﻿USE sofia;
DROP TABLE IF EXISTS sofia.nlg_vpl;
CREATE TABLE nlg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nlg_vpl WRITE;
INSERT INTO nlg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tana vuivuni mai dania God te gonia na kokou mana pari. ");
INSERT INTO nlg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tana bona keri, na maramana te kokoba me aroha, mana pungi te kuvihia na horara oka. Nina tarunga God te saopoa na horara. ");
INSERT INTO nlg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tana bona keri, God te bosa, “Ke mai na marara,” mana marara te tate. ");
INSERT INTO nlg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma God te righia na marara me nia togotogo. Ma gaia te vilivoka na marara tana pungi, ");
INSERT INTO nlg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ma God te vatua nia na marara “na Dani,” me vatua nia na pungi “na Bongi.” Na nulavi te tona mana puipungi te mai. Aeni gaia na diki bongi tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mi murina keri, God te bosa, “Lubatia siki totobo ke vilivokara na lei beti. ");
INSERT INTO nlg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Me ghaghua igaa. God te vokara na lei beti tana oka, mi rurughuna ghua. ");
INSERT INTO nlg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma God te vatua nia na totobo eni, “na Parako.” Na nulavi te tona mana puipungi te mai. Aeni gaia eruani na dani tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Keri ke, God te bosa, “Lubatighi na lei beti sarana na parako kara ghoroghoro kolu ta sakai na bona, ge tate mai na pari mamaha.” Me ghaghua igaa. ");
INSERT INTO nlg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma God te vatua nia na pari mamaha “na Paritina” mana beti te ghoro kolu mai te vatua nia “na Tahi.” Ma God te righia na hava te nea me nia togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Keri ge God te bosa, “Lubatia na paritina ke totolo igaa na lei vatavata ni buburu, mana lei ghai vangagha, mana lei ghai vunguvungugha te loghoa na vuavua. Mana lei vauvatu kara puputui na vatavata ni ghai tara pukulaghi mai gaa.” Me ghaghua iga. ");
INSERT INTO nlg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Mana paritina te vonughia na lei vata ni ghai. Mana vuavuadira te puputui na lei ghai vaghadira iga. Ma God te righia na hava te nea me nia togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Na nulavi te tona mana puipungi te mai. Aeni gaia e toluni na dani tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma God te bosa, “Lubatira rana marara sule ma kara tate mai tana oka, ma kara vilivokara na dani mana bongi. Raini na lei vaughilala, kara vokavokai na lei bonani, na lei dani, mana lei niulu. ");
INSERT INTO nlg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Lubatighi na lei marara ke marara horua na maramana.” Me ghaghua igaa. ");
INSERT INTO nlg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ma God te gonighi erua na bulu sule, na aho ke marara tana dani te sule, mana vula ke marara tana bongi. Me gonira ghua na lei veitughu. ");
INSERT INTO nlg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ma God te talura na bulu raini tana oka, ge kara mararaa na maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ge kara haba pungisia na dani mana bongi, ma kara vokaa na marara tana pungi. Ma God te righia na hava te nea me nia togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Na nulavi te tona mana puipungi te mai. Aeni gaia e vatini na dani tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma God te bosa, “Lubatia na lei beti ke vonughighi na lei igha mana na lei totobo vola, mana oka ke vonughia na lei manu kehakeha.” ");
INSERT INTO nlg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Keri ge God te gonighi na lei vata ni totobo vola tana tahi, sule mana pile, mana lei vata ni manu ghua. Ma God te righia na hava te nea me nia togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ma God te vautora me ghaghua, “Mi ghau rana lei totobo vola mana lei igha, kau sepalaghi ma kau vonughia na tahi. Mi ghau rana lei manu, kau sepalaghi ma kau vonughia na maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na nulavi te tona mana puipungi te mai. Aeni gaia e limani na dani tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma God te bosa, “Lubatia na maramana ke puputu mai ga na lei vata ni maumanu, tara pile mara sule, maia ghua na lei maumanu asi.” ");
INSERT INTO nlg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ma God te gonighi na lei vatavata ni maumanu, tara asi, tara dolo, mara tagutagu tana pari. Sopa gaira kara taonira sopa vinavahuhudira. Ma God te righia na hava te gonia me nia togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Keri ke, God te bosa, “Mai ghita ka gonia na tinoni tana mareda oli. Gaira kara vunaghini na lei totobo vola soko - na lei igha tana tahi, na lei manu tana oka, mana lei maumanu, sule mana pile, maia ghua na lei maumanu asi.” ");
INSERT INTO nlg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Keri ge God te gonira na lei tinoni, na mane mana vaivine, tana marena mi tana reireina heghena. ");
INSERT INTO nlg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma God te vautora me bosa vanira, “Kau sepalaghi ma kau vonughia na maramana, ma kau vatogha, ma kau haba pungisira na lei igha, mana lei manu, mana lei maumanu soko.” ");
INSERT INTO nlg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma God te bosa, “Kau righia! Inau tu vaheghau tua na lei ghai vavangagha te vuavuagha, mana lei ghai ghania tana maramana, na vatei vanga. ");
INSERT INTO nlg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mi nau tu vahera na lei buburu, mana balu ghai maumauri vanira na lei maumanu mana manu, na ghadira na vanga.” Me ghaghua igaa. ");
INSERT INTO nlg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma God te ghoi rei olighi na lei totobo te gonighi. Me vaevanei te uto ngangata tana lei levu soko. Na nulavi te tona mana puipungi te mai. Aeni gaia e ononi na dani tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Keri ke, mete goni sokoi tua na kokou mana pari, mana lei totobo soko igaa. ");
INSERT INTO nlg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mi tana vituni na dani, God te aheahe ilokana, te sokoi tua nina lei lutu. ");
INSERT INTO nlg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ma God te vautoa e vituni na dani, me vaa tabua na pukuna aeni na dani te aheahe iga me sokoi nina lei lutu. ");
INSERT INTO nlg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Aeni te ghaghua iga na goniana na kokou mana pari. Mi tana bona God, tara holoa nia Yahweh, te gonia na kokou mana pari, ");
INSERT INTO nlg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","me taho mua siki ghai pana vuavua ke totolo tana pari, na pukuna Yahweh God te mua nia vetena mai mua na uha. Me taho mua siki sakai igaa ke lutu tana pari. ");
INSERT INTO nlg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mete dato mai na beti vuvungana na pari, me bobona na pari. ");
INSERT INTO nlg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ma Yahweh God te gonia na tinoni, nia na pughu ni pari. Me aheahe savua nia na aheahe ni vola tana ihuna, mana tinoni te loghoa na vola. ");
INSERT INTO nlg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Keri ke Yahweh God te suba na leghai Eden iulu, me talua iga na mane te gonia. ");
INSERT INTO nlg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma Yahweh God te subai na lei vata ni ghai tana leghai - te ghaugharugha, mana vangani te manilu. Mi ghobuna na leghai te talua na ghai ni vola, mana ghai ni manahana na uto mana dika. ");
INSERT INTO nlg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Na betitina te tave horu tana leghai Eden, me ke vulia na leghai, me vokai gaa e vati na base ni beti tina. ");
INSERT INTO nlg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sakai tadira na base i Pishon, te tave talighutia na butonikomu i Havilah, te ghaha iga na gold. ");
INSERT INTO nlg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na gold keri te uto me marabu. Mi ga ko topoa ghua na vatu utoutoa na ahana onyx, mara loghoa na ghaiuruuru tara holoa nia bdellium. ");
INSERT INTO nlg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na ruani na basena i Gihon, te tave talighutia na butonikomu i Cush. ");
INSERT INTO nlg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na toluni na basena Tigris, te tave talighutia ilevu uluna Asshur. Me vatini na basena Euphrates. ");
INSERT INTO nlg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ma Yahweh God te talua na tinoni tana leghai Eden, ge ke vatoghaa. ");
INSERT INTO nlg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma Yahweh God te talua vania na bosa pungisi, “Ko tangomana so na ghaniani na lei vuavuani na lei ghai tana leghai eni. ");
INSERT INTO nlg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hauva, mo ko bei ghania gea na vangana na ghai ni manahana na uto mana dika. Ke vagha ko ghania na vavangana ke, tana bongi keri ko mate.” ");
INSERT INTO nlg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Keri ke, Yahweh God te bosa, “E mua uto ge ke ghana heghena na mane. Inau ku gonia na dolana te ulaghana ge ke hangaa. ");
INSERT INTO nlg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Keri ge Yahweh God te gonighi na lei vata ni maumanu mana manu, nia na pari. Me holara vania mai na mane ge ke talu ahadira. Mana mane te vatuahana sasakai tadira. ");
INSERT INTO nlg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Keri ke na mane te talu ahadira na lei maumanu dolo, mana lei manu soko, mana maumanu asi ghua. Hauva me mua sodoa na dolana te ulaghana ke kabu kolua me ke hangaa. ");
INSERT INTO nlg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Keri ge Yahweh God te nea Adam me maturu mate, me sipa keha sakai na huli kakasana, me mavo olia na bona te lavikeha iga. ");
INSERT INTO nlg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma Yahweh God te gonia na vaivine nia na huli kakasana na mane, me lavia vania mai. ");
INSERT INTO nlg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Keri ge na mane te bosa, “Itaeni, gaia na pilena na puku ni huligu mana vinahigu. Mu ku vatua nia na vaivine, na pukuna God te lavi horua mai tana mane. ");
INSERT INTO nlg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aeni te tughunitatea ge na mane ke sania tamana ma tinana, me ke sonikolu ta tauna, ma rogaira toro sakai vamua tana matana God. ");
INSERT INTO nlg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Sakai vamua na mane ma tauna toro sopa soesole, moro mua mamahaaghi. ");
INSERT INTO nlg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mana poli te gueguelo au vulera na lei vata ni maumanu soko Yahweh God te gonira. Na poli te huatia na vaivine, “?E bosa utunia sughua God, ko bei ghania gea siki vuavua tana leghai eni?” ");
INSERT INTO nlg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Na vaivine te bosa tughu vania, “Taho! Koro tangomana so na ghaniani na vavanga tana siki ghai tana leghai, ");
INSERT INTO nlg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","hauva ma gaia vamua na vavangana na ghai ghobuna na leghai, God te mua lubatighai na ghaniana po koro tabea. Ke vagha koro gonia te vagha ke, koro mate!” ");
INSERT INTO nlg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na poli te bosa, “Koro mua mate! ");
INSERT INTO nlg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God te ghilala ke vagha koro ghania, na matamiu ke davora mo koro manaha. Vaho ge koro vagha God, mo koro ghilalai na lei totobo soko, tara uto mana dika.” ");
INSERT INTO nlg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mi tana bona na vaivine te righia na reireina na vavanga te ghaugharugha, me manilu ge ke ghania ke, ma gaia te nia gharu ge ke manaha, kakeri tea ge ghanighi balu na vavanga. Me vahea na balu vavanga a tauna te kabukolua, ma gaia ghua te vanga. ");
INSERT INTO nlg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Me mina vaso, na matadira te davora, ge ro ghilala toro soesole, moro maa. Keri ge rogaira toro tura kolui na raurauna na ghai tara holoa nia na fig moro nighi sagova, ge koro sarora nia. ");
INSERT INTO nlg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Te dutu tua na nulavi, rogaira toro rongovia Yahweh God te sakusakutua tana leghai. Ma rogaira toro polo i ghobuni na lei ghai. ");
INSERT INTO nlg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma Yahweh God te holoa na mane, me ghaghua, “?Ivei ighoe?” ");
INSERT INTO nlg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mete bosa tughu, “Inau tu rongovigho, mu polo na pukuna tu soesole.” ");
INSERT INTO nlg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ma Yahweh God te huatia, “?Ahei te bosaa vanigho to soesole? ?Vaghi so o ghania na vuavua tu hovegho nia na ghaniana?” ");
INSERT INTO nlg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Na mane te bosa tughu, “Na vaivine eni to vaheu ge ke kabukoluu, te hola mai vaniu na vuavua, ge u ghania.” ");
INSERT INTO nlg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Keri ke, Yahweh God te huatia na vaivine, “?Na hava to ghua ge o nea te vagha eni?” Na vaivine te bosa vania, “Na poli te pegou, mana pukuna keri ge u ghania.” ");
INSERT INTO nlg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Keri ge Yahweh God te bosa vania na poli, “Na pukuna to nea te vagha eni, inau ku torogho. Ighoe itadira na lei maumanu kukuti mana maumanu asi tana maramana udolu ku varangagho. Tana lei bongi ni volamu, ko nia tagu na kutumu tana pari. ");
INSERT INTO nlg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Te vuivuni taeni, inau ku neghau, ighoe mana vaivine, koro kanahaghi. Mana vaivarimu ighoe mana vaivarina gaia ghua kara kanahaghi. Na vaivarina gaia ke turi horua na ulumu, mi ghoe ko ghalatia na guruvatuna na tuana. ");
INSERT INTO nlg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ma God te ghaghua vania na vaivine, “Ighoe ko vahaghitaili ngangata tana bona ko vahuhu gari. Hauva ko ghanaghana mava na taumu, ma gaia ke vunaghi pungisigho.” ");
INSERT INTO nlg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Vaho ge God te bosa vania na mane, “Na pukuna to rongovi taonia na taumu, ge o ghania na vuavua ni ghai tu bosa vanigho ko bei ghania, inau ku torogho mu ku talua na vavaranga vanigho tana pari. Tana lei bongi ni volamu udolu, ighoe ko lutu papara mo ko vahaghitaili ge ko sodoa iga na kaukabumu. ");
INSERT INTO nlg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ke totolo dato mai iga na kaukaru mana ghaulahi liva ke pungisigho. Hauva, ko ghanighi na vavanga te totolo dato tana pari. ");
INSERT INTO nlg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tana volamu udolu ighoe ko vivikino ge ko loghoa na vanga, polo ke sara na dani ni mateamu. Mi ghoe ko ghoi oli tana pari to vuha mai gaa. Ighoe to vuha mai tana pughu ni pari, mi tana pughu ni pari ko ghoi oli gaa.” ");
INSERT INTO nlg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ma Adam na mane, te vatua nia Eve na tauna, na pukuna gaia ke tinadira na lei tinoni soko. ");
INSERT INTO nlg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma Yahweh God te pupulura Adam maia tauna nia lei vata ghuighuli ni maumanu. ");
INSERT INTO nlg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ma Yahweh God te bosa, “Itaeni, na tinoni raini tara vaghaghita, mara ghilalai na lei totobo te uto mete dika. Ighita ka mua lubatira ge koro ghania na vuavuana na ghai ni vola, ge koro vola kasila!” ");
INSERT INTO nlg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Keri ge Yahweh God te tivakehara Adam mana tauna tana leghai Eden, ge koro lutu tana pari, te vuha mai gaa Adam. ");
INSERT INTO nlg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Murina te tivakehara tana leghai, ma Yahweh God te talura na lei angel tara holora nia cherubim ilevu uluna Eden, mana isi te ruruhu me ririu kolili, te vatoghaa na halautuna na ghai ni vola. ");
INSERT INTO nlg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ma Adam te maturu kolua tauna Eve, me logho gari. Mete sara tua na bona, gaia te vahua na garimane me ghaghua, “A Yahweh te hangau, inau tu loghoa na garimane.” Keri ke gaia te vatua nia Cain. ");
INSERT INTO nlg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mi murina mai, gaia te vahua ruani na dalena, na ahana Abel. Tana bona toro sule dato, Abel te righitaoni sheep, ma Cain te lutu tana leghai. ");
INSERT INTO nlg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tana sakai na bongi, Cain te lavia vania mai Yahweh nina lavi ni vogha ta nina leghai. ");
INSERT INTO nlg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Abel te lavira mai vania Yahweh na balu kamanagho dale sheep marabu te vilighi ta nina ovu ni sheep tara korukoru, me nighi sukaghi. Ma Yahweh te holopangotia Abel ma nina sukaghi. ");
INSERT INTO nlg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Hauva ma gaia te mua holopangotia Cain ma nina heveilee. Na pukuna keri, Cain te rutu ngangata me loghoa na lio dika. ");
INSERT INTO nlg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ma Yahweh te huatia, “?Na hava te ghua ge o rutu, me ghua ge o loghoa na lio dika? ");
INSERT INTO nlg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ke vagha ko gehegehe maemane ke, geva ku lavipangotigho. Me ke vagha ko hove na gehegehe maemane ke, ko righitaonigho na pukuna na palu te gonidila ge ke taghalaghinigho me ke durakegho, hauva mo ko tughuru pungisia. ");
INSERT INTO nlg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mi geva Cain te padapada vania tahina Abel, “Roghita koro rughuhoru va tana nanagu.” Mi tana bona koro ghahara iga, Cain te soghavia me matea na tahina. ");
INSERT INTO nlg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mi murina keri, Yahweh te huatia Cain, “?Ivei gaia Abel, na tahimu?” Ma Cain te bosa tughu, “U mua ghilala inau! ?To ghanaghana inau ge ku righitaonia na tahigu?” ");
INSERT INTO nlg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma Yahweh te bosa tughu, “?Na hava na pukuna ge o gonia na totobo dika eni? Ko rongovia, na ghabuna tahimu te ngangaraha dato vaniu mai tana pari. ");
INSERT INTO nlg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na pukuna to matea na tahimu mo nea na ghabuna te tave tana pari ke, inau ku tivakehagho tana pari mu ku varangagho ge ke mua totolo dato siki vuavua ko subaa. ");
INSERT INTO nlg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sakai vamua ko lutu laga, ke mua tangomana na hali vanigho na vanga. Te vuivuni taeni ke taho na komumu, mo ko ole kolili vamua tana maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Cain te bosa tughu vania Yahweh, “Nigua na totoro te sule vuleu na vadangitailiana. ");
INSERT INTO nlg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Itaeni, ighoe to tivakehau tana bonagu, maia tana matamu. To neu mu ghogho kolili tana maramana, ma siki sakai ke righi sodou ke labumateu.” ");
INSERT INTO nlg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma Yahweh te bosatughu, “Taho! Bei mataghu, na pukuna ke vagha siki sakai ke mategho ke, inau ku vahea e vitu na totoro ahei ke nea.” Ma Yahweh te talua na vaughilala itatana Cain, ge ke siki sakai te righi sodoa, ge ke bei matea. ");
INSERT INTO nlg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Vaho ge tona keha Cain tana matana Yahweh. Me vaa kabu tana butonikomu Nod ilevu uluna Eden. ");
INSERT INTO nlg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Balu bongi te murina, Cain te maturu kolua tauna. Ma tauna te logho gari, me vahua na garimane, mara vatua nia na ahana Enoch. Tana bona Cain te kisua na komu sule, me holoa nia Enoch na mavuna na dalena. ");
INSERT INTO nlg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch na tamana Irad. Irad na tamana Mehujael. Mehujael na tamana Methushael. Methushael tamana Lamech. ");
INSERT INTO nlg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ma Lamech te taudira rua na vaivine, Adah ma Zillah. ");
INSERT INTO nlg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah te vahua na garimane na ahana Jabal. Gaia na vuivuni tinoni te righi taonighi na volivoli ni maumanu, mete ghahaa tana vale tapole. ");
INSERT INTO nlg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na ahana tahina, Jabal, na vuivuni tinoni kage linge te gonighi na kolove mana uvete. ");
INSERT INTO nlg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Me ruani na tauna Lamech, Zillah te vahua na garimane, na ahana Tubal-Cain. Agaia na vuivuni tinoni te gonighi na lei totobo nia na halo mana kava. Tubal-Cain na vaivinena tara vatua nia Naamah. ");
INSERT INTO nlg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma sakai na dani, Lamech te bosa vanira erua na tauna, “Adah ma Zillah, roghau taugu, Koro rongoviu mai! Inau tu matea na tinoni te labuu, Eo, inau tu matea na garimane te niu ge u bubutou. ");
INSERT INTO nlg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Siki sakai ke labumatea Cain ke, gaia ke lavia ra vitu na tughuru ni lavitughu. Keri ke, siki sakai ke niu lavitughu inau ke, gaia ke lavia ra vitu hangavulu vitu na tughuru ni lavitughu.” ");
INSERT INTO nlg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ma Adam te ghoi maturu kolua tauna, me vahua sakai dalena mane. Gaia te bosa, “God te vaheu toluni na gari te tughua nia Abel, na pukuna Cain te matea.” Keri ke, me vatua nia Seth. ");
INSERT INTO nlg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ma Seth te sule dato, me loghoa na dalena me vatua nia Enosh. Mi tana lei bongi ni volana rana vure tara vuivuni ni holohabaana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aeni na vavatana mana vinavahuhuna Adam. Tana bona God te gonia na tinoni, gaia te goni taonira tana marena. ");
INSERT INTO nlg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gaia te gonira na mane mana vaivine, me vautora me holora nia na “Tinoni”. ");
INSERT INTO nlg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tana bona Adam te sakai hangalatu tolu hangavulu (130) na niuluna me vahua na dalena Seth. Ma Seth te vagha lolotoa tua na reireina tamana. ");
INSERT INTO nlg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Mi murina te vahua tua Seth, Adam te saravia tua alu hangalatu (800) na niuluna, me ghoi loghora na balu dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Me poso tua tana hiua hangalatu tolu hangavulu (930) na niuluna gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tana bona Seth te sakai hangalatu lima (105) na niuluna, me vahua na dalena na mane, a Enosh. ");
INSERT INTO nlg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Mi murina na vahuana Enosh, Seth te poso tua tana alu hangalatu vitu (807) na niulu, me ghoi loghora balu dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mana niuluna te saravia ra hiua hangalatu hangavulu erua (912) gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tana bona Enosh te hiua hangavulu (90) na niuluna, me vahua na dalena na mane, a Kenan. ");
INSERT INTO nlg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mi murina tua te vahua Kenan, Enosh te poso tua tana alu hangalatu hangavulu lima (815) na niuluna me ghoi vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mana niuluna te saravia hiua hangalatu lima (905) na niulu, gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tana bona Kenan te vitu hangavulu (70) na niuluna, me vahua na dalena na mane, a Mahalalel. ");
INSERT INTO nlg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Murina na vahuana Mahalalel, Kenan te saravia ra alu hangalatu vati hangavulu (840) na niuluna, me ghoi vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mana niuluna te saravia ra hiua hangalatu sakai hangavulu (910), gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tana bona Mahalalel ta sara tua ono hangavulu lima (65) na niuluna, me vahua na dalena na mane, a Jared. ");
INSERT INTO nlg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mi murina na vahuana Jared, Mahalalel te saravia ra alu hangalatu tolu hangavulu (830) na niuluna. Me ghoi vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mana niuluna te saravia alu hangalatu hiua hangavulu lima (895), gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tana bona Jared te saravia sakai hangalatu ono hangavulu rua (162) na niuluna me vahua na dalena na mane, a Enoch. ");
INSERT INTO nlg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mi murina tua na vahuana Enoch, Jared te saravia alu hangalatu (800) na niuluna, me vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mana niuluna te saravia hiua hangalatu ono hangavulu rua (962) gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tana bona Enoch te ono hangavulu lima (65) na niuluna, me vahua na dalena na mane, a Methuselah. ");
INSERT INTO nlg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mi murina na vahuana Methuselah, Enoch te saravia so tolu hangalatu (300) na niuluna, me nia sakaisonikolu God. Me ghoi vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ma Enoch te ghaha tolu hangalatu ono hangavulu lima (365) na niulu. ");
INSERT INTO nlg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Mi tana lei bongi ni volana, God te nia togotogo te sakaisonikolu itatana. Ma sakai na bongi, Enoch te tovongo taghaa, na pukuna God te lavi kehaa ge ke kabu kolua. ");
INSERT INTO nlg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tana bona Methuselah te saravia tua sakai hangalatu alu hangavulu vitu (187) na niulu, me sivuragha na dalena na mane, a Lamech. ");
INSERT INTO nlg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mi murina tara vahua tua Lamech, Methuselah te ghaha 782 na niulu, me sivuraghara na lei dalena na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mana na niuluna te saravia hiua hangalatu ono hangavulu hiua (969), gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tana bona Lamech te sakai hangalatu alu hangavulu rua (182) na niuluna, me sivuragha na dalena na mane. ");
INSERT INTO nlg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ma Lamech te ghaghua, “Na dalegu eni ke vaheghita na malumu ta dida na lutu papara, tana pari a Yahweh te varangaa.” Keri ge gaia te vatua nia na dalena, a Noah. ");
INSERT INTO nlg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mi murina tua tara vahua Noah, Lamech te ghaha lima hangalatu hiua hangavulu lima (595) na niuluna, me ghoi vahura na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mana niuluna te saravia vitu hangalatu vitu hangavulu vitu (777), gaia te mate. ");
INSERT INTO nlg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mi murina Noah te saravia lima hangalatu (500) na niulu, me sivuraghara ra tolu dalena na mane - Shem, Ham, ma Japheth. ");
INSERT INTO nlg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mi tana bona na lei tinoni tara mina mara totolo, mara sepalaghi tana maramana, mara suvuraghara mara subo na lei vaivine, ");
INSERT INTO nlg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","na lei dalena na mane God tara vaevanera na lei vaivine matakage tana lei vata ni tinoni raini. Mara liona na taulaghi itadira, ge ra lavira rahei tara liona. ");
INSERT INTO nlg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Keri ge Yahweh te bosa, “Tu mua lubatia na tarungagu, te vahera na vola, ke kabu kolura na lei tinoni ke va me vaa, na pukuna gaira na tinoni vamua. Te vuivuni taeni, gaira kara ghahara ke mua vulea sakai hangalatu rua hangavulu (120) na niuludira.” ");
INSERT INTO nlg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tana lei bongi kiri, mi murina ghua, na lei mumutabu, tara holora nira “Nephilim,” kara ghahara tana maramana. Raini na vaivaridira rana lei dalena God tara taudira na lei tinoni vaivine. Gaira na lei malaghai laga ta rongovira tana lei tutugu haulaghi. ");
INSERT INTO nlg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ma Yahweh te righia didira na tangohahi na lei tinoni, mana ghanaghanadira te tangohahi talau. ");
INSERT INTO nlg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ma Yahweh te dikalio sule me rusu na tobana, na pukuna gaia te gonira rana vure tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Keri ke, Yahweh te bosa, “Inau ku taghalaghi ni sokora na lei tinoni tu gonira. Eo, mi nau ku taghalaghinira na lei maumanu mana lei manu ghua. Mi nau tu dikalio sule ngangata na pukuna tu gonira.” ");
INSERT INTO nlg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hauva, Yahweh te righi togotogoa Noah. ");
INSERT INTO nlg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Aeni na vuivuni ni tutuguna Noah ma nina binaboli. Noah na tinoni maemane mete uto ngangata. Taho siki sakai te vola tana bongina ke bosaa siki huruhuru vania, na pukuna Noah te taonia God, me sakai sonikolu itatana. ");
INSERT INTO nlg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah te loghora ra tolu na dalena - Shem, Ham ma Japheth. ");
INSERT INTO nlg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hauva, na lei tinoni keha tana maramana tara liliu ni dika tana matana God. Gaira te vonughira na liodika mana veilaulabui. ");
INSERT INTO nlg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ma God te dikalio ngangata tana bona te vatogha na maramana, na pukuna rana vure tara gonighi na lei totobo dika haia. ");
INSERT INTO nlg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Keri ge God te bosa vania Noah, “Inau tu liona na taghalaghiniana na lei totobo vola tana maramana, na pukuna na maramana te saopoa tua na dika nia raini. Eo, ku durake sokora tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Saria na vaka ke vanigho ighoe ma nimua na binaboli, nia na ghai te ngasi. Ko gonighi na lei voki lokana, mo ko tita na vaka ilokana mana murina. ");
INSERT INTO nlg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mo ko gonia ke vagha na darona vitu hangavulu lima (75) na ghoto, mana volapana ke, hangavulu rua mana levu (12.5) ni ghoto, mana datona ke, vitu mana levu (7.5) ni ghoto. ");
INSERT INTO nlg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ko gonighi na vouvotuna na vaka, mo ko nea sakai na louloghu ni lima na datona ighobu. Mo ko talui ra tolu na lavata i lokana na vaka, sakai pari ke, me ruani tana ghobuna me toluni ikoukou, mo ko talua na mataula tana sakai na levuna na vaka. ");
INSERT INTO nlg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mo ko rongo uto mai! Inau ku saopoa nia na lualua na maramana udolu, me ke taghalaghinighi na lei totobo vola soko. Eo, na lei totobo vola soko tana maramana kara mate. ");
INSERT INTO nlg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Hauva, mi nau ku gonia nigua na baubahu itamua, ighoe mana taumu, mana lei dalemu mana taudira, kau haghe tana vaka, ge kau vola. ");
INSERT INTO nlg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mo ko lavira mai ghua tana vaka sopa rua na lei vata ni totobo vola, mane mana vaivine, ge kara kabu ma kara vola kolugho. ");
INSERT INTO nlg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Eo, erua na lei vata ni manu, mana lei maumanu sule mana pile kara mai tamua, ge kara vola. ");
INSERT INTO nlg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mo ko lavighi na lei vata ni vanga tana vaka vanigho ighoe ma nimua na binaboli mana lei maumanu mana lei manu. ");
INSERT INTO nlg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma Noah te goni soko na lei totobo God te vetena nia. ");
INSERT INTO nlg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Keri ke a Yahweh te bosa vania Noah, “Ko vaa haghe tana vaka, ighoe ma nimua na binaboli udolu, na pukuna itadira na lei vure soko tana maramana, ighoe heghemu vamua to maemane tana matagu. ");
INSERT INTO nlg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ko lavira sopa ruarua tana vitu na ovu na lei maumanu tu talamaghinia na ghaniani mana nighi sukaghi, mo ko lavia sakai tadira tara keha, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mo ko vilira ghua sopa ruarua tana vitu na ovu na lei vata ni manu. Eo, na mane mana vaivine tadira na lei vata ni maumanu mana lei manu soko, ge kara vola tana lualua. ");
INSERT INTO nlg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","E vitu vamua na dani itaeni, mi nau ku vuivunia na horulaghiniana na uha lokani e vati hangavulu na dani me vati hangavulu na bongi. Mu ku taghalaghinira na lei totobo vola soko tu gonira tana maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma Noah te goni taonia na hava Yahweh te vetena nia. ");
INSERT INTO nlg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah te saravia ono hangalatu (600) na niuluna tana bona te sara mai na lualua. ");
INSERT INTO nlg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Agaia ma tauna, ma dalena na mane mana lei taudira tara haghe tana vaka ge kara vola tana lualua. ");
INSERT INTO nlg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Gaira udolu kolura na lei vata ni maumanu, God te taladira na ghaniadira mana nira sukaghi, ma gaira kara mua nira sukaghi ghua itadira, kolura na lei manu. ");
INSERT INTO nlg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ma gaira tara mai tana vaka rua me rua, na mane mana vaivine, te vagha God te vetenaa nia tua Noah. ");
INSERT INTO nlg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Murina e vitu na dani na lualua te sara mai, me vuivuni na saopoana na maramana udolu. ");
INSERT INTO nlg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tana bona Noah te ono hangalatu (600) na niuluna, tana hangavulu vituni na dani tana ruani na vula, na beti sarana na pari te vuravura dato mai tana maramana, mana uha te horu binoru mai tana parako. ");
INSERT INTO nlg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mana uha te tona haliu so lokani vati hangavulu na dani me vati hangavulu na bongi. ");
INSERT INTO nlg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na dani vaghana keri, Noah te vaa haghe tana vaka kolura tauna ma daledira, Shem, Ham, ma Japheth maira na lei taudira. ");
INSERT INTO nlg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Gaira kolura tana vaka sopa vatavata ni maumanu vola, dolo mana asi, sule mana pile, kolura ghua na lei manu. ");
INSERT INTO nlg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ma gaira tara haghe tana vaka rua me rua, ");
INSERT INTO nlg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","na mane mana vaivine taonia nina vevetena God. Ma Yahweh te vongotia na matauluadira. ");
INSERT INTO nlg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mi tana vati hangavuluni na bongi na lualua te sule, me saopoa na pari udolu, me ghate datoa na vaka me leleboa. ");
INSERT INTO nlg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mi tana bona na beti te vonu dato me vulea na pari, na vaka te lelebo uto tana vuvunga ni beti. ");
INSERT INTO nlg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mi tana sosoko, na beti te saopoi na lei ghotu datogha tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Me dato vulei na ghotu datogha te kaekage vati na ghoto. ");
INSERT INTO nlg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Keri ke, na lei totobo soko tana maramana tara mate, na lei manu, na lei maumanu dolo maia tara asi, mana lei vatavata ni tautagu, mana lei tinoni ghua. ");
INSERT INTO nlg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mana lei totobo vola tara loghoa na aheahe tara ghahara tana pari mamaha tara mate ghua. ");
INSERT INTO nlg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Eo, na lei totobo vola tana maramana, God te taghalaghinira gaira udolu, na lei tinoni, mana lei maumanu sule mana pile, mana lei manu. Ma gaia Noah vamua te ghaha olia te vola, kolura gaira tara haghe kolua tana vaka. ");
INSERT INTO nlg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mana beti te saopo udolua na maramana ilokana sakai hangalatu lima hangavulu (150) na bongi udolu. ");
INSERT INTO nlg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma God te ghanaghana olia Noah mana maumanu ilokana na vaka. God te nia vetena na ghuri ge ke ghurihia na beti, mana lualua te vuivuni na kabulaghi horu. ");
INSERT INTO nlg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Na beti boroni pari te beto na vuravura me sosopi pulohi tana malana, mana uha sule te beto tesakai tua. ");
INSERT INTO nlg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mana lualua te kabulaghi horu me sosopi. Mi murina sakai hangalatu limi hangavulu (150) na bongi, ");
INSERT INTO nlg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","tana hangavulu vituni na dani tana vituni na vula, mana vaka te mai sopou tua tana ghotu tana bubulo i Ararat. ");
INSERT INTO nlg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Me te tona haliu so na sosopi horu na beti, mi tana vuivuni ni bongi tana hangavuluni na vula, mana kouni na ghotu sule te vuivuni ni tate. ");
INSERT INTO nlg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mi murina vati hangavulu na bongi, Noah te hangavia na matakenena na vaka te gonia, ");
INSERT INTO nlg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","me nia vetena na manu bili, tara holoa nia “raven”, me lovo kolili polo ke mamaha na maramana. ");
INSERT INTO nlg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mete ghoi nia vetena rughuhoru so na bola ke righia ke tangomana na kene sodoana na pari mamaha. ");
INSERT INTO nlg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mana bola te mua topo malana ge ke tegha, na pukuna na beti te vonu dato mua tana pari. Keri ge gaia te ghoi oli so tana vaka, ma Noah te nia hagalo horu na limana me tegha igaa na bola, ge lavi oli haghea. ");
INSERT INTO nlg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Me padi tua vituni na dani, Noah te ghoi nia vetena so na bola. ");
INSERT INTO nlg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tana dani vaghana keri, te dutu tua na nulavi, na bola te nia oli kolu vania mai na raurau ni olive tana mangana. Ma Noah te ghilala te dutu tua na sosopi soko na beti. ");
INSERT INTO nlg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Me padi tua e vitu na dani, gaia te ghoi nia vetena so na bola, mana dani vaghana keri gaia te mua pulohi mai tua. ");
INSERT INTO nlg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mi tana bona Noah te ono hangalatu sakai (601) na niuluna, ta sakai na dani tana vuivuni ni vula, Noah te ghae datoa na vovongo ni vaka, me vaevane horu, mana beti te dutu mamaha tua. ");
INSERT INTO nlg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mi tana erua hangavulu vitu na bongi tana ruani na vula, na maramana te mamaha udolu. ");
INSERT INTO nlg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ma God te bosa vania Noah, ");
INSERT INTO nlg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ko sania igaa na vaka, ighoe mana taumu mana dalemu mana taudira. ");
INSERT INTO nlg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ko taluhorura na lei maumanu mana manu ge gaira kara vahuhu ma kara sepalaghi tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Keri ge Noah, ma tauna, maira rana daledira mana taudira tara sania na vaka. ");
INSERT INTO nlg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mana lei vatavata ni maumanu mana manu tara horu mai tana vaka rua me rua. ");
INSERT INTO nlg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ma Noah te kisua nina vatei sukaghi kekere vania Yahweh. Me sukaghighi gaa na lei maumanu mana manu mana hava te talamaghinia ge kara nia sukaghi vania. ");
INSERT INTO nlg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma Yahweh te holopangotia na sukaghi me bosa vania heghena, “Inau ku mua ghoi varangaa tua na maramana, mana dikaladira na lei totobo vola soko, sakai mana na ghanaghana ni tinoni mana gehegehena ke dika vuivuni mai tana garipileadira. ");
INSERT INTO nlg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tana bona ke ghaha na maramana, ke mua mautu na bona ni vade mana baobaore, na uha pana hina, na bihi pana papara, na dani pana bongi.” ");
INSERT INTO nlg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God te vautoa Noah mana lei dalena me bosa vanira, “Kau vahuhu me ke subo na dalemiu ge kau sepalaghi ma kau vonughia na maramana. ");
INSERT INTO nlg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Na lei maumanu asi, na sule mana pile, mana lei manu mana igha, kara mataghunighau. Ighau kau vunaghi pungisira. ");
INSERT INTO nlg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Itaeni, inau tu heghau na lei totobo rakiri na ghamiu na vanga, te vaghaa tu vaheghau tua te padi na vuavua ni ghai mana raurau maumauri ge ke ghamiu na vanga. ");
INSERT INTO nlg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hauva, ma kau bei ghania na vinahi te ghabugha, na pukuna na volana ilokana na ghabuna. ");
INSERT INTO nlg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma ge siki sakai ke labumate tinoni ke, gaia ke lavia mughua na totoro. Na lei maumanu tara mate tinoni kau matera, ma hei ghua te labumate tinoni kau matea. ");
INSERT INTO nlg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Eo, Ahei ke labumatea na tinoni ke, Gaia kau labumatea mughua, na pukuna inau tu gonira na lei tinoni taonia na maregu. ");
INSERT INTO nlg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mi ghau kau vahura subo na gari, keri ge gaira maia na lei vaivaridira kara sepalaghi, ma kara vonughia na maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Keri ke, God te bosa vania Noah mana lei dalena, ");
INSERT INTO nlg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Inau ku tughuru vaghinia nigua na baubahu itamiu mana lei vaivarimiu, ");
INSERT INTO nlg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","mana lei totobo vola tara sania na vaka kolughau, na lei manu mana maumanu dolo mara asi. ");
INSERT INTO nlg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mi nau tu baubahu ku mua ghoi nia vetena mai na lualua ge ke matera lei totobo vola soko, me ke dikala na maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Keri ge, God te bosa, “Inau ku vaheghau na vaughilala ge kau ghilala utoa inau ku ngasilia na baubahu mava vanighau, ighau mana lei totobo vola tana maramana, ke va me va. ");
INSERT INTO nlg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Inau ku talua na kove tana parako. Aeni nigua na vaughilala ni baubahu eni vanighau ma vania na maramana. ");
INSERT INTO nlg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tana bona ku nia vetena na ghobaghuli mana uha tana maramana, mana kove ke tate tana parako, ");
INSERT INTO nlg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mi nau ku ghanaghana olia nigua na baubahu vanighau ma vanira na lei totobo vola soko, ge na lualua ge ke mua ghoi taghalaghinira na lei totobo vola udolu. ");
INSERT INTO nlg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Eo, tana bona inau ku righia na kove tana ghobaghuli, mu ghanaghana olia nigua baubahu kasila vanira na lei totobo vola udolu tana maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Vaho ge God te bosa vania Noah, “Na kove na vaughilala ta nigua na baubahu, itadira na lei totobo vola soko tana maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Shem, Ham, ma Japheth, ra tolu dalena Noah, tara sania na vaka kolua tamadira. (Ma Ham na tamana Canaan). ");
INSERT INTO nlg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Na lei tinoni tara saopoa na maramana tara vaivaridira ra tolu dalena Noah. ");
INSERT INTO nlg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Me padi tua na lualua, Noah na tinoni lutu tana leghai me subaa na leghai ni grape. ");
INSERT INTO nlg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mi ta sakai na dani, gaia te inuvia na wine te gonia, me bule me koli soesole ta nina vale tapole. ");
INSERT INTO nlg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ma Ham tamana Canaan, te vaevanea tamana te soesole ge rughuhoru me tutugu vanira hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Keri ge, Shem ma Japheth toro lavia na tivi, ro talua tana valadira, moro sakutua hugha vaa tana vale tapole, ge ro saroa tamadira te soesole. Ro nea te vagha eni, rogaira toro rei keha ge ro mua righia na tamadira te soesole. ");
INSERT INTO nlg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tana bona Noah te rarai murina te inu bulebule, me ghilala na hava te nea Ham na dalena na sosoko, ");
INSERT INTO nlg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","gaia te bosaa, “Inau tu varanga Canaan mana lei vaivarina. Gaira kara kubolu horu ma kara seka tana vaivaridira Shem ma Japheth.” ");
INSERT INTO nlg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma Noah te bosa ghua, “Holohabaa Yahweh, na God a Shem te nia kikinima! Ma rana vaivarina Canaan kara seka tana lei vaivarina Shem. ");
INSERT INTO nlg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Inau tu nongia God ke volapaa na bonana Japheth, ge ke lubatira na vaivarina Japheth ge kara kabu mabo kolua na vaivarina Shem. Me nera rana vaivarina Canaan ge kara seka vanira na vaivarina Japheth.” ");
INSERT INTO nlg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ma Noah te vola tolu hangalatu lima hangavulu (350) na niulu murina na lualua. ");
INSERT INTO nlg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Na niuluna te sara hiua hangalatu lima hangavulu (950), vaho ge mate. ");
INSERT INTO nlg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Aeni na vaivaridira Shem, Ham, ma Japheth, ra tolu dalena Noah. Gaira tara vahura subo ni gari murina na lualua. ");
INSERT INTO nlg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","A Japheth na tamadira Gomer, Magog, Madai, Javan, Tubal, Meshech, ma Tiras. ");
INSERT INTO nlg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A Gomer na tamadira Ashkenaz, Riphath, ma Togarmah. ");
INSERT INTO nlg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A Javan na tamadira Elishah, Tarshish, Kittim ma Rodanim. ");
INSERT INTO nlg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Rana vavatadira na tinoni rakeri tara va butu mai lilighina na tahi, mi tana lei koukomu, na sopa kema kara leui sopa leudira, mara ghahara tana sopa bubulo. ");
INSERT INTO nlg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham na tamadira Cush, Mizraim, Put, ma Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cush na tamadira Sheba, Havilah, Sabtah, Raamah ma Sabteca. Ma Raamah na tamadira Sheba ma Dedan. ");
INSERT INTO nlg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush te vahua ghua Nimrod, gaia te mai diki malaghai nagho tana maramana. ");
INSERT INTO nlg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nia nina hahanga Yahweh, gaia te puku ni tinoni hili maumanu. Mana ahana te nia rongoragha, keri ke rana vure tara bosa vania siki sakai, “Yahweh ke hangagho ge ko puku ni tinoni hili maumanu te vagha Nimrod.” ");
INSERT INTO nlg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod te vuivunia na vunaghi pungisiana tana butonikomu Shinar, kolura na komu sule i Babel, Erech, Accad, mi Calneh. ");
INSERT INTO nlg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mi kakeri te ghoi ghadaru va tana bubulo i Assyria, mi kakeri te kisua me tughuru vaghinia Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO nlg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mi Resen, te ghaha ighobudira Nineveh mi Calah, na komu sule. ");
INSERT INTO nlg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ma Mizraim na vaivaridira na kemana Lud, na kemana Anam, kemana Lehab, kemana Naphtuh, ");
INSERT INTO nlg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","kemana Pathrus, kemana Casluh, maia ghua kemana Caphtor, tara va mai gaa rana vure ni Philistia. ");
INSERT INTO nlg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan na tamadira Sidon, na kamanagho, maia Heth. ");
INSERT INTO nlg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ma Canaan na vaivaridira na kemana Jebus, kemana Amor, kemana Girgash, ");
INSERT INTO nlg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","kemana Hivi, kemana Ark, kemana Sin, ");
INSERT INTO nlg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","kemana Arvad, kemana Zemar, mi kemana Hamath. Igeva na lei vaivaridira Canaan tara saopoa tana bona ni pari sule. ");
INSERT INTO nlg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tana vovokana na bonadira rana vaivaridira Canaan tara tuvavoka i Sidon vaa i Gaza tana saravahale, mi longa i Gerar, mi levu uluna vaa i Sodom, Gomorrah, Admah, mi Zeboiim, me sara i Lasha. ");
INSERT INTO nlg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Raini na lei vavatana Ham, na sopa kema kara leui sopa leudira, mara ghahara tana lei sopa bubulo. ");
INSERT INTO nlg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem, na tughana Japheth, te vahura na lei dalena. Ma Shem ke na vaivarina na lei vavatana a Eber. ");
INSERT INTO nlg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem gaia na tamadira Elam, Asshur, Arpachshad, Lud, ma Aram. ");
INSERT INTO nlg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ma Aram gaia na tamadira Uz, Hul, Gether, ma Mash. ");
INSERT INTO nlg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ma Arpachshad gaia na tamana Shelah, ma Shelah gaia na tamana Eber. ");
INSERT INTO nlg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ma Eber te loghora erua dalena na mane. Sakai tadira tara holoa nia Peleg na pukuna tana lei bongi ni volana na lei tinoni lokana na maramana tara vilivoka. Na ahana hoghona ke Joktan. ");
INSERT INTO nlg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan gaia na tamadira Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO nlg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO nlg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO nlg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, ma Jobab. Gaira udolu raini na lei dalena Joktan. ");
INSERT INTO nlg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mana vavatana a Joktan te ghaha tana pile bona tara paguha vaa i Mesha pala uluna na lei ghotu i Sephar. ");
INSERT INTO nlg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Raini na vavatana a Shem, na sopa kema kara leui sopa leudira, mara ghahara tana sopa bubulo. ");
INSERT INTO nlg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Raini na lei vavatadira tara va butu mai tana lei dalena Noah, na geretughuni tana kema mana kema taonia na kema mana vavata. Na maramana te sepalaghi igaa na tinoni taonia na kemadira murina na lualua. ");
INSERT INTO nlg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tana bona keri, rana vure tana maramana udolu tara nia kokoe sakai na leu vamua. ");
INSERT INTO nlg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mana vure tara rughuhoru mara tona va i levu uluna, mara va sodoa na nanata i Shinar, mara ghahara igaa. ");
INSERT INTO nlg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Keri ke mara ghaghua heghedira, “Mai ghita, ka talukolui na lei pari raragu ge ka kerei ritini kara ngasi.” Keri ge kara kisua na valedira kolui na lei biriki tara gonighi, ge kara tabe kolua na tar. Na lei totobo raini tara tughui na lei vatu mana poke kolui na saghalea. ");
INSERT INTO nlg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Keri ge gaira tara bosa, “Mai ghita ka kisua na komu sule, kolua na vale datogha ke saravia na parako. Vaho ge ka loghoa na lada sule, ma eni ke lavikolughita, ma ka bei havukaghi gea tana maramana udolu.” ");
INSERT INTO nlg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mi tana bona Yahweh te horu mai ge ke vaevanea na komu sule mana vale datogha na vure tara tono haliu na kisuana, ");
INSERT INTO nlg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","me ghaghua, “Righia! ?Ma ge kara tangomana gera gonighi na lei totobo rakeri na pukuna tara loghoa sakai na leu mara lutu sakaisonikolu ke, na hava kara lutua i kise? Taho siki totobo ke vahola vanira na goniana! ");
INSERT INTO nlg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mai ghita, ka horu ma ka vahera lei leu te keha ge kara mua bei ghilalai.” ");
INSERT INTO nlg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Te vagha keri, Yahweh te havukaghinira ilokana na maramana udolu. Mi kakeri te soko na kisuana na komu sule. ");
INSERT INTO nlg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Keri ge vatua nia na komu Babel, na pukuna Yahweh te bulekaghinighi na ghanaghanadira na vure igaa, me vahera te subo na leu, mara saopoa na maramana udolu. ");
INSERT INTO nlg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Raini na lei vavata Shem. Tana bona Shem te sakai hangalatu (100) tua na niuluna, gaia te vahua na dalena na mane Arpachshad. Aeni te kale tana ruani na niulu murina na lualua. ");
INSERT INTO nlg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mi murina tua na vahuana Arpachshad, Shem te saravia tua lima hangalatu (500) ni niulu, me loghora lei dalena na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tana bona Arpachshad te tolu hangavulu lima (35) tua na niuluna, na dalena mane Shelah te sivuragha. ");
INSERT INTO nlg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Mi murina tua na vahuana Shelah, Arpachshad te saravia tua vati hangalatu tolu (403) na niuluna, me loghora na lei dalena, mane mana vaivine keha. ");
INSERT INTO nlg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tana bona Shelah te tolu hangavulu (30) tua na niuluna, na dalena mane Eber te sivuragha. ");
INSERT INTO nlg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Mi murina tua tara vahua Eber, Shelah te saravia tua vati hangalatu tolu (403) na niuluna, ma loghora na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tana bona Eber te tolu hangavulu vati (34) na niuluna, na dalena na mane Peleg te vahua. ");
INSERT INTO nlg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Mi murina tua tara vahua Peleg, Eber te saravia tua vati hangalatu tolu hangavulu (430) na niuluna, me loghora na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Me saravia tua tolu hangavulu (30) na niuluna Peleg, na dalena na mane Reu te vahua. ");
INSERT INTO nlg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Mi murina tua tara vahua Reu, Peleg te saravia tua erua hangalatu hiua (209) na niuluna, me loghora na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tana bona Reu te tolu hangavulu rua (32) na niuluna na dalena na mane Serug te sivuragha. ");
INSERT INTO nlg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Mi murina tua tara vahua Serug, Reu te saravia tua erua hangalatu vitu (207) na niuluna, me loghora na lei dalena na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tana bona Serug te tolu hangavulu (30) tua na niuluna, na dalena na mane Nahor te sivuragha. ");
INSERT INTO nlg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Mi murina tua tara vahua Nahor, Serug te saravia tua erua hangalatu (200) ni niuluna, me loghora na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tana bona Nahor te rua hangavulu hiua (29) na niuluna, na dalena na mane Terah te sivuragha. ");
INSERT INTO nlg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Mi murina na vahuana Terah, Nahor te saravia tua sakai hangalatu hangavulu hiua (119) na niuluna me loghora na lei dalena, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tana bona Terah te vitu hangavulu (70) tua na niuluna, gaia te sivuraghara e tolu na dalena na mane Abram, Nahor, ma Haran. ");
INSERT INTO nlg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Raeni na vaivaridira Terah. Gaia na tamadira Abram, Nahor, ma Haran. Ma Haran te vahua na dalena na mane Lot. ");
INSERT INTO nlg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hauva, mi tana bona Terah na tamana te vola so, Haran te mate tua, i Ur tana butonikomu i Chaldea. Aeni na komu tara vahua igaa. ");
INSERT INTO nlg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma Abram te tauna Sarai, mana hoghona Nahor te tauna Milcah. Milcah mana hoghona Iscah toro dalena Haran. ");
INSERT INTO nlg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma Sarai te mua tangomana ge ke vahuhu dalena. ");
INSERT INTO nlg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah te holara na dalena Abram mana vungona Sarai mana kukuana Lot, mara rughuhoru sania Ur, ge ra tona tana butonikomu i Canaan. Hauva, tana bona tara sara i Haran, ra kabu igaa. ");
INSERT INTO nlg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tana bona Terah te erua hangalatu lima (205) na niuluna, me mate tua igaa, tana komu Haran. ");
INSERT INTO nlg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma Yahweh te bosa vania Abram me ghaghua, “Ko rughuhoru sania na butonikomumu maia na lei kulamu na vure, mana nina binaboli tamamu, mo ko tona tana butonikomu ku huligho va igaa. ");
INSERT INTO nlg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Inau ku nera ge kara sepa na lei vaivarimu, ge kara liliu ni kema sule. Inau ku vautogho mu ku nea na ahamu ge ke rongoragha, keri ge ku vautora subo na vure itamua na pukuna ighoe. ");
INSERT INTO nlg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Inau ku vautora rahei tara vautogho mu ku varangara rahei tara varangagho. Mi tamua ighoe ku vautora na lei kema udolu ilokana na maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Keri ke, mi tana bona Abram te vitu hangavulu lima (75) na niuluna gaia te rughuhoru sania i Haran, taonia na bosana Yahweh. Ma Lot ghua te nia udukolu. ");
INSERT INTO nlg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram kolua a Sarai na tauna, maia Lot dalena hoghona, kolura nina lei seka, mana lei lologho tara lavighi i Haran, ge ra tughuru ni tona tana butonikomu Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Mara sara tua i Canaan, ge ra sakutua tona va ta sakai na ghai te tabu tara holoa nia Moreh lilighina Shechem, mara ghahara igaa. Tana bona keri, na lei kemana Canaan tara ghahara tana butonikomu eni. ");
INSERT INTO nlg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ma Yahweh te tate vania Abram ge bosa vania, “Inau ku hera na lei vaivarimu na butonikomu eni.” Keri ke, Abram te kisua na belasukaghi gaa vania Yahweh, na pukuna te tate vania. ");
INSERT INTO nlg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mi murina keri, Abram te ghadaru tona tana lei ghotu i uluna na komu tara holoa nia Bethel. Gaia te kabu i ghobudira erua na komu, Bethel i bobokona, mi Ai i uluna. Igaa te kisua sakai na belasukaghi na vatei holohabaana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Igeva gaia te sania na bona keri me ghadaru va tana bona mamaha tara holoa nia Negev. ");
INSERT INTO nlg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mi tana bona keri na ngengere sule te kalea na butonikomu i Canaan. Me vahola tua na ngengere, keri ge Abram te sakutua tona tana butonikomu Egypt, me ke va kabu pile bona igaa. ");
INSERT INTO nlg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mi tana bona te dutu ni haghe tana butonikomu i Egypt ka, ge bosa Abram vania Sarai a tauna, “Sarai, ighoe na vaivine matakage, te uto na reireimu. ");
INSERT INTO nlg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tana bona kara righigho na lei mane ni Egypt ke, kara liona na mateagu inau, na pukuna ighoe na taugu, ge kara lavigho. ");
INSERT INTO nlg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Keri ke, ge ko bosa vanira, to vaivinegu ighoe, mana pukuna ighoe ge kara holopangotiu mu ku vola.” ");
INSERT INTO nlg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Me haghe tua Abram tana butonikomu Egypt ka, na lei mane igaa tara righia Sarai te uto na reireina. ");
INSERT INTO nlg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mana lei nina mane nagho na Vunaghi haba ni Egypt, tara holoa nia Pharaoh, tara righia Sarai ge ra bosaa vania sakai na vinekama te uto na reireina te vaho mai, mara lavi haghea tana vale sule ni vunaghi. ");
INSERT INTO nlg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mana Vunaghi haba te righitaoni utoa Abram, na pukuna Sarai. Ma Pharaoh te vahea na balu sheep mana goat, mana lei buluka, mana lei donkey, mana lei camel kolura na lei seka, na mane mana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hauva mana pukuna na Vunaghi haba te lavia na tauna Abram, Yahweh te nea na Vunaghi haba ge kalea na lei vahaghi dika kolura na vure ilokana na vale sule ni vunaghi. ");
INSERT INTO nlg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Keri ge na Vunaghi haba te holoa Abram me mai tatana ge bosa vania, “E ghua ge o nea vaniu na totobo eni? ?E ghua ge o matapoloa na vaivine eni te taumu? ");
INSERT INTO nlg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","?Mana hava na pukuna ge o bosa ke, ma vaivinemu agaia te ghaghua, keri ge u lavia vaghaa tua a taugu? Aeni gaia na taumu! Ko lavia mo ko rughuhoru tua.” ");
INSERT INTO nlg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mana Vunaghi haba te hera na bosa ni keikeri vanira nina mane lutu, ge kara matareireia Abram, me ke rughuhoru sania Egypt, kolua na tauna ma nina lei lologho. ");
INSERT INTO nlg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Keri ke, Abram kolua tauna, ma Lot, a dalena hoghona, tara lavighi didira na lei lologho, mara rughuhoru sania Egypt. Mara va sara tana bona mamaha tara holoa nia i Negev. ");
INSERT INTO nlg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram a sakai na mane lologho, te loghoi subo na lei sheep mana goat mana buluka, kolui na silver mana gold ghua. ");
INSERT INTO nlg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Gaira tara sania na bona keri me sakutua me kabu balu na bona inaghona te sara tana lei ghotu lilighina Bethel mi Ai. ");
INSERT INTO nlg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Igaa te diki kabu tua, me diki kisua tua na belasukaghi. Me ghoi holohabaa igaa Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma Lot ghua te loghoi subo na lei sheep mana goat mana buluka, kolui nina binaboli heghena mana lei nina mane lutu. ");
INSERT INTO nlg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Me subo na totobo toro sopa loghoi a Abram ma Lot, me mua manana ge kara ghaha kolura vamua ta sakai na bona, na pukuna na pari keri te mua manadira maia didira na lei sopa maumanu. ");
INSERT INTO nlg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","A didira na mane lutu tara righitaonighi didira maumanu tara hughuhughu ghua. Mana bona vaghana keri ghua na kemadira Canaan ma Periz tara ghahara so ilokana na pari keri. ");
INSERT INTO nlg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Keri ge bosa Abram vania Lot me ghaghua, “Iroghita eni, a sakai na binaboli vamua. Mara hughuhughu haia tua na lei dida na mane lutu, me mua uto tara ghaghua igaa! ");
INSERT INTO nlg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Keri ke, me uto ge koro tuvavoka. Ko vilia na levu ni pari to liona ighoe. Ko kabu tana levu ni pari to vilia, mi nau ku lavia na levu.” ");
INSERT INTO nlg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ma Lot te reikolili, me righia na nanata lilighina na betitina Jordan, te dutuvia Zoar. Na pari eni te betigha vaghaa nina leghai Yahweh i Eden, pe vaghana ghua na pari utoutoa tana butonikomu Egypt. (Tana bona vaghana keri, Yahweh te mua durakera mua na komu i Sodom mi Gomorrah.) ");
INSERT INTO nlg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Keri ke, Lot te vilia na nanata udolu lilighina na betitina Jordan, keri ge ke tona palevu iuluna me ke ghanaa igaa. E vaghaa keri toro nea na tuvavoka rana mane raini. ");
INSERT INTO nlg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram te ghanaa tana butonikomu Canaan, ma Lot te kabu i ghobuni na lei komu sule tana nanata i lilighina i Sodom. ");
INSERT INTO nlg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na vure ni Sodom tara dika ngangata, mara tangohahi haia tana matana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mi murina a Lot te tona sania Abram ka, ge bosa Yahweh vania Abram, “Ko righi utoi na lei bona talighu raini. ");
INSERT INTO nlg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Na lei bona ni pari to righighi raini ku hegho ighoe mana lei vaivarimu. Na bona ni pari keri ke nimua haia tua ke vaa me vaa. ");
INSERT INTO nlg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Inau ku nera na lei vaivarimu ge kara sepa, ma kara subo vaghara na pughupughu ni pari, te taho tua hei ke idumira! ");
INSERT INTO nlg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ko tona mo ko sakutua kolili mo ko righia heghemu na bona udolu ku hegho eni.” ");
INSERT INTO nlg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Keri ka ge sania na bona keri a Abram kolui na lei nina lologho, me va ghanaa ililighina na lei ghai tabu nina Mamre dutuvia Hebron. Igaa Abram te kisua sakai na belasukaghi vania Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mi tana bona vaghana keri, e vati na vunaghi haba na ahadira a Amraphel ni Babylonia, Arioch ni Ellasar, Chedorlaomer ni Elam, ma Tidal ni Goiim. ");
INSERT INTO nlg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Gaira tara rughuhoru ni gehemate kolura e lima na vunaghi haba na ahadira, Bera ni Sodom, Birsha ni Gomorrah, Shinab ni Admah, Shemeber ni Zeboiim, mana vunaghi haba ni Bela (itaeni aeni na komu sule tara holoa nia ghua Zoar). ");
INSERT INTO nlg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ra lima na vunaghi haba raini tara liokolu mara lavira didira na malaghai, mara savukolu tana boboko i Siddim, (na bona eni tara holoa nia “na boboko ni Tahi Mate” itaeni). ");
INSERT INTO nlg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Gaira ra lima na vunaghi haba raini tara kabu tua e hangavulu rua na niulu sarana nina maana na vunaghi haba Chedorlaomer, hauva mi lokana e hangavulu tolu na niulu i sarana gaia mara kabu hughuhughu kolua. ");
INSERT INTO nlg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Keri ke, mi tana e hangavulu vatini na niulu na Vunaghi haba Chedorlaomer kolura ra tolu na vunaghi haba keha tara padapada, ma didira malaghai tara mai ge kara suravira e lima na vunaghi haba. Tana vuivuni tara veitotoghoni mara lagavulera na kema ni Repha tana Ashteroth-Karnaim, mara laga vulera ghua na kema ni Zuz tana Ham, mara tona haliu mara laga vulera na kema ni Em tana nanata ni Kiriathaim. ");
INSERT INTO nlg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Soko ke, mara lagavulera na kema ni Hori tana lei ghotu tana bubulo Seir, sara tana El-paran dutuvia na bona mamaha te taho iga na beti mana ghai. ");
INSERT INTO nlg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Me vati na vunaghi haba raini tara oli mara tona tana komu tara holoa nia En-mishpat (itaeni tara holoa nia Kadesh.) Iani tara lagavulera na kema ni Amelek, mara maana pungisira na lei komu nina kema Amelek. Murina keri ge ra ghoi tona ta sakai na komu tara holoa nia Hazazon-tamar, mara lagavulera rana kemana Amor tara ghahara igaa. ");
INSERT INTO nlg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Keri ge rana vunaghi haba ni Sodom, Gomorrah, Admah, Zeboiim ma Bela tara lolola kolura didira na malaghai, mara tona tana boboko i Siddim. Igaa tara veitotoghoni ");
INSERT INTO nlg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kolura ra vati na vunaghi haba, Cherdorlaomer ni Elam, Tidal ni Goiim, Amraphel ni Babylonia, ma Arioch ni Ellasar. E lima na vunaghi haba tara veilalabui kolura e vati na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na boboko te subo igaa na gilu te vonughighi na tar. Mi tana bona e vati na vunaghi haba tara dutu ni lagavuleadira, mara tabotabo ge kara sama sania rana lima na vunaghi haba kolura didira na malaghai ke, me subo itadira kara tumu haghe tana lei gilu. Mana balu ghua tara sama va tana lei ghotu. ");
INSERT INTO nlg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Keri ge ra vati na vunaghi haba tara bolighi na lei lologho ni Sodom mi Gomorrah, kolui na vanga, mara tona. ");
INSERT INTO nlg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Mara lavia ghua Lot, na dalena na hoghona Abram, kolui nina lei lologho na pukuna gaia te ghanaa so i Sodom tana bona vaghana keri. ");
INSERT INTO nlg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma sakai na mane te samapolo, me saravia a Abram, na tinoni ni Jew. Abram te ghanaa so ililighi na lei ghai tabu nina Mamre, na mane tana kemana Amor. A Mamre, kolura erua na hoghona, Eshcol ma Aner, tara liokolu ni gehemate kolua Abram. ");
INSERT INTO nlg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mi tana bona Abram te rongovia tara sagua a Lot, na dalena na hoghona ka, ge holokolura na lei nina malaghai. Gaira ra tolu hangalatu hangavulu alu na mane, mara ghurura ra vati na vunaghi haba, mara nira sara i Dan. ");
INSERT INTO nlg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Igaa Abram te vilivokara na lei nina malaghai tana sopasopa ovu, ge labura na lei ghana na kana tana bongi, me laga vulera ghua. Me ghuru tonara me nira va sara i Hobah, sodu ilauna Damascus. ");
INSERT INTO nlg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Me lavialighi na lei lologho te sagui, me lavia ghua a Lot, na dalena hoghona, kolui nina lei totobo mana lei vaivine kolura balu vure ghua. ");
INSERT INTO nlg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ma Abram te oli tana kisumate, me laga vulera igaa na Vunaghi haba Chedorlaomer maia tolu na vunaghi haba kolua. Mana vunaghi haba ni Sodom te tughuru me va holopangotia Abram tana boboko tara holoa nia Shaveh (eruani na ahana, “na bobokona na Vunaghi haba.”) ");
INSERT INTO nlg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma Melchizedek, na vunaghi haba ni Salem, ma nina manesukaghi ghua a God puku ni haba, gaia te mai, me hea a Abram na berete mana wine. ");
INSERT INTO nlg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma gaia te vautoa ghua Abram me ghaghua, “Ge God puku ni haba te gonia na parako mana pari, ke vautogho Abram. ");
INSERT INTO nlg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ge ka holohabaa God puku ni haba, gaia te negho ge o laga vulera ghamua na lei kana.” Ma Abram te holai sakai tana lei hangavuluni ta nina lei totobo te laga vulei tana veilalabui, me vahea Melchizedek. ");
INSERT INTO nlg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Keri ke, na Vunaghi haba ni Sodom te bosa vania Abram me ghaghua, “Ko holai tua na lei totobo to sagui tana kisumate, mana lei kulagu na vure vamua ko lavi olira vaniu mai.” ");
INSERT INTO nlg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abram te bosatughu me ghaghua, “Inau tu baubahu tana matana Yahweh, God puku ni haba, te gonia na parako mana pari, ");
INSERT INTO nlg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ge ku mua tabei nimua na lei lologho. Hughua na pile kikia ta nimua na lei totobo, ke oli vanigho gatu mughua. Keri ge ko mua bosa talunagho mo ghaghua, ‘Inau tu nea Abram ge lologho!’ ");
INSERT INTO nlg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Inau ku mua ghoi lavia tua siki totobo vaniu heghegu. Hauva, mu ku holopangotia so na hava tara ghanighi tua nina lei malaghai. Mo ko lubatira ghua na lei hoghogu Aner, Eshcol, ma Mamre, gaira kara lavighi na tunuvadira.” ");
INSERT INTO nlg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Murina eni, Yahweh te bosa vania Abram tana maturubole, mi lokana na mabubu eni te rongovia Yahweh te bosa me ghaghua, “Abram, ko bei mataghu. Inau so ku pilipilugho te vagha na tako, ge ke mua kalegho siki totobo dika. Inau ku hegho sakai na taba sule vahotua.” ");
INSERT INTO nlg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Abram te bosatughu me ghaghua, “Maghutu Yahweh, nimua na taba ke mua hangau na pukuna tu mua logho dalegu. A nigua na ghairau, A Eliezer eni, na tinoni ni Damascus vamua, gaia ke lavighi nigua na lologho. ");
INSERT INTO nlg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ighoe to mua heu siki dalegu, keri ke, asakai tadira nigua na ghairau igeva ke lavighi nigua na lologho.” ");
INSERT INTO nlg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Keri ge Yahweh te bosa vania me ghaghua, “Nimua na ghairau Eliezer eni ke mua salapu i tatana siki nimua na lei lologho. A dalemu na mane heghemu mughua ke loghoi nimua na lei lologho.” ");
INSERT INTO nlg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ma Yahweh te lavi horua i paribebete ge bosa vania, “Ko reidato tana parako i kokou, mo ko tabotabo na idumiani na lei veitughu. Ighoe ko mua tangomana ge ko idumi sokoi! Gaighi ke vaghai na suboni na gari kara vahura tana kemamu.” ");
INSERT INTO nlg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ma Abram te taluutunia Yahweh, ma Yahweh te dete maemanea na pukuna nina taluutuni. ");
INSERT INTO nlg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Keri ge bosa Yahweh vania Abram, “Inau Yahweh tu lavikehagho mai Ur tana bubulo i Babylonia, ge ku hegho na pari eni ke nimua heghemu.” ");
INSERT INTO nlg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Abram te huahuati me ghaghua, “?Maghutu Yahweh, ivei kea ge ku ghilala utoa te nigua na pari keri?” ");
INSERT INTO nlg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ge bosatughu Yahweh me ghaghua, “Ko lavighi vaniu mai sakai na buluka vaivine, ma sakai na goat, ma sakai na sheep mane, te tolu na niuludira tua, maia sakai na bola ma sakai na dalei bola.” ");
INSERT INTO nlg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Keri ke Abram te lavighi mai na maumanu raini vania God, me matera ge pahelevui, me nei gaa e rua na levu ge talu alaala. Hauva me mua pahelevui na manu. ");
INSERT INTO nlg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na lei manukama tara lovo horu mai na ghaniani na lei maumanu mate raini, ma Abram te ghuru kehara. ");
INSERT INTO nlg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mi tana bona te tona ni huu na aho ka, ma Abram te maturu mate, me maturu bole bulebule, me righia na pungi sule ngangata me mataghuni. ");
INSERT INTO nlg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mana Yahweh te bosa vania me ghaghua, “Rana vaivarimu kara sinogho tana butonikomu keha, ma kara seka igaa, mi lokana e vati hangalatu na niulu kara kabu vahaghitaili. ");
INSERT INTO nlg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mi nau ku hea na totoro na butonikomu te nera igaa, mi tana bona kara sania na butonikomu keri ke, mana lei totobo uto igaa kara lavighi. ");
INSERT INTO nlg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma Abram, ighoe ke daro na volamu, mo ko saravia na bona ko tonikama iga, keri vaho ge ko mate horu, ma kara tavughigho tana mabo. ");
INSERT INTO nlg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mi murina vaho tana vatini na vavata ge kara ghoi oli mai tana pari eni na lei vaivarimu, na pukuna ku mua tiva kehara mua na kemana Amor ritini ke dika haghata vaho tua na voladira, keri vaho ge ku hera na totoro.” ");
INSERT INTO nlg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mi tana bona te huu tua na aho me puikapu tua, Abram te righia na popo te loghoa na lake ni ahu, kolua na ghai te ruruhu moro tona haliu va ighobudira na pilepileni na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mi tana bongi keri Yahweh te baubahu vania Abram ge ghaghua, “Ku hera na lei vaivarimu na lei bona ni pari raini, te vuivuni tana kobekobena Egypt me va sara tana beti tina sule i Euphrates. ");
INSERT INTO nlg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Aeni na bona ni pari didira na kemana Ken, kemana Keniz, kemana Kadmon, ");
INSERT INTO nlg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kemana Het, kemana Periz, kemana Repha, ");
INSERT INTO nlg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kemana Amor, kemana Canaan, kemana Girgash, mana kemana Jebus.” ");
INSERT INTO nlg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","A Sarai, na tauna Abram, te mua vahua siki gari. Ma sakai na seka te loghoa, na vaivine ni Egypt na ahana Hagar. ");
INSERT INTO nlg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Me bosa Sarai vania Abram, “Yahweh te hoveu na logho gari me sara itaeni. Mi tana liogu inau ke, me uto so ko nia maturu kolua nigua na seka eni. Sogea gaia ke tangomana na logho gari vaniu.” Ma Abram te holopangotia na hava te bosaa Sarai. ");
INSERT INTO nlg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","E paregho na niulu tua te ghanaa Abram i Canaan, ge kale na totobo eni. Keri ke a Sarai te lavia Hagar, me vahea a Abram, eruani na tauna. ");
INSERT INTO nlg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ma Abram te nia maturu kolu Hagar, me vuha logho gari. Mi tana bona Hagar te ghilalaa heghena te logho gari, me vuivuni nia sika a Sarai. ");
INSERT INTO nlg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Keri ke, Sarai te bosa vania Abram, “Aeni na loamu ighoe ge niu sika a Hagar. Inau sughua tu lavia vanigho, mi tana bona te ghilalaa heghena te logho gari ka, me niu sika tua. Me uto, ge ma Yahweh ke detea vanighita, ahei tatada te utuni, ighoe pi nau!” ");
INSERT INTO nlg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma Abram te bosa tughu me ghaghua, “E uto so, a nimua na seka gaia, me kabu sarana nimua na righitaoni. Ko nea vania so na hava to liona vania.” Keri ge kabu vahaghitaili tatana Sarai a Hagar, keri ka ge sogha sania. ");
INSERT INTO nlg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma nina angel Yahweh te sodoa Hagar tana lilighina na vuravura ni beti lokana na bona aroha, tana halautu te tona va i Shur. ");
INSERT INTO nlg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Na angel te bosa vania me ghaghua, “?Hagar, nina seka a Sarai, ivei to vaa butu mai, mi vei ko vaa?” Ma Hagar te bosa tughu vania, “Inau tu sogha sania a Sarai, na vinahoghogu.” ");
INSERT INTO nlg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mana angel te bosa vania, “Ko oli ta Sarai mo ko ghoi va kabu seka so itatana. ");
INSERT INTO nlg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Inau ku hegho e subo na lei vaivarimu ke mua tangomana tua ahei ge ke idumi sokora. ");
INSERT INTO nlg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ighoe to logho gari itaeni, mo ko vahua sakai na meomeo mane mo ko holoa nia Ishmael, na pukuna Yahweh te rongovia nimua na tangi ni dikalio. ");
INSERT INTO nlg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","A dalemu eni ke vaghaa na maumanu asi, ke taonia vamua na liona heghena. Gaia ke kabu hughuhughu tadira na lei vure, mana lei vure kara kabu hughuhughu i tatana. Gaia ke ghana kehaa heghena itadira na lei kulana vure.” ");
INSERT INTO nlg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ma Hagar te kokoe heghena, me ghaghua, “Inau tu righi utunia tua a God, mu mua mate va ghua!” Keri ge holoa nia Yahweh te kokoe vania, “El-Roi.” ");
INSERT INTO nlg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Keri ge ra holoa nia na tuvu iga, i ghobuna i Kadesh mi Bered, ‘Beer-lahai-roi,’ na ghanaghana igaa ke, a nina tuvu a God te vola mete righiu inau. ");
INSERT INTO nlg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ma Hagar te vahua a dalena na garimane vania Abram, me vatua nia Ishmael. ");
INSERT INTO nlg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ma Abram te alu hangavulu ono na niuluna tana bona keri. ");
INSERT INTO nlg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mi tana bona te hiua hangavulu hiua na niuluna Abram ke, ma Yahweh te livu vania ge ghaghua, “Inau a God puku ni maana! Ko taonia haia na bosagu, mo ko nea haia na hava te uto. ");
INSERT INTO nlg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Inau tu baubahu vanigho ge ku sepalaghinia na lei vaivarimu ma kara subo.” ");
INSERT INTO nlg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ma Abram te poghotao tana pari. Ma God te bosa vania me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Aeni na baubahu mava ku nea vanigho. Inau tu baubahu vanigho ge ighoe ko vaivaridira na lei kema. ");
INSERT INTO nlg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Me vuivuni taeni kara mua hologho nia tua Abram, a Abraham tua na ahamu itaeni, na pukuna inau tu negho ge ko vaivaridira na lei kema. ");
INSERT INTO nlg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mi nau ku negho ge ke subo na lei vaivarimu kara vahura mai tana kemamu. Na balu tadira kara vunaghi haba, ma kara sepalaghinia na tinoni me ke subo, ma kara ghoi liliu ni kema sule. ");
INSERT INTO nlg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Inau ku pangotia nigua na baubahu tu nea vanigho, ma vanira ghua na lei vaivarimu tana lei bongi ke mai, ge ke mapiti me ke kabu kasila. Mi nau ku nimua God, ma didira God ghua na lei vaivarimu. ");
INSERT INTO nlg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inau ku hegho ighoe ma rana lei vaivarimu na pari eni, Canaan udolu. Mi nau a didira God.” ");
INSERT INTO nlg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma God te ghoi bosa vania so Abraham, “Ighoe ghua ko tala na pangotiana na baubahu koluu inau, ighoe mana lei vaivarimu tana lei vavata ke mai. ");
INSERT INTO nlg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ighoe, ma rana lei vaivarimu kau holopangotia mughua na pahevaughilaladira na lei mane udolu itamiu. ");
INSERT INTO nlg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Eo, ighau kau pahevaughilaladira mughua na lei mane. Aeni na vaughilalana na baubahu i ghobumu ighoe mi nau. ");
INSERT INTO nlg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Itaeni tua ke vuivuni, mi tana lei vavata udolu kara mai, kara pahevaughilala mughua na lei gari meomeo mane te alu na bongidira. Kau nea te vagha kolura rana seka tara vahura tana valemiu, maia rana seka tau pelura itadira rana sinogho, sakai vamua tara mua vaivarimu. ");
INSERT INTO nlg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ke bei ghoi taho tua sakai na pahevaughilala! Gaia ke vaughilala ni huli, ke tatea nigua na baubahu kolugho ighoe, ge ke kabu kasila. ");
INSERT INTO nlg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Siki mane te mua pahevaughilala, ke mua sakai tadira nigua na vure, na pukuna te mua pangotia na baubahu tu bosaa vanigho.” ");
INSERT INTO nlg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma God te bosa vania Abraham. “Ko bei holoa nia a taumu Sarai. Te vuivuni taeni ko holoa nia Sarah. ");
INSERT INTO nlg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Inau ku vautoa Sarah, ma gaia ke vahua na garimane vanigho. Eo, inau ku vautoa ge ke tinadira na lei kema, mi tadira na lei kema kiri kara dato mai ga na lei vunaghi haba.” ");
INSERT INTO nlg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ma Abraham te poghotao tana pari vania God, me kia na pukuna ta nina ghanaghana ke, “?Ku tangomana so inau, te sakai hangalatu tua na niulugu, ge ku sivuragha na dalegu? ?Me ke tangomana so Sarah te hiua hangavulu tua na niuluna ge ke logho gari meomeo?” ");
INSERT INTO nlg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Keri ge Abraham te bosa vania God, “E uto, ge ko lubatia Ishmael ke lavia nimua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma God te bosa tughu me ghaghua, “Taho, a taumu Sarah tua ke vahua vanigho na garimane, mo ko holoa nia Isaac. Inau ku pangotia nigua na baubahu kolua gaia, ma vanira ghua na lei vaivarina ke vaa me vaa. Na baubahu eni te kabu kasilaa. ");
INSERT INTO nlg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Inau tu rongovia nimua na nongi vuvungana Ishmael. Mi nau ku vautoa, mu ku nea ge ke subo na dalena, mana lei vaivarina ghua kara sepa i murina. Gaia ke tamadira na hangavulu rua na vunaghi, mu ku nera na lei vaivarina ge kara liliu ni kema sule heghedira. ");
INSERT INTO nlg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hauva, inau ku pangotia nigua na baubahu kolua dalemu Isaac, a Sarah ke vahua tana bongi eni tana niulu ke mai.” ");
INSERT INTO nlg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Me kokoe soko tua God vania Abraham ge tona sania. ");
INSERT INTO nlg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mi tana bongi vaghana keri so, a Abraham te taonia na bosana God, me pahevaughilalana a Ishmael, na dalena, maia ghua na lei mane udolu tana valena - na lei nina seka tara vahura tana valena, maia na lei nina seka te pelura. ");
INSERT INTO nlg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","E hiua hangavulu hiua na niuluna Abraham tana bona te pahevaughilala, ");
INSERT INTO nlg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ma Ishmael, a dalena, te hangavulu tolu na niuluna. ");
INSERT INTO nlg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Gaira tamadale toro pahevaughilala ilokana sakai na bongi vamua, ");
INSERT INTO nlg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kolura na lei nina seka mane a Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ma Yahweh te tate vania Abraham tana lei ghai tabu nina Mamre. Abraham te sopou so tana mataulana nina vale tapole tana kutu ni danikama, te papara ngangata iga na hina. ");
INSERT INTO nlg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Gaia te reitona tana halautu, me righira vaa e tolu na mane tara tughuru dutuvia. Me sama tona gaia me va sodora. Ge poghotao tana pari vanira ");
INSERT INTO nlg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ge ghaghua, “Tolughau, ma ge kau liona ge kau ahevata pile bona itagua ke, mu togotogo ge ku hangaghau. Kau bei tona mua. ");
INSERT INTO nlg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kau pitu ghua mu ku bosa vanira nigua ghairau ge kara lavia vanighau mai na pile beti ma kau saui nia na tuamiu, ma kau aheahe pile ghua sarana na ungaungana eni. ");
INSERT INTO nlg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na pukuna tau sara mai tana valegu, inau ku gonia vanighau ghua pile vanga ke hangaghau ge kau sakutua.” Gaira tara bosa tughu, “Holoutogho, ighai tai holopangotia nimua na hahanga.” ");
INSERT INTO nlg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Keri ke Abraham te mina me haghe tana vale tapole me bosa vania Sarah, “Mina mo ko lavia pile flour mo ko bitighi na balu berete.” ");
INSERT INTO nlg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Keri ge sama tona tana pilu me lavia na dale buluka korukoru, me hea nina ghairau ge ke matea, me gonidilaa pile vanga vanira ra tolu na mane. ");
INSERT INTO nlg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Me ghalati tua na vanga, ge Abraham te talua pile cheese mana kokolo tana susu ni buluka, kolua na vinahi, me lavighi heghena vanira, mara vanga. Tana bona tara vanga so, Abraham te tughuru lilighidira, sarana na ghai. ");
INSERT INTO nlg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ma gaira tara huatia Abraham, “?Ivei gaia taumu a Sarah?” Ge bosa oli Abraham, “Gaia ilokana na vale tapole.” ");
INSERT INTO nlg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ma sakai tadira te bosa, “E hiua na vula itaeni ku ghoi oli mai ni righiamiu so, mi gaa na bona vaghana ke vahua sakai na meomeo mane a taumu a Sarah.” A Sarah te rongo mai so i murina na mataulahaghena na vale tapole. ");
INSERT INTO nlg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham ma Sarah toro tonikama tua, ma Sarah te mua tangomana ge ke logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Keri ge kia heghena, “Inau tu tonikama ngangata tua, maia ghua a taugu te tonikama tua. ?Ivei ke ghaghua ge ku loghoa na togotogo keri, ke vagha ku vahua siki meomeo na mane?” ");
INSERT INTO nlg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Keri ge Yahweh te huatia Abraham, “Eghua ge kia Sarah me bosa, ‘?Ku tangomana so na logho gari, inau tu tonikama tua?’ ");
INSERT INTO nlg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Inau a Yahweh! Taho siki totobo ke vahola itagua! Me vaghaa tu bosaa tua, e hiua na vula itaeni ku ghoi oli mai so, mi ga Sarah ke vahua na garimane.” ");
INSERT INTO nlg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mana pukuna Sarah te matagu ge hughu, “Inau tu mua kia.” Ge bosa tughu Yahweh, “Taho! Ighoe tua to kia.” ");
INSERT INTO nlg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Keri ke, ma gaira e tolu na mane tara sania na bona keri mara sakutua tona ta sakai na bona, igaa tara tughuru mara sirohorua na komu i Sodom. Abraham ghua te sakutua kolura, me va sanira tana ghobu ni halautu. ");
INSERT INTO nlg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mi tana bona vaghana keri, Yahweh te ghanaghana heghena te vaghaa eni, “Inau ku mua poloa vania Abraham na hava ku gonia. ");
INSERT INTO nlg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Na lei vaivarina kara vuha liliu ni kema sule, mi tatana gaia inau ku vautora na lei kema udolu. ");
INSERT INTO nlg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Inau tu vilia tua ge ke keikerira na lei dalena mana vaivarina ge kara varongohia na bosagu, ma kara nea na hava te uto me te maemane. Keri ge ku nea vania na lei totobo tu bahua nia tua.” ");
INSERT INTO nlg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Me bosa Yahweh vania Abraham, “Inau tu rongovighi tua na lei totobo dika tara hurura nia na vure ni Sodom mi Gomorrah. Ma didira na lei tangohahi te sule ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ku horu va righira mughua mu ku kenea na hava tara hurura nia te utuni sughua pe taho.” ");
INSERT INTO nlg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ma gaira e rua na mane toro sakusakutua tona i Sodom, ma Yahweh te kabu kolua so Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ma Abraham te tughuru dutuvia Yahweh ge huatia, “?Ivei tea, ko durakera ghua na vure uto kolura nia rana vure dika? ");
INSERT INTO nlg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","?Ke ba lima hangavulu na vure uto kara ghahara tana komu keri ke, mo ghanaghana ge ko durake udolua so na komu? ?Ivei tea, ko mua arovia na komu keri, ge ko vaa vavolara ra lima hangavulu na vure uto? ");
INSERT INTO nlg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tana liogu inau ke, mo ko mua matera rana vure uto kolura rana vure dika. Ko mua tangomana na neana keri. Ma ge ko nea te vaghaa ke, ighoe ko torora rana vure uto te vaghara rana vure dika. Ighoe na manedete tana maramana udolu, keri ge ko nea mughua na hava te uto mete maemane. ");
INSERT INTO nlg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahweh te bosa tughu, “Ku ba sodora e lima hangavulu na vure tara uto lokana na komu i Sodom ke, mu ku vavola na komu keri, na pukuna e lima hangavulu na vure uto igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham te ghoi bosa so, “Yahweh, ko lubatiu ge ku ghoi bosa vanigho, sakai vamua inau na tinoni vamua, mu mua loghoa maana na bosaana siki totobo tana matamu. ");
INSERT INTO nlg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","?Ke ba vati hangavulu lima na vure uto tana komu ke, mo ko durakea so na komu udolu?” ");
INSERT INTO nlg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ma Yahweh te bosa tughu me ghaghua, “Ke vati hangavulu lima na vure uto vamua tana komu ke, mu ku mua durakea.’ ");
INSERT INTO nlg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham te ghoi bosa me ghaghua, “Yahweh ko bei rutu vaniu gea, ku ghoi bosa so. ?Na hava ko gonia, ke ba tolu hangavulu vamua na vure uto tana komu ke?” Me ghoi bosa tughu Yahweh me ghaghua, “Ku mua durakea na komu keri, ke tolu hangavulu na vure uto vamua igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham te ghoi bosa me ghaghua, “Ko talukehai vaniu tu mua mataghu na kokoe tana matamu. ?Na hava ko gonia ke ba rua hangavulu vamua na vure uto tana komu keri?” Ge bosa Yahweh me ghaghua, “Ku mua durakea na komu keri, ke rua hangavulu na vure uto vamua igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Me ghoi bosa so Abraham, “Yahweh, ko bei rutu vaniu gea, aeni vamua sakai nigua na bosa sosoko. ?Ke ba paregho vamua na vure tara uto tana komu keri ke, na hava ko gonia?” Ge bosa Yahweh, “Ke ba paregho vamua na vure uto tana komu ke, ku mua durakea.” ");
INSERT INTO nlg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Me soko na kokoe koukolu Abraham ma Yahweh, ma Yahweh ke tona keha, ma Abraham te oli tana vale tapolena. ");
INSERT INTO nlg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tana nulavi keri, e rua na angel toro sara mai tana komu i Sodom, ma Lot te sopou tana mataula haghe ni peona na komu. Me righira vaa, ge sakutua tona me va topora. Gaia te holopangotira, me poghotao kikinima tana pari, ");
INSERT INTO nlg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ge bosa vanira, “Iroghau na maghutu, koro mai tana valegu. Igaa toro saui na marevomiu, mo koro maturu i gevaa. Mi roropo ge koro ghoi sakutua tona ivei toro liona.” Ma gaira toro bosatughu, “Taho, e uto so, na bonadira na sinogho so tana komu ini, igaa koro va maturu.” ");
INSERT INTO nlg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hauva Lot te kurutia so, vaho ge ro tala na tona tana valena. Ma Lot tu keikerira nina ghairau ge kara gonidilai balu berete, kolui balu na vanga, ge ro vanga. ");
INSERT INTO nlg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mi murina na vanga nulavi inaghona ge ro gonidila ni maturu, na lei mane ni Sodom tara mai kililia na vale, na lei garimane mana tonikama. ");
INSERT INTO nlg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Gaira tara ghaeghahe dato vania Lot mara huatia, “?Ivei gaira na mane toro mai tana valemu i geni tana nulavi ka? Ko lavi horura vanighai mai, te liomami ge kai nira koli kolu!” ");
INSERT INTO nlg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ma Lot te horu i pari bebete, me vongotia na mataula. ");
INSERT INTO nlg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ge bosa vanira, “Ghau na lei hoghogu, kau bei gonia gea siki totobo dika! ");
INSERT INTO nlg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","E rua dalegu na tahula so itagua, mu ku va holora vanighau mai, ma kau nea vanira na hava te liomiu. Kau bei nea vanira siki totobo na mane raini, na pukuna gaira ghagua na sara, ge ku righitaonira mughua.” ");
INSERT INTO nlg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma gaira tara bosa, “Ighoe na sinogho mai, ko tulili! ?Ahei ghoe ge ko bosaa vanighai na hava kai gonia? Kai dikalagho gea vulera kai nera igaa ra rua na mane kiri!” Keri ke, Gaira tara pili olia Lot, gera dikalaa na vovongona na mataula. ");
INSERT INTO nlg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma rana angel ilokana na vale toro hangavia na mataula, moro hagalo horu moro ghora haghea Lot ilokana na vale, ge ro pitia na vovongo. ");
INSERT INTO nlg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Keri ge ro nei na matadira na lei mane ni Sodom mara pungi, mara mua tangomana na righi kaleana na mataula. ");
INSERT INTO nlg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ma rana angel toro huatia Lot moro ghaghua, “Ahei ghua siki kulamu ilokana na komu eni, ko lavi kehara tua itaeni! Na lei dalemu na mane mana vaivine mana taudira maia ghua tau palevara, ko lavi kehara ghua, ");
INSERT INTO nlg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","na pukuna i geva koro durakea na komu eni. Ma Yahweh te ghilalaa ge rana vure tana komu eni tara hahi sule haia tua, me vetena ghai mai ge koro durakea na komu Sodom.” ");
INSERT INTO nlg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Keri ke Lot te tona me va bosa vanira na mane tara gonidila ge kara taudira ra dalena na tahula, “Kau mina tua na tona keha tana komu eni, na pukuna Yahweh ke dutu na durakeana.” Hauva moro ghanaghana ke, me batobatora vamua a Lot ge ro mua tona keha. ");
INSERT INTO nlg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mi tana puipungi ghana, gaira na lei angel toro gherigheria Lot moro bosa vania, “Ko mina tua mo ko tona keha tana komu eni. Ko holaa a taumu, maia rua na dalemu na tahula, mi ghau udolu kau mina tona keha tua i taeni, ge kau vola tana bona ke durake na komu eni.” ");
INSERT INTO nlg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Hauva Lot te hughahughapoto na liona. Keri ge rana angel toro tabe limadira a tauna ma gaia, maia ghua ra rua na daledira na tahula, moro huli horu kehara i pari bebetena na komu ge kara vola igaa, na pukuna Yahweh te arovira. ");
INSERT INTO nlg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ma sakai tadira rana angel te bosa vanira me ghaghua, “Kau sama tona tua ge kau vola! Kau sama dato tana lei ghotu, ma kau bei reioli gea. Kau bei beto gea ta siki boboko, kau mate gea!” ");
INSERT INTO nlg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot te bosa me ghaghua, “Iroghau rana maghutugu, taho, ko bei neghai ge te vaghaa keri. ");
INSERT INTO nlg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Iroghau toro aroviu moro volau tua. Na lei ghotu tara hau, mi gevaa ke kaleu na vahaghitaili mu ku vuha mate tana halautu. ");
INSERT INTO nlg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","?Iroghau toro righia so na komu pile nagho keri? Gaia te dutu mai, mu ku tangomana ge ku saravia. Ko talagu mu ku va igaa. Na komu pile vamua mi ga ku va kabu tatavahale.” ");
INSERT INTO nlg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mana angel te bosa tughu me ghaghua, “E uto so, ku mua durakea na komu keri. ");
INSERT INTO nlg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mina tua mo ko sama tona! Inau ku mua tangomana na goniana siki totobo ritini kau sara igaa.” Mi ga te vuivuni ge ra holoa na komu keri Zoar. ");
INSERT INTO nlg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Na aho te sogha tua tana bona a Lot te sara tana komu i Zoar. ");
INSERT INTO nlg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Keri ke, Yahweh te nia vetena horu mai na lake, mana ghoughovu tara ruruhu tara tumu horu mai kokou vaghaa na uha i vuvungadira rana komu i Sodom mi Gomorrah. ");
INSERT INTO nlg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mete vagha keri, Yahweh te durakera rana komu i Sodom mi Gomorrah, maia na lei komu i lilighidira tana lei boboko, kolui na lei tinoni gaa, mana lei totobo soko tara totolo tana pari. ");
INSERT INTO nlg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma tauna Lot te reioli, ma gaia te liliu ni tahi kokodo. ");
INSERT INTO nlg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mi tana puipungi ghana murina na bongi keri, Abraham te tona tana bona igaa te tughuru me kokoe kolua Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Me righi horura i Sodom mi Gomorrah kolua na boboko sule, me vaevane na ahu te pouta tana bona keri, te vagha na ahu ni lake sule ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mi tana bona God te durakei tua na lei komu kiri tana boboko te ghahaa igaa Lot, gaia te ghanaghanaa Abraham, me talana Lot ge ke sama polo tana vahaghitaili te kalea. ");
INSERT INTO nlg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Mi murina keri a Lot te tona sania na komu i Zoar, na pukuna te mataghunia ge ke ghahaa iga. Gaia te lavira rua dalena toro tahula, me nira dato tana lei ghotu, mara ghahara i lokana na vatuluma. ");
INSERT INTO nlg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mi ta sakai na bongi, na diki tahula te bosa vania tahina me ghaghua, “E taho na lei mane lilighina na bona eni ge koro taulaghi. Ma tamada te dutuvia tua na tonikama. ");
INSERT INTO nlg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mai roghita mo koro hea na wine tamada me ke bule, ge koro nia maturu kolu, ge koro loghoa na kema ke va mai ta tamada.” ");
INSERT INTO nlg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mi tana bongi keri gaira toro hea tamadira na wine me inu bulebule tua. Mana diki tahula te va nia kolikolua tamana. Ma Lot te mua ghilalaa na hava te gonia na pukuna te inu me bule tua. ");
INSERT INTO nlg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mi tana puipungi ghana, na diki tahula te bosa vania tahina, “Inau tu nia kolikolu tua tamada i bongi, mi gevaa tana bongi eni koro ghoi hea so na wine me ke inu me ke bule, ge ko nia kolikolu ighoe. Keri ke ge koro sopa logho gari ta tamada.” ");
INSERT INTO nlg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mi tana bongi keri, gaira toro ghoi hea tamadira na wine me inu bule so, me ruani na tahula te va ghoi nia kolikolu tamana. Ma Lot te mua ghilala so na hava te gonia, na pukuna te ghoi inu bule so. ");
INSERT INTO nlg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Keri te vaghaa ge gaira udolu ra dalena na tahula Lot, toro logho gari ta tamadira. ");
INSERT INTO nlg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Na kamanagho te vahua na garimane, me holoa nia Moab. Agaia te vaivarina na kema tara holoa nia Moab. ");
INSERT INTO nlg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mana ruani te vahua na garimane ghua, me holoa nia Ben-Ammi. Gaia te vaivarina na kema tara holora nia Ammon. ");
INSERT INTO nlg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ma Abraham te sania i Mamre me tona tana bona mamaha tara holoa nia Negev, me va kabu i ghabudira e rua na komu, i Kadesh mi Shur. Murina keri gaia te ghoi ghadaru va i Gerar, ");
INSERT INTO nlg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","mi tana bona keri Abraham te bosa vanira na vure raeni, “A Sarah ke, te vaivinegu vamua,” sakai vamua te tauna. Keri ke, Abimelech, na vunaghi haba ni Gerar te holaa vania mai a Sarah ge ke tauna. ");
INSERT INTO nlg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mi ta sakai na bongi God te bosa vania Abimelech tana maturu bole me ghaghua, “Ighoe ko mate, na pukuna na vaivine to lavia te taulaghi tua.” ");
INSERT INTO nlg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma Abimelech te mua nia kolikolu mua Sarah, me bosa me ghaghua, “?Maghutu, ko mateu so kolura nigua na vure, sakai vamua tu marabu tana palu keri? ");
INSERT INTO nlg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Me bosa heghena Abraham ke, ‘Inau na vaivinena Sarah.’ Me bosa ghua Sarah ke, ‘Inau na vaivinena Abraham,’ e ghaghua! Tana bona tu lavia na vaivine eni ke, mi tana ghanaghanagu inau ke, tu mua gonia siki hahia vania!” ");
INSERT INTO nlg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God te bosa tughu vania Abimelech tana maturu bole, “Eo, inau tu ghilalaa na hava to nea keri te marabu, mo ko bei neu mo ko palugha itagua. Keri ke, ge u hovegho ko bei hibetia na vaivine keri. ");
INSERT INTO nlg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ko va talu olia vania a tauna. Gaia ke kokoeliulivutigho ge ko vola, na pukuna gaia na prophet. Taho ke, mi ghoe ma nimua na binaboli udolu tua kau mate.” ");
INSERT INTO nlg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ma Abimelech te va rarai mai tana bona te puipungi mua, me holo kolura na lei nina mane huhuli, me tutugui vanira na lei totobo tana maturu bole, mara mataghu sule ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ma gaia te holoa Abraham ge huatia, “Na hava na totobo vaghana eni to nea vanighai? ?Na hava tu goni dikalaa vanigho ge ko nea na totobo eni vaniu, ma nigua na vure? E mua manana ge ko gonia vaniu na totobo eni. ");
INSERT INTO nlg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","?Eghua ge ko gonia vaniu te vagha eni?” ");
INSERT INTO nlg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham te bosa tughu, “Inau tu ghanaghana ke, me taho siki tinoni te taluutunia God iani, keri ke, kara mateu gea ma kara lavia taugu. ");
INSERT INTO nlg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A vaivinegu sughua gaia, na pukuna te dalena tamagu, me mua dalena tinagu. Keri ke, ge u lavia mu tauna. ");
INSERT INTO nlg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mi tana bona God te vetenau ge u sania na komuna tamagu, mu ku tona tana lei butonikomu keha, keri ge u bosa vania Sarah, ‘Ivei tua koro vaa ke, ko niu kikinima mo ko bosa to vaivinegu.’” ");
INSERT INTO nlg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ma Abimelech te hea olia Abraham a Sarah tauna, kolura na lei nina seka, na mane mana vaivine, mana lei sheep mana lei buluka. ");
INSERT INTO nlg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ge gaia te bosa vania Abraham me ghaghua, “Aeni udolu tua nigua na pari, ko vilia ivei to liona na kabu igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Me bosa vania Sarah, “Inau tu hea vaivinemu Abraham na togha ni rongo ni silver, ke lavikehaa siki ghanaghana dika ke ba nea siki sakai vuvungamu, ge na mavitu ke ghilalaa, to mua gonia siki totobo te hahi vanigho.” ");
INSERT INTO nlg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Keri ke, Abraham te kokoeliulivuti vania God, ma God te volaa Abimelech kolua tauna, mana lei vaivine tana valena ge kara ghoi logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Mana pukuna Abimelech te diki lavia tua tauna Abraham, Yahweh te nera na lei vaivine tana valena mara mua logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahweh te vautoa Sarah taonia te diki bahua nia tua, ");
INSERT INTO nlg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","me logho gari, ge vahua na meomeo mane vania Abraham, tana bona te tonikama tua. Na garimane tara vahua tana bona te bosaa tua God. ");
INSERT INTO nlg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ma Abraham te vatua nia dalena Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Me padi tua e alu na bongina tara vahua Abraham te pahevaughilalana Isaac, taonia na bosana God. ");
INSERT INTO nlg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Me sakai na hangalatu tua na niuluna Abraham tana bona tara vahua a Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Me bosa Sarah me ghaghua, “God te heu na kiakia mana togotogo, ma gaira tara rongovia na ladagu, kara nia togotogo mara kiakia koukolu ghua. ");
INSERT INTO nlg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E taho siki sakai ke bosa vania Abraham ge ku logho gari eni, mu ku susua. Hauva ma sakai vamua toro tonikama tua i roghai, inau tu vahua so na meomeo mane vania Abraham.” ");
INSERT INTO nlg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma Isaac te sule tua, mi tana bongi te sania na susu, Abraham te gonia na vangakolu sule vania. ");
INSERT INTO nlg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Keri ke a Sarah te righia Ishmael, na dalena Hagar, na seka, te batobatoa Isaac, ");
INSERT INTO nlg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ge bosa vania Abraham, “Ko vetena tonaa na seka vaivine keri kolua dalena! Ke bei ghoi lavia tua na levuna nimua na lologho na dalena keri, te manana dalegu Isaac vamua ke loghoi.” ");
INSERT INTO nlg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham te rongovia eni, me nia dikalio sule ngangata, na pukuna dalena ghua Ishmael. ");
INSERT INTO nlg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma God te bosa vania Abraham, “Ko bei nira kanoragha gea Ishmael ma Hagar, nimua na seka vaivine. Ko taonia vamua na hava te bosaa vanigho Sarah, na pukuna itatana Isaac ko loghoa na vinavahuhu subo tu nia baubahu vanigho tua. ");
INSERT INTO nlg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hauva, inau ku nea ghua ge ke subo kara vahuara tana kemana Ishmael, ma kara sepa ma kara liliu tana kema sule, na pukuna gaia ghua na dalemu ighoe.” ");
INSERT INTO nlg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Me roropoghana mai, Abraham te gonidilai na balu vanga mana kada ni beti, me hea Hagar ge ke holai. Keri ge Abraham te lubatia na dalena Ishmael, me vetena tonara. Gaia te sakutua me va sara tana bona mamaha lilighina Beersheba kolua dalena. ");
INSERT INTO nlg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mi tana bona te soko na beti ni inu, gaia te talua na garimane sarana na ungaunga tana ghai pile. ");
INSERT INTO nlg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Hagar te tona hauvia na garimane, me va sopou heghena tana bona keha te manana na hauna siki sakai te nia vana sara igaa na kuali, na pukuna ta nina ghanaghana, “E mua liogu ge ku righia na dalegu ke mate.” Mi tana bona gaia te sopou kakeri, ge tangi. ");
INSERT INTO nlg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God te rongovia na garimane te tangi, ma nina angel God te bosa mai i kokou vania Hagar, me ghaghua, “?Na hava to nia dikalio? Ko bei mataghu. God te rongovia tua nina tangi na garimane to va talua igaa. ");
INSERT INTO nlg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tughuru mo ko tona mo ko va togholuvua. Inau ku nera na lei vaivarina ge kara liliu ni kema sule.” ");
INSERT INTO nlg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Keri ge a God te davoraa na matana Hagar, ge righia na tuvu. Me dorea ghana kada ni beti ge inuinua dalena. ");
INSERT INTO nlg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ma God te kabu kolua na garimane mi tana bona te sule te ghahaa tana bona mamaha i Paran, me manahana utoni na nighi hili na baghe mana kuali. ");
INSERT INTO nlg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mi tana bona keri na tinana te lavia vania na vaivine ni Egypt ge ke tauna. ");
INSERT INTO nlg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tana bona keri na Vunaghi haba Abimelech kolua Phicol, nina mane nagho tana malaghai, toro mai kaoa Abraham. Abimelech te bosa vania Abraham me ghaghua, “God te hangagho tana lei totobo to gonighi. ");
INSERT INTO nlg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Keri ke, ko papari vaniu mai tua itaeni tana matana God, ge ko mua ghoi pegou tua, kolura na lei dalegu mana vaivarigu. Inau tu kabu sasara tua itamua, mi ghoe ko baubahu mo ko kabu sasara itagua, mi tatana ghua na butonikomu eni to ghahagho igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ma Abraham te bosa tughu me ghaghua, “Inau tu baubahu.” ");
INSERT INTO nlg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Keri ge hughuhughu kolua Abimelech nia na tuvu tara holaa nina mane lutu Abimelech tadira nina mane lutu gaia. ");
INSERT INTO nlg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma Abimelech te bosa, “Itaeni vaho ge u rongovia to bosa vaniu, mu mua ghilalaa ahei te gonia. ?Me ghua ge o mua diki bosa vaniu tua?” ");
INSERT INTO nlg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ma Abraham te hea Abimelech na balu buluka mana sheep, ma rogaira toro sopa baubahu. ");
INSERT INTO nlg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ma Abraham te vilikehara e vitu na dale sheep vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ma Abimelech te huatia, “?E ghua ge o nea te vaghaa keri?” ");
INSERT INTO nlg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ge bosa tughu Abraham, “Ko lavighi nigua na dale sheep raini, mo ko holopangotighi ge ke vaughilala to taluutuniu, inau sughua tu ghelia na tuvu eni.” ");
INSERT INTO nlg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mi kakeri tea ge kara holoa nia na bona keri i Beersheba, na pukuna igaa toro baubahu a Abraham ma Abimelech. ");
INSERT INTO nlg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Murina toro baubahu soko tua, Abimelech kolua na mane nagho ni malaghai Phicol toro oli tana butonikomudira i Philistia. ");
INSERT INTO nlg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ma Abraham te subaa sakai na ghai tara holoa nia tamarisk i Beersheba. Mi ga te holohabaa Yahweh na God te vola talau. ");
INSERT INTO nlg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Me daro ni bona te ghahaa tana butonikomu Philistia a Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mi murina keri, God te tabotaboa Abraham ta nina taluutuni mana taotaoni ge holoa, “Abraham!” Me bosa tughu gaia, “Inau iani!” ");
INSERT INTO nlg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ge bosa God, “Ko lavia na vahusosopa dalemu Isaac, to dolovi ngangataa, mo ko tona tana bona tara holoa nia Moriah. Igaa ko nia sukaghi vaniu i vuvungana na ghotu ku bosa vanigho.” ");
INSERT INTO nlg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mi tana roropoghana te puipungi lamolamo mua, Abraham te pihaghai ni sukaghi, me ludangighi vuvungana na donkey. Gaia te lavia Isaac a dalena, maia ra rua nina mane lutu mara tona tana bona God te diki bosaa vania tua. ");
INSERT INTO nlg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mi tana toluni na bongi murina tara sakutua, Abraham te righi halahaua vaa i nagho na bona keri. ");
INSERT INTO nlg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ge bosa vanira nina mane lutu, “Pitu iani roghau, kolua na donkey, ma Isaac mi nau koro sakutua tona. Mo koro va holohaba iga, ge koro oli mai tamiu.” ");
INSERT INTO nlg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham te holaa na pipiti ni ghai ni sukaghi me talua tana valana Isaac ge ke holavala, ma gaia te lavia na isi mana keukeru ni lake. ");
INSERT INTO nlg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Moro sakutua gaira, ge bosa Isaac, “Tamagu!” Abraham te bosatughu, “Na hava dalegu?” Ge bosa Isaac, “?Na ghai mana lake tua i tatada, mi vei gaia na dale sheep koro nia sukaghi?” ");
INSERT INTO nlg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham te bosa tughu, “God heghena ke heghita so sakai.” Ma gaira toro sakusakutua so. ");
INSERT INTO nlg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mi tana bona toro sara tana bona te diki bosaa God vania, Abraham te kisua na bela ni sukaghi, me gonidilai na ghai vuvungana. Keri ge pitia Isaac, me kolivaghinia vuvungana na lei ghai. ");
INSERT INTO nlg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ma Abraham te lavia na ivi me haudatoa ge ke matea nia dalena. ");
INSERT INTO nlg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hauva anina angel Yahweh te holoa Abraham mai kokou me ghaghua, “Abraham! Abraham!” Gaia te bosa tughu, “Eo, iani so inau.” ");
INSERT INTO nlg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mana angel te ghoi bosa, “Ko bei matea na gari, po ko bei vahaghitailia! Itaeni inau tu ghilalaa to talumavaa mo taonia na bosana God, na pukuna to mua hovea na puku ni dalemu vahusosopa vania God.” ");
INSERT INTO nlg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham te reikolili me vaevanea na sheep mane te kau na kalana tana tautalu ni ghai. Keri ge holaa me nia sukaghi tughua nia dalena. ");
INSERT INTO nlg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham te vatua nia na bona keri, “Yahweh ke hea.” Me sara itaeni rana vure tara bosa, “I vuvungana nina ghotu Yahweh ke hea.” ");
INSERT INTO nlg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ma nina angel Yahweh te ruani na holoana mai so Abraham i kokou. ");
INSERT INTO nlg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Me bosa, “Aeni gaia na hava te bosaa Yahweh, ‘Inau tu nia papari na ahagu heghegu, ge ku vautogho na pukuna to mua hovea vaniu na dalemu vahusosopa. ");
INSERT INTO nlg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mu baubahu ge ku sepalaghinia na vaivarimu ge kara subo vaghara na veitughu tana parako, mana saghalea tana saravahale, ma kara laga vulera ghadira na kana. ");
INSERT INTO nlg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mi tadira na lei vaivarimu ku vautora na lei kema ni maramana talighu, na pukuna to varongohia na bosagu.” ");
INSERT INTO nlg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Keri ge Abraham ma Isaac toro oli tadira nina mane lutu, ma gaira tara tona i Beersheba, te ghahaa igaa Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Me mua hau murina keri, Abraham te rongovia a Milcah, tauna Nahor, a hoghona Abraham, te vahura e alu na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Na kamanagho Uz, me mai a Buz, Kemuel (tamana Aram,) ");
INSERT INTO nlg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph ma Bethuel. ");
INSERT INTO nlg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ma Bethuel ke, gaia na tamana Rebekah. ");
INSERT INTO nlg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor te lavia eruani na tauna, sakai nina seka vaivine, na ahana Reumah. Gaia te vahura e vati na mane itatana Nahor - Tebah, Gaham, Tahash, ma Maacah. ");
INSERT INTO nlg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Mi tana bona Sarah, te sakai na hangalatu rua hangavulu vitu na niuluna, ");
INSERT INTO nlg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ge mate i Kiriath-arba (itaeni tara holoa nia Hebron,) tana bubulo i Canaan. Igaa Abraham te kabu dikalio me nia tangi a tauna te mate. ");
INSERT INTO nlg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham te sania na bona te koli gaa na hulina tauna, ge tona me va righira na vure ni kemana Het, ge bosa vanira, ");
INSERT INTO nlg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Inau eni, na tinoni tu sinogho mai tana butonikomu eni, me taho siki bona ku tavughia igaa taugu. Kau heu na pile bona ni pari ni tautavughi mu ku pelua.” ");
INSERT INTO nlg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Gaira tara bosa tughu vania Abraham, mara ghaghua, ");
INSERT INTO nlg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Aghe, na manesule, ko rongovighai mai. Ighai tai righigho te vagha gaia a sakai te hulighai. Ko vilia vamua siki beku te liomu tadira tai loghoi, mo ko tavughia igaa a taumu. Taho tua hei tamami ke ghoi hovegho.” ");
INSERT INTO nlg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham te tongaghi vanira ge bosa, ");
INSERT INTO nlg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Kau talana sughua tua ku tavughia a taugu tana bona eni ke, ma kau nongighau a Ephron dalena Zohar, ");
INSERT INTO nlg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","me ke nia hunulu vaniu na vatuluma i Machpelah, i lilighi na sosokona nina nanagu. Kau bosa vania, me ke nia hunulu vaniu nia na matena, mu ku pelua taeni tana matamiu, ge ke nigua na bona ni tautavughi tua.” ");
INSERT INTO nlg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron te sopou so i ghobudira na vure ni kemana Het, tana bona ni vaukolu, tana mataula haghe ni komu. Mi tana matadira na vure subo ge bosa, ");
INSERT INTO nlg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Manesule, ko rongoviu mai. Inau ku hegho na pile bona ni pari eni, maia na vatuluma igaa. Tana matadira kulagu na vure ku hegho na pari, ge ko tavughia igaa a taumu.” ");
INSERT INTO nlg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham te ghoi tongaghi vanira na vure ni kemana Het, ");
INSERT INTO nlg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ge bosa vania Ephron, me ke rongo ghua na mavitu, me ghaghua, “Inau tu nongigho gatu ko rongoviu, tu liona na peluana na pile bona ni pari tamua. Ko holopangotia na rongo eni, na matena na pari, mu ku va tavughia taugu tana pari keri.” ");
INSERT INTO nlg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ma Ephron te bosa tughu, ");
INSERT INTO nlg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Aghe, na manesule, na matena na pari keri te vati na hangalatu na rongo silver vamua. ?Mi vei ka va nea na kulaghaa? Ko tona vamua mo ko va tavughia a taumu igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham te holopangotia na matena na pari te bosai a Ephron, ge idumighi na rongo tana matadira na vure subo, te vati hangalatu na rongo ni silver, taonia na nilabu ni kakage ni pelu pari tara nei haia tua na vure sabisabiri, me va hea tana limana Ephron. ");
INSERT INTO nlg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Keri ke, Abraham te pelua tua na pari tatana a Ephron i Machpelah, lilighina i Mamre, kolua na vatuluma mana lei ghai igaa. ");
INSERT INTO nlg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Keri te vaghaa ge loghoa Abraham na pile bona ni pari keri, kolui na lei totobo i lokana, taonia na baubahu te gonia tana matadira na lei manesule ni kemana Het tana bona ni savukolu. ");
INSERT INTO nlg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mi murina keri, Abraham te tavughia Sarah, a tauna, tana vatuluma ni beku i Machpelah, lilighina Mamre, ilokana na bubulo ni Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Keri ka, na pile bona ni pari didira na vure ni kemana Het, kolua na vatuluma igaa, te salapu vania tua Abraham, me vatei tautavughi. ");
INSERT INTO nlg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham te tonikama tua, ma Yahweh te vautoa so tana lei totobo te gonighi. ");
INSERT INTO nlg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ma sakai na bongi te bosa vania nina ghairau haulaghi mai tua, te righitaonighi nina lei totobo te loghoi me ghaghua, “Ko talua na limamu sarana na tuatavuligu, ");
INSERT INTO nlg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","me liogu ko nia papari na ahana Yahweh, God ni kokou mi pari, mo ko bei vilia vania siki vaivine tadira na vure ni Canaan raini ke tauna dalegu Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ko tona tana butonikomu tara vahuu igaa. Itadira na lei kulagu na vure ko lavia vania siki vaivine ge ke tauna dalegu Isaac.” ");
INSERT INTO nlg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mana ghairau te huahuati, “?Ivei tea, ke mua tala na saniana na komuna na vaivine, me ke mua niu uduhoru mai ke, me uto so ku lavia Isaac mu ku nia tona ta kulana vure me ke ghahaa tua itadira?” ");
INSERT INTO nlg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ma Abraham te bosa tughu, “Taho! Bei hola tona gea dalegu. ");
INSERT INTO nlg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ma Yahweh, God i kokou, te lavikehau tua tana komuna tamagu, mi tana bonadira kulagu na vure, me baubahu vaniu ge ke hera na lei vaivarigu na pari eni, me ke diki nia vetena ide nina angel ke huligho me ke tughunia vanigho na vaivine ke tauna dalegu. ");
INSERT INTO nlg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Me ke ba mua liona na mai koluamu na vaivine ke, mo ko mua nia maa ighoe na papari. Mo ko bei ghoi lavi tonaa tua dalegu.” ");
INSERT INTO nlg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Keri ge nia papari nina ghairau Abraham ge ke nea taonia na hava Abraham te bosaa vania. ");
INSERT INTO nlg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Keri ke na ghairau te lavighi e paregho nina camel Abraham mana balu nina lologho, me tona tana Aram-naharaim, na komu te ghahaa igaa Nahor, hoghona Abraham, launa tana bubulo i Mesopotamia. ");
INSERT INTO nlg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Gaia te sara nulavi tana bebete ni komu lilighina na tuvu, me talugonira na camel mara aheahe igaa. Me sara tua na bona tara horu ni heo beti na lei vaivine tana tuvu. ");
INSERT INTO nlg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Gaia te kokoeliulivuti me ghaghua, “Yahweh God ta Abraham na vunaghigu, ko hangau mai taeni ge ku nia tangomana na hava tu nea eni, mo ko tatea nimua na veiarovi vania na vunaghigu. ");
INSERT INTO nlg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Inau tu tughuru iani, lilighina na tuvu eni, igaa kara heo beti na lei vaivine ni komu. ");
INSERT INTO nlg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mu ku bosa vania sakai mu ghaghua, ‘Ko lubatiu ge ku inu.’ Ma ge ke bosa tughu gaia, ‘Eo, ko inu, mi nau ku heo ghadira beti ghua nimua na camel,’ vaho ge u ghilala gaia tua keri na vaivine to vilia vania nimua na mane lutu Isaac. Ke vaghaa keri ke, ge ku ghilalaa to pangotia so nimua baubahu vania na vunaghigu.” ");
INSERT INTO nlg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Me mua soko mua na kokoeliulivuti gaia, me sara tua sakai na tahula na ahana Rebekah, te hola valaa na popovatu. Gaia dalena Bethuel dalena Nahor ma tauna Milcah. A Nahor hoghona Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebekah na tahula maemane me te matakage, te mua koli koukolu mane mua. Gaia te tona tana tuvu, me dore betina nina popovatu ge oli. ");
INSERT INTO nlg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mana ghairau te samalia vaa ge bosa vania, “Ko lubatiu mu ku inu tana popovatu.” ");
INSERT INTO nlg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ge bosa Rebekah, “Maghutu, eo, ko inu.” Ge mina me hui horua na popovatu ni beti tana valana me lighia vania ge inu. ");
INSERT INTO nlg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Me inu soko tua gaia, ge bosa Rebekah me ghaghua, “Inau ku heo ghadira beti ghua na lei nimua camel, kara inu ma kara vada.” ");
INSERT INTO nlg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mana tahula te mina me kolava beti tana tungi, me ghoi oli ni heo beti ghadira so na lei camel, ma gaira udolu tara inu mara vada. ");
INSERT INTO nlg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Na ghairau te toghatoghaa na tahula me nia hoghohare na liona, gaia sogea tua na vaivine te vilia a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mara inua soko tua na camel, na ghairau te hea Rebekah na ring gold me nia susuihu, te dato na matena, me rua na seli gold te sule. ");
INSERT INTO nlg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Me huatia, “?Ko bosa vaniu, ahei a tamamu? ?Siki sakai so tana valena kai maturu igaa gevaa ke bongi, na lei kulagu mane mi nau?” ");
INSERT INTO nlg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Me bosa tughu na tahula, “Tamagu a Bethuel, na daledira Nahor ma Milcah. ");
INSERT INTO nlg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","E subo so na buburu na ghadira vanga na camel, me malagha so kau maturu tana valemami tana bongi.” ");
INSERT INTO nlg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mana ghairau te tualaghi tuturu me holohabaa Yahweh ");
INSERT INTO nlg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ge bosa, “Inau tu holoutoa Yahweh, God ta Abraham, na vunaghigu. Gaia te pangotia so nina baubahu vania na vunaghigu me huli maemaneu mai itadira na lei kulana vure.” ");
INSERT INTO nlg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mana tahula te sama oli tana valedira tinana ma tamana, me tutuguni vania na binaboli na hava te kale. ");
INSERT INTO nlg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ma Rebekah te loghoa na vaivinena Laban. Mi tana bona Laban te righia na ring te talua na mane tana ihuna Rebekah, mana lei seli tana limana, maia ghua te rongovia na tutuguna na mane te bosa vania Rebekah, keri ge sama horu tana tuvu me sodoa igaa nina ghairau Abraham, te tughuru i lilighidira so na camel. ");
INSERT INTO nlg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ge bosa Laban vania, “Ighoe, na mane te vautogho tua Yahweh, ko mai tana valemami. ?Eghua ge o tughuru so iani? Na voki te gonidila vanigho tua tana valemami, mara malagha so na lei nimua camel.” ");
INSERT INTO nlg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mana ghairau te nia udukolu Laban moro tona tana valenadira. Ma rana nina mane lutu Laban te taluhorui na luludadira na camel, me hera na buburu ni vatei koli, me kutira. Keri ge ra lavia na beti vanira mai nina ghairau Abraham, maia na lei nina mane lutu ma kara saui na marevodira. ");
INSERT INTO nlg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Me gonidila tua na vanga ge bosa na mane, nina ghairau Abraham, “Ku mua vanga mua inau, polo ku diki bosaa ghua na hava na pukuna ge u sara mai iani.” Ge bosa Laban, “Tona haliu so na kokoe ighoe.” ");
INSERT INTO nlg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Keri ge bosa gaia, “Inau ke, a nina ghairau Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh te vautoa na vunaghigu, me nea ge mane logho rongo. Me hea ghua na ovu ni sheep, goat, mana buluka, maia ghua te subo na rongo ni silver mana gold, maia ghua na lei seka, na mane mana vaivine, camel mana donkey. ");
INSERT INTO nlg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, a tauna na vunaghigu, te vahua na gari mane vania tana bona te vinekama hau tua. Mana vunaghigu te sonihalavui vania nina lei totobo te loghoi. ");
INSERT INTO nlg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Me neu ge u papari kolua na baubahu, ge ku taonia na bosana. Ma eni gaia te bosaa vaniu, ‘Ko bei vilia vania siki tahula ni Canaan ke tauna dalegu. ");
INSERT INTO nlg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ko tona i tadira kulana vure tamagu. Itadira ko vilia na tahula ke tauna. ");
INSERT INTO nlg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mi nau tu ghoi huatia so na vunaghigu, ‘Ivei tea, keba mua liona niu udukolu mai na tahula ke?’ ");
INSERT INTO nlg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ge bosatughu gaia, ‘Yahweh tu taonia mu dolovia haia tua, ke vetenaa vanigho mai nina angel me ke negho ge ko tangomana. Keri ge ko lavia vania dalegu na tahula ke tauna itadira kulagu na vure tana vaivarina tamagu. ");
INSERT INTO nlg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mo ko ba tona itadira kulagu vure, ma kara mua talamu ke, keri ge ko tatavahale tana papari to nea.’ ");
INSERT INTO nlg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mi tana bona tu sara tua tana tuvu igeni ka, mu kokoeliulivuti, ‘Yahweh, nina God na vunaghigu Abraham, ko neu mai ge ku nia tangomana na hava tu nea eni. ");
INSERT INTO nlg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Inau tu tughuru iani, lilighina na tuvu eni, igaa kara heo beti na lei vaivine ni komu. Mu ku bosa vania sakai mu ghaghua, ‘Ko lubatiu ge ku inu.’ ");
INSERT INTO nlg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ma ge ke bosa tughu gaia, ‘Eo, ko inu, mu ku heo ghadira beti ghua nimua na camel.’ Vaho ge ku ghilala gaia tua keri na tahula to vilia ge ke tauna nimua na mane lutu Isaac.” ");
INSERT INTO nlg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mu mua soko mua na kokoeliulivuti inau, me va mai tua Rebekah te hola valaa na popovatu. Gaia te horu tana tuvu me heo betina nina popovatu, keri ge u bosa vania inau mu ghaghua, ‘Ko lubatiu ge ku inu.’ ");
INSERT INTO nlg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ma Rebekah te mina tua me huihorua na popovatu ni beti tana valana me lighia vaniu ge bosa, ‘Eo, ko inu, mu ku heo ghadira beti ghua nimua na lei camel.’ Keri ge u inu inau, me heo ghadira beti na lei camel ghua. ");
INSERT INTO nlg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mi nau tu huatia, ‘Ahei a tamamu?’ Me bosa tughu gaia, ‘Tamagu Bethuel daledira Nahor ma Milcah.’ Keri ge u pasulaghinia na ring tana ihuna te nia susuihu, mu hogholavaghinighi rana seli tana limana. ");
INSERT INTO nlg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mi nau tu tualaghi tuturu mu holohabaa Yahweh nina God na vunaghigu Abraham, te huli maemaneu mai tadira na lei vaivarina na vunaghigu, ge u sodoa na tahula, ke tauna dalena na vunaghigu. ");
INSERT INTO nlg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","?Keri ke, ko bosa vaniu, ko tatea sughua nimua na dolo vania na vunaghigu pe taho? Ko bosa vaniu ke ge ku ghilaa na hava ku ghoi nea.” ");
INSERT INTO nlg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ma Laban ma Bethuel toro bosa tughu, “?Yahweh te huligho mai iani, mana hava ghua kai ghoi bosaa iga ighai? ");
INSERT INTO nlg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah eni, ko lavia mo ko tona. Gaia ke tauna a dalena na vunaghimu, te vaghaa Yahweh te diki bosaa tua.” ");
INSERT INTO nlg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A nina ghairau Abraham te rongovighi na bosa raini ge tongaghi horu tana pari me holohabaa Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Keri ge talu horui na gold mana silver, mana tivi utoutoa me hea Rebekah, me hera ghua na balu dolo a tinana ma vaivinena Rebekah. ");
INSERT INTO nlg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Keri vaho ge vanga nulavi nina ghairau Abraham maia na lei mane toro nia udukolu, ge ra maturu. Mara rarai mai tana puipungi ge bosa na ghairau, “Koro lubatiu ge ku oli tua inau tana vunaghigu.” ");
INSERT INTO nlg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma tinana ma vaivinena Rebekah toro bosa, “E liomami a Rebekah ke ghoi kabu oli ghua e paregho na bongi ge ke tona.” ");
INSERT INTO nlg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ge bosa na ghairau, “Kau bei neghai gea ma kai ghoi kabu oli. Yahweh te nea tua nigua na sakutua ge u tangomana. Me liogu tua na oli taeni tana vunaghigu!” ");
INSERT INTO nlg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Rogaira toro bosatughu, “Holoa mai na tahula ma ka rongovia i tatana na hava ke bosaa.” ");
INSERT INTO nlg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Keri ge ro holoa Rebekah me mai ge ra huatia, “Ighoe to liona so ge ko tona kolua na mane eni?” Ma Rebekah te bosa tughu, “Eo, e liogu so na tona.” ");
INSERT INTO nlg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Keri vaho ge ra talana Rebekah, maia nina vaivine ghairau te righitaonia tana vahuana me sara itaeni, ge koro tona kolua nina ghairau Abraham ma rana udukolura. ");
INSERT INTO nlg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ma gaira tara hea didira vauto Rebekah nia na bosa raini, “Ighoe vaivinemami, tai nongia Yahweh te negho ge ko tinadira na mola ni tinoni, Me ke hangara na lei vaivarimu kara lagavulera ghadira na kana.” ");
INSERT INTO nlg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Keri ge gonidila ni tona Rebekah maia na lei nina vaivine ghairau ge ra haghelighi na lei camel, mara tona kolua nina ghairau Abraham, ma rana lei ghana udukolu. Ma gaira udolu tara sakutua ma ra tona. ");
INSERT INTO nlg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mi tana bona keri Isaac, te ghaha tana bona mamaha tara holoa nia Negev, te pulohi mai tana Beer-lahai-roi. ");
INSERT INTO nlg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Mi ta sakai na nulavi, Isaac te sakusaku tua tana leghai ge ghanaghana. Mi tana bona keri, me righira vaa na lei camel tara mai. ");
INSERT INTO nlg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tana bona Rebekah te righia Isaac, ge sogha horu sania na camel. ");
INSERT INTO nlg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Te huatia nina mane lutu Abraham, “Ahei na mane eni te sakutua mai tatada?” Me bosa tughu na ghairau, “Gaia na vunaghigu, Isaac.” Keri ge lavia na tivi a Rebekah me saroa nia na matana mana ihuna. ");
INSERT INTO nlg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mara saravia Isaac, nina ghairau Abraham te tutugui vania na lei totobo udolu te nei. ");
INSERT INTO nlg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Keri ge lavia Rebekah Isaac, me nia haghe tana vale tapole, nina vale tapole tinana Sarah, moro taulaghi tua. Ma Isaac te dolovia Rebekah, ge togholuvu a Isaac i murina te mate a tinana. ");
INSERT INTO nlg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ma Abraham te ghoi tauna sakai na vaivine, na ahana Keturah. ");
INSERT INTO nlg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Me vahura vania Abraham a Zimran, Jokshan, Medan, Midian, Ishbak ma Shuah. ");
INSERT INTO nlg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan a tamadira Sheba ma Dedan, ma rana vaivarina Dedan maira na lei kemana Asshur, Letush ma Leum. ");
INSERT INTO nlg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ma rana lei dalena Midian gaira a Ephah, Epher, Hanoch, Abida, ma Eldaah. Raini udolu gaira na vaivarina Keturah. ");
INSERT INTO nlg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham te sonihalavui vania Isaac dalena, na lei totobo te loghoi. ");
INSERT INTO nlg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mi tana bona te vola mua te hera na dolo vanira na lei dalena tara vahura na lei tauna ghua, me vetena tonara tana bona i ulu hauvia Isaac a dalena. ");
INSERT INTO nlg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ma Abraham te saravia, a sakai na hangalatu, vitu hangavulu lima (175) na niuluna ");
INSERT INTO nlg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ge mate, te tonikama tua, me kabu kolura na lei kulana tara mate tua. ");
INSERT INTO nlg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac ma Ishmael ra dalena, toro tavughia tana vatuluma i Machpelah, tana pile bona ni pari i uluna Mamre te nina Ephron dalena Zohar, tana kemana Het te padi. ");
INSERT INTO nlg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Gaia na bona keri te pelua tua Abraham itadira na vure ni kemana Het. Igaa toro tavughia Abraham lilighina na bona tara tavughia tua Sarah na tauna. ");
INSERT INTO nlg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mi murina te mate tua Abraham, God te vautoa Isaac dalena, me ghahaa lilighina Beer-lahai-roi. ");
INSERT INTO nlg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Raini na lei vaivarina Ishmael dalena Abraham itatana Hagar na vaivine ni Egypt, te nina seka Sarah. ");
INSERT INTO nlg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Gaia a tamadira na lei mane raini te vuivuni tana kamanagho ritini tana sosoko, na ahadira ini, Nebaioth, Kedar, Abdeel, Mibsam, ");
INSERT INTO nlg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO nlg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish ma Kedemah. ");
INSERT INTO nlg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Gaira raeni na vunaghidira ra hangavulu rua na kema, na ahadira tara vatui nia na lei komudira, mana lei bona tara kabu pile igaa. ");
INSERT INTO nlg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael te saravia sakai na hangalatu tolu hangavulu vitu (137) na niuluna ge mate. ");
INSERT INTO nlg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Na lei vaivarina tara ghahara tana bona ighobudira i Havilah mi Shur, tana halautu te sara i uluna Egypt me tona va i Asshur. Gaira tara kabu hauvira na balu vaivarina Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aeni na tutuguna Isaac dalena Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Mi tana bona Isaac te vati hangavulu na niuluna me tauna Rebekah, na vaivine eni a dalena Bethuel, na mane ni Aram, tana komu Padan-aram, na vaivinena Laban. ");
INSERT INTO nlg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Me mua tangomana na logho gari a Rebekah, keri ge Isaac te kokoeliulivuti vania Yahweh ge ke tangomana vania. Ma Yahweh te rongovia nina kokoeliulivuti Isaac, ge logho gari a Rebekah. ");
INSERT INTO nlg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mana baso vunaghi lokana na kutuna tinadira. Mara mua vahura mua, moro veipipilighi lokana na kutuna Rebekah. Ma Rebekah te huatia Yahweh, “E ghua ge kaleu na totobo te vaghaa eni?” ");
INSERT INTO nlg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahweh te bosa tughu vania, “Erua na kema ilokana na kutumu, Mo ko vatura erua na butonikomu toro veihughuhughui. Sakai na kema ke laga vulea sakai, Mana tughana ke lutu vania na tahina.” ");
INSERT INTO nlg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Me sara nina bongi ni vahuhu a Rebekah, ge vahura na baso vunaghi. ");
INSERT INTO nlg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Na diki te malasisia me vuvulua na hulina, keri ge ra holoa nia Esau. ");
INSERT INTO nlg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na ruani tara vahua mai te tabe ngasilia na borokasi ni tuana Esau. Keri ge ra holoa nia Jacob. A Isaac, na tamadira te ono hangavulu na niuluna tana bona toro vahura na baso raini. ");
INSERT INTO nlg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mi tana bona toro sule dato na gari raini ke, ma Esau te ghilala utoa na hili maumanu, te liona ngangata na vola ni tautalu. Ma Jacob te hodohodo me kabu komu vamua. ");
INSERT INTO nlg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ma Isaac te dolovia va Esau, na pukuna na vihahi ni maumanu te lavighi mai ge ke ghanighi. Ma Rebekah te dolovia va Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mi ta sakai na bongi a Jacob te kukia na supusupu me oli mai tana hili a Esau ge toroa na vitolo, ");
INSERT INTO nlg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","me bosa vania Jacob, “Inau te torou na vitolo mo ko heu mai na pile supusupu te sisi to kukia!” (Keri ge rana vure tara holoa nia Esau eruani na ahana Edom). ");
INSERT INTO nlg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob te bosa tughu, “Ko heu mughua nimua na tunuva ni kamanagho ge ku hegho na pile supusupu.” ");
INSERT INTO nlg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau te bosa, “E uto so! Inau te toro mateu na vitolo, mu ku mate ke, ma kara mua hangau na lei totobo raini!” ");
INSERT INTO nlg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ge bosa Jacob, “Ko diki baubahu vaniu tua itaeni, ge ko heu sughua na tunuvamu.” Me baubahu Esau vania Jacob, ge hea na tunuvana ni kamanagho vania Jacob a tahina. ");
INSERT INTO nlg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Keri vaho gea Jacob te hea Esau na balu supusupu, mana balu berete. Esau te vanga me inu, ge ke tughuru me tona. Keri ke, gaia te mua ghanaghana mavaa na tunuva ni kamanagho. ");
INSERT INTO nlg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ma sakai na ngengere sule te ghoi kalea na butonikomu udolu vaghaa te kale tana bongina Abraham. Keri ke, ma Isaac te gharadu vaa i Gerar, te ghahaa igaa a Abimelech, didira na vunaghi haba rana vure ni Philistia. ");
INSERT INTO nlg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahweh te tate vania Isaac, ge bosa vania, “Ko bei tona i Egypt! Ko kabu tua tana pari eni tu bosaa vanigho ko kabu igaa. ");
INSERT INTO nlg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ko ghanagho tua iani, mi nau ku kabu kolugho mu ku vautogho. Inau ku hegho na bona udolu eni, maia ghua rana vaivarimu. Inau ku pangotia na baubahu tu nea vania tamamu Abraham. ");
INSERT INTO nlg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Inau ku nera na lei vaivarimu ge kara subo vaghara na veitughu tana parako, mu ku hera udolu tua na bona eni. Mi tadira na lei vaivarimu ku vautora na lei kema ilokana na maramana. ");
INSERT INTO nlg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Inau ku vautogho na pukuna Abraham te varongohia na bosagu me taonighi nigua na lei vetena mana keikeri.” ");
INSERT INTO nlg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Keri ge ghahaa i Gerar a Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mana lei mane ni komu keri tara huatia Isaac nia a tauna, ge bosa vanira, “Aeni ke vaivinegu,” na pukuna te mataghunira na lei mane kara matea gea ma kara lavia Rebekah, te vaivine matakage gaia. ");
INSERT INTO nlg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Me daro na bona tua te ghahaa i Gerar Isaac. Mi ta sakai na bongi na vunaghi haba Abimelech te gena horu mai tana matakene na valena me righia Isaac te avihia Rebekah. ");
INSERT INTO nlg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech te vetenara ge ra lavia Isaac mai tatana, ge bosa vania, “A taumu na vaivine keri ge! ?Me ghua ge o bosa ke na vavinemu gaia?” Ge bosa tughu Isaac, “Inau tu ghanaghana ke, ma kara mateu gea ge u bosaa te taugu gaia.” ");
INSERT INTO nlg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Me bosa Abimelech, “?Na hava to nea vanighai? Ma ge siki sakai tadira nigua na mane lutu kara nia maturu kolu taumu ke, ighai ke kaleghai nia na palu sule, na pukuna ighoe.” ");
INSERT INTO nlg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Keri ge Abimelech te bosa papara vanira kulana na vure, “Siki sakai ke gonidikalaa siki totobo hahi vania na mane eni pa tauna ke, me ke mate mughua.” ");
INSERT INTO nlg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mi tana niulu keri Isaac te umania na leghai tana pari me subasubaa iga, mana vuavua te subai tara vangagha subo ngangata na pukuna Yahweh te vautoi. ");
INSERT INTO nlg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A nina lutu te tona haliu so na uto, me nea ge vuha mane logho rongo. ");
INSERT INTO nlg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Na pukuna te subo nina ovu ni sheep mana buluka mana mane lutu ghua, ge ra vuha nia ghaghana na vure ni Philistia. ");
INSERT INTO nlg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Keri ge ra parikuvighi na tuvu tara ghelighi nina mane lutu Abraham tana bona te vola mua. ");
INSERT INTO nlg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ma Abimelech te bosa vania Isaac, “Ko rughuhoru tana komumami eni, na pukuna to mane rongagha ngangata, to laga mo maana vuleghai tua.” ");
INSERT INTO nlg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Keri ge tona Isaac me va gonighi na lei vale tapolena tana boboko i Gerar me ghahaa iga. ");
INSERT INTO nlg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Gaia te ghoi ghelighi na tuvu tara diki ghelighi mai tua tana bongina Abraham i dania. Na vure Philistia tara pari kuvighi na tuvu kiri i murina te mate tua Abraham. Ma Isaac te ghoi holoi nia so na lei tuvu, vaghai te holoi nia tua Abraham tamana idania. ");
INSERT INTO nlg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nina mane lutu Isaac tara ghelia sakai na tuvu tana boboko mara sodoa na beti gaa. ");
INSERT INTO nlg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma rana righitaoni sheep ni Gerar tara hughuhughu kolura rana righitaoni sheep ta Isaac mara bosa, “A nimami na beti eni.” Keri ge Isaac te holoa nia na tuvu keri na aha, “Esek.” ");
INSERT INTO nlg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ma rana mane lutu ta Isaac tara ghoi ghelia sakai na tuvu ghua, ma rana vure iga tara nia hughuhughu so, ge holoa nia “Sitnah.” ");
INSERT INTO nlg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Gaia te ghoi gharadu sania na bona keri, ma rana mane lutu tara ghoi ghelia sakai na tuvu. Rana vure iga tara mua nia hughuhughu, keri ge holoa nia, “Rehoboth.” Keri ge bosa gaia, “Yahweh te heghita na bona malagha ge ka ghanaghita, ma ka tangomana tana kaukabuda.” ");
INSERT INTO nlg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mi murina keri, Isaac te sania na komu keri me tona i Beersheba. ");
INSERT INTO nlg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mi tana bongi keri Yahweh te tate vania ge bosa, “Inau, a nina God tamamu Abraham. Ko bei mataghu, inau itamua so. Inau ku vautogho mu ku negho ge ke sepa na vaivarimu taonia nigua na baubahu vania nigua na mane lutu a Abraham.” ");
INSERT INTO nlg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ma Isaac te kisua na bela sukaghi ge holohabaa Yahweh iga. Gaia te gonighi na lei vale tapolena me kabu igaa, ma nina mane lutu tara ghoi ghelia sakai na tuvu. ");
INSERT INTO nlg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ma sakai na bongi na vunaghi haba Abimelech te mai, kolua Ahuzzath nina mane huhuli, ma Phicol, na mane naghodira nina ovu ni gehemate. Tara tughuru i Gerar mara va righia Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ma Isaac te huatira, “?Vaho ghua ge au mai righiu itaeni? Te padu tua, tau kanahaghiniu, ma au tiva kehau tana komumiu.” ");
INSERT INTO nlg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mara bosa tughu gaira mara ghaghua, “Ighai tai ghilala itaeni Yahweh itamua, mai ghanaghana ke, me uto ge ka baubahu i ghobuda hegheda. Ighai tai liona ko baubahu vanighai, ");
INSERT INTO nlg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ge ko bei vahaghitailighai vaghaa tai mua vahaghitailigho ighoe. Tai arovigho, ge ai vetena kehagho tana mabo. Mi taeni tai righi kalea Yahweh te vautogho sughua.” ");
INSERT INTO nlg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ma Isaac te gonia na vanga kolu vanira, ma gaira kolua gaia tara vanga mara inu. ");
INSERT INTO nlg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Me roropo ghana sopa gaira tara baubahu mara ngasilia nia na papari. Keri ge bahura Isaac me sanira ge ra oli tana komudira tana mabo. ");
INSERT INTO nlg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mi tana bongi keri ghua, nina mane lutu Isaac tara mai bosaa vania nia na tuvu tara ghelia. Mara ghaghua, “Ighai tai topoa tua na beti.” ");
INSERT INTO nlg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ma Isaac te vatua na tuvu keri nia na aha, “Shibah.” Keri te vaghaa ge lavia na aha Beersheba na komu keri. ");
INSERT INTO nlg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Me vati hangavulu na niuluna Esau me taudira e rua na vaivine tana vure ni kemana Het, Judith, dalena Beeri, ma Basemath dalena Elon. ");
INSERT INTO nlg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Na nilabudira rana vaivine raini te nera na voladira a Isaac ma Rebekah ge ro mua togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tana bona Isaac te tonikama tua, me dutu vania ge ke rorodo, gaia te holoa Esau na diki dalena na kamanagho, me ghaghua, “?Kula dalegu?” Ma Esau te bosa tughu me ghaghua, “?Na hava Tamagu?” ");
INSERT INTO nlg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma Isaac te ghaghua, “Inau tu tonikama tua, mu mua ghilala ke daro na volagu. ");
INSERT INTO nlg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Keri ge ko lavighi nimua na baghe mana kuali, mo ko tona tana tautalu, mo ko hilivia vaniu mai siki maumanu asi. ");
INSERT INTO nlg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ko gonidila vaniu na vanga te liona na liogu me ke loghoa na nainami te uto. Mo ko lavia vaniu mai, mu ku ghania. Keri ge ku vahegho na vauto, ke vanigho ighoe na dalegu na kamanagho naghona ge ku mate.” ");
INSERT INTO nlg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma Rebekah te rongovia na hava Isaac te bosa vania Esau. Mi tana bona Esau te rughuhoru ge ke va hilivighi mai na maumanu asi, ");
INSERT INTO nlg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ma Rebekah te ghaghua vania na dalena Jacob, “Inau tu rongovia na tamamu te bosa vania Esau, me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tona mo ko va matea siki maumanu asi, mo ko gonidila vaniu na puku ni vanga te uto. Mi murina ku ghania, eliogu ge ku vautogho tana matana Yahweh i naghona ge ku mate.’” ");
INSERT INTO nlg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebekah te bosa so, “Kula dalegu, itaeni ko goni taonia na hava tua ku bosaa vanigho. ");
INSERT INTO nlg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ko tona rughuhoru va tana lei ovu ni volivoli ni maumanu mo ko lavighi vaniu mai erua na dale goat vaolu. Inau ku gonidila vania tamamu na vanga te uto ngangata te liona tana goat raeni. ");
INSERT INTO nlg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mo ko lavighi na vanga raeni vania tamamu, ma gaia ke ghanighi ge ke va hegho na vauto tughua a Esau inaghona ge ke mate. ");
INSERT INTO nlg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Jacob te bosa tughu, “Kula Tinagu, e mua malumu koro pegoa na tamagu. Ko ghanaghana va ivei te vagha na vuvuluna na hulina Esau maia ivei te vagha na madolona na ghuighuligu inau. ");
INSERT INTO nlg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","?Ivei ke ghaghua ke vagha ke tabeu a tamagu? Agaia ke ghilala kalea inau tu pegoa, ma gaia ke varangau vamua me ke mua heu na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma Rebekah te ghaghua, “Dalegu tu dolovigho, lubatia na vavaranga keri ge ke tumu ivuvungagu. Mo ko gonia vamua na hava tu bosaa vanigho. Ko tona mo ko lavighi mai na goat.” ");
INSERT INTO nlg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Keri ge Jacob te taonighi na lei kokoe te bosai vania tinana, me holai vania mai ra rua na goat. Ma tinana te lavighi rana goat, ge gonia na puku ni vanga te vagha te liona Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ma gaia Rebekah te lavia nina na puku ni pupulu Esau te ghahai tua ilokana na vale tapole me pupulua nia Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Me saroi na limana mana luana Jacob nia na ghuighuli ni goat te vuvulugha. ");
INSERT INTO nlg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ma Rebekah te hea na popo ni vanga, te uruurua ngangata, maia na balu berete tara vaho bitighi. ");
INSERT INTO nlg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ma Jacob te lavia na popo ni vanga vania tamana me ghaghua, “?Kula Tamagu?” Ma Isaac te bosa tughu me ghaghua, “Eo! ?Ahei eni? ?Esau pa Jacob?” ");
INSERT INTO nlg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ma Jacob te bosa tughu, “A Esau na dalemu na kamanagho. Aeni tua na maumanu asi. U goni taonia tua na hava to bosaa vaniu nia, me momoha tua. Ko sopou dato mai mo ko vanga, ge ko vaheu nimua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma Isaac te huahuati, “?Kula dalegu, ivei te ghaghua ge o tangomana na sodo minaminaana?” Ma Jacob te bosa tughu, “Na pukuna a Yahweh, nimua na God, te hangau ge u sodo minaminaa.” ");
INSERT INTO nlg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ma Isaac te ghaghua vania Jacob, “Ko tughuru ghalagha mai iani. Eliogu ge ku tabegho ge ku taluutunia to Esau utuni sughua.” ");
INSERT INTO nlg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ma Jacob te tona ta tamana, ma Isaac te tabea. Ma Isaac te bosa heghena, “Na kokoe te vagha na kokoena Jacob, hauva na limana te vuvulugha te vagha Esau.” ");
INSERT INTO nlg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Me mua ghilala pukulaghinia te Jacob, na pukuna na limana Jacob tara vaghai sono na limana Esau tara vuvulua. Keri ke, Isaac te dutu ni vautoana Jacob, ");
INSERT INTO nlg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","me huatia, “?Na puku ni dalegu a Esau sughua ighoe?” Ma Jacob te bosa tughu, “Eo, inau utuni!” ");
INSERT INTO nlg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Keri ge ghaghua Isaac, “Kula dalegu, ko lavia vaniu mai na vinahina na maumanu ge ku vanga ge ku vahegho nigua na vauto.” Ma Jacob te lavighi na vanga va ta tamana, ma Isaac te ghanighi. Me inuvia ghua na wine a Jacob te gonidilaa vania. ");
INSERT INTO nlg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Keri ge ghaghua Isaac, “Kula dalegu, ko mai tagua mo ko nonginongiu.” ");
INSERT INTO nlg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ma Jacob te va tona me nonginongia. Mi tana bona te urumighi na lei pupuluna, Isaac te taluutunia ge vautoa na dalena, me ghaghua, “Na uruuruna na dalegu te vagha na uruna na leghai te va vautoi tua Yahweh. ");
INSERT INTO nlg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mi nau ku nongia God ke va hegho mai na kebu ge ke volai nimua na lei subasuba, ge ko loghoa na puku ni baore te hali tana lei nimua na subasuba mana lei grape tara gonighi nia na wine. ");
INSERT INTO nlg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Rana lei kema kara nimua na vure ni lutu, ma kara taonia na hava to bosaa. Mi ghoe ko vunaghi pungisira na lei hoghomu. Rana lei vaivaridira tinamu kara nigho kikinima. Ma rahei tara bosa kaugho, God ke bosa kaura. Ma rahei tara vautogho, God ke vautora.” ");
INSERT INTO nlg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mi tana bona Isaac te vauto sokoa vaso Jacob, me ke rughu horu sania tamana, Esau te pulohi mai ta nina na rughuhoru ni hili. ");
INSERT INTO nlg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau te gonidila vania tamana na puku ni vanga te liona, na vinahina na maumanu asi, me lavia va ta tamana. Ge ghaghua gaia Esau, “Kula tamagu, inau tu mai tua, mi nau tu lavia mai na maumanu asi to liona. Ko sopou dato mai mo ko ghania, keri ge ko vaheu nimua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ma Isaac te huatia gaia, “?Ahei ighoe?” Ma gaia te bosa tughu, “Inau a Esau, na dalemu na kamanagho.” ");
INSERT INTO nlg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ma Isaac te tatata me kanoragha, ge ghaghua, “Ma hei vaso ka, te vaheu na maumanu asi, mu ghania vaso? Mu vautoa tua gaia nia na puku ni vauto, keri ge o mai ighoe. Ma God ke vautoa gaia, na pukuna ku mua tangomana na tughuana nigua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mi tana bona Esau te rongovia na tamana, gaia te tangi ngangaraha, me kurutia tamana me ghaghua, “Kula tamagu, ko vautou mai ghua inau!” ");
INSERT INTO nlg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mana tamana te vania, “A hoghomu te pegou me lavi kehaa tua nimua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ma Esua te bosa, “E utuni sughua na ahana ke, Jacob, na pukuna erua tua na tughuru ni gitoagu tana lei lologho. Na diki te lavia nigua na tunuva ni kamanagho, mi taeni te lavia nigua na vauto. ?Mi vei tea o talukehaa vaniu sono sakai na vauto?” ");
INSERT INTO nlg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ma Isaac te bosa vania Esau me ghaghua, “U talua tua Jacob ge ke nimua na vunaghi haba mu tughuniladaa tua ge na lei kulana vure kara nina vure ni lutu. Mu baubahu vania ge gaia ke lologho au vule tana subasuba mana wine kara subo vaa. ?Mana hava iga ke ghoi hagha vanigho?” ");
INSERT INTO nlg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma Esau te nongia sono a tamana me ghaghua, “E taho tua sakai na vauto ke ghana olia vaniu? Kula tamagu, ko vautou ghua inau.” Ma Esau te tangi me dikalio. ");
INSERT INTO nlg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Keri ke, Isaac te ghaghua vania, “Ighoe ko kabu hauvia tana pari uto, mo ko hauvia ghua na uha uto te butu mai ikokou. ");
INSERT INTO nlg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mi ghoe ko nia vola na isi. Mi ghoe ko lutu vania a hoghomu. Hauva, mi tana bona ko luba sania, ge ko tatavahale itatana.” ");
INSERT INTO nlg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Keri ke, Esau te nia ghighirou a Jacob na pukuna te gitoa nina na vauto. Keri ge ghaghua tana ghanaghanana heghena, “A tamagu ke mua hau me ke mate, ma ka nia tangimate. Tana bona na posabongi ke soko, mi kakeri vaho ge ku labumatea Jacob.” ");
INSERT INTO nlg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ma siki sakai te rongovia na hava te bosatatea Esau, ge va tughunia vania Rebekah. Ma gaia te holoa mai Jacob, ge bosa vania, “A Esau te ghanaghana ge ke lavitughugho, me ke labu mategho. ");
INSERT INTO nlg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Aeni na hava ko gonia. Ko sogha polo va ta vaivinegu Laban te hagha i Haran. ");
INSERT INTO nlg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ko kabu kolua polo ke soko nina lei ghanaghana dika Esau itamua. ");
INSERT INTO nlg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tana bona vaho ke nighi ponolio na lei totobo to gonighi vania, ge ku bosa vanigho gatu. Na hava na pukuna ge ku sanighau iroghau udolu ta sakai na bongi vamua?” ");
INSERT INTO nlg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ma Rebekah te ghaghua vania Isaac, “Inau to nia vahaghitaili mu nia lugu nigua na lei vinekama voo ni kemana Het. Ke vagha Jacob ke tauna siki sakai tadira, e manana ku mate nigua vaso ge ku mua ghoi righia.” ");
INSERT INTO nlg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Keri ke, Isaac te holoa Jacob, ge vautoa me vania, “Ko bei tauna gea siki sakai tadira rana lei vaivine ni Canaan raini. ");
INSERT INTO nlg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hauva, ko tona tua i Paddan-aram, tana valena kukuamu Betheul, mo ko tauna sakai na dalena vaivine a tubumu Laban. ");
INSERT INTO nlg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ma God puku ni maana ke vautogho me ke va hegho na sonihalavu ge ko vahura na lei gari subo. Mana lei vaivarimu kara puputu ni ovu subo ni kema sule. ");
INSERT INTO nlg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ma God ke talua ivuvungamu ma rana vaivarimu na vauto te nia baubahu vania Abraham. Mi ghoe ko loghoa na bona eni toro sinogho mai iga iroghita itaeni, na pukuna God te va hea tua Abraham.” ");
INSERT INTO nlg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ma Isaac te nia vetena Jacob, ma gaia te tona i Paddan-aram me kabu kolua a tubuna Laban, na vaivinena tinana, na dalena Bethuel tana kemana Aram. ");
INSERT INTO nlg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ma Esau te rongovia gaia tamana te vautoa Jacob me nia vetena tona i Paddan-aram, ge ke va lavia iga na tauna, maia te hove pungisia Jacob ge ke bei tauna gea siki vaivine ni Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Me ghilala ghua sono gaia a Jacob te taonira na tinana mana tamana ge ke tona i Paddan-aram. ");
INSERT INTO nlg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ma Esau te righikalea gaia tamana te nira sika na lei vaivine ni Canaan raini. ");
INSERT INTO nlg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Na pukuna keri, gaia te va kaoa nina binaboli a tubuna Ishmael, me tauna a sakai na dalena na vaivine a Ishmael, na dalena Abraham, kolua nia na lei tauna te kabukolura tua. Mana ahana na vaivine vaolu te tauna ke a Mahalath, agaia na vaivinena Nebaioth. ");
INSERT INTO nlg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mi tana bona vaghana keri, Jacob te rughuhoru sania i Beersheba me tona potaa Haran. ");
INSERT INTO nlg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tana huu ni aho gaia te va sara ta sakai na bona te uto, me kabu beto kakeri vania na bongi. Ma Jacob te kenea na vatu ge ke nia ulunga me koli horu, ge maturu. ");
INSERT INTO nlg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mi tana bona te maturu agaia te righia na mabubuna na lata te vuivuni iani maramana ma sara ikokou. Me righira nina angel God tara dato mara horu igaa. ");
INSERT INTO nlg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mi kokou sosokona na lata keri agaia Yahweh te tughuru ge ghaghua, “Inau na Yahweh, ma God nina na kukuamu Abraham, ma God nina tamamu Isaac. Mana bona to koli iga itaeni ke animua. Inau ku vahegho mara rana lei vaivarimu. ");
INSERT INTO nlg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mana lei vaivarimu kara subo te vagha na pughu ni pari tana maramana. Gaira kara sepalaghi ta didira na lei bona te vuivuni uluna mi bokona, mi launa mi longana, mana lei kema tana maramana ku vautora na pukuna ighoe mana lei vaivarimu. ");
INSERT INTO nlg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Inau ku kabu kolugho mu ku pilupungisigho ivei tua ko va igaa. Inau, ta siki dani ku lavi oli tatavahalegho mai tana bona eni. Inau itamua talau polo ge ku soko na heamu na lei totobo tu nia baubahu na heamu.” ");
INSERT INTO nlg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ma Jacob te rarai, ge ghaghua, “E utuni sughua a Yahweh te kabu tana bona eni, mi nau tu mua ghilala.” ");
INSERT INTO nlg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma gaia te mataghu ge ghaghua, “Na bona eni te vatei mamataghugha! Aeni na valena God sughua, na mataula haghe va ikokou.” ");
INSERT INTO nlg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mi tana roropo ghana Jacob te mina me tapatughuru. Ma gaia te lavia na vatu te nia ulunga ge tughuruvaghini datoa te vaughilala nia na vatei ghanaghana oliana, keri ge lavia na kokolo ni olive me vulia nia. ");
INSERT INTO nlg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Me holoa nia bona keri Bethel, sakai vamua na ahana na komu te dutuvia na bona keri i Luz. ");
INSERT INTO nlg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ma Jacob te gonia nina na baubahu eni, “Ge ke vagha ighoe God ko kabu koluu mo ko pilupungisiu tana tonatona eni, mo ko vaheu na vanga mana pupulu, ");
INSERT INTO nlg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma ge ko lavi oli tatavahaleu va ta tamagu ke, mi nau ku negho Yahweh, ge ko nigua na God. ");
INSERT INTO nlg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mana vatu ni vatei ghanaghana oli eni ke, na bona rana vure tara holohaba iga God. Mi nau ku nia heveioli vanigho e hangavuluni na lei totobo ko vaheu mai. ");
INSERT INTO nlg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ma Jacob te tona so, me va haghe tana butonikomu iulu. ");
INSERT INTO nlg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ma gaia te vaevanea va ihalahau e tolu na ovu ni sheep tara koli tana bona oka lilighina na tuvu. Ma rana righitaoni sheep tara hera na beti ga vanira na lei sheep, mana vatu te mava ngangata te pungisia na matana na tuvu. ");
INSERT INTO nlg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mana vetena iga ikakeri ke, na lei ovu ni sheep udolu mughua kara mai sara ge kara lavikehaa na vatu. Mi murina kara hera tua na beti, gaira kara ghoi taovaghiniolia na vatu tana matana na tuvu. ");
INSERT INTO nlg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ma Jacob te va tona itadira rana righitaoni sheep ge huatira, “?Ivei tau haghaghau?” Ma gaira tara ghaghua, “I Haran.” ");
INSERT INTO nlg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Gaia te huatira, “?Ivei te ghaghua au ghilala so sakai na tinoni ikakeri na ahana Laban na kukuana Nahor?” Ma gaira tara bosa tughu, “Eo, ai ghilalaa so.” ");
INSERT INTO nlg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma Jacob te huatira, “?E vola uto so?” Ma gaira tara bosa tughu, “Gaia te vola uto so. Ko righia va, gaia na dalena Rachel te nira mai na lei sheep.” ");
INSERT INTO nlg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ma Jacob te huatira, “Itaeni te danikama mua. E mua na bona ni aho mua ge kau savukolura na lei sheep te vagha ge kara aheahe vania na nulavi. ?Na hava na pukuna ge au mua hera ghadira beti na sheep, ge kara pulohi tana bona kara vanga iga?” ");
INSERT INTO nlg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mara ghaghua gaira, “Kai mua tangomana na boki kehaana na vatu mana va heghedira beti polo kara ghaha udolura iani na lei sheep maia rana lei righitaoni sheep.” ");
INSERT INTO nlg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mana tutugu te tona haliu so, Rachel te nira sara mai nina na sheep a tamana na pukuna agaia na righitaoni sheep. ");
INSERT INTO nlg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mi tana bona Jacob te righia Rachel, na dalena Laban, na vaivinena tinana, mana pukuna na sheep tara nina tubuna, Jacob te tona tana tuvu me boki kehaa na vatu me hera na beti nina na ovu ni sheep a tubuna. ");
INSERT INTO nlg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Keri ge Jacob te nonginongia Rachel, mana kolobu te mai tana matana na pukuna te togotogo sule ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ma gaia te tughunia vania, “Inau na kulana vure na tamamu. Inau Jacob na dalena Rebekah.” Ma Rachel te mina sama tona tana tamana Laban ge bosa vania na hava te rongovia. ");
INSERT INTO nlg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mi tana bona Laban te rongovia na rongorongona Jacob, na dalena vaivinena, gaia te rughuhoru ge ke va topoa, me nonginongia. Ma Laban te lavia va tana valena, ma Jacob te bosa vania na lei totobo te kalea. ");
INSERT INTO nlg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ma Laban te ghaghua, “Eo, ighoe sughua na puku ni vinahigu mana ghabugu heghegu. Ma Jacob te ghahaa itatana tubuna, Laban, ta sakai na vula. ");
INSERT INTO nlg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ma Laban te ghaghua vania, “Ko mua tangomana na lutu vaniagu ge ko mua lavia na taba na pukuna ighoe na kulagu. ?Me ngiha te liomu ge ku pelugho nia?” ");
INSERT INTO nlg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma Laban te loghora ara rua dalena na vaivine, Leah na kamanagho ma Rachel na tahina. ");
INSERT INTO nlg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah te loghoi na mata marabu, ma Rachel te ghaugharugha me matakage. ");
INSERT INTO nlg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Mana pukuna Jacob te dolovia tua Rachel, keri ge bosa vania tua tamana, “Inau ku lutu vanigho e vitu na niulu ge ighoe ko heu tua Rachel ke taugu.” ");
INSERT INTO nlg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ma Laban te bosatughu ge talamaghi, “Inau ku va hegho ighoe ku mua vahea na keha te mua ghaha ilokana na binaboli.” ");
INSERT INTO nlg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Keri ge Jacob te lutu so e vitu na niulu na peluna Rachel. Ma nina dolo vania te laga ngangata, te vagha te mua daro vania na lei niulu rakiri. ");
INSERT INTO nlg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Me sara tua na bona ge koro taulaghi, ma Jacob te ghaghua vania Laban, “Ko heu mai Rachel ge koro taulaghi na pukuna tu sokoa tua nigua na lutu.” ");
INSERT INTO nlg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ma Laban te holokolura na ghana na komukolu ge kara mai tana gougonu ni taulaghi ta Jacob ma Rachel. ");
INSERT INTO nlg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mi tana bongi keri, tana bona te pungi tua, Laban te lavia Leah vania Jacob, ma gaia te maturu kolua. ");
INSERT INTO nlg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ma Laban te vahea Leah a sakai na seka, a Zilpah, ge ke nina ghairau. ");
INSERT INTO nlg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mi tana puipungi ghana te rarai a Jacob, agaia te righi kalea a Leah. Ma Jacob te rutu vania Laban, “?Na hava na pukuna ge o pegou? Inau tu lutu vanigho ra vitu na niulu vania Rachel! ?Mana hava to ghanaghanaa ge o pegou?” ");
INSERT INTO nlg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ma Laban te bosa tughu, “E mua dida na vetena ge ke diki taulaghi na kamamuri tatana na kamanagho. ");
INSERT INTO nlg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mo ko pitu koekobe kara padi ra vitu na bongi tana gougonu ni sonikolu, ge ko tauna Rachel. Hauva, mo ko ghoi baubahu vaniu mughua ge ko lutu vaniu ra vitu na niulu.” ");
INSERT INTO nlg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ma Jacob te talamaghi ge ke ghoi lutu so e vitu na niulu. Me vitu tua na bongi murina toro taulaghi a Jacob ma Leah, Laban te hea so ghua a Rachel. ");
INSERT INTO nlg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma Laban te hea Rachel sakai na seka, na ahana Bilhah, ge ke nina ghairau. ");
INSERT INTO nlg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ma Jacob te maturu kolua ghua Rachel, me dolovi ngangata va vulea Leah. Ma gaia te ghoi lutui ra vitu na niulu vania Laban. ");
INSERT INTO nlg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mana pukuna Jacob te dolovia Rachel haba vulea va Leah, Yahweh te lubatia Leah ge ke logho gari, ma Rachel te mua logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ma Leah te logho gari me vahua na dalena na mane. Me ghaghua gaia, “Yahweh te ghilala nigua na vahaghitaili, mi taeni na taugu ke doloviu.” Keri ge holoa nia Reuben. ");
INSERT INTO nlg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mi murina keri te ghoi logho gari so, me ghoi vahua na dalena na mane. Me holoa nia Simeon, na pukuna gaia te ghaghua, “Yahweh te rongovia ge na taugu te mua doloviu, ma gaia te ghoi heu mai eruani na dalegu.” ");
INSERT INTO nlg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Me Leah te ghoi logho gari so, me vahua sakai na mane me holoa nia Levi, na pukuna gaia te ghaghua, “E utuni itaeni a taugu ke doloviu tua, na pukuna tu vahua vania tua ara tolu dalena na mane.” ");
INSERT INTO nlg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma gaia te ghoi logho gari sono, me vahua na dalena na mane me holoa nia Judah, na pukuna gaia te ghaghua, “Itaeni inau ku holohaba Yahweh.” Ma gaia te beto tua na logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mi tana bona Rachel te righia te mua tangomana na logho gari, gaia te ghaghana vania tughana. Me bosa vania Jacob, “E liogu na logho dalegu, taho ke, mu ku mate nigua vaso.” ");
INSERT INTO nlg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ma Jacob te rutu, ge huatia me ghaghua, “?Inau ke a God? Agaia God heghena vamua ke tangomana na lubatiamu ge ko logho gari.” ");
INSERT INTO nlg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ma Rachel te bosa vania, “Ko maturu kolua nigua na ghairau Bilhah, ma gaia ke vahua na gari vaniu.” ");
INSERT INTO nlg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Keri ge Rachel te vahea Bilhah ge ke tauna, ma Jacob te maturu kolua. ");
INSERT INTO nlg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma Bilhah te logho gari, ge vahua na dalena na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel te bosa, “God te dete maemaneu, maia te rongovia nigua na nongi ge vaheu mai na garimane eni,” na pukuna keri gaia te holoa nia Dan. ");
INSERT INTO nlg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Me Bilhah te ghoi logho gari sono, me ghoi vahua vania Jacob eruani na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel te holoa nia Naphtali, na pukuna gaia te bosa, “Inau tu logho ngangataa na hughuhughu sule itatana tughagu mi nau tu laga vulea.” ");
INSERT INTO nlg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mi tana lei bona vaghai raini, Leah te ghilala ke mua ghoi logho gari tua, ma gaia te vahea nina na ghairau, Zilpah, vania Jacob ge ke tauna. ");
INSERT INTO nlg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Me mua hau mua a Zilpah te vahua vania sakai na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah te bosa, “Ivei vaho tua te vagha na uto ia tu loghoa,” na pukuna keri ge holoa nia Gad. ");
INSERT INTO nlg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ma Zilpah te ghoi vahua so eruani na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ma Leah te holoa nia Asher, na pukuna te ghaghua gaia, “Na togotogo tu loghoa mana lei vaivine kara ghanaghanaa tu togotogo ngangata.” ");
INSERT INTO nlg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mi ta sakai na dani tana bona ni hinava ni wheat, Reuben te sodoi balu na ghai tara holoi nia na mandrake tana leghai me vahea tinana Leah. Ma Rachel te nongia Leah, “Ko vaheu na balu.” ");
INSERT INTO nlg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma Leah te rutu ngangata me ghaghua, “?Ivei te ghaghua e mua manana mua to pongoa tua na taugu? Itaeni to liona ge ko ghoi lavipoloi so anina na mandrake na dalegu!” Ma Rachel te ghaghua, “Inau tu lubatia vanigho Jacob, ge ke maturu kolugho tana bongi geva ke tughua na lei mandrake tu holai.” ");
INSERT INTO nlg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mi tana nulavi keri, tana bona te vaho oli mai a Jacob tana leghai, Leah te rughuhoru ge ke va sodoa. Ma gaia te bosa vania, “Ighoe ko tangomana ge ko maturu koluu tana bongi geva. Inau tu pelugho tua ta Rachel nighi na balu mandrake nina dalegu te sodoi.” Keri ge Jacob te maturu kolua. ");
INSERT INTO nlg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ma God te bosa tughuna nina na kokoeliulivuti Leah, ma gaia te ghoi logho gari ge ghoi vahua e limani na dalena na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Me holoa nia Issachar, na pukuna gaia te bosa, “God te tabau nia tu hea nigua na ghairau na taugu te vagha na tauna.” ");
INSERT INTO nlg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ma gaia te ghoi logho gari sono Leah, ge vahua e ononi na dalena na garimane. ");
INSERT INTO nlg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Me holoa nia Zebulun, na pukuna gaia te bosaa, “God te vahea na sonihalavu te uto. Mi taeni na taugu ke talumavau, na pukuna tu vahea ra ono na dalena na lei garimane.” ");
INSERT INTO nlg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mi murina gaia te ghoi vahua so sakai na vaivine me holoa nia Dinah. ");
INSERT INTO nlg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Me God te ghanaghanaa Rachel, ge bosa tughuna nina na kokoeliulivuti nia na loghoana sakai na dalena. ");
INSERT INTO nlg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ma gaia te logho gari me vahua na garimane. Me ghaghua, “God te lavikehaa na maa itagua.” ");
INSERT INTO nlg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma gaia te holoa nia Joseph, na pukuna te ghaghua, “Ku kokoeliulivuti vania Yahweh ke ghoi talana vaniu mai so a sakai na dalegu na garimane.” ");
INSERT INTO nlg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mi murina Rachel te sivuragha Joseph, Jacob te bosa vania Laban, “Inau te liogu ge ku pulohi tua tana komugu. ");
INSERT INTO nlg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ko lubatiu ge ku lavira na lei taugu ma rana lei dalegu, na pukuna tu pelura tua itamua. Mo ko ghilalaa tu pelu sokora tua itamua te vagha nigua na lutu uto tu gonighi vanigho.” ");
INSERT INTO nlg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ma Laban te bosa tughu vania, “U nongi ngangatagho ge ko bei rughuhoru saniu na pukuna tu righighi na lei vaughilala mu ghilalaa Yahweh te vautou inau na pukuna ighoe itagua. ");
INSERT INTO nlg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ko bosa vaniu mai engiha to liona ge ko lutu so vaniu, mi nau ku pelugho!” ");
INSERT INTO nlg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma Jacob te bosatughu, “Ighoe to ghilala tua ivei tu nea na lutu laga vaniamu ilokani te subo na niulu tua, mi vei tara ghaghua nimura na lei sheep mana lei maumanu vola ge ra sepalaghi. ");
INSERT INTO nlg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ighoe to loghora na balu vamua inaghona ge u mai, mi taeni to loghoi tara subo ngangata tua. Ma Yahweh te vautogho tana lei totobo tu gonighi vanigho. Mi taeni inau ku righitaoni olira nigua na binaboli heghegu!” ");
INSERT INTO nlg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ma Laban te ghoi huahuati sono, “?Mana hava na pelu ia te liomu?” Jacob te bosatughu, “Ko bei peluu gea siki rongo. Mi nau ku ghoi pulohi mu ku ghoi lutu vanigho, ke vagha to gonia a sakai na totobo vaniu. ");
INSERT INTO nlg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ko lubatiu ge ku tona ghobudira nimua na lei volivoli itaeni, mu ku vilikehara na lei sheep mana goat tara loghoa na vaughilala, kolura nia na lei sheep tara kirikiria, ko va heu raeni te vagha na tabagu. ");
INSERT INTO nlg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Aeni ke negho ge ko righia inau tu lutu kaekage vanigho pe taho. Ge ko righi sodoa siki sheep pura pana goat tara mua kirikiria ke, mo ko ghilalaa tu gitoi itamua.” ");
INSERT INTO nlg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ma Laban te bosatughu, “E uto ngangata, ke ghaghua igaa na hava to bosaa.” ");
INSERT INTO nlg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mi tana dani vaghana keri, Laban te rughu horu me lavikehara itadira, na lei goat mane mana vaivine tara loghoa na pile vaughilala te pura, mana lei goat kirikiria maighi na lei sheep bili me lubatira tana limadira rana lei dalena ge kara righitaonira. ");
INSERT INTO nlg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mete lavira e tolu na bongi te vagha na hauna tara sopa haghara iga. Mi tana bona keri Jacob te kabu so me righitaonira nina volivoli keha a Laban. ");
INSERT INTO nlg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ma Jacob te lavighi na sousopuni na ghai tara holoi nia na poplar, almond, mana plane, me paighi na ghuighulini ge ke gonighi iga na ghalo pura. ");
INSERT INTO nlg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Me talui na lei gaegame te paighi lilighina na vatei inu, ge ra nina lei volivoli Laban kara righighi tana bona kara mai ni inu. ");
INSERT INTO nlg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ikakeri tua na bona kara vei sodoi ni gehe gari. Mi tana bona tara mai koukolu inaghoni na lei otooto pura, na lei daledira tara pura kolu bili, kirikiria, tunutunua nia na vaughilala itadira. ");
INSERT INTO nlg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ma Jacob te talukolura nia nina na lei volivoli heghena, me ke mua vilivokara na dale sheep ta nina na lei sheep Laban. Mi tana bona ni mai koukolu agaia te liliura na lei sheep vaivine va ta nina lei sheep mane tara bili Laban. Mete vagha ghua te talura heghedira rana lei nina sheep me mua talukolura ta nina ovu Laban. ");
INSERT INTO nlg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ivei tua na bona vaghana rana sheep vaivine tara laga kara gonidila ni mai koukolu gehe gari Jacob te gonidilai na lei otooto tara paighi te ghahai inaghodira. ");
INSERT INTO nlg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Me mua mai vanira tara lugu. Keri ke, rana dale sheep tara lugu ke, anina Laban, ma rana lagalaga a nina Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mete vagha keri ke, anina na lei volivoli a Jacob tara savungi minaminai, ma gaira tara sepa ngangata. Gaia te sosodo me loghora tara subo na vure lutu, mana lei camel mana lei donkey. ");
INSERT INTO nlg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ma Jacob te rongovia na rongorongo ge rana dalena Laban tara vuivuni ni hughuhughu, mara ghaghua, “A Jacob te mane lologho ngangata, hauva ka, anina lei lologho te lavighi ta nina lologho a tamada.” ");
INSERT INTO nlg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma Jacob te vuivuni ni ghilalaana ge a Laban te mua kulagha tua itaeni. ");
INSERT INTO nlg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ma Yahweh te ghaghua vania Jacob, “Ko pulohi tana bonadira tamamu maia kukuamu maira rana lei kulamu ikakeri, mi nau ku kabu kolugho.” ");
INSERT INTO nlg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Keri ge Jacob te holora Rachel ma Leah vaa tana bona te righitaonira iga na lei volivoli. ");
INSERT INTO nlg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ma gaia te bosa vanira, “A tamamiu te mua kulagha vaniu me mua lavipangotiu te vagha te ghaghua haia iga. Hauva ma nina God tamagu te kabukoluu so. ");
INSERT INTO nlg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Iroghau toro ghilala ivei te vaghai na vaholani na lutu tu lutui vania tamamiu, ");
INSERT INTO nlg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","hauva ka, me pegou me hughua haia nina baubahu ni peluagu. Ma God te mua talana ge ke gonia vaniu siki dika. ");
INSERT INTO nlg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mi tana bona Laban te bosaa, ‘Na lei sheep tara logho vaughilala ke, kara nimua,’ keri ke, maighi na lei sheep udolu kara vahura na lei daledira tara loghoi na lei vaughilala. Mi tana vuivunina na bona te tughua na liona me ghaghua, ‘Ighoe ko loghora rana sheep tara kirikiri,’ keri ke, na lei sheep udolu kara vahura na lei daledira tara kirikiria. ");
INSERT INTO nlg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mi tana bona eni, God te lavikehai nina volivoli tamamiu ge vahei inau. ");
INSERT INTO nlg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mi tana bona ni mai koukolu ni gehe gari, inau tu maturu bole mu righira na lei goat mane tara kirikiria maia tara logho vaughilala ma tara tunutunua, tara tonavira rana vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mi ta nigua na maturu bole, na angel nina God te bosa vaniu, ‘Jacob!’ Mi nau tu bosa tughu, ‘Eo, inau tu rongovigho.’ ");
INSERT INTO nlg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mana angel te ghaghua, ‘Ko vaevanera rana lei goat mane tara kirikiria maira tara loghoa na vaughilala maira tara tunutunua tara tonavira rana nimua na goat vaivine, na pukuna inau tu righighi na lei totobo Laban te gonighi vanigho. ");
INSERT INTO nlg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Inau na God to sodou i Bethel, tana komu to siusiua na vatu mo baubahu ge ko lutu vaniu. Itaeni ko rughuhoru tana komu eni mo ko pulohi tana komu to va mai iga.’” ");
INSERT INTO nlg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ma Rachel ma Leah toro ghaghua, “E uto vanighai so iroghai. E taho siki nimami totobo iani, me taho siki nina lologho a tamamiu ke va mai vanighai ghua. ");
INSERT INTO nlg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Agaia te talukehai nimami na uto te vaghaghai iroghai na lei vaivine sinogho tona mai. Gaia te nighai hunulu, mana hava te lavighi vanighai, gaia te sonighi tua. ");
INSERT INTO nlg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Na lei lologho te va hegho a God ta nina lei lologho a tamamami ke, ara nimami mana lei dalemami. Ko tona haliua na hava God te bosaa vanigho.” ");
INSERT INTO nlg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Keri ge Jacob te talura rana tauna ma rana lei dalena ivuvungadira rana camel. ");
INSERT INTO nlg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ma gaia te ghurughurura na lei volivoli udolu te loghora tua va i Paddan-aram, me vuivunia nina na rughuhoru va tana butonikomu i Canaan, ivei te ghaha iga tamana Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mi tana bona Laban te halahau mua ge gaia te palai na vuvuludira nina na lei sheep, ma Rachel te lavipolora nina na lei god-sasari a tamana. ");
INSERT INTO nlg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma Jacob te pegoa Laban, na pukuna gaia te mua bosatatea vania a Laban, na rughuhoruadira. ");
INSERT INTO nlg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ma Jacob te lavighi nina na lei lologho udolu, me sogha halavua tana beti tina Euphrates, me tona vania va na lei ghotu tana bubulo i Gilead. ");
INSERT INTO nlg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Laban te mua ghilala didira na rughuhoru me tolu tua na bongi te padi. ");
INSERT INTO nlg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Vaho ge ghilalara, ma gaia te holokolura rana lei kulana ge ara rughuhoru ma kara kene taonira. Mi murina tua e vitu na bongi geva dutuvira ge topora tana lei ghotu tana bubulo i Gilead. ");
INSERT INTO nlg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mi tana bongi keri, God te tate vania a Laban tana maturu bole me ghaghua, “Ko righitaonigho tana hava ko bosa vania Jacob.” ");
INSERT INTO nlg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mi tana bona Laban te sodoa Jacob tana vale tapolena tana sakai na ghotu i Gilead, ma gaia te tughuru vaghinia na vale tapolena lilighina Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma Laban te bosa vania Jacob, “?Na hava to ghanaghana ge o rughuhoru popolo te vagha keri? Ighoe to pegou, mo lavipolora rana dalegu vaivine vaghara na tinoni to sagura tana kisumate. ");
INSERT INTO nlg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","?Na hava na pukuna ge o rughuhoru popolo? Ge mi nau ku gonia vanighau na vanga ni saniamu, kolua nia na linge ni rivurivu mana uvete mana gita. ");
INSERT INTO nlg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ighoe to mua lubatiu ge ku nonginongira rana dalegu vaivine maira na lei kukuagu mu ku bahura. Ighoe to gehegehe bule ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Inau ku tangomana ge ku durakegho ighoe, hauva ka, ma nina God tamamu te tate vaniu i bongi me bosa vaniu, ‘Ko righitaonigho tana hava ko bosaa vania Jacob.’ ");
INSERT INTO nlg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Inau tu ghilalagho ighoe to liona ge ko tona mughua, mo nia ghaghua na komumu to sule dato igaa. ?Mana hava na pukuna ge o gitoi nigua na lei titinoni god tana valegu?” ");
INSERT INTO nlg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ma Jacob te bosa tughu me ghaghua, “Inau tu rughuhoru minamina na pukuna tu mataghu. Mu ghanaghana heghegu ke, mo ko laviolira gea rana dalemu vaivine itagua. ");
INSERT INTO nlg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mete vagha nimua na titinoni god ke, lubatia na tinoni te lavighi ke mate. Ma ge ke vagha ko sodoa siki nimua na totobo ke, inau tu papari tana matadira rana lei kulada raeni, ko lavikehai.” Hauva kaa, ma Jacob te mua ghilala a Rachel te holai. ");
INSERT INTO nlg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban te diki tona ta nina vale tapole Jacob me va kekene iga, me va ta nina vale tapole Leah, me va kekene ta didira vale tapole ra rua na vinekama ni lutu, me mua sodoi na lei titinoni god. Mana sosoko gaia te va haghe ta nina vale tapole Rachel. ");
INSERT INTO nlg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rachel te lavighi na lei titinoni god me talui lokana na kirisa ta nina camel, ge sopou ivuvungani. Ma sakai manaa Laban te kekene tana vale tapole udolu, te mua topoi. ");
INSERT INTO nlg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma Rachel te bosa vania tamana, “Ko mua rutu vaniu tu mua tughuru tana matamu, na pukuna te kaleu na vahaghi ni vaivine.” Keri ke, sakai manaa te kenekene ngangata, Laban te mua sodoi nina lei titinoni god. ");
INSERT INTO nlg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Keri ge Jacob te rutu ngangata, me keikeria Laban, “?Na hava to sodoa? ?Mana hava nigua na hahi? Ighoe to ghuru taoniu vaghau na tinoni diu vetena! ");
INSERT INTO nlg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ighoe to kekene udolui tua nigua na lei totobo tu loghoi. Ko tatei vaniu mai tua itaeni na lei hava to sodoi tara nimua! Ko talu horui iani tana matada ighita udolu, ge kara vaevanei na lei kulada, ge ighita udolu ka vaevanei. Lubatira ge kara detea ahei sughua te puku ni loghoani. ");
INSERT INTO nlg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Erua hangavulu na niulu tua tu kabu kolugho, mi tana lei bona udolu rakeri inau to righitaonighi nimua na lei sheep mana goat, keri ge kara vahura na lei dale korukoru mara maramarabu. Mi lokani rana lei niulu rakeri, inau tu mua tabea siki nimua na sheep mane, ge ku ghania. ");
INSERT INTO nlg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","?Ma siki sakai tadira kara soghavira pa kara matera na lei maumanu asi ke, ivei te ghaghua? U mua tatei vanigho, mu mua nongigho ge ko taluhorua ta nimua na iduidu itadira nimua na lei volivoli. Inau heghegu tu nia kaukauli na sosoni lee! Ighoe to neu mu pelui na lei sheep pana goat tara gitoi tadira nimua na volivoli tana bongi mana dani, sakai vamua na sosonilee tu nei, te palugu inau pe taho. ");
INSERT INTO nlg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Inau tu lutu vanigho tana papara ni hina tana dani, mana bihilaghi mana daidanihaghi tana bongi. ");
INSERT INTO nlg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Eo, rua hangavulu na niulu tu ghaha kolugho. Ra hangavulu vati na niulu tu lutu vanigho na peludira rana dalemu vaivine tu taudira. Mara ono na niulu ge u loghora na balu lei sheep mana goat. Mi ghoe te hangavulu na tughuru ni taluhoruana na pelugu ta nigua na pelu. ");
INSERT INTO nlg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ma ge a God, nina kukuagu Abraham mana tamagu, Isaac, toro holohabaa ke, te mua hangau, mo niu vetena keha nia te taho siki rongo tana limagu. Hauva ka, ma God te righia to niu ghighirou ma nigua na lutu laga. Mughua keri ge tate vanigho i bongi tana bongi me talu tateu inau ta nigua lutu.” ");
INSERT INTO nlg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ma Laban te bosa tughu vania Jacob, “Rana vinekama raeni ke ra dalegu, mana lei daledira raeni ke, rana lei kukuagu, mana lei sheep maia na lei totobo to loghoi ke anigua. ?Mana hava ku gonia vanira rana puku ni dalegu vaivine maia rana lei kukuagu? ");
INSERT INTO nlg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ko mai, mo koro gonia na baubahu ni mabo, ighoe mi nau, iroghita koro kabu taonighi na lei vetenana na baubahu. ");
INSERT INTO nlg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ma Jacob te lavia na vatu sule me tughuruvaghinia te vagha na vatei ghanaghana oli. ");
INSERT INTO nlg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma gaia te bosa vanira ghua nina na lei mane lutu ge kara vahikolui na vatu ma kara varavara datoi. Jacob ma Laban toro sopou horu lilighina na bara vatu ge koro ghani koukolua na vanga. ");
INSERT INTO nlg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Moro holoa nia na bara vatu keri, “na bara vatu ni vatei vaevane koukolu.” Tana leuna Laban te holoa nia Jegar-sahadutha, mi tana leuna Jacob te holoa nia Galeed. ");
INSERT INTO nlg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ma Laban te ghaghua, na bara vatu eni ke tughuru te vagha na vatei vaevane koukolu ke maumauri olia vanighita dida na lio sakai sonikolu. ");
INSERT INTO nlg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Na bona eni koro holoa nia ghua Mizpah. Ma Laban te ghoi ghaghua sono, “Lubatia Yahweh ge ke righitaonighita ge ka taonia dida na baubahu tana bona koro sopa kabu sagau mo koro mua reirei koukolu. ");
INSERT INTO nlg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ku mua ghilala inau toko nira ghighirou rana dalegu na vinekama, pa ko lavira balu vinekama keha mo ko taudira, hauva ka, ma God ke vaevanea mai so. ");
INSERT INTO nlg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Na bara ni vatu mana vatu sule eni ");
INSERT INTO nlg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","tara tughuru ighobuda te vaughilalaa toro kabu koukolu ta dida na baubahu. Inau ku mua vulea na kobekobe eni ge ku labugho, mi ghoe ko mua vulea ge ko mai labuu inau. ");
INSERT INTO nlg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Inau ku holoa didira na God kukuamu Abraham ma nina God kukuagu Nahor - ke hea na totoro ahei itatada ke va vahaghitailia a sakai. Ma Jacob te gonia na baubahu tana matana nina God puku ni maana, a tamana Isaac, ge ke talumavaa na baubahu. ");
INSERT INTO nlg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ma Jacob te nia hevei na sukaghi vania God. Me holora mai na vure subo ta nina vanga koukolu. Mi murina keri gaira tara ghahara so a sakai na bongi tana ghotu. ");
INSERT INTO nlg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ma Laban te rarai minamina tana roropo ghana, agaia te nonginongira rana dalena na vinekama maira rana lei kukuana, me vautora. Keri ge pulohi tana komuna. ");
INSERT INTO nlg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ma Jacob ma nina binaboli tara ghoi vuivunia so na rughuhoru, mara na nina angel God tara mai topoa. ");
INSERT INTO nlg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mi tana bona Jacob te vaevanera, agaia te ngangaraha nia na hava me ghaghua, “Aeni nina bona ni kisumate God.” Keri ke, me vatua nina na bona keri Mahanaim. ");
INSERT INTO nlg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ma Jacob te nira vetena nina vure lavibosa vania na hoghona Esau, tana butonikomu Edom (eruani ahana Seir). ");
INSERT INTO nlg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ma gaia (Jacob) te ghaghua vanira, “Kau vahea na rongorongo eni a nigua na vunaghi Esau, ‘Na kokoe ni talumuri tatana nimua na tinoni ni lutu Jacob, “Inau tu ghahau ta tubugu a Laban ritini itaeni. ");
INSERT INTO nlg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mi taeni inau tu loghoi tua lei buluka, rana donkey, rana sheep, rana goat maia ghua na lei tinoni lutu, na mane mana vaivine. Mi nau tu nira vetena vanigho gatu na vure lavibosa raeni ge kara diki tughuni dilaa vanigho na maiagu, mu ghanaghana dila ke, mo ko tamahoghoni kokolu so itamami.” ’” ");
INSERT INTO nlg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Rana vure lavibosa tara nia pulohi mai na rongorongo vania Jacob, “Agaia Esau te mai ni sodoagho kolura nia ara vati hangalatu ni mane.” ");
INSERT INTO nlg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ma Jacob te nia mataghu na rongorongo vaghana, ma gaia te tuvalira rana vure, maia na lei sheep ma rana camel ma rana goat ma rana buluka tana e rua na ovu, mara ghana sopasopara. ");
INSERT INTO nlg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Me ghanaghana, “Ge ke vagha ke suravira a Esau sakai na ovu ke, ma tara sogha polo sakai na ovu keha.” ");
INSERT INTO nlg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Keri ge Jacob te kokoeliulivuti me ghaghua, “A God nina kukuagu Abraham ma tamagu Isaac, rongoviu. A Yahweh, to bosa vaniu ge ku pulohi tana komugu maia tadira kulagu vure, mo baubahu ge ko righitaoniutou.' ");
INSERT INTO nlg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mi nau te mua ulaghagu na lei totobo uto to gonighi vaniu, maia na liodolo to tatea vaniu inau, nimua na tinoni lutu. Tana bona tu halavu na beti tini Jordan te padi, u mua loghoa siki totobo mana totoghona vamua. Mi taeni tana valegu tu loghora erua na ovu ni vure mana lologho. ");
INSERT INTO nlg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","A Lord, u kurutigho, ko vavolau tatana hoghogu, Esau. Inau tu mataghunia, ge ke mai me ke labumateu gea inau maira rana taugu maira rana lei gari. ");
INSERT INTO nlg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mi ghoe to baubahu ge ko righitaoni utou, mu ku halilaghinia na vaivarigu ge kara mai vaghara na saghalea tana saravahale tara subo ngangata a idumiani.” ");
INSERT INTO nlg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tana bongi keri, Jacob te ghaha iga, me gonidilaa nina na dolo vania Esau. ");
INSERT INTO nlg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Rua na hangalatu ni goat vaivine, me rua hangavulu na goat mane, me rua hangalatu na sheep vaivine, me rua hangavulu na sheep mane, ");
INSERT INTO nlg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","me tolu hangavulu na camel vaivine kolura nia na lei daledira, ma ra vati hangavulu na buluka vaivine, me hangavulu na buluka mane, ma rua hangavulu na donkey vaivine me hangavulu na donkey mane. ");
INSERT INTO nlg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ma gaia te bosa vanira nina vure lutu ge kara hulira va inagho, na lei ovu ni maumanu tana lei sopasopa ovu heghena, ke vokara na bona oka i ghobudira. ");
INSERT INTO nlg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ma gaia te vahera na kokoe eni na lei mane tara idevia na vuivuni ni ovu me ghaghua, “Tana bona kau tona Esau, gaia ke huahuati, ‘?Ivei kau tona vaa? ?Ahei nina tinoni ni lutu ighau ma hei nina na lei maumanu raeni?’ ");
INSERT INTO nlg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ma kau bosa tughu, ‘Na lei totobo raeni ke, nina nimua na tinoni ni lutu a Jacob. Gaighi nia na dolo vania na vunaghina Esau. Agaia te tumuri ghai mai.’” ");
INSERT INTO nlg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ma Jacob te va hera sakai vamua tua na kokoe na lei sopa vure tara righitaonighi na lei ovu ni mua manu me vanira, “Tana bona kau righia a Esau ke, kau bosaa vamua tua sakai na vata ni kokoe. ");
INSERT INTO nlg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma kau ghanaghana talaua na bosaana, ‘Nimua na tinoni ni lutu Jacob te tumurighai mai.’” Nina na padalaghi Jacob te loghoa na ghanaghana dila ge Esau ke holopangotighi nina lei dolo, ma gaia Esau ke arovia. ");
INSERT INTO nlg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mana lei dolo udolu gaia te diki nighi vetena ide tua, mi tana bongi keri Jacob te hagha mai sono tana vale tapole tana bona tara ghahara iga. ");
INSERT INTO nlg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mi tana bongi keri Jacob te tughuru dato me nira vetena rana tauna, erua nina vinekama ni lutu me hangavulu sakai na dalena ge kara sogha halavu tua tana beti tina Jabbok. ");
INSERT INTO nlg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mi murina tara ghahara mai tua na levuni beti tina, Jacob te nighi vetena halavu nina na lei lologho udolu. ");
INSERT INTO nlg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma Jacob te kabu heghena vamua iga. Ma siki tinoni te mai tatana me lotia moro ghutuveve tana tapoasana na dani. ");
INSERT INTO nlg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mi tana bona na tinoni keri te righia ke mua tangomana na lagavuleana ke, gaia te labua na bokena Jacob me vadikalaa na louloghu ni bokena. ");
INSERT INTO nlg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ma gaia na tinoni keri te ghaghua, “Ko lubatiu, te dani marao/labota puipungi tua.” Ma Jacob te lavi ghuri me ghaghua, “Ku mua tangomana tua na lubatiamu polo ko vaheu mai na vauto.” ");
INSERT INTO nlg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mana tinoni keri te huatia, “Ahei na ahamu?” Ma gaia te bosa tughu, “A Jacob.” ");
INSERT INTO nlg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mana tinoni keri te bosa vania, “Na ahamu ke mua ghoi Jacob, itaeni kara hologho nia Israel, na pukuna ighoe to pepo kolura God maira na lei tinoni mo laga vulera.” ");
INSERT INTO nlg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ma Jacob te huatia, “Ahei na ahamu?” Mana tinoni keri te bosatughu, “Na hava na pukuna ge o huatia?” Ma gaia te vautoa Jacob tana bona keri. ");
INSERT INTO nlg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Me Jacob te haghua gaia, “Inau tu righia na matana mana ihuna God, mana volagu te talu olia sono.” Keri ge ke holoa nia na bona keri Peniel. ");
INSERT INTO nlg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Mete puaka dato mai tua na aho tana bona Jacob te rughuhoru sania Peniel. Ma God te vadikala sakai na bokena Jacob, keri ge sakutua tona soe. ");
INSERT INTO nlg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ikakeri te ghaghua sughua itaeni na vure ni Israel tara mua ghania na vinahi lilighina na boke, na pukuna tara ghanaghana olia na hava te kale tana bongi keri. ");
INSERT INTO nlg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Mi tana bona hau mua, Jacob te righia va a Esau te mai kolura ara vati hangalatu nina mane. ");
INSERT INTO nlg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ma Jacob te padalaghinira nina na binaboli ge kara haghara tana palapala, kolura nia erua nina na vinekama ni lutu maia rana lei daledira inaghodira, ma Leah ma rana dalena tara mai ruani, ma Rachel me Joseph toro sosoko. ");
INSERT INTO nlg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma Jacob te tona haliu me ghidevira. Mi tana bona te dutuvia ge sodoa na hoghona, ge poghotao e vitu na bona. ");
INSERT INTO nlg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Esau te sama ge ke sodoa, me avehia me nonginongia. Ma rogaira udolu toro tangi. ");
INSERT INTO nlg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ma Esau te righira na lei vinekama mana gari, ge huahuati, “Ahei na vure vaghadira raeni tara kabu kolugho?” Ma Jacob te bosatughu, “Rana lei dalena God te vahe togotogou mai.” ");
INSERT INTO nlg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ma rana vinekama ni lutu toro dato mai kolura rana daledira, moro poghotao horu tana pari inaghona. ");
INSERT INTO nlg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Me Leah te holara mai na lei dalena mara poghotao horu vania. Mana sosoko Rachel ma Joseph toro mai moro poghotao. ");
INSERT INTO nlg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma Esau te huahuati, “?Mana vatei hava na lei sheep mana lei buluka tu topora tana bona tu mai?” Ma Jacob te ghaghua, “Nigua na vunaghi, gaighi nigua na dolo vanigho ge ke utuni nimua na madolo itagua.” ");
INSERT INTO nlg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Esau te bosatughu, “Hoghogu, inau tu loghora te subo tua, ko talugonighi na lei hava to loghoi.” ");
INSERT INTO nlg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Jacob te ghaghua, “Taho, U nongi ngangatagho ge ko lavi togotogoi ke vagha na sosokona na vahaghitaili. Inau tu togotogo ge kua righia kalea nimua na togotogo koukoluu. Aeni te vagha ku righia kalea a nina togotogo a God. ");
INSERT INTO nlg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ko lavipangotighi na lei dolo, na pukuna God te uto vaniu, mu loghoi na lei lologho te manana ge ku loghoi.” Ma Jacob te tona haliu sono na kerikeriana me nongia ge ke lavighi nina na dolo, ritini Esau te lavi togotogoi. ");
INSERT INTO nlg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ma Esau te ghaghua, “Koro tona mi nau ku kabu kolugho mu ku idevia na halautu.” ");
INSERT INTO nlg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Jacob te bosatughu, “Nigua na vunaghi, ko righia, na balu tadira na lei gari tara pile ngangata ghua, maira rana lei volivoli tara loghora ghua na daledira. Ge kara ghuru lagara ke, ma kara mate. ");
INSERT INTO nlg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mo ko tona haliu sono inaghomami ighoe. Ighai kai taonia nimami na sakutua ge kai gatu topogho tana butonikomu i Seir.” ");
INSERT INTO nlg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ma Esau te ghanaghana, “Uto, ko lubatiu ge ke sanira nigua na balu mane ge kara righitaonigho ma kara pilupilugho.” Ma Jacob te kurutigho, “E taho na pukuna itamua ge ko dolovi ngangatau.” ");
INSERT INTO nlg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na dani vaghana keri ke, a Esau te pulohi oli so tana butonikomu i Seir. ");
INSERT INTO nlg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mi tana bona vaghana keri, Jacob ma nina binaboli tara rughuhoru va i Succoth. Mi kakeri te kisua na valena heghena me kisui na baebale ni ungaunga vanira nina na lei volivoli mana lei buluka. Mana pukuna keri, ge kara holoa nia na bona keri Succoth. ");
INSERT INTO nlg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ma gaia tara sara tatavahale i Shechem, tana butonikomu Canaan, mara tughuru vaghinighi na vale tapoledira imurina na komu sule. ");
INSERT INTO nlg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ma Jacob te pelua na bona keri tara haghara iga itadira na binaboli ta Hamor, na tamana Shechem, nia e hangalatu na rongo ni silver. ");
INSERT INTO nlg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Mi kakeri te kisua na bela tabu ni sukaghi iga, me holoa nia El-elohe-Israel. ");
INSERT INTO nlg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ta sakai na dani, Dinah, na dalena vaivine a Leah te tona me va kaora na lei tahula tara haghara tana bona keri. ");
INSERT INTO nlg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mi tana bona a sakai na vunaghi ni komu, a Shechem, na dalena Hamor tana kemana Hivi, te righia Dinah, agaia te lavia me lotia. ");
INSERT INTO nlg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ma nina dolo Shechem vania Dinah te laga ngangata, ma gaia te tabotabo ge ke nea Dinah ge ke nia gharu agaia. ");
INSERT INTO nlg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ma sughua gaia te keikeria na tamana, me ghaghua, “Ko lavia vaniu mai na tahula Dinah, mu ku taulaghi itatana.” ");
INSERT INTO nlg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mana bosa te saravia Jacob nina na hava te kalea itatana na dalena. Mara na lei dalena na mane tara rughuhoru vaa tana leghai na va righitaoniani na lei maumanu tana bona vaghana. Ma gaia te kabu so polo ge ra oli mai. ");
INSERT INTO nlg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mi tana bona vaghana keri, Hamor, na tamana Shechem te rughuhoru me va padalaghinia na ghanaghana eni kolua Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Mi tana saraana gaia, rana lei dalena Jacob tara va oli mai tana leghai. Ma gaira tara nia ribe mara rutu na pukuna na vaivinedira tara lotia. A Shechem te gonia a totobo mamaagha eni ta nina binaboli Jacob nia na lotiana Dinah, na totobo ge me ke mua kale. ");
INSERT INTO nlg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor te bosa vanira Jacob marana lei dalena na mane, “Na dalegu Shechem te dolovi ngangataa Dinah, me nia ghaghua ngangata ge ke tauna. U nongighau ge kau lubatia me ke taulaghi itatana. ");
INSERT INTO nlg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ighai tai nongighau ge kau lubatira na lei dalemami mane ge kara taudira nimiu na lei tahula, mi ghai kai nira hevera na dalemami vaivine ge kara taudira nimiu na lei garimane. ");
INSERT INTO nlg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kau kabukolu tua itamami, na bona te tatavahale vanighau. Kau kaburaghi iani, ma kau pelupelu tatavahale koukolu itamami. Ighau kau tatavahale ge kau loghoa na kaukabu itamami.” ");
INSERT INTO nlg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ma Shechem te bosa vanira na tamana ma rana vaivinena Dinah, me kurutira, “U nongighau ge kau liouto vaniu, ma kau lubatiu ge ku lavia Dinah ke vagha na taugu. Inau ku nia hevei na hava tana na totobo ia kau liona. ");
INSERT INTO nlg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Sakai vamua na hava na lologho ia pana dolo kau nongia, inau ku pelua. Kau heu vamua na tahula ge ke taugu.” ");
INSERT INTO nlg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Hauva ka, ma rana lei vavinena Dinah tara nira sika Shechem ma Hamor na pukuna na hava te gonia Shechem ta vavinedira, keri ge ra pegora. ");
INSERT INTO nlg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ma gaira tara ghaghua vanira, “Kai mua taoniana na talamaghiniana aeni, na pukuna ighoe to mua pahevaughilala. Ke vatei mamaagha vania na vaivine tana nimami na binaboli ge ke taulaghi tana na mane te mua pahevaughilala. ");
INSERT INTO nlg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ma eni sakai na ghanaghana, ge na lei mane itamiu kara pahevaughilala te vagha tai ghaghua iga itamami ke, ");
INSERT INTO nlg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","mi ghai kai taulaghi kolu itamiu, ma kai kabukolughau, ma ka sakai na vure vamua. ");
INSERT INTO nlg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Me ke taho ke, mi ghai kai lavia Dinah ma kai rughuhoru. ");
INSERT INTO nlg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor ma Shechem toro talamaghi togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma Shechem te mua sania tua siki bona ni aho na taoniana nina nongi, na pukuna gaia te dolovi ngangataa Dinah. Ma Shechem na tinoni tara talumava ngangataa tana lokana na binaboli. ");
INSERT INTO nlg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ma gaia te va sivuragha kolua a tamana inaghona ge rana lei vunaghi ni komu tana bona ni savukolu kara nia hevei na talugoni ni taulaghi. ");
INSERT INTO nlg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ma gaira tara ghaghua, “Na lei mane rakeri ke na lei kulada. Mai ghita ma ka nongira ge kara kabu iani kolughita ma kara hunuhunulu ma kara pelupelu, na pukuna na bona te sule te manana ke tabera. Mai ghita ka taulaghi kolu rana tahula itadira ma ka vahera dida na tahula vanira. ");
INSERT INTO nlg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ma gaia kara kene ghanaghanana na kabu iani nia sakai na talamaghi. Ge ighita udolu na lei mane ka pahevaughilala mughua te vagha tara ghaghua iga gaira. ");
INSERT INTO nlg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ge ke vagha ka gonia te vagha eni ke, didira na lei sheep mana lei totobo lologho ke dida. Mai ighita ka talamaghinia eni ma gaira kara kabukolu itatada.” ");
INSERT INTO nlg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mana lei mane udolu tara talamaghi ma kara pahevaughilala. ");
INSERT INTO nlg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mi murina e tolu na bongi, tana bona na paedira te vahaghi mua, erua na vaivinena Dinah, Simeon ma Levi, toro lavighi didira na isi moro haghevia na komu, moro mate udolura na lei mane tana komu, ");
INSERT INTO nlg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","kolura nia Hamor ma Shechem. Ma gaia tara vaa lavi rughuhorua Dinah tana valena Shechem mara pulohi tana valedira tana bona tara ghahara iga. ");
INSERT INTO nlg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Vaho ge rana lei dalena Jacob udolu tara haghevia na komu mara lavighi na lei totobo iga, na pukua na vaivinedira tara metoa iga. ");
INSERT INTO nlg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ma gaia tara holai na lei sheep mana lei maumanu mana lei donkey, maia na lei totobo udolu tua tara liona na laviani na hava ilokana na komu mi paribebetena na leghai. ");
INSERT INTO nlg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ma gaira tara holara ghua na lei vinekama mana lei gari mana lei lologho soko tana lei vale. ");
INSERT INTO nlg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mi murina vaho keri, Jacob te ghaghua vanira Levi ma Simeon, “Iroghau toro nea gei dika na ahagu itadira na vure subo tana bona eni, itadira rana kemana Canaan mana kemana Periz. Ighita ta mua subo, ma ge kara mai vaukolu ma kara veilalabui vanighita, ge kara haurakeghita gea. Ma kara mate ighita. ");
INSERT INTO nlg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ma rogaira toro nia hevei na bosatughu te papara, “Iroghai koro mua lubatia na vaivinemami ge kara nea te vagha na rebi.” ");
INSERT INTO nlg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ma God te ghaghua vania Jacob, “Itaeni ko tona va i Bethel mo ko ghahagho iga. Ko tughuru vaghinia iga na bela tabu ni sukaghi, mo ko holohabau, na God tu tate vanigho tana bona to ghogho sania tughamu a Esau.” ");
INSERT INTO nlg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Keri ke Jacob te bosa vania na lei vure udolu ta nina binaboli, “Kau haurakei nimiu na lei titinoni god! Kau apo marabu ghau heghemiu, ma kau pupulughau nia na tivi te marabu. ");
INSERT INTO nlg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ighita ka tona tua i Bethel, ikakeri inau ku tughuru vaghinia na bela tabu ni sukaghi vania God, te bosatughuna nigua na kokoeliulivuti tana bona tu ghahau tana gunaguna. Agaia te ghaha koluu ivei tua tu tona vaa iga.” ");
INSERT INTO nlg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ma gaira tara vahea didira na lei titinoni udolu a Jacob maia didira na lei damukuli, ma Jacob te tavughighi sarana na ghai sule lilighina Shechem. ");
INSERT INTO nlg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mi tana bona tara ghoi rughuhoru, na mataghu sule te vaa mai ta God vanira na vureni na lei komu udolu tana bubulo ikakeri, me taho siki sakai ke ghoi kisumate kolura. ");
INSERT INTO nlg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Mi tana sosokona, gaira tara sara i Luz (itaeni tara holoa nia Bethel) tana butonikomu i Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A Jacob te tughuru vaghinia na bela tabu ni sukaghi ikakeri me holoa nia El-bethel, na pukuna God te livu vania ikakeri Bethel tana bona gaia te samapolo vania Esau. ");
INSERT INTO nlg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Mi murina vaso eni, Deborah te mate, gaia na tinoni te pabea Rebekah tana bona gaia na gari pile. Ma gaira tara bekua sarana na ghai tara holoa nia na oak, tana boboko horu gea boko sughina Bethel. Ma vuivuni tana bongi keri me sara so itaeni, na ghai keri tara vahua nia Allon-bucuth. ");
INSERT INTO nlg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ma God te ghoi livu vania sono a Jacob tana bona te sara i Bethel, murina te rughuhoru sania mai Paddan-Aram. God te vautoa gaia, ");
INSERT INTO nlg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","me ghaghua, “Vania na ahamu ke mua ghoi Jacob, itaeni ghoe kara ghoi hologho nia Israel.” ");
INSERT INTO nlg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Keri ge ghaghua God, “Inau God puku ni mana, ko sepalaghi mo ko vonughia na maramana! Ko vuhaa na kema sule ngangata, eo, hughua ko sivuraghai subo na kema. Na lei vunaghi haba kara sivuragha mai tana vaivarimu. ");
INSERT INTO nlg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mi nau ku sonihalavua vanigho na bona/pari tua va hera Abraham, ma Isaac. Eo, Inau ku va hegho maia na lei vaivarimu.” ");
INSERT INTO nlg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Keri ge a God te dato sania na bona keri te kokoe vania iga Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ma Jacob te tughuruvaghinia na vatu datogha, na vaughilalana na bona keri a God te kokoe vania igaa. Ma gaia te kovala na wine ivuvungana e vagha na vatei heveioli vania God, mi siusiua na vaughilala keri nia na kokolo ni olive. ");
INSERT INTO nlg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob e vatua nia na bona keri Bethel, na pukuna God te kokoe vania iga kakeri. ");
INSERT INTO nlg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mara rughu sania Bethel, ma gaira tara tona va i Ephrath (itaeni tara holoa nia Bethlehem.) Ma Rachel te nia vahaghitaili na vahuhu tana bona tara sagauvia mua na komu. ");
INSERT INTO nlg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mi tana bona na vahaghitaili ni vahuhu te laga ngangata, na vaivine gehe vahuhu te sosoko ni bosa vaniana, “Ko bei mataghu, ighoe to ghoi loghoa sakai na meomeo mane.” ");
INSERT INTO nlg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hauva, Rachel te dutu vania na mate, mi ta nina na lavi ghuri sosoko, gaia te vatua nia na ahana na gari, Ben-Oni. Igeva, ma tamana a gari te holoa nia Benjamin. ");
INSERT INTO nlg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mi murina Rachel te mate, mara bekua tana halautu va i Ephrath (gaia keri Bethlehem itaeni). ");
INSERT INTO nlg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma Jacob te tughuru vaghinia na vati datogha ni dikalio ivuvungana na bekuna, mana vatu keri ko righia sono ritini itaeni. ");
INSERT INTO nlg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ma Jacob, eruani na ahana Israel, te sono me tughuru vaghinia nina na vale tapole matangana pala vaa i levuna, dutuvia na vale datogha i Eder. ");
INSERT INTO nlg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Bona gaia te hagha ikakeri, Reuben te koli kolua Bilhah, nina na vinekama ni lutu a tamana Jacob, me eruani na tauna, ma siki sakai te bosa tatea vania Jacob na ghanaghana eni. Raeni na lei ahadira ara hangavulu rua, rana lei dalena Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Rana lei dalena Leah - Reuben (na kamanagho ta Jacob), Simeon, Levi, Judah, Issachar ma Zebulun. ");
INSERT INTO nlg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rana dalena Rachel ke, Joseph ma Benjamin. ");
INSERT INTO nlg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rana dalena Bilhah, nina tinoni lutu Rachel ke, Dan ma Naphtali. ");
INSERT INTO nlg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Rana dalena Zilpah, nina tinoni lutu Leah ke, Gad ma Asher. Raeni rana lei dalena Jacob te vahura i Paddan-aram. ");
INSERT INTO nlg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ma Jacob te oli tana komuna itatana tamana Isaac i Mamre, i lilighina Kiriath-arba, (itaeni ke, tara holoa nia Hebron.) Iga te ghaha ghua Abraham te padi. ");
INSERT INTO nlg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ma Isaac te vola saravighi 180 na niuluna. ");
INSERT INTO nlg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ma gaia te mate tana niuluna te haulaghi ngangata tua, ma kabu kolura rana lei vaivarina tana mate. Ma rana dalena, a Esau maia Jacob toro tavughia. ");
INSERT INTO nlg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aeni na tutugunana vavatana Esau (eruani na ahana Edom). ");
INSERT INTO nlg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau te taudira erua na tahula vaolu ni Canaan: Adah, na dalena vaivine Elon na kemana Heth, ma Oholibamah, na dalena vaivine Anah na kukuana vaivine a Zibeon tana kemana Hiv. ");
INSERT INTO nlg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ma gaia te tauna ghua Basemath, na vaivine halavu, na dalena vaivine Ishmael, mana vaivinena Nebaioth. ");
INSERT INTO nlg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau ma Adah toro loghoa na daledira na mane na ahana Eliphaz. Esau ma Basemath toro loghoa na daledira na mane na ahana Reuel. ");
INSERT INTO nlg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Esau ma Oholibamah toro loghoa ra tolu na daledira na mane na ahadira Jeush, Jalam ma Korah. Na lei daledira raeni te vahura Esau tana butonikomu Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ma Esau te lavira na lei tauna, maia rana lei dalena, ma nina vure lutu, nina na lei sheep ma nina na lei volivoli maighi nina na lei lologho udolu te loghoi tana butonikomu i Canaan, ge ke tona sania na hoghona Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Na bona te mua malagha rovanira rogaira udolu, na pukuna didira na lei sheep mana volivoli tara subo ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ma Esau (eruani na ahana, Edom) te kabu tana ghotu Seir. ");
INSERT INTO nlg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Aeni na gegere tutughunadira na vavatana Esau. Gaia na tamana tana kemana Edom, tara ghahara tana lei ghotu i Seir. ");
INSERT INTO nlg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tadira rana lei dalena Esau ke, Eliphaz, na dalena Adah na tauna Esau, ma Reuel dalena Basemath na tauna Esau. ");
INSERT INTO nlg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Rana lei dalena na mane Eliphaz ke, Teman, Omar, Zepho, Gatam ma Kenaz. ");
INSERT INTO nlg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eliphaz te ghoi loghoa sakai na dalena na mane na ahana Amalek. Timna nina na vaivine lutu Eliphaz te vahua. Raeni na lei kukuana Esau tana tauna Adah. ");
INSERT INTO nlg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rana lei dalena na mane Reuel ke, Nahath, Zerah, Shammah ma Mizzah. Raeni na lei kukuana Esau tana tauna Basemath. ");
INSERT INTO nlg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ma Esau te loghora ghua na lei dalena mane ta Oholibamah, na dalena vaivine Anah, kukuana vaivine Zibeon. Na ahadira ke Jeush, Jalam ma Korah. ");
INSERT INTO nlg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Rana lei dalena Esau ma rana lei kukuana tara vunaghini na lei sopa kema. Rana daleira Eliphaz, na dalena kamanagho Esau, tara vunaghini na lei kemadira Teman, ma Omar, ma Zepho, ma Kenaz, ");
INSERT INTO nlg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ma Korah, ma Gatam ma Amalek. Rana kema raeni tana butonikomu i Edom tana vavatana Eliphaz, na daledira Esau ma Adah. ");
INSERT INTO nlg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rana lei dalena Reuel na dalena Esau, tara vunaghini na lei kemana, Nahath, Zerah, Shammah ma Mizzah. Rana lei kema raeni tana butonikomu i Edom tana vavatana Reuel, na daledira Esau ma Basemath. ");
INSERT INTO nlg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Rana daledira Esau ma tauna Oholibamah, tara vunaghini na lei kemana, Jeush, Jalam ma Korah. Raeni na lei kema tana vavatana Oholibamah na tauna Esau, na dalena vaivine Anah. ");
INSERT INTO nlg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Rana lei kema udolu raeni tana vavatana Esau, eruani na ahana Edom. ");
INSERT INTO nlg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Raeni na ahadira na lei kema tana vavatana Seir na tinoni ni kemana Hor, sakai tadira na binaboli tara diki ghaha tana butonikomu Edom: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO nlg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer ma Dishan. Raeni na lei vike ni kemana Hor, na lei vavatana Seir, te ghahaa tana butonikomu i Edom. ");
INSERT INTO nlg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Rana dalena na mane Lotan ke, A Hori ma Heman. Na vaivinena ke, tara holoa nia Timna. ");
INSERT INTO nlg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Rana lei dalena na mane Shobal ke, Alvan, Manahath, Ebal, Shepho ma Onam. ");
INSERT INTO nlg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Rana dalena na mane Zibeon ke, Aiah ma Anah. Anah ia eni ke, agaia te kene sodoi na lei biti/vuravura tana bona mamaha, tana bona te kene ghadira buburu nina na lei donkey a tamana. ");
INSERT INTO nlg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Na dalena na mane Anah ke, Dishon, ma Oholibamah na dalena na vaivine. ");
INSERT INTO nlg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Rana lei dalena na mane Dishon ke, Hemdan, Eshban, Ithran ma Kerah. ");
INSERT INTO nlg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ra tolu dalena na mane Ezer ke, Bilhan, Zaavan ma Akan. ");
INSERT INTO nlg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Rana dalena na mane Dishan ke, Uz ma Aran. ");
INSERT INTO nlg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Keri ke, mana vunaghidira rana vike ni kemana Hor ke, Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO nlg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer ma Dishan. Na vike ni kemana Hor tara holo taonira nia na vunaghi ni vikedira ara kabu tana butonikomu i Edom. ");
INSERT INTO nlg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Raeni na lei vunaghi haba tara haba pungisia na butonikomu i Edom inaghora ge ara mai na lei vunaghi haba ni Israel, ");
INSERT INTO nlg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, na dalena na mane Beor, na tinoni ni Dinhabah, te vunaghi pungisia Edom. ");
INSERT INTO nlg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mi murina te mate a Bela, Jobab dalena na mane Zerah ni Bozrah te vunaghi pungisia Edom. ");
INSERT INTO nlg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Mi murina Jobab te mate, Husham tana butonikomu tana kemana Teman, te vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Mi murina Husham te mate, Hadad dalena na mane Bedad te vunaghi haba, te va mai tana komu sule i Avith. Agaia na tinoni te haurakera na ovu ni kisumate ni Midian tana butonikomu keha i Moab. ");
INSERT INTO nlg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Mi murina Hadad te mate, Samlah tana komu sule Masrekah te vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Mi murina Samlah te mate, Shaul tana komu sule Rehoboth tana beti tina Euphrates, te vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Mi murina Shaul te mate, Baal-hanan dalena na mane Acbor te vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Mi murina Baal-hanan te mate, Hadad te vunaghi haba tana komu sule i Pau. Na tauna Hadad ke Mehetabel, na dalena vaivine Matred mana kukuana vaivine Me-zahab. ");
INSERT INTO nlg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Raeni na lei tinoni huhuli ni kemana a Esau, tara ghahara tana lei komu tara ahara vanira: Timna, Alvah, Jetheth, ");
INSERT INTO nlg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO nlg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO nlg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ma Iram. Raeni na ahadira na lei kemana Esau, na lei vaivaridira rana vure ni Edom. Sopa vike tara hera sopa aha, na lei sopa bona tara ghahara iga taonia na sopa vikedira. ");
INSERT INTO nlg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ma Jacob te ghoi oli mai me ghanaa sono tana butonikomu i Canaan, tana komuna tamana te padi. ");
INSERT INTO nlg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Aeni na tutugu tana vavatana na binaboli ta Jacob. Tana bona Joseph te sara tana hangavulu vitu (17) na niuluna, agaia te hangara sono na lei hoghona halavu na righitaoniani nina na lei sheep mana lei goat a tamana. Agaira na lei daledira rana tauna tamana (Jacob) a Bilhah ma Zilpah. Hauva kaa ma Joseph te tughunighi vania tamana na balu totobo dika tara gonighi na lei hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma Jacob te dolovi ngangataa Joseph vulera na lei dalena soko, na pukuna te vahua tana tonikama tua. Mi ta sakai na dani, Jacob te vahea a sakai nina na dolo te uto ngangata a Joseph, na pupulu te utoutoa me daro. ");
INSERT INTO nlg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ma gaira na lei hoghona tara nia ghighirou/sika a Joseph na pukuna tara ghilala kalea te dolovi ngangataa vulera gaira a tamadira. Mara mua vahea tua siki kokoe te uto. ");
INSERT INTO nlg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mi ta sakai bongi, tana bona te maturu a Joseph, agaia te righia a sakai na maturubole. Mi tana bona te tutugua vanira na lei hoghona, na maturu bole eni te nera na lei hoghona ge ra nia ghighirou vule vaa. ");
INSERT INTO nlg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ma Joseph te talutatea vanira na lei hoghona me ghaghua, “Kau varongohia mai nigua na maturubole eni. ");
INSERT INTO nlg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ighita ta rughuhoru gatu tana leghai ma pitikolui na lei viriviri, na lei bubulo ni koni/wheat. Ma nigua na viriviri inau te tughuru dato, ma nimiu na viriviri ighau tara ghoro kolu talighutia mara tongaghi vania nigua na viriviri!” ");
INSERT INTO nlg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ma gaira tara ghaghua vania, “?Mi ghoe igeva ke mai vunaghi haba vanighai me vunaghi pungisighai? Taho tua!” Keri ge na lei hoghona tara rutu ngangata vania na pukuna a nina maturubole maia na hava te bosai vanira. ");
INSERT INTO nlg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mi geva, Joseph te ghoi maturubole sono me ghoi tutugua vanira na lei hoghona, me ghaghua vanira, “Kau varongohia mai na maturubole eni, na aho, na vula, maia ara hangavulu sakai na veitughu tara tualaghi tuturu kikinima vaniu tana matagu.” ");
INSERT INTO nlg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tana bona vaghana eni ke, agaia te tutugua ghua na maturubole vanira a tamana. Ma tamana te pasaa, “?Na hava to ghanaghanaa? ?Ke tangomana sono ge ighai udolu, a tinamu, na lei hoghomu maia inau kai tualaghi tuturu kikinima tana matamu inaghomu?” ");
INSERT INTO nlg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Mana pukuna keri na lei hoghona tara rutu ngangata vania Joseph, hauva na tamana Jacob te ghanaghana haia sono na hava na ghanaghana ilokana na maturubole. ");
INSERT INTO nlg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mi murini vasoo, na lei hoghona Joseph tara tona vaa i Shechem ge ra vatoghadira nina lei volivoli a tamadira, ge kara vangavanga ghadira buburu maumauri igaa. ");
INSERT INTO nlg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Imurina tara tona tua na lei hoghona, a tamana Jacob te ghaghua vania Joseph, “Na lei hoghomu ke i paleva levuna i Shechem tua, kolura na lei volivoli. Inau ku vetenagho ge ko va sodora.” Ma Joseph te bosatughu me ghaghua, “Inau to gonidila ge ku tona.” ");
INSERT INTO nlg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma Jacob te ghaghua vania Joseph, “Ko tona mo ko vaa vaevanera na lei hoghomu maia na lei volivoli. ?Ivei tara ghaghua itaeni? Mo ko nia oli vaniu mai na rongorongo.” Keri ge nia vetena tona a Joseph, ma Joseph te tughuru ni tona tana komu me liu vaa tana bubulo i Hebron ge va sara i Shechem. ");
INSERT INTO nlg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Mi tana bona te vaa sara igaa, a sakai na mane te vaevane kalea te bulebule kolili paribebetena na komu sule keri. Gaia te huatia, me ghaghua vania Joseph, “?Na hava to kenea?” ");
INSERT INTO nlg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ma Joseph te bosatughu vania me ghaghua, “Inau tu kenera na lei hoghogu maira didira na lei volivoli. ?Ivei te ghaghua, o vaevanera sono pe taho?” ");
INSERT INTO nlg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mana mane te bosatughu vania me ghaghua, ‘Eo, mara taho tua inau. Inau tu rongovira na lei hoghomu tara bosabosa ke, ma kara tona vaa i Dothan.” Ma gaia Joseph te tumurira na lei hoghona, ge va sodora i Dothan. ");
INSERT INTO nlg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tana bona na lei hoghona tara vaevanea a Joseph te mai, agaira tara vaevane kaekage utoa vaa tua tana bona te sagau mai mua, mara padalaghini kabua tua na mateana. ");
INSERT INTO nlg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ma gaira tara bosa heghedira, “Na tinoni maturubole ka, te mai keri. ");
INSERT INTO nlg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mai ghita, ka labumatea ma ka sonihaghea tana gilu lalo/tuvu lalo. Ma ka bosa vania tamada na kau asi te matea me ghania Joseph. Keri ge ka vaevanei i murina ivei kara vuha mai ghaghua nina lei maturubole!” ");
INSERT INTO nlg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Hauva ka, ma Reuben te ghanaghanaa ge ke volaa Joseph. Ge ghaghua vanira na lei hoghona, “Ka bei matea gea! ");
INSERT INTO nlg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","?Ivei te ghaghua tavea na ghabuna? Mai ghita ma ka soni horu volaa tana tuvu eni. Keri ge ke mate heghena, ma ka mua labumatea ighita.” A Reuben te ghanaghana popoloa heghena ge ke hangaa Joseph me ke soghapolo. Keri ge agaia ke lavi pulohia vania a tamana. ");
INSERT INTO nlg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Keri ke, mi tana bona te sara mai itadira Joseph, gaira tara taghi karuhikehaa nina pupulu te utoutoa. ");
INSERT INTO nlg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mara sonihaghea tana tuvu, me mamaha tana bona vaghana eni. ");
INSERT INTO nlg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Soko ke, gaira tara vanga. Mi tana bona tara sopou ni vanga vasoo, gaira tara vaevane vaa na ovu ni camel tara sara mai. Agaira na lei vure hunulu/pelupelu/sabiri ni kemana Ishmael, tara lavighi mai na lei totobo uruuru te ahuvia/nainamia na vanga, na balm mana myrrh. Gaira tara lavighi mai Gilead ma kara tona vaa i Egypt ge kara sabirighi. ");
INSERT INTO nlg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ma Judah te ghaghua vanira rana hoghona, “?Na hava ka sodoa igaa tana matena na hoghoda ma ka poloa na hulina? Taho siki totobo/sakai! ");
INSERT INTO nlg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mai ghita ma ka hunulua Joseph vanira na lei tinoni pelupelu/hunulu/sabiri ni kemana Ishmael raeni. Ka bei nia kaukauli gea na mateana, murini soko raeni ke, agaia ke na hoghoda sono!” Ma rana lei hoghona tara nia liosakai koukolu itatana ta nina ghanaghana. ");
INSERT INTO nlg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mi tana bona na lei vure pelupelu/hunulu/sabiri tara mai tona haliu, gaira na lei hoghona tara holakehaa Joseph tana tuvu, mara hunulua vanira nia erua hangavulu na mavana na rongo vitiviti/ni silver, mana lei vure pelupelu/hunulu/sabiri ni kemana Ishmael tara lavia Joseph, mara nia tona kolu tua i Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mi pile bona vamua i murina tara hunulua tua Joseph, a Reuben te pulohi ge ke lavi horua Joseph tana tuvu. Mi tana bona te righi sodoa te taho iga, Joseph, agaia te rosirosighi nina na lei tivi mai na dikalio. ");
INSERT INTO nlg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ma gaia Reuben te pulohi oli vaa itadira na lei hoghona ge tangi ngangaraha, me ghaghua, “Na garimane te taho tua igaa ilokana na tuvu. ?Na hava tua ku gonia inau?” ");
INSERT INTO nlg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ma gaira na lei hoghona Joseph tara matea sakai na goat mara lumia nina na pupulu utoutoa tana ghabuna na goat tara matea. ");
INSERT INTO nlg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Keri ge ra lavia vania tamadira na pupulu tara lumia tana ghabu, mara bosa vania, “Na pupulu eni tai sodoa i kokouna na leghai. ?A nina pupulu tua Joseph, agaia sughua?” ");
INSERT INTO nlg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mi tana bona atamadira te vaevanea na pupulu ke, me ghilalaa kalea tua. Ge ghaghua, “Eo, gaia a nina pupulu tua a dalegu Joseph! Na maumanu asi tua te ghalatia matea me ghania. E utuni tua, a Joseph ke, ara ghalati sagisagia tua sokoa!” ");
INSERT INTO nlg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ma Jacob te rosighi nina lei tivi me pupului nina na tivi ni dikalio. Me daro ni bona te nia dikalio ngangata na dalena. ");
INSERT INTO nlg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A nina binaboli tara tabotabo ngangata ge kara togholuvua, mara mua nia tangomana. Agaia te dikalio pulohi sono, tana bona ke ghaghua, “Inau ku nia mate kolu na dikalio eni nia na dalegu te mate.” Keri ke, Jacob te tangimate so na pukuna na hava te kalea na dalegu Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mi tana lei bongi vaghani raini, rana lei vure pelupelu/hunulu/sabiri tara hunulua tua Joseph vania Potiphar, a nina tinoni nagho a Pharaoh, na vunaghi haba ni Egypt. Potiphar te vunaghiadira na lei malaghi tara righitaonia Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mi tana bona ni aho te vaghana sono itaeni, Judah te rughuhoru sanira rana lei hoghona me tona va i Adullam me ghaha kolua na mane na ahana Hirah. ");
INSERT INTO nlg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iga i kakeri te sodoa na vaivine ni Canaan, na dalena vaivine a Shua, me tauna. ");
INSERT INTO nlg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Na vinekama te logho gari me vahua na meomeo mane, ma Judah te holoa nia na meomeo a Er. ");
INSERT INTO nlg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ma tauna Judah te ghoi vahua sono a sakai na meomeo mane, ma gaia te holoa nia Onan. ");
INSERT INTO nlg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Mi tana bona te ghoi vahua toluni dalena na meomeo mane, agaia te holoa nia Shelah. A Judah ma nina binaboli tara ghahara i Kezib tana niulu vaghana tara vahua i lokana a Shelah. ");
INSERT INTO nlg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mi tana bona te sule dato na dalena kamanagho, a Er, Judah na tamana te padalaghinia nina taulaghi ge ke tauna na vaivine tahula na ahana Tamar. ");
INSERT INTO nlg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Hauva ka, ma Er ke, na tinoni dika tana matana Yahweh, keri ge Yahweh te lavikehaa na volana. ");
INSERT INTO nlg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ma Judah te bosa vania Onan, na tahina Er, “Na tughamu te mate me mua logho gari. Ko tauna mughua Tamar te vaghaa dida na vetena te bosaa. Na gari kamanagho A Tamar te vahua ke, te vaghaa na gari kamanagho na tughamu.” ");
INSERT INTO nlg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Hauva ka, ma Onan te mua liona ge ke vahua me ke loghoa na gari ke mua nina/lologho tughua gaia oli heghena. Keri ke, mi tana bona te koli kolua me tonavia a Tamar ke, agaia te soni leaa vamua na utoa nina togotogo tana pari, ge ke bei logho gari na vinekama Tamar, me ke vahua na gari ke vaghaa a dalena hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Na hava te gonia, na totobo dika tana matana Yahweh, keri ge a Yahweh te ghoi lavia ghua na volana Onan. ");
INSERT INTO nlg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ma Judah te bosa vania na vungona a Tamar, “Ge ko bei ghoi taulaghi gea, mo ko pulohi vamua tana komudira tinamu ma tamamu. Mo ko kabu vaghaa na vaivine mate sasani ighoe koekobe ke sule a Selah na dalegu mane na sosoko, me ke ulaghana na taulaghi ke ge ke ghoi taumu.” Hauva ka, a Judah te mua ghanaghana ngangata ge ke nia te vaghaa te bosa vania, na pukuna vamua te mataghu ge ke bei ghoi gea a Shelah, vaghara rana hoghona too mate tua. Ma Tamar te pulohi tana komuna itadira tinana ma tamana. ");
INSERT INTO nlg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mi murina keri, na tauna Judah te mate. Mi murini na lei bongi ni kabu dikalio, a Judah maia na kulana mane a Hirah, na tinoni ni Adullam, toro tona i Timnah ge koro huli manahara rana tinoni lutu tara palai na vuvuludira nina na lei sheep Judah. ");
INSERT INTO nlg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ma siki sakai te tughunia vania Tamar na tonaana i Timnah a Judah na vungona tana palaani na vuvuludira nina lei sheep. ");
INSERT INTO nlg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ma gaia Tamar te ghilalaa te sule tua Selah, mara mua hea vaa na kokoe ge ke ghoi mai me ke tauna. Keri ge tughui lei nina tivi ni kabu matesasani, me saroa nia na uluna na tivi tara poloa nia matesasani. Ge sopou tana lilighina na halautu tana rughuhaghena na komu Enaim, te tona vaa i Timnah. ");
INSERT INTO nlg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ma Judah te vaevanea tana bona te va tona haliu, ge ghanaghana ke, na vaivine rebi, na pukuna te sara nia na tivi tara poloa nia na tivi na uluna. ");
INSERT INTO nlg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ma Judah te beto ge padalaghi kolua ge ke maturu kolua tana bongi, na pukuna te mua ghilalaa na vaivine ke a Tamar na vungona heghena sono. Ma Tamar te ghaghua vania Judah, “?E nigha na rongo ko tabau nia?” ");
INSERT INTO nlg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma Judah te baubahu nia, me ghaghua, “Inau ku nia vetena vanigho mai sakai na goat dale itadira lei nigua volivoli.” Ma Tamar te ghoi ghaghua vania sono, “?Na hava ko heu tua itaeni ge ko patua nia nimua na baubahu, ge ko nia vetena vaniu mai sono na goat dale?” ");
INSERT INTO nlg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma Judah te huatia me ghaghua, “?Vaghaa keri ke, mana hava te liomu ku hegho?” Ma Tamar te bosatughu me ghaghua vania, “E liogu a nimua na gegere ni vaughilala, mana alona, mana totoghona to halaa mai itaeni.” Ma Judah te hea na lei totobo raeni te lioni. Vaho keri ge talana Judah ge ke maturu kolua, mi murina Tamar te logho gari. ");
INSERT INTO nlg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mi murini soko rakiri ge pulohi tana komuna Tamar, me lavi kehaa na tivi te saoa nia na uluna, me nia pupulu itatana nina lei tivi ni kabu matesasania. ");
INSERT INTO nlg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ma Judah te vetenaa kulana mane a Hirah, na tinoni ni Adullam, ge ke lavia na goat dale me ke vaa hea na vaivine, ge ke lavi olighi vania na lei totobo te diki hea. Hauva ka, ma Hirah te mua sodoa gaia. ");
INSERT INTO nlg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ma gaia Hirah te huatira na lei mane tara ghanara tana komu keri, “?Ivei ku tangomana na topoana na vinekama rebi te sopou lilighi ni halautu keri?” Ma gaira na lei mane tara ghaghua vania, “E taho, ai mua loghoa siki vinekama rebi tana komu eni.” ");
INSERT INTO nlg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ma Hirah te pulohi ta Judah me bosaa vania te mua tangomana tua na topoana i siki pilena tana komu keri, maia na hava na lei mane ni komu tara bosaa vania, ge taho siki rebi tana komu keri. ");
INSERT INTO nlg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ma Judah te ghaghua, “Sania iga me ke righitaonighi/talugonighi sono na lei totobo! Iroghita toro mua liona ge rana vure tara kiakia vanighita. Inau tu tabotabo ngangata tua na hea vaa na goat dale, mo ko mua sodoa.” ");
INSERT INTO nlg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mete kaekage ge ke tolu na vula tua i murina keri, na rongorongo te saravia Judah, te logho gari tua Tamar, na vungona, na olilhina na gehegehe ni rebi. Ma Judah te ghaeghahe me ghaghua, “Lavi rughuhorua ma kau mate kerea.” ");
INSERT INTO nlg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hauvaa, mi tana bona tara lavi rughuhorua ge kara vaa matea, agaia Tamar te nia vetena vania vaa Judah na vungona na rongorongo, me ghaghua, “Na mane te loghoi na gegere vaughilala mana totoghona raeni ke, na tamana na dalegu. ?Ivei tea, o vaevane ghilalai sono ighoe?” ");
INSERT INTO nlg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ma gaia Judah te ghilala utoi tara nina na lei totobo, ge ghaghua, “Agaia Tamar te kabu uto maemane vaa vuleu inau, na pukuna tu mua kabu taonia nigua na baubahu ge ku lubatia ge me ke tauna na dalegu a Selah.” Ma Judah te mua ghoi nia maturu kolu a Tamar vuivuni tana bongi keri. ");
INSERT INTO nlg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mi tana bona te sara tua nina bongi ni vahuhu a Tamar, ma gaia te vahuhu baso-ara rua (2) na gari meomeo-mane. ");
INSERT INTO nlg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mi tana bona ni vahuadira, a sakai tadira te diki hauhorua mai na limana, mana vinekama te gonigoni tana bona te vahuhu te pitia na tivi sisi tara suki kirikiria tana guruvatu ni limana na gari te diki horu mai, me ghaghua, “Gaia te diki sivuragha.” ");
INSERT INTO nlg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hauva ka, mi murina eni, na gari te ghoi logu olia na limana, ma gaia na gari keha te horu mai mara diki vahua. Mana vinekama te gonigoni te vahuhu iga te bosaa, “?Eghua ge o samapolo mo diki sivuragha ighoe?” Mi murina vaho ge ara vatua nia Perez. ");
INSERT INTO nlg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Vaho keri ge sivuragha na gari tara pitia na tivi sisi tara suki kirikiria tana guruvatu ni limana. Mara holoa nia Zerah. ");
INSERT INTO nlg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mi tana bona Joseph maia rana lei vure pelupelu/hunulu/sabiri ni kemana Ishmael tara sara tana butunikomu Egypt, a Potiphar e mai pelua Joseph itadira. Agaia sakai tadira na lei mane huhuli a Pharaoh, na vunaghi haba ni Egypt, mana vunaghidira rana malaghai tara righitaonia na vunaghi haba ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","A Yahweh te kabu kolua me vautoa ngangataa haia Joseph tana bona te lutu righitaoni tana valena na vunaghina. ");
INSERT INTO nlg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar te righi kalea me ghilalaa Yahweh te kabu kolua haia Joseph, me vahea na tangomana tana lei totobo soko te gonighi. ");
INSERT INTO nlg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ma Potiphar te nia togotogo Joseph, ge ke gonia nina ghairau heghena, me ke talua Joseph ge ke righitaonighi na valena maia nina na lei lologho soko. ");
INSERT INTO nlg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Vuivuni tana bongi a Potiphar te talua Joseph ge ke righitaonighi na valena maia na lei nina lologho udolu, Yahweh te vautoa Potiphar na pukuna Joseph. Na lei lologho udolu tana valena tara sepalaghi ngangata, maia ghua na hava tara subasuba ta nina leghai. ");
INSERT INTO nlg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Keri ge Potiphar te hea tua na maana Joseph ge ke goni/righitaoni udolui tua na lei lologho soko. Tana bona kabu tua igaa Joseph, Potiphar te mua loghoa tua siki ghanaghana ruarua/gunagunalio sakai vamua na vata ni vanga vaghana kara gonia vania ge ke ghania. Ma Joseph te laga me matakage. ");
INSERT INTO nlg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mi tana lei bongi raeni, na tauna Potiphar te vuivuni na niana gharu a Joseph me nongia ge ke nia maturu kolu. ");
INSERT INTO nlg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma Joseph te mua liona te vaghaa, me ghaghua vania, “O ghilalaa sono ighoe, na vunaghigu te taluutuniu tana lei nina lologho ni valena udolu. ");
INSERT INTO nlg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","E taho siki sakai iani ke loghoa na maana ni righitaoni au vuleu inau. Me taho ghua siki nina lologho te mua heu na righitaoniani, mi ighoe vamua, na pukuna ighoe ke na tauna. Ivei ke ghaghua ge ku gonia inau na vaa i gehegehe dika vaghana te vaghaa keri? Na gehegehe vaghana keri ke, na palu sule tana matana God.” ");
INSERT INTO nlg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ma gaia na tauna Potiphar te tona haliu sono mughua tughu bongi, ma Joseph te laga vulea haia sono me tona sania tana bona te kurukurutia. ");
INSERT INTO nlg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hauva ka, mi ta sakai na dani, tana bona Joseph te lutui na lei lutuna ilokana ni vale, e taho tua siki tinoni ke ghoi ghana kolilia ke dutuvira igaa. ");
INSERT INTO nlg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ma gaia na tauna Potiphar te mai ta Joseph me tabea pupuluna ge sara mai itatana, me kuruti ngangataa, “Mai mo ko maturu kolikoluu tua!” Ma Joseph te tavasua heghena tana limana, ge tona sania. Mi tana bona te tavasua keha itatana, a nina na pupulu te tavasua keha ghua. Ma gaia na tauna Potiphar te taetabea sono na pupulu tana bona Joseph te sama rughu horu sania na vale. ");
INSERT INTO nlg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mi tana bona na tauna Potiphar te vaevanea me ghilalaa te taetabea sono tana limana nina pupulu Joseph imurina gaia te sama tona tua, ");
INSERT INTO nlg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","agaia te vuivuni ni ngangaraha vanira nina ghairau tana valena, me bosa vanira, “Righia! Na seka ni Israel na tauna te pelu/hola mai tana valemami ge ke gonia vanighita na dika. Agaia te mai itagua me tabotabo ge ke lotiu, hauva mi nau tu tangi ngangaraha. ");
INSERT INTO nlg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tana bona te rongovia aeni, gaia te samasaniu, me sania na pupulu i murina.” ");
INSERT INTO nlg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ma gaia na tauna Potiphar te righitaonia sono a nina pupulu Joseph, polo Potiphar te oli mai tana valedira. ");
INSERT INTO nlg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Keri ge na vinekama te tutugua vania nina tutugu, me ghaghua, “Na seka ni Israel to lavia mai tana valeda ge ke lutu vanighita ke, te tabotabo ngangata ge ke lotiu! ");
INSERT INTO nlg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ge ku tangi ngangaraha ke, gaia te sama rughuhoru, me sania nina pupulu iani!” ");
INSERT INTO nlg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Imurina te rongovia nina tutugu a tauna ke, a Potiphar te rutu ngangata! ");
INSERT INTO nlg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Agaia te lavia Joseph me soni haghea tana vale pipiti, tara talura igaa nina lei tinoni pipiti na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Hauva, Yahweh te kabu kolua sono a Joseph i lokana na vale pipiti, me vautoa, mana tinoni te righitaoni nagho ilokana na vale-pipiti te nia togotogo kolua Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Keri ke, na tinoni righitaoni nagho ilokana na vale pipiti te talua Joseph ge ke vunaghidira na lei tinoni pipiti udolu, maia ghua na hava tua ke kale ilokana na vale pipiti. ");
INSERT INTO nlg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Na tinoni righitaoni nagho te mua loghoa siki gunaguna tana hava Josephe te vunaghina, na pukuna Yahweh te kabu kolua me vahea na tangomana tana lei totobo soko te gonighi. ");
INSERT INTO nlg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Te daro ni bona i murini raeni ke, erua na tinoni nagho toro lavi dikaa vania/ihutupua/idutupua Pharaoh. Sakai na vunaghidira rahei tara gonidilaa me vahea na wine a Pharaoh, me ruani na vunaghidira rahei tara gonidilai ghana berete vania Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ma Pharaoh te rutu ngangata vanira nina tinoni nagho raeni. ");
INSERT INTO nlg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ma gaia te soni haghera tana vale pipiti tana vale sulena na vunaghidira rana malaghai tara righitaonia a Pharaoh. Aeni na vale pipiti te ghahaa ghua iga Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Agaira tara kabu ilokana na vale-pipiti te daro ni bona pile, mana vunaghidira rana malaghai te hea na maana itatana Joseph ge ke righitaonira. ");
INSERT INTO nlg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mi ta sakai na bongi, tana bona na mane tabe seu/kapu vania Pharaoh maia na mane biti berete toro maturu, rogaia toro sopa maturubole, ma didira na maturubole e sopa kehakeha na ghanaghana ilokani. ");
INSERT INTO nlg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mi ropoghana tana puipungi, Joseph te righi kalera toro mua reirei togotogodira, ");
INSERT INTO nlg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ge ghaghua vanira, “?Oro ghua ge reirei vaghaghau toro kanoragha tana puipungi taeni?” ");
INSERT INTO nlg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma rogaira toro bosa tughu vanira, “Tana bongi, iroghai tai loghoi na maturubole, hauva e taho na tinoni igaa ge ke toghiani na hava na ghanaghana ilokani.” Ma Joseph te bosatughu, “Na toghiani na ghanaghana i lokani na lei maturubole ke, na lutuna God heghena vamua. Koro bosai vaniu na hava toro sopa righighi ta nimiu maturubole.” ");
INSERT INTO nlg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Na mane te taetabe seu/kapu te diki tutugua nina maturubole me ghaghua, “Ta nigua na maturubole, inau tu righia na alo/ghai tara holoa nia na vaini/vine te tughuru inaghogu. ");
INSERT INTO nlg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na alo/vine te loghoi ara tolu na otona, tara vuivuni ni haga mara vunguvungui ni vuavua/vangagha, me mua hau mara mata na lei vunguvungu ni vuavua. ");
INSERT INTO nlg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mi nau tu taetabea nina seu/kapu Pharaoh, ge ku lavighi na lei vuavua, mu bita haghei na kokoloni ilokana na seu/kapu mu talua tana limana Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ma Joseph te ghaghua vania, “Inau tu ghilalaa na ghanaghana ilokana nimua na maturubole. Ara tolu na otooto ke, ara tolu na bongi. ");
INSERT INTO nlg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ilokani ara tolu na bongi mua itaeni, a Pharaoh ke lavi rughuhorugho tana vale pipiti, me ke ghoi talu pulohigho tana nina vunaghidira rahei tara gonidila me hea na wine. Ge ko ghoi vahea nina seu/kapu vania Pharaoh te vagha te padi tua. ");
INSERT INTO nlg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mu nongi ngangatagho, tana bona ke talu pulohigho a Pharaoh tana lutumu taonia nina dolo mana veiarovi i vuvungamu ke, ge o talutateu vania Pharaoh, mo ko nongia ge ke lubati horuu sania na vale pipiti eni. ");
INSERT INTO nlg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nia tara hunuluu mara peluu mai ani sania na butonikomugu, na butonikomudira rana lei vure ni Israel. Mi taeni inau tu mai ghahau iani lokana na vale pipiti, hauva, mi nau tu mua gonia siki totobo dika ge ku nia kabu pipiti.” ");
INSERT INTO nlg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mi tana bona na mane biti berete te ghilalaa na diki maturubole te loghoa na ghanaghana uto te vaghaa keri, agaia te ghoi tutugu vania ghua Joseph a nina maturubole, me ghaghua, “Ta nigua na maturubole ke, inau tu righighi ara tolu na kei ni vanga tu hungighi tana ulugu. ");
INSERT INTO nlg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I lokana na kei kokou tu loghoi na vata ni vanga vania Pharaoh/na vunaghi haba ni Egypt, hauva na lei manu tara lovo mai mara ghani sokoi na lei vanga rakeri i lokana na kei.” ");
INSERT INTO nlg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ma Joseph te ghaghua vania, “Inau ku tughunia vanigho na ghanaghana i lokana nimua na maturubole. Ara tolu na kei ke, ara tolu na bongi. ");
INSERT INTO nlg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ilokani ara tolu na bongi mua itaeni, a Pharaoh ke pusi kehaa na ulumu/luamu, me ke tari sasaraua na hulimu tana sodu ni ghai tara tughuruvaghinia. Ma rana lei manu kara lovo mai ma kara ghani kehai na lei vinahimu.” ");
INSERT INTO nlg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Me tolu na bongi murina keri, na niana togotogo koukolu na bongi tara vahua igaa Pharaoh te kale. Ma gaia te holora mai itatana lei nina mane nagho tana vangakolu/gougonu. Me vetenara na balu tinoni lutu ge ke kara lavi rughuhorura vania mai sania na vale pipiti, na tinoni nagho te taetabera nina seu/kapu mana tinoni biti ghana berete. ");
INSERT INTO nlg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ma gaia Pharaoh te ghoi talu pulohia na mane te taetabe seu tana lutuna te lutua tana bona te padi. ");
INSERT INTO nlg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Me mua arovia na tinoni biti berete, ge nia vevetena ge kara matera ma kara tari sasaraua na hulina tana sodu ni ghai, te vaghaa tua na hava a Joseph te diki bosadila tua. ");
INSERT INTO nlg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Sakai manaa te vagha keri, nina mane te taetabe seu/kapu a Pharaoh te nia ponolio kasila tua a Joseph, me mua tangomana tua ge ke ghoi ghanaghana kalea. ");
INSERT INTO nlg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","I murini erua na niulu, Pharaoh te maturubolea te tughuru agaia i lilighina na beti tina Nile. ");
INSERT INTO nlg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ta nina maturu bole, te righighi ara vitu na buluka korukoru mara utouto lee, tara vaa puaka dato mai tana beti tina mara vangavanga buburu lilighina na ade. ");
INSERT INTO nlg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mana ara vitu ghua na buluka keha tara ghoi pukuna dato mai tana beti tina sule, hauva ka, mara sighere mana hulilee. Na lei buluka sighere tara sakutua tona mara tughuru lilighidira ara vitu na buluka korukoru. ");
INSERT INTO nlg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Keri ge, rana buluka sighere tara ghani sokora rana buluka korukoru. Mi murini Pharaoh (pharaoh) te righi sokoi na lei totobo raeni, agaia te rarai dato. ");
INSERT INTO nlg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mete mua daro ni bona i murina eni, Pharaoh te ghoi maturu me ghoi righia sono a ruani na maturubole. Tana maturubole eni, agaia te righighi ara vitu na vunguvungu ni koni ta sakai vamua na puku, mana vavangani tara marabu mara utouto lee. ");
INSERT INTO nlg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ma mua hau mua ghoi puaka mai sono ara vitu na vunguvungu ni koni igaa tana puku ia sono keri. Hauva ka, rana vunguvungu kiri raeni ke, ara pororosi mana ghurighuri ni ara te nira mara maluhoru. ");
INSERT INTO nlg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ma rana vunguvungu pororosi tara sonomighi rana lei vunguvungu korukoru tara marabu mara utoutora lee. Ma Pharaoh te ghoi rarai sono vaho, ge ghanaghana kalea na hava te righia ke, te maturubole. ");
INSERT INTO nlg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mi tana bona Pharaoh te ghanaghana taotanonia, tana roropoghana, agaia te ghanaghana ngangataa na hava na ghanaghana i lokani na lei maturubole te righia. Ge holora na lei mane tara logho tidalo ni liliuani na lei totobo ge kara vatei haeharegha, maira na lei vure manaha i lokana Egypt talighu ge tutugua vanira nina lei maturubole. Hauva taho siki sakai te toghiani na ghanaghana ilokani. ");
INSERT INTO nlg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ma vaho ge a nina mane te taetabe seu/kapu na vunaghi haba te kokoe dato me ghaghua, “Itaeni vaho ge ghanaghana olia nigua na liobea. ");
INSERT INTO nlg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tana lei bona te padi ka, to rutu vanighai inau maia na mane nagho ni biti berete, mo talughai tana vale pipiti, ilokana na vale sulena na vunaghidira rana malaghai. ");
INSERT INTO nlg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ta sakai na bongi, toro maturu moro sopa maturubole, ma didira na maturubole e sopa kehakeha na ghanaghana ilokani. ");
INSERT INTO nlg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Moro sopa tutugui nimami na maturubole vania na garimane ni Israel te a nina na ghairau vania na vunaghidira rana malaghai. Ma gaia te bosai vanighai na ghanaghana i lokani. ");
INSERT INTO nlg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mara kale udolu na lei totobo te bosai vanighai ge kara kale. Inau to talu oliu tana lutugu nimua na mane te taetabe seu/kapu, mana mane nagho ni biti berete tara pusia na uluna mara tari sasara na hulina tana ghai tara ghelivaghinia tua.” ");
INSERT INTO nlg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Keri ke, a Pharaoh te vetenara vania Joseph, ma gaira tara nina vamua tua na vaa holaana mai tana vale pipiti. Ma gaia Joseph te mina vamua me sarakehaa/daraa na ghumina me tughui na tivi te haghelighi, ge haghe me va tughuru tana matana Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma gaia Pharaoh te ghaghua vania Joseph, “Inau te maturubole i bongi tana bongi, me taho siki sakai itadira na lei tinoni raeni ke tughuhia/toghia vaniu na ghanaghana ilokani. Hauva ka, mu rongovia ke, mo ko tangomana na toghiani na lei maturubole.” ");
INSERT INTO nlg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ma Joseph te bosatughu vania Pharaoh, me ghaghua, “E au vulea nigua na maana na goniana te vaghaa eni, hauva, ma God ke bosai vanigho na ghanaghana ilokani, me ke hegho na togholuvu ta nimua na ghanaghana ruarua.” ");
INSERT INTO nlg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ge a Pharaoh te tutugua vania Joseph na maturubole, me ghaghua, “Inau tu tughuru tana lilighina na beti tina sule Nile. ");
INSERT INTO nlg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","E mua hau vasoo ka, ara vitu na buluka korukoru maia tara utoutoa lee tara puaka dato mai tana beti tina, mara vuivunia na vanga buburu tana lilighi/dike ni beti. ");
INSERT INTO nlg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mara ghoi puaka dato mai sono tana beti tina sule ara vitu na buluka keha. Na buluka kiri raeni ke ara too sighere mara hulilee vamua - tu mua righia mua siki maumanu ke reirei dikana vaghara ilokana Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Rana buluka sighere mete dika ka reireidira tara ghani sokora ara vitu na buluka korukoru tara diki puaka mai tana beti tina sule. ");
INSERT INTO nlg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Mi murina rana buluka sighere tara ghani sokora rana buluka korukoru, agaira rana buluka sighere tara sighere mara hulilee vaghara sono tana bona te padi. Mi murini tu righighi raeni, inau tu rarai dato. ");
INSERT INTO nlg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Me pile bona vasoo imurina ka, mu ghoi righia sakai na maturubole sono. Tana maturubole ia eni ke, tu righighi ara vitu na vunguvungu ni koni ta sakai vamua ni puku tara too vatoro maira sulelee. ");
INSERT INTO nlg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mi tana puku ia sono keri, tara ghoi puaka mai ara vitu na vunguvungu ni koni tara pororosi, mana ghurighuri ni ara te nira mara maluhoru. ");
INSERT INTO nlg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma rana vunguvungu pororosi tara sonomira rana vunguvungu tara vatoro mara utoutoa lee. Inau tu tutugui vanira nigua na lei vure tara manaha/loghoi na lei tidalo ni liliuani na lei totobo ge kara vatei haeharegha, me taho tua siki sakai tadira ke tangomana na bosaana vaniagu siki ghanaghana ilokana rana maturubole.” ");
INSERT INTO nlg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ma Joseph te bosa vania Pharaoh, “Agaira udolu ara rua na maturubole toro loghoi sakai na vata ni ghanaghana vamua. A God te bosadilaa vanigho na hava ke gonia tana lei niulu kara mai. ");
INSERT INTO nlg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","A gaighi ara vitu na buluka korukoru maira ara vitu na vunguvungu ni koni tara vatoro mara sule ke, ara vitu na niulu ni lologho vanga, na niulu ni siosio mana baobaore. ");
INSERT INTO nlg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ra vitu na buluka sighere mana vunguvungu ni koni pororosi maia ara sesebe ke, ra vitu na niulu ni vitolo mana ngengere. ");
INSERT INTO nlg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tana lei niulu kara mai inagho kara kale na lei ghanaghana raeni taonia na hava tu bosaa vanigho itaeni, na pukuna a God te talutatea vanigho na hava ke dutu gonia. ");
INSERT INTO nlg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","A gaighi ara vitu na niulu kara mai nagho raini ke, a gaighi na lei niulu ni lologho vanga/siosio koni i Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hauva ka, mai murini ara vitu na niulu ni siosio ke, ara vitu na niulu ni vitolo pana ngengere. Ma rana vure tara ponolio na lei niulu ni lologho na pukuna na ngengere te sule ngangata me ke dikalai na lei komu i Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Eo, na ngengere vaghana eni, ke dika ngangata, me ke nighita ma ka mua ghanaghana oliani na lei niulu te uto. ");
INSERT INTO nlg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Na lei totobo raeni kara kalei utuni sughua/mughua na pukuna God te tughunitatea vanigho na rongorongo eni tana erua na maturubole, me ke mua daro ni bona me ke nighi ge kara kale. ");
INSERT INTO nlg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Age Vunaghi haba, a nigua na ghanaghana ke, ko kenea siki sakai te manaha au vule tua i Egypt talighu mo ko talua ge ke vunaghina na talugoni vania na butonikomu i Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Age Pharaoh, lubatigho ge ko vilira/taludatora na balu vure nagho i lokana Egypt talighu, ma kara vahikolui a sakai na lima/limani (1/5) tana vunguvungu udolu kara sioi/siosioi lokani ara vitu na lei niulu ni lologho vanga/siosio koni. ");
INSERT INTO nlg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ke vetenara ge kara vahikolui na lei vanga mana koni i lokana ara vitu na lei niulu ni uto tana vanga, ma kara talugoni toghoi tana lei vale ni talugoni/baore nia nimua na maana, ma kara righitaonighi keri ge ka logho vanga tana lei komu sule i lokana Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na samalaghi ia mughua keri, ge ka loghoa na vanga te manani ge ka ghanighi tana bona kara sara mai ara vitu na niulu ni ngengere. Keri ke, rana vure ni Egypt te mua matea tana vahola ni ngengere. ");
INSERT INTO nlg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","A Pharaoh maira na lei mane huhuli tara holopangotia nina ghanaghana Joseph te bosaa vanira. ");
INSERT INTO nlg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mi tana bona tara detea ahei sughua te manana ge ke lutua na lutu vaghana ke, a gaia Pharaoh heghena te huatira me ghaghua, “?Ahei ke lutu utoa na lutu eni vulea Joseph? Agaia na tinoni te vonughi utunia nina tarunga God.” ");
INSERT INTO nlg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ma Pharaoh te bosa vania Joseph, me ghaghua, “Ma God te tughunitatei vanigho na ghanaghana ilokani na lei maturubole ke, keri ke, ighoe tua na tinoni to manaha au vule ngangata itaeni iani Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Inau tu viligho itaeni ge ko taghaoa na samalaghi eni. Ighoe tua ko vunaghini nigua na lei lologho mo ko padalaghinira nigua na lei vure udolu. Mi nau heghegu vamua ge ku loghoa na maana ni vunaghi te haba vulea nimua na maana ighoe. ");
INSERT INTO nlg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ma Pharaoh te ghoi ghaghua vania Joseph, “Inau tu viligho mu talugho ge ko righitaonia na butunikomu Egypt talighu.” ");
INSERT INTO nlg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Keri vaho ge talua nina papada/ringi ni vaughilala heghena tana gigirina Joseph te vaghaa na vaughilalana nina malei haba. Me pupulua nia na lei tivi tara utoutoa lee, me talua ghua na ghalolua ni gold tana luana. ");
INSERT INTO nlg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ge talua Joseph ge ke haehaghe tana taitakiro ni tinoni haba te sasaraua gaia oli heghena, mi vei tua ke tona vaa ilokana Egypt talighu ke, nina rana kisumate ke ghaeghahe me ke ghaghua, “Tualaghi tuturu horu!” Keri ke, a Pharaoh te talua tua Joseph ge ke haba pungisia Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma Pharaoh te ghoi ghaghua vania sono a Joseph, “Inau tua na vunaghi haba, me taho siki sakai ge ke gonia siki totobo i lokana Egypt talighu, ke vaghaa ko mua talana ighoe.” ");
INSERT INTO nlg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ge agaia Pharaoh te tughua na ahana Joseph, me ghoi holoa nia Zaphenath-paneah, me hea na tahula tara holoa nia Asenath, ge ke tauna. Agaia na dalena vaivine a Potiphera, na mane sukaghi ni Heliopolis. Ma Joseph te vunaghi pungisia tua Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","A Joseph te haghe tana lutu vaniaana Pharaoh tana bona te saravia tua te tolu hangavulu (30) na niuluna. Mi tana bona Joseph te rughuhoru sania Pharaoh ke, agaia te tona kolili ni vaevane i lokana Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Me utuni sughua, i lokani ara vitu na niulu ni uto raeni, na lei subasuba ilokana Egypt talighu tara vavangagha uto. ");
INSERT INTO nlg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mi lokani na lei niulu rakiri ke, a Joseph te lavighi na pileni tana lei subasuba soko talighutia Egypt, me baorei tana lei komu sule dutuvia mai. ");
INSERT INTO nlg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","I murini ara vitu na niulu ni uto, na lei vale ni baobaore tara vonu mara katakata mara mua malagha tua. Ara too suba au vule na lei koni/vanga, vaghaa tua na suboni na saghalea tana saravahale, keri ge na lei vure kara mua tangomana na padangiani ara ngiha gaighi udolu. ");
INSERT INTO nlg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","I lokana na lei bonabona raeni inaghona ge sara mai na vuivuni ni niulu ni vitolo pana ngengere, a Joseph ma tauna Asenath, na dalena vaivine a Potiphera na mane sukaghi ni Heliopolis (Heliopolis) toro vahura tua erua na daledira mane. ");
INSERT INTO nlg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A Joseph te holoa nia Manasseh na kamanagho, na pukuna te ghaghua, “A God te niu keri ge u nighi ponolio nigua na lei vahola maira nina binaboli a tamagu.” ");
INSERT INTO nlg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Me holoa nia Ephraim eruani na dalena, te ghaghua, “A God te neu keri ge u vaivarigha tana butunikomu ni vahaghitailiagu eni.” ");
INSERT INTO nlg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ara vitu na niulu ni lologho vanga tara soko tua. ");
INSERT INTO nlg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ara vitu na lei niulu ni vitolo mana ngengere tara vuivuni tua, taonia te vagha Joseph te diki bosaa tua. Na ngengere ghua tana lei butonikomu talighutia Egypt, hauva ka, mara subo au vule na vanga i lokana na lei vale ni baobaore i Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","I lokana Egypt talighu, na lei vure udolu tara nia vahaghitaili tua na vitolo. Mara nongi ngangataa Pharaoh ge ke hera na vanga, ma Pharaoh te ghaghua vanira, “Kau tona ma kau padapada vania Joseph, ma kau goni taonia na hava te bosaa vanighau.” ");
INSERT INTO nlg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma nia na ngengere te sule ngangata tana lei komu talighutia Egypt talighu, a Joseph te hangavighi na lei vale ni baobaore me sabirighi na lei vuavua ni koni/vanga vanira na lei vure ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mana lei vure tana lei butonikomu talighutia Egypt tara mai i Egypt, ge kara mai pelu vangavanga na pukuna na ngengere te sule ngangata ilokana na maramana talighu. ");
INSERT INTO nlg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mi tana bona Jacob te rongovia te ghanaa sono na koni/vanga i Egypt, agaia te bosa vanira lei dalena ma ghaghua, “?Ivei te ghaghua ge au tughuru kolili mau sopa vaevane heghemiu? ");
INSERT INTO nlg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","U rongo me ghanaa sono na koni/vanga i Egypt. Kau sughi/tona va ma kau pelui vanighita mai na balu koni/vanga inaghona ge ka nia mate udolu na vitolo.” ");
INSERT INTO nlg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Keri ge, agaira ara hangavulu na lei hoghona/tughana Joseph, tara diki itatana gaia tara sughi/tona va i Egypt na vaa pelu koni/vanga. ");
INSERT INTO nlg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","A Jacob ke mua lubatia Benjamin na tahina Joseph ge ke tona kolura, na pukuna te mataghu siki totobo te mua uto ke kalea. ");
INSERT INTO nlg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ma gaira na lei dalena Jacob kolura na balu vure keha ghua tara sara Egypt na pelu vanga, na pukuna na ngengere te torora ghua tua rana vure ni Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mi tana lei bongi rakiri a Joseph te haba pungisia Egypt talighu (te governor), me logho maanana na hunuluani na lei koni/vanga. Keri ke, na lei hoghona tara mai poghotao tana matana. ");
INSERT INTO nlg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mi tana bona vaghana tua eni, a Joseph te vaevane ghilalara tua tara hoghona, ma gaia te vaghaa sono na tinoni keha itadira. Me kokoe ruturutu vanira, me ghaghua, “?Na vure ni vei ighau?/?Ivei tau butu mai, ighau?” Ma gaira tara bosa tughu vania mara ghaghua, ‘Ighai ke, na vure ni Canaan. Ighai tai mai ge kai pelu koni/vanga.” ");
INSERT INTO nlg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Sakai vamua Joseph te vaevane ghilalara sono tara hoghona tua agaira, ma gaira na lei hoghona tara mua vaevane ghilalaa Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ma Joseph te ghoi ghanaghana olia nina maturubole tara subo ngangata tua na niulu te padi. Me ghaghua vanira, “Ighau rana sigho! Tau mai ge au vaevane popoloa ivei te ghaghua na luguna na komumami!” ");
INSERT INTO nlg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma gaira tara ngangaraha vania, mara ghaghua, “Aghe ighoe a nimami na maghutu, e taho. Ighai tai mai ge kai pelu vanga vamua. ");
INSERT INTO nlg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ighai ke, na lei tamahoghoni vamua, maia tai mua na lei tinoni sorisori. Aghe na haba, ighai tai mua rana vure sigho!” ");
INSERT INTO nlg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma Joseph te hughuhughura sono, me ghaghua, “Taho! Ighau tau ge kau kene sodoa ivei te ia na dikalaamami na ngengere.” ");
INSERT INTO nlg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ma gaira tara ghaghua vania, “Aghe vunaghi, ighai ke, ara hangavulu rua (12) na lei tamahoghoni vamua, ma tamamami ke ghaha tana butonikomu i Canaan sono. Mana hoghomami na sosoko te kabu kolia sono a tamamami tana komu itaeni, ma sakai na hoghomami te mate tua.” ");
INSERT INTO nlg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ma Joseph te hughuhughu ngangatara sono, me ghaghua, “Te vaghaa tu bosaa vanighau tua, ighau ke, rana sigho. ");
INSERT INTO nlg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Inau ku nia na kene taonina a nimiu na tutugu te utuni. Inau tu baubahu tana volana Pharaoh, kau mua rughuhoru sania iani Egypt koekobe kau lavia mai hoghomiu na sosoko. ");
INSERT INTO nlg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sakai tamiu ke tona me ke lavia mai a hoghomiu mi ghau na balu ku righitaonighau sono tana vale pipiti, keri ge ku kene sodoa na utunina pana kikona nimiu na tutugu. Ma ge ke tatelaghinia tau mua loghoa siki hoghomiu na sosoko ke, vaho ge ku ghilalaa tau rana sigho.” ");
INSERT INTO nlg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Keri ge agaia te talura tana vale pipiti e tolu na bongi udolu. ");
INSERT INTO nlg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mi tana toluni na bongi, Joseph te bosa vanira, “Inau ke na tinoni tu nia kikinima haia God. Ma ge kau goni taonia na hava tu bosaa vanighau ke, igevaa kau vola. ");
INSERT INTO nlg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ke vagha ighau rana vure tara maemane ke, lubatia asakai vamua itamiu ke ghaha olia tana vale pipiti. Mi ghau udolu na balu kau nighi pulohi tana komumiu kolui na lei vanga vanira nimiu na binaboli. ");
INSERT INTO nlg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Keri ge kau holaa mai itagua na hoghomiu sosoko. Tana bona eni, inau ku ghilalaa, au nia kokoe vaniu na utuni pe taho. Ge ke utunimiu ke, inau ku mua mateghau.” Ma gaira na lei hoghona tara lavipangotia te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ma gaira tara sopa kokoe heghedira, mara ghaghua, “Aeni te kaleghita na totoro eni na pukuna na hava ta gonia vania Joseph tana bona te padi. Ighita ta sopa righia nina dikalio mana vahaghitaili, ma rongovia nina lei nongi kukuruti, hauvaa, mi ghita ta mua rongovi arovia. Mughua ge mai sodoghita na vahola eni.” ");
INSERT INTO nlg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Reuben te huatira ma ghaghua, “?Ivei te ghaghua, u mua bosaa vanighau ge ka bei gonia vania te vaghaa? Hauva ka, mau mua rongoviu. Igevaa ka mate ighita na pukuna ta matea gaia na hoghoda Joseph.” ");
INSERT INTO nlg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ma gaira tara mua ghilalaa Joseph te rongovi ghilalaa sono na hava tara bosa, na pukuna gaia te kokoe vanira tana leu te keha, ma siki sakai keha te kokoe vanira tana leudira tughua gaia. ");
INSERT INTO nlg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ma Joseph te sania na voki tara ghahara, ge tangi. Tana bona te beto, gaia te ghoi oli-mai tadira, me ghoi kokoe kolura. Ge vilia tua a Simeon itadira, mara pitia tana matadira na lei hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ma Joseph te vetenara nina tinoni lutu ge kara vonughighi didira na lei sopa kirisa na lei hoghona nia na koni/vanga, ma kara taluolighi sopa didira rongo tara nighi pelu ta didira sopa kirisa. Me bosa ghua ge kara vahea na vanga kara ghanighi tana halautu tana bona kara pulohi. ");
INSERT INTO nlg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na lei hoghona tara kuikutighi/Ma gaira tara tali didira na lei kirisa ni koni/vanga i vuvungani sopa didira na lei donkey, mara pulohi tana komudira. ");
INSERT INTO nlg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mi tana bona tara beto ge kara maturu tana halautu tana komudira, sakai tadira te hangavia nina kirisa ge ke lavighi na balu vuavua ni koni me ke kutira na lei donkey, ma gaia te righi sodoi sono nina rongo ilokana nina kirisa. ");
INSERT INTO nlg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Agaia te holora na lei hoghona me ghaghua vanira, “Kau righia mai! A nigua na lei rongo sono raeni ilokana nigua na kirisa.” Ma gaira udolu te vonughira na mataghu mara sopa kokoe heghedira, “?Na hava vaho tua te kabaria vanighita God ighita?” ");
INSERT INTO nlg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mi tana bona gaira tara sara tana tamadira Jacob tana butonikomu i Canaan, tara tutugui vania na lei totobo tara kale i vuvungadira. ");
INSERT INTO nlg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Mara ghaghua vania, “Na mane te vunaghi pungisia na butonikomu i Egypt talighu te too kokoe rutu vanighai. Agaia te lavihahighai, te ghanaghana gaia tai vure sigho mara vaevane popoloani na lei totobo ilokana na butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Hauvaa, ighai tai bosa vania mi ghaghua, ‘Ighai tai puku ni tinoni utuni vamua! Maia tai mua rana sigho! ");
INSERT INTO nlg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ighai ke, ara hangavulu rua na tamahoghoni vamua, na lei dalena sakai vamua na mane. Asakai na hoghomami te mate, mana hoghomami na gari sosoko te kabu kolura sono a tamamami tana komumami tana butonikomu i Canaan.’ ");
INSERT INTO nlg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ma gaia na mane huhuli/haba te bosa tughu, ‘Aeni na hava ku gonia ge ku kene sodoa tua na lei tinoni maemane sughua. Kau sania vaniu a sakai na hoghomiu iani, ma kau lavighi na lei vuavua ni koni/vanga vanira nimiu na binaboli ma kau pulohi tana komumiu. ");
INSERT INTO nlg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ma kau holaa vaniu mai hoghomiu na sosoko tana bona kau pulohi mai. Keri ge ku ghilalaa tau rana vure maemane, mau mua rana sigho. Mu ku lubatia vanighau na hoghomiu, ma kau mai talau sono ke vaghaa ke liomiu na mai pelu vuavua ni koni/vanga.’” ");
INSERT INTO nlg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tana bona tara sopa kovalai didira na lei kirisa ni koni/vanga, agaira tara sopa righighi sopa didira kirisa pile ni rongo tara nighi pelu tua i vuvungani na lei koni/vanga. Mi tana bona tara righighi na lei rongo, na mataghu te sopa vonughira, me vaghaa ghua na tamadira. ");
INSERT INTO nlg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma tamadira Jacob te ghaghua vanira, “Ighau tau peneu/lavipolo vaniu na lei dalemu! Joseph te mate, Simeon te ghoi tona keha, mi ghau tau ghoi liona na laviana Benjamin. Inau tu vahaghitaili na pukuna na lei totobo soko raeni tara kale vamua i vuvungagu!” ");
INSERT INTO nlg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ma Reuben te ghaghua vania tamana Jacob, “Ge ku mua laviolia vanigho mai Benjamin ke, ko matera erua na dalegu ke vaghaa ke liomu. Inau ku nia kaukauli na righitaoniana Benjamin.” ");
INSERT INTO nlg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Jacob te ghaghua vanira, “Na dalegu Benjamin ke mua nighau udukolu horu i Egypt, nia na pukuna a hoghona Joseph te mate tua, ma gaia heghena vamua te ghana olia ta tinana te vahura rogaira. Ge ke va kalea siki totobo tana bona ke nighau udukolu ke, inau na manerau mi gevaa na dikalio kau laviu vamua ku nia mate.” ");
INSERT INTO nlg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mana ngengere te tona haliu sono ilokana Canaan talighu. ");
INSERT INTO nlg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Mi tana bona nina binaboli Jacob te ghanighi soko ghadira na lei koni/vanga tara va pelui mai tua i Egypt, A Jacob te ghoi ghaghua vanira na lei dalena, “Kau ghoi tona ghua i Egypt, ma kau vaa pelui vanighita mai na vanga/koni.” ");
INSERT INTO nlg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Judah te ghaghua vania tamana, “Na mane huhuli Egypt te bosaa vanighai ge kai mua ghoi righi matana ke vaghaa kai mua lavia vania vaa Benjamin. ");
INSERT INTO nlg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ma ge ko lubatia sono Benjamin ge ke mai kolughai ke, ma kai ghoi sughi/tona sono na va pelu vanga. ");
INSERT INTO nlg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kai mua tona, ke vaghaa ko mua lubatia Benjamin na tona koluamami. Ko ghanaghanaolia na hava te bosaa vanighai na mane huhuli, ‘Kara mua talamiu tua ge kau mai righi matagu ke taho hoghomiu na sosoko itamiu.’” ");
INSERT INTO nlg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ma tamadira, a Jacob te hughuhughura sono me ghaghua, “?Ivei vaho tua te vaghaa na vahaghitaili vaghana tua gonia vaniu, ge au tughunia vania tau loghoa sono a sakai na hoghomiu?” ");
INSERT INTO nlg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ma gaira tara bosatughu, “Agaia na mane huhuli te huati taotaonighai nia dida na binaboli. E liona ngangata na ghilalaana te vola sono a tamamami pe taho, me huatighai nia ghua tai loghoa sono a sakai na hoghomami pe taho. Keri ge ai tughunia vania. ?Ivei te ghaghua ge kai tangomana na ghilalaana ge ke bosa vanighai, ‘Au lavia mai sono hoghomiu iani?’” ");
INSERT INTO nlg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ma Judah te ghaghua vania tamana, “Ko lubatia vaniu na garimane, ma kai tona tua ighai, keri ge ighai, mi ghoe ghua maira na lei dalemami rana lei gari pile udolu ka mua nia mate na vitolo. ");
INSERT INTO nlg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Inau heghegu tua ku nia vavaita na volana Benjamin, mi nau tua ku nia kaukauli kasila na huhuru ge ke mua laviolia vanigho mai. ");
INSERT INTO nlg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ge ke mua mo toghai nia na hoveana Benjamin ke, me rua tughuru ni tona olioli tua itaeni ighai.” ");
INSERT INTO nlg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma tamadira Jacob te bosa vanira, “Ge ka mua tangomana tua na tughuru pungisiana ke, kau gonia vamua te vaghaa eni. Kau hogho nighi ta nimiu na kirisa na lei totobo tara utoutoa lee ilokana na butonikomu i Canaan. Ma kau holai vania na mane huhuli vaghai a nimiu na dolo vaniana, na balm, na kokolo ni midua, na lei vata ni vanga uruurua, a myrrh, na lei ghadogha mana ngali. ");
INSERT INTO nlg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kau holai na lei rongo tau sodoi sono ilokani lei nimiu sopa kirisa, ma kau holai ghua te vaghai na suboni ma kau padangi kolui nighi, na pukuna, sogea ara talu hahighi ilokani lei nimiu na kirisa. ");
INSERT INTO nlg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ma kau lavia hoghomiu a Benjamin ma kau pulohi tana mane huhuli. ");
INSERT INTO nlg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A God puku ni maana ke va heghau na veiarovi tana bona kau na righi matana na mane huhuli, ge ke lubatia vanighau Simeon, me ke nia vetena pulohi mai a Benjamin. Ma ge mu ku nia hohola na niana dikalio na mateadira rana dalegu ke, me ke ghaghua tua igaa.” ");
INSERT INTO nlg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ma gaira tara lavia Benjamin maighi didira na lei dolo, maighi ghua na lei rongo tara vaghai sono ghua a suboni tara laviolighi mai ta didira na lei sopa kirisa maighi gaighi tara laviolighi mai mara mina tua mara tona i Egypt. Igaa tara va tatera heghedira vania Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mi tana bona Joseph te vaevanea Benjamin te mai kolura, agaia te ghaghua vania na vunaghina na valena, “Na lei mane raeni ke, kara vanga koluu tana danikama taeni. Ko lavi haghera na valegu mo ko gonidilaa na vanga sule na vatei vanga koluadira. ");
INSERT INTO nlg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mana mane te vunaghina na valena Joseph te gonia na hava Joseph te bosaa vania, me lavi haghera tana vale sulena Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Na mataghu sule te sodora tana bona tara righia ivei tara lavira vaa igaa. Ma gaira tara sopa ghanaghana heghedira, “Aeni na pukuna na lei rongo tara talu pulohighi ilokani dida na lei kirisa tana bosa ta pulohi. Agaia te ghanaghana ge ke lotighita te vaghaa rana tinoni gito, me ke pitighita vaghaghita na tinoni seka, me ke holai ghua dida na lei donkey.” ");
INSERT INTO nlg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tana bona na lei tamahoghoni tara sara mua tana mataula haghena na vale sulena Joseph ke, mara tona tahaliu vaa tua itatana na mane te vunaghina na vale. ");
INSERT INTO nlg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Mara ghaghua vania, “Vunaghi, i murina na diki maiamami iani na pelu vanga ka, ");
INSERT INTO nlg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","mi tana bona tai pulohi tana komu, ighai tai beto tana halautu na pukuna te bongi tua, mai sopa hagavaghi nimami na lei kirisa mai sodoi na lei rongo tai nighi pelu tua tara ghanai sono. A gaighi raeni tai lavi pulohighi mai. ");
INSERT INTO nlg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ai sopa lavi rongo mai sono ighai na vatei pelu koni/vanga tana maiamami eni. Ai mua ghilalaa ivei te ghaghua ge ara ghana pulohighi sono na rongo raeni ilokani nimami na lei sopa kirisa.” ");
INSERT INTO nlg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mana vunaghina na valena Joseph, te ghaghua vanira, “Kau kabu (beto/hodo) vamua, bei nia ghaghua gea. A nimiu na God, te didira na God na lei kukuamiu/vaivarimiu, sogea te talui igaa ilokani nimiu na sopa sopa kirisa. Ighai tai lavighi sono nimiu na rongo tau nighi pelu.” Keri ge lubatia Simeon tana vale pipiti, me lavihorua vanira mai. ");
INSERT INTO nlg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ma gaia te hulira rana lei tamahoghoni vaa ilokana na vale sulena Joseph, mara hera na beti ni apoani na tuadira, mana lei vanga ge kara kutira didira na lei donkey. ");
INSERT INTO nlg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Me bosaa vanira ge kara vanga dani tana vale eni, keri ke, ma gaira tara gonidilai didira sopa dolo vania Joseph ge kara hea tana oliana mai tana danikama. ");
INSERT INTO nlg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mi tana bona te sara haghe mai a Joseph, agaira tara sopa hea didira dolo, mara tualaghi tuturu horu kikinima vania inaghona tana matana. ");
INSERT INTO nlg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ma gaia Joseph te huatira nia ivei sono te ghaghua na kabuadira, ge ghaghua vanira ghua, “?Ivei sono te ghaghua tamamiu, na tonikama tau bosa vaniu tana bona te padi, e vola sono pe taho?” ");
INSERT INTO nlg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ma gaira tara ghaghua vania, “E vola uto sono.” Ge ara ghoi tualaghi tuturu kikinima vania. ");
INSERT INTO nlg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mi tana bona Joseph te vaevanea vaa a hoghona a Benjamin, agaia te huatira me ghaghua, “?Agaia tua eni hoghomiu na pile/sosoko tau bosaa vaniu?” Ge ghaghua vania Benjamin, “Aghe a dalegu, a God ke vahegho nina lei sonihalavu.” ");
INSERT INTO nlg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ma Joseph te vonughia na dolo nia na hoghona, me dutuvia ge ke tangi, keri ge mina rughuhoru sanira, mu vaa haghe tana vokina me vaa tangi ilokana. ");
INSERT INTO nlg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Murina te tangi soko, ge sani rana matana mu mamahai soko, ge ghoi mai itadira na lei hoghona, me patua heghena sono. Me bosa vania nina tinoni ni lutu vanga, “Ge ko holai mai na lei vanga.” ");
INSERT INTO nlg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Joseph te sopou ni vanga heghena ta nina bela ni vanga, mara kutira na lei hoghona tana bela ni vanga keha. Rana lei vure ni Egypt tara sopoudira tana bela ni vanga heghedira na pukuna tara nira sika rana Israel, mara mua liona na vanga koluadira. ");
INSERT INTO nlg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma Joseph te tughunia vanira na lei hoghona ivei kara sopa sopou mara sopa hare, na pukuna te sopa sopou laghinia taonia sopa niuludira, vuivuni tana diki me sosoko tana vahuhu sosokoana. ");
INSERT INTO nlg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Na ghadira na vanga tara holaa/seni vanira mai ta nina bela ni vanga Joseph. Ma ghana vanga Benjamin te sule vulei ghadira gaira na lei hoghona udolu, e lima na tughuru ni sulena. Ma gaira udolu tara vanga mara inu tatavahale kolua Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tana bona tara gonidila ni pulohi na lei hoghona, Joseph te bosa vania na mane te vunaghi pungisighi nina lei lologho ni valena, me ghaghua vania, “Hoghonighi didira sopa kirisa mai na koni/vanga ma kara vonu, ke manadira ge kara sopa holai. Mo ko taluolighi didira sopa rongo tara sopa nighi pelu ilokani didira na lei kirisa. ");
INSERT INTO nlg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mo ko talua nigua na kapu silver ilokana nina kirisa a hoghodira na sosoko, mo talukolua nia nina na lei rongo te nighi pelu koni/vanga.” Mana mane te vunaghina na valena Joseph te goni taonia na hava Joseph te bosaa vania. ");
INSERT INTO nlg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na lei tamahoghoni tara rarai dato tona labota mua, mara rughuhoru tughuru ni tona ge kara pulohi tana komudira, nira didira na lei donkey tara sopa ludangighi. ");
INSERT INTO nlg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mi tana bona tara rughuhoru sania na komu sule, Joseph te ghaghua vania te vunaghina na valena, “Ko sama taonira mo ko betora. Ko huatira, ‘?Ivei te ghaghua ge au peluolia nia na dika na lei gehegeheni dolo? ");
INSERT INTO nlg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","?Na hava tau ghanaghanaa ge au gitoa nina kapu silver na vunaghigu? Agaia na kapu keri ke te hangaa ge ke ghilala kabu me ke diki bosadilai na lei totobo kara kale tana lei bongi sara mai inagho. Ighau tau gonia na hahi sule!’” ");
INSERT INTO nlg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ma gaia te sodora me bosai vanira nia na hava Joseph te bosa vania. ");
INSERT INTO nlg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma gaira na lei tamahoghoni tara bosatughu vania mara ghaghua, “?Vunaghi, na hava na totobo ia to bosaa? Ighai tai papari vanigho, ge kai mua gonia siki totobo te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ko ghilala tai laviolighi mai na lei rongo tai sodoi ilokani nimami na lei kirisa tana bona te padi! ?Na hava na pukuna ge kai gitoi na silver pana gold tana valena na vunaghimu? ");
INSERT INTO nlg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ge ko sodoa ilokana nina kirisa siki sakai itamami na kapu ke, sania na tinoni keri me ke mate. Mi ghai udolu na balu kai nina seka na vunaghimu tana lei bongi ni volamami.” ");
INSERT INTO nlg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mana mane te vunaghina na valena Joseph te bosa tughu me ghaghua, “E maemane sono, agaia vamua na tinoni te lavia na kapu ke vaghaa na seka. Mi ghau udolu na balu ge kau tatavahale.” ");
INSERT INTO nlg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Gaira na lei tamahoghoni tara mina tua mara lavihorui didira na lei kirisa tana vuvunganidira na lei donkey, mara hangavighi vania. ");
INSERT INTO nlg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma nina ghairau a Joseph te te vuivuni ni heghiani didira na lei kirisa, me vuivuni tana kamanagho me sosoko tana kamamuri/gari sosoko. Mara topoa na kapu ilokana nina kirisa a Benjamin. ");
INSERT INTO nlg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nina na hava te kale, agaira tara rosighi didira na tivi nia na dikalio, mara ludangi olighi didira na lei kirisa i vuvunga nina lei donkey mara ghoi pulohi oli tana komu sule. ");
INSERT INTO nlg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","A Joseph te kabu sono tana valena tana bona tara sara haghe tana vale a Judah maira na lei hoghona. Ma gaira tara poghotao horu vania tana matana inaghona. ");
INSERT INTO nlg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma Joseph te ghaghua vanira, “?Na hava tau tabotabo ge kau gonia? ?Au mua ghilalaa ighau na tinoni te vaghau inau ke ghilalaa sono ahei na tinoni ia te gito?” ");
INSERT INTO nlg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ma Judah te ghaghua vania, “?Aghe nigua na vunaghi/maghutu, na hava kai bosaa vanigho ighai? ?Ivei kai nia na kurutiamu? ?Ivei kai nia na talutateana vanigho a nimami na tatavahale? God te heghai na totoro nia na lei palumami. Nigua na vunaghi/maghutu, ighai tai oli mai ge kai nimua na lei seka, ighai maia na hoghomami te lavia nimua na kapu ilokana nina kirisa.” ");
INSERT INTO nlg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Joseph te ghaghua vanira, “E taho, agaia vamua te gitoa na kapu ke nigua na seka. Mi ghau udolu na balu keha, kau pulohi sono ta tamamiu tana komumiu.” ");
INSERT INTO nlg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ma Judah te sakutua pile vaa inaghona Joseph ge ghaghua vania, “Nigua na maghutu/vunaghi, lubatiu ge ku tutugua vanigho vamua a sakai na tutugu kukuluu, mo ko kabu rurughu pile bona vaniu ghua. Aghe maghutu, inau tu ghilala nimua na maana te haga vaghaa ghua tua nina maana Pharaoh, keri ge ko mua rutu vaniu. ");
INSERT INTO nlg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Aghe nigua na maghutu, ighoe to huatighai tana bona te padi mo ghaghua, ‘Te ghahaa sono a tamamami pa hoghomami?’ ");
INSERT INTO nlg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Mi ghai tai bosaa vanigho, ‘Agaia te ghahaa sono a tamamami, te tonikama tua. Me loghoa na dalena na mane na sosoko, te vahua tana bona te tonikama tua. Na hoghona te mate tua, ma gaia heghena vamua te ghaha olia itatana tinadira rogaira. Ma tamamami Jacob te dolovi ngangataa gaia.’ ");
INSERT INTO nlg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mi ghoe to bosaa vanighai, ge kai holaa vanigho mai mo ko vaevane agaia. ");
INSERT INTO nlg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Hauvaa, mai bosaa vanigho tua, ‘Aghe nigua na Maghutu, ge na garimane pile ke, ke mua tangomana tua na saniana tamana, e mua uto ke mate gea tamana.’ ");
INSERT INTO nlg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hauva ka, mo bosaa vanighai te vaghaa eni, ‘Sogea kau mua ghoi righi matagu koekobe kau lavia mai hoghomiu na sosoko.’ ");
INSERT INTO nlg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mai na bosaa vania tamamami na hava to bosaa vanighai tana bona tai pulohi mai sara tana komu. ");
INSERT INTO nlg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mi tana bona na tamamamai te bosaa vanighai, ge kai ghoi pulohi mai ni peluani balu vanga/koni ke, ");
INSERT INTO nlg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ighai tai ghaghua vania, ‘Kai mua tangomana na tona, ko talana vanighai mughua hoghomami na sosoko ke tona kolughai, kara mua tangomana tua na talama mai. Kara mua tangomana tua na lubatiamami na vaa righi matana na mane te vunaghi pungisighi na lei vanga/koni koekobe hoghomami na sosoko ke tona kolughai.’ ");
INSERT INTO nlg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Keri ge ghaghua vanighai a tamagu, ‘Ighau tau ghilalaa tua na taugu a Rachel te vahura ara rua na dalena rana mane. ");
INSERT INTO nlg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ma sakai tadira te tona me mua pulohi mai tua. U mua nia ghanaghana ruarua, sogea e ghala rosirosia tua siki maumanu asi, mu mua righi matana tua. ");
INSERT INTO nlg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ma ge kau ghoi lavikehaa itagua a hoghona me ke va kalea siki sosodo ke, inau ku nia mate vamua na dikalio na pukuna tu tonikama tua/inau na manerau mi gevaa na dikalio kau laviu vamua ku nia mate.’ ");
INSERT INTO nlg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Aghe nigua na maghutu, mu ku mua tangomana tua na pulohi ta tamagu, ge ke taho a hoghomami na sosokoi tamami. Agaia tua na volana tamagu na garimane eni. ");
INSERT INTO nlg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ge ke taho mua itamami a hoghomami na garimane ke, ma gaia ke mate tua, mi ghai kai nia kaukauli na mateana nia na dikalio. ");
INSERT INTO nlg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Aghe nigua na maghutu, inau tu gonia na baubahu vania tamagu, ge inau ku righitaonia na garimane. Mu bosaa vania te vaghaa eni, ge ku mua lavi pulohia vanigho mai na garimane ke, mi nau tua ku nia kaukauli na huhuru taolia na hava ke kalea ke vaa me vaa. ");
INSERT INTO nlg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Aghe nigua na maghutu, inau tu nongi kurutigho, lubatiu inau ge ku kabu pulohi iani ke vaghau na seka mo ko lubatia na garimane me ke pulohi kolura na lei hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","?Ivei kea ge ku pulohi ta tamagu ge ke taho itagua na garimane? Ku mua tangomana tua ge ku pabea na righiana na hava ke kalea a tamagu.” ");
INSERT INTO nlg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ma Joseph te mua tangomana vania tua ge ke poloa vanira tana lei hoghona nina na kanora,/te haga tangi hauva me mua liona ge ke tangi inaghodira/tana matadira nina lei ghairau, keri ge bosa vanira nina na lei ghairau udolu ge kara rughuhoru sania na voki. Agaia te liona ge ke kabu kolura heghena tua na lei hoghona, vaho ge bosatatea heghena vanira ahei agaia. ");
INSERT INTO nlg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma gaia Joseph te tangi ngangaraha, mana lei vure ni Egypt tana vale sulena tara rongovia, mana viti vamua me nia sara itadira na lei vure tana vale sulena Pharaoh na rongorongo eni. ");
INSERT INTO nlg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ge ghaghua vanira na lei hoghona, “Inau ke a Joseph vamua! ?Ivei te ghaghua, e vola utuni sughua a tamada?” Mana lei hoghona tara mua kokoea siki totobo na pukuna agaira tara nia kanoragha tara ghilalaa agaia tua Joseph te tughuru mai inaghodira. ");
INSERT INTO nlg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ma gaia Joseph te ghaghua vanira sono, “Kau mai liliagu.” Tana bona tara mai so, gaia te bosa, “Inau utuni tua na hoghomiu a Joseph tau nia hunulu mai iani Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Hauvaa ma kau bei rutu mau sopa hughuhughu heghemiu gea na pukuna tau gonia vaniu na totobo eni, na pukuna God heghena tua te diki niu vetena mai iani ge ku vavolara na lei voladira rana vure tana ngengere. ");
INSERT INTO nlg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ara rua na niulu ni vitolo raeni ke, kara totolo ma kara riti tana vitu na niulu, ara lima na niulu mua iga. Ilokani ara lima na niulu raeni ke, ke taho igaa na subasuba mana ghegheli. ");
INSERT INTO nlg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","A God te diki niu vetena mai iani Egypt ge ku pabei na volamiu, ighau maira nimiu na lei sopa binaboli, ge kau vola ma kau sepalaghi ge kau vuha mai vaghaghau na kema sule. ");
INSERT INTO nlg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","A God tua te diki niu vetena mai iani, e mau ighau. Ma gaia God tua te neu ge u vuha mai nina tinoni ni huhuli a Pharaoh, mu vunaghi pungisia Egypt talighu. ");
INSERT INTO nlg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Kau minamina, ma kau pulohi ta tamagu ma kau bosa vania, ‘Aeni na hava te bosaa mai na dalemu a Joseph vanighai, “A God te neu ge u vunaghi pungisia Egypt. Mina mo ko mai kabu tua iani tagua. ");
INSERT INTO nlg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ighoe ko mai ghahagho tana bona tara holoa nia Goshen, ge ko kabu dutuviu kolura na lei dalemu mana lei kukuamu, maighi nimua na lei maumanu/volivoli soko kolui nighi nimua na lei lologho soko. ");
INSERT INTO nlg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Inau ku righitaonighau udolu i kakeri, ara lima mua na lei niulu ni ngengere tara mai inagho. E mua uto ighoe kolura nimua na binaboli ge kau nia kabu bona na vahaghitaili.’” ");
INSERT INTO nlg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma Joseph te ghaghua vanira, “Kau vaevaneu heghemiu mai, maia ghua ighoe ghe na tahigu a Benjamin, inau a Joseph loloto tua. ");
INSERT INTO nlg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kau bosaa vania a tamagu Jacob, tara nea iga na talumavaagu iani Egypt, mau bosaa vania nia ghua na lei totobo tau righighi. Ma kau mina ma kau lavia vaniu mai iani.” ");
INSERT INTO nlg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nia na togotogo, agaia Joseph te lighotia mai tana luhana na tahina Benjamin ge tangi, ma gaia Benjamin ghua te lighotia hoghona a Joseph ge tangi ghua. ");
INSERT INTO nlg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma gaia Joseph te sopa nonginongira me tangitangi savura rana lei hoghona udolu, ma gaira na lei hoghona tara vuivuni ni tutugu koukoluana. ");
INSERT INTO nlg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Me mua hau vasoo, me saravia a Pharaoh na rongorongodira rana lei hoghona Joseph tara mai i Egypt, ma Pharaoh kolura lei nina tinoni ni lutu tara nia togotogo tana bona tara rongovia te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ma Pharaoh te ghaghua vania Joseph, “Ko bosa vanira rana lei hoghomu ma kara ludangighi didira lei sopa donkey nighi na lei vuavua ni koni/vanga ma mina ma kara pulohi tana komudira i Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Keri ge kara lavia mai a tamamiu maia didira na lei sopa binaboli udolu, ma kara mai ghahara tua iani Egypt. Inau, a Pharaoh, ku lubatia vanighau tana puku ni bona te uto au vule ilokana Egypt talighu, ma kau ghanighi ghua na lei vanga uto tara ghahai ilokana na bona keri. ");
INSERT INTO nlg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mo ko bosa vanira na lei hoghomu ma kara lavi taitakiro tua iani ge kara ludangira mai rana taudira mana rana gari pile kolua tamamiu ghua. ");
INSERT INTO nlg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kau bei nighi ghaghua gea nimiu na lei lologho, na pukuna na bona te uto vulei na lei bona i Egypt talighu ke a nimiu.” ");
INSERT INTO nlg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Mana lei dalena Jacob tara goni taonighi na lei totobo Pharaoh te bosai vanira. A Joseph te hera na lei taitakiro taonia nina vevetena Pharaoh, me hera na vanga kara ghanighi tana halautu. ");
INSERT INTO nlg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Me sopa hera na tivi ni tughu, ma Benjamin na puku ni hoghona te hea ara lima na tivi vaolu i vahea tughu, maighi ara tolu hangalatu na rongo ni silver. ");
INSERT INTO nlg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma Joseph te nia vetena vania vaa a tamana ara hangavulu na lei donkey tara ludangi vonui i vuvungani nighi na lei totobo uto ni Egypt, maighi ghua ara hangavulu na lei donkey tara ludangi vonui i vuvungani nia na lei vuavua ni koni maighi ghua na lei vatavata ni vanga kehakeha soko ke ghanighi tana halautu bona ke tona mai Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ge vetena tonara na lei hoghona, mi tana bona na lei hoghona tara tughuru ni tona, agaia te ghoi kokoe vanira vaa sono me ghaghua, “Kau bei hughuhughu gea tana halautu!” ");
INSERT INTO nlg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ma gaira tara sania Egypt mana pulohi tana komudira tana butonikomu i Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Tana bona tara sara tana komudira, agaira tara ghaghua vania tamadira, “A Joseph ke, e vola sono, ma gaia tua te vunaghi pungisia na komu Egypt talighu!” Ma gaia Jacob te nia hoghohare na ghanaghana te rongovia na rongorongo, me mua taluutunia. ");
INSERT INTO nlg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mi tana bona tara rongorongoa vania nina na rongorongo a Joseph, maia te vaevanei na lei taitakiro ni vanga te nighi vetena vania mai a Joseph, na tarungana te ghoi rivurivu. ");
INSERT INTO nlg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma Jacob te ghaghua, “Ke tangomana ge ke utuni sughua, na dalegu a Joseph te vola sono! Inau ku tona mu ku righi matana inaghona ge ku mate!” ");
INSERT INTO nlg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ma Jacob te rughuhoru sania Canaan (me) ge ke tona vaa i Egypt kolui nina binaboli ma nina lei lologho udolu. Mi tana bona te sara i Beersheba, agaia te gonighi na lei sukaghi vania a nina God te tamana, Isaac. ");
INSERT INTO nlg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mi tana bongi hau, God te kokoe vania Jacob tana maturubole me ghaghua, “Jacob, Jacob!” Ma Jacob te bosatughu, “Inau sono aeni.” ");
INSERT INTO nlg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma God te bosaa, “Inau ke a God, a nina God a tamamu. Ko bei mataghu gea na sughi i Egypt. Inau ku righitaonigho mu ku nigho ge ko sepalaghi mo ko vahea puputu ni kema sule ngangata i kakeri Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Inau ku sughi kolugho i Egypt, mu ku ghoi laviolira mai sono iani Canaan na lei vaivarimu. Hauva ka, mi ghoe ke i Egypt tua ko mate, ma Joseph ke kabu ililighimu me ke righitaonigho tana bona ko mate.” ");
INSERT INTO nlg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ma Jacob te sania Beersheba, mana lei dalena na mane tara ludangighi na tamadira Jacob, rana lei taudira, kolura nia rana lei daledira pile ilokani na lei taitakiro te hera a Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ara lavighi ghua didira na lei maumanu vola udolu, maighi ghua didira na lei lologho udolu tara loghoi tana butonikomu Canaan. Jacob maira nina binaboli udolu tara sara haghe tana butonikomu i Egypt, ");
INSERT INTO nlg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","na lei dalena, na lei mane mana lei vaivine, mana lei kukuana, na lei mane mana lei vaivine udolu tua. ");
INSERT INTO nlg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A raini na lei ahadira na lei vure ni Israel, na lei vaivarina Jacob tara tona kolua i Egypt. Reuben a nina kamanagho a Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben te vahura a Hanoch, Pallu, Hezron, maia Carmi. ");
INSERT INTO nlg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon te vahura Jemuel, Jamin, Ohad, Jakin, Zohar maia Shaul. A tinana Shaul ke na vinekama ni Canaan. ");
INSERT INTO nlg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi te vahura Gershon, Kohath maia Merari. ");
INSERT INTO nlg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah te vahura Er, Onan, Shelah, Perez maia Zerah. Er maia Onan toro mate tua tana butonikomu i Canaan. Na lei dalena Perez ke, Hezron maia Hamul. ");
INSERT INTO nlg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar te vahura Tola, Puah, Jashub maia Shimron. ");
INSERT INTO nlg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun te vahura Sered, Eloni maia Jahleel. ");
INSERT INTO nlg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Gaira udolu raini na lei dalena mane mana kukuana Jacob tara sivuragha ta Leah i Paddan-aram, kolura nia a vaivinedira a Dinah. Agaira udolu na vaivarina ta Leah ke, ara tolu hangavulu tolu. ");
INSERT INTO nlg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad te vahura Zephon, Haggi, Shuni, Ezbon, Eri, Arodi maia Areli. ");
INSERT INTO nlg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher te vahura Imnah, Ishvah, Ishvi maia Beriah, ma vaivinedira Serah. Beriah te vahura Heber maia Malchiel. ");
INSERT INTO nlg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Agaira udolu ara hangavulu ono raini ke, na lei vaivarina Jacob tara sivuragha ta Zilpah, nina tinoni lutu a Leah, a tamana Laban te hea. ");
INSERT INTO nlg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rachel na tauna Jacob te vahura Joseph maia Benjamin. ");
INSERT INTO nlg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Rana dalena Joseph te vahura tana butonikomu Egypt ke, a Manasseh maia Ephraim. A tinadira ke, a Asenath na dalena na vaivine Potiphera, na mane sukaghi ni Heliopolis. ");
INSERT INTO nlg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin te vahura Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim maia Ard. ");
INSERT INTO nlg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Agaia udolu ara hangavulu vati raini ke, na lei vaivarina Jacob itatana na tauna a Rachel. ");
INSERT INTO nlg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan te vahua Hushim. ");
INSERT INTO nlg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali te vahura Jahzeel, Guni, Jezer maia Shillem. ");
INSERT INTO nlg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Agaira udolu ara vitu raini ke, na lei vaivarina Jacob itatana Bilhah, nina na tinoni ni lutu Rachel, a tamana Laban te hea. ");
INSERT INTO nlg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Keri ke, ma gaira udolu na lei puku ni vaivarina Jacob tara nia tona kolua i Egypt ke, agaira ara ono hangavulu ono (66). Ara mua idumi kolura nia na lei taudira tana lei dalena mane a Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ma Joseph te ghoi vahura ghua erua na dalena, te ghoi vahura sono i Egypt. Keri ke, agaira udolu nina binaboli Jacob tara ghahara i Egypt ke, vitu hangavulu. ");
INSERT INTO nlg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ma Jacob te diki nia vetena ghide a Judah ge ke va sodoa Joseph me ke pukulaghi utoa mai itatana ivei kara nea na tona ge kara va sara tana bubulo i Goshen. Mi tana bona agaira udolu tara sara i kakeri, ");
INSERT INTO nlg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","a Joseph te gonidilaa nina taitakiro me tona vaa tua i Goshen ge ke va sodoa tamana. Mi tana bona te sara mai Joseph, ma gaia te varava tua tana luana a tamana me tangi togotogo tana valana te daro ni bona. ");
INSERT INTO nlg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma Jacob te ghaghua vania Joseph, “Itaeni inau ku mate tana mabo, na pukuna tu vaevanegho nighi tua rana matagu heghegu to mua mate, mu ghilala to vola sono.” ");
INSERT INTO nlg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ma Joseph te ghaghua vanira na lei hoghona maira didira na lei sopa binaboli, “Inau ku pulohi mu ku va bosa vania a Pharaoh, ‘Rana hoghogu ma nina binaboli a tamagu, ge ra sania mai tua na butonikomu i Canaan ma kara mai ghaha koluu tua iani.’ ");
INSERT INTO nlg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mu ku bosaa vania ghua te vagha, ‘Rana lei vure raini tara righitaoni sheep maira tara kuikuti maumanu vola, mara nighi mai kolura rana sheep maia lei volivoli, maighi ghua didira na lei lologho udolu.’ ");
INSERT INTO nlg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Keri ke, mi tana bona ke hologhau a Pharaoh me ke huatighau nia na lei sopa lutumiu ke, ");
INSERT INTO nlg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ma kau bosaa vania te vaghaa eni, “Ighai ke, na vure tai righitaoni maumanu vola tua tana garimaneamami mai tua, vaghara na lei kukuamami/vaivarimami tana lei vavata.’ Keri ke, igevaa ke lubatighau ge kau ghahaghau tua tana bona iani Goshen, na pukuna rana righitaoni sheep ke, ara nira sika iani tana butonikomu i Egypt talighu.” ");
INSERT INTO nlg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ma Joseph te righimatana Pharaoh, me ghaghua vania, “A tamagu maira na lei hoghogu udolu iani tua. Tara sania mai tua Canaan. Ara nighi mai kolu tua didira na lei sheep mana lei volivoli, maighi didira na lei lologho udolu, ma gaira tara ghahara tua itaeni tana bona i Goshen. ");
INSERT INTO nlg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ma Joseph te lavia ara lima ma lei hoghona me va tatera vania Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh te huatira me ghaghua vanira, “?Na hava na lutumiu?” Ma gaira tara bosatughu vania, “Ighai ke na vure righitaoni sheep, vaghara na lei vaivarimami. ");
INSERT INTO nlg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ighai tai mai ge kai mai ghahaghai iani Egypt, na pukuna na ngengere te sule ngangata me taho tua siki buburu maumauri vanira nimami na lei maumanu vola i Canaan. Ighai tai nongia nimua na lulubati ge kai ghahaghai tana bubulo i Goshen.” ");
INSERT INTO nlg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma Pharaoh te ghaghua vania Joseph, “A nimua na binaboli tara mai kabu kolugho tua iani taeni, ");
INSERT INTO nlg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ighoe tua ko vilia ivei na bona vaghana te liona ge kara ghahara igaa. Hera na bona i Goshen ke, te uto vulei na lei bona soko iani Egypt. Ma ge siki sakai tadira ke loghoa na balu ghilala uto te keha ke, ko talura me ke righitaonighi vaniu ghua nigua na lei maumanu vola.” ");
INSERT INTO nlg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mi murina keri, a Joseph te ghoi lavia a tamana, a Jacob, me va tatea vania a Pharaoh. Ma Jacob te vautoa na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ma Pharaoh te huatia Jacob me ghaghua, “?Ara righia na niulumu tua itaeni ighoe?” ");
INSERT INTO nlg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma Jacob te bosatughu vania Pharaoh, me ghaghua, “Inau tu vola saravighi tua sakai hangalatu tolu hangavulu (130) na niulugu itaeni. Na lei niulu raeni tara vahola vaniu, hauva, mi nau tu mua haulaghi vaghara mua na subona itadira na lei vaivarigu tara padi tua.” ");
INSERT INTO nlg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma Jacob te ghoi vautoa sono a Pharaoh inaghona ge tona sania. ");
INSERT INTO nlg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ma Joseph te vilia na bona te uto vulei na lei bona soko i Egypt, na bubulo i Rameses, vanira tamana maira na lei hoghona ge kara ghaha igaa, taonia nina na vevetena a Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma Joseph te vetena ghadira vanga vaa tamana maira na lei hoghona kolura nina binabolidira tana bona i Goshen, tana kasekase/kaekage ke manadira rana lei daledira. ");
INSERT INTO nlg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mi tana lei bongi raini, na ngengere te sule ngangata tua, keri ke e taho na vanga, ma rana vure ni Egypt mi Canaan talighu, tara lugu ni vitoli. ");
INSERT INTO nlg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ma Joseph te vahikolui na lei rongo ilokani Egypt mi Canaan talighu tara nighi mai pelu koni/vanga, me va talugonighi tana vale ni (talugoni/righitaoni na lei totobo uto/nilau) ta Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mi tana bona na lei vure ni Egypt mi Canaan tara mua loghoa tua siki rongo, agaira tara mai sono ta Joseph mara tangitangi vania ge ke hera na vanga, mara ghaghua vania, “Ai mua loghoa tua siki rongo ighai, hauva, mo ko heghai ghamami vanga mai sono, e mua uto ge kai nia mate ni vitolo.” ");
INSERT INTO nlg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ma Joseph te bosatughu vanira, “Na pukuna tau soni sokoi tua nimiu na lei rongo ke, kau heu mai nimiu na lei maumanu vola, mi nau ku hea ghamiu na vanga ke vaghaa na tughu veioli.” ");
INSERT INTO nlg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ma gaira tara vahea Joseph didira na lei maumanu vola na vatei tutughu ni vanga. Me mua daro ni bona mua ka, mana lei maumanu vola tara vaghai na lei horse, rana sheep, rana goat, rana buluka mana lei donkey ni Egypt talighu ka, te logho udolui tua a Pharaoh. Mara tangomana vamua na pelu vanga na niulu vaghana keri. ");
INSERT INTO nlg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mi tana niulu murina na niulu vaghana keri ke, gaira tara ghoi mai sono Joseph, mara bosa vania, “E taho tua so nimami na rongo ighai, ma nimami na lei maumanu vola to logho udolui tua. Ai mua loghoa tua siki totobo ke ghana pulohia itamami, na lei hulimami maighi nimami na lei bona/pari vamua. ");
INSERT INTO nlg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","?Eghua ge kai mai mate tana matamu? Ko pelua na volamami maighi na lei parimami, mi ghai kai nina na tinoni lutu a Pharaoh, ma gaia te loghoi nimiu na lei pari. Ko heghai mai vamua na vanga ge kai vola, ge ke bei ohua/aroha na lei pari. ");
INSERT INTO nlg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ma Joseph te pelu udolui tua na lei bona ilokana i Egypt talighu vania a Pharaoh. Eo, na lei vure ni Egypt udolu tara hunului vania Pharaoh didira na lei bona i subasuba na pukuna te sule na ngengere. Ma Pharaoh te loghoi didira na lei pari udolu. ");
INSERT INTO nlg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Keri ke, na lei vure udolu ni Egypt tara vuha nina tinoni ni lutu vania Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Didira na lei bona vamua na lei mane sukaghi ge mua pelui na pukuna a Pharaoh te hera ghadira na vanga tughu bongi/vula. Na pukuna keri, tara mua sabiri didira na lei bona. ");
INSERT INTO nlg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma Joseph te bosa vanira na lei vure, “Kau righia, inau tu pelughau tua, maighi nimiu na lei bona vania Pharaoh. Inau ku vaheghau na lei vuavua, ge kau subasubai lei nimiu na leghai. ");
INSERT INTO nlg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mi tana bona kau siosio ke, e limani (1/5) ta nimiu na lei siosio kau vahea Pharaoh. Kau lavighi ara vatini na lima (4/5) kara vanighau heghemiu, maia niulu ke mai nagho. Maia ghua na ghamiu vanga vanighau, ma nimiu na binaboli.” ");
INSERT INTO nlg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ma gaira tara ghaghua vania, “Ighoe to volaghai! Aghe vunaghi, ighai kai liona ge ko togotogo vanighai. Mi ghai kai na lei seka vania Pharaoh.” ");
INSERT INTO nlg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Keri ge Joseph te talua a sakai na vetena i lokana Egypt talighu, ge a Pharaoh ke loghoi mughua e limani na tunuva (1/5) tana lei subasuba soko tara subai. Na vetena eni te loghoa na maana itaeni. Rana lei mane sukaghi vamua ge kara taho tana hevei ni tunuva vaghana eni, na pukuna a Pharaoh te mua lavighi didira na lei bona. ");
INSERT INTO nlg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mana lei vure ni Israel tara ghahara tua tana bubulo i Goshen i lokana Egypt. Mete mua daro ni bona mua imurini na lei niulu raini, agaira tara vuivuni ni sepalaghi tua ikakeri, mana subodira te totolo minamina ngangata. ");
INSERT INTO nlg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ma Jacob te vola me kabu ara hangavulu vitu na niulu i Egypt, imurina te sara igaa. Keri ke, ma gaia te vola saravighi ara sakai hangalatu vati hangavulu vitu (147) na niuluna ge mate. ");
INSERT INTO nlg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mi tana bona te dutu na bona ni mateana, agaia te holoa mai tatana na dalena, a Joseph, me ghaghua vania, “Ge ko loghoa na liouto koukolu itagua ke, ko papari dato sule ngangata vaniu, ge ko talumavaa mo ko taonia nigua na ghanaghana eni, a nigua na nongi sosoko vaniamu. Ko bei tavughiu gea ilokana na butonikomu iani Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tana bona ku mate ke, ko lavi rughuhoruu sania na butonikomu iani Egypt, mo ko tavughiu ililighidira na lei vaivarigu.” Ma Joseph te baubahu ge ke nea te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma Jacob te kurutia sono me ghaghua, “Ko papari ge ko nea te vaghaa!” Ge a Joseph te papari/vahea a nina na baubahu. Ma Jacob te holoutoa God igaa tana vatei koli/malei ghime. ");
INSERT INTO nlg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mi ta sakai na dani te mua daro ni bona i murina vaso aeni, na rongorongo te saravia Joseph, te toro ngangataa tua na vahaghi a tamana, Jacob. Ma Joseph te lavira rana dalena, a Manasseh ma Ephraim, ge ara tona ni va kaoana Jacob. ");
INSERT INTO nlg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tana bona Jacob te rongovia a Joseph te sara tua tana valena, agaia te lavia a lagana ge sopou dato tana ghimena ge ke lavipangotia. ");
INSERT INTO nlg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma gaia Jacob te ghaghua vania Joseph, “A God puku ni maana te livu vaniu tana komu i Luz tana bona/butonikomu ni Canaan, me vautou, ");
INSERT INTO nlg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","me ghaghua vaniu, ‘Inau ku negho ge ko sepalaghi mo ko puputu na lei kema sule. Mu ku hegho na bona/butonikomu eni Canaan, ighoe maira na lei vaivarimu, me ke nimiu na lologho kasila.’ ");
INSERT INTO nlg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Itaeni inau tu lavira mu ku kutira rana dalemu mane raeni vaghara rana puku ni dalegu heghegu, rogaira a Ephraim maia a Manasseh, toro sivuragha tua iani tana butonikomu i Egypt inaghona ge u sara haghe mai inau. Rogaira koro lologho tughu itagua, koro vaghara ghua a Reuben ma Simeon. ");
INSERT INTO nlg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mana lei dalemu ko ghoi vahura i muridira raeni ke, kara dalemu hughemu tua. Na bona kara lologho tughu igaa ke, igevaa ilokana tua na bonadira a Ephraim ma Manasseh. ");
INSERT INTO nlg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mi tana bona tu pulohi mai maia na bubulo i Paddan-aram, a Rachel te mate tua tana butonikomu/bona i Canaan. Ighobuna sono a dida na tonatona tana bona ta dutuvia tua Ephrath, (tara holoa nia Bethlehem itaeni.) Mi nau tu tavughia tua ikakeri rana lilighi ni halautu te tona va i Ephrath nia na dikalio sule ngangata.” ");
INSERT INTO nlg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ma Jacob te righira vaa rana garimane, ge huatia Joseph, me ghaghua, “?Arahei rana dale raeni?” ");
INSERT INTO nlg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ma gaia Joseph te bosatughu vania, “Rogaira tua rana dalegu. A God te heu mai ge u vahura tua iani Egypt.” Ma Jacob te ghaghua vania, “Ko lavira mai iani lilighigu mi nau u vautora.” ");
INSERT INTO nlg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mi tana lei bongi raini, a Jacob te mua puku ni reirei uto, na pukuna te tonikama ngangata tua. Ma Joseph te lavi dutuvira vaa itatana rana garimane, ma Jacob te nonginongira me lighotira tana garimane nia na togotogo. ");
INSERT INTO nlg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ma Jacob te ghoi ghaghua vania Joseph, “U mua ghanaghana ge ku ghoi righi matamu, hauva ka, mi taeni a God te talagu ge u vaevanera ghua rana dalemu.” ");
INSERT INTO nlg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ma Joseph te lavikehara rana garimane tana tuturuna kukuadira Jacob, me tongaghi horu kikinima vania. ");
INSERT INTO nlg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ge talu kaekagera rana garimane inaghona a tamana, a Ephraim tana levu ni lima maulina ma Manasseh tana levu ni lima madolona. ");
INSERT INTO nlg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Hauva ka, ma Jacob te talu vavalatighi rana limana tana bona te horui vaa i vuvungadira ge ke vautora. Keri ke, mana lima madolona tana vuvunga ni uluna Ephraim, na garimane tumuri, mana lima maulina tana vuvunga ni uluna a Manasseh na garimane kamanagho. ");
INSERT INTO nlg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Keri ge gaia te vautoa Joseph me ghaghua, “Aghe God, ighoe na God a kukuagu Abraham, maia tamagu Isaac toro taonia, ighoe na God te righitaonia haia tana lei bongi i volagu udolu vaghaa nigua na mane vatogha sheep, ");
INSERT INTO nlg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ighoe na angel te pilupungisiu tana lei sosodo soko, inau tu nongigho ge ko vautora rana garimane raeni. Ko lubatira rana vure tara ghanaghanaolia mara talumavaa na ahagu maia rana ahadira kukuagu Abraham maia na tamagu Isaac na pukuna rana garimane raeni. Mo ko lubatira ge rogaira koro puputua na kema sule ngangata tana maramana.” ");
INSERT INTO nlg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ma Joseph te dika ngangata na liona tana bona te righia tamana Jacob te talua vaa na lima madolona i vuvungana na uluna Ephraim. Ge ghate kohaa na lima madolona tamana me talua vaa tana uluna Manasseh. ");
INSERT INTO nlg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Me bosa vania na tamagu, “Aghe tamagu, e taho, ke bei ghaghua gea iga na hava to nea. Agaia eni tana pala madolomu te na diki. Agaia to talua na lima madolomu tana uluna.” ");
INSERT INTO nlg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hauva, ma tamana te hove na taoniana, me ghaghua vania, “Kula dalegu, inau tu ghilalaa na hava tu gonia. A Manasseh ghua ke vaivari ni kema sule, hauva ka, mana hoghona na pile/tahina ke sule a vulea vaa, mana vaivarina kara subo.” ");
INSERT INTO nlg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ma Jacob te vautora rana garimane tana dani vaghana keri, nia na vauto te vaghaa eni, “Rana vure ni Israel kara nia na hoholo na ahamiu tana bona kara sopa vautora heghedira. Agaira kara bosa ma kara ghaghua, ‘Lubatia God ke negho ge kau sepalaghi vaghara Ephraim ma Manasseh.” Taonia na ghanaghana eni ke, a Jacob te talua a Ephraim inaghona Manasseh. ");
INSERT INTO nlg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Keri ge bosa Jacob me ghaghua vania Joseph, “Inau tu dutu ni mate tua, hauva, ma God ke kabu kolughau me ke ghoi lavi pulohighau vaa ghua i Canaan, na bonadira lei kukuamiu. ");
INSERT INTO nlg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Inau tu vahegho na tunuva tu mua hera tua na lei hoghomu, na pari uto i Shechem. Inau tu lavia itadira na lei kema ni Amor nia nigua na isi mana baghe mana kuali tana lagagu heghegu.” ");
INSERT INTO nlg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ge holokolura mai tatana rana lei dalena mane a Jacob, me ghaghua vanira, “Kau sopou/kaukabu talighutiu mi nau ke bosaa vanighau na hava ke kaleghau tana lei bongi ke mai inagho. ");
INSERT INTO nlg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ighau rana lei dalena Jacob, kau mai ma kau vaovarongo, Kau varongohia Israel a tamamiu. ");
INSERT INTO nlg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, ighoe a nigua na kamanagho, na dalegu na mane tana bona tu mane vaolu mua. Ighoe na vuivuni tana alaala-alaala ni vaughilalaa tutughuni tana talusule mana talumavaa. ");
INSERT INTO nlg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hauva ka, ighoe to vaghaa na tave sule, te taho siki sakai te manga pungisigho/pungisiana. keri ke, mi ghoe ko mua ghoi nagho tua itaeni, na pukuna to nia maturu kolu a sakai tadira rana lei taugu, mi ghoe to mua talumavau tana ghimegu heghegu. ");
INSERT INTO nlg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon maia Levi toro sakai na vatadira vamua. Toro rana mane ni kisumate mana hughuhughu nia nina isi. ");
INSERT INTO nlg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Inau tu mua koukolu ta didira na lei padalaghi polo/vangarughu, mi nau ku bei ghoi tona ta didira na lei savukolu, na pukuna rogaira toro labumatera na lei tinoni ta didira na ruturutu, moro labu rapora na lei buluka te vaghaa didira na gougonu. ");
INSERT INTO nlg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Na vavaranga ke mai vuvungani didira na lei ruturutu, na pukuna toro lioni laga vule. Na vavaranga ke mai vuvungani didira na lei ruturutu mana lioni laga, na pukuna na lei gehegehe dika. Keri ke, mi nau ku havukaghinira na lei vaivaridira ilokana nabutunikomu ni Israel talighu.” ");
INSERT INTO nlg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, rana lei hoghomu kara holoutogho ighoe. Ighoe ke laga vulera na lei ghamua na kana. Na lei kulamu na vure udolu kara tongaghi kikinima vanigho tana matamu. ");
INSERT INTO nlg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah ke, na bolo ghaghala tara holoa nia na lion te sule vaolu me mahebo, Te tagiha ghani sokoa vasoo ghana vanga/maumanughania me pulohi tana niku/baba. Vaghaa na lion e harahara/sighorotu me koikoli horu, e taho siki sakai te liopatu ge ke alihia. ");
INSERT INTO nlg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Na lei alaala-alaala ni vunaghi haba ni Israel kara rughuhoru mai haia tana kemana Judah. Maira ghua na lei vaivarina kara loghoa na maana pungisia talau, koekobe na maiana ahei te paepaleva igaa/loghoa utuni, agaia keri, na lei kema soko kara taonia. ");
INSERT INTO nlg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Agaia ke pitia na dalena nina na donkey tana ghai/alo tara holoa nia na grape, Eo, na dalena nina na donkey ke pitia tana puku ni otooto te uto ngangata. Agaia (te/kea) apoi lei nina tivi nia na kokolo ni grape/wine na pukuna tara too subo au vule na lei vavanga te (bilui/bihui). ");
INSERT INTO nlg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Rana matana tara too sisi-bili vulea na kokolo ni grape/wine, ma rana lei livona tara too purapura vulea na kokolo na susu ni buluka. ");
INSERT INTO nlg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun i kise ke ghahaa tana lilighi ni tahi tana parilonga, me ke vaghaa na hinaba te uto vanira na lei vaka. na riritina nina lologho ke gharasu me ke sara Sidon. ");
INSERT INTO nlg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“A Issachar ke, na maumanu laga ni kaukauli, te koli ni aheahe i ghobuni na lei hoholana. ");
INSERT INTO nlg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tana bona te vaevanea/righia te uto vania na bona te aheahe igaa, mi vei te vaghaa na utoutona na bona ke, agaia ke taluolia tana valana na lutu vahola, me ke talana oli heghena vania na lutu huhuru laga. ");
INSERT INTO nlg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan, i gevaa ke righitaonira/hulira nina vure ni kemana, vaghara rana balu kema ni Israel, sakai vamua nina kema te pile. ");
INSERT INTO nlg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Igevaa ke vagha na poli te ghaghalana lilighina na halautu, eo, te vagha na umata ni mala. Agaia te ghalatighi rana tuana na horse keri ge ke nia pirihoru na tinoni te sopou tana vuvungana.” ");
INSERT INTO nlg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ma Jacob te kokoeliulivuti, “Aghe Yahweh, inau tu pitua ge ko vavolau!” ");
INSERT INTO nlg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad ke, rana gito mana labupolo kara mai sura kolua gea hauva, ma gaia ke ghoi ririu pulohi me ke ghurukehara/ghurumatera. ");
INSERT INTO nlg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher ke lutui me ke sivuraghai na lei puku ni vanga kara uto lee, na lei vanga te manadira na lei vunaghi haba ge kara ghanighi. ");
INSERT INTO nlg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali ke tona taonia vamua na liona ke vaghaa na maumanu tara holoa nia na deer. Rana lei dalena kara mahebo, korukoru maia kara utoutora lee. ");
INSERT INTO nlg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph ke, na ghai te vavangagha me vunguvungua, eo, na ghai vuvungua i lilighina na beti vuravura, ma rana lei otootona tara daro padia na vokovoko. ");
INSERT INTO nlg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Rana lei ghana levunimate tara suravia nighi na lei kuali, ma gaira tara vanahia nia na rutu papara. ");
INSERT INTO nlg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Hauva ka, ma nina na baghe te ngasi sono, ma rana limana ke lagalagai sono nia nina maana a God puku ni maana, a nina God a Jacob, gaia te vaghaa na vatoghaa ni sheep, maia na vatu ngasi ge pilupungisia Israel. ");
INSERT INTO nlg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nigua a God ke hangagho. Lubatia God puku ni maana te vautogho nighi rana lei vauto ni kokou, maighi rana lei vauto ni maramana iani pari, maighi rana lei vauto ni sepalaghi na lei vaivarimu, maighi nimua na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nina lei vauto na tamamu te haba va didira na lei vauto na lei ghotu ni dania mai tua, ma kara vaa sodoi na lei totobo uto tana lei ghotu tara kabu kasila. Na lei vauto raini kara horu mai i vuvungana Joseph, ma gaia te vunaghi itadira rana lei hoghona. ");
INSERT INTO nlg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ke vaghaa na kau asi te vitolo. Agaia te ghanira tara kanahaghinia tana puipungi, me tuvalia/vilivokaa na hava te sagua tana nulavi.” ");
INSERT INTO nlg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Agaira raini udolu ara hangavulu rua na lei kema ni Israel, maighi na lei vauto te sopa vautora nia ara hangavulu rua na lei dalena a Jacob. Sopasopa gaira tara lavia na vata ni vauto vaghana te taonia na sopa voladira. ");
INSERT INTO nlg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ma Jacob te bosa vanira na lei dalena, me ghaghua, “Inau tu dutu ni mate tua. Mi tana bona ke mate ke, ma kau vaa tavughiu i lilighidira a tamagu ma kukuagu, ilokana na vatuluma ta nina leghai a Ephron tana kemana Het. ");
INSERT INTO nlg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Agaia eni na vatuluma ilokana na leghai ni Machpelah, i lilighina Mamre tana bona/butonikomu i Canaan, te pelu sokoa tua a Abraham itatana Ephron ni tinoni ni kemana Het, ge ke bona ni vatei beku/tana tavughi tinoni mate tua. ");
INSERT INTO nlg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","I lokana tua na vatuluma kiri tara tavughira a Abraham maia na tauna, a Sarah, maia ghua a Isaac mana tauna, a Rebekah tara tavughira igaa. Mi lokana ghua tu tavughia a Leah inau. ");
INSERT INTO nlg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Gaia na vatuluma te pelu sokoa tua a kukuagu Abraham itadira rana lei vure ni kemana Het.” ");
INSERT INTO nlg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mi tana bona te kokoe sokoi vasoo a Jacob na lei ghanaghana ni talugoni raini vanira rana lei dalena, agaia te koli pulohi tana ghimena, me aheahe horua na ghuri sosoko, ge mate. ");
INSERT INTO nlg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Mi tana bona te mate a Jacob, a Joseph te taoraghi me tangitangi savua a tamana, mu nonginongia. ");
INSERT INTO nlg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Keri ge bosa vanira na lei vure gonigoni tinoni vahaghi ge kara gonigonia vania na hulina tamana. Mara gonidilaa na hulina vania na tavughiana. ");
INSERT INTO nlg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I lokani ara vati hangavulu na bongi tara gonigonia na hulina Jacob. Mi lokani ara vitu hangavulu na bongi tara nia dai na hulina Jacob i Egypt nia na dikalio. ");
INSERT INTO nlg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mi murini ara vitu hangavulu na lei bongi ni dikalio, a Joseph te tona me va kokoe vanira lei nina vure huhuli a Pharaoh, me nongira ge kara vaa kokoe tughuna agaia vania Pharaoh na vunaghi haba ta nina levu nia na mateana tamana. ");
INSERT INTO nlg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Me ghaghua vanira, “Kau bosaa vania Pharaoh te vaghaa eni, ‘A tamagu te nongiu ge u baubahu nia na papari vania, me ghaghua, “Inau tu dutu ni mate tua, mo ko lavi pulohia vaa na huligu tana butonikomu i Canaan, mo ko tavughia na huligu ilokana na vatuluma ni tavughiadira nigua na binaboli.” Me manana ngangata tua ge ku tona mu ku vaa tavughia a tamagu. Ku tavughi sokoa mua tamagu ke, mu ku oli mai tua.’” ");
INSERT INTO nlg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ma Pharaoh te lavi pangotia nina nongi a Joseph, me ghaghua vania, “Ko tona mo ko va tavughia tamamu, te vaghaa to nia baubahu tua.” ");
INSERT INTO nlg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ma Joseph te tona kolura rana lei vure huhuli ni Egypt maira rana lei vure manaha, ma gaira udolu rana lei mane nagho tana gavumane ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ma Joseph te lavira ghua rana lei hoghona udolu, maira agaira udolu tara halakulana Jacob. Hauva ka, mara sani olira rana lei daledira tara pile, maighi didira na lei sheep mana buluka, maira didira na lei maumanu vola udolu tana bubulo i Goshen. ");
INSERT INTO nlg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mara subo ngangata na lei vure tara sari taonia Joseph tana bona vaghana tara vaa tavughia Jacob. Na balu tara haehaghe tana lei taitakiro, balu tana vuvungani na lei horse, mana balu tara sakusaku tua. ");
INSERT INTO nlg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tana bona tara sara tana bona ni vatei viovio koni i Atad, lilighina na beti tina Jordan, agaira tara gonighi igaa na lei gehegehe sule ngangata ni tautavughi, tara tangihia iga Jacob nia tara dikalio. na kabu ni dikalio vaghana eni te lavira ara vitu na bongi na niana dikalio a tamana Joseph. ");
INSERT INTO nlg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ma rana lei vure ni Canaan tana komu kiri tara tughua na ahana na bona keri mara ghoi holoa nia Abel-Mizraim, na pukuna tara bosaa, “Aeni na bona ni dikalio sule vanira rana lei vure ni Egypt raini.” ");
INSERT INTO nlg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ma rana lei dalena Jacob tara ghoi goni taonia sono na hava te vaghaa Jacob te bosaa vanira. ");
INSERT INTO nlg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Agaira tara ghoi lavia na hulina Jacob mara nia tona vaa tana butonikomu i Canaan, mara tavughia na hulina i kakeri i lokana na vatuluma i Machpelah. Aeni na vatuluma te pelua tua Abraham, na vatei tavughiadira na lei vure ta nina na binaboli lokana nina leghai Ephron na tinoni ni kemana Het i lilighina Mamre. ");
INSERT INTO nlg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mi murina tara tautavughi soko tua, a Joseph kolura rana lei hoghona maira gaira udolu tara nia udukolu tona tana tavughiana tamana, a Jacob ke, tara ghoi pulohi i Egypt. ");
INSERT INTO nlg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mi murina te mate tua a tamadira, agaira rana lei hoghona Joseph tara mataghu. Mara ghaghua heghedira, “Itaeni tana lei bongi raeni, igevaa Joseph ke lavitughughita a nighi na lei totobo dika ta nei vania i dania tana lei niulu tara padi tua.” ");
INSERT INTO nlg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ma gaira tara nia vetena vania vaa na rongorongo a Joseph, mara ghaghua, “Inaghona ge mate a tamamu a Jacob ke, agaia te kokoea vanighai, ");
INSERT INTO nlg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ge kai bosaa vanigho te vaghaa eni, ‘Ko talukehai vanira rana lei hoghomu na lei totobo dika ngangata tara gonighi vanigho.’ Keri ke, mi ghai rana nina lei ghairau a nina God a tamamu Jacob, tai nongi kurutigho ge ko talukehai vanighai nimami na lei hahi i vuvungamu.” Mi tana bona Joseph te rongovia na rongorongo eni, agaia te ia dikalio ngangata me tangi. ");
INSERT INTO nlg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Keri ge ara mai tatana rana lei hoghona mara mai tongaghi horu kikinima vania i naghona, mara ghaghua vania, “Itaeni ke, ighai kai ghoi nimua na lei seka.” ");
INSERT INTO nlg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Hauva ka, ma Joseph te bosa vanira, me ghaghua, “Kau be mataghuniu gea. ?Ivei te ghaghua, A God inau ge ku heghau na totoro? ");
INSERT INTO nlg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ighau tau gonia na dika vaniu, hauva God te ririu/tughua tana na totobo te uto vamua. Agaia God te laviu mai tana malei haba eni tana lei bongi raini ge ku volara rana lei tinoni togha tana lei niulu ni ngengere tara haghevighi tua. ");
INSERT INTO nlg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kau bei ghoi mataghu gea, ke mua ghaghua igaa na hava tau ghanaghanaa. Inau heghegu tua ku righitaonighau maira ghua nimiu na lei binaboli.” Ma gaia Joseph te kokoe togholuvura rana lei hoghona nighi na lei kokoe mabe mana lavipangoti te nighi vanira. ");
INSERT INTO nlg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ma Joseph maira rana lei hoghona kolura didira na lei sopa binaboli tara ghahara i Egypt. Ma Joseph te vola saravia sakai na hangalatu paregho/me sara e salaghe (110) na niulu, ge mate. ");
INSERT INTO nlg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Agaia te vola sodo/saravighi me righira sono ara toluni na vavata ni kulagha tara sivuragha tana dalena a Ephraim. Ma gaia te vola me lavira rana dalena Machir, na dalena Manasseh, ilokana nina binaboli. A Joseph te lavipangotira me pabera rana lei vavata ni kulagha raini vaghara rana lei dalena heghena. ");
INSERT INTO nlg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ma Joseph te ghaghua vanira rana lei hoghona, “Inau tu dutu mate, hauva ka, ma God ke mai utuni vanighau i kise, ge ke lavi rughuhorughau iani Egypt. Agaia ke lavi olighau vaa tana butonikomu te nia baubahu tua ge ke hera rana lei vaivaridira Abraham, Isaac, maia Jacob.” ");
INSERT INTO nlg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ma Joseph te nira rana lei hoghona, rana lei vaivarina Jacob tana lei bongi rakiri ge ara gonia na papari ni baubahu sule ngangata, ge ghaghua vanira gaia, “Tana bona ke mai God ge ke huiolighita vaa i Canaan na butonikomu ni baubahu ke, kau laviolia ghua na huligu tana bona kau pulohi.” ");
INSERT INTO nlg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ma Joseph te vola me saravighi sakai na hangalatu paregho/me sara e salaghe (110) na niuluna ge mate. Mara gonigonia na hulina, mana hulina tara taluhaghea tua ilokana na kovini tana butonikomu i Egypt mua. ");
INSERT INTO nlg_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Raini gaira na lei dalena Jacob tara tona kolua tamadira i Egypt, sopa sakai tadira kolura didira na binaboli: ");
INSERT INTO nlg_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah, ");
INSERT INTO nlg_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, Benjamin, ");
INSERT INTO nlg_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, God ma Asher. ");
INSERT INTO nlg_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Joseph te diki ghana mai tua i Egypt. Ma gaira udolu na binaboli ta Jacob ke, te kaekage e vitu hangavulu. ");
INSERT INTO nlg_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sopa bongi, Joseph kolura hoghona tara mate, tara sokolaghinia na vinavahuhu. ");
INSERT INTO nlg_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ma didira na binaboli tara sopa loghoi te subo na gari mana kukuagha. Ko righia, gaira tara sepalaghi minamina, ma gaira tara vonughia na komu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mana vunaghi haba vaolu te dato mai tana malei kabuna i Egypt, te mua ghilala pilena tua a Joseph, pana hava te gonia. ");
INSERT INTO nlg_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Gaia te bosa vanira nina vure, “Na vure ni Israel/Jew raini ke, geva kara dikalaghita, na pukuna tara subo vaho tua. ");
INSERT INTO nlg_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mai ghita ma ka kenea na halautu ke nera ge kara kubolu horu. Ma ka mua nea te vagha keri, geva na veitotoghoni ke puputu dato mai, ma gaira igeva kara hangara na ghada na levunimate, ge kara veitotoghoni kolughita. Vaho, ge kara sogha sania na kema.” ");
INSERT INTO nlg_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kakeri vaho, gaira na vure ni Egypt tara nera na vure ni Israel/Jew geke didira na tinoni ni lutu. Ma gaira tara talui na lei vahaghitaili i vuvungadira, tara ghanaghana ke, ma gaighi na lei lutu mava raini ke nera ge kara kubolu horu. Gaira tara hughutira ge kara gonighi na komu i Pithom mi Rameses te vagha i ghobu, na nina vatei hevei horu na vunaghi haba, tara holoa nia Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ma gaira na vure ni Egypt tara vahaghitaili ngangatara rana Israel/Jew. Hauva, gaira na Israel/Jew tara mina ngangata na sepalaghi. Keri ke, na vure ni Egypt tara mataghu, ");
INSERT INTO nlg_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","mara ghanaghana ge kara nea na tinoni ni lutu ge ke vahaghi taili vaa ghua. ");
INSERT INTO nlg_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Gaira tara mua arovira na Israel/Jew, ra hughutira ge kara goni biriki mana mota, mara nera ge kara lutu daroni bona tana leghai. ");
INSERT INTO nlg_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ma gaia na vunaghi haba ni Egypt te nia hevei na vetena eni vanira na vaivine ni lutu ni Israel, Shiphrah ma Puah, ");
INSERT INTO nlg_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Tana bona koro hangara na lei vaivine ni Israel/Jew tana vahuhu ke, koro matera na lei meomeo mane kara vahu horura mai. Lubatira na lei meomeo vaivine ge kara vola.” ");
INSERT INTO nlg_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Na pukuna rogaira na vaivine ni lutu toro nia kikinima God ke, rogaira toro hove na taoniana na vunaghi haba, moro lubatira na lei mane ge kara vola ghua. ");
INSERT INTO nlg_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ma gaia na vunaghi haba te holora na vaivine ni lutu, me bosa vanira, “E ghua geo nea te vagha eni? E ghua ge ro lubatira na mane ge kara vola?” ");
INSERT INTO nlg_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Toro tughubosa vania, “Aghe na vunaghi haba, na lei vaivine ni Israel/Jew tara laga ngangata. Ra mina ngangata na vahuadira na daledira keri ge oro mu sara topora. Ra mua kiki tana vahuhu, vaghara na lei vaivine ni Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Keri ke, God te vautora na vaivine ni lutu, mana rana Israel/Jew tara tona haliu na sepalaghi, totolo dato me laga ngangata. ");
INSERT INTO nlg_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Mana pukuna rogaira na vaivine ni lutu toro nia kikinima God, gaia te sopa vahera rodidira sopa binaboli. ");
INSERT INTO nlg_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ma na vunaghi haba ni Egypt te nia hevei na vetena eni vanira nina vure, “Sonira na lei meomeo mane tana beti tina Nile. Ma kau volara vasoo na meomeo vaivine.” ");
INSERT INTO nlg_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tana bona vaghana eni, sakai na mane ma sakai na vaivine tana kemana Levi, toro taulaghi. ");
INSERT INTO nlg_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na vaivine te bohe me vahua na meomeo mane. Ma gaia te righia te matakage na meomeo me poloa e tolu na vula. ");
INSERT INTO nlg_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mi tana bona te mua tangomana ge ke poloa na meomeo, gaia te lavia na kei tara gonia tana ade, mara tita pungisia nia na tar kolua nia na vovongo. Gaia te lavia na meomeo me talua ilokana na kei, me va talua ighobuni na ghaghau tana kabara ni beti tina Nile. ");
INSERT INTO nlg_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mana vaivinena na meomeo te tughuru sagauvia, ge ke vatogha na hava ke kalea. ");
INSERT INTO nlg_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mua hau vaso imurina eni, sakai tadira dalena na vunaghi haba na vaivine te horu ni siu tana beti, ma nina lei tahula ni lutu tara sakusakutua tana lilighi ni beti tina. Mi tana bona na vinahogho te righia na kei pile kikia ighobuni na ghaghau, gaia te bosa vania sakai nina tahula ni lutu, ge ke lavia mai tatana. ");
INSERT INTO nlg_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tana bona na vinahogho te hangavia, gaia te righia na meomeo mane. Nina tangi ngangaraha te taho ke hanga, te tabea nia na tobana. Gaia te ghaghua, Sogea agaia eni, na dalena siki vaivine ni Israel/Jew.” ");
INSERT INTO nlg_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kakeri, na vaivinena na meomeo te mai dutuvia na vinahogho, me nongia, Ivei tea, ku tona mu ku kenea sakai na vaivine ni Israel/Jew ke righitaonia na meomeo vanigho?” ");
INSERT INTO nlg_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Na vinahogho te bosa tughu, “Eo, ko nea!” Keri ge na tahula te tona tana komuna, me holoa na tinana na meomeo. ");
INSERT INTO nlg_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Na dalena vaivine na vunaghi haba te bosa vania, “Ko lavia na meomeo eni, mo ko righitaonia vaniu, mi nau ku pelugho ta nimua na hahanga.” Mana tinana na meomeo te lavia vaa tana komu, me righitaonia. ");
INSERT INTO nlg_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Murina eni, tana bona te sule ghalagha, tinana te laviolia vania na vinahogho te kutia vagha na dalena. Mana vinahogho te vatua nia Moses, na pukuna te ghaghua, “Inau tu lavi horua mai tana beti.” ");
INSERT INTO nlg_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Subo na niulu te padi, Moses te sule ghalagha, gaia te rughuhoru ni kaoadira kulana na vure, na Israel/Jew. Mete vagha te righia ivei te vagha na vaholana na lutu tara hera. Ta nina na kao, gaia te righia na mane ni Egypt te labua sakai na mane ni lutu na Israel/Jew. ");
INSERT INTO nlg_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I murina te reirei kolili, geke bei righia gea siki sakai ke bungutia, Moses te labumatea na mane nina Egypt, me pari kuvia tana saghalea. ");
INSERT INTO nlg_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mi tana dani vaolu, te vagha a Moses te ghoi va kaora so kulana na vure, me righi topora erua na mane ni Israel/Jew toro vese. Moses te bosa vania gaia te hahi, “Na hava na totobo ia toro gonia, ge oro labughau heghemiu so te vagha keri?” ");
INSERT INTO nlg_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Na mane te bosa tughu, “Ahei to ghanaghana ahei ghoe? Ahei te viligho, ge ko vunaghimami mo ko nimami na mane ni dete? O ghanaghana ge ko mateu vagha to nea iga na mane ni Egypt i bongi?” Moses te mataghu ngangata na pukuna gaia te ghilala na lei tinoni soko, tara ghilala na hava te gonia. ");
INSERT INTO nlg_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Me manahana uto, tana bona na vunaghi haba (Pharaoh) ke rongovia eni ke, gaia ke nia hevei na bosa vanira ge kara lavia Moses ma kara labumatea. Keri ga sogha Moses tana na vunaghi haba (ta Pharaoh) me va polo i Midian. Mi tana bona Moses te sara i Midian, gaia te sopou i lilighina na teke. ");
INSERT INTO nlg_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Itaeni te kale, na mane gehegehe ni Midian te loghora ra vitu na dalena na vaivine, tara mai talau tana teke eni na holaa beti, maia na heo ghadira na beti na lei bolo nina tamadira. ");
INSERT INTO nlg_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mana balu righitaoni sheep ghua tara mai haia ghua iga, mara ghurukehara haia na lei tahula, kolura didira na lei sheep. Hauva Moses te tapatughuru me hangara na lei tahula tana ghobudira na lei mane righitaoni sheep. Keri ge gaia te hangara na heo beti ghadira na lei sheep. ");
INSERT INTO nlg_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mi tana bona na lei tahula tara pulohi vaa ta tamadira Reuel, gaia te huatira, “Ivei tea, ge au minamina na heo ghadira beti na sheep itaeni?” ");
INSERT INTO nlg_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Gaira tara bosa tughu, “Na mane ni Egypt te hangaghai tadira na lei mane righitaoni sheep. Gaia te heo beti vanighai, me heo ghadira beti ghua na sheep.” ");
INSERT INTO nlg_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reuel te huatira, “Mete vagha keri ke, mi vei gaia itaeni? Ivei tea, au sani lea vamua ikakeri? Tona ma kau bosa vania me ke mai tana komu, ge kau kutia.” ");
INSERT INTO nlg_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses te nia togotogo na hoholo, me kabu kolura, me ghaha kolura tua, Mi tana kabu koluadira, Reuel te vahea Moses na dalena vaivine, Zipporah, geke tauna. ");
INSERT INTO nlg_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Murina eni rogaira toro loghoa na meomeo mane, ma Moses te vatua ni Gershom na pukuna gaia te bosa, “Inau tu sinogho haghe mai tana kema vaolu.” ");
INSERT INTO nlg_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Subo na niulu te padi, mana vunaghi haba ni Egypt te mate. Mana vure ni Israel tara vahaghitaili so isarana didira na hohola ni tinoni ni lutu. Gaira tara tangi horu nia na hahanga, ma didira na ghanaghana ni lavikehaadira te dato vania a God. ");
INSERT INTO nlg_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ma God te rongovia didira na tangi me ghanaghanaolia nina na baubahu te bahua nia Abraham, Isaac ma Jacob. ");
INSERT INTO nlg_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Gaia te rei horu ivuvungadira na Israel/Jew, me righiadidira na ghanaghana te lalo me mavatira. ");
INSERT INTO nlg_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Sakai na bongi, Moses te lavira nina sheep vungona Jethro, na mane sukaghi ni Midian, me va tona haghe ilokana na tautalu asi/tana bona mamaha lilighina Sinai, na nina ghotu a God. ");
INSERT INTO nlg_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mua hau vaso, nina angel Yahweh/Lord God te tate vania tana ghai reserese te vavu. Moses te hare na pukuna na ghai reserese te vavu, hauva me mua durake. ");
INSERT INTO nlg_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses te bosa/ghanaghana heghena, “Vatei haeharegha sughua! Ivei tea, ge mua durakea na ghai reserese? Inau ku tona mu ku righia vaa eni.” ");
INSERT INTO nlg_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mi tana bona a Yahweh te righia Moses te mai lilighina na ghai reserese, gaia te holoa tana lokana na ghai, “Moses! Moses!” Ma Moses te bosa tughu, “Iani inau”. ");
INSERT INTO nlg_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","God te bosa vania, “Ko bei mai dutu. Ko hola keha na hahara ni tuamu na pukuna na bona tabu to tughuru iga.” ");
INSERT INTO nlg_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Keri ge bosa vania, “Inau God didira na kukuamu - na God nina Abraham, na God nina Isaac ma God nina Jacob.” Mi tana bona Moses te rongovia eni, gaia te poloa na matana nia na limana, na pukuna gaia te mataghu ge ke righia God. ");
INSERT INTO nlg_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ma Yahweh te bosa vania, “Itaeni vaho ge ko pukua. Inau tu righia na dika itadira nigua na vure i Egypt. Inau tu rongovia didira na tangi ni hangadira ta didira na vahola tana tinoni ni lutu. Eo, inau tu ghilala didira na vahaghitaili. ");
INSERT INTO nlg_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Keri ge u mai mu ku lavi kehara itadira na vure ni Egypt, vaa tana puku ni komudira te uto, mete subo iga na bona tana pari. Gaia na pari te tave iga na susu ni buluka mana kokolo ni midua - na pari tara ghahara iga rana vure ni Canaan, rana vure ni Hit, rana vure ni Amor, rana vure ni Periz, rana vure ni Hivi, ma rana vure ni Jebus. ");
INSERT INTO nlg_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Didira na tangi na vure ni Israel te saraviu, mi nau tu righia ivei te vagha na vure ni Egypt tara nea na vahaghitailiadira nia na lei totobo vahola. ");
INSERT INTO nlg_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mi taeni ko tona, inau tu vetenagho ge ko tona tana vunaghi haba (Pharaoh). Mi ghoe ko hulira nigua na vure rana Israel/Jew rughuhoru tana komu i Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ma Moses te bosa vania God, “Ma hei inau, ge ku va tate i naghona Pharaoh mu ku hulira rana Israel/Jew rughuhoru tana komu i Egypt?” ");
INSERT INTO nlg_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ma God te bosa vania, “Inau ku kabu kolugho. Aeni ke tatea te utuni, inau tu nigho vetena, tana bona ko lavi horura rana Israel/Jew tana komu ni Egypt ke, ko ghoi oli mai so iani ighau udolu kara holohabaa God tana ghotu eni.” ");
INSERT INTO nlg_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ma Moses te huatia me ghaghua, “Ge tuku tona itadira na vure ni Israel/Jew, mu ku bosa vanira, ‘Na God didira rana kukuamiu te niu vetena vanighau mai,’ gaira kara ghoi huatiu, ‘Ma hei na ahana na god eni to nia kokokoe?’ Keri ke, mana hava ku bosa vanira?” ");
INSERT INTO nlg_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ma God te bosa tughu vania, “Inau gaia sakai vamua te kabu talau ke va me va. Aeni na hava ko bosa vanira rana Israel/Jew, ‘Inau gaia keri te niu vetena vanighau mai.’” ");
INSERT INTO nlg_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ma God te ghoi bosa vania so, “Ko bosa vanira, ‘A Yahweh, na God didira na kukuamiu - a God nina Abraham, ma God nina Isaac ma God nina Jacob te niu vetena vanighau mai.’ Aeni gaia na ahagu ke ghahaa talaua, ma kara nia kokoe talau na lei vavata. ");
INSERT INTO nlg_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Ko tona mo ko holo kolura na lei mane huhuli ni Israel/Jew, mo ko bosa vanira, ‘A Yahweh, na God didira na kukuamiu - a God nina Abraham, ma God nina Isaac, ma God nina Jacob - te tate vaniu me ghaghua, “Inau tu vatoghaghau mu righia na hava te kaleghau i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mi nau tu baubahu ge ku vavolaghau tana lei vahola itadira na Egypt. Inau ku hulighau va tana pari tara ghahara iga rana vure ni Canaan, rana vure ni Hit, rana vure ni Amor, rana vure ni Periz, rana vure ni Hivi, ma rana vure ni Jebus, na pari te tave iga na kokolo ni susu mana midua.” ’ ");
INSERT INTO nlg_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Agaira na huhuli tana vure ni Israel/Jew kara tangomana na holopangotiana a nimua na rongorongo. Keri ge ighau udolu kau tona haliu va tana vunaghi haba ni Egypt, ma kau bosa vania, ‘A Yahweh na God didira rana Israel/Jew te kabukolughai. Lubatighai ge kai tona e tolu na bongi na vinano ilokana na bona mamaha, ge kai va taludatoa na sukaghi vania a Yahweh nimami na God.’ ");
INSERT INTO nlg_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Hauva mi nau tu ghilala na vunaghi haba ni Egypt ke mua lubatighau na tona sakai vamua gaia te ghilala utoa inau tu laga vulea itatana gaia. ");
INSERT INTO nlg_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mana pukuna keri, inau ku haua na limagu, ge ku vahaghitailira rana vure ni Egypt nia na lei vata ni butuli vaughilala. Mi tana sosoko, gaia ke lubatighau. ");
INSERT INTO nlg_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mi nau ku nera so, ke vagha ke goni utoghau na vure ni Egypt. Gaira kara va heghau na lei dolo ge kau mua rughuhoru kokoba. ");
INSERT INTO nlg_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Sopa na lei vaivine ni Israel/Jew kara nongighi na lei totobo ni silver/silver mana golu mana lei tivi utoutoa itadira na lei komukoludira na Egypt, maia ghua na lei hoghodira tara nongi haghe mai. Na lei tivi raini kau pupulura nia so na lei dalemiu na mane mana vaivine. Tana halautu vaghana vaho eni, ge kau righia te vagha kau sagura rana vure ni Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ma Moses te ghoi bosa tughu ghua, “Na hava te kale, ke vagha kara mua ghoi taluutuniu tua? Ma kara mua ghoi gonia na hava ku bosa vanira, ma kara ghaghua vamua, ‘A Yahweh te mua ghoi tangomana na tate vanigho.’” ");
INSERT INTO nlg_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ma gaia Yahweh te huatia, “Na hava keri tana limamu?” Moses te bosa tughu, “Na totoghonadira na vatogha sheep.” ");
INSERT INTO nlg_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","A Yahweh te bosa vania, “Soni horua tana pari.” Ma Moses te soni horua, me liliu ni poli! Ma Moses te mataghu, me sama keha. ");
INSERT INTO nlg_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ma gaia Yahweh te bosa vania, “Ko tabea vaa na ighuna.” Ma Moses te haua va na limana, me tabea na ighuna, me ghoi liliu ni totoghonadira na vatogha sheep. ");
INSERT INTO nlg_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yahweh te bosa vania, “Ko tatea na vaughilala eni, ge kara taluutunigho. Kakeri ge kara ghilala a Yahweh, na God didira na kukuadira - na God nina Abraham, ma God nina Isaac, ma God nina Jacob - utuni sughua te tate vanigho.” ");
INSERT INTO nlg_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Vaho ge a Yahweh te bosa vania Moses, “Ko talua na limamu ilokana na ghamua na kabe.” Moses te nea te vagha, mi tana bona te lavikeha, na limana te pura vagha na selo kolua nia na kuhu. ");
INSERT INTO nlg_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yahweh te bosa vania, “Ko talua olia na limamu ta ghamua na kabe.” Ma Moses te nea te vagha, mi tana bona te lavi keha, e marabu vagha na lei baebase ni hulina. ");
INSERT INTO nlg_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Keri ke, a Yahweh te bosa vania, “Ge takara mua taluutunigho tana vuivuni ni vaughilala ke, igeva kara taluutunigho tana ruani. ");
INSERT INTO nlg_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Hauva ma ge takara mua taluutunigho tana rua na vaughilala ke, heotia na beti tana beti tina Nile, mo ko kovala horua tana pari mamaha. Mi tana bona ko nea te vagha eni, igeva ke liliu na ghabu.” ");
INSERT INTO nlg_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ma Moses te bosa vania Yahweh, “Aghe Lord, u mua puku ni tinoni kokokoe inau. U mua tangomana mai tua me sar mai taeni. Sughua murina to bosa vaniu. Te vahola tailiu na lei bosaa.” ");
INSERT INTO nlg_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahweh te huatia, “Ahei te gonia na manga? Ma hei te gonira na vure ge kara tangomana na kokokoe, pa kara mua tangomana na kokokoe, rongo pa kara mua rongo, reirei pa kara mua reirei? Inau a Yahweh tu gonia. ");
INSERT INTO nlg_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Itaeni ko tona, mo ko gonia na hava tu bosa vanigho. Inau ku hangagho ge ko kokokoe uto, mi nau ku bosa vanigho na hava ko bosaa.” ");
INSERT INTO nlg_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ma Moses te ghoi bosa tughu oli so me ghaghua, “Lord, u nongigho so, ge ko nia vetena siki sakai na keha.” ");
INSERT INTO nlg_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ma Yahweh te rutu vania Moses, me bosa vania, “Ivei te ghaghua na hoghomu Aaron na Levite? Gaia na tinoni te kokokoe uto. Agaia te mai tana halautuna, ge ke mai topogho itaeni. Mi tana bona gaia te righigho ke, agaia ke togotogo ngangata. ");
INSERT INTO nlg_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ighoe ko kokokoe vania, ko vahea na bosa ke bosaa. Inau ku hangaghau ge koro bosa madalalai, mu ku bosaa vanighau na hava koro nea. ");
INSERT INTO nlg_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aaron ke nimua na tinoni ni kokokoe vanira na vure, mi ghoe ke vagha na God vaniana, ko bosai vania na hava ke bosaa. ");
INSERT INTO nlg_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Mo ko ghanaghana kale utoa na holaana na totoghonadira na vatogha sheep kolugho, ge ko gonighi nia na lei vaughilala tu tatei vanigho.” ");
INSERT INTO nlg_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mi tana bona Moses te pulohi tana komu me bosa vania Jethro na vungona. Moses te ghaghua, “Eliogu ge ku pulohi i Egypt na va kaoadira a nigua na binaboli. Tu mua ghilala, ara vola so pe taho.” Jethro te bosa tughu, “Ko tona kolua nigua na vauto.” ");
INSERT INTO nlg_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I naghona ge sania i Midian Moses, a Yahweh te bosa vania, “Ko bei mataghu gea na pulohi i Egypt, na pukuna agaira udolu tara liona ge kara mategho ka, tara mate tua.” ");
INSERT INTO nlg_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ma Moses te lavia tauna mana lei dalena, me talura ivuvungana na donkey, mara pulohi mai tana pari ni Egypt. Mi tana limana gaia te tabea na totoghonana God. ");
INSERT INTO nlg_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ma gaia Yahweh te ghoi bosa olia vania so, “Tana bona ko sara pulohi i Egypt ke, ko tona tana vunaghi haba tara holoa nia Pharaoh, mo ko tatea vania na butuli vaughilala tu vahegho iga na maana ge ko gonia. Mi nau ku nea ge ke toba ngasi me ke mua lubatira na vure na tona. ");
INSERT INTO nlg_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kakeri vaho ge ko bosa vania, ‘Aeni gaia na hava te bosa Yahweh, “Rana Israel/Jew tara vagha nigua na kamanagho. ");
INSERT INTO nlg_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Inau tu bosa vanigho ge ko lubatira, ma kara tona ma kara holohabau. Mana pukuna to hove ke, inau ku matera na lei kamanagho mane!” ’” ");
INSERT INTO nlg_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mi tana vinano, tana bona Moses ma nina binaboli tara beto na pukuna te bongi tua, a Yahweh te vesea Moses, me dutu ni mateana. ");
INSERT INTO nlg_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ma Zipporah, na tauna, te lavia na ivi pile, me pahevaughilalaana dalena. Gaia te lavia na ghuighuli me tabea na tuana Moses, me ghaghua, “Ighoe te vagha na tauna ni ghabu itagua!” ");
INSERT INTO nlg_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Gaia te bosa te vagha na pukuna gaia te ghanaghana vaa na pahevaughilala.) Mi murina keri, a Yahweh te lubatia Moses ge ke vola. ");
INSERT INTO nlg_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mi taeni a Yahweh te bosa vania Aaron, “Ge ke rughuhoru vaa tana bona mamaha, ge ke va topoa iga Moses.” Ma Aaron te tona tana ghotuna God, ikakeri te va topoa Moses me lavipangoti togotogoa. ");
INSERT INTO nlg_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ikakeri Moses te bosai na lei totobo soko vania Aaron na hava te bosai vania Yahweh na goniani mana bosaani. Me bosai vania ghua na lei vaughilala kara gonighi. ");
INSERT INTO nlg_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moses ma Aaron toro pulohi i Egypt moro holo kolura na lei huhuli ni Israel/Jew tana vaukolu. ");
INSERT INTO nlg_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron te bosai vanira na lei totobo soko a Yahweh te bosai vania Moses, ma Moses te gonia na butuli vaughilala tana bona tara bungutia. ");
INSERT INTO nlg_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Agaira tara huhuli tara mina mara lavipangotia te vagha a Yahweh te nia vetena Moses ma Aaron. Mi tana bona tara ghilala olia a Yahweh te righia didira na vahola me ghanaghana mavara ta nina ghanaghana, gaira udolu tara poghotao mara holohabaa God. ");
INSERT INTO nlg_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","I murina toro vaukolu soko kolura rana huhuli ni Israel/Jew, Moses ma Aaron toro va righia na vunaghi haba ni Egypt tara holoa nia Pharaoh. Ro bosa vania, “Aeni gaia na hava te bosaa Yahweh, na God didira rana Israel/Jew, ‘Lubatira nigua na vure ge kara tona, na pukuna kara rughuhoru mughua tana bona mamaha, ge kara va tabea iga na vangakolu ta nigua na maana.’” ");
INSERT INTO nlg_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaoh te mina na bosa tughu, “Ma hei gaia Yahweh ge ku rongovia, mu ku taladira rana Israel/Jew na tona? U mua ghilala inau a Yahweh, mu ku mua taladira rana Israel/Jew na tona. ");
INSERT INTO nlg_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ma Aaron ma Moses toro nia tona haliu so na tona olioliana moro bosatate, “Na God didira rana Israel/Jew te kabu kolughai. Lubatighai kai lavighi e tolu na bongi na sakutua tona tana bona mamaha ge kai taludatoa na sukaghi vania a Yahweh nimami na God. Ge takai mua tangomana ke, igeva kai mate tana vahaghi, pi tana isi.” ");
INSERT INTO nlg_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ma Pharaoh te bosa vanira, “Moses ma Aaron, na hava na pukuna ge ro gonira rana vure ge kara mua lutu/betora ta didira na lutu? Kau pulohi ta didira na lutu! ");
INSERT INTO nlg_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Rana Israel/Jew tara subo ngangata iani i Egypt, mi roghau toro va betora ta didira na lutu!” ");
INSERT INTO nlg_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mi tana bongi vaghana so keri, Pharaoh te nia vetena na bosaa vanira na vure tara ghairau tara nighi sama na lei totobo ni lutu, maia rahei tara righitaoni te talura vanira na vure ni Israel/Jew, ");
INSERT INTO nlg_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kau bei hera gea na vure siki straw na vatei goni brick. Kau nera ge kara holai heghedira! ");
INSERT INTO nlg_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kara gonighi mughua na idumiana na lei brick te vagha te padi, kau bei taluhorui gea didira na vahola ta sakai na brick. Gaira tara lugu, na pukuna keri kara huatiu ge ku lubatira na tona tana bona mamaha na vaa sukaghi vania didira na God. ");
INSERT INTO nlg_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Vahera na lei lutu te mavaa, ge kara lutu laga ma kara mua rongovighi na lei bosa sorisori.” ");
INSERT INTO nlg_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Keri ge na ghairau tara nighi sama na lei totobo ni lutu, maia gaira tara righitaoni tara bosa vanira na vure, “Pharaoh te bosa vanighai, ge kai mua vaheghau na straw. ");
INSERT INTO nlg_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kau tona ma kau va holaa heghemiu. Kau va kenea ivei kau topoi, hauva kau gonighi na lei brick te subo te vagha tau nea mai ga tana vauvaluni. ");
INSERT INTO nlg_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Keri ke, na vure tara havukaghi tana lei bona, na keneana na straw. ");
INSERT INTO nlg_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mana lei ghairau tara nighi sama na lei totobo ni lutu tara pisali ngangatara nia na vaholaa, mara bosa vanira, “Ko gonighi haia tua tughu bongi na suboana na lei brick te vagha tau nei iga na goniana tana vauvaluni!” ");
INSERT INTO nlg_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ma gaira tara ramusira na vure righitaoni lutu ni Israel/Jew tara hahanga itadira, mara huatira, “Na hava na pukuna ge au mua topoa na kakage i bongi mai taeni?” ");
INSERT INTO nlg_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ma gaira na lei mane righitaoni ni Israel/Jew tara tona ta Pharaoh mara hughuhughu kolua nia na hahanga, “Ai nongi ngangatagho ge ko bei neghai iga te vagha eni. ");
INSERT INTO nlg_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ighai ke, ra mua heghai siki straw, hauva tea mau bosa vanighai ge kai gonighi ke subo na lei brick ke vaghaa mai tana vauvaluni. Ra labughai nia na totobo te mua palumami! Na paludira animua na ghairau tara nighi sama na lei totobo ni lutu tara gonighi vanighai na lei vahaghitaili taho pukuna.” ");
INSERT INTO nlg_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ma Pharaoh te bosa tughu, “Au lugu vamua mau mua liona ge kau lutu! Na pukuna keri tau huatiu haia, ‘Lubatighai ma kai tona tana bona mamaha ge kai va sukaghi vania Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Itaeni, kau pulohi tana lutu! Taho siki straw kara vaheghau, ma kau gonia mughua na suboana na brick te vagha haia.” ");
INSERT INTO nlg_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Mi tana bona vaghana keri, Pharaoh te mua sanighi lei nina ghanaghana, mana lei mane righitaoni ni Israel/Jew tara ghilala agaira ilokana na lei vahaghitaili te sule. ");
INSERT INTO nlg_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","I murina tara sania a nina malei sopou haba ni Pharaoh, agaira tara mai topora Moses ma Aaron, toro pitura so ipari bebete. ");
INSERT INTO nlg_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Mana lei mane righitaoni tara bosa vanira, “Lubatia a Yahweh ke deteghau toro lavihagheghai mai tana vahaghitaili te dika eni kolua Pharaoh ma nina ovu ni tinoni lutu. Iroghau toro vahera na kokokoe ni mateamami!” ");
INSERT INTO nlg_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Keri ge Moses te pulohi tatana Yahweh me bosa vania, “Aghe Lord, eghua geo hulihahira nimua na puku ni vure te vagha eni? Na hava na pukuna to niu vetena iani? ");
INSERT INTO nlg_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tana vuivuni inau tu vahea Pharaoh nimua na bosaa, agaia te nia hevei na vahaghitaili te sule haba vaa ghua, vanira nimua na vure. Mo mua tabotabo ge ko vavolara!” ");
INSERT INTO nlg_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Keri ke, a Yahweh te bosa vania Moses, “Itaeni, ighoe ko righia na hava ku gonia vania Pharaoh. Tana bona agaia ke vadangia nigua na maana ivuvungana ke, agaia ke lubatira nigua na vure ge kara tona. Na pukuna nigua na maana ivuvungana ke, gaia ke bosa laga vaa ghua, ge kara sania nina pari. ");
INSERT INTO nlg_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ma God te bosa vania Moses me ghaghua, “Inau a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mi nau tu tate vania Abraham ma Isaac, ma Jacob te vagha na God puku ni maana, hauva tu mua tate tana ahagu, a Yahweh vanira. ");
INSERT INTO nlg_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mi nau tu tughuruvaghi/kapuri na baubahu kolura. Inau tu baubahu ge ku vahera na komu i Canaan, ivei tara haghara iga te vagha rana sinogho. ");
INSERT INTO nlg_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Mi taeni, inau tu rongovi utoa didira na tangi na vure ni Israel/Jew na pukuna tara tinoni ni lutu vanira na vure ni Egypt. Mi nau tu ghanaghana olia nigua na baubahu vaniadira. ");
INSERT INTO nlg_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Na pukuna keri ge, ko bosa vanira na vure ni Israel/Jew, ‘Inau a Yahweh, mu ku vavolaghau mu ku lavikeha maheboghau ta nimiu na vahaghitaili i Egypt. Mi nau tu huiolighau nia na puku ni maana, mana butuli vaughilala kolua nia na dete. ");
INSERT INTO nlg_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mi nau ku neghau ge kau puku ni nigua na vure, mi nau ku nimiu na God. Vaho ge kau ghilala inau a Yahweh nimiu na God, tu lavihorughau ta nimiu na vahaghitaili i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mi nau tu lavihagheghau mai tana komu/butonikomu tu nia baubahu vania Abraham, Isaac, ma Jacob. Mi ga ikakeri ke puku ni nimiu na lologho. Inau a Yahweh!’” ");
INSERT INTO nlg_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ma Moses te bosa vanira na vure nia na hava Yahweh te bosaa, hauva gaira tara mua ghoi liona ghua na rongoviana na pukuna gaira tara va mai tana puku ni ghanaghana ruarua tana bona tara paguhai didira na vahaghitaili ta didira na tinoni ni lutu na vure ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ma gaia Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ko ghoi pulohi ta Pharaoh, mo ko bosa vania ge ke lubatira na vure ni Israel/Jew ge kara sania i Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moses te bosa tughu, “Na kulagu na vure oli kara mua tangomana ge kara rongoviu, mi vei kea, ge ke tangomana na rongoviagu a Pharaoh? Vagha keri ke, mu ku mua kokokoe tughuru inau!” ");
INSERT INTO nlg_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ma Yahweh te ghoi bosa vanira so a Moses ma Aaron, “Koro bosa vanira rana Israel/Jew ma Pharaoh, na vunaghi haba ni Egypt, ge ku nighau vetena ge koro hulira na vure ni Israel/Jew na saniana i Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Raini gaighi na balu kemadira na Israel tana kema. Na vinavahuhu ta Reuben, na kamanagho ni Jacob, kolura nia Hanoch, Pallu, Hezron, ma Carmi. Na kukuadira tara vaa rughuhoru mai ga, na kemana Reuben. ");
INSERT INTO nlg_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ma vinavahuhu ta Simeon kolura nia Jemuel, Jamin, Ohad, Jakin, Zohar, ma Shaul (na tinadira ke, na vaivine ni Canaan.) Na kukuadira ke, tara vaa mai tana kemana Simeon. ");
INSERT INTO nlg_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Raini gaira na vinavahuhu ta Levi, tara gere horura taonia didira na binaboli tana vinavahuhu. Tana vuivuni na vinavahuhu ke, a Gershon, Kohath ma Merari. Levi, a tamadira, te vola taonia so 137 na niuluna. ");
INSERT INTO nlg_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Na vinavahuhu ta Gershon kolura nia Libni ma Shimei, sopa sakai tadira toro haghe tana kemana kukuadira. ");
INSERT INTO nlg_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Na vinavahuhu ta Kohath kolura nia Amram, Izhar, Hebron ma Uzziel. Kohath te vola taonia so 133 na niuluna. ");
INSERT INTO nlg_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Na vinavahuhu Merari kolura nia Mahli ma Mushi. Raini gaira tara haghe tana kemani Levi, tara gerehorura taonia na vinavahuhu. ");
INSERT INTO nlg_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram te tauna a vaivinena tamana Jochebed, mana vaivine te vahura vania a Aaron ma Moses. Amram te vola taonia so e 137 na niuluna. ");
INSERT INTO nlg_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Na vinavahuhuna Izhar kolura nia Korah, Nepheg, ma Zicri. ");
INSERT INTO nlg_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Na vinavahuhu ta Uzziel kolura nia a Mishael, Elzaphan ma Sithri. ");
INSERT INTO nlg_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron te tauna Elisheba, na dalena na vaivine a Amminadab, na vaivinena a Nahshon, me vahura vania Nadab, Abihu, Eleazar ma Ithamar. ");
INSERT INTO nlg_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na vinavahuhuna Korah kolura nia Assir, Elkanah, ma Abiasaph. Na vinavahuhudira te mai tana kemana Korah. ");
INSERT INTO nlg_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar dalena Aaron, te tauna sakai tadira na dalena vaivine Putiel, me vahura vania Phinehas. Raini gaira na vavatadira tana kemana Levite tara gerehorura taonia didira na binaboli. ");
INSERT INTO nlg_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","A Aaron ma Moses na ahadira ilokana na gegere eni, ma so gaia so, a Aaron ma Moses vaghana, te bosa vanira a Yahweh, “Hulira na vure ni Israel ge kara rughuhoru tana komu i Egypt, taonia sopa ovu.” ");
INSERT INTO nlg_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ma gaira raini na sopa ovu tara tona ta Pharaoh na vaa nongiana ge kara hulira na vure ni Israel tana rughuhoruadira tana komu/butonikomu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mi tana bona vaghana keri, a Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Inau a Yahweh! Ko vahea a Pharaoh na rongorongo tu vaheghau.” ");
INSERT INTO nlg_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Aeni gaia, Moses vaghana te hughuhughu kolua a Yahweh te ghaghua, “Ku mua tangomana na neana! Inau tu mua tinoni ni kokokoe, na hava na pukuna ge ke rongoviu a Pharaoh?” ");
INSERT INTO nlg_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ma Yahweh te bosa vania Moses me ghaghua, “Inau ku negho te vaghagho a God vania Pharaoh. Ma hoghomu, Aaron, ke vagha a nimua na prophet, agaia ke kokokoe vanigho. ");
INSERT INTO nlg_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ko bosai vania Aaron na lei totobo tu bosai vanigho, mo ko nea geke bosai vania a Pharaoh. Agaia ke talua na puku ni ghanaghana, ge na lei tinoni ni Israel/Jew kara lubatira ge kara sania na komu/butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mi nau ku nea Pharaoh ge ke kutuvatu, keri ge ku vahea te subo na vaughilala mana butuli, ilokana na komu/butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Sakai vamua te vagha keri, Pharaoh ke hove so na rongoviamu. Kakeri vaho, ge ku vahera na vure ni Egypt te subo na vahola, mi murina vaho eni, ge ku hulira na lei kemadira na vure ni Israel/Jew na rughuhoruadira tana lei vaughilala te sule taonia na dete. ");
INSERT INTO nlg_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tana bona inau ku tate vanira na vure ni Egypt a nigua na maana mana laga vanira tana lubatiadira na vure ni Israel/Jew ge kara tona ke, kakeri vaho ge kara ghilala utoa inau a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ma Moses ma Aaron toro goni kalea na hava a Yahweh te bosa vanira. ");
INSERT INTO nlg_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses te alu hangavulu na niuluna, ma Aaron te alu hangavulu tolu tana bona vaghana toro gonia rodidira na kokokoe vaniana Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kakeri vaho, A Yahweh te bosa vanira Moses ma Aaron, ");
INSERT INTO nlg_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Pharaoh ke liona ge koro tate vania na vaughilala te tughunitatea gaia GOd sughua te nighau vetena. Mi tana bona vaghana keri, Moses, ighoe ko bosa vania Aaron, ‘Sonihorua nimua na totoghona ni vatogha sheep,’ ge ke liliu ni poli.” ");
INSERT INTO nlg_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ma Moses ma Aaron toro tona ni va righia Pharaoh, ge koro gonia na vaughilala te vagha te bosa vanira. Aaron te sonihorua nina totoghona inaghona Pharaoh ma nina lei mane nagho, me liliu ni poli. ");
INSERT INTO nlg_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ma Pharaoh te holo haghera lei nina mane manaha mana lei mane goni butuli sorisori, mara gonia so te vagha taonia didira na lei gonigoni popolo. ");
INSERT INTO nlg_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ma didira na totoghona te liliu ni poli ghua. Hauva nina poli Aaron te sonomira didira gaira. ");
INSERT INTO nlg_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Sakai vamua te ghaghua iga, na tobana Pharaoh te mu tughu, me kabu ngasi, maia te tobavatu/kutuvatu. Gaia te mua liona ge ke rongovira, te vagha te bosa vanira Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","I murina keri, ma Yahweh te bosa vania Moses, “Pharaoh te kutuvatu so, me nia tona haliu so na hove, na lubatiadira na vure ge kara tona. ");
INSERT INTO nlg_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Keri ke, ko tona ta Pharaoh te roropo mua, tana bona ke horu tana beti tina Nile. Tughuru tana kabara ni beti tina, mo ko topoa iga. Ko hola na totoghona ni vatogha sheep te liliu ni poli. ");
INSERT INTO nlg_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mo ko bosa vania, “A Yahweh, na God didira rana Israel/Jew, te niu vetena mai ge ku bosa vanigho, ‘Ko lubatira nigua na vure ge kara tona, na vaa holohabaagu tana bona mamaha.’ Me sara mai taeni, ighoe to hove na rongoviana. ");
INSERT INTO nlg_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Itaeni a Yahweh te ghagua, ‘Ighoe ko kene taonia te vagha inau a Lord.’ Ko righia! Inau ku labua na beti tina Nile nia na totoghona eni, mana beti ke liliu ni ghabu. ");
INSERT INTO nlg_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Na igha iga kara mate, mana beti tina ke lulumi horu, mana vure ni Egypt kara mua ghoi inuvia siki beti tana beti tina Nile.’” ");
INSERT INTO nlg_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Keri vaho ge a Lord te bosa vania Moses, “Ko bosa vania Aaron ge ke tuhua nia vaa na totoghonana na beti ni Egypt taonighi na lei daidari mana kilipopu ivei tua ilokana i Egypt ke ghana iga na beti ke, me ke liliu na ghabu sughua mana na beti te ghana tana lei popo mana kuki vatu tana komudira na vure.” ");
INSERT INTO nlg_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Keri e a Moses ma Aaron toro goni kalea na hava a Yahweh te bosa vanira. Tana bona Pharaoh ma lei nina mane nagho tara bungutira, Aaron te talu ghalagha na totoghonana, me labua nia na beti tina Nile. Mua hau vaso, na beti udolu te liliu ni ghabu. ");
INSERT INTO nlg_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Na igha tana beti tina tara mate, mana beti tina te vuivunia na urumana dika ge na lei tinoni ni Egypt kara mua tangomana ge kara inu. Na ghabu udolu tua ivei mi vei tana komu/butonikomu udolu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ma gaira na lei mane goni butuli sorisori ni Egypt, tara nighi lutu didira na gonigoni popolo, ma gaira ghua tara liliua na beti ge ke ghabu. Mana tobana Pharaoh te vahola so, ma gaia te kutuvatu so. Gaia te mua liona na rongoviadira Moses ma Aaron, tana hava a Yahweh te tughunitatea vanira. ");
INSERT INTO nlg_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh te pulohi tana valena me lavi keha sokoi na lei ghanaghana tana liona. ");
INSERT INTO nlg_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ma gaira na vure ni Egypt tara gheli teke tana lilighina na beti tina Nile, ge kara hola beti ni inu, na pukuna kara mua inu tana beti. ");
INSERT INTO nlg_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Me padi tua sakai na week imurina a Yahweh te liliua na beti tina Nile, ge ke liliu ni ghabu. ");
INSERT INTO nlg_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ma Yahweh te bosa vania Moses, “Ko ghoi pulohi ghua ta Pharaoh mo ko bosa vania, ‘Aeni gaia na hava te bosaa Yahweh, “Lubatira nigua na vure ge kara tona, na vaa holohabaagu. ");
INSERT INTO nlg_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ge toko hove ko vaovarongo uto mai, inau ku nia vetena mai na kulau ke subo me ke au, me ke vonughia na komu/butonikomu. ");
INSERT INTO nlg_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Na beti tina Nile ke kilipopu/malasara kolura. Ma gaira kara dato mai tana beti, me ke mai ilokani na lei valedira, sughua ilokani na vokidira, mi vuvungani na ghimedira lei komu udolu i Egypt ke vonughira. Ke vonughighi ghua didira na bingiti mana popo vatu tara gonighi. ");
INSERT INTO nlg_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ighoe mana lei nimua mane nagho ke parikuvighau na kulau!” ’” ");
INSERT INTO nlg_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ma gaia Yahweh te bosa vania Moses, “Ko bosa vania Aaron, ‘Ko nia tuhu nimua na totoghona ni vatogha sheep taonighi na lei beti, kolomate, mana lei kilipopu ilokana na lei komu i Egypt, ge ke vonughia na kulau ilokani na lei piuni na komu/butonikomu.’” ");
INSERT INTO nlg_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron te nea te vagha, mana kulau te vonughia na komu/butonikomu udolu i Egypt! ");
INSERT INTO nlg_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ma gaira na lei mane goni butuli sorisori tara tangomanana so na neana te vagha nia didira na gonigoni popolo. Ma gaira ghua tara gonia, mana kulau te vonughia na lei komu/butonikomu udolu. ");
INSERT INTO nlg_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ma Pharaoh te holora mai Moses ma Aaron te nongira, “Koro bosa vania Yahweh, ge ke hola kehai na kulau itagua mai itadira nigua na vure. Mi nau ku lubatira nimiu na vure ge kara tona ma kara va taludatoa na sukaghi vania Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses te bosa tughu, “Ko talua vaniu na bona ni aho! Bosaa vaniu ingiha to liogu ge ku kokoeliulivutigho ighoe, kolura nimua na lei mane nagho/huhuli, ma nimua na vure. Mi nau ku kokoeliulivuti ge ighau mana lei vale kara tokeha iga na kulau. Mana beti tina Nile vamua ke kulagha me ke vola.” ");
INSERT INTO nlg_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh te bosa, “Ko nea tua iropo!” Moses te bosa tughu, “E uto so, ke tangomana na hava to bosaa. Kakeri vaho ge ko ghilala te taho siki sakai ke maana vagha a Yahweh nimami na God. ");
INSERT INTO nlg_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Na lei kulau udolu kara haurakera, lolonga gaira tana beti tina Nile kara haghara.” ");
INSERT INTO nlg_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ma Moses ma Aaron toro sania Pharaoh, ma Moses te kokoeliulivuti vania Yahweh nia na lei kulau te nira vetena. ");
INSERT INTO nlg_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ma gaia Yahweh te goni kalea na hava te nia baubahu a Moses. Na lei kulau ilokani na lei vale, mana bebete, mi tana lei leghai tara mate udolu. ");
INSERT INTO nlg_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ma rana vure ni Egypt tara sonikolura tana sausavula, mana mabulu te vonughia na komu/butonikomu udolu. ");
INSERT INTO nlg_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mi tana bona a Pharaoh te righia na lei kulau tara tona soko, gaia te ghoi tobangasi/kutuvatu tana tabana. Me mua liona ge ke rongovira Moses ma Aaron tana hava Yahweh te bosatate vanira. ");
INSERT INTO nlg_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ma Yahweh te bosa vania Moses, “Ko bosa vania Aaron ge ke labua nia na pari te pughu na totoghonana, mana pughu ni pari ke ghoi liliu ni kolodira na lei noinoi/maumanu tara ghaghala, me ke vonughia na komu/butonikomu udolu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ma Moses ma Aaron toro nea na hava te bosa vanira a Yahweh. Tana bona Aaron te labua na pari nia na totoghonana ke, na lei pughu ni pari ilokana na komu/butonikomu udolu i Egypt te liliu ni noinoi. Mua hau vaso, na noinoi/maumanu te vonughia na komu udolu, me saopora na vure n Egypt kolura didira na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nina vure ni goni butuli sorisori a Pharaoh tara tabotabo ni goni popoloana, hauvaa mara mua tangomana. Mana noinoi te saopora na vure kolura na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Na lei mane goni butuli sorisori tara bosa vania Pharaoh, “God te nea eni, nia nina maana!” Hauva na tobana Pharaoh te vahola me kutuvatu so. Me mua liona ge ke rongovira Moses ma Aaron, tana hava te bosai vanira Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Murina raini a Lord te bosa vania Moses, “Ko tughuru minamina tana roropo, mo ko va topoa Pharaoh tana bona ke vaa horu tana beti tina. Ko bosa vania, ‘Aeni gaia na hava te bosaa Yahweh, “Lubatira nigua na vure ge kara tona, ma kara tangomana na va holohabaagu. ");
INSERT INTO nlg_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ge toko hove ke, inau ku nia vetena na kolo ni lango ilokana na Egypt udolu. Na komumiu kara vonughia, mo ko mua righia na pari. ");
INSERT INTO nlg_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Me ke keha ngangata itatana na komu i Goshen, ivei tara haghara iga na vure ni Israel/Jew. Ko mua topoa na lango iga. Kakeri vaho ge ko ghilala te vagha inau a Yahweh mu tu loghoa na maana, sughua ilokana na tobana animua na pari. ");
INSERT INTO nlg_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Inau ku goni madalala na vilivoka ighobu, nimua na vure ma nigua na vure. Na vaughilala ni butuli vaghana eni ke kale iropo.” ’” ");
INSERT INTO nlg_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ma Yahweh te goni kalea na hava te bosaa. Mo ko righia na subona na lango te reirei vesikana te haghevia na valena Pharaoh kolura nia na lei vale nina mane nagho, kolura nia na lei vale ilokana na komu/butonikomu udolu i Egypt. Na kema udolu te sonihorua tana haeharegha na subona na lango. ");
INSERT INTO nlg_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ma Pharaoh te mina me holora Moses ma Aaron, me ghaghua, “E uto sono! Tona haliu, mo ko taludatoa na sukaghi vaniana nimiu na God. Ma kau nea so ikakeri tana komu/butonikomu eni. Bei rughuhoru tona gea tana bona mamaha. ");
INSERT INTO nlg_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Moses te bosa tughu, “Ke mua tangomana keri! Na vure ni Egypt kara mua liona na sukaghi kai taludatoa vaniana a Yahweh nimami na God. Ge takai taludatoi iani tara righighai igaa ke, igeva kara petaghai. ");
INSERT INTO nlg_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kai lavighi mughua e tolu na bongi na sakutua tona tana bona mamaha ge kai taludatoa na sukaghi vania a Yahweh nimami na God, te vagha te bosa vanighai.” ");
INSERT INTO nlg_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","A Pharaoh te bosa tughu, “E uto so, tona haliu. Ku tangomana ge ku lubatighau na vaa taludatoana na sukaghi vaniana a Yahweh nimiu na God tana bona aroha. Ma kau bei tona hau ngangata gea mina tua itaeni, ma kau kokoeliulivutiu.” ");
INSERT INTO nlg_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ma Moses te bosa, “Na dutuna te vagha inau ku tona ke, inau ku nongia Yahweh, ge ke lavikehara na ovu ni lango, ma kara tovongonitaghaadira vamua itamua maia na kulamu na vure. Mi nau ku vahegho na kokoe sule, ge ko bei tughua gea na liomu, mana hove pungisiadira na vure, na tona mana taludatoana na sukaghi vaniana a Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses te sania Pharaoh me nongia Lord geke lavikehara na lei lango. ");
INSERT INTO nlg_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ma Yahweh te goni kalea na hava te nongia Moses, me haurakea na ovu ni lango ge kara taghara. Taho sakai na vavanga ke ghana olia ilokana na komu/butonikomu udolu. ");
INSERT INTO nlg_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma Pharaoh te vahola olia so na tobana, me mua lubatira na vure ni Israel/Jew ge kara tona. ");
INSERT INTO nlg_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Keri ge a Yahweh te bosa vania Moses, “Pulohi ta Pharaoh, mo ko bosa vania, ‘Aeni na hava te bosa a Yahweh na God didira rana Israel/Jew, “Lubatira nigua na vure ge kara tona ma kara tangomana na va holohabaagu. ");
INSERT INTO nlg_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ge toko nia tona haliu na hove pungisiadira tana lubatiadira, ");
INSERT INTO nlg_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ku nia vetena mai na maemate te dika, ge ke dikalara lei nimiu na horse, donkey, camel, cattle, sheep, mana lei goat. ");
INSERT INTO nlg_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mu ku gonia na vilivoka ighobudira na lologho ni Israel/Jew, mana lologho ni Egypt. Taho siki sakai ta didira na maumanu na Israel/Jew ke mate! ");
INSERT INTO nlg_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mi nau, A Yahweh, tu bosa lada te vagha ku nia vetena mai na maemate tana roropoghana.” ’” ");
INSERT INTO nlg_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mi tana roropoghana, a Yahweh te goni kalea na hava te bosaa. Na lei maumanu soko ni Egypt tara mate tua, hauvaa taho siki sakai ta didira na maumanu na Israel/Jew te mate. ");
INSERT INTO nlg_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh te nira vetena nina tinoni ni lutu ge kara vaa righia, e utuni sughua te mua mate siki sakai didira na maumanu na vure ni Israel/Jew. Ma sakai vamua te vaa topoa na utuni iga, na tobana te sopou ni kutuvatu so, ma gaia te mua lubatira na vure ge kara tona. ");
INSERT INTO nlg_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Keri ke, a Yahweh te bosa vanira Moses ma Aaron, “Ko lavia na ravu ni biti, mo ko vahea Moses ge ke sonidatoa tana oka, tana bona te bubu/righia a Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Igeva ke kavulaha te vagha na pughu ni pari, me ke saopoa na komu/butonikomu udolu Egypt, ke nea na tubu ge ke kalera na vure mana maumanu ghua.” ");
INSERT INTO nlg_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ma gaira toro vahikolui na ravu ni biti, ge ro vaa righia Pharaoh. Tana bona Pharaoh te bubu, Moses te sonidatoi na ravu tana oka, mana na tuba dika te vuivuni ni kaleadira na vure mana maumanu tana komu/butonikomu udolu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Sughua na vure goni butuli sorisori tara mua tangomana ge kara tughuru inaghona Moses, na pukuna na tubu te kalera ghua te vaghara na vure ni Egypt udolu. ");
INSERT INTO nlg_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Hauvaa, a Yahweh te nea Pharaoh geke tobangasi vaa ghua, me mua liona ge ke vaovarongora, te vagha na hava a Yahweh te ghanaghana. ");
INSERT INTO nlg_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Keri ke a Yahweh te bosa vania Moses, “Ko tughuru puipungi tana roropo. Tona ta Pharaoh mo ko bosa vania, ‘A Yahweh na God didira rana Israel te ghaghua, “Lubatira nigua na vure ge kara tona, ge kara vaa holohabau. ");
INSERT INTO nlg_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ge toko mua lubatira ke, inau ku nighi vetena na lei maemate ke dika vulea vaa te padi vaniamu ighoe heghemu, ma nimua na mane nagho, kolura nia na vure ni Egypt. Mi nau ku talutatea vanigho te taho siki God keha ke vaghau inau ilokana na maramana talighu. ");
INSERT INTO nlg_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ku tangomana ge ku mate udolughau itaeni. Ku lubatia vanighau na maemate, ke lavikehaghau tana maramana. ");
INSERT INTO nlg_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Hauvaa mu lubatighau ge kau ghahaghau so, na pukuna eni, ge ko righia nigua na maana mana ladagu ke rongoragha tana maramana talighu. ");
INSERT INTO nlg_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Mi ghoe to hove pungisira so a nigua na vure, mo mua lubatira ge kara tona. ");
INSERT INTO nlg_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mi ropo te vagha itaeni ke, vaho ge inau ku nia vetena mai na uhabololo mana kebungasi ke dika vulei vaa na lei dika ilokana na tutuguna na komu/butonikomu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Keri ge ko bosa vanira nimiu na tinoni ni lutu mana lei maumanu ge kara rughuhoru mai tana leghai. Na lei tinoni pana maumanu ke ghaha so i paribebete ke mate isarana na uhabololo mana kebungasi.” ’” ");
INSERT INTO nlg_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Balu nina mane nagho a Pharaoh tara taluutunia na hava te bosa Yahweh, mara mina lavihaghera mai didira na lei tinoni ni lutu mana lei maumanu tana leghai. ");
INSERT INTO nlg_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ma rahei tara mua ghanaghana mavaa na bosana Yahweh ke, mare sanira na lei tinoni ni lutu mana lei maumanu tana leghai tana bona oka. ");
INSERT INTO nlg_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ma Yahweh te bosa vania Moses, “Hau ghalagha na limamu tana parako, mo ko nea na uhabololo mana kebungasi ge ke horuvia na butonikomu udolu i Egypt, ivuvungadira na vure, na maumanu mana lei ghai ghania.” ");
INSERT INTO nlg_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Keri ke, Moses te hau ghalagha na totoghonana va tana parako, ma Yahweh te nia vetena mai na viviha mana uhabololo mana kebungasi, mana viti te vitilia na maramana. Eo, A Yahweh te nia vetena mai ");
INSERT INTO nlg_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","na uhabololo mana kebungasi te sule, kolura na viti te tona haliu na vitiliana. Te taho mua tana tutuguna mai na komu/butonikomu Egypt ke vagha na uhabololo mana kebungasi keri. ");
INSERT INTO nlg_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mi tana Egypt talighu na uhabololo mana kebungasi te haurakera na lei totobo soko tana leghai, kolura na lei tinoni, na lei maumanu, mana lei totobo subasuba. Sughua na lei ghai tara dika. ");
INSERT INTO nlg_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tana Egypt talighu, na bubulo i Goshen vamua, tara ghahara iga na vure ni Israel/Jew, te mua kalea na uhabololo mana kebungasi. ");
INSERT INTO nlg_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ma Pharaoh te mina me nia vetena na bosa vanira Moses ma Aaron, me ghaghua, “Inau tu ghilala tu hahi sughua. A Yahweh te utuni, ma nigua na vure mi nau tai hahi. ");
INSERT INTO nlg_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Koro kurutia Yahweh ge ke sokolaghinia na uhabololo mana kebungasi! Ighai tai vadangitai ngangata! Mi nau ku lubatighau ge kau tona itaeni.” ");
INSERT INTO nlg_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses te bosa tughu, “E uto so. Tana bona ku sania na komu sule eni ke, inau ku taludatoa na limagu mu ku kokoeliulivuti vania Yahweh. Mana viviha mana uhabololo mana kebungasi ke beto. Aeni gaia na vaughilala vanigho te vagha na maramana ke, a nina Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mete vaghagho ighoe ma nimiu na mane nagho, u ghilalaghau tau mua nia kikinimaa mua Yahweh nimiu God. ");
INSERT INTO nlg_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tana bona na uhabololo mana kebungasi, na lei totobo tara subai tara holoa nia flax mana barley tara haurake/dika, na pukuna na barley tara mada, mana flax teara vuivuni ni sia. ");
INSERT INTO nlg_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Na wheat mana spelt tara mua dika na pukuna tara mua totolo dato mai mua tana pari. ");
INSERT INTO nlg_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Keri ke Moses te sania Pharaoh me rughuhoru tana komu sule. Tana bona te hau ghalagha na limana me kokoeliulivuti vania Yahweh ke, na viviha mana kebungasi mana uhabololo te beto. ");
INSERT INTO nlg_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tana bona Pharaoh ma nina mane nagho tara righia eni, gaia ma nina mane nagho tara ghoi palugha oli, na pukuna tara ghoi kutuvatu mara mua liona ge kara taonia na hava tara nia baubahu. ");
INSERT INTO nlg_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ma Pharaoh te mua lubatira na vure ni Israel/Jew ge kara sania, te vagha na hava te liona Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ma gaia Yahweh te bosa vania Moses, “Ko pulohi ta Pharaoh, mo ko ghoi gonia animua na ghanaghana. Inau tu nea gaia ma nina mane nagho ge kara kutuvatu, vaho ge ku nia tona haliu na talutateana a nigua na maana tana lei vaughilala te haeharegha ighobudira. ");
INSERT INTO nlg_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Keri ke ighau kau tutuguni na lei tutugu te haeharegha vanira na lei dalemiu mana lei kukuamiu nia na lei totobo te haeharegha inau tu gonighi tana ghobudira na vure ni Egypt te talutate inau a Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ma Moses ma Aaron toro tona ta Pharaoh, moro ghaghua vania, “Aeni gaia na hava te bosaa Yahweh, na God didira rana Israel/Jew, te ghaghua, ‘Ivei vaho ke vagha na hauna na hava vaghana ko nia hevei na maana vaniu? Lubatira nigua na vure ge kara tona, ma kara tangomana na holohabaagu. ");
INSERT INTO nlg_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ge toko hove ke, ko righitaonigho, i ropo ke, inau ku saroa nia na kema/butonikomu udolu na puko. ");
INSERT INTO nlg_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ke sepa me ke hali ge ko mua tangomana na righiana na pari. Gaira kara ghanighi na lei totobo tara ghaha olighi tana uhabololo mana kebungasi, kolui nia na lei ghai tana leghai. ");
INSERT INTO nlg_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gaira kara samahaghe ta nimua na malei haba, mana komudira animua na mane nagho, mana lei vale udolu i Egypt. Taho mua tana tutuguna, tana vuivunina mai i Egypt, ke kalea na maemate te vagha eni!” Nia keri, Moses te ririu pulohi, me sakutua horu. ");
INSERT INTO nlg_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Gaira na lei mane nagho tara mai ta Pharaoh, mara kokokoe vania, “Ivei vaho ke vagha na hauna ko lubatia na mane eni geke nea na haurake vaghana eni? Ai nongigho ge ko lubatira na lei mane ni Israel/Jew ge kara tona ni va holopangotiana Yahweh didira na God. O mua righiolia na komu/butonikomu i Egypt te koli tana haurake?” ");
INSERT INTO nlg_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Keri ge gaira tara lavi pulohira Moses ma Aaron mai ta Pharaoh. Gaia te bosa vanira, “E uto so, tona ma kau holopangotia Yahweh nimiu na God. Ma kau bosa vaniu mai, engiha vamua to liodira na tona?” ");
INSERT INTO nlg_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses te bosa tughu, “Ighai udolu kai tona. Kai holara na vaolu mana haulaghi, na lei dalemiu na mane mana vaivine, ma nimami na lei sheep mana goat mana buluka. Ighai udolu kai savukolu koukolu tana bongina Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh te bosa tughu nia na rutu, “Inau tu nia papari tatana Yahweh, mi nau ku mua lubatighau ge kau holara nimiu na vaivine mana dalemiu! Inau tu ghilala vakale ighau kau talugoni dika. ");
INSERT INTO nlg_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Taho! Na lei mane vamua kara tona na taludatoana a Yahweh, gaia keri na hava tau nongia.” Ma Pharaoh te sonihorura Moses ma Aaron ta nina malei haba. ");
INSERT INTO nlg_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kakeri vaho, a Yahweh te bosa vania Moses, “Talu ghalagha na limamu ivuvungana na komu/butonikomu Egypt, ge ko lavi olia mai na lei puko. Gaira kara saopoa na komu/butonikomu, ma kara ghanighi na lei totobo subasuba, mana lei vavanga tana lei ghai tara ghaha olighi imurina na uhabololo mana kebungasi.” ");
INSERT INTO nlg_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ma Moses te hau ghalagha na totoghonana, ma Yahweh te lubatia mai na ghuri i ulu geke ghuri na dani udolu me ke lavia na bongi udolu. Mi tana roropoghana, na ghuri te mai i ulu te lavira mai na lei puko. ");
INSERT INTO nlg_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mana lei puko tara vonughia na komu/butonikomu udolu i Egypt. E dika vulea na maemate ni puko tana tutuguna mai na komu/butonikomu Egypt, ma taho mai mua ke vagha eni. ");
INSERT INTO nlg_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Na lei puko tara saopoa udolu na komu/butonikomu udolu, me nea na pari ge vaevane bili. Ma gaira tar ghanighi na lei totobo subasuba mana lei vavanga tana lei ghai tara ghaha olighi tana uhabololo mana kebungasi. Taho siki totobo vola ke ghaha olia, na ghai pana totobo subasuba ilokana na Egypt udolu. ");
INSERT INTO nlg_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ma Pharaoh te mina me holora Moses, ma Aaron, me ghaghua, “Inau tu toghighi na palugu inaghona a Yahweh nimiu na God, maia iroghau. ");
INSERT INTO nlg_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Talukehai vaniu na palugu, vania na totobo eni, mo ko kurutia Yahweh nimiu na God, ge ke lavikeha na maemate te dika parihai eni.” ");
INSERT INTO nlg_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ma Moses te sania Pharaoh, me kokoeliulivuti vania Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Keri ge Yahweh te lubatia mai na ghuri i boko, mana ghuri te ghurihira na lei puka va tana na Tahi Sisi. Taho siki puko te ghaha olia ilokana na butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Hauva Yahweh te nea Pharaoh ge ke kutuvatu oli, me mua lubatira na vure ge kara tona. ");
INSERT INTO nlg_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Keri ke, Yahweh te bosa vania Moses, “Talu ghalagha na limamu vaa i kokou, mana pui loloho te mamataghugha ke horuvia ivuvungana na komu/butonikomu Egypt, keri ge na lei tinoni tara taotavongo.” ");
INSERT INTO nlg_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ma Moses te haua na limana vaa ikokou, mana pui loloho te horuvia na komu/butonikomu Egypt e tolu na bongi. ");
INSERT INTO nlg_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mi tana lei bongi vaghani raini, rana vure ni Egypt te mua vaevanea sopa heghedira, keri ge tara mua sanighi na valedira. Hauva rana Israel/Jew tara loghoa na mararana na dani tana lei bona tara ghahara. ");
INSERT INTO nlg_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ma Pharaoh te holoa Moses me ghaghua, “Tona ma kau holohabaa Yahweh. Ma kau tangomana na holadira na lei dalemiu mana nimiu lei vaivine. Hauva kau sanighi na lei sheep, mana lei goat mana lei buluka iani.” ");
INSERT INTO nlg_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ma Moses te ghaghua, “Taho. Kai tangomana ge kai holai nimami na sheep, mana goat mana buluka na vatei sukaghi mana hevei kekere vania Yahweh nimami na God. ");
INSERT INTO nlg_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Na lei nimami na totobo lologho ke tona kolughai, taho siki sakai te ghaha olia. Mi ghai kai vilia a nimami na sukaghi vaniana Yahweh nimami na God itadira na lei maumanu raini. Kai mua tangomana ge kai ghilala ivei na sukaghi ia te liona, koekobe kai sari ikakeri.” ");
INSERT INTO nlg_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma Yahweh te vahola so na tobana Pharaoh, ge ke mua ghoi lubatira na tona. ");
INSERT INTO nlg_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh te ghuuvia Moses, “Rughuhoru keha iani taeni! Mua ghoi liona ghua ge ku righi matamu! Na dani ko gonia iga, na dani ko mate iga.” ");
INSERT INTO nlg_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses te bosa tughu, “E uto so! Ku mua ghoi righi oligho ghua!” ");
INSERT INTO nlg_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ma Yahweh te bosa vania Moses me ghaghua, “Inau ku ghoi nia vetena mai ghua a sakai na maemate ivuvungana Pharaoh mana vure ni Egypt. Mi murina keri, Pharaoh ke lubatighau ge kau tona. Tana bona vaghana keri, agaia ke ghuruhorughau udolu, ma kau sania na komu/butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Bosa vanira na lei tinoni ni Israel ge kara nongira na lei komukoludira na Egypt tana lei totobo te vaghai na silver mana gold.” ");
INSERT INTO nlg_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Itaeni, a Yahweh ke nera na vure ni Egypt ge kara righi arovira na vure ni Israel, ma Moses tara ghanaghanadira agaia na mane sule tana komu/butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ma Moses te ladavaghinia vania Pharaoh, “Aeni gaia na hava te bosaa Yahweh, ‘Siki bonana igeva tana bongi hau, inau ku tona haliu tana ghobuna na komu/butonikomu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gaira udolu na lei kamanagho mane kara mate ilokana sopa binaboli tana komu/butonikomu udolu i Egypt, ke vuivuni ta nina kamanagho a Pharaoh, te sopou tana malei haba, kolua nia nina kamanagho a nina na ghairau sosoko. Sughua na lei kamanagho tana lei maumanu tara mate. ");
INSERT INTO nlg_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mi murina vaso eni, na tangi ngangaraha te haeharegha ko rongovia tana Egypt udolu, taho mai mua siki totobo ke haeharegha ke vagha eni ingiha, me ke mua ghoi kale ghua. ");
INSERT INTO nlg_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mi ghobudira na vure ni Israel/Jew ke, te hodo vaovarongo, sughua na kau te mua ngoho. I murina keri, vaho ge ko ghilala inau, a Yahweh, tu gonia na vilivoka eni ighobudira na vure ni Egypt mana vure ni Israel/Jew.’” ");
INSERT INTO nlg_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Moses te bosa sosoko, “Gaira udolu na lei mane nagho ni Egypt tara sama mai tagua, mara tongaghi horu, mara ghaghua, ‘Ai nongi ngangatagho, ge kau tona! Ighoe kolura udolu arahei kara tona kolugho.’ Mi murina keri, inau ku tona!” Ma Moses te rutu ngangata, me sania a nina malei haba Pharaoh. ");
INSERT INTO nlg_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Keri ke, a Yahweh te bosa vania Moses, “Pharaoh ke mua tangomana ge ke varongohigho, keri ge ku gonia na butuli ke haba vaa tana komu/butonikomu Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Sakai vamua Moses ma Aaron toro gonighi na lei butuli raini tana matana Pharaoh, a Yahweh te va ngasilia so na tobana ge ke mua lubatira na vure ni Israel/Jew ge kara sania na komu/butonikomu. ");
INSERT INTO nlg_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Itaeni Yahweh te nia hevei na lei kokokoe vanira Moses ma Aaron tana bona tara ghahara mua tana komu/butonikomu Egypt, ");
INSERT INTO nlg_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Te vuni taeni me ke gatu, na vula eni ke, na vuivuni na vula tana niulu vanighau. ");
INSERT INTO nlg_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ladavaghinia vania na vure udolu ni Israel/Jew tana hangavuluni na bongi tana vula eni, sopa binaboli ke vilia na dalei sheep pana goat vaolu ke vania na sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ge na binaboli ke pile kikia ke mua tangomana na ghaniana heghena na dale sheep, lubatira ge kara tuvalia na dale sheep kolura na balu binaboli tana tamahoghoni. Sakai vamua pa ke taho, kara nea iga na tuvaliana tana halautu eni, taonia na subona sopa binaboli, maia ghua ivei ke vagha na sulena kara ghania. ");
INSERT INTO nlg_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Na maumanu eni ke topoa mughua sakai na niulu na hauna me ke mane, na sheep pa ke goat, me ke bei vahaghigha gea. ");
INSERT INTO nlg_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Lavia na puku ni righitaoni tana lei sheep raini me ke sara tana nulavi tana hangavulu vatini na bongi tana vuivuni ni vula eni. Kakeri vaho ge sopa binaboli ilokana na mavitu kara sopa matei didira na dale sheep. ");
INSERT INTO nlg_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Gaira kara holai balu ghabuni na sheep ma kara seburukaghinighi ikouni mana lilighini na ghaini na mataulani na vale ivei kara ghanighi ga na sheep. ");
INSERT INTO nlg_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tana nulavi vaghana keri lei tinoni udolu kara ghania na dale sheep ghalati kolua nia na beti mali mana berete, tara mua ule kolua nia na yeast. ");
INSERT INTO nlg_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Na vinahi kara bei ghani kaikarighaipa kara bei kukia. Kau biti udolua, kolua nia na ulu, tua, mana lei hegohegona udolu. ");
INSERT INTO nlg_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kau bei sania siki pilena me ke topoa na roropoghana. Na hava tua to mua ghania tana bongi, kau kere taghalaghinia. ");
INSERT INTO nlg_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Nia pupulu nimiu na tivi ni oleole tana bona kau ghania na vanga nulavi eni, te vagha kau gonidila vania na vinano. Kau haghelaghinighi na hahara ni tuamu, mo ko lavia a nimiu na totoghomiu tana limamiu. Mina ma kau ghania na ghamiu na vanga, na pukuna aeni gaia a nina lovuvule a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tana bongi vaghana keri inau ku lovu vulea na komu/butonikomu udolu Egypt mu ku matera na lei kamanagho mane mane lei kamanagho mane tana lei maumanu soko ilokana na komu/butonikomu udolu i Egypt. Inau ku lavia na deteadira na lei didira na god ni Egypt, na pukuna inau a Yahweh! ");
INSERT INTO nlg_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Na ghabu kau seburukaghinia tana ghaina na mataula ke tatea na vaughilala ni vavola. Tana bona inau ku righia na ghabu, inau ku lovovulegho. Mana maemate ni mate eni ke mua tabeghau tana bona ku labua na komu/butonikomu i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ma kau ghanaghana olia na bongi eni ke va me va. Tughu niulu kau ghanaghana olia te vagha na bongina Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ilokani e vitu na bongi, ighau kau ghanighi na berete te taho iga na yeast. Tana vuivuni puku ni bongi, ighau kau gharadukehai na lei yeast tana lei valemiu. Ge ahei ke ghania na berete te gonia nia na yeast tana lei bongi ilokani e vitu na bongi tana bongi ni ghanaghana oli ke, kau lavikeha tana ovu ni tinoni ni Israel/Jew. ");
INSERT INTO nlg_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tana vuivuni ni bongi, na bongi ni ghanaghana oli, maia ghua tana vituni na bongi, lei tinoni tara savukolu, na pukuna na bona ta talu sosopa iga na holohaba. Taho iga na lutuana siki totobo tana lei bongi raini lolonga na gonidilaana na vanga. ");
INSERT INTO nlg_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Talu gonia haia na bongi ni berete gulu, na pukuna gaia ke neghau ge kau ghanaghana olia haia inau tu lavihorughau tana komu/butonikomu i Egypt tana puku ni bongi vaghana na bongi ni ghanaghana oli eni, ke ngasi itamiu me ke nimiu vetena taonia na vavata mana vavata. ");
INSERT INTO nlg_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Na berete te taho iga na yeast lolonga ke ghania te vuni tana nulavi hangavulu vatini na bongina na vula me ke sara tana nulavi ghana tana rua hangavulu sakaini na vula vaghana. ");
INSERT INTO nlg_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ighobuni gaighi e vitu na bongi raini, ke taho na yeast tana lokana na komumiu. Ge ahei ke ghania siki totobo ke gonia nia na yeast ilokana na week eni, ke tokeha tana ovu ni tinoni ni Israel/Jew. Ma gaighi so na vetena raini, ke tona vanira na vure keha tara kabukolughau, ge takara vahura ighobumiu. ");
INSERT INTO nlg_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ku ghoi bosa olia, ighobuni na lei bongi raini kau bei ghanighi gea siki totobo kau gonighi nia na yeast. Ivei tua ko ghahagho, ko ghania vaso na berete te taho iga na yeast. ");
INSERT INTO nlg_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ma Moses te holora na lei mane huhuli ni Israel/Jew ge bosa vanira, “Kau bosa vania sopa nimiu binaboli, ge kau matera na shep tau talukehara vania na lovovule. ");
INSERT INTO nlg_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kau talukehai na ghabuni na dale sheep tana disi. Vaho ge kau lavia na otona na hyssop ma kau lumia tana ghabuna na dale sheep. Seburukaghinia na hyssop tana kauna mana lilighina na ghaina na mataula ghuduria nia na ghabu. Kau ghanaghana, mua lubatia siki sakai ge ke rughuhoru sania na vale koekobe tana roropo. ");
INSERT INTO nlg_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Na pukuna a Yahweh ke lovovulea na komu/butonikomu udolu Egypt me ke matera na lei kamanagho ni Egypt. Mi tana bona ke righia na ghabu tana kauna mana lilighina na ghaina na mataula, a Yahweh ke lovovulei na valemiu. Ke mua lubatia na angel te matera rana vure ge ke haghe me ke matera nimiu na lei kamanagho. ");
INSERT INTO nlg_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Na tutughunitate raini ke kabu tona haliu mi ghau kau righitaonighi maia ghua na lei vavatamiu polo ke va me va. ");
INSERT INTO nlg_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tana bona kau sara tana komu/butonikomu te bahughau nia Yahweh ge ke vaheghau, ighau kau nia tona haliu na talugoniana na ghanaghana oli eni. ");
INSERT INTO nlg_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tana bona na lei dalemiu kara huatighau, ‘Na hava na pukuna ighai tai talugoni vaghana gaia eni?’ ");
INSERT INTO nlg_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Vaho ge kau bosa tughu, ‘Na ghanaghana oliana Yahweh te lovovule, na pukuna gaia te lovovulei na valedira na Israel/Jew tana komu/butonikomu i Egypt. Gaia te matera na lei kamanagho mane i Egypt, me mua matera nimami na lei kamanagho.’” Vaho ge na lei tinoni soko tara malu horui na uludira mara holohabaa God. ");
INSERT INTO nlg_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kakeri ge na lei tinoni ni Israel/Jew kara goni taonia na hava Yahweh te bosa vanira nia a Moses ma Aaron. ");
INSERT INTO nlg_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tana kutuna na bongi hau, Yahweh te matera na lei kamanagho mane tana komu/butonikomu i Egypt, te vuivuni tana kamanagho mane ta Pharaoh te sopou tana malei haba, ma nina na kamanagho mane na mane tara sagua tana vale pipiti. Sughua didira na kamanagho tana lei maumanu tara matera. ");
INSERT INTO nlg_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaoh ma nina ovu ni huhuli mana lei tinoni soko i Egypt tara rarai tana bongi. Mara tangi ngangaraha tana komu/butonikomu udolu i Egypt, na pukuna tana sopa valedira siki sakai te mate tua. ");
INSERT INTO nlg_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pharaoh te nira vetena Moses ma Aaron tana bongi eni, me ghaghua, “Sanighai! Tona keha ighau udolu! Tona ma kau holohaba vania a Yahweh te vagha toro bosaa. ");
INSERT INTO nlg_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Lavira lei nimiu na maumanu soko ma kau tona. Mo koro nongia Yahweh ge ke vautou inau ghua.” ");
INSERT INTO nlg_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Na lei tinoni soko i Egypt tara liodira na vure ni Israel/Jew ge kara mina ma kara rughuhoru, na pukuna tara ghanaghana, “Igeva kara mate udolu!” ");
INSERT INTO nlg_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Na vure ni Israel/Jew tara hola kolura nia didira na vatei berete tara mua gonia nia na yeast. Ra poroi nia na tivi te au didira na baolo/bowl ni vatei goni berete mara holai tana valadira. ");
INSERT INTO nlg_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ma gaira na vure ni Israel/Jew tara goni taonia na hava te bosa vanira Moses na nongiadira na vure ni Egypt na tivi mana balu totobo te vagha na silver mana gold. ");
INSERT INTO nlg_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A Yahweh te nera na vure ni Egypt ge kara righi arovira na vure ni Israel/Jew, ma kara vahera na Israel/Jew na hava tua tara nongia itadira. Te vaghara na vure veitotoghoni lagavule tara haghevia na komu, tara nera iga nina lologho na vure ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Tana bongi vaghana keri, na vure tara sania Rameses mara tona via vaa i Succoth. Na subodira ke te kaekage ono na hangalatu ni togha, Tara mua idumira na lei vaivine mana gari pile. Gaira udolu tara sakutua. ");
INSERT INTO nlg_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Subo na vure tara mua Israel/Jew tara tona kolura, nia didira na maumanu te subo. ");
INSERT INTO nlg_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ivei tua kara ahevata iga na vanga, ge kara gonia na berete tana baolo/bowl tara mua talu yeast igaa, tara lavighi mai tua i Egypt. Ra gonighi te taho iga na yeast na pukuna na vure tara minamina ge kara rughuhoru tana komu/butonikomu Egypt, mara mua loghoa na bona ni aho ge kara pitua na berete ke dato. ");
INSERT INTO nlg_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Na vure ni Israel/Jew tara kabu i Egypt vati na hangalatu tolu hangavulu na niulu. ");
INSERT INTO nlg_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tana bongi sosoko tana vati na hangalatu tolu hangavulu na niulu na lei kema nina vure Yahweh gera sania na komu/butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tana bongi eni Yahweh te righitaonira nina vure ge ke lavi rughuhorura tana komu/butonikomu Egypt. Kakeri tea ge na bongi taeni a nina bongi gaia. Ge kara ghanaghana olia tughu niulu, taonia na vavata mana vavata, na ghanaghana oliana na lavi rughuhoru eni a Yahweh te nea. ");
INSERT INTO nlg_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ma Yahweh te bosa vanira Moses ma Aaron, “Raini na lei vetena vania na ghanaghana oliana na Lovovule. Mua lubatia na tinoni keha geke ghania na dale sheep ni Lovovule. ");
INSERT INTO nlg_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ma siki ghairau tau pelua ke ghania so, ge teke pahevaughilala. ");
INSERT INTO nlg_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Na tinoni lutu kolura nia na tinoni tona mai kara mua ghania. ");
INSERT INTO nlg_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Arahei udolu kara ghania na dale sheep ke, kara ghani koukolua tana vale. Kau bei lavikeha siki pilena na vinahi i pari bebete, ma kau bei gotia gea siki pilena na huli. ");
INSERT INTO nlg_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Na lei tinoni soko ni Israel/Jew kara ghanaghana olia na bongi eni ta sakai na bona ni aho vamua. ");
INSERT INTO nlg_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ge siki tinoni keha ke ghaha i ghobumiu me ke liona geke hahanga ta nina Lovovule Yahweh ke, na lei mane udolu ge kara pahevaughilala mughua. Vaho ge kara hahanga tana ghanaghana oliana na Lovovule kolughau. Gaira kau bosa ngangata vanira te vagha tara vahura ighobumiu. Ma gaira na lei mane tara mua pahevaughilala kara mua ghania na dale sheep ni Lovovule. ");
INSERT INTO nlg_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Na lei vetena eni ke vania sopasopa sakai, itadira tara vahura na Israel pa na vure keha tara ghahara ighobumiu.” ");
INSERT INTO nlg_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mana lei tinoni ni Israel/Jew tara taonia na lei nina kokokoe Yahweh vania Moses ma Aaron. ");
INSERT INTO nlg_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mi tana puku ni bongi vaghana Yahweh te vuivuni ni huliadira na Israel/Jew tana sopa kema. ");
INSERT INTO nlg_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ma Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Vaa tabura vaniu na lei kamanagho mane ni Israel/Jew kolura nia na lei kamanagho mane tana lei maumanu ghua. Gaira kiri ra nigua.” ");
INSERT INTO nlg_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ma Moses te bosa vanira na vure, “Aeni gaia na bongi ka ghanaghana kasilaa - na bongi ta sania Egypt, na komu/butonikomu ta seka iga, na pukuna Yahweh te lavihorughau nia a nina maana te laga ngangata. Keri ge kau mua ghania na berete kolua na yeast. ");
INSERT INTO nlg_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tau rughuhoru na butonikomu Egypt tana bongi eni, ilokana na diki vula, tara holoa nia Abib. ");
INSERT INTO nlg_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","A Yahweh te nia baubahu na kukuamiu geke vaheghau na butonikomu tara ghahara iga rana vure ni Canaan, rana vure ni Hit, rana vure ni Amor, rana vure ni Periz, rana vure ni Hivi, ma rana vure ni Jebus, na pari te tave iga na kokolo ni susu mana midua. Mi tana bona te lavi hagheghau mai tana na butonikomu keri, kau ghanaghana olia mughua na dani eni tughu niulu. ");
INSERT INTO nlg_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ilokani e vitu na bongi kau ghania vamua na berete gulu. Vaho tana vituni na bongi ke, ge kau gonia anina puku ni vangakolu ma kau nia kikinima Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ghania vamua na berete gulu ilokani e vitu na bongi. Ke vagha, te taho na yeast ilokana na valemiu, pi vei ghua kililia na sosoko na komu/butonikomu tau ghahaghau iga tana bona vaghana eni. ");
INSERT INTO nlg_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tana bona ke kale haia tughu niulu na bongi vaghana eni ke, kau toghia vanira na lei dalemiu, ‘Na ghanaghana oli eni ke, na hava Yahweh te nea vanighai tana bona tai sania Egypt.’ ");
INSERT INTO nlg_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Na bongi ni ghanaghana oli eni ke, tughu niulu kau righia te vagha na vatei ghanaghana oli vanighau, te vagha na vaughilala tana limamiu pi tana ulumiu. Lubatighi lei nina kokokoe Yahweh ke neghau ge kau ghanaghana olighi tana liomiu mana ghidumiu. Imurina soko raini, gaia Yahweh te lavi horughau mai tana komu/butonikomu Egypt nia na maana te sule. ");
INSERT INTO nlg_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Keri te vagha ge kau talugonia na bongi eni te kale iga tughu niulu tana bona Yahweh te vilia tua. ");
INSERT INTO nlg_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Yahweh ke lavighau mai tana komu/butonikomu tara ghahara iga rana vure ni Canaan, te nia baubahu geke vaheghau maia a kukuamiu tana bona te hau mai tua. Mi tana bona te vahea na butonikomu keri vanighau, ");
INSERT INTO nlg_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kau vahe olia Yahweh na lei kamanagho mane mana lei kamanagho mane na lei maumanu. Ighita udolu anina Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Na kamanagho mane na donkey kara tughua/huiolia nia na dale sheep tana bona kara vahe olia Yahweh. Ma ge takau mua ghanaghana ge kau tughua na donkey ke, kau matea nia na gotiana na luana. Hauva, kau tughui haia na lei kamanagho mane. ");
INSERT INTO nlg_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Mi tana bongi ke mai nagho, na lei dalemiu kara huatighau, ‘Na hava na lei ghanaghana udolu iga raini?’ Vaho ge kau bosa vanira, ‘Nia a nina maana te laga Yahweh te lavihorughai nia tana kabu popongo i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pharaoh te mua lubatighai ge kai tona, keri ge Yahweh te labumatera na lei kamanagho mane udolu tana komu/butonikomu udolu i Egypt, na tinoni mana lei maumanu. Keri vaho tua na pukuna ge ai taludatoi/sukaghighi vania Yahweh na lei kamanagho mane ni maumanu, hauva kai tughu haia na lei kamanagho mane.’ ");
INSERT INTO nlg_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mu ku ghoi bosa oli so na talugoni vaghana eni ke, te vagha na vaughilala tau talua tana limamiu pa au talua tana raemiu, ge kau ghanaghana haia Yahweh te lavihorughau nia na maana te laga.’” ");
INSERT INTO nlg_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Tana bona Pharaoh te lubati tatavahalera na vure ni Israel/Jew ge kara tona, God te mua hulira tana halautu te tona pota na bubulo ni Philistia, sakai vamua te kukulu na hala. God te ghaghua, “Ge nigua na vure kara tona via vaa na veitotoghoni ke, igeva kara tughua na liodira ma kara pulohi i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Keri ge God te hulira vaa tana bona mamaha taonia va na Tahi Sisi. Ma rana Israel/Jew tara sania Egypt te vagha na vure veitotoghoni te sakusakutua. ");
INSERT INTO nlg_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses te lavia na hulina Joseph itatana, na pukuna na Joseph te bosa vanira rana Israel idania ge kara baubahu vania na laviana na hulina tana bona God ke hulira horura i Egypt. Joseph te bosaa, “Tana bona God te vavolaghau ke, kau lavia mughua na huligu kolughau itatana na bona/butonikomu eni.” ");
INSERT INTO nlg_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Rana Israel/Jew tara sania Succoth, ma gaira tara kabu i Etham tana sosokona na bona mamaha. ");
INSERT INTO nlg_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahweh te hulira nia na ghobaghuli ni pui tana dani, mana lapilapi ni lake tana bongi. Nia na halautu vaghana eni, gaira kara tona so tana dani mana bongi. ");
INSERT INTO nlg_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Na ghobaghuli ni pui te kabu haia inaghona rana vure tana dani, mana lapilapi ni lake tana bongi. ");
INSERT INTO nlg_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ma Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ko bosa vanira na vure Israel/Jew ma kara ririu oli va tana bona tara holoa nia Pi Hahiroth ighobuna i Migdol mana Tahi Sisi, ma kara taludatoi na vale tapole, ke dutuvia na tahi, me ke dutuvia na bona tara holoa nia Baal Zephon. ");
INSERT INTO nlg_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Keri ke, mana vunaghi haba Pharaoh ke ghanaghanaa ke, mara sivi tana halautu, ra onga kolili didira vamua tana bona mamaha, mara mua pukua ivei kara ghoi liu va. ");
INSERT INTO nlg_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mi nau ku ghoi nea Pharaoh ge ke tobangasi, ge ke ghoi saritaonira na vure. Mi nau ku laga vulea Pharaoh maia nina lei malaghai, mana nigua na vure subo kara ghoi holohabau. Mana vure ni Egypt kara ghilala inau sughua Yahweh!” Mana vure ni Israel/Jew tara goni taonia na hava te bosaa God vanira. ");
INSERT INTO nlg_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tana bona na vunaghi haba ni Egypt te rongovira na vure ni Israel/Jew tara sogha sania tua, gaia maia lei nina mane nagho tara tughui na liodira, mara bosa te vagha eni, “Na hava ta gonia eni? Ighita ta lubatira rana Israel/Jew ge kara sani tatavahale, mi ghita ka sivilaghinira tua dida na vure kabu pipiti kiri!” ");
INSERT INTO nlg_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Keri ge Pharaoh te holo kolura nina lei malaghai me idevia na ghuru taonia olia nia na vure ni Israel/Jew ta nina taitakiro. ");
INSERT INTO nlg_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Me holai ono hangalatu na puku ni taitakiro kolui nia na balu taitakiro ni Egypt ghua, me sopa talu malaghaini ge kara righitaonighi. ");
INSERT INTO nlg_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ma Yahweh te nia na liona Pharaoh ge ghoi tobangasi me ghuru taonira na vure ni Israel/Jew tara sogha. ");
INSERT INTO nlg_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Na lei malaghai udolu ta Pharaoh, kolui na lei horse, mana lei taitakiro, maia na lei malaghaini tara ghuru taonira nia na vure ni Israel, mara mai saravia na bona tara taludato iga na vale tapole lilighini na tahi te dutuvia Pi Hahiroth mi Baal Zephon. ");
INSERT INTO nlg_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tana bona Pharaoh ma nina lei malaghai tara mai dutu, na vure ni Israel/Jew tara righira tara dutuvira tua. Rana Israel/Jew tara mataghu ngangata, mara ngangaraha vania Yahweh ge ke hangara. ");
INSERT INTO nlg_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mara vuivuni ni bosa hughuhughuana Moses te vagha eni, “Ivei tea go holoa horughai mai i Egypt, ge kai mai mate tana bona mamaha te vagha eni? O ghanaghana ighoe ke, me kukutu na pari ni tavughi tinoni mate i Egypt? Ko righia mua, o hola horughai mai iani ge kara mai dikalaghai vamua. ");
INSERT INTO nlg_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ighai tai bosa sokoi vanigho tua te vagha eni, mai bosaa ghua ke, e uto vamua ge kai kabu oli ma kai didira tinoni ni lutu lee/seka vamua, hauva mo mua rongovighai so. Ma ge takai didira tinoni ni lutu lee/seka so ke, e uto vulea va kai mai mate iani tana bona mamaha.” ");
INSERT INTO nlg_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ma Moses te bosa tughu vanira, “Kau bei mataghu gea! Kau tughuru ngasi ta nimiu na taluutuni, ge kau righia nina maana Yahweh ke nea vanighau taeni, geke vavolaghau! Na vure ni Egypt tau righira, kau mua ghoi righira ghua. ");
INSERT INTO nlg_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Kau kabu beto, ma Yahweh vamua ke nighau pala. Yahweh ke veitotoghoni tughughau!” ");
INSERT INTO nlg_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ma Yahweh te bosa vania ghua Moses, “Ivei tea ko tangi/kuruti/nongi vaniu mai? Ko bosa vanira na vure ma kara sakutua tona so. ");
INSERT INTO nlg_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ko tabe datoa na totoghonamu mo ko haua vuvungana na tahi, ge ke mamaha levu mi levuna ge kau sakutua halavu na vure tana pari mamaha. ");
INSERT INTO nlg_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mi nau ku ghoi nera na vure ni Egypt ma kara tobangasi ma kara tona haliu so na saritaoniamiu. Mi nau ku laga vulea so a Pharaoh maia nina lei malaghai, ge nigua na vure kara holohaba datoa na ahagu. ");
INSERT INTO nlg_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Mi tana bona na vure ni Egypt kara righia tu laga vulera tua te vagha keri, vaho ge kara ghilalaa inau sughua tu puku ni God. ");
INSERT INTO nlg_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ma nina angel God te idevia haia na lei malaghai/vure ni Israel/Jew, te gharadu oli me va sopou mai i muridira mana ghobaghuli ghua te gharadu me va sopou mai ghua i muridira. ");
INSERT INTO nlg_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mana ghobaghuli te sopou ighobudira na lei vure ni Israel/Jew mi Egypt. Mana ghobaghuli te nia hevei so na pui sule vanira na levu na Egypt, hauva didira na levu na Israel/Jew te nia hevei so na marara. Keri ke, tana bongi keri rua na levu pala mara mua vei dutudutua. ");
INSERT INTO nlg_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ma Moses te hau datoa na limana vuvungana na tahi. Ma Yahweh te liliua na boro ni horara nia na ara sule, ge mamaha na borona na horara. ");
INSERT INTO nlg_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kakeri vaho ge ra sakutua halavu tana pari mamaha na vure ni Israel/Jew, mana buabualalo ni tahi te vagha na voko levu mi levu na bona tara liu halavu iga. ");
INSERT INTO nlg_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ma Pharaoh ma rahei tara haghelighi nina lei horse, maia na lei malaghai tara taghaoi na lei taitakiro, tara taonia na bona tara liu halavu iga rana Israel/Jew. ");
INSERT INTO nlg_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Me roropo ghana, Yahweh te righi horura mai tatana na ghobaghuli ma lapilapi ni lake, me righira na lei malaghai ni Egypt. Keri ge nera ge kara mua ghilala na hava kara nea. ");
INSERT INTO nlg_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ma gaia te nera na taitakironi didira na taitakiro tara moghomogho/kauli, mara mua tangomana ge kara taviru. Mana lei malaghai ni Egypt tara bosa heghedira, “Ighita ka tona sanira na vure ni Israel/Jew! Yahweh te veitotoghoni vanira rana Israel/Jew pungisighita.” ");
INSERT INTO nlg_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Mi tana bona tara halavu soko na vure ni Israel/Jew tana horara, Yahweh te bosa vania Moses, “Ko ghoi hau datoa na limamu vuvungana na tahi, ge ke ghoi oli, me ke sarora na lei malaghai ni Egypt, kolui nia na taitakirodira.” ");
INSERT INTO nlg_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mi tana bona te sogha dato mai na hina, Moses te ghoi hau datoa na limana vuvungana na tahi, mana tahi te ghoi oli tana malana. Na lei malaghai ni Egypt tara tabotabo ge kara sogha/ghogho ke, hauva Yahweh te ghoi nia hevei na tave ni tahi te sule me gharilaghira na lei malaghai ni Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mana tahi te sarora na lei taitakiro mana lei malaghai ni Egypt, me mate sokora. Taho tua hei ke vola. ");
INSERT INTO nlg_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Hauva na vure ni Israel/Jew tara sakutua halavu tana pari mamaha, mana buabualalo ni tahi te vagha na voko levu mi levu. ");
INSERT INTO nlg_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tana bongi keri, Yahweh te vavolara na vure ni Israel/Jew itadira na lei malaghai ni Egypt, ma gaira tara righighi na hulidira na vure ni Egypt tara lelebo mara sonilongai tana saghalea. ");
INSERT INTO nlg_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mi tana bona na vure ni Israel/Jew tara righikalea nina maana Yahweh, gaira nia kikinima mara holohaba mara taluutunia Yahweh, maia Moses nina tinoni ni lutu. ");
INSERT INTO nlg_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moses mana vure ni Israel/Jew tara lingea vania Yahweh na linge eni, “Inau ku linge vania Yahweh, na pukuna te lagavule, me sonihorura na lei horse maia rahei tara haghelighi tana tahi! ");
INSERT INTO nlg_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh te vaheu na laga, mu ku linge na pukuna gaia; Gaia ahei te vavolau. Gaia nigua na God, mu ku holohabaa, ma gaia ghua nina God a tamagu, mi nau ku nia kikinimaa. ");
INSERT INTO nlg_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh na mane laga ni veitotoghoni/malaghai; Yahweh na ahana. ");
INSERT INTO nlg_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Lei nina malaghai Pharaoh, maia nina lei taitakiro, gaia te lulumi lokani tahi; Maia nina malaghai nagho, tara lulumi ghua ilokana na Tahi Sisi. ");
INSERT INTO nlg_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Na tahi lalo te saro horura; mara lulumi horu vagha na vatu tana boro ni horara. ");
INSERT INTO nlg_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yahweh, na lima madolomu te loghoa na maana mana rongoragha. Yahweh, na lima madolomu te goti sodusodui na hulidira na levunimate. ");
INSERT INTO nlg_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ta nimua na maana te haeharegha, go sonihorura nia arahei tara pungisigho. Mo rutu papara vanira, go dikalara vagha na buburu mamaha te ghani taghalaghighi na lake. ");
INSERT INTO nlg_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sakai na hola ghuri vamua ighoe, me tuvavoka na tahi; Rua na levu vagha na peo vatu, mana borona ipari te vunga dato mai me mamaha. ");
INSERT INTO nlg_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mana ghamami na levunimate tara bosa, “Ka ghuru taonira ma ka lotira, ma ka matera. Ma ka hola na isi ni kisumate, ma ka lagavulera. Ma ka tuvalighi didira na lologho, ma ka hola kehaa na hava ta liona. ");
INSERT INTO nlg_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Hauva ma nimiua na hola ghuri va vamua itadira, mana tahi te kakovo savura; Mara lulumi horu tana tahi, vagha na talihalo. ");
INSERT INTO nlg_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yahweh, itadira didira lei titinoni god, taho siki god vaghagho. Ighoe to rongoragha mo tabu, mo laga vulera va gaira, Mana lei tinoni kara nia kikinimaa ma kara holohabagho, na pukuna mo gonighi na lei butuli te haeharegha. ");
INSERT INTO nlg_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mo hau datoa na lima madolomu, mana maramana te sonomira na ghamami na levunimate. ");
INSERT INTO nlg_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ma nia nimua na dolo, ko hulira nimua na vure to huiolira; Mo ko hulira nia na lagamu, va saravia na komu tabu to ghaha iga. ");
INSERT INTO nlg_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Na vure tana lei komu/butonikomu kara mataghu tatata, tana bona kara rongovia na tutugu eni; Na vure ni Philistia kara mataghu ghua. ");
INSERT INTO nlg_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Na lei mane nagho ni Edom kara mataghu, maia na lei mane laga ni Moab kara tatata, mara rahei tara ghahara i Canaan ke sivi na liomalaghai, ");
INSERT INTO nlg_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Na mataghu te sule ke sodora. Yahweh, na pukuna nimua na maana te sule, gaira kara sopou beto vagha vamua na vatu, ritini nimua na vure kara alualu liupadi tadira, ritini na vure to huiolira tana kabu pipiti kara liupadi tadira. ");
INSERT INTO nlg_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yahweh, ighoe ko lavira mai, mo ko kapurira tana nimua na ghotu, na ghotu/bona to vilia ge ko kabu iga, na bona tabu to kisua. ");
INSERT INTO nlg_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahweh, ighoe vamua ko vunaghi pungisi ke va me va. ");
INSERT INTO nlg_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tana bona Pharaoh ma rahei tara haghelighi nina lei horse, maia na lei malaghai tara taghaoi na lei taitakiro, tara sama gatu tana tahi, Yahweh te olivaghinia na tahi me kakovo savura. Hauva rana vure ni Israel/Jew tara sakutua halavu tana pari mamaha. ");
INSERT INTO nlg_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ma Miriam, na vaivine tughunilada/prophet, vaivinena Aaron, maia na balu vaivine tara gonighi na balu velesamu, ra linge mara ghavaighi na lei velesamu. ");
INSERT INTO nlg_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ma Miriam te lingea na linge eni, “Kau linge vania Yahweh, na pukuna te lagavule, me sonihorura na lei horse maia rahei tara haghelighi tana tahi!” ");
INSERT INTO nlg_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ma Moses te idevira na vure ni Israel/Jew sania na Tahi Sisi, mara sakutua va tana bona mamaha tara holoa nia Shur. E tolu na bongi tara mua sodoa siki beti. ");
INSERT INTO nlg_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mi tana bona tara mai sara i Marah, iani tara sodoa na beti, hauva mara mua inuvia na pukuna te mali na beti vaghaa. Keri ge ra holoa nia na bona Marah. ");
INSERT INTO nlg_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mana vure tara bosa hughuhughu vania Moses, ra ghaghua, “Na hava kai inuvia?” ");
INSERT INTO nlg_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ma Moses te ngangaraha vania Yahweh ge ke hanga. Ma Yahweh te tatea vania sakai na ghai. Moses te hola na ghai me sonihaghea ilokana na beti, mana beti te uto na inuviana. Iani tua te hera na balu vetena Yahweh, me tabotabora ge kara taonighi ge kara tatea didira na ghanaghana mava itatana. ");
INSERT INTO nlg_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ge bosa vanira, ‘Inau Yahweh nimiu na God! Ma ge kau rongovia na bosagu, ma kau goni vamua na hava te uto tana matana, ma kau taonighi lei nigua na vetena ke, ku mua toroghau nia siki sosodo te vagha tu nia vetena vanira na vure ni Egypt, na pukuna inau Yahweh tu volaghau.” ");
INSERT INTO nlg_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mara sania Marah, mara mai sara tana bona tara vatua nia Elim. Tara ghahai ga hangavulu rua na vulavula/vuravura ni beti, me vitu hangavulu ni oil palm. Iani tara taludatoi na vale tapoledira lilighini ni beti. ");
INSERT INTO nlg_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Rana Israel/Jew udolu tara sania Elim, mara mai saravia na bona mamaha tara holoa nia Sin, ighobuna Elim ma Ghotu Sinai. Tara saravia tana hangavulu lima na bongi ilokana eruani na vula, imurina na vure ni Israel/Jew tara sania Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mi tana bona tara kabu tana bona eni, gaira tara hughuhughu kolura Moses ma Aaron, ");
INSERT INTO nlg_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","mara ghaghua, “E uto vanighai vaa ge Yahweh ke labumateghai tana bona tai kabu mua i Egypt. Me subo so na lei vinahi mana berete tai ghanighi tana bona tai kabu iga. Mi roghau toro holaghai mai tana bona mamaha eni, kai nia mate na guluva mana vitolo tana bona eni!” ");
INSERT INTO nlg_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ma Yahweh te bosa vania Moses, “Inau ku nia hevei vanighau mai na vanga tana parako vagha na uha ge kau ghanighi tughu dani. Ighau udolu kau tona ma kau vahighi na vanga manana sakai na dani. Mi ani vaho ge ku righi vaughilaladira arahei tara taotaonia na bosagu pe taho. ");
INSERT INTO nlg_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tana ononi na bongi kau vahikolui na vanga te manana rua na bongi ilokana lei sopa dani, mara gonighi ge kara vanga.” ");
INSERT INTO nlg_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Keri ke, Moses ma Aaron toro bosa vanira na vure ni Israel, moro ghaghua, “Tana nulavi vaho ge kau ghilala a Yahweh sughua te lavihorughau mai Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Mi ropo kau righia nina rongoragha mana lada Yahweh, na pukuna te rongovia tua nimiu bosa ni hughuhughu, tau diua na bosana Yahweh, mua iroghai tau diughai.” ");
INSERT INTO nlg_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ma Moses te bosa ghua, “Ma Yahweh ke nia hevei na vinahi ni maumanu, ge kau ghanighi tana lei nulavi, mana berete tana roropo, na pukuna te rongovi udolui nimiu na bosa ni hughuana. Eo, nimiu na bosa ni hughu ke, te diua Yahweh, mua roghai.” ");
INSERT INTO nlg_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ma Moses te bosa vania Aaron, “Ko bosa vanira na vure udolu ni Israel/Jew te vagha eni, ‘kau mai tatana Yahweh ma kau rongovia na bosa tughuni nimiu na bosa ni hughu.’” ");
INSERT INTO nlg_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mi tana bona Aaron te bosa vanira mua na vure, mara rei va mua tana bona mamaha ka, ra righi datoa nina rongoragha Yahweh te marara mai lokana na ghobaghuli/parako. ");
INSERT INTO nlg_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ma Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Na vure kiri tara hughu, mu rongovighi tua didira kokokoe, mo ko bosa vanira, ‘Taeni, tana nulavi kau loghoa na vinahi ge kau ghanighi, mi ropo roropo ke subo na berete kau ghanighi te vagha tau liona. Ge kau ghilala inau sughua Yahweh nimiu na God!’” ");
INSERT INTO nlg_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Me nulavi mua ka, e subo ngangata na manu, tara holoa nia quail, tara tate mai, mara saro udolua na bona tara ghahara iga. Mi tana roropo, na kebu tana bongi te vonughi kolilia na bona keri tara ghahara iga. ");
INSERT INTO nlg_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mi tana bona na kebu te mamaha, na totobo te reirei vagha na vuru ni igha te saro udolua na bona tara ghahara iga, e pile na reireini me malumu vamua ge kara tagoti. ");
INSERT INTO nlg_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tana bona na vure ni Israel/Jew tara righighi, tara mua righi vaughilalani na hava na totobo keri, mara huati olira heghedira, “Na hava ka na totobo keri?” Ma Moses te bosa vanira, “Gaighi ini na vanga Yahweh te nighi hevei vanighau mai ge kau ghanighi. ");
INSERT INTO nlg_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Aeni na hava Yahweh te bosaa, ‘Sopa itamiu kara vahikolui na vanga te manamiu kau ghanighi, te manana sakai na lobo pile tughu tinoni.’” ");
INSERT INTO nlg_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Keri ge na vure subo tara goni taoni na hava te bosaa vanira nia Moses. Balu tinoni tara vahikolui te subo, ma balu te mua subo. ");
INSERT INTO nlg_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Hauva tana bona tara kagei, arahei tara vahikolui subo te mua loghoa siki te au, ma rahei tara vahikolui mua subo te loghoi na manadira mate na vanga kara ghanighi. Sopa tinoni te vahikolui na hava te manana. ");
INSERT INTO nlg_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ma Moses te ghoi bosa vanira, “Kau bei taluolia siki pile vanga tau ghani sanighi ge ke taporasa kuvighi.” ");
INSERT INTO nlg_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Hauva balu itadira tara mua taonia, ra taluolighi so na balu me taporasa kuvighi. Mi tana roropoghana mai ka, ra righighi na vanga te perigha me uru dikani. Ma Moses te rutu vanira. ");
INSERT INTO nlg_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tana tughu roropo, sopa tinoni te vahikolui na vanga te manana, mana vanga te mua vahikolui tara obo keha tana bona te papara na hina. ");
INSERT INTO nlg_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mi tana ononi na bongi, na vure tara vahikolui na vanga te kaekage ge kara ghanighi rua na bongi te manana rua na lobo pile tughu tinoni. Mana lei mane naghodira tara mai tughunia na totobo eni vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ma Moses te bosa vanira, “Aeni na hava Yahweh te bosa, ‘I ropo ke, na Sabbath, na bongi ni aheahe. Mana bongi eni ke, na bongi ge kau holohabau. Keri ke, na vanga ni valei ghaniani taeni kau kukighi pa kau bitighi. Mana levuni te ghaha olighi, kau talugonighi vania iropo.’” ");
INSERT INTO nlg_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mana vure tara taluolighi na levuni na vanga vania iropo, mana vanga kiri tara mua perigha mara mua mabulu. ");
INSERT INTO nlg_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ma Moses te bosa vanira, “Kau ghani sokoi tua na lei vanga ini taeni, na pukuna itaeni ke, na Sabbath, na bongi ni aheahe ka holohabaa iga Yahweh. Mana pukuna keri, gau mua sodoa siki vanga i paribebete. ");
INSERT INTO nlg_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mi tana ononi na bongi lokana tughu week, kau vahikolui na vanga. Mi tana vituni na bongi, na bongi ni aheahe, kau mua lutu iga, ma kau mua sodoa siki vanga ivuvungana ni pari. ");
INSERT INTO nlg_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Sakai vamua Moses te bosa te vagha keri ke, na balu tadira tara rughuhoru ni va kene vania, mara mua sodoa siki vanga. ");
INSERT INTO nlg_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ma Yahweh te bosa vania Moses, “Ivei tea na vure kiri mua liona na taoniani lei nigua na vetena mana tarai. ");
INSERT INTO nlg_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kau ghanaghana kalea inau, Yahweh, tu nia hevei na bongi ni aheahe. Keri ke, tana ononi na bongi tu vaheghau iga na vanga te manana rua na bongi. Me vituni na bongi, kau sopa kabu beto vamua tana sopa valemiu, ge kau mua lutua iga siki lutu.” ");
INSERT INTO nlg_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Keri vaho, na vure tara aheahe e vituni na bongi. ");
INSERT INTO nlg_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Na vure ni Israel/Jew tara holoa nia manna na vanga eni. Me pura na reireina, me vaghai na vuavua tara holoa nia coriander, me manilu vaghai na biscuit tara gonia nia na midua. ");
INSERT INTO nlg_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses te ghoi bosa vanira so, “Aeni na hava Yahweh te bosa, ‘Kau talugonighi na balu manna te manana erua na litre vanira nimiu na vaivarimiu. Keri ge kara tangomana ra righia na berete inau tu vaheghau tana bona mamaha, tana bona tu lavihorughau mai Egypt.’” ");
INSERT INTO nlg_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ma Moses te bosa vania Aaron, “Ko hola sakai na botolo/borore mo ko hoghoni vonua nia na manna te kaekagena erua na litre, mo ko talugoni utoa tana bona te ghaha iga Yahweh, keri ge na vaivarimiu kara vaevanea. ");
INSERT INTO nlg_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ma Aaron te goni taonia na hava Yahweh te bosaa vania nia Moses. Hola na botolo talui na manna ilokana, me va talua tana na Bokisi ni Vetena ni Baubahu tabu. ");
INSERT INTO nlg_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mana vure ni Israel/Jew tara ghania na manna e vati hangavulu na niulu koekobe ra mai sara tana komu/butonikomu i Canaan. ");
INSERT INTO nlg_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Sakai na ephah te kaekage hangavulu na lobo pile.) ");
INSERT INTO nlg_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ma gaira rana Israel tara ghoi rughuhoru sania na bona mamaha i Sin. Ra mua sopou ta sakai na bona, ra gharadu kolili vamua te vagha te bosa vanira Yahweh. Mi tana bona tara mai sara i Rephidim, vaho gera taludatoi na vale tapoledira, mana bona keri te taho iga na beti. ");
INSERT INTO nlg_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ma gaira tara vuivuni ni kokokoe hughuhughu koluana Moses mara vania, “Ighai tai haga inu ngangata tua, ko vaheghai mai na beti.” Ma Moses te bosa tughu vanira, “Ivei tea gau kokokoe hughuhughu te vagha eni gau liona na taboana nina maana Yahweh?” ");
INSERT INTO nlg_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Hauva na vure tara haga inuvia ngangata, ge kara bosa hughuhughu ghua vania Moses, “Ivei tea go hola horughau mai Egypt? Ighai kolura na lei dalemami, maia lei nimami na maumanu geva kai mate iani!” ");
INSERT INTO nlg_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ma Moses te nongi kukuruti vania Yahweh, “Na hava ku nea vanira na vure ini? Ra dutu ni petaagu nia na vatu.” ");
INSERT INTO nlg_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ma Yahweh te bosa vania Moses, “Ko hola na totoghonamu, to labu vokasia na beti tina Nile. Ko holora na balu mane nagho kara idevira na vure subo. ");
INSERT INTO nlg_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mi nau ku sodogho lilighina na vatu tana ghotu Sinai. Ko labua na vatu, mana beti ke horu mai ga, ma kara inu iga na vure.” Moses te goni taonia vamua na hava Yahweh te bosa vania. Mi tana bona na lei mane nagho tara reirei, na beti te doedore horu mai. ");
INSERT INTO nlg_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ma Moses te holoa nia Meribah mi Massah na bona keri, na pukuna iga na vure tara kokokoe hughuhughu koluana Moses mara tabotabo nina maana Yahweh tara ghaghua, “Ke hangaghita sughua Yahweh, pe ke taho?” ");
INSERT INTO nlg_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tana bona na vure ni Israel/Jew tara ghahara mua Rephidim, na lei malaghai ni Amalek tara mai mara veitotoghoni kolura. ");
INSERT INTO nlg_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ma Moses te bosa vania Joshua, “Ko vilira na lei mane ni veitotoghoni, ma kara veitotoghoni kolura rana Amalek i ropo. Inau ku tughuru kouna na ghotu, kolua nia na totoghona God tana limagu.” ");
INSERT INTO nlg_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ma Joshua te goni taonia na hava te bosa Moses, me idevira na lei mane kisumate ge kara veitotoghoni kolura rana Amalek. Moses kolura Aaron ma Hur tara dato kouna na ghotu te dutuvira. ");
INSERT INTO nlg_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tana bona Moses te hau datoa na totoghona nia rua na limana, Joshua kolura na vure/malaghai ni Israel/Jew tara lagavulera rana Amalek. Mete taluhorua mua na limana tana bona teke maghomagho ke, mana levu pala kara ghoi lagavulera Joshua ma nina ovu. ");
INSERT INTO nlg_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mana limana Moses tara maghomagho ngangata me mua malumu vania geke hau datoa, Aaron ma Hur toro ghatea sakai na vatu geke sopou ivuvungana. Ma rogaira toro tughuru levu mi levuna ge koro hau datoa na limana geke bei taluhorui gea. Moro nea vagha eni koekobe te diridiri na hina/aho i boko. ");
INSERT INTO nlg_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mana pukuna keri, Joshua maia nina lei mane kisumate lagavule ngangatara na lei malaghai ni Amalek, me subo ngangata tara mate tua. ");
INSERT INTO nlg_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ma Yahweh te bosa vania Moses, “Ko gere horua na tutuguna na kisumate eni, kara bei nei ponolio gea na vure. Mo ko bosa vania Joshua, ‘Tu mate sokora tua na taba ni vurena Amalek, me taho ahei tana maramana ke ghoi ghanaghanara.’” ");
INSERT INTO nlg_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ma Moses te kisua na bela ni sukaghi tana bona ni pari vaghana keri, ge holoa nia, “Yahweh nigua na vaughilala ni lagavule!” ");
INSERT INTO nlg_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ge bosa, “Ra hau datoi na limadira ge kara batobatoa Yahweh. Ma Yahweh ke tona haliu so na kisumate koluadira na taba ni vurena Amalek tana lei vavatadira!” ");
INSERT INTO nlg_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A Jethro, na mane sukaghi ni Midian, gaia na vungona Moses, te rongovighi nia na lei haeharegha God te nea vania Moses mana vure ni Israel/Jew tana bona Yahweh te lavihorura i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mi naghona eni, Moses te nia vetena oli Zipporah tauna maia rua na dalena ge kara va kabu kolua Jethro na vungona. ");
INSERT INTO nlg_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Na ahana na kamanagho dalena ke Gershom. E vatua nia na pukuna na bona te sivuragha na gari ke, Moses te bosa, “Inau tu sinogho haghe mai lokana na bona eni.” ");
INSERT INTO nlg_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Na ahana na ruani dalena ke, Eliezer, na pukuna na bona te sivuragha na gari eni, Moses te bosaa, “God tamagu, ighoe nigua na hahanga, o lavikehau tana mangana nina ivi Pharaoh.” ");
INSERT INTO nlg_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro te mai kaoa Moses, me lavira mai tauna Moses me rua dalena. Ra saravia Moses kolura na vure tana bona tara kabu lilighina nina ghotu God. ");
INSERT INTO nlg_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethro te nia vetena na rongorongo ta Moses, “Inau Jethro na vungomu te mai kaogho. Na taumu ma rua na dalemu tara mai koluu.” ");
INSERT INTO nlg_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses te rughuhoru mai tana valena, me va sodoa vungona, e malu horua na uluna te tatea iga nina holopangoti, vaho ge nonginongia. Ro sopa bosabosaa ivei tea na sopa voladira, moro tabe lima, soko vaho gera haghe tana vale tapolena Moses. ");
INSERT INTO nlg_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses te tutuguni vania Jethro nia na lei totobo Yahweh te gonia vanira Pharaoh mana vure ni Egypt. Me bosa vanira ghua so tara rughupota na vahola te nea na hangadira righitaoniadira kulana vure ni Israel/Jew. Me bosa vania ghua so tara rughu pota na vahola te nea na hangadira tana halautu. ");
INSERT INTO nlg_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro te togotogo ngangata ta rongovighi na tutugu ivei te nea na hangadira God rana Israel/Jew te lavihorura mai Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Me bosa, “Holoutoa Yahweh te vavolaghau itadira na vure ni Egypt mana Pharaoh. Gaia te volaghau tana nina maana Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Vaho ge u ghilala a Yahweh te haba vulera na lei god, na pukuna nina vure tara tona sania didira na talunagho mana ghighirou na vure ni Egypt.” ");
INSERT INTO nlg_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Keri ke Jethro te holai na maumanu me matea geke nia sukaghi vania God, me sukaghi ghua na balu sukaghi keha. Mi tana bona te gonia eni, Aaron mana balu mane naghodira rana Israel/Jew tara horu mai, mara mai righia na vungona Moses, na ghani koukoluana na hava te nia sukaghi tana matana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mi ropo Moses te vagha haia te nea, gaia te sopou me rongovighi didira na kokokoe hughuhughu na vure. Ra tughuru maemane talighutia, vuivuni tana puipungi/roropo me sara tana huu ni aho/hina. ");
INSERT INTO nlg_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ma vungona te righia na hava te gonia vanira na vure, ge bosa vania, “Na hava te gonia vanira na vure ini? ivei tea ge ighoe heghemu to sopou mo detera na vure ini tara sopou talighutigho vuivuni tana roropo/puipungi me sara tana nulavi?” ");
INSERT INTO nlg_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ma Moses te bosa tughu vania, “Na vure tara mai kenea itagua ivei kara nea na kabu te vagha God te liodira kara ghaghua iga. ");
INSERT INTO nlg_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tana bona ke dato mai na hughu itadira na vure ke, mi nau mughua ku maemanera ta didira na hughuhughu mu bosa tatea vanira nina dete pungisi God, mu taraira nia nina lei vetena mana hava te liona God.” ");
INSERT INTO nlg_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ma Jethro te bosa tughu vania, “Na hava to gonia te mua uto/maemane. ");
INSERT INTO nlg_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ke tona haliu so te vagha eni ke, na vure mi ghoe kau na lugu, na pukuna na lutu eni te sule ngangata ge ko lutua heghemu. ");
INSERT INTO nlg_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Keri ke, me liogu ge ku nia hevei vanigho na balu bosa hahanga, ma God ke kabu haia so itamua. Mi nau tu righia ke, me maemane so ge ko holai didira na kokokoe va ta God, mo ko holai ghua didira na hughuhughu va itatana. ");
INSERT INTO nlg_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ko bosaa vanira nia na hava te liona God, mo ko taraira nia nina vetena. Mo ko tughuni pukupukui vanira na halautu mana hava kara gonia tana voladira. ");
INSERT INTO nlg_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Me uto va ge ko kenera na balu mane uto tara nia kikinima God mara mua dete kulakulagha. Ko vilira ge kara manenaghodira na vure, ma kara manedete ta lei sopa ovu te vuni ta sakai na togha, ma sakai na hangalatu, ma lima hangavulu maia hangavulu. ");
INSERT INTO nlg_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Na lei mane raini kara righitaonira na vure, ma kara maemanei na lei hughuhughu te pile, mana lei ghanaghana te mava me vahola kara holai vanigho mai. Kara tangomana heghedira so ge kara gonighi na lei totobo te pile, ge kara hangagho na holani na hohola te mava keri ge ke malumu vanigho na righitaoni. ");
INSERT INTO nlg_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ma ge toko taonighi na lei bosa hahanga ini ke, me ke huligho God ke, igeva ko loghoa na laga na lutuani na lei vahola itadira na vure, ma kara ghoi oli so tana sopa valedira nia na mabo. ");
INSERT INTO nlg_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses te varongohighi nina lei bosa hahanga vungona ge taonighi. ");
INSERT INTO nlg_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Me vilira lei mane uto tana lei sopa kema ni Israel/Jew, me talura ge kara manedete ghobudira na vure. Na balu kara manenaghodira sakai na togha, na balu sakai na hangalatu na balu lima hangavulu mana balu hangavulu. ");
INSERT INTO nlg_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ma keri ke, na lei mane ini ra lutu vagha rana lei manedete, na maemaneani didira na lei vahola na vure, mana lei vahola sule ke, ra holai vania va Moses. Ma gaira oli heghedira so tara lutui na lei vahola pile. ");
INSERT INTO nlg_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mi murina mua eni ka, Moses te bahua vungona ma Jethro te ghoi oli tana puku ni komuna. ");
INSERT INTO nlg_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Murina tara rughuhoru sania Rephidim, na vure ni Israel tara va saravia na bona mamaha i Sinai, te kaekage rua matapono na vula imurina tara sania Egypt. Gaira tara mai sara tana pukuna na ghotu Sinai, mara taludatoi ga na vale tapoledira. ");
INSERT INTO nlg_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ma Moses te sei dato kouna na ghotu Sinai ge ke va tate heghena vania God. Ma Yahweh te hoholo horua mai kouna na ghotu me vania, “Ko nighi hevei na lei bosa ni tarai ini vanira na vure ni Israel/Jew, na vaivarina/tana kemana Jacob, ");
INSERT INTO nlg_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Au righighi tu na hava tu nea vanira na vure ni Egypt, mau ghilala ghua tua ivei tu nea na lavimiu mai tagua, mu lavighau mai tana komu eni, vagha na manukama te sopou laghinira dalena kouna na ghatana. ");
INSERT INTO nlg_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Me ke vagha kau taonia nigua na bosa ni tarai, ma kau holopangotia nigua na bosa ni baubahu ke, mi ghau kau nigua na vure vivili tadira na balu tinoni/kema tana maramana. Na maramana udolu ke a nigua, ");
INSERT INTO nlg_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mi nau ku neghau ge kau nigua na taba ni vure, ma kau lutu vaghaa nigua na mane sukaghi/gehegehe.’ Ko nia hevei nigua na bosa ni tarai ini vanira na vure ni Israel/Jew.” ");
INSERT INTO nlg_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ma Moses te sughi horu mai tana ghotu me holo kolura na lei mane naghodira na vure ni Israel/Jew, me bosai vanira na hava God te bosai vania. ");
INSERT INTO nlg_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mana vure udolu tara bosa sakai sonikolu mara ghaghua, “Kai goni taonia na hava Yahweh te liomami ge kai nei.” Ma Moses te hola olighi didira na kokokoe na vure va ta Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Keri ke, Yahweh te ghoi bosa so vania Moses, “Inau ku mai tamua ilokana na pui/ghobaghuli sule ge kara rongo heghedira na vure tana bona ku kokoe vanigho, ge kara loghoa na ghanaghana mava haia ivuvungamu.” Ma Moses te hola olighi didira na lei kokokoe na vure va ta Yahweh, ");
INSERT INTO nlg_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ma Yahweh te bosa vania Moses, “Ko oli tadira na vure mo ko gonidilara ta nigua na kao. Ko va tabura taeni mi ropo mo ko bosa vanira kara apoi na tivi ge kara mai holohabaagu. ");
INSERT INTO nlg_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kara gonidila tana toluni na bongi/valiha, mi nau ku horu mai tana bongi keri kouna na ghotu Sinai, tana matadira na vure subo. ");
INSERT INTO nlg_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ko talu kobekobe talighutia na ghotu, mo ko bosatate vanira kara bei dato mai gea tana ghotu pa kara via na pukuna na ghotu, ma hei ke diua ke, kau matea mughua. ");
INSERT INTO nlg_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Taho siki sakai ke tabea na tinoni eni. Kau peta matea nia na vatu, pa kau vanahia nia na kuali. Ke vagha na mane pana maumanu ke, ge kau matea mughua. Hauva, mi tana bona kara rongovia na tangina na tavuli ke, keri vaho ge kara mai tana ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ma Moses te sughihoru, me va saravira na vure, ge bosa vanira ge kara gonidila heghedira ge kara holohabaa Yahweh. Keri ge kara apoi didira na tivi. ");
INSERT INTO nlg_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ma Moses te bosa vanira, “Kau gonidilaghau vania na valiha/toluni na bongi, ma kau bei maturu kolura taumiu, koekobe ke saravia na bona vaghana keri.” ");
INSERT INTO nlg_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mi tana valiha/toluni na bongi roropo/puipungi, na viviha ragiragi ma viti te sule, mana pui/ghoghopa/ghobaghuli te saroa kouna na ghotu. Ma tangina na tavuli te daro ngangata, mana vure subo tara tatata tara righighi mara rongovighi na lei vaughilala ini. ");
INSERT INTO nlg_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mi murina eni, Moses te hola horura na vure tana bona tara sopou iga, ge kara va topoa God, ma kara kabu vamua tana pukuna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Na ghotu Sinai te saro udolua na ahu, na pukuna Yahweh te horu mai vuvungana tana vaughilala ni lake. Na ahu te maemane poito dato tana oka vagha na ahuna na lake sule, mana ghotu te anuanu vagha na anu sule te anuanua. ");
INSERT INTO nlg_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mana tangina na tavuli te sule vulea te nea iga na tangina haia, Moses te kokokoe, ma God te bosa tughu vania ilokana viviha ragiragi. ");
INSERT INTO nlg_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ma Yahweh te horu mai kouna na ghotu, me holoa Moses ge ke dato tana ghotu. Ma Moses te sei dato me va sodoa Yahweh kouna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ma Yahweh te bosa vania Moses, “Ko oli horu mo ko ladavaghinia vanira na vure kara bei sogha halavui gea na lei kobekobe, ma kara bei dato mai ghua iani na righiagu. Ma rahei kara diua, ku mate. ");
INSERT INTO nlg_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Na lei mane gehegehe vamua kara mai vaniu, hauva kara diki marabura heghedira mughua, me ke taho ke, mi nau ku torora.” ");
INSERT INTO nlg_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ma Moses te bosa vania Yahweh, “Na vure ini kara mua tangomana na dato gatu tana ghotu Sinai na pukuna ighoe heghemu to bosa vanighai nia tua ke, ma kai talua na lei kobekobe talighutiana na ghotu ma kara va tabua.” ");
INSERT INTO nlg_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma Yahweh te bosa tughu, “E uto so, mo ko ghoi horu holaa kolugho nia mai Aaron tana bona eni. Hauva mo ko bei lubatira na lei mane gehegehe pana vure subo kara sogha halavui na lei kobekobe ma kara dato mai iani tagua. Ma kara dato mai ke, igeva ke kalera na totoro.” ");
INSERT INTO nlg_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ma Moses te sughi horu me va sodora na vure subo me bosa vanira nia na hava Yahweh te bosaa. ");
INSERT INTO nlg_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ma God te nia hevei vanira na vure na lei bosa ni tarai ini, ");
INSERT INTO nlg_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Inau Yahweh, nimiu na God, to hola horughau mai tana kabu pipiti i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kau bei holohabaa siki god keha. Kau holohabau inau vamua. ");
INSERT INTO nlg_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kau bei saria siki titinoni tana reirei ni siki totobo tana oka, pana siki totobo tana maramana/ pari pana siki totobo tana tahi. ");
INSERT INTO nlg_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ma kau bei tongavi vania siki god keha mau holohabaa, na pukuna inau vamua Yahweh, nimiu na God, ma kau holohabau mughua inau vamua. Arahei tara diua na bosagu mara niu sika, inau ku torora kolura nia daledira maia kukuadira me ke saravia na dodoedira. ");
INSERT INTO nlg_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ma rahei tara doloviu mara taonighi nigua na vetena, inau ku dolovira ritini tana togha ni vavata ni tinoni tara mai muridira. ");
INSERT INTO nlg_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Kau bei bosa taboa na ahagu, na pukuna inau, Yahweh nimiu na God ku tangotoroa ahei ke bosa taboa na ahagu. ");
INSERT INTO nlg_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Kau ghanaghana mavaa na Sabbath, ma kau va tabua. ");
INSERT INTO nlg_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","E ono na bongi ni lutu kau lutui ga nimiu na lei lutu. ");
INSERT INTO nlg_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Me vituni na bongi, na Sabbath, ma kau va tabua. Tana bongi vaghana keri, kau bei lutu siki nimiu na lutu iga. Ighau, dalemiu na mane mana vaivine, maia nimiu na tinoni lutu/ghairau na mane mana vaivine, nimiu na maumanu maia siki sinogho te kabukolughau. ");
INSERT INTO nlg_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","E ono na bongi, inau, Yahweh, te gonia na kokou mana maramana, na tahi, mana lei totobo soko ilokani/ilokadira, mu aheahe e vituni na bongi. Mana pukuna keri inau, Yahweh, tu va tabua e vituni na bongi, me talu tabalilia heghegu ge ke tabu. ");
INSERT INTO nlg_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kau nira kikinima tamamiu ma tinamiu, ge ke daro na bongimiu tana komu/butonikomu te vaheghau inau, Yahweh nimiu na God. ");
INSERT INTO nlg_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kau bei labumate tinoni. ");
INSERT INTO nlg_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kau bei ngelengele. ");
INSERT INTO nlg_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kau bei gito. ");
INSERT INTO nlg_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kau bei tutugu sorisori na ghamiu na komukolu. ");
INSERT INTO nlg_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kau bei nia vevehe na valena na ghamiu na komukolu, tauna, pa nina tinoni lutu/ghairau na mane pana vaivine, pa nina maumanu, pana hava tua te loghoa/lologho.” ");
INSERT INTO nlg_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tana bona na vure tara rongovia na tagumuna na viviha ragiragi, maia na talama ni uvete/tangina na tavuli, maia tara righia na viti mana ahu te saroa kouna na ghotu, na vure tara mataghu mara tatata mara mua tughuru dutuvia na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mara bosa vania Moses, “Ko bosa vanighai heghemu, ma kai varongohigho. Hauva ighai tai mataghu ma ge/ke vagha God ke bosa vanighai ke, ighai kai mate! ");
INSERT INTO nlg_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ma Moses te bosa vanira, “Kau bei mataghu gea. God ke mai vagha eni ge ke tatea iga nina maana, keri ge kau talumavaa haia, ma kau bei gonia gea siki hahi/palugha/tangohahi!” ");
INSERT INTO nlg_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Hauva na vure tara tughuru sagau, ma Moses heghena vamua te va dutuvia na ghobaghuli te pungi te ghaha God. ");
INSERT INTO nlg_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ma Yahweh te bosa vania Moses, “Ko bosa vanira na vure ni Israel/Jew, ‘Ighau heghemiu tau rongoviu mau ghilala tu kokokoe vanighau mai kokou. ");
INSERT INTO nlg_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kau bei saria siki titinoni god keha nia na silver pana gold, ma kau holohabara gea te vagha tau nea iga na holohabau inau. ");
INSERT INTO nlg_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kau kisua nigua na bela ni sukaghi nia na pari, ma kau sukaghighi vaniu iga nimiu na sheep mana goat mana buluka - na lei sukaghi ge kau kerei, mana lei sukaghi ge kau hevei ma kau kabu mabo kolura rana vure. Mi tana sopa bona ku vilia ge kau holohabau inau keri/iga, inau ku mai vanighau mu ku vautoghau. ");
INSERT INTO nlg_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ma ge kau gonia na bela ni sukaghi nia na vatu ke, kau nia lutu vamua na vatu tau mua saria. Kau bei sodui pa ka kau sarighi nia na halo, na pukuna ke nea gea me ke mua ulaghana na vatei lutu tabu. ");
INSERT INTO nlg_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kau bei talu malei tuturini/palapala nigua na bela ni sukaghi na vatei tete dato. Kau nea so ke, mi tana bona kau sei dato iga ke, igeva kara righia vamua sarana nimiu na tivi ma kara righighau tau soesole.” ");
INSERT INTO nlg_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ma Yahweh te ghoi bosa vania Moses, “Raini gaighi na balu vetena ko vahera na vure ma kara taonighi. ");
INSERT INTO nlg_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ma ge kau pelua na seka tana taba ni vure ni Israel/Jew, ke lutuvagha na seka vamua e ono na niulu. Ma kau lubatia me ke tona tatavahale e vituni na niulu, me mua pelughau siki rongo. ");
INSERT INTO nlg_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ke vagha na tinoni ke mua taulaghi tana bona ke seka me ke tauna imurina ke, gaia heghena vamua ke rughuhoru. Mi tana bona te mai me ke taulaghi tua ke, me ke va saravia na bona na vunaghina ke lubatia ke, gaia ma tauna koro rughuhoru tatavahale. ");
INSERT INTO nlg_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ma ge na vunaghina ke vahea tauna tana bona te seka mo koro logho daledira, na mane vamua ke rughuhoru tana seka e vituni na niulu. Na tauna ma dalena kara nia seka so na vunaghina. ");
INSERT INTO nlg_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Hauva, ma ge na seka te rughuhoru ke baubahu vania na vunaghina me ke ghaghua, “Inau tu dolovia na vunaghina, taugu, ma rana dalegu, me uto va ge ku mua rughuhoru tatavahale.” ");
INSERT INTO nlg_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Keri ge na vunaghina ke talutatea vania God. Me ke lavia va tana mataula me ke potaa na kulina nia na nila tana matadira na vure subo, vaho na seka keri ke nina na vunaghina tana bongi ni volana. ");
INSERT INTO nlg_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ma ge na mane ke nia hunulu dalena na vaivine vania hei ke, na vaivine keri ke mua rughuhoru sania na seka tana sosokona ono na niulu tara ghaghua iga na lei mane. ");
INSERT INTO nlg_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ke vagha na vaivine ke mua togotogona na mane te pelua ge ke tauna ke, ge ke ghoi nia hunulu olia tana tamana. Me ke mua nia hunulu vania ahei te sinogho haghe mai, na pukuna gaia te diua nina talamaghi mai tatana. ");
INSERT INTO nlg_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ma ge na vunaghina na seka vaivine ke padapada kolua me ke tauna dalena na mane, ke mua ghoi nea te vagha na seka, ke nea vagha na dalena vaivine. ");
INSERT INTO nlg_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ma ge na vunaghina heghena ke tauna so, mi geva ke tauna eruani vaivine ke, ke kuti utoa me ke vahea na tivi na diki tauna, me ke nia maturukolu te nea mai ga na vauvaluni mai. ");
INSERT INTO nlg_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ke vagha na vunaghina ke mua goni taonighi vania e tolu na ghanaghana ini ke, na vaivine keri ke rughuhoru tatavahale me ke mua pelua siki rongo vania. ");
INSERT INTO nlg_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Na tinoni ke labu dikalaa siki sakai me ke mate ke, kau labumatea ghua na tinoni keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ma ge na tinoni vaghana keri ke mua ghanaghana ge ke labumatea siki sakai, gaia ke sogha tana siki komu ku vilia vanighau, ge ke kabu tatavahale tana komu keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ma ge siki tinoni ke talugonia na ghanaghana ni mateana siki sakai tana liona, sakai vamua ke sama me ke mai polo ta nigua na bela ni sukaghi, kau hola horua ma kau labumatea. ");
INSERT INTO nlg_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Siki sakai ke labu dikalaa tinana pa tamana, kau labumatea ghua. ");
INSERT INTO nlg_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ma hei ke gitoa siki tinoni sakai vamua te nia hunulu vagha na seka, pe ke talugonia so itatana, kau labumatea na tinoni keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ma hei ke koengelea tinana pa tamana, kau labumatea ghua. ");
INSERT INTO nlg_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Ke vagha erua na tinoni koro veilaulabui, ma sakai rotadira ke peta nia na vatu, pe ke lupi dikalaa nia na limana, me ke mua mate na tinoni keha, kau mua toroa na tinoni keri. Ma gaia te bubuto me ke koli so tana ghimena, mi murina ke nia sakutua na totoghona, na tinoni te nea ge totoghona ke gonia na poroporo ulu vania hoghona, me ke righi taonia koekobe ke ghoi uto pulohi. ");
INSERT INTO nlg_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ma hei ke labua nia na ghai nina seka mane pana seka vaivine, me ke mate tua tana bona te labua ke, kau toroa na tinoni keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Hauva mana seka keri ke mate sakai pe rua na bongi murina te labumatea, kau bei toroa gea na vunaghina, na pukuna e sivilaghinia tua nina seka vagha nina rongo sule. ");
INSERT INTO nlg_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ke vagha na balu tinoni kara veilaulabui koukolu ma kara tupia na vaivine te bohe, me ke suabutoa dalena, me ke mua loghoa siki pae tana hulina, gaia te labua ke poroporo uluna tauna na vaivine. Ma tauna ke nia kukuniti na nongiana na poroporo ulu, mana lei mane huhuli ni komu kara talamaghinia, na tinoni keri pelua tua. ");
INSERT INTO nlg_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Hauva, ke vagha na tinoni keri te dikalaa na vaivine te bohe, na totoro ke kalea ke taonia na hava vaughilala tana hulina na vaivine. Me ke mate ke, ma gaia ghua ke mate. ");
INSERT INTO nlg_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ma sakai na matana ke sivilaghinia ke, mana gaia ghua kara kisi horu keha sakai na matana. Me ke kabilu keha sakai na livona ke, ma gaia ghua kara bilukehaa na livona. Siki limana ke tasodu ke, me ke tasodu ghua na limana gaia, me ke tagoti siki tuana ke, ma gaia ghua kara gotia na tuana. ");
INSERT INTO nlg_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Mana tinoni ke kerea na vaivine tana lake, ma gaia ghua kara kerea tana lake. Na mane ke toka na vaivine, ma gaia ghua kara toka pae. Me ke mua horu diki ghabu itatana ke, me ke ghaghua ghua iga na mane. ");
INSERT INTO nlg_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ke vagha na vunaghina ke labua nina seka mane pana vaivine, me ke dika sakai na matana ke, gaia ke lubati tatavahalea na seka keri, na pukuna na peluna te nea na matana me dika. ");
INSERT INTO nlg_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ke vagha na vunaghina ke tupia nina seka mane pana vaivine me ke kabilu keha siki livona ke, gaia te loghoa ke lubati tatavahale vagha te pelu olia nia na livona te kabilu keha. ");
INSERT INTO nlg_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ke vagha siki buluka mane ke matea siki tinoni, na mane pana vaivine, kara peta matea nia na vatu. Ma kau bei ghania gea na vinahina ma kau bei toroa gea ghua na tinoni te loghoa na buluka keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Hauva mana vure kara ghilalaa na buluka mane eni te asi me ghilala te ghoi dikalaa tinoni, mara talutate haia vania so na tinoni te loghoa me mua talu haghea so tana piluna, mana buluka mane eni te ghoi va matea so siki tinoni mane pana vaivine ke, na buluka mane eni kau peta matea nia na vatu, ma kau matea ghua na tinoni te loghoa. ");
INSERT INTO nlg_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Hauvaa ma ge takara lubatia me ke pelu olia na volana ge ke mua mate, na tinoni te loghoa ke pelu udoluna engiha tara kagea iga na matena. ");
INSERT INTO nlg_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ma ge siki buluka mane eni ke matea siki garimane pa siki gari vaivine/tahula ke, ma gaia so na vetena ia kau nea taonia. ");
INSERT INTO nlg_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ma ge na buluka mane eni ke matea siki seka mane pana seka vaivine, na tinoni te loghoa na buluka mane ke pelui tolu hangavulu ni silver vaa itatana hei te vunaghina na seka kiri, vaho ge kau peta matea na buluka mane keri. ");
INSERT INTO nlg_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ke vagha siki tinoni ke loghoa na tuvu ni beti me ke mua vongotia, pe ke ghelia siki gilu me ke mua pari kuvia, ma siki buluka pana donkey ke tumu haghena ilokana na tuvu ni beti pana gilu, me ke mate ke, ");
INSERT INTO nlg_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","na tinoni eni ke pelua horua na volana va itatana na tinoni te loghoa na maumanu kiri, ma gaia tua ke loghoa na maumanu te mate. ");
INSERT INTO nlg_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ma ge siki buluka mane ke labumatea nina buluka mane siki kulana, rogaira udolu koro nia hunulu na buluka mane te vola, mo koro tuvali kaekagea na mateana tana ghobudira, mo koro tuvalia ghua na vinahina na buluka mane te mate. ");
INSERT INTO nlg_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ma ge kara ghilala tua na vure na buluka mane keri te asi me matamata ngangata me tona haliu so na mateadira na lei maumanu, mana tinoni loghoa te mua talu haghea tana piluna, gaia ke nia hevei sakai na buluka mane te vola, me holaa na buluka mane te mate.” ");
INSERT INTO nlg_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Yahweh te bosa ghua, “Ahei ke gitoa nina buluka pa nina sheep pe ke matea, pe ke nia hunulu vania siki tinoni keha, ke tughu olia na buluka nia e lima na buluka pe ke gitoa na sheep ke, me ke tughua nia vati na sheep, ke tughui nia na sheep te gitoa. ");
INSERT INTO nlg_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Na tinoni te gito eni ke tughu olia mughua na hava te gitoa. Me ke tinoni bona gaia, me mua loghoa siki nina totobo/lologho, kara hola gaia ma kara nia hunulu vaghaa na seka, ma kara hola na matena, ma kara pelu olighi nia hava te gitoi. Ke vagha na na buluka pa na donkey pana sheep, me ke mua matea na hava na maumanu vaghana te gitoa ke, ke nia hevei oli kolua nia erua te vagha keri te gitoa. “Ma ge na tinoni gito ke mai tana tana bongi, me ke haghe tana valena siki tinoni, mana tinoni logho vale ke sodoa me ke labumatea ke, na tinoni logho vale te mua hahi. Hauva ma ge na tinoni gito ke mai tana dani, mana tinoni logho vale ke labumatea ke, me ke mua uto te nea iga hoghona, me manana ge kara tangotoroa. ");
INSERT INTO nlg_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Me ke vagha siki tinoni ke talua nina maumanu ni vatei vanga ta nina leghai haulaghi pa ta nina hughuru ni grep/grape mana maumanu keri ke horu me ke va odai na vangana nina leghai pana hughuru siki tinoni, na tinoni lologho maumanu gaia ke pelu olighi na hava te odai nina maumanu me ke nighi tutughu ne puku ni vanga ta nina leghai pana hughuru vania na tinoni keri. ");
INSERT INTO nlg_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ma siki sakai ke kerea nina leghai, mana lake ke vanga kolili me ke va sodoa na tautalu mamaha te dutuvia nina leghai sakai na tinoni keha, me ke ghanighi na vangana na leghai pe ke va sodoi nina baore te talu kolia, na tinoni te tungia na lake ke tughui na vanga te ghanighi na lake. ");
INSERT INTO nlg_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ma ge siki sakai ghua ke tala na righitaoniani nina seleni pa siki nina puku ni totobo lologho sakai na tinoni, mi murina mai ka, ma siki tinoni keha te mai gitoi na lei totobo kiri, ma kara sodoa hei te gito ke, ke tughu olighi eruani na hava te gitoi. ");
INSERT INTO nlg_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ma kara mua topoa na tinoni te gito ke, kara holaa na tinoni te righitaoniani na lei totobo kiri, ma kara lavia va itadira na vure dete, me ke baubahu vanira tana matagu Yahweh te mua gitoi gaia na lei totobo kiri. ");
INSERT INTO nlg_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Ma ge siki tinoni ke sivilaghinia nina lei totobo/lologho te vaghai na buluka, donkey pana sheep, pa sughua na tivi pana hava so, mi murina mai ka, sakai so na tinoni te holai moro nia hughuhughu ahei sughua rotadira te puku ni loghoani, kara holara va tana bona ni holohabau. Ahei tadira inau, Yahweh, tu tughunia te hahi ke, keri ge ahei te hahi ke nia heveioli vanira va na tinoni te puku ni lologho, eruani na mateni na hava te gitoi. ");
INSERT INTO nlg_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ma ge na tinoni te tala ge ke righitaonia nina donkey, buluka, pana sheep pana maumanu ghua vania sakai na tinoni keha, me ke mate heghena pe ke pae, pe ke mai gitoa siki tinoni ghighirou, me taho siki tinoni ke righi sodoa ke, ");
INSERT INTO nlg_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","na tinoni te tala ge ke righitaoni ke mai kenera na vure ni dete me ke mai gonia na baubahu tana ahagu inau Yahweh te mua gitoa gaia na maumanu keri. Ma ge siki sakai ke mua gitoa na maumanu keri, na tinoni lologho ke talamaghia/pangotia na papari/baubahu eni, mana tinoni te tala ge ke righitaonia te mua pelu olia. ");
INSERT INTO nlg_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Hauva ma ge siki tinoni ke gitoa na maumanu ke, mana tinoni te righitaoni ke tughu olia vania na tinoni te loghoa na maumanu keri. ");
INSERT INTO nlg_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ma ge na maumanu asi ke mai matea ke, na tinoni te righitaoni ke hola na pilena, me ke mai tatea vania na tinoni logho, ge kara taluutunia te matea sughua na maumanu asi. Keri ge tinoni te righitaoni ke mua tughu olia na maumanu. ");
INSERT INTO nlg_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ma ge na tinoni ke nongia me ke nia latu na maumanu me ke mua nia udukolua ahei te loghoa, mana maumanu ke pae pe ke mate, na tinoni keri ke pelu/tughu olia na maumanu vania hei te loghoa. ");
INSERT INTO nlg_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Hauva, ma ge na maumanu ke bubuto pe ke mate te ghana so iga hei te loghoa, na tinoni te nongi ke mua tughu olia vania hei te lologho. Ma siki tinoni ke nongia ge ke nia lutu me ke tabaa sokoa tua me ke mate na maumanu ke, me ke mua tughu oli ghua na pukuna e saroa tua na tabana te pelu sokoa nia ge nia lutu. ");
INSERT INTO nlg_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Na tahula marabu/te mua nia maturu kolu mua siki mane, me ke nia bosa kolu siki mane, me ke gonia vania tua na tangotangodika ke, na mane keri ke va pelua ta tamana na vaivine vaho ge ke tauna. ");
INSERT INTO nlg_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ma tamana na tahula keri ke mua lubatia dalena ge ke tauna na mane keri ke, me ke nia poroporoulu na rongo te kaekagena na matena na tahula marabu. ");
INSERT INTO nlg_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Siki vaivine ke nia lutu na kibo ke, ma kau matea na vaivine keri. ");
INSERT INTO nlg_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Na tinoni ke tangodika itatana siki maumanu, kau matea ghua. ");
INSERT INTO nlg_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ma hei ke sukaghia siki god keha ke, kau matea. Kau sukaghia vaso/vamua Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ma siki tinoni ke sinogho haghe mai tamua, kau bei lavibuleana. Kau ghanaghana olia tana bona tau sinogho va i Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kau bei nira ghighirou gea na lei vaivine mate sasani maia na lei gari pile tara mate sanira tamadira ma tinadira. ");
INSERT INTO nlg_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kau gonia vanira na totobo te dika ke, mi nau ku arovira so tana bona kara tangi vaniu ge ku hangara. ");
INSERT INTO nlg_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ma nigua na rutu ke gatu vanighau, mu ku neghau ge kau mate tana veitotoghoni, mana lei taumiu kara samu mana lei dalemiu kara mua tamagha ghua. ");
INSERT INTO nlg_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kau lavikau vania siki tinoni bona ke, kau bei nera ge kau pelu olia na balu rongo ivuvungana na rongo te hola kaua vagha na bank. ");
INSERT INTO nlg_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kau lotia na popolona siki tinoni, me ke sora na bona te nia baubahu ge ke pelu olia itamiu na rongo. Kau vahe oliana popolona te mua huu mua na hina. ");
INSERT INTO nlg_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Na pukuna gaia vamua tua na popole te loghoa ke poroa nia na hulina. Mi tana bona ke tangi vaniu ge ku hanga ke, mu ku hangaa so na pukuna tu nira dikalio arahei tara ghaghana iga. ");
INSERT INTO nlg_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kau bei bosa tabuu inau nimiu na God, ma kau bei bosai na lei bosa dika vanira na lei mane naghomiu. ");
INSERT INTO nlg_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Mi tana bona kau heveioli ke, kau nighi heveioli vaniu mai na lei vuivuni ni vanga ta nimiu na leghai, maia ghua na kokolo ni olive maia na wine. “Kau nighi heveioli vaniu mai nimiu na mane kamanagho. ");
INSERT INTO nlg_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kau vahe oliu mai ghua na dale buluka mane, mana dale sheep mane. Tana bona kara sivuragha ke, kara kabu kolua ghua tinadira te vitu mua na bongi murina kara sivuragha, ma kara sukaghi vaniu mai ke alu na bongi murina tara sivuragha. ");
INSERT INTO nlg_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ighau nigua na vure tabu. Keri ge kau bei ghanighi gea na vinahini na maumanu te matera na siki maumanu asi keha. Ighau kau vahera vamua tana lei kau, ma kara ghanighi.” ");
INSERT INTO nlg_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ma Yahweh te ghoi bosa vania so Moses, “Kau bei bosai gea na lei bosa sorisori ivuvungadira arahei na keha. Ma siki tinoni ke hanga na koti, ke bei bosa na hava te mua utuni, ge ke hanga na tinoni te mua maemane. ");
INSERT INTO nlg_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Kau bei nira udukolu na lei tinoni tara liona na goniana na totobo dika, pa ra bosaa na hava te mua utuni tana dete. ");
INSERT INTO nlg_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ma siki tinoni bona ke tona tana koti ke, kau bei nia pala ma kau hangaa, sakai vamua/na pukuna te bona. ");
INSERT INTO nlg_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ma ge kau tona sodoa nina buluka pana donkey na ghamiu levunimate tara tona sania na bona te talura iga, kau laviolira vania mai na ghamiu levunimate. ");
INSERT INTO nlg_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nina donkey na ghamiu na levunimate, ke mavaa na hohola te holaa, me ke nia tumu na hohola tana pari, ma kau righia ke, kau bei tona haliu, kau hangaa na ghamiu na levunimate ma kau tughuru vaghinia na donkey ge ke tughuru dato. ");
INSERT INTO nlg_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kau bei pegopalaa na tinoni bona tana koti. ");
INSERT INTO nlg_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Kau bei pegoa hei tana koti, ma kau bei labumate tinoni ma kau toroa nia te mua goni hahia siki totobo dika. Kau nea eni vania hei ke, ku mua talukehai vania hei te ghaghua iga. ");
INSERT INTO nlg_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ma siki tinoni dika ke tabotabo ge ke nia lutu na rongo ge ke sukighau ma kau nia pala tana koti, kau bei taonia gea na totobo keri. Kau nera gea na vure dete ma kara rorodo, mara mua righikalea na hava te maemane, mau nea na koti me toroa na tinoni te ma goni hahi na hava. ");
INSERT INTO nlg_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Kau lavibuleadira na sinogho haghe mai na pukuna ighau ghua tua sinogho tana bona tau kabu pipiti i Egypt, mau vadangia na dikana tana bona keri. ");
INSERT INTO nlg_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“E ono na niulu kau lutui ga nimiu na leghai ta nimiu a pari, ge kau holai ga na ghamiu na vanga subai/vadei. ");
INSERT INTO nlg_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","E vitu na niulu kau bei suba siki totobo ilokana nimiu na pari, kau sania me ke aheahe. Kau bei lutua mua iga siki leghai, ma kau bei gheli keahi ghua siki vanga te totolo me ghahai ga. Na vure bona kara lavighi na vanga tara totolo dato, mana maumanu asi kara ghanighi na vanga tara lavi sanighi na vure bona. Ma kau nea ghua iga nimiu na leghai ni grape mana lei ghai ni olive. ");
INSERT INTO nlg_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ma haia ke tau ghilala vamua na lutu e ono na bongi, me vituni na bongi, kau mua tangomana ge kau lutu iga. Me vituni na bongi ke, na bongi ni aheahe ighau, maia nimiu na seka, mara hei na sinogho tara lutu vanighau. Kara aheahe maia ghua nimiu na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Kau rongovi utoi na lei totobo ini inau, nimiu na God, tu bosai vanighau. Kau bei kokoeliulivuti vania siki god keha, sughu manaa na bosani na ahadira kau bei nea ghua. ");
INSERT INTO nlg_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tana lei niulu, kau talu sosopara e tolu na bongi ge kau ghanaghana mavau iga. ");
INSERT INTO nlg_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tana vula Abib kau ghanaghana iga na bongi ni Berete Gulu, na pukuna tana vula ia tua eni, tu lavihorughau mai Egypt, ma kau taonighi na hava tu bosai vanighau. Mi tana e vitu na bongi kau ghanighi berete te taho iga na yeast. Ma kau holai mai mughua nimiu na vatei sukaghi ge kau holohabau nia. ");
INSERT INTO nlg_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Kau ghanaghana ghua na bongi ni Lavinivogha, na bongi ni heveioli ta sopa nimiu na leghai na vuivuni ni vanga. “Ma kau ghanaghana ghua te soko iga na bona ni ghegheli. Mi tana sosokona na niulu, kau ghanaghana olia na bongina na ghaghata tau lavighi mai ga na vangani nimiu na leghai ");
INSERT INTO nlg_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tana tughu niulu vanira tolu na bongi mava ini na lei mane kara mai holohabau inau, Yahweh, nimiu na God. ");
INSERT INTO nlg_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kau bei nia sukaghi na berete te loghoa na yeast tana bona kau nia sukaghi vaniu na maumanu ma kau hea nina ghabu vaniu. Ma kau kerea na birosoni na lei maumanu tau nighi sukaghi tana bongi eni, taho siki biroso te ghaha olighi me ke saravia na roropoghana. ");
INSERT INTO nlg_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Kau holai mai tughu niulu tana valegu, inau a Yahweh, nimiu na God, na vuivuni na vanga ni subai tau holai ta nimiu na leghai tana bona ni lavinivogha. “Kau bei ghalatia nia gea na dalei sheep pana goat nia kokolo ni susuna tinadira. ");
INSERT INTO nlg_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Inau ku nia vetena vanighau na angel geke idevighau me ke righitaonighau ta nimiu na vinano vaa tana komu/butonikomu tu gonidilaa vanighau. ");
INSERT INTO nlg_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kau rongovia ma kau goni taonia na hava ke bosa vanighau nia. Kau bei hughuhughu kolua, na pukuna inau tua tu nia vetena vanighau, me ke mua talukehai vania hei ke hughuhughu kolua. ");
INSERT INTO nlg_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ge teke vagha kau taonia ma kau gonia na hava tu bosa vanighau, inau ku veitotoghoni kolura ghamiu na levunimate. ");
INSERT INTO nlg_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ma nigua na angel ke idevighau me ke lavighau va tana komudira/butonikomudira rana vure ni Amor, mana vure ni Hit, mana vure ni Periz, mana vure ni Canaan, mana vure ni Hiv mana vure ni Jebus, mi nau ku taghalaghinira sokora na vure raini. ");
INSERT INTO nlg_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kau bei tongaghi vania didira na lei god ma kau bei holohabara gea. Ma kau bei taonia gea ghua ivei tar nea na holohaba. Kau taghalaghighi didira na god ma kau durake horui didira na vatu tabu datogha tara tughuru iga ge kara holohaba. ");
INSERT INTO nlg_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Kau holohabau vaso inau Yahweh, nimiu na God, ma kau nea ke, mi nau ku vautoghau nia na vanga ke subo me ke subo ghua na ghamiu na beti, mu ku lavikehaghau na vahaghi tamiu. ");
INSERT INTO nlg_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na lei vaivine kara logho daledira tana bona kau sara tana kolu ni tunuva keri. Mana lei vaivine kara mua sivilaghinia siki daledira tana bona tara mua vahuhu mua, mi nau ku neghau ge ke daro na volamiu. ");
INSERT INTO nlg_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mi nau ku nera na ghamiu na levunimate ge kara mataghuniu, mu ku nei na liodira ge ke hughahughapoto ta ghamiu na levunimate, mu ku nera ghua ge kara ririu keha ma kara sama keha itamiu. ");
INSERT INTO nlg_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mi nau ku nera na ghamiu na levunimate ge kara mataghu nighau, mu ku ghurukehara na kema ni Hiv, mana Canaan maia na kema ni Hit tana bona kau sakutua tona. ");
INSERT INTO nlg_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mu ku mua ghuruhorura ilokana sakai na niulu, na pukuna ku nea ke, me ke aroha na komu/butonikomu baubahu, me ke subo ngangata iga na maumanu asi kau mua tangomana na ghurukehaadira. ");
INSERT INTO nlg_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ku mua ghuruhorura sakai te, balu mu ghura, koekobe ke saravia na bona ke sivuragha me ke subo na tinoni ge kau vunaghina na komu/butonikomu baubahu (tunuva). ");
INSERT INTO nlg_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mi nau ku talua na kobekobena na komu/butonikomu baubahu ke vuivuni paleva launa na Tahi Sisi, me ke saravia na paleva bokona na beti tina Euphrates, me ke ghoi vuivuni paleva uluna na tahi Mediterranean me ke saravia longana na bona tuatuarese te mua totolo ga siki ghai. Mi nau ku vaheghau na laga mana maana ge kau vunaghidira na vure tana komu/butonikomu keri, ma kau ghurura so na vure tana bona kau sakutua haghe tana komu/butonikomu baubahu. ");
INSERT INTO nlg_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kau bei gonia siki baubahu koluadira pa sughua didira na god ghua. ");
INSERT INTO nlg_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kau bei lubatira ge kara sopou ilokana na komu/butonikomu ni baubahu. Kara neghau ma kau tangotangodika savuu gea. Ma kau holohaba so didira na lei god keha ke, ma gaia keri na hahi kau tumu iga ilokana.” ");
INSERT INTO nlg_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Keri ke Yahweh te bosa vania Moses, “Ko holara Aaron, ma Nadab ma Abihu kolura nia ara vitu hangavulu na mane naghomiu, ma kau dato mai tagua inau God tana ghotu eni. Mi tana bona kau mai dutu pile mua ke, kau tongavi/poghotao ma kau holohabau. ");
INSERT INTO nlg_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ighoe heghemu vamua ko tangomana ge ko mai dutuviu. Ma gaira na lei mane naghomiu kara bei mai dutu gea, maia na balu vure ghua kara bei dato mai gea tana ghotu eni. ");
INSERT INTO nlg_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ma Moses te ladavaghinia vanira na vure na lei kokokoe mava maia na lei vetena Yahweh te bosa vanira nia. Ma gaira udolu na vure tara bosa sakaisonikolu mara ghaghua, “Ighai tai baubahu ge kai goni taonia na hava Yahweh te bosaa vanighai.” ");
INSERT INTO nlg_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ma Moses te gere horui na lei kokokoe Yahweh te bosai vania nia. Mi tana puipungighana tana doni vaolu, Moses te kisua sakai na bela ni sukaghi tana pukuna na ghotu, ge holai hangavulu rua na vatu sule. E tughuru vaghinighi hangavulu rua na vatu taonighi hangavulu rua na kema ni Israel/Jew. ");
INSERT INTO nlg_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Me vilira na balu garimane ni Israel ge kara matera na balu buluka mane vaolu, ma kara nira sukaghi vania Yahweh. Na balu kara kerei mana balu na levudira vamua tara kerei mana levu tara ghanighi te talutatea didira na tamakulani kulana God. ");
INSERT INTO nlg_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Me holai na ghabudira na lei dale buluka mane me talui na levuni lokana na popo, me seburukaghinighi na levuni keha tana bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Keri ge holaa na buka ni baubahu nina God te gere horui ga na lei kokokoe kiri, me idumi tatei vanira na vure. Mara bosa mara ghaghua, “Ighai kai taonia Yahweh, ma kai goni taonighi na lei kokokoe Yahweh te lioni ge kai gonighi.” ");
INSERT INTO nlg_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Keri ke, Moses te seburukaghinighi na ghabu ilokana na popo itadira na vure, ge bosa me ghaghua, “Gaia eni na ghabu te patupatu laga na baubahu Yahweh te nea vanighau tana bona te nighi hevei nina vetena.” ");
INSERT INTO nlg_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ma Moses kolura Aaron, Nadab, Abihu maia ara vitu na hangavulu na mane nagho ni Israel/Jew, tara dato tana ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Iani tara righia God ni Israel/Jew. Tana pukuna na ghotu lilighina na bona te tughuru iga ra righighi na balu vatu utoutoi tara holoi nia sapphire, te mana/mara reireini te vagha na parako raumauri. ");
INSERT INTO nlg_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ma sakai vamua na lei mane nagho ni Israel/Jew tara righia God, e mua dikalara, mi murina eni gaira tra vanga mara inu koukolu. ");
INSERT INTO nlg_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ma Yahweh te bosa vania Moses, “Ko dato mai ani tagua tana ghotu. Ko kabu iani, mi nau ku vahegho rua na vatu peapea tu gere horui ga nigua na vetena tu gerehorui ga nigua na lei vetena mana bosa ni tarai ge ko taraira nia na vure ni Israel/Jew.” ");
INSERT INTO nlg_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moses maia Joshua na hahanga, te gonidila, ma Moses te sei dato ta nina ghotu God. ");
INSERT INTO nlg_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Imurina te sei dato, Moses te bosa vanira na balu mane nagho ni Israel/Jew, “Kau kabu pitughai ani koekobe koro oli mai. Ma ge siki hughuhughu ke sivuragha mai muriamu ke, kau va righira Aaron ma Hur toro kabu kolughau, mara tona vanira. ");
INSERT INTO nlg_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Keri ge dato Moses tana ghotu, mana pui/ghobaghuli sule te horu mai me saroa kouna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Mana mararana nina maana Yahweh te kabu kouna na ghotu Sinai, me ono na bongi te saroa na pungi/ghotu. Me vituni na bongi, Yahweh te holoa Moses ilokana na pungi/ghobaghuli. ");
INSERT INTO nlg_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Mi tana bona na vure ni Israel/Jew tara righia na mararana nina maana God te marara vagha na lake sule kouna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Keri ke, Moses te tona tana ghobaghuli tana bona te sei dato tana ghotu. Me kabu iga vati hangavulu na dani me vati hangavulu na bongi. ");
INSERT INTO nlg_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ko bosa vanira na vure ni Israel/Jew ahei te liona ge ke nia mai nina hevei oli vaniu ke, me ke nea so. ");
INSERT INTO nlg_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Raini gaighi na gegereni na lei totobo ko holopangotighi tughuu inau kara nighi hevei na vure - gold, silver mana bronze; ");
INSERT INTO nlg_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","na vuvulu ni sheep te reirei vagha na horara, boibongi pana sisi, na tivi pura utoutoa, na tivi pura tara vauhia nia na ghuighuli ni goat; ");
INSERT INTO nlg_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na ghuighuli ni sheep mane tara gonia me sisi, na ghuighuli ni maumanu te malebo, maia na ghai tara holoa nia acacia, ");
INSERT INTO nlg_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","na kokolo ni olive kara dodoea nia na bulu, na raurau ni ghai na vatei kere ghaiuruuru te gasuva, maia na kokolo tabu me vatei siusiu tinoni, maia kara tabui nia na balu totobo; ");
INSERT INTO nlg_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na vatu sisi utoutoa/vitiviti tara holoa nia na onyx, maia ghua na balu vatu vitiviti/utoutoa so kara talui tana sosokona didira pupulu na puku ni sonisukaghi tara holoa nia na ephod, maia na paosi te sasarau lilighina na pupulu. ");
INSERT INTO nlg_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Mo ko bosa vanira na vure ni Israel/Jew kara kisua vaniu sakai na vaevale tapole tabu, mi kakeri iga ku sopou ighobudira. ");
INSERT INTO nlg_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kau kisua na vaevale tapole tabu, maia na lei totobo soko ilokana, ke tona taoni utoa nigua na ghanaghana ku tughunia vanigho kau nea iga na goniana. ");
INSERT INTO nlg_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ko gonia sakai na bokisi nia tibana na ghai tara holoa nia na acacia. Mana darona ke saravia erua mi levu na cubit, mana volapana ke saravia sakai mi levu na cubit, mana datona ke saravia sakai mi levu na cubit. ");
INSERT INTO nlg_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Mo ko saroa na lokana nia na puku ni gold maia ghua ke talighutia i paribebetena. Mo ko gonia sakai na kabe ni gold ke talighutia na bokisi na vaguvaguna. ");
INSERT INTO nlg_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Mo ko gonighi ghua e vati na ringi ni gold. Mo ko tarighi e vati na ringi ini taonighi e vati na tuana na bokisi, erua ta sakai na levu, me rua tana ruani na levu. ");
INSERT INTO nlg_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Mo ko gonighi ghua erua na ghai daro na vatei holaana na bokisi, na ghai tara holoa nia na acacia na tibana ko gonia nia, mo ko rago taovaghia nia na gold na ghai ni hola. ");
INSERT INTO nlg_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Vaho ge ko talui va erua na ghai ni hola ilokani e vati na papada/ringi tana rua na levu na vatei holana nia. ");
INSERT INTO nlg_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Erua na ghai ni hola ini ke kara ghahara haia tua ilokani na lei ringi kiri, ko bei ghoi hola kehai tua. ");
INSERT INTO nlg_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Me rua na vatu peapea tu gerei ga nigua na baubahu ge ku nia hevei vanigho, ko talui lokana na bokisi keri. ");
INSERT INTO nlg_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Mo ko gonia sakai na sasaroa na bokisi nia na puku ni gold, mana darona ke saravia erua mi levu na cubit, mana volapana ke saravia sakai mi levu na cubit. ");
INSERT INTO nlg_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Mo ko sarighi erua na cherubim, koro loghoi na ghata ni gold. Ko patokighi va itadira, mo ko talui va erua cherubim ini kouni erua na sosokoni na sasaro, ");
INSERT INTO nlg_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","mo ko talu pasukolura na cherubim ini ge koro pasukolua nia na sasarona. ");
INSERT INTO nlg_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Na cherubim koro vaevane kolu mo koro vaevane horua sasarona na bokisi. Koro vurehighi na ghatadira me ke saroa na vouvotuna na bokisi. ");
INSERT INTO nlg_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mi nau ku vahegho erua na vatu peapea mo ko talu haghei lokana na bokisi, vaho ge ko hola na sasarona mo ko vongotia. ");
INSERT INTO nlg_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Vouvotuna na sasaro na bokisi ighobudira rua na cherubim, kakeri ku sodogho, mu ku kokokoe kolugho ge ku vahegho nigua na lei vetena vanira na vure ni Israel/Jew, ma kara taonighi. ");
INSERT INTO nlg_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Keri ge ko gonia sakai na bela nia na ghai tara holoa nia na acacia. Na darona ke saravia erua na cubit, na volapana ke sakai na cubit, mana datona ke saravia sakai mi levu na cubit. ");
INSERT INTO nlg_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ko saroa nia na puku ni gold na lei tibana. Mo ko gonia sakai kabe ni gold ke talighutia na bela eni na vaguvaguna. ");
INSERT INTO nlg_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Mi vouvotuna na bela, ko gonia iga na pilupiluna ke talighutia niana datona na pilupilu lima na gigiri. ");
INSERT INTO nlg_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Mo ko gonighi vati na ringi nia na puku ni gold tana bela eni, ko tari sasaraui lilighini vati na tuana na bela. ");
INSERT INTO nlg_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Na lei ringi ini kara loti kolui erua na ghai ni holana na bela, ma kara dutuvia na pilupilu. ");
INSERT INTO nlg_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Mo ko gonighi ghua erua na ghai daro ni hola, nia na ghai tara holoa nia acacia, vaho ge ko saroa nia na puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ko gonighi na plate mana dish nia na puku ni gold, maia na barore, mana popo, mana kapu na vatei talu wine ge ko nia sukaghi dato vaniu mai. ");
INSERT INTO nlg_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ko talua haia na berete tabu eni vouvotuna na bela, ke tughunitatea inau haia tu ghaha kolughau haia. Na berete eni ke ghaha haia tana matagu. ");
INSERT INTO nlg_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ko gonia na tuana na vatei talu bulu nia na puku ni gold. Na tuana mana berena ke, ko tupi paruruha na gold ge ko gonighi nia. Na ghobupaupatuna ko talua iga na seu ni vatei tolu kokolo, mana seu ke reirei vagha na pulaoa/flower, mana lei hegohegona ke mai ta sakai na base vamua. ");
INSERT INTO nlg_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Me ke loghoi e ono na baebaseni - e tolu na baebase ke tona horu taonia na ghobuna i levu, me tolu ke tona va i levu. ");
INSERT INTO nlg_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Me ono na vaguvagu ke, ko gonighi ma kara reirei vagha na pulaoa/flower-tana na ghai tara holoa nia almond. ");
INSERT INTO nlg_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Mana berea ko gonighi ga e vati na pulaoa/flower nia na puku ni gold, mana reireina ke vagha na pulaoa/flower-tana na ghai tara holoa nia almond. ");
INSERT INTO nlg_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","E tolu na bona ko talui ga sasakai na pulaoa/flower kara pasukolu iga na lei vaguvagu va tana bere. ");
INSERT INTO nlg_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ko tupi maemane na gold va tana ghai ni vatei talu bulu eni maia na vatei talu pulaoa/flower, maia na lei vughuvughu ke pasukolu ta sakai na puku ni gold vamua tara patokighi. ");
INSERT INTO nlg_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Vaho ge ko gonighi ara vitu na bulu na vatei talu kokolo, mo ko talui va ivouvotuna ge ke nia hevei na marara va inagho. ");
INSERT INTO nlg_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ko gonighi na palapala (sisis) ge ke lotia kolua na vatei talu lake, maia na plate nia na puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ko holai tolu hangavulu lima na kilo na puku ni gold ge ko gonia nia na vatei talu bulu eni maia ghua na lei hegohego na. ");
INSERT INTO nlg_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ko goni taoni utoa na totoghalena tana bona ko gonia na vatei talu bulu eni tu bosaa vanigho kouna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ko gonia na vaevale tapole tabu ni ra paregho (10) rana tivi kara malebo ghioghio, boibongi, me ke sisi rana susukini. Holatia na tinoni te ghilala utoa na susuki tivi me ke sukighi na vaughilala ni maumanu vola tana tivi rakeri ma kara logho ghatadira. ");
INSERT INTO nlg_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Rana tivi rakeri, kara sakai na vata ni daro mana volapa va sono. Sakai na midi ni tivi ke, vitu na ghoto na darona me ke sakai na ghoto na volapa. ");
INSERT INTO nlg_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Suki kokolui ra liva na midi ni tivi rakeri ge kara sakai na tivi vaso. Mo ko suki kokolui ghua na balu midi ni tivi ge ke ruani na ovu. ");
INSERT INTO nlg_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ko tura alaala horui na ringi tana sosokoni na tivi ghioghio mi sosokoni ghua sopa sakai na midi ni tivi. ");
INSERT INTO nlg_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Turai ra livi hangavulu na ringi tana sosokoni ta sopa sakai na tivi tana vuivuni ni ovu. Mo ko turai ghua ra livi hangavulu na ringi tana sopa sosokoni ra ruani na ovu. Rana ringi raeni ke, kara sopa murimuri kokolu. ");
INSERT INTO nlg_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Holai ra lima hangavulu na halili gold, mo ko talukolui nia ra rua na ovu ni tivi raeni, me ke nea ge ke sakai na Vaevale tapole tabu geke sakai vaso. ");
INSERT INTO nlg_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Gonia ghua sakai na kuikuvi/papata/vale tapole me ke saroa na vaevale tapole tabu keri. Ko gonia nia kuikuvi/papata/na vale tapole keri ra hangavulu sakai na midi ni tivi tara gonighi tana vuvuluna na goat. ");
INSERT INTO nlg_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Na lei midi ni tivi raeni, kara sakai na kaekage vamua. Na kaekageni kara 13.5 meter tolu hangavulu na cubit na daroni me ke 1.8 meter vati na cubit na volapani. ");
INSERT INTO nlg_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Suki kokolui ra lima na midi ni tivi ta sakai na ovu, mo ko ghoi suki kokolui ra ono na midi ni tivi tana ruani na ovu. Loku ruai ra ono na midi ni tivi va inaghona na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tura alaala horui ra lima hangavulu na ringi tana lilighini sakai na ovu ni tivi, mo ko nei ghua iga na sosokoni sakai na ovu ghua. ");
INSERT INTO nlg_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ko holai ra lima hangavulu na halili burasi (brass), mo ko kautighi tana ringini sakai na ovu ni tivi, ge ke talukolui ra rua na ovu ni tivi. Ke nea ra rua na ovu ni tivi raeni, ge ke sakai na kuikuvi. ");
INSERT INTO nlg_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Lubatia na soduna na kuikuvi keri ge ke sasarau me ke saroa na murina na vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ge saravia ra 0.5 metersakai na cubit ke sasarau horu tana levuna mana levuna na vaevale tapole tabu keri geke pilupilua na vale tapole. ");
INSERT INTO nlg_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ko ghoi gonighi ghua ra rua na kuikuvina na vaevale tapole tabu. Sakai ko gonia nia na ghuighulina na sheep mane tara kirikiria sisi, mana kuikuvi muri ko goni nia na ghuighuli ni maumanu ke malebo. ");
INSERT INTO nlg_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ko tokai na ghai tara holoa nia na Acacia, ge ko gonia nia na ghelivaghina na vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Na ghelivaghi keri ke, 4.5 meter na darona 0.7 meter na volapana. ");
INSERT INTO nlg_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Na ghelivaghi keri ke bei ghoi kehakeha gea na daro tana levu mana levu vagha ghua na volapa tana sodu mana sodu. Patokighi ra rua na ghai ilevuni mi levuni tana sopa piuni ge ke tabe kolua na ghelivaghi. ");
INSERT INTO nlg_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ko patokighi ra rua hangavulu na ghai sodu longana na ghelivaghi, ge ke tabea. ");
INSERT INTO nlg_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Mo ko gonighi mai ra vati hangavulu na bere silver vania sopa pukuni, ra rua na posi/bere kukulu ta sakai na gilu, mo ko hogho lavaghinighi lokani. ");
INSERT INTO nlg_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Mo ko tokai vania ghua ra rua hangavulu na bere tana sodu launa, na vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Mo ko ghelivaghinighi ra vati hangavulu posi silver tana pukuni, ra rua na posi silver ta sakai na gilu. ");
INSERT INTO nlg_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ko bei ghoi taho gea na ghelivaghiniani ra ono na ghai i sodu boko sosokona na vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Mo ko tualaghinighi ghua ra tango tua na ghai kara tabe ngasilighi sopa piu. ");
INSERT INTO nlg_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ra rua na ghai tana sopa piu ke, ko talukolu utoi mo ko varoghi ngasilighi ge kara tabe kolu utoi na vuvunga mi boroni rana ringi seni. Ko gonighi ma kara sakai na vata vasono rana sopa piu. ");
INSERT INTO nlg_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Keri ge ke kaekage ra alu na kala kara tabei sopa piuna na vaevale tapole tabu. Me ke kaekagena ra hangavulu ono na silver posi tana pukuni ma kara sopa tango tua. ");
INSERT INTO nlg_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ghoi tokai mai sono rana ghai na ahana na acacia ge ke tabe kolua na kokouna na ghelivaghi ni vaevale tapole tabu. Talui ra lima na ghai kara vavala ke tabe kolua ta sakai na levu i launa. ");
INSERT INTO nlg_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Mo ko ghoi talui ra lima na ghai kara vavala ta sakai na levu kolua ghua rana ghai kara vavala ge ke tabe kolua na ghelivaghi tana levu bokona tana sosoko mi tana piu. ");
INSERT INTO nlg_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mi tana ghabu popatuna na ghelivaghi ke datogha me ke sara ighobu. Mo ko talua iga na vuvunga ge ke tabe kolui na ghaho i levuna mi levuna mi tana piuna na vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tura alaalai na ringi gold tana sosokoni na ghai tana levu mana levu. Ghogholavaghinighi ra rua na ghai lokani na ringi gold. Mo ko saroa na ghaite vavala nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Goni taonia na Vaevale tapole tabu tana hava tu tatea tua vanigho tana ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tari datoa na tivi ni vokovoko nia na tivi malebo kolua na tivi ghioghio, boibongi, tara sukighi nia na cotton sisi. Lavia na tinoni te ghilala suki totoghale tana tivi, me ke sukighi na totoghaledira na maumanu vola ma kara logho ghatadira tana tivi ni vokovoko. ");
INSERT INTO nlg_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Taria na tivi ni vokovoko nia na halili gold tana vati na acacia posi. Mo ko saroi nia na gold mo ko sukavai tana silver posi i pari tana vati na pukuni. ");
INSERT INTO nlg_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Taria na tivi ni vokovoko tana halili gold, ke sasarau tana ghobu ni voki lokana na vaevale tapole tabu. Talua na Bokisi ni vetena ni baubahu tabu ighobu paupatuna eruani na voki murina na vokovoko. Na vokovoko eni te vilivokai na bona tabu mana bona tabu mavaa mete haba. ");
INSERT INTO nlg_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ko vaa pataa na Bokisi ni vetena ni baubahu tabu tana voki te tabu vahotua. ");
INSERT INTO nlg_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I paribebetena na vokovoko ke, ko talua na bela paleva launa na vaevale tapole tabu. Mo ko talua na vatei talu bulu tana levu longana na vaevale tapole tabu. Paleva levuna na bela. ");
INSERT INTO nlg_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Ko ghoi sukia na vokovokona na vatei liuhaghe tana vale tapole, ko gonia nia rana tivi malebo, ghioghio, boibongi me ke sisi na susukini. Ko kenea na tinoni te ghilala utoa na susuki me ke sukighi na vaughilala tana tivi rakeri. ");
INSERT INTO nlg_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tughuruvaghinighi ra lima na posi nia na ghai na ahana acacia, mo ko saroi nia na gold. Turai ra lima na halili gold, kara sasarau iga tana vokovoko te vavala tana bere, mo ko talui ra lima na vatei tuturi rana brass ge ko sukavai ga rana post ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ko gonia na bela ni sukaghi nia na ghai tara holoa nia acacia ke, sakai na ghoto ma sakai na hangava na darona, me ke vaghaa ghua na halavuna, mana datona ke, erua na alo ni togho. ");
INSERT INTO nlg_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ko gonighi tangosakai kala, te vagha na kala ni buluka, tana vati na piuna na bela ni sukaghi, ge kara pasu te vagha sakai na pilena. Mo ko poroa nia na bela ni sukaghi maia na kalana na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Na bucket, mana shovel, mana basin, mana fork/seubasebase, mana pepetelake, ko gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ko gonia sakai na netwire nia na bronze vaghaa na kei, mo ko talui va na ringi bronze tana vati na piuna. ");
INSERT INTO nlg_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mo ko talua va na netwire ighobu ke hau i pari mi kokou tana malana na lake, me ke va sopou tana ringi to gonia iga. ");
INSERT INTO nlg_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Na vatei gharaduana na bela ni sukaghi ke, ko gonighi erua na ghai ni hola nia na ghai ta vatua nia na acacia, mo ko poroa nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Tana bona kau holaa ke, torovaghinighi va na ghai ni hola tana ringi levu mi levuna na bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Na bela ni sukaghi ke tatavanga, ko gonia nia na kilova volapa. Ko righitaonia, ko gonia te vaghaa tu tatea vanigho tua tana vuvungana na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Vaho ge ko gonia na pilupiluna na Vaevale tapole tabu. Ko tari kililia nia na puku ni tivi tara vauhia. Tana pala launa ko taria iga na tivi erua hangavulu lima na ghoto na darona. ");
INSERT INTO nlg_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ko tari datoa nia erua hangavulu na bere ko gonighi nia na bronze, ma kara tughuru ilokani erua hangavulu na pukuni to gonighi nia na bronze. Ko taria na tivi nia na silver tara kekeli/sinagaura vaghai na halili mo ko kaulaghinighi va tana wire daro ko gonia nia na silver to kaulaghinighi va tana lei bere. ");
INSERT INTO nlg_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Me ke vaghaa ghua i longana - erua hangavulu lima na ghoto na darona na tivi. Ko tari datoa nia erua hangavulu na bere me erua hangavulu na pukuni kara tughuru iga, maia na halili mana wire daro to gonighi nia na silver. ");
INSERT INTO nlg_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Na tivi tana pala bokona na pilupilu, ke hangavulu rua na ghoto mana levu lima na darona. Ko tari datoa nia ara hangavulu na bere, me hangavulu na tuani kara tughuru iga. ");
INSERT INTO nlg_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Tana pala uluna, ke hangavulu na ghoto mana levu lima ghua na darona. ");
INSERT INTO nlg_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Na mataula ni haghe tana pilupilu ke, tana pala uluna. Ko tari pungisia nia erua na tivi. Na tivi tana pala madolo ke tolu na ghoto mana alo ni togho. Ko tari datoa nia e tolu na bere me tolu na pukuni kara tughuru iga. ");
INSERT INTO nlg_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Na tivi tana pala mauli ke tolu na ghoto mana alo ni togho ghua na darona. Ko tari datoa nia e tolu na bere me tolu na pukuni na bere kara tughuru iga. ");
INSERT INTO nlg_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Vania na mataulana na pilupilu, ko gonia na tivi e lima na ghoto na darona. Ko talua iga na puku ni tivi, mo ko vaguvagua nia na ghioghio mana boibongi ma asisi te utoutoa na reireini kara sukighi va iga. Mo ko kaulaghinia va tana vati na bere tara tughuru tana vati na pukuni. ");
INSERT INTO nlg_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Na lei bere kililia na pilupilu kara kaukolu va tana wire daro to gonia nia na silver. Na bere kara nighi tughuru na pukuna ke ngasi to gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Keri ke, mana pilupilu udolu ke erua hangavulu lima na ghoto na darona, me hangavulu rua na ghoto mana levu lima na halavuna, maia ghua sakai na ghoto me rua na hangava na datona na puku ni tivi tau gonia. Na pukuni na berena na pilupilu kau gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Na lei totobo kau nighi lutu tana lokana na Vaevale tapole tabu, kolua nia na hava kau tupi horui tana pari, kau taria iga na alo geke ngasilia na Vaevale tapole tabu mana pilupilu, kau gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ko bosa vanira na vure ni Israel ge kara holai vanigho mai na kokolo ni olive te marabu vania na bulu te tughuru, ge ke tona haliu na ruruhu. ");
INSERT INTO nlg_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Na bulu ko tughuruvaghinia i pari bebetena na vokovokona na Bona Tabu ngangata ilokana na pilupiluna na Vaevale tabolu tabu. Aaron ma lei dalena (mane) kara righitaonighi na bulu ge kara ruruhu tona haliu tana matana Yahweh tana bongi mana dani. Aeni na vetena ke tona haliu vanira na vure ni Israel, ma kara righitaonia tana lei vavata ke mai. ");
INSERT INTO nlg_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ko holora na tugha Aaron mana lei dalena, Nadab, Abihu, Eleazar ma Ithamar. Ko talu tabalilira itadira na vuresubo. Gaira kara nigua na manesukaghi ma kara lutu vaniu. ");
INSERT INTO nlg_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ko goni kehaa nina pupulu Aaron ge ke talutatea gaia va ta God, nina pupulu tabu ke utoutoa ke vahea na talumava va ta nina lutu manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ko bosa vanira rahei tara loghoa na manaha ni goniani na pupulu, ke nea Aaron ge ke keha itadira na vure, ge ke lutu vaniu te vaghaa na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Kara gonia na sasaro garo, mana pupulu te sara tana tuturu tara holoa nia na ephod, na pupulu daro te sara tana pititagoe, mana pupulu tara vauhia, na tivi tara virighoa/pipisia na uludira, mana ghaloboke. Kara goni kehai ghua didira na tivi na lei dalena Aaron, ge kara nighi gehegehe vaniu vaghaa na manesukaghi tana matagu. ");
INSERT INTO nlg_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Rahei kara gonighi, kara gonighi nia na tivi malebo te ghioghio, me boibongi, me sisi maia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Na ephod kara gonia nia na puku ni tivi malebo, kara sukia ma kara vaguvagua nia na gold, mana cotton te ghioghio, mana boibongi, mana sisi. ");
INSERT INTO nlg_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kara gonighi erua na midi, sakai i nagho ma sakai i muri, ma kara suki kolui va tana vala tana midi te saroi na vala i levu mi levu. ");
INSERT INTO nlg_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mana ghaloboke ke vaghaa ghua na tivi tara nia lutu. Kara sukia nia gold, mana ghioghio, mana boibongi, mana sisi me ke utoutoa na reireina. ");
INSERT INTO nlg_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Kara lavighi erua na vatu tara holoi nia na onyx, ma kara gerei ga na ahani na lei kema ni Israel. ");
INSERT INTO nlg_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Kara gerei e ono na aha ta sakai na vatu, me ono ta sakai taonia na vinavahuhu na diki vahuhu me ke va sara tana sosoko ta kukuadira. ");
INSERT INTO nlg_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kara gerei na aha raini te vaghaa na tinoni te gerea na gegere kara taluutunia. Ma kara gonia na gold ke tabei na lei vatu. ");
INSERT INTO nlg_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Talu ngasilighi na vatu raini tana valana na ephod ke vaghaa na vatu ni vatei ghanaghanaoli vanira na vure ni Israel. Ma Aaron ke holai na aha raini va tana matana Yahweh, na vatei ghanaghanaoli te mua tughu. ");
INSERT INTO nlg_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Mana malani kara gonia nia na gold, ");
INSERT INTO nlg_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","me erua na ghalo kara gonighi nia na puku ni gold, ma kara kaulaghinighi va tana valana na ephod. ");
INSERT INTO nlg_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Vaho, rahei tara manahana uto na goniana kara gonia na sasaro garo, kara nia lutu geke talugonia na liona God. Kara gonia nia na tivi tara gonia nia tua na ephod, na puku ni tivi malebo tara vaguvagu nia na cotton te vaghaa gold, mana ghioghio mana boibongi, mana sisi. ");
INSERT INTO nlg_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Na sasaro garo eni na tivi kara lokua ge ke vaghaa na tanga, ma sakai na hangava na darona me ke vaghaa ghua na halavuna. ");
INSERT INTO nlg_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kara pasulaghinighi va iga ara vati na alaala ni vatu te vaguvagu./uto lee. Tana na diki alaala kara pasulaghinighi na carnelian te sisi, na topaz, mana garnet. ");
INSERT INTO nlg_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Tana ruani na alaala kara talui ga na emerald, na sapphire, mana diamond. ");
INSERT INTO nlg_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Tana toluni na alaala kara talui ga na jacinth, na agate, mana amethyst. ");
INSERT INTO nlg_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mi tana vatini na alaala kara talui ga na beryl, mana onyx, mana jasper. Na lei vatu raini kara gonia na hava te vaghaa na gold ge kara tabe ngasilighi nia. ");
INSERT INTO nlg_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Na lei vatu raini kara talutatea sakai na kema tana kema ni Israel, mana ahana na kema keri kara tupia iga na vatei talu vaughilala kara taluutunia. ");
INSERT INTO nlg_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Na vatei pitiana na sasaro garo va tana ephod, kara gonia na ghalo nia na puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Vaho, ge kara gonighi erua na ringi nia na gold, ma kara pasulaghinighi va tana rua na piuna na sasaro garo i kokou. ");
INSERT INTO nlg_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Me rua na ghalo kara gonighi nia na gold kara turai va tana ringi tana sasaro garo, ");
INSERT INTO nlg_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","mana soduni na ghalo kiri kara pitighi va tana gold tara talua tana valana na ephod. ");
INSERT INTO nlg_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Vaho ge kara ghoi gonighi ghua erua na ringi nia na gold, ma kara pasulaghinighi tana piuna i pari na sasaro garo kara palangia va na ephod kara bei tate gea. ");
INSERT INTO nlg_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kara gonighi ghua e rua na ringi nia na gold, ma kara pasulaghinighi va tana ephod lilighina na ghaloboke. ");
INSERT INTO nlg_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Vaho ge kara pitighi nia na ghalo te ghioghio na ringi i pari tana sasaro garo va tana ringi tana ephod. Ke nea ge ke tabe ngasilia na sasaro garo va tana ephod i vuvungana na ghaloboke. ");
INSERT INTO nlg_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Mi tana bona Aaron te haghe tana Bona Tabu, gaia ke holai na ahadira na lei kema ni Israel tana sasaro garo te palangia va na tobana, keri ge inau, a Yahweh ke ghanaghanaolira haia nigua na vure. ");
INSERT INTO nlg_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Hoghonighi tana tangana na sasaro garo na puku ni vatu raini, na Urim mana Thummim, te palangia na tobana Aaron ge ke holai tana bona te tona va tana matagu. Keri ke, Aaron ke holaa haia na totobo raini geke nia uto/ghilala utoa na liogu vanira nigua vure. ");
INSERT INTO nlg_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Na pupulu daro i sarana na ephod kara gonia nia na tivi te ghioghio. ");
INSERT INTO nlg_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ke hangavi na ghobuna ke vania na uluna Aaron. Ma kara vauhia na luana ge ke ngasilia ke bei taghagha gea. ");
INSERT INTO nlg_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gonia na vuavua tara holoa nia na pomegranate nia na cotton te ghioghio, na boibongi, mana sisi, ");
INSERT INTO nlg_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ma kau suki kolui va tana tivi tara bibia mana lei belo gold tana ghobuni. ");
INSERT INTO nlg_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron ke nia pupulu na tivi eni tana lei bona ni aho ke haghe tana Bona Tabu ge ke gehegehe vaniu, mana belo kara tangi tana bona ke haghe me ke horu tana matagu. Ke nia pupulu ke, ge ke mua mate. ");
INSERT INTO nlg_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Vaho ge kara ghoi gonia na medolo nia na puku ni gold. Ma kara gerea iga na bosa raini, ‘Kobe kehaa te vaghaa te tabu va ta Yahweh.’ ");
INSERT INTO nlg_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Na medolo eni kara pitia nia na ghalo te ghioghio va inaghona na ghana tivi tara virighoa/pipisia na uluna Aaron. ");
INSERT INTO nlg_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ma Aaron ke talua tana raena, ge ke holaa siki hahi ta didira na sukaghi tabu na vure ni Israel. Gaia ke talua haia tana raena ge ku lavipangotira nigua vure, inau a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Vauhia vania Aaron na pupulu nia na tivi malebo. Mana na tivi tara virighoa/pipisia na uluna ghua nia na tivi malebo, mana ghaloboke ghua kara sukia iga na hava ke loghoa na tutugu kara vaguvagua nia. ");
INSERT INTO nlg_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Ma vanira na lei dalena mane Aaron, gonighi vanira na pupulu, mana ghaloboke, mana tivi tara virighoa/pipisia na uluna, ge ke vahera na maana mana kikinima. ");
INSERT INTO nlg_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pupulura nia Aaron mana lei dalena nia na lei pupulu raini, vaho ge kau siusiura ma kau va tabura nia na manesukaghi. Talu kehara kara tabu ge kara lutu vaghara nigua na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ma kau gonighi vanira ghua na tivi malebo kara diki nighi pupulu te vuivuni tana ghobu me ke sara tana peghe. ");
INSERT INTO nlg_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kara nighi pupulu mughua raini Aaron mana lei dalena tana lei bona ni aho kara haghevia na Vaevale tapole tabu, pa kara haliu tana bela ni sukaghi tana Bona Tabu ge kara lutua na lutudira. Ke pungisira kara bei nia mate gea na paludira rana keha. Aeni na vetena ke tona haliu vania Aaron mana vaivarina. ");
INSERT INTO nlg_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Keri ke Yahweh te bosa vania Moses, “Aeni na hava ko gonia tana tabuadira Aaron ma lei dalena mane ge kara manesukaghi vaniu. Ko lavia sakai na dale buluka mane me rua na sheep mane kara marabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Nia na flour te vaolu mo ko bei kalua nia na yeast, Ko gonighi na berete, mana cake kara madeve kalu kolui nia na kokolo ni olive, mana balu na cake kara madeve kau kaikavia va na kokolo ni olive tana vuvungani. ");
INSERT INTO nlg_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Talui na lei sopa berete kiri ta sakai na kei, ma kau talui mai tana mataulana na Vaevale tapole tabu, kolui nia na dale buluka mane me rua na sheep mane. ");
INSERT INTO nlg_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Lavira mai Aaron mana lei dalena tana mataulana na Vaevale tapole tabu ma kau siuvia nia na beti. ");
INSERT INTO nlg_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Vaho, ge ko pupulua nia Aaron na diki pupulu vaho geke mai na pupulu daro mana ephod, mana sasaro garo mana ghaloboke. ");
INSERT INTO nlg_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Talua tana uluna na tivi tara virighoa/pipisia mana medolo gold. ");
INSERT INTO nlg_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Vaho ge ko lavia na kokolo ni siusiu mo ko kaikavia va tana uluna. ");
INSERT INTO nlg_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Vaho ge ko lavira mai na lei dalena mane mo ko pupulura nia didira na pupulu, ");
INSERT INTO nlg_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","maia didira na ghaloboke tara vauhighi mana pitiulu. Mi tana gehegehe eni, ighoe ko va tabura nia Aaron mana lei dalena. Gaira mana lei vaivarina kara nigua na manesukaghi ke va me va. ");
INSERT INTO nlg_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ko lavia mai na dale buluka mane tana mataulana na Vaevale tapole tabu, ma Aaron mana lei dalena mane kara talua va na limadira tana uluna. ");
INSERT INTO nlg_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Vaho ge ko matea tana matagu tana mataulana na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Paipalighi va na pile ghabu tana vati kalana na bela ni sukaghi nia na gigirimu mo ko kaikavi udolua va tana pukuna na bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ko lavia udolui na raghova te poroa na kutuna, maia na pilena na atena maia erua na gholamauvo/tutupi/kola kolua nia na raghovani, mo ko kerei tana bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Vaho ge ko lavi udolua na vinahina kolua nia na ghuighulina mana kutuna va i pari bebetena na bona tau kabu iga, mo ko kerei te vagha na sukaghi ni talukeha palu. ");
INSERT INTO nlg_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Taeni ke, ko lavia vanira mai Aaron mana lei dalena mane sakai tadira na sheep mane, ge kara talua va na limadira tana uluna. ");
INSERT INTO nlg_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ge ko matea, mo ko lavia na ghabuna mo ko seburukaghi talighutia va na bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ko pahe pilepilea na sheep mo ko saua na lokana mana tana. Ko talu kolui va tana uluna maia na balu pilena na sheep. ");
INSERT INTO nlg_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Mo ko kere udolui tana vuvungana na bela ni sukaghi. Aeni na sukaghi kekere va ta inau, Yahweh, te liuliogha ngangata itagua inau. ");
INSERT INTO nlg_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Vaho ge ko lavia mai eruani na sheep mane, ma Aaron mana lei dalena mane kara talua va na limadira tana uluna. ");
INSERT INTO nlg_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ko matea mo ko lavia na ghabuna mo ko talui va tana boghoni na kuli madolodira Aaron mana lei dalena. Maia ghua na gigirikama tana lima madolodira, mana gigirikama tana marevo madolodira. Vaho ge ko seburukaghini udolua va tana levuna mana levuna kililia na bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Vaho ge ko lavighi na pilepile ghabu tana bela ni sukaghi mo ko ule kolua nia na pile kokolo ni vatabu. Vaho ge ko seburukaghinia va tana vuvungadira Aaron mana lei dalena maia didira na tivi. Mi tana halautu vaghana eni gaira ma didira na tivi tara kobe kehara mara tabu vaniu. ");
INSERT INTO nlg_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Na pukuna na sheep eni na vatei vatabuadira Aaron mana lei dalena, ko lavighi na birosona na sheep, kolua nia na ighuna te birosogha, mana raghova te poroa na kutuna. Lavia ghua pilena na ate, me rua na gholamauvo kolui nia na birosoni, mana tuatavuli/botekama/peghe madolo. ");
INSERT INTO nlg_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Vaho ge ko lavia sakai na berete, ma sakai na cake to ule kolua nia na kokolo ni olive, ma sakai na cake madeve tana kei to mua gonia na yeast to talui tua tana matagu. ");
INSERT INTO nlg_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ko talui raini tana limadira Aaron mana lei dalena ma kara hau datoi te vaghaa na heveioli te keha va vaniu. ");
INSERT INTO nlg_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mi murina vaho, ko lavi kehai na lei totobo raini tana limadira, mo ko kerei tana bela ni sukaghi vuvungana na diki sheep te vagha na sukaghi keha vaniu. Na uruuru/angi tana sukaghi eni te liuliogha itagua. ");
INSERT INTO nlg_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Vaho ge ko lavia na garona eruani na sheep ni tabuana Aaron, mo ko hau datoa tana matagu, ke vaghaa na heveioli te keha vaniu. Mo ko lavia keri na ghamua ighoe. ");
INSERT INTO nlg_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Talukehai te vaghaa tara tabu na lei pilena na sheep mane ni vatabu geke vanira Aaronmana lei dalena, kolui na garona mana tuatavulina tara hau datoi tana matagu tana bona ni vatabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mi tana lei bongi ke mai, tana bona rana vure ni Israel kara nia hevei dato na sukaghi ni mabo pana sukaghi ni holouto vaniu inau, Yahweh, na lei pilena na sheep mane raini na tunuvadira haia Aaron mana vinavahuhuna. ");
INSERT INTO nlg_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Nina pupulu tabu Aaron kau righitaonighi vanira na vinavahuhuna ahei tadira ke tughua, ge kara tangomana na siusiuadira mana vatabuadira kara nighi pupulu. ");
INSERT INTO nlg_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ma hei ke ghoi puku ni sonisukaghi i murina Aaron ke nighi pupulu na pupulu raini e vitu na bongi inaghona geke vuivunia na lutu ilokana na Vaevale tapole tabu mana Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ko lavia na sheep to tabura nia Aaron mana lei dalena, mo ko kukia tana bona tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ma Aaron mana lei dalena kara ghania, maia na berete tana kei tana mataula na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ma gaira heghedira vasoo kara ghania na sheep maia na berete ni vatei talukehaani na paludira tana bona ni tabuadira. ");
INSERT INTO nlg_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ma kara mua ghani sokoi na sheep mana berete ni vatabu me ke saravia ke dani ghana, kara kere taghalaghinighi. Kara bei ghanighi gea, na pukuna te tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Gaia eni ko nea iga na tabuadira Aaron mana lei dalena va tana lutudira. Na gehegehe ni vatabu ke tona haliu e vitu na dani. ");
INSERT INTO nlg_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tana sopa lei dani ko nia sukaghi nia sakai na dale buluka mane, te vaghaa na vatei heveioli ni talukeha palu. Mi murina keri ko gonia na heveioli ni marabuana na bela ni sukaghi. Marabua na bela ni sukaghi nia na sukaghi ni talukeha palu mo ko vatabu nia na siusiuana nia na oil. ");
INSERT INTO nlg_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ko va marabua na bela ni sukaghi tuhu dani koekobe ke va sara tana vituni na bongi. Mi murina keri, na bela ni sukaghi ke tabu ngangata, ma siki totobo ghua ke tibelia, ke liliu ni tabu. ");
INSERT INTO nlg_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ma raini na totobo ko nighi sukaghi tana bela ni sukaghi. Ko nighi sukaghi erua na dale sheep tughu dani, ");
INSERT INTO nlg_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","sakai tana roropo ma sakai te nulavi. ");
INSERT INTO nlg_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ko nia sukaghi sakai tadira, kolua nia sakai na kilo ni flour, ko kalu kolua nia sakai na litre ni kokolo ni olive, mo ko nia sukaghi ghua sakai na litre ni wine te vagha na heveioli ni inu. ");
INSERT INTO nlg_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mi tana nulavi ko nia sukaghi sakai na dale sheep, kolua nia na flour mana wine te vaghaa tana roropo. Mi geva na sukaghi keri, ke manilu na uruuruna va itagua, na sukaghi to gonia nia na lake. ");
INSERT INTO nlg_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Na sukaghi kekere eni ighau mana nimiu na vinavahuhu kau gonia haia, me ke tona haliu tana lei vavata ke mai. Kau sukaghia tana matagu inau a Yahweh, tana mataulana na Vaevale tapole tabu, iga inau ku topogho mu ku kokoe kolugho. ");
INSERT INTO nlg_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Igeva iga ku topora iga na vure ni Israel mana Vaevale tapole tabu geva ke tabu nia na rarangagu. ");
INSERT INTO nlg_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Eo, igeva ku nea na Vaevale tapole tabu mana bela ni sukaghi ke tabu ngangata, mi geva ku vili kobera Aaron mana lei dalena ge kara tabu ghua ge kara nigua na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mi geva inau ku kabu tana ghobudira na vure Israel, ge ku didira na God. ");
INSERT INTO nlg_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Gaira kara ghilalaa inau a Yahweh didira na God. Inau agaia tu lavia rughuhoru i Egypt ge ku kabu tana ghobudira. Inau a Yahweh didira na God. ");
INSERT INTO nlg_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Vaho ge ko gonia sakai na bela pile nia na ghai tara vatua nia acacia, na vatei kere ghaiuruuru. ");
INSERT INTO nlg_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ke rua na hangava na darona mana halavuna, mana levu lima/vati na hangava na datona, mo ko gonighi na lei sopa piuna vuvungana te vagha na kala, nia na ghai to gonia nia na bela. ");
INSERT INTO nlg_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Mo ko saroa na vuvungana mana lilighina maia na kalana na bela nia na puku ni gold, mo ko kabe kililia na bela nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tana sarana na gold to kabe kililia nia na bela, ko talui ga erua na ringi gold, sakai ilevu ma ruani ilevuna na bela, na vatei torovaghiniani na ghai ni holaa. ");
INSERT INTO nlg_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Na ghai ni hola ko gonighi nia na ghai na ahana acacia, mo ko poroi nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ko talua na bela ni ghaiuruuru i paribebetena na vokovoko iloka, ighobudira na Bona Tabu mana Bona Tabu Vahotua. Na Bokisi ni Vetena ni Baubahu tabu kolua na bona ni arovi te ghaha imuri na vokovoko keri, mi kakeri ku topogho iga. ");
INSERT INTO nlg_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Tana lei sopa puipungi/roropo, tana bona Aaron ke mai gonidilai na bulu, ke kerea mughua na ghaiuruuru te manilu na uruna tana vuvungana na bela keri. ");
INSERT INTO nlg_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Mi tana lei sopa nulavi tana bona ke mai geke tungighi na bulu, gaia ke ghoi kerea so na ghaiuruuru tana matagu. Ma eni ke tona haliu na goniana taonia na lei vavata ke mai. ");
INSERT INTO nlg_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ko bei nia sukaghi gea siki ghaiuruuru te mua tabu tana vuvungana na bela eni, pana sukaghi kekere, pana sukaghi ni vuavua, pana sukaghi ni wine. ");
INSERT INTO nlg_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Tana tughu niulu, a sakai na tughuru ni va marabuana na bela, nia na daliana na kalana na bela nia na ghabu te lavia tana sukaghi ni talukeha palu. Aeni ke nilabu me ke vetena, sakai na goniana tughu niulu taonia na lei vavata, na pukuna aeni nina bela te tabu ngangata vaniu, inau a Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ma Yahweh te bosa vania Moses me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Tana bona ko idumia na subodira na vure ni Israel, tughu tinoni te haghe tana iduidu ke pelua heghena na poroporoulu vaniu, ge ke mua kalera siki totobo maemategha te vaghaa to idumira tua. ");
INSERT INTO nlg_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Gaira udolu kara nia pelu vaniu na levu/eruani na mava ni silver/shekel te vagha na heveioli. Na kaekagena te vagha na shekel nina Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Gaira udolu tara va sara tua rua hangavulu na niuluna ke, kara nia hevei mughua na rongo ni sukaghi/heveioli vaniu, a Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Mi tana bona na rongo ni sukaghi eni kara nia hevei vaniu, ke va marabua heghena, mana tinoni lologho mana tinoni bona kara nia hevei sakai na vata ni kaekage vamua. ");
INSERT INTO nlg_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ko nia lutu na rongo eni tana lei lutuna/righitaoniana tana Vaevale tapole tabu. Gaia ke na ghanaghanaoliana vanighau, ighau rana Israel, tana matagu, ge kau pelu olira vanira na voladira.” ");
INSERT INTO nlg_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ma Yahweh te bosa vania Moses me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ko gonia na popo sule na vatei sau lima mana tua nia na bronze, mana tuana ghua ke tabe ngasilia. Mo ko talua ighobudira na Vaevale tapole tabu mana bela ni sukaghi, vaho ge ko heoti vonua nia na beti. ");
INSERT INTO nlg_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ma Aaron mana lei dalena mane kara saui ga na tuadira mana limadira, ");
INSERT INTO nlg_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","inaghona kara haghe tana Vaevale tapole tabu ge kara va tate tana matagu, mi naghona kara tonavia va na bela ni sukaghi kekere va itagua. Kara saui haia na tuadira mana limadira inaghonina kara va gehegehe, kara bei mate gea. ");
INSERT INTO nlg_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Na vetena eni ke ngasi me ke tona haliu vanira Aaron mana lei vaivarina, ma kara righitaonia tana lei vavatadira.” ");
INSERT INTO nlg_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ma Yahweh te bosa vanira Moses me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ko lavi kolui na lei ghaiuruuru raini ra lima hangalatu na shekel na kokolo ni myrrh, me rua hangalatu lima hangavulu na shekel na cinnamon te manilu na uruna, me rua hangalatu lima hangavulu na shekel na tovu, ");
INSERT INTO nlg_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","me rua hangalatu lima hangavulu na shekel na cassia, ma sakai na gallon na kokolo ni olive. Ko kaekage na lei ghaiuruuru te vagha na kaekage na shekel ni Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ko ule kolui raini ge kara va tana kokolo tabu na vatei siusiu. ");
INSERT INTO nlg_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ko siusiua nia na kokolo uruuru eni, na Vaevale tapole tabu, maia na Bokisi ni Vetena ni Baubahu tabu, ");
INSERT INTO nlg_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","maia na bela kolua nia na lei hegohego, mana vatei talu bulu mana lei hegohego, maia na bela ni kere ghaiuruuru, ");
INSERT INTO nlg_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mana bela ni sukaghi maia na hegohego, maia na popo sule kolua nia na tuana na vatei sau lima mana tua. ");
INSERT INTO nlg_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ko va tabui raini ge kara puku ni tabu. Mi murina eni, siki totobo ke tibelira ke liliu ni tabu ghua. ");
INSERT INTO nlg_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ko siusiura nia na kokolo eni a Aaron mana lei dalena mane, ko va tabura ge kara tangomana na gehegehe tana matagu ta vagha na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Mo ko bosa vanira na vure ni Israel, ‘Aeni a nigua na kokolo tabu ni vatei siusiu haia. ");
INSERT INTO nlg_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Me ke bei kaikavia gea tana hulina siki tinoni lee, me ke bei gonia gea na kokolo eni ge ke vania heghena. Ma kau nea/nia kikinimaa/talumavaa na pukuna te tabu. ");
INSERT INTO nlg_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ma hei ke kalua me ke gonia te vaghaa na kokolo eni, pe ke dalia va tana hulina siki sakai te mua manesukaghi ke, ku soni kehaa tana ovu ni tinoni ni Israel.’” ");
INSERT INTO nlg_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ma Yahweh te bosa vania Moses, “Ko lavikolui na lei uruuru te manilu raini, ke sakai na kaekage vasoo, stacte, onycha, galbanum, mana puku ni frankincense. ");
INSERT INTO nlg_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ko gonighi te vaghaa rahei tara goni uruuru, goni marabui ge kara liliua na uruuru te tabu me marabu. ");
INSERT INTO nlg_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ko tutui na pileni ma kara liliu ni ghura, mo ko talui na balu inaghona na Bokisi ni Vetena ni Baubahu tabu, iga ku topogho tana lokana na Vaevale tapole tabu. Kau nia kikinima/talumavaa/nea na uruuru eni geke tabu ngangata. ");
INSERT INTO nlg_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kau bei gonia gea na uruuru eni geke vanighau heghemiu. Kau talu tabalilia vaniu a Yahweh, ma kau nea geke tabu. ");
INSERT INTO nlg_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ma hei ke gonia geke nia togotogo vaghaa na kokolo uruuru, ku sonikehaa tana ovu ni tinoni ni Israel.” ");
INSERT INTO nlg_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ma Yahweh te ghoi bosa vania so Moses, ");
INSERT INTO nlg_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ko righia, inau tu vilia tua Bezalel na dalena Uri, na kukuana Hur, tana kemana Judah. ");
INSERT INTO nlg_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mi nau tu vonughia nia tua nigua na tarunga, mu vahea na ghilala mana manaha sule, me ghilalai na lei vata ni lutu te kehakeha. ");
INSERT INTO nlg_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Gaia te tangomana na goniani na lei totobo te kehakeha me utoutoa nia na gold, mana silver mana bronze. ");
INSERT INTO nlg_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ma gaia te ghilalaa na sariani na vatu vaguvagu maia na ghai. Eo, gaia te ghilalai na lei vata ni sarisari te kehakeha! ");
INSERT INTO nlg_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mi nau tu vilia ghua Oholiab na dalena Ahisamach tana kemana Dan, ge ke lutu kolua. Inua tu vahea ghua na manaha tana lei mane lutu keha ge kara tangomana na goniani na lei totobo ku bosai vanigho na goniani, ");
INSERT INTO nlg_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","na Vaevale tapole tabu, maia na Bokisi ni Vetena ni Baubahu tabu mana papatana, aeni na bona ni toghipalu, mana lei hegohegona na Vaevale tapole tabu - ");
INSERT INTO nlg_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","na bela mana lei hegohegona, na ghaitughuru na vatei talubulu tara gonia nia na gold maia na lei hegohegona, maia na bela ni kekere na uruuru, ");
INSERT INTO nlg_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","na bela ni sukaghi kekere mana lei hegohegona, na pupu ni sasau mana tuana, ");
INSERT INTO nlg_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","nina pupulu Aaron na manesukaghi, maia didira na pupulu dalena kara nighi pupulu tana bona kara gehetighi na lutu ni manesukaghi, ");
INSERT INTO nlg_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","na kokolo ni siusiu, mana uruuru tabu vania na Bona Tabu. Kau goni taonia mughua tua na lei hava tu bosai vanigho.” ");
INSERT INTO nlg_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ma Yahweh te ghoi bosa vania so Moses, ");
INSERT INTO nlg_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ko bosa vanira na vure ni Israel ge kara righitaonia nigua na bongi ni Sabbath, na pukuna na Sabbath na vaughilalana nigua na baubahu ighobuda ighau maia inau ke va me va. Gaia ke hangaghau ge kau ghanaghana haia inau a Yahweh tu gonighau tabu ge kau nigua na vure. ");
INSERT INTO nlg_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Eo, kau righitaonia na Sabbath na pukuna te tabu. Ma hei ke diua kau mate mughua, ma hei ke lutua na hava tana bongi keri kara sonikehaa tana vuresubo. ");
INSERT INTO nlg_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","E ono vasoo na bongi kau lutu iga, me vituni na bongi nigua puku ni bongi ni aheahe. Ku ghoi bosa olia so, na pukuna inau Yahweh te va tabua, ma hei ke lutu tana Sabbath, kara mate mughua. ");
INSERT INTO nlg_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ghau na vure ni Israel, kau righitaonia na Sabbath ke va me va. ");
INSERT INTO nlg_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Gaia na vaughilala ke ghana kasilaa ta nigua na vetena itadira na vure ni Israel. Na pukuna ilokana e ono na bongi nau, a Yahweh, tu gonia na kokou mana pari, mu aheahe tana vituni na bongi.” ");
INSERT INTO nlg_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mi tana bona Yahweh te kokoe soko kolua Moses tana vuvungana na ghotu Sinai, God te vahea erua na midi ni vatu te gerei ga na vetena te gerei nia na gigirina heghena. ");
INSERT INTO nlg_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Tana bona Moses te mua mina geke sughi horu mai tana ghotu, na vure tara va ta Aaron mara bosa vania, “Na tinoni eni a Moses, gaia te lavighi mai iani sania i Egypt te tona me mua oli mai, mai mua ghilalaa na hava te kalea. Keri ge ko gonia vanighai siki god ke tangomana ge ke hulighai.” ");
INSERT INTO nlg_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ma Aaron te ghaghua vanira, “Kau huighi na damukuli gold tana kulidira na lei taumiu, mana lei dalemiu na lei garimane mana lei tahula, ma kau holai vaniu mai.” ");
INSERT INTO nlg_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ma gaira udolu tara taonia Aaron mara lavighi vania mai na ghadira na damukuli gold. ");
INSERT INTO nlg_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ma Aaron te lavighi na gold me obolaghinighi me goni taonia nia na dale buluka mane. Mana vure tara nia bosa laga na manga sule, “Israel, aeni na god te lavi rughuhorughita mai i Egypt!” ");
INSERT INTO nlg_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Tana bona Aaron te righia na hava te kale, gaia te gonia na bela ni sukaghi inaghona na dale buluka gold ge ghaghua, “Iropo na bongi ni gougonu mana vangakolu vania Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Keri ke, na vure tara tughuru roropo mara kere sukaghi maia na heveioli ni mabo. Mi murina eni, gaira tara vangakolu mara inu beer/wine mara togotogo, mara riui na ghanaghanadira va tana titinoni ghavai tana bona/halautu te mua uto. ");
INSERT INTO nlg_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ma Yahweh te bosa vania Moses, “Ko mina! Mina mo ko sughi! Na vure to lavi rughuhorura mai i Egypt tara va metora heghedira tua. ");
INSERT INTO nlg_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Gaira tara ririu sania tua na halautu tu bosaa vanira ge kara taonia, mara gonia na titinonina na dale buluka, mara sukaghia mara kikinima vania. Mara ghaghua, ‘Aeni dida na god te lavi rughuhorughita mai Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Inau tu righia taeni didira na toba ngasi mana diu vetena na vure raini. ");
INSERT INTO nlg_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Itaeni inau tu rutu ngangata vanira, ma nigua na rutu ke vusi taghalaghinira. Ko bei hoveu gea! Vaho ge ku negho ighoe mana vinavahuhumu na kema sule ma kau sepalaghi tughuru gaira.” ");
INSERT INTO nlg_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Hauva, Moses te nongi ngangataa a Yahweh nina na God geke bei nea gea te vaghaa, me bosa me ghaghua, “Ivei tea geo rutu ngangata vanira nimua na vure to lavi rughuhorura mai Egypt nia na maana mana lei gehegehe sule? ");
INSERT INTO nlg_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Rana vure ni Egypt kara bosa, ‘Yahweh te pegora ge kara mai tana lei ghotu ge ke matera me ke taghalaghinira.’ Ko ririu ta nimua na rutu, mo ko tughua na liomu tana tataghalaghi sule eni to gonidilaa vanira nimiu na vure. ");
INSERT INTO nlg_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ko ghanaghana olia nimua na baubahu vanira nimua na tinoni lutu Abraham, Isaac ma Jacob, mo papari vanira ge ko nea na vaivaridira vaghara na lei veitughu i kokou. Eo, mo ko vahera na pari to nia baubahu vanira na vaivaridira ma kara logho kasilaa.” ");
INSERT INTO nlg_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ma Yahweh te tughua na liona me lavikehaa nina ghanaghana ge ke taghalaghinira nia. ");
INSERT INTO nlg_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ma Moses te ririu me sughi horu tana ghotu. Gaia te tabei tana limana erua na midi ni vatu te gerei ga God na vetena, te gerei na naghoni mana murini. ");
INSERT INTO nlg_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Na midi ni vatu raini a nina lutu God heghena, me gerei nia na limana. ");
INSERT INTO nlg_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Tana bona Joshua te rongovi horura na vure tara ngingili i pari, gaia te mina bosa vania va Moses, “E vaghaa na ngingili ni veitotoghoni tana komu.” ");
INSERT INTO nlg_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Hauva, Moses te bosa tughu vania, “Taho, e mua ngingili ni lagavule tana veitotoghoni, na ngingili ni togotogo.” ");
INSERT INTO nlg_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mi tana bona toro dutuvia na bona tara ghahara iga na vure, Moses te righia va na dale buluka mana ghavai. Ma gaia te rutu ngangata, me soni paruhai erua na midi ni vatu tana pukuna na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ma Moses te lavia na dale buluka tara gonia me obolaghinia tana lake. Mi tana bona te bihi, gaia te paruparuha vaghaa na poke me kalua nia na beti, me nera na vure gera inuvia. ");
INSERT INTO nlg_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mi murina eni te bosa vania Aaron, “Na hava tara gonia vanigho na vure raini, mana hava te ghua geo hola mai na palu dika ngangata eni tana vuvungadira?” ");
INSERT INTO nlg_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ma Aaron te bosa tughu vania, “Ko bei rutu vaniu gea. Ighoe heghemu to ghilalara na vure ini te ghaghua iga na liodira ge kara gonighi na lei totobo dika. ");
INSERT INTO nlg_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Gaira tara mai bosa vaniu, ‘Na tinoni eni a Moses, gaia te lavighi mai iani sania i Egypt te tona me mua oli mai, mai mua ghilalaa na hava te kalea. Keri ge ko gonia vanighai siki god ke tangomana ge ke hulighai.’ ");
INSERT INTO nlg_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mi nau tu bosa vanira, ‘Kau bihui mai na ghamiu na damukuli gold ma kau lavighi mai.’ Tana bona tara lavighi vaniu mai, inau tu sonighi va tana lake me va horu mai ga na dale buluka eni!” ");
INSERT INTO nlg_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mi tana bona Moses te righia Aaron te hahilaghinira na vure mara bule tana matadira na ghadia levunimate, ");
INSERT INTO nlg_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","gaia te tughuru tana mataulana na komu me nia kokoe na manga sule, “Ahei te palangia Yahweh, ke mai iani tagua!” Ma gaira udolu na kema ni Levi tara mai tatana. ");
INSERT INTO nlg_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Keri ke, gaia te bosa vanira, “Aeni na hava te bosaa Yahweh, na God ni Israel, ‘Kau kabei nimiu na isi tana gehimiu, ma kau oli va tana komu ma kau vuni sodu me ke sara i soduna na komu, ma kau labu matera na lei hoghomiu mana lei kulamiu mana ghamiu na komukolu.’” ");
INSERT INTO nlg_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mana lei vaivarina Levi tara taonia Moses, me kaekagena e tolu na togha ni tinoni tara mate tana bongi vaghana keri. ");
INSERT INTO nlg_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ma Moses te ghaghua vanira, “Itaeni ighau au va tabughau va ta nina lutu Yahweh, na pukuna tau taonia na liona sakai vamua tau labumatera na lei puku ni dalemiu mana hoghomiu. Mana pukuna eni, gaia ke vaheghau na vauto te sule.” ");
INSERT INTO nlg_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mete dani ghana Moses te bosa vanira na vure, “Ighau tau gonia na palu te dika ngangata. Mi taeni ku ghoi dato va ta Yahweh tana kouna na ghotu. Sogea ke vaheu na talukeha palu vanighau.” ");
INSERT INTO nlg_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Keri ke, Moses te va ta Yahweh me ghaghua, “Na vure ini tara gonia na palu te dika ngangata, ara gonia gold ge ke god vanira. ");
INSERT INTO nlg_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mi taeni, inau tu nongi ngangatagho ge ko talukehai na paludira, me ke taho ke, mo ko ghuduri kehau ta nimua na buka to gerei na ahadira nimua na vure.” ");
INSERT INTO nlg_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma Yahweh te bosa tughu vania Moses, “Inau ku ghuduri kehaa rahei kara tangohahi savuu ta nigua na buka. ");
INSERT INTO nlg_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Mi taeni, ko tona, mo ko hulira na vure va tana komu tu bosaa vanigho tua. Ko righia! Nigua na angel igeva ke idevighau! Hauva, tana bona ku mai ikakeri vaho ge ku tororo na vure eni nia na lei paludira.” ");
INSERT INTO nlg_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Keri ge Yahweh te nia vetena mai tana vuvungadira na vure na vahaghi maemategha na pukuna tara kikinima vania na dale buluka gold te gonia Aaron. ");
INSERT INTO nlg_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Keri ke, Yahweh te bosa vania Moses, “Ighoe to lavi rughuhorura mai Egypt na vure raini, ko hulira va tana butonikomu tu nia baubahu vanira Abraham, Isaac ma Jacob. Idania, mu bosaa vanira tua ku vahera na butonikomu keri maia na lei vinavahuhudira. ");
INSERT INTO nlg_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mi nau ku nia vetena nigua na angel ke idevighau me ke ghuru kehara na lei kema tara ghahara iga, rana vure ni Canaan, mi Amor, mi Heth, mi Periz, mi Hiv, maia Jebus. ");
INSERT INTO nlg_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Na pari te tave iga na susu ni buluka mana kokolo ni midua. Mi nau ku mua nighau udukolu, na pukuna tau kutuvatu/toba ngasi mau diu vetena/diudiu. Ma ge ku tona kolughau, ku vuha taghalaghinighau gea tana ghobu ni halautu.” ");
INSERT INTO nlg_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mi tana bona na vure tara rongovighi na lei bosa ni lavi mataghu raini, gaira tara dikalio mara hove na taluani na ghadira vaguvagu. ");
INSERT INTO nlg_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Na pukuna a Yahweh te bosa vania Moses ge ke bosa vanira nia, “Gaira na vure tara kutuvatu/toba ngasi mara diu vetena/diudiu. Ke vagha inau itamiu hughua na pile bona vamua, ku taghalaghinighau. Me vaghaa keri kau talu kehai tamiu na vaguvagumiu koekobe ku ghilala na hava ku gonia vanighau.” ");
INSERT INTO nlg_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Keri ke, rana vure ni Israel te vuivuni tara tughuru sania na Ghotu Sinai ara mua talua siki vaguvagu tana hulidira. ");
INSERT INTO nlg_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mete vaghaa haia na nilabuna tua Moses, gaia te va tughuruvaghinia na tapole tabu i pari bebetena me sagauvia na bona tara ghahara iga na vure. Gaia te vatua nia, “Na tapole te vaukolu kolua Yahweh.” Ma hei tadira na vure ke liona geke kokoe kolu a Yahweh, ke va iga. ");
INSERT INTO nlg_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mi tana bona Moses ke va tana tapole te vaukolu, gaira udolu kara tughuru tana mataulani na lei tapole/valedira, ma kara bungutia va koekobe ke va haghe. ");
INSERT INTO nlg_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mi tana bona te va haghe tana tapole keri, na ghoghopa daro ke horu mai me mai beto tana mataulana na tapole tana bona a Yahweh te kokoe kolua Moses. ");
INSERT INTO nlg_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tana bona na vure tara righia te vaghaa, tara tualaghi tuturu mara poghotao. ");
INSERT INTO nlg_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ma Yahweh te tate vania Moses me kokoe kolua vaghaa na tinoni te kokoe vania na kulana. Mi murina keri Moses te pulohi tana komu, hauva ma Joshua, na dalena Nun, na garimane nina tinoni lutu Moses, te kabu so imuri tana tapole te vaukolu. ");
INSERT INTO nlg_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ma Moses te bosa vania Yahweh, “Ighoe to bosa vaniu tua ge ku lavira na vure ini va tana butonikomu baubahu. Hauva, mo mua bosaa vaniu ahei ke niu udukolu. Mi ghoe to holoa na ahagu mo bosa vaniu to loghoa na liouto itagua. ");
INSERT INTO nlg_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Me ke vaghaa keri ke, inua tu nongi ngangatagho ge ko tuhua vania na liomu, ge ku ghilala utoa mu ku goni kalea na hava to liona ge ku gonia. Mo ko bei nia ponolio na kema eni animua na vure.” ");
INSERT INTO nlg_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ma Yahweh te bosa tughu vania Moses, “Inau heghegu ku tona kolugho, mu ku vahegho na kabu aheahe.” ");
INSERT INTO nlg_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ma Moses te bosa vania, “Ke vaghaa ko mua nighai udukolu ke, mo ko bei lubatighai gea ge kai tona keha tana bona eni. ");
INSERT INTO nlg_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ke vagha ko mua nighai tona kolu ke, mi vei ke ghaghua ahei ge ke ghilalaa nimua na vure raini mi nau to loghoa na liouto vanighai? Hauva, ma ge ko nighai tona kolu ke, na lei tinoni tana maramana udolu kara ghilalaa tai mua vaghara mai keha itadira.” ");
INSERT INTO nlg_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ma Yahweh te bosa tughu vania Moses, “E utuni inau ku gonia na hava to nongia, na pukuna tu loghoa na liouto itamua, mu ghilalagho nia na ahamu.” ");
INSERT INTO nlg_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Keri ge Moses te ghoi nongia so sakai na totobo, “U nongi ngangatagho, ko talagu ge ku righia na mararamu mana rongoraghamu.” ");
INSERT INTO nlg_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ma Yahweh te bosa tughu vania, “Igeva ku nei nigua na lei uto mana liouto ke mai tona haliu tana matamu, mu ku bosa ladaa vanigho na ahagu, a Yahweh. Mi nau ku tatea na liouto mana veiarovi vania ahei ku vilia. ");
INSERT INTO nlg_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hauva, ko mua tangomana ge ko righia mai na matagu, e taho ahei ke righia na matagu me ke vola. ");
INSERT INTO nlg_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ko tughuru tana vuvungana na vatu eni tana lilighigu. ");
INSERT INTO nlg_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mi tana bona na rongoraghagu/rarangagu ke mai tona haliu, igeva ku talu horugho tana sosogholana na vatu mu ku saro pungisigho nia na limagu koekobe ku tona padi. ");
INSERT INTO nlg_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Vaho ge ku lavikehaa na limagu, ge ko righia na murigu, mana matagu ko mua righia.” ");
INSERT INTO nlg_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ma Yahweh te bosa vania Moses, “Ko gonidilai erua na midi ni vatu vaghai erua na diki vatu to soni paruhai, mu ku gere vanighi na lei bosa tana erua na diki vatu. ");
INSERT INTO nlg_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ko gonidila i ropo tana puipungi ge ko dato mai tana Ghotu Sinai, ge ko mai topou iga tana vuvungana na ghotu. ");
INSERT INTO nlg_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Me ke bei nigho udukolu mai gea siki sakai, mu mua lubatia ghua ahei geke datovia mai na ghotu. Mo ko bei lubatia siki buluka pa siki maumanu ke vangavanga dutuvia na ghotu.” ");
INSERT INTO nlg_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ma Moses te sarighi erua na midi ni vatu vaghai erua na diki vatu. Me labota lamolamo mua, gaia te sei dato tana Ghotu Sinai te vaghaa Yahweh te bosa vania nia, me holai erua na midi ni vatu tana limana. ");
INSERT INTO nlg_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ma Yahweh te horu mai tana ghoghopa daro/te tughuru vaghaa na bere sule, me holoa heghena na ahana, “Yahweh,” ma Moses te tughuru iga tana matana. ");
INSERT INTO nlg_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ma gaia te mai tona haliu inaghona Moses ge ghaghua, “Inau a Yahweh! Inau a Yahweh, na God te veiarovi me liouto. Inau tu mua mina rutu, me vonughiu na dolo te sule me utuni. ");
INSERT INTO nlg_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Inau tu tatea na dole sule vanira na lei togha ni vavata nia na talukehani na lei vata ni palu mana dika. Me vagha ghua ku mua sania na toroana na palu, mu ku torora na lei daledira mana kukuadira nia na paludira na tamadira mana tinadira me ke va sara tana toluni mana vatini na vavata.” ");
INSERT INTO nlg_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ma Moses te mina me poghotao tana pari me kikinima. ");
INSERT INTO nlg_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ge ghaghua, “Yahweh, ke vaghaa ko righi utou tana matamu ke, inau ku nongi ngangatagho ge ko nighai udukolu. Eo, na vure raeni tara kutuvatu mara diu vetena/diudiu, hauva, inau tu nongigho ngangatagho ge ko talukehai nimami na hahi mana palumami. Mo ko lavipangotighai te vaghaa nimua na puku ni vure/totobo lologho.” ");
INSERT INTO nlg_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ma Yahweh te bosa tughu, “E uto! Aeni na baubahu ku gonia vanighau. Inau ku gonighi na lei butuli tana matamiu tu mua gonighi mua tana maramana maia ta siki kema. Ighau mana lei kema kililighau kara niu kikinima, mara ghilala inau, Yahweh, ku gonighi na lei butuli raini vanighau. ");
INSERT INTO nlg_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Keri ge kau taonighi na lei vetena tu vaheghau itaeni. Mi nau ku ghuru kehara rahei tara tughuru pungisia na halautumiu, rana vure ni Amor, mi Canaan, mi Heth, mi Periz, mi Hiv mi Jebus. ");
INSERT INTO nlg_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ma kau bei gonia siki baubahu itadira na vure raini tana butonikomu kau va iga, na pukuna kau taonighi gea na lei halautudira te dika. ");
INSERT INTO nlg_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kau haurakei ma kara tumuhoru didira na lei bela ni sukaghi, ma kau horui ma kau labu paruhai didira na vatu daro tara tughuruvaghi nighi mara kikinima vanira, ma kau toka horui didira na lei titinoni Asherah tara sarighi. ");
INSERT INTO nlg_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kau bei kikinima vania gea siki god keha, na pukuna inau Yahweh tu ghaghana ge kau liosakai vaniu/itagua. ");
INSERT INTO nlg_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Kau bei gonia siki baubahu kolura na vure tara kabu tana butonikomu keri, na pukuna tana bona tara kikinima didira na lei god keha mara sukaghi vanira, gaira kara kurutighau ge kau taonira, ma kau ghanighi na lei sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Mi geva ke vagha kau lavira na lei daledira na tahula tara kikinima vanira na lei god keha ge kara taudira na lei dalemiu na garimane ke, ma kara nera na lei dalemiu garimane ge kara tangotangodika savuu nia na kikinima vaniadira na lei god keha. ");
INSERT INTO nlg_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kau bei gonia vanighau heghemiu gea siki god keha. ");
INSERT INTO nlg_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ma kau ghanaghana na righitaoniana mana ghaniana na Berete Gulu e vitu na bongi. Te vaghaa tu taraighau nia tua, ke saravia na vula Abib tana tughu niulu iga, kau ghania, na pukuna na vula keri tau sania mai Egypt. ");
INSERT INTO nlg_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Na lei kamanagho mane ke a nigua, me vagha ghua na buluka mana sheep. ");
INSERT INTO nlg_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Na kamanagho mane na donkey kau pelu oil nia na volana itagua nia na hevei va sakai na dale sheep ge ke tughua na malana. Ma kau ghanaghana kau mua tughua ke, ma kau matea mughua na donkey nia na gotiana na luana. Hauva, kau pelu olira mughua na lei kamanagho mane, me ke bei mai tata gea tana matagu ahei ke mua lavia mai nina heveioli. ");
INSERT INTO nlg_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“E ono na bongi tu talu kehai kau lutu iga, mi tana na Sabbath kau aheahe iga, sakai vamua tana bona ni ivu mana ghegheli. ");
INSERT INTO nlg_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Kau ghanaghana na Bongi/Gougonu ni Lavinivogha nia vangakolu mana togotogo na diki lavinivogha ni wheat, me ke vagha ghua na Bongi/Gougonu ni Baebale tana sosokona na hola koluana na vavanga mana wheat. ");
INSERT INTO nlg_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tana tughu niulu, e tolu na tughuru ni mai tate tana matagu inau Yahweh, na God ni Israel. ");
INSERT INTO nlg_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Inau ku ghuru kehara na lei kema tara tughuru pungisia na halautumiu mu ku ghadaru sulea na riritina na pari, me taho ahei ke hughutighau me ke lagavulea nimiu na pari tana bona kau mai tate tana matagu e tolu na bona keri tana tughu niulu. ");
INSERT INTO nlg_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kau bei vaheu mai gea na berete tau goni kolua nia na yeast, tana bona kau sukaghi na maumanu vaniu. Ma kau bei talua gea me ke dani kuvia tana roropoghana na dale sheep ni Lovovule tau mua ghania soko. ");
INSERT INTO nlg_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Kau holai mai tughu niulu tana valegu, inau a Yahweh, nimiu na God, na vuivuni na vanga ni subai tau holai ta nimiu na leghai tana bona ni lavinivogha. “Kau bei ghalatia nia gea na dalei sheep pana goat nia kokolo ni susuna tinadira.” ");
INSERT INTO nlg_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ma Yahweh te bosa vania Moses, “Ko gere horui na lei bosa ni baubahu raini, na pukuna na lei bosa raini te vaughilalaa nigua na baubahu itamua ighoe maia na vure ni Israel.” ");
INSERT INTO nlg_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ma Moses te kabu so tana kouna na ghotu kolua Yahweh e vati hangavulu na bongi mana dani, me mua vanga me mua inu. Mi tana bona vaghana keri gaia te gerei na lei bosa ni baubahu maia na Hangavulu na Vetena tana vuvungani na midi ni vatu. ");
INSERT INTO nlg_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Tana bona Moses te sughi horu mai tana ghotu, te holai na midi ni vatu te gerei ga na bosa ni baubahu, ma gaia te mua ghilala na matana mana ihuna te marara na pukuna te kokoe kolua Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mi tana bona Aaron maia na vure ni Israel tara righia te marara na matana mana ihuna ke, gaira tana mataghu ge kara mai dutuvia. ");
INSERT INTO nlg_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma hauva, Moses te holora me nongira Aaron mana lei mane nagho itadira na vuresubo, ge kara mai ma kara kokoe kolua. ");
INSERT INTO nlg_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mi murina keri, gaira udolu na vure tara mai tatana, ma Moses te vahera na lei vetena te vahea Yahweh tana vuvungana na Ghotu Sinai. ");
INSERT INTO nlg_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mi tana bona te kokoe soko vanira, gaia te saroa na matana nia na tivi. ");
INSERT INTO nlg_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mi tana lei bona ni aho ke haghe tana Vaevale tapole tabu ge ke kokoe kolua Yahweh, gaia te lavikehaa na tivi koekobe ke ghoi horu mai. Vaho ge ke vahera va na vure ne lei vetena te vahea Yahweh, ");
INSERT INTO nlg_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","mana vure kara righia na matana mana ihuna Moses te marara. Mi murina vaho ge ke ghoi saroa sono koekobe ke ghoi oli me ke kokoe kolua Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ma Moses te holo kolura na vure me bosa vanira, “Kau bei diui gea na lei vetena raini te bosai Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","E ono vamua na bongi kau lutu iga ta sakai na week, me vituni na bongi, na bongi tabu ni aheahe, na Sabbath nina Lord. Ma hei ke lutu tana bongi keri, ke mate mughua. ");
INSERT INTO nlg_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ma kau bei kerua gea na lake tana lei valemiu tana bongi keri.” ");
INSERT INTO nlg_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ma Moses te bosa vanira na vure, “Aeni na hava te nia vetena Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ighau udolu kau lavighi mai raini na vatei heveioli vania Yahweh, na gold mana silver mana bronze, ");
INSERT INTO nlg_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","na vuvulu ni sheep te reirei vagha na horara, boibongi pana sisi, na tivi pura utoutoa, na tivi pura tara vauhia nia na ghuighuli ni goat; ");
INSERT INTO nlg_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","na ghuighuli ni sheep mane tara gonia me sisi, na ghuighuli na maumanu te malebo, maia na ghai tara holoa nia acacia, ");
INSERT INTO nlg_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","na kokolo ni olive vanira na lei bulu, na raurau ni ghai te gasuva vania na kokolo tabu ni siusiu maia na ghaiuruuru te manilu na uruna, ");
INSERT INTO nlg_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","na vatu sisi utoutoa/vitiviti tara holoa nia na onyx, maia ghua na balu vatu vitiviti/utoutoa so kara talui tana sosokona didira pupulu na puku ni sonisukaghi tara holoa nia na ephod, mana sasaro garo. ");
INSERT INTO nlg_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Ighau na lei mane tau ghilalaa na goniani na lei totobo utoutoa, kau mai udolu ma kau lutui na lei totobo raini te vaghaa a Yahweh te nighi vetena, ");
INSERT INTO nlg_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","na Vaevale tapole tabu maia na sasarona, na sinagaura ni vatei tariani, na ihola mana bere maia na pukuni kara nighi tughuru, ");
INSERT INTO nlg_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","mana Bokisi ni Vetena ni Baubahu tabu maia erua na ghai ni hola, mana vovongona na bona ni toghipalu, ni tivi ni vokovoko iloka te pungisia na Bokisi ni Vetena ni Baubahu tabu tana puku ni Bona Tabu, ");
INSERT INTO nlg_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mana bela maia erua na ghai hola ni holaana, maia na lei totobona, mana berete ni vatei sukaghi, ");
INSERT INTO nlg_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","mana vatei talu bulu mana hegohegona, na bulu maia na kokolona, ");
INSERT INTO nlg_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","mana bela ni kere ghaiuruuru maia na lei hegohegona, maia erua na ghai ni holana, na kokolo ni siusiu mana uruuru te manilu na uruna, mana tivi ni voko pungisiana na mataulana na Vaevale tapole tabu, ");
INSERT INTO nlg_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","mana bela ni kere sukaghi mana lei hegohegona, maia na ghai ni holaana, mana kei ni bronze te vagha na vugho, mana popo sule na vatei sasau maia na tuana ke sopou iga, ");
INSERT INTO nlg_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","mana tivi ni vokoana na pilupilu, na bere mana pukuni kara nighi tughuru mana tivina na mataulana na Vaevale tapole tabu, ");
INSERT INTO nlg_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","mana alona na Vaevale tapole tabu mana pilupilu, maia na totobo kara tupi horui tana pari kara pitighi ga na alo, ");
INSERT INTO nlg_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","mana lei tivi utoutoa vanira na manesukaghi kara nighi pupulu tana bona kara lutu tana Bona Tabu, na tivi kiri vanira Aaron mana lei dalena kara nighi pupulu tana bona tara lutua na lutu ni manesukaghi.” ");
INSERT INTO nlg_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ma vure subo tara sania Moses mara tona tana lei valedira ge kara gonidilai didira na vatei heveioli. ");
INSERT INTO nlg_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ma gaira tara puku ni liona tana tobadira ge kara hevei, gaira tara holai vania Yahweh didira na heveioli vania na Vaevale tapole tabu, mara holai mai ghua na lei totobo kara gonighi nia na lei tivi tabu. ");
INSERT INTO nlg_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mana lei mane mana vaivine tara liona na hevei tana tobadira tara mai. Mana balu itadira tara holai mai vania Yahweh na gold, na pepetaka, na siraku mana damukuli. Gaira tara holai mai na lei vata ni totobo tara gonighi nia na gold vania Lord. ");
INSERT INTO nlg_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mana balu itadira tara holai mai na ghalo ni suki tivi. Na ghalo te ghioghio, me boibongi me sisi, mana tivi pura maia na vuvulu ni goat na vatei vau tivi. Mana balu tara nighi hevei na ghuighuli ni sheep mane te sisi mana ghuighuli ni maumanu te malebo. ");
INSERT INTO nlg_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mana balu tara holai mai na silver mana bronze didira na vatei heveioli vaniaYahweh, ma gaira ghua tara loghoi na ghai tara vatua nia acacia, tara holai mai. ");
INSERT INTO nlg_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ma gaira udolu na lei vaivine tara ghilala utoa na susuki mana goniani na ghalo ni susuki, tara gonidilai na ghalo te boibongi, me ghioghio me sisi, mara holai mai. ");
INSERT INTO nlg_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Mana lei vaivine tara manahana uto mara lagalaga na vauhiana na tivi nia na vuvulu ni goat. ");
INSERT INTO nlg_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ma gaira na lei mane huhuli tara holai mai na puku ni vatu vitiviti/utoutoa tara vatua nia onyx, maia na balu puku ni vatu ghua iga, ge kara talui va tana ephod mana sasaro garo nina Aaron/na puku ni sonisukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ma gaira tara holai mai ghua na lei raurau te utoutoa na uruni, mana kokolo ni olive na vatei bulu, mana kokolo ni olive na vatei siusiu, maia na ghaiuruuru. ");
INSERT INTO nlg_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mana vure ni Israel tara liona na hahanga tana lei lutu te vahera Yahweh te bosai vania Moses, tara holai mai didira na heveioli. ");
INSERT INTO nlg_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ma Moses te bosa vanira na vure, “A Yahweh te vilia tua Bezalel dalena Uri, na kukuana Hur, tana kemana Judah. ");
INSERT INTO nlg_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A Yahweh te vonughia nia nina Tarunga God, me vahea na manaha te sule mana ghilala ge ke gonighi na lei vata ni totobo. ");
INSERT INTO nlg_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Gaia ke tangomana na goniani na lei vata ni totobo nia na gold, silver mana bronze. ");
INSERT INTO nlg_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Gaia te ghilalaa ghua na sariani na puku ni vatu utoutoa/vitiviti me ke vaguvagui, me sarighi na ghai. Gaia te ghilala utoi na vata ni lutu kehakeha te vaghai raini. ");
INSERT INTO nlg_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","A Yahweh te vahea gaia ma Oholiab dalena Ahisamach tana kemana Dan, ge koro tangomana na taraiadira ghua na balu na goniani na lei lutu raini. ");
INSERT INTO nlg_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","A Yahweh te vahera na manaha ni sariani na lei puku ni vatu, mana vaguvaguani nia na lei totobo toro gonighi, maia na vauvau mana nighi suki kirikiri na ghalo te ghioghio, me boibongi, me sisi va tana tivi selo malebo. Rogaira toro ghilala utoi na lei totobo ta liona tana lutu. ");
INSERT INTO nlg_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ma Bezalel ma Oholiab maia na lei mane te vahera na manaha mana ghilala a Yahweh, na goniani na lei totobo tana Vaevale tapole tabu te vaghaa te bosaa Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ma Moses te bosa vanira Bezalel ma Oholiab ge koro vuivunia na lutu, kolura nia na lei mane te vahera na manaha Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ma Moses te vahera na lei totobo tara nighi hevei na vure, ge kara goni sokoa nia na Vaevale tapole tabu. Mi tana tughu puipungi na vuresubo tara holai mai soo didira dolo sakai vamua tara hevei tua. ");
INSERT INTO nlg_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Hauva, na lei mane lutu tara tughuru sania na lutu mara va padapada kolua Moses, ");
INSERT INTO nlg_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mara bosa vania, “Itaeni te subo vuleghaitua na lei totobo kai goni sokoa nia na lutu te vaheghai Yahweh ge kai lutua.” ");
INSERT INTO nlg_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Keri ge Moses te nia hevei na bosa, mana bosa eni te talighutia na komu, “Kau beto tua na holaana mai siki totobo itaeni! E subo vulea tua na lutu na lei totobo tau holai mai tua.” Mana vure tara beto na holaani mai didira na dolo. ");
INSERT INTO nlg_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Didira na kolukolu te au vulea na goni soko udoluana nia na lutu. ");
INSERT INTO nlg_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Na vuivuni gaira na lei mane tara manahana na vauvau, tara vauhighi ara hangavulu na selo nia na ghalo malebo. Ma sakai tadira na lei mane lutu te vaguvagui me sukighi ga na totoghalena na cherubim nia na ghalo te ghioghio, me boibongi me sisi. ");
INSERT INTO nlg_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Na selo kiri te sakai na vata vamua na daroni mana halavuni, e vitu na ghoto na daroni ma sakai a ghoto na halavuni. ");
INSERT INTO nlg_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Me lima itadira tara suki kolui geke sakai vamua na tivi daro, mara ghoi nei ghua iga ara lima. ");
INSERT INTO nlg_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mara gonighi e lima hangavulu na ringi nia na tivi ghioghio mara pasulaghinighi va tana sosokoni na selo daro. ");
INSERT INTO nlg_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Me lima hangavulu na ringi tana diki selo te kaekage va tana ringi tana ruani na selo. ");
INSERT INTO nlg_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Vaho ge ra gonighi e lima hangavulu na halili nia na gold te kekeli i sodu mi sodu, ge kara kaulaghinighi va tana ringi tana sosokoni erua na selo. Mi kakeri, na Vaevale tapole tabu te talukolu vamua ta sakai na tivi. ");
INSERT INTO nlg_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Mi tana vouvotuna na Vaevale tapole tabu tara saroa nia, ara hangavulu sakai na tivi sule tara gonighi nia na vuvulu ni goat. ");
INSERT INTO nlg_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Na tivi raini te sakai na vata vamua na daroni mana halavuni, e vitu na ghoto mana levu lima na daro, ma sakai na ghoto na halavu. ");
INSERT INTO nlg_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Na lei mane lutu tara suki kolui ara lima na tivi ta sakai, mara nei ghua iga ara ono ge ke ruani. ");
INSERT INTO nlg_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Vaho ge ra gonighi ara lima hangavulu na ringi nia na tivi, mara talui va tana sosokoni erua na selo sule. ");
INSERT INTO nlg_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ma gaira tara gonighi ghua e lima hangavulu na halili nia na bronze te kekeli i sodu mi sodu. Geke tabe kolu ngasilighi tana sosokoni erua na selo. Mara nea te vaghaa keri sasarona te talukolu te vaghaa sakai vamua na selo sule. ");
INSERT INTO nlg_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Vaho, gaira tara ghoi gonighi ghua erua na sasarona vania na vouvotu. Na diki tara gonia nia na ghuighuli ni sheep mane te sisi, me ruani tara gonia nia na ghuighuli ni maumanu te malebo. ");
INSERT INTO nlg_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Mana kokorasana na Vaevale tapole tabu, tara gonia nia na kilova tana ghai tara vatua nia acacia tana matenagho mi buritina. ");
INSERT INTO nlg_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Na daroni te dato erua na ghoto mana levu lima, mana levu lima na halavu. ");
INSERT INTO nlg_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Mara gonighi erua na sodu ni ghai ge ke pasukolu va ta sakai na kilova. Ma gaighi udolu na lei kilova tara nea iga te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ma gaira tara gonighi erua hangavulu na kilova mara talui tana paleva i launa, ge ke tabe ngasilighi, ");
INSERT INTO nlg_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","kolui nia e vati hangavulu na tuani nia na silver, kara nighi tughuru. ");
INSERT INTO nlg_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ma gaira tara gonighi ghua erua hangavulu na kilova vania i paleva longana na Vaevale tapole tabu, ");
INSERT INTO nlg_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","maia e vati hangavulu na tuani nia na silver, erua vania sakai na kilova. ");
INSERT INTO nlg_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Mi tana paleva bokona na Vaevale tapole tabu tana buritina, tara gonighi ga e ono na kilova. ");
INSERT INTO nlg_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Mara gonighi ghua erua na kilova ge kara tugai erua na piu i buriti. ");
INSERT INTO nlg_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ma gaighi erua na kilova raini tara talukolu ngasilighi te vuni i pari tana pukuni me sara i kokou ta sakai na ringi, ge vaghaa sakai vamua te vuni i kokou me sara ipari. Mara gonighi erua raini, tango sakai erua na piu i buriti. ");
INSERT INTO nlg_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ma vania i paleva bokona tara gonighi e alu na kilova, kolui nia e hangavulu ono na pukuni nia na silver, kara nighi tughuru, erua vania sakai na kilova. ");
INSERT INTO nlg_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Vaho ge ra gonighi ara lima na ghai daro ge kara piti kolui nia na kilova i paleva launa. ");
INSERT INTO nlg_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Mara gonighi ghua e lima vania i longana, me lima vania i bokona. ");
INSERT INTO nlg_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Me lima na ghai daro vania ighobuni na kilova ilevu mi levu te vuni isodu me sara i sodu. ");
INSERT INTO nlg_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mana kilova mana ghai daro tara poroi nia na gold. Mana ringi tara tabe kolui nia na ghai daro tara gonighi nia na puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Mana vokovoko ilokana na Vaevale tapole tabu tara gonia nia na tivi pura te malebo, ara vaguvagua nia na totoghalena na cherubim tara sukia nia na ghalo ghioghio, me boibongi me sisi. ");
INSERT INTO nlg_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Mana vokovoko eni tara kaulaghinia va tana vati na halili tara gonighi nia na gold, tara kaulaghinighi tana kouni e vati na bere. Na bere na ghai tara vatua nia acacia mara poroi nia na gold, tara tughuru tana vati na piu tana pukuni tara gonighi nia na silver. ");
INSERT INTO nlg_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Vaho ge ra ghoi gonia ghua sakai na vokovoko vania na mataulana na Vaevale tapole tabu. Tara gonia nia na tivi pura te malebo, mara vaguvagu nia na ghalo ghioghio, mana boibongi, mana sisi. ");
INSERT INTO nlg_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Na vokovoko eni tara taria nia e lima na halili va tana kouni e lima na bere, mara vaguvagu mara kabei na kouni nia na gold, me lima na pukuni tara tughuruvaghinighi ga, tara gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ma Bezalel te ghoi gonia na Bokisi ni Vetena ni Baubahu tabu nia na ghai tara vatua nia acacia. Aeni na levu lima mana hangava na darona, me rua na goigoti ni lima na halavuna, me vaghaa ghua na datona. ");
INSERT INTO nlg_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ma gaia te poroa nia na gold tana lokana maia tana murina, me kabe kililia nia na gold te vaguvagua nia. ");
INSERT INTO nlg_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Me gonighi e vati na ringi nia na gold, me kaulaghinighi va tana tuana, erua i levu me rua i levu. ");
INSERT INTO nlg_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Vaho ge gonighi erua na ghai daro nia na acacia me poroi nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ma gaia te torovaghinighi va tana ringi ilevu mi levuna na Bokisi ni Vetena ni Baubahu tabu kara holaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Vaho ge gonia na vovongona/papatana na Bokisi ni Vetena ni Baubahu tabu nia na puku ni gold, na bona ni laviana na veiarovi. Na levu lima mana hangava na darona, me rua na goigoti ni lima na halavuna. ");
INSERT INTO nlg_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ma gaia te gonighi erua na cherubim nia na gold te tupighi, me talu ngasilighi va i sodu mi soduna na vovongona na malei sopou ni veiarovi. ");
INSERT INTO nlg_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Gaia te pasukolua/talu ngasilighi va tana vovongona na malei sopou ni veiarovi, geke vagha sakai vamua. ");
INSERT INTO nlg_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Na cherubim toro naghonagho kolu i sodu mi sodu, moro vurehighi na ghatadira ivuvungana ge ko pilupungisia na malei sopou ni veiarovi. ");
INSERT INTO nlg_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Vaho ge gonia na bela nia na acacia, na levu lima na darona, me rua na hangava na halavuna, me rua na goigoti ni lima na datona. ");
INSERT INTO nlg_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Me saroa udolua nia na puku ni gold, me gonia na kabe nia na gold me kabe kililia nia. ");
INSERT INTO nlg_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Me gonighi na ringi pile nia na gold vania e vati na piuna na bela. ");
INSERT INTO nlg_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Vaho ge pasulaghinighi va ringi gold tana vati na tuana na bela, ");
INSERT INTO nlg_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","geke tabe ngasilighi na ghai ni hola. ");
INSERT INTO nlg_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Vaho ge gonighi na ghai ni hola nia na ghai tara vatua nia acacia, me poroi nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ma gaia te gonighi na plate mana disi mana sosa mana botolo na vatei taluani tana vuvungana na bela. Na lei totobo raini na vatei kaikavi wine ilokani kara nia sukaghi na wine. ");
INSERT INTO nlg_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ma gaia te gonia na vatei talu bulu te tughuru nia na puku ni gold te tupia. Na malana ke nia tughuru, na tughuruna te vuni mai ipari, na pukuni tara sopou iga na bulu te vaghai na lova, maia na vaguvaguni te vaghai na haga ni ghai, mana raurau tana pukuni na hahaga me talu kolui te vaghaa sakai vamua. ");
INSERT INTO nlg_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mana bulu tughuru te loghoi e ono na oto, e tolu i levu me tolu ilevu mana tughuru ighobu. ");
INSERT INTO nlg_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ma gaighi ara ono na oto tara tango sakai seu tara tabe datoi te vaghaa na reireina na hagana na ghai tara vatua nia na almond. ");
INSERT INTO nlg_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Mana tughuruna ighobu na bulu tara vaguvagua nia ghua ara vati na hagana na ghai. ");
INSERT INTO nlg_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Sakai na hahaga te talua va i sarani ara tolu na bulu, ma sakai isarani ara tolu i levu, tara pasu mai tana tughuru ighobu. ");
INSERT INTO nlg_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mana vaguvagu mana oto te vaghaa sakai vamua kolua na tughuru, me tupighi tana puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ma Bezalel te gonighi ghua ara vitu na bulu, maia ara vitu na vatei mate bulu, mana lei plate nia na puku ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Na bulu kolua nia na lei vaguvaguna te gonia nia na puku ni gold, na mavana e tolu hangavulu lima na kilo. ");
INSERT INTO nlg_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Na bela ni ghaiuruuru te gonia nia na ghai tara vatua nia acacia. Erua na hangava na darona mana halavuna, mana levu lima na datona, me vati na kala tana vati na piuna te gonighi nia ta sakai na vata ni ghai vamua, me pasulaghinighi va tana bela. ");
INSERT INTO nlg_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ma gaia te poroa nia na puku ni gold na vuvungana, mana lilighina, mana kalana na bela, me kabe kilili nia. ");
INSERT INTO nlg_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Me rua na ringi gold ilevu me rua ilevu, me pasulaghinighi va isarana na kabe, ge kara torovaghinighi ga na ghai ni hola. ");
INSERT INTO nlg_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Na ghai ni hola te gonighi nia na ghai acacia me poroi nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Vaho ge gonighi na kokolo tabu, na vatei siusiuadira na manesukaghi. Me gonighi ghua na ghaiuruuru te vaghaa tara gonighi na balu tara goni ghaiuruuru. ");
INSERT INTO nlg_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Na bela ni sukaghi kekere te gonia nia na ghai tara vatua nia acacia, a sakai na ghoto ma sakai na hangava na darona, me vaghaa ghua na halavuna, mana datona na alo ni togho. ");
INSERT INTO nlg_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mara vati na kala tana piuna na bela ni sukaghi tara tango sakai kala te talukolui va tana bela, geke vaghaa sakai vamua, me poro udolua nia na hulina na bela ni sukaghi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Vaho ge gonighi na bucket na vatei soni ravu, na shovel, mana halili na vatei liulivu na vinahi, mana rangai nia na bronze na vatei lutu tana bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Vaho ge gonia na netwire nia na bronze, me gonia vaghaa na kei, me talua va isarana na vatei keru lake, ighobu te sagau kokou mi pari. ");
INSERT INTO nlg_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ma gaia te gonighi ara vati na ringi me pasulaghinighi va erua ilevu me rua ilevu tana bela, geke tabe ngasilighi na ghai ni hola. ");
INSERT INTO nlg_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Na ghai ni hola te gonighi nia na ghai tara vatua nia acacia, me poroi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Na ghai hola te torovaghini haghei tana ringi ilevu mi levuna na bela, me tatavanga te gonia nia na kilova. ");
INSERT INTO nlg_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Na popo ni sasau maia na tuana tara gonighi nia na glass ni bronze, tara nighi hevei na lei vaivine tara lutu rana mataulana na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Vaho ge ke gonia na pilupiluna erua hangavulu lima na ghoto na darona ilauna, me vokoa nia na tivi pura. ");
INSERT INTO nlg_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Me rua hangavulu na berena kolua nia na tuani te gonighi nia na bronze, mana halili/sinagaura mana wire daro, tara gonighi nia na silver, ma kara sasarau iga na tivi. ");
INSERT INTO nlg_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mana pilupilu ilongana ghua erua hangavulu lima na ghoto na darona, maia erua hangavulu na bere mana tuani, tara gonighi nia na bronze, maia na kilili mana wire daro tara gonighi nia na silver. ");
INSERT INTO nlg_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mana pilupilu i bokona, e hangavulu rua mana levu lima na halavuna, mara vokoa nia na tivi pura tara tari datoa nia e hangavulu na bere maia na tuani, maia na halili mana wire daro tara gonighi nia na silver. ");
INSERT INTO nlg_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mana pilupilu i uluna e hangavulu rua na ghoto mana levu lima ghua na halavuna. ");
INSERT INTO nlg_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mana mataulana na pilupilu ke ghanaa i uluna, kara vokoa nia erua na tivi, Mana tivi tana pala madolo ke, e tolu na ghoto mana alo ni togho, ma kara taria nia e tolu na bere me tolu na tuani, kara nighi tughuru. ");
INSERT INTO nlg_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Mana tivi tana pala mauli, e tolu na ghoto mana alo ni togho, ma kara taria nia e tolu na bere me tolu na tuani kara nighi tughuru. ");
INSERT INTO nlg_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mana lei vokovoko tivi kililia na Vaevale tapole tabu kara gonia nia na tivi malebo pura. ");
INSERT INTO nlg_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Mana pukuni na lei bere kara gonighi nia na bronze, mana lei halili mana wire daro mana kouni/uluni na bere kara gonighi nia na silver. Mana wire daro ke tabe datoi na tivi kara gonia nia na silver ngasi/puku ni silver. ");
INSERT INTO nlg_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Na tivi ke vokoa na mataulana na pilupilu kara vauhia nia na ghioghio, boibongi mana sisi. E lima na ghoto na darona, me ke sakai na ghoto me rua hangava na datona, ke vaghaa sono na vokovokona na pilupiluna na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ma kara tari datoa nia ara vati na bere kara tughuru ilokani ara vati na pukuni tara gonighi nia na bronze. Na uluni/kouni na bere kara poroi nia na silver, mana halili mana wire daro kara gonighi ni na silver. ");
INSERT INTO nlg_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Mana lei vatei tari alona na Vaevale tapole tabu maia na pilupiluna kara gonighi nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Aeni na gegereni na lei totobo tara lutua nia na Vaevale tapole tabu. Moses te bosa vanira na lei mane tana kemana Levi ge kara talukolui na lei gegereni, ma Ithamar dalena Aaron na mane sukaghi te righitaonira. ");
INSERT INTO nlg_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ma Bezalel dalena Uri, a kukuana Hur, tana kemana Judah, te idevia na lutu, te vaghaa Yahweh te bosa vania tua Moses. ");
INSERT INTO nlg_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ma Oholiab dalena Ahisamach tana kemana Dan te hangaa. Gaia te ghilala utoa na baru, mana nighi suki vaguvagu na ghioghio, boibongi mana sisi tana tivi selo. ");
INSERT INTO nlg_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Mana gold tara nighi heveioli mai tua na vure vania Yahweh te vagha sakai na togha na kilo na mava, gaighi tara lutua nia na Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Mana suboni na silver tara nighi hevei e tolu togha vati hangalatu na kilo na mava te kaekage tana na mavani utuni. ");
INSERT INTO nlg_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Aeni te mai tana takisi ta sakai na tinoni, taonia gegere tana iduidu te vuni tana rua hangavulu na niulu me dato, ma gaira udolu ono hangalatu tolu na togha, lima hangalatu (603,550) na tinoni. ");
INSERT INTO nlg_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ma sakai na hangalatu na tuani/pukuni na lei berena na vokona na Bona Tabu maia na berena na vokovoko iloka te manana udolu sakai hangalatu na talent na mava ni silver, te manana sakai na talent na mava ni silver, sakai na tua. ");
INSERT INTO nlg_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Me tolu hangavulu na mava ni silver te au, Bezalel te gonighi nia na halili mana wire daro me poroi nia na kouni na lei bere. ");
INSERT INTO nlg_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Mana vure tara lavighi mai ghua vania Yahweh, na bronze erua na togha vati hangalatu erua hangavulu lima (2,425) na kilo na mavani. ");
INSERT INTO nlg_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ma gaia te gonighi nia na pukuni na lei bere tana mataula va tana Vaevale tapole tabu, maia na bela ni sukaghi maia na netwire sarana na bela ni sukaghi, mana lei vatei lutu tana bela ni sukaghi te goni udolui nia na bronze. ");
INSERT INTO nlg_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Mana bronze ghua te gonighi nia ghua na pukuni na lei bere kara tari kilili nia tivi tana Vaevale Tapole tabu, na pukuni na bere tana mataulana na bona ni vaukolu, mana lei vatei tariana na alona na vokovoko kililia na bona ni vaukolu. ");
INSERT INTO nlg_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ma vanira na lei manesukaghi, gaira tara gonighi na lei pupulu utouto nia na tivi ghioghio, mana boibongi mana sisi. Na tivi kara nighi pupulu tana bona kara gehegehe tana Bona Tabu. Mana raini ghua kara gonighi nia ghua nina pupulu tabu Aaron te vaghaa Yahweh te bosaa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Na goniana na ephod tara gonia nia na tivi pura mara vaguvagua nia na ghalo tara gonikolua nia na gold mana ghalo te ghioghio, me boibongi, me sisi. ");
INSERT INTO nlg_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Na lei mane tara ghilalaa utoa na lutu tara gonia na ghalo gold, gaira tara tupia na gold me madeve vaho ge ra palai na lei midi daro. Vaho ge sukaghi va tana tivi selo nia na ghalo te ghioghio me boibongi me sisi. ");
INSERT INTO nlg_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ma gaira tara gonighi ghua erua na midi vania na vala ilevu mi levu, kara tari horui ga. ");
INSERT INTO nlg_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gaira tra gonia ghua na kabe ghobu vania na ephod tana tivi vaghana sono mana ghalo te ghioghio, me boibongi me sisi te vaghaa te bosaa God vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Me rua na vatu tara vatui nia na onyx tara talui va tana midi ni tivi tana valana na ephod, mara goni kililighi nia na gold geke tabe ngasilighi. Mara gerei ga tara garui na ahadira na kema ni Israel. ");
INSERT INTO nlg_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Na vatu raini ke nea Yahweh ge ke ghanaghanara na vure ni Israel. Ara gonighi raini taonia na hava Yahweh te bosa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Na sasaro garo tara gonia na tivi tara gonia nia sono na ephod, tara gonia nia na tivi pura malebo mara vaguvagua nia ghalo gold mana ghioghio, mana boibongi, mana sisi. ");
INSERT INTO nlg_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Mara lokua ge ke vaghaa na tanga, ma sakai na hangava na darona mana halavuna. ");
INSERT INTO nlg_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Me vati na alaala ni vatu tara pasulaghinighi va iga. Tana diki alaala ara pasulaghinighi na vatu sisi tara vata na carnelian te sisi, na topaz, mana garnet. ");
INSERT INTO nlg_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Tana ruani na alaala kara talui ga na emerald, na sapphire, mana diamond. ");
INSERT INTO nlg_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tana toluni na alaala kara talui ga na jacinth, na agate, mana amethyst. ");
INSERT INTO nlg_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Mi tana vatini na alaala kara talui ga na beryl, mana onyx, mana jasper. Ma gaighi udolu na puku ni vatu raini tara vau kililighi nia na gold. ");
INSERT INTO nlg_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ma gaighi udolu na vatu raini tara sopa gerei ga na ahadira ara hangavulu rua na kema ni Israel. ");
INSERT INTO nlg_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mana talu koluana na sasaro garo va tana ephod, gaira tara gonia na ghalo nia na pulu ni gold. ");
INSERT INTO nlg_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Mara gonighi ghua erua na ringi nia na gold mara kaulaghinighi va tana piuna ilevu mi levu ikokou tana sasaro garo. ");
INSERT INTO nlg_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Me rua na ghalo gold tara turai va tana ringi gold tana sasaro garo, ");
INSERT INTO nlg_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","mana soduni na ghalo kiri kara pitighi va tana gold tara talua tana valana na ephod. ");
INSERT INTO nlg_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Me rua ghua na ringi gold tara kaulaghinighi va ilevu mi levu ipari tana sasaro garo toro palangia va na ephod. ");
INSERT INTO nlg_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Vaho erua na ringi gold tara kaulaghinighi va tana ephod lilighina na kabe ghobu. ");
INSERT INTO nlg_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Mana ghal ghioghio tara kaulaghinighi va tana ringi ipari tana sasaro garo va tana ringi tana ephod. Mara nea te vaghaa keri ge ke tabe ngasilia na sasaro garo va tana ephod i vuvungana na kabe ghobu. Mana lei totobo raini tara gonighi te vaghaa Yahweh te bosaa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ma pupulu vania na ephod tara vauhia nia na ghalo ghioghio. ");
INSERT INTO nlg_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Me hangavi na ghobuna vania na uluna Aaron. Mana lilighina te hangavi ga tara vauhi ngasilia ge ke bei tarosi gea. ");
INSERT INTO nlg_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mana sagasaga tara goni kililia nia tana sosokona ipari. Mara goni utoutoi nia na ghalo ghioghio, mana boibongi mana sisi. ");
INSERT INTO nlg_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Mana lei belo gold tara tarighi ighobuni na lei sagasaga taonia na bibi ipari tana sokona na pupulu. ");
INSERT INTO nlg_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Sakai na belo mana sagasaga, sakai na belo mana sagasaga kililia sosokona na pupulu i pari tana bibi. Na pupulu eni ke nia pupulu Aaron tana bona ke gehegehe vania Yahweh, te vagha Yahweh te bosa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ma kara gonighi na pupulu te vuivuni tana ghobu me ke sara tana peghe nia na tivi malebo vania Aaron mana lei dalena. ");
INSERT INTO nlg_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Na tivi ni pitiulu, mana kepi mana tivi ni puku boro kara gonighi nia na tivi pura te malebo. ");
INSERT INTO nlg_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Mana lei kabe ghobu tara gonighi nia na tivi malebo mara vaguvagui nia na ghalo ghioghio, mana boibongi, mana sisi, te vagha Yahweh te bosaa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Mana sosoko gaira tara gonia na medolo tabu nia na puku ni gold kara talua inaghona na tivi ni pitiulu. Mara gerei ga na lei bosa raini, “Kobe kehaa ta tabu va ta Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Na medolo eni tara pitia nia na ghalo te ghioghio va tana tivi ni pitiulu, te vagha Yahweh te bosaa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mi tana sosoko na goniana na Vaevale tapole tabu te soko. Gaira na Israel tara goni taoni udolui na lei totobo Yahweh te bosaa vania Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ma gaira tara holaa na Vaevale tapole tabu vania mai a Moses, kolua nia na lei hegohegona, na halili/sinagaura na ihola mana bere mana pukuna kara nighi tughuru. ");
INSERT INTO nlg_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Mana ghuighuli ni sheep mane, mana maumanu te malebo, mana tivi na vatei voko pungisiana na Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Mana Bokisi ni Vetena ni Baubahu tabu maia erua na ghai ni holaana, na vovongona na Bokisi ni Vetena ni Baubahu tabu, na bona ni toghipalu, ");
INSERT INTO nlg_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na bela mana lei hegohegona mana berete tabu, ");
INSERT INTO nlg_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na vatei talu bulu tara gonia na gold, maia na buluna mana kokolo na vatei tungiani, ");
INSERT INTO nlg_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na bela ni sukaghi tara gonia nia na gold, mana kokolo ni siusiu, mana ghaiuruuru, mana vokovokona na mataulana na Vaevale tapole tabu, ");
INSERT INTO nlg_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na bela ni sukaghi tara gonia nia na bronze, na kei te vaghaa na vugho tara gonia nia na bronze, mana ghai ni hola mana lei hegohegona, mana popo sule na vatei sasau mana malei sopouna, ");
INSERT INTO nlg_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na tivi ni vokoana na pilupilu, na bere mana tuani kara nighi tughuru, na tivi ni vokoana na mataula, na alo mana vatei tari alona na Vaevale tapole tabu, mana lei hegohego ni vatei gehegehe tana Vaevale tapole tabu. ");
INSERT INTO nlg_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Na pupulu tara goni utoutoi kara nighi pupulu tana bona kara gehegehe tana Bona Tabu, na pupulu tabu vania Aaron na manesukaghi ma vanira rana dalena kara nighi pupulu tana bona kara lutu. ");
INSERT INTO nlg_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Me vaghaa keri na vure ni Israel tara taoni udolui na lei totobo Yahweh te taraia nia Moses. ");
INSERT INTO nlg_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ma Moses te siro udolua didira na lutu ge vautora, na pukuna te soko taonia na hava Yahweh te bosaa vania. ");
INSERT INTO nlg_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ma Yahweh te bosa vania Moses, ");
INSERT INTO nlg_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ko tughuruvaghinia na Vaevale tapole tabu tana diki bongi tana niulu vaolu. ");
INSERT INTO nlg_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ko talua na Bokisi ni Vetena ni Baubahu tabu iloka, mo ko taria na tivi ke pungisia na Bokisi ni Vetena ni Baubahu tabu ilokana na Bona Tabu Vaho tua. ");
INSERT INTO nlg_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Vaho ge ko lavi haghea mai na bela, mo ko talui na lei hegohegona tana sopa malani. Mo ko lavi haghea mai na tughuru bulu mo ko talui va na lei bulu ivouvotuna. ");
INSERT INTO nlg_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Mo ko talua na bela tabu ni kere ghaiuruuru ipari bebetena na tivi te voko pungisia na Bokisi ni Vetena ni Baubahu tabu. Mo ko tari datoa na tivi to gonia vania na mataulana na Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ko talua na bela ni sukaghi ipari bebetena inaghona na mataulana na Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Talua na popo sule ni vatei siu ighobuni na Bona Tabu maia na bela ni sukaghi kekere, mo ko heo vonughia nia na beti. ");
INSERT INTO nlg_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Vaho ge ko talu datoa na vokovoko kililia na lei totobo raini, mo ko taria na tivi tana mataulana na pilupilu. ");
INSERT INTO nlg_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ko lavia na kokolo tabu mo ko seburukaghinia va tana Vaevale tapole tabu mana lei hegohegona, ge kara tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ko seburukaghinia va na kokolo tabu tana bela ni sukaghi kekere maia na lei hegohegona, ge kara tabu. Vaho na bela ni sukaghi ke liliu ni tabu ngangata. ");
INSERT INTO nlg_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Vaho, ko siusiua na popo sule ni siu mana malei sopouna, ke nera ge kara tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ko lavira mai Aaron mana lei dalena mai tana mataulana na Bona Tabu, mo ko siuvira nia na beti. ");
INSERT INTO nlg_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ko pupulua nia Aaron na pupulu tabu mo ko siusiua, ke kobe kehaa ge ke gehegehe vaniu ke vaghaa na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Vaho ge ko holara mai dalena, mo ko pupulura nia didira na pupulu. ");
INSERT INTO nlg_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ko siusiura te vagha to nea tua tamadira, ge kara gehegehe vaniu te vaghara na manesukaghi. Mara nia siusiu eni Aaron mana vinavahuhuna kara kobe kehara tana malei manesukaghi ke va me va, taoni na vavata mana vavata.” ");
INSERT INTO nlg_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ma Moses te rughuhoru ge ke gonighi na lei totobo Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Keri ke, na Vaevale tapole tabu tara tughuruvaghinia tana diki bongi tana niulu vaolu. ");
INSERT INTO nlg_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ma Moses te talu kolu udolua nia na taluani na pukuni tana malani, me tughuruvaghinighi ga na bere, me talu datoi na iholana. ");
INSERT INTO nlg_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Vaho ge ra tari kililia nia na tivi mara saroa nia na vouvotuna na ghuighuli ni maumanu mana goat, taonia na hava Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Keri ge Moses te talu haghe tana Bokisi ni Vetena ni Baubahu tabu erua na midi ni vatu na hangavulu na vetena, me talui va iga na ghai ni holaana. Me talua va ghua na vovongona na Bokisi ni Vetena ni Baubahu tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Vaho ge hola haghea mai na Bokisi ni Vetena ni Baubahu tabu tana Bona Tabu Vaho tua, me tari pungisia nia na tivi ge kara bei vaevanea, te vaghaa Yahweh te bosaa. ");
INSERT INTO nlg_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ma gaia te talua na bela te pala va ilonga ilokana na Bona Tabu, ipari bebetena vamua na tivi tara taria iloka. ");
INSERT INTO nlg_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Vaho ge talui tana vuvungana na berete tabu te tughuru pungisia na matana Yahweh, te vaghaa Yahweh te bosaa. ");
INSERT INTO nlg_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ma gaia te tughuruvaghinia na tughuru bulu kaekage kolua na bela te pala ilauna na Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Vaho ge ko talui va na lei bulu ivouvotuna tana matana Yahweh, te vaghaa Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ma gaia te talua ghua na bela gold ni ghaiuruuru tana Vaevale tapole tabu ilokana na Bona Tabu inaghona na vokovoko ilokana. ");
INSERT INTO nlg_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Tana vuvungana keri tara kerea na ghaiuruuru, te vaghaa Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ma Moses te taria na tivi tana mataulana na Bona Tabu. ");
INSERT INTO nlg_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Tana lilighina na mataulana, gaia te talua na bela ni sukaghi kekere. Me kerea na sukaghi mana na sukaghi ni wheat, te vagha Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ma gaia te talua na popo sule ighobudira na Bona Tabu mana bela ni sukaghi kekere. Ma gaia te heoti vonua nia na beti, ge kara tangomana na saudira heghedira nia rana manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ma Moses ma Aaron maia rana lei dalena Aaron kara saui na limadira mana tuadira tana popo. ");
INSERT INTO nlg_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tana bona kara va tana bela ni sukaghi, pa kara haghe tana Bona Tabu ke, kara tughuru beto ma kara sasau ghua, te vaghaa Yahweh te vetenaa nia. ");
INSERT INTO nlg_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Vaho ge tari kililia nia na tivi na bebetena na Vaevale tapole tabu mana bela ni sukaghi. Me tari datoa na tivi tana mataulana na pilupilu, mi kakeri Moses te sokoa/sokolaghinia na lutu. ");
INSERT INTO nlg_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Keri ke, na ghoghopa te saroa na Vaevale tapole tabu, mana rongoraghana Yahweh te vonughia. ");
INSERT INTO nlg_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ma Moses te mua tangomana ge ke haghevia na Vaevale tapole tabu, na pukuna na ghoghopa te saroa, mana Vaevale tapole tabu te vonughia na rongoraghana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mi tana bona ke ghate datoa na ghoghopa sania na Vaevale tapole tabu me ke gharadu, na vure ni Israel kara tona taonia ta didira na vinano. ");
INSERT INTO nlg_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Me ke sopou so na ghoghopa ke, kara mua tangomana na tona koekobe, ke ghoi gharadu. ");
INSERT INTO nlg_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ma nina ghoghopa Yahweh te sopou tana vuvungana na Vaevale tapole tabu tana dani, mi tana bongi na lake tana lokana na ghoghopa, ge kara righia va na vure ni Israel. Ma eni t tona haliu taonia didira na vinano. ");
INSERT INTO nlg_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Mi murina Moses nina tinoni ni lutu God te mate tua. A Yahweh te bosa vania Joshua dalena Nun, nina tinoni hahanga ni lutu Moses, me ghaghua, ");
INSERT INTO nlg_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Na pukuna nigua na tinoni ni lutu Moses te mate tua ke, mi ghoe ko ghoi hulira nigua na vure ge kara sogha halavua na beti tina Jordan va tana bona ni pari tu bahura nia geku vahera. ");
INSERT INTO nlg_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Na bona ni pari kau tonavia ke, tu gonidilaa vanighau tua, te vagha tu bahu sokoa vania nia tua Moses. ");
INSERT INTO nlg_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Na bona ni pari ku vaheghau ke, te vuivuni tana bona mamaha na ahana Negev paleva longana me ke va sara tana lei ghotu ni Lebanon paleva launa. Me ke ghoi vuivuni tana beti tina Euphrates paleva uluna tana tahi Mediterranean, me lavia va tana bubulo tara sopou iga na taba ni vure ni Heth. ");
INSERT INTO nlg_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Me taho siki sakai ke lagavulegho tana veitotoghoni tana bona to vola mua. Inau haia itamua, te vagha tu nea iga Moses. Inau ku kabu kolugho haia, muku mua sanigho. ");
INSERT INTO nlg_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“Ko tughuru ngasi haia, mo ko bei mataghu na pukuna ighoe ko hulira na vure ini gekara haghevia na bona ni pari tu bahura nia tua rana kukuamiu idania ku vaheghau. ");
INSERT INTO nlg_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ko tughuru ngasi haia, mo ko bei mataghu. Ko taonighi haia na lei vetena te vahegho nigua na tinoni ni lutu Moses, mo ko bei sania gea siki peleni na lei vetena kiri, ge ivei tua ko va mana hava tua ko gonia ke tatavahale vanigho. ");
INSERT INTO nlg_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ko siroa mo ko idumia haia na buka ni vetena, mo ko taraira na vure nia na bosa te ghanaa i lokana. Tana dani mana bongi ko ghanaghana taoni utoi na lei bosa ini, geko tangomana goni utoani na hava na vetena te bosaa. Ko gonia te vagha eni ke, na lei nimua nilabu ke tona tatavahale me ke uto. ");
INSERT INTO nlg_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Inau tu bosa vanigho, ko tughuru ngasi haia mo ko bei mataghu, mo ko bei ghanaghana ruarua, na pukuna ivei tua ko vaa, inau, nimiu na God, ku kabu haia itamua.” ");
INSERT INTO nlg_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Joshua te kokokoe laga vanira na lei mane nagho ni Israel te vagha eni, ");
INSERT INTO nlg_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Kau talighu itadira na vure, ma kara gonidilai na balu vanga, na pukuna e tolu na bongi taeni ka sogha halavua na beti tina Jordan, ma kau hola na lologho tana bona ni pari a Yahweh, nimiu na God te nia hevei mai.” ");
INSERT INTO nlg_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Ma Joshua te holokolura na kemana Ruben ma Gad maia na vike ta Manasseh, me bosa te vagha eni, ");
INSERT INTO nlg_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Kau ghanaghana olia na hava Moses nina tinoni lutu Yahweh te nia kokokoe vanighau, ‘A Yahweh, nimiu na God, te nia hevei na bona ni pari tana levu uluna na beti tina Jordan.’ ");
INSERT INTO nlg_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Rana taumiu, dalemiu ma nimiu na bolo kara kabu oli ani levu uluna na beti tina Jordan, hauva nimiu na lei malaghai kara talui tua na lei totobo ni gehemate tana hulidira, ma kara idevira na balu kema na sogha halavuana na beti tina Jordan, ge kara hangaghai tana veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Ke tona me ke va saravia na bona ka lagavulei na lei bona ni pari ini lilighina na beti tina Jordan paeva bokona. Eni gaia na bona ni pari a Yahweh dida na God te bahughita geke vaheghita. Iani vamua geko kabu liligina beti tina Jordan tana bona ni pari Moses nina tinoni lutu Yahweh te nia hevei.” ");
INSERT INTO nlg_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ma gaira tara bosa tughu vania Joshua, mara ghaghua, “Ighai kai goni taonia na hava tua ko bosa vanighai nia, makai tona ivei tua ko vetenaghai ga. ");
INSERT INTO nlg_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Kai taonigho te vagha tai nea iga na taoniana Moses. Ma Yahweh, nimua na God, ke kabu kolugho te vagha te nea vania Moses. ");
INSERT INTO nlg_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ma hei ke mua taonia na bosamu me ke mua taonia nimua na lei bosa ni arevaghi, kai matea. Keri ke, ko tughuru ngasi mo ko bei mataghu!” ");
INSERT INTO nlg_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Ma Joshua mana vure ni Israel tara savukolu i Acacia, ge nira vetena erua na tinoni sigho gekoro va vaevane popolo paleva launa na beti tina Jordan me haba va talighutia na komu sule Jericho. Moro rughuhoru moro mai sara i Jericho, tana valena sakai na rebi na ahana Rahab. Moto kabu itatana tana bongi keri. ");
INSERT INTO nlg_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ma siki tinoni te va bosa vania na Vunaghi Haba ni Jericho te vagha eni, “Na balu mane ni Israel tara mai tana bongi ani gekara mai vaevanea na lei bona ni pari,” ");
INSERT INTO nlg_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","keri ge vunaghi haba te vetena kokokoe vania Rahab te vagha eni, “Ko holahurua mai na lei mane tara mai tana valemu. Ra mai vaevane popoloi va hava tana komuda makara mai veitotoghoni kolughita” ");
INSERT INTO nlg_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Ma Rahab te bosa tughu me ghaghua, “Iani so na kiri igeni, mu mua ghilalara ivei toro butu mai. ");
INSERT INTO nlg_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","E pungi mua mara sania tua na komuda eni tana bona na vovongo ni mataula haghe te dutu ni vovongo, mu mua ghilalara ivei toro nea na tona. Ke vagha kau mina mina tona ke, ma sogea kau sodora so.” ");
INSERT INTO nlg_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Hauva me lavira me va polora i sarana na lei pipiti ni buburu te talui gekara mamaha tara hina. ");
INSERT INTO nlg_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Keri ke, na lei nina malaghai na vuraghi haba tara sania na komu. Mi tana bona keri, tara vongotia na mataula ni peo tana komu sule. Mara tona gekara va kene taonira rua na tinoni ini, mara taonia va na halautu te sogha halavua na beti tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Inaghona goro maturu na tinoni ini, Rahab te dato tana vouvotu ni valena, ge ke va kokoe kolura, ");
INSERT INTO nlg_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","me ghaghua vanira, “Inau tu ghilala a Yahwe te nia hevei vanighau na bona ni pari eni, mi ghai udolu tai nia talata mai mataghu nighau. ");
INSERT INTO nlg_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ighai tai rongovia ivei te nea Yahweh ge mamaha va halautumiu gau sogha halavua na tahi Sisi tana bona tau sania mai Egypt. Mi ghai ghua tai ghilala ivei tau nera rua na vunaghi haba ni Amor, Sihon ma Og, levu uluna na beti tina Jordan, maia na vurena tau mate sokora. ");
INSERT INTO nlg_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Mi tana bona tai rongovighi na lei tutugu ivei ka, ai tatata mai mataghu sule ngangata, mana ghanaghana mai taeni labe, na pukuna a Yahweh, nimiu na God, te vunaghina i kokou maia na maramana eni. ");
INSERT INTO nlg_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Inau tu liodolovighau mu hangaghau. Keri ke, koro nia papari/baubahu vaniu mai tana ahana Yahweh ge koro liodoloviu maira nigua na binaboli, te vagha tu nea iga na hangamiu. Koro gonia vaniu mai siki vaughilala tana nimiu bosa ni baubahu, ");
INSERT INTO nlg_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ge kau volau maira tamagu ma tinagu, na lei vaivinegu maira na hoghogu kolura nia didira binaboli. Mi tana bona kau mai haurakea Jericho ke, kau mua mateghai!” ");
INSERT INTO nlg_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Toro bosa tughu vania, “Koro nia hevei na volamami te vagha ronimami na bosa ni baubahu vaniamu. Ke vagha ko mua tughunia ivei toro mai ghaghua iga eni ke, koro loti ngasilia so ronimami na baubahu moro hangaghau, tana bona Yahweh ke nia hevei vanighai na bona ni pari eni.” ");
INSERT INTO nlg_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Mana pukuna na valena Rahab tara kisua tana peona na komu ke, ma Rahab te dorovaghi ni horura nia na alo (rope) tana kunapana/matakene na peo ni komu rua na tinoni ini. ");
INSERT INTO nlg_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Ge bosa vanira te vagha eni, “Koro sama polo va tana lei ghotu mokoro polo iga ilokana tolu na bongi koekobe kara oli maia rahei tara keneghau, vaho ge koro tona. ");
INSERT INTO nlg_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Moro bosa vania na vaivine te vagha eni, “Iroghai toro nia hevei nimami na bosa ni baubahu to liona tamami. ");
INSERT INTO nlg_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Mo ko goni taonia te vagha eni, tana bona kai mai haghevia nimiu na bona ni pari eni ke, ko hola na alo sisi (rope) mo ko sasarau horua tana kunapa/matakene to lubati horughai ga. Holora mai na tamamu, tinamu, vaivinegu maia rana binaboli tamua, ma kara ghana tana vale eni koluu. ");
INSERT INTO nlg_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ma ge siki sakai tamiu ke rughuhoru sania na vale me ke tona tara loloa ni komu, makai labu matea ke, ma nina hahi heghena tua, ma kai/mo koro mua lavia siki totoro ghoi. Ma ge siki sakai tamami ke labu matea siki sakai lokana na valemu, iroghai kai/koro lavia na totoro iga. ");
INSERT INTO nlg_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ma sakai vamua te vagha eni, ma ge toko tughunitatea na hava toro gonia iani, kai/koro mua tangomana na lotiaana nimami na baubahu.” ");
INSERT INTO nlg_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ma gaia te holopangotia rodidira na kokoke, ge lubati horura tana alo (rope) ge ro tona. Keri ke, gaia te talua/pitia na alo sisi tana matakene. ");
INSERT INTO nlg_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Me rua na tinoni ini toro tona moro va polo tana ghotu e tolu na bongi. Ma nina malaghai na vunaghi haba tara tona haliu so na keneadira tara lei bona e tolu na bongi, mara mua tangomana gekara kene sodora, vaho gara ghoi oli tana komu sule i Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Keri vaho, goro sughi horu mai tana ghotu rua na tinoni ini, moro sogha halavua na beti tina Jordan, goro va saravia Joshua, moro tutugua vania na lei totobotoro sodoi ta didira na kenekene. ");
INSERT INTO nlg_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Moro bosa te vagha eni, “Ighia ta ghilala utoa tua Yahweh te nia hevei tua na bona ni pari eni vanighita. Na lei tinonina soko na komu keri tara mataghu nighita sule ngangata. ");
INSERT INTO nlg_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Tana roropo ghana tana ruani na bongi Joshua mana Vure ni Israel tara sania Acacia, mara mai sara tana kakabara/kebara ni beti tina Jordan, mara ghahara iga vaho ge ra sogha halavu. ");
INSERT INTO nlg_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Me padi tolu na bongi na lei mane nagho ni Israel tara tona taoni ivei tara sopa kabu iga na vure. ");
INSERT INTO nlg_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Mara nighi hevei na lei bosa ni arevaghi ini vanira na vure, “Tana bona ko righira na lei manesukaghi ni/tana vaivarina Levi kara hola na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh dida na God, kau saritaonira. ");
INSERT INTO nlg_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Moto mua taonia mai mua na halautu eni siki bongi ke, gaira kara hulighita, ma kara tughunia vanighita na halautu ge ka taonia. Kau bei dutuvia gea na Bokisi ni Vetena ni Baubahu Tabu. Kau tabalili kehaghau te manana lima hangalatu na ghoto kau tumuri makau bei mai dutuvia na Bokisi ni Vetena ni Baubahu Tabu.” ");
INSERT INTO nlg_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ma Joshua te bosa vanira na vure “Kau marabu olighau, na pukuna i ropo a Yahweh ke gonighi na lei butuli tana ghobumiu.” ");
INSERT INTO nlg_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Mi tana roropo keri, Joshua te bosa vanira na lei manesukaghi me ghaghua, “Kau haudatoa na Bokisi ni Vetena ni Baubahu Tabu makau idevira na vurena.” Mara gonia te vagha Joshua te bosa. ");
INSERT INTO nlg_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ma Yahweh te bosa vania Joshua, “Tana dani eni inau ku vuivuni ni taludatoana na ahamu tana matadira na vure ni Israel. Ge kara ghilala inau haia itamua te vagha tu nea iga Moses. ");
INSERT INTO nlg_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ko nighi hevei na lei bosa ini vanira na lei manesukaghi tara holaa na Bokisi ni Vetena ni Baubahu Tabu, ‘Tana bona kau va saravia na kebaraana na beti tina Jordan, kau gonia sakai pe rua ra talutua, mo ko tughuru beto.’” ");
INSERT INTO nlg_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Keri ge bosa Joshua vanira na vure ni Israel me ghaghua, “Kau mai makau varongohia na hava Yahweh, nimiu na God te bosaa. ");
INSERT INTO nlg_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Kau ghilala itaeni a God te vola itamiu, gaia ke ghurura taba ni vure ni Canaan, mi Heth, mi Hiv, mi Periz, mi Girgash, mi Amor, mi Jebus. ");
INSERT INTO nlg_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Kau ghanaghanaa na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh te vunaghi pungisia na maramana udolu, ke idevighau ge kau sogha halavua na beti tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Kau vilira ara hangavulu rua na mane sasakai sopa kema. ");
INSERT INTO nlg_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Na lei manesukaghi kara hola na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh te vunaghi pungisia na maramana talighu. Tana bona na tuadira ke tibelia mua na beti, na tavena na beti ke beto, mana beti te tave horu ke beto me ke va ghoghoro kolu vamua sakai na bona.” ");
INSERT INTO nlg_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Mana vure tara rughuhoru sania na bona tara ghahara gekara sogha halavua na beti, na lei manesukaghi tara ghatea na Bokisi ni Vetena ni Baubahu Tabu tara ide mana vure tara tumuri. ");
INSERT INTO nlg_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Tana bona vaghana eni, na beti tini Jordan te sule ngangata na tavena mana bona ni lavini vogha ghua, na ghegheti vanga tana leghai. Hauva mi tana bona tara talutua haghe mua na lei manesukaghi tana beti ke, ");
INSERT INTO nlg_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","me beto tua na beti. Na levuna na beti te tave horu te va ghoghoro kolu vamua te sakai na bona te sagau ngangata me dutuvia na komu i Adam lilighina i Zarethan. Ma sakai na levuna na beti te tave horu saravia na tahi Mate te mamaha. Ma gaira udolu tara sogha halavua na beti te dutuvia Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Mana bona tara sogha halavu, na lei manesukaghi tara tughuru tana bona te mamaha i ghobuna na beti tina me va saravia gaira soko tara sogha halavu paleva levu. ");
INSERT INTO nlg_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Na lei vure soko tara sogha halavu tatavale na beti, ma Yahweh te bosa vania Joshua te vagha eni, ");
INSERT INTO nlg_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Ko vilira hangavulu rua na mane sasakai sopa kema, ");
INSERT INTO nlg_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","mo ko bosa vanira, ge kara holai hangavulu rua na vatu ivei tara tughuru iga na lei manesukaghi ghobuna na beti tina Jordan, ma kara holai ma kara ovuovu kolui tana bona kau kabu iga tana bongi taeni.” ");
INSERT INTO nlg_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Ma Joshua te holo kolura hangavulu rua na mane sasakai sopa kema, ");
INSERT INTO nlg_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","me bosa vanira te vagha eni, “Kau tona ighobuna i Jordan inaghona na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh, nimiu na God. Sopa sakai tamiu ke tabe datoa sakai na vatu, makau holavalai hangavulu rua na vatu, tango sakai ta hangavulu rua na kema. ");
INSERT INTO nlg_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Na vatu ini ka gonia na vatei ghanaghana oliana na beti te beto me mua tave. Tana lei bongi ke mai, ma ge kara huatighau rana dalemiu, ‘Na hava na ghanaghana iga na lei vatu raini?’ ");
INSERT INTO nlg_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Keri ge kau bosa tughu vanira te vagha eni, ‘Na lei vatu raini tai ghanaghana olia iga na beti tina Jordan te mua tave tana bona tara hola halavua na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh.’ Na vatu ini kara tughuru iga didira na vatei ghanaghana oli rana Israel.” ");
INSERT INTO nlg_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Na vure tara goni taonia na hava Joshua te bosa vanira nia, mara holai hangavulu rua na vatu sule ighobuna na beti tina Jordan taonia sopa kema taonia na hava Yahweh te bosa vania nia Joshua. Ra holai na vatu va ivei tara taludatoi ga na vale tapole, gara vara datoi ivei tara nea na lutuani. ");
INSERT INTO nlg_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Ma Joshua ghua te kisua sakai na vatei ghanaghana oli nia hangavulu rua na vatu i ghobuna na beti tina Jordan tana bona tara tughuru iga na lei manesukaghi tara holaa na Bokisi ni Vetena ni Baubahu Tabu. Me ghana so ritini mai so itaeni na vatei ghanaghana oli eni. ");
INSERT INTO nlg_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Na lei manesukaghi tara hola na Bokisi ni Vetena ni Baubahu Tabu tara tughuru beto i ghobuna na beti tina koekobe ra goni kale sokoi na lei bosana Yahweh te vahea Joshua. Aeni te vagha na hava Moses te aravaghighi. Tana bona ia eni, na vure tara mina sakutua tana pari mamaha va na beti tina. ");
INSERT INTO nlg_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Mi tana bona gaira udolu tara sara ilevuna na beti tina vaho gera sakutua halavu, rana manesukaghi tara hola nina Bokisi ni Vetena ni Baubahu Tabu Yahweh. ");
INSERT INTO nlg_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Na lei malaghai tana kemadira Ruben ma Gad, maia na vike a Manasseh, tara idevira rana Israel na sogha halavuana na beti tina taonia nina arevaghi Moses. ");
INSERT INTO nlg_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","E vati hangavutu na togha ni malaghai laga raini tara gonigonidila ni veitotoghoni tara sogha halavua na nanata Jericho tana matana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Tana dani vaghana eni a Yahweh te nea Joshua ge haba vule tana matadira na vure ni Israel, mi tana lei bongi ni volana te vagha tara nea iga Moses idania. ");
INSERT INTO nlg_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Mi muruna eni Yahweh te bosa vania Joshua, ");
INSERT INTO nlg_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","ge ke kokokoe sule vanira na lei manesukaghi tara holaa na Bokisi ni Vetena ni Baubahu Tabu ge kara dato sania na beti tina. ");
INSERT INTO nlg_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Ma Joshua te goni taonia na hava God te bosa vania nia. ");
INSERT INTO nlg_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Tana bona tara dato sania mai na beti na lei manesukaghi ini, na beti te vuivuni ni ghoe tave oli te ghaghua haia iga me saravia na kakaburuana/keburuana na beti. ");
INSERT INTO nlg_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Rana vure Israel tara sogha halavua na beti tina Jordan tana hangavulu/paregho na bongina na vuivuni na vula tana niulu, mara ghaha na bona tara holoa nia Gilgal, tana paleva uluna Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Iga Joshua e holai hangavulu rua na vatu tana beti tina Jordan, me varavarai. ");
INSERT INTO nlg_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Ma Joshua e ghoi bosa vanira rana Israel, “Tana lei bongi ke mai nagho, rana lei dalemiu igeva kara huatighau ma kara ghaghua, ‘?Na hava na ghanaghana iga na lei vatu ini?’ ");
INSERT INTO nlg_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Keri gekau bosa tughu vanira te vagha eni, ‘Iani rana Israel tara sogha halavua na beti tina Jordan tana bona te mamaha. ");
INSERT INTO nlg_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Tana matamiu, a Yahweh, nimiu na God, te nea ge mamaha na beti tina ritini ighau udolu tau soga halavu, te vagha te nea iga ge mamaha na tahi Sisi ga sogha halavu ighita udolu. ");
INSERT INTO nlg_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","E nea te vagha eni ge na lei taba ni vure tana maramana kara manahana nina maana Yahweh, ge kau nia kikinima a Yahweh, nimiu na God, itaeni maia ke va me va. ");
INSERT INTO nlg_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Tana bona na lei vunaghi haba ni Amor paleva bokona Jordan kolua nia na lei vunaghi haba ni Canaan tara komu dutuvia na tahi Mediterranean, tara rongovia ivei te nea Yahweh ge mamaha na beti tina Jordan mara sogha halavu na vure ni Israel. Tara mataghu ngangata, mana ghanaghanadira te labe tana vuvungadia rana Israel. ");
INSERT INTO nlg_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Tana bona ia keri, Lord te bosa vania Joshua, “Ke gonighi na bou ivi nia na vatu te vanga me ke pahevaughilaladira na lei mane itadia na lei kema tara mua pahevaughilala mua. ");
INSERT INTO nlg_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ma Joshua te goni taonia na hava Lord te bosa vania nia, ge pahevaughilalara na lei mane. Na bona te gonia aeni tara holoa nia ‘Gibeath Haaraloth.’ ");
INSERT INTO nlg_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Ma Joshua te pahevaughilalara na pukuna na lei mane te manadira na holani na lei totobo ni kisumate tana bona tara sania mai Egypt tara mate soko tua tana bona mamaha. ");
INSERT INTO nlg_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Rahei tara sania mai Egypt tara pahevaughilala tua, ma rahei tara sivuragha imurina na rughuhoru tara mua pahevaughilala ilokana na lei niulu tana bona mamaha. ");
INSERT INTO nlg_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Rana Israel tara tona olioli vati hangavulu na niulu tana bona mamaha koekobe na lei mane te sara na niuludira gekara holai na lei totobo ni kisumate bona tara sania mai Egypt tara mate. Na pukuna tara diua Yahweh, ma Yahweh te baubahu gekara mua haghevia na butonikomu te nia papari geke vahera rana kukuadira, na butonikomu keri te vonughia susu ni buluka mara kokolo ni midua. ");
INSERT INTO nlg_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ma Joshua te pahevaughilalara na daledira tara mua pahevaughilala mua bona tara tonavia gatu na komu/butonikomu baubahu, rahei tara tughura tamadira bona tara suledato. ");
INSERT INTO nlg_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Mi murina na lei mane tara pahevaughilala ke, ra sopou beto tana bona tara taludatoi ga na vale tapole ritini ke mavo na paedria. ");
INSERT INTO nlg_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ma Lord te bosa vania Joshua, “Tana dani eni inau ku pilukeha/talukeha itamiu nimiu na maa tana kabu pipiti/popongo i Egypt. Keri gara holoa nia mai so na bona keri Gilgal. ");
INSERT INTO nlg_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Tana bona tara kabu mua tana vale tapole i Gilgal te dutuvia na nanata i Jericho, gaira tara ghanaghana olia iga na Gougonu ni Lovovule, tana nulavi vaghana keri, hangavulu vati na bongina na vula Abid. ");
INSERT INTO nlg_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Mi ropo agaira tara vuivuru ni ghaniani na berete gulu mana balu barley tara goni ghalatighi tana vuivuni ni dani tara saravia na bona ni pari keri. ");
INSERT INTO nlg_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","E mua tumu horu mai siki manna tana dani vagana eni, mara mua ghoi righia ghua tua. Mi tana bona ia eni rana Israel tara ghanighi tua na vangana i Canaan. ");
INSERT INTO nlg_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Mana bona Joshua te dutuvia Jericho, e rei dato me righia sakai na tinoni te mai nia tughuru tate vania na ivi daro (sword) te tabea. Ma Joshua te dato me huatia, “?Ahei ghoe, na kulagha pana levunimate?” ");
INSERT INTO nlg_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ge bosa tughu gaia, “Taho udolu gaira. Inau nina malaghai kamanagho Yahweh.” Tana bona ia eni, Joshua te tumu horu nia na matana / poghotao tana pari nia na kikinima. Ma Joshua te ghoi bosa me vania, “Inau nimua na tinoni ni lutu. ?Muku taonia na hava ko bosa vaniu nia, mana hava to liona ku gonia?” ");
INSERT INTO nlg_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ma nina malaghai kamanagho ni gehemate Lord te bosa tughu vania, “Ko sua kehaa va sasaro ni marevomu, na pukuna na bona to tughuru iga eni te tabu.” Ma Joshua te goni taonia na hava te bosaa vania nia. ");
INSERT INTO nlg_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Na mataula haghe i Jercho tara vongoti ngasilia na pukuna na vure tara mataghu nira na vure ni Israel, mara mua lubatia hei ke horu me ke haghe. ");
INSERT INTO nlg_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ma Yahweh te bosa vania Joshua, “Inau tu vahegho Jericho, nina Vunaghi Haba ma lei nina malaghai. ");
INSERT INTO nlg_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Ma gaira udolu nimua na lei maleghai kara sakutua talighutia na komu sule sakai tughu dani, lokana ono na dani. ");
INSERT INTO nlg_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Me ono na manesukaghi kara sakutua idevia na Bokisi ni Vetena ni Baubahu Tabu, ma kara sopa hola tango sakai na kala ni sheep mane. Mi tana vituni na dani e vitu tughuru ni sakutua talighutiana na komu sule mana lei manesukaghi kara lovui na lei kala kiri. ");
INSERT INTO nlg_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Mi tana bona kau rongovira na lei manesukaghi sakai tughuru ni lolovu daro me ke laga na lei kala ke, na vure udolu kara nia hevei sakai na ghuu te laga. Keri vaho geke dudura horu na peona na komu, mana vure tara sama haghe haliu tana komu.” ");
INSERT INTO nlg_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Keri ke, Joshua te holo kolura na lei manesukaghi me bosa vanira te vagha eni, “Kau ghate datoa na Bokisi ni Vetena ni Baubahu Tabu, makau vilira ra vitu kara idevia, maka sopa tango sakai kala ni sheep mane. ");
INSERT INTO nlg_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Keri ge nia hevei na bosa vanira na vure, “Kau sakusakutua minamina talighutia na komu sule, mana balu mane tara holai na le totobo ni kisumate kara idevia na halautu inaghona nina Bokisi ni Vetena ni Baubahu Tabu Yahweh.” ");
INSERT INTO nlg_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Mi murina Joshua te kokoe soko vanira na vure, ra vitu na manesukaghi kolui nia didira na kala ni sheep mane tara vuivuni ni sakutua tana matana Yahweh, gara lovui na kala tana bona tara tona. Na lei manesukaghi tara holaa na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh tara taonira mai muri. ");
INSERT INTO nlg_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Sakai na ovu ni malaghai ni gehemate kara sakusakutua inaghodia na lei manesukaghi tara tona haliu na lavuani na kala ni sheep mane, mi murina raini na lei manesukaghi tara holaa/ghatea na Bokisi ni Vetena ni Baubahu Tabu, mana eruani na ovu ni malaghai ni gehemate tara sakusakutua imurina gaira. ");
INSERT INTO nlg_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Hauva, Joshua te arevaghi vanira me ghaghua, “Kau bei ghuu, ma sughua kau bei kokokoe. Sughua siki pile ngengo itatana hei, koekobe ku bosaa, ‘Kau ghuu.’ Keri ge kau ghuu!” ");
INSERT INTO nlg_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Mana Bokisi ni Vetena ni Baubahu Tabu nina Yahweh sakai tughuru ni hola talighutia nia na komu sule tana dani keri, vaho gara ghoi oli ni maturu tana bona tara kisui ga na vale tapoledira. ");
INSERT INTO nlg_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Tana labotana na dani vauolu keri, Joshua te mina me rarai kolura na lei manesukaghi mara ghoi hola so na Bokisi ni Vetena ni Baubahu Tabu nina Lord. ");
INSERT INTO nlg_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Ra vitu na manesukaghi kolui na didira na kala ni sheep mane tara sakutua inaghona na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh, mara lovui didira na kala. Na lei malaghai ni kisumate tara idevira na lei manesukaghi kolui didira na kala, ge tumurira mai na Bokisi ni Vetena ni Baubahu Tabu nina Lord. Vaho gara lovu lagai dira na kala rana manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Mi tana ruani na dani, sakai tughuru ni sakutua talighutiana na komu sule, mara ghoi oli so tana maladira tara maturu iga. Mara gonighi te vagha so e ono na bongi/dani. ");
INSERT INTO nlg_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Tana vituni na dani rana vure ni Israel tara rarai labota mara ghoi sakutua talighutiana na komu sule tara nea haia mai. Mi tana dani vaghana ghua so eni, e vitu tughuru ni sakutua talighutiana na komu sule. ");
INSERT INTO nlg_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Me vituni na talighu mua ka, rana manesukaghi tara lovu lagai didira na kala, ma Joshua te arevaghi vanira na vure, me ghaghua, “Kau nia ghaeghahe dato na manga sule, na pukuna Yahweh te nia hevei vanighau na komu sule eni taeni! ");
INSERT INTO nlg_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Na komu sule eni mana lei totobo soko ilokana haurake ma kara pisu, na vatei hevei oli vania Yahweh. Ma Rahab na rebi, maia rahei tana valena vamua kara vola, na pukuna te vavolara rua na tinoni toro mai polo ni vaevane. ");
INSERT INTO nlg_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Kau bei hola gea siki totobo tara taludilai ge kau haurakei, ma kau diua so ke, mi ghau kau hola ghana mate Israel, mi ghau ghua kau mate. ");
INSERT INTO nlg_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Na hava tua tara gonia nia na silver, gold pana bronze mane halo, ke kabu oli vania Yahweh, me ke tana vania nina kei ni baobaore.” ");
INSERT INTO nlg_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Keri ke na lei manesukaghi tara lovui na lei kola ni sheep. Na vure tara rongovia mua tara lovu lagai na kola ni sheep ka, na vure udolu tara ghuu. Me hau vaso na pile ka, na peovatuna na komu sule Jericho te kakovo me dudura horu tana pari, mana vure udolu ni Israel tara sopa sama maemane haghe tana sopa piuna mara dikalaa na komu sule eni. ");
INSERT INTO nlg_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Taho siki totobo ke kabu oli kara mua haurakea, - na mane, vaivine, vure vaolu mana haulaghi didira buluka, sheep, mana donkey, - na lei totobo soko tua. ");
INSERT INTO nlg_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Ma Joshua te bosa vanira rua na tinoni toro vaevane polopolo, koro righitaonia ronimiu na baubahu, mokoro tona tana valena na rebi mokoro hola horua mai, kolura nia nina binaboli. ");
INSERT INTO nlg_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Lei mane vaolu tara haghe mara hola horua mai Rahab, na tamana mana tinana, na lei vaivinena kolua balu nina binaboli tara ghana kolua. Ra hola tonara va lilighina na bona tara maturu iga na Israel. ");
INSERT INTO nlg_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Mana vure ni Israel tara tungi lakena mara kere horua na komu sule Jericho mana lei totobo soko ilokana, Na hava tara gonighi nia vamua na silver, mana gold pana bronze mana halo tara taluolighi vania na keina na Valena/baebale tapole tabu / bona/vale ni rongo nina Yahweh. ");
INSERT INTO nlg_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ma Joshua te taluolia na volana Rahab na rebi ma nina binaboli tana valena, na pukuna te polora rua na tinoni vaevane polopolo Joshua te nira vetena va Jericho. Mana vavatana na vaivine eni te ghana so itatada rana Israel ritini tana dani eni. ");
INSERT INTO nlg_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Tana bona ia eni, Joshua te nia hevei nini bosa vavaranga te vagha eni, “Nina vavaranga Yahweh ke kalea hei ke tabotabo ni gonioliana na komu Jericho. Ahei ke goniolia na bona tana na peona komu, nina kamanagho mane ke mate. Mi tana bona ke sokolaghinia na komu mana taludatoa na mataula haghe, nina kama muri ke mate.” ");
INSERT INTO nlg_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Keri ke, a Yahweh te kabu kolua Joshua, mana ahana te haba dato talighutia Canaan/na butonikomu. ");
INSERT INTO nlg_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Ma vure ni Israel tara mua kabu taonia na vatei hevei oli vania Yahweh. Ma sakai na tinoni na ahana Achan te gitoi na lei totobo keri, ge rutu ngangata Yahweh vanira na vure ni Israel. Achan na dalena Carmi, tana vinavahuhuna Zabdi mana vikena Zerah na kemana Judah. ");
INSERT INTO nlg_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Na balu nina tinoni Joshua te nira vetena i Jericho gekara va vaevane polopolo tana komu i Ai na paleva uluna Bethel, lilighina na komu Beth-Aven. ");
INSERT INTO nlg_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Mi tana bona tara oli mai, gaira tara bosa vania Joshua te vagha eni, “E mua sakai sule na komu vaghana, me ke vulea rua pe tolu na togha itatada kara haurakea. Me mua manada ighita udolu ka tona.” ");
INSERT INTO nlg_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Keri ke, me kaekagena tolu na togha ni malaghai Joshua te nira vetena gekara va veitotoghoni kolura na lei mane tana komu keri, mana lei malaghaina na komu keri tara lagavulera. ");
INSERT INTO nlg_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Na lei malaghai ni Ai tara ghuru tonara didira na malaghai rana Israel, vuivuni tana mataula ni peovatuna na komu mara va nira sara ta sakai na ghotu tara gheli vatu iga. Mi tana bona tara va nira sara tana ghotu keri, na vure ni Ai tara matera tolu hangavulu ono rana lei malaghai Israel. Keri ke rana vure ni Israel tara kubolu didira na ghanaghana/liopatu, mara mataghu. ");
INSERT INTO nlg_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Joshua mana lei nina mane nagho ni Israel tara rosighi didira na pupulu tana bona tara rongovia eni, ra talea iga didira na dikalio. Ra dali ravuni na uludira, mara malu horui na uludira inaghona na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh, poghotao/kolitao horu ritini na nulavi. ");
INSERT INTO nlg_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Ma Joshua te ngangaraha dato vania God me ghaghua, “?Yahweh, ighoe na vunaghi pungisira rana vure, ivei tea go lavi halavughai mai tana beti tina Jordan, mo taladira na taba ni vure Amor gara mateghai? E uto vulea va ge kai kabu vamua levuna na beti Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Lord, u mua ghilala na hava ku bosaa, na pukuna rana ghamami na levunimate tara lagavuleghai mara ghuruolighai tua. ");
INSERT INTO nlg_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Ma ge rana vure ni Canaan mara balu tinoni tara ghanara tana komu ini kara rongovia eni ke, igeva kara ghurughai makara labu pisu mateghai. Me ke ghaghua iga eni ke, mi geva ke subo na vure koehorua na ahamu te habadato. Keri ke mo ko hangaghai.” ");
INSERT INTO nlg_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Ma Yahweh te bosa vania Joshua, “Ko tughuru dato! ?Ivei tea go kolitao/poghotao tana pari te vagha eni? ");
INSERT INTO nlg_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Na vure ni Israel tara palugha, ra diua nigua na baubahu. Ra gitoi na lei totobo tu bosai gekau talukehai vaniu. Ra mua gitoi vamua, ra nighi pego, mara poloi so ta didira na lei totobo lologho. ");
INSERT INTO nlg_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Keri te vagha ge na vure ni Israel tara mua laga vulera ghamiu na levunimate. Rana Israel tara sama sanira na pukuna ighau heghemiu tau nea gau sodoa na totoro eni. Ma keri te vagha ge ighau udolu kau mate. Kau mua kere taghalaghinighi na lei totobo tau gitoi ke, mi nau ku mua kabu kolughau! ");
INSERT INTO nlg_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“Ko tughuru mo ko tona itadira na vure, ma kara marabura ghua tana matagu. Ko tughunitatea nigua na kokokoe te vagha eni, ‘Israel, inau a Yahweh, nimiu na God. Iropo kau mai tagua, na pukuna na balu totobo tau talui so itamiu tu bosai gekau kerei taghalaghinighi. Makau pangotighi so ke, makau mua lagavulera na ghamiu na levunimate. ");
INSERT INTO nlg_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Iropo roropo na lei kema udolu kau mai tagua, taonia sopa kemamiu. Mi nau ku tuhua na kema vagana te ghana iga na tinoni te gonia na hahi eni. Me ke taonia ghua sopa vike ni kema, mi nau ku tuhua hei na vike ia te hahi. Sopa binaboli tana lei sopa vike kara mai, mi nau ku tuhua na binaboli te kabu iga na hahi. Mana sosoko sopa tinoni tana binaboli keri kara mai sakai ma sakai. ");
INSERT INTO nlg_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Ma tinoni ku tuhua ke, gaia keri na tinoni te holai na lei totobo tabu ini. Kau kerea gaia, kolura nia nina binaboli, maia nina na lei totobo lologho. Kau nea vania eni, na pukuna te diua nigua na baubahu tu talua vanighau me lavia mai nia maa ngangata tana Israel udolu.’” ");
INSERT INTO nlg_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Tana roropo ghana Joshua te holokolura na lei sopa kema, makara mai naghona nina baebale tapole tabu Yahweh, ma Yahweh te tuhua na kemana Judah. ");
INSERT INTO nlg_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Mana lei tinoni tana kemana Judah tara mai tona haliu, ma God te tuhua na vikena Zerah. Mi tana bona na binaboli tara mai tona haliu, nina binboli a Zabdi te tuhua. ");
INSERT INTO nlg_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Mana binaboli udolu ta Zabdi tara mai tona haliu, ma God te tuhua Achan na dalena Carmi, a kukuana Zabdi. ");
INSERT INTO nlg_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Ma Joshua te huatia Achan te vagha eni, “Kula dalegu, ko bosa utuni ani tana matana Yahweh, na God ni Israel, mo ko bosatate vaniu mai na totobo dika to gonia. Ko bei poloa gea na hava vaniu.” ");
INSERT INTO nlg_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ma Achan te bosa tughu me ghaghua, “Inau sughua tu hahi tana matana Yahweh, na God ni Israel. ");
INSERT INTO nlg_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Inau tu righia sughua na tivi te uto na reireina tana matagu tara pelu haghea mai Babylon. Erua hangalatu na mavani ni/na silver, kolua nia na midi ni gold, e lima hangavulu na mavani. Gu righi gharu sughua, gu holai mu ghelivaghi nighi loka ni pari tana vale tapolegu. Na rongo na silver tu ghelivaghini horuvulei va.” ");
INSERT INTO nlg_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Ma Joshua te vetenara na balu mane gekara va kene taonighi na hava te gitoi Achan. Ge ra sama va tana vale tapolena Achan mara sodoi na lei totobo te gitoi, kolui nia na silver te gheli horui vulera na balu. ");
INSERT INTO nlg_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Ra holai vania mai Joshua mana vure ni Israel na lei totobo tara sodoi tana vale tapole, mara mai taluhoru tana pari tana matana Yahweh. ");
INSERT INTO nlg_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Keri ge Joshua mana vure ni Israel tara hola Achan kolui nia na silver, na tivi, na gold, na lei dalena na mane mana vavine, nina lei buluka, mana lei donkey, mana lei sheep, na vale tapolena, maia na lei totobo soko te loghoi va tana boboko tara holoa nia Achor. ");
INSERT INTO nlg_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Ma Joshua te bosa vania Achan, “?Na hava na pukuna go gonia va totobo totoro eni vanighai? Mi taeni Yahweh ke torogho!” Mana vure ni Israel tara peta matea Achan ma nina binaboli mara kerei na hulidira mana lei lologho. ");
INSERT INTO nlg_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ra vatorighighi na lei ovu ni vatu vuvungana Achan, mara ghanai so ritini mai taeni. Keri te vagha gara holoa nia na Boboko ni Achor, me sara so taeni. Me soko nina rutu Yahweh vanira na vure ni Israel ta nina hahi Achan. ");
INSERT INTO nlg_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Ma Yahweh te bosa vania Joshua, “Ko bei mataghu mo ko bei ghanaghana ruarua! Ko hola udolura na lei nimua malaghai ni veitotoghoni, mo ko va veitotoghoni kolura na vurena Ai, na pukuna inau ku vahegho na vunaghi haba ni Ai, nina vure, na komuna mana parina. ");
INSERT INTO nlg_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Kau haurakea Ai te vagha tau nea iga na haurakeana Jericho ma nina vunaghi haba. Mi taeni ka, kau holai nimiu oli heghemiu na lei totobo lologho, maia na lei buluka. Mo ko talura na balu malaghai gekara koli polo murina na komu.” ");
INSERT INTO nlg_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Vaho ge rughuhoru Joshua mana lei malagai ni Israel gekara va labura na vurena i Ai. Ma Joshua te vilira tolu hangavulu na toghi ni malaghai geke nira vetena tana bongi, nia na lei bosa ni arevaghi ini, ");
INSERT INTO nlg_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","“Kau koli polo dutuva murina na komu, makau gonidila ni veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Inau kolura nia na balu malaghai kai mai naghona na peona na komu. Tana bona na lei malaghai ni Ai kara mai ma kara gonidila ge kara veitotogoni ke, ighai tai ririu mai sama sanira te vagha na bona te padi. ");
INSERT INTO nlg_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Gaira geva kara ghurughai makai sagauvia na komu, na pukuna kara ghanaghana ighai tai sama sanira vagha ta ghaghua iga na bona te padi. ");
INSERT INTO nlg_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Tana bona ia tua keri, kau tughuru dato sakai sonikolu mai ivei tau sopa polo iga. Makau haghevia na komu makau hola iga na maana. Yahweh, dida/nimiu na God, ke nia hevei nina maana ge kau lagavulea. ");
INSERT INTO nlg_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Tana bona kau lagavulea tua ke, kau kerea nia na lake, me ke tao na ravuna tana pari te vagha Yahweh te bosaa. Aeni gaighi na lei bosa papara kau taonighi.” ");
INSERT INTO nlg_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Keri ke Joshua te nira vetena. Ra rughuhoru mara va koli polo ighobuna Bethel mi paleva bokona Ai. Ma Joshua te kabu oli kolura na vure tana bona tara kabu iga tana bongi keri. ");
INSERT INTO nlg_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Tana roropo ghana Joshua tughuru vaghinira nina lei malaghai, mara vuivuni ni sakutua va i Ai kolura nia lei mane nagho ni Israel. ");
INSERT INTO nlg_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Mara taludatoi na vale tapoledira paleva ulu/longa north datona Ai, mana boboko ighobu te vokara. ");
INSERT INTO nlg_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Mi tana bongi ia tua keri Joshua te nira vetena lima na toga ni malaghai gekara va koli polo tana paleva bokona, i ghobuna Bethel mi Ai. ");
INSERT INTO nlg_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Ra talura subona na malaghai ulu/longa datona na komu, mara talura na balu makara koli polo paleva bokona na komu. Ma Joshua te maturu heghena tana boboko tana bongi eni. ");
INSERT INTO nlg_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Tana bona na vunaghi haba ni Ai te righira Joshua ma nina lei malaghai tara mai, e mua pitu tua. Tana labota, e rughuhoru kolura nina lei malagha mara tona via gatu na boboko Jordan, ma kara veitotoghoni kolura na Israel tara ghaghua so iga te padi. Hauva me mua ghilala gaia kara kisumatedira mai muri. ");
INSERT INTO nlg_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Joshua ma nina malaghai tara pegora, mara vuivuni ni sama oli mai tana bona mamaha gekara ghanaghana tara matagu gara sama oli, hauva mara pegora vamua. ");
INSERT INTO nlg_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Na vunaghi haba ni Ai te holora na lei mane udolu ni komu ge kara ghuru taonira Joshua ma nina malaghai ni Israel. Mi tana bona tara ghuru taonira, ra sagauvi ngangata tua na komudira. ");
INSERT INTO nlg_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Na lei mane udolu ni komu Ai mi Bethel tara ghuru taonira rana Israel, mara mataula haghe tana peona na komu Ai te hahangavi, me taho hei ke righitaonia/vatogha. ");
INSERT INTO nlg_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Keri ke a Yahweh te bosa vania Joshua, “Ko tuhua na komu Ai nia nimua na tinabe. Mi taeni tu talamu ge kau holatughua na komu keri.” Ma Joshua te goni taonia na bosa ni arevaghi te vahea God. ");
INSERT INTO nlg_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Me hau vaso na pile, Joshua te nia hevei nina talu vaughilala, mana lei malaghai tara kabu polo, tara tughuru dato mara sama haghe ilokana na komu mara mina tua mara hola tughua, gera tungia lakena. ");
INSERT INTO nlg_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Tana bona na lei malaghai ni Ai tara rei oli mara righia na ahuna te pouta dato me sara na parako, ra mua pukuna ivei kara hava na tona, na pukuna na lei malaghai ni Israel tara sama tana bona mamaha ka, tara ririu oli mai, mara vuivunia na veitotoghoni oli, mara matera na lei malaghai ni Ai. ");
INSERT INTO nlg_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Na pukuna, mi tana bona Joshua mana balu vure ni Israel tara righia na lei maleghai tara kabu polo tara nia tangomana na lutu tara nea, mara righia na ahuna na komu te pouta dato, ra ririu oli mai mara labura na vure ni Ai. ");
INSERT INTO nlg_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Mana lei malaghai ni Israel ilokana na komu tara horu mai, mara vuivuni ni labumateadira mai muri. Mana lei mane/malaghai ni Ai tara haghe ilokana na piti, mara labumate udolura, taho tua hei ke vola, pe ke sama polo. ");
INSERT INTO nlg_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Na vunaghi haba ni Ai vamua gera hola volaa, mara hola vania va Joshua. ");
INSERT INTO nlg_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Mi tana bona na lei malaghai ni Israel tara labumate sokora na le tinoni pari bebetena na komu, ra olivia na komu mara taghalaghini sokora ilokana. ");
INSERT INTO nlg_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Na subodira na vurena na komu Ai tara labu pisu matera tana dani ia keri te saravia hangavulu rua na togha. ");
INSERT INTO nlg_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","E nia tona haliu so na tabe (hau) datoana nina tinabe Joshua, koekobe ra mate pisu sokora rahei tara kabu i Ai. ");
INSERT INTO nlg_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Na le buluka mana lei totobo te mategha vamua tara mua haurakei, na pukuna rana Israel tara taluolighi ini vanira oli te vagha Yahweh te bosaa vania nia Joshua. ");
INSERT INTO nlg_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Joshua kolura nina lei malaghai tara haurakea mara kerehorua me vavu tana pari na komu Ai. Me sopou ghaghua iga me sara mai so taeni. ");
INSERT INTO nlg_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Ma Joshua te tari sasaraua na vunaghi haba ni Ai tana ghai, me sasarau iga ritini na nulavi. Tana huu ni aho vaho ge bosa vanira na vure ni Israel mara hola horua na hulina mara sonia va tana peo mataula haghe ni komu. Ra soni pilu vatuna na hulina mara ghanai so na vatu ini ritini mai taeni. ");
INSERT INTO nlg_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Keri ke Joshua te kisua na bela ni sukaghi vania Yahweh, na God ni Israel, kouna na ghotu Ebal. ");
INSERT INTO nlg_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","E kisu taonia nia nina bosa ni arevaghi God/Yahweh te bosaa vania nia Moses nina tinoni ni lutu, te gerea tana buka ni vetena te ghaghua, “Ko kisua vaniu na bela ni sukaghi nia na votu tara mua sarighi mara mua tokai nia na lei totobo ni lutu (halo).” Mi tana bela ni sukaghi keri, kara nia heveioli vania Yahweh, na lei sukaghi kekere mana lei sukaghi ni mabo. ");
INSERT INTO nlg_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Mana vure ni Israel tara vaevanea, Joshua te gere taonighi nina vetena Moses ivuvungana na vatu tana bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Tana bona ia keri, na lei kemani Israel, rana vure tara mua Jew, na lei mane nagho ni Israel, na lei mane naghodira na lei malaghai, na lei mane dete, tara savukolu mara gonighi rua na ovu. Sakai na ovu kara tughuru tana pukuna na ghotu Gerizim, me ruani tana pukuna na ghotu Ebal, sopa ovu kara sopa nagho kolu, mi ghobudira kara tughuru na lei manesukaghi tana kemana Levi kara ghatea na Bokisi ni Vetena ni Baubahu Tabu nina Yahweh. Kara taonia nina bosa ni arevaghi Moses, nina tinoni lutu Yahweh makara tughuru dila te vagha eni geke nia hevei nina vauto na manesukaghi. ");
INSERT INTO nlg_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Mi murina eni, Joshua te idumi tatea na lei bosa te gerei tana buka ni vetena te tughu nia na hava te uto God te nia hevei gekara taonia na vetena, mana lei dika ke kalera ge takara mua taonia. ");
INSERT INTO nlg_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Na lei nina bosa ni arevaghi udolu Moses te idumi tatei Joshua vanira na vure udolu ni Israel. Kolua nia, na lei vaivine, na lei meomeo, ma rana vure tara mua Jew tara kabu kolura na Israel. ");
INSERT INTO nlg_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Na lei vunaghi haba paleva bokona na beti Jodan tara rongovighi na lei totobo te kale. Na lei vunaghi haba na kemadira na Heth, Amor, Canaan, Periz, Hiv maia Jebus tara ghanara tana lei ghotu maia tana lei nanata me sara tana tahi Mediterranean, me holaa me va nia sara sarana na lei ghotu ni Lebanon. ");
INSERT INTO nlg_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Na lei vunaghi haba ini tara padapada koukolu gekara talukolura didira na lei malaghai ni veitotoghoni makara veitotoghoni kolura nina malaghai Joshua mana vure ni Israel. ");
INSERT INTO nlg_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Mi tana bona na vure ni Gibeon tara rongovia na hava te kalea i Jericho mi Ai, ");
INSERT INTO nlg_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","gaira tara padapada gekara mai gonia na pego gekara bei matera gea. Gara nira vetena na balu itadira, gekara va padapada vania Joshua. Ra talui na luludadira ivuvungani didira na donkey na lei baeke haulaghi mana lei ghuighuli ni sheep na vatei dode wine tara tarosi mara goniutoi. ");
INSERT INTO nlg_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Ra nighi pupulu na tivi marosi, mara haharani na tuadira tara sukisuki kolui, maia na berete modiri me mamaha na ohodira. ");
INSERT INTO nlg_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Tana bona tara mai sara tana bona tara kabu iga rana Israel i Gilgal, ra bosa vania Joshua maia na lei mane ni Israel mara ghaghua, “E hau ngangatana komu tai butu mai ga, ge kai mai nongigho ma kai mai gonia na baubahu ni mabo kolugho.” ");
INSERT INTO nlg_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Mana lei mane ni Israel tara bosa tughu vanira na vure i Hiv, “?Ivei kai nea na ghilalamiu e dutu pe hau na komu tau mai ga? Me ke ghaghua iga ke, kai mua tangomana na goniana na baubahu ni mabo kolughau.” ");
INSERT INTO nlg_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Ma gaira tara bosa vania Joshua, “Ighai nimiu na tinoni ni lutu.” Joshua te huatira me ghaghua, “?Ma hei sughua ighau? ?Mi vei tau butu mai?” ");
INSERT INTO nlg_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ma gaira tara bosa tughu mara ghaghua, “Ighai tai butu hau ngangata mai, mai rongovia na ladana Yahweh, nimiu na God, mana hava te gonia tana butonikomu Egypt. ");
INSERT INTO nlg_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","Mai rongovia ghua na hava te nea vanira rua na vunaghi haba uluna na beti Jordan, na vunaghi haba Sihon ni Heshbon ma Og, na vunaghi haba ni Bashan (te kabu i Ashtaroth). ");
INSERT INTO nlg_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Keri ge ra talu kokokoe vanighai na lei naghomami ma kulamami na vure ge kai gonidilai na balu oho ta nimami na mai righiamiu ge kai nimua na tinoni ni lutu vamua. Mai nongighau, gekau gonia na baubahu ni mabo kolughai, gekai tamakulani kolughau. ");
INSERT INTO nlg_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Na berete ini tara papara tai divei tana bingiti tai sania mai na komumami, mi taeni ra mamaha mara modiri tua. ");
INSERT INTO nlg_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Na lei ghuighuli ni sheep tai dodei nia na wine tara vaolu bona tai sania na komumami, mi taeni tau righighi ra haulaghi mara potapota tua. Ma sughua nimami na tivi, maia na hahara ni tuamami tara tarosi ta nimami va vinano mai.” ");
INSERT INTO nlg_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Mana lei mane naghodira na vure ni Israel tara mua diki talutate/huatia vania God, keri ge ra ghania na berete, na vaughilala tara holopangotira rana vure. ");
INSERT INTO nlg_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Ma Joshua te gere aha tana baubahu ni mabo, kolura na lei mane nagho ni Israel tara talamaghi mara holopangotia didira na baubahu. ");
INSERT INTO nlg_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Mana lei ghanaghana e tate murina tolu na bongi, na lei mane ni Gibeon ini te dutu so na komudira. ");
INSERT INTO nlg_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Mana vure ni Israel tara rughuhoru ma va kene taotaonia gaira va saravia na komudira e tolu vamua na bongi, mana lei aha ni komu raini Gibeon, Kephirah, Beeroth mi Kiriath-jearim. ");
INSERT INTO nlg_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Mara mua matera, na pukuna na lei mane nagho ni Israel tara diki gonia tua na baubahu itadira tana ahana Yahweh, na God ni Israel gekara mu matera makara mua gonia vanira siki totobo. Mana vure ni Israel tara nia ghuru varongo vania Joshua kolura nia na balu naghodira na vure ni Israel nia na baubahu te mava eni. ");
INSERT INTO nlg_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Mara na lei manenagho tara bosa mara ghaghua, “Ighita ta goni sokoa ta na baubahu te mava eni tana ahana Yahweh, dida na God geka mua matera. ");
INSERT INTO nlg_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ka nera gekara vola, ke bei rutu vanighia gea God ka diu na baubahu ta gonia tana ahana. ");
INSERT INTO nlg_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Ka lubatira makara vola, hauva ka nera ge kara tagi ghai makara heo beti vanighita. ");
INSERT INTO nlg_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Ma Joshua te holora na lei tinoni ni Gibeon me ghaghua vanira, “Na hava na pukuna gau pegoghai? Au bosa ke, me hau ngangata na komumiu, au ghaghua! Hauva mau pego! E mua hau so na komumiu. ");
INSERT INTO nlg_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ma God ke deteghau, na pukuna nimiu na pegopego, keri ke, mi geva ighau udolu nimami na seka, ma nimiu na lutu ke na tagi ghai maia na heo betina na Vale tapole tabu nina/dida na God. ");
INSERT INTO nlg_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Ma gaira tara bosa tughu vania Joshua, “Ai gonia na pego na pukuna ra bosa vanighai a Yahweh, nimiu na God, te bosaa vania nina tinoni ni lutu, Moses, geke haurakera me ke matera na lei tinoni tara ghanara. Mai mataghu mai nia ghaghua na volamami gai gonia sughua. ");
INSERT INTO nlg_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Mi taeni ke, tana limamiu/nimiu na maana tua tai sopou! Kau ne taonia vamua na hava tau ghanaghana te maemane kau nea vanighai.” ");
INSERT INTO nlg_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Ma Joshua te mua lubati rana vure ni Israel gekara matera. ");
INSERT INTO nlg_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Me nera geke didira na seka mana lutudira na tagi ghai mana heo ghadira na beti maia na betina nina bela ni sukaghi Yahweh. Mara gonia na lutu eni me sara mai so itaeni. ");
INSERT INTO nlg_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Adonizedek, na vunaghi haba ni Jerusalem te rongovia Joshua te lagavulera me matera na vurena Ai me matera na vunaghi haba ni komu iga, te vagha gaia te gonia vania Jericho mana nina vunaghi haba. Ma Adonizedek te pukura ghua rana vure ni Gibeon tara mabo kolura rana Israel mara nera gekara didira na seka. ");
INSERT INTO nlg_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Gaia maia kulana vure tara mataghu sule ngangata tana bona tara rongovighi na lei tutugu ini, na pukuna Gibeon ke na komu te sule me subo ghua na vurena mara laga ghua na veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Keri ke na vunaghi haba Adonizedek te na hevei na rongorongo vanira va na lei vunaghi haba: Hoham ni Hebron, Piram ni Jarmuth, Japhia ni Lachish ma Debir ni Eglon. ");
INSERT INTO nlg_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Me bosa vanira te vaghi eni, “U nongi ngangataghau gekau mai hanga geka veitotoghoni kolura na lei malaghai i Gibeon, na pukuna ra talukolu tua ta Joshua maia rana Israel. ");
INSERT INTO nlg_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Keri ke, me lima na vunaghi haba tana kemana Amor kolura nia didira na malaghai tara mai mara talighutia Gibeon mara vuivuni ni veitotoghoni koluadira. ");
INSERT INTO nlg_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Mana lei mane haba tana komu keri tara nia vetena na kokokoe vania Joshua i Gigal, mara ghaghua vania, “Ighoe na vunaghi, kau mina makau saravighai mai, kau bei sani lea ghani te vagha eni, na lei vunaghi haba tana kemana Amor tara ghanara tana lei ghotu tara talukolu tua gekara veitotoghoni kolughai.” ");
INSERT INTO nlg_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ma Joshua te lavi udolura nina lei malaghai kolura nia nina lei mane nagho ni veitotoghoni mara tonavia va Gibeon. ");
INSERT INTO nlg_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ma Yahweh te bosa vania Joshua, “Kau bei mataghunia gea. Mi nau ku idevighau gekau lagavulera, me taho siki sakai tadira ke lagavuleghau.” ");
INSERT INTO nlg_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Tana bongi udolu keri Joshua kolura nia nina lei maleghai tara sania Gigal mara sakutua va i Gibeon. Mi tana puipungi rana malaghai ni Amor tara hare tana bona tara righira Joshua kolura nina lei malaghai tara mai veitotoghoni kolura. ");
INSERT INTO nlg_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Yahweh te nera na lei malaghai didira na Amor ge ra ribe mara mataghunira na lei malaghai ni Israel, ge ra sama kolili vamua. Joshua ma nina lei maleghai tara labu matera subo ngangata na malaghai tana bona keri, mara ghuru kolilira taonia na halaulu va tana komu i Beth-Horon maia i Azekah mi Makkedah paleva longani. ");
INSERT INTO nlg_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Tana bona tara sama horu tana ghotu na vure ni Amor, a Yahweh te nia vetena horu mai na vatu te bihi vagha na ice/kebungasi me kutu horu ivuvungadira, me subo tara mate vulea Joshua ma nina malaghai tara matera nia na isi. ");
INSERT INTO nlg_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Tana dani keri Yahweh te vahera na vure ni Israel na lagavule itadira rana vure ni Amor. Ma Joshua te kokoeliulivuti vania Yahweh tana matadira na vure ni Israel me ghaghua, “Ko betoa na hina ke bei gharadu sasia mua/tughuru beto Gibon maia na vula tana boboko i Aijalon.” ");
INSERT INTO nlg_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Keri ke, na hina mana vula toro tughuru beto koekobe rana Israel tara lagavule sokora ghadira na levunimate. Na tutugu eni tara gerea ta nia book Jashar. Na hina te tughuru beto ighobuni paupatuna na oka, me mua huu te vagha sakai na bongi/dani/ghaghua haia iga. ");
INSERT INTO nlg_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Ma Lord te veitotoghi ni tugura rana Israel tana bongi keri. Te mua kale na bongi te vagha mi sara tana itaeni, ge Yahweh te nea te vagha keri vania siki tinoni tana bosa tughuana na nongi tana tinoni. ");
INSERT INTO nlg_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Mi murina keri, Joshua ma nina malaghai ni Israel tara ghoi oli tana bona tara so kabu iga i Gilgal. ");
INSERT INTO nlg_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Tara bona ni veitotoghoni e lima na vunaghi haba tara sama polo, mara va polo ilokana na vatuluma i Makkedah. ");
INSERT INTO nlg_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Ma Joshua te rongovia tara sodora, ");
INSERT INTO nlg_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","e nia hevei nina bosa ni arevaghi vanira nina malaghai, “Kau pataa nia na vatu na matana na vatuluma, makau talura balu na mane righitaoni tana matana na vatuluma ge kara bei horu mai gea na lei vunaghi haba ini. ");
INSERT INTO nlg_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Hauva bei beto iga! Kau tona haliu na ghuruadira so na levunimate makau sama pungisira mai i muri. Kau bei taladira gea makara oli tana komudira, na pukuna Yahweh dida na God te nia hevei vanighita na lagavule.” ");
INSERT INTO nlg_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Keri ke, Joshua mana lei malaghai ni Israel tara tona haliu na labumateadira e lima na ovu ni malaghai, mara mua subo tana ghana olira tara tabotabo ngangata na sara oli tana komudira. ");
INSERT INTO nlg_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Keri ge rana malaghai ni Israel tara ghoi oli tatavahale ta Joshua i Makkedah. Mi murina eni taho hei ke ghoi koengelera rana Israel. ");
INSERT INTO nlg_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Keri ke, ma Joshua te bosa, “Kau gharadu kehaa na vatu tau pata nia na vatuluma, makau holera vaniu mai e lima na vunaghi haba kiri.” ");
INSERT INTO nlg_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Keri gera hola horura mai lima na vunaghi haba ni Jerusalem, Hebron, Jarmuth, Lachish maia Eglon. ");
INSERT INTO nlg_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Joshua te bosa vanira na habadira nina malaghai, “Kau mai makau turighi na luadira.” Mara goni taonia na hava te bosa vanira nia. ");
INSERT INTO nlg_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Keri ke, Joshua te bosa vanira na habadira, “Kau bei mataghu me ke bei ruarua na ghanaghanamiu. Kau tughuru ngasi, na pukuna Lord ke gonighi na lei lutu ini tadira na ghada levunimate.” ");
INSERT INTO nlg_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Ma Joshua te matera sasakai tadira na vunaghi haba ini me tari sasaura ra kouna e lima na ghai saravia na nulavi. ");
INSERT INTO nlg_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Bona te dutu ni huu tua na hina, Joshua te nia hevei horu nina arevaghi gekara hola horui na hulidira rana vunaghi haba ini, mara sonighi lokana na vatuluma tara polo iga. Vaho ge ra vongotia na mataulana na valuluma nia na ovu ni vatu. Gaighi tara sopou iga sara itaeni. ");
INSERT INTO nlg_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Tana dani vaghana so keri, Joshua e haurake udolui na komu sule Makkedah, e mate sokoa kolua nia na vunaghi haba. Taho siki sakai ke vola tana komu. E matea na vunaghi haba ni Makkedah te vagha te nea na mateana na vunaghi haba ni Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Mi murina eni, Joshua maia rana malaghai ni Israel tara tona i Libnah, geka va suravia. ");
INSERT INTO nlg_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Ma Yahweh te ghoi nia hevei so vanira na komu maia na vunaghi haba. Ra dokora, me taho hei ke ghana olia tana komu. Joshua te ghoi matea so na vunaghi haba ni Libnah te nea iga na mateana na vunaghi haba ni Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Tughuru Libnah, Joshua ma rana Israel tara tonavia vaa i Lachish na suraviana. ");
INSERT INTO nlg_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Mi lokani erua na bongi tara veitotoghoni tua ka, a Yahweh te lagalagara na lei malaghai nina Joshua gekara lagavulera na vurena na komu keri. Ra mate sokora lagavulera na vurena Lachish te vagha tara nera iga na vurena i Libnah. ");
INSERT INTO nlg_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Na vunaghi haba Horam tana komu i Gezer tara mai hangara na vurena Lachish, hauva Joshua kolura nia nina lei malaghai tara mate sokora. ");
INSERT INTO nlg_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Mi murina eni, Joshua kolura nina malaghai tara ghoi tona va ta sakai na komu tara holoa nia Eglon, mara talighutia mara veitotoghoni kolura na vurena na komu keri. ");
INSERT INTO nlg_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Mi tana bongi ia so keri, gaira tara mate sokora na vurena i Eglon te vagha tara nera iga na vurena Lachish. ");
INSERT INTO nlg_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Mi murina eni, Joshua kolura nina malaghai ta sania na komu keri, mara suravia na komu tara holoa nia Hebron. ");
INSERT INTO nlg_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Gaira tara hola tughua na komu, mara mate sokora na vurena, kolua nia didira vunaghi haba, maia na lei komu pile talighutia i Hebron. Ra mate sokora na lei vurena, te vagha tara nera na vurena Eglon. ");
INSERT INTO nlg_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Mi murina eni Joshua maia nina lei malaghai tara ririu pulohi va ta sakai na komu tara holoa nia Debir, mara veitotoghoni kolura. ");
INSERT INTO nlg_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Mara hola tughua na komu keri, maia didira na vunaghi haba maia na lei komu pile tara dutuvia, mara mate udolura. Joshua ma nina lei malaghai tara nea taonia na hava tara nea vania na vunaghi haba ni Hebron mi Libnah. ");
INSERT INTO nlg_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Ma Joshua ma nina malaghai tara lagavulera na lei vunaghi haba mana vurena na lei komu keri, rahei tara ghana tana lei ghotu, mi tana bona te dutuvia na beti Jordan, maia hei tara ghana tana bona mamaha paleva longana tara holoa nia na Negev, maia hei tara ghana tana ghotu paleva bokona, tara holoa nia na Shephelah. Mara mate sokora didira lei vunaghi haba, maia na lei tinoni nina lei komu keri, na pukuna a Yahweh, didira na God rana vure ni Israel, me liodira ge kara nea te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Na bona ni pari tara holaa tughua tana bona ni veitotoghoni te vuivuni Kadesh Barnea paleva launa me sara Gaza dutuvia na tahi Mediterranean, me ghoi vuivuni Goshen me sara Gibeon i kouna na lei bona ni pari ini. ");
INSERT INTO nlg_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Tana bona vaghana eni Joshua te lagavule sokora na lei vunaghi haba kolui nia didira na lei pari na pukuna Yahweh, didira na God rana vure ni Israel, me hangara tana veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Mi murina eni Joshua maia nina malaghai tara ghoi oli va i Gilgal. ");
INSERT INTO nlg_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Tana bona na Vunaghi haba Jabin ni Hazor te rongovia na hava te kale, gaia te nia vetena na rongorongo mava vanira vaa na lei vunaghi haba ini, Vunaghi haba Jobab ni Madon, mana vunaghi haba ni Shimron mana vunaghi haba ni Acshaph, ");
INSERT INTO nlg_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","mana lei vunaghi haba tara ghanara tana lei pukuni na lei ghotu talighutia, mana lei vunaghi haba tana boboko i Jordan uluna/tana south na kolokama ni beti i Galilee, mana lei vunaghi haba tana pukuni na lei ghotu bokona, mana lei vunaghi ni Naphoth–Dor bokona. ");
INSERT INTO nlg_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Ma gaia te nia vetena ghua na rongorongo mava vanira vaa na kemana/rana vure i Canaan, bokona mi ulena, mana kemana Amor, maia na kemana Heth, na kemana Periz, na kemana Jebus tara ghanara tana lei ghotu, mana kemana Hiv tara ghanara na lei gege horu tana/sarana na ghotu Hermon, tana boboko i Mizpah. ");
INSERT INTO nlg_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Keri ke, na lei vunaghi haba ini tara talukolui didira na lei malaghai gekara veitotoghoni kolura rana Israel. Ra talukolura didira malaghai, didira na lei horse mana lei taitakiro te ghora na horse, te vaghera na subodira na saghalea tana saravahale. ");
INSERT INTO nlg_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Ra taludatoi didira na vale tapole talighutia na beti lilighina Merom, ma kara gonidila ge kara veitotoghoni kolura rana Israel. ");
INSERT INTO nlg_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Ma Yahweh te bosa vania Joshua me ghaghua, “Ko bei mataghunira gea, te vagha na bona ia taeni i ropo ke, gaira udolu kara mate. Ko tokai na tuadira didira na lei horse gekara bei sakutua, mo ko kerei didira na lei taitakiro.” ");
INSERT INTO nlg_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Keri ke, Joshua ma nina lei malaghai tara tonavia va na beti lilighina Merom mara veitotoghoni minamina kolura inaghona tara gonidila tua.. ");
INSERT INTO nlg_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Ma Yahweh te vahera nina lagavule ta ghadira na levunimate. Rana Israel tara ghurura va tana komu sule Sidon, mi Misrephoth-maim, paleva uluna na boboko i Mizpah ritina taho siki sakai ke vola. ");
INSERT INTO nlg_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Ma Joshua kolura nina Malaghai tara goni taonighi na hava te bosa vanira nia Yahweh, gera tokai na ula ni na tuadira didira na horse mara kerei didira na taitakiro ni veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Tana bona keri, na Vunaghi haba ni Hazor te vunaghi pungisira rana vure maira na lei vunaghi haba tara veitotoghoni kolura Israel. Keri ge Joshua ma nina malaghai tara ririu pulohi mara lagavulea na komu sule Hazor, mara matea didira vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Joshua kolura nia nina malaghai tara mate sokora rana vure ni Hazor, mara kere horua na komu. Taho siki sakai lokana te vola. ");
INSERT INTO nlg_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Joshua ma nina malaghai tara holai na lei komu maia na lei vunaghi haba. Ma Joshua te bosa vanira nina malaghai gekara labumate sokora, te vagha Moses nina tinoni ni lutu Yahweh te bosaa. ");
INSERT INTO nlg_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Ma Joshua ma nina malaghai tara kerea Hazor, hauva tara mua kerei na lei komu tara ghahai kou ni ghotu. ");
INSERT INTO nlg_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Mana vure ni Israel tara labumate sokora rana vure ilokani, mara holai heghedira didira na lei totobo uto kolui nia didira na maumanu. ");
INSERT INTO nlg_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","God te bosai tua na lei kokokoe ini vania Moses nina tinoni lutu idania, ma Moses te bosai Joshua geke gonighi. Keri ke Joshua te taoni utoi na lei bosa Yahweh te arevaghi vania Moses. ");
INSERT INTO nlg_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Joshua ma nina malaghai tara holai tua na lei pari vuivuni boko me sara ulu. Mara holai na lei komu tana ghotu, maia na lei komu tana lei boboko i betitina Jordan, na bona mamaha tara holoa nia Negev, na boboko i Goshen, mi tana lei nanata ni Israel ");
INSERT INTO nlg_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Ra holai na lei bona ni pari tana ghotu Halak, paleva launa dutuvia na bubulo i Edom, me va saravia Baal-gad tana boboko i Lebanon paleva launa, sarana na ghotu Hermon. Joshua te lagavulera na lei vunaghi haba me matera. ");
INSERT INTO nlg_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Me daro ni bona ngangata tua Joshua te veitotoghoni kolura na lei vunaghi haba ni komu ini, me lagavulera sokora tua. ");
INSERT INTO nlg_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Na kemana Hiv tara kabui Gibeon vamua tara dolo kolura Joshua mana vure ni Israel. Mana lei taba ni vure soko, Joshua kolura nia nina malaghai tara labu pisu matera soko. ");
INSERT INTO nlg_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Ma Yahweh te ne udolura gera liona ngangata so na veitotoghoni koluadira na vure ni Israel, me nea ghua Joshua ma nina lei malaghai gera mua arovira mara labu pisu matera. Aeni na hava Yahweh te bosa/arevaghi vania nia Moses dania. ");
INSERT INTO nlg_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Mi tana bona ia ghua keri Joshua ma nina lei malaghai tara labumatera na lei mumutabu tana kemana Anak, tara kabu tana komu i Hebron mi Debir mi Anab maia tana lei ghotu tana Judah ma Israel. Gaira tara labumate sokora mara durakei nina lei komu. ");
INSERT INTO nlg_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Joshua ma nina malaghai tara mate sokora na lei mumutabu tara ghana tana lei bona keri. Rua pe tolu vamua tara ghana tana lei komu i Gaza, Gath, mi Ashdod. ");
INSERT INTO nlg_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Keri ke, Joshua ma nina lei malaghai tara hola udolui va na lei pari tana lei bona kiri te vagha Yahweh te bosa vania nia i dania Moses. Mi muruia eni, Joshua te kobe vokai na lei bona ni pari ghobudira na lei kema ni Israel. Mi murina eni, gaira tara sopou beto mara loghoa na mabo. ");
INSERT INTO nlg_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Idania mai, Moses te hulira na vure ni Israel na veitotoghoni me lagavulera erua na vunaghi haba paleva uluna na betitina Jordan, me lagavulera rua sagui didira na pari. Na vovoka ani didira na pari rua na vunaghi haba ini te vuivuni na nanata Arnon me dato me sara tana betitina Jordan mi tona haliu me va sara tana ghotu Hermon paleva launa. ");
INSERT INTO nlg_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Ma sakai tadira na vunaghi haba ini na ahana Sihon. Gaia te vunaghi haba tana kemana Amor, me ghanaa tana komu sule i Heshbon. Gaia te vunaghi pungisia na levuna Gilead, te vuivuni tana komu Aroer tana lavuna/lilighina na nanata Arnon, me tona i ghobuna na nanata Arnon me sara va tana betitina Jabbok paleva launa, aeni na ririti/kobevoka tana kemana Amon. ");
INSERT INTO nlg_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Ma Sihon te haba pungisia ghua na boboko Jordan mi bokona na kolokama ni beti i Galilee, ma va saravia na tahi Mate paleva longana maia na komu Beth–Jeshimoth i uluna, maia na ghotu Pisgah. ");
INSERT INTO nlg_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Ma sakai ghua ke na vunaghi haba Moses ma rana Israel tara lagavulea ke, a Og na vunaghi haba ni Bashan. Gaia na sosoko tadira na kemana Rapha, na mumutabu, me vunaghi pungisi tana erua na komu i Ashtaroth maia Edrei. ");
INSERT INTO nlg_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","E vunaghi pungisighi na lei bubulo te saroa paleva launa/longana/North va tana ghotu Hermon mi tana komu Salecah i uluna, ma gaighi udolu i Bashan paleva uluna me sara tana riritira na kinakabu ni Geshur mi Maacah. Me vunaghi pungisighi ghua na levuna Gilead me sara tana pilena na bubulona na vunaghi haba Sihon ni Heshbon. ");
INSERT INTO nlg_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Moses, nina tinoni ni lutu Yahweh, maia na vure ni Israel tara haurakera nina vure na Vunaghi haba Sihon maia na Vunaghi haba Og. Keri ge Moses te nia hevei didira na pari vania na kemana Ruben, na kemana Gad, mana levuna na kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Ra ini na gegeredira na lei vunaghi hali Joshua mana lei malaghai ni Israel tara lagavulera ililighi bokona na betitina Jordan, te vuivuni Baal-gad tana lei nanata Lebanon, va tana ghotu Halak te tona dato va Edom. Na lei pari keri ke, Joshua te nia hevei vanira na lei kemana keha ni Israel tara holai tua. ");
INSERT INTO nlg_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Na lei bona ni pari Joshua te tuvalighi vanira te vuivuni tana lei ghotu me tona me va sara lilighini na le ghotu i boko tara holoa nia Shephelah, ge va sara tana na nanata tana betitina Jordan paleva uluna, ge va saravia malangava na bona mamaha tara holoa nia Negev. Idania na lei bona ni pari ini ke, didira na taba ni vure Het, maia Amor, na tabani vurena Caanan, maia na taba ni vurena Periz, Hivi, maia Jebus tara ghanara. ");
INSERT INTO nlg_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Joshua ma nina malaghai tara lagavulera tua na lei vunaghi haba tana lei komu te vagha i Jericho, Ai te dutuvia Bethel, ");
INSERT INTO nlg_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","mi Jerusalem, mi Hebron, ");
INSERT INTO nlg_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","mi Jarmuth, mi Lachish, ");
INSERT INTO nlg_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","mi Eglon, mi Gezer, ");
INSERT INTO nlg_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","mi Debir, mi Geder, ");
INSERT INTO nlg_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","mi Hormah, mi Arad, ");
INSERT INTO nlg_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","mi Libnah, mi Adullam, ");
INSERT INTO nlg_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","mi Makkedah, mi Bethel, ");
INSERT INTO nlg_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","mi Tappuah, mi Hepher, ");
INSERT INTO nlg_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","mi Aphek, mi Lasharon, ");
INSERT INTO nlg_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","mi Madon, mi Hazor, ");
INSERT INTO nlg_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","mi Shimron Meron, mi Acshaph, ");
INSERT INTO nlg_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","mi Taanach, mi Megiddo, ");
INSERT INTO nlg_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","mi Kedesh, mi Jokneam tana bubulo i Carmel, ");
INSERT INTO nlg_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","mi Dor tana bubulo i Naphath-Dor, mi Goyim tana bubulo i Galilee, ");
INSERT INTO nlg_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","mi Tirzah. Gaira udolu ara tolu hangavulu sakai na vunaghi haba kolui nia na komudira tara haurakei. ");
INSERT INTO nlg_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Tana bona Joshua te tonikama tua, a Lord te bosa vania, “Ighoe to tonikama tua, me subo mua na pari te ghani gekau lagavulei gekau loghoi. ");
INSERT INTO nlg_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","Na vure tara liona sono gekara loghoi didira na pari na Philistia mana Geshur. ");
INSERT INTO nlg_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","Tana bubulo didira na Canaan - Na pari te vuni tana daidari Shihor, na vovokani Egypt, me tona longa me va sara tana vovokana i Ekron, - rana lima na vunaghi haba ni vure ni Philistia tara vunaghi pungisighi na komu sule Gaza, mi Ashod, mi Ashkelon, mi Gath maia Ekron, Mana didira na pari na Avvite te ghanaa mua, ");
INSERT INTO nlg_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","gekau lagavulea makau lavia, na pari raini didira na Canaan, kolua nia didira Sidon, me tona haliu longa va i Aphek va tana i vovoka ni Amor. ");
INSERT INTO nlg_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","Ma didira na pari na Gibal maia na lei ghotu ni Lebanon m tona ghalagha te vuni Baal-gad sarana na i Hermon me va sara i hebo-hamath. ");
INSERT INTO nlg_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","Na lei ghotu te vuni Lebanon me va sara i Misrephoth, maia na pari udolu didira na Sidon. “Inau ku ghuru kehaa na vure tana lei pari raini geke vanira rana Israel gekara loghoi te vaghaa tu vetenagho nia. ");
INSERT INTO nlg_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Na lei ke vania tua ana Israel, mo ko tuvalighi ighobudira ara hiua na kema mai na levuna na kemana Manasseh.” ");
INSERT INTO nlg_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Na levuna na Kemana Manasseh maia na Kema dira Reuben ma Gad tara lavi sokoa tua na tunuvadra tana levu uluna Jordan, Moses nina tinoni lutu God te iki vahera tua. ");
INSERT INTO nlg_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Didira na bubulo te vuni tanaKabara ni beti Aroer, me lavia na komu i ghobina gorge, va tana namata Medeba me va sara Dibon. ");
INSERT INTO nlg_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Me lavi udolui na lei komu dira na Amorites te vunaghi ga Sihon me Vunagh i Heshbon, me tona haliu me sara tana vovoka ni Ammon. ");
INSERT INTO nlg_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Mi Gilead tana bubulo ni Geshur mi Maacah, mana ghotu Hermon mi Bashan udolu me va sara i Salecah. ");
INSERT INTO nlg_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Mana bubulo ni Bashan te vunaghi ga Og na Vunaghi me vunaghi i Ashtaroth mi Edrei. Gaia na sosokodira naRahait, a Moses te te veitotoghoni kolura me ghuru kehara tua. ");
INSERT INTO nlg_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Hau va, mana lei dale Israel tara mua tangomana gekar ghuru kehara na vure ni Geshur mi Maacah, mara tona haliu so na kabu koluadira me sara mai tana bongi taeni. ");
INSERT INTO nlg_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Moses te mua tunuvara nia siki pari na kemana Levi. Tughua keri, te vaha Lord te bahura nia tuna, natunuvadira ke mai tua tana kere Sukaghi ta vuvungana na bela ni Sukagi vania Lord God ni Israel. ");
INSERT INTO nlg_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Moses te vahera na lei bona raini vanira na lei binaboli tana kemana Reuben. ");
INSERT INTO nlg_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Didira na bubulo te vuni Aroer, tana kabaana na beti Arnon Gorge, (mana komu sule ighobuna Gorge) me va sara tana nanata Medeba. ");
INSERT INTO nlg_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","Me lavighi ghua Heshbon mana le komu sule tana nanata – Dibon, Bamoth-Baal, Beth-baal-meon. ");
INSERT INTO nlg_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","Jahaz, Kedemoth, Mephath ");
INSERT INTO nlg_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","Kiriathaim, Sibmah, Zereth-shahar tana ghotu mana nanata ipari. ");
INSERT INTO nlg_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","Beth-peor, tana sughi i Pisgah, mi Beth-Jeshimoth. ");
INSERT INTO nlg_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","Nina pari Reuben ke lavighi ghua na lei komu sule tana nanata mana kinakabuna udolu Sihon. Sihon didira na vunaghihali na Amorite te vunaghi i Hesbon, ma Moses te labu matea kolura nia na lei vunaghi ni Media-Evi, Rekem, Zur, Hur ma Reba-na lei dale vunaghi tara kabu tana bubulo keri mara nia tona kolu Sihon tana veitotoghi. ");
INSERT INTO nlg_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Na lei dale Israel tara matea ghua Balaam dalena Beor. Balaam te logo tidalo me sukaghi vaho gara rughuhoru ni veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Na beti Jordan te vaughilalaa i boko na koekobe vanira na emana Reuben. Mana lei komu sule mana lei komu pile ilokana na bubulo eni tara vahera gekara loghoi na lei binaboli tana kemana Reuben. ");
INSERT INTO nlg_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Moses te tuvalighi na lei bona rain vanira na lei inaboli tana kemana Gad. ");
INSERT INTO nlg_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Na tunuvadira te vuni Iazer, maia na lei komusule ni Gilead, maia na pilena na pari ni Ammon, me va sara tana komusule ni Aroer i paleva bokona vassoo Rabbah. ");
INSERT INTO nlg_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","Me ghoi vuni Heshbon me va sara Ramath-Mizpeh mi Betonim, e ghoi vuni Mahanaim me va sara Lo-debar. ");
INSERT INTO nlg_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Mi tana boboko, Beth-haram, Beth-nimrah, Succoth. Zaphon, kolua nia na kinakabuna udolu Sihon na vanaghihali ni Heshbon. Na beti tina Jordan na ririti boko, me tona longa me va sara tana kolo i Galilee. ");
INSERT INTO nlg_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Na lei komu sle mana lei kou tan bona eni tara vahera na lei binaboli gekara loghoi tana kemana Gad. ");
INSERT INTO nlg_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Moses te tuvalighi na lei bona raini vanira na levuna na Kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Didira na bubulo te vuivuniMahamaim me va sara i Bashan, maia na diki Kinakabuna Og na vunaghihali, maia e ono hangavulu na kumusule ni Jain i Bashan. ");
INSERT INTO nlg_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Me lavia ghua na levuna Gilead, maia na komu sule Ashtaroth mi Edrei, nina komu ni vunaghi Og, na vunaghihali. Na lei bona udolu raini tara vahera na lei dalena Makir, gaia na dalena Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Gaighi raini na lei bona Moses te tuvalira nia tana bona te ghanaa mua tana nanata Moab, me halavu tana eti tina. Jordan pala uluna Jericho. ");
INSERT INTO nlg_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Hau va, Moses te musa vaherana unuva tana pari nakemana Levi, na pukuna a Lordna God ni Israel, agaia tua didira na logho te vaghaa te bahura tua. ");
INSERT INTO nlg_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Na lei kema ni Israel tara logho tunuva i Canaan tara tuvalira Eleazar na priest, Joshua, maia na lei kamangho tana lei kema. ");
INSERT INTO nlg_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Gaira ara hiua mana leva na kema raini, ara sopa holai na tunuvadira taonia na loka, taonia na hava te bosaa Lord vania Moses. ");
INSERT INTO nlg_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","A Moses te diki vahera tua gekara loghoa na pari paleva uluna na beti i Jordan, e rua mana levuna na kema. ");
INSERT INTO nlg_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Tana kemana Joseph te uputu ga erua na kema keakeha, a Manasseh ma Ephraim. Ma gaira na Levite tara mu tuvalira nia tua ski pari, na komu vamua tara ghanara iga maia na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Mana tuvaliana na pari tara goni taonia na hava Lord te bosaa vania tua Moses. ");
INSERT INTO nlg_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","mana ovu ni tinoni tana kemana Judah, te idevira Caleb dalena Jephunneh na mane ni Kenizzite, tara ma tatana Joshua i Gilgal. Ma Caleb te bosa vania Joshua, “Ko ghanaghanaa na hava te bosaa Lord vania Moses, nina mane God, ni mane God, nia ighoe mi nau tana bona ta ghanaghuta mua i Kadesh-barnea. ");
INSERT INTO nlg_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Tana bona vaghana keri, inau e vati hangavulu na niulugu, tana bona Moses nina tinoni lutu Lord, te vetenou te vuni Kadesh-barnea gku va righia na pari i Canaan. Mi nau tu oli mai, mu nia hevei na bosatughu te uto te pukulaghi mai tana tobagu. ");
INSERT INTO nlg_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Hau va mana lei hoghogu tara niu tona kolu tara nera na vure mara mataghu me nei na liodira gekara mua haghevia na komu Biubahui. Hau va mi nau tu taoni haliua a Lord nigua na God. ");
INSERT INTO nlg_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Mi tana bongi keri a Moses te baubahu vaniu te vaghaa eni, “The na pari i Canaan tu va tagiha turia ke tunauvamu maia rana kukuamu ke va me va, na pukuna to taonia a Lord nigua Go nia na tobamu udulou. ");
INSERT INTO nlg_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","Mi taeni ko righia, a Lord te righitaoniu geu vola sono, te bosaa ilokana e vati hangavulu lima na niulu te vuivuni te onia ga Moses na baubahu eni, tana bona aroha. Mi taeni e alu hangavlu lima tuana niulugha. ");
INSERT INTO nlg_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Mi nau tu laga sono itaeni vaghau tana bongi keri a Moses tevetenau geku tona. Ku tangomana sono geku rughuhoru gatu taa veitotoghoni, maia ku saku tua ton mana mai. ");
INSERT INTO nlg_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Ma keri te vaghaa, inau tu nongigho geko vaheu na ghotu a Lord te bahuu nia. Mo ko ghanaghana olia ighai tai tona mai topora ga na Anakim tara ghanara iga tara subo va, ilokani na lei komu sule tara pilui nia na vatu. Ma Lord ke kabu itagua me ke hangau, muku ghuru kehara tana bona keri, te vaghaa Lord te bosaa.” ");
INSERT INTO nlg_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Ma Joshua te vautoa Caleb dalena Japhunneh me vahea Hebron geke loghoa. ");
INSERT INTO nlg_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Hebron a didira sono rana lei kukuana mana vina vahuhuna Caleb dalena Japhunneh na Kenizzite na pukuna te taonia a Lord God ni Israel nia na tobanan udolu. ");
INSERT INTO nlg_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Hebron tara diki holoa nia Kiriath-arba. Ara holo taonia nia Arba, na man sule mana laga ni Anakim. Mi kakeri ma komu te beto tana veitotoghoni. ");
INSERT INTO nlg_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Na pari tara vahera na lei binaboli tana kemana Judah, te tn sapa me va sara tana riritina Edom, kolua nia na bona aroha Zin te ghanaa tana sosokona ilau. ");
INSERT INTO nlg_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Na ririti ilau te vuni tana logu tana Tahi Mate. ");
INSERT INTO nlg_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","Me tona sapa ilauna, Scorpion Pass me va tana bona aroha i Zin me tona haliu va Kadesh-banea me va sara Hezron. Vaho ge tona dato Addar, ikakeri te ririu va i karva. ");
INSERT INTO nlg_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","Te vuni Kakeri, me tona vulea Azmon, koekobe e va sara tana daidari i Egypt me va sara tana tahi. Aeni gaia didira na ririti ilau. ");
INSERT INTO nlg_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Mana ririti iulu te vuni tanan Tahi Mate me va sara tana matana na tina Jordan. Mana ririti i longa te vuivuni tana logu tana tina Jordan te tave va tana Tahi Mate. ");
INSERT INTO nlg_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","Me tona halavu va i Beth-hoglah, vaho ge tona longa i lilighina Beth-arabah me va sara tana vatu Bohan na dalena Reuben. ");
INSERT INTO nlg_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Vaho ge vuni tanan ihu keri me liu tanan boboko. Achor me va sara Debir, me ririu longa va Gilgal, te liuvia va na sughi Adummim pala uluna na boboko. Me ghoi vuni kakeri me tona va tanan vulavula ni beti En-shemesh me tona haliu va i En-rogel. ");
INSERT INTO nlg_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Mana koekobe te ghoi liu va tana na boboko lilighidira na lei dalena Hinnom, me tona sopa tana sughi tara ghanara ga na Jebusite, te ghanaa ga Jerusalem. Vaho ge tona dato i pateva boko me va sara tanan kouna na ghotu, mana boko Hinnom i pari, me tona haliuhoru i matanga me va soko tana bobko ni Rephaim. ");
INSERT INTO nlg_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Mete ghoi vun kakeri, na koekobe te vuni tana kouna na ghotu me va sava tana pukuna na beti Nephtoah, mi kakeri me tona va tona va tanan lei komu tana ghotu Ephron. Vaho ge ririu me tonavia va Baalah (gaia keri, Kiriath-Jiarim). ");
INSERT INTO nlg_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Na koekobe te liu kilili bokona Baalah va tana ghotu Seir, me liu lilighina na komu ni kesalon me tona haliu longa va tana horu va Beth-She-Mes me va sara i Timnah. ");
INSERT INTO nlg_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Mana kobe te ghoi liu lighi-lighi tanan ghotu longana Ekron, mi kakeri te ririu va Shikkeron maa hotu Baala. Me liu lilighina Jabneel me va soko tana Tahi ni Mediterranean. ");
INSERT INTO nlg_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Na koekobe i boko te soke tana saravahale tan Thi ni Mediterranean Gaighi na lei kobedira na lei binaboli tana kemana Judah. ");
INSERT INTO nlg_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Ma Lord te uhulia Joshua gee vahea Caleb dalena Jephunneh na pilena na tunuvama Judah. Mara vahea Caleb na komu sule Arba, (gaia keri Hebron), tara holo taona nia na kukuna Anak. ");
INSERT INTO nlg_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Ma Caleb te ghur kehara na Anak, mana Shsha, mana Ahiman, mana Talmai, rana lei viavahuhuna Anak. ");
INSERT INTO nlg_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Vaho ge veitotoghoni kolura na vure taa ghanara i Debir (tara diki vatua nia Kiriath-Sepher). ");
INSERT INTO nlg_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Ma Caleb te ghaghua, “Inau ku vahea Acsah na dalegu geke tauna ahei ke veitotoghoni me ke lavia na Komu Kiriath-Sepher.” ");
INSERT INTO nlg_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Ma Othneil na dalena Kenaz, na hoghona Caleb gaia keri te lgavulea, ma Acsah te tauna Othneil. ");
INSERT INTO nlg_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Mi tana bona Acsah te tauna tua Othniel, gaia te bosa ngangatavania geke nongia na pile bona ni pari tatamana. Mi tana bona Ascah te spgha hurta nina na dkey Caleb te huatia, “Na havato liona gku gonia vangho?” ");
INSERT INTO nlg_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Ma gaia te bosa vania, “Ko vaheu na vauto. Ighoe to doloviu mo vaheu tua na pari tana Negev; mi nau nongi ngangatagho geko vaheu ghua na vulavula ni beti”. Ma Caleb tete vahea na ulavula imatanga mi pari. ");
INSERT INTO nlg_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Gaigh raini na pari tara vahera na lei binaboli tana Keruana Judah. ");
INSERT INTO nlg_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Na lei komudira na lei binaboli tana kemana Judah tara ghanai pala launa na koekobe ni Edom, Kabzeel, Eder, mi Jagur. ");
INSERT INTO nlg_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","Kinah, Dimonah, mi Adadah. ");
INSERT INTO nlg_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","Kedesh, Hazor, mi Ithnan ");
INSERT INTO nlg_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","Ziph, Telem, mi Bealoth ");
INSERT INTO nlg_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","Haz-hadattah, Kerioth-Hezron (gaia keri Hazor). ");
INSERT INTO nlg_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","Amam, Shema, mi Moladah ");
INSERT INTO nlg_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","Hazar-gaddah, Heshmon, mi Beth-pelet ");
INSERT INTO nlg_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","Hazar-shual, Beersheba, mi Biziothiah ");
INSERT INTO nlg_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","Baalah, Iim, mi Ezem. ");
INSERT INTO nlg_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","Eltolad, kesil, mi Hormah. ");
INSERT INTO nlg_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","Ziklag, Madmannah mi sansannah. ");
INSERT INTO nlg_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","Lebaoth, Silhim, Ain, mi Rimmon. Gaighi udolu, ara rua hangavulu hiua na komu sule kolui nia na lei komu pile tara kililighi. ");
INSERT INTO nlg_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Na lei komu sule tara ghanai tana nanata tana pukuni a le ghotu tara vahea ghua Judah: Eshtaol, Zorah, mi Ashnah. ");
INSERT INTO nlg_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","Zanoah, En-gannim, Tappuah, mi Enam. ");
INSERT INTO nlg_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","Jarmuth, Adullam, Socoth, mi Ashnah. ");
INSERT INTO nlg_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","Shaaraim, Adithaim, Gederah, mi Gederothaim. Gaighi udolu, ara hangavulu vati na komu sule maia na lei komu pile tara kililighi. ");
INSERT INTO nlg_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Kolui nia ghua Zeman, Hadashah, mi Migdal-gad, ");
INSERT INTO nlg_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","Dilean, Mizpeh, mi Joktheel. ");
INSERT INTO nlg_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","Lachish, Bozkath, mi Eglon. ");
INSERT INTO nlg_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","Cabbon, Lahmam, mi Kitlish. ");
INSERT INTO nlg_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","Gederoth, Bet-dagon, Namah, mi Makkedah, ara hangavuu ono na komu sule maia na lei komu pile i lilighini. ");
INSERT INTO nlg_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","I lilighini raini Libnah, Ether, mi Ashan. ");
INSERT INTO nlg_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","Iphtah, Ashnah, mi Nezib. ");
INSERT INTO nlg_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","Keilah, Aczib, Mareshah-ara hiua na komu sule maia na lei komu pile kililighi. ");
INSERT INTO nlg_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Ma didira na bubulo na kemana Judah te haghe maia ga na lei komu sule mana komu pile ni Ekron. ");
INSERT INTO nlg_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","Na vovoka te vuni Ekron me ona horu me hola haghei na lei komu sule liligina Ashdod maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Me lavi haghea ghua Ashdod kolui nia na lei komu sule mana komu pile, maia Gaza kolui nia na lei komu sule maa komu pile iga, me va sara tana daidari ni Egypt, me taonia na saravahale tana Mediteranean. ");
INSERT INTO nlg_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Judah te lavighi ghua na lei kmu sule raini tana ghotu: Shamir, Jattir, mi Socoh. ");
INSERT INTO nlg_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","Dannah, Kiriath-sannah (gaia keri Debir). ");
INSERT INTO nlg_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","Anab, Eshtemoh, mi Anim. ");
INSERT INTO nlg_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","Goshen, Holon, mi Giloh, ara hangavulu sakai na komu sule kolui nia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Me lavi haghei ghua na komu sule ni Arab, Dumah, mi Eshan. ");
INSERT INTO nlg_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","Janim, Beth-tapuah, mi Aphekah. ");
INSERT INTO nlg_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","Humtah, Kiriath-arba, (gaia keri Hebron), mi Zior, ara hiua na komu sule kolui nia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Mi lilighini raini Maon, Carmel, Ziph, mi Juttah. ");
INSERT INTO nlg_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","Jezreal, Jokdeam, Zanoah. ");
INSERT INTO nlg_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","Kain, Gibeah, mi Timnah, ara hangavulu na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Me mai kolui ghua Halhul, Beth-Zur, mi Gedor. ");
INSERT INTO nlg_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","Maarath, Beth-anoth, mi Eltekon, (ara ono na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Iga ghua Kiriath-Baal (gaia keri Kiriath-jearim mi Rabbah, e rua na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","Mi tana bona aroha na lei komu sule ni Beth-arabah, Middin, Secacah. ");
INSERT INTO nlg_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","Nibshan, na komu sule ni Tahi, mi EN-gedi ara ono na komu sule maia na le komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Hau va, na kemana Judah tara mua tangomana nekara ghuru kehera na Jebusite tara diki ghahara tua i Jerusalem, mara kabu kolura so na lei dalena Judah me viti mai tana dani taeni. ");
INSERT INTO nlg_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Na tunuvadira rana dalena Joseph te vuni tana Tina Jordan i lilighina Jericho, me va sara ta vuravura ni beti ni Jericho, pala ulu, me tona vatana bona aroha, me tona va ta ghotu ni Bethel. ");
INSERT INTO nlg_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Me ghoi vuni Bethel me tona va i Luz, me tona i Atoaroth tana bona dira na Arki. ");
INSERT INTO nlg_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Vaho ge sughi horu va i boko tana bonadira na Japhlet, me va sara tanan nanata ni Beth horon, me tona va Gezer me va sara tana Tahi ni Mediteranean. ");
INSERT INTO nlg_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Na binaboli tana dalena Joseph, Manasseh ma Ephraim tara holai na tunuvadia. ");
INSERT INTO nlg_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Na lei bona tara vahera na lei binaboli tana kemana Ephraim gekara loghoi te vaghai raini. Na vovoka i ulu te vuni Ataroth-Adda me tona dato i Beth-horon i matanga. ");
INSERT INTO nlg_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","Vaho ge tona va tana tahi ni Mediteranean, vaho ge tona galagha taonia na saravahale va i Micmethath, me ririu ghalagha i liligina Taanath-shiloh pala uluna Janoah. ");
INSERT INTO nlg_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","e vuni Janoah me ririu sapa ghalagha i Ataroth mi Naarah, me sara va i Jericho me va soko ta Tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Te vuni Tappuah na vovoka te tona horu, me taonia na kanah Ravine va tana Tahi ni Mediteranean. Gaighi raini na pari tara vahera na lei binaboli tann kemana Ephraim. ");
INSERT INTO nlg_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Ephraim tara vahea ghua na balu komu sule mana lei komu pile tana pilena na Kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Mara mua tarigomana na ghuru kehadira navure ni Canaan tara ghanara tua Gezer, ma gaira tara kabu koluraso na vure ni Ephraim mara hughutira gekara lutu lee me sara mai tana dani taeni. ");
INSERT INTO nlg_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Na pari tara goi vahea na levuna na Kemana Manasseh na diki dalena Joseph Gilead mi Bashan tana paleva uluna Jordan, tara diki tuvalira nia tua nina binaboli Makir, na pukuna gaia na malagha ni veitotoghoni. (Manaseh te dki vahua makir na tamana Gilead.) ");
INSERT INTO nlg_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Na pari te pala i bokona Jordn tara tuvalira nia na binaboli ara mua tuvalira mua tanan kemana Manasseh: Abiezer, Helek, Shechem, Hepher, mi Shemida. ");
INSERT INTO nlg_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Hau va, Zelophead na dalenattepher, na dalena Gilead, na dalena Makir, na dalena Manasseh te loghora vamua ara lima na vaivine me taho na mane. Na ahadira Mahlah, Noah, Hioglah Milcah, ma Tirzah. ");
INSERT INTO nlg_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Gaira na lei vaivine raini tara mai tatana Eleazar na priest, ma Joshua dlena Nun, maia na lei kamanagho ni Israel mara ghaghua, “A Lord te bosavania Moses geke vaheghau na tunuvamami kolura nia na lei mane tana kemamami.” Ma Joshua te vahera na lologho gekara lologho koukolu ta dira na lei hoghodira na lei tamadira mana tinadira, te vaghaa Lord te bosaa. ");
INSERT INTO nlg_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Mana lei dalena mana vinavahulunia Manasseh tara loghoi ara hangavulu na buto ni pari kolui nia na pari Gilead mi Bashan me tona halavu tana Tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","Na pukuna na lei vaivine tana vinavahuhuna Manasseh tar lologho koukolu tadira na lei mane. (Na pari Gilead tara vahera tua na lei mane tana vinavahuhuna Manaseh). ");
INSERT INTO nlg_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Na vovokana na pari tara loghoa na kemana Manasseh te vuivuni tana riritina Asher me vasava Miemethatha, gaia keri paleva uluna Sechem. Me tona sapa te vuni Micmethath me va sara tadira na vure tarahanara tana beti Tappuah. ");
INSERT INTO nlg_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Mana pari e kililia Tappuah a nina Manasseh, hau va, na komu sule Tappuah te ghanaa tana riritina nina pari Manasseh, a diira tana kemana Ephraim. ");
INSERT INTO nlg_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Na riritina nina pari Manasseh te vuivuni tanan beti Tappuah me tona sapa lilighina Kanah Ravine me va sara tana Tahi ni Mediteranean. (Mana balu komu sule ilokann na tunuvana Manasseh a didira na kemana Ephraim). ");
INSERT INTO nlg_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Na pari pala longananna taetave a nina Ephraim, mana pari i launa na taetave a nina Manasseh me va sara tana Tahi Mediteranean, me talukolu taa ririti boko a nina Manasseh. Pala bokona sono Manasseh na kobena Asher, mi paleva uluna na kobona Issachar. ");
INSERT INTO nlg_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Na lei komu sule i lokani na kobedira Issachar ma Asher tara vahea Manassehi Beth-Sham, Ibleam, Dor (gaia Keri Naphoth-dor) Endor, Taanach mi Megiddo, kolui nia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Hau va mana lei vaivarina Manasseh tara mua tangomana na ghuru keha-adira na vure ni Canaan mara tona haliu sono na kabu iga. ");
INSERT INTO nlg_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Mi murina mai vaho tara totolo subo mara laga rana Israel, ara hughutira gekara tinoni lultl lee, mara mua ghuru kehara. ");
INSERT INTO nlg_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Mana lei vaivari tana kemana Josheph tara mai ta Joshua mara huatia, “Ivei tea geo vaheghai vamua sakai na buto ni pari, na pukuna Lord te vautoghai me totolo subo na tinoni?” ");
INSERT INTO nlg_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Ma Joshua te bosatughu vanira, “Ke mua manamiu na ghotu Ephraim tau ghanaghau ga ke, kau dato tana leao ta ghanara ga na Perizzites mana mumutabu makau mangatia heghemiu.” ");
INSERT INTO nlg_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Ma gaira tara ghaghua. Na ghotu te mua manamami, mana vure ni Canaan tara ghahara tana nanata Beth-shan maia tana nanata ni Jezreel tara loghoi na idi vatei haehaghe tara gonighi nia na halo, mara laga ngangata. ");
INSERT INTO nlg_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Ma Joshua te bosavanira na Kemana Epraim ma Manasseh na vinavahuhuna Joseph, “Na pukuna tau subo mau laga, igeva kau lavighi ghua na balu pari. ");
INSERT INTO nlg_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Na leao i matanga a nimiu ghua. Kau umania makau tokaa engiha na pari tau liona makau kabu ga. Mi nau tu ghilala utoa, kau tangomana so na ghuru adira na Canan. Sakai amua tara loghoi na lei vatei haehaghe tara gonighi na na halo mara laga.” ");
INSERT INTO nlg_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Mana pari udolu i savana didira na righitaoni rana dale Israel, ma gaira tara talu datoa na Vaevale Tapole i Shiloh. ");
INSERT INTO nlg_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Hau va aravitu na kema tara mua tuvalira nia mua na pari gekara loghoa. ");
INSERT INTO nlg_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Ma Joshu huatira, “Ivei vaho ke vaghaa na darona kau pitu, vaho gekau holai makau loghoi na pari tara ghana, a didira na Lord God na lei kukuamiu te vaheghau?” ");
INSERT INTO nlg_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Kau vilira ara tolu na mane ta sakai na kema, muku vetenara va tana lei bona ta mua lagavuli mua. Makara nighi oli mai tagua na gegereni a lei didira na kobe, taonia na lei bona kara loghoi. ");
INSERT INTO nlg_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Ma gaira kara kobea na pari tana vitu na bubulo, kolua nia nina bublo Judah ke ghanaa sonoilau, ma nina bubulo Joseph ilonga. ");
INSERT INTO nlg_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Vaho inau ku talua na vaughilala tabu tana matana Lord, geku ghilalaa ivei na kobe ia ke vania sakai na kema. ");
INSERT INTO nlg_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Hau va, gaira na Levite kara mua loghoa siki pari. Didira na lutu tana malei priest nina Lord gaia keri didira na lologho. Mana Kemadira Gad ma Reuben, maia na levunana Kemana Manasseh kara mua ghoi lavia ghua siki tunuvan pari, na pukuna na tunuadira tua i pala uluna na Tina Jordan, te vahera tua Moses nina tinoni lutu Lord.” ");
INSERT INTO nlg_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Mi tana bona tara tapatughuru gekara tona rahei kar va kobea na pai, Joshua te bosa vanira, “Kau tna makau rghia na pari. Vaho gekau oli mai tagua kolui nia nimiu na gegere tutughuni, vaho geku tuvalia na pai vanira na lei kema nia na talu vaugilala tana matana Lord iani Shiloh. ");
INSERT INTO nlg_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Mana lei mane tara gonitaonia na hava tara vetenara nia, mara gonia na gegere taonia na pari tana vtu na bubulo, mara gerei ghua na lei komu sule tana lei sopa bublo. Vaho gara oli mai ta Joshua i Shiloh. ");
INSERT INTO nlg_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Mi gai i Shiloh, Joshua te talu vaugilala tana matana Lord geke ghilala ivei na bubulo vaghana ke Inghoa sakai na kema. ");
INSERT INTO nlg_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Na vuivuni ni tunuva tara vahera va a lei binaboli tana kemana Benjamin. Gaia keri te kabu ighobudira na pari tara diki vahera tua na kemadira Judah ma Joseph. ");
INSERT INTO nlg_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Na vovoka i longa te vuivuni tana Tina Jordan, me tona haliu longa va tana lighilighi ni ghotu ni Jericho, vaho ge tona horu va tana leao ni Beth-aven. ");
INSERT INTO nlg_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","Me tughuru kakeri na vovoka te tona sapa va Luz (gaia keri Bethel) me sghi horu va Ataroth-addar me va sara tana ghotu pala launa Beth-horon i pari. ");
INSERT INTO nlg_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","Na vovoka te ghoi ona sapa taonia pleva bokona na ghotu te naghovia va Beth-horon, me va siki tana komu ni Kiriath-Baal (gaia keri Kiriath-jearim), sakai na komu sule didira n kemana Judah. Gaia eni na vovoka i bokona. ");
INSERT INTO nlg_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Mana vovoka ilau te vuivuni tana sosokona Kiriath-jeakim. Te vuivuni kakeri ine tona horu va i boko me va sara tana beti i Nephtaoh. ");
INSERT INTO nlg_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","Me ghoi sughi va tana pukuna na ghotu lilighina na boboko didira na dalena Hinnom, tana sosokana ilonga na boboko ni Rehaim. Me uni kakeri e sughi tana boboko ni Rephaim. Me vni kakeri me sughi tana boboko ni Hinnom, me tona halavu sopa tana sughi tara ghanara ga na Jebusite me sugi horu haliu va i En-rogel. ");
INSERT INTO nlg_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Me vuni En-rogel na vovoka te tona ghalaghalong va i En-shemesh me va sara Geliloth. (gaia kei t tona tana boboko Adummin). Vaho ge tona horu va Bohan (Boha na dalena Reuben). ");
INSERT INTO nlg_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Mete vuni kaker te liu lilighina na boboko te righi sughia va na boboko Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Na vovoka te sughi horu me liu lilighana na boboko Beth-hoglah me va soko pala longana na logu tana Tahi Mate pala launa na Tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Mana Tina Jordan na vovoka uluna. Gaighi raini didira na lologho na lei binaboli tana kemana Benjamin. ");
INSERT INTO nlg_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Gaighi rani na lei komu sule tara vahera na lei binaboli tana kemana Benjamin. Jericho, Beth-hoglah, Emek-keziz. ");
INSERT INTO nlg_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","Beth-arabah, Zemaraim, Bethel. ");
INSERT INTO nlg_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","Avvim, Parah, Ophrah ");
INSERT INTO nlg_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","Kephar-ammoni, Ophni, mi Geba ara hangavulu rua na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Gibeon, Ramah, Beeroth, ");
INSERT INTO nlg_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","Mizpeh, Kephirah, Mozah, ");
INSERT INTO nlg_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","Rekem, Irpeel, Taralah. ");
INSERT INTO nlg_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","Zela, Haeleph, Jebus (gaia keri Jerusalem. Gibeah, mi Kiriath-jearim. Ara hangavulu vati na komu sule maia na lei komu pile. Gaighi raini didira na lologho na lei binaboli tana kemana Benjamin. ");
INSERT INTO nlg_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Ruani na tunuva tana pari tara vahera va na lei binaboli tana kemana Simeon. Didira na lologho ilokona didira na lologho na le dalena Judah. ");
INSERT INTO nlg_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Gaira tara loghoi Beersheba, Sheba, mi Moladah. ");
INSERT INTO nlg_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","Hazar, Shual, Balah, mi Ezem. ");
INSERT INTO nlg_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","Eltolad, Bethul, mi Hormah. ");
INSERT INTO nlg_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","Ziklag, Beth-marcaboh, mi Haz-susah. ");
INSERT INTO nlg_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","Beth-lebaoth mi Sharuheni ara hangavulu tolu na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Ain, Rimmon, Ether, mi Ashan ara vati na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","Mana lei komu pile me tona sapa me va sara Balath-Beer (ta ghilalaa ghua Ramh ni Negev). ");
INSERT INTO nlg_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Gaighi raini didira na lologhona lei binaboli tana kemana Simeon. Didira na ologho te tara midi kehaa tana pari tar diki vahea tua Judah, na pukuna te sule vanira vaho tua. Mi kakeri tea, na kemana Simeon tara lavia didira na lologho iloana nina na bubulo Judah. ");
INSERT INTO nlg_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Toluni na tunuva tana pari tara vahera na lei binaboli tana kemana Zebulun. Mana riritina nina lologho Zebulun te vuni i Sarid. ");
INSERT INTO nlg_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Te vuivuni kakeri m tona horu va i Maralah, me tona haliu va i Dabbasheth, me tona haliu sono me va sara tana daidari pala uluna Jokneam. ");
INSERT INTO nlg_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Mete ghoi vuni sono i Sarid me tona ghalagha me va ara tana riritina Kisloh-tabor, mete ghoi vuni kari me va sara Daberath, me liu lilighina i Japhia. ");
INSERT INTO nlg_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Me tona haliu ghalagha so me va sara Gath-hepher, Eth-kazn, me Rimmo, vaho ge ririu va i Neah. ");
INSERT INTO nlg_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Mana ririti longana te liu lilighina Hannathon me va soko tana boboko i Iphtah-el. ");
INSERT INTO nlg_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Mana lei komu sule tana bona eni ke, i Kattah, Nahalal, Shimron, Idala mi Bethlehem, ara hangavulu rua komu sule mana lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Gaighi raini didira na lologho na lei binaboli tana kemana Zebulun. ");
INSERT INTO nlg_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Vatini na tunuva tana pari tara vahera na lei binaboli tana emana Issachar. ");
INSERT INTO nlg_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Na lei riritina maia na lei komu sule te vaghai raini Jezreel, Kesulloth, mi Shunem, ");
INSERT INTO nlg_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","Hapharaim, Shion mi Anaharath, ");
INSERT INTO nlg_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","Rabbith, Kishion, mi Ebez. ");
INSERT INTO nlg_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","Remeth, En-gannim, En-hadah, mi Beth-pezzez ");
INSERT INTO nlg_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Na ririti te va hibetia i Tabor, Shahazumah, mi Beth-Shemesh me va soko tana tina Jordan, ara hangavulu ono na komu sule mana lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Gaighi raini didira na lologho na lei binaboli tana kemana Isachar. ");
INSERT INTO nlg_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Limani n tunuva tanapari tara vahera na lei binaboli tana kemana Asher. ");
INSERT INTO nlg_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Na riritina maa nalei komu sule raini: Helkath, Hali, Beten, mi Acshaph. ");
INSERT INTO nlg_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","Allammelech Amad, mi Mishal. Na ririti i boko t vuni Carme me va sara Shihorlibath. ");
INSERT INTO nlg_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","Vaho ge ririu ghalagha va i Beth-dagon, me tona haliu me va sara i Zebulun tana boboko i Iphatah-el, me ghoi tona longa va i Beth-emek mi Neiel. Me tona haliu longa s me va sara Cabul. ");
INSERT INTO nlg_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Mi Abdon, Rehob, Hammon, Kanah, me tona va ghua me v sara tana komu sule i Sidon. ");
INSERT INTO nlg_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Mana ririti te ghoi rriu va i Ramma maia a komu sule tara ghanava ga na lei malaghai ara talu ga na le totobo ni veitotohoni na vure ni Tyre. Me tona me va sara tana Tahi ni Mediterranean tana bubulo ni Hosah, mana lei komu sule tara ghanara ilokana na bubulo keri i Mehebel, mi Aezib. ");
INSERT INTO nlg_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","Mi Ummah, Aphek, mi Rehob, ararua hangavulu mesava erua na omu sule mana lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Gaighi raini didira na lologho na lei binaboli tana kemana Asher. ");
INSERT INTO nlg_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Ononi na tumiva tana pari tara vahera na lei binboli tana kemana Naphtali. ");
INSERT INTO nlg_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","a rirti te vuivuni Heleph, ta pukuna na ghai tara vatua nia na Oak, Zaanannim, me tona vavala va i Adami-nekeb mi Jabneel me va sara i Lakkum, me va soko tana Tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Na ririti i boko te liu lilighina i Aznoth-tabor me va sara Hukkok, me va tibelia ni na ririti Zebulun ilau ma inaririti Asher i boko, man Tina Jordan iulu. ");
INSERT INTO nlg_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Mana lei komu sule tara ghanara ga na lei malaghai mara talui ga ne lei totobo ni veitotoghoni tana bubuto eni te vaghai raini. Ziddm, Zer, Hammath, Rakkath, mi Kinnereth. ");
INSERT INTO nlg_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","Adamath, Raah, mi Hazor. ");
INSERT INTO nlg_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","Kedesh, Edrei mi En-hazor, ");
INSERT INTO nlg_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","Yiron, Migdalk-el, Horem, Beth-anath, mi Beth-shemesh ara hangavulu hiua na komu sule maia na lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Gaighi raini didira na lologho na lei binaboli tana kemana Naphtali. ");
INSERT INTO nlg_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Vituni na unuva tana pari tara vahera na lei binaboli tana kemana Dan. ");
INSERT INTO nlg_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Na lei komu sule ilokana na tunuvana Dan; Zorah, Eshtaol, Ir–shemesh. ");
INSERT INTO nlg_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","Shaalabin, Aijalon, mi Ithlah. ");
INSERT INTO nlg_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","Elon, Timnah, mi Ithlah. ");
INSERT INTO nlg_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","Eltekeh, Gibbethon, mi Baalath ");
INSERT INTO nlg_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","Jehud, Bene-berak, mi Gath-rimmon. ");
INSERT INTO nlg_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","Me-jarkon, mi Rakkon kolua nia na bubulo ilighina Joppa. ");
INSERT INTO nlg_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Hau va mana kemana Dan tara tona vulea na lologho ta didira na pari, ma gaira tara vitotoghoni kolua na komu sule Laish, mara labu mate sokora na vure, mara holaa na komu mara ghanava ga. Mara tughua na ahana na komu, mara vatua nia Fan taonia na ahana kukuadira. ");
INSERT INTO nlg_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Gaighi raini didira na lologho na lei binaboli tan kemana Dan, na le komu sule mna lei komu pile. ");
INSERT INTO nlg_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Mi murina tara tuvali sokoa tua na pari tana ghobudira na lei kema, rana Israel tara vahea na pile pari Joshua geke loghoa. ");
INSERT INTO nlg_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","Tonia na bosana Lord, ke tangomana geke loghoa siki komu sulete liona. Ma gaia te vilia Timnath-Serah tanaghotu Ephraim. Ma gaia te kisu lia me kabu iga. ");
INSERT INTO nlg_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Gaighi raini na lei bubulo ni pari, a Eleazar na riest, Joshua dalena Nun, maa na lei kamanaho tana li kem tara vahera, na lei kema gekara loghoi, nia na talu vaughilala tana matana Lord tana mataulana na Vaevale Tapole Shiloh. Ma gaira tara mai tana sosokona a tuvaliona na pari. ");
INSERT INTO nlg_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Ma Lord te bosa vania Joshua, ");
INSERT INTO nlg_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Taeni ko bosavanira rana dale Israel gekara vilighi na le komuni vatei polo, te vaghaa tu bosaa vania tua Moses. ");
INSERT INTO nlg_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Ma ge ahei ke tovongo matea ahea ke mua ghanaghanaa geke matea ahei ke mua ghanaghanaa gee matea ke, ke sama me ke va polo ta sakai tadira na komu rini. Na pukuna na lei kulana ahe te mate kara kenea gekara matea tughuna kuladira. ");
INSERT INTO nlg_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Mi tana bona ke sama va ta sakai tadira na lei komu raini, gaia ke tughuru tana mataulana na komu me ke bosatatea vanira na lei kamanagho tana komu na hava te goni hahia. Ma gaira kara lavi haghea tana komu, makara vahea na bona ke kabu ga, me ke kabu kolura. ");
INSERT INTO nlg_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Me ke vaghaa na lei kulana aheai te mate kara mai makara lavitughuna kuladira te mate, na lei kamanagho tana komu keri kara bei lubatia vanira, na pukuna te mu ghanaghana geke matea. ");
INSERT INTO nlg_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Mana tinoni tematea ahei ke kabu tana komu keri, me ke tughuru inaghona na vuresubo makara dete tatavahalea. Vaho gaia ke bosatatea te tatavahalea. Vao gaia ke bosatatea te tatavahole, na pukuna te mua ghanaghana geke matea na tinoni keri, me ke tona haliu na kabu tana komu keri koekobe ke mate na Priest kamanagho te detea na tinoni keri. Mi murina ker, vaho geke oli tatavahale tana komuna. ");
INSERT INTO nlg_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Mana lei komu sule tara vilighi na vatei sogha polo t vaghai raini i Kdesh ni Galilee, tana ghotu n Naphtali; Sechem, tna ghotu ni Ephraim; mi Kiriath-Arba (gaia keri Hebron itaeni), tana ghotu ni Judah. ");
INSERT INTO nlg_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Mi paleva iuluna na Tina Jordan lilighina Jericho, nakomu tara vilighi ga na vatei soga polo: Bezer tana bona aroha tana nanata tana kemanaGad, mi Golan i Basan, na pari tana kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Na kmu raini tara vili kehai vanira rana Israel, ma vanira ghua rana singho tara kabu kolu itadira. Ge ahei ke tovngo labu matea ahei ke sogha me ke va polo tana lei komu raii. Mi tana halautu eni eni, gaira kara soga gekara bei matera gea, makara va diki tughuru ghua tana dete inaghona na vuresubo. ");
INSERT INTO nlg_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Ma gaira na lei Kamanagho tanan kemana Levi tara mai kokoe kolura Eleazar na Priest ma Josha daena Nun, maia na lei Kamanagho tana lei Kema ni Israel. ");
INSERT INTO nlg_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Ma gaira tara kokoe kolura I Shiloh I Canaan mara ghagua vanira, “A lord te bosavania Moses geke vaheghai na lei Komy kai ghanaghai ga, mana bona ni pari te buburugha vanira niami na lei buluka maan sheep.” ");
INSERT INTO nlg_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Ma gaira tara vahera na lei komy mana bona ni pari vanira didira na maumanu taonia na bosana Lord vanira na Levi. ");
INSERT INTO nlg_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Rana vaivarina Aron, gaira tara baebasena na vike Kohath ilokanan na kemana Levi, tara vahera ara hangavulu tolu na Komu, ara diki vahera tu na kemadira Judah, ma Simeon, ma Benjamin. ");
INSERT INTO nlg_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Mana balu binaboli tana vike Kohath tara vahera ara hangavulu na komu tana Kobedira Ephraim, ma Dan, mana levuna na Kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Mana vike Gershon tara lavighi ara hangavulu tolu na komy tanan Kemadira Isaachar, ma Asher, ma Naphtali mana levuna na Kemana Manasseh i Bashan. ");
INSERT INTO nlg_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Mana vike Merari tava tara lavighi ara hangavulurua na Komy sule tana Kemandria Reuben, ma Gad, ma Zebulun. ");
INSERT INTO nlg_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Ma rana Israel tara taonia vetnaLord vania Moses, mara vahera na kemana Levi na komu raini ana bona Kara Kutira ga didira na maumanu nia na talu vauhilala tabu. ");
INSERT INTO nlg_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Ma rana Israel tara nighi hevei na lei Komu raini tana Kemandira Judah m Simeon. ");
INSERT INTO nlg_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","vanira na vaivarina Aaron, gaira tara baebase tana vike Kohath ilokana na kemana Levi tana bona tara talu vaughilala tabu me diki Kalera gaira. ");
INSERT INTO nlg_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Ma gaira tara vahera Kiriath-arba (gaia Keri Hebron), tana ghotu ni Judah maia na lei pari Kililia. (Arba tamana Anak). ");
INSERT INTO nlg_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Hau va mana lei bona ni gehe leghai Kililia na Komu, maia na le komy pile tara diki vahea tua Caleb dalena Jephunneh. ");
INSERT INTO nlg_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Ma vaivarina Aaron na priest tara vahera Hebron maia na lei bona ni gehe leghai kililia, (Hebron na komu ke sogha savua ahei ke tovono labu matea aheai). Libnah ghua kolui na lei pari ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","Jattir mi Eshtemoa ");
INSERT INTO nlg_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","Holon mi Debir ");
INSERT INTO nlg_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","Ain, mi Jutlah, mi Bet-Shemesh, ara huia na komu sule tadira erua na kema raini. ");
INSERT INTO nlg_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Mi tana kemana Benjamin, gaira na lei priest tara vahera na lei komu maia na na bona ni gehe legai i Gibeon mi Geba. ");
INSERT INTO nlg_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","Anathoth mi Almon Kolui nia na lei bona ni gehe leghai, (ara vati na komu sule). ");
INSERT INTO nlg_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Gaighi udolu na lei komu ule tara vahera na lei priest, tana vinavahutuina Aaron, ara hangavulu tolu na Komu. ");
INSERT INTO nlg_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Ma gaighi udolu na lei komy mana bona ni gehe leghai tara vahea na vike Koliath tana Kemana Levi. ");
INSERT INTO nlg_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Tana Kemana Ephraim: Sechem (na Komu ni sogha savuana ahei ke torongo labu matea ahei), mi Gezer. ");
INSERT INTO nlg_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","Kibzaim, mi Beth-horon, ara vati na Komu Sule. ");
INSERT INTO nlg_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Tana Kemana Dan tara vahera na lei priest Eltekeh mi Gibbethon, ");
INSERT INTO nlg_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","Aijalon, mi Gath-rimmon, ara vati na komu sule kolui nia na lei bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Mana levuna na Kemana Manasseh, tara nigh hevei na lei komu sule mana bona ni gehe leghai vanira na lei pries te vaghai rain! Taanach mi Gath-rimmon, e rua na komu sule. ");
INSERT INTO nlg_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Ma gaighi udolu na lei Komu Sule kolui nia na lei bona ni gehe legai, ara hangavulu matapono tara vahera na vike Kohath. ");
INSERT INTO nlg_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Mana vaivarina Gershon, sakai ghua na vike tanan Kemana Levi, tara lavighi e rua a komu sule main a lei bona ni gehe leghai tana levuna na Kemana Manasseh: Golan ni Bashan (na komu ni sogha savuana ahei ke torongo labu matea ahei) mi Be-eshterah. ");
INSERT INTO nlg_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","Mi tana Kemana Isaachar gaira tara lavighi Kishion mi Daberath. ");
INSERT INTO nlg_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","Jarmuth mi En-gannim, ara vati na komu sule kolui nia na bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Mi tana kemana Asher, gara taa lavighi Mishal, mi Abdon, ");
INSERT INTO nlg_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","Helkath mi Rehob, ara vati na komu sule kolui ni na lei bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Mi tana kemana Naphtali, gaira tara lavighi Kedesh I Galilee, (na omu ni sogha savuana ahei ke tovngo ni labu mateana ahei) mi Hammoth-dor, mi Kartan, ara tolu na komu sule kolui nia na lei bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Ma gaighi udolu tara vahea na vike Gershon, ara hangavulu tolu na komu sule kolui nia na lei bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Ma gaira udolu tana kemana Levi, n vike Merari na lei komu raini tara vahera tana Kemana Zebulun i Jokneam mi Kartah. ");
INSERT INTO nlg_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","Dimnah mi Nahalal; ara vati na komu sule kolui nia na lei bonani gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","Mi tana kemana Reuben, gaira tara lavighi, Bzer, m Jahaz. ");
INSERT INTO nlg_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","Mi Kedemoth, mi Mephaath, ara vati na komu sule kolui nia na lei bona gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Mi tanan kemana God, gaira tara lavighi Ramoth I Gilead (na komu ni sogha savuanan tana bona ke tovongo ni labu matean ahei) mi Mahanaim, ");
INSERT INTO nlg_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","Mi Heshbon, mi Jazer, ara vati na komu sule kolui nia na lei bona ni gehe leghai. ");
INSERT INTO nlg_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Ma gaighi udolu na le komu sule tara tunuvaa nia na vike Merari, ara hangavulu me sara erua. ");
INSERT INTO nlg_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Ma gaighi udolu na lei komu sule mana lei bona ni gehe leghai tara vahera na kemana Levi, e vati hangavulu me sara e alu. ");
INSERT INTO nlg_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Ma gaighi udolu na lei komu sule raini tara logho udolui na lei bona ni gehe leghai e Kililighi. ");
INSERT INTO nlg_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Ma Lord t vahe udolua Israel na pari te nia baubahu geke vahera na lei bibiudira, ma gaira tava lagavulea mara Kabu ga. ");
INSERT INTO nlg_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Ma Lord te vahera na kabu aheahe mana togholuvu tana lei levu oko, te vaghaa te nia baubahu vanira tua na Kukuadira. Me ke mua tangomana na ghadana levunimate kara tughuru hoghorora, na pukuna a Lord te hangara gekara lagavulera na ghadia na lei levunimate. ");
INSERT INTO nlg_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Mana lei baubahu uto a Lord te vahea Israel temai utuni. ");
INSERT INTO nlg_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Ma Joshua te holokolura na Kemadira Reuben, ma Gad mana levuna na Kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","Ma gaia te bosa vanira, “Ighau tau goni taonia te aghaa Moses nina tinoni lutu Lord te bosaa vanighau, ghau au taoni udolui na totobo tu veteghau nia. ");
INSERT INTO nlg_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Ighau tau mua sanira na balu kema, sakai vamua natalugoni te daro ni bona ngangata me sara mai taeni. Ighau tau rightaoni ngangataa mau tauiania vetena Lord me sara mai tana dani taeni. ");
INSERT INTO nlg_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Mi taeni a Lord nimiu na God te vahera na aheahe na lei hoghomiu tana balu kema, te vaghaa te bahura nia tua. Mi taeni kau oli tana koumiu tana bona ni pari a Moses, nina tinoni nil utu a ord nimiu na God, te vaheaghau paleva uluna na Tina Jordan. ");
INSERT INTO nlg_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Makau bei nia pariparile gean a taoniani na lei vetena, mana vetena Moses te vaheghau tua. Kay dolovia a Lord nimiu na God, makau sakutua tana lei halautuna, makau taonighi nina vetena, makau tabe ngasilia, makau lutu vania nia na tobamiu maa tarungamiu. ");
INSERT INTO nlg_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Ma Joshua te vautora vaho ge nira vetena va tana komudira. ");
INSERT INTO nlg_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Ma Moses te vahea tua I Bashan paelva uluna na Tina Jordan na levuna nae mana Manaseh. Mana levuna na kema Joshua te vahera pala bokona na Tina Jorda. Mi tana bonate nira vetena tona, gaia te vautora ge bosa vanira. ");
INSERT INTO nlg_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","“Kau tuvalira na lei hoghomiu tana komu na lei totobo subo tau holai tadira na ghamiu na levunimate. Kay tuvalira nia na buluka, mana silver mana gold manabras, mana halo ma na tivi.” ");
INSERT INTO nlg_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Ma gaira rana lei mane tana kemana Reuben mana kemana God mana levuna na kemana Manasseh tara sanira rana Israel I Shiloh taa komu I Canaan Ma gaira tara tona va tana komudira I Gilead, ta didira na bubulo taonia nina vetena Lord itatana Moses. ");
INSERT INTO nlg_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Hau va, mi tana tara mua saia mua I Canaan inaghona gekara sogha halavu na Tina Jordan, Reuben, ma Gad, mana levuna na Kemana Manasseh, tara sonia na baravatu sule lilighina na Tina Jordan tana bona tara holoa nia Geliloth. ");
INSERT INTO nlg_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Mi tana bona tara rongovira van a srael, tara sonia na baravatu I Gelilot pala okona na Tina Jordan, ilokana na pari ni Canaan, didira na lologho rana Israel. ");
INSERT INTO nlg_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Gair tara vaukolu I Shiloh mara gonigonidila gekara va veitotoghoni itadira. ");
INSERT INTO nlg_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Mara diki nira vetena a ovu ni mane te idevira Phinehas dalena Eleazar na priest. Gaira ara sogha halavua na tina gekara kokoe kolura nakemadira Reuben ma Gad, mana levuna a Kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Mi lokana na ovu eni, gairaara hangavulu na mane nagho ni Israel, sakai ta sakai na kema itadira ara hangavulu na kema. ");
INSERT INTO nlg_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Mi tana bonatara va sa ra I Gilead, gaira tara bosavanira na kemadira Reuben ma Gad, mana levuna na kemana Manasseh. ");
INSERT INTO nlg_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“Na vuresubo nina Lord tara liona gekara ghilalaa ivei tea ge au peroa God ni Israel. Ivei te ghaghua ge au ririu keha sania Lord mu sonia na baravatu gekau tughuru keha ta nina malei haba? ");
INSERT INTO nlg_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Ivei tea emua manana mua na paluda I Peor? Ighita ta mua va marabou haliua mua me sara mai taa dani taeni, sakaivamua imurina te ale udolua na totoro nina ovu ni tinoni Lord. ");
INSERT INTO nlg_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Hau va mi taeni ighau tau ririu keha mau mua taonia Lord. Ke vaghaa kau hughuhughu kolua ord taeni ke, ma gaia ke rutu vanighita iropo. ");
INSERT INTO nlg_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Me ke vaghaa kau liona na baravatu, na pukuna nimiu na pari te meto ke, makau mai righighai ta nimami na levu tan a levu ni tina, te kabu kolughai ga Lord ta nina Vaevale Tapole mi geva kai tuvalighau s ta nimami na pari. Makau bei hughughu koluana Lord nia na soniana heghemi a sakai na baravatu. A sakai vamua napuku ni baravatu te utuni nina Lord dida na God. ");
INSERT INTO nlg_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Ivei tea e mua toroa God n vure ni Israel tana bona Achan, sakai tadira tana vikena Zerah, te palugha tana bona te gitoi na le totobo tara talu kehai vnia Lord? E mua mate heghena vamua aia na pukuna na palu keri.” ");
INSERT INTO nlg_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Vaho na vure tana Kemadira Reuben, ma Gad, mana levuna na Kemana Manasseh tara bosa tughu vanira na lei mane kamanagho. ");
INSERT INTO nlg_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“A Lord heghena te God! A Lord heghena te God! Ighai tai mua sonia na baravatu gekai hughuhughu koly ta nina malei haba mana maana God. Makai nea te vaghaa keri ke, makau lavi kehai na volamami tana dani eni. Hau va ma Lord tegilalaa, menera ghua na Israel udolu gekara ghilalaa ghua. ");
INSERT INTO nlg_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Ighai tai mua sonia na baravatu vanighai heghemami gekai ririukha sania Lord. Ma kai mua nia kere sukaghi, pana sukaghi ni wheat, pana sukaghi ni mabo. Ma gai sonia na baravatu nia na vatei goniani raini k, ma Lord heghena tua ke toroghai. ");
INSERT INTO nlg_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Ighai tai sonia na baravatu eni na pukuna tai mataghunira na lei kukuamiu, tana lei bona ke mai nagho kara bosa vanira na lei kukuamami, “Na hava na maana ia tau lghoa ge au holohabaa mau nia kikinima a Lord God ni Israel?” ");
INSERT INTO nlg_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","A Lord te talua tan a Tina Jordan geke vovoka ighobudira kulamiu na vure maiakulamami na vure. Mau mua loghoa na maana a nimiu naLord, “Mana lei kukuamiu kara betora na lei kukuamami gekara mua nia kikinima makara holohabaa Lord. ");
INSERT INTO nlg_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","Me vaghaa keri, gai padapada mai sonia na baravatu, na mua vatei kere sukaghi, na vatei ghanaghana oli. ");
INSERT INTO nlg_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Ke nera na lei kukuamami mana kukuamiu ge ighai gua tai loghoa na maana na holoha-ana Lord tana bonana te tabu kolua nia nimami kere sukaghi, na lei sukaghi, mana sukaghi ni mabo. Vaho gekara bei bosa gea, na lei kukuamiu vanira na lei kukuamami, “Au mua loghoa a Lord ighau.” ");
INSERT INTO nlg_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","Makara bosaa te vaghaa keri ke, “Kay righia eni na vaughilalana nina baravatu Lordtara sonia na lei kukumami. Na mua vatei kere sukaghi pana vatei sukaghi; na vatei ghanagana oli tana tamakulani ighita udolu itatana Lord. ");
INSERT INTO nlg_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Ma mua itamami gekai hiughuhughu Tatana Lrd makai ririu keha nia na soniana nimami na baravatu heghemami na vatei kere sukaghi, pana sukaghi ni wheat, pana lei vata ni sukaghi. A sakai vamua na baravatu nia Lord God te tughuru tana naghona na vaevale Tapole ka gonighi ga na lei gehegehe kiri. ");
INSERT INTO nlg_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Mi tana bona Phinehas na priest maia na lei mane habatara rongovia keri tana kemadira Reuben ma Gad mana levuna na kemana Manasseh. Gaira tara vada. ");
INSERT INTO nlg_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Ma Phinehas na priest dalena Eleazar, te bosatughu vanira, “Tana dani eni ighita ta ghilalaa a Lord itatada na pukuna taumua tangotangodika savua Lord te vaghaa tai ghanaghanaa. Hau va, igha tau vavola olia Israel geke mua taghalaghinia Lord.” ");
INSERT INTO nlg_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Ma Phinehas na priestdalena Eleazar, maia ara hangavulu na mane haba tara sanira na kemadira Reuben ma Gad I Gilead mara pulohi I Canaan, mara bosaa vanira rana Israel na ava te kale. ");
INSERT INTO nlg_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Ma gaira udolu rana Israel te nia uto na liodira mara nia vada, mara mua ghoi bosa olia na veitotoghoni koluadira Reuben ma Gad. ");
INSERT INTO nlg_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Mana daledira Reuben ma Gad tara vatua nia na baravatu, “Ghanaghana Oli,” na pukuna tarabosa, na vatei ghanaghana oli ighobudira gaira mi tadira gaira a Lord didira na God ghua gaira. ");
INSERT INTO nlg_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Mana lei niulu te tona padi tua, ma Lord te vahera na vure ni Israel na aheahe tadira na ghadia na levunimate, ma Josha te tonikama ngangata tua. ");
INSERT INTO nlg_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Ma gaia teholokolura na lei kamanagho, mana lei mane uhu-uhuli, mana lei mane ni dete, man lei mane haba ni Israel, ge bosa vaira, “Inau u tonikama tua taeni. ");
INSERT INTO nlg_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Ighau tau righi udolui na totobo a Lord nimiu na God te vei vanighau tana tu kabu kolughau tana volagu. A Lord nimiu na God te veitotoghoni vanighau itadira na ghamiu na levunimate. ");
INSERT INTO nlg_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Mi nau tut tuvalighi vanighau tan a lei pari tadira na lei kema ta mua lagavlei mua, maia na pari ta lagavulei tua. Te vuni tana Tina Jordan me va sara tana Tahi ni Mediteranean I boko. ");
INSERT INTO nlg_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Na pari eni keanimiu, na pukuna a Lord nimiu na God ke ghuru kehara na vure ta ghanara ga itaeni. I ghau kau kabu tughura iga te vaghaa a Lord nimiu na God te bahughau nia. ");
INSERT INTO nlg_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","Keri ke makau laga! Makau righitaoni ngangatai na lei totobo te bosai ta nina buka ni vetena Moses, makaubei lolola kolura gea a siki vata nitotobo. ");
INSERT INTO nlg_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Makau ghilala utoa, kau haidu gea itadira na vure tara ghanara mua tana pari, makau bosai gea na ahani didira na God /tidalo, makau nira paparo gea, makau bei lutu vanira, makau bei tongaghi vanira. ");
INSERT INTO nlg_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Makau tughuru ngasi itatana Lord nimiu na God te vagaa ttau nea tua me sara mai taeni. ");
INSERT INTO nlg_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Na pukuna a Lord te ghuru horura vanighau tua na kema tara sulemara laga, me taho mua ahei ke laga vuleghau. ");
INSERT INTO nlg_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Sakai na tinoni vamua itamiu ke ghurura na togha tanaghamiu na kana, na pukuna a Lord nimui na God te veitotoghoni vnighau te vaghaa te nia baubahu tua. ");
INSERT INTO nlg_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Keri ke, kau righituni utoa, kau dolovia a Lord nimiu na God ");
INSERT INTO nlg_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Makau ririu keha sania gaia, makau bei taulaghi haghe itadira rahei tara ghanara tana lei kema raini tara kabu tana ghobumiu. ");
INSERT INTO nlg_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","Kau ghilalaa uto a Lord nimiu na God ke mua ghuru kehava ta nimiu na pari. Mi gera kau hogho ta didira na vugho, mana vahaghitaili tana gehimiu, mana kaukaru ni moli tana matamiu, makai vamusi keha ghau tana pari uto eni aLord nimiu na God te vaheghau. ");
INSERT INTO nlg_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Ke mua hau muku mate sanighau, me ke susungasi tana tobamiu, na lei babahu nina Lord niiu na God tara mai utuni, me mua padia sakai tadira! ");
INSERT INTO nlg_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Makau gilala utoa, e vaghaa a Lord nimiu na God te vahghau tua na lei totobo uto te nighi baubahu, me ke vagaa ghua ke vaheghau main a lei totobo dika ke vagaa kay diua. Igera ke ghuduri kehaghau tana pari uto eni te vaheghau. ");
INSERT INTO nlg_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Makau diua nina vetena a Lord nimiu na God, makau kikinima makau holohabara na lei god /tidalo keha ke, nina rutu ke vavu tana vuvungamiu me ke mina ghuduri kehaghau tana pari uto eni te vaheghau tua. ");
INSERT INTO nlg_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Ma Joshua te holokolura na vure ni Israel va I Shechem, kolura nia na lei kamanagho, mana lei mane uhu-uhuli, mana lei mane ni dete, marana haba. Ma gaira tara mai udolu tana matana God. ");
INSERT INTO nlg_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Ma Joshua te bosavanira na vure, “Aeni na hava a Lord, na God ni Israel te bosaa: Rana lei kukuamiu, kolua nia ghua Terah, tamadira Abraham ma Nahor. Gira tara kabu mai pala van a Tina Euphrates, ma gaira tara nir kikinima na lei god keha. ");
INSERT INTO nlg_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Hau va, mi nau tu lavikehaa mai kukuamiu Abraham tana komu ke i pala va Euphrates mu hulia va tana komu i Canaan. Mi nau tu vahea rana vaivarina te subo itatana Isaac na dalena. ");
INSERT INTO nlg_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Mi tatana Isaac ina tu vahea Jacob ma Esau, mi nau tu vahea Esau na ghotu Seir, ma Jacob mana lei dalena tara sughi va I Egypt. ");
INSERT INTO nlg_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“Vaho gu nira vetena Moses ma Aaron, mi nau tu vahera main a lei totoro te dika va I vuvungana Egypt; mi murina vaho keri inau tu lavi rughuhoru ghau vagha rana vure tatavahale. ");
INSERT INTO nlg_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Mi tana bona rana kukuamiu tara va sara tana Tahi Sisi, gaira na vure ni Egypt tara ghrura nia na horse mana tarake te ghorai na horse. ");
INSERT INTO nlg_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Mi tana bona tarangangaraha vania Lord, inau tu talua n pui tana ghobumiu maia rana Egypt. Mu nea na tah me pari kuvira me lumira. Mau righighi nia na matamiu na hava tu gonihi. Vao gau kabu tana bona aroha te subo na niulu. ");
INSERT INTO nlg_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Mi tana sosoko, ina tu lavighau v tana komudira na Amori paleva uluna I Jordan. Ma gaira tara veitotoghoni kolughau, hau va mi nau tu vaheghau na lagavule mau lagavulera, mau lavia didira na pari mau loghoa. ");
INSERT INTO nlg_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Vaho Balak dalena Zippor na vunaghi hali ni Moab te tughuru geke veitotoghoni kolua Israel. Ma gaia te holoa va Balam dalena Beor geke varanga ghau. ");
INSERT INTO nlg_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Hau va inau tu mua talu kuligu va itatana. Tughua keri, inau tu nea Balaam me vautoghau, mi nau tu vavolaghau tana limana Balak. ");
INSERT INTO nlg_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Mi tana bona tausogha halavua na Tina Jordan ma va sara I ericho, na lei mane ni Jericho tara veitotoghoni kolughau, kolura ghua rana Amori, ma rana Perizz, ma rana Canaan, ma rana Hitti, ma rana Girgash, ma rana Hivit, ma rana Jebus. Hau va, mi nautu vaheghau na lagavule mau lagavulera. ");
INSERT INTO nlg_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Inau tu vaheghau na pari tau mua lutu matena, mana lei komu sule tau mua kusui, na li komu sule tau ghanaghau ga taeni. Mu vaheghau ghua na leghai ni vine, mana olive mau ghanighi, sakai vamua tau mua subai. ");
INSERT INTO nlg_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Me vaghaa keri ke, kau nia kikinima makau ghanaghana mavaa Lord, makau lutu vania nia na tobamiu udolu. Kau sonikehai tamiu na lei titinoni tava kikinima vanira na lei kukuamiu, tara kabu mua I pala va I Euphrate maa I Egypt, makau lutu vania vasoo Lord. ");
INSERT INTO nlg_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","15","Ma lei tamiu ke mua liona na lutu vaniana Lord ke, mi taeni tua ke vilia ahei ke lutu vania. Pa gaia na god tara lutu vania na lei kukamiu tara ghanara mua pala vai Ephrates? Pa didira na god na Amori tau kabu tua iga taeni ta didira na pari? Ma vaniu inau ma nigua na binaboli ke, ighai kai lutu vania Lord.” ");
INSERT INTO nlg_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Mana vure tara bosatughu, “Kai mua tangomana na saniana Lord maai Kikinima vanira na lei god keha. ");
INSERT INTO nlg_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Na pukuna a Lrd nimami na God te vavola ghai maia na lei kukuamami tana kabu pipiti I Egypt. Ma gia te gonighi na lei butuli te mamataghugha tana matamami. Mi tana bona tai vinano tana bona aroha, gaia te pilupilughai tadira na ghamami na levunimate. ");
INSERT INTO nlg_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","MA gaia Lord te ghuru Kehara na Amori maia na balu Kema ghua tara ghanara tana lei bona ruini. Keri ke, mi ghai ghua kai lutu vania Lord, napukuna gaia heghena a nimami na God. ");
INSERT INTO nlg_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Ma Joshua teg hoi bosa vanra na vure, “Kau tangomana gekau lutu vania Lord, a pukuna gaia na God te tabu me nighi sika na lei gehegehe dika. Me ke mua tangoma geke talukehai a nmiu na hughu pungisi mana plumiu ta nina maana gaia. ");
INSERT INTO nlg_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ke vaghaa au muri sania Lord makau lutu vanira na god keha ke, gaia ke ririu vanighau me ke taghalaghini ghau, sakai vamua te uto ngangata vanighau. ");
INSERT INTO nlg_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Mana vuresubo tara bosatughu vaniaJoshua mara gaghua, “Taho tua, tana puku ni liomami tua gekai lutu vania Lord!” ");
INSERT INTO nlg_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Ma Joshua teghoi bosavanira, “Ighau heghemiu tau bosaa mau vilia gekau lutu vania Lord.” Mana vure tara ghaghua vania, “Eo, ighai heghemami tai bosaa.” ");
INSERT INTO nlg_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Ma Joshua te ghaghua vanira, “Vaho ge uto taeni, kau taghalaghinighi na lei titinoni tamiu, makau riui na tobamiu vania Lord na God ni Israel.” ");
INSERT INTO nlg_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Mana vure taraghaghua vania Joshua, “Ighai kai lutu vania Lord nimami na God, ma gaia heghena vasoo kai taonia. ");
INSERT INTO nlg_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Ma Josh ate gonia na baubahu kolura na vure tana dani vaghana keri I Shechem, nia na pitikoluadira nia na gegere tutughuni te ngasi tana ghobudira gaira ma Lord. ");
INSERT INTO nlg_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Ma Joshua te gerei na totobo raini tana Buka ni Vetena nina God. Mete vaghaa na vatei ghanghana oli tana baubahu, gaia te pilia na vatu sule va tanasarana naghai tara vatua nia na oak, lilighina na Vuvale Tapole nina Lord. ");
INSERT INTO nlg_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Vaho ge bosa vanira na vuresubo udolu, “Na vatu ei te rongovi udolui na lei totobo te bosai vanighita. Ma gaia ke bosai ttei na lei totobo kau goni hahia, akau mua taonia nimiu na baubahu.” ");
INSERT INTO nlg_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Vaho aJoshua te nira vetena keha na vure va tana lei sopa komuna ma nina lologo. ");
INSERT INTO nlg_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Me mua hau vasoo imurina eni, Joshua nina tinoni lutu Lod, na dalena Nun, te mate tana 110 na niuluna. ");
INSERT INTO nlg_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ma gaira tara tavughia ta nina pari te loghoa I Timnah-Serah tana ghotu Ephraim, paleva longana na Ghotu Gaash. ");
INSERT INTO nlg_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Ma Israel gehegehe vani Lord tana leibongina Joshua tevola maia na le mane uhu=uhuli tara vola imurina gaia, gaira kiri tara righighi mara ghilalai na lei totbo a Lord te gonighi vania Israel. ");
INSERT INTO nlg_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Mana hulinaJoseph, gaira rana Israel tara lavghi mara nighi mai kolu taa tughuru mai Egypt, tara tavughia I Shechem, tana bona ni pari te pelua Jacob tadia na lei dalena Hamor nia sakai na hangalatu ni silver. Na pari eni te ghanaa tana tunuvadira na Kemana Ephraim mana kemana Manasseh, na vinavahuhuna Joseph. ");
INSERT INTO nlg_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ma Eleazar ghua te mate. Mara tavughia tana ghotu Ephraim, tana komu sule Gibeah tara diki vahea tua Phinehas na dalena. ");
INSERT INTO nlg_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Na ghanaghana eni te kale tana bonana Xerxes te vunaghi haba, te vunaghi pungisira sakai na hangalatu rua hangavulu vitu (127) na bubulo, te vuivuni India me sara Ethiopia. ");
INSERT INTO nlg_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Tana bona vaghana keri, agaia te vunaghi pungisia ta nina na malei sopou ni vunaghi haba ilokana na valengasina/sulena ni vunaghi haba i Susa. ");
INSERT INTO nlg_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Tana toluni nina niulu ni huhuli, agaia te gonia sakai na vanga koukolu/savukolu sule ngangata vanira nina lei mane huhuli maira na lei mane nagho udolu. Agaia te holora mai tana savukolu keri, na lei mane/vunaghi nagho ni kisumate udolu maira na lei mane manaha mana lei vure lutu nagho udolu tana lei bubulo. ");
INSERT INTO nlg_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Na gougonu ni togotogo eni te lavighi ara ono na vula, na talutateani nina lei lologho mana sosodo, mana tutugu ni ladana mana rongoraghana na kinakabu te haba pungisia gaia. ");
INSERT INTO nlg_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Mi murina na lei bongi raeni, na vunaghi haba te ghoi gonia sakai na savukolu/vanga nulavi sule vanira na lei vure lutu udolu nina vale vatungasi na vunaghi haba i Susa, tara vuivuni tana haba me sara tana tinoni pari sosoko. Na savukolu ni togotogo eni te lavighi ara vitu na bongi (sakai na week), mana savukolu eni tara gonia tana lokana na leghai ni vale sulena na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Ilokana na leghai/Na loa tara vaguvagua nighi na lei tivi pura mana mera/mauri tara vauhi utoutoi tara tari talighutia nia. Tara piti kaui nighi va tana lei bore/papada/ringi vitiviti ni silver nighi na lei tivi pile daodaro te ghioghio/dengedenge gera tari kaui tana lei vatu daro pura tara tughuru, tara holoa nia marble. Na lei vatei sopou tara gold mara silver, tara tughuru tana padepade, tara gonighi nia na vatu ngasi vaguvagu tara loghoi na kirikiri kehakeha. ");
INSERT INTO nlg_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Na inu tara hera na lei vure tana kapu gold tara goni kehakehai, mete subo ngangata na lei wine ni vunaghi haba, taonia na bosana agaia na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Na vetena te mava vamua tara talua tana bona ni inu ke, ge kara bei kurutia gea siki sakai na inu au vuleana na hava te liona. Mara hei tara liona sono ke, kara inu taonia sono na liodira, taonia na bosana na vunaghi haba vanira nina vure lutu, ge na lei sopa tinoni udolu kara detea heghedira taonia na sopa ghanaghanadira. ");
INSERT INTO nlg_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Mi tana bona vaghana keri, na vinahogho Vashti te gonia ghua na savukolu sule, vanira na lei vinekama udolu ilokana na vale sulena na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Mi tana vituni na bongi ni savukolu, na vunaghi haba Xerxes te nia bulebule pile tua na wine te inuvia, ge bosa vanira Mehuman, Biztha, Harbona, Bigtha, Abagtha, Zethar maia Carcas, agaira raeni ke, ara vitu nina ghairau nagho tara lavahira, tara kabu kolua, ");
INSERT INTO nlg_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","ge kara lavia vania mai a vinahogho Vashti, kolua nia na pitiulu ni vinahogho tana uluna. Agaia te liodira na lei mane udolu tua ge kara totolaa ma kara vaevanea ivei te vagha vahotua na utona na reireina, na pukuna agaia Vashti te puku ni vinekama uto ngangata. ");
INSERT INTO nlg_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Hauva ka, tana bona tara rongorongoa vania na bosana na vunaghi haba Xerxes, agaia Vashti te hove na tona taoniadira. Mana ghanaghana eni te nia dika na liona na vunaghi haba, ge rutu ngangata. ");
INSERT INTO nlg_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Keri ge na vunaghi haba te kokoe kolura tua nina lei mane manaha tara tarai manahaa nighi na lei samalaghi. Ma gaia te huatira haia ge kara taghaoa tana lei samalaghi, na pukuna tara ghilala udolui na lei vetena ni gavumane mana lei nilabuna/vetena haulaghi tana vavata ni Persia. ");
INSERT INTO nlg_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Na ahadira na lei mane nagho raeni ke, Carshena, Shethar, Admatha, Tarshish, Meres, Marsena maia Memucan, agaira raeni ke, ara vitu (7) na mane nagho tara haba itadira na lei mane nagho ni Persia mi Media. Agaira raeni tara kabu dutuvia mara lutu koukolua haia tua na vunaghi haba, mara lavighi ghua na lei malei lutu nagho tana kinakabu ni Persia mi Media. ");
INSERT INTO nlg_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Na vunaghi haba te nongi ngangatara nina lei mane manaha me ghaghua, “?Na hava ka gonia vania vinahogho Vashti? ?Mana hava na totoro ia ka hea ahei na vinahogho vaghana ke mua taonia nina na arovaghi/kokoe rughuhoru na vunaghi haba, te nia vetena rughuhoru nia na mangadira nina lei ghairau nagho?” ");
INSERT INTO nlg_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Ma Memucan te bosa tughu vania na vunaghi haba ma nina mane manaha, “A vinahogho Vashti te gonia na hahi eni vania na vunaghi haba, mete vanira ghua na lei mane lutu nagho maira na lei mane udolu tana kinakabumu. ");
INSERT INTO nlg_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Na lei vinekama tana lei komu ilokana na kinakabumu, kara vuivuni ni niadira sika mana hughuadira na lei taudira tana bona kara ghilalaa/rongovia vinahogho Vashti te hove na mai tatana na vunaghi haba tana bona te nongia. ");
INSERT INTO nlg_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Inaghona geke padi na bongi eni ke, igeva na lei taumami ighai nimua na lei mane lutu nagho ilokana na kinakabu talighu eni, kara rongovia na hava te gonia na vinahogho, ma kara vuivunia na kokoe vaniadira na lei taudira te vagha te ghaghua iga na vinahogho. Igeva ke mua soko tua na vola ni mua talumava mana ruturutu ilokana nimua na kinakabu. ");
INSERT INTO nlg_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Ma ge teke uto itatana na vunaghi haba ke, mi ghai tai detea geko nia vetena rughuhoru sakai na vetena tana gegere tutughuni, na vetena geke mua ghoi tughua tua siki tinoni ni Persia mi Media. Na vetena eni ke talutatea tana kokoe vania vinahogho Vashti, ko hove kasilaa tua, me ke mai tana matamu. Mo ko ghoi vilia sakai na vinahogho ke too uto vanigho tughua gaia. ");
INSERT INTO nlg_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Tana bona na vetena eni kara gegere horua tana lei komu talighu ilokana na kinakabu sule eni, na lei mane taulaghi, tara sodo rongo pa ra bona, igeva kara sodoa na puku ni talumava itadira na lei taudira.” ");
INSERT INTO nlg_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Na vunaghi haba ma rana mane manaha keha toro ghanaghana tana liodira te uto na ghanaghana manaha eni, keri ge taonia nina ghanaghana a Memucan. ");
INSERT INTO nlg_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Agaia na vunaghi haba te nighi vetena rughuhoru na lei gegere tutughuni vaa tana lei baebasena na kinakabu, vania sopa bubulo tana sopa leudira. Te ladavaghinia ge na lei mane udolu kara vunaghini na lei sopa taudira maira na lei daledira tana valedira. ");
INSERT INTO nlg_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Hauva ka mi murina na vunaghi haba Xerxes te uto ta nina na rutu, agaia te vuivuni ni ghanaghana oliana Vashti, mana hava gaia Vashti te gonia maia na vetena te taluhorua agaia. ");
INSERT INTO nlg_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Keri ke, ma gaira na lei ghairau tara kabu kolua haia tara bosa vania, “Aghe vunaghi haba, ko nira vetena rana tinoni lutu ge kara kenea ilokana na kinakabu udolu balu tahula marabu tara reirei utodira lee vanigho ighoe. ");
INSERT INTO nlg_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Aghe vunaghi haba, ko vilira sasakai tinoni tana sopa bubulo ilokana na kinakabu, ge kara sopa lavira mai na lei tahula sule vaolu tara uto na reireidira, tana vale ni vaivine iga tana vale vatungasi i Susa. A Hegai, na tinoni haba te vunaghina rana vaivine, ke sopa vaevanera, ge sopa gaira ke righitaoni utora nia na lei reresi mana lei dalovi. ");
INSERT INTO nlg_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Mi murina keri ke, na taholu marabu te uto ngangata itadira ko ghoi vilia geke vinahogho, ke ghoi tughua Vashti.” Na kokoe tarai ni manaha eni te uto vania na vunaghi haba, keri ge talua na ghanaghana talugoni eni mara samalaghinia tua. ");
INSERT INTO nlg_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Mi tana bona vaghana eni ke, a sakai na tinoni ni Jew tara holoa nia Mordecai, na dalena Jair, te ghahaa tua tana vale vatungasi na vunaghi haba ikakeri Susa. Agaia te mai tana vinavahuhudira Kish ma Shimei, tana kemana Benjamin. ");
INSERT INTO nlg_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Te padi tua tana bonana vunaghi haba Nebuchadenezzar te laga vulea na vunaghi haba Jehoiachin ni Judah tana kisumate, gaia te soniasia nina kulana vure Mordecai kolura nia vunaghi haba Jehoiachin mana subo na vure keha ghua, mara sania Jerusalem ge ra ghaha kolili tana bubulo i Babylon. ");
INSERT INTO nlg_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Na tinoni eni a Mordecai te loghoa sakai na vaivinena halavu, te sule vaolu me uto ngangata na reireina, tara holoa nia Hadassah, na ruani na ahana ke, Esther. Mi tana bona tinana ma tamana toro mate, a Mordecai te lavipangotia mai, me kutia ge sulea te vaghaa na dalena vaivine heghena tua. ");
INSERT INTO nlg_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Taonia te vagha nina vetena na vunaghi haba te talu rughuhorua, a Esther kolura nia subo na tahula vaolu, tara lavira va tana vale vatungasi na vunaghi haba i Susa, ge kara ghahara iga, mara talura sarana nina righitaoni Hegai. ");
INSERT INTO nlg_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Hegai te nia togotogo ngangata Esther me righitaoni utoa ngangata. Agaia te talua na kokoe ge kara gonia vania na balu vanga tara uto ngangata, me hea ghua na balu dalovi/totobo ni gonigoniani na hulina. Ma gaia (Hegai) te vilira ghua ara vitu na vinekama lutu ge kara righitaonia, te vili kehara tadira na lei vinekama lutu tana vale sulena na vunaghi haba, me talu kehara va ta sakai na bona te uto ngangata igaa, tana vale keri tara ghahara iga. ");
INSERT INTO nlg_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Esther te mua tutugua vania tua siki tinoni na tutuguna heghena gaia maia ivei te vagha nina binaboli, na pukuna Mordecai te hovea geke bei tutugua gea. ");
INSERT INTO nlg_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","A Mordecai te sakusakutua tonahaliu haia tughu dani lilighina na pilupiluna na vale na lei vaivine tara ghahara iga, geke huatira na vure tara lutu iga, nia ivei sono te ghaghua na kabuana Esther. ");
INSERT INTO nlg_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Inaghona ge kara holaa va tana malei ghimena na vunaghi haba sopa tahula vaolu ke, kara diki gonigonia mughua na hulina ilokani ara hangavulu-rua na vula ge ke utoutoa va. Ono na vula kara gonigonia/dalovia nia na kokolo ni olive te lolola na myrrh, mara ono na vula imurini vaa, kara gonigonia nighi na balu kokolo uruurua kehakeha ghua mana lei reresi. ");
INSERT INTO nlg_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Mi tana bona te sara nina bona ge sopa tahula ke haghe ni righimatana na vunaghi haba ke, ara bosa vania geke vilivili taonia na liona heghena, ivei te vagha na tivi vaghana mana lei vaguvagu vaghani ke haghelighi geke nia uto au vule na reireina. ");
INSERT INTO nlg_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Tana nulavi vaghana keri, gaia sopa tahula kara lavia vaa tana lei vokina heghena na vunaghi haba. Mi tana puipungi ghana, agaia kara ghoi lavia va tana ruani na bona ke ghahaa iga, tana bona tara ghahara iga na lei tauna na vunaghi haba. Agaia ke kabu sarana nina maana Shaashgaz, a sakai tadira nina lei mane haba, tara holora nia na eunuch. Agaia ke ghaha tua tana bona keri tana lei bongi ni volana, me ke mua ghoi vaa tua tana vunaghi haba, koekobe na vunaghi haba ke nia togotogo kolua me ke nongia vaa nia na holoana na ahana. ");
INSERT INTO nlg_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Esther na dalena vaivine Abihail, ma Mordecai na tabuna te kutia me lavipangotia te vaghaa na dalena vaivine. Mi tana bona te sara nina bona Esther geke va righimatana na vunaghi haba, agaia te lavipangotia me taonia nina tarai Hagai, agaia sakai tadira nina lei mane haba tara holora nia na eunuch, te righitaonia na vale tara ghahara iga. Agaia Esther te mua nongia siki totobo, sakai manaa na hava vamua te detea Hagai. Ma gaira udolu tara vaevanea Esther tara nia gharu na reireina. ");
INSERT INTO nlg_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Tana bona tara lavia va tana vale sulena na vunaghi haba Esther, geke vaevane matana vunaghi haba Xerxes ke, tana hangavuluni na vula tana niulu tara holoa nia Tebeth, tana vituni nina niulu ni huhuli. ");
INSERT INTO nlg_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Na vunaghi haba te dolovi-uto ngangata gaia Esther vulera na lei tahula vaolu/maemane udolu. Agaia te togotogo ngangata kolua Esther, keri ge talua na pitiulu ni vunaghi haba tana uluna, me ladavaghinia ge agaia Esther tua te vinahogho tughua Vashti. ");
INSERT INTO nlg_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Geke nia togotogo na hava te kale eni, agaia te gonia sakai na savukolu/gougonu sule ngangata vanira na lei mane nagho, maira na lei vure lutu rongovi vevetena, nia na talumavaana Esther te vinahogho. Agaia ghua te hera na lei puku ni totobo uto ngangata nia na puku ni dolo vanira rana vure, me ladavaghinia ge na lei bubulo udolu ilokana na kinakabuna ge rana vure udolu kara aheahea tana lutu ma kara nia togotogo koukolu na ghanaghana eni. ");
INSERT INTO nlg_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","I murina keri, mi tana bona tara ghoi vahikolura rana tahula vaolu/maemane tana ruani na bona, ma gaia Mordecai te mane nagho tana vale sulena na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Agaia Esther te mua tughunia vania siki tinoni na tutuguna heghena gaia na Jew, maia na tutuguna nina binaboli na pukuna Mordecai te hovea. Ma gaia Esther te taonighi sono na lei bosana Mordecai, te vagha te gonia haia tua tana valena tabuna. ");
INSERT INTO nlg_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Tana sakai na dani te ghoi lutua na lutuna Mordecai ilokana na vale sulena na vunaghi haba, rogaira Bigthana ma Teresh, rana nina na mane nagho na vunaghi haba tara holoa nia eunuch, toro righitaoni tana mataula hagheni na lei vokina heghena na vunaghi haba, toro rutu vania vunaghi haba Xerxes, moro padalaghinia ge koro labumate poloa. ");
INSERT INTO nlg_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Hauva, ma Mordecai te rongovia na padalaghi eni, me tutugua vania vinahogho Esther. Keri ge a Esther te rongorongoa vania vunaghi haba Xerxes na hava Mordecai te tutugu vania. ");
INSERT INTO nlg_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Tana bona tara huahuati taotaonia na tutugu, mara kene sodoa te utuni na tutugu te rongorongoa Mordecai, rana mane raeni, a Teresh ma Bigthana tara ligho matera tana vatei tari-mate tinoni. Mana vunaghi haba te arevaghi na tutugudira tara gegerei tana buka ni tutuguna nina righitaoni/vunaghi pungisi vunaghi haba Xerxes. ");
INSERT INTO nlg_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Tana balu bonana imurini raeni, na vunaghi haba Xerxes te talu datoa Haman na dalena Hammedatha tana lavata ni malei lutu, agaia na tinoni eni te sivuragha mai tana kemana Agag. Na vunaghi haba Xerxes te talua geke puku ni tinoni nagho, me ke loghoa na maana tana kinakabu udolu te righitaonia gaia, mete tinoni lutu sasara itatana gaia oli heghena. ");
INSERT INTO nlg_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Na vunaghi haba te bosa papara vanira nina lei mane nagho ge kara talutatea vania Haman didira na talumava, ma kara tualaghi tuturu mara tongaghi kikinima itatana. Hauva ka, ma Mordecai te mua liona geke talutatea nina talumava vania Haman. ");
INSERT INTO nlg_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Ma keri ge, rana lei mane lutu nagho tara righitaoni tana mataula haghena na pilupiluna na vale sulena na vunaghi haba, tara bosa vania Mordecai mara ghaghua, “?Eghua ge o mua taonia nina na kokoe papara na vunaghi haba?” ");
INSERT INTO nlg_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Mordecai te bosa tughu, “Inau na tinoni ni Jew, mi ghai tai tualaghi tuturu mama moluhoru itatana God vamua.” Agaira tara kokoea vania tughu dani, hauva kaa, ma gaia te hove sono na taoniana na kokoe rughuhoru eni. Keri ge agaira tara tutugua vania Haman na gehegehena Mordecai, ge kara ghilalaa, ke lavipangotia sono na ghanaghanana Mordecai pe ke taho. ");
INSERT INTO nlg_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Mi tana bona agaia Haman te righi ghilalaa ge gaia Mordecai ke mua tongaghi kikinima vania, pa ke mua talutatea vania na talumava, agaia te vonughia na rutu papara na ghanaghanana. ");
INSERT INTO nlg_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Mi tana bona te ghilala tua te tinoni ni Jew a Mordecai, keri ge detea tana ghanaghanana, te mua ulaghana ge kara gonia vania siki ghanaghana ni mateana heghena vamua Mordecai. Agaia te ghanaghana tana liona ge ke mate udolura tua rana lei tinoni ni Jew ilokana na kinakabu udolu te righitaonia vunaghi haba Xerxes. ");
INSERT INTO nlg_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Keri ke, mi tana vula Nisan, na diki vula tana niulu, tana hangavulu-ruani na niulu te nia vunaghi haba Xerxes, Haman te arovaghinira ge ra gonia na loka tara holoa nia na “purim,” geke detea me ke tughunia na puku ni bongi mana vula kara gonia iga na haurakeadira rana vure ni Jew. Na vula tara vilia ke, tana hangavulu ruani na vula, tara holoa nia Adar. ");
INSERT INTO nlg_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Ma gaia Haman te va righimatana vunaghi haba Xerxes me ghaghua vania, “A sakai na vata ni vinavahuhu ni vure tara ghana kolilira tana lei bubulo ilokana na kinakabu eni to vunaghi habana ighoe, ma didira na lei vetena tara keha itadira na lei vata ni kema soko, maia tara mua lioni na taoniani na lei vetena, haba vaa, nina vetena na vunaghi haba. Keri ke, me te uto vanighita ge ro haurakera. ");
INSERT INTO nlg_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Age na vunaghi haba, geke uto ke ighoe, ko talu rughuhorua sakai na vetena ge kara matera na vure eni, mi nau ku hea sakai hangavulu na togha na mavani ni silver na lei mane nagho ni gavumane, keri ge kara talui lei rongo raeni tana vatei paopangoti rongona na vale sulena na vunaghi haba.” ");
INSERT INTO nlg_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Na vunaghi haba te lavipangotia nina ghanaghana Haman, me nia te lavi kehaa na papada (ringi) ni vaughilala tana gigirina me hea va Haman, na dalena Hammedathan tana kemana Agag, te kanahaghinira rana lei vure ni Jew. ");
INSERT INTO nlg_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Mana vunaghi haba te bosa vania Haman, “Ko gonia na hava to liona vanira rana vure eni, mana nimua na rongo.” ");
INSERT INTO nlg_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Tana hangavulu toluni na bongina tana diki na vula, a Haman te holokolura nina lei tinoni gegere na vunaghi haba, mara gegerei na lei gegere-tutughuni vanira na lei mane haba, maira arahei tara righitaoni tana lei bubulo, maira na lei vure tara lutu-nagho tana lei bubulo, tana lei didira sopa gegere-vaughilala mana kokoedira. Na lei gegere-tutughuni raeni ke, tara gegere-vaughilalai nighi na ahana vunaghi haba Xerxes, mara vaughilalai nighi nia ghana (nina) papada ni vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Mana lei vure lavi rongorongo tara lavighi vaa tana lei bubulo udolu talighutia na kinakabu te vunaghi habana gaia Xerxes. Na vetena tana gegere-tutughuni te talutatea ge na lei vure Jew udolu, vure-vaolu mana tonikama, kolura nia na lei vinekama mana gari kara matera, pahepahera, ma kara haurakera mughua ilokana sakai na bongi vamua. Na ghanaghana eni tara padalaghini-dilaa geke kale tana hangavulu toluni na bongina na vula Adar, na hangavulu ruani na vula tana niulu. Na didira na lei lologho rana vure ni Jew kara matera ke, kara loghoi tua arahei kara matera gaira. ");
INSERT INTO nlg_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Na gegere-tutughuni eni tara gegere halavui mara nighi vetena rughuhoru vaa tana lei bubulo, mara talutatea vanira na lei vure udolu tana kema talighu ge kara ghilalaa, keri ge kara gonidila ni lutuani na lei lutudira tana bongi keri tara vili tua. ");
INSERT INTO nlg_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Taonia nina kokoe papara na vunaghi haba, na vetena eni te mua moto na potitiana na kema udolu, nighi na limadira rana lei vure lavi rongorongo, mara ladavaghinia tana vale vatungasi sule i Susa. Vaho keri ge oro sopou ni inu a vunaghi haba Xerxes ma Haman, hauva kaa, mana vure udolu tana komu-sule i Susa tara mua ghilalaa na hava kara gonia. ");
INSERT INTO nlg_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Tana bona Mordecai te ghilalaa na hava tara gonia, agaia te rosighi na lei tivi tana hulina, me pupulu nia na tivi ni dikalio me saroa nia na uluna na ravu, ge sakusakutua kolili tana komu sule, ge tangi ngangaraha. ");
INSERT INTO nlg_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Hauva, mi tana bona gaia te sara tana mataula haghena na vokovokona na vale sulena na vunaghi haba, agaia te tughuru ni tangi pari murina, na pukuna ara mua talana siki sakai geke rughuhaghe tana vale sule tana bona ke haghelia na tivi ni dikalio. ");
INSERT INTO nlg_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Mi tana bona te saravighi na lei bubulo udolu na vetena te talu rughuhorua na vunaghi haba, na kabu ni dikalio sule i ghobudira na lei vure ni Jew. Agaira tara nia maturutoo na vanga, ara dikalio mara tangi ngangaraha te daro ni bona, me subo itadira tara nighi koikoli kolu na tivi ni dikalio mana ravu. ");
INSERT INTO nlg_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Tana bona rana lei nina vaivine lutu maira rana lei mane manaha tara holoa nira eunch vinahogho Esther tara mai rongorongoa vania nia Mordecai, agaia te vonughia na dikalio. Agaia Esther te nia vetena vania vaa na tivi uto geke tughui nia na tivi ni dikalio, hau vakaa, Mordecai te hove na laviani. ");
INSERT INTO nlg_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Keri ge Esther te holoa mai Hathach, a sakai tadira nina lei mane lutu tara holoa nia eunuch, gaia na vunaghi haba Xerxes te vilia geke kabukolua Esther. Agaia Esther te nia vetena rughuhoru geke va vaevane-matana Mordecai, me ke kenesodoa vania na hava te hahi tatana, me ghua keri ge kabu dikalio. ");
INSERT INTO nlg_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Keri ge rughuhoru a Hathach me tona va ta Mordecai tana bona keri inaghona na mataula-haghena na vokovokona na vale sule ni vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Mordecai te tutugu udolui vania Hathach na lei totobo, me bosaa vania nia ghua ara ngiha na rongo te nighi baubahu Haman geke pelu haghea tana vatei paopangoti rongona na vale sule, ge kara matera na lei vure ni Jew. ");
INSERT INTO nlg_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Ma Mordecai te hea ghua Hathach a sakai na gegere-tutughunina na vetena tara talu-rughuhorua i Susa, te talutatea na hoholo ge kara mate-pisura (sokora) tua na lei vure ni Jew ilokana na kinakabu udolu te mana pungisia gaia vunaghi haba Xerxes, me nongia geke va tatea vania Esther. Ma gaia te nongia ghua Hathach geke tutugu kaekale utoa vania, me ke keikeria geke va vaevane matana na vunaghi haba, me ke kurutia nina veiarovi, me ke nongia na hahanga ni veiarovi tatana tughura kulana vure. ");
INSERT INTO nlg_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Keri ge agaia Hathach te nia pulohi vania Esther nina rongorongo Mordecai. ");
INSERT INTO nlg_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Ma Esther te ghoi nia vetena pulohi sono Hathach geke va talutatea vania Mordecai na rongorongo eni. ");
INSERT INTO nlg_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Na maramana udolu te ghilala tua, ge siki sakai ke va tughuru tate tana matana na vunaghi haba, ilokana na valena te ghaha iga tana bona tara mua holoa ke, ma kara matea mughua, sakai vamua/mana ke haua vania va nina totoghona gold. Mete vula sara tua itaeni te mua holou na vunaghi haba ge ku righi matana inau.” ");
INSERT INTO nlg_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Keri ke, ma Hathach te rongorongoa vania Mordecai nina rongorongo Esther. ");
INSERT INTO nlg_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Ma Mordecai te nia vetena pulohi vania Esther na bosatughu eni, “Ko bei ghanaghanaa gea na bona ni aho vaghana keri, ge ko ghahagho i kakeri tana vale sulena na vunaghi haba ighoe mo ko vola, tana bona na lei vure ni Jew udolu kara matera tua. ");
INSERT INTO nlg_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Ge ko kabu beto vamua tana bona ni aho vaghana eni ke, siki sakai tana balu komu keha ke mai me ke voladira na lei vure ni Jew, hauva kaa, mi ghoe maira na lei kulamu na vure ke, ka mate. ?Na hava ghua iga, na hava ke ghoi bosaa ghua hei, hauva kaa, mi ghoe tara talu datogho tana malei haba tana vale sulena na vunaghi haba, nia vamua tana vata ni bona ni aho vaghana eni?”. ");
INSERT INTO nlg_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Ma Esther te ghoi nia vetena vania vaa Mordecai na bosa-tughu eni, ");
INSERT INTO nlg_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Ko tona mo ko holokolura na lei vure ni Jew udolu tana komu sule i Susa, ma kau maturutoo tana vanga, na pukuna inau. Kau bei vanga ma kau inu gea ilokani ara tolu na bongi mana dani. Inau kolura nigua na lei vaivine lutu kai gonia ghua te vaghaa. Ma keri ge, sakai vamua te mua tala na vetena ke, inau ku tona sono mu ku vaevane matana na vunaghi haba. Ma ge ku mate mughua ke, mi nau tu liona sono ge ku mate.” ");
INSERT INTO nlg_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Keri ge tona Mordecai me goni taonia na hava te bosaa vania Esther. ");
INSERT INTO nlg_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Imurini ara tolu na bongi, Esther te haghelighi nina lei tivi ni tinoni-haba me va haghe iloka te ghaha iga na vunaghi haba, ilokana na vale sule ni vunaghi haba, levuna vamua nina voki vatei gougonu na vunaghi haba. Na vunaghi haba te sopou tana nina na malei sopou ni vunaghi haba, ge rei tona vaa tana vatei rughuhaghe (mataula). ");
INSERT INTO nlg_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Tana bona te vaevanea vaa vinahogho Esther te tughuru i naghona, agaia te holopangotia, ge tabea nina totoghona gold ni maana ge haua vania vaa. Keri ke, Esther te sakutua vaa itatana ge tabea na sosokona na totoghona gold keri. ");
INSERT INTO nlg_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Ma gaia vunaghi haba te huatia gaia Esther me ghaghua, “?Aghe vinahogho Esthera, na hava to liona? ?Na hava nimua na nongi? Inau ku hegho na hava ko nongia itagua, sakai manaa levuna nigua na kinakabu ko nongia ke, inau ku hegho sono!” ");
INSERT INTO nlg_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Ma gaia Esther te bosa tughu me ghaghua, “Aghe na vunaghi haba, geke vagha ke uto sono itamua ke, mi ighoe ma Haman koro mai tana gougonu sule igevaa tu gonidilaa vanigho.” ");
INSERT INTO nlg_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Na vunaghi haba te ririu va itadira nina vure lutu tara kabu lilighina me ghaghua vania sakai tadira, “Ko bosa vania Haman me ke mai tana gougonu sule, taonia nina nongi Esther.” Keri ge rogaira Haman ma vunaghi haba toro tona tana gougonu sule te gonidilaa Esther. ");
INSERT INTO nlg_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Mi tana bona tara inu wine (wine), na vunaghi haba te ghaghua vania Esther, “Ko bosaa vaniu tua taeni na hava to puku ni liona. ?Na hava nimua na nongi? Inau ku hegho na hava ko nongia itagua, sakai manaa na levuna nigua na kinakabu ko nongia ke, inau ku hegho sono!” ");
INSERT INTO nlg_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Ma gaia Esther te bosa tughu me ghaghua, “Aeni nigua na nongi, mana puku ni ghanaghana tana tobagu tu ghanaghanaa geke ghaghua iga. ");
INSERT INTO nlg_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","O vunaghi haba, geke uto sono itamua, mo liona sono ge ko gonia vaniu na hava ku nongia ke, u nongi ngangatagho ge ko mai kolua Haman iropo tana gougonu sule ku gonidilaa vanighau. Mi ropo ge ku tutugu utoa vanigho ivei te vaghaa na ghanaghana ia eni.” ");
INSERT INTO nlg_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Ma Haman te togotogo ngangata tana bona te rughuhoru sania na gougonu sule keri. Hauva, mi tana bona te vaevanea Mordecai te sopou tana mataula haghena na vokovokona na vale sule ni vunaghi haba, me mua tughuru dato me mua tongaghi meke nia kikinima tana bona te mai tona haliu, agaia Haman te nia rutu ngangata. ");
INSERT INTO nlg_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Sakai vamua te vaghaa keri, agaia te patupatua heghena sono me tona haliu vaa tana valena. Keri ge holokolura mai tatana rana lei kulana te dolovira maia Zeresh na tauna, ");
INSERT INTO nlg_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","me nia kokoe talunagho vanira nina lei lologho maira na lei dalena tara subo, me kokoe talutatea heghena vanira ghua nia na talumava mana malei lutu sule ngangata, na vunaghi haba te hea, me taludatoa tana lutu agaia haba vulea na lei vure lutu nagho udolu. ");
INSERT INTO nlg_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Ma gaia Haman te tona haliu sono na kokoe, me ghaghua, “Tara mua gaighi vamua raeri! A vinahogho Esther te hologhai vamua inau mana vunaghi haba tana gougonu sule te gonidilaa vanighai roghai. Me ghoi nongiu sono ge ku gougonu kolua gaia maia vunaghi haba iropo! ");
INSERT INTO nlg_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Me tona haliu sono na kokoe, me ghaghua, “Hauva kaa, mana lei totobo raeni udolu ke ara mua pukugha vamua, tana bona tu vaevanea Mordecai na tinoni ni Jew te sopou sono ikakeri tana mataula haghena na vokovoko/pilupilu ni vale sulena na vunaghi haba!” ");
INSERT INTO nlg_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Keri ge a Zeresh, na tauna gaia maira na lei kulana te dolovira udolu, tara dete koukolua te vagha eni, “Ko gonia sakai na vatei tari-mate tinoni, ara hangavulu rua mana levu (12.5) na ghoto na datona, mi ropo tana puipungi ke, ko nongia na vunaghi haba ge ko tari sasaraua tana luana Mordecai iga, me ke mate. Keri ge ighoe ko tona togotogo kolua na vunaghi haba tana gougonu sule keri, murina ko mate tua Mordecai.” Haman te nia togotogo ngangata na ghanaghana eni, ge vetenara na lei vure lutu ge kara gonia na vatei tatari-mate tinoni. ");
INSERT INTO nlg_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Na vunaghi haba te sodoa na vahola tana bongi keri, te mua malumu vania geke maturu, keri ge hea na kokoe na tinoni lutu te mai kabu kolua, geke holai vania mai na lei gegere tutughuni alaala haulaghi ni vavatana na kinakabu te vunaghi habana gaia, ge ke idumighi vania me ke rongovighi. ");
INSERT INTO nlg_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Ilokani na lei gegere tutughuni rakeri, agaia te kene sodoa iga ivei te nia na talutateana Mordecai didira ghanaghana padalaghi ni mateana agaia te vunaghi haba, rogaira Bigthana ma Teresh, rogaira rua nina tinoni vatogha na vunaghi haba tara holoa nia eunuch, toro righitaonighi na lei mataulani na lei vokina heghena na vunaghi haba, te mua haghevighi siki tinoni keha. Oro padalaghinia ge koro mate poloa na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Na vunaghi haba te huahuati mi ghaghua, “?Na hava na taba vaghana, pana vaughilala ta hea Mordecai nia na hava te talutatea na gegere tutughuni eni?” Ma nina na tinoni te kabukolua te bosatughu vania me ghaghua, “Taho siki totobo!” ");
INSERT INTO nlg_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Na vunaghi haba te huahuati me ghaghua, “?Ahei agaia tana buto ni vale pari keri?” Tana bona vaghana eni ke, te sara mai tua pari tana buto ni vale te ghaha iga na vunaghi haba Haman, geke mai nongia na vunaghi haba me ke tari sasaraua Mordecai tana luana me ke mate, tana vatei tari-sasarau tinoni geke mate, te gonidilaa tua gaia. ");
INSERT INTO nlg_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Mana tinoni keri te kokoe vania vaa te bosatughu me ghaghua, “A Haman i pari keri.” Mana vunaghi haba te bosa vania, “Ko lavihaghea mai.” ");
INSERT INTO nlg_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Keri ge haghe mai Haman, mana vunaghi haba te bosa vania Haman me ghaghua, “?Na hava te manana sughua ge ku gonia vania na tinoni te gonia na totobo tu nia togotogo, nia na talumavaana?” Ma Haman te ghanaghana tana liona heghena te vagha eni, “?Ahei na tinoni ia te ghanaghanaa tana liona geke talumavaa? Inau sughua!” ");
INSERT INTO nlg_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Keri ge agaia te bosatughu vania me ghaghua, “Ge na vunaghi haba te ghanaghana geke talumavaa siki sakai ke, ");
INSERT INTO nlg_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","agaia ke lavi horua mai a sakai nina pupulu daro ni vunaghi haba heghena tua, maia ghua nina horse heghena tua, kolua nia nina pitiulu ni vunaghi haba tana uluna. ");
INSERT INTO nlg_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Me ke bosa vania sakai tadira na lei mane haba nagho te talumavaa gaia, geke pupulua nia nina pupulu daro na vunaghi haba na tinoni keri to nia talumavaa. Me ke huli kolilia tana lei bona ilokana na komu sule, ivuvungana nina horse heghena tua na vunaghi haba. Me ke ghuughuu ni ladavaghinia tana bona ke tona haliu, ‘Aeni te vaghaa na hava kara gonighi vanira arahei te ghanaghana geke talumavara gaia na vunaghi haba.’” ");
INSERT INTO nlg_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Mana vunaghi haba te ghaghua vania Haman, “E to'o uto ngangata! Ko mina tua mo ko holaa nigua na pupulu daro maia nigua na horse, mo ko goni taonighi te vaghaa to bosai tua vania Mordecai na tinoni ni Jew, agaia te sopou tana mataula haghena na pilupilu ni vale sulegu. Ko bei taho gea na goniani na lei totobo to padalaghinighi!” ");
INSERT INTO nlg_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Keri ge Haman te lavia na pupulu daro me pupulua nia Mordecai, ge sopoulaghinia vuvungana nina horse na vunaghi haba, me huli kolilia ilokana na komu sule keri. Me ghuughuu, me ghaghua, ““Aeni te vaghaa na hava kara gonighi vanira arahei te ghanaghana geke talumavara gaia na vunaghi haba.” ");
INSERT INTO nlg_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Mi murini raini, a Mordecai te ghoi pulohi sono tana mataula haghena na pilupilu ni vale sulena na vunaghi haba, hauva kaa, ma Haman ke, te mina tua me pulohi tana valena, nia te vonughia na dikalio maia te nia ma'a ngangata na hava te gonia vania Mordecai. ");
INSERT INTO nlg_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Tana bona Haman te tutugua vania Zeresh na tauna, maira na lei kulana te dolovira na hava te kale, agaira tara ghaghua vania, “Ighoe to vuivuni taeni ge ko sivilaghi nimua na maana vania Mordecai. Na pukuna Mordecai na tinoni ni Jew ke, ighoe ko mua nia tangomana tua ge o laga vulea. Ge ko tona haliu sono na hughuana ke, mi geva gaia ke lagavulegho sughua! ");
INSERT INTO nlg_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Mi tana bona tara tona haliu sono na kokoe, nina lei mane lutu na vunaghi haba tara holoa nia eunuch, tara saravira ge tua ge kara lavia tonaa Haman tana gougonu sule te gonidilaa tua Esther. ");
INSERT INTO nlg_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Keri ge gaia Haman maia na vunaghi haba toro tona tana gougonu sule te gonidilaa vinahogho Esther. ");
INSERT INTO nlg_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Mi tana bona tara inu wine tana dani keri, na vunaghi haba te ghoi huatia sono Esther, “Aghe vinahogho Esther, ko bosaa vaniu na hava te liomu. ?Na hava nimua na nongi? Inau ku hegho na totobo ko nongia, sakai manaa ke levuna nigua na kinakabu!” ");
INSERT INTO nlg_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Keri ge bosatughu vinahogho Esther, me ghaghua, “Ghe na vunaghi haba, ge ko lavipangoti togotogou inau mo ko liona geko gonia vaniu na hava ku nongigho ke, ma nigua na nongi sule ngangata ke, ge ko vavolau gea inau maira na lei kulagu na vure. ");
INSERT INTO nlg_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Nia na pukuna inau maira na lei kulagu na vure ke tara nighami hunulu ge kara mateghai, pahepaheghai, maia kara mate taghalaghinighai. Ma ge kara hunulughai ge kai seka ke, mu ku mua nia ghaghua, ge mu ku kabu beto vamua na pukuna te mua totobo mava ngangata ge ku pungisighi nia na vunaghi haba.” ");
INSERT INTO nlg_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Agaia vunaghi haba Xerxes te kokoe huahuati me ghaghua, “?Ahei na tinoni ia ke gonia na totobo ia keri, geke haua na limana vuvungamu/pungisigho?” ");
INSERT INTO nlg_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Ma Esther te bosa tughu me ghaghua, “Na tinoni dika eni, a Haman ke, na ghamami na levunimate!” Ma Haman te mataghu ngangata tua tana matadira rana vunaghi haba mana vinahogho. ");
INSERT INTO nlg_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Ma gaia na vunaghi haba te tapa tughuru sania na malei sopouna nia na rutu papara, ge sakutua rughuhoru vaa tana kausana/leleghai na vale sulena na vunaghi haba. Hauva kaa, ma Haman te ghana pulohia sono geke nongia na vinahogho ge kara bei matea gea. ");
INSERT INTO nlg_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Mi tana bona te mua ghilalaa tua na hava ke gonia, agaia te tumu horu ta nina vatei sopou vinahogho Esther ge ke nongia ge ke arovia, tana bona ia tua te va pulohi oli mai tana kausana/leleghai na vale sulena na vunaghi haba. Ma gaia na vunaghi haba te suravia/kokoe ngangara laga me ghaghua, “?Ke tangomana sono geke loti na vinahogho itaeni ani tana vale sule, tana bona ku vaevanea tua inau?” Mi tana bona te kokoe mua na vunaghi haba, agaira nina lei tinoni lutu te kabukolua te saroa tua na maana mana ihuna Haman. ");
INSERT INTO nlg_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Keri ge bosa me ghaghua Harbona, a sakai tadira nina lei mane manaha na vunaghi haba, “Haman te gonia na vatei tari sasarau mate tinoni tana bebete ni valena, ara hangavulu rua mana levu na ghoto na datona. Agaia te gonia, nia te loghoa na ghanaghana geke matea iga Mordecai, na te volaa na vunaghi haba ge ara mua mate poloa.” Mana vunaghi haba te vetenara me ghaghua, “Vaghaa keri ke, ma kau tari sasaraua Haman iga me ke mate”. ");
INSERT INTO nlg_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Keri ge ara tari sasaraua Haman tana luana iga, ge mate. Mi murina keri, na vunaghi haba te mua rutu. ");
INSERT INTO nlg_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Tana bongi keri tua, agaia na vunaghi haba Xerxes te hea tua vinahogho Esther nina lei lologho mana valena Haman, te kanahaghinira na lei vure ni Jew. Keri gera lavia vania mai na vunaghi haba Mordecai, na pukuna gaia Esther te bosaa vania nia, ge agaia te halakulana Mordecai. ");
INSERT INTO nlg_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Na vunaghi-haba Xerxes te lavia na papada (ringi) ni vaughilala te laviolia tua ta Haman, ge hea Mordecai. Ma Esther te vilia Mordecai geke vunaghini lei nina lologho Haman. ");
INSERT INTO nlg_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Ma gaia Esther te ghoi mai sono ta vunaghi haba, ge mai pogho-tao horu tana tuana inaghona, ge nongi kurutia, nia na kolobu te tumu tana rana matana, geke bettoa nina ghanaghana talugoni dika vanira na lei vure ni Jew Haman. ");
INSERT INTO nlg_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Mana vunaghi haba te ghoi haua vania mai Esther nina totoghona-golu. Keri ge tapatughuru dato Esther ge vaa tughuru inaghona na vunaghi haba, ");
INSERT INTO nlg_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","me ghaghua, “geke liona sono na haba nigua na ghanaghana, maia ke uto sono tana ghanaghanana ke, me ke nia vetena horu a sakai na vetena, ke betoa nina vevetena Haman, geke mate udolura na lei vure ni Jew ilokani nina lei bubulo udolu na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","?Nia ivei ke ghaghua ge ku nia togotogo inau na vaevane-adira na lei kulagu na vure, maira nigua na binabolitana bona kara pahepahera, maia kara mate pisura?”. ");
INSERT INTO nlg_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Keri ge bosa vanira vinahogho Esther maia Mordecai, rana tinoni ni Jew vunaghi haba Xerxes, me ghaghua, “inau tu hea sokoa tua Esther na valena Haman maia nina lei lologho iga, mara tari sasaraua tua Haman me mate tana vatei tari sasarau ni mate tinoni. Na pukuna te tabotabo geke mate taghalaghinira na lei vure ni Jew. ");
INSERT INTO nlg_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Koro tona haliu tua na niana vetena rughuhoru vanira na kokoe na lei vure ni Jew tana ahana na vunaghi haba, talutatea vanira na hava te liomiu na bosaana vaniadira, mo koro vaughilalaa nia na papada (ringi) ni vaughilala ni vunaghi haba. Hau vakaa, mo koro ghanaghana utoa, na hava tua na ghanaghana ia kara gegerea iga na ahana na vunaghi haba, ma kara vaughilalaa nia na papada (ringi) vaughilala ni vunaghi haba ke, kara mua ghoi hughua pa, kara mua ghoi haurakea tua”. ");
INSERT INTO nlg_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Keri ke, mi tana rua hangavulu-limani na bongina June, na kokoe tara hera nina lei tinoni gegere na vunaghi haba. Te vagha te ghanaghanaa tua Mordecai, a gaira tara gegerea na vetena geke rughuhoru vanira vaa na lei vure ni Jew maira na lei vinahogho (na lei tauna na vunaghi haba), na lei vure righitaoni maira na lei vure ni komu tara lavi lutu nagho ilokani hangalatu rua hangavulu-vitu na bubulo, tara vuivuni India me sara Ethiopia. Na vetena tara gegerei tana lei vaughilala mana kokoe-dira na na lei vure udolu, kolura nia na lei vure ni Jew udolu tana kema talighu te haba pugisia vunaghi haba Xerxes. ");
INSERT INTO nlg_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Mordecai te gegere tana ahana na vunaghi haba, me vaughilalaa nia na papada (ringi), na vaughilala ni vunaghi haba. Agaia te nighi vetena na lei gegere tutughuni raaeni tana minamina vamua tua, nia na limadira rana lei vure hola bosa, agaira tara nighi sama minamina na lei horse tara righitaonira, haba vaa, nina na horse na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","A nina vetena na vunaghi haba te rughuhoru ke, te hera na maana na lei vure ni Jew udolu, ge kara sakai-sonikolu tana hava tua kara gonia, ge kara pilupungisia na vola-dira, ilokani na lei komu ni pura udolu tana kema te haba pungisia gaia vunaghi haba Xerxes. Agaira tara taladira ge kara matera, pahepahera, kara kosoi na sosono-dira ma kara mate taghalaghinira arahei tana siki koukomu pana bubulo, ge kara mai ni labuadira pa, na taudira mana daledira. Maia kara lavighi didira na lei lologho ghadira na lei levu ni mate. ");
INSERT INTO nlg_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Na bongi eni tara talua geke kale iga na kisumate ke, tana vitu na bongina na vula March tana niulu imurina eni, tana lei bubulo udolu ilokana na kema te haba pungisia gaia vunaghi haba Xerxes. ");
INSERT INTO nlg_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Na vetena eni ke, kara vaevane kalea te vagha sakai na vetena sule, ma kara ladavaghinia vanira na lei vure udolu. Tana ghanaghana vaghana keri ke, ge na lei vure ni Jew udolu kara gonidila ni lavi tughu itadira lei ghadira levu ni mate. ");
INSERT INTO nlg_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Keri ke, mana vunaghi haba te mavatia na ghanaghana eni, te nia hevei horu nina kokoe-papara, na lei tinoni hola-bosa tara nighi sama minamina na lei horse kukuti, na vatei samalaghi-niani nina lei lutu na vunaghi haba, nia na mina vamua tua, na vetena eni ke tara ladavaghinia ghua tana vale sulena na vunaghi haba i Susa. ");
INSERT INTO nlg_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Keri ge agaia Mordecai te haghelia nina pupulu-sule ni tinoni-haba, te pura me mera maia na piti-ulu golu, ge haghelia mai vuvungana keri na pupulu malebo te ghioghio. Mana lei vure ni Susa tara nia vanga-kolu togotogo na vetena vaolu te rughuhoru eni. ");
INSERT INTO nlg_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Na lei vure ni Jew udolu te vonughira na togotogo mana rivurivu, maia tara talu mavaa tana lei komu soko. ");
INSERT INTO nlg_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Na vetena te talu-rughuhorua na vunaghi haba te saravighi na lei bubulo mana lei komu ni pura, na lei vure ni Jew tara togotogo mara gonia sakai na vanga koukolu ni togotogo sule ngangata, mara talamaghinia mara ladavaghinia geke bongi ni vanga vuresubo vure subo, me ke bongi ni aheahe. Mete subo ngangata na lei tinoni tana komu tara vuha tinoni ni Jew tua, tara nia mataghu na hava kara gonighi na lei vure ni Jew udolu vanira gaira-oli heghedira. ");
INSERT INTO nlg_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Keri ke, mi tana vituni na bongina vula March, ara rua na vetena te talu-rughuhorui na vunaghi haba toro mai kale utuni. Tana bongi vaghana keri, ghadira lei levu ni mate na lei vure ni Jew tara ghanaghana dila ge kara mate taghalaghinira na lei vure ni Jew, hau va kaa, me mua kale te vaghaa tara ghanaghanaa geke ghaghua iga. Mana hava tara mua ghanaghanaa gaira te kale. ");
INSERT INTO nlg_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Rana lei vure ni Jew tara ghahara vamua ta sakai na bona tana lei sopa bubulo te mana pungisighi na vunaghi haba, ge kara pilupungisira heghedira ge kara bei vahaghitailira gea. Hau vakaa, me taho siki sakai ke mai pepora, nia na pukuna agaira udolu tara levunimate vanira tara mataghunira. ");
INSERT INTO nlg_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Ma gaira udolu na lei tinoni nagho tana kisumate, na lei vinahogho, agaira udolu arahei tara vunaghini na lei samalaghi tana lei bubulo maira tara lutu tana vale sulena na vunaghi haba, tara hangara na lei vure ni Jew na mataghuniana pana talumavaana Mordecai. ");
INSERT INTO nlg_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Na pukuna na Vunaghi haba/Nia te taludatoa Mordecai tana lutuna ilokana na vale sulena na vunaghi haba, mana ladana/lutuna te sepalaghi saravighi na lei bubulo, te vagha agaia te logho ngangata tua na maana. ");
INSERT INTO nlg_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Hau vakaa, mana lei vure ni Jew tara diki rughuhoru tua, mara matera ghadira na kana tana bongi keri tara talu-dilaa tua. nia na isi (Ghau/ ivi kasikasi te vanga levu mi levu). Agaira tara matera mara pahepahera mara gonighi vanira na lei totobo te taonighi na liodira, agaira tara mua dolovira. ");
INSERT INTO nlg_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Agaira tara matera ara lima na hangalatu ni tinoni tana vale ngasi sulena na vunaghi haba i Susa. ");
INSERT INTO nlg_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Agaira tara matera ghua Parshandatha, Dalphon, Aspatha, ");
INSERT INTO nlg_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Poratha, Adalia, Aridatha, ");
INSERT INTO nlg_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Parmshta, Arisai, Aridai maia Vaizatha. ");
INSERT INTO nlg_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","Agaira rakeri ke, ara hangavulu matapono na lei dalena mane Haman, na dalena Hammedatha, na tinoni te kanahaghinira na lei vure ni Jew. Hauva kaa, mara mua holai siki didira na lologho. ");
INSERT INTO nlg_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Tana bona tara tughunia vania na vunaghi haba ara ngiha na tinoni tara matera tana vale sule ni vunaghi haba i Susa tana nulavi vaghana keri, ");
INSERT INTO nlg_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","agaia te holoa vinahogho Esther me ghaghua vania, “rana lei vure ni Jew tara matera ara lima hangalatu ni tinoni tana vale sule ni vunaghi haba i Susa heghena vamua, maira ghua agaira ara hangavulu mapono na lei dalena mane Haman. ?Ma ge tara gonia te vagha keri i Susa ke, mana hava ghua te kale tana lei bubulo udolu? ?Hauva kaa, mana hava ghua te ghoi liomu itaeni, ke tala vanigho, bosaa vaniu mai, mi nau ku gonia vanigho”? ");
INSERT INTO nlg_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Ma gaia Esther te ghaghua, “Geke taonia nina na liona na haba ke, me ke taladira na lei vure ni Jew ni Susa, ge kara ghoi gonia sono i ropo na hava tara gonia itaeni, ma kara lavighi na huli-dira ara hangavulu na lei dalena Haman, ge kara tari sasaraura tana vatei tari sasarau ni doko mate tinoni.” ");
INSERT INTO nlg_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Keri ke, mana vunaghi haba te tala geke ghaghua iga, mana vetena ni talamaghi eni tara bosa-ladavaghinia lokana Susa talighu. Gaira tara tari sasaraura ghua tana vatei tari sasarau ni doko-mate tinoni hangavulu-matapono na lei dalena Haman, tara mate tua. ");
INSERT INTO nlg_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Keri ge ara ghoi savukolu sono na lei vure ni Jew Susa, tana alu na bongina March, mara ghoi matera sono tolu na hangalatu ni tinoni, ma gaira tara mua ghoi lavighi sono didira na lei lologho. ");
INSERT INTO nlg_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Mi tana bona vaghana eni ke, na lei vure ni Jew udolu lokani na lei bubulo tara sopa savukolu ta sakai na bona vamua, tana lei sopa bubulo ge kara pilupungisighi na voladira. Gaira tara sodoa na malumu tadira na ghadira levunimate, ara matera vitu hangavulu-lima na togha ni tinoni, gaira tara kana haghinira, hau vakaa, mara mua holai siki didira na lologho. ");
INSERT INTO nlg_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Na gehegehe eni te kale tana vituni na bongina March ilokani na lei sopa bubulo. Keri ge tana bongi murina eni, tana roropo-ghana, gaira tara kabu beto vamua, tara nia togotogo koukolu didira na laga-vule, te vagha na bongi ni vanga koukolu togotogo. ");
INSERT INTO nlg_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Hauva ka, mana lei vure Jew ni Susa tara tona haliu sono na mate-adira lei ghadira levunimate lokana ruani na bongi eni, mara kabu beto tana toluni na bongi. Mara nia na bongi keri ge didira na bongi ni vanga koukolu mana togotogo. ");
INSERT INTO nlg_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Mete vuivuni tana bongi vaghana keri me sara tana bongi taeni ke, na lei vure ni Jew tara ghana kolilira tana lei komu tara mua pilupilui, tara nia kabu togotogo sono nia na ghanaghana-oliana tana lei tughu niulu na bongi ni aheahe eni, tana bona na bihi te mua puku ni sule tua iga tana lokana na niulu, tana vula Feburary pa, March. ");
INSERT INTO nlg_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Mordecai te gegere horui na lei totobo tara kale raeni, me nia vetena rughu-horu na gegere tutughuni vanira na lei vure ni Jew udolu tara kabu dutu maia tara kabu sagau mai, ilokani na lei bubulo udolu te maana pungisia vunaghi haba Xerxes, ");
INSERT INTO nlg_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","te kokoe togotogora ge kara vanga koukolu togotogo ni ghanaghana-oliani ara rua na bongi raeni haia tughu niulu. ");
INSERT INTO nlg_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Agaia te bosaa vanira ge kara ghanaghana-olighi rana bongi raeni nia na vanga-koukolu mana togotogo, maia ghua na sopa hevei dolo ilevu mi levu, ma vanira ghua na vure tara mua lologho. Na gehegehe eni ke, na ghanaghana-oliana na bona rana lei vure ni Jew tara sodoa na malumu tadira ghadira lei levu ni mate, tana bona didira na dikalio te ghoi liliu ni togotogo mana roku te liliu ni rivurivu. ");
INSERT INTO nlg_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Keri ke, ma gaira rana lei vure ni Jew tara taonia nina ghanaghana Mordecai, mara vuivunia na goni taoniana tughu niulu te vaghaa na vavatadira ");
INSERT INTO nlg_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Haman a dalena Hammedatha tana kemani Agag te kanahaghinira rana lei vure ni Jew, te talua na ghanaghana ni vahaghitailiadira mana haurake taghalaghini-adira rana lei vure ni Jew, tana vula mana bongi te talutatea tana bona tara gonia na (loka/daisi) tara holoa nia na Purim. ");
INSERT INTO nlg_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Hauva kaa, mi tana bona te mai tughuru inaghona na vunaghi haba Esther, agaia vunaghi haba te talu rughuhorua na vetena te nia nina ghanaghana dika Haman te talu dilaa tua geke kale-olia heghena, ma Haman kolura lei dalena mane tara tari sasaraura tana lei vatei tari saarau ni doko mate tinoni. ");
INSERT INTO nlg_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Mughua sono te vagha keri, ge ara holoa nia na gougonu ni togotogo eni ke na Purim, (na bongi tara ghanaghana-olia iga tara vola tana mate tara piti dilaa vanira), na pukuna na Purim ke, na kokoe ni dania tua tara holoa nia na (loka/daisi). Keri ke, na pukuna nina (letasi/gegere-tutughuni) Mordecai maia ghua tara ghilala olia na hava tara gonia tua/te kalera tua, ");
INSERT INTO nlg_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","na lei vure ni Jew tara talamaghinia ge kara taludatoa na ghanaghana eni, ma kara talu-halavua vanira vaa na lei vavatadira maira arahei kara ghoi tinoni ni Jew ghua. Agaira tara kokoe ladavaghinia vanira na lei vure udolu, ge kara mua ghoi taho tua na ghanaghana-oliani nia na vanga koukolu togotogo ara rua na bongi raeni tara gegere horui tua tana bongini tughu niulu. ");
INSERT INTO nlg_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Kara ghanaghana-olighi na lei bongi raeni nia na vanga koukolu-togotogo tana lei vavata mana vavata, maia tana lei sopa binaboli ilokani na lei bubulo mana lei komu-sule ni vure pura tana kema udolu. Ke bei ghoi soko gea na ghanaghana-oliani nia na vanga koukolu-togotogo rana bongi raeni i ghobudira na lei vure ni Jew, me ke bei ghoi mate gea tana ghanaghana-dira na ghanaghana-oliani na hava tara kale iga, ighobu-dira na lei hala kuladira. ");
INSERT INTO nlg_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Ma keri ge vinahogho Esther, na dalena vaivine Abihail, kolua nia Mordecai na tinoni ni Jew, toro gegerea ruani na (letasi/gegere-tutughuni), moro talua nina na puku ni maana ni huhuli na vinahogho i murina nina na gegere-tutughuni Mordecai, ge koro talua me ke ghaghua tua iga na vanga koukolu-togotogo ni ghanaghana-oliana na bongi keri, (tara holoa nia na purim,) tara ghanaghana-olia iga tara vola tana mate tara piti-dilaa vanira tua. ");
INSERT INTO nlg_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Mete mai kolua ghua keri na gegere-tutughuni tara liona iga na mabo mana kabu sasarana na righitaoni, tara nighi vetena vanira vaa na lei vure ni Jew udolu ilokani sakai na hangalatu rua hangavulu-vitu na bubulo sarana nina righitaoni vunaghi haba a Xerxes. ");
INSERT INTO nlg_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Rana gegere-tutughuni raeni toro tatea geke ghaghua tua iga na vanga koukolu-togotogo ni ghanaghana-oliana na bongi keri tara vola iga tana mate tara piti-dilaa vanira tua, mana kabu koukolu-togotogo haia tughu niulu tana bonana tara talua tua geke kale iga, taonia na vetena toro talua rogaira Mordecai na tinoni ni Jew maia vinahogho Esther. Na lei vure tara detea tana ghanaghanadira ge kara kabu taonia na vanga koukolu-togotogo eni, te vagha tara detea tua tana ghanaghana-dira vanira gaira heghedira mana lei hala kuladira, ge kara talua na bona ni dikalio mana talukaa ni vanga/maturutoo ni vanga. ");
INSERT INTO nlg_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","A nina kokoe papara Esther te nia geke kale utuni na goniani na lei totobo, tana ghanaghana-oliana na bongi keri tara vola iga tana mate tara putu-dilaa vira tua, tara holoa nia na Purim (loka/ daisi), mara gegere horu udolui tana lei gegere-tutughuni. ");
INSERT INTO nlg_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Vunaghi-haba Xerxes te taluhorua na kokoe ni dikalio vanira na lei vure udolu ilokana na kema talighu ta vunaghi habana gaia, me va saravira ghua na lei komu lilighi ni tahi tara ghana haura mai vaho tua. ");
INSERT INTO nlg_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Na lei totobo sule ngangata te gonighi maia na lei gegere tutughunini udolu na ladana mana rongoraghana Mordecai, gaia keri na tinoni vunaghi haba Xerxes te taludatoa tana malei lutu, tara gegere horu udolui lokaa na buka ni (gegere tutughuni-dira) (vavata-dira) na lei vunaghi haba ni Media mi Persia. ");
INSERT INTO nlg_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mordecai na tinoni ni Jew tara talu datoa tana lutuna ge vuha mai tinoni lutu-nagho itadira arahei tara lutu tana gavumane, te tinoni lutu sasarana mai na vunaghi haba Xerxes heghena tua, (te Prime Minister) tana maana ni lutu huhuli. Agaia Mordecai te haba vule ngangata ighobudira na lei vure ni Jew udolu, tara nia gaia ge nia togotogo ngangata na lutuna, na pukuna te nia lutu laga ngangata na uto vanira na lei kulana vure, rana lei vure ni Jew udolu, maia te kuladira sono gaira udolu tana vale sule ni vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ghau, na togotogo/nina vauto God vanira ara hei tara mua taonia didira na uhuhuli tara dika, pa kara tughuru kolura rana tangohahi, pa kara nira udu kolu rana tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Ma gaira tara lioni vamua na taoniani na lei totobo te lioni a Lord; na bongi mana dani tara ghanaghanai vamua na lei nina vetena. ");
INSERT INTO nlg_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Gaira te vaghara na lei ghai tara subai lilighini na lei beti, ma gaira tara vangagha tughu niulu, te mua ghoi taho tua. Mana rauraudira te mua ghoi dudu ghua, mana hava tara gonighi vamua ilokani, te maemane tona haliu. ");
INSERT INTO nlg_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ma eni gaia te mua utuni itadira rana kiko; A gaira te vaghara na totobo lee vamua, te havukaghini kolilira na ghuri. ");
INSERT INTO nlg_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Ma gaira kara dete matera tana bongi ni dete. Rana tangotangodika te taho na maladira itadira rana uto. ");
INSERT INTO nlg_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Na pukuna Lord te vatoghai na halautudira tara uto, me vatoghai ghua na halautudira rana kiko te uhulira va tana totoro te sule. ");
INSERT INTO nlg_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","E ghua ge na lei tara talu tatei didira na rutu para ghaghada. Me ghua ge na lei tinoni tara sonileai didira na bona ni aho nia na ghanaghana taho puku ni? ");
INSERT INTO nlg_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Na lei vunaghi haba ni maramana tara gonidila ni veitotoghoni: mana lei tinoni huhuli kara tughuru kaukolu nia didira na lei ghanaghana popolo kara vahaghitailira nia a Lord, ma kara tughuru pungisia nia nina tinoni te siusiua. ");
INSERT INTO nlg_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Mai ghita ma ka gotia didira na tali halo,” ara ghaghua tara tangi ngangaraha; “Ge ka tatavahale ghita hegheda tana kabu popongo eni. ");
INSERT INTO nlg_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ma gaia te uhuhuli ikokou te kia. Ma Lord te batobatora nina. ");
INSERT INTO nlg_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ta nina na rutu te va betora nia: ma gaira tara mataghu nia na tatata ta nina rutu paraghaghada. ");
INSERT INTO nlg_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ma Lord te tughunitatea, “Inau tu talu horua a nigua na vunaghi vivili tana malei sopouna Jerusalem ta nigua na komu tabu. ");
INSERT INTO nlg_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Na vunaghi te ladavaghinia na lei nina vetena Lord. “Ma Lord te ghaghua vania, “Ighoe na dalegu. Itaeni inau tu talutatea ge ku Tamamu. ");
INSERT INTO nlg_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Na totobo vamua ko gonia, “Ko nongi, mi nau ku vahegho na lei kema ke vagha a nimua na lologho, tana sosokona na maramana. ");
INSERT INTO nlg_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ighoe ko gotira nia na tali halo, mo ko kara tara te vaghara na kuki vatu. ");
INSERT INTO nlg_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Mi taeni, ighau na lei vunaghi, kau talua na manaha te uto. Mi ghau tau uhuhuli tana maramana, tara bosa dila vanighau, ge kau bei ghoi nea na dika. ");
INSERT INTO nlg_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ko lutu vania Lord nia na ghanaghana mava mana mataghu, mo ko togotogo kolua nia na mataghu. ");
INSERT INTO nlg_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Ko va hea dalena God na puku ni maana, na pukuna ke bei rutu gea; me ke havukaghinigho gea ighobudira tara tangohahi; na pukuna nina rutu ke tangomana ge ke vagha na pagana na vavuna na lake na pile bona vamua. Mi vei vaho te vagha na togotogo vaghana; ke vanira ara hei tara kenea na righitaoni itatana. ");
INSERT INTO nlg_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Aghe Lord, ara subo na ghagua na levunimate; mara subo ghua tara tughuru pungisiu. ");
INSERT INTO nlg_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ara subo lee ghua tara bosa mara ghaghua: A God ke mua ghoi tangomana na hangaana!” ");
INSERT INTO nlg_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Mi ghoe ghe Lord, a nigua na tako te pilupilu, ma nigua na lada itatana gaia te ghaedatoa na ulugu tana oka. ");
INSERT INTO nlg_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Inau tu tangi vania Lord, ma gaia te bosa tughu vaniu mai ta nina ghotu te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Inau tu koli horu, mu tu maturu. Mu rarai mai tana maboagu; na pukuna Lord te righitaoniu. ");
INSERT INTO nlg_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Inau tu mua mataghunira ara hangavulu na togha ni levunimate, tara sama talighutiu. ");
INSERT INTO nlg_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Tughuru ghe Lord! Mo ko vavolau, a nigua na God! Tapoi na ngara dira gaira udolu na ghagua na levunimate; mo ko karatai na livo dira tara tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Na laga vule te va mai itamua ghe Lord: Lubatia nimua na vauto ke kabu itadira a nimua na vure. ");
INSERT INTO nlg_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Ko bosa tughu vaniu mai tana bona inau ku hoholo, na pukuna God te bosa tateu inau tu tatavahale. Ko lavi kehai a nigua na hahi: mo ko aroviu; mo ko arovighi a nigua na kokoeliulivuti. ");
INSERT INTO nlg_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ivei vaho ke vagha na darona: ighau na vure kau dikalai na lei nigua a uto? Mi vei vaho ke vagha na darona kau gonighi na lei hurutabo taho puku ni? Mi vei vaho ke vagha na darona kau nia sorisori, ge kau goni dila na mate? ");
INSERT INTO nlg_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ma kau ghilala utoa eni; A Lord te talu keha na uto vania gaia heghena. Ma Lord ke tangomana na bosa tughu tana bona ku holoa. ");
INSERT INTO nlg_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ko bei lubatia na rutu ge ke hulia na volamu: ke lavi haghegho gea tana tangotangodika. Ko ghanaghana vaovarongo tana bongi udolu: mo ko kabu todore. ");
INSERT INTO nlg_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ko gonia na puku ni sukaghi; mo ko varava ngasi itatana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Subo na vure tara bosa mara ghaghua, “Ahei vaho ke tatei vanighita na lei bona ni aho ke uto?” Lubatia na kia mangihi ni mangamu ke marara i vuvungamami ghe Lord. ");
INSERT INTO nlg_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ighau tau vaheu na togotogo te sule, vulera arahei tara loghoa na hali ni vagha te subo tana vavanga ni vaini. ");
INSERT INTO nlg_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Mi nau ku koli horu tana mabo, mu ku maturu. Mi ghoe heghemu a Lord, ko righitaoni tatavahaleu. ");
INSERT INTO nlg_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Aghe Lord, Ko rongoviu tana bona inau ku kokoeliulivuti; ko kabu avehiu ta nigua na tangi. ");
INSERT INTO nlg_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ko varongohia a nigua na tangi ni hahanga, aghe nigua na vunaghi ma nimua na God. Na pukuna ku mua ghoi tangomana ghua na kokoeliulivuti vaniana siki sakai na keha, mi ghoe heghemu vamua God. ");
INSERT INTO nlg_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Ko varongohia na talama ni mangagu tana roropo, ghe Lord. Tughu roropo, inau ku lavighi vanigho mai a nigua na nongi; mu ku avehi utoi na lei bosa tughu. ");
INSERT INTO nlg_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Aghe God, ighoe to mua lavia na togotogo itadira rana tangohahi mo ko mua nira ghaghua ara hei tara gonia na hahi. ");
INSERT INTO nlg_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Na pukuna keri, gaira tara talunagho kara mua lubatira ge kara tughuru tana bonamu te tabu, na pukuna ighoe to nira sika ara hei tara gonia na hahi. ");
INSERT INTO nlg_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ighoe ko durakera ara hei tara bosa sorisori: ma Lord te mua liodira tara labupolo mara gueguelo. ");
INSERT INTO nlg_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Na pukuna a nimua na dolo ke mua ghoi tughu, ge inau ku tangomana na haghe tana valemu! Nia na douna?? nigua na ghanaghana mava, inau ku holohabagho nia tana valemu te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Ko huliu tana halautu te maemane ghe Lord, ge na ghaghua na levunimate kara bei laga vuleu. Ko bosa lada utoa na hava ku gonia; mo ko tuhua vaniu vaniu na halautu ku ririu va iga. ");
INSERT INTO nlg_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Na ghagua na levunimate kara mua ghoi bosa tua asakai na bosa ke utuni. Na douna didira na ghanaghana ke, kara hurakera vamua na balu. Didira na kokoe te vagha na bule, te vagha na uru ni tinoni mate te va horu mai tana tavughi te tatavanga. Didira na bosabosa te vonughia na talunagho. ");
INSERT INTO nlg_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ghe God, ko bosa tate lagara agaira tara hahi. Lubatira ge kara hogo haghe ta didira na vugho. Ko ghuru ke hara, na pukuna te subo na paludira, maia tara hughuhughu kolugho. ");
INSERT INTO nlg_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ko lubatira agaira tara ungaunga itamua kara lavia na togotogo; lubatira ge kara linge rivurivu nia na holohaba ke va me vaa. Ko pilu pungisira, ge agaira tara datovia na ahamu, ko vonughira nia na togotogo. ");
INSERT INTO nlg_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Na pukuna ighoe to vautora na uto ge Lord, mo pilupilura nia a nimua na tako ni dolo. ");
INSERT INTO nlg_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Ghe Lord, Ko bei ririu pulohi vaniu ta nimua na rutu, po ko torou ta nimua na rutu paraghaghada. ");
INSERT INTO nlg_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Ko righi aroviu ghe Lord, na pukuna tu labe. Mo ko kisu Lord, na pukuna na huligu te ghana tana bule. ");
INSERT INTO nlg_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Inau tu vahaghi tana toba. Mi vei vaho ke vagha na hauna ghe Lord, ge ko kisu volau? ");
INSERT INTO nlg_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Ko pulohi mai ghe Lord, mo ko vavolau. Vavolau na pukuna a nimua na dolo ke mua tughu. ");
INSERT INTO nlg_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Tana mate, ahei ke ghanaghanagho? Ma hei ke tangomana na holohabaamu tana tavughi? ");
INSERT INTO nlg_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Inau ku mua pupulu heghegu tana mate. Mana kolobu te podia na ghimegu tughu bongi; na ulungagu te podi ta nigua na tangi. ");
INSERT INTO nlg_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","A ghagua na levunimate te hughahugha potou tana dikalio; mana matagu te mua vuha righigho: na pukuna na ghaghua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Kau tona keha, ighau udolu tau gonia na dika: na pukuna a Lord te rongovia a nigua na tangi. ");
INSERT INTO nlg_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","A Lord te rongovia a nigua na kokoe; Ma Lord ke bosa tughui a nigua na kokoeliulivuti. ");
INSERT INTO nlg_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Lubatira a gaira udolu na ghagua na levunimate kara ghanaghana ruarua ma kara mataghu. Ge agaira udolu kara ririu pulohi nia na maa. ");
INSERT INTO nlg_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Inau tu mai tamua ghe Lord, nigua na God; ge ko pilupilu. Vavolau itadira tara kisua ghagua na mate. Mo ko lavi kehau. ");
INSERT INTO nlg_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Ma ge toko mua Lavi kehau ke, ma gaira kara dikalau te vagha na lion: sagiu ma kara pilepileu. Me taho siki sakai ke lavikehau. ");
INSERT INTO nlg_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Ghe Lord nigua na God, ge inau ku gonia na hahi, pe inau ku tangotangodika taonia te mua maemane. ");
INSERT INTO nlg_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Ma ge inau ku peroa a kulagu, puku peroa na ghagua na levunimate: sagauvia na goniana na hava ke kale. ");
INSERT INTO nlg_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Kakeri vaho ge ko lubatira na ghagua na levunimate, ge kara lotiu. Lubatira ge kara turi pepeleu tana pari. Lubatira nigua na haba ge ke lelebo tana pughu ni pari. ");
INSERT INTO nlg_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Tapatughuru ghe Lord tana rutu! Tughuru dato mo ko pungisia na rutu para ghaghada itadira na ghagua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Vahikolura na lei kema i naghomu. Sopou tana malei kabumu te datogha i vuvungadira soko. ");
INSERT INTO nlg_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Ma Lord ke tuvalia na dete ivuvungadira na lei kema. Bosa ladaa inau tu maemane ghe Lord; Na pukuna inau tu tatavahale, ghe na puku ni haba. ");
INSERT INTO nlg_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Sokolaghinia na dikadira rana dika, mo ko hangara udolu ara hei tara taonigho. Na pukuna ighoe to vaevane halahau tana lio mana taba ghe God ni maemane. ");
INSERT INTO nlg_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","God nigua na tako, to vavolara nia arahei na tobadira te utuni me maemane. ");
INSERT INTO nlg_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","God, agaia na dete te maemane me uto. Ma gaia te rutu vanira tara tangotangodika tughu bongi. ");
INSERT INTO nlg_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Ma ge na tinoni ke mua tughulio, God ke sava nia na isi, ma gaia ke lohia nina na baghe. ");
INSERT INTO nlg_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ma gaia ke gonidilai nina lei totobo ni vei totoghoni ni mate kasila. Ma nina kuali te ruruhu ke kalegho nia. ");
INSERT INTO nlg_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Rana tangotangodika tara loghoa na dika; a gaira tara nia bahe na lei vahola; mara vahui na lei sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","A gaira tara ghelighi na taripiti, ge kara taripitira na balu, ma kara kutu haghe va itadira. ");
INSERT INTO nlg_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","A gaira tara gonia na dika; hauva me labu olira so na lake. Mara gonia na padalaghi ni haurakeadira na balu, me kutu oli so tana uludira. ");
INSERT INTO nlg_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Mi nau ku holoutoa Lord: Na pukuna gaia na maemane: mi nau ku linge holohaba vania na ahana Lord te haba ngangata. ");
INSERT INTO nlg_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ghe Lord, nimami na Lord, puku ni maana, na ahamu te vonughia na maramana! Mana lada mu te haba dato vulea na parako. ");
INSERT INTO nlg_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ighoe to taraira na lei gari pile, mana lei meomeo, ge kara bosai puku ni holohaba. Ma gaira kara talu betora ghamua na levunimate, tara kenea na lavitughuamu/toroamu. ");
INSERT INTO nlg_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Mi tana bona inau tu reitada tana parako te bongi, ge ku righia na lutu ni gigirimu-tana vula mana lei veitughu tana sopa malani to talui ga. ");
INSERT INTO nlg_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Na hava vaho tua na mete vaghana to ghanaghana dilaa vanighai tai huli vinahi te manana ge ko righitaonighai? ");
INSERT INTO nlg_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Na pukuna ighoe to gonighai pile kikia vamua isarana God, mo pitiulumami nia na lada mana rongoragha. ");
INSERT INTO nlg_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ighoe to talughai ge kai righitaonighi na lei totobo to gonighi, mo vaheghai na maana vulera na lei totobo soko. ");
INSERT INTO nlg_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Na sheep mana buluka, maia ghua na lei bolo matamata. ");
INSERT INTO nlg_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Na manu tana oka, mana igha tana tahi, mana lei totobo vola tara olo’olo kolili tana harara oka. ");
INSERT INTO nlg_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Ghe Lord, nimami na Lord puku ni maana, na ahamu te vonughia na maramana! ");
INSERT INTO nlg_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Inau ku holoutogho, Lord, na na tobagu udolu; mi nau ku bosa tatei na lei totobo te haeharegha to gonighi. ");
INSERT INTO nlg_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Mi nau ke vonughiu na togo na pukuna ighoe. Mu ku linge holohaba vania na ahamu, aghe na Puku ni Haba. ");
INSERT INTO nlg_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Na ghagua na levunimate kara ririu keha ma kara tona keha; na pukuna gaira tara laga vulera, mara havukaghinira i naghomu. ");
INSERT INTO nlg_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Na pukuna ighoe to dete maemane ta nigua na levu; mi tana malei kabumu, ighoe to nia hevei na dete kaekage. ");
INSERT INTO nlg_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ighoe to tughuru pungisira na lei kema me havukaghinira na tangohahi; mo ghuduri kehai na ahadira ke va me vaa. ");
INSERT INTO nlg_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Na ghagua na levunimate tara topou nia na mateagu; hauva mana komudira te parihai. Sughua didira na vatei ghanaghana oli tara vuti kehai na lei komu tara sivi. ");
INSERT INTO nlg_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Ma nina uhuhuli Lord ke va me vaa; ma nina dete ke tona haliu tana malei kabuna. ");
INSERT INTO nlg_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Agaia ke detea na maramana nia na maemane; me ke uhulira na lei kema taonia na hava te kaekage. ");
INSERT INTO nlg_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ma Lord ke ungaunga vanira ara hei tara uhulira nia na vahaghitaili, agaia na ungaunga tana bona ni aho ni vahola. ");
INSERT INTO nlg_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Agaira ara hei tara ghilala na ahamu mara taluutunigho ighoe, a Lord, ko mua tangomana ge ko tona keha itatana siki sakai te kene taonigho. ");
INSERT INTO nlg_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Linge holohaba vania Lord ilokana Jerusalem. Bosa vania na maramana te mua nia ponolio na hava te gonia. ");
INSERT INTO nlg_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ma gaia te vahea na vahaghitailia ahei te mate tinoni, me righitaonira tara bona. Me mua nira ponolio ara hei tara ngangaraha vania nia na hahanga. ");
INSERT INTO nlg_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Lord, ko aroviu. Righia ivei te vagha tu nea na vahaghitaili tana limadira ara hei tara kanahaghiniu. Ko lavikehau tana mate Lord. ");
INSERT INTO nlg_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Ko vavolau, ge ke tangomana na holohabaamu tana mavitu, tana mataulana Jerusalem, ge ku togotogo na pukuna ighoe to vavolau. ");
INSERT INTO nlg_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Na lei kema tara kutu horu ilokani na lei gilu tara ghelighi vanira rana keha. Ma gaira tara hogho oli heghedira ta didira na vugho. ");
INSERT INTO nlg_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Ma Lord te ghilala tua nina na maemane. Marana tangohahi tara hogho heghedira ta didira na tangohahi. ");
INSERT INTO nlg_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Rana tangohahi kara tona horu tana gilu ni mate. Aeni gaia na kakalena vanira na lei kema tara mua ghilala God. ");
INSERT INTO nlg_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Ma gaira tara lio ni hahanga kara mua ghoi nira ponolio tua ke va me va. Ma didira na ghanaghanadila rana bona kara mua ghoi sonikeha. ");
INSERT INTO nlg_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Tughuru dato age Lord! Mo ko bei lubatira na lei tinoni tara mua liona na taoniamu! Mo ko lubatira na lei kema ge kara dete ta nimua na kinakabu. ");
INSERT INTO nlg_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Ko nera ge kara nia ribe na mataghu, age Lord. Lubatira ge kara ghilala agaira na tinoni gogoni vamua. ");
INSERT INTO nlg_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Aghe, Lord, e ghua ge o sakai tughuru saghau? Me ghua ge o polo tana bona inau tu liomu ngangata? ");
INSERT INTO nlg_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Na vure talu nagho mana tangohahi tara liona ge kara vunaghidira ma kara dikalara na bona. Lubatira ge kara hogho tana dika tara gonidila vanira rana keha. ");
INSERT INTO nlg_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ma gaira tara talutatei mai didira na lei lio dika; mara holoutora tara lologho au. Mara holoa mai na dika ivuvungana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Na vure tangohahi raini ke, tara nia talunagho ngangata na kene tana God. Na pukuna didira na ghanaghana gaira ke, ma God te mate. ");
INSERT INTO nlg_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","A gaira tara tangomana tana lei totobo tara gonighi. Mara mua righia nimua na totoro te pitu dilara tua. Mara kialaghi, talutatea didira na batobato ivuvungadira na ghadira na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Gaira tara bosa vanira heghedira mara ghaghua, “Taho siki totobo ke dika ke kaleghita! Ighita ka tatavahale tana lei vahola ke va me va. ");
INSERT INTO nlg_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Na mangadira te vonughia na dika, sorisori mana bosa dikala ara hei. Na vahola mana dika te sopou tana kouni na lapidira. ");
INSERT INTO nlg_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","A gaira tara koli polo tana pungi ighobuni na lei vale, ge kara labura ga na lei tinoni mahebo tana bona kara mai tona haliu. Na lutudira haia na keneadira na balu tinoni mahebo ge kara vahaghitailira. ");
INSERT INTO nlg_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Vaghara na lei lion tara tao beto pitura na lei tinoni mahebo ge kara soghavira. Vagha ghua na lei tinoni tara hili ge kara tana vugho. ");
INSERT INTO nlg_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Na lei tinoni mahebo tara mate tua tana bona tara labura mara parikuvira: agaira tara kutu horu i sarana na lagadira na lei tinoni tangohahi. ");
INSERT INTO nlg_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Na lei tinoni tangohahi tara bosa heghedira mara nigua God ke mua tangomana na vaovatogha! Me ke mua ghoi tangomana ghua na ghilalaana. ");
INSERT INTO nlg_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Tughuru dato, Aghe Lord! Mo ko torora rana tangohahi, “Aghe God!” mo ko bei nira ponolio na lei tinoni mahebo. ");
INSERT INTO nlg_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","E ghua ge na lei tinoni tangohahi tara tona keha nia na bosa dikalaana God? Ivei tara nea na ghanaghanaana, “God ke mua ghoi tangomana na holoada tana ghanaghana eni? ");
INSERT INTO nlg_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Mo ko righia na vahola mana vahaghitaili tara gonia. Ko righi kalea eni, mo ko torora. Mana lei tinoni mahebo tara talua didira na ghanaghana kodo itamua. Mi ghoe didira na pilupilu na lei meomeo. ");
INSERT INTO nlg_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ko gotighi na limadira rana tangohahi ini, na vure dika! Ko tumurira, kokoekobe na sosoko itadira ko havukaghinia! ");
INSERT INTO nlg_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Ma Lord Ke vunaghi ke va me va! Lubatira ra hei tara holohabai na lei God Keha ge kara tona keha tana pari. ");
INSERT INTO nlg_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Lord, Ighoe to ghilalai didira na ghanaghana dila rana tinoni bona. E utuni Ighoe ko tangomana na rongoviani didira na tangi mo ko togholuvura. ");
INSERT INTO nlg_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Ighoe to lavia vanira na maemane rana lei meomeo mate sasani, mana vahaghitaili tona haliu vanira rana tangohahi: ge na lei tinoni ke mua hau ma kara mua mataghunira. ");
INSERT INTO nlg_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Inau tu talua nigua na ghanaghana ni pilupilu itatana Lord. Na pukuna keri, e ghua ge o bosa vaniu, “Ko tona tana lei ghotu na va polopolo iga! ");
INSERT INTO nlg_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Rana tangohahi tara lohighi didira na baghe mara talui didira na kuali tana nilohi. Ma gaira tara vania va tana ungaungadira ara hei tara gonia na uto. ");
INSERT INTO nlg_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Na banatana na vetena mana arelavaghi te parihai. Mana hava kara nea rana maemane? ");
INSERT INTO nlg_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Ma Lord te ghaha tana valena te Tabu; ma Lord te tona haliu so na huhuli ikokou. Ma gaia te vatogha dutuvighi so na lei totobo me tabotaboa sopasopa sakai tana maramana. ");
INSERT INTO nlg_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Ma Lord te tabotabora rana maemane maia rana tangohahi. Ma gaia te nira sika arahei tara dolovia na dika. ");
INSERT INTO nlg_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Agaia te kovala horua inaghodira te ruruhu ivuvungadira rana tangohahi, me vahaghitailira nia na lake te ruruhu mana ruruhuni na lei ghuri. ");
INSERT INTO nlg_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Na pukuna Lord te maemane; Keri ge agaia te dolovia na maemane. Agaira arahei tara gonia na maemane, kara righia na matana. ");
INSERT INTO nlg_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Ko hahanga, Age Lord, na pukuna rana lei tinoni uto te nina ngangata na taghadira! Ma gaira tara ghalabutete tara tona keha tua tana maramana. ");
INSERT INTO nlg_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","A gaira na komukolu tara sopa koli vania sopasopa sakai tadira, mara nia kokoe na ghidu te uto mana toba te ghanaghana ruarua. ");
INSERT INTO nlg_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Lubatia a Lord ke lavia vanira mai na ghanaghana mava ke sara tana sosokona; ma kara nia kabu vaovarongo didira na talu nagho tana lapidira. ");
INSERT INTO nlg_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Ma gaira tara ghaghua, “Ighai kai nia koli tana tobamami na hava tai ghanaghana. Na ghidumami ke, a nimami heghemami, ma hei ke tangomana ge ke va betoghau? ");
INSERT INTO nlg_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Ma Lord te bosa tughu, me ghaghua, “Inau tu righia na vahaghitaili, tau nea vanira tara mahebora, mu tu rongovia didira na vahaghitaili rana bona. Mi taeni inau ku tughuru dato ge ku lavi kehara, te vagha te daro ni bona tua tara liogu ge ku nea vanira. ");
INSERT INTO nlg_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","A nina na baubahu Lord te marabu, vagha na silver to kerea tana lake me va marabu e vitu na tughuru ni marabu. ");
INSERT INTO nlg_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Vagha keri, Lord, Ighai tai ghilala, ighoe to pilupungisira nia tana dika, mo talugonira ke va me va tana vavata sorisori eni. ");
INSERT INTO nlg_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Vagha keri rana hahi tara holohaba na dika ilokana na komu udolu. ");
INSERT INTO nlg_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Aghe Lord, ivei vaho ke vagha na hauna ko niu ponolio? Ke va me va? Mi vei vaho ke vagha na hauna ge ko reirei va tana balu halautu? ");
INSERT INTO nlg_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Mi vei vaho ke vagha na hauna ku ghutu vevehea na vahaghitaili tana tarungagu, mi tana dikalio tana tobagu tughu bongi? Mi vei vaho ke vagha na hauna ge na ghagua na levunimate kara talu datoi na limadira? ");
INSERT INTO nlg_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Ko ririu mai mo ko bosa tughu, Aghe Lord, nigua na God! Talugonia na marara mai tana matagu, na pukuna ge ku bei mate gea. ");
INSERT INTO nlg_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Bei lubatira na ghagua na levunimate ge kara batobatou, ma kara ghaghua, “Ighai tai laga vulea gaia!” Mo ko bei lubatira ge kara togotogo tagua na kutu horu. ");
INSERT INTO nlg_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Mi nau tu varava ngasi so ta nimua na dolo ke mua tughu. Mu ku nia togotogo na pukuna to lavi kehau. ");
INSERT INTO nlg_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Inau ku linge vania Lord, na pukuna gaia te uto vaniu inau. ");
INSERT INTO nlg_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Na vure bule tara bosa tana tobadira; “E taho siki God.” Gaira tara vatei sikagha, na nilabudira te dika; me taho ahei itadira ke gehegehe uto! ");
INSERT INTO nlg_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Ma Lord te rei horu mai kokou tana vuvungadira na lei tinoni; gaia te rei mai ge ke righia siki sakai ke loghoa na puku ni manaha, siki sakai te kene taonia God. ");
INSERT INTO nlg_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Hau va me taho, gaira udolu tara ririu keha sania God; Gaira udolu tara vuha dika. Taho ahei tadira ke gehegehe uto! ");
INSERT INTO nlg_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Ivei tea gaira tara gehegehe dika tara mua naunau? Gaira tara goni sokora nigua na vure vaghaa na vanga; ara mua tangomana na kokoeliulivuti va ta God. ");
INSERT INTO nlg_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Na mataghu sule te loti ngasilira, ma God itadira rahei tara goni taonia na liona. ");
INSERT INTO nlg_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Rana tangotangodika kara soni kehai didira na ghanaghana ma kara talu horura nia na ghighirou, hau va ma Lord ke pilupilura nina vure. ");
INSERT INTO nlg_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Na vola kasila keri ke rughuhoru mai tana ghotu Zion ge ke vavolaa nia Israel! Mi tana bona a Lord ke talugoni olira nina vure, a Jacob ke nia ghu na togotogo, ma Israel ke rivurivu. ");
INSERT INTO nlg_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Lord, Ahei ke kokoeliulivuti kikinima ta valemu? Ahei ke haghe gatu itamua ta nimua na ghotu te tabu? ");
INSERT INTO nlg_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Gaira tara uhulia na nilabu te uto mara gonighi na lei gehegehe uto haia, mara nia kokoe na utuni tana toba maghora. ");
INSERT INTO nlg_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Gaira tara mua liona ge kara dikalara na lei tinoni nia na sori, pa kara vahaghitailira na lei kuladira. ");
INSERT INTO nlg_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Gaira tara hughulevu mara nira sika rana tangohahi, mara nira kikinima tara taluutuni utunia mara taonia Lord, mara righitaonighi didira na baubahu, sakai vamua te vahaghitaili. ");
INSERT INTO nlg_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Gaira tara mua nongia na rongo au ivuvungana didira na rongo tara nia hevei, mara mua liona me ke taonia na taba itatana na tinoni te kabu maemane, gaira tara gehetighi raini kara tughuru ngasi haia. ");
INSERT INTO nlg_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Ko righitaoniu tana lei totobo dika ke bei kaleu, ghe God, inau tu varava itamua ge ko pilupungisiu. ");
INSERT INTO nlg_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Inau tu bosa vania va Lord, “Ighoe nigua na God! Na lei totobo uto tu loghoi tara butu mai tamua.” ");
INSERT INTO nlg_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Gaira tara kabu tabu tana maramana itadira te ghanaa nigua na ghanaghana ge ku kabu kolura! ");
INSERT INTO nlg_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Gaira tara mina samataonighi na lei God keha ke vonughira na dikalio. Inau ku mua tangomana ge ku hahanga ta didira na sukaghi, mu ku mua tangomana na kikinima vaniadira. ");
INSERT INTO nlg_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Lord, itamua heghemu vamua na lei totobo tu loghoi, maia nigua na seu ni vauto. Mo righitaonighi nigua na lei totobo. ");
INSERT INTO nlg_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Na pari to vaheu te togotogogha. Ivei vaho te vaghaa na utona nigua na lologho iga. ");
INSERT INTO nlg_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Inau ku holoutoa Lord na pukuna te uhuliu mi tana bongi ghua na tobagu te taraiu. ");
INSERT INTO nlg_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Inau tu ghilalaa a Lord te kabu haia itagua. Ku tangomana na aleale, na pukuna gaia tana lilighigu. ");
INSERT INTO nlg_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Ku mua nia hava na tobagu te vonughia na togotogo mana rivurivu, mana mangagu te nia ghu na holohabaana. Na huligu te aheahe tana mabo. ");
INSERT INTO nlg_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Na pukuna ko mua tangomana ge ko sania na tarungagu itadira tara mate, mo ko mua lubatia a nimua na puku ni tinoni lutu tabu ke sele tana gilu ni mate. ");
INSERT INTO nlg_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ighoe ko tuhua vaniu na halautu te huliu va tana vola, me ke ghaha koluu ke me ke vonughiu haia na togotogo, mana na rivurivu haia kasila. ");
INSERT INTO nlg_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Ghe Lord, Ko rongovia nigua na nongi ni hahanga (ni kabu maemane). Varongohia mai nigua na tangi ni hahanga. Ko bosa tughua nigua na kokoeliulivuti te mai tana toba te mua kiko. ");
INSERT INTO nlg_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ko tughunitateu tu kabu maemane, ighoe to ghilalara rahei tara gehegehe uto. ");
INSERT INTO nlg_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ighoe to tabotaboa na liogu mo righia na tobagu te bongi. Ighoe to kene ngangatau mo mua topoa siki hahi. Na pukuna inau tu ghanaghana ge ku gei nia palugha gea na hava tu bosaa. ");
INSERT INTO nlg_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Inau tu taonighi tua nimua na lei vetena, tara righitaoniu ge ku bei taonira gea na vure tara ghighirou mara dika. ");
INSERT INTO nlg_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Inau tu sakutua tana halautumu; inau tu mua turipadi na taoniamu. ");
INSERT INTO nlg_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Inau tu kokoeliulivuti vanigho gatu na pukuna inau tu ghilalaa ko bosatughu, ghe God. Ko taoraghi horu mai mo ko vaovarongo tana bona ku kokoeliulivuti. ");
INSERT INTO nlg_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ko tughunia vaniu nimua na dolo te mua soko tana lei halautu te haeharegha. Ighoe to vavolara nia na lagamu tana ghadira na levunimate rahei tara kabu itamua. ");
INSERT INTO nlg_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ko righitaoniu mo ko pilupiluu vaghaa na loka ni matamu. Ko polou tana ungaungana na ghatamu. ");
INSERT INTO nlg_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Pilupiluu itadira na vure dika tara gunaliu mara vahaghitailiu, itadira na levunimate tara liona na mateagu mara talighutiu. ");
INSERT INTO nlg_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Gaira tara mua loghoa na veiarovi. Rongovia va didira na kokoe talunagho. ");
INSERT INTO nlg_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Gaira tara samataoniu mara talighutiu, mara sonihoruu tana pari. ");
INSERT INTO nlg_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","E vaghara na lion te vitolo, ra liona ge kara pilepilea na huligu; vaghara na lei dalei ni lion tara polopitu ta didira na vatei polo. ");
INSERT INTO nlg_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Ko tughuru, Ghe Lord! Hughutira mo ko lagavulera na ghagua na levunimate! Vavolau nia nimua na isi itadira tara dika. ");
INSERT INTO nlg_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Vavolau nia na limamu te maana, Ghe Lord, itadira tara liona ge kara loghoi na lei totobo ni maramana. Ko torora nia na vahaghitaili to gonidilaa vanira; Ko nea na dete mana totoro ke tona haliu itadira na lei daledira mana kukuadira. ");
INSERT INTO nlg_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Na pukuna inau tu mua gonia siki hahi, inau tu mua gonia siki hahi, inau ku righigho. Tana bona ku rarai mu ku tughuru ke vonughiu na togo, na pukuna ku righia na matamu. ");
INSERT INTO nlg_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Inau tu dolovigho, Lord; Ighoe a nigua na pilupilu. ");
INSERT INTO nlg_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","A Lord, nigua na vatu ngasi, nigua na bona ni polo, ma nigua na vavola; nigua na God a nigua na vatu, itatana tu topoa na pilupilu. Gaia nigua na tako, te pilupiluu me righitaoniu. ");
INSERT INTO nlg_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Inau tu holoa va Lord, te manana na holohaba, na pukuna gaia te vavolau itadira na ghagua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Na alo ni mate te utu talighutiu; mana tave ni tataghalaghi te ghoghoro i vuvungagu. ");
INSERT INTO nlg_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Na sosodo ni mate te talighutiu; mana ghilu ni mate te talua vaniu na taripiti. ");
INSERT INTO nlg_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Hauva ta nigua na vahaghitaili inau tu tangi vania va Lord, Eo, inau tu kokoeliulivuti vania va nigua na God ge ke hangau. Gaia te rongoviu mai tana bonana te tabu; nigua na tangi te saravia na kulina. ");
INSERT INTO nlg_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Vaho na maramana te anu me kahikahi; na panatani na lei ghotu tara aleale; ara anuanu na pukuna nina rutu God. ");
INSERT INTO nlg_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Na ahu te rughuhoru mai tana ihuna; na lapilapi ni lake mamataghugha te tataghalaghi te sosogha horu mai tana mangana; mana gougovu te bera me vavu te rughuhoru mai tatana. ");
INSERT INTO nlg_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Gaia te hangavia na kokou me horu mai; na pui tana sara ni marevona. ");
INSERT INTO nlg_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Gaia te haehaghe vuvungana na Cherubim, me lovo dato tana vuvungana na parako nia na ghata ni ghuri. ");
INSERT INTO nlg_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Gaia te poroa heghena nia na pui, na pui ni uha te pa ku te talighutia. ");
INSERT INTO nlg_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Na mararana gaia te tona potaa na pui, me dudura horu mai na lei gougovu ghala. ");
INSERT INTO nlg_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Vaho a Lord te kokoe horu mai kokou vagha na viviha; na talama ni mangana te haba vule tara rongovia. ");
INSERT INTO nlg_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Gaia te nighi rana lei nina kuali me havukaghinira na ghana levunimate; me nia vetena vania na viti mara hughuhughu poto. ");
INSERT INTO nlg_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Vaho ta nimua na vevetena, Ghe Lord, mi tana pogaana na ghuri ni aheahemu na horara te mamaha, mana banatana na maramana tara pipili lee. ");
INSERT INTO nlg_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Gaia te hagalo horu mai kokou me vavolau, gaia te holakeha datou tana tahi lalo. ");
INSERT INTO nlg_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Gaia te vavolau itadira na ghagua na levunimate mamata ghugha, mi tadira gaira tara niu sika mara lagavuleu. ");
INSERT INTO nlg_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Gaira tara hughutiu ge kara mateu tana bona inau tu labe, hauva ma Lord te tabe datou. ");
INSERT INTO nlg_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Gaia te uhuliu va tana bona ni kabu mahebo; Gaia te vavolau na pukuna te niu togotogo. ");
INSERT INTO nlg_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","A Lord te tabau nia nigua na lutu uto; a Lord te vuevugheu nia nigua na kabu maemane. ");
INSERT INTO nlg_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Na pukuna inau tu taonighi nina na lei vetena Lord; Inau tu mua ririu keha sania nigua na God mu ku taonia te dika. ");
INSERT INTO nlg_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Inau tu righitaoni ngangata nina vetena inaghogu, inau tu mua lugu na righitaoniani nina vetena. ");
INSERT INTO nlg_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Inau tu maemane tana matana God; inau tu mua lugu na righitaoniu heghegu tana tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","A Lord te tabau nia nigua na lutu uto; na pukuna te marabu na limagu, te marabu tana matana. ");
INSERT INTO nlg_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Lord, ighoe to utuni vanira rahei tara taluutuni utunigho; mo uto haliu vanira rahei tara maemane. ");
INSERT INTO nlg_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ghe, Lord, ighoe to marabu mo tategho vanira rahei tara marabu, ma gaira tara dika, ighoe to kanahaghinira ");
INSERT INTO nlg_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Ighoe to vavolara tara talumuri, mo vahaghitailira tara talunaghora heghedira. ");
INSERT INTO nlg_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Lord, ighoe to nia hevei mai na marara tana volagu; mo ghuru kehaa na pungi itagua. ");
INSERT INTO nlg_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ighoe to vaheu na laga ge ku vahaghitailira nia na ghagua na kana; mana maana ge ku lagavulea didira pilupungisi. ");
INSERT INTO nlg_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Ma vania God, na halautuna te maemane. Na lei nina baubahu Lord tara utuni. Gaia na tako vanira rahei tara rei va itatana ge ke pilupilura. ");
INSERT INTO nlg_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","A Lord heghena te God, God heghena dida na pilupilu. ");
INSERT INTO nlg_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Gaia na God te vaheu na laga, gaia te nea na halautugu ge tatavahale. ");
INSERT INTO nlg_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Gaia te righitaonighi na marevogu vaghaa na deer gaia te righitaoniu tana lei tetete ni ghotu. ");
INSERT INTO nlg_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Gaia te gonidilau me naunauu na kisumate, gaia te vaheu na laga ge ku nia va na baghe halo. ");
INSERT INTO nlg_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ighoe to vaheu na takona nimua na vola kasila. na lima madolomu te bereu, me nimua na lio dolo te talu suleu. ");
INSERT INTO nlg_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ighoe to goni okaa na halautuna na marevogu ge kara bei turi madali. ");
INSERT INTO nlg_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Inau tu ghurutaonira na ghagua na kana mu lotira; inau tu mua beto koekobe tu lagavulera. ");
INSERT INTO nlg_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Inau tu labu horura ge kara mua tangomana na tughuru dato; gaira tara tumu sara ni marevogu. ");
INSERT INTO nlg_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ighoe to vaheu na laga ni kisumate; gaia te vaheu na laga ge ku nia vana na baghe halo. ");
INSERT INTO nlg_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ighoe to nera ge ra ririu mara sama; inau tu taghalaghinira tara niu sika. ");
INSERT INTO nlg_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Gaira tara holoa ahei ge ke hangara. Hauva me taho ahei ke vavolara. Gaira tara ngangaraha vania Lord, hauva me mua bosa tughu vanira. ");
INSERT INTO nlg_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Nau tu pilepilera vaghaa na pughu ni pari te lovolaghinia na ghuri. Inau tu halara va tana beti vaghaa na lololo. ");
INSERT INTO nlg_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Ighoe to neu ge u lagavulera tara huru tabou, ighoe to viliu ge ku vunaghidira na lei kema; na vure tu mua ghilalara tara vuha mai kabu i sarana nigua na maana mara lutu vaniu. ");
INSERT INTO nlg_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Na vure tana kema keha tara tongaghi vaniu; Gaira tara taoni vetena tana bona tara rongovia na mangagu. ");
INSERT INTO nlg_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Gaira udolu tara sivilaghinia didira na lio malaghai; mara vuha ghebeghebe tana bona tara ghahara ga pitua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","A Lord te vola! holohabaa nigua na pilupilu! tughuniladaa nina uto mana haba God te vavolau. ");
INSERT INTO nlg_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Gaia God te vaheu na lagavule tadira na ghagua na levunimate; Gaia te laga vulera na lei kema tana rurughugu. ");
INSERT INTO nlg_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Me vavolau tadira ghagua na levunimate. Ghe Lord, ighoe to vaheu na lagavule tana ghagua na levunimate mo pilupungisiu tadira tara kanahaghiniu. ");
INSERT INTO nlg_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Me vaghaa keri, Ghe Lord, inau ku vahegho na holohaba tana ghobudira na lei kema; mi nau ku linge rivurivu va tana ahamu. ");
INSERT INTO nlg_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Ighoe to vahea na lagavule sule nimua na vunaghi; Ighoe to tatea na dolo te tona haliu vania nimua na tinoni to vilia, vania David mana vinavahuhuna ke va me va. ");
INSERT INTO nlg_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Na kokou te bosa tatea nina rongoragha Ge o. Na parako te talutatea nina lutu te haeharegha. ");
INSERT INTO nlg_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Tana tughu dani tara tona haliu na bosa tateana; mi tana lei dani te bongi tara talutatea gaia. ");
INSERT INTO nlg_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Gaira tara bosa mo ko mua rongovia na talamana na bosa; na talama ni mangadira ko mua rongovia tana parako. ");
INSERT INTO nlg_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Hauva didira na rongorongo te tonavia na maramana talighu mana bosadira tara rongovia tana kauna na maramana. Na aho te kabu ikokou tana bona God te talua ga. ");
INSERT INTO nlg_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Gaia te sogha dato mai te puipungi vaghaa na mane te vaguvagu ni sonikolu. gaia te rivurivu vaghaa na mane ni sama tautau te gonidila ni sama. ");
INSERT INTO nlg_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Gaia te dato mai tana vuivunina na parako me taonia na halautuna va tana sosokona. Taho siki totobo ke polohaghinia na paparana. ");
INSERT INTO nlg_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Nina vetena Lord te maemane, te vahe olia na vola na tarunga. Nina vetena Lord te manana ka varava ga. te manahara tara mua manaha. ");
INSERT INTO nlg_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Na lei nina vetena Lord tara uto, rahei tara taonighi tara togotogo. Nina na lei vetena Lord tara maemane, te nia hevei na manaha tana vola. ");
INSERT INTO nlg_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Nia kikinima Lord te uto, te kabu kasila. ");
INSERT INTO nlg_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Nina vetena Lord tara utuni, tara maemane haia. gaighi tara liuliugha vulea na puku ni gold, mara manilu vulea va na midua. ");
INSERT INTO nlg_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Gaira tara bosa dila vanira rahei tara rongovighi; na taba iga vanira rahei tara taonighi. ");
INSERT INTO nlg_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Ivei tea ge ku ghilalai na palu tara kabu polo tana tobagu? Ko marabuu mo ko lavikehau tana lei palu te kabu polo. ");
INSERT INTO nlg_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ko righitaoniu ghua, tana palu te liuliogha tana lio! Bei lubatira ge kara huliu ma kara vunaghigu vaho ge ku maemane mu ku tatavahale tana palu sule. ");
INSERT INTO nlg_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Ko lavipangotighi na lei bosa ni mangagu mana kokoeliulivuti vaovarongo ni tobagu, Ghe Lord, nigua na pilupilu mana huioli. ");
INSERT INTO nlg_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Tana lei bona ni gunaguna, a Lord ke rongovia mai nimua na tangi. Nina God Israel ke pilupilugho tana lei sosodo. ");
INSERT INTO nlg_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Gaia ke nia vetena vanigho mai na hahanga ta nina vale tabu, me ke vahegho mai na laga i Jerusalem. ");
INSERT INTO nlg_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Gaia ke lavipangotighi nimua na lei sukaghi me ke righitaonighi nia na liouto nimua na lei sukaghi kekere. ");
INSERT INTO nlg_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Gaia ke vahegho na hava te liona na tobamu, me ke nei nimua na lei ghanaghana ge ke tangomana. ");
INSERT INTO nlg_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Keri ge ighai kai nia ghu na rivurivu ta nimua na lagavule, ma kai nia talunagho na togotogo na holohabaana dida na God. ");
INSERT INTO nlg_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Itaeni inau tu ghilalaa a Lord te vavolaa nina vunaghi haba te siusiua nia na oil/oele. Gaia ke bosatughu vania mai kokou me ke vavolaa nia na maana sule. ");
INSERT INTO nlg_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Na balu kema tara kokoe talunaghora/taluutunira didira na lei mane ni kisumate maia didira na tinabe ni veitotoghoni, hauva mi ghita ka kokoe talunagho/taluutunia itatana Lord dida na God. ");
INSERT INTO nlg_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Na lei kema kiri kara saisari kiba ma kara tumu, hauva mi ghita ka tughuru dato ma ka tughuru ngasi. ");
INSERT INTO nlg_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Vahea va na lagavule nimami na vunaghi haba, Lord! Ko bosatughu vanighai mai tana bona kai hologho. ");
INSERT INTO nlg_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Na vunaghi haba te togo na pukuna to vahea na laga, Ghe Lord! Gaia te nia ghu na rivurivu na pukuna nimua na lagavule. ");
INSERT INTO nlg_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Ighoe to vahea na hava te liona tana tobana; ighoe to mua tabe olia na hava te nongia. ");
INSERT INTO nlg_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ighoe to vautoa nia na lologho sule. Ighoe to talua na pitiulu ni gold tana uluna. ");
INSERT INTO nlg_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Gaia te nongigho ge ko righitaonia na volana tana totobo te dika, mi ghoe to vahea na hava te nongia ge ke daro na bongi ni volana. ");
INSERT INTO nlg_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Nimua na lagavule te talu datoa tana malei haba, mo pupulua nia na lologho sule mana rongoragha. ");
INSERT INTO nlg_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Ighoe to vautoa nia nimua na lologho kasila mo vonughia nia na rivurivu ta nimua na tabu. ");
INSERT INTO nlg_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Na vunaghi haba te varava a itatana Lord, puku ni maana; Nina dolo na Puku ni Haba te mua tughu ke righitaonia ge ke bei saisarikiba. ");
INSERT INTO nlg_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ighoe ko lotira na ghamua na kana, na lima madolomu te laga ke mina lotira rahei tara nigho sika. ");
INSERT INTO nlg_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Ighoe ko taghalaghinira vaghaa na lake te vuvusi tana bona ko tughuru tate. A Lord ke taghalaghinira ta nina rutu, mana lake ke ghoi taghalaghinira. ");
INSERT INTO nlg_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ighoe ko taghalaghinira na lei daledira tana maramana; ma kara mua ghoi loghoa na vaivaridira. ");
INSERT INTO nlg_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Sakai vamua kara kobe pungisigho, didira na gehegehe kara mua nia tangomana. ");
INSERT INTO nlg_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Gaira kara ririu ma kara sama tana bona kara righia nimua na kuali ke tuhura va. ");
INSERT INTO nlg_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Ighai tai holohabagho Lord nia nimua na maana te rongoragha. Ighai tai holohabagho nia na lei totobo tangitangi mana linge tana bona tai nia togotogo nimua na gehegehe te sule. ");
INSERT INTO nlg_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Nigua na God, nigua na God! e ghua ge o tona saniu? E ghua ge o kabu sagauviu? E ghua ge o mua hangau, mo rongovi leaa nimua na tangi. ");
INSERT INTO nlg_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Nigua na God, inau tu hologho tana lei dani. hauva mo mua bosatughu. Inau tu hologho te bongi tana lei bongi mo rongovia na mangagu, hauva mua topoa na topoa na togholuvu. ");
INSERT INTO nlg_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Nina lei holohaba Israel te talighutia na malei kabumu, na pukuna ighoe to tabu. ");
INSERT INTO nlg_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Na lei kukuamami tara varava itamua; gaira tara varava itamua mo vavolara. ");
INSERT INTO nlg_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ighoe to rongovia didira na hoholo ge ko hangara mo ko vavolara. Gaira tara varava itamua ma kara mua ghoi dikalio. ");
INSERT INTO nlg_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Hauva, inau ke na kedu, u mua tinoni. gaira udolu tara mua liogu mara niu sika. ");
INSERT INTO nlg_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Gaira udolu tara righiu tara batobatou. Ra toutoui na ghidudira mara birubirui na uludira, mara ghaghua. ");
INSERT INTO nlg_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Gaia te varava itatana Lord, sania Lord ke vavolaa! Ge teke dolovi ngangataa gaia, Eghua ge mua vavolaa?” ");
INSERT INTO nlg_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Ighoe to lavihoru tatavahaleu tana kutuna tinagu, mo uhuliu ge ku varava itamua tana bona tu meomeo mua. ");
INSERT INTO nlg_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Itamua tua tu ghanau vuivuni tana bona ni vahuagu. Ighoe nigua na God mai tua vuivuni tana bona ni sivuraghaagu. ");
INSERT INTO nlg_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ko bei kabu sagauviu! Na gunaguna ililighigu, me taho siki sakai ke tangomana na hangaagu. ");
INSERT INTO nlg_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Na ghagua na kana tara talighutiu vaghara na ovu ni buluka mane; na lei buluka mane mamataghugha ni Bashan tara kililiu. ");
INSERT INTO nlg_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Vaghara na lion tara ngurunguru tara sagia na ghadira na bolo, ra ovaovai na mangadira mara mai tagua. ");
INSERT INTO nlg_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Na volagu te kaikavi vaghaa na beti, mana lei paupaguha ni huligu tara varadiu. Na dougu te vaghaa na soi kokodo ni ghai te obo tana lokagu. ");
INSERT INTO nlg_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Na sosonogu te mamaha vaghaa na pari sisi te hinari paopaoa. Na lapigu te rago dato tana mangagu. Ighoe to kolivaghiniu tana pughu ni pari mo tona saniu ge ku mate. ");
INSERT INTO nlg_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Na ghagua na kana tara utu talighutiu vaghara na ovu ni kau; na lei tinoni dika tara talighutiu. Ra suki potai na limagu mana tuagu. ");
INSERT INTO nlg_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Inau ku tangomana na idumiani na huli tana huligu. Na lei ghagua na levunimate tara pelau nia na togo. ");
INSERT INTO nlg_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Gaira tara tuvalighi lei nigua na tivi ighobudira heghedira, mara sonia na dice ta nigua na pupulu. ");
INSERT INTO nlg_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Ko bei kabu sagauviu, Ghe Lord! Ighoe nigua na laga; mina mai mo ko vavolau. ");
INSERT INTO nlg_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Ko vavolau tana ivi; ko vavolau tana lei kau raini. ");
INSERT INTO nlg_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Ko lavikehau tana mangadira na lion raini mi tana koladira na buluka asi. ");
INSERT INTO nlg_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Vaho ge ku ladavaghinia na ahamu te haeharegha vanira na lei hoghogu mana vavinegu. Inau ku holohabagho itadira na lei tinoni. ");
INSERT INTO nlg_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Kau holohabaa Lord ighau udolu tau nia kikinima! Kau nia kikinima, ighau na vinavahuhuna Jacob! Ma kau tualaghi tuturu kikinima vania, ighau na vinavahuhuna Israel! Gaia te mua nia murilio didira na vahaghitaili rana tinoni bona. Gaia te mua ririu keha me ke tona sanira. Me bosatughu vanira tana bona tara holoa ge ke hangara. ");
INSERT INTO nlg_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Inau ku holohabagho tadira na lei tinoni; inau ku goni kalea nigua na baubahu tana matadira tara nigho kikinima. ");
INSERT INTO nlg_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Rana bona kara vanga ma kara mahu. Kau holohaba Lord ighau tau kene taonia. ");
INSERT INTO nlg_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Na maramana udolu kara ghilala Lord te utuni ma kara oli va itatana. Lei tinoni tana lei kema kara tualaghi tuturu kikinima tana matana. ");
INSERT INTO nlg_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Gaa Lord te vunaghi haba! gaia te vunaghi pungisira na lei kema tana maramana. ");
INSERT INTO nlg_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Lubatira na lei tinoni lologho tana maramana kara kikinima. Lubatira na tinoni tara vahura ge kara mate, kara poghotao tana matana. ");
INSERT INTO nlg_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Na lei vavata ke mai kara lutu vania Lord. Na lei daleda kara rongovia nina lutu Lord te haeharegha. ");
INSERT INTO nlg_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","nina gehegehe maemane kara tughunitatea vanira tara mua vahura mua. gaira kara rongovighi na lei totobo te gonighi. ");
INSERT INTO nlg_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","A Lord nigua na vatogha; Inau ku mua kenea na hava te liogu. ");
INSERT INTO nlg_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Gaia te lubatiu ge ku aheahe tana buburu maumauri; me uhuliu va tana daidari ni beti maghora. ");
INSERT INTO nlg_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Gaia te vaheu na laga vaolu. Gaia te huliu tana halautu maemane, ge ku nia kikinima na ahana. ");
INSERT INTO nlg_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Sakai vamua ku liu tana pui mana ungaunga ni mate ku mua mataghu; na pukuna ighoe tana lilighigu. nimua na toghona mana tila kara pilupiluu. ");
INSERT INTO nlg_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ko gonidilaa vaniu na vanga kolu tana matadira tara kanahaghiniu. Ighoe to lavipangotiu mo dolovia na ulugu nia na oil/oele. Ma nigua na seu ke vonughia na vauto. ");
INSERT INTO nlg_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Nimua na dolo mana vauto ke saritaoniu tana lei bongi ni volagu, mi nau kabu kasila tana valena Lord. ");
INSERT INTO nlg_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Na maramana mana lei totobo soko ilokana anina Lord. Na maramana mana lei tinoni soko tara haghara iga a nina Lord. ");
INSERT INTO nlg_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Gaia te kolivaghinia na banatana na maramana tana tahi lalo, me kisua tana oka lalo, ");
INSERT INTO nlg_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Ahei ke tangomana ge ke sei dato ta nina ghotu Lord? Ahei ke tangomana na tughuru ta nina bona te tabu? ");
INSERT INTO nlg_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Gaira vamua te marabu na limadira mana tobadira. mara mua kikinima vania na titinoni mara mua gonia na baubahu sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","A Lord ke vautora me ke vavolara; God ke tughunitatera gaira tara marabu. ");
INSERT INTO nlg_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Gaira vamua kara tangomana na va righiana Lord, ma kara holohabaa nina God Jacob. ");
INSERT INTO nlg_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Hangavighi na mataula ni peo ni dania! hangavighi na mataula ni dania mai tua, lubatia na vunaghi haba ni rongoragha ke haghe. ");
INSERT INTO nlg_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Ahei na vunaghi haba ni rongoragha. A Lord te laga me haba, A Lord te lagavule tana kisumate. ");
INSERT INTO nlg_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Hangavia na mataula ni peo ni dania! Hangavia na mataula ni dania mai tua, lubatia na vunaghi haba ke haghe. ");
INSERT INTO nlg_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Ahei na vunaghi haba ni rongoragha? A Lord Puku ni Maana, Gaia na Vunaghi Halikama ni Rongoragha. ");
INSERT INTO nlg_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Itamua, Ghe Lord, ku talu datoa nigua na kokoeliulivuti. ");
INSERT INTO nlg_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Nigua na God, inau tu varava itamua! Ko bei lubatiu ge ku maa, mo ko bei lubatira na ghagua na levunimate kara nia rivurivu na lagavuleagu. ");
INSERT INTO nlg_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Gaira tara varava itamua kara mua nia ma siki totobo, gaira vamua tara nia lutu na kiko kara maa. ");
INSERT INTO nlg_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Tughunia vaniu na halautu ku liu ga, Ghe Lord; Tuhua vaniu na halautu maemane ku taonia. ");
INSERT INTO nlg_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","uhuliu nia nimua na utuni mo ko taraiu na pukuna ighoe na God to vavolau. Inau tu talua nigua na ghanaghana kodo itamua tana dani udolu. ");
INSERT INTO nlg_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Ko ghanaghanaa, Ghe Lord, nimua na dolo mana veiarovi te mua soko buto, to tatea vanira mai tua na lei vavata idania. ");
INSERT INTO nlg_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Ko talukehai na lei palugu vuivuni tana pileagu mai; taonia nimua na dolo ko ghanaghanau na pukuna ighoe to veiarovi, Ghe Lord. ");
INSERT INTO nlg_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","a Lord te uto te gonighi na lei totobo maemane me taraira tara tangohahi nia na halautuna. ");
INSERT INTO nlg_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Gaia te uhulira nia na hava e maemane tara talumuri, me taraira nia na halautuna. ");
INSERT INTO nlg_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","na lei halautuna Lord tara dolo mara utuni, vanira rahei tara righitaonia na hava te liona ta nina baubahu. ");
INSERT INTO nlg_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Na talumava vania na ahamu, “Ghe Lord, Ko talukehai na lei palugu tara subo ngangata. ");
INSERT INTO nlg_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Ahei gaira tara mataghunia Lord? Gaia ke tuhua vanira na halautu te vilia vanira. ");
INSERT INTO nlg_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Gaira kara kabu tana lei lologho sule tana lei bongidira, mana lei daledira ghua kara lologho tana komu baubahu. ");
INSERT INTO nlg_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Na tamakulani kolua Lord te kabu dila vanira rahei tara mataghunia gaia. Gaia te tatea vanira nina baubahu te talu polo dilaa. ");
INSERT INTO nlg_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Na matagu te righia haia va Lord ge ke hangau. Na pukuna gaia vamua ke tangomana na vavolaagu, ta didira na taripiti na ghagua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Ririu vaniu mai mo ko aroviu, na pukuna inau heghegu ilokana na vahaghitaili sule. ");
INSERT INTO nlg_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Na lei gunaguna tana tobagu tara subo mara dika va, Ko aroviu ta nigua na dikalio te vahaghitailiu. ");
INSERT INTO nlg_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Righighi nigua na vahaghitaili mana gunaguna, ko talukehai na lei palugu. ");
INSERT INTO nlg_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Righia na subodira na ghagua na levunimate, ra niu sika mara niu ghighirou. ");
INSERT INTO nlg_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Righitaonia na volagu mo ko vavolau; ko bei lubatiu gea ge ku maa, na pukuna inau tu varava itamua. ");
INSERT INTO nlg_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Lubatia na kabu marabu ke pilupungisiu, na pukuna inau tu talua nigua na ghanaghana dila itamua. ");
INSERT INTO nlg_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Huiolia Israel Ghe God, ta nina na lei gunaguna. ");
INSERT INTO nlg_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Ko bosa tateu tu kabu marabu, Ghe Lord, Na pukuna tu nia sakutua kolu na utuni; inau tu varava itatana Lord, ge ku mua saisarikiba. ");
INSERT INTO nlg_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Ko taluu tana dete Lord, mo ko ghilalau tabotaboi na tobagu mana liogu. ");
INSERT INTO nlg_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Na pukuna nimua na dolo haia inaghona mi nau tu sakutua haia ta nimua na utuni. ");
INSERT INTO nlg_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Inau tu mua kabu kolura na lei tinoni sorisori, mu mua nira udukolu rana kiko. ");
INSERT INTO nlg_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Nau tu nia sika didira na savukolu tara gehegehe dika, mu mua sopou kolura tara dika. ");
INSERT INTO nlg_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Nau ku sani na limagu ge ku tughunitatea tu marabu, ge ku gatu ta nimua na baubahu, Ghe Lord. ");
INSERT INTO nlg_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Ge ku linge na linge ni holouto, mu ku bosai nimua na lei lutu te haeharegha. ");
INSERT INTO nlg_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Lord, inau tu dolovia na lei hegohego ni valemu, iga teghanaa ga nimua na rongoragha. ");
INSERT INTO nlg_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ko bei lavi kolura nia tara tangotangodika na tarungagu. mana volagu ghua tara mate tinoni. ");
INSERT INTO nlg_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Na limadira te meto nia na lei padalaghi dika, mara bahura na balu ge kara gonighi na lei totobo hahi. ");
INSERT INTO nlg_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Mete vaghaa inau, inau ku gonia na hava te maemane; Ko aroviu, mo ko vavolau. ");
INSERT INTO nlg_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Na marevogu ke tughuru tana bona uto, mu ku holohabaa Lord tana mavitu. ");
INSERT INTO nlg_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Nina David A Lord nigua na marara mana vola kasila ma ge ahei ku mataghunia? A Lord ke pilupungisiu tana lei totobo maemategha. ");
INSERT INTO nlg_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Tana bona na lei tinoni dika kara mai ma kara taghalaghiniu, kara sarikiba ma kara tumu. ");
INSERT INTO nlg_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Sakai vamua na ovu ni kisumate ke talighutiu, na tobagu ke mua mataghu. Sakai vamua a kisumate ke tavurake savuu, Inau ku varava ngasi so itatana. ");
INSERT INTO nlg_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Sakai na totobo ku nongia va itatana Lord, na totobo tu kene ngangataa, ke na kabu tana valena Lord tana lei bongi ni volagu. Ku nighi togotogo na lei totobo te uto mu ku kokoeliulivuti ta nina vale tabu. ");
INSERT INTO nlg_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Gaia ke polou ngasiliu ga tana lei bona ke mai; gaia ke polou tana valena. gaia ke talu datou tana vuvungana na vatu datogha. ");
INSERT INTO nlg_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","vaho ge ku ghae datoa na ulugu, ivuvungadira na ghagua na kana tara talighutiu. Mi tana valena te tabu ku vahea va na lei sukaghi kolua na ghu ni rivurivu na nia linge kolu na keyboard na holohabaana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Ko rongovia mai nigua na kokoeliulivuti, Ghe Lord, Ko aroviu mo ko bosatughu vaniu. ");
INSERT INTO nlg_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Na tobagu te rongovigho tua to bosa, “Mai mo ko kokoe vaniu.” mana tobagu te bosatughu, “Lord inau tu mai.” ");
INSERT INTO nlg_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Ko bei pologho vaniu. ko bei sonikehaa nia na rutu nimua na tinoni ni lutu. ko bei saniu mo ko niu sika, Ghe God, nigua na vola kasila? ");
INSERT INTO nlg_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Sakai vamua koro tivau tamagu ma tinagu a Lord ke varavaghiniu va itatana. ");
INSERT INTO nlg_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Taraiu nia na halautumu, Ghe Lord, Ko uhuliu va tana halautu maomabo, na pukuna na ghagua na levunimate tara polo pituu ge kara tumulaghiniu. ");
INSERT INTO nlg_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ko bei lubatiu ge ku tumu va tana limadira, Gaira tara huruu nia na hava tu mua nei mara aheahe horu na ghighirou. ");
INSERT INTO nlg_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Hauva inau tu varava me ngasi nigua na taluutuni ge ku righia nina uto Lord tana komudira tara vola. ");
INSERT INTO nlg_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Vadangitai mo ko pitua Lord, Ko liopatu/liosakai mo ko bei mataghu. Eo, vadangitai mo ko pitua Lord. ");
INSERT INTO nlg_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Nina David Lord, ighoe nigua na vatu ni vatei tuturi, Inau ko hologho, mo ko bei hove gea na rongoviagu Na pukuna ko mua nea mua ke, mu ku vaghara tua ara hei tara kutu haghe tana gilu taho borona. ");
INSERT INTO nlg_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ko rongovia nigua na kokoeliulivuti tu nongigho ge ko hangau. Mi nau tu hau datoi na limagu vata nimua na malei tuturi tana valemu te tabu ");
INSERT INTO nlg_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Holouto Lord na pukuna te rongovia nigua nigua na tangi ge aroviu. ");
INSERT INTO nlg_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Ma Lord nigua na laga ma nigua na tako tana bona ni sosodo mu ghanaghana mavaa nia na tobagu, na pukuna ke hangau mana liogu te vonughia na togotogo mu ku holohaba nia na lei linge ni holouto. ");
INSERT INTO nlg_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Ma Lord te righi taonira nina vure, me vahera na laga vule nina na vunaghi haba. ");
INSERT INTO nlg_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Ko vavolara nimua na vure ghe Lord, ighau na lei tarunga vetena kau vahe na holouto ta nina rongoragha mana laga. ");
INSERT INTO nlg_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Nina David Kau vahea na holouto a Lord, Ighau na lei tarunga vetena. Kau vahea a Lord na holouto ta nina rongoragha mana laga. ");
INSERT INTO nlg_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Kau vahea na holouto tana ahana ta nina rongoragha, Kau holouto Lord nia na holohaba te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Na bosana Lord te talao vuvungana na tahi Ma Lord ta nina rongoragha te gonia na viviha, Ma Lord sughua te nea ge vihalia na tahi oka. ");
INSERT INTO nlg_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Na talama ni mangana Lord te laga mana rongoragha. ");
INSERT INTO nlg_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Na talama ni mangana Lord te durakei na lei ghai tara holoa nia cedar, rana cedar tara ghahai tana butonikomu Lebanon. ");
INSERT INTO nlg_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Gaia te gonighi na lei ghotu ni Lebanon ge kara sogha te vaghai na dalei buluka, ma gaia te nea na ghotu Hermon ge ke sogha te vaghai na dalei buluka na mane. ");
INSERT INTO nlg_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Na talama ni mangana Lord te vokasighi na lei vatu nia na lapilapi ni lake. ");
INSERT INTO nlg_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Na talama ni mangana Lord te anuanua na lei bona aroha me nea ghua na bona aroha i Kadesh ge anuanu. ");
INSERT INTO nlg_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Na talama ni mangana Lord te voghalaghighi na lei ghai sule me kakarai na lei leao, Mi tana Valetabu rana vure kara ngingili dato ma kara ghaghua, “Holohabaa God!” ");
INSERT INTO nlg_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Ma Lord te sopou vuvungana na maraghata, Ma Lord ke sopou vaghaa na vunaghi haba. gaia na vunaghi haba te vunaghi pungisi ke va me va. ");
INSERT INTO nlg_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Ma Lord ke nia hevei na laga vanira nina vure me ke vautora nia nina dolo. ");
INSERT INTO nlg_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Mi nau tu nigho kikinima Lord, na pukuna to ghate datou, mo mua lubatira na ghagua na levunimate ge kara laga vuleu. ");
INSERT INTO nlg_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ma Lord nigua na God, Inau tu tangi vanigho ge ko hangau, mo vuha kisu volau so. ");
INSERT INTO nlg_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Ma Lord te lavi olia na tarungagu mai i betidalo me righi tao niu so ge u mua tumu haghe ilokana. ");
INSERT INTO nlg_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Kau linge vania Lord, ighau nina tabu, Kau holoutoa na ahana te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Te mua daro ni bona nina rutu, ma nina dolo te tona haliu haia so, mana dikalio ke soko buto mana togotogo ke sivuragha tana dani vaolu. ");
INSERT INTO nlg_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Inau tu pukulaghi ni utoa mai tua keri ge u bosa mu ghaghua, ke mua ghoi laga vuleu tua siki sakai ");
INSERT INTO nlg_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ighoe Lord to uto vaniu mo pilupilu nia na ghotu, mo polo vaniu ge u mataghu. ");
INSERT INTO nlg_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Ma keri ge u hoholo ghe Lord, ge u kokoeliulivuti vanigho gatu, mu ghaghua, ");
INSERT INTO nlg_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Na hava na uto ke gonia vanigho na ghabugu tana bona ke horu i betidalo? Ke tangomana so na pughu ni pari ge ke holoutogho me ke bosaa to utuni. ");
INSERT INTO nlg_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Ko rongoviu ghe Lord, mo ko aroviu, Ighoe na hahanga vaniu. ");
INSERT INTO nlg_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","To liliua nigua na dikalio me togotogo mo tughua nigua na lio ni roku me togotogo ");
INSERT INTO nlg_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Me vagha keri ge na lei tinoni kara holohaba na ahamu ma kara bei beto gea. Ighoe nigua na Lord ma God, Inau ku holoutogho haia ke vei ma va. ");
INSERT INTO nlg_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Itamua ku talua gatu nigua na ghanaghana ghe Lord. Ku mua nigho maa gea na pukuna ighoe to maemane talau ");
INSERT INTO nlg_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ko gegevaghi kulimu mai tagua. Ighoe nigua na vatu ni ahevata Kara mua sodou ga ghaghua na levunimate. ");
INSERT INTO nlg_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Ighoe ko vatu ngasi vaniu, nigua na vatei ahevata ge ku pologa. ");
INSERT INTO nlg_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ko hola keha na vugho tara taludila ghaghua na levunimate ge kara mateu nia. Ighoe vamua nigua na pilupilu. ");
INSERT INTO nlg_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","U talua na tarungagu tana limamu, Ko hola horuu mai tana mate, Ighoe God to maemane. ");
INSERT INTO nlg_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","U mua liodira ara hei tara holohabara na lei titinoni na pukuna tu ghanaghana kodo tatana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","E sule ngangata nigua na togotogo na pukuna nimua na dolo te tona haliu so, mo righighi na lei nigua na vahola. ");
INSERT INTO nlg_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Mo mua lubatiu va tadira ghagua na levunimate mo laviu va so tana bona te tatavahale. ");
INSERT INTO nlg_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Ko aroviu, ghe Lord, na pukuna tu ghau tana vahola na matagu te kukurodo na pukuna na kolobu ni matagu, na huligu mana tarungagu tara labe. ");
INSERT INTO nlg_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","U nia tangi na dika lio, na niulugu te kukulua nigua na dika lio. ");
INSERT INTO nlg_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Ghagua na levunimate tara batobatou, ma rana ghagua kulagu na komukolu tara pasapasau, ma sughua rana kulagu tara mataghu na mai dutuviagu ");
INSERT INTO nlg_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ra righiu vaghau tu mate vagha na popo te taboha. ");
INSERT INTO nlg_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Na lei kokoe tu rongovighi tara nei vaniu me talighutiu na hava te mua uto. Ghagua na levunimate tara mua liogu, ra kenea na mateagu. ");
INSERT INTO nlg_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Lord inau tu ghanaghanagho so, Ge u bosaa. “Ighoe nigua na God.” ");
INSERT INTO nlg_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","U talua tana limana ivei ku ghoi ghaghua mai ko volau tadira tara mua liogu. ");
INSERT INTO nlg_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Lubatia nimua na veiarovi ke hinaria nimua na tinoni lutu, nia nimua na dolo ke volau ");
INSERT INTO nlg_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Lord, ko bei lubatiu ge ke vatei aroviagu, mu hologho so ge ke hangau, mo ko nera tara dika ge ke vatei aroviadira ma kara koli tana gilu vaghara na tinoni mate. ");
INSERT INTO nlg_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Na ghidudira te sori ke todore, gaira tara talunagho mara hurura na maemane ke bei bosa na hava. ");
INSERT INTO nlg_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","E sule ngangata nimua na lutu. O talu dila nimua na vauto vanira tara talu mavagho mo gonia vanira na hava tara mai tamua, mo ko vautora tana maramana eni. ");
INSERT INTO nlg_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Mo polara sarana nimua na malei righitaoni tadira tara mua liodira. ko polora sarana nimua na malei righitaoni sagauvira na manga tara hurura nia ");
INSERT INTO nlg_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Holoutoa Lord, te tatea nina dolo vaniu, te righitaoniu tara suravia na komugu. ");
INSERT INTO nlg_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Nigua na mataghu, tu ngangaraha dato vania ra pusi kehau tatana Lord Hauva mo rongoviu so nigua na tangi ni veiarovi, me bosa tughuna nigua na hoholo ni hahanga. ");
INSERT INTO nlg_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Kau dolovia Lord ighau rana maemane pile. Ma Lord ke righi taonira tara varava ngasi tatana na pukuna ara hei tara mua varava ngasi tatana ke torora. ");
INSERT INTO nlg_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Ka laga ma kau tughuru ngasi. Ighau tau talua nimiu na ghanaghana kodo tatana. ");
INSERT INTO nlg_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Ke togotogo gaia te talu kehai nina vaghivaghiliu na paluna tara talu kehai me ke mua righighi ");
INSERT INTO nlg_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Eo, ma Lord God te vautora, te mua idumi olighi didira na hahi, me kabu maemane tana volana. ");
INSERT INTO nlg_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Tana bona tu mua liona ge ku tughunitatei na palugu; u labe me dikahaghiniu ge u mua laga tana dani udolu. ");
INSERT INTO nlg_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Tana dani mana bongi na mavana na limamu te neu ga tughu na volagu, na lagagu te vogha na beti te obo keha tana bona te paraa na papara ni hiua. ");
INSERT INTO nlg_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Mana sosoko ke, ku lughuni tatei vanigho na lei palugu mu ku bei poloi gea, mu bosa vaniu heghegu, “Ku tughunitatei nigua na vaghivaghiliu vania Lord.” Mo ko talu kehai vaniu. Nigua hahi ke tara tona keha tua. ");
INSERT INTO nlg_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Keri ke, rana maemane kara tughunitatei didira na vaghivaghiliu te ghana mua na bona ni aho ge kara bei lulumu gea tana tave ni dete kasila. ");
INSERT INTO nlg_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ighoe nigua na bona ni polo, mo righi taoniu tana bona ni gunaguna. me talu koluu nia na linge ni lagavule. ");
INSERT INTO nlg_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Inau ku huligho tana halautu te uto nia na volamu, e ghaghua Lord, Ku kokoe hahanga mu ku righitaonigho ");
INSERT INTO nlg_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Ko bei vagha gea na horse pana polo pule te liona na alo tara tongoa nia na mangana ge ke taghaoa ta nina sakutua. ");
INSERT INTO nlg_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Nigua na dikalio tadira tara labe, mana dolo te talighutira tara varava tatana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Kau rivurivu ma kau togotogo talana Lord Ighau tau taonia, ma kau nia ghaeghahe dato nia na toba te marabu. ");
INSERT INTO nlg_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Lubatira na maemane kara linge nia na rivurivu vania Lord, me manana ge ka holohabaa. ");
INSERT INTO nlg_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Kau holohaba Lord nia hulu ni gita mo ko ghalevu vania nia hangavulu na ghalo ni ukalele. ");
INSERT INTO nlg_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Kau holohaba nia na linge vaolu Kau tigili utoi na ukalele nia na linge te manilu. ");
INSERT INTO nlg_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Na bosaana Lord te vonughia na utuni mana lei totobo soko te gonighi ke na pukuna ighita. ");
INSERT INTO nlg_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","E dolovia na hava maemane me uto me vonughia na maramana nia nina dolo ");
INSERT INTO nlg_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Ma Lord te bosa lee vamua, me puputu dato mai kokou, me aheahea na bosa me sivuragha mai na veitughu. ");
INSERT INTO nlg_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","E Kobe voka na tahi me talua na vovokana me vongotia na horara oka nia na horuna. ");
INSERT INTO nlg_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Na lei totobo soko tana maramana kara nia kikinima Lord, ma rahei soko ghua kara tughuru kolua gaia. ");
INSERT INTO nlg_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","E puputu na maramana tana bona kokoe E puputua nia nina arevaghi. ");
INSERT INTO nlg_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Ma Lord te taho laghinighi didira na ghanaghana dila na lei kema; me talu olighi didira na halautu ni tughuni vaghi. ");
INSERT INTO nlg_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Ma nina ghanaghana Lord te kabu ngasi talau mana hava te ghanaghana ke mua aleale. ");
INSERT INTO nlg_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Na hava na togo ia ke loghoa na lei kema nia God ke didira na Lord, na vure vilira te loghora. ");
INSERT INTO nlg_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Ma Lord te rei horu mai kokou me righira mai na lei taba ni vure soko. ");
INSERT INTO nlg_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Mi tana malei kabuna te righi horura mai ara hei tana maramana. ");
INSERT INTO nlg_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","E gonighi na tobadia, ge ghilalara na hava tara gonia. ");
INSERT INTO nlg_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Na puku ni mane vei totoghoni te loghoa na takona mana tinabena ke mua volaa na vunaghi haba, me ke mua kuvi takona hea na malaghaina. ");
INSERT INTO nlg_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Ko bei ghanaghana gea nimua na horse ni vei totoghoni ke vahegho na laga vule ma nia na lagana soko, Ke mua tangomana ge ke volagho ");
INSERT INTO nlg_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Ma Lord te ghilalara ara hei tara nia kikinima maia ara hei tara ghanaghana kodo ta nina dolo. ");
INSERT INTO nlg_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","E lavi olira mai tana mate! Me righitaonira tana bona ni vitolo ");
INSERT INTO nlg_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","tatana Lord vamua tai ghanaghana kodo ge ke vola ghai gaia heghena vamua ke hangaghai me ke kuvi takomami. ");
INSERT INTO nlg_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Itatana gaia na tobamami te rivurivu mai talumava na ahana te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Lord God/YHWH, ighita ta varavai nimua lei baubahu, keri ke lubatia nimua na dolo te talighutighita haia. ");
INSERT INTO nlg_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Inau ku holohabaa haia Lord: mu ku bosa haia na holoutoana. ");
INSERT INTO nlg_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Mi nau ku kokoe tate vania Lord: ma rahei tara mua uto kara loghoa na toba te uto. ");
INSERT INTO nlg_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Mai ma ka talu tatea nina rongoragha Lord. Ma ka taludato koukolua na ahana. ");
INSERT INTO nlg_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Inau tu kokoeliulivuti me rongoviu Lord me lavi horuu ta nigua na mataghu. ");
INSERT INTO nlg_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Ra hei tara kenea ge ke hangara kara togotogo ma kara mua loghoa na maa tana matadira. ");
INSERT INTO nlg_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Mi nau tu ngangaraha vania Lord ta nigua na vahaghitaili me rongoviu, me lubati tatavahaleu ta nigua na mataghu. ");
INSERT INTO nlg_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Ma nina tarunga vetena Lord te righitaonira arahei tara nia kikinima, ge righitaonira. ");
INSERT INTO nlg_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Taboa, mo ko righia a Lord te uto sughua ra rivurivu ara hei tara varava tatana. ");
INSERT INTO nlg_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Lubatira nina tinoni Lord kara tatea didira na ghanaghana mava ma rahei tara holohaba, kara loghoa na hava ke liodira ");
INSERT INTO nlg_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Sughua na dalei liona tara laga tara vitolo ma rahei tara varava ngasi tatana kara mua kenea na hava ke uto vanira. ");
INSERT INTO nlg_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Kau mai ghau dalegu ma kau rongoviu mu ku taraighau ma kau nia kikinima Lord. ");
INSERT INTO nlg_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Siki sakai tamiu te liona ge ke uto me ke daro na volana? ");
INSERT INTO nlg_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ko righi taonia na lapimu mo ko righi taonia ghidumu ge ke bei bosaa na kiko. ");
INSERT INTO nlg_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Na maghutu te vavola nina tinoni ni lutu: Mara hei tara taluutunia kara mua sivi. ");
INSERT INTO nlg_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Ko niu pala, Ghe Lord, itadira tara veitotoghoni koluu ko vesera ara hei tara veseu inau. ");
INSERT INTO nlg_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Ko tabe na tako mana kadu; gonidila ni vese, mo ko mai niu pala kolu. ");
INSERT INTO nlg_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Ko tabe datoa nimua na tinabe: mo ko pitudilara tara sama taoniu: bosa vania na tarungagu: Inau nimua na mana ni vola ");
INSERT INTO nlg_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Holara va tana mamahaghi mana dika ara hei tara kenea na mateagu: Ko ririu oli mo ko talura tana ma lei totoro, gaira tara nia dete kolu na mateagu ");
INSERT INTO nlg_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Lubatira vagha na gavu te ghuru kehaa: ma nina tarunga vetena Lord te tuva vokara. ");
INSERT INTO nlg_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Talana na halautudira ke pui me ke madali: ma nina Tarunga Vetena Lord ke ghuru kehara. ");
INSERT INTO nlg_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Sakai vamua tu mua goni hahia vanira siki totobo; ra talu vughogu so, sakai vamua tu mua goni hahia vanira siki totobo dika, ra gheli gilugu so ge kara mateu ga. ");
INSERT INTO nlg_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Ko lubatira na mate ribehaghi vania, maia na vugho te nia polo, ge hogho haghe heghena ga, me ke kutu haghe heghena tana ghilu te ghelia. ");
INSERT INTO nlg_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Mana tabogu ke togotogo tana Lord: me ke nia rivurivu ta nina maana ni vola. ");
INSERT INTO nlg_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Na lei huligu kara bosa: Lord hei te vaghagho ighoe, To volara tara bona tatana gaia keri te laga vulea va? Eo, tara labe mara dikalio tatana tara nea ge gonia na holaana na lei hava tara loghoi. ");
INSERT INTO nlg_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Ra hei tara huru kikou tara tughuru dato: ra pilighi mai vuvungagu na lei totobo inau tu mua pukui. ");
INSERT INTO nlg_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ra pelu olia nia na dika na hava te uto tu gonia: me gunalia na tobagu. ");
INSERT INTO nlg_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Mi tana bona tara vahaghi ke: Inau tu nira tangi, mu nira talukau, mu kokoeliulivutira so ma nigua na kokoeliulivuti te oli mai vamua itagua. ");
INSERT INTO nlg_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Mi nau tu dika lio: vaghau tu nira dika lio na hoghogu pa sakai ta nigua na binaboli, mu ulu horu, vagha siki sakai te tangihia tinana te mate. ");
INSERT INTO nlg_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Mi taeni tara togo na pukuna tu ghanau tana vahola ra savukoluu na lei tinoni mana vure keha tu mua ghilalara tara ghaeghahe mara mua beto na ghahelaghiniagu. ");
INSERT INTO nlg_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Na lei tinoni tara mua nia kikinima God tara lavi mamaagu mara girigirighi vaniu nia na livodira. ");
INSERT INTO nlg_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","vei vaho ke vagha eni Lord ge ko soni vaghini matamu mai: Ko righitaoniu tadira tara goni dila ni kanahaghi niagu. Mana volagu tu dolovia tadira na bolo ghaghala. ");
INSERT INTO nlg_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ku holoutogho inaghodira na vaukolu ni mavitu mu ku holohabagho tana ovu ni vure subo. ");
INSERT INTO nlg_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Ko bei lubatira ghagua na levunimate ge kara laga vuleu nia na kiko; ma rahei tara kanahaghiniu kara bei batobatou gea. ");
INSERT INTO nlg_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Ra mua nia kokoe na mabo: Ra kisu ghadira mate mara mamimamira nia na sori ara hei tara kabu tana komu. ");
INSERT INTO nlg_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ra vukesia na mangadira mara ghaghua, “Aha! Tai righia nia na matamami te gonia.” ");
INSERT INTO nlg_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","O righia tua eni ke Lord: ko bei todore gea mo ko bei sagauviu gea ghua ighoe nigua na Lord. ");
INSERT INTO nlg_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ko rarai mai; mo ko detedetea nigua hahi, ko lavi tughu ta nigua na hahi, Ighoe nigua na God mana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Ko talutatea tu mua hahi Lord nigua na God: Ko bei lubatira ghagua na levunimate ge kara kia haghiniu nia nigua na hahi. ");
INSERT INTO nlg_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Ko bei taladia gea ge kara bosaa tana tobadia, “Righia a lavia tua na hava ta liona tatana. Mai ma ka sonomi na volaa tana kutuda.” ");
INSERT INTO nlg_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Gaira tara togotogo na pukuna inau tu vahaghitaili, me uto vanigho ge kara maa ma ka bule mu liodira ra hei tara bosa tara uto vuleu inau Kara haba ni maa va, ma kara vaevane vesikana tana mata ni tinoni. ");
INSERT INTO nlg_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Ra hei tara liona ngangata ge ku talu tateu inau sakai na tinoni uto, kara togotogo ma kara ghaeghae dato. E uto ge kara ghaeghahe dato haia te vagha ke, God te haba vule ngangata, me ke nia togo nina tinoni ni lutu te kabu tana vola te uto. ");
INSERT INTO nlg_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Mi nau ku bosa tatea na nilabumu te maemane mi nau ku holoutogho haia tana lei dani, vuivuni tara puipungi me ke saravia na bongi. ");
INSERT INTO nlg_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Na pulu te vaevare lokana haia te tangotangodika: me rorodo na matana ge mua nia kikinima God. ");
INSERT INTO nlg_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Ra ghanaghana God ke liouto vanira so tana palu tara gonighi; Mara vaevane olia ivei te vagha na dika ia tara nei. ");
INSERT INTO nlg_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Na hava tua tara bosai nia na mangadira te dika, me vonughia na sori: ra mua liona ge kara uto ma kara gonia na totobo te maemane. ");
INSERT INTO nlg_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Na dika vamua te mai tana liona te koli te bongi tana ghimena, E talu haghea heghena tana dika, me mua nia sika na tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Lord, nimua na dolo te hagalo topoa na kokou ma nimua na utuni te saravia na parako. ");
INSERT INTO nlg_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Nimua na uto te datogha vagha na ghotu, nimua na dete te horugha vagha na horara mo volara na tinoni mana maumanu sakai na vata vamua. ");
INSERT INTO nlg_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Vei vaho te vagha na utouto na nimua na dolo eni Lord, na lei dale tinoni tara mai ungaunga sarani ghatamu. ");
INSERT INTO nlg_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Kara nighi mahu na lei vanga tana valemu mo lubatira ge kara inuvia na beti ni togotogo ");
INSERT INTO nlg_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Ighoe na vuravura ni beti ni vola: mana bulu ge kai vaevanea na marara. ");
INSERT INTO nlg_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ko kovala horua nimua na dolo i vuvungadira tara dolovigho: Ma nimua na dete itadira te marabu na tabadira. ");
INSERT INTO nlg_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Ko bei lubatia na tuadira na lei tinoni talunagho ge ku nia saisarikiba, ma rana dika kara bei pili koliliu gea. ");
INSERT INTO nlg_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Ma gaira tara tangotangodika tara kutu horu, ra soni horu va ma kara mua tangomana na ghoi tughuru dato. ");
INSERT INTO nlg_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ko bei rutu gea na pukuna rana tangotangodika: mo ko bei nira sika ahei te gonia te dika. ");
INSERT INTO nlg_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Kara malu horu vagha na buburu: Ma kara sesebe vaghara na lei tautalu maumauri. ");
INSERT INTO nlg_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Ko varava ngasi tatana Lord: Mo ko gonia na hava te uto, ko kabu tana pari tu vahegho, mo ko vola. ");
INSERT INTO nlg_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ko togotogo kolu tatana Lord: me ke vahego na hava te liona na tobamu. ");
INSERT INTO nlg_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ko talua na hava to gonia tana limana Lord: Mo ko varava ngasi tatana, ma gaia ke hangagho. ");
INSERT INTO nlg_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Ma gaia ke nea nimua na kabu maemane ge ke maghora vagha na ghama ni labota marara ni dani kama. ");
INSERT INTO nlg_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Kai kabu beto i naghona Lord: Ko pitu tatavahalea ta nina bosa ni arevaghi: bei ghanaghanara ra hei tara dika, ra liona ge kara nia tangomana. ");
INSERT INTO nlg_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Betoa nimua na rutu, ko ririu oli tana hava to gonia: bei lio dika vanira rana keha: Ke huligho va gea tana halautu te dika. ");
INSERT INTO nlg_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Rana tangotangodika kara taghalaghi nira: Mara hei tara nia kikinima God, Kara loghoa na pari ni tumu va. ");
INSERT INTO nlg_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Mi tana pile bona, gaia na tangotangodika ke tagha haliua, ko kenea manaa, ma kara tagha haliura tua. ");
INSERT INTO nlg_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Ma hei vamua te kabu totovongona ke loghoa na pari ni tunuva, me ke nia togo na mabo iga. ");
INSERT INTO nlg_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Gaia te tangohahi te kenea na dikalana ahei te gehegehe uto, me girigirighi na livona vania ");
INSERT INTO nlg_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Ma Lord te kia vamua, na pukuna te righia na bongidira te dutu ni sara mai tua ge ke taghalaghinira. ");
INSERT INTO nlg_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Rana tangotangodika tara suai dida na isi, mara lohighi dida na baghe ge kara labura nia tara bona mara kosimogo ma kara matera ara hei tara lutu maemane ");
INSERT INTO nlg_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Dida na isi ke sutu potai na lokadira, ma dida na baghe ke tagoti. ");
INSERT INTO nlg_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Me uto va nina lologho pile na tinoni uto tatana nina lologho au na tinoni tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Na pukuna a Lord ke hola kehai na lagadira tara tangotangodika, me ke righi taonira tara lutu uto. ");
INSERT INTO nlg_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Ma Lord ke righitaonira ara hei tara gehegehe uto ma kara holaa na taba te kabu kasila. ");
INSERT INTO nlg_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Kara mua vahaghitaili tana bona ni bongi dika sughua tana bongi ni vitolo kara loghoa so na hava te manadira. ");
INSERT INTO nlg_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Rana tangotangodika kara mate, mana ghana na levunimate na Lord, Kara dudu vaghara na buburu. ");
INSERT INTO nlg_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Rana tangotangodika tara hola kau mara mua tutughu oli, na tinoni uto te vei arovi me hevei nia na lio te maemane. ");
INSERT INTO nlg_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","gaira te vautora na Lord Kara loghoa na bona kara sopou ga. Mara hei ke varangara kara ghuru horura. ");
INSERT INTO nlg_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Ma Lord te uhulia, na sakutuana na tinoni ivei ke va iga me righitaonira ara hei tara holopangotiana na Ahana. ");
INSERT INTO nlg_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Kara saisari keba ke, ma kara mua tumu na pukuna Lord ke tabe daroa nia so na limana. ");
INSERT INTO nlg_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Inau tu tinoni vaolu, mu saravia tua na tonikamaagu, mu mua righi topoa mua siki tinoni uto ke righi leara na ahana aua hei pe ke mua kutira dalena kara nongi vanga. ");
INSERT INTO nlg_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Na tinoni uto te hevei nia na toba te maghora me uto, me hangara rana keha, ma dalena kara loghoa na vauto. ");
INSERT INTO nlg_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ko ririu sania na tangotangodika, mo ko gehegehe uto, mo ko kabu kasila ivei te talugho ga Lord ");
INSERT INTO nlg_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","A Lord te dolovia na uto, me mua nira ponolio ara hei tara maemane: Me righi taonira ke va me va, me ke tagha laghinira daledira tara tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Rana maemane kara loghoa na komu ni tunuva; ma kara sopou ga ke va me va. ");
INSERT INTO nlg_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Na mangana na tinoni manaha te bosaa na lei bosa manaha, mana ghiduna te bosaa na lei bosa maemane. ");
INSERT INTO nlg_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Na vetena nina God tana tobana, mana sakusaku tuana ke mua dororo. ");
INSERT INTO nlg_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Na tinoni ghighirou te toghatogha na tinoni uto me kenea ivei ke nea ge ke matea. ");
INSERT INTO nlg_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Ma Lord ke mua lubatia a hei te tangohahi ge ke laga vule, pa rana maemane kara hurura tana bona ni dete. ");
INSERT INTO nlg_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Ko pitu dila Lord, mo ko tona taonia na halautuna ke ghaedatogho me ke vahegho na bona ko sopou ga, ma rana tangohahi kara tapusi keha ka, mo ko righi kalea so. ");
INSERT INTO nlg_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Inau heghegu tu righi kalea ta nina lavi mataghu na tinoni tangohahi, E talu tatea heghena te vagha na ghai lodu ni leao. ");
INSERT INTO nlg_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Mu rei va mu mua righi sodora, sakai vamua ku kenera ke, mu ku mua sodora tua. ");
INSERT INTO nlg_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ko righia gatu na nilabuna na tinoni te maemane kolua nia na tinoni uto te loghoa na mabe tana volana, na dalena kara taonia va na nilabu te loghoa. ");
INSERT INTO nlg_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Mara hei tara gehegehe dika kara taghara udolu ma daledira tara gehegehe dika taghora tana sosoko. ");
INSERT INTO nlg_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Ma Lord ke volara tara gehegehe uto, gaia didira na vatu tana bona ni gunaguna. ");
INSERT INTO nlg_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ma Lord ke hangara me ke lavi olira tatana te gehegehedika, ke volara mi tatana vamua kara sodoa na beala ni ahevata. ");
INSERT INTO nlg_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Lord ko bei kokoe laga vaniu tana bona ko rutu: mo ko bei torou gea ta nimua na rutu papara. ");
INSERT INTO nlg_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Nimua na kuali tara vauvausuka haghe tagua: mana limamu te saro horuu nia mai so. ");
INSERT INTO nlg_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Na pukuna nimua na rutu: na huligu udolu tara vahaghi: me mua mahebo na volagu na pukuna na lei palugu ");
INSERT INTO nlg_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ma nigua na lei hahi tara saro udolua na ulugu vagha na hohola te mava na holana. ");
INSERT INTO nlg_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Na palugu tara utu mara vei sikani: na pukuna na lei palugu. ");
INSERT INTO nlg_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Inau tu rongorongo mu neu ge u tinoni toposo: mu nia ole kolili na dikalio tana dani udolu. ");
INSERT INTO nlg_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Na levugu te paralamuta: Me taho na laga ni vola tana huligu. ");
INSERT INTO nlg_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Inau tu labe mu tapele kolili: mu gutuveve na pukuna na maghae tana lokagu. ");
INSERT INTO nlg_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Lord o ghilalai na hava tu lioni, ma nigua na dikalio te mua polo itamua. ");
INSERT INTO nlg_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Na tobagu te tuputupu mana lagagu te kubolu mana reireina na matagu te taghoi ");
INSERT INTO nlg_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Rana kulagu mana ghagua udu tara tabalili keha tana vahaghiagu, ma rana kulagu na vure tara tughuru sagauviu. ");
INSERT INTO nlg_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Ra hei tara liona na hola kehana na volagu tara lohi ghagua na piti: Ma gaira tara tona olioli na kanahaghiniagu tara vavaranga mana kene ghanaghanaana na halautu ni posoagu. ");
INSERT INTO nlg_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Mi nau te vaghau na tinoni te pui me mua rongo te vagha na tinoni te laghu, te mua vukesia na mangana. ");
INSERT INTO nlg_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","E utuni, inua tu mai vuha vaghau na tinoni te mua rongo, mana mangagu te mua kokoe tughu. ");
INSERT INTO nlg_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Mi nau tu pitugho so Lord, Ighoe vamua ge ko bosa tughu vanira, Ighoe a Lord, nigua na God. ");
INSERT INTO nlg_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Inau tu liona ge rana ghagua na kana kara bei laga vuleu gea: mi tana bona ku turi padi: Kara bei lavi mamagu gea. ");
INSERT INTO nlg_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ku mua tangomana tua ge ku ghoi tughuru dato, na pukuna nigua na vahaghitaili haia tagua. ");
INSERT INTO nlg_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ku toghighi lei nigua na hahi: mu ku nighi dika lio na lei palugu. ");
INSERT INTO nlg_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Ma rana ghagua na kana kara ghahara: mara laga lee: ma gaira tara kanahaghi leau tara subo vule. ");
INSERT INTO nlg_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Gaira ghua tara nia tutugu na dika tara uto: tara hughuhughuu na pukuna Inau tu taonia te uto. ");
INSERT INTO nlg_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Ko bei sivilaghiniu: Ighoe, Lord, nigua na God, mo ko bei kabu sagauviu. ");
INSERT INTO nlg_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Ko mina, mo ko hangau: Ighoe Lord God nigua na vavola. ");
INSERT INTO nlg_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Inau tu bosa: Ku ngasilia na lei nilabugu: Mu ku bei nia palugha gea na lapigu. Inau tu betoa na mangagu: tana bona tara kabu koluu rana tangohahi. ");
INSERT INTO nlg_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Inau tu betoa na ghidugu: Mu mua bosa siki totobo: Mu kabu beto vamua: vagha ghua tana bosani na lei bosa te uto: Na pukuna te vahaghitailigha me vatei sikagha tagua ");
INSERT INTO nlg_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Na lokagu te papara: mu ghanaghana na lake te vavu: ma vaho ge u nia kokoe na lapigu. ");
INSERT INTO nlg_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Lord: Ko neu ge ku ghilalaa na sosokona na volagu: mana suboni ghua na lei bongigu: ma ge ku pukulaghini utoi ke vagha ku vola. ");
INSERT INTO nlg_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Righia, to nea na lei bongigu ke vagha vamua na darona na lima: mana lei niulugu te totobo lee vamua itamua: me utuni sughua na vola ni tinoni na ghuri lee vamua. ");
INSERT INTO nlg_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Na tinoni te ole vamua te vagha na nunu lee, me mangolia heghena nia na lutu laga: me baore aua nina sodo rongo, me mua ghilalai ahei ke loghoi. ");
INSERT INTO nlg_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Mi taeni Lord: na hava ge u ghanaghana dila: E utuni nigua na ghanaghana dila tamua. ");
INSERT INTO nlg_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ko vavolau ta nigua na lei hahi, mo ko bei lubatira tara bule ge kara kia haghiniu. ");
INSERT INTO nlg_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Inau tu vuha laghu, mu mua vukesia na mangagu, na pukuna ighoe to neu. ");
INSERT INTO nlg_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Ko lavi keha itagua nimua na tatapo ni limamu, na tatapo ni limamu te neu ge ku mua nea na hava te dika ");
INSERT INTO nlg_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Tana bona ighoe to nea na bosa ngarangara te toroa na tinoni palugha, ma au dikalai na lei totobo te dolovighi. me utuni sughua na tinoni ke na ghuri lee vamua ");
INSERT INTO nlg_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Ko rongovia nigua na kokoeliulivuti, Ghe Lord, Mo ko rongovia nigua na tangi vaniamu: mo ko bei ririu keha ta nigua na kara kolobu: na pukuna tu ghahau pile bona vamua itamua: (check meaning) na sinogho haghe mai vaghara na lei kukuagu. ");
INSERT INTO nlg_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Ko lubati pileu ghua ge ku ghoi kiakia me ke maheboa ghua na lagagu, vaho ge ku tona. ");
INSERT INTO nlg_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Inau tu pitu kikinima Lord, ge ke hangau mai me ririu vaniu mai me rongovia nigua na hoholo. ");
INSERT INTO nlg_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Me lavi horu kebau tana gilu mamata ghaghua sania na nenepa mana pari luiluki, me kabu laghinia na tuagu tana pari ngutu me are lavaghinighi na lei nigua na tonatona. ");
INSERT INTO nlg_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","E vaheu mai na linge vaolu ge ku lingea na Hymn ni vatei holohabana dida na God subo kara righia na hava te gonia ma kara nia hare ma kara talua didira na ghanaghana mava tatana Lord / Ara subo kara righia, ma kara kikinima ma kara talua didira na ghanaghana kodo itatana Lord. ");
INSERT INTO nlg_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Holoutoa na tinoni te ngasilia nina taluutuni tatana Lord: me mua liliu vania te talunagho ma rahei tara nia oli kolili na sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Ghe Lord, nigua na God, e haeharegha nimua na lei lutu to gonighi: vagha ghua nimua na ghanaghana talu togo itamami me taho hei tinoni ke vatoghara ke vaghagho. Ma ge ku talu tatea mu ku bosara ke, Kara au vulei va ku bosai. ");
INSERT INTO nlg_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","O mua nia togotogo ngangata nia na sukaghi mana hevei oli to liona vamua na hulina to gonia tua vaniu. Na lei sukaghi kakeri mana sukaghi ni palu to mua puku ni lioni. ");
INSERT INTO nlg_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Keri ge u bosa, “Inau ku mai tana lei buka na gegeregu iga, ");
INSERT INTO nlg_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","ge inau ku hui kikinagea nimua na lioliogha ghe nigua na God mu nia togo na goniana Ma nimua na vetena tana tobagu. ");
INSERT INTO nlg_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","mu bosaa ghua tua nimua na utuni maia nimua na maana ni vola. ");
INSERT INTO nlg_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Inau tu mua matapoloi nimua na veiarovi mana utuni tana vaukolu ni mavitu ");
INSERT INTO nlg_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Ko bei holaa olia nimua na veiarovi tagua, Ighoe Maghutu. Ko lubatia nimua na dolo ni veiarovi mana utuni ke pilupilu haia. ");
INSERT INTO nlg_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Na lei gunaguna te subo vulei nigua na iduidu tara talighutiu na lei porongiu ge u mua tangomana na rei tada na pukuna ra subo vulei na vuvulu ni ulugu. ");
INSERT INTO nlg_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Mara hei tara kene taonigho ke vonughira na togotogo ma rahei dolovia nimua na huioli ka gehegehe dato ma kara ghaghua, “A Lord te rongoragha.” ");
INSERT INTO nlg_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ma vaniu inau tu bona mu liona na hahanga, Ma Lord te ghanaghanau mai taeni Ighoe nigua na hahanga mana vavola Ko bei kiki ghe nigua na God. ");
INSERT INTO nlg_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Kara togotogo gaira tara dolovira tana bona A Lord ke volara tana bona ni sosodo ");
INSERT INTO nlg_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Ma Lord te righitaonira, me nera ge ra vola me nera ge ra lologho, me hola kehara tana ghadira na levunimate ");
INSERT INTO nlg_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ma Lord te kisu volara tana bona kara vahaghi me kubolui didira vahaghitaili. ");
INSERT INTO nlg_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Lord, inau tu kokoeliulivuti, ko aroviu mai, ko kisu volau na pukuna inau tu palugha tana matamu. ");
INSERT INTO nlg_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Mana ghagua na levunimate tara mua bosaa siki hava ta nigua na hahi: Ke ghua nigha ke mate ma ka nia ponolio,” ra ghaghua. ");
INSERT INTO nlg_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ra mai kaou vaghara rana kukuagu. Me hau vaso na pile ra pasapasau so mara tutugu koliliu ivei tara va iga. ");
INSERT INTO nlg_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Ra vaevane koliliu ara hei tara kanahaghiniu mara ghanaghana ivei tea na dikaagu. ");
INSERT INTO nlg_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Ke luvu lee vamua na hava te loghoa me ke mua tangomana ge ke rughu horu sania na bona te sopou ga. ");
INSERT INTO nlg_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Sughua na puku ni kulagu tu ghanaghana mavaa mu nia vanga koukolu te kanahaghiniu. ");
INSERT INTO nlg_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Lord ko aroviu, mo ko ghoi vola oliu mu ku ghoi pelu olira. ");
INSERT INTO nlg_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","U ghilala to lio uto vaniu, na pukuna to mua tuvalira ghagua na levunimate ge kara laga vuleu. ");
INSERT INTO nlg_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Na pukuna to nea na volagu ge ke mua kalea na hava te dika mo laviu va tana malamu talau. ");
INSERT INTO nlg_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Vautoa Lord, God ni Israel te kabu kasila tana lei vavata ke va ma va Amen ma Amen. ");
INSERT INTO nlg_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Te vagha na deer te liona na beti ni daidari, mu ghanaghanagho, Ighoe God, na kene taoniamu. ");
INSERT INTO nlg_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Inau tu nia mamangaha God, na God te vola E ghua nigha ku mai inau tughuru i naghona gaia? ");
INSERT INTO nlg_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Bongi mana dani, lolonga na kolobu inau tu lavia na vatei vanga. Ma gaia ghana na levunimate tara tona haliu so na huatiagu mara bosa, “Ivei gaia a nimua na God?” ");
INSERT INTO nlg_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Na tobagu te tarosi te vagha tu ghanaghana olighi na hava te ghaghua iga tana bona te padi Inau tu sakusaku tua ighobudira na vure subo tara holohaba mu ghidevira tana alaala alaala sule va tana valena God. Linge rivurivu mana nia hevei na holouto gaia na tangitangina te vagha na taba tu sule! ");
INSERT INTO nlg_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","E ghua ge o dikalio? Me ghua ge o dikalio ngangata? Inau ku talu ngasilia nigua na ghanaghana tatana God! Mu ku ghoi holoutoa so gaia nigua na God mana vavolagu ");
INSERT INTO nlg_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Nigua na dikalio itaeni te tabagu ngangata, hauva mi nau tu ghanaghana olighi so nimua na veiarovi te butu mai tana ghotu Hermon, na vuravura ni Jordan, te butu mai tana bona itatana ghotuna Mizar. ");
INSERT INTO nlg_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Inau tu rongovia na gumugumuna na tahi te vagha nimua na lualua mana unuunu tara tona vuleu inau. ");
INSERT INTO nlg_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Na pukuna na lei dani soko na Lord te mua mautu na kovala horuana mai nina dolo i vuvungagu mana pukuna na lei bongi soko inau u lingei vania na lei nina na linge, Mu kokoeliulivuti vania God gaia te vaheu na vola. ");
INSERT INTO nlg_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","“Ghe God, nigua na vatu ngasi,” tu ngangaraha “E ghua ge o nia ponolio? E ghua ge ku sakutua kolili itatana pungi, ge kara gunaliu ga na ghaghua na lei levunimate?” ");
INSERT INTO nlg_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Didira na ghanaghana ni gunaliagu te vagha ke togo potaa na volagu tana mate. A gaira tara batobato, “Ivei agaia nimua na God?” ");
INSERT INTO nlg_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","E ghua ge u lio kihi ngangata? E ghua ge o dikalio? Inau ku varavaghinia nigua na ghanaghana kodo itatana God! Inau ku ghoi holohaba so gaia nigua na God mana vavolagu! ");
INSERT INTO nlg_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Ghe God, Ko tatea vaniu na kabu marabu, mo ko pilupungisiau itadira rana lei tinoni tangohahi, Ko vavolau itadira na lei tinoni sorisori mana tangotangodika. ");
INSERT INTO nlg_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Na pukuna Ighoe nigua na God, Nigua na vatei vola itamua. Me ghua ghe o tona saniu? Me ghua ge u sakutua kolili tana pungi mi tana ungaunga ni mate, itadira tara niu ghighirou tana lei ghaghua na levunimate? ");
INSERT INTO nlg_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Mo nira vetena rughuhoru mai nimua na marara mana utuni. ma kara righitaoniu lubatira ge kara liuliu va ta nimua na ghotu tabu, va tana bonamu to ghahagho iga. ");
INSERT INTO nlg_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","I kakeri ge ku tona ta nina malei sukaghi God, Mi ga ta God te butu ni mai na rivurivu mana togotogo. Inau ku holoutogho nia na tigitigi ge God, nigua na God! ");
INSERT INTO nlg_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","E ghua ge o dikalio ngangata? Inau tu talua nigua na ghanaghana mava itatana God! Inau ku ghoi holoutoa so agaia na pukuna gaia na vavolagu mana nigua na God! ");
INSERT INTO nlg_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Ghe God, Ighai tai rongovighi nia tua na lei kulimami te vagha tara bosai vanighai na lei kukuamami tana hava to gonia itatana balu bongi te padi tana tualani mai. ");
INSERT INTO nlg_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Te vagha to nira ga na ghuru horua dira rana voo tana lei sopa kemadira mo vahera na pari rana lei kukuamami Ighoe to vahaghitailira ta ghadira na levunimate, mo nira na lei kukuamami mara tatavahale. ");
INSERT INTO nlg_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","A gaira tara mua manangi vulea na pari nia didira na isi Me mua didira na laga heghedira te nera ge ra nia laga vule. Hauva ma nimua na puku ni maana ge ra nia tangomana. nia na pukuna to lio uto vanira mo tatea nimua na dolo itadira. ");
INSERT INTO nlg_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ighoe nigua na God mana vunaghigu. mo vahera na laga vule vanira nimua na vure. ");
INSERT INTO nlg_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","nimua na maana oli vamua ghe ighai tai turi bitara na ghamami na levunimate. itatana ahamu oli heghemu vamua ge kai turi bitara ghamami na kana ");
INSERT INTO nlg_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Nigua na baghe heghegu tu mua taluutunia. Inau tu mua idumia siki nigua na isi ge ke vavolau ");
INSERT INTO nlg_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Ighoe to vaheghai mai na laga vule itadira na ghamami na levunimate. Mi ghoe to nira ge ra kubolu horu gaira tara nighai sika. ");
INSERT INTO nlg_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Tana lei dani soko ge God, Ighai kai holohabagho ma kai holoutoana ahamu kasila. ");
INSERT INTO nlg_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Mi taeni ighoe to kabu sagauvighai. Mo mua ghoi ghidevira nimami na ovu ni vure ni sura tana veitotoghoni ");
INSERT INTO nlg_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ighoe to nighami ge ai sama pulohi itadira ghamami na levu i mate me talana vanira ge kara dikalai nimami na lei hegohego tana pari. ");
INSERT INTO nlg_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ighoe to tangomanaghai te vagha na sheep te gonidila ge kara pusia. mi ghoe to neghai ghai havukaghi kolili tana lei sopa kema ");
INSERT INTO nlg_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","To nighai hunulu, ighai nimura na lei vure uto tana malumu. Mo nighai ghai taho vaho tua ta nimami na lei sopa uto itamami. ");
INSERT INTO nlg_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ighoe to neghai ge ra batobatoghai na lei ghamami na komu kolu. Ighai tara kiakia kiahaghinighai mara mua liomami, mana lei kema soko tara kililighai tara batobatoghai mara koengeleghai. ");
INSERT INTO nlg_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ighoe to neghai ge ra batobato ghai na lei tinoni; Ighai tara bosa batobatoghai na maramana udolu. ");
INSERT INTO nlg_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ighita udolu ka mua tangomana ge ka sogha poloa nina lio ni talumuri mana kikinima; na maa tara gegere pungisighi nia na lei matamami. ");
INSERT INTO nlg_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Na hava vamua tai rongovia na koepasa itadira tara nighai ghighirou. ");
INSERT INTO nlg_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Ma raeni soko te kale tua me hauva ma mua nigho ponolio, Ighai tai mua diudiua nimua na vetena. ");
INSERT INTO nlg_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Na lei tobamami tara mua tona sanigho. Ighai tai mua sivi tana halautumu. ");
INSERT INTO nlg_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Hauva mi ghoe to neghai ge ai vahaghitaili mai tona sanigho. Mi ghoe to kuvihighai nia na ungaunga ni pungi mana mate. ");
INSERT INTO nlg_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Ge ke vagha ighai kai ririukeha na holohabana dida na God pa ka vurehighi na lei limamami itatana kokoeliulivutiani na lei god keha, ");
INSERT INTO nlg_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","God ke ghilala utunia sughua, na pukuna gaia oli heghena te pukui me ghilala udolui na lei ghanaghana te kabu polo tana lei sopa toba/tobamami. ");
INSERT INTO nlg_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Na pukuna ighoe, ge kakale ighai tana lei dani soko. mi ghai tara pahepaheghai vagha na sheep. ");
INSERT INTO nlg_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Ko sakeraghi dato, Ighoe, Lord, E ghua ge o maturu? Tughuru dato! Mo ko bei neghai sika kasila. ");
INSERT INTO nlg_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","E ghua ge o vaevane keha? E ghua ge o nighi ponolio nimami na lei vahaghitaili mana gunaguna? ");
INSERT INTO nlg_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ighai tai tumu taghoti horu itatana ravu, ma kolitao horu tana ravu te meto. ");
INSERT INTO nlg_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Tughuru dato! Hangaghai! Ko vavolaghai nia nimua na dolo ke mua mautu haia. ");
INSERT INTO nlg_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Na tobagu te vonughia na ghanaghana te uto utoa, Inau ku bosa poloani na lei kokoe vania na vunaghi, Na lapigu te vagha na vatei gegere vagha na tinoni te gegere uto. ");
INSERT INTO nlg_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ighoe na matakage utuni vulera na lei taba ni vure soko na lei bosa uto lee tara tavetave mai tana ghidumu. God, oli heghena te vautogho kasila. ");
INSERT INTO nlg_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Talu dila nimua na isi ge na malaghai haba! Ighoe vamua to rongoragha ngangata, vagha ghua na manamanaha! ");
INSERT INTO nlg_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ta nimua na haba, haehaghe mo ko rughu horu va tana lagavule, Na vokovoko ni utuni, talumuri mana mua kiko. Tona haliu mo ko rughuhoru mo ko lutu maemanei na lei gehegehe dika! ");
INSERT INTO nlg_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Nimua na lei kuali tara vavangalu. Te kale pota na tobadira na ghamami na levunimate. Na lei kema soko kara poghotao inaghona gaia, Mi sarana na tuamu ke pilili. ");
INSERT INTO nlg_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Nimua na malei sopou ni vunaghi, Ighoe God, Ke mua soko ke va me va. Nimua na maana ni vunaghi tara kokoe tatea tara utuni./te maemane, mi tatana gaia, ko righitaonia nimua na kinakabu ");
INSERT INTO nlg_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ighoe to dolovia na hava te kaekage, mana totobo te dika to nia sika. Keri te vagha ke, God, nimua na God, te siusiugho, me kovala horua na kokolo madalo ni rivurivu i vuvungamu haba vulera na lei tinoni soko. ");
INSERT INTO nlg_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Nimua na pupulu te, to uruuru iga na myrrh, aloes, mana cassia. Mi tana bonana na vunaghi tara vaghuvaghua nia na lei totobo pura, Ighoe tara nia lingelinge vanigho nia na lei harp. ");
INSERT INTO nlg_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Na lei daledira vaivine na lei vunaghi tara kabu ighobudira na lei nimua na vure ni lutu. Na vinahogho te tughuru tana pala madolomu mete nia vaghuvaghua na puku ni Gold tara lavia tana Ophir. ");
INSERT INTO nlg_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ko rongoviu inau, ghe detei vinahogho; Ko holopangotia tana tobamu na hava tu bosa Ko nira ponolio nimua na vure mana lei bona ni komumu tara hau. ");
INSERT INTO nlg_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Na taumu na vunaghi te nia togotogo na utona na reireimu Ko talumava gaia na maghutumu. ");
INSERT INTO nlg_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Na vunaghi ni Tyre ke siusiugho nia na dolo. Mana lei tinoni tara lologho Kara nongia na hava te nagho itamua. ");
INSERT INTO nlg_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Na vaivine te taulaghi, na vinahogho, te pitu tana vokina Te nia pupulu na tivi tara vauhia nia na Gold. ");
INSERT INTO nlg_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ta nina na alo utoutoa, agaia tara hulia va tana vunaghi mana lei kulana vaivine tara tona kolua. ");
INSERT INTO nlg_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Ivei vaho te vagha, na togotogo ia to nira ghaghua, Te vagha tara rughu haghe tana valei ni haba. ");
INSERT INTO nlg_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Rana lei dalemu kara mai vunaghi vaghara na lei tamadira. Mi ghoe ko nira ge kara vunaghi pungisighi na lei komu. ");
INSERT INTO nlg_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Inau ku ghanaghana na ahamu tana lei sopa vavata udolu vagha keri ke, na lei kama kara holohabagho ke va me vaa. ");
INSERT INTO nlg_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","God, ighoe dida na laga mana vola, Mo gonidilaa haia na hangada tana bona ni gunaguna. ");
INSERT INTO nlg_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Keri ke, ma ka mua ghoi mataghu, sakai ghua manaa na anu ke mai mana lei ghotu kara tavuti kehara ma kara tumu horu tana tahi. ");
INSERT INTO nlg_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Talana na lei ghotu kara kahikahi te vagha na beti te voghuvoghua te tave. ");
INSERT INTO nlg_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Na betitina te nia hevei na rivurivu tana komuna dida na God Na komu tabu nina na puku ni haba. ");
INSERT INTO nlg_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","God, heghena vamua te ghaha itatana komu vaghana keri; Ke mua ghoi tangomana tua na durake. God ke pilupilua tana taporasana na dani. ");
INSERT INTO nlg_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Na lei vure tara ngingili laga, mana lei kinakabu soko kara havukaghi kolili! God ni viviha ke nia hevei mai na viviha mana maramana ke obo keha! ");
INSERT INTO nlg_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","A Lord puku ni maana te kabu ighobuda, Na God ni Israel gaia dida na pilupilu/vatu ngasi ");
INSERT INTO nlg_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Kau mai, ma kau righia nina lei lutu nina Lord te rongoragha Ma kau righia ivei te vagha na laviana mai tana maramana na mana ni durake ");
INSERT INTO nlg_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Mana betoana na lei sura tana maramana udolu. Agaia te gotia na baghe mana tinabe te sodui ge e rua. Me Kerea na tako tana lake. ");
INSERT INTO nlg_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Kabu todore, ma kau ghilala Inau a God! Na lei kema soko kara talumavau Inau. Na maramana udolu ke talumavau Inau. ");
INSERT INTO nlg_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","A Lord puku ni maana te kabu ighobuda Na God ni Israel gaia dida na pilupilu/ vatungasi ");
INSERT INTO nlg_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Mai ghau na lei vure soko, Kau tapoi na limamiu nia na rivu! Kau ghuu dato vania God nia na togotogo mana rivurivu. ");
INSERT INTO nlg_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","A Lord puku na maana te haba va, Agaia na vunaghi haba tana maramana udolu. ");
INSERT INTO nlg_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Agaia te taluhorura na lei kema i sarada; me talura na ghada levunimate i sarana marevoda. ");
INSERT INTO nlg_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","A gaia te vilia vanighita na komu ni baubahu te vagha na bonada; Tana bonadira na lei kukuana Jacob te dolovira. ");
INSERT INTO nlg_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","A God te nia dato na ngingili rivurivu Ma Lord te nia dato na talama ni tavuli. ");
INSERT INTO nlg_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Kau linge holouto vania God, linge holouto, linge holouto vania dida na vunaghi, kau linge holouto! ");
INSERT INTO nlg_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","A God, gaia na vunaghi haba tana maramana talighu kau holohabaa nia na Linge holouto. ");
INSERT INTO nlg_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","A God te vunaghi pungisia na maramana udolu; agaia te Kabu ta nina mali sopou te haba. ");
INSERT INTO nlg_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Rana lei haba ni maramana tara kabu sakai sonikolu. Agaira tara hangaghita tana holohabana na God ni Abraham. Na lei vunaghi ni maramana a nina God. Agaia ka nia kikinima ivei mi vei. ");
INSERT INTO nlg_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Ivei vaho tua te vagha na habana Lord, me mava na bosa utoana tana komuna dida na God; mi tana nina ghotu te tabu. ");
INSERT INTO nlg_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Ivei vaho tua tea na utona mana datona, na maramana udolu te nia togotogo na righiana. Na ghotu Zion, na ghotu te Tabu, na komuna na vunaghi haba lee/puku ni haba ");
INSERT INTO nlg_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","God te hagha heghena tua tana vale datogha i Jerusalem ge talutatea heghena te vagha na pilupiluna. ");
INSERT INTO nlg_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Na lei vunaghi ni maramana tara hogholavaghi tana ovu ni sura mara gonidilaa ge kara haghe tana komu. ");
INSERT INTO nlg_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Mi tana bona tara righia ge ara tumu ni mate Ma gaira tara mataghu mara sama keha. ");
INSERT INTO nlg_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Ma gaira tara nia taetabe ngasi na mataghu; te vagha na vinekama ta nina na vadangi ni vahuhu. ");
INSERT INTO nlg_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Te vaghara na lei vaka sule i Tarshish; na ghuri sule ngangata te dikalara ");
INSERT INTO nlg_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ighai tai rongovia tua na ladana mana rongoraghana na komu sule keri, mi taeni ighai tai righia heghemami na komuna dida na God, A gaia ke righitaonia ke va me va. ");
INSERT INTO nlg_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","God, Ighai tai kokoeliulivuti vaovarongo ta nimua na dolo ke mua soko, Te vagha ighai tai holohabaa tana bonamiu te Tabu. ");
INSERT INTO nlg_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Na ahamu te rongoragha, Ghe Lord, Ara hei soko tana maramana talighu kara holohabaa ma nia na lima madolomu te laga ke vonughia na maemane. ");
INSERT INTO nlg_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Lubatira na lei tinoni i vuvungana na ghotu i Zion kara rivurivu, mana lei komu sule ni Judea ke togotogo ma nimura na dete soko tara uto. ");
INSERT INTO nlg_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Haghevia, mo ko righitalighutia na komu sule Jerusalem, sakutua talighutia mo ko idumighi na lei valei datogha iga. ");
INSERT INTO nlg_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Vatoghaa na pilupiluna te ngasi mo ko righighi na lei valena ge kau tughunighi vanira arahei kara mai imuri. ");
INSERT INTO nlg_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","A keri te vagha gaia God, A gaia dida na God ke va me vaa. ma gaia dida na righitaoni, koekobe ka mate. ");
INSERT INTO nlg_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Kau rongovia aeni ighau udolu na lei vure; Ighau udolu tana maramana kau varongohighi. ");
INSERT INTO nlg_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Haba mana kubolu, tinoni sosodo mana bona, kau rongo! ");
INSERT INTO nlg_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Na lei bosagu te vonughia na manaha; mana lei ghanaghanagu te nia vonu na ghilala. ");
INSERT INTO nlg_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Inau tu varongohi pukupukua na lei vavaghaha mu ku tatea nigua na bosa tana ghalevu ghalo. ");
INSERT INTO nlg_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","E Taho na hava ku mataghunia tana bona ni gunagunagha. Tana bona na levunimate tara talighutiu. ");
INSERT INTO nlg_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Gaira tara ghanaghana kodo tadia na lologho au. Mara nighi mangamangagha didira na sosodo au. ");
INSERT INTO nlg_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Me taho siki sakai tadira ke huiolia heghena tana mate mana peluana nina peluoli God ");
INSERT INTO nlg_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Na huioli te mua malumu na maiana Me taho siki sakai ge ke pelu aua. ");
INSERT INTO nlg_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Me ke vagha ge ke vola kasila me ke mua righia na maramana ni mate. ");
INSERT INTO nlg_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Mara hei tara manaha kara mate, te vaghara na bule mana toba kupi. Ara luba sanighi didira na sosodo au i muri. ");
INSERT INTO nlg_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Na puku ni komudira na maramana ni mate, gaira kara kabu igaa ke va me va; Mara holo taonira nia na bona keri, mara sanighi didira na lologho vanira na keha. ");
INSERT INTO nlg_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Ma gaira kara mua kabu daro ta didira na lologho au; Gaira kara mate vaghara vamua na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Aeni te vagha didira na hahi tara bule mara talu sulera heghedira. ");
INSERT INTO nlg_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Te vagha na sheep tara hulira va i betidalo, na mate te vatoghaa vanira vagha na righitaoni. rana uto kara umaghi pungisira te puipungi mana hulidira ke vuvuha tana gilu ni mate ke hauvia na komu tara haghara igaa. ");
INSERT INTO nlg_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Ma vaniu inau, God ke huiolia na volagu; Agaia ke lavi kehau ta nina maana na mate. ");
INSERT INTO nlg_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Ko bei mataghu, ge kara lologho au ara hei na bona mana valedira ke togotogogha. ");
INSERT INTO nlg_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Mi tana bona ni mateadira, Gaira kara mua ghoi lavia diki totobo kolura. Ma didira na lologho ke taonira va tana gilu ni mate. ");
INSERT INTO nlg_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Tana bona ni volana te togotogo ta nina ghanaghana heghena; Mana maramana te nia ghuu na togotogo ta didira na lutu uto. ");
INSERT INTO nlg_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Ma gaira kara mate te vaghara na balu. Ma kara mua ghoi righia ghua na marara. ");
INSERT INTO nlg_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Na vure tara nia talunagho didira na lologho tara mua ghilala agaira kara mate te vaghara vamua na lei maumanu. ");
INSERT INTO nlg_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","A Lord God puku ni maana te bosa, me detera na lei tinoni tana soghaana mai ga na aho, maia te va huu iga. ");
INSERT INTO nlg_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Tana ghotu i Zion te vatei ghagharugha iga God te mararaa nia na marara uto. ");
INSERT INTO nlg_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Ghada na God, te nia dutu mai na dedemo/talamo ni viviha na lake ke durake na lei totobo i naghona mana gutuveve ni maraghata sule ke talighutia. ");
INSERT INTO nlg_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","I kokou mi pari koro nina komu ni righi kale utuni. tatana a gaia ke detera nina na vure. ");
INSERT INTO nlg_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Lavira mai itagua nigua na vure taluutuni Agaira ra hei tara gonia na baubahu nia na sukaghi. ");
INSERT INTO nlg_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Lubatia i kokou ke talutatea nina uto te maemane A God heghena vamua ke dete. ");
INSERT INTO nlg_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Aghau nigua na vure, kau rongo! Inau ku bosaa; raeni nigua na kakage vanigho Israel Inau God, nimua na God. ");
INSERT INTO nlg_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Inau tu mua loghoa siki bosa ni huhuru ta nimua na sukaghi, pa na lei sukaghi kekere. To lavia mai ta nigua na bela ni sukaghi. ");
INSERT INTO nlg_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Mi nau tu mua liona siki buluka tana valemu, Mu mua liona ghua siki goat ta nimua na pilu. ");
INSERT INTO nlg_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Na lei maumanu udolu na leiao a nigua: Inau tu loghora na lei bolo soko tana lei togha ni ghotu. ");
INSERT INTO nlg_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Na lei manu ni popopo mana lei maumanu udolu ni nanata ke a nigua. ");
INSERT INTO nlg_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ge tuku vitolo ke, mu ku mua tughurua vanigho Na pukuna na maramana udolu a nigua, mana lei hegohego soko i lokana. ");
INSERT INTO nlg_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","inau tu mau nia ghaghua to nia sukaghi na buluka mu mua nia ghaghua na ghabu ni Goat. ");
INSERT INTO nlg_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Mana hava vamua tu puku ni liona ke, nimua na puku ni holouto vamua God, Mi nau tu liomu ge nimua na baubahu ke kale utuni vania gaia te haba i kokou. ");
INSERT INTO nlg_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ko ghanaghanau tana bona ko haghagho tana gunaguna mi nau ku vavolagho, mi ghoe ko va heu na talumava. ");
INSERT INTO nlg_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Ma God te ghaghua vanira tara tangohahi Kau bei ghoi nighi ghaeghahe nigua na lei vetena, ma kau bei ghoi tate ghau heghemiu tau taotaoniu inau. ");
INSERT INTO nlg_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ighoe to nia sika nigua na totoro ni taraghi mo nighi lei nigua na vetena me totobo lee vamua. ");
INSERT INTO nlg_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Tana bona to righia agaia te gito ke, mo hangaa Mi ghoe to sonileaa vamua nimua na bona itadira tara ngelera na taudira rana keha. ");
INSERT INTO nlg_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Na Mangamu te bosai na lei bosa dika, mana lapimu te vonughia na sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ighoe o sopou kolili ni bosa pungisiana na hoghomu, Na pukuna dalena tinamu hoghomu. ");
INSERT INTO nlg_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Tana bona to gonighi na lei totobo udolu raeni ke, Inau tu kabu todore, mo ghanaghana ighoe tu mua nia ghaghua na hava: mi taeni inau ku tatei na lei nimua na hahi, mu ku gegerei na lei nigua na totobo i vuvungamu. ");
INSERT INTO nlg_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Kau tughui na liomiu. Ighau rahei tau mua ghanaghana God, ku vuti keha ghau gea, me taho siki sakai ke vavolaghau. ");
INSERT INTO nlg_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Mana niana hevei na holouto gaia keri na sukaghi ni talumavaagu. Inau ku talutatea vanigho a nina maana ni vola a God. ");
INSERT INTO nlg_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Ko aroviu, Ghe God, Na pukuna nimua na dolo mana lei uto tara subo Ko hola kehai na lei nigua na hahi. ");
INSERT INTO nlg_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ko apo marabu utou ta nigua na tangohahi: Mo ko marabui tana lei palugu. ");
INSERT INTO nlg_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Tu ghilalai na lei nigua na gehegehe te vatei maamaagha tu gonighi tara kene taoniu tana dani mana bongi. ");
INSERT INTO nlg_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Itamua vamua, mi ghoe heghemu vamua inau tu tangohahi, Inau tu nei na lei totobo te dika itamua, Ighoe ko nia hevei na uto tana hava to bosaa ma nimua na dete itagua kara maemane ");
INSERT INTO nlg_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Tana sivuraghagu, Inau tu tinoni tangotangodika Eo, tana bona tu kau mai tana kutuna tinagu. ");
INSERT INTO nlg_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","E utuni, to liona na utuni tana toba ni tinoni: Ighoe ko taraiu ge ku manahana na vola ilokagu. ");
INSERT INTO nlg_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ko apo marabu tana lei palugu, ge inau ku marabu ko apou mughua, Mi nau ku pura vulea na snow/rana lovo ");
INSERT INTO nlg_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ko va hea oliu mai nigua na togotogo, Ighoe to tagotighi na huligu ko neu ge ku ghoi togotogo pulohi. ");
INSERT INTO nlg_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ko bei righighi na lei palugu mo ko talukehai na lei nigua na hahihahi. ");
INSERT INTO nlg_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ko vuha ilokagu na toba te maghora, Ghe God. Ko vavaolua na tarunga te utuni ilokagu. ");
INSERT INTO nlg_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ko bei tiva kehau tana bonamu mo ko bei soni kehaa nimua na tarunga tabu itagua. ");
INSERT INTO nlg_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ko ghoi vaheu mai na togotogo ta nimua na vola maurihali mo ko neu ge ku lagalaga na taoniamu ");
INSERT INTO nlg_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Mi nau ku taraira nia na nilabumu rana tangohahi Ma gaira kara liliu pulohi vanigho. ");
INSERT INTO nlg_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Ko talukehai vaniu te tave na ghabu, Ighoe God, to vavolagu vaho ge Inau ku nia linge rivurivu a nimua na talukehai palu. ");
INSERT INTO nlg_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ko vukesia na ghidugu, Ghe Lord, Ge Inau ku holohabagho. ");
INSERT INTO nlg_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ighoe to mua nia togotogoa na sukaghi, Inau tu mai hegho Puku lavia vanigho na sukaghi kekere ighoe ko mu lavipangotia. ");
INSERT INTO nlg_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Na sukaghi to nia ghaghua Ighoe ke na toba te paruruha. Na tabo te tughu mete paruruha, God ge ko bei sivilaghiniu. ");
INSERT INTO nlg_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ko righia nia a veiarovi i Zion mo ko hanga mo ko kisu olia na peona Jerusalem. ");
INSERT INTO nlg_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ighoe ko nia togotogo na puku ni sukaghi uto, nia na lei sukaghi kekere, mana sukaghi udolu, Ma kara nia sukaghi na buluka ta nimua na bela tabu. ");
INSERT INTO nlg_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Vania na tinoni te lutulutu linge na lingena David, taonia tana bona a Doeg na tinoni ni Edom te bosa vania a Saul, te talua tana komu ni pipiti vanira rana kisumate a David a Ahimelech. Ighoe to hologho nia heghemu na tinoni te laga vule tana kisumate, Ina sughua? Ivei te ghaghua ge o nia talunagho kolili a nimua na gehegehe dika eni, Ighoe to nira a nina vure a God ge ara mua loghoa na talumava? ");
INSERT INTO nlg_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Tana lei dani udolu to talu dilaa na haurake na lapimu te toro tatasi vagha na vangana na (isi dadara.)? Ighoe na tinoni to manaha au vulea ngangata tana kokoe sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ighoe to dolovi ngangata na gehegehe dika vulea na gehegehe uto. mana sorisori vulea na utuni. ");
INSERT INTO nlg_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ighoe to dolovi ngangata na bosa ani na lei totobo te va lavibuleadira na balu tinoni Ighoe na tinoni sorisori. ");
INSERT INTO nlg_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Hauva ka, ma God ke gora kehagho tana komumu me ke sania na bonadira tara vola kasila ");
INSERT INTO nlg_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","A gaira tara kabu marabu, kara vaevanea ma kara mataghunia A gaira kara kiakia ma kara ghaghua, ");
INSERT INTO nlg_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Vaevanera vaa na lei mane sutusutu sule ngangata na hava te kalera tara mua loghoa na talu mavaa itatana God. Hauva ma gaira tara talu mavaa vamua a didira na lologho mara nia sule kolu na gehegehe dika mana tarungadira te labe. ");
INSERT INTO nlg_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Mi nau te vaghau na ghai tara vatua nia na Olive Te totolo me kotukotu i lokana valena God. Inau tu talu mavaa a nina dolo a God te mua soko buto, ke va me va ");
INSERT INTO nlg_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Inau ku bosautogho ke vaa me vaa ghe God nia na lei totobo te gonighi. Inau ku polopitua nimua na lei veiarovi. I naghona na matadira nimua na vure. ");
INSERT INTO nlg_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","vania na tinoni te taghaoa na vungu ni linge: A nina kabu beto ni ghanaghana nina David. A gaira tara bule vamua tara bosa mara ghaghua tana tobadira, “Te tahoa God,” A gaira tara sonia na uto mara tona va vania na dika, mana lei ghanaghanadira te dika. E taho tua siki sakai ke gonia siki uto! ");
INSERT INTO nlg_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","God te vaevane horu mai i kokou, i vuvungana na vinavahuhu ni tinoni. A gaia te vaevane horu mai ge ke vaevane sodoa ge a siki sakai so na puku ni ghanaghana manaha. Ge siki sakai te kene taonia God. ");
INSERT INTO nlg_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Hauva ka me taho, Agaira udolu tara ririu keha vania God. A gaira udolu tara vuha sania na uto mara tona va vania na dika. E taho tua siki sakai ke gonia siki uto, hughua a sakai na tinoni te taho! ");
INSERT INTO nlg_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Kara mua tangomana tua na naunau ta didira na hahi a gaira tara gehegehe dika? A gaira ta ghani soko laghinira tua nigua na vure vagha na berete Ara mua tangomana tua na ghanaghana ni kokoeliulivuti vaniana God. ");
INSERT INTO nlg_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Hauva, mana mataghu ke ngasilira agaira, na mataghu te vaghaa tara mua ghilalaa mai mua i dania God ke havukaghinighi na hulidira na ghamua na kana Ighoe ko talura tana vati mamaagha nia a God te soni kehara tua vaghara tara dika gaira. ");
INSERT INTO nlg_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Tu liona na vatei vavola keri sogea ke va mai tana ghotu Zion ke vavolaa Israel! Nia tana bona God ke ghoi talugoni olira nina vure Jacob ke nia ghaghua vola na togotogo, me Israel ke rivurivu. ");
INSERT INTO nlg_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Ko nia mai kolu na mana te laga, Ghe God, mo ko vavolau na levunimate! Ko pilupungisiu nia nimua na maana te laga. ");
INSERT INTO nlg_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Ghe God, ko rongoviu ta nigua na kokoeliulivuti. Ko kabu vaovarongo mai ta nigua na nongi papara. ");
INSERT INTO nlg_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Nia rana keha tu mua ghilalara tara liona na labuagu nia na lei totobo ni matemate; na lei mane laga tara liona na mateagu. A gaira tara totobo lee vamua itatana God. ");
INSERT INTO nlg_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Hauva ka, ma God a nigua na hahanga A gaia Lord te pangotiu ge u vola! ");
INSERT INTO nlg_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ko nighi didira na lei padalaghi ni dika na ghagua na lei levunimate ge ke ririu pulohi vanira. ko gonia te vagha to nia baubahu tua mo ko soko laghinira. ");
INSERT INTO nlg_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Inau ku ni sukaghi nigua na hevei oli heghegu gatu vanigho. Inau ku holoutogho na ahamu, Ghe Lord nia te uto te vaghaa. ");
INSERT INTO nlg_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Nia ighoe ko vavolau ta nigua na lei vahola tara kauliu. Mo hangau ge ku laga vulera na lei ghagua na kana. ");
INSERT INTO nlg_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Vania na tinoni te taghaoa na vunguvungu ni linge. Nina David Ko rongoviu ta nigua na kokoeliulivuti, Ghe God. Ko bei nia hughu a nigua na tangitangi ni hahanga. ");
INSERT INTO nlg_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","U bongi ngangatagho ge ko vaovarongo mo ko heu na bosa tughu a nigua na lei vahola kaukauli tara au vule ngangatau tua. ");
INSERT INTO nlg_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Lei ghagua na kana tara ghughuviu, ara nighi ghaeghahe laga dato na lei lavi mataghu tara matemate. Ara talui na lei vahola kaukauli i vuvungagu. Agaira tara hiliviu ta didira na rutu papara. ");
INSERT INTO nlg_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Na tobagu te vahaghitaili ngangata. na mamataghuna na mate te mana pungisiu. ");
INSERT INTO nlg_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Na mataghu mana tatata tara au vuleu. u mua tangomana tua ge ku beto na kahikahi. ");
INSERT INTO nlg_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ivei te ghaghua sughua ge ku loghoa na ghata vaghaa na bola ke; keri ge ku lovo keha mu ku aheahe. ");
INSERT INTO nlg_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Ge ku lovo sagau vaa tana tautalu asi. ");
INSERT INTO nlg_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ivei ke ghaghua ge ku mina samapolo, sagauvia na maraghata ni gunaguna te mamataghugha. ");
INSERT INTO nlg_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Ko haurakera, Ghe Lord, mo ko nira ge kara hoghohare tana koluadira, Na Inau tu vaevanea na haurake, veilalabui mana hughuhughu i lokana na komu sule. ");
INSERT INTO nlg_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Na peona tara talighutia tana lei bongi mana dani ge kara bei mai haghevia. Hau va ka, mana puku ni totobo te mamataghugha ke na lei gehegehe dika ilokana na komu sule. ");
INSERT INTO nlg_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Na mate tinoni mana gitogito tara kale so. Ivei tua ilokana na komu sule. Na lavi mataghu mana pasapasa popolo tara vonughia na lei baebasena na komu sule. ");
INSERT INTO nlg_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Te mua ghagua na kana te bosa dikalau u tangomana sono ge ku lavia keri. Tara mua ghagua na kana tara ghanaghanara heghedira tara mava tara bosa dikalau Inau u tangomana sono ge ku polo vanira. ");
INSERT INTO nlg_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Hauva ka, mi ghoe, a nigua na tinoni te kaekage kolu itagua, ghagua na udukolu mana kulagu to dutuviu. ");
INSERT INTO nlg_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Ivei te vagha na utona dida na udu kolikolu toro nia togotogo tana bona to sakutua koukolu vaa tana valena God. ");
INSERT INTO nlg_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Lubatia na mate ke ghurukeha na ghagua na kana nia na hare. talana na malei beku tinoni mate ke sononi volara, nia na gehegehe dika te mangatia na komuna tana lokadira. ");
INSERT INTO nlg_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Mi nau ku holoa God, Ma Lord ke vavolau Inau. ");
INSERT INTO nlg_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Tana puipungi, levu ni aho, nulavi, mi tana bongi, inau tu ghaeghahe dato laga ta nigua na vahaghitaili ma Lord te rongovia na tangi ni mangagu. ");
INSERT INTO nlg_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Agaia te vavolau me righitaoni utou ta nigua na vahaghitaili. tana veitotoghoni tara utu talighutia. Sakai vamua te vaghaa keri ka, ara subo so tara hughu Inau. ");
INSERT INTO nlg_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","God, te vunaghi haba kasila, ke rongoviu me ke talumurira. nia ghagua na lei levunimate tara mua liona ge kara tughui na lei gehegehedira Ara mua nia kikinima God. ");
INSERT INTO nlg_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Vania na kulagu eni, agaia te perou agaia te diua nina lei baubahu. ");
INSERT INTO nlg_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Na lei kokoena tara malebo te vagha na lei vanga tara malebo/na tahi beata Hauva ka, mi loka ni tobana ke, na kisu mate. Na lei kokoena tara vaghai na beti ni beto pileana na vahaghitaili. /na oil/oele hauva mi sarana na lei vatei suki tinoni. ");
INSERT INTO nlg_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Vahea nimua na lei vahola, Ighoe A Lord, ma gaia ke mua lubatira rana taluutuni ge kara madali keha ma kara tumu ");
INSERT INTO nlg_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Mi ghoe, Ghe 