﻿USE sofia;
DROP TABLE IF EXISTS sofia.nldnbg_vpl;
CREATE TABLE nldnbg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nldnbg_vpl WRITE;
INSERT INTO nldnbg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In den beginne schiep God de hemel en de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","De aarde nu was woest en ledig, en duisternis lag op de vloed, en de Geest Gods zweefde over de wateren. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","En God zeide: Er zij licht; en er was licht. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","En God zag, dat het licht goed was, en God maakte scheiding tussen het licht en de duisternis. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","En God noemde het licht dag, en de duisternis noemde Hij nacht. Toen was het avond geweest en het was morgen geweest: de eerste dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","En God zeide: Daar zij een uitspansel in het midden der wateren, en dit make scheiding tussen wateren en wateren. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","En God maakte het uitspansel en Hij scheidde de wateren die onder het uitspansel waren, van de wateren die boven het uitspansel waren; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","En God noemde het uitspansel hemel. Toen was het avond geweest en het was morgen geweest: de tweede dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","En God zeide: Dat de wateren onder de hemel op één plaats samenvloeien en het droge te voorschijn kome; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","En God noemde het droge aarde, en de samengevloeide wateren noemde Hij zeeën. En God zag, dat het goed was. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","En God zeide: Dat de aarde jong groen voortbrenge, zaadgevend gewas, vruchtbomen, die naar hun aard vruchten dragen, welke zaad bevatten, op de aarde; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","En de aarde bracht jong groen voort, gewas, dat naar zijn aard zaad geeft, en geboomte, dat naar zijn aard vruchten draagt, welke zaad bevatten. En God zag, dat het goed was. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Toen was het avond geweest en het was morgen geweest: de derde dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","En God zeide: Dat er lichten zijn aan het uitspansel des hemels om scheiding te maken tussen de dag en de nacht, en dat zij dienen tot aanwijzing zowel van vaste tijden als van dagen en jaren; ");
INSERT INTO nldnbg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","en dat zij tot lichten zijn aan het uitspansel des hemels om licht te geven op de aarde; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","En God maakte de beide grote lichten, het grootste licht tot heerschappij over de dag, en het kleinere licht tot heerschappij over de nacht, benevens de sterren. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","En God stelde ze aan het uitspansel des hemels om licht te geven op de aarde, ");
INSERT INTO nldnbg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","en om te heersen over de dag en over de nacht, en om het licht en de duisternis te scheiden. En God zag, dat het goed was. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Toen was het avond geweest en het was morgen geweest: de vierde dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","En God zeide: Dat de wateren wemelen van levende wezens, en dat het gevogelte over de aarde vliege langs het uitspansel des hemels. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Toen schiep God de grote zeedieren en alle krioelende levende wezens, waarvan de wateren wemelen, naar hun aard, en allerlei gevleugeld gevogelte naar zijn aard. En God zag, dat het goed was. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","En God zegende ze en zeide: Weest vruchtbaar, wordt talrijk en vervult de wateren in de zeeën, en het gevogelte worde talrijk op de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Toen was het avond geweest en het was morgen geweest: de vijfde dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","En God zeide: Dat de aarde voortbrenge levende wezens naar hun aard, vee en kruipend gedierte en wild gedierte naar hun aard; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","En God maakte het wild gedierte naar zijn aard en het vee naar zijn aard en alles wat op de aardbodem kruipt naar zijn aard. En God zag, dat het goed was. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","En God zeide: Laat Ons mensen maken naar ons beeld, als onze gelijkenis, opdat zij heersen over de vissen der zee en over het gevogelte des hemels en over het vee en over de gehele aarde en over al het kruipend gedierte, dat op de aarde kruipt. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","En God schiep de mens naar zijn beeld; naar Gods beeld schiep Hij hem; man en vrouw schiep Hij hen. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","En God zegende hen en God zeide tot hen: Weest vruchtbaar en wordt talrijk; vervult de aarde en onderwerpt haar, heerst over de vissen der zee en over het gevogelte des hemels en over al het gedierte, dat op de aarde kruipt. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","En God zeide: Zie, Ik geef u al het zaaddragend gewas op de gehele aarde en al het geboomte, waaraan zaaddragende vruchten zijn; het zal u tot spijze dienen. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Maar aan al het gedierte der aarde en al het gevogelte des hemels en al wat op de aarde kruipt, waarin leven is, (geef Ik) al het groene kruid tot spijze; en het was alzo. ");
INSERT INTO nldnbg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","En God zag alles wat Hij gemaakt had, en zie, het was zeer goed. Toen was het avond geweest en het was morgen geweest: de zesde dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Alzo werden voltooid de hemel en de aarde en al hun heer. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Toen God op de zevende dag het werk voltooid had, dat Hij gemaakt had, rustte Hij op de zevende dag van al het werk, dat Hij gemaakt had. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","En God zegende de zevende dag en heiligde die, omdat Hij daarop gerust heeft van al het werk, dat God scheppende tot stand had gebracht. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dit is de geschiedenis van de hemel en de aarde, toen zij geschapen werden. Ten tijde, dat de Here God aarde en hemel maakte, ");
INSERT INTO nldnbg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","– er was nog geen enkel veldgewas op de aarde, en er was nog geen enkel kruid des velds uitgesproten, want de Here God had het niet op de aarde doen regenen, en er was geen mens om de aardbodem te bewerken; ");
INSERT INTO nldnbg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","maar een damp steeg op uit de aarde en bevochtigde de gehele aardbodem – ");
INSERT INTO nldnbg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","toen formeerde de Here God de mens van stof uit de aardbodem en blies de levensadem in zijn neus; alzo werd de mens tot een levend wezen. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Voorts plantte de Here God een hof in Eden, in het Oosten, en Hij plaatste daar de mens, die Hij geformeerd had. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ook deed de Here God allerlei geboomte uit de aardbodem opschieten, begeerlijk om te zien en goed om van te eten; en de boom des levens in het midden van de hof, benevens de boom der kennis van goed en kwaad. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Er ontsprong in Eden een rivier om de hof te bevochtigen, en daar splitste zij zich in vier stromen. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","De naam van de eerste is Pison; deze stroomt om het gehele land Chawila, waar het goud is; ");
INSERT INTO nldnbg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","en het goud van dat land is goed; daar is de balsemhars en de steen chrysopraas. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","De naam van de tweede rivier is Gichon; deze stroomt om het gehele land Ethiopië. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","De naam van de derde rivier is Tigris; deze stroomt ten oosten van Assur. En de vierde rivier is de Eufraat. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","En de Here God nam de mens en plaatste hem in de hof van Eden om die te bewerken en te bewaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","En de Here God legde de mens het gebod op: Van alle bomen in de hof moogt gij vrij eten, ");
INSERT INTO nldnbg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","maar van de boom der kennis van goed en kwaad, daarvan zult gij niet eten, want ten dage, dat gij daarvan eet, zult gij voorzeker sterven. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","En de Here God zeide: Het is niet goed, dat de mens alleen zij. Ik zal hem een hulp maken, die bij hem past. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","En de Here God formeerde uit de aardbodem al het gedierte des velds en al het gevogelte des hemels. Ook bracht Hij het tot de mens, om te zien hoe deze het noemen zou; en zoals de mens elk levend wezen noemen zou, zo zou het heten. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","En de mens gaf namen aan al het vee, aan het gevogelte des hemels en aan al het gedierte des velds, maar voor zichzelf vond hij geen hulp, die bij hem paste. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Toen deed de Here God een diepe slaap op de mens vallen; en terwijl deze sliep, nam Hij een van zijn ribben en sloot haar plaats toe met vlees. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","En de Here God bouwde de rib, die Hij uit de mens genomen had, tot een vrouw, en Hij bracht haar tot de mens. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Toen zeide de mens: Dit is nu eindelijk been van mijn gebeente en vlees van mijn vlees; deze zal „mannin” heten, omdat zij uit de man genomen is. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Daarom zal een man zijn vader en zijn moeder verlaten en zijn vrouw aanhangen, en zij zullen tot één vlees zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","En zij beiden waren naakt, de mens en zijn vrouw, maar zij schaamden zich voor elkander niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","De slang nu was het listigste van alle dieren des velds, die de Here God gemaakt had; en zij zeide tot de vrouw: God heeft zeker wel gezegd: Gij zult niet eten van enige boom in de hof? ");
INSERT INTO nldnbg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Toen zeide de vrouw tot de slang: Van de vrucht van het geboomte in de hof mogen wij eten, ");
INSERT INTO nldnbg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","maar van de vrucht van de boom, die in het midden van de hof staat, heeft God gezegd: Gij zult daarvan niet eten noch die aanraken; anders zult gij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","De slang echter zeide tot de vrouw: Gij zult geenszins sterven, ");
INSERT INTO nldnbg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","maar God weet, dat ten dage, dat gij daarvan eet, uw ogen geopend zullen worden, en gij als God zult zijn, kennende goed en kwaad. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","En de vrouw zag, dat de boom goed was om van te eten, en dat hij een lust was voor de ogen, ja, dat de boom begeerlijk was om daardoor verstandig te worden, en zij nam van zijn vrucht en at, en zij gaf ook haar man, die bij haar was, en hij at. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Toen werden hun beider ogen geopend, en zij bemerkten, dat zij naakt waren; zij hechtten vijgebladeren aaneen en maakten zich schorten. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Toen zij het geluid van de Here God hoorden, die in de hof wandelde in de avondkoelte, verborgen de mens en zijn vrouw zich voor de Here God tussen het geboomte in de hof. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","En de Here God riep de mens tot Zich en zeide tot hem: Waar zijt gij? ");
INSERT INTO nldnbg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","En hij zeide: Toen ik uw geluid in de hof hoorde, werd ik bevreesd, want ik ben naakt; daarom verborg ik mij. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","En Hij zeide: Wie heeft u te kennen gegeven, dat gij naakt zijt? Hebt gij van de boom gegeten, waarvan Ik u verboden had te eten? ");
INSERT INTO nldnbg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Toen zeide de mens: De vrouw, die Gij aan mijn zijde gesteld hebt, die heeft mij van de boom gegeven en toen heb ik gegeten. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Daarop zeide de Here God tot de vrouw: Wat hebt gij daar gedaan? En de vrouw zeide: De slang heeft mij verleid en toen heb ik gegeten. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Daarop zeide de Here God tot de slang: Omdat gij dit gedaan hebt, zijt gij vervloekt onder al het vee en onder al het gedierte des velds; op uw buik zult gij gaan en stof zult gij eten, zolang gij leeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","En Ik zal vijandschap zetten tussen u en de vrouw, en tussen uw zaad en haar zaad; dit zal u de kop vermorzelen en gij zult het de hiel vermorzelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tot de vrouw zeide Hij: Ik zal zeer vermeerderen de moeite uwer zwangerschap; met smart zult gij kinderen baren en naar uw man zal uw begeerte uitgaan, en hij zal over u heersen. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","En tot de mens zeide Hij: Omdat gij naar uw vrouw hebt geluisterd en van de boom gegeten, waarvan Ik u geboden had: Gij zult daarvan niet eten, is de aardbodem om uwentwil vervloekt; al zwoegende zult gij daarvan eten zolang gij leeft, ");
INSERT INTO nldnbg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","en doornen en distelen zal hij u voortbrengen, en gij zult het gewas des velds eten; ");
INSERT INTO nldnbg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","in het zweet uws aanschijns zult gij brood eten, totdat gij tot de aardbodem wederkeert, omdat gij daaruit genomen zijt; want stof zijt gij en tot stof zult gij wederkeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","En de mens noemde zijn vrouw Eva, omdat zij de moeder van alle levenden is geworden. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","En de Here God maakte voor de mens en voor zijn vrouw klederen van vellen en bekleedde hen daarmede. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","En de Here God zeide: Zie, de mens is geworden als Onzer een door de kennis van goed en kwaad; nu dan, laat hij zijn hand niet uitstrekken en ook van de boom des levens nemen en eten, zodat hij in eeuwigheid zou leven. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Toen zond de Here God hem weg uit de hof van Eden om de aardbodem te bewerken, waaruit hij genomen was. ");
INSERT INTO nldnbg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","En Hij verdreef de mens en Hij stelde ten oosten van de hof van Eden de cherubs met een flikkerend zwaard, dat zich heen en weer wendde, om de weg tot de boom des levens te bewaken. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","De mens nu had gemeenschap met Eva, zijn vrouw, en zij werd zwanger en baarde Kaïn; en zij zeide: Ik heb met des Heren hulp een man verkregen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Voorts baarde zij zijn broeder Abel; en Abel werd schaapherder, Kaïn landbouwer. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na verloop van tijd nu bracht Kaïn van de vruchten der aarde aan de Here een offer; ");
INSERT INTO nldnbg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ook Abel bracht er een van de eerstelingen zijner schapen, van hun vet; en de Here sloeg acht op Abel en zijn offer, ");
INSERT INTO nldnbg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","maar op Kaïn en zijn offer sloeg Hij geen acht. Toen werd Kaïn zeer toornig en zijn gelaat betrok. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","En de Here zeide tot Kaïn: Waarom zijt gij toornig en waarom is uw gelaat betrokken? ");
INSERT INTO nldnbg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Moogt gij het niet opheffen, indien gij goed handelt? Doch indien gij niet goed handelt, ligt de zonde als een belager aan de deur, wiens begeerte naar u uitgaat, doch over wie gij moet heersen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Maar Kaïn zeide tot zijn broeder Abel: (Laten wij het veld ingaan). Toen zij nu in het veld waren, stond Kaïn tegen zijn broeder Abel op en doodde hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Toen zeide de Here tot Kaïn: Waar is uw broeder Abel? En hij zeide: Ik weet het niet; ben ik mijns broeders hoeder? ");
INSERT INTO nldnbg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","En Hij zeide: Wat hebt gij gedaan? Hoor, het bloed van uw broeder roept tot Mij van de aardbodem. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","En nu, vervloekt zijt gij, ver van de bodem, die zijn mond heeft opengesperd om het bloed van uw broeder van uw hand te ontvangen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wanneer gij de aardbodem bewerken zult, zal hij u zijn volle opbrengst niet meer geven; een zwerver en een vluchteling zult gij op de aarde zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Toen zeide Kaïn tot de Here: Mijn misdaad is te groot om de straf te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Zie, Gij verdrijft mij heden uit het land en ik zal voor uw aangezicht verborgen zijn, een zwerver en een vluchteling op de aarde; ieder, die mij aantreft, zal mij doden. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Toen zeide de Here tot hem: Geenszins; ieder, die Kaïn doodt, zal zevenvoudig boeten. En de Here stelde een teken aan Kaïn, dat niemand, die hem zou aantreffen, hem zou verslaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Toen ging Kaïn weg van het aangezicht des Heren, en ging wonen in het land Nod, ten oosten van Eden. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","En Kaïn had gemeenschap met zijn vrouw en zij werd zwanger en baarde Henoch; daarna werd hij de stichter van een stad en hij noemde deze stad naar zijn zoon Henoch. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","En aan Henoch werd Irad geboren en Irad verwekte Mechujaël, en Mechujaël verwekte Metusaël, en Metusaël verwekte Lamech. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","En Lamech nam zich twee vrouwen; de ene heette Ada, en de andere Silla. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","En Ada baarde Jabal; hij is de vader geworden van hen, die in tenten en bij de kudde wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","En de naam van zijn broeder was Jubal; hij is de vader geworden van allen, die citer en fluit bespelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","En Silla baarde eveneens, namelijk Tubal-Kaïn, (de vader van) de smeden, allen, die koper en ijzer bewerken. En de zuster van Tubal-Kaïn was Naäma. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","En Lamech zeide tot zijn vrouwen: Ada en Silla, hoort naar mijn stem; vrouwen van Lamech, neigt uw oor tot mijn rede. Ik sloeg een man dood om mijn wonde, een knaap om mijn striem; ");
INSERT INTO nldnbg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","want Kaïn wordt zevenvoudig gewroken, maar Lamech zevenenzeventig maal! ");
INSERT INTO nldnbg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","En Adam had weer gemeenschap met zijn vrouw en zij baarde een zoon en gaf hem de naam Set, want (zeide zij) God heeft mij een andere zoon gegeven in plaats van Abel; hem immers heeft Kaïn gedood. ");
INSERT INTO nldnbg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","En ook aan Set werd een zoon geboren, en hij noemde hem Enos. Toen begon men de naam des Heren aan te roepen. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dit is het geslachtsregister van Adam. Ten dage, dat God Adam schiep, maakte Hij hem naar de gelijkenis Gods; ");
INSERT INTO nldnbg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","man en vrouw schiep Hij hen, en Hij zegende hen en noemde hen „mens” ten dage, dat zij geschapen werden. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Toen Adam honderd dertig jaar geleefd had, verwekte hij (een zoon) naar zijn gelijkenis, als zijn beeld, en noemde hem Set. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","En de dagen van Adam, nadat hij Set verwekt had, waren achthonderd jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Zo waren al de dagen van Adam, die hij geleefd heeft, negenhonderd dertig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Toen Set honderd vijf jaar geleefd had, verwekte hij Enos. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","En Set leefde, nadat hij Enos verwekt had, achthonderd zeven jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Zo waren al de dagen van Set negenhonderd twaalf jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Toen Enos negentig jaar geleefd had, verwekte hij Kenan. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","En Enos leefde, nadat hij Kenan verwekt had, achthonderd vijftien jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Zo waren al de dagen van Enos negenhonderd vijf jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Toen Kenan zeventig jaar geleefd had, verwekte hij Mahalalel. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","En Kenan leefde, nadat hij Mahalalel verwekt had, achthonderd veertig jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Zo waren al de dagen van Kenan negenhonderd tien jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Toen Mahalalel vijfenzestig jaar geleefd had, verwekte hij Jered. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","En Mahalalel leefde, nadat hij Jered verwekt had, achthonderd dertig jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Zo waren al de dagen van Mahalalel achthonderd vijfennegentig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Toen Jered honderd tweeënzestig jaar geleefd had, verwekte hij Henoch. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","En Jered leefde, nadat hij Henoch verwekt had, achthonderd jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Zo waren al de dagen van Jered negenhonderd tweeënzestig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Toen Henoch vijfenzestig jaar geleefd had, verwekte hij Metuselach. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","En Henoch wandelde met God, nadat hij Metuselach verwekt had, driehonderd jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Zo waren al de dagen van Henoch driehonderd vijfenzestig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","En Henoch wandelde met God, en hij was niet meer, want God had hem opgenomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Toen Metuselach honderd zevenentachtig jaar geleefd had, verwekte hij Lamech. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","En Metuselach leefde, nadat hij Lamech verwekt had, zevenhonderd tweeëntachtig jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Zo waren al de dagen van Metuselach negenhonderd negenenzestig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Toen Lamech honderd tweeëntachtig jaar geleefd had, verwekte hij een zoon, ");
INSERT INTO nldnbg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","en gaf hem de naam Noach, zeggende: Deze zal ons troosten over de moeitevolle arbeid onzer handen op deze aardbodem, die de Here vervloekt heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","En Lamech leefde, nadat hij Noach verwekt had, vijfhonderd vijfennegentig jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Zo waren al de dagen van Lamech zevenhonderd zevenenzeventig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Toen Noach vijfhonderd jaar oud geworden was, verwekte Noach Sem, Cham en Jafet. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Toen de mensen zich op de aarde begonnen te vermenigvuldigen en hun dochters geboren werden, ");
INSERT INTO nldnbg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","zagen de zonen Gods, dat de dochters der mensen schoon waren, en zij namen zich daaruit vrouwen, wie zij maar verkozen. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","En de Here zeide: Mijn Geest zal niet altoos in de mens blijven, nu zij zich misgaan hebben; hij is vlees; zijn dagen zullen honderd twintig jaar zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","De reuzen waren in die dagen op de aarde, en ook daarna, toen de zonen Gods tot de dochters der mensen kwamen, en zij hun (kinderen) baarden; dit zijn de geweldigen uit de voortijd, mannen van naam. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Toen de Here zag, dat de boosheid des mensen groot was op de aarde en al wat de overleggingen van zijn hart voortbrachten te allen tijde slechts boos was, ");
INSERT INTO nldnbg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","berouwde het de Here, dat Hij de mens op de aarde gemaakt had, en het smartte Hem in zijn hart. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","En de Here zeide: Ik zal de mensen, die Ik geschapen heb, van de aardbodem uitroeien, de mensen zowel als het vee en het kruipend gedierte en het gevogelte des hemels, want het berouwt Mij, dat Ik hen gemaakt heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maar Noach vond genade in de ogen des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dit is de geschiedenis van Noach. Noach was onder zijn tijdgenoten een rechtvaardig en onberispelijk man; Noach wandelde met God. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","En Noach verwekte drie zonen: Sem, Cham en Jafet. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","De aarde nu was verdorven voor Gods aangezicht, en de aarde was vol geweldenarij. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","En God zag de aarde aan, en zie, zij was verdorven, want al wat leeft had zijn weg op de aarde verdorven. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Toen zeide God tot Noach: Het einde van al wat leeft is door Mij besloten, want door hun schuld is de aarde vol geweldenarij, en zie, Ik ga hen met de aarde verdelgen. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Maak u een ark van goferhout; met vakken zult gij de ark maken en haar van binnen en van buiten met pek bestrijken. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","En zó zult gij haar maken: driehonderd el zal de lengte der ark zijn, vijftig el haar breedte en dertig el haar hoogte. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gij zult aan de ark een lichtopening maken, en een el van boven af zult gij die afwerken, en de ingang der ark zult gij in haar zijkant aanbrengen; met een onderste, een tweede en een derde verdieping zult gij haar maken. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Want zie, Ik ga een watervloed over de aarde brengen om al wat leeft, waarin een levensgeest is, van onder de hemel te verdelgen; alles wat op de aarde is, zal omkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Maar met u zal Ik mijn verbond oprichten, en gij zult in de ark gaan, gij en uw zonen en uw vrouw en de vrouwen uwer zonen met u. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","En van al wat leeft, van alle vlees, van alles zult gij één paar in de ark brengen om het met u in het leven te behouden; mannetje en wijfje zullen zij zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Van het gevogelte naar zijn aard en van het vee naar zijn aard, van al het kruipend gedierte van de aardbodem naar zijn aard, van alles zal één paar tot u komen om het in het leven te behouden. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","En gij, neem u van alle voedsel, dat gegeten wordt, en verzamel het bij u, opdat het voor u en voor hen tot spijze zij. ");
INSERT INTO nldnbg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","En Noach deed het; geheel zoals God het hem geboden had, deed hij. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","En de Here zeide tot Noach: Ga in de ark, gij en geheel uw huis, want u heb Ik in dit geslacht voor mijn aangezicht rechtvaardig bevonden. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Van alle reine dieren zult gij zeven paar nemen, het mannetje en zijn wijfje, maar van de dieren, die niet rein zijn, één paar, het mannetje en zijn wijfje; ");
INSERT INTO nldnbg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ook van het gevogelte des hemels zeven paar, mannetjes en wijfjes, om het geslacht in het leven te behouden op de gehele aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Want over nog zeven dagen zal Ik het op de aarde veertig dagen en veertig nachten doen regenen, en Ik zal alles wat bestaat, hetgeen Ik gemaakt heb, van de aardbodem verdelgen. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","En Noach deed naar alles wat de Here hem geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","En Noach was zeshonderd jaar oud, toen de watervloed over de aarde kwam. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","En Noach ging met zijn zonen en zijn vrouw en de vrouwen zijner zonen met hem, in de ark vanwege de wateren van de vloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Van de reine dieren en van de dieren, die niet rein waren, van het gevogelte en (van) alles wat op de aarde kruipt, ");
INSERT INTO nldnbg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kwamen er twee aan twee tot Noach in de ark, mannetje en wijfje, zoals God Noach geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na zeven dagen kwamen de wateren van de vloed over de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In Noachs zeshonderdste levensjaar, in de tweede maand, op de zeventiende dag der maand, op die dag braken alle kolken der grote waterdiepten open en werden de sluizen des hemels geopend. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","En de slagregen was veertig dagen en veertig nachten over de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Op diezelfde dag gingen Noach en Sem, Cham en Jafet, Noachs zonen, en de vrouw van Noach en de drie vrouwen zijner zonen met hem in de ark, ");
INSERT INTO nldnbg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","zij en al het wild gedierte naar zijn aard en al het vee naar zijn aard en al het kruipend gedierte, dat op de aarde kruipt, naar zijn aard en al het gevogelte naar zijn aard, alle vogels van allerlei gevederte; ");
INSERT INTO nldnbg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","zij kwamen dan tot Noach in de ark twee aan twee, van al wat leeft, waarin een levensgeest is. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","En die kwamen, kwamen als mannetjes en wijfjes van al wat leeft, zoals God hem geboden had; en de Here sloot de deur achter hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","En de vloed was veertig dagen over de aarde en de wateren wiesen en hieven de ark op, zodat zij oprees boven de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Toen de wateren zeer toenamen en sterk wiesen boven de aarde, dreef de ark op de wateren. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","En de wateren namen geweldig sterk toe over de aarde, en alle hoge bergen onder de ganse hemel werden overdekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Vijftien el daarboven stegen de wateren, en de bergen werden overdekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","En al wat leeft, dat zich op de aarde roert, het gevogelte, het vee en het wild gedierte en alle wemelend gedierte, dat op de aarde wemelt, benevens alle mensen, kwamen om. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Alles, in welks neus de adem van de levensgeest was, alles wat op het droge was, stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Zo verdelgde Hij alles wat bestond, wat op de aardbodem was, mensen zowel als vee en kruipend gedierte en het gevogelte des hemels, zodat zij verdelgd werden van de aarde; Noach alleen bleef over en wat met hem in de ark was. ");
INSERT INTO nldnbg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","En de wateren hadden de overhand over de aarde, honderd vijftig dagen lang. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Toen gedacht God Noach en al het wild gedierte en al het vee, dat met hem in de ark was, en God deed een wind over de aarde strijken, zodat de wateren daalden. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","De kolken der waterdiepte en de sluizen des hemels werden toegesloten en de regen uit de hemel hield op, ");
INSERT INTO nldnbg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","en de wateren vloeiden gestadig van de aarde weg. Aldus namen de wateren na verloop van honderd vijftig dagen af. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","En in de zevende maand, op de zeventiende dag der maand, bleef de ark vastzitten op het gebergte van Ararat. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","En de wateren namen tot de tiende maand gestadig af; in de tiende maand, op de eerste der maand, werden de toppen der bergen zichtbaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Na verloop van veertig dagen opende Noach het venster, dat hij in de ark gemaakt had, ");
INSERT INTO nldnbg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","en hij liet een raaf uit, en deze vloog heen en weer, totdat de wateren van de aarde waren opgedroogd. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Daarna liet hij een duif uit om te zien, of de wateren afgenomen waren van de aardbodem. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Doch de duif vond geen rustplaats voor het hol van haar voet en keerde tot hem in de ark terug, omdat op de gehele aarde water was, en hij stak zijn hand uit, greep haar en bracht haar tot zich in de ark. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Toen wachtte hij nog zeven dagen en hij liet de duif weer uit de ark; ");
INSERT INTO nldnbg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","tegen de avond kwam de duif bij hem, en zie, een vers olijfblad was in haar snavel. Hieraan bemerkte Noach, dat de wateren afgenomen waren van de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Voorts wachtte hij nog zeven dagen en hij liet de duif uit, en zij keerde niet weer tot hem terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","In het zeshonderd en eerste jaar, in de eerste (maand), op de eerste der maand, waren de wateren opgedroogd van de aarde; daarop verwijderde Noach het luik van de ark, en hij zag uit, en zie, de aardbodem droogde op. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","In de tweede maand, op de zevenentwintigste dag der maand, was de aarde droog. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","En God sprak tot Noach: ");
INSERT INTO nldnbg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ga uit de ark, gij en uw vrouw en uw zonen en de vrouwen uwer zonen met u; ");
INSERT INTO nldnbg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","doe al het gedierte dat met u is, van al wat leeft: het gevogelte, het vee en al het kruipend gedierte, dat op de aarde kruipt, met u uitgaan, opdat zij wemelen op de aarde, en vruchtbaar zijn en talrijk worden op de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Toen ging Noach uit, en zijn zonen en zijn vrouw en de vrouwen zijner zonen met hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Al het wild gedierte, al het kruipend gedierte en al het gevogelte, alles wat zich op de aarde roert, naar hun geslachten, ging uit de ark. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","En Noach bouwde een altaar voor de Here, en hij nam van al het reine vee en van al het reine gevogelte en bracht brandoffers op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Toen de Here de liefelijke reuk rook, zeide de Here bij Zichzelf: Ik zal de aardbodem niet weer vervloeken om de mens, omdat het voortbrengsel van des mensen hart boos is van zijn jeugd aan, en Ik zal al wat leeft niet weer slaan, zoals Ik gedaan heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Voortaan zullen, zolang de aarde bestaat, zaaiing en oogst, koude en hitte, zomer en winter, dag en nacht, niet ophouden. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","En God zegende Noach en zijn zonen en zeide tot hen: Weest vruchtbaar, wordt talrijk en vervult de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","En de vrees en de schrik voor u zij over al het gedierte der aarde en over al het gevogelte des hemels, al wat zich op de aardbodem roert en alle vissen der zee; in uw hand zijn zij gegeven. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alles wat zich roert, wat leeft, zal u tot spijze zijn; Ik heb het u alles gegeven evenals het groene kruid. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Alleen vlees met zijn ziel, zijn bloed, zult gij niet eten. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","En waarlijk, Ik zal uw eigen bloed eisen; van al het gedierte zal Ik het eisen en van de mensen onderling zal Ik het leven des mensen eisen. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wie des mensen bloed vergiet, diens bloed zal door de mens vergoten worden, want naar het beeld Gods heeft Hij de mens gemaakt. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","En gij, weest vruchtbaar en wordt talrijk, wemelt op de aarde, ja, wordt talrijk daarop. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","En God zeide tot Noach en tot zijn zonen met hem: ");
INSERT INTO nldnbg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Zie, Ik richt mijn verbond op met u en met uw nageslacht, ");
INSERT INTO nldnbg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","en met alle levende wezens die bij u zijn: het gevogelte, het vee en het wild gedierte der aarde bij u, allen, die uit de ark gegaan zijn, alle gedierte der aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ik dan richt mijn verbond met u op, dat voortaan niets dat leeft, meer door de wateren van de zondvloed zal worden uitgeroeid, en dat er geen zondvloed meer wezen zal, om de aarde te verderven. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","En God zeide: Dit is het teken van het verbond, dat Ik geef tussen Mij en u en alle levende wezens, die bij u zijn, voor alle volgende geslachten: ");
INSERT INTO nldnbg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","mijn boog stel Ik in de wolken, opdat die tot een teken zij van het verbond tussen Mij en de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wanneer Ik dan wolken over de aarde breng en de boog in de wolken verschijnt, ");
INSERT INTO nldnbg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","zal Ik mijn verbond gedenken, dat tussen Mij en u en alle levende wezens van alle vlees bestaat, zodat de wateren niet weer tot een vloed zullen worden om al wat leeft te verderven. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Als de boog in de wolken is, dan zal Ik hem zien, zodat Ik mijn eeuwig verbond gedenk tussen God en alle levende wezens van alle vlees, dat op aarde is. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","En God zeide tot Noach: Dit is het teken van het verbond, dat Ik heb opgericht tussen Mij en al wat op de aarde leeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","De zonen van Noach, die uit de ark gegaan waren, waren Sem, Cham en Jafet; Cham was de vader van Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Deze drie waren de zonen van Noach, en uit dezen is de gehele aarde bevolkt. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","En Noach werd een landman en plantte een wijngaard. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Toen hij van de wijn gedronken had, werd hij dronken en hij ontblootte zich in zijn tent. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Toen zag Cham, de vader van Kanaän, zijns vaders naaktheid en hij vertelde het aan zijn beide broeders buiten. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Daarop namen Sem en Jafet een mantel, legden die op hun beider schouders, liepen achterwaarts en bedekten huns vaders naaktheid, terwijl hun aangezicht afgewend was, zodat zij huns vaders naaktheid niet zagen. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Toen Noach uit zijn roes ontwaakte en vernam, wat zijn jongste zoon hem aangedaan had, ");
INSERT INTO nldnbg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","zeide hij: Vervloekt zij Kanaän, een knecht der knechten zij hij voor zijn broeders. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Voorts zeide hij: Geprezen zij de Here, de God van Sem, maar Kanaän zij hem tot knecht. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God breide Jafet uit, en hij wone in de tenten van Sem, en Kanaän zij hem tot knecht. ");
INSERT INTO nldnbg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","En Noach leefde na de vloed driehonderd vijftig jaar; ");
INSERT INTO nldnbg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","zo waren al de dagen van Noach negenhonderd vijftig jaar; en hij stierf. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dit zijn de nakomelingen der zonen van Noach: Sem, Cham en Jafet; hun werden namelijk zonen geboren na de vloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","De zonen van Jafet waren Gomer, Magog, Madai, Jawan, Tubal, Mesek en Tiras. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","En de zonen van Gomer waren Askenaz, Rifat en Togarma. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","En de zonen van Jawan waren Elisa, Tarsis, de Kittiërs en de Dodanieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Naar dezen zijn de kustlanden der volken in hun landen verdeeld, elk naar zijn taal, naar hun geslachten, onder hun volken. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","En de zonen van Cham waren Kus, Misraïm, Put en Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","En de zonen van Kus: Seba, Chawila, Sabta, Rama en Sabteka; en de zonen van Rama waren Seba en Dedan. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","En Kus verwekte Nimrod; deze was de eerste machthebber op de aarde; ");
INSERT INTO nldnbg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","hij was een geweldig jager voor het aangezicht des Heren; daarom zegt men: Een geweldig jager voor het aangezicht des Heren als Nimrod. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","En het begin van zijn koninkrijk was Babel, Erek, Akkad en Kalne, in het land Sinear. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Uit dat land trok hij naar Assur en hij bouwde Nineve, Rechobot-Ir, Kalach ");
INSERT INTO nldnbg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","en Resen tussen Nineve en Kalach; dat is de grote stad. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","En Misraïm verwekte de Ludieten, de Anamieten, de Lehabieten, de Naftuchieten, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","de Patrusieten, de Kasluchieten, uit wie de Filistijnen zijn voortgekomen, en de Kaftorieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","En Kanaän verwekte Sidon, zijn eerstgeborene, en Chet ");
INSERT INTO nldnbg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","en de Jebusiet, de Amoriet, de Girgasiet, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","de Chiwwiet, de Arkiet, de Siniet, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","de Arwadiet, de Semariet en de Hamatiet; en daarna verspreidden zich de geslachten van de Kanaäniet. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","En de grens van de Kanaäniet was van Sidon in de richting van Gerar tot Gaza, in de richting van Sodom, Gomorra, Adma en Seboïm tot Lesa. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dit waren de zonen van Cham naar hun geslachten, naar hun talen, in hun landen, in hun volken. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","En aan Sem, de vader van alle zonen van Eber, de oudere broeder van Jafet, werden eveneens (zonen) geboren. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","De zonen van Sem waren Elam, Assur, Arpaksad, Lud en Aram. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","En de zonen van Aram waren: Us, Chul, Geter en Mas. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","En Arpaksad verwekte Selach, en Selach verwekte Eber. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","En aan Eber werden twee zonen geboren; de naam van de ene was Peleg, want in zijn dagen werd de aarde verdeeld, en de naam van zijn broeder was Joktan. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","En Joktan verwekte Almodad, Selef, Chasarmawet, Jerach, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaël, Seba, ");
INSERT INTO nldnbg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Chawila en Jobab; deze allen waren de zonen van Joktan. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","En hun woonplaats strekte zich uit van Mesa in de richting van Sefar, het gebergte in het Oosten. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dit waren de zonen van Sem naar hun geslachten, naar hun talen, in hun landen, naar hun volken. ");
INSERT INTO nldnbg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dit zijn de geslachten der zonen van Noach naar hun afstammingen, in hun volken. En van dezen verdeelden zich de volken op de aarde na de vloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","De gehele aarde nu was één van taal en één van spraak. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Toen zij oostwaarts trokken, vonden zij een vlakte in het land Sinear, waar zij zich vestigden. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","En zij zeiden tot elkander: Welaan, laten wij tichelen maken en die goed bakken. En de tichel diende hun tot steen en het asfalt diende hun tot leem. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ook zeiden zij: Welaan, laten wij ons een stad bouwen met een toren, waarvan de top tot de hemel reikt, en laten wij ons een naam maken, opdat wij niet over de gehele aarde verstrooid worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Toen daalde de Here neder om de stad en de toren, die de mensenkinderen bouwden, te bezien, ");
INSERT INTO nldnbg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","en de Here zeide: Zie, het is één volk en zij allen hebben één taal. Dit is het begin van hun streven; nu zal niets van wat zij denken te doen voor hen onuitvoerbaar zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Welaan, laat Ons nederdalen en daar hun taal verwarren, zodat zij elkanders taal niet verstaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Zo verstrooide de Here hen vandaar over de gehele aarde, en zij staakten de bouw van de stad. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Daarom noemt men haar Babel, omdat de Here daar de taal der gehele aarde verward heeft en de Here hen vandaar over de gehele aarde verstrooid heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dit zijn de nakomelingen van Sem. Toen Sem honderd jaar oud was, verwekte hij Arpaksad, twee jaar na de vloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","En Sem leefde, nadat hij Arpaksad verwekt had, vijfhonderd jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Toen Arpaksad vijfendertig jaar geleefd had, verwekte hij Selach. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","En Arpaksad leefde, nadat hij Selach verwekt had, vierhonderd drie jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Toen Selach dertig jaar geleefd had, verwekte hij Eber. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","En Selach leefde, nadat hij Eber verwekt had, vierhonderd drie jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Toen Eber vierendertig jaar geleefd had, verwekte hij Peleg. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","En Eber leefde, nadat hij Peleg verwekt had, vierhonderd dertig jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Toen Peleg dertig jaar geleefd had, verwekte hij Reü. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","En Peleg leefde, nadat hij Reü verwekt had, tweehonderd negen jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Toen Reü tweeëndertig jaar geleefd had, verwekte hij Serug. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","En Reü leefde, nadat hij Serug verwekt had, tweehonderd zeven jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Toen Serug dertig jaar geleefd had, verwekte hij Nachor. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","En Serug leefde, nadat hij Nachor verwekt had, tweehonderd jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Toen Nachor negenentwintig jaar geleefd had, verwekte hij Terach. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","En Nachor leefde, nadat hij Terach verwekt had, honderd negentien jaar, en hij verwekte zonen en dochteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Toen Terach zeventig jaar geleefd had, verwekte hij Abram, Nachor en Haran. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","En dit zijn de nakomelingen van Terach: Terach verwekte Abram, Nachor en Haran, en Haran verwekte Lot. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","En Haran stierf bij het leven van zijn vader Terach in zijn geboorteland, in Ur der Chaldeeën. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","En Abram en Nachor namen zich vrouwen; de naam van Abrams vrouw was Sarai, en de naam van Nachors vrouw was Milka, de dochter van Haran, de vader van Milka en Jiska. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai nu was onvruchtbaar; zij had geen kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","En Terach nam zijn zoon Abram en Lot, de zoon van Haran, zijn kleinzoon, en Sarai, zijn schoondochter, de vrouw van zijn zoon Abram; en hij deed hen wegtrekken uit Ur der Chaldeeën om te gaan naar het land Kanaän, en zij kwamen te Haran en bleven daar. ");
INSERT INTO nldnbg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","En de dagen van Terach waren tweehonderd vijf jaar, en Terach stierf te Haran. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","De Here nu zeide tot Abram: Ga uit uw land en uit uw maagschap en uit uws vaders huis naar het land, dat Ik u wijzen zal; ");
INSERT INTO nldnbg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ik zal u tot een groot volk maken, en u zegenen, en uw naam groot maken, en gij zult tot een zegen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ik zal zegenen wie u zegenen, en wie u vervloekt zal Ik vervloeken, en met u zullen alle geslachten des aardbodems gezegend worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Toen ging Abram, zoals de Here tot hem gesproken had, en Lot ging met hem; en Abram was vijfenzeventig jaar oud, toen hij uit Haran trok. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram nu nam zijn vrouw Sarai en Lot, zijns broeders zoon, en al hun have, die zij verworven hadden, en de lieden, die zij in Haran verkregen hadden, en zij trokken uit om te gaan naar het land Kanaän, en zij kwamen in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","En Abram trok het land door tot de plek bij Sichem, tot de terebint More; en de Kanaänieten waren toen in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Toen verscheen de Here aan Abram en zeide: Aan uw nageslacht zal Ik dit land geven. En hij bouwde daar een altaar voor de Here, die hem verschenen was. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Toen brak hij vandaar op naar het gebergte ten oosten van Betel, en hij spande zijn tent, met Betel tegen het westen en Ai tegen het oosten, en hij bouwde daar een altaar voor de Here en riep de naam des Heren aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Daarna trok Abram steeds verder, naar het Zuiderland. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Toen er hongersnood in het land uitbrak, trok Abram naar Egypte, om daar als vreemdeling te vertoeven, want de hongersnood was zwaar in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Toen hij op het punt stond Egypte binnen te trekken, zeide hij tot zijn vrouw Sarai: Zie toch, ik weet, dat gij een vrouw zijt schoon van uiterlijk. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wanneer de Egyptenaren u zien, zullen zij zeggen: Dit is zijn vrouw; en zij zullen mij doden, en u in het leven laten. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Zeg toch, dat gij mijn zuster zijt, opdat het mij om uwentwil welga, en ik om uwentwil in het leven moge blijven. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Zodra Abram Egypte binnentrok, zagen de Egyptenaren, dat de vrouw zeer schoon was; ");
INSERT INTO nldnbg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","en toen de vorsten van Farao haar zagen, roemden zij haar bij Farao, zodat de vrouw naar het huis van Farao gehaald werd. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","En hij deed Abram wèl om harentwil, zodat hij schapen, runderen, ezels, slaven, slavinnen, ezelinnen en kamelen ontving. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Maar de Here sloeg Farao met zware plagen, evenals zijn huis, ter oorzake van Sarai, de vrouw van Abram. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Toen riep Farao Abram en zeide: Wat hebt gij mij daar aangedaan? Waarom hebt gij mij niet meegedeeld, dat zij uw vrouw is? ");
INSERT INTO nldnbg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Waarom hebt gij gezegd: Zij is mijn zuster, zodat ik haar mij tot vrouw genomen heb? En nu, ziehier uw vrouw, neem haar en ga heen. ");
INSERT INTO nldnbg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","En Farao gaf enige mannen omtrent hem opdracht, en zij deden hem, zijn vrouw en al wat hij bezat, uitgeleide. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","En Abram trok uit Egypte naar het Zuiderland, hij en zijn vrouw en al wat hij bezat, en Lot met hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram nu was zeer rijk aan vee, aan zilver en aan goud. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","En hij ging van de ene pleisterplaats naar de andere, uit het Zuiderland tot bij Betel, de plaats, waar zijn tent in het eerst gestaan had, tussen Betel en Ai, ");
INSERT INTO nldnbg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","naar de plaats van het altaar, dat hij daar vroeger gemaakt had, en Abram riep daar de naam des Heren aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","En ook Lot, die met Abram mede ging, had schapen en runderen en tenten. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Maar het land liet niet toe, dat zij tezamen bleven wonen, want hun have was talrijk, zodat zij niet tezamen konden wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Daardoor ontstond er twist tussen de herders van Abrams vee en de herders van Lots vee. De Kanaänieten nu en de Perizzieten woonden toen in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Dus zeide Abram tot Lot: Laat er toch geen twist zijn tussen mij en u, en tussen mijn herders en uw herders, want wij zijn mannen broeders. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ligt het gehele land niet voor u open? Scheid u toch van mij af; hetzij naar links, dan ga ik rechts, hetzij naar rechts, dan ga ik links. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Toen sloeg Lot zijn ogen op en zag, dat de gehele streek van de Jordaan rijk aan water was; voordat de Here Sodom en Gomorra verwoest had, was zij tot Soar toe als de hof des Heren, als het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Dus koos Lot voor zich de gehele streek van de Jordaan, en Lot brak op naar het oosten; en zij scheidden van elkander. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram bleef wonen in het land Kanaän en Lot vestigde zich in de steden van de Streek, en sloeg zijn tenten op tot bij Sodom. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","De mannen van Sodom nu waren zeer slecht en zondig tegenover de Here. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","En de Here zeide tot Abram, nadat Lot zich van hem gescheiden had: Sla toch uw ogen op, en zie van de plaats, waar gij zijt, naar het noorden, zuiden, oosten en westen, ");
INSERT INTO nldnbg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","want het gehele land, dat gij ziet, zal Ik u en uw nageslacht voor altoos geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","En Ik zal uw nageslacht maken als het stof der aarde, zodat, indien iemand het stof der aarde zou kunnen tellen, ook uw nageslacht te tellen zou zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sta op, doorwandel het land in zijn lengte en breedte, want u zal Ik het geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Daarna sloeg Abram zijn tenten op en ging wonen bij de terebinten van Mamre, bij Hebron, en hij bouwde daar een altaar voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Het gebeurde nu in de dagen van Amrafel, de koning van Sinear, Arjok, de koning van Ellasar, Kedorlaomer, de koning van Elam, en Tidal, de koning der volken, ");
INSERT INTO nldnbg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","dat dezen oorlog voerden tegen Bera, de koning van Sodom, Birsa, de koning van Gomorra, Sinab, de koning van Adma, Semeber, de koning van Seboïm, en de koning van Bela, dat is Soar. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Deze allen kwamen in bondgenootschap naar het dal Siddim, dat is de Zoutzee. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twaalf jaar hadden zij Kedorlaomer gediend en in het dertiende jaar waren zij in opstand gekomen; ");
INSERT INTO nldnbg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","en in het veertiende jaar kwam Kedorlaomer met de koningen die bij hem waren, en zij sloegen de Refaïeten te Asterot-Karnaïm, de Zuzieten te Ham, de Emieten te Sawe-Kirjataïm ");
INSERT INTO nldnbg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","en de Chorieten op hun gebergte Seïr tot El-Paran, dat aan de rand der woestijn ligt. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Daarna keerden zij terug en kwamen te En-Mispat, dat is Kades, en sloegen het gehele gebied van de Amalekieten, en ook de Amorieten, die te Chaseson-Tamar woonden. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Toen rukten de koning van Sodom, de koning van Gomorra, de koning van Adma, de koning van Seboïm en de koning van Bela, dat is Soar, uit en zij stelden zich tegen hen in slagorde in het dal Siddim, ");
INSERT INTO nldnbg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","tegen Kedorlaomer, de koning van Elam, Tidal, de koning der volken, Amrafel, de koning van Sinear, en Arjok, de koning van Ellasar, vier koningen tegen vijf. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Het dal Siddim nu was vol asfaltputten. Toen de koning van Sodom en die van Gomorra vluchtten, vielen zij daarin, en de overgeblevenen vluchtten naar het gebergte. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","En zij namen al de have van Sodom en Gomorra en al hun voedsel en trokken af. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ook namen zij Lot mede, de zoon van Abrams broeder, en zijn have, en trokken af – hij nu woonde te Sodom. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Toen kwam een vluchteling en deelde dit mede aan de Hebreeër Abram, – hij nu woonde bij de terebinten van de Amoriet Mamre, de broeder van Eskol en Aner, die Abrams bondgenoten waren. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Toen Abram hoorde, dat zijn broeder als gevangene was weggevoerd, bracht hij zijn geoefenden, degenen die in zijn huis geboren waren, in de strijd, driehonderd achttien man, en achtervolgde hen tot Dan toe. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","En zij verdeelden zich des nachts tegen hen in troepen, hij en zijn slaven, en versloegen hen en achtervolgden hen tot Choba toe, dat ten noorden van Damascus ligt. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","En hij bracht al de have terug, en ook zijn broeder Lot en diens have bracht hij terug, evenals de vrouwen en het volk. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Toen ging de koning van Sodom uit, hem tegemoet, nadat hij teruggekeerd was van het verslaan van Kedorlaomer en de koningen die met hem waren, naar het dal Sawe, dat is het Koningsdal. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","En Melchisedek, de koning van Salem, bracht brood en wijn; hij nu was een priester van God, de Allerhoogste. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","En hij zegende hem en zeide: Gezegend zij Abram door God, de Allerhoogste, de Schepper van hemel en aarde, ");
INSERT INTO nldnbg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","en geprezen zij God, de Allerhoogste, die uw vijanden in uw macht heeft overgeleverd. En hij gaf hem van alles de tienden. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","De koning van Sodom nu zeide tot Abram: Geef mij de mensen, en behoud de have voor u. ");
INSERT INTO nldnbg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Doch Abram zeide tot de koning van Sodom: Ik zweer bij de Here, bij God, de Allerhoogste, de Schepper van hemel en aarde: ");
INSERT INTO nldnbg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Zelfs geen draad of schoenriem, ja niets van het uwe zal ik nemen, opdat gij niet kunt zeggen: Ik heb Abram rijk gemaakt! ");
INSERT INTO nldnbg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Geenszins, alleen wat de knechten hebben verteerd en het aandeel der mannen, die met mij gegaan zijn, Aner, Eskol en Mamre, laten die hun aandeel ontvangen. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hierna kwam het woord des Heren tot Abram in een gezicht: Vrees niet, Abram, Ik ben uw schild; uw loon zal zeer groot zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","En Abram zeide: Here Here, wat zult Gij mij geven, daar ik kinderloos heenga en de bezitter van mijn huis, dat zal deze Damascener Eliëzer zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","En Abram zeide: Zie, mij hebt Gij geen nakroost gegeven, en nu moet een onderhorige mijn erfgenaam zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","En zie, het woord des Heren kwam tot hem: Deze zal uw erfgenaam niet zijn, maar uw lijfelijke zoon, die zal uw erfgenaam zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Toen leidde Hij hem naar buiten, en zeide: Zie toch op naar de hemel en tel de sterren, indien gij ze tellen kunt; en Hij zeide tot hem: Zo zal uw nageslacht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","En hij geloofde in de Here, en Hij rekende het hem toe als gerechtigheid. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","En Hij zeide tot hem: Ik ben de Here, die u uit Ur der Chaldeeën heb geleid om u dit land in bezit te geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","En hij zeide: Here Here, waaraan zal ik weten, dat ik het bezitten zal? ");
INSERT INTO nldnbg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","En Hij zeide tot hem: Haal Mij een driejarige jonge koe, een driejarige geit, een driejarige ram, een tortelduif en een jonge duif. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Hij haalde die alle voor Hem, deelde ze middendoor en legde de stukken tegenover elkander, maar het gevogelte deelde hij niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Toen de roofvogels op de dode dieren neerstreken, joeg Abram ze weg. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Toen de zon op het punt stond onder te gaan, viel een diepe slaap op Abram. En zie, hem overviel een angstwekkende, dikke duisternis. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","En Hij zeide tot Abram: Weet voorzeker, dat uw nakomelingen vreemdelingen zullen zijn in een land, dat het hunne niet is, en dat zij hen dienen zullen, en dat die hen zullen verdrukken, vierhonderd jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Doch ook het volk, dat zij zullen dienen, zal Ik richten, en daarna zullen zij met grote have uittrekken. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Maar gij zult in vrede tot uw vaderen gaan; gij zult in hoge ouderdom begraven worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Het vierde geslacht echter zal hierheen wederkeren, want eerder is de maat van de ongerechtigheid der Amorieten niet vol. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Toen de zon was ondergegaan, en er dikke duisternis was, zie, een rokende oven met een vurige fakkel, welke tussen die stukken doorging. ");
INSERT INTO nldnbg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Te dien dage sloot de Here een verbond met Abram, zeggende: Aan uw nageslacht zal Ik dit land geven, van de rivier van Egypte tot de grote rivier, de rivier de Eufraat: ");
INSERT INTO nldnbg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","de Keniet, de Kenizziet, de Kadmoniet, ");
INSERT INTO nldnbg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","de Hethiet, de Perizziet, de Refaïeten, ");
INSERT INTO nldnbg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","de Amoriet, de Kanaäniet, de Girgasiet en de Jebusiet. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai nu, de vrouw van Abram, schonk hem geen kinderen, en zij had een Egyptische slavin, wier naam was Hagar. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","En Sarai zeide tot Abram: Zie toch, de Here heeft mij niet vergund te baren; ga toch tot mijn slavin; misschien zal ik uit haar gebouwd worden. En Abram luisterde naar Sarai. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","En Sarai, de vrouw van Abram, nam Hagar, de Egyptische, haar slavin, nadat Abram tien jaar in het land Kanaän gewoond had, en gaf haar aan haar man Abram tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","En hij ging tot Hagar en zij werd zwanger; toen zij zag, dat zij zwanger geworden was, was haar meesteres verachtelijk in haar ogen. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Toen zeide Sarai tot Abram: De krenking mij aangedaan, komt voor uw rekening; ik heb mijn slavin in uw schoot gegeven, en nu zij ziet, dat zij zwanger geworden is, ben ik verachtelijk in haar ogen; de Here doe recht tussen mij en u. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","En Abram zeide tot Sarai: Zie, uw slavin is in uw macht; doe met haar wat goed is in uw ogen. Toen vernederde Sarai haar, en zij vluchtte van haar weg. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","En de Engel des Heren trof haar aan bij een waterbron in de woestijn, bij de bron aan de weg naar Sur. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","En Hij zeide: Hagar, slavin van Sarai, vanwaar komt gij en waarheen gaat gij? En zij zeide: Ik ben op de vlucht voor mijn meesteres Sarai. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","En de Engel des Heren zeide tot haar: Keer naar uw meesteres terug en verneder u onder haar hand. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","En de Engel des Heren zeide tot haar: Ik zal uw nageslacht zeer talrijk maken, zodat het vanwege de menigte niet geteld kan worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Voorts zeide de Engel des Heren tot haar: Zie, gij zijt zwanger, en zult een zoon baren, en hem Ismaël noemen, want de Here heeft naar uw ellende gehoord. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hij zal een wilde ezel van een mens zijn; zijn hand zal tegen allen zijn en de hand van allen tegen hem, en hij zal ten aanschouwen van al zijn broederen wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Toen noemde zij de naam des Heren, die tot haar gesproken had: Gij zijt een God des aanziens; want, zeide zij, heb ik hier ook omgezien naar Hem, die naar mij ziet? ");
INSERT INTO nldnbg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Daarom noemt men die put: de put Lachai-Roï; zie, hij is tussen Kades en Bered. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","En Hagar baarde Abram een zoon en Abram noemde de zoon, die Hagar gebaard had, Ismaël. ");
INSERT INTO nldnbg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","En Abram was zesentachtig jaar oud, toen Hagar Ismaël aan Abram baarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Toen Abram negenennegentig jaar oud was, verscheen de Here aan Abram en zeide tot hem: Ik ben God, de Almachtige, wandel voor mijn aangezicht, en wees onberispelijk; ");
INSERT INTO nldnbg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ik zal mijn verbond tussen Mij en u stellen, en u uitermate talrijk maken. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Toen wierp Abram zich op zijn aangezicht en God sprak tot hem: ");
INSERT INTO nldnbg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Wat Mij aangaat, zie, mijn verbond is met u, en gij zult de vader van een menigte volken worden; ");
INSERT INTO nldnbg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","en gij zult niet meer Abram genoemd worden, maar uw naam zal zijn Abraham, omdat Ik u tot een vader van een menigte volken gesteld heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ik zal u uitermate vruchtbaar maken en u tot volken stellen, en koningen zullen uit u voortkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ik zal mijn verbond oprichten tussen Mij en u en uw nageslacht in hun geslachten, tot een eeuwig verbond, om u en uw nageslacht tot een God te zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ik zal aan u en uw nageslacht het land, waarin gij als vreemdeling vertoeft, het ganse land Kanaän, tot een altoosdurende bezitting geven, en Ik zal hun tot een God zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Voorts zeide God tot Abraham: En wat u aangaat, gij zult mijn verbond houden, gij en uw nageslacht, in hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dit is mijn verbond, dat gij zult houden tussen Mij en u en uw nageslacht: dat bij u al wat mannelijk is besneden worde; ");
INSERT INTO nldnbg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","gij zult het vlees van uw voorhuid laten besnijden, en dat zal tot een teken van het verbond zijn tussen Mij en u. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Wie acht dagen oud is, zal bij u besneden worden, al wat mannelijk is in uw geslachten: zowel wie in uw huis geboren is, als wie van enige vreemdeling voor geld is gekocht, doch niet van uw nageslacht is. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Wie in uw huis geboren is en wie door u voor geld gekocht is, moet voorzeker besneden worden; zo zal mijn verbond in uw vlees zijn tot een eeuwig verbond. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","En de onbesnedene, de man namelijk, die het vlees van zijn voorhuid niet laat besnijden, die mens zal uitgeroeid worden uit zijn volksgenoten: hij heeft mijn verbond verbroken. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Verder zeide God tot Abraham: Wat uw vrouw Sarai betreft, gij zult haar niet Sarai noemen, maar Sara zal haar naam zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","En Ik zal haar zegenen, en ook zal Ik u uit haar een zoon schenken, ja, Ik zal haar zegenen, zodat zij tot volken worden zal; koningen van volken zullen uit haar voortkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Toen wierp Abraham zich op zijn aangezicht, lachte en zeide bij zichzelf: Zal dan aan een honderdjarige een kind geboren worden, en zal Sara, een negentigjarige, baren? ");
INSERT INTO nldnbg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","En Abraham zeide tot God: Och, mocht Ismaël voor uw aangezicht leven! ");
INSERT INTO nldnbg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Maar God zeide: Neen, maar uw vrouw Sara zal u een zoon baren, en gij zult hem Isaak noemen, en Ik zal mijn verbond met hem oprichten tot een eeuwig verbond, voor zijn nageslacht. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","En wat Ismaël betreft, Ik heb u verhoord; zie, Ik zal hem zegenen, hem vruchtbaar doen zijn en uitermate talrijk maken; twaalf vorsten zal hij verwekken, en Ik zal hem tot een groot volk stellen. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maar mijn verbond zal Ik oprichten met Isaak, die Sara u op deze zelfde tijd in het volgend jaar baren zal. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Toen God geëindigd had met hem te spreken, voer Hij van Abraham op. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Daarop nam Abraham zijn zoon Ismaël en allen die in zijn huis geboren waren, ook allen die door hem voor geld gekocht waren, al wat mannelijk was onder Abrahams huisgenoten, en hij besneed het vlees van hun voorhuid op diezelfde dag, zoals God tot hem gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","En Abraham was negenennegentig jaar oud, toen hij het vlees van zijn voorhuid liet besnijden. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","En zijn zoon Ismaël was dertien jaar oud, toen hij het vlees van zijn voorhuid liet besnijden. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Op diezelfde dag werden Abraham en zijn zoon Ismaël besneden. ");
INSERT INTO nldnbg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","En al zijn huisgenoten, zowel die in zijn huis geboren, als die van een vreemdeling voor geld gekocht waren, werden met hem besneden. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","En de Here verscheen aan hem bij de terebinten van Mamre, terwijl hij op het heetst van de dag in de ingang der tent zat. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","En hij sloeg zijn ogen op en zag, en zie, drie mannen stonden bij hem; toen hij hen zag, liep hij hun uit de ingang van zijn tent tegemoet, en boog zich ter aarde; ");
INSERT INTO nldnbg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","en hij zeide: Mijn heer, indien ik uw genegenheid gewonnen heb, ga dan niet aan uw knecht voorbij. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Laat toch een weinig water gehaald worden, en wast uw voeten en vlijt u neder onder de boom; ");
INSERT INTO nldnbg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","dan wil ik een bete broods gaan halen, opdat gij uw hart versterkt; daarna kunt gij verder trekken; daartoe zijt gij immers langs uw knecht getrokken? En zij zeiden: Doe zoals gij gesproken hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Toen spoedde Abraham zich naar de tent tot Sara, en zeide: Haast u! Drie maten fijn meel! Kneed het en bereid koeken! ");
INSERT INTO nldnbg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","En Abraham liep naar de runderen, nam een kalf, mals en goed, en gaf het aan een knecht, en deze haastte zich om het te bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ook nam hij boter en melk en het kalf, dat hij bereid had, en zette het hun voor; en hij stond onder de boom bij hen, terwijl zij aten. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Toen zeiden zij tot hem: Waar is uw vrouw Sara? En hij zeide: Daar, in de tent. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","En Hij zeide: Voorzeker zal Ik over een jaar tot u wederkeren, en dan zal uw vrouw Sara een zoon hebben. En Sara luisterde bij de ingang der tent, die zich achter Hem bevond. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham nu en Sara waren oud en hoogbejaard; het ging Sara niet meer naar de wijze der vrouwen. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Dus lachte Sara in zichzelf, denkende: Zal ik wellust hebben, nadat ik vervallen ben, terwijl mijn heer oud is? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Toen zeide de Here tot Abraham: Waarom lacht Sara daar en zegt: Zal ik werkelijk baren, terwijl ik oud geworden ben? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Zou voor de Here iets te wonderlijk zijn? Te bestemder tijd, over een jaar, zal Ik tot u wederkeren, en Sara zal een zoon hebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Toen loochende Sara het: Ik heb niet gelachen, want zij was bevreesd; doch Hij zeide: Neen, gij hebt wèl gelachen. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Toen vertrokken die mannen vandaar en zagen in de richting van Sodom; en Abraham ging met hen mede om hen uitgeleide te doen. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","En de Here dacht: Zou Ik voor Abraham verbergen wat Ik ga doen? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham immers zal voorzeker tot een groot en machtig volk worden en met hem zullen alle volken der aarde gezegend worden; ");
INSERT INTO nldnbg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","want Ik heb hem gekend, opdat hij gebieden zou, dat zijn zonen en zijn huis na hem de weg des Heren zouden bewaren door gerechtigheid en recht te doen, opdat de Here aan Abraham vervulle wat Hij over hem gesproken heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Daarop zeide de Here: Het geroep over Sodom en Gomorra is voorwaar groot, en haar zonde is voorwaar zeer zwaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ik wil nederdalen om te zien, of zij inderdaad gedaan hebben naar het geroep, dat tot Mij gekomen is, of niet; Ik wil het weten. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Toen wendden die mannen zich vandaar en gingen naar Sodom, maar Abraham bleef nog staan voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","En Abraham trad nader en zeide: Zult Gij dan de rechtvaardige met de goddeloze verdelgen? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Misschien zullen er vijftig rechtvaardigen in de stad zijn; zult Gij haar dan verdelgen, en aan de plaats geen vergiffenis schenken ter wille van de vijftig rechtvaardigen, die in haar zijn? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Het zij verre van U, aldus te handelen, de rechtvaardige te doden met de goddeloze, zodat de rechtvaardige zou zijn gelijk de goddeloze; verre zij het van U; zou de Rechter der ganse aarde geen recht doen? ");
INSERT INTO nldnbg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","En de Here zeide: Indien Ik te Sodom vijftig rechtvaardigen in de stad vind, zal Ik de gehele plaats vergiffenis schenken om hunnentwil. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","En Abraham antwoordde: Zie toch, ik heb mij verstout tot de Here te spreken, hoewel ik stof en as ben. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Misschien ontbreken er aan de vijftig rechtvaardigen vijf; zult Gij dan om die vijf de gehele stad verwoesten? En Hij zeide: Ik zal haar niet verwoesten, indien Ik er vijfenveertig vind. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","En hij sprak verder tot Hem en zeide: Misschien worden er daar veertig gevonden. En Hij zeide: Ik zal het niet doen ter wille van de veertig. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","En hij zeide: De Here worde toch niet toornig, als ik nog eens spreek; misschien worden er daar dertig gevonden. En Hij zeide: Ik zal het niet doen, indien Ik er daar dertig vind. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","En hij zeide: Zie toch, ik heb mij verstout tot de Here te spreken; misschien worden er daar twintig gevonden. En Hij zeide: Ik zal haar niet verwoesten ter wille van de twintig. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","En hij zeide: De Here worde toch niet toornig, als ik nog eenmaal spreek; misschien worden er daar tien gevonden. En Hij zeide: Ik zal haar niet verwoesten ter wille van de tien. ");
INSERT INTO nldnbg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Toen ging de Here weg, nadat Hij geëindigd had tot Abraham te spreken, en Abraham keerde naar zijn woonplaats terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","En de twee engelen kwamen in de avond te Sodom. Lot zat in de poort van Sodom en toen Lot hen zag, stond hij op, ging hun tegemoet, boog zich neder met het aangezicht ter aarde, ");
INSERT INTO nldnbg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","en zeide: Zie toch, mijne heren, neemt toch uw intrek in het huis van uw knecht, overnacht en wast uw voeten, dan kunt gij morgenvroeg uws weegs gaan. Maar zij zeiden: Neen, wij zullen de nacht op het plein doorbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Toen hij echter sterk bij hen aandrong, namen zij bij hem hun intrek en kwamen in zijn huis; en hij bereidde voor hen een maaltijd en bakte ongezuurde koeken, en zij aten. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Zij hadden zich nog niet ter ruste gelegd, of de mannen der stad, de mannen van Sodom, omsingelden het huis, van jong tot oud, de gehele bevolking, niemand uitgezonderd, ");
INSERT INTO nldnbg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","en zij riepen Lot toe en zeiden tot hem: Waar zijn de mannen, die vannacht bij u gekomen zijn? Breng hen bij ons buiten, opdat wij met hen gemeenschap hebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Toen ging Lot tot hen naar buiten, maar de deur sloot hij achter zich toe, ");
INSERT INTO nldnbg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","en hij zeide: Mijn broeders, doet toch geen kwaad; ");
INSERT INTO nldnbg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","zie toch, ik heb twee dochters, die met geen man gemeenschap hebben gehad; laat mij die tot u naar buiten brengen en doet met haar, zoals goed is in uw ogen; alleen doet deze mannen niets, want daartoe zijn zij onder de schaduw van mijn dak gekomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Maar zij zeiden: Ga op zij! En zij zeiden: Deze ene is als vreemdeling komen vertoeven om ons geheel en al de wet te stellen! Nu zullen wij u meer kwaad doen dan hun. En zij drongen sterk op tegen de man, tegen Lot, en kwamen naderbij om de deur open te breken. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Maar die mannen staken hun hand uit, trokken Lot tot zich naar binnen en sloten de deur. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","En de lieden, die bij de ingang van het huis waren, sloegen zij met blindheid, van klein tot groot, zodat zij zich tevergeefs moeite gaven om de ingang te vinden. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Toen zeiden die mannen tot Lot: Wie hebt gij hier nog meer? Schoonzoons, of uw zonen, uw dochters, of wie gij ook in de stad hebt, voer hen uit deze plaats, ");
INSERT INTO nldnbg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","want wij gaan deze plaats verwoesten; want groot is het geroep over haar voor de Here; daarom heeft de Here ons gezonden om haar te verwoesten. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Toen ging Lot heen en sprak tot zijn schoonzoons, die met zijn dochters zouden trouwen, en zeide: Staat op, verlaat deze plaats, want de Here gaat de stad verwoesten. Maar hij was in de ogen van zijn schoonzoons als iemand, die schertste. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Toen de dageraad gekomen was, drongen de engelen bij Lot op spoed aan en zeiden: Sta op, neem uw vrouw en uw beide dochters, die zich hier bevinden, opdat gij niet vanwege de ongerechtigheid der stad verdelgd wordt. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","En toen hij talmde, grepen de mannen hem en zijn vrouw en zijn beide dochters bij de hand, omdat de Here hem wilde sparen, en leidden hem uit en brachten hem buiten de stad. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","En zodra zij hen naar buiten geleid hadden, zeide een van hen: Vlucht om uws levens wil; zie niet om, en sta nergens in de Streek stil; vlucht naar het gebergte, opdat gij niet verdelgd wordt. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","En Lot zeide tot hen: Neen toch, mijn heer. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Zie toch, uw knecht heeft genade gevonden in uw ogen, en gij hebt mij een grote weldaad bewezen door mij in het leven te behouden, maar ik zal niet naar het gebergte kunnen ontkomen, zonder dat het onheil mij achterhaalt en ik sterf. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Zie toch, gindse stad is dicht genoeg bij om daarheen de wijk te nemen; zij is maar klein; laat mij toch daarheen vluchten; zij is immers klein? Dan zal ik in het leven blijven. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Toen zeide hij tot hem: Zie, ik zal u ook in dit opzicht ter wille zijn, dat ik de stad, waarvan gij gesproken hebt, niet zal omkeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haast u, vlucht daarheen, want ik zal niets kunnen doen, voordat gij daar aangekomen zijt. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Daarom noemt men die stad Soar. De zon was over de aarde opgegaan, toen Lot te Soar aankwam. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Toen liet de Here zwavel en vuur op Sodom en Gomorra regenen, van de Here, uit de hemel; ");
INSERT INTO nldnbg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","en Hij keerde die steden om, benevens de gehele Streek, met al de inwoners der steden en het gewas van de aardbodem. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Maar zijn vrouw, die achter hem liep, zag om, en werd een zoutpilaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Toen Abraham zich vroeg in de morgen begaf naar de plaats, waar hij voor de Here gestaan had, ");
INSERT INTO nldnbg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","en uitzag in de richting van Sodom en Gomorra en het gehele land van de Streek, zag hij, en zie, de rook van de aarde steeg op als de rook van een smeltoven. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Toen God de steden der Streek verwoestte, gedacht God Abraham, en Hij leidde Lot uit het midden der omkering, toen Hij de steden waarin Lot gewoond had, omkeerde. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","En Lot trok op uit Soar en vestigde zich met zijn beide dochters op het gebergte, want hij durfde niet in Soar te blijven, en hij ging wonen in een spelonk, hij met zijn beide dochters. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","En de eerstgeborene zeide tot de jongste: Onze vader is oud, en daar is geen man in het land om tot ons te komen, naar de gewoonte der gehele aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, laten wij onze vader wijn te drinken geven en bij hem nederliggen, opdat wij door onze vader aan nakroost het leven geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Toen gaven zij in die nacht haar vader wijn te drinken, en de eerstgeborene ging naar binnen en legde zich bij haar vader neder, zonder dat hij er iets van merkte toen zij zich nederlegde of toen zij opstond. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","En de volgende morgen zeide de eerstgeborene tot de jongste: Zie, ik heb gisterennacht bij mijn vader gelegen; wij zullen hem ook deze nacht wijn te drinken geven, en ga gij dan naar binnen, en leg u bij hem neder, opdat wij door onze vader aan nakroost het leven geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Zo gaven zij haar vader ook die nacht wijn te drinken, en de jongste stond op en legde zich bij hem neder, zonder dat hij er iets van merkte, toen zij zich nederlegde of toen zij opstond. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","En de beide dochters van Lot werden zwanger van haar vader. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","En de eerstgeborene baarde een zoon, en noemde hem Moab; hij is de vader van de tegenwoordige Moabieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ook de jongste baarde een zoon, en noemde hem Ben-Ammi; hij is de vader van de tegenwoordige Ammonieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham nu brak vandaar op naar het Zuiderland en vestigde zich tussen Kades en Sur, en vertoefde als vreemdeling in Gerar. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Daar Abraham van zijn vrouw Sara gezegd had: Zij is mijn zuster, liet Abimelek, de koning van Gerar, Sara weghalen. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Maar God kwam des nachts in een droom tot Abimelek en zeide tot hem: Zie, gij zijt een kind des doods, omdat gij die vrouw genomen hebt, want zij is gehuwd. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek nu was niet tot haar genaderd. En hij zeide: Here, zult Gij dan een rechtvaardig volk doden? ");
INSERT INTO nldnbg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Heeft hij zelf niet tot mij gezegd: Zij is mijn zuster? En zij heeft zelf ook gezegd: Hij is mijn broeder; in onschuld mijns harten en reinheid mijner handen heb ik dit gedaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","En God zeide tot hem in de droom: Ik weet ook, dat gij het in onschuld uws harten gedaan hebt, Ik heb u dan ook ervan weerhouden tegen Mij te zondigen; daarom heb Ik u niet toegelaten haar aan te raken. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","En nu breng de vrouw van deze man terug, want hij is een profeet; dan zal hij voor u bidden, opdat gij in het leven moogt blijven; maar indien gij haar niet terugbrengt, weet, dat gij voorzeker zult sterven, gij en al de uwen. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","De volgende morgen vroeg riep Abimelek al zijn dienaren en bracht dit alles te hunner kennis, en de mannen werden zeer bevreesd. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Voorts riep Abimelek Abraham en zeide tot hem: Wat hebt gij ons aangedaan, en waarin heb ik tegen u gezondigd, dat gij over mij en mijn koninkrijk een grote zonde hebt gebracht? Gij hebt tegenover mij dingen gedaan, die niet gedaan mochten worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ook zeide Abimelek tot Abraham: Wat hebt gij beoogd, dat gij dit deedt? ");
INSERT INTO nldnbg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Toen zeide Abraham: Ik dacht: wellicht is er geen vreze Gods in deze plaats; zij zullen mij doden om mijn vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","En bovendien is zij werkelijk mijn zuster; zij is de dochter van mijn vader, maar niet de dochter van mijn moeder; en zij is mij tot vrouw geworden. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Toen God mij uit mijns vaders huis liet omzwerven, zeide ik tot haar: Dit zal de liefdedienst zijn, die gij mij bewijzen zult: zeg van mij op elke plaats, waar wij komen: hij is mijn broeder. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Toen nam Abimelek schapen en runderen, slaven en slavinnen, en schonk die aan Abraham, en hij gaf hem zijn vrouw Sara terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","En Abimelek zeide: Zie, mijn land staat voor u open, vestig u, waar het u goeddunkt. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","En tot Sara zeide hij: Zie, ik geef aan uw broeder duizend zilverstukken; zie, dat zal voor u de ogen bedekken van allen die bij u zijn; en gij zult gerechtvaardigd zijn, ja, in elk opzicht. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Toen bad Abraham tot God, en God genas Abimelek en zijn vrouw en zijn slavinnen, zodat zij baarden. ");
INSERT INTO nldnbg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","De Here had namelijk elke moederschoot in Abimeleks huis toegesloten ter oorzake van Sara, de vrouw van Abraham. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","De Here bezocht Sara, zoals Hij gezegd had, en de Here deed aan Sara, zoals Hij gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","En Sara werd zwanger, en zij baarde Abraham een zoon in zijn ouderdom, te bestemder tijd, waarvan God tot hem gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","En Abraham noemde de zoon, die hem geboren was, die Sara hem gebaard had, Isaak. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","En Abraham besneed zijn zoon Isaak, toen hij acht dagen oud was, zoals God hem geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham nu was honderd jaar oud, toen hem zijn zoon Isaak geboren werd. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","En Sara zeide: God heeft gemaakt, dat ik lach; ieder die het hoort, zal om mijnentwil lachen. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","En zij zeide: Wie had aan Abraham durven toezeggen: Sara zoogt kinderen? Want ik heb een zoon gebaard in zijn ouderdom. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","En het kind groeide op en werd gespeend, en Abraham richtte een grote maaltijd aan op de dag dat Isaak gespeend werd. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Toen zag Sara, dat de zoon van Hagar, de Egyptische, die zij Abraham gebaard had, spotte, ");
INSERT INTO nldnbg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","en zij zeide tot Abraham: Jaag die slavin met haar zoon weg, want de zoon van deze slavin zal niet erven met mijn zoon, met Isaak. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dit nu mishaagde Abraham zeer ter wille van zijn zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maar God zeide tot Abraham: Laat dit niet kwaad zijn in uw ogen, om de jongen en om uw slavin; in alles wat Sara tot u zegt, moet gij naar haar luisteren, want door Isaak zal men van uw nageslacht spreken. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Maar ook de zoon der slavin zal Ik tot een volk stellen, omdat hij uw nakomeling is. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","De volgende morgen vroeg nam Abraham brood en een zak water, en gaf het aan Hagar, dat leggende op haar schouder, alsook het kind, en hij zond haar weg; daarop ging zij heen en dwaalde door de woestijn van Berseba. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Toen het water uit de zak op was, wierp zij het kind onder één der struiken, ");
INSERT INTO nldnbg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","en ging op een afstand zitten, zo ver als een boogschot reikt, want zij zeide: Ik kan het sterven van het kind niet aanzien. Terwijl zij op een afstand zat, verhief zij haar stem en weende. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","En God hoorde de stem van de jongen, en de Engel Gods riep van de hemel tot Hagar en zeide tot haar: Wat deert u, Hagar? Vrees niet, want God heeft naar de stem van de jongen gehoord, daar waar hij is. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Sta op, neem de jongen op, en houd hem vast met uw hand, want Ik zal hem tot een groot volk stellen. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Toen opende God haar ogen, en zij zag een waterput; zij ging de zak met water vullen en liet de jongen drinken. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","En God was met de jongen en hij groeide op; hij ging in de woestijn wonen en werd een boogschutter. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","En hij woonde in de woestijn Paran, en zijn moeder nam voor hem een vrouw uit het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","In die tijd zeide Abimelek, alsook zijn legeroverste Pikol, tot Abraham: God is met u in alles wat gij doet. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nu dan, zweer mij toch hier bij God, dat gij niet bedrieglijk met mij zult handelen, noch met mijn kroost, noch met mijn nageslacht; naar de vriendschap, die ik u betoond heb, zult gij mij en het land waarin gij als gast vertoeft, behandelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","En Abraham zeide: Ik zweer het. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Maar Abraham maakte Abimelek een verwijt over een waterput, die de knechten van Abimelek zich hadden toegeëigend. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Daarop zeide Abimelek: Ik weet niet, wie dat gedaan heeft; ook hebt gij het mij niet meegedeeld, en ik heb het ook niet vernomen vóór vandaag. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Toen nam Abraham schapen en runderen en gaf ze aan Abimelek, en die beiden sloten een verbond. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Maar Abraham zette zeven lammeren van de schapen afzonderlijk. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Toen zeide Abimelek tot Abraham: Wat betekenen die zeven lammeren hier, die gij afzonderlijk gezet hebt? ");
INSERT INTO nldnbg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","En hij zeide: Voorzeker moet gij de zeven lammeren uit mijn hand aannemen, opdat het mij tot een getuigenis zij, dat ik deze put gegraven heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daarom noemt men die plaats Berseba, want die beiden hebben daar gezworen. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Toen zij te Berseba het verbond gesloten hadden, gingen Abimelek en zijn legeroverste Pikol heen, en keerden naar het land der Filistijnen terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","En (Abraham) plantte te Berseba een tamarisk, en riep daar de naam van de Here, de eeuwige God, aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","En Abraham vertoefde vele dagen als vreemdeling in het land der Filistijnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hierna gebeurde het, dat God Abraham op de proef stelde. Hij zeide tot hem: Abraham, en deze zeide: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","En Hij zeide: Neem toch uw zoon, uw enige, die gij liefhebt, Isaak, en ga naar het land Moria, en offer hem daar tot een brandoffer op een der bergen, die Ik u noemen zal. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Toen stond Abraham des morgens vroeg op, zadelde zijn ezel, en nam twee van zijn knechten met zich, benevens zijn zoon Isaak; hij kloofde hout voor het brandoffer, begaf zich op weg en ging naar de plaats, die God hem genoemd had. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Toen Abraham op de derde dag zijn ogen opsloeg, zag hij die plaats in de verte. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","En Abraham zeide tot zijn knechten: Blijft gij hier met de ezel, terwijl ik en de jongen daarginds heengaan; wanneer we hebben aangebeden, zullen wij tot u terugkeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Toen nam Abraham het hout voor het brandoffer, legde het op zijn zoon Isaak, en nam vuur en een mes met zich mede. Zo gingen die beiden tezamen. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Toen sprak Isaak tot zijn vader Abraham en zeide: Mijn vader, en deze zeide: Hier ben ik, mijn zoon. En hij zeide: Hier is het vuur en het hout, maar waar is het lam ten brandoffer? ");
INSERT INTO nldnbg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","En Abraham zeide: God zal Zichzelf voorzien van een lam ten brandoffer, mijn zoon. Zo gingen die beiden tezamen. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Toen zij aan de plaats die God hem genoemd had, gekomen waren, bouwde Abraham daar een altaar, schikte het hout, bond zijn zoon Isaak en legde hem op het altaar boven op het hout. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Daarop strekte Abraham zijn hand uit en nam het mes om zijn zoon te slachten. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Maar de Engel des Heren riep tot hem van de hemel en zeide: Abraham, Abraham! En hij zeide: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","En Hij zeide: Strek uw hand niet uit naar de jongen en doe hem niets, want nu weet Ik, dat gij godvrezend zijt, en uw zoon, uw enige, Mij niet hebt onthouden. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Toen sloeg Abraham zijn ogen op en daar zag hij een ram achter zich, met zijn horens verward in het struikgewas. En Abraham ging en nam de ram en offerde hem ten brandoffer in plaats van zijn zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","En Abraham noemde die plaats: De Here zal erin voorzien; waarom nog heden gezegd wordt: Op de berg des Heren zal erin voorzien worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Toen riep de Engel des Heren ten tweeden male van de hemel tot Abraham en zeide: ");
INSERT INTO nldnbg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ik zweer bij Mijzelf, luidt het woord des Heren: omdat gij dit gedaan hebt, en uw zoon, uw enige, Mij niet onthouden hebt, ");
INSERT INTO nldnbg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","zal Ik u rijkelijk zegenen, en uw nageslacht zeer talrijk maken, als de sterren des hemels en als het zand aan de oever der zee, en uw nageslacht zal de poort zijner vijanden in bezit nemen. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","En met uw nageslacht zullen alle volken der aarde gezegend worden, omdat gij naar mijn stem gehoord hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Toen keerde Abraham terug tot zijn knechten, en zij gingen tezamen op weg naar Berseba, en Abraham woonde te Berseba. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hierna werd aan Abraham bericht: Zie, ook Milka heeft Nachor, uw broeder, zonen gebaard: ");
INSERT INTO nldnbg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","zijn eerstgeborene Us, diens broeder Buz, en Kemuël, de vader van Aram, ");
INSERT INTO nldnbg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","en Kesed, Chazo, Pildas, Jidlaf en Betuël. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","En Betuël verwekte Rebekka. Deze acht heeft Milka aan Nachor, de broeder van Abraham, gebaard. ");
INSERT INTO nldnbg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","En ook zijn bijvrouw, wier naam was Reüma, baarde (zonen), Tebach, Gacham, Tachas en Maäka. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","En Sara leefde honderd zevenentwintig jaar; dit waren de jaren van Sara’s leven. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","En Sara stierf te Kirjat-Arba, dat is Hebron, in het land Kanaän, en Abraham ging naar binnen om over Sara te weeklagen en haar te bewenen. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Toen stond Abraham op, en ging heen van zijn dode, en sprak tot de Hethieten: ");
INSERT INTO nldnbg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Een vreemdeling en bijwoner ben ik bij u, geeft mij een eigen grafstede bij u, opdat ik mijn dode moge uitdragen en begraven. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Toen antwoordden de Hethieten Abraham en zeiden tot hem: ");
INSERT INTO nldnbg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Luister naar ons, mijn heer, een vorst Gods zijt gij in ons midden: begraaf uw dode in de keur onzer grafsteden; niemand van ons zal u zijn grafstede weigeren om uw dode te begraven. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Daarna stond Abraham op, wierp zich neder voor het volk des lands, de Hethieten, en sprak tot hen: ");
INSERT INTO nldnbg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Indien het naar uw wil is, dat ik mijn dode uitdrage en begrave, luistert dan naar mij en dringt voor mij bij Efron, de zoon van Sochar, erop aan, ");
INSERT INTO nldnbg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","dat hij mij de spelonk van Makpela geve, welke hem toebehoort en aan het einde van zijn veld ligt; hij geve mij die voor de volle prijs tot een eigen grafstede onder u. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron nu was een gezeten man onder de Hethieten. En de Hethiet Efron antwoordde Abraham ten aanhoren van de Hethieten, van allen die de poort zijner stad ingingen: ");
INSERT INTO nldnbg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Neen, mijn heer, luister naar mij; het veld geef ik u en de spelonk aldaar geef ik u: in tegenwoordigheid van mijn volksgenoten geef ik het u; begraaf uw dode. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Toen wierp Abraham zich neder voor het volk des lands, ");
INSERT INTO nldnbg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","en sprak tot Efron ten aanhoren van het volk des lands: Waarlijk, indien gij (genegen) zijt, luister dan naar mij: ik geef de prijs van het veld; neem die van mij aan, opdat ik mijn dode daar begrave. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","En Efron antwoordde Abraham en zeide tot hem: ");
INSERT INTO nldnbg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Och, mijn heer, luister naar mij: een stuk land van vierhonderd sikkelen zilver, wat maakt dat uit tussen mij en u? Begraaf toch uw dode. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Toen hoorde Abraham naar Efron, en Abraham woog aan Efron het geld af, waarvan hij gesproken had ten aanhoren der Hethieten, vierhonderd sikkelen zilver, gangbaar bij de koopman. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Zo ging het veld van Efron, dat in Makpela tegenover Mamre ligt, het veld en de spelonk aldaar, en al het geboomte op het veld, op het gehele terrein ervan rondom, ");
INSERT INTO nldnbg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","in eigendom aan Abraham over, in tegenwoordigheid van de Hethieten, van allen die de poort zijner stad ingingen. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Daarna heeft Abraham zijn vrouw Sara begraven in de spelonk van het veld van Makpela, tegenover Mamre, dat is Hebron, in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Zo is het veld met de spelonk aldaar van de Hethieten aan Abraham overgegaan tot een eigen grafstede. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham nu was oud en hoogbejaard, en de Here had Abraham in alles gezegend. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","En Abraham zeide tot zijn knecht, de oudste in zijn huis, die alles wat hij had bestuurde: Leg toch uw hand onder mijn heup, ");
INSERT INTO nldnbg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","opdat ik u doe zweren bij de Here, de God des hemels en der aarde, dat gij voor mijn zoon geen vrouw zult nemen uit de dochters der Kanaänieten, in wier midden ik woon. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Maar gij zult naar mijn land en naar mijn maagschap gaan om een vrouw te nemen voor mijn zoon Isaak. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Toen zeide de knecht tot hem: Misschien zal die vrouw mij niet willen volgen naar dit land; moet ik dan uw zoon terugbrengen naar het land, vanwaar gij uitgetrokken zijt? ");
INSERT INTO nldnbg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Maar Abraham zeide tot hem: Wacht u ervoor mijn zoon daarheen terug te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","De Here, de God des hemels, die mij genomen heeft uit mijns vaders huis en uit het land mijner maagschap, en die tot mij gesproken heeft, en mij heeft gezworen: aan uw nageslacht zal Ik dit land geven – Hij zal zijn engel voor uw aangezicht zenden, en gij zult vandaar voor mijn zoon een vrouw nemen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Indien echter die vrouw u niet wil volgen, zult gij van deze eed aan mij ontslagen zijn; alleen, gij zult mijn zoon daarheen niet terugbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Toen legde de knecht zijn hand onder de heup van zijn heer Abraham, en zwoer hem, wat hij gevraagd had. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hierop nam de knecht tien van de kamelen van zijn heer en ging op weg met allerlei kostbaarheden van zijn heer bij zich; hij maakte zich op en ging naar Mesopotamië, naar de stad van Nachor. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","En hij liet de kamelen neerknielen buiten de stad bij een waterput, tegen de avond, de tijd, dat de vrouwen uitgaan om te putten. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Toen zeide hij: Here, God van mijn heer Abraham, laat mij toch heden slagen en bewijs genade aan mijn heer Abraham. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ik sta hier bij de waterbron, en de dochters van de mannen der stad gaan uit om water te putten. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Laat het nu zo zijn, dat het meisje, tot wie ik zeg: Neig toch uw kruik, opdat ik drinke, en dat zegt: Drink, en ook uw kamelen zal ik drenken, – dat Gij haar hebt bestemd voor uw knecht Isaak; dan zal ik daaraan weten, dat Gij genade bewezen hebt aan mijn heer. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Hij was nog niet uitgesproken, of zie, Rebekka, die geboren was aan Betuël, de zoon van Milka, de vrouw van Nachor, de broeder van Abraham, kwam naar buiten met haar kruik op haar schouder. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","En het meisje was zeer schoon van uiterlijk, een maagd, met wie geen man gemeenschap had gehad. Zij daalde af naar de bron, vulde haar kruik, en kwam naar boven. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Toen liep de knecht haar tegemoet en zeide: Laat mij toch een weinig water drinken uit uw kruik. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Daarop zeide zij: Drink, mijn heer, en zij liet haar kruik snel op haar hand neerglijden, en gaf hem te drinken. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Toen zij hem genoeg had laten drinken, zeide zij: Ik zal ook voor uw kamelen putten, totdat zij genoeg gedronken hebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Daarop goot zij snel haar kruik leeg in de drinkbak, liep andermaal naar de put om te scheppen en putte voor al zijn kamelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","En de man sloeg haar zwijgend gade om te weten, of de Here zijn weg voorspoedig gemaakt had of niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Toen de kamelen genoeg gedronken hadden, nam de man een gouden ring van een halve sikkel in gewicht, en twee armbanden van tien halve sikkelen goud in gewicht, ");
INSERT INTO nldnbg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","en hij zeide: Wiens dochter zijt gij? Vertel het mij toch. Is er in uws vaders huis voor ons plaats om te overnachten? ");
INSERT INTO nldnbg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Daarop zeide zij tot hem: Ik ben de dochter van Betuël, de zoon van Milka, die zij Nachor gebaard heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Verder zeide zij tot hem: Er is bij ons zowel stro als voeder in overvloed, ook plaats om te overnachten. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Toen boog de man zijn knieën en wierp zich neder voor de Here, ");
INSERT INTO nldnbg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","en zeide: Geprezen zij de Here, de God van mijn heer Abraham, die zijn goedertierenheid en trouw niet onttrokken heeft aan mijn heer; wat mij aangaat, de Here heeft mij geleid op de weg naar het huis der broeders van mijn heer. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","En het meisje snelde heen en verhaalde het gebeurde aan haar moeders huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekka nu had een broeder, die Laban heette. En Laban snelde naar de man, naar buiten, bij de bron. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Zodra hij namelijk de ring gezien had en de armbanden aan de handen van zijn zuster, en zodra hij de woorden van zijn zuster Rebekka gehoord had: Zo heeft die man tot mij gesproken, ging hij naar de man toe; en zie, deze stond bij de kamelen aan de bron. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","En hij zeide: Kom, gij gezegende des Heren, waarom staat gij buiten, terwijl ik reeds het huis gereed gemaakt heb en ook de plaats voor de kamelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Toen kwam de man in huis. En men ontzadelde de kamelen, gaf aan de kamelen stro en voeder en bracht water om zijn voeten en de voeten der mannen die bij hem waren, te wassen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Maar toen hem te eten werd voorgezet, zeide hij: Ik zal niet eten, voordat ik mijn woord gesproken heb. En hij zeide: Spreek. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Daarop zeide hij: Ik ben de knecht van Abraham. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","De Here heeft mijn heer zeer gezegend, zodat hij rijk geworden is; Hij heeft hem gegeven kleinvee en runderen, zilver en goud, slaven en slavinnen, kamelen en ezels. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","En Sara, de vrouw van mijn heer, heeft mijn heer een zoon gebaard, nadat zij oud geworden was, en hij heeft hem gegeven alles wat hij bezit. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nu heeft mijn heer mij doen zweren: Gij zult voor mijn zoon geen vrouw nemen uit de dochters der Kanaänieten, in wier land ik woon, ");
INSERT INTO nldnbg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","maar gij zult naar mijns vaders huis gaan en naar mijn geslacht, en daar een vrouw voor mijn zoon nemen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","En ik zeide tot mijn heer: Misschien zal die vrouw mij niet volgen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Maar hij zeide tot mij: De Here, voor wiens aangezicht ik gewandeld heb, zal zijn engel met u zenden, en zal uw weg voorspoedig maken, zodat gij voor mijn zoon een vrouw zult nemen uit mijn geslacht en uit mijns vaders huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Slechts dan zult gij ontslagen zijn van de eed aan mij, wanneer gij komt tot mijn geslacht, en men haar aan u niet wil geven; dan zult gij ontslagen zijn van de eed aan mij. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nu kwam ik heden bij de bron, en ik zeide: Here, God van mijn heer Abraham, wil toch de weg, waarop ik ga, voorspoedig maken; ");
INSERT INTO nldnbg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","zie, ik sta bij de waterbron; laat het nu zo zijn dat de maagd, die naar buiten komt om te putten en die, als ik tot haar zeg: Geef mij toch een weinig water te drinken uit uw kruik, tot mij zal zeggen: ");
INSERT INTO nldnbg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Drink zelf, en ook voor uw kamelen zal ik putten, dat zij de vrouw zal zijn, die de Here voor de zoon van mijn heer bestemd heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ik had dit nog nauwelijks bij mijzelf gezegd, of zie, Rebekka kwam naar buiten met haar kruik op haar schouder, en zij daalde af naar de bron, en putte. En ik zeide tot haar: Geef mij toch te drinken. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Toen liet zij snel haar kruik neerglijden en zij zeide: Drink, en ook uw kamelen zal ik drenken. Toen dronk ik, en ook de kamelen drenkte zij. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Daarop vroeg ik haar en zeide: Wiens dochter zijt gij? En zij zeide: De dochter van Betuël, de zoon van Nachor, die Milka hem gebaard heeft. Toen deed ik de ring aan haar neus, en de armbanden aan haar handen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ik boog mijn knieën en wierp mij neder voor de Here, en ik prees de Here, de God van mijn heer Abraham, die mij op de rechte weg geleid had om de dochter van de broeder van mijn heer voor zijn zoon te nemen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","En nu, indien gij liefde en trouw wilt bewijzen aan mijn heer, laat het mij weten; en zo niet, laat het mij ook weten, opdat ik mij naar rechts of naar links wende. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Toen antwoordde Laban, alsook Betuël en zij zeiden: Dit is een bestiering van de Here; wij kunnen niets tot u zeggen, ten kwade of ten goede. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Zie, daar is Rebekka, neem haar en ga heen, opdat zij de vrouw worde van de zoon van uw heer, zoals de Here gesproken heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Toen de knecht van Abraham hun woorden hoorde, wierp hij zich ter aarde neder voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","En de knecht bracht zilveren en gouden sieraden te voorschijn, en klederen, en gaf deze aan Rebekka; ook gaf hij aan haar broeder en aan haar moeder kostbare geschenken. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Daarna aten en dronken zij, hij en de mannen die bij hem waren, en zij overnachtten er.Toen zij des morgens opstonden, zeide hij: Laat mij naar mijn heer gaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Doch haar broeder zeide, alsook haar moeder: Laat het meisje een dag of tien bij ons blijven, ga daarna heen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Hij echter zeide tot hen: Houd mij niet op, nu de Here mijn weg voorspoedig gemaakt heeft; laat mij vertrekken, opdat ik naar mijn heer ga. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Daarop zeiden zij: Laten wij het meisje roepen en het haar zelf vragen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Toen riepen zij Rebekka en zeiden tot haar: Wilt gij met deze man meegaan? En zij zeide: Ja. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Zij dan lieten hun zuster Rebekka en haar voedster en de knecht van Abraham en zijn mannen gaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","En zij zegenden Rebekka en zeiden tot haar: Onze zuster, moogt gij tot duizenden van tienduizenden worden, en uw nageslacht bezitte de poort van zijn haters. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Toen maakte Rebekka zich met haar dienstmaagden gereed en zij reden op kamelen weg, en volgden de man. De knecht nam Rebekka mede en ging heen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","En Isaak kwam uit de richting van de put Lachai-Roï; hij woonde namelijk in het Zuiderland. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaak ging tegen het vallen van de avond uit om te peinzen in het veld. Hij sloeg zijn ogen op, en zag daar kamelen aankomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Toen Rebekka haar ogen opsloeg en Isaak zag, liet zij zich van de kameel glijden. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","En zij zeide tot de knecht: Wie is die man daar, die ons tegemoet komt in het veld? En de knecht zeide: Dat is mijn heer. Daarop nam zij de sluier en bedekte zich. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","En de knecht vertelde Isaak alles wat hij gedaan had. ");
INSERT INTO nldnbg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Toen bracht Isaak haar in de tent van zijn moeder Sara, en hij nam Rebekka, en zij werd hem tot vrouw, en hij kreeg haar lief. Zo vond Isaak troost na de dood van zijn moeder. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","En Abraham nam wederom een vrouw, Ketura geheten. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","En zij baarde hem Zimran, Joksan, Medan, Midjan, Jisbak en Suach. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","En Joksan verwekte Seba en Dedan. En de zonen van Dedan waren de Assurieten, de Letusieten en de Leümieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","En de zonen van Midjan waren Efa, Efer, Chanok, Abida en Eldaä. Deze allen waren de zonen van Ketura. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham nu gaf alles wat hij had aan Isaak, ");
INSERT INTO nldnbg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","maar aan de zonen van de bijvrouwen, die Abraham had, gaf Abraham geschenken, en hij zond hen, nog bij zijn leven, weg van zijn zoon Isaak, oostwaarts, naar het Oosterland. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dit nu was het getal der jaren van Abrahams leven, die hij geleefd heeft: honderd vijfenzeventig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","En Abraham gaf de geest en stierf in hoge ouderdom, oud en van het leven verzadigd, en hij werd vergaderd tot zijn voorgeslacht. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","En zijn zonen Isaak en Ismaël begroeven hem in de spelonk van Makpela, in het veld van Efron, de zoon van de Hethiet Sochar, dat tegenover Mamre gelegen is, ");
INSERT INTO nldnbg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","het veld, dat Abraham van de Hethieten had gekocht; daar werd Abraham begraven, evenals zijn vrouw Sara. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Na de dood van Abraham zegende God zijn zoon Isaak; en Isaak woonde bij de put Lachai-Roï. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dit nu zijn de nakomelingen van Ismaël, de zoon van Abraham, die Hagar, de Egyptische, de slavin van Sara, Abraham gebaard had. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dit zijn dan de namen der zonen van Ismaël, genoemd naar hun afstamming: de eerstgeborene van Ismaël Nebajot, voorts Kedar, Adbeël, Mibsam, ");
INSERT INTO nldnbg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO nldnbg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis en Kedema. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dit zijn dan de zonen van Ismaël, en dit zijn hun namen, naar hun dorpen en hun tentenkampen, twaalf vorsten naar hun volksstammen. – ");
INSERT INTO nldnbg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","En dit waren de jaren van Ismaëls leven: honderd zevenendertig jaar. Toen gaf hij de geest en stierf, en werd vergaderd tot zijn voorgeslacht. – ");
INSERT INTO nldnbg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","En zij woonden van Chawila tot Sur, dat ten oosten van Egypte ligt, in de richting van Assur. Zij hebben zich tegenover al hun broeders gevestigd. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dit is de geschiedenis van Isaak, de zoon van Abraham. Abraham verwekte Isaak. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","En Isaak was veertig jaar oud, toen hij Rebekka, de dochter van Betuël, de Arameeër uit Paddan-Aram, de zuster van de Arameeër Laban, tot vrouw nam. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nu bad Isaak de Here voor zijn vrouw, want zij was onvruchtbaar; en de Here liet Zich door hem verbidden, en zijn vrouw Rebekka werd zwanger. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","En de kinderen stieten in haar binnenste tegen elkander. Toen zeide zij: Indien het aldus gesteld is, waarom overkomt mij dat? Daarop ging zij om de Here te vragen. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","En de Here zeide tot haar: Twee volken zijn in uw schoot, en twee natiën zullen zich scheiden uit uw lichaam; de ene natie zal sterker zijn dan de andere, en de oudste zal de jongste dienstbaar wezen. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Toen nu haar dagen vervuld waren, dat zij baren zou, waren er dan ook tweelingen in haar schoot. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","En de eerste kwam te voorschijn, rossig, geheel als een haren mantel; en men gaf hem de naam Esau. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","En daarna kwam zijn broeder te voorschijn, wiens hand Esaus hiel vasthield; en hem noemde men Jakob. En Isaak was zestig jaar oud bij hun geboorte. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Toen de jongens opgroeiden, werd Esau een man, ervaren in de jacht, een man van het veld, maar Jakob was een huiselijk man, die in tenten woonde. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","En Isaak had Esau lief, want wildbraad was naar zijn smaak; maar Rebekka had Jakob lief. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Eens had Jakob een gerecht gekookt, en Esau kwam vermoeid van het veld. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Toen zeide Esau tot Jakob: Laat mij toch slokken van dat rode, dat rode daar, want ik ben moe. Daarom gaf men hem de naam Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Maar Jakob zeide: Verkoop mij dan eerst uw eerstgeboorterecht. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","En Esau zeide: Zie, ik ga toch sterven; waartoe dient mij dan het eerstgeboorterecht? ");
INSERT INTO nldnbg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Daarop zeide Jakob: Zweer mij eerst. En hij zwoer hem. Zo verkocht hij aan Jakob zijn eerstgeboorterecht. ");
INSERT INTO nldnbg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Toen gaf Jakob aan Esau brood en het linzengerecht; hij at en dronk, stond op en ging heen. Zo verachtte Esau het eerstgeboorterecht. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Eens kwam er een hongersnood in het land, behalve de eerste hongersnood, die er geweest was in de dagen van Abraham; en Isaak ging naar Abimelek, de koning der Filistijnen, naar Gerar. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Toen verscheen hem de Here en zeide: Trek niet naar Egypte, woon in het land, dat Ik u zeggen zal, ");
INSERT INTO nldnbg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","vertoef in dit land als een vreemdeling, dan zal Ik met u zijn en u zegenen, want u en uw nageslacht zal Ik al die landen geven, en Ik zal de eed gestand doen, die Ik uw vader Abraham gezworen heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","En Ik zal uw nageslacht vermenigvuldigen als de sterren des hemels, en Ik zal uw nageslacht al die landen geven, en met uw nageslacht zullen alle volken der aarde gezegend worden, ");
INSERT INTO nldnbg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","omdat Abraham naar Mij geluisterd en mijn dienst in acht genomen heeft: mijn geboden, mijn inzettingen en mijn wetten. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Dus bleef Isaak in Gerar. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Toen de mannen van die plaats hem naar zijn vrouw vroegen, zeide hij: Zij is mijn zuster, want hij durfde niet zeggen: Zij is mijn vrouw, (want hij dacht:) de mannen van die plaats mochten mij anders eens doden om Rebekka, omdat zij schoon van uiterlijk is. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Toen hij lange tijd daar geweest was, en Abimelek, de koning der Filistijnen, eens door het venster keek, zag hij, en zie, Isaak was aan het minnekozen met zijn vrouw Rebekka. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Toen riep Abimelek Isaak en zeide: Zij is zowaar uw vrouw; hoe hebt gij dan kunnen zeggen: zij is mijn zuster? Daarop zeide Isaak tot hem: Omdat ik dacht: ik mocht anders eens om haar het leven verliezen. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Maar Abimelek zeide: Wat hebt gij ons toch aangedaan? Licht zou een van het volk bij uw vrouw hebben kunnen liggen, en dan zoudt gij schuld over ons gebracht hebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Toen gebood Abimelek al het volk: Wie deze man of zijn vrouw aanraakt, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","En Isaak zaaide in dat land en oogstte in dat jaar honderdvoudig; want de Here zegende hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","En die man werd rijk, ja gaandeweg rijker, totdat hij zeer rijk geworden was. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","En hij had kudden kleinvee en runderen en een talrijke slavenstoet, zodat de Filistijnen hem benijdden. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Al de putten nu, die de knechten van zijn vader in de dagen van zijn vader Abraham gegraven hadden, hadden de Filistijnen dichtgestopt en met aarde gevuld. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Toen zeide Abimelek tot Isaak: Ga van ons heen, want gij zijt veel machtiger geworden dan wij. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Dus ging Isaak vandaar en hij legerde zich in het dal van Gerar, en woonde daar. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","En Isaak groef de waterputten, die men gegraven had in de dagen van zijn vader Abraham, en die de Filistijnen na Abrahams dood hadden dichtgestopt, weer op, en noemde ze met dezelfde namen, waarmee zijn vader ze genoemd had. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Daarna groeven de knechten van Isaak in het dal en vonden daar een put met levend water. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Toen twistten de herders van Gerar met de herders van Isaak en zeiden: Dit water is van ons. En hij gaf aan die put de naam Esek, omdat zij met hem getwist hadden. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Toen zij een andere put groeven, twistten zij ook daarover. En hij noemde die Sitna. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Toen brak hij vandaar op en groef een andere put, waarover zij niet twistten. Deze noemde hij Rechobot, en zeide: Nu heeft de Here ons ruimte gemaakt, zodat wij vruchtbaar kunnen zijn in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","En hij trok vandaar op naar Berseba. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","En de Here verscheen hem in die nacht en zeide: Ik ben de God van uw vader Abraham; vrees niet, want Ik ben met u; Ik zal u zegenen en uw nageslacht vermenigvuldigen ter wille van mijn knecht Abraham. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Toen bouwde hij daar een altaar en riep de naam des Heren aan. Hij spande daar zijn tent, en de knechten van Isaak groeven daar een put. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","En Abimelek ging uit Gerar tot hem, met zijn vriend Achuzzat en zijn legeroverste Pikol. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","En Isaak zeide tot hen: Waarom komt gij tot mij, daar gij mij haat, en mij van u weggezonden hebt? ");
INSERT INTO nldnbg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Daarop zeiden zij: Wij hebben duidelijk gezien, dat de Here met u is; daarom zeiden wij: laat er toch een verdrag onder ede tussen ons zijn, tussen ons en u; en laten wij een verbond met u sluiten: ");
INSERT INTO nldnbg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","dat gij ons geen kwaad zult doen, evenals wij u niet aangeraakt hebben, en evenals wij u enkel goed gedaan hebben en u in vrede hebben laten heengaan; nu zijt gij de gezegende des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Toen richtte hij hun een maaltijd aan, en zij aten en dronken. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","De volgende morgen vroeg zwoeren zij elkander de eed. Daarop deed Isaak hen uitgeleide, en zij gingen van hem heen in vrede. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Te dien dage kwamen de knechten van Isaak hem bericht brengen over een put die zij gegraven hadden, en zeiden tot hem: Wij hebben water gevonden. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","En hij noemde hem Seba; daarom is de naam der stad Berseba tot op de huidige dag. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Toen Esau veertig jaar oud geworden was, nam hij tot vrouw Jehudit, dochter van de Hethiet Beëri, en Basemat, dochter van de Hethiet Elon. ");
INSERT INTO nldnbg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","En zij waren een kwelling des geestes voor Isaak en voor Rebekka. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Toen Isaak oud geworden was, werden zijn ogen zo verzwakt, dat hij niet zien kon. Hij riep zijn oudste zoon Esau en zeide tot hem: Mijn zoon. En deze zeide tot hem: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","En hij zeide: Zie toch, ik ben oud geworden, ik weet de dag van mijn dood niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nu dan, neem toch uw wapentuig, uw pijlkoker en uw boog, en ga uit, het veld in en schiet voor mij een stuk wild; ");
INSERT INTO nldnbg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","bereid mij dan een smakelijk gerecht, zoals ik het gaarne heb, en breng het mij, opdat ik ete; dan zal ik u zegenen, eer ik sterf. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekka had geluisterd, toen Isaak tot zijn zoon Esau sprak. Nadat Esau het veld ingegaan was om een stuk wild te schieten en het (zijn vader) te brengen, ");
INSERT INTO nldnbg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","zeide Rebekka tot haar zoon Jakob: Zie, ik heb uw vader horen spreken tot uw broeder Esau: ");
INSERT INTO nldnbg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Breng mij toch een stuk wild en bereid mij een smakelijk gerecht, opdat ik ete, en ik zal u vóór mijn dood zegenen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nu dan, mijn zoon, luister naar mij in wat ik u gebied. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ga naar de kudde, haal mij vandaar twee beste geitebokjes, dan zal ik die tot een smakelijk gerecht voor uw vader bereiden, zoals hij het gaarne heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Breng dit dan aan uw vader om te eten, opdat hij u zegene vóór zijn dood. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Maar Jakob zeide tot zijn moeder Rebekka: Zie, mijn broeder Esau is een ruig man, en ik ben een onbehaard man. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Misschien zal mijn vader mij betasten; dan zal ik in zijn ogen zijn als iemand, die de spot met hem drijft, en ik zal vloek over mij brengen en geen zegen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Maar zijn moeder zeide tot hem: Uw vloek zij op mij, mijn zoon; luister nu naar mij en ga ze mij halen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Toen ging hij ze halen en bracht ze aan zijn moeder, en zijn moeder bereidde een smakelijk gerecht, zoals zijn vader het gaarne had. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ook nam Rebekka de beste klederen van haar oudste zoon Esau, die bij haar in huis waren, en liet ze haar jongste zoon Jakob aantrekken. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","En de vellen der geitebokjes trok zij over zijn handen en over zijn gladde hals. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Toen stelde zij het smakelijk gerecht en het brood, dat zij bereid had, haar zoon Jakob ter hand. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Daarop kwam hij bij zijn vader en zeide: Mijn vader. En deze zeide: Hier ben ik; wie zijt gij, mijn zoon? ");
INSERT INTO nldnbg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","En Jakob zeide tot zijn vader: Ik ben Esau, uw eerstgeborene; ik heb gedaan, zoals gij tot mij gesproken hebt. Richt u op, ga zitten en eet van mijn wildbraad, opdat gij mij moogt zegenen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Daarop zeide Isaak tot zijn zoon: Wat hebt gij het spoedig gevonden, mijn zoon! En hij zeide: Omdat de Here, uw God, mij deed slagen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Toen zeide Isaak tot Jakob: Kom toch dichterbij, opdat ik u betaste, mijn zoon, of gij inderdaad mijn zoon Esau zijt of niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob dan kwam dichterbij tot zijn vader Isaak, en deze betastte hem. En hij zeide: De stem is Jakobs stem, maar de handen zijn Esaus handen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Doch hij herkende hem niet, omdat zijn handen behaard waren evenals de handen van zijn broeder Esau. En hij wilde hem zegenen en zeide: ");
INSERT INTO nldnbg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Zijt gij inderdaad mijn zoon Esau zelf? En hij zeide: Ja. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Toen zeide hij: Zet het dicht bij mij, dan wil ik eten van het wildbraad van mijn zoon, opdat ik u zegene. Toen zette hij het dicht bij hem, en hij at; ook bracht hij hem wijn, en hij dronk. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Daarna zeide zijn vader Isaak tot hem: Kom toch dichterbij en kus mij, mijn zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","En hij kwam dichterbij en kuste hem. Toen hij de geur van zijn klederen rook, zegende hij hem en zeide: Zie, de geur van mijn zoon is als de geur van het veld, dat de Here gezegend heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God zal u geven van de dauw des hemels en van de vette streken der aarde, en overvloed van koren en most. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Volken zullen u dienen, en natiën zich voor u nederwerpen; wees heerser over uw broederen, en de zonen uwer moeder zullen zich voor u nederbuigen. Wie u vervloekt, zij vervloekt, en wie u zegent, zij gezegend. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Toen Isaak geëindigd had Jakob te zegenen en Jakob nog maar nauwelijks van zijn vader Isaak naar buiten was gegaan, kwam zijn broeder Esau van de jacht. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ook hij bereidde een smakelijk gerecht en bracht dat aan zijn vader. En hij zeide tot zijn vader: Mijn vader richte zich op en ete van het wildbraad van zijn zoon, opdat gij mij zegent. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","En zijn vader Isaak zeide tot hem: Wie zijt gij? En hij zeide: Ik ben uw eerstgeboren zoon Esau. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Toen schrok Isaak geweldig en hij zeide: Wie was het dan toch, die het wild geschoten en mij gebracht heeft? En ik heb van alles gegeten, eer gij kwaamt en heb hem gezegend; ook zal hij gezegend zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Zodra Esau de woorden van zijn vader hoorde, gaf hij een luide en bittere schreeuw, en hij zeide tot zijn vader: Zegen mij, ook mij, mijn vader! ");
INSERT INTO nldnbg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Toen zeide deze: Uw broeder is met bedrog gekomen en heeft uw zegen weggenomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","En hij zeide: Noemt men hem niet terecht Jakob, omdat hij mij nu al tweemaal bedrogen heeft? Mijn eerstgeboorterecht heeft hij weggenomen, en zie, nu heeft hij mijn zegen weggenomen. En hij zeide: Hebt gij voor mij geen zegen overgehouden? ");
INSERT INTO nldnbg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Toen antwoordde Isaak en zeide tot Esau: Zie, ik heb hem tot een heerser over u gesteld, en al zijn broederen heb ik hem tot knechten gegeven, en van koren en most heb ik hem voorzien; wat kan ik dan voor u doen, mijn zoon? ");
INSERT INTO nldnbg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Daarop zeide Esau tot zijn vader: Hebt gij slechts deze éne zegen, mijn vader? Zegen mij, ook mij, mijn vader! En Esau verhief zijn stem en weende. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Toen antwoordde zijn vader Isaak en zeide tot hem: Zie, ver van de vette streken der aarde zal uw woonplaats zijn, en zonder dauw des hemels van boven. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Maar van uw zwaard zult gij leven en uw broeder zult gij dienen. En het zal geschieden, wanneer gij u krachtig inspant, dat gij zijn juk van uw hals zult afrukken. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","En Esau koesterde wrok tegen Jakob om de zegen, waarmede zijn vader hem gezegend had, en Esau zeide bij zichzelf: De dagen van de rouw over mijn vader zijn aanstaande; dan zal ik mijn broeder Jakob doden. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Toen aan Rebekka de woorden van Esau, haar oudste zoon, waren medegedeeld, liet zij Jakob, haar jongste zoon, roepen, en zeide tot hem: Zie, uw broeder Esau wil zich op u wreken door u te doden. ");
INSERT INTO nldnbg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nu dan, mijn zoon, luister naar mij, maak u gereed, vlucht naar mijn broeder Laban, in Haran, ");
INSERT INTO nldnbg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","en blijf enige tijd bij hem, totdat de grimmigheid van uw broeder gestild is, ");
INSERT INTO nldnbg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","totdat de toorn van uw broeder van u afgewend is; als hij vergeten is, wat gij hem hebt aangedaan, zal ik u vandaar laten halen. Waarom zou ik op één dag van u beiden beroofd worden? ");
INSERT INTO nldnbg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Voorts zeide Rebekka tot Isaak: Ik walg van mijn leven om die Hethitische vrouwen; indien Jakob zich nu ook zo’n Hethitische vrouw neemt uit de dochters des lands, waarvoor leef ik dan nog? ");
INSERT INTO nldnbg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Toen riep Isaak Jakob en zegende hem, en hij gebood hem en zeide tot hem: Neem geen vrouw uit de dochters van Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Maak u gereed, ga naar Paddan-Aram, naar het huis van Betuël, de vader van uw moeder, en neem u vandaar een vrouw uit de dochters van Laban, de broeder van uw moeder. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","En God, de Almachtige, zegene u, Hij make u vruchtbaar en vermenigvuldige u, zodat gij tot een menigte van volken wordt. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hij geve u de zegen van Abraham, u en uw nageslacht met u, zodat gij het land uwer vreemdelingschap, dat God aan Abraham gegeven heeft, in bezit krijgt. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Zo zond Isaak Jakob weg, en deze ging naar Paddan-Aram, naar Laban, de zoon van Betuël, de Arameeër, de broeder van Rebekka, de moeder van Jakob en Esau. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Toen Esau zag, dat Isaak Jakob gezegend had en hem met een zegen had weggezonden naar Paddan-Aram, om zich vandaar een vrouw te nemen, en dat hij hem geboden had: Neem geen vrouw uit de dochters van Kanaän; ");
INSERT INTO nldnbg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","en dat Jakob naar zijn vader en zijn moeder geluisterd had, en naar Paddan-Aram gegaan was – ");
INSERT INTO nldnbg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","toen Esau nu zag, dat de dochters van Kanaän zijn vader Isaak zeer mishaagden, ");
INSERT INTO nldnbg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ging hij naar Ismaël, en nam zich bij zijn vrouwen Machalat, de dochter van Ismaël, de zoon van Abraham, de zuster van Nebajot, tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob vertrok uit Berseba en ging naar Haran. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","En hij bereikte een plaats, waar hij bleef overnachten, omdat de zon ondergegaan was. En hij nam een van de stenen der plaats, legde die onder zijn hoofd en ging op die plaats slapen. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Toen droomde hij, en zie, op de aarde was een ladder opgericht, waarvan de top tot aan de hemel reikte, en zie, engelen Gods klommen daarlangs op en daalden daarlangs neder. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","En zie, de Here stond bovenaan en zeide: Ik ben de Here, de God van uw vader Abraham en de God van Isaak; het land, waarop gij ligt, zal Ik aan u en aan uw nageslacht geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","En uw nageslacht zal zijn als het stof der aarde, en gij zult u uitbreiden naar het westen, oosten, noorden en zuiden, en met u en met uw nageslacht zullen alle geslachten des aardbodems gezegend worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","En zie, Ik ben met u en Ik zal u behoeden overal waar gij gaat, en Ik zal u wederbrengen naar dit land, want Ik zal u niet verlaten, totdat Ik gedaan heb wat Ik u heb toegezegd. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Toen Jakob uit zijn slaap ontwaakte, zeide hij: Waarlijk, de Here is aan deze plaats, en ik heb het niet geweten. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","En hij vreesde en zeide: Hoe ontzagwekkend is deze plaats. Dit is niet anders dan een huis Gods, dit is de poort des hemels. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","De volgende morgen vroeg nam Jakob de steen die hij onder zijn hoofd gelegd had, stelde die tot een opgerichte steen en goot er olie bovenop. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","En hij noemde die plaats Betel, maar tevoren was de naam der stad Luz. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","En Jakob deed een gelofte: Indien God met mij zal zijn, en mij behoeden zal op deze weg, die ik ga, mij zal geven brood om te eten en klederen om aan te trekken, ");
INSERT INTO nldnbg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","en ik behouden tot mijns vaders huis wederkeer, dan zal de Here mij tot een God zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","En deze steen, die ik tot een opgerichte steen gesteld heb, zal een huis Gods wezen, en van alles wat Gij mij schenken zult, zal ik U stipt de tienden geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","En Jakob begaf zich op weg en ging naar het land der stammen van het Oosten. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Toen hij rondkeek, zag hij een put in het veld, en zie, drie kudden kleinvee waren daarbij gelegerd, want men placht de kudden uit die put te drenken. De steen op de opening van de put was groot; ");
INSERT INTO nldnbg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","als alle kudden daar bijeengedreven waren, wentelde men de steen van de opening van de put en drenkte het vee; daarna bracht men de steen weer op de opening van de put op zijn plaats. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","En Jakob zeide tot (de herders): Mijn broeders, vanwaar zijt gij? En zij zeiden: Wij zijn uit Haran. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Daarop zeide hij tot hen: Kent gij ook Laban, de zoon van Nachor? En zij zeiden: Ja. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Vervolgens zeide hij tot hen: Gaat het hem wèl? En zij zeiden: Ja, maar zie, daar komt zijn dochter Rachel aan met het kleinvee. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Toen zeide hij: Zie, het is nog volop dag, het is nog geen tijd, dat de kudde bijeengedreven wordt; drenkt het vee en gaat het weer weiden. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Maar zij zeiden: Dat kunnen wij niet, voordat al de kudden bijeengedreven zijn; dan wentelt men de steen van de opening van de put, en drenken wij het vee. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Terwijl hij nog met hen sprak, kwam Rachel er aan met het kleinvee van haar vader, want zij was een herderin. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Zodra Jakob Rachel, de dochter van Laban, de broeder van zijn moeder, zag, en het kleinvee van Laban, de broeder van zijn moeder, trad Jakob toe, wentelde de steen van de opening van de put en drenkte het vee van Laban, de broeder van zijn moeder. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","En Jakob kuste Rachel en verhief zijn stem en weende. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Daarop vertelde Jakob Rachel, dat hij een bloedverwant van haar vader was, en de zoon van Rebekka. Toen snelde zij weg en deelde het haar vader mede. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Zodra Laban het bericht aangaande Jakob, de zoon zijner zuster, hoorde, snelde hij hem tegemoet, omhelsde hem en kuste hem hartelijk, en bracht hem in zijn huis. En hij vertelde dit alles aan Laban. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Toen zeide Laban tot hem: Waarlijk, gij zijt mijn eigen vlees en bloed. En hij bleef een volle maand bij hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","En Laban zeide tot Jakob: Zoudt gij, omdat gij mijn bloedverwant zijt, mij dienen om niet? Zeg mij, wat uw loon moet zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nu had Laban twee dochters; de oudste heette Lea en de jongste Rachel. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea’s ogen waren flets, maar Rachel was schoon van gestalte en schoon van uiterlijk. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","En Jakob had Rachel lief. Daarom zeide hij: Ik wil u zeven jaren dienen om uw jongste dochter Rachel. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","En Laban zeide: Het is beter, dat ik haar aan u geef dan dat ik haar aan een andere man geef; blijf bij mij. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Derhalve diende Jakob zeven jaren om Rachel, en die waren in zijn ogen als enkele dagen, omdat hij haar liefhad. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Daarna zeide Jakob tot Laban: Geef mij mijn vrouw, want mijn tijd is om, opdat ik tot haar kome. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","En Laban vergaderde al de mannen van die plaats, en richtte een maaltijd aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Des avonds echter nam hij zijn dochter Lea en bracht haar tot hem, en hij kwam tot haar. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ook gaf Laban haar zijn slavin Zilpa, tot een slavin voor zijn dochter Lea. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Maar des morgens, zie, het was Lea. Toen zeide hij tot Laban: Wat hebt gij mij daar gedaan? Heb ik niet om Rachel bij u gediend, waarom hebt gij mij dan bedrogen? ");
INSERT INTO nldnbg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Daarop zeide Laban: Zo doet men niet hier ter plaatse, dat men de jongste ten huwelijk geeft vóór de eerstgeborene. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Breng de bruiloftsweek met deze ten einde, dan zal u ook de andere gegeven worden voor de dienst, waarmede gij nog eens zeven jaren bij mij dienen zult. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","En Jakob deed zo; hij bracht de bruiloftsweek met haar ten einde; daarop gaf hij hem zijn dochter Rachel tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","En Laban gaf aan zijn dochter Rachel zijn slavin Bilha, haar tot een slavin. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","(Jakob) kwam ook tot Rachel, en hij had Rachel lief, in tegenstelling met Lea. Aldus diende hij bij hem nog eens zeven jaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Toen de Here zag, dat Lea niet bemind was, opende Hij haar schoot, maar Rachel bleef onvruchtbaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","En Lea werd zwanger, baarde een zoon, en gaf hem de naam Ruben, want, zo zeide zij, voorwaar, de Here heeft mijn ellende aangezien; voorwaar, nu zal mijn man mij liefhebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","En zij werd wederom zwanger, baarde een zoon, en zeide: Voorwaar, de Here heeft gehoord, dat ik niet bemind ben, en heeft mij ook deze geschonken; en zij gaf hem de naam Simeon. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wederom werd zij zwanger, baarde een zoon, en zeide: Nu zal mijn man zich ditmaal aan mij hechten, omdat ik hem drie zonen gebaard heb; daarom gaf zij hem de naam Levi. ");
INSERT INTO nldnbg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","En zij werd wederom zwanger, baarde een zoon, en zeide: Nu zal ik de Here loven; daarom gaf zij hem de naam Juda. Toen hield zij op met baren. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Toen Rachel zag, dat zij Jakob geen kinderen baarde, werd Rachel jaloers op haar zuster, en zij zeide tot Jakob: Geef mij kinderen; zo niet, dan sterf ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Toen ontbrandde Jakobs toorn tegen Rachel, en hij zeide: Neem ik de plaats van God in, die u de vrucht van de schoot ontzegd heeft? ");
INSERT INTO nldnbg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Maar zij zeide: Hier is mijn slavin Bilha, kom tot haar, en zij bare op mijn knieën, opdat ook ik uit haar gebouwd worde. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","En zij gaf hem haar slavin Bilha tot vrouw; en Jakob kwam tot haar. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha werd zwanger en baarde Jakob een zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Toen zeide Rachel: God heeft mij recht verschaft, ook heeft Hij mij verhoord en mij een zoon gegeven; daarom gaf zij hem de naam Dan. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Wederom werd Bilha, de slavin van Rachel, zwanger en baarde Jakob een tweede zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Toen zeide Rachel: Op bovenmenselijke wijze heb ik met mijn zuster geworsteld, ook heb ik overmocht; en zij gaf hem de naam Naftali. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Toen Lea zag, dat zij had opgehouden te baren, nam zij haar slavin Zilpa en gaf haar aan Jakob tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","En Zilpa, de slavin van Lea, baarde Jakob een zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Toen zeide Lea: Het geluk is gekomen, en zij gaf hem de naam Gad. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","En Zilpa, de slavin van Lea, baarde Jakob een tweede zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Toen zeide Lea: Ik gelukkige! Voorzeker zullen de jongedochters mij gelukkig prijzen; en zij gaf hem de naam Aser. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Toen Ruben in de dagen van de tarweoogst naar buiten ging, vond hij op het veld liefdesappelen, die hij aan zijn moeder Lea bracht. En Rachel zeide tot Lea: Geef mij toch enige van de liefdesappelen van uw zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Maar zij zeide tot haar: Is het niet genoeg, dat gij mijn man genomen hebt? En nu ook nog de liefdesappelen van mijn zoon nemen? Rachel zeide: Daarom mag hij vannacht bij u liggen voor de liefdesappelen van uw zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Toen Jakob des avonds uit het veld kwam, ging Lea hem tegemoet, en zeide: Kom bij mij, want ik heb u eerlijk gehuurd voor de liefdesappelen van mijn zoon. Daarom lag hij die nacht bij haar. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","En God hoorde naar Lea, zij werd zwanger en baarde Jakob een vijfde zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Toen zeide Lea: God heeft mij mijn loon gegeven, omdat ik mijn slavin aan mijn man gegeven heb; en zij gaf hem de naam Issakar. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Wederom werd Lea zwanger en baarde Jakob een zesde zoon. Toen zeide Lea: ");
INSERT INTO nldnbg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","God heeft mij een schoon geschenk gegeven; ditmaal zal mijn man bij mij wonen, omdat ik hem zes zonen gebaard heb; en zij gaf hem de naam Zebulon. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Daarna baarde zij een dochter en noemde haar Dina. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Toen gedacht God Rachel, en God verhoorde haar; Hij opende haar schoot, ");
INSERT INTO nldnbg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","en zij werd zwanger en baarde een zoon. Toen zeide zij: God heeft mijn smaad weggenomen; ");
INSERT INTO nldnbg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","en zij gaf hem de naam Jozef, zeggende: Moge de Here mij er nog een andere zoon bijvoegen. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Nadat Rachel Jozef gebaard had, zeide Jakob tot Laban: Laat mij vertrekken, opdat ik naar mijn geboorteplaats en mijn land ga. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Geef (mij) mijn vrouwen en kinderen, om wie ik u gediend heb, opdat ik moge heengaan, want gij weet welke diensten ik voor u verricht heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Daarop zeide Laban tot hem: Mocht ik uw genegenheid gewonnen hebben! Ik heb waargenomen, dat de Here mij om uwentwil gezegend heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","En hij zeide: Bepaal, wat uw loon bij mij zal zijn; en ik zal het geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Daarop zeide hij tot hem: Gij zelf weet, hoe ik u gediend heb, en hoe het met uw kudde bij mij gegaan is; ");
INSERT INTO nldnbg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","want wat gij bezat, voordat ik kwam, was weinig, maar het heeft zich uitgebreid in menigte, en de Here heeft u gezegend, waarheen ik mijn voet ook wendde; nu dan, wanneer zal ik ook eens voor mijn eigen huis kunnen werken? ");
INSERT INTO nldnbg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Toen zeide hij: Wat zal ik u geven? Maar Jakob zeide: Gij behoeft mij niets te geven; ik zal wederom uw vee weiden en hoeden, indien gij mij slechts dit wilt toestaan: ");
INSERT INTO nldnbg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ik zal heden door al uw kleinvee gaan en daaruit elk gespikkeld en gevlekt stuk kleinvee afzonderen; elk zwart stuk onder de schapen, en wat gevlekt en gespikkeld is onder de geiten, dat zal mijn loon zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","En mijn eerlijkheid zal morgen voor mij spreken, wanneer gij mijn loon zult komen bezichtigen: alles wat niet gespikkeld of gevlekt is onder de geiten of zwart onder de schapen, dat zal als door mij gestolen gelden. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Daarop zeide Laban: Zie, het geschiede naar uw woord. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Toen zonderde hij op die dag de gestreepte en gevlekte bokken af en alle gespikkelde en gevlekte geiten, alles waaraan iets wits was, benevens alles wat zwart was onder de schapen, en hij stelde het onder de hoede van zijn zonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","En (Laban) bepaalde een afstand van drie dagreizen tussen zich en Jakob, en Jakob weidde het overige vee van Laban. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Toen nam Jakob zich verse takken van populieren, amandelbomen en platanen, en schilde daarop witte strepen door het wit aan de takken te ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Hij legde de takken die hij geschild had, in de troggen, in de drinkbakken, waar het kleinvee kwam drinken, vlak voor het kleinvee; en zij werden bronstig, als zij kwamen drinken. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Was het kleinvee bronstig geworden bij de takken, dan wierp het gestreepte, gespikkelde en gevlekte jongen. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Dan scheidde Jakob de schapen af, keerde de koppen van het kleinvee naar het gestreepte en naar al het zwarte onder Labans kleinvee, en zette die kudden voor zich afzonderlijk, en plaatste ze niet bij het kleinvee voor Laban. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","En telkens, als het sterkste kleinvee bronstig werd, legde Jakob de takken voor het kleinvee in de troggen, opdat zij bij de takken bronstig zouden worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maar als het kleinvee zwak was, legde hij ze er niet in; aldus waren de zwakke dieren voor Laban en de sterke voor Jakob. ");
INSERT INTO nldnbg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Derhalve nam die man ten zeerste toe in bezit, en hij had veel kleinvee, slavinnen, slaven, kamelen en ezels. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","En hij hoorde de zonen van Laban zeggen: Jakob heeft zich alles toegeëigend wat van onze vader was, en uit hetgeen van onze vader was heeft hij zich al deze rijkdom gevormd. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ook lette Jakob op het gezicht van Laban, en zie, het was jegens hem niet als gisteren en eergisteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Toen zeide de Here tot Jakob: Keer terug naar het land uwer vaderen en naar uw maagschap, en Ik zal met u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Daarop liet Jakob Rachel en Lea roepen naar het veld, bij zijn kleinvee, en zeide tot haar: ");
INSERT INTO nldnbg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ik bemerk, dat het gezicht van uw vader jegens mij niet is als gisteren en eergisteren, maar de God mijns vaders is met mij geweest. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ook weet gij zelf, dat ik met al mijn kracht uw vader gediend heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Maar uw vader heeft mij bedrogen en mijn loon tienmaal veranderd, doch God heeft hem niet toegelaten mij te benadelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wanneer hij zeide: de gespikkelde zullen uw loon zijn, dan wierp al het kleinvee gespikkelde jongen; en wanneer hij zeide: de gestreepte zullen uw loon zijn, dan wierp al het kleinvee gestreepte jongen. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Zo heeft God de kudde uws vaders weggenomen en mij gegeven. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Het gebeurde eens in de tijd, toen het kleinvee bronstig was, dat ik mijn ogen opsloeg en ik zag in de droom, en zie, de bokken die het kleinvee besprongen, waren gestreept, gespikkeld en gevlekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","En de Engel Gods zeide tot mij in de droom: Jakob. En ik zeide: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","En Hij zeide: Sla toch uw ogen op en zie toe: al de bokken die het kleinvee bespringen, zijn gestreept, gespikkeld en gevlekt, want Ik heb gezien alles wat Laban u aandoet. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ik ben de God van Betel, waar gij een opgerichte steen gezalfd hebt, waar gij Mij een gelofte gedaan hebt; welnu, maak u reisvaardig, ga uit dit land weg en keer naar het land uwer maagschap terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Toen antwoordden Rachel en Lea en zeiden tot hem: Hebben wij nog deel of erfenis in het huis van onze vader? ");
INSERT INTO nldnbg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Zijn wij door hem niet als vreemden geacht, omdat hij ons verkocht heeft? Ook heeft hij ons geld geheel en al opgemaakt. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Doch al de rijkdom, die God van onze vader weggenomen heeft, die behoort ons en onze kinderen; nu dan, doe al wat God u gezegd heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Toen maakte Jakob zich reisvaardig, zette zijn kinderen en zijn vrouwen op de kamelen, ");
INSERT INTO nldnbg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","en dreef zijn gehele kudde voort en al de have, die hij verworven had, de kudde, die zijn eigendom was, die hij in Paddan-Aram verworven had, om te gaan naar zijn vader Isaak, naar het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban nu was heengegaan om zijn schapen te scheren. Toen stal Rachel de terafim van haar vader. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","En Jakob misleidde de Arameeër Laban door hem niet te vertellen, dat hij wilde vluchten. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Zo vluchtte hij met alles wat hij had, begaf zich op weg, trok over de Rivier en sloeg de richting in naar het gebergte van Gilead. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Toen aan Laban op de derde dag werd bericht, dat Jakob gevlucht was, ");
INSERT INTO nldnbg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","nam hij zijn verwanten met zich mee, achtervolgde hem zeven dagreizen ver, en haalde hem in op het gebergte van Gilead. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","En God kwam in een droom des nachts tot de Arameeër Laban en zeide tot hem: Neem u wel in acht, dat gij met Jakob niet ten goede of ten kwade spreekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Toen Laban Jakob bereikte, had Jakob zijn tent opgeslagen in het gebergte; ook Laban met zijn verwanten sloegen (hun tent) in het gebergte van Gilead op. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","En Laban zeide tot Jakob: Wat hebt gij gedaan, dat gij mij misleid en mijn dochters als krijgsgevangenen weggevoerd hebt? ");
INSERT INTO nldnbg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Waarom zijt gij heimelijk gevlucht en hebt gij mij misleid en het mij niet medegedeeld? Ik zou u dan uitgeleide hebben gedaan met vreugdebetoon en liederen, met tamboerijn en citer. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Gij hebt mij niet eens gelegenheid gegeven mijn zonen en dochters te kussen; zodoende hebt gij dwaas gehandeld. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Het is in mijn macht u kwaad te doen, maar de God van uw vader heeft gisterennacht tot mij gezegd: Neem u in acht, dat gij met Jakob niet ten goede of ten kwade spreekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nu dan, als gij zijt heengegaan, enkel omdat gij zo vurig naar uws vaders huis verlangt, waarom hebt gij dan mijn goden gestolen? ");
INSERT INTO nldnbg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Toen antwoordde Jakob en zeide tot Laban: Ik was bevreesd, omdat ik dacht, dat gij mij uw dochters zoudt ontrukken. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bij wie gij uw goden vindt, die blijve niet in leven; onderzoek in tegenwoordigheid van onze verwanten al wat ik bij mij heb, en neem het mee. Want Jakob wist niet, dat Rachel ze gestolen had. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Toen kwam Laban in de tent van Jakob en in de tent van Lea en in de tent der beide slavinnen, maar hij vond ze niet. Nadat hij uit de tent van Lea gegaan was, kwam hij in de tent van Rachel. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel nu had de terafim genomen en in het kameelzadel gelegd, en was daarop gaan zitten. En Laban doorzocht de gehele tent, maar vond ze niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","En zij zeide tot haar vader: Mijn heer worde niet toornig, omdat ik voor u niet kan opstaan, want het gaat mij naar de wijze der vrouwen. En hij zocht nauwkeurig, maar vond de terafim niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Toen werd Jakob toornig en twistte met Laban, en Jakob antwoordde en zeide tot Laban: Wat is mijn overtreding, wat is mijn zonde, dat gij mij zo heftig achtervolgd hebt? ");
INSERT INTO nldnbg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nu gij al mijn huisraad doorzocht hebt, wat hebt gij gevonden van al het huisraad van uw huis? Leg het hier neer voor de ogen van mijn en uw broeders, opdat zij scheidsrechters tussen ons zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Het is nu twintig jaar, dat ik bij u geweest ben; uw ooien en uw geiten hebben geen misdracht gehad en de rammen van uw kleinvee heb ik niet gegeten. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wat verscheurd was, bracht ik niet tot u, ik moest het zelf vergoeden; wat gestolen was, hetzij bij dag, hetzij bij nacht, hebt gij van mijn hand geëist. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Zo ging het mij: des daags sloopte mij de hitte en des nachts de koude, en de slaap week van mijn ogen. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Het is nu twintig jaar, dat ik in uw huis geweest ben; ik heb u veertien jaar om uw beide dochters gediend en zes jaar om uw vee, en gij hebt mijn loon tienmaal veranderd. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Indien de God van mijn vader, de God van Abraham en de Vreze van Isaak, niet met mij was geweest, dan zoudt gij mij nu voorzeker met lege handen hebben weggezonden; mijn ellende en de arbeid mijner handen heeft God aangezien en Hij heeft gisterennacht het geding beslist. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Toen antwoordde Laban en zeide tot Jakob: Deze dochters zijn mijn dochters en deze kinderen zijn mijn kinderen en dit vee is mijn vee, ja, al wat gij ziet, dat is van mij; wat zou ik dan nu mijn eigen dochters en de kinderen die zij gebaard hebben, kunnen aandoen? ");
INSERT INTO nldnbg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Welnu, komaan, laten wij een verbond sluiten, ik en gij, opdat het tot een getuige zij tussen mij en u. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Daarop nam Jakob een steen en zette die overeind als een opgerichte steen. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Voorts zeide Jakob tot zijn verwanten: Brengt stenen bijeen. Toen haalden zij stenen en maakten een hoop en zij hielden daar bij die hoop een maaltijd. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban noemde hem Jegar-Sahaduta, en Jakob noemde hem Gal-Ed. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","En Laban zeide: Deze steenhoop zij heden getuige tussen mij en u. Daarom noemde hij hem Gal-Ed, ");
INSERT INTO nldnbg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","en ook Mispa, want hij zeide: De Here houde wacht tussen mij en u, wanneer wij van elkander gescheiden zullen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Indien gij mijn dochters vernederend behandelt, en indien gij behalve mijn dochters vrouwen neemt, zie toe, al is er niemand bij ons, God is getuige tussen mij en u. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Voorts zeide Laban tot Jakob: Zie, deze steenhoop, en zie, de opgerichte steen die ik geplaatst heb tussen mij en u – ");
INSERT INTO nldnbg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","deze steenhoop zij getuige, en de opgerichte steen zij getuige: voorzeker, ik zal deze steenhoop niet voorbijtrekken naar u toe, en gij zult deze hoop en deze opgerichte steen niet voorbijtrekken naar mij toe, met kwade bedoeling. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","De God van Abraham en de God van Nachor, de God van hun vader, mogen richten tussen ons. Toen zwoer Jakob bij de Vreze van zijn vader Isaak. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","En Jakob bracht een slachtoffer op die berg en nodigde zijn verwanten tot een maaltijd. En zij hielden de maaltijd en overnachtten op de berg. ");
INSERT INTO nldnbg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","De volgende morgen vroeg kuste Laban zijn zonen en dochters en zegende hen, en Laban keerde terug naar zijn woonplaats. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ook Jakob ging zijns weegs, en engelen Gods ontmoetten hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Toen hij hen zag, zeide Jakob: Dit is een leger Gods. Daarom noemde hij die plaats Machanaïm. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","En Jakob zond boden voor zich uit tot zijn broeder Esau, naar het land Seïr, het gebied van Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","En hij gebood hun: Zo zult gij tot mijn heer, tot Esau, zeggen: Zo zegt uw knecht Jakob: ik heb als vreemdeling bij Laban vertoefd en ben daar tot nu toe gebleven. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","En ik heb runderen, ezels en kleinvee, slaven en slavinnen verworven, en ik laat dit mijn heer meedelen om uw genegenheid te winnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","De boden nu keerden tot Jakob terug en zeiden: Wij kwamen bij uw broeder, bij Esau, en hij is reeds op weg u tegemoet, met vierhonderd man bij zich. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Toen werd Jakob zeer bevreesd en het werd hem bang te moede; en hij verdeelde het volk dat bij hem was, en het kleinvee, de runderen en de kamelen in twee groepen. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Want hij dacht: Indien Esau op de ene groep afkomt en die verslaat, dan kan de groep die overblijft, ontkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Toen zeide Jakob: O God van mijn vader Abraham en God van mijn vader Isaak, Here, die tot mij gezegd hebt: keer terug naar uw land en naar uw maagschap en Ik zal u weldoen – ");
INSERT INTO nldnbg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ik ben te gering voor al de gunstbewijzen en voor al de trouw, die Gij aan uw knecht bewezen hebt, want met mijn staf trok ik over de Jordaan hier en nu ben ik tot twee legers geworden. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Red mij toch uit de hand van mijn broeder, uit de hand van Esau, want ik ben bevreesd voor hem: misschien zal hij komen en mij verslaan, zowel moeder als kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gij toch hebt gezegd: Ik zal u zeker weldoen en uw nageslacht maken als het zand der zee, dat wegens de menigte niet geteld kan worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","En hij bleef daar die nacht over.Toen nam hij van hetgeen hij verworven had een geschenk voor zijn broeder Esau: ");
INSERT INTO nldnbg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","tweehonderd geiten en twintig bokken, tweehonderd ooien en twintig rammen, ");
INSERT INTO nldnbg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","dertig zogende kemelinnen met haar veulens, veertig koeien en tien stieren, twintig ezelinnen en tien ezelhengsten. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","En hij stelde ze onder de hoede van zijn slaven, elke kudde afzonderlijk, en zeide tot zijn slaven: Trekt voor mij uit en laat ruimte tussen de verschillende kudden. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","En hij gebood de voorste: Als mijn broeder Esau u ontmoet en u vraagt: van wie zijt gij? en waarheen gaat gij? en van wie is dat vee daar voor u uit? ");
INSERT INTO nldnbg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","zeg dan: van uw knecht, van Jakob; dit is een geschenk, gezonden aan mijn heer, aan Esau, en zie, hij komt ook zelf achter ons aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","En hij gebood zowel de tweede als de derde en verder allen die achter de kudden liepen: Aldus zult gij tot Esau spreken, als gij hem aantreft; ");
INSERT INTO nldnbg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","en gij zult zeggen: ook uw knecht Jakob komt daar reeds achter ons aan. Hij dacht namelijk: Laat ik hem verzoenen met het geschenk dat voor mij uitgaat, en daarna wil ik zijn aangezicht zien; misschien zal hij mij goedgunstig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Aldus ging het geschenk vóór hem uit, maar zelf bleef hij die nacht in de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Toen stond hij in die nacht op, nam zijn beide vrouwen, zijn beide slavinnen en zijn elf zonen, en trok de doorwaadbare plaats van de Jabbok over; ");
INSERT INTO nldnbg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","hij nam hen en deed hen de beek overtrekken, en hij bracht alles wat hij had naar de overzijde. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Zo bleef Jakob alleen achter. En een man worstelde met hem, totdat de dag aanbrak. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Toen deze zag, dat hij hem niet overmocht, sloeg hij hem op zijn heupgewricht, zodat Jakobs heupgewricht ontwricht werd, terwijl hij met hem worstelde. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Toen zeide hij: Laat mij gaan, want de dageraad is gekomen. Maar hij zeide: Ik laat u niet gaan, tenzij gij mij zegent. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Daarop zeide hij tot hem: Hoe is uw naam? En hij zeide: Jakob. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Toen zeide hij: Uw naam zal niet meer Jakob luiden, maar Israël, want gij hebt gestreden met God en mensen, en gij hebt overmocht. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Daarop vroeg Jakob: Zeg mij toch uw naam. Maar hij antwoordde: Waarom vraagt gij toch naar mijn naam? En hij zegende hem daar. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","En Jakob noemde de plaats Pniël, want (zeide hij) ik heb God gezien van aangezicht tot aangezicht en mijn leven is behouden gebleven. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","En de zon ging over hem op, toen hij door Penuël getrokken was; en hij ging mank aan zijn heup. ");
INSERT INTO nldnbg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Daarom eten de Israëlieten tot op heden de heupspier niet, die op het heupgewricht ligt, omdat Hij Jakob op het heupgewricht, aan de heupspier, geslagen had. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob nu sloeg zijn ogen op en daar zag hij Esau aankomen, en met hem vierhonderd man. Toen verdeelde hij de kinderen onder Lea en Rachel en de beide slavinnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hij plaatste de slavinnen en haar kinderen vooraan, Lea en haar kinderen daarachter, en Rachel en Jozef achteraan. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","En zelf ging hij voor hen uit en boog zich zevenmaal ter aarde, totdat hij bij zijn broeder gekomen was. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Maar Esau snelde hem tegemoet, omarmde hem, viel hem om de hals en kuste hem, en zij weenden. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Daarna sloeg hij zijn ogen op, zag de vrouwen en de kinderen, en vroeg: Wie hebt gij daar bij u? En hij antwoordde: De kinderen, die God in zijn genade aan uw knecht geschonken heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Daarop naderden de slavinnen met haar kinderen en bogen zich neer. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Vervolgens naderde ook Lea met haar kinderen en zij bogen zich neer. En ten laatste naderden Jozef en Rachel en zij bogen zich neer. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Toen zeide hij: Wat bedoelt gij met die gehele schare, die ik ontmoette? En hij zeide: Om de genegenheid van mijn heer te winnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Maar Esau zeide: Ik heb al veel, mijn broeder; wat gij hebt, blijve het uwe. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Doch Jakob zeide: Geenszins, indien gij mij genegen zijt, neem dan mijn gave uit mijn hand aan, omdat ik uw aangezicht gezien heb zoals men het aangezicht Gods ziet, en gij welgevallen aan mij gehad hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Neem toch mijn geschenk, dat u gebracht werd, want God is mij genadig geweest en ik heb alles. En hij hield bij hem aan, zodat hij het nam. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","En hij zeide: Laat ons toch opbreken en verder reizen; ik wil u begeleiden. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Maar hij zeide tot hem: Mijn heer weet, dat de kinderen teer zijn, en dat ik kleinvee en zogende runderen bij mij heb; zou men die één dag al te zeer jagen, dan zou de gehele kudde sterven. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mijn heer trekke toch vóór zijn knecht uit en ik wil op mijn gemak verder trekken naar de tred van het vee, dat vóór mij uitgaat, en naar de tred van de kinderen, totdat ik bij mijn heer in Seïr kom. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Toen zeide Esau: Laat mij dan van het volk dat bij mij is, enigen bij u achterlaten. Maar hij zeide: Waarom toch? Laat mij de genegenheid van mijn heer winnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dus ging Esau die dag weer zijns weegs, naar Seïr. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Maar Jakob brak op naar Sukkot en hij bouwde zich daar een huis, en voor zijn kudde maakte hij hutten. Daarom noemde hij die plaats Sukkot. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jakob kwam op zijn tocht uit Paddan-Aram behouden bij de stad Sichem, in het land Kanaän en sloeg zijn legerplaats ten oosten van de stad op; ");
INSERT INTO nldnbg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","hij kocht voor honderd geldstukken het stuk land waarop hij zijn tent gespannen had, van de zonen van Hemor, de vader van Sichem. ");
INSERT INTO nldnbg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Daar richtte hij een altaar op en noemde dat: De God van Israël is God. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, de dochter van Lea, die zij Jakob gebaard had, ging eens uit om de dochters des lands te bezoeken. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Toen zag haar Sichem, de zoon van de Chiwwiet Hemor, de vorst des lands, en hij nam haar en lag bij haar en verkrachtte haar. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","En hij was aan Dina, de dochter van Jakob, innig gehecht; hij had het meisje lief en sprak tot het hart van het meisje. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Daarom zeide Sichem tot zijn vader Hemor: Neem mij dit meisje tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob nu had gehoord, dat hij zijn dochter Dina onteerd had. Daar zijn zonen bij zijn kudde in het veld waren, zweeg Jakob erover totdat zij thuiskwamen. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hemor nu, de vader van Sichem, ging tot Jakob om met hem te spreken. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","De zonen van Jakob kwamen thuis uit het veld, zodra zij het hoorden; de mannen waren gegriefd en zeer toornig, omdat hij een schandelijke dwaasheid in Israël begaan had door bij de dochter van Jakob te liggen, want zo iets doet men niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","En Hemor sprak met hen en zeide: Mijn zoon Sichem hangt met heel zijn hart aan uw dochter; geeft haar dan aan hem tot vrouw, ");
INSERT INTO nldnbg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","en verzwagert u met ons; geeft ons uw dochters en neemt onze dochters voor u, ");
INSERT INTO nldnbg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","woont dan bij ons: het land ligt voor u open; zet u daar neder, trekt daarin rond en vestigt u daar. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","En Sichem zeide tot haar vader en tot haar broeders: Schenkt mij toch uw genegenheid; ik zal u geven wat gij mij zegt. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Al maakt gij mij de bruidsprijs en de huwelijksgift nog zo hoog, ik zal geven wat gij mij zult zeggen; maar geeft mij het meisje tot vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Toen antwoordden de zonen van Jakob Sichem en zijn vader Hemor bedrieglijk en spraken, omdat hij hun zuster Dina onteerd had, tot hen als volgt: ");
INSERT INTO nldnbg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wij kunnen dit niet doen, onze zuster aan een man geven, die onbesneden is, want dat zou voor ons een schande zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Slechts op deze voorwaarde kunnen wij u ter wille zijn: indien gij ons gelijk wordt, doordat bij u al wie mannelijk is, besneden wordt; ");
INSERT INTO nldnbg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","dan zullen wij u onze dochters geven, en uw dochters voor ons nemen, en wij zullen bij u wonen, en wij zullen tot één volk zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Maar indien gij naar ons niet luistert en u niet laat besnijden, dan nemen wij onze dochter mee en gaan heen. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","En hun woorden vonden bijval bij Hemor en bij Sichem, de zoon van Hemor. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","En de jonge man draalde niet dit te doen, want hij had behagen in de dochter van Jakob en hij was de aanzienlijkste in zijn gehele familie. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Toen gingen Hemor en zijn zoon Sichem naar de poort hunner stad en spraken tot de mannen van hun stad: ");
INSERT INTO nldnbg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Die mannen hebben vredelievende bedoelingen jegens ons; laten zij wonen in dit land en daarin rondtrekken; het land is immers ruim genoeg voor hen. Wij kunnen dan hun dochters voor ons tot vrouwen nemen en onze dochters kunnen wij hun geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maar slechts op deze voorwaarde zullen die mannen ons ter wille zijn om bij ons te wonen, zodat wij één volk zijn: dat van ons al wie mannelijk is, besneden worde, zoals zij besneden zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hun kudde, hun have en al hun vee, zullen die niet ons toebehoren? Laat ons hun slechts ter wille zijn, zodat zij bij ons blijven wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Toen vonden Hemor en zijn zoon Sichem gehoor bij allen die uitgegaan waren naar de poort van zijn stad, en besneden werd al wie mannelijk was, allen die naar de poort van zijn stad waren uitgegaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Op de derde dag nu, toen zij hevige pijn leden, namen twee zonen van Jakob, Simeon en Levi, broeders van Dina, ieder zijn zwaard en zij overvielen de argeloze stad en doodden al wie mannelijk was. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ook Hemor en zijn zoon Sichem doodden zij met de scherpte des zwaards, en zij namen Dina mee uit het huis van Sichem en gingen weg. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","De zonen van Jakob wierpen zich op de verslagenen en plunderden de stad, omdat zij hun zuster onteerd hadden. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hun kleinvee en rundvee, hun ezels en al wat in de stad en op het veld was, namen zij mee. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","En hun gehele bezit, al hun kleine kinderen en hun vrouwen namen zij gevangen en zij maakten die buit, evenals alles wat in de huizen was. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Toen zeide Jakob tot Simeon en Levi: Gij hebt mij in het ongeluk gestort door mij in een kwade reuk te brengen bij de inwoners van dit land, bij de Kanaänieten en de Perizzieten, terwijl ik slechts met weinige lieden ben; als zij tegen mij samenspannen, zullen zij mij verslaan, en ik zal verdelgd worden, ik en mijn huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Maar zij zeiden: Mocht hij soms onze zuster als een hoer behandelen? ");
INSERT INTO nldnbg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","En God zeide tot Jakob: Maak u reisvaardig, trek naar Betel, blijf daar, en richt er een altaar op voor de God, die u verschenen is, toen gij vluchttet voor uw broeder Esau. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Toen zeide Jakob tot zijn huis en tot allen die bij hem waren: Doet weg de vreemde goden die in uw midden zijn, reinigt u en verwisselt uw klederen. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Laten wij ons dan gereed maken en naar Betel trekken, en ik zal daar een altaar oprichten voor die God, die mij geantwoord heeft ten dage mijner benauwdheid, en die met mij geweest is op de weg die ik gegaan ben. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Toen gaven zij Jakob al de vreemde goden die in hun bezit waren, en de ringen die in hun oren waren, en Jakob begroef ze onder de terebint die bij Sichem is. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Daarna braken zij op. En de schrik voor God viel op de steden rondom hen, zodat zij de zonen van Jakob niet achtervolgden. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Toen Jakob aangekomen was te Luz, in het land Kanaän, – dat is Betel – hij en al het volk dat bij hem was, ");
INSERT INTO nldnbg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","bouwde hij daar een altaar, en hij noemde die plaats El-Betel, omdat God Zich daar aan hem geopenbaard had, toen hij voor zijn broeder vluchtte. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Toen Debora, de voedster van Rebekka, gestorven was, werd zij begraven beneden Betel onder een eik, en men noemde die: Eik van geween. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","En God verscheen wederom aan Jakob, bij zijn komst uit Paddan-Aram, en zegende hem; ");
INSERT INTO nldnbg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","en God zeide tot hem: Gij heet Jakob; gij zult niet meer Jakob heten, maar Israël zal uw naam zijn. En Hij noemde hem Israël. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","En God zeide tot hem: Ik ben God, de Almachtige, wees vruchtbaar en word talrijk; een volk, ja een menigte van volken, zal uit u ontstaan, en koningen zullen uit uw lendenen voortkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","En dit land, dat Ik Abraham en Isaak gegeven heb, zal Ik u geven; en uw nageslacht zal Ik dit land geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","En God voer op van hem ter plaatse, waar Hij met hem gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","En Jakob zette een opgerichte steen ter plaatse, waar Hij met hem gesproken had, een stenen zuil, en hij stortte een plengoffer erover uit en goot er olie op. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","En Jakob noemde de plaats, waar God met hem gesproken had, Betel. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Daarna braken zij op uit Betel. Toen zij nog maar een eindweegs van Efrat verwijderd waren, baarde Rachel, en zij had een moeilijke bevalling. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","En terwijl zij die moeilijke bevalling had, zeide de vroedvrouw tot haar: Vrees niet, ook ditmaal hebt gij een zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","En toen haar het leven ontvlood – want zij stierf – noemde zij hem Ben-Oni, maar zijn vader noemde hem Benjamin. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Zo stierf Rachel en werd begraven aan de weg naar Efrat, dat is Betlehem. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","En Jakob zette op haar graf een opgerichte steen, dat is de opgerichte steen van Rachels graf tot op heden. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Daarna brak Israël op en spande zijn tent aan de andere zijde van Migdal-Eder. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","En toen Israël in dit land woonde, ging Ruben heen en lag bij Bilha, de bijvrouw van zijn vader, en Israël hoorde het.De zonen van Jakob nu waren twaalf in getal. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","De zonen van Lea: de eerstgeborene van Jakob, Ruben, voorts Simeon, Levi, Juda, Issakar en Zebulon. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","De zonen van Rachel: Jozef en Benjamin. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Verder de zonen van Bilha, de slavin van Rachel: Dan en Naftali. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Vervolgens de zonen van Zilpa, de slavin van Lea: Gad en Aser. Dit zijn de zonen van Jakob, die hem geboren zijn in Paddan-Aram. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","En Jakob kwam bij zijn vader Isaak te Mamre bij Kirjat-Arba – dat is Hebron – waar Abraham en Isaak als vreemdeling vertoefd hadden. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","En de dagen van Isaak waren honderd tachtig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","En Isaak gaf de geest en stierf en hij werd tot zijn voorgeslacht vergaderd, oud en van het leven verzadigd, en zijn zonen Esau en Jakob begroeven hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dit zijn de nakomelingen van Esau, dat is Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nam zijn vrouwen uit de dochters van Kanaän, Ada, dochter van de Hethiet Elon, en Oholibama, dochter van Ana, dochter van de Chiwwiet Sibon, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","en Basemat, dochter van Ismaël, zuster van Nebajot. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","En Ada baarde aan Esau Elifaz, en Basemat baarde Reüel, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","en Oholibama baarde Jeüs, Jalam en Korach. Dit waren de zonen van Esau, die hem in het land Kanaän geboren zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau nu nam zijn vrouwen, zijn zonen, zijn dochters en al de lieden die tot zijn huis behoorden, zijn kudde, al zijn vee en al zijn have, die hij in het land Kanaän verworven had, en hij ging van zijn broeder Jakob weg, naar een (ander) land. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Want hun have was te veel dan dat zij konden samenwonen, en het land hunner vreemdelingschap kon hen niet onderhouden vanwege hun kudden. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Daarom ging Esau op het gebergte Seïr wonen; Esau, dat is Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dit zijn de nakomelingen van Esau, de vader van de Edomieten, op het gebergte Seïr. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dit zijn de namen der zonen van Esau: Elifaz, de zoon van Esaus vrouw Ada; Reüel, de zoon van Esaus vrouw Basemat. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","En de zonen van Elifaz waren Teman, Omar, Sefo, Gatam en Kenaz. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna was een bijvrouw van Elifaz, de zoon van Esau, en zij baarde aan Elifaz Amalek; dit waren de zonen van Esaus vrouw Ada. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","En dit waren de zonen van Reüel: Nachat, Zerach, Samma en Mizza; dit waren de zonen van Esaus vrouw Basemat. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","En dit waren de zonen van Esaus vrouw Oholibama, dochter van Ana, dochter van Sibon, zij baarde aan Esau Jeüs, Jalam en Korach. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dit waren de stamhoofden der zonen van Esau: de zonen van Elifaz, de eerstgeborene van Esau, waren de stamhoofden Teman, Omar, Sefo, Kenaz, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korach, Gatam, Amalek; dit waren de stamhoofden van Elifaz in het land Edom; dit waren de zonen van Ada. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","En dit waren de zonen van Reüel, de zoon van Esau: de stamhoofden Nachat, Zerach, Samma en Mizza; dit waren de stamhoofden van Reüel in het land Edom; dit waren de zonen van Esaus vrouw Basemat. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","En dit waren de zonen van Esaus vrouw Oholibama; de stamhoofden Jeüs, Jalam en Korach; dit waren de stamhoofden van Esaus vrouw Oholibama, dochter van Ana. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dit waren de zonen van Esau en dit waren hun stamhoofden; dat is Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Dit waren de zonen van Seïr, de Chorieten, de inwoners van het land: Lotan, Sobal, Sibon, Ana, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser en Disan; dit waren de stamhoofden der Chorieten, der zonen van Seïr in het land Edom. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","En de zonen van Lotan waren Chori en Hemam, en de zuster van Lotan was Timna. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","En dit waren de zonen van Sobal: Alwan, Manachat, Ebal, Sefo en Onam. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","En dit waren de zonen van Sibon: zowel Ajja als Ana; dit is de Ana, die de hete bronnen in de woestijn gevonden heeft, toen hij de ezels van zijn vader Sibon hoedde. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","En dit waren de kinderen van Ana: Dison; en Oholibama was de dochter van Ana. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","En dit waren de zonen van Disan: Chemdan, Esban, Jitran en Keran. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dit waren de zonen van Eser: Bilhan, Zaäwan en Akan. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dit waren de zonen van Disan: Us en Aran. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dit waren de stamhoofden der Chorieten: Lotan, Sobal, Sibon, Ana, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser en Disan; dit waren de stamhoofden der Chorieten, naar hun stammen in het land Seïr. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","En dit waren de koningen, die over het land Edom regeerden, voordat er een koning over de Israëlieten regeerde. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","In Edom dan regeerde Bela, de zoon van Beor, en zijn stad heette Dinhaba. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Toen Bela gestorven was, werd koning in zijn plaats Jobab, de zoon van Zerach, uit Bosra. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Toen Jobab gestorven was, werd koning in zijn plaats Chusam, uit het land der Temanieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Toen Chusam gestorven was, werd koning in zijn plaats Hadad, de zoon van Bedad, die Midjan versloeg in het veld van Moab, en zijn stad heette Awit. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Toen Hadad gestorven was, werd koning in zijn plaats Samla, uit Masreka. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Toen Samla gestorven was, werd koning in zijn plaats Saul, uit Rechobot aan de rivier. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Toen Saul gestorven was, werd koning in zijn plaats Baäl-Chanan, de zoon van Akbor. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Toen Baäl-Chanan, de zoon van Akbor, gestorven was, werd koning in zijn plaats Hadar, en zijn stad heette Paü, en zijn vrouw heette Mehetabel, de dochter van Matred, de dochter van Me-Zahab. ");
INSERT INTO nldnbg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","En dit zijn de namen der stamhoofden van Esau naar hun geslachten, naar hun plaatsen, met hun namen: Timna, Alwa, Jetet, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibsar, ");
INSERT INTO nldnbg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiël en Iram; dit waren de stamhoofden van Edom naar hun woonplaatsen in het land hunner bezitting; dat is Esau, de vader van de Edomieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob echter woonde in het land der vreemdelingschap van zijn vader, in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dit is de geschiedenis van Jakob. Jozef, zeventien jaar oud – hij was dus nog jong – placht met zijn broeders, de zonen van Bilha en de zonen van Zilpa, de vrouwen van zijn vader, de schapen te hoeden. En Jozef bracht kwaad gerucht aangaande hen aan hun vader over. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","En Israël had Jozef lief boven al zijn zonen, omdat hij hem een zoon des ouderdoms was; en hij maakte hem een pronkgewaad. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Toen zijn broeders zagen, dat hun vader hem boven al zijn broeders liefhad, haatten zij hem en konden niet vriendelijk met hem spreken. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","En Jozef had een droom en vertelde die aan zijn broeders; daarom haatten zij hem nog meer. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Hij zeide namelijk tot hen: Hoort toch deze droom die ik gehad heb. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Zie, wij waren aan het schoven binden in het veld – daar richtte mijn schoof zich op en bleef overeind staan, en zie, uw schoven omringden haar en bogen zich voor mijn schoof neer. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Daarop zeiden zijn broeders tot hem: Wilt gij soms koning over ons zijn? Wilt ge soms over ons heersen? Toen haatten zij hem nog meer om zijn droom en om zijn woorden. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","En hij had nog een andere droom, die hij aan zijn broeders verhaalde. Hij zeide: Nu heb ik weer een droom gehad, en zie, de zon, de maan en elf sterren bogen zich voor mij neer. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Toen hij dit aan zijn vader en zijn broeders verhaalde, onderhield zijn vader hem daarover, en zeide tot hem: Wat voor een droom is dat, die gij gehad hebt? Zullen soms ik, uw moeder en uw broeders komen om ons voor u ter aarde neer te buigen? ");
INSERT INTO nldnbg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Zijn broeders dan benijdden hem, maar zijn vader hield de zaak in gedachten. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Eens waren zijn broeders heengegaan om de schapen van hun vader bij Sichem te weiden. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Toen zeide Israël tot Jozef: Uw broeders weiden immers bij Sichem? Kom, ik wil u tot hen zenden. En hij zeide tot hem: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Verder zeide hij tot hem: Ga toch en doe onderzoek naar de welstand van uw broeders en naar de welstand van de schapen en breng mij bescheid. En hij liet hem gaan uit het dal van Hebron en hij kwam te Sichem. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Toen hij nu in het veld omdoolde, trof hem een man aan, die hem vroeg: Wat zoekt gij? ");
INSERT INTO nldnbg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","En hij zeide: Ik zoek mijn broeders; vertel mij toch, waar zij weiden. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Daarop zeide die man: Zij zijn van hier opgebroken, want ik heb hen horen zeggen: Laten wij naar Dotan gaan. Toen ging Jozef zijn broeders achterna en hij trof hen aan te Dotan. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","En zij zagen hem van verre. Maar voordat hij bij hen gekomen was, smeedden zij een aanslag tegen hem om hem te doden. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Zij zeiden tot elkander: Zie, daar komt die aartsdromer aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nu dan, komt, laten wij hem doden en in een van de putten werpen, en laten wij dan zeggen: een wild dier heeft hem verslonden. Dan zullen wij zien, wat er van zijn dromen terechtkomt. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Toen Ruben dit hoorde, wilde hij hem uit hun hand redden, en zeide: Laten wij hem niet doodslaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Verder zeide Ruben tot hen: Vergiet geen bloed; werpt hem in deze put, die in de woestijn is, maar slaat de hand niet aan hem – met de bedoeling hem uit hun hand te redden en naar zijn vader terug te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Zodra Jozef bij zijn broeders gekomen was, trokken zij Jozef zijn kleed uit, het pronkgewaad, dat hij droeg. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","En zij namen hem en wierpen hem in de put; de put nu was leeg, er stond geen water in. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Daarna zetten zij zich neer om te eten. Toen zij hun ogen opsloegen – daar zagen zij een karavaan van Ismaëlieten aankomen uit Gilead, wier kamelen gom, balsem en hars droegen, op weg om dat naar Egypte te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Toen zeide Juda tot zijn broeders: Wat voordeel is erin gelegen, wanneer wij onze broeder doden en zijn bloed verbergen? ");
INSERT INTO nldnbg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Komt dan, laten wij hem aan de Ismaëlieten verkopen, doch laten wij niet de hand aan hem slaan, want hij is onze broeder, ons eigen vlees. En zijn broeders gaven daaraan gehoor. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Toen Midjanitische mannen, kooplieden, voorbijgingen, trokken zij Jozef omhoog, haalden hem op uit de put en verkochten Jozef voor twintig zilverstukken aan de Ismaëlieten; en dezen brachten Jozef naar Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Toen Ruben bij de put kwam, zie, Jozef was niet in de put. En hij scheurde zijn klederen, ");
INSERT INTO nldnbg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","keerde naar zijn broeders terug en zeide: De knaap is er niet, en ik, waar moet ik heen? ");
INSERT INTO nldnbg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Toen namen zij Jozefs kleed, slachtten een geitebok en doopten het kleed in het bloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","En zij lieten het pronkgewaad aan hun vader brengen met de boodschap: Dit hebben wij gevonden; zie toch, of dit het kleed van uw zoon is of niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","En hij herkende het en zeide: Het is het kleed van mijn zoon; een wild dier heeft hem verslonden; Jozef is stellig verscheurd. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","En Jakob scheurde zijn mantel, deed een rouwgewaad om zijn heupen en treurde lange tijd over zijn zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Al zijn zonen en al zijn dochters deden hun best hem te troosten, maar hij weigerde zich te laten troosten, en zeide: Neen, rouw dragend zal ik tot mijn zoon in het dodenrijk neerdalen. En zijn vader beweende hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","De Midjanieten nu verkochten hem naar Egypte, aan Potifar, een hoveling van Farao, de overste der lijfwacht. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","In die tijd trok Juda van zijn broeders weg en nam zijn intrek bij een man van Adullam, genaamd Chira. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","En Juda zag daar de dochter van een Kanaänitisch man, genaamd Sua; hij huwde haar en kwam tot haar. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","En zij werd zwanger, baarde een zoon, en noemde hem Er. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Daarna werd zij opnieuw zwanger, baarde een zoon en noemde hem Onan. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Vervolgens baarde zij nogmaals een zoon, en noemde hem Sela. Hij was te Kezib, toen zij hem baarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","En Juda nam voor Er, zijn eerstgeborene, een vrouw, genaamd Tamar. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","En Er, de eerstgeborene van Juda, wekte het misnoegen des Heren op, en de Here doodde hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Toen zeide Juda tot Onan: Ga tot uws broeders vrouw, sluit met haar het zwagerhuwelijk en verwek voor uw broeder nakroost. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Maar Onan wist, dat het nakroost hem niet zou toebehoren, daarom, zo vaak hij tot de vrouw van zijn broeder kwam, verspilde hij het zaad op de grond, om aan zijn broeder geen nakroost te geven. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","En hetgeen hij gedaan had, was kwaad in de ogen des Heren, en Hij doodde ook hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Toen zeide Juda tot zijn schoondochter Tamar: Ga als weduwe in het huis van uw vader wonen, totdat mijn zoon Sela groot is, want hij dacht: Dat ook hij niet sterve evenals zijn broeders. En Tamar ging in het huis van haar vader wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Na verloop van vele dagen stierf de dochter van Sua, de vrouw van Juda. En toen Juda de rouwtijd ten einde gebracht had, ging hij naar de scheerders van zijn schapen, hij en zijn vriend Chira, de Adullamiet, naar Timna. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Toen aan Tamar bericht werd: Zie, uw schoonvader is naar Timna gegaan om zijn schapen te scheren, ");
INSERT INTO nldnbg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","trok zij haar weduwkleed uit, bedekte zich met een sluier, vermomde zich en ging zitten aan de ingang van Enaïm, dat aan de weg naar Timna ligt, omdat zij gezien had, dat Sela groot geworden was, en zij hem niet tot vrouw was gegeven. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Toen Juda haar zag, hield hij haar voor een hoer, omdat zij haar aangezicht bedekt had. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","En hij wendde zich tot haar aan de weg en zeide: Welaan, laat mij toch tot u komen, want hij wist niet, dat zij zijn schoondochter was. Daarop zeide zij: Wat zult gij mij geven, wanneer gij tot mij komt? ");
INSERT INTO nldnbg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","En hij zeide: Ik zal u een geitebokje van de kudde zenden. Zij dan zeide: Als gij mij dan maar een pand geeft, totdat gij het gezonden hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Hij zeide: Wat voor pand moet ik u geven? Zij zeide: Uw zegelring, uw snoeren en de staf, die in uw hand is. Toen gaf hij het haar, en hij kwam tot haar en zij werd zwanger van hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Daarna stond zij op, en ging heen, legde haar sluier af en trok haar weduwkleed aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda nu zond het geitebokje door bemiddeling van zijn vriend, de Adullamiet, om het pand uit de hand der vrouw in ontvangst te nemen, maar deze trof haar niet aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","En hij vroeg de mannen van haar woonplaats: Waar is die deerne, die te Enaïm aan de weg zat? En zij zeiden: Er is hier geen deerne geweest. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hij dan kwam tot Juda terug en zeide: Ik heb haar niet gevonden; en ook de mannen van die plaats zeiden: Er is hier geen deerne geweest. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Toen zeide Juda: Laat zij het behouden, opdat wij niet tot spot worden; zie, ik heb het bokje gezonden, maar gij hebt haar niet kunnen vinden. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Na verloop van ongeveer drie maanden werd Juda bericht: Uw schoondochter Tamar heeft hoererij bedreven, en zie, zij is ook zwanger door hoererij. Toen zeide Juda: Brengt haar naar buiten, opdat zij verbrand worde. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Terwijl zij naar buiten gebracht werd, zond zij haar schoonvader deze boodschap: Bij de man, van wie deze dingen zijn, ben ik zwanger. Ook zeide zij: Zie eens goed, van wie deze zegelring en snoeren en staf zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Toen herkende Juda ze en hij zeide: Zij staat tegenover mij in haar recht, omdat ik haar niet aan mijn zoon Sela heb gegeven. En hij heeft geen gemeenschap meer met haar gehad. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Toen het nu de tijd was, dat zij baren zou, was er een tweeling in haar schoot. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","En toen zij baarde, stak er één zijn hand uit, en de vroedvrouw nam die, bond om zijn hand een scharlaken draad en zeide: Deze is het eerst gekomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","En toen hij zijn hand weer introk, daar kwam zijn broeder, en zij zeide: Hoe krachtig zijt gij doorgebroken, en zij gaf hem de naam Peres. ");
INSERT INTO nldnbg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","En daarna kwam zijn broeder aan wiens hand de scharlaken draad was, en men noemde hem Zerach. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jozef nu werd naar Egypte gebracht; en Potifar, een hoveling van Farao, de overste der lijfwacht, een Egyptenaar, kocht hem van de Ismaëlieten die hem daarheen gebracht hadden. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","En de Here was met Jozef, zodat hij een voorspoedig man werd, en hij woonde in het huis van zijn heer, de Egyptenaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Toen zijn heer zag, dat de Here met hem was, en dat de Here alles wat hij ondernam onder zijn hand deed gelukken, ");
INSERT INTO nldnbg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","won Jozef zijn genegenheid en hij mocht hem bedienen; hij stelde hem aan over zijn huis, en alles wat hij had, gaf hij in zijn hand. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Van het ogenblik af, dat hij hem over zijn huis en over al wat hij bezat had aangesteld, zegende de Here het huis van de Egyptenaar om Jozefs wil: de zegen des Heren rustte op alles wat hij had, zowel in huis als op het veld. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","En hij liet al het zijne aan Jozef over, en met hem naast zich, bemoeide hij zich enkel met het brood dat hij at. Jozef nu was schoon van gestalte en schoon van uiterlijk. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hierna sloeg de vrouw van zijn heer haar ogen op Jozef, en zij zeide: Kom bij mij liggen. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maar hij weigerde en zeide tot de vrouw van zijn heer: Zie, mijn heer bemoeit zich, met mij naast zich, met niets van wat er in huis is, en alles wat hij heeft, heeft hij in mijn hand gegeven; ");
INSERT INTO nldnbg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","niemand is in dit huis machtiger dan ik, en hij heeft mij niets onthouden dan alleen u, omdat gij zijn vrouw zijt; hoe zou ik dan dit grote kwaad doen en zondigen tegen God? ");
INSERT INTO nldnbg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","En ofschoon zij dag aan dag tot Jozef sprak, voldeed hij niet aan haar wens bij haar te gaan liggen en omgang met haar te hebben. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Op zekere dag kwam hij het huis binnen om zijn werk te verrichten, terwijl niemand van de huisgenoten daar in huis was. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Toen greep zij hem bij zijn kleed en zeide: Kom bij mij liggen. Maar hij liet zijn kleed in haar hand achter, vluchtte en liep naar buiten. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Toen zij nu zag, dat hij zijn kleed in haar hand achtergelaten had en naar buiten gevlucht was, ");
INSERT INTO nldnbg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","riep zij haar huisgenoten en zeide tot hen: Ziet toch, hij heeft ons een Hebreeuwse man gebracht opdat deze zijn spel met ons drijve; hij is bij mij gekomen om bij mij te liggen, maar ik heb met luider stem geroepen; ");
INSERT INTO nldnbg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","en toen hij hoorde, dat ik mijn stem verhief en riep, liet hij zijn kleed bij mij achter, vluchtte en liep naar buiten. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Daarop legde zij zijn kleed bij zich neer, totdat zijn heer thuiskwam. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","En zij sprak tot hem in dezer voege: Die Hebreeuwse slaaf, die gij ons gebracht hebt, is bij mij gekomen om zijn spel met mij te drijven. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Maar toen ik mijn stem verhief en riep, heeft hij zijn kleed bij mij achtergelaten en is naar buiten gevlucht. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Zodra zijn heer de woorden hoorde, die zijn vrouw tot hem sprak: zo en zo heeft uw slaaf mij gedaan, ontbrandde zijn toorn. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","En Jozefs heer greep hem en wierp hem in de gevangenis, de plaats waar de gevangenen van de koning gevangen zaten. Zo kwam hij daar in de gevangenis. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","En de Here was met Jozef; Hij bewees hem genade en deed hem de genegenheid van de overste der gevangenis winnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Daarom vertrouwde de overste der gevangenis al de gevangenen die in de gevangenis waren, aan Jozef toe, en al wat daar te doen was, deed hij. ");
INSERT INTO nldnbg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","De overste der gevangenis keek niet om naar iets dat hem was toevertrouwd, omdat de Here met hem was; en wat hij verrichtte, deed de Here gelukken. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hierna gebeurde het, dat de schenker en de bakker van de koning van Egypte zondigden tegen hun heer, de koning van Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","En Farao werd toornig op zijn beide hovelingen, de overste der schenkers en de overste der bakkers. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Hij zette hen in hechtenis in het huis van de overste der lijfwacht, in de gevangenis, de plaats waar Jozef gevangen zat. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","En de overste der lijfwacht stelde Jozef bij hen aan, om hen te bedienen. En zij waren geruime tijd in hechtenis. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Zij nu hadden beiden een droom, ieder zijn eigen droom, in dezelfde nacht, ieder een droom met een eigen betekenis, zowel de schenker als de bakker van de koning van Egypte, die in de gevangenis gevangen zaten. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Toen Jozef in de morgen bij hen kwam, zag hij hen aan, en zie, zij waren mismoedig. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hij vroeg aan de hovelingen van Farao, die met hem in hechtenis waren in het huis van zijn heer: Waarom staat uw gezicht zo somber vandaag? ");
INSERT INTO nldnbg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Daarop zeiden zij tot hem: Wij hebben een droom gehad en er is niemand, die hem kan uitleggen. Toen zeide Jozef tot hen: Zijn de uitleggingen niet Gods zaak? Vertelt het mij toch. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Daarop vertelde de overste der schenkers aan Jozef zijn droom en zeide tot hem: In mijn droom, zie, er stond een wijnstok vóór mij. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Aan de wijnstok waren drie ranken, en nauwelijks begon hij te botten, of zijn bloesem was er, en zijn trossen droegen rijpe druiven. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","En Farao’s beker was in mijn hand. Ik nam de druiven, perste ze uit in Farao’s beker en gaf de beker in Farao’s hand. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Toen zeide Jozef tot hem: Dit is de uitlegging ervan: de drie ranken, dat zijn drie dagen; ");
INSERT INTO nldnbg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","binnen drie dagen zal Farao uw hoofd verhogen en u in uw rang herstellen, en gij zult Farao de beker in de hand geven, zoals gij tevoren placht te doen, toen gij zijn schenker waart. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Maar blijf aan mij denken, wanneer het u goed zal gaan; toon mij toch uw dankbaarheid door van mij gewag te maken bij Farao, en breng mij uit dit huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Want gestolen ben ik uit het land der Hebreeën, en ook hier heb ik niets gedaan, waarom zij mij in dit kerkerhol hadden kunnen zetten. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Toen de overste der bakkers zag, dat Jozef een gunstige uitlegging gegeven had, zeide hij tot hem: Ook ik had een droom: zie, er waren op mijn hoofd drie korven met gebak. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In de bovenste korf was allerlei spijs voor Farao, wat een bakker bereidt. Het gevogelte at dit uit de korf, boven mijn hoofd. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Toen antwoordde Jozef: Dit is de uitlegging ervan: de drie korven, dat zijn drie dagen; ");
INSERT INTO nldnbg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","binnen drie dagen zal Farao uw hoofd verhogen, boven u, en u aan een paal hangen en het gevogelte zal het vlees van u afeten. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Op de derde dag nu, de geboortedag van Farao, maakte hij een maaltijd voor al zijn dienaren. En hij verhief het hoofd van de overste der schenkers en het hoofd van de overste der bakkers te midden van zijn dienaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Want hij herstelde de overste der schenkers in zijn schenkersambt, zodat hij de beker weer in Farao’s hand gaf. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Maar de overste der bakkers hing hij op, zoals Jozef hun had uitgelegd. ");
INSERT INTO nldnbg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Doch de overste der schenkers dacht niet aan Jozef, maar vergat hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na verloop van twee volle jaren droomde Farao, dat hij aan de Nijl stond. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","En zie, uit de Nijl kwamen zeven koeien op, mooi van uiterlijk en vet van vlees, en zij weidden in het oevergras. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Maar zie, zeven andere koeien kwamen na deze op uit de Nijl, lelijk van uiterlijk en mager van vlees, en zij gingen naast die koeien staan aan de oever van de Nijl. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","En de koeien die lelijk van uiterlijk en mager van vlees waren, aten de zeven koeien op, die mooi van uiterlijk en vet waren. Toen ontwaakte Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Daarna sliep hij weer in en droomde ten tweeden male, en zie, zeven dikke en mooie aren schoten op uit één halm. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Maar zie, zeven dunne en door de oostenwind verzengde aren ontsproten na deze. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","En de dunne aren verslonden de zeven dikke en volle aren. Toen ontwaakte Farao, en het was een droom. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","De volgende morgen was zijn geest onrustig en hij ontbood al de geleerden en al de wijzen van Egypte, en Farao vertelde hun zijn dromen, maar er was niemand, die ze Farao kon uitleggen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Toen sprak de overste der schenkers tot Farao: Heden moet ik mijn zonden in herinnering brengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao was toornig op zijn dienaren, en zette mij in hechtenis in het huis van de overste der lijfwacht, mij en de overste der bakkers. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","In één zelfde nacht nu hadden wij een droom, ik en hij, ieder had een droom met een eigen betekenis. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nu was daar bij ons een Hebreeuwse jongeman, een slaaf van de overste der lijfwacht, en wij vertelden hem onze dromen, en hij legde ze ons uit; aan ieder gaf hij uitleg naar zijn droom. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","En zoals hij ons uitgelegd had, zo is het gebeurd; mij herstelde Farao weer in mijn ambt, hem liet hij ophangen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Toen ontbood Farao Jozef, en zij haalden hem ijlings uit de kerker; men schoor hem en gaf hem andere klederen, en hij kwam bij Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Toen zeide Farao tot Jozef: Ik heb een droom gehad, en er is niemand, die hem kan uitleggen, maar ik heb van u horen zeggen: Gij behoeft een droom maar te horen om hem te kunnen uitleggen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","En Jozef antwoordde Farao: Geenszins; God zal Farao’s welzijn verkondigen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Toen sprak Farao tot Jozef: In mijn droom stond ik aan de oever van de Nijl. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","En zie, uit de Nijl kwamen zeven koeien op, vet van vlees en mooi van gedaante, en zij weidden in het oevergras. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Maar zie, zeven andere koeien kwamen na deze op, schraal, zeer lelijk van gedaante en mager van vlees; ik heb nooit zulke lelijke als deze gezien in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","En de magere en lelijke koeien aten de zeven eerste, vette koeien op. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Toen deze in haar maag gekomen waren, was daarvan niets te merken; zij bleven er even lelijk uitzien als tevoren. Toen ontwaakte ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Verder zag ik in mijn droom, en zie, zeven aren schoten op uit één halm, vol en mooi. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maar zie, zeven dorre, dunne en door de oostenwind verzengde aren ontsproten na deze. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","En de dunne aren verslonden de zeven mooie aren. En ik heb dit de geleerden gezegd, maar er is niemand, die het mij kan verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Toen zeide Jozef tot Farao: Farao’s dromen zijn één; God heeft Farao bekend gemaakt, wat Hij zal doen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De zeven mooie koeien, dat zijn zeven jaren, en de zeven mooie aren, dat zijn zeven jaren; de dromen zijn één. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","En de zeven magere en lelijke koeien, die na deze opkwamen, dat zijn zeven jaren, en de zeven loze, door de oostenwind verzengde aren betekenen zeven jaren van hongersnood. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Dit bedoelde ik, toen ik tot Farao sprak: God heeft Farao getoond, wat Hij zal doen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Zie, er komen zeven jaren, waarin grote overvloed in het gehele land Egypte wezen zal. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Daarna zullen zeven jaren van hongersnood aanbreken; dan zal al de overvloed in het land Egypte vergeten zijn en de honger het land verteren. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Van de overvloed zal men daarna in het land niets meer merken vanwege die hongersnood, want die zal zeer zwaar zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dat de droom tot tweemaal toe aan Farao herhaald is, wil zeggen, dat de zaak bij God vaststaat, en dat God die haastig zal volbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nu dan, Farao zie om naar een verstandig en wijs man, en hij stelle hem aan over het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao doe ook dit: hij stelle opzichters over het land aan, en heffe van het land Egypte een vijfde, in de zeven jaren van de overvloed. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Zij moeten al het voedsel van deze goede jaren die komen zullen, verzamelen en koren opslaan ter beschikking van Farao, als voedsel in de steden, en dit bewaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Zo zal dat voedsel het land tot voorraad dienen voor de zeven jaren van hongersnood, die in het land Egypte zullen zijn, opdat het land door de honger niet te gronde worde gericht. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Dit voorstel nu was goed in de ogen van Farao en in de ogen van al zijn dienaren. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","En Farao zeide tot zijn dienaren: Zouden wij iemand kunnen vinden als deze, een man, in wie de Geest Gods is? ");
INSERT INTO nldnbg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","En Farao zeide tot Jozef: Aangezien God u dit alles bekend gemaakt heeft, is er niemand zo verstandig en wijs als gij. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gij zult over mijn huis zijn, en op uw bevel zal mijn gehele volk zich voeden; alleen door de troon zal ik boven u staan. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Voorts zeide Farao tot Jozef: Zie, ik stel u aan over het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Daarop trok Farao zijn zegelring van zijn hand en deed hem aan Jozefs hand; hij bekleedde hem met linnen klederen, en hing een gouden keten om zijn hals. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","En hij liet hem rijden op de tweede wagen die hij had, en men riep voor hem uit: Eerbied! Aldus stelde hij hem aan over het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ook zeide Farao tot Jozef: Ik ben Farao, maar zonder u zal niemand in het gehele land Egypte zijn hand of zijn voet opheffen. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","En Farao noemde Jozef: Safenat-Paneach, en hij gaf hem Asnat, de dochter van Potifera, de priester van On, tot vrouw. En Jozef ging uit, (als heer) over het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jozef was dertig jaar oud, toen hij voor Farao, de koning van Egypte, stond. En Jozef ging van Farao heen en trok door het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Het land nu gaf zijn opbrengst in de zeven jaren van overvloed bij handen vol, ");
INSERT INTO nldnbg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","en hij verzamelde al het voedsel der zeven jaren, dat in het land Egypte was, en hij sloeg het voedsel in steden op; de opbrengst van de velden die om elke stad gelegen waren, sloeg hij daarin op. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","En Jozef hoopte koren op als zand der zee, geweldig veel, zodat men ophield te tellen, want er was geen tellen aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","En voordat er een jaar van hongersnood kwam, werden Jozef twee zonen geboren, die Asnat, de dochter van Potifera, de priester van On, hem baarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jozef gaf aan de eerstgeborene de naam Manasse, want (zeide hij): God heeft mij al mijn moeite doen vergeten, en ook het gehele huis mijns vaders. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","En aan de tweede gaf hij de naam Efraïm, want (zeide hij): God heeft mij vruchtbaar gemaakt in het land mijner ellende. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Toen de zeven jaren van overvloed, die er in het land Egypte geweest was, verstreken waren, ");
INSERT INTO nldnbg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","begonnen de zeven jaren van de hongersnood te komen, zoals Jozef gezegd had; in alle landen was hongersnood, maar in het gehele land Egypte was brood. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Toen het gehele land Egypte honger leed, en het volk tot Farao om brood riep, zeide Farao tot alle Egyptenaren: Gaat tot Jozef; doet wat hij u zegt. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Toen de hongersnood nu over de gehele aarde heerste, opende Jozef alle schuren en verkocht koren aan de Egyptenaren; want de honger was sterk in het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","En de gehele wereld kwam naar Egypte om bij Jozef koren te kopen, want de honger was sterk op de gehele aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Toen Jakob vernam, dat er in Egypte koren was, zeide hij tot zijn zonen: Waarom ziet gij elkander aan! ");
INSERT INTO nldnbg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Voorts zeide hij: Zie, ik heb gehoord, dat er in Egypte koren is; trekt daarheen en koopt daar koren voor ons, opdat wij in leven blijven en niet sterven. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Toen trokken tien broeders van Jozef heen om in Egypte koren te kopen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Doch Jakob liet Benjamin, Jozefs broeder, niet met zijn broeders meegaan, want hij dacht; er mocht hem eens een ongeluk overkomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Onder degenen die kwamen om koren te kopen, waren ook de zonen van Israël, want er was hongersnood in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jozef nu was de machthebber over het land; hij was het, die aan al het volk van het land koren verkocht.Toen nu de broeders van Jozef aangekomen waren, bogen zij zich voor hem neer met het aangezicht ter aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zodra Jozef zijn broeders zag, herkende hij hen, maar hij deed alsof hij een vreemde voor hen was; hij sprak hen bits aan, en zeide tot hen: Vanwaar komt gij? Zij zeiden: Uit het land Kanaän, om voedsel te kopen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jozef herkende zijn broeders wel, maar zij herkenden hem niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Toen herinnerde Jozef zich de dromen die hij van hen gedroomd had. En hij zeide tot hen: Gij zijt verspieders, gij zijt gekomen om te zien, waar het land open ligt. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Doch zij zeiden tot hem: Neen, mijn heer, maar uw knechten zijn gekomen om voedsel te kopen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wij zijn allen zonen van één man; wij zijn eerlijke lieden; uw knechten zijn geen verspieders. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Doch hij zeide tot hen: Neen, maar gij zijt gekomen om te zien, waar het land open ligt. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Daarop zeiden zij: Uw knechten waren twaalf in getal, wij zijn broeders, zonen van één man in het land Kanaän, en zie, de jongste is thans bij onze vader, en één is niet meer. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Toen zeide Jozef tot hen: Het is, zoals ik tot u gesproken heb: gij zijt verspieders. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hieraan zult gij getoetst worden: zowaar Farao leeft, gij zult vanhier niet weggaan, tenzij uw jongste broeder hierheen komt. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Zendt één van u om uw broeder te halen, maar gij zult gevangen blijven; zo zullen uw woorden getoetst worden, of gij waarheid spreekt; maar indien niet, zowaar Farao leeft, dan zijt gij verspieders. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","En hij zette hen gezamenlijk drie dagen lang in hechtenis. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Op de derde dag nu zeide Jozef tot hen: Doet dit, opdat gij in leven blijft; ik vrees God. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Indien gij eerlijke lieden zijt, laat dan één broeder van u gevangen blijven in het huis van bewaring, maar gaat gij heen, neemt koren mee voor de honger uwer gezinnen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Doch dan moet gij uw jongste broeder tot mij brengen, opdat uw woorden waarheid mogen blijken en gij niet sterft. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Zij nu deden aldus en zeiden tot elkander: Voorwaar, nu boeten wij voor wat wij onze broeder aangedaan hebben: wij zagen zijn zielsbenauwdheid, toen hij ons om erbarming smeekte, maar wij hoorden niet; daarom is deze benauwdheid over ons gekomen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Toen antwoordde Ruben hun: Heb ik u niet gezegd: bezondigt u niet aan de knaap! Maar gij hebt niet geluisterd. Nu wordt zijn bloed van ons geëist. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zij wisten echter niet, dat Jozef hen verstond, want zij gebruikten een tolk. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Toen wendde hij zich van hen af en weende. Daarna keerde hij tot hen terug en sprak met hen; hij nam Simeon uit hun midden en liet hem in hun bijzijn binden. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","En Jozef beval, dat men hun zakken met koren vullen en ieder het geld in zijn zak teruggeven zou, en dat men hun teerkost voor de reis zou geven. En men deed hun aldus. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Daarna laadden zij hun koren op hun ezels en gingen vandaar weg. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Toen één zijn zak opende om in het nachtverblijf zijn ezel voeder te geven, zag hij zijn geld, en zie, het lag boven in zijn zak. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hij zeide tot zijn broeders: Mijn geld is teruggegeven; zie maar, het ligt in mijn zak. Toen ontzonk hun de moed, en zij wendden zich bevende tot elkander en zeiden: Wat heeft God ons nu aangedaan! ");
INSERT INTO nldnbg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Toen zij bij hun vader Jakob gekomen waren, in het land Kanaän, deelden zij hem alles mee wat hun wedervaren was, en zeiden: ");
INSERT INTO nldnbg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Die man, de heer van dat land, heeft ons bits aangesproken en bejegende ons als verspieders van dat land. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Toen zeiden wij tot hem: Wij zijn eerlijke lieden, wij zijn geen verspieders. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wij waren twaalf in getal, broeders, zonen van onze vader; één is niet meer, en de jongste is thans bij onze vader, in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Toen zeide die man, de heer van dat land, tot ons: Hieraan zal ik weten, dat gij eerlijke lieden zijt: één broeder van u zult gij bij mij laten; neemt dan koren voor de honger uwer gezinnen en gaat heen; ");
INSERT INTO nldnbg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","en brengt uw jongste broeder tot mij, opdat ik weet, dat gij geen verspieders zijt, maar eerlijke lieden; dan zal ik uw broeder aan u teruggeven, en gij moogt vrij in het land rondtrekken. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Toen zij hun zakken ledigden – daar lag ieders geldbuidel in zijn zak; en toen zij en hun vader hun geldbuidels zagen, werden zij bevreesd. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","En hun vader Jakob zeide tot hen: Gij berooft mij van kinderen; Jozef is niet meer, en Simeon is er niet meer, en Benjamin wilt gij meenemen; dit alles is tegen mij. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Toen zeide Ruben tot zijn vader: Gij moogt mijn twee zonen doden, indien ik hem niet tot u breng; geef hem onder mijn hoede en ik zal hem tot u terugbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Maar hij zeide: Mijn zoon gaat niet met u mee, want zijn broeder is dood en hij is alleen overgebleven; overkomt hem een ongeluk op de weg die gij gaan zult, dan zult gij mijn grijze haar met verdriet in het dodenrijk doen nederdalen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Maar de hongersnood was zwaar in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","En toen zij het uit Egypte meegebrachte koren verbruikt hadden, zeide hun vader tot hen: Gaat ons weer een weinig voedsel kopen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Toen zeide Juda tot hem: Die man heeft ons uitdrukkelijk verzekerd: gij zult mijn aangezicht niet zien, tenzij uw broeder bij u is. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wilt gij onze broeder met ons laten gaan, dan zullen wij heentrekken en voedsel voor u kopen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Doch indien gij hem niet wilt laten gaan, dan zullen wij niet heentrekken, want die man heeft tot ons gezegd: gij zult mijn aangezicht niet zien, tenzij uw broeder bij u is. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Toen zeide Israël: Waarom hebt gij mij kwaad aangedaan door die man mee te delen, dat gij nog een broeder hebt? ");
INSERT INTO nldnbg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Daarop zeiden zij: Die man heeft ons nauwkeurig ondervraagd over onszelf en onze maagschap: leeft uw vader nog? Hebt gij nog een broeder? En wij hebben het hem naar waarheid meegedeeld. Konden wij soms weten, dat hij zou zeggen: brengt uw broeder mee? ");
INSERT INTO nldnbg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","En Juda zeide tot zijn vader Israël: Laat de jongen toch met mij meegaan; dan zullen wij ons gereed maken en op reis gaan, opdat wij in het leven mogen blijven en niet sterven, zowel wij als gij en onze kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ik blijf borg voor hem; van mijn hand moogt gij hem eisen; indien ik hem niet tot u breng en vóór u stel, dan moge ik te allen tijde tegenover u als een schuldige staan. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hadden wij niet getalmd, dan zouden wij zeker al tweemaal terug zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Toen zeide hun vader Israël tot hen: Indien het zo gesteld is, doet dan dit: neemt van het fijnste des lands in uw zakken en brengt die man een geschenk: een weinig balsem en een weinig honig, gom en hars, terpentijnnoten en amandelen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","En neemt dubbel geld mee; ook het geld, dat boven in uw zakken gelegd was, moet gij terugbrengen; misschien was het een vergissing. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","En neemt uw broeder mee, maakt u reisvaardig en keert terug tot die man. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","En God, de Almachtige, geve u barmhartigheid voor het aangezicht van die man, opdat hij uw andere broeder late gaan, alsook Benjamin. En wat mij aangaat, als ik van kinderen beroofd moet worden, dan worde ik beroofd. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Toen namen de mannen dat geschenk en zij namen dubbel geld mee, benevens Benjamin; zij maakten zich reisvaardig, trokken naar Egypte en stonden voor het aangezicht van Jozef. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Toen Jozef Benjamin bij hen zag, zeide hij tot zijn huisbestuurder: Breng deze mannen in huis en slacht slachtvee en bereid het, want hedenmiddag zullen deze mannen met mij eten. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","En de man deed zoals Jozef gezegd had, en bracht hen in Jozefs huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","De mannen werden bevreesd, toen zij naar Jozefs huis gebracht werden, en zeiden: Wij worden hier gebracht vanwege het geld dat de eerste maal in onze zakken is teruggekomen, om ons te overrompelen en te overvallen, en om ons tot slaven te maken en onze ezels weg te nemen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","En zij traden toe op de man die Jozefs huisbestuurder was, en spraken tot hem aan de ingang van het huis, ");
INSERT INTO nldnbg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","en zeiden: Met uw verlof, mijn heer, wij zijn reeds een vorige maal gekomen om voedsel te kopen; ");
INSERT INTO nldnbg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","en toen wij in het nachtverblijf kwamen, en onze zakken openden – daar lag ieders geld boven in zijn zak, ons geld naar zijn volle gewicht. Maar wij hebben het mee teruggebracht, ");
INSERT INTO nldnbg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","en ander geld hebben wij meegenomen om voedsel te kopen; wij weten niet, wie ons geld in onze zakken gelegd heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Doch hij zeide: Weest gerust, vreest niet; de God van u en van uw vader heeft u heimelijk een schat in uw zakken gegeven; uw geld heb ik ontvangen. Vervolgens bracht hij Simeon bij hen terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Toen die man hen in Jozefs huis gebracht had, gaf hij water om hun voeten te wassen, en hij gaf voeder aan hun ezels. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Daarop legden zij het geschenk gereed tegen het ogenblik, waarop Jozef in de middag zou komen, want zij hadden gehoord, dat zij daar een maaltijd zouden gebruiken. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Toen Jozef het huis binnengekomen was, brachten zij het geschenk dat zij bij zich hadden, bij hem binnen en zij bogen zich voor hem ter aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Daarop vroeg hij hen naar hun welstand en zeide: is het wèl met uw oude vader, over wie gij gesproken hebt? Leeft hij nog? ");
INSERT INTO nldnbg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","En zij zeiden: Het is wèl met uw knecht, onze vader; hij leeft nog. Daarop knielden zij en bogen zich neer. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Toen hij zijn ogen opsloeg, zag hij zijn broeder Benjamin, de zoon zijner moeder, en zeide: Is dit uw jongste broeder, over wie gij tot mij gesproken hebt? En hij zeide: God zij u genadig, mijn zoon. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Toen haastte Jozef zich weg, want zijn hart ging in ontroering uit naar zijn broeder, en hij zocht gelegenheid om te wenen; hij trad een kamer binnen en weende daar. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Daarna wies hij zijn gelaat en trad naar buiten, bedwong zichzelf en zeide: Dient het maal op. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Toen dienden zij het op voor hem afzonderlijk en voor hen afzonderlijk en voor de Egyptenaren die met hem aten, afzonderlijk; de Egyptenaren toch mogen geen maaltijd gebruiken met de Hebreeën, want dat is voor de Egyptenaren een gruwel. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","En zij zaten voor zijn aangezicht, de eerstgeborene naar zijn eerstgeboorte en de jongste naar zijn jeugd, zodat de mannen elkander verbaasd aanzagen. ");
INSERT INTO nldnbg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","En men bracht hun van de gerechten die vóór hem stonden, en het gerecht voor Benjamin was vijfmaal zo groot als het gerecht van ieder hunner. Zo dronken zij en werden dronken met hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","En hij beval zijn huisbestuurder: Vul de zakken der mannen met koren, zoveel zij kunnen vervoeren, en leg ieders geld boven in zijn zak. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","En mijn beker, de zilveren beker, moet gij boven in de zak van de jongste leggen met het geld voor zijn koren. En hij deed naar het woord, dat Jozef gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Toen de morgen aanlichtte, liet men de mannen weggaan, met hun ezels. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nauwelijks waren zij de stad uitgegaan, nog niet ver weg, of Jozef zeide tot zijn huisbestuurder: Maak u op, jaag die mannen achterna, en als gij hen ingehaald hebt, zeg dan tot hen: Waarom hebt gij goed met kwaad vergolden? (Waarom hebt gij de zilveren beker gestolen?) ");
INSERT INTO nldnbg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is deze het niet, waaruit mijn heer drinkt en waarmede hij de toekomst pleegt te voorspellen? Gij hebt slecht gehandeld met dit te doen. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Toen hij hen ingehaald had, sprak hij deze woorden tot hen. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","En zij zeiden tot hem: Waarom spreekt mijn heer zulke woorden? Verre zij het van uw knechten zo iets te doen. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Zie, het geld dat wij boven in onze zakken vonden, hebben wij uit het land Kanaän tot u teruggebracht, en hoe zouden wij dan uit het huis van uw heer zilver of goud stelen? ");
INSERT INTO nldnbg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Degene van uw knechten, bij wie (de beker) gevonden wordt, moge sterven, en bovendien zullen wij mijn heer tot slaven zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Daarop zeide hij: Welaan, het zij zoals gij gezegd hebt; degene, bij wie hij gevonden wordt, die zal mij tot slaaf zijn, maar gij zult vrij uitgaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Toen haastte ieder van hen zich zijn zak af te laden op de grond, en ieder opende zijn zak. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","En hij stelde een onderzoek in; hij begon bij de oudste en eindigde bij de jongste; en de beker werd gevonden in Benjamins zak. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Toen scheurden zij hun klederen, en ieder van hen belaadde zijn ezel en zij keerden terug naar de stad. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zo kwamen Juda en zijn broeders in het huis van Jozef, waar hij nog was, en zij wierpen zich voor hem ter aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","En Jozef zeide tot hen: Wat is dat voor daad, die gij bedreven hebt? Wist gij niet, dat een man als ik dat ongetwijfeld ontdekken moest? ");
INSERT INTO nldnbg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Daarop zeide Juda: Wat zullen wij tot mijn heer zeggen, wat zullen wij spreken, en waarmee zullen wij ons rechtvaardigen? God heeft de schuld uwer knechten aan het licht gebracht. Zie, wij zijn slaven voor mijn heer, wij evenals degene, bij wie de beker gevonden is. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Maar hij zeide: Het zij verre van mij dat te doen; de man, bij wie de beker gevonden is, die zal mij tot slaaf zijn, maar gij, trekt in vrede naar uw vader. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Toen naderde Juda tot hem en zeide: Met uw verlof, mijn heer, uw knecht moge toch een enkel woord ten aanhoren van mijn heer spreken en uw toorn ontbrande niet tegen uw knecht, want gij zijt als Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mijn heer heeft zijn knechten gevraagd: Hebt gij nog een vader of een broeder? ");
INSERT INTO nldnbg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","En wij zeiden tot mijn heer: Wij hebben een oude vader en daar is nog een jonge zoon zijns ouderdoms; maar zijn broeder is dood; hij is de enig overgeblevene van zijn moeder, en zijn vader heeft hem zeer lief. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Toen zeidet gij tot uw knechten: Brengt hem tot mij, opdat ik mijn ogen op hem sla. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Maar wij zeiden tot mijn heer: De jongen kan zijn vader niet verlaten, want verlaat hij zijn vader, dan zal deze sterven. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Daarop zeidet gij tot uw knechten: Indien uw jongste broeder niet met u meekomt, zult gij mijn aangezicht niet meer zien. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nadat wij naar uw knecht, mijn vader, waren teruggereisd, deelden wij hem de woorden van mijn heer mee. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Toen nu onze vader zeide: Gaat ons weer een weinig voedsel kopen, ");
INSERT INTO nldnbg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","zeiden wij: Wij kunnen niet heentrekken; als onze jongste broeder bij ons is, dan zullen wij heentrekken; want wij zullen het aangezicht van die man niet mogen zien, wanneer onze jongste broeder niet bij ons is. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Daarop zeide uw knecht, mijn vader, tot ons: Gij weet, dat mijn vrouw mij twee zonen heeft gebaard; ");
INSERT INTO nldnbg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","de éne is van mij weggegaan, en ik heb moeten zeggen: voorzeker is hij verscheurd, en ik heb hem tot nu toe niet weergezien. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","En neemt gij ook deze van mij weg, en overkomt hem een ongeluk, dan zult gij mijn grijze haar met verdriet in het dodenrijk doen neerdalen. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","En nu, wanneer ik bij uw knecht, mijn vader, kom, en de jongen is niet bij ons, aan wiens ziel zijn eigen ziel nauw verbonden is, ");
INSERT INTO nldnbg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","dan zal het gebeuren, als hij ziet, dat de jongen er niet is, dat hij sterven zal, en uw knechten zullen het grijze haar van uw knecht, onze vader, met verdriet in het dodenrijk doen neerdalen. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Maar uw knecht is borg geworden voor de jongen bij mijn vader met deze woorden: indien ik hem niet tot u breng, dan moge ik te allen tijde tegenover mijn vader schuldig staan. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Nu dan, laat toch uw knecht in de plaats van de jongen als slaaf voor mijn heer achterblijven, en de jongen trekke met zijn broeders mee. ");
INSERT INTO nldnbg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Want hoe zal ik naar mijn vader heentrekken, wanneer de jongen niet bij mij is? Ik zou het verdriet niet kunnen aanzien, dat mijn vader zou treffen. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Toen kon Jozef zich niet langer bedwingen voor allen die bij hem stonden, en hij riep: Laat allen van mij weggaan. En daar stond niemand bij hem, toen Jozef zich aan zijn broeders bekend maakte. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Daarop brak hij uit in luid geween, zodat de Egyptenaren en Farao’s huis het hoorden. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","En Jozef zeide tot zijn broeders: Ik ben Jozef; leeft mijn vader nog? Doch zijn broeders konden hem niet antwoorden, want zij deinsden van schrik voor hem terug. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Toen zeide Jozef tot zijn broeders: Komt toch naderbij. Daarop naderden zij. En hij zeide: Ik ben uw broeder Jozef, die gij naar Egypte verkocht hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Maar weest nu niet verdrietig en ziet er niet zo ontsteld uit, omdat gij mij hierheen verkocht hebt, want om u in het leven te behouden heeft God mij voor u uit gezonden. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Want reeds twee jaren is er hongersnood geweest in dit land en er komen nog vijf jaren, waarin niet geploegd of geoogst zal worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Daarom heeft God mij voor u uit gezonden om u een voortbestaan te verzekeren op aarde, en om voor u een groot aantal geredden in het leven te behouden. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Dus zijt gij het niet, die mij hierheen gezonden hebt, maar God; Hij heeft mij gesteld tot Farao’s vader en tot heer over geheel zijn huis en tot heerser in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Trekt haastig naar mijn vader en zegt tot hem: Zo zegt uw zoon Jozef: God heeft mij gesteld tot heer over geheel Egypte, kom tot mij, draal niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gij zult in het land Gosen wonen en gij zult dicht bij mij zijn, gij en uw kinderen en uw kindskinderen, uw kleinvee en uw runderen en al wat gij hebt. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","En ik zal daar voor u zorgen – want er zal nog vijf jaar hongersnood zijn – opdat gij niet verarmt, gij, noch uw huis, noch iemand van de uwen. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","En zie, uw eigen ogen en die van mijn broeder Benjamin zien, dat het mijn mond is, die tot u spreekt. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Vertelt dan aan mijn vader al de heerlijkheid die ik in Egypte bezit, en alles wat gij gezien hebt, en brengt mijn vader haastig hierheen. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Toen viel hij zijn broeder Benjamin om de hals en weende, en Benjamin weende aan zijn hals. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","En hij kuste al zijn broeders hartelijk en weende, hen omhelzende. Daarna eerst spraken zijn broeders met hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Toen het gerucht in Farao’s huis vernomen werd, dat Jozefs broeders waren gekomen, was dit Farao en zijn dienaren aangenaam. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","En Farao zeide tot Jozef: Zeg tot uw broeders: doet dit: belaadt uw dieren en trekt heen naar het land Kanaän, ");
INSERT INTO nldnbg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","en haalt uw vader en uw gezinnen en komt tot mij, dan zal ik u het beste van het land Egypte geven, zodat gij het vette des lands eten zult. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Voorts hebt gij de opdracht hun te gelasten: Neemt u uit het land Egypte wagens voor uw kinderen en voor uw vrouwen, brengt uw vader mee en komt (herwaarts). ");
INSERT INTO nldnbg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gij moet het niet jammer vinden van uw huisraad, want het beste van het gehele land Egypte zal voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Toen deden de zonen van Israël aldus; en Jozef gaf hun wagens volgens Farao’s bevel; ook gaf hij hun teerkost voor de reis. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Aan hen allen, man voor man, gaf hij een stel kostbare klederen en aan Benjamin gaf hij drie honderd zilverstukken en vijf stel kostbare klederen. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Daarbij zond hij zijn vader tien ezels, beladen met het beste van Egypte, en tien ezelinnen, beladen met koren en brood en voedsel, voor zijn vader op de reis. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Hierop deed hij zijn broeders uitgeleide, en zij gingen heen, en hij zeide tot hen: Maakt geen twist onderweg. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Zij dan trokken weg uit Egypte en kwamen in het land Kanaän bij hun vader Jakob. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Toen zij hem vertelden: Jozef leeft nog en hij is zelfs heerser over het gehele land Egypte, bleef zijn hart er koud onder, want hij kon het niet geloven. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Maar toen zij hem al de woorden overbrachten, die Jozef tot hen gesproken had, en toen hij de wagens zag, die Jozef gezonden had om hem te vervoeren, leefde de geest van hun vader Jakob op. ");
INSERT INTO nldnbg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","En Israël zeide: Het is genoeg, mijn zoon Jozef leeft nog; ik wil gaan en hem zien, eer ik sterf. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","En Israël brak op met alles wat hij had en kwam te Berseba en bracht de God van zijn vader Isaak slachtoffers. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","En God sprak tot Israël in nachtgezichten, en Hij zeide: Jakob, Jakob. En hij zeide: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Toen zeide Hij: Ik ben God, de God van uw vader, vrees niet naar Egypte te trekken, want Ik zal u daar tot een groot volk maken. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ik zal zelf met u naar Egypte trekken en Ik zal u ook zeker weer terugvoeren en Jozef zal u de ogen toedrukken. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Toen ging Jakob uit Berseba op weg, en de zonen van Israël vervoerden hun vader Jakob, benevens hun kinderen en hun vrouwen, op de wagens die Farao gezonden had om hem te vervoeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Zij namen ook mee hun vee en hun have, die zij in het land Kanaän verworven hadden, en zij kwamen in Egypte, Jakob en al zijn kroost met hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Zijn zonen en kleinzonen, zijn dochters en kleindochters en zijn gehele kroost bracht hij met zich naar Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dit nu zijn de namen van de zonen van Israël, die in Egypte kwamen, van Jakob en zijn zonen. De eerstgeborene van Jakob was Ruben. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","De zonen van Ruben waren Chanok, Pallu, Chesron en Karmi. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","De zonen van Simeon waren Jemuël, Jamin, Ohad, Jakin, Sochar en Saul, de zoon van een Kanaänitische. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","De zonen van Levi waren Gerson, Kehat en Merari. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","De zonen van Juda waren Er, Onan, Sela, Peres en Zerach; doch Er en Onan waren in het land Kanaän gestorven; en de zonen van Peres waren Chesron en Chamul. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","De zonen van Issakar waren Tola, Puwwa, Job en Simron. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","De zonen van Zebulon waren Sered, Elon en Jachleël. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dit waren de zonen van Lea, die zij aan Jakob gebaard heeft in Paddan-Aram, benevens zijn dochter Dina. Het gehele zielental van zijn zonen en dochters was drieëndertig. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","De zonen van Gad waren Sifjon, Chaggi, Suni, Esbon, Eri, Arodi en Areli. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","De zonen van Aser waren Jimna, Jiswa, Jiswi en Beria, benevens hun zuster Serach, en de zonen van Beria waren Cheber en Malkiël. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dit waren de zonen van Zilpa, die Laban aan zijn dochter Lea gegeven had, en zij baarde dezen aan Jakob – zestien zielen. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","De zonen van Rachel, de vrouw van Jakob, waren Jozef en Benjamin. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","En aan Jozef werden in het land Egypte Manasse en Efraïm geboren, die Asnat, de dochter van Potifera, de priester van On, hem baarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","De zonen van Benjamin waren Bela, Beker, Asbel, Gera, Naäman, Echi, Ros, Muppim, Chuppim en Ard. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dit waren de zonen van Rachel, die aan Jakob geboren werden, het gehele zielental veertien. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","De zoon van Dan was Chusim. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","De zonen van Naftali waren Jachseël, Guni, Jeser en Sillem. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dit waren de zonen van Bilha, die Laban aan zijn dochter Rachel gegeven had, en zij baarde dezen aan Jakob, het gehele zielental zeven. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Alle personen die met Jakob naar Egypte kwamen, zijn afstammelingen, behalve de vrouwen der zonen van Jakob, het gehele zielental was zesenzestig. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","En de zonen van Jozef, die hem in Egypte geboren waren, waren twee in getal. Het gehele getal der zielen van het huis van Jakob, die naar Egypte kwamen, was zeventig. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Hij dan zond Juda voor zich uit naar Jozef, opdat deze hem in Gosen zou ontmoeten. En zij kwamen in het land Gosen aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","En Jozef spande zijn wagen aan en trok naar Gosen, zijn vader Israël tegemoet. Toen hij hem ontmoette, viel hij hem om de hals en weende geruime tijd aan zijn hals. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Toen zeide Israël tot Jozef: Nu kan ik sterven, nadat ik uw aangezicht gezien heb, omdat gij nog leeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","En Jozef zeide tot zijn broeders en tot het huis zijns vaders: Ik zal heengaan, het Farao meedelen en hem zeggen: mijn broeders en het huis mijns vaders, die in het land Kanaän waren, zijn tot mij gekomen; ");
INSERT INTO nldnbg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","die mannen zijn schaapherders, want zij zijn veehouders en hebben hun kleinvee, hun runderen en alles wat zij bezitten, meegebracht. ");
INSERT INTO nldnbg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","En wanneer Farao u roept en zegt: wat is uw bedrijf? ");
INSERT INTO nldnbg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","zegt dan: uw knechten zijn veehouders geweest van onze jeugd aan tot heden, zowel wij als onze vaderen – opdat gij in het land Gosen moogt wonen, want al wat schaapherder is, is voor de Egyptenaren een gruwel. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Toen kwam Jozef bij Farao, deelde het hem mee, en zeide: Mijn vader en mijn broeders zijn met hun kleinvee, hun runderen en al wat zij bezitten, gekomen uit het land Kanaän, en zij zijn in het land Gosen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Nu had hij vijf mannen uit zijn broeders meegenomen, en hij stelde die aan Farao voor. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","En Farao zeide tot zijn broeders: Wat is uw bedrijf? Daarop zeiden zij tot Farao: Uw knechten zijn schaapherders, wij evenals onze vaderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ook zeiden zij tot Farao: Wij zijn gekomen om als vreemdelingen in dit land te vertoeven, want er is geen weide meer voor de kudde, die uw knechten hebben, omdat de hongersnood zwaar is in het land Kanaän; nu dan, sta uw knechten toe in het land Gosen te wonen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Toen zeide Farao tot Jozef: Uw vader en uw broeders zijn tot u gekomen; ");
INSERT INTO nldnbg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","het land Egypte ligt voor u open. Wijs uw vader en uw broeders in het beste deel van het land woonplaatsen aan, laten zij in het land Gosen wonen; indien gij weet, dat onder hen flinke mannen zijn, stel die dan tot opzichters over mijn kudde aan. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ook bracht Jozef zijn vader Jakob en stelde hem aan Farao voor. En Jakob zegende Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Toen zeide Farao tot Jakob: Hoe groot is het getal van uw levensjaren? ");
INSERT INTO nldnbg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","En Jakob zeide tot Farao: Het getal der jaren mijner vreemdelingschap is honderd en dertig; weinig in getal en kwaad zijn al mijn levensjaren geweest, en zij hebben niet bereikt het getal der levensjaren van mijn vaderen in de dagen hunner vreemdelingschap. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Toen zegende Jakob Farao en ging van Farao heen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jozef nu wees zijn vader en zijn broeders woonplaatsen aan en gaf hun grondbezit in het land Egypte, in het beste deel van het land, in het land Rameses, zoals Farao geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","En Jozef onderhield zijn vader, zijn broeders en het gehele huis zijns vaders met brood, naar het getal der kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Er was nu in het gehele land geen brood, want de hongersnood was zeer zwaar, en het land Egypte en het land Kanaän raakten uitgeput tengevolge van de honger. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","En Jozef zamelde al het geld in, dat zich in het land Egypte en in het land Kanaän bevond, voor het koren dat men kwam kopen, en Jozef bracht het geld in Farao’s huis. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Toen het geld uit het land Egypte en uit het land Kanaän op was, kwamen alle Egyptenaren tot Jozef en zeiden: Geef ons brood! Waarom toch zouden wij voor uw ogen sterven? Want er is geen geld meer. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","En Jozef zeide: Geeft uw vee, dan zal ik u (brood) geven in ruil voor uw vee, indien er geen geld meer is. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Toen brachten zij hun vee tot Jozef, en Jozef gaf hun brood in ruil voor de paarden, het kleinvee, het rundvee en de ezels, en hij voorzag hen in dat jaar van brood in ruil voor al hun vee. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Toen dat jaar ten einde was, kwamen zij tot hem in het tweede jaar en zeiden tot hem: Wij zullen het voor mijn heer niet verhelen dat, nu het geld op is en onze veestapel aan mijn heer is gekomen, er voor mijn heer niet anders overblijft dan ons lichaam en onze grond. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Waarom zouden wij voor uw ogen sterven, en zou onze grond verkommeren? Koop ons en onze grond in ruil voor brood; en wij en onze grond zullen Farao dienstbaar zijn. Geef ons dan zaad, opdat wij leven en niet sterven, en opdat de grond niet woest worde. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Toen kocht Jozef al de grond der Egyptenaren voor Farao, want de Egyptenaren verkochten ieder zijn akker, omdat de honger hun te sterk werd. Zo kwam het land aan Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","En wat het volk aangaat, dat maakte hij dienstbaar van het ene einde van het gebied van Egypte tot het andere einde. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Alleen de grond der priesters kocht hij niet, want de priesters hadden vaste inkomsten van Farao, en zij leefden van hun vaste inkomsten, die Farao hun gegeven had, daarom verkochten zij hun grond niet. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","En Jozef zeide tot het volk: Zie, ik heb heden u en uw grond voor Farao gekocht; zie, hier is zaad voor u, opdat gij de grond kunt bezaaien. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Maar van de opbrengst zult gij een vijfde deel aan Farao geven, en vier delen zullen voor u zijn tot zaad voor de akker en tot voedsel voor u en voor hen die in uw huizen zijn, en tot spijze voor uw kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Toen zeiden zij: Gij hebt ons in het leven behouden; mogen wij de genegenheid van mijn heer winnen, dan zullen wij Farao dienstbaar zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","En Jozef maakte het tot een inzetting tot op de huidige dag met betrekking tot het grondbezit in Egypte, dat Farao daarvan een vijfde deel zou hebben; alleen de grond der priesters kwam niet aan Farao. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israël dan woonde in het land Egypte, in het land Gosen, en zij werden daar ingezetenen. Zij waren vruchtbaar en vermenigvuldigden zich zeer. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","En Jakob leefde in het land Egypte nog zeventien jaar, en de dagen van Jakob, de jaren zijns levens, waren honderd zevenenveertig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Toen de tijd naderde, dat Israël sterven zou, riep hij zijn zoon Jozef en zeide tot hem: Indien gij mij genegenheid toedraagt, leg dan uw hand onder mijn heup, (en zweer) dat gij mij liefde en trouw zult bewijzen: begraaf mij niet in Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Want ik wil bij mijn vaderen liggen, vervoer mij daarom uit Egypte en begraaf mij in hun graf. En hij zeide: Ik zal doen naar uw woord. ");
INSERT INTO nldnbg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Daarop zeide hij: Zweer het mij dan. En hij zwoer het hem. En Israël boog zich aanbiddend neder aan het hoofdeinde van het bed. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hierna gebeurde het, dat men tot Jozef zeide: Zie, uw vader is ziek. Daarop nam hij zijn beide zonen met zich, Manasse en Efraïm. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Toen men aan Jakob meegedeeld had: Zie, uw zoon Jozef komt tot u, verzamelde Israël al zijn krachten en ging op het bed zitten. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","En Jakob zeide tot Jozef: God, de Almachtige, is mij verschenen te Luz in het land Kanaän en heeft mij gezegend ");
INSERT INTO nldnbg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","en tot mij gezegd: zie, Ik zal u vruchtbaar maken, u vermenigvuldigen en u maken tot een menigte van volken; Ik zal dit land aan uw nageslacht geven tot een altoosdurende bezitting. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","En nu, uw beide zonen, die u in het land Egypte geboren zijn, voordat ik tot u naar Egypte gekomen was, zij zijn de mijne; Efraïm en Manasse zullen mij als Ruben en Simeon zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Maar uw nakomelingen, die gij na hen verwekt hebt, zullen de uwe zijn; naar de naam hunner broeders zullen zij genoemd worden in hun erfdeel. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Wat mij aangaat, toen ik uit Paddan kwam, is Rachel mij door de dood ontvallen in het land Kanaän op de reis, toen wij nog maar een eindweegs van Efrat verwijderd waren, en heb ik haar daar begraven aan de weg naar Efrat, dat is Betlehem. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Toen Israël de zonen van Jozef zag, zeide hij: Wie zijn dit? ");
INSERT INTO nldnbg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","En Jozef zeide tot zijn vader: Dat zijn mijn zonen, die God mij hier gegeven heeft. Daarop zeide hij: Breng hen toch tot mij, opdat ik hen zegene. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israëls ogen nu waren dof geworden van ouderdom, hij kon niet zien. En (Jozef) bracht hen dichter bij hem; en hij kuste en omhelsde hen. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Daarna zeide Israël tot Jozef: Ik had niet kunnen vermoeden, dat ik uw aangezicht zou zien, en zie, God heeft mij zelfs uw nageslacht doen zien. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Toen deed Jozef hen van zijn knieën weggaan, en boog zich neer met zijn aangezicht ter aarde. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","En Jozef nam hen beiden, met zijn rechterhand Efraïm aan Israëls linkerhand, en met zijn linkerhand Manasse aan Israëls rechterhand, en hij bracht hen dichter bij hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Toen strekte Israël zijn rechterhand uit en legde die op het hoofd van Efraïm, hoewel hij de jongste was, en zijn linkerhand op het hoofd van Manasse; hij legde zijn handen kruiselings, ofschoon Manasse de eerstgeborene was. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","En hij zegende Jozef en zeide: God, voor wiens aangezicht mijn vaderen Abraham en Isaak gewandeld hebben; God, die mij als herder geleid heeft, mijn leven lang tot op deze dag; ");
INSERT INTO nldnbg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","de Engel, die mij verlost heeft uit alle nood, zegene deze jongelingen, zodat in hen mijn naam en die van mijn vaderen Abraham en Isaak voortleven en zij in menigte mogen toenemen in het land. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Toen Jozef zag, dat zijn vader zijn rechterhand op Efraïms hoofd gelegd had, was dat verkeerd in zijn ogen, en hij greep de hand van zijn vader om die van Efraïms hoofd te verleggen naar het hoofd van Manasse. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","En Jozef zeide tot zijn vader: Zó niet, mijn vader, want deze is de eerstgeborene, leg uw rechterhand op zíjn hoofd. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maar zijn vader weigerde het en zeide: Ik weet het, mijn zoon, ik weet het; ook hij zal tot een volk worden en ook hij zal groot worden; nochtans zal zijn jongere broeder groter zijn dan hij, en diens nageslacht zal een volheid van volken worden. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","En hij zegende hen te dien dage en zeide: Met u zal Israël zegen toewensen door te zeggen: God make u als Efraïm en als Manasse. En hij plaatste Efraïm vóór Manasse. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","En Israël zeide tot Jozef: Zie, ik ga sterven, maar God zal met u zijn en u terugbrengen naar het land uwer vaderen. ");
INSERT INTO nldnbg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","En ik geef u, boven uw broeders, een bergrug, die ik met mijn zwaard en mijn boog aan de Amorieten heb ontrukt. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","En Jakob ontbood zijn zonen en zeide: Komt bijeen, opdat ik u bekend make, wat u in toekomende dagen wedervaren zal. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Verzamelt u en luistert, gij zonen van Jakob, luistert naar Israël, uw vader. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, mijn eerstgeborene zijt gij, mijn sterkte en de eersteling mijner kracht, de voornaamste in hoogheid, de voornaamste in vermogen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Gij, die opbruist als water, gij zult de voornaamste niet zijn, omdat gij uws vaders bed beklommen hebt; toen hebt gij het ontwijd. Hij heeft mijn legerstede beklommen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon en Levi zijn broeders; hun gereedschappen zijn werktuigen van geweld. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mijn ziel hebbe geen deel aan hun beraadslaging, mijn geest sluite zich niet aan bij hun vergadering, want in hun toorn hebben zij mannen gedood en in hun moedwil hebben zij runderen de pezen doorgesneden. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Vervloekt zij hun toorn, want die is hevig, en hun grimmigheid, want die is hard. Ik zal hen verdelen onder Jakob en verstrooien onder Israël. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, ù zullen uw broeders loven, uw hand zal zijn op de nek uwer vijanden, voor u zullen uws vaders zonen zich neerbuigen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Een leeuwewelp is Juda; na de roof zijt gij omhoog geklommen, mijn zoon; hij kromt zich, legt zich neder als een leeuw of als een leeuwin; wie durft hem opjagen? ");
INSERT INTO nldnbg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","De scepter zal van Juda niet wijken, noch de heersersstaf tussen zijn voeten, totdat Silo komt, en hem zullen de volken gehoorzaam zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Hij zal zijn ezel aan de wijnstok binden en het jong zijner ezelin aan de wingerd; hij zal zijn kleed in wijn wassen en in druivebloed zijn gewaad. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Hij zal donkerder van ogen zijn dan wijn en witter van tanden dan melk. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon zal wonen aan het strand der wijde zee, ja, hij zal wonen aan het strand bij de schepen, en zijn zijde zal naar Sidon gekeerd zijn. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar is een bonkige ezel, die tussen de stallingen ligt; ");
INSERT INTO nldnbg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","als hij ziet, dat de rust goed is, en dat het land liefelijk is, buigt hij zijn schouder om te torsen en leent zich tot slaafse herendienst. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan zal zijn volk richten als een der stammen Israëls. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Moge Dan een slang op de weg zijn, een hoornslang op het pad, die in de hielen van het paard bijt, zodat zijn berijder achterover valt. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Op uw heil wacht ik, o Here. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, een bende zal hem belagen, maar hij zal hun hielen belagen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, zijn spijze zal vet zijn, en hij zal koninklijke lekkernijen leveren. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali is een losgelaten hinde; hij laat schone woorden horen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Een jonge vruchtboom is Jozef, een jonge vruchtboom aan een bron; zijn takken stijgen boven de muur uit; ");
INSERT INTO nldnbg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","de boogschutters hebben hem getergd, beschoten en vijandig bejegend, ");
INSERT INTO nldnbg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","maar zijn boog bleef stevig en zijn sterke handen bleven lenig, door de handen van de Machtige Jakobs, daar de Steenrots Israëls zijn herder is; ");
INSERT INTO nldnbg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","door de God uws vaders, die u zal helpen, en de Almachtige, die u zal zegenen met zegeningen des hemels van boven, met zegeningen van de watervloed, die beneden ligt, met zegeningen van de borsten en de moederschoot. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","De zegeningen van uw vader gaan de zegeningen van mijn voorvaderen te boven, reikende tot het kostelijkste der eeuwige heuvelen; zij zullen komen op het hoofd van Jozef, op de schedel van de uitverkorene onder zijn broeders. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is een verscheurende wolf; in de morgen verslindt hij zijn prooi en tegen de avond verdeelt hij de buit. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dit zijn al de stammen van Israël, twaalf in getal; en dit is wat hun vader over hen gesproken heeft, toen hij hen zegende; ieder zegende hij met een eigen zegen. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Daarna gaf hij hun bevel en zeide tot hen: Ik word tot mijn voorgeslacht vergaderd, begraaft mij bij mijn vaderen in de spelonk in het veld van de Hethiet Efron, ");
INSERT INTO nldnbg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in de spelonk in het veld van Makpela, dat tegenover Mamre in het land Kanaän ligt, welk veld Abraham gekocht heeft van de Hethiet Efron tot een eigen grafstede. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Daar heeft men Abraham en zijn vrouw Sara begraven; daar heeft men Isaak en zijn vrouw Rebekka begraven, en daar heb ik Lea begraven; ");
INSERT INTO nldnbg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","het veld met de spelonk daarin, is gekocht van de Hethieten. ");
INSERT INTO nldnbg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Toen Jakob geëindigd had zijn zonen bevelen te geven, trok hij zijn voeten terug op het bed en gaf de geest, en hij werd tot zijn voorgeslacht vergaderd. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Toen wierp Jozef zich op zijns vaders aangezicht en hij beweende hem en kuste hem. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","En Jozef gebood zijn dienaren, de geneesheren, zijn vader te balsemen; en de geneesheren balsemden Israël. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dit duurde bij hem veertig dagen, want zo lang duurden de dagen van het balsemen, en de Egyptenaren beweenden hem zeventig dagen. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","En toen de dagen dat men hem beweende, voorbijgegaan waren, sprak Jozef tot het huis van Farao: Indien ik uw genegenheid gewonnen heb, spreekt dan ten aanhoren van Farao: ");
INSERT INTO nldnbg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","mijn vader heeft mij doen zweren: zie, ik sterf; in mijn graf, dat ik mij in het land Kanaän uitgehouwen heb, daar moet gij mij begraven. Nu dan, laat mij toch heentrekken, opdat ik mijn vader begrave, en dan zal ik terugkeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Daarop zeide Farao: Trek heen en begraaf uw vader, zoals hij u heeft doen zweren. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Toen trok Jozef heen om zijn vader te begraven, en met hem trokken alle dienaren van Farao, de oudsten van zijn huis, en al de oudsten van het land Egypte, ");
INSERT INTO nldnbg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","benevens het gehele huis van Jozef, zijn broeders en het huis zijns vaders; alleen hun kleine kinderen, hun schapen en hun runderen lieten zij in het land Gosen achter. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ook trokken met hem zowel wagens als ruiters, zodat de stoet geweldig groot was. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","En toen zij gekomen waren bij de Doornen-dorsvloer aan de overzijde van de Jordaan, hielden zij daar een grote en zeer plechtige rouwklacht, en hij liet over zijn vader zeven dagen rouw bedrijven. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Toen de inwoners van het land, de Kanaänieten, de rouw op de Doornen-dorsvloer zagen, zeiden zij: Dit is een zware rouw der Egyptenaren; daarom gaf men daaraan de naam Abel-Misraïm, dat aan de overzijde van de Jordaan ligt. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","En zijn zonen deden met hem zoals hij hun geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Zijn zonen vervoerden hem naar het land Kanaän, en zij begroeven hem in de spelonk van het veld van Makpela, welk veld, tegenover Mamre gelegen, Abraham tot een eigen grafstede had gekocht van de Hethiet Efron. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na zijn vader begraven te hebben, keerde Jozef naar Egypte terug, hij en zijn broeders en allen, die waren meegegaan om zijn vader te begraven. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Toen Jozefs broeders zagen, dat hun vader gestorven was, zeiden zij: Als Jozef zich nu maar niet op ons gaat wreken en ons ten volle al het kwaad vergeldt, dat wij hem hebben aangedaan. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Daarom zonden zij Jozef deze boodschap: Uw vader heeft vóór zijn sterven geboden: ");
INSERT INTO nldnbg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","zo moet gij tot Jozef zeggen: och, vergeef toch de overtreding uwer broeders en hun zonde, want zij hebben u kwaad aangedaan. Nu dan, vergeef toch de overtreding der dienaren van de God uws vaders. En Jozef weende, toen men zo tot hem sprak. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ook kwamen zijn broeders zelf, wierpen zich voor hem neer en zeiden: Zie, wij zijn u tot slaven. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Maar Jozef zeide tot hen: Vreest niet, want ben ik in Gods plaats? ");
INSERT INTO nldnbg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gij hebt wel kwaad tegen mij gedacht, maar God heeft dat ten goede gedacht, ten einde te doen, zoals heden het geval is: een groot volk in het leven te behouden. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Vreest dus niet, ik zal u onderhouden en ook uw kinderen. Zo troostte hij hen en sprak tot hun hart. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","En Jozef bleef in Egypte wonen, hij en zijns vaders huis; en Jozef leefde honderd en tien jaar. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","En Jozef zag van Efraïm het derde geslacht; ook de kinderen van Makir, de zoon van Manasse, werden op Jozefs knieën geboren. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","En Jozef zeide tot zijn broeders: Ik ga sterven; God zal zeker naar u omzien en u uit dit land voeren naar het land, dat Hij Abraham, Isaak en Jakob onder ede beloofd heeft. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","En Jozef deed de zonen van Israël zweren: God zal zeker naar u omzien; dan zult gij mijn gebeente van hier meevoeren. ");
INSERT INTO nldnbg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","En Jozef stierf, honderd en tien jaar oud, en men balsemde hem, en hij werd in een kist gelegd, in Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dit nu zijn de namen der zonen van Israël, die met Jakob naar Egypte gekomen zijn; zij kwamen er ieder met zijn gezin: ");
INSERT INTO nldnbg_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi en Juda; ");
INSERT INTO nldnbg_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulon en Benjamin; ");
INSERT INTO nldnbg_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan en Naftali, Gad en Aser. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","De afstammelingen van Jakob waren zeventig zielen in het geheel. Jozef echter was reeds in Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","En Jozef stierf, benevens al zijn broeders en dat gehele geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","De Israëlieten nu waren vruchtbaar en breidden zich snel uit; zij vermenigvuldigden zich en werden uitermate talrijk, zodat het land met hen vervuld werd. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Toen kwam er een nieuwe koning over Egypte, die Jozef niet gekend had. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Deze nu zeide tot zijn volk: Zie, het volk der Israëlieten is groter en talrijker dan wij. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Welnu, laten wij met beleid tegen hen optreden, opdat zij zich niet vermenigvuldigen en zich – als wij in oorlog komen – bij onze tegenstanders aansluiten, tegen ons strijden en uit het land wegtrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Daarom stelde men opzichters van herendiensten over hen aan om hen door de hun opgelegde dwangarbeid te onderdrukken: zij moesten voor Farao voorraadsteden bouwen, Pitom en Raämses. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Maar hoemeer men hen onderdrukte, des te meer vermenigvuldigden zij zich en breidden zij zich uit, zodat men bevreesd werd voor de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Toen lieten de Egyptenaren de Israëlieten onder mishandeling werken; ");
INSERT INTO nldnbg_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ja, zij maakten hun het leven bitter door harde slavenarbeid met leem en tichelstenen en door allerlei arbeid op het veld – alle werk, waartoe zij hen onder mishandeling als slaven gebruikten. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ook beval de koning van Egypte de vroedvrouwen der Hebreeuwse vrouwen, van wie de een Sifra heette en de ander Pua: ");
INSERT INTO nldnbg_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wanneer gij de Hebreeuwse vrouwen bij de bevalling helpt, dan moet gij goed toezien bij de verlossing; indien het een zoon is, dan moet gij hem doden, maar indien het een dochter is, mag zij blijven leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","De vroedvrouwen echter vreesden God en deden niet wat de koning van Egypte haar gezegd had, maar lieten de jongens in leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Toen ontbood de koning van Egypte de vroedvrouwen en zeide tot haar: Waarom hebt gij dit gedaan en de jongens laten leven? ");
INSERT INTO nldnbg_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","En de vroedvrouwen zeiden tot Farao: De Hebreeuwse vrouwen zijn niet als de Egyptische; zij zijn sterk: voordat een vroedvrouw bij haar komt, hebben zij al gebaard. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","En God deed de vroedvrouwen wèl; het volk vermenigvuldigde zich en werd zeer talrijk. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","En daar de vroedvrouwen God vreesden, gaf Hij haar ieder een gezin. ");
INSERT INTO nldnbg_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Toen gebood Farao aan zijn gehele volk: Werpt alle jongens die geboren worden, in de Nijl, maar alle meisjes moogt gij laten leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Een man uit het huis van Levi huwde een Levitische vrouw; ");
INSERT INTO nldnbg_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","deze werd zwanger en baarde een zoon. Toen zij zag, dat hij schoon was, verborg zij hem drie maanden lang. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Maar langer kon zij hem niet verborgen houden; daarom nam zij voor hem een biezen kistje, bestreek het met asfalt en pek, legde het kind erin en zette het in het riet aan de oever van de Nijl; ");
INSERT INTO nldnbg_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","zijn zuster ging op enige afstand staan om te zien, wat er met hem gebeuren zou. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Toen kwam de dochter van Farao om in de Nijl te baden, en intussen wandelden haar dienaressen langs de Nijl; zij zag het kistje in het riet en zond haar slavin om het te halen. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Toen zij het open deed, zag zij het kind, en zie, het jongetje schreide, zodat zij medelijden met hem kreeg en zeide: Dit is een Hebreeuws kind. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Toen zeide zijn zuster tot de dochter van Farao: Zal ik voor u uit de Hebreeuwse vrouwen een voedster gaan roepen, om het kind voor u te zogen? ");
INSERT INTO nldnbg_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","En de dochter van Farao zeide tot haar: Ja. Toen ging het meisje de moeder van het kind roepen. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","En de dochter van Farao zeide tot deze: Neem dit kind mee en zoog het voor mij, dan zal ik u het u toekomende loon geven. Daarop nam de vrouw het kind mee en zoogde het. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","En toen het kind groot geworden was, bracht zij het naar de dochter van Farao; en hij werd door haar als zoon aangenomen, en zij noemde hem Mozes, want, zeide zij: ik heb hem uit het water getrokken. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","In die tijd, toen Mozes groot geworden was, ging hij uit tot zijn broeders en lette op hun dwangarbeid; toen zag hij, hoe een Egyptenaar een Hebreeër, iemand van zijn broeders, sloeg. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Hij keek naar alle kanten, en toen hij zag, dat er niemand was, sloeg hij de Egyptenaar dood en verborg hem in het zand. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Toen hij op een andere dag uitging, zie, daar waren twee Hebreeuwse mannen aan het vechten, en hij zeide tot de schuldige: Waarom slaat gij uw naaste? ");
INSERT INTO nldnbg_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Deze echter zeide: Wie heeft u tot overste en rechter over ons aangesteld? Denkt gij soms mij te doden, zoals gij de Egyptenaar gedood hebt? Daarop werd Mozes bevreesd, want hij dacht: Voorwaar, de zaak is bekend geworden. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Toen Farao van deze zaak hoorde, trachtte hij Mozes te doden, maar Mozes vluchtte voor Farao en zocht verblijf in het land Midjan. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Daar zat hij neer bij een bron. De priester van Midjan nu had zeven dochters; zij kwamen juist water putten en vulden de drinkbakken om de kudde van haar vader te drenken. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Er kwamen echter herders, die haar verjoegen, maar Mozes stond op en kwam haar te hulp en drenkte haar kudde. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Toen zij bij haar vader Reüel gekomen waren, zeide deze: Waarom zijt gij vandaag zo spoedig terug? ");
INSERT INTO nldnbg_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Zij antwoordden: Een Egyptenaar heeft ons geholpen tegen de herders en bovendien volop voor ons geput en de kudde gedrenkt. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Hij zeide tot zijn dochters: En waar is hij? Waarom hebt gij die man achtergelaten? Nodigt hem ten eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","En Mozes bewilligde erin bij de man te blijven, en deze gaf zijn dochter Sippora aan Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zij baarde een zoon en hij noemde hem Gersom, want, zeide hij: ik ben een vreemdeling geworden in een vreemd land. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","In die lange tijd stierf de koning van Egypte; en de Israëlieten zuchtten nog steeds onder de slavernij en schreeuwden het uit, zodat hun hulpgeroep over de slavernij omhoog steeg tot God. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","En God hoorde hun klacht en God gedacht aan zijn verbond met Abraham, Isaak en Jakob. ");
INSERT INTO nldnbg_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Zo zag God de Israëlieten aan en God had bemoeienis met hen. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mozes nu was gewoon de kudde van zijn schoonvader Jetro, de priester van Midjan, te hoeden. Eens, toen hij de kudde naar de overkant van de woestijn geleid had, kwam hij bij de berg Gods, Horeb. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Daar verscheen hem de Engel des Heren als een vuurvlam midden uit een braamstruik. Hij keek toe, en zie, de braamstruik stond in brand, maar werd niet verteerd. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mozes nu dacht: Laat ik toch dat wondere verschijnsel gaan bezien, waarom de braamstruik niet verbrandt. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Toen de Here zag, dat hij het ging bezien, riep God hem uit de braamstruik toe: Mozes, Mozes! En hij antwoordde: Hier ben ik. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Daarop zeide Hij: Kom niet dichterbij: doe uw schoenen van uw voeten, want de plaats, waarop gij staat, is heilige grond. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Voorts zeide Hij: Ik ben de God van uw vader, de God van Abraham, de God van Isaak en de God van Jakob. Toen verborg Mozes zijn gelaat, want hij vreesde God te aanschouwen. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","En de Here zeide: Ik heb terdege gezien de ellende van mijn volk, dat in Egypte is, en hun gejammer over hun drijvers gehoord, ja, Ik ken hun smarten. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Daarom ben Ik nedergedaald om hen uit de macht der Egyptenaren te redden en uit dit land te voeren naar een goed en wijd land, een land vloeiende van melk en honig, naar de woonplaats van de Kanaänieten, Hethieten, Amorieten, Perizzieten, Chiwwieten en Jebusieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","En nu, zie, het gejammer der Israëlieten is tot Mij doorgedrongen; ook heb Ik gezien, hoezeer de Egyptenaren hen verdrukken. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nu dan, ga, Ik zend u tot Farao, om mijn volk, de Israëlieten, uit Egypte te leiden. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Maar Mozes zeide tot God: Wie ben ik, dat ik naar Farao zou gaan en de Israëlieten uit Egypte zou leiden? ");
INSERT INTO nldnbg_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Toen zeide Hij: Ik ben immers met u! En dit zal u het teken zijn, dat Ik u gezonden heb: wanneer gij het volk uit Egypte hebt geleid, zult gij God dienen op deze berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Daarop zeide Mozes tot God: Maar wanneer ik tot de Israëlieten kom en hun zeg: De God uwer vaderen heeft mij tot u gezonden, en zij mij vragen: hoe is zijn naam – wat moet ik hun dan antwoorden? ");
INSERT INTO nldnbg_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Toen zeide God tot Mozes: Ik ben, die Ik ben. En Hij zeide: Aldus zult gij tot de Israëlieten zeggen: Ik ben heeft mij tot u gezonden. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Voorts zeide God tot Mozes: Aldus zult gij tot de Israëlieten zeggen: De Here, de God uwer vaderen, de God van Abraham, de God van Isaak en de God van Jakob, heeft mij tot u gezonden; dit is mijn naam voor eeuwig en zo wil Ik aangeroepen worden van geslacht tot geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ga heen, vergader de oudsten van Israël en zeg tot hen: De Here, de God uwer vaderen, de God van Abraham, Isaak en Jakob is mij verschenen en heeft gezegd: Ik heb terdege acht geslagen op u en op wat u in Egypte wordt aangedaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ik heb gezegd, dat Ik u uit de ellende van Egypte voeren zal naar het land der Kanaänieten, Hethieten, Amorieten, Perizzieten, Chiwwieten en Jebusieten, naar een land vloeiende van melk en honig. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","En zij zullen naar uw stem horen; dan zult gij met de oudsten van Israël naar de koning van Egypte gaan en tot hem zeggen: De Here, de God der Hebreeën, heeft ons ontmoet; nu dan, wij wilden wel drie dagreizen ver de woestijn intrekken om de Here, onze God, een offer te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ik weet echter, dat de koning van Egypte u niet zal toestaan te gaan, zelfs niet door een sterke hand. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Maar Ik zal mijn hand uitstrekken en de Egyptenaren slaan met alle wondertekenen, die Ik in hun midden zal doen; daarna zal hij u laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","En Ik zal bewerken, dat de Egyptenaren dit volk gunstig gezind zijn, zodat gij, wanneer gij wegtrekt, niet ledig wegtrekt: ");
INSERT INTO nldnbg_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","iedere vrouw moet dan van haar buurvrouw en van haar huisgenote zilveren en gouden voorwerpen vragen en klederen, die gij uw zoons en dochters te dragen geeft; zo zult gij de Egyptenaren beroven. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Toen antwoordde Mozes: Maar als zij mij niet geloven en niet naar mij luisteren, doch zeggen: de Here is u niet verschenen? ");
INSERT INTO nldnbg_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","En de Here zeide tot hem: Wat hebt gij daar in uw hand? Hij antwoordde: Een staf. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Daarop zeide Hij: Werp die op de grond. En toen hij die op de grond geworpen had, werd hij een slang, zodat Mozes ervoor wegvluchtte. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Maar de Here zeide tot Mozes: Strek uw hand uit en grijp ze bij de staart – toen strekte hij zijn hand uit en greep haar vast en zij werd een staf in zijn hand – ");
INSERT INTO nldnbg_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","opdat zij geloven, dat de Here, de God hunner vaderen, de God van Abraham, de God van Isaak en de God van Jakob, u verschenen is. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Wederom zeide de Here tot hem: Steek uw hand in uw boezem. En hij stak zijn hand in zijn boezem en toen hij ze eruit trok, zie, zijn hand was melaats, sneeuwwit. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Daarop zeide Hij: Steek uw hand opnieuw in uw boezem. En hij stak zijn hand opnieuw in zijn boezem en toen hij ze eruit trok, zie, zij was weer geworden als zijn overige vlees. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Indien zij u niet geloven en geen acht geven op wat het eerste teken te zeggen heeft, dan zullen zij geloven wat het tweede teken te zeggen heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","En indien zij ook deze beide tekenen niet geloven en naar u niet luisteren, dan zult gij Nijlwater nemen en uitgieten op het droge, en het water dat gij uit de Nijl neemt, zal bloed worden op het droge. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Toen zeide Mozes tot de Here: Och Here, ik ben geen man van het woord, noch sinds gisteren, noch sinds eergisteren, noch sinds Gij tot uw knecht gesproken hebt, want ik ben zwaar van mond en zwaar van tong. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Maar de Here zeide tot hem: Wie heeft de mens een mond gegeven, wie maakt stom of doof, ziende of blind; ben Ik het niet, de Here? ");
INSERT INTO nldnbg_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nu dan, ga heen. Ik zal met uw mond zijn en u leren, wat gij spreken moet. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Maar hij zeide: Och Here, zend toch iemand anders. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Toen ontbrandde de toorn des Heren tegen Mozes en Hij zeide: Is niet de Leviet Aäron uw broeder? Ik weet, dat hij goed spreekt; en zie, hij is op weg gegaan, u tegemoet, en als hij u ziet, zal hij zich van harte verheugen. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Dan zult gij tot hem spreken en de woorden in zijn mond leggen, en Ik zal zijn met uw mond en zijn mond en Ik zal u leren, wat gij doen moet. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Hij zal voor u tot het volk spreken en zo zal hij u tot een mond zijn en gij zult hem tot God zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","En deze staf, waarmede gij de tekenen moet doen, moet gij in uw hand nemen. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Toen keerde Mozes naar zijn schoonvader Jeter terug en zeide tot hem: Ik wilde wel terugkeren naar mijn broeders, die in Egypte zijn, en zien, of zij nog leven. En Jetro zeide tot Mozes: Ga in vrede. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Want de Here had tot Mozes in Midjan gezegd: Keer terug naar Egypte, want alle mannen, die u naar het leven stonden, zijn dood. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Daarop nam Mozes zijn vrouw en zijn zonen, zette hen op een ezel en keerde naar het land Egypte terug; ook nam Mozes de staf Gods in zijn hand. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","En de Here zeide tot Mozes: Nu gij gaat terugkeren naar Egypte, zie toe, dat gij voor het aangezicht van Farao al de wonderen doet, die Ik in uw macht gesteld heb. Maar Ik zal zijn hart verharden, zodat hij het volk niet zal laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dan zult gij tot Farao zeggen: Zo zegt de Here: Israël is mijn eerstgeboren zoon; ");
INSERT INTO nldnbg_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","daarom zeg Ik u: laat mijn zoon gaan, opdat hij Mij diene; zoudt gij echter weigeren hem te laten gaan, dan zal Ik uw eerstgeboren zoon doden. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Onderweg nu, in een nachtverblijf, kwam de Here hem tegen en zocht hem te doden. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Toen nam Sippora een stenen mes, besneed de voorhuid van haar zoon, raakte daarmee zijn voeten aan en zeide: Voorzeker, gij zijt mij een bloedbruidegom. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","En Hij liet hem met rust. Bloedbruidegom, zeide zij toen, met het oog op de besnijdenis. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","En de Here zeide tot Aäron: Ga Mozes in de woestijn tegemoet. Hij ging en ontmoette hem bij de berg Gods en kuste hem. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mozes nu deelde Aäron al de woorden van de Here mede, met welke Hij hem gezonden had, en al de tekenen, die Hij hem had opgedragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","En Mozes ging met Aäron op weg en zij verzamelden al de oudsten der Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aäron sprak al de woorden, die de Here tot Mozes gesproken had, en hij deed de tekenen voor de ogen van het volk. ");
INSERT INTO nldnbg_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Het volk nu geloofde, en toen zij hoorden, dat de Here op de Israëlieten acht geslagen en hun ellende gezien had, knielden zij en bogen zich neder. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Daarna kwamen Mozes en Aäron tot Farao en zeiden tot hem: Zo zegt de Here, de God van Israël: laat mijn volk gaan om te mijner ere in de woestijn een feest te vieren. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maar Farao zeide: Wie is de Here, naar wie ik zou moeten luisteren om Israël te laten gaan? Ik ken de Here niet, en ik zal Israël ook niet laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Toen zeiden zij: De God der Hebreeën heeft ons ontmoet; laat ons toch drie dagreizen ver de woestijn intrekken, om aan de Here, onze God, te offeren, anders zou Hij ons treffen met de pest of met het zwaard. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Maar de koning van Egypte zeide tot hen: Waarom tracht gij, Mozes en Aäron, het volk van zijn werk af te houden! Vooruit, aan uw dwangarbeid! ");
INSERT INTO nldnbg_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ook zeide Farao: Zie, het volk des lands is reeds zo talrijk en gij wilt hen met hun dwangarbeid doen ophouden! ");
INSERT INTO nldnbg_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Farao beval op die dag de drijvers en opzichters van het volk: ");
INSERT INTO nldnbg_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Gij moogt het volk geen stro meer geven om tichelstenen te maken, zoals gisteren en eergisteren; zij moeten nu zelf stro gaan verzamelen, ");
INSERT INTO nldnbg_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","maar toch zult gij hun de vastgestelde hoeveelheid tichelstenen, die zij gisteren en eergisteren moesten maken, opleggen zonder er iets van af te doen; want zij zijn lui, daarom roepen zij: laat ons aan onze God gaan offeren. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Het werk dezer mannen moet worden verzwaard, zodat zij daarmee bezig zijn en geen aandacht schenken aan leugentaal. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Toen gingen de drijvers en opzichters van het volk heen en zeiden tot het volk: Zo zegt Farao: ik geef u geen stro. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gaat er zelf op uit en haalt stro, waar gij het vindt, maar van uw taak gaat niets af. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Toen verspreidde zich het volk over het gehele land Egypte om stoppels te verzamelen voor het stro. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","En de drijvers drongen aan met de woorden: Maakt uw werk af, de bepaalde dagtaak voor elke dag, evengoed als toen er stro was. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","En de Israëlitische opzichters, aan wie de drijvers van Farao die taak hadden opgelegd, werden geslagen, terwijl hun werd toegevoegd: Waarom hebt gij het vastgestelde getal tichelstenen niet klaar, zoals gisteren en eergisteren, vandaag evengoed als gisteren? ");
INSERT INTO nldnbg_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Daarop kwamen de Israëlitische opzichters tot Farao en riepen tot hem: Waarom doet gij zó met uw knechten? ");
INSERT INTO nldnbg_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Stro wordt uw knechten niet meer gegeven en toch zegt men ons: maak tichelstenen. En zie, uw knechten worden geslagen. Maar de schuld ligt bij uw volk. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Hij echter zeide: Lui zijt gij, lui! Daarom zegt gij: Laat ons aan de Here gaan offeren. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nu dan, vooruit, aan het werk! Stro wordt u niet gegeven, maar dezelfde hoeveelheid tichelstenen moet gij leveren. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Toen begrepen de Israëlitische opzichters, hoe erg het met hen gesteld was, daar men zeide: Gij moogt het aantal tichelstenen, uw vastgestelde taak voor elke dag, niet verminderen. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Bij hun vertrek van Farao ontmoetten zij Mozes en Aäron, die op hen stonden te wachten, ");
INSERT INTO nldnbg_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","en zij zeiden tot hen: De Here zie op u en oordele, omdat gij ons bij Farao en zijn knechten in een kwade reuk gebracht hebt, waarmee gij hun een zwaard in handen hebt gegeven, om ons te doden. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Toen keerde Mozes terug tot de Here en zeide: Here, waarom behandelt Gij dit volk zo hard? Waarom hebt Gij mij gezonden? ");
INSERT INTO nldnbg_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Want van het ogenblik af, dat ik bij Farao gekomen ben, om in uw naam te spreken, heeft hij dit volk slecht behandeld, en Gij hebt uw volk geenszins gered. ");
INSERT INTO nldnbg_vpl VALUES ("EX5_24","003_5_24","EXO","5","24","24","Maar de Here zeide tot Mozes: Nu zult gij zien, wat Ik aan Farao doen zal; want door een sterke hand zal hij hen laten gaan, ja door een sterke hand hen uit zijn land drijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Voorts sprak God tot Mozes en zeide tot hem: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ik ben aan Abraham, Isaak en Jakob verschenen als God de Almachtige, maar met mijn naam Here ben Ik hun niet bekend geweest. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Niet alleen heb Ik mijn verbond met hen opgericht om hun het land Kanaän te geven, het land hunner vreemdelingschap, waar zij als vreemdelingen vertoefd hebben; ");
INSERT INTO nldnbg_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","maar ook heb Ik de klacht der Israëlieten gehoord, die door de Egyptenaren tot slaven gemaakt zijn, en Ik heb gedacht aan mijn verbond. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Zeg derhalve tot de Israëlieten: Ik ben de Here, Ik zal u onder de dwangarbeid der Egyptenaren uitleiden, u redden van hun slavernij en u verlossen door een uitgestrekte arm en onder zware gerichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ik zal Mij u tot een volk aannemen en Ik zal u tot een God zijn, opdat gij weet, dat Ik, de Here, uw God, het ben, die u onder de dwangarbeid der Egyptenaren uitleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","En Ik zal u brengen naar het land, waarvan Ik gezworen heb het aan Abraham, Isaak en Jakob te zullen geven, en Ik zal het u geven tot een bezitting, Ik, de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Toen sprak Mozes aldus tot de Israëlieten, maar zij luisterden niet naar Mozes uit ongeduld en wegens de harde slavernij. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Vervolgens zeide de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ga naar Farao, de koning van Egypte, en zeg, dat hij de Israëlieten uit zijn land moet laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Maar Mozes sprak voor het aangezicht des Heren: De Israëlieten luisterden niet eens naar mij, hoe zou dan Farao naar mij luisteren, terwijl ik zo slecht ter tale ben? ");
INSERT INTO nldnbg_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","De Here echter sprak tot Mozes en Aäron en vaardigde hen af naar de Israëlieten en naar Farao, de koning van Egypte, om de Israëlieten uit het land Egypte te leiden. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Dit zijn hun familiehoofden: De zonen van Ruben, de eerstgeborene van Israël: Chanok, Pallu, Chesron en Karmi; dit zijn de geslachten van Ruben. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","De zonen van Simeon: Jemuël, Jamin, Ohad, Jakin, Sochar en Saul, de zoon ener Kanaänitische; dit zijn de geslachten van Simeon. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","En dit zijn de namen van de zonen van Levi naar de volgorde van hun geboorten: Gerson, Kehat en Merari. En de levensjaren van Levi waren honderd zevenendertig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","De zonen van Gerson: Libni en Simi, naar hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","De zonen van Kehat: Amram, Jishar, Chebron en Uzziël. En de levensjaren van Kehat waren honderd drieëndertig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","De zonen van Merari: Machli en Musi. Dit zijn de geslachten van Levi naar de volgorde van hun geboorten. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","En Amram nam zich Jokebed, zijn tante, tot vrouw, en zij baarde hem Aäron en Mozes. En de levensjaren van Amram waren honderd zevenendertig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","De zonen van Jishar: Korach, Nefeg en Zikri. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","De zonen van Uzziël: Misaël, Elsafan en Sitri. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","En Aäron nam zich Eliseba, de dochter van Amminadab, de zuster van Nachson, tot vrouw, en zij baarde hem Nadab, Abihu, Eleazar en Itamar. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","De zonen van Korach: Assir, Elkana en Abiasaf; dit zijn de geslachten van de Korachieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Eleazar, de zoon van Aäron, nam zich een der dochters van Putiël tot vrouw, en zij baarde hem Pinechas. Dit zijn de familiehoofden der Levieten naar hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Dit zijn Aäron en Mozes, tot wie de Here gezegd heeft: Leidt de Israëlieten uit het land Egypte volgens hun legerscharen. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Zij zijn het, die tot Farao, de koning van Egypte, gesproken hebben, dat hij de Israëlieten uit Egypte zou laten gaan. Dit zijn Mozes en Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ten dage, dat de Here sprak tot Mozes in het land Egypte, ");
INSERT INTO nldnbg_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","sprak de Here tot Mozes aldus: Ik ben de Here; zeg tot Farao, de koning van Egypte, alles wat Ik tot u zeg. ");
INSERT INTO nldnbg_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Maar Mozes zeide voor het aangezicht des Heren: Ik ben immers slecht ter tale; hoe zou Farao dan naar mij luisteren? ");
INSERT INTO nldnbg_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","De Here echter zeide tot Mozes: Zie, Ik stel u als God voor Farao; en uw broeder Aäron zal uw profeet zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Gij zult alles zeggen wat Ik u gebied, en uw broeder Aäron zal bij Farao het woord voeren, opdat deze de Israëlieten uit zijn land laat gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Maar Ik zal het hart van Farao verstokken, en Ik zal mijn tekenen en wonderen talrijk maken in het land Egypte, ");
INSERT INTO nldnbg_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","doch Farao zal naar u niet luisteren. Daarom zal Ik mijn hand op Egypte leggen en mijn legerscharen, mijn volk, de Israëlieten, uit het land Egypte leiden onder zware gerichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","En de Egyptenaren zullen weten, dat Ik de Here ben, wanneer Ik mijn hand tegen Egypte uitstrek en de Israëlieten uit hun midden wegleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Aldus deden Mozes en Aäron; zoals de Here hun geboden had, zo deden zij. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mozes nu was tachtig jaar oud en Aäron drieëntachtig jaar, toen zij tot Farao spraken. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","En de Here zeide tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wanneer Farao tot u zegt: vertoon een wonderteken, dan zult gij tot Aäron zeggen: neem uw staf en werp die neer voor het aangezicht van Farao; dan zal hij een slang worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mozes en Aäron kwamen tot Farao en zij deden, zoals de Here geboden had; Aäron wierp zijn staf neer voor het aangezicht van Farao en zijn dienaren, en hij werd een slang. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Daarop riep Farao van zijn kant de wijzen en de tovenaars en ook zij, de Egyptische geleerden, deden door hun toverkunsten hetzelfde. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ieder wierp zijn staf neer en deze werden tot slangen; de staf van Aäron echter verslond hun staven. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Maar het hart van Farao verhardde en hij luisterde niet naar hen – zoals de Here gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","En de Here zeide tot Mozes: Het hart van Farao is onvermurwbaar, hij weigert het volk te laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ga in de morgen tot Farao; zie, hij is gewoon naar het water te gaan, gij zult hem opwachten aan de oever van de Nijl en de staf, die in een slang veranderd is geweest, in uw hand nemen. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","En gij zult tot hem zeggen: de Here, de God der Hebreeën, heeft mij tot u gezonden met de boodschap: laat mijn volk gaan, om Mij te dienen in de woestijn; maar zie, tot nu toe hebt gij niet willen horen. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Zó zegt de Here: hieraan zult gij weten, dat Ik de Here ben: zie, ik zal met de staf die in mijn hand is, op het water in de Nijl slaan; het zal in bloed veranderd worden, ");
INSERT INTO nldnbg_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","en de vis in de Nijl zal sterven, zodat de Nijl zal stinken; dan zullen de Egyptenaren het water uit de Nijl niet kunnen drinken. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Toen zeide de Here tot Mozes: Zeg tot Aäron: neem uw staf en strek uw hand uit over de wateren der Egyptenaren, over hun stromen, hun kanalen, hun poelen en al hun verzamelplaatsen van water, opdat zij bloed worden, en er zal bloed zijn in het gehele land Egypte, zelfs in het houten en stenen vaatwerk. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","En Mozes en Aäron deden, zoals de Here geboden had; hij hief de staf op en sloeg het water in de Nijl voor de ogen van Farao en zijn dienaren, en al het water in de Nijl werd in bloed veranderd; ");
INSERT INTO nldnbg_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","de vis in de Nijl stierf, zodat de Nijl stonk en de Egyptenaren het water uit de Nijl niet konden drinken; en er was bloed in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Maar de Egyptische geleerden deden door hun toverkunsten hetzelfde, zodat het hart van Farao verhardde en hij naar hen niet luisterde – zoals de Here gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao wendde zich af, ging naar huis en nam ook dit niet ter harte. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Alle Egyptenaren echter groeven in de omgeving van de Nijl naar water om te drinken, want Nijlwater konden zij niet drinken. ");
INSERT INTO nldnbg_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zo verliepen zeven volle dagen, nadat de Here de Nijl geslagen had. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Daarna zeide de Here tot Mozes: Ga tot Farao en zeg tot hem: zó zegt de Here: laat mijn volk gaan, om Mij te dienen; ");
INSERT INTO nldnbg_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","indien gij weigert het te laten gaan, zal Ik uw gehele gebied met kikvorsen teisteren. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","De Nijl zal wemelen van kikvorsen, zij zullen komen opzetten en in uw huis en slaapkamer binnendringen, ja, op uw bed, en in de huizen van uw dienaren en onder uw volk, ja, in uw bakovens en baktroggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tegen u, uw volk en al uw dienaren zullen de kikvorsen opkomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Voorts zeide de Here tot Mozes: Zeg tot Aäron: strek uw hand met uw staf uit over de stromen, de kanalen en de poelen, en doe kikvorsen opkomen over het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Toen strekte Aäron zijn hand uit over de wateren van Egypte, en de kikvorsen kwamen opzetten en bedekten het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Maar de geleerden deden hetzelfde door hun toverkunsten, zodat zij kikvorsen over het land Egypte deden opkomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Toen riep Farao Mozes en Aäron en zeide: Bidt tot de Here, dat Hij de kikvorsen van mij en mijn volk wegdoe; dan zal ik het volk laten gaan, om de Here offers te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","En Mozes zeide tot Farao: Verwaardig u mij te zeggen, tegen wanneer ik voor u, uw dienaren en uw volk zal bidden om uitroeiing der kikvorsen bij u en uit uw huizen; alleen in de Nijl zullen zij overblijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","En hij zeide: Tegen morgen. Toen zeide hij: Zoals gij beveelt, opdat gij weet, dat er niemand is gelijk de Here, onze God: ");
INSERT INTO nldnbg_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","de kikvorsen zullen u, uw huizen, uw dienaren en uw volk verlaten; alleen in de Nijl zullen zij overblijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Toen gingen Mozes en Aäron van Farao heen, en Mozes riep tot de Here vanwege de kikvorsen, waarmee Hij Farao bezocht had. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","En de Here deed naar het woord van Mozes, zodat de kikvorsen uit de huizen, uit de hoven en van de velden wegstierven. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Men verzamelde ze bij hopen, zodat het land ervan stonk. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Maar toen Farao zag, dat er verlichting was ingetreden, liet hij zijn hart niet vermurwen en luisterde niet naar hen – zoals de Here gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","En de Here zeide tot Mozes: Zeg tot Aäron: strek uw staf uit en sla het stof der aarde; het zal tot muggen worden in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Toen deden zij aldus; Aäron strekte zijn hand uit met zijn staf en sloeg het stof der aarde, en de muggen kwamen op mens en dier. Alle stof der aarde werd muggen in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ook de geleerden deden hetzelfde om door hun toverkunsten de muggen te voorschijn te brengen; maar zij konden het niet. En de muggen kwamen op mens en dier. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Toen zeiden de geleerden tot Farao: Dit is Gods vinger. Maar het hart van Farao verhardde, en hij luisterde niet naar hen – zoals de Here gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","En de Here zeide tot Mozes: Sta vroeg in de morgen op en stel u voor Farao; zie, hij is gewoon naar het water te gaan, en gij zult tot hem zeggen: zo zegt de Here: laat mijn volk gaan, om Mij te dienen; ");
INSERT INTO nldnbg_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","want indien gij mijn volk niet laat gaan, dan zal Ik tegen u, uw dienaren, uw volk en uw huizen steekvliegen loslaten, zodat de huizen der Egyptenaren, ja zelfs de bodem, waarop zij zich bevinden, vol steekvliegen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Maar op die dag zal Ik het land Gosen, waar mijn volk verblijf houdt, uitzonderen, dat daar geen steekvliegen voorkomen; opdat gij weet, dat Ik, de Here, in het land ben. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Want Ik zal mijn volk van uw volk bevrijden. Morgen zal dit teken geschieden. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","De Here deed alzo; en er kwamen steekvliegen in zwermen in het huis van Farao en van zijn dienaren en in het gehele land Egypte; het land werd geteisterd door de steekvliegen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Toen ontbood Farao Mozes en Aäron en zeide: Gaat, offert aan uw God in dit land. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Maar Mozes zeide: Het is onmogelijk zo te doen, wij zouden aan de Here, onze God, offeren, wat de gruwel der Egyptenaren is. Wanneer wij datgene, wat de gruwel der Egyptenaren is, voor hun ogen zouden offeren, zouden zij ons dan niet stenigen? ");
INSERT INTO nldnbg_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Wij willen drie dagreizen ver de woestijn intrekken en de Here, onze God, offers brengen, zoals Hij ons gezegd heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Toen zeide Farao: Ik zal u laten gaan om aan de Here, uw God, in de woestijn te offeren; slechts moogt gij niet al te ver weggaan. Bidt voor mij. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Toen zeide Mozes: Zie, ik ga van u heen en zal tot de Here bidden, en de steekvliegen zullen Farao, zijn dienaren en zijn volk, morgen verlaten; alleen, dat Farao niet langer bedrieglijk handele, door het volk niet te laten gaan om de Here een offer te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Daarop ging Mozes van Farao heen en bad de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","En de Here deed naar het woord van Mozes: de steekvliegen verlieten Farao, zijn dienaren en zijn volk; niet één bleef er over. ");
INSERT INTO nldnbg_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Toch liet Farao zijn hart ook ditmaal niet vermurwen; hij liet het volk niet gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","En de Here zeide tot Mozes: Ga tot Farao en spreek tot hem: zó zegt de Here, de God der Hebreeën: laat mijn volk gaan om Mij te dienen. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Want indien gij weigert hen te laten gaan en hen nog weerhoudt, ");
INSERT INTO nldnbg_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","dan zal de hand des Heren zijn tegen uw vee, dat in het veld is, tegen de paarden, de ezels, de kamelen, de runderen en het kleinvee, – een zeer zware pest. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","En de Here zal het vee van Israël afzonderen van het vee der Egyptenaren, zodat er geen stuk van het vee dat de Israëlieten bezitten, zal sterven. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","De Here stelde voorts een bepaalde tijd vast en zeide: Morgen zal de Here dit doen in het land. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","En de Here deed dit op de volgende dag; al het vee van de Egyptenaren stierf, maar niet één stuk van het vee der Israëlieten stierf. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Toen zond Farao heen en zie, van het vee der Israëlieten was zelfs niet één stuk gestorven. Toch bleef het hart van Farao onvermurwbaar en liet hij het volk niet gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","En de Here zeide tot Mozes en Aäron: Neemt uw handen vol roet uit een smeltoven, en laat Mozes dit in de lucht strooien ten aanschouwen van Farao. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dan zal het tot stof over het gehele land Egypte worden, het zal bij mens en dier in het gehele land Egypte tot zweren worden, die als puisten uitbreken. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Toen namen zij roet uit een smeltoven, gingen voor Farao staan en Mozes strooide het in de lucht en er kwamen bij mens en dier zweren, die als puisten uitbraken, ");
INSERT INTO nldnbg_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","zodat de geleerden niet konden blijven staan voor Mozes, vanwege de zweren; want de geleerden kregen evenzeer zweren als alle Egyptenaren. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Maar de Here verhardde het hart van Farao, zodat hij naar hen niet luisterde – zoals de Here tot Mozes gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","En de Here zeide tot Mozes: Sta vroeg in de morgen op, en stel u voor Farao en zeg tot hem: zó zegt de Here, de God der Hebreeën: laat mijn volk gaan om Mij te dienen. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Want ditmaal zal Ik al mijn plagen laten losbreken tegen u persoonlijk, tegen uw dienaren en uw volk, opdat gij weet, dat er niemand is op de gehele aarde, zoals Ik. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Reeds nu had Ik mijn hand kunnen uitstrekken om u en uw volk met de pest te slaan en zoudt gij van de aarde weggevaagd zijn; ");
INSERT INTO nldnbg_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","doch hierom laat Ik u bestaan, om u mijn kracht te tonen, opdat men mijn naam verkondige op de gehele aarde. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nog steeds verzet gij u tegen mijn volk, zodat gij het niet laat gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Zie, Ik zal het morgen om deze tijd zeer zwaar laten hagelen, zoals in Egypte nog niet gebeurd is van de dag af, dat het gegrondvest werd, tot nu toe. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nu dan, laat uw kudde en alles wat gij op het veld hebt, in veiligheid brengen; op alle mensen en al het vee, die zich op het veld bevinden en niet thuis gehaald zijn, zal de hagel neervallen, zodat zij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wie onder de dienaren van Farao het woord des Heren vreesde, liet zijn knechten en zijn vee in de huizen een toevlucht zoeken, ");
INSERT INTO nldnbg_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","maar wie geen acht sloeg op het woord des Heren, liet zijn knechten en zijn kudde op het veld blijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","En de Here zeide tot Mozes: Strek uw hand uit naar de hemel, opdat er hagel over het gehele land Egypte kome, over mens en dier en over al het veldgewas in het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Toen strekte Mozes zijn staf uit naar de hemel, en de Here liet het donderen en hagelen, vuur schoot naar de aarde, en de Here deed het hagelen over het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","En, terwijl er vuur door de hagelbuien heen flikkerde, hagelde het zo buitengewoon zwaar als nooit tevoren in het gehele land der Egyptenaren, sinds zij tot een volk geworden waren. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","De hagel sloeg in het gehele land Egypte alles neer, wat op het veld was, van mens tot dier; ook al het veldgewas sloeg de hagel neer en alle bomen op het veld deed hij afknappen. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Alleen in het land Gosen, waar de Israëlieten woonden, hagelde het niet. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Toen liet Farao Mozes en Aäron ontbieden en zeide tot hen: Ik heb ditmaal gezondigd, de Here is rechtvaardig, maar ik en mijn volk zijn schuldig. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bidt tot de Here; de donderslagen Gods en de hagel zijn te erg. Dan zal ik u laten gaan, gij behoeft niet langer te blijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","En Mozes zeide tot hem: Zodra ik buiten de stad gekomen ben, zal ik mijn handen uitbreiden tot de Here; de donderslagen zullen ophouden en het zal niet meer hagelen, opdat gij weet, dat de aarde aan de Here toebehoort. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Maar wat u en uw dienaren aangaat, ik weet, dat gij nog niet vreest voor het aangezicht van de Here God. – ");
INSERT INTO nldnbg_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Het vlas en de gerst nu waren neergeslagen, want de gerst stond in de aar en het vlas was in bloei. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Maar de tarwe en de spelt waren niet neergeslagen, want die komen later. – ");
INSERT INTO nldnbg_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","En Mozes ging van Farao heen, de stad uit, en hij breidde zijn handen uit tot de Here; toen hielden de donderslagen en de hagel op en de regen stroomde niet meer op de aarde neer. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Maar toen Farao zag, dat de regen, de hagel en de donderslagen hadden opgehouden, ging hij voort met zondigen; hij liet zijn hart niet vermurwen, hij noch zijn dienaren. ");
INSERT INTO nldnbg_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Het hart van Farao verhardde, zodat hij de Israëlieten niet liet gaan – zoals de Here door Mozes gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","En de Here zeide tot Mozes: Ga tot Farao, want Ik heb zijn hart en dat van zijn dienaren onvermurwbaar gemaakt, opdat Ik deze mijn tekenen onder hen tone, ");
INSERT INTO nldnbg_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","en gij aan uw kind en kleinkind kunt vertellen, wat Ik de Egyptenaren heb aangedaan en welke tekenen Ik onder hen verricht heb, opdat gij weet, dat Ik de Here ben. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Toen kwamen Mozes en Aäron tot Farao en zeiden tot hem: Zo zegt de Here, de God der Hebreeën: hoe lang zult gij weigeren u voor mijn aangezicht te verootmoedigen? Laat mijn volk gaan om Mij te dienen. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Want indien gij weigert mijn volk te laten gaan, dan zal Ik morgen sprinkhanen in uw gebied laten komen; ");
INSERT INTO nldnbg_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","zij zullen de oppervlakte van het land bedekken, zodat men het land niet zal kunnen zien; zij zullen de rest, het overgeblevene, dat u nog uit de hagelbuien gespaard is, afvreten, ja, alle bomen die op uw veld groeien, afvreten. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","En zij zullen uw huizen, de huizen van al uw dienaren, de huizen van alle Egyptenaren zo vullen, als uw vaderen en voorvaderen het nooit hebben gezien, van de dag af, dat zij op de wereld waren, tot deze dag toe. Toen wendde hij zich af en ging van Farao heen. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Daarop zeiden de dienaren van Farao tot hem: Hoe lang zal deze ons tot een valstrik zijn? Laat die mannen gaan om de Here, hun God, te dienen. Beseft gij nog niet, dat Egypte te gronde gaat? ");
INSERT INTO nldnbg_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Toen werden Mozes en Aäron tot Farao teruggebracht, en hij zeide tot hen: Gaat, dient de Here, uw God. Wie zijn eigenlijk van plan te gaan? ");
INSERT INTO nldnbg_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","En Mozes antwoordde: Wij gaan met onze jongens en grijsaards, wij gaan met onze zonen en dochters, met ons kleinvee en onze runderen, want wij hebben een feest des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Hij echter zeide tot hen: De Here moge met u zijn, als ik van zins ben u met uw kinderen te laten gaan! Neemt u in acht, want onheil bedreigt u! ");
INSERT INTO nldnbg_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Niet alzo, gij mannen moogt gaan om de Here te dienen, want dat was uw verzoek. En men joeg hen van Farao weg. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Daarna zeide de Here tot Mozes: Strek uw hand uit over het land Egypte, om de sprinkhanen, en zij zullen over het land Egypte opkomen en al het kruid des lands afvreten, alles wat de hagel heeft overgelaten. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Toen strekte Mozes zijn staf over het land Egypte uit, en de Here bracht een oostenwind over het land, gedurende die gehele dag en de gehele nacht, en toen het morgen geworden was, voerde de oostenwind de sprinkhanen mee. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Zo kwamen de sprinkhanen op over het gehele land Egypte en streken in het gehele gebied van Egypte in massa neer; nooit tevoren was er zulk een sprinkhanenzwerm geweest en nooit nadien zal er meer zo een zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Zij bedekten de gehele oppervlakte van het land, zodat het land erdoor verdonkerd werd en zij vraten al het veldgewas af en alle vruchten van de bomen, die de hagel had overgelaten, zodat er geen groen meer overbleef aan boom of veldgewas in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Toen haastte Farao zich Mozes en Aäron te ontbieden en hij zeide: Ik heb gezondigd tegen de Here, uw God, en tegen u. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Nu dan, vergeef toch nog ditmaal mijn zonde en bid de Here, uw God, dat Hij althans deze dood van mij doe wijken. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Toen ging hij van Farao heen en bad tot de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","En de Here liet een andere, een zeer sterke westenwind waaien, die de sprinkhanen meevoerde en ze in de Schelfzee dreef: niet één sprinkhaan bleef er over in het gehele gebied van Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Maar de Here verhardde het hart van Farao, zodat hij de Israëlieten niet liet gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Daarna zeide de Here tot Mozes: Strek uw hand uit naar de hemel, opdat er duisternis zij over het land Egypte, zodat men de duisternis kan tasten. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","En Mozes strekte zijn hand uit naar de hemel, en er was gedurende drie dagen een dikke duisternis in het gehele land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Gedurende drie dagen kon niemand een ander zien, noch van zijn plaats opstaan; maar alle Israëlieten hadden licht, waar zij woonden. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Toen ontbood Farao Mozes en zeide: Gaat, dient de Here, alleen uw kleinvee en uw runderen moeten achterblijven; ook uw kinderen mogen met u meegaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Maar Mozes zeide: Gij moet ons niet alleen slachtoffers en brandoffers ter beschikking stellen, die wij voor de Here, onze God, kunnen toebereiden, ");
INSERT INTO nldnbg_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","maar ook moet ons vee met ons meegaan, zonder dat er een hoef ontbreekt, want daarvan zullen wij nemen om de Here, onze God, te dienen; want wij weten niet, waarmee wij de Here zullen moeten dienen vóórdat wij daar aankomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Maar de Here verhardde het hart van Farao, zodat hij hen niet wilde laten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","En Farao zeide tot hem: Ga weg van mij; zorg ervoor, dat gij mijn aangezicht niet meer ziet, want ten dage, dat gij mijn aangezicht ziet, zult gij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Hierop zeide Mozes: Gij hebt juist gesproken; ik zal uw aangezicht niet meer zien. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","– De Here nu had tot Mozes gezegd: Nog één plaag zal Ik over Farao en over Egypte brengen, daarna zal hij u in uw geheel vanhier laten gaan; wanneer hij u laat gaan, zal hij u met geweld vanhier wegdrijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Spreek toch ten aanhoren van het volk, dat ieder van zijn buurman en iedere vrouw van haar buurvrouw zilveren en gouden voorwerpen vrage. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","En de Here bewerkte, dat de Egyptenaren het volk gunstig gezind waren; ook was Mozes een zeer gezien man in het land Egypte, bij de dienaren van Farao en bij het volk –. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","En Mozes zeide: Zó zegt de Here: te middernacht ga Ik door het midden van Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dan zal iedere eerstgeborene in het land Egypte sterven, van de eerstgeborene van Farao, die op zijn troon zou zitten, tot de eerstgeborene van de slavin achter de handmolen, ook alle eerstgeborenen van het vee. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","En er zal een luid gejammer zijn in het gehele land Egypte, zoals er nooit is geweest en zoals er nooit meer zal zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Maar tegen niemand van de Israëlieten zal een hond zijn tong durven roeren, tegen mens noch dier, opdat gij weet, dat de Here scheiding maakt tussen de Egyptenaren en de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","En al uw dienaren hier zullen tot mij komen en zich voor mij nederbuigen en zeggen: Ga heen, gij en al het volk dat u volgt; daarna zal ik heengaan. Toen ging hij in brandende toorn van Farao heen. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","En de Here zeide tot Mozes: Farao zal naar u niet luisteren, opdat mijn wonderen in het land Egypte talrijk worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mozes en Aäron nu hebben al deze wonderen gedaan voor het aangezicht van Farao. Maar de Here verhardde het hart van Farao, zodat hij de Israëlieten niet uit zijn land liet gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","En de Here zeide tot Mozes en tot Aäron in het land Egypte: ");
INSERT INTO nldnbg_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Deze maand zal u het begin der maanden zijn; zij zal u de eerste der maanden van het jaar zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Spreekt tot de gehele vergadering van Israël als volgt: op de tiende van deze maand zal ieder voor zich een stuk kleinvee nemen, familiesgewijs, een stuk kleinvee per gezin. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Maar indien een gezin te klein is voor een stuk kleinvee, dan zullen hij en de naaste buurman van zijn gezin er een nemen, naar het aantal personen; gij zult bij het stuk kleinvee rekenen met ieders behoefte. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Een gaaf, mannelijk, éénjarig stuk kleinvee moet gij nemen; gij kunt dit nemen van de schapen of van de geiten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","En gij zult het bewaren tot de veertiende dag van deze maand; dan zal de gehele vergadering der gemeente van Israël het slachten in de avondschemering. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Vervolgens zal men van het bloed nemen en dit strijken aan de beide deurposten en de bovendorpel, aan die huizen, waarin men het eet. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Het vlees zullen zij dezelfde nacht eten; zij zullen het eten op het vuur gebraden, met ongezuurde broden, benevens bittere kruiden. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Rauw of gaar gekookt in water zult gij het niet eten; slechts op het vuur gebraden met kop, schenkels en ingewanden. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Gij zult daarvan niets overlaten tot de morgen; wat ervan overblijft tot de morgen, dat zult gij met vuur verbranden. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","En aldus zult gij het eten: uw lendenen omgord, uw schoenen aan uw voeten en uw staf in uw hand; overhaast zult gij het eten; het is een Pascha voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Want Ik zal in deze nacht het land Egypte doortrekken en alle eerstgeborenen, zowel van mens als dier, in het land Egypte slaan en aan alle goden van Egypte zal Ik gerichten oefenen, Ik, de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","En het bloed zal u dienen als een teken aan de huizen, waar gij zijt, en wanneer Ik het bloed zie, dan ga Ik u voorbij. Aldus zal er geen verdervende plaag onder u zijn, wanneer Ik het land Egypte sla. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","En deze dag zal u een gedenkdag zijn, gij zult hem vieren als een feest voor de Here; in uw geslachten zult gij hem als een altoosdurende inzetting vieren. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Zeven dagen zult gij ongezuurde broden eten; dadelijk op de eerste dag zult gij het zuurdeeg uit uw huizen verwijderen, want ieder die iets gezuurds eet, van de eerste tot de zevende dag, zo iemand zal uit Israël worden uitgeroeid. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Zowel op de eerste als op de zevende dag zult gij een heilige samenkomst hebben; generlei arbeid zal daarop verricht worden; slechts wat door ieder gegeten wordt, alleen dat mag door u bereid worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Onderhoudt dan (het feest der) ongezuurde broden, want op deze zelfde dag leid Ik uw legerscharen uit het land Egypte. Daarom moet gij deze dag onderhouden in uw geslachten als een altoosdurende inzetting. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In de eerste (maand), op de veertiende dag der maand, des avonds, zult gij ongezuurde broden eten, tot aan de eenentwintigste dag der maand, des avonds. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Zeven dagen zal er geen zuurdeeg in uw huizen gevonden worden, want ieder, die iets gezuurds eet, zo iemand zal uit de vergadering van Israël worden uitgeroeid, hetzij hij een vreemdeling, hetzij hij in het land geboren is. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Niets wat gezuurd is, zult gij eten; gij zult in al uw woonplaatsen ongezuurde broden eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Toen ontbood Mozes al de oudsten van Israël en zeide tot hen: Trekt heen, haalt kleinvee voor uw geslachten en slacht het Pascha. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Daarna zult gij een bundel hysop nemen en in het bloed in een schaal dopen, en van het bloed in die schaal strijken aan de bovendorpel en aan de beide deurposten; niemand van u zal de deur van zijn huis uitgaan tot de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","En de Here zal Egypte doortrekken om het te slaan; wanneer Hij dan het bloed aan de bovendorpel en aan de beide deurposten ziet, dan zal de Here die deur voorbijgaan en de verderver niet toelaten in uw huizen te komen om te slaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Gij zult dit voorschrift houden als een altoosdurende inzetting voor u en uw zonen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","En wanneer gij komt in het land dat de Here u geven zal, gelijk Hij gezegd heeft, zult gij deze dienst onderhouden. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","En wanneer uw zonen tot u zeggen: Wat betekent deze dienst van u, ");
INSERT INTO nldnbg_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","dan zult gij zeggen: Het is een Paasoffer voor de Here, die in Egypte aan de huizen der Israëlieten voorbijging, toen Hij de Egyptenaren sloeg, maar onze huizen spaarde. Toen knielde het volk en boog zich neer. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","En de Israëlieten gingen heen en deden dit; zoals de Here Mozes en Aäron geboden had, zo deden zij. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","En te middernacht sloeg de Here iedere eerstgeborene in het land Egypte, van de eerstgeborene van Farao, die op zijn troon zou zitten, tot de eerstgeborene van de gevangene, die in de kerker was, benevens alle eerstgeborenen van het vee. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","En Farao stond des nachts op, hij en al zijn dienaren en alle Egyptenaren; en er was een luid gejammer in Egypte; want er was geen huis, waarin geen dode was. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Toen ontbood hij des nachts Mozes en Aäron en zeide: Maakt u gereed, gaat weg uit het midden van mijn volk, zowel gij als de Israëlieten; gaat, dient de Here, zoals gij gezegd hebt. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Neemt ook uw kleinvee en uw runderen mee, zoals gij gezegd hebt; maar gaat! En wilt ook mij zegenen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","De Egyptenaren drongen eveneens sterk bij het volk aan, om het snel uit het land te laten gaan, want, zeiden zij, wij sterven allen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Toen nam het volk zijn deeg op, voordat het gezuurd was, met hun baktroggen in hun klederen gebonden op hun schouders. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Voorts deden de Israëlieten naar het woord van Mozes en vroegen van de Egyptenaren zilveren en gouden voorwerpen en klederen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","En de Here bewerkte, dat de Egyptenaren het volk gunstig gezind waren, zodat zij hun verzoek inwilligden. Zo beroofden zij de Egyptenaren. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Daarna trokken de Israëlieten op van Raämses naar Sukkot, ongeveer zeshonderdduizend man te voet, ongerekend de kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ook trok een menigte van allerlei slag met hen mee; en kleinvee en runderen, een zeer talrijke veestapel. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","En zij bakten van het deeg dat zij uit Egypte hadden meegenomen, ongezuurde koeken, want het was niet gezuurd, omdat zij uit Egypte waren verdreven en niet hadden kunnen wachten en ook geen teerkost voor zich hadden bereid. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","De tijd, dat de Israëlieten in Egypte gewoond hadden, was vierhonderd en dertig jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","En na vierhonderd en dertig jaar, juist op de dag af, gingen al de legerscharen des Heren uit het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Een nacht van waken was dit voor de Here, om hen uit het land Egypte te leiden. Dit is de nacht van waken ter ere van de Here voor alle Israëlieten in hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","De Here zeide tot Mozes en Aäron: Dit is de inzetting van het Pascha: geen enkele vreemdeling mag ervan eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Iedere slaaf, die door iemand voor geld is gekocht, mag er eerst van eten, wanneer gij hem besneden hebt. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Een bijwoner en een dagloner mogen er niet van eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In één huis zal het gegeten worden; gij zult van het vlees niets uit het huis naar buiten brengen; geen been zult gij ervan breken. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","De gehele vergadering van Israël zal dit vieren. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Maar wanneer een vreemdeling bij u vertoeft en de Here het Pascha wil vieren, dan zal ieder van het mannelijk geslacht, die bij hem behoort, besneden worden; eerst dan mag hij naderen om het te vieren; hij zal gelden als in het land geboren. Maar geen enkele onbesnedene mag ervan eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Eénzelfde wet zal gelden voor de geboren Israëliet en voor de vreemdeling, die in uw midden vertoeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Alle Israëlieten deden aldus; zoals de Here Mozes en Aäron geboden had, zo deden zij. ");
INSERT INTO nldnbg_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","En op deze zelfde dag leidde de Here de Israëlieten uit het land Egypte, volgens hun legerscharen. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Heilig Mij alle eerstgeborenen, die onder de Israëlieten het eerst uit een moederschoot voortkomen, zowel van mens als van dier; zij zijn mijn eigendom. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Toen zeide Mozes tot het volk: Gedenkt deze dag, waarop gij uit Egypte, uit het diensthuis, gegaan zijt; want met een sterke hand heeft de Here u daaruit geleid. Daarom mag niets gezuurds gegeten worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heden trekt gij uit, in de maand Abib. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wanneer de Here u gebracht heeft naar het land der Kanaänieten, Hethieten, Amorieten, Chiwwieten en Jebusieten, waarvan Hij uw vaderen gezworen heeft, dat Hij het u zal geven, een land, vloeiende van melk en honig, dan zult gij deze dienst in deze maand onderhouden. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Zeven dagen zult gij ongezuurde broden eten en op de zevende dag zal er een feest voor de Here zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ongezuurde broden zullen gedurende de zeven dagen gegeten worden; er mag zelfs niets gezuurds bij u gezien worden, ja, in uw gehele gebied mag er geen zuurdeeg worden gezien. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","En op die dag zult gij uw zoon uitleggen: Dit is ter wille van wat de Here mij heeft gedaan bij mijn uittocht uit Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Het zal u zijn als een teken op uw hand en als een herinnering tussen uw ogen, opdat de wet des Heren in uw mond zij; want met een sterke hand heeft de Here u uit Egypte geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Gij zult deze inzetting onderhouden op haar vaste tijd, van jaar tot jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wanneer dan de Here u gebracht heeft naar het land der Kanaänieten, zoals Hij u en uw vaderen gezworen heeft, en het u gegeven heeft, ");
INSERT INTO nldnbg_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","dan zult gij al wat het eerst uit de moederschoot voortkomt, de Here wijden; ook van elke eerste worp van het vee dat gij hebt, zullen de mannelijke dieren voor de Here zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Maar elk eerste ezelsveulen zult gij lossen met een stuk kleinvee; of, indien gij het niet lost, zult gij het de nek breken. Iedere menselijke eerstgeborene onder uw zonen echter zult gij lossen. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","En wanneer uw zoon u later zal vragen: Wat betekent dat? dan zult gij tot hem zeggen: Met een sterke hand heeft de Here ons uit Egypte, uit het diensthuis, geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Want toen Farao bezwaar maakte ons te laten gaan, doodde de Here alle eerstgeborenen in het land Egypte, zowel de eerstgeborenen der mensen als die van het vee. Daarom ben ik gewoon alle mannelijke dieren, die het eerst uit de moederschoot voortkomen, de Here te offeren, terwijl ik alle eerstgeborenen mijner zonen los. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Het zal tot een teken op uw hand en tot een kenteken tussen uw ogen zijn, want met een sterke hand heeft de Here ons uit Egypte geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Toen Farao het volk had laten gaan, leidde God hen niet op de weg naar het land der Filistijnen, hoewel deze de naaste was; want God zeide: Het volk mocht eens berouw krijgen, wanneer zij in strijd gewikkeld werden, en naar Egypte terugkeren. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Daarom liet God het volk zwenken, de woestijnweg op naar de Schelfzee. Ten strijde toegerust trokken de Israëlieten op uit het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","En Mozes nam het gebeente van Jozef mee, omdat deze de zonen van Israël plechtig had doen zweren: God zal zeker naar u omzien, dan zult gij mijn gebeente vanhier met u meevoeren. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Zo braken zij van Sukkot op en legerden zich in Etam, aan de rand der woestijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","De Here ging voor hen uit, des daags in een wolkkolom om hen te leiden op de weg, en des nachts in een vuurkolom om hun voor te lichten, zodat zij dag en nacht konden voortgaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Zonder ophouden bleef de wolkkolom des daags en de vuurkolom des nachts aan de spits van het volk. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Zeg tot de Israëlieten, dat zij teruggaan en zich legeren voor Pi-Hachirot, tussen Migdol en de zee; recht tegenover Baäl-Sefon zult gij u legeren, aan de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Dan zal Farao van de Israëlieten denken: zij zijn in het land verdwaald, de woestijn heeft hun de weg versperd. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","En Ik zal het hart van Farao verharden, zodat hij hen achtervolgt. Dan zal Ik Mij aan Farao en aan zijn gehele legermacht verheerlijken, en de Egyptenaren zullen weten, dat Ik de Here ben. En zij deden alzo. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Toen aan de koning van Egypte bericht werd, dat het volk gevlucht was, veranderde de gezindheid van Farao en van zijn dienaren ten aanzien van het volk, en zij zeiden: Wat hebben wij gedaan, dat wij Israël uit onze dienst hebben ontslagen? ");
INSERT INTO nldnbg_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Daarop spande hij zijn wagen aan en nam zijn volk met zich. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Hij nam zeshonderd uitgelezen wagens, ja, al de wagens van Egypte, alle volledig bemand. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Zo verhardde de Here het hart van Farao, de koning van Egypte, zodat hij de Israëlieten achtervolgde. Maar de Israëlieten zetten hun uittocht voort, door een verheven hand geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","De Egyptenaren nu, al de paarden en wagens van Farao, zijn ruiters en zijn legermacht, achtervolgden hen en haalden hen in, terwijl zij gelegerd waren aan de zee, bij Pi-Hachirot, tegenover Baäl-Sefon. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Toen Farao naderbij gekomen was, sloegen de Israëlieten hun ogen op, en zie, de Egyptenaren rukten achter hen aan. Toen werden de Israëlieten zeer bevreesd en schreeuwden tot de Here, ");
INSERT INTO nldnbg_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","en zij zeiden tot Mozes: Waren er soms geen graven in Egypte, dat gij ons hebt meegenomen om te sterven in de woestijn? Wat hebt gij ons aangedaan door ons uit Egypte te leiden? ");
INSERT INTO nldnbg_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Hebben wij u dit al niet gezegd in Egypte: laat ons met rust, en laten wij de Egyptenaren dienen. Want wij kunnen beter de Egyptenaren dienen dan in de woestijn sterven. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Maar Mozes zeide tot het volk: Vreest niet, houdt stand, dan zult gij de verlossing des Heren zien, die Hij u heden bereiden zal; want de Egyptenaren, die gij heden gezien hebt, zult gij nimmermeer zien. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","De Here zal voor u strijden, en gij zult stil zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Toen zeide de Here tot Mozes: Wat roept gij zo luid tot Mij? Zeg tot de Israëlieten, dat zij opbreken. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","En gij, hef uw staf op en strek uw hand uit over de zee en splijt haar; dan zullen de Israëlieten midden door de zee kunnen gaan op het droge. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Maar zie, Ik zal het hart der Egyptenaren verharden, zodat zij hen achterna zullen trekken, en Ik zal Mij verheerlijken aan Farao en aan zijn gehele legermacht, aan zijn wagens en aan zijn ruiters. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","En de Egyptenaren zullen weten, dat Ik de Here ben, doordat Ik Mij verheerlijken zal aan Farao, aan zijn wagens en aan zijn ruiters. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Toen verliet de Engel Gods, die vóór het leger van Israël uitging, zijn plaats en ging achter hen aan; ook verliet de wolkkolom haar plaats aan hun spits en ging achter hen staan. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Zo kwam zij tussen het leger van de Egyptenaren en dat van de Israëlieten in, – en de wolk was duisternis, maar tegelijk verlichtte zij de nacht – zodat de een de ander niet kon naderen, de gehele nacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Toen strekte Mozes zijn hand uit over de zee en de Here deed de zee de gehele nacht door een sterke oostenwind wegvloeien, maakte haar droog, en de wateren werden gespleten. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Zo gingen de Israëlieten in het midden der zee op het droge; terwijl rechts en links de wateren voor hen waren als een muur. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","En de Egyptenaren vervolgden hen en kwamen achter hen aan – alle paarden van Farao, zijn wagens en zijn ruiters – midden in de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Toen dan, in de morgenwake, schouwde de Here in vuurkolom en wolk naar het leger der Egyptenaren en bracht het leger der Egyptenaren in verwarring. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hij deed de wielen van hun wagens wegglijden en met moeite voortrijden, zodat de Egyptenaren zeiden: Laten wij vluchten voor de Israëlieten, want de Here strijdt voor hen tegen Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Toen zeide de Here tot Mozes: Strek uw hand uit over de zee, opdat de wateren terugvloeien over de Egyptenaren, over hun wagens en ruiters. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","En Mozes strekte zijn hand uit over de zee en tegen het aanbreken van de morgen vloeide de zee terug in haar bedding, terwijl de Egyptenaren haar tegemoet vluchtten; zo dreef de Here de Egyptenaren midden in de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","De wateren vloeiden terug en bedekten de wagens en de ruiters van de gehele legermacht van Farao, die hen in de zee achterna getrokken waren; er bleef van hen niet één over. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Maar de Israëlieten gingen op het droge midden door de zee en de wateren waren hun rechts en links als een muur. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zo verloste de Here op die dag de Israëlieten uit de macht der Egyptenaren. En Israël zag de Egyptenaren dood op de oever der zee liggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Toen zag Israël, welk een machtige daad de Here tegen Egypte gedaan had; en het volk vreesde de Here en zij geloofden in de Here en in Mozes, zijn knecht. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Toen zong Mozes met de Israëlieten de Here dit lied en zij zeiden:Ik wil de Here zingen, want Hij is hoog verheven,het paard en zijn ruiter stortte Hij in de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","De Here is mijn kracht en mijn psalm,Hij is mij tot heil geweest.Hij is mijn God, Hem verheerlijk ik,de God mijns vaders, Hem prijs ik. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","De Here is een krijgsheld; Here is zijn naam. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","De wagens van Farao en zijn legermacht wierp Hij in de zee;de keur van zijn wagenhelden werd in de Schelfzee gedompeld. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Watervloeden overdekten hen;in de diepte zonken zij als een steen. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Uw rechterhand, Here, heerlijk door kracht,uw rechterhand, Here, verpletterde de vijand. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In uw grote majesteit vernietigdet Gij wie tegen U opstonden;Gij liet uw toorngloed los, hij verteerde hen als stoppels. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Door de adem van uw neus werden de wateren opgestuwd;als een dam stonden de stromen;de watervloeden stolden in het hart der zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","De vijand zeide: Ik achtervolg, haal in, deel de buit;ik koel mijn lust aan hen, trek mijn zwaard;mijn hand roeit hen uit. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Gij bliest met uw adem, de zee overdekte hen;als lood zonken zij in geweldige wateren. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wie is als Gij, onder de goden, Here,wie is als Gij, heerlijk in heiligheid,vreselijk in roemrijke daden,wonderbaar in uw doen? ");
INSERT INTO nldnbg_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Gij strektet uw rechterhand uit;de aarde verzwolg hen. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Gij leiddet in uw goedertierenheid het volk dat Gij verlost hebt;Gij leiddet het door uw kracht naar uw heilige woonstede. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Volkeren hoorden het, zij sidderden;beving greep de bewoners van Filistea aan. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Toen verschrikten Edoms stamhoofden,huivering greep Moabs machtigen aan;alle bewoners van Kanaän sidderden. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ontzetting en schrik overviel hen,door uw geweldige arm verstarden zij als een steen,terwijl uw volk, Here, doortrok,uw volk, dat Gij U hebt verworven, doortrok. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Gij brengt hen en plant hen op de berg die uw erfdeel is;de plaats die Gij, Here, tot uw woning gemaakt hebt;het heiligdom, Here, door uw hand gesticht. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","De Here regeert voor altoos en eeuwig. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Toen Farao’s paarden met zijn wagenen en ruiters in de zee gekomen waren, deed de Here de wateren der zee over hen terugvloeien, maar de Israëlieten gingen op het droge midden door de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Toen nam Mirjam, de profetes, de zuster van Aäron, de tamboerijn in haar hand, en alle vrouwen gingen achter haar aan met tamboerijnen en in reidansen. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","En Mirjam zong hun ten antwoord:Zingt de Here, want Hij is hoog verheven,het paard en zijn ruiter stortte Hij in de zee. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Toen liet Mozes de Israëlieten opbreken van de Schelfzee en zij gingen naar de woestijn Sur; drie dagreizen trokken zij door de woestijn zonder water te vinden. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","En zij kwamen in Mara, maar zij konden het water van Mara niet drinken, omdat het bitter was. Daarom noemde men die plaats Mara. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Toen morde het volk tegen Mozes en zeide: Wat moeten wij drinken? ");
INSERT INTO nldnbg_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","En hij riep luide tot de Here, en de Here wees hem een stuk hout; hij wierp het in het water; toen werd het water zoet. Daar gaf Hij hun inzettingen en verordeningen en daar stelde Hij hen op de proef, ");
INSERT INTO nldnbg_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","terwijl hij zeide: Indien gij aandachtig luistert naar de stem van de Here, uw God, en doet wat recht is in zijn ogen, en uw oor neigt tot zijn geboden en al zijn inzettingen onderhoudt, zal Ik u geen enkele van de kwalen opleggen, die Ik de Egyptenaren opgelegd heb; want Ik, de Here, ben uw Heelmeester. ");
INSERT INTO nldnbg_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Daarna kwamen zij in Elim; daar waren twaalf waterbronnen en zeventig palmbomen, en zij legerden zich daar aan het water. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toen zij van Elim opgebroken waren, kwam de gehele vergadering der Israëlieten in de woestijn Sin, die tussen Elim en de Sinai ligt, op de vijftiende dag van de tweede maand sedert hun uittocht uit het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","En in die woestijn morde de gehele vergadering der Israëlieten tegen Mozes en Aäron; ");
INSERT INTO nldnbg_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","en de Israëlieten zeiden tot hen: Och, dat wij door de hand des Heren in het land Egypte gestorven waren, toen wij bij de vleespotten zaten en volop brood aten; want gij hebt ons in deze woestijn geleid om deze gehele gemeente van honger te doen omkomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Toen zeide de Here tot Mozes: Zie, Ik zal voor u brood uit de hemel laten regenen; dan zal het volk uitgaan en verzamelen zoveel als voor elke dag nodig is, opdat Ik het op de proef stelle, of het al dan niet wandelt naar mijn wet. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","En als zij op de zesde dag bereiden wat zij hebben binnengebracht, dan zal dit dubbel zoveel zijn als wat zij op de andere dagen verzamelen. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Daarop zeiden Mozes en Aäron tot alle Israëlieten: Vanavond zult gij weten, dat de Here u uit het land Egypte heeft geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","En morgenochtend zult gij de heerlijkheid des Heren zien, omdat Hij uw gemor tegen de Here gehoord heeft. Want wat zijn wij, dat gij tegen ons mort? ");
INSERT INTO nldnbg_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","En Mozes zeide: Als de Here u in de avond vlees te eten geeft en in de morgen volop brood, omdat de Here het gemor waarmede gij tegen Hem gemord hebt, gehoord heeft – wat zijn wij? Niet tegen ons was uw gemor, maar tegen de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","En Mozes zeide tot Aäron: Zeg tot de gehele vergadering der Israëlieten: nadert voor het aangezicht des Heren: want Hij heeft uw gemor gehoord. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Terwijl nu Aäron sprak tot de gehele vergadering der Israëlieten, richtten zij hun blik naar de woestijn – en zie, de heerlijkheid des Heren verscheen in een wolk. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Toen sprak de Here tot Mozes en zeide: ");
INSERT INTO nldnbg_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ik heb het gemor der Israëlieten gehoord; zeg tot hen: in de avondschemering zult gij vlees eten en in de morgen zult gij met brood verzadigd worden; en gij zult weten, dat Ik, de Here, uw God ben. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","En des avonds kwamen kwakkels opzetten en overdekten de legerplaats; en des morgens was er een dauwlaag rondom de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Toen de dauwlaag opgetrokken was, zie, daar lag over de woestijn iets fijns, iets schilferachtigs, fijn als rijm op de aarde. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Toen de Israëlieten het zagen, zeiden zij tot elkander: Wat is dit? Want zij wisten niet, wat het was. Maar Mozes zeide tot hen: Dit is het brood dat de Here u tot spijze gegeven heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Dit is wat de Here geboden heeft: verzamelt ervan naar ieders behoefte; ieder van u kan voor zijn tentgenoten een gomer per hoofd nemen, naar gelang van het zielental. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","De Israëlieten nu deden zo en verzamelden het, de een meer en de ander minder. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Toen zij het in een gomer maten, had hij die meer verzameld had, niet te veel en hij die minder verzameld had, kwam niet te kort. Ieder had naar zijn behoefte verzameld. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","En Mozes zeide tot hen: Niemand late ervan over tot de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Maar sommigen luisterden niet naar Mozes en lieten ervan over tot de morgen, maar toen was het bedorven van de wormen en stonk. En Mozes werd toornig op hen. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Zij nu verzamelden het elke morgen ieder naar zijn behoefte; maar als de zon heet werd, smolt het. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","En op de zesde dag verzamelden zij tweemaal zoveel brood, twee gomer voor ieder; en al de vorsten der vergadering kwamen het Mozes berichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Toen zeide hij tot hen: Dit is wat de Here gezegd heeft: een rustdag, een heilige sabbat is het morgen voor de Here; bakt wat gij bakken wilt en kookt wat gij koken wilt; laat al wat overblijft liggen om het tot de volgende morgen te bewaren. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Zij lieten het dan tot de volgende morgen liggen, zoals Mozes bevolen had; toen stonk het niet, en er waren geen maden in. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Voorts zeide Mozes: Eet dit vandaag, want heden is het sabbat voor de Here, vandaag zult gij het niet vinden op het veld. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Zes dagen zult gij het verzamelen, maar op de zevende dag is het sabbat; dan is het er niet. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Toen er dan ook van het volk op de zevende dag heengingen om wat te verzamelen, vonden zij het niet. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Daarom zeide de Here tot Mozes: Hoelang weigert gij mijn geboden en wetten te onderhouden? ");
INSERT INTO nldnbg_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bedenkt, dat de Here u de sabbat gegeven heeft; daarom geeft Hij u op de zesde dag brood voor twee dagen. Ieder moet op zijn plaats blijven; niemand mag zijn plaats op de zevende dag verlaten. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Toen rustte het volk op de zevende dag. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Het huis Israëls noemde het: manna; en het was wit als korianderzaad en de smaak ervan was als die van een honigkoek. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mozes zeide: Dit is wat de Here geboden heeft: vul er een gomer mee, om het voor de toekomende geslachten te bewaren, opdat zij het brood zien, dat Ik u in de woestijn te eten heb gegeven, toen Ik u uit het land Egypte leidde. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Daarom zeide Mozes tot Aäron: Neem een kruik, doe daarin een volle gomer manna en leg dit voor het aangezicht des Heren, om het voor de toekomende geslachten te bewaren. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Zoals de Here Mozes geboden had, legde Aäron het vóór de Getuigenis ter bewaring. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","De Israëlieten nu hebben veertig jaar het manna gegeten, totdat zij kwamen in bewoond land; het manna hebben zij gegeten, totdat zij kwamen aan de grens van het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Een gomer nu is het tiende van een efa. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","De gehele vergadering der Israëlieten brak daarna op uit de woestijn Sin, trekkende van pleisterplaats tot pleisterplaats naar het bevel des Heren, en legerde zich te Refidim, maar daar was geen water voor het volk om te drinken. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Het volk begon met Mozes te twisten en zeide: Geeft ons water, zodat wij kunnen drinken. Maar Mozes zeide tot hen: Wat twist gij met mij? Wat stelt gij de Here op de proef? ");
INSERT INTO nldnbg_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","En het volk dorstte daar naar water, het morde tegen Mozes en zeide: Waarom toch hebt gij ons uit Egypte gevoerd, om mij, mijn kinderen en mijn kudde van dorst te doen omkomen? ");
INSERT INTO nldnbg_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Toen riep Mozes luide tot de Here en zeide: Wat moet ik met dit volk doen? Nog een ogenblik en zij gaan mij stenigen! ");
INSERT INTO nldnbg_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Daarop zeide de Here tot Mozes: Ga vóór het volk uit en neem enige van de oudsten van Israël met u; neem ook de staf waarmee gij de Nijl geslagen hebt, in uw hand en ga heen. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Zie, Ik zal daar vóór u op de rots bij Horeb staan; dan zult gij op de rots slaan en daaruit zal water te voorschijn komen, zodat het volk kan drinken. En Mozes deed alzo voor de ogen van de oudsten van Israël. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Hij noemde die plaats Massa en Meriba, wegens de twist der Israëlieten en omdat zij de Here op de proef gesteld hadden door te zeggen: Is de Here in ons midden of niet? ");
INSERT INTO nldnbg_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Toen kwam Amalek en streed tegen Israël te Refidim. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","En Mozes zeide tot Jozua: Kies ons mannen uit, trek uit, strijd tegen Amalek, morgen zal ik op de heuveltop staan met de staf Gods in mijn hand. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozua nu deed, zoals Mozes tot hem gezegd had en streed tegen Amalek; maar Mozes, Aäron en Chur hadden de heuveltop bestegen. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","En wanneer Mozes zijn hand ophief, had Israël de overhand, maar wanneer hij zijn hand liet zakken, had Amalek de overhand. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Toen de handen van Mozes zwaar werden, namen zij een steen, legden die onder hem neer, zodat hij daarop kon gaan zitten; en Aäron en Chur ondersteunden zijn handen, de een aan de ene en de ander aan de andere zijde, zodat zijn handen onbeweeglijk bleven tot zonsondergang. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Zo overwon Jozua Amalek en diens volk door de scherpte des zwaards. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","En de Here zeide tot Mozes: Schrijf dit ter gedachtenis in een boek, en prent het Jozua in, dat Ik de herinnering aan Amalek onder de hemel volledig zal uitwissen. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Toen bouwde Mozes een altaar en noemde het: de Here is mijn banier. ");
INSERT INTO nldnbg_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","En hij zeide: De hand op de troon des Heren! De Here heeft een strijd tegen Amalek, van geslacht tot geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","En Jetro, de priester van Midjan, de schoonvader van Mozes, hoorde alles wat God voor Mozes en zijn volk Israël gedaan had, dat de Here Israël uit Egypte had geleid. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Toen nam Jetro, de schoonvader van Mozes, Sippora, de vrouw van Mozes – nadat deze haar had weggezonden – ");
INSERT INTO nldnbg_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","benevens haar beide zonen; van wie de ene Gersom heette, want, had hij gezegd, ik ben een vreemdeling geweest in een vreemd land, ");
INSERT INTO nldnbg_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","en de andere Eliëzer, want de God van mijn vader is mijn hulp geweest en heeft mij gered van het zwaard van Farao. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Toen Jetro, de schoonvader van Mozes, met diens zonen en vrouw bij Mozes kwam in de woestijn, waar hij gelegerd was bij de berg Gods, liet hij aan Mozes zeggen: ");
INSERT INTO nldnbg_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ik, uw schoonvader Jetro, kom tot u met uw vrouw en haar beide zonen. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Daarop ging Mozes zijn schoonvader tegemoet, boog zich voor hem neer en kuste hem; zij vroegen naar elkanders welstand en gingen naar de tent. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Toen vertelde Mozes zijn schoonvader al wat de Here Farao en de Egyptenaren had aangedaan ter wille van Israël, alle moeiten die hen onderweg getroffen hadden, en hoe de Here hen had gered. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","En Jetro verheugde zich over al het goede dat de Here aan Israël gedaan had, dat Hij het uit de macht der Egyptenaren had gered. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","En Jetro zeide: Geprezen zij de Here, die u gered heeft uit de macht der Egyptenaren en van Farao. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu weet ik, dat de Here groter is dan alle goden; want Hij heeft het volk uit de macht der Egyptenaren gered, omdat dezen overmoedig tegen hen waren opgetreden. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","En Jetro, de schoonvader van Mozes, nam een brandoffer en slachtoffers voor God; en Aäron en alle oudsten van Israël kwamen om met de schoonvader van Mozes voor het aangezicht van God maaltijd te houden. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","De volgende dag hield Mozes zitting om recht te spreken over het volk; en het volk stond vóór Mozes van de morgen tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Toen de schoonvader van Mozes zag al wat hij te doen had met het volk, zeide hij: Wat hebt gij toch met het volk te doen! Waarom houdt gij alleen zitting, terwijl het gehele volk vóór u staat van de morgen tot de avond? ");
INSERT INTO nldnbg_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","En Mozes zeide tot zijn schoonvader: Omdat het volk tot mij komt om God te vragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wanneer zij een zaak hebben, komt deze tot mij en spreek ik recht tussen de een en de ander; bovendien maak ik de inzettingen en wetten Gods bekend. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Maar de schoonvader van Mozes zeide tot hem: Het is niet goed, wat gij doet. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Gij raakt geheel uitgeput, gij zowel als dit volk dat met u is; want dit is te zwaar voor u, gij kunt het alleen niet doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Luister nu naar mij, ik zal u raad geven en God zal met u zijn. Vertegenwoordig gij het volk bij God en breng de zaken voor God. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Voorts moet gij hun de inzettingen en de wetten Gods inscherpen, en hun de weg bekend maken, die zij te gaan, en het werk dat zij te volbrengen hebben. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Daarnaast moet gij onder het gehele volk omzien naar flinke, godvrezende, betrouwbare mannen, die winstbejag haten, en hen over hen aanstellen als oversten van duizend, oversten van honderd, oversten van vijftig en oversten van tien. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Die zullen te allen tijde onder het volk rechtspreken; dan zullen zij alle grote zaken voor u brengen, maar alle kleine zaken zullen zij zelf berechten, zodat zij u verlichting geven en met u meedragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Indien gij dit doet en God het u gebiedt, dan zult gij staande kunnen blijven en zal ook al dit volk tevreden naar zijn woonplaats gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mozes nu luisterde naar de woorden van zijn schoonvader en deed al hetgeen hij gezegd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Onder geheel Israël koos Mozes flinke mannen en stelde hen aan als hoofden over het volk, oversten van duizend, oversten van honderd, oversten van vijftig en oversten van tien. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dezen spraken te allen tijde recht onder het volk; de moeilijke zaken brachten zij tot Mozes, maar alle kleine zaken berechtten zij zelf. ");
INSERT INTO nldnbg_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Toen liet Mozes zijn schoonvader gaan en deze ging naar zijn land. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In de derde maand na de uittocht der Israëlieten uit het land Egypte, op dezelfde dag, kwamen zij in de woestijn Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Nadat zij van Refidim opgebroken waren, kwamen zij in de woestijn Sinai en legerden zich in de woestijn; en Israël legerde zich daar tegenover de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Toen klom Mozes op tot God, en de Here riep tot hem van de berg, en zeide: Zó zult gij zeggen tot het huis van Jakob en meedelen aan de Israëlieten: ");
INSERT INTO nldnbg_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","gij hebt gezien, wat Ik de Egyptenaren heb aangedaan, en dat Ik u op arendsvleugelen gedragen en tot Mij gebracht heb. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nu dan, indien gij aandachtig naar Mij luistert en mijn verbond bewaart, dan zult gij uit alle volken Mij ten eigendom zijn, want de ganse aarde behoort Mij. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","En gij zult Mij een koninkrijk van priesters zijn en een heilig volk. Dit zijn de woorden die gij tot de Israëlieten spreken zult. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Toen kwam Mozes en ontbood de oudsten van het volk en legde hun al deze woorden die de Here hem geboden had, voor. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","En het gehele volk antwoordde eenparig: Alles wat de Here gesproken heeft, zullen wij doen. En Mozes bracht de woorden van het volk weder aan de Here over. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Daarna zeide de Here tot Mozes: Zie, Ik kom tot u in een donkere wolk, opdat het volk kan horen, wanneer Ik met u spreek, en zij ook voor altoos in u geloven. En Mozes deelde de woorden van het volk aan de Here mee. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","En de Here zeide tot Mozes: Ga tot het volk; heilig hen heden en morgen, en laten zij hun klederen wassen. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","En tegen de derde dag zullen zij gereed zijn, want op de derde dag zal de Here nederdalen voor de ogen van het gehele volk op de berg Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Daarom zult gij het volk buiten een bepaalde kring houden en zeggen: Wacht er u voor de berg te bestijgen, of maar de voet ervan aan te raken; ieder die de berg aanraakt, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Geen hand zal hem aanraken, want dan zal men zeker gestenigd of met pijlen doorschoten worden; hetzij dier hetzij mens, hij zal niet blijven leven. Eerst bij de langgerekte toon van de hoorn mogen zij de berg bestijgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Toen daalde Mozes de berg af naar het volk; hij heiligde het volk en zij wiesen hun klederen. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","En hij zeide tot het volk: Weest over drie dagen gereed, nadert niet tot een vrouw. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","En het geschiedde op de derde dag, toen het morgen werd, dat er donderslagen en bliksemstralen en een zware wolk op de berg waren en zeer sterk bazuingeschal, zodat al het volk dat in de legerplaats was, beefde. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Toen leidde Mozes het volk uit de legerplaats God tegemoet en zij stelden zich op onder aan de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","En de berg Sinai stond geheel in rook, omdat de Here daarop nederdaalde in vuur; de rook daarvan steeg op als de rook van een oven, en de gehele berg beefde zeer. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Het geluid van de bazuin werd gaandeweg zeer sterk. Mozes sprak, en God antwoordde hem in de donder. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Toen daalde de Here neder op de berg Sinai, op de bergtop, en de Here riep Mozes naar de bergtop, en Mozes klom naar boven. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Daarna zeide de Here tot Mozes: Daal af, waarschuw het volk, dat zij niet doordringen tot de Here om iets te zien; dan zouden velen van hen vallen. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","En ook de priesters die tot de Here naderen, zullen zich heiligen, opdat de Here niet tegen hen losbreke. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Toen zeide Mozes tot de Here: Het volk kan de berg Sinai niet bestijgen, want Gij hebt ons gewaarschuwd: zet de berg af en heilig hem. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Daarop zeide de Here tot hem: Ga, daal af en klim met Aäron naar boven; maar de priesters en het volk mogen niet doordringen om tot de Here op te klimmen, opdat Hij niet tegen hen losbreke. ");
INSERT INTO nldnbg_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Toen daalde Mozes af tot het volk en zeide het hun. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Toen sprak God al deze woorden: ");
INSERT INTO nldnbg_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ik ben de Here, uw God, die u uit het land Egypte, uit het diensthuis, geleid heb. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Gij zult geen andere goden voor mijn aangezicht hebben. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gij zult u geen gesneden beeld maken noch enige gestalte van wat boven in de hemel, noch van wat beneden op de aarde, noch van wat in de wateren onder de aarde is. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gij zult u voor die niet buigen, noch hen dienen; want Ik, de Here, uw God, ben een naijverig God, die de ongerechtigheid der vaderen bezoek aan de kinderen, aan het derde en aan het vierde geslacht van hen die Mij haten, ");
INSERT INTO nldnbg_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","en die barmhartigheid doe aan duizenden van hen die Mij liefhebben en mijn geboden onderhouden. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Gij zult de naam van de Here, uw God, niet ijdel gebruiken, want de Here zal niet onschuldig houden wie zijn naam ijdel gebruikt. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenk de sabbatdag, dat gij die heiligt; ");
INSERT INTO nldnbg_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","zes dagen zult gij arbeiden en al uw werk doen; ");
INSERT INTO nldnbg_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","maar de zevende dag is de sabbat van de Here, uw God; dan zult gij geen werk doen, gij noch uw zoon, noch uw dochter, noch uw dienstknecht, noch uw dienstmaagd, noch uw vee, noch de vreemdeling die in uw steden woont. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Want in zes dagen heeft de Here de hemel en de aarde gemaakt, de zee en al wat daarin is, en Hij rustte op de zevende dag; daarom zegende de Here de sabbatdag en heiligde die. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Eer uw vader en uw moeder, opdat uw dagen verlengd worden in het land dat de Here, uw God, u geven zal. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gij zult niet doodslaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gij zult niet echtbreken. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gij zult niet stelen. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Gij zult geen valse getuigenis spreken tegen uw naaste. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gij zult niet begeren uws naasten huis; gij zult niet begeren uws naasten vrouw, noch zijn dienstknecht, noch zijn dienstmaagd, noch zijn rund, noch zijn ezel, noch iets dat van uw naaste is. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","En het gehele volk was getuige van de donderslagen, de bliksemstralen, het geluid van de bazuin en de rokende berg. Toen het volk het zag, beefde het en bleef van verre staan. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","En zij zeiden tot Mozes: Spreek gij met ons, dan zullen wij horen; maar God spreke niet met ons, opdat wij niet sterven. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Maar Mozes zeide tot het volk: Vreest niet, want God is gekomen om u op de proef te stellen, en opdat er vrees voor Hem over u kome, dat gij niet zondigt. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Het volk nu bleef van verre staan, maar Mozes naderde tot de donkerheid waarin God was. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Toen zeide de Here tot Mozes: Zó zult gij zeggen tot de Israëlieten: gij hebt gezien, dat Ik van de hemel met u gesproken heb: ");
INSERT INTO nldnbg_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","gij zult naast Mij geen goden maken; noch van zilver noch van goud zult gij ze u maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Een altaar van aarde zult gij voor Mij maken en daarop offeren uw brandoffers en uw vredeoffers, uw kleinvee en uw runderen. Op elke plaats waar Ik mijn naam doe gedenken, zal Ik tot u komen en u zegenen. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Indien gij echter een altaar van stenen voor Mij maakt, dan moogt gij het niet bouwen van gehouwen steen; wanneer gij dat met uw houweel bewerkt, ontwijdt gij het. ");
INSERT INTO nldnbg_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ook moogt gij niet langs een trap naar mijn altaar opklimmen, opdat daarop uw schaamte niet zichtbaar worde. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Dit zijn de verordeningen die gij hun zult voorhouden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Wanneer gij een Hebreeuwse slaaf koopt, zal hij zes jaar dienen, maar in het zevende jaar zal hij om niet als een vrij man weggaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Indien hij alleen gekomen is, zal hij alleen weggaan; indien hij gehuwd was, dan zal zijn vrouw met hem weggaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Indien zijn heer hem een vrouw gegeven heeft en zij hem zonen of dochters gebaard heeft, zal de vrouw met haar kinderen het eigendom blijven van haar heer, en hij zal alleen weggaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Maar indien de slaaf nadrukkelijk zegt: Ik heb mijn heer, mijn vrouw en mijn kinderen lief, ik wil niet als vrij man weggaan, ");
INSERT INTO nldnbg_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dan zal zijn heer hem bij de goden brengen, hij zal hem bij de deur of de deurpost brengen, en zijn heer zal zijn oor met een priem doorboren en hij zal hem voor altijd dienen. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","En wanneer iemand zijn dochter als slavin verkoopt, zal zij niet weggaan zoals de slaven weggaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Indien zij haar heer niet bevalt, die haar voor zichzelf bestemd had, dan moet hij haar laten loskopen; hij heeft niet de bevoegdheid haar aan een vreemd volk te verkopen, omdat hij trouweloos tegen haar gehandeld heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Indien hij haar voor zijn zoon bestemt, zal hij haar naar het recht der dochters doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Indien hij zich een andere neemt, zal hij haar voeding, haar kleding en de echtelijke gemeenschap met haar niet verminderen. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Indien hij haar deze drie dingen niet doet, zal zij weggaan, om niet, zonder geld. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wie iemand zo treft, dat hij sterft, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Maar voor het geval, dat hij het er niet op toelegde, doch dat God het zijn hand deed overkomen, zal Ik u een plaats aanwijzen, waarheen hij kan vluchten. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Doch wanneer iemand misdadig handelt tegen zijn naaste en hem met list doodt, dan zult gij hem van mijn altaar weghalen, opdat hij sterve. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wie zijn vader of zijn moeder slaat, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wie een mens rooft, hetzij hij hem reeds verkocht heeft, hetzij deze nog in zijn bezit wordt aangetroffen, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wie zijn vader of zijn moeder vervloekt, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Wanneer mannen twisten en de een slaat de ander met een steen of met de vuist, zodat deze wel niet sterft, maar bedlegerig wordt, ");
INSERT INTO nldnbg_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","dan zal hij die de slag gaf, ongestraft blijven, wanneer de ander opstaat en met zijn stok buiten wandelt; slechts diens gedwongen rusttijd zal hij vergoeden en voor genezing zorgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Wanneer iemand zijn slaaf of zijn slavin met een stok slaat, zodat deze onder zijn hand sterft, zal deze zeker gewroken worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Slechts indien hij een dag of twee in leven blijft, zal hij niet gewroken worden, want het is zijn eigen geld. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wanneer mannen vechten en een van hen stoot een zwangere vrouw, zodat haar vrucht afgaat, maar zonder ander letsel, dan zal zeker een boete worden geëist, naardat de man van die vrouw hem oplegt, en hij zal het volgens besluit van de rechters geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Maar indien er een ander letsel is, zult gij geven leven voor leven, ");
INSERT INTO nldnbg_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oog voor oog, tand voor tand, hand voor hand, voet voor voet, ");
INSERT INTO nldnbg_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","blaar voor blaar, wond voor wond, striem voor striem. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Wanneer iemand het oog van zijn slaaf – of het oog van zijn slavin – raakt en het vernielt, zal hij hem om zijn oog vrijlaten. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","En indien hij een tand van zijn slaaf – of een tand van zijn slavin – uitslaat, zal hij hem om zijn tand vrijlaten. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Wanneer een rund een man of een vrouw stoot, zodat deze sterft, dan zal het rund zeker gestenigd worden en zijn vlees zal niet gegeten worden, maar de eigenaar van het rund zal vrijuit gaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Indien echter dat rund reeds vroeger stotig was en zijn eigenaar gewaarschuwd was, maar hij het niet bewaakte, en het doodt een man of een vrouw, dan zal het rund gestenigd worden, maar ook de eigenaar zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Indien hem een zoengeld opgelegd wordt, dan zal hij alles wat hem opgelegd wordt, als losprijs voor zijn leven geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Stoot het een zoon of een dochter, dan zal met hem gehandeld worden volgens dezelfde verordening. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Maar indien het rund een slaaf of een slavin stoot, dan zal hij dertig sikkels zilver aan de heer van deze geven, en het rund zal gestenigd worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Wanneer iemand een put opent, of wanneer iemand een put graaft, zonder die te bedekken, en er valt een rund of een ezel in, ");
INSERT INTO nldnbg_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","dan zal de eigenaar van de put vergoeding geven: hij zal er geld voor teruggeven aan de eigenaar ervan, maar het dode dier zal zijn eigendom zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wanneer iemands rund het rund van zijn naaste stoot, zodat het sterft, dan zal men het levende rund verkopen en zijn prijs verdelen en ook het dode dier zal men verdelen. ");
INSERT INTO nldnbg_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Of als het bekend was, dat het rund reeds vroeger stotig was, en als zijn eigenaar het desondanks niet bewaakte, dan zal hij volledig rund voor rund vergoeden, doch het dode dier zal zijn eigendom zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wanneer iemand een rund of een stuk kleinvee steelt en het slacht of verkoopt, dan zal hij vijf stuks rundvee als vergoeding geven voor het rund en vier stuks kleinvee voor het stuk kleinvee. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Indien een dief bij een inbraak betrapt en zo getroffen wordt, dat hij sterft, dan rust daarop geen bloedschuld; ");
INSERT INTO nldnbg_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","indien de zon was opgegaan, rust daarop wel bloedschuld. Hij zal volledig vergoeding geven; indien hij niets heeft, zal hij verkocht worden om wat hij gestolen heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Indien werkelijk het gestolene levend in zijn bezit gevonden wordt, hetzij rund, ezel of een stuk kleinvee, zal hij het dubbele als vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Wanneer iemand een akker of een wijngaard laat afweiden door zijn vee erin los te laten, en dit weidt de akker van een ander af, dan zal hij het beste deel van zijn eigen akker of het beste deel van zijn wijngaard als vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Wanneer brand ontstaat en doornstruiken aantast, doch ook een schoof of het staande koren of het gehele veld verteerd wordt, dan zal hij, die de brand aanstak, volledig vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Wanneer iemand aan zijn naaste geld of goed te bewaren geeft, en het uit het huis van die man gestolen wordt, zal de dief, indien hij gevonden wordt, het dubbele als vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Indien de dief niet gevonden wordt, zal de heer des huizes tot de goden naderen, om te zweren, dat hij zijn hand niet uitgestoken heeft naar de have van zijn naaste. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Bij elke zaak van verduistering, hetzij van een rund, een ezel, een stuk kleinvee, een gewaad, hetzij van welk verloren voorwerp ook, waarvan (de eigenaar) zegt: dat is het – zal hun beider zaak tot de goden komen. Hij, die de goden schuldig verklaren, zal aan zijn naaste het dubbele als vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Wanneer iemand aan zijn naaste een ezel of een rund of een stuk kleinvee of welk dier ook, te bewaren geeft en het sterft, of het wordt gewond of geroofd, zonder dat iemand het ziet, ");
INSERT INTO nldnbg_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","dan zal de eed bij de Here tussen hen beslissen, of hij niet zijn hand uitgestoken heeft naar de have van zijn naaste, en de eigenaar zal er genoegen mee nemen, de ander behoeft geen vergoeding te geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Maar indien het zonder meer van hem gestolen is, zal hij aan de eigenaar vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Indien het zonder meer verscheurd is, zal hij het als bewijsstuk overleggen. Het verscheurde zal hij niet vergoeden. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Wanneer iemand van zijn naaste (een dier) leent, en het wordt gewond of sterft, terwijl de eigenaar er niet bij was, dan zal hij volledig vergoeding geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Indien de eigenaar erbij was, zal hij geen vergoeding geven. Indien het gehuurd was, is de schade in de huurprijs inbegrepen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wanneer iemand een maagd verleidt, die niet ondertrouwd is, en gemeenschap met haar heeft, dan zal hij haar tegen de volle bruidsprijs tot vrouw nemen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Indien haar vader ten stelligste weigert haar aan hem te geven, dan zal hij de bruidsprijs der maagden aan zilver afwegen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Een tovenares zult gij niet in leven laten. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Alwie met een dier gemeenschap heeft, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wie aan de goden offert, behalve aan de Here alleen, zal met de ban geslagen worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Een vreemdeling zult gij niet onderdrukken, noch hem benauwen, want gij zijt vreemdelingen geweest in het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Geen enkele weduwe of wees zult gij verdrukken. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Indien gij dezen toch verdrukt, voorzeker zal Ik, indien zij luide tot Mij roepen, hun geroep horen, ");
INSERT INTO nldnbg_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","en mijn toorn zal ontbranden en Ik zal u met het zwaard doden, zodat uw vrouwen weduwen worden en uw kinderen wezen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Indien gij aan mijn volk, aan de arme bij u, geld leent, zult gij u niet als een schuldeiser jegens hem gedragen: gij zult hem geen rente opleggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Indien gij het opperkleed van uw naaste tot pand neemt, zult gij het hem vóór zonsondergang teruggeven, ");
INSERT INTO nldnbg_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","want dat is zijn enige bedekking, dat is de bekleding voor zijn huid – waarin zal hij zich te ruste leggen? Wanneer hij tot Mij om hulp zal roepen, zal Ik horen, want Ik ben genadig. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","De goden zult gij niet vervloeken en een vorst onder uw volk zult gij niet verwensen. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Gij zult niet talmen, van uw graan- en van uw wijnoogst te geven. De eerstgeborene van uw zonen zult gij Mij geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Evenzo zult gij doen met uw runderen en met uw kleinvee: zeven dagen zullen zij bij de moeder blijven, op de achtste dag zult gij ze Mij geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Gij zult Mij heilige mensen zijn; vlees van dieren, die in het veld verscheurd zijn, zult gij niet eten, gij zult het voor de honden werpen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Gij zult geen vals gerucht verbreiden; gij moogt de schuldige niet helpen als misdadig getuige. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Gij zult de meerderheid in het kwade niet volgen, noch in een rechtsgeding getuigenis afleggen met de meerderheid mee, om het recht te buigen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ook zult gij een onaanzienlijke niet voortrekken in zijn rechtsgeding. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wanneer gij een verdwaald rund of ezel van uw vijand aantreft, zult gij ze hem zeker terugbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wanneer gij de ezel van uw vijand onder zijn last ziet bezwijken, zult gij dit niet onverschillig aan hem overlaten. Gij zult hem zeker helpen met afladen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Gij zult het recht van de arme onder u in zijn rechtsgeding niet buigen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Van een bedrieglijke zaak moet gij u ver houden. De onschuldige en de rechtvaardige moogt gij niet doden, want Ik verklaar de schuldige niet rechtvaardig. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Een geschenk zult gij niet aannemen, want een geschenk maakt zienden blind en verdraait de zaak der onschuldigen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","De vreemdeling zult gij niet benauwen, want gij kent de gemoedsgesteldheid van de vreemdeling, omdat gij vreemdelingen zijt geweest in het land Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Zes jaar zult gij uw land bezaaien en zijn opbrengst inzamelen, ");
INSERT INTO nldnbg_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","maar in het zevende zult gij het braak laten liggen en het met rust laten, opdat de armen van uw volk eten, en wat zij overlaten zal het gedierte des velds eten. Evenzo zult gij doen met uw wijngaard en met uw olijfbomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Zes dagen zult gij uw werk doen, maar op de zevende dag zult gij rusten, opdat uw rund en uw ezel uitrusten, en de zoon van uw slavin en de vreemdeling adem scheppen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ten aanzien van alles, wat Ik u bevolen heb, zult gij op uw hoede zijn; de naam van andere goden zult gij niet noemen, hij zal uit uw mond niet gehoord worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Driemaal in het jaar zult gij Mij een feest houden. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Het feest der ongezuurde broden zult gij onderhouden; zeven dagen zult gij ongezuurde broden eten, zoals Ik u geboden heb, op de bepaalde tijd van de maand Abib, want daarin zijt gij uit Egypte getrokken; maar men zal niet met ledige handen voor mijn aangezicht verschijnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ook het feest van de oogst, der eerstelingen van uw vruchten, die gij op de akker zaaien zult; en het feest der inzameling aan het einde des jaars, wanneer gij uw vruchten van de akker ingezameld hebt. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Driemaal in het jaar zullen al uw mannen voor het aangezicht van de Here Here verschijnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Gij zult het bloed van mijn slachtoffer niet met iets gezuurds offeren, noch zal het vet van mijn feestoffer de nacht overblijven tot de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Het beste der eerstelingen van uw bodem zult gij in het huis van de Here, uw God, brengen. Gij zult een bokje niet koken in de melk van zijn moeder. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Zie, Ik zend een engel vóór uw aangezicht, om u te bewaren op de weg en om u te brengen naar de plaats, die Ik bereid heb. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Neem u voor hem in acht en luister naar hem, wees tegen hem niet wederspannig, want hij zal uw overtredingen niet vergeven, want mijn naam is in hem. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Maar indien gij aandachtig naar hem luistert, en alles doet, wat Ik zeg, zal Ik uw vijanden vijandig bejegenen, en benauwen die u benauwen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Want mijn engel zal voor uw aangezicht gaan en u brengen naar de Amoriet, de Hethiet, de Perizziet, de Kanaäniet, de Chiwwiet en de Jebusiet, en Ik zal hen vernietigen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Gij zult u niet nederbuigen voor hun goden noch hen dienen en gij zult niet doen naar hun werken, maar gij zult ze volkomen vernielen en hun gewijde stenen zult gij geheel verbrijzelen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Maar gij zult de Here, uw God, dienen; dan zal Hij uw brood en uw water zegenen en Ik zal ziekte uit uw midden verwijderen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Geen vrouw in uw land zal een misgeboorte hebben of onvruchtbaar zijn. Het getal uwer dagen zal Ik vol maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","De schrik voor Mij zal Ik voor u uit zenden; Ik zal in verwarring brengen elk volk, waarmee gij in aanraking komt, en Ik zal al uw vijanden voor u doen vluchten. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ook zal Ik hoornaars voor u uit zenden, opdat zij de Chiwwiet, de Kanaäniet en de Hethiet voor u uit verdrijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ik zal hen niet in één jaar voor u uit verdrijven, opdat het land geen woestenij worde en het wild gedierte u niet te veel worde. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Langzamerhand zal Ik hen voor u uit verdrijven, totdat gij zo vruchtbaar wordt, dat gij het land in bezit kunt nemen. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","En Ik zal u het gebied geven van de Schelfzee tot de Zee der Filistijnen en van de woestijn tot de Rivier, want Ik zal de inwoners van het land in uw macht geven, zodat gij hen voor u uit verdrijft. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Gij zult noch met hen noch met hun goden een verbond sluiten. ");
INSERT INTO nldnbg_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Zij zullen in uw land niet blijven wonen, opdat zij u niet tegen Mij doen zondigen, doordat gij hun goden gaat dienen, want dit zou u tot een valstrik zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Tot Mozes zeide Hij: Klim op tot de Here, gij en Aäron, Nadab en Abihu en zeventig van de oudsten van Israël en buigt u van verre neder. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Maar Mozes alleen zal tot de Here naderen, zij echter zullen niet naderen, en het volk zal niet met hem opklimmen. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Toen kwam Mozes en deelde het volk al de woorden des Heren en al de verordeningen mee, en het gehele volk antwoordde eenstemmig: Al de woorden, die de Here gesproken heeft, zullen wij doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","En Mozes schreef al de woorden des Heren op. Vroeg in de morgen bouwde hij een altaar onder aan de berg, met twaalf opgerichte stenen overeenkomstig de twaalf stammen van Israël. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Toen zond hij de jongelingen der Israëlieten heen, en zij brachten brandoffers en offerden stieren als vredeoffers voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Daarop nam Mozes de helft van het bloed en deed het in bekkens, en de andere helft van het bloed sprengde hij op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hij nam het boek des verbonds en las het voor de oren van het volk en zij zeiden: Alles wat de Here gesproken heeft, zullen wij doen en daarnaar zullen wij horen. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Toen nam Mozes het bloed en sprengde het op het volk en hij zeide: Zie, het bloed van het verbond dat de Here met u sluit, op grond van al deze woorden. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","En Mozes klom op met Aäron, Nadab en Abihu en zeventig van de oudsten van Israël. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","En zij zagen de God van Israël en het was alsof onder zijn voeten een plaveisel lag van lazuur, als de hemel zelf in klaarheid. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Maar tot de vooraanstaanden der Israëlieten strekte Hij zijn hand niet uit; zij aanschouwden God en zij aten en dronken. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","De Here zeide tot Mozes: Klim op tot Mij, de berg op, en blijf daar, dan zal Ik u de stenen tafelen geven, de wet en het gebod, die Ik opgeschreven heb, om hen te onderwijzen. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Toen stond Mozes op met zijn dienaar Jozua, en Mozes besteeg de berg Gods. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Maar tot de oudsten zeide hij: Wacht hier op ons, totdat wij bij u terugkeren; Aäron en Chur zijn immers bij u, wie zaken heeft, moet zich tot hen wenden. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Daarop besteeg Mozes de berg, en de wolk bedekte de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","De heerlijkheid des Heren rustte op de berg Sinai, en de wolk bedekte hem zes dagen lang; op de zevende dag riep Hij tot Mozes midden uit de wolk. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","De verschijning van de heerlijkheid des Heren was als verterend vuur op de top van de berg ten aanschouwen van de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mozes ging de wolk in en besteeg de berg. En hij bleef op de berg veertig dagen en veertig nachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Zeg tot de Israëlieten, dat zij voor Mij een heffing inzamelen; van iedere man, wiens hart hem dringt, zult gij voor Mij een heffing inzamelen. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Dit nu is de heffing die gij van hen inzamelen zult: goud, zilver, koper; ");
INSERT INTO nldnbg_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blauwpurper, roodpurper, scharlaken, fijn linnen, geitehaar; ");
INSERT INTO nldnbg_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","roodgeverfde ramsvellen, tachasvellen en acaciahout; ");
INSERT INTO nldnbg_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olie voor het licht, specerijen voor de zalfolie en voor het welriekend reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","chrysopraasstenen en vulstenen voor de efod en voor het borstschild. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","En zij zullen Mij een heiligdom maken, en Ik zal in hun midden wonen. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Gij zult het maken overeenkomstig alles wat Ik u toon, het model van de tabernakel en het model van al zijn gerei. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Zij moeten dan een ark van acaciahout maken, twee en een halve el lang, anderhalve el breed, en anderhalve el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Gij zult die overtrekken met louter goud; van binnen en van buiten zult gij die overtrekken en er rondom een gouden omlijsting op maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Gij zult er vier gouden ringen voor gieten en die bevestigen aan de vier voetstukken en wel twee ringen aan de ene zijwand en twee ringen aan de andere zijwand. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Gij zult draagstokken van acaciahout maken en die met goud overtrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Gij zult de draagstokken steken in de ringen aan de zijwanden van de ark, om daarmee de ark te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","De draagstokken zullen in de ringen van de ark blijven, zij zullen er niet uit verwijderd worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","In de ark zult gij de getuigenis leggen, die Ik u geven zal. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ook zult gij een verzoendeksel van louter goud maken, twee en een halve el lang en anderhalve el breed. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","En gij zult twee cherubs van goud maken, van gedreven werk zult gij ze maken, aan de beide einden van het verzoendeksel. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Maak één cherub aan het ene einde en één cherub aan het andere einde; uit één stuk met het verzoendeksel zult gij de cherubs op zijn beide einden maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","De cherubs zullen twee vleugels uitgespreid houden naar boven, met hun vleugels het verzoendeksel bedekkende en hun aangezicht naar elkander gericht; naar het verzoendeksel zullen de aangezichten der cherubs gericht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Gij zult het verzoendeksel bovenop de ark leggen en in de ark zult gij de getuigenis leggen, die Ik u geven zal. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","En Ik zal dáár met u samenkomen en van het verzoendeksel af, tussen de beide cherubs op de ark der getuigenis, over alles met u spreken wat Ik u voor de Israëlieten gebieden zal. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Gij zult een tafel van acaciahout maken, twee el lang, een el breed en anderhalve el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Gij zult die overtrekken met louter goud en er een gouden omlijsting omheen maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Gij zult er een rand van een handbreedte omheen maken en een gouden omlijsting rondom haar rand. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Gij zult vier gouden ringen ervoor maken en de ringen zetten op de vier hoeken aan haar vier poten. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dicht bij de rand zullen zich de ringen bevinden als houders voor draagstokken, om de tafel te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Gij zult de draagstokken van acaciahout maken en ze met goud overtrekken, opdat daarmee de tafel gedragen worde. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Gij zult schotels, schalen, kannen en kommen maken, waarmee geplengd wordt; van louter goud zult gij ze maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","En gij zult op de tafel geregeld toonbrood leggen voor mijn aangezicht. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Gij zult een kandelaar van louter goud maken, van gedreven werk zal de kandelaar gemaakt worden, het voetstuk zowel als de schacht; de bloemkelken, met knoppen en bloesems, zullen daarmee één geheel vormen. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Zes armen nu zullen uit zijn zijden uitsteken: drie armen van de kandelaar uit de ene zijde en drie armen van de kandelaar uit de andere zijde. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Drie bloemkelken in de vorm van amandelbloesem aan de ene arm, met knop en bloesem; en drie bloemkelken in de vorm van amandelbloesem aan de andere arm, met knop en bloesem; aldus voor de zes armen, die uit de kandelaar uitsteken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Op de kandelaar vier bloemkelken in de vorm van amandelbloesem, met zijn knoppen en bloesems. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ook een knop onder het eerste paar armen, die uit hem voortkomen, en een knop onder het tweede paar armen, die uit hem voortkomen, en een knop onder het derde paar armen, die uit hem voortkomen; (aldus) bij de zes armen, die uit de kandelaar uitsteken. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","De knoppen en de armen zullen uit hem voortkomen, terwijl het geheel één gedreven werk van louter goud is. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Gij zult er zeven lampen voor maken en men zal die lampen erop zetten en het licht laten vallen naar de voorkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Zijn snuiters en zijn bakjes zullen van louter goud zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Van een talent louter goud zal men hem maken, met al dit gerei. ");
INSERT INTO nldnbg_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Zie nu toe, dat gij alles maakt naar het model dat u daarvan op de berg getoond is. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","De tabernakel zult gij maken van tien tentkleden; van getweernd fijn linnen, blauwpurper, roodpurper en scharlaken, met kunstig geweven cherubs zult gij ze maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","De lengte van elk tentkleed zal achtentwintig el zijn en de breedte van elk tentkleed vier el: eenzelfde maat voor al de tentkleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Vijf van de tentkleden zullen verbonden zijn aan elkander, en nog eens vijf tentkleden zullen verbonden zijn aan elkander. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ook zult gij blauwpurperen lussen maken op de rand van het ene tentkleed aan het einde, aan het ene stel, en evenzo zult gij doen op de rand van het laatste tentkleed aan het andere stel. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Vijftig lussen zult gij maken op het éne tentkleed en vijftig lussen zult gij maken aan het einde van het tentkleed, dat tot het andere stel behoort, zodat de lussen tegenover elkaar staan, de éne tegenover de andere. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","En gij zult vijftig gouden haken maken en de tentkleden aan elkander door de haken verbinden, zodat de tabernakel één geheel is. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ook zult gij tentkleden van geitehaar maken tot een tent over de tabernakel, elf tentkleden zult gij maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","De lengte van elk tentkleed zal dertig el zijn en de breedte van elk tentkleed vier el: eenzelfde maat voor de elf tentkleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Gij zult vijf van de tentkleden afzonderlijk verbinden en zes van de tentkleden afzonderlijk, en gij zult het zesde tentkleed dubbel leggen, aan de voorkant van de tent. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Gij zult vijftig lussen maken op de rand van het ene tentkleed, het laatste aan het ene stel, en vijftig lussen op de rand van het tentkleed, aan het andere stel. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Gij zult vijftig koperen haken maken en de haken in de lussen steken en de tent samenvoegen, zodat zij één geheel is. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Wat het overhangende betreft, dat overhangt aan de tentkleden der tent, de helft van het overhangende tentkleed zal overhangen aan de achterkant van de tabernakel. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Een el aan deze zijde en een el aan gene zijde van wat overhangt in de lengte van de tentkleden der tent zal overhangen aan de zijde van de tabernakel, aan deze en aan gene zijde, om haar te bedekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ook zult gij een dekkleed voor de tent maken van roodgeverfde ramsvellen, en een dekkleed van tachasvellen daaroverheen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Gij zult de planken voor de tabernakel maken van acaciahout, rechtopstaande; ");
INSERT INTO nldnbg_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","tien el zal een plank lang zijn en anderhalve el breed. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Elke plank zal twee tappen hebben, zodat zij aan elkaar kunnen worden verbonden; zo zult gij met al de planken van de tabernakel doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Gij zult de planken voor de tabernakel maken, twintig planken aan de zuidkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","En veertig zilveren voetstukken zult gij maken onder de twintig planken, twee voetstukken onder de ene plank voor haar beide tappen, en twee voetstukken onder de andere plank voor haar beide tappen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Evenzo voor de andere zijde van de tabernakel aan de noordkant twintig planken ");
INSERT INTO nldnbg_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","met veertig zilveren voetstukken: twee voetstukken onder de ene plank en twee voetstukken onder de andere plank. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Voor de achterzijde van de tabernakel aan de westkant zult gij zes planken maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Twee planken zult gij maken voor de hoeken van de tabernakel aan de achterkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Volkomen gelijk nu zullen zij zijn aan de onderkant en aan de bovenkant, tot de ene ring; zo zal het voor die beide zijn: zij zullen de beide hoeken vormen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Er zullen dus acht planken zijn met haar zilveren voetstukken: zestien voetstukken; twee voetstukken onder de ene plank en twee voetstukken onder de andere plank. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ook zult gij dwarsbalken maken van acaciahout: vijf voor de planken van de ene zijde van de tabernakel, ");
INSERT INTO nldnbg_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","vijf dwarsbalken voor de planken van de andere zijde van de tabernakel, en vijf dwarsbalken voor de planken van de zijde van de tabernakel aan de achterkant naar het westen, ");
INSERT INTO nldnbg_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","met de middelste dwarsbalk, in het midden der planken, dwars dóórlopende van het ene einde naar het andere. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","De planken nu zult gij met goud overtrekken, de ringen zult gij van goud maken als houders voor de dwarsbalken, en de dwarsbalken zult gij met goud overtrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Dan zult gij de tabernakel oprichten overeenkomstig het plan dat u daarvan op de berg getoond werd. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Gij zult een voorhangsel maken van blauwpurper, roodpurper, scharlaken en getweernd fijn linnen; met kunstig geweven cherubs zult gij het maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Gij zult het hangen aan vier pilaren van acaciahout, met goud overtrokken, van gouden haken voorzien, op vier zilveren voetstukken. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Gij zult het voorhangsel onder de haken hangen en daarheen, binnen het voorhangsel, de ark der getuigenis brengen, zodat het voorhangsel voor u scheiding maakt tussen het heilige en het heilige der heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Gij zult het verzoendeksel op de ark der getuigenis leggen in het heilige der heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Gij zult de tafel buiten het voorhangsel zetten, en de kandelaar tegenover de tafel aan de zuidzijde van de tabernakel, en de tafel zult gij plaatsen aan de noordzijde. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ook zult gij een gordijn voor de ingang der tent maken van blauwpurper, roodpurper, scharlaken en getweernd fijn linnen: veelkleurig weefwerk. ");
INSERT INTO nldnbg_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Gij zult voor het gordijn vijf pilaren van acaciahout maken en ze met goud overtrekken, van gouden haken voorzien, en gij zult daarvoor vijf koperen voetstukken gieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Gij zult het altaar van acaciahout maken, vijf el lang en vijf el breed, zodat het altaar vierkant is, en drie el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Gij zult hoornen aan de vier hoeken maken; de hoornen zullen daarmee één geheel vormen, en gij zult het overtrekken met koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ook zult gij er potten voor maken, om het van as te reinigen, en scheppen, sprengbekkens, vorken en vuurpannen; al zijn gerei zult gij van koper maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Gij zult een traliewerk ervoor maken, een koperen netwerk, en op het net vier koperen ringen maken aan de vier einden. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Gij zult het onder de rand van het altaar van onderen bevestigen, zodat het netwerk halverwege het altaar reikt. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Gij zult draagstokken voor het altaar maken, draagstokken van acaciahout en die met koper overtrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Zijn draagstokken moeten in de ringen gestoken worden en de draagstokken zullen zich aan de beide zijden van het altaar bevinden, wanneer men het draagt. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hol, van planken, zult gij het maken; zoals Hij u op de berg getoond heeft, zó zal men het maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Gij zult de voorhof van de tabernakel maken; aan de zuidzijde gordijnen voor de voorhof van getweernd fijn linnen, honderd el lengte aan de ene zijde; ");
INSERT INTO nldnbg_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","en daarvoor twintig pilaren, en twintig voetstukken van koper, voor de pilaren haken en dwarsstangen van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Zo ook aan de noordzijde in de lengte gordijnen van honderd el lengte en daarvoor twintig pilaren, en twintig voetstukken van koper, voor de pilaren haken en dwarsstangen van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","In de breedte nu van de voorhof aan de westzijde gordijnen van vijftig el, met hun tien pilaren en de tien voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","De breedte nu van de voorhof aan de oostzijde: vijftig el. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","En vijftien el gordijnen voor het ene zijstuk, met hun drie pilaren en de drie voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ook voor het andere zijstuk vijftien el gordijnen, met hun drie pilaren en de drie voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","En voor de poort van de voorhof een gordijn van twintig el van blauwpurper, roodpurper, scharlaken en van getweernd fijn linnen – veelkleurig weefwerk – met de vier pilaren en de vier voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Al de pilaren rondom de voorhof door zilveren dwarsstangen verbonden, en hun haken van zilver en hun voetstukken van koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","De lengte van de voorhof honderd el, de breedte telkens vijftig en de hoogte vijf el van getweernd fijn linnen, en de voetstukken ervan van koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Wat al het gerei voor de gehele inrichting van de tabernakel betreft, en al zijn pinnen en al de pinnen van de voorhof – dat moet van koper zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Gij zult de Israëlieten bevelen, dat zij u brengen zuivere olie, uit gestoten olijven, voor het licht, om voortdurend een lamp te kunnen laten branden. ");
INSERT INTO nldnbg_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In de tent der samenkomst buiten het voorhangsel dat vóór de getuigenis is, zal Aäron met zijn zonen die verzorgen, van de avond tot de morgen, voor het aangezicht des Heren: een altoosdurende inzetting bij de Israëlieten voor hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Gij dan, doe tot u naderen uw broeder Aäron, en zijn zonen met hem, uit het midden der Israëlieten, om voor Mij het priesterambt te bekleden: Aäron, Nadab en Abihu, Eleazar en Itamar, de zonen van Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Gij zult heilige klederen maken voor uw broeder Aäron, tot een prachtig sieraad. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gij zult zeggen tot allen die kunstvaardig zijn, welke Ik met een geest van wijsheid vervuld heb, dat zij de klederen van Aäron maken, om hem te heiligen, om voor Mij het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Dit nu zijn de klederen die zij maken zullen: een borstschild, een efod, een opperkleed, een onderkleed van bewerkte stof, een tulband en een gordel. Zo zullen zij heilige klederen maken voor uw broeder Aäron, en voor zijn zonen, om voor Mij het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Daartoe zullen zij nemen goud, blauwpurper, roodpurper, scharlaken en fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Zij zullen de efod maken van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen: kunstig werk. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Twee verbonden schouderstukken zal hij hebben, aan de beide einden moet hij verbonden worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","De gordel aan de efod om die aan te binden, op dezelfde wijze vervaardigd, zal daarmee één geheel vormen, van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Gij zult twee chrysopraasstenen nemen en de namen der zonen van Israël daarin graveren, ");
INSERT INTO nldnbg_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","zes van hun namen op de éne steen en de zes overige namen op de andere steen, naar de volgorde van hun geboorte. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Als kunstwerk van een steensnijder, als zegelgraveerwerk, zult gij de twee stenen met de namen der zonen van Israël graveren; ingevat in gouden kassen zult gij ze maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Dan zult gij de twee stenen op de schouderstukken van de efod zetten als gedachtenisstenen voor de Israëlieten: Aäron zal hun namen ter gedachtenis voor het aangezicht des Heren op zijn beide schouderstukken dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Gij zult kassen van goud maken ");
INSERT INTO nldnbg_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","en twee kettinkjes van louter goud; als snoeren zult gij ze maken, vlechtwerk, en gij zult de gevlochten kettinkjes aan de kassen bevestigen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Gij zult een borstschild der beslissing maken, kunstig werk. Op dezelfde wijze als de efod zult gij het maken: van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen zult gij het maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Vierkant zal het zijn, dubbel, een span lang en een span breed. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Gij zult het vullen met een steenvulling, vier rijen stenen: een rij rode jaspis, chrysoliet en malachiet, de eerste rij; ");
INSERT INTO nldnbg_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","de tweede rij: hematiet, lazuursteen en prasem; ");
INSERT INTO nldnbg_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","de derde rij: barnsteen, agaat en amethist; ");
INSERT INTO nldnbg_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","de vierde rij: turkoois, chrysopraas en nefriet. Met goud omgeven zullen zij in hun zettingen gevat zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","En de stenen zullen overeenkomstig de namen der zonen van Israël twaalf in getal zijn, overeenkomstig hun namen; als zegelgraveerwerk zullen zij, elk met zijn naam, zijn voor de twaalf stammen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ook zult gij op het borstschild gedraaide kettinkjes maken, vlechtwerk, van louter goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Gij zult op het borstschild twee gouden ringen maken en de beide ringen aan de beide einden van het borstschild zetten. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Gij zult de beide gevlochten kettinkjes van goud in de beide ringen aan de einden van het borstschild doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","De beide andere einden der beide gevlochten kettinkjes zult gij aan de beide kassen vastmaken en op de schouderstukken van de efod zetten, aan de voorkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Gij zult twee gouden ringen maken en ze aan de beide einden van het borstschild zetten, op de binnenrand, die naar de efod toegekeerd is. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ook zult gij twee gouden ringen maken en ze op de beide schouderstukken van de efod zetten, onderaan, aan de voorkant, dicht bij de plaats waar hij verbonden is, boven de gordel van de efod. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Dan zal men het borstschild met zijn ringen aan de ringen van de efod vastbinden met een blauwpurperen snoer, zodat het op de gordel van de efod vastzit, en het borstschild niet van de efod kan afschuiven. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Zo zal Aäron de namen der zonen van Israël in het borstschild der beslissing op zijn hart dragen, wanneer hij in het heiligdom komt, tot een voortdurende gedachtenis voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","En gij zult in het borstschild der beslissing de Urim en de Tummim leggen; zij zullen op het hart van Aäron zijn, wanneer hij voor het aangezicht des Heren komt, en Aäron zal de beslissing voor de Israëlieten voortdurend op zijn hart dragen, voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Gij zult het opperkleed van de efod geheel van blauwpurper maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","De halsopening zal in het midden ervan zijn: de halsopening zal rondom een rand hebben van weefsel als bij een pantser, opdat het niet scheure. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","En gij zult op zijn zomen granaatappels in blauwpurper, roodpurper en scharlaken, rondom op zijn zomen, zetten, en gouden belletjes overal daartussen: ");
INSERT INTO nldnbg_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","telkens een gouden belletje en een granaatappel, rondom op de zomen van het opperkleed. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aäron nu zal dit aanhebben, als hij dienst doet, en het geluid ervan zal gehoord worden, wanneer hij in het heiligdom komt voor het aangezicht des Heren en wanneer hij naar buiten komt, opdat hij niet sterve. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ook zult gij een plaat van louter goud maken en daarop graveren als zegelgraveerwerk: Den Here heilig. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Gij zult haar aan een blauwpurperen snoer bevestigen, en zij zal zich bevinden op de tulband, aan de voorkant van de tulband. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Zij zal op het voorhoofd van Aäron zijn, en Aäron zal de schuld dragen, gelegen in de heilige dingen die de Israëlieten heiligen bij al de gaven van hun heilige dingen; ja, zij zal voortdurend op zijn voorhoofd wezen, zodat zij welgevallig zijn vóór het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Gij zult het onderkleed van fijn linnen met ingeweven patroon weven, en een tulband maken van fijn linnen en een gordel zult gij maken van veelkleurig weefwerk. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Voor de zonen van Aäron zult gij onderklederen maken en gij zult voor hen gordels maken, en hoofddoeken zult gij voor hen maken tot een prachtig sieraad. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Dan zult gij daarmede uw broeder Aäron en zijn zonen bekleden en hen zalven, wijden en heiligen, zodat zij voor Mij het priesterambt bekleden kunnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Maak voor hen linnen broeken, om hun schaamte te bedekken: van de heupen tot aan de dijen zullen zij reiken. ");
INSERT INTO nldnbg_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aäron en zijn zonen zullen die dragen, wanneer zij komen naar de tent der samenkomst of wanneer zij naderen tot het altaar, om dienst te doen in het heiligdom, opdat zij geen ongerechtigheid op zich laden en sterven. Het is een altoosdurende inzetting voor hem en voor zijn nakomelingschap. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Dit nu is wat gij hun doen zult, om hen te heiligen om voor Mij het priesterambt te bekleden: Neem één jonge stier, en twee gave rammen, ");
INSERT INTO nldnbg_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ongezuurd brood en ongezuurde koeken, met olie aangemaakt, en ongezuurde, dunne koeken, met olie bestreken; van fijn tarwemeel zult gij ze maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Leg ze in een korf en draag ze in de korf naderbij, met de stier en de beide rammen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ook zult gij Aäron en zijn zonen doen naderen tot de ingang van de tent der samenkomst en gij zult hen met water wassen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Dan zult gij de klederen nemen en Aäron bekleden met het onderkleed, het opperkleed van de efod, de efod en het borstschild; gij zult hem de gordel van de efod ombinden, ");
INSERT INTO nldnbg_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","gij zult de tulband op zijn hoofd zetten en de heilige diadeem aan de tulband vastmaken. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Dan zult gij de zalfolie nemen en over zijn hoofd uitgieten, en hem zalven. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Gij zult zijn zonen doen naderen en hen met onderklederen bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Gij zult hen omgorden met een gordel, Aäron en zijn zonen, en hun de hoofddoeken ombinden, en zij zullen het priesterambt hebben tot een altoosdurende inzetting; zo zult gij Aäron en zijn zonen wijden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Voorts zult gij de stier doen naderen vóór de tent der samenkomst, en Aäron en zijn zonen zullen hun handen op de kop van de stier leggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Gij zult de stier slachten voor het aangezicht des Heren bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Gij zult van het bloed van de stier nemen en dat met uw vinger aan de hoornen van het altaar strijken, en al het bloed zult gij aan de voet van het altaar uitgieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Dan zult gij nemen al het vet dat de ingewanden bedekt, het aanhangsel aan de lever, de beide nieren en het vet dat daaraan zit, en gij zult het op het altaar in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maar het vlees van de stier, zijn huid en zijn mest zult gij met vuur buiten de legerplaats verbranden; het is een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Dan zult gij de éne ram nemen en Aäron en zijn zonen zullen hun handen op de kop van de ram leggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Gij zult de ram slachten en zijn bloed nemen en sprengen rondom op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","De ram zult gij in zijn delen verdelen, zijn ingewanden en onderschenkels wassen en op zijn delen en zijn kop leggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Dan zult gij de gehele ram op het altaar in rook doen opgaan; het is een brandoffer voor de Here, met een liefelijke reuk; het is een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Dan zult gij de andere ram nemen, en Aäron en zijn zonen zullen hun handen op de kop van de ram leggen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Gij zult de ram slachten, van zijn bloed nemen en het strijken aan de rechter oorlel van Aäron en aan die van zijn zonen, aan hun rechterduim en aan hun rechter grote teen, en gij zult de rest van het bloed rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Gij zult van het bloed, dat op het altaar is, en van de zalfolie nemen en sprenkelen op Aäron en op zijn klederen, en ook op zijn zonen en op de klederen van zijn zonen; en hij zal heilig zijn, hij en zijn klederen, en ook zijn zonen en de klederen van zijn zonen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Gij zult van de ram nemen het vet, de vetstaart, het vet dat de ingewanden bedekt, het aanhangsel aan de lever, de beide nieren, het vet dat daaraan zit, de rechterschenkel – het is een ram ter inwijding –, ");
INSERT INTO nldnbg_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","één brood, één geoliede broodkoek en één dunne koek uit de korf met ongezuurde broden, die voor het aangezicht des Heren is. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Gij zult alles op de handen van Aäron en op die van zijn zonen leggen en gij zult dat bewegen als een beweegoffer voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Daarna zult gij het van hen aannemen en op het altaar op het brandoffer in rook doen opgaan tot een liefelijke reuk voor het aangezicht des Heren; het is een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Vervolgens zult gij de borst van de ram ter inwijding voor Aäron nemen en die bewegen als een beweegoffer voor het aangezicht des Heren, en zij zal u ten deel vallen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Zo zult gij de beweegborst heiligen en de hefschenkel, die bewogen en geheven zijn van de ram der inwijding, die zowel voor Aäron als voor zijn zonen is. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Het zal ten behoeve van Aäron en ten behoeve van zijn zonen tot een altoosdurende verplichting zijn voor de Israëlieten, want dat is een heffing, en als zodanig zal zij geheven worden van de Israëlieten, van hun vredeoffers, hun heffing voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","De heilige klederen nu van Aäron zullen voor zijn zonen na hem zijn, om hen daarin te zalven en te wijden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Zeven dagen zal de priester, die uit zijn zonen in zijn plaats komen zal naar de tent der samenkomst, om in het heiligdom dienst te doen, ze aantrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","De ram der inwijding zult gij nemen en zijn vlees koken op een heilige plaats. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aäron en zijn zonen zullen het vlees van de ram en het brood dat in de korf is, eten bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Zij zullen dan eten die dingen, waarmede verzoening gedaan werd, om hen te wijden en te heiligen, maar een onbevoegde zal er niet van eten, want het is iets heiligs. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Indien er van het vlees der inwijding en van het brood overblijft tot de morgen, zult gij het overgeblevene met vuur verbranden, het zal niet gegeten worden, want het is iets heiligs. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Gij zult voor Aäron en zijn zonen zó doen, naar alles wat Ik u geboden heb; gedurende zeven dagen zult gij hen wijden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dagelijks zult gij een stier als zondoffer ter verzoening bereiden en het altaar ontzondigen, doordat gij er verzoening over doet; gij zult het zalven om het te heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Zeven dagen zult gij over het altaar verzoening doen; gij zult het heiligen en het altaar zal allerheiligst zijn; ieder die het altaar aanraakt, zal heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Dit is, wat gij op het altaar zult bereiden: twee éénjarige lammeren, geregeld elke dag. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Het éne lam zult gij in de morgen bereiden en het andere lam zult gij in de avondschemering bereiden, ");
INSERT INTO nldnbg_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","benevens een tiende fijn meel aangemaakt met een vierde hin gestoten olie, en een plengoffer van een vierde hin wijn voor het éne lam. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Het andere lam zult gij in de avondschemering bereiden; zoals het morgenspijsoffer en het daarbij behorende plengoffer zult gij het bereiden tot een liefelijke reuk, een vuuroffer voor de Here, ");
INSERT INTO nldnbg_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","een dagelijks brandoffer voor uw geslachten bij de ingang van de tent der samenkomst voor het aangezicht des Heren, waar Ik met u zal samenkomen, om daar tot u te spreken. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ik zal dan dáár samenkomen met de Israëlieten, en zij zullen door mijn heerlijkheid geheiligd worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ik zal de tent der samenkomst en het altaar heiligen, en Aäron en zijn zonen zal Ik heiligen om voor Mij het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ik zal in het midden van de Israëlieten wonen en Ik zal hun tot een God zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","En zij zullen weten, dat Ik, de Here, hun God ben, die hen uit het land Egypte geleid heb, opdat Ik in hun midden wone; Ik ben de Here, hun God. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Gij zult een altaar, een offerplaats voor reukwerk, maken; van acaciahout zult gij het maken; ");
INSERT INTO nldnbg_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","een el lang en een el breed, zodat het vierkant is, en twee el zal zijn hoogte zijn; de hoornen zullen daarmee één geheel vormen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Gij zult het overtrekken met louter goud, het bovenvlak en de zijvlakken rondom, en de hoornen. Gij zult er een gouden omlijsting omheen maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Twee gouden ringen zult gij ervoor maken onder de omlijsting, aan de beide zijkanten zult gij ze maken, op de beide zijden, en zij zullen dienen als houders voor draagstokken om het daarmede te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gij zult dan de draagstokken van acaciahout maken en ze overtrekken met goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Gij zult het zetten vóór het voorhangsel, dat vóór de ark der getuigenis is, vóór het verzoendeksel, dat boven de getuigenis is, waar Ik met u zal samenkomen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aäron nu zal daarop welriekend reukwerk in rook doen opgaan; elke morgen, wanneer hij de lampen in orde maakt, zal hij het in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ook wanneer Aäron de lampen aansteekt in de avondschemering, zal hij het in rook doen opgaan voor het aangezicht des Heren als een bestendig reukwerk voor uw geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Gij zult daarop geen vreemd reukwerk brengen noch brandoffer noch spijsoffer, ook een plengoffer zult gij er niet op plengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aäron zal met het bloed van het zondoffer der verzoening eenmaal per jaar op zijn hoornen verzoening doen; eenmaal per jaar zal hij er verzoening op doen voor uw geslachten; allerheiligst is het voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wanneer gij het getal der Israëlieten bij de telling opneemt, dan zullen zij, ieder voor zijn leven, aan de Here een zoengeld geven, wanneer men hen telt, opdat er onder hen geen plaag zij bij de telling. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dit zal ieder die tot de getelden gaat behoren, geven: een halve sikkel, gerekend naar de heilige sikkel – deze sikkel is twintig gera – een halve sikkel is de heffing voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ieder die tot de getelden gaat behoren van twintig jaar oud en daarboven, zal de heffing voor de Here geven. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","De rijke zal niet meer noch de arme minder dan een halve sikkel opbrengen, om die te geven als heffing voor de Here ter verzoening voor uw leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","En gij zult het geld der verzoening van de Israëlieten nemen en het bestemmen voor de dienst in de tent der samenkomst; het zal voor de Israëlieten tot een gedachtenis zijn voor het aangezicht des Heren ter verzoening voor hun leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Gij nu zult een vat van koper maken met een voetstuk van koper, voor de afwassingen, het plaatsen tussen de tent der samenkomst en het altaar, en daar water in doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","En Aäron en zijn zonen zullen daarin hun handen en voeten wassen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wanneer zij naar de tent der samenkomst komen, zullen zij zich met water wassen, opdat zij niet sterven; of wanneer zij naderen tot het altaar, om dienst te doen en een vuuroffer in rook te doen opgaan voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Zij zullen dan hun handen en voeten wassen, opdat zij niet sterven; het zal voor hen een altoosdurende inzetting zijn, voor hem en voor zijn nakomelingen naar hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Gij nu, neem u zeer fijne specerijen: vijfhonderd sikkels vanzelf gevloeide mirre, en half zoveel: tweehonderd en vijftig sikkels, welriekende kaneel, en tweehonderd en vijftig sikkels welriekende kalmoes, ");
INSERT INTO nldnbg_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","en vijfhonderd sikkels kassie, naar de heilige sikkel, en een hin olijfolie. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Gij zult het tot een heilige zalfolie maken, als een zorgvuldig bereid mengsel, zoals een zalfbereider dat bereidt; het zal een heilige zalfolie zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Gij zult daarmede zalven de tent der samenkomst en de ark der getuigenis, ");
INSERT INTO nldnbg_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","de tafel met al haar gerei, de kandelaar met al zijn gerei, en het reukofferaltaar; ");
INSERT INTO nldnbg_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","het brandofferaltaar met al zijn gerei, het wasvat met zijn voetstuk. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Gij zult ze heiligen, zodat zij allerheiligst zijn; ieder die ze aanraakt, zal heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ook Aäron en zijn zonen zult gij zalven en heiligen om voor Mij het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","En tot de Israëlieten zult gij spreken: Dit is voor Mij een heilige zalfolie van geslacht tot geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Op het lichaam van een mens zal zij niet uitgegoten worden, en volgens deze bereidingswijze moogt gij niets soortgelijks maken: zij is iets heiligs, heilig zal zij u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","De man die iets soortgelijks zal bereiden en iets daarvan op een onbevoegde laat komen, zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","De Here zeide tot Mozes: Neem u welriekende stoffen: druipende hars, onyx en galbanum, welriekende stoffen en reine wierook, in gelijke delen. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Gij zult dit alles maken tot een reukwerk, een mengsel, zoals een zalfbereider bereidt, gezouten, zuiver, heilig. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Een gedeelte daarvan zult gij uiterst fijn wrijven, en iets ervan leggen vóór de Getuigenis in de tent der samenkomst, waar Ik met u zal samenkomen; allerheiligst zal dit voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","En wat het reukwerk betreft, dat gij bereiden zult, volgens deze bereidingswijze zult gij niets voor u zelf maken; het zal u iets heiligs zijn, voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","De man die iets soortgelijks maken zal, om daaraan te ruiken, zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Zie, Ik heb bij name geroepen Besaleël, de zoon van Uri, de zoon van Chur, uit de stam Juda, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","en hem vervuld met Gods Geest, met wijsheid, inzicht en kennis, en dat voor allerlei werk, om ontwerpen te bedenken, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","om die uit te voeren in goud, zilver en koper; ");
INSERT INTO nldnbg_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","om stenen te bewerken, om die in te zetten; om hout te snijden en werkzaam te zijn in allerlei arbeid. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","En zie, Ik heb naast hem gesteld Oholiab, de zoon van Achisamak, uit de stam Dan; in het hart van ieder die kunstvaardig is, heb Ik wijsheid gelegd. Zij zullen alles maken, wat Ik u geboden heb: ");
INSERT INTO nldnbg_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","de tent der samenkomst, de ark voor de getuigenis, het verzoendeksel dat daarop ligt, en al het gerei der tent, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","de tafel met haar gerei, de kandelaar van louter goud met al zijn gerei, het reukofferaltaar, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","het brandofferaltaar met al zijn gerei, het wasvat met zijn voetstuk, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","de ambtsklederen, zowel de heilige klederen van de priester Aäron als de klederen van zijn zonen, om het priesterambt te bekleden, ");
INSERT INTO nldnbg_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","de zalfolie en het welriekend reukwerk voor het heiligdom; naar alles wat Ik u geboden heb, zullen zij dit maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","De Here zeide tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Gij dan, spreek tot de Israëlieten: maar mijn sabbatten moet gij onderhouden, want dat is een teken tussen Mij en u, van geslacht tot geslacht, zodat gij weet, dat Ik de Here ben, die u heilig. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Gij zult de sabbat onderhouden, want deze is iets heiligs voor u; wie hem ontheiligt, zal zeker ter dood gebracht worden, want ieder die daarop werk verricht, zal uitgeroeid worden uit het midden van zijn volksgenoten. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Zes dagen mag men arbeiden, maar op de zevende dag zal er een volledige sabbat zijn, de Here geheiligd: ieder die op de sabbatdag werk verricht, zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","De Israëlieten zullen de sabbat onderhouden, door de sabbat te vieren, zij en hun nageslacht, als een altoosdurend verbond. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tussen Mij en de Israëlieten is deze een teken voor altoos, want in zes dagen heeft de Here de hemel en de aarde gemaakt, en op de zevende dag heeft Hij gerust en adem geschept. ");
INSERT INTO nldnbg_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","En Hij gaf aan Mozes, toen Hij geëindigd had met hem te spreken op de berg Sinai, de twee tafelen der getuigenis, tafelen van steen, beschreven door de vinger Gods. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Toen het volk zag, dat Mozes toefde van de berg af te dalen, verzamelde het zich rondom Aäron, en zeide tot hem: Welaan, maak ons goden, die vóór ons uit gaan, want deze Mozes, die man, die ons uit het land Egypte heeft gevoerd – wij weten niet, wat er van hem geworden is. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","En Aäron zeide tot hen: Rukt de gouden ringen af, die in de oren van uw vrouwen, uw zonen en uw dochters zijn, en brengt ze mij. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Toen rukte het gehele volk zich de gouden ringen die in hun oren waren, af en zij brachten ze aan Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Hij nam ze van hen aan, gaf er vorm aan met een stift en maakte er een gegoten kalf van. En zij zeiden: Dit is uw god, Israël, die u uit het land Egypte heeft gevoerd. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Toen Aäron dat zag, bouwde hij daarvóór een altaar en riep uit: Morgen is er een feest voor de Here! ");
INSERT INTO nldnbg_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","En de volgende morgen vroeg offerden zij brandoffers en brachten vredeoffers, en het volk zette zich neer om te eten en te drinken; daarna stonden zij op om vreugde te bedrijven. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","En de Here sprak tot Mozes: Ga, daal af, want uw volk, dat gij uit het land Egypte hebt gevoerd, heeft het verdorven. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Zij hebben zich gehaast om af te wijken van de weg die Ik hun geboden had; zij hebben zich een gegoten kalf gemaakt, waarvoor zij zich hebben nedergebogen en waaraan zij geofferd hebben, terwijl zij zeiden: dit is uw god, Israël, die u uit het land Egypte heeft gevoerd. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Vervolgens zeide de Here tot Mozes: Ik heb dit volk gezien en zie, het is een hardnekkig volk. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nu dan, laat Mij begaan, dat mijn toorn tegen hen ontbrande en Ik hen vernietige, maar u zal Ik tot een groot volk maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Toen zocht Mozes de gunst van de Here, zijn God, en hij zeide: Waarom, Here, zou uw toorn ontbranden tegen uw volk, dat Gij uit het land Egypte hebt geleid met grote kracht en met een sterke hand? ");
INSERT INTO nldnbg_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Waarom zouden de Egyptenaren zeggen: Tot hun onheil heeft Hij hen uitgeleid, om hen te doden in de bergen en hen van de aardbodem te vernietigen? Laat uw brandende toorn varen en heb berouw over het onheil, waarmede Gij uw volk bedreigt. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Denk aan Abraham, Isaak en Israël, uw dienaren, aan wie Gij gezworen hebt bij Uzelf en tot wie Gij gesproken hebt: Ik zal uw nakomelingschap vermenigvuldigen als de sterren des hemels en dit gehele land, waarover Ik gesproken heb, zal Ik aan uw nakomelingschap geven, om het voor altoos te bezitten. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","En de Here kreeg berouw over het kwaad, dat Hij gezegd had zijn volk te zullen aandoen. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Toen keerde Mozes zich om en daalde van de berg af met de twee tafelen der getuigenis in zijn hand, tafelen, die aan beide zijden beschreven waren: aan de éne en aan de andere zijde waren zij beschreven. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","De tafelen waren het werk Gods en het schrift was het schrift Gods, op de tafelen gegrift. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Toen nu Jozua het rumoer van het juichende volk hoorde, zeide hij tot Mozes: Er is krijgsgeschreeuw in de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Maar deze zeide: Geen geluid van overwinningsgeroep en geen geluid van roepen bij nederlaag – een geluid van beurtzang is het, wat ik hoor. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","En zodra hij de legerplaats genaderd was en het kalf en de reidansen zag, ontbrandde de toorn van Mozes; hij wierp de tafelen uit zijn hand en verbrijzelde ze aan de voet van de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Daarop nam hij het kalf dat zij gemaakt hadden, verbrandde het met vuur en vermaalde het, totdat het fijn gestoten was, vervolgens strooide hij het op het water en gaf dit aan de Israëlieten te drinken. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Toen zeide Mozes tot Aäron: Wat heeft dit volk u gedaan, dat gij zulk een zware schuld daarover gebracht hebt? ");
INSERT INTO nldnbg_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Maar Aäron zeide: De toorn van mijn heer ontbrande niet; gij weet zelf, dat dit volk in het boze ligt. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Zij zeiden tot mij: Maak ons goden, die vóór ons uit gaan, want deze Mozes, die man, die ons uit het land Egypte heeft gevoerd – wij weten niet, wat er van hem geworden is. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Toen zeide ik tot hen: Wie heeft goud? Rukt het af! Zij gaven het mij en ik wierp het in het vuur, en dit kalf kwam eruit. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Daar Mozes zag, dat het volk teugelloos was – want Aäron had het de vrije teugel gelaten, tot spot voor hun tegenstanders – ");
INSERT INTO nldnbg_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ging Mozes staan in de poort van de legerplaats en zeide: Wie is voor de Here? Die kome tot mij! en tot hem verzamelden zich al de Levieten. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","En hij zeide tot hen: Zó zegt de Here, de God van Israël: Ieder gorde zijn zwaard aan zijn heup en ga heen en weer door de legerplaats van poort tot poort en dode, ieder zijn broeder en ieder zijn verwant en ieder zijn naaste. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","De Levieten deden naar het woord van Mozes en er vielen van het volk op die dag ongeveer drieduizend man. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mozes nu zeide: Weest heden de Here gewijd – want ieder was tegen zijn zoon en zijn broeder – en wel om heden een zegen over u te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","De volgende dag zeide Mozes tot het volk: Gij hebt een grote zonde begaan, maar nu zal ik opklimmen tot de Here, misschien zal ik voor uw zonde verzoening bewerken. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Toen keerde Mozes tot de Here terug en zeide: Ach, dit volk heeft een grote zonde begaan, want zij hebben zich een gouden god gemaakt. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Maar nu, vergeef toch hun zonde – en zo niet, delg mij dan uit het boek dat Gij geschreven hebt. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Maar de Here zeide tot Mozes: Wie tegen Mij gezondigd heeft, zal Ik uit mijn boek delgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Maar ga nu heen, leid het volk naar de plaats waarvan Ik u gesproken heb; zie, mijn engel zal voor u uit gaan, maar ten dage van mijn bezoeking zal Ik aan hen hun zonde bezoeken. ");
INSERT INTO nldnbg_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Zo sloeg de Here het volk, omdat dit het kalf gemaakt had, dat Aäron vervaardigd had. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","En de Here sprak tot Mozes: Ga, trek vanhier op, gij en het volk dat gij uit het land Egypte hebt gevoerd, naar het land, waarvan Ik Abraham, Isaak en Jakob gezworen heb: aan uw nakomelingschap zal Ik het geven – ");
INSERT INTO nldnbg_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ik zal een engel voor uw aangezicht zenden en verdrijven de Kanaäniet, de Amoriet, de Hethiet, de Perizziet, de Chiwwiet en de Jebusiet –, ");
INSERT INTO nldnbg_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","naar een land, vloeiende van melk en honig. Want Ik zal in uw midden niet optrekken, daar gij een hardnekkig volk zijt, opdat Ik u niet onderweg vertere. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Toen het volk dit kwade woord hoorde, treurde het en niemand deed zijn sieraad aan. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","De Here nu zeide tot Mozes: Zeg tot de Israëlieten: gij zijt een hardnekkig volk. Indien Ik ook maar één ogenblik in uw midden zou optrekken, zou Ik u vernietigen. Nu dan, doe uw sieraad af, dan zal Ik zien, wat Ik u doen zal. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","En de Israëlieten onthielden zich van sieraad, van de berg Horeb af. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mozes nu nam een tent en spande haar voor zich uit buiten de legerplaats, ver van de legerplaats, en noemde haar: tent der samenkomst. Ieder, die de Here zocht, ging uit naar de tent der samenkomst, die buiten de legerplaats was. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Wanneer Mozes uitging naar de tent, stond het gehele volk op en ging staan, ieder aan de ingang van zijn tent, en zij zagen Mozes na, totdat hij de tent was binnengegaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Zodra Mozes in de tent kwam, daalde de wolkkolom neer en bleef staan aan de ingang van de tent, en Hij sprak met Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wanneer het gehele volk de wolkkolom zag staan aan de ingang van de tent, stond het op en boog zich neder, ieder aan de ingang van zijn tent. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","En de Here sprak tot Mozes van aangezicht tot aangezicht, zoals iemand spreekt met zijn vriend; dan keerde hij terug naar de legerplaats. Maar zijn dienaar Jozua, de zoon van Nun, een jonge man, week niet uit de tent. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Toen zeide Mozes tot de Here: Zie, Gij zegt tot mij: doe dit volk optrekken, maar Gij hebt mij niet doen weten, wie Gij met mij zult zenden, terwijl Gij toch gezegd hebt: Ik ken u bij name en ook hebt gij genade gevonden in mijn ogen. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nu dan, indien ik genade in uw ogen gevonden heb, maak mij toch uw wegen bekend, zodat ik U ken; opdat ik genade vinde in uw ogen. Bedenk toch, dat deze natie uw volk is. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Toen zeide Hij: Moet Ik zelf medegaan om u gerust te stellen? ");
INSERT INTO nldnbg_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","En hij zeide tot Hem: Indien Gij zelf niet medegaat, doe ons vanhier niet optrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Waaraan zal anders geweten worden, dat ik en uw volk genade in uw ogen gevonden hebben, dan doordat Gij met ons medegaat? Immers daardoor zijn ik en uw volk afgezonderd uit alle volken, die op de aardbodem zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","En de Here zeide tot Mozes: Ook deze zaak, waarover gij gesproken hebt, zal Ik doen, omdat gij genade in mijn ogen gevonden hebt en Ik u bij name ken. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Maar hij zeide: Doe mij toch uw heerlijkheid zien. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Hij nu zeide: Ik zal mijn luister aan u doen voorbijgaan en de naam des Heren voor u uitroepen: Ik zal genadig zijn, wie Ik genadig ben, en Mij ontfermen, over wie Ik Mij ontferm. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hij zeide: Gij zult mijn aangezicht niet kunnen zien, want geen mens zal Mij zien en leven. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","De Here zeide: Zie, bij Mij is een plaats, waar gij op de rots kunt staan; ");
INSERT INTO nldnbg_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","wanneer mijn heerlijkheid voorbijgaat, zal Ik u in de rotsholte zetten en u met mijn hand bedekken, totdat Ik ben voorbijgegaan. ");
INSERT INTO nldnbg_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Dan zal Ik mijn hand wegnemen en gij zult Mij van achteren zien, maar mijn aangezicht zal niet gezien worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","De Here zeide tot Mozes: Houw u twee stenen tafelen gelijk de eerste, dan zal Ik op de tafelen de woorden schrijven, die stonden op de eerste tafelen, welke gij verbrijzeld hebt. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wees gereed tegen de morgen en beklim in de morgen de berg Sinai; vervoeg u daar bij Mij op de top van de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Doch niemand zal met u opklimmen en ook mag niemand gezien worden op de gehele berg, zelfs het kleinvee en de runderen mogen niet weiden in de nabijheid van de berg. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Toen hieuw Mozes twee stenen tafelen gelijk de eerste; hij beklom vroeg in de morgen de berg Sinai, zoals de Here hem geboden had, en nam de twee stenen tafelen in zijn hand. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","En de Here daalde neder in een wolk, stelde Zich daar bij hem en riep de naam des Heren uit. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","De Here ging aan hem voorbij en riep: Here, Here, God, barmhartig en genadig, lankmoedig, groot van goedertierenheid en trouw, ");
INSERT INTO nldnbg_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","die goedertierenheid bestendigt aan duizenden, die ongerechtigheid, overtreding en zonde vergeeft; maar (de schuldige) houdt Hij zeker niet onschuldig, de ongerechtigheid der vaderen bezoekende aan kinderen en kindskinderen, aan het derde en vierde geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mozes knielde haastig ter aarde, boog zich neder ");
INSERT INTO nldnbg_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","en zeide: Indien ik genade in uw ogen gevonden heb, Here, dan ga toch de Here in ons midden, want het is een hardnekkig volk, maar vergeef onze ongerechtigheden en onze zonden; neem ons als erfdeel in bezit. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hij zeide: Zie, Ik sluit een verbond; in het bijzijn van uw gehele volk zal Ik wonderen doen, zoals niet gewrocht zijn op de gehele aarde en bij al de volken; het gehele volk, in welks midden gij zijt, zal het werk des Heren zien, want ontzagwekkend is wat Ik met u doe. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Onderhoud wat Ik u heden gebied. Zie, voor u uit verdrijf Ik de Amoriet, de Kanaäniet, de Hethiet, de Perizziet, de Chiwwiet en de Jebusiet. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Neem u in acht, dat gij geen verbond sluit met de inwoners van het land, waarheen gij gaat, opdat zij niet tot een valstrik in uw midden worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Integendeel, hun altaren zult gij omverhalen, hun gewijde stenen verbrijzelen en hun gewijde palen omhouwen. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Want gij zult u niet nederbuigen voor een andere god, immers de Here, wiens naam Naijverige is, is een naijverig God. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Sluit toch geen verbond met de inwoners van het land; wanneer zij hun goden overspelig nalopen en aan hun goden offeren, dan zouden zij u uitnodigen en gij zoudt van hun slachtoffer eten. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Wanneer gij van hun dochters voor uw zonen neemt en zij haar goden overspelig nalopen, dan zouden zij tevens uw zonen tot overspelig nalopen van haar goden verleiden. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Gegoten goden zult gij u niet maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Het feest der ongezuurde broden zult gij onderhouden: zeven dagen zult gij ongezuurde broden eten, gelijk Ik u geboden heb, op de bepaalde tijd van de maand Abib, want in de maand Abib zijt gij uit Egypte getrokken. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alles wat het eerst uit de moederschoot voortkomt, is mijn eigendom, en al uw vee van het mannelijk geslacht, dat de eerstgeboorte is van een rund of van een stuk kleinvee. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Maar de eerstgeboorte van een ezel zult gij lossen voor een stuk kleinvee; indien gij het niet lost, zult gij het de nek breken. Iedere eerstgeborene van uw zonen zult gij lossen, en men zal niet met ledige handen voor mijn aangezicht verschijnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Zes dagen zult gij arbeiden, maar op de zevende dag zult gij rusten, ook in de ploegtijd en in de oogst zult gij de rustdag houden. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Het feest der weken, der eerstelingen van de tarweoogst, zult gij vieren, en het feest der inzameling bij de wisseling des jaars. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Driemaal in het jaar zal ieder van u, die van het mannelijk geslacht is, voor het aangezicht van de Here Here, de God van Israël, verschijnen, ");
INSERT INTO nldnbg_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","want Ik zal volken voor uw aangezicht verdrijven en uw gebied ruim maken; en niemand zal uw land begeren, wanneer gij opgaat, om voor het aangezicht van de Here, uw God, te verschijnen driemaal in het jaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Gij zult het bloed van mijn slachtoffer niet op iets gezuurds slachten, en het slachtoffer van het Paasfeest mag de nacht niet overblijven tot de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Het beste van de eerstelingen van uw bodem zult gij in het huis van de Here, uw God, brengen. Gij zult een bokje niet koken in de melk van zijn moeder. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","De Here zeide tot Mozes: Schrijf u deze woorden op, want op grond van deze woorden heb Ik met u en met Israël een verbond gesloten. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","En hij was daar bij de Here veertig dagen en veertig nachten, brood at hij niet en water dronk hij niet, en Hij schreef op de tafelen de woorden van het verbond, de Tien Woorden. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Toen Mozes van de berg Sinai afdaalde, – de twee tafelen der getuigenis nu waren in de hand van Mozes, toen hij van de berg afdaalde – wist hij niet, dat de huid van zijn gelaat straalde, doordat hij met Hem gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Toen Aäron en al de Israëlieten Mozes zagen, zie, de huid van zijn gelaat straalde, en zij durfden hem niet naderen. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Toen riep Mozes hen tot zich, en Aäron en al de vorsten in de vergadering keerden tot hem terug en Mozes sprak hen toe. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Daarna naderden al de Israëlieten en hij gebood hun al wat de Here tot hem gesproken had op de berg Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Toen Mozes geëindigd had met hen te spreken, deed hij een doek voor zijn gelaat. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Maar wanneer Mozes kwam voor het aangezicht des Heren, om met Hem te spreken, deed hij de doek af, totdat hij naar buiten ging; daarna ging hij naar buiten en zeide tot de Israëlieten wat geboden was. ");
INSERT INTO nldnbg_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Wanneer de Israëlieten aan het gelaat van Mozes zagen, dat de huid van zijn gelaat straalde, deed Mozes de doek weer voor zijn gelaat, totdat hij naar binnen ging, om met Hem te spreken. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Toen liet Mozes de gehele vergadering der Israëlieten samenkomen en zeide tot hen: Dit zijn de geboden, die de Here bevolen heeft te doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Zes dagen zal werk verricht worden, maar op de zevende dag zal het voor u een heilige tijd zijn, een volledige sabbat voor de Here; ieder, die daarop werk verricht, zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Gij zult in geen van uw woningen vuur ontsteken op de sabbatdag. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mozes zeide tot de gehele vergadering der Israëlieten: Dit is het gebod dat de Here gegeven heeft: ");
INSERT INTO nldnbg_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","neemt van uw bezit een heffing voor de Here; ieder zal deze gewillig van hart opbrengen als heffing voor de Here, goud, zilver, koper; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blauwpurper, roodpurper, scharlaken, fijn linnen, geitehaar; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","roodgeverfde ramsvellen, tachasvellen, acaciahout; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olie voor het licht, specerijen voor de zalfolie en voor het welriekend reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","chrysopraasstenen en vulstenen voor de efod en voor het borstschild. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Allen die onder u kunstvaardig zijn, zullen komen maken al wat de Here geboden heeft; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","de tabernakel, zijn tent en zijn dekkleed, zijn haken en zijn planken, zijn dwarsbalken, zijn pilaren en zijn voetstukken; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","de ark met haar draagstokken, het verzoendeksel en het voorhangsel ter bedekking; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","de tafel met haar draagstokken, al haar toebehoren en het toonbrood; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","de lichtkandelaar met zijn gerei, zijn lampen en de olie voor het licht; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","het reukofferaltaar met zijn draagstokken, de zalfolie en het welriekend reukwerk; het gordijn van de ingang, voor de ingang van de tabernakel; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","het brandofferaltaar met het bijbehorende koperen traliewerk, zijn draagstokken en al zijn gerei, het wasvat met zijn voetstuk; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","de gordijnen van de voorhof, zijn pilaren, zijn voetstukken en het gordijn van de poort van de voorhof; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","de pinnen van de tabernakel en de pinnen van de voorhof, en hun touwen; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","de ambtsklederen voor de dienst in het heiligdom, de heilige klederen voor de priester Aäron en de klederen van zijn zonen, om het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toen ging de gehele vergadering der Israëlieten van Mozes heen. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Daarop kwam iedere man wiens hart hem dreef, ieder wiens geest hem drong, en bracht de heffing voor de Here ten behoeve van het werk aan de tent der samenkomst en voor de gehele dienst en de heilige klederen. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Zij kwamen dan, de mannen zowel als de vrouwen, en ieder bracht gewillig van hart neusringen, oorringen, zegelringen en halssieraden, allerlei gouden voorwerpen. Iedere man die een beweegoffer van goud voor de Here bewoog, ");
INSERT INTO nldnbg_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","en iedere man die blauwpurper, roodpurper, scharlaken, fijn linnen, geitehaar, roodgeverfde ramsvellen en tachasvellen in zijn bezit had, bracht dit. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ieder die een heffing van zilver of koper hief, bracht de heffing voor de Here, en ieder die acaciahout voor al het werk ten behoeve van de dienst in zijn bezit had, bracht dit. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Iedere vrouw, die kunstvaardig was, spon eigenhandig en zij bracht het gesponnene, het blauwpurper, roodpurper, scharlaken en het fijne linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Alle kunstvaardige vrouwen, wier hart haar daartoe dreef, sponnen het geitehaar. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","De vorsten brachten de chrysopraasstenen en de vulstenen voor de efod en voor het borstschild, ");
INSERT INTO nldnbg_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","de specerij en de olie voor het licht, voor de zalfolie en voor welriekend reukwerk. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Alle mannen en vrouwen, wier hart hen drong om iets te brengen voor al het werk dat de Here door Mozes geboden had te maken – de Israëlieten brachten het als een vrijwillige gave voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mozes zeide tot de Israëlieten: Ziet, de Here heeft Besaleël, de zoon van Uri, de zoon van Chur, uit de stam Juda, bij name geroepen, ");
INSERT INTO nldnbg_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","en heeft hem vervuld met Gods Geest, met wijsheid, inzicht en kennis en dat voor allerlei werk: ");
INSERT INTO nldnbg_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","om ontwerpen te bedenken en om die uit te voeren in goud, zilver en koper; ");
INSERT INTO nldnbg_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","om stenen te bewerken en om die in te zetten; om hout te snijden en om al het ontworpen werk te maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","En Hij heeft hem en Oholiab, de zoon van Achisamak, uit de stam van Dan in het hart gegeven om anderen te onderrichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Hij heeft hen vervuld met kunstvaardigheid, om te maken al het werk van een handwerker, van een kunstenaar, van een maker van veelkleurig weefwerk in blauwpurper, roodpurper, scharlaken en fijn linnen, en van een wever: uitvoerders van allerlei werk en makers van ontwerpen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Zo moeten Besaleël en Oholiab werken, en iedere man die kunstvaardig is, aan wie de Here wijsheid en inzicht in die dingen geschonken heeft, zodat hij verstand heeft van het vervaardigen van al het werk voor de dienst van het heiligdom, overeenkomstig alles wat de Here geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Toen ontbood Mozes Besaleël en Oholiab en iedere man die kunstvaardig was, in wiens hart de Here wijsheid had gelegd, ieder wiens hart hem drong om het werk te komen verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Zij namen van Mozes de gehele heffing over, die de Israëlieten gebracht hadden ten behoeve van het werk voor de dienst van het heiligdom, om dit te verrichten. Dezen nu brachten nog elke morgen een vrijwillige gave tot hem. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","En al de vaklieden, die het gehele werk ten behoeve van het heiligdom maakten, kwamen ieder van het werk dat hij verrichtte, ");
INSERT INTO nldnbg_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","en zeiden tot Mozes: Het volk brengt meer dan nodig is voor de uitvoering van het werk dat de Here geboden heeft te maken. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Toen gaf Mozes een bevel en men liet het overal in de legerplaats afroepen: Laat man noch vrouw verder enig werk maken ten behoeve van de heffing voor het heiligdom. Zo werd het volk weerhouden meer te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Want het materiaal was voldoende om al het werk te maken, ja, er was te veel. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Toen maakten alle kunstvaardigen onder de werklieden de tabernakel van tien tentkleden van getweernd fijn linnen en van blauwpurper, roodpurper en scharlaken; met kunstig geweven cherubs maakte men die. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","De lengte van elk tentkleed was achtentwintig el, en de breedte van elk tentkleed vier el: eenzelfde maat voor al de tentkleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Men verbond vijf van de tentkleden aan elkander, en nog eens vijf tentkleden aan elkander. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ook maakte men blauwpurperen lussen op de rand van het ene tentkleed, aan het einde, aan het ene stel; evenzo deed men op de rand van het laatste tentkleed aan het andere stel. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Vijftig lussen maakte men op het ene tentkleed en vijftig lussen aan het einde van het tentkleed, dat tot het andere stel behoorde, zodat de lussen tegenover elkaar stonden, de één tegenover de ander. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Men maakte vijftig gouden haken en verbond de tentkleden aan elkander door de haken, zodat de tabernakel één geheel was. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Men maakte tentkleden van geitehaar tot een tent over de tabernakel, elf tentkleden maakte men. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","De lengte van elk tentkleed was dertig el en de breedte van elk tentkleed vier el: eenzelfde maat voor de elf tentkleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Men verbond vijf van de tentkleden afzonderlijk en zes van de tentkleden afzonderlijk. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Men maakte vijftig lussen op de rand van het laatste tentkleed aan het ene stel, en vijftig lussen op de rand van het tentkleed aan het andere stel. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Men maakte vijftig koperen haken, om de tent te verbinden, zodat zij één geheel was. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ook maakte men een dekkleed voor de tent van roodgeverfde ramsvellen, en een dekkleed van tachasvellen daaroverheen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Men maakte de planken voor de tabernakel van acaciahout, rechtopstaande; ");
INSERT INTO nldnbg_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","tien el was een plank lang en anderhalve el breed. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Elke plank had twee tappen, zodat zij aan elkaar verbonden konden worden; zo deed men met al de planken van de tabernakel. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Men maakte de planken voor de tabernakel, twintig planken aan de zuidkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","En veertig zilveren voetstukken maakte men onder de twintig planken, twee voetstukken onder de ene plank voor haar beide tappen, en twee voetstukken onder de andere plank voor haar beide tappen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Evenzo maakte men voor de andere zijde van de tabernakel aan de noordkant twintig planken ");
INSERT INTO nldnbg_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","en veertig zilveren voetstukken daarvoor: twee voetstukken onder de ene plank en twee voetstukken onder de andere plank. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Voor de achterzijde van de tabernakel aan de westkant maakte men zes planken. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Twee planken maakte men voor de hoeken van de tabernakel aan de achterkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Zij waren volkomen gelijk aan de onderkant en aan de bovenkant, tot de ene ring. Zo deed men met die beide, om de twee hoeken te vormen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Er waren dus acht planken met haar zilveren voetstukken: zestien voetstukken; telkens twee voetstukken onder één plank. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Men maakte dwarsbalken van acaciahout: vijf voor de planken van de ene zijde van de tabernakel, ");
INSERT INTO nldnbg_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","vijf dwarsbalken voor de planken van de andere zijde van de tabernakel, en vijf dwarsbalken voor de planken van de tabernakel aan de achterkant naar het westen. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Men maakte de middelste dwarsbalk in het midden der planken, dwars dóórlopende van het ene einde naar het andere. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","De planken overtrok men met goud, de ringen maakte men van goud als houders voor de dwarsbalken, en de dwarsbalken overtrok men met goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Men maakte het voorhangsel van blauwpurper, roodpurper, scharlaken en getweernd fijn linnen; met kunstig geweven cherubs maakte men het. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Men maakte daarvoor vier pilaren van acaciahout en overtrok ze met goud; de haken waren van goud, en men goot er vier zilveren voetstukken voor. ");
INSERT INTO nldnbg_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Men maakte een gordijn voor de ingang der tent van blauwpurper, roodpurper, scharlaken en getweernd fijn linnen: veelkleurig weefwerk; ");
INSERT INTO nldnbg_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","en de vijf pilaren van acaciahout, met hun haken; men overtrok hun toppen en dwarsstangen met goud, en de vijf voetstukken waren van koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleël maakte de ark van acaciahout, twee en een halve el lang, anderhalve el breed, en anderhalve el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Hij overtrok die met louter goud, van binnen en van buiten, en hij maakte er een gouden omlijsting omheen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hij goot er vier gouden ringen voor, aan de vier voetstukken en wel twee ringen aan de ene zijwand en twee ringen aan de andere zijwand. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Hij maakte draagstokken van acaciahout en overtrok die met goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","En hij stak de draagstokken in de ringen aan de zijwanden van de ark om de ark te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hij maakte een verzoendeksel van louter goud, twee en een halve el lang en anderhalve el breed. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Hij maakte twee cherubs van goud, van gedreven werk maakte hij ze, aan de beide einden van het verzoendeksel, ");
INSERT INTO nldnbg_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","één cherub aan het ene einde en één cherub aan het andere einde. Uit één stuk met het verzoendeksel maakte hij de cherubs op zijn beide einden. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","En de cherubs hielden twee vleugels uitgespreid naar boven, met hun vleugels het verzoendeksel bedekkende en hun aangezicht naar elkander gericht; naar het verzoendeksel waren de aangezichten der cherubs gericht. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Hij maakte de tafel van acaciahout, twee el lang, één el breed en anderhalve el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Hij overtrok die met louter goud en maakte er een gouden omlijsting omheen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hij maakte er een rand van een handbreedte omheen en een gouden omlijsting rondom haar rand. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Hij goot er vier gouden ringen voor en hij zette de ringen op de vier hoeken aan haar vier poten. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Dicht bij de rand bevonden zich de ringen, als houders voor de draagstokken om de tafel te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Hij maakte de draagstokken van acaciahout en overtrok ze met goud, om de tafel te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","En hij maakte het gerei dat op de tafel behoorde, de schotels, schalen, kommen, en de kannen, waarmee geplengd wordt, van louter goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hij maakte de kandelaar van louter goud; van gedreven werk maakte hij de kandelaar, het voetstuk zowel als de schacht, de bloemkelken, met knoppen en bloesems, vormden één geheel daarmee. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Zes armen staken uit zijn zijden: drie armen van de kandelaar uit de ene zijde en drie armen van de kandelaar uit de andere zijde. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Drie bloemkelken in de vorm van amandelbloesem aan de ene arm, met knop en bloesem, en drie bloemkelken, in de vorm van amandelbloesem, aan de andere arm, met knop en bloesem; aldus voor de zes armen, die uit de kandelaar uitstaken. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Op de kandelaar vier bloemkelken, in de vorm van amandelbloesem, met zijn knoppen en bloesems. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ook een knop onder het eerste paar armen, die uit hem voortkwamen, en een knop onder het tweede paar armen, die uit hem voortkwamen, en een knop onder het derde paar armen, die uit hem voortkwamen; (aldus) bij de zes armen, die er uitstaken. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","De knoppen en de armen kwamen uit hem voort, terwijl het geheel één gedreven werk van louter goud was. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","En hij maakte er de zeven lampen voor met snuiters en bakjes van louter goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Van een talent louter goud maakte hij hem met al zijn gerei. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hij maakte het reukofferaltaar van acaciahout, een el lang en een el breed, vierkant, en twee el hoog; de hoornen vormden daarmee één geheel. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Hij overtrok het met louter goud, het bovenvlak en de zijvlakken rondom, en de hoornen. Hij maakte er een gouden omlijsting omheen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Hij maakte er twee gouden ringen voor, onder de omlijsting, aan de beide zijkanten op de beide zijden, als houders voor draagstokken om het daarmee te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","En hij maakte draagstokken van acaciahout en overtrok ze met goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","En hij maakte de heilige zalfolie en het zuivere welriekend reukwerk, zoals een zalfbereider die bereidt. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Hij maakte het brandofferaltaar van acaciahout, vijf el lang en vijf el breed, vierkant, en drie el hoog. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Hij maakte hoornen aan de vier hoeken, de hoornen vormden daarmee één geheel en hij overtrok het met koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hij maakte al het gerei van het altaar: de potten, de scheppen, de sprengbekkens, de vorken en de vuurpannen, al zijn gerei maakte hij van koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hij maakte voor het altaar een traliewerk, een koperen netwerk, tot halverwege beneden zijn rand. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Hij goot vier ringen aan de vier einden van het koperen traliewerk, als houders voor de draagstokken. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Hij maakte de draagstokken van acaciahout en overtrok ze met koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","En hij stak de draagstokken in de ringen aan de zijden van het altaar, om het daarmee te dragen; hol, van planken maakte hij dit. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hij maakte het wasvat van koper, met een voetstuk van koper, van de spiegels der dienstdoende vrouwen, die dienst deden bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hij maakte de voorhof; voor de zuidzijde: de gordijnen van de voorhof van getweernd fijn linnen, honderd el; ");
INSERT INTO nldnbg_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","hun twintig pilaren met daarvoor twintig voetstukken van koper, en voor de pilaren haken en dwarsstangen van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Voor de noordzijde: honderd el; hun twintig pilaren met daarvoor twintig voetstukken van koper en voor de pilaren haken en dwarsstangen van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Voor de westzijde: de gordijnen vijftig el; en hun tien pilaren met daarvoor tien voetstukken, en voor de pilaren haken en dwarsstangen van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","En voor de oostzijde: vijftig el. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Voor het ene zijstuk: de gordijnen vijftien el, met hun drie pilaren met de drie voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","En voor het andere zijstuk – aan weerszijden van de poort van de voorhof waren gordijnen – vijftien el, met de drie pilaren en de drie voetstukken daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Al de gordijnen van de voorhof rondom, waren van getweernd fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","De voetstukken voor de pilaren waren van koper, de haken en de dwarsstangen voor de pilaren van zilver, ook het overtrek van hun boveneinde was van zilver. Zij waren door zilveren dwarsstangen verbonden, al de pilaren van de voorhof. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Het gordijn voor de poort van de voorhof was veelkleurig weefwerk van blauwpurper, roodpurper, scharlaken en getweernd fijn linnen; twintig el was de lengte, en de hoogte – tevens de breedte (van de stof) – was vijf el, in overeenstemming met de gordijnen van de voorhof. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","De vier pilaren en de vier voetstukken daarvan waren van koper; de haken, het overtrek van hun boveneinde en de dwarsstangen waren van zilver. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Al de pinnen voor de tabernakel en voor de voorhof rondom, waren van koper. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Dit zijn de kosten van de tabernakel, de tabernakel der getuigenis, die berekend zijn op bevel van Mozes door de Levieten onder leiding van Itamar, de zoon van de priester Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleël nu, de zoon van Uri, de zoon van Chur, uit de stam Juda, maakte alles wat de Here Mozes geboden had, ");
INSERT INTO nldnbg_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","en met hem Oholiab, de zoon van Achisamak, uit de stam Dan, een handwerker en kunstenaar, vervaardiger van veelkleurig weefwerk in blauwpurper, roodpurper, scharlaken en fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Al het goud dat gebruikt werd bij de verrichting van alle werkzaamheden aan het heiligdom, het goud van het beweegoffer, was negenentwintig talenten en zevenhonderd en dertig sikkels, naar de heilige sikkel. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Het zilver van de getelden der vergadering was honderd talenten en duizend zevenhonderd en vijfenzeventig sikkels naar de heilige sikkel: ");
INSERT INTO nldnbg_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","een beka per hoofd, dat is een halve sikkel, naar de heilige sikkel, voor ieder die tot de getelden ging behoren, van twintig jaar oud en daarboven, ten getale van zeshonderdendrieduizend vijfhonderd en vijftig man. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Honderd talenten zilver dienden om de voetstukken van het heiligdom en van het voorhangsel te gieten, honderd voetstukken, naar de honderd talenten, een talent voor een voetstuk. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Van de duizend zevenhonderd en vijfenzeventig sikkels maakte hij haken voor de pilaren, overtrok er hun boveneinde mee en maakte daarvoor verbindingen. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Het koper van het beweegoffer was zeventig talenten en tweeduizend vierhonderd sikkels. ");
INSERT INTO nldnbg_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Daarvan maakte hij de voetstukken voor de ingang van de tent der samenkomst, het koperen altaar met het bijbehorende koperen traliewerk, al het gerei van het altaar, ");
INSERT INTO nldnbg_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","de voetstukken van de voorhof rondom, de voetstukken van de poort van de voorhof, al de pinnen van de tabernakel en al de pinnen van de voorhof rondom. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Van het blauwpurper, roodpurper en scharlaken maakten zij ambtsklederen voor de dienst in het heiligdom; ook maakten zij de heilige klederen die voor Aäron bestemd waren, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hij maakte de efod van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Zij pletten de gouden platen en hij sneed ze in draden, om die te verwerken tussen het blauwpurper, het roodpurper, het scharlaken en het fijn linnen: kunstig werk. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Verbonden schouderstukken maakten zij ervoor, aan de beide einden was de efod verbonden; ");
INSERT INTO nldnbg_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","en de gordel om hem aan te binden, die daarmee één geheel vormde, was op dezelfde wijze vervaardigd: van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Zij bewerkten de chrysopraasstenen, ingevat in gouden kassen, gegraveerd als zegelgraveerwerk, met de namen der zonen van Israël. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Hij zette ze op de schouderstukken van de efod als gedachtenisstenen voor de Israëlieten, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","En hij maakte het borstschild, kunstig werk, op dezelfde wijze als de efod: van goud, blauwpurper, roodpurper, scharlaken en getweernd fijn linnen. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Vierkant was het; dubbel maakten zij het borstschild, een span lang en een span breed, dubbel. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Zij vulden het met vier rijen stenen: een rij rode jaspis, chrysoliet en malachiet, de eerste rij; ");
INSERT INTO nldnbg_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","de tweede rij: hematiet, lazuursteen en prasem; ");
INSERT INTO nldnbg_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","de derde rij: barnsteen, agaat en amethist; ");
INSERT INTO nldnbg_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","de vierde rij: turkoois, chrysopraas en nefriet. In gouden kassen waren zij ingevat in hun zettingen. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","De stenen overeenkomstig de namen der zonen van Israël, waren twaalf in getal, overeenkomstig hun namen; als zegelgraveerwerk waren zij, elk met zijn naam, voor de twaalf stammen. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Zij maakten op het borstschild gedraaide kettinkjes, vlechtwerk van louter goud. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Zij maakten twee gouden kassen en twee gouden ringen en zetten de beide ringen aan de beide einden van het borstschild. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Zij deden de beide gevlochten kettinkjes van goud in de beide ringen aan de einden van het borstschild. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","De beide andere einden der beide gevlochten kettinkjes maakten zij aan de beide kassen vast en zetten ze op de schouderstukken van de efod, aan de voorkant. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Zij maakten twee gouden ringen en zetten ze aan de beide einden van het borstschild, op de binnenrand, die naar de efod was toegekeerd. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ook maakten zij twee gouden ringen en zetten die op de beide schouderstukken van de efod, onderaan aan de voorkant, dicht bij de plaats waar hij verbonden was, boven de gordel van de efod. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Zij bonden het borstschild met zijn ringen aan de ringen van de efod vast met een blauwpurperen snoer, zodat het op de gordel van de efod vastzat, en het borstschild niet van de efod kon afschuiven – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","En hij maakte het opperkleed van de efod, weefwerk, geheel blauwpurper. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","De opening van het opperkleed was in het midden ervan als bij een pantser, rondom die opening was een rand, opdat het niet scheurde. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Zij zetten op de zomen van het opperkleed granaatappels in blauwpurper, roodpurper en scharlaken, getweernd. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Zij maakten belletjes van louter goud en zetten de belletjes tussen de granaatappels op de zomen van het opperkleed, overal tussen de granaatappels: ");
INSERT INTO nldnbg_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","telkens een belletje en een granaatappel, rondom op de zomen van het opperkleed voor de dienst – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","En zij maakten de onderklederen van fijn linnen, weefwerk, voor Aäron en zijn zonen, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","de tulband van fijn linnen, de sierlijke hoofddoeken van fijn linnen, de linnen broeken van getweernd fijn linnen, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","en de gordel van getweernd fijn linnen, blauwpurper, roodpurper en scharlaken: veelkleurig weefwerk – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Zij maakten een plaat, de heilige diadeem, van louter goud, en schreven daarin een inschrift, zegelgraveerwerk: Den Here heilig. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Zij zetten er een blauwpurperen snoer aan om ze op de tulband vast te maken – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Toen was alle arbeid aan de tabernakel, de tent der samenkomst, voltooid, en de Israëlieten hadden het werk verricht overeenkomstig alles wat de Here Mozes geboden had, zó hadden zij het verricht. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","En zij brachten de tabernakel tot Mozes, de tent met al haar gerei, de haken, planken, dwarsbalken, pilaren met hun voetstukken, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","het dekkleed van roodgeverfde ramsvellen, het dekkleed van tachasvellen, het voorhangsel ter bedekking, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","de ark der getuigenis met de draagstokken en het verzoendeksel, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","de tafel, al haar gerei en het toonbrood, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","de kandelaar van louter goud, zijn lampen – de lampen die men daarop hun plaats geven moest – en al zijn gerei, de olie voor het licht, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","het gouden altaar, de zalfolie, het welriekend reukwerk, het gordijn voor de ingang der tent, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","het koperen altaar met het bijbehorend koperen traliewerk, de draagstokken en al zijn gerei, het wasvat met zijn voetstuk, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","de gordijnen van de voorhof, zijn pilaren en zijn voetstukken, en het gordijn voor de poort van de voorhof, zijn touwen en zijn pinnen, al het gerei voor de dienst van de tabernakel, de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","de ambtsklederen voor de dienst in het heiligdom, de heilige klederen voor de priester Aäron, en de klederen van zijn zonen, om het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Overeenkomstig alles, wat de Here Mozes geboden had, zó hadden de Israëlieten al de arbeid verricht. ");
INSERT INTO nldnbg_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","En Mozes zag al het werk, en zie, zij hadden het gemaakt zoals de Here geboden had; zó hadden zij het gemaakt. Toen zegende Mozes hen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Op de eerste dag van de eerste maand zult gij de tabernakel, de tent der samenkomst, oprichten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Gij zult daarin de ark der getuigenis plaatsen en gij zult de ark door het voorhangsel aan het oog onttrekken. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Gij zult de tafel brengen en schikken wat erop behoort; gij zult de kandelaar brengen en zijn lampen erop zetten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Gij zult het gouden altaar voor het reukwerk vóór de ark der getuigenis zetten. Gij zult het gordijn voor de ingang van de tabernakel ophangen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Gij zult het brandofferaltaar vóór de ingang van de tabernakel, de tent der samenkomst, zetten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Gij zult het wasvat tussen de tent der samenkomst en het altaar zetten en er water in doen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Gij zult de voorhof rondom uitzetten en het gordijn voor de poort van de voorhof ophangen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Dan zult gij de zalfolie nemen en de tabernakel met al wat daarin is, zalven; zo zult gij hem heiligen met al zijn gerei, en hij zal heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ook zult gij het brandofferaltaar zalven met al zijn gerei; zo zult gij het heiligen, en het altaar zal allerheiligst zijn. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ook zult gij het wasvat met zijn voetstuk zalven en het heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Dan zult gij Aäron en zijn zonen doen naderen tot de ingang van de tent der samenkomst en gij zult hen met water wassen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Gij zult Aäron met de heilige klederen bekleden, hem zalven en heiligen, om voor Mij het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ook zijn zonen zult gij doen naderen en hen met onderklederen kleden. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Gij zult hen zalven, zoals gij hun vader gezalfd hebt, om voor Mij het priesterambt te bekleden; en dit geschiedt, opdat hun zalving voor hen tot een altoosdurend priesterschap zij in hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","En Mozes deed dit; overeenkomstig alles wat de Here hem geboden had, zó deed hij. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Het geschiedde in de eerste maand in het tweede jaar op de eerste der maand, dat de tabernakel werd opgericht. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mozes richtte de tabernakel op, plaatste de voetstukken, stelde de planken, bracht dwarsbalken aan en richtte de pilaren op. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Hij breidde de tent over de tabernakel uit en legde het dekkleed der tent er overheen – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Hij nam de getuigenis en legde die in de ark, hij schoof de draagstokken aan de ark en legde het verzoendeksel bovenop de ark. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hij bracht de ark naar de tabernakel, hing het voorhangsel ter bedekking op en onttrok de ark der getuigenis aan het oog – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Hij zette de tafel in de tent der samenkomst aan de noordzijde van de tabernakel, buiten het voorhangsel. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Hij schikte daarop het brood voor het aangezicht des Heren – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hij plaatste de kandelaar in de tent der samenkomst tegenover de tafel, aan de zuidzijde van de tabernakel. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Hij zette de lampen erop voor het aangezicht des Heren – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Hij zette het gouden altaar in de tent der samenkomst vóór het voorhangsel. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Hij ontstak daarop welriekend reukwerk – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hij hing het gordijn voor de ingang van de tabernakel op. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Het brandofferaltaar zette hij bij de ingang van de tabernakel, de tent der samenkomst, en hij offerde daarop het brandoffer en het spijsoffer – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Hij zette het wasvat tussen de tent der samenkomst en het altaar en hij deed er water in voor de afwassingen. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mozes en Aäron en diens zonen wiesen daarmee hun handen en hun voeten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Wanneer zij kwamen in de tent der samenkomst en wanneer zij naderden tot het altaar, wiesen zij zich – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Hij richtte de voorhof op rondom de tabernakel en het altaar, en hij hing het gordijn voor de poort van de voorhof op. Zo voleindigde Mozes het werk. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","En de wolk bedekte de tent der samenkomst, en de heerlijkheid des Heren vervulde de tabernakel, ");
INSERT INTO nldnbg_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","zodat Mozes de tent der samenkomst niet kon binnengaan, want de wolk rustte daarop, en de heerlijkheid des Heren vervulde de tabernakel. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Wanneer de wolk zich verhief van boven de tabernakel, braken de Israëlieten op, op al hun tochten. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Maar indien de wolk zich niet verhief, dan braken zij niet op tot de dag, dat zij zich verhief. ");
INSERT INTO nldnbg_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Want op de tabernakel rustte des daags de wolk des Heren, en des nachts was er een vuur in voor de ogen van het gehele huis Israël, op al zijn tochten. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","De Here nu riep Mozes en sprak tot hem uit de tent der samenkomst: ");
INSERT INTO nldnbg_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Spreek tot de Israëlieten en zeg tot hen: Wanneer iemand onder u de Here een offergave brengen wil, dan zult gij uw offergave brengen van het vee, zowel van het rundvee als van het kleinvee. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Indien zijn offergave een brandoffer van rundvee is, dan zal hij een gaaf dier van het mannelijk geslacht brengen. Naar de ingang van de tent der samenkomst zal hij het brengen, opdat hij welgevallig zij voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Dan zal hij zijn hand op de kop van het brandoffer leggen; zo zal het, hem ten goede, welgevallig zijn, om over hem verzoening te doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Vervolgens zal hij het rund voor het aangezicht des Heren slachten, en de zonen van Aäron, de priesters, zullen het bloed brengen en dat sprengen rondom op het altaar, dat bij de ingang van de tent der samenkomst staat. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Daarna zal hij het brandoffer de huid aftrekken en het in stukken verdelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Dan zullen de zonen van de priester Aäron vuur op het altaar leggen en stukken hout op het vuur schikken. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","En de zonen van Aäron, de priesters, zullen de delen, de kop en het vet, schikken op het hout dat op het vuur op het altaar ligt. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","En de ingewanden en de onderschenkels ervan zal men met water wassen, en de priester zal alles op het altaar in rook doen opgaan als een brandoffer, een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Indien zijn offergave een brandoffer van kleinvee is, van schapen of van geiten, dan zal hij een gaaf dier van het mannelijk geslacht brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Hij zal het aan de noordzijde van het altaar slachten voor het aangezicht des Heren; de zonen van Aäron, de priesters, zullen het bloed rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Dan zal hij het in stukken verdelen, en de priester zal die, met de kop en het vet, schikken op het hout dat op het vuur op het altaar ligt. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","De ingewanden en onderschenkels zal hij met water wassen en de priester zal alles brengen en het in rook doen opgaan op het altaar; het is een brandoffer, een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Indien zijn offergave voor de Here een brandoffer van gevogelte is, dan zal hij zijn offergave brengen van tortelduiven of van jonge duiven. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","De priester zal die op het altaar brengen en de kop afknijpen en ze op het altaar in rook doen opgaan; en het bloed zal tegen de zijde van het altaar worden uitgedrukt. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Hij zal de krop met de spijsresten erin verwijderen en die naast het altaar aan de oostzijde op de asbelt werpen. ");
INSERT INTO nldnbg_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","En hij zal ze bij de vleugels inscheuren, zonder deze eraf te trekken, en de priester zal ze in rook doen opgaan op het altaar, op het hout dat op het vuur ligt; het is een brandoffer, een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Wanneer iemand de Here een offergave van spijsoffer brengen wil, dan zal zijn offergave bestaan uit fijn meel, en hij zal olie daarop gieten en wierook daarbij doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","En hij zal het tot de zonen van Aäron, de priesters, brengen; hij zal een handvol fijn meel en olie daarvan nemen met al de daarbij behorende wierook, en de priester zal dat als gedenkoffer op het altaar in rook doen opgaan, als een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","En wat overblijft van het spijsoffer, is voor Aäron en zijn zonen, als het allerheiligste van de vuuroffers des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Wanneer gij als offergave van spijsoffer een baksel uit de oven zult brengen, dan zal het uit fijn meel bestaan: ongezuurde koeken, met olie aangemaakt, en ongezuurde, dunne koeken, met olie bestreken. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Indien uw offergave een spijsoffer van de bakplaat is, dan zal het van fijn meel, aangemaakt met olie, en ongezuurd zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Men zal het in stukken breken en gij zult olie daarop gieten; het is een spijsoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Indien uw offergave een spijsoffer uit de pan is, dan zal het van fijn meel met olie bereid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","En gij zult het spijsoffer, dat hieruit bereid is, de Here brengen; men zal het tot de priester brengen en deze zal het naar het altaar dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","En de priester zal het gedenkoffer van het spijsoffer opheffen en het op het altaar in rook doen opgaan, als een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","En wat overblijft van het spijsoffer, is voor Aäron en zijn zonen, als het allerheiligste van de vuuroffers des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Geen spijsoffer, dat gij de Here brengt, zal gezuurd bereid worden, want van zuurdeeg noch honig zult gij iets als een vuuroffer voor de Here in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Als offergave der eerstelingen zult gij ze de Here brengen, maar zij zullen niet tot een liefelijke reuk op het altaar komen. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","En elke offergave van uw spijsoffer zult gij zouten, gij zult het zout van het verbond uws Gods aan uw spijsoffer niet laten ontbreken; bij al uw offergaven zult gij zout voegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Indien gij de Here een spijsoffer der eerste vruchten zult brengen, dan zult gij in het vuur geroosterde aren, fijngewreven graankorrels, als spijsoffer uwer eerste vruchten brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Gij zult daar olie bij doen en wierook daarop leggen; het is een spijsoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","En de priester zal een deel van het fijngewrevene en van de olie, met al de daarbij behorende wierook, als gedenkoffer in rook doen opgaan, als een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Indien zijn offergave een vredeoffer is: indien hij dat brengt van rundvee, dan zal hij een gaaf dier, hetzij van het mannelijk, hetzij van het vrouwelijk geslacht, voor het aangezicht des Heren brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Hij zal zijn hand op de kop van zijn offergave leggen en die slachten bij de ingang van de tent der samenkomst, en de zonen van Aäron, de priesters, zullen het bloed rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","En als vuuroffer voor de Here zal hij van het vredeoffer brengen het vet dat de ingewanden bedekt, en al het vet dat op de ingewanden ligt; ");
INSERT INTO nldnbg_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","benevens de beide nieren en het vet dat daaraan zit, dat aan de lenden is, en het aanhangsel aan de lever, dat hij met de nieren moet wegnemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","En de zonen van Aäron zullen het op het altaar in rook doen opgaan, op het brandoffer, dat op het hout op het vuur ligt, als een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Indien zijn offergave een stuk kleinvee is als vredeoffer voor de Here, dan zal hij een gaaf dier, hetzij van het mannelijk, hetzij van het vrouwelijk geslacht, brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Indien hij een schaap als zijn offergave brengt, dan zal hij het voor het aangezicht des Heren brengen, ");
INSERT INTO nldnbg_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","en zijn hand op de kop van zijn offergave leggen en die slachten voor de tent der samenkomst, en de zonen van Aäron zullen het bloed daarvan rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Van het vredeoffer zal hij het vet brengen als vuuroffer voor de Here: de gehele vetstaart, die hij dicht bij de ruggegraat moet afsnijden, het vet dat de ingewanden bedekt, en al het vet dat op de ingewanden ligt. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ook de beide nieren en het vet dat daaraan zit, dat aan de lenden is, en het aanhangsel aan de lever, dat hij met de nieren moet wegnemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","En de priester zal het in rook doen opgaan op het altaar, als een spijs ten vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Indien zijn offergave een geit is, dan zal hij (het dier) brengen voor het aangezicht des Heren, ");
INSERT INTO nldnbg_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","hij zal zijn hand leggen op zijn kop, het slachten voor de tent der samenkomst, en de zonen van Aäron zullen het bloed daarvan rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Dan zal hij daarvan zijn offergave als vuuroffer voor de Here brengen: het vet dat de ingewanden bedekt, en al het vet dat op de ingewanden ligt; ");
INSERT INTO nldnbg_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ook de beide nieren en het vet dat daaraan zit, dat aan de lenden is, en het aanhangsel aan de lever, dat hij met de nieren moet wegnemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","En de priester zal het in rook doen opgaan op het altaar als een spijs ten vuuroffer, tot een liefelijke reuk; al het vet is voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Dit zij een altoosdurende inzetting voor uw geslachten in al uw woonplaatsen: gij zult volstrekt geen vet en geen bloed eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Spreek tot de Israëlieten: Wanneer iemand zonder opzet zondigt in een van de dingen die de Here verboden heeft te doen, en één daarvan doet – ");
INSERT INTO nldnbg_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","dan zal, indien de gezalfde priester zonde gedaan en daardoor het volk in schuld gebracht heeft, hij voor de zonde die hij begaan heeft, een jonge, gave stier de Here tot een zondoffer brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Hij zal de stier naar de ingang van de tent der samenkomst brengen voor het aangezicht des Heren, zijn hand op de kop van de stier leggen en de stier slachten voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","De gezalfde priester zal een deel van het bloed van de stier nemen en dat brengen naar de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","De priester zal zijn vinger in het bloed dopen en van het bloed zevenmaal sprenkelen voor het aangezicht des Heren, vóór het voorhangsel van het heiligdom. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","En de priester zal van het bloed strijken aan de horens van het reukaltaar, dat voor het aangezicht des Heren staat in de tent der samenkomst; al het (overige) bloed van de stier zal hij uitgieten aan de voet van het brandofferaltaar, dat bij de ingang van de tent der samenkomst staat. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","En al het vet van de stier van het zondoffer zal hij eruit nemen: het vet dat de ingewanden bedekt, en al het vet dat op de ingewanden ligt; ");
INSERT INTO nldnbg_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","en de beide nieren en het vet dat daaraan zit, dat aan de lenden zit, en het aanhangsel aan de lever, dat hij met de nieren moet wegnemen, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","zoals het weggenomen wordt van het rund van het vredeoffer; en de priester zal het in rook doen opgaan op het brandofferaltaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","En de huid van de stier en al zijn vlees, benevens zijn kop en zijn onderschenkels en zijn ingewanden en zijn mest, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","alles van de stier zal hij buiten de legerplaats brengen, op een reine plek, waar men de as stort, en hij zal hem op een houtvuur verbranden; op de plaats waar de as wordt uitgestort, zal hij verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Indien de gehele vergadering Israëls zonder opzet zonde gedaan heeft, en dit voor de ogen der gemeente verborgen is gebleven, en zij tegen één van al de geboden des Heren iets gedaan heeft, dat niet gedaan mocht worden, en dus schuldig geworden is, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","dan zal de gemeente, wanneer de zonde die zij begaan heeft, haar bekend geworden is, een jonge stier ten zondoffer brengen en zij zal die leiden vóór de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","En de oudsten der vergadering zullen hun handen op de kop van de stier leggen voor het aangezicht des Heren, en men zal de stier voor het aangezicht des Heren slachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","De gezalfde priester zal een deel van het bloed van de stier in de tent der samenkomst brengen, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","en die priester zal zijn vinger in het bloed dopen en zevenmaal voor het aangezicht des Heren vóór het voorhangsel sprenkelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","En een deel van het bloed zal hij strijken aan de horens van het altaar, dat voor het aangezicht des Heren in de tent der samenkomst staat; al het overige bloed zal hij uitgieten aan de voet van het brandofferaltaar, dat bij de ingang van de tent der samenkomst staat. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","En al het vet zal hij eruit nemen en op het altaar in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","En met de stier zal hij doen, zoals hij met de stier van het zondoffer gedaan heeft, zó zal hij daarmee doen. Zo zal de priester over hen verzoening doen, en het zal hun vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","En hij zal de stier buiten de legerplaats brengen en hem verbranden, zoals hij de eerste stier verbrand heeft. Dit is het zondoffer der gemeente. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Als een vorst gezondigd heeft en zonder opzet tegen één van al de geboden van de Here, zijn God, iets gedaan heeft dat niet gedaan mocht worden, en dus schuldig geworden is, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","dan zal hij, als hem de zonde die hij begaan heeft, bekend geworden is, als zijn offergave een geitebok brengen, een gaaf dier van het mannelijk geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Hij zal zijn hand op de kop van de bok leggen en hem slachten op de plaats waar men ook het brandoffer voor het aangezicht des Heren pleegt te slachten; een zondoffer is het. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","En de priester zal met zijn vinger een deel van het bloed van het zondoffer nemen en dat strijken aan de horens van het brandofferaltaar; het overige bloed zal hij aan de voet van het brandofferaltaar uitgieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Maar al het vet zal hij op het altaar in rook doen opgaan, zoals het vet van het vredeoffer. Zo zal de priester over hem verzoening doen voor zijn zonde, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Indien iemand uit het volk des lands zonder opzet gezondigd heeft door een van de dingen te doen, die de Here verboden heeft, en dus schuldig geworden is, ");
INSERT INTO nldnbg_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","dan zal hij, als hem de zonde die hij begaan heeft, bekend geworden is, voor de zonde die hij begaan heeft, als zijn offergave een geit, een gaaf dier van het vrouwelijk geslacht, brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Hij zal zijn hand op de kop van het zondoffer leggen en het zondoffer slachten op de plaats van het brandoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","En de priester zal met zijn vinger een deel van het bloed nemen en het strijken aan de horens van het brandofferaltaar; al het overige bloed zal hij aan de voet van het altaar uitgieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Maar al het vet ervan zal hij wegnemen, zoals het vet bij het vredeoffer weggenomen wordt, en de priester zal het op het altaar in rook doen opgaan, tot een liefelijke reuk voor de Here. Zo zal de priester over hem verzoening doen, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Indien hij een schaap brengt als zijn offergave ten zondoffer, dan zal hij een gaaf dier van het vrouwelijk geslacht brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Hij zal zijn hand op de kop van het zondoffer leggen en het slachten ten zondoffer op de plaats waar men het brandoffer pleegt te slachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","En de priester zal met zijn vinger een deel van het bloed van het zondoffer nemen en het strijken aan de horens van het brandofferaltaar; al het overige bloed zal hij aan de voet van het altaar uitgieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Maar al het vet ervan zal hij wegnemen, zoals het vet van het schaap van het vredeoffer weggenomen wordt, en de priester zal het op het altaar in rook doen opgaan op de vuuroffers des Heren. Zo zal de priester over hem verzoening doen voor de zonde die hij begaan heeft, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Wanneer iemand zondigt, in geval hij een overluid gesproken vervloeking hoort en getuige is, hetzij hij het zelf gehoord heeft of het te weten gekomen is, dan draagt hij, indien hij het niet aanbrengt, zijn ongerechtigheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Of als iemand iets onreins aanraakt, hetzij het aas van een onrein wild dier, of van een onrein stuk vee, of van een onrein kruipend dier, zonder er zich van bewust te zijn, dan is hij onrein en schuldig. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Of wanneer hij de onreinheid van een mens aanraakt, door welke onreinheid hij ook maar onrein geworden is, zonder er zich van bewust te zijn, en hij bemerkt het, dan is hij schuldig. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Of wanneer iemand onbezonnen een eed uitspreekt, om iets te doen, hetzij kwaad, hetzij goed, hoe een mens ook maar in een eed onbezonnen spreken kan, zonder er zich van bewust te zijn, en hij bemerkt het, dan is hij schuldig aan een van deze dingen. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Wanneer hij nu aan een van deze dingen schuldig is, dan zal hij belijden, waarin hij gezondigd heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","en aan de Here als boete voor de zonde die hij begaan heeft, een dier van het vrouwelijk geslacht uit het kleinvee, een schaap of een geit, ten zondoffer brengen; zo zal de priester over hem voor zijn zonde verzoening doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Maar indien zijn draagkracht ontoereikend is voor een stuk kleinvee, dan zal hij als boete voor de zonde die hij gedaan heeft, twee tortelduiven of twee jonge duiven de Here brengen, een ten zondoffer en een ten brandoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Hij zal ze tot de priester brengen, en deze zal het eerst offeren die, welke ten zondoffer bestemd is. En hij zal haar kop van haar nek afknijpen, maar die niet afscheiden. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Hij zal van het bloed van het zondoffer tegen de zijde van het altaar sprenkelen, maar wat van het bloed overblijft zal aan de voet van het altaar uitgedrukt worden; het is een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","En de tweede zal hij als brandoffer bereiden, volgens het voorschrift. Zo zal de priester verzoening over hem doen voor de zonde die hij begaan heeft, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Indien echter zijn draagkracht ontoereikend is voor twee tortelduiven of twee jonge duiven, dan zal hij als offergave voor de zonde die hij gedaan heeft, een tiende efa fijn meel ten zondoffer brengen. Hij zal er geen olie op gieten en er geen wierook bijvoegen, want het is een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Hij zal het tot de priester brengen, en de priester zal daarvan een handvol nemen als gedenkoffer en op het altaar in rook doen opgaan op de vuuroffers des Heren; het is een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Zo zal de priester verzoening over hem doen voor de zonde die hij in een van deze dingen begaan heeft, en het zal hem vergeven worden. En het zal, evenals het spijsoffer, voor de priester zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wanneer iemand ontrouw wordt en zonder opzet zonde doet tegen iets van wat de Here geheiligd is, dan zal hij, als zijn boete, de Here een gave ram van het kleinvee brengen ten schuldoffer, de waarde geschat in zilveren sikkels, naar de heilige sikkel. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","En het heilige waartegen hij gezondigd heeft, zal hij vergoeden en daaraan een vijfde toevoegen: hij zal het aan de priester geven, en de priester zal over hem verzoening doen met de ram van het schuldoffer, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Indien iemand zondigt en doet één van de dingen die de Here verboden heeft, zonder dat hij het weet, dan is hij toch schuldig en draagt zijn ongerechtigheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Hij zal een gave ram van het kleinvee, in waarde geschat, ten schuldoffer tot de priester brengen, en de priester zal verzoening over hem doen voor wat hij zonder opzet gedaan heeft, zonder dat hij het wist, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Het is een schuldoffer; hij heeft de Here zijn schuld volkomen geboet. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Wanneer iemand zonde doet en ontrouw wordt jegens de Here, en tegenover zijn volksgenoot ontkent, dat hij iets in bewaring heeft, of dat hem iets is ter hand gesteld, of dat hij iets weggeroofd heeft; ");
INSERT INTO nldnbg_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","of hij heeft zijn volksgenoot iets afgeperst, of hij heeft iets dat verloren was, gevonden en hij ontkent het, en doet een valse eed ten opzichte van enige zaak die een mens doen kan, zodat hij zich daaraan bezondigt, ");
INSERT INTO nldnbg_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","wanneer hij zo zonde doet en schuldig wordt, dan zal hij teruggeven het geroofde dat hij wegroofde, of het afgeperste dat hij afperste, of het in bewaring gegevene dat hem in bewaring gegeven was, of het verlorene dat hij gevonden had, ");
INSERT INTO nldnbg_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","of alles, ten opzichte waarvan hij een valse eed zwoer. Hij zal de volle waarde ervan vergoeden en nog een vijfde daaraan toevoegen; aan degene wie het behoorde, die zal hij het geven, op de dag wanneer hij zijn schuldoffer brengt. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Als zijn schuldoffer zal hij voor de Here brengen een gave ram uit het kleinvee, in waarde geschat, ten schuldoffer tot de priester. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","En de priester zal over hem verzoening doen voor het aangezicht des Heren, en hem zal vergeving geschonken worden, ten aanzien van elke zaak waardoor hij schuld op zich laadt. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Gebied Aäron en zijn zonen het volgende: Dit is de wet op het brandoffer. Het brandoffer zal op de vuurhaard op het altaar de ganse nacht tot de morgen blijven liggen, en het vuur van het altaar zal daarop blijven branden. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","En de priester zal zijn linnen kleed aandoen en een linnen broek over zijn lichaam aantrekken; dan zal hij de as wegnemen, waartoe het vuur het brandoffer op het altaar verteerd heeft, en hij zal die naast het altaar storten. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Daarna zal hij zijn klederen uitdoen en andere klederen aantrekken, en de as zal hij brengen buiten de legerplaats, op een reine plaats. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","En het vuur op het altaar zal brandende gehouden worden, het mag niet uitgaan. Daarop zal de priester elke morgen hout aansteken, het brandoffer erop schikken en daarop de vetstukken van het vredeoffer in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Een vuur zal voortdurend brandende gehouden worden op het altaar, het mag niet uitgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Dit is de wet op het spijsoffer. De zonen van Aäron zullen het voor het aangezicht des Heren voor het altaar brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","En een zal daarvan een handvol nemen, van het fijn meel van het spijsoffer en van de olie daarvan, en al de wierook die op het spijsoffer ligt, en zo zal hij dit op het altaar in rook doen opgaan, tot een liefelijke reuk ten gedenkoffer daarvan voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Wat daarvan overblijft, zullen Aäron en zijn zonen eten: als ongezuurde koeken zal het gegeten worden op een heilige plaats; in de voorhof van de tent der samenkomst zullen zij het eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Het zal ongezuurd gebakken worden; als hun aandeel aan mijn vuuroffers heb Ik het gegeven; het is allerheiligst, evenals het zondoffer en het schuldoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Allen die van het mannelijk geslacht zijn onder de nakomelingen van Aäron, zullen het eten; dit zij een altoosdurende inzetting voor uw geslachten ten aanzien van de vuuroffers des Heren; al wie het aanraakt, zal heilig worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Dit is de offergave, die Aäron en zijn zonen de Here zullen brengen op de dag, dat hij gezalfd wordt: een tiende efa fijn meel als een dagelijks spijsoffer, de helft des morgens en de helft des avonds. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Het zal op een bakplaat in olie bereid worden, gij zult het doorgeroerd brengen, als een spijsoffer, aan brokken zult gij het offeren, tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","En de priester, die uit zijn zonen in zijn plaats de gezalfde zal zijn, zal dit doen; het is een altoosdurende inzetting, het zal geheel voor de Here verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Elk spijsoffer van een priester zal geheel verbrand worden, het zal niet worden gegeten. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Spreek tot Aäron en zijn zonen: Dit is de wet op het zondoffer: ter plaatse waar het brandoffer geslacht wordt, zal ook het zondoffer geslacht worden voor het aangezicht des Heren, het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","De priester die het als zondoffer offert, zal het eten; op een heilige plaats zal het gegeten worden, in de voorhof van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Al wat met het vlees daarvan in aanraking komt, zal heilig zijn, en als iets van het bloed ervan op een kledingstuk spat, zult gij hetgeen waarop het spatte, op een heilige plaats wassen. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","En het aarden vat waarin het gekookt is, zal stukgeslagen worden, en indien het in een koperen vat gekookt is, dan zal dit geschuurd en met water gespoeld worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Allen die van het mannelijk geslacht zijn onder de priesters, zullen het eten, het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Maar geen zondoffer, van welks bloed in de tent der samenkomst gebracht werd om in het heiligdom verzoening te doen, zal gegeten worden; met vuur zal het verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Dit is de wet op het schuldoffer: het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ter plaatse waar men het brandoffer slacht, zal men het schuldoffer slachten; en het bloed daarvan zal men rondom op het altaar sprengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Al het vet daarvan zal men offeren, de vetstaart en het vet dat de ingewanden bedekt. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ook de beide nieren en het vet dat daaraan zit, dat aan de lenden is, en het aanhangsel aan de lever, dat hij met de nieren moet wegnemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","De priester zal dit op het altaar in rook doen opgaan als een vuuroffer voor de Here; het is een schuldoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Allen die van het mannelijk geslacht zijn onder de priesters, zullen het eten; op een heilige plaats zal het gegeten worden; het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wat voor het schuldoffer geldt, geldt ook voor het zondoffer; een zelfde wet geldt daarvoor: het zal zijn voor de priester die daardoor verzoening doet. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","En de priester die iemands brandoffer brengt – de huid van het brandoffer dat hij brengt, zal voor die priester zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Elk spijsoffer dat gebakken wordt in de oven, en al wat bereid is in de pan en op de bakplaat, is voor de priester die het brengt, voor hem zal het zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Elk spijsoffer dat met olie aangemaakt of droog is, zal voor alle zonen van Aäron zijn, voor de een zowel als voor de ander. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Dit is de wet op het vredeoffer, dat men de Here brengen zal. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Indien men het zal brengen als een lofoffer, dan zal men met het lofoffer ongezuurde koeken brengen, met olie aangemaakt, en ongezuurde dunne koeken, met olie bestreken, en doorgeroerd fijn meel, koeken met olie aangemaakt. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Met koeken van gezuurd brood zal hij zijn offergave brengen, nevens zijn vredeoffer als lofoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","En van elke offergave zal hij er een brengen als heffing aan de Here; voor de priester die het bloed van het vredeoffer sprengt, zal die zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","En het vlees van zijn vredeoffer als lofoffer zal op de dag van zijn offergave gegeten worden; niets daarvan zal hij tot de morgen over laten. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Indien het slachtoffer dat hij als offergave brengt, een gelofteoffer of een vrijwillig offer is, dan zal het op de dag waarop hij zijn slachtoffer brengt, gegeten worden, en op de volgende dag zal ook hetgeen daarvan overbleef, gegeten worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Maar wat dan nog van het vlees van het slachtoffer overblijft, zal op de derde dag met vuur worden verbrand. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Indien toch op de derde dag gegeten wordt van het vlees van zijn vredeoffer, dan zal hij die dat gebracht heeft, niet welgevallig zijn; het zal hem niet ten goede gerekend worden, het zal iets verfoeilijks zijn, en wie daarvan eet, zal zijn ongerechtigheid dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","En vlees dat met iets onreins in aanraking komt, zal niet gegeten worden, het zal met vuur verbrand worden; wat overigens het vlees betreft, ieder die rein is, mag vlees eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Maar iemand die, terwijl onreinheid hem aankleeft, vlees eet van het vredeoffer dat de Here toebehoort, die zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","En wanneer iemand iets onreins aanraakt, onreinheid van mensen of onreine dieren of enig onrein kruipend gedierte, en eet van het vlees van het vredeoffer dat de Here toebehoort, dan zal hij uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Spreek tot de Israëlieten: Gij zult in het geheel geen vet van rund, schaap of geit eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Het vet van een gestorven of verscheurd dier mag voor allerlei doeleinden gebruikt worden, maar eten zult gij het in geen geval. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Want ieder die vet eet van het vee, waarvan men een vuuroffer voor de Here brengt, – wie dat eet, zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ook zult gij in al uw woonplaatsen in het geheel geen bloed eten, van gevogelte noch van vee. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Alwie enig bloed eet, die zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Spreek tot de Israëlieten: Hij die de Here zijn vredeoffer offert, moet de Here een deel van zijn vredeoffer als offergave brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Eigenhandig zal hij de vuuroffers des Heren brengen; het vet met de borst zal hij brengen, de borst, om die als beweegoffer te bewegen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","En de priester zal het vet in rook doen opgaan op het altaar, maar de borst zal voor Aäron en zijn zonen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","De rechterschenkel zult gij als een heffing van uw vredeoffers aan de priester geven. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Diegene van de zonen van Aäron, die het bloed van het vredeoffer en het vet offert, hem zal de rechterschenkel ten deel vallen. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Want de beweegborst en de hefschenkel neem Ik van de Israëlieten van hun vredeoffers en geef die aan de priester Aäron, en aan zijn zonen, als een altoosdurende inzetting voor de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dit is het gewijde deel van Aäron en zijn zonen in de vuuroffers des Heren, ten dage dat Hij hen deed naderen om als priester de Here te dienen, ");
INSERT INTO nldnbg_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","hetgeen de Here gebood hun te geven, ten dage dat Hij hen zalfde uit de Israëlieten, als een altoosdurende inzetting voor hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dit is de wet op het brandoffer, het spijsoffer, het zondoffer, het schuldoffer, het wijdingsoffer en het vredeoffer, ");
INSERT INTO nldnbg_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","die de Here Mozes gebood op de berg Sinai, ten dage dat Hij de Israëlieten gebood hun offers de Here te brengen, in de woestijn Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Neem Aäron en zijn zonen met hem, de klederen, de zalfolie, de stier van het zondoffer, de beide rammen en de korf met de ongezuurde broden, ");
INSERT INTO nldnbg_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","en roep de gehele vergadering samen bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","En Mozes deed, zoals de Here hem geboden had, en de vergadering werd samengeroepen bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Toen zeide Mozes tot de vergadering: Dit is het, wat de Here geboden heeft te doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","En Mozes deed Aäron en zijn zonen naderen en wies hen met water; ");
INSERT INTO nldnbg_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","daarna deed hij hem het onderkleed aan, omgordde hem met de gordel, bekleedde hem met het opperkleed, deed de efod daarover, omgordde hem met de band van de efod en bond hem die om. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Daarna deed hij hem het borstschild aan en legde in het borstschild de Urim en de Tummim. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Vervolgens zette hij hem de tulband op het hoofd en bevestigde vóór op de tulband de gouden plaat, de heilige diadeem, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Toen nam Mozes de zalfolie en zalfde de tabernakel en alles wat daarin was en heiligde dat. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ook sprenkelde hij daarvan op het altaar, zevenmaal, en zalfde het altaar met al zijn toebehoren, benevens het wasbekken en zijn voetstuk, om ze te heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Daarna goot hij van de zalfolie op het hoofd van Aäron, en hij zalfde hem om hem te heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","En Mozes deed de zonen van Aäron naderen, bekleedde hen met een onderkleed, omgordde hen met een gordel en bond hun hoofddoeken om, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Toen liet hij de stier van het zondoffer nader brengen, en Aäron en zijn zonen legden hun handen op de kop van de stier van het zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","En hij slachtte die, en Mozes nam het bloed en streek dat met zijn vinger rondom aan de horens van het altaar en ontzondigde het altaar; het overige bloed goot hij uit aan de voet van het altaar. Zo heiligde hij dit en deed daarover verzoening. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","En hij nam al het vet dat op de ingewanden ligt, het aanhangsel aan de lever, de beide nieren en het vet daaraan, en Mozes deed het in rook opgaan op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Maar de stier met zijn huid, zijn vlees en zijn mest verbrandde hij met vuur buiten de legerplaats, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Daarop bracht hij de ram van het brandoffer nader, en Aäron en zijn zonen legden hun handen op de kop van de ram, en hij slachtte die, ");
INSERT INTO nldnbg_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","en Mozes sprengde het bloed rondom tegen het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","De ram verdeelde hij in stukken, en Mozes deed de kop, de stukken en het vet in rook opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","De ingewanden echter en de onderschenkels wies hij met water, en Mozes deed de gehele ram op het altaar in rook opgaan; het was een brandoffer tot een liefelijke reuk, een vuuroffer was het voor de Here, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Nu bracht hij de tweede ram, de ram ter inwijding, nader, en Aäron en zijn zonen legden hun handen op de kop van de ram. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","En hij slachtte die, en Mozes nam een deel van het bloed en streek het aan Aärons rechter oorlel, aan zijn rechterduim en aan zijn rechter grote teen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","En hij deed de zonen van Aäron naderen en Mozes streek het bloed aan hun rechter oorlel en aan hun rechterduim en aan hun rechter grote teen, en Mozes sprengde het bloed rondom tegen het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","En hij nam het vet, de vetstaart, al het vet dat op de ingewanden ligt, het aanhangsel aan de lever, de beide nieren en het vet daaraan en de rechterschenkel. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","En uit de korf met ongezuurde broden, die voor het aangezicht des Heren stond, nam hij één ongezuurd brood, één geoliede broodkoek en één dunne koek, legde die op de vetdelen en op de rechterschenkel, ");
INSERT INTO nldnbg_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","en legde dat alles op de handen van Aäron en van zijn zonen en bewoog dat als een beweegoffer voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Daarna nam Mozes het van hen over en deed het op het altaar op het brandoffer in rook opgaan; het was een wijdingsoffer tot een liefelijke reuk; een vuuroffer was het voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","En Mozes nam de borst en bewoog die als beweegoffer voor het aangezicht des Heren; van de ram ter inwijding viel die Mozes ten deel, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Voorts nam Mozes een deel van de zalfolie en van het bloed, dat op het altaar was, en sprenkelde dat op Aäron, op zijn klederen en ook op zijn zonen en de klederen van zijn zonen; zo heiligde hij Aäron en zijn klederen en ook zijn zonen en de klederen van zijn zonen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","En Mozes zeide tot Aäron en zijn zonen: Kookt het vlees aan de ingang van de tent der samenkomst; daar zult gij het eten met het brood dat in de korf van de wijdingsoffers is, zoals ik geboden heb, dat Aäron en zijn zonen het zouden eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Wat nu van het vlees en het brood overblijft, zult gij met vuur verbranden. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","En van de ingang van de tent der samenkomst zult gij gedurende zeven dagen niet weggaan, tot de dag waarop de dagen uwer wijding vervuld zijn; want zeven dagen zal uw wijding duren. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Zoals men op deze dag gedaan heeft, zo heeft de Here geboden voortaan te handelen, om over u verzoening te doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Bij de ingang van de tent der samenkomst zult gij dag en nacht, zeven dagen lang, blijven en gij zult het u door de Here gegeven voorschrift in acht nemen, opdat gij niet sterft, want zo is mij geboden. ");
INSERT INTO nldnbg_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aäron en zijn zonen nu deden alles wat de Here door de dienst van Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Op de achtste dag riep Mozes Aäron, diens zonen en de oudsten van Israël en zeide tot Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Neem u een kalf, een jong rund, ten zondoffer, en een ram ten brandoffer, beide gaaf, en breng ze voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","En tot de Israëlieten zult gij spreken: Neemt een geitebok ten zondoffer, en ten brandoffer een kalf en een schaap, elk één jaar oud, en gaaf. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Daarbij een rund en een ram ten vredeoffer om ze voor het aangezicht des Heren te offeren, benevens een spijsoffer, met olie aangemaakt, want heden zal u de Here verschijnen. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Toen brachten zij hetgeen Mozes geboden had naar de tent der samenkomst, en de gehele vergadering naderde en stond voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","En Mozes zeide: Dit is het, wat de Here u geboden heeft te doen, opdat de heerlijkheid des Heren u verschijne. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Toen zeide Mozes tot Aäron: Nader tot het altaar en bereid uw zondoffer en uw brandoffer en doe verzoening voor u en voor het volk; bereid daarna de offergave des volks en doe voor hen verzoening, zoals de Here geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Toen naderde Aäron tot het altaar en slachtte het kalf dat voor hem ten zondoffer bestemd was. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","En de zonen van Aäron brachten hem het bloed en hij doopte zijn vinger in het bloed en streek dat aan de horens van het altaar; het bloed goot hij uit aan de voet van het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Maar het vet, de nieren en het aanhangsel aan de lever van het zondoffer deed hij in rook opgaan op het altaar, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Het vlees en de huid echter verbrandde hij met vuur buiten de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Daarop slachtte hij het brandoffer, en de zonen van Aäron reikten hem het bloed, en hij sprengde het rondom tegen het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ook het brandoffer reikten zij hem, in zijn stukken verdeeld, met de kop, en hij deed dit op het altaar in rook opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Hij wies de ingewanden en de onderschenkels en deed ze op het brandoffer in rook opgaan op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hierna offerde hij de offergave des volks; hij nam de bok van het zondoffer, die voor het volk bestemd was, slachtte die en bereidde hem ten zondoffer zoals het vorige. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Daarna offerde hij het brandoffer en deed daarmede volgens het voorschrift. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Vervolgens liet hij het spijsoffer brengen, nam er een handvol van en deed het in rook opgaan op het altaar, benevens het morgenbrandoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ook slachtte hij het rund en de ram, die als vredeoffer voor het volk bestemd waren, en de zonen van Aäron reikten hem het bloed, en hij sprengde het rondom tegen het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","De vetstukken van het rund echter, de vetstaart van de ram, benevens het vet dat de ingewanden bedekt, de nieren en het aanhangsel aan de lever, ");
INSERT INTO nldnbg_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","deze vetstukken legden zij op de borststukken, en hij deed deze vetstukken in rook opgaan op het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","En de borststukken en de rechterbovenschenkel bewoog Aäron als beweegoffer voor het aangezicht des Heren, zoals Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Toen hief Aäron zijn handen op over het volk en zegende het; daarna daalde hij af, nadat hij het zondoffer, het brandoffer en het vredeoffer gebracht had. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mozes nu en Aäron gingen in de tent der samenkomst, en toen zij er weer uitkwamen, zegenden zij het volk, en de heerlijkheid des Heren verscheen aan het gehele volk. ");
INSERT INTO nldnbg_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","En er ging vuur uit van de Here en dit verteerde op het altaar het brandoffer en de vetstukken; toen het volk dat zag, juichten allen en wierpen zich op hun aangezicht. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","En de zonen van Aäron, Nadab en Abihu, namen ieder zijn vuurpan, deden daar vuur in en legden daar reukwerk op; zo brachten zij vreemd vuur voor het aangezicht des Heren, hetgeen Hij hun niet geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Toen ging er vuur uit van de Here en dit verteerde hen, zodat zij stierven voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","En Mozes zeide tot Aäron: Dit is het, wat de Here gesproken heeft: aan degenen die Mij het naaste staan, zal Ik Mij de Heilige betonen en ten aanschouwen van het gehele volk zal Ik Mij verheerlijken. En Aäron zweeg. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Toen riep Mozes Misaël en Elsafan, de zonen van Uzziël, de oom van Aäron, en zeide tot hen: Nadert, draagt uw broeders van het heiligdom weg buiten de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Zij naderden en droegen hen in hun onderklederen weg buiten de legerplaats, zoals Mozes gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","En Mozes zeide tot Aäron en zijn zonen Eleazar en Itamar: Uw hoofdhaar zult gij niet los laten hangen en uw klederen zult gij niet scheuren, opdat gij niet sterft, en Hij niet toorne over de gehele vergadering; maar uw broeders, het gehele huis Israëls, zullen de brand bewenen, die de Here heeft doen ontbranden. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Van de ingang van de tent der samenkomst zult gij niet weggaan, opdat gij niet sterft, want de zalfolie des Heren is op u. En zij deden naar het woord van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","De Here sprak tot Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Wijn of bedwelmende drank zult gij niet drinken, gij noch uw zonen, wanneer gij de tent der samenkomst binnengaat, opdat gij niet sterft – het is een altoosdurende inzetting voor uw geslachten – ");
INSERT INTO nldnbg_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","opdat gij scheiding kunt maken tussen heilig en onheilig, tussen onrein en rein, ");
INSERT INTO nldnbg_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","en opdat gij de Israëlieten kunt onderwijzen in al de inzettingen die de Here door de dienst van Mozes tot hen gesproken heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","En Mozes sprak tot Aäron en Eleazar en Itamar, zijn overgebleven zonen: Neemt het spijsoffer dat overgebleven is van de vuuroffers des Heren, en eet het als ongezuurde broden naast het altaar, want het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Gij zult het eten op een heilige plaats, want het is uw deel en het deel uwer zonen in de vuuroffers des Heren; zó is mij geboden. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","De beweegborst en de hefschenkel zult gij op een reine plaats eten, gij met uw zonen en dochters; want dat is het deel van de vredeoffers der Israëlieten, dat aan u en uw kinderen gegeven is. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","De hefschenkel en de beweegborst zullen zij brengen bij de vuuroffers van de vetstukken, om die als een beweegoffer te bewegen voor het aangezicht des Heren. En het zal voor u en uw kinderen tot een altoosdurende inzetting zijn, zoals de Here geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","En Mozes zocht ijverig naar de bok van het zondoffer, maar zie, hij was verbrand. Toen werd hij toornig op Eleazar en Itamar, de overgebleven zonen van Aäron, en zeide: ");
INSERT INTO nldnbg_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Waarom hebt gij het zondoffer niet op de heilige plaats gegeten? Want het was allerheiligst, en Hij gaf u dit om de ongerechtigheid der vergadering weg te nemen en over hen verzoening te doen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Zie, het bloed daarvan is niet binnen in het heiligdom gebracht; gij hadt het immers in het heiligdom moeten eten, zoals ik geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Toen sprak Aäron tot Mozes: Zie, heden hebben zij hun zondoffer en hun brandoffer voor het aangezicht des Heren gebracht, en zulke dingen zijn mij overkomen; indien ik heden zondoffer gegeten had, zou dat goed geweest zijn in de ogen des Heren? ");
INSERT INTO nldnbg_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Toen Mozes dit hoorde, was het goed in zijn ogen. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","De Here sprak tot Mozes en Aäron en zeide tot hen: ");
INSERT INTO nldnbg_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Spreekt tot de Israëlieten: Dit zijn de dieren, die gij eten moogt van al het gedierte dat op de aarde is. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Al wat gespleten hoeven heeft, te weten geheel doorkloofde hoeven, en wat herkauwt onder de dieren moogt gij eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","De volgende echter zult gij niet eten van de dieren die herkauwen of gespleten hoeven hebben: de kameel, omdat die wel herkauwt, maar geen gespleten hoeven heeft; onrein zal die voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ook de klipdas, omdat die wel herkauwt, maar geen gespleten hoeven heeft; onrein zal die voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ook de haas, omdat die wel herkauwt, maar geen gespleten hoeven heeft; onrein zal die voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ook het zwijn, omdat het wel gespleten hoeven, ja zelfs geheel doorkloofde hoeven heeft, maar niet herkauwt; onrein zal het voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Van hun vlees zult gij niet eten en hun aas zult gij niet aanraken; onrein zullen die voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dit moogt gij eten van al wat in het water leeft: al wat vinnen en schubben heeft, in het water, in de zeeën en in de stromen, dat moogt gij eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Maar al wat geen vinnen of schubben heeft, in de zeeën en de stromen, onder al wat in het water wemelt en onder alle levende wezens die in het water zijn, dat zal u een gruwel wezen. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ja, een gruwel zullen zij u zijn; van hun vlees zult gij niet eten en hun aas zult gij verafschuwen. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alles in het water, dat geen vinnen of schubben heeft, dat zal u een gruwel zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Deze zult gij verafschuwen onder de vogels, – zij mogen niet gegeten worden, een gruwel zijn zij –: de arend, de lammergier en de zeearend, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","de wouw en alle soorten gieren, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","alle soorten raven, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","de struisvogel, de katuil en de meeuw en alle soorten sperwers, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","de steenuil, de aalscholver en de oehoe, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","de witte uil, de pelikaan, de aasgier ");
INSERT INTO nldnbg_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","en de ooievaar, alle soorten reigers, de hop en de vleermuis. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alle wemelend gedierte met vleugels, dat op vier poten gaat – dat zal u een gruwel zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Deze echter moogt gij eten van al het wemelend gedierte met vleugels, dat op vier poten gaat: die boven zijn voeten dijen heeft om daarmee over de grond te springen. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Deze moogt gij daarvan eten: alle soorten sprinkhanen, alle soorten treksprinkhanen, alle soorten veldsprinkhanen en alle soorten kleine treksprinkhanen. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Maar alle wemelend gedierte met vleugels, dat vier poten heeft, dat zal u een gruwel zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Aan deze verontreinigt gij u; ieder die hun aas aanraakt, zal onrein zijn tot de avond, ");
INSERT INTO nldnbg_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","en ieder die van hun aas opneemt, zal zijn klederen wassen en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Alle dieren die gespleten hoeven hebben, maar niet geheel doorkloofde hoeven, en die niet herkauwen, zullen u onrein zijn; ieder die ze aanraakt, zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ook alle zoolgangers onder al de viervoetige dieren zullen u onrein zijn: ieder die hun aas aanraakt, zal onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","En hij die hun aas opneemt, zal zijn klederen wassen en onrein zijn tot de avond; onrein zullen zij u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Dit zal u het onreine zijn onder het wemelend gedierte dat op de grond wemelt: de mol, de muis en alle soorten padden; ");
INSERT INTO nldnbg_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","en de egel, de waraan en de hagedis, de slak en het kameleon. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Deze zullen u onrein zijn onder al het wemelend gedierte. Ieder die ze aanraakt, als zij dood zijn, zal onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","En alles waarop zulk een dier valt, als het dood is, zal onrein zijn; elk houten vat of kledingstuk of vel of zak, elk gebruiksvoorwerp, zal in het water gelegd worden en onrein zijn tot de avond; dan zal het rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","En elk aarden vat, waarin zulk een dier valt – alles wat daarin is, zal onrein zijn, en gij zult het stuk breken. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Alle voedsel dat gegeten mag worden, waarop water komt, zal onrein zijn; en alle drank die gedronken mag worden, zal in al zulk vaatwerk onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","En alles waarop zulk aas valt, zal onrein zijn: de oven en de bakpan zullen gebroken worden, onrein zijn zij en onrein zullen zij u zijn; ");
INSERT INTO nldnbg_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","een bron echter of een put, een vergaarbak van water, zal rein zijn; maar die zulk aas aanraakt, zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","En wanneer zulk aas valt op enig zaaizaad dat uitgezaaid zal worden, dan zal dit rein blijven. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Maar wanneer water op dat zaad gedaan is en er valt zulk aas op, dan zal het u onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Wanneer een van de dieren die u tot spijze zijn, sterft, dan zal hij die zijn aas aanraakt, onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","En hij die van zijn aas eet, zal zijn klederen wassen en onrein zijn tot de avond; ook hij die zijn aas opneemt, zal zijn klederen wassen en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","En al het wemelend gedierte dat op de grond wemelt, is een gruwel, het zal niet gegeten worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Alles wat op de buik gaat en alles wat op vier voeten gaat, ook alle veelvoetigen van allerlei wemelend gedierte dat op de grond wemelt, dat zult gij niet eten, want die zijn een gruwel. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Maakt uzelf niet verfoeilijk door enig wemelend gedierte en verontreinigt u daardoor niet, zodat gij daardoor onrein wordt. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Want Ik ben de Here, uw God; heiligt u en weest heilig, want Ik ben heilig; verontreinigt uzelf niet door allerlei wemelend gedierte dat op de grond krioelt. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Want Ik ben de Here, die u uit het land Egypte heb doen trekken, om u tot een God te zijn; weest heilig, want Ik ben heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Dit is de wet aangaande het vee, het gevogelte en elk levend wezen dat krioelt in het water, en elk wezen dat op de grond wemelt – ");
INSERT INTO nldnbg_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","om scheiding te maken tussen het onreine en het reine, tussen de dieren die gegeten mogen worden, en de dieren die niet gegeten mogen worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Spreek tot de Israëlieten: Wanneer een vrouw moeder wordt en een kind van het mannelijk geslacht baart, dan zal zij zeven dagen onrein zijn; als in de tijd van haar maandelijkse afzondering zal zij onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","En op de achtste dag zal het vlees van zijn voorhuid besneden worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Drieëndertig dagen zal zij blijven in het reinigingsbloed; niets heiligs zal zij aanraken, naar het heiligdom zal zij niet komen, totdat de dagen van haar reiniging vervuld zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Indien zij echter een kind van het vrouwelijk geslacht baart, zal zij twee weken onrein zijn zoals in haar maandelijkse afzondering; zesenzestig dagen zal zij blijven in het reinigingsbloed. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Als de dagen van haar reiniging vervuld zijn, zal zij voor een zoon of voor een dochter een éénjarig schaap ten brandoffer, en een jonge duif of tortelduif ten zondoffer, naar de ingang van de tent der samenkomst tot de priester brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Deze zal het voor het aangezicht des Heren offeren en over haar verzoening doen; dan zal zij rein zijn van haar bloedvloeiing. Dit is de wet voor haar die gebaard heeft, hetzij het een kind van het mannelijk of van het vrouwelijk geslacht betreft. ");
INSERT INTO nldnbg_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Indien echter haar vermogen niet toereikend is voor een stuk kleinvee, dan zal zij twee tortelduiven of twee jonge duiven nemen: de ene ten brandoffer en de andere ten zondoffer, en de priester zal over haar verzoening doen, en zij zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wanneer iemand op de huid van zijn lichaam een zwelling of uitslag of lichte plek heeft, welke op de huid van zijn lichaam tot de plaag der melaatsheid zou kunnen worden, dan zal hij tot de priester Aäron of een van zijn zonen, de priesters, gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","De priester zal dan de aangetaste plek op de huid van het lichaam bezien, en als het haar op de aangetaste plek wit is geworden en het blijkt, dat de aangetaste plek dieper zit dan de huid van zijn lichaam, dan is het de plaag der melaatsheid; als de priester dat ziet, zal hij hem onrein verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Indien het echter een witte plek op de huid van zijn lichaam is, en het niet blijkt, dat die dieper dan de huid zit, en het haar niet wit geworden is, dan zal de priester de aangetaste zeven dagen opsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","De priester zal hem op de zevende dag bezien; wanneer hem dan blijkt, dat de aangetaste plek gelijk gebleven is en zich over de huid niet heeft uitgebreid, dan zal de priester hem andermaal zeven dagen opsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","En de priester zal hem op de zevende dag voor de tweede maal bezien; wanneer dan blijkt, dat de aangetaste plek is verdoft en zich over de huid niet heeft uitgebreid, dan zal de priester hem rein verklaren; het is uitslag; dan zal hij zijn klederen wassen en rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Maar indien de uitslag zich wel over de huid heeft uitgebreid, nadat hij zich aan de priester vertoond heeft om rein verklaard te worden, dan zal hij andermaal voor de priester verschijnen. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Wanneer de priester hem beziet en het blijkt, dat de uitslag zich over de huid heeft uitgebreid, dan zal de priester hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wanneer de plaag der melaatsheid zich bij enig mens voordoet, dan zal hij tot de priester gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Wanneer de priester hem beziet en het blijkt, dat er op de huid een witte zwelling is, die het haar heeft wit gemaakt, of dat er wild vlees groeit in de zwelling, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","dan is dat verouderde melaatsheid in de huid van zijn lichaam, en de priester zal hem niet opsluiten, want hij is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","En indien de melaatsheid sterk uitgebroken is in de huid en de melaatsheid de gehele huid van de aangetaste bedekt, van zijn hoofd tot zijn voeten, zover de priester ziet, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","en de priester beziet hem en het blijkt, dat de melaatsheid zijn gehele lichaam heeft bedekt, dan zal hij de aangetaste rein verklaren; hij is geheel wit geworden, hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Maar als zich wild vlees bij hem vertoont, dan is hij onrein; ");
INSERT INTO nldnbg_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ziet de priester dat wild vlees, dan zal hij hem onrein verklaren; het wild vlees is onrein, het is melaatsheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Of wanneer het wild vlees weer verdwijnt en hij wit wordt, dan zal hij tot de priester gaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","En de priester zal hem bezien; wanneer dan blijkt dat de aangetaste wit geworden is, dan zal de priester de aangetaste rein verklaren; hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Wanneer er op de huid van het lichaam een zweer was, die genezen is, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","maar er ontstaat op de plaats van de zweer een witte zwelling of een roodachtig witte plek, dan zal die aan de priester getoond worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Wanneer de priester die beziet en het blijkt, dat zij beneden de huid zit, en het haar daarop wit geworden is, dan zal de priester hem onrein verklaren; het is de plaag der melaatsheid, die in de zweer is uitgebroken. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Maar indien de priester haar beziet en het blijkt dat er geen wit haar op is, en dat zij niet beneden de huid zit, maar verdoft is, dan zal de priester hem zeven dagen opsluiten; ");
INSERT INTO nldnbg_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","en indien zij zich verder over de huid heeft uitgebreid, dan zal de priester hem onrein verklaren; het is de plaag. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Maar indien de lichte plek gelijk gebleven is op dezelfde plaats en zich niet heeft uitgebreid, dan is zij het litteken van de zweer, en de priester zal hem rein verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Of wanneer iemand op zijn huid een brandwond heeft, en het wild vlees van de brandwond is een roodachtig witte of witte plek, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","dan zal de priester die bezien; wanneer dan blijkt, dat het haar op die lichte plek wit geworden is, en het blijkt, dat zij dieper zit dan de huid, dan is het melaatsheid, die in de brandwond is uitgebroken, en de priester zal hem onrein verklaren; het is de plaag der melaatsheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Maar indien de priester die beziet en het blijkt, dat op die lichte plek geen wit haar is en zij niet beneden de huid zit, maar verdoft is, dan zal de priester hem zeven dagen opsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","En de priester zal hem op de zevende dag bezien; indien zij zich verder over de huid heeft uitgebreid, dan zal de priester hem onrein verklaren; het is de plaag der melaatsheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Maar indien de lichte plek gelijk gebleven is op dezelfde plaats en zich niet over de huid heeft uitgebreid, maar verdoft is, dan is dat de zwelling van de brandwond, en de priester zal hem rein verklaren, want het is het litteken van de brandwond. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wanneer een man of een vrouw een aangetaste plek op het hoofd of in de baard heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","dan zal de priester die aangetaste plek bezien; wanneer het blijkt, dat zij dieper zit dan de huid, en daar geel, dun haar op is, dan zal de priester hem onrein verklaren; het is uitslag, het is melaatsheid van het hoofd of van de baard. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","En wanneer de priester de door uitslag aangetaste plek beziet, en het niet blijkt, dat zij dieper zit dan de huid, en daar geen zwart haar op is, dan zal de priester de door uitslag aangetaste zeven dagen opsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","En de priester zal de aangetaste plek op de zevende dag bezien; wanneer dan blijkt, dat de uitslag zich niet heeft uitgebreid, en dat daar geen geel haar op is, en het blijkt, dat de uitslag niet dieper zit dan de huid, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","dan zal hij zich scheren, maar de uitslag zal hij niet scheren; en de priester zal de door uitslag aangetaste andermaal zeven dagen opsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","En de priester zal de uitslag op de zevende dag bezien; wanneer dan blijkt, dat de uitslag zich niet over de huid heeft uitgebreid, en het niet blijkt, dat deze dieper zit dan de huid, dan zal de priester hem rein verklaren, en hij zal zijn klederen wassen; hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Maar indien de uitslag zich verder over de huid heeft uitgebreid, nadat hij rein verklaard is, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","en de priester beziet hem, en het blijkt, dat de uitslag zich over de huid uitgebreid heeft, dan behoeft de priester niet naar het gele haar te zoeken, hij is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Maar indien de uitslag, naar hij zien kan, gelijk gebleven is, en daar zwart haar op groeit, dan is de uitslag genezen, hij is rein, en de priester zal hem rein verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wanneer een man, of een vrouw, op de huid van hun lichaam lichte plekken hebben, witte plekken, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","en de priester beziet ze, en het blijkt, dat op de huid van hun lichaam doffe, witte plekken zijn, dan is het gewone uitslag, die in de huid uitgebroken is; hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Wanneer het hoofd van een man kaal wordt, is hij slechts kaalhoofdig; hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Indien iemands voorhoofd kaal wordt, dan is hij van voren kaal; hij is rein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Maar wanneer op de kale kruin of op het kale voorhoofd een roodachtig witte, aangetaste plek is, dan is het melaatsheid, die uitgebroken is op zijn kale kruin of op zijn kale voorhoofd. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","En de priester zal hem bezien; wanneer dan blijkt, dat de zwelling van de aangetaste plek roodachtig wit is op zijn kale kruin of op zijn kale voorhoofd, zoals melaatsheid van de huid van het lichaam er uit ziet, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","dan is hij een melaatse, hij is onrein, de priester zal hem zeker onrein verklaren; op zijn hoofd is zijn plaag. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","De klederen van de melaatse, die door de plaag getroffen is, zullen gescheurd zijn, zijn hoofdhaar zal hij los laten hangen en de bovenlip bedekken en roepen: Onrein, onrein! ");
INSERT INTO nldnbg_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Zolang hij de plaag heeft, blijft hij onrein; hij is onrein; afgezonderd zal hij wonen, buiten de legerplaats zal zijn verblijf zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Wanneer aan een kleed een plaag der melaatsheid zal zijn, aan een wollen of linnen kleed, hetzij aan de schering, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","hetzij aan de inslag van het linnen of van de wol, of aan leder of iets van leder gemaakt, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","en indien de aangetaste plek groenachtig of roodachtig is aan het kleed of aan het leder, hetzij aan de schering, hetzij aan de inslag, of aan enig lederwerk, dan is dat de plaag der melaatsheid, en zal het aan de priester getoond worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","De priester zal de aangetaste plek bezien en het aangetaste zeven dagen wegsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Op de zevende dag zal hij de aangetaste plek bezien; wanneer de aangetaste plek aan het kleed, hetzij aan de schering, hetzij aan de inslag of aan het leder, voor welk doel het leder ook gebruikt wordt, zich heeft uitgebreid, dan is de plaag een kwaadaardige melaatsheid, het is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hij zal het kleed, zowel de schering als de inslag van wol of van linnen, of enig lederwerk, waaraan de plaag is, verbranden, want het is een kwaadaardige melaatsheid, met vuur zal het verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","En wanneer de priester het beziet, en het blijkt, dat de aangetaste plek aan het kleed, hetzij aan de schering, hetzij aan de inslag, of aan enig lederwerk, zich niet uitgebreid heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","dan zal de priester gebieden het aangetaste voorwerp te wassen, en hij zal het andermaal zeven dagen wegsluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Nadat het gewassen is, zal de priester het aangetaste bezien; wanneer blijkt, dat de aangetaste plek er niet anders uitziet, ook al heeft de aangetaste plek zich niet uitgebreid, dan is het onrein; met vuur zult gij het verbranden, het is een invreting aan zijn achterkant of aan zijn voorkant. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","En wanneer de priester het beziet, en het blijkt, dat de aangetaste plek verdoft is, nadat het gewassen is, dan zal hij die uit het kleed of uit het leder, hetzij uit de schering, hetzij uit de inslag, uitscheuren. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Indien zij zich echter opnieuw vertoont in het kleed, hetzij in de schering, hetzij in de inslag, of in enig lederwerk, dan is het uitbrekende melaatsheid; met vuur zult gij dan het stuk waaraan de plaag zit, verbranden. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Maar het kleed, hetzij de schering, hetzij de inslag, of enig lederwerk, dat gij wassen zult, en waaruit de plaag is geweken, zal andermaal gewassen worden, en het zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Dit is de wet op de plaag der melaatsheid aan wollen of linnen klederen, hetzij aan de schering, hetzij aan de inslag, of aan enig lederwerk – om het rein of onrein te verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dit zal de wet voor de melaatse zijn ten dage van zijn reiniging: hij zal tot de priester gebracht worden, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","en de priester zal uitgaan buiten de legerplaats; wanneer de priester hem beziet en het blijkt, dat de plaag der melaatsheid genezen is, van de melaatse is geweken, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","dan zal de priester gebieden voor hem die gereinigd moet worden, twee levende, reine vogels te nemen, ook cederhout, scharlaken en hysop. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","De priester zal gebieden de ene vogel te slachten boven een aarden pot met levend water. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","De levende vogel echter zal hij nemen benevens het cederhout, het scharlaken en de hysop, en hij zal die met de levende vogel dopen in het bloed van de vogel die boven het levende water geslacht is. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","En hij zal hem die van de melaatsheid gereinigd moet worden, zevenmaal besprenkelen en hem reinigen, en de levende vogel zal hij in het open veld laten wegvliegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","En hij die gereinigd moet worden, zal zijn klederen wassen, al zijn haar afscheren en zich in water baden, en hij zal rein zijn: daarna zal hij in de legerplaats komen, maar zeven dagen buiten zijn tent blijven. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Op de zevende dag zal hij al zijn haar afscheren: zijn hoofd, zijn baard en zijn wenkbrauwen, al zijn haar zal hij afscheren, zijn klederen wassen en zijn lichaam in water baden; en hij zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","En op de achtste dag zal hij twee gave schapen nemen, en één eenjarige gave ooi en drie tienden efa fijn meel als spijsoffer, aangemaakt met olie, en één log olie. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","En de priester die de reiniging voltrekt, zal de man die gereinigd moet worden, met dit alles stellen voor het aangezicht des Heren, bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","De priester zal het ene schaap nemen en het tot een schuldoffer offeren met het log olie, en hij zal ze bewegen als beweegoffer voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Hij zal het schaap slachten op de plaats, waar men het zondoffer en het brandoffer slacht, op de heilige plaats, want evenals het zondoffer komt ook het schuldoffer de priester toe; het is allerheiligst. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","De priester zal een deel van het bloed van het schuldoffer nemen en dit strijken aan de rechter oorlel van hem die gereinigd moet worden, en aan zijn rechterduim en zijn rechter grote teen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","En de priester zal een deel van het log olie nemen en op zijn eigen linkerhand gieten; ");
INSERT INTO nldnbg_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","de priester zal zijn rechtervinger dopen in de olie die in zijn linkerhand is, en van die olie met zijn vinger zevenmaal sprenkelen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Van de rest van de olie die in zijn hand is, zal de priester iets strijken aan de rechter oorlel van hem die gereinigd moet worden, en aan zijn rechterduim en zijn rechter grote teen, boven op het bloed van het schuldoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","En wat van de olie in zijn hand is overgebleven, zal de priester doen op het hoofd van hem die gereinigd moet worden; zo zal de priester over hem verzoening doen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","En de priester zal het zondoffer bereiden en verzoening doen over hem die gereinigd moet worden van zijn onreinheid, en daarna zal hij het brandoffer slachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","De priester zal het brandoffer en het spijsoffer op het altaar offeren. En de priester zal verzoening over hem doen, en hij zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Maar indien hij arm is en zijn vermogen niet toereikend is, dan zal hij nemen één schaap als schuldoffer, tot een beweegoffer, om verzoening over hem te doen, met één tiende efa fijn meel, aangemaakt met olie, tot een spijsoffer, en een log olie. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ook twee tortelduiven of twee jonge duiven, naar dat zijn vermogen toereikend is, en de ene zal zondoffer en de andere brandoffer zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Hij zal ze tot zijn reiniging op de achtste dag tot de priester brengen, bij de ingang van de tent der samenkomst voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","De priester zal het schaap voor het schuldoffer nemen en het log olie, en de priester zal ze bewegen als beweegoffer voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Hij zal het schaap voor het schuldoffer slachten en de priester zal van het bloed van het schuldoffer nemen en dat strijken aan de rechter oorlel van hem die gereinigd moet worden, en aan zijn rechterduim en zijn rechter grote teen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","En een deel van de olie zal de priester in zijn eigen linkerhand gieten, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","en de priester zal met zijn rechtervinger van de olie die in zijn linkerhand is, zevenmaal sprenkelen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","En de priester zal iets van de olie die in zijn hand is, strijken aan de rechter oorlel van hem die gereinigd moet worden, en aan zijn rechterduim en zijn rechter grote teen, boven op de plaats van het bloed van het schuldoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","En wat van de olie in zijn hand is overgebleven, zal de priester doen op het hoofd van hem die gereinigd moet worden, om over hem verzoening te doen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","En hij zal één van de tortelduiven of van de jonge duiven, hetgeen waartoe zijn vermogen toereikend is, bereiden, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","hetgeen waartoe zijn vermogen toereikend is: de ene als zondoffer en de andere als brandoffer, benevens het spijsoffer; en de priester zal verzoening doen over hem, die gereinigd moet worden, voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Dit is de wet aangaande hem die de plaag der melaatsheid heeft, wiens vermogen niet toereikend is voor zijn reiniging. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wanneer gij komt in het land Kanaän, dat Ik u ten bezit geef, en Ik de plaag der melaatsheid doe ontstaan in een huis in het land dat gij bezit, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","dan zal hij, van wie dat huis is, het de priester komen meedelen en zeggen: bij mij aan huis vertoont zich iets als de plaag. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Dan zal de priester gebieden het huis te ontruimen, voordat de priester komt om de plaag te bezien, opdat niet alles wat in het huis is, onrein zij; daarna zal de priester komen om het huis te bezien. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","En hij zal de plaag bezien; wanneer dan blijkt, dat de plaag op de wanden van het huis zit als groenachtige of roodachtige kuiltjes, die dieper schijnen te zitten dan de wand, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","dan zal de priester uit het huis gaan, naar de ingang van het huis en het huis zeven dagen sluiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Op de zevende dag zal de priester terugkomen; wanneer hij het dan beziet en het blijkt, dat de plaag zich op de wanden van het huis heeft uitgebreid, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","dan zal de priester gebieden, de stenen waarop de plaag zit, eruit te halen en ze buiten de stad op een onreine plaats te werpen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Het huis zal hij van binnen rondom laten afschrappen, en men zal het leem dat men afgeschrapt heeft, buiten de stad op een onreine plaats storten. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","En men zal andere stenen nemen en die in de plaats van de vorige aanbrengen; men zal ook ander leem nemen en het huis bepleisteren. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Maar indien de plaag opnieuw in het huis uitbreekt, nadat men de stenen uitgebroken en het huis afgeschrapt heeft en nadat het bepleisterd is, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","en de priester komt en beziet het en het blijkt, dat de plaag zich in het huis heeft uitgebreid, dan is het een kwaadaardige melaatsheid in het huis: het is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Dan zal men het huis omverhalen, zijn stenen en zijn houtwerk en al het leem van het huis, en men zal het buiten de stad brengen op een onreine plaats. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","En hij die in het huis komt gedurende al de dagen dat men het afgesloten heeft, zal onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","En hij die zich te slapen legt in dat huis, zal zijn klederen wassen; ook hij die in dat huis eet, zal zijn klederen wassen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Maar wanneer de priester komt en het beziet en het blijkt, dat de plaag zich niet heeft uitgebreid in het huis, nadat het huis bepleisterd was, dan zal de priester het huis rein verklaren, omdat de plaag genezen is. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Dan zal hij, om het huis te ontzondigen, twee vogels, cederhout, scharlaken en hysop nemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Hij zal de ene vogel slachten boven een aarden pot met levend water. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Het cederhout, de hysop, het scharlaken en de levende vogel zal hij nemen en ze dopen in het bloed van de geslachte vogel en het levende water, en zevenmaal dat huis besprenkelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Zo zal hij het huis ontzondigen met het bloed van de vogel, het levende water, de levende vogel, het cederhout, de hysop en het scharlaken. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","En de levende vogel zal hij buiten de stad in het open veld laten wegvliegen; zo zal hij verzoening doen over dat huis, en het zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Dit is de wet op allerlei plaag van melaatsheid, op haaruitslag, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","melaatsheid van kleed en huis, ");
INSERT INTO nldnbg_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","zwelling, uitslag en lichte plek – ");
INSERT INTO nldnbg_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","om aan te wijzen, wanneer iets onrein of wanneer iets rein is; dit is de wet op de melaatsheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Spreekt tot de Israëlieten en zegt tot hen: Wanneer enig man een vloeiing uit zijn lichaam heeft, diens vloeiing is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Zo staat het ten aanzien van zijn onreinheid bij zijn vloeiing: hetzij zijn lichaam die vloeiing laat lopen, hetzij het die inhoudt, zodat hij niet meer vloeit; dat is zijn onreinheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Elk bed waarop hij die de vloeiing heeft, ligt, is onrein, en elk voorwerp waarop hij zit, is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ieder die zijn bed aanraakt, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Wie zit op een voorwerp, waarop hij die de vloeiing heeft, gezeten heeft, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wie het lichaam van hem die de vloeiing heeft, aanraakt, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Wanneer hij die de vloeiing heeft, op een reine spuwt, dan zal deze zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","En elk zadel, waarop hij die de vloeiing heeft, rijdt, zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","En ieder, die iets aanraakt dat onder hem is, zal onrein zijn tot de avond; wie dit opneemt, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","En ieder, welke hij die de vloeiing heeft aanraakt zonder de handen met water te hebben afgespoeld, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Het aardewerk, dat hij die de vloeiing heeft, aanraakt, zal stukgeslagen worden, en elk houten voorwerp zal met water afgespoeld worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Wanneer hij, die de vloeiing heeft, rein zal zijn van zijn vloeiing, dan zal hij zeven dagen tellen met het oog op zijn reiniging, zijn klederen wassen, zijn lichaam in levend water baden, en hij zal rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Op de achtste dag zal hij twee tortelduiven of twee jonge duiven nemen en voor het aangezicht des Heren komen bij de ingang van de tent der samenkomst en ze de priester geven. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","En de priester zal ze bereiden, de ene als zondoffer en de andere als brandoffer. En de priester zal verzoening over hem doen voor het aangezicht des Heren vanwege zijn vloeiing. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Wanneer bij een man zaaduitstorting plaats heeft, dan zal hij zijn gehele lichaam in water baden en hij zal onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Elk kleed en alle leder, waarop zaad is uitgestort, zal in water gewassen worden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Wanneer een man bij een vrouw gelegen heeft en zaaduitstorting heeft plaats gehad, dan zullen zij zich in water baden en tot de avond onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wanneer een vrouw vloeit – namelijk de bloedvloeiing van haar lichaam heeft – dan zal zij zeven dagen in haar maandelijkse onreinheid blijven, en ieder die haar aanraakt, zal onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Alles waarop zij in haar maandelijkse onreinheid ligt, zal onrein zijn, en alles waarop zij zit, zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ieder die haar bed aanraakt, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ieder die een of ander voorwerp, waarop zij gezeten heeft, aanraakt, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Indien hij iets aanraakt, dat zich op het bed of op het voorwerp waarop zij gezeten heeft, bevindt, dan zal hij onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Indien een man bij haar ligt, dan zal haar maandelijkse onreinheid op hem komen, en zeven dagen zal hij onrein zijn, en elk bed waarop hij ligt zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wanneer bij een vrouw lange tijd bloed vloeit, buiten de tijd van haar maandelijkse onreinheid, of wanneer zij langer vloeit dan haar maandelijkse onreinheid, dan zal zij gedurende al de tijd dat zij vloeit, onrein zijn als in de tijd van haar maandelijkse onreinheid; zij is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Elk bed waarop zij ligt, al de tijd dat zij vloeit, zal voor haar zijn als het bed van haar maandelijkse onreinheid, en elk voorwerp waarop zij zit, zal onrein zijn als in de onreinheid van haar maandelijkse onreinheid. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ieder die deze dingen aanraakt, zal onrein zijn, zijn klederen wassen, zich baden in water, en onrein zijn tot de avond. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Maar indien zij van haar vloed rein geworden is, dan zal zij nog zeven dagen tellen en daarna zal zij rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Op de achtste dag zal zij twee tortelduiven of twee jonge duiven nemen en ze tot de priester brengen naar de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","En de priester zal de ene tot een zondoffer en de andere tot een brandoffer bereiden; zo zal de priester verzoening over haar doen voor het aangezicht des Heren, om haar onreine vloed. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Zo zult gij de Israëlieten zuiveren van hun onreinheid, opdat zij niet in hun onreinheid sterven, wanneer ze mijn woning, die in hun midden is, zouden verontreinigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dit is de wet aangaande hem die een vloeiing heeft of die een zaaduitstorting heeft, waardoor men onrein wordt, ");
INSERT INTO nldnbg_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","en aangaande haar die vloeit in haar maandelijkse onreinheid, en aangaande iemand, hetzij van het mannelijk hetzij van het vrouwelijk geslacht, die een vloeiing heeft, en aangaande de man, die ligt bij een onreine. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Na de dood van de beide zonen van Aäron, die gestorven waren, toen zij voor het aangezicht des Heren waren genaderd, sprak de Here tot Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","De Here nu zeide tot Mozes: Spreek tot uw broeder Aäron, dat hij niet te allen tijde kome in het heiligdom binnen het voorhangsel voor het verzoendeksel dat op de ark ligt, opdat hij niet sterve; want in de wolk verschijn Ik boven het verzoendeksel. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Slechts op deze wijze zal Aäron het heiligdom binnengaan: met een jonge stier ten zondoffer en een ram ten brandoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Het heilige linnen onderkleed zal hij aantrekken en een linnen broek zal over zijn vlees zijn en met een linnen gordel zal hij zich omgorden en een linnen tulband zal hij zich ombinden; dit zijn heilige klederen, die hij zal aantrekken, nadat hij zijn lichaam in water gebaad heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","En van de vergadering der Israëlieten zal hij twee geitebokken ten zondoffer en één ram ten brandoffer nemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Dan zal Aäron de stier van zijn eigen zondoffer brengen en verzoening doen voor zich en zijn huis. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hij zal de twee bokken nemen en ze voor het aangezicht des Heren stellen bij de ingang van de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","en Aäron zal over de beide bokken het lot werpen; één lot voor de Here, en één lot voor Azazel. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Dan zal Aäron de bok waarop het lot voor de Here gevallen is, brengen en hem ten zondoffer bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Maar de bok waarop het lot voor Azazel gevallen is, zal men levend voor het aangezicht des Heren stellen, om daarmee verzoening te doen, door hem voor Azazel de woestijn in te zenden. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Dan zal Aäron de stier van zijn eigen zondoffer brengen en verzoening doen voor zich en zijn huis; hij zal de stier van zijn eigen zondoffer slachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","En hij zal een pan vol gloeiende kolen van het altaar voor het aangezicht des Heren nemen en zijn handen vullen met fijngestoten welriekend reukwerk en dat alles brengen binnen het voorhangsel. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Dan zal hij het reukwerk op het vuur leggen voor het aangezicht des Heren, zodat de wolk van het reukwerk het verzoendeksel dat op de getuigenis ligt, bedekt, opdat hij niet sterve. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Dan zal hij een deel van het bloed van de stier nemen en dat met zijn vinger sprenkelen op het verzoendeksel, aan de voorzijde; en vóór het verzoendeksel zal hij zevenmaal dat bloed met zijn vinger sprenkelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Dan zal hij de bok van het zondoffer, voor het volk bestemd, slachten en zijn bloed naar binnen, achter het voorhangsel brengen, en met dat bloed doen, zoals hij met het bloed van de stier gedaan heeft: hij zal het op het verzoendeksel en vóór het verzoendeksel sprenkelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Zo zal hij verzoening doen over het heiligdom om de onreinheden der Israëlieten en om hun overtredingen in al hun zonden; aldus zal hij doen met de tent der samenkomst, die bij hen verblijf houdt te midden van hun onreinheden. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Geen mens zal in de tent der samenkomst zijn, wanneer hij daar binnengaat om in het heiligdom verzoening te doen, totdat hij naar buiten komt en verzoening gedaan heeft voor zichzelf, voor zijn huis en voor de gehele gemeente Israëls. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Dan zal hij naar buiten gaan naar het altaar, dat voor het aangezicht des Heren staat, en daarover verzoening doen; hij zal van het bloed van de stier en van het bloed van de bok nemen en dat rondom aan de horens van het altaar strijken. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Dan zal hij daarop met zijn vinger zevenmaal van het bloed sprenkelen en het reinigen en heiligen van de onreinheden der Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Wanneer hij de verzoening van het heiligdom en van de tent der samenkomst en van het altaar voleindigd heeft, dan zal hij de levende bok brengen, ");
INSERT INTO nldnbg_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","en Aäron zal zijn beide handen op de kop van de levende bok leggen en over hem al de ongerechtigheden der Israëlieten en al hun overtredingen in al hun zonden, belijden; hij zal die op de kop van de bok leggen en die door iemand, die daarvoor gereed staat, naar de woestijn laten brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Zo zal de bok al hun ongerechtigheden op zich dragen naar een onvruchtbaar land, en hij zal die bok in de woestijn vrijlaten. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Daarna zal Aäron naar de tent der samenkomst komen en de linnen klederen uittrekken, die hij aangetrokken had, toen hij het heiligdom binnenging, en zal ze daar laten liggen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Hij zal zijn lichaam in water baden op een heilige plaats en zijn gewone klederen aantrekken; dan naar buiten gaan en zijn brandoffer en het brandoffer van het volk bereiden en verzoening doen voor zich en voor het volk. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","En het vet van het zondoffer zal hij op het altaar in rook doen opgaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Hij nu, die de bok voor Azazel weggebracht heeft, zal zijn klederen wassen, zijn lichaam in water baden en daarna in de legerplaats komen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","En de stier van het zondoffer en de bok van het zondoffer, waarvan het bloed gebracht werd om verzoening te doen in het heiligdom, zal men buiten de legerplaats brengen en hun huid, hun vlees en hun mest met vuur verbranden. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Wie dat verbrandt, zal zijn klederen wassen, zijn lichaam in water baden en daarna in de legerplaats komen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Dit zal u tot een altoosdurende inzetting zijn: in de zevende maand op de tiende der maand zult gij u verootmoedigen en generlei werk doen, zomin de geboren Israëliet als de vreemdeling, die in uw midden vertoeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Want op deze dag zal over u verzoening gedaan worden, om u te reinigen; van al uw zonden zult gij gereinigd worden voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Het zal u een volkomen sabbat zijn en gij zult u verootmoedigen, het is een altoosdurende inzetting. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","En de verzoening zal de priester doen, die men gezalfd heeft en die men gewijd heeft, om in zijns vaders plaats het priesterambt te bekleden; hij zal de linnen klederen, de heilige klederen, aantrekken; ");
INSERT INTO nldnbg_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","het heilige der heiligen zal hij verzoenen, ook de tent der samenkomst en het altaar zal hij verzoenen, en over de priesters en het ganse volk der gemeente verzoening doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","En dit zal u een altoosdurende inzetting zijn, ten einde verzoening te doen over de Israëlieten om al hun zonden, eenmaal in het jaar. En hij deed, zoals de Here Mozes bevolen had. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Spreek tot Aäron en zijn zonen en tot al de Israëlieten en zeg tot hen: Dit is hetgeen de Here geboden heeft: ");
INSERT INTO nldnbg_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ieder van het huis Israëls, die een rund, een schaap of een geit in de legerplaats of buiten de legerplaats slacht, ");
INSERT INTO nldnbg_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","maar die niet brengt naar de ingang van de tent der samenkomst, om een offergave aan de Here te brengen vóór de tabernakel des Heren – als bloedschuld zal dat die man worden aangerekend; hij heeft bloed vergoten en die man zal uit het midden van zijn volk uitgeroeid worden, ");
INSERT INTO nldnbg_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","opdat de Israëlieten hun slachtoffers brengen, die zij op het open veld plegen te offeren; zij moeten ze brengen voor de Here, naar de ingang van de tent der samenkomst, tot de priester, om ze als vredeoffers de Here te offeren. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Dan zal de priester het bloed op het altaar des Heren, bij de ingang van de tent der samenkomst, sprengen en het vet in rook doen opgaan tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","En zij zullen hun offers niet meer brengen aan de veldgeesten, die zij overspelig nalopen. Een altoosdurende inzetting zal dit voor hen zijn in hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","En gij zult tot hen zeggen: Ieder van het huis Israëls of van de vreemdelingen, die in uw midden vertoeven, die een brandoffer of slachtoffer offert, ");
INSERT INTO nldnbg_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","maar dat niet naar de ingang van de tent der samenkomst brengt om het de Here te bereiden, die zal uit zijn volksgenoten uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ieder van het huis Israëls en van de vreemdelingen, die in hun midden vertoeven, die enig bloed eet – tegen zo iemand, die dat bloed gegeten heeft, zal Ik mijn aangezicht keren en hem uit het midden van zijn volk uitroeien. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Want de ziel van het vlees is in het bloed en Ik heb het u op het altaar gegeven om verzoening over uw zielen te doen, want het bloed bewerkt verzoening door middel van de ziel. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Daarom heb Ik tot de Israëlieten gezegd: Niemand van u zal bloed eten. Ook de vreemdeling, die in uw midden vertoeft, zal geen bloed eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","En ieder van de Israëlieten en van de vreemdelingen, die in uw midden vertoeven, die een stuk wild of gevogelte jaagt, dat gegeten mag worden, zal het bloed daarvan uitgieten en dat bedekken met aarde. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Want, wat de ziel van alle vlees betreft – het bloed ervan is zijn ziel; daarom heb Ik tot de Israëlieten gezegd: Gij zult van generlei vlees bloed eten, want de ziel van alle vlees is het bloed: ieder die het eet, zal uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","En ieder, hetzij geboren Israëliet of vreemdeling, die een gestorven of verscheurd dier eet, zal zijn klederen wassen, zich in water baden en onrein zijn tot de avond; dan zal hij rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Maar indien hij ze niet wast en zijn lichaam niet baadt, dan zal hij zijn ongerechtigheid dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Spreek tot de Israëlieten en zeg tot hen: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Gij zult niet doen, zoals men doet in het land Egypte, waar gij gewoond hebt; gij zult niet doen, zoals men doet in het land Kanaän, waarheen Ik u breng; naar hun inzettingen zult gij niet wandelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mijn verordeningen zult gij volbrengen en mijn inzettingen in acht nemen en daarnaar wandelen: Ik ben de Here uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ja, gij zult mijn inzettingen en mijn verordeningen in acht nemen; de mens die ze doet, zal daardoor leven: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niemand zal naderen tot zijn naaste bloedverwant, om de schaamte te ontbloten: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Gij zult de schaamte van uw vader, dat is de schaamte van uw moeder, niet ontbloten; het is uw moeder, gij zult haar schaamte niet ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","De schaamte van de vrouw van uw vader zult gij niet ontbloten; het is de schaamte van uw vader. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","De schaamte van uw zuster, de dochter van uw vader of de dochter van uw moeder, geboren in huis of geboren daarbuiten, haar schaamte zult gij niet ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","De schaamte van de dochter van uw zoon of van de dochter van uw dochter, haar schaamte zult gij niet ontbloten, want uw schaamte zijn zij. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","De schaamte van de dochter van uws vaders vrouw, die aan uw vader geboren is, zij is uw zuster – haar schaamte zult gij niet ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","De schaamte van uws vaders zuster zult gij niet ontbloten; zij is uws vaders bloedverwant. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","De schaamte van uw moeders zuster zult gij niet ontbloten, want zij is uw moeders bloedverwant. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","De schaamte van uws vaders broeder zult gij niet ontbloten; tot zijn vrouw zult gij niet naderen, het is uw tante. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","De schaamte van uw schoondochter zult gij niet ontbloten; het is uws zoons vrouw, gij zult haar schaamte niet ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","De schaamte van uws broeders vrouw zult gij niet ontbloten; het is de schaamte van uw broeder. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","De schaamte van een vrouw en die van haar dochter zult gij niet ontbloten; gij zult niet de dochter van haar zoon en de dochter van haar dochter nemen, om haar schaamte te ontbloten; zij zijn bloedverwanten: bloedschande is het. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Gij zult geen vrouw nemen als bijvrouw naast haar zuster om haar schaamte te ontbloten nevens haar, tijdens haar leven. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","En tot een vrouw in haar maandelijkse onreinheid zult gij niet naderen, om haar schaamte te ontbloten. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","En met de vrouw van uw naaste zult gij geen vleselijke gemeenschap hebben, zodat gij u met haar verontreinigt. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","En gij zult geen van uw kinderen overgeven, om het aan de Moloch te wijden, opdat gij de naam van uw God niet ontwijdt. Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","En gij zult geen gemeenschap hebben met een, die van het mannelijk geslacht is, zoals men gemeenschap heeft met een vrouw: een gruwel is het. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","En met geen enkel dier zult gij vleselijke gemeenschap hebben, om u daarmee te verontreinigen; en een vrouw mag niet staan voor een dier, om daarmee gemeenschap te hebben: schandelijke ontucht is het. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Verontreinigt u niet door dit alles, want door dit alles hebben zich verontreinigd de volken die Ik voor u uit wegdrijf. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Het land toch werd verontreinigd en Ik vergold daaraan zijn ongerechtigheid, zodat het land zijn inwoners uitspuwde. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Gij echter zult mijn inzettingen en mijn verordeningen in acht nemen en geen van deze gruwelen doen, noch de geboren Israëliet, noch de vreemdeling die in uw midden vertoeft – ");
INSERT INTO nldnbg_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","want al deze gruwelen deden de lieden van het land, die vóór u waren, zodat het land onrein werd – ");
INSERT INTO nldnbg_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","opdat het land u niet uitspuwe, wanneer gij het verontreinigt, zoals het uitgespuwd heeft het volk, dat vóór u was. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Want ieder die iets van al deze gruwelen doet, – degenen, die ze doen, zullen uit het midden van hun volk uitgeroeid worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Zo zult gij het voorschrift dat Ik u geef, in acht nemen, zodat gij de gruwelijke inzettingen niet doet, die vóór u gedaan werden, opdat gij u daardoor niet verontreinigt. Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Spreek tot de ganse vergadering der Israëlieten en zeg tot hen: Heilig zult gij zijn, want Ik, de Here, uw God, ben heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ieder zal voor zijn moeder en zijn vader ontzag hebben en mijn sabbatten houden: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Gij zult u niet tot de afgoden wenden en u geen gegoten beelden maken: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","En wanneer gij de Here een vredeoffer offert, zult gij het zo offeren, dat gij Hem welgevallig zijt. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Het zal gegeten worden op de dag dat gij het offert, en op de volgende dag, maar wat tot de derde dag overblijft, zal met vuur verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Indien het dan toch op de derde dag gegeten wordt, zal het iets verfoeilijks wezen, het zal niet welgevallig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Wie het eet, zal zijn ongerechtigheid dragen, omdat hij het heilige des Heren ontwijd heeft; zo iemand zal uit zijn volksgenoten worden uitgeroeid. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Wanneer gij de oogst van uw land binnenhaalt, zult gij de rand van uw veld niet geheel afmaaien, en wat nog is blijven liggen van uw oogst, zult gij niet oplezen. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ook zult gij uw wijngaard niet afzoeken en het afgevallene van uw wijngaard niet oplezen; dit zult gij voor de armen en de vreemdelingen laten liggen: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Gij zult niet stelen, gij zult niet liegen en gij zult elkander niet bedriegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Gij zult bij mijn naam niet vals zweren en zo de naam van uw God ontheiligen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Gij zult uw naaste niet afpersen en gij zult niet roven; het loon van een dagloner zal niet de nacht bij u overblijven tot de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Een dove zult gij niet vloeken en voor een blinde zult gij geen struikelblok leggen, maar gij zult voor uw God vrezen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Gij zult bij het rechtspreken geen onrecht doen; gij zult de arme niet begunstigen en de aanzienlijke niet voortrekken: op rechtvaardige wijze zult gij uw naaste berechten. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Gij zult onder uw volksgenoten niet als een lasteraar rondgaan; gij zult uw naaste niet naar het leven staan: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Gij zult uw broeder in uw hart niet haten; openlijk zult gij uw volksgenoot terechtwijzen en niet ter wille van hem zonde op u laden. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Gij zult niet wraakzuchtig en haatdragend zijn tegenover de kinderen van uw volk, maar uw naaste liefhebben als uzelf: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mijn inzettingen zult gij bewaren, gij zult van uw vee niet twee verschillende soorten laten paren, uw akker zult gij niet met tweeërlei zaad bezaaien, en een kleed, uit tweeërlei stof vervaardigd, zult gij niet dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Wanneer iemand geslachtsgemeenschap heeft met een vrouw, terwijl zij, als slavin, aan een man ondergeschikt is, maar niet losgekocht, noch haar een vrijbrief is gegeven, dan zal een straf toegepast worden; zij zullen niet ter dood gebracht worden, omdat zij niet vrijgelaten was. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hij zal zijn schuldoffer voor de Here bij de ingang van de tent der samenkomst brengen, een ram ten schuldoffer. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","En de priester zal door de ram van het schuldoffer verzoening over hem doen voor het aangezicht des Heren, voor de zonde die hij begaan heeft, en hem zal vergiffenis geschonken worden voor de zonde die hij begaan heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Wanneer gij komt in het land en allerlei vruchtbomen plant, dan zult gij de vrucht daarvan als verboden beschouwen; drie jaar lang zal zij u verboden zijn, zij zal niet gegeten worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In het vierde jaar echter zullen alle vruchten daarvan tot een lofprijzing de Here geheiligd zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","In het vijfde jaar zult gij dan de vrucht daarvan eten, opdat zij u een grotere opbrengst geven: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Gij zult niets met het bloed eten; gij zult niet aan waarzeggerij of toverij doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Gij zult de rand van uw hoofdhaar niet rond afscheren, en gij zult de rand van uw baard niet afsnijden. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Gij zult geen insnijding voor een dode in uw lichaam maken en geen tekens in uw huid laten prikken: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Gij zult uw dochter niet ontwijden door haar aan ontucht over te geven, opdat het land geen ontucht bedrijve en het land niet van schanddaden vol worde. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mijn sabbatten zult gij houden en voor mijn heiligdom eerbied hebben: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Gij zult u niet wenden tot de geesten van doden of tot waarzeggende geesten, gij zult hen niet zoeken, om u met hen te verontreinigen: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Voor het grijze haar zult gij opstaan en aan de oude zult gij eer bewijzen en voor uw God zult gij vrezen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","En wanneer een vreemdeling bij u in uw land vertoeft, zult gij hem niet onderdrukken. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Als een onder u geboren Israëliet zal u de vreemdeling gelden, die bij u vertoeft; gij zult hem liefhebben als uzelf, want gij zijt vreemdeling geweest in het land Egypte: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Gij zult geen onrecht doen bij het rechtspreken, bij lengtemaat, gewicht of inhoudsmaat. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Een zuivere weegschaal, zuivere gewichten, een zuivere efa en een zuivere hin zult gij gebruiken: Ik ben de Here, uw God, die u uit het land Egypte geleid heb. ");
INSERT INTO nldnbg_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Zo zult gij al mijn inzettingen en al mijn verordeningen nauwgezet in acht nemen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Tot de Israëlieten zult gij zeggen: Iedere Israëliet en iedere vreemdeling, die in Israël vertoeft, die van zijn kinderen aan de Moloch geeft, zal zeker ter dood gebracht worden: het volk des lands zal hem stenigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ook zal Ik mijn aangezicht tegen die man keren en hem uit het midden van zijn volk uitroeien, omdat hij van zijn kinderen aan de Moloch gegeven heeft, om mijn heiligdom te verontreinigen en mijn heilige naam te ontwijden. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Indien echter het volk des lands oogluikend toelaat, dat die man van zijn kinderen aan de Moloch geeft en hem niet ter dood brengt, ");
INSERT INTO nldnbg_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","dan zal Ik mijn aangezicht tegen die man en tegen zijn geslacht keren en Ik zal hem en allen die hem in zijn overspelige verering van de Moloch volgen, uit het midden van hun volk uitroeien. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","En iemand, die zich tot de geesten van doden of tot waarzeggende geesten wendt, om die overspelig na te lopen – tegen zo iemand zal Ik mijn aangezicht keren en hem uit het midden van zijn volk uitroeien. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Heiligt u dan, en weest heilig, want Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Zo zult gij mijn inzettingen nauwgezet in acht nemen; Ik ben de Here, die u heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Wanneer er iemand is, die zijn vader of zijn moeder vervloekt, die zal zeker ter dood gebracht worden; zijn vader of zijn moeder heeft hij vervloekt, zijn bloedschuld is op hem. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","En een man, die echtbreuk pleegt met iemands vrouw, echtbreuk pleegt met de vrouw van zijn naaste, zal zeker ter dood gebracht worden; zowel de overspeler als de overspeelster. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Een man die gemeenschap heeft met de vrouw van zijn vader, de schaamte zijns vaders heeft hij ontbloot – beiden zullen zeker ter dood gebracht worden, hun bloedschuld is op hen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Een man die gemeenschap heeft met zijn schoondochter – beiden zullen zeker ter dood gebracht worden, schandelijke ontucht hebben zij bedreven, hun bloedschuld is op hen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Een man die gemeenschap heeft met iemand van het mannelijk geslacht, zoals men gemeenschap heeft met een vrouw, – beiden hebben een gruwel gedaan, zij zullen zeker ter dood gebracht worden, hun bloedschuld is op hen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Een man die een vrouw en ook haar moeder neemt – bloedschande is het – met vuur zal men hem en haar verbranden, opdat er geen bloedschande in uw midden zij. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Een man die met een dier gemeenschap heeft, zal zeker ter dood gebracht worden; het dier zal men afmaken. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Een vrouw die tot enig dier nadert, opdat het met haar gemeenschap hebbe – de vrouw en het dier zult gij doden, zij zullen zeker ter dood gebracht worden, hun bloedschuld is op hen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Een man die zijn zuster, de dochter van zijn vader of de dochter van zijn moeder, neemt en haar schaamte ziet en zij ziet zijn schaamte – een schande is het en zij zullen voor de ogen van hun volksgenoten worden uitgeroeid; de schaamte van zijn zuster heeft hij ontbloot, zijn ongerechtigheid zal hij dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Een man die bij een vloeiende vrouw ligt en haar schaamte ontbloot – haar bron heeft hij ontbloot en zij heeft de bron van haar bloed ontbloot; beiden zullen zij uitgeroeid worden uit het midden van hun volk. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","De schaamte van de zuster uwer moeder en van de zuster uws vaders zult gij niet ontbloten, want dan ontbloot men zijn bloedverwant; hun ongerechtigheid zullen zij dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Een man die gemeenschap heeft met zijn tante – de schaamte van zijn oom ontbloot hij; hun zonde zullen zij dragen, kinderloos zullen zij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Een man die de vrouw van zijn broeder neemt – bloedschande is het; de schaamte van zijn broeder heeft hij ontbloot, kinderloos zullen zij zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Neemt dan al mijn inzettingen en al mijn verordeningen nauwgezet in acht, opdat het land, waarheen Ik u breng om daarin te wonen, u niet uitspuwe. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Wandelt niet naar de inzettingen van het volk, dat Ik voor u uit verdrijf: want al deze dingen hebben zij gedaan, zodat Ik een afschuw van hen gekregen heb. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Maar tot u zeide Ik: gij zult hun land in bezit nemen en Ik zal het u geven om het te bezitten, een land vloeiende van melk en honig; Ik ben de Here, uw God, die u van de andere volken heb afgezonderd. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Maakt dan scheiding tussen rein en onrein vee en tussen onreine en reine vogels, opdat gij uzelf niet verfoeilijk maakt door vee en vogels en alles wat op de aarde kruipt, dat Ik u ontzegd heb door het onrein te verklaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Weest Mij heilig, want heilig ben Ik, de Here, en Ik heb u afgezonderd van de volken, opdat gij Mij zoudt toebehoren. ");
INSERT INTO nldnbg_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Wanneer een man of een vrouw door zich de geest van een dode laat spreken of een waarzeggende geest bezit, zullen zij zeker ter dood gebracht worden; stenigen zal men hen, hun bloedschuld is op hen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","En de Here zeide tot Mozes: Spreek tot de priesters, de zonen van Aäron, en zeg tot hen, dat geen hunner zich aan een dode zal verontreinigen onder zijn volksgenoten, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","behalve aan zijn naaste bloedverwant: zijn moeder, zijn vader, zijn zoon, zijn dochter, zijn broeder, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","zijn zuster, die nog ongetrouwd en hem na verwant is, die nog geen man toebehoorde, – aan die mag hij zich verontreinigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Als echtgenoot zal hij zich onder zijn volksgenoten niet verontreinigen en zich daardoor ontheiligen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Zij zullen op hun hoofd geen kale plek maken, noch de rand van hun baard wegscheren noch insnijdingen in hun lichaam maken. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Heilig zullen zij hun God zijn en de naam van hun God zullen zij niet ontheiligen, want zij brengen de vuuroffers des Heren, de spijze van hun God, daarom zullen zij heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Geen ontuchtige of onteerde vrouw zullen zij huwen, en een vrouw die door haar man verstoten is, zullen zij niet nemen, want hij is heilig voor zijn God. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","En gij zult hem heilig houden, want de spijze van uw God offert hij: hij zij u heilig, want heilig ben Ik, de Here, die u heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","En wanneer een priesterdochter zich ontheiligt door ontucht te plegen, dan ontheiligt zij daarmee haar vader; met vuur zal zij verbrand worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","En de priester, die de hoogste is onder zijn broeders, op wiens hoofd de zalfolie is gegoten en die men gewijd heeft, door hem de heilige klederen aan te trekken, zal zijn hoofdhaar niet los laten hangen en zijn klederen niet scheuren. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Bij geen enkele dode zal hij komen; aan zijn vader of moeder zal hij zich niet verontreinigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Het heiligdom zal hij niet verlaten, opdat hij het heiligdom van zijn God niet ontheilige, want de wijding van de zalfolie van zijn God is op hem: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Een vrouw in haar maagdelijke staat zal hij nemen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Een weduwe, een verstotene, een onteerde of ontuchtige vrouw – deze zal hij niet huwen, maar een maagd uit zijn volksgenoten zal hij tot vrouw nemen, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","opdat hij zijn nakomelingen onder zijn volksgenoten niet ontheilige, want Ik ben de Here, die hem heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","En de Here sprak tot Mozes aldus: ");
INSERT INTO nldnbg_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Spreek tot Aäron: Wie van uw nakomelingen in latere geslachten een lichaamsgebrek heeft, zal niet naderen om de spijze van zijn God te offeren, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","want niemand die een lichaamsgebrek heeft, zal naderen: een blinde of een verlamde of iemand met mismaakt gelaat of met te lange leden, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","of iemand die een breuk aan been of arm heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","of een bultenaar of een uitgeteerde, of iemand, die een vlek op zijn oog heeft, of die uitslag of huidziekte heeft, of die geschonden is aan de geslachtsdelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Geen nakomeling van de priester Aäron, die een lichaamsgebrek heeft, zal naderen om de vuuroffers des Heren te brengen; hij heeft een lichaamsgebrek, met de spijze van zijn God zal hij niet naderen om te offeren. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","De spijze van zijn God, zowel van het allerheiligste als van het heilige, mag hij eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Alleen bij het voorhangsel zal hij niet komen en tot het altaar zal hij niet naderen, want hij heeft een lichaamsgebrek; opdat hij mijn heiligdommen niet ontheilige, want Ik ben de Here, die hen heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Zo sprak Mozes tot Aäron en zijn zonen en tot alle Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Spreek tot Aäron en zijn zonen, dat zij, om mijn heilige naam niet te ontheiligen, zich in acht nemen ten aanzien van de heilige gaven die de Israëlieten Mij heiligen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Zeg tot hen: Ieder in uw geslachten, die uit al uw nakomelingen nadert tot de heilige gaven die de Israëlieten de Here heiligen, terwijl zijn onreinheid nog aan hem is, die zal van voor mijn aangezicht uitgeroeid worden: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Geen van Aärons nakomelingen, die melaats is of een vloeiing heeft, zal eten van de heilige gaven, totdat hij gereinigd is; evenmin hij die iets aanraakt, dat onrein geworden is door een dode, of iemand die een zaaduitstorting heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","of iemand die enig kruipend gedierte aanraakt, waardoor hij onrein wordt, of een mens, door wie hij onrein wordt, doordat deze een of andere onreinheid aan zich heeft; ");
INSERT INTO nldnbg_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","hij, die zoiets aanraakt, blijft onrein tot de avond en zal niet eten van de heilige gaven, tenzij hij zijn lichaam in water gebaad heeft. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","En als de zon ondergegaan is, zal hij rein zijn en daarna zal hij van de heilige gaven eten, want het is zijn spijs. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Een gestorven of verscheurd dier zal hij niet eten en zich daardoor niet verontreinigen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","En zij zullen mijn voorschrift in acht nemen, opdat zij deswege geen zonde op zich laden en daardoor sterven, omdat zij dat ontheiligd hebben: Ik ben de Here, die hen heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","En geen onbevoegde zal iets heiligs eten, geen inwonende bij de priester of dagloner zal iets heiligs eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Maar wanneer de priester iemand als eigendom koopt met zijn geld, mag deze daarvan eten, ook zij, die in zijn huis geboren werden, mogen van zijn spijs eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","En wanneer een priesterdochter met iemand, die geen priester is, getrouwd is, dan zal zij van de heffing der heilige gaven niet eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Wanneer echter een priesterdochter weduwe wordt of verstoten wordt en geen kinderen heeft en teruggekeerd is naar haars vaders huis, zoals in haar jeugd, dan mag zij van de spijs haars vaders eten; maar geen onbevoegde zal daarvan eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Wanneer nu iemand zonder opzet iets heiligs gegeten heeft, dan zal hij het heilige de priester vergoeden en een vijfde deel erbij voegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","En zij zullen de heilige gaven die de Israëlieten voor de Here heffen, niet ontheiligen, ");
INSERT INTO nldnbg_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","want zij zouden hen alzo zondeschuld doen dragen, wanneer zij hun heilige gaven zouden eten: want Ik ben de Here, die hen heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Spreek tot Aäron en zijn zonen en tot al de Israëlieten en zeg tot hen: Ieder van het huis Israëls en van de vreemdelingen in Israël, die zijn offergave brengt, overeenkomstig al de geloften en vrijwillige offers, die zij de Here als brandoffer willen offeren: ");
INSERT INTO nldnbg_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","het moet, zo gij welgevallig wilt zijn, gaaf wezen, van het mannelijke geslacht van het rundvee, van de schapen en van de geiten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Niets dat enig gebrek heeft, zult gij offeren; want het zou u geen welgevallen doen vinden. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ook wanneer iemand de Here een vredeoffer brengt, om een gelofte te vervullen of als een vrijwillig offer van runderen of van kleinvee, dan zal het gaaf wezen, opdat het welgevallig zij: geen enkel gebrek zal het hebben. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Wat blind is of gebroken of een wond, buil, uitslag of huidziekte heeft, dat zult gij de Here niet offeren en daarvan zult gij de Here geen vuuroffer op het altaar geven. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Maar een rund of schaap met te lange of te korte leden, dat moogt gij als vrijwillig offer toebereiden, maar als gelofte zal het niet welgevallig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Wat echter door kneuzen, stoten, uitrukken of snijden verminkt is, zult gij de Here niet offeren; dat zult gij in uw land niet doen. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ook uit de hand van een vreemdeling zult gij niets van dat alles uw God als spijze offeren, want zij zijn geschonden, er is een gebrek aan; het zal u niet welgevallig doen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Wanneer een rund of schaap of geit geboren wordt, dan zal dat zeven dagen bij zijn moeder blijven, maar van de achtste dag af en daarna zal het als een gave de Here ten vuuroffer welgevallig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Een rund of een stuk kleinvee zult gij niet tegelijk met zijn jong op één dag slachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","En wanneer gij de Here een lofoffer slacht, zult gij het zo slachten, dat gij welgevallen vindt. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Op dezelfde dag zal het gegeten worden; niets moogt gij daarvan overlaten tot de morgen: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Neemt dan mijn geboden nauwgezet in acht: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","En ontheiligt mijn heilige naam niet, zodat Ik geheiligd worde in het midden der Israëlieten: Ik ben de Here, die u heilig, ");
INSERT INTO nldnbg_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","die u uit het land Egypte deed trekken, opdat Ik u tot een God zou zijn: Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Spreek tot de Israëlieten en zeg tot hen: De feesttijden des Heren, die gij zult uitroepen als heilige samenkomsten, zijn mijn feesttijden. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Zes dagen mag arbeid verricht worden, maar op de zevende dag zal er een volkomen sabbat zijn: een heilige samenkomst; generlei arbeid zult gij verrichten, het is een sabbat voor de Here in al uw woonplaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dit zijn de feesttijden des Heren, heilige samenkomsten, die gij uitroepen zult op de daarvoor bepaalde tijd. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In de eerste maand, op de veertiende der maand, in de avondschemering, is het pascha voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","En op de vijftiende dag van deze maand is het feest der ongezuurde broden voor de Here, zeven dagen zult gij ongezuurde broden eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Op de eerste dag zult gij een heilige samenkomst hebben; dan zult gij generlei slaafse arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Gij zult de Here een vuuroffer brengen gedurende zeven dagen; op de zevende dag zal er een heilige samenkomst zijn; generlei slaafse arbeid zult gij verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Spreek tot de Israëlieten en zeg tot hen: Wanneer gij komt in het land dat Ik u geef, en de oogst daarvan binnenhaalt, dan zult gij de eerstelingsgarve van uw oogst naar de priester brengen, ");
INSERT INTO nldnbg_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","en hij zal de garve voor het aangezicht des Heren bewegen, opdat gij welgevallig zijt; daags na de sabbat zal de priester die bewegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Gij zult op de dag waarop gij de garve beweegt, een gaaf eenjarig schaap de Here ten brandoffer bereiden, ");
INSERT INTO nldnbg_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","met als bijbehorend spijsoffer twee tienden fijn meel, met olie aangemaakt, ten vuuroffer tot een liefelijke reuk voor de Here, en als bijbehorend plengoffer een vierde hin wijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tot op die dag zult gij geen brood, geen geroosterd of vers koren eten, totdat gij de offergave van uw God gebracht hebt: het is een altoosdurende inzetting voor uw geslachten, in al uw woonplaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Dan zult gij tellen van de dag na de sabbat, van de dag waarop gij de garve van het beweegoffer gebracht hebt: zeven volle weken zullen het zijn; ");
INSERT INTO nldnbg_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","tot de dag na de zevende sabbat zult gij tellen, vijftig dagen; dan zult gij een nieuw spijsoffer de Here brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Uit uw woonplaatsen zult gij twee beweegbroden meebrengen; uit twee tienden efa fijn meel zullen zij bereid worden, gezuurd zullen zij gebakken worden, eerstelingen voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bij het brood zult gij zeven gave eenjarige schapen offeren en een jonge stier en twee rammen; zij zullen een brandoffer voor de Here zijn, met de bijbehorende spijsoffers en plengoffers, een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Dan zult gij een geitebok ten zondoffer, en twee eenjarige schapen ten vredeoffer bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","En de priester zal ze bewegen, bij het brood der eerstelingen, als beweegoffer voor het aangezicht des Heren bij de twee schapen: zij zullen de Here heilig zijn, zij zijn voor de priester. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Op deze zelfde dag zult gij een oproep doen uitgaan, gij zult een heilige samenkomst hebben, generlei slaafse arbeid zult gij verrichten; het is een altoosdurende inzetting, in al uw woonplaatsen, voor uw geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Wanneer gij de oogst van uw land binnenhaalt, dan zult gij de rand van uw veld bij uw oogst niet geheel afmaaien, en wat van uw oogst is blijven liggen, zult gij niet oplezen; dat zult gij voor de arme en de vreemdeling laten liggen: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Spreek tot de Israëlieten: In de zevende maand, op de eerste der maand, zult gij een rustdag hebben, aangekondigd door bazuingeschal, een heilige samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Generlei slaafse arbeid zult gij verrichten en gij zult de Here een vuuroffer brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Maar op de tiende van die zevende maand is de Verzoendag; een heilige samenkomst zult gij hebben en gij zult u verootmoedigen en de Here een vuuroffer brengen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Op die dag zult gij generlei arbeid verrichten, want het is de Verzoendag, om over u verzoening te doen voor het aangezicht van de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Want ieder die zich op die dag niet zal verootmoedigen, zal uitgeroeid worden uit zijn volksgenoten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ieder die enige arbeid verricht op die dag, zal Ik verdelgen uit het midden van zijn volk. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Generlei arbeid zult gij verrichten: het is een altoosdurende inzetting voor uw geslachten, in al uw woonplaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Het zal u een volkomen sabbat zijn en gij zult u verootmoedigen. Op de negende van de maand, des avonds, van avond tot avond, zult gij uw sabbat vieren. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Spreek tot de Israëlieten: Op de vijftiende dag van deze zevende maand begint het Loofhuttenfeest voor de Here, zeven dagen lang. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Op de eerste dag zal er een heilige samenkomst zijn; generlei slaafse arbeid zult gij verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Zeven dagen zult gij de Here een vuuroffer brengen; op de achtste dag zult gij een heilige samenkomst hebben en de Here een vuuroffer brengen; het is een feest, generlei slaafse arbeid zult gij verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Dit zijn de feesttijden des Heren, waarop gij heilige samenkomsten zult uitroepen, om de Here een vuuroffer te brengen: brandoffer en spijsoffer, slachtoffer en plengoffers, naar het voorschrift voor iedere dag, ");
INSERT INTO nldnbg_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","behalve de sabbatten des Heren en behalve de gaven en al de gelofteoffers en al de vrijwillige offers, die gij de Here geven wilt. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Doch op de vijftiende dag van de zevende maand, wanneer gij de opbrengst van uw land inzamelt, zult gij zeven dagen het feest des Heren vieren; op de eerste dag zal er rust zijn en op de achtste dag zal er rust zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Op de eerste dag zult gij vruchten van sierlijke bomen nemen, takken van palmen en twijgen van loofbomen en van beekwilgen, en gij zult vrolijk zijn voor het aangezicht van de Here, uw God, zeven dagen lang. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Gij zult het als een feest des Heren vieren zeven dagen in het jaar, een altoosdurende inzetting voor uw geslachten; in de zevende maand zult gij het vieren. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","In loofhutten zult gij wonen zeven dagen; allen die in Israël geboren zijn, zullen in loofhutten wonen, ");
INSERT INTO nldnbg_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","opdat uw geslachten weten, dat Ik de Israëlieten in hutten heb doen wonen, toen Ik hen uit het land Egypte leidde: Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Zo maakte Mozes de feesttijden des Heren aan de Israëlieten bekend. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Gebied de Israëlieten, dat zij tot u brengen zuivere olie, uit gestoten olijven, voor de kandelaar, om voortdurend een lamp te laten branden. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Buiten het voorhangsel der getuigenis in de tent der samenkomst zal Aäron die voortdurend verzorgen, van de avond tot de morgen, voor het aangezicht des Heren. Het is een altoosdurende inzetting voor uw geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Op de kandelaar van louter goud zal hij voortdurend de lampen verzorgen voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","En gij zult fijn meel nemen en daarvan twaalf koeken bakken, uit twee tienden efa zal elke koek bereid worden; ");
INSERT INTO nldnbg_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","gij zult ze op twee stapels leggen, zes op een stapel, op de tafel van louter goud, voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Gij zult zuivere wierook op elke stapel leggen; dit zal dan dienen als gedenkoffer van het brood, een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Elke sabbatdag zal hij dat steeds opnieuw gereed maken voor het aangezicht des Heren; van de zijde der Israëlieten is het een verbond voor altoos. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","En het zal voor Aäron en zijn zonen zijn, en zij zullen het op een heilige plaats eten, want het is allerheiligst voor hem; het behoort tot de vuuroffers des Heren; het is een altoosdurende inzetting. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Eens ging een zoon van een Israëlitische vrouw, die tevens de zoon was van een Egyptisch man onder de Israëlieten, naar buiten, en de zoon van deze Israëlitische en een Israëlitisch man kregen in de legerplaats twist. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","En de zoon van de Israëlitische vrouw lasterde de Naam en vloekte; toen brachten zij hem tot Mozes. De naam nu van zijn moeder was Selomit, de dochter van Dibri, van de stam Dan. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","En zij zetten hem in verzekerde bewaring in afwachting van een beslissing op grond van een uitspraak des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Toen sprak de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Breng de vloeker buiten de legerplaats, en allen die het gehoord hebben, zullen hun handen op zijn hoofd leggen, daarna zal de gehele vergadering hem stenigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","En tot de Israëlieten zult gij zeggen: Een ieder, die zijn God vloekt, zal zijn zonde dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Wie de Naam des Heren lastert, zal zeker ter dood gebracht worden: de gehele vergadering zal hem stenigen: zowel een vreemdeling als een geboren Israëliet, zal, wanneer hij de Naam lastert, ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ook wanneer iemand enig mens doodslaat, zal hij zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Maar wie een stuk vee doodt, zal dat vergoeden: stuk voor stuk. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","En wanneer iemand zijn volksgenoot lichamelijk letsel toebrengt, dan zal hem evenzo gedaan worden als hij gedaan heeft: ");
INSERT INTO nldnbg_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","breuk voor breuk, oog voor oog, tand voor tand; hetzelfde letsel, dat hij een mens heeft toegebracht, zal hem toegebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","En wie een beest doodslaat, zal het vergoeden, maar wie een mens doodslaat, zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Enerlei recht zult gij hebben; de vreemdeling zij gelijk de geboren Israëliet, want Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Zo sprak Mozes tot de Israëlieten; toen brachten zij de vloeker buiten de legerplaats en stenigden hem, en de Israëlieten deden gelijk de Here Mozes bevolen had. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","En de Here sprak tot Mozes op de berg Sinai: ");
INSERT INTO nldnbg_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Spreek tot de Israëlieten en zeg tot hen: Wanneer gij in het land komt, dat Ik u geef, dan zal het land rusten, een sabbat voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Zes jaar zult gij uw akker bezaaien en zes jaar zult gij uw wijngaard snoeien, en de opbrengst daarvan inzamelen, ");
INSERT INTO nldnbg_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","maar in het zevende jaar zal het land een volkomen sabbat hebben, een sabbat voor de Here: uw akker zult gij niet bezaaien en uw wijngaard niet snoeien. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Wat vanzelf opkomt van uw oogst, zult gij niet inoogsten en de druiven van uw ongesnoeide wijnstok zult gij niet inzamelen; het zal een jaar van rust voor het land zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","De sabbatopbrengst van het land zal u tot voedsel zijn: u en uw slaaf en uw slavin, uw dagloner en uw bijwoner, die bij u vertoeven. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ook voor uw vee en voor het gedierte, dat in uw land is, zal de gehele opbrengst daarvan tot voedsel zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Voorts zult gij u zeven jaarsabbatten tellen, zevenmaal zeven jaren; zodat de dagen van de zeven jaarsabbatten negenenveertig jaren zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Dan zult gij bazuingeschal doen rondgaan in de zevende maand op de tiende van de maand; op de Verzoendag zult gij de bazuin doen rondgaan door uw ganse land. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Gij zult het vijftigste jaar heiligen en vrijheid in het land afkondigen voor al zijn bewoners, een jubeljaar zal het voor u zijn, dan zal ieder van u tot zijn bezitting en tot zijn geslacht terugkeren. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Een jubeljaar zal dit vijftigste jaar voor u zijn, dan zult gij niet zaaien, en wat dan vanzelf opkomt zult gij niet oogsten en dan zult gij de ongesnoeide wijnstok niet aflezen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Want het zal u een jubeljaar zijn, heilig zal het u zijn; van de akker zult gij eten wat hij opbrengt. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In dit jubeljaar zal ieder van u zijn bezitting terugkrijgen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wanneer gij iets aan uw volksgenoot verkoopt of iets van hem koopt, dan zal de een de ander niet benadelen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Rekening houdend met de jaren na een jubeljaar, zult gij het van uw volksgenoot kopen; rekening houdend met de oogstjaren zal hij het u verkopen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Bij een groter aantal jaren zult gij de koopsom naar verhouding hoger stellen; bij een geringer aantal jaren zult gij de koopsom naar verhouding lager stellen: want het getal der oogsten verkoopt hij u. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Gij zult elkander niet benadelen, maar voor uw God vrezen, want Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Zo zult gij mijn inzettingen opvolgen en mijn verordeningen nauwgezet in acht nemen; dan zult gij veilig wonen in het land. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","En het land zal zijn vrucht geven, zodat gij tot verzadiging eet en daarin veilig woont. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Wanneer gij zegt: wat zullen wij in het zevende jaar eten, zie, wij mogen niet zaaien noch onze oogst inhalen – ");
INSERT INTO nldnbg_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","dan zal Ik mijn zegen in het zesde jaar over u gebieden, dat het u een opbrengst geve voor drie jaren. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","In het achtste jaar zult gij zaaien, maar van de vorige oogst eten, tot het negende jaar; totdat de oogst daarvan binnenkomt, zult gij van de vorige eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","En het land zal niet voor altijd verkocht worden, want het land is van Mij, en gij zijt vreemdelingen en bijwoners bij Mij. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","In het gehele land, dat gij in bezit hebt, zult gij lossing voor het land toestaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wanneer uw broeder verarmd is en iets van zijn bezitting heeft moeten verkopen, dan zal zijn naaste bloedverwant als losser optreden, en hij zal loskopen wat zijn broeder heeft moeten verkopen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Wanneer iemand geen losser heeft, maar zijn vermogen wordt toereikend, zodat hij verwerft, wat hij voor lossing nodig heeft, ");
INSERT INTO nldnbg_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","dan zal hij de jaren sinds de verkoop in rekening brengen, en wat nog overblijft de man terugbetalen aan wie hij het verkocht heeft, opdat hij zijn bezitting terugkrijgt. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Maar indien hij niet verwerft wat nodig is, om hem terug te betalen, dan blijft wat hij verkocht heeft, in het bezit van hem die het gekocht heeft, tot het jubeljaar: maar in het jubeljaar zal het vrijkomen, en hij zal zijn bezitting terugkrijgen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Wanneer iemand een woonhuis verkoopt in een ommuurde stad, dan zal het recht van lossing duren tot er een jaar na de verkoop verstreken is; een jaar zal het recht van lossing duren. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Maar indien het niet gelost is, voordat een vol jaar verstreken is, dan komt dat huis, dat in een ommuurde stad stond, voorgoed aan hem die het gekocht heeft, in zijn geslacht: in het jubeljaar zal het niet vrijkomen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","De huizen echter in de dorpen, waar geen muur om is, zullen bij het akkerland gerekend worden, daarvoor zal wel recht van lossing zijn en in het jubeljaar zullen zij vrijkomen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","En aangaande de steden der Levieten, de huizen der steden, die zij in bezit hebben – de Levieten zullen een altoosdurend recht van lossing hebben. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Als iemand van de Levieten het inlost, dan zal het verkochte huis, in de stad van zijn bezit, in het jubeljaar vrijkomen; want de huizen van de steden der Levieten zijn hun bezit in het midden van de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","En het weideland bij hun steden zal niet verkocht worden, want dat is hun altoosdurend bezit. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Wanneer uw broeder verarmt en zich bij u niet meer staande kan houden, dan zult gij hem – vreemdeling en bijwoner – ondersteunen, opdat hij bij u in het leven blijve. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Gij zult geen rente of winst van hem nemen, maar gij zult voor uw God vrezen, opdat uw broeder bij u in het leven blijve. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Gij zult hem uw geld niet op rente geven noch uw voedsel tegen winst. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ik ben de Here, uw God, die u uit het land Egypte heb geleid, om u het land Kanaän te geven, opdat Ik u tot een God zou zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Wanneer uw broeder verarmt bij u en zich aan u verkoopt, dan zult gij hem geen slavenarbeid laten verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Als een dagloner, als een bijwoner zal hij bij u zijn; tot het jubeljaar zal hij bij u arbeiden. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dan zal hij van u weggaan, hij met zijn kinderen, en naar zijn geslacht terugkeren en hij zal het bezit zijner vaderen terugkrijgen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Want zij zijn mijn knechten, die Ik uit het land Egypte heb geleid: zij zullen niet verkocht worden, zoals men een slaaf verkoopt. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Gij zult niet met hardheid over hem heersen, maar gij zult voor uw God vrezen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Doch uw slaaf of slavin, die gij houdt, zullen zijn uit de volken rondom u; uit hen zult gij een slaaf of slavin kopen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ook uit de kinderen der bijwoners die bij u vertoeven, uit hen zult gij ze kopen en uit hun geslacht, dat bij u is, dat zij in uw land hebben voortgebracht, en zij zullen uw bezit zijn; ");
INSERT INTO nldnbg_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","gij zult hen aan uw kinderen na u tot een erfenis geven, zodat zij in hun bezit overgaan; voor altoos zult gij hen in dienst houden, maar over uw broeders, de Israëlieten, zult gij niet, de een over de ander, met hardheid heersen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Wanneer het vermogen van een vreemdeling of bijwoner bij u toeneemt, en uw broeder bij hem verarmt en zich aan die vreemdeling of bijwoner bij u, of aan iemand die uit een geslacht van vreemdelingen afkomstig is, verkoopt, ");
INSERT INTO nldnbg_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","dan zal hij, nadat hij zich verkocht heeft, recht van lossing hebben: een van zijn broeders mag hem loskopen; ");
INSERT INTO nldnbg_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","of zijn oom of de zoon van zijn oom mag hem loskopen, of zijn naastbestaande uit zijn geslacht mag hem loskopen, of, als zijn vermogen toereikend wordt, mag hij zich zelf loskopen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Dan zal hij samen met zijn koper een berekening maken van het jaar af, dat hij zich aan hem verkocht, tot het jubeljaar, en de prijs van zijn verkoop zal zich richten naar het aantal jaren; op de wijze van een dagloner zal hij bij hem zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Indien het nog vele jaren zijn, zal hij dienovereenkomstig zijn losgeld terugbetalen van het geld, waarvoor hij was gekocht. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Indien er weinige jaren overblijven tot het jubeljaar, dan zal hij met hem een berekening maken; overeenkomstig die jaren zal hij zijn losgeld terugbetalen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Zo zal hij als een dagloner van jaar tot jaar bij hem zijn; deze zal bij u niet met hardheid over hem heersen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Maar indien hij op deze wijze niet gelost wordt, dan komt hij in het jubeljaar vrij, hij met zijn kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Want de Israëlieten zijn Mij tot knechten: mijn knechten zijn zij, die Ik uit het land Egypte heb geleid; Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Gij zult u geen afgoden maken; een gesneden beeld noch een gewijde steen zult gij u oprichten; ook een steen met beeldhouwwerk zult gij in uw land niet zetten, om u daarvoor neder te buigen, want Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mijn sabbatten zult gij houden en mijn heiligdom ontzien, Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Indien gij in mijn inzettingen wandelt en mijn geboden nauwgezet in acht neemt, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","dan zal Ik u te rechter tijd uw regens geven, zodat het land zijn opbrengst geeft en het geboomte des velds zijn vrucht draagt; ");
INSERT INTO nldnbg_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","de dorstijd zal bij u duren tot de wijnoogst, en de wijnoogst tot de zaaitijd; gij zult uw brood eten tot verzadiging en veilig in uw land wonen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","En Ik zal vrede in het land geven, zodat gij nederliggen zult, zonder dat iemand u opschrikt; Ik zal de wilde dieren uit het land uitroeien, en het zwaard zal uw land niet teisteren. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","En gij zult uw vijanden vervolgen, en zij zullen voor uw aangezicht door het zwaard vallen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vijf van u zullen honderd achtervolgen, en honderd van u zullen tienduizend achtervolgen, en uw vijanden zullen voor uw aangezicht door het zwaard vallen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","En Ik zal Mij tot u wenden, u vruchtbaar doen zijn en u talrijk maken, en Ik zal mijn verbond met u bevestigen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","En gij zult het overjarige, dat overgebleven is, eten, en het overjarige zult gij vóór het nieuwe moeten wegdoen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","En Ik zal mijn tabernakel in uw midden zetten, en Ik zal geen afkeer van u hebben, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","maar Ik zal in uw midden wandelen en u tot een God zijn en gij zult Mij tot een volk zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ik ben de Here, uw God, die u uit het land Egypte heb geleid, opdat gij hun niet meer tot slaven zoudt zijn; Ik heb de stangen van uw juk verbroken en u rechtop doen gaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Maar indien gij naar Mij niet luistert en al deze geboden niet doet, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","indien gij mijn inzettingen versmaadt en van mijn verordeningen een afkeer hebt, zodat gij geen van mijn geboden doet en mijn verbond verbreekt, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","dan zal Ik ook aldus met u doen en met verschrikking u bezoeken: tering en koorts, die de ogen verteren en het leven doen verkwijnen; dan zult gij tevergeefs uw zaad zaaien, want uw vijanden zullen het eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ik zal mijn aangezicht tegen u keren, zodat gij voor uw vijanden geslagen zult worden, en die u haten, zullen over u heersen, en gij zult vluchten, zonder dat iemand u vervolgt. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","En indien gij desniettegenstaande niet naar Mij luistert, dan zal Ik u blijven tuchtigen wegens uw zonden, tot zevenmaal toe, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","en uw trotse macht zal Ik breken en uw hemel maken als ijzer en uw land als koper. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Dan zal uw kracht tevergeefs verbruikt worden; uw land zal zijn opbrengst niet geven en het geboomte des lands zal zijn vrucht niet dragen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Indien gij u tegen Mij verzet en naar Mij niet wilt luisteren, dan zal Ik u nog zevenmaal harder slaan, naar uw zonden; ");
INSERT INTO nldnbg_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ik zal het wild gedierte op u loslaten, dat u van kinderen beroven en uw vee uitroeien zal en uw aantal zo zal verminderen, dat uw wegen verlaten zullen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Indien gij u door deze tuchtiging nog niet tot Mij keert en u tegen Mij blijft verzetten, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","dan zal ook Ik Mij tegen u verzetten en dan zal Ik u ook zevenmaal slaan wegens uw zonden, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","en over u een zwaard brengen, dat wraak neemt over het verbond; wanneer gij dan in uw steden bijeenkomt, dan zal Ik de pest onder u zenden en gij zult aan de vijand overgeleverd worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Als Ik u de staf des broods verbreek, dan zullen tien vrouwen uw brood in één oven bakken en zij zullen uw brood afgewogen teruggeven, en gij zult eten, maar niet verzadigd worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","En indien gij desondanks niet naar Mij luistert en u tegen Mij blijft verzetten, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","dan zal Ik Mij met grimmigheid tegen u verzetten en Ik, ja Ik, zal u zevenmaal tuchtigen over uw zonden, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","en gij zult het vlees uwer zonen eten en het vlees uwer dochters zult gij eten. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","En uw hoogten zal Ik verwoesten en uw wierookaltaren uitroeien; Ik zal uw lijken werpen op de lijken uwer afgoden en Ik zal een afkeer van u hebben. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Uw steden zal Ik tot een puinhoop maken en uw heiligdommen verwoesten en Ik wil niet meer uw liefelijke reuk ruiken. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ik zelf zal het land verwoesten, zodat uw vijanden, die daarin wonen, zich daarover zullen ontzetten. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Maar u zal Ik onder de volken verstrooien en Ik zal achter u het zwaard trekken, en uw land zal een woestenij zijn en uw steden een puinhoop. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Dan zal het land zijn sabbatsjaren vergoed krijgen, al de dagen dat het woest ligt en gij in het land uwer vijanden zijt; dan zal het land rusten en zijn sabbatsjaren vergoeden. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Al de tijd der verwoesting zal het rusten, de rust die het niet gehad heeft gedurende uw sabbatsjaren, toen gij daarin woondet. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","En Ik zal vrees brengen in de harten van hen die van u zijn overgebleven, in de landen hunner vijanden, zodat het geluid van een opgewaaid blad hen opjaagt, en zij zullen vluchten, zoals men vlucht voor het zwaard, en vallen, zonder dat er een vervolger is. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","En de een zal over de ander struikelen als voor het zwaard, zonder dat er een vervolger is, en gij zult voor uw vijanden geen stand kunnen houden. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","En gij zult onder de volken te gronde gaan, en het land uwer vijanden zal u verteren. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","En wie van u overgebleven zijn, zullen in de landen hunner vijanden wegkwijnen vanwege hun ongerechtigheid en ook vanwege de ongerechtigheden hunner vaderen zullen zij, evenals dezen, wegkwijnen. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Maar belijden zij hun ongerechtigheid en die hunner vaderen, in de ontrouw waarmede zij tegen Mij ontrouw zijn geweest, en ook dat zij zich tegen Mij verzet hebben, – ");
INSERT INTO nldnbg_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ook Ik verzette Mij tegen hen en bracht hen in het land hunner vijanden – of vernedert zich dan hun onbesneden hart en boeten zij dan hun ongerechtigheid, ");
INSERT INTO nldnbg_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","dan zal Ik mijn verbond met Jakob gedenken; ook mijn verbond met Isaak en ook mijn verbond met Abraham zal Ik gedenken, en Ik zal het land gedenken. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Maar het land zal door hen verlaten worden en het zal zijn sabbatsjaren vergoed krijgen, terwijl het verwoest ligt zonder hen, en zij zullen hun ongerechtigheid boeten, omdat, ja, omdat zij mijn verordeningen versmaadden en van mijn inzettingen een afkeer hadden. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Maar ook zelfs, wanneer zij in het land hunner vijanden zijn, versmaad Ik hen niet en heb Ik geen afkeer van hen, zodat Ik hen zou vernietigen en mijn verbond met hen verbreken: want Ik ben de Here, hun God. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maar Ik zal hun ten goede gedenken het verbond met hun voorvaderen, die Ik voor de ogen der volken uit het land Egypte heb geleid, om hun tot een God te zijn. Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dit zijn de inzettingen en verordeningen en wetten, die de Here gegeven heeft tussen Zich en de Israëlieten op de berg Sinai, door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Spreek tot de Israëlieten en zeg tot hen: Wanneer iemand een gelofte aflegt, naar uw schatting van personen voor de Here, ");
INSERT INTO nldnbg_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","dan zal uw schatting zijn voor iemand van het mannelijk geslacht van twintig tot zestig jaar, – uw schatting zal zijn vijftig sikkels zilver, naar de heilige sikkel; ");
INSERT INTO nldnbg_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","maar indien het iemand van het vrouwelijk geslacht is, dan zal uw schatting dertig sikkels zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Indien het iemand is van vijf tot twintig jaar, dan zal uw schatting zijn voor iemand van het mannelijk geslacht twintig sikkels en voor iemand van het vrouwelijk geslacht tien sikkels. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Indien het een kind is van een maand tot vijf jaar, dan zal uw schatting zijn voor een van het mannelijk geslacht vijf sikkels zilver en voor een van het vrouwelijk geslacht drie sikkels zilver. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Indien het iemand is van zestig jaar of daarboven, indien het iemand van het mannelijk geslacht is, dan zal uw schatting zijn vijftien sikkels, en voor iemand van het vrouwelijk geslacht tien sikkels. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Maar indien hij te arm is om uw schatting te betalen, dan zal men hem voor de priester stellen, en de priester zal hem schatten; overeenkomstig het vermogen van hem die de gelofte deed, zal de priester hem schatten. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","En indien het vee is, waarvan men de Here een offergave brengt, dan zal alles wat men daarvan de Here geeft, heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Men zal het niet verwisselen noch verruilen, goed voor slecht of slecht voor goed. Maar indien men toch een stuk vee voor een ander verruilt, dan zal dit zowel als het daarvoor verruilde heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Indien het enig stuk onrein vee is, waarvan men de Here geen offergave mag brengen, dan zal men dat dier voor de priester stellen, ");
INSERT INTO nldnbg_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","en de priester zal het schatten naar dat het goed of slecht is; zoals de priester het schat, zal het zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","En indien men het toch wil lossen, dan zal men een vijfde deel bij de geschatte waarde voegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Wanneer iemand zijn huis heiligt als iets heiligs voor de Here, dan zal de priester het schatten, naar dat het goed of slecht is; zoals de priester het schat, zo zal het vaststaan. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Maar indien hij, die geheiligd heeft, zijn huis wil lossen, zal hij een vijfde deel van het geld van de geschatte waarde daarbij voegen; dan zal het van hem zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Indien iemand een deel van zijn grondbezit de Here heiligt, dan zal uw schatting zijn overeenkomstig het daarin gezaaide: een homer zaaisel van gerst op vijftig sikkels zilver. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Indien hij van het jubeljaar af zijn akker heiligt, zal het op de geschatte waarde blijven staan. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Maar indien hij na het jubeljaar zijn akker heiligt, zal de priester hem het geld berekenen overeenkomstig de jaren die nog overblijven tot het jubeljaar, en het zal van de geschatte waarde afgetrokken worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","En indien hij, die de akker geheiligd heeft, erop staat die te lossen, dan zal hij een vijfde deel van het geld van de geschatte waarde daar bijvoegen, en die akker zal de zijne blijven. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Maar indien hij de akker niet lost, of indien hij de akker aan iemand anders verkocht heeft, dan kan die niet meer gelost worden, ");
INSERT INTO nldnbg_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","maar de akker zal, wanneer die in het jubeljaar vrijkomt, de Here heilig zijn, gelijk een akker, die onder de ban ligt; de priester zal hem in bezit hebben. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","En indien hij een akker, die hij gekocht heeft, die niet tot zijn grondbezit behoorde, de Here heiligt, ");
INSERT INTO nldnbg_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","zal de priester hem het bedrag van de geschatte waarde tot het jubeljaar berekenen, en hij zal deze geschatte waarde op die dag geven, als iets heiligs voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In het jubeljaar komt die akker terug aan hem van wie hij hem gekocht heeft, aan hem die het land oorspronkelijk in bezit had. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","En al de geschatte waarde zal naar de heilige sikkel zijn: twintig gera zal die sikkel zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Het eerstgeborene echter, dat als eerstgeborene de Here toebehoort onder het vee, zal niemand heiligen, hetzij een rund, hetzij een stuk kleinvee, het is van de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Maar indien het van een stuk onrein vee is, dan zal men het naar de geschatte waarde loskopen en het vijfde deel daarvan erbij voegen, en indien het niet gelost wordt, dan zal het verkocht worden naar de geschatte waarde. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Niets echter van hetgeen iemand de Here door de ban wijdt, uit al wat hij bezit, van mens of vee, of zijn grondbezit, zal verkocht worden of gelost: alles wat onder de ban ligt, dat is allerheiligst voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Niets, dat met de ban geslagen is, dat door de ban getroffen is onder de mensen, kan losgekocht worden; het zal zeker ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ook is alle tiende van het land, van het zaad des lands, van de vrucht van het geboomte, van de Here; het is de Here heilig. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Maar indien iemand toch van zijn tiende zal willen lossen, dan zal hij het vijfde deel daarvan erbij voegen. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","En alle tienden van runderen of kleinvee, al wat onder de staf doorgaat, het tiende daarvan zal de Here heilig zijn. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Men zal niet onderzoeken, of het goed of slecht is, en men zal het niet verruilen; indien men het toch verruilt, dan zal dit zowel als het verruilde de Here heilig zijn; het zal niet gelost worden. ");
INSERT INTO nldnbg_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dit zijn de geboden, die de Here Mozes gegeven heeft voor de Israëlieten op de berg Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","De Here sprak tot Mozes in de woestijn Sinai, in de tent der samenkomst, op de eerste dag der tweede maand in het tweede jaar na hun uittocht uit het land Egypte: ");
INSERT INTO nldnbg_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Neemt het aantal op van de gehele vergadering der Israëlieten naar hun geslachten en families, overeenkomstig het aantal namen, allen die van het mannelijk geslacht zijn, hoofd voor hoofd, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","van twintig jaar oud en daarboven, allen die in het leger uitrukken in Israël; gij zult hen tellen naar hun legerscharen, gij en Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Daarbij zal u uit elke stam één man behulpzaam zijn, de man, die het hoofd is van zijn families. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","En dit zijn de namen der mannen die u ter zijde zullen staan: van Ruben Elisur, de zoon van Sedeür; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","van Simeon Selumiël, de zoon van Surisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","van Juda Nachson, de zoon van Amminadab; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","van Issakar Netanel, de zoon van Suar; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","van Zebulon Eliab, de zoon van Chelon; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","van de zonen van Jozef: van Efraïm Elisama, de zoon van Ammihud; van Manasse Gamliël, de zoon van Pedasur; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","van Benjamin Abidan, de zoon van Gidoni; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","van Dan Achiëzer, de zoon van Ammisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","van Aser Pagiël, de zoon van Okran; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","van Gad Eljasaf, de zoon van Reüel; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","van Naftali Achira, de zoon van Enan. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Dit zijn degenen die uit de vergadering moeten worden opgeroepen, vorsten van de stammen hunner vaderen; hoofden van Israëls geslachten zijn zij. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Toen namen Mozes en Aäron deze met name aangewezen mannen, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","en zij riepen op de eerste dag der tweede maand de gehele vergadering samen, die zich opstelde volgens geslachten en families, overeenkomstig het aantal namen, van twintig jaar oud en daarboven, hoofd voor hoofd, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","zoals de Here Mozes geboden had. En hij telde hen in de woestijn Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","De zonen nu van Ruben, Israëls eerstgeborene, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen, hoofd voor hoofd, allen die van het mannelijk geslacht waren, van twintig jaar oud en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","de getelden van de stam Ruben waren zesenveertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Van de zonen van Simeon, hun nakomelingen naar hun geslachten en families overeenkomstig het aantal namen, hoofd voor hoofd, allen die van het mannelijk geslacht waren, van twintig jaar oud en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","de getelden van de stam Simeon waren negenenvijftigduizend driehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Van de zonen van Gad, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","de getelden van de stam Gad waren vijfenveertigduizend zeshonderd vijftig. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Van de zonen van Juda, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","de getelden van de stam Juda waren vierenzeventigduizend zeshonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Van de zonen van Issakar, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","de getelden van de stam Issakar waren vierenvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Van de zonen van Zebulon, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","de getelden van de stam Zebulon waren zevenenvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Van de zonen van Jozef, van de zonen van Efraïm, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","de getelden van de stam Efraïm waren veertigduizend vijfhonderd; ");
INSERT INTO nldnbg_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","van de zonen van Manasse, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","de getelden van de stam Manasse waren tweeëndertigduizend tweehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Van de zonen van Benjamin, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","de getelden van de stam Benjamin waren vijfendertigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Van de zonen van Dan, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","de getelden van de stam Dan waren tweeënzestigduizend zevenhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Van de zonen van Aser, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","de getelden van de stam Aser waren eenenveertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Van de zonen van Naftali, hun nakomelingen naar hun geslachten en families, overeenkomstig het aantal namen van wie twintig jaar oud was en daarboven, allen die in het leger uitrukten, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","de getelden van de stam Naftali waren drieënvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dit zijn de getelden, die Mozes telde met Aäron en de vorsten Israëls, twaalf man; ieder vertegenwoordigde zijn families. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Dus waren al de getelden der Israëlieten, naar hun families, van twintig jaar oud en daarboven, allen die in het leger uitrukten in Israël, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","al de getelden waren zeshonderddrieduizend vijfhonderd vijftig. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Maar de Levieten naar de stam hunner vaderen werden niet samen met hen geteld. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","De Here had namelijk tot Mozes gesproken: ");
INSERT INTO nldnbg_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Slechts de stam Levi zult gij niet tellen, noch hun aantal onder de Israëlieten opnemen, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","maar stel gij de Levieten over de tabernakel der getuigenis en over al zijn gerei en over al zijn toebehoren; zij zullen de tabernakel en al zijn gerei dragen; zij zullen daarbij dienst doen en zich rondom de tabernakel legeren. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wanneer de tabernakel moet opbreken, dan zullen de Levieten hem uit elkander nemen, en wanneer de tabernakel moet legeren, dan zullen de Levieten hem oprichten, maar de onbevoegde, die nadert, zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Terwijl de Israëlieten zich zullen legeren, ieder bij zijn legerplaats en zijn vendel, naar hun legerscharen, ");
INSERT INTO nldnbg_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","zullen de Levieten zich rondom de tabernakel der getuigenis legeren, opdat er geen toorn ruste op de vergadering der Israëlieten; de Levieten zullen zorg dragen voor de tabernakel der getuigenis. ");
INSERT INTO nldnbg_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","En de Israëlieten deden het; juist zoals de Here Mozes geboden had, deden zij. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","De Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","De Israëlieten zullen zich legeren ieder bij zijn vendel onder de veldtekenen van hun families; op een afstand zullen zij zich rondom de tent der samenkomst legeren. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Aan de oostzijde, aan de kant waar de zon opgaat, zal het vendel van de legerplaats van Juda zich legeren naar hun legerscharen. De vorst nu der zonen van Juda was Nachson, de zoon van Amminadab; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","en zijn leger, dat uit hun getelden bestond, bedroeg vierenzeventigduizend zeshonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Naast hem zal de stam Issakar zich legeren. De vorst nu der zonen van Issakar was Netanel, de zoon van Suar; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","en zijn leger, dat uit zijn getelden bestond, bedroeg vierenvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Voorts de stam Zebulon: de vorst nu der zonen van Zebulon was Eliab, de zoon van Chelon; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","en zijn leger, dat uit zijn getelden bestond, bedroeg zevenenvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Al de getelden van de legerplaats van Juda waren honderdzesentachtigduizend vierhonderd naar hun legerscharen. Zij zullen het eerst opbreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Het vendel van de legerplaats van Ruben zal aan de zuidzijde zijn, naar hun legerscharen. De vorst nu der zonen van Ruben was Elisur, de zoon van Sedeür; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","en zijn leger, dat uit zijn getelden bestond, bedroeg zesenveertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Naast hem zal de stam Simeon zich legeren. De vorst nu der zonen van Simeon was Selumiël, de zoon van Surisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","en zijn leger, dat uit hun getelden bestond, bedroeg negenenvijftigduizend driehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Voorts de stam Gad: de vorst nu der zonen van Gad van Eljasaf, de zoon van Reüel; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","en zijn leger dat uit hun getelden bestond, bedroeg vijfenveertigduizend zeshonderd vijftig. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Al de getelden van de legerplaats van Ruben waren honderdeenenvijftigduizend vierhonderd vijftig naar hun legerscharen. Zij zullen in de tweede plaats opbreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","De tent der samenkomst nu, de legerplaats der Levieten, zal te midden van de legerplaatsen opbreken; zoals zij zich zullen legeren, zullen zij ook opbreken, ieder op zijn plaats naar hun vendels. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Het vendel van de legerplaats van Efraïm naar hun legerscharen zal aan de westzijde zijn. De vorst nu der zonen van Efraïm was Elisama, de zoon van Ammihud; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","en zijn leger, dat uit hun getelden bestond, bedroeg veertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Naast hem de stam Manasse: de vorst nu der zonen van Manasse was Gamliël, de zoon van Pedasur; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","en zijn leger, dat uit hun getelden bestond, bedroeg tweeëndertigduizend tweehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Voorts de stam Benjamin: de vorst nu der zonen van Benjamin was Abidan, de zoon van Gidoni; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","en zijn leger, dat uit hun getelden bestond, bedroeg vijfendertigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Al de getelden van de legerplaats van Efraïm waren honderdachtduizend éénhonderd, naar hun legerscharen. Zij zullen in de derde plaats opbreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Het vendel van de legerplaats van Dan zal aan de noordzijde zijn, naar hun legerscharen. De vorst nu der zonen van Dan was Achiëzer, de zoon van Ammisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","en zijn leger, dat uit hun getelden bestond, bedroeg tweeënzestigduizend zevenhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Naast hem zal de stam Aser zich legeren: de vorst nu der zonen van Aser was Pagiël, de zoon van Okran; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","en zijn leger, dat uit hun getelden bestond, bedroeg eenenveertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Voorts de stam Naftali: de vorst nu der zonen van Naftali was Achira, de zoon van Enan; ");
INSERT INTO nldnbg_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","en zijn leger, dat uit hun getelden bestond, bedroeg drieënvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Al de getelden van de legerplaats van Dan waren honderdzevenenvijftigduizend zeshonderd. Zij zullen naar hun vendels het laatst opbreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Dit waren de getelden der Israëlieten naar hun families; al de getelden der legerplaatsen naar hun legerscharen waren zeshonderddrieduizend vijfhonderd vijftig. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","De Levieten echter werden niet samen met de Israëlieten geteld, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","En de Israëlieten deden het; juist zoals de Here Mozes geboden had, legerden zij zich naar hun vendels, en braken zij op, ieder naar zijn geslacht, bij zijn familie. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dit nu waren de nakomelingen van Aäron en Mozes ten dage, dat de Here met Mozes sprak op de berg Sinai. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Dit waren de namen der zonen van Aäron: de eerstgeborene was Nadab, voorts Abihu, Eleazar en Itamar. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Dit waren de namen der zonen van Aäron, de gezalfde priesters, die hij gewijd had om het priesterambt te bekleden. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadat Nadab en Abihu voor het aangezicht des Heren gestorven waren in de woestijn Sinai, toen zij vreemd vuur vóór de Here brachten – zij hadden geen zonen – bekleedden Eleazar en Itamar het priesterambt tijdens het leven van hun vader Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Laat de stam Levi aantreden en stel hem voor het aangezicht van de priester Aäron, opdat zij hem dienen, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","en zij zullen hun taak vervullen te zijnen behoeve en ten behoeve van de gehele vergadering vóór de tent der samenkomst, door de dienst bij de tabernakel te verrichten; ");
INSERT INTO nldnbg_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","zij zullen zorg dragen voor al het gerei van de tent der samenkomst, en hun taak vervullen ten behoeve van de Israëlieten door de dienst bij de tabernakel te verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Gij zult de Levieten schenken aan Aäron en zijn zonen; uit de Israëlieten zullen dezen hem onvoorwaardelijk geschonken zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Maar aan Aäron en zijn zonen zult gij opdragen hun priesterambt waar te nemen; doch de onbevoegde, die nadert, zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Zie, Ik zelf neem uit de Israëlieten de Levieten in plaats van alle eerstgeborenen der Israëlieten, die het eerst uit de moederschoot voortkomen, opdat de Levieten mijn eigendom zijn, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","want alle eerstgeborenen zijn mijn eigendom. Ten dage, dat Ik alle eerstgeborenen in het land Egypte sloeg, heiligde Ik Mij alle eerstgeborenen in Israël, zowel van mens als van dier; zij zijn mijn eigendom; Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","En de Here sprak tot Mozes in de woestijn Sinai: ");
INSERT INTO nldnbg_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Tel de Levieten naar hun families en geslachten; allen die van het mannelijk geslacht zijn, van één maand oud en daarboven, die zult gij tellen. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Toen telde Mozes hen naar het bevel des Heren, zoals geboden was. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Dit nu waren de namen der zonen van Levi: Gerson, Kehat en Merari. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Dit waren de namen der zonen van Gerson naar hun geslachten: Libni en Simi. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","De zonen van Kehat naar hun geslachten waren Amram, Jishar, Chebron en Uzziël. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","En de zonen van Merari naar hun geslachten waren Machli en Musi. Dit zijn de geslachten der Levieten naar hun families. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Tot Gerson behoorde het geslacht der Libnieten en dat der Simieten; dit waren de geslachten der Gersonieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Hun getelden, overeenkomstig het aantal van allen die van het mannelijk geslacht waren, van één maand oud en daarboven, waren zevenduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","De geslachten der Gersonieten legerden zich achter de tabernakel aan de westzijde. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","En het familiehoofd der Gersonieten was Eljasaf, de zoon van Laël. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","De Gersonieten nu hadden bij de tent der samenkomst, zowel tabernakel als tent, de zorg voor de dakbedekking, het voorhangsel voor de ingang van de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","de gordijnen van de voorhof en het voorhangsel voor de ingang van de voorhof, die rondom de tabernakel en het altaar was, en de daarbij behorende touwen, naar alles wat daaraan te doen was. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Tot Kehat behoorde het geslacht der Amramieten, dat der Jisharieten, dat der Chebronieten en dat der Uzziëlieten; dit waren de geslachten der Kehatieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Hun getelden, overeenkomstig het aantal van allen die van het mannelijk geslacht waren, van één maand oud en daarboven, waren achtduizend zeshonderd: zij hadden de zorg voor het heilige. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","De geslachten der Kehatieten legerden zich langs de tabernakel aan de zuidzijde. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","En het familiehoofd van de geslachten der Kehatieten was Elisafan, de zoon van Uzziël. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Zij hadden de zorg voor de ark, de tafel, de kandelaar, de altaren, het heilige gerei, waarmede men de dienst verrichtte, het voorhangsel en alles wat daaraan te doen was. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Het opperste hoofd nu der Levieten was Eleazar, de zoon van de priester Aäron, die het opzicht had over hen, die de zorg hadden voor het heilige. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Tot Merari behoorde het geslacht der Machlieten en dat der Musieten; dit waren de geslachten van Merari. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Hun getelden, overeenkomstig het aantal van allen die van het mannelijk geslacht waren, van één maand oud en daarboven, waren zesduizend tweehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","En het familiehoofd der geslachten van Merari was Suriël, de zoon van Abichaïl. Zij legerden zich langs de tabernakel aan de noordzijde. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Aan de Merarieten was opgedragen de zorg voor de planken van de tabernakel, zijn balken, zijn pilaren, zijn voetstukken, al zijn gerei en alles wat daaraan te doen was, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","eveneens voor de pilaren van de voorhof rondom, de voetstukken, de pinnen en de touwen daarvan. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Voorts legerden zich vóór de tabernakel aan de oostzijde, vóór de tent der samenkomst aan de kant, waar de zon opgaat, Mozes en Aäron en diens zonen, die de zorg hadden voor het heiligdom namens de Israëlieten; maar de onbevoegde, die naderde, moest ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Al de getelden der Levieten, die Mozes met Aäron naar het bevel des Heren naar hun geslachten telde, allen van het mannelijk geslacht, van één maand oud en daarboven, waren tweeëntwintigduizend. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Toen zeide de Here tot Mozes: Tel alle mannelijke eerstgeborenen der Israëlieten van één maand oud en daarboven, en neem het aantal hunner namen op, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","en gij zult voor Mij de Levieten nemen – Ik ben de Here – in plaats van alle eerstgeborenen onder de Israëlieten, evenals het vee der Levieten in plaats van alle eerstgeborenen onder het vee der Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Toen telde Mozes, zoals de Here hem geboden had, alle eerstgeborenen onder de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Alle mannelijke eerstgeborenen, overeenkomstig het aantal namen, van één maand oud en daarboven, bleken bij telling te zijn tweeëntwintigduizend tweehonderd drieënzeventig. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Toen sprak de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Neem de Levieten in plaats van alle eerstgeborenen onder de Israëlieten, evenals het vee der Levieten in plaats van hun vee, opdat de Levieten mijn eigendom zijn; Ik ben de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Als losgeld voor de tweehonderd drieënzeventig eerstgeborenen der Israëlieten, die het getal der Levieten te boven gaan, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","zult gij voor ieder per hoofd vijf sikkels nemen, naar de heilige sikkel zult gij het nemen – deze sikkel is twintig gera – ");
INSERT INTO nldnbg_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","en dat geld zult gij aan Aäron en zijn zonen geven als het losgeld voor diegenen onder hen, die het getal (der Levieten) te boven gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Toen nam Mozes het losgeld van degenen die het getal van hen, die door de Levieten waren losgekocht, te boven gingen; ");
INSERT INTO nldnbg_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","van de eerstgeborenen der Israëlieten nam hij het geld, duizend driehonderd vijfenzestig sikkels naar de heilige sikkel, ");
INSERT INTO nldnbg_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","en Mozes gaf het losgeld aan Aäron en zijn zonen naar het bevel des Heren, zoals de Here aan Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Neem het aantal op van de Kehatieten onder de Levieten, naar hun geslachten en families, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","van dertig jaar oud en daarboven tot vijftig jaar oud, ieder, die dienstplichtig is om werk te verrichten in de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Dit zal de dienst der Kehatieten in de tent der samenkomst zijn: de zorg voor de allerheiligste dingen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Bij het opbreken van de legerplaats zullen Aäron en zijn zonen naar binnen gaan en het bedekkend voorhangsel afnemen, en daarmee de ark der getuigenis bedekken; ");
INSERT INTO nldnbg_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","daarover zullen zij een bedekking van tachasvel leggen, en daarover een kleed, geheel van blauwpurper, spreiden en de draagstokken aanbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ook over de tafel der toonbroden zullen zij een blauwpurperen kleed spreiden, en daarop plaatsen de schotels, de schalen, de kommen en de plengkannen, terwijl ook het steeds aanwezige brood erop zal blijven liggen: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","daarover zullen zij een scharlaken kleed spreiden en dit bedekken met een bedekking van tachasvel, en de draagstokken aanbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Dan zullen zij een blauwpurperen kleed nemen en daarmee de kandelaar voor het licht bedekken met zijn lampen, snuiters, bakjes, en al zijn gerei voor de olie, waarvan men zich daarbij bedient, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","en zij zullen hem met al zijn gerei plaatsen op een bedekking van tachasvel en op een draagbaar zetten. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Over het gouden altaar zullen zij een blauwpurperen kleed spreiden en dit bedekken met een bedekking van tachasvel en de draagstokken aanbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Dan zullen zij al het dienstgerei nemen, waarmee zij in het heilige dienst doen en dat op een blauwpurperen kleed plaatsen en het bedekken met een bedekking van tachasvel en op een draagbaar plaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","En het altaar zullen zij van as reinigen, er een roodpurperen kleed overheen spreiden, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","en daarop leggen al zijn gerei, waarvan men zich daarbij bedient, de vuurpannen, de vorken, de scheppen, de sprengbekkens, al het gerei van het altaar, en daarover een bedekking van tachasvel spreiden, en de draagstokken aanbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Als Aäron en zijn zonen bij het opbreken van de legerplaats gereed zijn met het bedekken van het heilige en al het heilige gerei, dan zullen daarna de Kehatieten binnengaan om het te dragen; zij zullen echter het heilige niet aanraken, want dan zouden zij sterven. Dit is hetgeen de Kehatieten aan de tent der samenkomst te dragen hebben. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","En Eleazar, de zoon van de priester Aäron, heeft het toezicht op de olie voor het licht, het welriekend reukwerk, het dagelijkse spijsoffer en de zalfolie; hij heeft het toezicht op de gehele tabernakel en alles wat daarin is, zowel het heilige als zijn gerei. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Laat de stam van de geslachten der Kehatieten niet uitgeroeid worden uit de Levieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Maar dit zult gij voor hen doen, opdat zij blijven leven en niet sterven, wanneer zij de allerheiligste dingen naderen. Aäron en zijn zonen zullen naar binnen gaan en hun een plaats aanwijzen, ieder bij hetgeen hij te doen of te dragen heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Maar zij zullen niet naar binnen gaan, zodat zij het heilige ook maar voor een ogenblik zien, want dan zouden zij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Neem ook het aantal op van de Gersonieten naar hun families en geslachten: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","van dertig jaar oud en daarboven tot vijftig jaar oud zult gij hen tellen, ieder, die dienstplichtig is om arbeid te verrichten in de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dit zal de dienst van de geslachten der Gersonieten zijn bij het dienen en het dragen: ");
INSERT INTO nldnbg_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","zij zullen dragen de tentkleden van de tabernakel en de tent der samenkomst, de bedekking daarvan en de bedekking van tachasvel, die daar overheen ligt, het voorhangsel voor de ingang van de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","de gordijnen van de voorhof en het voorhangsel van de ingang van de poort van de voorhof, die bij de tabernakel en het altaar rondom is, met de bijbehorende touwen en al hun dienstgereedschap en alles wat daaraan te doen is, daarbij zullen zij dienst doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Naar het bevel van Aäron en zijn zonen zal de gehele dienst der Gersonieten verricht worden, bij al hun dragen en bij al hun dienen; gij zult hun als taak aanwijzen alles wat zij moeten dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Dit is de dienst van de geslachten der Gersonieten aan de tent der samenkomst en hun taak onder leiding van Itamar, de zoon van de priester Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Wat de Merarieten betreft, hen zult gij tellen naar hun geslachten en families; ");
INSERT INTO nldnbg_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","van dertig jaar oud en daarboven tot vijftig jaar oud zult gij hen tellen, ieder, die dienstplichtig is om de arbeid te verrichten aan de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","En dit is hun taak in het dragen, wat betreft al hun dienst aan de tent der samenkomst: de planken van de tabernakel, zijn balken, zijn pilaren, zijn voetstukken, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","de pilaren van de voorhof rondom met de voetstukken, de pinnen en de touwen, al het bijbehorende gereedschap en alles wat daaraan te doen is; en bij name zult gij het gereedschap noemen, dat zij moeten dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Dit is de dienst van de geslachten der Merarieten naar al hun dienst aan de tent der samenkomst, onder leiding van Itamar, de zoon van de priester Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Toen Mozes met Aäron en de hoofden der vergadering de Kehatieten telde naar hun geslachten en families, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","van dertig jaar oud en daarboven tot vijftig jaar oud, ieder, die dienstplichtig was tot de arbeid aan de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","waren hun getelden naar hun geslachten tweeduizend zevenhonderd vijftig; ");
INSERT INTO nldnbg_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","dit waren de getelden van de geslachten der Kehatieten, allen die dienst deden aan de tent der samenkomst, die Mozes met Aäron telde naar het bevel des Heren door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","De getelden der Gersonieten naar hun geslachten en families, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","van dertig jaar oud en daarboven tot vijftig jaar oud, ieder, die dienstplichtig was tot de arbeid aan de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","hun getelden naar hun geslachten en families waren tweeduizend zeshonderd dertig. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Dit waren de getelden van de geslachten der Gersonieten, allen die dienst deden aan de tent der samenkomst, die Mozes met Aäron telde naar het bevel des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","De getelden van de geslachten der Merarieten naar hun geslachten en families, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","van dertig jaar oud en daarboven tot vijftig jaar oud, ieder, die dienstplichtig was tot de arbeid aan de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","hun getelden naar hun geslachten waren drieduizend tweehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Dit waren de getelden van de geslachten der Merarieten, die Mozes met Aäron telde naar het bevel des Heren door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Al de getelden, die Mozes met Aäron en de hoofden van Israël naar hun geslachten en families telde, namelijk de Levieten, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","van dertig jaar oud en daarboven tot vijftig jaar oud, ieder, die dienstplichtig was tot dienen en tot dragen aan de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","hun getelden waren achtduizend vijfhonderd tachtig. ");
INSERT INTO nldnbg_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Naar het bevel des Heren door de dienst van Mozes droeg men ieder op, wat hij te dienen en te dragen had, te weten de getelden, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Gebied de Israëlieten, dat zij uit de legerplaats wegzenden alle melaatsen, allen die een vloeiing hebben, en allen die onrein zijn door aanraking van een lijk; ");
INSERT INTO nldnbg_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","zowel mannen als vrouwen zult gij wegzenden; gij zult hen buiten de legerplaats zenden, opdat zij hun legerplaats niet verontreinigen, daar Ik toch in hun midden woon. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Toen deden de Israëlieten aldus en zonden hen weg buiten de legerplaats; de Israëlieten deden, zoals de Here tot Mozes gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Spreek tot de Israëlieten: Wanneer iemand, man of vrouw, een of andere zonde doet, die mensen begaan, en daardoor ontrouw wordt tegenover de Here, zodat hij een schuld op zich laadt, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","dan zullen zij de zonden belijden, die zij begaan hebben; en daarna de volle waarde van wat hij schuldig is, vergoeden, vermeerderd met een vijfde, en dat geven aan degene tegenover wie hij zich schuldig gemaakt heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Maar heeft die man geen losser, aan wie de schuld vergoed zou kunnen worden, dan zal de schuld die vergoed moet worden, aan de Here vervallen, ten bate van de priester, ongeacht de ram der verzoening, waarmee deze over hem verzoening zal doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","En elke heffing van al de heilige gaven, die de Israëlieten tot de priester brengen, zal voor hem zijn; ");
INSERT INTO nldnbg_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","maar wat de heilige gaven zelf betreft, die zullen voor de brenger zijn; alleen wat hij de priester geeft, zal voor deze zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Spreek tot de Israëlieten en zeg tot hen: Wanneer iemands vrouw zich misgaan zal hebben en hem ontrouw zal zijn geworden, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","en een ander met haar geslachtsgemeenschap zal hebben gehad, zonder dat het aan haar man bekend werd, daar het verborgen bleef, dat zij zich verontreinigd had, en er geen getuige tegen haar was, en zij niet betrapt werd, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","en wanneer dan de geest der jaloersheid over hem komt, zodat hij jaloers wordt ten aanzien van zijn vrouw, terwijl zij zich verontreinigd heeft, of wanneer de geest der jaloersheid over hem komt, zodat hij jaloers wordt ten aanzien van zijn vrouw, terwijl zij zich niet verontreinigd heeft, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","dan zal die man zijn vrouw tot de priester brengen met een offergave voor haar van een tiende efa gerstemeel, waarover hij geen olie gegoten heeft en waaraan hij geen wierook toegevoegd heeft, omdat het een spijsoffer der jaloersheid is, een herinneringsoffer, dat ongerechtigheid in gedachtenis brengt. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Dan zal de priester haar doen naderen en voor het aangezicht des Heren stellen, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","en de priester zal heilig water nemen in een aarden vat, en de priester zal van het stof dat op de vloer van de tabernakel ligt, nemen en aan het water toevoegen. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Heeft de priester de vrouw voor het aangezicht des Heren gesteld, dan zal hij het hoofdhaar der vrouw losmaken, en op haar handpalmen het herinneringsoffer, het spijsoffer der jaloersheid, leggen, terwijl in de hand van de priester zal zijn dat bittere water, dat de vloek brengt. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Dan zal de priester haar onder ede stellen en tot de vrouw zeggen: Indien geen man met u gemeenschap heeft gehad, en indien gij geen onreinheid begaan hebt, terwijl gij uw man toebehoordet, blijf dan ongestraft van dit bittere water, dat de vloek brengt; ");
INSERT INTO nldnbg_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","maar indien gij u, terwijl gij uw man toebehoordet, misgaan en u verontreinigd hebt, doordat een ander dan uw eigen man met u gemeenschap heeft gehad – ");
INSERT INTO nldnbg_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","de priester zal de vrouw onder een eed van vervloeking stellen, en de priester zal tot de vrouw zeggen: Dan stelle de Here u tot een vervloeking en een verwensing onder uw volk, doordat de Here uw heup doe invallen en uw buik doe opzwellen, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","want dit water, dat de vloek brengt, zal in uw binnenste komen om uw buik te doen opzwellen en uw heup te doen invallen. Daarop zal de vrouw zeggen: Amen, amen. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Daarna zal de priester die vervloekingen op een blad schrijven en in het bittere water afwassen ");
INSERT INTO nldnbg_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","en hij zal de vrouw het bittere water, dat de vloek brengt, te drinken geven, en het water, dat de vloek brengt, zal in haar worden tot bitterheid. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Dan zal de priester het spijsoffer der jaloersheid van de hand der vrouw nemen, en dit, na het voor het aangezicht des Heren bewogen te hebben, naar het altaar brengen, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","en de priester zal een handvol ervan als gedachtenisgave afnemen en die op het altaar in rook doen opgaan; daarna zal hij de vrouw het water te drinken geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Heeft hij haar het water te drinken gegeven, dan zal, wanneer zij zich verontreinigd heeft en zij aan haar man ontrouw is geweest, het water, dat de vloek brengt, in haar worden tot bitterheid, zodat haar buik zal opzwellen en haar heup zal invallen, en die vrouw tot een vloek onder haar volk zal zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Heeft de vrouw zich echter niet verontreinigd en is zij rein, dan zal zij ongestraft blijven en zwanger kunnen worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Dit is de wet op gevallen van jaloersheid als een vrouw zich misgaan heeft tegenover haar man en zich verontreinigd heeft, ");
INSERT INTO nldnbg_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","of als over een man de geest der jaloersheid is gekomen, zodat hij jaloers is ten aanzien van zijn vrouw; hij zal de vrouw voor het aangezicht des Heren stellen en de priester zal heel deze wet op haar toepassen. ");
INSERT INTO nldnbg_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","De man zal vrij zijn van ongerechtigheid, maar de vrouw zal haar ongerechtigheid dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Spreek tot de Israëlieten en zeg tot hen: Wanneer iemand, man of vrouw, een bijzondere gelofte wil afleggen, de nazireeërgelofte, om zich aan de Here te wijden, ");
INSERT INTO nldnbg_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dan zal hij zich van wijn en bedwelmende drank onthouden, geen azijn van wijn of van bedwelmende drank drinken noch enige uit druiven bereide drank, en geen druiven eten, noch verse noch gedroogde. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Al de tijd van zijn nazireeërschap zal hij niets eten, dat van de wijnstok afkomstig is, van de pitten af tot de toppen der ranken toe. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Al de tijd van zijn nazireeërgelofte zal geen scheermes over zijn hoofd komen; totdat de tijd, voor welke hij zich aan de Here gewijd heeft, ten einde is, zal hij heilig zijn, hij zal zijn hoofdhaar lang laten groeien. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Al de tijd, dat hij zich aan de Here gewijd heeft, zal hij bij geen dode komen; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","aan zijn vader noch zijn moeder, aan zijn broeder noch zijn zuster mag hij zich, na hun sterven, verontreinigen, want het nazireeërschap zijns Gods is op zijn hoofd. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Al de tijd van zijn nazireeërschap is hij de Here heilig. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Sterft echter geheel onverwacht iemand in zijn omgeving, zodat hij het hoofdhaar van zijn nazireeërschap verontreinigt, dan zal hij zijn hoofdhaar afscheren op de dag van zijn reiniging, op de zevende dag zal hij het afscheren; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","op de achtste dag zal hij twee tortelduiven of twee jonge duiven naar de priester aan de ingang van de tent der samenkomst brengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Dan zal de priester de ene tot een zondoffer en de andere tot een brandoffer bereiden, en hij zal verzoening over hem doen, omdat hij zich door aanraking van een lijk heeft bezondigd, en hij zal op diezelfde dag zijn hoofd heiligen. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Dan zal hij opnieuw aan de Here de tijd van zijn nazireeërschap wijden en een éénjarig schaap tot een schuldoffer brengen; de voorafgaande tijd zal niet meetellen, omdat zijn nazireeërschap verontreinigd was. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Dit nu is de wet aangaande de nazireeër. Wanneer de tijd van zijn nazireeërschap ten einde is, dan zal men hem naar de ingang van de tent der samenkomst brengen, ");
INSERT INTO nldnbg_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","en hij zal zijn offergave de Here aanbieden: een gaaf éénjarig schaap als brandoffer en een gave, éénjarige ooi als zondoffer en een gave ram als vredeoffer, ");
INSERT INTO nldnbg_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","met een korf ongezuurde broden van fijn meel, koeken aangemaakt met olie, en dunne ongezuurde broden bestreken met olie, met het bijbehorend spijsoffer en de bijbehorende plengoffers. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","En de priester zal het voor het aangezicht des Heren brengen en zijn zondoffer en zijn brandoffer bereiden; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","de ram zal hij toebereiden als vredeoffer aan de Here, met de korf ongezuurde broden; ook zal de priester het bijbehorend spijsoffer en het bijbehorend plengoffer bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Dan zal de nazireeër vóór de ingang van de tent der samenkomst het hoofdhaar van zijn nazireeërschap afscheren en dat hoofdhaar van zijn nazireeërschap nemen en het in het vuur onder het vredeoffer werpen. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","De priester zal de schouder van de ram nemen, nadat deze gekookt is, en één ongezuurde koek uit de korf, met één ongezuurde dunne koek, en deze leggen op de handpalmen van de nazireeër, nadat deze zich het haar van zijn nazireeërschap heeft afgeschoren; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","vervolgens zal de priester deze voor het aangezicht des Heren bewegen als een beweegoffer; het zal een heiligheid voor de priester zijn, met de beweegborst en de hefschenkel. Eerst daarna zal de nazireeër wijn mogen drinken. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Dit is de wet aangaande de nazireeër. Hetgeen hij als offergave de Here belooft op grond van zijn nazireeërschap, behalve datgene waartoe hij in staat is, overeenkomstig zijn gelofte die hij belooft, aldus zal hij doen overeenkomstig de wet op zijn nazireeërschap. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Spreek tot Aäron en zijn zonen: Zó zult gij de Israëlieten zegenen: ");
INSERT INTO nldnbg_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","De Here zegene u en behoede u; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","de Here doe zijn aangezicht over u lichten en zij u genadig; ");
INSERT INTO nldnbg_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","de Here verheffe zijn aangezicht over u en geve u vrede. ");
INSERT INTO nldnbg_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Zo zullen zij mijn naam op de Israëlieten leggen, en Ik zal hen zegenen. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Op de dag nu, dat Mozes gereed was met het oprichten van de tabernakel, zalfde en heiligde hij die met al zijn toebehoren, benevens het altaar met al zijn toebehoren; en toen hij deze gezalfd en geheiligd had, ");
INSERT INTO nldnbg_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","offerden de vorsten van Israël, de hoofden van hun families – dit waren de vorsten der stammen, degenen, die aan het hoofd van de getelden stonden; – ");
INSERT INTO nldnbg_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","als hun offergave brachten zij voor het aangezicht des Heren: zes overdekte wagens en twaalf runderen, één wagen voor elke twee vorsten en voor ieder één rund, en zij brachten ze vóór de tabernakel. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Toen zeide de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Neem deze van hen in ontvangst en laat ze dienen voor de dienst aan de tent der samenkomst; geef ze aan de Levieten, naardat ieder voor zijn dienst behoeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Toen nam Mozes de wagens en de runderen in ontvangst en gaf ze aan de Levieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","twee wagens en vier runderen gaf hij aan de Gersonieten, naardat zij voor hun dienst behoefden, ");
INSERT INTO nldnbg_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","en vier wagens en acht runderen gaf hij aan de Merarieten, naardat zij voor hun dienst behoefden, onder leiding van Itamar, de zoon van de priester Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Maar aan de Kehatieten gaf hij niets, omdat op hen rustte de dienst der heilige voorwerpen, die zij op hun schouder droegen. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ook brachten de vorsten een wijdingsgave voor het altaar, op de dag dat het gezalfd werd; de vorsten brachten hun offergave vóór het altaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","En de Here zeide tot Mozes: laat op elke dag één vorst zijn offergave voor de inwijding van het altaar brengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Die nu op de eerste dag zijn offergave bracht, was Nachson, de zoon van Amminadab, van de stam van Juda. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Nachson, de zoon van Amminadab. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Op de tweede dag bracht Netanel, de zoon van Suar, de vorst van Issakar, zijn offergave. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Hij bracht als zijn offergave één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Netanel, de zoon van Suar. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Op de derde dag de vorst der Zebulonieten, Eliab, de zoon van Chelon. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Eliab, de zoon van Chelon. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Op de vierde dag de vorst der Rubenieten, Elisur, de zoon van Sedeür. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Elisur, de zoon van Sedeür. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Op de vijfde dag de vorst der Simeonieten, Selumiël, de zoon van Surisaddai. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Selumiël, de zoon van Surisaddai. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Op de zesde dag de vorst der Gadieten, Eljasaf, de zoon van Reüel. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Eljasaf, de zoon van Reüel. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Op de zevende dag de vorst der Efraïmieten, Elisama, de zoon van Ammihud. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Elisama, de zoon van Ammihud. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Op de achtste dag de vorst der Manassieten, Gamliël, de zoon van Pedasur. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Gamliël, de zoon van Pedasur. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Op de negende dag de vorst der Benjaminieten, Abidan, de zoon van Gidoni. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Abidan, de zoon van Gidoni. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Op de tiende dag de vorst der Danieten, Achiëzer, de zoon van Ammisaddai. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Achiëzer, de zoon van Ammisaddai. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Op de elfde dag de vorst der Aserieten, Pagiël, de zoon van Okran. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Pagiël, de zoon van Okran. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Op de twaalfde dag de vorst der Naftalieten, Achira, de zoon van Enan. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Zijn offergave bestond uit één zilveren schotel, honderd dertig sikkels in gewicht, en één zilveren sprengbekken van zeventig sikkels, naar de heilige sikkel, beide gevuld met fijn meel, aangemaakt met olie, tot een spijsoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","één schaal van tien sikkels goud, gevuld met reukwerk; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","één jonge stier, één ram en één éénjarig schaap tot een brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","één geitebok tot een zondoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","en tot een vredeoffer twee runderen, vijf rammen, vijf bokken en vijf éénjarige schapen. Dit was de offergave van Achira, de zoon van Enan. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Dit was de wijdingsgave voor het altaar op de dag dat het gezalfd werd, geschonken door de vorsten van Israël: twaalf zilveren schotels, twaalf zilveren sprengbekkens, twaalf gouden schalen, ");
INSERT INTO nldnbg_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","honderd dertig sikkels zilver elke schotel, en zeventig elk sprengbekken; al het zilver der vaten bedroeg tweeduizend vierhonderd sikkels, naar de heilige sikkel; ");
INSERT INTO nldnbg_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","twaalf gouden schalen gevuld met reukwerk, elke schaal tien sikkels, naar de heilige sikkel; al het goud der schalen bedroeg honderd twintig sikkels. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Al het vee voor het brandoffer bestond uit twaalf jonge stieren, twaalf rammen, twaalf éénjarige schapen, met het bijbehorende spijsoffer; daarbij twaalf geitebokken tot een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Al het vee van het vredeoffer bestond uit vierentwintig jonge stieren, zestig rammen, zestig bokken, zestig éénjarige schapen. Dit was de wijdingsgave voor het altaar, nadat het gezalfd was. ");
INSERT INTO nldnbg_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Wanneer nu Mozes de tent der samenkomst binnenging om met Hem te spreken, dan hoorde hij een stem, die tot hem sprak van boven het verzoendeksel, dat op de ark der getuigenis was, van tussen de beide cherubs, en Hij sprak tot hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Spreek tot Aäron en zeg tot hem: Wanneer gij de lampen opstelt, moeten de zeven lampen haar licht doen vallen op de voorzijde van de kandelaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","En Aäron deed alzo; aan de voorzijde van de kandelaar stelde hij de lampen daarvan op, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","En aldus was de kandelaar gemaakt: van gedreven goud; zowel wat zijn schacht als wat zijn bloesemversiering betreft, was hij gedreven werk; overeenkomstig het voorbeeld dat de Here hem had getoond, had Mozes de kandelaar gemaakt. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Neem de Levieten uit de Israëlieten en reinig hen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Aldus zult gij met hen handelen om hen te reinigen: sprenkel op hen ontzondigingswater, daarna moeten zij een scheermes over hun gehele lichaam laten gaan en hun klederen wassen, opdat zij gereinigd worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Dan zullen zij een jonge stier nemen met het bijbehorend spijsoffer, fijn meel aangemaakt met olie, en een tweede jonge stier zult gij nemen tot een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Vervolgens zult gij de Levieten doen naderen vóór de tent der samenkomst, en de gehele vergadering der Israëlieten samenroepen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Hebt gij de Levieten voor het aangezicht des Heren doen naderen, dan zullen de Israëlieten de Levieten de handen opleggen, ");
INSERT INTO nldnbg_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","en Aäron zal de Levieten bewegen als een beweegoffer uit de Israëlieten voor het aangezicht des Heren, en zij zullen bestemd zijn om de dienst des Heren te verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Nadat de Levieten hun handen op de kop der jonge stieren gelegd hebben, bereid dan de ene tot een zondoffer en de andere tot een brandoffer voor de Here, om verzoening te doen over de Levieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Dan zult gij de Levieten vóór Aäron en zijn zonen plaatsen en hen bewegen als een beweegoffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Aldus zult gij de Levieten uit de Israëlieten afzonderen, opdat de Levieten mijn eigendom zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Eerst daarna zullen de Levieten naar binnen gaan om bij de tent der samenkomst dienst te doen; gij zult hen reinigen en hen als een beweegoffer bewegen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Want zij zullen uit de Israëlieten Mij onvoorwaardelijk geschonken zijn; Ik heb hen voor Mij genomen in de plaats van alles wat het eerst uit de moederschoot voortkomt, van alle eerstgeborenen onder de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Want alle eerstgeborenen onder de Israëlieten, zowel van mens als van dier, zijn mijn eigendom; op de dag dat Ik alle eerstgeborenen in het land Egypte sloeg, heb Ik hen Mij geheiligd, ");
INSERT INTO nldnbg_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","en Ik nam de Levieten in de plaats van alle eerstgeborenen onder de Israëlieten, ");
INSERT INTO nldnbg_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","en Ik gaf de Levieten uit de Israëlieten als geschonkenen aan Aäron en zijn zonen, om de dienst der Israëlieten bij de tent der samenkomst te verrichten, en om verzoening te doen over de Israëlieten, opdat er geen plaag zij onder de Israëlieten, wanneer de Israëlieten tot het heilige zouden naderen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Toen volbrachten Mozes, Aäron en de gehele vergadering der Israëlieten deze handeling aan de Levieten; juist zoals de Here Mozes ten aanzien van de Levieten geboden had, deden de Israëlieten met hen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","De Levieten lieten zich ontzondigen en wiesen hun klederen, Aäron bewoog hen als een beweegoffer voor het aangezicht des Heren, en deed verzoening over hen en reinigde hen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Daarna gingen de Levieten naar binnen om hun dienst bij de tent der samenkomst te verrichten, onder toezicht van Aäron en zijn zonen. Zoals de Here Mozes aangaande de Levieten geboden had, deed men met hen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dit geldt voor de Levieten: iemand van vijfentwintig jaar oud en daarboven zal komen om zijn taak te verrichten in de dienst van de tent der samenkomst, ");
INSERT INTO nldnbg_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","en op vijftigjarige leeftijd zal hij van het dienstwerk ontslagen zijn, zodat hij niet langer behoeft te dienen. ");
INSERT INTO nldnbg_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Al zal hij zijn broeders in de tent der samenkomst bij het vervullen van hun taak behulpzaam mogen zijn, hij zal geen dienst meer behoeven te doen. Aldus zult gij met de Levieten handelen ten aanzien van hun taak. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","En de Here sprak tot Mozes in de woestijn Sinai, in het tweede jaar na hun uittocht uit het land Egypte, in de eerste maand: ");
INSERT INTO nldnbg_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","De Israëlieten nu zullen het Pascha vieren op de daarvoor bepaalde tijd; ");
INSERT INTO nldnbg_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","op de veertiende dag dezer maand, in de avondschemering, zult gij het vieren op de daarvoor bepaalde tijd, naar al de inzettingen en verordeningen, die daarop betrekking hebben, zult gij het vieren. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Toen beval Mozes de Israëlieten het Pascha te vieren; ");
INSERT INTO nldnbg_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","en zij vierden het Pascha in de eerste maand, op de veertiende dag der maand, in de avondschemering, in de woestijn Sinai; juist zoals de Here Mozes geboden had, deden de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nu waren er enige mannen, die onrein waren door aanraking van het lijk van een mens, zodat zij op die dag het Pascha niet konden vieren; dezen verschenen op die dag vóór Mozes en Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","En die mannen zeiden tot hen: Wij zijn onrein door aanraking van het lijk van een mens, waarom wordt ons nu belet de offergave des Heren op de daarvoor bepaalde tijd te midden van de Israëlieten te brengen? ");
INSERT INTO nldnbg_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Toen zeide Mozes tot hen: Blijft hier staan, dan wil ik horen, wat mij de Here ten aanzien van u zal gebieden. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Toen sprak de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Spreek tot de Israëlieten: wanneer iemand onrein is door aanraking van een lijk of op een verre reis is, – het geldt zowel voor u als voor uw nageslacht – dan zal hij toch des Heren Pascha vieren. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","In de tweede maand, op de veertiende dag, in de avondschemering, zal men het vieren, met ongezuurde broden en bittere kruiden zal men het eten. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Men zal niets ervan laten overblijven tot de volgende morgen, en geen been eraan breken; geheel volgens de inzetting van het Pascha zal men het vieren. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Maar de man, die rein is, en niet op reis, en nalaat het Pascha te vieren, die zal uitgeroeid worden uit zijn volksgenoten, omdat hij op de daarvoor bepaalde tijd de offergave des Heren niet heeft gebracht; die man zal zijn zonde dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Wanneer bij u een vreemdeling vertoeft, die de Here het Pascha vieren wil, dan moet hij het vieren naar de inzetting van het Pascha en de verordeningen, die daarop betrekking hebben. Enerlei inzetting zal voor u gelden, zowel voor de vreemdeling als voor de in het land geborene. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Op de dag nu der oprichting van de tabernakel bedekte de wolk de tabernakel, de tent der getuigenis, en des avonds was zij op de tabernakel als een vuurverschijnsel tot aan de morgen. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Zo was het voortdurend: de wolk bedekte hem, en het vuurverschijnsel des nachts. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","En zo vaak als de wolk van boven de tent optrok, braken daarna de Israëlieten op, en op de plek waar de wolk bleef rusten, daar legerden zich de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Op het bevel des Heren braken de Israëlieten op, en op het bevel des Heren legerden zij zich; zolang de wolk op de tabernakel rustte, bleven zij gelegerd. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bleef de wolk lange tijd op de tabernakel, dan onderhielden de Israëlieten de dienst des Heren, en braken niet op. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Soms bleef de wolk enkele dagen op de tabernakel; dan legerden zij zich op het bevel des Heren en op het bevel des Heren braken zij op. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Soms was de wolk er van de avond tot de morgen; trok de wolk dan in de morgen op, dan braken zij op; hetzij des daags of des nachts, als de wolk optrok, dan braken zij op. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Wanneer de wolk langere tijd op de tabernakel rustte, hetzij twee dagen, een maand of nog langer, dan bleven de Israëlieten gelegerd en braken niet op; eerst, als zij optrok, braken zij op. ");
INSERT INTO nldnbg_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Op het bevel des Heren legerden zij zich en op het bevel des Heren braken zij op; zij onderhielden de dienst des Heren, volgens het bevel des Heren door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Maak u twee zilveren trompetten; van gedreven werk zult gij deze maken, om u te dienen tot het samenroepen van de vergadering en tot het opbreken van de legerplaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Geeft men op beide een stoot, dan zal de gehele vergadering zich tot u verzamelen bij de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Geeft men op één een stoot, dan zullen de vorsten, de stamhoofden Israëls, zich tot u verzamelen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Blaast gij één signaal, dan zullen de legerafdelingen die aan de oostzijde gelegerd zijn, opbreken; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","blaast gij een tweede signaal, dan zullen de legerafdelingen die aan de zuidzijde gelegerd zijn, opbreken. Men zal een signaal blazen, als zij moeten opbreken; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","bij het samenroepen van de gemeente zult gij alleen een stoot geven, maar geen signaal blazen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","De zonen van Aäron, de priesters, zullen op de trompetten blazen; dit zal u tot een altoosdurende inzetting zijn voor uw nageslacht. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","En wanneer gij in uw land ten strijde trekt tegen de vijand die u benauwt, dan zult gij op de trompetten een signaal blazen, waardoor gij in gedachtenis gebracht zult worden voor het aangezicht van de Here, uw God, zodat gij van uw vijanden verlost zult worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ook op uw vreugdedagen, op uw feesten en op uw nieuwemaansdagen zult gij een stoot op de trompetten geven bij uw brandoffers en vredeoffers; zij zullen u dienen om u voor het aangezicht van uw God in gedachtenis te brengen; Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","In het tweede jaar, in de tweede maand, op de twintigste dag der maand, trok de wolk van boven de tabernakel der getuigenis op. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Toen braken de Israëlieten uit de woestijn Sinai op in de voorgeschreven orde van opbreken, en de wolk bleef rusten in de woestijn Paran. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Dit nu was de eerste maal, dat zij opbraken volgens het bevel des Heren door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","In de eerste plaats brak het vendel van de legerplaats der Judeeërs op volgens hun legerscharen; aan het hoofd van het leger van Juda stond Nachson, de zoon van Amminadab; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","aan het hoofd van het leger van de stam der Issakarieten stond Netanel, de zoon van Suar; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","aan het hoofd van het leger van de stam der Zebulonieten stond Eliab, de zoon van Chelon. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Daarna werd de tabernakel afgebroken, en braken de Gersonieten en de Merarieten op, die de tabernakel droegen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Vervolgens brak het vendel van de legerplaats van Ruben op volgens hun legerscharen; aan het hoofd van het leger van Ruben stond Elisur, de zoon van Sedeür; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","aan het hoofd van het leger van de stam der Simeonieten stond Selumiël, de zoon van Surisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","aan het hoofd van het leger van de stam der Gadieten stond Eljasaf, de zoon van Reüel. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Daarna braken de Kehatieten op, die het heilige droegen; men richtte de tabernakel op, voordat zij kwamen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Dan brak het vendel van de legerplaats der Efraïmieten op volgens hun legerscharen; aan het hoofd van het leger van Efraïm stond Elisama, de zoon van Ammihud; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","aan het hoofd van het leger van de stam der Manassieten stond Gamliël, de zoon van Pedasur; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","aan het hoofd van het leger van de stam der Benjaminieten stond Abidan, de zoon van Gidoni. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Als laatste van alle legerplaatsen brak het vendel van de legerplaats der Danieten op volgens hun legerscharen; aan het hoofd van het leger van Dan stond Achiëzer, de zoon van Ammisaddai; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","aan het hoofd van het leger van de stam der Aserieten stond Pagiël, de zoon van Okran; ");
INSERT INTO nldnbg_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","aan het hoofd van het leger van de stam der Naftalieten stond Achira, de zoon van Enan. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Aldus was de orde van opbreken der Israëlieten volgens hun legerscharen. En zij braken op. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Toen zeide Mozes tot Chobab, de zoon van de Midjaniet Reüel, de schoonvader van Mozes: Wij trekken op naar de plaats waarvan de Here gezegd heeft: Ik zal u haar geven; ga met ons, dan zullen wij u weldoen, want de Here heeft het goede gesproken over Israël. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hij echter zeide tot hem: Neen, maar ik wil naar mijn land en naar mijn verwanten gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Hij nu zeide: Wil ons toch niet verlaten, want gij weet immers, hoe wij ons in de woestijn moeten legeren, en gij kunt ons tot ogen dienen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Indien gij nu met ons medegaat, en wanneer het goede er zal zijn, waarmede de Here ons zal weldoen, dan zullen wij u weldoen. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Toen braken zij op van de berg des Heren en trokken drie dagreizen ver, terwijl de ark van het verbond des Heren vóór hen uit optrok, drie dagreizen ver, om voor hen een rustplaats te zoeken. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","En de wolk des Heren was overdag boven hen, wanneer zij uit de legerplaats opbraken. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Wanneer nu de ark opbrak, zeide Mozes: Sta op, Here, opdat uw vijanden verstrooid worden en uw haters van uw aangezicht wegvluchten. ");
INSERT INTO nldnbg_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","En wanneer zij bleef rusten, zeide hij: Keer weder, Here, tot de tienduizenden der duizenden Israëls. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Toen het volk aan het klagen was, was het kwaad in de oren des Heren; de Here hoorde het en zijn toorn ontstak, waarop het vuur des Heren onder hen ontbrandde en aan de rand van de legerplaats woedde. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Toen kermde het volk tot Mozes en Mozes bad tot de Here; daarop doofde het vuur. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Daarom gaf men aan die plaats de naam Tabera, omdat onder hen het vuur des Heren had gebrand. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Het samenraapsel nu, dat zich onder hen bevond, werd met gulzig begeren vervuld; ook de Israëlieten begonnen weer te jammeren en zeiden: Wie geeft ons vlees te eten? ");
INSERT INTO nldnbg_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wij denken terug aan de vis, die wij in Egypte aten om niet, aan de komkommers en de meloenen, het look, de uien en het knoflook. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Maar nu drogen wij uit, er is in het geheel niets, wij krijgen alleen dit man te zien. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Het man nu leek op korianderzaad en het zag er uit als balsemhars; ");
INSERT INTO nldnbg_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","het volk verspreidde zich om het te verzamelen en maalde het in handmolens of stampte het in vijzels en kookte het in potten en bereidde het tot koeken; en de smaak ervan was als van oliegebak; ");
INSERT INTO nldnbg_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","telkens wanneer des nachts de dauw op de legerplaats neerdaalde, daalde ook het man daarop neder. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Toen Mozes het volk, geslacht aan geslacht, hoorde wenen, ieder aan de ingang van zijn tent, ontbrandde de toorn des Heren hevig, en het was kwaad in de ogen van Mozes, ");
INSERT INTO nldnbg_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","en Mozes zeide tot de Here: Waarom hebt Gij uw knecht slecht behandeld en waarom heb ik geen genade gevonden in uw ogen, dat Gij de last van dit gehele volk op mij legt? ");
INSERT INTO nldnbg_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Heb ik dit gehele volk ontvangen of heb ik het gebaard, dat Gij tot mij zoudt kunnen zeggen: Draag het in uw schoot, zoals een voedstervader een zuigeling draagt, naar het land dat Gij aan zijn vaderen onder ede beloofd hebt? ");
INSERT INTO nldnbg_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Vanwaar zou ik het vlees halen om aan dit gehele volk te geven? want zij jammeren tegen mij: Geef ons vlees te eten! ");
INSERT INTO nldnbg_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ik alleen kan de zorg voor dit gehele volk niet dragen: dat is mij te zwaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Wilt Gij zó met mij handelen, dood mij dan liever, indien ik genade heb gevonden in uw ogen, opdat ik mijn ongeluk niet behoef aan te zien. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Toen zeide de Here tot Mozes: Vergader Mij uit de oudsten van Israël zeventig mannen, van wie gij weet, dat zij oudsten en opzieners van het volk zijn, en breng hen naar de tent der samenkomst, opdat zij zich daar bij u opstellen. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Dan zal Ik nederdalen en daar met u spreken en een deel van de Geest die op u is, nemen en op hen leggen, opdat zij met u de last van het volk dragen, en gij die niet alleen behoeft te dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Maar tot het volk zult gij zeggen: Heiligt u tegen morgen, dan zult gij vlees eten; gij hebt immers ten aanhoren des Heren gejammerd: Wie zal ons vlees te eten geven? wij hadden het zo goed in Egypte. – De Here zal u vlees geven en gij zult eten. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Gij zult het niet één dag eten en geen twee dagen, geen vijf dagen, geen tien dagen en geen twintig dagen, ");
INSERT INTO nldnbg_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","maar een volle maand lang, totdat het uw neus uitkomt en gij ervan walgt – omdat gij de Here hebt veracht, die in uw midden is en aldus voor zijn aangezicht hebt gejammerd: Waarom toch zijn wij uit Egypte getrokken? ");
INSERT INTO nldnbg_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Doch Mozes zeide: Zeshonderdduizend man te voet bedraagt dit volk, in welks midden ik ben, en Gij zegt: Vlees zal Ik hun geven, en een volle maand zullen zij het eten! ");
INSERT INTO nldnbg_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kunnen er zoveel schapen en runderen voor hen geslacht worden, dat zij er genoeg aan hebben? Of kunnen alle vissen uit de zee voor hen gevangen worden, dat zij er genoeg aan hebben? ");
INSERT INTO nldnbg_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","De Here echter zeide tot Mozes: Zou de hand des Heren te kort zijn? Nu zult gij zien, of mijn woord aan u geschieden zal of niet! ");
INSERT INTO nldnbg_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Toen Mozes naar buiten was gekomen, sprak hij de woorden des Heren tot het volk; daarop vergaderde hij zeventig mannen uit de oudsten van het volk en stelde hen rondom de tent. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Toen daalde de Here in de wolk neder en sprak tot hem, en Hij nam een deel van de Geest die op hem was, en legde dat op de zeventig mannen, op de oudsten; toen de Geest op hen rustte, profeteerden zij, doch daarna niet meer. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Twee mannen nu waren in de legerplaats achtergebleven; de een heette Eldad, en de ander Medad. Toen de Geest op hen rustte – zij behoorden tot de opgeschrevenen, maar waren niet naar de tent gegaan – profeteerden zij in de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Een jongeman snelde daarop heen en bracht Mozes bericht en zeide: Eldad en Medad zijn aan het profeteren in de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jozua nu, de zoon van Nun, die van jongs af Mozes’ dienaar was geweest, antwoordde daarop en zeide: Mijn heer Mozes, belet het hun. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Doch Mozes zeide tot hem: Wilt gij voor mij ijveren? och, ware het gehele volk des Heren profeten, doordat de Here zijn Geest op hen gave! ");
INSERT INTO nldnbg_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Daarop trok Mozes zich in de legerplaats terug, vergezeld van de oudsten van Israël. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Toen stak er een wind op, door de Here gezonden; die voerde kwakkels aan van de zee en strooide ze uit over de legerplaats, zodat zij een dagreis ver naar alle kanten rondom de legerplaats lagen, ongeveer twee ellen hoog boven de grond. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Toen maakte het volk zich op, die gehele dag en de gehele nacht en de gehele volgende dag, en verzamelde de kwakkels – die het minst had, verzamelde tien homer – en zij spreidden deze wijd uit, rondom de legerplaats. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Terwijl het vlees nog tussen hun tanden was, vóórdat het gekauwd was, ontbrandde de toorn des Heren tegen het volk en de Here sloeg het volk met een zeer zware slag. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daarom gaf men aan die plaats de naam Kibrot-Hattaäwa, omdat men daar het gulzige volk begraven had. ");
INSERT INTO nldnbg_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Uit Kibrot-Hattaäwa brak het volk op naar Chaserot en zij bleven te Chaserot. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam nu sprak met Aäron over Mozes naar aanleiding van de Ethiopische vrouw, die hij genomen had, want hij had een Ethiopische vrouw genomen, ");
INSERT INTO nldnbg_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","en zij zeiden: Heeft de Here soms uitsluitend door Mozes gesproken, heeft Hij ook niet door ons gesproken? En de Here hoorde het. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mozes nu was een zeer zachtmoedig man, meer dan enig mens op de aardbodem. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Toen zeide de Here onverwijld tot Mozes, Aäron en Mirjam: Gaat met uw drieën uit naar de tent der samenkomst. Daarop gingen zij met hun drieën uit. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Toen daalde de Here neder in de wolkkolom, stelde Zich in de ingang der tent, en riep Aäron en Mirjam; en zij traden beiden naar voren. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Toen zeide Hij: Hoort nu mijn woorden. Indien onder u een profeet is, dan maak Ik, de Here, Mij in een gezicht aan hem bekend, in een droom spreek Ik met hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Niet aldus met mijn knecht Mozes, vertrouwd als hij is in geheel mijn huis. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Van mond tot mond spreek Ik met hem, duidelijk en niet in raadselen, maar hij aanschouwt de gestalte des Heren. Waarom hebt gij u dan niet ontzien tegen mijn knecht Mozes te spreken? ");
INSERT INTO nldnbg_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Daarom ontbrandde de toorn des Heren tegen hen en Hij ging heen. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Toen nu de wolk van boven de tent geweken was, zie, Mirjam was melaats als sneeuw; toen Aäron zich tot Mirjam omwendde, ziedaar een melaatse! ");
INSERT INTO nldnbg_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Toen zeide Aäron tot Mozes: Ach mijn heer, reken ons toch de zonde niet toe, die wij in onze dwaasheid begaan hebben. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Laat haar toch niet zijn als een doodgeborene, wiens vlees reeds half vergaan is, wanneer hij uit de schoot zijner moeder komt. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","En Mozes riep tot de Here: O God, genees haar toch. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Daarop zeide de Here tot Mozes: Had haar vader haar openlijk in het gezicht gespuwd, zou zij dan niet gedurende zeven dagen te schande zijn? Laat haar gedurende zeven dagen buiten de legerplaats gesloten worden, en daarna mag zij zich er weer bijvoegen. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Daarop werd Mirjam zeven dagen buiten de legerplaats gesloten; en het volk brak niet op, vóórdat Mirjam zich bij hen gevoegd had. ");
INSERT INTO nldnbg_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Toen brak het volk op uit Chaserot en legerde zich in de woestijn Paran. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Zend mannen uit om het land Kanaän te verspieden, dat Ik de Israëlieten geven zal; telkens één man zult gij zenden als vertegenwoordiger van de stam zijner vaderen: allen vorsten onder hen. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Toen zond Mozes hen heen uit de woestijn Paran, naar het bevel des Heren; al die mannen waren hoofden der Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","En dit zijn hun namen: van de stam Ruben Sammua, de zoon van Zakkur; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","van de stam Simeon Safat, de zoon van Chori; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","van de stam Juda Kaleb, de zoon van Jefunne; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","van de stam Issakar Jigal, de zoon van Josef; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","van de stam Efraïm Hosea, de zoon van Nun; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","van de stam Benjamin Palti, de zoon van Rafu; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","van de stam Zebulon Gaddiël, de zoon van Sodi; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","van de stam Jozef, van de stam Manasse Gaddi, de zoon van Susi; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","van de stam Dan Ammiël, de zoon van Gemalli; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","van de stam Aser Setur, de zoon van Michaël; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","van de stam Naftali Nachbi, de zoon van Wofsi; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","van de stam Gad Geüel, de zoon van Maki. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Dit zijn de namen der mannen, die Mozes uitzond om het land te verspieden; en Mozes noemde Hosea, de zoon van Nun, Jozua. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mozes dan zond hen uit om het land Kanaän te verspieden en zeide tot hen: Trekt hier het Zuiderland in en trekt op naar het bergland, ");
INSERT INTO nldnbg_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","en ziet, hoe het land is, en of het volk dat erin woont, sterk is of zwak, klein of talrijk; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","en of het land, waarin het woont, goed is of slecht, hoe de steden zijn, waarin het woont, of het in legerplaatsen woont dan wel in vestingen, ");
INSERT INTO nldnbg_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","en of het land vet is of schraal, of er bomen op staan of niet. Weest moedig en neemt van de vrucht des lands mede. Het was toen juist de tijd der eerste druiven. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Zij trokken op en verspiedden het land van de woestijn Sin af tot aan Rechob toe, waar de weg naar Hamat begint. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Toen zij door het Zuiderland optrokken, kwam men tot Hebron; daar woonden Achiman, Sesai en Talmai, de kinderen van Enak. Hebron is zeven jaar eerder gebouwd dan Soan in Egypte. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Toen zij in het dal Eskol gekomen waren, sneden zij daar een rank met één tros druiven af, die zij met hun tweeën aan een draagstok droegen; ook enige granaatappelen en vijgen. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Die plaats noemde men het dal Eskol wegens de druiventros, die de Israëlieten daar afgesneden hadden. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Na verloop van veertig dagen keerden zij terug van het verspieden van het land; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","zij gingen op weg en kwamen tot Mozes en Aäron en de gehele vergadering der Israëlieten in Kades, in de woestijn Paran, en brachten hun en de gehele vergadering bericht en toonden hun de vrucht van het land. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Zij verhaalden hem dan en zeiden: Wij kwamen in het land, waarheen gij ons gezonden hadt, en ja, het vloeit van melk en honig, en dit is zijn vrucht. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Het volk echter, dat in het land woont, is sterk en de steden zijn ommuurd en zeer groot, en ook de kinderen van Enak zagen wij daar; ");
INSERT INTO nldnbg_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek woont in het Zuiderland, de Hethieten, Jebusieten en Amorieten wonen in het bergland, de Kanaänieten aan de zee en aan de oever van de Jordaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Daarop trachtte Kaleb het volk tot bedaren te brengen tegenover Mozes en zeide: Laat ons gerust optrekken en het in bezit nemen, want wij zullen het zeker kunnen vermeesteren. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Maar de mannen die met hem opgetrokken waren, zeiden: Wij zullen tegen dat volk niet kunnen optrekken, want het is sterker dan wij. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ook verspreidden zij onder de Israëlieten een kwaad gerucht omtrent het land dat zij verspied hadden, door te zeggen: Het land dat wij zijn doorgetrokken om het te verspieden, is een land dat zijn inwoners verslindt, en alle mensen die wij daar zagen, waren mannen van grote lengte. ");
INSERT INTO nldnbg_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ook zagen wij daar de reuzen, Enakieten, die tot de reuzen behoren, en wij waren als sprinkhanen in onze eigen ogen en ook in hun ogen. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toen verhief de gehele vergadering haar stem en het volk weende in die nacht. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Al de Israëlieten morden tegen Mozes en Aäron; en de gehele vergadering zeide tot hen: Och, waren wij in het land Egypte gestorven, of waren wij in deze woestijn gestorven! ");
INSERT INTO nldnbg_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Waarom toch brengt ons de Here naar dit land, opdat wij door het zwaard vallen, onze vrouwen en kinderen ten buit worden? Zou het voor ons niet beter zijn naar Egypte terug te keren? ");
INSERT INTO nldnbg_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","En zij zeiden tot elkander: Laat ons een hoofd aanstellen en naar Egypte terugkeren. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Toen wierpen Mozes en Aäron zich op hun aangezicht ten aanschouwen van de gehele gemeente van de vergadering der Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","En Jozua, de zoon van Nun, en Kaleb, de zoon van Jefunne, die behoorden tot degenen die het land verspied hadden, scheurden hun klederen ");
INSERT INTO nldnbg_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","en zeiden tot de gehele vergadering der Israëlieten: Het land dat wij doorgetrokken zijn om het te verspieden, dat land is buitengewoon goed. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Indien de Here welgevallen aan ons heeft, dan zal Hij ons in dit land brengen en het ons geven, een land, dat vloeit van melk en honig. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Alleen, weest dan niet opstandig tegen de Here, en gij, vreest het volk van het land niet, want zij zijn ons tot spijs, hun schaduw is van hen geweken, en de Here is met ons; vreest hen niet. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Toen zeide de gehele vergadering, dat men hen stenigen zou. Maar de heerlijkheid des Heren verscheen in de tent der samenkomst aan al de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","En de Here zeide tot Mozes: Hoelang zal dit volk Mij versmaden, en hoelang zullen zij niet op Mij vertrouwen bij al de tekenen die Ik in zijn midden gedaan heb? ");
INSERT INTO nldnbg_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ik zal het met de pest slaan en het uitroeien, en u tot een volk maken, groter en machtiger dan dit. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Maar Mozes zeide tot de Here: Hoort Egypte het – Gij hebt immers dit volk door uw kracht uit zijn midden doen optrekken – ");
INSERT INTO nldnbg_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","dan zullen zij zeggen tot de inwoners van dit land, die gehoord hebben, dat Gij, Here, in het midden van dit volk zijt, dat Gij, Here, oog in oog U hebt laten zien, terwijl uw wolk boven hen staat en Gij in de wolkkolom vóór hen henen gaat des daags en in de vuurkolom des nachts – ");
INSERT INTO nldnbg_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","zult Gij nu dit volk tot op de laatste man doden, dan zullen de volken die van U bij geruchte hoorden, zeggen: ");
INSERT INTO nldnbg_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Omdat de Here dit volk niet kon brengen naar het land dat Hij hun onder ede beloofd had, daarom heeft Hij hen in de woestijn omgebracht. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nu dan, laat toch de kracht des Heren zich groot betonen, zoals Gij gesproken hebt: ");
INSERT INTO nldnbg_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","De Here is lankmoedig en groot van goedertierenheid, vergevende ongerechtigheid en overtreding, hoewel Hij zeker niet ongestraft laat, maar de ongerechtigheid der vaderen bezoekt aan de kinderen, aan het derde en vierde geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Vergeef toch de ongerechtigheid van dit volk naar de grootheid uwer goedertierenheid, gelijk Gij dit volk vergiffenis geschonken hebt van Egypte af tot hier toe. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","En de Here zeide: Op uw bede schenk Ik vergeving. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Evenwel, zo waar Ik leef en de heerlijkheid des Heren de ganse aarde vervullen zal: ");
INSERT INTO nldnbg_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Geen van de mannen die mijn heerlijkheid gezien hebben, en de tekenen die Ik in Egypte en in de woestijn gedaan heb, en die Mij nu reeds tienmaal verzocht en naar mijn stem niet geluisterd hebben, ");
INSERT INTO nldnbg_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","zal het land zien, dat Ik onder ede aan hun vaderen beloofd heb! Ja, niemand van hen, die Mij versmaad hebben, zal het zien. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Doch omdat bij mijn knecht Kaleb een andere geest geweest is en hij Mij volkomen gevolgd heeft, zal Ik hem naar het land brengen, waar hij heen geweest is, en zijn nakomelingschap zal het bezitten. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","De Amalekieten nu en de Kanaänieten wonen in de Laagvlakte. Wendt u morgen om en trekt op naar de woestijn in de richting van de Schelfzee. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Verder sprak de Here tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Hoelang zal het duren dat deze boze vergadering tegen Mij blijft morren? Het gemor, dat de Israëlieten tegen Mij uiten, heb Ik gehoord. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Zeg tot hen: Zowaar Ik leef, luidt het woord des Heren, Ik zal zeker met u doen gelijk gij te mijnen aanhoren gesproken hebt! ");
INSERT INTO nldnbg_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In deze woestijn zullen uw lijken vallen, namelijk zovelen als er van u geteld zijn, naar uw volle getal, van twintig jaar oud en daarboven, omdat gij tegen Mij gemord hebt. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Voorwaar, gij zult niet komen in het land, waarvan Ik gezworen heb u daarin te doen wonen, behalve Kaleb, de zoon van Jefunne en Jozua, de zoon van Nun! ");
INSERT INTO nldnbg_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","En uw kinderen, van welke gij gezegd hebt: Die zullen tot een buit zijn – hen zal Ik er brengen, opdat zij het land leren kennen, dat gij veracht hebt. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Maar wat u betreft, uw lijken zullen vallen in deze woestijn, ");
INSERT INTO nldnbg_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","en uw zonen zullen veertig jaar lang in de woestijn rondzwerven en uw overspelig gedrag boeten, totdat uw lijken alle in de woestijn liggen. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Overeenkomstig het aantal dagen, gedurende welke gij het land verspied hebt, veertig dagen, zult gij uw ongerechtigheden veertig jaar lang boeten, voor elke dag één jaar, opdat gij weet wat het betekent, als Ik Mij afkeer. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ik, de Here, heb het gesproken. Ik zal dit zeker doen aan heel deze boze vergadering, die tegen Mij samenspant. In deze woestijn zullen zij hun einde vinden en daar zullen zij sterven. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","De mannen nu, die Mozes uitgezonden had om het land te verspieden, en die, toen zij teruggekomen waren, de gehele vergadering tegen hem hadden doen morren door een kwaad gerucht over het land te verspreiden, ");
INSERT INTO nldnbg_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","deze mannen, die een kwaad gerucht over het land verspreid hadden, stierven door een plaag voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Maar van die mannen die uitgegaan waren om het land te verspieden, bleven Jozua, de zoon van Nun, en Kaleb, de zoon van Jefunne, in leven. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Toen Mozes deze woorden tot al de Israëlieten gesproken had, bedreef het volk zware rouw. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","En de volgende morgen vroeg wilden zij de bergtop beklimmen, onder de uitroep: Ziet, wij trekken op naar de plaats, van welke de Here gesproken heeft, want wij hebben gezondigd. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Maar Mozes zeide: Waarom staat gij op het punt het bevel des Heren te overtreden? Dit zal toch niet gelukken. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Trekt niet op, want de Here is niet in uw midden – opdat gij niet de nederlaag lijdt tegen uw vijanden, ");
INSERT INTO nldnbg_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","want de Amalekieten en de Kanaänieten zijn daar tegenover u, en gij zult door het zwaard vallen, daarom dat gij u van de Here hebt afgekeerd, en de Here zal niet met u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Toch waagden zij het de bergtop te beklimmen, doch de ark van het verbond des Heren en Mozes verlieten de legerplaats niet. ");
INSERT INTO nldnbg_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Toen kwamen de Amalekieten en de Kanaänieten die dat gebergte bewoonden, naar beneden, versloegen hen en dreven hen terug tot Chorma toe. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Spreek tot de Israëlieten en zeg tot hen: Wanneer gij komt in het land, dat Ik u ter woning geven zal, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","en gij brengt de Here een vuuroffer, hetzij brandoffer of slachtoffer, hetzij om een gelofte in te lossen, of vrijwillig, of op uw feesten, om de Here een liefelijke reuk te bereiden van runderen of kleinvee, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","dan zal hij die de Here zijn offergave aanbiedt, als spijsoffer aanbieden een tiende efa fijn meel, aangemaakt met een vierde hin olie, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","en wijn tot een plengoffer; een vierde hin zult gij voor elk schaap bij het brandoffer of bij het slachtoffer doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Bij een ram zult gij als spijsoffer twee tienden efa fijn meel doen, aangemaakt met een derde hin olie, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","en wijn tot een plengoffer, een derde hin; gij zult de Here een liefelijke reuk aanbieden. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Wanneer gij een rund zult bereiden als brandoffer of als slachtoffer, hetzij om een gelofte in te lossen, of als vredeoffer voor de Here, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dan zal men bij het rund als spijsoffer drie tienden efa fijn meel aanbieden, aangemaakt met een halve hin olie. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","En wijn zult gij brengen tot een plengoffer, een halve hin, als een vuuroffer tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Aldus zal gedaan worden voor elk rund of voor elke ram of voor een stuk kleinvee, schaap of geit. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Zoveel gij er zult bereiden, voor elk daarvan zult gij aldus doen, naar hun aantal. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Iedere geboren Israëliet zal aldus handelen, wanneer hij een vuuroffer aanbiedt tot een liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","En wanneer een vreemdeling bij u vertoeft, of iemand, die van geslacht op geslacht onder u is, en hij brengt een vuuroffer tot een liefelijke reuk voor de Here, dan zal hij handelen zoals gij; ");
INSERT INTO nldnbg_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","wat de gemeente betreft, éénzelfde inzetting zal gelden zowel voor u als voor de vreemdeling die bij u vertoeft; een altoosdurende inzetting zal het zijn voor uw geslachten: gij en de vreemdeling zullen voor de Here gelijk zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Eénzelfde wet en éénzelfde voorschrift zal gelden zowel voor u als voor de vreemdeling die bij u vertoeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Spreek tot de Israëlieten en zeg tot hen: Wanneer gij komt in het land, waarheen Ik u brengen zal, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","dan zult gij, wanneer gij van de spijs des lands eet, de Here een heffing geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","De eerstelingen van uw gerstemeel zult gij, in de vorm van een koek, als heffing geven; gelijk gij een heffing geeft van uw dorsvloer, zo zult gij het als een heffing geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Van de eerstelingen van uw gerstemeel zult gij de Here een heffing geven, van geslacht tot geslacht. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Wanneer gij nu onopzettelijk een van deze geboden niet volbrengt, die de Here tot Mozes gesproken heeft, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","van alles wat de Here u geboden heeft door de dienst van Mozes van die dag af, dat de Here zijn geboden gaf en daarna, van geslacht tot geslacht, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","en wanneer het buiten weten van de vergadering onopzettelijk geschied is, dan zal de gehele vergadering een jonge stier tot een brandoffer bereiden, tot een liefelijke reuk voor de Here, met het bijbehorend spijsoffer en plengoffer volgens het voorschrift, benevens een geitebok tot een zondoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Dan zal de priester over de gehele vergadering der Israëlieten verzoening doen, en het zal hun vergeven worden, omdat het onopzettelijk was, en omdat zij hun offergaven de Here als een vuuroffer hebben gebracht met hun zondoffer voor het aangezicht des Heren wegens hun onopzettelijke zonde. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Het zal aan de gehele vergadering der Israëlieten vergeven worden, zowel als aan de vreemdeling die in uw midden vertoeft, want het was onopzettelijk over het gehele volk gekomen. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Wanneer één persoon onopzettelijk gezondigd heeft, dan zal hij een éénjarige geit tot een zondoffer aanbieden; ");
INSERT INTO nldnbg_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","en de priester zal over hem die onopzettelijk gezondigd heeft met een onopzettelijke zonde tegen de Here, verzoening doen door over hem de verzoening te volbrengen, en het zal hem vergeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Eénzelfde wet zal voor u gelden, voor de onder de Israëlieten geborene en voor de vreemdeling die in uw midden vertoeft, ten aanzien van hem, die iets doet door een onopzettelijke zonde. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Maar wie iets met voorbedachten rade doet, hetzij geboren Israëliet, hetzij vreemdeling, die zal een lasteraar van de Here zijn, die zal uit zijn volk worden uitgeroeid, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","want hij heeft het woord des Heren veracht en zijn gebod geschonden; die zal zeker uitgeroeid worden, zijn ongerechtigheid is op hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Terwijl de Israëlieten in de woestijn waren, betrapten zij iemand, die op de sabbatdag aan het houtsprokkelen was, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","en zij, die hem betrapt hadden, terwijl hij aan het houtsprokkelen was, brachten hem tot Mozes en Aäron en de gehele vergadering; ");
INSERT INTO nldnbg_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","dezen stelden hem in bewaring omdat nog niet bepaald was wat met hem gedaan moest worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Toen zeide de Here tot Mozes: Die man zal zeker ter dood gebracht worden; de gehele vergadering zal hem buiten de legerplaats stenigen. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toen leidde de gehele vergadering hem buiten de legerplaats, en zij stenigden hem, zodat hij stierf – zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","De Here nu zeide tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Spreek tot de Israëlieten en zeg tot hen, dat zij zich gedenkkwasten maken aan de hoeken van hun klederen, van geslacht tot geslacht, en dat zij in de gedenkkwasten aan de hoeken een blauwpurperen draad verwerken. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Dat zal u dan tot een gedenkkwast zijn; als gij daarnaar ziet, dan zult gij al de geboden des Heren gedenken en die volbrengen zonder uw hart of uw ogen te volgen, dat gij u daardoor tot overspel zoudt laten verleiden, ");
INSERT INTO nldnbg_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","opdat gij gedenkt en volbrengt al mijn geboden en heilig zijt voor uw God. ");
INSERT INTO nldnbg_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ik ben de Here, uw God, die u uit het land Egypte heb uitgeleid om u tot een God te zijn; Ik ben de Here, uw God. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korach nu, de zoon van Jishar, de zoon van Kehat, de zoon van Levi, nam met Datan en Abiram, zonen van Eliab, en On, de zoon van Pelet, Rubenieten, (een aantal mannen); ");
INSERT INTO nldnbg_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","en zij stelden zich vóór Mozes met tweehonderd vijftig mannen uit de Israëlieten, hoofden der vergadering, opgeroepenen ter volksvergadering, mannen van naam. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Zij dan liepen te hoop tegen Mozes en Aäron en zeiden tot hen: Laat het u genoeg zijn, want de gehele vergadering, zij allen zijn heiligen, en de Here is in hun midden. Waarom verheft gij u dan boven de gemeente des Heren? ");
INSERT INTO nldnbg_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Toen Mozes het hoorde, wierp hij zich op zijn aangezicht. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","En hij sprak tot Korach en zijn gehele aanhang: Morgen, dan zal de Here doen weten, wie Hem toebehoort, en wie de heilige is, dat Hij hem tot Zich doe naderen; die Hij verkiezen zal, zal Hij tot Zich doen naderen. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Doet dit: neemt u vuurpannen, gij, Korach en gij, zijn gehele aanhang, ");
INSERT INTO nldnbg_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","doet dan vuur daarin en legt er morgen reukwerk op voor het aangezicht des Heren, en de man die de Here verkiezen zal, die zal de heilige zijn. Laat het u genoeg zijn, Levieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Toen zeide Mozes tot Korach: Hoort toch, gij Levieten! ");
INSERT INTO nldnbg_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is het u te weinig, dat de God van Israël u heeft afgezonderd van de vergadering Israëls om u tot Zich te doen naderen, om de dienst aan de tabernakel des Heren te verrichten en voor het aangezicht der vergadering te staan om hen te dienen, ");
INSERT INTO nldnbg_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","en dat Hij u en al uw broederen, de Levieten, met u deed naderen? Streeft gij nu ook naar het priesterschap? ");
INSERT INTO nldnbg_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Daarom, gij en uw gehele aanhang, gij spant samen tegen de Here, want wat is Aäron, dat gij tegen hem zoudt morren? ");
INSERT INTO nldnbg_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mozes nu zond heen om Datan en Abiram, de zonen van Eliab, te ontbieden, maar zij zeiden: Wij komen niet. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is het een kleinigheid, dat gij ons hebt opgevoerd uit een land, vloeiende van melk en honig, om ons te laten sterven in de woestijn, en wilt gij u ook nog als heerser over ons opwerpen? ");
INSERT INTO nldnbg_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Gij hebt ons waarlijk niet gebracht in een land, vloeiende van melk en honig, noch ons akkers en wijngaarden in bezit gegeven; meent gij de ogen dezer mannen te kunnen verblinden? Wij komen niet. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Toen werd Mozes zeer toornig en hij zeide tot de Here: Wend U niet tot hun spijsoffer; niet één ezel heb ik van hen weggenomen, noch iemand van hen kwaad gedaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","En Mozes zeide tot Korach: Gij en uw gehele aanhang, verschijnt morgen voor het aangezicht des Heren, gij en zij en Aäron! ");
INSERT INTO nldnbg_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Neemt dan ieder zijn vuurpan, legt er reukwerk op en biedt de Here ieder zijn vuurpan aan, tweehonderd vijftig vuurpannen, gij en Aäron, ieder zijn vuurpan. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Zij namen dan ieder zijn vuurpan, deden vuur daarin, legden reukwerk daarop, en stelden zich op bij de ingang van de tent der samenkomst met Mozes en Aäron. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Toen Korach de gehele aanhang bij de ingang van de tent der samenkomst tegen hen had bijeengebracht, verscheen de heerlijkheid des Heren aan de gehele vergadering. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","En de Here sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Scheidt u af van deze vergadering, opdat Ik haar in één oogwenk vertere. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Toen wierpen zij zich op hun aangezicht en zeiden: O God, God der geesten van alle levende schepselen, als één man zondigt, zult Gij dan tegen de gehele vergadering toornen? ");
INSERT INTO nldnbg_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","De Here dan sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Spreek tot de vergadering: Trekt u terug uit de omtrek van de woning van Korach, Datan en Abiram. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Toen maakte Mozes zich op en ging tot Datan en Abiram, en de oudsten van Israël volgden hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","En hij sprak tot de vergadering: Wijkt toch van de tenten dezer goddeloze mannen en raakt niets aan, dat hun toebehoort, opdat gij niet door al hun zonden wordt weggeraapt. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Toen trokken zij weg uit de omtrek van de woning van Korach, Datan en Abiram, en Datan en Abiram traden naar buiten en stonden aan de ingang van hun tenten met hun vrouwen, zonen en kleine kinderen. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Daarop zeide Mozes: Hieraan zult gij weten, dat de Here mij gezonden heeft om al deze daden te doen, en dat het niet mijn bedenksel is: ");
INSERT INTO nldnbg_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","indien dezen zullen sterven, zoals ieder mens sterft, en over hen bezoeking zal worden gedaan, zoals ieder mens bezocht wordt, dan heeft de Here mij niet gezonden. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Maar, indien de Here iets nieuws zal scheppen, zodat de grond zijn mond zal opensperren en hen verzwelgen met alles wat hun toebehoort, zodat zij levend in het dodenrijk zullen dalen, dan zult gij weten, dat deze mannen de Here gesmaad hebben. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Nauwelijks had hij al deze woorden uitgesproken, of de grond spleet onder hen, ");
INSERT INTO nldnbg_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","en de aarde opende haar mond en verzwolg hen met hun huisgezinnen en met alle mensen die bij Korach behoorden en met alle have. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Zo daalden zij, met al de hunnen, levend in het dodenrijk; en de aarde overdekte hen, zodat zij uit het midden der gemeente omkwamen. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","En alle Israëlieten die om hen heen stonden, vluchtten weg op hun geroep, want zij dachten: De aarde moest ook ons eens verzwelgen! ");
INSERT INTO nldnbg_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Toen ging er een vuur uit van de Here en verteerde de tweehonderd vijftig mannen, die het reukwerk geofferd hadden. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Zeg tot Eleazar, de zoon van de priester Aäron, dat hij de vuurpannen uit de brand wegneme, en strooi het vuur ver weg, omdat zij heilig zijn, ");
INSERT INTO nldnbg_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","te weten de vuurpannen dergenen die ten koste van hun leven gezondigd hebben, en maakt deze tot dunne platen, tot een overtrek voor het altaar, want zij hebben ze voor het aangezicht des Heren gebracht, zodat deze geheiligd zijn; zo zullen zij de Israëlieten tot een teken zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Toen nam de priester Eleazar de koperen vuurpannen, welke zij die verbrand waren, hadden gebracht en men plette ze tot een overtrek voor het altaar, ");
INSERT INTO nldnbg_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","een herinnering voor de Israëlieten, opdat geen onbevoegde, die niet behoort tot de nakomelingen van Aäron, nadere om reukwerk te branden voor het aangezicht des Heren, en het hem niet verga als Korach en zijn aanhang, zoals de Here tot hem gesproken had door de dienst van Mozes. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","De volgende dag echter morde de gehele vergadering der Israëlieten tegen Mozes en Aäron, zeggende: Gij hebt het volk des Heren gedood. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Toen nu de vergadering tegen Mozes en Aäron te hoop liep, en zij zich naar de tent der samenkomst wendden, zie, de wolk bedekte haar en de heerlijkheid des Heren verscheen. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Toen kwamen Mozes en Aäron tot vóór de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","De Here dan sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Trekt u terug uit deze vergadering, opdat Ik haar in één ogenblik vertere. Toen wierpen zij zich neder op hun aangezicht. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","En Mozes zeide tot Aäron: Neem een vuurpan, doe er vuur in van het altaar, leg er reukwerk op, en ga haastig tot de vergadering en doe verzoening over hen, want de toorn is van de Here uitgegaan, de plaag is begonnen. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aäron nam (een vuurpan), zoals Mozes gesproken had, en snelde tot midden onder de gemeente, en zie, de plaag was onder het volk begonnen; toen legde hij er reukwerk op en deed verzoening over het volk. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Toen hij tussen de doden en de levenden stond, hield de plaag op. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","En zij, die gestorven waren door de plaag, waren veertienduizend zevenhonderd, behalve degenen die gestorven waren terzake van Korach. ");
INSERT INTO nldnbg_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Toen Aäron tot Mozes terugkeerde aan de ingang van de tent der samenkomst, had de plaag opgehouden. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Spreek tot de Israëlieten en neem van hen voor elke stam één staf van al hun vorsten, naar hun stammen twaalf staven; ieders naam zult gij op zijn staf schrijven; ");
INSERT INTO nldnbg_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","maar de naam van Aäron zult gij op de staf van Levi schrijven, want één staf dient voor het hoofd van hun stam. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Dan zult gij deze nederleggen in de tent der samenkomst vóór de getuigenis, waar Ik met u pleeg samen te komen. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","En de man die Ik verkies, diens staf zal bloeien; zo zal Ik het gemor, waarmee de Israëlieten tegen u morren, tot zwijgen brengen, zodat Ik het niet meer hoor. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nadat nu Mozes tot de Israëlieten gesproken had, gaven al hun vorsten hem voor iedere vorst één staf, naar hun stammen twaalf staven, en de staf van Aäron was onder hun staven. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mozes nu legde de staven neer vóór het aangezicht des Heren in de tent der getuigenis. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Toen Mozes de volgende dag de tent der getuigenis binnenging, zie, de staf van Aäron, voor het huis van Levi, bloeide; hij had bloesem voortgebracht, bloemen gedragen en amandelen doen rijpen. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Toen Mozes al de staven van vóór het aangezicht des Heren tot al de Israëlieten naar buiten bracht, zagen zij het en namen ieder zijn staf. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","En de Here zeide tot Mozes: Breng de staf van Aäron terug vóór de getuigenis, om bewaard te worden tot een teken voor de wederspannigen, zodat gij aan hun gemor een einde maakt en Ik het niet meer hoor, opdat zij niet sterven. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","En Mozes deed het: zoals de Here hem geboden had, deed hij. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","De Israëlieten immers hadden tot Mozes gezegd: Zie wij geven de geest, wij komen om, wij komen allen om. ");
INSERT INTO nldnbg_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Al wie ook maar nadert tot de tabernakel des Heren, zal sterven. Moeten wij dan tot de laatste man de geest geven? ");
INSERT INTO nldnbg_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","De Here nu zeide tot Aäron: Gij en uw zonen en uw familie met u zult de ongerechtigheid, tegen het heiligdom begaan, dragen; en gij en uw zonen zult de ongerechtigheid, in uw priesterambt begaan, dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Doe ook uw broederen, de stam Levi, de stam van uw vader, met u naderen, opdat zij zich bij u aansluiten en u, zowel als uw zonen dienen, vóór de tent der getuigenis; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","opdat zij hun taak vervullen jegens u, zowel als hun taak met betrekking tot de gehele tent; tot het gerei van het heiligdom en tot het altaar echter, zullen zij niet naderen, opdat zij niet sterven, niet alleen zij, maar ook gij; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","en opdat zij zich bij u aansluiten en hun taak vervullen met betrekking tot de tent der samenkomst naar de gehele dienst der tent; maar een onbevoegde zal tot u niet naderen. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Gij echter zult uw taak vervullen met betrekking tot het heilige en het altaar, opdat er geen toorn meer op de Israëlieten ruste. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Zie, Ik zelf heb uw broederen, de Levieten, uit de Israëlieten genomen als een geschenk voor u, als gegevenen aan de Here, om de dienst aan de tent der samenkomst te verrichten; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","maar gij en uw zonen met u zult uw priesterambt vervullen in alles wat bij het altaar behoort en bij hetgeen achter het voorhangsel is, en daarbij dienst doen; als een dienst, die een geschenk is, geef Ik u uw priesterambt; maar de onbevoegde, die nadert, zal ter dood gebracht worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","En de Here sprak tot Aäron: Zie, Ik zelf geef u de verzorging van mijn heffingen; wat al de heilige gaven der Israëlieten betreft, die geef Ik u en uw zonen tot een gewijd deel, tot een altoosdurende inzetting. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Van de allerheiligste gaven, voorzover zij niet verbrand worden, zal dit voor u zijn: al hun offergaven, zowel met betrekking tot al hun spijsoffers als al hun zondoffers en al hun schuldoffers, die zij Mij vergelden; de allerheiligste gaven, die zullen voor u en uw zonen zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Als iets, dat allerheiligst is, zult gij het eten; al wat van het mannelijk geslacht is, zal het eten, het zal u iets heiligs zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Dit komt u toe als heffing van al de beweegoffers die de Israëlieten geven; die geef ik u en uw zonen en uw dochters met u tot een altoosdurende inzetting; al wie in uw gezin rein is, zal het eten. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Al het beste van de olie en al het beste van most en koren, het eerste daarvan, dat zij de Here geven, geef Ik u. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","De eerstelingen van alles wat op hun land is, die zij de Here brengen, zullen voor u zijn; alwie in uw gezin rein is, zal het eten. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alles, waarop in Israël de ban ligt, zal voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Alles, wat het eerst uit de moederschoot voortkomt van al wat leeft, hetgeen zij de Here aanbieden, zowel van mensen als van dieren, zal voor u zijn; alleen zult gij de eerstgeborenen der mensen loskopen, ook zult gij de eerstgeborenen van de onreine dieren loskopen. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Wat zijn losprijs aangaat, gij zult hen, zodra zij één maand oud zijn, loskopen volgens uw schatting tegen een bedrag van vijf sikkels naar de heilige sikkel; deze bedraagt twintig gera. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Echter zult gij de eerstgeborenen van een rund, schaap of geit niet loskopen; zij zijn iets heiligs, hun bloed zult gij op het altaar sprengen en hun vet doen roken als een vuuroffer tot een liefelijke reuk voor de Here; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","maar hun vlees zal voor u zijn; evenals de beweegborst en de rechterschenkel zal het voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle heffingen der heilige gaven, die de Israëlieten als heffingen de Here brengen, geef Ik u en uw zonen en uw dochters met u tot een altoosdurende inzetting, een altoosdurend zoutverbond is het voor het aangezicht des Heren voor u en uw nakomelingschap. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","En de Here zeide tot Aäron: In hun land zult gij geen erfdeel hebben en een stuk land zal u onder hen niet ten deel vallen; Ik ben uw deel en uw erfdeel onder de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Wat nu de Levieten betreft, zie, Ik geef hun alle tienden in Israël als erfdeel, een vergoeding voor de dienst die zij verrichten, de dienst van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","De Israëlieten namelijk zullen niet meer tot de tent der samenkomst naderen, zodat zij zonde op zich laden en sterven; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","de Levieten echter zullen de dienst van de tent der samenkomst verrichten en zij zullen hun ongerechtigheid dragen, een altoosdurende inzetting voor uw nageslacht, en in het midden der Israëlieten zullen zij geen erfdeel verkrijgen; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","want aan de Levieten geef Ik als erfdeel de tiende, die de Israëlieten de Here als heffing brengen; daarom heb Ik van hen gezegd: In het midden der Israëlieten zullen zij geen erfdeel verkrijgen. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tot de Levieten zult gij spreken en tot hen zeggen: Wanneer gij van de Israëlieten de tiende ontvangt, die Ik u van hen als erfdeel geef, dan zult gij daarvan als een heffing voor de Here een tiende van de tiende brengen, ");
INSERT INTO nldnbg_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","en het zal voor u als een heffing beschouwd worden, als ware het het koren van de dorsvloer en de inhoud van de perskuip. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Aldus zult ook gij van al de tienden die gij van de Israëlieten ontvangt, een heffing voor de Here brengen en gij zult daarvan de heffing voor de Here aan de priester Aäron geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Van alles wat u geschonken wordt, zult gij de gehele heffing voor de Here brengen, van al het beste ervan, hetgeen daarvan geheiligd wordt. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","En gij zult tot hen zeggen: Wanneer gij het beste daarvan als heffing brengt, zal dat voor de Levieten beschouwd worden als de opbrengst van de dorsvloer en van de perskuip; ");
INSERT INTO nldnbg_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","gij zult het met uw gezin op elke plaats mogen eten, want het strekt u tot loon als vergoeding voor uw dienst aan de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Gij zult ten aanzien daarvan geen zonde op u laden, indien gij maar het beste daarvan als heffing brengt; zo zult gij de heilige gaven der Israëlieten niet ontwijden, opdat gij niet sterft. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","De Here nu sprak tot Mozes en Aäron: ");
INSERT INTO nldnbg_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dit is het wetsvoorschrift, dat de Here gebiedt: Spreek tot de Israëlieten, dat zij u een rode, gave koe brengen, waaraan geen gebrek is, en die geen juk gedragen heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","En gij zult haar aan de priester Eleazar geven: dan zal men haar buiten de legerplaats brengen en haar in zijn tegenwoordigheid slachten. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Dan zal de priester Eleazar met zijn vinger van haar bloed nemen en van haar bloed zevenmaal sprenkelen in de richting van de voorzijde van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Daarna zal men de koe voor zijn ogen tot as verbranden; haar huid, haar vlees en haar bloed zal men met haar mest verbranden. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","En de priester zal cederhout, hysop en scharlaken nemen en dat midden op de brandende koe werpen. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Vervolgens zal de priester zijn klederen wassen en zijn lichaam in water baden en daarna in de legerplaats komen, maar de priester zal tot de avond onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Hij die haar verbrand heeft, zal zijn klederen in water wassen en zijn lichaam in water baden, maar tot de avond onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Dan zal een rein man de as van de koe verzamelen en buiten de legerplaats op een reine plaats nederleggen, opdat zij voor de vergadering der Israëlieten bewaard blijve ter bereiding van het water der reiniging; het is een middel tot ontzondiging. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","En hij die de as van de koe verzameld heeft, zal zijn klederen wassen, maar tot de avond onrein zijn. Dit zal gelden als een altoosdurende inzetting voor de Israëlieten en voor de vreemdeling die onder u vertoeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Hij die het lijk van enig mens aanraakt, zal zeven dagen onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Hij zal zich op de derde dag ermee ontzondigen, en op de zevende dag zal hij rein zijn. Maar indien hij zich op de derde dag niet ontzondigt, zal hij op de zevende dag niet rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ieder die een lijk, enig mens, die gestorven is, aanraakt, en zich niet ontzondigt, verontreinigt de tabernakel des Heren, en hij zal uit Israël uitgeroeid worden; omdat het water der reiniging op hem niet gesprengd werd, zal hij onrein wezen; zijn onreinheid is nog op hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Dit is de wet, wanneer in een tent iemand gestorven is: ieder die de tent binnengaat en alles wat in de tent is, zal zeven dagen onrein zijn; ");
INSERT INTO nldnbg_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","elk open vat waarover geen doek gebonden is, zal onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ook zal ieder die op het veld iemand aanraakt, die met het zwaard gedood is, of een lijk, of het gebeente van een mens, of een graf, zeven dagen onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Men zal voor de onreine van de as van het dier dat voor ontzondiging verbrand is, nemen en daarop in een vat levend water gieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Dan zal een rein man hysop nemen, dat in het water dopen en dit sprenkelen op de tent en op al de vaten en op de personen die daarin zijn, en op degene die het gebeente, of de gedode, of het lijk, of het graf heeft aangeraakt; ");
INSERT INTO nldnbg_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","de reine zal op de derde dag en op de zevende dag de onreine besprenkelen, en hij zal hem op de zevende dag ontzondigen; en hij zal zijn klederen wassen, zich in water baden en des avonds rein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Maar iemand die onrein geworden is, en zich niet laat ontzondigen, die zal uit de gemeente uitgeroeid worden, omdat hij het heiligdom des Heren verontreinigd heeft; er is geen water der reiniging op hem gesprengd, hij is onrein. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","En het zal hun tot een altoosdurende inzetting zijn. Wie het water der reiniging gesprenkeld heeft, zal zijn klederen wassen en wie het water der reiniging aangeraakt heeft, zal tot de avond onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Alles wat de onreine aanraakt, zal onrein zijn, en wie hem aanraakt, zal tot de avond onrein zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","De Israëlieten dan, de gehele vergadering, kwamen in de woestijn Sin, in de eerste maand, en het volk verbleef te Kades; Mirjam stierf daar en werd daar begraven. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Toen de vergadering geen water had, liep zij te hoop tegen Mozes en Aäron, ");
INSERT INTO nldnbg_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","en het volk twistte met Mozes en zeide: Waren wij maar gestorven, toen onze broeders voor het aangezicht des Heren stierven! ");
INSERT INTO nldnbg_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Waarom hebt gij de gemeente des Heren in deze woestijn gebracht, zodat wij en ons vee daar moeten sterven? ");
INSERT INTO nldnbg_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Waarom hebt gij ons uit Egypte doen optrekken, om ons in dit barre oord te brengen, waar geen koren, vijgeboom, wijnstok en granaatappel groeien en waar geen water is om te drinken. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Toen ging Mozes met Aäron van de gemeente weg naar de ingang van de tent der samenkomst en zij wierpen zich neder op hun aangezicht, en de heerlijkheid des Heren verscheen hun. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Toen sprak de Here tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Neem de staf en laat de vergadering samenkomen, gij en uw broeder Aäron; spreek dan in hun tegenwoordigheid tot de rots, dan zal zij haar water geven; gij zult voor hen water uit de rots te voorschijn doen komen en de vergadering en hun vee drenken. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Toen nam Mozes de staf van vóór het aangezicht des Heren, zoals Hij hem geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Toen Mozes en Aäron de gemeente vóór de rots hadden doen samenkomen, zeide hij tot hen: Hoort toch, wederspannigen, zullen wij uit deze rots voor u water te voorschijn doen komen? ");
INSERT INTO nldnbg_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Daarop hief Mozes zijn hand op en sloeg de rots met zijn staf tweemaal, en er kwam veel water uit, zodat de vergadering kon drinken en ook het vee. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Maar de Here zeide tot Mozes en Aäron: Aangezien gij op Mij niet vertrouwd hebt en Mij ten aanschouwen van de Israëlieten niet geheiligd hebt, daarom zult gij deze gemeente niet brengen in het land, dat Ik hun geef. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Dit is het water van Meriba, waar de Israëlieten met de Here twistten en Hij Zich onder hen de Heilige betoonde. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mozes nu zond uit Kades boden tot de koning van Edom: Zo zegt uw broeder Israël: Gij weet van al de moeite, die ons overkomen is: ");
INSERT INTO nldnbg_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","hoe onze vaderen naar Egypte trokken, en wij lange tijd in Egypte woonden, en de Egyptenaren ons en onze vaderen slecht behandelden. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Toen riepen wij tot de Here, en Hij hoorde onze stem, zond een engel en leidde ons uit Egypte; en zie, nu zijn wij te Kades, een stad aan de grens van uw gebied. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laat ons toch door uw land trekken; wij zullen niet door akkers en wijngaarden trekken en wij zullen geen welwater drinken; de koninklijke weg zullen wij gaan, zonder naar rechts of naar links af te wijken, totdat wij uw gebied zullen zijn doorgetrokken. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Maar Edom zeide tot hem: Gij zult niet door mijn gebied gaan, anders trek ik met het zwaard u tegemoet. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Toen zeiden de Israëlieten tot hem: Wij zullen langs de gebaande weg optrekken, en indien ik en mijn vee van uw water drinken, dan zal ik de prijs daarvoor betalen; ik wil niet anders dan te voet doortrekken. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Maar hij zeide: Gij zult niet doortrekken. En Edom rukte uit hem tegemoet met een geweldig leger en een sterke macht. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Toen nu Edom weigerde Israël door zijn gebied te laten trekken, boog Israël zijwaarts van hem af. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Nadat zij uit Kades opgebroken waren, kwamen de Israëlieten, de gehele vergadering, bij de berg Hor. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Toen zeide de Here tot Mozes en Aäron bij de berg Hor, aan de grens van het land Edom: ");
INSERT INTO nldnbg_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aäron zal tot zijn voorgeslacht vergaderd worden, want hij zal niet komen in het land, dat Ik de Israëlieten geef, omdat gijlieden bij het water van Meriba tegen mijn bevel weerspannig zijt geweest. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Neem Aäron en zijn zoon Eleazar en laat hen de berg Hor beklimmen; ");
INSERT INTO nldnbg_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","laat Aäron zijn klederen uittrekken en bekleed zijn zoon Eleazar daarmee, dan zal Aäron tot zijn voorgeslacht vergaderd worden en daar sterven. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","En Mozes deed, zoals de Here geboden had en zij beklommen de berg Hor ten aanschouwen van de gehele vergadering. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","En Mozes liet Aäron zijn klederen uittrekken en bekleedde daarmee zijn zoon Eleazar. Toen stierf Aäron daar op de top van de berg, en Mozes daalde met Eleazar van de berg af. ");
INSERT INTO nldnbg_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Toen de gehele vergadering bemerkte, dat Aäron de geest gegeven had, beweende het ganse huis Israëls Aäron dertig dagen. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Toen de Kanaäniet, de koning van Arad, die in het Zuiderland woonde, hoorde, dat Israël langs de weg van Atarim kwam, streed hij tegen Israël, en voerde enigen gevankelijk weg. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Daarop deed Israël de Here een gelofte en zeide: Indien Gij dit volk volkomen in mijn macht geeft, zal ik hun steden met de ban slaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","En de Here hoorde naar Israël en gaf de Kanaäniet over; toen sloegen zij hen en hun steden met de ban. Daarom noemde men die plaats Chorma. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Toen zij van de berg Hor opgebroken waren in de richting van de Schelfzee ten einde om het land Edom heen te trekken, werd het volk onderweg ongeduldig. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","En het volk sprak tegen God en tegen Mozes: Waarom hebt gij ons uit Egypte gevoerd? om te sterven in de woestijn? Want er is geen brood en geen water en van deze flauwe spijs walgen wij. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Toen zond de Here vurige slangen onder het volk; die beten het volk, zodat er velen van Israël stierven. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Daarop kwam het volk tot Mozes en zeide: Wij hebben gezondigd, want wij hebben tegen de Here en tegen u gesproken; bid tot de Here, dat Hij de slangen van ons wegdoe. Toen bad Mozes ten gunste van het volk. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","De Here dan zeide tot Mozes: Maak een vurige slang en plaats die op een staak; ieder, die daarnaar ziet, wanneer hij gebeten is, zal in leven blijven. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Toen maakte Mozes een koperen slang en plaatste die op een staak; en wie, wanneer een slang hem gebeten had, op de koperen slang de blik richtte, bleef in leven. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","De Israëlieten nu braken op en legerden zich te Obot. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","En zij braken op uit Obot en legerden zich bij de puinhopen van Abarim, in de woestijn, die ten oosten van Moab ligt, tegen de opgang der zon. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Vandaar braken zij op en legerden zich in het dal van de Zered. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Vandaar braken zij op en legerden zich aan de overzijde van de Arnon, die in de woestijn stroomt en die uit het gebied der Amorieten komt, want de Arnon is de grens tussen Moab en de Amorieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Daarom wordt gezegd in het boek van de oorlogen des Heren: Waheb in Sufa en de dalen, de Arnon, ");
INSERT INTO nldnbg_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","en de helling der dalen, die zich uitstrekt naar de woning van Ar en leunt tegen de grens van Moab. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Vandaar ging het naar Beër. Dit is de bron, waarvan de Here tot Mozes gezegd had: Vergader het volk, dan zal Ik hun water geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Toen heeft Israël dit lied gezongen:Wel op, gij bron:zingt haar in beurtzang toe; ");
INSERT INTO nldnbg_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","de bron, die de vorsten groeven, die edelen des volks boorden met hun scepter, met hun staven.En van de woestijn ging het naar Mattana. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","En van Mattana naar Nachaliël; en van Nachaliël naar Bamot, ");
INSERT INTO nldnbg_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","en van Bamot naar het dal, dat in het veld van Moab is, bij de top van de Pisga, die uitziet over de Wildernis. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israël nu zond boden tot Sichon, de koning der Amorieten, met het verzoek: ");
INSERT INTO nldnbg_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laat mij door uw land trekken; wij zullen niet afbuigen door akkers en wijngaarden, wij zullen geen welwater drinken, de koninklijke weg zullen wij gaan, totdat wij uw gebied doorgetrokken zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Doch Sichon stond Israël niet toe door zijn gebied te trekken, maar verzamelde zijn gehele krijgsmacht en trok Israël tegemoet de woestijn in, en gekomen bij Jahas, streed hij tegen Israël. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Maar Israël sloeg hem met de scherpte des zwaards en nam zijn land in bezit van de Arnon af tot de Jabbok, tot aan de Ammonieten toe, want de grens der Ammonieten was sterk. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","En Israël nam al die steden in en ging wonen in alle steden der Amorieten, in Chesbon en al haar onderhorige plaatsen. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Want Chesbon was de stad van Sichon, de koning der Amorieten; deze had tegen de vorige koning van Moab gestreden en diens gehele land aan zijn macht ontrukt, tot de Arnon toe. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daarom zeggen de spreukendichters:Komt te Chesbon, gebouwd en versterkt worde Sichons stad! ");
INSERT INTO nldnbg_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Want vuur ging er uit van Chesbon, een vlam uit Sichons stad; het verteerde Ar-Moab, de heerseres over de hoogten van de Arnon. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wee u, Moab; verloren zijt gij, volk van Kemos!Hij maakte zijn zonen vluchtelingen, zijn dochters gevangenen van Sichon, de koning der Amorieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Wij hebben hen beschoten, Chesbon ging verloren, tezamen met Dibon, en wij verwoestten het tot Nofach, dat reikt tot Medeba. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israël woonde in het land der Amorieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Nadat Mozes Jazer had laten verspieden, namen zij haar onderhorige plaatsen in en verdreven de Amorieten, die daar waren. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Daarop wendden zij zich en trokken op in de richting van Basan; toen trok Og, de koning van Basan, hun tegemoet, hij en zijn gehele volk, om bij Edreï slag te leveren. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Doch de Here zeide tot Mozes: Vrees hem niet, want Ik geef hem met zijn gehele volk en zijn land in uw macht, en gij zult met hem doen, gelijk gij gedaan hebt met Sichon, de koning der Amorieten, die te Chesbon woonde. ");
INSERT INTO nldnbg_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","En zij versloegen hem en zijn zonen en zijn gehele volk zo volkomen, dat zij niemand lieten ontkomen; en zij namen zijn land in bezit. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Toen braken de Israëlieten op en legerden zich in de velden van Moab, aan de overzijde van de Jordaan bij Jericho. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak nu, de zoon van Sippor, zag alles wat Israël met de Amorieten had gedaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Toen werd Moab zeer bang voor het volk, omdat het talrijk was, en Moab werd bevreesd vanwege de Israëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Toen zeide Moab tot de oudsten van Midjan: Nu zal die menigte onze gehele streek afscheren, zoals een rund het groen des velds afscheert. In die tijd nu was Balak, de zoon van Sippor, koning over Moab. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Hij dan zond boden naar Bileam, de zoon van Beor, naar Petor, dat aan de Rivier ligt, naar het land zijner volksgenoten, om hem te ontbieden met deze woorden: Daar is een volk getrokken uit Egypte; zie, het overdekt de oppervlakte van het land, terwijl het tegenover mij gelegerd is. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nu dan, kom toch en vervloek mij dit volk, want het is sterker dan ik; misschien zal ik dan in staat zijn het te verslaan en uit het land te verdrijven, want ik weet: wie gij zegent, die is gezegend, en wie gij vervloekt, die is vervloekt. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Toen gingen de oudsten van Moab en van Midjan, met het waarzeggersloon bij zich, op weg, en bij Bileam aangekomen, brachten zij hem de woorden van Balak over. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Hij dan zeide tot hen: Overnacht hier deze nacht, dan zal ik u bescheid geven, zoals de Here tot mij spreken zal. Toen bleven de vorsten van Moab bij Bileam. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God nu kwam tot Bileam en zeide: Wie zijn die mannen bij u? ");
INSERT INTO nldnbg_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","En Bileam zeide tot God: Balak, de zoon van Sippor, de koning van Moab, heeft tot mij de boodschap gezonden: ");
INSERT INTO nldnbg_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Zie, er is een volk, dat getrokken is uit Egypte, en dat de oppervlakte van het land overdekt; nu dan, kom vervloek het mij, misschien zal ik dan in staat zijn daartegen te strijden en zal ik het verdrijven. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Toen zeide God tot Bileam: Gij zult met hen niet medegaan, gij zult dat volk niet vervloeken, want het is gezegend. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","En Bileam stond des morgens op en zeide tot de vorsten van Balak: Gaat naar uw land, want de Here weigert mij toe te staan met u mee te gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Toen begaven de vorsten van Moab zich op weg en bij Balak aangekomen, zeiden zij: Bileam weigerde met ons mee te gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Maar Balak zond opnieuw vorsten, talrijker en aanzienlijker dan dezen. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Bij Bileam aangekomen, zeiden zij tot hem: Zó zegt Balak, de zoon van Sippor: Laat u toch niet weerhouden tot mij te komen, ");
INSERT INTO nldnbg_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","want ik zal u rijk belonen; alles wat gij mij zult zeggen, zal ik doen; kom toch, en vervloek mij dit volk. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Maar Bileam antwoordde en zeide tot de dienaren van Balak: Al gaf Balak mij zijn huis vol zilver en goud, ik zou niet in staat zijn het bevel van de Here, mijn God, te overtreden, door iets kleins of iets groots te doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nu dan, blijft ook gij toch deze nacht hier, opdat ik wete, wat de Here verder tot mij spreken zal. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God nu kwam tot Bileam des nachts en zeide tot hem: Nu die mannen gekomen zijn om u te ontbieden, sta op, ga met hen mede, maar alleen het woord, dat Ik tot u spreken zal, zult gij volbrengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Toen stond Bileam des morgens op, zadelde zijn ezelin en ging met de vorsten van Moab mee. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Maar de toorn Gods ontbrandde, toen hij ging, en de Engel des Heren stelde zich op de weg als zijn tegenstander; (Bileam) reed op zijn ezelin en had twee zijner dienaren bij zich. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Toen de ezelin de Engel des Heren op de weg zag staan, met getrokken zwaard in de hand, boog zij van de weg af en ging de akker op; en Bileam sloeg de ezelin om haar naar de weg terug te drijven. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Daarop ging de Engel des Heren staan in een holle weg tussen wijngaarden, waar een muur was aan beide zijden. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Toen de ezelin de Engel des Heren zag, drukte zij zich tegen de muur aan, zodat zij Bileams voet tegen de muur klemde; toen sloeg hij haar opnieuw. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","De Engel des Heren ging andermaal verder en ging staan op een enge plaats, waar geen ruimte was om rechts of links uit te wijken. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Toen de ezelin de Engel des Heren zag, ging zij onder Bileam liggen; toen ontbrandde de toorn van Bileam en hij sloeg de ezelin met de stok. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nu opende de Here de mond der ezelin, en zij zeide tot Bileam: Wat heb ik u gedaan, dat gij mij nu driemaal geslagen hebt? ");
INSERT INTO nldnbg_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","En Bileam zeide tot de ezelin: Omdat gij de spot met mij drijft; had ik een zwaard in mijn hand, dan zou ik u nu zeker doden. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Maar de ezelin zeide tot Bileam: Ben ik niet uw ezelin, waarop gij uw leven lang tot op deze dag hebt gereden? Ben ik ooit gewoon geweest u zó te behandelen? En hij zeide: Neen. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Toen opende de Here de ogen van Bileam; hij zag de Engel des Heren met getrokken zwaard in de hand op de weg staan en hij knielde neer en wierp zich op zijn aangezicht. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","De Engel des Heren zeide tot hem: Om welke reden hebt gij uw ezelin nu driemaal geslagen? Zie, Ik ben uitgegaan als een tegenstander, want deze weg voert bij Mij ten ondergang. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Toen de ezelin Mij zag, is zij nu driemaal voor Mij uitgeweken; ware zij voor Mij niet uitgeweken, voorwaar, dan zou Ik nu juist u gedood en haar in het leven hebben gelaten. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Toen zeide Bileam tot de Engel des Heren: Ik heb gezondigd, omdat ik niet wist, dat Gij U op de weg tegenover mij gesteld hadt, en nu, indien het kwaad is in uw ogen, wil ik wel omkeren. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Maar de Engel des Heren zeide tot Bileam: Ga met die mannen mede, doch alleen het woord, dat Ik tot u spreken zal, zult gij spreken. Daarop ging Bileam met de vorsten van Balak mede. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Toen Balak hoorde, dat Bileam in aantocht was, ging hij hem tegemoet tot de stad van Moab in het gebied van de Arnon, aan de uiterste grens van het gebied. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","En Balak zeide tot Bileam: Heb ik u niet dringend laten ontbieden? Waarom zijt gij niet tot mij gekomen? Ben ik werkelijk niet in staat u te belonen? ");
INSERT INTO nldnbg_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Maar Bileam zeide tot Balak: Zie, nu ben ik tot u gekomen; zal ik wel iets kunnen spreken? Het woord, dat God in mijn mond zal leggen, zal ik spreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Toen ging Bileam met Balak mee en zij kwamen te Kirjat-Chusot, ");
INSERT INTO nldnbg_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak offerde runderen en schapen en zond daarvan aan Bileam en de vorsten die bij hem waren. ");
INSERT INTO nldnbg_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","De volgende morgen nam Balak Bileam mede en liet hem de hoogten van Bamot-Baäl beklimmen, vanwaar hij het uiterste deel van het volk zag. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Toen zeide Bileam tot Balak: Bouw mij hier zeven altaren en bereid mij hier zeven stieren en zeven rammen. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak deed, zoals Bileam gesproken had, en Balak offerde met Bileam een stier en een ram op elk altaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Daarop zeide Bileam tot Balak: Ga bij uw brandoffer staan, dan wil ik heengaan; misschien zal de Here mij tegemoet komen, en welk woord Hij mij ook doet zien, dat zal ik u bekend maken. Toen ging hij een kale heuvel op. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","God nu ontmoette Bileam en hij zeide tot Hem: De zeven altaren heb ik gereed gemaakt en op elk altaar een stier en een ram geofferd. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","En de Here legde een woord in de mond van Bileam en zeide: Keer tot Balak terug en spreek aldus. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Toen hij bij hem terugkwam, stond hij daar nog bij zijn brandoffer, hij en al de vorsten van Moab. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Toen hief hij zijn spreuk aan en zeide:Uit Aram voerde mij Balak, Moabs koning, uit de bergen van het Oosten:Kom, vervloek mij Jakob, en kom, verwens Israël. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Hoe zal ik vervloeken, die God niet vervloekt? Hoe zal ik verwensen, die de Here niet verwenst? ");
INSERT INTO nldnbg_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Want van der rotsen top zie ik hem, van de heuvelen aanschouw ik hem. Zie, een volk, dat alleen woont en onder de natiën zich niet rekent. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wie telt het stof van Jakob en wie berekent de drommen van Israël? Sterve ik zelf de dood der oprechten en zij mijn einde daaraan gelijk! ");
INSERT INTO nldnbg_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Toen zeide Balak tot Bileam: Wat hebt gij mij gedaan? Om mijn vijanden te vervloeken heb ik u gehaald en zie, gij hebt juist gezegend. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Maar hij antwoordde en zeide: Zal ik niet nauwgezet spreken, wat de Here in mijn mond legt? ");
INSERT INTO nldnbg_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak dan zeide tot hem: Ga toch met mij mee naar een andere plaats, vanwaar gij het (volk) zien kunt; gij ziet slechts het uiterste deel ervan, maar in zijn geheel ziet gij het niet; vervloek het mij dan vandaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Toen nam hij hem mede naar het veld der Spieders, naar de top van de Pisga; hij bouwde zeven altaren en offerde een stier en een ram op elk altaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","En hij zeide tot Balak: Ga hier bij uw brandoffer staan, terwijl mij ginds een ontmoeting ten deel valt. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","De Here nu ontmoette Bileam en legde een woord in zijn mond en Hij zeide: Keer tot Balak terug en spreek aldus. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Toen hij bij hem terugkwam, stond hij daar nog bij zijn brandoffer en de vorsten van Moab met hem. En Balak zeide tot hem: Wat heeft de Here gesproken? ");
INSERT INTO nldnbg_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Toen hief hij zijn spreuk aan en zeide:Sta op, Balak, en hoor; leen mij het oor, zoon van Sippor. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is geen man, dat Hij liegen zou; of een mensenkind, dat Hij berouw zou hebben.Zou Hij zeggen en niet doen, of spreken en niet volbrengen? ");
INSERT INTO nldnbg_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Zie, ik heb bevel ontvangen te zegenen, en zegent Hij, dan keer ik het niet. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Men schouwt geen onheil in Jakob, en ziet geen rampspoed in Israël.De Here, zijn God, is met hem, en gejubel over de Koning is bij hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God, die hen uitleidde uit Egypte, is hem als de hoornen van de wilde stier, ");
INSERT INTO nldnbg_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","want er bestaat geen bezwering tegen Jakob, noch waarzeggerij tegen Israël.Thans worde gezegd van Jakob en van Israël wat God doet: ");
INSERT INTO nldnbg_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Zie, een volk, dat als een leeuwin opstaat, en als een leeuw zich verheft, die zich niet neerlegt, eer hij buit gegeten en bloed van gevallenen gedronken heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Toen zeide Balak tot Bileam: Als gij het beslist niet vervloeken wilt, dan zult gij het in geen geval zegenen. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Maar Bileam antwoordde en zeide tot Balak: Heb ik u niet gezegd: Alles wat de Here zal spreken, dat zal ik doen? ");
INSERT INTO nldnbg_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak dan zeide tot Bileam: Kom toch, ik zal u meenemen naar een andere plaats; misschien zal het in Gods ogen recht zijn, dat gij hem mij vandaar vervloekt. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Toen nam Balak Bileam mee naar de top van de Peor, die uitziet over de Wildernis. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","En Bileam zeide tot Balak: Bouw mij hier zeven altaren en bereid mij hier zeven stieren en zeven rammen. ");
INSERT INTO nldnbg_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Toen deed Balak, zoals Bileam gezegd had, en offerde een stier en een ram op elk altaar. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Daar Bileam zag, dat het in de ogen des Heren goed was Israël te zegenen, ging hij niet, zoals een- en andermaal, op bezwering uit, maar richtte zijn gelaat naar de woestijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Toen Bileam zijn ogen ophief, zag hij Israël naar zijn stammen gelegerd, en de Geest Gods kwam over hem. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Toen hief hij zijn spreuk aan en zeide:De spreuk van Bileam, de zoon van Beor, en de spreuk van de man met het geopend oog; ");
INSERT INTO nldnbg_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","de spreuk van hem, die de woorden Gods hoort,die het gezicht des Almachtigen schouwt, nederliggende met ontsloten ogen. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hoe goed zijn uw tenten, o Jakob, uw woningen, o Israël! ");
INSERT INTO nldnbg_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Als valleien breiden zij zich uit; als tuinen aan een rivier; als aloë’s, die de Here plantte; als cederen aan het water. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Water vloeie uit zijn emmers, en zijn zaad hebbe overvloedig water; ja, zijn koning verheffe zich boven Agag, en zijn koninkrijk zij verheven. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God, die hem uitleidde uit Egypte, is hem als de hoornen van de wilde stier.Volken, die zijn vijanden zijn, verslinde hij, en hun beenderen vermorzele hij en hij doorbore ze met zijn pijlen. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Hij kromt zich, en legt zich neder als een leeuw, en als een leeuwin; wie zal hem doen opstaan?Gezegend, die u zegenen; en die u vervloeken, vervloekt! ");
INSERT INTO nldnbg_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Toen ontbrandde de toorn van Balak tegen Bileam en hij sloeg zijn handen in elkaar en Balak zeide tot Bileam: Om mijn vijanden te vervloeken heb ik u geroepen, en zie, gij hebt nu driemaal achtereen een zegen uitgesproken. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nu dan, pak u weg naar uw woonplaats; ik heb wel gezegd: Ik zal u rijk belonen, maar zie, de Here heeft u het loon onthouden. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Maar Bileam zeide tot Balak: Heb ik dan niet tot de boden, die gij gezonden hebt, gesproken: ");
INSERT INTO nldnbg_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Al gaf Balak mij zijn huis vol zilver en goud, ik zou niet in staat zijn het bevel des Heren te overtreden door goed of kwaad te doen uit mijzelf; wat de Here spreken zal, dat zal ik spreken. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","En nu, zie, ik sta op het punt naar mijn volk te gaan; kom, ik zal u aankondigen wat dit volk in de toekomst uw volk zal aandoen. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Toen hief hij zijn spreuk aan en zeide:De spreuk van Bileam, de zoon van Beor, en de spreuk van de man met het geopend oog; ");
INSERT INTO nldnbg_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","de spreuk van hem, die de woorden Gods hoort, en die de wetenschap des Allerhoogsten kent,die het gezicht des Almachtigen schouwt, nederliggende met ontsloten ogen. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ik zie hem, maar niet nu; ik schouw hem, maar niet van nabij; een ster gaat op uit Jakob, een scepter rijst op uit Israël, en verbrijzelt Moabs slapen, en verplettert alle zonen van Set. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Dan zal Edom een veroverd gebied wezen, en Seïr zal een veroverd gebied wezen – zijn vijanden. Maar Israël zal kracht oefenen, ");
INSERT INTO nldnbg_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","en hij zal heersen uit Jakob, en de vluchtelingen uit de stad verdelgen. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Toen hij Amalek zag, hief hij zijn spreuk aan en zeide:Eerste der volken is Amalek, maar zijn einde zal ondergang zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Toen hij de Kenieten zag, hief hij zijn spreuk aan en zeide:Vast is uw woning, gesteld op de rots is uw nest, ");
INSERT INTO nldnbg_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","nochtans zal Kaïn tot verwoesting zijn;hoe lang nog of Assur voert u gevankelijk weg. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hij hief ook zijn spreuk aan en zeide:Wee! wie zal leven, als God dat tot stand zal brengen? ");
INSERT INTO nldnbg_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Maar schepen van de kust der Kittiërs!Die zullen Assur onderdrukken en Eber onderdrukken, maar ook hij zal ten onder gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Toen maakte Bileam zich op en keerde naar zijn woonplaats terug, en ook Balak ging zijns weegs. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Terwijl Israël in Sittim verbleef, begon het volk ontucht te plegen met de dochters van Moab. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Dezen nodigden het volk tot de slachtoffers van haar goden en het volk at daarvan en boog zich neer voor haar goden. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Toen Israël zich aan Baäl-Peor gekoppeld had, ontbrandde de toorn des Heren tegen Israël ");
INSERT INTO nldnbg_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","en de Here zeide tot Mozes: Neem al de oversten van het volk en hang hen in het openbaar op voor de Here, opdat de brandende toorn des Heren zich van Israël afwende. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Toen zeide Mozes tot de richters van Israël: Ieder dode diegenen onder zijn mannen, die zich aan Baäl-Peor gekoppeld hebben. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","En zie, een der Israëlieten kwam een Midjanitische bij zijn broeders brengen ten aanschouwen van Mozes en van de gehele vergadering der Israëlieten, terwijl dezen weenden aan de ingang van de tent der samenkomst. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Toen Pinechas, de zoon van Eleazar, de zoon van de priester Aäron, dat zag, stond hij midden uit de vergadering op en nam een speer in zijn hand; ");
INSERT INTO nldnbg_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","toen hij de Israëlitische man tot in het vertrek achterhaald had, doorstak hij hen beiden, zowel de Israëlitische man, als de vrouw, in het onderlijf. Toen hield de plaag over de Israëlieten op. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Het getal van hen die aan de plaag gestorven waren, bedroeg vierentwintigduizend. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","De Here nu zeide tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinechas, de zoon van Eleazar, de zoon van de priester Aäron, heeft mijn toorn van de Israëlieten afgewend, doordat hij met een ijver voor Mij in hun midden heeft geijverd, zodat Ik de Israëlieten in mijn ijver niet heb verdelgd. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Zeg daarom: Zie, Ik geef hem mijn verbond des vredes, ");
INSERT INTO nldnbg_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","opdat het voor hem en zijn nakomelingen tot een verbond van een altoosdurend priesterschap zij, omdat hij voor zijn God geijverd en over de Israëlieten verzoening gedaan heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","De Israëliet die tegelijk met de Midjanitische gedood werd, heette Zimri en was de zoon van Salu, een familievorst der Simeonieten, ");
INSERT INTO nldnbg_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","en de Midjanitische vrouw die gedood was, heette Kozbi en was de dochter van Sur; hij was een familiestamhoofd in Midjan. ");
INSERT INTO nldnbg_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","De Here nu sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Behandelt de Midjanieten als vijanden en doodt hen, ");
INSERT INTO nldnbg_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","want zij hebben u vijandig behandeld met de listen die zij tegen u bedacht hebben ten aanzien van Peor en ten aanzien van Kozbi, de dochter van de Midjanitische vorst, hun zuster, die gedood is ten dage van de plaag ter oorzake van Peor. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Na de plaag zeide de Here tot Mozes en tot Eleazar, de zoon van de priester Aäron; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Neemt het aantal der gehele vergadering der Israëlieten op, van twintig jaar oud en daarboven naar hun families, allen die in het leger uitrukken in Israël. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Toen spraken Mozes en de priester Eleazar, tot hen in de velden van Moab aan de Jordaan bij Jericho: ");
INSERT INTO nldnbg_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Van twintig jaar oud en daarboven! – zoals de Here Mozes geboden had, te weten de Israëlieten, die uit het land Egypte getrokken waren. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben was Israëls eerstgeborene; de zonen van Ruben waren: van Chanok het geslacht der Chanokieten; van Pallu het geslacht der Palluïeten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","van Chesron het geslacht der Chesronieten en van Karmi het geslacht der Karmieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dit waren de geslachten der Rubenieten, en hun getelden waren drieënveertigduizend zevenhonderd dertig. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","De zoon nu van Pallu was Eliab, ");
INSERT INTO nldnbg_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","en de zonen van Eliab waren Nemuël, Datan en Abiram. Deze Datan en Abiram waren de opgeroepenen der vergadering, die met Mozes en Aäron getwist hadden in de bende van Korach, toen dezen twistten tegen de Here, ");
INSERT INTO nldnbg_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","maar de aarde had haar mond geopend en hen met Korach verslonden, toen de bende stierf, doordat het vuur de tweehonderd vijftig mannen verteerde, zodat zij tot een teken werden; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","maar de zonen van Korach waren niet gestorven. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","De zonen van Simeon, naar hun geslachten, waren: van Nemuël het geslacht der Nemuëlieten; van Jamin het geslacht der Jaminieten; van Jakin het geslacht der Jakinieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","van Zerach het geslacht der Zarchieten en van Saul het geslacht der Saulieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Dit waren de geslachten der Simeonieten, tweeëntwintigduizend tweehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","De zonen van Gad, naar hun geslachten, waren: van Sefon het geslacht der Sefonieten; van Chaggi het geslacht der Chaggieten; van Suni het geslacht der Sunieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","van Ozni het geslacht der Oznieten; van Eri het geslacht der Erieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","van Arod het geslacht der Arodieten en van Areli het geslacht der Arelieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Dit waren de geslachten der zonen van Gad, naar hun getelden, veertigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","De zonen van Juda waren: Er en Onan; en Er en Onan stierven in het land Kanaän. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","De zonen van Juda, naar hun geslachten, nu waren: van Sela het geslacht der Selanieten; van Peres het geslacht der Parsieten en van Zerach het geslacht der Zarchieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","De zonen van Peres waren: van Chesron het geslacht der Chesronieten en van Chamul het geslacht der Chamulieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Dit waren de geslachten van Juda, naar hun getelden, zesenzeventigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","De zonen van Issakar, naar hun geslachten, waren: van Tola het geslacht der Tolaïeten; van Puwwa het geslacht der Punieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","van Jasub het geslacht der Jasubieten en van Simron het geslacht der Simronieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Dit waren de geslachten van Issakar, naar hun getelden, vierenzestigduizend driehonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","De zonen van Zebulon, naar hun geslachten, waren: van Sered het geslacht der Sardieten; van Elon het geslacht der Elonieten en van Jachleël het geslacht der Jachleëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Dit waren de geslachten der Zebulonieten, naar hun getelden, zestigduizend vijfhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","De zonen van Jozef, naar hun geslachten, waren Manasse en Efraïm. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","De zonen van Manasse waren: van Makir het geslacht der Makirieten; en Makir verwekte Gilead; van Gilead het geslacht der Gileadieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dit waren de zonen van Gilead: van Iëzer het geslacht der Iëzrieten; van Chelek het geslacht der Chelekieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","van Asriël het geslacht der Asriëlieten; van Sekem het geslacht der Sekemieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","van Semida het geslacht der Semidaïeten en van Chefer het geslacht der Cheferieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","en Selofchad, de zoon van Chefer, had geen zonen, maar wel dochters, en de namen der dochters van Selofchad waren Machla, Noa, Chogla, Milka en Tirsa. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Dit waren de geslachten van Manasse, en hun getelden waren tweeënvijftigduizend zevenhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Dit waren de zonen van Efraïm, naar hun geslachten: van Sutelach het geslacht der Sutalchieten; van Beker het geslacht der Bakrieten en van Tachan het geslacht der Tachanieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","En dit waren de zonen van Sutelach: van Eran het geslacht der Eranieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Dit waren de geslachten der zonen van Efraïm, naar hun getelden, tweeëndertigduizend vijfhonderd. Dit waren de zonen van Jozef naar hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","De zonen van Benjamin, naar hun geslachten, waren: van Bela het geslacht der Balieten; van Asbel het geslacht der Asbelieten; van Achiram het geslacht der Achiramieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","van Sefufam het geslacht der Sufamieten en van Chufam het geslacht der Chufamieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","En de zonen van Bela waren Ard en Naäman; (van Ard was) het geslacht der Ardieten en van Naäman het geslacht der Naämieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dit waren de zonen van Benjamin naar hun geslachten, en hun getelden waren vijfenveertigduizend zeshonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dit waren de zonen van Dan, naar hun geslachten: van Sucham het geslacht der Suchamieten. Dit waren de geslachten van Dan naar hun geslachten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Al de geslachten der Suchamieten, naar hun getelden, waren vierenzestigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","De zonen van Aser, naar hun geslachten, waren: van Jimna het geslacht Jimna; van Jiswi het geslacht der Jiswieten en van Beria het geslacht der Beriïeten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Aangaande de zonen van Beria: van Cheber het geslacht der Cheberieten en van Malkiël het geslacht der Malkiëlieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","En de naam der dochter van Aser was Serach. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Dit waren de geslachten der zonen van Aser, naar hun getelden, drieënvijftigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","De zonen van Naftali, naar hun geslachten, waren: van Jachseël het geslacht der Jachseëlieten; van Guni het geslacht der Gunieten; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","van Jeser het geslacht der Jisrieten en van Sillem het geslacht der Sillemieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Dit waren de geslachten van Naftali, naar hun geslachten, en hun getelden waren vijfenveertigduizend vierhonderd. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Dit waren de getelden der Israëlieten: zeshonderdéénduizend zevenhonderd dertig. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","En de Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Onder dezen zal het land ten erfdeel worden verdeeld naar het aantal namen; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","is dit groot, dan zult gij het erfdeel groot maken, en is dit klein, dan zult gij het erfdeel klein maken; overeenkomstig de getelden zal aan ieder zijn erfdeel gegeven worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Evenwel zal het land door het lot verdeeld worden; naar de namen van de stammen hunner vaderen zullen zij het erven; ");
INSERT INTO nldnbg_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","naar het lot zal ieders erfdeel toegewezen worden, naar gelang van groter of kleiner aantal. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","En dit waren de getelden der Levieten, naar hun geslachten: van Gerson het geslacht der Gersonieten; van Kehat het geslacht der Kehatieten en van Merari het geslacht der Merarieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dit waren de geslachten van Levi: het geslacht der Libnieten, het geslacht der Chebronieten, het geslacht der Machlieten, het geslacht der Musieten en het geslacht der Korachieten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","En Kehat verwekte Amram. En de naam van de vrouw van Amram was Jokebed, de dochter van Levi, die (haar moeder) aan Levi in Egypte baarde; en zij baarde aan Amram Aäron en Mozes en Mirjam, hun zuster. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","En aan Aäron werden Nadab en Abihu, Eleazar en Itamar geboren. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","En Nadab en Abihu stierven, toen zij vreemd vuur voor het aangezicht des Heren brachten. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","En hun getelden waren drieëntwintigduizend, allen van het mannelijk geslacht, van één maand oud en daarboven; want zij werden niet samen met de Israëlieten geteld, omdat hun onder de Israëlieten geen erfdeel werd gegeven. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Dit waren degenen, die geteld waren door Mozes en de priester Eleazar, die de Israëlieten telden in de velden van Moab aan de Jordaan bij Jericho. ");
INSERT INTO nldnbg_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Onder hen bevond zich niemand van hen, die door Mozes en de priester Aäron geteld waren, toen dezen de Israëlieten in de woestijn Sinai telden, ");
INSERT INTO nldnbg_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","want de Here had van hen gezegd: Zij zullen voorzeker in de woestijn sterven. En van hen was niemand overgebleven dan Kaleb, de zoon van Jefunne, en Jozua, de zoon van Nun. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","En de dochters van Selofchad, de zoon van Chefer, de zoon van Gilead, de zoon van Makir, de zoon van Manasse, van de geslachten van Manasse, de zoon van Jozef – en dit zijn de namen van zijn dochters: Machla, Noa, Chogla, Milka en Tirsa – naderden ");
INSERT INTO nldnbg_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","en stelden zich vóór Mozes en de priester Eleazar en de vorsten en de gehele vergadering aan de ingang van de tent der samenkomst en zeiden: ");
INSERT INTO nldnbg_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Onze vader is in de woestijn gestorven, hoewel hij niet behoorde tot de bende, die tegen de Here samenspande, tot de bende van Korach, maar om zijn eigen zonde is hij gestorven, en hij had geen zonen. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Waarom zal de naam van onze vader uit het midden der geslachten verdwijnen, daar hij geen zoon heeft? Geef ons bezit onder de broeders van onze vader. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Toen bracht Mozes haar rechtsvraag voor het aangezicht des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","En de Here zeide tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","De dochters van Selofchad hebben gelijk; gij zult haar voorzeker erfelijk bezit onder de broeders van haar vader geven, en gij zult het erfdeel van haar vader op haar doen overgaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","En tot de Israëlieten zult gij aldus spreken: Wanneer iemand sterft zonder een zoon te hebben, dan zult gij zijn erfdeel op zijn dochter doen overgaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Heeft hij geen dochter, dan zult gij zijn erfdeel aan zijn broeders geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Heeft hij geen broeders, dan zult gij zijn erfdeel aan de broeders van zijn vader geven. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","En heeft zijn vader geen broeders, dan zult gij zijn erfdeel geven aan de naaste bloedverwant uit zijn geslacht, opdat die het bezitte. En dit zal voor de Israëlieten tot een rechtsinzetting zijn, zoals de Here aan Mozes geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","En de Here zeide tot Mozes: Beklim dit gebergte Abarim, en aanschouw het land, dat Ik de Israëlieten gegeven heb. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Als gij het aanschouwd hebt, dan zult ook gij tot uw voorgeslacht vergaderd worden, zoals uw broeder Aäron; ");
INSERT INTO nldnbg_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","omdat gij in de woestijn Sin, toen de vergadering opstandig was, mijn bevel om Mij voor hun ogen bij het water te heiligen, weerstreefd hebt. Dat is het water van Meribat-Kades in de woestijn Sin. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Toen sprak Mozes tot de Here: ");
INSERT INTO nldnbg_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","De Here, de God der geesten van alle levende schepselen, stelle over de vergadering een man, ");
INSERT INTO nldnbg_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","die voor hun aangezicht uitgaat en die voor hun aangezicht ingaat, en die hen doet uittrekken en hen weer terugbrengt, opdat de vergadering des Heren niet zij als schapen die geen herder hebben. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Toen zeide de Here tot Mozes: Neem u Jozua, de zoon van Nun, een man, van geest vervuld, en leg hem uw hand op, ");
INSERT INTO nldnbg_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","en stel hem voor de priester Eleazar en voor de gehele vergadering, en geef hem in hun tegenwoordigheid uw bevelen ");
INSERT INTO nldnbg_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","en leg op hem van uw heerlijkheid, opdat de gehele vergadering der Israëlieten het hore. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Hij zal voor de priester Eleazar staan, opdat deze voor het aangezicht des Heren de beslissing van de Urim voor hem vrage; op zijn bevel zullen zij uitrukken en op zijn bevel zullen zij inrukken, hij en alle Israëlieten met hem, en de gehele vergadering. ");
INSERT INTO nldnbg_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","En Mozes deed, zoals de Here hem geboden had, en hij nam Jozua en stelde hem voor de priester Eleazar en voor de gehele vergadering; ");
INSERT INTO nldnbg_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","hij legde hem zijn handen op en gaf hem zijn bevelen, zoals de Here door de dienst van Mozes gesproken had. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Gebied de Israëlieten en zeg tot hen: Gij zult zorg dragen mijn offergave, mijn spijze, als mijn vuuroffers, een liefelijke reuk voor Mij, op de bepaalde tijd aan Mij te brengen. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Zeg dan tot hen: Dit is het vuuroffer, dat gij de Here brengen zult: twee gave, éénjarige schapen per dag als dagelijks brandoffer; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","het ene schaap zult gij des morgens bereiden, het andere schaap zult gij in de avondschemering bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Daarbij een tiende efa fijn meel tot een spijsoffer, aangemaakt met een vierde hin gestoten olie. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Het is het dagelijks brandoffer, dat op de berg Sinai ingesteld is tot een liefelijke reuk, een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","En het bijbehorend plengoffer zal zijn een vierde hin voor elk schaap; pleng een plengoffer van bedwelmende drank in het heiligdom voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","En het andere schaap zult gij in de avondschemering bereiden; gelijk het spijsoffer des morgens en gelijk het bijbehorend plengoffer zult gij het bereiden, een vuuroffer van liefelijke reuk voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","En op de sabbatdag twee gave, éénjarige schapen en twee tienden fijn meel als spijsoffer, aangemaakt met olie, en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Het is het brandoffer van de sabbat op elke sabbat boven het dagelijks brandoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","En bij het begin uwer maanden zult gij de Here een brandoffer brengen: twee jonge stieren, één ram, zeven gave, éénjarige schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","en drie tienden fijn meel als spijsoffer, aangemaakt met olie, bij elke stier; en twee tienden fijn meel als spijsoffer, aangemaakt met olie, bij de éne ram; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","en telkens een tiende fijn meel als spijsoffer, aangemaakt met olie, bij elk schaap; een brandoffer, een liefelijke reuk, een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","En de bijbehorende plengoffers zullen bestaan uit een halve hin wijn bij een stier, en een derde hin bij een ram, en een vierde hin bij een schaap. Dit is het maandelijks brandoffer in elke maand van de maanden des jaars. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","En één geitebok zal tot een zondoffer voor de Here bereid worden met het bijbehorend plengoffer boven het dagelijks brandoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","En in de eerste maand, op de veertiende dag der maand, zal het Pascha voor de Here zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Op de vijftiende dag dier maand zal er een feest zijn; zeven dagen lang zullen ongezuurde broden worden gegeten. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Op de eerste dag zal er een heilige samenkomst zijn, gij zult generlei slaafse arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","En gij zult de Here een vuuroffer, een brandoffer brengen; twee jonge stieren, één ram en zeven éénjarige schapen; gaaf zullen zij zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Het bijbehorend spijsoffer, fijn meel aangemaakt met olie, drie tienden bij een stier en twee tienden bij de ram, zult gij bereiden; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","telkens een tiende zult gij bereiden bij elk van de zeven schapen. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Voorts één bok als zondoffer om over u verzoening te doen; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ongeacht het morgenbrandoffer, dat tot het dagelijks brandoffer behoort, zult gij deze bereiden. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Dienovereenkomstig zult gij dagelijks gedurende zeven dagen de spijze van het vuuroffer, een liefelijke reuk voor de Here, bereiden; boven het dagelijks brandoffer zal het bereid worden met het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","En op de zevende dag zult gij een heilige samenkomst hebben, gij zult generlei slaafse arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","En op de dag der eerstelingen, wanneer gij een nieuw spijsoffer de Here brengen zult, op uw feest der weken, zult gij een heilige samenkomst hebben, gij zult generlei slaafse arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Dan zult gij een brandoffer brengen tot een liefelijke reuk voor de Here: twee jonge stieren, één ram, zeven éénjarige schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","en het bijbehorend spijsoffer: fijn meel aangemaakt met olie, drie tienden bij elke stier, twee tienden bij de éne ram, ");
INSERT INTO nldnbg_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","telkens een tiende bij elk van de zeven schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","één geitebok om over u verzoening te doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Gij zult het ongeacht het dagelijks brandoffer en het bijbehorend spijsoffer bereiden, zij zullen gaaf zijn met de bijbehorende plengoffers. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","En in de zevende maand, op de eerste dag der maand, zult gij een heilige samenkomst hebben, gij zult generlei slaafse arbeid verrichten, het zal een jubeldag voor u zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dan zult gij tot een brandoffer bereiden tot een liefelijke reuk voor de Here; één jonge stier, één ram, zeven gave, éénjarige schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","en het bijbehorend spijsoffer: fijn meel, aangemaakt met olie, drie tienden bij de stier, twee tienden bij de ram ");
INSERT INTO nldnbg_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","en één tiende bij elk van de zeven schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","en een geitebok als zondoffer om over u verzoening te doen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","behalve het maandelijks brandoffer en het bijbehorend spijsoffer, en het dagelijks brandoffer en het bijbehorend spijsoffer en de bijbehorende plengoffers naar het desbetreffend voorschrift, tot een liefelijke reuk, een vuuroffer voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Op de tiende dag dezer zevende maand zult gij een heilige samenkomst hebben en u verootmoedigen, gij zult generlei arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dan zult gij de Here een brandoffer, een liefelijke reuk, brengen: één jonge stier, één ram, zeven éénjarige schapen; gaaf zullen zij zijn; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","en het bijbehorend spijsoffer: fijn meel aangemaakt met olie, drie tienden bij de stier, twee tienden bij de éne ram, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","telkens een tiende bij elk van de zeven schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","één geitebok als zondoffer, ongeacht het zondoffer der verzoening en het dagelijks brandoffer en het bijbehorend spijsoffer en de bijbehorende plengoffers. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","En op de vijftiende dag der zevende maand zult gij een heilige samenkomst hebben, gij zult generlei slaafse arbeid verrichten; dan zult gij zeven dagen feest vieren voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Gij zult een brandoffer brengen, een vuuroffer, een liefelijke reuk voor de Here: dertien jonge stieren, twee rammen, veertien éénjarige schapen, gaaf zullen zij zijn; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","en het bijbehorend spijsoffer: fijn meel aangemaakt met olie, drie tienden bij elk van de dertien stieren, twee tienden bij elk van de twee rammen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","en telkens een tiende bij elk van de veertien schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","en één geitebok als zondoffer, ongeacht het dagelijks brandoffer, het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Op de tweede dag twaalf jonge stieren, twee rammen, veertien gave, éénjarige schapen, en het bijbehorend spijsoffer ");
INSERT INTO nldnbg_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen, naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","en één geitebok als zondoffer, ongeacht het dagelijks brandoffer en het bijbehorend spijsoffer en de bijbehorende plengoffers. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Op de derde dag elf stieren, twee rammen, veertien gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","en het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","en één bok als zondoffer, ongeacht het dagelijks brandoffer en het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Op de vierde dag tien stieren, twee rammen, veertien gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","en het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","en één geitebok als zondoffer, ongeacht het dagelijks brandoffer, het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Op de vijfde dag negen stieren, twee rammen, veertien gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","en het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","en één bok als zondoffer, ongeacht het dagelijks brandoffer en het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Op de zesde dag acht stieren, twee rammen, veertien gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","en het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","en één bok als zondoffer, ongeacht het dagelijks brandoffer, het bijbehorend spijsoffer en de bijbehorende plengoffers. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Op de zevende dag zeven stieren, twee rammen, veertien gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","en het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stieren, bij de rammen en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","en één bok als zondoffer, ongeacht het dagelijks brandoffer, het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Op de achtste dag zult gij een feestelijke vergadering hebben, gij zult generlei slaafse arbeid verrichten. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Dan zult gij een brandoffer brengen, een vuuroffer, een liefelijke reuk voor de Here: één stier, één ram, zeven gave, éénjarige schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","het bijbehorend spijsoffer en de bijbehorende plengoffers bij de stier, bij de ram en bij de schapen naar hun aantal, volgens het voorschrift; ");
INSERT INTO nldnbg_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","en één bok als zondoffer, ongeacht het dagelijks brandoffer en het bijbehorend spijsoffer en het bijbehorend plengoffer. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Dit zult gij voor de Here op uw feesten bereiden als uw brandoffers, uw spijsoffers, uw plengoffers en uw vredeoffers, behalve uw gelofteoffers en uw vrijwillige offers. ");
INSERT INTO nldnbg_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","En Mozes sprak tot de Israëlieten naar alles wat de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","En Mozes sprak tot de stamhoofden der Israëlieten: Dit is het woord, dat de Here geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Wanneer een man de Here een gelofte doet of een eed zweert, waardoor hij een verplichting op zich neemt, dan zal hij zijn woord niet schenden; geheel zoals hij het uitgesproken heeft, zal hij doen. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Maar wanneer een vrouw de Here een gelofte gedaan en een verplichting op zich genomen heeft in haars vaders huis in haar jeugd, ");
INSERT INTO nldnbg_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","en haar vader de gelofte en de verplichting die zij op zich heeft genomen, gehoord heeft, maar haar vader tegen haar gezwegen heeft, dan zullen al haar geloften van kracht zijn en elke verplichting die zij op zich genomen heeft, zal van kracht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Indien echter haar vader haar weerstaan heeft, toen hij het hoorde, dan zal geen van de geloften en van de verplichtingen die zij op zich genomen heeft, van kracht zijn; en de Here zal het haar vergeven, want haar vader heeft haar weerstaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Indien zij echter een man toebehoort, terwijl haar geloften of de verplichting die zij door een onbezonnen uitspraak op zich genomen heeft, op haar rusten, ");
INSERT INTO nldnbg_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","en haar man het hoort en tegen haar zwijgt, wanneer hij het hoort, dan zullen haar geloften van kracht zijn en de verplichtingen die zij op zich genomen heeft, zullen ook van kracht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Maar als haar man, toen hij het hoorde, haar weerstaan heeft, dan heeft hij de gelofte die op haar is, en de verplichting die zij door een onbezonnen uitspraak op zich genomen heeft, ongeldig gemaakt; en de Here zal het haar vergeven. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Wat de geloften van een weduwe of van een verstoten vrouw betreft, elke verplichting die zij op zich genomen heeft, zal voor haar van kracht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","En indien zij een gelofte gedaan heeft in het huis van haar man of onder ede een verplichting op zich genomen heeft, ");
INSERT INTO nldnbg_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","en haar man het gehoord, maar tegen haar gezwegen en haar niet weerstaan heeft, dan zullen al haar geloften van kracht zijn, en elke verplichting die zij op zich genomen heeft, zal van kracht zijn. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Indien echter haar man deze nadrukkelijk ongeldig maakt, wanneer hij het hoort, zal niets, wat over haar lippen gekomen is, zowel van haar gelofte als van haar verplichting, van kracht zijn; haar man heeft ze ongeldig gemaakt en de Here zal het haar vergeven. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Elke gelofte en elke verplichting onder ede om zichzelf te verootmoedigen, zal haar man kunnen bekrachtigen en haar man zal ze ongeldig kunnen maken. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Zwijgt echter haar man van dag tot dag geheel tegen haar, dan bekrachtigt hij al haar geloften of al de verplichtingen die op haar rusten; hij bekrachtigt ze, omdat hij tegen haar zwijgt, wanneer hij het hoort. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Maar maakt hij ze nadrukkelijk ongeldig, nadat hij ze gehoord heeft, dan zal hij haar ongerechtigheid dragen. ");
INSERT INTO nldnbg_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Dit zijn de inzettingen, die de Here Mozes geboden heeft over de verhouding van een man tot zijn vrouw, en van een vader tot zijn dochter in haar jeugd, in het huis van haar vader. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","De Here sprak tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Neem voor de Israëlieten wraak op de Midjanieten; daarna zult gij tot uw voorgeslacht vergaderd worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Toen sprak Mozes tot het volk: Laat een aantal mannen van u zich ten strijde toerusten, dat zij zich tegen Midjan keren om de wraak des Heren aan Midjan te voltrekken. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Uit elke stam van alle stammen Israëls zult gij er duizend ten strijde zenden. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Zo werden van de geslachten Israëls duizend voor elke stam geleverd, twaalfduizend ten strijde toegerusten. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Toen zond Mozes hen ten strijde, duizend voor elke stam; hen en Pinechas, de zoon van de priester Eleazar, ten strijde, en het heilige gerei en de signaaltrompetten had hij bij zich. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","En zij trokken ten strijde tegen Midjan, zoals de Here Mozes geboden had, en doodden allen die van het mannelijk geslacht waren. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Behalve degenen, die onder hen verslagen werden, doodden zij ook de koningen van Midjan, Ewi, Rekem, Sur, Chur en Reba, de vijf koningen van Midjan; ook Bileam, de zoon van Beor, doodden zij met het zwaard. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","En de Israëlieten namen de vrouwen van Midjan gevangen en hun kinderen; en al hun vee, al hun have en hun gehele vermogen maakten zij buit; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","al hun steden, waar zij woonden, en al hun tentenkampen verbrandden zij met vuur. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Daarna namen zij de gehele buit en de gehele roof aan mensen en dieren ");
INSERT INTO nldnbg_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","en brachten de gevangenen, de roof en de buit tot Mozes en de priester Eleazar en de vergadering der Israëlieten in de legerplaats, naar de velden van Moab aan de Jordaan bij Jericho. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Toen gingen Mozes en de priester Eleazar en al de hoofden der vergadering hun tegemoet tot buiten de legerplaats; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","en Mozes werd toornig op de aanvoerders van het leger, op de oversten over duizend en de oversten over honderd, die van de krijgstocht kwamen, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","en Mozes zeide tot hen: Hebt gij allen die van het vrouwelijk geslacht zijn, laten leven? ");
INSERT INTO nldnbg_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Zie, dezen waren op raad van Bileam voor de Israëlieten aanleiding om trouwbreuk te plegen tegen de Here ter oorzake van Peor, zodat de plaag kwam onder de vergadering des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Nu dan, doodt al wat onder de jeugdigen van het mannelijk geslacht is; en ook alle vrouwen die gemeenschap met een man hebben gehad, zult gij doden. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Maar alle jeugdigen onder de vrouwen, die geen gemeenschap met een man hebben gehad, zult gij voor u laten leven. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","En gij, legert u zeven dagen buiten de legerplaats; ieder van u, die iemand gedood heeft, en ieder van u, die een verslagene aangeraakt heeft, moet zich op de derde en op de zevende dag laten ontzondigen, gij zelf en uw gevangenen; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ook zal elk kleed en elk voorwerp van leer en al wat van geitehaar gemaakt is en elk houten voorwerp ontzondigd worden. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Toen zeide de priester Eleazar tot de krijgslieden, die ten strijde getrokken waren: Dit is het wetsvoorschrift, dat de Here Mozes geboden heeft. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Alleen het goud en het zilver, het koper, het ijzer, het tin en het lood, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","alles wat door het vuur kan gaan, zult gij door het vuur doen gaan, opdat het rein worde; evenwel zal het met het water der reiniging ontzondigd worden; en alles wat niet door het vuur kan gaan, zult gij door het water doen gaan. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","En gij zult op de zevende dag uw klederen wassen, opdat gij rein wordt, en daarna zult gij in de legerplaats komen. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","En de Here zeide tot Mozes: ");
INSERT INTO nldnbg_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Stel het totaal vast van de buit, die meegevoerd is aan mensen en dieren, gij en de priester Eleazar en de familiehoofden der vergadering, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","en verdeel de buit in twee helften tussen hen, die de krijgswapenen gehanteerd hebben, die ten strijde uitgetrokken zijn, en de gehele vergadering. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","En gij zult voor de Here een schatting heffen van de krijgslieden, die ten strijde uitgetrokken zijn, één op de vijfhonderd van de mensen, de runderen, de ezels en de schapen; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","van de voor hen bestemde helft zult gij deze nemen en aan de priester Eleazar geven als een heffing voor de Here. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Maar van de helft die voor de Israëlieten bestemd is, zult gij één gevangene op de vijftig nemen van de mensen, de runderen, de ezels en de schapen, van al het vee, en ze aan de Levieten geven, die zorg dragen voor de tabernakel des Heren. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","En Mozes en de priester Eleazar deden, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","De buit nu, het overige van de roof, die het krijgsvolk geroofd had, was zeshonderdvijfenzeventigduizend schapen ");
INSERT INTO nldnbg_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","en tweeënzeventigduizend runderen, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","en eenenzestigduizend ezels, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","voorts mensen, namelijk vrouwen, die geen gemeenschap met een man hadden gehad, in het geheel tweeëndertigduizend. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","En de helft, het aandeel van degenen die in de strijd uitgetrokken waren, was tezamen driehonderdzevenendertigduizend vijfhonderd schapen, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","en de schatting voor de Here van de schapen bedroeg zeshonderd vijfenzeventig; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","en de runderen zesendertigduizend en hun schatting voor de Here tweeënzeventig; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","en de ezels dertigduizend vijfhonderd en hun schatting voor de Here eenenzestig; ");
INSERT INTO nldnbg_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","en de mensen zestienduizend en hun schatting voor de Here tweeëndertig. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","En Mozes gaf de schatting, de heffing voor de Here, aan de priester Eleazar, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","En de helft, bestemd voor de Israëlieten, die Mozes van de mannen welke uitgetrokken waren, afgescheiden had, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","de helft voor de vergadering bestemd, bedroeg van de schapen driehonderdzevenendertigduizend vijfhonderd, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","en de runderen zesendertigduizend, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","en de ezels dertigduizend vijfhonderd, ");
INSERT INTO nldnbg_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","en de mensen zestienduizend. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","En Mozes nam van de helft, voor de Israëlieten bestemd, één gevangene op de vijftig, van mensen en van vee, en gaf die aan de Levieten, die zorg droegen voor de tabernakel des Heren, zoals de Here Mozes geboden had. ");
INSERT INTO nldnbg_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Toen naderden de aanvoerders der legerafdelingen, de oversten over duizend en de oversten over honderd, tot Mozes en zeiden tot hem: ");
INSERT INTO nldnbg_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Uw knechten hebben het getal van de krijgslieden opgenomen, die onder 