﻿USE sofia;
DROP TABLE IF EXISTS sofia.nldgbv_vpl;
CREATE TABLE nldgbv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nldgbv_vpl WRITE;
INSERT INTO nldgbv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Overzicht van de afstamming van Jezus Christus, de Zoon van David, de Zoon van Abraham. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham was de vader van Isaak, Isaak van Jakob, en Jakob van Juda en zijn broers. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda was de vader van Peres en Zerach; hun moeder was Tamar. Peres was de vader van Chesron, en Chesron van Aram. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram was de vader van Amminadab, Amminadab van Nachson, en Nachson van Salmon. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon was de vader van Boaz; diens moeder was Rachab. Boaz was de vader van Obed; diens moeder was Ruth. Obed was de vader van Isaï. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaï was de vader van koning David. David was de vader van Salomo; diens moeder was de weduwe van Uria. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo was de vader van Rechabeam, Rechabeam van Abia, Abia van Asaf. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf was de vader van Josafat, Josafat van Joram, Joram van Uzzia, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzzia van Jotam, Jotam van Achaz, Achaz van Hizkia, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia van Manasse, Manasse van Amos, Amos van Josia, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","en Josia was de vader van Jechonja en zijn broers, in de tijd van de ballingschap in Babylon. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na de ballingschap in Babylon werd Jechonja vader van Sealtiël, Sealtiël van Zerubbabel, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel van Abiud, Abiud van Eljakim, Eljakim van Azor, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor van Sadok, Sadok van Achim, Achim van Eliud, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud van Eleazar, Eleazar van Mattan, Mattan van Jakob, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","en Jakob was de vader van Jozef, de man van Maria. Zij was de moeder van Jezus, die ook Christus wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Er zijn dus veertien generaties van Abraham tot David, veertien generaties van David tot de ballingschap in Babylon, en ook veertien generaties van de ballingschap in Babylon tot de Messias. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","De geboorte van Jezus Christus verliep als volgt: Toen zijn moeder Maria verloofd was met Jozef, nog voordat ze bij elkaar woonden, bleek dat ze zwanger was door toedoen van de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Omdat Jozef, haar man, integer was en haar niet te schande wilde maken, wilde hij in stilte van haar scheiden. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Terwijl hij dit overwoog, verscheen een engel van de Heer aan hem in een droom. De engel zei: “Jozef, zoon van David, wees niet bang om met Maria te trouwen, want het kind dat zij verwacht komt van de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ze zal een zoon krijgen en je moet Hem de naam Jezus geven, want Hij zal zijn volk redden van hun zonden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dit hele gebeuren vormde de vervulling van de belofte die de Heer bij monde van de profeet had gegeven: ");
INSERT INTO nldgbv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“De maagd zal zwanger worden en een zoon baren, en men zal hem de naam Immanuël geven.” Die naam betekent “God is bij ons”. ");
INSERT INTO nldgbv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Toen Jozef wakker werd, deed hij wat de engel van de Heer hem had opgedragen: hij trouwde met Maria, ");
INSERT INTO nldgbv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","maar hij sliep niet met haar totdat ze haar zoon had gebaard, en hij gaf Hem de naam Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nadat Jezus in Betlehem in Judea was geboren, in de tijd van koning Herodes, kwamen er sterrenkundigen uit het oosten naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ze vroegen: “Waar is de koning van de Joden die onlangs is geboren? Wij hebben zijn ster zien opkomen en zijn gekomen om Hem te vereren.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Toen koning Herodes dat hoorde, schrok hij hevig, en heel Jeruzalem met hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes riep alle hoofdpriesters en Schriftgeleerden van het Joodse volk bijeen en vroeg hun waar de Messias zou worden geboren. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Zij zeiden tegen hem: “In Betlehem in Judea, want in de profetische geschriften staat: ");
INSERT INTO nldgbv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘En jij, Betlehem in het land van Juda, jij bent zeker niet de geringste van de heersers van Juda, want uit jou zal een heerser voortkomen die mijn volk, Israël, zal leiden.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Toen ontbood Herodes de sterrenkundigen in het geheim en hij kwam van hen te weten op welk tijdstip de ster was verschenen. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hij stuurde hen naar Betlehem en zei: “Ga nauwkeurig navraag doen naar het Kind en kom mij verslag uitbrengen wanneer jullie Hem hebben gevonden, opdat ook ik Hem kan gaan vereren.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nadat ze de koning hadden aangehoord, vertrokken de sterrenkundigen. Opeens ging de ster die ze eerder hadden zien opkomen voor hen uit, totdat ze boven de plaats was gekomen waar het Kind was; daar hield ze stil. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ze waren onbeschrijflijk blij om de ster te zien. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Toen ze het huis binnengingen en het Kind met zijn moeder Maria zagen, vielen ze op hun knieën om Hem te vereren. Ze openden hun schatkisten en gaven Hem hun geschenken: goud, wierook en mirre. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","En nadat ze in een droom waren gewaarschuwd om niet opnieuw naar Herodes te gaan, keerden ze naar hun land terug via een andere route. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na hun vertrek verscheen een engel van de Heer in een droom aan Jozef. Hij zei: “Sta op en vlucht met het Kind en zijn moeder naar Egypte. Blijf daar totdat ik zeg dat je mag terugkomen, want Herodes zal binnenkort naar het Kind zoeken met de bedoeling het Kind om te brengen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jozef stond op en week diezelfde nacht met het Kind en zijn moeder uit naar Egypte. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Daar bleven ze totdat Herodes stierf en zo ging de volgende profetie van de Heer in vervulling: “Uit Egypte heb Ik mijn Zoon geroepen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Toen Herodes merkte dat hij door de sterrenkundigen was misleid, werd hij ziedend van woede. Op basis van het tijdstip dat hij van de sterrenkundigen te weten was gekomen, liet hij alle kinderen van twee jaar en jonger in Betlehem en in de hele omgeving ervan ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","En zo ging de volgende profetie van Jeremia in vervulling: ");
INSERT INTO nldgbv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“In Rama wordt een stem gehoord: geween en luid gekerm. Rachel weent om haar kinderen; ze wil niet worden getroost, want zij zijn er niet meer.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nadat Herodes was gestorven, verscheen in Egypte een engel van de Heer in een droom aan Jozef. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hij zei: “Sta op en neem het Kind en zijn moeder mee terug naar het land Israël, want zij die het Kind wilden ombrengen zijn gestorven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dus stond Jozef op en hij nam het Kind en zijn moeder mee terug naar het land Israël. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maar toen hij hoorde dat Archelaüs als opvolger van zijn vader Herodes over Judea regeerde, was Jozef bang om daarheen te gaan. Hij werd in een droom gewaarschuwd en week uit naar het gebied Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Daar aangekomen ging hij in een stad wonen die Nazaret heet. En zo gingen de volgende woorden van de profeten in vervulling: “Hij zal een Man van Nazaret worden genoemd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","In die periode verscheen Johannes de Doper in de wildernis van Judea. Hij verkondigde: ");
INSERT INTO nldgbv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kom tot inkeer, want Gods rijk is in aantocht.” ");
INSERT INTO nldgbv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Johannes was degene over wie de profeet Jesaja had voorspeld: “Er roept een stem in de wildernis: Maak de weg van de Heer gereed, maak paden voor Hem vrij!” ");
INSERT INTO nldgbv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johannes droeg kledij van kameelhaar en hij had een leren riem om zijn middel. Zijn eten bestond uit sprinkhanen en wilde honing. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","De mensen kwamen uit Jeruzalem en heel Judea en het hele gebied rond de Jordaan naar hem toe ");
INSERT INTO nldgbv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","en werden door hem in de rivier de Jordaan gedoopt, waarbij ze hun zonden bekenden. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Toen hij zag dat veel van de farizeeën en de sadduceeën naar hem toe kwamen om zich te laten dopen, zei hij tegen hen: “Addergebroed, wie heeft jullie gewaarschuwd om te vluchten voor de naderende straf? ");
INSERT INTO nldgbv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Zorg dat de gevolgen van jullie inkeer zichtbaar zijn ");
INSERT INTO nldgbv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","en denk niet dat jullie tegen jezelf kunnen zeggen: wij hebben Abraham als voorvader. Want ik zeg jullie: God is in staat om uit deze stenen nakomelingen voor Abraham voort te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","De bijl ligt reeds klaar onderaan de bomen en elke boom die geen goede vruchten voortbrengt, wordt omgehakt en in het vuur gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Want ik doop jullie met water als teken van inkeer, maar na mij komt Iemand die machtiger is dan ik, en ik ben het niet waard om Hem zijn schoenen uit te trekken. Hij zal jullie dopen met de Heilige Geest en vuur. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hij heeft de vork om het kaf van het koren te scheiden al in zijn hand. Daarmee zal Hij zijn dorsvloer leegmaken; zijn graan zal Hij in de schuur onderbrengen en het kaf zal Hij verbranden in onblusbaar vuur.” ");
INSERT INTO nldgbv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Toen kwam Jezus vanuit Galilea naar de Jordaan om door Johannes te worden gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Johannes probeerde Hem tegen te houden door te zeggen: “Ik zou door U moeten worden gedoopt en toch komt U bij mij?” ");
INSERT INTO nldgbv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Maar Jezus antwoordde: “Laten we het nu maar doen, want alleen zo kunnen we alles doen wat God van ons verlangt.” Toen gaf Johannes toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zodra Jezus was gedoopt en uit het water omhoogkwam, ging de hemel open en zag Hij Gods Geest neerdalen en op Hem plaatsnemen zoals een duif. ");
INSERT INTO nldgbv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Toen klonk er een stem uit de hemel: “Dit is mijn dierbare Zoon, Ik verheug Mij over Hem.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jezus werd door de Geest naar de wildernis geleid om door de duivel op de proef te worden gesteld. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jezus vastte veertig dagen en veertig nachten en kreeg uiteindelijk grote honger. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Toen kwam de duivel Hem op de proef stellen. Hij zei: “Als U de Zoon van God bent, zeg dan tegen deze stenen dat ze broden moeten worden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Maar Jezus antwoordde: “In de Schriften staat: ‘De mens leeft niet alleen van brood, maar van ieder woord dat uit Gods mond komt.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Vervolgens leidde de duivel Hem naar de heilige stad, naar de hoogste plaats op het tempelterrein. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hij zei tegen Hem: “Als U de Zoon van God bent, spring dan naar beneden, want in de Schriften staat: ‘Hij zal zijn engelen bevelen jou te beschermen; dan zullen zij je op hun handen dragen, zodat je je voet niet aan een steen stoot.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jezus antwoordde: “Er staat ook: ‘Stel de Heer, je God, niet op de proef.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Vervolgens leidde de duivel Hem naar een zeer hoge berg en toonde hij Hem alle koninkrijken van de wereld en hun pracht. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hij zei tegen Hem: “Ik zal U dit alles geven als U voor mij neerknielt en mij aanbidt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Maar Jezus zei tegen hem: “Ga weg, Satan, want in de Schriften staat: ‘Aanbid de Heer, je God, en dien alleen Hem.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Toen liet de duivel Hem met rust en kwamen engelen Hem dienen. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zodra Jezus hoorde dat Johannes was gevangengenomen, trok Hij zich terug naar Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Daar verhuisde Hij van Nazaret naar Kafarnaüm; dat ligt aan het meer in het gebied van Zebulon en Naftali. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Zo gingen de volgende woorden van de profeet Jesaja in vervulling: ");
INSERT INTO nldgbv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Land van Zebulon en land van Naftali, aan de weg naar zee voorbij de Jordaan, Galilea van de andere volken: ");
INSERT INTO nldgbv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Het volk dat in het duister woonde, heeft een groot licht gezien, en voor hen die woonden waar de schaduw van de dood heerste, is een licht gaan schijnen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vanaf toen begon Jezus te verkondigen: “Kom tot inkeer, want Gods rijk is in aantocht.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Toen Jezus langs het Meer van Galilea wandelde, zag Hij twee broers: Simon, die Petrus wordt genoemd, en zijn broer Andreas. Ze waren bezig een net in het meer uit te werpen, want ze waren vissers. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hij zei tegen hen: “Kom, volg Mij en Ik zal mensenvissers van jullie maken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Meteen lieten ze de netten achter en volgden ze Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iets verderop zag Hij nog twee broers: Jakobus, de zoon van Zebedeüs, en zijn broer Johannes. Ze waren met hun vader Zebedeüs in de boot de netten aan het klaarmaken. Toen Jezus hen riep, ");
INSERT INTO nldgbv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","lieten ze meteen de boot en hun vader achter en volgden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jezus trok door heel Galilea, waar Hij in de synagogen onderwees, het evangelie van Gods koninkrijk verkondigde en iedere ziekte en aandoening van de mensen genas. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Het nieuws over Hem verspreidde zich door heel Syrië en men bracht alle mensen bij Hem die aan allerlei aandoeningen, ziekten en pijnlijke kwalen leden, die bezeten waren, epilepsie hadden of verlamd waren, en Hij genas hen. ");
INSERT INTO nldgbv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Een grote mensenmassa volgde Hem uit Galilea, Dekapolis, Jeruzalem, Judea en het gebied aan de overkant van de Jordaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Toen Jezus de mensenmassa zag, ging Hij de berg op. Hij ging zitten, zijn leerlingen kwamen bij Hem, ");
INSERT INTO nldgbv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","en Hij begon hun te onderwijzen. Hij zei: ");
INSERT INTO nldgbv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Zij die geestelijk arm zijn, zijn gezegend, want Gods rijk behoort hen toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Zij die rouwen, zijn gezegend, want ze zullen worden getroost. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Zij die zachtmoedig zijn, zijn gezegend, want de aarde zal van hen zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Zij die honger en dorst hebben naar gerechtigheid, zijn gezegend, want ze zullen verzadigd worden. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Zij die mededogen betonen, zijn gezegend, want ze zullen mededogen ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Zij die een zuiver hart hebben, zijn gezegend, want ze zullen God zien. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Zij die zich voor de vrede inzetten, zijn gezegend, want ze zullen kinderen van God worden genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Zij die worden vervolgd omdat ze doen wat God van hen verlangt, zijn gezegend, want Gods rijk behoort hen toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Je bent gezegend als de mensen je bespotten en vervolgen en valselijk van allerlei kwaad beschuldigen omwille van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wees blij en verheugd, want jullie beloning in de hemel zal groot zijn. Voorheen werden de profeten namelijk op dezelfde wijze vervolgd. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jullie zijn het zout van de aarde, maar als het zout zijn smaak verliest, hoe kan het dan worden gezouten? Het deugt nergens meer voor, behalve om te worden weggegooid en door de mensen te worden vertrappeld. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jullie zijn het licht van de wereld. Een stad die boven op een berg ligt, kan niet verborgen blijven. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","En wanneer een olielamp wordt aangestoken, wordt ze niet onder een bak gezet maar op een standaard, waar ze schijnt voor iedereen in huis. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Laat op dezelfde manier jullie licht schijnen voor de mensen, opdat ze je goede daden zien en er je hemelse Vader voor verheerlijken. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Denk niet dat Ik ben gekomen om de Wet of de Profeten af te schaffen. Ik ben niet gekomen om af te schaffen, maar om te vervullen. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Want Ik verzeker jullie, zolang de hemel en de aarde bestaan, zal geen letter of streepje in de Wet vervallen voordat alles wat erin staat is gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dus wie een van de geringste geboden naast zich neerlegt en anderen leert dat ook te doen, zal in Gods rijk de geringste zijn. Maar wie ze naleeft en aan anderen leert, zal in Gods rijk belangrijk zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Maar Ik zeg jullie: tenzij jullie een deugdzamer leven leiden dan de Schriftgeleerden en farizeeën, komen jullie Gods rijk in geen geval binnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jullie hebben gehoord dat vroeger tegen de mensen is gezegd: ‘Pleeg geen moord’, en: ‘Wie moord pleegt, verdient het Oordeel’. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Maar Ik zeg jullie: ieder die kwaad op zijn broeder of zuster blijft, verdient het Oordeel, wie ‘nietsnut’ tegen zijn broeder of zuster zegt, verdient het hoogste gerechtshof, en wie ‘dwaas’ tegen hem of haar zegt, verdient het vuur van de hel. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dus als je je offer naar het altaar brengt en je daar herinnert dat je broeder of zuster iets tegen je heeft, ");
INSERT INTO nldgbv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","laat je offer dan bij het altaar liggen, ga je eerst met je broeder of zuster verzoenen, en kom dan terug om je offer te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Leg het tijdig bij met je tegenstander, wanneer je nog met hem onderweg naar het gerecht bent; anders kan je tegenstander jou aan de rechter uitleveren, en de rechter kan je uitleveren aan de bewaker, zodat je in de gevangenis wordt gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ik verzeker je, je zal daar in geen geval uitkomen voordat je de laatste cent hebt betaald. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jullie hebben gehoord dat er is gezegd: ‘Pleeg geen echtbreuk.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Maar Ik zeg jullie dat ieder die een vrouw begerig bekijkt, in zijn hart al echtbreuk met haar heeft gepleegd. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Als je rechteroog jou tot zonde aanzet, verwijder het dan en gooi het weg, want je kan beter een van je lichaamsdelen verliezen dan dat je hele lichaam in de hel wordt gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","En als je rechterhand jou tot zonde aanzet, hak haar dan maar af en gooi haar weg, want je kan beter een van je lichaamsdelen verliezen dan dat je hele lichaam naar de hel gaat. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Er is ook gezegd: ‘Wie zijn vrouw wegstuurt, moet haar een echtscheidingsakte geven.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Maar Ik zeg jullie dat ieder die zijn vrouw wegstuurt om een andere reden dan seksueel wangedrag, zorgt dat er echtbreuk met haar wordt gepleegd. En ieder die met een weggestuurde vrouw trouwt, pleegt echtbreuk. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Verder hebben jullie gehoord dat vroeger tegen de mensen is gezegd: ‘Houd je aan de geloften die je tegenover je Heer aflegt en breek ze niet.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Maar Ik zeg jullie: zweer helemaal niet. Niet bij de hemel, want die is Gods troon. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Niet bij de aarde, want dat is zijn voetenbank, en niet bij Jeruzalem, want dat is de stad van de grote Koning. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Zweer ook niet bij je eigen hoofd, want je bent zelfs niet in staat om één haar wit of zwart te maken. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Laat je ‘ja’ gewoon ‘ja’ betekenen en je ‘nee’ ‘nee’. Alles wat verder gaat dan dat, komt van de duivel. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jullie hebben gehoord dat er is gezegd: ‘Oog om oog, tand om tand.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Maar Ik zeg jullie: vecht niet terug wanneer iemand je kwaad doet. Als iemand jou een klap op je rechterwang geeft, keer dan ook je andere wang naar hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Als iemand je via het gerecht je hemd wil afnemen, geef hem dan ook je mantel. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","En als iemand je beveelt een mijl met hem mee te gaan, ga dan twee mijl mee. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Als iemand jou om iets vraagt, geef het dan en als iemand iets van je wil lenen, weiger het hem dan niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jullie hebben gehoord dat er is gezegd: ‘Heb je naaste lief en haat je vijand.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Maar Ik zeg jullie: heb je vijanden lief en bid voor de mensen die jullie vervolgen, ");
INSERT INTO nldgbv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","opdat jullie kinderen van jullie hemelse Vader mogen zijn, want Hij laat zijn zon schijnen op zowel de slechte als de goede mensen en geeft regen aan zowel de rechtvaardigen als de onrechtvaardigen. ");
INSERT INTO nldgbv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Want als jullie liefdevol behandelen wie jullie liefdevol behandelt, welke beloning krijg je dan? Dat doen de belastinginners toch ook? ");
INSERT INTO nldgbv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","En als jullie alleen je eigen mensen begroeten, wat doen jullie dan voor speciaals? Dat doen zij die niet bij Gods volk horen toch ook? ");
INSERT INTO nldgbv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jullie moeten dus volmaakt zijn, zoals jullie hemelse Vader volmaakt is. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zorg dat jullie de dingen die God van je verlangt niet doen in het bijzijn van de mensen, om door hen te worden gezien; anders krijgen jullie geen beloning van jullie Vader in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dus wanneer jullie aan de armen geven, bazuin het dan niet rond zoals de hypocriete mensen doen, in de synagogen en op straat, om door de mensen geprezen te worden. Ik verzeker jullie: zij hebben hun beloning al. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wanneer je aan de armen geeft, zorg dan dat je linkerhand niet weet wat je rechterhand doet, ");
INSERT INTO nldgbv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","zodat je gift in het geheim wordt gegeven. Dan zal je Vader, die ziet wat er in het geheim gebeurt, je belonen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ook wanneer jullie bidden, moeten jullie dat niet doen zoals de hypocriete mensen, want zij houden ervan om in de synagogen en op straathoeken te staan bidden om door de mensen gezien te worden. Ik verzeker jullie: zij hebben hun beloning al. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maar wanneer jij bidt, ga dan naar je binnenkamer, sluit de deur en bid tot je Vader in het geheim. Dan zal je Vader, die ziet wat er in het geheim gebeurt, je belonen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Herhaal bij het bidden niet steeds gedachteloos dezelfde woorden zoals zij die niet bij Gods volk horen, want zij denken dat ze worden gehoord omdat ze veel woorden gebruiken. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wees dus niet zoals zij. Jullie Vader weet immers al wat jullie nodig hebben voordat jullie Hem erom vragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bid dus als volgt: Onze Vader in de hemel, laat de heiligheid van uw naam worden geëerd. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laat uw koninkrijk komen, laat gebeuren wat U wil, niet alleen in de hemel maar ook op aarde. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Geef ons voldoende eten voor vandaag ");
INSERT INTO nldgbv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","en vergeef ons onze schulden, zoals ook wij vergeven wie zich tegenover ons heeft schuldig gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","En laat niet toe dat we in verzoeking komen, maar verlos ons van de duivel. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Want als jullie de mensen het kwaad vergeven dat zij je aandoen, zal je hemelse Vader ook jullie vergeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Maar als je de mensen niet vergeeft, zal jullie Vader je zonden ook niet vergeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ook wanneer jullie vasten, moeten jullie dat niet doen zoals de hypocriete mensen, die triest kijken en hun uiterlijk niet verzorgen, zodat de mensen kunnen zien dat ze aan het vasten zijn. Ik verzeker jullie: zij hebben hun beloning al. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Maar wanneer jij vast, doe dan olie op je hoofd en was je gezicht, ");
INSERT INTO nldgbv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","zodat het bij de mensen niet opvalt dat je aan het vasten bent, maar wel bij je Vader, die door niemand wordt gezien. Dan zal je Vader, die ziet wat er in het geheim gebeurt, je belonen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Verzamel geen schatten voor jezelf op aarde, waar motten en roest vernieling aanrichten en waar dieven inbreken en stelen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Verzamel schatten voor jezelf in de hemel, waar geen motten of roest vernieling aanrichten en waar geen dieven inbreken en stelen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Want waar je schat is, daar zal ook je hart zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Het oog is de lamp van het lichaam, dus als je ogen in goede staat zijn, is je hele lichaam verlicht. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Maar als je ogen in slechte staat zijn, is je hele lichaam vol duisternis. En als het licht in jou eigenlijk duisternis is, dan is het wegens die duisternis slecht met je gesteld. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Niemand kan twee meesters dienen, want hij zal ofwel een hekel aan de ene hebben en van de andere houden, of toegewijd zijn aan de ene en de andere verachten. Jullie kunnen niet God én het geld dienen. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Daarom zeg Ik jullie: wees niet ongerust over je leven, over wat je zal eten of drinken, of over je lichaam, over hoe je je zal kleden. Het leven is toch meer dan eten en het lichaam is toch meer dan kledij? ");
INSERT INTO nldgbv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kijk eens naar de vogels: zij zaaien niet, oogsten niet en slaan geen eten op in schuren, en toch geeft jullie hemelse Vader hun te eten. Jullie zijn toch meer waard dan zij? ");
INSERT INTO nldgbv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wie van jullie kan, door ongerust te zijn, een uur aan zijn leven toevoegen? ");
INSERT INTO nldgbv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","En waarom zou je ongerust zijn over kledij? Kijk eens hoe de wilde bloemen groeien: ze doen geen inspanningen om kledij te maken. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ik zeg jullie: zelfs Salomo in al zijn pracht was niet zo mooi gekleed als zij. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","En als God het gras dat vandaag op het veld staat en morgen in de oven wordt gegooid, zo mooi kleedt, zal Hij jullie, kleingelovigen, dan niet nog beter kleden? ");
INSERT INTO nldgbv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Maak je dus geen zorgen en zeg niet: wat zullen we eten? Of: wat zullen we drinken? Of: waarmee zullen we ons kleden? ");
INSERT INTO nldgbv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Want dat zijn allemaal zaken die de ongelovigen najagen. Je hemelse Vader weet dat je dat alles nodig hebt. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jullie moeten echter prioriteit geven aan Gods koninkrijk en doen wat Hij van je vraagt; dan zullen ook al die dingen aan jullie worden gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maak je geen zorgen over de dag van morgen, want die heeft zijn eigen zorgen. Elke dag bevat al voldoende kwaad. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Oordeel niet over anderen, anders zal er over jou worden geoordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Want het oordeel dat jij velt, zal aan jou worden voltrokken en de maat die jij hanteert, zal op jou worden toegepast. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hoe is het mogelijk dat je wel de splinter in het oog van je naaste ziet, maar de balk in je eigen oog niet opmerkt? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","En hoe kan je tegen je naaste zeggen: ‘Laat mij de splinter uit je oog verwijderen’, terwijl de balk nog in jouw oog zit? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hypocriet, verwijder eerst de balk uit je eigen oog. Dan zal je goed genoeg zien om de splinter uit het oog van je naaste te verwijderen. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Geef het heilige niet aan de honden en werp je parels niet voor de zwijnen, anders vertrappelen die zwijnen de parels en keren die honden zich tegen je om je te verscheuren. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Vraag en het zal je gegeven worden, zoek en je zal vinden, klop en er zal voor je worden opengedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Want ieder die vraagt, zal ontvangen, en wie zoekt zal vinden en voor wie klopt, zal worden opengedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Of is er onder jullie iemand die, als zijn zoon hem om brood vraagt, hem een steen geeft? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","En als hij om vis vraagt, geeft hij hem toch geen slang? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Als jullie, die slecht zijn, goede geschenken weten te geven aan je kinderen, is het toch veel zekerder dat jullie Vader in de hemel goede dingen geeft aan wie erom vraagt? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Doe dus alles voor de mensen wat je wil dat zij voor jou zouden doen, want dat is wat de Wet en de Profeten voorschrijven. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ga naar binnen door de nauwe poort, want wijd is de poort – en breed de weg – die naar de ondergang leidt. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","En nauw is de poort – en smal de weg – die naar het leven leidt; er zijn er maar weinig die hem vinden! ");
INSERT INTO nldgbv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Pas op voor de valse profeten; zij doen zich aan jullie voor als schapen, maar zijn in wezen roofzuchtige wolven. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Je kan ze herkennen aan hun vruchten. Van een doornstruik worden toch geen druiven geoogst, of vijgen van distels? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Op dezelfde manier levert iedere goede boom goede vruchten op, en een slechte boom slechte vruchten. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Een goede boom kan toch geen slechte vruchten opleveren, of een slechte boom goede vruchten? ");
INSERT INTO nldgbv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Elke boom die geen goede vruchten oplevert, wordt omgehakt en in het vuur gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Je kan ze dus herkennen aan hun vruchten. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Niet iedereen die almaar ‘Heer, Heer’ tegen Mij zegt, zal Gods rijk binnengaan, maar wel wie doet wat mijn Vader in de hemel wil. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Op de Grote Dag zullen veel mensen Mij vragen: ‘Heer, Heer, we hebben toch in uw naam geprofeteerd, in uw naam demonen uitgedreven en in uw naam veel wonderen verricht?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","En dan zal Ik ronduit tegen hen zeggen: ‘Ik heb jullie nooit gekend! Ga weg, jullie zondaars!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Dus ieder die mijn woorden hoort en in praktijk brengt, is als een verstandig man, die zijn huis op een stevige ondergrond bouwde. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Toen het begon te regenen, er een overstroming kwam, het ging stormen en de wind tegen dat huis beukte, stortte het niet in, want het stond op een stevige ondergrond. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Maar ieder die mijn woorden hoort en ze niet in praktijk brengt, is als een dwaze man die zijn huis op los zand bouwde. ");
INSERT INTO nldgbv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Toen het begon te regenen, er een overstroming kwam, het ging stormen en de wind tegen dat huis beukte, stortte het in en was het volledig verwoest.” ");
INSERT INTO nldgbv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Toen Jezus was uitgesproken, was de mensenmassa diep onder de indruk van zijn onderwijs, ");
INSERT INTO nldgbv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","want Hij onderwees hen als een gezaghebbende en niet zoals hun Schriftgeleerden. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nadat Jezus van de berg was afgedaald, werd Hij gevolgd door grote groepen mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Er was iemand met een huidziekte die hem onrein maakte. Hij kwam naar Jezus toe, knielde voor Hem en zei: “Heer, als U wil, kan U mij rein maken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jezus stak zijn hand uit, raakte hem aan en zei: “Ik wil het, word rein!” De man werd meteen van zijn huidziekte genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Toen zei Jezus tegen hem: “Zorg dat je dit aan niemand vertelt, maar ga jezelf aan de priester tonen en breng het offer dat Mozes heeft opgelegd, bij wijze van getuigenis voor de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Toen Jezus Kafarnaüm binnenging, kwam er een centurio naar Hem toe. Hij smeekte Jezus: ");
INSERT INTO nldgbv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Heer, mijn knecht ligt thuis verlamd in bed met hevige pijn.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jezus vroeg hem: “Zal Ik hem komen genezen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","De centurio antwoordde: “Heer, ik ben het niet waard dat U mijn huis binnengaat. Maar als U het bevel geeft, zal mijn knecht genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Want ik ben ook iemand die onder gezag staat en zelf soldaten heeft. En als ik tegen de ene zeg: ‘ga’, dan gaat hij, en tegen een andere: ‘kom’, dan komt hij, en als ik tegen mijn slaaf zeg: ‘doe dit’, dan doet hij het.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jezus verbaasde zich over dat antwoord en zei tegen de mensen die Hem waren gevolgd: “Ik verzeker jullie: bij niemand in Israël heb Ik zo'n groot geloof gevonden! ");
INSERT INTO nldgbv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","En Ik zeg jullie: er zullen veel mensen uit het oosten en het westen komen en in Gods rijk met Abraham en Isaak en Jakob aan tafel plaatsnemen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Maar de ‘onderdanen van het koninkrijk’ zullen worden buitengegooid, de verste duisternis in, en daar zal worden geweend en met de tanden geknarst.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","En tegen de centurio zei Jezus: “Ga maar naar huis; datgene waarvoor u het geloof heeft, zal gebeuren.” Op dat moment werd de knecht van de centurio genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jezus kwam bij Petrus thuis en zag dat diens schoonmoeder met koorts in bed lag. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jezus nam haar hand vast en de koorts verdween. Ze stond op en bediende Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Die avond bracht men veel mensen bij Hem die bezeten waren. Hij dreef de geesten uit met een enkel woord en genas iedereen die een aandoening had. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Zo gingen de volgende woorden van de profeet Jesaja in vervulling: “Hij was het die onze ziekten wegnam en ons lijden droeg.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Toen Jezus zag dat er een menigte om Hem heen stond, gaf Hij de opdracht om het meer over te steken. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Er kwam een Schriftgeleerde naar Hem toe, die zei: “Leraar, ik zal U volgen, waarheen U ook gaat.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jezus zei tegen hem: “De vossen hebben holen en de vogels hebben nesten, maar de Mensenzoon heeft geen plaats om zijn hoofd te laten rusten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iemand anders, een van zijn leerlingen, zei tegen Hem: “Heer, laat mij eerst gaan om mijn vader te begraven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Maar Jezus zei tegen hem: “Volg Mij en laat de doden hun doden begraven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jezus stapte in een boot en zijn leerlingen gingen mee. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Op het meer stak plots een hevige storm op, zodat de golven over de rand van de boot sloegen. Maar Jezus sliep. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","De leerlingen kwamen Hem wakker maken en zeiden: “Heer, red ons, we vergaan!” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jezus antwoordde: “Waarom zijn jullie bang? Wat hebben jullie weinig geloof!” Toen stond Hij op en Hij berispte de wind en het meer. Het werd heel stil. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iedereen was verbaasd en vroeg: “Wat voor iemand is Hij toch, dat zelfs de wind en het meer Hem gehoorzamen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Toen Hij aan de overkant was gekomen, in het gebied van de Gadarenen, kwamen twee bezeten mensen van tussen de graven naar Hem toe. Ze waren zo gevaarlijk dat niemand daar langs kon gaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ze schreeuwden tegen Hem: “Wat wilt U van ons, Zoon van God? Bent U hier gekomen om ons voortijdig te folteren?” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nu was er op enige afstand van hen een grote kudde varkens aan het grazen. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","De demonen smeekten Jezus: “Als U ons uitdrijft, stuur ons dan alstublieft die kudde varkens in!” ");
INSERT INTO nldgbv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hij zei tegen hen: “Ga!” En dus kwamen ze naar buiten en drongen ze de varkens binnen. De hele kudde stormde de helling af, het meer in, en ze verdronken in het water. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","De varkenshoeders renden weg, naar de stad, en maakten bekend wat er allemaal was gebeurd, ook met de mensen die bezeten waren geweest. ");
INSERT INTO nldgbv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Toen kwamen alle mensen de stad uit, naar Jezus toe, en toen ze Hem zagen, smeekten ze Hem uit hun streek te vertrekken. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jezus stapte in een boot, stak het meer over en ging naar zijn thuisstad. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Enkele mensen brachten iemand bij Hem die verlamd was en op een draagbed lag. Toen Jezus zag hoeveel geloof ze hadden, zei Hij tegen de verlamde man: “Wees gerust, mijn kind, je zonden zijn je vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Toen zeiden enkele van de Schriftgeleerden tegen elkaar: “Die Man lastert God.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jezus merkte wat ze dachten en zei: “Waarom denken jullie zulke slechte dingen? ");
INSERT INTO nldgbv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wat is gemakkelijker, zeggen: je zonden zijn vergeven, of zeggen: sta op en wandel? ");
INSERT INTO nldgbv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Maar om te zorgen dat jullie beseffen dat de Mensenzoon het gezag heeft om op aarde zonden te vergeven …” Toen zei Hij tegen de verlamde man: “Sta op, neem je draagbed op en ga naar huis.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","De man stond op en ging naar huis. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Toen de mensen dat zagen, waren ze diep onder de indruk en ze verheerlijkten God, omdat Hij dergelijk gezag aan mensen had gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Toen Jezus daarvandaan verder ging, zag Hij iemand die Matteüs heette bij het tolhuis zitten. Jezus zei tegen hem: “Volg Mij.” En Matteüs stond op en volgde Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Toen Jezus op een dag bij Matteüs thuis was voor een maaltijd, kwamen er veel belastinginners en zondaars met Hem en zijn leerlingen mee-eten. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Enkele farizeeën zagen dat en vroegen aan zijn leerlingen: “Waarom eet jullie Leraar samen met belastinginners en zondaars?” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jezus hoorde dat en zei: “Het zijn niet de gezonde mensen die een dokter nodig hebben, maar de zieken. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jullie moeten leren wat ‘Ik verlang mededogen, geen offers’ betekent. Ik ben namelijk niet gekomen om rechtvaardige mensen te roepen, maar zondaars.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Toen kwamen de leerlingen van Johannes Hem vragen: “Wij en de farizeeën vasten dikwijls; waarom vasten uw leerlingen niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jezus antwoordde: “De gasten van de bruidegom kunnen toch niet rouwen terwijl de bruidegom bij hen is? Er komt echter een tijd dat de bruidegom bij hen wordt weggehaald en dan zullen ze vasten. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Niemand verstelt een oud kledingstuk met een stuk stof dat nog niet gekrompen is, want dan trekt het verstelstuk de stof kapot en ontstaat er een grotere scheur. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ook giet men geen nieuwe wijn in oude wijnzakken, want dan barsten de zakken open, stroomt de wijn eruit en zijn de zakken kapot. Nee, men giet nieuwe wijn in nieuwe wijnzakken; dan blijven de twee samen behouden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Terwijl Jezus deze dingen tegen hen zei, kwam een vooraanstaand man naar Jezus toe. Hij knielde voor Hem en zei: “Mijn dochter is pas gestorven. Maar kom uw hand op haar leggen; dan zal ze weer leven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jezus stond op en ging, samen met zijn leerlingen, met de man mee. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Er was echter een vrouw die al twaalf jaar aan bloedingen leed, en die Jezus van achteren benaderde en de kwast onderaan zijn mantel aanraakte. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ze dacht namelijk: “Als ik slechts zijn mantel aanraak, zal ik genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jezus draaide zich om, zag haar en zei: “Wees gerust, mijn dochter, je geloof heeft je genezen.” De vrouw werd genezen op datzelfde moment. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Daarna ging Jezus het huis van de vooraanstaande man binnen. Hij zag de fluitspelers en de luid wenende menigte ");
INSERT INTO nldgbv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","en zei: “Gaan jullie maar weg; het meisje is niet dood, ze slaapt alleen maar.” Ze lachten Hem echter uit. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Toen de menigte naar buiten was gestuurd, ging Hij naar binnen, nam haar hand vast en het meisje stond op. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Het nieuws hierover verspreidde zich over die hele streek. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Toen Jezus daarvandaan verderging, werd Hij gevolgd door twee mensen die blind waren. Ze riepen: “Heb medelijden met ons, Zoon van David!” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Toen Hij thuisgekomen was, kwamen de twee bij Hem. Jezus vroeg hen: “Geloven jullie dat Ik dit kan doen?” Ze antwoordden: “Ja, Heer.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Toen raakte Hij hun ogen aan en zei Hij: “Laat nu gebeuren wat jullie geloven!” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Toen konden ze zien. Jezus waarschuwde hen: “Pas op, niemand mag hiervan weten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Maar zij gingen eropuit en maakten het bekend in de hele streek. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nadat ze waren vertrokken, werd iemand bij Jezus gebracht die niet kon spreken omdat hij bezeten was. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Toen de demon was uitgedreven, begon de man te spreken. De mensenmassa stond er versteld van en zei: “Dit is nog nooit vertoond in Israël.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Maar de farizeeën zeiden: “Hij drijft demonen uit door de kracht van de heerser over de demonen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jezus trok rond langs alle steden en dorpen, waar Hij in de synagogen onderwees, het evangelie van Gods koninkrijk verkondigde en iedere ziekte en aandoening van de mensen genas. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Toen Hij de vele mensen zag, kreeg Hij medelijden met hen, omdat ze verward en uitgeput waren, als schapen zonder herder. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hij zei tegen zijn leerlingen: “De oogst is wel groot, maar er zijn weinig arbeiders. ");
INSERT INTO nldgbv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Smeek daarom de Heer van de oogst om arbeiders naar zijn oogst te zenden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jezus riep zijn twaalf leerlingen bij zich en gaf hun het gezag om onreine geesten uit te drijven en elke ziekte en aandoening te genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","De namen van de twaalf apostelen zijn: vooreerst Simon die Petrus wordt genoemd, en zijn broer Andreas, verder Jakobus, de zoon van Zebedeüs, zijn broer Johannes, ");
INSERT INTO nldgbv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippus, Bartolomeüs, Tomas, Matteüs de belastinginner, Jakobus, de zoon van Alfeüs, Taddeüs, ");
INSERT INTO nldgbv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon de Zeloot en Judas Iskariot, die Jezus heeft verraden. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Deze twaalf stuurde Jezus op pad met de volgende instructies: “Begeef je niet onder de niet-Joden en ga geen Samaritaanse stad binnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ga daarentegen naar het volk Israël, de verloren schapen, ");
INSERT INTO nldgbv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","en verkondig onderweg dat Gods rijk in aantocht is. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Genees zieken, wek doden tot leven, maak mensen met huidziekten rein, en drijf demonen uit. Jullie hebben gratis gekregen en moeten zelf ook gratis geven. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ga zonder gouden, zilveren of koperen munten in je geldriem ");
INSERT INTO nldgbv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","en zonder reistas, zonder extra kledij of schoenen en zonder wandelstok, want de arbeider is zijn levensonderhoud waard. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wanneer jullie een stad of dorp bezoeken, ontdek dan wie het waard is jullie te ontvangen en blijf bij die persoon logeren totdat je vertrekt. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wens bij het binnengaan van het huis de mensen daar vrede toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Als ze het waard zijn, zal je vredeswens op hen rusten. Maar als ze het niet waard zijn, zal je vredeswens geen effect op hen hebben. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Als iemand je niet verwelkomt of niet naar je woorden luistert, vertrek dan uit dat huis of die stad en schud het stof van je voeten. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ik verzeker jullie: op de Oordeelsdag zal het draaglijker zijn voor de mensen van Sodom en Gomorra dan voor de mensen van die stad. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ik stuur jullie eropuit als schapen tussen de wolven. Wees dus zo behoedzaam als slangen en zo onschuldig als duiven. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","En pas op voor de mensen, want ze zullen jullie aan stadsraden uitleveren en jullie geselen in hun synagogen. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Omwille van Mij zullen jullie voor heersers en koningen worden geleid, om te getuigen tegenover hen en de volken. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wanneer je wordt overgeleverd, wees dan niet ongerust over wat je precies zal zeggen, want de woorden zullen je op dat moment worden ingegeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Dan ben je het namelijk niet zelf die spreekt, maar dan spreekt in jullie de Geest van jullie Vader. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","De ene broer zal de andere uitleveren om te worden omgebracht, en een vader zijn kind; kinderen zullen tegen hun ouders in opstand komen en hen laten ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jullie zullen door iedereen worden gehaat omwille van mijn naam, maar wie standhoudt tot het einde, zal worden gered. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wanneer men jullie in de ene stad vervolgt, vlucht dan naar de andere. Want Ik verzeker jullie: jullie zullen niet in alle steden van Israël zijn geweest voordat de Mensenzoon komt. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Een leerling staat niet boven zijn leraar en een slaaf niet boven zijn meester. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Het is voor de leerling voldoende om te zijn als zijn leraar en voor de slaaf om te zijn als zijn meester. Als de mensen de huiseigenaar Beëlzebul hebben genoemd, waarvoor zullen ze dan zijn huisgenoten uitmaken? ");
INSERT INTO nldgbv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wees dus niet bang voor de mensen, want er is niets verborgen dat niet zal worden onthuld en er is niets geheim dat niet zal worden bekendgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wat Ik in het geheim tegen jullie zeg, moeten jullie in het openbaar doorvertellen en wat Ik jullie in het oor fluister, moeten jullie van de daken verkondigen. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wees niet bang voor wie wel het lichaam maar niet de ziel kunnen doden; je zou beter bang zijn voor Hem die zowel de ziel als het lichaam kan vernietigen in de hel. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Worden mussen niet per twee verkocht voor een kopermuntje? Toch valt niet één mus op de grond buiten jullie Vader om. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","En alle haren op je hoofd zijn geteld. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jullie zijn veel meer waard dan mussen; wees dus niet bang. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ieder die Mij erkent bij de mensen, zal Ik erkennen bij mijn Vader in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","En wie Mij verloochent bij de mensen, zal Ik verloochenen bij mijn Vader in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Denk niet dat Ik ben gekomen om vrede op aarde te brengen. Ik ben niet gekomen om vrede te brengen, maar het zwaard. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ik ben gekomen om vijandschap te brengen tussen mannen en hun vaders, tussen dochters en hun moeders, en tussen schoondochters en hun schoonmoeders. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","En huisgenoten zullen elkaars vijanden worden. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wie meer van zijn vader of moeder houdt dan van Mij, is Mij niet waard, en wie meer van zijn zoon of dochter houdt dan van Mij, is Mij niet waard. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","En wie niet zijn kruis op zich neemt en Mij volgt, is Mij niet waard. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wie het ware leven denkt te hebben gevonden, zal het verliezen, maar wie zijn leven loslaat voor Mij, zal het ware leven vinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wie jullie verwelkomt, verwelkomt Mij en wie Mij verwelkomt, verwelkomt Degene die Mij heeft gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wie een profeet verwelkomt als een profeet, zal als een profeet worden beloond en wie een rechtvaardig mens verwelkomt als een rechtvaardig mens, zal als een rechtvaardig mens worden beloond. ");
INSERT INTO nldgbv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","En wie een van deze eenvoudige mensen een beker koud water geeft, enkel en alleen omdat hij mijn volgeling is, Ik verzeker jullie dat hij zijn beloning zeker niet zal mislopen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nadat Jezus zijn instructies aan zijn twaalf leerlingen had afgerond, vertrok Hij om in de steden in dat gebied te onderwijzen en te preken. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Toen Johannes de Doper in de gevangenis hoorde wat de Messias aan het doen was, stuurde hij enkele van zijn leerlingen naar Jezus toe ");
INSERT INTO nldgbv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","met de vraag: “Bent U degene die zou komen, of moeten we iemand anders verwachten?” ");
INSERT INTO nldgbv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jezus antwoordde: “Ga Johannes verslag uitbrengen van wat jullie horen en zien: ");
INSERT INTO nldgbv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","blinde mensen kunnen weer zien, verlamde mensen beginnen te stappen, mensen met een huidziekte worden rein, dove mensen kunnen weer horen, dode mensen verrijzen, en aan arme mensen wordt het evangelie verkondigd. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wie zich niet aan Mij ergert, is gezegend.” ");
INSERT INTO nldgbv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Toen de leerlingen van Johannes vertrokken, zei Jezus over hem tegen de mensenmassa: “Wat zijn jullie gaan bekijken in de wildernis? Riet dat wuift in de wind? ");
INSERT INTO nldgbv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nee! Wat gingen jullie bekijken: een man in mooie kleren? Nee, de mensen in mooie kleren bevinden zich in paleizen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wat gingen jullie dan wel bekijken? Een profeet? Jazeker, zeg Ik jullie, iemand die meer is dan een profeet. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hij is het over wie werd geschreven: ‘Ik stuur mijn boodschapper voor Je uit, die de weg voor Je zal banen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ik verzeker jullie: onder hen die uit een vrouw zijn geboren, is er niemand opgestaan die belangrijker is dan Johannes de Doper, maar in Gods rijk is de geringste belangrijker dan hij. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","En vanaf de periode dat Johannes de Doper optrad tot nu toe wordt Gods rijk bestormd en de bestormers proberen het binnen te dringen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Want alle Profeten en de Wet hebben erover geprofeteerd totdat Johannes kwam. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","En als jullie bereid zijn om het te aanvaarden: Johannes is Elia, die zou komen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Als je oren hebt, luister dan! ");
INSERT INTO nldgbv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Waarmee zal ik dit soort mensen vergelijken? Ze zijn als kinderen die op de marktpleinen zitten en naar anderen roepen: ");
INSERT INTO nldgbv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wij hebben voor jullie op de fluit gespeeld en jullie hebben niet gedanst, we hebben een klaaglied gezongen en jullie hebben niet gerouwd.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Want toen Johannes kwam en niet at of dronk, zeiden ze: ‘Hij heeft een demon in zich.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Maar toen de Mensenzoon kwam en wel at en dronk, zeiden ze: ‘Kijk, een veelvraat en een dronkaard, een vriend van belastinginners en zondaars!’ De juistheid van wijsheid wordt aangetoond door de daden die erop gebaseerd zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Toen begon Jezus de steden waar de meeste van zijn wonderen waren gebeurd, te verwijten dat ze niet tot inkeer waren gekomen: ");
INSERT INTO nldgbv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wee jou, Chorazin, wee jou, Betsaïda, want als de wonderen die bij jullie zijn gebeurd, in Tyrus en Sidon hadden plaatsgevonden, dan zou men daar allang in zak en as hebben gezeten en tot inkeer zijn gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Maar Ik zeg jullie: op de Oordeelsdag zal het draaglijker zijn voor de mensen van Tyrus en Sidon dan voor jullie. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","En jij, Kafarnaüm, zal jij worden verheven naar de hemel? Nee, je zal worden verlaagd naar het dodenrijk. Want als de wonderen die bij jou zijn gebeurd, in Sodom hadden plaatsgevonden, dan zou het vandaag nog bestaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Maar Ik zeg jullie: op de Oordeelsdag zal het draaglijker zijn voor het land Sodom dan voor jou.” ");
INSERT INTO nldgbv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","In die tijd zei Jezus ook: “Ik dank U, Vader, Heer van hemel en aarde, dat U deze dingen hebt verborgen voor wijzen en verstandigen, maar ze hebt onthuld aan eenvoudigen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ja, Vader, want zo is het goed in uw ogen. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Alles is door mijn Vader aan Mij toevertrouwd. Niemand kent de Zoon behalve de Vader, en niemand kent de Vader behalve de Zoon en zij aan wie de Zoon Hem wenst bekend te maken. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kom bij Mij, iedereen die afgemat en zwaar beladen is, en Ik zal jullie rust geven. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Draag mijn juk en leer van Mij, want Ik heb een zachtmoedig en nederig hart. Dan zullen jullie innerlijke rust vinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Want mijn juk is zacht en mijn last is licht.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","In die periode wandelde Jezus op een sabbat tussen de graanvelden door. Zijn leerlingen kregen honger en begonnen aren te plukken en op te eten. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Toen de farizeeën dat zagen, zeiden ze tegen Jezus: “Uw leerlingen doen iets dat op de sabbat niet is toegestaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Maar Hij antwoordde: “Hebben jullie niet gelezen wat David deed toen hij en zijn mannen honger hadden? ");
INSERT INTO nldgbv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hij ging het huis van God binnen en hij en zijn mannen aten van de gewijde broden, hoewel hun dat niet was toegestaan; enkel de priesters mochten dat. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","En hebben jullie niet in de Wet gelezen dat de priesters die op de sabbat in de tempel zijn, de sabbat ontwijden maar toch onschuldig zijn? ");
INSERT INTO nldgbv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Maar Ik zeg jullie dat hier iets belangrijkers is dan de tempel. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","En als jullie hadden geweten wat ‘Ik verlang mededogen, geen offers’ betekent, dan hadden jullie de onschuldigen niet veroordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Want de Mensenzoon is baas over de sabbat.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Toen vertrok Hij daarvandaan en ging Hij hun synagoge binnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Daar was iemand met een verlamde hand. Om Jezus te kunnen beschuldigen, vroegen ze Hem: “Is het toegestaan om op de sabbat te genezen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jezus antwoordde: “Wie van jullie die een schaap heeft zou dat, als het op de sabbat in een kuil zou vallen, niet vastgrijpen en eruit halen? ");
INSERT INTO nldgbv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","En een mens is toch veel meer waard dan een schaap? Daarom is het toegestaan om goed te doen op de sabbat.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Vervolgens zei Hij tegen de man: “Steek je hand uit.” De man stak zijn hand uit en die genas; hij was nu even gezond als de andere. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","De farizeeën gingen naar buiten en beraamden een plan om Hem om te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Maar Jezus wist ervan en vertrok daarvandaan. Grote aantallen mensen volgden Hem en Hij genas hen allen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hij verbood hun echter bekend te maken wie Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zo gingen de volgende woorden van de profeet Jesaja in vervulling: ");
INSERT INTO nldgbv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dit is mijn dienaar die Ik heb uitverkoren, mijn dierbare, over Wie Ik Mij verheug. Ik zal mijn Geest op Hem leggen en Hij zal gerechtigheid aankondigen aan de volken. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hij zal niet ruziën of schreeuwen en op straat zal niemand zijn stem horen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Het geknakte riet zal Hij niet afbreken en een smeulende wiek zal Hij niet uitdoven, totdat Hij de gerechtigheid doet overwinnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Op Hem zullen de volken hun hoop vestigen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Er werd iemand bij Jezus gebracht die bezeten was en niet kon zien of spreken. Jezus genas hem, zodat de man kon spreken en zien. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Alle mensen waren verbaasd; ze zeiden: “Zou Hij de Zoon van David zijn?” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","De farizeeën hoorden dat en zeiden: “Hij kan de demonen alleen maar uitdrijven omdat Beëlzebul, de heerser over de demonen, Hem daartoe in staat stelt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jezus wist echter wat ze dachten en zei: “Ieder koninkrijk dat innerlijk verdeeld is, gaat te gronde, en geen enkele stad of familie die innerlijk verdeeld is, zal standhouden. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","En als Satan Satan uitdrijft, is hij innerlijk verdeeld. Dus hoe kan zijn koninkrijk dan standhouden? ");
INSERT INTO nldgbv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","En als Ik de demonen uitdrijf doordat Beëlzebul Mij daartoe in staat stelt, wie stelt jullie aanhangers dan in staat om ze uit te drijven? Zij tonen aan dat jullie ongelijk hebben. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Maar als het Gods Geest is die Mij in staat stelt om demonen uit te drijven, dan blijkt daaruit dat Gods koninkrijk bij jullie is gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Of hoe zou iemand het huis van een sterk persoon kunnen binnendringen en diens bezittingen kunnen roven? Hij zal toch eerst de sterke persoon vastbinden en pas daarna het huis leegroven? ");
INSERT INTO nldgbv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wie niet voor Mij is, is tegen Mij en wie niet met Mij bijeenbrengt, drijft uiteen. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Daarom zeg Ik jullie: elke zonde en elke godslastering kan de mensen worden vergeven, maar lastering tegen de Geest zal niet worden vergeven ");
INSERT INTO nldgbv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","en wie kwaadspreekt over de Mensenzoon, kan worden vergeven, maar wie kwaadspreekt over de Heilige Geest, zal niet worden vergeven, noch in dit tijdperk, noch in het toekomstige. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Van een boom moet je ofwel zeggen dat hij goed is, en dan zijn de vruchten ervan ook goed, ofwel moet je zeggen dat hij slecht is, en dan zijn ook de vruchten ervan slecht, want de boom is te herkennen aan zijn vruchten. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Addergebroed, jullie kunnen toch geen goede woorden spreken terwijl jullie slecht zijn? Want waar het hart vol van is, daarvan spreekt de mond. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Een goed mens haalt uit zijn voorraad goedheid goede dingen tevoorschijn, en een slecht mens haalt uit zijn voorraad slechtheid slechte dingen tevoorschijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Maar Ik zeg jullie: op de Oordeelsdag zullen de mensen verantwoording moeten afleggen voor iedere lichtzinnige opmerking die ze hebben gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Want op basis van je woorden zal je worden vrijgesproken en op basis van je woorden zal je worden veroordeeld.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Toen vroegen enkele Schriftgeleerden en farizeeën Hem: “Leraar, wij willen U graag een teken zien doen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jezus antwoordde: “Slechte en overspelige mensen eisen een teken, maar er zal hun geen teken worden gegeven, behalve het teken van de profeet Jona. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Want zoals Jona zich drie dagen en drie nachten in de buik van het grote zeedier bevond, zal de Mensenzoon zich drie dagen en drie nachten in het hart van de aarde bevinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bij het Oordeel zullen tegelijk met jullie soort de inwoners van Nineve verrijzen en zij zullen jullie veroordelen, want zij kwamen tot inkeer door Jona's verkondiging, en hier is Iemand die groter is dan Jona. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bij het Oordeel zal tegelijk met jullie soort de koningin van het Zuiden verrijzen en zij zal jullie veroordelen, want zij kwam van de uithoeken van de aarde naar Salomo's wijsheid luisteren en hier is Iemand die groter is dan Salomo. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wanneer een onreine geest uit een mens is gekomen, trekt hij door dorre plaatsen op zoek naar een rustplaats, zonder die te vinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dan zegt hij: ‘Ik ga terug naar het huis waar ik vandaan kom.’ En wanneer hij aankomt, treft hij het huis onbewoond, geveegd en opgeruimd aan. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dan gaat hij weg om zeven andere geesten op te halen die nog slechter zijn dan hijzelf, en ze nemen er hun intrek. Dan is die persoon er slechter aan toe dan eerst. Zo zal het ook zijn met jullie soort slechte mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Terwijl Hij de mensenmassa nog toesprak, stonden onverwachts zijn moeder en broers buiten. Ze wilden Hem spreken. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iemand zei tegen Jezus: “Uw moeder en broers staan buiten en ze willen met U spreken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jezus antwoordde de persoon die het Hem had verteld: “Wie is mijn moeder en wie zijn mijn broers?” ");
INSERT INTO nldgbv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hij wees naar zijn leerlingen en zei: “Dit zijn mijn moeder en mijn broers. ");
INSERT INTO nldgbv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Want wie doet wat mijn Vader in de hemel wil, die is mijn broer, zus of moeder.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Diezelfde dag verliet Jezus het huis en ging Hij bij het meer zitten. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Er verzamelde zich zo'n grote mensenmassa om Hem heen, dat Hij in een boot plaatsnam, terwijl alle mensen op de oever bleven staan. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hij vertelde hun van alles in de vorm van parabels. Hij zei: “Er was eens een zaaier die ging zaaien. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tijdens het zaaien vielen er wat zaadjes langs het pad en de vogels kwamen ze oppikken. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Andere zaadjes vielen in ondiepe laagjes aarde op rotsgrond. De plantjes schoten meteen op, omdat de aarde ondiep was. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Maar toen de zon hoog kwam te staan, verschroeiden de plantjes; en omdat ze geen wortels hadden, gingen ze dood. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nog andere zaadjes vielen tussen het onkruid en het onkruid kwam op en verstikte hen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Weer andere zaadjes vielen in goede aarde en leverden een goede oogst op, wel honderd-, zestig- of dertigmaal zoveel als er was gezaaid. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Als je oren hebt, luister dan!” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Later kwamen Jezus' leerlingen Hem vragen: “Waarom spreekt U de mensen toe in de vorm van parabels?” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hij antwoordde: “Omdat het jullie is gegeven de geheimen van Gods rijk te kennen, maar hun is dat niet gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Want aan wie heeft, zal nog meer worden gegeven, zodat hij overvloed zal hebben. Maar van wie niets heeft, zal zelfs hetgeen hij heeft worden afgenomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Daarom spreek Ik hen toe in parabels, zodat ze wel zien maar niet begrijpen, en wel horen maar niet verstaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Voor hen is de volgende profetie van Jesaja in vervulling gegaan: ‘Jullie zullen wel horen maar niet verstaan, en wel zien maar niet begrijpen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Want het hart van dit volk is gevoelloos geworden, hun oren kunnen nauwelijks horen en hun ogen hebben ze gesloten. Anders zouden ze met hun ogen kunnen zien en met hun oren kunnen horen en met hun hart verstaan en zich bekeren en dan zou Ik hen gezond maken.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Maar omdat jullie ogen zien en jullie oren horen, zijn ze gezegend. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Want Ik verzeker jullie: veel profeten en rechtvaardige mensen wilden graag zien wat jullie zien, maar ze hebben het niet gezien. En ze wilden graag horen wat jullie horen, maar ze hebben het niet gehoord. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Luister dus naar de uitleg van de parabel van de zaaier: ");
INSERT INTO nldgbv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Telkens wanneer iemand de boodschap van het koninkrijk hoort en deze niet begrijpt, komt de duivel weggrissen wat in het hart van die persoon was gezaaid. Dit is wat langs het pad is gezaaid. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wat op de rotsgrond is gezaaid, is als de persoon die de boodschap hoort en haar meteen vol vreugde aanvaardt. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Maar hij is oppervlakkig en het raakt niet diep in hem geworteld. Zodra er verdrukking of vervolging komt omwille van het evangelie, komt hij ten val. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","En wat tussen het onkruid is gezaaid, is als de persoon die de boodschap hoort, maar de zorgen van dit leven en de misleiding van de rijkdom verstikken de boodschap, zodat deze niets oplevert. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wat in goede aarde is gezaaid, is als de persoon die het evangelie hoort, het begrijpt en vruchten voortbrengt; in het ene geval honderd-, in het andere zestig- en in nog een ander geval dertigmaal zoveel als er was gezaaid.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jezus vertelde hun nog een parabel: “Het is met Gods rijk als met iemand die goed zaad in zijn akker zaaide. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Maar terwijl iedereen sliep, kwam zijn vijand schadelijk onkruid tussen het graan zaaien en ging hij weer weg. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Toen de plantjes opkwamen en aren vormden, verscheen ook het schadelijk onkruid. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","De knechten van de landeigenaar vroegen hem: ‘Meneer, u had toch goed zaad in uw akker gezaaid? Waar komt dat schadelijk onkruid dan vandaan?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hij antwoordde: ‘Dat heeft een vijand gedaan.’ De knechten vroegen hem: ‘Wilt u dat we gaan wieden?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Maar hij antwoordde: ‘Nee, want als jullie het onkruid zouden wieden, zouden jullie ook de wortels van het graan lostrekken. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Laat het allemaal samen opgroeien tot de oogsttijd. Dan zal ik tegen de maaiers zeggen: Breng eerst het onkruid bijeen en maak er bundels van om te verbranden, en oogst dan het graan en breng het naar mijn schuur.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jezus vertelde hun nog een parabel: “Het is met Gods rijk als met een mosterdzaadje dat iemand in zijn akker zaaide. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Het is kleiner dan alle andere zaden, maar wanneer het uitgroeit, is het de grootste van de moestuinplanten en wordt het een boom, zodat de vogels in zijn takken komen nestelen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hij vertelde hun nog een parabel: “Het is met Gods rijk als met desem die door een vrouw vermengd werd met drie porties meel, totdat het deeg volledig doordesemd was.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jezus vertelde dat alles aan de mensenmassa in de vorm van parabels; Hij vertelde hun niets zonder parabels te gebruiken. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zo gingen de volgende woorden van de profeet Jesaja in vervulling: “Ik open mijn mond om in parabels te spreken, ik maak bekend wat vanaf de schepping van de wereld verborgen is geweest.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nadat Hij afscheid had genomen van de mensenmassa, ging Hij naar huis. Zijn leerlingen kwamen bij Hem en vroegen: “Wilt U de parabel van het schadelijk onkruid op de akker aan ons uitleggen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jezus antwoordde: “De zaaier van het goede zaad is de Mensenzoon. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","De akker is de wereld en het goede zaad zijn de onderdanen van het koninkrijk. Het schadelijk onkruid, dat zijn de onderdanen van de duivel. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","De vijand die hen zaaide is de duivel, de oogst is het einde van de wereld en zij die de oogst binnenhalen zijn engelen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","En zoals het schadelijk onkruid bijeengebracht en verbrand wordt, zo zal het ook zijn bij het einde van de wereld. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","De Mensenzoon zal zijn engelen uitzenden en zij zullen alles uit zijn koninkrijk dat tot zonde aanzet en ieder die het slechte doet bijeenbrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Die zullen in de brandende oven worden gegooid en daar zal worden geweend en met de tanden geknarst. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dan zullen de rechtvaardigen in het koninkrijk van hun Vader stralen als de zon. Als je oren hebt, luister dan! ");
INSERT INTO nldgbv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Het is met Gods rijk als met een schat die in een akker is verborgen, en die door iemand wordt gevonden en weer toegedekt. Hij is er zo blij over dat hij weggaat, alles verkoopt wat hij heeft en die akker koopt. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Het is met Gods rijk ook als met een zakenman die op zoek was naar mooie parels. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hij vond een parel die zo kostbaar was, dat hij al zijn bezittingen verkocht om die parel te kopen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Het is met Gods rijk ook als met een lang visnet dat in het meer werd gegooid en waarin allerlei vissen werden gevangen. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Toen het vol was, werd het aan wal getrokken en men ging zitten om de goede vissen in emmers te doen en de slechte weg te gooien. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zo zal het zijn bij het einde van de wereld. De engelen zullen eropuit gaan en de slechte mensen scheiden van de rechtvaardige. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ze zullen de slechte mensen in de brandende oven gooien en daar zal worden geweend en met de tanden geknarst. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hebben jullie dit alles begrepen?” De leerlingen antwoordden: “Ja.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jezus zei tegen hen: “Daarom is iedere Schriftgeleerde die een leerling in Gods rijk is geworden, als een huiseigenaar die uit zijn voorraadkamer nieuwe en oude dingen tevoorschijn haalt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Toen Jezus deze parabels had afgerond, vertrok Hij daarvandaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hij kwam in zijn thuisstad en onderwees de mensen daar in hun synagoge, zodat ze diep onder de indruk waren en vroegen: “Vanwaar haalt Hij die wijsheid en die wonderen? ");
INSERT INTO nldgbv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Is dit niet de zoon van de bouwer? Heet zijn moeder niet Maria en zijn broers Jakobus, Jozef, Simon en Judas? ");
INSERT INTO nldgbv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","En wonen niet al zijn zussen bij ons? Waar haalt Hij dat alles dan vandaan?” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ze ergerden zich aan Hem, maar Jezus zei tegen hen: “Het is alleen in zijn thuisstad en in zijn eigen huis dat een profeet geen eer ontvangt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","En wegens hun ongeloof deed Hij daar slechts weinig wonderen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","In die tijd hoorde de tetrarch Herodes de berichten over Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hij zei tegen zijn dienaren: “Dit is Johannes de Doper; hij is uit de dood verrezen en daarom beschikt hij over deze bijzondere krachten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes had Johannes namelijk laten arresteren, boeien en gevangenzetten wegens Herodias, de vrouw van zijn broer Filippus. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Dat was omdat Johannes tegen hem had gezegd: “U mag niet met haar trouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes wilde Johannes doden, maar hij was bang voor de mensen, omdat die Johannes als een profeet beschouwden. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Op de verjaardag van Herodes danste de dochter van Herodias voor de gasten en Herodes beleefde daar zoveel plezier aan, ");
INSERT INTO nldgbv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","dat hij zwoer dat hij haar zou geven wat ze maar zou vragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Daarom zei ze, opgestookt door haar moeder: “Geef mij hier, op een schaal, het hoofd van Johannes de Doper.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hoewel de koning ontsteld was, beval hij, omwille van wat hij had gezworen in het bijzijn van zijn gasten, dat haar verzoek moest worden ingewilligd. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hij stuurde iemand om Johannes in de gevangenis te onthoofden. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Johannes' hoofd werd op een schaal naar binnen gebracht en aan het meisje gegeven, en zij bracht het naar haar moeder. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Toen kwamen Johannes' leerlingen zijn lichaam ophalen. Ze begroeven het en gingen dat aan Jezus vertellen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Toen Jezus hun verslag gehoord had, vertrok Hij in een boot naar een afgelegen plaats om alleen te zijn. De mensenmassa hoorde dat en volgde Hem te voet vanuit de steden. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Toen Jezus uit de boot stapte, zag Hij een grote menigte. Hij kreeg medelijden met de mensen en genas hun zieken. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Toen het avond werd, kwamen zijn leerlingen Hem zeggen: “Dit is een afgelegen plaats en het is al laat geworden. Stuur de mensen toch weg, zodat ze naar de dorpen kunnen gaan om eten voor zichzelf te kopen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jezus antwoordde: “Ze hoeven niet weg te gaan; geven jullie hun maar te eten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Maar zij zeiden tegen Hem: “Wij hebben hier slechts vijf broden en twee vissen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jezus zei: “Breng ze hier.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hij droeg de mensen op om plaats te nemen op het gras, nam de vijf broden en de twee vissen, keek omhoog naar de hemel, sprak een zegengebed uit, brak de broden in stukken en gaf die aan zijn leerlingen. Zij gaven ze door aan de mensen, ");
INSERT INTO nldgbv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","en ze aten allen totdat ze voldaan waren. De overgebleven brokken werden verzameld, wel twaalf manden vol. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Het aantal mannen die hadden gegeten, dus zonder de vrouwen en kinderen te tellen, bedroeg ongeveer vijfduizend. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Meteen daarna droeg Jezus zijn leerlingen op om in de boot te stappen en voor Hem uit het meer over te steken, terwijl Hij de mensenmassa naar huis stuurde. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nadat Hij de mensenmassa naar huis had gestuurd, ging Hij alleen de berg op om te bidden. Toen het avond werd, was Hij daar alleen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","De boot bevond zich op dat moment reeds op een grote afstand van de kust en werd door de golven heen en weer geslingerd, omdat ze de wind tegen hadden. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tegen het einde van de nacht kwam Hij over het meer naar hen toe gewandeld. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Toen zijn leerlingen Hem over het meer zagen wandelen, werden ze doodsbang en zeiden ze: “Het is een spook!” Ze schreeuwden het uit van angst. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Meteen zei Jezus tegen hen: “Wees gerust, Ik ben het. Wees niet bang.” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Toen vroeg Petrus Hem: “Heer, als U het bent, zeg dan dat ik bij U moet komen over het water!” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jezus zei: “Kom maar!” Petrus stapte uit de boot en wandelde over het water naar Jezus toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Maar toen Petrus merkte hoe hard het waaide, werd hij bang en begon hij te zinken. Hij riep: “Heer, red mij!” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jezus stak meteen zijn hand uit, greep hem vast en zei tegen hem: “Jij kleingelovige, waarom twijfelde je?” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","En toen ze in de boot stapten, ging de wind liggen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","De anderen in de boot vielen voor Jezus op hun knieën en zeiden: “U bent werkelijk de Zoon van God!” ");
INSERT INTO nldgbv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eenmaal overgestoken, kwamen ze bij Gennesaret aan land. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","De mannen van die plaats herkenden Hem en lieten zijn komst in de gehele streek bekendmaken, zodat alle mensen hun zieken kwamen brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Zij smeekten dat die slechts de kwast onderaan zijn mantel zouden mogen aanraken. En iedereen die Hem aanraakte, werd genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","De farizeeën en Schriftgeleerden uit Jeruzalem kwamen Jezus vragen: ");
INSERT INTO nldgbv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Waarom overtreden uw leerlingen de traditie van de voorouders? Ze wassen hun handen niet voor het eten!” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jezus antwoordde: “En waarom overtreden jullie Gods gebod omwille van jullie traditie? ");
INSERT INTO nldgbv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God heeft immers gezegd: ‘Eer je vader en moeder’ en ‘Wie kwaadspreekt van zijn vader of moeder, moet ter dood worden gebracht.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Maar jullie beweren dat wie tegen zijn vader of moeder zegt: ‘Wat ik aan jullie had kunnen geven, heb ik aan God gewijd’, ");
INSERT INTO nldgbv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","zijn vader of moeder niet langer moet eren. Zo verklaren jullie Gods gebod ongeldig omwille van jullie traditie. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hypocrieten! Jesaja had gelijk toen hij het volgende over jullie profeteerde: ");
INSERT INTO nldgbv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dit volk bewijst Mij lippendienst, hun hart is ver van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zij vereren Mij tevergeefs, en ze onderwijzen menselijke voorschriften.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jezus riep de mensen bij zich en zei tegen hen: “Luister en begrijp het volgende: ");
INSERT INTO nldgbv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Het is niet wat de mond binnengaat dat de mens verontreinigt, maar wat uit de mond naar buiten komt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Toen kwamen zijn leerlingen Hem vragen: “Weet U dat de farizeeën uw woorden hebben gehoord en zich eraan ergeren?” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jezus antwoordde: “Iedere plant die niet door mijn Hemelse Vader is geplant, zal worden uitgetrokken. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Laat ze maar. Het zijn blindenbegeleiders die zelf blind zijn. En als een blinde een blinde leidt, vallen ze beiden in een kuil.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus vroeg Jezus: “Wilt U die vergelijking aan ons uitleggen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jezus zei: “Hebben ook jullie nog altijd geen inzicht? ");
INSERT INTO nldgbv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Beseffen jullie niet dat alles wat de mond binnengaat, naar de maag gaat en uiteindelijk weer naar buiten komt? ");
INSERT INTO nldgbv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maar hetgeen door de mond naar buiten gaat, komt uit het hart en verontreinigt de mens. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Uit het hart komen immers slechte gedachten voort, en moord, overspel, seksueel wangedrag, diefstal, leugenachtige verklaringen en godslastering. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dat zijn de zaken die de mens verontreinigen, maar de mens raakt niet verontreinigd door met ongewassen handen te eten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jezus verliet die plaats en trok zich terug in het gebied van Tyrus en Sidon. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Een Kanaänitische vrouw uit die omgeving kwam naar Hem toe en riep: “Heb medelijden met mij, Heer, Zoon van David! Mijn dochter is ernstig bezeten!” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jezus gaf geen antwoord. Zijn leerlingen kwamen bij Hem met het verzoek: “Stuur haar toch weg; ze blijft ons maar naroepen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jezus antwoordde: “Ik ben enkel gezonden naar de verloren schapen van het volk Israël.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Maar zij kwam naar Hem toe, viel op haar knieën en vroeg: “Heer, help mij!” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jezus antwoordde: “Het is niet goed om de kinderen het brood af te nemen en dat aan de hondjes te geven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maar zij zei: “Ja Heer, maar zelfs de hondjes eten van de kruimels die van de tafel van hun eigenaars vallen!” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jezus antwoordde: “Mevrouw, je hebt een groot geloof; moge je wens in vervulling gaan.” Op dat moment was haar dochter genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nadat Jezus van daar was verder getrokken, kwam Hij bij het Meer van Galilea. Hij ging de berg op en zette zich daar neer. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Er kwam een grote mensenmassa naar Hem toe met mensen die verlamd of blind waren, hun arm of been niet goed konden gebruiken of die niet konden spreken, en veel anderen. Ze legden hen aan Jezus' voeten en Hij genas hen. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","De menigte was verbaasd om te zien dat mensen die niet konden spreken begonnen te praten, mensen die hun arm of been niet goed konden gebruiken gezond werden, verlamden begonnen te stappen en blinden konden zien. En ze verheerlijkten de God van Israël. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jezus riep zijn leerlingen bij zich en zei: “Ik heb medelijden met al die mensen, want ze zijn al drie dagen bij Me en nu hebben ze niets te eten. Ik wil hen niet met een lege maag wegsturen, want dan zullen ze onderweg bezwijken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","De leerlingen zeiden tegen Hem: “Waar in dit afgelegen gebied kan voldoende brood worden gevonden om zoveel mensen te eten te geven?” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jezus vroeg hen: “Hoeveel broden hebben jullie?” Ze zeiden: “Zeven, en enkele visjes.” ");
INSERT INTO nldgbv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hij droeg de menigte op om op de grond plaats te nemen, ");
INSERT INTO nldgbv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nam de zeven broden en de visjes, sprak een dankgebed uit, brak ze in stukken, en gaf die aan zijn leerlingen. De leerlingen gaven ze door aan de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ze aten allen tot ze voldaan waren. De overgebleven brokken werden verzameld, wel zeven korven vol. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Het waren ongeveer vierduizend mannen die hadden gegeten, vrouwen en kinderen niet meegeteld. ");
INSERT INTO nldgbv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jezus stuurde de mensen naar huis, stapte in de boot en ging naar het gebied Magadan. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","De farizeeën en de sadduceeën kwamen bij Jezus en stelden Hem op de proef met de vraag om een teken uit de hemel aan hen te tonen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hij antwoordde echter: “Soms zeggen jullie tijdens de avond: het wordt mooi weer, want de lucht is rood. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Of in de ochtend: vandaag krijgen we storm, want de lucht is rood en dreigend. Jullie weten wat het betekent als de lucht er op een bepaalde manier uitziet, maar jullie begrijpen niet waarop de huidige gebeurtenissen wijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jullie soort slechte en overspelige mensen eist een teken, maar er zal hun geen teken worden gegeven, behalve het teken van Jona.” Hij draaide zich om en vertrok. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","De leerlingen van Jezus staken het meer over, maar ze vergaten brood mee te nemen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hij zei tegen hen: “Pas op en wees op je hoede voor de desem van de farizeeën en de sadduceeën.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ze bespraken onder elkaar of Hij dat had gezegd omdat ze geen brood hadden meegenomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jezus merkte het en zei: “Kleingelovigen, waarom zijn jullie met elkaar aan het bespreken dat jullie geen brood hebben? ");
INSERT INTO nldgbv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Begrijpen jullie het nog niet? Weten jullie niet meer van de vijf broden voor de vijfduizend en hoeveel manden vol jullie verzamelden? ");
INSERT INTO nldgbv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Of van de zeven broden voor de vierduizend en hoeveel korven vol jullie toen verzamelden? ");
INSERT INTO nldgbv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hoe bestaat het dat jullie niet beseffen dat Ik het niet over brood had? Pas op voor de desem van de farizeeën en de sadduceeën.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Toen begrepen ze dat ze niet op hun hoede moesten zijn voor de desem in het brood, maar voor het onderwijs van de farizeeën en de sadduceeën. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Toen Jezus in het gebied van Caesarea Filippi kwam, vroeg Hij zijn leerlingen: “Wie zeggen de mensen dat de Mensenzoon is?” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ze zeiden: “Sommigen zeggen: Johannes de Doper, anderen: Elia, nog anderen: Jeremia of een van de profeten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jezus vroeg: “En jullie, wie zeggen jullie dat Ik ben?” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus antwoordde: “U bent de Messias, de Zoon van de levende God.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Toen zei Jezus tegen hem: “Simon Bar-Jona, jij bent gezegend, want dit is jou niet onthuld door mensen van vlees en bloed, maar door mijn Vader in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ik zeg je: jij bent Petrus, de rots. Op deze rots zal Ik mijn kerk bouwen en zelfs de dood zal haar niet kunnen overwinnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ik zal jou de sleutels van Gods rijk geven, en wat jij op aarde bindend verklaart, zal in de hemel bindend zijn en wat jij op aarde ontbonden verklaart zal in de hemel ontbonden zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Toen droeg Hij zijn leerlingen op aan niemand te vertellen dat Hij de Messias was. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vanaf toen begon Jezus aan zijn leerlingen uit te leggen dat Hij naar Jeruzalem moest gaan, dat de oudsten, hoofdpriesters en Schriftgeleerden Hem veel leed zouden aandoen, dat Hij zou worden gedood en dat Hij op de derde dag weer tot leven zou worden gewekt. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrus nam Hem apart en begon Hem te berispen door te zeggen: “Dat nooit, Heer! Dat mag U in geen geval overkomen!” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Maar Jezus draaide zich om en zei tegen Petrus: “Ga weg, uit mijn ogen, jij satan! Je vormt een hinderpaal voor Me, omdat het jou niet om Gods belangen gaat, maar om die van de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Toen zei Jezus tegen zijn leerlingen: “Als iemand met Mij wil meekomen, moet hij zichzelf verloochenen, zijn kruis opnemen en Mij volgen. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wie zijn leven wil redden, zal het verliezen, maar wie zijn leven loslaat voor Mij, zal het vinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wat heeft een mens eraan als hij de hele wereld wint maar zijn leven verliest? Wat zou een mens geven in ruil voor zijn leven? ");
INSERT INTO nldgbv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","De Mensenzoon zal komen, gehuld in de hemelse pracht van zijn Vader en vergezeld door zijn engelen. Dan zal Hij iedereen geven wat hij verdiend heeft met zijn daden. ");
INSERT INTO nldgbv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ik verzeker jullie: sommigen die hier staan, zullen niet sterven voordat zij de Mensenzoon in zijn koninklijke glorie hebben zien komen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Zes dagen later nam Jezus Petrus, Jakobus en diens broer Johannes mee een hoge berg op, waar ze alleen waren. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Daar veranderde Hij voor hun ogen; zijn gezicht straalde als de zon en zijn kleren werden zo wit als het licht. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Plots verschenen Elia en Mozes aan hen; ze waren met Jezus in gesprek. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus onderbrak hen en zei tegen Jezus: “Heer, het is goed dat wij hier zijn. Als U wil, zal ik hier drie hutten bouwen: een voor U, een voor Mozes en een voor Elia.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Terwijl hij nog sprak, kwam er een wolk vol licht boven hen hangen. Vanuit de wolk sprak een stem: “Dit is mijn dierbare Zoon; Ik verheug Mij over Hem. Luister naar Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Toen ze dat hoorden, vielen zijn leerlingen voorover. Ze waren verschrikkelijk bang. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jezus kwam naar hen toe, raakte hen aan en zei: “Sta op; wees niet bang.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Toen ze opkeken, zagen ze enkel nog Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tijdens hun afdaling van de berg beval Jezus hun: “Vertel niemand wat jullie hebben gezien zolang de Mensenzoon nog niet uit de dood is opgewekt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","De leerlingen vroegen Hem: “Waarom zeggen de Schriftgeleerden dat Elia eerst moet komen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hij antwoordde: “Elia komt inderdaad eerst alles in orde maken. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Maar Ik zeg jullie: Elia is reeds gekomen. Ze hebben hem echter niet herkend, maar met hem gedaan wat ze wilden. Op dezelfde wijze zullen ze de Mensenzoon mishandelen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Toen begrepen de leerlingen dat Hij het over Johannes de Doper had. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Toen ze bij de menigte terugkwamen, kwam er iemand naar Jezus toe. Hij knielde voor Hem ");
INSERT INTO nldgbv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","en zei: “Heer, heb medelijden met mijn zoon. Hij krijgt toevallen en valt dan dikwijls in het vuur of het water, zodat hij er ellendig aan toe is. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ik heb hem bij uw leerlingen gebracht, maar zij konden hem niet genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jezus antwoordde: “O, ongelovige en tegendraadse mensen, hoelang zal Ik nog bij jullie zijn? Hoelang zal Ik jullie nog verdragen? Breng hem hier, bij Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jezus sprak de demon bestraffend toe en die ging uit het kind weg; het was onmiddellijk genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Later, toen Jezus alleen was, kwamen zijn leerlingen Hem vragen: “Waarom konden wij die geest niet uitdrijven?” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jezus antwoordde: “Omdat jullie geloof zo klein is! Ik verzeker jullie: Als jullie een geloof hebben ter grootte van een mosterdzaadje en tegen deze berg zeggen: verplaats je van hier naar daar, dan zal hij zich verplaatsen. Niets zal dan onmogelijk voor jullie zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Toen ze bijeenkwamen in Galilea, zei Jezus tegen hen: “Binnenkort zal de Mensenzoon aan de mensen worden uitgeleverd. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zij zullen Hem doden en op de derde dag zal Hij verrijzen.” Ze werden diep bedroefd. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Toen ze Kafarnaüm binnenkwamen, werd Petrus benaderd door de inners van de tempelbelasting, die twee drachma per man bedroeg. Ze vroegen: “Betaalt jullie Leraar geen tempelbelasting?” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus zei: “Toch wel!” Toen hij thuiskwam, vroeg Jezus hem, voordat hij iets kon zeggen: “Wat denk je, Simon, van wie ontvangen de koningen op aarde tolgeld of belasting, van hun eigen kinderen of van vreemdelingen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus zei: “Van de vreemdelingen.” En Jezus zei: “Dan zijn de kinderen dus vrijgesteld. ");
INSERT INTO nldgbv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maar, om te zorgen dat we die mensen niet ergeren: ga naar het meer, werp een hengel uit en neem de eerste vis die bijt. Als je zijn bek opent, zal je een muntstuk van vier drachma vinden. Geef die aan de inners van de tempelbelasting, voor jou en Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Op dat moment kwamen Jezus' leerlingen Hem vragen: “Wie is de belangrijkste in Gods rijk?” ");
INSERT INTO nldgbv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jezus riep een kind, zette het tussen hen in ");
INSERT INTO nldgbv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","en zei: “Ik verzeker jullie, als jullie niet veranderen en als kinderen worden, zullen jullie Gods rijk in geen geval binnengaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wie zo nederig wordt als dit kind, is de belangrijkste in Gods rijk, ");
INSERT INTO nldgbv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","en wie zo'n kind verwelkomt in mijn naam, verwelkomt Mij. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wie een van deze eenvoudige mensen die in Mij geloven tot zonde aanzet, zou beter af zijn als men een zware molensteen om zijn nek zou hangen om hem diep in zee te verdrinken. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wee de wereld, wegens de struikelblokken. Die aansporingen tot zonde moeten er wel komen, maar wee de persoon door wie ze komen. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Als je hand of je voet jou tot zonde aanzet, hak hem dan maar af en gooi hem weg. Je kan beter verminkt of gehandicapt het leven binnengaan dan in het bezit van twee handen of twee voeten in het eeuwig vuur gegooid worden. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","En als je oog jou tot zonde aanzet, verwijder het dan en gooi het weg. Je kan beter met één oog het leven binnengaan dan in het bezit van twee ogen in de brandende hel worden gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Zorg dat je op geen van deze eenvoudige mensen neerkijkt, want Ik zeg jullie dat hun engelen in de hemel vrije toegang hebben tot mijn Vader in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wat denken jullie: stel dat iemand honderd schapen heeft en een ervan dwaalt af. Zou hij dan niet de negenennegentig in de heuvels achterlaten en op zoek gaan naar het afgedwaalde schaap? ");
INSERT INTO nldgbv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ik verzeker jullie, als hij het vindt, verheugt hij zich er meer over dan over de negenennegentig die niet waren afgedwaald. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Net zomin wil jullie Vader in de hemel dat een van deze eenvoudige mensen verloren gaat. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Als je broeder of zuster je iets misdoet, ga dan naar die persoon toe en wijs hem onder vier ogen terecht. Als hij naar je luistert, heb je hem teruggewonnen. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Als de persoon echter niet luistert, neem dan een of twee anderen mee, zodat ‘iedere aanklacht door twee of drie getuigen kan worden bevestigd.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Als hij echter weigert naar hen te luisteren, stel dan je kerkgemeenschap op de hoogte. En als hij zelfs niet naar de kerkgemeenschap luistert, mag je hem behandelen als een ongelovige of een belastinginner. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ik verzeker jullie: wat jullie op aarde bindend verklaren, zal in de hemel bindend zijn en wat jullie op aarde ontbonden verklaren, zal in de hemel ontbonden zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bovendien verzeker Ik jullie: als twee van jullie op aarde overeenkomen om iets te vragen, eender wat, dan zal mijn hemelse Vader hun wens vervullen. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Want waar twee of drie personen samenkomen in mijn naam, daar ben Ik bij hen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Toen kwam Petrus bij Jezus met de vraag: “Heer, hoe vaak zal ik mijn broeder vergeven als hij mij iets misdoet? Tot zevenmaal?” ");
INSERT INTO nldgbv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jezus zei tegen hem: “Ik zeg je: niet tot zevenmaal, maar tot zeven maal zeventigmaal. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Het is met Gods rijk namelijk als met een man, een koning, die afrekening wilde houden met zijn dienaren. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hij was net met de afrekening begonnen, toen iemand bij hem werd gebracht die hem een bedrag schuldig was ter waarde van 60 miljoen daglonen. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","En omdat hij het niet kon betalen, beval zijn heer dat hij, zijn vrouw en kinderen en al zijn bezittingen verkocht moesten worden om de schuld te betalen. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Daarop viel de dienaar voor hem op zijn knieën en smeekte: ‘Heb geduld met mij, ik zal u alles betalen!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","De heer van die dienaar kreeg medelijden, liet hem gaan en schold hem zijn schuld kwijt. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nadat die dienaar was vertrokken, zag hij een van zijn mededienaren, die hem een bedrag ter waarde van honderd daglonen schuldig was. Hij greep hem bij de keel en zei: ‘Betaal wat je me schuldig bent!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","De mededienaar liet zich voor hem neervallen en smeekte: ‘Heb alsjeblieft geduld met mij, ik zal je betalen!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Maar hij weigerde en liet hem in de gevangenis zetten totdat het verschuldigde bedrag zou zijn betaald. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Toen zijn mededienaren zagen wat er gebeurde, vonden ze dat zo verschrikkelijk dat ze naar hun heer gingen om te vertellen wat er allemaal was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Toen riep de koning de dienaar bij zich en hij zei tegen hem: ‘Jij slechte dienaar, ik had je al je schulden kwijtgescholden omdat je mij daarom had gesmeekt. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Had jij dan niet ook mededogen moeten hebben met je mededienaar, zoals ik mededogen had met jou?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Zijn heer was zo kwaad dat hij hem liet gevangenzetten en straffen totdat hij zijn hele schuld zou hebben afbetaald. ");
INSERT INTO nldgbv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mijn hemelse Vader zal hetzelfde met jullie doen als je niet allemaal je broeder of zuster van harte vergeeft.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Toen Jezus uitgesproken was, vertrok Hij uit Galilea en kwam Hij in het gebied van Judea aan de overkant van de Jordaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Een grote mensenmassa volgde Hem en Hij genas de zieken ter plekke. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Er kwamen farizeeën naar Hem toe om Hem op de proef te stellen. Ze vroegen: “Mag een man zijn vrouw wegsturen om eender welke reden?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jezus antwoordde: “Hebben jullie niet gelezen dat de Schepper hen vanaf het begin mannelijk en vrouwelijk heeft gemaakt? ");
INSERT INTO nldgbv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","En dat Hij zei: ‘Daarom zal een man zijn vader en moeder verlaten en zich aan zijn vrouw verbinden, en ze zullen samen een nieuw lichaam vormen’? ");
INSERT INTO nldgbv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ze zijn dus niet langer twee lichamen, maar één. Daarom moet een mens niet scheiden wat God heeft samengevoegd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ze vroegen Hem: “Waarom heeft Mozes dan geboden om een echtscheidingsakte mee te geven als iemand zijn vrouw wegstuurt?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jezus zei tegen hen: “Omdat jullie koppig zijn, gaf Mozes toestemming om je vrouw weg te sturen, maar aanvankelijk was dat niet de bedoeling. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ik zeg jullie: wie zijn vrouw wegstuurt om een andere reden dan seksueel wangedrag en trouwt met een andere vrouw, pleegt echtbreuk.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jezus' leerlingen zeiden tegen Hem: “Als het zo zit tussen man en vrouw, is het beter om niet te trouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Maar Hij zei tegen hen: “Niet iedereen kan deze leer aanvaarden, alleen zij aan wie het gegeven is. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Want er zijn eunuchen die zo zijn vanaf hun geboorte, er zijn eunuchen die door mensen zijn gecastreerd, en er zijn mensen die als een eunuch leven omwille van Gods rijk. Laat wie dit kan aanvaarden, het aanvaarden!” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Toen werden er kinderen bij Jezus gebracht met de bedoeling dat Hij hun de handen zou opleggen en zou bidden. Maar zijn leerlingen berispten de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jezus zei echter: “Laat de kinderen bij Mij komen en houd hen niet tegen, want Gods rijk is bestemd voor wie is zoals zij.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nadat Hij hun de handen had opgelegd, vertrok Hij. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Op dat moment kwam iemand aan Jezus vragen: “Leraar, welke goede daad moet ik doen om het eeuwig leven te krijgen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jezus vroeg hem: “Waarom vraag je Mij over het goede? Er is er maar één die goed is. Maar als je het leven wil binnengaan, houd je dan aan de geboden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hij vroeg Hem: “Welke?” Jezus zei: “Pleeg geen moord, pleeg geen echtbreuk, steel niet, leg geen leugenachtige verklaring af, ");
INSERT INTO nldgbv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","eer je vader en moeder, en heb je naaste lief zoals je jezelf liefhebt.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","De jongeman zei tegen Hem: “Aan al die dingen heb ik me gehouden. Wat ontbreekt mij nog?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jezus antwoordde: “Als je volmaakt wil zijn, ga dan je bezittingen verkopen en geef de opbrengst aan de armen; dan zal je een schat in de hemel hebben. Kom dan terug en volg Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Toen de man dat antwoord hoorde, ging hij aangeslagen weg, want hij had veel bezittingen. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jezus zei tegen zijn leerlingen: “Ik verzeker jullie, voor een rijke is het moeilijk om Gods rijk binnen te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nogmaals, Ik zeg jullie: het is gemakkelijker voor een kameel om door het oog van een naald te kruipen dan voor een rijke om Gods koninkrijk binnen te gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","De leerlingen waren erg ontdaan toen ze dat hoorden. Ze zeiden: “Maar wie kan dan worden gered?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jezus keek hen aan en zei: “Bij de mensen is het onmogelijk, maar bij God is alles mogelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petrus reageerde: “Wij hebben alles achtergelaten om U te volgen. Wat gebeurt er dan met ons?” ");
INSERT INTO nldgbv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jezus zei tegen hem: “Ik verzeker jullie: in de nieuwe wereld, wanneer de Mensenzoon op zijn verheven troon zit, zullen jullie die Mij zijn gevolgd op twaalf tronen zitten en over de twaalf stammen van Israël rechtspreken. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","En ieder die huizen, broers, zussen, vader, moeder, kinderen of akkers heeft opgegeven omwille van mijn naam, zal honderdmaal zoveel ontvangen en deel krijgen aan het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Maar veel eersten zullen de laatsten zijn, en veel laatsten de eersten. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Het is met Gods rijk als met een man, een landeigenaar, die er 's ochtends op uitging om arbeiders in te huren voor het werk in zijn wijngaard. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nadat hij met de arbeiders had afgesproken dat ze ieder een dagloon van een denarie zouden verdienen, stuurde hij hen zijn wijngaard in. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","En toen hij er halverwege de ochtend weer op uitging, zag hij anderen werkloos op het marktplein staan. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hij zei tegen hen: ‘Gaan jullie ook in de wijngaard werken, en ik zal jullie een rechtvaardig loon geven.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dus gingen zij aan de slag. En toen hij rond het middaguur en halverwege de middag nogmaals ging, deed hij hetzelfde. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tegen het einde van de middag ging hij opnieuw en trof hij nog anderen aan die daar stonden. Hij vroeg hen: ‘Waarom hebben jullie hier de hele dag staan nietsdoen?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ze antwoordden: ‘Omdat niemand ons heeft ingehuurd.’ Hij zei tegen hen: ‘Gaan jullie ook maar in de wijngaard werken.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Toen het avond werd, zei de eigenaar van de wijngaard tegen zijn opziener: ‘Roep de arbeiders en geef hun het loon, te beginnen met de laatsten, tot en met de eersten.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Zij die tegen het einde van de dag waren gekomen, ontvingen ieder een denarie. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","En toen de eersten aan de beurt waren, dachten ze dat zij meer zouden krijgen, maar ook zij kregen ieder een denarie. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nadat ze die hadden ontvangen, begonnen ze tegen de landeigenaar te klagen: ");
INSERT INTO nldgbv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Zij die het laatst zijn ingehuurd, hebben slechts een uur gewerkt, en u stelt hen aan ons gelijk, terwijl wij de hele dag in de hitte hebben gezwoegd.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Maar hij antwoordde: ‘Vriend, ik behandel je niet verkeerd. Je had toch een denarie met mij afgesproken? ");
INSERT INTO nldgbv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Neem wat je toekomt en vertrek, maar ik wens deze arbeider die het laatst was ingehuurd hetzelfde bedrag te geven als aan jou. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Of mag ik soms niet met mijn geld doen wat ik wil? Of ben je jaloers geworden omdat ik vrijgevig ben?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zo zullen de laatsten de eersten zijn en de eersten de laatsten.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jezus ging naar Jeruzalem. Onderweg nam Hij zijn twaalf leerlingen apart en zei tegen hen: ");
INSERT INTO nldgbv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Luister, we gaan naar Jeruzalem. Daar zal de Mensenzoon worden uitgeleverd aan de hoofdpriesters en Schriftgeleerden. Zij zullen Hem ter dood veroordelen ");
INSERT INTO nldgbv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","en Hem aan de niet-Joden uitleveren om te worden bespot, gegeseld en gekruisigd, maar op de derde dag zal Hij verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Toen kwam de moeder van de zonen van Zebedeüs naar Jezus toe, samen met haar zonen. Ze knielde om iets van Hem te vragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jezus vroeg haar: “Wat is je wens?” Zij antwoordde: “Zou mijn ene zoon rechts van U mogen zitten in uw koninkrijk, en mijn andere zoon links?” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jezus antwoordde: “Jullie weten niet wat jullie vragen. Kunnen jullie dezelfde beker leegdrinken als Ik?” Ze zeiden: “Dat kunnen we.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jezus zei tegen hen: “Mijn beker zullen jullie wel leegdrinken, maar het is niet aan Mij om te bepalen wie rechts of links van Mij mag zitten. Die plaatsen zijn voor wie mijn Vader ze heeft bestemd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Toen de tien andere leerlingen van Jezus hiervan hoorden, waren ze kwaad op de twee broers. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jezus riep hen bij zich en zei: “Jullie weten dat het bij de andere volken zo is dat hun leiders de baas over hen spelen en hun heersers hun gezag over hen laten gelden. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bij jullie is dat niet zo. Integendeel, wie onder jullie belangrijk wil worden, moet jullie dienaar zijn ");
INSERT INTO nldgbv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","en wie onder jullie vooraanstaand wil zijn, moet jullie slaaf zijn, ");
INSERT INTO nldgbv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","net zoals de Mensenzoon niet is gekomen om te worden gediend, maar om te dienen en zijn leven te geven als losgeld voor velen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Toen ze Jericho verlieten, werd Jezus gevolgd door een grote menigte. ");
INSERT INTO nldgbv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Er zaten twee blinde mensen aan de kant van de weg. Omdat ze hadden gehoord dat Jezus voorbijkwam, riepen ze: “Heb medelijden met ons, Heer, Zoon van David!” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","De menigte snauwde hen toe dat ze moesten zwijgen. Maar ze riepen nog luider: “Heb medelijden met ons, Heer, Zoon van David!” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jezus hield halt, riep hen bij zich en vroeg: “Wat willen jullie dat Ik voor jullie doe?” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ze antwoordden: “Heer, we willen graag dat onze ogen worden genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jezus kreeg medelijden met hen en raakte hun ogen aan. Meteen konden ze weer zien en volgden ze Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Toen ze Jeruzalem naderden en bij Betfagé kwamen, bij de Olijfberg, stuurde Jezus twee van zijn leerlingen vooruit. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Hij zei tegen hen: “Ga het dorp in dat voor jullie ligt. Dan zullen jullie meteen een vastgebonden ezelin zien, met een veulen. Maak ze los en breng ze hier. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Als iemand bezwaar maakt, zeg dan: ‘De Heer heeft ze nodig; Hij zal ze meteen terugsturen.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zo gebeurde wat de profeet had voorspeld: ");
INSERT INTO nldgbv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Vertel de dochter van Sion: Let op, je koning komt naar je toe, nederig en rijdend op een ezel, op het veulen van een ezelin.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","De leerlingen vertrokken en deden wat Jezus hun had opgedragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Toen ze de ezelin met het veulen hadden gebracht en hun mantels erop hadden gelegd, ging Jezus daarop zitten. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Een groot aantal mensen legden hun mantels op de weg, anderen sneden takken van de bomen en spreidden die uit op de weg. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","De vele mensen die voor en achter Jezus wandelden, riepen: “Hosanna voor de zoon van David! Gezegend is Hij die komt in de naam van de Heer! Hosanna aan de Allerhoogste!” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Toen Jezus Jeruzalem binnenging, raakte de hele stad in opschudding over de vraag: “Wie is dit?” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","De mensen bij Jezus zeiden: “Dit is Jezus, de profeet uit Nazaret in Galilea.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jezus ging het tempelterrein op, joeg iedereen weg die daar aan het kopen of verkopen was, gooide de tafels van de geldwisselaars en de zitbanken van de duivenverkopers omver ");
INSERT INTO nldgbv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","en zei tegen hen: “In de Schriften staat: ‘Mijn huis zal een gebedshuis worden genoemd’, maar jullie maken er een rovershol van.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Op het tempelterrein kwamen er mensen naar Hem toe die blind of verlamd waren en Hij genas hen. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Maar toen de hoofdpriesters en de Schriftgeleerden de verbazingwekkende dingen zagen die Hij deed en toen ze hoorden dat de kinderen op het tempelterrein uitriepen: “Hosanna voor de zoon van David!”, waren ze verontwaardigd. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ze vroegen Jezus: “Hoort U wat ze roepen?” Jezus zei tegen hen: “Jazeker. Hebben jullie nooit gelezen: ‘U heeft zich laten bejubelen door kleine kinderen en zuigelingen’?” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hij liet hen achter en ging de stad uit, naar Betanië. Daar overnachtte Hij. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'s Morgens vroeg, toen ze naar Jeruzalem teruggingen, kreeg Jezus honger. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hij zag naast de weg een vijgenboom, ging ernaartoe en stelde vast dat er niets anders aan zat dan bladeren. Hij zei tegen de boom: “Van jou mogen nooit meer vruchten worden geplukt!” Onmiddellijk verdorde de boom. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zijn leerlingen zagen het en vroegen verwonderd: “Hoe kan het dat die vijgenboom onmiddellijk is verdord?” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jezus zei tegen hen: “Ik verzeker jullie, als jullie geloof hebben en niet twijfelen, zullen jullie niet alleen doen wat Ik met de vijgenboom heb gedaan, maar zelfs als jullie dan tegen deze berg zeggen: kom van je plaats en stort jezelf in zee, zal het gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","En alles wat jullie vol vertrouwen vragen in het gebed, zullen jullie ontvangen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jezus ging het tempelterrein op. Terwijl Hij aan het onderwijzen was, kwamen de hoofdpriesters en de volksoudsten naar Hem toe. Ze vroegen: “Op grond van welke bevoegdheid doet U deze dingen? En wie heeft U die bevoegdheid gegeven?” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jezus antwoordde: “Ik zal jullie ook één vraag stellen, en als jullie Mij antwoord geven, zal Ik jullie vertellen op grond van welke bevoegdheid Ik deze dingen doe. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","De doop van Johannes, vanwaar kwam die? Van God of van de mensen?” Ze overlegden met elkaar: “Als we zeggen: van God, zal Hij zeggen: Waarom geloven jullie hem dan niet? ");
INSERT INTO nldgbv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Maar als we zeggen: van de mensen ... We zijn bang voor de menigte, want iedereen beschouwt Johannes als een profeet.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Daarom antwoordden ze: “Wij weten het niet.” Toen zei Hij tegen hen: “Dan vertel Ik jullie ook niet op grond van welke bevoegdheid Ik deze dingen doe. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wat denken jullie? Een man had twee zonen. Hij ging naar de eerste toe en zei: ‘Mijn zoon, ga vandaag in de wijngaard werken.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hij antwoordde: ‘Ik wil niet.’ Maar later kreeg hij wroeging en ging hij toch. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Toen ging de vader naar de andere zoon en zei hetzelfde. Die zoon antwoordde: ‘Ja, vader’, maar hij ging niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wie van de twee deed wat de vader wilde?” Ze zeiden: “De eerste.” Jezus zei tegen hen: “Ik verzeker jullie dat de belastinginners en de prostituees eerder dan jullie Gods koninkrijk zullen binnengaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Want Johannes kwam naar jullie toe en toonde jullie de juiste weg, maar jullie geloofden hem niet, terwijl de belastinginners en prostituees hem wel geloofden. En zelfs toen jullie dat zagen, kwamen jullie niet tot inkeer en geloofden jullie hem niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Luister ook naar deze parabel: Er was iemand, een landeigenaar, die een wijngaard aanplantte, een omheining plaatste, een perskuil groef, een wachttoren bouwde, de wijngaard aan wijnbouwers verhuurde en op reis ging. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Toen de oogsttijd was aangebroken, stuurde hij zijn knechten naar de wijnbouwers om zijn opbrengst op te halen. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Maar de wijnbouwers grepen zijn knechten; ze sloegen de ene in elkaar, doodden een andere en stenigden nog een andere. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Vervolgens stuurde hij andere knechten, meer dan de eerste keer, en die behandelden ze op dezelfde wijze. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Uiteindelijk stuurde hij zijn zoon naar hen toe. Hij zei: ‘Mijn zoon zullen ze wel respecteren.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Maar toen de wijnbouwers de zoon zagen, zeiden ze tegen elkaar: ‘Dit is de erfgenaam. Kom, laten we hem doden en beslag leggen op zijn erfenis.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ze grepen hem, gooiden hem de wijngaard uit en doodden hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wat zou de eigenaar van de wijngaard dus met die wijnbouwers doen, wanneer hij komt?” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ze zeiden tegen Hem: “Hij zal die slechte mensen ombrengen en de wijngaard aan andere wijnbouwers verhuren. En die zullen hem steeds op tijd de opbrengst uitbetalen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jezus zei tegen hen: “Hebben jullie nooit het volgende in de Schriften gelezen: ‘De steen die de bouwers hebben afgekeurd, is de hoeksteen geworden; de Heer heeft hiervoor gezorgd, het is verbazingwekkend om te zien’? ");
INSERT INTO nldgbv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Daarom vertel Ik jullie: Gods koninkrijk zal van jullie worden afgenomen en aan een volk worden gegeven dat de vruchten ervan oplevert. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wie over deze steen valt, raakt verbrijzeld, en degene op wie hij valt, wordt verpletterd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Toen de hoofdpriesters en farizeeën Jezus' parabels hoorden, begrepen ze dat Hij over hen sprak. ");
INSERT INTO nldgbv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ze wilden Jezus oppakken, maar waren bang van het volk, want dat beschouwde Hem als een profeet. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jezus sprak hen nogmaals toe in parabels. Hij vertelde: ");
INSERT INTO nldgbv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Het is met Gods rijk als met een man, een koning, die een huwelijksfeest gaf voor zijn zoon. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hij stuurde zijn dienaren eropuit om de genodigden bijeen te roepen voor het huwelijksfeest, maar die wilden niet komen. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Toen stuurde hij andere dienaren, aan wie hij opdroeg: ‘Zeg tegen de genodigden: ik heb mijn feestmaal klaargemaakt, mijn ossen en mestvee zijn geslacht en alles is gereed. Kom naar het huwelijksfeest.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Maar de genodigden negeerden hen en vertrokken, sommigen naar hun akker, anderen naar hun bedrijf, ");
INSERT INTO nldgbv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","terwijl de overigen zijn dienaren grepen, mishandelden en doodden. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","De koning werd kwaad en stuurde zijn troepen om de moordenaars te doden en hun stad in brand te steken. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Toen zei hij tegen zijn dienaren: ‘Het huwelijksfeest is gereed, maar de genodigden zijn het feest niet waard. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ga dus naar de plaatsen op straat waar veel volk is en nodig iedereen die jullie daar aantreffen uit voor het huwelijksfeest.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","De dienaren gingen op pad en brachten iedereen bijeen die ze konden vinden, zowel slechte als goede mensen, en zo werd de feestzaal gevuld met gasten. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Toen de koning binnenkwam om de gasten te begroeten, zag hij daar iemand die geen feestkledij had aangetrokken. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hij zei tegen hem: ‘Vriend, hoe ben jij hier binnengekomen zonder feestkledij?’ De man had geen antwoord. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Toen zei de koning tegen de dienaren: ‘Boei hem aan zijn handen en voeten en gooi hem buiten, de uiterste duisternis in; daar zal worden geweend en met de tanden geknarst.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Want velen zijn geroepen, maar weinigen zijn uitverkoren.” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Toen vertrokken de farizeeën om met elkaar te overleggen hoe ze Hem in zijn eigen woorden zouden kunnen vangen. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ze stuurden hun leerlingen met de aanhangers van Herodes naar Hem toe met de vraag: “Leraar, wij weten dat U oprecht bent en naar waarheid onderwijst hoe men Gods weg moet bewandelen. U laat zich door niemand beïnvloeden en praat niemand naar de mond. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vertel ons daarom: vindt U dat het is toegestaan om de keizerlijke belasting te betalen, of niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Maar Jezus was zich bewust van hun slechte bedoelingen en zei: “Hypocrieten, waarom stellen jullie Mij op de proef? ");
INSERT INTO nldgbv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Toon Mij de munt die voor deze belasting wordt gebruikt.” Ze brachten Hem een denarie. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Toen vroeg Hij hun: “Wie staat hierop afgebeeld? En welke naam staat erop?” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ze antwoordden: “Van de keizer.” Jezus zei tegen hen: “Geef dan aan de keizer wat van de keizer is, en aan God wat van God is.” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Toen ze dat hoorden, verwonderden ze zich. Ze lieten Hem met rust en vertrokken. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dezelfde dag kwamen er sadduceeën naar Jezus toe. (Sadduceeën beweren dat er geen verrijzenis is.) ");
INSERT INTO nldgbv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ze vroegen: “Leraar, Mozes heeft gezegd dat als iemand sterft zonder kinderen na te laten, zijn broer met zijn weduwe moet trouwen en zo moet zorgen voor nakomelingen voor zijn gestorven broer. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Er waren bij ons zeven broers, en de eerste was getrouwd. Toen hij stierf zonder kinderen na te laten, trouwde zijn broer met de weduwe. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zo verging het ook de tweede en de derde broer, tot en met de zevende. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Als laatste van allen stierf de vrouw. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Van wie van de zeven wordt zij de echtgenote bij de verrijzenis? Ze zijn alle zeven met haar getrouwd geweest!” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jezus antwoordde: “Jullie zitten op een dwaalspoor, want jullie begrijpen noch de Schriften, noch Gods macht. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bij de verrijzenis trouwen de mensen niet, maar zijn ze als engelen in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","En wat de verrijzenis van de doden betreft, hebben jullie niet gelezen wat God tegen jullie heeft gezegd? ");
INSERT INTO nldgbv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hij zei: ‘Ik ben de God van Abraham, de God van Isaak en de God van Jakob.’ Hij is niet de God van doden, maar van levenden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Toen de mensen dat hoorden, waren ze diep onder de indruk van Jezus' onderwijs. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","De farizeeën hoorden dat Jezus de sadduceeën tot zwijgen had gebracht. Daarom gingen ze gezamenlijk naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Een van hen, een Wetgeleerde, stelde Hem op de proef met de vraag: ");
INSERT INTO nldgbv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Leraar, welk gebod in de Wet is het belangrijkst?” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jezus antwoordde: “Heb de Heer, je God, lief met heel je hart, met heel je ziel en met heel je verstand. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dit is het allerbelangrijkste gebod. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","En er is een tweede, even belangrijk gebod: Heb je naaste lief zoals je jezelf liefhebt. ");
INSERT INTO nldgbv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","De hele Wet en de Profeten zijn vervat in deze twee geboden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Terwijl de farizeeën om Hem heen stonden, vroeg Jezus hun: ");
INSERT INTO nldgbv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wat denken jullie over de Messias? Van wie is Hij de Zoon?” Ze antwoordden: “Van David.” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jezus zei tegen hen: “Hoe kan het dan dat David, aangestuurd door de Heilige Geest, Hem ‘Heer’ noemde? Hij zei immers: ");
INSERT INTO nldgbv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘De Heer zei tegen mijn Heer: neem plaats aan mijn rechterzijde, totdat Ik je vijanden aan Je heb onderworpen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dus als David Hem ‘Heer’ noemt, hoe kan Hij dan zijn zoon zijn?” ");
INSERT INTO nldgbv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niemand was in staat om Jezus een antwoord te geven en voortaan durfde niemand Hem nog vragen te stellen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Daarna zei Jezus tegen de mensenmassa en tegen zijn leerlingen: ");
INSERT INTO nldgbv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Het zijn de Schriftgeleerden en de farizeeën die de Wet van Mozes onderwijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Doe daarom alles wat ze zeggen dat jullie moeten doen en houd je daaraan. Maar gedraag je niet zoals zij, want ze leggen het wel uit, maar doen het zelf niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ze bundelen zware, moeilijk te dragen lasten en leggen die de mensen op, maar steken zelf geen vinger uit om die lasten te helpen dragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Alles wat ze doen, doen ze om door de mensen gezien te worden. Ze maken hun gebedsriemen breed en de rituele kwasten aan hun kleren lang, ");
INSERT INTO nldgbv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ze zijn gesteld op de ereplaatsen bij feestmalen en de beste plaatsen in synagogen, ");
INSERT INTO nldgbv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","en ze worden graag op de marktpleinen met respect begroet en door de mensen aangesproken met ‘rabbi’. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Maar jullie moeten je niet met ‘rabbi’ laten aanspreken. Er is er immers maar Eén die jullie Leraar is en jullie zijn allen broeders en zusters van elkaar. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Noem ook niemand op aarde jullie ‘vader’, want er is er maar Eén die jullie hemelse Vader is. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Laat je ook geen ‘leermeester’ noemen, want er is er maar Eén die jullie Leermeester is: de Messias. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","De belangrijkste van jullie zal jullie dienaar zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wie zichzelf een eervolle plaats toebedeelt, zal een geringe plaats krijgen, en wie zichzelf een geringe plaats toebedeelt, zal een eervolle plaats krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie sluiten mensen buiten van Gods rijk en gaan het zelf niet binnen. En wie het wel binnengaat, proberen jullie tegen te houden. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie reizen over zee en land om één bekeerling te maken, en wanneer hij dat geworden is, maken jullie er iemand van die tweemaal zozeer de hel verdient als jullie. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Wee jullie blinde leraars, jullie die zeggen: ‘Wie zweert bij de tempel, is niet aan zijn eed gebonden, maar wie zweert bij het goud van de tempel, is dat wel.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Blinde dwazen! Wat is belangrijker, het goud of de tempel die het goud heilig maakt? ");
INSERT INTO nldgbv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jullie zeggen ook: ‘Wie zweert bij het altaar is niet aan zijn eed gebonden, maar wie zweert bij het offer op het altaar, is dat wel.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Blind zijn jullie! Wat is belangrijker, het offer of het altaar dat het offer heilig maakt? ");
INSERT INTO nldgbv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dus wie zweert bij het altaar, zweert daarbij en bij alles wat erop ligt. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","En wie heeft gezworen bij de tempel, zweert daarbij en bij Hem die er verblijft. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","En wie zweert bij de hemel, zweert bij Gods troon en bij Hem die erop zit. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie geven God een tiende deel van munt, dille en komijn, maar jullie negeren wat belangrijker is in de Wet: gerechtigheid, mededogen en geloof. Dat laatste moeten jullie nastreven zonder het eerste te verwaarlozen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Blinde leiders! Een mug wordt door jullie uit de drank gezeefd, maar een kameel slikken jullie door! ");
INSERT INTO nldgbv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie reinigen wel de buitenkant van de beker en de schotel, maar jullie vullen die met zelfzucht en gebrek aan zelfbeheersing. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Blinde farizeeër, zorg eerst dat de beker vanbinnen rein is; dan wordt hij ook vanbuiten rein. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie lijken op witgekalkte graven, die er vanbuiten mooi uitzien, maar vanbinnen zijn gevuld met doodsbeenderen en alles wat onrein is. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","In de ogen van de mensen zien jullie er vanbuiten rechtvaardig uit, maar vanbinnen zitten jullie vol hypocrisie en slechtheid. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wee jullie, Schriftgeleerden en farizeeën! Hypocrieten! Jullie bouwen graven voor de profeten en versieren de grafmonumenten van de rechtvaardigen, ");
INSERT INTO nldgbv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","en jullie zeggen: ‘Als wij in de tijd van onze voorouders hadden geleefd, dan zouden we niet met hen hebben meegewerkt aan het vergieten van het bloed van de profeten.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Maar zo bevestigen jullie dat jullie de afstammelingen zijn van de moordenaars van de profeten! ");
INSERT INTO nldgbv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jullie zijn aan het voltooien wat jullie voorouders zijn begonnen! ");
INSERT INTO nldgbv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Slangen, addergebroed, hoe denken jullie het Oordeel in de hel te ontlopen? ");
INSERT INTO nldgbv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Het is daarom dat Ik profeten, wijzen en Schriftgeleerden naar jullie toe stuur. Jullie zullen sommigen van hen doden en kruisigen, terwijl jullie anderen van hen zullen geselen in jullie synagogen en van de ene stad naar de andere jagen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Daardoor nemen jullie zelf alle schuld op je voor het bloed van rechtvaardige mensen dat op aarde is gevloeid, van het bloed van de rechtvaardige Abel tot het bloed van Zacharia de zoon van Berechja, die jullie hebben vermoord tussen de tempel en het altaar. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ik verzeker jullie, dit alles zal jullie overkomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruzalem, Jeruzalem, jij die de profeten doodt en stenigt wie naar jou toe gestuurd zijn! Ik heb zo vaak je inwoners willen bijeenbrengen, zoals een hen haar kuikens onder haar vleugels bijeenbrengt. Maar jullie wilden dat niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jullie tempel zal binnenkort verlaten achterblijven. ");
INSERT INTO nldgbv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ik zeg jullie: jullie zullen Mij niet meer zien totdat jullie uitroepen: ‘Gezegend is Hij die komt in de naam van de Heer!’” ");
INSERT INTO nldgbv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Toen Jezus het tempelterrein verliet, kwamen zijn leerlingen Hem onderweg tegemoet om Hem op de tempelgebouwen te wijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jezus reageerde: “Zien jullie dit alles? Ik verzeker jullie, hier zal geen enkele steen op de andere worden gelaten, het zal allemaal worden verwoest.” ");
INSERT INTO nldgbv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Toen Jezus op de Olijfberg was gaan zitten, kwamen zijn leerlingen Hem vragen terwijl ze met Hem alleen waren: “Kunt U ons vertellen wanneer dat zal zijn en wat het teken zal zijn van uw komst en van het einde van de wereld?” ");
INSERT INTO nldgbv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jezus antwoordde: “Pas op dat niemand jullie misleidt, ");
INSERT INTO nldgbv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","want er zullen veel mensen komen die zich mijn naam toe-eigenen en zich voor de Messias uitgeven; zij zullen veel mensen misleiden. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jullie zullen horen van oorlogen en oorlogsdreiging. Maak je dan niet ongerust; die dingen moeten gebeuren, maar het einde is dan nog niet aangebroken. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Volken en koninkrijken zullen namelijk tegen elkaar oorlog voeren, en op allerlei plaatsen zullen er hongersnoden en aardbevingen plaatsvinden. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dit alles is het begin van de weeën. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dan zullen jullie worden uitgeleverd om te worden gemarteld en men zal jullie doden. Jullie zullen door alle volken worden gehaat omwille van mijn naam. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dan zullen veel mensen het geloof in Mij opgeven en elkaar verraden en haten. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Er zullen veel valse profeten opstaan en ze zullen veel mensen misleiden. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","En omdat de wetteloosheid dan toeneemt, zal de liefde van veel mensen bekoelen. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Maar wie standhoudt tot het einde, zal worden gered. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dit evangelie van Gods koninkrijk zal in de hele wereld worden verkondigd als een getuigenis voor alle volken en dan komt het einde. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dus wanneer jullie de verwoestende gruwel waarover de profeet Daniël sprak, in het heiligdom zien staan – lezer, begrijp wat dit betekent! – ");
INSERT INTO nldgbv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","dan moeten de mensen in Judea de bergen invluchten. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wie zich op het dakterras bevindt, moet niet naar beneden gaan om iets op te halen uit zijn huis. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","En wie zich op het land bevindt, moet niet terugkeren om zijn mantel op te halen. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Het zal verschrikkelijk zijn voor vrouwen die in die periode zwanger zijn of borstvoeding geven. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bid dat jullie vlucht niet plaatsvindt in de winter of op de sabbat, ");
INSERT INTO nldgbv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","want er zal dan groot leed zijn zoals er nog nooit is geweest, vanaf het begin van de wereld tot nu, en zoals er daarna nooit meer zal zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Als die periode niet was ingekort, zou geen mens het overleven. In het belang van de uitverkorenen zal die periode echter worden ingekort. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Als iemand dan tegen jullie zegt: ‘Kijk, hier is de Messias!’, of: ‘Kijk, hier!’, geloof het dan niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Want er zullen valse messiassen en valse profeten opstaan, die tekenen en wonderen doen om zo mogelijk zelfs de uitverkorenen te misleiden. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ik heb jullie gewaarschuwd. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Dus als men tegen jullie zegt: ‘Hij is daar in de wildernis’, ga er dan niet heen. Of: ‘Hij verstopt zich daarbinnen’, geloof het dan niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Want zoals de bliksem uit het oosten komt en helemaal in het westen wordt waargenomen, zo zal het zijn met de komst van de Mensenzoon. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Waar het kadaver ligt, daar verzamelen zich de gieren. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Onmiddellijk na het leed van die periode zal de zon verduisteren en de maan geen licht geven, zullen de sterren uit de lucht vallen en de hemellichamen uit koers raken. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dan zal het teken van de Mensenzoon in de hemel verschijnen. Dan zullen alle volken op aarde rouwen en ze zullen de Mensenzoon op de wolken zien komen, met macht en grote hemelse pracht. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hij zal zijn engelen eropuit sturen met luid trompetgeschal en zij zullen zijn uitverkorenen samenbrengen vanuit de vier windstreken, uit alle uithoeken van de wereld. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Leer daarom van de volgende vergelijking met de vijgenboom: zodra zijn takken uitlopen en de bladeren verschijnen, weet je dat het bijna zomer is. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Op dezelfde manier kunnen jullie, wanneer je dit alles ziet gebeuren, weten dat het voor de deur staat. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ik verzeker jullie, dit volk zal niet vergaan voordat dit alles gebeurt. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","De hemel en de aarde zullen vergaan, maar mijn woorden zullen nooit vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Maar op welke dag en welk tijdstip dat zal gebeuren weet niemand; zelfs de engelen in de hemel niet, ook de Zoon niet, maar alleen de Vader. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Met de komst van de Mensenzoon zal het zijn als in de tijd van Noach. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","In de tijd voor de zondvloed gingen de mensen door met eten, drinken en trouwen tot de dag dat Noach de ark binnenging. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ze beseften niet wat er ging gebeuren, totdat de zondvloed kwam en iedereen wegvaagde. Zo zal het ook zijn met de komst van de Mensenzoon. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dan zullen twee mannen op het veld bezig zijn, van wie de ene wordt weggenomen en de andere achtergelaten. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Van twee vrouwen die dan bij de molen aan het malen zijn, wordt de ene weggenomen en de andere achtergelaten. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wees dus waakzaam, want jullie weten niet op welke dag je Heer komt. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dit moeten jullie weten: als de huiseigenaar zou weten in welk deel van de nacht de dief komt, zou hij waakzaam zijn en niet in zijn huis laten inbreken. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ook jullie moeten dus voorbereid zijn, want de Mensenzoon komt op een onverwacht tijdstip. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wie is de trouwe en verstandige dienaar die door zijn heer over zijn huispersoneel is aangesteld om hun op tijd te eten te geven? ");
INSERT INTO nldgbv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","De dienaar die door zijn heer bij diens thuiskomst aan het werk wordt aangetroffen, is gezegend. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ik verzeker jullie dat hij hem over al zijn bezittingen zal aanstellen. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Maar als de dienaar slecht is en denkt: ‘Mijn heer komt nog lang niet’, ");
INSERT INTO nldgbv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","en hij begint zijn mededienaren te mishandelen en met de dronkenlappen te eten en drinken, ");
INSERT INTO nldgbv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dan zal de heer van die dienaar komen op een dag dat hij het niet verwacht en op een tijdstip dat hij niet kent. ");
INSERT INTO nldgbv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","De heer zal hem zeer zwaar straffen en hij zal terechtkomen bij de hypocrieten, waar zal worden geweend en met de tanden geknarst. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Dan zal het met Gods rijk zijn als met tien bruidsmeisjes die met hun olielamp naar de plaats gingen waar ze de bruidegom zouden opwachten. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vijf van hen waren dwaas, vijf waren verstandig. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","De dwaze meisjes namen wel hun lamp maar geen olie mee, ");
INSERT INTO nldgbv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","maar de verstandige meisjes namen naast hun lamp ook een kruikje olie mee. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Toen de bruidegom uitbleef, werden alle meisjes slaperig en ze vielen in slaap. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Midden in de nacht werd er geroepen: ‘Daar is de bruidegom! Ga hem tegemoet!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Toen stonden al die meisjes op en maakten ze hun lamp in orde. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","De dwaze meisjes zeiden tegen de verstandige: ‘Geef ons wat van jullie olie, want onze lampen zijn aan het uitdoven.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","De verstandige bruidsmeisjes antwoordden: ‘Dat kan niet, want er is niet voldoende olie voor ons en jullie. Ga maar naar de handelaars om olie voor jezelf te kopen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Maar toen ze weggingen om olie te kopen, arriveerde de bruidegom. De meisjes die voorbereid waren, gingen met hem mee naar het feest. Toen werd de deur gesloten. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Later kwamen ook de andere meisjes. Ze riepen: ‘Meneer, meneer, doe voor ons open!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","De bruidegom antwoordde: ‘Ik verzeker jullie, ik ken jullie niet.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wees dus waakzaam, want jullie kennen de dag of het tijdstip niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Het is als met iemand die op reis ging en zijn dienaren bij zich riep om de zorg voor zijn bezittingen aan hen over te dragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aan de één gaf hij vijf zakken goud, aan de ander twee, aan een derde één, afhankelijk van hun bekwaamheid, en hij ging op reis. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","De dienaar die vijf zakken goud had ontvangen, ging er onmiddellijk mee aan de slag en verdiende er vijf bij. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Zo ging het ook met de dienaar die er twee had: hij verdiende er twee bij. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Maar de dienaar die er één had ontvangen, ging naar buiten en groef een gat in de grond om het geld van zijn heer te verbergen. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na lange tijd kwam de heer van die dienaren terug en moesten ze verantwoording aan hem afleggen. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","De dienaar die vijf zakken goud had ontvangen, kwam bij zijn heer, bracht hem er nog vijf en zei: ‘Heer, u had mij vijf zakken goud gegeven, ik heb er vijf bijverdiend.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Zijn heer zei tegen hem: ‘Goed gedaan, goede en trouwe dienaar! Je bent betrouwbaar geweest met weinig, ik zal je aanstellen over veel. Je mag deelnemen aan het feest van je heer.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","De dienaar die twee zakken goud had ontvangen, kwam ook bij zijn heer, en zei: ‘Heer, u had mij twee zakken goud gegeven. Kijk, ik heb er twee bijverdiend.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Zijn heer zei tegen hem: ‘Goed gedaan, goede en trouwe dienaar! Je bent betrouwbaar geweest met weinig, ik zal je aanstellen over veel. Je mag deelnemen aan het feest van je heer.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Toen kwam ook de dienaar die één zak goud had ontvangen bij zijn heer en zei: ‘Heer, ik wist dat u een streng mens bent, die oogst waar hij niet heeft gezaaid en verzamelt waar hij niet heeft geplant. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ik was bang en heb uw zak goud verborgen in een gat in de grond. Alstublieft, dit is van u.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Zijn heer zei tegen hem: ‘Jij slechte, luie dienaar! Je wist dus dat ik oogst waar ik niet heb gezaaid en verzamel waar ik niet heb geplant? ");
INSERT INTO nldgbv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Dan had je mijn geld bij de bankiers in bewaring moeten geven, zodat ik na mijn terugkomst mijn geld had kunnen terugkrijgen met rente. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Neem hem dus die zak goud af en geef ze aan degene die de tien zakken heeft. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Want aan ieder die heeft, zal nog meer worden gegeven, zodat hij overvloed zal hebben. Maar van wie niets heeft, zal zelfs hetgeen hij heeft worden afgenomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","En gooi de nutteloze dienaar buiten, de uiterste duisternis in; daar zal worden geweend en met de tanden geknarst.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wanneer de Mensenzoon komt, gehuld in zijn hemelse pracht en vergezeld van alle engelen, zal Hij plaatsnemen op zijn koninklijke troon. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Alle volken zullen vóór Hem worden bijeengebracht en Hij zal de mensen van elkaar scheiden zoals de herder de schapen en de geiten van elkaar scheidt: ");
INSERT INTO nldgbv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hij zal de ‘schapen’ aan zijn rechterzijde opstellen en de ‘geiten’ aan zijn linkerzijde. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dan zal de Koning tegen de mensen aan zijn rechterzijde zeggen: ‘Kom maar! Jullie zijn gezegend door mijn Vader, jullie krijgen deel aan het koninkrijk dat vanaf de schepping van de wereld voor jullie is gereedgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Want Ik had honger en jullie gaven Mij te eten, Ik had dorst en jullie gaven Mij te drinken, Ik was een vreemde en jullie verwelkomden Mij, ");
INSERT INTO nldgbv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ik was naakt en jullie gaven Mij kleren, Ik was ziek en jullie verzorgden Mij, Ik zat gevangen en jullie kwamen Mij bezoeken.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dan zullen de rechtvaardige mensen Hem vragen: ‘Heer, wanneer hebben wij U hongerig gezien en gaven wij U te eten, of dorstig en gaven wij U te drinken? ");
INSERT INTO nldgbv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","En wanneer zagen wij U als vreemdeling en verwelkomden wij U, of naakt en gaven wij U kleren? ");
INSERT INTO nldgbv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wanneer zagen wij dat U ziek was of gevangen zat en kwamen wij U bezoeken?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dan zal de Koning tegen hen zeggen: ‘Ik verzeker jullie, voor zover jullie dit hebben gedaan voor een van de geringsten van mijn broeders en zusters, hebben jullie het voor Mij gedaan.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Dan zal Hij tegen de mensen aan zijn linkerzijde zeggen: ‘Ga weg, bij Mij vandaan, jullie vervloekten, naar het eeuwig vuur dat is gereedgemaakt voor de duivel en zijn engelen! ");
INSERT INTO nldgbv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Want Ik had honger en jullie gaven Mij niet te eten, Ik had dorst en jullie gaven Mij niet te drinken, ");
INSERT INTO nldgbv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ik was een vreemde en jullie verwelkomden Mij niet, naakt en jullie gaven Mij geen kleren, ziek en gevangen en jullie kwamen Mij niet bezoeken!’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dan zullen ook zij Hem vragen: ‘Heer, wanneer hebben wij U hongerig gezien, of dorstig, of als vreemdeling, of naakt, of ziek, of gevangen, en hebben wij U niet geholpen?’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dan zal Hij tegen hen zeggen: ‘Ik verzeker jullie, voor zover jullie dit niet hebben gedaan voor een van deze geringsten, hebben jullie het ook niet voor Mij gedaan.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","En dan gaan zij de eeuwige straf tegemoet, maar de rechtvaardigen gaan naar het eeuwig leven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nadat Jezus al deze dingen had gezegd, zei Hij tegen zijn leerlingen: ");
INSERT INTO nldgbv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Zoals jullie weten, is het over twee dagen Pesach. Dan zal de Mensenzoon worden uitgeleverd om te worden gekruisigd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Toen kwamen de hoofdpriesters en de volksoudsten bijeen in de ambtswoning van hogepriester Kajafas. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ze spanden samen om Jezus met een list op te pakken en te doden. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Maar niet tijdens het feest,” zeiden ze, “anders komt het volk in opstand.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Toen Jezus in Betanië was, in het huis van Simon de Melaatse, ");
INSERT INTO nldgbv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kwam er een vrouw naar Hem toe met een albasten flesje dure olie, die ze over zijn hoofd uitgoot terwijl Hij aan de maaltijd deelnam. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zijn leerlingen zagen het en zeiden verontwaardigd: “Waarom die verspilling? ");
INSERT INTO nldgbv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","De olie had voor veel geld kunnen worden verkocht en de opbrengst had aan de armen kunnen worden gegeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jezus was zich ervan bewust en zei tegen hen: “Waarom vallen jullie die vrouw lastig? Ze heeft iets goeds voor Mij gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Er zullen altijd wel arme mensen bij jullie zijn, maar Ik zal niet altijd bij jullie zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Door deze olie over mijn lichaam uit te gieten, heeft zij Mij gezalfd ter voorbereiding op mijn begrafenis. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ik verzeker jullie, overal in de wereld waar het evangelie zal worden verkondigd, zal ter herinnering aan haar worden verteld wat zij heeft gedaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Toen ging een van de Twaalf, namelijk Judas Iskariot, naar de hoofdpriesters ");
INSERT INTO nldgbv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","en vroeg: “Wat zijn jullie bereid mij te geven als ik Jezus aan jullie uitlever?” Zij telden dertig zilverstukken voor hem uit. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Vanaf toen zocht Judas naar een gelegenheid om Jezus uit te leveren. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Op de eerste dag van het Feest van de Ongedesemde Broden kwamen Jezus' leerlingen Hem vragen: “Waar wilt U dat we de Pesachmaaltijd klaarmaken?” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jezus zei: “Ga de stad in, naar die en die persoon, en zeg tegen hem: ‘De Leraar zegt: Mijn tijd is bijna gekomen. Bij jou thuis zal Ik met mijn leerlingen de Pesachmaaltijd eten.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","De leerlingen deden wat Hij hun had opgedragen: ze maakten de Pesachmaaltijd klaar. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Die avond nam Jezus aan tafel plaats met de Twaalf. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tijdens het eten zei Jezus: “Ik verzeker jullie, een van jullie zal Mij verraden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Daar werden ze heel bedroefd van en ze vroegen Hem, de een na de ander: “Ik ben het toch niet, Heer?” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jezus antwoordde: “Hij die samen met Mij het stuk brood in zijn hand in de schaal met eten doopt, Hij is het die Mij zal verraden. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","De Mensenzoon zal heengaan, precies zoals over Hem in de Schriften staat, maar wee degene door wie de Mensenzoon wordt verraden. Voor die persoon zou het beter zijn geweest als hij niet was geboren.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, zijn verrader, reageerde: “Ik ben het toch niet, Rabbi?” Jezus zei tegen hem: “Jij hebt het gezegd.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tijdens de maaltijd nam Jezus een brood, sprak een zegengebed uit, brak het in stukken, verdeelde die onder zijn leerlingen en zei: “Neem dit aan en eet het, dit is mijn lichaam.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ook nam Hij een beker, sprak een dankgebed uit en reikte hen de beker aan, terwijl Hij zei: “Drink er allen uit. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dit is mijn bloed, het bloed van het verbond, dat voor veel mensen wordt vergoten, voor de vergeving van hun zonden. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ik zeg jullie, vanaf nu zal Ik niet meer van deze vrucht van de druivelaar drinken tot de dag waarop Ik nieuwe wijn met jullie drink in het koninkrijk van mijn Vader.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na het zingen van een danklied vertrokken ze naar de Olijfberg. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Toen zei Jezus tegen zijn leerlingen: “Omwille van wat er met Mij gaat gebeuren, zullen jullie allen Mij vannacht in de steek laten, want in de Schriften staat: ‘Ik zal de herder doodslaan, en de schapen van de kudde zullen worden uiteengedreven.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Maar nadat Ik ben verrezen, zal Ik voor jullie uit naar Galilea gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus reageerde: “Al zou iedereen U in de steek laten, ik zal U nooit in de steek laten!” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jezus zei tegen hem: “Ik verzeker je, vannacht nog, voordat de haan kraait, zal jij Mij driemaal verloochenen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus antwoordde: “Al zou ik samen met U moeten sterven, ik zal U nooit verloochenen.” De andere leerlingen zeiden hetzelfde. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Toen kwam Jezus met hen bij een plaats die Getsemane wordt genoemd. Hij zei tegen zijn leerlingen: “Gaan jullie hier zitten terwijl Ik verderop ga bidden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jezus nam Petrus en de twee zonen van Zebedeüs met zich mee en begon bedroefd en onrustig te worden. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hij zei tegen hen: “Ik ben diep, zelfs dodelijk, bedroefd. Blijf hier samen met Mij waken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hij stapte iets verder, liet zich voorover vallen en bad: “Mijn Vader, als het mogelijk is, laat deze beker dan aan Mij voorbijgaan; laat echter niet gebeuren wat Ik wil, maar wat U wil.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Toen Hij bij zijn leerlingen terugkwam, trof Hij hen slapend aan. Hij zei tegen Petrus: “Konden jullie niet eens een uur lang samen met Mij waken? ");
INSERT INTO nldgbv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Waak en bid, opdat jullie niet in verzoeking komen, want de geest is wel bereidwillig maar het lichaam is zwak.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hij ging nogmaals weg, voor de tweede keer, en bad: “Mijn Vader, als het niet mogelijk is dat dit voorbij gaat tenzij Ik drink, laat dan gebeuren wat U wil.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Toen Hij weer bij zijn leerlingen terugkwam, trof Hij hen nogmaals slapend aan, want ze konden hun ogen niet openhouden. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hij ging opnieuw weg en bad iets verderop dezelfde woorden, voor de derde keer. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Daarna kwam Hij bij zijn leerlingen terug en zei Hij: “Zijn jullie nog altijd aan het slapen en rusten? Het tijdstip waarop de Mensenzoon aan de zondaars wordt uitgeleverd, is bijna aangebroken. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sta op, laten we vertrekken; mijn verrader is bijna hier.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Terwijl Hij nog sprak, kwam Judas, een van de Twaalf, vergezeld van een grote menigte met zwaarden en knuppels, gestuurd door de hoofdpriesters en oudsten van het volk. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jezus' verrader had een teken met hen afgesproken: “Het is degene die ik met een kus begroet; Hem moeten jullie arresteren.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hij stapte recht op Jezus af, zei “Gegroet, Rabbi!” en gaf Hem een kus. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jezus zei tegen hem: “Vriend, doe waarvoor je gekomen bent.” Toen kwamen ze naar Jezus toe, en ze grepen en arresteerden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Een van de mensen bij Jezus strekte ineens zijn hand uit, trok zijn zwaard, viel de dienaar van de hogepriester aan en hakte zijn oor af. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Maar Jezus zei tegen hem: “Steek je zwaard terug op zijn plaats, want ieder die naar het zwaard grijpt, zal door het zwaard omkomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Denk je niet dat Ik mijn Vader te hulp zou kunnen roepen en dat Hij Mij dan meteen twaalf legioenen engelen zou sturen? ");
INSERT INTO nldgbv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Maar hoe zou dan in vervulling gaan wat in de Schriften staat, namelijk dat dit moet gebeuren?” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Op dat moment zei Jezus tegen de mensen: “Zijn jullie Mij hier als een misdadiger met zwaarden en knuppels komen arresteren? Ik zat toch elke dag bij jullie op het tempelterrein te onderwijzen? Toen hebben jullie Mij niet opgepakt. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Maar dit alles is gebeurd opdat in vervulling zou gaan wat de profeten hebben geschreven.” Toen lieten al zijn leerlingen Hem in de steek; ze vluchtten weg. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zij die Jezus hadden gearresteerd, leidden Hem weg naar Kajafas, de hogepriester, waar de Schriftgeleerden en de oudsten waren bijeengekomen. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus volgde Hem op een afstand, tot op de binnenplaats van het huis van de hogepriester. Eenmaal binnen ging hij bij de bewakers zitten om te kijken wat er zou gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","De hoofdpriesters en de hele Joodse raad zochten naar een valse getuigenverklaring tegen Jezus, zodat ze Hem zouden kunnen ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dat lukte niet, hoewel er veel valse getuigen naar voren kwamen. Uiteindelijk kwamen twee mensen naar voren, ");
INSERT INTO nldgbv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","die zeiden: “Deze man heeft gezegd: ‘Ik kan Gods tempel verwoesten en in drie dagen herbouwen.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Toen stond de hogepriester op en vroeg aan Jezus: “Hebt U geen antwoord op de verklaring van deze getuigen tegen U?” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jezus zweeg. De hogepriester zei tegen Hem: “Ik bezweer U bij de levende God, zeg ons of U de Messias bent, de Zoon van God!” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jezus zei tegen hem: “U hebt het gezegd. Maar Ik zeg u, vanaf nu zal u de Mensenzoon aan de rechterzijde van de Machtige zien zitten, en u zal Hem zien komen op de wolken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Toen maakte de hogepriester een scheur in zijn mantel en zei hij: “Hij heeft God gelasterd. Waarom hebben we nog getuigen nodig? U heeft de godslastering nu toch gehoord? ");
INSERT INTO nldgbv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wat is uw oordeel?” Ze antwoordden: “Hij verdient de dood!” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Toen spuwden ze Hem in het gezicht en gaven ze Hem vuistslagen. Sommigen sloegen Hem ");
INSERT INTO nldgbv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","en riepen dan: “Profeteer voor ons, Messias, wie is het die U heeft geslagen?” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Intussen zat Petrus buiten op de binnenplaats. Er kwam een dienstmeisje naar hem toe. Ze zei: “U was ook bij Jezus de Galileeër.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petrus ontkende het tegenover hen allen. “Ik weet niet waarover je het hebt”, zei hij. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Terwijl hij naar de buitenpoort stapte, werd hij opgemerkt door een ander dienstmeisje. Zij zei tegen de mensen daar: “Die man was bij Jezus van Nazaret.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus ontkende het opnieuw door te zweren: “Ik ken die Man niet.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iets later kwamen de omstaanders naar Petrus toe en zeiden: “Jij bent toch echt een van hen, want je accent verraadt je.” ");
INSERT INTO nldgbv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Toen begon Petrus vloeken over zichzelf af te roepen en te zweren: “Ik ken die Man niet.” Meteen kraaide er een haan. ");
INSERT INTO nldgbv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Toen herinnerde Petrus zich wat Jezus had gezegd: “Voordat de haan kraait, zal jij Mij driemaal verloochenen.” Hij ging naar buiten en weende bitter. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Toen het ochtend werd, smeedden alle hoofdpriesters en volksoudsten tezamen een plan om Jezus om te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ze leidden Hem gebonden weg en leverden Hem over aan Pilatus, de gouverneur. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Toen Judas, Jezus' verrader, zag dat Hij was veroordeeld, kreeg hij wroeging en bracht hij de dertig zilverstukken naar de hoofdpriesters en oudsten terug. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hij zei: “Ik heb gezondigd door een onschuldige te verraden.” Maar zij zeiden: “Wat gaat ons dat aan? Zie zelf maar.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas gooide de zilverstukken de tempel in, vertrok en hing zich op. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Toen de hoofdpriesters de zilverstukken opraapten, zeiden ze: “Dit mogen we niet bij de tempelschatten bewaren, want het is bloedgeld.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Daarom kwamen ze tot het gezamenlijke besluit, met de zilverstukken de akker van de pottenbakker te kopen en als begraafplaats voor vreemdelingen te gebruiken. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Daarom wordt die akker tot op vandaag de Bloedakker genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zo ging in vervulling wat de profeet Jeremia had voorspeld: “Ze namen de dertig zilverstukken, de prijs die door de Israëlieten was bepaald, ");
INSERT INTO nldgbv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","en ze betaalden dat voor de akker van de pottenbakker, zoals de Heer mij had opgedragen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Inmiddels stond Jezus voor de gouverneur. De gouverneur vroeg Hem: “Bent U de koning van de Joden?” Jezus antwoordde: “U zegt het zelf.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","De hoofdpriesters en oudsten brachten hun beschuldigingen tegen Hem in, maar Jezus reageerde niet. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Toen vroeg Pilatus Hem: “Hoort U niet hoeveel verklaringen tegen U worden afgelegd?” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jezus ging echter op geen enkele beschuldiging in, wat de gouverneur sterk verwonderde. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nu was het de gewoonte van de gouverneur om tijdens het feest een gevangene vrij te laten die door de menigte werd gekozen. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Er was dit keer een beruchte gevangene die Jezus Barabbas heette. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Daarom vroeg Pilatus aan de mensen die waren samengestroomd: “Wie willen jullie dat ik vrijlaat, Jezus Barabbas of Jezus die de Messias wordt genoemd?” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hij wist namelijk dat ze Hem hadden uitgeleverd uit afgunst. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Terwijl hij nog op de rechterstoel zat, liet zijn vrouw hem berichten: “Zorg dat je die rechtvaardige man niets aandoet, want ik ben erg ontdaan door een droom die ik vannacht over Hem heb gehad.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Maar de hoofdpriesters en de oudsten overreedden de mensenmassa om Barabbas op te eisen en Jezus te laten ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","De gouverneur vroeg nogmaals: “Wie van de twee willen jullie dat ik vrijlaat?” Ze antwoordden: “Barabbas!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus vroeg hen: “Wat willen jullie dat ik doe met Jezus die de Messias wordt genoemd?” Iedereen riep: “Hij moet gekruisigd worden!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus vroeg: “Wat heeft Hij dan misdaan?” Nu riep men nog luider: “Hij moet gekruisigd worden!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus zag dat hij niets bereikte maar dat er een rel ontstond. Hij liet water halen, waste in het bijzijn van de menigte zijn handen, en zei: “Ik ben niet verantwoordelijk voor de dood van deze man. Zie zelf maar.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Het hele volk antwoordde: “Wij en onze kinderen nemen de verantwoordelijkheid voor zijn dood op ons!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Toen liet Pilatus Barabbas vrij, maar Jezus liet hij geselen en vervolgens wegleiden om te worden gekruisigd. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","De soldaten van de gouverneur leidden Jezus het hoofdkwartier binnen en de gehele legerafdeling kwam om Hem heen staan. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ze trokken Hem de kleren uit en deden Hem een felrode mantel om. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ze vlochten een kroon van doorntakken die ze op zijn hoofd zetten, staken een rieten stok in zijn rechterhand, knielden voor Hem en dreven de spot met Hem door te roepen: “Gegroet, koning van de Joden!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ze spuwden naar Hem, namen Hem de rietstok af en sloegen ermee op zijn hoofd. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nadat ze zo de spot met Hem hadden gedreven, trokken ze Hem de mantel uit en deden Hem zijn eigen kleren weer aan. Vervolgens leidden ze Hem weg om Hem te kruisigen. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Toen ze de stad uitgingen, troffen ze een man uit Cyrene aan, die Simon heette. Hem dwongen ze Jezus' kruis te dragen. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Toen ze bij de plaats kwamen die Golgota heet, wat “Schedelplaats” betekent, ");
INSERT INTO nldgbv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","gaven ze Hem met gal gemengde wijn te drinken. Maar na ervan geproefd te hebben, wilde Hij het niet opdrinken. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nadat ze Hem daar hadden gekruisigd en zijn kleren door middel van verloting hadden verdeeld, ");
INSERT INTO nldgbv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","gingen ze zitten om Hem te bewaken. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Boven zijn hoofd plaatsten ze een bordje met de aanklacht tegen Hem: “Dit is Jezus, de koning van de Joden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Samen met Hem werden ook twee misdadigers gekruisigd, één rechts en één links van Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","De voorbijgangers beledigden Hem door hoofdschuddend ");
INSERT INTO nldgbv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","te roepen: “Jij die de tempel verwoest en binnen drie dagen herbouwt! Red Jezelf als Jij de Zoon van God bent; kom van het kruis af!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Precies zo bespotten ook de hoofdpriesters Hem, samen met de Schriftgeleerden en de oudsten. Ze riepen: ");
INSERT INTO nldgbv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Anderen heeft Hij gered, maar zichzelf redden kan Hij niet. Als Hij de koning van Israël is, laat Hij dan nu van het kruis afkomen; dan zullen we in Hem geloven. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hij vertrouwt op God, laat Die Hem redden als Hij daartoe bereid is. Hij heeft immers gezegd: ‘Ik ben de Zoon van God.’” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ook de misdadigers die samen met Jezus waren gekruisigd, bespotten Hem op die manier. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vanaf twaalf uur 's middags werd het donker in het hele land, tot drie uur. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rond drie uur 's middags riep Jezus luid: “Eli, Eli, lama sabachtani?” Dat betekent: Mijn God, mijn God, waarom heeft U Mij verlaten? ");
INSERT INTO nldgbv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sommige mensen die daar stonden, hoorden het en zeiden: “Die Man roept Elia.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Meteen haalde een van hen haastig een spons, vulde die met zure wijn, stak hem op een stok en gaf Jezus zo te drinken. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Maar de anderen zeiden: “Wacht, laten we kijken of Elia Hem komt redden.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nadat Jezus nogmaals luid had geroepen, stierf Hij. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Op dat moment scheurde het tempelgordijn van boven naar beneden in tweeën. De aarde beefde, de rotsen spleten, ");
INSERT INTO nldgbv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","en de graven gingen open. Veel lichamen van overleden mensen die bij God hoorden, kwamen tot leven. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ze kwamen uit hun graven, en nadat Jezus was verrezen, gingen ze de heilige stad in, waar ze door veel mensen zijn gezien. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tijdens de aardbeving waren de centurio en zijn mannen Jezus aan het bewaken. Toen ze zagen wat er gebeurde, werden ze verschrikkelijk bang. Ze zeiden: “Deze man was werkelijk de Zoon van God!” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Er waren veel vrouwen die vanop een afstand toekeken. Zij waren Jezus gevolgd vanuit Galilea en hadden Hem gediend. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Onder hen bevonden zich Maria van Magdala, Maria de moeder van Jakobus en Jozef, en de moeder van de zonen van Zebedeüs. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Het werd avond. Een rijk man uit Arimatea die Jozef heette en een volgeling van Jezus was geworden, ");
INSERT INTO nldgbv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ging naar Pilatus en vroeg om het lichaam van Jezus. Pilatus gaf opdracht het hem te geven. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jozef nam het lichaam, wikkelde het in schoon linnen ");
INSERT INTO nldgbv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","en legde het in zijn nieuwe graf, dat hij in de rots had laten uithouwen. Hij rolde een grote steen voor de ingang van het graf en vertrok. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria van Magdala en de andere Maria waren daar; ze zaten tegenover het graf. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","De volgende dag, dus de dag na Voorbereidingsdag, gingen de hoofdpriesters en de farizeeën gezamenlijk naar Pilatus. ");
INSERT INTO nldgbv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ze zeiden: “Meneer de gouverneur, wij herinneren ons dat die bedrieger, toen Hij nog leefde, heeft gezegd: ‘Na drie dagen zal Ik verrijzen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wilt u daarom het bevel geven om het graf te bewaken tot de derde dag? Anders kunnen zijn leerlingen erheen gaan, het lichaam stelen en tegen het volk zeggen: ‘Hij is uit de dood verrezen.’ En dan is het laatste bedrog erger dan het eerste.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus zei tegen hen: “Ik geef jullie een wacht soldaten; ga het graf bewaken naar best vermogen.” ");
INSERT INTO nldgbv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ze gingen met de wacht soldaten naar het graf om dat te bewaken, en ze verzegelden de steen. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na de sabbat, toen het ochtend werd op de eerste dag van de week, gingen Maria van Magdala en de andere Maria naar het graf kijken. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Plots vond er een zware aardbeving plaats. Een engel van de Heer daalde uit de hemel neer, ging naar het graf, rolde de steen weg en ging erop zitten. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hij zag eruit als de bliksem en zijn kledij was sneeuwwit. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","De mannen die het graf bewaakten, beefden van angst en vielen voor dood neer. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maar de engel sprak de vrouwen als volgt toe: “Wees niet bang, ik weet dat jullie Jezus zoeken, die was gekruisigd. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hij is hier niet; Hij is verrezen, zoals Hij had gezegd. Kom maar kijken waar Hij heeft gelegen. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","En ga dan snel aan zijn leerlingen vertellen: ‘Hij is uit de dood verrezen. Hij gaat voor jullie uit naar Galilea en daar zullen jullie Hem zien.’ Dat is mijn boodschap voor jullie.” ");
INSERT INTO nldgbv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Snel verlieten de vrouwen het graf, angstig maar ook bijzonder verheugd. Ze haastten zich naar Jezus' leerlingen om verslag uit te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Plots kwam Jezus naar hen toe. Hij zei: “Gegroet!” Ze kwamen dichterbij, grepen zijn voeten vast en aanbaden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Toen zei Jezus tegen hen: “Wees maar niet bang. Ga mijn mensen vertellen dat ze naar Galilea moeten gaan; daar zullen ze Mij zien.” ");
INSERT INTO nldgbv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Terwijl de vrouwen onderweg waren, gingen enkele van de soldaten die het graf hadden bewaakt naar de stad, waar ze verslag aan de hoofdpriesters uitbrachten van alles wat er gebeurd was. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","De hoofdpriesters kwamen bijeen met de oudsten en beraamden samen met hen het plan om een grote som geld aan de soldaten te geven ");
INSERT INTO nldgbv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","en hun te vertellen: “Jullie moeten zeggen: ‘Zijn leerlingen zijn Hem 's nachts komen stelen terwijl wij sliepen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","En als de gouverneur hiervan hoort, zullen wij hem overreden, zodat jullie je geen zorgen hoeven te maken.” ");
INSERT INTO nldgbv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","De soldaten aanvaardden het geld en deden wat hun was opgedragen. Dit verhaal is tot op vandaag onder de Joodse mensen verspreid. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","De elf leerlingen van Jezus gingen naar Galilea, naar de berg waarvan Hij had gezegd dat ze daarnaartoe moesten gaan. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Toen ze Hem zagen, aanbaden ze Hem, hoewel sommigen twijfelden. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jezus kwam dichterbij en zei tegen hen: “Alle gezag in de hemel en op aarde is aan Mij gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ga daarom op weg en maak van alle volken mijn volgelingen, doop hen in de naam van de Vader, de Zoon en de Heilige Geest ");
INSERT INTO nldgbv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","en leer hun alles na te leven wat Ik jullie heb opgedragen. En weet dat Ik voortdurend bij jullie zal zijn, tot aan het einde van de wereld.”");
INSERT INTO nldgbv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Begin van het evangelie van Jezus Christus, de Zoon van God. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","In het boek van de profeet Jesaja staat: “Ik stuur mijn boodschapper voor Je uit, die de weg voor Je zal banen; ");
INSERT INTO nldgbv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","er roept een stem in de wildernis: Maak de weg van de Heer gereed, maak paden voor Hem vrij!” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Overeenkomstig die profetie kwam Johannes de Doper in de wildernis de doop van inkeer verkondigen, die tot vergeving van zonden leidt. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mensen uit heel het gebied Judea en alle inwoners van Jeruzalem kwamen naar hem toe en werden door hem in de rivier de Jordaan gedoopt, waarbij ze hun zonden bekenden. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannes droeg kledij van kameelhaar en had een leren riem om zijn middel. Hij at sprinkhanen en wilde honing. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hij verkondigde: “Na mij komt Iemand die machtiger is dan ik; ik ben het niet waard om te bukken om zijn schoenriem los te maken. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ik heb jullie gedoopt met water, maar Hij zal jullie dopen met de Heilige Geest.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","In die tijd arriveerde Jezus uit Nazaret; dat ligt in Galilea. Hij werd door Johannes in de Jordaan gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zodra Jezus uit het water omhoogkwam, zag Hij dat de hemel openging en de Geest als een duif op Hem neerdaalde. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Toen klonk er een stem uit de hemel: “Jij bent mijn dierbare Zoon; Ik verheug Mij over Jou.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Meteen daarna stuurde de Geest Jezus de wildernis in. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Op die eenzame plaats bleef Hij veertig dagen, terwijl Hij door Satan op de proef werd gesteld. Jezus was bij de wilde dieren en de engelen dienden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nadat Johannes was gevangengenomen, ging Jezus naar Galilea, waar Hij Gods goede nieuws verkondigde. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hij zei: “Het tijdstip is aangebroken, Gods koninkrijk is in aantocht. Kom tot inkeer en geloof het evangelie.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Toen Jezus langs het Meer van Galilea wandelde, zag Hij dat Simon en zijn broer Andreas een net in het meer uitwierpen, want ze waren vissers. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jezus zei tegen hen: “Kom, volg Mij en Ik zal mensenvissers van jullie maken.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Meteen lieten ze hun netten achter en volgden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iets verderop zag Hij Jakobus, de zoon van Zebedeüs, die met zijn broer Johannes in een boot de netten aan het klaarmaken was. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hij riep hen, en meteen lieten zij hun vader Zebedeüs met de arbeiders in de boot achter en gingen ze Hem achterna. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ze gingen naar Kafarnaüm en de eerstvolgende sabbat ging Jezus naar de synagoge om er te onderwijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","De mensen waren diep onder de indruk van zijn onderwijs, want Hij onderwees hen als een gezaghebbende en niet zoals de Schriftgeleerden. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Op dat moment was er in hun synagoge een man in wie een onreine geest leefde. Hij schreeuwde: ");
INSERT INTO nldgbv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Wat wilt U van ons, Jezus van Nazaret? Bent U gekomen om ons te vernietigen? Ik weet wie U bent: Gods Heilige!” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Maar Jezus sprak hem berispend toe: “Zwijg en ga uit hem weg.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","De onreine geest deed de man stuiptrekken en ging met een luide schreeuw uit hem weg. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Alle mensen stonden er versteld van en ze vroegen elkaar: “Wat is dit? Nieuwe leer, met gezag! Hij geeft zelfs bevelen aan de onreine geesten en zij gehoorzamen Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Het nieuws over Jezus verspreidde zich meteen door het hele gebied van Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Toen ze uit de synagoge kwamen, gingen ze meteen met Jakobus en Johannes naar het huis van Simon en Andreas. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simons schoonmoeder lag met koorts in bed en meteen vertelden ze Jezus over haar. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hij ging naar haar toe, nam haar bij de hand en hielp haar overeind. De koorts verdween en zij bediende hen. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Die avond na zonsondergang bracht men iedereen bij Jezus die ziek of bezeten was. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","De hele stad verzamelde zich bij de deur. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jezus genas veel mensen met allerlei ziekten. Ook dreef Hij veel demonen uit, maar Hij liet niet toe dat de demonen spraken, want zij wisten wie Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","De volgende ochtend stond Jezus op terwijl het nog donker was. Hij verliet het huis en ging naar een eenzame plaats om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Maar Simon en de mensen die bij hem waren, zochten naar Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Toen ze Hem hadden gevonden, zeiden ze tegen Hem: “Iedereen zoekt U!” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Maar Jezus zei: “Laten we naar de dorpen in de omgeving gaan, zodat Ik ook daar kan preken, want daarvoor ben Ik gekomen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Toen trok Hij door heel Galilea, waar Hij preekte in de synagogen en demonen uitdreef. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Er kwam iemand bij Jezus met een huidziekte die hem onrein maakte. Hij smeekte Jezus op zijn knieën: “Als U wilt, kan U mij rein maken.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Vol medeleven stak Hij zijn hand uit om hem aan te raken. “Ik wil het”, zei Hij. “Word rein.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Meteen verdween de huidziekte en was de man rein geworden. ");
INSERT INTO nldgbv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jezus stuurde hem meteen weg met de strenge waarschuwing: ");
INSERT INTO nldgbv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Zorg dat je niemand iets vertelt, maar ga jezelf aan de priester tonen en breng het reinigingsoffer dat Mozes heeft opgelegd, bij wijze van getuigenis voor de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Maar nadat de man was vertrokken, ging hij het nieuws uitgebreid rondvertellen. Daarom kon Jezus niet langer openlijk een stad binnengaan en moest Hij op eenzame plaatsen verblijven. Toch kwamen de mensen van overal naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Toen Jezus enkele dagen later opnieuw Kafarnaüm binnenkwam, raakte bekend dat Hij thuis was. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Daar stroomden zoveel mensen samen dat er geen plaats meer was, zelfs niet bij de deur, en Hij sprak hen toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","De mensen kwamen iemand bij Hem brengen die verlamd was en door vier van hen werd gedragen. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","En omdat het wegens de menigte niet lukte om met hem bij Jezus te komen, maakten ze boven Hem een opening in het dak, waardoor ze de verlamde man op zijn mat naar beneden lieten zakken. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Toen Jezus hun geloof zag, zei Hij tegen de verlamde man: “Mijn zoon, je zonden zijn je vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nu waren daar enkele Schriftgeleerden, die heimelijk dachten: ");
INSERT INTO nldgbv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Waarom zegt Hij dat? Dat is godslastering! Behalve God is er toch niemand die zonden kan vergeven?” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jezus had meteen door dat ze dat dachten en Hij zei tegen hen: “Waarom denken jullie deze dingen? ");
INSERT INTO nldgbv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wat is gemakkelijker, tegen de verlamde zeggen: je zonden zijn vergeven, of zeggen: sta op, neem je mat op en wandel? ");
INSERT INTO nldgbv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Maar, opdat jullie beseffen dat de Mensenzoon het gezag heeft om op aarde zonden te vergeven …” En Hij zei tegen de verlamde man: ");
INSERT INTO nldgbv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tegen jou zeg Ik: sta op, neem je mat op en ga naar huis!” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","De verlamde man stond op, nam meteen zijn mat op en vertrok waar iedereen bij was. Ze stonden allen versteld, verheerlijkten God en zeiden: “Zoiets hebben we nog nooit gezien!” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jezus ging terug naar het meer. Alle mensen kwamen bij Hem en Hij onderwees hen. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Onderweg zag Hij Levi, de zoon van Alfeüs, bij het tolhuis zitten. Jezus zei tegen hem: “Volg Mij.” En Levi stond op en volgde Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Toen Hij op een dag bij Levi te gast was voor een maaltijd, at een groot aantal belastinginners en zondaars met Jezus en zijn leerlingen mee, want velen van hen volgden Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Toen de Schriftgeleerden van de farizeeën Jezus zagen eten met de zondaars en belastinginners, vroegen ze aan zijn leerlingen: “Waarom eet Hij met belastinginners en zondaars?” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jezus hoorde het en zei tegen hen: “Het zijn niet de gezonde mensen die een dokter nodig hebben, maar de zieken. Ik ben niet gekomen om rechtvaardige mensen te roepen, maar zondaars.” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Toen Johannes' leerlingen en de farizeeën aan het vasten waren, kwamen er mensen aan Jezus vragen: “Johannes' leerlingen en de farizeeën zijn aan het vasten; waarom vasten uw leerlingen niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jezus antwoordde: “De gasten van de bruidegom kunnen toch niet vasten terwijl de bruidegom bij hen is? Zolang hij bij hen is, kunnen ze niet vasten. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Maar er komt een tijd dat de bruidegom bij hen wordt weggenomen en dan zullen ze vasten. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Niemand lapt een oud kledingstuk op met een stuk stof dat nog niet gekrompen is, want dan trekt het verstelstuk de oude stof kapot en ontstaat er een grotere scheur. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","En niemand giet nieuwe wijn in oude wijnzakken, want dan barst de wijn uit zijn zakken en zijn zowel de wijn als de zakken niets meer waard. Nieuwe wijn hoort in nieuwe wijnzakken.” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Op een sabbat, toen Jezus tussen de graanvelden door wandelde, begonnen zijn leerlingen onderweg wat aren te plukken. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","De farizeeën vroegen Hem: “Waarom doen zij iets dat op de sabbat niet is toegestaan?” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hij antwoordde: “Hebben jullie nooit gelezen wat David deed toen hij en zijn mannen niets bij zich hadden en honger kregen? ");
INSERT INTO nldgbv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dat gebeurde in de tijd dat Abjatar hogepriester was. David ging het huis van God binnen, at van de gewijde broden waarvan enkel de priesters mochten eten, en gaf ervan aan zijn mannen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ook zei Jezus tegen hen: “De sabbat is voor de mens gemaakt, niet de mens voor de sabbat. ");
INSERT INTO nldgbv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daarom is de Mensenzoon ook baas over de sabbat.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jezus ging opnieuw naar de synagoge en daar was iemand met een hand die hij niet kon bewegen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","De mensen keken goed of Jezus hem op de sabbat zou genezen, zodat ze Hem zouden kunnen beschuldigen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Maar Hij zei tegen de man met de hand die hij niet kon bewegen: “Kom in het midden staan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Toen vroeg Hij de mensen: “Wat is toegestaan op de sabbat: goed doen of kwaad doen, een leven redden of een leven wegnemen?” Maar ze zwegen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hij keek hen kwaad aan, ontzet over de starheid van hun hart. Vervolgens zei Hij tegen de man: “Steek de hand uit.” De man stak zijn hand uit en die genas. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Toen gingen de farizeeën naar buiten om samen met de aanhangers van Herodes een plan te beramen om Jezus om te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jezus trok zich echter met zijn leerlingen terug bij het meer. Een groot aantal mensen uit Galilea volgde hen. Ook uit Judea, ");
INSERT INTO nldgbv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruzalem, Idumea, het gebied aan de overkant van de Jordaan en uit de omgeving van Tyrus en Sidon kwamen de mensen in drommen naar Hem toe, omdat ze hadden gehoord wat Hij allemaal deed. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hij vroeg zijn leerlingen om een bootje klaar te houden wegens de menigte, voor het geval het gedrang te sterk zou worden. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hij had namelijk veel mensen genezen en daarom drongen veel mensen die iets mankeerden naar voren om Hem aan te raken. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","En wanneer de onreine geesten Hem zagen, vielen ze voor Hem neer terwijl ze schreeuwden: “U bent de Zoon van God.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Maar Hij verbood hun nadrukkelijk, bekend te maken wie Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Toen ging Jezus een berg op en riep Hij wie Hij bij zich wilde hebben. Die mensen kwamen naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hij stelde twaalf personen aan – Hij noemde hen apostelen – om bij Hem te horen en door Hem te worden uitgezonden om te preken ");
INSERT INTO nldgbv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","met het gezag om demonen uit te drijven. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dit zijn de twaalf die hij aanstelde: Simon, aan wie Hij de naam Petrus gaf, ");
INSERT INTO nldgbv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakobus, de zoon van Zebedeüs, zijn broer Johannes – aan hen gaf Hij de naam Boanerges, wat “zonen van de donder” betekent – ");
INSERT INTO nldgbv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filippus, Bartolomeüs, Matteüs, Tomas, Jakobus, de zoon van Alfeüs, Taddeüs, Simon de Zeloot, ");
INSERT INTO nldgbv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","en Judas Iskariot, die Hem uiteindelijk verraden heeft. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jezus ging naar huis. Opnieuw stroomde daar veel volk samen, zodat ze zelfs niet konden eten. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Toen zijn familie ervan hoorde, gingen ze op pad om Hem op te halen, want ze zeiden: “Hij is niet goed bij zijn verstand.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","De Schriftgeleerden die uit Jeruzalem waren gekomen, zeiden: “Beëlzebul, de heerser over de demonen, zit in Hem en daarom kan Hij de demonen uitdrijven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jezus riep hen echter bij zich en zei tegen hen in de vorm van parabels: “Het kan toch niet dat Satan Satan uitdrijft? ");
INSERT INTO nldgbv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Als een koninkrijk innerlijk verdeeld is, kan het niet standhouden. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","En als een familie innerlijk verdeeld is, kan ze niet standhouden. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","En als Satan tegen zichzelf opstaat en verdeeld is, kan hij niet standhouden maar is het voor hem afgelopen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ook kan niemand het huis van een sterk persoon binnendringen om zijn bezit te plunderen zonder eerst die sterke man vast te binden. Pas dan kan hij het huis leegplunderen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ik verzeker jullie, alle zonde en alle godslastering die mensen begaan, kan hun worden vergeven. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Maar voor wie lastert tegen de Heilige Geest, komt er nooit vergeving; hij is schuldig aan een eeuwige zonde.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","De mensen hadden namelijk gezegd dat Jezus een onreine geest in zich had. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Toen arriveerden Jezus' moeder en broers. Ze bleven buiten en stuurden iemand naar binnen om Hem te roepen. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Er zaten veel mensen om Hem heen en ze zeiden tegen Hem: “Uw moeder en broers en zussen staan buiten en zoeken U.” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Maar Hij vroeg hun: “Wie zijn mijn moeder en mijn broers?” ");
INSERT INTO nldgbv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hij keek naar de mensen die in een kring om Hem heen zaten en zei: “Dit zijn mijn moeder en broers. ");
INSERT INTO nldgbv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Want wie doet wat God wil, die is mijn broer, zus of moeder.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Toen Jezus opnieuw ging onderwijzen bij het meer, verzamelde zich zo'n grote menigte om Hem heen, dat Hij plaatsnam in een boot op het meer, terwijl alle mensen op de oever bleven staan. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hij leerde hun van alles door middel van parabels. Hij zei: ");
INSERT INTO nldgbv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Luister! Er was eens een zaaier die ging zaaien. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tijdens het zaaien viel er wat zaad langs het pad en de vogels kwamen het oppikken. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Een ander deel viel in een ondiep laagje aarde op rotsgrond. De plantjes schoten meteen op, omdat de aarde ondiep was. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Maar toen de zon hoog kwam te staan, verschroeiden de plantjes en gingen ze dood, omdat ze geen wortels hadden. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nog een ander deel viel tussen het onkruid. Het werd door het groeiende onkruid verstikt en leverde geen oogst op. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Weer ander zaad kwam terecht in goede aarde. Het kwam op, groeide verder en leverde een goede oogst op, wel dertig-, zestig- of zelfs honderdmaal zoveel als er was gezaaid.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Toen zei Hij: “Als je oren hebt om te horen, luister dan!” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Toen Hij later alleen was, vroegen de mensen die samen met de Twaalf bij Hem waren, wat de parabels betekenden. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hij zei tegen hen: “Aan jullie is het geheim van Gods koninkrijk onthuld, maar aan buitenstaanders wordt alles in parabels verteld, ");
INSERT INTO nldgbv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","zodat ze ‘wel zien maar niet begrijpen, en wel horen maar niet verstaan’; anders zouden ze zich bekeren en worden vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Toen zei Hij tegen hen: “Begrijpen jullie deze parabel niet? Hoe gaan jullie dan de andere parabels begrijpen? ");
INSERT INTO nldgbv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","De zaaier ‘zaait’ de boodschap van God voor de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bij sommigen gaat het als bij zaad langs het pad. De boodschap wordt gezaaid, maar zodra ze haar horen, neemt Satan de boodschap die in hen gezaaid is weg. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bij anderen gaat het als bij zaad dat op rotsgrond wordt gezaaid: ze horen de boodschap en aanvaarden deze meteen met vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Maar ze zijn oppervlakkig en de boodschap raakt niet diep in hen geworteld. Zodra er verdrukking of vervolging komt omwille van het evangelie, geven ze op. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bij nog anderen gaat het als bij plantjes tussen het onkruid. Ze horen de boodschap, ");
INSERT INTO nldgbv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","maar deze raakt verstikt door de zorgen van dit leven, de misleiding van de rijkdom en de begerigheid naar andere dingen, en levert niets op. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","En bij weer anderen is het als bij zaad dat in goede aarde wordt gezaaid: ze horen de boodschap en aanvaarden haar, zodat ze een oogst oplevert die dertig-, zestig- of zelfs honderdmaal zo groot is.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hij vertelde hun ook: “Een olielamp wordt toch niet in huis gehaald om onder een bak of een bed te worden gezet? Nee, ze wordt op een standaard geplaatst. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Want er is niets geheim dat niet zal worden onthuld en niets verhuld dat niet zichtbaar zal worden. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Als je oren hebt om te horen, luister dan!” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hij zei ook tegen hen: “Denk zorgvuldig na over wat je hoort, want de maat die jij hanteert, zal op jou worden toegepast en daaruit zal je ruimschoots ontvangen! ");
INSERT INTO nldgbv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aan wie heeft, zal nog meer worden gegeven; maar van wie niets heeft, zal zelfs hetgeen hij heeft worden afgenomen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Verder zei Hij: “Met Gods koninkrijk is het als met een man die zaad in de grond heeft gezaaid. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dag na dag staat hij op en gaat hij weer slapen terwijl het zaad ontkiemt en groeit, zonder dat hij weet hoe. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Er groeit vanzelf iets uit die aarde: eerst een stengel, dan een aar, en vervolgens de volle graankorrels in de aar. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zodra het graan rijp is, zet hij de sikkel erin, want het is tijd geworden voor de oogst.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hij zei ook: “Waarmee zal ik Gods koninkrijk vergelijken, met welke parabel zal ik het beschrijven? ");
INSERT INTO nldgbv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Het is als een mosterdzaadje; wanneer het in de aarde wordt gezaaid, is het het kleinste van alle zaad op aarde. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maar na het zaaien groeit het op en wordt het de grootste van alle moestuinplanten, met takken die zo groot zijn dat de vogels zich in zijn schaduw kunnen nestelen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hij vertelde hun de boodschap van God in de vorm van veel van dergelijke parabels, in de mate waarin ze het konden begrijpen. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In feite sprak Hij enkel in de vorm van parabels, maar wanneer Hij met zijn leerlingen alleen was, legde Hij alles uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aan het einde van die dag, toen het avond werd, zei Hij tegen zijn leerlingen: “Laten we naar de overkant varen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ze stuurden de menigte naar huis en voeren met Hem in de boot weg. Er voeren andere boten met Hem mee. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Het begon hard te stormen en de golven sloegen in de boot, zodat die begon vol te lopen. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hij lag echter achter in de boot tegen het kussen te slapen. Ze maakten Hem wakker en vroegen: “Leraar, kan het U niet schelen dat we vergaan?” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Toen Hij wakker was geworden, beval Hij de wind en het meer: “Rustig, kalmeer!” De wind ging liggen en het werd heel stil. ");
INSERT INTO nldgbv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hij zei tegen hen: “Waarom zijn jullie zo bang? Hebben jullie geen geloof?” ");
INSERT INTO nldgbv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Maar zij waren hevig geschrokken en vroegen elkaar: “Wie is Hij toch, dat zelfs de wind en het meer Hem gehoorzamen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ze kwamen aan bij de overkant van het meer, in het gebied van de Gerasenen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zodra Jezus uit de boot stapte, kwam een man met een onreine geest van tussen de graven naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hij leefde namelijk tussen die graven en niemand kon hem nog vastbinden, zelfs niet met een ketting. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hij was namelijk al vaak aan handen en voeten geketend geweest, maar had telkens de ketens en boeien kapotgetrokken en vernield. Niemand kon hem in bedwang houden. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dag en nacht was hij tussen de graven en in de bergen aan het schreeuwen en zichzelf met stenen aan het verminken. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hij zag Jezus van ver, rende op Hem af en viel voor Hem op zijn knieën, ");
INSERT INTO nldgbv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","terwijl hij riep: “Waarom bemoeit U zich met mij, Jezus, Zoon van de allerhoogste God? Ik bezweer U in Gods naam: folter mij alstublieft niet!” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jezus had namelijk tegen hem gezegd: “Onreine geest, ga uit die man weg!” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Toen vroeg Jezus hem: “Hoe heet jij?” Hij antwoordde: “Mijn naam is Legio, want wij zijn met velen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hij smeekte Jezus met aandrang om hen niet uit de streek te verjagen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nu was er op de berghelling een grote kudde varkens aan het grazen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","De onreine geesten smeekten Hem: “Stuur ons alstublieft die varkens in!” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jezus stemde toe en de onreine geesten kwamen naar buiten en drongen de varkens binnen. De kudde, ongeveer tweeduizend varkens, stormde de helling af, het meer in, waar ze verdronken. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","De varkenshoeders renden weg en brachten verslag uit in de stad en op het land. Daarom kwamen de mensen kijken wat er was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Toen ze bij Jezus kwamen, zagen ze de man zitten die door demonen bezeten was geweest; hij was gekleed en bij zijn volle verstand. Toen werden ze bang. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Zij die hadden gezien wat er met de bezeten man en met de varkens was gebeurd, legden het aan hen uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Toen begonnen de mensen Jezus te smeken hun streek te verlaten. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Toen Hij in de boot stapte, smeekte de man die bezeten was geweest om met Hem mee te mogen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jezus liet dat niet toe, maar zei tegen hem: “Ga naar huis en vertel je familie wat de Heer voor jou heeft gedaan en hoe Hij jou zijn mededogen heeft getoond.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","De man vertrok en begon in de Dekapolis te verkondigen wat Jezus voor hem had gedaan. En iedereen was diep onder de indruk. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Toen Jezus naar de overkant was teruggevaren, kwam een grote menigte om Hem heen staan. Hij was nog bij het meer, ");
INSERT INTO nldgbv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","toen er een synagogebestuurder aankwam die Jaïrus heette. Hij zag Jezus, viel aan zijn voeten neer, ");
INSERT INTO nldgbv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","en smeekte vurig: “Mijn dochtertje is stervende. Kom haar alstublieft de handen opleggen, zodat ze zal genezen en in leven blijven!” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jezus ging met hem mee. Een grote menigte volgde Hem en drong tegen Hem aan. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Er was een vrouw bij die al twaalf jaar last had van bloedingen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ze had allerlei behandelingen van vele dokters ondergaan en had daar al haar geld aan uitgegeven, maar in plaats van beter te worden was ze verslechterd. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Toen zij over Jezus hoorde, wrong ze zich tussen de mensen door en raakte ze van achteren zijn mantel aan, ");
INSERT INTO nldgbv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","want ze dacht: “Als ik slechts zijn mantel aanraak, zal ik genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Meteen stopte het bloeden en voelde ze aan haar lichaam dat ze van haar kwaal was genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jezus merkte meteen dat er kracht van Hem was uitgegaan. Hij draaide zich om in de menigte en vroeg: “Wie heeft mijn kleren aangeraakt?” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Zijn leerlingen zeiden tegen Hem: “U ziet toch hoe de menigte zich om U verdringt? Hoe kan U dan vragen wie U heeft aangeraakt?” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hij bleef echter om zich heen kijken om te zien wie het had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","De vrouw, die nu beefde van angst omdat ze wist wat er met haar was gebeurd, kwam naar voren, liet zich voor Hem neervallen en vertelde Hem de hele waarheid. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hij zei tegen haar: “Mijn dochter, je geloof heeft je genezen. Ga in vrede en wees genezen van je kwaal.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Terwijl Jezus nog sprak, kwamen mensen uit het huishouden van Jaïrus de synagogebestuurder zeggen: “Uw dochtertje is gestorven. Waarom zou u de Leraar nog lastigvallen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jezus hoorde hun bericht, maar zei tegen de synagogebestuurder: “Wees niet bang; je moet enkel geloven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hij liet niet toe dat er iemand met Hem meeging, behalve Petrus en de broers Jakobus en Johannes. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Toen ze bij het huis van de synagogebestuurder waren aangekomen, zag Jezus een grote drukte. Er werd geweend en luid gejammerd. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hij ging naar binnen en zei: “Waarom deze drukte en dit geween? Het kind is niet dood, het slaapt alleen maar.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ze lachten Hem uit, maar Hij stuurde iedereen naar buiten behalve de vader en moeder van het kind en de leerlingen die Hem vergezelden. Hij ging de kamer binnen waar het kind lag, ");
INSERT INTO nldgbv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","nam haar hand vast en zei tegen haar: “Talita koem.” Dat betekent: “Meisje, Ik zeg je: sta op.” ");
INSERT INTO nldgbv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Het meisje stond meteen op en begon te stappen. Ze was twaalf jaar oud. Men was buiten zichzelf van verbazing. ");
INSERT INTO nldgbv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hij droeg hun op dat niemand dit te weten mocht komen en zei dat ze haar wat eten moesten geven. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jezus vertrok daarvandaan en kwam aan in zijn thuisstad. Zijn leerlingen waren met Hem meegekomen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Toen het sabbat werd, begon Hij te onderwijzen in de synagoge en de vele toehoorders waren diep onder de indruk. Ze vroegen: “Waar haalt die Man dat toch vandaan, hoe komt Hij aan die wijsheid en hoe is het mogelijk dat Hij die wonderen doet? ");
INSERT INTO nldgbv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Is dit niet de bouwer, de zoon van Maria en broer van Jakobus, Joses, Judas en Simon? En zijn zussen wonen toch hier bij ons?” Ze ergerden zich aan Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Maar Jezus zei tegen hen: “Het is alleen in zijn thuisstad, bij zijn familie en in zijn eigen huis dat een profeet geen eer ontvangt.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hij kon er geen wonderen doen, alleen genas Hij enkele zieken door hun de handen op te leggen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hij verbaasde zich over hun ongeloof. Daarna trok Hij van dorp tot dorp om er te onderwijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jezus riep de Twaalf bij zich en begon hen twee aan twee op pad te sturen. Hij gaf hun gezag over onreine geesten ");
INSERT INTO nldgbv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","en gaf hun de volgende instructies: “Neem niets mee voor onderweg, behalve een wandelstok. Geen brood, geen reistas, en geen geld in je geldriem. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Trek wel sandalen aan, maar geen extra kledij.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jezus zei ook tegen hen: “Wanneer jullie bij iemand te gast zijn, blijf dan bij die persoon logeren totdat je uit die plaats vertrekt. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","En wanneer men je ergens niet verwelkomt of niet naar je luistert, vertrek dan uit die plaats en schud het stof van je voetzolen als een teken voor hen van jullie afkeuring.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ze gingen eropuit en riepen de mensen op om tot inkeer te komen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ze dreven veel demonen uit en zalfden vele zieken met olie en genazen hen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jezus' naam raakte bekend en ook koning Herodes hoorde over Hem. Sommige mensen zeiden: “Johannes de Doper is uit de dood verrezen; daarom doet Hij wonderen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Anderen zeiden: “Hij is Elia”, en nog anderen: “Hij is een profeet, zoals de profeten van vroeger.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Maar toen Herodes het hoorde, zei hij: “Johannes, die ik heb laten onthoofden, is verrezen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes had namelijk zelf bevolen om Johannes te arresteren en in de gevangenis vast te zetten, wegens Herodias, de vrouw van zijn broer Filippus. Herodes was met haar getrouwd, ");
INSERT INTO nldgbv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","en Johannes had tegen Herodes gezegd: “U mag niet met uw schoonzus trouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Daarom had Herodias een hekel aan Johannes. Ze wilde hem doden, maar ze kreeg daartoe niet de gelegenheid. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes wist dat Johannes een rechtvaardige man was die een zuiver leven leidde. Herodes was bang voor Johannes en beschermde hem. Herodes luisterde graag naar Johannes, hoewel het hem in verlegenheid bracht. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias zag haar kans schoon op de verjaardag van Herodes, toen hij een feestmaal hield voor zijn hoge functionarissen en militaire leiders en de vooraanstaande burgers van Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Toen Herodias' dochter kwam dansen, beleefden Herodes en zijn gasten daar zoveel plezier aan dat de koning tegen het meisje zei: “Vraag me wat je wil, en ik zal het je geven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hij zwoer haar: “Ik zal je alles geven wat je vraagt, al was het de helft van mijn koninkrijk.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ze ging de zaal uit en zei tegen haar moeder: “Wat zal ik vragen?” Zij antwoordde: “Het hoofd van Johannes de Doper.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Het meisje haastte zich meteen terug naar binnen en zei tegen de koning: “Ik wil graag dat u mij onmiddellijk het hoofd van Johannes de Doper geeft, op een schaal.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","De koning was zwaar aangeslagen, maar omwille van wat hij had gezworen in het bijzijn van zijn gasten wilde hij het haar niet weigeren. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hij stuurde meteen een beul naar de gevangenis om het hoofd van Johannes te halen. De beul vertrok, onthoofdde Johannes ");
INSERT INTO nldgbv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","en kwam terug met zijn hoofd op een schaal. Hij gaf het aan het meisje en zij gaf het aan haar moeder. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Toen Johannes' leerlingen dit hoorden, haalden ze zijn lichaam op en legden het in een graf. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","De apostelen kwamen bij Jezus terug en vertelden Hem alles wat ze hadden gedaan en wat ze aan de mensen hadden onderwezen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Maar Hij zei tegen hen: “Ga naar een afgelegen plaats, waar jullie alleen kunnen zijn, en rust wat uit.” Want het was zo'n komen en gaan dat ze zelfs niet aan eten toekwamen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Daarom vertrokken ze per boot naar een afgelegen plaats om alleen te zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Veel mensen die hen zagen wegvaren, herkenden hen. Ze haastten zich te voet vanuit alle steden naar die plaats, en kwamen vóór hen aan. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Toen Jezus uit de boot stapte, zag Hij een grote menigte en kreeg Hij medelijden met de mensen, want ze waren als schapen zonder herder. Daarom begon Hij hun van alles te leren. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Maar toen het laat begon te worden, kwamen zijn leerlingen bij Hem en zeiden: “Dit is een afgelegen plaats en het is al laat. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Stuur de mensen toch weg, zodat ze naar de gehuchten en dorpen in de omgeving kunnen gaan om voor zichzelf iets te kopen om te eten.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Maar Hij antwoordde: “Geven jullie hun maar te eten.” Zij vroegen Hem: “Hoe kunnen wij voor tweehonderd denarie brood gaan kopen om aan al die mensen te geven?” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jezus zei: “Ga eens kijken hoeveel broden jullie hebben.” Ze gingen het na het en zeiden: “Vijf, en twee vissen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Toen droeg Hij hun op tegen de mensen te zeggen dat ze in groepen op het groene gras moesten plaatsnemen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dus namen de mensen plaats in groepen van honderd en van vijftig. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jezus nam de vijf broden en de twee vissen, keek omhoog, naar de hemel, sprak een zegengebed uit, brak de broden in stukken en gaf die aan zijn leerlingen om uit te delen. Ook de twee vissen verdeelde Hij onder alle mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ze aten allen tot ze voldaan waren. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Daarna verzamelden ze de overgebleven brokken – wel twaalf manden vol – en de overgebleven vis. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Het aantal mannen dat had gegeten bedroeg vijfduizend. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Meteen daarna droeg Jezus zijn leerlingen op om in de boot te stappen en voor Hem uit naar Betsaïda over te steken terwijl Hij de menigte naar huis stuurde. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nadat Hij afscheid van hen had genomen, ging Hij de berg op om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Toen het avond werd, bevond de boot zich midden op het meer terwijl Hij nog alleen aan wal was. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hij zag dat de leerlingen zich hard moesten inspannen om vooruit te roeien, want ze hadden de wind tegen. Tegen het einde van de nacht ging Hij hen achterna, al wandelend over het water. Toen Hij hen zou voorbijgaan, ");
INSERT INTO nldgbv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","zagen ze Hem op het meer wandelen. Ze dachten dat Hij een spook was en schreeuwden het uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Iedereen zag Hem allemaal en waren doodsbang. Meteen sprak Hij hen toe: “Wees gerust, Ik ben het. Wees niet bang.” ");
INSERT INTO nldgbv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hij stapte bij hen in de boot en de wind ging liggen. Ze waren volkomen verbijsterd, ");
INSERT INTO nldgbv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","want ze hadden de les van de broden niet begrepen; hun hart was verstard. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eenmaal overgestoken, kwamen ze aan land bij Gennesaret, waar ze aanmeerden. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Zodra ze uit de boot stapten, herkenden de mensen Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ze doorkruisten de hele streek om hun zieken op draagmatten naar de plaats te dragen waarvan ze hoorden dat Hij daar was. ");
INSERT INTO nldgbv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","En waar Hij ook kwam – dorpen, steden of platteland – bracht men de zieken naar marktplaatsen en smeekte men Hem om slechts de kwast onderaan zijn mantel te mogen aanraken. Iedereen die Hem aanraakte, werd genezen. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","De farizeeën en enkele Schriftgeleerden die uit Jeruzalem waren gekomen, kwamen om Jezus heen staan. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ze hadden sommige van zijn leerlingen zien eten met onreine – dat wil zeggen: ongewassen – handen. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","De farizeeën, in feite alle Joodse mensen, eten namelijk niet zonder eerst grondig hun handen te wassen. Daarmee volgen ze de traditie van hun voorouders. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Als ze van de markt thuiskomen, eten ze pas nadat ze zich hebben gewassen. Ze volgen ook allerlei andere tradities, zoals het afwassen van bekers, kannen en kookpotten. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Daarom vroegen de farizeeën en de Schriftgeleerden aan Jezus: “Waarom leven uw leerlingen niet volgens de tradities van de voorouders, maar eten zij met onreine handen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hij antwoordde: “Jesaja had gelijk toen hij profeteerde over jullie, hypocrieten. Want er staat: ‘Dit volk bewijst Mij lippendienst, hun hart is ver van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zij vereren Mij tevergeefs, en ze onderwijzen menselijke voorschriften.’ ");
INSERT INTO nldgbv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jullie hebben Gods gebod losgelaten en houden je vast aan menselijke traditie.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hij vervolgde: “Jullie blinken uit in het verwerpen van Gods gebod om jullie eigen traditie na te leven. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mozes heeft immers gezegd: ‘Eer je vader en moeder’, en ‘Wie kwaadspreekt van zijn vader of moeder, moet ter dood worden gebracht.’ ");
INSERT INTO nldgbv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Maar jullie beweren dat als iemand tegen zijn vader of moeder zegt: ‘Wat ik aan jullie had kunnen geven, is korban’ – dat wil zeggen: aan God gewijd – ");
INSERT INTO nldgbv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","dat hij dan niets meer voor zijn vader of moeder mag doen. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Zo gebruiken jullie de traditie die aan jullie is doorgeven, om hetgeen God heeft gezegd ongeldig te verklaren. En jullie doen veel dergelijke dingen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jezus riep de menigte weer bij zich en zei: “Luister, iedereen, en begrijp het volgende: ");
INSERT INTO nldgbv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Niets dat van buitenaf bij iemand naar binnen gaat, kan hem verontreinigen. Integendeel, het zijn de dingen die uit een mens naar buiten komen, die hem verontreinigen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nadat Hij een huis was binnengegaan, weg van de menigte, vroegen zijn leerlingen Hem naar deze vergelijking. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hij antwoordde: “Hebben ook jullie nog altijd geen inzicht? Beseffen jullie niet dat niets dat van buitenaf de mens ingaat, hem kan verontreinigen? ");
INSERT INTO nldgbv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Het gaat namelijk niet naar zijn hart, maar naar zijn maag, en van daar weer naar buiten.” Door dat te zeggen verklaarde Jezus alle voedingswaren rein. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hij vervolgde: “Wat uit de mens naar buiten komt, dat verontreinigt hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Want het is van binnenuit, uit het hart van de mens, dat slechte gedachten voortkomen: seksueel wangedrag, diefstal, moord, ");
INSERT INTO nldgbv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","overspel, hebzucht, kwaadaardigheid, bedrog, losbandigheid, jaloezie, laster, arrogantie en dwaasheid. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Al deze slechte dingen komen van binnenuit en verontreinigen de mens.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jezus vertrok uit die plaats en ging naar de omgeving van Tyrus. Daar ging Hij een huis binnen en wilde niet dat iemand daarvan wist. Hij kon echter niet onopgemerkt blijven. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Er was namelijk een vrouw die een dochtertje had met een onreine geest. Zodra zij over Hem hoorde, kwam ze naar Hem toe en liet ze zich voor zijn voeten neervallen. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","De vrouw was een niet-Joodse, afkomstig van Syrofenicië. Ze smeekte Jezus om de demon uit haar dochter te drijven. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Maar Hij zei tegen haar: “Laat eerst de kinderen voldoende eten, want het is niet goed om het brood van de kinderen af te nemen en aan de hondjes te geven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Zij antwoordde: “Heer, de hondjes onder de tafel eten toch van wat de kinderen morsen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hij zei tegen haar: “Omdat je dat antwoord geeft, kun je gerust naar huis; de demon is uit je dochter weggegaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Zij ging naar huis en zag dat haar kind in bed lag en de demon was weggegaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Toen vertrok Jezus uit de omgeving van Tyrus. Via Sidon reisde Hij naar het Meer van Galilea, dwars door het gebied van Dekapolis. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Daar werd iemand bij Hem gebracht, die doof was en moeite had met praten. Men smeekte Jezus om zijn hand op hem te leggen. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nadat Hij hem apart had genomen, bij de menigte vandaan, stak Jezus zijn vingers in de oren van de man, spuwde Hij en raakte Hij de tong van de man aan. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Toen keek Hij omhoog naar de hemel, en zuchtte diep en zei tegen hem: “Effata”. Dat betekent: ga open! ");
INSERT INTO nldgbv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Meteen werkten zijn oren en tong naar behoren en sprak hij normaal. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jezus droeg hun op het aan niemand te vertellen, maar hoe meer Hij het verbood, hoe meer de mensen het bekendmaakten. ");
INSERT INTO nldgbv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ze waren diep onder de indruk en zeiden: “Alles wat Hij heeft gedaan is goed. Hij zorgt er zelfs voor dat de doven kunnen horen en de stomme mensen kunnen spreken.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Op een keer was er weer een grote menigte en omdat ze geen eten hadden, riep Jezus zijn leerlingen bij zich. Hij zei: ");
INSERT INTO nldgbv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ik heb medelijden met al die mensen, want ze zijn al drie dagen bij Me en nu hebben ze niets te eten. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Als Ik hen met een lege maag wegstuur, zullen ze onderweg bezwijken, want sommigen zijn van ver gekomen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Zijn leerlingen antwoordden: “Waar in dit afgelegen gebied kan voldoende brood worden gevonden voor al deze mensen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jezus vroeg hen: “Hoeveel broden hebben jullie?” “Zeven”, antwoordden ze. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hij droeg de menigte op om op de grond plaats te nemen. Hij nam de zeven broden, sprak een dankgebed uit, brak ze in stukken en gaf die aan zijn leerlingen om uit te delen, en zij bezorgden de stukken brood aan de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Men had ook enkele visjes. Hij sprak een zegen uit en liet ook die uitdelen. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","De mensen aten tot ze voldaan waren. Toen werden de overgebleven brokken verzameld: zeven korven vol. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Er waren ongeveer vierduizend mensen en Hij stuurde hen naar huis. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Meteen stapte Hij met zijn leerlingen in de boot en ging naar het gebied van Dalmanuta. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","De farizeeën kwamen naar Hem toe en begonnen met Hem te discussiëren. Om Hem op de proef te stellen vroegen ze Hem om een teken uit de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jezus zuchtte diep en zei: “Waarom vragen jullie om een teken? Ik verzeker jullie, aan jullie soort mensen zal beslist geen teken worden gegeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hij ging bij hen weg en voer terug naar de overkant. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jezus' leerlingen waren vergeten brood mee te nemen; ze hadden maar één brood bij zich in de boot. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jezus waarschuwde hen: “Pas op, kijk uit voor de desem van de farizeeën en ook voor de desem van Herodes.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ze bespraken met elkaar of Hij dat had gezegd omdat ze geen brood hadden. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jezus merkte het en vroeg hun: “Waarom zijn jullie aan het bespreken dat jullie geen brood hebben? Begrijpen en beseffen jullie het nog steeds niet? Is jullie hart verstard? ");
INSERT INTO nldgbv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zien jullie niet met de ogen die jullie hebben en horen jullie niet met de oren die jullie hebben? En weten jullie niet meer ");
INSERT INTO nldgbv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","hoeveel manden vol brokken jullie verzamelden toen Ik de vijf broden brak voor de vijfduizend?” Ze zeiden: “Twaalf”. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“En de zeven broden voor de vierduizend, hoeveel korven vol brokken verzamelden jullie toen?” Ze antwoordden: “Zeven”. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hij zei tegen hen: “Begrijpen jullie het dan nog niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ze kwamen in Betsaïda. De mensen brachten iemand bij Jezus die blind was en ze smeekten Hem om hem aan te raken. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jezus nam de blinde man bij de hand en leidde hem het dorp uit. Daar spuwde Hij in de ogen van de man, legde hem de handen op en vroeg: “Zie je al iets?” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","De man probeerde te kijken en zei: “Ik zie mensen, ze zien eruit als wandelende bomen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jezus legde zijn handen nogmaals op de ogen van de man. Nu kon hij goed zien en was hij genezen; hij zag alles duidelijk. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jezus stuurde hem naar huis en zei: “Ga zelfs het dorp niet in!” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jezus en zijn leerlingen trokken verder, naar de dorpen bij Caesarea Filippi. Onderweg vroeg Hij hun: “Wie zeggen de mensen dat Ik ben?” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ze antwoordden: “Johannes de Doper; anderen zeggen Elia, en nog anderen een van de profeten.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hij vroeg hun: “En jullie, wie zeggen jullie dat Ik ben?” Petrus antwoordde: “U bent de Messias.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jezus beval hun, aan niemand te vertellen wie Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ook begon Hij hun te leren dat de Mensenzoon veel lijden zou moeten doorstaan, dat Hij verworpen zou worden door de oudsten, hoofdpriesters en Schriftgeleerden, en dat Hij zou worden gedood en na drie dagen zou verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hij sprak er openlijk over, maar Petrus nam Hem apart en begon Hem te berispen. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jezus draaide zich om, keek zijn leerlingen aan en berispte Petrus door te zeggen: “Ga weg, uit mijn ogen, jij satan! Het gaat jou niet om Gods belangen, maar om die van de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Toen riep Hij de menigte bij zich, samen met zijn leerlingen, en zei: “Als iemand Mij wil volgen, moet hij zichzelf verloochenen, zijn kruis opnemen en Mij volgen. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Want wie zijn leven wil redden, zal het verliezen, maar wie zijn leven loslaat voor Mij en voor het evangelie, zal het redden. ");
INSERT INTO nldgbv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Immers, wat heeft een mens eraan om de hele wereld te winnen als hij zijn leven verliest? ");
INSERT INTO nldgbv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","En wat kan een mens geven in ruil voor zijn leven? ");
INSERT INTO nldgbv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Als iemand zich voor Mij en mijn woorden schaamt in deze overspelige en zondige tijd, zal de Mensenzoon zich voor hem schamen wanneer Hij komt met de heilige engelen, in de hemelse pracht die zijn Vader omringt.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jezus zei tegen hen: “Ik verzeker jullie, sommigen die hier staan zullen niet sterven voordat ze Gods koninkrijk op krachtige wijze hebben zien komen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Zes dagen later nam Jezus Petrus, Jakobus en Johannes mee een hoge berg op, waar ze alleen waren. Daar veranderde Hij voor hun ogen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zijn kleren werden stralend wit, zo wit als niemand op aarde ze kan maken. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Toen verschenen Elia en Mozes aan hen; ze waren met Jezus in gesprek. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrus onderbrak hen en zei tegen Jezus: “Rabbi, het is goed dat wij hier zijn. Laten we drie hutten bouwen: een voor U, een voor Mozes en een voor Elia.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hij wist niet hoe te reageren, want ze waren hevig geschrokken. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Toen kwam er een wolk die een schaduw over hen wierp. Vanuit de wolk klonk een stem: “Dit is mijn dierbare Zoon. Luister naar Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Plots, toen ze om zich heen keken, zagen ze niemand meer en was enkel Jezus nog bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tijdens hun afdaling van de berg droeg Jezus hun op, aan niemand te vertellen wat ze hadden gezien zolang de Mensenzoon nog niet uit de dood was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ze hielden het gebeurde voor zich, maar onderling bespraken ze wel wat Hij bedoelde met “uit de dood verrijzen”. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ook vroegen ze Hem: “Waarom zeggen de Schriftgeleerden dat Elia eerst moet komen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hij antwoordde: “Elia komt inderdaad eerst alles in orde maken. Waarom zou er dan over de Mensenzoon in de Schriften staan dat Hij veel moet lijden en slecht behandeld gaat worden? ");
INSERT INTO nldgbv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Maar Ik zal jullie iets vertellen: Elia is reeds gekomen en ze hebben hem alles aangedaan wat ze wilden, zoals over hem in de Schriften staat.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Toen ze bij de andere leerlingen kwamen, zagen ze dat er een grote menigte om hen heen stond en er Schriftgeleerden met hen discussieerden. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zodra alle mensen Jezus zagen, waren ze volkomen verrast en haastten ze zich naar Hem toe om Hem te begroeten. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hij vroeg hun: “Waarover zijn jullie aan het discussiëren?” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iemand uit de menigte antwoordde: “Leraar, ik kwam mijn zoon bij U brengen; hij heeft een geest in zich waardoor hij niet kan praten. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Overal waar deze hem overmant, gooit hij hem tegen de grond. Dan staat het schuim op zijn lippen, knarst hij met zijn tanden en verstijft hij. Ik heb uw leerlingen gevraagd om de geest uit te drijven, maar dat lukte hun niet.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jezus antwoordde: “O, ongelovige mensen, hoelang zal Ik nog bij jullie zijn? Hoelang zal Ik jullie nog verdragen? Breng hem bij Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Toen brachten ze de jongen bij Hem. Zodra de geest Jezus zag, zorgde hij dat de jongen begon te stuiptrekken. Hij viel op de grond en rolde heen en weer met het schuim op zijn lippen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jezus vroeg aan de vader: “Hoe lang gebeurt dit al met hem?” De vader zei: “Van kleins af aan. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","De geest heeft hem zelfs vaak in het vuur of het water gegooid om hem om te brengen. Maar als U iets kan doen, help ons dan, heb medelijden met ons.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jezus zei tegen hem: “Waarom zeg je: ‘Als U iets kan doen’? Voor wie gelooft is alles mogelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","De vader van het kind riep meteen uit: “Ik geloof! Kom mijn ongeloof te hulp!” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Toen Jezus zag dat er veel mensen op hen afkwamen, beval Hij de onreine geest: “Jij doofstomme geest, Ik gebied je om uit hem weg te gaan en nooit weer in hem binnen te gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Met veel stuiptrekkingen en geschreeuw ging de geest uit hem weg. De jongen bleef voor dood liggen. Veel mensen zeiden: “Hij is gestorven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Maar Jezus nam hem bij de hand en hielp hem overeind. En hij stond op. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nadat Jezus ergens naar binnen was gegaan en ze met Hem alleen waren, vroegen zijn leerlingen: “Waarom konden wij die geest niet uitdrijven?” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hij antwoordde: “Dit soort kan enkel worden uitgedreven door middel van gebed.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ze vertrokken uit die plaats en reisden door Galilea, maar Hij wilde niet dat iemand dat wist. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hij was namelijk zijn leerlingen aan het onderwijzen. Hij zei tegen hen: “De Mensenzoon zal aan de mensen worden uitgeleverd. Hij zal worden gedood en na drie dagen zal Hij verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Maar ze begrepen deze uitspraak niet en durfden Hem niet om uitleg te vragen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Toen ze in Kafarnaüm waren aangekomen en thuis waren, vroeg Hij hen: “Waarover waren jullie onderweg aan het discussiëren?” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Maar ze zwegen, want ze hadden onderweg gediscussieerd over wie van hen de belangrijkste was. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hij ging zitten, riep de Twaalf bij zich en zei: “Wie de belangrijkste wil zijn, moet de minste van allen zijn en iedereen dienen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hij nam een kind, zette het tussen hen in, sloeg zijn armen er omheen en zei: ");
INSERT INTO nldgbv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wie een kind als dit in mijn naam verwelkomt, verwelkomt Mij; en wie Mij verwelkomt, verwelkomt niet Mij maar Degene die Mij heeft gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannes zei tegen Hem: “Leraar, wij zagen iemand in uw naam demonen uitdrijven en wij wilden het hem verbieden omdat hij niet bij ons hoort.” ");
INSERT INTO nldgbv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jezus antwoordde: “Verbied het hem niet, want niemand kan in mijn naam een wonder doen en onmiddellijk daarna iets lelijks over Mij zeggen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Want wie niet tegen ons is, is voor ons. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ik verzeker jullie, wie in mijn naam een beker water aan jullie geeft, zal zijn beloning zeker niet mislopen. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","En wie een van deze eenvoudige mensen die in Mij geloven tot zonde aanzet, zou beter af zijn als men een zware molensteen om zijn nek zou hangen en hem in zee zou gooien. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","En als je hand jou tot zonde aanzet, hak haar dan maar af. Je kan beter verminkt het leven binnengaan dan met twee handen in de hel terechtkomen, in het onuitblusbare vuur. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","En als je voet jou tot zonde aanzet, hak hem dan maar af. Je kan beter gehandicapt het leven binnengaan dan in het bezit van twee voeten in de hel worden gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","En als je oog jou tot zonde aanzet, haal het dan maar weg. Je kan beter met één oog Gods koninkrijk binnengaan dan in het bezit van twee ogen in de hel worden gegooid, ");
INSERT INTO nldgbv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","waar ‘de wormen die aan hen vreten nooit doodgaan en het vuur niet wordt gedoofd’. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Want iedereen zal met vuur worden gezouten. ");
INSERT INTO nldgbv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zout is goed, maar als het zout smaakloos wordt, hoe kan je het dan zouten? Zorg dat er zout in jullie zit en bewaar de vrede met elkaar.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Toen vertrok Jezus. Via de overkant van de Jordaan kwam Hij aan in het gebied Judea. Opnieuw kwamen er grote aantallen mensen om Hem heen staan en opnieuw onderwees Hij hun, zoals Hij gewoon was. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Enkele farizeeën kwamen Hem op de proef stellen door te vragen: “Mag een man zijn vrouw wegsturen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hij antwoordde: “Wat heeft Mozes jullie geboden?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ze zeiden: “Mozes gaf toestemming om een echtscheidingsakte te schrijven en haar weg te sturen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jezus antwoordde: “Het was omdat jullie koppig zijn dat Mozes dat gebod voor jullie opschreef. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maar vanaf het begin van de schepping heeft God hen ‘mannelijk en vrouwelijk gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Daarom zal een man zijn vader en moeder verlaten en zich aan zijn vrouw verbinden, ");
INSERT INTO nldgbv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","en ze zullen samen een nieuw lichaam vormen.’ Ze zijn dus niet langer twee lichamen, maar één. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Daarom moet een mens niet scheiden wat God heeft samengevoegd.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Toen ze weer thuis waren, vroegen zijn leerlingen Hem om uitleg. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hij zei tegen hen: “Iemand die zijn vrouw wegstuurt en met een ander trouwt, pleegt echtbreuk ten opzichte van zijn vrouw. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","En als een vrouw bij haar man weggaat en met een ander trouwt, pleegt zij echtbreuk.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Er werden kinderen bij Jezus gebracht met de bedoeling dat Hij hen zou aanraken, maar zijn leerlingen berispten de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Toen Jezus dat zag, zei Hij verontwaardigd tegen hen: “Laat de kinderen bij Mij komen; houd hen niet tegen, want Gods koninkrijk is bestemd voor wie is zoals zij. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ik verzeker jullie, wie Gods koninkrijk niet aanvaardt als een kind, zal het in geen geval binnengaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hij nam de kinderen in zijn armen en zegende hen door middel van handoplegging. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Toen Hij aanstalten maakte om te vertrekken, kwam er iemand naar Hem toe, knielde voor Hem neer en vroeg: “Goede leraar, wat moet ik doen om het eeuwig leven te ontvangen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jezus vroeg hem: “Waarom noem je Mij goed? Behalve God is niemand goed. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Je kent toch de geboden? Pleeg geen moord, pleeg geen echtbreuk, steel niet, leg geen leugenachtige verklaring af, bedrieg niemand, eer je vader en moeder.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","De man antwoordde: “Leraar, aan al die dingen heb ik me van jongs af aan gehouden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jezus keek hem aan, kreeg sympathie voor hem en zei: “Eén ding ontbreekt je nog; ga verkopen wat je hebt en geef de opbrengst aan de armen; dan zal je een schat in de hemel hebben. Kom dan terug en volg Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","De man was teleurgesteld over dat antwoord en ging aangeslagen weg, want hij had veel bezittingen. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jezus keek om zich heen en zei tegen zijn leerlingen: “Wat is het moeilijk voor rijken om Gods koninkrijk binnen te gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","De leerlingen stonden versteld van zijn woorden. Jezus herhaalde: “Mijn kinderen, wat is het moeilijk om Gods koninkrijk binnen te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Het is gemakkelijker voor een kameel om door het oog van een naald te kruipen dan voor een rijke om Gods koninkrijk binnen te gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nu waren ze helemaal ontdaan. Ze zeiden tegen elkaar: “Maar wie kan dan worden gered?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jezus keek hen aan en zei: “Bij de mensen is het onmogelijk, maar bij God niet, want bij Hem is alles mogelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus reageerde: “Kijk eens, wij hebben alles achtergelaten om U te volgen!” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jezus zei: “Ik verzeker jullie, er is niemand die zijn huis, broers, zussen, moeder, vader, kinderen of akkers heeft achtergelaten voor Mij en het evangelie, ");
INSERT INTO nldgbv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","die niet honderdmaal zoveel terugkrijgt: nu in deze tijd huizen, broers, zussen, moeders, kinderen en akkers, maar ook vervolgingen, en in de toekomst het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Maar veel eersten zullen de laatsten zijn, en veel laatsten de eersten.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nu waren ze onderweg naar Jeruzalem; Jezus wandelde voorop. Zijn leerlingen waren verbijsterd en de mensen die met hen meekwamen waren bang. Opnieuw nam Hij de Twaalf apart en begon Hij hun te vertellen wat er met Hem zou gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hij zei: “Luister, we gaan naar Jeruzalem. Daar zal de Mensenzoon worden uitgeleverd aan de hoofdpriesters en Schriftgeleerden. Zij zullen Hem ter dood veroordelen en Hem aan de niet-Joden uitleveren. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","En die zullen Hem bespotten, bespuwen, geselen en doden, maar na drie dagen zal Hij verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Toen kwamen Jakobus en Johannes, de zonen van Zebedeüs, Hem vragen: “Leraar, wij zouden U willen vragen om iets voor ons te doen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hij vroeg: “Wat willen jullie dat Ik voor je doe?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Zij vroegen Hem: “Zou één van ons rechts en de ander links van U mogen zitten in uw hemel?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jezus antwoordde: “Jullie weten niet wat jullie vragen. Kunnen jullie dezelfde beker leegdrinken als Ik, of dezelfde doop ondergaan als Ik?” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Zij antwoordden: “Dat kunnen we.” Jezus zei tegen hen: “Jullie zullen dezelfde beker leegdrinken als Ik, en dezelfde doop ondergaan als Ik. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Maar het is niet aan Mij om te bepalen wie rechts of links van Mij mag zitten. Die plaatsen zijn voor de mensen voor wie ze zijn bestemd.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Toen de tien andere leerlingen van Jezus hiervan hoorden, werden ze kwaad op Jakobus en Johannes. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jezus riep hen bij zich en zei: “Jullie weten dat het bij de andere volken zo is dat zij die als leiders worden beschouwd, de baas over hen spelen en dat hun heersers hun gezag over hen laten gelden. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Maar bij jullie is dat niet zo. Integendeel, wie onder jullie belangrijk wil worden, moet jullie dienaar zijn ");
INSERT INTO nldgbv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","en wie onder jullie vooraanstaand wil zijn, moet de slaaf van iedereen zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Want zelfs de Mensenzoon is niet gekomen om te worden gediend, maar om te dienen en zijn leven te geven als losgeld voor velen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Toen kwamen ze aan in Jericho. En toen Jezus en zijn leerlingen samen met een grote menigte Jericho verlieten, zat er een blinde bedelaar aan de kant van de weg. Hij heette Bartimeüs, wat “zoon van Timeüs” betekent. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Toen hij hoorde dat Jezus van Nazaret er was, begon hij luid te roepen: “Zoon van David, Jezus, heb medelijden met mij!” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Veel mensen snauwden hem toe dat hij moest zwijgen, maar hij riep nog luider: “Zoon van David, heb medelijden met mij!” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jezus hield halt en zei: “Roep hem maar.” Toen riepen ze naar de blinde man: “Wees gerust en sta op, want Hij roept je.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","De man deed snel zijn mantel uit, sprong overeind en kwam naar Jezus toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jezus vroeg hem: “Wat wil je dat Ik voor je doe?” De blinde man antwoordde: “Rabboeni, ik wil graag weer zien.” ");
INSERT INTO nldgbv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jezus zei tegen hem: “Ga, je geloof heeft je genezen.” De man kon meteen weer zien en kwam achter Hem aan toen Hij zijn weg vervolgde. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Toen ze in de buurt van Jeruzalem kwamen – bij Betfagé en Betanië, die tegen de Olijfberg liggen – stuurde Jezus twee van zijn leerlingen vooruit. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Hij zei tegen hen: “Ga naar het dorp dat voor jullie ligt. Meteen bij het binnengaan zullen jullie een vastgebonden jonge ezel zien, die nog nooit door iemand is bereden. Maak hem los en breng hem hier. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Als iemand jullie vraagt: ‘Wat doen jullie daar?’, zeg dan: ‘De Heer heeft hem nodig en zal hem meteen naar hier terugsturen.’” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ze vertrokken en troffen een jonge ezel aan op straat, vastgebonden bij een deur. Toen ze hem losmaakten, ");
INSERT INTO nldgbv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vroegen enkele mensen die daar stonden: “Waarom maken jullie die ezel los?” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ze antwoordden overeenkomstig Jezus' instructies en de mensen lieten hen begaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Toen ze de jonge ezel bij Jezus hadden gebracht en hun mantels erop hadden gelegd, ging Hij erop zitten. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Veel mensen spreidden hun mantels uit op de weg, anderen takken met bladeren die ze in de velden hadden gekapt. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","De mensen die voor en achter Hem wandelden, riepen: “Hosanna! Gezegend is Hij die komt in de naam van de Heer! ");
INSERT INTO nldgbv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gezegend is het komende koninkrijk van onze vader David! Hosanna aan de Allerhoogste!” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jezus ging Jeruzalem binnen, het tempelterrein op. Nadat Hij alles uitgebreid had bekeken en het laat was geworden, ging Hij met de Twaalf naar Betanië. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","De volgende ochtend, toen ze Betanië weer verlieten, kreeg Hij honger. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hij zag in de verte een vijgenboom in blad staan en ging kijken of er iets eetbaars aan zat. Eenmaal bij de boom vond Hij alleen maar bladeren, want het was niet de juiste tijd voor vijgen. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hij zei tegen de boom: “Laat niemand ooit nog vruchten van jou eten!” Zijn leerlingen hoorden wat Hij zei. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Toen ze in Jeruzalem waren aangekomen, ging Hij het tempelterrein op. Daar begon Hij de mensen weg te jagen die op het tempelterrein aan het kopen of verkopen waren. Hij gooide de tafels van de geldwisselaars en de zitbanken van de duivenverkopers omver ");
INSERT INTO nldgbv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","en liet niet toe dat iemand voorwerpen over het tempelterrein droeg. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hij legde aan hen uit: “Er staat toch in de Schriften: ‘Mijn huis zal een gebedshuis voor alle volken worden genoemd’? Maar jullie hebben er een rovershol van gemaakt.” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","De hoofdpriesters en de Schriftgeleerden hoorden het. Ze zochten naar een manier om Hem om te brengen, want ze waren bang voor Hem omdat de hele menigte diep onder de indruk was van zijn onderwijs. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Toen het avond werd, gingen Jezus en zijn leerlingen de stad uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Toen ze de volgende ochtend op de terugweg waren, zagen ze dat de vijgenboom vanaf de wortels was verdord. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus herinnerde zich wat er eerder was gebeurd en zei tegen Jezus: “Rabbi, kijk, de vijgenboom die U had vervloekt is verdord.” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jezus antwoordde: “Geloof maar in God. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ik verzeker jullie, als iemand tegen deze berg zegt: kom van je plaats en stort jezelf in zee, en in zijn hart niet twijfelt maar gelooft dat wat hij zegt zal gebeuren, dan zal het voor hem worden gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Daarom zeg Ik jullie: als je ergens om vraagt in je gebed, wat het ook is, geloof dat je het hebt ontvangen en je zal het krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","En wanneer je staat te bidden terwijl je iets tegen iemand hebt, vergeef het hem; dan zal je hemelse Vader ook jouw zonden vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ze kwamen opnieuw in Jeruzalem en terwijl Jezus over het tempelterrein wandelde, kwamen de hoofdpriesters, de Schriftgeleerden en de oudsten naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ze vroegen Hem: “Op grond van welke bevoegdheid doet U deze dingen? En wie heeft de bevoegdheid gegeven om ze te doen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jezus antwoordde: “Ik zal jullie één vraag stellen. Als jullie Mij antwoorden, zal Ik jullie vertellen op grond van welke bevoegdheid Ik deze dingen doe. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","De doop van Johannes, kwam die van God of van de mensen? Wat is jullie antwoord?” ");
INSERT INTO nldgbv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ze overlegden met elkaar: “Als we zeggen: van God, zal Hij zeggen: Waarom geloven jullie hem dan niet? ");
INSERT INTO nldgbv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Maar als we zeggen: van de mensen …” Ze waren bang voor de menigte, want iedereen was ervan overtuigd dat Johannes werkelijk een profeet was. ");
INSERT INTO nldgbv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Daarom antwoordden ze Jezus: “Wij weten het niet.” Toen zei Jezus tegen hen: “Dan vertel Ik jullie ook niet op grond van welke bevoegdheid Ik deze dingen doe.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Toen begon Hij hun parabels te vertellen: “Iemand plantte een wijngaard aan, plaatste een omheining, groef een wijnperskuil en bouwde een wachttoren. Toen verpachtte hij de wijngaard aan wijnbouwers en ging op reis. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","In de oogsttijd stuurde hij een knecht naar de wijnbouwers om zijn aandeel in de opbrengst van de wijngaard van hen te ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Maar ze grepen hem, sloegen hem in elkaar en stuurden hem met lege handen weg. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vervolgens stuurde hij een andere knecht naar hen toe, maar ze sloegen hem op het hoofd en vernederden hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hij stuurde nog iemand, maar hem doodden ze. Hij stuurde er nog veel meer, en sommigen daarvan sloegen ze in elkaar, anderen doodden ze. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Toen hij uiteindelijk maar één persoon over had, zijn dierbare zoon, stuurde hij hem, want hij dacht: mijn zoon zullen ze wel respecteren. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Maar de wijnbouwers zeiden tegen elkaar: ‘Dit is de erfgenaam. Kom, laten we hem doden; dan is de erfenis van ons.’ ");
INSERT INTO nldgbv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ze grepen hem, doodden hem en gooiden hem de wijngaard uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wat gaat de eigenaar van de wijngaard nu doen? Hij zal komen, de wijnbouwers ombrengen en de wijngaard aan anderen geven. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hebben jullie dit Schriftgedeelte niet gelezen: ‘De steen die de bouwers hebben afgekeurd, is de hoeksteen geworden; ");
INSERT INTO nldgbv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","de Heer heeft hiervoor gezorgd, het is verbazingwekkend om te zien’?” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Toen wilden de hoofdpriesters, Schriftgeleerden en oudsten Jezus arresteren, want ze beseften dat de parabel over hen ging. Maar ze lieten Hem met rust en vertrokken, omdat ze bang waren voor de menigte. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Later stuurden ze enkele farizeeën en aanhangers van Herodes op Hem af om Hem in zijn eigen woorden te vangen. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Toen ze bij Hem waren gekomen, zeiden ze: “Leraar, wij weten dat U oprecht bent. U laat zich door niemand beïnvloeden en praat niemand naar de mond, maar U onderwijst naar waarheid hoe men Gods weg moet bewandelen. Is het toegestaan om de keizerlijke belasting te betalen, of niet? Moeten we betalen, of mag het niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Maar Jezus doorzag hun hypocrisie. Hij zei: “Waarom stellen jullie Mij op de proef? Breng Mij een denarie en laat Me die zien.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ze brachten Hem een munt en Hij vroeg: “Wie staat hierop afgebeeld? En welke naam staat erop?” Ze antwoordden: “Van de keizer.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jezus zei tegen hen: “Geef dan aan de keizer wat van de keizer is, en aan God wat van God is.” Toen waren ze stomverbaasd over Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Daarna kwamen er sadduceeën bij Hem. (Sadduceeën beweren dat er geen verrijzenis is.) Zij vroegen Hem: ");
INSERT INTO nldgbv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Leraar, volgens de geschriften van Mozes moet iemand van wie de broer sterft en een vrouw maar geen kinderen nalaat, met de weduwe trouwen en zo voor nakomelingen zorgen voor zijn gestorven broer. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maar er waren eens zeven broers. De eerste trouwde, maar hij stierf kinderloos. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","De tweede broer trouwde met de weduwe, maar stierf ook zonder nakomelingen. Zo verging het ook de derde. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","De zeven broers lieten geen nakomelingen achter en als laatste van allen stierf de vrouw. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Van wie wordt zij de echtgenote bij de verrijzenis? Want ze zijn alle zeven met haar getrouwd geweest!” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jezus zei tegen hen: “Jullie zitten op een dwaalspoor. Komt dat niet doordat jullie noch de Schriften, noch Gods macht begrijpen? ");
INSERT INTO nldgbv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanneer de mensen uit de dood verrijzen, trouwen ze niet, maar zijn ze als engelen in de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","En wat de verrijzenis van de doden betreft, hebben jullie niet in het boek van Mozes gelezen, in het gedeelte over de doornstruik, dat God tegen hem zei: ‘Ik ben de God van Abraham, de God van Isaak en de God van Jakob’? ");
INSERT INTO nldgbv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hij is niet de God van doden, maar van levenden. Jullie zitten er ver naast.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Een van de Schriftgeleerden was dichterbij gekomen, had hen horen debatteren, besefte dat Jezus hun een goed antwoord had gegeven, en vroeg Hem: “Welk gebod is het belangrijkste van al?” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jezus antwoordde: “Het belangrijkste gebod is: Luister, Israël! De Heer is onze God, de Heer is één. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Heb de Heer, je God, lief met heel je hart, met heel je ziel, met heel je verstand en met al je kracht. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Het tweede is: Heb je naaste lief zoals je jezelf liefhebt. Er bestaat geen belangrijker gebod dan deze twee.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","De Schriftgeleerde zei: “Dat is juist, Leraar. Er is inderdaad maar één God; een ander is er niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hem liefhebben met heel je hart, heel je verstand en al je kracht en je naaste liefhebben zoals je jezelf liefhebt is belangrijker dan alle soorten offers.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Toen Jezus zag dat de Schriftgeleerde een verstandig antwoord had gegeven, zei Hij tegen hem: “U bevindt zich niet ver van Gods koninkrijk.” Nu durfde niemand nog vragen aan Hem te stellen. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tijdens het onderwijzen op het tempelterrein vroeg Jezus: “Waarom zeggen de Schriftgeleerden dat de Messias de zoon van David is? ");
INSERT INTO nldgbv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David verklaarde toch zelf, aangestuurd door de Heilige Geest: ‘De Heer zei tegen mijn Heer: neem plaats aan mijn rechterzijde, totdat Ik je vijanden aan Je heb onderworpen.’ ");
INSERT INTO nldgbv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David zelf noemt Hem zijn Heer. Hoe kan Hij dan zijn zoon zijn?” Het grote publiek luisterde graag naar Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tijdens het onderwijzen zei Jezus ook: “Pas op voor de Schriftgeleerden. Zij houden ervan, in prachtige gewaden rond te wandelen, met respect te worden begroet op het marktplein, ");
INSERT INTO nldgbv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","en de beste plaatsen in te nemen in de synagogen en bij feestmalen. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Maar ze slokken de huizen van weduwen op en bidden lange gebeden voor de schijn. Ze zullen extra zwaar worden gestraft.” ");
INSERT INTO nldgbv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jezus ging tegenover de offerkist zitten en keek hoe de mensen er geld in staken. Veel rijke mensen gaven grote bedragen, ");
INSERT INTO nldgbv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","maar een arme weduwe stak er twee kopermuntjes in ter waarde van een kwadrans. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jezus riep zijn leerlingen bij zich en zei tegen hen: “Ik verzeker jullie dat deze arme weduwe meer in de offerkist heeft gestoken dan alle anderen. ");
INSERT INTO nldgbv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Want zij gaven allen iets vanuit hun overvloed, maar deze vrouw gaf vanuit haar armoede alles wat ze had, haar hele levensonderhoud.” ");
INSERT INTO nldgbv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bij het verlaten van het tempelterrein zei een van Jezus' leerlingen tegen Hem: “Kijk, Leraar, wat een prachtige stenen en enorme gebouwen!” ");
INSERT INTO nldgbv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jezus antwoordde: “Zie je al die grote gebouwen? Niet één steen hier zal op de andere worden gelaten; het zal allemaal worden verwoest.” ");
INSERT INTO nldgbv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Later, toen Jezus tegenover het tempelterrein op de Olijfberg zat en alleen was met Petrus, Jakobus, Johannes en Andreas, vroegen zij Hem: ");
INSERT INTO nldgbv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kunt U ons vertellen wanneer dat zal zijn en wat het teken zal zijn dat het allemaal op het punt staat te gebeuren?” ");
INSERT INTO nldgbv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jezus begon hen toe te spreken: “Pas op dat niemand jullie misleidt. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Er zullen veel mensen komen die zich mijn naam toe-eigenen en zich voor Mij uitgeven; zij zullen veel mensen misleiden. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","En wanneer jullie horen van oorlogen en oorlogsdreiging, maak je dan niet ongerust. Die dingen moeten gebeuren, maar het einde is dan nog niet aangebroken. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Want volken en koninkrijken zullen tegen elkaar oorlogvoeren, op allerlei plaatsen zullen er aardbevingen plaatsvinden, en er komen hongersnoden. Dat is het begin van de weeën. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Wees dus op je hoede. Jullie zullen aan stadsraden worden uitgeleverd en in synagogen worden gegeseld. Omwille van Mij zullen jullie voor heersers en koningen terechtstaan om tegenover hen te getuigen van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","En eerst moet aan alle volken het evangelie worden verkondigd. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wanneer jullie worden gearresteerd en overgeleverd, wees dan niet ongerust over wat je zal zeggen. Zeg gewoon wat je op dat moment wordt ingegeven; dan ben je het namelijk niet zelf die spreekt, maar de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","De ene broer zal de andere uitleveren om te worden omgebracht, en een vader zijn kind; kinderen zullen tegen hun ouders in opstand komen en hen laten ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jullie zullen door iedereen worden gehaat omwille van mijn naam, maar wie standhoudt tot het einde, zal worden gered. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wanneer jullie dan de ‘verwoestende gruwel’ zien staan waar hij niet hoort – lezer, begrijp wat dit betekent – moeten de mensen in Judea de bergen invluchten. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wie zich op het dakterras bevindt, moet niet naar beneden of naar binnen gaan om iets uit huis mee te nemen. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wie zich op het land bevindt, moet niet terugkeren om zijn mantel op te halen. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Het zal verschrikkelijk zijn voor vrouwen die in die periode zwanger zijn of borstvoeding geven. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bid dat het niet in de winter plaatsvindt, ");
INSERT INTO nldgbv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","want tijdens die periode zal er leed zijn zoals er nog nooit is geweest van het begin van Gods schepping tot nu, en zoals er daarna nooit meer zal zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","En als de Heer die periode niet zou hebben ingekort, zou geen mens het overleven. Maar Hij heeft die periode ingekort in het belang van de uitverkorenen, de mensen die Hij heeft uitgekozen. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Als iemand dan tegen jullie zegt: ‘Kijk, hier is de Messias!’, of: ‘Kijk, daar is Hij!’, geloof het dan niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Want er zullen valse messiassen en valse profeten opstaan, die tekenen en wonderen doen om zo mogelijk de uitverkorenen te misleiden. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wees dus op je hoede. Ik heb jullie gewaarschuwd. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Maar dan, na dat leed, zal de zon verduisteren en de maan geen licht geven, ");
INSERT INTO nldgbv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zullen de sterren uit de lucht vallen en de hemellichamen uit koers raken. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","En dan zal men de Mensenzoon in de wolken zien komen, met veel macht en hemelse pracht. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dan zal Hij de engelen eropuit sturen om zijn uitverkorenen vanuit de vier windstreken, uit alle uithoeken van de wereld, samen te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Leer daarom van de volgende vergelijking met de vijgenboom: zodra zijn takken uitlopen en de bladeren verschijnen, weet je dat het bijna zomer is. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Op dezelfde manier kunnen jullie, wanneer je deze dingen ziet gebeuren, weten dat het voor de deur staat. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ik verzeker jullie, dit volk zal niet vergaan voordat dit alles gebeurt. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","De hemel en de aarde zullen vergaan, maar mijn woorden zullen nooit vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Maar op welke dag en welk tijdstip dat zal gebeuren weet niemand; zelfs de engelen in de hemel niet, ook de Zoon niet, enkel de Vader. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pas op, wees waakzaam, want jullie weten niet wanneer het zover is. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Het is als bij iemand die op reis gaat: hij draagt het beheer van zijn huis aan zijn dienaren over door aan elk van hen een taak te geven, en hij geeft de portier opdracht om op de uitkijk te staan. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wees dus waakzaam, want jullie weten niet op welk tijdstip de eigenaar van het huis terugkomt: 's avonds, tegen middernacht, in de kleine uurtjes of vlak voor de ochtend aanbreekt. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zorg dat hij je niet slapend aantreft wanneer hij plots komt. ");
INSERT INTO nldgbv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wat Ik jullie zeg, zeg Ik aan iedereen: wees waakzaam.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Het was twee dagen voor Pesach en het Feest van de Ongedesemde Broden. De hoofdpriesters en Schriftgeleerden zonnen op een list om Jezus te kunnen oppakken en doden. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Maar niet tijdens het feest,” zeiden ze, “anders komt er een volksopstand.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Toen Jezus in Betanië deelnam aan een maaltijd in het huis van Simon de Melaatse, kwam er een vrouw naar Hem toe met een albasten flesje kostbare zuivere nardusolie. Ze brak het flesje open en goot de geurige olie over zijn hoofd. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sommige van de aanwezigen zeiden verontwaardigd tegen elkaar: “Waarom werd die geurige olie verspild? ");
INSERT INTO nldgbv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Die olie had verkocht kunnen worden voor meer dan driehonderd denarie en de opbrengst had aan de armen kunnen worden gegeven.” Ze vielen ruw tegen haar uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Maar Jezus zei: “Laat haar met rust. Waarom vallen jullie haar lastig? Ze heeft iets goeds voor Mij gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Er zullen altijd arme mensen bij jullie zijn en jullie kunnen goed voor hen doen wanneer jullie willen. Maar Ik zal niet altijd bij jullie zijn. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Zij heeft gedaan wat ze kon: ze heeft mijn lichaam gezalfd ter voorbereiding van mijn begrafenis. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ik verzeker jullie, overal in de wereld waar het evangelie zal worden verkondigd, zal ter herinnering aan haar worden verteld wat zij heeft gedaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Toen ging Judas Iskariot, een van de Twaalf, naar de hoofdpriesters om Jezus aan hen uit te leveren. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ze waren verheugd om dat te vernemen en beloofden dat ze hem geld zouden betalen. Daarom zocht hij naar een gelegenheid om Jezus aan hen uit te leveren. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Op de eerste dag van het Feest van de Ongedesemde Broden, de dag waarop gewoonlijk het Pesachlam wordt geslacht, vroegen Jezus' leerlingen Hem: “Waar wilt U dat we de Pesachmaaltijd voor U gaan klaarmaken?” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hij stuurde twee van zijn leerlingen eropuit met de woorden: “Ga de stad in. Daar zullen jullie een man tegenkomen die een waterkan draagt. Volg hem en ");
INSERT INTO nldgbv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","zeg tegen de eigenaar van het huis waar hij naar binnen gaat: ‘De Leraar vraagt: Waar is het vertrek waar Ik met mijn leerlingen de Pesachmaaltijd kan eten?’ ");
INSERT INTO nldgbv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hij zal jullie een bovenzaal tonen, ingericht en op orde. Maak het daar voor ons klaar.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","De leerlingen vertrokken, gingen de stad in, troffen alles aan volgens zijn beschrijving en maakten de Pesachmaaltijd klaar. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","'s Avonds kwam Hij met de Twaalf. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ze gingen aan tafel en tijdens het eten zei Jezus: “Ik verzeker jullie, één van jullie zal Mij verraden, iemand die met Mij aan het eten is.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Daar werden ze bedroefd van en ze vroegen Hem, de een na de ander: “Ik ben het toch niet?” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hij antwoordde: “Het is één van jullie twaalf, iemand die zijn brood samen met Mij in de schaal doopt. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Want de Mensenzoon zal heengaan, zoals over Hem in de Schriften staat, maar wee degene door wie de Mensenzoon wordt verraden: voor die persoon zou het beter zijn geweest als hij niet was geboren.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tijdens de maaltijd nam Jezus een brood, sprak een zegengebed uit, brak het in stukken, verdeelde die onder hen en zei: “Neem dit aan; dit is mijn lichaam.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ook nam Hij een beker, sprak een dankgebed uit en reikte hun de beker aan. Ze dronken er allen uit. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hij zei tegen hen: “Dit is mijn bloed, het bloed van het verbond, dat voor veel mensen wordt vergoten. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ik verzeker jullie, Ik zal niet meer drinken van de vrucht van de druivelaar tot de dag waarop Ik nieuwe wijn drink in Gods koninkrijk.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na het zingen van een danklied vertrokken ze naar de Olijfberg. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jezus zei tegen hen: “Jullie zullen Mij allemaal in de steek laten, want in de Schriften staat: ‘Ik zal de herder doodslaan en de schapen zullen worden uiteengedreven.’ ");
INSERT INTO nldgbv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maar nadat Ik ben verrezen, zal Ik voor jullie uit naar Galilea gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus zei tegen Hem: “Al zou iedereen U in de steek laten, ik niet!” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jezus antwoordde: “Ik verzeker je, vandaag, ja vannacht nog, voordat de haan tweemaal kraait, zal jij Mij driemaal verloochenen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus hield vol: “Al moet ik met U sterven, ik zal U nooit verloochenen.” Alle anderen zeiden hetzelfde. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Toen ze bij een plaats aankwamen die Getsemane heet, zei Jezus tegen zijn leerlingen: “Gaan jullie hier zitten terwijl Ik ga bidden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hij nam Petrus, Jakobus en Johannes met zich mee en begon ontdaan en onrustig te worden. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hij zei tegen hen: “Ik ben dodelijk bedroefd. Blijf hier en waak.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hij stapte iets verder, liet zich op de grond vallen en bad dat, indien mogelijk, dit tijdstip aan Hem zou mogen voorbijgaan. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hij zei: “Abba, Vader, U kan alles. Neem deze beker van Mij weg! laat echter niet gebeuren wat Ik wil, maar wat U wil.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Toen Hij terugkwam, trof Hij hen slapend aan. Hij zei tegen Petrus: “Simon, slaap je? Was je zelfs niet in staat om één uur te waken? ");
INSERT INTO nldgbv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Waak en bid, opdat jullie niet in verzoeking komen, want de geest is wel bereidwillig maar het lichaam is zwak.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hij ging weg en bad opnieuw hetzelfde gebed. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Toen Hij opnieuw terugkwam, trof Hij hen slapend aan, want hun ogen waren dichtgevallen. Ze wisten niet wat ze Hem konden antwoorden. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Toen Hij voor de derde keer terugkwam, zei Hij tegen hen: “Zijn jullie nog altijd aan het slapen en rusten? Het is genoeg geweest, het tijdstip is aangebroken waarop de Mensenzoon aan de zondaars wordt uitgeleverd. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sta maar op, laten we vertrekken; mijn verrader is bijna hier.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Terwijl Hij nog sprak, arriveerde Judas, een van de Twaalf, met een groep mensen met zwaarden en knuppels. Ze waren gestuurd door de hoofdpriesters, Schriftgeleerden en oudsten. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jezus' verrader had een teken met hen afgesproken: “Het is degene die ik met een kus begroet; Hem moeten jullie arresteren en onder bewaking wegleiden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hij stapte recht op Jezus af, zei “Rabbi!” en gaf Hem een kus. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ze grepen Jezus en arresteerden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Maar een van de omstaanders trok zijn zwaard, viel de dienaar van de hogepriester aan en hakte zijn oor af. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jezus zei tegen de mensen: “Zijn jullie Mij hier als een misdadiger met zwaarden en knuppels komen arresteren? ");
INSERT INTO nldgbv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ik was toch elke dag bij jullie op het tempelterrein aan het onderwijzen? Toen hebben jullie Mij niet opgepakt. Maar de Schriften moeten in vervulling gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Toen liet iedereen Jezus in de steek en vluchtte weg. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Een jongeman die een linnen kledingstuk op het naakte lichaam droeg, volgde Jezus en werd door hen gegrepen. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hij maakte zich uit het kledingstuk los en vluchtte naakt weg. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jezus werd weggeleid, naar de hogepriester, waar alle hoofdpriesters, oudsten en Schriftgeleerden bijeenkwamen. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus volgde Hem op een afstand, helemaal tot op de binnenplaats van het huis van de hogepriester. Daar ging hij bij de bewakers zitten om zich aan het vuur te warmen. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","De hoofdpriesters en de hele Joodse raad zochten naar een getuigenverklaring op grond waarvan ze Jezus ter dood zouden kunnen veroordelen, maar ze vonden die niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Veel mensen legden valse verklaringen tegen Hem af, maar de getuigenissen stemden niet met elkaar overeen. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Toen kwamen er mensen naar voren met de volgende valse bezwarende verklaring: ");
INSERT INTO nldgbv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Wij hebben Hem horen zeggen: Ik zal deze door mensen gebouwde tempel verwoesten en in drie dagen een andere, niet door mensenhanden gemaakte, tempel bouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maar zelfs hun getuigenissen stemden niet met elkaar overeen. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Toen ging de hogepriester in het midden staan en vroeg aan Jezus: “Hebt U geen antwoord op de verklaring van deze getuigen tegen U?” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Maar Hij zweeg en gaf helemaal geen antwoord. De hogepriester vroeg verder: “Bent U de Messias, de Zoon van de Gezegende?” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jezus zei: “Dat ben Ik. En u zal de Mensenzoon aan de rechterzijde van de Machtige zien zitten, en Hem zien komen met de wolken.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","De hogepriester scheurde zijn kleren en zei: “Waarom hebben we nog getuigen nodig? ");
INSERT INTO nldgbv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","U heeft de godslastering gehoord. Wat is uw besluit?” Ze oordeelden allemaal dat Jezus de doodstraf verdiende. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sommigen begonnen naar Hem te spuwen, Hem te blinddoeken en Hem te slaan, terwijl ze riepen: “Profeteer dan!” De bedienden namen Hem over en ook zij sloegen Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Terwijl Petrus beneden op de binnenplaats was, kwam er een dienstmeisje van de hogepriester voorbij. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Toen ze Petrus zag, die zich aan het warmen was, keek ze hem aan en zei ze: “U was ook bij die Jezus van Nazaret.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Maar hij ontkende het. “Ik heb geen idee waarover je het hebt”, zei hij en ging naar het voorportaal. Toen kraaide er een haan. ");
INSERT INTO nldgbv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Maar toen het dienstmeisje hem daar zag, herhaalde ze het tegenover de omstaanders: “Die man is één van hen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Opnieuw ontkende Petrus. Na een tijdje zeiden de omstaanders tegen Petrus: “Jij bent toch echt één van hen, want je bent een Galileeër.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hij begon vloeken over zichzelf af te roepen en te zweren: “Ik ken die Man niet over Wie jullie het hebben.” ");
INSERT INTO nldgbv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Meteen kraaide voor de tweede keer een haan. Toen herinnerde Petrus zich wat Jezus tegen hem had gezegd: “Voordat de haan tweemaal kraait, zal jij Mij driemaal verloochenen.” Hij barstte in tranen uit en weende. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zodra het ochtend werd, kwamen de hoofdpriesters met de oudsten, Schriftgeleerden en de hele Joodse raad tot een gezamenlijk besluit. Ze leidden Jezus gebonden weg en leverden Hem over aan Pilatus. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus vroeg Hem: “Bent U de koning van de Joden?” Jezus antwoordde: “U zegt het zelf.” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","De hoofdpriesters brachten allerlei beschuldigingen tegen Hem in. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus vroeg verder: “Geeft U geen antwoord? U hoort toch waarvan ze U beschuldigen!” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Maar Jezus gaf nog altijd geen antwoord, wat Pilatus verwonderde. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gewoonlijk liet Pilatus tijdens het feest een gevangene vrij op verzoek van het volk. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iemand die Barabbas heette, zat gevangen met de opstandelingen die zich tijdens het oproer aan moord hadden schuldig gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Toen de menigte naar Pilatus toe ging met het verzoek om te doen wat hij gewoonlijk deed, ");
INSERT INTO nldgbv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","stelde Pilatus voor: “Willen jullie dat ik de koning van de Joden vrijlaat?” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hij besefte namelijk dat de hoofdpriesters Jezus hadden uitgeleverd uit afgunst. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Maar de hoofdpriesters hitsten de menigte op om te eisen dat Barabbas zou worden vrijgelaten. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Daarom vroeg Pilatus hen: “Wat willen jullie dat ik doe met de Man die jullie de koning van de Joden noemen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","De mensen riepen terug: “Kruisig Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus vroeg: “Wat heeft Hij dan misdaan?” Toen riepen ze nog luider: “Kruisig Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus besloot om de menigte tevreden te stellen. Daarom liet hij Barabbas vrij, maar Jezus liet hij geselen en vervolgens wegleiden om te worden gekruisigd. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","De soldaten leidden Jezus het paleis – dat wil zeggen: het hoofdkwartier – binnen en riepen hun gehele legerafdeling bijeen. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vervolgens trokken ze Jezus een paarse mantel aan en vlochten ze een krans van doorntakken die ze Hem als een kroon opzetten. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ze begonnen Hem te “begroeten”: “Gegroet, koning van de Joden!” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ze sloegen Hem op het hoofd met een rietstok, bespuwden Hem en knielden om Hem te ‘eren’. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nadat ze zo de spot met Jezus hadden gedreven, trokken ze Hem de paarse mantel uit en zijn eigen kleren aan. Vervolgens leidden ze Hem naar buiten om Hem te kruisigen. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Er was een voorbijganger die van het land kwam, Simon van Cyrene, de vader van Alexander en Rufus. Hem dwongen ze, Jezus' kruis te dragen. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ze brachten Hem naar de plaats die Golgota heet. Dat betekent: Schedelplaats. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Daar reikten ze Jezus wijn met mirre aan, maar Hij weigerde die. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Toen kruisigden ze Hem. Zijn kleren verdeelden ze onder elkaar door middel van verloting. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Het was negen uur 's ochtends toen ze Hem kruisigden. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Op het bordje met de aanklacht tegen Hem stond: “De koning van de Joden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Samen met Jezus werden twee misdadigers gekruisigd: de ene rechts en de andere links van Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","De voorbijgangers beledigden Jezus door hoofdschuddend te roepen: “Ha, Jij die de tempel verwoest en binnen drie dagen herbouwt! ");
INSERT INTO nldgbv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Red Jezelf en kom van het kruis af!” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ook de hoofdpriesters en de Schriftgeleerden bespotten Hem, door tegen elkaar te zeggen: “Anderen heeft Hij gered, maar zichzelf redden kan Hij niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Laat die Messias, die koning van Israël, maar van het kruis afkomen. Als we dat zien, zullen we geloven.” Zelfs zij die samen met Jezus werden gekruisigd, bespotten Hem. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Om twaalf uur werd het donker in het hele land, tot drie uur 's middags. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Om drie uur 's middags riep Jezus luid: “Eloï, Eloï, lama sabachtani?” Dat betekent: Mijn God, Mijn God, waarom heeft U Mij verlaten? ");
INSERT INTO nldgbv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sommigen die dichtbij stonden, hoorden dat en zeiden: “Hoor je dat? Hij roept Elia.” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iemand haalde snel een spons, vulde die met zure wijn en stak hem op een stok om Jezus te drinken te geven, terwijl hij zei: “Wacht, laten we kijken of Elia Hem van het kruis komt halen.” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Maar Jezus slaakte een luide kreet en stierf. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Toen scheurde het tempelgordijn van boven naar beneden in tweeën. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Toen de centurio die tegenover Jezus stond, zag dat Hij op die wijze was gestorven, zei hij: “Deze man was werkelijk de Zoon van God.” ");
INSERT INTO nldgbv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Er waren vrouwen die vanop een afstand toekeken, waaronder Maria van Magdala, Maria de moeder van Jakobus de Jongere en van Joses, en Salome. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Zij hadden Jezus gevolgd en gediend toen Hij in Galilea was. Er waren ook veel andere vrouwen bij, die met Hem naar Jeruzalem waren meegekomen. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Het was Voorbereidingsdag, de dag voor de sabbat. Toen het avond werd, ");
INSERT INTO nldgbv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","vatte Jozef van Arimatea, een vooraanstaand lid van de Joodse raad die zelf ook Gods koninkrijk verwachtte, moed en ging hij Pilatus vragen om Jezus' lichaam. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus verbaasde zich erover dat Jezus al gestorven zou zijn en ontbood de centurio om hem te vragen of Hij al gestorven was. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pas toen hij het van de centurio zelf had vernomen, gaf hij het lichaam vrij aan Jozef. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jozef kocht een stuk linnen, haalde Jezus van het kruis, wikkelde Hem in het linnen, legde Hem in een graf dat in de rots was uitgehouwen en rolde een steen voor de ingang van dat graf. ");
INSERT INTO nldgbv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria van Magdala en Maria de moeder van Joses zagen waar Jezus was neergelegd. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Toen de sabbat voorbij was, kochten Maria van Magdala, Maria de moeder van Jakobus, en Salome geurige oliën om Jezus' lichaam te zalven. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Op de eerste dag van de week waren ze al vroeg, vlak na zonsopgang, onderweg naar het graf. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ze vroegen zich af: “Wie zal de steen voor de ingang voor ons wegrollen?” ");
INSERT INTO nldgbv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maar toen ze keken, zagen ze dat de steen, die zeer groot was, reeds was weggerold. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ze gingen het graf binnen en zagen aan de rechterkant een jongeman zitten die een lang wit gewaad droeg. Ze schrokken hevig. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hij zei tegen hen: “Schrik maar niet. Jullie zoeken Jezus van Nazaret, die gekruisigd was. Hij is verrezen; Hij is hier niet. Kijk maar waar ze Hem hadden neergelegd. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ga nu en zeg tegen zijn leerlingen, ook Petrus: ‘Hij gaat voor jullie uit naar Galilea en daar zullen jullie Hem zien, zoals Hij jullie had verteld.’” ");
INSERT INTO nldgbv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","De vrouwen gingen bevend van schrik naar buiten en vluchtten bij het graf vandaan. Ze waren zo van slag, dat ze tegen niemand iets zeiden. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nadat Jezus 's morgens vroeg op de eerste dag van de week verrezen was, vertoonde Hij zich eerst aan Maria van Magdala, bij wie Hij zeven demonen had uitgedreven. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Zij ging het verkondigen aan de mensen die Hem hadden vergezeld en die nu aan het rouwen en wenen waren. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Toen die hoorden dat Jezus leefde en dat zij Hem had gezien, geloofden ze het niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Daarna vertoonde Hij zich in een andere gedaante aan twee van hen, die naar het platteland gingen. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Zij keerden terug om het aan de anderen te vertellen, maar die geloofden het nog altijd niet. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nog later vertoonde Jezus zich aan de Elf toen die aan het eten waren. Hij verweet hen hun ongeloof en hun koppige weigering om de mensen te geloven die Hem hadden gezien nadat Hij was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hij zei tegen hen: “Ga de hele wereld in en verkondig het evangelie aan de hele schepping. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wie gelooft en zich laat dopen, zal worden gered, maar wie niet gelooft, zal worden veroordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bij de gelovigen zullen de volgende tekenen gebeuren: in mijn naam zullen ze demonen uitdrijven, ze zullen in tongentaal spreken, ");
INSERT INTO nldgbv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","met hun handen zullen ze slangen opnemen en als ze dodelijk gif drinken zal het hun geen kwaad doen, ze zullen zieke mensen de handen opleggen en die zullen gezond worden.” ");
INSERT INTO nldgbv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nadat de Heer Jezus hen toegesproken had, werd Hij in de hemel opgenomen en nam Hij plaats aan Gods rechterzijde. ");
INSERT INTO nldgbv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zijn leerlingen gingen eropuit om overal het evangelie te verkondigen. De Heer werkte door hen en bevestigde hun boodschap door middel van de tekenen die ermee gepaard gingen.");
INSERT INTO nldgbv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Velen hebben geprobeerd een verslag te maken over de gebeurtenissen die bij ons hebben plaatsgevonden, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","en die aan ons zijn overgeleverd door de mensen die vanaf het begin ooggetuigen zijn geweest en het nieuws hebben doorgegeven. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Daarom leek het ook mij goed om – nadat ik alles vanaf het begin nauwkeurig heb onderzocht – een ordelijk verslag voor u te schrijven, geachte Theofilus, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","zodat u er zeker van kan zijn dat hetgeen men u geleerd heeft, waar is. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","In de tijd van Herodes, koning van Judea, was er een priester die Zacharias heette. Hij behoorde tot de afdeling van Abia. Zijn vrouw heette Elisabet; ook zij stamde af van Aäron. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ze waren allebei rechtvaardig in Gods ogen; ze hielden zich nauwgezet aan alle geboden en voorschriften van de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ze hadden geen kinderen, omdat Elisabet onvruchtbaar was, en ze waren allebei op leeftijd. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Op een dag dat het de beurt van Zacharias' afdeling was om de priestertaken in Gods aanwezigheid uit te voeren, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","werd hij, door een loting die volgens de priesterlijke gebruiken werd uitgevoerd, aangewezen om het tempelgebouw van de Heer binnen te gaan en daar wierook te branden. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Op het tijdstip dat het wierookoffer zou worden gebracht, stond een groot aantal Joodse mensen buiten te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Toen verscheen aan Zacharias een engel van de Heer; hij stond rechts van het wierookaltaar. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Toen Zacharias de engel zag, schrok hij hevig en werd hij door angst bevangen. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","De engel zei echter tegen hem: “Wees niet bang, Zacharias, want je gebed is verhoord. Jij en je vrouw Elisabet zullen een zoon krijgen en je moet hem de naam Johannes geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hij zal een bron van grote vreugde en blijdschap voor je zijn en veel mensen zullen zich over zijn geboorte verheugen, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","want hij zal een groot man zijn in de ogen van de Heer. Hij mag geen wijn of andere alcoholische dranken nuttigen en hij zal worden vervuld van de Heilige Geest terwijl hij nog in de moederschoot is. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hij zal veel Israëlieten terugleiden naar de Heer, hun God. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hij zal voor de Heer uit gaan, onder leiding van dezelfde Geest en met dezelfde kracht als Elia. Hij zal het hart van vaders terugleiden naar hun kinderen en het denken van zondaars naar de rechtvaardigheid; zo zal hij een volk voorbereiden dat gereed is voor de Heer.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacharias vroeg de engel: “Hoe kan ik weten of dit waar is? Ik ben immers een oude man en mijn vrouw is op leeftijd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","De engel antwoordde: “Ik ben Gabriël. Ik sta in Gods dienst en ik ben gezonden om jou dit goede nieuws te vertellen. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mijn woorden zullen op het juiste moment in vervulling gaan. Maar omdat je ze niet gelooft, zal je stom zijn en niet kunnen spreken tot het tijdstip waarop deze dingen plaatsvinden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Intussen wachtte het volk op Zacharias; men vroeg zich af waarom hij zo lang in het tempelgebouw bleef. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Toen hij uiteindelijk naar buiten kwam, was hij niet in staat om hen toe te spreken. Daaruit maakten ze op dat hij in het tempelgebouw een visioen had gehad, want hij bleef gebaren naar hen maken zonder te kunnen spreken. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Toen zijn dienstperiode als priester voorbij was, ging Zacharias naar huis. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Enige tijd later werd zijn vrouw Elisabet zwanger. Vijf maanden lang zonderde ze zich af. Ze zei: ");
INSERT INTO nldgbv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dit heeft de Heer voor mij gedaan: Hij heeft zich over mij ontfermd en de schande weggenomen die ik in de ogen van de mensen droeg.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","In de zesde maand van de zwangerschap van Elisabet zond God de engel Gabriël naar een stad in Galilea die Nazaret heette, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","naar een jonge vrouw die maagd was. Zij was verloofd met een man die Jozef heette en afstammeling van David was. De jonge vrouw heette Maria. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","De engel kwam bij haar thuis en zei: “Gegroet, jij bevoorrechte vrouw, de Heer is bij je.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Zij stond perplex van deze woorden en vroeg zich af wat de begroeting te betekenen had. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","De engel zei tegen haar: “Wees niet bang, Maria, God is je gunstig gezind. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Je zal zwanger worden en een zoon krijgen. Je moet Hem de naam Jezus geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hij zal een groot man zijn en de Zoon van de Allerhoogste worden genoemd. De Heer God zal Hem de troon van zijn voorvader David schenken. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hij zal voor eeuwig over de afstammelingen van Jakob regeren en zijn heerschappij zal nooit eindigen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria vroeg aan de engel: “Maar hoe kan dat? Ik heb nog nooit met een man geslapen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","De engel antwoordde: “De Heilige Geest zal naar je toe komen en de kracht van de Allerhoogste zal je als een schaduw bedekken. Daarom zal het kindje heilig zijn en de Zoon van God worden genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bovendien is je bloedverwante Elisabet ook zwanger van een zoon, hoewel ze oud is. Ze werd als onvruchtbaar beschouwd, maar is nu in de zesde maand. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Voor God is namelijk niets onmogelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria zei: “Ik stel mij ten dienste van de Heer. Laat het gebeuren zoals u gezegd hebt.” Toen ging de engel bij haar vandaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kort daarna maakte Maria zich klaar en begaf ze zich haastig naar een stad in het bergland van Juda. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Daar ging ze naar het huis van Zacharias en begroette ze Elisabet. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Toen Elisabet de begroeting van Maria hoorde, trappelde het kindje in haar buik en raakte ze vervuld van de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ze riep luid: “Jij bent gezegend onder de vrouwen! Ook het kindje in je buik is gezegend! ");
INSERT INTO nldgbv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hoe is het mogelijk dat het mij overkomt dat de moeder van mijn Heer bij mij komt? ");
INSERT INTO nldgbv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Zodra ik je begroeting hoorde, trappelde het kindje in mijn buik van vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Zij die gelooft dat hetgeen de Heer haar had beloofd zou gebeuren, is gezegend!” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Toen zei Maria: “Mijn ziel prijst de Heer ");
INSERT INTO nldgbv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","en mijn geest verheugt zich in God, mijn redder, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","want Hij heeft omgekeken naar zijn dienares in haar geringheid. Voortaan zullen alle generaties mij gezegend noemen, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","want de Machtige heeft grote dingen voor mij gedaan en zijn naam is heilig. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Zijn mededogen geldt voor wie ontzag voor Hem hebben, de ene generatie na de andere. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Met zijn sterke arm heeft Hij zijn kracht getoond, Hij heeft uiteengejaagd wie arrogante gedachten koesterden. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Heersers heeft Hij onttroond, aan eenvoudigen gaf Hij een eervolle plaats. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hongerigen heeft Hij verzadigd met het goede, rijken stuurde Hij met lege handen weg. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hij heeft zijn dienaar Israël geholpen; Hij had mededogen, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","overeenkomstig Zijn eeuwige belofte aan onze voorouders, aan Abraham en zijn afstammelingen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria bleef ongeveer drie maanden bij Elisabet en ging toen terug naar huis. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Toen voor Elisabet de tijd was aangebroken om haar kind te baren, kreeg ze een zoon. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Haar buren en familieleden hoorden dat de Heer mededogen met haar had gehad en haar had gezegend, en ze kwamen dat met haar vieren. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Toen ze op de achtste dag het kind kwamen besnijden, wilden ze hem de naam Zacharias geven, naar zijn vader. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maar zijn moeder reageerde: “Nee, hij moet Johannes heten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ze vroegen haar: “Maar er is toch niemand in je familie die zo heet?” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ze gebaarden naar de vader van het kind, om te vragen hoe hij wilde dat het zou heten. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hij vroeg om een schrijfplankje en schreef: “Zijn naam is Johannes.” Iedereen was verbaasd. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Onmiddellijk kon Zacharias zijn mond en tong weer gebruiken. Hij sprak weer en hij prees God. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Alle buren waren vol ontzag en al deze dingen waren onderwerp van gesprek in het hele bergland van Judea. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Allen die ervan hoorden, dachten erover na en vroegen zich af: “Wat zal er van dit kind terechtkomen?” Het was namelijk duidelijk dat de zegen van de Heer op hem rustte. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Toen werd zijn vader Zacharias vervuld van de Heilige Geest en profeteerde hij: ");
INSERT INTO nldgbv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ik prijs de Heer, de God van Israël, want Hij heeft naar zijn volk omgekeken en het verlost. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uit het nageslacht van zijn dienaar David heeft Hij een machtige redder doen opstaan, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","zoals Hij lang geleden had beloofd bij monde van zijn heilige profeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hij is het die ons redt van onze vijanden en uit de greep van allen die ons verachten. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Zo betoont Hij ons het mededog en dat Hij ook aan onze voorouders heeft betoond. En zo bevestigt Hij zijn heilig verbond, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","en de eed die Hij aan Abraham, onze voorvader, heeft gezworen. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bevrijd uit de greep van onze vijanden, mogen wij Hem nu onbevreesd vereren, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","in heiligheid en rechtvaardigheid, terwijl Hij op ons toekijkt, ons leven lang. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","En jij, kind, zal een profeet van de Allerhoogste worden genoemd, want je zal voor de Heer uitgaan om de weg voor Hem gereed te maken, ");
INSERT INTO nldgbv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","om de redding, de vergeving van hun zonden, aan zijn volk bekend te maken. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wegens Gods grote mededogen voor ons, zal vanuit de hemel de zon voor ons opgaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Zij zal schijnen op de mensen die in het duister en in de schaduw van de dood leven, en zij zal onze voeten naar de weg van de vrede leiden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Het kind groeide op en zijn geest werd steeds sterker. Hij leefde op afgelegen plaatsen tot de dag waarop hij zich publiekelijk aan Israël vertoonde. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","In die tijd vaardigde keizer Augustus het bevel uit dat iedereen in het Romeinse rijk moest worden geregistreerd. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Deze volkstelling was de eerste in de periode dat Quirinius gouverneur van Syrië was. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iedereen reisde naar zijn thuisstad, om daar te worden ingeschreven. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ook Jozef begaf zich vanuit de stad Nazaret in Galilea naar Judea, naar de stad van David, Betlehem genaamd. Hij was namelijk een afstammeling van David. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hij ging zich inschrijven met Maria, zijn verloofde. Zij was zwanger. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Toen ze daar waren, brak de tijd aan dat haar kind geboren zou worden. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ze baarde haar zoon, haar eerste, wikkelde hem in doeken en legde hem in een voederbak, omdat er geen plaats voor hen was in het gastenverblijf. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Er waren in die omgeving herders, die buiten de stad verbleven en 's nachts over hun kudde waakten. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Opeens stond er een engel van de Heer voor hen en werden ze door de hemelse pracht van de Heer beschenen. Ze werden heel bang. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","De engel zei tegen hen: “Wees niet bang, want ik breng jullie goed nieuws, dat grote vreugde brengt voor het hele volk. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vandaag is in de stad van David een redder voor jullie geboren: de Messias, de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Als teken hiervan zullen jullie een Kindje vinden dat in doeken is gewikkeld en in een voederbak ligt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Plots bevond zich bij de engel een groot hemels leger, dat God prees met de woorden: ");
INSERT INTO nldgbv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alle glorie aan God in de hoogste hemel en vrede op aarde voor de mensen die Hij begunstigt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nadat de engelen bij hen vandaan waren gegaan, terug naar de hemel, zeiden de herders tegen elkaar: “Laten we naar Betlehem gaan om te zien wat daar gebeurd is en door de Heer aan ons bekend gemaakt is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ze haastten zich erheen en vonden Maria, Jozef en het kindje dat in de voederbak lag. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Toen ze hen hadden gezien, maakten ze bekend wat hun over dit kind was verteld. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Alle mensen die het hoorden, verbaasden zich over hetgeen de herders hun vertelden, ");
INSERT INTO nldgbv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","maar Maria onthield hun woorden zorgvuldig en dacht er nog lang over na. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","De herders keerden terug, terwijl ze God verheerlijkten en prezen voor alles wat ze hadden gehoord en gezien; het kwam precies overeen met hetgeen hun verteld was. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Acht dagen later was het tijd om het kindje te besnijden. Hij ontving de naam Jezus, de naam die de engel had gegeven voordat Maria zwanger van Hem was geworden. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Toen de tijd was aangebroken dat ze zich volgens de Wet van Mozes moesten reinigen, gingen ze met Jezus naar Jeruzalem om Hem aan de Heer voor te stellen. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","In de Wet van de Heer staat namelijk dat iedere eerste zoon aan de Heer moet worden gewijd. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ook brachten ze een offer, overeenkomstig de bepalingen in de Wet van de Heer: een paar tortelduiven of twee jonge duiven. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Er was in Jeruzalem iemand die Simeon heette. Hij was een oprecht mens met veel eerbied voor God. Hij keek uit naar de tijd dat Israël getroost zou worden en de Heilige Geest rustte op hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","De Heilige Geest had aan hem onthuld dat hij niet zou sterven voordat hij de Messias van de Heer had gezien. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Door de Geest geleid kwam hij naar het tempelterrein. Toen de ouders de kleine Jezus binnen brachten om met Hem de gebruiken uit te voeren die de Wet voorschrijft, ");
INSERT INTO nldgbv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nam Simeon Hem in zijn armen en prees hij God met de woorden: ");
INSERT INTO nldgbv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Machtige Heer, nu kan U in vrede uw dienaar laten gaan, zoals U had beloofd, ");
INSERT INTO nldgbv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","want mijn ogen hebben uw redding gezien, ");
INSERT INTO nldgbv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","die U in de aanwezigheid van alle volken hebt gereedgemaakt: ");
INSERT INTO nldgbv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","een licht dat openbaring brengt voor de vreemde volken, en glorie voor uw volk Israël.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jezus' vader en moeder verbaasden zich over de dingen die Simeon over Hem zei. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon sprak een zegen over hen uit en zei tegen Maria, Jezus' moeder: “Dit Kind is bestemd om velen in Israël ten val te brengen of te doen opstaan, en om een waarschuwingsteken te zijn dat controverse zal oproepen. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Zo zal duidelijk worden wat er in veel mensen omgaat. Ook jouw ziel zal worden doorstoken als met een zwaard.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Er was ook een profetes: Anna, dochter van Fanuel, van de stam Aser. Ze was al op hoge leeftijd. Nadat ze was getrouwd had ze zeven jaar lang met haar man geleefd; ");
INSERT INTO nldgbv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","daarna leefde ze als weduwe en nu was ze 84 jaar. Ze week nooit van het tempelterrein, maar diende God dag en nacht door te vasten en te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Op dat moment kwam ze naar hen toe en begon ze God te danken en over Jezus te vertellen aan iedereen die de verlossing van Jeruzalem verwachtte. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nadat Jozef en Maria alles hadden gedaan wat de Wet van de Heer voorschrijft, keerden ze terug naar Galilea, naar hun woonplaats Nazaret. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Het Kind groeide op en werd steeds sterker en wijzer; Gods genade rustte op Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ieder jaar gingen Jezus' ouders naar Jeruzalem voor het Pesachfeest. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Toen Hij twaalf jaar oud was en ze zoals gebruikelijk naar het feest gingen, ging Hij mee. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Maar na afloop, toen zij terugkeerden, bleef de jonge Jezus in Jeruzalem achter zonder dat zijn ouders het wisten. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ze dachten dat Hij zich in de groep reizigers bevond en legden een dagreis af, terwijl ze onder hun familieleden en bekenden naar Hem zochten. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Toen ze Hem niet vonden, keerden ze naar Jeruzalem terug om Hem daar te zoeken. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pas op de derde dag vonden ze Hem bij de leraars op het tempelterrein; Hij zat naar hen te luisteren en stelde hun vragen. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Allen die Hem hoorden, stonden versteld van zijn inzicht en zijn antwoorden. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Toen zijn ouders Hem zagen, waren ze aangeslagen. Zijn moeder zei tegen Hem: “Kind, hoe kon Je ons dit aandoen? Je vader en ik waren diep ongerust naar Je op zoek.” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jezus antwoordde: “Waarom zochten jullie naar Mij? Weten jullie niet dat Ik in het huis van mijn Vader moet zijn?” ");
INSERT INTO nldgbv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Maar ze begrepen niet wat Hij tegen hen zei. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hij kwam met hen mee naar Nazaret en was hun gehoorzaam. Zijn moeder onthield al deze dingen zorgvuldig. ");
INSERT INTO nldgbv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jezus werd steeds wijzer en volwassener en stond steeds meer in de gunst bij God en bij de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","In het vijftiende regeringsjaar van keizer Tiberius, toen Pontius Pilatus gouverneur van Judea was, en Herodes tetrarch van Galilea, zijn broer Filippus tetrarch van het gebied van Iturea en Trachonitis, en Lysanias tetrarch van Abilene, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","en toen Annas en Kajafas de hogepriesters waren, ontving Johannes, de zoon van Zacharias, in de wildernis een boodschap van God. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Daarom ging hij naar het gebied rondom de Jordaan, waar hij overal de doop van inkeer verkondigde, die tot vergeving van zonden leidt. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zo ging in vervulling wat in het boek met de uitspraken van de profeet Jesaja staat: “Er roept een stem in de wildernis: Maak de weg van de Heer gereed, maak paden voor Hem vrij! ");
INSERT INTO nldgbv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iedere kloof zal worden gevuld en elke berg en heuvel verlaagd; kronkelende paden zullen worden rechtgemaakt, en hobbelige wegen geëffend. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Alle mensen zullen Gods redding zien.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Johannes zei tegen de vele mensen die naar hem toekwamen om door hem te worden gedoopt: “Addergebroed, wie heeft jullie gewaarschuwd om te vluchten voor de naderende straf? ");
INSERT INTO nldgbv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Zorg dat de gevolgen van jullie inkeer zichtbaar zijn en zeg niet tegen jezelf: wij hebben Abraham als voorvader. Want ik zeg jullie: God is in staat om uit deze stenen afstammelingen van Abraham voort te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","De bijl ligt reeds klaar onderaan de bomen en elke boom die geen goede vruchten voortbrengt, wordt omgehakt en in het vuur gegooid.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","De mensen vroegen hem: “Wat moeten we dan doen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johannes antwoordde: “Wie twee hemden heeft, moet delen met wie er geen heeft en wie voedsel heeft, moet hetzelfde doen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Er kwamen ook belastinginners om te worden gedoopt. Zij vroegen hem: “Leraar, wat moeten wij doen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Johannes zei tegen hen: “Vorder geen hoger bedrag dan jullie is opgedragen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ook de soldaten vroegen hem: “Wat moeten wij doen?” Tegen hen zei hij: “Beroof niemand en pers niemand af, maar wees tevreden met je soldij.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Omdat het volk grote verwachtingen had en zich afvroeg of Johannes misschien de Messias was, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","gaf hij hun allen het volgende antwoord: “Ik doop jullie met water, maar er komt Iemand die machtiger is dan ik en ik ben het niet waard om zijn schoenriem los te maken. Hij zal jullie dopen met de Heilige Geest en met vuur. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hij heeft de vork om het kaf van het koren te scheiden al in zijn hand. Daarmee zal Hij zijn dorsvloer leegmaken; het graan zal Hij in de schuur onderbrengen en het kaf zal Hij verbranden in onblusbaar vuur.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zo, en met veel andere waarschuwingen, verkondigde Johannes het evangelie aan het volk. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hij vermaande ook de tetrarch Herodes – wegens Herodias, de vrouw van zijn broer, en al het andere kwaad dat hij had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Maar Herodes maakte alles nog erger door Johannes in de gevangenis op te sluiten. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Toen heel het volk zich liet dopen, werd ook Jezus gedoopt. Terwijl Hij in gebed was, ging de hemel open. ");
INSERT INTO nldgbv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","De Heilige Geest daalde op Hem neer in de gedaante van een duif en er klonk een stem uit de hemel: “Jij bent mijn dierbare Zoon, Ik verheug Mij over Jou.” ");
INSERT INTO nldgbv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aan het begin van zijn optreden was Jezus ongeveer dertig jaar oud. Hij was, zo werd verondersteld, de zoon van Jozef, de zoon van Eli, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","de zoon van Mattat, de zoon van Levi, de zoon van Melchi, de zoon van Jannai, de zoon van Jozef, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","de zoon van Mattatias, de zoon van Amos, de zoon van Naüm, de zoon van Hesli, de zoon van Naggai, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","de zoon van Maät, de zoon van Mattatias, de zoon van Semeïn, de zoon van Josech, de zoon van Joda, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","de zoon van Joanan, de zoon van Resa, de zoon van Zerubbabel, de zoon van Sealtiël, de zoon van Neri, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","de zoon van Melchi, de zoon van Addi, de zoon van Kosam, de zoon van Elmadan, de zoon van Er, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","de zoon van Jozua, de zoon van Eliëzer, de zoon van Jorim, de zoon van Mattat, de zoon van Levi, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","de zoon van Simeon, de zoon van Juda, de zoon van Jozef, de zoon van Jonan, de zoon van Eljakim, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","de zoon van Melea, de zoon van Menna, de zoon van Mattatta, de zoon van Natan, de zoon van David, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","de zoon van Isaï, de zoon van Obed, de zoon van Boaz, de zoon van Selach, de zoon van Nachson, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","de zoon van Amminadab, de zoon van Admin, de zoon van Arni, de zoon van Chesron, de zoon van Peres, de zoon van Juda, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","de zoon van Jakob, de zoon van Isaak, de zoon van Abraham, de zoon van Terach, de zoon van Nachor, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","de zoon van Serug, de zoon van Reü, de zoon van Peleg, de zoon van Eber, de zoon van Selach, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","de zoon van Kenan, de zoon van Arpachsad, de zoon van Sem, de zoon van Noach, de zoon van Lamech, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","de zoon van Metuselach, de zoon van Henoch, de zoon van Jered, de zoon van Mahalalel, de zoon van Kenan, ");
INSERT INTO nldgbv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","de zoon van Enos, de zoon van Set, de zoon van Adam, de zoon van God. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Vol van de Heilige Geest keerde Jezus terug van de Jordaan. Hij werd door de Geest naar de wildernis geleid, ");
INSERT INTO nldgbv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","waar Hij veertig dagen lang door de duivel op de proef werd gesteld. Al die tijd at Hij niet en na afloop kreeg Hij honger. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","De duivel zei tegen Hem: “Als U de Zoon van God bent, zeg dan dat deze steen een brood moet worden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Maar Jezus antwoordde: “In de Schriften staat: ‘De mens leeft niet alleen van brood.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Toen leidde de duivel Hem naar een hoge plaats en toonde hij Hem in een oogwenk alle koninkrijken van de wereld. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","De duivel zei tegen Hem: “Ik zal U het gezag over dit alles geven, in al zijn pracht, want het is aan mij overhandigd en ik geef het aan wie ik wil. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dus als U mij aanbidt, zal het allemaal van U zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Maar Jezus antwoordde: “In de Schriften staat: ‘Aanbid de Heer, je God, en dien alleen Hem.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Toen leidde hij Hem naar Jeruzalem, naar de hoogste plaats op het tempelterrein, en zei: “Als U de Zoon van God bent, spring dan van hier naar beneden, ");
INSERT INTO nldgbv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","want in de Schriften staat: ‘Hij zal zijn engelen bevelen jou te beschermen’, ");
INSERT INTO nldgbv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","en: ‘Zij zullen je op hun handen dragen, zodat je je voet niet aan een steen stoot.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jezus antwoordde: “Er staat ook: ‘Stel de Heer, je God, niet op de proef.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na afloop van al die verzoekingen bleef de duivel een tijdlang bij Jezus vandaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jezus keerde naar Galilea terug, dankzij de kracht die de Geest Hem gaf. Het nieuws over Hem verspreidde zich in de hele omgeving. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hij begon te onderwijzen in de synagogen en werd door iedereen geprezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Toen Jezus in Nazaret kwam, waar Hij was opgegroeid, ging Hij zoals Hij gewoon was op de sabbat naar de synagoge. Hij stond op om voor te lezen ");
INSERT INTO nldgbv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","en het boek van de profeet Jesaja werd Hem aangereikt. Hij rolde het open om het gedeelte op te zoeken waar staat: ");
INSERT INTO nldgbv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“De Geest van de Heer rust op mij, omdat Hij mij heeft gezalfd om goed nieuws te brengen aan de armen. Hij heeft mij gezonden om kwijtschelding te verkondigen aan de gevangenen en herstel van zicht aan de blinden, om vrijheid te brengen aan de verdrukten ");
INSERT INTO nldgbv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","en het jaar aan te kondigen waarin de Heer zijn genegenheid toont.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hij rolde de boekrol dicht, gaf die terug aan de koster en ging zitten. Alle ogen in de synagoge waren op Hem gericht ");
INSERT INTO nldgbv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","en Hij sprak hen toe: “Vandaag is dit Schriftgedeelte in vervulling gegaan terwijl jullie ernaar luisterden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iedereen sprak lovend over Hem en men verbaasde zich over zijn welsprekendheid. Ze vroegen: “Is dit niet de zoon van Jozef?” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jezus zei tegen hen: “Jullie zullen ongetwijfeld de spreuk ‘Dokter, genees jezelf’ aanhalen en tegen Mij zeggen: doe de dingen waarvan wij hebben gehoord dat ze in Kafarnaüm zijn gebeurd, ook hier in uw thuisstad. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Maar Ik verzeker jullie: geen enkele profeet is welkom in zijn thuisstad. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ik verzeker jullie: er waren veel weduwen in Israël in de tijd van Elia, toen het drie jaar en zes maanden niet regende en er grote hongersnood heerste in het hele land. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Elia werd naar geen van die vrouwen gestuurd, maar wel naar een weduwe in Sarepta bij Sidon. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","En in de tijd van de profeet Elisa waren er in Israël veel mensen met een huidziekte die hen onrein maakte. Niemand van hen werd rein gemaakt, maar wel de Syriër Naäman.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Alle mensen in de synagoge werden woedend toen ze dat hoorden. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ze sprongen op, sleurden Hem de stad uit en brachten Hem naar een richel op de berghelling waarop de stad was gebouwd. Ze wilden Hem in de afgrond duwen, ");
INSERT INTO nldgbv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","maar Hij wandelde midden tussen hen door en vertrok. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jezus ging naar Kafarnaüm, een stad in Galilea. Daar onderwees Hij de mensen telkens op de sabbat. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ze waren diep onder de indruk van zijn leer, want Hij sprak met gezag. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Er was in de synagoge iemand met een demon, een onreine geest, in zich. Hij schreeuwde luid: ");
INSERT INTO nldgbv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wat wilt U van ons, Jezus van Nazaret? Bent U gekomen om ons te vernietigen? Ik weet wie U bent: Gods Heilige.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jezus sprak hem echter berispend toe: “Zwijg en ga uit hem weg.” De demon gooide de man op de grond, midden tussen de mensen, en ging uit de man weg zonder hem te kwetsen. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iedereen stond versteld en de mensen zeiden tegen elkaar: “Wat een woorden! Hij geeft vol gezag en macht bevelen aan de onreine geesten en ze gaan weg!” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Het nieuws over Jezus verspreidde zich naar alle plaatsen in de omgeving. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jezus verliet de synagoge en ging naar het huis van Simon. Simons schoonmoeder had hoge koorts en men vroeg Jezus om iets voor haar te doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hij boog zich over haar heen en sprak de koorts bestraffend toe. Die verdween op hetzelfde moment en de vrouw stond op om hen te bedienen. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bij zonsondergang brachten alle mensen hun zieken bij Hem; ze hadden allerlei verschillende aandoeningen. Hij legde elk van hen de handen op en genas hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bij veel mensen gingen ook de demonen uit hen weg, terwijl ze schreeuwden: “U bent de Zoon van God!” Jezus sprak hen bestraffend toe en liet niet toe dat ze spraken, want ze wisten dat Hij de Messias was. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Toen het ochtend werd, vertrok Jezus naar een eenzame plaats. De mensen zochten Hem en toen ze eindelijk bij Hem waren, probeerden ze te verhinderen dat Hij weg zou gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Maar Hij zei tegen hen: “Ik moet het evangelie van Gods koninkrijk ook verkondigen in de andere steden, want daarvoor ben Ik gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Vanaf toen preekte Hij in de synagogen van Judea. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Op een dag, toen Jezus bij het Meer van Gennesaret stond en de menigte zich rondom Hem verdrong om naar de boodschap van God te luisteren, ");
INSERT INTO nldgbv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","zag Hij twee boten bij de oever liggen. De vissers waren uitgestapt om de netten te spoelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hij stapte in een van de boten, die van Simon, en vroeg hem een eindje het meer op te varen. Hij ging zitten en onderwees de menigte vanuit de boot. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Toen Hij was uitgesproken, zei Hij tegen Simon: “Vaar naar het diepe water en laat jullie netten zakken om iets te vangen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon antwoordde: “Heer, we hebben de hele nacht gezwoegd en niets gevangen. Maar omdat U het zegt, zal ik de netten laten zakken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Toen ze dat hadden gedaan, vingen ze zo'n grote hoeveelheid vis, dat de netten begonnen te scheuren. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ze wuifden naar de vissers in de andere boot, om duidelijk te maken dat die hen moesten komen helpen. Dat deden ze, en beide boten raakten zo vol dat ze begonnen te zinken. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Toen Simon Petrus dat zag, viel hij voor Jezus op zijn knieën en zei hij: “Ga bij mij weg, Heer, want ik ben een zondig mens.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Petrus en iedereen die bij hem was, waren namelijk verbijsterd over de hoeveelheid vis die ze hadden gevangen. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hetzelfde gold voor Jakobus en Johannes, zonen van Zebedeüs die met Simon samenwerkten. Toen zei Jezus tegen Simon: “Wees niet bang. Vanaf nu zal je mensen vangen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ze brachten de boten aan land, lieten alles achter en volgden Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Op een dag, toen Jezus in een van de steden was, was er een man die volledig bedekt was met een huidziekte die hem onrein maakte. Toen hij Jezus zag, liet hij zich voor Hem neervallen en smeekte hij Hem: “Heer, als U wil, kan U mij rein maken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jezus stak zijn hand uit, raakte hem aan en zei: “Ik wil het, word rein.” Meteen verdween de huidziekte. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jezus droeg hem op: “Vertel het aan niemand, maar ga je aan de priester tonen en breng het reinigingsoffer dat Mozes heeft opgelegd, bij wijze van getuigenis voor de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Het nieuws over Jezus verspreidde zich echter nog meer en de mensen kwamen in drommen naar Hem toe om te luisteren en zich van hun aandoeningen te laten genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hij trok zich echter dikwijls naar eenzame plaatsen terug om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Op een dag was Jezus aan het onderwijzen in het bijzijn van farizeeën en Wetgeleerden, die uit alle dorpen in Galilea en Judea en uit Jeruzalem waren gekomen. De kracht van de Heer om mensen te genezen rustte op Jezus ");
INSERT INTO nldgbv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","en er kwamen mannen met een verlamde op een draagbed. Ze probeerden hem naar binnen te brengen en voor Jezus neer te leggen. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Maar er waren zoveel mensen, dat ze geen manier vonden om hem naar binnen te brengen. Daarom gingen ze het dak op en lieten ze hem op zijn draagberrie door een opening in het tegeldak naar beneden zakken, tot vlak voor Jezus en tussen de mensen in. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jezus zag hun geloof en zei: “Vriend, je zonden zijn je vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","De farizeeën en Schriftgeleerden begonnen zich af te vragen: “Wie is dit, dat Hij zo godslasterlijk spreekt? De enige die zonden kan vergeven is God!” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jezus wist wat ze dachten en vroeg hun: “Waarom denken jullie deze dingen? ");
INSERT INTO nldgbv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wat is gemakkelijker, zeggen: je zonden zijn vergeven, of zeggen: sta op en wandel? ");
INSERT INTO nldgbv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Maar, opdat jullie beseffen dat de Mensenzoon het gezag heeft om op aarde zonden te vergeven …” Toen zei Hij tegen de verlamde man: “Tegen jou zeg Ik: sta op, neem je draagberrie op en ga naar huis!” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Op hetzelfde moment stond de man voor hun ogen op. Hij nam zijn bed op en vertrok naar huis terwijl hij God verheerlijkte. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ze waren allemaal buiten zichzelf van verbazing en verheerlijkten God. Ze werden vervuld van ontzag en zeiden: “Vandaag hebben we wonderlijke dingen gezien!” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Daarna ging Jezus de stad uit en zag Hij een belastinginner die Levi heette bij het tolhuis zitten. Jezus zei tegen hem: “Volg Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi stond op, liet alles achter en volgde Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi hield in zijn huis een groot feestmaal voor Jezus. Er nam ook een grote groep belastinginners en anderen aan de maaltijd deel. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","De farizeeën en hun Schriftgeleerden mopperden tegen Jezus' leerlingen: “Waarom eten en drinken jullie met belastinginners en zondaars?” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jezus antwoordde: “Het zijn niet de gezonde mensen die een dokter nodig hebben, maar de zieken. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ik ben niet gekomen om rechtvaardigen op te roepen om tot inkeer te komen, maar zondaars.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Er werd tegen Jezus gezegd: “De leerlingen van Johannes vasten en bidden dikwijls, en ook de leerlingen van de farizeeën, maar die van U eten en drinken er maar op los.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jezus antwoordde: “Je kan de gasten van de bruidegom toch niet laten vasten terwijl de bruidegom bij hen is? ");
INSERT INTO nldgbv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Er komt echter een tijd dat de bruidegom bij hen wordt weggehaald en dan zullen ze vasten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ook vertelde Hij hun een parabel: “Niemand scheurt een stuk van een nieuwe mantel af om het op een oude mantel te naaien, want dan is de nieuwe mantel beschadigd en zit op de oude mantel een stuk stof dat er niet bij past. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ook giet niemand nieuwe wijn in oude wijnzakken, want dan doet de nieuwe wijn de wijnzakken barsten, stroomt de wijn weg en zijn de wijnzakken kapot. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nee, nieuwe wijn moet in nieuwe wijnzakken worden gegoten. ");
INSERT INTO nldgbv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","En niemand die oude wijn heeft gedronken, wil de nieuwe, want hij zal zeggen dat de oude beter is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Op een sabbat, toen Jezus tussen de graanvelden door wandelde, plukten zijn leerlingen enkele aren, wreven die fijn tussen hun handen, en aten ze op. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sommige van de farizeeën zeiden: “Waarom doen jullie iets dat op de sabbat niet is toegestaan?” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jezus antwoordde: “Hebben jullie niet gelezen wat David deed toen hij en zijn mannen honger hadden? ");
INSERT INTO nldgbv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hij ging het huis van God binnen, nam de gewijde broden waarvan enkel de priesters mochten eten, at en gaf ervan aan zijn mannen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hij zei tegen hen: “De Mensenzoon is baas over de sabbat.” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Op een andere sabbat, toen Hij naar de synagoge ging om te onderwijzen, was daar iemand met een verlamde rechterhand. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","De Schriftgeleerden en de farizeeën hielden Jezus in de gaten om te zien of Hij op de sabbat zou genezen. Ze zochten namelijk iets waarvan ze Hem konden beschuldigen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hij wist echter wat ze dachten en zei tegen de man met de verlamde hand: “Kom in het midden staan.” De man kwam daar staan. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jezus zei tegen hen: “Ik zal jullie eens iets vragen. Wat is toegestaan op de sabbat: goed doen of kwaad doen, een leven redden of het vernietigen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hij keek om zich heen, naar hen allen, en zei tegen de man: “Steek je hand uit.” Dat deed de man en zijn hand genas. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Zij werden echter woedend en bespraken onder elkaar wat ze met Jezus zouden doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Het was in die periode dat Jezus de berg op ging om te bidden en de hele nacht doorbracht in gebed tot God. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Toen het dag werd, riep Hij zijn leerlingen bij zich. Hij koos twaalf van hen uit en noemde hen apostelen: ");
INSERT INTO nldgbv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, die ook Petrus wordt genoemd, zijn broer Andreas, Jakobus, Johannes, Filippus, Bartolomeüs, ");
INSERT INTO nldgbv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matteüs, Tomas, Jakobus, de zoon van Alfeüs, Simon die de Zeloot wordt genoemd, ");
INSERT INTO nldgbv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, de zoon van Jakobus, en Judas Iskariot, die een verrader werd. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jezus daalde met hen de berg af en ging op een vlak terrein staan, samen met een grote groep van zijn leerlingen en een groot aantal mensen uit heel Judea, Jeruzalem en de kuststrook van Tyrus en Sidon. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Zij waren gekomen om naar Hem te luisteren en van hun ziekten te worden genezen. Ook wie werd gekweld door onreine geesten, werd genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iedereen in de menigte probeerde Hem aan te raken, omdat er kracht van Hem uitging en Hij hen allen genas. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hij keek zijn leerlingen aan en zei: “Jullie die arm zijn, zijn gezegend, want Gods koninkrijk behoort jullie toe. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jullie die nu honger hebben, zijn gezegend, want je zal verzadigd worden. Jullie die nu wenen, zijn gezegend, want je zal lachen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jullie zijn gezegend wanneer de mensen je haten en wanneer ze je buitensluiten en bespotten en je naam bezoedelen omwille van de Mensenzoon. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wanneer dat gebeurt, verheug je dan en spring op van blijdschap, want jullie beloning in de hemel zal groot zijn. De profeten werden namelijk ook zo behandeld door de voorouders van deze mensen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Maar wee jullie rijken, want jullie hebben je troost reeds ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wee jullie die nu voldoende te eten hebben, want je zal hongerlijden. Wee jullie die nu lachen, want je zal rouwen en wenen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wee jullie wanneer alle mensen positief over je spreken, want hun voorouders deden dat met de valse profeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Maar tegen jullie die luisteren, zeg Ik: heb je vijanden lief, doe goed aan wie jullie haten. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Zegen wie jullie verwensen, bid voor wie jullie beledigen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Als iemand jou op de wang slaat, bied hem dan ook je andere wang aan; als iemand je mantel afneemt, ontzeg hem dan niet je hemd. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Geef aan iedereen die iets van je wil hebben en als iemand iets van je afneemt, eis het dan niet terug. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Behandel de mensen op de manier waarop jullie door hen behandeld willen worden. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Als jullie liefdevol behandelen wie jullie liefdevol behandelt, is dat toch geen verdienste? Zelfs de zondaars hebben lief wie hen liefheeft. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","En als jullie goed behandelen wie jullie goed behandelt, is dat toch geen verdienste? Zelfs de zondaars doen dat. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","En als je leent aan diegenen van wie jullie hopen terug te krijgen, dan is dat toch geen verdienste? Zelfs de zondaars lenen aan zondaars om hetzelfde bedrag terug te krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Heb je vijanden lief en doe goed en leen aan anderen zonder tegenprestaties te verwachten. Dan zal je beloning groot zijn en zullen jullie kinderen van de Allerhoogste zijn, want Hij is goed voor de mensen die ondankbaar en slecht zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Toon medeleven, zoals jullie Vader medeleven toont. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Oordeel niet over anderen, dan zal er over jou niet worden geoordeeld. Veroordeel anderen ook niet, dan zal je zelf niet worden veroordeeld. Vergeef, dan zal jou worden vergeven. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Geef, dan zal aan jou worden gegeven. Een maatbak vol – aangedrukt, geschud en overvol – zal je worden toebedeeld, want de maat die jij hanteert, zal op jou worden toegepast.” ");
INSERT INTO nldgbv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hij vertelde hun nog een parabel: “Een blinde kan toch geen blinde leiden? Dan vallen ze toch allebei in een kuil? ");
INSERT INTO nldgbv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Een leerling staat niet boven zijn leraar, maar ieder die volleerd is, zal zijn zoals zijn leraar. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hoe is het mogelijk dat je wel de splinter in het oog van je naaste ziet, maar de balk in je eigen oog niet opmerkt? ");
INSERT INTO nldgbv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hoe kan je tegen je naaste zeggen: broer, laat mij die splinter uit je oog verwijderen, terwijl je de balk in jouw oog niet ziet? Hypocriet, verwijder eerst de balk uit je eigen oog. Dan zal je goed genoeg zien om de splinter uit het oog van je naaste te verwijderen. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Er is geen goede boom die slechte vruchten oplevert, en ook geen slechte boom die goede vruchten oplevert. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Want elke boom is herkenbaar aan zijn vruchten. Men kan toch geen vijgen oogsten van een doornstruik, of druiven plukken van een stekelplant? ");
INSERT INTO nldgbv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Een goed mens haalt uit de voorraad goedheid in zijn hart goede dingen tevoorschijn, en een slecht mens haalt slechte dingen tevoorschijn uit zijn voorraad slechtheid. Want waar het hart vol van is, daarvan spreekt de mond. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Waarom spreken jullie Mij aan met ‘Heer, Heer’, maar doen jullie niet wat Ik zeg? ");
INSERT INTO nldgbv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ieder die naar Mij toe komt, mijn woorden hoort en ze in praktijk brengt – Ik zal jullie uitleggen waarop hij lijkt. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hij lijkt op iemand die een huis bouwde en eerst een diepe sleuf groef om het fundament op rotsgrond te leggen. Toen er een overstroming kwam en het water tegen dat huis beukte, konden die het huis niet doen wankelen, omdat het stevig was gebouwd. ");
INSERT INTO nldgbv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maar wie mijn woorden hoort en ze niet in praktijk brengt, is als iemand die een huis bouwde zonder fundament, los op de aarde. Toen het water ertegenaan beukte, stortte het meteen in en was het volledig verwoest.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nadat Jezus dit alles aan het luisterende volk had verteld, ging Hij Kafarnaüm binnen. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Daar was een centurio met een slaaf die veel voor hem betekende en die ernstig ziek was en op sterven lag. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Toen de centurio het nieuws over Jezus hoorde, stuurde hij oudsten van het Joodse volk naar Hem toe om Hem te vragen, zijn slaaf te komen genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Toen die oudsten bij Jezus waren gekomen, drongen ze sterk bij Hem aan: “Hij is het waard dat U dit voor hem doet, ");
INSERT INTO nldgbv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","want hij houdt van ons volk en heeft zelfs onze synagoge laten bouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jezus ging met hen mee, maar toen Hij dicht bij het huis was, stuurde de centurio vrienden met de boodschap: “Heer, doe geen moeite, want ik ben het niet waard dat U mijn huis binnengaat. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Daarom durfde ik niet zelf naar U toe te gaan, maar op uw bevel zal mijn knecht genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ik ben namelijk ook iemand die onder gezag staat en zelf soldaten heeft. Als ik tegen de ene ‘ga’ zeg, dan gaat hij, en tegen een andere ‘kom’, dan komt hij, en als ik tegen mijn slaaf zeg: ‘doe dit’, dan doet hij het.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Toen Jezus dat hoorde, verbaasde Hij zich over hem. Hij draaide zich om naar de menigte die Hem volgde en zei: “Ik zeg jullie: bij niemand in Israël heb Ik zo'n groot geloof gevonden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De vrienden die de centurio had gestuurd, keerden naar het huis terug en troffen de slaaf in goede gezondheid aan. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Niet lang daarna ging Jezus naar een stad die Naïn heet. Zijn leerlingen en een grote menigte kwamen met Hem mee. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Toen Jezus de stadspoort naderde, werd er een dode naar buiten gedragen om te worden begraven. Hij was de enige zoon van zijn moeder en zij was weduwe. Er kwam een grote menigte uit de stad met haar mee. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Toen de Heer de vrouw zag, kreeg Hij medelijden met haar. Hij zei tegen haar: “Ween maar niet.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hij ging naar de lijkbaar toe en raakte die aan. De dragers hielden stil en Jezus zei: “Jongeman, Ik zeg je, verrijs.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","De dode ging overeind zitten, begon te praten en werd door Jezus aan de moeder overgedragen. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iedereen werd vervuld van ontzag en verheerlijkte God door te zeggen: “Er is een groot profeet onder ons opgestaan”, en: “God heeft acht geslagen op zijn volk.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dit nieuws over Jezus verspreidde zich in heel Judea en de wijde omtrek. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","De leerlingen van Johannes brachten hem over al deze dingen verslag uit. Daarom riep Johannes twee van zijn leerlingen bij zich ");
INSERT INTO nldgbv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","en hij stuurde hen naar de Heer met de vraag: “Bent U degene die zou komen, of moeten we iemand anders verwachten?” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","De mannen kwamen bij Jezus en zeiden: “Johannes de Doper heeft ons gestuurd om U te vragen: Bent U degene die zou komen, of moeten we iemand anders verwachten?” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jezus was op dat moment veel mensen aan het genezen van ziekten, aandoeningen en onreine geesten en Hij gaf veel blinden het zicht. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hij zei tegen Johannes' leerlingen: “Ga Johannes vertellen wat jullie hebben gezien en gehoord: blinde mensen kunnen weer zien, verlamde mensen beginnen te stappen, mensen met een huidziekte worden rein, dove mensen kunnen weer horen, dode mensen verrijzen, en aan arme mensen wordt het evangelie verkondigd. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wie zich niet aan Mij ergert, is gezegend.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Toen de boodschappers waren vertrokken, zei Jezus over Johannes tegen de mensenmassa: “Wat zijn jullie gaan bekijken in de wildernis? Riet dat wuift in de wind? ");
INSERT INTO nldgbv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nee! Wat gingen jullie bekijken: een man in mooie kleren? Nee, zij die dure kledij dragen en in luxe leven, bevinden zich in paleizen. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wat gingen jullie dan wel bekijken? Een profeet? Jazeker, zeg Ik jullie, iemand die meer is dan een profeet. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hij is het over wie werd geschreven: ‘Ik stuur mijn boodschapper voor Je uit, die de weg voor Je zal banen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ik zeg jullie: onder hen die uit een vrouw zijn geboren, is niemand belangrijker dan Johannes de Doper, maar in Gods koninkrijk is de geringste belangrijker dan Hij. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Door zich te laten dopen met de doop van Johannes erkende heel het volk dat naar hem had geluisterd, ook de belastinginners, dat Gods eisen juist zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","De farizeeën en Wetgeleerden lieten zich echter niet door hem dopen en weigerden te doen wat God van hen wilde. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Waarmee zal Ik dit soort mensen vergelijken, waar lijken ze op? ");
INSERT INTO nldgbv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ze zijn als kinderen die op het marktplein zitten en naar elkaar roepen: ‘Wij hebben voor jullie op de fluit gespeeld en jullie hebben niet gedanst; we hebben een klaaglied gezongen en jullie hebben niet geweend!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Want toen Johannes de Doper was gekomen, die geen brood at en geen wijn dronk, zeiden jullie: ‘Hij heeft een demon in zich.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","En nu de Mensenzoon is gekomen, die wel eet en drinkt, zeggen jullie: ‘Kijk, een veelvraat en een dronkaard, een vriend van belastinginners en zondaars!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Maar de juistheid van wijsheid wordt aangetoond door allen die wijze daden doen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Eén van de farizeeën nodigde Jezus uit voor een maaltijd bij hem thuis. Jezus ging naar het huis van die farizeeër en nam plaats aan tafel. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Er was een vrouw die in die stad bekendstond als een zondares. Zij kwam te weten dat Jezus aan de maaltijd deelnam in het huis van de farizeeër en ging erheen met een albasten flesje geurige olie. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ze ging wenend achter Jezus staan, bij zijn voeten. Door haar tranen werden zijn voeten nat en zij droogde ze met haar haren. Ook kuste ze zijn voeten en zalfde deze met de olie. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Toen de farizeeër die Jezus had uitgenodigd dit zag, dacht hij: “Als Jezus een profeet was, zou Hij weten wie het is die Hem aanraakt en wat voor vrouw zij is. Ze is een zondares.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Daarom zei Jezus tegen hem: “Simon, Ik heb je iets te vertellen.” Hij antwoordde: “Leraar, zegt U het maar.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Twee mensen stonden in de schuld bij een geldschieter; de een voor vijfhonderd denarie, de ander voor vijftig. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Toen ze niet konden betalen, schold hij hun allebei hun schuld kwijt. Wie van hen zou het meest van hem houden?” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon antwoordde: “Ik veronderstel de persoon aan wie het grootste bedrag was kwijtgescholden.” Jezus zei tegen hem: “Je hebt het juiste antwoord gegeven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hij keerde zich naar de vrouw toe en zei: “Simon, zie je deze vrouw? Ik ben naar je huis gekomen en je hebt Mij geen water gegeven voor mijn voeten. Maar zij heeft mijn voeten gewassen met haar tranen en ze gedroogd met haar haren. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jij hebt Mij niet met een kus verwelkomd, maar sinds Ik ben binnengekomen heeft zij zonder ophouden mijn voeten gekust. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jij hebt mijn hoofd niet met olijfolie gezalfd, maar zij heeft mijn voeten gezalfd met geurige olie. ");
INSERT INTO nldgbv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Daarom zeg Ik je: haar vele zonden zijn vergeven; ze heeft namelijk veel liefde betoond. Maar wie weinig werd vergeven, betoont weinig liefde.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Toen zei Hij tegen haar: “Je zonden zijn vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","De andere gasten begonnen onder elkaar te zeggen: “Wie is dit, dat Hij zelfs zonden vergeeft?” ");
INSERT INTO nldgbv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jezus zei tegen de vrouw: “Je geloof heeft je gered. Ga in vrede.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kort daarna reisde Jezus langs steden en dorpen, om daar het goede nieuws van Gods koninkrijk te verkondigen. De Twaalf waren bij Hem, ");
INSERT INTO nldgbv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","en ook enkele vrouwen die Hij had genezen van boze geesten en van aandoeningen: Maria die ‘van Magdala’ werd genoemd, bij wie zeven demonen waren uitgedreven; ");
INSERT INTO nldgbv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Johanna, de vrouw van Chusas, het hoofd van de hofhouding van Herodes; Susanna en nog veel anderen. Met gebruik van eigen middelen voorzagen deze vrouwen in het onderhoud van Jezus en de Twaalf. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Toen er een grote menigte was bijeengekomen en mensen uit allerlei steden naar Jezus toe waren gekomen, vertelde Hij een parabel: ");
INSERT INTO nldgbv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Er was eens een zaaier die ging zaaien. Tijdens het zaaien viel er wat zaad naast het pad; het werd vertrappeld en de vogels pikten het op. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ander zaad viel op de rots en toen het opkwam, verschroeide het omdat het geen vocht had. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nog ander zaad viel tussen het onkruid, en toen het opkwam werd het door het onkruid verstikt. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Het overige zaad viel in goede aarde, en toen het was opgekomen, leverde het een honderdvoudige oogst op.” Toen Hij dit had gezegd, riep Hij: “Als je oren hebt om te horen, luister dan!” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jezus' leerlingen vroegen Hem wat de parabel betekende. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hij zei: “Het is jullie gegeven de geheimen van Gods koninkrijk te kennen, maar tot de anderen spreek Ik in parabels, zodat ze ‘wel zien maar niet begrijpen, en wel horen maar niet verstaan.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","De parabel betekent het volgende: Het zaad is de boodschap van God aan de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Het zaad naast het pad zijn de mensen die de boodschap hebben gehoord. Maar dan komt de duivel die uit hun hart wegnemen, zodat ze niet tot geloof komen en gered worden. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Het zaad op de rots zijn de mensen die de boodschap horen en met vreugde aanvaarden. Ze hebben echter geen wortels en ze geloven wel een tijdlang, maar zodra ze op de proef worden gesteld, geven ze op. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Het zaad dat tussen het onkruid viel, zijn de mensen die de boodschap hebben gehoord, maar bij wie deze verstikt raakt door de zorgen, rijkdom en geneugten van het leven, zodat ze geen rijpe oogst opleveren. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","En het zaad in de goede aarde zijn de mensen die de boodschap met een eerlijk en goed hart hebben beluisterd, haar in zich opnemen, en vruchtdragen doordat ze standvastig zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Niemand die een olielamp heeft aangestoken, verbergt haar onder een pot of zet haar onder een bed. Integendeel, hij zet haar op een standaard, zodat zij die binnenkomen het licht zien. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Er is niets geheim dat niet zichtbaar zal worden gemaakt, en niets verhuld dat niet zal worden bekendgemaakt en aan het licht zal komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Denk dus zorgvuldig na over wat jullie horen. Want aan wie heeft, zal nog meer worden gegeven, maar van wie niets heeft, zal zelfs hetgeen hij denkt te hebben worden afgenomen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jezus' moeder en broers kwamen naar Hem toe, maar wegens de menigte lukte het hun niet om bij Hem te komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Er werd aan Hem verteld: “Uw moeder en uw broers staan buiten en ze willen U zien.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Maar Jezus antwoordde: “Mijn moeder en mijn broers zijn zij die Gods evangelie horen en in praktijk brengen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Op een dag zei Jezus tegen zijn leerlingen: “Laten we naar de overkant van het meer varen.” Ze stapten in een boot en voeren weg. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tijdens het varen viel Jezus in slaap. Er raasde een zware storm over het meer, de boot maakte water en ze raakten in gevaar. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jezus' leerlingen gingen naar Hem toe, maakten Hem wakker en riepen: “Heer, Heer, we vergaan!” Jezus werd wakker en berispte de wind en de woeste golven. De storm ging liggen en het werd stil. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jezus vroeg hun: “Waar was jullie geloof?” Bang en verwonderd zeiden ze tegen elkaar: “Wie is Hij toch, dat Hij zelfs bevelen aan de wind en het water geeft en dat die Hem gehoorzamen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ze voeren naar het gebied van de Gerasenen; dat ligt tegenover Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Toen Jezus aan wal stapte, kwam er een man naar Hem toe, die demonen in zich had. Hij was uit de stad afkomstig, maar woonde tussen de graven in plaats van in een huis en hij droeg sinds lang geen kleren meer. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Toen hij Jezus zag, viel hij voor Hem op zijn knieën en riep hij: “Waarom bemoeit U zich met mij, Jezus, Zoon van de Allerhoogste God? Ik smeek U, folter mij alstublieft niet!” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jezus had de onreine geest namelijk bevolen om uit de man weg te gaan. De man was al vele malen door de onreine geest overmand en hoewel hij geketend aan handen en voeten werd bewaakt, brak hij dan zijn boeien stuk en werd hij door de demon naar eenzame plaatsen gedreven. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jezus vroeg hem: “Hoe heet je?” Hij antwoordde: “Legio”, want er waren veel demonen in hem komen wonen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ze smeekten Hem om hen niet naar de hel te verbannen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nu was er op de berg een grote kudde varkens aan het grazen. De demonen smeekten Jezus, toe te laten dat ze die varkens zouden binnendringen, en Hij liet het toe. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","De demonen kwamen uit de man naar buiten en drongen de varkens binnen; de kudde stormde de helling af, het meer in, en ze verdronken. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Toen de varkenshoeders zagen wat er was gebeurd, renden ze weg en brachten ze verslag uit in de stad en de omliggende dorpen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Daarom kwamen de mensen kijken wat er gebeurd was. Toen ze bij Jezus kwamen, zagen ze de man uit wie de demonen naar buiten waren gekomen, gekleed en bij zijn volle verstand aan Jezus' voeten zitten en ze werden bang. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Zij die hadden gezien hoe de bezeten man was genezen, vertelden het hun. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Alle mensen uit het gebied van de Gerasenen smeekten Jezus, bij hen weg te gaan, want ze waren door grote angst bevangen. Daarom stapte Hij in de boot en keerde Hij terug. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","De man uit wie de demonen waren weggegaan, smeekte om met Hem te mogen meekomen. Maar Jezus stuurde hem weg met de woorden: ");
INSERT INTO nldgbv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ga naar huis en vertel daar wat God voor jou heeft gedaan.” De man trok door de hele stad en verkondigde wat Jezus voor hem had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Toen Jezus terugkwam, werd Hij door de menigte verwelkomd. Iedereen had op Hem gewacht. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Toen kwam er iemand die Jaïrus heette en synagogebestuurder was. Hij liet zich aan Jezus' voeten neervallen en smeekte Hem, naar zijn huis te komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Zijn enige dochter, die ongeveer twaalf jaar oud was, lag namelijk op sterven. Onderweg verdrong de mensenmassa zich rondom Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Er was ook een vrouw die al twaalf jaar last had van bloedingen, en hoewel ze haar hele levensonderhoud aan dokters had uitgegeven, was er niemand die haar had kunnen genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Zij benaderde Jezus van achteren en raakte de kwast onderaan zijn mantel aan. Op dat moment stopte het bloeden. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jezus vroeg: “Wie heeft Mij aangeraakt?” Iedereen ontkende en Petrus zei: “Heer, de menigte staat om U heen en dringt tegen U aan!” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maar Jezus zei: “Iemand heeft Mij aangeraakt, want Ik heb gemerkt dat er kracht van Mij uitging.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Toen de vrouw inzag dat ze niet onopgemerkt kon blijven, kwam ze bevend naar Hem toe en liet ze zich voor Hem neervallen. Ze verklaarde waar iedereen bij stond waarom ze Hem had aangeraakt en hoe ze op dat moment was genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jezus zei tegen haar: “Mijn dochter, je geloof heeft je genezen; ga in vrede.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Terwijl Hij nog sprak, kwam iemand van het huishouden van de synagogebestuurder zeggen: “Uw dochtertje is gestorven, val de Leraar niet meer lastig.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Toen Jezus dat hoorde, zei Hij tegen Jaïrus: “Wees niet bang, je moet enkel geloven; dan zal ze genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Toen Jezus bij het huis aankwam, liet Hij niet toe dat er iemand met Hem naar binnen ging, behalve Petrus, Johannes, Jakobus en de vader en moeder van het kind. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iedereen was om haar aan het wenen en treuren, maar Jezus zei: “Stop met wenen, want ze is niet dood; ze slaapt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","De mensen lachten Hem uit, want ze wisten dat ze was gestorven. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Maar Jezus nam haar hand vast en riep: “Kind, sta op!” ");
INSERT INTO nldgbv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Haar geest keerde naar haar terug en ze stond meteen op. Hij zei dat men haar iets te eten moest geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Haar ouders waren buiten zichzelf van verbazing, maar Hij droeg hun op aan niemand te vertellen wat er was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jezus riep de Twaalf bijeen en gaf hun macht en gezag over alle demonen en ook om ziekten te genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hij stuurde hen op pad om Gods koninkrijk te verkondigen en zieken te genezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hij zei tegen hen: “Neem niets mee voor onderweg; geen wandelstok, geen reistas, geen brood, geen geld, zelfs geen extra kledij. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wanneer jullie bij iemand te gast zijn, blijf dan bij die persoon logeren totdat je uit die plaats vertrekt. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Uit elke stad waar men jullie niet verwelkomt, moet je vertrekken en het stof van je voeten schudden als een teken van je afkeuring.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ze gingen op pad en trokken langs de dorpen, terwijl ze overal het evangelie verkondigden en mensen genazen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","De tetrarch Herodes hoorde wat er allemaal gebeurde en was zeer verbaasd, want er werd door sommigen beweerd dat Johannes uit de dood was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anderen zeiden dat Elia was verschenen, nog anderen dat een van de profeten uit vroeger tijden was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes zei echter: “Johannes heb ik laten onthoofden. Wie is dit dan, over Wie ik deze verhalen hoor?” Hij probeerde Jezus te ontmoeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Toen de apostelen terugkwamen, vertelden ze Jezus wat ze hadden gedaan. Hij trok zich terug naar een stadje dat Betsaïda heet en nam hen mee, zodat ze onder elkaar waren. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","De massa kwam het echter te weten en volgde Hem. Hij verwelkomde de mensen en sprak hen toe over Gods koninkrijk. Ook genas Hij wie nood aan genezing had. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tijdens de late namiddag kwamen de Twaalf naar Hem toe. Ze zeiden: “Stuur de mensen toch weg, zodat ze naar de dorpen en gehuchten in de omgeving kunnen gaan om onderdak en eten te zoeken, want we zijn hier op een afgelegen plaats.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jezus zei tegen hen: “Geven jullie hun maar te eten.” Zij antwoordden: “We hebben slechts vijf broden en twee vissen, tenzij we eropuit gaan om eten voor al deze mensen te kopen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Er waren ongeveer vijfduizend mannen. Jezus zei tegen zijn leerlingen: “Zeg dat ze in groepen van vijftig moeten plaatsnemen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dat deden de leerlingen en iedereen nam plaats. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jezus nam de vijf broden en de twee vissen, keek omhoog naar de hemel, sprak een zegengebed uit, brak de broden in stukken en gaf die aan zijn leerlingen. Zij deelden ze uit aan de mensen, ");
INSERT INTO nldgbv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","en ze aten allen totdat ze voldaan waren. Het overschot werd verzameld: twaalf manden vol met brokken. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Op een dag, toen Jezus aan het bidden was, met alleen zijn leerlingen bij zich, vroeg Hij hun: “Wie zeggen de mensen dat Ik ben?” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ze antwoordden: “Johannes de Doper; anderen zeggen Elia, en nog anderen dat een profeet uit vroeger tijden verrezen is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hij vroeg hun: “En jullie, wie zeggen jullie dat Ik ben?” Petrus antwoordde: “De door God gestuurde Messias.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jezus beval hun nadrukkelijk, dit aan niemand te vertellen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hij vervolgde: “De Mensenzoon zal veel lijden moeten doorstaan en door de oudsten en hoofdpriesters en Schriftgeleerden worden verworpen en gedood, en op de derde dag zal Hij weer tot leven worden gewekt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hij zei tegen hen allen: “Als iemand met Mij wil meekomen, moet hij zichzelf verloochenen, dagelijks zijn kruis opnemen en Mij volgen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wie zijn leven wil redden, zal het verliezen, maar wie zijn leven loslaat voor Mij, zal het redden. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wat heeft een mens eraan als hij de hele wereld wint maar zichzelf verliest of te gronde richt? ");
INSERT INTO nldgbv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Als iemand zich voor Mij en mijn woorden schaamt, zal de Mensenzoon zich voor hem schamen wanneer Hij komt in de hemelse pracht die Hem, de Vader en de heilige engelen omringt. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Maar Ik verzeker jullie, sommigen die hier staan zullen niet sterven voordat ze Gods koninkrijk hebben gezien.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ongeveer acht dagen nadat Hij dit had gezegd, nam Hij Petrus, Johannes en Jakobus met zich mee om op een berg te gaan bidden. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Terwijl Hij bad, veranderde de aanblik van zijn gezicht en zijn kledij werd verblindend wit. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Plots waren er twee mannen met Hem in gesprek; het waren Mozes en Elia. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ze waren verschenen in hemelse pracht en spraken over Jezus' heengaan – de taak die Hij binnenkort in Jeruzalem zou uitvoeren. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus en zijn vrienden raakten door slaap overmand en toen ze wakker werden, zagen ze Jezus' hemelse pracht en de mannen die bij Hem stonden. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Toen die aanstalten maakten om bij Hem weg te gaan, zei Petrus tegen Jezus: “Heer, het is goed dat wij hier zijn. Laten we drie hutten bouwen, een voor U, een voor Mozes en een voor Elia.” Hij wist niet wat hij zei. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Terwijl hij nog sprak, kwam er een wolk die hen overdekte. Toen de wolk hen omhulde, werden ze bang. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Vanuit de wolk klonk een stem die zei: “Dit is mijn Zoon, de Uitverkorene. Luister naar Hem.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nadat de stem had gesproken, zagen Jezus' leerlingen dat Hij weer alleen was. Ze bewaarden het stilzwijgen en vertelden in die tijd aan niemand wat ze hadden gezien. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","De volgende dag, toen ze van de berg afdaalden, ging een grote menigte Jezus tegemoet. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Een man riep vanuit de mensenmassa: “Leraar, ik smeek U om naar mijn zoon te kijken; hij is mijn enig kind. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hij wordt steeds door een geest overmand en dan schreeuwt hij plots; dan laat hij hem stuiptrekken met een schuimende mond, en hij laat hem pas met rust wanneer hij hem volledig heeft uitgeput. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ik heb uw leerlingen gesmeekt om hem uit te drijven, maar ze konden het niet.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jezus antwoordde: “O ongelovige en tegendraadse mensen, hoelang zal Ik nog bij jullie zijn en zal Ik jullie verdragen? Breng je zoon hier.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Terwijl het kind naar Hem toekwam, gooide de demon hem stuiptrekkend op de grond. Jezus sprak de onreine geest bestraffend toe, genas het kind en droeg hem over aan zijn vader. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iedereen was diep onder de indruk van Gods grootheid. Terwijl iedereen ontdaan was over alles wat Jezus deed, zei Hij tegen zijn leerlingen: ");
INSERT INTO nldgbv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Laat deze woorden goed tot jullie doordringen: binnenkort zal de Mensenzoon aan de mensen worden uitgeleverd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Maar ze begrepen deze uitspraak niet en de betekenis bleef voor hen verhuld, zodat ze het niet konden bevatten. Ze durfden Hem niet te vragen wat Hij bedoelde. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Onder Jezus' leerlingen ontstond een discussie over wie van hen de belangrijkste was. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Toen Jezus merkte wat er in hun hart omging, nam Hij een kind, zette het naast zich neer, ");
INSERT INTO nldgbv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","en zei Hij tegen hen: “Wie in mijn naam dit kind verwelkomt, verwelkomt Mij. En wie Mij verwelkomt, verwelkomt Degene die Mij heeft gezonden. Want wie van jullie de geringste is, is de belangrijkste.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johannes reageerde: “Heer, wij zagen iemand in uw naam demonen uitdrijven en wij wilden het hem verbieden omdat hij niet bij ons hoort.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jezus zei tegen hem: “Verbied het hem niet, want wie niet tegen jullie is, is voor jullie.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Toen de tijd naderde dat Jezus in de hemel zou worden opgenomen, ging Hij vastberaden op weg naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hij stuurde boodschappers voor zich uit en zij gingen onderweg een Samaritaans dorp binnen om voorbereidingen te treffen voor zijn komst. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","De dorpelingen weigerden echter Jezus te ontvangen, omdat Hij naar Jeruzalem onderweg was. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Toen Jakobus en Johannes, leerlingen van Jezus, dat zagen, vroegen ze: “Heer, wilt U dat we zeggen dat er vuur uit de hemel moet komen om hen te vernietigen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jezus draaide zich echter naar hen toe en berispte hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Toen gingen ze naar een ander dorp. ");
INSERT INTO nldgbv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Terwijl ze onderweg waren, zei iemand tegen Jezus: “Ik zal U volgen, waarheen U ook gaat.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jezus antwoordde: “Vossen hebben holen en vogels hebben nesten, maar de Mensenzoon heeft geen plaats om zijn hoofd te laten rusten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tegen iemand anders zei Jezus: “Volg Mij”, maar die persoon zei: “Heer, laat mij eerst gaan zodat ik mijn vader kan begraven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jezus antwoordde: “Laat de doden hun doden begraven; jij moet op pad gaan om Gods koninkrijk te verkondigen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nog iemand anders zei: “Ik zal U volgen, Heer, maar laat me eerst afscheid nemen van mijn familie.” ");
INSERT INTO nldgbv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tegen hem zei Jezus: “Niemand die begint te ploegen en dan achterom kijkt, is geschikt om dienst te doen in Gods koninkrijk.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Later stelde Jezus nog 72 personen aan. Hij stuurde hen twee aan twee voor zich uit, naar elke stad en plaats waarheen Hij zelf wilde gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hij zei tegen hen: “De oogst is wel groot, maar er zijn weinig arbeiders. Smeek daarom de Heer van de oogst om arbeiders naar zijn oogst te zenden. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ga, Ik stuur jullie eropuit als lammeren onder de wolven. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Neem geen geldbuidel, geen reistas en geen extra schoenen mee, en stop nooit onderweg om iemand te begroeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Telkens wanneer jullie bij iemand te gast zijn, zeg dan bij het binnengaan van hun huis: ‘Ik wens de mensen in dit huis vrede toe.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Als daar iemand is die jullie vredeswens waard is, zal hij de vrede ontvangen die je hem toewenst, maar anders zal je vredeswens geen effect op hem hebben. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Blijf in dat huis logeren en eet en drink wat je wordt voorgezet, want de arbeider is zijn loon waard. Trek niet van het ene huis naar het andere. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wanneer je een stad binnenkomt en men je daar verwelkomt, eet dan wat je wordt voorgezet. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Genees er wie ziek is, en zeg tegen de mensen: ‘Gods koninkrijk is bijna bij jullie.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Maar wanneer je een stad binnenkomt en men je daar niet verwelkomt, ga dan de straten van die stad op en zeg: ");
INSERT INTO nldgbv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Het stof van jullie stad dat nog aan onze voeten kleeft, vegen wij af als een teken van onze afkeuring. Maar jullie moeten weten dat Gods koninkrijk in aantocht is.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ik zeg jullie dat het op de Oordeelsdag draaglijker zal zijn voor Sodom dan voor die stad. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wee jou, Chorazin, wee jou, Betsaïda, want als de wonderen die bij jullie zijn gebeurd, zouden hebben plaatsgevonden in Tyrus en Sidon, dan zou men daar allang in zak en as hebben gezeten en tot inkeer zijn gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bij het Oordeel zal het draaglijker zijn voor de mensen van Tyrus en Sidon dan voor jullie. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","En jij, Kafarnaüm, zal jij worden verheven naar de hemel? Nee, je zal worden verlaagd naar het dodenrijk. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wie naar jullie luistert, luistert naar Mij, en wie jullie afwijst, wijst Mij af. En wie Mij afwijst, wijst Hem af die Mij heeft gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","De 72 kwamen vol vreugde terug. Ze zeiden: “Heer, zelfs de demonen onderwerpen zich aan ons wanneer wij uw naam noemen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hij antwoordde: “Ik heb Satan als een bliksem uit de hemel zien vallen. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ik heb jullie de macht gegeven om op slangen en schorpioenen te trappen en de vijand te overwinnen. Niets zal jullie kwaad kunnen doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Verheug je er echter niet over dat de geesten zich aan jullie onderwerpen, verheug je erover dat jullie namen in de hemel staan genoteerd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Op dat moment werd Jezus door de Heilige Geest vervuld met vreugde en Hij juichte: “Ik dank U, Vader, Heer van hemel en aarde, dat U deze dingen hebt verborgen voor wijzen en verstandigen, maar ze hebt onthuld aan eenvoudigen. Ja, Vader, want zo is het goed in uw ogen. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mijn Vader heeft Mij alles toevertrouwd. Er is niemand die weet wie de Zoon is behalve de Vader, en niemand die weet wie de Vader is behalve de Zoon en zij aan wie de Zoon Hem wenst bekend te maken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jezus richtte zich tot zijn leerlingen toen Hij met hen alleen was. Hij zei: “De ogen die zien wat jullie zien, zijn gezegend. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Want Ik zeg jullie: veel profeten en koningen wilden zien wat jullie zien, maar ze hebben het niet gezien. En ze wilden horen wat jullie horen, maar ze hebben het niet gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Er was een Wetgeleerde die Jezus op de proef stelde met de vraag: “Leraar, wat moet ik doen om het eeuwig leven te ontvangen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jezus vroeg hem: “Wat staat er in de Wet? Wilt u dat citeren?” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","De man antwoordde: “Heb de Heer, je God, lief met heel je hart, met heel je ziel, met al je kracht en met heel je verstand, en heb je naaste lief zoals je jezelf liefhebt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jezus zei: “U heeft het juiste antwoord gegeven. Doe dat, en u zal leven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","De Wetgeleerde wilde zichzelf rechtvaardigen en vroeg aan Jezus: “Wie is mijn naaste?” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jezus antwoordde: “Er was eens een man, die van Jeruzalem naar Jericho reisde en door rovers werd overvallen. Ze namen hem zijn kleren af, sloegen hem in elkaar, lieten hem halfdood achter en gingen weg. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Toevallig kwam er een priester langs diezelfde weg. Toen hij de man zag, ging hij aan de andere kant van de weg voorbij. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ook was er een Leviet. Toen die langs die plaats kwam en de man zag, ging ook hij aan de andere kant voorbij. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Toen kwam er een Samaritaan voorbij, die op reis was. Toen hij de man zag, kreeg hij medelijden. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hij ging naar hem toe, goot olie en wijn over zijn wonden en verbond die, zette hem op zijn eigen rijdier, bracht hem naar een herberg en verzorgde hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","De volgende dag nam hij twee denarie en gaf die aan de herbergier met de woorden: ‘Zorg voor hem, en als het meer kost, zal ik u betalen wanneer ik terugkom.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wie van deze drie, denkt u, was een naaste voor de man die door rovers was overvallen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","De Wetgeleerde antwoordde: “De persoon die mededogen betoonde.” Jezus zei tegen hem: “Ga nu hetzelfde doen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Onderweg ging Jezus in een dorp binnen, waar een vrouw die Marta heette Hem thuis verwelkomde. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Zij had een zus die Maria heette en die aan Jezus' voeten ging zitten om te luisteren, terwijl Hij vertelde. ");
INSERT INTO nldgbv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maar Marta werd in beslag genomen door de bediening van de gasten. Ze kwam Jezus vragen: “Heer, kan het U niet schelen dat mijn zus de bediening aan mij alleen overlaat? Zeg eens tegen haar dat ze mij moet helpen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","De Heer antwoordde echter: “Marta, Marta, je bent bezorgd en je maakt je druk over allerlei zaken, ");
INSERT INTO nldgbv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","terwijl maar één ding nodig is. Maria heeft het juiste gekozen, en dat zal haar niet worden afgenomen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Op een dag was Jezus ergens aan het bidden. Toen Hij klaar was, vroeg een van zijn leerlingen Hem: “Heer, leer ons bidden, zoals Johannes dat aan zijn leerlingen heeft geleerd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jezus zei tegen hen: “Wanneer jullie bidden, zeg dan: Vader, laat de heiligheid van uw naam worden geëerd. Laat uw koninkrijk komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Geef ons elke dag voldoende eten. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Vergeef ons onze zonden, want wij vergeven ieder die zich tegenover ons heeft schuldig gemaakt. En laat niet toe dat we in verzoeking komen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jezus zei tegen hen: “Stel dat een van jullie een vriend heeft naar wie je midden in de nacht toe gaat en zegt: ‘Vriend, wil je mij drie broden geven, ");
INSERT INTO nldgbv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","want een kennis van mij die op reis is, is bij mij gekomen en ik heb niets om hem voor te zetten.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","En stel dat die vriend vanuit zijn huis roept: ‘Val me niet lastig, want de deur is al op slot en mijn kinderen en ik liggen al in bed. Ik kan niet opstaan om je iets te geven!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ik zeg jullie: zelfs als die vriend niet voor je opstaat en het aan je geeft omdat je zijn vriend bent, zal hij toch opstaan en je zoveel geven als je nodig hebt, omdat je aanhoudt. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Daarom zeg Ik jullie: vraag en het zal je gegeven worden, zoek en je zal vinden, klop en er zal voor je worden opengedaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Want ieder die vraagt, zal ontvangen, en wie zoekt, zal vinden, en voor wie klopt, zal worden opengedaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wie van jullie die vader is, zal als zijn zoon om een vis vraagt, hem een slang geven in plaats van een vis? ");
INSERT INTO nldgbv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Of als hij om een ei vraagt, geeft hij hem dan een schorpioen? ");
INSERT INTO nldgbv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dus als jullie, die slecht zijn, goede geschenken weten te geven aan je kinderen, is het toch veel zekerder dat jullie Vader vanuit de hemel de Heilige Geest zal geven aan wie het Hem vraagt?” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jezus dreef eens een demon uit die niet kon spreken. Toen de demon was weggegaan, begon die persoon te spreken. De mensen stonden versteld, ");
INSERT INTO nldgbv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","maar sommigen zeiden: “Het is Beëlzebul, de heerser over de demonen, die Hem in staat stelt de demonen uit te drijven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Anderen stelden Jezus op de proef door Hem te vragen om een teken uit de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jezus wist echter wat er in hen omging en zei tegen hen: “Ieder koninkrijk dat innerlijk verdeeld is, gaat te gronde, en verdeelde families komen ten val. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Als Satan innerlijk verdeeld is, hoe zal zijn koninkrijk dan standhouden? Jullie zeggen dat Ik de demonen uitdrijf doordat Beëlzebul Mij daartoe in staat stelt. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Maar als Ik de demonen uitdrijf doordat Beëlzebul Mij daartoe in staat stelt, wie stelt jullie aanhangers dan in staat om demonen uit te drijven? Die aanhangers zijn het bewijs dat jullie ongelijk hebben. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Maar als Ik demonen uitdrijf doordat God Mij daartoe in staat stelt, dan blijkt daaruit dat Gods koninkrijk bij jullie is gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wanneer een goed bewapende, sterke man zijn paleis bewaakt, zijn zijn bezittingen veilig. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Maar wanneer er iemand komt die sterker is en hem verslaat, neemt de winnaar hem de wapenrusting af waarop hij had vertrouwd, en verdeelt hij de buit. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wie niet voor Mij is, is tegen Mij, en wie niet met Mij bijeenbrengt, drijft uiteen. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wanneer een onreine geest uit een mens is gekomen, trekt hij door dorre plaatsen op zoek naar een rustplaats, zonder die te vinden. Dan zegt hij: ‘Ik ga terug naar het huis waar ik vandaan kom.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","En wanneer hij aankomt, treft hij het huis geveegd en opgeruimd aan. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dan gaat hij weg om zeven andere geesten op te halen die nog slechter zijn dan hijzelf, en ze nemen er hun intrek. Dan is die persoon er slechter aan toe dan eerst.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Terwijl Jezus deze dingen zei, riep een vrouw vanuit de menigte: “Gezegend zijn de moederschoot waaruit U bent geboren en de borsten waarvan U heeft gedronken!” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maar Jezus zei: “Het zijn veeleer de mensen die Gods boodschap horen en zich eraan houden, die gezegend zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Toen er nog meer mensen om Jezus heen kwamen staan, sprak Hij hen toe. Hij zei: “Jullie soort mensen is slecht. Jullie soort vraagt om een teken, maar het enige teken dat jullie zal worden gegeven is het teken van Jona. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Want zoals Jona een teken werd voor de mensen van Nineve, zo zal de Mensenzoon een teken zijn voor jullie soort. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bij het Oordeel zal tegelijk met jullie soort de koningin van het zuiden verrijzen en zij zal jullie veroordelen, want zij kwam van een van de uithoeken van de aarde naar Salomo's wijsheid luisteren en hier is Iemand die groter is dan Salomo. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bij het Oordeel zullen tegelijk met jullie soort de inwoners van Nineve verrijzen en zij zullen jullie veroordelen, want zij kwamen tot inkeer door Jona's verkondiging, en hier is Iemand die groter is dan Jona. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Niemand die een olielamp heeft aangestoken, zet haar in de kelder of onder een bak. Integendeel, hij zet haar op een standaard, zodat de mensen die binnenkomen het licht zien. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Je oog is de lamp van je lichaam; wanneer je oog helder is, is je hele lichaam verlicht, maar wanneer je oog troebel is, is je lichaam vol duisternis. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Zorg dus dat het licht binnenin jou geen duisternis wordt. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Als je hele lichaam verlicht is, en geen enkel deel ervan is duister, dan is het even goed verlicht als wanneer je door het licht van een lamp wordt beschenen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nadat Jezus had gesproken, werd Hij door een farizeeër uitgenodigd voor een maaltijd. Jezus ging met hem mee naar huis en nam plaats. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","De farizeeër was verbaasd toen hij zag dat Jezus zijn handen niet waste voor het eten. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maar de Heer zei tegen hem: “Jullie farizeeën reinigen wel de buitenkant van de beker en de schaal, maar vanbinnen zitten jullie vol zelfzucht en slechtheid. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dwazen, de Maker van de buitenkant heeft toch ook de binnenkant gemaakt? ");
INSERT INTO nldgbv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Geef de inhoud weg als gift voor de armen; dan zal voor jullie alles rein zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Maar wee jullie, farizeeën, want jullie geven God een tiende deel van de munt, de wijnruit en de andere kruiden, maar jullie negeren Gods gerechtigheid en liefde, terwijl dat de dingen zijn die je moet nastreven zonder het andere na te laten. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wee jullie, farizeeën, want jullie houden ervan de beste plaatsen in de synagogen in te nemen en met respect te worden begroet op het marktplein. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wee jullie, want jullie zijn als ongemarkeerde graven waar de mensen overheen wandelen zonder het te beseffen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Een van de Wetgeleerden reageerde: “Leraar, U beledigt ook ons door dat te zeggen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Maar Jezus zei: “Wat jullie Wetgeleerden betreft, wee ook jullie, want jullie leggen moeilijk te dragen lasten aan de mensen op, maar steken zelf geen vinger naar die lasten uit. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wee jullie, want jullie bouwen grafmonumenten voor de profeten die door jullie voorouders zijn gedood. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Door dat te doen, bewijzen jullie dat je de daden van je voorouders goedkeurt, want zij hebben hen gedood en jullie bouwen graven voor hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Daarom heeft God in zijn wijsheid gezegd: ‘Ik zal profeten en apostelen naar hen toe sturen en ze zullen sommigen van hen doden en anderen vervolgen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daarom zal jullie soort mensen verantwoordelijk worden gesteld voor het bloed van alle profeten dat vergoten is sinds de schepping van de wereld, ");
INSERT INTO nldgbv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","van het bloed van Abel tot het bloed van Zacharia, die werd omgebracht tussen het altaar en Gods huis. Jazeker, ik zeg jullie, jullie soort zal ervoor verantwoordelijk worden gesteld. ");
INSERT INTO nldgbv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wee jullie, Wetgeleerden, want jullie hebben de sleutel tot de kennis weggenomen zonder zelf naar binnen te gaan, en jullie houden de mensen tegen die naar binnen willen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Toen Jezus naar buiten ging, keerden de Schriftgeleerden en de farizeeën zich tegen Hem en bestookten ze Hem met allerlei vragen ");
INSERT INTO nldgbv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","om een strafbare uitspraak bij Hem uit te lokken. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Intussen waren er zoveel mensen toegestroomd, dat ze elkaar verdrongen. Jezus begon te spreken, in de eerste plaats tot zijn leerlingen: “Wees op je hoede voor de desem – dat wil zeggen: de hypocrisie – van de farizeeën. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Er is niets verborgen dat niet zal worden onthuld en er is niets geheim dat niet zal worden bekendgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wat jullie in het donker hebben gezegd, zal in het licht worden gehoord, en wat jullie in de binnenkamer hebben gefluisterd, zal van de daken worden verkondigd. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mijn vrienden, Ik zeg jullie: wees niet bang voor wie wel het lichaam doden maar verder niets kunnen doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ik zal jullie vertellen voor wie jullie wel bang moeten zijn: wees bang voor Degene die de macht heeft om je in de hel te gooien nadat je lichaam is gedood. Jazeker, Ik zeg jullie: voor Hem moeten jullie bang zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Worden mussen niet per vijf verkocht voor twee kopermuntjes? Toch is er niet één die niet door God wordt opgemerkt. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","En alle haren op je hoofd zijn geteld. Wees dus niet bang; jullie zijn veel meer waard dan mussen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ik zeg jullie: ieder die Mij erkent bij de mensen, zal door de Mensenzoon worden erkend bij Gods engelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maar wie Mij verloochent bij de mensen, zal worden verloochend bij Gods engelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ieder die iets lelijks zegt over de Mensenzoon, kan worden vergeven, maar wie de Heilige Geest belastert, zal niet worden vergeven. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wanneer jullie voor de synagogen, heersers en gezaghebbers worden gesleept, maak je dan niet bezorgd over hoe je jezelf moet verdedigen of wat je moet zeggen, ");
INSERT INTO nldgbv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","want de Heilige Geest zal je op dat moment leren wat je moet zeggen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iemand in de menigte zei tegen Jezus: “Leraar, zeg tegen mijn broer dat hij de erfenis met mij moet delen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Maar Jezus antwoordde: “Wie heeft Mij als rechter of bemiddelaar over jullie aangesteld?” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Toen zei Jezus tegen hen: “Pas op; wees op je hoede voor iedere vorm van hebzucht, want zelfs als iemand veel bezittingen heeft, is hij niet meester van zijn leven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jezus vertelde hun een parabel: “Er was eens een rijk man, met land dat een grote oogst had opgeleverd. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hij begon zich af te vragen: Wat zal ik doen? Ik heb geen plaats om mijn oogst op te slaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Toen zei hij: ‘Ik zal het volgende doen: ik zal mijn schuren afbreken en grotere bouwen. Daarin zal ik al mijn graan en mijn voorraden bewaren. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dan zal ik tegen mezelf zeggen: Jongen, je hebt veel voorraden opgeslagen waar je vele jaren van kan leven. Ontspan je: eet, drink en geniet.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Maar God zei tegen hem: ‘Jij dwaas, vannacht zal Ik je leven van je opeisen; wie krijgt dan wat je voor jezelf hebt opgespaard?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zo zal het de persoon vergaan die rijkdom voor zichzelf vergaart maar in Gods ogen niet rijk is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jezus zei tegen zijn leerlingen: “Daarom zeg Ik jullie: wees niet ongerust over je leven, over wat je zal eten of drinken, of over je lichaam, over hoe je je zal kleden. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Het leven is immers meer dan eten en het lichaam is meer dan kledij. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kijk naar de raven: zij zaaien of oogsten niet en ze hebben geen opslagruimte of schuur, maar toch geeft God hun te eten. Jullie zijn toch meer waard dan de vogels? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wie van jullie kan door ongerust te zijn een uur aan zijn leven toevoegen? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Als jullie zelfs zoiets kleins niet kunnen, waarom zouden jullie dan bezorgd zijn over het overige? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kijk hoe de wilde bloemen groeien: ze spinnen en weven niet en toch, zeg Ik jullie, was zelfs Salomo in al zijn pracht niet zo mooi gekleed als zij. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Als God het gras dat vandaag op het veld staat en morgen in de oven wordt gegooid, zo mooi kleedt, zal Hij jullie, kleingelovigen, dan niet nog beter kleden? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Vraag je niet voortdurend af wat je zal eten en drinken; wees niet bezorgd. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dat zijn allemaal zaken die de volken van deze wereld najagen; je Vader weet dat je ze nodig hebt. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Geef daarentegen prioriteit aan Gods koninkrijk; dan zullen ook deze dingen aan jullie worden gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wees niet bang, kleine kudde, want jullie Vader heeft in zijn goedheid besloten het koninkrijk aan jullie te geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Verkoop je bezittingen en geef aan de armen; zo maak je voor jezelf een geldbuidel die niet verslijt, een schat in de hemel die niet opraakt, waar geen dief in de buurt komt en die niet door motten wordt aangetast. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Want waar jullie schat is, daar zal ook jullie hart zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zorg dat jullie klaarstaan en dat je lamp brandt. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wees als mensen die hun baas opwachten wanneer hij terugkeert van het huwelijksfeest, zodat ze meteen kunnen opendoen wanneer hij arriveert en aanklopt. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","De knechten die de baas bij zijn terugkomst aantreft terwijl ze op de uitkijk staan, zijn gezegend. Ik verzeker jullie dat hij hen aan tafel zal laten plaatsnemen, zich zal klaarmaken en hen zal komen bedienen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ze zijn gezegend, of hij nu komt rond middernacht of in de vroege uurtjes. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dit moeten jullie weten: als de huiseigenaar zou weten hoe laat de dief komt, zou hij niet in zijn huis laten inbreken. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ook jullie moeten voorbereid zijn, want de Mensenzoon komt op een onverwacht tijdstip.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus vroeg: “Heer, is deze parabel voor ons bedoeld, of voor iedereen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","De Heer antwoordde: “Wie is de trouwe en verstandige beheerder die door zijn heer over het personeel is aangesteld om hun op tijd hun portie eten te geven? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","De dienaar die door zijn heer bij diens thuiskomst aan het werk wordt aangetroffen, is gezegend. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ik verzeker jullie dat hij hem over al zijn bezittingen zal aanstellen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Als de dienaar echter denkt: mijn heer komt nog lang niet, en als hij dan de knechten en dienstbodes begint te mishandelen en zelf eet, drinkt en dronken wordt, ");
INSERT INTO nldgbv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dan zal de heer van die dienaar komen op een dag en een tijdstip die de dienaar niet verwacht of kent, hem de doodstraf opleggen en hem dezelfde bestemming geven als de misdadigers. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","De dienaar die weet wat zijn heer wil, en er niet naar handelt en geen voorbereidingen treft, zal veel slaag krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maar wie zonder het te beseffen dingen doet waarvoor hij straf verdient, zal weinig slaag krijgen. Want van ieder aan wie veel is gegeven, zal veel worden geëist, en van de mensen aan wie veel is toevertrouwd, zal veel worden gevraagd. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ik ben gekomen om vuur op de aarde te werpen en Ik zou graag willen dat het nu reeds wordt aangestoken. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Maar er is een doop die Ik moet ondergaan en dat weegt zwaar op Mij zolang het nog niet is gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Denken jullie dat Ik ben gekomen om vrede op aarde te brengen? Nee, zeg Ik jullie, Ik breng verdeeldheid. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Voortaan zal het zo zijn dat een familie van vijf personen verdeeld zal zijn: drie tegen twee en twee tegen drie. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vaders zullen tegen hun zoon zijn en zonen tegen hun vader, moeders tegen hun dochter en dochters tegen hun moeder, schoonmoeders tegen hun schoondochter en schoondochters tegen hun schoonmoeder.” ");
INSERT INTO nldgbv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jezus zei tegen de mensenmassa: “Als jullie een wolk uit het westen zien komen, zeggen jullie meteen: ‘Er komt een bui.’ En dan gebeurt dat. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","En als de wind uit het zuiden komt, zeggen jullie: ‘Vandaag wordt het heet.’ En dan gebeurt dat. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jullie hypocrieten, jullie kunnen de dingen die jullie op aarde en in de lucht zien wel interpreteren; hoe is het mogelijk dat jullie de huidige tijd niet kunnen interpreteren? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Waarom kunnen jullie niet zelf beoordelen wat rechtvaardig is? ");
INSERT INTO nldgbv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wanneer je met je tegenstander onderweg bent naar de autoriteiten, probeer dan met hem tot een vergelijk te komen; anders kan je voor de rechter worden gesleept, zodat de rechter je aan de gerechtsdienaar uitlevert en de gerechtsdienaar je in de gevangenis gooit. ");
INSERT INTO nldgbv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ik verzeker je, je zal daar in geen geval uitkomen voordat je de laatste cent hebt betaald.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","In die tijd waren er mensen die Jezus vertelden over de Galileeërs die door Pilatus waren omgebracht tijdens het slachten van hun offerdieren voor God. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jezus reageerde: “Denken jullie dat deze Galileeërs grotere zondaars waren dan de andere Galileeërs omdat ze dit lijden ondergingen? ");
INSERT INTO nldgbv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nee, zeg Ik jullie; als jullie niet tot inkeer komen, zullen ook jullie omkomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Of denken jullie dat de achttien mensen die omkwamen toen de toren van Siloam op hen viel, meer schuld droegen dan de andere inwoners van Jeruzalem? ");
INSERT INTO nldgbv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nee, zeg Ik jullie, als jullie niet tot inkeer komen, zullen jullie allen omkomen, net als zij.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jezus vertelde de volgende parabel: “Iemand had een vijgenboom in zijn wijngaard staan. Hij kwam kijken of er vijgen aan zaten, maar hij vond er geen. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hij zei tegen de beheerder van de wijngaard: ‘Ik kom al drie jaar kijken of er vruchten aan deze vijgenboom groeien, zonder dat ik iets vind. Hak hem maar om, hij neemt alleen maar grond in beslag.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","De beheerder antwoordde: ‘Heer, laat hem nog een jaar staan, zodat ik de grond eromheen kan omspitten en bemesten. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Misschien groeien er volgend jaar vruchten aan. Maar zo niet, laten we hem dan omhakken.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Op een sabbat was Jezus in een synagoge aan het onderwijzen. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Daar was een vrouw die al achttien jaar ziek was door een geest; ze was krom en kon haar rug in het geheel niet rechten. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Toen Jezus haar zag, riep Hij haar bij zich. Hij zei tegen haar: “Mevrouw, u bent bevrijd van uw aandoening.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hij legde haar de handen op en op dat moment werd haar rug recht en ze verheerlijkte God. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","De synagogebestuurder reageerde verontwaardigd, omdat Jezus de genezing had verricht op de sabbat. Hij zei tegen de mensen: “Er zijn zes dagen om te werken; kom op die dagen om je te laten genezen, maar niet op de sabbat.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","De Heer reageerde: “Hypocrieten, jullie maken toch allemaal op de sabbat je os of ezel van de voederbak los om hem naar de drinkbak te leiden? ");
INSERT INTO nldgbv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","En deze dochter van Abraham, die achttien jaar lang door de satan werd gevangengehouden, zou niet op de sabbat uit haar gevangenschap mogen worden bevrijd?” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Door dit te zeggen bracht Hij al zijn tegenstanders in verlegenheid, maar de hele menigte verheugde zich over de prachtige dingen die Hij had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jezus zei: “Waarop lijkt Gods koninkrijk en waarmee zal Ik het vergelijken? ");
INSERT INTO nldgbv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Het is als een mosterdzaadje dat iemand in zijn tuin zaaide. Het groeide uit tot een boom en de vogels nestelden zich in zijn takken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jezus vervolgde: “Waarmee zal Ik Gods koninkrijk vergelijken? ");
INSERT INTO nldgbv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Het is als desem die door een vrouw werd vermengd met drie porties meel, totdat het deeg volledig doordesemd was.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jezus vervolgde zijn reis naar Jeruzalem en onderwees de mensen in de steden en dorpen waar Hij langstrok. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iemand vroeg Hem: “Heer, zijn er maar weinig mensen die worden gered?” Jezus zei tegen hen: ");
INSERT INTO nldgbv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Doe alle moeite om door de smalle deur naar binnen te gaan, want Ik zeg jullie: velen zullen proberen naar binnen te gaan en er niet toe in staat zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wanneer de huiseigenaar de deur gesloten heeft, zullen jullie buiten staan, aankloppen en roepen: ‘Meneer, doe voor ons open!’ Hij zal antwoordden: ‘Ik ken jullie niet. Waar komen jullie vandaan?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dan zullen jullie zeggen: ‘We hebben toch bij u gegeten en gedronken en u heeft toch op onze straten onderwijs gegeven?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Maar hij zal zeggen: ‘Ik weet niet wie jullie zijn of waar jullie vandaan komen. Ga allemaal weg, jullie zondaars!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Daar zal worden geweend en met de tanden geknarst, wanneer jullie Abraham en Isaak en Jakob en alle profeten in Gods koninkrijk zullen zien, maar zelf zullen worden buitengegooid. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","De mensen zullen uit het oosten en het westen komen, uit het noorden en het zuiden, en aan tafel plaatsnemen in Gods koninkrijk. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Er zijn namelijk laatsten die de eersten zullen zijn en er zijn eersten die de laatsten zullen zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Op dat moment kwamen er enkele farizeeën bij Jezus. Ze zeiden: “U kan beter van hier vertrekken en verder reizen, want Herodes wil U doden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jezus antwoordde: “Ga die vos maar vertellen dat Ik vandaag en morgen nog demonen uitdrijf en mensen genees en dat Ik op de derde dag mijn doel zal bereiken. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Toch moet Ik vandaag, morgen en overmorgen doorreizen, want het is ondenkbaar dat een profeet omkomt buiten Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzalem, Jeruzalem, jij die de profeten doodt en stenigt wie naar jou toe gestuurd zijn! Ik heb zo vaak je inwoners willen bijeenbrengen, zoals een hen haar kuikens onder haar vleugels bijeenbrengt. Maar jullie wilden dat niet. ");
INSERT INTO nldgbv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Daarom zal jullie huis verlaten zijn. Ik zeg jullie: jullie zullen Mij niet meer zien totdat jullie uitroepen: ‘Gezegend is Hij die komt in de naam van de Heer.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Op een sabbat, toen Jezus bij een van de leiders van de farizeeën thuis was gaan eten, werd Hij nauwlettend in de gaten gehouden. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Recht voor Jezus stond iemand die aan oedeem leed. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jezus reageerde door aan de Wetgeleerden en de farizeeën te vragen: “Is het toegestaan om op de sabbat te genezen? Of mag het niet?” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Zij zwegen. Jezus nam de persoon bij de hand, genas hem en liet hem gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tegen de anderen zei Hij: “Wie van jullie die een zoon of een os heeft die in een put valt, zou hem er niet meteen uit trekken, zelfs op de sabbat?” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ook hierop hadden ze geen antwoord. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jezus had gemerkt dat de gasten de ereplaatsen hadden gekozen en vertelde hun een parabel: ");
INSERT INTO nldgbv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wanneer iemand jullie uitnodigt naar een huwelijksfeest, ga dan niet op de ereplaats zitten, want het is mogelijk dat hij iemand heeft uitgenodigd die meer voor hem betekent. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Dan zal de gastheer die jullie beiden had uitgenodigd, naar je toe komen en zeggen: ‘Sta je plaats af aan deze persoon.’ En dan moet je, tot je schaamte, genoegen nemen met de verste plaats aan tafel. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dus als jullie zijn uitgenodigd, ga dan op de verste plaats zitten. Dan zal je gastheer naar je toe komen en tegen je zeggen: ‘Vriend, kom op een betere plaats zitten’. En dan ontvang je eer in de ogen van al je tafelgenoten. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Want ieder die zichzelf een eervolle plaats toebedeelt, zal een geringe plaats krijgen, en wie zichzelf een geringe plaats toebedeelt, zal een eervolle plaats krijgen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tegen de gastheer zei Jezus: “Wanneer je 's middags of 's avonds een feestmaal geeft, nodig dan niet je vrienden, broers en zussen, familie en rijke buren uit, met de bedoeling dat zij op hun beurt jou zullen uitnodigen en jij op die manier iets zult terugkrijgen. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nee, wanneer je een feestmaal geeft, nodig dan de armen, de mensen met een handicap, de verlamden en de blinden uit. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dan zal je gezegend zijn, want hoewel zij jou niets kunnen teruggeven, zal je worden beloond bij de verrijzenis van de mensen die met God in het reine zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eén van Jezus' tafelgenoten hoorde dat en zei: “Wat een zegen moet het zijn om te mogen deelnemen aan het feestmaal in Gods koninkrijk!” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jezus antwoordde: “Iemand gaf eens een groot feestmaal en nodigde veel mensen uit. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tegen het tijdstip waarop de maaltijd klaar was, stuurde hij zijn dienaar naar de genodigden met het bericht: ‘Kom, het is klaar.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ze lieten zich echter allen verontschuldigen. De een zei: ‘Ik heb een akker gekocht en moet die gaan bekijken; wilt u mij verontschuldigen?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","De ander zei: ‘Ik heb vijf paar ossen gekocht en ga ze uitproberen; wilt u mij verontschuldigen?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nog een ander zei: ‘Ik ben pas getrouwd en daarom kan ik niet komen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","De dienaar ging naar zijn baas toe en vertelde het. De heer werd boos en zei tegen zijn dienaar: ‘Ga direct naar de straten en stegen van de stad en breng de armen, de mensen met een handicap, de blinden en de verlamden naar hier.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","De dienaar zei: ‘Meneer, dat bevel is uitgevoerd en er is nog altijd plaats.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Toen zei de heer tegen de dienaar: ‘Ga naar de wegen en paden buiten de stad en dwing de mensen te komen, zodat mijn huis vol raakt. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ik zeg jullie dat geen van de mensen die aanvankelijk waren uitgenodigd, van mijn feestmaal zal eten.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Er kwam nu een groot aantal mensen met Jezus mee. Hij keerde zich naar hen toe en zei: ");
INSERT INTO nldgbv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Als iemand bij Mij komt en Mij niet méér liefheeft dan zijn vader, moeder, vrouw, kinderen, broers en zussen en zelfs zijn eigen leven, dan kan hij niet mijn volgeling zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wie niet zijn kruis draagt en achter Mij aankomt, kan niet mijn volgeling zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wie van jullie zou een toren bouwen zonder eerst neer te zitten om uit te rekenen of hij voldoende geld heeft om de bouw af te maken? ");
INSERT INTO nldgbv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Want als hij het fundament zou leggen en de bouw vervolgens niet zou kunnen afmaken, zou iedereen die het zag, hem uitlachen ");
INSERT INTO nldgbv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","en zeggen: die man is begonnen met bouwen maar kon het niet afmaken. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Of welke koning zou ten strijde trekken tegen een andere koning zonder eerst te overwegen of hij in staat is met tienduizend soldaten zijn tegenstander te verslaan, die met twintigduizend soldaten op hem afkomt? ");
INSERT INTO nldgbv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","En als hij weet dat hij zijn tegenstander niet zal kunnen verslaan, zal hij een delegatie sturen wanneer de ander nog ver weg is, en om vrede vragen. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zo is het ook met jullie: wie niet al zijn bezittingen opgeeft, kan niet mijn volgeling zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Zout is goed, maar als het zout smaakloos wordt, hoe kan het dan op smaak worden gebracht? ");
INSERT INTO nldgbv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Het zout is zelfs ongeschikt geworden voor op de akker of de mesthoop; het wordt weggegooid. Als je oren hebt om te horen, luister dan!” ");
INSERT INTO nldgbv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Alle belastinginners en zondaars kwamen naar Jezus luisteren. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","De farizeeën en Schriftgeleerden mopperden: “Deze Man ontvangt zondaars en eet samen met hen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Daarom vertelde Hij hun de volgende parabel: ");
INSERT INTO nldgbv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Stel dat iemand van jullie honderd schapen heeft en er een van kwijtraakt. Zou hij dan niet de negenennegentig op het veld achterlaten en het verloren dier achternagaan totdat hij het terugvindt? ");
INSERT INTO nldgbv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","En wanneer hij het heeft gevonden, is hij verheugd en legt hij het op zijn schouders. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dan gaat hij naar huis, roept hij zijn vrienden en buren bijeen en zegt hij tegen hen: ‘Verheug je samen met mij, want ik heb mijn verloren schaap teruggevonden.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ik zeg jullie dat het in de hemel ook zo is: daar zal meer vreugde zijn over één zondaar die tot inkeer komt dan over negenennegentig rechtvaardige mensen die geen inkeer nodig hebben. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Stel dat een vrouw tien zilveren munten heeft en er een van kwijtraakt. Zou ze dan niet een lamp aansteken, het huis schoonvegen en grondig zoeken totdat ze hem terugvindt? ");
INSERT INTO nldgbv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","En wanneer ze hem heeft gevonden, roept ze haar vriendinnen en buurvrouwen bijeen en zegt ze: ‘Verheug je samen met mij, want ik heb mijn verloren munt teruggevonden.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ik zeg jullie dat het met Gods engelen ook zo is: zij verheugen zich over één zondaar die zich bekeert.” ");
INSERT INTO nldgbv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jezus vertelde: “Een man had twee zonen. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","De jongste zei tegen de vader: ‘Vader, geef mij mijn aandeel van de erfenis.’ Daarop verdeelde de vader zijn vermogen tussen de zonen. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Enkele dagen later maakte de jongste zoon alles te gelde en vertrok hij naar een ver land, waar hij zijn erfenis verbraste door losbandig te leven. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Toen hij alles had opgemaakt, brak in heel dat land een zware hongersnood uit en begon hij gebrek te lijden. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Daarom vroeg hij een van de burgers van dat land om werk en die stuurde hem de velden in om de varkens te hoeden. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hij had graag zijn honger gestild met de schillen die door de varkens werden opgegeten, maar niemand gaf hem iets. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Toen kwam hij tot zichzelf en zei hij: ‘De dagloners van mijn vader hebben eten in overvloed, terwijl ik hier omkom van de honger. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ik zal naar mijn vader toe gaan en tegen hem zeggen: vader, ik heb gezondigd tegen God en tegen u. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ik ben het niet langer waard uw zoon genoemd te worden. Stel me aan als een van uw dagloners.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hij ging op weg, terug naar zijn vader. Maar zijn vader zag hem al van ver, kreeg medelijden, rende naar hem toe, omarmde hem en gaf hem een kus. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","De zoon zei: ‘Vader, ik heb gezondigd tegen God en tegen u. Ik ben het niet langer waard uw zoon te worden genoemd.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Maar de vader zei tegen zijn knechten: ‘Snel, breng het mooiste feestgewaad, trek hem dat aan en doe een ring aan zijn vinger en schoenen aan zijn voeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","En haal dan het gemeste kalf, slacht het en laten we eten en feest vieren, ");
INSERT INTO nldgbv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","want mijn zoon hier was dood en is weer tot leven gekomen, ik was hem kwijt en hij is teruggevonden.’ Toen begonnen ze feest te vieren. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","De oudste zoon was nog op het land, maar toen hij thuiskwam, hoorde hij muziek en feestgeluiden. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hij riep een van de dienaren en vroeg wat er aan de hand was. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","De dienaar zei: ‘Uw broer is thuisgekomen en uw vader heeft het gemeste kalf laten slachten, omdat hij hem veilig en wel heeft teruggekregen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","De oudste zoon werd kwaad en wilde niet naar binnen. Toen kwam zijn vader naar buiten om hem over te halen. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Maar hij zei tegen zijn vader: ‘Ik heb u jarenlang gediend en ik heb nooit een bevel van u genegeerd, maar u heeft mij nooit een jonge geit gegeven om met mijn vrienden een feestje te houden. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","En nu is die zoon van u gekomen, die uw vermogen aan hoeren heeft verkwist, en u heeft het gemeste kalf voor hem geslacht.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","De vader antwoordde: ‘Zoon, jij bent altijd bij mij geweest en alles wat van mij is, is van jou. ");
INSERT INTO nldgbv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","We konden toch niet anders dan verheugd zijn en feest vieren? Je broer hier was immers dood en nu leeft hij; hij was verloren en nu is hij teruggevonden.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jezus vertelde zijn leerlingen: “Er was eens een rijk man, die werd gewaarschuwd dat de beheerder die hij in dienst had zijn bezittingen verkwanselde. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hij riep de beheerder bij zich en zei: ‘Wat hoor ik nu over jou? Overhandig de boekhouding van mijn zaken die je beheert, want je mag niet langer mijn beheerder zijn.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Toen dacht de beheerder: ‘Wat zal ik doen? Mijn baas neemt mij het beheer af. Ik ben niet sterk genoeg om op het land te werken en ik schaam me om te gaan bedelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ik weet wat ik zal doen om te zorgen dat de mensen mij in hun huis zullen verwelkomen wanneer ik als beheerder ben ontslagen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hij riep iedereen die bij zijn baas in de schuld stond, bij zich. Hij vroeg aan de eerste: ‘Hoeveel bent u mijn baas schuldig?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Die antwoordde: ‘Honderd vaten olijfolie.’ Hij zei tegen hem: ‘Hier is uw schuldbewijs. Ga vlug zitten en maak er vijftig van.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hij vroeg aan een ander: ‘Hoeveel bent u hem schuldig?’ Hij antwoordde: ‘Honderd zakken graan.’ Hij zei tegen hem: ‘Neem uw schuldbewijs en maak er tachtig van.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","De heer prees de oneerlijke beheerder, omdat die iets slims had gedaan. De mensen van deze wereld gaan handiger met elkaar om dan de mensen die in het licht leven. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ik zeg jullie: gebruik rijkdom die op oneerlijke wijze is verkregen, om vrienden te maken; dan zullen jullie wanneer het niets meer waard is, welkom zijn in de eeuwige woning. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wie betrouwbaar is met weinig, is ook betrouwbaar met veel, en wie oneerlijk is met weinig, is ook oneerlijk met veel. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Als jullie dus niet betrouwbaar zijn geweest in het beheren van rijkdom die op oneerlijke wijze is verkregen, wie zal jullie dan vertrouwen met hetgeen werkelijk rijk maakt? ");
INSERT INTO nldgbv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","En als jullie niet betrouwbaar zijn geweest met andermans bezit, wie zal jullie dan geven wat jullie toebehoort? ");
INSERT INTO nldgbv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Een huisknecht kan niet twee meesters dienen: hij zal ofwel een hekel aan de ene hebben en van de andere houden, of de ene trouw zijn en de andere verachten. Jullie kunnen niet God én het geld dienen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","De farizeeën, die verzot op geld waren, hoorden dit alles en dreven de spot met Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jezus zei tegen hen: “Jullie doen de mensen denken dat jullie rechtvaardig zijn, maar God kent jullie hart. Wat door de mensen wordt hooggeschat, is weerzinwekkend in Gods ogen. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tot de tijd van Johannes werden de Wet en de Profeten verkondigd; sindsdien wordt het evangelie van Gods koninkrijk verkondigd en probeert iedereen het met geweld binnen te dringen. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Het is echter gemakkelijker voor de hemel en de aarde om te vergaan, dan voor een pennenstreek in Gods Wet om te vervallen. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ieder die zijn vrouw wegstuurt en met een ander trouwt, pleegt echtbreuk, en ook wie met een weggestuurde vrouw trouwt, pleegt echtbreuk. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Er was eens een rijk man. Hij kleedde zich in paarse stoffen en fijn linnen en genoot iedere dag van zijn welvaart. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bij zijn huispoort lag een arme man, die Lazarus heette. Hij zat onder de zweren ");
INSERT INTO nldgbv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","en verlangde ernaar te kunnen eten wat er overschoot van de maaltijden van de rijke. Bovendien kwamen de honden aan zijn zweren likken. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Op een dag stierf de arme man en werd hij door de engelen weggedragen naar de plaats naast Abraham. Ook de rijke man stierf en werd begraven. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Terwijl hij in het dodenrijk zware pijn leed, keek hij op en zag hij Abraham, met Lazarus naast zich, in de verte. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hij riep: ‘Vader Abraham, heb medelijden met mij en stuur Lazarus om zijn vinger in water te dopen en mijn tong af te koelen, want deze vlammen doen verschrikkelijk veel pijn.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Maar Abraham zei: ‘Mijn kind, weet je nog dat je tijdens je leven het goede hebt ontvangen en Lazarus het slechte? Nu wordt hij hier getroost en lijd jij. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bovendien gaapt er een grote kloof tussen ons en jou, zodat niemand van hier naar jou kan oversteken, of van daar naar ons.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","De rijke zei: ‘In dat geval smeek ik u, vader, dat u hem naar mijn familie stuurt. ");
INSERT INTO nldgbv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ik heb namelijk vijf broers. Laat hij hen waarschuwen, zodat zij niet ook op deze plaats van kwelling terechtkomen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Maar Abraham zei: ‘Zij hebben Mozes en de profeten; laten ze naar hen luisteren.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hij antwoordde: ‘Nee, vader Abraham, als er iemand vanuit het dodenrijk naar hen toe gaat, zullen ze tot inkeer komen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Maar Abraham zei: ‘Als ze niet naar Mozes en de profeten luisteren, zullen ze ook niet overtuigd raken als iemand uit de dood verrijst.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jezus zei tegen zijn leerlingen: “Het is onvermijdelijk dat er struikelblokken komen, maar wee degene door wie ze komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hij zou beter af zijn als men een molensteen om zijn nek zou hangen en hem in zee zou gooien dan dat hij een van deze eenvoudige mensen tot zonde aanzet. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Let dus goed op. Als je naaste jou onrecht aandoet, wijs hem dan terecht. En als hij tot inkeer komt, vergeef hem dan. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Al doet hij je zevenmaal per dag onrecht aan en komt hij zevenmaal bij je terug om te zeggen: ‘Het spijt me’, je moet hem steeds opnieuw vergeven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","De apostelen vroegen aan de Heer: “Geef ons meer geloof.” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","De Heer zei: “Als jullie geloof zouden hebben ter grootte van een mosterdzaadje, dan zouden jullie tegen deze moerbeiboom zeggen: Maak je uit de grond los en ga in de zee staan, en hij zou je direct gehoorzamen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wie van jullie een knecht heeft die voor hem ploegt of zijn schapen hoedt, zal tegen hem zeggen wanneer hij terugkomt van het veld: Kom snel binnen en ga aan tafel zitten? ");
INSERT INTO nldgbv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Welnee, hij zal tegen hem zeggen: Maak wat eten klaar en bereid je voor om mij te bedienen terwijl ik eet en drink; daarna mag jij eten en drinken. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hij bedankt de knecht toch niet omdat die doet wat hem is opgedragen? ");
INSERT INTO nldgbv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zo is het ook met jullie; wanneer jullie alles doen wat jullie is opgedragen, moeten jullie zeggen: ‘Wij zijn slechts knechten, we hebben gedaan wat we moesten doen.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tijdens zijn reis naar Jeruzalem kwam Jezus door het grensgebied van Samaria en Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Toen Hij een dorp binnenging, kwamen er tien mannen naar Hem toe met een huidziekte die hen onrein maakte. Ze bleven op enige afstand staan ");
INSERT INTO nldgbv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","en riepen: “Heer Jezus, heb medelijden met ons!” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Toen Jezus hen zag, zei Hij: “Ga je aan de priesters tonen.” Terwijl ze nog onderweg waren, werden ze rein. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eén van hen keerde terug toen hij zag dat hij genezen was, en hij verheerlijkte God luidkeels. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hij liet zich aan Jezus' voeten neervallen om Hem te danken. Deze man was een Samaritaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jezus reageerde: “Er zijn toch tien mensen rein gemaakt? Waar zijn de overige negen? ");
INSERT INTO nldgbv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Is er niemand anders teruggekomen om God de eer te geven dan deze vreemdeling?” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","En tegen de man zei Hij: “Sta op, je mag vertrekken; je geloof heeft je genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Toen de farizeeën aan Jezus vroegen wanneer Gods koninkrijk zou komen, antwoordde Hij: “De komst van Gods koninkrijk zal niet gepaard gaan met allerlei zichtbare tekenen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Er zal niet gezegd worden: ‘kijk hier’ of ‘kijk daar’, want Gods koninkrijk is in jullie midden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tegen zijn leerlingen zei Jezus: “Er zal een tijd komen dat jullie ernaar verlangen een glimp op te vangen van de tijd van de Mensenzoon, maar die niet zullen zien. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Er zal tegen jullie worden gezegd: ‘kijk daar’, of ‘kijk hier’. Ga er niet op af, ren er niet heen, ");
INSERT INTO nldgbv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","want zoals de bliksem van de ene naar de andere kant van de lucht flitst, zo zal het zijn met de Mensenzoon wanneer Hij komt. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Eerst moet Hij echter veel lijden doorstaan en door dit volk worden verworpen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","In de tijd van de Mensenzoon zal het zijn als in de tijd van Noach: ");
INSERT INTO nldgbv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","De mensen gingen door met eten, drinken en trouwen tot de dag dat Noach de ark binnenging en de zondvloed kwam, waardoor ze allen omkwamen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Het zal zijn als in de tijd van Lot: de mensen aten en dronken, kochten en verkochten, plantten en bouwden, ");
INSERT INTO nldgbv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","maar op de dag dat Lot Sodom verliet, regende het vuur en zwavel uit de hemel, waardoor ze allen omkwamen. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Zo zal het ook zijn op de dag dat de Mensenzoon verschijnt. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wie zich op die dag op het dakterras bevindt en bezittingen in huis heeft liggen, moet niet naar beneden gaan om ze op te halen. En wie op het land bezig is, moet niet naar huis terugkeren. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Denk maar aan de vrouw van Lot. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wie zijn leven probeert te behouden, zal het verliezen en wie het loslaat, zal het behouden. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ik zeg jullie: die nacht zullen twee mannen in een bed slapen, van wie de ene wordt weggenomen en de andere achtergelaten. ");
INSERT INTO nldgbv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Van twee vrouwen die dan tezamen aan het malen zijn, wordt de ene weggenomen en de andere achtergelaten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Men vroeg Jezus: “Waar, Heer?”, en Hij zei tegen hen: “Waar het lijk ligt, daar verzamelen zich de gieren.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jezus vertelde een parabel om duidelijk te maken dat ze voortdurend moesten bidden zonder op te geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hij zei: “Er was in een stad een rechter die geen ontzag voor God of respect voor de mensen had. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","In diezelfde stad was er een weduwe die hem steeds opnieuw kwam vragen: ‘Verschaf mij recht tegenover mijn tegenpartij.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Een tijdlang wilde hij niet, maar daarna dacht hij: ‘Ik heb geen ontzag voor God en geen respect voor de mensen, ");
INSERT INTO nldgbv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","maar deze weduwe valt me zodanig lastig dat ik haar recht zal verschaffen. Anders blijft ze terugkomen totdat ik toegeef.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","De Heer vervolgde: “Luister naar de woorden van de onrechtvaardige rechter. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Zou God dan geen recht verschaffen aan de mensen die Hij heeft uitverkoren wanneer ze dag en nacht tot Hem roepen, en zou Hij hen lang laten wachten? ");
INSERT INTO nldgbv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ik zeg jullie dat Hij hun snel recht zal verschaffen. Maar zal de Mensenzoon geloof op aarde vinden wanneer Hij komt?” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jezus vertelde ook een parabel aan enkele mensen die zichzelf als rechtvaardig beschouwden en op anderen neerkeken. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Hij zei: “Twee mensen gingen naar de tempel om te bidden; de één was farizeeër, de ander belastinginner. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","De farizeeër ging rechtop staan en bad: ‘O God, ik dank U dat ik niet ben als de anderen: roofzuchtige, corrupte, overspelige mensen, of zelfs als deze belastinginner. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ik vast tweemaal per week en ik geef tien procent van al mijn inkomsten weg.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","De belastinginner daarentegen bleef op een afstand staan en durfde zelfs niet omhoog te kijken, naar de hemel. Hij sloeg zichzelf op de borst en zei: ‘O God, schenk mij genade, want ik ben een zondaar.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ik zeg jullie: deze man, en niet de andere, was met God in het reine toen hij naar huis ging. Want ieder die zichzelf een eervolle plaats toebedeelt, zal een geringe plaats krijgen, en wie zichzelf een geringe plaats toebedeelt, zal een eervolle plaats krijgen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Er werden ook jonge kinderen bij Jezus gebracht met de bedoeling dat Hij hen zou aanraken, maar zijn leerlingen zagen het en ze berispten de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jezus riep de kinderen echter bij zich. Hij zei: “Laat de kinderen bij Mij komen en houd hen niet tegen, want Gods koninkrijk is bestemd voor wie is zoals zij. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ik verzeker jullie: wie Gods koninkrijk niet aanvaardt als een kind, zal het in geen geval binnengaan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Een vooraanstaand man vroeg aan Jezus: “Goede leraar, wat moet ik doen om het eeuwig leven te ontvangen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jezus vroeg hem: “Waarom noem je Mij goed? Behalve God is niemand goed. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Je kent toch de geboden? Pleeg geen echtbreuk, pleeg geen moord, steel niet, leg geen leugenachtige verklaring af, eer je vader en moeder.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","De man zei: “Aan al die dingen heb ik me van jongs af aan gehouden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Toen Jezus dat hoorde, zei Hij tegen hem: “Er ontbreekt je nog één ding; verkoop alles wat je hebt en geef de opbrengst aan de armen. Dan zal je een schat in de hemel hebben. Kom dan terug en volg Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Toen de man dat hoorde, werd hij bedroefd, want hij was schatrijk. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jezus keek hem aan en zei: “Wat is het moeilijk voor rijken om Gods koninkrijk binnen te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Het is gemakkelijker voor een kameel om door het oog van een naald te kruipen dan voor een rijke om Gods koninkrijk binnen te gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","De mensen die dat hoorden, vroegen: “Maar wie kan dan worden gered?” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jezus antwoordde: “Wat bij de mensen onmogelijk is, is mogelijk bij God.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus zei: “Wij hebben achtergelaten wat we hadden, om U te volgen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jezus antwoordde: “Ik verzeker jullie, er is niemand die zijn huis, vrouw, broers, zussen, ouders of kinderen heeft achtergelaten voor Gods koninkrijk, ");
INSERT INTO nldgbv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","die niet veel meer terugkrijgt in deze tijd en die niet in de toekomst het eeuwig leven zal ontvangen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jezus nam de Twaalf apart en zei tegen hen: “Luister, we gaan naar Jeruzalem en alles wat de profeten over de Mensenzoon hebben geschreven, zal in vervulling gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hij zal aan de niet-Joden worden uitgeleverd en worden bespot, beledigd en bespuwd. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Zij zullen Hem geselen en vervolgens doden, maar op de derde dag zal Hij verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","De leerlingen begrepen er niets van; zijn uitspraak was onbegrijpelijk voor hen en ze konden niet bevatten wat Hij had gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Toen Jezus dicht bij Jericho kwam, zat er een blinde man bij de weg te bedelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Toen hij hoorde dat er veel mensen voorbij wandelden, vroeg hij wat er aan de hand was. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Men vertelde hem dat Jezus van Nazaret voorbijkwam. ");
INSERT INTO nldgbv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Toen begon hij te roepen: “Jezus, Zoon van David, heb medelijden met mij!” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","De mensen die voorop wandelden, snauwden hem toe dat hij moest zwijgen, maar hij riep almaar luider: “Zoon van David, heb medelijden met mij!” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jezus hield halt en gaf opdracht, de man bij Hem te brengen. Toen hij dichterbij kwam, vroeg Jezus: ");
INSERT INTO nldgbv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wat wil je dat Ik voor je doe?” De man zei: “Heer, zorg dat ik weer zie.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jezus zei tegen hem: “Zie! Je geloof heeft je genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Op hetzelfde moment kon de man weer zien. Hij volgde Jezus en verheerlijkte God. Heel het volk zag dat en prees God. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jezus ging Jericho binnen en trok door de stad. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Er was daar een man die Zacheüs heette; hij was hoofd-belastinginner en hij was rijk. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zacheüs wilde zien wie Jezus was, maar wegens de menigte lukte dat niet. Hij was namelijk klein van gestalte. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hij rende vooruit en klom in een vijgenboom, om Jezus te kunnen zien wanneer Hij zou voorbijkomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Toen Jezus bij die plaats aankwam, keek Hij omhoog en zei Hij: “Zacheüs, kom vlug naar beneden, want vandaag moet Ik bij jou thuis te gast zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacheüs kwam vlug naar beneden en heette Jezus hartelijk welkom in zijn huis. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Allen die het zagen, mopperden: “Jezus is te gast bij een zondaar.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maar Zacheüs stond recht en zei tegen de Heer: “Heer, ik zal de helft van mijn bezittingen aan de armen geven en ik zal aan iedereen die ik iets afhandig heb gemaakt, het viervoudige teruggeven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jezus zei tegen hem: “Vandaag is redding aan deze familie geschonken, want ook deze man is een afstammeling van Abraham. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","De Mensenzoon is gekomen om te zoeken en te redden wie verloren was.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Terwijl de mensen nog luisterden, begon Jezus een parabel te vertellen. Hij was nu dicht bij Jeruzalem en de mensen verwachtten dat Gods koninkrijk heel binnenkort zou aanbreken. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jezus zei: “Een edelman ging naar een ver land om daar het koningschap op zich te nemen en vervolgens terug te komen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hij riep tien van zijn dienaren bij zich en gaf hun tien mina. Hij zei tegen hen: ‘Gebruik dit geld om zaken te doen totdat ik terugkom.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Maar zijn onderdanen hadden een hekel aan hem en stuurden een delegatie achter hem aan met de boodschap: wij willen niet dat deze man onze koning wordt. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nadat hij het koningschap had ontvangen, kwam hij terug. Hij liet hij de dienaren aan wie hij het geld had gegeven, bij zich roepen om van hen te horen wat ze met het zakendoen hadden verdiend. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","De eerste verscheen en zei: ‘Heer, uw mina heeft nog tien mina's opgeleverd.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hij zei tegen hem: ‘Goed gedaan, goede dienaar, want je bent betrouwbaar geweest met weinig. Daarom krijg je het gezag over tien steden.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","De tweede kwam zeggen: ‘Heer, uw mina heeft nog vijf mina's opgeleverd.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tegen hem zei hij: ‘Jij krijgt het gezag over vijf steden.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Toen kwam de volgende zeggen: ‘Heer, hier is uw mina terug; ik heb hem in een doek bewaard. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ik was bang, want ik wist dat u een veeleisend mens bent: u eist terug wat u niet heeft overhandigd en maait wat u niet heeft gezaaid.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","De edelman zei tegen hem: ‘Jij nutteloze dienaar, ik zal je oordelen op grond van je eigen woorden. Je wist dus dat ik een veeleisend mens ben die terugeist wat ik niet heb overhandigd en oogst wat ik niet heb gezaaid? ");
INSERT INTO nldgbv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Waarom heb je mijn geld dan niet naar de bank gebracht? Dan had ik het na mijn terugkomst kunnen opnemen met rente!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tegen de omstaanders zei hij: ‘Neem hem zijn mina af en geef die aan de persoon die er tien heeft.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ze zeiden tegen hem: ‘Maar meneer, hij heeft er al tien!’ ");
INSERT INTO nldgbv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","De edelman antwoordde: ‘Ik zeg jullie dat aan ieder die heeft, nog meer zal worden gegeven, maar van wie niets heeft, zal zelfs hetgeen hij heeft worden afgenomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","En breng mijn vijanden die niet wilden dat ik hun koning zou worden, naar hier en dood hen voor mijn ogen.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nadat Jezus deze dingen had gezegd, vervolgde Hij zijn reis naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Toen Hij bijna bij Betfagé en Betanië was, bij de berg die Olijfberg wordt genoemd, stuurde Hij twee van zijn leerlingen vooruit. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hij zei: “Ga naar het dorp vóór jullie. Bij het binnengaan zullen jullie een vastgebonden jonge ezel zien, die nog nooit door iemand is bereden. Maak hem los en breng hem hier. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Als iemand jullie vraagt: ‘Waarom maken jullie hem los?’, zeg dan: ‘De Heer heeft hem nodig.’” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","De vooruitgestuurde leerlingen vertrokken en troffen alles aan zoals Jezus het hun had verteld. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Toen ze de jonge ezel losmaakten, vroegen de eigenaars hun: “Waarom maken jullie die jonge ezel los?” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ze antwoordden: “De Heer heeft hem nodig.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ze brachten de jonge ezel bij Jezus, legden hun mantels erop en lieten Jezus erop plaatsnemen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Terwijl Hij erop reed, spreidden de mensen hun mantels uit op de weg. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Toen Hij bijna bij het punt was waar de afdaling van de Olijfberg begint, begon de hele groep leerlingen verheugd en luidkeels God te prijzen voor alle wonderen die ze hadden gezien. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ze riepen: “Gezegend is de Koning die komt in de naam van de Heer! Vrede in de hemel en eer aan de Allerhoogste!” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sommige van de farizeeën in de menigte zeiden tegen Hem: “Leraar, wijs uw leerlingen terecht.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Maar Jezus antwoordde: “Ik zeg jullie dat als zij zouden zwijgen, de stenen zouden roepen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Toen Hij nog dichterbij Jeruzalem kwam en de stad zag liggen, begon Hij erom te wenen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hij zei: “Had jij, ja jij, vandaag maar geweten welke zaken vrede brengen. Maar nu kan je ze niet zien. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Er komt een tijd dat je vijanden belegeringswerken zullen bouwen om je te omsingelen en je aan alle kanten in te sluiten. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ze zullen je met de grond gelijk maken en je inwoners uitroeien. Ze zullen geen steen op de andere laten, omdat jij het tijdstip niet hebt erkend waarop God naar je omkeek.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jezus ging het tempelterrein op en begon de verkopers weg te jagen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hij zei tegen hen: “In de Schriften staat: ‘Mijn huis zal een gebedshuis zijn’, maar jullie hebben er een rovershol van gemaakt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jezus onderwees dagelijks op het tempelterrein, maar de hoofdpriesters, de Schriftgeleerden en de leiders van het volk wilden Hem ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ze konden echter geen manier bedenken om dat te doen, want het hele volk hing aan zijn lippen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Op een dag, toen Jezus op het tempelterrein het volk onderwees en het evangelie verkondigde, kwamen de hoofdpriesters en de Schriftgeleerden samen met de oudsten naar Hem toe. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ze vroegen Hem: “Vertel ons, op grond van welke bevoegdheid doet U deze dingen en wie is het die U die bevoegdheid heeft gegeven?” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jezus antwoordde: “Ik zal jullie ook een vraag stellen en dan mogen jullie Mij antwoord geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","De doop van Johannes, kwam die van God of van de mensen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ze overlegden met elkaar: “Als we zeggen: van God, zal Hij zeggen: Waarom geloven jullie hem dan niet? ");
INSERT INTO nldgbv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Maar als we zeggen: van de mensen, zal heel het volk ons stenigen, want de mensen zijn ervan overtuigd dat Johannes een profeet was.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Daarom antwoordden ze: “Wij weten niet vanwaar.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Toen zei Jezus tegen hen: “Dan vertel Ik jullie ook niet op grond van welke bevoegdheid Ik deze dingen doe.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jezus vertelde de volgende parabel aan het volk: “Iemand plantte een wijngaard aan, verhuurde deze aan wijnbouwers en ging lange tijd op reis. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","In de oogsttijd stuurde hij een knecht naar de wijnbouwers, opdat die hem zijn aandeel van de opbrengst van de wijngaard zouden geven. De wijnbouwers sloegen hem echter in elkaar en stuurden hem met lege handen weg. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Vervolgens zond hij nog een knecht naar hen toe. Ook die werd door hen in elkaar geslagen, vernederd en met lege handen weggestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vervolgens zond hij een derde en ook hij werd verwond de wijngaard uitgegooid. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Toen zei de eigenaar van de wijngaard: ‘Wat zal ik doen? Ik zal mijn dierbare zoon sturen; misschien zullen ze hem respecteren.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maar toen de wijnbouwers de zoon zagen, overlegden ze met elkaar: ‘Dit is de erfgenaam. Laten we hem doden; dan zal de erfenis van ons zijn.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ze gooiden hem de wijngaard uit en doodden hem. Wat gaat de eigenaar van de wijngaard nu met hen doen? ");
INSERT INTO nldgbv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hij zal naar de wijnbouwers gaan, hen ombrengen en de wijngaard aan anderen geven.” Toen de mensen dat hoorden, zeiden ze: “Zoiets mag absoluut niet gebeuren!” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jezus keek hen echter aan en zei: “Wat zou dit Schriftgedeelte dan betekenen: ‘De steen die de bouwers hebben afgekeurd, is de hoeksteen geworden’? ");
INSERT INTO nldgbv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ieder die over deze steen valt, raakt verbrijzeld, en degene op wie hij valt, wordt verpletterd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","De Schriftgeleerden en de hoofdpriesters probeerden Jezus op dat moment op te pakken, maar ze waren bang voor het volk. Ze beseften dat de parabel die Hij had verteld, over hen ging. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Daarom hielden ze Hem in de gaten en stuurden ze spionnen die zich als integer voordeden, met de bedoeling om Hem in zijn eigen woorden te vangen en Hem dan aan de rechtspraak en het gezag van de gouverneur over te leveren. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","De spionnen vroegen Jezus: “Leraar, wij weten dat uw uitspraken en uw onderwijs correct zijn, en dat U niet partijdig bent, maar naar waarheid onderwijst hoe men Gods weg moet bewandelen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Is het toegestaan dat wij belasting aan de keizer betalen, of niet?” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jezus merkte dat het een strikvraag was en zei tegen hen: ");
INSERT INTO nldgbv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Toon Mij een denarie. Wiens afbeelding en naam staan erop?” Ze antwoordden: “Van de keizer.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hij zei tegen hen: “Geef dan aan de keizer wat van de keizer is, en aan God wat van God is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ze konden Hem niet in zijn eigen woorden vangen in de aanwezigheid van het volk. Ze verbaasden zich over zijn antwoord en zwegen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Toen werd Jezus benaderd door enkele van de sadduceeën. (Zij beweren dat er geen verrijzenis is.) Zij vroegen: ");
INSERT INTO nldgbv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Leraar, volgens de geschriften van Mozes moet iemand van wie de broer sterft en een vrouw maar geen kinderen nalaat, met zijn schoonzus trouwen en zo voor nakomelingen zorgen voor zijn gestorven broer. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maar er waren eens zeven broers. De eerste trouwde, maar hij stierf kinderloos. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ook de tweede ");
INSERT INTO nldgbv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","en de derde trouwden met die vrouw, en zo verging het alle zeven: ze stierven zonder kinderen achter te laten. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Uiteindelijk stierf ook de vrouw. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Van wie wordt zij de echtgenote bij de verrijzenis? Ze zijn alle zeven met haar getrouwd geweest!” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jezus zei tegen hen: “De mensen van de huidige wereld trouwen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maar de mensen die naar de volgende wereld mogen en uit de dood verrijzen, trouwen niet. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dan kunnen ze ook niet meer sterven, want ze zijn dan als de engelen. En als verrezen mensen zijn ze kinderen van God. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Zelfs Mozes toont in het gedeelte over de doornstruik aan dat de doden verrijzen, want hij noemt de Heer ‘de God van Abraham, de God van Isaak en de God van Jakob.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hij is niet de God van doden maar van levenden, want voor Hem leven alle mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sommige Schriftgeleerden antwoordden: “Leraar, U heeft dat goed gezegd.” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Niemand durfde Jezus nog vragen te stellen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jezus vroeg hen: “Waarom wordt er gezegd dat de Messias de Zoon van David is? ");
INSERT INTO nldgbv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David zegt toch zelf in het boek Psalmen: ");
INSERT INTO nldgbv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘De Heer zei tegen mijn Heer: neem plaats aan mijn rechterzijde, totdat Ik je vijanden aan Je heb onderworpen.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David noemt Hem dus ‘Heer’. Hoe kan Hij dan ook zijn zoon zijn?” ");
INSERT INTO nldgbv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Terwijl heel het volk luisterde, zei Jezus tegen zijn leerlingen: ");
INSERT INTO nldgbv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pas op voor de Schriftgeleerden. Zij houden ervan rond te wandelen in prachtige gewaden. Ook zijn ze erop gesteld met respect te worden begroet op het marktplein en de beste plaatsen in te nemen in de synagogen en bij feestmalen. ");
INSERT INTO nldgbv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Maar ze slokken de huizen van weduwen op en bidden lange gebeden voor de schijn. Ze zullen extra zwaar worden gestraft.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Toen Jezus opkeek, zag Hij dat rijke mensen hun giften in de offerkist staken. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ook zag Hij dat een arme weduwe er twee kopermuntjes in stak. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hij zei: “Ik verzeker jullie dat deze arme weduwe meer heeft gegeven dan alle anderen, ");
INSERT INTO nldgbv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","want zij allen hebben hun gift gegeven vanuit hun overvloed, maar deze vrouw gaf vanuit haar armoede alles wat ze had om van te leven.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Toen sommigen zeiden dat het tempelterrein met mooie stenen en aan God gewijde geschenken was versierd, zei Jezus: ");
INSERT INTO nldgbv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Er komt een tijd dat alles wat jullie hier zien verwoest zal worden; geen steen zal op de andere worden gelaten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Men vroeg Hem: “Leraar, wanneer zal dat zijn en wat zal het teken zijn dat het op het punt staat te gebeuren?” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jezus zei: “Pas op, laat je niet misleiden, want er zullen veel mensen komen die zich mijn naam toe-eigenen, zich voor Mij uitgeven en zeggen: ‘Het is bijna zover.’ Loop niet achter hen aan. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wanneer jullie horen van oorlogen en onlusten, wees dan niet angstig; die dingen moeten eerst gebeuren, maar het einde is dan nog niet meteen aangebroken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jezus vervolgde: “Volken en koninkrijken zullen tegen elkaar oorlog voeren, ");
INSERT INTO nldgbv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","er zullen zware aardbevingen zijn, hongersnoden en epidemieën op allerlei plaatsen, en schrikwekkende en grote tekenen in de lucht. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Maar vooraleer dat alles gebeurt, zal men jullie oppakken en vervolgen; men zal jullie aan de synagogen uitleveren en gevangenzetten en jullie voor koningen en heersers leiden omwille van mijn naam. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Voor jullie is dat een kans om van Mij te getuigen. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Neem je daarom voor om geen verdedigingstoespraak voor te bereiden. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ik zal je namelijk wijze woorden ingeven, die door geen van jullie tegenstanders zal kunnen worden betwist of weerlegd. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jullie zullen zelfs door je ouders, broers, zussen, familie en vrienden worden verraden en sommigen van jullie zullen door hun toedoen worden gedood. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iedereen zal jullie haten omwille van mijn naam. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Toch zal er geen haar op je hoofd verloren gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Houd stand; dan zullen jullie het ware leven ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wanneer jullie zien dat Jeruzalem door legers wordt omsingeld, moeten jullie beseffen dat de stad binnenkort zal worden verwoest. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dan moeten de mensen in Judea de bergen invluchten; zij die in de stad zijn, moeten vertrekken en zij die op het land zijn moeten de stad niet binnengaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Want dat is de periode van vergelding, wanneer alles wat in de Schriften staat, in vervulling gaat. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Het zal verschrikkelijk zijn voor vrouwen die in die periode zwanger zijn of borstvoeding geven, want het land zal zwaar lijden en het volk zal worden gestraft. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","De mensen zullen met het zwaard worden omgebracht of naar het buitenland worden weggevoerd. Jeruzalem zal door de andere volken worden vertrappeld totdat de tijd van de niet-Joden voorbij is. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dan zullen er wonderlijke tekenen zijn aan de zon, maan en sterren, en op aarde zullen de volken ontdaan van angst zijn door het bulderen en golven van de zee. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mensen zullen flauwvallen van angst en bezorgdheid over wat er met de wereld zal gebeuren, want de hemellichamen zullen uit koers raken. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","En dan zal men de Mensenzoon zien komen, op een wolk en met macht en grote hemelse pracht. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wanneer deze dingen beginnen te gebeuren, ga dan op de uitkijk staan, want jullie staan op het punt te worden verlost.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hij vertelde hun een parabel: “Kijk eens naar de vijgenboom en naar alle andere bomen. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zodra ze uitlopen, zien jullie dat en weten jullie dat het bijna zomer is. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Op dezelfde manier kunnen jullie, wanneer je deze dingen ziet gebeuren, weten dat Gods koninkrijk dichtbij is. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ik verzeker jullie, dit volk zal niet vergaan voordat dit alles gebeurt. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","De hemel en de aarde zullen vergaan, maar mijn woorden zullen nooit vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pas op, laat je niet in beslag nemen door amusement, dronkenschap en de zorgen van het dagelijks leven, want die dag zal jullie plots overvallen, ");
INSERT INTO nldgbv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","zoals een val die dichtklapt. Die dag komt namelijk voor iedereen die op aarde leeft. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wees dus waakzaam en bid voortdurend dat jullie in staat zullen zijn, te ontkomen aan al deze dingen die op het punt staan te gebeuren, en dat jullie voor de Mensenzoon zullen mogen verschijnen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Overdag gaf Jezus steeds onderwijs op het tempelterrein, maar 's avonds ging Hij de stad uit om de nacht door te brengen op de berg die Olijfberg heet. ");
INSERT INTO nldgbv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","En 's ochtends vroeg kwam al het volk naar het tempelterrein om naar Hem te luisteren. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Het was bijna het Feest van de Ongedesemde Broden, dat ook Pesach wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","De hoofdpriesters en Schriftgeleerden zochten naar een geschikte manier om Jezus uit de weg te ruimen, want ze waren bang voor de reactie van het volk. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Toen nam Satan bezit van Judas, die Iskariot wordt genoemd en een van de Twaalf was. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hij ging naar de hoofdpriesters en de hoofden van de tempelwacht en besprak met hen hoe hij Jezus aan hen zou uitleveren. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ze waren verheugd en spraken met hem af dat ze hem geld zouden betalen. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hij stemde toe en zocht een gelegenheid om Hem aan hen uit te leveren zonder dat er veel volk bij zou zijn. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Toen de Dag van de Ongedesemde Broden aanbrak, waarop het Pesachlam geslacht moest worden, ");
INSERT INTO nldgbv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","stuurde Jezus Petrus en Johannes eropuit. Hij zei: “Ga de Pesachmaaltijd voor ons klaarmaken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Zij vroegen: “Waar wilt U dat we het klaarmaken?” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jezus antwoordde: “Wanneer jullie de stad binnenkomen, zullen jullie een man tegenkomen die een kan water draagt. Volg hem en ga het huis binnen dat hij binnengaat. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Zeg dan tegen de eigenaar van dat huis: ‘De Leraar vraagt u: Waar is het vertrek waar Ik met mijn leerlingen de Pesachmaaltijd kan eten?’ ");
INSERT INTO nldgbv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hij zal jullie een ingerichte bovenzaal tonen. Maak het daar klaar.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ze vertrokken, troffen alles aan overeenkomstig zijn beschrijving en maakten de Pesachmaaltijd klaar. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Toen het tijd was, ging Jezus met zijn leerlingen aan tafel. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hij zei tegen hen: “Ik heb er intens naar uitgekeken, deze Pesachmaaltijd met jullie te eten voordat Ik zal lijden. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Want Ik zeg jullie: Ik zal het nooit meer eten voordat het zijn ware betekenis heeft gekregen in Gods koninkrijk.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jezus nam een beker, sprak een dankgebed uit, en zei: “Neem deze beker en laat hem onder jullie rondgaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Want Ik zeg jullie: vanaf nu zal Ik niet meer drinken van de vrucht van de druivelaar totdat Gods koninkrijk gekomen is.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jezus nam een brood, sprak een dankgebed uit, brak het in stukken en deelde die uit aan zijn leerlingen, terwijl Hij zei: “Dit is mijn lichaam, dat voor jullie wordt gegeven. Doe dit om Mij te gedenken.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nadat ze hadden gegeten nam Jezus op dezelfde wijze een beker en zei Hij: “Deze beker die voor jullie wordt uitgegoten, is het nieuwe verbond, dat wordt gesloten door middel van mijn bloed. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Toch bevindt mijn verrader zich samen met Mij aan tafel. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Want de Mensenzoon zal wel heengaan, zoals reeds is bepaald, maar wee degene door wie Hij wordt verraden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ze begonnen met elkaar te discussiëren over wie van hen degene zou kunnen zijn die dit zou doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ook ontstond onder hen onenigheid, over wie van hen als de belangrijkste werd beschouwd. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jezus zei tegen hen: “Bij de andere volken is het zo dat hun koningen de baas over hen spelen en dat zij die macht over hen uitoefenen zich weldoener noemen. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Maar bij jullie is het zo niet. Integendeel, laat hij die de belangrijkste onder jullie is, als de minst belangrijke worden, en de leider als de dienaar. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Immers, wie is er belangrijker, iemand die aan tafel heeft plaatsgenomen of iemand die bedient? Is het niet de persoon die aan tafel heeft plaatsgenomen? Maar Ik gedraag me in jullie midden als iemand die bedient. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jullie zijn het die in al mijn beproevingen trouw bij Mij zijn gebleven. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","En zoals mijn Vader het koningschap aan Mij heeft toegekend, ken Ik dat aan jullie toe. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Daarom zullen jullie in mijn koninkrijk aan mijn tafel mogen eten en drinken en zullen jullie op een troon zitten en over de twaalf stammen van Israël rechtspreken. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, de satan heeft toestemming gevraagd om jullie te zeven als graan. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ik heb echter voor jou gebeden dat je geloof niet zal falen. Wanneer jij je herpakt hebt, versterk dan je broeders en zusters.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus antwoordde: “Heer, ik ben bereid om met U naar de gevangenis te gaan en te worden omgebracht.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Maar Jezus zei: “Petrus, Ik zeg je, voordat de haan vandaag kraait, zal je driemaal ontkennen dat je Mij kent.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jezus vroeg zijn leerlingen: “Toen Ik jullie had uitgezonden zonder geldbuidel, reistas of schoenen, hadden jullie toen ergens gebrek aan?” Ze antwoordden: “Aan niets.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hij zei tegen hen: “Laat nu wie een geldbuidel heeft, ook een reistas meenemen, en laat wie geen zwaard heeft, zijn mantel verkopen om er een te kopen. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Want Ik zeg jullie, het volgende citaat uit de Schriften gaat over Mij en moet in vervulling gaan: ‘Hij werd als een misdadiger beschouwd.’ Wat er over Mij staat, gaat nu in vervulling.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ze zeiden: “Kijk, Heer, hier zijn twee zwaarden.” Hij antwoordde: “Genoeg hierover.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jezus ging de stad uit en begaf zich zoals gewoonlijk naar de Olijfberg. Zijn leerlingen volgden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Toen Hij daar aankwam, zei Hij tegen hen: “Bid dat jullie niet in verzoeking komen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hij zonderde zich van hen af, ongeveer een steenworp bij hen vandaan, en knielde neer om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hij zei: “Vader, als U het wil, neem dan deze beker van Mij weg; laat echter niet gebeuren wat Ik wil, maar wat U wil.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Toen verscheen er een engel uit de hemel, die Hem kracht gaf. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jezus werd doodsbang. Hij bad nog vuriger en Hij zweette bloed, dat op de grond druppelde. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nadat Hij had gebeden, stond Hij op en ging Hij naar zijn leerlingen toe. Hij zag dat ze van verdriet in slaap waren gevallen, ");
INSERT INTO nldgbv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","en zei tegen hen: “Hoe is het mogelijk dat jullie slapen? Sta op en bid, opdat jullie niet in verzoeking komen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Terwijl Hij nog sprak, kwam er een grote groep mensen aan, die werd geleid door de man die Judas heette. Hij was een van de Twaalf en ging naar Jezus toe om Hem een kus te geven. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maar Jezus vroeg hem: “Judas, is het met een kus dat jij de Mensenzoon verraadt?” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Toen de mensen rondom Jezus zagen wat er stond te gebeuren, vroegen ze: “Heer, zullen we hen aanvallen met het zwaard?” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Een van hen viel de dienaar van de hogepriester aan en hakte zijn rechteroor af. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Maar Jezus zei: “Stop daarmee.” Hij raakte de man aan op de plaats van het oor en genas hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Toen zei Jezus tegen de hoofdpriesters, de hoofden van de tempelwacht en de oudsten die op Hem waren afgekomen: “Zijn jullie op Mij afgekomen als op een misdadiger, met zwaarden en knuppels? ");
INSERT INTO nldgbv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Toen Ik dagelijks bij jullie op het tempelterrein was, hebben jullie mij niet opgepakt, maar dit is jullie moment – nu regeert de duisternis.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jezus werd gearresteerd, weggeleid en naar het huis van de hogepriester gebracht. Petrus volgde op een afstand. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Midden op de binnenplaats was een vuur aangestoken, waarrond mensen waren gaan zitten. Petrus bevond zich onder hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","In het licht van het vuur zag een dienstmeisje hem zitten. Ze bekeek hem en zei: “Die man was ook bij Jezus.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petrus ontkende het: “Ik ken Hem niet.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Een tijdje later zag iemand anders hem en zei: “Jij bent ook een van hen”, maar Petrus zei: “Nee, dat ben ik niet.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na verloop van ongeveer een uur beweerde nog iemand anders: “Die man was toch echt wel bij Hem, want hij is een Galileër.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrus zei echter: “Ik weet niet waar je het over hebt.” Op hetzelfde moment, terwijl hij nog sprak, kraaide er een haan. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","De Heer draaide zich om en keek Petrus aan. Toen herinnerde Petrus zich wat de Heer tegen hem had gezegd: “Voordat vandaag de haan kraait, zal jij Mij driemaal verloochenen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hij ging naar buiten en weende bitter. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","De mannen die Jezus bewaakten, bespotten en sloegen Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ook blinddoekten ze Hem en riepen ze: “Profeteer dan, wie heeft Je geslagen?” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ze zeiden nog veel andere beledigende dingen tegen Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Toen het licht werd, kwam de raad van volksoudsten, hoofdpriesters en Schriftgeleerden bijeen en werd Jezus aan de raad voorgeleid. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ze zeiden: “Zeg ons of U de Messias bent.” Jezus antwoordde: “Als Ik het u zeg, zal u Mij niet geloven. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","En als Ik u iets zou vragen, zou u niet antwoorden. ");
INSERT INTO nldgbv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Maar vanaf nu zal de Mensenzoon aan de rechterzijde van de machtige God zitten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ze vroegen allemaal: “Bent U dan de Zoon van God?” Hij antwoordde: “U zegt dat Ik dat ben.” ");
INSERT INTO nldgbv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Toen zeiden ze: “Meer bewijs hebben we toch niet nodig? Nu hebben we het zelf uit zijn eigen mond gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","De voltallige raad stond op en leidde Jezus voor aan Pilatus. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","De raadsleden begonnen hun beschuldiging als volgt: “Wij hebben vastgesteld dat deze Man een slechte invloed op ons volk heeft. Hij verbiedt het betalen van de keizerlijke belasting en beweert dat Hij de Messias is, een koning.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus vroeg aan Jezus: “Bent U de koning van de Joden?” Jezus antwoordde: “U zegt het zelf.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus zei tegen de hoofdpriesters en de mensenmassa: “Ik vind niets strafbaars aan deze man.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ze bleven echter volhouden: “Maar Hij hitst de mensen in heel Judea op met zijn leer; eerst deed Hij dat in Galilea en nu ook hier.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Toen Pilatus dat hoorde, vroeg hij of Jezus een Galileër was. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","En toen hij vernam dat Jezus uit het rechtsgebied van Herodes kwam, stuurde Pilatus Hem naar Herodes, die in die periode ook in Jeruzalem was. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Toen Herodes Jezus zag, was hij verheugd, want hij had er reeds lang naar verlangd Jezus te zien. Hij had namelijk over Hem gehoord en hoopte Hem een wonder te zien doen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hij stelde Hem heel veel vragen, maar Jezus gaf geen antwoord. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","De hoofdpriesters en Schriftgeleerden stonden erbij en beschuldigden Hem in felle bewoordingen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Toen vernederden en bespotten Herodes en zijn soldaten Jezus, kleedden ze Hem in een prachtig gewaad en stuurden ze Hem naar Pilatus terug. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Op die dag raakten Herodes en Pilatus met elkaar bevriend; voordien waren ze vijanden van elkaar. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Toen riep Pilatus de hoofdpriesters, leiders en het volk bijeen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hij zei tegen hen: “Jullie hebben deze Man aan mij voorgeleid als iemand die het volk misleidt. Ik heb Hem in jullie bijzijn verhoord en heb deze Man niet schuldig bevonden aan hetgeen waarvoor jullie Hem aanklagen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ook Herodes denkt niet dat Hij schuldig is, want hij heeft Hem naar ons teruggestuurd. Hij heeft dus niets gedaan waarop de doodstraf staat. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Daarom zal ik Hem geselen en laten gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Maar ze schreeuwden allen tezamen: “Weg met Hem! Laat Barabbas vrij.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas was iemand die in de stad een opstand had geleid en voor moord in de gevangenis was gegooid. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus zei nogmaals tegen de mensen dat hij Jezus wilde vrijlaten. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maar ze bleven schreeuwen: “Kruisig Hem! Kruisig Hem!” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hij vroeg hun voor de derde keer: “Waarom? Wat heeft deze Man misdaan? Ik heb geen grond voor de doodstraf in Hem gevonden; daarom zal ik Hem laten geselen en vrijlaten.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ze bleven echter luidkeels eisen dat Hij gekruisigd zou worden en hun geschreeuw kreeg de overhand. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hij besloot hun eis in te willigen: ");
INSERT INTO nldgbv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","de man die voor opstand en moord in de gevangenis was gegooid en om wiens vrijlating ze vroegen, liet hij vrij, maar met Jezus mochten ze doen wat ze wilden. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Toen de soldaten Jezus wegleidden, grepen ze een zekere Simon van Cyrene, die van het land de stad binnenkwam. Ze legden het kruis op zijn schouder en dwongen hem, het achter Jezus aan te dragen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jezus werd gevolgd door een grote groep mensen, waaronder vrouwen die luidruchtig om Hem treurden. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hij draaide zich om en zei tegen hen: “Dochters van Jeruzalem, stop met wenen om Mij. Ween om jezelf en om je kinderen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Er komt namelijk een tijd dat men zal zeggen: ‘Gezegend zijn de onvruchtbare vrouwen en zij die nooit kinderen hebben gebaard en gevoed.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dan zullen de mensen tegen de bergen zeggen: ‘Val op ons’, en tegen de heuvels: ‘Bedek ons.’ ");
INSERT INTO nldgbv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Want als mensen deze dingen doen wanneer de boom nog groen is, wat zal er dan gebeuren wanneer ze is verdord?” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Samen met Jezus werden ook twee misdadigers weggeleid om te worden terechtgesteld. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Toen ze bij de plaats aankwamen die Schedel wordt genoemd, kruisigden ze Jezus en de misdadigers; de ene hing rechts en de andere links van Hem. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jezus zei: “Vader, vergeef hun, want ze beseffen niet wat ze doen.” Zijn kleren werden door middel van verloting verdeeld. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Het volk stond toe te kijken en de leiders dreven de spot met Hem. Ze zeiden: “Anderen heeft Hij gered, laat Hij nu zichzelf redden als Hij de door God beloofde Messias is, de Uitverkorene.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ook de soldaten lachten Hem uit; ze gingen naar Hem toe, boden Hem zure wijn aan ");
INSERT INTO nldgbv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","en zeiden: “Als Jij de koning van de Joden bent, red Jezelf dan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Boven Hem hing een bordje: “Dit is de koning van de Joden.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Een van de misdadigers die naast Hem hing, beledigde Hem door te zeggen: “Ben Jij niet de Messias? Red dan Jezelf en ook ons.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Maar de andere misdadiger wees hem terecht door te reageren: “Ben jij zelfs niet bang voor God? Jij hebt dezelfde veroordeling gekregen als Hij, ");
INSERT INTO nldgbv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","en voor ons is dat terecht, want wij krijgen het verdiende loon voor onze daden, maar deze Man heeft niets verkeerds gedaan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ook zei hij: “Jezus, denk aan mij wanneer U uw koninkrijk binnengaat.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jezus zei tegen hem: “Ik verzeker je, vandaag zal je bij Mij in het paradijs zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Het was nu ongeveer twaalf uur en het werd donker in het hele land, tot drie uur 's middags. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","De zon was verduisterd en het tempelgordijn scheurde in tweeën. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Toen riep Jezus luid: “Vader, Ik leg mijn geest in uw handen.” Nadat Hij dit had gezegd, stierf Hij. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Toen de centurio zag wat er was gebeurd, verheerlijkte hij God. Hij zei: “Deze man was werkelijk onschuldig.” ");
INSERT INTO nldgbv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","De vele mensen die op dit schouwspel waren afgekomen, zagen wat er gebeurde en gingen naar huis. Van verdriet sloegen ze zich op de borst. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maar allen die Jezus hadden gekend, waaronder de vrouwen die Hem vanuit Galilea waren gevolgd, bleven op een afstand staan kijken. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Er was een man die Jozef heette, een lid van de Joodse raad. Hij was een goed en oprecht man. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hij kwam uit Arimatea, een stad in Judea, en hij verwachtte Gods koninkrijk. Hij had niet ingestemd met het besluit en de handelwijze van de Joodse raad. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hij ging naar Pilatus en vroeg om het lichaam van Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hij haalde het van het kruis, wikkelde het in een linnen doek en legde het in een uitgehouwen graf waarin nog niemand was begraven. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Het was Voorbereidingsdag en de sabbat zou bijna beginnen. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","De vrouwen die vanuit Galilea met Jezus waren meegekomen, volgden Jozef. Ze zagen het graf en hoe Jezus' lichaam erin werd gelegd. ");
INSERT INTO nldgbv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ze gingen naar huis om geurige oliën en balsem klaar te maken, en op de sabbat namen ze rust, zoals de Wet voorschrijft. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Op de eerste dag van de week, zodra het ochtend werd, gingen ze naar het graf met de geurige oliën die ze hadden klaargemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ze zagen dat de steen van het graf was weggerold, ");
INSERT INTO nldgbv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","en toen ze naar binnen gingen, troffen ze het lichaam van de Heer Jezus niet aan. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ze wisten zich geen raad met de situatie. Opeens stonden er twee mannen in oogverblindend stralende kleren bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","De vrouwen waren zo bang dat ze naar de grond keken, maar de engelen zeiden tegen hen: “Waarom zoeken jullie bij de doden naar de Levende? ");
INSERT INTO nldgbv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hij is hier niet, Hij is verrezen. Weten jullie nog wat Hij jullie heeft verteld toen Hij nog in Galilea was? ");
INSERT INTO nldgbv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hij zei dat de Mensenzoon aan zondige mensen zou worden overgeleverd, zou worden gekruisigd en op de derde dag weer tot leven zou komen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Toen herinnerden de vrouwen zich wat Jezus had gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ze keerden terug van het graf en rapporteerden dit alles aan de Elf en aan alle anderen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","De vrouwen die het aan de apostelen vertelden waren Maria van Magdala, Johanna, Maria de moeder van Jakobus en de andere vrouwen bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hun woorden kwamen echter op de apostelen over als onzinnig gepraat. Ze geloofden hen niet, ");
INSERT INTO nldgbv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","maar Petrus rende naar het graf. Toen hij zich voorover boog en naar binnen keek, zag hij enkel de windsels. Hij ging naar huis en vroeg zich af wat er was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Diezelfde dag nog gingen twee van hen naar een dorp dat op elf kilometer van Jeruzalem ligt en Emmaüs heet. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Zij praatten met elkaar over alles wat er was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Terwijl ze aan het praten en discussiëren waren, kwam Jezus zelf naar hen toe en wandelde met hen mee. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Maar ze werden ervan weerhouden Hem te herkennen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hij vroeg hun: “Waarover zijn jullie onderweg met elkaar aan het discussiëren?” Ze hielden halt en keken triest. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Een van hen – hij heette Kleopas – zei tegen Hem: “Bent U dan de enige vreemdeling in Jeruzalem die niet op de hoogte is van de dingen die hier onlangs zijn gebeurd?” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hij vroeg hun: “Welke dingen?” Ze antwoordden: “Wat er is gebeurd met Jezus van Nazaret. In de ogen van God en het hele volk was Hij een profeet, een man die krachtig optrad en sprak. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Maar de hoofdpriesters en onze leiders hebben Hem laten ter dood veroordelen en kruisigen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wij hadden zo gehoopt dat Hij Degene was die Israël zou verlossen. En nu is het al de derde dag sinds die dingen zijn gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maar ook hebben enkele van de vrouwen die bij ons zijn ons versteld doen staan toen ze vanochtend vroeg naar het graf waren gegaan, ");
INSERT INTO nldgbv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","en zijn lichaam niet aantroffen. Ze kwamen vertellen dat er engelen aan hen waren verschenen, die zeiden dat Hij leeft. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Enkelen van ons zijn naar het graf gegaan en zij troffen het precies zo aan als de vrouwen hadden verteld, maar Hem hebben ze niet gezien.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jezus zei tegen de mannen: “Wat zijn jullie onwetend en traag van begrip, dat jullie geen geloof hechten aan alles wat de profeten hebben gezegd! ");
INSERT INTO nldgbv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Het was toch nodig dat de Messias zou lijden en zijn glorie zou binnengaan?” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Toen legde Hij hun uit wat er over Hem in al de Schriften staat, te beginnen met Mozes en verder in alle Profeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Toen ze het dorp naderden waarnaar ze onderweg waren, deed Jezus alsof Hij verder wilde gaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Zij drongen echter bij Hem aan: “Blijf bij ons logeren, want straks wordt het avond; het is al late namiddag.” Daarom ging Hij met hen naar huis en bleef Hij bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Toen Jezus met hen aan tafel had plaatsgenomen, nam Hij het brood, sprak Hij een zegengebed uit, brak Hij het brood in stukken en gaf Hij hun daarvan. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Toen gingen hun ogen open en herkenden ze Hem, maar meteen daarna was Hij uit hun zicht verdwenen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ze zeiden tegen elkaar: “Klopten onze harten niet sneller toen Hij ons onderweg toesprak en de Schriften aan ons uitlegde?” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ze stonden meteen op en keerden naar Jeruzalem terug. Daar troffen ze de Elf gezamenlijk aan, samen met hun gasten. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","De apostelen zeiden: “De Heer is werkelijk verrezen; Hij is aan Simon verschenen.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Toen vertelden de twee reizigers wat zij onderweg hadden ervaren en hoe ze Jezus herkenden toen Hij het brood in stukken brak. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Terwijl ze dit aan het vertellen waren, stond Jezus opeens zelf in hun midden. Hij zei tegen hen: “Ik wens jullie vrede toe.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ze schrokken en waren erg bang; ze dachten dat ze een geest zagen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jezus zei tegen hen: “Waarom zijn jullie zo overstuur en twijfelen jullie zo? ");
INSERT INTO nldgbv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kijk naar mijn handen en voeten; jullie zien toch dat Ik het ben? Raak Me aan en kijk naar Mij; een geest heeft toch geen lichaam zoals jullie zien dat Ik heb?” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nadat Hij dat had gezegd, toonde Hij hun zijn handen en voeten. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Toen ze het van vreugde en verbazing nog altijd niet konden geloven, vroeg Hij hun: “Hebben jullie hier iets te eten?” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ze gaven Hem een stuk geroosterde vis. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hij nam het aan en at het voor hun ogen op. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Toen zei Jezus tegen hen: “Dit zijn de dingen waarover Ik jullie had verteld toen Ik nog bij jullie was. Alles wat over Mij in de Wet van Mozes en in de Profeten en de Psalmen staat, moest in vervulling gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Toen schonk Hij hun het inzicht om de Schriften te begrijpen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hij zei tegen hen: “Er staat dat de Messias zou lijden en op de derde dag uit de dood zou verrijzen, ");
INSERT INTO nldgbv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","en dat in zijn naam de inkeer die tot vergeving van zonden leidt, aan alle volken verkondigd zou worden, te beginnen in Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jullie zijn daar getuigen van. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ik zal het geschenk dat mijn Vader heeft beloofd, naar jullie toe sturen. Jullie moeten echter in de stad blijven totdat jullie worden toegerust met kracht die van boven komt.” ");
INSERT INTO nldgbv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hij leidde hen de stad uit, naar Betanië. Daar hief Hij zijn handen omhoog en zegende hen. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Terwijl Hij hen zegende, werd Hij in de hemel opgenomen, bij hen vandaan. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ze aanbaden Jezus en keerden vol vreugde terug naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Daar waren ze voortdurend op het tempelterrein God aan het prijzen.");
INSERT INTO nldgbv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In het begin was het Woord er al. Het Woord was bij God en het Woord was God. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Het Woord was reeds in het begin bij God. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Alles is door Hem, het Woord, ontstaan en er is niets dat buiten Hem om is ontstaan. Alles wat bestaat ");
INSERT INTO nldgbv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","heeft het leven aan Hem te danken en het leven was het licht voor de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Het licht schijnt in de duisternis en de duisternis heeft het niet kunnen doven. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Er kwam iemand die Johannes heette. Hij was door God gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hij kwam om getuige te zijn – om van het licht te getuigen, opdat door hem alle mensen zouden geloven. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hij was zelf niet het licht; hij kwam van het licht getuigen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Het ware licht, dat ieder mens verlicht, is naar de wereld gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hij was in de wereld – de wereld die dankzij Hem was ontstaan – maar de wereld erkende Hem niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hij kwam naar hetgeen van Hem was, maar zij die van Hem waren, hebben Hem niet aanvaard. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Er zijn er echter die Hem wel hebben aanvaard en die op Hem vertrouwen. Hun heeft Hij het voorrecht geschonken om Gods kinderen te worden, ");
INSERT INTO nldgbv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","door middel van een geboorte die niet lichamelijk is, en ook niet het gevolg is van een natuurlijke wens of de wil van een man; het is een geboorte die van God komt. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Het Woord is mens geworden en heeft bij ons gewoond. Wij hebben zijn grootheid gezien, de grootheid van de enige Zoon van de Vader, vol genade en waarheid. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes getuigde van Hem door uit te roepen: “Hij is het van wie ik heb gezegd: Na mij komt Iemand die boven mij staat, want Hij bestond al voordat ik er was.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","En vanuit zijn overvloedige genade hebben wij almaar meer genade ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Want de Wet werd gegeven via Mozes, maar genade en waarheid zijn er gekomen door Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Niemand heeft ooit God gezien, maar de enige God, Hij die zich aan de zijde van de Vader bevindt, Hij is het die ervoor heeft gezorgd dat men God kan kennen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Toen de Joodse leiders vanuit Jeruzalem priesters en Levieten naar Johannes stuurden om te vragen: “Wie bent u?”, was dit zijn getuigenis. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hij verklaarde eenduidig en onomwonden: “Ik ben niet de Messias.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ze vroegen hem: “Wie bent u dan? Bent u Elia?” Hij zei: “Nee, ook niet.” “Bent u de profeet?” Hij antwoordde: “Nee.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Toen vroegen ze: “Wie bent u dan? We moeten de mensen die ons hebben gestuurd toch een antwoord geven! Wie zegt u dat u bent?” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hij zei: “Zoals de profeet Jesaja zei: ‘Ik ben een stem die roept in de wildernis: Maak de weg van de Heer vrij.’” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","De mensen die door de farizeeën waren gestuurd, ");
INSERT INTO nldgbv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","vroegen verder: “Waarom doopt u dan, als u niet de Messias bent en ook niet Elia, noch de profeet?” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes antwoordde: “Ik doop met water, maar tussen jullie staat Iemand die jullie niet herkennen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hij is het, die na mij komt. Ik ben het niet waard om zijn schoenriem los te maken.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dit gebeurde in Betanië, aan de overkant van de Jordaan, waar Johannes aan het dopen was. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","De volgende dag zag Johannes Jezus naar zich toe komen. Hij zei: “Daar is het lam van God, dat de zonde van de wereld wegneemt. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hij is het van wie ik heb gezegd: ‘Na mij komt Iemand die boven mij staat, want Hij bestond al voordat ik er was.’ ");
INSERT INTO nldgbv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ik wist niet wie Hij was, maar ik kwam dopen met water zodat Hij aan Israël kon worden geopenbaard.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johannes getuigde: “Ik zag dat de Geest uit de hemel neerdaalde als een duif en op Hem bleef rusten. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ik wist niet wie Hij was, maar Degene die mij had gestuurd om met water te dopen, zei tegen mij: ‘De persoon op wie je de Geest ziet neerdalen en blijven rusten, Hij is het die doopt met de Heilige Geest.’ ");
INSERT INTO nldgbv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ik heb het zelf gezien; ik verklaar: Hij is de Zoon van God.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","De volgende dag stond Johannes er opnieuw met twee van zijn leerlingen. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hij keek naar Jezus, die daar langs kwam en zei: “Daar is het lam van God.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","De twee leerlingen hoorden wat hij zei en gingen achter Jezus aan. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jezus draaide zich om, zag dat ze Hem volgden, en vroeg hen: “Wat willen jullie?” Zij antwoordden: “Rabbi” (dat betekent: Leraar), “waar verblijft U?” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jezus zei tegen hen: “Kom maar mee, dan zullen jullie het zien.” Ze kwamen met Hem mee en zagen waar Hij verbleef. Het was ongeveer vier uur 's middags en ze bleven de rest van die dag bij Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Eén van de twee die Johannes hadden horen spreken en die met Jezus waren meegegaan, was Andreas, de broer van Simon Petrus. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hij zocht onmiddellijk zijn broer Simon op en zei tegen hem: “Wij hebben de Messias gevonden.” (Messias betekent: Christus, gezalfde.) ");
INSERT INTO nldgbv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas bracht Simon bij Jezus. Jezus keek hem aan en zei: “Jij bent Simon, de zoon van Johannes. Voortaan zal je Kefas genoemd worden.” (Die naam betekent: Petrus, rots.) ");
INSERT INTO nldgbv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","De volgende dag besloot Jezus naar Galilea te gaan. Hij zocht Filippus op en zei tegen hem: “Kom met Mij mee.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippus kwam uit Betsaïda, de thuisstad van Andreas en Petrus. ");
INSERT INTO nldgbv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus zocht Natanaël op en zei tegen hem: “We hebben Hem gevonden, over Wie Mozes schreef in de Wet en over wie ook de profeten schreven. Het is Jezus, de zoon van Jozef, uit Nazaret.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaël vroeg hem: “Kan uit Nazaret iets goeds komen?” Filippus antwoordde: “Kom maar mee, dan zal je het zien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jezus zag Natanaël aankomen en zei: “Daar is een echte Israëliet, iemand die door en door eerlijk is.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaël vroeg Hem: “Hoe kent U mij?” Jezus antwoordde: “Ik had je al gezien voordat Filippus je riep, toen je onder de vijgenboom zat.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaël verklaarde: “Rabbi, U bent de Zoon van God, U bent de koning van Israël.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jezus antwoordde: “Geloof jij omdat Ik tegen je zei dat Ik je onder de vijgenboom zag zitten? Jij zal grotere dingen zien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jezus vervolgde: “Ik zeg jullie nadrukkelijk, jullie zullen de hemel zien opengaan en Gods engelen zien opstijgen en neerdalen op de Mensenzoon.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Op de derde dag was er in Kana in Galilea een huwelijksfeest en Jezus' moeder was daar. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jezus en zijn leerlingen waren ook voor het huwelijksfeest uitgenodigd. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Toen de wijn opraakte, zei Jezus' moeder tegen Hem: “Ze hebben geen wijn meer.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jezus antwoordde: “Wat hebben wij daarmee te maken? Mijn moment is nog niet gekomen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Zijn moeder zei tegen de mensen die opdienden: “Doe wat Hij tegen jullie zegt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nu stonden daar zes stenen watervaten voor het joodse reinigingsritueel, elk met een inhoud van tachtig tot honderd liter. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jezus zei tegen de mensen die opdienden: “Vul die vaten met water.” Ze vulden ze tot de rand. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jezus zei tegen hen: “Schep er nu wat uit en breng het naar de ceremoniemeester.” Dat deden ze. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","De ceremoniemeester proefde van het water dat wijn was geworden. Hij wist niet waar het vandaan kwam, maar de mensen die opdienden wisten dat wel. De ceremoniemeester riep de bruidegom, ");
INSERT INTO nldgbv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","en zei tegen hem: “Iedereen zet eerst de goede wijn voor, en wanneer de gasten dronken zijn, de minder goede. Maar jij hebt de goede wijn bewaard tot nu.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Dit was het eerste wonderlijke teken dat Jezus verrichtte, in Kana in Galilea. Zo toonde Hij zijn grootheid – en zijn leerlingen geloofden in Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Daarna ging Hij naar Kafarnaüm, met zijn moeder, zijn broers en zijn leerlingen. Daar bleven ze enkele dagen. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Binnenkort zou het Joodse Pesachfeest plaatsvinden en Jezus ging naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Op het tempelterrein trof Hij de verkopers van runderen, schapen en duiven aan en zag Hij de geldwisselaars zakendoen. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hij maakte een zweep van touw en verjoeg alle mensen van het tempelterrein, en ook de schapen en runderen. Verder duwde Hij de tafels van de geldwisselaars omver, zodat hun geld op de grond viel. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tegen de verkopers van de duiven zei Hij: “Neem ze hier weg, maak van het huis van mijn Vader geen marktplaats.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Toen herinnerden zijn leerlingen zich dat in de Schriften staat: “Mijn inzet voor uw huis zal alles van mij vragen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","De Joodse leiders zeiden tegen Jezus: “Doe eens een wonderlijk teken om te bewijzen dat U het recht hebt om deze dingen te doen!” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jezus antwoordde: “Breek deze tempel maar af; dan zal Ik hem in drie dagen heropbouwen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Toen zeiden de Joodse leiders: “De bouw van deze tempel heeft 46 jaar in beslag genomen, en U gaat hem in drie dagen heropbouwen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Met “de tempel” bedoelde Jezus echter zijn lichaam. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Later, toen Hij uit de dood was verrezen, herinnerden zijn leerlingen zich dat Hij dit had gezegd; toen geloofden ze de Schriften en hetgeen Jezus had gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tijdens het Pesachfeest, toen Jezus in Jeruzalem was, kwamen velen tot geloof in Hem, omdat ze de wonderlijke tekenen zagen die Hij verrichtte. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jezus vertrouwde zich echter niet aan hen toe, omdat Hij iedereen doorzag. ");
INSERT INTO nldgbv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Niemand hoefde Hem uitleg over de mens te geven, want Hij wist wat er in de mens omgaat. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Een van de Joodse leiders was een man die Nikodemus heette, een farizeeër. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Op een nacht ging hij naar Jezus toe en zei: “Rabbi, wij weten dat U een leraar bent die van God komt, want niemand kan de wonderlijke tekenen verrichten die U verricht, tenzij met Gods hulp.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jezus antwoordde: “Ik zeg je nadrukkelijk, niemand kan Gods koninkrijk zien, tenzij hij opnieuw wordt geboren.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus vroeg Hem: “Hoe kan een mens geboren worden als hij reeds volwassen is? Hij kan toch niet in de schoot van zijn moeder terugkeren en een tweede keer geboren worden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jezus antwoordde: “Ik zeg je nadrukkelijk, niemand kan Gods koninkrijk binnengaan, tenzij hij wordt geboren uit water en door de Geest. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Het menselijk lichaam wordt geboren uit de mens, maar het geestelijke wordt geboren door het werk van Gods Geest. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wees niet verbaasd dat Ik tegen je heb gezegd dat je opnieuw geboren moet worden. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","De wind waait waar hij naartoe wil en je kan zijn geluid horen, maar je weet niet waar hij vandaan komt en waar hij naartoe gaat. Zo is het ook met iedereen die door het werk van de Geest is geboren.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus vroeg Hem: “Hoe kan dat?” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jezus antwoordde: “Jij bent het die Israël onderwijst en jij begrijpt dit niet? ");
INSERT INTO nldgbv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ik zeg je nadrukkelijk, wij spreken over wat wij weten, en wij getuigen van wat wij hebben gezien. En toch aanvaarden jullie onze getuigenis niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Als jullie Mij niet geloven wanneer ik over aardse zaken spreek, hoe zullen jullie Mij dan geloven wanneer ik over hemelse zaken spreek? ");
INSERT INTO nldgbv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Er is nog nooit iemand naar de hemel gegaan; alleen Hij die uit de hemel is gekomen, de Mensenzoon, is er geweest. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","En zoals Mozes in de wildernis de slang omhooghief, zo moet de Mensenzoon worden omhooggeheven, ");
INSERT INTO nldgbv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","opdat ieder die in Hem gelooft het eeuwig leven zal hebben. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Zo had God de wereld lief: door zijn enige Zoon te geven, opdat ieder die in Hem gelooft het eeuwig leven zou hebben en niet verloren zou gaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God heeft de Zoon niet naar de wereld gezonden om de wereld te veroordelen, maar om de wereld te redden. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wie in Hem gelooft, wordt niet veroordeeld, maar wie niet gelooft, is reeds veroordeeld omdat hij niet zijn vertrouwen op Gods enige Zoon heeft gesteld. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Het zit zo met het Oordeel: het licht is naar de wereld gekomen, maar de mensen hielden meer van het duister dan van het licht, want hun daden waren slecht. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ieder die kwaad doet, haat het licht; hij weigert naar het licht toe te komen, omdat zijn daden dan worden onthuld. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Maar wie oprecht leeft, komt naar het licht toe, zodat zal blijken dat hij zijn daden heeft verricht uit gehoorzaamheid aan God.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Later ging Jezus met zijn leerlingen naar het gebied Judea. Hij verbleef daar enige tijd en doopte. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ook Johannes doopte, in Enon, dicht bij Salim. Daar was veel water en de mensen kwamen ernaartoe om te worden gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Johannes was toen nog niet gevangengezet. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Enkele leerlingen van Johannes kregen onenigheid met een Joodse leider over het Joodse reinigingsritueel. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ze gingen naar Johannes toe en vroegen hem: “Rabbi, de Man die bij u was aan de overkant van de Jordaan, die u heeft aangeduid, Hij is aan het dopen en de mensen gaan allemaal naar Hem toe.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes antwoordde: “Een mens kan enkel ontvangen wat hem vanuit de hemel wordt geschonken. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jullie zijn er zelf getuige van dat ik heb gezegd: ‘Ik ben de Messias niet, maar ik ben voor Hem uitgestuurd.’ ");
INSERT INTO nldgbv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wie de bruid krijgt, is de bruidegom, maar de beste vriend van de bruidegom staat naar de bruidegom te luisteren en verheugt zich wanneer hij de stem van de bruidegom hoort. Dat geldt ook voor mij: ik ben vervuld met vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hij moet meer aanzien krijgen, en ik minder.” ");
INSERT INTO nldgbv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hij die van boven komt, staat boven allen; wie uit de aarde voortkomt, is aards en spreekt op aardse wijze. Hij die uit de hemel komt en boven alles staat, ");
INSERT INTO nldgbv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","getuigt van hetgeen Hij heeft gezien en gehoord, en niemand aanvaardt zijn getuigenis. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Maar wie zijn getuigenis wel aanvaardt, bevestigt zo dat God betrouwbaar is. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Hij die door God gezonden is, spreekt de woorden van God, want God schenkt de Geest zonder enige beperking. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","De Vader heeft de Zoon lief en heeft Hem alle macht gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wie in de Zoon gelooft, heeft het eeuwig leven. Wie daarentegen weigert de Zoon te gehoorzamen, zal het leven niet ervaren, maar Gods straf ondervinden. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jezus kwam te weten dat de farizeeën hadden gehoord dat Hij meer volgelingen maakte en doopte dan Johannes. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Het was echter niet Jezus zelf die doopte, maar zijn leerlingen.) ");
INSERT INTO nldgbv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Daarom verliet Hij Judea en reisde Hij terug naar Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hij moest door Samaria heen, ");
INSERT INTO nldgbv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","en zo kwam Hij bij de Samaritaanse stad Sichar, dicht bij het stuk grond dat Jakob aan zijn zoon Jozef had nagelaten. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Daar bevond zich de Jakobsbron. Vermoeid van de reis ging Jezus bij de bron zitten. Het was ongeveer twaalf uur 's middags. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Toen er een vrouw uit Samaria water kwam putten, vroeg Jezus haar: “Wilt u Mij wat te drinken geven?” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Zijn leerlingen waren namelijk naar de stad gegaan om eten te kopen. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","De Samaritaanse vrouw vroeg: “Hoe kan U, een Jood, mij, een Samaritaanse, om drinken vragen?” Joden gaan namelijk niet om met Samaritanen. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jezus antwoordde: “Als je zou weten wat God kan geven en Wie het is die jou om drinken vraagt, dan zou jij Hém om drinken vragen en Hij zou je het water geven dat leven geeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","De vrouw zei: “Meneer, U hebt geen emmer en de put is diep; hoe komt U dan aan dat water dat leven geeft? ");
INSERT INTO nldgbv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","U bent toch niet machtiger dan onze voorvader Jakob, die ons de bron heeft nagelaten? Hij heeft er zelf van gedronken, en ook zijn zonen en zijn vee.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jezus antwoordde: “Ieder die van dit water drinkt, zal opnieuw dorst krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Maar wie van het water drinkt dat Ik hem geef, zal nooit meer dorst krijgen. Integendeel, het water dat Ik geef, zal binnenin hem een bron worden, waaruit water opwelt tot in het eeuwig leven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","De vrouw vroeg: “Meneer, geef mij dit water! Dan zal ik geen dorst meer krijgen en hoef ik niet meer hierheen te komen om water te putten.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jezus zei: “Ga je man roepen en kom dan samen terug.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","De vrouw antwoordde: “Ik heb geen man.” Jezus zei tegen haar: “Het klopt wat je zegt; je hebt geen man. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Je hebt namelijk vijf mannen gehad, en degene die je nu hebt is je man niet. Wat je hebt gezegd, is waar.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","De vrouw antwoordde: “Meneer, ik zie dat U een profeet bent. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Onze voorvaders hebben God aanbeden op deze berg, maar jullie zeggen dat Jeruzalem de plaats is waar men God behoort te aanbidden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jezus zei: “Geloof Mij, mevrouw, er komt een tijd dat jullie de Vader noch op deze berg noch in Jeruzalem zullen aanbidden. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jullie aanbidden God zonder Hem te kennen, wij kennen de God die wij aanbidden. De redding komt immers van het Joodse volk. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Er komt echter een tijd – en het is nu al zover – dat de ware aanbidders de Vader zullen aanbidden door de kracht van de Geest en in overeenstemming met de waarheid. De Vader wil door dat soort mensen worden aanbeden. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God is Geest en wie Hem aanbidt, moet Hem aanbidden door de kracht van de Geest en in overeenstemming met de waarheid.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","De vrouw zei: “Ik weet dat de Messias komt, Hij die Christus wordt genoemd. Wanneer Hij komt, zal Hij ons alles uitleggen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jezus zei: “Die persoon ben Ik, je spreekt met Hem.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Op dat moment kwamen zijn leerlingen terug. Ze waren verbaasd dat Jezus met een vrouw praatte. Maar niemand vroeg: “Waarom doet U dat?”, of: “Waarom praat U met haar?” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","De vrouw liet haar emmer achter, ging naar de stad, en zei tegen de mensen: ");
INSERT INTO nldgbv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kom kijken, er is Iemand die me alles heeft verteld wat ik heb gedaan. Zou Hij de Messias zijn?” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ze kwamen de stad uit, naar Jezus toe. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Intussen drongen Jezus' leerlingen bij Hem aan: “Rabbi, eet toch iets!” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Maar Hij zei: “Ik leef van voedsel dat jullie niet kennen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","De leerlingen vroegen elkaar: “Niemand heeft Hem toch eten gebracht?” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Maar Jezus zei tegen hen: “Mijn voedsel is dat Ik doe wat Hij wil, die Mij heeft gestuurd, en dat Ik het werk voltooi dat Hij Mij heeft gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zeggen jullie niet: Nog vier maanden en dan komt de oogst? Let op, Ik zeg tegen jullie: als je goed kijkt, zie je dat de velden wit zijn, klaar voor de oogst. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","De maaier ontvangt reeds loon; hij verzamelt een opbrengst voor het eeuwig leven. Zo komt het dat de zaaier zich samen met de maaier verheugt. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hier is het gezegde ‘De één zaait, de ander maait’ van toepassing. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ik heb jullie uitgezonden om een oogst binnen te halen waarvoor jullie niet hebben gewerkt. Anderen hebben gewerkt, en jullie oogsten de vruchten van hun werk.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Door de getuigenis van de vrouw die zei: “Hij heeft me alles verteld wat ik ooit heb gedaan”, kwamen veel Samaritanen uit die stad tot geloof in Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Daarom kwamen de Samaritanen Jezus vragen bij hen te blijven. Hij bleef er twee dagen, ");
INSERT INTO nldgbv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","en door hetgeen Hij vertelde kwamen nog meer mensen tot geloof. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Zij zeiden tegen de vrouw: “Wij geloven niet langer omwille van wat jij hebt gezegd; nu we zelf naar Hem hebben geluisterd, beseffen we dat Hij werkelijk de redder van de wereld is.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na die twee dagen vervolgde Jezus zijn reis naar Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jezus had zelf verklaard dat een profeet in zijn thuisstad geen erkenning krijgt. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Maar toen Hij in Galilea aankwam, verwelkomden de Galileeërs Hem. Ze waren namelijk bij het feest in Jeruzalem geweest en hadden gezien wat Hij tijdens het feest had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hij kwam opnieuw in Kana in Galilea, waar Hij het water in wijn had veranderd. Er was toen in Kapernaüm een koninklijk functionaris, van wie de zoon ernstig ziek was. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Toen hij hoorde dat Jezus vanuit Judea naar Galilea was gekomen, ging hij naar Hem toe en smeekte hij Hem om zijn zoon, die op sterven lag, te komen genezen. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jezus zei tegen hem: “Willen jullie dan niet geloven tenzij jullie tekenen en wonderen zien?” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Maar de koninklijk functionaris antwoordde: “Heer, kom alstublieft mee, voordat mijn kind sterft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jezus antwoordde: “Ga gerust naar huis, je zoon is gezond.” De man geloofde wat Jezus tegen hem had gezegd en vertrok. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hij was nog onderweg, toen zijn dienaren hem tegemoetkwamen met het bericht dat zijn kind gezond was. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hij vroeg wanneer het kind beter was geworden. Ze antwoordden: “Gisteren om één uur 's middags is de koorts verdwenen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","De vader besefte dat dit het tijdstip was waarop Jezus had gezegd: “Je zoon is gezond.” Hij kwam tot geloof, en ook iedereen die bij hem in huis woonde. ");
INSERT INTO nldgbv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dit was de tweede keer dat Jezus een wonderlijk teken verrichtte nadat Hij vanuit Judea naar Galilea was teruggekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Later reisde Jezus naar Jeruzalem voor een Joods feest. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu is er bij de Schaapspoort in Jeruzalem een badhuis met vijf zuilengalerijen; in het Aramees heet het Betzata. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Daar lagen veel mensen met ernstige aandoeningen: ze waren blind, verlamd of hadden een andere handicap. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Er was daar iemand die al 38 jaar aan zijn aandoening leed. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jezus zag hem liggen, wist dat hij al lange tijd aan die aandoening leed en vroeg hem: “Wil je gezond worden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","De man antwoordde: “Meneer, ik heb niemand om me het bad in te helpen wanneer het water in beweging komt. Telkens als ik ga, is een ander mij voor.” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jezus zei: “Sta op, neem je mat op en wandel.” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","De man werd meteen gezond; hij nam zijn mat op en wandelde rond. Dit gebeurde op een sabbat. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Daarom zeiden de Joodse leiders tegen de genezen man: “Het is sabbat, je mag je mat niet dragen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Maar hij antwoordde: “Hij die mij gezond gemaakt heeft, zei tegen mij: ‘Neem je draagmat op en wandel.’” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zij vroegen hem: “Wie is die Man die tegen je zei dat je je draagmat moest opnemen en moest wandelen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Maar de man die genezen was, wist niet wie het was, want Jezus had zich teruggetrokken in de menigte die zich daar bevond. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Later trof Jezus hem aan op het tempelterrein. Hij zei tegen hem: “Luister. Je bent nu genezen. Zorg dat je niet meer zondigt; anders zal je iets ergers overkomen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","De man vertrok en vertelde aan de Joodse leiders dat het Jezus was die hem gezond had gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Toen begonnen de Joodse leiders Jezus tegen te werken, omdat Hij dit op een sabbat had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maar Jezus zei tegen hen: “Mijn Vader is altijd al aan het werk; daarom werk Ik ook.” ");
INSERT INTO nldgbv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dit versterkte de Joodse leiders in hun bedoeling Jezus te doden, omdat Hij niet alleen de Joodse sabbatsregels had overtreden, maar ook God zijn Vader had genoemd en zichzelf dus aan God gelijkstelde. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jezus reageerde daarop: “Ik zeg jullie nadrukkelijk, de Zoon kan niets uit zichzelf doen, Hij kan enkel doen wat Hij de Vader ziet doen. Alles wat de Vader doet, doet de Zoon ook. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","De Vader houdt van de Zoon en toont Hem alles wat Hij doet. Hij zal Hem nog grotere daden tonen dan deze, en jullie zullen versteld staan. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Want zoals de Vader de doden doet verrijzen en hen doet leven, zo doet ook de Zoon leven wie Hij wil. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","De Vader oordeelt over niemand; Hij heeft het Oordeel volledig aan de Zoon toevertrouwd. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Daarom zullen alle mensen de Zoon eren zoals ze de Vader eren. Wie de Zoon niet eert, eert ook de Vader niet, die Hem heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ik zeg jullie nadrukkelijk, wie luistert naar hetgeen Ik zeg en gelooft in Degene die Mij heeft gestuurd, heeft het eeuwig leven en valt niet onder het Oordeel. Hij is overgegaan van de dood naar het leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ik zeg jullie nadrukkelijk, er komt een tijd – en het is nu al zover – dat de doden de stem van de Zoon van God zullen horen en zij die Hem horen, zullen leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","De Vader heeft de macht om leven te geven, en diezelfde macht om leven te geven heeft Hij aan de Zoon geschonken. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bovendien heeft Hij Hem de macht gegeven om het Oordeel te voltrekken, omdat Hij de aangekondigde Mensenzoon is. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Verbaas je hierover niet. Er komt namelijk een tijd dat alle doden zijn stem zullen horen. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Zij die het goede hebben gedaan, zullen verrijzen om het leven te ontvangen en zij die het verkeerde hebben gedaan, zullen verrijzen om het Oordeel te ondergaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ik kan niets doen uit Mijzelf; Ik oordeel op basis van wat Ik hoor, en mijn oordeel is rechtvaardig, omdat Ik niet gericht ben op mijn eigen wil, maar op de wil van Degene die Mij gestuurd heeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Als Ik van Mijzelf getuig, is mijn getuigenis niet rechtsgeldig. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Er is echter iemand anders die van Mij getuigt en Ik weet dat de getuigenis die hij van Mij geeft, betrouwbaar is. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jullie hebben mensen naar Johannes gestuurd en zijn getuigenis is waar. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ik heb het niet nodig dat mensen van Mij getuigen, maar Ik zeg dit opdat jullie worden gered. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes was de lamp die brandde en licht gaf, en jullie waren een tijdlang bereid om van zijn licht te genieten. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ik beschik over een getuigenis die zwaarder doorweegt dan die van Johannes. De daden die de Vader Mij te doen geeft, de daden die Ik doe, die getuigen van Mij dat de Vader Mij heeft gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","En verder getuigt de Vader die Mij heeft gestuurd van Mij, maar jullie hebben nog nooit zijn stem gehoord of zijn gezicht gezien. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Zijn getuigenis is jullie niet bijgebleven, omdat jullie niet geloven in Degene die Hij gezonden heeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jullie bestuderen de Schriften, omdat jullie denken dat zij het eeuwig leven bevatten, maar ook die getuigen van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","En toch willen jullie niet bij Mij komen om het leven te ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ik ben niet uit op goedkeuring van mensen, ");
INSERT INTO nldgbv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","maar Ik ken jullie: jullie hebben geen liefde voor God in je hart. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ik ben gekomen in de naam van mijn Vader en jullie aanvaarden Mij niet, maar als iemand anders op eigen gezag komt, aanvaarden jullie die persoon wel. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hoe kunnen jullie geloven als jullie graag goedkeuring van elkaar ontvangen in plaats van naar Gods goedkeuring te streven? ");
INSERT INTO nldgbv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Denk niet dat Ik jullie bij de Vader zal aanklagen. Het is Mozes, op wie jullie je hoop stellen, die jullie aanklaagt. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Als jullie Mozes zouden geloven, zouden jullie ook Mij geloven, want hetgeen hij schreef gaat over Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Maar als jullie niet geloven wat hij schreef, hoe zullen jullie dan geloven wat Ik zeg?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Later vertrok Jezus naar de overkant van het Meer van Galilea. (Dit wordt ook het Meer van Tiberias genoemd.) ");
INSERT INTO nldgbv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Een grote menigte volgde Hem, want de mensen hadden de wonderlijke tekenen gezien die Hij had verricht bij mensen met ernstige aandoeningen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Toen ging Jezus de berg op. Daar ging Hij zitten met zijn leerlingen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Het was bijna Pesach, het Joodse paasfeest. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jezus keek om zich heen en zag dat er een grote menigte naar Hem toekwam. Toen vroeg Hij aan Filippus: “Waar zullen we brood kopen, zodat deze mensen kunnen eten?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hij zei dit om Filippus op de proef te stellen, want Hij wist wat Hij van plan was. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippus antwoordde: “Zelfs tweehonderd denarie zou onvoldoende zijn om ervoor te zorgen dat iedereen wat eten zou krijgen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Een van zijn andere leerlingen – Andreas, de broer van Simon Petrus – zei tegen Hem: ");
INSERT INTO nldgbv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Er is hier een jongen die vijf gerstebroden en twee vissen heeft, maar wat hebben we daar aan voor zoveel mensen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jezus zei: “Zeg tegen de mensen dat ze moeten plaatsnemen.” Er was op die plaats veel gras en de mensen namen plaats. Het aantal mannen bedroeg ongeveer vijfduizend. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Toen nam Jezus de broden. Hij sprak het dankgebed uit en liet aan de mensen die hadden plaatsgenomen zoveel uitdelen als ze wilden. Hetzelfde deed hij met de vissen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Toen de mensen voldoende hadden gegeten, zei Jezus tegen zijn leerlingen: “Verzamel de overgebleven brokken, zodat er niets verloren gaat.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ze verzamelden de brokken van de vijf gerstebroden die waren overgelaten door de mensen die hadden gegeten. Ze vulden er twaalf manden mee. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bij het zien van het wonderlijke teken dat Jezus had verricht, zeiden de mensen: “Deze Man is werkelijk de profeet die naar de wereld zou komen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jezus merkte dat ze Hem onder dwang wilden meenemen om Hem tot koning uit te roepen. Daarom trok Hij zich weer terug, de berg op, om alleen te zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Toen het avond werd, gingen zijn leerlingen naar het meer. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ze stapten in een boot om het meer over te steken, naar Kafarnaüm. Het was al donker geworden en Jezus was nog niet naar hen toe gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Doordat er een harde wind stond, werd het meer woelig. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Toen ze ongeveer vijf of zes kilometer hadden geroeid, zagen ze Jezus over het meer wandelen. Hij kwam dicht bij de boot en ze werden bang. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Maar Hij zei tegen hen: “Ik ben het. Wees niet bang.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ze wilden Hem aan boord nemen, maar de boot kwam meteen op hun plaats van bestemming aan wal. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","De volgende dag kwam de menigte die aan de overkant van het meer was gebleven tot het besef dat er slechts één bootje was geweest en dat Jezus niet samen met zijn leerlingen in de boot was gestapt, maar dat zijn leerlingen zonder Hem waren vertrokken. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Dicht bij de plaats waar men het brood had gegeten nadat de Heer het dankgebed had uitgesproken, kwamen andere bootjes uit Tiberias aan. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Toen de mensen zagen dat Jezus er niet was en zijn leerlingen ook niet, stapten ze in die bootjes en voeren ze naar Kafarnaüm om naar Hem te zoeken. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Toen ze Jezus aan de overkant van het meer hadden gevonden, vroegen ze Hem: “Rabbi, wanneer bent U hier aangekomen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jezus antwoordde: “Ik zeg jullie nadrukkelijk, jullie zoeken Mij niet omdat jullie wonderlijke tekenen hebben gezien, maar omdat jullie je hebben volgegeten met de broden. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Zet je niet in voor voedsel dat bederft, maar voor het voedsel dat goed blijft tot in het eeuwig leven. De Mensenzoon zal het jullie geven, want God de Vader heeft zijn stempel van goedkeuring op Hem gedrukt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","De mensen vroegen Hem: “Hoe kunnen we ervoor zorgen dat we doen wat God wil dat we doen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jezus antwoordde: “Wat God wil dat jullie doen is: geloven in Degene die Hij heeft gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ze vroegen Jezus: “Welk wonderlijke teken gaat U verrichten, zodat wij het kunnen zien en U dan geloven? Wat gaat U doen? ");
INSERT INTO nldgbv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Onze voorouders aten het manna toen ze in de wildernis waren. Er staat immers in de Schriften: ‘Hij gaf hun brood uit de hemel te eten.’” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jezus antwoordde: “Ik zeg jullie nadrukkelijk, het was niet Mozes die jullie het brood uit de hemel gaf, maar mijn Vader. Hij geeft jullie het ware brood uit de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Want het brood van God is het brood dat uit de hemel neerdaalt en leven aan de wereld geeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ze zeiden tegen Hem: “Heer, geef ons voortdurend dat brood.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jezus zei tegen hen: “Ik ben het brood dat leven geeft. Wie bij Mij komt, zal nooit meer honger hebben, en wie in Mij gelooft, zal nooit meer dorst hebben. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Maar zoals Ik jullie al gezegd heb: jullie hebben Mij gezien en toch geloven jullie niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ieder die de Vader aan Mij toevertrouwt, zal bij Mij komen en wie bij Mij komt, zal niet door Mij worden weggestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ik ben namelijk niet uit de hemel neergedaald om te doen wat Ik zelf wil, maar om te doen wat Hij wil, die Mij gestuurd heeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","En wat Hij die Mij gestuurd heeft wil, is dat Ik geen van de mensen die Hij Mij heeft toevertrouwd, verloren laat gaan, maar dat Ik hen doe verrijzen op de Laatste Dag. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dit is wat mijn Vader wil: dat ieder die de Zoon ziet en in Hem gelooft, het eeuwig leven zal hebben en dat Ik hem op de Laatste Dag zal doen verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","De Joodse leiders begonnen over Jezus te mopperen, omdat Hij had gezegd: “Ik ben het brood dat uit de hemel is neergedaald.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ze zeiden: “Is dit niet Jezus de zoon van Jozef? Wij weten wie zijn vader en moeder zijn. Hoe kan Hij dan zeggen: ‘Ik ben uit de hemel neergedaald?’” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jezus zei tegen hen: “Mopper niet zo onder elkaar. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Niemand kan bij Mij komen tenzij de Vader, die Mij heeft gestuurd, hem naar Mij toe leidt. Dan zal Ik hem op de Laatste Dag doen verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","In de Profeten staat: ‘Zij zullen allen door God worden onderwezen.’ Ieder die naar de Vader luistert en van Hem heeft geleerd, komt bij Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Niemand heeft de Vader gezien; alleen Hij die door God is gestuurd heeft de Vader gezien. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ik zeg jullie nadrukkelijk, wie gelooft, heeft het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ik ben het brood dat leven geeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jullie voorouders aten manna toen ze in de wildernis waren, en ze zijn gestorven. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Maar dit is het brood dat uit de hemel is neergedaald; wie ervan eet, zal niet sterven. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ik ben het brood dat leven geeft en dat uit de hemel is neergedaald; als iemand van dit brood eet, zal hij voor eeuwig leven. Het brood dat Ik geef om de wereld te doen leven is mijn lichaam.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","De Joodse leiders begonnen met elkaar te ruziën. Ze zeiden: “Hoe kan Hij ons zijn lichaam te eten geven?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jezus zei tegen hen: “Ik zeg jullie nadrukkelijk, als jullie niet van het lichaam van de Mensenzoon eten en van zijn bloed drinken, kunnen jullie het eeuwig leven niet in je hebben. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wie van mijn lichaam eet en van mijn bloed drinkt, heeft het eeuwig leven, en op de Laatste Dag zal Ik hem doen verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Want mijn lichaam is het ware voedsel en mijn bloed de ware drank. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wie van mijn lichaam eet en van mijn bloed drinkt, hoort bij Mij en Ik bij hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Zoals Ik leef dankzij de Vader die het leven geeft, de Vader die Mij heeft gezonden, zo is het ook met wie van Mij eet: hij zal leven dankzij Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dit is het brood dat uit de hemel is neergedaald. Het is niet zoals het brood dat de voorouders aten. Zij zijn gestorven, maar wie van dit brood eet, zal voor eeuwig leven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dit is wat Hij zei in de synagoge in Kafarnaüm, toen Hij daar onderwees. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Veel van zijn leerlingen die hiernaar hadden geluisterd, zeiden: “Dit zijn harde woorden; wie kan ernaar luisteren?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jezus had door dat zijn leerlingen hierover aan het mopperen waren. Daarom vroeg Hij hen: “Ergeren jullie je hieraan? ");
INSERT INTO nldgbv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wat als jullie de Mensenzoon zien teruggaan naar waar Hij eerder was? ");
INSERT INTO nldgbv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Het is de Geest die leven geeft; menselijke inspanningen baten niet. Wat Ik jullie heb verteld, is van de Geest en geeft leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Maar sommigen van jullie geloven niet.” Jezus wist namelijk vanaf het begin wie er niet geloofden en wie het was die Hem zou verraden. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hij zei: “Daarom had Ik tegen jullie gezegd dat niemand bij Mij kan komen tenzij de Vader hem ertoe in staat stelt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Vanaf toen keerden veel van zijn leerlingen zich van Hem af; ze wilden niet meer met Hem omgaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jezus vroeg aan de Twaalf: “Willen ook jullie niet weggaan?” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus antwoordde: “Heer, naar wie zouden we toe gaan? De woorden die U spreekt, bieden het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wij geloven en beseffen dat U de door God gestuurde Heilige bent.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jezus zei tegen Petrus: “Ik heb jullie zelf gekozen, alle twaalf, maar één van jullie is een duivel.” ");
INSERT INTO nldgbv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hij bedoelde Judas, de zoon van Simon Iskariot. Hij was een van de Twaalf en hij was het die Jezus zou verraden. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Later reisde Jezus rond in Galilea. Hij wilde niet in Judea rondreizen, want de Joodse leiders waren van plan Hem te doden. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Binnenkort zou het Joodse Loofhuttenfeest plaatsvinden. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Daarom zeiden Jezus' broers tegen Hem: “Vertrek toch; ga naar Judea. Dan kunnen je leerlingen de bijzondere dingen zien die Jij doet. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Immers, niemand die bekend wil zijn, gaat in het geheim te werk. Als Jij al die bijzondere dingen doet, maak Jezelf dan aan de wereld bekend!” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zelfs zijn broers geloofden namelijk niet in Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jezus antwoordde: “Mijn moment is nog niet gekomen, maar voor jullie is elk tijdstip goed. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","De wereld kan jullie niet haten, maar ze haat Mij, omdat Ik verklaar dat de dingen die zij doet, slecht zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gaan jullie maar naar het feest. Ik ga niet naar dit feest omdat mijn moment nog niet is gekomen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nadat Hij dit tegen hen had gezegd, bleef Hij in Galilea. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Maar toen zijn broers naar het feest waren vertrokken, ging Hij zelf ook – onopvallend en in het geheim. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tijdens het feest zochten de Joodse leiders naar Jezus. Ze vroegen: “Waar is Hij?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Onder de mensen werd veel over Hem gefluisterd. Sommigen zeiden: “Hij is een goed mens”. Anderen zeiden: “Welnee, Hij misleidt het volk.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Maar uit angst voor de Joodse leiders sprak niemand openlijk over Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Halverwege het feest ging Jezus naar het tempelterrein; daar onderwees Hij. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","De Joodse leiders verbaasden zich. Ze vroegen: “Hoe weet die Man dat allemaal? Hij heeft geen onderwijs genoten.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jezus reageerde: “Mijn onderwijs komt niet van Mijzelf, maar van Degene die Mij heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Als iemand ernaar verlangt, te doen wat God wil, zal hij weten of mijn onderwijs van God komt, of dat Ik spreek namens Mijzelf. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wie namens zichzelf spreekt, is uit op eer voor zichzelf, maar wie wil dat degene die hem heeft gestuurd de eer krijgt, is oprecht en heeft geen kwaad in de zin. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Heeft Mozes jullie niet de Wet gegeven? Maar niemand van jullie houdt zich aan de Wet. Waarom willen jullie Mij doden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","De menigte antwoordde: “U heeft een demon in U. Wie probeert U te doden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jezus antwoordde: “Ik heb één bijzondere daad verricht en jullie verbazen je allemaal. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mozes heeft jullie de besnijdenis gegeven – niet dat de besnijdenis van Mozes komt; ze komt van de aartsvaders – en daarom besnijden jullie jongetjes ook op de sabbat. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Maar als iemand op de sabbat wordt besneden om te vermijden dat de Wet van Mozes wordt overtreden, waarom zijn jullie dan boos dat Ik iemand gezond heb gemaakt op de sabbat? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Stop met oordelen op basis van uiterlijkheden, en oordeel op basis van wat rechtvaardig is.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sommige inwoners van Jeruzalem vroegen: “Is dit niet de Man die ze willen doden? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Maar kijk, Hij spreekt in het openbaar en ze zeggen er niets van. Zouden de autoriteiten misschien beseffen dat Hij de Messias is? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Van deze Man weten we echter waar Hij vandaan komt, terwijl niemand weet waar de Messias vandaan komt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Toen Jezus op het tempelterrein aan het onderwijzen was, riep Hij uit: “Jullie weten wie Ik ben en waar Ik vandaan kom. Maar Ik ben niet namens Mijzelf gekomen. Hij die Mij gestuurd heeft, is de waarheid en jullie kennen Hem niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ik ken Hem, omdat Ik bij Hem vandaan kom; Hij heeft Mij gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Toen probeerden ze Hem te arresteren, maar niemand slaagde erin Hem te grijpen, want zijn moment was nog niet gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Toch geloofden veel mensen in Hem. Zij zeiden: “Wanneer de Messias komt, zal Hij toch niet meer wonderlijke tekenen verrichten dan deze Man?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","De farizeeën hoorden dat de mensen dit over Jezus fluisterden en de hoofdpriesters en farizeeën stuurden tempelwachters om Hem te arresteren. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Toen zei Jezus: “Ik zal nog even bij jullie zijn; dan ga Ik terug naar Degene die Mij heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jullie zullen Mij zoeken zonder Mij te vinden en waar Ik dan zal zijn, kunnen jullie niet komen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","De Joodse mensen zeiden tegen elkaar: “Waar zou Hij naartoe gaan, dat wij Hem niet zullen vinden? Hij zal toch niet naar de Joodse diaspora in het buitenland gaan, om de Grieken te onderwijzen? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wat bedoelde Hij toen Hij zei: ‘Jullie zullen Mij zoeken zonder Mij te vinden en waar Ik dan zal zijn, kunnen jullie niet komen’?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Op de laatste en belangrijkste dag van het feest ging Jezus voor de menigte staan en riep Hij uit: “Als iemand dorst heeft, laat hij dan bij Mij komen en drinken. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Zoals in de Schriften staat over wie in Mij gelooft: uit zijn binnenste zullen rivieren stromen van water dat leven geeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hij zei dit over de Geest, die de mensen die in Jezus geloofden, zouden ontvangen. De Geest was er echter nog niet, want Jezus was nog niet naar Gods glorie teruggekeerd. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Toen sommige mensen deze woorden hoorden, zeiden ze: “Deze Man is werkelijk de profeet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Anderen zeiden: “Hij is de Messias.” Nog anderen zeiden: “De Messias komt toch niet uit Galilea? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Zeggen de Schriften niet dat de Messias een van de afstammelingen van David zal zijn en uit Betlehem, de woonplaats van David, zal komen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zo ontstond er verdeeldheid onder de mensen over Wie Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sommigen probeerden Jezus te arresteren, maar niemand slaagde erin Hem te grijpen. ");
INSERT INTO nldgbv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Toen gingen de tempelwachters terug naar de hoofdpriesters en farizeeën. Die vroegen hen: “Waarom hebben jullie Hem niet meegebracht?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","De tempelwachters antwoordden: “Er heeft nog nooit iemand gesproken zoals Hij.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","De farizeeën reageerden: “Heeft Hij jullie misschien ook misleid? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Geen van de leiders en geen van de farizeeën gelooft toch in Hem? ");
INSERT INTO nldgbv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Maar deze massa heeft geen besef van de Wet en zij is vervloekt!” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, die eerder bij Jezus was geweest en die een van de farizeeën was, vroeg hen: ");
INSERT INTO nldgbv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Volgens onze wetten mag een mens toch niet worden veroordeeld zonder dat hij eerst wordt verhoord en zonder dat wordt onderzocht wat hij heeft gedaan?” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ze antwoordden: “Kom jij soms ook uit Galilea? Ga het maar na, dan zal je ontdekken dat uit Galilea geen profeet kan komen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Toen ging iedereen naar huis. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jezus vertrok naar de Olijfberg. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Toen Hij de volgende ochtend naar het tempelterrein terugkeerde, kwam heel het volk naar Hem toe. Hij ging zitten en onderwees hen. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Toen brachten de Schriftgeleerden en de farizeeën een vrouw naar Hem toe, die op overspel betrapt was. Ze zetten haar in het midden, ");
INSERT INTO nldgbv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","en zeiden tegen Jezus: “Leraar, deze vrouw is op heterdaad op overspel betrapt. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mozes heeft ons in de Wet bevolen dat zo'n vrouw gestenigd moet worden. Wat vindt U?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ze zeiden dit om Hem op de proef te stellen, om iets te hebben waarvan ze Hem zouden kunnen beschuldigen. Maar Jezus boog zich voorover en schreef met zijn vinger op de grond. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Toen ze bleven doorvragen, ging Hij rechtop zitten en zei Hij tegen hen: “Wie van jullie heeft nog nooit gezondigd? Laat die persoon de eerste steen naar haar gooien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hij boog zich opnieuw voorover en schreef op de grond. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Toen ze dat hoorden, vertrokken ze een voor een, te beginnen met de oudsten. Jezus bleef alleen achter met de vrouw die in het midden had gestaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jezus ging weer rechtop zitten en vroeg haar: “Waar zijn ze? Heeft niemand je veroordeeld?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ze zei: “Niemand, meneer.” Jezus zei: “Ik veroordeel je ook niet. Je mag gaan. Zorg dat je voortaan niet meer zondigt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Opnieuw sprak Jezus de mensen toe. Hij zei: “Ik ben het licht voor de wereld. Wie Mij volgt, leeft niet meer in het duister, maar heeft het licht dat leven geeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","De farizeeën zeiden tegen Hem: “U getuigt van Uzelf; uw getuigenis is dus niet rechtsgeldig.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jezus antwoordde: “Al getuig Ik van Mezelf, mijn getuigenis is rechtsgeldig, omdat Ik weet waar Ik vandaan kom en waar Ik naartoe ga. Jullie daarentegen weten niet waar Ik vandaan kom of waar Ik naartoe ga. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jullie oordelen aan de hand van menselijke maatstaven; Ik oordeel niemand. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Maar zelfs als Ik oordeel, dan is mijn oordeel rechtsgeldig, want Ik ben niet alleen. Ik ben samen met de Vader, die Mij heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Zelfs in jullie Wet staat dat de getuigenis van twee personen rechtsgeldig is. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Van Mij getuigen Ikzelf en de Vader die Mij gestuurd heeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ze vroegen Hem: “Waar is uw vader dan?” Jezus antwoordde: “Jullie kennen noch Mij, noch mijn Vader. Als jullie Mij zouden kennen, zouden jullie ook mijn Vader kennen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dit is wat Jezus zei toen Hij onderwees in de buurt van de offerkist op het tempelterrein. En niemand arresteerde Hem, want zijn moment was nog niet gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Opnieuw sprak Jezus de mensen toe. “Ik ga weg, jullie zullen Mij zoeken en jullie zullen sterven in je zondige staat. Waar Ik naartoe ga, kunnen jullie niet komen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","De Joodse leiders zeiden: “Hij zegt: ‘Waar Ik naartoe ga, kunnen jullie niet komen.’ Hij gaat toch geen zelfmoord plegen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hij zei tegen hen: “Jullie zijn van beneden, Ik ben van boven. Jullie zijn van deze wereld, Ik ben niet van deze wereld. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ik heb tegen jullie gezegd dat jullie zullen sterven in je zondige staat. Als jullie niet geloven dat Ik ben wie Ik ben, zullen jullie sterven in je zondige staat.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ze vroegen Hem: “Wie bent U dan?” Jezus zei tegen hen: “Wat Ik jullie van in het begin heb gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Er is veel dat Ik over jullie kan zeggen om jullie te veroordelen, maar Hij die Mij heeft gestuurd, spreekt de waarheid en wat Ik de wereld vertel, heb Ik van Hem gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ze beseften niet dat Hij hun over de Vader vertelde. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jezus zei tegen hen: “Wanneer jullie de Mensenzoon omhoogheffen, zullen jullie weten dat Ik ben wie Ik ben en dat Ik niets namens Mijzelf doe, maar dat Ik zeg wat de Vader Mij heeft geleerd. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hij die Mij heeft gestuurd, is bij Mij. Hij heeft Mij niet in de steek gelaten, want Ik doe altijd wat Hem bevalt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Toen Hij dit zei, kwamen velen tot geloof in Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jezus zei tegen de Joodse mensen die in Hem geloofden: “Als jullie je houden aan hetgeen Ik zeg, zijn jullie werkelijk leerlingen van Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dan zullen jullie de waarheid kennen en de waarheid zal jullie bevrijden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ze antwoordden: “Wij zijn afstammelingen van Abraham en wij zijn nooit iemands slaaf geweest. Hoe kan U dan zeggen dat we bevrijd zullen worden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jezus antwoordde: “Ik zeg jullie nadrukkelijk, ieder die zondigt, is slaaf van de zonde. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Een slaaf blijft niet altijd bij de familie, maar de zoon blijft voor altijd. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Als de Zoon jullie bevrijdt, zullen jullie werkelijk vrij zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ik weet dat jullie Abrahams afstammelingen zijn. Maar toch zoeken jullie naar een mogelijkheid om Mij te doden, omdat jullie in je hart geen ruimte hebben voor hetgeen Ik zeg. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ik vertel hetgeen Ik bij de Vader heb gezien, terwijl jullie doen wat jullie van jullie vader hebben gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ze antwoordden: “Onze vader is Abraham.” Jezus zei tegen hen: “Als jullie kinderen van Abraham zouden zijn, zouden jullie de dingen doen die Abraham deed. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Maar in plaats daarvan proberen jullie Mij te doden – Mij, een mens die jullie de waarheid vertelt die Hij van God heeft gehoord – en Abraham heeft zoiets niet gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jullie doen wat jullie vader doet.” Ze antwoordden: “Wij zijn geen onwettige kinderen, wij hebben één Vader: God.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jezus zei tegen hen: “Als God jullie Vader zou zijn, dan zouden jullie liefdevol met Mij omgaan, want Ik kom van God. Ik ben niet namens Mijzelf gekomen; Hij heeft Mij gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Waarom begrijpen jullie niet wat Ik zeg? Omdat jullie het niet kunnen verdragen om mijn woorden te horen. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jullie vader is de duivel en jullie doen graag wat hij verlangt. Hij was een moordenaar vanaf het begin en hij houdt zich niet aan de waarheid, omdat er in hem geen waarheid is. Wanneer hij liegt, spreekt hij uit zichzelf. Hij is een leugenaar, de vader van de leugen. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Maar omdat Ik de waarheid spreek, geloven jullie Mij niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wie van jullie kan Mij terechtwijzen voor een zonde die Ik gedaan zou hebben? Als Ik de waarheid spreek, waarom geloven jullie Mij dan niet? ");
INSERT INTO nldgbv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hij die God als Vader heeft, luistert naar Gods woorden. De reden waarom jullie niet luisteren, is dat God niet jullie Vader is.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","De Joodse leiders antwoordden: “Het is terecht dat wij zeggen dat U een Samaritaan bent en een demon in U heeft.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jezus antwoordde: “Ik heb geen demon in Me, Ik eer mijn Vader en jullie eren Mij niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ik wil geen eer voor Mijzelf – er is er Eén die dat voor Mij wil, en Hij is het die beslist. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ik zeg jullie nadrukkelijk, wie zich houdt aan hetgeen Ik zeg, zal nooit de dood ervaren.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","De Joodse leiders zeiden tegen Hem: “Nu weten wij zeker dat U een demon in U heeft. Abraham is dood, en de profeten ook, maar U zegt dat wie zich houdt aan hetgeen U zegt, nooit de dood zal ervaren. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","U bent toch niet beter dan onze voorvader Abraham? Hij is dood, en de profeten ook. Wie denkt U wel dat U bent?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jezus antwoordde: “Als Ik Mijzelf eer geef, is die eer niets waard. Maar het is de Vader die Mij eer geeft en jullie zeggen dat Hij jullie God is. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","En toch kennen jullie Hem niet. Maar Ik ken Hem wel. Als Ik zou zeggen dat Ik Hem niet ken, zou Ik een leugenaar zijn, net als jullie. Maar Ik ken Hem wel en Ik houd Mij aan hetgeen Hij zegt. ");
INSERT INTO nldgbv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jullie voorvader Abraham verheugde zich op mijn komst en was blij toen hij die zag.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","De Joodse leiders zeiden tegen Hem: “U bent nog geen vijftig jaar oud en U zegt dat U Abraham heeft gezien?” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jezus zei tegen hen: “Ik zeg jullie nadrukkelijk, Ik ben er al van voordat Abraham geboren werd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Toen raapten ze stenen op om Jezus daarmee te bekogelen. Maar Hij onttrok zich aan hun zicht en verliet het tempelterrein. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","In het voorbijgaan zag Jezus iemand die reeds vanaf zijn geboorte blind was. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Zijn leerlingen vroegen Hem: “Rabbi, die man is blind geboren. Wie heeft daar schuld aan, hij of zijn ouders?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jezus antwoordde: “Het is niet zijn schuld, noch die van zijn ouders; hij is blind geboren opdat de mensen Gods daden zouden zien. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","En die daden, waarvoor Hij Mij heeft gestuurd, moeten Wij doen zolang het nog licht is. Straks wordt het nacht en dan kan niemand iets doen. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Zolang Ik in de wereld ben, ben Ik het licht voor de wereld.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Na dat te hebben gezegd, spuwde Hij op de grond. Met het speeksel maakte Hij slijk, en Hij streek dat slijk op de ogen van de man. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Toen zei Hij tegen hem: “Ga je wassen in het Badhuis van Siloam.” (Siloam betekent: gezonden.) De man vertrok, waste zich en toen hij terugkwam kon hij zien. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","De buren en de mensen die hem vroeger altijd hadden zien bedelen, vroegen: “Is dat niet die man die altijd zat te bedelen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sommigen zeiden: “Dat is hem.” Anderen zeiden: “Nee, maar hij lijkt op hem.” Hijzelf zei: “Ik ben het.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ze vroegen hem: “Hoe kan het dat je nu kan zien?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hij antwoordde: “Iemand die Jezus heet maakte slijk, streek dat op mijn ogen, en zei: ‘Ga naar Siloam om je te wassen.’ Dus ging ik daarheen, waste me, en toen kon ik zien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ze vroegen hem: “Waar is die Man?” Hij antwoordde: “Ik weet het niet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Toen werd de man die blind was geweest, bij de farizeeën gebracht. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","De dag waarop Jezus slijk had gemaakt en zijn ogen had genezen, was een sabbat. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ook de farizeeën vroegen hem hoe het kwam dat hij nu kon zien. Hij antwoordde: “Die man streek slijk op mijn ogen. Toen heb ik me gewassen en nu kan ik zien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sommige van de farizeeën zeiden: “Die Man komt niet van God, want Hij houdt zich niet aan de sabbat.” Anderen zeiden: “Hoe zou een zondig mens zulke wonderlijke tekenen kunnen verrichten?” Er ontstond verdeeldheid onder hen. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ze vroegen verder aan de man die blind was geweest: “Wat zeg jij van Hem? Want jij bent het die door zijn toedoen kan zien.” De man zei: “Hij is een profeet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","De Joodse leiders weigerden te geloven dat de man blind was geweest en nu kon zien. Daarom lieten ze zijn ouders ophalen ");
INSERT INTO nldgbv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","en vroegen hun: “Is dit jullie zoon? Kunnen jullie bevestigen dat hij blind geboren is? Hoe komt het dat hij nu kan zien?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","De ouders antwoordden: “Wij weten dat dit onze zoon is en dat hij blind is geboren. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Maar hoe het komt dat hij nu kan zien, of wie hem heeft genezen, dat weten we niet. Vraag het hem zelf maar. Hij is oud genoeg om voor zichzelf te spreken.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Zijn ouders zeiden dit omdat ze bang waren voor de Joodse leiders. De Joodse leiders waren namelijk overeengekomen dat wie zou belijden dat Jezus de Messias was, uit de synagoge zou worden verbannen. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Het was daarom dat zijn ouders zeiden: “Hij is oud genoeg. Vraag het hem zelf maar.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ze riepen de man die blind was geweest terug en zeiden tegen hem: “Geef God de eer. We weten toch dat die Man een zondaar is?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hij antwoordde: “Of Hij een zondaar is, weet ik niet. Maar één ding weet ik wel: ik was blind, en nu kan ik zien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ze vroegen hem: “Wat heeft Hij met je gedaan? Hoe heeft Hij ervoor gezorgd dat je nu kan zien?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hij antwoordde: “Dat heb ik u al gezegd en u weigerde te luisteren. Waarom wilt u het opnieuw horen? Of wilt u ook leerlingen van Hem worden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ze verwensten hem en zeiden: “Jij bent zijn leerling, maar wij zijn leerlingen van Mozes. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Van Mozes weten we dat God tot hem sprak, maar van deze Man weten we zelfs niet waar Hij vandaan komt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","De man antwoordde: “Is dat niet raar? Jullie weten niet waar Hij vandaan komt en toch heeft Hij gezorgd dat ik nu kan zien. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","We weten dat God niet luistert naar zondaars, maar wel naar wie Hem vereert en doet wat Hij wil. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Het is nog nooit vertoond dat een blind geboren persoon is genezen. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Als die Man niet van God zou komen, dan zou Hij toch niets kunnen doen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ze antwoordden: “Jij bent altijd al een zondaar geweest, vanaf je geboorte, en jij wil ons de les lezen?” Toen joegen ze hem weg. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jezus hoorde dat de man was weggejaagd, zocht hem op en vroeg: “Geloof je in de Mensenzoon?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","De man antwoordde: “Wie is Hij, meneer? Als ik dat weet, zal ik in Hem geloven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jezus zei tegen hem: “Je hebt Hem gezien en je spreekt met Hem.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","De man zei: “Ik geloof, Heer”, en knielde voor Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Toen zei Jezus: “Ik ben naar deze wereld gekomen om scheiding te brengen: zij die blind zijn, zullen zien en zij die denken te zien, zullen ontdekken dat ze blind zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Enkele farizeeën die erbij stonden, hoorden wat Hij zei en vroegen Hem: “Zijn wij dan ook blind?” ");
INSERT INTO nldgbv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jezus antwoordde: “Als jullie blind zouden zijn, zou jullie geen schuld treffen. Maar omdat jullie beweren dat jullie kunnen zien, blijft jullie schuld bestaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ik zeg jullie nadrukkelijk, wie de schaapskooi niet binnengaat door de deur, maar op een andere plaats naar binnen klimt, is een dief, een rover. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wie echter door de deur naar binnen gaat, is de herder van de schapen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Voor hem doet de bewaker open en de schapen luisteren naar zijn stem. Hij roept zijn schapen bij hun naam en leidt hen naar buiten. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","En wanneer hij al zijn schapen naar buiten heeft geleid, gaat hij voor hen uit. De schapen volgen hem omdat ze zijn stem kennen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Een vreemde zullen ze zeker niet volgen. Integendeel, ze zullen van hem weglopen, omdat ze de stem van vreemden niet kennen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jezus vertelde hun deze parabel, maar ze begrepen niet wat Hij bedoelde. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jezus vervolgde: “Ik zeg jullie nadrukkelijk, Ik ben de deur voor de schapen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Allen die vóór Mij kwamen, waren dieven en rovers, maar naar hen hebben de schapen niet geluisterd. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ik ben de deur. Als iemand door Mij naar binnen gaat, zal hij gered zijn. Hij zal vrij naar binnen en buiten kunnen gaan en hij zal weidegrond vinden. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","De dief komt enkel om te stelen, te slachten en te vernietigen; Ik ben gekomen opdat zij het leven zullen hebben en het hun aan niets zal ontbreken. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ik ben de goede herder. De goede herder is bereid om voor de schapen zijn leven te geven. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Een loonarbeider is niet de herder en niet de eigenaar van de schapen. Hij ziet de wolf komen, laat de schapen in de steek en slaat op de vlucht. Dan valt de wolf de schapen aan en jaagt hij hen uiteen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dat gebeurt omdat de loonarbeider niet om de schapen geeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ik ben de goede herder. Ik ken mijn schapen en mijn schapen kennen Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Precies zo kent de Vader Mij en ken Ik de Vader. Ik geef mijn leven voor de schapen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ik heb ook andere schapen, die niet bij deze kudde horen. Ook hen moet Ik leiden en ook zij zullen naar mijn stem luisteren. Ze zullen samen één kudde vormen, met één herder. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","De Vader heeft Mij lief omdat Ik mijn leven geef om het later terug te nemen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Niemand ontneemt Mij het leven; Ik doe er vrijwillig afstand van en Ik heb de bevoegdheid om het terug te nemen. Dat is de opdracht die Ik van mijn Vader heb gekregen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Omwille van deze woorden raakten de Joodse leiders opnieuw onderling verdeeld. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Velen van hen zeiden: “Hij heeft een demon in Zich, Hij is gek. Waarom luisteren jullie naar Hem?” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Maar anderen zeiden: “Die woorden komen niet van iemand die bezeten is door een demon; een demon kan geen blindheid genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Toen werd in Jeruzalem Chanoeka gevierd; het was winter. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jezus wandelde over het tempelterrein, door de Zuilengalerij van Salomo. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","De Joodse leiders kwamen om Hem heen staan en vroegen Hem: “Hoelang houdt U ons nog in het ongewisse? Als U de Messias bent, zeg het dan duidelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jezus antwoordde: “Ik heb het jullie al gezegd en jullie geloven het niet. De daden die Ik doe in de naam van mijn Vader, tonen aan wie Ik ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Maar jullie geloven het niet omdat jullie niet bij mijn schapen horen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mijn schapen luisteren naar Mij. Ik ken hen en zij volgen Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ik geef hun het eeuwig leven; zij zullen nooit verloren gaan en niemand zal hen uit mijn handen roven. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wat mijn Vader Mij heeft toevertrouwd, gaat alles te boven en niemand kan hen uit de handen van de Vader roven. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","De Vader en Ik vormen een eenheid.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","De Joodse leiders raapten opnieuw stenen op om Hem te stenigen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Daarom zei Jezus tegen hen: “Ik heb in opdracht van de Vader veel goede dingen gedaan en jullie hebben ze gezien; voor welke daad willen jullie Mij stenigen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","De Joodse leiders antwoordden: “We willen U niet stenigen voor een goede daad, maar voor godslastering. U beweert dat U God bent, maar U bent slechts een mens.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jezus antwoordde: “Er staat toch in jullie Wet: ‘Ik zei: jullie zijn goden’? ");
INSERT INTO nldgbv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","De Schriften verliezen nooit hun zeggingskracht. Als mensen tot wie God spreekt goden worden genoemd, ");
INSERT INTO nldgbv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","waarom word Ik, die door de Vader ben aangesteld en naar de wereld gezonden, dan door jullie van godslastering beschuldigd omdat Ik zeg dat Ik de Zoon van God ben? ");
INSERT INTO nldgbv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Als de dingen die Ik doe, niet afkomstig zijn van mijn Vader, geloof Mij dan niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Maar als de dingen die Ik doe wel van Hem komen, geloof die dan, zelfs als je Mij niet gelooft. Dan zullen jullie weten en beseffen dat de Vader en Ik een volkomen eenheid vormen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ze probeerden nogmaals Hem te arresteren, maar Hij wist aan hen te ontkomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hij vertrok opnieuw naar de overkant van de Jordaan, naar de plaats waar Johannes voorheen had gedoopt, en verbleef daar. ");
INSERT INTO nldgbv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Veel mensen kwamen naar Hem toe. Ze zeiden: “Johannes verrichtte weliswaar geen wonderlijke tekenen, maar alles wat hij over deze Man heeft gezegd, is waar.” ");
INSERT INTO nldgbv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Veel mensen kwamen daar tot geloof in Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Er was iemand ziek: Lazarus van Betanië, de woonplaats van Maria en haar zuster Marta. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Dit was de Maria die de Heer met nardusolie zou zalven en die zijn voeten met haar haren zou drogen. Het was haar broer Lazarus die ziek was. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De zussen stuurden iemand naar Jezus toe om te zeggen: “Heer, uw goede vriend is ziek.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Toen Jezus dat hoorde, zei Hij: “Deze ziekte zal niet eindigen in de dood, maar in eer voor God: hierdoor zal de grootheid van de Zoon van God zichtbaar worden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jezus was goed bevriend met Marta en haar zus, en met Lazarus. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nadat Hij had gehoord dat Lazarus ziek was, bleef Hij nog twee dagen waar Hij was. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Daarna zei Hij tegen zijn leerlingen: “Laten we weer naar Judea gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","De leerlingen zeiden tegen Hem: “Rabbi, de mensen in Judea hebben onlangs nog geprobeerd U te stenigen, en U wilt weer daarnaartoe?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jezus antwoordde: “Duurt de dag geen twaalf uur? Wie overdag wandelt, struikelt niet, omdat hij ziet door het daglicht. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Maar wie 's nachts wandelt, struikelt omdat hij niet over licht beschikt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nadat Hij dat gezegd had, zei Hij tegen hen: “Onze vriend Lazarus is ingeslapen, maar Ik ga hem wakker maken.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","De leerlingen zeiden tegen Hem: “Heer, als hij is ingeslapen, zal hij genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jezus bedoelde dat Lazarus dood was, maar zij dachten dat Hij het had over de gewone slaap. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Toen zei Jezus onomwonden tegen hen: “Lazarus is dood. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Maar Ik ben blij voor jullie dat Ik er niet bij was, want nu kunnen jullie leren geloven. Laten we naar hem toe gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, die ook Didymus wordt genoemd, zei tegen de andere leerlingen: “Laten wij ook maar gaan, dan kunnen we met Hem sterven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Toen Jezus aankwam, ontdekte Hij dat Lazarus al vier dagen in het graf lag. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanië ligt dicht bij Jeruzalem, op ongeveer drie kilometer afstand. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Er waren veel Joodse mensen naar Marta en Maria toe gekomen om hen te troosten na het overlijden van hun broer. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Toen Marta hoorde dat Jezus eraan kwam, ging ze Hem tegemoet. Maria bleef thuis. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta zei tegen Jezus: “Heer, als U hier was geweest, zou mijn broer niet zijn gestorven. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Maar zelfs nu weet ik dat God U alles zal geven wat U van Hem vraagt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jezus antwoordde: “Je broer zal verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta zei: “Ik weet dat hij zal verrijzen, bij de verrijzenis op de Laatste Dag.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jezus antwoordde: “Ik ben de verrijzenis en het leven; wie in Mij gelooft zal leven, ook als hij sterft. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","En ieder die leeft en in Mij gelooft, zal nooit sterven. Geloof je dat?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ze zei: “Ja, Heer, ik geloof dat U de Messias bent, de Zoon van God die naar de wereld zou komen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nadat ze dat had gezegd, ging ze terug om haar zus Maria te halen. Ze vertelde haar onder vier ogen: “De Leraar is hier en Hij wil je spreken.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Toen Maria dat hoorde, stond ze snel op om Jezus tegemoet te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jezus was hun woonplaats nog niet binnengekomen, maar Hij bevond zich nog op de plaats waar Marta Hem had ontmoet. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","De Joodse mensen die bij haar thuis waren om haar te troosten, zagen dat Maria snel opstond en naar buiten ging. Daarom volgden ze haar, in de veronderstelling dat ze naar het graf ging om daar te wenen. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Toen Maria op de plaats kwam waar Jezus was en Hem zag, viel ze aan zijn voeten neer en zei: “Heer, als U hier was geweest, zou mijn broer niet zijn gestorven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Toen Jezus zag hoe ze weende en hoe ook de Joodse mensen die met haar waren meegekomen aan het wenen waren, raakte Hij zwaar misnoegd en ontsteld. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hij vroeg: “Waar hebben jullie Hem neergelegd?” Ze zeiden tegen Hem: “Kom maar kijken, Heer.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Toen begon Jezus te wenen. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","De Joodse mensen zeiden: “Kijk eens hoe goed Hij met hem bevriend was!” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Maar sommigen van hen zeiden: “Die Man heeft een blinde genezen; had Hij niet kunnen voorkomen dat Lazarus stierf?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Toen Jezus bij het graf kwam – een grot die met een steen was afgesloten – raakte Hij opnieuw zwaar misnoegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jezus zei: “Neem die steen weg.” Marta, de zus van de overledene, zei: “Maar Heer, de stank! Het is al de vierde dag dat hij er ligt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jezus zei: “Heb Ik je niet verteld dat je Gods grootheid zal zien als je gelooft?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Toen namen ze de steen weg. Jezus keek omhoog en zei: “Vader, Ik dank U dat U mijn gebed heeft verhoord. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ik weet dat U mijn gebed altijd verhoort, maar Ik zeg dit omwille van de mensen die hier staan, opdat ze zullen geloven dat U Mij heeft gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nadat Jezus dit had gezegd, riep Hij luid: “Lazarus, kom naar buiten!” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","De dode kwam naar buiten; zijn handen en voeten waren nog in lijkdoeken gewikkeld en zijn gezicht met een doek omwonden. Jezus zei: “Maak hem uit de doeken los en laat hem gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Veel van de Joodse mensen die met Maria waren meegekomen en hadden gezien wat Jezus had gedaan, kwamen tot geloof in Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Maar anderen gingen naar de farizeeën en vertelden hun wat Jezus had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Daarom riepen de hoofdpriesters en de farizeeën de Joodse Raad bijeen. Ze vroegen: “Wat zullen we doen nu deze Man zoveel wonderlijke tekenen verricht? ");
INSERT INTO nldgbv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Als we Hem zo laten voortdoen, zal iedereen in Hem geloven. En dan zullen de Romeinen ingrijpen door ons heiligdom en ons volk van ons af te nemen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maar één van hen – Kajafas; hij was dat jaar hogepriester – zei tegen hen: “Jullie begrijpen het echt niet! ");
INSERT INTO nldgbv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Beseffen jullie niet dat het beter is dat één mens sterft voor het volk dan dat de hele natie te gronde gaat?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Deze woorden kwamen niet van hemzelf, maar als de hogepriester van dat jaar profeteerde hij dat Jezus voor het Joodse volk zou sterven. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","En niet alleen voor het Joodse volk, maar ook om Gods kinderen die verspreid over de wereld wonen, tot één volk samen te voegen. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Vanaf die dag maakten de Joodse leiders plannen om Hem te doden. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Daarom begaf Jezus zich niet langer in het openbaar onder de Joodse mensen. Hij vertrok daarvandaan naar de rand van de wildernis, naar een stadje dat Efraïm heette. Daar verbleef Hij met zijn leerlingen. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Het Joodse Pesachfeest was bijna aangebroken en veel mensen reisden vóór het Pesachfeest vanuit het hele land naar Jeruzalem, om daar de reinigingsceremonie te ondergaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ze zochten naar Jezus en wanneer ze op het tempelterrein stonden vroegen ze elkaar: “Wat denken jullie? Zou Hij naar het feest komen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","De hoofdpriesters en de farizeeën hadden bevolen dat als iemand wist waar Jezus was, hij hen moest verwittigen, zodat ze Hem zouden kunnen arresteren. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zes dagen voor het Pesachfeest kwam Jezus naar Betanië. Daar woonde Lazarus, die Hij uit de dood had opgewekt. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ter ere van Jezus werd een feestmaal gegeven en Marta diende op, terwijl Lazarus met Jezus en de andere gasten aan de maaltijd deelnam. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Toen nam Maria dure, zuivere nardusolie met een gewicht van ruim driehonderd gram en zalfde daarmee Jezus' voeten. Ze droogde ze af met haar haren en het hele huis rook naar de olie. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Maar Judas Iskariot – hij was een van Jezus' leerlingen en zou Hem later uitleveren – zei: ");
INSERT INTO nldgbv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Deze olie had verkocht kunnen worden voor driehonderd denarie en de opbrengst had aan de armen kunnen worden gegeven. Waarom is dat niet gebeurd?” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hij zei dit niet omdat hij zich om de armen bekommerde, maar omdat hij een dief was. Hij beheerde de kas en stal van de inkomsten. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jezus zei: “Laat haar met rust; ze wil het gebruiken om mijn lichaam te zalven ter voorbereiding van mijn begrafenis. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Er zullen altijd arme mensen bij jullie zijn, maar Ik zal niet altijd bij jullie zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Toen bekend raakte dat Jezus daar was, kwam een grote groep Joodse mensen naar hen toe; niet alleen voor Jezus maar ook om Lazarus te zien, die door Hem uit de dood was opgewekt. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","De hoofdpriesters daarentegen maakten plannen om ook Lazarus te doden, ");
INSERT INTO nldgbv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","want wegens hem waren er veel Joodse mensen die zich van hen afkeerden en tot geloof in Jezus kwamen. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","De volgende dag hoorde de grote menigte die naar het feest was gekomen dat Jezus naar Jeruzalem onderweg was. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ze namen de takken van palmbomen en gingen de stad uit, Hem tegemoet, terwijl ze uitriepen: “Hosanna! Gezegend is Hij die komt in de naam van de Heer, de koning van Israël.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jezus leende een jonge ezel en ging erop zitten, zoals in de Schriften staat: ");
INSERT INTO nldgbv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Wees niet bang, dochter van Sion, je koning is in aantocht en Hij zit op een jonge ezel.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Zijn leerlingen begrepen dit aanvankelijk niet, maar nadat Jezus naar Gods glorie was teruggekeerd, herinnerden zij zich dat dit over Hem in de Schriften staat en dat het zo met Hem was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","De vele mensen die erbij waren geweest toen Jezus Lazarus uit het graf had geroepen en uit de dood had opgewekt, waren daarvan blijven getuigen. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daarom kwam de menigte Hem tegemoet; men had gehoord dat Hij dit wonderlijke teken had verricht. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","De farizeeën zeiden tegen elkaar: “Jullie zien dat jullie niets hebben bereikt. Kijk, de hele wereld loopt achter Hem aan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Onder de mensen die naar het feest gingen om God te aanbidden, bevonden zich enkele Grieken. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Zij benaderden Filippus uit Betsaïda in Galilea met het verzoek: “Meneer, wij zouden Jezus graag willen ontmoeten.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus ging het aan Andreas vertellen, en Andreas en Filippus gingen het aan Jezus vertellen. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jezus antwoordde: “Het moment waarop de grootheid van de Mensenzoon zichtbaar wordt, is gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ik zeg jullie nadrukkelijk, als een graankorrel niet in de aarde valt en sterft, blijft het één korrel. Maar wanneer hij sterft, levert hij veel nieuwe graankorrels op. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wie aan zijn leven verknocht is, zal het verliezen, maar wie in deze wereld zijn leven veracht, zal het behouden voor het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wie Mij wil dienen, moet Mij volgen; dan zal mijn dienaar daar zijn waar Ik ben. En als iemand Mij dient, zal hij door de Vader worden geëerd. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nu ben Ik hevig ontsteld. Zal Ik bidden: Vader, red Mij uit deze situatie? Nee! Ik ben immers gekomen om deze situatie te doorstaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Vader, toon uw grootheid!” Toen kwam er een stem uit de hemel: “Ik heb tot nu toe steeds mijn grootheid getoond en Ik zal ook nu mijn grootheid tonen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","De menigte die erbij stond en die de stem had gehoord, zei dat het had gedonderd. Anderen zeiden dat een engel Jezus had toegesproken. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Maar Jezus zei: “Die stem heeft niet gesproken voor Mij, maar voor jullie. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nu zal het oordeel over deze wereld worden geveld, nu zal de heerser van deze wereld worden onttroond. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","En wanneer Ik vanaf de aarde ben omhooggeheven, zal Ik alle mensen naar Mij toe halen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hij zei dit om aan te geven welke dood Hij zou sterven. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Toen antwoordden de mensen: “Wij hebben uit de Wet begrepen dat de Messias voor eeuwig zal blijven. Hoe kan U zeggen dat de Mensenzoon omhooggeheven moet worden? En wie is die Mensenzoon?” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jezus zei tegen hen: “Het licht zal nog even bij jullie zijn. Wandel terwijl het nog licht is en laat je niet door het donker overvallen. Wie in het donker wandelt, weet niet waar hij heengaat. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Geloof in het licht zolang jullie het licht nog bij jullie hebben; dan zijn jullie kinderen van het licht.” Nadat Jezus dit had gezegd, ging Hij weg en trok Hij zich terug uit het openbare leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ondanks dat Jezus voor hun ogen veel wonderlijke tekenen had verricht, geloofden de mensen niet in Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Zo zijn de volgende woorden van de profeet Jesaja in vervulling gegaan: “Heer, wie geloofde wat hij van ons heeft gehoord? En aan wie heeft de Heer zijn macht geopenbaard?” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","De reden dat ze niet konden geloven is dat Jesaja ook heeft gezegd: ");
INSERT INTO nldgbv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Hij heeft hun ogen verblind en hun hart verstard. Zo komt het dat hun ogen niet zien, hun hart niet begrijpt en zij zich niet bekeren om zich door Mij te laten genezen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesaja had dat gezegd omdat hij Jezus' grootheid had gezien; daarom sprak hij over Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Toch geloofden ook veel van de Joodse leiders in Jezus. Maar omwille van de farizeeën zeiden ze dat niet openlijk, want ze wilden niet uit de synagoge verbannen worden. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ze stelden meer prijs op goedkeuring van mensen dan op goedkeuring van God. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jezus sprak luid en duidelijk: “Wie in Mij gelooft, gelooft niet in Mij maar in Degene die Mij heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","En wie Mij ziet, ziet Degene die Mij heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ik ben het licht dat naar de wereld is gekomen, opdat ieder die in Mij gelooft, niet in de duisternis hoeft te blijven. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","En als iemand hoort wat Ik zeg en het negeert, ben Ik het niet die hem veroordeelt. Ik ben niet gekomen om de wereld te veroordelen, maar om de wereld te redden. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wie Mij afwijst en niet aanvaardt wat Ik zeg, heeft reeds een rechter: op de Laatste Dag zal hij worden veroordeeld door de woorden die Ik heb gesproken. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ik heb namelijk niet namens Mijzelf gesproken. De Vader die Mij heeft gestuurd, Hij heeft Mij opgedragen wat Ik precies moet zeggen. ");
INSERT INTO nldgbv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","En Ik weet dat hetgeen Hij Mij opdraagt, het eeuwig leven brengt. Daarom zeg Ik precies wat de Vader tegen Mij heeft gezegd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Het was vlak voor het Pesachfeest. Jezus wist dat zijn moment was gekomen: Hij zou vanuit deze wereld naar de Vader toe gaan. Hij had de mensen in deze wereld die bij Hem horen lief en heeft hen tot het einde liefgehad. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na de maaltijd gebeurde het volgende: de duivel had het idee om Jezus te verraden al in het hart van Judas, zoon van Simon van Iskariot, gelegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jezus wist dat de Vader Hem alle macht had gegeven en dat Hij van God kwam en naar God zou terugkeren. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hij stond op van tafel, trok zijn bovenkleed uit en sloeg een handdoek om. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Toen goot Hij water in het waskruikje en begon Hij de voeten van zijn leerlingen te wassen. Hij droogde ze met de handdoek die Hij had omgeslagen. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Toen Hij bij Simon Petrus kwam, protesteerde deze: “Heer, U wil mijn voeten wassen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jezus antwoordde: “Je begrijpt nu nog niet wat Ik doe, maar je zal het later begrijpen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus zei: “U mijn voeten wassen? Dat nooit!” Maar Jezus antwoordde: “Als Ik je niet was, kan je niet bij Mij horen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Toen zei Simon Petrus: “Heer, was in dat geval niet enkel mijn voeten, maar ook mijn handen en hoofd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jezus antwoordde: “Wie reeds in bad is geweest, hoeft enkel zijn voeten nog te wassen, maar is verder helemaal schoon. Jullie zijn dus schoon, maar niet allemaal.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hij wist namelijk wie Hem zou uitleveren; het was daarom dat Hij zei: “Jullie zijn niet allemaal schoon.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Toen Hij hun voeten had gewassen, trok Hij zijn bovenkleed weer aan, nam weer plaats aan tafel, en vroeg: “Begrijpen jullie wat Ik heb gedaan? ");
INSERT INTO nldgbv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jullie noemen Mij Leraar en Heer, en dat is terecht, want dat is wat Ik ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","En als Ik, de Heer en Leraar, jullie voeten heb gewassen, dan moeten jullie ook elkaars voeten wassen. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ik heb jullie het voorbeeld gegeven; hetgeen Ik bij jullie heb gedaan, moeten jullie ook doen. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ik zeg jullie nadrukkelijk, een slaaf staat niet boven zijn meester en een afgezant staat niet boven degene die hem heeft gestuurd. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Je bent gezegend als je dit niet alleen begrijpt, maar het ook in praktijk brengt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ik heb het niet over jullie allen. Ik weet wie Ik heb uitgekozen, maar in de Schriften staat: ‘Hij die samen met mij brood at, heeft zich tegen Mij gekeerd’, en dat moet in vervulling gaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ik zeg het jullie reeds nu, voordat het zover is, opdat jullie wanneer het gebeurt, zullen geloven dat Ik het ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ik zeg jullie nadrukkelijk, wie iemand verwelkomt die door Mij is gezonden, verwelkomt Mij en wie Mij verwelkomt, verwelkomt Degene die Mij heeft gezonden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nadat Hij dit had gezegd, raakte Jezus hevig ontsteld. Hij verklaarde: “Ik zeg jullie nadrukkelijk, een van jullie zal Mij verraden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zijn leerlingen keken elkaar aan en vroegen zich vertwijfeld af wie Hij bedoelde. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Eén van zijn leerlingen, de leerling van wie Jezus veel hield, bevond zich naast Jezus aan tafel. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus gaf die leerling een teken dat die Jezus moest vragen wie Hij bedoelde. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","De leerling boog zich dicht naar Jezus toe en vroeg: “Heer, wie is het?” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jezus antwoordde: “Ik zal een stuk brood in de schaal dopen en de persoon aan wie Ik het geef, die is het.” Daarop doopte Jezus een stuk brood in de schotel en gaf het aan Judas, zoon van Simon Iskariot. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zodra deze het stuk brood had aangenomen, drong Satan in hem binnen. Jezus zei tegen hem: “Ga nu doen wat je van plan bent.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niemand aan tafel begreep waarom Hij dit tegen hem zei. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Omdat Judas de kas beheerde, meenden sommigen dat Jezus hem opdroeg om iets te kopen dat nodig was voor het feest, of om iets te geven aan de armen. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Meteen nadat Judas het stuk brood had aangenomen, ging hij naar buiten, de nacht in. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Toen Judas weg was, zei Jezus: “Nu wordt de grootheid van de Mensenzoon zichtbaar en wordt in Hem ook Gods grootheid zichtbaar. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","En wanneer de Mensenzoon Gods grootheid zichtbaar heeft gemaakt, zal God zelf ook de grootheid van de Mensenzoon zichtbaar maken. Dat zal heel binnenkort gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lieve kinderen, Ik zal nog even bij jullie zijn. Dan zullen jullie Mij zoeken, en wat Ik tegen iedereen heb gezegd, zeg Ik nu ook tegen jullie: waar Ik naartoe ga, kunnen jullie niet komen. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ik geef jullie een nieuw gebod: ga liefdevol met elkaar om. Zoals Ik jullie heb liefgehad, moeten jullie elkaar liefhebben. ");
INSERT INTO nldgbv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hieraan zal iedereen jullie herkennen als mijn leerlingen: aan jullie liefde voor elkaar.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus vroeg Hem: “Heer, waar gaat U naartoe?” Jezus antwoordde: “Waar Ik naartoe ga, kan jij Mij nu niet volgen, maar later zal je Me daarheen volgen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus vroeg Hem: “Heer, waarom kan ik U nu nog niet volgen? Ik ben bereid om mijn leven voor U te geven.” ");
INSERT INTO nldgbv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jezus antwoordde: “Jij bent bereid om voor Mij je leven te geven? Ik zeg je nadrukkelijk, voordat er een haan kraait, zal jij Mij driemaal hebben verloochend. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Raak niet ontsteld; vertrouw op God en vertrouw op Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In het paleis van mijn Vader is veel woonruimte. Anders zou Ik toch niet tegen jullie hebben gezegd dat Ik erheen ga om te zorgen dat er plaats voor jullie zal zijn? ");
INSERT INTO nldgbv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","En nadat Ik erheen ben gegaan om te zorgen dat er plaats voor jullie zal zijn, kom Ik terug om jullie op te halen, zodat jullie zullen zijn waar Ik ook ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Waar Ik naartoe ga, daarheen kennen jullie de weg.” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas zei tegen Hem: “Heer, wij weten niet waar U naartoe gaat. Hoe kunnen we dan de weg kennen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jezus zei tegen hem: “Ik ben de weg, de waarheid en het leven. Niemand kan bij de Vader komen, tenzij door Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Als jullie Mij kennen, kennen jullie ook de Vader. Daarom kennen jullie Hem en jullie hebben Hem zelfs gezien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filippus zei tegen Jezus: “Heer, toon ons de Vader; dat is alles wat we vragen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jezus antwoordde: “Ik ben al zo lang bij jullie, Filippus, en je kent Mij nog altijd niet? Wie Mij heeft gezien, heeft de Vader gezien. Hoe kan je dan vragen: ‘Toon ons de Vader’? ");
INSERT INTO nldgbv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Geloof je niet dat de Vader en Ik een volkomen eenheid vormen? De woorden die Ik tot jullie spreek, heb Ik niet van Mijzelf, ze zijn het werk van de Vader met Wie Ik een volkomen eenheid vorm. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Geloof Me wanneer Ik tegen jullie zeg dat de Vader en Ik een volkomen eenheid vormen, of geloof anders omwille van de dingen die de Vader heeft gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ik zeg jullie nadrukkelijk, wie op Mij vertrouwt, zal dezelfde dingen doen die Ik heb gedaan. Hij zal zelfs grotere dingen doen, want Ik ga naar de Vader, ");
INSERT INTO nldgbv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","en wat jullie ook vragen in mijn naam, zal Ik doen, opdat de grootheid van de Vader zichtbaar zal zijn in de Zoon. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wat jullie Mij ook vragen in mijn naam, Ik zal het doen. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Als jullie Mij liefhebben, houden jullie je aan mijn geboden. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","En Ik zal de Vader vragen om jullie een andere Raadgever te geven, die voor altijd bij jullie zal zijn: ");
INSERT INTO nldgbv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","de Geest die de waarheid brengt. De wereld kan Hem niet ontvangen, omdat ze Hem niet ziet en Hem niet kent. Maar jullie kennen Hem wel, omdat Hij bij jullie blijft en in jullie zal wonen. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ik zal jullie niet verweesd achterlaten, Ik kom bij jullie terug. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nog even en dan zal de wereld Mij niet meer zien. Maar jullie zullen Mij wel zien en omdat Ik leef, zullen ook jullie leven. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dan zullen jullie begrijpen dat mijn Vader en Ik een eenheid vormen en dat jullie een eenheid vormen met Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wie mijn geboden kent en zich eraan houdt, die heeft Mij werkelijk lief. En als iemand Mij liefheeft, zal de Vader hem liefdevol behandelen. En ook Ik zal hem liefdevol behandelen en Ik zal hem tonen wie Ik ben.” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Toen vroeg Judas (niet Judas Iskariot): “Heer, hoe komt het dat U wel aan ons zal tonen wie U bent, maar niet aan de wereld?” ");
INSERT INTO nldgbv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jezus antwoordde: “Wie Mij liefheeft, houdt zich aan hetgeen Ik zeg. Mijn Vader zal hem liefhebben en wij zullen bij hem komen en voor altijd bij hem zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Maar wie Mij niet liefheeft, houdt zich niet aan hetgeen Ik zeg. En wat jullie Mij horen zeggen, komt niet van Mij, maar van Degene die Mij heeft gestuurd, mijn Vader. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ik zeg dit tegen jullie nu Ik nog bij jullie ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Maar de Raadgever, de Heilige Geest, die de Vader in mijn naam naar jullie zal sturen – Hij is het die jullie al het overige zal leren en jullie alles in herinnering zal brengen wat Ik tegen jullie heb gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ik laat jullie mijn vrede na; Ik geef jullie vrede. De vrede die Ik geef, is niet als de vrede die de wereld geeft. Raak niet ontsteld, wees niet bang. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jullie hebben gehoord wat Ik tegen jullie heb gezegd: Ik ga weg en Ik zal bij jullie terugkomen. Als jullie Mij zouden liefhebben, zouden jullie je verheugen omdat Ik naar de Vader ga, want de Vader staat boven Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ik zeg het jullie nu reeds, voordat het zover is, opdat jullie zullen geloven dat Ik het ben wanneer het gebeurt. ");
INSERT INTO nldgbv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ik zal niet lang meer met jullie spreken, want de heerser van de wereld is in aantocht. Hij heeft weliswaar niets over Mij te zeggen, ");
INSERT INTO nldgbv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","maar dit gebeurt opdat de wereld zal weten dat Ik de Vader liefheb en doe wat de Vader Mij heeft opgedragen. Kom, laten we hier weggaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ik ben de ware wijnstok en mijn Vader is de wijnbouwer. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hij verwijdert elke rank aan Mij die geen vrucht draagt. En elke rank die wel vrucht draagt, snoeit Hij, opdat deze meer vrucht zou dragen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jullie zijn reeds gesnoeid door de woorden die Ik tot jullie heb gesproken. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Blijf met Mij verbonden; dan blijf Ik met jullie verbonden. De rank kan uit zichzelf geen vrucht dragen; dat kan enkel als hij met de wijnstok verbonden blijft. Precies zo kunnen jullie enkel vrucht dragen als je met Mij verbonden blijft. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ik ben de wijnstok; jullie zijn de ranken. Als iemand met Mij verbonden blijft – en Ik met hem – draagt hij veel vrucht, want los van Mij kunnen jullie niets doen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wie niet met Mij verbonden blijft, is als een rank die wordt weggegooid en die verdort. De weggegooide ranken worden verzameld, in het vuur gegooid en verbrand. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Maar als jullie met Mij verbonden blijven en jullie je houden aan hetgeen Ik jullie heb verteld, mogen jullie vragen wat je wil, en het zal gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","De grootheid van mijn Vader wordt zichtbaar wanneer jullie veel vrucht dragen en daardoor laten zien dat jullie mijn leerlingen zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ik heb jullie lief zoals de Vader Mij liefheeft. Blijf verbonden met mijn liefde. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jullie blijven verbonden met mijn liefde door je aan mijn geboden te houden, net zoals Ik met de liefde van mijn Vader verbonden blijf door Me aan zijn geboden te houden. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ik heb deze dingen tegen jullie gezegd opdat de vreugde die Ik heb, ook in jullie aanwezig zal zijn en opdat jullie vreugde volkomen zal zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mijn gebod voor jullie is: heb elkaar lief op dezelfde manier als Ik jullie heb liefgehad. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Er is geen grotere liefde dan dat je je leven geeft voor je vrienden. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","En jullie zijn mijn vrienden als jullie doen wat Ik jullie opdraag. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ik noem jullie niet langer dienaren, want een dienaar weet niet wat zijn meester doet. Nee, Ik noem jullie vrienden, want Ik heb alles wat Ik van mijn Vader heb vernomen, aan jullie bekendgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jullie hebben Mij niet uitgekozen, Ik heb jullie uitgekozen en jullie aangesteld om eropuit te gaan en vrucht te dragen, blijvende vrucht. Dan zal de Vader jullie alles geven wat jullie in mijn naam van Hem vragen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ik beveel jullie dus: ga liefdevol met elkaar om. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Als de wereld jullie haat, besef dan dat ze Mij haatte voordat ze jullie haatte. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Als jullie bij de wereld zouden horen, zou de wereld van jullie houden omdat jullie van haar zouden zijn. Maar omdat Ik jullie uit de wereld heb uitgekozen, zijn jullie niet van de wereld en haat de wereld jullie. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Onthoud wat Ik jullie heb verteld: een slaaf staat niet boven zijn meester. Als de mensen Mij hebben vervolgd, zullen ze ook jullie vervolgen, maar als ze zich hielden aan hetgeen Ik zei, dan zullen ze zich ook houden aan hetgeen jullie zeggen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dit alles zullen ze jullie aandoen omwille van mijn naam, omdat ze Degene die Mij heeft gestuurd niet kennen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ze zouden niet schuldig zijn geweest als Ik niet was gekomen om hen toe te spreken, maar nu hebben ze geen excuus voor hun schuld. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wie Mij haat, haat ook mijn Vader. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ze zouden niet schuldig zijn geweest als Ik niet te midden van hen de dingen had gedaan die niemand anders ooit heeft gedaan. Maar ze hebben die daden gezien en ze haten zowel Mij als mijn Vader. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Zo gaat in vervulling wat in hun Wet staat: ‘Ze haatten Mij zonder reden.’ ");
INSERT INTO nldgbv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Wanneer de Raadgever komt die Ik van bij de Vader naar jullie zal sturen – de Geest die van de Vader afkomstig is en die de waarheid brengt – dan zal Hij van Mij getuigen. ");
INSERT INTO nldgbv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","En ook jullie zullen getuigen, omdat jullie vanaf het begin bij Mij zijn geweest. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ik vertel jullie deze dingen opdat jullie niet zullen struikelen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Men zal jullie uit de synagoge verbannen en er komt een tijd dat iedereen die jullie ter dood brengt, zal denken dat hij God een dienst bewijst. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","De reden dat de mensen dat zullen doen is dat ze noch de Vader, noch Mij kennen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Maar Ik vertel jullie deze dingen, zodat wanneer ze gebeuren, jullie je zullen herinneren dat Ik het heb gezegd. Ik heb ze jullie niet eerder verteld omdat Ik toen nog bij jullie was. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nu ga ik naar Degene die Mij heeft gestuurd. Toch vraagt niemand van jullie: ‘Waar gaat U naartoe?’ ");
INSERT INTO nldgbv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Maar nu Ik dit tegen jullie heb gezegd, is jullie hart vol verdriet. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Maar Ik zeg jullie de waarheid: het is beter voor jullie dat Ik ga. Want als Ik niet ga, zal de Raadgever niet bij jullie komen, maar als Ik wel ga, zal Ik Hem naar jullie toe sturen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","En wanneer Hij gekomen is, zal Hij de wereld overtuigen van zonde, rechtvaardigheid en veroordeling. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hij zal de mensen overtuigen van hun zonde, namelijk dat ze niet in Mij geloven. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Hij zal hen overtuigen van Gods rechtvaardigheid, want Ik ga naar de Vader en dan zien jullie Mij niet meer. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","En Hij zal hen overtuigen van veroordeling, want de heerser van de huidige wereld is veroordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ik heb jullie nog veel meer te vertellen, maar jullie kunnen het nu nog niet aan. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Echter, wanneer de Geest die de waarheid brengt is gekomen, zal Hij jullie leiden naar het inzicht in de volkomen waarheid. Want hetgeen Hij zal zeggen, zal niet van Hemzelf komen; Hij zal zeggen wat Hij te horen krijgt. En Hij zal jullie vertellen welke dingen zullen gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hij zal mijn grootheid zichtbaar maken door hetgeen Hij van Mij ontvangt aan jullie door te geven. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Alles wat van de Vader is, is ook van Mij. Daarom heb Ik gezegd: Hij zal van Mij ontvangen en aan jullie doorgeven. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nog even en dan zien jullie Mij niet meer, en kort daarna zien jullie Mij terug.” ");
INSERT INTO nldgbv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Toen vroegen enkele van zijn leerlingen aan elkaar: “Wat zou Hij bedoelen met: ‘Nog even en dan zien jullie Mij niet meer, en kort daarna zien jullie Mij terug’, en: ‘Omdat Ik naar de Vader ga?’” ");
INSERT INTO nldgbv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ook vroegen ze: “Wat bedoelt Hij met ‘even’? We begrijpen niet wat Hij zegt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jezus besefte dat ze het Hem wilden vragen. Daarom vroeg Hij hun: “Proberen jullie te begrijpen wat Ik bedoelde toen Ik zei: ‘Nog even en dan zien jullie Mij niet meer, en kort daarna zien jullie Mij terug’? ");
INSERT INTO nldgbv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ik zeg jullie nadrukkelijk, jullie zullen wenen en rouwen, maar de wereld zal zich verheugen. Jullie zullen bedroefd zijn, maar jullie verdriet zal in vreugde veranderen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Een vrouw lijdt pijn tijdens de geboorte van haar kind, wanneer haar moment is gekomen. Maar zodra het kind er is, denkt ze niet meer aan de pijn, wegens de vreugde dat er een kind ter wereld is gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ook jullie lijden pijn, maar Ik zal jullie terugzien. En dan zal er vreugde in je hart zijn en niemand zal die vreugde van je afnemen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Op die dag hoeven jullie niets meer aan Mij te vragen. Ik zeg jullie nadrukkelijk, de Vader zal jullie alles geven wat jullie van Hem vragen in mijn naam. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tot nu toe hebben jullie niets gevraagd in mijn naam. Vraag en je zal ontvangen, en dan zal je vreugde volkomen zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ik heb deze dingen tegen jullie gezegd in de vorm van beeldspraak. Er komt echter een tijd dat Ik niet langer in beelden tot jullie zal spreken; dan zal Ik jullie onomwonden over de Vader vertellen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dan zullen jullie vragen in mijn naam en hoef Ik niet te zeggen dat Ik het voor jullie aan de Vader zal vragen. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","De Vader zelf houdt van jullie omdat jullie van Mij houden en geloven dat Ik van de Vader afkomstig ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ik ben inderdaad van de Vader afkomstig. Ik ben naar de wereld gekomen, maar nu vertrek Ik uit de wereld, terug naar de Vader.” ");
INSERT INTO nldgbv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zijn leerlingen zeiden: “Kijk, nu spreekt U onomwonden en niet in beelden. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nu weten wij dat U alles weet en dat niemand U vragen hoeft te stellen. Daarom geloven wij dat U van God afkomstig bent.” ");
INSERT INTO nldgbv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jezus antwoordde: “Geloven jullie nu? ");
INSERT INTO nldgbv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Er komt een tijd – en het is nu al zover – dat jullie zullen worden uiteengejaagd, elk een andere kant uit, en dat jullie Mij alleen zullen laten. Ik ben echter niet alleen, de Vader is bij Mij. ");
INSERT INTO nldgbv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ik heb deze dingen tegen jullie gezegd opdat jullie bij Mij vrede zullen vinden. In de wereld zullen jullie verdrukking lijden, maar houd moed, Ik heb de wereld overwonnen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nadat Jezus dit had gezegd, keek Hij omhoog, naar de hemel, en bad Hij: “Vader, nu is het moment gekomen. Maak de grootheid van uw Zoon zichtbaar, dan zal de Zoon uw grootheid zichtbaar maken. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","U heeft Hem immers de macht over de hele mensheid gegeven, opdat Hij het eeuwig leven zou schenken aan de mensen die U aan Hem heeft toevertrouwd. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Het eeuwig leven, dat is dat zij U kennen, de enige, ware God, en ook Degene die U heeft gezonden: Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ik heb op aarde Uw grootheid zichtbaar gemaakt door het werk uit te voeren dat U Mij heeft gegeven. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","En nu, Vader, bekleed Mij bij U opnieuw met de grootheid die Ik bij U had voordat de wereld bestond. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ik heb de mensen die U Mij vanuit de wereld heeft gegeven, getoond wie U bent. Zij waren van U en U heeft hen aan Mij toevertrouwd. Ze hebben zich gehouden aan hetgeen U heeft gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nu beseffen zij dat alles wat U Mij gegeven heeft, van U komt, ");
INSERT INTO nldgbv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","want Ik heb de woorden die U Mij had gegeven, aan hen doorgegeven. En omdat zij die hebben aanvaard, beseffen ze dat Ik werkelijk van U kom en geloven ze dat U Mij heeft gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ik bid voor hen. Ik bid niet voor de wereld, maar voor de mensen die U Mij heeft toevertrouwd, want ze zijn van U. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ja, alles wat van Mij is, is van U, en alles wat van U is, is van Mij. In hen is mijn grootheid zichtbaar geworden. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Binnenkort zal Ik niet meer in de wereld zijn; Ik kom naar U toe. Maar zij zijn dan nog wel in de wereld. Heilige Vader, bescherm hen met uw macht, de macht die U Mij heeft gegeven, zodat zij een eenheid zullen vormen zoals U en Ik een eenheid vormen. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Zolang Ik bij hen was, heb Ik hen beschermd met uw macht, de macht die U Mij heeft verleend. Ik heb over hen gewaakt en geen van hen is verloren gegaan, behalve hij die voor de ondergang bestemd was. Zo is hetgeen in de Schriften staat in vervulling gegaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nu kom Ik naar U toe en Ik zeg dit terwijl Ik nog in de wereld ben, opdat zij vol zullen zijn van mijn vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ik heb uw boodschap aan hen doorgegeven. En nu haat de wereld hen, omdat zij niet meer bij de wereld horen, net zoals Ik niet bij de wereld hoor. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ik vraag U niet hen uit de wereld weg te nemen, maar hen te beschermen tegen de duivel. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ze zijn niet van de wereld, net zoals Ik niet van de wereld ben. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Maak van hen, door middel van de waarheid, mensen die aan U zijn toegewijd. Hetgeen U zegt, is de waarheid. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ik heb hen naar de wereld gezonden, net zoals U Mij naar de wereld had gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","En omwille van hen geef Ik Mij aan U over, opdat ook zij, door middel van de waarheid, aan U toegewijd zullen zijn. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ik bid niet alleen voor hen, maar ook voor de mensen die door hun getuigenis tot geloof in Mij komen. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ik bid dat zij allen een eenheid mogen vormen, zoals U, Vader, en Ik met elkaar verbonden zijn. Laat hen een eenheid vormen door hun verbondenheid met Ons, opdat de wereld zal geloven dat U Mij heeft gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","De grootheid die U Mij heeft gegeven, heb Ik aan hen doorgegeven, opdat zij een eenheid mogen vormen, zoals Wij een eenheid vormen – ");
INSERT INTO nldgbv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ik met hen en U met Mij. Ik bid dat ze een volkomen eenheid mogen vormen. Dan zal de wereld weten dat U Mij heeft gezonden en dat U hen liefheeft, net zoals U Mij liefheeft. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Vader, Ik wil graag dat de mensen die U Mij heeft toevertrouwd bij Mij zullen zijn daar waar Ik ben, en dat zij mijn grootheid zullen zien – de grootheid die U Mij heeft gegeven omdat U Mij reeds liefhad vóór de schepping van de wereld. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Rechtvaardige Vader, de wereld kent U niet, maar Ik ken U en zij beseffen dat U Mij heeft gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ik heb hun duidelijk gemaakt Wie U bent, en Ik zal dat blijven doen; dan zal uw liefde voor Mij ook hen vervullen en zal Ik in hen wonen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nadat Jezus dit had gebeden, ging Hij met zijn leerlingen naar de overkant van de Kidronbeek. Daar was een tuin, die Hij met zijn leerlingen binnenging. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, die Hem wilde uitleveren, kende die plaats ook, want Jezus was er vaak met zijn leerlingen samengekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas ging er ook heen, met een eenheid soldaten en met de tempelwachters die door de hoofdpriesters en de farizeeën waren gestuurd. Ze hadden lantaarns, fakkels en wapens bij zich. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jezus, die precies wist wat er met Hem zou gebeuren, ging naar hen toe en vroeg: “Wie zoeken jullie?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ze antwoordden: “Jezus van Nazaret.” Jezus zei: “Dat ben Ik.” Judas, die Hem wilde uitleveren, stond bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Toen Jezus zei: “dat ben Ik”, deinsden de mannen achteruit en vielen ze op de grond. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hij vroeg nogmaals: “Wie zoeken jullie?” Ze zeiden: “Jezus van Nazaret.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jezus reageerde: “Ik heb jullie al verteld dat Ik het ben. Dus als jullie Mij zoeken, laat deze mensen dan gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zo ging in vervulling wat Hij eerder had gezegd: “Ik heb geen van de mensen verloren die U Mij had toevertrouwd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Toen trok Simon Petrus het zwaard dat hij bij zich had, haalde ermee uit naar de dienaar van de hogepriester en hakte zijn rechteroor af. De dienaar heette Malchus. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Maar Jezus zei tegen Petrus: “Steek dat zwaard weer in zijn schede. Zou Ik niet drinken van de beker die de Vader Mij heeft gegeven?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","De eenheid soldaten, de tribuun en de Joodse tempelwachters arresteerden Jezus en boeiden Hem. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ze brachten Hem eerst naar Annas, de schoonvader van Kajafas. Kajafas was dat jaar hogepriester, ");
INSERT INTO nldgbv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","en hij was het die de Joodse leiders de raad had gegeven dat het beter is dat één mens sterft voor het volk. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus en een andere leerling volgden Jezus. Die andere leerling kende de hogepriester en ging met Jezus mee, de binnenplaats van het huis van de hogepriester op. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Maar Petrus bleef buiten staan, bij de poort. De andere leerling, die de hogepriester kende, ging terug, sprak met de portierster en nam Petrus mee naar binnen. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dit dienstmeisje, de portierster, vroeg aan Petrus: “Ben jij niet ook een van de leerlingen van die Man?” Petrus zei: “Nee, dat ben ik niet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","De dienaren en de tempelwachters stonden zich te warmen bij een vuur dat ze hadden aangelegd tegen de kou. Petrus ging bij hen staan om zich te warmen. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","De hogepriester ondervroeg Jezus over zijn leerlingen en over zijn leer. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jezus antwoordde: “Ik heb altijd in het openbaar tot de wereld gesproken; Ik onderwees in synagogen en in de tempel, waar alle Joodse mensen bijeenkomen. Ik heb nooit in het geheim gesproken. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Waarom stelt u Mij die vragen? Vraag het maar aan de mensen die hebben gehoord wat Ik hun vertelde; zij weten heel goed wat Ik heb gezegd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Toen Hij dat zei, gaf een van de tempelwachters die bij Jezus stond, Hem een klap en zei: “Is dat hoe je de hogepriester antwoordt?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jezus antwoordde: “Als Ik iets verkeerds heb gezegd, vertel dan wat er verkeerd aan is. Maar als hetgeen Ik zei de waarheid is, waarom sla je me dan?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Toen stuurde Annas Jezus geboeid naar hogepriester Kajafas. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Intussen stond Simon Petrus zich te warmen. Iemand vroeg hem: “Ben jij misschien ook een van zijn leerlingen?” Maar hij ontkende het: “Nee, dat ben ik niet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Een van de dienaren van de hogepriester was familie van de persoon van wie Petrus het oor had afgehakt. Hij vroeg: “Heb ik jou niet bij Hem gezien in die tuin?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus ontkende het opnieuw en meteen kraaide er een haan. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Toen brachten ze Jezus van het huis van Kajafas naar het paleis van de gouverneur. Het was vroeg in de ochtend. Om te voorkomen dat ze onrein zouden worden en dus niet van de Pesachmaaltijd zouden mogen eten, gingen ze het paleis niet binnen. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Daarom kwam Pilatus naar buiten om hen te woord te staan. Hij vroeg: “Welke beschuldiging brengen jullie tegen deze persoon in?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ze antwoordden: “Als Hij geen boosdoener zou zijn, zouden we Hem niet aan u uitleveren.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus antwoordde: “Nemen jullie Hem mee, en oordeel zelf over Hem volgens jullie Wet.” Maar de Joodse leiders antwoordden: “Wij mogen niemand ter dood brengen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","En zo is in vervulling gegaan wat Jezus had gezegd over de wijze waarop Hij zou sterven. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus ging het paleis weer binnen en liet Jezus voorleiden. Hij vroeg Hem: “Bent U de koning van de Joden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jezus antwoordde: “Komt die vraag van uzelf of hebben anderen u dat over Mij verteld?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus reageerde: “Ik ben toch geen Jood? Uw eigen volk en de hoofdpriesters hebben U aan mij uitgeleverd. Wat hebt U gedaan?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jezus antwoordde: “Mijn koningschap hoort niet bij deze wereld. Als mijn koningschap bij deze wereld zou horen, dan zouden mijn mensen zich hebben ingespannen om te voorkomen dat Ik aan de Joden werd uitgeleverd. Maar mijn koningschap is niet van hier.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus vroeg Hem: “U bent dus koning?” Jezus antwoordde: “Ik ben koning, zoals u zegt. Hiervoor ben Ik geboren en hiervoor ben ik naar de wereld gekomen: om van de waarheid te getuigen. Ieder die zich op de waarheid richt, luistert naar hetgeen Ik zeg.” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus vroeg Hem: “Wat is waarheid?” Nadat hij dat had gezegd, ging hij weer naar buiten, naar de Joodse leiders. Hij zei tegen hen: “Ik heb niets gevonden waarvoor Hij veroordeeld zou moeten worden. ");
INSERT INTO nldgbv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Maar volgens jullie gewoonte laat ik ter gelegenheid van het Pesachfeest op jullie verzoek iemand vrij. Willen jullie dat ik de koning van de Joden vrijlaat?” ");
INSERT INTO nldgbv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Toen begonnen ze te schreeuwen: “Niet Hem, maar Barabbas!” Barabbas was een misdadiger. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Toen liet Pilatus Jezus wegleiden en geselen. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","De soldaten vlochten een kroon van doorntakken en zetten die op zijn hoofd. Ook trokken ze Hem een paarse mantel aan. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Keer op keer stapten ze naar Hem toe, zeiden dan: “gegroet, koning van de Joden”, en sloegen Hem in het gezicht. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus kwam nogmaals naar buiten en zei: “Kijk, ik breng Hem naar buiten. Zo weten jullie dat ik niets heb gevonden waarvoor Hij veroordeeld zou moeten worden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Toen kwam Jezus naar buiten; Hij droeg de kroon van doorntakken en de paarse mantel. Pilatus zei: “Kijk naar die Mens.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zodra de hoofdpriesters en tempelwachters Jezus zagen, riepen ze: “Kruisig Hem, kruisig Hem!” Pilatus zei: “Neem Hem mee en kruisig Hem zelf. Ik heb niets gevonden waarvoor Hij veroordeeld zou moeten worden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","De Joodse leiders antwoordden: “Maar wij hebben een Wet die stipuleert dat Hij moet sterven omdat Hij beweert dat Hij de Zoon van God is.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Toen Pilatus die woorden hoorde, schrok hij hevig. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hij ging het paleis weer binnen en vroeg Jezus: “Waar komt U vandaan?” Maar Jezus gaf geen antwoord. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Toen zei Pilatus: “Zegt U niets tegen mij? Weet U niet dat ik het gezag heb om U vrij te laten, maar ook het gezag om U te laten kruisigen?” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jezus antwoordde: “U zou geen enkel gezag over Mij hebben als het u niet van boven zou zijn geschonken. Daarom draagt degene die Mij aan u heeft uitgeleverd meer schuld dan u.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus probeerde nogmaals Jezus vrij te laten, maar de Joodse mensen schreeuwden: “Als u die Man vrijlaat, bent u geen vriend van de keizer. Want ieder die zichzelf tot koning uitroept, is een tegenstander van de keizer.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Toen Pilatus die woorden hoorde, liet hij Jezus naar buiten leiden en ging hij op de rechterstoel zitten, op een plaats die het Mozaïekterras genoemd wordt, of Gabbata in het Aramees. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Het was Voorbereidingsdag, de dag voor Pesach. Het was ongeveer twaalf uur. Pilatus zei tegen de Joodse mensen: “Dit is jullie koning.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Maar ze schreeuwden: “Weg met Hem! Weg met Hem! Kruisig Hem!” Pilatus vroeg hun: “Moet ik jullie koning dan laten kruisigen?” De hoofdpriesters antwoordden: “De enige koning die wij hebben is de keizer!” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Toen droeg Pilatus Jezus aan hen over om te worden gekruisigd en zij leidden Hem weg. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jezus droeg zelf zijn kruis toen Hij de stad verliet, naar de zogeheten Schedelplaats, die in het Aramees Golgota wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Daar werd Hij gekruisigd, samen met twee anderen, één aan elke kant met Jezus in het midden. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus had een bordje laten maken dat op het kruis werd aangebracht; er stond op: “Jezus van Nazaret, de koning van de Joden.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Het was geschreven in het Aramees, het Latijn en het Grieks. Omdat de plaats waar Jezus werd gekruisigd dicht bij de stad lag, werd dit opschrift door veel van de Joodse mensen gelezen. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","De Joodse hoofdpriesters protesteerden bij Pilatus: “Er moet niet staan: ‘de koning van de Joden’, maar: ‘Hij beweerde: Ik ben de koning van de Joden.’” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus antwoordde: “Wat ik heb laten schrijven, blijft er staan.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nadat ze Jezus hadden gekruisigd, namen de soldaten zijn kledij in beslag. De bovenkledij werd in vieren gedeeld en elke soldaat kreeg een deel. Maar zijn onderkleed was naadloos, in een stuk van boven naar onder geweven. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Daarom zeiden ze tegen elkaar: “Laten we het niet in stukken scheuren, maar onder elkaar verloten.” Zo ging in vervulling wat in de Schriften staat: “Mijn kleren hebben ze onder elkaar verdeeld en mijn kledij hebben ze verloot.” Dat was precies wat de soldaten deden. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Dicht bij het kruis van Jezus stonden zijn moeder, de zuster van zijn moeder, Maria de vrouw van Klopas, en Maria van Magdala. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Toen Jezus zijn moeder zag staan, en naast haar de leerling van wie Hij veel hield, zei Hij tegen zijn moeder: “Kijk, hij is je zoon.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Daarna zei Hij tegen die leerling: “Kijk, zij is je moeder.” Toen nam de leerling haar bij zich in huis. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Daarna zei Jezus, omdat Hij wist dat Hij zijn werk had voltooid: “Ik heb dorst.” Hij zei dit opdat de Schriften in vervulling zouden gaan. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Er stond daar een vat met zure wijn. Iemand doopte een spons in die zure wijn, stak de spons op een hyssopstengel en bracht die omhoog naar Jezus' lippen. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nadat Jezus er wat van had gedronken, zei Hij: “Het is voltooid.” Toen boog Hij zijn hoofd en stierf Hij. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Omdat het Voorbereidingsdag was en de Joodse mensen niet wilden dat de lichamen tijdens de sabbat – en dan nog wel een bijzondere sabbat – aan het kruis zouden blijven hangen, verzochten ze Pilatus dat de benen van de gekruisigden gebroken zouden worden en de lichamen verwijderd. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Toen kwamen de soldaten de benen breken van de ene en van de andere man die samen met Jezus waren gekruisigd. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Maar toen ze bij Jezus kwamen, zagen ze dat Hij reeds was gestorven en braken ze zijn benen niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wel stak een van de soldaten met een speer in zijn zij. Er kwam meteen bloed en water uit. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dit is de getuigenis van iemand die het zelf heeft gezien en zijn getuigenis is betrouwbaar. Hij weet dat hij de waarheid spreekt en hij doet dat opdat ook jullie het geloven. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dit is gebeurd als vervulling van hetgeen in de Schriften staat: “Geen van zijn beenderen zal worden verbrijzeld.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","En op een andere plaats in de Schriften staat: “Ze zullen naar Hem kijken die ze hadden doorstoken.” ");
INSERT INTO nldgbv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Daarna verzocht Jozef van Arimatea – hij was een leerling van Jezus, maar in het geheim, omdat hij bang was voor de Joodse leiders – Pilatus om toelating om Jezus' lichaam op te halen. Pilatus liet het toe en dus kwam Jozef Jezus' lichaam ophalen. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ook kwam Nikodemus – de man die ooit 's nachts bij Jezus was gekomen – een mengsel van mirre en aloë brengen, dat ongeveer dertig kilo woog. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ze wikkelden Jezus' lichaam met de balsem in linnen doeken, zoals gebruikelijk is bij een Joodse begrafenis. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Vlak bij de plaats waar Jezus was gekruisigd, bevond zich een tuin met daarin een nieuw graf, waarin nog niemand was bijgezet. ");
INSERT INTO nldgbv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Omdat het voor de Joodse mensen Voorbereidingsdag was en het graf dichtbij was, legden ze Jezus daarin. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Vroeg op de eerste dag van de week, toen het nog donker was, ging Maria van Magdala naar het graf. Ze zag dat de steen voor de ingang van het graf was verwijderd. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ze rende naar Simon Petrus en naar een andere leerling van Jezus, de leerling van wie Hij veel hield, en zei tegen hen: “De Heer is uit het graf weggenomen en we weten niet waar Hij is neergelegd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Toen gingen Petrus en die andere leerling naar het graf. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ze renden samen, maar de andere leerling was sneller dan Petrus en kwam als eerste bij het graf aan. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hij boog zich voorover, keek naar binnen en zag de windsels liggen, maar ging niet naar binnen. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Toen kwam ook Simon Petrus, die achter hem had gelopen. Hij ging het graf binnen en zag de doeken liggen. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","De doek die om Jezus' hoofd gewikkeld was geweest, bevond zich niet bij de andere doeken maar lag opgerold apart. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nu ging de andere leerling, die als eerste bij het graf was aangekomen, ook naar binnen. Hij keek en hij geloofde. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Maar ze begrepen nog niet dat in de Schriften staat dat Jezus uit de dood moest verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Zijn leerlingen gingen terug naar huis, ");
INSERT INTO nldgbv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","terwijl Maria bij het graf stond te wenen. Al wenend boog ze voorover om in het graf te kijken. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Daar zag ze twee in het wit geklede engelen zitten op de plaats waar Jezus' lichaam had gelegen, de ene aan het hoofdeinde en de andere aan het voeteneinde. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ze vroegen haar: “Waarom huil je?” Ze antwoordde: “Mijn Heer is weggenomen en ik weet niet waar Hij is neergelegd.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nadat ze dat had gezegd, keek ze om en zag ze Jezus staan, maar ze besefte niet dat Hij het was. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jezus vroeg haar: “Waarom huil je? Wie zoek je?” Ze dacht dat Hij de tuinman was en antwoordde: “Meneer, als u hem hebt verplaatst, vertel me dan waar u Hem hebt neergelegd. Dan zal ik Hem laten ophalen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jezus zei tegen haar: “Maria”. Toen keerde ze zich naar Hem toe en zei in het Aramees: “Rabboeni”. Dat betekent: Leraar. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jezus zei tegen haar: “Laat Me los, want Ik ben nog niet naar mijn Vader opgestegen. Maar ga naar mijn broeders toe en zeg tegen hen: ‘Ik ga terug naar mijn Vader, die ook jullie Vader is, naar mijn God die ook jullie God is.’” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria van Magdala ging naar Jezus' leerlingen en verkondigde: “Ik heb de Heer gezien.” Ook vertelde ze wat Hij tegen haar had gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Op de avond van diezelfde dag, de eerste dag van de week, toen Jezus' leerlingen bijeenkwamen en de deur op slot hadden gedaan uit angst voor de Joodse leiders, kwam Hij in hun midden staan. Hij zei tegen hen: “Ik wens jullie vrede toe.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nadat Hij dat had gezegd, toonde Hij hun zijn handen en zijn zij. De leerlingen waren verheugd om de Heer te zien. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jezus vervolgde: “Ik wens jullie vrede toe. Zoals de Vader Mij heeft gezonden, zend Ik jullie.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nadat Hij dat had gezegd, blies Hij over hen en zei Hij: “Ontvang de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Als jullie iemands zonden vergeven, dan zijn ze vergeven. Maar als jullie iemands zonden niet vergeven, dan blijven die zonden hem toegerekend.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Een van de Twaalf, Tomas bijgenaamd Didymus, was er niet toen Jezus bij hen was gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Toen de andere leerlingen hem vertelden: “Wij hebben de Heer gezien”, antwoordde hij: “Zolang ik de wonden van de spijkers in zijn handen niet heb gezien, de plaats waar de spijkers hebben gezeten niet met mijn vinger heb aangeraakt en met mijn hand niet zijn zij heb gevoeld, geloof ik het niet.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Een week later waren Jezus' leerlingen opnieuw bijeen en was ook Tomas erbij. Hoewel de deuren op slot waren, kwam Hij in hun midden staan. Hij zei: “Ik wens jullie vrede toe.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Toen zei Hij tegen Tomas: “Geef je vinger hier en bekijk mijn handen; geef Me je hand en leg die in mijn zij. Wees niet langer ongelovig, maar geloof.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas antwoordde: “Mijn Heer, mijn God!” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jezus vervolgde: “Je gelooft omdat je Mij hebt gezien? Gezegend zijn zij die geloven zonder te hebben gezien.” ");
INSERT INTO nldgbv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jezus heeft in het bijzijn van zijn leerlingen nog veel meer wonderlijke tekenen verricht, maar die staan niet in dit boek vermeld. ");
INSERT INTO nldgbv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wat wel in dit boek staat, is op schrift gesteld met de bedoeling dat jullie geloven dat Jezus de Messias is, de Zoon van God, en dat jullie, door te geloven, leven zullen bezitten omdat jullie bij Hem horen. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Later vertoonde Jezus zich nogmaals aan zijn leerlingen, bij het Meer van Tiberias. Dat gebeurde als volgt: ");
INSERT INTO nldgbv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus, Tomas die Didymus wordt genoemd, Natanaël uit Kana in Galilea, de zonen van Zebedeüs en nog twee van Jezus' leerlingen waren bijeen. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus zei: “Ik ga vissen.” De anderen zeiden: “Wij komen met je mee.” Ze gingen naar de boot en stapten in, maar die nacht vingen ze niets. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Toen de ochtend aanbrak, stond Jezus op de oever, maar de leerlingen beseften niet dat het Jezus was. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jezus vroeg hen: “Hebben jullie niets gevangen?” Ze antwoordden: “Nee.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hij zei tegen hen: “Werp het net uit aan de rechterkant van de boot. Dan zullen jullie wél vis vangen.” Ze wierpen het net uit en toen zat er zoveel vis in dat ze het niet terug aan boord konden krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Toen zei de leerling van wie Jezus veel hield tegen Petrus: “Het is de Heer.” Toen Simon Petrus hoorde dat het de Heer was, trok hij zijn bovenkleed aan – want hij was nauwelijks gekleed – en sprong in het water. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","De andere leerlingen voeren erheen in het bootje, terwijl ze het net met de vissen meesleepten. Ze bevonden zich namelijk niet ver van de oever, op bijna honderd meter afstand. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Toen ze uitstapten, de oever op, zagen ze dat daar een vuur was aangelegd. Er lag vis op en er was ook brood. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jezus zei tegen hen: “Breng wat van de vissen die jullie hebben gevangen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus ging weer aan boord en trok het net aan land. Het zat vol grote vissen: wel 153, en toch scheurde het niet. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jezus zei tegen hen: “Kom eten.” Geen van zijn leerlingen durfde Hem te vragen: “Wie bent U?”, want ze beseften dat het de Heer was. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jezus kwam dichterbij, nam het brood en gaf hun ervan. Hetzelfde deed Hij met de vis. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dit was de derde keer dat Jezus zich aan zijn leerlingen vertoonde nadat Hij uit de dood was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nadat ze hadden gegeten, zei Jezus tegen Simon Petrus: “Simon, zoon van Johannes, heb jij Mij meer lief dan de anderen hier?” Hij antwoordde: “Ja Heer, U weet dat ik van U hou.” Jezus zei: “Weid mijn lammeren.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jezus vroeg hem een tweede keer: “Simon, zoon van Johannes, heb jij Mij lief?” Hij antwoordde: “Ja Heer, U weet dat ik van U hou.” Jezus zei tegen hem: “Weid mijn schapen.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jezus vroeg hem voor de derde keer: “Simon, zoon van Johannes, hou jij van Mij?” Petrus werd bedroefd omdat Jezus hem voor de derde keer vroeg: “Hou jij van Mij?” Hij antwoordde: “Heer, U weet alles. U weet dat ik van U hou.” Jezus zei tegen hem: “Weid mijn schapen. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ik zeg je nadrukkelijk, toen je jonger was, deed je zelf je gordel om en ging je naar de plaats waar je wilde zijn. Maar wanneer je oud bent geworden, zal je je handen uitstrekken en een ander zal jou je gordel omdoen en je naar een plaats brengen waar je niet wil zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jezus zei dit om aan te geven hoe Petrus zou sterven tot eer van God. Vervolgens zei Hij tegen hem: “Volg Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus draaide zich om en zag dat de leerling van wie Jezus veel hield hen volgde. Dit was ook de leerling die zich tijdens het Pesachmaal naast Jezus aan tafel had bevonden en die zich naar Hem toe gebogen had om te vragen: “Heer, wie is het die U zal verraden?” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Toen Petrus hem zag, vroeg hij aan Jezus: “Heer, wat zal er met hem gebeuren?” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jezus antwoordde: “Als Ik wil dat hij hier blijft totdat Ik terugkom, is dat jouw zaak toch niet? Zorg jij maar dat je Mij volgt.” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Zo ontstond onder de christenen het gerucht dat die leerling niet zou sterven. Jezus had echter niet tegen Petrus gezegd dat hij niet zou sterven, maar: “Als Ik wil dat hij hier blijft totdat Ik terugkom, is dat jouw zaak toch niet?” ");
INSERT INTO nldgbv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dat was dezelfde leerling die deze dingen verklaart en ze op schrift heeft gesteld. En zoals wij weten is deze getuigenis betrouwbaar. ");
INSERT INTO nldgbv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jezus heeft nog veel andere dingen gedaan. Als die allemaal op schrift gesteld zouden worden, zou de wereld volgens mij te klein zijn voor de boeken die dan geschreven zouden worden.");
INSERT INTO nldgbv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Aan Theofilus. In mijn eerste werk beschreef ik alles wat Jezus heeft gedaan en onderwezen, vanaf het begin ");
INSERT INTO nldgbv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tot de dag dat Hij in de hemel werd opgenomen, nadat Hij door de kracht van de Heilige Geest instructies had gegeven aan de apostelen die Hij had gekozen. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na zijn lijden had Jezus de apostelen veertig dagen lang getoond dat Hij leefde, door dikwijls aan hen te verschijnen en hun te vertellen over Gods koninkrijk. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Terwijl ze een keer samen de maaltijd gebruikten, gaf Hij hun de opdracht: “Vertrek niet uit Jeruzalem, maar wacht op de vervulling van de belofte van mijn Vader waarover Ik jullie heb verteld. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Want Johannes doopte met water, maar jullie zullen over enkele dagen worden gedoopt met de Heilige Geest.” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zij die waren samengekomen, vroegen Hem: “Heer, gaat U ongeveer nu het koningschap van Israël herstellen?” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hij antwoordde: “Jullie hoeven de tijden en momenten niet te kennen die de Vader op grond van zijn eigen gezag heeft bepaald. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Maar wanneer de Heilige Geest over jullie komt, zullen jullie kracht ontvangen en mijn getuigen worden, zowel in Jeruzalem als in heel Judea en Samaria, zelfs tot in de uithoeken van de aarde.” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Na dit te zeggen werd Hij voor hun ogen weggenomen naar omhoog, en een wolk nam Hem uit hun zicht. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Terwijl Hij bij hen vandaan ging en ze nog naar de hemel tuurden, stonden er opeens twee mannen in witte kleren bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ze zeiden: “Galileeërs, wat staan jullie naar de hemel te kijken? Deze Jezus, die van bij jullie in de hemel is opgenomen, zal op dezelfde wijze terugkomen als jullie Hem naar de hemel hebben zien gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Toen keerden de apostelen naar Jeruzalem terug, vanaf de berg die Olijfberg heet en dicht bij Jeruzalem ligt – op een sabbatsreis verwijderd. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Daar aangekomen gingen ze naar de bovenzaal waar ze verbleven. Dit waren Petrus, Johannes, Jakobus en Andreas, Filippus, Tomas, Bartolomeüs en Matteüs, Jakobus, de zoon van Alfeüs, Simon de Zeloot en Judas, de zoon van Jakobus. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Zij waren allen voortdurend en eensgezind aan het bidden, samen met een aantal vrouwen, waaronder Jezus' moeder Maria, en met zijn broers. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Het was in die periode dat Petrus te midden van de gelovigen – een groep van ongeveer 120 personen – opstond en zei: ");
INSERT INTO nldgbv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Geloofsgenoten, het Schriftgedeelte moest in vervulling gaan, waarin de Heilige Geest bij monde van David profeteerde over Judas, die de mensen die Jezus arresteerden naar Hem toe geleid heeft. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas werd als een van ons beschouwd en had een aandeel in onze dienende taak gekregen. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hij kocht een stuk grond met het loon voor het kwaad dat hij had gedaan. Daar viel hij voorover, zijn lichaam scheurde open en zijn ingewanden puilden naar buiten. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dat raakte bekend onder alle inwoners van Jeruzalem. Daarom heet dat stuk grond in hun taal Akeldama, wat ‘bloedgrond’ betekent. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Want in het boek Psalmen staat: ‘Laat zijn woonplaats verlaten zijn en laat er niemand wonen’ en ‘Laat een ander zijn positie als verantwoordelijke overnemen’. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Daarom moet iemand anders, die de hele tijd bij ons is geweest toen de Heer Jezus onder ons leefde – ");
INSERT INTO nldgbv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","te beginnen met zijn doop door Johannes tot de dag dat Hij bij ons is weggenomen naar omhoog – samen met ons getuige van zijn verrijzenis zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Er werden twee kandidaten voorgesteld: Jozef Barsabbas die ook wel Justus werd genoemd, en Mattias. ");
INSERT INTO nldgbv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","De gelovigen baden: “Heer, U kent de harten van alle mensen, wilt U aanwijzen wie van deze twee U heeft uitgekozen ");
INSERT INTO nldgbv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","om de dienende taak als apostel over te nemen van Judas, die deze positie heeft verlaten en nu op de plaats is die hem toekomt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Er werd tussen hen geloot en het lot viel op Mattias. Zo werd hij een apostel, samen met de andere elf. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Toen de dag van Pinksteren was aangebroken, waren ze allen op één plaats bij elkaar. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Plots kwam uit de hemel een geluid dat leek op dat van een hevige windvlaag. Het vulde het hele huis waar ze zich bevonden. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Toen verscheen bij hen iets dat leek op vlammen die zich verspreidden en op elk van hen bleven rusten. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ze raakten allen vervuld van de Heilige Geest en begonnen te spreken in vreemde talen, zoals de Geest het hun ingaf om uit te spreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nu woonden er in Jeruzalem Joodse mensen die God respecteerden en die uit alle landen in de wereld afkomstig waren. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Toen dit gebeurde, kwamen velen van hen op het geluid af; ze waren verbaasd dat iedereen hen in zijn eigen taal hoorde spreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Verwonderd en perplex vroegen ze: “Maar die mensen die daar spreken zijn toch allen Galileeërs? ");
INSERT INTO nldgbv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hoe kan het dan dat ieder van ons hen hoort in de taal van zijn geboortestreek? ");
INSERT INTO nldgbv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parten, Meden, Elamieten, inwoners van Mesopotamië, Judea, Kappadocië, Pontus, Asia, ");
INSERT INTO nldgbv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygië, Pamfylië, Egypte en de streek rondom Cyrene in Libië, maar ook bezoekers uit Rome ");
INSERT INTO nldgbv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","– zowel Joden als mensen die zich tot het jodendom hadden bekeerd – en Kretenzen en Arabieren, we horen hen in onze eigen talen spreken over Gods machtige daden!” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Verwonderd en verward vroegen ze elkaar: “Wat zou dit toch betekenen?” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Anderen zeiden echter spottend: “Ze hebben te veel zoete wijn gedronken.” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Toen stond Petrus op, samen met de andere apostelen, en sprak hen op luide toon toe: “Joden en alle inwoners van Jeruzalem, luister en laat mijn woorden goed tot jullie doordringen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Deze mensen zijn niet dronken zoals jullie denken, want het is nog maar negen uur in de ochtend! ");
INSERT INTO nldgbv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wat hier gebeurt, is wat door de profeet Joël werd aangekondigd: ");
INSERT INTO nldgbv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tegen het einde van de tijd, zegt God, zal Ik mijn Geest uitstorten over alle mensen. Jullie zonen en dochters zullen profeteren; jullie jongeren zullen visioenen krijgen en jullie ouderen dromen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","In die dagen stort Ik mijn Geest uit over mijn dienaren en dienaressen en zij zullen profeteren. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ik zal wonderen doen in de hemel boven en tekenen op de aarde beneden: bloed, vuur en rookpluimen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","De zon zal duister worden en de maan bloedrood, voordat de grote en glorierijke Dag van de Heer aanbreekt. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","En het zal zo zijn dat ieder die de Heer aanroept, gered zal worden.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israëlieten, luister naar dit nieuws: God heeft jullie gewezen op Jezus van Nazaret. Zoals jullie weten heeft God immers door deze Man machtige daden, wonderen en tekenen gedaan waar jullie zelf bij waren. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","En overeenkomstig Gods onveranderlijke plan en voorkennis werd Jezus aan jullie overgeleverd. Jullie hebben Hem door slechte mensen laten kruisigen en doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","God heeft Hem echter tot leven gewekt en Hem zo bevrijd van de kwelling van de dood, want het was onmogelijk dat Hij in zijn greep zou blijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David schreef namelijk over Hem: ‘Ik hield de Heer voortdurend voor ogen. Omdat Hij aan mijn zijde is, wankel ik niet. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Daarom is mijn hart blij en jubelt mijn tong. Mijn hele lichaam leeft in hoop, ");
INSERT INTO nldgbv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","want U laat mijn ziel niet in het dodenrijk achter en U laat uw toegewijde niet tot ontbinding overgaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U maakt de paden van het leven aan mij bekend, U vervult mij met vreugde door uw aanwezigheid.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Volksgenoten, wat onze voorvader David betreft kan ik jullie met stelligheid zeggen dat hij gestorven en begraven is en dat zijn graf vandaag nog bij ons is. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Maar hij was een profeet en hij wist dat God hem had gezworen dat een van zijn afstammelingen op zijn troon zou zitten. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hij voorzag de verrijzenis van de Messias en zei dat Hij niet in het dodenrijk zou worden achtergelaten en dat zijn lichaam niet tot ontbinding zou overgaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Deze Jezus is door God weer tot leven gewekt; wij allen zijn daar getuige van. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hij is verheven naar Gods rechterzijde, ontving de Heilige Geest die de Vader had beloofd, en heeft geschonken wat jullie nu zien en horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Want David is niet naar de hemel gegaan, maar toch zegt hij: ‘De Heer zei tegen mijn Heer: Neem plaats aan Mijn rechterzijde, ");
INSERT INTO nldgbv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","totdat Ik je vijanden aan je heb onderworpen.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Daarom mogen alle Israëlieten er zeker van zijn dat God deze Jezus, die jullie hadden gekruisigd, tot zowel Heer als Messias heeft aangesteld.” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Toen de mensen dit hoorden, werden ze diep in hun harten geraakt en vroegen ze Petrus en de andere apostelen: “Vrienden, wat moeten we doen?” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus antwoordde: “Jullie moeten allemaal tot inkeer komen en je laten dopen in de naam van Jezus Christus, opdat jullie zonden worden vergeven en jullie als geschenk de Heilige Geest ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Want de belofte geldt voor jullie, voor jullie kinderen en voor alle mensen ver weg, voor iedereen die de Heer onze God zal roepen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hij vervolgde zijn getuigenis met nog meer argumenten en spoorde hen aan: “Laat je redden uit deze corrupte wereld!” ");
INSERT INTO nldgbv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","De mensen die Petrus' boodschap aanvaardden, werden gedoopt. Die dag werd hun aantal uitgebreid met ongeveer drieduizend personen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ze wijdden zich aan het onderwijs van de apostelen, het onderling samenzijn, de gezamenlijke maaltijd en de gebeden. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","De vele wonderen en tekenen die door de apostelen werden gedaan, vervulden iedereen met ontzag. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Alle gelovigen bleven bijeen en hadden alles gemeenschappelijk. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ze verkochten eigendommen en bezittingen en verdeelden de opbrengst naar behoefte onder iedereen. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Elke dag kwamen ze trouw en eensgezind bijeen op het tempelterrein; thuis braken ze het brood en aten ze gezamenlijk met een blij en oprecht hart. ");
INSERT INTO nldgbv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ze loofden God en het hele volk was hen gunstig gezind. En elke dag werden meer mensen gered en door de Heer aan hen toegevoegd. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Op een dag waren Petrus en Johannes onderweg naar het tempelterrein. Het was 3 uur 's middags, de tijd van het gebed. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ook werd er een man daarheen gedragen, die vanaf zijn geboorte aan zijn voeten verlamd was. Hij werd elke dag naar de tempelpoort gebracht die Schone Poort heet, zodat hij om aalmoezen kon vragen aan de mensen die het tempelterrein opgingen. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Toen hij zag dat Petrus en Johannes het tempelterrein zouden opgaan, vroeg hij hen om een aalmoes. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petrus en Johannes keken hem in de ogen en Petrus zei: “Kijk ons eens aan.” ");
INSERT INTO nldgbv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hij vestigde zijn aandacht op hen in de verwachting iets van hen te krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Toen zei Petrus: “Goud of zilver heb ik niet, maar ik geef je wat ik wel heb. In naam van Jezus Christus van Nazaret: sta op en wandel!” ");
INSERT INTO nldgbv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hij greep hem bij zijn rechterhand en hielp hem overeind. Op hetzelfde moment werden zijn voeten en enkels gezond. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hij sprong op, ging overeind staan en begon te stappen. Toen ging hij met hen het tempelterrein op, waar hij rondwandelde, sprong en God prees. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Alle mensen die daar waren, zagen hem wandelen en God prijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ze herkenden hem als de man die altijd om aalmoezen vroeg bij de Schone Poort van de tempel, en ze waren vol verwondering en verbijstering over wat er met hem was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Terwijl hij zich aan Petrus en Johannes vastklampte, stroomden alle mensen die daar waren nieuwsgierig naar hen toe, op de plaats die de Zuilengalerij van Salomo heet. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Toen Petrus dat zag, sprak hij de mensen toe: “Israëlieten, waarom verbazen jullie je hierover en waarom staren jullie ons aan alsof het door onze kracht of godsdienstigheid is dat deze man nu kan wandelen? ");
INSERT INTO nldgbv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","De God van Abraham, Isaak en Jakob, de God van onze voorvaders, heeft zijn dienaar Jezus verheerlijkt, die door jullie was uitgeleverd en afgewezen voor de ogen van Pilatus, zelfs toen die Hem wilde vrijlaten. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jullie hebben de Heilige en Rechtvaardige afgewezen en vroegen om gratie voor een moordenaar. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jullie hebben de Gever van het leven vermoord, maar God heeft Hem uit de dood doen verrijzen, en wij zijn daarvan getuige. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Op basis van het geloof in de kracht van Jezus is deze man, die jullie zien en kennen, sterk geworden. Het is dankzij de kracht van Jezus en het geloof dat Hij schenkt, dat deze man volkomen gezond is geworden in het bijzijn van jullie allen. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Volksgenoten, ik weet dat jullie – en ook jullie leiders – uit onwetendheid hebben gehandeld. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Maar zo heeft God vervuld wat Hij vooraf had aangekondigd bij monde van alle profeten, namelijk dat zijn Messias zou lijden. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kom dus tot inkeer en bekering, opdat jullie zonden worden uitgewist ");
INSERT INTO nldgbv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","en opdat de Heer tijden van rust zal geven en Hij de Messias zal zenden, die reeds voor jullie is aangesteld: Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jezus moet in de hemel blijven tot het tijdstip waarop God alle dingen herstelt, zoals Hij lang geleden bij monde van de heilige profeten heeft beloofd. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mozes zei immers al: ‘De Heer jullie God zal uit jullie eigen mensen een profeet voor jullie doen opstaan die is zoals ik; luister naar alles wat Hij jullie vertelt. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ieder die niet naar die profeet luistert, zal uit het volk worden verwijderd.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","En inderdaad hebben alle profeten, vanaf Samuel en zijn opvolgers, in hun uitspraken de huidige periode aangekondigd. ");
INSERT INTO nldgbv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jullie zijn de erfgenamen van de profeten en van het verbond dat God met jullie voorouders heeft gesloten. Hij zei tegen Abraham: ‘Door jouw afstammelingen zullen alle volken op aarde worden gezegend.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nu God zijn dienaar heeft doen verrijzen, heeft Hij Hem eerst naar jullie gezonden om jullie te zegenen door elk van jullie van zijn slechte levenswandel af te brengen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Terwijl Petrus en Johannes het volk toespraken, kwamen de priesters, de sadduceeën en het hoofd van de tempelwacht op hen af. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ze ergerden zich omdat Petrus en Johannes, door het volk over Jezus te onderwijzen, de verrijzenis uit de dood verkondigden. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ze arresteerden hen en omdat het al avond was, zetten ze hen gevangen tot de volgende dag. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Maar veel van de mensen die de toespraak hadden gehoord, kwamen tot geloof en het aantal gelovigen nam toe tot ongeveer vijfduizend. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","De volgende dag kwamen de Joodse leiders, oudsten en Schriftgeleerden in Jeruzalem bijeen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas de hogepriester was erbij, en ook Kajafas, Johannes, Alexander en de overige leden van de familie van de hogepriester. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ze lieten Petrus en Johannes voorleiden en vroegen hen: “Door welke kracht of in wiens naam hebben jullie dit gedaan?” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus raakte vervuld van de Heilige Geest en zei tegen hen: “Leiders en oudsten van het volk, ");
INSERT INTO nldgbv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","als wij vandaag worden verhoord vanwege een goede daad die wij hebben verricht voor een persoon met een handicap, zodat hij daarvan is genezen, ");
INSERT INTO nldgbv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dan moet u allen – en ook het hele volk Israël – weten dat deze persoon gezond voor u staat door de kracht van Jezus Christus van Nazaret, die u heeft gekruisigd maar die God uit de dood heeft doen verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jezus is de steen die door u, de bouwers, werd afgekeurd maar die de hoeksteen is geworden. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Het is door Hem dat we gered moeten worden; de redding is bij niemand anders te vinden. Er is in de hele wereld geen enkele andere redder voor de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Toen ze de vrijmoedigheid van Petrus en Johannes zagen en beseften dat dit niet-opgeleide, gewone mannen waren, waren ze verbijsterd. Ze herkenden hen als mensen die met Jezus hadden opgetrokken. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","En omdat ze de genezen persoon bij hen zagen staan, hadden ze geen weerwoord. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ze stuurden hen de zaal uit en overlegden met elkaar. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ze zeiden: “Wat zullen we met deze mensen doen? Voor alle inwoners van Jeruzalem is het duidelijk dat er door hen een opmerkelijk teken is verricht. Dat kunnen we niet ontkennen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Laten we, om te voorkomen dat dit verder onder het volk bekend raakt, hen waarschuwen dat ze in geen geval nog iemand in zijn naam mogen toespreken.” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ze riepen hen binnen en verboden hun streng om in de naam van Jezus te spreken of te onderwijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maar Petrus en Johannes antwoordden: “Is het correct tegenover God om naar u te luisteren in plaats van naar Hem? Oordeelt u zelf! ");
INSERT INTO nldgbv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wij kunnen echter niet zwijgen over wat we hebben gezien en gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nadat ze Petrus en Johannes verder dreigend hadden toegesproken, lieten ze hen vrij, omdat ze geen manier konden vinden om hen te straffen. Dat kwam door het volk: iedereen verheerlijkte God voor wat er was gebeurd. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","De man die door dit wonder was genezen, was meer dan veertig jaar oud. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na hun vrijlating gingen Petrus en Johannes naar hun eigen mensen om verslag uit te brengen van wat de hoofdpriesters en oudsten tegen hen hadden gezegd. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Toen zij het hoorden, baden ze eensgezind luidop tot God: “Machtige Heer, U bent de Maker van de hemel, de aarde en de zee met alles wat daarin. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Door de Heilige Geest sprak U bij monde van uw dienaar en onze voorvader David: ‘Waarom gaan de vreemde volken tekeer en smeden ze dwaze plannen? ");
INSERT INTO nldgbv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","De koningen van de aarde stellen zich op en de heersers verzamelen zich tegen de Heer en zijn Messias.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Want inderdaad hebben Herodes, Pontius Pilatus, de niet-Joden en het volk Israël zich in deze stad tegen uw heilige Dienaar Jezus, uw Gezalfde, verzameld ");
INSERT INTO nldgbv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","om te doen wat U, in uw macht en volgens uw wil, reeds had besloten dat er zou gebeuren. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","En nu, Heer, kijk naar hun dreigementen en stel uw nederige dienaren in staat om in alle vrijmoedigheid uw Woord te verkondigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Strek uw hand uit om te genezen en doe tekenen en wonderen door de kracht van uw heilige dienaar Jezus.” ");
INSERT INTO nldgbv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nadat ze hadden gebeden, beefde de plaats waar ze bijeen waren. Ze raakten allen vervuld van de Heilige Geest en verkondigden vrijmoedig het Woord van God. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","De groep gelovigen was volkomen eensgezind en niemand beschouwde zijn eigendommen als zijn eigen bezit, maar ze hadden alles gemeenschappelijk. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","De apostelen bleven met grote kracht getuigen over de verrijzenis van de Heer Jezus, en Zijn rijke genade rustte op hen allen. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ook leed niemand onder hen gebrek. Er waren namelijk eigenaars die hun land of huizen verkochten en de opbrengst daarvan ");
INSERT INTO nldgbv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ter beschikking van de apostelen stelden; het werd naar behoefte onder iedereen verdeeld. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Er was een leviet die uit Cyprus afkomstig was, Jozef, die door de apostelen Barnabas werd genoemd, wat “zoon van bemoediging” betekent. ");
INSERT INTO nldgbv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hij bezat een akker en verkocht die. De opbrengst bracht hij bij de apostelen en stelde het hun ter beschikking. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iemand die Ananias heette, verkocht samen met zijn vrouw Saffira een stuk grond. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Met medeweten van zijn vrouw hield hij een deel van de opbrengst achter. De rest bracht hij naar de apostelen en stelde het hun ter beschikking. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Maar Petrus zei: “Ananias, hoe is het mogelijk dat de satan je hart heeft vervuld, zodat je de Heilige Geest probeert te bedriegen door een deel van de opbrengst van het stuk grond achter te houden? ");
INSERT INTO nldgbv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vóór de verkoop was het toch jouw eigendom? En erna beschikte je toch zelf over de opbrengst? Hoe is het mogelijk dat je tot het besluit was gekomen om dit te doen? Je hebt niet tegen mensen gelogen, maar tegen God.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Toen Ananias deze woorden hoorde, viel hij neer en stierf. En ieder die ervan hoorde, schrok hevig. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","De jonge mannen wikkelden hem in doeken, droegen hem weg en begroeven hem. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ongeveer drie uur later kwam zijn vrouw binnen. Zij wist niet wat er gebeurd was. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus vroeg haar: “Vertel eens, hebben jullie het stuk grond voor dit bedrag verkocht?” Zij antwoordde: “Ja, voor dit bedrag.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Toen zei Petrus tegen haar: “Hoe is het mogelijk dat jullie met elkaar hebben afgesproken om de Geest van de Heer op de proef te stellen? De voetstappen van de mensen die je man hebben begraven zijn al te horen bij de deur. En ook jou zullen ze wegdragen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Op hetzelfde moment viel ze voor zijn voeten neer en stierf. Toen de jongemannen binnenkwamen, troffen ze haar dood aan. Ze droegen haar weg en begroeven haar bij haar man. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","De hele kerkgemeenschap en ieder die ervan hoorde, werd erg bang. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","De apostelen verrichtten veel tekenen en wonderen onder het volk. Alle gelovigen kwamen eensgezind bijeen in de Zuilengalerij van Salomo. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Van de anderen durfde niemand zich bij hen aan te sluiten, maar het volk sprak lovend over hen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Toch kwamen nog meer mannen én vrouwen tot het geloof in de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Men droeg zelfs de zieken de straat op en legde hen daar op bedden en matten, in de hoop dat ten minste Petrus' schaduw in het voorbijgaan op sommigen van hen zou vallen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ook uit de plaatsen rondom Jeruzalem kwamen grote aantallen mensen naar hen toe. Ze brachten zieken en door onreine geesten gekwelden mee en die werden allen genezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Toen kwam de hogepriester in actie met al zijn medestanders; dat waren de sadduceeën. Vervuld van afgunst ");
INSERT INTO nldgbv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","arresteerden ze de apostelen en sloten ze hen op in de gevangenis. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Maar 's nachts opende een engel van de Heer de gevangenisdeuren en leidde hen naar buiten. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Hij zei: “Ga op het tempelterrein staan en vertel al het nieuws over dit nieuwe leven aan de mensen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","De apostelen luisterden; rond zonsopgang gingen ze het tempelterrein op en onderwezen verder. Inmiddels kwamen de hogepriester en zijn medestanders aan. Ze riepen de hele Joodse raad – de voltallige raad van oudsten van de Israëlieten – bijeen en gaven opdracht om de apostelen op te halen uit de gevangenis. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Maar toen de tempelwachters in de gevangenis aankwamen, vonden ze hen daar niet. Ze gingen terug en brachten verslag uit: ");
INSERT INTO nldgbv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“We stelden vast dat de gevangenis zorgvuldig afgesloten was, en de bewakers stonden bij de deuren, maar toen we die openden, troffen we binnen niemand aan.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Toen het hoofd van de tempelwacht en de hoofdpriesters die woorden hoorden, vroegen ze zich vertwijfeld af wat er aan de hand was. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Toen kwam iemand hen verwittigen: “De mannen die u gevangen had gezet, staan op het tempelterrein het volk te onderwijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Het hoofd van de tempelwacht ging er met zijn agenten op af en haalde de apostelen op zonder gebruik van geweld, want ze waren bang dat het volk hen anders zou stenigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","De opgehaalde apostelen werden voor de Joodse raad geleid. De hogepriester vroeg hun: ");
INSERT INTO nldgbv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Wij hebben jullie toch streng verboden om in de naam van die Man te onderwijzen? Maar nu zijn jullie bezig om jullie leer in heel Jeruzalem te verspreiden en willen jullie ons aansprakelijk stellen voor zijn dood!” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus en de andere apostelen antwoordden: “Men moet God meer gehoorzamen dan de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","De God van onze voorouders heeft Jezus doen verrijzen, nadat u Hem had omgebracht door Hem aan een kruis te hangen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God heeft Hem verheven naar de plaats aan zijn rechterzijde, als heerser en redder, opdat Hij inkeer en vergeving van zonden aan Israël zou schenken. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Daarvan zijn wij getuigen, evenals de Heilige Geest, die door God wordt geschonken aan de mensen die Hem gehoorzamen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Toen de leden van de Joodse raad dat hoorden, werden ze woedend en wilden ze de apostelen ombrengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Maar een farizeeër die Gamaliël heette, een Wetgeleerde die door het hele volk werd gerespecteerd, stond op in de vergadering en liet de apostelen kort naar buiten sturen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Vervolgens sprak hij de vergadering toe: “Israëlieten, overweeg zorgvuldig wat u met deze mannen gaat doen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Want enige tijd geleden trad Teudas op. Hij beweerde dat hij een bijzonder man was en ongeveer vierhonderd mensen sloten zich bij hem aan. Hij werd omgebracht en zijn aanhang viel uiteen; er bleef niets van over. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Verder trad Judas de Galileeër op, in de dagen van de volkstelling. Hij leidde een aantal mensen in een opstand. Ook hij is omgekomen en zijn aanhang werd uiteengedreven. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","En wat de voorliggende zaak betreft zeg ik u: laat deze mensen met rust. Laat hen gaan. Want als dit plan en deze activiteiten mensenwerk zijn, zullen ze worden vernietigd. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Maar als dit van God is, kan u het niet vernietigen en kan zelfs blijken dat u God aan het tegenwerken bent.” De leden van de Joodse raad lieten zich door hem overtuigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ze riepen de apostelen naar binnen, geselden hen, verboden hun streng om in de naam van Jezus te spreken en lieten hen vrij. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","De apostelen verlieten de Joodse raad, vol vreugde omdat ze waardig waren geacht om vernedering te ondergaan omwille van Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","En elke dag waren ze zonder ophouden op het tempelterrein en aan huis aan het onderwijzen en verkondigen dat Jezus de Messias is. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Terwijl het aantal volgelingen van Jezus in die tijd almaar toenam, begonnen de Griekstaligen te klagen over de Arameestaligen, omdat de Griekstalige weduwen over het hoofd werden gezien bij de dagelijkse voedselbedeling. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Daarom riepen de Twaalf de hele groep volgelingen van Jezus bijeen en zeiden: “Het zou ongepast zijn als wij de verkondiging van het Woord van God zouden verwaarlozen om maaltijden uit te delen. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Daarom, geloofsgenoten: kies uit jullie midden zeven mannen die een goede reputatie hebben en die vervuld van de Geest en vol wijsheid zijn. Hen zullen wij voor deze taak aanstellen. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","En wij zullen ons blijven bezighouden met het gebed en het verkondigen van de boodschap van God.” ");
INSERT INTO nldgbv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","De hele gemeenschap was tevreden met dit voorstel. Men koos Stefanus, een man vol van geloof en de Heilige Geest, en ook Filippus, Prochorus, Nikanor, Timon, Parmenas en Nikolaüs uit Antiochië, een bekeerling tot het jodendom. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ze stelden hen aan de apostelen voor en die baden voor hen en legden hun de handen op. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Het Woord van God bleef zich verspreiden en het aantal volgelingen van Jezus in Jeruzalem nam sterk toe. Ook een grote groep priesters aanvaardde het geloof. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus was vol genade en kracht en deed grote wonderen en tekenen onder het volk. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Maar sommige leden van de zogeheten Synagoge van de Vrijgelaten Slaven – ze waren afkomstig uit Cyrene, Alexandrië, Cilicië en Asia – gingen met Stefanus in discussie. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ze konden echter niet op tegen de wijsheid die de Geest hem gaf bij het spreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Daarom zetten ze enkele mannen ertoe aan te beweren: “Wij hebben hem lasterlijke taal horen spreken tegen Mozes en God.” ");
INSERT INTO nldgbv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ze hitsten zowel het volk als de oudsten en de Schriftgeleerden op. Vervolgens pakten ze Stefanus op. Ze leidden hem voor de Joodse raad. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ook lieten ze valse getuigen naar voren komen, die zeiden: “Deze man spreekt zich zonder ophouden uit tegen dit heiligdom en tegen de Wet. ");
INSERT INTO nldgbv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Want we hebben hem horen zeggen dat die Jezus van Nazaret deze plaats zal afbreken en de gebruiken zal veranderen die Mozes aan ons heeft overgeleverd.” ");
INSERT INTO nldgbv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iedereen die in de Joodse raad zitting had, keek naar Stefanus en zag dat zijn gezicht eruitzag als dat van een engel. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","De hogepriester vroeg: “Is dat waar?” ");
INSERT INTO nldgbv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanus antwoordde: “Volksgenoten en leiders, luister. De hemelse God verscheen aan onze voorvader Abraham toen die nog in Mesopotamië was, voordat hij zich in Haran vestigde. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God zei tegen hem: ‘Verlaat je land en je familie en ga naar het land dat Ik je zal tonen.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Toen vertrok Abraham uit het land van de Chaldeeën en vestigde hij zich in Haran. Nadat zijn vader was gestorven, stuurde God hem naar dit land, waar u nu woont. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God gaf hem hier geen grond in eigendom, zelfs geen klein stukje. Wel beloofde God dat Hij het land later aan hem en zijn afstammelingen in bezit zou geven, hoewel Abraham toen nog geen kinderen had. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God zei dat zijn afstammelingen als vreemdelingen in het land van anderen zouden verblijven, die hen tot slaven zouden maken en hen vierhonderd jaar lang slecht zouden behandelen. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Maar Ik zal het volk dat zij als slaven dienen veroordelen’, zei God, ‘en daarna zullen ze wegtrekken en Mij hier vereren.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Toen gaf God Abraham het verbond van de besnijdenis. Later kreeg Abraham een zoon, Isaak, en hij besneed hem op de achtste dag na zijn geboorte. Isaak werd vader van Jakob en Jakob van de twaalf stamvaders. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","De stamvaders werden afgunstig op Jozef en verkochten hem naar Egypte. Maar God was bij hem ");
INSERT INTO nldgbv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","en bevrijdde hem uit al zijn ellende. God schonk Jozef wijsheid en zorgde dat hij in de gunst kwam bij Farao, de koning van Egypte. Die stelde hem aan als bestuurder van Egypte en hoofd van zijn hofhouding. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Er brak echter hongersnood uit in heel Egypte en Kanaän. De ellende was groot en onze voorouders konden geen eten meer vinden. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Toen Jakob hoorde dat er graan was in Egypte, stuurde hij onze voorvaders daar een eerste keer heen. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bij het tweede bezoek maakte Jozef zich aan zijn broers bekend en kwam Farao Jozefs afkomst te weten. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Toen stuurde Jozef hen terug om zijn vader Jakob en zijn hele familie op te halen, 75 personen. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","En zo kwam Jakob in Egypte terecht, waar hij en onze voorouders zijn gestorven. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ze werden naar Sichem overgebracht en bijgezet in het graf dat Abraham voor een geldbedrag had gekocht van de Chamorieten in Sichem. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","En naarmate het tijdstip naderde waarop God de belofte zou vervullen die Hij aan Abraham gedaan had, werd het volk Israël in Egypte groter en talrijker. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Later werd iemand anders koning van Egypte, iemand die niet wist wie Jozef was. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hij ging bedrieglijk met ons volk om en behandelde onze voorouders slecht: hij dwong hen hun baby's buiten achter te laten, zodat ze zouden sterven. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","In die tijd werd Mozes geboren. Hij was bijzonder mooi. Drie maanden lang werd voor hem gezorgd door zijn eigen familie. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Maar toen hij buiten werd achtergelaten, werd hij door de dochter van Farao geadopteerd en als haar eigen zoon opgevoed. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mozes werd opgeleid in alle wijsheid van de Egyptenaren en was krachtig in woord en daad. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Toen hij veertig jaar oud werd, besloot hij zijn verwanten, de Israëlieten, te bezoeken. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hij zag dat een van hen werd mishandeld, schoot hem te hulp en zorgde voor vergelding door de Egyptenaar dood te slaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hij dacht dat zijn volksgenoten wel zouden beseffen dat God hem zou gebruiken om hen te bevrijden, maar ze begrepen het niet. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","De volgende dag zag hij Israëlieten met elkaar vechten. Hij probeerde hen met elkaar te verzoenen door te zeggen: ‘Mannen, jullie zijn volksgenoten. Waarom doen jullie elkaar kwaad?’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","De man die zijn volksgenoot mishandelde, duwde Mozes weg en zei: ‘Wie heeft jou als leider en rechter over ons aangesteld? ");
INSERT INTO nldgbv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wil je mij ombrengen zoals je gisteren die Egyptenaar hebt omgebracht?’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Toen Mozes dat hoorde, vluchtte hij. Hij woonde als vreemdeling in het land Midian en kreeg daar twee zonen. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Na verloop van veertig jaar verscheen in de wildernis bij de berg Sinaï een engel aan Mozes, in de vlammen van een brandende doornstruik. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mozes verwonderde zich over wat hij zag. Toen hij dichterbij kwam om het beter te bekijken, klonk de stem van de Heer: ");
INSERT INTO nldgbv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ik ben de God van je voorvaders, de God van Abraham, Isaak en Jakob.’ Mozes begon te beven en durfde niet te kijken. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Toen zei de Heer tegen hem: ‘Trek je schoenen uit, want de plaats waar je staat is heilige grond. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ik heb gezien dat mijn volk wordt mishandeld in Egypte, Ik heb hun zuchten gehoord en Ik ben gekomen om hen te bevrijden. Kom hier, dan zend Ik je naar Egypte.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dit is de Mozes die de mensen hadden afgewezen door te zeggen: ‘Wie heeft jou als leider en rechter aangesteld?’ Maar God gebruikte een engel die in de doornstruik aan hem verscheen om hem naar hen toe te sturen als leider en verlosser. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hij leidde hen weg en deed wonderen en tekenen in het land Egypte, bij de Rode Zee en in de woestijn, veertig jaar lang. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Dit is de Mozes die tegen de Israëlieten zei: ‘God zal uit jullie eigen mensen een profeet zoals ik voor jullie doen opstaan.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hij was bij ons volk in de woestijn, bij onze voorouders en bij de engel die tot hem sprak op de berg Sinaï. Hij ontving levende woorden om aan ons door te geven. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Onze voorouders weigerden hem echter te gehoorzamen; ze wezen hem af en verlangden terug naar Egypte. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ze zeiden tegen Aäron: ‘Maak goden die de weg voor ons zullen leiden. Want we weten niet wat er gebeurd is met die Mozes, die ons het land Egypte heeft uitgeleid.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Het was in die periode dat ze een afgodsbeeld in de vorm van een kalf maakten, er offers aan brachten en zich verheugden over iets dat ze eigenhandig gemaakt hadden. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Maar God keerde zich van hen af en gaf hen over aan de verering van de hemellichamen, zoals in het boek van de profeten staat: ‘Hebben jullie Mij veertig jaar lang in de woestijn offers en slachtoffers gebracht, Israëlieten? ");
INSERT INTO nldgbv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nee, jullie hebben de tent voor de verering van Moloch meegedragen en de ster van de god Refan, en de afgodsbeelden die jullie hebben gemaakt om te aanbidden. Daarom zal ik jullie wegvoeren tot voorbij Babylon.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Onze voorouders in de woestijn hadden de tent bij zich die op Gods aanwezigheid wees – gemaakt volgens de instructies die Hij aan Mozes had gegeven en volgens het voorbeeld dat Mozes had gezien. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Onze latere voorouders brachten de tent mee toen ze onder leiding van Jozua het land veroverden op de volken die God voor hen verdreef. De tent bleef in het land tot de tijd van David. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David vond genade bij God en hij wilde graag voorzien in een heiligdom voor Jakobs God. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Het was echter Salomo die een tempel voor Hem bouwde. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Toch woont de Allerhoogste niet in heiligdommen die door mensen zijn gebouwd. Zoals de profeet zegt: ");
INSERT INTO nldgbv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘De hemel is mijn troon en de aarde mijn voetenbank. Wat voor huis ga je dan voor Mij bouwen, zegt de Heer, of op welke plaats zal Ik verblijven? ");
INSERT INTO nldgbv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Heb Ik dit alles niet zelf gemaakt?’ ");
INSERT INTO nldgbv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Koppige mensen, onbesneden van hart en oren, jullie verzetten je altijd tegen de Heilige Geest, net als jullie voorouders! ");
INSERT INTO nldgbv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wie van de profeten hebben jullie voorouders niet vervolgd? Zij hebben zelfs de mensen gedood die de komst van de Rechtvaardige hebben aangekondigd. En nu zijn jullie zijn verraders en moordenaars geworden, ");
INSERT INTO nldgbv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","jullie die de Wet door de tussenkomst van engelen hebben ontvangen, maar er niet naar leven!” ");
INSERT INTO nldgbv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Toen de leden van de Joodse raad dat hoorden, werden ze zo kwaad op hem dat ze begonnen te knarsetanden. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Maar Stefanus, vervuld van de Heilige Geest, tuurde naar de hemel. Hij zag Gods hemelse pracht en Jezus die aan Gods rechterzijde stond. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Kijk”, zei hij, “ik zie dat de hemel is geopend en dat de Mensenzoon aan Gods rechterzijde staat.” ");
INSERT INTO nldgbv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Toen begonnen ze luid te schreeuwen, bedekten hun oren en stormden met zijn allen op hem af. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ze sleurden hem de stad uit en begonnen hem te stenigen. De getuigen gaven hun mantels in bewaring bij een jongeman die Saulus heette. ");
INSERT INTO nldgbv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Terwijl ze hem stenigden, bad Stefanus: “Heer Jezus, ontvang mijn geest.” ");
INSERT INTO nldgbv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hij viel op zijn knieën en schreeuwde: “Heer, reken hun deze zonde niet aan.” Na die woorden stierf hij. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus stemde in met de moord op Stefanus. Diezelfde dag barstte er een grote vervolging van de kerkgemeenschap in Jeruzalem los; met uitzondering van de apostelen raakten allen verspreid over de gebieden Judea en Samaria. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Stefanus werd begraven door mensen die God respecteerden en er werd diep om hem gerouwd. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Maar Saulus begon de kerkgemeenschap te gronde te richten: hij drong het ene huis na het andere binnen, sleurde zowel mannen als vrouwen weg en liet hen gevangenzetten. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Zij die verspreid raakten, trokken rond en verkondigden het evangelie. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filippus ging naar de stad Samaria en verkondigde daar de Messias. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Toen de mensenmassa Filippus hoorde spreken en de wonderlijke tekenen zag die hij deed, luisterde iedereen geboeid naar zijn boodschap. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bij veel mensen met onreine geesten kwamen die luid schreeuwend naar buiten en velen die verlamd of slecht ter been waren, werden genezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Daarom was er veel vreugde in die stad. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nu was er iemand die Simon heette en die al enige tijd magie had bedreven in de stad. Hij deed de mensen van Samaria versteld staan en beweerde dat hij een bijzonder persoon was. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Alle mensen, van de geringste tot de aanzienlijkste, luisterden geboeid naar hem en zeiden: “Hij is de god die de Grote Macht wordt genoemd.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ze luisterden zo geboeid naar hem omdat zijn magie lange tijd indruk op hen had gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Maar toen ze Filippus gingen geloven, die het goede nieuws over Gods koninkrijk en over Jezus Christus verkondigde, werden ze gedoopt, zowel mannen als vrouwen. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ook Simon zelf kwam tot geloof. Hij werd gedoopt en bleef voortdurend bij Filippus in de buurt, want hij was onder de indruk van de tekenen en grote wonderen die hij zag. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Toen de apostelen in Jeruzalem hoorden dat Samaria het Woord van God had aanvaard, stuurden ze Petrus en Johannes naar de nieuwe gelovigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Eenmaal aangekomen baden ze voor hen, dat ze de Heilige Geest mochten ontvangen, ");
INSERT INTO nldgbv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","want Hij was op nog geen van hen neergedaald; ze waren enkel gedoopt in de naam van de Heer Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Toen legden Petrus en Johannes hun de handen op en ontvingen zij de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Toen Simon zag dat de Geest werd gegeven via handoplegging door de apostelen, bood hij hun geld aan en zei: ");
INSERT INTO nldgbv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Geef mij ook deze macht, zodat iedereen bij wie ik de handen opleg, de Heilige Geest zal ontvangen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Maar Petrus zei tegen hem: “Laat jouw geld samen met jou ten onder gaan als je denkt dat je Gods gave met geld kan kopen. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jij krijgt geen enkel aandeel in wat wij doen, want je houding tegenover God is niet oprecht. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bekeer je dus van dit kwaad en bid de Heer om je te vergeven voor de slechte bedoelingen in je hart, ");
INSERT INTO nldgbv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","want ik zie dat je vol afgunst bent en in het kwaad verstrikt zit.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon antwoordde: “Bid voor mij tot de Heer, dat niets van wat jullie hebben gezegd mij zal overkomen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nadat Petrus en Johannes hadden gepredikt en het Woord van de Heer hadden gesproken, keerden ze terug naar Jeruzalem. Onderweg verkondigden ze in veel Samaritaanse dorpen het evangelie. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","En tegen Filippus zei een engel van de Heer: “Ga op reis in zuidelijke richting, naar de weg van Jeruzalem naar Gaza.” Dit is een verlaten weg. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Daarom ging hij op pad. Daar bevond zich een Ethiopiër, een eunuch van de hofhouding van de kandake, de Ethiopische koningin. Hij beheerde haar hele schatkist en was naar Jeruzalem geweest om God te aanbidden. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Op de terugweg zat hij in zijn wagen het boek van de profeet Jesaja te lezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Toen zei de Geest tegen Filippus: “Ga naar die wagen toe en blijf erbij.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Toen Filippus erheen ging, hoorde hij de Ethiopiër uit de profeet Jesaja voorlezen. Hij vroeg hem: “Begrijpt u wat u aan het lezen bent?” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hij antwoordde: “Hoe zou ik dat kunnen zonder dat iemand mij uitleg geeft?” En hij stond erop dat Filippus zou instappen en bij hem zou komen zitten. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hij was het volgende Schriftgedeelte aan het lezen: “Hij werd als een schaap naar de slacht geleid, als een lam dat stil is bij zijn scheerder deed hij zijn mond niet open. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","In zijn vernedering werd zijn recht hem ontnomen. Wie kan over zijn afstammelingen vertellen? Want zijn leven werd van de aarde weggenomen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","De eunuch vroeg aan Filippus: “Mag ik u vragen over wie de profeet het hier heeft? Over zichzelf of iemand anders?” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filippus begon te vertellen en met dit Schriftgedeelte als uitgangspunt verkondigde hij hem het evangelie van Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Terwijl ze nog onderweg waren, kwamen ze bij water. De eunuch zei: “Kijk, water! Wat zou mij ervan weerhouden om gedoopt te worden?” ");
INSERT INTO nldgbv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hij liet de wagen tot stilstand brengen, ze gingen allebei het water in en Filippus doopte de eunuch. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","En toen ze uit het water kwamen, nam de Geest van de Heer Filippus weg. De eunuch zag hem niet meer, en hij vervolgde zijn reis vol vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filippus bleek in Azotus te zijn. Hij verkondigde het evangelie in alle steden waar hij langstrok, totdat hij in Caesarea aankwam. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulus ging nog altijd tegen de volgelingen van de Heer tekeer door hen met de dood te bedreigen. Hij ging naar de hogepriester ");
INSERT INTO nldgbv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","en vroeg hem om brieven voor de synagogen in Damascus, opdat hij, als hij daar mensen zou vinden die bij de Weg hoorden, hen zou kunnen gevangennemen en naar Jeruzalem brengen, zowel mannen als vrouwen. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Maar terwijl hij onderweg was – hij was al bijna bij Damascus – werd hij plots beschenen door een licht uit de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hij viel op de grond en hoorde een stem tegen hem zeggen: “Saul, Saul, waarom vervolg je Mij?” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hij vroeg: “Wie bent U, Heer?” De stem zei: “Ik ben Jezus, degene die jij vervolgt. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Maar kom overeind en ga de stad in. Dan zal aan je worden verteld wat je moet doen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Zijn medereizigers stonden sprakeloos: ze hoorden wel de stem, maar zagen niemand. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus stond op van de grond en hoewel hij zijn ogen open had, zag hij niets. Ze namen hem bij de hand en leidden hem zo Damascus binnen. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Drie dagen lang kon hij niet zien en at en dronk hij niet. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nu bevond zich in Damascus een volgeling van Jezus die Ananias heette. In een visioen zei de Heer tegen hem: “Ananias!” Hij antwoordde: “Hier ben ik, Heer!” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","De Heer zei tegen hem: “Sta op, ga naar de straat die de Rechte Straat heet en vraag bij het huis van Judas naar iemand uit Tarsus die Saulus heet. Hij is aan het bidden ");
INSERT INTO nldgbv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","en heeft in een visioen een man zien binnenkomen die Ananias heet en die hem de handen oplegde om hem weer te laten zien.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias antwoordde echter: “Heer, ik heb van veel mensen over deze man gehoord, dat hij de mensen in Jeruzalem die bij U horen veel kwaad heeft aangedaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","En hij heeft van de hoofdpriesters de volmacht gekregen om iedereen hier gevangen te nemen die U aanbidt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Maar de Heer zei tegen Ananias: “Ga, want Ik heb deze man uitverkoren om aan de niet-Joden en hun leiders, maar ook aan het volk Israël, te verkondigen wie Ik ben. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ik zal hem tonen hoezeer hij zal moeten lijden omwille van Mij.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias vertrok, ging het huis binnen, legde Saulus de handen op en zei: “Saul, broeder, de Heer die aan jou is verschenen toen je naar hier onderweg was – Jezus – heeft mij gestuurd opdat je weer zal zien en met de Heilige Geest wordt vervuld.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Meteen was het alsof er vliezen van Saulus' ogen vielen. Hij kon weer zien, stond op en werd gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nadat hij had gegeten, kwam Saulus weer op krachten. Hij bleef enkele dagen bij de volgelingen van Jezus in Damascus ");
INSERT INTO nldgbv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","en begon meteen in de synagogen te verkondigen dat Jezus de Zoon van God is. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Alle mensen die hem hoorden spreken, waren perplex en zeiden: “Is dit niet de man die in Jeruzalem de mensen die Jezus aanroepen vervolgde en die hier is gekomen om hen gevangen te nemen en aan de hoofdpriesters voor te leiden?” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus' optreden werd steeds krachtiger en hij bracht de Joodse mensen die in Damascus woonden in verwarring door aan te tonen dat Jezus de Messias is. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na een aantal dagen spanden enkele Joodse mensen samen om hem te doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Hun plan raakte echter bij Saulus bekend. Dag en nacht bewaakten ze de stadspoorten om hem te kunnen doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Maar Saulus' volgelingen namen hem 's nachts mee en lieten hem in een korf door een opening in de stadsmuur naar beneden zakken. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","In Jeruzalem aangekomen, probeerde Saulus zich bij de volgelingen van Jezus aan te sluiten. Maar iedereen was bang voor hem, men geloofde niet dat hij een volgeling van Jezus was geworden. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas nam hem echter onder zijn hoede en bracht hem bij de apostelen. Hij vertelde hun hoe Saulus onderweg de Heer had gezien en Hij tot hem had gesproken, en hoe Saulus in Damascus vrijmoedig in de naam van Jezus had gesproken. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulus bleef bij hen en bewoog zich vrij binnen Jeruzalem, terwijl hij vrijmoedig sprak in de naam van de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hij praatte en discussieerde ook met de Griekstalige Joden, maar zij probeerden hem om te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Toen de gelovigen dat te weten kwamen, brachten ze hem naar Caesarea en stuurden hem verder naar Tarsus. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","De kerkgemeenschap in heel Judea, Galilea en Samaria kende vrede, werd opgebouwd, leefde in ontzag voor de Heer, werd bemoedigd door de Heilige Geest en groeide in aantal. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus reisde door het hele land en kwam zo bij de gelovigen die in Lydda woonden. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hij trof daar iemand aan die Eneas heette en al acht jaar verlamd en bedlegerig was. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus zei tegen hem: “Eneas, Jezus Christus geneest je. Sta op en maak je bed op.” Eneas stond meteen op. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Alle inwoners van Lydda en Saron zagen hem en bekeerden zich tot de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nu was er in Joppe een volgelinge van Jezus die Tabita heette. Dat wordt vertaald als Dorkas. Zij deed veel goede daden en gaf aan de armen. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Het was in die tijd dat zij ziek werd en stierf. Ze werd gewassen en in een bovenzaal opgebaard. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda is dicht bij Joppe en toen de volgelingen van Jezus hoorden dat Petrus daar was, stuurden ze twee mannen naar hem toe met het verzoek: “Kom zonder uitstel bij ons.” ");
INSERT INTO nldgbv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus ging meteen met hen mee. Eenmaal aangekomen brachten ze hem naar de bovenzaal. Alle weduwen kwamen huilend om hem heen staan en toonden hem de tunieken en mantels die Dorkas had gemaakt toen ze nog leefde. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus stuurde iedereen naar buiten, knielde neer en bad. Vervolgens keerde hij zich tot het lichaam en zei: “Tabita, sta op.” Ze opende haar ogen en toen ze Petrus zag, ging ze overeind zitten. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Hij nam haar bij de hand en hielp haar opstaan. En nadat hij de gelovigen, inclusief de weduwen, had geroepen, toonde hij hun dat ze leefde. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dit raakte in heel Joppe bekend en velen kwamen tot geloof in de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus bleef enige tijd in Joppe, bij een leerlooier die Simon heette. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Er was in Caesarea iemand die Cornelius heette, een centurio van wat de Italiaanse legerafdeling werd genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hij en zijn hele huishouden hadden eerbied en ontzag voor God, en hij gaf veel aan de armen van het volk en bad aanhoudend tot God. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Op een dag, rond drie uur 's middags, had Cornelius een visioen waarin hij duidelijk zag dat er een engel van God bij hem binnenkwam en tegen hem zei: “Cornelius!” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hij keek hem verschrikt aan en vroeg: “Wat is er, meneer?” De engel antwoordde: “Je gebeden en je giften voor de armen hebben God bereikt en Hij heeft er acht op geslagen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Stuur dus mannen naar Joppe om een zekere Simon op te halen, die Petrus wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hij logeert bij een zekere Simon de leerlooier, die in een huis aan zee woont.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Zodra de engel die met hem had gesproken was vertrokken, riep Cornelius twee van zijn huisslaven en een soldaat die in zijn dienst was en ontzag voor God had. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nadat hij hun alles had uitgelegd, stuurde hij hen naar Joppe. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","De volgende dag, toen ze onderweg waren en in de buurt van de stad kwamen, was Petrus het dakterras opgegaan om te bidden. Het was ongeveer twaalf uur. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hij kreeg honger en wilde iets eten. Terwijl men iets voor hem klaarmaakte, kreeg hij een visioen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Hij zag dat de hemel openging en er een voorwerp naar beneden kwam dat op een groot laken leek en aan de vier hoeken naar de aarde werd neergelaten. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Er zaten allerlei viervoetige dieren en wilde reptielen en vogels in. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hij hoorde een stem tegen hem zeggen: “Ga je gang, Petrus, slacht en eet.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Maar Petrus antwoordde: “Dat nooit, Heer, want ik heb nog nooit iets gegeten dat verwerpelijk of onrein is.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Petrus hoorde de stem nogmaals: “Wat God rein heeft verklaard, mag jij niet als onrein behandelen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Dit gebeurde driemaal. Meteen daarna werd het voorwerp naar de hemel opgetrokken. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Terwijl Petrus zich verwonderd afvroeg wat het visioen dat hij had gezien betekende, stonden de mannen die door Cornelius waren gestuurd en die naar het huis van Simon hadden gevraagd, al voor de poort. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ze riepen: “Logeert Simon die Petrus wordt genoemd hier?” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Terwijl Petrus nog over het visioen nadacht, zei de Geest tegen hem: “Luister, er zijn drie mannen naar je op zoek. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sta op, ga naar beneden en ga zonder aarzelen met hen mee, want Ik heb hen gestuurd.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus ging naar beneden en zei tegen de mannen: “Ik ben degene die jullie zoeken. Wat is de reden van jullie komst?” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ze zeiden: “Cornelius, een centurio, een integere man met ontzag voor God, en die een goede reputatie heeft bij het hele Joodse volk, heeft van een engel van God de opdracht ontvangen om u naar zijn huis uit te nodigen en te luisteren naar wat u te zeggen hebt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petrus liet hen binnen en verleende hun onderdak. De volgende ochtend ging hij met hen op pad. Enkele gelovigen uit Joppe reisden mee. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","De dag erna kwamen ze in Caesarea aan. Cornelius was Petrus aan het opwachten en had zijn familie en beste vrienden bijeengeroepen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Toen Petrus op het punt stond om naar binnen te gaan, kwam Cornelius naar hem toe en liet zich aan Petrus' voeten vallen om hem te eren. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Maar die deed hem opstaan door te zeggen: “Ga maar staan, ik ben slechts een mens.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Terwijl hij met hem praatte, ging Petrus mee naar binnen, waar hij zag dat er een groot aantal mensen was bijeengekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hij zei tegen hen: “Zoals u weet is het voor een Jood verboden om met vreemdelingen om te gaan of hen te bezoeken. Maar God heeft mij getoond dat ik geen enkel mens verwerpelijk of onrein moet noemen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Dus toen ik werd uitgenodigd, ben ik zonder bezwaar gekomen. Daarom vraag ik u, om welke reden hebt u mij laten ophalen?” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius antwoordde: “Drie dagen geleden was ik rond deze tijd, rond drie uur 's middags, thuis aan het bidden, toen er plots een man in blinkende kleren voor me stond. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hij zei: ‘Cornelius, God heeft je gebed gehoord en Hij heeft acht geslagen op je giften voor de armen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Stuur daarom iemand naar Joppe om Simon op te halen, die Petrus wordt genoemd. Hij logeert in het huis van Simon de leerlooier, bij de zee.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ik heb u meteen laten ophalen en u hebt er goed aan gedaan om te komen. Wij allen zijn hier in Gods tegenwoordigheid aanwezig om te luisteren naar alles wat de Heer u beveelt aan ons te zeggen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Toen nam Petrus het woord. Hij zei: “Nu begrijp ik werkelijk dat er bij God geen favoritisme is, ");
INSERT INTO nldgbv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","maar dat iedereen, uit welk volk ook, die ontzag voor Hem heeft en een rechtvaardig leven leidt, welkom bij Hem is. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","De boodschap die Hij aan de Israëlieten heeft gezonden, de verkondiging van het evangelie van vrede door Jezus Christus, is als volgt: Hij is Heer over alle mensen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","U weet wat er in heel Judea is gebeurd, vanaf het begin in Galilea na de doop die Johannes verkondigde, ");
INSERT INTO nldgbv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","hoe God Jezus van Nazaret met de Heilige Geest en met macht heeft gezalfd en hoe Jezus al rondtrekkende goede daden deed en mensen genas die in de macht van de duivel waren, omdat God met Hem was. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wij zijn ooggetuigen van alles wat Hij heeft gedaan in het Joodse land en in Jeruzalem. Hij werd gedood door kruisiging, ");
INSERT INTO nldgbv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","maar God heeft Hem op de derde dag doen verrijzen en heeft ervoor gezorgd dat Hij werd gezien. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Niet door het hele volk, maar door ooggetuigen die reeds door God waren uitgekozen, door ons die met Jezus hebben gegeten en gedronken nadat Hij uit de dood was verrezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hij heeft ons opgedragen, aan het volk te verkondigen en te getuigen dat Hij degene is die door God is aangesteld tot rechter van de levenden en de doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Alle profeten getuigen over Hem dat ieder die in Hem gelooft, dankzij Hem vergeving van zonden ontvangt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Terwijl Petrus nog sprak, kwam de Heilige Geest over alle mensen die naar zijn woorden luisterden. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","De besneden gelovigen die met Petrus waren meegekomen, stonden ervan versteld dat de Heilige Geest nu ook als een geschenk over niet-Joden was uitgestort. ");
INSERT INTO nldgbv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ze hoorden hen namelijk in tongentaal spreken en God de hoogste eer geven. Toen zei Petrus: ");
INSERT INTO nldgbv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wie zou deze mensen, die net als wij de Heilige Geest hebben ontvangen, ervan kunnen weerhouden om in water te worden gedoopt?” ");
INSERT INTO nldgbv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hij droeg hun op, zich in de naam van Jezus Christus te laten dopen. Toen vroegen ze hem om enkele dagen te blijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","De apostelen en de gelovigen in heel Judea hoorden dat ook niet-Joden het Woord van God hadden aanvaard. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Maar toen Petrus naar Jeruzalem ging, namen de besneden gelovigen hem dat kwalijk. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ze zeiden: “Jij bent bij onbesneden mensen thuis geweest en hebt met hen gegeten.” ");
INSERT INTO nldgbv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petrus legde hun echter het hele verhaal uit, vanaf het begin. Hij zei: ");
INSERT INTO nldgbv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ik was in de stad Joppe aan het bidden en werd overvallen door een visioen. Ik zag een voorwerp dat op een groot laken leek en dat aan de vier hoeken uit de hemel werd neergelaten. Het kwam vlak voor mij terecht. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Toen ik erin keek, zag ik viervoetige landdieren en wilde beesten en reptielen en vogels. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","En ik hoorde een stem, die tegen mij zei: ‘Ga je gang, Petrus, slacht en eet.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Maar ik zei: ‘Dat nooit, Heer, want ik heb nog nooit iets gegeten dat verwerpelijk of onrein is.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","De stem uit de hemel sprak nogmaals: ‘Wat God rein heeft verklaard, mag jij niet als onrein behandelen.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dit gebeurde driemaal; daarna werd alles opgetrokken, terug naar de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","En precies op dat moment stonden er drie mannen bij het huis waar ik logeerde. Ze waren vanuit Caesarea naar mij toe gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","De Geest zei tegen me dat ik zonder aarzelen met hen moest meegaan. Deze zes geloofsgenoten hier kwamen ook mee, en we zijn het huis van de man binnengegaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hij vertelde ons hoe hij een engel in zijn huis had zien staan, die zei: ‘Stuur iemand naar Joppe om Simon op te halen, die Petrus wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hij zal woorden tot je spreken waardoor jij en je hele huishouden gered zullen worden.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ik was nauwelijks begonnen met spreken toen de Heilige Geest over hen kwam zoals in het begin ook over ons. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","En ik herinnerde mij de woorden van de Heer. Hij had gezegd: ‘Johannes doopte met water, maar jullie zullen worden gedoopt met de Heilige Geest.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dus als God hun hetzelfde geschenk heeft gegeven als aan ons toen wij tot geloof in de Heer Jezus Christus waren gekomen, wie ben ik dan om te proberen God tegen te houden?” ");
INSERT INTO nldgbv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Toen ze dit hoorden, waren ze gerustgesteld en verheerlijkten ze God met de woorden: “Blijkbaar heeft God ook aan de niet-Joodse volken de inkeer geschonken die tot het leven leidt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Inmiddels waren zij die verspreid waren geraakt wegens de onderdrukking na wat er met Stefanus was gebeurd, naar Fenicië, Cyprus en Antiochië getrokken. Ze verkondigden het evangelie uitsluitend aan Joodse mensen. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Maar sommigen van hen – afkomstig van Cyprus en Cyrene – spraken na hun aankomst in Antiochië ook met Griekstaligen en verkondigden hun het evangelie – Jezus is Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","De zegen van de Heer rustte op hen. Een groot aantal mensen kwam tot geloof en bekeerde zich tot de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Het nieuws hierover bereikte de kerkgemeenschap in Jeruzalem en men stuurde Barnabas naar Antiochië. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Toen die aankwam en zag dat Gods genade aan het werk was, was hij verheugd en spoorde hij allen aan, van harte aan de Heer toegewijd te blijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas was een goed mens, vol van de Heilige Geest en geloof. En een groot aantal mensen werd voor de Heer gewonnen. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas vertrok naar Tarsus om Saulus op te zoeken. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","En toen hij hem had gevonden, nam hij hem mee naar Antiochië. Een jaar lang kwamen Barnabas en Saulus met de kerkgemeenschap bijeen en onderwezen ze een groot aantal mensen. Het was in Antiochië dat de volgelingen van Jezus voor het eerst christenen werden genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","In die periode kwamen er profeten uit Jeruzalem naar Antiochië. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Een van hen – hij heette Agabus – stond op en voorspelde door toedoen van de Geest dat er een grote hongersnood zou komen in het hele Romeinse rijk. (Die kwam er in de tijd van Claudius.) ");
INSERT INTO nldgbv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Daarom besloten de volgelingen van Jezus, elk naar vermogen bijstand te sturen naar hun geloofsgenoten die in Judea woonden. ");
INSERT INTO nldgbv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","En dat deden ze door Barnabas en Saulus met de gift naar de oudsten te sturen. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Rond die tijd liet koning Herodes sommige kerkleden grijpen en mishandelen. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jakobus, de broer van Johannes, liet hij met het zwaard doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","En toen hij zag dat hij de Joodse mensen daarmee een plezier had gedaan, liet hij vervolgens ook Petrus oppakken. Dat gebeurde tijdens het Feest van de Ongedesemde Broden. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na de arrestatie zette hij Petrus gevangen onder bewaking van vier groepen van vier soldaten, met de bedoeling hem na Pesach in het openbaar te berechten. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Terwijl Petrus onder bewaking gevangen zat, werd door de kerkgemeenschap vurig voor hem tot God gebeden. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","In de nacht voordat Herodes hem zou laten voorleiden, lag Petrus met twee ketenen geboeid te slapen tussen twee soldaten in, terwijl twee bewakers de wacht hielden voor de deur van de gevangenis. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Plots kwam er een engel van de Heer naar Petrus toe en scheen er licht in de cel. De engel stootte Petrus in zijn zij, maakte hem wakker en zei: “Vlug, sta op.” Daarbij vielen de ketenen van zijn polsen. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","De engel zei tegen hem: “Doe je riem om en trek je sandalen aan.” Dat deed Petrus. Verder zei de engel: “Sla je mantel om en kom mee.” ");
INSERT INTO nldgbv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petrus volgde hem naar buiten, maar besefte niet dat de dingen die de engel deed werkelijk gebeurden; hij dacht dat hij een visioen had. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ze gingen de eerste en de tweede wacht voorbij en kwamen bij de ijzeren poort die toegang geeft tot de stad. Die ging vanzelf voor hen open. Nadat ze naar buiten waren gegaan, wandelden ze een straat door en ineens verliet de engel Petrus. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Toen kwam Petrus tot zichzelf en zei: “Nu weet ik zeker dat de Heer zijn engel heeft gestuurd en mij heeft bevrijd uit de handen van Herodes en van alles wat het Joodse volk verwachtte.” ");
INSERT INTO nldgbv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Toen dit tot hem was doorgedrongen, ging hij naar het huis van Maria, de moeder van Johannes die Markus wordt genoemd. Daar waren veel mensen samen aan het bidden. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Toen Petrus bij de buitendeur aanklopte, kwam er een dienstmeisje luisteren wie er was. Zij heette Roda. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Zij herkende Petrus' stem en was zo blij dat ze, in plaats van de deur te openen, naar binnen rende en berichtte dat Petrus voor de poort stond. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Maar ze zeiden tegen haar: “Je bent niet goed wijs.” Ze hield echter vol dat het waar was. Dus zeiden ze: “Het zal zijn engel wel zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrus bleef echter kloppen en toen ze opendeden en hem zagen, stonden ze perplex. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus gebaarde met zijn hand dat ze moesten zwijgen en vertelde hun hoe de Heer hem uit de gevangenis had geleid. Hij zei: “Vertel dit aan Jakobus en de gelovigen.” Toen ging hij naar buiten en vertrok hij naar een andere plaats. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Toen het ochtend werd, ontstond er grote commotie onder de soldaten over wat er met Petrus gebeurd kon zijn. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes liet naar hem zoeken, maar hij werd niet gevonden. Toen verhoorde Herodes de bewakers, liet hen executeren en vertrok uit Judea naar Caesarea, waar hij een tijdlang bleef. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nu was het zo dat Herodes kwaad was op de bevolking van Tyrus en Sidon. Zij kwamen gezamenlijk naar hem toe. En nadat ze Blastus, de kamerheer van de koning, voor zich hadden gewonnen, verzochten ze Herodes om vrede, omdat hun gebied economisch van hem afhankelijk was. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Op de afgesproken dag nam Herodes in koninklijk ornaat op zijn troon plaats en sprak hen toe. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Het volk jubelde: “Dit is de stem van een god, niet van een mens.” ");
INSERT INTO nldgbv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Op hetzelfde moment werd Herodes getroffen door een engel van de Heer, omdat hij niet de eer aan God had gegeven. Hij werd door wormen aangevreten en stierf. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Maar het Woord van God verspreidde zich en kreeg steeds meer aanhang. ");
INSERT INTO nldgbv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nadat Barnabas en Saulus hun opdracht hadden voltooid, keerden ze vanuit Jeruzalem terug. Ze brachten Johannes, die ook wel Markus genoemd wordt, mee. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","In de kerkgemeenschap in Antiochië bevonden zich profeten en leraars: Barnabas, Simeon die Niger wordt genoemd, Lucius van Cyrene, Manaën die met de tetrarch Herodes was opgegroeid, en Saulus. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ze waren de Heer aan het aanbidden en aan het vasten, toen de Heilige Geest zei: “Maak Barnabas en Saulus vrij voor de taak waarvoor Ik hen heb geroepen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ze vastten en baden voor hen, legden hun de handen op en stuurden hen op pad. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas en Saulus, die dus door de Heilige Geest waren uitgezonden, gingen naar Seleucië en voeren daarvandaan naar Cyprus. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","In Salamis aangekomen verkondigden ze het Woord van God in de Joodse synagogen. Ze hadden Johannes bij zich als assistent. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ze trokken door het hele eiland, naar Pafos, waar ze een Joodse magiër aantroffen, een valse profeet die Barjezus heette. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hij maakte deel uit van de entourage van de proconsul Sergius Paulus, een verstandig man die Barnabas en Saulus bij zich uitnodigde omdat hij graag naar het Woord van God wilde luisteren. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Elymas de magiër – dat is de vertaling van zijn naam – werkte hen echter tegen: hij probeerde de proconsul van het geloof af te houden. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Maar Saulus – ook Paulus genoemd – raakte vervuld van de Heilige Geest, keek Elymas strak aan en zei: ");
INSERT INTO nldgbv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Jij duivelszoon vol van allerlei bedrog en sluwheid, vijand van alle gerechtigheid, stop jij dan nooit met het verdraaien van de rechte wegen van de Heer? ");
INSERT INTO nldgbv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Daarom zal de Heer je straffen: je zal een tijdlang blind zijn en het zonlicht niet zien.” Op hetzelfde moment werd Elymas overvallen door nevel en duisternis en zocht hij al rondtastend naar iemand die hem bij de hand kon leiden. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Toen de proconsul zag wat er gebeurd was, was hij zo diep onder de indruk van de leer over de Heer, dat hij tot geloof kwam. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus en zijn entourage voeren weg van Pafos. Maar toen ze in Perge in Pamfylië waren aangekomen, verliet Johannes hen om naar Jeruzalem terug te keren. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Zij reisden echter vanuit Perge verder naar Antiochië in Pisidië. Daar gingen ze op de sabbat naar de synagoge en namen plaats. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na de voorlezing uit de Wet en de Profeten stuurden de synagogebestuurders iemand naar hen toe om te vragen: “Volksgenoten, als jullie een bemoedigend woord hebben voor de mensen, spreek dan maar.” ");
INSERT INTO nldgbv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus stond op, maakte een handgebaar en zei: “Israëlieten en anderen die ontzag voor God hebben, luister. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","De God van ons volk Israël heeft onze voorouders uitverkoren en ons volk machtig gemaakt toen het in het land Egypte verbleef. Met veel machtsvertoon leidde Hij hen weg ");
INSERT INTO nldgbv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","en in de wildernis verdroeg Hij veertig jaar lang hun gedrag. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","In het land Kanaän roeide Hij zeven volken uit om het land aan ons volk in eigendom te geven. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dat duurde ongeveer 450 jaar. Vervolgens gaf Hij rechters, tot de tijd van de profeet Samuel. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Toen vroeg ons volk om een koning en God gaf Saul, de zoon van Kis, uit de stam Benjamin. Dat duurde veertig jaar. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","God zette hem af en stelde David aan als hun koning. Hij verklaarde over hem: ‘In David, de zoon van Isaï, heb ik een man naar mijn hart gevonden, die alles zal doen wat Ik wil.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Uit Davids afstammelingen heeft God zoals beloofd een redder voor Israël voortgebracht: Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Maar voordat Jezus kwam, verkondigde Johannes aan het hele volk Israël een doop van inkeer. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","En toen hij zijn opdracht bijna had voltooid, zei Johannes: ‘Ik ben niet de persoon die jullie denken dat ik ben. Maar let goed op, na mij komt er Iemand anders en ik ben het niet waard om zijn schoenen voor Hem los te maken.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Volksgenoten, afstammelingen van Abraham, en ook jullie anderen die ontzag voor God hebben, het nieuws van deze redding is aan ons bekendgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","De inwoners van Jeruzalem en hun leiders hebben Hem niet herkend. Door Jezus te veroordelen, vervulden zij de woorden van de profeten die elke sabbat worden voorgelezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hoewel ze geen enkele grond voor een doodvonnis konden vinden, vroegen ze Pilatus om zijn doodstraf. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","En na alles te hebben uitgevoerd dat over Hem was geschreven, haalden ze Hem van het kruis en legden Hem in een graf. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","God heeft Hem echter uit de dood doen verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","In de loop van vele dagen verscheen Hij aan de mensen die met Hem samen uit Galilea naar Jeruzalem waren gereisd en die nu over Hem getuigen aan het Joodse volk. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","En wij verkondigen jullie het goede nieuws: wat God aan onze voorouders had beloofd, ");
INSERT INTO nldgbv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","heeft Hij voor ons, hun afstammelingen, vervuld door Jezus te doen verrijzen. Zo staat het ook in Psalm 2: ‘Jij bent mijn Zoon, vandaag heb Ik Je verwekt.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dat God Jezus uit de dood zou doen verrijzen zodat Hij niet tot ontbinding zou overgaan, had Hij reeds voorspeld met deze woorden: ‘De betrouwbare, heilige zegeningen die aan David waren beloofd, zal Ik aan jullie geven.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","En elders zegt Hij: ‘U zal uw toegewijde niet tot ontbinding laten overgaan.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David zelf is gestorven, nadat hij de mensen van zijn eigen volk had gediend volgens Gods plan. Hij is bij zijn voorouders begraven en zijn lichaam is vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Maar het lichaam van de Persoon die God heeft doen verrijzen, is niet vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Daarom, vrienden, moeten jullie weten dat dankzij Hem de vergeving van zonden aan jullie wordt verkondigd. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ieder die in Hem gelooft, wordt vrijgesproken van alle schuld waarvoor geen vrijspraak mogelijk was op basis van de Wet van Mozes. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pas dus op dat jullie niet overkomt wat in de Profeten als volgt wordt omschreven: ");
INSERT INTO nldgbv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kijk, spotters, verwonder je en verdwijn, want Ik ga in jullie tijd iets doen dat jullie niet zullen geloven wanneer iemand het jullie vertelt.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Toen Paulus en Barnabas naar buiten gingen, drong men er bij hen op aan, de volgende sabbat opnieuw over dit onderwerp te spreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na afloop van de samenkomst gingen veel van de Joden en van de mensen die God vereerden en zich tot het jodendom hadden bekeerd, met Paulus en Barnabas mee. Die spraken met hen om hen aan te sporen zich aan Gods genade vast te houden. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","De volgende sabbat kwam bijna de hele stad bijeen om het Woord van de Heer te horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Toen de Joden de mensenmassa zagen, werden ze door afgunst overmand. Ze spraken de woorden van Paulus tegen en belasterden hem. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulus en Barnabas zeiden echter vrijmoedig: “Het was nodig om het Woord van God eerst aan jullie te vertellen. Maar nu jullie het afwijzen en zelf aangeven dat jullie het eeuwig leven niet waard zijn, richten wij ons voortaan tot de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Want de Heer heeft ons opgedragen: ‘Ik heb je aangesteld tot een licht voor de volken, om redding te brengen tot aan de uithoeken van de aarde.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Toen de niet-Joden dit hoorden, verheugden ze zich en verheerlijkten ze het Woord van de Heer. Iedereen die voor het eeuwig leven bestemd was, kwam tot geloof. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Het Woord van de Heer raakte in de hele omgeving bekend. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Toen stookten de Joden de voorname vrouwen die God vereerden en de leiders van de stad op tegen Paulus en Barnabas, ontketenden een vervolging en verdreven hen uit hun gebied. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Maar Paulus en Barnabas schudden het stof van hun voeten als een teken van afkeuring en gingen naar Ikonium. ");
INSERT INTO nldgbv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","De nieuwe volgelingen van Jezus waren echter vervuld van vreugde en van de Heilige Geest. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","In Ikonium gebeurde hetzelfde: Paulus en Barnabas gingen naar de Joodse synagoge en een groot aantal Joden en Grieken kwam tot geloof. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Maar de Joden die het geloof afwezen, stookten de niet-Joden op en brachten hen in een vijandige stemming ten opzichte van de christenen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus en Barnabas bleven daar lange tijd en spraken vrijmoedig over de Heer. En Hij bevestigde de verkondiging van zijn genade, door hen in staat te stellen tekenen en wonderen te doen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","De mensen in de stad raakten verdeeld: sommigen waren voor de Joden, anderen voor de apostelen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Toen bepaalde niet-Joden, Joden en hun leiders op het punt stonden om Paulus en Barnabas te mishandelen en te stenigen, ");
INSERT INTO nldgbv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","kwamen die het te weten en vluchtten ze naar de Lykaonische steden Lystra en Derbe en het omliggende gebied. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ook daar verkondigden ze het evangelie. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","In Lystra was een man die geen macht over zijn voeten had; hij was verlamd vanaf zijn geboorte en had nooit kunnen stappen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Toen hij naar Paulus' boodschap aan het luisteren was, keek deze hem recht aan en zag hij dat de man het geloof had om te worden genezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Toen riep Paulus: “Ga recht op je voeten staan!” De man sprong op en begon te stappen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Toen de mensen zagen wat Paulus had gedaan, begonnen ze luid in het Lykaonisch te roepen: “De goden zijn in mensengedaante naar ons neergedaald!” ");
INSERT INTO nldgbv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ze noemden Barnabas Zeus en Paulus Hermes, omdat Paulus de woordvoerder was. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Vlak buiten de stad was een tempel van Zeus. De priester bracht stieren en bloemenkransen naar de stadspoorten en wilde samen met de mensenmassa offers aan hen brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Maar de apostelen – Barnabas en Paulus – hoorden daarvan, scheurden hun kleren, stortten zich in de menigte en riepen: ");
INSERT INTO nldgbv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Vrienden, waarom doen jullie dat? Wij zijn mensen, net als jullie, en het goede nieuws dat wij verkondigen is dat jullie je van deze zinloosheid moeten afkeren naar de levende God, die de hemel en de aarde en de zee met alles daarin heeft gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","In het verleden heeft Hij toegelaten dat alle volken hun eigen gang gingen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Toch liet Hij van zich weten, want Hij toonde zijn goedheid door vanuit de hemel regen en vruchtbare seizoenen aan jullie te geven en te zorgen dat jullie overvloedig te eten hebben en tevreden zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hoewel ze dit zeiden, konden ze de menigte er ternauwernood van weerhouden, offers aan hen te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Toen arriveerden er echter Joodse mensen uit Antiochië en Ikonium, die de mensenmassa voor zich wonnen. Ze stenigden Paulus en sleepten hem de stad uit, in de veronderstelling dat hij dood was. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Maar toen de volgelingen van Jezus om hem heen gingen staan, stond hij op en ging hij de stad binnen. De volgende dag vertrok hij met Barnabas naar Derbe. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","In die stad verkondigden ze het evangelie en maakten ze veel volgelingen van Jezus. Vervolgens keerden ze terug naar Lystra, Ikonium en Antiochië. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Daar bemoedigden ze de volgelingen van Jezus en spoorden hen aan om bij het geloof te blijven. “We moeten nog veel ellende doorstaan voordat we Gods koninkrijk binnengaan”, zeiden ze. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","In elke kerkgemeenschap stelden ze oudsten aan, die ze in gebed en vasten opdroegen aan de Heer op wie ze hun vertrouwen hadden gesteld. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nadat ze door Pisidië waren gereisd, kwamen ze in Pamfylië. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","En nadat ze in Perge het woord hadden verkondigd, gingen ze naar Attalia. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Daarvandaan voeren ze terug naar Antiochië, waar ze eerder aan Gods genade waren toevertrouwd voor de taak die ze nu hadden voltooid. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na hun aankomst riepen ze de kerkgemeenschap bijeen en brachten ze verslag uit van wat God door hen had gedaan en hoe Hij de deur van het geloof had geopend voor de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ze bleven lange tijd bij de volgelingen van Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Toen kwamen er mensen uit Judea, die de christenen in Antiochië leerden: “Als jullie niet worden besneden volgens het gebruik dat door Mozes is opgelegd, kunnen jullie niet gered worden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","En omdat Paulus en Barnabas hen krachtig tegenspraken en er grote onenigheid ontstond, werd besloten Paulus, Barnabas en enkele anderen uit hun midden naar de apostelen en oudsten in Jeruzalem te sturen om de kwestie met hen te bespreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nadat de kerkgemeenschap hen uitgeleide had gedaan, reisden ze door Fenicië en Samaria, waar ze alle christenen blij maakten door hun uitgebreid te vertellen over de bekering van de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","In Jeruzalem aangekomen, werden ze door de kerkgemeenschap, de apostelen en de oudsten verwelkomd en brachten ze verslag uit over hetgeen God met hen had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Maar enkele farizeeën die tot geloof waren gekomen, stonden op en zeiden: “Die mensen moeten worden besneden en ze moeten worden verplicht zich aan de Wet van Mozes te houden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Daarom kwamen de apostelen en oudsten bijeen om zich over deze kwestie te beraden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nadat er uitgebreid was gediscussieerd, stond Petrus op en sprak hen toe: “Geloofsgenoten, zoals jullie weten, heeft God mij enige tijd geleden uit jullie midden uitgekozen, opdat de niet-Joden de boodschap van het evangelie uit mijn mond zouden horen en tot geloof zouden komen. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","En God, die het hart van de mensen kent, heeft dat bevestigd door hun de Heilige Geest te schenken, zoals eerder aan ons. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hij maakt geen onderscheid tussen ons en hen, want Hij heeft hun harten gereinigd door het geloof. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Waarom stellen jullie God dan op de proef door een juk op de schouders van de volgelingen van Jezus te leggen dat noch onze voorvaders noch wijzelf konden dragen? ");
INSERT INTO nldgbv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Want wij geloven dat het door de genade van de Heer Jezus is dat wij – en ook zij – gered worden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Alle aanwezigen werden stil en luisterden naar het verslag van Barnabas en Paulus over de tekenen en wonderen die God door hen had gedaan onder de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Toen ze waren uitgesproken, reageerde Jakobus: “Geloofsgenoten, luister naar mij. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon heeft uiteengezet hoe God reeds in het begin van plan was om uit de niet-Joden mensen uit te kiezen die voortaan zijn naam zouden dragen. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","De woorden van de profeten stemmen hiermee overeen, want er staat: ");
INSERT INTO nldgbv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Daarna kom Ik terug en herbouw ik de vervallen hut van David; Ik zal de ruïnes ervan herbouwen en herstellen, ");
INSERT INTO nldgbv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","opdat het overgebleven deel van de mensheid de Heer zal zoeken, zelfs de volken die Ik heb geroepen om mijn naam te dragen, zegt de Heer die deze dingen doet, ");
INSERT INTO nldgbv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","dingen die Hem altijd al bekend zijn.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Daarom ben ik van oordeel dat we het niet moeilijk moeten maken voor de niet-Joden die zich tot God bekeren, ");
INSERT INTO nldgbv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","maar dat we hun moeten schrijven dat ze zich moeten onthouden van dingen die onrein zijn omdat ze aan afgoden zijn gewijd, van seksueel wangedrag, van vlees van verstikte dieren en van bloed. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Want de Wet van Mozes wordt vanouds in elke stad verkondigd en elke sabbat in de synagogen voorgelezen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Toen besloten de apostelen en de oudsten samen met de hele kerkgemeenschap, enkele van hun eigen mannen uit te kiezen en die samen met Paulus en Barnabas naar Antiochië te sturen. Dit waren Judas (die Barsabbas wordt genoemd) en Silas, mannen die leiders waren onder de christenen. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ze gaven hun de volgende brief mee: “Van: de apostelen en de oudsten, jullie geloofsgenoten. Aan: onze niet-Joodse geloofsgenoten in Antiochië, Syrië en Cilicië. Gegroet! ");
INSERT INTO nldgbv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wij hebben gehoord dat jullie zijn verontrust door mensen die bij ons vandaan komen maar geen mandaat van ons hadden, en die jullie met hun uitspraken diep hebben geschokt. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Daarom hebben wij gezamenlijk besloten, mannen uit te kiezen die we naar jullie toe sturen, samen met onze vrienden Barnabas en Paulus. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Die twee hebben hun levens op het spel gezet voor onze Heer Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wij sturen dus Judas en Silas mee; zij zullen ons schrijven mondeling bevestigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Want de Heilige Geest is van oordeel – en wij ook – dat jullie geen zwaardere last moet worden opgelegd dan de volgende vereisten: ");
INSERT INTO nldgbv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","je onthouden van vlees van afgodenoffers, bloed, vlees van verstikte dieren en seksueel wangedrag. Als jullie die dingen vermijden, handelen jullie juist. Het ga jullie goed.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nadat ze afscheid hadden genomen, reisden de mannen naar Antiochië, waar ze alle christenen bijeenriepen en de brief overhandigden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","De christenen lazen de brief en waren verheugd over de bemoedigende inhoud. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas en Silas, die allebei ook profeet waren, bemoedigden en versterkten de christenen door hen langdurig toe te spreken. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nadat ze daar enige tijd waren geweest, lieten de christenen hen met hun vredeswens terugkeren naar degenen die hen hadden gezonden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Maar Paulus en Barnabas bleven in Antiochië, waar zij en veel anderen het Woord van de Heer onderwezen en verkondigden. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Na een aantal dagen zei Paulus tegen Barnabas: “Laten we teruggaan naar iedere stad waar we het Woord van de Heer hebben verkondigd, om de christenen te bezoeken en te kijken hoe het met hen gaat.” ");
INSERT INTO nldgbv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas wilde ook Johannes meenemen, die Markus wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paulus vond het echter beter om hem niet mee te nemen, omdat hij hen in Pamfylië had verlaten en het werk niet met hen had voortgezet. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Het meningsverschil was zo groot dat ze uiteengingen. Barnabas voer naar Cyprus en nam Markus mee. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus koos Silas en vertrok, nadat hij door de christenen aan de genade van de Heer was opgedragen. ");
INSERT INTO nldgbv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Hij reisde door Syrië en Cilicië en bemoedigde daar de kerkgemeenschappen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus kwam aan in Derbe en in Lystra. Daar trof hij een volgeling van Jezus aan die Timoteüs heette, de zoon van een gelovige Joodse vrouw en een Griekse vader. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","De christenen in Lystra en Ikonium spraken lovend over hem. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus wilde hem meenemen op reis en liet hem besnijden omwille van de Joodse mensen die in dat gebied woonden, want iedereen wist dat zijn vader een niet-Jood was. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Op hun tocht langs de steden vertelden ze de christenen over het besluit dat de apostelen en oudsten in Jeruzalem hadden genomen en waaraan men zich voortaan moest houden. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","De kerkgemeenschappen werden gesterkt in het geloof en het aantal christenen nam elke dag toe. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus en zijn reisgenoten trokken door het gebied van Frygië en Galatië, omdat de Heilige Geest niet toeliet dat ze het woord verkondigden in Asia. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Toen ze Mysië bereikten, probeerden ze Bitynië binnen te gaan, maar Jezus' Geest weerhield hen daarvan. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Dus reisden ze verder door Mysië en kwamen aan in Troas. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","'s Nachts kreeg Paulus een visioen. Hij zag een Macedoniër staan, die hem smeekte: “Kom naar Macedonië en help ons!” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Onmiddellijk nadat hij dat visioen had gehad, wilden we naar Macedonië vertrekken, omdat we eruit opmaakten dat God ons had geroepen om het evangelie aan de mensen daar te verkondigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","We voeren uit Troas weg, zetten koers naar Samotrake en voeren de volgende dag verder naar Neapolis. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Vervolgens reisden we naar Filippi, een stad in Macedonië, de belangrijkste in dat gebied en een Romeinse kolonie. In die stad bleven we enkele dagen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Op de sabbat gingen we naar een plaats bij de rivier buiten de stadspoort, waarvan we vermoedden dat het een plaats van gebed was. We namen plaats en spraken met de vrouwen die waren bijeengekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Daar was een vrouw die God vereerde. Ze heette Lydia, kwam uit de stad Tyatira en was handelaar in paarse stoffen. Terwijl zij luisterde, opende de Heer haar hart, zodat ze op Paulus' boodschap inging. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nadat zij en haar huishouden waren gedoopt, verzocht ze: “Als jullie mij beschouwen als gelovige in de Heer, kom dan in mijn huis logeren.” Ze drong er bij ons op aan. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Op een dag toen we naar de plaats van gebed gingen, kwam ons een slavin tegemoet die een waarzeggende geest had. Haar eigenaars verdienden veel aan haar toekomstvoorspellingen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Zij kwam voortdurend achter Paulus en ons aan en riep dan: “Deze mensen zijn dienaren van de Allerhoogste God, zij verkondigen hoe men gered kan worden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ze deed dit vele dagen achtereen. Uiteindelijk raakte Paulus zo geïrriteerd dat hij zich omdraaide en tegen de geest zei: “Ik beveel je in naam van Jezus Christus om uit haar weg te gaan.” Op dat moment ging de geest uit haar weg. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Toen haar eigenaars zagen dat hun bron van inkomsten weg was, grepen ze Paulus en Silas en sleurden hen naar de stadsbestuurders op het marktplein. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ze leidden hen aan de magistraten voor en zeiden: “Deze mensen brengen onze stad in oproer. Het zijn Joden ");
INSERT INTO nldgbv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","en ze verkondigen praktijken die wij, Romeinen, niet mogen aanvaarden of naleven.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nu keerde ook de menigte zich tegen Paulus en Silas en de stadsbestuurders bevalen hun de kleren van het lijf te rukken en hen met stokken af te ranselen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nadat ze hun veel slagen hadden toegebracht, gooiden ze hen in de gevangenis en droegen de cipier op, hen streng te bewaken. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Omdat hij die opdracht had gekregen, zette hij hen in de binnenste cel en sloot hij hun voeten in een blok. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Rond middernacht – Paulus en Silas waren tot God aan het bidden en zingen en de andere gevangenen waren naar hen aan het luisteren – ");
INSERT INTO nldgbv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","was er ineens een zware aardbeving. Het fundament van de gevangenis schudde ervan. Meteen gingen alle deuren open en raakten alle boeien los. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","De cipier, die wakker was geworden en de geopende deuren van de gevangenis zag, trok zijn zwaard om zichzelf om te brengen, want hij dacht dat de gevangenen waren ontsnapt. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Maar Paulus riep luid: “Doe uzelf geen kwaad, we zijn allemaal hier!” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","De cipier liet licht brengen, haastte zich naar binnen en viel bevend voor Paulus en Silas neer. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Hij bracht hen naar buiten en vroeg: “Heren, wat moet ik doen om te worden gered?” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ze zeiden: “Geloof in de Heer Jezus en u zal gered zijn, u en uw huishouden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ze verkondigden het Woord van de Heer, aan hem en aan iedereen in zijn huis. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hij nam hen nog op dat uur van de nacht mee om hun wonden te laten wassen. Ook werden hij en zijn hele huishouden onmiddellijk gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Hij leidde hen zijn huis binnen en zette hun een maaltijd voor. Hij en zijn hele huishouden waren dolblij dat ze tot geloof in God waren gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Toen het ochtend werd, stuurden de magistraten de gerechtsdienaren met de boodschap: “Laat die mannen maar vrij.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","De cipier bracht het volgende bericht over aan Paulus: “De magistraten hebben laten weten dat u vrijgelaten moet worden. U mag vertrekken. Ga in vrede.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Maar Paulus antwoordde: “Ze hebben ons zonder proces in het openbaar stokslagen laten geven hoewel we Romeinse staatsburgers zijn, en ze hebben ons in de gevangenis gegooid. En nu sturen ze ons onopgemerkt weg? Nee hoor, laat ze zelf maar komen om ons uitgeleide te doen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","De gerechtsdienaren brachten deze woorden over aan de magistraten. Die schrokken toen ze hoorden dat Paulus en Silas Romeinen waren. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ze kwamen hun excuses aanbieden, leidden hen de gevangenis uit en verzochten hen de stad te verlaten. ");
INSERT INTO nldgbv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Uit de gevangenis gekomen, gingen Paulus en Silas naar Lydia. En toen ze de christenen daar hadden gezien en bemoedigd, vertrokken ze. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ze trokken door Amfipolis en Apollonia en kwamen in Tessalonica, waar een Joodse synagoge was. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Zoals hij gewoon was, ging Paulus erheen en drie sabbatten lang debatteerde hij met de Joden op basis van de Schriften. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Hij legde uit en toonde aan dat de Messias moest lijden en uit de dood verrijzen. Hij zei: “Deze Messias is Jezus, die ik aan jullie verkondig.” ");
INSERT INTO nldgbv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sommigen van hen raakten overtuigd en sloten zich bij Paulus en Silas aan, evenals een groot aantal Grieken die God vereerden en veel voorname vrouwen. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Maar de andere Joden werden afgunstig en met enkele slechte mensen die ze uit het straatvolk hadden verzameld, vormden ze een bende waarmee ze de stad in oproer brachten. Ze bestormden het huis van Jason met de bedoeling Paulus en Silas door het volk te laten berechten. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Maar toen ze hen niet vonden, sleurden ze Jason en enkele andere christenen naar het stadsbestuur en riepen: “De mensen die het hele rijk op zijn kop hebben gezet, zijn ook hier aangekomen, ");
INSERT INTO nldgbv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","en Jason heeft hen in huis gehaald. Ze overtreden allemaal de decreten van de keizer door te zeggen dat er een andere koning is: Jezus!” ");
INSERT INTO nldgbv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Het volk en de stadsbestuurders raakten in verwarring toen ze dit hoorden. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ze lieten Jason en de anderen een borgsom betalen en lieten hen gaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zodra het nacht werd, stuurden de christenen Paulus en Silas naar Berea. Daar aangekomen gingen ze naar de Joodse synagoge. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","De mensen daar waren vriendelijker dan in Tessalonica. Ze aanvaardden de boodschap met veel enthousiasme en raadpleegden dagelijks de Schriften om te controleren of deze dingen juist waren. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Velen van hen kwamen tot geloof, en ook een groot aantal voorname niet-Joodse vrouwen en veel niet-Joodse mannen. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Maar toen de Joden in Tessalonica ontdekten dat het Woord van God nu ook door Paulus werd verkondigd in Berea, gingen ze daarheen om de mensen op te hitsen en verwarring te zaaien. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","De christenen stuurden Paulus meteen weg, naar de kust, maar Silas en Timoteüs bleven achter. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","De mensen die Paulus begeleidden, brachten hem tot Athene. Toen keerden ze terug met de boodschap voor Silas en Timoteüs, dat die zich zo snel mogelijk bij hem moesten voegen. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Terwijl Paulus in Athene op hen wachtte, zag hij dat de stad vol afgodsbeelden stond. Dat choqueerde hem. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Daarom debatteerde hij in de synagoge met de Joden en de mensen die God vereerden, en sprak hij op het marktplein de mensen toe die hij daar dagelijks aantrof. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ook enkele epicurese en stoïcijnse filosofen debatteerden met hem. Sommigen zeiden: “Wat probeert die praatjesmaker te vertellen?” Anderen zeiden: “Kennelijk is hij een prediker van vreemde goden,” omdat hij het evangelie van Jezus en de verrijzenis verkondigde. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dus nodigden ze Paulus uit om mee te komen naar de Areopagus. Daar vroegen ze: “Mogen wij weten wat die nieuwe leer is waarover u spreekt? ");
INSERT INTO nldgbv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","U vertelt dingen die ons vreemd in de oren klinken en we willen graag weten wat ze betekenen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Alle Atheners en de vreemdelingen die er woonden besteedden hun tijd namelijk aan niets anders dan het praten over en luisteren naar nieuwe ideeën. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Daarom ging Paulus in de Areopagus staan en sprak hij de mensen toe: “Inwoners van Athene, ik zie dat jullie in alle opzichten heel godsdienstig zijn. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Want toen ik rondwandelde en bekeek wat jullie vereren, trof ik ook een altaar aan met het opschrift ‘aan een onbekende god’. Wat jullie dus vereren maar niet kennen, zal ik nu aan jullie bekendmaken. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","De God die de wereld en alles daarin heeft gemaakt, de Heer van hemel en aarde, woont niet in tempels die door mensen zijn gemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ook wordt Hij niet door mensenhanden onderhouden alsof Hij iets nodig heeft: Hij geeft alle mensen het leven, hun adem, in feite alles. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Uit één mens heeft Hij alle volken gemaakt om de hele aardbodem te bewonen en Hij heeft bepaald in welke tijden en binnen welke grenzen ze zouden leven. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God deed dat met de bedoeling dat ze Hem zouden zoeken en Hem misschien al rondtastend zouden vinden. Toch is Hij niet ver van ieder van ons. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Want ‘in Hem leven wij, bewegen wij en bestaan wij’. Zoals enkele van uw dichters hebben gezegd: ‘Ook wij zijn van Hem afkomstig.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Maar als wij uit God afkomstig zijn, moeten we niet denken dat het goddelijke is als een gouden, zilveren of stenen beeld dat voortkomt uit de artistieke bekwaamheid van een mens. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Vroeger heeft God die onwetendheid gedoogd, maar nu roept Hij alle mensen overal op, tot inkeer te komen. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Hij heeft namelijk een dag vastgesteld waarop Hij de hele wereld rechtvaardig zal oordelen door de Man die Hij heeft aangesteld. En Hij heeft het bewijs hiervoor aan alle mensen geleverd door Hem uit de dood te doen verrijzen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Toen ze over de verrijzenis van doden hoorden, dreven sommigen daar de spot mee, maar anderen zeiden: “Hierover willen we nog wel eens naar u luisteren.” ");
INSERT INTO nldgbv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Zo vertrok Paulus uit hun midden. ");
INSERT INTO nldgbv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Maar enkele mensen sloten zich bij hem aan en kwamen tot geloof, waaronder Dionysius de Areopagiet, een vrouw die Damaris heette en een aantal anderen. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hierna vertrok Paulus uit Athene naar Korinte. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Daar ontmoette hij een Joodse man die Aquila heette en uit Pontus afkomstig was. Hij was onlangs met zijn vrouw Priscilla uit Italië aangekomen, omdat Claudius had bevolen dat alle Joodse mensen uit Rome moesten vertrekken. Paulus ging bij hen op bezoek, ");
INSERT INTO nldgbv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","en omdat hij hetzelfde beroep had, bleef hij bij hen wonen en werken. Ze waren namelijk tentenmakers van beroep. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Elke sabbat debatteerde Paulus in de synagoge en probeerde hij zowel Joden als Grieken te overtuigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Maar nadat Silas en Timoteüs uit Macedonië waren aangekomen, concentreerde Paulus zich op de verkondiging van het Woord. Hij verklaarde aan de Joodse mensen dat Jezus de Messias is. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Toen zij hem echter tegenspraken en bespotten, schudde hij het stof van zijn kleren en zei tegen hen: “Jullie zijn verantwoordelijk voor je eigen ondergang. Ik heb er geen schuld aan. Voortaan ga ik naar de niet-Joden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hij verliet de synagoge en trok in bij iemand die God vereerde. Die man heette Titius Justus en zijn huis stond naast de synagoge. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, de synagogebestuurder, kwam met zijn hele huishouden tot geloof in de Heer. Ook veel andere Korintiërs die naar Paulus hadden geluisterd, kwamen tot geloof en werden gedoopt. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","'s Nachts zei de Heer in een visioen tegen Paulus: “Wees niet bang, blijf spreken en zwijg niet, ");
INSERT INTO nldgbv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","want Ik ben bij je en niemand zal je aanvallen of kwaad doen, want er zijn in deze stad veel mensen die bij Mij horen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulus bleef een jaar en zes maanden en leerde hun het Woord van God. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Maar toen Gallio proconsul van Achaje was geworden, keerden de Joden in Korinte zich gezamenlijk tegen Paulus en brachten hem naar Gallio's rechterstoel. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ze zeiden: “Deze man haalt de mensen over om God te vereren op een manier die in strijd is met de wet.” ");
INSERT INTO nldgbv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Net toen Paulus op het punt stond iets te zeggen, zei Gallio tegen de Joden: “Als het hier zou gaan om een misdrijf of een kwaadaardig vergrijp, zou het terecht zijn dat ik jullie aanhoor. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Maar omdat deze onenigheid woorden, namen en jullie eigen wetten betreft, moeten jullie zelf maar zien. Over deze dingen wil ik geen rechter zijn.” ");
INSERT INTO nldgbv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","En hij stuurde hen bij de rechterstoel vandaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Toen vielen ze allemaal Sostenes de synagogebestuurder aan; ze sloegen hem voor de rechterstoel in elkaar. Maar Gallio trok zich er niets van aan. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus bleef nog een aantal dagen in Korinte, maar nam toen afscheid van de christenen daar en voer met Priscilla en Aquila naar Syrië. Hij liet echter eerst in Kenchreeën zijn haren knippen, omdat hij een plechtige gelofte had afgelegd. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Toen ze in Efeze aankwamen, liet hij Prisca en Aquila achter, maar ging zelf naar de synagoge om met de Joodse mensen te debatteren. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Toen die hem vroegen wat langer te blijven, sloeg hij dat af. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Maar bij zijn vertrek zei hij: “Als God het wil, kom ik later bij jullie terug.” Toen voer hij uit Efeze weg. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hij ging aan land in Caesarea, ging naar Jeruzalem om de kerkgemeenschap daar te begroeten en reisde verder naar Antiochië. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nadat hij daar enige tijd was geweest, vertrok hij om door het gebied van Galatië en door Frygië te trekken en alle volgelingen van Jezus daar te versterken. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Intussen kwam er een Joodse man naar Efeze die Apollos heette en uit Alexandrië afkomstig was. Hij was hoogopgeleid en had een grondige kennis van de Schriften. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Hij had onderricht ontvangen over de Weg van de Heer en sprak met veel enthousiasme. Wat hij over Jezus leerde was correct, maar hij kende enkel de doop van Johannes. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Hij begon vrijmoedig in de synagoge te spreken. Toen Priscilla en Aquila hem hadden horen spreken, namen ze hem apart en legden ze de Weg van God nauwkeuriger aan hem uit. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","En toen hij naar Achaje wilde doorreizen, bemoedigden zijn medegelovigen hem en schreven ze aan de volgelingen van Jezus daar dat die hem moesten verwelkomen. In Achaje aangekomen, was Apollos een grote steun voor de mensen die door genade tot geloof waren gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Hij weerlegde de Joden namelijk krachtig door publiekelijk aan de hand van de Schriften te bewijzen dat Jezus de Messias is. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Terwijl Apollos in Korinte was, kwam Paulus na een reis door het binnenland aan in Efeze, waar hij enkele volgelingen van Jezus ontmoette. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Hij vroeg hun: “Hebben jullie de Heilige Geest ontvangen toen jullie tot geloof kwamen?” Ze antwoordden: “Nee, we hebben zelfs niet over het bestaan van een Heilige Geest gehoord.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Hij vroeg: “Welke doop hebben jullie dan ondergaan?” Ze zeiden: “De doop van Johannes.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulus zei: “De doop van Johannes was een doop van inkeer. Johannes vertelde de mensen dat ze moesten geloven in de Persoon die na hem zou komen, dat wil zeggen: in Jezus.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Toen ze dat hoorden, lieten ze zich dopen in de naam van de Heer Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","En toen Paulus hun de handen oplegde, kwam de Heilige Geest over hen en begonnen ze in andere talen te spreken en te profeteren. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","In totaal ging het om ongeveer twaalf personen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulus ging naar de synagoge, waar hij drie maanden lang ongehinderd over Gods koninkrijk debatteerde en overtuigend sprak. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Maar toen sommigen halsstarrig weigerden te geloven en de Weg belasterden bij de mensen, trok hij zich uit de synagoge terug. Hij nam de volgelingen van Jezus met zich mee en sprak voortaan elke dag in het auditorium van Tyrannus. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dit duurde twee jaar en daardoor hoorden alle inwoners van Asia, zowel Joden als Grieken, het Woord van de Heer. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God gebruikte Paulus om buitengewone wonderen te doen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Er werden zelfs doeken en werkschorten die met zijn huid in contact waren geweest, naar de zieken gebracht, zodat hun aandoeningen verdwenen en de boze geesten uit hen weggingen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Er waren echter ook enkele rondreizende Joodse exorcisten, die probeerden in naam van de Heer Jezus boze geesten uit te drijven door te zeggen: “Ik bezweer jullie bij de Jezus die door Paulus wordt verkondigd!” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Een zekere Skevas, een Joodse hoofdpriester, had zeven zonen die dit deden. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Toen antwoordde de boze geest: “Ik ken Jezus en ik weet wie Paulus is, maar wie zijn jullie?” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","De persoon sprong op hen af en overmeesterde hen allen. Hij was zoveel sterker dan zij, dat ze naakt en verwond uit dat huis vluchtten. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Dit raakte bekend bij alle inwoners van Efeze, zowel Joden als Grieken. Ze raakten allen door angst bevangen en de naam van de Heer Jezus werd grootgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Veel mensen die tot geloof kwamen, kwamen opbiechten en bekennen wat ze hadden misdreven. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Een aantal mensen die magie hadden bedreven, verzamelden hun boeken en verbrandden die in het openbaar. Toen de waarde ervan werd berekend, kwam men uit op 50.000 zilverstukken. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Door dit grootse gebeuren kreeg de boodschap van de Heer steeds meer gehoor en aanhang. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Na deze gebeurtenissen vatte Paulus het plan op, via Macedonië en Achaje naar Jeruzalem te reizen. Hij zei: “Nadat ik daar ben geweest, moet ik ook Rome bezoeken.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Hij stuurde twee van zijn assistenten, Timoteüs en Erastus, naar Macedonië, maar bleef zelf wat langer in Asia. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Rond die tijd ontstond er grote commotie over de Weg. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Er was namelijk een zilversmid die Demetrius heette en die met de vervaardiging van zilveren artemistempeltjes een aanzienlijk inkomen aan de ambachtslieden bezorgde. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Hij belegde een vergadering voor hen en voor de mensen met aanverwante beroepen, en zei: “Mensen, zoals jullie weten is onze welvaart van deze werkzaamheden afhankelijk. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Maar jullie zien en horen ook dat die Paulus een groot aantal mensen heeft overtuigd en op een dwaalspoor gebracht, niet alleen in Efeze maar in bijna heel Asia, door te zeggen dat handgemaakte goden geen echte goden zijn. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu bestaat niet alleen het gevaar dat ons vak in diskrediet raakt, maar ook dat de tempel van de grote godin Artemis zijn aanzien verliest en zij die door heel Asia en het hele rijk wordt vereerd van haar verhevenheid wordt beroofd.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Toen ze dat hoorden, werden ze razend van woede en schreeuwden ze: “Groot is de Artemis van de Efeziërs!” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","De stad raakte in rep en roer. De mensen stormden allemaal naar het theater, waarbij ze Gajus en Aristarchus, Macedonische reisgenoten van Paulus, met zich meesleurden. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus wilde zich in de menigte begeven, maar de volgelingen van Jezus hielden hem tegen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Enkele hoge provinciefunctionarissen die met hem bevriend waren, lieten hem dringend waarschuwen dat hij zich beter niet in het theater zou vertonen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","De mensen schreeuwden door elkaar heen en de bijeenkomst verliep chaotisch. De meesten wisten zelfs niet waarom ze waren samengekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Sommigen in de menigte schreeuwden instructies naar Alexander, die door de Joden naar voren werd geduwd. Alexander gaf met een handgebaar aan dat hij een verdedigingstoespraak wilde geven aan het volk. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Maar toen ze beseften dat hij een Jood was, scandeerden ze twee uur lang: “Groot is de Artemis van de Efeziërs!” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nadat de stadssecretaris de menigte tot bedaren had gebracht, zei hij: “Efeziërs, er is toch geen mens die niet weet dat de stad Efeze de zorg draagt voor de tempel van de verheven Artemis en voor haar beeld dat uit de hemel gevallen is? ");
INSERT INTO nldgbv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aangezien deze dingen niet kunnen worden ontkend, moeten jullie je kalmte bewaren en geen domme dingen doen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Want de mannen die jullie hierheen hebben gebracht, zijn geen tempelrovers en hebben jullie godin niet belasterd. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Als Demetrius en zijn vakgenoten dus iets tegen iemand hebben, dan zijn er rechtszittingen met proconsuls. Laten zij dan maar klacht indienen. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","En als jullie nog iets wensen, moet dat in een wettige vergadering worden opgelost. ");
INSERT INTO nldgbv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Door de gebeurtenissen van vandaag lopen wij namelijk het gevaar van oproer te worden beschuldigd. En dan zullen we deze oploop niet kunnen goedpraten.” ");
INSERT INTO nldgbv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nadat hij dit had gezegd, beëindigde hij de samenkomst. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Toen het tumult bedaard was, riep Paulus de volgelingen van Jezus bijeen. Hij bemoedigde hen, nam afscheid en vertrok naar Macedonië. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nadat hij dat gebied had doorgereisd en de gelovigen daar had bemoedigd met zijn toespraken, kwam hij aan in Griekenland. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Daar bleef hij drie maanden. Net toen hij op het punt stond naar Syrië te varen, beraamden een aantal Joden een aanslag tegen hem. Daarom besloot hij terug te keren via Macedonië. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hij werd vergezeld door Sopatrus, de zoon van Pyrrhus uit Berea, Aristarchus en Secundus uit Tessalonica, Gajus uit Derbe, Timoteüs, en Tychikus en Trofimus uit Asia. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Zij reisden vooruit en wachtten op ons in Troas. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wijzelf voeren uit Filippi weg na het Feest van de Ongedesemde Broden. Na vijf dagen voegden we ons bij de anderen in Troas, en bleven daar zeven dagen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Op de eerste dag van de week, toen we bijeengekomen waren voor de gezamenlijke maaltijd, sprak Paulus de aanwezigen toe. En omdat hij van plan was de volgende ochtend te vertrekken, bleef hij doorspreken tot middernacht. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Er brandden veel lampen in de bovenzaal waar we bijeen waren. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Een jongeman die Eutychus heette, zat in de raamopening en raakte door slaap overmand toen Paulus almaar langer sprak. Diep in slaap viel hij van de tweede verdieping naar beneden en hij werd dood opgeraapt. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus ging naar beneden, ging bovenop hem liggen, sloeg zijn armen om hem heen en zei: “Wees niet ongerust, hij leeft.” ");
INSERT INTO nldgbv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Hij ging weer naar boven, zette de maaltijd voort en sprak lang verder totdat het licht werd. Toen vertrok hij. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Het kind werd levend weggebracht en men was bijzonder bemoedigd. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wij gingen alvast naar het schip en voeren naar Assus, waar we Paulus aan boord zouden nemen. Hij had dat zo geregeld omdat hij over land wilde reizen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nadat hij zich in Assus weer bij ons had gevoegd en we hem aan boord hadden genomen, voeren we naar Mitylene. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Daarvandaan voeren we verder en de volgende dag gingen we bij Chios voor anker. De dag daarna staken we over naar Samos en nog een dag later kwamen we aan in Miletus. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus had namelijk besloten om Efeze voorbij te varen omdat hij geen tijd in Asia wilde doorbrengen. Hij had haast; hij wilde als het kon in Jeruzalem zijn op de dag van het Pinksterfeest. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","In Miletus stuurde hij iemand naar Efeze om de oudsten van de kerkgemeenschap te ontbieden. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Toen die bij hem waren aangekomen, zei hij tegen hen: “Jullie weten hoe ik mij de hele tijd bij jullie heb gedragen, vanaf de eerste dag dat ik in Asia aankwam. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ik heb de Heer in alle nederigheid en met tranen gediend in de beproevingen die mij zijn overkomen door de complotten van de Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ik heb jullie in het openbaar en bij mensen thuis toegesproken en onderwezen zonder jullie ook maar iets te onthouden dat jullie van nut kon zijn. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ik heb zowel Joden als Grieken opgeroepen zich tot God te bekeren en in onze Heer Jezus te geloven. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","En nu ga ik naar Jeruzalem, onder aandrang van de Geest, en ik weet niet wat mij daar zal overkomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Alleen word ik in elke stad door de Heilige Geest gewaarschuwd dat mij gevangenschap en lijden te wachten staat. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wat mijzelf betreft, ik hecht geen waarde aan mijn leven, als ik mijn taak en opdracht maar mag voltooien die ik van de Heer Jezus heb ontvangen: getuigen van het evangelie van Gods genade. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ik weet dat niemand van jullie aan wie ik tijdens mijn reizen Gods koninkrijk heb verkondigd, mij zal terugzien. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Daarom verklaar ik vandaag aan jullie dat als er iemand van jullie verloren gaat, dat niet mijn schuld zal zijn, ");
INSERT INTO nldgbv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","want ik heb niet nagelaten heel Gods plan aan jullie te verkondigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pas dus op jezelf en de hele kudde waarover de Heilige Geest jullie als verantwoordelijken heeft aangesteld. Zorg voor Gods kerk, die Hij zich heeft toegeëigend doordat zijn bloed werd vergoten. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ik weet dat na mijn vertrek wrede wolven bij jullie zullen binnendringen, die de kudde niet zullen ontzien. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Zelfs uit jullie eigen midden zullen mensen opstaan die de waarheid verdraaien om van de volgelingen van Jezus hun eigen volgelingen te maken. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Wees dus waakzaam en onthoud dat ik ieder van jullie drie jaar lang onophoudelijk dag en nacht in tranen heb onderwezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","En nu draag ik jullie op aan God en aan de boodschap van zijn genade, die jullie kan opbouwen en jullie kan schenken wat beloofd is aan allen die bij Hem horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Zilver, goud of kledij heb ik van niemand verlangd. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jullie weten dat ik eigenhandig heb voorzien in mijn eigen noden en die van de mensen bij mij. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","In alles heb ik jullie getoond dat we zo, door hard te werken, de zwakken moeten steunen, terwijl we denken aan de woorden van de Heer Jezus zelf: ‘Het is beter te geven dan te ontvangen.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Toen Paulus was uitgesproken, knielde hij met hen allen neer om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Paulus werd onder luid geween door iedereen omhelsd en gekust. ");
INSERT INTO nldgbv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Waar ze het droevigst om waren was dat hij had gezegd dat zij hem niet zouden terugzien. Vervolgens deden ze hem uitgeleide naar het schip. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nadat we ons van hen hadden losgemaakt, voeren we weg. We zetten rechtstreeks koers naar Kos, de volgende dag naar Rhodos en daarvandaan naar Patara. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Daar vonden we een schip dat naar Fenicië zou oversteken, gingen aan boord en voeren weg. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nadat we Cyprus hadden zien liggen en aan de zuidkant waren gepasseerd, voeren we verder naar Syrië en meerden we aan in Tyrus. Daar moest de lading van het schip worden gelost. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","We zochten in Tyrus de volgelingen van Jezus op en bleven daar zeven dagen. Door toedoen van de Geest zeiden zij tegen Paulus dat hij niet naar Jeruzalem moest gaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Maar toen onze tijd daar voorbij was, vertrokken we om onze reis te vervolgen. Ze vergezelden ons allemaal, met hun vrouwen en kinderen, tot buiten de stad. Op het strand knielden we neer om te bidden. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","We namen afscheid van elkaar en wij gingen aan boord van het schip, terwijl zij naar huis terugkeerden. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Vanuit Tyrus vervolgden we onze zeereis tot we in Ptolemaïs aankwamen. Daar begroetten we de christenen en bleven we een dag bij hen. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","De volgende dag vertrokken we en kwamen we aan in Caesarea. Daar gingen we naar het huis van Filippus de Evangelist, – hij was een van de Zeven – en bleven bij hem logeren. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Hij had vier ongehuwde dochters met de gave van profetie. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","We waren er al een aantal dagen, toen er een profeet uit Judea kwam die Agabus heette. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Hij kwam naar ons toe, nam Paulus' riem, bond daarmee zijn eigen voeten en handen vast en zei: “De Heilige Geest zegt: ‘De Joden in Jeruzalem zullen de man van wie deze riem is vastbinden en hem aan de niet-Joden uitleveren.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Toen we dat hoorden, drongen zowel wijzelf als de christenen van Caesarea er bij Paulus op aan niet naar Jeruzalem te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Maar Paulus antwoordde: “Waarom wenen jullie en maken jullie mij zo treurig? Ik ben niet alleen bereid in Jeruzalem te worden vastgebonden, maar ook omwille van de Heer Jezus te sterven.” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Toen hij zich niet liet overreden, gaven we het op. We zeiden: “Laat gebeuren wat de Heer wil.” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Na die periode troffen we voorbereidingen en reisden we naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Enkele volgelingen van Jezus uit Caesarea kwamen met ons mee. Zij brachten ons bij Mnason, een Cyprioot en een van de eerste volgelingen van Jezus. Bij hem mochten we logeren. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Bij onze aankomst in Jeruzalem ontvingen de christenen ons met vreugde. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","De volgende dag gingen wij met Paulus mee naar Jakobus. Ook alle oudsten waren daar. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulus begroette hen en vertelde gedetailleerd over de dingen die God door zijn bediening had gedaan onder de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nadat ze hem hadden aangehoord, verheerlijkten ze God. Toen zeiden ze tegen Paulus: “Broer, je ziet hoeveel duizenden Joden tot geloof zijn gekomen en dat zij allen nauwgezet de Wet naleven. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Er is hun over jou verteld dat je alle Joden in niet-Joodse gebieden leert om Mozes ontrouw te zijn door hun kinderen niet te besnijden en de Joodse gebruiken niet na te leven. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Wat valt hieraan te doen? Ze zullen zeker horen dat je bent gekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Doe daarom wat wij je vertellen. Wij hebben vier mannen die een plechtige gelofte hebben afgelegd. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Neem hen mee, onderga samen met hen de reinigingsceremonie en betaal hun kosten, zodat ze hun hoofd kunnen laten kaalscheren. Dan zullen alle mensen weten dat de dingen die ze over jou hebben gehoord, niet waar zijn, maar dat je leeft in gehoorzaamheid aan de Wet. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","En wat de niet-Joodse gelovigen betreft, wij hebben hun geschreven over het besluit dat ze zich moeten onthouden van vlees van afgodenoffers, bloed, vlees van verstikte dieren en seksueel wangedrag.” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paulus nam de mannen met zich mee. De volgende dag voerden ze de reinigingsceremonie uit en gingen ze naar het tempelterrein om te melden op welke dag de reiniging voltooid zou zijn en voor elk van hen een offer zou worden gebracht. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Toen de zeven dagen bijna voorbij waren, zagen de Joden uit Asia Paulus op het tempelterrein. Ze stookten de hele menigte op, grepen hem vast ");
INSERT INTO nldgbv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","en riepen: “Israëlieten, help ons! Dit is de man die overal aan alle mensen dingen leert die ingaan tegen ons volk, de Wet en deze plaats. Bovendien heeft hij Grieken het tempelterrein binnengebracht en daardoor dit heiligdom onrein gemaakt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ze hadden namelijk Trofimus van Efeze met hem in de stad gezien en dachten dat Paulus hem had meegenomen naar het tempelterrein. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","De hele stad raakte in rep en roer. De mensen kwamen van alle kanten op hen af, grepen Paulus en sleurden hem het tempelterrein af. Meteen werden de poorten gesloten. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Terwijl ze probeerden hem te vermoorden, ontving de tribuun van de legerafdeling het bericht dat heel Jeruzalem in rep en roer was. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hij verzamelde meteen soldaten en centurio's en haastte zich naar hen toe. Toen de mensen de tribuun en de soldaten zagen, hielden ze op Paulus te slaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","De tribuun kwam op hem af, arresteerde hem en gaf het bevel om hem met twee ketenen te boeien. Toen vroeg hij wie Paulus was en wat hij had gedaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Maar de mensen schreeuwden allemaal door elkaar heen en door het tumult kon hij de feiten niet achterhalen. Daarom gaf hij het bevel, Paulus naar de kazerne te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Toen Paulus de trappen had bereikt, moest hij door de soldaten worden gedragen wegens het gedrang van de menigte. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Er kwam namelijk veel volk achter hen aan, dat “Weg met hem!” schreeuwde. ");
INSERT INTO nldgbv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Op het moment dat Paulus de kazerne zou worden binnengebracht, vroeg hij de tribuun: “Mag ik u iets zeggen?” Hij antwoordde: “Spreekt u Grieks? ");
INSERT INTO nldgbv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bent u dan niet die Egyptenaar die een tijdje geleden in opstand kwam en vierduizend terroristen naar de wildernis heeft geleid?” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus zei: “Ik ben een Jood uit Tarsus in Cilicië, burger van een niet onbelangrijke stad, en ik verzoek u, geef mij toestemming het volk toe te spreken.” ");
INSERT INTO nldgbv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Toen de tribuun zijn toestemming had gegeven, ging Paulus bovenaan de trappen staan en maakte hij een handgebaar naar het volk. Het werd stil en hij sprak hen als volgt toe in het Aramees: ");
INSERT INTO nldgbv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Volksgenoten, raadsleden, luister hoe ik mijzelf tegenover u verdedig.” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Toen ze hoorden dat hij hen toesprak in het Aramees, werden ze nog stiller. Hij vervolgde: ");
INSERT INTO nldgbv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ik ben een Jood, geboren in Tarsus in Cilicië, maar ik ben hier in Jeruzalem opgegroeid. Als leerling van Gamaliël ben ik grondig opgeleid in de Wet van onze voorouders en ik was God zeer toegewijd, net als u allen hier. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ik heb de aanhangers van de Weg tot de dood toe vervolgd, mannen en vrouwen heb ik gearresteerd en gevangen laten zetten. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Zelfs de hogepriester en de hele raad van volksoudsten kunnen daarvan getuigen. Ik had brieven van hen meegekregen voor onze volksgenoten in Damascus, toen ik daarheen ging om die mensen gevangen te nemen en naar Jeruzalem te brengen zodat ze gestraft konden worden. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Maar onderweg, toen ik bijna bij Damascus was, omstraalde mij rond de middag plots een fel licht uit de hemel. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ik viel op de grond en hoorde een stem tegen me zeggen: ‘Saul, Saul, waarom vervolg je Mij?’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ik antwoordde: ‘Wie bent U, Heer?’ Hij zei tegen mij: ‘Ik ben Jezus van Nazaret, degene die jij vervolgt.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","De mensen bij mij zagen wel het licht, maar hoorden niet de stem van Degene die mij toesprak. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","En ik zei: ‘Wat zal ik doen, Heer?’ En de Heer zei tegen mij: ‘Kom overeind en ga Damascus binnen. Daar zal je worden verteld over al het werk waarvoor ik jou heb aangesteld.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Omdat ik door het felle licht niets meer kon zien, werd ik door mijn reisgenoten bij de hand genomen en Damascus binnengeleid. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","En een zekere Ananias, iemand die zich eerbiedig aan de Wet hield en over wie lovend werd gesproken door alle Joodse mensen die daar woonden, ");
INSERT INTO nldgbv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","kwam naar me toe, ging voor me staan en zei tegen mij: ‘Saul, broer, word ziende!’ En meteen kon ik hem zien. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ananias vervolgde: ‘De God van onze voorouders heeft jou aangesteld om te weten wat Hij wil en om de Rechtvaardige te zien en zijn stem te horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Je zal, als zijn getuige, aan alle mensen vertellen wat je hebt gezien en gehoord. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wat aarzel je nog? Sta op, laat je dopen en je zonden wegwassen terwijl je Hem aanroept.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Later, toen ik naar Jeruzalem was teruggekeerd en op het tempelterrein aan het bidden was, kreeg ik een visioen. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ik zag God en Hij zei tegen mij: ‘Snel, vertrek onmiddellijk uit Jeruzalem, want ze zullen jouw getuigenis over Mij niet aanvaarden.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Maar ik zei: ‘Heer, ze weten dat ik in alle synagogen de mensen die in U geloven gevangennam en liet geselen. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","En toen het bloed van uw getuige Stefanus werd vergoten, stond ik erbij. Ik stemde ermee in en paste op de mantels van degenen die hem ombrachten.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Hij zei tegen mij: ‘Ga, want Ik zal je sturen naar de volken ver weg.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tot dan toe hadden de mensen naar Paulus' toespraak geluisterd, maar nu begonnen ze luid te roepen: “Neem die man van de aarde weg! Hij verdient het niet om te leven!” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Al schreeuwend gooiden ze hun mantels van zich af en wierpen ze stof in de lucht. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","De tribuun gaf het bevel, Paulus de kazerne binnen te brengen en hem onder geseling te verhoren om te weten te komen waarom ze zo tegen hem schreeuwden. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Toen ze hem vastmaakten om te worden gegeseld, zei Paulus tegen de centurio die erbij stond: “Mogen jullie een Romeins staatsburger geselen en dan nog wel zonder vonnis?” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Toen de centurio dat hoorde, ging hij de tribuun verwittigen: “Wat bent u nu van plan? Deze man is een Romeins staatsburger!” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","De tribuun ging naar Paulus toe en vroeg hem: “Zeg eens, bent u een Romeins staatsburger?” Hij antwoordde: “Ja”. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","De tribuun vertelde: “Ik heb veel geld betaald voor mijn staatsburgerschap.” En Paulus zei: “Maar ik ben ermee geboren.” ");
INSERT INTO nldgbv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Meteen trokken de mensen die hem zouden ondervragen zich terug. Ook de tribuun werd bang, want hij besefte dat hij Paulus, een Romeins staatsburger, had laten boeien. ");
INSERT INTO nldgbv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","De tribuun wilde precies weten waarvan Paulus door de Joden werd beschuldigd. Daarom beval hij de volgende dag dat de hoofdpriesters en de hele Joodse raad moesten bijeenkomen. Paulus liet hij uit de gevangenis ophalen, naar hen toebrengen en aan hen voorleiden. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus keek de Joodse raad aan en zei: “Volksgenoten, ik heb tot nu toe altijd met een goed geweten mijn plichten jegens God vervuld.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Toen gaf hogepriester Ananias de mensen die bij Paulus stonden de opdracht hem op de mond te slaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Daarom zei Paulus tegen hem: “God zal u slaan, witgekalkte muur! U zit daar om mij volgens de Wet te berechten en u overtreedt de Wet door opdracht te geven mij te slaan?” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","De mensen die bij Paulus stonden, zeiden: “Jij beledigt Gods hogepriester!” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Maar Paulus zei: “Volksgenoten, ik wist niet dat hij de hogepriester is. Want in de Schriften staat: ‘Je mag niet kwaadspreken over de leider van je volk.’” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulus wist dat een deel van de Joodse raad uit sadduceeën bestond en een ander deel uit farizeeën. Daarom riep hij uit: “Volksgenoten, ik ben een farizeeër uit een familie van farizeeën en ik sta terecht voor mijn verwachting dat de doden zullen verrijzen!” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Zodra hij dat gezegd had, ontstond er onenigheid tussen de farizeeën en de sadduceeën en raakte de vergadering intern verdeeld. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","De sadduceeën zeggen immers dat er geen verrijzenis is, en ook geen engelen of geesten, maar de farizeeën zeggen dat ze wel bestaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Er ontstond grote commotie. Enkele farizese Schriftgeleerden stonden op en betoogden vurig: “Wij vinden niets verkeerds in deze man. Wat als een geest of een engel tot hem heeft gesproken?” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","De onenigheid werd zo groot dat de tribuun vreesde dat Paulus door hen aan stukken zou worden gereten. Hij liet de soldaten komen om hem uit hun midden weg te halen en naar de kazerne te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Die nacht kwam de Heer naar Paulus toe. Hij zei: “Wees moedig, want zoals je over Mij hebt getuigd in Jeruzalem, moet je ook in Rome getuigen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Toen het ochtend werd, smeedden enkele Joodse mensen een complot: ze zwoeren dat ze niet zouden eten of drinken voordat ze Paulus hadden gedood. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Meer dan veertig personen waren bij deze samenzwering betrokken. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ze benaderden de hoofdpriesters en oudsten en zeiden: “Wij hebben gezworen om niet te eten voordat we Paulus hebben gedood. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Stuur daarom namens de Joodse raad een verzoek naar de tribuun om hem aan u voor te leiden, alsof u zijn zaak nauwkeuriger wilt onderzoeken. Dan staan wij klaar om hem om te brengen terwijl hij onderweg is.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Maar toen de zoon van Paulus' zus over de hinderlaag hoorde, begaf hij zich naar de kazerne en ging hij naar binnen om Paulus te verwittigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulus riep een van de centurio's bij zich en zei: “Breng deze jongeman naar de tribuun, want hij heeft hem iets te melden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","De centurio nam hem mee naar de tribuun en zei: “Gevangene Paulus heeft mij bij zich geroepen en me verzocht deze jongeman bij u te brengen, omdat hij u iets te zeggen heeft.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","De tribuun nam hem bij de hand, nam hem apart en vroeg: “Wat heb je mij te melden?” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","De jongeman zei: “De Joden zijn met elkaar overeengekomen om u te verzoeken, Paulus morgen naar de Joodse raad te brengen, zogezegd om de zaak nader te onderzoeken. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Laat u echter niet door hen overreden, want meer dan veertig van hen willen hem in een hinderlaag lokken. Zij hebben gezworen om niet te eten of te drinken voordat ze hem hebben omgebracht, en nu staan ze klaar, in afwachting van uw toestemming.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","De tribuun liet de jongeman gaan, nadat hij hem had gewaarschuwd: “Laat aan niemand weten dat je mij hierover hebt ingelicht.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Vervolgens riep hij twee van zijn centurio's en zei: “Zorg dat er vanavond om negen uur tweehonderd soldaten, zeventig ruiters en tweehonderd speerdragers klaarstaan om naar Caesarea te vertrekken. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Zorg ook voor rijdieren voor Paulus, zodat hij bij gouverneur Felix in veiligheid kan worden gebracht.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ook schreef hij een brief met de volgende inhoud: ");
INSERT INTO nldgbv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Van Claudius Lysias aan zijne excellentie gouverneur Felix. Gegroet! ");
INSERT INTO nldgbv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Deze man is door de Joden opgepakt en was bijna door hen vermoord. Ik ben er met mijn afdeling soldaten naartoe gegaan en heb hem in veiligheid gebracht, want ik had vernomen dat hij een Romeins staatsburger is. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","En omdat ik wilde weten waarvan ze hem beschuldigden, heb ik hem naar hun raad gebracht. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Daar stelde ik vast dat hij werd beschuldigd van iets dat verband hield met hun wetten. Er was echter geen tenlastelegging voor iets waarop de dood of gevangenisstraf staat. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Omdat ik ben verwittigd van een complot tegen de man, stuur ik hem naar u toe en heb ik zijn aanklagers opgedragen aan u te vertellen wat ze tegen hem hebben.” ");
INSERT INTO nldgbv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Zoals hun was opgedragen, haalden de soldaten Paulus op om hem 's nachts naar Antipatris te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","'s Ochtends lieten ze de ruiters met Paulus verder rijden en keerden ze zelf naar de kazerne terug. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na hun aankomst in Caesarea overhandigden de ruiters de brief aan de gouverneur, en droegen ze Paulus aan hem over. ");
INSERT INTO nldgbv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","De gouverneur las de brief en vroeg Paulus uit welke provincie hij afkomstig was. Toen hij vernam dat Paulus uit Cilicië kwam, ");
INSERT INTO nldgbv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","zei hij: “Ik zal je verhoren zodra je aanklagers zijn aangekomen.” Hij gaf het bevel, Paulus gevangen te houden in het paleis dat Herodes had laten bouwen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na vijf dagen kwam hogepriester Ananias aan, met enkele oudsten en een advocaat die Tertullus heette. Zij dienden hun aanklacht tegen Paulus in bij de gouverneur. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulus werd binnengeroepen en Tertullus begon zijn beschuldigingsrede. Hij zei: “Dat wij dankzij u volop van vrede genieten en dat uw vooruitziendheid hervormingen oplevert ten bate van ons volk, ");
INSERT INTO nldgbv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","excellentie Felix, wordt door ons altijd en overal met diepe dankbaarheid erkend. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Om u niet te lang op te houden, verzoek ik u ons in uw welwillendheid kort aan te horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Wij hebben namelijk ontdekt dat deze man een ruziemaker is die rellen veroorzaakt onder alle Joodse mensen in het hele rijk. Hij is een van de hoofdleiders van de volgelingen van de Man van Nazaret. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hij heeft zelfs geprobeerd, de tempel te ontwijden en daarom hebben wij hem opgepakt. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Als u hem zelf verhoort, zal u alles te weten komen waarvan wij hem beschuldigen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","De Joodse mensen vielen hem bij door te zeggen dat het waar was. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Maar toen de gouverneur aangaf dat Paulus mocht spreken, antwoordde deze: “Ik weet dat u al vele jaren rechter voor dit volk bent. Daarom zal ik mijzelf vol goede moed in deze zaak verdedigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Zoals u kan controleren, ben ik pas twaalf dagen geleden naar Jeruzalem gekomen om God te aanbidden. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Niemand heeft mij op het tempelterrein met mensen zien discussiëren of een oploop zien veroorzaken, ook niet in de synagogen of in de stad. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Verder kunnen ze de dingen waarvan zij mij beschuldigen, niet bewijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Maar ik beken u wel dat ik de God van onze voorouders vereer volgens de Weg die zij een sekte noemen, en dat ik alles geloof wat overeenstemt met de Wet en wat in de Profeten staat. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","En evenals mijn aanklagers verwacht ik dat God zowel de rechtvaardigen als de onrechtvaardigen zal doen verrijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Daarom doe ik mijn best om altijd een zuiver geweten te hebben tegenover God en de mensen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Na een afwezigheid van vele jaren ben ik naar mijn land teruggekomen om giften aan de armen te geven en offers te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Dat was ik aan het doen toen men mij in de tempel aantrof, waar ik pas de reinigingsceremonie had uitgevoerd; er was geen samenscholing en geen commotie. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Maar er zijn enkele Joodse mensen uit Asia die voor u zouden moeten verschijnen om mij te beschuldigen als zij iets tegen mij hebben. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Of laat wie hier aanwezig is verklaren aan welke overtreding zij mij schuldig hebben bevonden toen ik voor de Joodse raad stond. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Of het moest die ene uitroep zijn die ik deed toen ik voor hen stond: ‘Het is in verband met de verrijzenis van de doden dat ik vandaag voor u terecht sta’.” ");
INSERT INTO nldgbv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Maar Felix, die goed op de hoogte was van de Weg, verdaagde de zitting en zei: “Wanneer Lysias de tribuun komt, zal ik over uw zaak beslissen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Hij beval de centurio, Paulus gevangen te houden onder licht regime. Ook mocht geen van Paulus' assistenten worden verhinderd hem bij te staan. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Enkele dagen later kwam Felix vergezeld van zijn vrouw Drusilla, die Jodin was. Hij liet Paulus ophalen en liet hem vertellen over zijn geloof in Christus Jezus. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Maar toen Paulus sprak over gerechtigheid, zelfbeheersing en het komende Oordeel, werd Felix heel bang en onderbrak hij hem: “Zo is het genoeg, u mag beschikken. Wanneer ik weer tijd heb zal ik u ontbieden.” ");
INSERT INTO nldgbv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tegelijkertijd hoopte hij dat Paulus hem geld zou aanbieden. Daarom liet hij hem vaak ontbieden om met hem te praten. ");
INSERT INTO nldgbv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Na verloop van twee jaar werd Felix opgevolgd door Porcius Festus. En om de Joodse mensen een gunst te bewijzen, liet Felix Paulus in gevangenschap achter. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Drie dagen nadat Festus in de provincie was aangekomen, begaf hij zich van Caesarea naar Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Daar dienden de hoofdpriesters en andere Joodse leiders hun aanklacht tegen Paulus bij hem in. Ze verzochten Festus, ");
INSERT INTO nldgbv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","hun een gunst te bewijzen door Paulus naar Jeruzalem te laten overbrengen. Ze hadden namelijk een hinderlaag voorbereid om hem onderweg te kunnen doden. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Maar Festus antwoordde dat Paulus in Caesarea zou blijven en dat hijzelf daar binnenkort naartoe wilde gaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Hij zei: “Enkele van jullie leiders mogen meekomen en als die man iets heeft misdaan, kunnen zij hem daar in beschuldiging stellen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Hij bleef niet langer dan acht of tien dagen en ging terug naar Caesarea. De volgende ochtend nam hij plaats op de rechterstoel en gaf bevel, Paulus voor te leiden. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Toen Paulus was binnengekomen, gingen de Joodse mensen die uit Jeruzalem waren gekomen om hem heen staan. Ze brachten allerlei zware beschuldigingen tegen hem in, die ze niet konden bewijzen. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulus verdedigde zich: “Ik heb niets misdaan; niet tegen de Joodse Wet, niet tegen de tempel en ook niet tegen de keizer.” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus, die de Joodse mensen een gunst wilde bewijzen, vroeg aan Paulus: “Bent u bereid naar Jeruzalem te gaan om daar in deze zaak voor mij terecht te staan?” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus antwoordde: “Ik sta hier voor de keizerlijke rechterstoel, waar ik berecht moet worden. Zoals u goed beseft heb ik de Joodse mensen niets misdaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Als ik iets verkeerds heb gedaan waarop de doodstraf staat, zal ik mij niet tegen de dood verzetten. Maar als de dingen waarvan zij mij beschuldigen onwaar zijn, heeft niemand het recht mij aan hen uit te leveren. Ik beroep me op de keizer!” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus overlegde met zijn adviesraad en antwoordde: “U hebt zich op de keizer beroepen, naar de keizer zal u gaan.” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Na verloop van enkele dagen kwam koning Agrippa met Bernice naar Caesarea voor een beleefdheidsbezoek aan Festus. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Toen ze daar al verscheidene dagen waren, vertelde Festus de koning over de rechtszaak tegen Paulus. Festus zei: “Er is hier iemand die door Felix als gevangene is achtergelaten, ");
INSERT INTO nldgbv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","tegen wie een aanklacht werd ingediend door de Joodse hoofdpriesters en oudsten toen ik Jeruzalem bezocht. Ze vroegen mij, hem te veroordelen. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ik heb hun geantwoord dat het bij de Romeinen niet de gewoonte is om iemand over te leveren voordat de beschuldigde voor zijn aanklagers is verschenen en de gelegenheid heeft gekregen om zich tegen de aanklacht te verdedigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Dus toen ze met zijn allen hier kwamen, heb ik zonder uitstel de volgende dag op de rechterstoel plaatsgenomen en de man laten voorleiden. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Maar toen de aanklagers opstonden, beschuldigden ze hem helemaal niet van de misdaden die ik had verwacht. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Wel hadden ze onenigheid met hem over hun godsdienst en over een zekere Jezus, die gestorven is en van wie Paulus beweert dat hij leeft. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","En omdat het mij onduidelijk was hoe ik deze kwestie kon onderzoeken, vroeg ik of hij bereid was naar Jeruzalem te gaan om daar voor deze dingen te worden berecht. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Maar toen Paulus mij verzocht om hem in bewaring te houden in afwachting van het besluit van de keizer, gaf ik bevel hem in bewaring te houden totdat ik hem naar Caesar kan sturen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa zei tegen Festus: “Ik wil die man ook wel eens horen.” Festus antwoordde: “Morgen zal u hem horen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","De volgende ochtend kwamen Agrippa en Bernice in vol ornaat binnen. Ze gingen de gehoorzaal binnen met de militaire leiders en de voorname mannen van de stad. Op het bevel van Festus werd Paulus voorgeleid. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus zei: “Koning Agrippa en iedereen die hier met ons aanwezig is, hier ziet u de man om wie de hele Joodse gemeenschap, zowel in Jeruzalem als hier, zich tot mij heeft gericht. Ze roepen dat hij niet langer hoort te leven. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ik heb vastgesteld dat hij niets heeft gedaan waarop de doodstraf staat, maar omdat hij zich op de keizer heeft beroepen, heb ik besloten hem naar Rome te sturen. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ik heb echter niets concreets over hem dat ik aan zijne majesteit kan schrijven. Daarom leid ik hem aan u allen voor, in het bijzonder aan u, koning Agrippa, zodat ik na afloop van het onderzoek iets zal hebben dat ik kan schrijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Want het lijkt mij onredelijk een gevangene door te sturen zonder duidelijk te maken wat de aanklacht tegen hem is.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa zei tegen Paulus: “U mag voor uzelf pleiten.” Paulus maakte een handgebaar en verdedigde zichzelf als volgt: ");
INSERT INTO nldgbv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Koning Agrippa, ik prijs mezelf gelukkig dat ik mij vandaag tegenover u mag verdedigen voor alles waarvan ik door de Joodse mensen word beschuldigd, ");
INSERT INTO nldgbv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","vooral omdat u goed bekend bent met alle Joodse gebruiken en twistpunten. Daarom verzoek ik u, mij geduldig aan te horen. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Alle Joodse mensen weten hoe ik van kinds af aan heb geleefd, eerst in mijn eigen land en later ook in Jeruzalem. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Zij kennen mij al lang, en als ze daartoe bereid zijn kunnen ze bevestigen dat ik als een farizeeër heb geleefd, dus volgens de strengste stroming binnen onze religie. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","En nu sta ik terecht omdat ik verwacht dat God zijn belofte aan onze voorouders zal waarmaken. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Onze twaalf stammen vereren God dag en nacht terwijl ze de vervulling van die belofte verwachten. Het is omwille van die verwachting, majesteit, dat ik door de Joodse mensen word beschuldigd. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Waarom vinden jullie het zo ongeloofwaardig dat God doden doet verrijzen? ");
INSERT INTO nldgbv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Vroeger dacht ik dat ik de naam van Jezus van Nazaret krachtig moest bestrijden. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","En dat heb ik ook gedaan! Ik heb in Jeruzalem veel mensen die in Jezus geloofden in de gevangenis laten opsluiten, want ik had daarvoor de bevoegdheid gekregen van de hoofdpriesters. Ook stemde ik voor de doodstraf voor die mensen. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Vaak ben ik alle synagogen langsgegaan om hen met geweld te dwingen hun geloof af te zweren. Ik ging verschrikkelijk tegen hen tekeer en vervolgde hen tot in steden buiten ons land. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Maar toen ik in dat kader naar Damascus ging, met de instemming van de hoofdpriesters en door hen gemandateerd, ");
INSERT INTO nldgbv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","zag ik onderweg, o majesteit, midden op de dag een licht uit de hemel dat feller was dan de zon en dat mij en mijn reisgenoten omstraalde. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","We vielen allemaal op de grond en ik hoorde een stem die in het Aramees tegen mij zei: ‘Saul, Saul, waarom vervolg je Mij? Je doet jezelf pijn door je tegen Mij te verzetten.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ik vroeg: ‘Wie bent U, Heer?’ En de Heer zei: ‘Ik ben Jezus, degene die jij vervolgt. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kom overeind en ga op je voeten staan, want Ik ben aan je verschenen om je aan te stellen als mijn dienaar en als getuige van wat Ik je heb laten zien en van hetgeen Ik je nog ga tonen. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ik zal je beschermen tegen je volksgenoten, maar ook tegen de niet-Joden naar wie ik je toe stuur ");
INSERT INTO nldgbv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","om hun ogen te openen en hen uit het donker naar het licht te leiden, en uit de macht van de satan naar God. Daardoor zullen zij vergeving van zonden ontvangen en voor altijd deel mogen uitmaken van de mensen die door hun geloof in Mij heilig zijn geworden.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Sindsdien, koning Agrippa, ben ik altijd gehoorzaam geweest aan dat hemelse visioen. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ik heb eerst aan de inwoners van Damascus, en dan in Jeruzalem en het gebied Judea, en zelfs aan niet-Joden verkondigd dat ze tot inkeer moeten komen, zich tot God moeten bekeren en moeten handelen overeenkomstig hun inkeer. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Daarom hebben enkele Joodse mensen mij in de tempel opgepakt en geprobeerd mij om te brengen. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tot de dag van vandaag heb ik echter altijd steun van God ontvangen. Ik sta hier en leg getuigenis af aan de mensen, zowel de aanzienlijken als de eenvoudigen. Ik vertel niets waarvan niet reeds door de profeten en Mozes was gezegd dat het ging gebeuren, ");
INSERT INTO nldgbv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","namelijk dat de Messias zou moeten lijden en dat Hij als eerste van de doden zou verrijzen om aan zowel ons volk als aan de niet-Joden het licht te verkondigen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulus was nog met deze verdedigingsrede bezig, toen Festus uitriep: “Je bent gek, Paulus, al dat studeren heeft je gek gemaakt.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulus antwoordde: “Ik ben niet gek, hoogedele Festus, de woorden die ik spreek zijn waar en doordacht. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","En de koning is met deze dingen bekend. Daarom spreek ik hem vrijmoedig toe, want ik ben ervan overtuigd dat niets hiervan hem is ontgaan, want ze hebben zich niet in een uithoek afgespeeld. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Koning Agrippa, u gelooft toch de profeten? Ik weet dat u ze gelooft.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa zei tegen Paulus: “Ga je straks proberen mij te overtuigen om christen te worden?” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","En Paulus zei: “Ik zou God willen vragen dat – straks of later – niet alleen u maar ook alle mensen die mij vandaag horen, mogen worden zoals ik, maar dan zonder deze boeien.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","De koning stond op, en ook de gouverneur, Bernice en de anderen die de zitting hadden bijgewoond. ");
INSERT INTO nldgbv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ze verlieten de zaal en zeiden tegen elkaar: “Deze man heeft niets gedaan waarop de dood of gevangenisstraf staat.” ");
INSERT INTO nldgbv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa zei tegen Festus: “Deze man had nu kunnen worden vrijgelaten als hij zich niet op de keizer had beroepen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nadat besloten was dat we naar Italië zouden varen, werden Paulus en enkele andere gevangenen overgedragen aan een centurio die Julius heette; hij was van de keizerlijke afdeling. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","We gingen aan boord van een schip uit Adramyttium dat de havens aan de kust van Asia zou aandoen en voeren weg. Aristarchus, een Macedoniër uit Tessalonica, was bij ons. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","De volgende dag kwamen we aan in de haven van Sidon. Julius behandelde Paulus vriendelijk en liet toe dat hij zijn vrienden bezocht om zich door hen te laten verzorgen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","We vervolgden onze zeereis en voeren Cyprus aan de beschutte kant voorbij, omdat we de wind tegen hadden. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nadat we de open zee bij Cilicië en Pamfylië waren overgestoken, kwamen we aan bij Myra in Lycië. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Daar vond de centurio een Alexandrijns schip dat naar Italië zou gaan en hij scheepte ons in. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","We vorderden traag en met moeite; het was pas na vele dagen dat we Knidus bereikten. En omdat we de wind tegen hadden, voeren we Kreta aan de beschutte kant, de kant van Salmone, voorbij. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","We voeren het met moeite voorbij en kwamen bij een plaats die Schone Haven heet, vlak bij Lasea. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Omdat er zoveel tijd was verlopen en de vastenperiode ook al voorbij was, werd het gevaarlijk om verder te varen. Paulus waarschuwde: ");
INSERT INTO nldgbv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mannen, ik voorzie dat onze zeereis met moeilijkheden en veel verlies gepaard zal gaan, en niet alleen voor de lading en het schip. Ook onze levens staan op het spel.” ");
INSERT INTO nldgbv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","In plaats van Paulus' woorden ter harte te nemen, liet de centurio zich overtuigen door de stuurman en de eigenaar van het schip. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","En omdat de haven niet geschikt was om er te overwinteren, werd door de meerderheid besloten om verder te varen en te kijken of ze Fenix konden bereiken om daar te overwinteren. Fenix is een haven op Kreta met uitzicht op het zuid- en het noordwesten. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Dus toen er een zachte zuidenwind opstak, dachten ze dat het wel zou lukken. Ze lichtten het anker en voeren dicht langs de kust van Kreta verder. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Maar kort daarna stak vanaf het eiland een zware stormwind op, die Eurakylon wordt genoemd. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Omdat het schip werd meegesleurd en de kop niet in de wind kon houden, gaven we ons gewonnen en lieten we ons meedrijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","We voeren langs de beschutte kant van een eilandje dat Kauda heet, waar we met moeite de sloep onder controle konden krijgen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","De bemanningsleden hesen hem aan boord en verstevigden de romp van het schip met touwen. Omdat ze bang waren om bij Syrtis vast te lopen, wierpen ze het drijfanker uit en lieten ze het schip drijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","De storm ging zo hard tekeer dat ze de volgende dag lading overboord gooiden. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","En op de derde dag gooiden ze eigenhandig het scheepstuig overboord. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Dagenlang zagen we geen licht van de zon of de sterren. De storm bleef woeden en we hadden geen enkele hoop op redding meer. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nadat er aan boord lange tijd niet was gegeten, ging Paulus tussen de bemanningsleden staan en zei: “Mannen, jullie hadden naar mij moeten luisteren en niet uit Kreta moeten vertrekken. Dan waren deze moeilijkheden en dit verlies jullie bespaard gebleven. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Maar nu spoor ik jullie aan om moed te houden, want geen van jullie zal zijn leven verliezen. Alleen het schip zal vergaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Vannacht kwam er namelijk een engel van de God aan wie ik toebehoor en die ik vereer, bij mij staan. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Hij zei: ‘Wees niet bang, Paulus, je moet voor de keizer terechtstaan en God zal, als een gunst aan jou, al je medeopvarenden in leven houden.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Daarom, mannen, houd moed, want ik vertrouw erop dat God zal zorgen dat het precies zo zal verlopen als mij verteld is. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Maar we moeten stranden bij een eiland.” ");
INSERT INTO nldgbv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Toen brak de veertiende nacht aan. We waren nog altijd op drift in de Adriatische Zee, maar midden in de nacht vermoedden de bemanningsleden dat we land naderden. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ze peilden de diepte: 40 meter. Toen ze iets verder waren gevorderd, peilden ze opnieuw: 30 meter. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Omdat ze bang waren dat we op de klippen zouden lopen, wierpen ze vier ankers uit van de achtersteven en ze baden dat het licht zou worden. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","De bemanning wilde van het schip ontsnappen en liet de sloep in zee zakken onder het voorwendsel dat ze vanaf de voorsteven ankers wilden uitwerpen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Maar Paulus zei tegen de centurio en de soldaten: “Als zij niet aan boord blijven, kunnen jullie niet worden gered.” ");
INSERT INTO nldgbv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Daarom kapten de soldaten de touwen van de sloep door en lieten ze die wegdrijven. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Vlak voordat het licht werd, spoorde Paulus iedereen aan om te eten. Hij zei: “Vandaag is al de veertiende dag dat jullie afwachten zonder te eten en doorwerken zonder een maaltijd te nuttigen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Daarom raad ik jullie aan om te eten, want dat hebben jullie nodig om te overleven. Niemand van jullie zal zelfs maar een hoofdhaar verliezen.” ");
INSERT INTO nldgbv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nadat hij dit had gezegd, nam hij brood, dankte God waar ze allen bij waren, brak het en begon te eten. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ze raakten er allen door bemoedigd en begonnen zelf ook te eten. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","We waren in totaal met 276 opvarenden. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Toen ze voldoende hadden gegeten, maakten ze het schip lichter door het graan in zee te gooien. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Toen het licht werd, herkenden ze het land niet. Wel zagen ze een inham met een strand en besloten ze een poging te wagen het schip daar te laten vastlopen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ze maakten de ankers los en lieten die in de zee achter. Tegelijkertijd maakten ze de touwen los waarmee het dubbelroer was vastgezet. Toen hesen ze het voorzeil en zetten ze voor de wind koers naar het strand. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Het schip kwam in ondiep water terecht en ze lieten het vastlopen. De voorsteven kwam onwrikbaar vast te zitten, maar door de kracht van de golven begon de achtersteven te breken. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","De soldaten waren van plan de gevangenen te doden om te voorkomen dat er iemand zwemmend zou ontsnappen. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Maar de centurio wilde Paulus sparen en weerhield hen van hun plan. Hij beval dat wie kon zwemmen, het eerst overboord zou springen om aan land te gaan. ");
INSERT INTO nldgbv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","De rest zou volgen op planken of andere stukken van het schip. En zo kwam iedereen veilig aan land. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Pas toen we in veiligheid waren, kwamen we te weten dat het eiland Malta heet. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","De inheemse bewoners behandelden ons met buitengewone vriendelijkheid: ze maakten een vuur en haalden ons er allemaal bij omdat het was gaan regenen en vanwege de kou. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Maar toen Paulus een hoeveelheid brandhout die hij had bijeengeraapt op het vuur gooide, kwam er door de hitte een adder uitgekropen, die zich in zijn hand vastbeet. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","De inheemse mensen zagen het dier aan zijn hand hangen en zeiden tegen elkaar: “Die man is vast een moordenaar. En nu hij veilig uit de zee is gekomen, laat de godin Gerechtigheid niet toe dat hij in leven blijft.” ");
INSERT INTO nldgbv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulus schudde het dier van zich af, het vuur in, en bleef ongedeerd. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","De mensen verwachtten dat hij een zwelling zou krijgen of plots dood zou neervallen. Maar toen ze na lang wachten zagen dat er niets ongewoons met hem gebeurde, veranderden ze van mening en zeiden ze dat hij een god was. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","In de buurt van die plaats was een landgoed dat toebehoorde aan de gouverneur van het eiland, die Publius heette. Hij verwelkomde ons en verleende ons drie dagen lang gastvrij onderdak. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","De vader van Publius lag in bed, gekweld door koorts en dysenterie. Paulus ging naar hem toe en genas hem door te bidden en hem de handen op te leggen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nadat dit was gebeurd, kwamen ook de andere zieken van het eiland naar hem toe en zij werden genezen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ze overlaadden ons met eerbewijzen en bij ons vertrek gaven ze ons wat we nodig hadden. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Na drie maanden vertrokken we met een schip dat op het eiland had overwinterd. Het kwam uit Alexandrië en had een boegbeeld van de twee beschermgoden voor de scheepvaart. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Toen we in Syracuse waren aangekomen, bleven we daar drie dagen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Daarvandaan voeren we verder tot we in Regium aankwamen. Na een dag stak er een zuidenwind op, zodat we de dag daarna Puteoli bereikten. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Daar ontmoetten we enkele geloofsgenoten en werden we uitgenodigd een week bij hen te blijven. En zo zijn we in Rome aangekomen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","De christenen daar hadden over ons gehoord en kwamen ons tegemoet tot Forum Appii en Tres Tabernae. Toen Paulus hen zag, dankte hij God en vatte hij moed. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","En in Rome aangekomen mocht Paulus zelfstandig wonen onder bewaking van een soldaat. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Na drie dagen riep Paulus de Joodse leiders bijeen. Toen ze allen bij hem waren, zei hij tegen hen: “Volksgenoten, hoewel ik niets heb misdaan tegen ons volk of de gebruiken van onze voorouders, ben ik als gevangene uit Jeruzalem aan de Romeinen overgeleverd. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Die hebben mij verhoord en waren van plan mij vrij te laten omdat er geen reden was mij ter dood te veroordelen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Maar omdat de Joodse mensen bezwaar maakten, moest ik me wel op de keizer beroepen. Het is echter niet zo dat ik een aanklacht tegen mijn volk heb. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Het is om die reden dat ik heb verzocht om u te zien en te spreken. Want het is omwille van de hoop van Israël dat ik deze ketenen draag.” ");
INSERT INTO nldgbv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Zij zeiden tegen hem: “Wij hebben geen brieven over u ontvangen uit Judea, en ook is er niemand van ons volk aangekomen die iets slechts over u rapporteerde of zei. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Maar wij willen graag uw opvattingen horen, want het is ons bekend dat overal kritiek wordt geleverd op die stroming.” ");
INSERT INTO nldgbv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ze spraken een dag met hem af en kwamen met velen naar hem toe op de plaats waar hij verbleef. En van de ochtend tot de avond sprak hij met hen, getuigde hij over Gods koninkrijk en probeerde hij hen voor Jezus te winnen op basis van de Wet van Mozes en van de profetische boeken. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sommigen raakten overtuigd van wat hij zei, anderen geloofden hem niet. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ze raakten het niet met elkaar eens en bij hun vertrek deed Paulus nog één uitspraak: “De Heilige Geest had gelijk toen Hij bij monde van de profeet Jesaja over uw voorvaders zei: ");
INSERT INTO nldgbv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ga naar dit volk en zeg: Jullie zullen wel horen maar niet verstaan, en wel zien maar niet begrijpen. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Want het hart van dit volk is gevoelloos geworden, hun oren kunnen nauwelijks horen en hun ogen hebben ze gesloten. Anders zouden ze met hun ogen kunnen zien en met hun oren kunnen horen en met hun hart verstaan en zich bekeren en dan zou Ik hen gezond maken.’ ");
INSERT INTO nldgbv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Daarom moeten jullie weten dat Gods redding naar de niet-Joden is gezonden en dat zij wel zullen luisteren.” ");
INSERT INTO nldgbv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulus verbleef twee hele jaren in de woning die hij huurde. Hij verwelkomde iedereen die bij hem op bezoek kwam. ");
INSERT INTO nldgbv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","In alle vrijmoedigheid en ongehinderd verkondigde hij Gods koninkrijk en onderwees hij over de Heer Jezus Christus.");
INSERT INTO nldgbv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Van: Paulus, dienaar van Christus Jezus, geroepen om als apostel ten dienste te staan van Gods evangelie. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","God had het evangelie lang geleden via zijn profeten in de heilige Schriften beloofd. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Het is het goede nieuws over zijn Zoon, die wat zijn aardse leven betreft een afstammeling van David is, ");
INSERT INTO nldgbv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","en die door zijn verrijzenis uit de dood op krachtige wijze door de Heilige Geest is uitgeroepen tot de Zoon van God – Jezus de Messias, onze Heer. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Het is door Hem dat wij het voorrecht ontvangen hebben om apostel te zijn, opdat bij alle volken mensen tot geloof en gehoorzaamheid aan God zouden komen en Hij geëerd zou worden. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","En jullie behoren tot die mensen: jullie zijn geroepen om bij Jezus Christus te horen. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Aan: alle door God geliefde en geroepen christenen in Rome. Wij wensen jullie de genade en vrede van God, onze Vader, en van de Heer Jezus Christus toe. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Allereerst dank ik mijn God, via Jezus Christus, voor jullie allen, want het nieuws over jullie geloof wordt in de hele wereld verspreid. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","God, die ik van harte dien door het evangelie van zijn Zoon te verkondigen, kan bevestigen dat ik jullie voortdurend noem ");
INSERT INTO nldgbv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","in mijn gebeden. Dan vraag ik altijd aan God dat ik jullie eindelijk zal kunnen bezoeken – als Hij het ook wil. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ik verlang ernaar jullie te zien en een geestelijke zegen met jullie te delen om jullie te sterken. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Of beter gezegd: dan kunnen we wederzijds bemoedigd worden – ik door jullie geloof en jullie door dat van mij. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Broeders en zusters, jullie moeten weten dat ik dikwijls van plan ben geweest om jullie te bezoeken, maar tot nu toe werd ik steeds verhinderd. Ik wil namelijk ook bij jullie oogsten, zoals ik dat ook heb gedaan bij de andere niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ik sta in het krijt bij zowel Grieken als niet-Grieken, bij zowel geletterde als ongeletterde mensen. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Daarom wil ik zo graag ook aan jullie in Rome het evangelie verkondigen. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Het evangelie brengt mij niet in verlegenheid, want het is Gods krachtige nieuws, dat redding brengt voor allen die geloven – in de eerste plaats Joden, maar ook niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Het evangelie maakt duidelijk hoe men enkel en alleen door te geloven met God in het reine kan komen. In de Schriften staat immers: “De rechtvaardige zal het leven ontvangen door middel van het geloof.” ");
INSERT INTO nldgbv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Vanuit de hemel wordt namelijk duidelijk gemaakt dat God alle goddeloosheid en kwaad van mensen die met hun kwaad de waarheid verdringen, zal straffen. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Wat over God geweten kan worden, is hun duidelijk, want God heeft het hun bekendgemaakt. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Zijn eeuwige macht en goddelijkheid zijn weliswaar onzichtbare eigenschappen, maar ze zijn sinds de schepping van de wereld duidelijk te zien in hetgeen Hij gemaakt heeft. De mensen hebben dus geen excuus. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hoewel ze weten dat er een God is, geven ze Hem niet de eer en dank die Hem toekomt. Integendeel, hun redeneringen zijn onzinnig geworden en hun onverstandige hart is verduisterd. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ze beweren dat ze verstandig zijn, maar ze zijn dwaas geworden. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","In plaats van de grootheid van de onvergankelijke God te erkennen, zijn ze beelden van vergankelijke mensen en van vliegende, lopende en kruipende dieren gaan vereren. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Daarom heeft God hen met hun begerige verlangens prijsgegeven aan immoraliteit, zodat ze met elkaar hun lichaam onteren. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ze hebben Gods waarheid verruild voor de leugen: ze vereren en dienen het geschapene in plaats van de Schepper, aan Wie voor eeuwig alle eer toekomt. Amen. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Daarom heeft God hen prijsgegeven aan schandelijke hartstochten. Zelfs hun vrouwen hebben natuurlijke seks verruild voor hetgeen tegen de natuur ingaat. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","En wat de mannen betreft: in plaats van natuurlijke seks met vrouwen zijn ze ontbrand in lust naar elkaar. Mannen hebben seks met andere mannen en ontvangen zo in hun eigen lichaam het verdiende loon voor hun dwaling. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","En omdat ze het niet de moeite waard vinden om God te erkennen, heeft Hij hen prijsgegeven aan verwerpelijk denken en onwaardig gedrag. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Hun leven is gevuld met allerlei onrecht, slechtheid, hebzucht en verdorvenheid. Ze zitten vol afgunst, moordzucht, rivaliteit, bedrog en kwaadaardigheid. Het zijn roddelaars ");
INSERT INTO nldgbv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","en kwaadsprekers. Ze haten God en zijn hoogmoedig, arrogant en zelfingenomen. Ze bedenken kwaadaardige plannen en zijn hun ouders ongehoorzaam. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ze zijn onverstandig, onbetrouwbaar, hardvochtig en meedogenloos. ");
INSERT INTO nldgbv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ze weten dat wie zich met dergelijke dingen bezighoudt, volgens Gods voorschriften de dood verdient en toch doen ze die niet alleen zelf, maar juichen ze het ook toe dat anderen ze doen. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Als jij over anderen oordeelt, heb je dus geen excuus. Want op ieder punt waarop je een oordeel over een ander velt, veroordeel je jezelf doordat je die dingen ook doet. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","We weten immers dat wie dergelijke dingen doet, terecht door God veroordeeld wordt. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Dus als jij een oordeel velt over wie dergelijke dingen doet maar ze zelf ook doet, denk je dan dat jij Gods oordeel zal ontlopen? ");
INSERT INTO nldgbv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Of heb je geen respect voor zijn grote mildheid, verdraagzaamheid en geduld? Besef je dan niet dat Gods mildheid jou tot inkeer zou moeten brengen? ");
INSERT INTO nldgbv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Door halsstarrig te weigeren tot inkeer te komen, spaar je voor jezelf straf op – en die zal je krijgen op de dag dat God zijn toorn en gerechtigheid openbaart. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Hij zal iedereen loon naar werken geven. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Zij die glorie, eer en onvergankelijkheid nastreven door voortdurend goed te doen, ontvangen dan het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Maar zij die uit geldingsdrang de waarheid van de hand wijzen en zich door het kwaad laten leiden, ontvangen dan Gods zware straf. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Alle mensen die het slechte doen – in de eerste plaats Joden, maar ook niet-Joden – wacht leed en ellende. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Maar allen die het goede doen – in de eerste plaats Joden, maar ook niet-Joden – wacht glorie, eer en vrede. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Er is bij God namelijk geen favoritisme, ");
INSERT INTO nldgbv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","want allen die hebben gezondigd zonder de Wet te kennen, zullen zonder de Wet verloren gaan, en allen die hebben gezondigd terwijl ze de Wet wel kenden, zullen op grond van de Wet worden veroordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Het zijn niet de mensen die de Wet horen die vrij van schuld zijn tegenover God; integendeel, het zijn zij die de Wet naleven, die zullen worden vrijgesproken van schuld. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","En wanneer niet-Joden – zij die de Wet niet hebben ontvangen – spontaan doen wat de Wet vereist, dan blijkt dat zij de Wet in zich hebben, ook al hebben zij haar niet ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ze tonen dat de voorschriften van de Wet in hun hart zijn gegrift, terwijl hun geweten hen erover aanspreekt en hun gedachten hen soms beschuldigen en soms vrijpleiten. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Dit alles zal blijken op de dag dat God, door Christus Jezus, over de verborgen daden van de mensen zal oordelen. Dit is het evangelie dat ik verkondig. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Als je jezelf als een Jood beschouwt, op de Wet vertrouwt en fier op God bent, ");
INSERT INTO nldgbv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","en als je weet wat God van je verlangt en als je kan onderscheiden waarop het aankomt omdat de Wet jou dat heeft geleerd, ");
INSERT INTO nldgbv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","als je ervan overtuigd bent dat je een gids bent voor de blinden en een licht voor de mensen die in het duister leven, ");
INSERT INTO nldgbv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","als je dwazen corrigeert en onverstandigen onderwijst omdat je in de Wet kennis en de waarheid weet te vinden, ");
INSERT INTO nldgbv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","kortom, als jij anderen onderwijst, onderwijs je dan ook jezelf? Of verkondig je dat stelen niet mag, maar steel je zelf? ");
INSERT INTO nldgbv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Zeg je dat echtbreuk verkeerd is, maar pleeg je zelf echtbreuk? Walg je van afgodsbeelden, maar roof je uit tempels? ");
INSERT INTO nldgbv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Dan doe jij, die er fier op bent dat je de Wet bezit hoewel je haar ook overtreedt, God schande aan. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Dan is het zoals in de Schriften staat: “Door jouw toedoen wordt God gelasterd onder de volken.” ");
INSERT INTO nldgbv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Als je de Wet naleeft, is het waardevol om besneden te zijn, maar als je de Wet overtreedt, ben je als een onbesnedene. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","En als een onbesnedene zich aan de voorschriften van de Wet houdt, wordt hij dan niet als een besnedene beschouwd? ");
INSERT INTO nldgbv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Dan zullen zij die onbesneden gebleven zijn maar zich aan de Wet houden, oordelen over jou die de Wet overtreedt hoewel je haar op schrift hebt en besneden bent. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Want niet wie aan de buitenkant Joods is, noch wie lichamelijk besneden is, is werkelijk Joods. ");
INSERT INTO nldgbv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Integendeel, wie vanbinnen Joods is en een besneden hart heeft – door de Geest, niet door de schriftelijke Wet – is werkelijk Joods. En de lof die zo iemand ontvangt, komt niet van mensen maar van God. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Wat is dan het voordeel van het Joods-zijn en wat de waarde van de besnijdenis? ");
INSERT INTO nldgbv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Er zijn veel voordelen en de waarde is groot. In de eerste plaats zijn Gods openbaringen aan de Joden toevertrouwd. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Maar wat als sommigen Hem ontrouw zijn? Maakt hun ontrouw Gods trouw ongedaan? ");
INSERT INTO nldgbv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Absoluut niet! Al zijn alle mensen leugenaars, God houdt zich aan zijn woord. In de Schriften staat immers: “Wanneer U spreekt, blijkt uw rechtvaardigheid, en wanneer U vonnist, blijkt uw gelijk.” ");
INSERT INTO nldgbv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Als het kwaad dat wij doen aantoont dat God rechtvaardig is, kunnen we dan zeggen dat het onrechtvaardig is dat God ons straft? (Ik redeneer nu op menselijke wijze.) ");
INSERT INTO nldgbv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Absoluut niet! Hoe anders zou God over de wereld oordelen? ");
INSERT INTO nldgbv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Maar als God wordt geëerd doordat mijn onbetrouwbaarheid zijn betrouwbaarheid beter in de verf zet, waarom word ik dan nog als een zondaar veroordeeld? ");
INSERT INTO nldgbv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","En kunnen we dan zeggen: ‘Laten we het verkeerde doen opdat het goede eruit voortkomt?’ Sommigen beweren lasterlijk dat wij dat zeggen en het is terecht dat zij veroordeeld zullen worden. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Wat moeten we dan concluderen? Staan wij Joden er beter voor? Absoluut niet! Zoals we eerder zagen zijn we allemaal – zowel Joden als niet-Joden – in de macht van de zonde. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Het is zoals in de Schriften staat: “Er is niemand die rechtvaardig is, zelfs niet één. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Er is niemand die verstandig is, niemand die God zoekt. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Allemaal zijn ze afgedwaald, tezamen zijn ze nietswaardig geworden. Er is niemand die goed doet, zelfs niet één. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Hun keel is een open graf, hun tong verraderlijk, achter hun lippen zit addergif. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Hun mond is vol bittere vervloekingen. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Hun voeten staan klaar om bloed te vergieten. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Vernietiging en ellende liggen op hun pad. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Het vredespad kennen ze niet, ");
INSERT INTO nldgbv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","en ontzag voor God is niet wat zij voor ogen hebben.” ");
INSERT INTO nldgbv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Zoals we weten is hetgeen de Wet zegt, gericht tot die mensen op wie de Wet van toepassing is. Daarom heeft niemand recht van spreken en is de hele wereld verantwoording aan God verschuldigd. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Geen mens kan dus met Hem in het reine komen door de Wet na te leven, want door wetten ontdekt men wat zonde is. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nu is echter onthuld hoe men buiten de Wet om met God in het reine kan komen, en de Wet en de Profeten getuigen daarvan. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","We kunnen met God in het reine komen door in Jezus Christus te geloven. Dat geldt voor iedereen die gelooft, zonder onderscheid. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Want iedereen heeft gezondigd en leeft daardoor zonder Gods glorie, ");
INSERT INTO nldgbv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","maar wordt zonder er iets voor te moeten doen – uit genade – met God in het reine gebracht door de verlossing die Christus Jezus heeft bewerkstelligd. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Hij is door God aangeduid als het middel tot verzoening – doordat zijn bloed werd vergoten – en die verzoening ontvangen we door in Hem te geloven. Zo wordt Gods gerechtigheid aangetoond, want de zonden die voorheen zijn gepleegd waren onbestraft gebleven. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","God heeft ze getolereerd, maar nu toont Hij zijn gerechtigheid. Hij is dus rechtvaardig, ook wanneer Hij vrijspreekt wie in Jezus gelooft. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Waarop kan ik dan fier zijn? Nergens op! Op mijn naleving van de Wet? Nee, maar wel op mijn geloof. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","We concluderen dus dat de mens met God in het reine komt door te geloven, niet door de Wet na te leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Of is God enkel God van de Joden en niet van de niet-Joden? Nee, Hij is ook God van de niet-Joden. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Er is immers maar één God en Hij is het die zowel besneden als onbesneden mensen van schuld zal vrijspreken op grond van hun geloof. ");
INSERT INTO nldgbv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Maken we de Wet dan ongedaan door te geloven? Absoluut niet. Het is andersom: we bevestigen de Wet. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Wat kunnen we dan zeggen over de ervaring van onze voorvader Abraham? ");
INSERT INTO nldgbv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Als Abraham wegens zijn daden zou zijn vrijgesproken van schuld, dan zou hij iets hebben gehad waarop hij fier kon zijn. Maar zo werkt het niet bij God. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Want wat staat er in de Schriften? “Abraham geloofde God en op grond daarvan werd hij vrijgesproken van schuld”. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Wanneer iemand arbeid verricht, wordt zijn loon niet beschouwd als een blijk van genade, maar als iets dat hem verschuldigd is. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Wie echter niet zelf het werk probeert te doen, maar vertrouwt op Degene die zondaars vrijspreekt, wordt vrijgesproken op grond van dat vertrouwen. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ook David spreekt over de zegen voor de persoon die door God vrijgesproken wordt, ook al heeft die er niet voor gewerkt: ");
INSERT INTO nldgbv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Gezegend zijn zij wiens overtredingen zijn vergeven en wiens zonden zijn uitgewist. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Gezegend is de persoon aan wie de Heer zijn zonde niet toerekent.” ");
INSERT INTO nldgbv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Geldt deze zegen enkel voor besneden mensen of ook voor wie onbesneden is? We zeggen toch dat het op grond van zijn geloof is dat Abraham werd vrijgesproken? ");
INSERT INTO nldgbv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Maar onder welke omstandigheden gebeurde dat? Was hij toen al besneden of nog niet? Hij was nog onbesneden. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Hij ontving de besnijdenis als een teken, een bezegeling van de vrijspraak van schuld die hij op grond van zijn geloof had ontvangen terwijl hij nog onbesneden was. Zo kon hij de vader van alle gelovigen worden, ook als ze niet besneden zijn. Daarom worden ook zij vrijgesproken op grond van hun geloof. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraham is ook de vader van de besnedenen. Dat zijn zij die niet enkel de besnijdenis hebben maar ook, door te geloven, treden in de voetstappen van onze vader Abraham toen hij nog onbesneden was. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abraham en zijn afstammelingen ontvingen de belofte dat de wereld van hen zou zijn niet omdat hij de Wet naleefde, maar omdat hij, dankzij zijn geloof, met God in het reine was. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Immers, als het beloofde zou worden geschonken aan diegenen die de Wet naleven, dan zou het geloof geen waarde meer hebben en zou de belofte vervallen. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Want de Wet levert straf op, maar als er geen wetten zijn, dan kunnen ze niet worden overtreden. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","De belofte berust dus op geloof, op genade. Om die reden geldt de belofte voor al Abrahams afstammelingen – niet enkel zij die de Wet hebben maar ook zij die zijn geloof hebben. Hij is de vader van ons allen, ");
INSERT INTO nldgbv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","want in de Schriften staat: “Ik heb van jou een vader van vele volken gemaakt.” En dat is hij ook geworden voor de God in Wie hij geloofde, de God die de doden het leven geeft en die aan het onbestaande het bestaan schenkt. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Toen er geen hoop meer voor hem was, bleef hij geloven dat hij vader van vele volken zou worden, omdat hem was beloofd: “Zoveel afstammelingen zal je krijgen.” ");
INSERT INTO nldgbv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Zijn geloof verzwakte niet toen hij bedacht dat zijn eigen lichaam zo goed als dood was omdat hij bijna honderd jaar oud was, en dat Sara onvruchtbaar was. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Hij gaf het geloof niet op en twijfelde niet aan Gods belofte. Integendeel, zijn geloof werd sterker en hij gaf God de eer. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Hij was er volledig van overtuigd dat God in staat was om te doen wat Hij beloofd had. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Daarom werd Abraham vrijgesproken van schuld op grond van zijn geloof. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","En dat er staat dat hij werd vrijgesproken, geldt niet alleen voor Abraham. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Het geldt ook voor ons: ook wij worden vrijgesproken op grond van ons geloof in Degene die Jezus, onze Heer, uit de dood heeft opgewekt. ");
INSERT INTO nldgbv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jezus werd overgeleverd voor onze overtredingen en weer tot leven gewekt voor onze vrijspraak. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","We zijn dus vrijgesproken op grond van ons geloof, en we hebben vrede met God dankzij onze Heer Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ook hebben wij, dankzij Hem en door het geloof, toegang verkregen tot de genade. Wij ervaren die genade nu al, en we zijn fier op onze verwachting dat we straks Gods glorie zullen ervaren. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Dat niet alleen, wij zijn zelfs fier op onze moeilijkheden, want we weten dat moeilijkheden volharding opleveren. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Die volharding levert betrouwbaarheid op, en die betrouwbaarheid levert hoop op. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Die hoop zal ons niet beschamen, want Gods liefde is in ons hart uitgestort door de Heilige Geest, die Hij ons geschonken heeft. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Want op het door God gekozen tijdstip, toen wij nog hulpeloos waren, is Christus voor de goddelozen gestorven. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Het gebeurt zelden dat iemand voor een rechtvaardig mens sterft, maar wie weet is er iemand die het zou aandurven om voor een goed mens te sterven. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","God daarentegen bewijst zijn liefde voor ons doordat Christus voor ons stierf toen wij nog zondaars waren. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","En omdat wij met God in het reine zijn gekomen doordat Christus' bloed voor ons is vergoten, mogen we erop rekenen dat we dankzij Christus van Gods straf bewaard zullen blijven. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Toen we nog vijanden van Hem waren, zijn we met God verzoend door de dood van zijn Zoon. En nu we met Hem verzoend zijn, mogen we er zeker van zijn dat we, doordat Hij leeft, gered zullen worden. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Dat niet alleen, wij prijzen onszelf gelukkig dat we bij God horen, dankzij onze Heer Jezus Christus, door Wie wij de verzoening hebben ontvangen. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Het is door één mens dat de zonde de wereld is binnengekomen, en door de zonde de dood. Zo is de dood bij alle mensen gekomen, omdat allen hebben gezondigd. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Voordat de Wet kwam, was er al zonde in de wereld, maar zonde wordt niet toegerekend als er geen wetten zijn. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Toch regeerde de dood in de tijd van Adam tot Mozes, zelfs over de mensen die niet hadden gezondigd door een specifiek gebod te overtreden, zoals Adam. Adam kan worden vergeleken met Degene die zou komen. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Het genadige geschenk is echter niet vergelijkbaar met de overtreding. Want de overtreding van één mens heeft weliswaar tot de dood van velen geleid, maar dat weegt niet op tegen Gods genade en tegen het geschenk dat velen hebben ontvangen door de genade van die andere Mens, Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Het genadige geschenk is evenmin vergelijkbaar met de zonde van die eerste mens. Het vonnis over die overtreding verklaart die eerste mens weliswaar schuldig, maar het genadige geschenk dat na vele overtredingen werd geschonken, resulteert in vrijspraak van schuld. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","En de dood regeerde weliswaar als gevolg van de overtreding van één mens, maar het is nog zekerder dat zij die de vrijspraak van schuld ontvangen als een geschenk dat uit overvloedige genade is gegeven, in het nieuwe leven mogen regeren dankzij die andere Mens, Jezus Christus. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Wij concluderen dat zoals de overtreding van één mens de veroordeling van alle mensen teweegbracht, de rechtvaardigheid van die andere Mens vrijspraak en leven voor alle mensen heeft bewerkstelligd. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","En zoals velen zondaars zijn geworden door de ongehoorzaamheid van één mens, zo worden velen vrijgesproken van schuld door de gehoorzaamheid van die andere Mens. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Doordat de Wet erbij is gekomen, zijn de overtredingen toegenomen, maar waar de zonde toenam, werd de genade nog overvloediger. ");
INSERT INTO nldgbv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Wij concluderen dat zoals de zonde regeerde en tot de dood leidde, de vrijspraak van schuld ervoor heeft gezorgd dat de genade regeert en tot het eeuwig leven leidt dankzij Jezus Christus, onze Heer. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Kunnen we dan zeggen dat we moeten doorgaan met zondigen opdat de genade dan toeneemt? ");
INSERT INTO nldgbv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Absoluut niet! We zijn immers dood voor de zonde; dan kunnen we toch geen zondig leven blijven leiden? ");
INSERT INTO nldgbv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Weten jullie niet dat wij die ons hebben laten dopen om voortaan bij Christus te horen, door die doop delen in zijn dood? ");
INSERT INTO nldgbv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","En omdat we door onze doop delen in zijn dood, delen we ook in zijn begrafenis. En omdat Christus uit de dood is opgewekt door de grote macht van de Vader, behoren ook wij een nieuw leven te leiden. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Als wij delen in zijn dood, zullen we ook delen in zijn verrijzenis. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","We weten immers dat onze oude ‘ik’ is meegekruisigd, opdat met onze neiging tot zonde zou worden afgerekend en we niet langer slaaf van de zonde zouden zijn. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Immers, wie gestorven is, is vrij van de macht van de zonde. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Als wij samen met Christus zijn gestorven, geloven we dat we ook samen met Hem zullen leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","We weten immers dat nu Christus uit de dood is opgewekt, Hij nooit meer zal sterven. De dood heeft geen macht meer over Hem. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Door te sterven heeft Hij eens en voor altijd met de zonde afgerekend en nu Hij leeft, leeft Hij voor God. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Daarom moeten jullie jezelf beschouwen als eveneens dood voor de zonde, maar levend voor God doordat jullie bij Christus Jezus horen. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Laat daarom niet toe dat de zonde over je sterfelijk lichaam regeert: geef niet toe aan de zondige verlangens ervan. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Stel geen enkel deel van je lichaam meer ter beschikking van de zonde, om er slechte dingen mee te doen. Stel jezelf daarentegen ter beschikking van God, als iemand die dood geweest is maar nu leeft; laat alle delen van je leven door God gebruiken, om er goede dingen mee te doen. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Laat je niet beheersen door de zonde, want jullie leven wordt niet meer bepaald door de Wet, maar door Gods genade. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Hoe zit het dan? Als ons leven niet door de Wet, maar door Gods genade wordt bepaald, zullen we dan maar zondigen? Absoluut niet! ");
INSERT INTO nldgbv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Weten jullie niet dat als je jezelf als slaaf ten dienste van iemand stelt, hij je meester wordt en je hem moet gehoorzamen? Ofwel ben je slaaf van de zonde – wat tot de dood leidt – ofwel ben je slaaf van de gehoorzaamheid – wat tot vrijspraak van schuld leidt. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","God zij dank zijn jullie, die slaaf van de zonde waren, van harte gehoorzaam geworden aan de leer die jullie hebben omarmd. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Jullie zijn bevrijd van de zonde en ten dienste gesteld van de gerechtigheid. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ik redeneer op menselijke wijze, wegens jullie zwakke, zondige natuur. Zoals jullie jezelf vroeger als slaaf ten dienste stelden van immoraliteit en onrecht – wat leidde tot nog meer onrecht – zo moeten jullie nu jezelf als slaaf ten dienste stellen van de rechtvaardigheid. En dat zal leiden tot een zuiver leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Toen jullie nog slaaf van de zonde waren, hadden jullie je nog niet aan de rechtvaardigheid toegewijd. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Maar wat hebben de zaken waarvoor jullie je nu schamen voor jullie opgeleverd? Het resultaat daarvan is de dood! ");
INSERT INTO nldgbv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Maar nu zijn jullie van de zonde bevrijd en hebben jullie jezelf ten dienste van God gesteld. En wat heeft dat voor jullie opgeleverd? Jullie zijn gezuiverd, en het resultaat daarvan is het eeuwig leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Want wat we verdienen met onze zonde, is de dood, maar het geschenk dat God in zijn genade geeft, is het eeuwig leven met Christus Jezus, onze Heer. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Weten jullie niet, broeders en zusters – ik spreek tot mensen die de Wet kennen – dat wetten op mensen van toepassing zijn zolang ze leven? ");
INSERT INTO nldgbv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Een gehuwde vrouw is bij wet aan haar man gebonden zolang hij leeft, maar als de man sterft, is ze ontslagen van haar wettelijke verplichtingen tegenover haar man. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Als ze tijdens het leven van haar echtgenoot de vrouw van een ander zou worden, zou ze overspelig worden genoemd. Maar als haar echtgenoot sterft, is ze ontslagen van haar wettelijke verplichtingen tegenover hem. En als ze dan de vrouw van een andere man wordt, is ze niet overspelig. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Broeders en zusters, zo is het ook met jullie. Dankzij de dood van Christus zijn ook jullie gestorven ten opzichte van de Wet en mogen jullie je met iemand anders verbinden – namelijk Hij die uit de dood is opgewekt – en je voor God inzetten. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Want toen we onze zondige natuur nog hadden, riep de Wet zondige verlangens bij ons op, zodat we ons inzetten voor de dood. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Maar omdat we gestorven zijn ten opzichte van de Wet, die ons gevangen hield, zijn we ontslagen van onze verplichtingen tegenover de Wet en kunnen we dienen op de nieuwe manier, die van de Geest, in plaats van de oude manier, die van de geschreven wetten. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Mogen we dan zeggen dat de Wet slecht is? Absoluut niet! Integendeel, als de Wet er niet zou zijn, zou ik niet weten wat zonde is. Ik zou niet hebben geweten wat begerigheid is als de Wet niet zou zeggen: “Wees niet begerig naar wat van een ander is”. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","De zonde maakte van het gebod gebruik om allerlei slechte verlangens bij mij op te roepen, maar zonder de Wet is de zonde machteloos. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ik leefde vroeger zonder de Wet, maar toen het gebod kwam, kwam de zonde tot leven, ");
INSERT INTO nldgbv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","en stierf ik. Het gebod dat tot het leven had moeten leiden, bleek voor mij te leiden tot de dood. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","De zonde maakte dus van het gebod gebruik om mij te misleiden en mij te doden. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","De Wet is dus heilig en het gebod is heilig, rechtvaardig en goed. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Heeft het goede dan mijn dood veroorzaakt? Absoluut niet! Maar doordat de zonde het goede gebruikte om mijn dood te veroorzaken, is duidelijk geworden wat zonde is. En zo is door middel van het gebod aangetoond hoe verschrikkelijk zonde is. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","We weten dat de Wet geestelijke zaken betreft, maar ik ben stoffelijk en verslaafd aan de zonde. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ik begrijp mijn gedrag niet, want hetgeen ik wil doen, doe ik niet; ik doe wat ik verafschuw. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","En door te doen wat ik niet wil, bevestig ik dat de Wet goed is. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Het is dus niet langer mijn gedrag, maar dat van de zonde die in mij leeft. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Want zoals ik weet leeft er in mij – dat wil zeggen: in mijn zondige natuur – niets goeds. Ik wil dus wel graag het goede doen, maar ik gedraag me niet goed. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ik doe namelijk niet het goede dat ik wil doen, ik doe het slechte dat ik niet wil doen. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Maar als ik doe wat ik niet wil, dan ben ik niet meer degene die me zo gedraagt, maar de zonde die in mij leeft. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ik bemerk dus deze wetmatigheid: wanneer ik het goede wil doen, dringt het slechte zich aan mij op. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Diep vanbinnen verheug ik me in Gods Wet, ");
INSERT INTO nldgbv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","maar ik zie in mijn leven ook de werking van een andere wet, die in strijd is met de wet in mijn denken en ik zie dat die andere wet mij in de macht brengt van de wet van de zonde die in mijn leven actief is. ");
INSERT INTO nldgbv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","O, wat ziet het er slecht voor mij uit! Wie zal mij bevrijden uit dit bestaan in de greep van de dood? ");
INSERT INTO nldgbv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","God, door Jezus Christus, onze Heer! En ik dank Hem daarvoor. Enerzijds onderwerp ik me dus met mijn verstand aan Gods Wet, maar anderzijds ben ik met mijn zondige natuur onderworpen aan de wet van de zonde. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Wie bij Christus Jezus hoort, is dus niet langer veroordeeld. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Dankzij Christus Jezus heeft de wet van de Geest, die tot het leven leidt, je namelijk bevrijd van de wet van zonde en de dood. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Door zijn eigen Zoon te sturen in een lichaam zoals dat van zondige mensen, heeft God komaf gemaakt met de zonde in de menselijke natuur. De Wet was daartoe niet in staat, want zij wordt tegengewerkt door onze zondige natuur. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Wij die ons niet laten leiden door onze zondige natuur maar door de Geest, voldoen daarom aan de vereisten van de Wet. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Want wie zich door de zondige natuur laat leiden, volgt de denkwijze van de zondige natuur, maar wie zich door de Geest laat leiden, volgt de denkwijze van de Geest. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Het volgen van de denkwijze van de zondige natuur leidt tot de dood, maar het volgen van de denkwijze van de Geest leidt tot leven en vrede. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","De denkwijze van de zondige natuur staat vijandig tegenover God, want zij weigert het gezag van Gods wet te aanvaarden. Zij kan dat zelfs niet. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","En wie zich laat leiden door de zondige natuur, kan niet doen wat God goedkeurt. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Jullie daarentegen laten je niet leiden door je zondige natuur, maar door de Geest, althans wanneer Gods Geest in jullie woont. Wie de Geest van Christus echter niet heeft, behoort Hem niet toe. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Maar als Christus in je is, gaat je lichaam wel dood wegens de zonde, maar schenkt de Geest jou leven omdat je bent vrijgesproken van schuld. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Als de Geest van Degene die Jezus uit de dood heeft opgewekt in je woont, dan zal Hij die Christus uit de dood heeft opgewekt, ook jouw sterfelijk lichaam levend maken, door zijn Geest die in je woont. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Broeders en zusters, we staan dus in het krijt, maar niet bij de zondige natuur. We hoeven ons dus niet door de zondige natuur te laten leiden. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Want als je je door de zondige natuur laat leiden, is het zeker dat je zal sterven. Maar als je met de hulp van de Geest afrekent met de praktijken van de zondige natuur, dan zal je leven. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Want iedereen die zich door Gods Geest laat leiden, is een kind van God. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","De Geest die jullie hebben ontvangen, maakt jullie niet tot slaven; in dat geval zouden jullie opnieuw in angst moeten leven. Integendeel, de Geest die jullie hebben ontvangen, maakt jullie tot zonen, zodat we Hem “Abba, Vader” mogen noemen. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","En het is die Geest die, samen met onze geest, ons ervan overtuigt dat wij kinderen van God zijn. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","En omdat we zijn kinderen zijn, zullen we, samen met Christus, ontvangen wat God aan zijn kinderen heeft beloofd. Nu delen we in zijn lijden, maar straks mogen we ook delen in zijn glorie. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ik ben ervan overtuigd dat het tegenwoordige lijden niet opweegt tegen de glorie die wij zullen ervaren. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","De schepping kijkt namelijk reikhalzend uit naar het moment waarop die glorie van Gods kinderen zichtbaar zal worden. ");
INSERT INTO nldgbv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Immers, de schepping werd aan een zinloos bestaan onderworpen; niet vrijwillig, maar doordat God daartoe besloot. Toch is er hoop: ");
INSERT INTO nldgbv_vpl VALUES ("RM8