﻿USE sofia;
DROP TABLE IF EXISTS sofia.nld_vpl;
CREATE TABLE nld_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nld_vpl WRITE;
INSERT INTO nld_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In den beginne schiep God den hemel en de aarde. ");
INSERT INTO nld_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","De aarde nu was woest en ledig, en duisternis was op den afgrond; en de Geest Gods zweefde op de wateren. ");
INSERT INTO nld_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","En God zeide: Daar zij licht! en daar werd licht. ");
INSERT INTO nld_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","En God zag het licht, dat het goed was; en God maakte scheiding tussen het licht en tussen de duisternis. ");
INSERT INTO nld_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","En God noemde het licht dag, en de duisternis noemde Hij nacht. Toen was het avond geweest, en het was morgen geweest, de eerste dag. ");
INSERT INTO nld_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","En God zeide: Daar zij een uitspansel in het midden der wateren; en dat make scheiding tussen wateren en wateren! ");
INSERT INTO nld_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","En God maakte dat uitspansel, en maakte scheiding tussen de wateren, die onder het uitspansel zijn, en tussen de wateren, die boven het uitspansel zijn. En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","En God noemde het uitspansel hemel. Toen was het avond geweest, en het was morgen geweest, de tweede dag. ");
INSERT INTO nld_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","En God zeide: Dat de wateren van onder den hemel in een plaats vergaderd worden, en dat het droge gezien worde! En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","En God noemde het droge aarde, en de vergadering der wateren noemde Hij zeeen; en God zag, dat het goed was. ");
INSERT INTO nld_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","En God zeide: Dat de aarde uitschiete grasscheutjes, kruid zaadzaaiende, vruchtbaar geboomte, dragende vrucht naar zijn aard, welks zaad daarin zij op de aarde! En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","En de aarde bracht voort grasscheutjes, kruid zaadzaaiende naar zijn aard, en vruchtdragend geboomte, welks zaad daarin was, naar zijn aard. En God zag, dat het goed was. ");
INSERT INTO nld_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Toen was het avond geweest, en het was morgen geweest, de derde dag. ");
INSERT INTO nld_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","En God zeide: Dat er lichten zijn in het uitspansel des hemels, om scheiding te maken tussen den dag en tussen den nacht; en dat zij zijn tot tekenen en tot gezette tijden, en tot dagen en jaren! ");
INSERT INTO nld_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","En dat zij zijn tot lichten in het uitspansel des hemels, om licht te geven op de aarde! En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God dan maakte die twee grote lichten; dat grote licht tot heerschappij des daags, en dat kleine licht tot heerschappij des nachts; ook de sterren. ");
INSERT INTO nld_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","En God stelde ze in het uitspansel des hemels, om licht te geven op de aarde. ");
INSERT INTO nld_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","En om te heersen op den dag, en in den nacht, en om scheiding te maken tussen het licht en tussen de duisternis. En God zag, dat het goed was. ");
INSERT INTO nld_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Toen was het avond geweest, en het was morgen geweest, de vierde dag. ");
INSERT INTO nld_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","En God zeide: Dat de wateren overvloediglijk voortbrengen een gewemel van levende zielen; en het gevogelte vliege boven de aarde, in het uitspansel des hemels! ");
INSERT INTO nld_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","En God schiep de grote walvissen, en alle levende wremelende ziel, welke de wateren overvloediglijk voortbrachten, naar haar aard; en alle gevleugeld gevogelte naar zijn aard. En God zag, dat het goed was. ");
INSERT INTO nld_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","En God zegende ze, zeggende: Zijt vruchtbaar, en vermenigvuldigt, en vervult de wateren in de zeeen; en het gevogelte vermenigvuldige op de aarde! ");
INSERT INTO nld_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Toen was het avond geweest, en het was morgen geweest, de vijfde dag. ");
INSERT INTO nld_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","En God zeide: De aarde brenge levende zielen voort, naar haar aard, vee, en kruipend, en wild gedierte der aarde, naar zijn aard! En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","En God maakte het wild gedierte der aarde naar zijn aard, en het vee naar zijn aard, en al het kruipend gedierte des aardbodems naar zijn aard. En God zag, dat het goed was. ");
INSERT INTO nld_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","En God zeide: Laat Ons mensen maken, naar Ons beeld, naar Onze gelijkenis; en dat zij heerschappij hebben over de vissen der zee, en over het gevogelte des hemels, en over het vee, en over de gehele aarde, en over al het kruipend gedierte, dat op de aarde kruipt. ");
INSERT INTO nld_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","En God schiep den mens naar Zijn beeld; naar het beeld van God schiep Hij hem; man en vrouw schiep Hij ze. ");
INSERT INTO nld_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","En God zegende hen, en God zeide tot hen: Weest vruchtbaar, en vermenigvuldigt, en vervult de aarde, en onderwerpt haar, en hebt heerschappij over de vissen der zee, en over het gevogelte des hemels, en over al het gedierte, dat op de aarde kruipt! ");
INSERT INTO nld_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","En God zeide: Ziet, Ik heb ulieden al het zaadzaaiende kruid gegeven, dat op de ganse aarde is, en alle geboomte, in hetwelk zaadzaaiende boomvrucht is; het zij u tot spijze! ");
INSERT INTO nld_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Maar aan al het gedierte der aarde, en aan al het gevogelte des hemels, en aan al het kruipende gedierte op de aarde, waarin een levende ziel is, heb Ik al het groene kruid tot spijze gegeven. En het was alzo. ");
INSERT INTO nld_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","En God zag al wat Hij gemaakt had, en ziet, het was zeer goed. Toen was het avond geweest, en het was morgen geweest, de zesde dag. ");
INSERT INTO nld_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Alzo zijn volbracht de hemel en de aarde, en al hun heir. ");
INSERT INTO nld_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Als nu God op den zevenden dag volbracht had Zijn werk, dat Hij gemaakt had, heeft Hij gerust op den zevenden dag van al Zijn werk, dat Hij gemaakt had. ");
INSERT INTO nld_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","En God heeft den zevenden dag gezegend, en dien geheiligd; omdat Hij op denzelven gerust heeft van al Zijn werk, hetwelk God geschapen had, om te volmaken. ");
INSERT INTO nld_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dit zijn de geboorten des hemels en der aarde, als zij geschapen werden; ten dage als de HEERE God de aarde en den hemel maakte. ");
INSERT INTO nld_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","En allen struik des velds, eer hij in de aarde was, en al het kruid des velds, eer het uitsproot; want de HEERE God had niet doen regenen op de aarde, en er was geen mens geweest, om den aardbodem te bouwen. ");
INSERT INTO nld_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Maar een damp was opgegaan uit de aarde, en bevochtigde den gansen aardbodem. ");
INSERT INTO nld_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","En de HEERE God had den mens geformeerd uit het stof der aarde, en in zijn neusgaten geblazen den adem des levens; alzo werd de mens tot een levende ziel. ");
INSERT INTO nld_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ook had de HEERE God een hof geplant in Eden, tegen het oosten, en Hij stelde aldaar den mens, dien Hij geformeerd had. ");
INSERT INTO nld_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","En de HEERE God had alle geboomte uit het aardrijk doen spruiten, begeerlijk voor het gezicht, en goed tot spijze; en den boom des levens in het midden van den hof, en de boom der kennis des goeds en des kwaads. ");
INSERT INTO nld_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","En een rivier was voortgaande uit Eden, om dezen hof te bewateren; en werd van daar verdeeld, en werd tot vier hoofden. ");
INSERT INTO nld_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","De naam der eerste rivier is Pison; deze is het, die het ganse land van Havila omloopt, waar het goud is. ");
INSERT INTO nld_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","En het goud van dit land is goed; daar is ook bedolah, en de steen sardonix. ");
INSERT INTO nld_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","En de naam der tweede rivier is Gihon; deze is het, die het ganse land Cusch omloopt. ");
INSERT INTO nld_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","En de naam der derde rivier is Hiddekel; deze is gaande naar het oosten van Assur. En de vierde rivier is Frath. ");
INSERT INTO nld_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Zo nam de HEERE God den mens, en zette hem in den hof van Eden, om dien te bouwen, en dien te bewaren. ");
INSERT INTO nld_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","En de HEERE God gebood den mens, zeggende: Van allen boom dezes hofs zult gij vrijelijk eten; ");
INSERT INTO nld_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Maar van den boom der kennis des goeds en des kwaads, daarvan zult gij niet eten; want ten dage, als gij daarvan eet, zult gij den dood sterven. ");
INSERT INTO nld_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ook had de HEERE God gesproken: Het is niet goed, dat de mens alleen zij; Ik zal hem een hulpe maken, die als tegen hem over zij. ");
INSERT INTO nld_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Want als de HEERE God uit de aarde al het gedierte des velds, en al het gevogelte des hemels gemaakt had, zo bracht Hij die tot Adam, om te zien, hoe hij ze noemen zou; en zo als Adam alle levende ziel noemen zoude, dat zou haar naam zijn. ");
INSERT INTO nld_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Zo had Adam genoemd de namen van al het vee, en van het gevogelte des hemels, en van al het gedierte des velds; maar voor den mens vond hij geen hulpe, die als tegen hem over ware. ");
INSERT INTO nld_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Toen deed de HEERE God een diepen slaap op Adam vallen, en hij sliep; en Hij nam een van zijn ribben, en sloot derzelver plaats toe met vlees. ");
INSERT INTO nld_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","En de HEERE God bouwde de ribbe, die Hij van Adam genomen had, tot een vrouw, en Hij bracht haar tot Adam. ");
INSERT INTO nld_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Toen zeide Adam: Deze is ditmaal been van mijn benen, en vlees van mijn vlees! Men zal haar Manninne heten, omdat zij uit den man genomen is. ");
INSERT INTO nld_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Daarom zal de man zijn vader en zijn moeder verlaten, en zijn vrouw aankleven; en zij zullen tot een vlees zijn. ");
INSERT INTO nld_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","En zij waren beiden naakt, Adam en zijn vrouw; en zij schaamden zich niet. ");
INSERT INTO nld_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","De slang nu was listiger dan al het gedierte des velds, hetwelk de HEERE God gemaakt had; en zij zeide tot de vrouw: Is het ook, dat God gezegd heeft: Gijlieden zult niet eten van allen boom dezes hofs? ");
INSERT INTO nld_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","En de vrouw zeide tot de slang: Van de vrucht der bomen dezes hofs zullen wij eten; ");
INSERT INTO nld_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Maar van de vrucht des booms, die in het midden des hofs is, heeft God gezegd: Gij zult van die niet eten, noch die aanroeren, opdat gij niet sterft. ");
INSERT INTO nld_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Toen zeide de slang tot de vrouw: Gijlieden zult den dood niet sterven; ");
INSERT INTO nld_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Maar God weet, dat, ten dage als gij daarvan eet, zo zullen uw ogen geopend worden, en gij zult als God wezen, kennende het goed en het kwaad. ");
INSERT INTO nld_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","En de vrouw zag, dat die boom goed was tot spijze, en dat hij een lust was voor de ogen, ja, een boom, die begeerlijk was om verstandig te maken; en zij nam van zijn vrucht en at; en zij gaf ook haar man met haar, en hij at. ");
INSERT INTO nld_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Toen werden hun beider ogen geopend, en zij werden gewaar, dat zij naakt waren; en zij hechtten vijgeboombladeren samen, en maakten zich schorten. ");
INSERT INTO nld_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","En zij hoorden de stem van den HEERE God, wandelende in den hof, aan den wind des daags. Toen verborg zich Adam en zijn vrouw voor het aangezicht van den HEERE God, in het midden van het geboomte des hofs. ");
INSERT INTO nld_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","En de HEERE God riep Adam, en zeide tot hem: Waar zijt gij? ");
INSERT INTO nld_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","En hij zeide: Ik hoorde Uw stem in den hof, en ik vreesde; want ik ben naakt; daarom verborg ik mij. ");
INSERT INTO nld_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","En Hij zeide: Wie heeft u te kennen gegeven, dat gij naakt zijt? Hebt gij van dien boom gegeten, van welken Ik u gebood, dat gij daarvan niet eten zoudt? ");
INSERT INTO nld_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Toen zeide Adam: De vrouw, die Gij bij mij gegeven hebt, die heeft mij van dien boom gegeven, en ik heb gegeten. ");
INSERT INTO nld_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","En de HEERE God zeide tot de vrouw: Wat is dit, dat gij gedaan hebt? En de vrouw zeide: De slang heeft mij bedrogen, en ik heb gegeten. ");
INSERT INTO nld_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Toen zeide de HEERE God tot die slang: Dewijl gij dit gedaan hebt, zo zijt gij vervloekt boven al het vee, en boven al het gedierte des velds! Op uw buik zult gij gaan, en stof zult gij eten, al de dagen uws levens. ");
INSERT INTO nld_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","En Ik zal vijandschap zetten tussen u en tussen deze vrouw, en tussen uw zaad en tussen haar zaad; datzelve zal u den kop vermorzelen, en gij zult het de verzenen vermorzelen. ");
INSERT INTO nld_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tot de vrouw zeide Hij: Ik zal zeer vermenigvuldigen uw smart, namelijk uwer dracht; met smart zult gij kinderen baren; en tot uw man zal uw begeerte zijn, en hij zal over u heerschappij hebben. ");
INSERT INTO nld_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","En tot Adam zeide Hij: Dewijl gij geluisterd hebt naar de stem uwer vrouw, en van dien boom gegeten, waarvan Ik u gebood, zeggende: Gij zult daarvan niet eten; zo zij het aardrijk om uwentwil vervloekt; en met smart zult gij daarvan eten al de dagen uws levens. ");
INSERT INTO nld_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ook zal het u doornen en distelen voortbrengen, en gij zult het kruid des velds eten. ");
INSERT INTO nld_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In het zweet uws aanschijns zult gij brood eten, totdat gij tot de aarde wederkeert, dewijl gij daaruit genomen zijt; want gij zijt stof, en gij zult tot stof wederkeren. ");
INSERT INTO nld_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Voorts noemde Adam den naam zijner vrouw Heva, omdat zij een moeder aller levenden is. ");
INSERT INTO nld_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","En de HEERE God maakte voor Adam en zijn vrouw rokken van vellen, en toog ze hun aan. ");
INSERT INTO nld_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Toen zeide de HEERE God: Ziet, de mens is geworden als Onzer een, kennende het goed en het kwaad! Nu dan, dat hij zijn hand niet uitsteke, en neme ook van den boom des levens, en ete, en leve in eeuwigheid. ");
INSERT INTO nld_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Zo verzond hem de HEERE God uit den hof van Eden, om den aardbodem te bouwen, waaruit hij genomen was. ");
INSERT INTO nld_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","En Hij dreef den mens uit; en stelde cherubim tegen het oosten des hofs van Eden, en een vlammig lemmer eens zwaards, dat zich omkeerde, om te bewaren den weg van den boom des levens. ");
INSERT INTO nld_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","En Adam bekende Heva, zijn huisvrouw, en zij werd zwanger, en baarde Kain, en zeide: Ik heb een man van den HEERE verkregen! ");
INSERT INTO nld_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","En zij voer voort te baren zijn broeder Habel; en Habel werd een schaapherder, en Kain werd een landbouwer. ");
INSERT INTO nld_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","En het geschiedde ten einde van enige dagen, dat Kain van de vrucht des lands den HEERE offer bracht. ");
INSERT INTO nld_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","En Habel bracht ook van de eerstgeborenen zijner schapen, en van hun vet. En de HEERE zag Habel en zijn offer aan; ");
INSERT INTO nld_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Maar Kain en zijn offer zag Hij niet aan. Toen ontstak Kain zeer, en zijn aangezicht verviel. ");
INSERT INTO nld_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","En de HEERE zeide tot Kain: Waarom zijt gij ontstoken, en waarom is uw aangezicht vervallen? ");
INSERT INTO nld_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Is er niet, indien gij weldoet, verhoging? en zo gij niet weldoet, de zonde ligt aan de deur. Zijn begeerte is toch tot u, en gij zult over hem heersen. ");
INSERT INTO nld_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","En Kain sprak met zijn broeder Habel; en het geschiedde, als zij in het veld waren, dat Kain tegen zijn broeder Habel opstond, en sloeg hem dood. ");
INSERT INTO nld_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","En de HEERE zeide tot Kain: Waar is Habel, uw broeder? En hij zeide: Ik weet het niet; ben ik mijns broeders hoeder? ");
INSERT INTO nld_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","En Hij zeide: Wat hebt gij gedaan? daar is een stem des bloeds van uw broeder, dat tot Mij roept van den aardbodem. ");
INSERT INTO nld_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","En nu zijt gij vervloekt van den aardbodem, die zijn mond heeft opengedaan, om uws broeders bloed van uw hand te ontvangen. ");
INSERT INTO nld_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Als gij den aardbodem bouwen zult, hij zal u zijn vermogen niet meer geven; gij zult zwervende en dolende zijn op aarde. ");
INSERT INTO nld_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","En Kain zeide tot den HEERE: Mijn misdaad is groter, dan dat zij vergeven worde. ");
INSERT INTO nld_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Zie, Gij hebt mij heden verdreven van den aardbodem, en ik zal voor Uw aangezicht verborgen zijn; en ik zal zwervende en dolende zijn op de aarde, en het zal geschieden, dat al wie mij vindt, mij zal doodslaan. ");
INSERT INTO nld_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Doch de HEERE zeide tot hem: Daarom, al wie Kain doodslaat, zal zevenvoudig gewroken worden! En de HEERE stelde een teken aan Kain; opdat hem niet versloeg al wie hem vond. ");
INSERT INTO nld_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","En Kain ging uit van het aangezicht des HEEREN; en hij woonde in het land Nod, ten oosten van Eden. ");
INSERT INTO nld_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","En Kain bekende zijn huisvrouw, en zij werd bevrucht en baarde Henoch; en hij bouwde een stad, en noemde den naam dier stad naar den naam zijns zoons, Henoch. ");
INSERT INTO nld_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","En aan Henoch werd Hirad geboren; en Hirad gewon Mechujael; en Mechujael gewon Methusael; en Methusael gewon Lamech. ");
INSERT INTO nld_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","En Lamech nam zich twee vrouwen; de naam van de eerste was Ada, en de naam van de andere Zilla. ");
INSERT INTO nld_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","En Ada baarde Jabal; deze is geweest een vader dergenen, die tenten bewoonden, en vee hadden. ");
INSERT INTO nld_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","En de naam zijns broeders was Jubal; deze was de vader van allen, die harpen en orgelen handelen. ");
INSERT INTO nld_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","En Zilla baarde ook Tubal-Kain, een leermeester van allen werker in koper en ijzer; en de zuster van Tubal-Kain was Naema. ");
INSERT INTO nld_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","En Lamech zeide tot zijn vrouwen Ada en Zilla: Hoort mijn stem, gij vrouwen van Lamech! neemt ter ore mijn rede! Voorwaar, ik sloeg wel een man dood, om mijn wonde, en een jongeling, om mijn buile! ");
INSERT INTO nld_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Want Kain zal zevenvoudig gewroken worden, maar Lamech zeventigmaal zevenmaal. ");
INSERT INTO nld_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","En Adam bekende wederom zijn huisvrouw, en zij baarde een zoon, en zij noemde zijn naam Seth; want God heeft mij, sprak zij, een ander zaad gezet voor Habel; want Kain heeft hem doodgeslagen. ");
INSERT INTO nld_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","En denzelven Seth werd ook een zoon geboren, en hij noemde zijn naam Enos. Toen begon men den Naam des HEEREN aan te roepen. ");
INSERT INTO nld_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dit is het boek van Adams geslacht. Ten dage als God den mens schiep, maakte Hij hem naar de gelijkenis Gods. ");
INSERT INTO nld_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Man en vrouw schiep Hij hen, en zegende ze, en noemde hun naam Mens, ten dage als zij geschapen werden. ");
INSERT INTO nld_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","En Adam leefde honderd en dertig jaren, en gewon een zoon naar zijn gelijkenis, naar zijn evenbeeld, en noemde zijn naam Seth. ");
INSERT INTO nld_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","En Adams dagen, nadat hij Seth gewonnen had, zijn geweest achthonderd jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Zo waren al de dagen van Adam, die hij leefde, negenhonderd jaren, en dertig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","En Seth leefde honderd en vijf jaren, en hij gewon Enos. ");
INSERT INTO nld_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","En Seth leefde, nadat hij Enos gewonnen had, achthonderd en zeven jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Zo waren al de dagen van Seth negenhonderd en twaalf jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","En Enos leefde negentig jaren, en hij gewon Kenan. ");
INSERT INTO nld_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","En Enos leefde, nadat hij Kenan gewonnen had, achthonderd en vijftien jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Zo waren al de dagen van Enos negenhonderd en vijf jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","En Kenan leefde zeventig jaren, en hij gewon Mahalal-el. ");
INSERT INTO nld_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","En Kenan leefde, nadat hij Mahalal-el gewonnen had, achthonderd en veertig jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Zo waren al de dagen van Kenan negenhonderd en tien jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","En Mahalal-el leefde vijf en zestig jaren, en hij gewon Jered. ");
INSERT INTO nld_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","En Mahalal-el leefde, nadat hij Jered gewonnen had, achthonderd en dertig jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Zo waren al de dagen van Mahalal-el achthonderd vijf en negentig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","En Jered leefde honderd twee en zestig jaren, en hij gewon Henoch. ");
INSERT INTO nld_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","En Jered leefde, nadat hij Henoch gewonnen had, achthonderd jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Zo waren al de dagen van Jered negenhonderd twee en zestig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","En Henoch leefde vijf en zestig jaren, en hij gewon Methusalach. ");
INSERT INTO nld_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","En Henoch wandelde met God, nadat hij Methusalach gewonnen had, driehonderd jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Zo waren al de dagen van Henoch driehonderd vijf en zestig jaren. ");
INSERT INTO nld_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoch dan wandelde met God; en hij was niet meer; want God nam hem weg. ");
INSERT INTO nld_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","En Methusalach leefde honderd zeven en tachtig jaren, en hij gewon Lamech. ");
INSERT INTO nld_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","En Methusalach leefde, nadat hij Lamech gewonnen had, zevenhonderd twee en tachtig jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Zo waren al de dagen van Methusalach negenhonderd negen en zestig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","En Lamech leefde honderd twee en tachtig jaren, en hij gewon een zoon. ");
INSERT INTO nld_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","En hij noemde zijn naam Noach, zeggende: Deze zal ons troosten over ons werk, en over de smart onzer handen, vanwege het aardrijk, dat de HEERE vervloekt heeft! ");
INSERT INTO nld_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","En Lamech leefde, nadat hij Noach gewonnen had, vijfhonderd vijf en negentig jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Zo waren al de dagen van Lamech zevenhonderd zeven en zeventig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","En Noach was vijfhonderd jaren oud; en Noach gewon Sem, Cham en Jafeth. ");
INSERT INTO nld_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","En het geschiedde, als de mensen op den aardbodem begonnen te vermenigvuldigen, en hun dochters geboren werden, ");
INSERT INTO nld_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Dat Gods zonen de dochteren der mensen aanzagen, dat zij schoon waren, en zij namen zich vrouwen uit allen, die zij verkozen hadden. ");
INSERT INTO nld_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Toen zeide de HEERE: Mijn Geest zal niet in eeuwigheid twisten met den mens, dewijl hij ook vlees is; doch zijn dagen zullen zijn honderd en twintig jaren. ");
INSERT INTO nld_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In die dagen waren er reuzen op de aarde, en ook daarna, als Gods zonen tot de dochteren der mensen ingegaan waren, en zich kinderen gewonnen hadden; deze zijn de geweldigen, die van ouds geweest zijn, mannen van name. ");
INSERT INTO nld_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","En de HEERE zag, dat de boosheid des mensen menigvuldig was op de aarde, en al het gedichtsel der gedachten zijns harten te allen dage alleenlijk boos was. ");
INSERT INTO nld_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Toen berouwde het den HEERE, dat Hij den mens op de aarde gemaakt had, en het smartte Hem aan Zijn hart. ");
INSERT INTO nld_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","En de HEERE zeide: Ik zal den mens, dien Ik geschapen heb, verdelgen van den aardbodem, van den mens tot het vee, tot het kruipend gedierte, en tot het gevogelte des hemels toe; want het berouwt Mij, dat Ik hen gemaakt heb. ");
INSERT INTO nld_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maar Noach vond genade in de ogen des HEEREN. ");
INSERT INTO nld_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dit zijn de geboorten van Noach. Noach was een rechtvaardig, oprecht man in zijn geslachten. Noach wandelde met God. ");
INSERT INTO nld_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","En Noach gewon drie zonen: Sem, Cham en Jafeth. ");
INSERT INTO nld_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Maar de aarde was verdorven voor Gods aangezicht; en de aarde was vervuld met wrevel. ");
INSERT INTO nld_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Toen zag God de aarde, en ziet, zij was verdorven; want al het vlees had zijn weg verdorven op de aarde. ");
INSERT INTO nld_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Daarom zeide God tot Noach: Het einde van alle vlees is voor Mijn aangezicht gekomen; want de aarde is door hen vervuld met wrevel; en zie, Ik zal hen met de aarde verderven. ");
INSERT INTO nld_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Maak u een ark van goferhout; met kameren zult gij deze ark maken; en gij zult die bepekken van binnen en van buiten met pek. ");
INSERT INTO nld_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","En aldus is het, dat gij haar maken zult: driehonderd ellen zij de lengte der ark, vijftig ellen haar breedte, en dertig ellen haar hoogte. ");
INSERT INTO nld_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gij zult een venster aan de ark maken, en zult haar volmaken tot een elle van boven; en de deur der ark zult gij in haar zijde zetten; gij zult ze met onderste, tweede en derde verdiepingen maken. ");
INSERT INTO nld_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Want Ik, zie, Ik breng een watervloed over de aarde, om alle vlees, waarin een geest des levens is, van onder den hemel te verderven; al wat op de aarde is, zal den geest geven. ");
INSERT INTO nld_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Maar met u zal Ik Mijn verbond oprichten; en gij zult in de ark gaan, gij, en uw zonen, en uw huisvrouw, en de vrouwen uwer zonen met u. ");
INSERT INTO nld_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","En gij zult van al wat leeft, van alle vlees, twee van elk, doen in de ark komen, om met u in het leven te behouden: mannetje en wijfje zullen zij zijn; ");
INSERT INTO nld_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Van het gevogelte naar zijn aard, en van het vee naar zijn aard, van al het kruipend gedierte des aardbodems naar zijn aard, twee van elk zullen tot u komen, om die in het leven te behouden. ");
INSERT INTO nld_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","En gij, neem voor u van alle spijze, die gegeten wordt, en verzamel ze tot u, opdat zij u en hun tot spijze zij. ");
INSERT INTO nld_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","En Noach deed het; naar al wat God hem geboden had, zo deed hij. ");
INSERT INTO nld_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Daarna zeide de HEERE tot Noach: Ga gij, en uw ganse huis in de ark; want u heb Ik gezien rechtvaardig voor Mijn aangezicht in dit geslacht. ");
INSERT INTO nld_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Van alle rein vee zult gij tot u nemen zeven en zeven, het mannetje en zijn wijfje; maar van het vee, dat niet rein is, twee, het mannetje en zijn wijfje. ");
INSERT INTO nld_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ook van het gevogelte des hemels zeven en zeven, het mannetje en het wijfje, om zaad levend te houden op de ganse aarde. ");
INSERT INTO nld_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Want over nog zeven dagen zal Ik doen regenen op de aarde veertig dagen, en veertig nachten; en Ik zal van den aardbodem verdelgen al wat bestaat, dat Ik gemaakt heb. ");
INSERT INTO nld_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","En Noach deed, naar al wat de HEERE hem geboden had. ");
INSERT INTO nld_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noach nu was zeshonderd jaren oud, als de vloed der wateren op de aarde was. ");
INSERT INTO nld_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Zo ging Noach, en zijn zonen, en zijn huisvrouw, en de vrouwen zijner zonen met hem in de ark, vanwege de wateren des vloeds. ");
INSERT INTO nld_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Van het reine vee, en van het vee, dat niet rein was, en van het gevogelte, en al wat op den aardbodem kruipt, ");
INSERT INTO nld_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Kwamen er twee en twee tot Noach in de ark, het mannetje en het wijfje, gelijk als God Noach geboden had. ");
INSERT INTO nld_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","En het geschiedde na die zeven dagen, dat de wateren des vloeds op de aarde waren. ");
INSERT INTO nld_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In het zeshonderdste jaar des levens van Noach, in de tweede maand, op den zeventienden dag der maand, op dezen zelfden dag zijn alle fonteinen des groten afgronds opengebroken, en de sluizen des hemels geopend. ");
INSERT INTO nld_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","En een plasregen was op de aarde veertig dagen en veertig nachten. ");
INSERT INTO nld_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Even op dienzelfden dag ging Noach, en Sem, en Cham, en Jafeth, Noachs zonen, desgelijks ook Noachs huisvrouw, en de drie vrouwen zijner zonen met hem in de ark; ");
INSERT INTO nld_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Zij, en al het gedierte naar zijn aard, en al het vee naar zijn aard, en al het kruipend gedierte, dat op de aarde kruipt, naar zijn aard, en al het gevogelte naar zijn aard, alle vogeltjes van allerlei vleugel. ");
INSERT INTO nld_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","En van alle vlees, waarin een geest des levens was, kwamen er twee en twee tot Noach in de ark. ");
INSERT INTO nld_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","En die er kwamen, die kwamen mannetje en wijfje, van alle vlees, gelijk als hem God bevolen had. En de HEERE sloot achter hem toe. ");
INSERT INTO nld_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","En die vloed was veertig dagen op de aarde, en de wateren vermeerderden, en hieven de ark op, zodat zij oprees boven de aarde. ");
INSERT INTO nld_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","En de wateren namen de overhand, en vermeerderden zeer op de aarde; en de ark ging op de wateren. ");
INSERT INTO nld_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","En de wateren namen gans zeer de overhand op de aarde, zodat alle hoge bergen, die onder den gansen hemel zijn, bedekt werden. ");
INSERT INTO nld_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Vijftien ellen omhoog namen de wateren de overhand, en de bergen werden bedekt. ");
INSERT INTO nld_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","En alle vlees, dat zich op de aarde roerde, gaf den geest, van het gevogelte, en van het vee, en van het wild gedierte, en van al het kruipend gedierte, dat op de aarde kroop, en alle mens. ");
INSERT INTO nld_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Al wat een adem des geestes des levens in zijn neusgaten had, van alles wat op het droge was, is gestorven. ");
INSERT INTO nld_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Alzo werd verdelgd al wat bestond, dat op den aardbodem was, van den mens aan tot het vee, tot het kruipend gedierte, en tot het gevogelte des hemels, en zij werden verdelgd van de aarde; doch Noach alleen bleef over, en wat met hem in de ark was. ");
INSERT INTO nld_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","En de wateren hadden de overhand boven de aarde, honderd en vijftig dagen. ");
INSERT INTO nld_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","En God gedacht aan Noach, en aan al het gedierte, en aan al het vee, dat met hem in de ark was; en God deed een wind over de aarde doorgaan, en de wateren werden stil. ");
INSERT INTO nld_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ook werden de fonteinen des afgronds, en de sluizen des hemels gesloten, en de plasregen van den hemel werd opgehouden. ");
INSERT INTO nld_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Daartoe keerden de wateren weder van boven de aarde, heen en weder vloeiende, en de wateren namen af ten einde van honderd en vijftig dagen. ");
INSERT INTO nld_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","En de ark rustte in de zevende maand, op den zeventienden dag der maand, op de bergen van Ararat. ");
INSERT INTO nld_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","En de wateren waren gaande, en afnemende tot de tiende maand; in de tiende maand, op den eersten der maand, werden de toppen der bergen gezien. ");
INSERT INTO nld_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","En het geschiedde, ten einde van veertig dagen, dat Noach het venster der ark, die hij gemaakt had, opendeed. ");
INSERT INTO nld_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","En hij liet een raaf uit, die dikwijls heen en weder ging, totdat de wateren van boven de aarde verdroogd waren. ");
INSERT INTO nld_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Daarna liet hij een duif van zich uit, om te zien, of de wateren gelicht waren van boven den aardbodem. ");
INSERT INTO nld_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Maar de duif vond geen rust voor het hol van haar voet; zo keerde zij weder tot hem in de ark; want de wateren waren op de ganse aarde; en hij stak zijn hand uit, en nam haar, en bracht haar tot zich in de ark. ");
INSERT INTO nld_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","En hij verbeidde nog zeven andere dagen; toen liet hij de duif wederom uit de ark. ");
INSERT INTO nld_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","En de duif kwam tot hem tegen den avondtijd; en ziet, een afgebroken olijfblad was in haar bek; zo merkte Noach, dat de wateren van boven de aarde gelicht waren. ");
INSERT INTO nld_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Toen vertoefde hij nog zeven andere dagen; en hij liet de duif uit; maar zij keerde niet meer weder tot hem. ");
INSERT INTO nld_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","En het geschiedde in het zeshonderd en eerste jaar, in de eerste maand, op den eersten derzelver maand, dat de wateren droogden van boven de aarde; toen deed Noach het deksel der ark af, en zag toe, en ziet, de aardbodem was gedroogd. ");
INSERT INTO nld_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","En in de tweede maand, op den zeven en twintigsten dag der maand, was de aarde opgedroogd. ");
INSERT INTO nld_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Toen sprak God tot Noach, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ga uit de ark, gij, en uw huisvrouw, en uw zonen, en de vrouwen uwer zonen met u. ");
INSERT INTO nld_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Al het gedierte, dat met u is, van alle vlees, aan gevogelte, en aan vee, en aan al het kruipend gedierte, dat op de aarde kruipt, doe met u uitgaan; en dat zij overvloediglijk voorttelen op de aarde, en vruchtbaar zijn, en vermenigvuldigen op de aarde. ");
INSERT INTO nld_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Toen ging Noach uit, en zijn zonen, en zijn huisvrouw, en de vrouwen zijner zonen met hem. ");
INSERT INTO nld_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Al het gedierte, al het kruipende, en al het gevogelte, al wat zich op de aarde roert, naar hun geslachten, gingen uit de ark. ");
INSERT INTO nld_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","En Noach bouwde den HEERE een altaar; en hij nam van al het reine vee, en van al het rein gevogelte, en offerde brandofferen op dat altaar. ");
INSERT INTO nld_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","En de HEERE rook dien liefelijken reuk, en de HEERE zeide in Zijn hart: Ik zal voortaan den aardbodem niet meer vervloeken om des mensen wil; want het gedichtsel van 's mensen hart is boos van zijn jeugd aan; en Ik zal voortaan niet meer al het levende slaan, gelijk als Ik gedaan heb. ");
INSERT INTO nld_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Voortaan al de dagen der aarde zullen zaaiing en oogst, en koude en hitte, en zomer en winter, en dag en nacht, niet ophouden. ");
INSERT INTO nld_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","En God zegende Noach en zijn zonen, en Hij zeide tot hen: Zijt vruchtbaar en vermenigvuldigt, en vervult de aarde! ");
INSERT INTO nld_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","En uw vrees, en uw verschrikking zij over al het gedierte der aarde, en over al het gevogelte des hemels; in al wat zich op den aardbodem roert, en in alle vissen der zee; zij zijn in uw hand overgegeven. ");
INSERT INTO nld_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Al wat zich roert, dat levend is, zij u tot spijze; Ik heb het u al gegeven, gelijk het groene kruid. ");
INSERT INTO nld_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Doch het vlees met zijn ziel, dat is zijn bloed, zult gij niet eten. ");
INSERT INTO nld_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","En voorwaar, Ik zal uw bloed, het bloed uwer zielen eisen; van de hand van alle gedierte zal Ik het eisen; ook van de hand des mensen, van de hand eens iegelijken zijns broeders zal Ik de ziel des mensen eisen. ");
INSERT INTO nld_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wie des mensen bloed vergiet, zijn bloed zal door den mens vergoten worden; want God heeft den mens naar Zijn beeld gemaakt. ");
INSERT INTO nld_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Maar gijlieden, weest vruchtbaar, en vermenigvuldigt; teelt overvloediglijk voort op de aarde, en vermenigvuldigt op dezelve. ");
INSERT INTO nld_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Voorts zeide God tot Noach, en tot zijn zonen met hem, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Maar Ik, ziet, Ik richt Mijn verbond op met u, en met uw zaad na u; ");
INSERT INTO nld_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","En met alle levende ziel, die met u is, van het gevogelte, van het vee, en van alle gedierte der aarde met u; van allen, die uit de ark gegaan zijn, tot al het gedierte der aarde toe. ");
INSERT INTO nld_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","En Ik richt Mijn verbond op met u, dat niet meer alle vlees door de wateren des vloeds zal worden uitgeroeid; en dat er geen vloed meer zal zijn, om de aarde te verderven. ");
INSERT INTO nld_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","En God zeide: Dit is het teken des verbonds, dat Ik geef tussen Mij en tussen ulieden, en tussen alle levende ziel, die met u is, tot eeuwige geslachten. ");
INSERT INTO nld_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mijn boog heb Ik gegeven in de wolken; die zal zijn tot een teken des verbonds tussen Mij en tussen de aarde. ");
INSERT INTO nld_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","En het zal geschieden, als Ik wolken over de aarde brenge, dat deze boog zal gezien worden in de wolken; ");
INSERT INTO nld_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Dan zal Ik gedenken aan Mijn verbond, hetwelk is tussen Mij en tussen u, en tussen alle levende ziel van alle vlees; en de wateren zullen niet meer wezen tot een vloed, om alle vlees te verderven. ");
INSERT INTO nld_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Als deze boog in de wolken zal zijn, zo zal Ik hem aanzien, om te gedenken aan het eeuwig verbond tussen God en tussen alle levende ziel, van alle vlees, dat op de aarde is. ");
INSERT INTO nld_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Zo zeide dan God tot Noach: Dit is het teken des verbonds, dat Ik opgericht heb tussen Mij en tussen alle vlees, dat op de aarde is. ");
INSERT INTO nld_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","En de zonen van Noach, die uit de ark gingen, waren Sem, en Cham, en Jafeth; en Cham is de vader van Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Deze drie waren de zonen van Noach; en van dezen is de ganse aarde overspreid. ");
INSERT INTO nld_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","En Noach begon een akkerman te zijn, en hij plantte een wijngaard. ");
INSERT INTO nld_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","En hij dronk van dien wijn, en werd dronken; en hij ontblootte zich in het midden zijner tent. ");
INSERT INTO nld_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","En Cham, Kanaans vader, zag zijns vaders naaktheid, en hij gaf het zijn beiden broederen daar buiten te kennen. ");
INSERT INTO nld_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Toen namen Sem en Jafeth een kleed, en zij leiden het op hun beider schouderen, en gingen achterwaarts, en bedekten de naaktheid huns vaders; en hun aangezichten waren achterwaarts gekeerd, zodat zij de naaktheid huns vaders niet zagen. ");
INSERT INTO nld_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","En Noach ontwaakte van zijn wijn; en hij merkte wat zijn kleinste zoon hem gedaan had. ");
INSERT INTO nld_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","En hij zeide: Vervloekt zij Kanaan; een knecht der knechten zij hij zijn broederen! ");
INSERT INTO nld_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Voorts zeide hij: Gezegend zij de HEERE, de God van Sem; en Kanaan zij hem een knecht! ");
INSERT INTO nld_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God breide Jafeth uit, en hij wone in Sems tenten! en Kanaan zij hem een knecht! ");
INSERT INTO nld_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","En Noach leefde na den vloed driehonderd en vijftig jaren. ");
INSERT INTO nld_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Zo waren al de dagen van Noach negenhonderd en vijftig jaren; en hij stierf. ");
INSERT INTO nld_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dit nu zijn de geboorten van Noachs zonen: Sem, Cham, en Jafeth; en hun werden zonen geboren na den vloed. ");
INSERT INTO nld_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","De zonen van Jafeth zijn: Gomer, en Magog, en Madai, en Javan, en Tubal, en Mesech, en Thiras. ");
INSERT INTO nld_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","En de zonen van Gomer zijn: Askenaz, en Rifath, en Togarma. ");
INSERT INTO nld_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","En de zonen van Javan zijn: Elisa, en Tarsis; de Chittieten en Dodanieten. ");
INSERT INTO nld_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Van dezen zijn verdeeld de eilanden der volken in hun landschappen, elk naar zijn spraak, naar hun huisgezinnen, onder hun volken. ");
INSERT INTO nld_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","En de zonen van Cham zijn: Cusch en Mitsraim, en Put, en Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","En de zonen van Cusch zijn: Seba en Havila, en Sabta, en Raema, en Sabtecha. En de zonen van Raema zijn: Scheba en Dedan. ");
INSERT INTO nld_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","En Cusch gewon Nimrod; deze begon geweldig te zijn op de aarde. ");
INSERT INTO nld_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Hij was een geweldig jager voor het aangezicht des HEEREN; daarom wordt gezegd: Gelijk Nimrod, een geweldig jager voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","En het beginsel zijns rijks was Babel, en Erech, en Accad, en Calne in het land Sinear. ");
INSERT INTO nld_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Uit ditzelve land is Assur uitgegaan, en heeft gebouwd Nineve, en Rehoboth, Ir, en Kalach. ");
INSERT INTO nld_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","En Resen, tussen Nineve en tussen Kalach; deze is die grote stad. ");
INSERT INTO nld_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","En Mitsraim gewon de Ludieten, en de Anamieten, en de Lehabieten, en de Naftuchieten, ");
INSERT INTO nld_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","En de Pathrusieten, en de Casluchieten, van waar de Filistijnen uitgekomen zijn, en de Caftorieten. ");
INSERT INTO nld_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","En Kanaan gewon Sidon, zijn eerstgeborene, en Heth, ");
INSERT INTO nld_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","En den Jebusiet, en den Amoriet, en den Girgasiet, ");
INSERT INTO nld_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","En den Hivviet, en den Arkiet, en den Siniet, ");
INSERT INTO nld_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","En den Arvadiet, en den Tsemariet, en den Hamathiet; en daarna zijn de huisgezinnen der Kanaanieten verspreid. ");
INSERT INTO nld_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","En de landpale der Kanaanieten was van Sidon, daar gij gaat naar Gerar tot Gaza toe; daar gij gaat naar Sodom en Gomorra, en Adama, en Zoboim, tot Lasa toe. ");
INSERT INTO nld_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Deze zijn zonen van Cham, naar hun huisgezinnen, naar hun spraken, in hun landschappen, in hun volken. ");
INSERT INTO nld_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Voorts zijn Sem zonen geboren; dezelve is ook de vader aller zonen van Heber, broeder van Jafeth, den grootste. ");
INSERT INTO nld_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sems zonen waren Elam, en Assur, en Arfachsad, en Lud, en Aram. ");
INSERT INTO nld_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","En Arams zonen waren Uz, en Hul, en Gether, en Maz. ");
INSERT INTO nld_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","En Arfachsad gewon Selah, en Selah gewon Heber. ");
INSERT INTO nld_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","En Heber werden twee zonen geboren; des enen naam was Peleg; want in zijn dagen is de aarde verdeeld; en zijns broeders naam was Joktan. ");
INSERT INTO nld_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","En Joktan gewon Almodad, en Selef, en Hatsarmaveth, en Jarach, ");
INSERT INTO nld_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","En Hadoram, en Usal, en Dikla, ");
INSERT INTO nld_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","En Obal, en Abimael, en Scheba, ");
INSERT INTO nld_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","En Ofir, en Havila, en Jobab; deze allen waren zonen van Joktan. ");
INSERT INTO nld_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","En hun woning was van Mescha af, daar gij gaat naar Sefar, het gebergte van het oosten. ");
INSERT INTO nld_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Deze zijn zonen van Sem, naar hun huisgezinnen, naar hun spraken, in hun landschappen, naar hun volken. ");
INSERT INTO nld_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Deze zijn de huisgezinnen der zonen van Noach, naar hun geboorten, in hun volken; en van dezen zijn de volken op de aarde verdeeld na den vloed. ");
INSERT INTO nld_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","En de ganse aarde was van enerlei spraak en enerlei woorden. ");
INSERT INTO nld_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Maar het geschiedde, als zij tegen het oosten togen, dat zij een laagte vonden in het land Sinear; en zij woonden aldaar. ");
INSERT INTO nld_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","En zij zeiden een ieder tot zijn naaste: Kom aan, laat ons tichelen strijken, en wel doorbranden! En de tichel was hun voor steen, en het lijm was hun voor leem. ");
INSERT INTO nld_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","En zij zeiden: Kom aan, laat ons voor ons een stad bouwen, en een toren, welks opperste in den hemel zij, en laat ons een naam voor ons maken, opdat wij niet misschien over de ganse aarde verstrooid worden! ");
INSERT INTO nld_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Toen kwam de HEERE neder, om te bezien de stad en den toren, die de kinderen der mensen bouwden. ");
INSERT INTO nld_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","En de HEERE zeide: Ziet, zij zijn enerlei volk, en hebben allen enerlei spraak; en dit is het, dat zij beginnen te maken; maar nu, zoude hun niet afgesneden worden al wat zij bedacht hebben te maken? ");
INSERT INTO nld_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kom aan, laat Ons nedervaren, en laat Ons hun spraak aldaar verwarren, opdat iegelijk de spraak zijns naasten niet hore. ");
INSERT INTO nld_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Alzo verstrooide hen de HEERE van daar over de ganse aarde; en zij hielden op de stad te bouwen. ");
INSERT INTO nld_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Daarom noemde men haar naam Babel; want aldaar verwarde de HEERE de spraak der ganse aarde, en van daar verstrooide hen de HEERE over de ganse aarde. ");
INSERT INTO nld_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Deze zijn de geboorten van Sem: Sem was honderd jaren oud, en gewon Arfachsad, twee jaren na den vloed. ");
INSERT INTO nld_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","En Sem leefde, nadat hij Arfachsad gewonnen had, vijfhonderd jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","En Arfachsad leefde vijf en dertig jaren, en hij gewon Selah. ");
INSERT INTO nld_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","En Arfachsad leefde, nadat hij Selah gewonnen had, vierhonderd en drie jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","En Selah leefde dertig jaren, en hij gewon Heber. ");
INSERT INTO nld_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","En Selah leefde, nadat hij Heber gewonnen had, vierhonderd en drie jaren, en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","En Heber leefde vier en dertig jaren, en gewon Peleg. ");
INSERT INTO nld_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","En Heber leefde, nadat hij Peleg gewonnen had, vierhonderd en dertig jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","En Peleg leefde dertig jaren, en hij gewon Rehu. ");
INSERT INTO nld_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","En Peleg leefde, nadat hij Rehu gewonnen had, tweehonderd en negen jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","En Rehu leefde twee en dertig jaren, en hij gewon Serug. ");
INSERT INTO nld_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","En Rehu leefde, nadat hij Serug gewonnen had, tweehonderd en zeven jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","En Serug leefde dertig jaren, en gewon Nahor. ");
INSERT INTO nld_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","En Serug leefde, nadat hij Nahor gewonnen had, tweehonderd jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","En Nahor leefde negen en twintig jaren, en gewon Terah. ");
INSERT INTO nld_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","En Nahor leefde, nadat hij Terah gewonnen had, honderd en negentien jaren; en hij gewon zonen en dochteren. ");
INSERT INTO nld_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","En Terah leefde zeventig jaren, en gewon Abram, Nahor en Haran. ");
INSERT INTO nld_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","En deze zijn de geboorten van Terah: Terah gewon Abram, Nahor en Haran; en Haran gewon Lot. ");
INSERT INTO nld_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","En Haran stierf voor het aangezicht zijns vaders Terah, in het land zijner geboorte, in Ur der Chaldeen. ");
INSERT INTO nld_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","En Abram en Nahor namen zich vrouwen; de naam van Abrams huisvrouw was Sarai, en de naam van Nahors huisvrouw was Milka, een dochter van Haran, vader van Milka, en vader van Jiska. ");
INSERT INTO nld_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","En Sarai was onvruchtbaar; zij had geen kind. ");
INSERT INTO nld_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","En Terah nam Abram, zijn zoon, en Lot, Harans zoon, zijns zoons zoon, en Sarai, zijn schoondochter, de huisvrouw van zijn zoon Abram, en zij togen met hen uit Ur der Chaldeen, om te gaan naar het land Kanaan; en zij kwamen tot Haran, en woonden aldaar. ");
INSERT INTO nld_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","En de dagen van Terah waren tweehonderd en vijf jaren, en Terah stierf te Haran. ");
INSERT INTO nld_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","De HEERE nu had tot Abram gezegd: Ga gij uit uw land, en uit uw maagschap, en uit uws vaders huis, naar het land, dat Ik u wijzen zal. ");
INSERT INTO nld_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","En Ik zal u tot een groot volk maken, en u zegenen, en uw naam groot maken; en wees een zegen! ");
INSERT INTO nld_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","En Ik zal zegenen, die u zegenen, en vervloeken, die u vloekt; en in u zullen alle geslachten des aardrijks gezegend worden. ");
INSERT INTO nld_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","En Abram toog heen, gelijk de HEERE tot hem gesproken had; en Lot toog met hem; en Abram was vijf en zeventig jaren oud, toen hij uit Haran ging. ");
INSERT INTO nld_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","En Abram nam Sarai, zijn huisvrouw, en Lot, zijns broeders zoon, en al hun have, die zij verworven hadden, en de zielen, die zij verkregen hadden in Haran; en zij togen uit, om te gaan naar het land Kanaan, en zij kwamen in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","En Abram is doorgetogen in dat land, tot aan de plaats Sichem, tot aan het eikenbos More; en de Kanaanieten waren toen ter tijd in dat land. ");
INSERT INTO nld_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Zo verscheen de HEERE aan Abram, en zeide: Aan uw zaad zal Ik dit land geven. Toen bouwde hij aldaar een altaar den HEERE, Die hem verschenen was. ");
INSERT INTO nld_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","En hij brak op van daar naar het gebergte, tegen het oosten van Beth-El, en hij sloeg zijn tent op, zijnde Beth-El tegen het westen, en Ai tegen het oosten; en hij bouwde daar den HEERE een altaar, en riep den Naam des HEEREN aan. ");
INSERT INTO nld_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Daarna vertrok Abram, gaande en trekkende naar het zuiden. ");
INSERT INTO nld_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","En er was honger in dat land; zo toog Abram af naar Egypte, om daar als een vreemdeling te verkeren, dewijl de honger zwaar was in dat land. ");
INSERT INTO nld_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","En het geschiedde, als hij naderde, om in Egypte te komen, dat hij zeide tot Sarai, zijn huisvrouw: Zie toch, ik weet, dat gij een vrouw zijt, schoon van aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","En het zal geschieden, als u de Egyptenaars zullen zien, zo zullen zij zeggen: Dat is zijn huisvrouw; en zij zullen mij doden, en u in het leven behouden. ");
INSERT INTO nld_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Zeg toch: Gij zijt mijn zuster; opdat het mij wel ga om u, en mijn ziel om uwentwil leve. ");
INSERT INTO nld_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","En het geschiedde, als Abram in Egypte kwam, dat de Egyptenaars deze vrouw zagen, dat zij zeer schoon was. ");
INSERT INTO nld_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ook zagen haar de vorsten van Farao, en prezen haar bij Farao; en die vrouw werd weggenomen naar het huis van Farao. ");
INSERT INTO nld_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","En hij deed Abram goed, om harentwil; zodat hij had schapen, en runderen, en ezelen, en knechten, en maagden, en ezelinnen, en kemelen. ");
INSERT INTO nld_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Maar de HEERE plaagde Farao met grote plagen, ook zijn huis, ter oorzake van Sarai, Abrams huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Toen riep Farao Abram, en zeide: Wat is dit, dat gij mij gedaan hebt? waarom hebt gij mij niet te kennen gegeven, dat zij uw huisvrouw is? ");
INSERT INTO nld_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Waarom hebt gij gezegd: Zij is mijn zuster; zodat ik haar mij tot een vrouw zoude genomen hebben? en nu, zie, daar is uw huisvrouw; neem haar en ga henen! ");
INSERT INTO nld_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","En Farao gebood zijn mannen vanwege hem, en zij geleidden hem, en zijn huisvrouw, en alles wat hij had. ");
INSERT INTO nld_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Alzo toog Abram op uit Egypte naar het zuiden, hij en zijn huisvrouw, en al wat hij had, en Lot met hem. ");
INSERT INTO nld_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","En Abram was zeer rijk, in vee, in zilver, en in goud. ");
INSERT INTO nld_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","En hij ging, volgens zijn reizen, van het zuiden tot Beth-El toe, tot aan de plaats, waar zijn tent in het begin geweest was, tussen Beth-El, en tussen Ai; ");
INSERT INTO nld_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tot de plaats des altaars, dat hij in het eerst daar gemaakt had; en Abram heeft aldaar den Naam des HEEREN aangeroepen. ");
INSERT INTO nld_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","En Lot, die met Abram toog, had ook schapen, en runderen, en tenten. ");
INSERT INTO nld_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","En dat land droeg hen niet, om samen te wonen; want hun have was vele, zodat zij samen niet konden wonen. ");
INSERT INTO nld_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","En er was twist tussen de herders van Abrams vee, en tussen de herders van Lots vee. Ook woonden toen de Kanaanieten en Ferezieten in dat land. ");
INSERT INTO nld_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","En Abram zeide tot Lot: Laat toch geen twisting zijn tussen mij en tussen u, en tussen mijn herders en tussen uw herders; want wij zijn mannen broeders. ");
INSERT INTO nld_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is niet het ganse land voor uw aangezicht? Scheid u toch van mij; zo gij de linkerhand kiest, zo zal ik ter rechterhand gaan; en zo gij de rechterhand, zo zal ik ter linkerhand gaan. ");
INSERT INTO nld_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","En Lot hief zijn ogen op, en hij zag de ganse vlakte der Jordaan, dat zij die geheel bevochtigde; eer de HEERE Sodom en Gomorra verdorven had, was zij als de hof des HEEREN, als Egypteland, als gij komt te Zoar. ");
INSERT INTO nld_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Zo koos Lot voor zich de ganse vlakte der Jordaan, en Lot trok tegen het oosten; en zij werden gescheiden, de een van den ander. ");
INSERT INTO nld_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram dan woonde in het land Kanaan; en Lot woonde in de steden der vlakte, en sloeg tenten tot aan Sodom toe. ");
INSERT INTO nld_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","En de mannen van Sodom waren boos, en grote zondaars tegen den HEERE. ");
INSERT INTO nld_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","En de HEERE zeide tot Abram, nadat Lot van hem gescheiden was: Hef uw ogen op, en zie van de plaats, waar gij zijt noordwaarts en zuidwaarts, en oostwaarts en westwaarts. ");
INSERT INTO nld_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Want al dit land, dat gij ziet, zal Ik u geven, en aan uw zaad, tot in eeuwigheid. ");
INSERT INTO nld_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","En Ik zal uw zaad stellen als het stof der aarde, zodat, indien iemand het stof der aarde zal kunnen tellen, zal ook uw zaad geteld worden. ");
INSERT INTO nld_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Maak u op, wandel door dit land, in zijn lengte en in zijn breedte; want Ik zal het u geven. ");
INSERT INTO nld_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","En Abram sloeg tenten op, en kwam en woonde aan de eikenbossen van Mamre, die bij Hebron zijn; en hij bouwde aldaar den HEERE een altaar. ");
INSERT INTO nld_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","En het geschiedde in de dagen van Amrafel, den koning van Sinear, van Arioch, den koning van Ellasar, van Kedor-Laomer, den koning van Elam, en van Tideal, den koning der volken; ");
INSERT INTO nld_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Dat zij krijg voerden met Bera, koning van Sodom, en met Birsa, koning van Gomorra, Sinab, koning van Adama, en Semeber, koning van Zeboim, en den koning van Bela, dat is Zoar. ");
INSERT INTO nld_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Deze allen voegden zich samen in het dal Siddim, dat is de Zoutzee. ");
INSERT INTO nld_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twaalf jaren hadden zij Kedor-Laomer gediend; maar in het dertiende jaar vielen zij af. ");
INSERT INTO nld_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Zo kwam Kedor-Laomer in het veertiende jaar, en de koningen, die met hem waren, en sloegen de Refaieten in Asteroth-Karnaim, en de Zuzieten in Ham, en de Emieten in Schave-Kiriathaim; ");
INSERT INTO nld_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","En de Horieten op hun gebergte Seir, tot aan het effen veld van Paran, hetwelk aan de woestijn is. ");
INSERT INTO nld_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Daarna keerden zij wederom, en kwamen tot En-Mispat, dat is Kades, en sloegen al het land der Amalekieten, en ook den Amoriet, die te Hazezon-Thamar woonde. ");
INSERT INTO nld_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Toen toog de koning van Sodom uit, en de koning van Gomorra, en de koning van Adama, en de koning van Zeboim, en de koning van Bela, dat is Zoar; en zij stelden tegen hen slagorden in het dal Siddim, ");
INSERT INTO nld_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Tegen Kedor-Laomer, den koning van Elam, en Tideal, den koning der volken, en Amrafel, den koning van Sinear, en Arioch, den koning van Ellasar; vier koningen tegen vijf. ");
INSERT INTO nld_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Het dal nu van Siddim was vol lijmputten; en de koningen van Sodom en Gomorra vluchtten, en vielen aldaar; en de overgeblevenen vluchtten naar het gebergte. ");
INSERT INTO nld_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","En zij namen al de have van Sodom en Gomorra, en al hun spijze, en trokken weg. ");
INSERT INTO nld_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ook namen zij Lot, den zoon van Abrams broeder, en zijn have, en trokken weg; want hij woonde in Sodom. ");
INSERT INTO nld_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Toen kwam er een, die ontkomen was, en boodschapte het aan Abram, den Hebreer, die woonachtig was aan de eikenbossen van Mamre, den Amoriet, broeder van Eskol, en broeder van Aner, welke Abrams bondgenoten waren. ");
INSERT INTO nld_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Als Abram hoorde, dat zijn broeder gevangen was, zo wapende hij zijn onderwezenen, de ingeborenen van zijn huis, driehonderd en achttien, en hij jaagde hen na tot Dan toe. ");
INSERT INTO nld_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","En hij verdeelde zich tegen hen des nachts, hij en zijn knechten, en sloeg ze; en hij jaagde hen na tot Hoba toe, hetwelk is ter linkerhand van Damaskus. ");
INSERT INTO nld_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","En hij bracht alle have weder, en ook Lot zijn broeder en deszelfs have bracht hij weder, als ook de vrouwen, en het volk. ");
INSERT INTO nld_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","En de koning van Sodom toog uit, hem tegemoet (nadat hij wedergekeerd was van het slaan van Kedor-Laomer, en van de koningen, die met hem waren), tot het dal Schave, dat is, het dal des konings. ");
INSERT INTO nld_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","En Melchizedek, koning van Salem, bracht voort brood en wijn; en hij was een priester des allerhoogsten Gods. ");
INSERT INTO nld_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","En hij zegende hem, en zeide: Gezegend zij Abram Gode, de Allerhoogste, Die hemel en aarde bezit! ");
INSERT INTO nld_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","En gezegend zij de allerhoogste God, Die uw vijanden in uw hand geleverd heeft! En hij gaf hem de tiende van alles. ");
INSERT INTO nld_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","En de koning van Sodom zeide tot Abram: Geef mij de zielen; maar neem de have voor u. ");
INSERT INTO nld_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Doch Abram zeide tot den koning van Sodom: Ik heb mijn hand opgeheven tot den HEERE, den allerhoogsten God, Die hemel en aarde bezit; ");
INSERT INTO nld_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Zo ik van een draad aan tot een schoenriem toe, ja, zo ik van alles, dat het uwe is, iets neme! opdat gij niet zegt: Ik heb Abram rijk gemaakt! ");
INSERT INTO nld_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Het zij buiten mij; alleen wat de jongelingen verteerd hebben, en het deel dezer mannen, die met mij getogen zijn, Aner, Eskol en Mamre, laat die hun deel nemen! ");
INSERT INTO nld_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na deze dingen geschiedde het woord des HEEREN tot Abram in een gezicht, zeggende: Vrees niet, Abram! Ik ben u een Schild, uw Loon zeer groot. ");
INSERT INTO nld_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Toen zeide Abram: Heere, HEERE! wat zult Gij mij geven, daar ik zonder kinderen heenga en de bezorger van mijn huis is deze Damaskener Eliezer? ");
INSERT INTO nld_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Voorts zeide Abram: Zie, mij hebt Gij geen zaad gegeven, en zie, de zoon van mijn huis zal mijn erfgenaam zijn! ");
INSERT INTO nld_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","En ziet, het woord des HEEREN was tot hem, zeggende: Deze zal uw erfgenaam niet zijn; maar die uit uw lijf voortkomen zal, die zal uw erfgenaam zijn. ");
INSERT INTO nld_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Toen leidde Hij hem uit naar buiten, en zeide: Zie nu op naar den hemel, en tel de sterren, indien gij ze tellen kunt; en Hij zeide tot hem: Zo zal uw zaad zijn! ");
INSERT INTO nld_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","En hij geloofde in den HEERE; en Hij rekende het hem tot gerechtigheid. ");
INSERT INTO nld_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Voorts zeide Hij tot hem: Ik ben de HEERE, Die u uitgeleid heb uit Ur der Chaldeen, om u dit land te geven, om dat erfelijk te bezitten. ");
INSERT INTO nld_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","En hij zeide: Heere, HEERE! waarbij zal ik weten, dat ik het erfelijk bezitten zal? ");
INSERT INTO nld_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","En Hij zeide tot hem: Neem Mij een driejarige vaars, en een driejarige geit, en een driejarigen ram, en een tortelduif, en een jonge duif. ");
INSERT INTO nld_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","En hij bracht Hem deze alle, en hij deelde ze middendoor, en hij leide elks deel tegen het andere over; maar het gevogelte deelde hij niet. ");
INSERT INTO nld_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","En het wild gevogelte kwam neder op het aas; maar Abram joeg het weg. ");
INSERT INTO nld_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","En het geschiedde, als de zon was aan het ondergaan, zo viel een diepe slaap op Abram; en ziet, een schrik, en grote duisternis viel op hem. ");
INSERT INTO nld_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Toen zeide Hij tot Abram: Weet voorzeker, dat uw zaad vreemd zal zijn in een land, dat het hunne niet is, en zij zullen hen dienen, en zij zullen hen verdrukken vierhonderd jaren. ");
INSERT INTO nld_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Doch Ik zal het volk ook rechten, hetwelk zij zullen dienen; en daarna zullen zij uittrekken met grote have. ");
INSERT INTO nld_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","En gij zult tot uw vaderen gaan met vrede; gij zult in goeden ouderdom begraven worden. ");
INSERT INTO nld_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","En het vierde geslacht zal herwaarts wederkeren; want de ongerechtigheid der Amorieten is tot nog toe niet volkomen. ");
INSERT INTO nld_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","En het geschiedde, dat de zon onderging en het duister werd, en ziet, daar was een rokende oven en vurige fakkel, die tussen die stukken doorging. ");
INSERT INTO nld_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ten zelfden dage maakte de HEERE een verbond met Abram, zeggende: Aan uw zaad heb Ik dit land gegeven, van de rivier van Egypte af, tot aan die grote rivier, de rivier Frath: ");
INSERT INTO nld_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Den Keniet, en den Keniziet, en den Kadmoniet, ");
INSERT INTO nld_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","En den Hethiet, en den Fereziet, en de Refaieten, ");
INSERT INTO nld_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","En den Amoriet, en den Kanaaniet, en den Girgaziet, en den Jebusiet. ");
INSERT INTO nld_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Doch Sarai, Abrams huisvrouw, baarde hem niet; en zij had een Egyptische dienstmaagd, welker naam was Hagar. ");
INSERT INTO nld_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Zo zeide Sarai tot Abram: Zie toch, de HEERE heeft mij toegesloten, dat ik niet bare; ga toch in tot mijn dienstmaagd, misschien zal ik uit haar gebouwd worden. En Abram hoorde naar de stem van Sarai. ");
INSERT INTO nld_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Zo nam Sarai, Abrams huisvrouw, de Egyptische Hagar, haar dienstmaagd, ten einde van tien jaren, welke Abram in het land Kanaan gewoond had, en zij gaf haar aan Abram, haar man, hem tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","En hij ging in tot Hagar, en zij ontving. Als zij nu zag, dat zij ontvangen had, zo werd haar vrouw veracht in haar ogen. ");
INSERT INTO nld_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Toen zeide Sarai tot Abram: Mijn ongelijk is op u; ik heb mijn dienstmaagd in uw schoot gegeven; nu zij ziet, dat zij ontvangen heeft, zo ben ik veracht in haar ogen; de HEERE rechte tussen mij en tussen u! ");
INSERT INTO nld_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","En Abram zeide tot Sarai: Zie uw dienstmaagd is in uw hand; doe haar, wat goed is in uw ogen. En Sarai vernederde haar, en zij vluchtte van haar aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","En de Engel des HEEREN vond haar aan een waterfontein in de woestijn, aan de fontein op den weg van Sur. ");
INSERT INTO nld_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","En hij zeide: Hagar, gij, dienstmaagd van Sarai! van waar komt gij, en waar zult gij heengaan? En zij zeide: Ik ben vluchtende van het aangezicht mijner vrouw Sarai! ");
INSERT INTO nld_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Toen zeide de Engel des HEEREN tot haar: Keer weder tot uw vrouw, en verneder u onder haar handen. ");
INSERT INTO nld_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Voorts zeide de Engel des HEEREN tot haar: Ik zal uw zaad grotelijks vermenigvuldigen, zodat het vanwege de menigte niet zal geteld worden. ");
INSERT INTO nld_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ook zeide des HEEREN Engel tot haar: Zie, gij zijt zwanger, en zult een zoon baren, en gij zult zijn naam Ismael noemen, omdat de HEERE uw verdrukking aangehoord heeft. ");
INSERT INTO nld_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","En hij zal een woudezel van een mens zijn; zijn hand zal tegen allen zijn, en de hand van allen tegen hem; en hij zal wonen voor het aangezicht van al zijn broederen. ");
INSERT INTO nld_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","En zij noemde den Naam des HEEREN, Die tot haar sprak: Gij, God des aanziens! want zij zeide: Heb ik ook hier gezien naar Dien, Die mij aanziet? ");
INSERT INTO nld_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Daarom noemde men dien put, den put Lachai-Roi; ziet, hij is tussen Kades en tussen Bered. ");
INSERT INTO nld_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","En Hagar baarde Abram een zoon; en Abram noemde den naam zijns zoons, die Hagar gebaard had, Ismael. ");
INSERT INTO nld_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","En Abram was zes en tachtig jaren oud, toen Hagar Ismael aan Abram baarde. ");
INSERT INTO nld_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Als nu Abram negen en negentig jaren oud was, zo verscheen de HEERE aan Abram, en zeide tot hem: Ik ben God, de Almachtige! Wandel voor Mijn aangezicht, en zijt oprecht! ");
INSERT INTO nld_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","En Ik zal Mijn verbond stellen tussen Mij en tussen u, en Ik zal u gans zeer vermenigvuldigen. ");
INSERT INTO nld_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Toen viel Abram op zijn aangezicht, en God sprak met hem, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Mij aangaande, zie, Mijn verbond is met u; en gij zult tot een vader van menigte der volken worden! ");
INSERT INTO nld_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","En uw naam zal niet meer genoemd worden Abram; maar uw naam zal wezen Abraham; want Ik heb u gesteld tot een vader van menigte der volken. ");
INSERT INTO nld_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","En Ik zal u gans zeer vruchtbaar maken, en Ik zal u tot volken stellen, en koningen zullen uit u voortkomen. ");
INSERT INTO nld_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","En Ik zal Mijn verbond oprichten tussen Mij en tussen u, en tussen uw zaad na u in hun geslachten, tot een eeuwig verbond, om u te zijn tot een God, en uw zaad na u. ");
INSERT INTO nld_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","En Ik zal u, en uw zaad na u, het land uwer vreemdelingschappen geven, het gehele land Kanaan, tot eeuwige bezitting; en Ik zal hun tot een God zijn. ");
INSERT INTO nld_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Voorts zeide God tot Abraham: Gij nu zult Mijn verbond houden, gij, en uw zaad na u, in hun geslachten. ");
INSERT INTO nld_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dit is Mijn verbond, dat gijlieden houden zult tussen Mij, en tussen u, en tussen uw zaad na u: dat al wat mannelijk is, u besneden worde. ");
INSERT INTO nld_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","En gij zult het vlees uwer voorhuid besnijden; en dat zal tot een teken zijn van het verbond tussen Mij en tussen u. ");
INSERT INTO nld_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Een zoontje dan van acht dagen zal u besneden worden, al wat mannelijk is in uw geslachten: de ingeborene van het huis, en de gekochte met geld van allen vreemde, welke niet is van uw zaad; ");
INSERT INTO nld_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","De ingeborene van uw huis, en de gekochte met uw geld zal zekerlijk besneden worden; en Mijn verbond zal zijn in ulieder vlees, tot een eeuwig verbond. ");
INSERT INTO nld_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","En wat mannelijk is, de voorhuid hebbende, wiens voorhuids vlees niet zal besneden worden, dezelve ziel zal uit haar volken uitgeroeid worden; hij heeft Mijn verbond gebroken. ");
INSERT INTO nld_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nog zeide God tot Abraham: Gij zult den naam van uw huisvrouw Sarai, niet Sarai noemen; maar haar naam zal zijn Sara. ");
INSERT INTO nld_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Want Ik zal haar zegenen, en u ook uit haar een zoon geven; ja, Ik zal haar zegenen, zodat zij tot volken worden zal: koningen der volken zullen uit haar worden! ");
INSERT INTO nld_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Toen viel Abraham op zijn aangezicht, en hij lachte; en hij zeide in zijn hart: Zal een, die honderd jaren oud is, een kind geboren worden; en zal Sara, die negentig jaren oud is, baren? ");
INSERT INTO nld_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","En Abraham zeide tot God: Och, dat Ismael mocht leven voor Uw aangezicht! ");
INSERT INTO nld_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","En God zeide: Voorwaar, Sara, uw huisvrouw, zal u een zoon baren, en gij zult zijn naam noemen Izak; en Ik zal Mijn verbond met hem oprichten, tot een eeuwig verbond zijn zade na hem. ");
INSERT INTO nld_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","En aangaande Ismael heb Ik u verhoord; zie, Ik heb hem gezegend, en zal hem vruchtbaar maken, en hem gans zeer vermenigvuldigen; twaalf vorsten zal hij gewinnen, en Ik zal hem tot een groot volk stellen; ");
INSERT INTO nld_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maar Mijn verbond zal Ik met Izak oprichten, die u Sara op dezen gezetten tijd in het andere jaar baren zal. ");
INSERT INTO nld_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","En Hij eindigde met hem te spreken, en God voer op van Abraham. ");
INSERT INTO nld_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Toen nam Abraham zijn zoon Ismael, en al de ingeborenen van zijn huis, en alle gekochten met zijn geld, al wat mannelijk was onder de lieden van het huis van Abraham, en hij besneed het vlees hunner voorhuid, even ten zelfden dage, gelijk als God met hem gesproken had. ");
INSERT INTO nld_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","En Abraham was oud negen en negentig jaren, als hem het vlees zijner voorhuid besneden werd. ");
INSERT INTO nld_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","En Ismael, zijn zoon, was dertien jaren oud, als hem het vlees zijner voorhuid besneden werd. ");
INSERT INTO nld_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Even op dezen zelfden dag werd Abraham besneden, en Ismael, zijn zoon. ");
INSERT INTO nld_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","En alle mannen van zijn huis, de ingeborenen des huizes, en de gekochten met geld, van den vreemde af, werden met hem besneden. ");
INSERT INTO nld_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Daarna verscheen hem de HEERE aan de eikenbossen van Mamre, als hij in de deur der tent zat, toen de dag heet werd. ");
INSERT INTO nld_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","En hij hief zijn ogen op en zag; en ziet, daar stonden drie mannen tegenover hem; als hij hen zag, zo liep hij hun tegemoet van de deur der tent, en boog zich ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","En hij zeide: Heere! heb ik nu genade gevonden in Uw ogen, zo gaat toch niet aan Uw knecht voorbij. ");
INSERT INTO nld_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Dat toch een weinig waters gebracht worde, en wast Uw voeten, en leunt onder dezen boom. ");
INSERT INTO nld_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","En ik zal een bete broods langen, dat Gij Uw hart sterkt; daarna zult Gij voortgaan, daarom omdat Gij tot Uw knecht overgekomen zijt. En zij zeiden: Doe zo als gij gesproken hebt. ");
INSERT INTO nld_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","En Abraham haastte zich naar de tent tot Sara, en hij zeide: Haast u; kneed drie maten meelbloem, en maak koeken. ");
INSERT INTO nld_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","En Abraham liep tot de runderen, en hij nam een kalf, teder en goed, en hij gaf het aan den knecht, die haastte, om dat toe te maken. ");
INSERT INTO nld_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","En hij nam boter en melk, en het kalf, dat hij toegemaakt had, en hij zette het hun voor, en stond bij hen onder dien boom, en zij aten. ");
INSERT INTO nld_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Toen zeiden zij tot hem: Waar is Sara, uw huisvrouw? En hij zeide: Ziet, in de tent. ");
INSERT INTO nld_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","En Hij zeide: Ik zal voorzeker weder tot u komen, omtrent dezen tijd des levens; en zie, Sara, uw huisvrouw, zal een zoon hebben! En Sara hoorde het aan de deur der tent, welke achter Hem was. ");
INSERT INTO nld_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham nu en Sara waren oud, en wel bedaagd; het had Sara opgehouden te gaan naar de wijze der vrouwen. ");
INSERT INTO nld_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Zo lachte Sara bij zichzelve, zeggende: Zal ik wellust hebben, nadat ik oud geworden ben, en mijn heer oud is? ");
INSERT INTO nld_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","En de HEERE zeide tot Abraham: Waarom heeft Sara gelachen, zeggende: Zou ik ook waarlijk baren, nu ik oud geworden ben? ");
INSERT INTO nld_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Zou iets voor den HEERE te wonderlijk zijn? Ter gezetter tijd zal Ik tot u wederkomen, omtrent dezen tijd des levens, en Sara zal een zoon hebben! ");
INSERT INTO nld_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","En Sara loochende het, zeggende: Ik heb niet gelachen; want zij vreesde. En Hij zeide: Neen! maar gij hebt gelachen. ");
INSERT INTO nld_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Toen stonden die mannen op van daar, en zagen naar Sodom toe; en Abraham ging met hen, om hen te geleiden. ");
INSERT INTO nld_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","En de HEERE zeide: Zal Ik voor Abraham verbergen, wat Ik doe? ");
INSERT INTO nld_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Dewijl Abraham gewisselijk tot een groot en machtig volk worden zal, en alle volken der aarde in hem gezegend zullen worden? ");
INSERT INTO nld_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Want Ik heb hem gekend, opdat hij zijn kinderen en zijn huis na hem zoude bevelen, en zij den weg des HEEREN houden, om te doen gerechtigheid en gerichte; opdat de HEERE over Abraham brenge, hetgeen Hij over hem gesproken heeft. ");
INSERT INTO nld_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Voorts zeide de HEERE: Dewijl het geroep van Sodom en Gomorra groot is, en dewijl haar zonde zeer zwaar is, ");
INSERT INTO nld_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Zal Ik nu afgaan en bezien, of zij naar hun geroep, dat tot Mij gekomen is, het uiterste gedaan hebben, en zo niet, Ik zal het weten. ");
INSERT INTO nld_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Toen keerden die mannen het aangezicht van daar, en gingen naar Sodom; maar Abraham bleef nog staande voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","En Abraham trad toe, en zeide: Zult Gij ook den rechtvaardige met den goddeloze ombrengen? ");
INSERT INTO nld_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Misschien zijn er vijftig rechtvaardigen in de stad; zult Gij hen ook ombrengen, en de plaats niet sparen, om de vijftig rechtvaardigen, die binnen haar zijn? ");
INSERT INTO nld_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Het zij verre van U, zulk een ding te doen, te doden den rechtvaardige met den goddeloze! dat de rechtvaardige zij gelijk de goddeloze, verre zij het van U! zou de Rechter der ganse aarde geen recht doen? ");
INSERT INTO nld_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Toen zeide de HEERE: Zo Ik te Sodom binnen de stad vijftig rechtvaardigen zal vinden, zo zal Ik de ganse plaats sparen om hunnentwil. ");
INSERT INTO nld_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","En Abraham antwoordde en zeide: Zie toch; ik heb mij onderwonden te spreken tot den Heere, hoewel ik stof en as ben! ");
INSERT INTO nld_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Misschien zullen aan de vijftig rechtvaardigen vijf ontbreken; zult Gij dan om vijf de ganse stad verderven? En Hij zeide: Ik zal haar niet verderven, zo Ik er vijf en veertig zal vinden. ");
INSERT INTO nld_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","En hij voer voort nog tot Hem te spreken, en zeide: Misschien zullen aldaar veertig gevonden worden! En Hij zeide: Ik zal het niet doen om der veertigen wil. ");
INSERT INTO nld_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Voorts zeide hij: Dat toch de Heere niet ontsteke, dat ik spreke; misschien zullen aldaar dertig gevonden worden! En Hij zeide: Ik zal het niet doen, zo Ik aldaar dertig zal vinden. ");
INSERT INTO nld_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","En hij zeide: Zie toch, ik heb mij onderwonden te spreken tot de Heere; misschien zullen er twintig gevonden worden! En Hij zeide: Ik zal haar niet verderven om der twintigen wil. ");
INSERT INTO nld_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Nog zeide hij: Dat toch de Heere niet ontsteke, dat ik alleenlijk ditmaal spreke: misschien zullen er tien gevonden worden. En Hij zeide: Ik zal haar niet verderven om der tienen wil. ");
INSERT INTO nld_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Toen ging de HEERE weg, als Hij geeindigd had tot Abraham te spreken; en Abraham keerde weder naar zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","En die twee engelen kwamen te Sodom in den avond; en Lot zat in de poort te Sodom; en als Lot hen zag, stond hij op hun tegemoet, en boog zich met het aangezicht ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","En hij zeide: Ziet nu, mijne heren! keert toch in ten huize van uw knecht, en vernacht, en wast uw voeten; en gij zult vroeg opstaan, en gaan uws weegs. En zij zeiden: Neen, maar wij zullen op de straat vernachten. ");
INSERT INTO nld_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","En hij hield bij hen zeer aan, zodat zij tot hem inkeerden, en kwamen in zijn huis; en hij maakte hun een maaltijd, en bakte ongezuurde koeken, en zij aten. ");
INSERT INTO nld_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Eer zij zich te slapen leiden, zo hebben de mannen dier stad, de mannen van Sodom, van den jongste tot den oudste toe, dat huis omsingeld, het ganse volk, van het uiterste einde af. ");
INSERT INTO nld_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","En zij riepen Lot toe, en zeiden tot hem: Waar zijn die mannen, die deze nacht tot u gekomen zijn? breng hen uit tot ons, opdat wij ze bekennen. ");
INSERT INTO nld_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Toen ging Lot uit tot hen aan de deur, en hij sloot de deur achter zich toe; ");
INSERT INTO nld_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","En hij zeide: Mijn broeders! doet toch geen kwaad! ");
INSERT INTO nld_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ziet toch, ik heb twee dochters, die geen man bekend hebben; ik zal haar nu tot u uitbrengen, en doet haar, zoals het goed is in uw ogen; alleenlijk doet dezen mannen niets; want daarom zijn zij onder de schaduw mijns daks ingegaan. ");
INSERT INTO nld_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Toen zeiden zij: Kom verder aan! Voorts zeiden zij: Deze ene is gekomen, om als vreemdeling hier te wonen, en zoude hij alleszins rechter zijn? Nu zullen wij u meer kwaads doen, dan hun. En zij drongen zeer op den man, op Lot, en zij traden toe om de deur open te breken. ");
INSERT INTO nld_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Doch die mannen staken hun hand uit, en deden Lot tot zich inkomen in het huis, en sloten de deur toe. ");
INSERT INTO nld_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","En zij sloegen de mannen, die aan de deur van het huis waren, met verblindheden, van den kleinste tot aan den grootste, zodat zij moede werden, om de deur te vinden. ");
INSERT INTO nld_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Toen zeiden die mannen tot Lot: Wien hebt gij hier nog meer? een schoonzoon, of uw zonen, of uw dochteren, en allen, die gij hebt in deze stad, breng uit deze plaats; ");
INSERT INTO nld_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Want wij gaan deze plaats verderven, omdat haar geroep groot geworden is voor het aangezicht des HEEREN, en de HEERE ons uitgezonden heeft, om haar te verderven. ");
INSERT INTO nld_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Toen ging Lot uit, en sprak tot zijn schoonzonen, die zijn dochteren nemen zouden, en zeide: Maakt u op, gaat uit deze plaats; want de HEERE gaat deze stad verderven. Maar hij was in de ogen zijner schoonzonen als jokkende. ");
INSERT INTO nld_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","En als de dageraad opging, drongen de engelen Lot aan, zeggende: Maak u op, neem uw huisvrouw, en uw twee dochteren, die voorhanden zijn, opdat gij in de ongerechtigheid dezer stad niet omkomt. ");
INSERT INTO nld_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Maar hij vertoefde; zo grepen dan die mannen zijn hand, en de hand zijner vrouw, en de hand zijner twee dochteren, om de verschoning des HEEREN over hem; en zij brachten hem uit, en stelden hem buiten de stad. ");
INSERT INTO nld_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","En het geschiedde als zij hen uitgebracht hadden naar buiten, zo zeide Hij: behoud u om uws levens wil; zie niet achter u om, en sta niet op deze ganse vlakte; behoud u naar het gebergte heen, opdat gij niet omkomt. ");
INSERT INTO nld_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","En Lot zeide tot hen: Neen toch, Heere! ");
INSERT INTO nld_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Zie toch, Uw knecht heeft genade gevonden in Uw ogen, en Gij hebt Uw weldadigheid groot gemaakt, die Gij aan mij gedaan hebt, om mijn ziel te behouden bij het leven; maar ik zal niet kunnen behouden worden naar het gebergte heen, opdat mij niet misschien dat kwaad aankleve, en ik sterve! ");
INSERT INTO nld_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ziet toch, deze stad is nabij, om derwaarts te vluchten, en zij is klein; laat mij toch derwaarts behouden worden (is zij niet klein?) opdat mijn ziel leve. ");
INSERT INTO nld_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","En Hij zeide tot hem: Zie, Ik heb uw aangezicht opgenomen ook in deze zaak, dat Ik deze stad niet omkere waarvan gij gesproken hebt. ");
INSERT INTO nld_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haast, behoud u derwaarts; want Ik zal niets kunnen doen, totdat gij daarhenen ingekomen zijt. Daarom noemde men den naam dezer stad Zoar. ");
INSERT INTO nld_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","De zon ging op boven de aarde, als Lot te Zoar inkwam. ");
INSERT INTO nld_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Toen deed de HEERE zwavel en vuur over Sodom en Gomorra regenen, van den HEERE uit den hemel. ");
INSERT INTO nld_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","En Hij keerde deze steden om, en die ganse vlakte, en alle inwoners dezer steden, ook het gewas des lands. ");
INSERT INTO nld_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","En zijn huisvrouw zag om van achter hem; en zij werd een zoutpilaar. ");
INSERT INTO nld_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","En Abraham maakte zich deszelven morgens vroeg op, naar de plaats, waar hij voor het aangezicht des HEEREN gestaan had. ");
INSERT INTO nld_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","En hij zag naar Sodom en Gomorra toe, en naar het ganse land van die vlakte; en hij zag, en ziet, er ging een rook van het land op, gelijk de rook eens ovens. ");
INSERT INTO nld_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","En het geschiedde, toen God de steden dezer vlakte verdierf, dat God aan Abraham gedacht, en Hij leidde Lot uit het midden dezer omkering, in het omkeren dier steden, in welke Lot gewoond had. ");
INSERT INTO nld_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","En Lot toog op uit Zoar, en woonde op den berg, en zijn twee dochters met hem; want hij vreesde binnen Zoar te wonen. En hij woonde in een spelonk, hij en zijn twee dochters. ");
INSERT INTO nld_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Toen zeide de eerstgeborene tot de jongste: Onze vader is oud, en er is geen man in dit land, om tot ons in te gaan, naar de wijze der ganse aarde. ");
INSERT INTO nld_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, laat ons onze vader wijn te drinken geven, en bij hem liggen, opdat wij van onze vader zaad in het leven behouden. ");
INSERT INTO nld_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","En zij gaven dien nacht haar vader wijn te drinken; en de eerstgeborene kwam, en lag bij haar vader, en hij werd het niet gewaar in haar nederliggen, noch in haar opstaan. ");
INSERT INTO nld_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","En het geschiedde des anderen daags, dat de eerstgeborene zeide tot de jongste: Zie, ik heb gisteren nacht bij mijn vader gelegen; laat ons ook dezen nacht hem wijn te drinken geven; ga dan in, lig bij hem, opdat wij van onzen vader zaad in het leven behouden. ");
INSERT INTO nld_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","En zij gaven haar vader ook dien nacht wijn te drinken, en de jongste stond op, en lag bij hem. En hij werd het niet gewaar in haar nederliggen, noch in haar opstaan. ");
INSERT INTO nld_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","En de twee dochters van Lot werden bevrucht van haar vader. ");
INSERT INTO nld_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","En de eerstgeborene baarde een zoon, en noemde zijn naam Moab; deze is de vader der Moabieten, tot op dezen dag. ");
INSERT INTO nld_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","En de jongste baarde ook een zoon, en noemde zijn naam Ben-Ammi; deze is de vader der kinderen Ammons, tot op dezen dag. ");
INSERT INTO nld_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","En Abraham reisde van daar naar het land van het zuiden, en woonde tussen Kades en tussen Sur; en hij verkeerde als vreemdeling te Gerar. ");
INSERT INTO nld_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Als nu Abraham van Sara, zijn huisvrouw, gezegd had: Zij is mijn zuster, zo zond Abimelech, de koning van Gerar, en nam Sara weg. ");
INSERT INTO nld_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Maar God kwam tot Abimelech in een droom des nachts, en Hij zeide tot hem: Zie, gij zijt dood om der vrouwe wil, die gij weggenomen hebt; want zij is met een man getrouwd. ");
INSERT INTO nld_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Doch Abimelech was tot haar niet genaderd; daarom zeide hij: Heere! zult Gij dan ook een rechtvaardig volk doden? ");
INSERT INTO nld_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Heeft hij zelf mij niet gezegd: Zij is mijn zuster? en zij, ook zij heeft gezegd: Hij is mijn broeder. In oprechtheid mijns harten en in reinheid mijner handen, heb ik dit gedaan. ");
INSERT INTO nld_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","En God zeide tot hem in den droom: Ik heb ook geweten, dat gij dit in oprechtheid uws harten gedaan hebt, en Ik heb u ook belet van tegen Mij te zondigen; daarom heb Ik u niet toegelaten, haar aan te roeren. ");
INSERT INTO nld_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Zo geef dan nu dezes mans huisvrouw weder; want hij is een profeet, en hij zal voor u bidden, opdat gij leeft; maar zo gij haar niet wedergeeft, weet, dat gij voorzeker sterven zult, gij, en al wat uwes is! ");
INSERT INTO nld_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Toen stond Abimelech des morgens vroeg op, en riep al zijn knechten, en sprak al deze woorden voor hun oren. En die mannen vreesden zeer. ");
INSERT INTO nld_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","En Abimelech riep Abraham, en zeide tot hem: Wat hebt gij ons gedaan? en wat heb ik tegen u gezondigd, dat gij over mij en over mijn koninkrijk een grote zonde gebracht hebt? gij hebt daden met mij gedaan, die niet zouden gedaan worden. ");
INSERT INTO nld_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Voorts zeide Abimelech tot Abraham: Wat hebt gij gezien, dat gij deze zaak gedaan hebt? ");
INSERT INTO nld_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","En Abraham zeide: Want ik dacht: alleen is de vreze Gods in deze plaats niet, zodat zij mij om mijner huisvrouw wil zullen doden. ");
INSERT INTO nld_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","En ook is zij waarlijk mijn zuster; zij is mijns vaders dochter, maar niet mijner moeder dochter; en zij is mij ter vrouwe geworden. ");
INSERT INTO nld_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","En het is geschied, als God mij uit mijns vaders huis deed dwalen, zo sprak ik tot haar: Dit zij uw weldadigheid, die gij bij mij doen zult; aan alle plaatsen waar wij komen zullen, zeg van mij: Hij is mijn broeder! ");
INSERT INTO nld_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Toen nam Abimelech schapen en runderen, ook dienstknechten en dienstmaagden, en gaf dezelve aan Abraham; en hij gaf hem Sara zijn huisvrouw weder. ");
INSERT INTO nld_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","En Abimelech zeide: Zie, mijn land is voor uw aangezicht; woon, waar het goed is in uw ogen. ");
INSERT INTO nld_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","En tot Sara zeide hij: Zie, ik heb uw broeder duizend zilverlingen gegeven; zie, hij zij u een deksel der ogen, allen, die met u zijn, ja, bij allen, en wees geleerd. ");
INSERT INTO nld_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","En Abraham bad tot God; en God genas Abimelech, en zijn huisvrouw, en zijn dienstmaagden, zodat zij baarden. ");
INSERT INTO nld_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Want de HEERE had al de baarmoeders van het huis van Abimelech ganselijk toegesloten, ter oorzake van Sara, Abrahams huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","En de HEERE bezocht Sara, gelijk als Hij gezegd had; en de HEERE deed aan Sara, gelijk als Hij gesproken had. ");
INSERT INTO nld_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","En Sara werd bevrucht, en baarde Abraham een zoon in zijn ouderdom, ter gezetter tijd, dien hem God gezegd had. ");
INSERT INTO nld_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","En Abraham noemde den naam zijns zoons, die hem geboren was, dien hem Sara gebaard had, Izak. ");
INSERT INTO nld_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","En Abraham besneed zijn zoon Izak, zijnde acht dagen oud, gelijk als hem God geboden had. ");
INSERT INTO nld_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","En Abraham was honderd jaren oud, als hem Izak zijn zoon geboren werd. ");
INSERT INTO nld_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","En Sara zeide: God heeft mij een lachen gemaakt; al die het hoort, zal met mij lachen. ");
INSERT INTO nld_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Voorts zeide zij: Wie zou Abraham gezegd hebben: Sara heeft zonen gezoogd? want ik heb een zoon gebaard in zijn ouderdom. ");
INSERT INTO nld_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","En het kind werd groot, en werd gespeend; toen maakte Abraham een groten maaltijd op den dag, als Izak gespeend werd. ");
INSERT INTO nld_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","En Sara zag den zoon van Hagar, de Egyptische, dien zij Abraham gebaard had, spottende. ");
INSERT INTO nld_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","En zij zeide tot Abraham: Drijf deze dienstmaagd en haar zoon uit; want de zoon dezer dienstmaagd zal met mijn zoon, met Izak, niet erven. ");
INSERT INTO nld_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","En dit woord was zeer kwaad in Abrahams ogen, ter oorzake van zijn zoon. ");
INSERT INTO nld_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maar God zeide tot Abraham: Laat het niet kwaad zijn in uw ogen, over den jongen, en over uw dienstmaagd; al wat Sara tot u zal zeggen, hoor naar haar stem; want in Izak zal uw zaad genoemd worden. ");
INSERT INTO nld_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Doch Ik zal ook den zoon dezer dienstmaagd tot een volk stellen, omdat hij uw zaad is. ");
INSERT INTO nld_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Toen stond Abraham des morgens vroeg op, en nam brood, en een fles water, en gaf ze aan Hagar, die leggende op haar schouder; ook gaf hij haar het kind, en zond haar weg. En zij ging voort, en dwaalde in de woestijn Ber-seba. ");
INSERT INTO nld_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Als nu het water van de fles uit was, zo wierp zij het kind onder een van de struiken. ");
INSERT INTO nld_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","En zij ging en zette zich tegenover, afgaande zo verre, als die met den boog schieten; want zij zeide: Dat ik het kind niet zie sterven; en zij zat tegenover, en hief haar stem op, en weende. ");
INSERT INTO nld_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","En God hoorde de stem van den jongen; en de Engel Gods riep Hagar toe uit den hemel, en zeide tot haar: Wat is u, Hagar? Vrees niet; want God heeft naar des jongens stem gehoord, ter plaatse, waar hij is. ");
INSERT INTO nld_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Sta op, hef den jongen op, en houd hem vast met uwe hand; want Ik zal hem tot een groot volk stellen. ");
INSERT INTO nld_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","En God opende haar ogen, dat zij een waterput zag; en zij ging, en vulde de fles met water, en gaf den jongen te drinken. ");
INSERT INTO nld_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","En God was met den jongen; en hij werd groot, en hij woonde in de woestijn, en werd een boogschutter. ");
INSERT INTO nld_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","En hij woonde in de woestijn Paran; en zijn moeder nam hem een vrouw uit Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Voorts geschiedde het ter zelfder tijd, dat Abimelech, mitsgaders Pichol, zijn krijgsoverste, tot Abraham sprak, zeggende: God is met u in alles, wat gij doet. ");
INSERT INTO nld_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Zo zweer mij nu hier bij God: Zo gij mij, of mijn zoon, of mijn neef liegen zult! naar de weldadigheid, die ik bij u gedaan heb, zult gij doen bij mij, en bij het land, waarin gij als vreemdeling verkeert. ");
INSERT INTO nld_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","En Abraham zeide: Ik zal zweren. ");
INSERT INTO nld_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","En Abraham berispte Abimelech ter oorzake van een waterput, die Abimelechs knechten met geweld genomen hadden. ");
INSERT INTO nld_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Toen zeide Abimelech: Ik heb niet geweten, wie dit stuk gedaan heeft; en ook hebt gij het mij niet aangezegd, en ik heb er ook niet van gehoord, dan heden. ");
INSERT INTO nld_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","En Abraham nam schapen en runderen, en gaf die aan Abimelech; en die beiden maakten een verbond. ");
INSERT INTO nld_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Doch Abraham stelde zeven ooilammeren der kudde bijzonder. ");
INSERT INTO nld_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Zo zeide Abimelech tot Abraham: Wat zullen hier deze zeven ooilammeren, die gij bijzonder gesteld hebt? ");
INSERT INTO nld_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","En hij zeide: Dat gij de zeven ooilammeren van mijn hand nemen zult, opdat het mij tot een getuigenis zij, dat ik dezen put gegraven heb. ");
INSERT INTO nld_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daarom noemde men die plaats Ber-seba, omdat die beiden daar gezworen hadden. ");
INSERT INTO nld_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Alzo maakten zij een verbond te Ber-seba. Daarna stond Abimelech op, en Pichol, zijn krijgsoverste, en zij keerden wederom naar het land der Filistijnen. ");
INSERT INTO nld_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","En hij plantte een bos in Ber-seba, en riep aldaar den Naam des HEEREN, des eeuwigen Gods, aan. ");
INSERT INTO nld_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","En Abraham woonde als vreemdeling vele dagen in het land der Filistijnen. ");
INSERT INTO nld_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","En het geschiedde na deze dingen, dat God Abraham verzocht; en Hij zeide tot hem: Abraham! En hij zeide: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","En Hij zeide: Neem nu uw zoon, uw enige, dien gij liefhebt, Izak, en ga heen naar het land Moria, en offer hem aldaar tot een brandoffer, op een van de bergen, dien Ik u zeggen zal. ");
INSERT INTO nld_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Toen stond Abraham des morgens vroeg op, en zadelde zijn ezel, en nam twee van zijn jongeren met zich, en Izak zijn zoon; en hij kloofde hout tot het brandoffer, en maakte zich op, en ging naar de plaats, die God hem gezegd had. ");
INSERT INTO nld_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Aan den derden dag, toen hief Abraham zijn ogen op, en zag die plaats van verre. ");
INSERT INTO nld_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","En Abraham zeide tot zijn jongeren: Blijft gij hier met den ezel, en ik en de jongen zullen heengaan tot daar; als wij aangebeden zullen hebben, dan zullen wij tot u wederkeren. ");
INSERT INTO nld_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","En Abraham nam het hout des brandoffers, en legde het op Izak, zijn zoon; en hij nam het vuur en het mes in zijn hand, en zij beiden gingen samen. ");
INSERT INTO nld_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Toen sprak Izak tot Abraham, zijn vader, en zeide: Mijn vader! En hij zeide: Zie, hier ben ik, mijn zoon! En hij zeide: Zie het vuur en het hout; maar waar is het lam tot het brandoffer? ");
INSERT INTO nld_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","En Abraham zeide: God zal Zichzelven een lam ten brandoffer voorzien, mijn zoon! Zo gingen zij beiden samen. ");
INSERT INTO nld_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","En zij kwamen ter plaatse, die hem God gezegd had; en Abraham bouwde aldaar een altaar, en hij schikte het hout, en bond zijn zoon Izak, en leide hem op het altaar boven op het hout. ");
INSERT INTO nld_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","En Abraham strekte zijn hand uit, en nam het mes om zijn zoon te slachten. ");
INSERT INTO nld_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Maar de Engel des HEEREN riep tot hem van den hemel, en zeide: Abraham, Abraham! En hij zeide: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Toen zeide Hij: Strek uw hand niet uit aan den jongen, en doe hem niets! want nu weet Ik, dat gij God vrezende zijt, en uw zoon, uw enige, van Mij niet hebt onthouden. ");
INSERT INTO nld_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Toen hief Abraham zijn ogen op, en zag om, en ziet, achter was een ram in de verwarde struiken vast met zijn hoornen; en Abraham ging, en nam dien ram, en offerde hem ten brandoffer in zijns zoons plaats. ");
INSERT INTO nld_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","En Abraham noemde den naam van die plaats: De HEERE zal het voorzien! Waarom heden ten dage gezegd wordt: Op den berg des HEEREN zal het voorzien worden! ");
INSERT INTO nld_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Toen riep de Engel des HEEREN tot Abraham ten tweeden male van den hemel; ");
INSERT INTO nld_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","En zeide: Ik zweer bij Mijzelven, spreekt de HEERE; daarom dat gij deze zaak gedaan hebt, en uw zoon, uw enige, niet onthouden hebt; ");
INSERT INTO nld_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Voorzeker zal Ik u grotelijks zegenen, en uw zaad zeer vermenigvuldigen, als de sterren des hemels, en als het zand, dat aan den oever der zee is; en uw zaad zal de poort zijner vijanden erfelijk bezitten. ");
INSERT INTO nld_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","En in uw zaad zullen gezegend worden alle volken der aarde, naardien gij Mijn stem gehoorzaam geweest zijt. ");
INSERT INTO nld_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Toen keerde Abraham weder tot zijn jongeren, en zij maakten zich op, en zij gingen samen naar Ber-seba; en Abraham woonde te Ber-seba. ");
INSERT INTO nld_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","En het geschiedde na deze dingen, dat men Abraham boodschapte, zeggende: Zie, Milka heeft ook Nahor, uw broeder, zonen gebaard: ");
INSERT INTO nld_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, zijn eerstgeborene, en Buz, zijn broeder, en Kemuel, den vader van Aram, ");
INSERT INTO nld_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","En Chesed, en Hazo, en Pildas, en Jidlaf, en Bethuel; ");
INSERT INTO nld_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(En Bethuel gewon Rebekka) deze acht baarde Milka aan Nahor, den broeder van Abraham. ");
INSERT INTO nld_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","En zijn bijwijf, welker naam was Reuma, diezelve baarde ook Tebah, en Gaham, en Tahas, en Maacha. ");
INSERT INTO nld_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","En het leven van Sara was honderd zeven en twintig jaren; dit waren de jaren des levens van Sara. ");
INSERT INTO nld_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","En Sara stierf te Kiriath-Arba, dat is Hebron, in het land Kanaan; en Abraham kwam om Sara te beklagen, en haar te bewenen. ");
INSERT INTO nld_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Daarna stond Abraham op van het aangezicht van zijner dode, en hij sprak tot de zonen Heths, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ik ben een vreemdeling en inwoner bij u; geeft mij een erfbegrafenis bij u, opdat ik mijn dode van voor mijn aangezicht begrave. ");
INSERT INTO nld_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","En de zonen Heths antwoordden Abraham, zeggende tot hem: ");
INSERT INTO nld_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Hoor ons, mijn heer! gij zijt een vorst Gods in het midden van ons; begraaf uw dode in de keure onzer graven; niemand van ons zal zijn graf voor u weren, dat gij uw dode niet zoudt begraven. ");
INSERT INTO nld_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Toen stond Abraham op, en boog zich neder voor het volk des lands, voor de zonen Heths; ");
INSERT INTO nld_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","En hij sprak met hen, zeggende: Is het met uw wil, dat ik mijn dode begrave van voor mijn aangezicht; zo hoort mij, en spreekt voor mij bij Efron, den zoon van Zohar, ");
INSERT INTO nld_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Dat hij mij geve de spelonk van Machpela, die hij heeft, die in het einde van zijn akker is, dat hij dezelve mij om het volle geld geve, tot een erfbegrafenis in het midden van u. ");
INSERT INTO nld_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron nu zat in het midden van de zonen Heths; en Efron de Hethiet antwoordde Abraham, voor de oren van de zonen Heths, van al degenen, die ter poorte zijner stad ingingen, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Neen, mijn heer! hoor mij; den akker geef ik u; ook de spelonk, die daarin is, die geef ik u; voor de ogen van de zonen mijns volks geef ik u die; begraaf uw dode. ");
INSERT INTO nld_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Toen boog zich Abraham neder voor het aangezicht van het volk des lands; ");
INSERT INTO nld_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","En hij sprak tot Efron, voor de oren van het volk des lands, zeggende: Trouwens, zijt gij het? lieve, hoor mij; ik zal het geld des akkers geven; neem het van mij, zo zal ik mijn dode aldaar begraven. ");
INSERT INTO nld_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","En Efron antwoordde Abraham, zeggende tot hem: ");
INSERT INTO nld_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mijn heer! hoor mij; een land van vierhonderd sikkelen zilvers, wat is dat tussen mij en tussen u? begraaf slechts uw dode. ");
INSERT INTO nld_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","En Abraham luisterde naar Efron; en Abraham woog Efron het geld, waarvan hij gesproken had voor de oren van de zonen Heths, vierhonderd sikkelen zilvers, onder den koopman gangbaar. ");
INSERT INTO nld_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Alzo werd de akker van Efron, die in Machpela was, dat tegenover Mamre lag, de akker en de spelonk, die daarin was, en al het geboomte, dat op den akker stond, dat rondom in zijn ganse landpale was gevestigd, ");
INSERT INTO nld_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aan Abraham tot een bezitting, voor de ogen van de zonen Heths, bij allen, die tot zijn stadspoort ingingen. ");
INSERT INTO nld_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","En daarna begroef Abraham zijn huisvrouw Sara in de spelonk des akkers van Machpela, tegenover Mamre, hetwelk is Hebron, in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Alzo werd die akker, en de spelonk die daarin was, aan Abraham gevestigd tot een erfbegrafenis van de zonen Heths. ");
INSERT INTO nld_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham nu was oud en wel bedaagd; en de HEERE had Abraham in alles gezegend. ");
INSERT INTO nld_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Zo sprak Abraham tot zijn knecht, den oudste van zijn huis, regerende over alles, wat hij had: Leg toch uw hand onder mijn heup, ");
INSERT INTO nld_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Opdat ik u doe zweren bij den HEERE, den God des hemels, en den God der aarde, dat gij voor mijn zoon geen vrouw nemen zult van de dochteren der Kanaanieten, in het midden van welke ik woon; ");
INSERT INTO nld_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Maar dat gij naar mijn land, en naar mijn maagschap trekken, en voor mijn zoon Izak een vrouw nemen zult. ");
INSERT INTO nld_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","En die knecht zeide tot hem: Misschien zal die vrouw mij niet willen volgen in dit land; zal ik dan uw zoon moeten wederbrengen in het land, waar gij uitgetogen zijt? ");
INSERT INTO nld_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","En Abraham zeide tot hem: Wacht u, dat gij mijn zoon niet weder daarheen brengt! ");
INSERT INTO nld_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","De HEERE, de God des hemels, Die mij uit mijns vaders huis en uit het land mijner maagschap genomen heeft, en Die tot mij gesproken heeft, en Die mij gezworen heeft, zeggende: Aan uw zaad zal Ik dit land geven! Die Zelf zal Zijn Engel voor uw aangezicht zenden, dat gij voor mijn zoon van daar een vrouw neemt. ");
INSERT INTO nld_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maar indien de vrouw u niet volgen wil, zo zult gij rein zijn van dezen mijn eed; alleenlijk breng mijn zoon daar niet weder heen. ");
INSERT INTO nld_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Toen legde de knecht zijn hand onder de heup van Abraham, zijn heer, en hij zwoer hem over deze zaak. ");
INSERT INTO nld_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","En die knecht nam tien kemelen van zijns heren kemelen, en toog heen; en al het goed zijns heren was in zijn hand; en hij maakte zich op, en toog heen naar Mesopotamie, naar de stad van Nahor. ");
INSERT INTO nld_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","En hij deed de kemelen nederknielen buiten de stad, bij een waterput, des avondtijds, ten tijde, als de putsters uitkwamen. ");
INSERT INTO nld_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","En hij zeide: HEERE! God van mijn heer Abraham! doe haar mij toch heden ontmoeten, en doe weldadigheid bij Abraham, mijn heer. ");
INSERT INTO nld_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Zie, ik sta bij de waterfontein, en de dochteren der mannen dezer stad zijn uitgaande om water te putten; ");
INSERT INTO nld_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Zo geschiede, dat die jonge dochter, tot welke ik zal zeggen: Neig toch uw kruik, dat ik drinke; en zij zal zeggen: Drink, en ik zal ook uw kemelen drenken; diezelve zij, die Gij Uw knecht Izak toegewezen hebt, en dat ik daaraan bekenne, dat Gij weldadigheid bij mijn heer gedaan hebt. ");
INSERT INTO nld_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","En het geschiedde, eer hij geeindigd had te spreken, ziet, zo kwam Rebekka uit, welke aan Bethuel geboren was, de zoon van Milka, de huisvrouw van Nahor, de broeder van Abraham; en zij had haar kruik op haar schouder. ");
INSERT INTO nld_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","En die jonge dochter was zeer schoon van aangezicht, een maagd, en geen man had haar bekend; en zij ging af naar de fontein, en vulde haar kruik, en ging op. ");
INSERT INTO nld_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Toen liep die knecht haar tegemoet, en hij zeide: Laat mij toch een weinig waters uit uw kruik drinken. ");
INSERT INTO nld_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","En zij zeide: Drink, mijn heer! en zij haastte zich en liet haar kruik neder op haar hand, en gaf hem te drinken. ");
INSERT INTO nld_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Als zij nu voleindigd had van hem drinken te geven, zeide zij: Ik zal ook voor uw kemelen putten, totdat zij voleindigd hebben te drinken. ");
INSERT INTO nld_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","En zij haastte zich, en goot haar kruik uit in de drinkbak, en liep weder naar den put om te putten, en zij putte voor al zijn kemelen. ");
INSERT INTO nld_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","En de man ontzette zich over haar, stilzwijgende, om te merken, of de HEERE zijn weg voorspoedig gemaakt had, of niet. ");
INSERT INTO nld_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","En het geschiedde, als de kemelen voleindigd hadden te drinken, dat die man een gouden voorhoofdsiersel nam, welks gewicht was een halve sikkel, en twee armringen aan haar handen, welker gewicht was tien sikkelen gouds. ");
INSERT INTO nld_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Want hij had gezegd: Wiens dochter zijt gij? geef het mij toch te kennen; is er ook ten huize uws vaders plaats voor ons, om te vernachten? ");
INSERT INTO nld_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","En zij had tot hem gezegd: Ik ben de dochter van Bethuel, den zoon van Milka, die zij Nahor gebaard heeft. ");
INSERT INTO nld_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Voorts had zij tot hem gezegd: Ook is er stro en veel voeders bij ons, ook plaats om te vernachten. ");
INSERT INTO nld_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Toen neigde die man zijn hoofd, en aanbad den HEERE; ");
INSERT INTO nld_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","En hij zeide: Geloofd zij de HEERE, de God van mijn heer Abraham, Die Zijn weldadigheid en waarheid niet nagelaten heeft van mijn heer; aangaande mij, de HEERE heeft mij op dezen weg geleid, ten huize van mijns heren broederen. ");
INSERT INTO nld_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","En die jonge dochter liep, en gaf ten huize harer moeder te kennen, gelijk deze zaken waren. ");
INSERT INTO nld_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","En Rebekka had een broeder, wiens naam was Laban; en Laban liep tot dien man naar buiten tot de fontein. ");
INSERT INTO nld_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","En het geschiedde, als hij dat voorhoofdsiersel gezien had, en de armringen aan de handen zijner zuster; en als hij gehoord had de woorden zijner zuster Rebekka, zeggende: Alzo heeft die man tot mij gesproken, zo kwam hij tot dien man, en ziet, hij stond bij de kemelen, bij de fontein. ");
INSERT INTO nld_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","En hij zeide: Kom in, gij, gezegende des HEEREN! waarom zoudt gij buiten staan? want ik heb het huis bereid, en de plaats voor de kemelen. ");
INSERT INTO nld_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Toen kwam die man naar het huis toe, en men ontgordde de kemelen, en men gaf den kemelen stro en voeder; en water om zijn voeten te wassen, en de voeten der mannen, die bij hem waren. ");
INSERT INTO nld_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Daarna werd hem te eten voorgezet; maar hij zeide: Ik zal niet eten, totdat ik mijn woorden gesproken heb. En hij zeide: Spreek! ");
INSERT INTO nld_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Toen zeide hij: Ik ben een knecht van Abraham; ");
INSERT INTO nld_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","En de HEERE heeft mijn heer zeer gezegend, zodat hij groot geworden is; en Hij heeft hem gegeven schapen, en runderen, en zilver, en goud, en knechten, en maagden, en kemelen, en ezelen. ");
INSERT INTO nld_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","En Sara, de huisvrouw van mijn heer, heeft mijn heer een zoon gebaard, nadat zij oud geworden was; en hij heeft hem gegeven alles, wat hij heeft. ");
INSERT INTO nld_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","En mijn heer heeft mij doen zweren, zeggende: Gij zult voor mijn zoon geen vrouw nemen van de dochteren der Kanaanieten, in welker land ik wone; ");
INSERT INTO nld_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Maar gij zult trekken naar het huis mijns vaders, en naar mijn geslacht, en zult voor mijn zoon een vrouw nemen! ");
INSERT INTO nld_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Toen zeide ik tot mijn heer: Misschien zal mij de vrouw niet volgen. ");
INSERT INTO nld_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","En hij zeide tot mij: De HEERE, voor Wiens aangezicht ik gewandeld heb, zal Zijn Engel met u zenden, en Hij zal uw weg voorspoedig maken, dat gij voor mijn zoon een vrouw neemt, uit mijn geslacht en uit mijns vaders huis. ");
INSERT INTO nld_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Dan zult gij van mijn eed rein zijn, wanneer gij tot mijn geslacht zult gegaan zijn; en indien zij haar u niet geven, zo zult gij rein zijn van mijn eed. ");
INSERT INTO nld_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","En ik kwam heden aan de fontein; en ik zeide: O, HEERE! God van mijn heer Abraham! zo Gij nu mijn weg voorspoedig maken zult, op welke ik ga; ");
INSERT INTO nld_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Zie, ik sta bij de waterfontein; zo geschiede, dat de maagd, die uitkomen zal om te putten, en tot welke ik zeggen zal: Geef mij toch een weinig waters te drinken uit uw kruik; ");
INSERT INTO nld_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","En zij tot mij zal zeggen: Drink gij ook, en ik zal ook uw kemelen putten; dat deze die vrouw zij, die de HEERE aan den zoon van mijn heer heeft toegewezen. ");
INSERT INTO nld_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Eer ik geeindigd had te spreken in mijn hart, ziet, zo kwam Rebekka uit, en had haar kruik op haar schouder, en zij kwam af tot de fontein en putte; en ik zeide tot haar: Geef mij toch te drinken! ");
INSERT INTO nld_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Zo haastte zij zich en liet haar kruik van zich neder, en zeide: Drink gij, en ik zal ook uw kemelen drenken; en ik dronk, en zij drenkte ook de kemelen. ");
INSERT INTO nld_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Toen vraagde ik haar, en zeide: Wiens dochter zijt gij? En zij zeide: De dochter van Bethuel, den zoon van Nahor, welken Milka hem gebaard heeft. Zo leide ik het voorhoofdsiersel op haar aangezicht, en de armringen aan haar handen; ");
INSERT INTO nld_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","En ik neigde mijn hoofd, en aanbad den HEERE; en ik loofde den HEERE, den God van mijn heer Abraham, Die mij op den rechten weg geleid had, om de dochter des broeders van mijn heer voor zijn zoon te nemen. ");
INSERT INTO nld_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nu dan, zo gijlieden weldadigheid en trouw aan mijn heer doen zult, geeft het mij te kennen; en zo niet, geeft het mij ook te kennen, opdat ik mij ter rechter- of ter linkerhand wende. ");
INSERT INTO nld_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Toen antwoordde Laban, en Bethuel, en zeiden: Van den HEERE is deze zaak voortgekomen; wij kunnen kwaad noch goed tot u spreken. ");
INSERT INTO nld_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Zie, Rebekka is voor uw aangezicht; neem haar en trek henen; zij zij de vrouw van den zoon uws heren, gelijk de HEERE gesproken heeft! ");
INSERT INTO nld_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","En het geschiedde, als Abrahams knecht hun woorden hoorde, zo boog hij zich ter aarde voor den HEERE. ");
INSERT INTO nld_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","En de knecht langde voort zilveren kleinoden, en gouden kleinoden, en klederen, en hij gaf die aan Rebekka; hij gaf ook aan haar broeder en haar moeder kostelijkheden. ");
INSERT INTO nld_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Toen aten en dronken zij, hij en de mannen, die bij hem waren; en zij vernachtten, en zij stonden des morgens op, en hij zeide: Laat mij trekken tot mijn heer! ");
INSERT INTO nld_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Toen zeide haar broeder, en haar moeder: Laat de jonge dochter enige dagen, of tien, bij ons blijven; daarna zult gij gaan. ");
INSERT INTO nld_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Maar hij zeide tot hen: Houdt mij niet op, dewijl de HEERE mijn weg voorspoedig gemaakt heeft! laat mij trekken, dat ik tot mijn heer ga. ");
INSERT INTO nld_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Toen zeiden zij: Laat ons de jonge dochter roepen, en haar mond vragen. ");
INSERT INTO nld_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","En zij riepen Rebekka, en zeiden tot haar: Zult gij met dezen man trekken? En zij antwoordde: Ik zal trekken. ");
INSERT INTO nld_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Toen lieten zij Rebekka, hun zuster, en haar voedster trekken, mitsgaders Abrahams knecht en zijn mannen. ");
INSERT INTO nld_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","En zij zegenden Rebekka, en zeiden tot haar: O, onze zuster! wordt gij tot duizenden millioenen, en uw zaad bezitte de poort zijner haters! ");
INSERT INTO nld_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","En Rebekka maakte zich op met haar jonge dochteren, en zij reden op kemelen, en volgden den man; en die knecht nam Rebekka, en toog heen. ");
INSERT INTO nld_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Izak nu kwam, van daar men komt tot den put Lachai-Roi; en hij woonde in het zuiderland. ");
INSERT INTO nld_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","En Izak was uitgegaan om te bidden in het veld, tegen het naken van den avond; en hij hief zijn ogen op en zag toe, en ziet, de kemelen kwamen! ");
INSERT INTO nld_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekka hief ook haar ogen op, en zij zag Izak; en zij viel van den kemel af. ");
INSERT INTO nld_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","En zij zeide tot den knecht: Wie is die man, die ons in het veld tegemoet wandelt? En de knecht zeide: Dat is mijn heer! Toen nam zij den sluier, en bedekte zich. ");
INSERT INTO nld_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","En de knecht vertelde aan Izak al de zaken, die hij gedaan had. ");
INSERT INTO nld_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","En Izak bracht haar in de tent van zijn moeder Sara; en hij nam Rebekka, en zij werd hem ter vrouw, en hij had haar lief. Alzo werd Izak getroost na zijner moeders dood. ");
INSERT INTO nld_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","En Abraham voer voort, en nam een vrouw, wier naam was Ketura. ");
INSERT INTO nld_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","En zij baarde hem Zimran en Joksan, en Medan en Midian, en Jisbak en Suah. ");
INSERT INTO nld_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","En Joksan gewon Seba en Dedan; en de zonen van Dedan waren de Assurieten, en Letusieten, en Leummieten. ");
INSERT INTO nld_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","En de zonen van Midian waren Efa en Efer, en Henoch en Abida, en Eldaa. Deze allen waren zonen van Ketura. ");
INSERT INTO nld_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Doch Abraham gaf aan Izak al wat hij had. ");
INSERT INTO nld_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Maar aan de zonen der bijwijven, die Abraham had, gaf Abraham geschenken; en zond hen weg van zijn zoon Izak, terwijl hij nog leefde, oostwaarts naar het land van het Oosten. ");
INSERT INTO nld_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dit nu zijn de dagen der jaren des levens van Abraham, welke hij geleefd heeft, honderd vijf en zeventig jaren. ");
INSERT INTO nld_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","En Abraham gaf den geest en stierf, in goeden ouderdom, oud en des levens zat, en hij werd tot zijn volken verzameld. ");
INSERT INTO nld_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","En Izak en Ismael, zijn zonen, begroeven hem, in de spelonk van Machpela, in den akker van Efron, den zoon van Zohar, den Hethiet, welke tegenover Mamre is; ");
INSERT INTO nld_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","In den akker, dien Abraham van de zonen Heths gekocht had, daar is Abraham begraven, en Sara, zijn huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","En het geschiedde na Abrahams dood, dat God Izak, zijn zoon, zegende; en Izak woonde bij den put Lachai-Roi. ");
INSERT INTO nld_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dit nu zijn de geboorten van Ismael, den zoon van Abraham, dien Hagar, de Egyptische, dienstmaagd van Sara, Abraham gebaard heeft. ");
INSERT INTO nld_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","En dit zijn de namen der zonen van Ismael, met hun namen naar hun geboorten. De eerstgeborene van Ismael, Nabajoth; daarna Kedar, en Adbeel, en Mibsam, ");
INSERT INTO nld_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","En Misma, en Duma, en Massa, ");
INSERT INTO nld_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar en Thema, Jetur, Nafis en Kedma. ");
INSERT INTO nld_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Deze zijn de zonen van Ismael, en dit zijn hun namen, in hun dorpen en paleizen, twaalf vorsten naar hun volken. ");
INSERT INTO nld_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","En dit zijn de jaren des levens van Ismael, honderd zeven en dertig jaren; en hij gaf den geest, en stierf, en hij werd verzameld tot zijn volken. ");
INSERT INTO nld_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","En zij woonden van Havila tot Sur toe, hetwelk tegenover Egypte is, daar gij gaat naar Assur; hij heeft zich nedergeslagen voor het aangezicht van al zijn broederen. ");
INSERT INTO nld_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dit nu zijn de geboorten van Izak, den zoon van Abraham: Abraham gewon Izak. ");
INSERT INTO nld_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","En Izak was veertig jaren oud, als hij Rebekka, de dochter van Bethuel, den Syrier, uit Paddan-Aram, de zuster van Laban, den Syrier, zich ter vrouw nam. ");
INSERT INTO nld_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","En Izak bad den HEERE zeer in de tegenwoordigheid van zijn huisvrouw; want zij was onvruchtbaar; en de HEERE liet zich van hem verbidden, zodat Rebekka, zijn huisvrouw, zwanger werd. ");
INSERT INTO nld_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","En de kinderen stieten zich samen in haar lichaam. Toen zeide zij: Is het zo? waarom ben ik dus? en zij ging om den HEERE te vragen. ");
INSERT INTO nld_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","En de HEERE zeide tot haar: Twee volken zijn in uw buik, en twee natien zullen zich uit uw ingewand van een scheiden; en het ene volk zal sterker zijn dan het andere volk; en de meerdere zal den mindere dienen. ");
INSERT INTO nld_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Als nu haar dagen vervuld waren om te baren, ziet, zo waren tweelingen in haar buik. ");
INSERT INTO nld_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","En de eerste kwam uit, ros; hij was geheel als een haren kleed; daarom noemden zij zijn naam Ezau. ");
INSERT INTO nld_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","En daarna kwam zijn broeder uit, wiens hand Ezau's verzenen hield; daarom noemde men zijn naam Jakob. En Izak was zestig jaren oud, als hij hen gewon. ");
INSERT INTO nld_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Als nu deze jongeren groot werden, werd Ezau een man, verstandig op de jacht, een veldman; maar Jakob werd een oprecht man, wonende in tenten. ");
INSERT INTO nld_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","En Izak had Ezau lief; want het wildbraad was naar zijn mond; maar Rebekka had Jakob lief. ");
INSERT INTO nld_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","En Jakob had een kooksel gekookt; en Ezau kwam uit het veld, en was moede. ");
INSERT INTO nld_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","En Ezau zeide tot Jakob: Laat mij toch slorpen van dat rode, dat rode daar, want ik ben moede; daarom heeft men zijn naam genoemd Edom. ");
INSERT INTO nld_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Toen zeide Jakob: Verkoop mij op dezen dag uw eerstgeboorte. ");
INSERT INTO nld_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","En Ezau zeide: Zie, ik ga sterven; en waartoe mij dan de eerstgeboorte? ");
INSERT INTO nld_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Toen zeide Jakob: Zweer mij op dezen dag! en hij zwoer hem; en hij verkocht aan Jakob zijn eerstgeboorte. ");
INSERT INTO nld_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","En Jakob gaf aan Ezau brood, en het linzenkooksel; en hij at en dronk, en hij stond op en ging heen; alzo verachtte Ezau de eerstgeboorte. ");
INSERT INTO nld_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","En er was honger in dat land, behalve den eersten honger, die in de dagen van Abraham geweest was; daarom toog Izak tot Abimelech, de koning der Filistijnen, naar Gerar. ");
INSERT INTO nld_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","En de HEERE verscheen hem en zeide: Trek niet af naar Egypte; woon in het land, dat Ik u aanzeggen zal; ");
INSERT INTO nld_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Woon als vreemdeling in dat land, en Ik zal met u zijn, en zal u zegenen; want aan u en uw zaad zal Ik al deze landen geven, en Ik zal den eed bevestigen, dien Ik Abraham uw vader gezworen heb. ");
INSERT INTO nld_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","En Ik zal uw zaad vermenigvuldigen, als de sterren des hemels, en zal aan uw zaad al deze landen geven; en in uw zaad zullen gezegend worden alle volken der aarde, ");
INSERT INTO nld_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Daarom dat Abraham Mijn stem gehoorzaam geweest is, en heeft onderhouden Mijn bevel, Mijn geboden, Mijn inzettingen en Mijn wetten. ");
INSERT INTO nld_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Alzo woonde Izak te Gerar. ");
INSERT INTO nld_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","En als de mannen van die plaats hem vraagden van zijn huisvrouw, zeide hij: Zij is mijn zuster; want hij vreesde te zeggen, mijn huisvrouw; opdat mij misschien, zeide hij, de mannen dezer plaats niet doden, om Rebekka; want zij was schoon van aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","En het geschiedde, als hij een langen tijd daar geweest was, dat Abimelech, de koning der Filistijnen, ten venster uitkeek, en hij zag, dat, ziet, Izak was jokkende met Rebekka zijn huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Toen riep Abimelech Izak, en zeide: Voorwaar, zie, zij is uw huisvrouw! hoe hebt gij dan gezegd: Zij is mijn zuster? En Izak zeide tot hem: Want ik zeide: Dat ik niet misschien om harentwil sterve. ");
INSERT INTO nld_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","En Abimelech zeide: Wat is dit, dat gij ons gedaan hebt? Lichtelijk had een van dit volk bij uw huisvrouw gelegen, zodat gij een schuld over ons zoudt gebracht hebben. ");
INSERT INTO nld_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","En Abimelech gebood het ganse volk, zeggende: Zo wie deze man of zijn huisvrouw aanroert, zal voorzeker gedood worden! ");
INSERT INTO nld_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","En Izak zaaide in datzelve land, en hij vond in datzelve jaar honderd maten; want de HEERE zegende hem. ");
INSERT INTO nld_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","En die man werd groot, ja, hij werd doorgaans groter, totdat hij zeer groot geworden was. ");
INSERT INTO nld_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","En hij had bezitting van schapen, en bezitting van runderen, en groot gezin; zodat hem de Filistijnen benijdden. ");
INSERT INTO nld_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","En al de putten, die de knechten van zijn vader, in de dagen van zijn vader Abraham, gegraven hadden, die stopten de Filistijnen, en vulden dezelve met aarde. ");
INSERT INTO nld_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ook zeide Abimelech tot Izak: Trek van ons; want gij zijt veel machtiger geworden, dan wij. ");
INSERT INTO nld_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Toen toog Izak van daar, en hij legerde zich in het dal van Gerar, en woonde aldaar. ");
INSERT INTO nld_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Als nu Izak wedergekeerd was, groef hij die waterputten op, die zij ten tijde van Abraham, zijn vader, gegraven, en die de Filistijnen na Abrahams dood toegestopt hadden; en hij noemde derzelver namen naar de namen, waarmede zijn vader die genoemd had. ");
INSERT INTO nld_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","De knechten van Izak dan groeven in dat dal, en zij vonden aldaar een put van levend water. ");
INSERT INTO nld_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","En de herders van Gerar twistten met Izaks herders, zeggende: Dit water hoort ons toe! Daarom noemde hij den naam van dien put Esek, omdat zij met hem gekeven hadden. ");
INSERT INTO nld_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Toen groeven zij een anderen put, en daar twistten zij ook over; daarom noemde hij deszelfs naam Sitna. ");
INSERT INTO nld_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","En hij brak op van daar, en groef een anderen put, en zij twistten over dien niet; daarom noemde hij deszelfs naam Rehoboth, en zeide: Want nu heeft ons de HEERE ruimte gemaakt, en wij zijn gewassen in dit land. ");
INSERT INTO nld_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Daarna toog hij van daar op naar Ber-seba. ");
INSERT INTO nld_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","En de HEERE verscheen hem in denzelven nacht, en zeide: Ik ben de God van Abraham, uw vader; vrees niet; want Ik ben met u; en Ik zal u zegenen, en uw zaad vermenigvuldigen, om Abrahams, Mijns knechts, wil. ");
INSERT INTO nld_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Toen bouwde hij daar een altaar, en riep den Naam des HEEREN aan. En hij sloeg aldaar zijn tent op; en Izaks knechten groeven daar een put. ");
INSERT INTO nld_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","En Abimelech trok tot hem van Gerar, met Ahuzzat, zijn vriend, en Pichol, zijn krijgsoverste. ");
INSERT INTO nld_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","En Izak zeide tot hen: Waarom zijt gij tot mij gekomen, daar gij mij haat, en hebt mij van u weggezonden? ");
INSERT INTO nld_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","En zij zeiden: Wij hebben merkelijk gezien, dat de HEERE met u is; daarom hebben wij gezegd: Laat toch een eed tussen ons zijn, tussen ons en tussen u, en laat ons een verbond met u maken: ");
INSERT INTO nld_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Zo gij bij ons kwaad doet, gelijk als wij u niet aangeroerd hebben, en gelijk als wij bij u alleenlijk goed gedaan hebben, en hebben u in vrede laten trekken! Gij zijt nu de gezegende des HEEREN! ");
INSERT INTO nld_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Toen maakte hij hun een maaltijd, en zij aten en dronken. ");
INSERT INTO nld_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","En zij stonden des morgens vroeg op, en zwoeren de een den ander; daarna liet Izak hen gaan, en zij togen van hem in vrede. ");
INSERT INTO nld_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","En het geschiedde ten zelfden dage, dat Izaks knechten kwamen, en boodschapten hem van de zaak des puts, dien zij gegraven hadden, en zij zeiden hem: Wij hebben water gevonden. ");
INSERT INTO nld_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","En hij noemde denzelven Seba; daarom is de naam dier stad Ber-seba, tot op dezen dag. ");
INSERT INTO nld_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Als nu Ezau veertig jaren oud was, nam hij tot een vrouw Judith, de dochter van Beeri, den Hethiet, en Basmath, de dochter van Elon, den Hethiet. ");
INSERT INTO nld_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","En deze waren voor Izak en Rebekka een bitterheid des geestes. ");
INSERT INTO nld_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","En het geschiedde, als Izak oud geworden was, en zijn ogen donker geworden waren, en hij niet zien kon; toen riep hij Ezau, zijn grootsten zoon, en zeide tot hem: Mijn zoon! En hij zeide tot hem: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","En hij zeide: Zie nu, ik ben oud geworden, ik weet den dag mijns doods niet. ");
INSERT INTO nld_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nu dan, neem toch uw gereedschap, uw pijlkoker en uw boog, en ga uit in het veld, en jaag mij een wildbraad; ");
INSERT INTO nld_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","En maak mij smakelijke spijzen, zo als ik die gaarne heb, en breng ze mij, dat ik ete; opdat mijn ziel u zegene, eer ik sterve. ");
INSERT INTO nld_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekka nu hoorde toe, als Izak tot zijn zoon Ezau sprak; en Ezau ging in het veld, om een wildbraad te jagen, dat hij het inbracht. ");
INSERT INTO nld_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Toen sprak Rebekka tot Jakob, haar zoon, zeggende: Zie, ik heb uw vader tot Ezau, uw broeder, horen spreken, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Breng mij een wildbraad, en maak mij smakelijke spijzen toe, dat ik ete; en ik zal u zegenen voor het aangezicht des HEEREN, voor mijn dood. ");
INSERT INTO nld_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nu dan, mijn zoon! hoor mijn stem in hetgeen ik u gebiede. ");
INSERT INTO nld_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ga nu heen tot de kudde, en haal mij van daar twee goede geitenbokjes; en ik zal die voor uw vader maken tot smakelijke spijzen, gelijk als hij gaarne heeft. ");
INSERT INTO nld_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","En gij zult ze tot uw vader brengen, en hij zal eten, opdat hij u zegene voor zijn dood. ");
INSERT INTO nld_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Toen zeide Jakob tot Rebekka, zijn moeder: Zie, mijn broeder Ezau is een harig man, en ik ben een glad man. ");
INSERT INTO nld_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Misschien zal mij mijn vader betasten, en ik zal in zijn ogen zijn als een bedrieger; zo zoude ik een vloek over mij halen, en niet een zegen. ");
INSERT INTO nld_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","En zijn moeder zeide tot hem: Uw vloek zij op mij, mijn zoon! hoor alleen naar mijn stem, en ga, haal ze mij. ");
INSERT INTO nld_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Toen ging hij, en hij haalde ze, en bracht ze zijn moeder; en zijn moeder maakte smakelijke spijzen, gelijk als zijn vader gaarne had. ");
INSERT INTO nld_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Daarna nam Rebekka de kostelijke klederen van Ezau, haar grootsten zoon, die zij bij zich in huis had, en zij trok ze Jakob, haar kleinsten zoon, aan. ");
INSERT INTO nld_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","En de vellen van de geitenbokjes trok zij over zijn handen, en over de gladdigheid van zijn hals. ");
INSERT INTO nld_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","En zij gaf de smakelijke spijzen, en het brood, welke zij toegemaakt had, in de hand van Jakob, haar zoon. ");
INSERT INTO nld_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","En hij kwam tot zijn vader, en zeide: Mijn vader! En hij zeide: Zie, hier ben ik; wie zijt gij, mijn zoon? ");
INSERT INTO nld_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","En Jakob zeide tot zijn vader: Ik ben Ezau uw eerstgeborene; ik heb gedaan, gelijk als gij tot mij gesproken hadt; sta toch op, zit, en eet van mijn wildbraad, opdat uw ziel mij zegene. ");
INSERT INTO nld_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Toen zeide Izak tot zijn zoon: Hoe is dit, dat gij het zo haast gevonden hebt, mijn zoon? En hij zeide: Omdat de HEERE uw God dat heeft doen ontmoeten voor mijn aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","En Izak zeide tot Jakob: Nader toch, dat ik u betaste, mijn zoon! of gij mijn zoon Ezau zelf zijt, of niet. ");
INSERT INTO nld_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Toen kwam Jakob bij, tot zijn vader Izak, die hem betastte; en hij zeide: De stem is Jakobs stem, maar de handen zijn Ezau's handen. ");
INSERT INTO nld_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Doch hij kende hem niet, omdat zijn handen harig waren, gelijk zijns broeders Ezau's handen; en hij zegende hem. ");
INSERT INTO nld_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","En hij zeide: Zijt gij mijn zoon Ezau zelf? En hij zeide: Ik ben het! ");
INSERT INTO nld_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Toen zeide hij: Stel het nabij mij, dat ik van het wildbraad mijns zoons ete, opdat mijn ziel u zegene. En hij stelde het nabij hem, en hij at; hij bracht hem ook wijn, en hij dronk. ");
INSERT INTO nld_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","En zijn vader Izak zeide tot hem: Kom toch bij, en kus mij, mijn zoon! ");
INSERT INTO nld_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","En hij kwam bij, en hij kuste hem; toen rook hij de reuk zijner klederen, en zegende hem; en hij zeide: Zie, de reuk mijns zoons is als de reuk des velds, hetwelk de HEERE gezegend heeft. ");
INSERT INTO nld_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Zo geve u dan God van den dauw des hemels, en de vettigheid der aarde, en menigte van tarwe en most. ");
INSERT INTO nld_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Volken zullen u dienen, en natien zullen zich voor u nederbuigen; wees heer over uw broederen, en de zonen uwer moeder zullen zich voor u nederbuigen! Vervloekt moet hij zijn, wie u vervloekt; en wie u zegent, zij gezegend! ");
INSERT INTO nld_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","En het geschiedde, als Izak voleindigd had Jakob te zegenen, zo geschiedde het, toen Jakob maar even van het aangezicht van zijn vader Izak uitgegaan was, dat Ezau, zijn broeder, van zijn jacht kwam. ");
INSERT INTO nld_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Hij nu maakte smakelijke spijzen toe, en bracht die tot zijn vader; en hij zeide tot zijn vader: Mijn vader sta op en ete van het wildbraad zijns zoons, opdat uw ziel mij zegene. ");
INSERT INTO nld_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","En Izak, zijn vader, zeide tot hem: Wie zijt gij? En hij zeide: Ik ben uw zoon, uw eerstgeborene, Ezau. ");
INSERT INTO nld_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Toen verschrikte Izak met zeer grote verschrikking, gans zeer, en zeide: Wie is hij dan, die het wildbraad gejaagd en tot mij gebracht heeft? en ik heb van alles gegeten, eer gij kwaamt, en heb hem gezegend; ook zal hij gezegend wezen. ");
INSERT INTO nld_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Als Ezau de woorden zijns vaders hoorde, zo schreeuwde hij met een groten en bitteren schreeuw, gans zeer; en hij zeide tot zijn vader: Zegen mij, ook mij, mijn vader! ");
INSERT INTO nld_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","En hij zeide: Uw broeder is gekomen met bedrog, en heeft uw zegen weggenomen. ");
INSERT INTO nld_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Toen zeide hij: Is het niet omdat men zijn naam noemt Jakob, dat hij mij nu twee reizen heeft bedrogen? mijn eerstgeboorte heeft hij genomen, en zie, nu heeft hij mijn zegen genomen! Voorts zeide hij: Hebt gij dan geen zegen voor mij uitbehouden? ");
INSERT INTO nld_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Toen antwoordde Izak, en zeide tot Ezau: Zie, ik heb hem tot een heer over u gezet, en al zijn broeders heb ik hem tot knechten gegeven; en ik heb hem met koorn en most ondersteund; wat zal ik u dan nu doen, mijn zoon? ");
INSERT INTO nld_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","En Ezau zeide tot zijn vader: Hebt gij maar dezen enen zegen, mijn vader? Zegen mij, ook mij, mijn vader! En Ezau hief zijn stem op, en weende. ");
INSERT INTO nld_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Toen antwoordde zijn vader Izak en zeide tot hem: Zie, de vettigheden der aarde zullen uw woningen zijn, en van den dauw des hemels van boven af zult gij gezegend zijn. ");
INSERT INTO nld_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","En op uw zwaard zult gij leven, en zult uw broeder dienen; doch het zal geschieden, als gij heersen zult, dan zult gij zijn juk van uw hals afrukken. ");
INSERT INTO nld_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","En Ezau haatte Jakob om dien zegen, waarmede zijn vader hem gezegend had; en Ezau zeide in zijn hart: De dagen van den rouw mijns vaders naderen, en ik zal mijn broeder Jakob doden. ");
INSERT INTO nld_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Toen aan Rebekka deze woorden van Ezau, haar grootsten zoon, geboodschapt werden, zo zond zij heen, en ontbood Jakob, haar kleinsten zoon, en zeide tot hem: Zie, uw broeder Ezau troost zich over u, dat hij u doden zal. ");
INSERT INTO nld_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nu dan, mijn zoon! hoor naar mijn stem, en maak u op, vlied gij naar Haran, tot Laban, mijn broeder. ");
INSERT INTO nld_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","En blijf bij hem enige dagen, totdat de hittige gramschap uws broeders kere; ");
INSERT INTO nld_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Totdat de toorn uws broeders van u afkere, en hij vergeten hebbe, hetgeen gij hem gedaan hebt; dan zal ik zenden, en u van daar nemen; waarom zoude ik ook van u beiden beroofd worden op een dag? ");
INSERT INTO nld_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","En Rebekka zeide tot Izak: Ik heb verdriet aan mijn leven vanwege de dochteren Heths! Indien Jakob een vrouw neemt van de dochteren Heths, gelijk deze zijn, van de dochteren dezes lands, waartoe zal mij het leven zijn? ");
INSERT INTO nld_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","En Izak riep Jakob, en zegende hem; en gebood hem, en zeide tot hem: Neem geen vrouw van de dochteren van Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Maak u op, ga naar Paddan-Aram, ten huize van Bethuel, den vader uwer moeder, en neem u van daar een vrouw, van de dochteren van Laban, uwer moeders broeder. ");
INSERT INTO nld_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","En God almachtig zegene u, en make u vruchtbaar, en vermenigvuldige u, dat gij tot een hoop volken wordt. ");
INSERT INTO nld_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","En Hij geve u den zegen van Abraham; aan u, en uw zaad met u, opdat gij erfelijk bezit het land uwer vreemdelingschappen, hetwelk God aan Abraham gegeven heeft. ");
INSERT INTO nld_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Alzo zond Izak Jakob weg, dat hij toog naar Paddan-Aram, tot Laban, den zoon van Bethuel, den Syrier, den broeder van Rebekka, Jakobs en Ezau's moeder. ");
INSERT INTO nld_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Als nu Ezau zag, dat Izak Jakob gezegend, en hem naar Paddan-Aram weggezonden had om zich van daar een vrouw te nemen; en als hij hem zegende, dat hij hem geboden had, zeggende: Neem geen vrouw van de dochteren van Kanaan; ");
INSERT INTO nld_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","En dat Jakob zijn vader en zijn moeder gehoorzaam geweest was, en naar Paddan-Aram getrokken was; ");
INSERT INTO nld_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","En dat Ezau zag, dat de dochteren van Kanaan kwaad waren in de ogen van Izak, zijn vader; ");
INSERT INTO nld_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Zo ging Ezau tot Ismael, en nam zich tot een vrouw boven zijn vrouwen, Mahalath, de dochter van Ismael, den zoon van Abraham, de zuster van Nebajoth. ");
INSERT INTO nld_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob dan toog uit van Ber-seba, en ging naar Haran. ");
INSERT INTO nld_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","En hij geraakte op een plaats, waar hij vernachtte; want de zon was ondergegaan; en hij nam van de stenen dier plaats, en maakte zijn hoofdpeluw, en leide zich te slapen te dierzelver plaats. ");
INSERT INTO nld_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","En hij droomde; en ziet, een ladder was gesteld op de aarde, welker opperste aan den hemel raakte; en ziet, de engelen Gods klommen daarbij op en neder. ");
INSERT INTO nld_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","En ziet, de HEERE stond op dezelve en zeide: Ik ben de HEERE, de God van uw vader Abraham, en de God van Izak; dit land, waarop gij ligt te slapen, zal Ik aan u geven, en aan uw zaad. ");
INSERT INTO nld_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","En uw zaad zal wezen als het stof der aarde, en gij zult uitbreken in menigte, westwaarts en oostwaarts, en noordwaarts en zuidwaarts; en in u, en in uw zaad zullen alle geslachten des aardbodems gezegend worden. ");
INSERT INTO nld_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","En zie, Ik ben met u, en Ik zal u behoeden overal, waarheen gij trekken zult, en Ik zal u wederbrengen in dit land; want Ik zal u niet verlaten, totdat Ik zal gedaan hebben, hetgeen Ik tot u gesproken heb. ");
INSERT INTO nld_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Toen nu Jakob van zijn slaap ontwaakte, zeide hij: Gewisselijk is de HEERE aan deze plaats, en ik heb het niet geweten! ");
INSERT INTO nld_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","En hij vreesde, en zeide: Hoe vreselijk is deze plaats! Dit is niet dan een huis Gods, en dit is de poort des hemels! ");
INSERT INTO nld_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Toen stond Jakob des morgens vroeg op, en hij nam dien steen, dien hij tot zijn hoofdpeluw gelegd had, en zette hem tot een opgericht teken, en goot daar olie boven op. ");
INSERT INTO nld_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","En hij noemde den naam dier plaats Beth-El; daar toch de naam dier stad te voren was Luz. ");
INSERT INTO nld_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","En Jakob beloofde een gelofte, zeggende: Wanneer God met mij geweest zal zijn, en mij behoed zal hebben op dezen weg, dien ik reize, en mij gegeven zal hebben brood om te eten, en klederen om aan te trekken; ");
INSERT INTO nld_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","En ik ten huize mijns vaders in vrede zal wedergekeerd zijn; zo zal de HEERE mij tot een God zijn! ");
INSERT INTO nld_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","En deze steen, dien ik tot een opgericht teken gezet heb, zal een huis Gods wezen, en van alles, wat Gij mij geven zult, zal ik U voorzeker de tienden geven! ");
INSERT INTO nld_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Toen hief Jakob zijn voeten op, en ging naar het land der kinderen van het Oosten. ");
INSERT INTO nld_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","En hij zag toe, en ziet, er was een put in het veld; en ziet, er waren drie kudden schapen nevens dien nederliggende; want uit dien put drenkten zij de kudden; en er was een grote steen op den mond van dien put. ");
INSERT INTO nld_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","En derwaarts werden al de kudden verzameld, en zij wentelden den steen van den mond des puts, en drenkten de schapen, en legden den steen weder op den mond van dien put, op zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Toen zeide Jakob tot hen: Mijn broeders! van waar zijt gij? En zij zeiden: Wij zijn van Haran. ");
INSERT INTO nld_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","En hij zeide tot hen: Kent gij Laban, den zoon van Nahor? En zij zeiden: Wij kennen hem. ");
INSERT INTO nld_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Voorts zeide hij tot hen: Is het wel met hem? En zij zeiden: Het is wel; en zie, Rachel, zijn dochter, komt met de schapen. ");
INSERT INTO nld_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","En hij zeide: Ziet, het is nog hoog dag, het is geen tijd, dat het vee verzameld worde; drenkt de schapen, en gaat heen, weidt dezelve. ");
INSERT INTO nld_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Toen zeiden zij: Wij kunnen niet, totdat al de kudden samen zullen vergaderd zijn, en dat men den steen van den mond des puts afwentele, opdat wij de schapen drenken. ");
INSERT INTO nld_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Als hij nog met hen sprak, zo kwam Rachel met de schapen, die haar vader toebehoorden; want zij was een herderin. ");
INSERT INTO nld_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","En het geschiedde, als Jakob Rachel zag, de dochter van Laban, zijner moeders broeder, en de schapen van Laban, zijner moeders broeder, dat Jakob toetrad, en wentelde den steen van den mond des puts, en drenkte de schapen van Laban, zijner moeders broeder. ");
INSERT INTO nld_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","En Jakob kuste Rachel; en hij hief zijn stem op en weende. ");
INSERT INTO nld_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","En Jakob gaf Rachel te kennen, dat hij een broeder van haar vader, en dat hij de zoon van Rebekka was. Toen liep zij heen, en gaf het aan haar vader te kennen. ");
INSERT INTO nld_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","En het geschiedde, als Laban die tijding hoorde van Jakob, zijner zusters zoon, zo liep hij hem tegemoet, en omhelsde hem, en kuste hem, en bracht hem tot zijn huis. En hij vertelde Laban al deze dingen. ");
INSERT INTO nld_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Toen zeide Laban tot hem: Voorwaar, gij zijt mijn gebeente en mijn vlees! En hij bleef bij hem een volle maand. ");
INSERT INTO nld_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Daarna zeide Laban tot Jakob: Omdat gij mijn broeder zijt, zoudt gij mij derhalve om niet dienen? verklaar mij, wat zal uw loon zijn? ");
INSERT INTO nld_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","En Laban had twee dochters: de naam der grootste was Lea; en de naam der kleinste was Rachel. ");
INSERT INTO nld_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Doch Lea had tedere ogen; maar Rachel was schoon van gedaante, en schoon van aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","En Jakob had Rachel lief; en hij zeide: Ik zal u zeven jaren dienen, om Rachel, uw kleinste dochter. ");
INSERT INTO nld_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Toen zeide Laban: Het is beter, dat ik haar aan u geve, dan dat ik haar aan een anderen man geve; blijf bij mij. ");
INSERT INTO nld_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Alzo diende Jakob om Rachel zeven jaren; en die waren in zijn ogen als enige dagen, omdat hij haar liefhad. ");
INSERT INTO nld_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Toen zeide Jakob tot Laban: Geef mijn huisvrouw, want mijn dagen zijn vervuld, dat ik tot haar inga. ");
INSERT INTO nld_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Zo verzamelde Laban al de mannen dier plaats, en maakte een maaltijd. ");
INSERT INTO nld_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","En het geschiedde des avonds, dat hij zijn dochter Lea nam, en bracht haar tot hem; en hij ging tot haar in. ");
INSERT INTO nld_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","En Laban gaf haar Zilpa, zijn dienstmaagd, aan Lea, zijn dochter, tot een dienstmaagd. ");
INSERT INTO nld_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","En het geschiedde des morgens, en ziet, het was Lea. Daarom zeide hij tot Laban: Wat is dit, dat gij mij gedaan hebt; heb ik niet bij u gediend om Rachel? waarom hebt gij mij dan bedrogen? ");
INSERT INTO nld_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","En Laban zeide: Men doet alzo niet te dezer onzer plaatse, dat men de kleinste uitgeve voor de eerstgeborene. ");
INSERT INTO nld_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Vervul de week van deze; dan zullen wij u ook die geven, voor den dienst, dien gij nog andere zeven jaren bij mij dienen zult. ");
INSERT INTO nld_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","En Jakob deed alzo; en hij vervulde de week van deze. Toen gaf hij hem Rachel, zijn dochter, hem tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","En Laban gaf aan zijn dochter Rachel zijn dienstmaagd Bilha, haar tot een dienstmaagd. ");
INSERT INTO nld_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","En hij ging ook in tot Rachel, en had ook Rachel liever dan Lea; en hij diende bij hem nog andere zeven jaren. ");
INSERT INTO nld_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Toen nu de HEERE zag, dat Lea gehaat was, opende Hij haar baarmoeder; maar Rachel was onvruchtbaar. ");
INSERT INTO nld_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","En Lea werd bevrucht, en baarde een zoon, en zij noemde zijn naam Ruben; want zij zeide: Omdat de HEERE mijn verdrukking heeft aangezien, daarom zal mijn man mij nu liefhebben. ");
INSERT INTO nld_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","En zij werd wederom bevrucht, en baarde een zoon, en zeide: Dewijl de HEERE gehoord heeft, dat ik gehaat was, zo heeft Hij mij ook dezen gegeven; en zij noemde zijn naam Simeon. ");
INSERT INTO nld_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","En zij werd nog bevrucht, en baarde een zoon, en zeide: Nu zal zich ditmaal mijn man bij mij voegen, dewijl ik hem drie zonen gebaard heb; daarom noemde zij zijn naam Levi. ");
INSERT INTO nld_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","En zij werd wederom bevrucht, en baarde een zoon, en zeide: Ditmaal zal ik den HEERE loven; daarom noemde zij zijn naam Juda. En zij hield op van baren. ");
INSERT INTO nld_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Als nu Rachel zag, dat zij Jakob niet baarde, zo benijdde Rachel haar zuster; en zij zeide tot Jakob: Geef mij kinderen! of indien niet, zo ben ik dood. ");
INSERT INTO nld_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Toen ontstak Jakobs toorn tegen Rachel, en hij zeide: Ben ik dan in plaats van God, Die de vrucht des buiks van u geweerd heeft? ");
INSERT INTO nld_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","En zij zeide: Zie, daar is mijn dienstmaagd Bilha, ga tot haar in; dat zij op mijn knieen bare, en ik ook uit haar gebouwd worde. ");
INSERT INTO nld_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Zo gaf zij hem haar dienstmaagd Bilha tot een vrouw; en Jakob ging tot haar in. ");
INSERT INTO nld_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","En Bilha werd zwanger, en baarde Jakob een zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Toen zeide Rachel: God heeft mij gericht, en ook mijn stem verhoord, en heeft mij een zoon gegeven; daarom noemde zij zijn naam Dan. ");
INSERT INTO nld_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","En Bilha, Rachels dienstmaagd, werd wederom bevrucht, en baarde Jakob den tweeden zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Toen zeide Rachel: Ik heb worstelingen Gods met mijn zuster geworsteld; ook heb ik de overhand gehad; en zij noemde zijn naam Nafthali. ");
INSERT INTO nld_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Toen nu Lea zag, dat zij ophield van baren, nam zij ook haar dienstmaagd Zilpa, en gaf die aan Jakob tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","En Zilpa, Lea's dienstmaagd, baarde Jakob een zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Toen zeide Lea: Er komt een hoop! en zij noemde zijn naam Gad. ");
INSERT INTO nld_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Daarna baarde Zilpa, Lea's dienstmaagd, Jakob een tweeden zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Toen zeide Lea: Tot mijn geluk! want de dochters zullen mij gelukkig achten; en zij noemde zijn naam Aser. ");
INSERT INTO nld_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","En Ruben ging in de dagen van de tarweoogst, en hij vond Dudaim in het veld, en hij bracht die tot zijn moeder Lea. Toen zeide Rachel tot Lea: Geef mij toch van uws zoons Dudaim. ");
INSERT INTO nld_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","En zij zeide tot haar: Is het weinig, dat gij mijn man genomen hebt, dat gij ook mijns zoons Dudaim nemen zult? Toen zeide Rachel: Daarom zal hij dezen nacht voor uws zoons Dudaim bij u liggen. ");
INSERT INTO nld_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Als nu Jakob des avonds uit het veld kwam, ging Lea uit hem tegemoet, en zeide: Gij zult tot mij inkomen; want ik heb u om loon zekerlijk gehuurd voor mijns zoons Dudaim; en hij lag dien nacht bij haar. ");
INSERT INTO nld_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","En God verhoorde Lea; en zij werd bevrucht, en baarde Jakob den vijfden zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Toen zeide Lea: God heeft mijn loon gegeven, nadat ik mijn dienstmaagd aan mijn man gegeven heb; en zij noemde zijn naam Issaschar. ");
INSERT INTO nld_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","En Lea werd wederom bevrucht, en zij baarde Jakob den zesden zoon. ");
INSERT INTO nld_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","En Lea zeide: God heeft mij, mij heeft Hij begiftigd met een goede gift; ditmaal zal mijn man mij bijwonen; want ik heb hem zes zonen gebaard; en zij noemde zijn naam Zebulon. ");
INSERT INTO nld_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","En zij baarde daarna een dochter; en zij noemde haar naam Dina. ");
INSERT INTO nld_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","God dacht ook aan Rachel; en God verhoorde haar, en opende haar baarmoeder. ");
INSERT INTO nld_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","En zij werd bevrucht, en baarde een zoon; en zij zeide: God heeft mijn smaadheid weggenomen! ");
INSERT INTO nld_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","En zij noemde zijn naam Jozef, zeggende: De HEERE voege mij een anderen zoon daartoe. ");
INSERT INTO nld_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","En het geschiedde, dat Rachel Jozef gebaard had, dat Jakob tot Laban zeide: Laat mij vertrekken, dat ik ga tot mijn plaats, en naar mijn land. ");
INSERT INTO nld_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Geef mijn vrouwen, en mijn kinderen, om welke ik u gediend heb, dat ik vertrek; want gij weet mijn dienst, dien ik u gediend heb. ");
INSERT INTO nld_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Toen zeide Laban tot hem: Zo ik nu genade gevonden heb in uw ogen; ik heb waargenomen, dat de HEERE mij om uwentwil gezegend heeft. ");
INSERT INTO nld_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Hij zeide dan: Noem mij uitdrukkelijk uw loon, dat ik geven zal. ");
INSERT INTO nld_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Toen zeide hij tot hem: Gij weet, hoe ik u gediend heb, en hoe uw vee bij mij geweest is. ");
INSERT INTO nld_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Want het weinige, dat gij voor mij gehad hebt, dat is tot een menigte uitgebroken; en de HEERE heeft u gezegend bij mijn voet; nu dan, wanneer zal ik ook werken voor mijn huis? ");
INSERT INTO nld_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","En hij zeide: Wat zal ik u geven? Toen zeide Jakob: Gij zult mij niet met al geven, indien gij mij deze zaak doen zult; ik zal wederom uw kudden weiden, en bewaren. ");
INSERT INTO nld_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ik zal heden door uw ganse kudde gaan, daarvan afzonderende al het gespikkelde en geplekte vee, en al het bruine vee onder de lammeren, en het geplekte en gespikkelde onder de geiten; en zulks zal mijn loon zijn. ");
INSERT INTO nld_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Zo zal mijn gerechtigheid op den dag van morgen met mij betuigen, als gij komen zult over mijn loon, voor uw aangezicht; al wat niet gespikkeld en geplekt is onder de geiten en bruin onder de lammeren, dat zij bij mij gestolen. ");
INSERT INTO nld_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Toen zeide Laban: Zie, och ja, het zij naar uw woord! ");
INSERT INTO nld_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","En hij zonderde af ten zelfden dage de gesprenkelde en geplekte bokken en al de gespikkelde en geplekte geiten, al waar wit aan was, en al het bruine onder de lammeren; en hij gaf dezelve in de hand zijner zonen. ");
INSERT INTO nld_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","En hij stelde een weg van drie dagen tussen hem, en tussen Jakob; en Jakob weidde de overige kudde van Laban. ");
INSERT INTO nld_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Toen nam zich Jakob roeden van groen populierenhout, en van hazelaar, en van kastanje; en hij schilde daarin witte strepen, ontblotende het wit, hetwelk aan die roeden was. ");
INSERT INTO nld_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","En hij leide deze roeden, die hij geschild had, in de goten, en in de drinkbakken van het water, waar de kudde kwam drinken, tegenover de kudde; en zij werden verhit, als zij kwamen om te drinken. ");
INSERT INTO nld_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Als dan de kudde verhit werd bij de roeden, zo lammerde de kudde gesprenkelde, gespikkelde, en geplekte. ");
INSERT INTO nld_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Toen scheidde Jakob de lammeren, en hij wendde het gezicht der kudde op het gesprenkelde, en al het bruine onder Labans kudde; en hij stelde zijn kudden alleen, en hij zette ze niet bij de kudde van Laban. ");
INSERT INTO nld_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","En het geschiedde, telkens als de kudde der vroegelingen verhit werd, zo stelde Jakob de roeden voor de ogen der kudde in de goten, opdat zij hittig werden bij de roeden. ");
INSERT INTO nld_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maar als de kudde spade hittig werd, zo stelde hij ze niet, zodat de spadelingen Laban, en de vroegelingen Jakob toekwamen. ");
INSERT INTO nld_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","En die man brak gans zeer uit in menigte, en hij had vele kudden, en dienstmaagden, en dienstknechten, en kemelen, en ezelen. ");
INSERT INTO nld_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Toen hoorde hij de woorden der zonen van Laban, zeggende: Jakob heeft genomen alles, wat onzes vaders was, en van hetgeen, dat onzes vaders was, heeft hij al deze heerlijkheid gemaakt. ");
INSERT INTO nld_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakob zag ook het aangezicht van Laban aan, en ziet, het was jegens hem niet als gisteren en eergisteren. ");
INSERT INTO nld_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","En de HEERE zeide tot Jakob: Keer weder tot het land uwer vaderen, en tot uw maagschap, en Ik zal met u zijn. ");
INSERT INTO nld_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Toen zond Jakob heen, en riep Rachel en Lea, op het veld tot zijn kudde; ");
INSERT INTO nld_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","En hij zeide tot haar: Ik zie het aangezicht uws vaders, dat het jegens mij niet is als gisteren en eergisteren; doch de God mijns vaders is bij mij geweest. ");
INSERT INTO nld_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","En gijlieden weet, dat ik met al mijn macht uw vader gediend heb. ");
INSERT INTO nld_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Maar uw vader heeft bedriegelijk met mij gehandeld, en heeft mijn loon tien malen veranderd; doch God heeft hem niet toegelaten, om mij kwaad te doen. ");
INSERT INTO nld_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wanneer hij aldus zeide: De gespikkelde zullen uw loon zijn, zo lammerden al de kudden gespikkelde; en wanneer hij alzo zeide: De gesprenkelde zullen uw loon zijn, zo lammerden al de kudden gesprenkelde. ");
INSERT INTO nld_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Alzo heeft God uw vader het vee ontrukt, en aan mij gegeven. ");
INSERT INTO nld_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","En het geschiedde ten tijde, als de kudde hittig werd, dat ik mijn ogen ophief, en ik zag in den droom; en ziet, de bokken, die de kudden beklommen, waren gesprenkeld, gespikkeld, en hagelvlakkig. ");
INSERT INTO nld_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","En de Engel Gods zeide tot mij in den droom: Jakob! En ik zeide: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","En Hij zeide: Hef toch uw ogen op, en zie! alle bokken, die de kudde beklimmen, zijn gesprenkeld, gespikkeld, en hagelvlakkig; want Ik heb gezien alles, wat Laban u doet. ");
INSERT INTO nld_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ik ben die God van Beth-El, alwaar gij het opgerichte teken gezalfd hebt, waar gij Mij een gelofte beloofd hebt; nu, maak u op, vertrek uit dit land, en keer weder in het land uwer maagschap. ");
INSERT INTO nld_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Toen antwoordden Rachel en Lea, en zeiden tot hem: Is er nog voor ons een deel of erfenis, in het huis onzes vaders? ");
INSERT INTO nld_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Zijn wij niet vreemden van hem geacht? Want hij heeft ons verkocht, en hij heeft ook steeds ons geld verteerd. ");
INSERT INTO nld_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Want al de rijkdom, welke God onzen vader heeft ontrukt, die is onze, en van onze zonen; nu dan, doe alles, wat God tot u gezegd heeft. ");
INSERT INTO nld_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Toen maakte zich Jakob op, en laadde zijn zonen en zijn vrouwen op kemelen. ");
INSERT INTO nld_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","En hij voerde al zijn vee weg, en al zijn have, die hij gewonnen had, het vee, dat hij bezat, hetwelk hij in Paddan-Aram geworven had, om te komen tot Izak, zijn vader, naar het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban nu was gegaan, om zijn schapen te scheren; zo stal Rachel de terafim, die haar vader had. ");
INSERT INTO nld_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","En Jakob ontstal zich aan het hart van Laban, den Syrier, overmits hij hem niet te kennen gaf, dat hij vlood. ");
INSERT INTO nld_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","En hij vlood, en al wat het zijne was, en hij maakte zich op, en voer over de rivier, en hij zette zijn aangezicht naar het gebergte Gilead. ");
INSERT INTO nld_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","En ten derden dage werd aan Laban geboodschapt, dat Jakob gevloden was. ");
INSERT INTO nld_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Toen nam hij zijn broeders met zich, en jaagde hem achterna, een weg van zeven dagen, en hij kreeg hem op het gebergte van Gilead. ");
INSERT INTO nld_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Doch God kwam tot Laban, den Syrier, in een droom des nachts, en Hij zeide tot hem: Wacht u, dat gij met Jakob spreekt, noch goed, noch kwaad. ");
INSERT INTO nld_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","En Laban achterhaalde Jakob; Jakob nu had zijn tent geslagen op dat gebergte; ook sloeg Laban met zijn broederen de zijne op het gebergte van Gilead. ");
INSERT INTO nld_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Toen zeide Laban tot Jakob: Wat hebt gij gedaan, dat gij u aan mijn hart ontstolen hebt, en mijn dochteren ontvoerd hebt, als gevangenen met het zwaard? ");
INSERT INTO nld_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Waarom zijt gij heimelijk gevloden, en hebt u aan mij ontstolen? en hebt het mij niet aangezegd, dat ik u geleid had met vreugde, en met gezangen, met trommel en met harp? ");
INSERT INTO nld_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ook hebt gij mij niet toegelaten mijn zonen en mijn dochteren te kussen; nu, gij hebt dwaselijk gedaan zo doende. ");
INSERT INTO nld_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Het ware in de macht mijner hand aan ulieden kwaad te doen; maar de God van ulieder vader heeft tot mij gisteren nacht gesproken, zeggende: Wacht u, van met Jakob te spreken, of goed, of kwaad. ");
INSERT INTO nld_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","En nu, gij hebt immers willen vertrekken, omdat gij zo zeer begerig waart naar uws vaders huis; waarom hebt gij mijn goden gestolen? ");
INSERT INTO nld_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Toen antwoordde Jakob, en zeide tot Laban: Omdat ik vreesde; want ik zeide: Opdat gij niet misschien uw dochteren mij ontweldigdet! ");
INSERT INTO nld_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bij wien gij uw goden vinden zult, laat hem niet leven! Onderken gij voor onze broederen, wat bij mij is, en neem het tot u. Want Jakob wist niet, dat Rachel dezelve gestolen had. ");
INSERT INTO nld_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Toen ging Laban in de tent van Jakob, en in de tent van Lea, en in de tent van de beide dienstmaagden, en hij vond niets; en als hij uit de tent van Lea gegaan was, kwam hij in de tent van Rachel. ");
INSERT INTO nld_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maar Rachel had de terafim genomen, en zij had die in een kemels zadeltuig gelegd, en zij zat op dezelve. En Laban betastte die ganse tent, en hij vond niets. ");
INSERT INTO nld_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","En zij zeide tot haar vader: Dat de toorn niet ontsteke in mijns heren ogen, omdat ik voor uw aangezicht niet kan opstaan; want het gaat mij naar der vrouwen wijze; en hij doorzocht; maar hij vond de terafim niet. ");
INSERT INTO nld_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Toen ontstak Jakob, en twistte met Laban; en Jakob antwoordde en zeide tot Laban: Wat is mijn overtreding, wat is mijn zonde, dat gij mij zo hittiglijk hebt nagejaagd? ");
INSERT INTO nld_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Als gij al mijn huisraad betast hebt, wat hebt gij gevonden van al het huisraad uws huizes! Leg het hier voor mijn broederen en uw broederen, en laat hen richten tussen ons beiden. ");
INSERT INTO nld_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Deze twintig jaren ben ik bij u geweest; uw ooien en uw geiten hebben niet misdragen, en de rammen uwer kudde heb ik niet gegeten. ");
INSERT INTO nld_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Het verscheurde heb ik tot u niet gebracht; ik heb het geboet; gij hebt het van mijn hand geeist, het ware des daags gestolen, of des nachts gestolen. ");
INSERT INTO nld_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ik ben geweest, dat mij bij dag de hitte verteerde, en bij nacht de vorst, en dat mijn slaap van mijn ogen week. ");
INSERT INTO nld_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ik ben nu twintig jaren in uw huis geweest; ik heb u veertien jaren gediend om uw beide dochteren, en zes jaren om uw kudde; en gij hebt mijn loon tien malen veranderd. ");
INSERT INTO nld_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ten ware de God van mijn vader, de God van Abraham, en de Vreze van Izak, bij mij geweest was, zekerlijk, gij zoudt mij nu ledig weggezonden hebben! God heeft mijn ellende, en den arbeid mijner handen aangezien, en heeft u gisteren nacht bestraft. ");
INSERT INTO nld_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Toen antwoordde Laban en zeide tot Jakob: Deze dochters zijn mijn dochters, en deze zonen zijn mijn zonen, en deze kudde is mijn kudde, ja, al wat gij ziet, dat is mijn; en wat zoude ik aan deze mijn dochteren heden doen? of aan haar zonen, die zij gebaard hebben? ");
INSERT INTO nld_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nu dan, kom, laat ons een verbond maken, ik en gij, dat het tot een getuigenis zij tussen mij en tussen u! ");
INSERT INTO nld_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Toen nam Jakob een steen, en hij verhoogde dien tot een opgericht teken. ");
INSERT INTO nld_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","En Jakob zeide tot zijn broederen: Vergadert stenen! En zij namen stenen, en maakten een hoop; en zij aten aldaar op dien hoop. ");
INSERT INTO nld_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","En Laban noemde hem Jegar-Sahadutha; maar Jakob noemde denzelven Gilead. ");
INSERT INTO nld_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Toen zeide Laban: Deze hoop zij heden een getuige tussen mij en tussen u! Daarom noemde men zijn naam Gilead, ");
INSERT INTO nld_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","En Mizpa; omdat hij zeide: Dat de HEERE opzicht neme tussen mij en tussen u, wanneer wij de een van den ander zullen verborgen zijn! ");
INSERT INTO nld_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Zo gij mijn dochteren beledigt, en zo gij vrouwen neemt boven mijn dochteren, niemand is bij ons; zie toe, God zal getuige zijn tussen mij en tussen u! ");
INSERT INTO nld_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban zeide voorts tot Jakob: Zie, daar is deze zelfde hoop, en zie, daar is dit opgericht teken, hetwelk ik opgeworpen heb tussen mij en tussen u; ");
INSERT INTO nld_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Deze zelfde hoop zij getuige, en dit opgericht teken zij getuige, dat ik tot u voorbij dezen hoop niet komen zal, en dat gij tot mij, voorbij dezen hoop en dit opgericht teken, niet komen zult ten kwade! ");
INSERT INTO nld_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","De God van Abraham, en de God van Nahor, de God huns vaders richte tussen ons! En Jakob zwoer bij de Vreze zijn vaders Izaks. ");
INSERT INTO nld_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Toen slachtte Jakob een slachting op dat gebergte, en hij nodigde zijn broederen, om brood te eten; en zij aten brood, en vernachtten op dat gebergte. ");
INSERT INTO nld_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","En Laban stond des morgens vroeg op, en kuste zijn zonen, en zijn dochteren, en zegende hen; en Laban trok heen, en keerde weder tot zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakob toog ook zijns weegs; en de engelen Gods ontmoetten hem. ");
INSERT INTO nld_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","En Jakob zeide, met dat hij hen zag: Dit is een heirleger Gods! en hij noemde den naam derzelver plaats Mahanaim. ");
INSERT INTO nld_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","En Jakob zond boden uit voor zijn aangezicht tot Ezau, zijn broeder, naar het land Seir, de landstreek van Edom. ");
INSERT INTO nld_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","En hij gebood hun, zeggende: Zo zult gij zeggen tot mijn heer, tot Ezau: Zo zegt Jakob, uw knecht: Ik heb als vreemdeling gewoond bij Laban, en heb er tot nu toe vertoefd; ");
INSERT INTO nld_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","En ik heb ossen en ezelen, schapen en knechten en maagden; en ik heb gezonden om mijn heer aan te zeggen, opdat ik genade vinde in uw ogen. ");
INSERT INTO nld_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","En de boden kwamen weder tot Jakob, zeggende: Wij zijn gekomen tot uw broeder, tot Ezau; en ook trekt hij u tegemoet, en vierhonderd mannen met hem. ");
INSERT INTO nld_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Toen vreesde Jakob zeer, en hem was bange; en hij verdeelde het volk, dat met hem was, en de schapen, en de runderen, en de kemels, in twee heiren; ");
INSERT INTO nld_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Want hij zeide: Indien Ezau op het ene heir komt, en slaat het, zo zal het overgeblevene heir ontkomen. ");
INSERT INTO nld_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Voorts zeide Jakob: O, God mijns vaders Abrahams, en God mijns vaders Izaks, o HEERE! Die tot mij gezegd hebt: Keer weder tot uw land, en tot uw maagschap, en Ik zal wel bij u doen! ");
INSERT INTO nld_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ik ben geringer dan al deze weldadigheden, en dan al deze trouw, die Gij aan Uw knecht gedaan hebt; want ik ben met mijn staf over deze Jordaan gegaan, en nu ben ik tot twee heiren geworden! ");
INSERT INTO nld_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ruk mij toch uit mijns broeders hand, uit Ezau's hand; want ik vreze hem, dat hij niet misschien kome, en mij sla, de moeder met de zonen! ");
INSERT INTO nld_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gij hebt immers gezegd: Ik zal gewisselijk bij u weldoen, en Ik zal uw zaad stellen als het zand der zee, dat vanwege de menigte niet geteld kan worden! ");
INSERT INTO nld_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","En hij vernachtte aldaar dienzelfden nacht; en hij nam van hetgeen, dat hem in zijn hand kwam, een geschenk voor Ezau zijn broeder; ");
INSERT INTO nld_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Tweehonderd geiten en twintig bokken, tweehonderd ooien en twintig rammen; ");
INSERT INTO nld_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Dertig zogende kemelinnen met haar veulens, veertig koeien en tien varren, twintig ezelinnen en tien jonge ezels. ");
INSERT INTO nld_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","En hij gaf die in de hand zijner knechten, elke kudde bijzonder; en hij zeide tot zijn knechten: Gaat gijlieden door, voor mijn aangezicht, en stelt ruimte tussen kudde en tussen kudde. ");
INSERT INTO nld_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","En hij gebood de eerste, zeggende: Wanneer Ezau, mijn broeder, u ontmoeten zal, en u vragen, zeggende: Wiens zijt gij? en waarheen gaat gij? en wiens zijn deze voor uw aangezicht? ");
INSERT INTO nld_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Zo zult gij zeggen: Dat is een geschenk van uw knecht Jakob, gezonden tot mijn heer, tot Ezau, en zie, hij zelf is ook achter ons! ");
INSERT INTO nld_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","En hij gebood ook den tweede, ook den derde, ook allen, die de kudden nagingen, zeggende: Naar ditzelfde woord zult gij spreken tot Ezau, als gij hem vinden zult. ");
INSERT INTO nld_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","En gij zult ook zeggen: Zie, uw knecht Jakob is achter ons! Want hij zeide: Ik zal zijn aangezicht verzoenen met dit geschenk, dat voor mijn aangezicht gaat, en daarna zal ik zijn aangezicht zien; misschien zal hij mijn aangezicht aannemen. ");
INSERT INTO nld_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Alzo ging dat geschenk heen voor zijn aangezicht; doch hij zelf vernachtte dienzelfden nacht in het leger. ");
INSERT INTO nld_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","En hij stond op in dienzelfden nacht, en hij nam zijn twee vrouwen, en zijn twee dienstmaagden, en zijn elf kinderen, en hij toog over het veer van de Jabbok. ");
INSERT INTO nld_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","En hij nam ze, en deed hen over die beek trekken; en hij deed overtrekken hetgeen hij had. ");
INSERT INTO nld_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Doch Jakob bleef alleen over; en een man worstelde met hem, totdat de dageraad opging. ");
INSERT INTO nld_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","En toen Hij zag, dat Hij hem niet overmocht, roerde Hij het gewricht zijner heup aan, zodat het gewricht van Jakobs heup verwrongen werd, als Hij met hem worstelde. ");
INSERT INTO nld_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","En Hij zeide: Laat Mij gaan, want de dageraad is opgegaan. Maar hij zeide: Ik zal U niet laten gaan, tenzij dat Gij mij zegent. ");
INSERT INTO nld_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","En Hij zeide tot hem: Hoe is uw naam? En hij zeide: Jakob. ");
INSERT INTO nld_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Toen zeide Hij: Uw naam zal voortaan niet Jakob heten, maar Israel; want gij hebt u vorstelijk gedragen met God en met de mensen, en hebt overmocht. ");
INSERT INTO nld_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","En Jakob vraagde, en zeide: Geef toch Uw naam te kennen. En Hij zeide: Waarom is het, dat gij naar Mijn naam vraagt? En Hij zegende hem aldaar. ");
INSERT INTO nld_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","En Jakob noemde den naam dier plaats Pniel: Want, zeide hij, ik heb God gezien van aangezicht tot aangezicht, en mijn ziel is gered geweest. ");
INSERT INTO nld_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","En de zon rees hem op, als hij door Pniel gegaan was; en hij was hinkende aan zijn heup. ");
INSERT INTO nld_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Daarom eten de kinderen Israels de verrukte zenuw niet, die op het gewricht der heup is, tot op dezen dag, omdat Hij het gewricht van Jakobs heup aangeroerd had, aan de verrukte zenuw. ");
INSERT INTO nld_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","En Jakob hief zijn ogen op en zag; en ziet, Ezau kwam, en vierhonderd mannen met hem. Toen verdeelde hij de kinderen onder Lea, en onder Rachel, en onder de twee dienstmaagden. ");
INSERT INTO nld_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","En hij stelde de dienstmaagden en haar kinderen vooraan; en Lea en haar kinderen meer achterwaarts; maar Rachel en Jozef de achterste. ");
INSERT INTO nld_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","En hij ging voorbij hun aangezicht heen, en hij boog zich zeven malen ter aarde, totdat hij bij zijn broeder kwam. ");
INSERT INTO nld_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Toen liep Ezau hem tegemoet, en nam hem in den arm, en viel hem aan den hals, en kuste hem; en zij weenden. ");
INSERT INTO nld_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Daarna hief hij zijn ogen op, en zag die vrouwen en die kinderen, en zeide: Wie zijn deze bij u? En hij zeide: De kinderen, die God aan uw knecht genadiglijk verleend heeft. ");
INSERT INTO nld_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Toen traden de dienstmaagden toe, zij en haar kinderen, en zij bogen zich neder. ");
INSERT INTO nld_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","En Lea trad ook toe, met haar kinderen, en zij bogen zich neder; en daarna trad Jozef toe en Rachel, en zij bogen zich neder. ");
INSERT INTO nld_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","En hij zeide: Voor wien is u al dit heir, dat ik ontmoet heb? En hij zeide: Om genade te vinden in de ogen mijns heren! ");
INSERT INTO nld_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Maar Ezau zeide: Ik heb veel, mijn broeder! het zij het uwe, wat gij hebt! ");
INSERT INTO nld_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Toen zeide Jakob: Och neen! indien ik nu genade in uw ogen gevonden heb, zo neem mijn geschenk van mijn hand; daarom, omdat ik uw aangezicht gezien heb, als had ik Gods aangezicht gezien, en gij welgevallen aan mij genomen hebt. ");
INSERT INTO nld_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Neem toch mijn zegen, die u toegebracht is, dewijl het God mij genadiglijk verleend heeft, en dewijl ik alles heb; en hij hield bij hem aan, zodat hij het nam. ");
INSERT INTO nld_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","En hij zeide: Laat ons reizen en voorttrekken; en ik zal voor u trekken. ");
INSERT INTO nld_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Maar hij zeide tot hem: Mijn heer weet, dat deze kinderen teder zijn, en dat ik zogende schapen en koeien bij mij heb; indien men dezelve maar een dag afdrijft, zo zal de gehele kudde sterven. ");
INSERT INTO nld_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mijn heer trekke toch voorbij, voor het aangezicht van zijn knecht; en ik zal mij op mijn gemak als leidsman voegen, naar den gang van het werk, hetwelk voor mijn aangezicht is, en naar den gang dezer kinderen, totdat ik bij mijn heer te Seir kome. ");
INSERT INTO nld_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","En Ezau zeide: Laat mij toch van dit volk, dat met mij is, u bijstellen. En hij zeide: Waartoe dat? laat mij genade vinden in mijns heren ogen! ");
INSERT INTO nld_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Alzo keerde Ezau dien dag wederom zijns weegs naar Seir toe. ");
INSERT INTO nld_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Maar Jakob reisde naar Sukkoth, en bouwde een huis voor zich, en maakte hutten voor zijn vee; daarom noemde hij den naam dier plaats Sukkoth. ");
INSERT INTO nld_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","En Jakob kwam behouden tot de stad Sichem, welke is in het land Kanaan, als hij kwam van Paddan-Aram; en hij legerde zich in het gezicht der stad. ");
INSERT INTO nld_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","En hij kocht een deel des velds, waarop hij zijn tent gespannen had, van de hand der zonen van Hemor, den vader van Sichem, voor honderd stukken gelds. ");
INSERT INTO nld_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","En hij richte aldaar een altaar op, en noemde het: De God Israels is God! ");
INSERT INTO nld_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","En Dina, de dochter van Lea, die zij Jakob gebaard had, ging uit, om de dochteren van dat land te bezien. ");
INSERT INTO nld_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sichem nu, de zoon van Hemor den Heviet, den landvorst, zag haar, en hij nam ze, en lag bij haar, en verkrachtte ze. ");
INSERT INTO nld_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","En zijn ziel kleefde aan Dina, Jakobs dochter; en hij had de jonge dochter lief, en sprak naar het hart van de jonge dochter. ");
INSERT INTO nld_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sichem sprak ook tot zijn vader Hemor, zeggende: Neem mij deze dochter tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Toen Jakob hoorde, dat hij zijn dochter Dina verontreinigd had, zo waren zijn zonen met het vee in het veld; en Jakob zweeg, totdat zij kwamen. ");
INSERT INTO nld_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","En Hemor, de vader van Sichem, ging uit tot Jakob, om met hem te spreken. ");
INSERT INTO nld_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","En de zonen van Jakob kwamen van het veld, als zij dit hoorden; en het smartte dezen mannen, en zij ontstaken zeer, omdat hij dwaasheid in Israel gedaan had, Jakobs dochter beslapende, hetwelk alzo niet zoude gedaan worden. ");
INSERT INTO nld_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Toen sprak Hemor met hen, zeggende: Mijns zoons Sichems ziel is verliefd op ulieder dochter; geeft hem haar toch tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","En verzwagert u met ons; geeft ons uw dochteren; en neemt voor u onze dochteren; ");
INSERT INTO nld_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","En woont met ons; en het land zal voor uw aangezicht zijn; woont, en handelt daarin, en stelt u tot bezitters daarin. ");
INSERT INTO nld_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","En Sichem zeide tot haar vader, en tot haar broederen: Laat mij genade vinden in uw ogen; en wat gij tot mij zeggen zult, zal ik geven. ");
INSERT INTO nld_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Vergroot zeer over mij den bruidschat en het geschenk; en ik zal geven, gelijk als gij tot mij zult zeggen; geef mij slechts de jonge dochter tot een vrouw. ");
INSERT INTO nld_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Toen antwoordden Jakobs zonen aan Sichem en Hemor, zijn vader, bedriegelijk, en spraken (overmits dat hij Dina, hun zuster, verontreinigd had); ");
INSERT INTO nld_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","En zij zeiden tot hen: Wij zullen deze zaak niet kunnen doen, dat wij onze zuster aan een man geven zouden, die de voorhuid heeft; want dat ware ons een schande. ");
INSERT INTO nld_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Doch hierin zullen wij u te wille zijn, zo gij wordt gelijk als wij, dat onder u besneden worde al wat mannelijk is. ");
INSERT INTO nld_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dan zullen wij u onze dochteren geven, en uw dochteren zullen wij ons nemen, en wij zullen met u wonen, en wij zullen tot een volk zijn. ");
INSERT INTO nld_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Maar zo gij naar ons niet zult horen, om besneden te worden, zo zullen wij onze dochter nemen, en wegtrekken. ");
INSERT INTO nld_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","En hun woorden waren goed in de ogen van Hemor, en in de ogen van Sichem, Hemors zoon. ");
INSERT INTO nld_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","En de jongeling vertoogde niet, deze zaak te doen; want hij had lust in Jakobs dochter; en hij was geeerd boven al zijns vaders huis. ");
INSERT INTO nld_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Zo kwam Hemor en Sichem, zijn zoon, tot hunner stadspoort; en zij spraken tot de mannen hunner stad, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Deze mannen zijn vreedzaam met ons; daarom laat hen in dit land wonen, en daarin handelen, en het land (ziet het is wijd van begrip) voor hun aangezicht zijn; wij zullen ons hun dochteren tot vrouwen nemen, en wij zullen onze dochteren aan hen geven. ");
INSERT INTO nld_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Doch hierin zullen deze mannen ons te wille zijn, dat zij met ons wonen, om tot een volk te zijn; als al wat mannelijk is onder ons besneden wordt, gelijk als zij besneden zijn. ");
INSERT INTO nld_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hun vee, en hun bezitting, en al hun beesten, zullen die niet onze zijn? Alleen laat ons hun te wille zijn, en zij zullen met ons wonen. ");
INSERT INTO nld_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","En zij hoorden naar Hemor, en naar Sichem, zijn zoon, allen, die ter zijner stadspoort uitgingen; en zij werden besneden, al wat mannelijk was, allen, die ter zijner stadspoort uitgingen. ");
INSERT INTO nld_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","En het geschiedde ten derden dage, toen zij in de smart waren, zo namen de twee zonen van Jakob, Simeon en Levi, broeders van Dina, een iegelijk zijn zwaard, en kwamen stoutelijk in de stad, en doodden al wat mannelijk was. ");
INSERT INTO nld_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Zij sloegen ook Hemor, en zijn zoon Sichem, dood met de scherpte des zwaards; en zij namen Dina uit Sichems huis, en gingen van daar. ");
INSERT INTO nld_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","De zonen van Jakob kwamen over de verslagenen, en plunderden de stad, omdat zij hun zuster verontreinigd hadden. ");
INSERT INTO nld_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hun schapen, en hun runderen, en hun ezelen, en hetgeen dat in de stad, en hetgeen dat in het veld was, namen zij. ");
INSERT INTO nld_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","En al hun vermogen, en al hun kleine kinderen, en hun vrouwen, voerden zij gevankelijk weg, en plunderden dezelven, en al wat binnenshuis was. ");
INSERT INTO nld_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Toen zeide Jakob tot Simeon en tot Levi: Gij hebt mij beroerd, mits mij stinkende te maken onder de inwoners dezes lands, onder de Kanaanieten, en onder de Ferezieten; en ik ben weinig volks in getal; zo zij zich tegen mij verzamelen, zo zullen zij mij slaan, en ik zal verdelgd worden, ik en mijn huis. ");
INSERT INTO nld_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","En zij zeiden: Zou hij dan met onze zuster als met een hoer doen? ");
INSERT INTO nld_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Daarna zeide God tot Jakob: Maak u op, trek op naar Beth-El, en woon aldaar; en maak daar een altaar dien God, Die u verscheen, toen gij vluchttet voor het aangezicht van uw broeder Ezau. ");
INSERT INTO nld_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Toen zeide Jakob tot zijn huisgezin, en tot allen, die bij hem waren: Doet weg de vreemde goden, die in het midden van u zijn, en reinigt u, en verandert uw klederen; ");
INSERT INTO nld_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","En laat ons ons opmaken, en optrekken naar Beth-El; en ik zal daar een altaar maken dien God, Die mij antwoordt ten dage mijner benauwdheid, en met mij geweest is op den weg, die ik gewandeld heb. ");
INSERT INTO nld_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Toen gaven zij Jakob al die vreemde goden, die in hun hand waren, en de oorsierselen, die aan hun oren waren, en Jakob verborg ze onder den eikeboom, die bij Sichem is. ");
INSERT INTO nld_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","En zij reisden heen; en Gods verschrikking was over de steden, die rondom hen waren, zodat zij de zonen van Jakob niet achterna jaagden. ");
INSERT INTO nld_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Alzo kwam Jakob te Luz, hetwelk is in het land Kanaan (dat is Beth-El), hij en al het volk, dat bij hem was. ");
INSERT INTO nld_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","En hij bouwde aldaar een altaar, en noemde die plaats El Beth-El; want God was hem aldaar geopenbaard geweest, als hij voor zijns broeders aangezicht vlood. ");
INSERT INTO nld_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","En Debora, de voedster van Rebekka, stierf, en zij werd begraven onder aan Beth-El; onder dien eik, welks naam hij noemde Allon-Bachuth. ");
INSERT INTO nld_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","En God verscheen Jakob wederom, als hij van Paddan-Aram gekomen was; en Hij zegende hem. ");
INSERT INTO nld_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","En God zeide tot hem: Uw naam is Jakob, uw naam zal voortaan niet Jakob genoemd worden, maar Israel zal uw naam zijn; en Hij noemde zijn naam Israel. ");
INSERT INTO nld_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Voorts zeide God tot hem: Ik ben God de Almachtige! wees vruchtbaar, en vermenigvuldig! Een volk, ja, een hoop der volken zal uit u worden, en koningen zullen uit uw lenden voortkomen. ");
INSERT INTO nld_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","En dit land, dat Ik aan Abraham en Izak gegeven heb, dat zal Ik u geven; en aan uw zaad na u zal Ik dit land geven. ");
INSERT INTO nld_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Toen voer God van hem op in die plaats, waar Hij met hem gesproken had. ");
INSERT INTO nld_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","En Jakob stelde een opgericht teken op in die plaats, waar Hij met hem gesproken had, een stenen opgericht teken; en hij stortte daarop drankoffer, en goot olie daarover. ");
INSERT INTO nld_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","En Jakob noemde den naam dier plaats, alwaar God met hem gesproken had, Beth-El. ");
INSERT INTO nld_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","En zij reisden van Beth-El; en er was nog een kleine streek lands om tot Efrath te komen; en Rachel baarde, en zij had het hard in haar baren. ");
INSERT INTO nld_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","En het geschiedde, als zij het hard had in haar baren, zo zeide de vroedvrouw tot haar: Vrees niet; want dezen zoon zult gij ook hebben! ");
INSERT INTO nld_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","En het geschiedde, als haar ziel uitging (want zij stierf), dat zij zijn naam noemde Ben-oni; maar zijn vader noemde hem Benjamin. ");
INSERT INTO nld_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Alzo stierf Rachel; en zij werd begraven aan den weg naar Efrath, hetwelk is Bethlehem. ");
INSERT INTO nld_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","En Jakob richtte een gedenkteken op boven haar graf, dit is het gedenkteken van Rachels graf tot op dezen dag. ");
INSERT INTO nld_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Toen verreisde Israel, en hij spande zijn tent op gene zijde van Migdal-Eder. ");
INSERT INTO nld_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","En het geschiedde, als Israel in dat land woonde, dat Ruben heenging, en lag bij Bilha, zijns vaders bijwijf; en Israel hoorde het. En de zonen van Jakob waren twaalf. ");
INSERT INTO nld_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","De zonen van Lea waren: Ruben, Jakobs eerstgeborene, daarna Simeon, en Levi, en Juda, en Issaschar, en Zebulon. ");
INSERT INTO nld_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","De zonen van Rachel: Jozef en Benjamin. ");
INSERT INTO nld_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","En de zonen van Bilha, Rachels dienstmaagd: Dan en Nafthali. ");
INSERT INTO nld_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","En de zonen van Zilpa, Lea's dienstmaagd: Gad en Aser. Deze zijn de zonen van Jakob, die hem geboren zijn in Paddan-Aram. ");
INSERT INTO nld_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","En Jakob kwam tot Izak, zijn vader, in Mamre, te Kirjath-Arba, hetwelk is Hebron, waar Abraham als vreemdeling had verkeerd, en Izak. ");
INSERT INTO nld_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","En de dagen van Izak waren honderd jaren, en tachtig jaren. ");
INSERT INTO nld_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","En Izak gaf den geest en stierf, en werd verzameld tot zijn volken, oud en zat van dagen; en zijn zonen Ezau en Jakob begroeven hem. ");
INSERT INTO nld_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dit nu zijn de geboorten van Ezau, welke is Edom. ");
INSERT INTO nld_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezau nam zijn vrouwen uit de dochteren van Kanaan, Ada, de dochter van Elon, den Hethiet, en Aholibama, de dochter van Ana, de dochter van Zibeon, den Heviet; ");
INSERT INTO nld_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","En Basmath, de dochter van Ismael, zuster van Nebajoth. ");
INSERT INTO nld_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nu baarde aan Ezau Elifaz, en Basmath baarde Rehuel. ");
INSERT INTO nld_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","En Aholibama baarde Jehus, en Jaelam, en Korah. Dit zijn de zonen van Ezau, die hem geboren zijn in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ezau nu had genomen zijn vrouwen, en zijn zonen, en zijn dochters, en al de zielen zijns huizes, en zijn vee, en al zijn beesten, en al zijn bezitting, die hij in het land Kanaan geworven had, en was vertrokken naar een ander land, van het aangezicht van zijn broeder Jakob. ");
INSERT INTO nld_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Want hun have was te veel, om samen te wonen; en het land hunner vreemdelingschappen kon ze niet dragen vanwege hun vee. ");
INSERT INTO nld_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Derhalve woonde Ezau op het gebergte Seir. Ezau is Edom. ");
INSERT INTO nld_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dit nu zijn de geboorten van Ezau, den vader der Edomieten, op het gebergte van Seir. ");
INSERT INTO nld_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dit zijn de namen der zonen van Ezau: Elifaz, de zoon van Ada, Ezau's huisvrouw; Rehuel, de zoon van Basmath, Ezau's huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","En de zonen van Elifaz waren: Teman, Omar, Zefo, en Gaetam, en Kenaz. ");
INSERT INTO nld_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","En Timna was een bijwijf van Elifaz, den zoon van Ezau, en zij baarde aan Elifaz Amalek; dit zijn de zonen van Ada, Ezau's huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","En dit zijn de zonen van Rehuel: Nahath, en Zerah, Samma en Mizza; dat zijn geweest de zonen van Basmath, Ezau's huisvrouw. ");
INSERT INTO nld_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","En dit zijn geweest de zonen van Aholibama, dochter van Ana, dochter van Zibeon, Ezau's huisvrouw; en zij baarde aan Ezau Jehus, en Jaelam, en Korah. ");
INSERT INTO nld_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dit zijn de vorsten der zonen van Ezau: de zonen van Elifaz, den eerstgeborene van Ezau, waren: de vorst Teman, de vorst Omar, de vorst Zefo, de vorst Kenaz. ");
INSERT INTO nld_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","De vorst Korah, de vorst Gaetam, de vorst Amalek; dat zijn de vorsten van Elifaz in het land Edom; dat zijn de zonen van Ada. ");
INSERT INTO nld_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","En dit zijn de zonen van Rehuel, den zoon van Ezau: de vorst Nahath, de vorst Zerah, de vorst Samma, de vorst Mizza; dat zijn de vorsten van Rehuel in het land Edom; dat zijn de zonen van Basmath, de huisvrouw van Ezau. ");
INSERT INTO nld_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","En dit zijn de zonen van Aholibama, de huisvrouw van Ezau: de vorst Jehus, de vorst Jaelam, de vorst Korah; dat zijn de vorsten van Aholibama, de dochter van Ana, de huisvrouw van Ezau. ");
INSERT INTO nld_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dat zijn de zonen van Ezau, en dat zijn hunlieder vorsten; hij is Edom. ");
INSERT INTO nld_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Dit zijn de zonen van Seir, den Horiet, inwoners van dat land: Lotan, en Sobal, en Zibeon, en Ana, ");
INSERT INTO nld_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","En Dison, en Ezer, en Disan; dat zijn de vorsten der Horieten, zonen van Seir, in het land van Edom. ");
INSERT INTO nld_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","En de zonen van Lotan waren Hori en Hemam; en Lotans zuster was Timna. ");
INSERT INTO nld_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","En dit zijn de zonen van Sobal: Alvan en Manahath, en Ebal, en Sefo, en Onam. ");
INSERT INTO nld_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","En dit zijn de zonen van Zibeon: Aja en Ana, hij is die Ana, die de muilen in de woestijn gevonden heeft, toen hij de ezels van zijn vader Zibeon weidde. ");
INSERT INTO nld_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","En dit zijn de zonen van Ana: Dison; en Aholibama was de dochter van Ana. ");
INSERT INTO nld_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","En dit zijn de zonen van Dison: Hemdan, en Esban, en Ithran, en Cheran. ");
INSERT INTO nld_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dit zijn de zonen van Ezer: Bilhan, en Zaavan, en Akan. ");
INSERT INTO nld_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dit zijn de zonen van Disan: Uz en Aran. ");
INSERT INTO nld_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dit zijn de vorsten der Horieten: de vorst Lotan, de vorst Sobal, de vorst Zibeon, de vorst Ana. ");
INSERT INTO nld_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","De vorst Dison, de vorst Ezer, de vorst Disan; dit zijn de vorsten der Horieten, naar hun vorsten in het land Seir. ");
INSERT INTO nld_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","En dit zijn koningen, die geregeerd hebben in het land Edom, eer een koning regeerde over de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela dan, de zoon van Beor, regeerde in Edom, en de naam zijner stad was Dinhaba. ");
INSERT INTO nld_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","En Bela stierf, en Jobab, de zoon van Zerah, van Bozra, regeerde in zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","En Jobab stierf, en Husam, uit der Temanieten land, regeerde in zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","En Husam stierf, en in zijn plaats regeerde Hadad, de zoon van Bedad, die Midian versloeg in het veld van Moab; en de naam zijner stad was Avith. ");
INSERT INTO nld_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","En Hadad stierf, en Samla, van Masreka, regeerde in zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","En Samla stierf, en Saul van Rehoboth, aan de rivier, regeerde in zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","En Saul stierf, en Baal-Hanan, de zoon van Achbor, regeerde in zijn plaats. ");
INSERT INTO nld_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","En Baal-Hanan, de zoon van Achbor, stierf, en Hadar regeerde in zijn plaats; en de naam zijner stad was Pahu; en de naam zijner huisvrouw was Mechetabeel, een dochter van Matred, de dochter van Me-zahab. ");
INSERT INTO nld_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","En dit zijn de namen der vorsten van Ezau, naar hun geslachten, naar hun plaatsen, met hun namen: de vorst Timna, de vorst Alva, de vorst Jetheth, ");
INSERT INTO nld_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","De vorst Aholibama, de vorst Ela, de vorst Pinon, ");
INSERT INTO nld_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","De vorst Kenaz, de vorst Teman, de vorst Mibzar, ");
INSERT INTO nld_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","De vorst Magdiel, de vorst Iram; dit zijn de vorsten van Edom, naar hun woningen, in het land hunner bezitting; hij is Ezau, de vader van Edom. ");
INSERT INTO nld_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","En Jakob woonde in het land der vreemdelingschappen zijns vaders, in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dit zijn Jakobs geschiedenissen. Jozef, zijnde een zoon van zeventien jaren, weidde de kudde met zijn broeders (en hij was een jongeling), met de zonen van Bilha, en de zonen van Zilpa, zijns vaders vrouwen; en Jozef bracht hun kwaad gerucht tot hun vader. ");
INSERT INTO nld_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","En Israel had Jozef lief, boven al zijn zonen; want hij was hem een zoon des ouderdoms; en hij maakte hem een veelvervigen rok. ");
INSERT INTO nld_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Als nu zijn broeders zagen, dat hun vader hem boven al zijn broederen liefhad, haatten zij hem, en konden hem niet vredelijk toespreken. ");
INSERT INTO nld_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ook droomde Jozef een droom, dien hij aan zijn broederen vertelde; daarom haatten zij hem nog te meer. ");
INSERT INTO nld_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","En hij zeide tot hen: Hoort toch dezen droom, dien ik gedroomd heb. ");
INSERT INTO nld_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","En ziet, wij waren schoven bindende in het midden des velds; en ziet, mijn schoof stond op, en bleef ook staande; en ziet, uw schoven kwamen rondom, en bogen zich neder voor mijn schoof. ");
INSERT INTO nld_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Toen zeiden zijn broeders tot hem: Zult gij dan ganselijk over ons regeren: zult gij dan ganselijk over ons heersen? Zo haatten zij hem nog te meer, om zijn dromen en om zijn woorden. ");
INSERT INTO nld_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","En hij droomde nog een anderen droom, en verhaalde dien aan zijn broederen; en hij zeide: Ziet, ik heb nog een droom gedroomd, en ziet, de zon, en de maan, en elf sterren bogen zich voor mij neder. ");
INSERT INTO nld_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","En als hij het aan zijn vader en aan zijn broederen verhaalde, bestrafte hem zijn vader, en zeide tot hem: Wat is dit voor een droom, dien gij gedroomd hebt; zullen wij dan ganselijk komen, ik, en uw moeder, en uw broeders, om ons voor u ter aarde te buigen? ");
INSERT INTO nld_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Zijn broeders dan benijdden hem; doch zijn vader bewaarde deze zaak. ");
INSERT INTO nld_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","En zijn broeders gingen heen, om de kudde van hun vader te weiden bij Sichem. ");
INSERT INTO nld_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Zo zeide Israel tot Jozef: Weiden uw broeders niet bij Sichem? Kom, dat ik u tot hen zende. En hij zeide tot hem: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","En hij zeide tot hem: Ga toch heen, zie naar den welstand van uw broederen, en naar den welstand van de kudde, en breng mij een woord wederom. Zo zond hij hem uit het dal Hebron, en hij kwam te Sichem. ");
INSERT INTO nld_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","En een man vond hem (want ziet, hij was dwalende in het veld); zo vraagde hem deze man, zeggende: Wat zoekt gij? ");
INSERT INTO nld_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","En hij zeide: Ik zoek mijn broederen; geef mij toch te kennen, waar zij weiden. ");
INSERT INTO nld_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Zo zeide die man: Zij zijn van hier gereisd; want ik hoorde hen zeggen: Laat ons naar Dothan gaan. Jozef dan ging zijn broederen na, en vond hen te Dothan. ");
INSERT INTO nld_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","En zij zagen hem van verre; en eer hij tot hen naderde, sloegen zij tegen hem een listigen raad, om hem te doden. ");
INSERT INTO nld_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","En zij zeiden de een tot den ander: Ziet, daar komt die meesterdromer aan! ");
INSERT INTO nld_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nu komt dan, en laat ons hem doodslaan, en hem in een dezer kuilen werpen; en wij zullen zeggen: een boos dier heeft hem opgegeten; zo zullen wij zien, wat van zijn dromen worden zal. ");
INSERT INTO nld_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben hoorde dat, en verloste hem uit hun hand; en hij zeide: Laat ons hem niet aan het leven slaan. ");
INSERT INTO nld_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ook zeide Ruben tot hen: Vergiet geen bloed; werpt hem in dezen kuil die in de woestijn is, en legt de hand niet aan hem; opdat hij hem uit hun hand verloste, om hem tot zijn vader weder te brengen. ");
INSERT INTO nld_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","En het geschiedde, als Jozef tot zijn broederen kwam, zo togen zij Jozef zijn rok uit, den veelvervigen rok, dien hij aanhad. ");
INSERT INTO nld_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","En zij namen hem, en wierpen hem in den kuil; doch de kuil was ledig; er was geen water in. ");
INSERT INTO nld_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Daarna zaten zij neder om brood te eten, en hieven hun ogen op, en zagen, en ziet, een reisgezelschap van Ismaelieten kwam uit Gilead; en hun kemelen droegen specerijen en balsem, en mirre, reizende, om dat af te brengen naar Egypte. ");
INSERT INTO nld_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Toen zeide Juda tot zijn broederen: Wat gewin zal het zijn, dat wij onzen broeder doodslaan, en zijn bloed verbergen? ");
INSERT INTO nld_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Komt, en laat ons hem aan deze Ismaelieten verkopen, en onze hand zij niet aan hem; want hij is onze broeder, ons vlees, en zijn broederen hoorden hem. ");
INSERT INTO nld_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Als nu de Midianietische kooplieden voorbijtogen, zo trokken en hieven zij Jozef op uit den kuil, en verkochten Jozef aan deze Ismaelieten voor twintig zilverlingen; die brachten Jozef naar Egypte. ");
INSERT INTO nld_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Als nu Ruben tot den kuil wederkeerde, ziet, zo was Jozef niet in den kuil; toen scheurde hij zijn klederen. ");
INSERT INTO nld_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","En hij keerde weder tot zijn broederen, en zeide: De jongeling is er niet; en ik, waar zal ik heengaan? ");
INSERT INTO nld_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Toen namen zij Jozefs rok, en zij slachtten een geitenbok, en zij doopten den rok in het bloed. ");
INSERT INTO nld_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","En zij zonden den veelvervigen rok, en deden hem tot hun vader brengen, en zeiden: Dezen hebben wij gevonden; beken toch, of deze uws zoons rok zij, of niet. ");
INSERT INTO nld_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","En hij bekende hem, en zeide: Het is mijns zoons rok! een boos dier heeft hem opgegeten! voorzeker is Jozef verscheurd! ");
INSERT INTO nld_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Toen scheurde Jakob zijn klederen, en legde een zak om zijn lenden; en hij bedreef rouw over zijn zoon vele dagen. ");
INSERT INTO nld_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","En al zijn zonen, en al zijn dochteren maakten zich op, om hem te troosten; maar hij weigerde zich te laten troosten, en zeide: Want ik zal, rouw bedrijvende, tot mijn zoon in het graf nederdalen. Alzo beweende hem zijn vader. ");
INSERT INTO nld_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","En de Midianieten verkochten hem in Egypte, aan Potifar, een hoveling van Farao, overste der trawanten. ");
INSERT INTO nld_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En het geschiedde ten zelven tijde, dat Juda van zijn broederen aftoog, en hij keerde in tot een man van Adullam, wiens naam was Hira. ");
INSERT INTO nld_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","En Juda zag aldaar de dochter van een Kanaanietisch man, wiens naam was Sua; en hij nam haar, en ging tot haar in. ");
INSERT INTO nld_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","En zij werd bevrucht, en baarde een zoon, en hij noemde zijn naam Er. ");
INSERT INTO nld_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Daarna werd zij weder bevrucht, en baarde een zoon, en zij noemde zijn naam Onan. ");
INSERT INTO nld_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","En zij voer nog voort, en baarde een zoon, en noemde zijn naam Sela; doch hij was te Chezib, toen zij hem baarde. ");
INSERT INTO nld_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda nu nam een vrouw voor Er, zijn eerstgeborene, en haar naam was Thamar. ");
INSERT INTO nld_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Maar Er, de eerstgeborene van Juda, was kwaad in des HEEREN ogen; daarom doodde hem de HEERE. ");
INSERT INTO nld_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Toen zeide Juda tot Onan: Ga in tot uws broeders huisvrouw, en trouw haar in uws broeders naam, en verwek uw broeder zaad. ");
INSERT INTO nld_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Doch Onan, wetende, dat dit zaad voor hem niet zoude zijn, zo geschiedde het, als hij tot zijns broeders huisvrouw inging, dat hij het verdierf tegen de aarde, om zijn broeder geen zaad te geven. ");
INSERT INTO nld_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","En het was kwaad in des HEEREN ogen, wat hij deed; daarom doodde Hij hem ook. ");
INSERT INTO nld_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Toen zeide Juda tot Thamar, zijn schoondochter: Blijf weduwe in uws vaders huis, totdat mijn zoon Sela groot wordt; want hij zeide: Dat niet misschien ook deze sterve, gelijk zijn broeders! Zo ging Thamar heen, en bleef in haar vaders huis. ");
INSERT INTO nld_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Als nu vele dagen verlopen waren, stierf de dochter van Sua, de huisvrouw van Juda; daarna troostte zich Juda, en ging op tot zijn schaapscheerders naar Timna toe, hij en Hira, zijn vriend, de Adullamiet. ");
INSERT INTO nld_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","En men gaf Thamar te kennen, zeggende: Zie, uw schoonvader gaat op naar Timna, om zijn schapen te scheren. ");
INSERT INTO nld_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Toen leide zij de klederen van haar weduwschap van zich af, en zij bedekte zich met een sluier, en bewond zich, en zette zich aan den ingang der twee fonteinen, die op den weg naar Timna is; want zij zag, dat Sela groot geworden was, en zij hem niet ter vrouw was gegeven. ");
INSERT INTO nld_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Als Juda haar zag, zo hield hij haar voor een hoer, overmits zij haar aangezicht bedekt had. ");
INSERT INTO nld_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","En hij week tot haar naar den weg, en zeide: Kom toch, laat mij tot u ingaan; want hij wist niet, dat zij zijn schoondochter was. En zij zeide: Wat zult gij mij geven, dat gij tot mij ingaat? ");
INSERT INTO nld_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","En hij zeide: Ik zal u een geitenbok van de kudde zenden. En zij zeide: Zo gij pand zult geven, totdat gij hem zendt. ");
INSERT INTO nld_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Toen zeide hij: Wat pand is het, dat ik u geven zal? En zij zeide: Uw zegelring en uw snoer en uw staf, die in uw hand is; hetwelk hij haar gaf, en ging tot haar in; en zij ontving bij hem. ");
INSERT INTO nld_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","En zij maakte zich op, en ging heen, en leide haar sluier van zich af, en zij trok aan de klederen van haar weduwschap. ");
INSERT INTO nld_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","En Juda zond den geitenbok door de hand van zijn vriend, den Adullamiet, om het pand uit de hand der vrouw te nemen; maar hij vond haar niet. ");
INSERT INTO nld_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","En hij vraagde de lieden van haar plaats, zeggende: Waar is de hoer, die bij deze twee fonteinen aan den weg was? En zij zeiden: Hier is geen hoer geweest. ");
INSERT INTO nld_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","En hij keerde weder tot Juda, en zeide: Ik heb haar niet gevonden; en ook zeiden de lieden van die plaats: Hier is geen hoer geweest. ");
INSERT INTO nld_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Toen zeide Juda: Zij neme het voor zich, opdat wij misschien niet tot verachting worden; zie, ik heb dezen bok gezonden; maar gij hebt haar niet gevonden. ");
INSERT INTO nld_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","En het geschiedde omtrent na drie maanden, dat men Juda te kennen gaf, zeggende: Thamar, uw schoondochter, heeft gehoereerd, en ook zie, zij is zwanger van hoererij. Toen zeide Juda: Breng ze hervoor, dat zij verbrand worde! ");
INSERT INTO nld_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Als zij voorgebracht werd, schikte zij tot haar schoonvader, om te zeggen: Bij den man, wiens deze dingen zijn, ben ik zwanger; en zij zeide: Beken toch, wiens deze zegelring, en deze snoeren, en deze staf zijn. ");
INSERT INTO nld_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","En Juda kende ze, en zeide: Zij is rechtvaardiger dan ik, daarom, omdat ik haar aan mijn zoon Sela niet gegeven heb. En hij bekende haar voortaan niet meer. ");
INSERT INTO nld_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","En het geschiedde ten tijde, als zij baren zou, ziet, zo waren tweelingen in haar buik. ");
INSERT INTO nld_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","En het geschiedde, als zij baarde, dat een de hand uitgaf; en de vroedvrouw nam dezelve, en zij bond een scharlaken draad om zijn hand, zeggende: Deze komt het eerst uit. ");
INSERT INTO nld_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Maar het geschiedde, als hij zijn hand weder intoog, ziet, zo kwam zijn broeder uit; en zij zeide: Hoe zijt gij doorgebroken? op u is de breuke! en men noemde zijn naam Perez. ");
INSERT INTO nld_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","En daarna kwam zijn broeder uit, om wiens hand de scharlaken draad was; en men noemde zijn naam Zera. ");
INSERT INTO nld_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jozef nu werd naar Egypte afgevoerd; en Potifar, een hoveling van Farao, een overste der trawanten, een Egyptisch man, kocht hem uit de hand der Ismaelieten, die hem derwaarts afgevoerd hadden. ");
INSERT INTO nld_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","En de HEERE was met Jozef, zodat hij een voorspoedig man was; en hij was in het huis van zijn heer, den Egyptenaar. ");
INSERT INTO nld_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Als nu zijn heer zag, dat de HEERE met hem was, en dat de HEERE al wat hij deed, door zijn hand voorspoedig maakte; ");
INSERT INTO nld_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Zo vond Jozef genade in zijn ogen, en diende hem; en hij stelde hem over zijn huis; en al wat hij had, gaf hij in zijn hand. ");
INSERT INTO nld_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","En het geschiedde van toen af, dat hij hem over zijn huis, en over al wat het zijne was, gesteld had, dat de HEERE des Egyptenaars huis zegende, om Jozefs wil; ja, de zegen des HEEREN was in alles, wat hij had, in het huis en in het veld. ");
INSERT INTO nld_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","En hij liet alles, wat hij had, in Jozefs hand, zodat hij met hem van geen ding kennis had, behalve van het brood, dat hij at. En Jozef was schoon van gedaante, en schoon van aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","En het geschiedde na deze dingen, dat de huisvrouw zijns heren haar ogen op Jozef wierp; en zij zeide: lig bij mij! ");
INSERT INTO nld_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maar hij weigerde het, en zeide tot de huisvrouw zijns heren: Zie, mijn heer heeft geen kennis met mij, wat er in het huis is; en al wat hij heeft, dat heeft hij in mijn hand gegeven. ");
INSERT INTO nld_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Niemand is groter in dit huis dan ik, en hij heeft voor mij niets onthouden, dan u, daarin dat gij zijn huisvrouw zijt; hoe zoude ik dan dit een zo groot kwaad doen, en zondigen tegen God! ");
INSERT INTO nld_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","En het geschiedde, als zij Jozef dag op dag aansprak, en hij naar haar niet hoorde, om bij haar te liggen, en bij haar te zijn; ");
INSERT INTO nld_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Zo gebeurde het op zulk een dag, dat hij in het huis kwam, om zijn werk te doen; en niemand van de lieden des huizes was daar binnenshuis. ");
INSERT INTO nld_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","En zij greep hem bij zijn kleed, zeggende: Lig bij mij! En hij liet zijn kleed in haar hand, en vluchtte, en ging uit naar buiten. ");
INSERT INTO nld_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","En het geschiedde, als zij zag, dat hij zijn kleed in haar hand gelaten had, en naar buiten gevlucht was; ");
INSERT INTO nld_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Zo riep zij de lieden van haar huis, en sprak tot hen, zeggende: Ziet, hij heeft ons den Hebreeuwsen man ingebracht, om met ons te spotten; hij is tot mij gekomen, om bij mij te liggen, en ik heb geroepen met luider stem; ");
INSERT INTO nld_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","En het geschiedde, als hij hoorde, dat ik mijn stem verhief, en riep, zo verliet hij zijn kleed bij mij, en vluchtte, en ging uit naar buiten. ");
INSERT INTO nld_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","En zij leide zijn kleed bij zich, totdat zijn heer in zijn huis kwam. ");
INSERT INTO nld_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Toen sprak zij tot hem naar diezelfde woorden, zeggende: De Hebreeuwse knecht, dien gij ons hebt ingebracht, is tot mij gekomen, om met mij te spotten. ");
INSERT INTO nld_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","En het is geschied, als ik mijn stem verhief, en riep, dat hij zijn kleed bij mij liet, en vluchtte naar buiten. ");
INSERT INTO nld_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","En het geschiedde, als zijn heer de woorden zijner huisvrouw hoorde, die zij tot hem sprak, zeggende: Naar deze zelfde woorden heeft mij uw knecht gedaan, zo ontstak zijn toorn. ");
INSERT INTO nld_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","En Jozefs heer nam hem, en leverde hem in het gevangenhuis, ter plaatse, waar des konings gevangenen gevangen waren; alzo was hij daar in het gevangenhuis. ");
INSERT INTO nld_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Doch de HEERE was met Jozef, en wende Zijn goedertierenheid tot hem; en gaf hem genade in de ogen van den overste van het gevangenhuis. ");
INSERT INTO nld_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","En de overste van het gevangenhuis gaf al de gevangenen, die in het gevangenhuis waren, in Jozefs hand; en al wat zij daar deden, deed hij. ");
INSERT INTO nld_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","De overste van het gevangenhuis zag gans op geen ding, dat in zijn hand was, overmits dat de HEERE met hem was; en wat hij deed, dat deed de HEERE wel gedijen. ");
INSERT INTO nld_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","En het geschiedde na deze dingen, dat de schenker des konings van Egypte, en de bakker, zondigden tegen hun heer, tegen den koning van Egypte. ");
INSERT INTO nld_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Zodat Farao zeer toornig werd op zijn twee hovelingen, op den overste der schenkers, en op den overste der bakkers. ");
INSERT INTO nld_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","En hij leverde hen in bewaring, ten huize van den overste der trawanten, in het gevangenhuis, ter plaatse, waar Jozef gevangen was. ");
INSERT INTO nld_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","En de overste der trawanten bestelde Jozef bij hen, dat hij hen diende; en zij waren sommige dagen in bewaring. ");
INSERT INTO nld_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Zij droomden nu beiden een droom, elk zijn droom, in een nacht, elk naar de uitlegging zijns drooms, de schenker en de bakker, die des konings van Egypte waren, die gevangen waren in het gevangenhuis. ");
INSERT INTO nld_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","En Jozef kwam des morgens tot hen, en hij zag hen aan, en ziet, zij waren ontsteld. ");
INSERT INTO nld_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Toen vraagde hij de hovelingen van Farao, die bij hem waren in hechtenis van het huis zijns heren, zeggende: Waarom zijn uw aangezichten heden kwalijk gesteld? ");
INSERT INTO nld_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","En zij zeiden tot hem: Wij hebben een droom gedroomd, en er is niemand, die hem uitlegge. En Jozef zeide tot hen: Zijn de uitleggingen niet van God? Vertelt ze mij toch. ");
INSERT INTO nld_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Toen vertelde de overste der schenkers Jozef zijn droom, en zeide tot hem: In mijn droom, zie, zo was een wijnstok voor mijn aangezicht; ");
INSERT INTO nld_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","En aan den wijnstok waren drie ranken; en hij was als bottende, zijn bloeisel ging op, zijn trossen brachten rijpe druiven voort. ");
INSERT INTO nld_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","En Farao's beker was in mijn hand; en ik nam die druiven, en drukte ze uit in Farao's beker, en ik gaf den beker op Farao's hand. ");
INSERT INTO nld_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Toen zeide Jozef tot hem: Dit is zijn uitlegging: de drie ranken zijn drie dagen. ");
INSERT INTO nld_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Binnen nog drie dagen zal Farao uw hoofd verheffen, en zal u in uw staat herstellen; en gij zult Farao's beker in zijn hand geven, naar de vorige wijze, toen gij zijn schenker waart. ");
INSERT INTO nld_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Doch gedenk mijner bij uzelven, wanneer het u wel gaan zal, en doe toch weldadigheid aan mij, en doe van mij melding bij Farao, en maak, dat ik uit dit huis kome. ");
INSERT INTO nld_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Want ik ben diefelijk ontstolen uit het land der Hebreen; en ook heb ik hier niets gedaan, dat zij mij in dezen kuil gezet hebben. ");
INSERT INTO nld_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Toen de overste der bakkers zag, dat hij een goede uitlegging gedaan had, zo zeide hij tot Jozef: Ik was ook in mijn droom, en zie, drie getraliede korven waren op mijn hoofd. ");
INSERT INTO nld_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","En in den oppersten korf was van alle spijze van Farao, die bakkerswerk is; en het gevogelte at dezelve uit den korf, van boven mijn hoofd. ");
INSERT INTO nld_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Toen antwoordde Jozef, en zeide: Dit is zijn uitlegging: de drie korven zijn drie dagen. ");
INSERT INTO nld_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Binnen nog drie dagen zal Farao uw hoofd verheffen van boven u, en hij zal u aan een hout hangen, en het gevogelte zal uw vlees van boven u eten. ");
INSERT INTO nld_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","En het geschiedde op den derden dag, den dag van Farao's geboorte, dat hij voor al zijn knechten een maaltijd maakte; en hij verhief het hoofd van den overste der schenkers, en het hoofd van den overste der bakkers, in het midden zijner knechten. ");
INSERT INTO nld_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","En hij deed den overste der schenkers wederkeren tot zijn schenkambt, zodat hij den beker op Farao's hand gaf. ");
INSERT INTO nld_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Maar den overste der bakkers hing hij op; gelijk Jozef hun uitgelegd had. ");
INSERT INTO nld_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Doch de overste der schenkers gedacht aan Jozef niet, maar vergat hem. ");
INSERT INTO nld_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","En het geschiedde ten einde van twee volle jaren, dat Farao droomde, en ziet, hij stond aan de rivier. ");
INSERT INTO nld_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","En ziet, uit de rivier kwamen op zeven koeien, schoon van aanzien, en vet van vlees, en zij weidden in het gras. ");
INSERT INTO nld_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","En ziet, zeven andere koeien kwamen na die op uit de rivier, lelijk van aanzien, en dun van vlees; en zij stonden bij de andere koeien aan den oever der rivier. ");
INSERT INTO nld_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","En die koeien, lelijk van aanzien, en dun van vlees, aten op die zeven koeien, schoon van aanzien en vet. Toen ontwaakte Farao. ");
INSERT INTO nld_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Daarna sliep hij en droomde andermaal; en ziet, zeven aren rezen op, in een halm, vet en goed. ");
INSERT INTO nld_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","En ziet, zeven dunne en van den oostenwind verzengde aren schoten na dezelve uit. ");
INSERT INTO nld_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","En de dunne aren verslonden de zeven vette en volle aren. Toen ontwaakte Farao, en ziet, het was een droom. ");
INSERT INTO nld_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","En het geschiedde in den morgenstond, dat zijn geest verslagen was, en hij zond heen, en riep al de tovenaars van Egypte, en al de wijzen, die daarin waren; en Farao vertelde hun zijn droom; maar er was niemand, die ze aan Farao uitlegde. ");
INSERT INTO nld_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Toen sprak de overste der schenkers tot Farao, zeggende: Ik gedenk heden aan mijn zonden. ");
INSERT INTO nld_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao was zeer vertoornd op zijn dienaars, en leverde mij in bewaring ten huize van den overste der trawanten, mij en den overste der bakkers. ");
INSERT INTO nld_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","En in een nacht droomden wij een droom, ik en hij; wij droomden elk naar de uitlegging zijns drooms. ");
INSERT INTO nld_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","En aldaar was bij ons een Hebreeuws jongeling, een knecht van den overste der trawanten; en wij vertelden ze hem, en hij leide ons onze dromen uit; een ieder leide hij ze uit, naar zijn droom. ");
INSERT INTO nld_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","En gelijk hij ons uitleide, alzo is het geschied; mij heeft hij hersteld in mijn staat, en hem gehangen. ");
INSERT INTO nld_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Toen zond Farao en riep Jozef en zij deden hem haastelijk uit den kuil komen; en men schoor hem, en men veranderde zijn klederen; en hij kwam tot Farao. ");
INSERT INTO nld_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","En Farao sprak tot Jozef: Ik heb een droom gedroomd, en er is niemand, die hem uitlegge; maar ik heb van u horen zeggen, als gij een droom hoort, dat gij hem uitlegt. ");
INSERT INTO nld_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","En Jozef antwoordde Farao, zeggende: Het is buiten mij! God zal Farao's welstand aanzeggen. ");
INSERT INTO nld_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Toen sprak Farao tot Jozef: Zie, in mijn droom stond ik aan den oever der rivier; ");
INSERT INTO nld_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","En zie, uit de rivier kwamen op zeven koeien, vet van vlees en schoon van gedaante, en zij weidden in het gras. ");
INSERT INTO nld_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","En zie, zeven andere koeien kwamen op na deze, mager en zeer lelijk van gedaante, rank van vlees; ik heb dergelijke van lelijkheid niet gezien in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","En die ranke en lelijke koeien aten die eerste zeven vette koeien op; ");
INSERT INTO nld_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dewelke in haar buik inkwamen; maar men merkte niet, dat ze in haar buik ingekomen waren; want haar aanzien was lelijk, gelijk als in het begin. Toen ontwaakte ik. ");
INSERT INTO nld_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Daarna zag ik in mijn droom, en zie, zeven aren rezen op in een halm, vol en goed. ");
INSERT INTO nld_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","En zie, zeven dorre, dunne en van den oostenwind verzengde aren, schoten na dezelve uit; ");
INSERT INTO nld_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","En de zeven dunne aren verslonden die zeven goede aren. En ik heb het den tovenaars gezegd; maar er was niemand, die het mij verklaarde. ");
INSERT INTO nld_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Toen zeide Jozef tot Farao: De droom van Farao is een; hetgeen God is doende, heeft Hij Farao te kennen gegeven. ");
INSERT INTO nld_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Die zeven schone koeien zijn zeven jaren; die zeven schone aren zijn ook zeven jaren; de droom is een. ");
INSERT INTO nld_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","En die zeven ranke en lelijke koeien, die na gene opkwamen, zijn zeven jaren; en die zeven ranke van den oostenwind verzengde aren zullen zeven jaren des hongers wezen. ");
INSERT INTO nld_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Dit is het woord, hetwelk ik tot Farao gesproken heb: hetgeen God is doende, heeft Hij Farao vertoond. ");
INSERT INTO nld_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Zie, de zeven aankomende jaren, zal er grote overvloed in het ganse land van Egypte zijn. ");
INSERT INTO nld_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Maar na dezelve zullen er opstaan zeven jaren des hongers; dan zal in het land van Egypte al die overvloed vergeten worden; en de honger zal het land verteren. ");
INSERT INTO nld_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ook zal de overvloed in het land niet gemerkt worden, vanwege dienzelven honger, die daarna wezen zal; want hij zal zeer zwaar zijn. ");
INSERT INTO nld_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","En aangaande, dat die droom aan Farao ten tweeden maal is herhaald, is, omdat de zaak van God vastbesloten is, en dat God haast, om dezelve te doen. ");
INSERT INTO nld_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Zo zie nu Farao naar een verstandigen en wijzen man, en zette hem over het land van Egypte. ");
INSERT INTO nld_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao doe zo, en bestelle opzieners over het land; en neme het vijfde deel des lands van Egypte in de zeven jaren des overvloeds. ");
INSERT INTO nld_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","En dat zij alle spijze van deze aankomende goede jaren verzamelen, en koren opleggen, onder de hand van Farao, tot spijze in de steden, en bewaren het. ");
INSERT INTO nld_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Zo zal de spijze zijn tot voorraad voor het land, voor zeven jaren des hongers, die in Egypteland wezen zullen; opdat het land van honger niet verga. ");
INSERT INTO nld_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","En dit woord was goed in de ogen van Farao, en in de ogen van al zijn knechten. ");
INSERT INTO nld_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Zo zeide Farao tot zijn knechten: Zouden wij wel een man vinden als dezen, in welken Gods Geest is? ");
INSERT INTO nld_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Daarna zeide Farao tot Jozef: Naardien dat God u dit alles heeft verkondigd, zo is er niemand zo verstandig en wijs, als gij. ");
INSERT INTO nld_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gij zult over mijn huis zijn, en op uw bevel zal al mijn volk de hand kussen; alleen dezen troon zal ik groter zijn dan gij. ");
INSERT INTO nld_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Voorts sprak Farao tot Jozef: Zie, ik heb u over gans Egypteland gesteld. ");
INSERT INTO nld_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","En Farao nam zijn ring van zijn hand af, en deed hem aan Jozefs hand, en liet hem fijne linnen klederen aantrekken, en leide hem een gouden keten aan zijn hals; ");
INSERT INTO nld_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","En hij deed hem rijden op den tweeden wagen, dien hij had; en zij riepen voor zijn aangezicht: Knielt! Alzo stelde hij hem over gans Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","En Farao zeide tot Jozef: Ik ben Farao! doch zonder u zal niemand zijn hand of zijn voet opheffen in gans Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","En Farao noemde Jozefs naam Zafnath Paaneah, en gaf hem Asnath, de dochter van Potifera, overste van On, tot een vrouw; en Jozef toog uit door het land van Egypte. ");
INSERT INTO nld_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jozef nu was dertig jaren oud, als hij stond voor het aangezicht van Farao, koning van Egypte; en Jozef ging uit van Farao's aangezicht, en hij toog door gans Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","En het land bracht voort, in de zeven jaren des overvloeds, bij handvollen. ");
INSERT INTO nld_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","En hij vergaderde alle spijze der zeven jaren, die in Egypteland was, en deed de spijze in de steden; de spijze van het veld van elke stad, hetwelk rondom haar was, deed hij daar binnen. ");
INSERT INTO nld_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Alzo bracht Jozef zeer veel koren bijeen, als het zand der zee, totdat men ophield te tellen: want daarvan was geen getal. ");
INSERT INTO nld_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","En Jozef werden twee zonen geboren, eer er een jaar des hongers aankwam, die Asnath, de dochter van Potifera, overste van On, hem baarde. ");
INSERT INTO nld_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","En Jozef noemde den naam des eerstgeborenen Manasse; want, zeide hij, God heeft mij doen vergeten al mijn moeite, en het ganse huis mijns vaders. ");
INSERT INTO nld_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","En den naam des tweeden noemde hij Efraim; want, zeide hij, God heeft mij doen wassen in het land mijner verdrukking. ");
INSERT INTO nld_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Toen eindigden de zeven jaren des overvloeds, die in Egypte geweest was. ");
INSERT INTO nld_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","En de zeven jaren des hongers begonnen aan te komen, gelijk als Jozef gezegd had. En er was honger in al de landen; maar in gans Egypteland was brood. ");
INSERT INTO nld_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Als nu gans Egypteland hongerde, riep het volk tot Farao om brood; en Farao zeide tot alle Egyptenaren: Gaat tot Jozef, doet wat hij u zegt. ");
INSERT INTO nld_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Als dan honger over het ganse land was, zo opende Jozef alles, waarin iets was, en verkocht aan de Egyptenaren; want de honger werd sterk in Egypteland. ");
INSERT INTO nld_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","En alle landen kwamen in Egypte tot Jozef, om te kopen; want de honger was sterk in alle landen. ");
INSERT INTO nld_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Toen Jakob zag, dat er koren in Egypte was, zo zeide Jakob tot zijn zonen: Waarom ziet gij op elkander? ");
INSERT INTO nld_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Voorts zeide hij: Ziet, ik heb gehoord, dat er koren in Egypte is; trekt daarhenen af, en koopt ons koren van daar, opdat wij leven en niet sterven. ");
INSERT INTO nld_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Toen togen Jozefs tien broederen af, om koren uit Egypte te kopen. ");
INSERT INTO nld_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Doch Benjamin, Jozefs broeder, zond Jakob niet met zijn broederen; want hij zeide: Opdat hem niet misschien het verderf ontmoete! ");
INSERT INTO nld_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Alzo kwamen Israels zonen om te kopen onder degenen, die daar kwamen; want de honger was in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jozef nu was regent over dat land; hij verkocht aan al het volk des lands; en Jozefs broederen kwamen, en bogen zich voor hem, met de aangezichten ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Als Jozef zijn broederen zag, zo kende hij hen; maar hij hield zich vreemd jegens hen, en sprak hard met hen, en zeide tot hen: Van waar komt gij? En zij zeiden: Uit het land Kanaan; om spijze te kopen. ");
INSERT INTO nld_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jozef dan kende zijn broederen; maar zij kenden hem niet. ");
INSERT INTO nld_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Toen gedacht Jozef aan de dromen, die hij van hen gedroomd had; en hij zeide tot hen: Gij zijt verspieders, gij zijt gekomen om te bezichtigen, waar het land bloot is. ");
INSERT INTO nld_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","En zij zeiden tot hem: Neen, mijn heer! maar uw knechten zijn gekomen, om spijze te kopen. ");
INSERT INTO nld_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wij allen zijn eens mans zonen; wij zijn vroom; uw knechten zijn geen verspieders. ");
INSERT INTO nld_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","En hij zeide tot hen: Neen, maar gij zijt gekomen, om te bezichtigen, waar het land bloot is. ");
INSERT INTO nld_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","En zij zeiden: Wij, uw knechten, waren twaalf gebroeders, eens mans zonen, in het land Kanaan; en zie, de kleinste is heden bij onzen vader; doch de een is niet meer. ");
INSERT INTO nld_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Toen zeide Jozef tot hen: Dat is het, wat ik tot u gesproken heb, zeggende: Gij zijt verspieders! ");
INSERT INTO nld_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hierin zult gij beproefd worden: zo waarlijk als Farao leeft! indien gij van hier zult uitgaan, tenzij dan, wanneer uw kleinste broeder herwaarts zal gekomen zijn! ");
INSERT INTO nld_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Zendt een uit u, die uw broeder hale; maar weest gijlieden gevangen, en uw woorden zullen beproefd worden, of de waarheid bij u zij; en indien niet, zo waarlijk als Farao leeft, zo zijt gij verspieders! ");
INSERT INTO nld_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","En hij zette hen samen drie dagen in bewaring. ");
INSERT INTO nld_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","En ten derden dage zeide Jozef tot hen: Doet dit, zo zult gij leven; ik vrees God. ");
INSERT INTO nld_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Zo gij vroom zijt, zo zij een uwer broederen gebonden in het huis uwer bewaring; en gaat gij heen, brengt het koren voor den honger uwer huizen. ");
INSERT INTO nld_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","En brengt uw kleinsten broeder tot mij, zo zullen uw woorden waargemaakt worden; en gij zult niet sterven. En zij deden alzo. ");
INSERT INTO nld_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Toen zeiden zij de een tot den ander: Voorwaar, wij zijn schuldig aan onzen broeder, wiens benauwdheid der ziele wij zagen, toen hij ons om genade bad; maar wij hoorden niet! daarom komt deze benauwdheid over ons. ");
INSERT INTO nld_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","En Ruben antwoordde hun, zeggende: Heb ik het tot u niet gezegd, toen ik zeide: Zondigt niet aan dezen jongeling! maar gij hoordet niet; en ook zijn bloed, ziet, het wordt gezocht! ");
INSERT INTO nld_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","En zij wisten niet, dat het Jozef hoorde; want daar was een taalman tussen hen. ");
INSERT INTO nld_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Toen wendde hij zich om, van hen af, en weende; daarna keerde hij weder tot hen, en sprak tot hen, en nam Simeon van hen, en bond hem voor hun ogen. ");
INSERT INTO nld_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","En Jozef gebood, dat men hun zakken met koren vullen zou, en dat men hun geld wederkeerde, een iegelijk in zijn zak, en dat men hun teerkost gave tot den weg; en men deed hun alzo. ");
INSERT INTO nld_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","En zij laadden hun koren op hun ezels, en togen van daar. ");
INSERT INTO nld_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Toen een zijn zak opendeed, om zijn ezel voeder te geven in de herberg, zo zag hij zijn geld; want ziet, het was in den mond van zijn zak. ");
INSERT INTO nld_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","En hij zeide tot zijn broederen: Mijn geld is wedergekeerd; daartoe ook, ziet, het is in mijn zak! Toen ontging hun het hart, en zij verschrikten, de een tot den ander zeggende: Wat is dit, dat ons God gedaan heeft? ");
INSERT INTO nld_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","En zij kwamen in het land Kanaan, tot Jakob, hun vader; en zij gaven hem te kennen al hun wedervaren, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Die man, de heer van dat land, heeft hard met ons gesproken; en hij heeft ons gehouden voor verspieders des lands. ");
INSERT INTO nld_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Maar wij zeiden tot hem: Wij zijn vroom; wij zijn geen verspieders. ");
INSERT INTO nld_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wij waren twaalf gebroeders, zonen van onzen vader; de een is niet meer, en de kleinste is heden bij onzen vader in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","En die man, de heer van dat land, zeide tot ons: Hieraan zal ik bekennen, dat gijlieden vroom zijt; laat een uwer broederen bij mij, en neemt voor den honger uwer huizen, en trekt heen. ");
INSERT INTO nld_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","En brengt uw kleinsten broeder tot mij; zo zal ik weten, dat gij geen verspieders zijt, maar dat gij vroom zijt; uw broeder zal ik u wedergeven, en gij zult in dit land handelen. ");
INSERT INTO nld_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","En het geschiedde, als zij hun zakken ledigden, ziet, zo had een iegelijk den bundel zijns gelds in zijn zak; en zij zagen de bundelen huns gelds, zij en hun vader, en zij waren bevreesd. ");
INSERT INTO nld_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Toen zeide Jakob, hun vader, tot hen: Gij berooft mij van kinderen! Jozef is er niet, en Simeon is er niet; nu zult gij Benjamin wegnemen! al deze dingen zijn tegen mij! ");
INSERT INTO nld_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Toen sprak Ruben tot zijn vader, zeggende: Dood twee mijner zonen, zo ik hem tot u niet wederbreng; geef hem in mijn hand, en ik zal hem weder tot u brengen! ");
INSERT INTO nld_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Maar hij zeide: Mijn zoon zal met ulieden niet aftrekken; want zijn broeder is dood, en hij is alleen overgebleven; zo hem een verderf ontmoette op den weg, dien gij zult gaan, zo zoudt gij mijn grauwe haren met droefenis ten grave doen nederdalen. ");
INSERT INTO nld_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","De honger nu werd zwaar in dat land; ");
INSERT INTO nld_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Zo geschiedde het, als zij den leeftocht, dien zij uit Egypte gebracht hadden, opgegeten hadden, dat hun vader tot hen zeide: Keert wederom, koopt ons een weinig spijze. ");
INSERT INTO nld_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Toen sprak Juda tot hem, zeggende: Die man heeft ons op het hoogste betuigd, zeggende: Gij zult mijn aangezicht niet zien, tenzij dat uw broeder met u is. ");
INSERT INTO nld_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Indien gij onzen broeder met ons zendt, wij zullen aftrekken, en u spijze kopen; ");
INSERT INTO nld_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Maar indien gij hem niet zendt, wij zullen niet aftrekken; want die man heeft tot ons gezegd: Gij zult mijn aangezicht niet zien, tenzij dat uw broeder met u is. ");
INSERT INTO nld_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","En Israel zeide: Waarom hebt gij zo kwalijk aan mij gedaan, dat gij dien man te kennen gaaft, of gij nog een broeder hadt? ");
INSERT INTO nld_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","En zij zeiden: Die man vraagde zeer nauw naar ons, en naar onze maagschap, zeggende: Leeft uw vader nog; hebt gij nog een broeder? Zo gaven wij het hem te kennen, volgens diezelfde woorden; hebben wij juist geweten, dat hij zeggen zou: Brengt uw broeder af? ");
INSERT INTO nld_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Toen zeide Juda tot Israel, zijn vader: Zend den jongeling met mij, zo zullen wij ons opmaken en reizen, opdat wij leven en niet sterven, noch wij, noch gij, noch onze kinderkens. ");
INSERT INTO nld_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ik zal borg voor hem zijn; van mijn hand zult gij hem eisen; indien ik hem tot u niet breng en hem voor uw aangezicht stel, zo zal ik alle dagen tegen u gezondigd hebben! ");
INSERT INTO nld_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Want hadden wij niet gezuimd, voorwaar, wij waren alreeds tweemaal wedergekomen. ");
INSERT INTO nld_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Toen zeide Israel, hun vader, tot hen: Is het nu alzo, zo doet dit; neemt van het loffelijkste dezes lands in uwe vaten, en brengt dien man een geschenk henen af: een weinig balsem, en een weinig honig, specerijen en mirre, terpentijnnoten en amandelen. ");
INSERT INTO nld_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","En neemt dubbel geld in uw hand; en brengt het geld, hetwelk in den mond uwer zakken wedergekeerd is, weder in uw hand; misschien is het een feil. ");
INSERT INTO nld_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Neemt ook uw broeder mede, en maakt u op, keert weder tot dien man. ");
INSERT INTO nld_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","En God, de Almachtige, geve u barmhartigheid voor het aangezicht van dien man, dat hij uw anderen broeder en Benjamin met u late gaan! En mij aangaande, als ik van kinderen beroofd ben, zo ben ik beroofd! ");
INSERT INTO nld_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","En die mannen namen dat geschenk, en namen dubbel geld in hun hand, en Benjamin; en zij maakten zich op, en togen af naar Egypte, en zij stonden voor Jozefs aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Als Jozef Benjamin met hen zag, zo zeide hij tot dengene, die over zijn huis was: Breng deze mannen naar het huis toe, en slacht slachtvee, en maak het gereed; want deze mannen zullen te middag met mij eten. ");
INSERT INTO nld_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","De man nu deed, gelijk Jozef gezegd had; en de man bracht deze mannen in het huis van Jozef. ");
INSERT INTO nld_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Toen vreesden deze mannen, omdat zij in het huis van Jozef gebracht werden, en zeiden: Ter oorzake van het geld, dat in het begin in onze zakken wedergekeerd is, worden wij ingebracht, opdat hij ons overrompele en ons overvalle, en ons tot slaven neme, met onze ezelen. ");
INSERT INTO nld_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Daarom naderden zij tot dien man, die over het huis van Jozef was, en zij spraken tot hem aan de deur van het huis. ");
INSERT INTO nld_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","En zij zeiden: Och, mijn heer! wij waren in het begin gewisselijk afgekomen, om spijze te kopen. ");
INSERT INTO nld_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Het is nu geschied, als wij in de herberg gekomen waren, en wij onze zakken opendeden, zie, zo was ieders mans geld in den mond van zijn zak, ons geld in zijn gewicht; en wij hebben hetzelve wedergebracht in onze hand. ");
INSERT INTO nld_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wij hebben ook ander geld in onze hand afgebracht, om spijze te kopen; wij weten niet, wie ons geld in onze zakken gelegd heeft. ");
INSERT INTO nld_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","En hij zeide: Vrede zij ulieden, vreest niet! Uw God en de God uws vaders heeft u een schat in uw zakken gegeven; uw geld is tot mij gekomen. En hij bracht Simeon tot hen uit. ");
INSERT INTO nld_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Daarna bracht de man deze mannen in het huis van Jozef, en hij gaf water; en zij wiesen hun voeten; hij gaf ook aan hun ezelen voeder. ");
INSERT INTO nld_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","En zij bereidden het geschenk, totdat Jozef kwam op den middag; want zij hadden gehoord, dat zij aldaar brood eten zouden. ");
INSERT INTO nld_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Als nu Jozef te huis gekomen was, zo brachten zij hem het geschenk, hetwelk in hun hand was, in het huis, en zij bogen zich voor hem ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","En hij vraagde hun naar hun welstand, en zeide: Is het wel met uw vader, den oude, waarvan gij zeidet? Leeft hij nog? ");
INSERT INTO nld_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","En zij zeiden: Het is wel met uw knecht, onzen vader, hij leeft nog; en zij neigden het hoofd en bogen zich neder. ");
INSERT INTO nld_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","En hij hief zijn ogen op, en zag Benjamin, zijn broeder, den zoon zijner moeder, en zeide: Is dit uw kleinste broeder, waarvan gij tot mij zeidet? Daarna zeide hij: Mijn zoon? God zij u genadig! ");
INSERT INTO nld_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","En Jozef haastte zich; want zijn ingewand ontstak jegens zijn broeder, en hij zocht te wenen; en hij ging in een kamer, en weende aldaar. ");
INSERT INTO nld_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Daarna wies hij zijn aangezicht en kwam uit; en hij bedwong zichzelven, en zeide: Zet brood op. ");
INSERT INTO nld_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","En zij richtten voor hem aan in het bijzonder, en voor hen in het bijzonder; en voor de Egyptenaren, die met hem aten, in het bijzonder; want de Egyptenaars mogen geen brood eten met de Hebreen, dewijl zulks den Egyptenaren een gruwel is. ");
INSERT INTO nld_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","En zij aten voor zijn aangezicht, de eerstgeborene naar zijn eerstgeboorte, en de jongere naar zijn jonkheid; dies verwonderden zich de mannen onder elkander. ");
INSERT INTO nld_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","En hij langde hun van de gerechten, die voor hem waren; maar Benjamins gerecht was vijfmaal groter, dan de gerechten van hen allen. En zij dronken, en zij werden dronken met hem. ");
INSERT INTO nld_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","En hij gebood dengene, die over zijn huis was, zeggende: Vul de zakken dezer mannen met spijze, naar dat zij zullen kunnen dragen, en leg ieders mans geld in den mond van zijn zak; ");
INSERT INTO nld_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","En mijn beker, den zilveren beker, zult gij leggen in den mond van den zak des kleinsten, met het geld van zijn koren. En hij deed naar Jozefs woord, hetwelk hij gesproken had. ");
INSERT INTO nld_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Des morgens, als het licht werd, zo liet men deze mannen trekken, hen en hun ezelen. ");
INSERT INTO nld_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Zij zijn ter stad uitgegaan; zij waren niet verre gekomen, als Jozef tot dengene, die over zijn huis was, zeide: Maak u op, en jaag die mannen achterna; en als gij hen zult achterhaald hebben, zo zult gij tot hen zeggen: Waarom hebt gij kwaad voor goed vergolden? ");
INSERT INTO nld_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is het deze niet, waaruit mijn heer drinkt? en waarbij hij iets zekerlijk waarnemen zal? Gij hebt kwalijk gedaan, wat gij gedaan hebt. ");
INSERT INTO nld_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","En hij achterhaalde hen, en sprak tot hen diezelfde woorden. ");
INSERT INTO nld_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","En zij zeiden tot hem: Waarom spreekt mijn heer zulke woorden? Het zij verre van uw knechten, dat zij zodanig een ding doen zouden. ");
INSERT INTO nld_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Zie, het geld, dat wij in den mond onzer zakken vonden, hebben wij tot u uit het land Kanaan wedergebracht; hoe zouden wij dan uit het huis uws heren zilver of goud stelen? ");
INSERT INTO nld_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bij wien van uw knechten hij gevonden zal worden, dat hij sterve; en ook zullen wij mijn heer tot slaven zijn! ");
INSERT INTO nld_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","En hij zeide: Dit zij nu ook alzo, naar uw woorden! Bij wien hij gevonden wordt, die zij mijn slaaf; maar gijlieden zult onschuldig zijn. ");
INSERT INTO nld_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","En zij haastten, en iegelijk zette zijn zak af op de aarde, en iegelijk opende zijn zak. ");
INSERT INTO nld_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","En hij doorzocht, beginnende met den grootste, en voleindigende met den kleinste; en die beker werd gevonden in den zak van Benjamin. ");
INSERT INTO nld_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Toen scheurden zij hun klederen; en ieder man laadde zijn ezel op, en zij keerden weder naar de stad. ");
INSERT INTO nld_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","En Juda kwam met zijn broederen in het huis van Jozef; want hij was nog zelf aldaar; en zij vielen voor zijn aangezicht neder ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","En Jozef zeide tot hen: Wat daad is dit, die gij gedaan hebt? Weet gij niet, dat zulk een man als ik dat zekerlijk waarnemen zoude? ");
INSERT INTO nld_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Toen zeide Juda: Wat zullen wij tot mijn heer zeggen, wat zullen wij spreken, en wat zullen wij ons rechtvaardigen? God heeft de ongerechtigheid uwer knechten gevonden; zie, wij zijn mijns heren slaven, zo wij, als hij, in wiens hand de beker gevonden is. ");
INSERT INTO nld_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Maar hij zeide: Het zij verre van mij zulks te doen! de man, in wiens hand de beker gevonden is, die zal mijn slaaf zijn; doch trekt gijlieden op in vrede tot uw vader. ");
INSERT INTO nld_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Toen naderde Juda tot hem, en zeide: Och, mijn heer! laat toch uw knecht een woord spreken voor mijns heren oren, en laat uw toorn tegen uw knecht niet ontsteken; want gij zijt even gelijk Farao! ");
INSERT INTO nld_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mijn heer vraagde zijn knechten, zeggende: Hebt gijlieden een vader, of broeder? ");
INSERT INTO nld_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Zo zeiden wij tot mijn heer: Wij hebben een ouden vader, en een jongeling des ouderdoms, den kleinsten, wiens broeder dood is, en hij is alleen van zijn moeder overgebleven, en zijn vader heeft hem lief. ");
INSERT INTO nld_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Toen zeidet gij tot uw knechten: Brengt hem af tot mij, dat ik mijn oog op hem sla. ");
INSERT INTO nld_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","En wij zeiden tot mijn heer: Die jongeling zal zijn vader niet kunnen verlaten; indien hij zijn vader verlaat, zo zal hij sterven. ");
INSERT INTO nld_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Toen zeidet gij tot uw knechten: Indien uw kleinste broeder met u niet afkomt, zo zult gij mijn aangezicht niet meer zien. ");
INSERT INTO nld_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","En het is geschied, als wij tot uw knecht, mijn vader, opgetrokken zijn, en wij hem de woorden mijns heren verhaald hebben; ");
INSERT INTO nld_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","En dat onze vader gezegd heeft: Keert weder. koopt ons een weinig spijze; ");
INSERT INTO nld_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Zo hebben wij gezegd: Wij zullen niet mogen aftrekken; indien onze kleinste broeder bij ons is, zo zullen wij aftrekken; want wij zullen het aangezicht van dien man niet mogen zien, zo deze onze kleinste broeder niet bij ons is. ");
INSERT INTO nld_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Toen zeide uw knecht, mijn vader, tot ons: Gijlieden weet, dat mijn huisvrouw er mij twee gebaard heeft. ");
INSERT INTO nld_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","En de een is van mij uitgegaan, en ik heb gezegd: Voorwaar, hij is gewisselijk verscheurd geworden! en ik heb hem niet gezien tot nu toe. ");
INSERT INTO nld_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Indien gij nu dezen ook van mijn aangezicht wegneemt, en hem een verderf ontmoette, zo zoudt gij mijn grauwe haren met jammer ten grave doen nederdalen! ");
INSERT INTO nld_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nu dan, als ik tot uw knecht, mijn vader, kome, en de jongeling is niet bij ons (alzo zijn ziel aan de ziel van dezen gebonden is), ");
INSERT INTO nld_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Zo zal het geschieden, als hij ziet, dat de jongeling er niet is, dat hij sterven zal; en uw knechten zullen de grauwe haren van uw knecht, onzen vader, met droefenis ten grave doen nederdalen. ");
INSERT INTO nld_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Want uw knecht is voor deze jongeling borg bij mijn vader, zeggende: Zo ik hem tot u niet wederbreng, zo zal ik tegen mijn vader alle dagen gezondigd hebben! ");
INSERT INTO nld_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Nu dan, laat toch uw knecht voor dezen jongeling slaaf van mijn heer blijven, en laat den jongeling met zijn broederen optrekken! ");
INSERT INTO nld_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Want hoe zoude ik optrekken tot mijn vader, indien de jongeling niet met mij was, opdat ik den jammer niet zie, welke mijn vader overkomen zou. ");
INSERT INTO nld_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Toen kon zich Jozef niet bedwingen voor allen, die bij hem stonden, en hij riep: Doet alle man van mij uitgaan! En er stond niemand bij hem, als Jozef zich aan zijn broederen bekend maakte. ");
INSERT INTO nld_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","En hij verhief zijn stem met wenen, zodat het de Egyptenaren hoorden, en dat het Farao's huis hoorde. ");
INSERT INTO nld_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","En Jozef zeide tot zijn broederen: Ik ben Jozef! leeft mijn vader nog? En zijn broeders konden hem niet antwoorden; want zij waren verschrikt voor zijn aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","En Jozef zeide tot zijn broederen: Nadert toch tot mij! En zij naderden. Toen zeide hij: Ik ben Jozef, uw broeder, dien gij naar Egypte verkocht hebt. ");
INSERT INTO nld_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Maar nu, weest niet bekommerd, en de toorn ontsteke niet in uw ogen, omdat gij mij hierheen verkocht hebt; want God heeft mij voor uw aangezicht gezonden, tot behoudenis des levens. ");
INSERT INTO nld_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Want het zijn nu twee jaren des hongers in het midden des lands; en er zijn nog vijf jaren, in welke geen ploeging noch oogst zijn zal. ");
INSERT INTO nld_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Doch God heeft mij voor uw aangezicht henen gezonden, om u een overblijfsel te stellen op de aarde, en om u bij het leven te behouden, door een grote verlossing. ");
INSERT INTO nld_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nu dan, gij hebt mij herwaarts niet gezonden, maar God Zelf, Die mij tot Farao's vader gesteld heeft, en tot een heer over zijn ganse huis, en regeerder in het ganse land van Egypte. ");
INSERT INTO nld_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Haast u en trekt op tot mijn vader, en zegt het hem: Alzo zegt uw zoon Jozef: God heeft mij tot een heer over gans Egypteland gesteld; kom af tot mij, en vertoef niet. ");
INSERT INTO nld_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","En gij zult in het land Gosen wonen, en nabij mij wezen, gij en uw zonen, en de zonen uwer zonen, en uw schapen, en uw runderen, en al wat gij hebt. ");
INSERT INTO nld_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","En ik zal u aldaar onderhouden; want er zullen nog vijf jaren des hongers zijn, opdat gij niet verarmt, gij en uw huis, en alles wat gij hebt! ");
INSERT INTO nld_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","En ziet, uw ogen zien het, en de ogen van mijn broeder Benjamin, dat mijn mond tot u spreekt. ");
INSERT INTO nld_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","En boodschapt mijn vader al mijn heerlijkheid in Egypte, en alles wat gij gezien hebt; en haast u, en brengt mijn vader herwaarts af. ");
INSERT INTO nld_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","En hij viel aan den hals van Benjamin, zijn broeder, en weende; en Benjamin weende aan zijn hals. ");
INSERT INTO nld_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","En hij kuste al zijn broederen, en hij weende over hen; en daarna spraken zijn broeders met hem. ");
INSERT INTO nld_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Als dit gerucht in het huis van Farao gehoord werd, dat men zeide: Jozefs broeders zijn gekomen! was het goed in de ogen van Farao, en in de ogen van zijn knechten. ");
INSERT INTO nld_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","En Farao zeide tot Jozef: Zeg tot uw broederen: Doet dit, laadt uw beesten, en trekt heen, gaat naar het land Kanaan; ");
INSERT INTO nld_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","En neemt uw vader en uw huisgezinnen, en komt tot mij, en ik zal u het beste van Egypteland geven, en gij zult het vette dezes lands eten. ");
INSERT INTO nld_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Gij zijt toch gelast: doet dit, neemt u uit Egypteland wagenen voor uw kinderkens, en voor uw vrouwen, en voert uw vader, en komt. ");
INSERT INTO nld_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","En uw oog verschone uw huisraad niet; want het beste van gans Egypteland, dat zal het uwe zijn. ");
INSERT INTO nld_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","En de zonen van Israel deden alzo. Zo gaf Jozef hun wagenen, naar Farao's bevel; ook gaf hij hun teerkost op den weg. ");
INSERT INTO nld_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Hij gaf hun allen, ieder een, wisselklederen; maar Benjamin gaf hij driehonderd zilverlingen, en vijf wisselklederen. ");
INSERT INTO nld_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","En zijn vader desgelijks zond hij tien ezelen, dragende van het beste van Egypte, en tien ezelinnen, dragende koren, en brood, en spijze voor zijn vader op den weg. ");
INSERT INTO nld_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","En hij zond zijn broeders heen; en zij vertrokken; en hij zeide tot hen: Verstoort u niet op den weg. ");
INSERT INTO nld_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","En zij trokken op uit Egypte, en zij kwamen in het land Kanaan tot hun vader Jakob. ");
INSERT INTO nld_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Toen boodschapten zij hem, zeggende: Jozef leeft nog, ja, ook is hij regeerder in gans Egypteland! Toen bezweek zijn hart, want hij geloofde hen niet. ");
INSERT INTO nld_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Maar als zij tot hem gesproken hadden al de woorden van Jozef, die hij tot hen gesproken had, en dat hij de wagenen zag, die Jozef gezonden had om hem te voeren, zo werd de geest van Jakob hun vader, levendig. ");
INSERT INTO nld_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","En Israel zeide: Het is genoeg! mijn zoon Jozef leeft nog! ik zal gaan, en hem zien, eer ik sterve! ");
INSERT INTO nld_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","En Israel verreisde met al wat hij had, en hij kwam te Ber-seba, en hij offerde offeranden aan den God van zijn vader Izak. ");
INSERT INTO nld_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","En God sprak tot Israel in gezichten des nachts, en zeide: Jakob, Jakob! En hij zeide: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","En Hij zeide: Ik ben die God, uws vaders God; vrees niet van af te trekken naar Egypte; want Ik zal u aldaar tot een groot volk zetten. ");
INSERT INTO nld_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ik zal met u aftrekken naar Egypte en Ik zal u doen weder optrekken, mede optrekkende; en Jozef zal zijn hand op uw ogen leggen. ");
INSERT INTO nld_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Toen maakte zich Jakob op van Ber-seba; en de zonen van Israel voerden Jakob, hun vader, en hun kinderen, en hun vrouwen, op de wagenen, die Farao gezonden had, om hem te voeren. ");
INSERT INTO nld_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","En zij namen hun vee, en hun have, die zij in het land Kanaan geworven hadden, en zij kwamen in Egypte, Jakob en al zijn zaad met hem; ");
INSERT INTO nld_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Zijn zonen, en de zonen zijner zonen met hem; zijn dochteren, en zijner zonen dochteren, en al zijn zaad bracht hij met zich in Egypte. ");
INSERT INTO nld_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","En dit zijn de namen der zonen van Israel, die in Egypte kwamen: Jakob en zijn zonen. De eerstgeborene van Jakob: Ruben. ");
INSERT INTO nld_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","En de zonen van Ruben: Hanoch, en Pallu, en Hezron, en Karmi. ");
INSERT INTO nld_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","En de zonen van Simeon: Jemuel, en Jamin, en Ohad, en Jachin, en Zohar, en Saul, de zoon ener Kanaanietische vrouw. ");
INSERT INTO nld_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","En de zonen van Levi: Gerson, Kehath en Merari. ");
INSERT INTO nld_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","En de zonen van Juda: Er, en Onan, en Sela, en Perez, en Zerah. Doch Er en Onan waren gestorven in het land van Kanaan; en de zonen van Perez waren Hezron en Hamul. ");
INSERT INTO nld_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","En de zonen van Issaschar: Tola, en Puwa, en Job, en Simron. ");
INSERT INTO nld_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","En de zonen van Zebulon: Sered, en Elon, en Jahleel. ");
INSERT INTO nld_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dit zijn de zonen van Lea, die zij Jakob gebaard heeft in Paddan-Aram, met Dina zijn dochter; al de zielen zijner zonen en zijner dochteren waren drie en dertig. ");
INSERT INTO nld_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","En de zonen van Gad: Zifjon en Haggi, Schuni en Ezbon, Eri en Arodi, en Areli. ");
INSERT INTO nld_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","En de zonen van Aser: Jimna, en Jisva, en Jisvi, en Berija, en Sera, hun zuster; en de zonen van Berija: Heber en Malchiel. ");
INSERT INTO nld_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dit zijn de zonen van Zilpa, die Laban aan zijn dochter Lea gegeven had; en zij baarde Jakob deze zestien zielen. ");
INSERT INTO nld_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","De zonen van Rachel, Jakobs huisvrouw: Jozef en Benjamin. ");
INSERT INTO nld_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","En Jozef werden geboren in Egypteland, Manasse en Efraim, die hem Asnath, de dochter van Potifera, den overste te On, baarde. ");
INSERT INTO nld_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","En de zonen van Benjamin: Bela, Becher en Asbel, Gera en Naaman, Echi en Ros, Muppim en Huppim, en Ard. ");
INSERT INTO nld_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dit zijn de zonen van Rachel, die Jakob geboren zijn, al te zamen veertien zielen. ");
INSERT INTO nld_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","En de zonen van Dan: Chusim. ");
INSERT INTO nld_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","En de zonen van Nafthali: Jahzeel, en Guni, en Jezer, en Sillem. ");
INSERT INTO nld_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dit zijn de zonen van Bilha, die Laban aan zijn dochter Rachel gegeven had; en zij baarde dezelve Jakob, zij waren allen zeven zielen. ");
INSERT INTO nld_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Al de zielen, die met Jakob in Egypte kwamen, uit zijn heup gesproten, uitgenomen de vrouwen van de zonen van Jakob, waren allen zes en zestig zielen. ");
INSERT INTO nld_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","En de zonen van Jozef, die hem in Egypte geboren zijn, waren twee zielen. Al de zielen van het huis van Jakob, die in Egypte kwamen, waren zeventig. ");
INSERT INTO nld_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","En hij zond Juda voor zijn aangezicht heen tot Jozef, om voor zijn aangezicht aanwijzing te doen naar Gosen; en zij kwamen in het land Gosen. ");
INSERT INTO nld_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Toen spande Jozef zijn wagen aan, en toog op, zijn vader Israel tegemoet naar Gosen; en als hij zich aan hem vertoonde, zo viel hij hem aan zijn hals, en weende lang aan zijn hals. ");
INSERT INTO nld_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","En Israel zeide tot Jozef: Dat ik nu sterve, nadat ik uw aangezicht gezien heb, dat gij nog leeft! ");
INSERT INTO nld_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Daarna zeide Jozef tot zijn broederen, en tot zijns vaders huis: Ik zal optrekken en Farao boodschappen, en tot hem zeggen: Mijn broeders en het huis mijns vaders, die in het land Kanaan waren, zijn tot mij gekomen. ");
INSERT INTO nld_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","En die mannen zijn schaapherders; want het zijn mannen, die met vee omgaan; en zij hebben hun schapen, en hun runderen, en al wat zij hebben, medegebracht. ");
INSERT INTO nld_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wanneer het nu geschieden zal, dat Farao ulieden zal roepen, en zeggen: Wat is uw hantering? ");
INSERT INTO nld_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Zo zult gij zeggen: Uw knechten zijn mannen, die van onze jeugd af tot nu toe met vee omgegaan hebben, zo wij als onze vaders; opdat gij in het land Gosen moogt wonen; want alle schaapherder is den Egyptenaren een gruwel. ");
INSERT INTO nld_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Toen kwam Jozef en boodschapte Farao, en zeide: Mijn vader en mijn broeders, en hun schapen, en hun runderen, met alles wat zij hebben, zijn gekomen uit het land Kanaan; en zie, zij zijn in het land Gosen. ");
INSERT INTO nld_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","En hij nam een deel zijner broederen, te weten vijf mannen, en hij stelde hen voor Farao's aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Toen zeide Farao tot zijn broederen: Wat is uw hantering? En zij zeiden tot Farao: Uw knechten zijn schaapherders, zo wij als onze vaders. ");
INSERT INTO nld_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Voorts zeiden zij tot Farao: Wij zijn gekomen, om als vreemdelingen in dit land te wonen; want er is geen weide voor de schapen, die uw knechten hebben, dewijl de honger zwaar is in het land Kanaan; en nu, laat toch uw knechten in het land Gosen wonen! ");
INSERT INTO nld_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Toen sprak Farao tot Jozef, zeggende: Uw vader en uw broeders zijn tot u gekomen; ");
INSERT INTO nld_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egypteland is voor uw aangezicht; doe uw vader en uw broeders in het beste van het land wonen; laat hen in het land Gosen wonen, en zo gij weet, dat er onder hen kloeke mannen zijn, zo zet hen tot veemeesters over hetgeen ik heb. ");
INSERT INTO nld_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","En Jozef bracht zijn vader Jakob mede, en stelde hem voor Farao's aangezicht; en Jakob zegende Farao. ");
INSERT INTO nld_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","En Farao zeide tot Jakob: Hoe vele zijn de dagen der jaren uws levens! ");
INSERT INTO nld_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","En Jakob zeide tot Farao: De dagen der jaren mijner vreemdelingschappen zijn honderd en dertig jaren; weinig en kwaad zijn de dagen der jaren mijns levens geweest, en hebben niet bereikt de dagen van de jaren des levens mijner vaderen, in de dagen hunner vreemdelingschappen. ");
INSERT INTO nld_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","En Jakob zegende Farao, en ging uit van Farao's aangezicht. ");
INSERT INTO nld_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","En Jozef bestelde voor Jakob en zijn broederen woningen, en hij gaf hun een bezitting in Egypteland, in het beste van het land, in het land Rameses, gelijk als Farao geboden had. ");
INSERT INTO nld_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","En Jozef onderhield zijn vader, en zijn broeders, en het ganse huis zijns vaders, met brood, tot den mond der kinderkens toe. ");
INSERT INTO nld_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","En er was geen brood in het ganse land; want de honger was zeer zwaar: zodat het land van Egypte en het land Kanaan raasden vanwege dien honger. ");
INSERT INTO nld_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Toen verzamelde Jozef al het geld, dat in Egypteland en in het land Kanaan gevonden werd, voor het koren, dat zij kochten; en Jozef bracht dat geld in Farao's huis. ");
INSERT INTO nld_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Als nu het geld uit Egypteland en uit het land Kanaan verdaan was, kwamen al de Egyptenaars tot Jozef, zeggende: Geef ons brood; want waarom zouden wij in uw tegenwoordigheid sterven? want het geld ontbreekt; ");
INSERT INTO nld_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","En Jozef zeide: Geeft uw vee, zo zal ik het u geven voor uw vee, indien het geld ontbreekt. ");
INSERT INTO nld_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Toen brachten zij hun vee tot Jozef; en Jozef gaf hun brood voor paarden en voor het vee der schapen, en voor het vee der runderen, en voor ezels; en hij voedde hen met brood, datzelve jaar, voor al hun vee. ");
INSERT INTO nld_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Toen datzelve jaar voleind was, zo kwamen zij tot hem in het tweede jaar, en zeiden tot hem: Wij zullen het voor mijn heer niet verbergen, alzo het geld verdaan is, en de bezitting der beesten gekomen aan mijn heer, zo is er niets anders overgebleven voor het aangezichts mijns heren, dan ons lichaam en ons land. ");
INSERT INTO nld_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Waarom zullen wij voor uw ogen sterven, zo wij als ons land? Koop ons en ons land voor brood; zo zullen wij en ons land Farao dienstbaar zijn; en geef zaad, opdat wij leven en niet sterven, en het land niet woest worde! ");
INSERT INTO nld_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Alzo kocht Jozef het gehele land van Egypte voor Farao; want de Egyptenaars verkochten een ieder zijn akker, dewijl de honger sterk over hen geworden was; zo werd het land Farao's eigen. ");
INSERT INTO nld_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","En aangaande het volk, dat zette hij over in de steden, van het ene uiterste der palen van Egypte, tot het andere uiterste deszelven. ");
INSERT INTO nld_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Alleen het land der priesteren kocht hij niet, want de priesters hadden een bescheiden deel van Farao, en zij aten hun bescheiden deel, hetwelk hun Farao gegeven had; daarom verkochten zij hun land niet. ");
INSERT INTO nld_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Toen zeide Jozef tot het volk: Ziet, ik heb heden u en uw land gekocht voor Farao; ziet, daar is zaad voor u, opdat gij het land bezaait. ");
INSERT INTO nld_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Doch met de inkomsten zal het geschieden, dat gij aan Farao het vijfde deel zult geven, en de vier delen zullen voor u zijn, tot zaad des velds, en tot uw spijze en van degenen, die in uw huizen zijn, en om te eten voor uw kinderkens. ");
INSERT INTO nld_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","En zij zeiden: Gij hebt ons leven behouden; laat ons genade vinden in de ogen mijns heren, en wij zullen Farao's knechten zijn. ");
INSERT INTO nld_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jozef dan stelde ditzelve in tot een wet, tot dezen dag, over het land van Egypte, dat Farao het vijfde deel zou hebben; behalve dat alleen het land der priesteren van Farao niet werd. ");
INSERT INTO nld_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Zo woonde Israel in het land van Egypte, in het land Gosen; en zij stelden zich tot bezitters daarin, en zij werden vruchtbaar en vermeerderden zeer. ");
INSERT INTO nld_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","En Jakob leefde in het land van Egypte zeventien jaar; zodat de dagen van Jakob, de jaren zijns levens, geweest zijn honderd zeven en veertig jaren. ");
INSERT INTO nld_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Als nu de dagen van Israel naderden, dat hij sterven zou, zo riep hij zijn zoon Jozef, en zeide tot hem: Indien ik nu genade gevonden heb in uw ogen, zo leg toch uw hand onder mijn heup, en doe weldadigheid en trouw aan mij, en begraaf mij toch niet in Egypte; ");
INSERT INTO nld_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Maar dat ik bij mijn vaderen ligge; hierom zult gij mij uit Egypte voeren, en mij in hun graf begraven. En hij zeide: Ik zal doen naar uw woord! ");
INSERT INTO nld_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","En hij zeide: Zweer mij! en hij zwoer hem. En Israel boog zich ten hoofde van het bed. ");
INSERT INTO nld_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Het geschiedde nu na deze dingen, dat men Jozef zeide: Zie, uw vader is krank! Toen nam hij zijn twee zonen met zich, Manasse en Efraim! ");
INSERT INTO nld_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","En men boodschapte Jakob, en men zeide: Zie, uw zoon Jozef komt tot u! Zo versterkte zich Israel, en zat op het bed. ");
INSERT INTO nld_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Daarna zeide Jakob tot Jozef: God de Almachtige, is mij verschenen te Luz, in het land Kanaan, en Hij heeft mij gezegend; ");
INSERT INTO nld_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","En Hij heeft tot mij gezegd: Zie, Ik zal u vruchtbaar maken, en u vermenigvuldigen, en u tot een hoop van volken stellen; en Ik zal aan uw zaad na u dit land tot een eeuwige bezitting geven. ");
INSERT INTO nld_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nu dan, uw twee zonen, die u in Egypteland geboren waren, eer ik in Egypte tot u gekomen ben, zijn mijne; Efraim en Manasse zullen mijne zijn, als Ruben en Simeon. ");
INSERT INTO nld_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Maar uw geslacht, dat gij na hen zult gewinnen, zullen uwe zijn; zij zullen naar hunner broederen naam genoemd worden in hun erfdeel. ");
INSERT INTO nld_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Toen ik nu van Paddan kwam, zo is Rachel bij mij gestorven in het land Kanaan, op den weg, als het nog een kleine streek lands was, om tot Efrath te komen; en ik begroef haar aldaar aan den weg van Efrath, welke is Bethlehem. ");
INSERT INTO nld_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","En Israel zag de zonen van Jozef, en zeide: Wiens zijn deze? ");
INSERT INTO nld_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","En Jozef zeide tot zijn vader: Zij zijn mijn zonen, die mij God hier gegeven heeft. En hij zeide: Breng hen toch tot mij, dat ik hen zegene! ");
INSERT INTO nld_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Doch de ogen van Israel waren zwaar van ouderdom; hij kon niet zien; en hij deed hen naderen tot zich; toen kuste hij hen, en omhelsde hen. ");
INSERT INTO nld_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","En Israel zeide tot Jozef: Ik had niet gemeend uw aangezicht te zien; maar zie, God heeft mij ook uw zaad doen zien! ");
INSERT INTO nld_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Toen deed hen Jozef uitgaan van zijn knieen; en hij boog zich voor zijn aangezicht neder ter aarde. ");
INSERT INTO nld_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","En Jozef nam die beiden, Efraim met zijn rechterhand, tegenover Israels linkerhand, en Manasse met zijn linkerhand, tegenover Israels rechterhand, en hij deed hen naderen tot hem. ");
INSERT INTO nld_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Maar Israel strekte zijn rechterhand uit, en leide die op het hoofd van Efraim, hoewel hij de minste was, en zijn linkerhand op het hoofd van Manasse; hij bestierde zijn handen verstandelijk; want Manasse was de eerstgeborene. ");
INSERT INTO nld_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","En hij zegende Jozef, en zeide: De God, voor Wiens aangezicht mijn vaders, Abraham en Izak, gewandeld hebben, die God, Die mij gevoed heeft, van dat ik was, tot op dezen dag; ");
INSERT INTO nld_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Die Engel, Die mij verlost heeft van alle kwaad, zegene deze jongeren, en dat in hen mijn naam genoemd worde, en de naam mijner vaderen, Abraham en Izak, en dat zij vermenigvuldigen als vissen in menigte, in het midden des lands! ");
INSERT INTO nld_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Toen Jozef zag, dat zijn vader zijn rechterhand op het hoofd van Efraim leide, zo was het kwaad in zijn ogen, en hij ondervatte zijns vaders hand, om die van het hoofd van Efraim op het hoofd van Manasse af te brengen. ");
INSERT INTO nld_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","En Jozef zeide tot zijn vader: Niet alzo, mijn vader! want deze is de eerstgeborene; leg uw rechterhand op zijn hoofd. ");
INSERT INTO nld_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maar zijn vader weigerde het, en zeide: Ik weet het, mijn zoon! ik weet het; hij zal ook tot een volk worden, en hij zal ook groot worden; maar nochtans zal zijn kleinste broeder groter worden dan hij, en zijn zaad zal een volle menigte van volkeren worden. ");
INSERT INTO nld_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Alzo zegende hij ze te dien dage, zeggende: In u zal Israel zegenen, zeggende: God zette u als Efraim en als Manasse! En hij zette Efraim voor Manasse. ");
INSERT INTO nld_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Daarna zeide Israel tot Jozef: Zie, ik sterf; maar God zal met ulieden wezen, en Hij zal u wederbrengen in het land uwer vaderen. ");
INSERT INTO nld_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","En ik heb u een stuk lands gegeven boven uw broederen; hetwelk ik, met mijn zwaard en met mijn boog, uit de hand der Amorieten genomen heb. ");
INSERT INTO nld_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Daarna riep Jakob zijn zonen, en hij zeide: Verzamelt u, en ik zal u verkondigen, hetgeen u in de navolgende dagen wedervaren zal. ");
INSERT INTO nld_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Komt samen en hoort, gij, zonen van Jakob! en hoort naar Israel, uw vader. ");
INSERT INTO nld_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! gij zijt mijn eerstgeborene, mijn kracht, en het begin mijner macht; de voortreffelijkste in hoogheid, en de voortreffelijkste in sterkte! ");
INSERT INTO nld_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Snelle afloop als der wateren, gij zult de voortreffelijkste niet zijn! want gij hebt uws vaders leger beklommen; toen hebt gij het geschonden; hij heeft mijn bed beklommen! ");
INSERT INTO nld_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon en Levi zijn gebroeders! hun handelingen zijn werktuigen van geweld! ");
INSERT INTO nld_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mijn ziel kome niet in hun verborgen raad; mijn eer worde niet verenigd met hun vergadering! want in hun toorn hebben zij de mannen doodgeslagen, en in hun moedwil hebben zij de ossen weggerukt. ");
INSERT INTO nld_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Vervloekt zij hun toorn, want hij is heftig; en hun verbolgenheid, want zij is hard! ik zal hen verdelen onder Jakob, en zal hen verstrooien onder Israel. ");
INSERT INTO nld_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda! gij zijt het, u zullen uw broeders loven; uw hand zal zijn op den nek uwer vijanden; voor u zullen zich uws vaders zonen nederbuigen. ");
INSERT INTO nld_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda is een leeuwenwelp! gij zijt van den roof opgeklommen, mijn zoon! Hij kromt zich, hij legt zich neder als een leeuw, en als een oude leeuw; wie zal hem doen opstaan? ");
INSERT INTO nld_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","De schepter zal van Juda niet wijken, noch de wetgever van tussen zijn voeten, totdat Silo komt, en Denzelven zullen de volken gehoorzaam zijn. ");
INSERT INTO nld_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Hij bindt zijn jongen ezel aan den wijnstok, en het veulen zijner ezelin aan den edelsten wijnstok; hij wast zijn kleed in den wijn, en zijn mantel in wijndruivenbloed. ");
INSERT INTO nld_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Hij is roodachtig van ogen door den wijn, en wit van tanden door de melk. ");
INSERT INTO nld_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon zal aan de haven der zeeen wonen, en hij zal aan de haven der schepen wezen; en zijn zijde zal zijn naar Sidon. ");
INSERT INTO nld_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issaschar is een sterk gebeende ezel, nederliggende tussen twee pakken. ");
INSERT INTO nld_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Toen hij de rust zag, dat zij goed was, en het land, dat het lustig was, zo boog hij zijn schouder om te dragen, en was dienende onder cijns. ");
INSERT INTO nld_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan zal zijn volk richten, als een der stammen Israels. ");
INSERT INTO nld_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan zal een slang zijn aan den weg, een adderslang nevens het pad, bijtende des paards verzenen, dat zijn rijder achterover valle. ");
INSERT INTO nld_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Op uw zaligheid wacht ik, HEERE! ");
INSERT INTO nld_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Aangaande Gad, een bende zal hem aanvallen; maar hij zal haar aanvallen in het einde. ");
INSERT INTO nld_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Van Aser, zijn brood zal vet zijn; en hij zal koninklijke lekkernijen leveren. ");
INSERT INTO nld_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafthali is een losgelaten hinde; hij geeft schone woorden. ");
INSERT INTO nld_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jozef is een vruchtbare tak, een vruchtbare tak aan een fontein; elk der takken loopt over den muur. ");
INSERT INTO nld_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","De schutters hebben hem wel bitterheid aangedaan, en beschoten, en hem gehaat; ");
INSERT INTO nld_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Maar zijn boog is in stijvigheid gebleven, en de armen zijner handen zijn gesterkt geworden, door de handen van den Machtige Jakobs; daarvan is hij een herder, een steen Israels; ");
INSERT INTO nld_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Van uws vaders God, Die u zal helpen, en van den Almachtige, Die u zal zegenen, met zegeningen des hemels van boven, met zegeningen des afgronds, die daaronder ligt, met zegeningen der borsten en der baarmoeder! ");
INSERT INTO nld_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","De zegeningen uws vaders gaan te boven de zegeningen mijner voorvaderen, tot aan het einde van de eeuwige heuvelen; die zullen zijn op het hoofd van Jozef, en op den hoofdschedel des afgezonderden zijner broederen! ");
INSERT INTO nld_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin zal als een wolf verscheuren; des morgens zal hij roof eten, en des avonds zal hij buit uitdelen. ");
INSERT INTO nld_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Al deze stammen van Israel zijn twaalf; en dit is het, wat hun vader tot hen sprak, als hij hen zegende; hij zegende hen, een iegelijk naar zijn bijzonderen zegen. ");
INSERT INTO nld_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Daarna gebood hij hun, en zeide tot hen: Ik word verzameld tot mijn volk: begraaft mij bij mijn vaders, in de spelonk, die is in den akker van Efron, den Hethiet; ");
INSERT INTO nld_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","In de spelonk, welke is op den akker van Machpela, die tegenover Mamre is, in het land Kanaan, die Abraham met dien akker gekocht heeft van Efron, den Hethiet, tot een erfbegrafenis. ");
INSERT INTO nld_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aldaar hebben zij Abraham begraven, en Sara, zijn huisvrouw; daar hebben zij Izak begraven, en Rebekka, zijn huisvrouw; en daar heb ik Lea begraven. ");
INSERT INTO nld_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","De akker, en de spelonk, die daarin is, is gekocht van de zonen Heths. ");
INSERT INTO nld_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Als Jakob voleind had aan zijn zonen bevelen te geven, zo leide hij zijn voeten samen op het bed, en hij gaf den geest, en hij werd verzameld tot zijn volken. ");
INSERT INTO nld_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Toen viel Jozef op zijns vaders aangezicht, en hij weende over hem, en kuste hem. ");
INSERT INTO nld_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","En Jozef gebood zijn knechten, den medicijnmeesters, dat zij zijn vader balsemen zouden; en de medicijnmeesters balsemden Israel. ");
INSERT INTO nld_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","En veertig dagen werden aan hem vervuld; want alzo werden vervuld de dagen dergenen, die gebalsemd werden; en de Egyptenaars beweenden hem zeventig dagen. ");
INSERT INTO nld_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Als nu de dagen zijns bewenens over waren, zo sprak Jozef tot het huis van Farao, zeggende: Indien ik nu genade gevonden heb in uw ogen, spreekt toch voor de oren van Farao, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mijn vader heeft mij doen zweren, zeggende: Zie, ik sterf; in mijn graf, dat ik mij in het land Kanaan gegraven heb, daar zult gij mij begraven! Nu dan, laat mij toch optrekken, dat ik mijn vader begrave, dan zal ik wederkomen. ");
INSERT INTO nld_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","En Farao zeide: Trek op en begraaf uw vader, gelijk als hij u heeft doen zweren. ");
INSERT INTO nld_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","En Jozef toog op, om zijn vader te begraven; en met hem togen op alle Farao's knechten, de oudsten van zijn huis, en al de oudsten des lands van Egypte; ");
INSERT INTO nld_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Daartoe het ganse huis van Jozef, en zijn broeders, en het huis zijns vaders; alleen hun kleine kinderen, en hun schapen, en hun runderen lieten zij in het land Gosen. ");
INSERT INTO nld_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","En met hem togen op, zo wagenen als ruiteren; en het was een zeer zwaar heir. ");
INSERT INTO nld_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Toen zij nu aan het plein van het doornbos kwamen, dat aan gene zijde van de Jordaan is, hielden zij daar een grote en zeer zware rouwklage; en hij maakte zijn vader een rouw van zeven dagen. ");
INSERT INTO nld_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Als de inwoners des lands, de Kanaanieten, dien rouw zagen op het plein van het doornbos, zo zeiden zij: Dit is een zware rouw der Egyptenaren; daarom noemde men haar naam Abel-Mizraim, die aan het veer van de Jordaan is. ");
INSERT INTO nld_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","En zijn zonen deden hem, gelijk als hij hun geboden had; ");
INSERT INTO nld_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Want zijn zonen voerden hem in het land Kanaan, en begroeven hem in de spelonk des akkers van Machpela, welke Abraham met den akker gekocht had tot een erfbegrafenis van Efron, den Hethiet, tegenover Mamre. ");
INSERT INTO nld_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Daarna keerde Jozef weder in Egypte, hij en zijn broeders, en allen, die met hem opgetogen waren, om zijn vader te begraven, nadat hij zijn vader begraven had. ");
INSERT INTO nld_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Toen Jozefs broeders zagen, dat hun vader dood was, zo zeiden zij: Misschien zal ons Jozef haten, en hij zal ons gewisselijk vergelden al het kwaad, dat wij hem aangedaan hebben. ");
INSERT INTO nld_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Daarom ontboden zij aan Jozef, zeggende: Uw vader heeft bevolen voor zijn dood, zeggende: ");
INSERT INTO nld_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Zo zult gij tot Jozef zeggen: Ei, vergeef toch de overtreding uwer broederen, en hun zonde; want zij hebben u kwaad aangedaan; maar nu vergeef toch de overtreding der dienaren van den God uws vaders! En Jozef weende, als zij tot hem spraken. ");
INSERT INTO nld_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Daarna kwamen ook zijn broeders, en vielen voor hem neder, en zeiden: Zie, wij zijn u tot knechten! ");
INSERT INTO nld_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","En Jozef zeide tot hen: Vreest niet; want ben ik in de plaats van God? ");
INSERT INTO nld_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gijlieden wel, gij hebt kwaad tegen mij gedacht; doch God heeft dat ten goede gedacht; opdat Hij deed, gelijk het te dezen dage is, om een groot volk in het leven te behouden. ");
INSERT INTO nld_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nu dan, vreest niet! Ik zal u en uw kleine kinderen onderhouden. Zo troostte hij hen, en sprak naar hun hart. ");
INSERT INTO nld_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jozef dan woonde in Egypte, hij en het huis zijns vaders; en Jozef leefde honderd en tien jaren. ");
INSERT INTO nld_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","En Jozef zag van Efraim kinderen, van het derde gelid; ook werden de zonen van Machir, den zoon van Manasse, op Jozefs knieen geboren. ");
INSERT INTO nld_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","En Jozef zeide tot zijn broederen: Ik sterf; maar God zal u gewisselijk bezoeken, en Hij zal u doen optrekken uit dit land, in het land, hetwelk hij aan Abraham, Izak en Jakob gezworen heeft. ");
INSERT INTO nld_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","En Jozef deed de zonen van Israel zweren, zeggende: God zal u gewisselijk bezoeken, zo zult gij mijn beenderen van hier opvoeren! ");
INSERT INTO nld_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","En Jozef stierf, honderd en tien jaren oud zijnde; en zij balsemden hem, en men leide hem in een kist in Egypte.﻿ ");
INSERT INTO nld_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dit nu zijn de namen der zonen van Israel, die in Egypte gekomen zijn, met Jakob; zij kwamen er in, elk met zijn huis. ");
INSERT INTO nld_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, en Juda; ");
INSERT INTO nld_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issaschar, Zebulon, en Benjamin; ");
INSERT INTO nld_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan en Nafthali, Gad en Aser. ");
INSERT INTO nld_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Al de zielen nu, die uit Jakobs heup voortgekomen zijn, waren zeventig zielen; doch Jozef was in Egypte. ");
INSERT INTO nld_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Toen nu Jozef gestorven was, en al zijn broeders, en al dat geslacht, ");
INSERT INTO nld_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Zo werden de kinderen Israels vruchtbaar en wiesen overvloedig, en zij vermeerderden, en werden gans zeer machtig, zodat het land met hen vervuld werd. ");
INSERT INTO nld_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Daarna stond een nieuwe koning op over Egypte, die Jozef niet gekend had; ");
INSERT INTO nld_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Die zeide tot zijn volk: Ziet, het volk der kinderen Israels is veel, ja, machtiger dan wij. ");
INSERT INTO nld_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Komt aan, laat ons wijselijk tegen hetzelve handelen, opdat het niet vermenigvuldige, en het geschiede, als er enige krijg voorvalt, dat het zich ook niet vervoege tot onze vijanden, en tegen ons strijde, en uit het land optrekke. ");
INSERT INTO nld_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","En zij zetten oversten der schattingen over hetzelve, om het te verdrukken met hun lasten; want men bouwde voor Farao schatsteden, Pitom en Raamses. ");
INSERT INTO nld_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Maar hoe meer zij het verdrukten, hoe meer het vermeerderde, en hoe meer het wies; zodat zij verdrietig waren vanwege de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","En de Egyptenaars deden de kinderen Israels dienen met hardigheid; ");
INSERT INTO nld_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Zodat zij hun het leven bitter maakten met harden dienst, in leem en in tichelstenen, en met allen dienst op het veld, met al hun dienst, dien zij hen deden dienen met hardigheid. ");
INSERT INTO nld_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Daarenboven sprak de koning van Egypte tot de vroedvrouwen der Hebreinnen, welker ener naam Sifra, en de naam der andere Pua was; ");
INSERT INTO nld_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","En zeide: Wanneer gij de Hebreinnen in het baren helpt, en ziet haar op de stoelen; is het een zoon, zo doodt hem; maar is het een dochter, zo laat haar leven! ");
INSERT INTO nld_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Doch de vroedvrouwen vreesden God, en deden niet, gelijk als de koning van Egypte tot haar gesproken had, maar zij behielden de knechtjes in het leven. ");
INSERT INTO nld_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Toen riep de koning van Egypte de vroedvrouwen, en zeide tot haar: Waarom hebt gijlieden deze zaak gedaan, dat gij de knechtjes in het leven behouden hebt? ");
INSERT INTO nld_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","En de vroedvrouwen zeiden tot Farao: Omdat de Hebreinnen niet zijn gelijk de Egyptische vrouwen; want zij zijn sterk; eer de vroedvrouw tot haar komt, zo hebben zij gebaard. ");
INSERT INTO nld_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Daarom deed God aan de vroedvrouwen goed; en dat volk vermeerderde, en het werd zeer machtig. ");
INSERT INTO nld_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","En het geschiedde, dewijl de vroedvrouwen God vreesden, zo bouwde Hij haar huizen. ");
INSERT INTO nld_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Toen gebood Farao aan al zijn volk, zeggende: Alle zonen, die geboren worden, zult gij in de rivier werpen, maar al de dochteren in het leven behouden. ");
INSERT INTO nld_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","En een man van het huis van Levi ging, en nam een dochter van Levi. ");
INSERT INTO nld_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","En de vrouw werd zwanger, en baarde een zoon. Toen zij hem zag, dat hij schoon was, zo verborg zij hem drie maanden. ");
INSERT INTO nld_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Doch als zij hem niet langer verbergen kon, zo nam zij voor hem een kistje van biezen, en belijmde het met lijm en met pek; en zij leide het knechtje daarin, en leide het in de biezen, aan den oever der rivier. ");
INSERT INTO nld_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","En zijn zuster stelde zich van verre, om te weten, wat hem gedaan zou worden. ");
INSERT INTO nld_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","En de dochter van Farao ging af, om zich te wassen in de rivier; en haar jonkvrouwen wandelden aan den kant der rivier; toen zij het kistje in het midden van de biezen zag, zo zond zij haar dienstmaagd heen, en liet het halen. ");
INSERT INTO nld_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Toen zij het open deed, zo zag zij dat knechtje; en ziet, het jongsken weende; en zij werd met barmhartigheid bewogen over hetzelve, en zij zeide: Dit is een van de knechtjes der Hebreen! ");
INSERT INTO nld_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Toen zeide zijn zuster tot Farao's dochter: Zal ik heengaan, en u een voedstervrouw uit de Hebreinnen roepen, die dat knechtje voor u zoge? ");
INSERT INTO nld_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","En de dochter van Farao zeide tot haar: Ga heen. En de jonge maagd ging, en riep des knechtjes moeder. ");
INSERT INTO nld_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Toen zeide Farao's dochter tot haar: Neem dit knechtje heen, en zoog het mij; ik zal u uw loon geven. En de vrouw nam het knechtje en zoogde het. ");
INSERT INTO nld_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","En toen het knechtje groot geworden was, zo bracht zij het tot Farao's dochter, en het werd haar ten zoon; en zij noemde zijn naam Mozes, en zeide: Want ik heb hem uit het water getogen. ");
INSERT INTO nld_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En het geschiedde in die dagen, toen Mozes groot geworden was, dat hij uitging tot zijn broederen, en bezag hun lasten; en hij zag, dat een Egyptisch man een Hebreeuwsen man uit zijn broederen sloeg. ");
INSERT INTO nld_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","En hij zag herwaarts en gindswaarts; en toen hij zag, dat er niemand was, zo versloeg hij den Egyptenaar, en verborg hem in het zand. ");
INSERT INTO nld_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Des anderen daags ging hij wederom uit, en ziet, twee Hebreeuwse mannen twistten; en hij zeide tot den ongerechte: Waarom slaat gij uw naaste? ");
INSERT INTO nld_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Hij dan zeide: Wie heeft u tot een overste en rechter over ons gezet? Zegt gij dit, om mij te doden, gelijk gij den Egyptenaar gedood hebt? Toen vreesde Mozes, en zeide: Voorwaar, deze zaak is bekend geworden! ");
INSERT INTO nld_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Als nu Farao deze zaak hoorde, zo zocht hij Mozes te doden; doch Mozes vlood voor Farao's aangezicht, en woonde in het land Midian, en hij zat bij een waterput. ");
INSERT INTO nld_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","En de priester in Midian had zeven dochters, die kwamen om te putten, en vulden de drinkbakken, om de kudde haars vaders te drenken. ");
INSERT INTO nld_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Toen kwamen de herders, en zij dreven haar van daar; doch Mozes stond op, en verloste ze, en drenkte haar kudden. ");
INSERT INTO nld_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","En toen zij tot haar vader Rehuel kwamen, zo sprak hij: Waarom zijt gij heden zo haast wedergekomen? ");
INSERT INTO nld_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Toen zeiden zij: Een Egyptisch man heeft ons verlost uit de hand der herderen; en hij heeft ook overvloedig voor ons geput, en de kudde gedrenkt. ");
INSERT INTO nld_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","En hij zeide tot zijn dochters: Waar is hij toch, waarom liet gij den man nu gaan? roept hem, dat hij brood ete. ");
INSERT INTO nld_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","En Mozes bewilligde bij den man te wonen; en hij gaf Mozes zijn dochter Zippora; ");
INSERT INTO nld_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Die baarde een zoon; en hij noemde zijn naam Gersom; want hij zeide: Ik ben een vreemdeling geworden in een vreemd land. ");
INSERT INTO nld_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","En het geschiedde na vele dezer dagen, als de koning van Egypte gestorven was, dat de kinderen Israels zuchtten en schreeuwden over den dienst; en hun gekrijt over hun dienst kwam op tot God. ");
INSERT INTO nld_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","En God hoorde hun gekerm, en God gedacht aan Zijn verbond met Abraham, met Izak, en met Jakob. ");
INSERT INTO nld_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","En God zag de kinderen Israels aan, en God kende hen. ");
INSERT INTO nld_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","En Mozes hoedde de kudde van Jethro, zijn schoonvader, den priester in Midian; en hij leidde de kudde achter de woestijn, en hij kwam aan den berg Gods, aan Horeb. ");
INSERT INTO nld_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","En de Engel des HEEREN verscheen hem in een vuurvlam uit het midden van een braambos; en hij zag, en ziet, het braambos brandde in het vuur, en het braambos werd niet verteerd. ");
INSERT INTO nld_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","En Mozes zeide: Ik zal mij nu daarheen wenden, en bezien dat grote gezicht, waarom het braambos niet verbrandt. ");
INSERT INTO nld_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Toen de HEERE zag, dat hij zich daarheen wendde, om te bezien, zo riep God tot hem uit het midden van het braambos, en zeide: Mozes, Mozes! En hij zeide: Zie, hier ben ik! ");
INSERT INTO nld_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","En Hij zeide: Nader hier niet toe; trek uw schoenen uit van uw voeten; want de plaats, waarop gij staat, is heilig land. ");
INSERT INTO nld_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Hij zeide voorts: Ik ben de God uws vaders, de God van Abraham, de God van Izak en de God van Jakob. En Mozes verborg zijn aangezicht, want hij vreesde God aan te zien. ");
INSERT INTO nld_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","En de HEERE zeide: Ik heb zeer wel gezien de verdrukking Mijns volks, hetwelk in Egypte is, en heb hun geschrei gehoord, vanwege hun drijvers; want Ik heb hun smarten bekend. ");
INSERT INTO nld_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Daarom ben Ik nedergekomen, dat Ik het verlosse uit de hand der Egyptenaren, en het opvoere uit dit land, naar een goed en ruim land, naar een land, vloeiende van melk en honig, tot de plaats der Kanaanieten, en der Hethieten, en der Amorieten, en der Ferezieten, en der Hevieten, en der Jebusieten. ");
INSERT INTO nld_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","En nu, zie, het geschrei der kinderen Israels is tot Mij gekomen; en ook heb Ik gezien de verdrukking, waarmede de Egyptenaars hen verdrukken. ");
INSERT INTO nld_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Zo kom nu, en Ik zal u tot Farao zenden, opdat gij Mijn volk (de kinderen Israels) uit Egypte voert. ");
INSERT INTO nld_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Toen zeide Mozes tot God: Wie ben ik, dat ik tot Farao zou gaan; en dat ik de kinderen Israels uit Egypte zou voeren? ");
INSERT INTO nld_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Hij dan zeide: Ik zal voorzeker met u zijn, en dit zal u een teken zijn, dat Ik u gezonden heb: wanneer gij dit volk uit Egypte geleid hebt, zult gijlieden God dienen op dezen berg. ");
INSERT INTO nld_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Toen zeide Mozes tot God: Zie, wanneer ik kom tot de kinderen Israels, en zeg tot hen: De God uwer vaderen heeft mij tot ulieden gezonden; en zij mij zeggen: Hoe is Zijn naam? wat zal ik tot hen zeggen? ");
INSERT INTO nld_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","En God zeide tot Mozes: IK ZAL ZIJN, DIE IK ZIJN ZAL! Ook zeide Hij: Alzo zult gij tot de kinderen Israels zeggen: IK ZAL ZIJN heeft mij tot ulieden gezonden! ");
INSERT INTO nld_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Toen zeide God verder tot Mozes: Aldus zult gij tot de kinderen Israels zeggen: De HEERE, de God uwer vaderen, de God van Abraham, de God van Izak, en de God van Jakob, heeft mij tot ulieden gezonden; dat is Mijn Naam eeuwiglijk, en dat is Mijn gedachtenis van geslacht tot geslacht. ");
INSERT INTO nld_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ga heen, en verzamel de oudsten van Israel, en zeg tot hen: De HEERE, de God uwer vaderen, is mij verschenen, de God van Abraham, Izak en Jakob, zeggende: Ik heb ulieden getrouwelijk bezocht, en hetgeen ulieden in Egypte is aangedaan; ");
INSERT INTO nld_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Daarom heb Ik gezegd: Ik zal ulieden uit de verdrukking van Egypte opvoeren, tot het land der Kanaanieten, en der Hethieten, en der Amorieten, en der Ferezieten, en der Hevieten, en der Jebusieten; tot het land, vloeiende van melk en honig. ");
INSERT INTO nld_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","En zij zullen uw stem horen; en gij zult gaan, gij en de oudsten van Israel, tot den koning van Egypte, en gijlieden zult tot hem zeggen: De HEERE, de God der Hebreen, is ons ontmoet; zo laat ons nu toch gaan den weg van drie dagen in de woestijn, opdat wij den HEERE, onzen God, offeren! ");
INSERT INTO nld_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Doch Ik weet, dat de koning van Egypte ulieden niet zal laten gaan, ook niet door een sterke hand. ");
INSERT INTO nld_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Want Ik zal Mijn hand uitstrekken, en Egypte slaan met al Mijn wonderen, die Ik in het midden van hetzelve doen zal; daarna zal hij ulieden laten vertrekken. ");
INSERT INTO nld_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","En Ik zal dit volk genade geven in de ogen der Egyptenaren; en het zal geschieden, wanneer gijlieden uitgaan zult, zo zult gij niet ledig uitgaan. ");
INSERT INTO nld_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Maar elke vrouw zal van haar naburin, en van de waardin haars huizes, eisen zilveren vaten, en gouden vaten, en klederen; die zult gijlieden op uw zonen, en op uw dochteren leggen, en gij zult Egypte beroven. ");
INSERT INTO nld_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Toen antwoordde Mozes, en zeide: Maar zie, zij zullen mij niet geloven, noch mijn stem horen; want zij zullen zeggen: De HEERE is u niet verschenen! ");
INSERT INTO nld_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","En de HEERE zeide tot hem: Wat is er in uw hand? En hij zeide: Een staf. ");
INSERT INTO nld_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","En Hij zeide: Werp hem ter aarde. En hij wierp hem ter aarde! Toen werd hij tot een slang; en Mozes vlood van haar. ");
INSERT INTO nld_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Toen zeide de HEERE tot Mozes: Strek uw hand uit, en grijp haar bij haar staart! Toen strekte hij zijn hand uit, en vatte haar, en zij werd tot een staf in zijn hand. ");
INSERT INTO nld_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Opdat zij geloven, dat u verschenen is de HEERE, de God hunner vaderen, de God van Abraham, de God van Izak, en de God van Jakob. ");
INSERT INTO nld_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","En de HEERE zeide verder tot hem: Steek nu uw hand in uw boezem. En hij stak zijn hand in zijn boezem; daarna trok hij ze uit, en ziet, zijn hand was melaats, wit als sneeuw. ");
INSERT INTO nld_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","En Hij zeide: Steek uw hand wederom in uw boezem. En hij stak zijn hand wederom in zijn boezem; daarna trok hij ze uit zijn boezem, en ziet, zij was weder als zijn ander vlees. ");
INSERT INTO nld_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","En het zal geschieden, zo zij u niet geloven, noch naar de stem van het eerste teken horen, zo zullen zij de stem van het laatste teken geloven. ");
INSERT INTO nld_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","En het zal geschieden, zo zij ook deze twee tekenen niet geloven, noch naar uw stem horen, zo neem van de wateren der rivier, en giet ze op het droge; zo zullen de wateren, die gij uit de rivier zult nemen, diezelve zullen tot bloed worden op het droge. ");
INSERT INTO nld_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Toen zeide Mozes tot den HEERE: Och Heere! ik ben geen man wel ter tale, noch van gisteren, noch van eergisteren, noch van toen af, toen Gij tot Uw knecht gesproken hebt; want ik ben zwaar van mond, en zwaar van tong. ");
INSERT INTO nld_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","En de HEERE zeide tot hem: Wie heeft den mens den mond gemaakt, of wie heeft den stomme, of dove, of ziende, of blinde gemaakt? Ben Ik het niet, de HEERE? ");
INSERT INTO nld_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","En nu ga henen, en Ik zal met uw mond zijn, en zal u leren, wat gij spreken zult. ");
INSERT INTO nld_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Doch hij zeide: Och, Heere! zend toch door de hand desgenen, dien Gij zoudt zenden. ");
INSERT INTO nld_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Toen ontstak de toorn des HEEREN over Mozes, en Hij zeide: is niet Aaron, de Leviet, uw broeder? Ik weet, dat hij zeer wel spreken zal, en ook, zie, hij zal uitgaan u tegemoet; wanneer hij u ziet, zo zal hij in zijn hart verblijd zijn. ");
INSERT INTO nld_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Gij dan zult tot hem spreken, en de woorden in zijn mond leggen; en Ik zal met uw mond, en met zijn mond zijn; en Ik zal ulieden leren, wat gij doen zult. ");
INSERT INTO nld_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","En hij zal voor u tot het volk spreken; en het zal geschieden, dat hij u tot een mond zal zijn, en gij zult hem tot een god zijn. ");
INSERT INTO nld_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Neem dan dezen staf in uw hand, waarmede gij die tekenen doen zult. ");
INSERT INTO nld_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Toen ging Mozes heen, en keerde weder tot Jethro, zijn schoonvader, en zeide tot hem: Laat mij toch gaan, dat ik wederkere tot mijn broederen, die in Egypte zijn, en zie, of zij nog leven. Jethro dan zeide tot Mozes: Ga in vrede! ");
INSERT INTO nld_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ook zeide de HEERE tot Mozes in Midian: Ga heen, keer weder in Egypte, want al de mannen zijn dood, die uw ziel zochten. ");
INSERT INTO nld_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mozes dan nam zijn vrouw, en zijn zonen, en voerde hen op een ezel, en keerde weder in Egypteland; en Mozes nam den staf Gods in zijn hand. ");
INSERT INTO nld_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","En de HEERE zeide tot Mozes: Terwijl gij heentrekt, om weder in Egypte te keren, zie toe, dat gij al de wonderen doet voor Farao, die Ik in uw hand gesteld heb; doch Ik zal zijn hart verstokken, dat hij het volk niet zal laten gaan. ");
INSERT INTO nld_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dan zult gij tot Farao zeggen: Alzo zegt de HEERE: Mijn zoon, Mijn eerstgeborene, is Israel. ");
INSERT INTO nld_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","En Ik heb tot u gezegd: Laat Mijn zoon trekken, dat hij Mij diene! maar gij hebt geweigerd hem te laten trekken; zie, Ik zal uw zoon, uw eerstgeborene doden! ");
INSERT INTO nld_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","En het geschiedde op den weg, in de herberg, dat de HEERE hem tegenkwam, en zocht hem te doden. ");
INSERT INTO nld_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Toen nam Zippora een stenen mes en besneed de voorhuid haars zoons, en wierp die voor zijn voeten, en zeide: Voorwaar, gij zijt mij een bloedbruidegom! ");
INSERT INTO nld_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","En Hij liet van hem af. Toen zeide zij: Bloedbruidegom! vanwege de besnijdenis. ");
INSERT INTO nld_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","De HEERE zeide ook tot Aaron: Ga Mozes tegemoet in de woestijn. En hij ging, en ontmoette hem aan den berg Gods, en hij kuste hem. ");
INSERT INTO nld_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","En Mozes gaf Aaron te kennen al de woorden des HEEREN, Die hem gezonden had, en al de tekenen, die Hij hem bevolen had. ");
INSERT INTO nld_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Toen ging Mozes en Aaron, en zij verzamelden al de oudsten der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","En Aaron sprak al de woorden, die de HEERE tot Mozes gesproken had; en hij deed de tekenen voor de ogen des volks. ");
INSERT INTO nld_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","En het volk geloofde, en zij hoorden, dat de HEERE de kinderen Israels bezocht, en dat Hij hun verdrukking zag, en zij neigden hun hoofden, en aanbaden. ");
INSERT INTO nld_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","En daarna gingen Mozes en Aaron heen, en zeiden tot Farao: Alzo zegt de HEERE, de God van Israel: Laat Mijn volk trekken, dat het Mij een feest houde in de woestijn! ");
INSERT INTO nld_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maar Farao zeide: Wie is de HEERE, Wiens stem ik gehoorzamen zou, om Israel te laten trekken? Ik ken den HEERE niet, en ik zal ook Israel niet laten trekken. ");
INSERT INTO nld_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Zij dan zeiden: De God der Hebreen is ons ontmoet; zo laat ons toch heentrekken, den weg van drie dagen in de woestijn, en den HEERE, onzen God, offeren, dat Hij ons niet overkome met pestilentie, of met het zwaard. ");
INSERT INTO nld_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Toen zeide de koning van Egypte tot hen: Gij, Mozes en Aaron! waarom trekt gij het volk af van hun werken? Gaat heen tot uw lasten. ");
INSERT INTO nld_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Verder zeide Farao: Ziet, het volk des lands is alreeds te veel; en zoudt gijlieden hen doen rusten van hun lasten? ");
INSERT INTO nld_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Daarom beval Farao, ten zelfden dage, aan de aandrijvers onder het volk, en deszelfs ambtlieden, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Gij zult voortaan aan deze lieden geen stro meer geven, tot het maken der tichelstenen, als gisteren en eergisteren; laat hen zelven heengaan, en stro voor zichzelven verzamelen. ");
INSERT INTO nld_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","En het getal der tichelstenen, die zij gisteren en eergisteren gemaakt hebben, zult gij hun opleggen; gij zult daarvan niet verminderen; want zij gaan ledig; daarom roepen zij, zeggende: Laat ons gaan, laat ons onzen God offeren! ");
INSERT INTO nld_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Men verzware den dienst over deze mannen, dat zij daaraan te doen hebben, en zich niet vergapen aan leugenachtige woorden. ");
INSERT INTO nld_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Toen gingen de aandrijvers des volks uit, en deszelfs ambtlieden, en spraken tot het volk, zeggende: Zo zegt Farao: Ik zal ulieden geen stro geven. ");
INSERT INTO nld_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gaat gij zelve heen, haalt u stro, waar gij het vindt; doch van uw dienst zal niet verminderd worden. ");
INSERT INTO nld_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Toen verstrooide zich het volk in het ganse land van Egypte, dat het stoppelen verzamelde, voor stro. ");
INSERT INTO nld_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","En de aandrijvers drongen aan, zeggende: Voleindigt uw werken, elk dagwerk op zijn dag, gelijk toen er stro was. ");
INSERT INTO nld_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","En de ambtlieden der kinderen Israels, die Farao's aandrijvers over hen gesteld hadden, werden geslagen, en men zeide: Waarom hebt gijlieden uw gezette werk niet voleindigd, in het maken der tichelstenen, gelijk te voren, alzo ook gisteren en heden? ");
INSERT INTO nld_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Derhalve gingen de ambtlieden der kinderen Israels, en schreeuwden tot Farao, zeggende: Waarom doet gij uw knechten alzo? ");
INSERT INTO nld_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Aan uw knechten wordt geen stro gegeven, en zij zeggen tot ons: Maakt de tichelstenen; en ziet, uw knechten worden geslagen, doch de schuld is uws volks! ");
INSERT INTO nld_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Hij dan zeide: Gijlieden gaat ledig, ledig gaat gij; daarom zegt gij: Laat ons gaan, laat ons den HEERE offeren! ");
INSERT INTO nld_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Zo gaat nu heen, arbeidt; doch stro zal u niet gegeven worden; evenwel zult gij het getal der tichelstenen leveren. ");
INSERT INTO nld_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Toen zagen de ambtlieden der kinderen Israels, dat het kwalijk met hen stond, dewijl men zeide: Gij zult niet minderen van uw tichelstenen, van het dagwerk op zijn dag. ");
INSERT INTO nld_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","En zij ontmoetten Mozes en Aaron, die tegen hen over stonden, toen zij van Farao uitgingen. ");
INSERT INTO nld_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","En zeiden tot hen: De HEERE zie op u, en richte het, dewijl dat gij onzen reuk hebt stinkende gemaakt voor Farao, en voor zijn knechten, gevende een zwaard in hun handen, om ons te doden. ");
INSERT INTO nld_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Toen keerde Mozes weder tot den HEERE, en zeide: Heere! waarom hebt Gij dit volk kwaad gedaan, waarom hebt Gij mij nu gezonden? ");
INSERT INTO nld_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Want van toen af, dat ik tot Farao ben ingegaan, om in Uw naam te spreken, heeft hij dit volk kwaad gedaan; en Gij hebt Uw volk geenszins verlost. ");
INSERT INTO nld_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","(5:24) Toen zeide de HEERE tot Mozes: Nu zult gij zien, wat Ik aan Farao doen zal; want door een machtige hand zal hij hen laten trekken, ja, door een machtige hand zal hij hen uit zijn land drijven. ");
INSERT INTO nld_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","(6:1) Verder sprak God tot Mozes, en zeide tot hem: Ik ben de HEERE, ");
INSERT INTO nld_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","(6:2) En Ik ben aan Abraham, Izak, en Jakob verschenen, als God de Almachtige; doch met Mijn Naam HEERE ben Ik hun niet bekend geweest. ");
INSERT INTO nld_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","(6:3) En ook heb Ik Mijn verbond met hen opgericht, dat Ik hun geven zou het land Kanaan, het land hunner vreemdelingschappen, waarin zij vreemdelingen geweest zijn. ");
INSERT INTO nld_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","(6:4) En ook heb Ik gehoord het gekerm der kinderen Israels, die de Egyptenaars in dienstbaarheid houden, en Ik heb aan Mijn verbond gedacht. ");
INSERT INTO nld_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","(6:5) Derhalve zeg tot de kinderen Israels: Ik ben de HEERE! en Ik zal ulieden uitleiden van onder de lasten der Egyptenaren, en Ik zal u redden uit hun dienstbaarheid, en zal u verlossen door een uitgestrekten arm, en door grote gerichten; ");
INSERT INTO nld_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","(6:6) En Ik zal ulieden tot Mijn volk aannemen, en Ik zal u tot een God zijn; en gijlieden zult bekennen, dat Ik de HEERE uw God ben, Die u uitleide van onder de lasten der Egyptenaren. ");
INSERT INTO nld_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","(6:7) En Ik zal ulieden brengen in dat land, waarover Ik Mijn hand opgeheven heb, dat Ik het aan Abraham, Izak, en Jakob geven zou; en Ik zal het ulieden geven tot een erfdeel, Ik, de HEERE! ");
INSERT INTO nld_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","(6:8) En Mozes sprak alzo tot de kinderen Israels; doch zij hoorden naar Mozes niet, vanwege de benauwdheid des geestes, en vanwege de harde dienstbaarheid. ");
INSERT INTO nld_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","(6:9) Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","(6:10) Ga heen, spreek tot Farao, den koning van Egypte, dat hij de kinderen Israels uit zijn land trekken late. ");
INSERT INTO nld_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","(6:11) Doch Mozes sprak voor den HEERE, zeggende: Zie, de kinderen Israels hebben naar mij niet gehoord; hoe zou mij dan Farao horen? daartoe ben ik onbesneden van lippen. ");
INSERT INTO nld_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","(6:12) Evenwel sprak de HEERE tot Mozes en tot Aaron, en gaf hun bevel aan de kinderen Israels, en aan Farao, den koning van Egypte, om de kinderen Israels uit Egypteland te leiden. ");
INSERT INTO nld_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","(6:13) Dit zijn de hoofden van ieder huis hunner vaderen: de zonen van Ruben, den eerstgeborene van Israel, zijn Hanoch en Pallu, Hezron en Charmi; dit zijn de huisgezinnen van Ruben. ");
INSERT INTO nld_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","(6:14) En de zonen van Simeon: Jemuel, en Jamin, en Ohad, en Jachin, en Zohar, en Saul, de zoon ener Kanaanietische; dit zijn de huisgezinnen van Simeon. ");
INSERT INTO nld_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","(6:15) Dit nu zijn de namen der zonen van Levi, naar hun geboorten: Gerson, en Kehath, en Merari. En de jaren des levens van Levi waren honderd zeven en dertig jaren. ");
INSERT INTO nld_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","(6:16) De zonen van Gerson: Libni en Simei, naar hun huisgezinnen. ");
INSERT INTO nld_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","(6:17) En de zonen van Kehath: Amram, en Jizhar, en Hebron, en Uzziel, en de jaren des levens van Kehath waren honderd drie en dertig jaren. ");
INSERT INTO nld_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","(6:18) En de zonen van Merari: Machli en Musi; dit zijn de huisgezinnen van Levi, naar hun geboorten. ");
INSERT INTO nld_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","(6:19) En Amram nam Jochebed, zijn moei, zich tot een huisvrouw, en zij baarde hem Aaron en Mozes; en de jaren des levens van Amram waren honderd zeven en dertig jaren. ");
INSERT INTO nld_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","(6:20) En de zonen van Jizhar: Korah, en Nefeg, en Zichri. ");
INSERT INTO nld_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","(6:21) En de zonen van Uzziel: Misael, en Elzafan, en Sithri. ");
INSERT INTO nld_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","(6:22) En Aaron nam zich tot een vrouw Eliseba, dochter van Amminadab, zuster van Nahesson; en zij baarde hem Nadab en Abihu, Eleazar en Ithamar. ");
INSERT INTO nld_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","(6:23) En de zonen van Korah waren: Assir, en Elkana, en Abiasaf; dat zijn de huisgezinnen der Korachieten. ");
INSERT INTO nld_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","(6:24) En Eleazar, de zoon van Aaron, nam voor zich een van de dochteren van Putiel tot een vrouw; en zij baarde hem Pinehas. Dit zijn de hoofden van de vaderen der Levieten, naar hun huisgezinnen. ");
INSERT INTO nld_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","(6:25) Dit is Aaron en Mozes, tot welke de HEERE zeide: Leidt de kinderen Israels uit Egypteland, naar hun heiren. ");
INSERT INTO nld_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","(6:26) Dezen zijn het, die tot Farao, den koning van Egypte, spraken, opdat zij de kinderen Israels uit Egypte leidden; dit is Mozes en Aaron. ");
INSERT INTO nld_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","(6:27) En het geschiedde te dien dage, als de HEERE tot Mozes sprak in Egypteland; ");
INSERT INTO nld_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","(6:28) Zo sprak de HEERE tot Mozes, zeggende: Ik ben de HEERE! spreek tot Farao, den koning van Egypte, alles, wat Ik tot u spreek. ");
INSERT INTO nld_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","(6:29) Toen zeide Mozes voor het aangezicht des HEEREN: Zie, ik ben onbesneden van lippen; hoe zal dan Farao naar mij horen? ");
INSERT INTO nld_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Toen zeide de HEERE tot Mozes: Zie, Ik heb u tot een God gezet over Farao; en Aaron, uw broeder, zal uw profeet zijn. ");
INSERT INTO nld_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Gij zult spreken alles, wat Ik u gebieden zal; en Aaron, uw broeder, zal tot Farao spreken, dat hij de kinderen Israels uit zijn land trekken laat. ");
INSERT INTO nld_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Doch Ik zal Farao's hart verharden; en Ik zal Mijn tekenen en Mijn wonderheden in Egypteland vermenigvuldigen. ");
INSERT INTO nld_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Farao nu zal naar ulieden niet horen, en Ik zal Mijn hand aan Egypte leggen, en voeren Mijn heiren, Mijn volk, de kinderen Israels, uit Egypteland, door grote gerichten. ");
INSERT INTO nld_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Dan zullen de Egyptenaars weten, dat Ik de HEERE ben, wanneer Ik Mijn hand over Egypte uitstrekke, en de kinderen Israels uit het midden van hen uitleide. ");
INSERT INTO nld_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Toen deed Mozes en Aaron, als hun de HEERE geboden had, alzo deden zij. ");
INSERT INTO nld_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","En Mozes was tachtig jaar oud, en Aaron was drie en tachtig jaar oud, toen zij tot Farao spraken. ");
INSERT INTO nld_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","En de HEERE sprak tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wanneer Farao tot ulieden spreken zal, zeggende: Doet een wonderteken voor ulieden; zo zult gij tot Aaron zeggen: Neem uw staf, en werp hem voor Farao's aangezicht neder; hij zal tot een draak worden. ");
INSERT INTO nld_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Toen ging Mozes en Aaron tot Farao henen in, en deden alzo, gelijk de HEERE geboden had; en Aaron wierp zijn staf neder voor Farao's aangezicht, en voor het aangezicht zijner knechten; en hij werd tot een draak. ");
INSERT INTO nld_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao nu riep ook de wijzen en de guichelaars; en de Egyptische tovenaars deden ook alzo met hun bezweringen. ");
INSERT INTO nld_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Want een iegelijk wierp zijn staf neder, en zij werden tot draken; maar Aarons staf verslond hun staven. ");
INSERT INTO nld_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Doch Farao's hart verstokte, zodat hij naar hen niet hoorde, gelijk de HEERE gesproken had. ");
INSERT INTO nld_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Toen zeide de HEERE tot Mozes: Farao's hart is zwaar; hij weigert het volk te laten trekken. ");
INSERT INTO nld_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ga heen tot Farao in den morgenstond; zie, hij zal uitgaan naar het water toe, zo stel u tegen hem over aan den oever der rivier, en den staf, die in een slang is veranderd geweest, zult gij in uw hand nemen. ");
INSERT INTO nld_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","En gij zult tot hem zeggen: de HEERE, de God der Hebreen, heeft mij tot u gezonden, zeggende: Laat Mijn volk trekken, dat het Mij diene in de woestijn; doch zie, gij hebt tot nu toe niet gehoord. ");
INSERT INTO nld_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Zo zegt de HEERE: Daaraan zult gij weten, dat Ik de HEERE ben; zie, ik zal met dezen staf, die in mijn hand is, op het water, dat in deze rivier is, slaan, en het zal in bloed veranderd worden. ");
INSERT INTO nld_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","En de vis in de rivier zal sterven, zodat de rivier zal stinken; en de Egyptenaars zullen vermoeid worden, dat zij het water uit de rivier drinken mogen. ");
INSERT INTO nld_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Verder zeide de HEERE tot Mozes: zeg tot Aaron: Neem uw staf, en steek uw hand uit over de wateren der Egyptenaren, over hun stromen, over hun rivieren, en over hun poelen, en over alle vergadering hunner wateren, dat zij bloed worden; en er zij bloed in het ganse Egypteland, beide in houten en in stenen vaten. ");
INSERT INTO nld_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mozes nu en Aaron deden alzo, gelijk de HEERE geboden had; en hij hief den staf op, en sloeg het water, dat in de rivier was, voor de ogen van Farao, en voor de ogen van zijn knechten; en al het water in de rivier werd in bloed veranderd. ");
INSERT INTO nld_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","En de vis, die in de rivier was, stierf; en de rivier stonk, zodat de Egyptenaars het water uit de rivier niet drinken konden; en er was bloed in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Doch de Egyptische tovenaars deden ook alzo met hun bezweringen; zodat Farao's hart verstokte, en hij hoorde naar hen niet, gelijk als de HEERE gesproken had. ");
INSERT INTO nld_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","En Farao keerde zich om, en ging naar zijn huis; en hij zette zijn hart daar ook niet op. ");
INSERT INTO nld_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Doch alle Egyptenaars groeven rondom de rivier, om water te drinken; want zij konden van het water der rivier niet drinken. ");
INSERT INTO nld_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Alzo werden zeven dagen vervuld, nadat de HEERE de rivier geslagen had. ");
INSERT INTO nld_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Daarna zeide de HEERE tot Mozes: Ga in tot Farao, en zeg tot hem: Zo zegt de HEERE: Laat Mijn volk trekken, dat zij Mij dienen. ");
INSERT INTO nld_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","En indien gij het weigert te laten trekken, zie, zo zal ik uw ganse landpale met vorsen slaan; ");
INSERT INTO nld_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Dat de rivier van vorsen zal krielen, die zullen opkomen, en in uw huis komen, en in uw slaapkamer, ja, op uw bed; ook in de huizen uwer knechten, en op uw volk, en in uw bakovens, en in uw baktroggen. ");
INSERT INTO nld_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","En de vorsen zullen opkomen, op u, en op uw volk, en op al uw knechten. ");
INSERT INTO nld_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Verder zeide de HEERE tot Mozes: Zeg tot Aaron: Strek uw hand uit met uw staf, over de stromen, en over de rivieren, en over de poelen; en doe vorsen opkomen over Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","En Aaron strekte zijn hand uit over de wateren van Egypte, en er kwamen vorsen op en bedekten Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Toen deden de tovenaars ook alzo, met hun bezweringen; en zij deden vorsen over Egypteland opkomen. ");
INSERT INTO nld_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","En Farao riep Mozes en Aaron, en zeide: Bidt vuriglijk tot den HEERE, dat Hij de vorsen van mij en van mijn volk wegneme; zo zal ik het volk trekken laten, dat zij den HEERE offeren. ");
INSERT INTO nld_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Doch Mozes zeide tot Farao: Heb de eer boven mij! Tegen wanneer zal ik voor u, en voor uw knechten, en voor uw volk, vuriglijk bidden, om deze vorsen van u en van uw huizen te verdelgen, dat zij alleen in de rivier overblijven? ");
INSERT INTO nld_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Hij dan zeide: Tegen morgen. En hij zeide: Het zij naar uw woord, opdat gij weet, dat er niemand is, gelijk de HEERE, onze God. ");
INSERT INTO nld_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Zo zullen de vorsen van u, en van uw huizen, en van uw knechten, en van uw volk wijken; zij zullen alleen in de rivier overblijven. ");
INSERT INTO nld_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Toen ging Mozes en Aaron uit van Farao; en Mozes riep tot den HEERE, ter oorzake der vorsen, die Hij Farao had opgelegd. ");
INSERT INTO nld_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","En de HEERE deed naar het woord van Mozes; en de vorsen stierven, uit de huizen, uit de voorzalen, en uit de velden. ");
INSERT INTO nld_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","En zij vergaderden ze samen bij hopen, en het land stonk. ");
INSERT INTO nld_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Toen nu Farao zag, dat er verademing was, verzwaarde hij zijn hart, dat hij naar hen niet hoorde, gelijk als de HEERE gesproken had. ");
INSERT INTO nld_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Verder zeide de HEERE tot Mozes: Zeg tot Aaron: Strek uw staf uit, en sla het stof der aarde, dat het tot luizen worde, in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","En zij deden alzo; want Aaron strekte zijn hand uit met zijn staf, en sloeg het stof der aarde, en er werden vele luizen aan de mensen, en aan het vee; al het stof der aarde werd luizen, in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","De tovenaars deden ook alzo met hun bezweringen, opdat zij luizen voortbrachten; doch zij konden niet; zo waren de luizen aan de mensen, en aan het vee. ");
INSERT INTO nld_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Toen zeiden de tovenaars tot Farao: Dit is Gods vinger! Doch Farao's hart verstijfde, zodat hij naar hen niet hoorde, gelijk de HEERE gesproken had. ");
INSERT INTO nld_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Verder zeide de HEERE tot Mozes: Maak u morgen vroeg op, en stel u voor Farao's aangezicht; zie, hij zal aan het water uitgaan, en zeg tot hem: Zo zegt de HEERE: Laat Mijn volk trekken, dat zij Mij dienen; ");
INSERT INTO nld_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Want zo gij Mijn volk niet laat trekken, zie, zo zal Ik een vermenging van ongedierte zenden op u, en op uw knechten, en op uw volk, en in uw huizen; alzo dat de huizen der Egyptenaren met deze vermenging zullen vervuld worden, en ook het aardrijk, waarop zij zijn. ");
INSERT INTO nld_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","En Ik zal te dien dage het land Gosen, waarin Mijn volk woont, afzonderen, dat daar geen vermenging van ongedierte zij, opdat gij weet, dat Ik, de HEERE, in het midden dezes lands ben. ");
INSERT INTO nld_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","En Ik zal een verlossing zetten tussen Mijn volk en tussen uw volk; tegen morgen zal dit teken geschieden! ");
INSERT INTO nld_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","En de HEERE deed alzo; en er kwam een zware vermenging van ongedierte in het huis van Farao, en in de huizen van zijn knechten, en over het ganse Egypteland; het land werd verdorven van deze vermenging. ");
INSERT INTO nld_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Toen riep Farao Mozes en Aaron, en zeide: Gaat heen, en offert uwen God in dit land. ");
INSERT INTO nld_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mozes dan zeide: Het is niet recht, dat men alzo doe; want wij zouden der Egyptenaren gruwel den HEERE, onzen God, mogen offeren; zie, indien wij der Egyptenaren gruwel voor hun ogen offerden, zouden zij ons niet stenigen? ");
INSERT INTO nld_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Laat ons den weg van drie dagen in de woestijn gaan, dat wij den HEERE onzen God offeren, gelijk Hij tot ons zeggen zal. ");
INSERT INTO nld_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Toen zeide Farao: Ik zal u trekken laten, dat gijlieden den HEERE, uwen God, offert in de woestijn; alleen, dat gijlieden in het gaan geenszins te verre trekt! Bidt vuriglijk voor mij. ");
INSERT INTO nld_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mozes nu zeide: Zie, ik ga van u, en zal tot den HEERE vuriglijk bidden, dat deze vermenging van ongedierte van Farao, van zijn knechten, en van zijn volk morgen wegwijke! Alleen, dat Farao niet meer bedriegelijk handele, dit volk niet latende gaan, om den HEERE te offeren. ");
INSERT INTO nld_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Toen ging Mozes uit van Farao, en bad vuriglijk tot den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","En de HEERE deed naar het woord van Mozes, en de vermenging van ongedierte week van Farao, van zijn knechten, en van zijn volk; er bleef niet een over. ");
INSERT INTO nld_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Doch Farao verzwaarde zijn hart ook op ditmaal, en hij liet het volk niet trekken. ");
INSERT INTO nld_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Daarna zeide de HEERE tot Mozes: Ga in tot Farao, en spreek tot hem: Alzo zegt de HEERE, de God der Hebreen: Laat Mijn volk trekken, dat het Mij diene. ");
INSERT INTO nld_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Want zo gij hen weigert te laten trekken, en gij hen nog met geweld ophoudt, ");
INSERT INTO nld_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Zie, de hand des HEEREN zal zijn over uw vee, dat in het veld is, over de paarden, over de ezelen, over de kemelen, over de runderen, en over het klein vee, door een zeer zware pestilentie. ");
INSERT INTO nld_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","En de HEERE zal een afzondering maken tussen het vee der Israelieten, en tussen het vee der Egyptenaren, dat er niets sterve van al wat van de kinderen Israels is. ");
INSERT INTO nld_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","En de HEERE bestemde een zekeren tijd, zeggende: Morgen zal de HEERE deze zaak in dit land doen. ");
INSERT INTO nld_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","En de HEERE deed deze zaak des anderen daags; en al het vee der Egyptenaren stierf; maar van het vee der kinderen Israels stierf niet een. ");
INSERT INTO nld_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","En Farao zond er heen, en ziet, van het vee van Israel was niet tot een toe gestorven. Doch het hart van Farao werd verzwaard, en hij liet het volk niet trekken. ");
INSERT INTO nld_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Toen zeide de HEERE tot Mozes en tot Aaron: Neemt gijlieden uw vuisten vol as uit den oven; en Mozes strooie die naar den hemel voor de ogen van Farao. ");
INSERT INTO nld_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","En zij zal tot klein stof worden over het ganse Egypteland; en zij zal aan de mensen, en aan het vee worden tot zweren, uitbrekende met blaren, in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","En zij namen as uit den oven, en stonden voor Farao's aangezicht; en Mozes strooide die naar den hemel; toen werden er zweren, uitbrekende met blaren, aan de mensen en aan het vee; ");
INSERT INTO nld_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Alzo dat de tovenaars voor Mozes niet staan konden, vanwege de zweren; want aan de tovenaars waren zweren, en aan al de Egyptenaren. ");
INSERT INTO nld_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Doch de HEERE verstokte Farao's hart, dat hij naar hen niet hoorde, gelijk de HEERE tot Mozes gesproken had. ");
INSERT INTO nld_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Toen zeide de HEERE tot Mozes: Maak u morgen vroeg op, en stel u voor Farao's aangezicht, en zeg tot hem: Zo zegt de HEERE, de God der Hebreen: Laat Mijn volk trekken, dat zij Mij dienen. ");
INSERT INTO nld_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Want ditmaal zal Ik al Mijn plagen in uw hart zenden, en over uw knechten, en over uw volk, opdat gij weet, dat er niemand is gelijk Ik, op de ganse aarde. ");
INSERT INTO nld_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Want nu heb Ik Mijn hand uitgestrekt, opdat Ik u en uw volk met de pestilentie zou slaan, en dat gij van de aarde zoudt verdelgd worden. ");
INSERT INTO nld_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Maar waarlijk, daarom heb Ik u verwekt, opdat Ik Mijn kracht aan u betoonde, en opdat men Mijn Naam vertelle op de ganse aarde. ");
INSERT INTO nld_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Verheft gij uzelven nog tegen Mijn volk, dat gij het niet wilt laten trekken? ");
INSERT INTO nld_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Zie, Ik zal morgen omtrent dezen tijd een zeer zwaren hagel doen regenen, desgelijks in Egypte niet geweest is van dien dag af, dat het gegrond is, tot nu toe. ");
INSERT INTO nld_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","En nu, zend heen, vergader uw vee, en alles wat gij op het veld hebt; alle mens en gedierte, dat op het veld gevonden zal worden, en niet in huis verzameld zal zijn, als deze hagel op hen vallen zal, zo zullen zij sterven. ");
INSERT INTO nld_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wie onder Farao's knechten des HEEREN woord vreesde, die deed zijn knechten en zijn vee in de huizen vlieden; ");
INSERT INTO nld_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Doch die zijn hart niet zette tot des HEEREN woord, die liet zijn knechten en zijn vee op het veld. ");
INSERT INTO nld_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Toen zeide de HEERE tot Mozes: Strek uw hand uit naar den hemel, en er zal hagel zijn in het ganse Egypteland; over de mensen, en over het vee, en over al het kruid des velds in Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Toen strekte Mozes zijn staf naar den hemel; en de HEERE gaf donder en hagel, en het vuur schoot naar de aarde; en de HEERE liet hagel regenen over Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","En er was hagel, en vuur in het midden des hagels vervangen; hij was zeer zwaar; desgelijks is in het ganse Egypteland nooit geweest, sedert het tot een volk geweest is. ");
INSERT INTO nld_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","En de hagel sloeg, in het ganse Egypteland, alles wat op het veld was, van de mensen af tot de beesten toe; ook sloeg de hagel al het kruid des velds, en verbrak al het geboomte des velds. ");
INSERT INTO nld_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Alleen in het land Gosen, waar de kinderen Israels waren, daar was geen hagel. ");
INSERT INTO nld_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Toen schikte Farao heen, en hij riep Mozes en Aaron, en zeide tot hen: Ik heb mij ditmaal verzondigd; de HEERE is rechtvaardig; ik daarentegen en mijn volk zijn goddelozen! ");
INSERT INTO nld_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bidt vuriglijk tot den HEERE (want het is genoeg), dat geen donder Gods noch hagel meer zij; dan zal ik ulieden trekken laten, en gij zult niet langer blijven. ");
INSERT INTO nld_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Toen zeide Mozes tot hem: Wanneer ik ter stad uitgegaan zal zijn, zo zal ik mijn handen uitbreiden voor den HEERE; de donder zal ophouden, en de hagel zal niet meer zijn; opdat gij weet, dat de aarde des HEEREN is! ");
INSERT INTO nld_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nochtans u en uw knechten aangaande, weet ik, dat gijlieden voor het aangezicht van den HEERE God nog niet vrezen zult. ");
INSERT INTO nld_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Het vlas nu, en de gerst werd geslagen; want de gerst was in de aar, en het vlas was in den halm. ");
INSERT INTO nld_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Maar de tarwe en de spelt werden niet geslagen; want zij waren bedekt. ");
INSERT INTO nld_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Zo ging Mozes van Farao ter stad uit, en breidde zijn handen tot den HEERE; de donder en de hagel hielden op, en de regen werd niet meer uitgegoten op de aarde. ");
INSERT INTO nld_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Toen Farao zag, dat de regen en hagel, en de donder ophielden, zo verzondigde hij zich verder, en hij verzwaarde zijn hart, hij en zijn knechten. ");
INSERT INTO nld_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Alzo werd Farao's hart verstokt, dat hij de kinderen Israels niet trekken liet, gelijk als de HEERE gesproken had door Mozes. ");
INSERT INTO nld_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Daarna zeide de HEERE tot Mozes: Ga in tot Farao; want Ik heb zijn hart verzwaard, ook het hart zijner knechten, opdat Ik deze Mijn tekenen in het midden van hen zette; ");
INSERT INTO nld_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","En opdat gij voor de oren uwer kinderen en uwer kindskinderen moogt vertellen, wat Ik in Egypte uitgericht heb, en Mijn tekenen, die Ik onder hen gesteld heb; opdat gijlieden weet, dat Ik de HEERE ben. ");
INSERT INTO nld_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Zo gingen Mozes en Aaron tot Farao, en zeiden tot hem: Zo zegt de HEERE, de God der Hebreen: Hoe lang weigert gij u voor Mijn aangezicht te verootmoedigen? Laat Mijn volk trekken, dat zij Mij dienen. ");
INSERT INTO nld_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Want indien gij weigert Mijn volk te laten trekken, zie, zo zal Ik morgen sprinkhanen in uw landpale brengen. ");
INSERT INTO nld_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","En zij zullen het gezicht des lands bedekken, alzo dat men de aarde niet zal kunnen zien; en zij zullen afeten het overige van hetgeen ontkomen is, hetgeen ulieden overgebleven was van den hagel; zij zullen ook al het geboomte afeten, dat ulieden uit het veld voortkomt. ");
INSERT INTO nld_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","En zij zullen vervullen uw huizen, en de huizen van al uw knechten, en de huizen van alle Egyptenaren; dewelke uw vaders, noch de vaderen uwer vaders gezien hebben, van dien dag af, dat zij op den aardbodem geweest zijn, tot op dezen dag. En hij keerde zich om, en ging uit van Farao. ");
INSERT INTO nld_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","En de knechten van Farao zeiden tot hem: Hoe lang zal ons deze tot een strik zijn, laat de mannen trekken, dat zij den HEERE hun God dienen! weet gij nog niet, dat Egypte verloren is? ");
INSERT INTO nld_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Toen werden Mozes en Aaron weder tot Farao gebracht, en hij zeide tot hen: Gaat henen, dient den HEERE, uw God! wie en wie zijn zij, die gaan zullen? ");
INSERT INTO nld_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","En Mozes zeide: Wij zullen gaan met onze jonge en met onze oude lieden; met onze zonen en met onze dochteren, met onze schapen en met onze runderen zullen wij gaan; want wij hebben een feest des HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Toen zeide hij tot hen: De HEERE zij alzo met ulieden, gelijk ik u en uw kleine kinderen zal trekken laten: ziet toe, want er is kwaad voor ulieder aangezicht! ");
INSERT INTO nld_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Niet alzo gij, mannen, gaat nu heen, en dient den HEERE; want dat hebt gijlieden verzocht! En men dreef hen uit van Farao's aangezicht. ");
INSERT INTO nld_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Toen zeide de HEERE tot Mozes: Strek uw hand uit over Egypteland, om de sprinkhanen, dat zij opkomen over Egypteland, en al het kruid des lands opeten, al wat de hagel heeft over gelaten. ");
INSERT INTO nld_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Toen strekte Mozes zijn staf over Egypteland, en de HEERE bracht een oostenwind in dat land, dien gehele dag en dien gansen nacht; het geschiedde des morgens, dat de oostenwind de sprinkhanen opbracht. ");
INSERT INTO nld_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","En de sprinkhanen kwamen op over het ganse Egypteland, en lieten zich neder aan al de palen der Egyptenaren, zeer zwaar; voor dezen zijn dergelijke sprinkhanen, als deze, nooit geweest, en na dezen zullen er zulke niet wezen; ");
INSERT INTO nld_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Want zij bedekten het gezicht des gansen lands, alzo dat het land verduisterd werd; en zij aten al het kruid des lands op, en al de vruchten der bomen, die de hagel had over gelaten; en er bleef niets groens aan de bomen, noch aan de kruiden des velds, in het ganse Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Toen haastte Farao, om Mozes en Aaron te roepen, en zeide: Ik heb gezondigd tegen den HEERE, uw God, en tegen ulieden. ");
INSERT INTO nld_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","En nu vergeeft mij toch mijn zonde alleen ditmaal, en bidt vuriglijk tot den HEERE, uw God, dat Hij slechts dezen dood van mij wegneme. ");
INSERT INTO nld_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","En hij ging uit van Farao, en bad vuriglijk tot den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Toen keerde de HEERE een zeer sterken westenwind, die hief de sprinkhanen op, en wierp ze in de Schelfzee; er bleef niet een sprinkhaan over in al de landpalen van Egypte. ");
INSERT INTO nld_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Doch de HEERE verstokte Farao's hart, dat hij de kinderen Israels niet liet trekken. ");
INSERT INTO nld_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Toen zeide de HEERE tot Mozes: Strek uw hand uit naar den hemel, en er zal duisternis komen over Egypteland, dat men de duisternis tasten zal. ");
INSERT INTO nld_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Als Mozes zijn hand uitstrekte naar den hemel, werd er een dikke duisternis in het ganse Egypteland, drie dagen. ");
INSERT INTO nld_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Zij zagen de een den ander niet; er stond ook niemand op van zijn plaats, in drie dagen; maar bij al de kinderen Israels was het licht in hun woningen. ");
INSERT INTO nld_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Toen riep Farao Mozes, en zeide: Gaat heen, dient den HEERE! alleen uw schapen en uw runderen zullen vast blijven; ook zullen uw kinderkens met u gaan. ");
INSERT INTO nld_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Doch Mozes zeide: Ook zult gij slachtofferen en brandofferen in onze handen geven, die wij den HEERE, onzen God, doen mogen; ");
INSERT INTO nld_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","En ons vee zal ook met ons gaan, er zal niet een klauw achterblijven; want van hetzelve zullen wij nemen, om den HEERE, onzen God, te dienen; want wij weten niet, waarmede wij den HEERE, onzen God, dienen zullen, totdat wij daar komen. ");
INSERT INTO nld_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Doch de HEERE verhardde Farao's hart; en hij wilde hen niet laten trekken. ");
INSERT INTO nld_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Maar Farao zeide tot hem: Ga van mij! wacht u, dat gij niet meer mijn aangezicht ziet; want op welken dag gij mijn aangezicht zult zien, zult gij sterven! ");
INSERT INTO nld_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mozes nu zeide: Gij hebt recht gesproken; ik zal niet meer uw aangezicht zien! ");
INSERT INTO nld_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","(Want de HEERE had tot Mozes gesproken: Ik zal nog een plaag over Farao, en over Egypte brengen, daarna zal hij ulieden van hier laten trekken; als hij u geheellijk zal laten trekken, zo zal hij u haastelijk van hier uitdrijven. ");
INSERT INTO nld_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Spreek nu voor de oren des volks, dat ieder man van zijn naaste, en iedere vrouw van haar naaste zilveren vaten en gouden vaten eise. ");
INSERT INTO nld_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","En de HEERE gaf het volk genade in de ogen der Egyptenaren; ook was de man Mozes zeer groot in Egypteland voor de ogen van Farao's knechten, en voor de ogen des volks.) ");
INSERT INTO nld_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Verder zeide Mozes: Zo heeft de HEERE gezegd: Omtrent middernacht zal Ik uitgaan door het midden van Egypte; ");
INSERT INTO nld_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","En alle eerstgeborenen in Egypteland zullen sterven, van Farao's eerstgeborene af, die op zijn troon zitten zou, tot den eerstgeborene der dienstmaagd, die achter den molen is, en alle eerstgeborenen van het vee. ");
INSERT INTO nld_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","En er zal een groot geschrei zijn in het ganse Egypteland, desgelijke nooit geweest is, en desgelijke niet meer wezen zal. ");
INSERT INTO nld_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Maar bij alle kinderen Israels zal niet een hond zijn tong verroeren, van de mensen af tot de beesten toe; opdat gijlieden weet, dat de HEERE tussen de Egyptenaren en tussen de Israelieten een afzondering maakt. ");
INSERT INTO nld_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dan zullen al deze uw knechten tot mij afkomen, en zich voor mij neigen, zeggende: Trek uit, gij en al het volk, dat uw voetstappen volgt; en daarna zal ik uitgaan. En hij ging uit van Farao in hitte des toorns. ");
INSERT INTO nld_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","De HEERE dan had tot Mozes gesproken: Farao zal naar ulieden niet horen, opdat Mijn wonderen in Egypteland vermenigvuldigd worden. ");
INSERT INTO nld_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","En Mozes en Aaron hebben al deze wonderen gedaan voor Farao's aangezicht; doch de HEERE verhardde Farao's hart, dat hij de kinderen Israels uit zijn land niet trekken liet. ");
INSERT INTO nld_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","De HEERE nu had tot Mozes en tot Aaron in Egypteland gesproken, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Deze zelfde maand zal ulieden het hoofd der maanden zijn; zij zal u de eerste van de maanden des jaars zijn. ");
INSERT INTO nld_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Spreekt tot de ganse vergadering van Israel, zeggende: Aan den tienden dezer maand neme een iegelijk een lam, naar de huizen der vaderen, een lam voor een huis. ");
INSERT INTO nld_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Maar indien een huis te klein is voor een lam, zo neme hij het en zijn nabuur, de naaste aan zijn huis, naar het getal der zielen, een iegelijk naar dat hij eten kan; gij zult rekening maken naar het lam. ");
INSERT INTO nld_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Gij zult een volkomen lam hebben, een manneken, een jaar oud; van de schapen of van de geitenbokken zult gij het nemen. ");
INSERT INTO nld_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","En gij zult het in bewaring hebben tot den veertienden dag dezer maand; en de ganse gemeente der vergadering van Israel zal het slachten tussen twee avonden. ");
INSERT INTO nld_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","En zij zullen van het bloed nemen, en strijken het aan de beide zijposten, en aan den bovendorpel, aan de huizen, in welke zij het eten zullen. ");
INSERT INTO nld_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","En zij zullen het vlees eten in denzelfden nacht, aan het vuur gebraden, met ongezuurde broden; zij zullen het met bittere saus eten. ");
INSERT INTO nld_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Gij zult daarvan niet rauw eten, ook geenszins in water gezoden; maar aan het vuur gebraden, zijn hoofd met zijn schenkelen en met zijn ingewand. ");
INSERT INTO nld_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Gij zult daarvan ook niet laten overblijven tot den morgen; maar hetgeen daarvan overblijft tot den morgen, zult gij met vuur verbranden. ");
INSERT INTO nld_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Aldus nu zult gij het eten: uw lenden zullen opgeschort zijn, uw schoenen aan uw voeten, en uw staf in uw hand; en gij zult het met haast eten; het is des HEEREN pascha. ");
INSERT INTO nld_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Want Ik zal in dezen nacht door Egypteland gaan, en alle eerstgeborenen in Egypteland slaan, van de mensen af tot de beesten toe; en Ik zal gerichten oefenen aan al de goden der Egyptenaren, Ik, de HEERE! ");
INSERT INTO nld_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","En dat bloed zal ulieden tot een teken zijn aan de huizen, waarin gij zijt; wanneer Ik het bloed zie, zal Ik ulieden voorbijgaan; en er zal geen plaag onder ulieden ten verderve zijn, wanneer Ik Egypteland slaan zal. ");
INSERT INTO nld_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","En deze dag zal ulieden wezen ter gedachtenis, en gij zult hem den HEERE tot een feest vieren; gij zult hem vieren onder uw geslachten tot een eeuwige inzetting. ");
INSERT INTO nld_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Zeven dagen zult gijlieden ongezuurde broden eten; maar aan den eersten dag zult gij het zuurdeeg wegdoen uit uw huizen; want wie het gedesemde eet, van den eersten dag af tot op den zevenden dag, diezelve ziel zal uitgeroeid worden uit Israel. ");
INSERT INTO nld_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","En op den eersten dag zal er een heilige verzameling zijn; ook zult gij een heilige verzameling hebben op den zevenden dag; er zal geen werk op denzelven gedaan worden; maar wat van iedere ziel gegeten zal worden, datzelve alleen mag van ulieden toegemaakt worden. ");
INSERT INTO nld_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Zo onderhoudt dan de ongezuurde broden, dewijl Ik even aan denzelfden dag ulieder heiren uit Egypteland geleid zal hebben; daarom zult gij dezen dag houden, onder uw geslachten, tot een eeuwige inzetting. ");
INSERT INTO nld_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In de eerste maand, aan den veertienden dag der maand, in den avond, zult gij ongezuurde broden eten, tot den een en twintigsten dag der maand, in den avond. ");
INSERT INTO nld_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dat er zeven dagen lang geen zuurdesem in uw huizen gevonden worde, want al wie het gedesemde eten zal, dezelve ziel zal uit de vergadering van Israel uitgeroeid worden, hij zij een vreemdeling of een ingeborene des lands. ");
INSERT INTO nld_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Gij zult niets eten, dat gedesemd is; in al uw woningen zult gij ongezuurde broden eten. ");
INSERT INTO nld_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mozes dan riep al de oudsten van Israel, en zeide tot hen: Leest uit, en neemt u lammeren voor uw huisgezinnen, en slacht het pascha. ");
INSERT INTO nld_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Neemt dan een bundelken hysop, en doopt het in het bloed, dat in een bekken zal wezen; en strijkt aan den bovendorpel, en aan de beide zijposten van dat bloed, hetwelk in het bekken zijn zal; doch u aangaande, niemand zal uitgaan uit de deur van zijn huis, tot aan den morgen. ");
INSERT INTO nld_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Want de HEERE zal doorgaan, om de Egyptenaren te slaan; doch wanneer Hij het bloed zien zal aan den bovendorpel en aan de twee zijposten, zo zal de HEERE de deur voorbijgaan, en den verderver niet toelaten in uw huizen te komen om te slaan. ");
INSERT INTO nld_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Onderhoudt dan deze zaak, tot een inzetting voor u en voor uw kinderen, tot in eeuwigheid. ");
INSERT INTO nld_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","En het zal geschieden, als gij in dat land komt, dat u de HEERE geven zal, gelijk Hij gesproken heeft, zo zult gij dezen dienst onderhouden. ");
INSERT INTO nld_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","En het zal geschieden, wanneer uw kinderen tot u zullen zeggen: Wat hebt gij daar voor een dienst? ");
INSERT INTO nld_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Zo zult gij zeggen: Dit is den HEERE een paasoffer, Die voor de huizen der kinderen Israels voorbijging in Egypte, toen Hij de Egyptenaars sloeg, en onze huizen bevrijdde! Toen boog zich het volk en neigde zich. ");
INSERT INTO nld_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","En de kinderen Israels gingen en deden het, gelijk als de HEERE Mozes en Aaron geboden had, alzo deden zij. ");
INSERT INTO nld_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","En het geschiedde ter middernacht, dat de HEERE al de eerstgeborenen in Egypteland sloeg, van den eerstgeborene van Farao af, die op zijn troon zitten zou, tot op den eerstgeborene van den gevangene, die in het gevangenhuis was, en alle eerstgeborenen der beesten. ");
INSERT INTO nld_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","En Farao stond op bij nacht, hij en al zijn knechten, en al de Egyptenaars; en er was een groot geschrei in Egypte; want er was geen huis, waarin niet een dode was. ");
INSERT INTO nld_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Toen riep hij Mozes en Aaron in den nacht, en zeide: Maakt u op, trekt uit het midden van mijn volk, zo gijlieden als de kinderen van Israel; en gaat heen, dient den HEERE, gelijk gijlieden gesproken hebt. ");
INSERT INTO nld_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Neemt ook met u uw schapen en uw runderen, zoals gijlieden gesproken hebt, en gaat heen, en zegent mij ook. ");
INSERT INTO nld_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","En de Egyptenaars hielden sterk aan bij het volk, haastende, om die uit het land te drijven; want zij zeiden: Wij zijn allen dood! ");
INSERT INTO nld_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","En het volk nam zijn deeg op, eer het gedesemd was, hun deegklompen, gebonden in hun klederen, op hun schouderen. ");
INSERT INTO nld_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","De kinderen Israels nu hadden gedaan naar het woord van Mozes, en hadden van de Egyptenaren geeist zilveren vaten, en gouden vaten, en klederen. ");
INSERT INTO nld_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Daartoe had de HEERE het volk genade gegeven in de ogen der Egyptenaren, dat zij hun hun begeerte deden; en zij beroofden de Egyptenaren. ");
INSERT INTO nld_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Alzo reisden de kinderen Israels uit van Rameses naar Sukkoth, omtrent zeshonderd duizend te voet, mannen alleen, behalve de kinderkens. ");
INSERT INTO nld_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","En veel vermengd volk trok ook met hen op, en schapen, en runderen, gans veel vee. ");
INSERT INTO nld_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","En zij bakten van het deeg, dat zij uit Egypte gebracht hadden, ongezuurde koeken; want het was niet gedesemd; overmits zij uit Egypte uitgedreven werden, zodat zij niet vertoeven konden, noch ook tering voor zich bereiden. ");
INSERT INTO nld_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","De tijd nu der woning, dien de kinderen Israels in Egypte gewoond hebben, is vierhonderd jaren en dertig jaren. ");
INSERT INTO nld_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","En het geschiedde ten einde van de vierhonderd en dertig jaren, zo is het even op denzelfden dag geschied, dat al de heiren des HEEREN uit Egypteland gegaan zijn. ");
INSERT INTO nld_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Dezen nacht zal men den HEERE op het vlijtigst houden, omdat Hij hen uit Egypteland geleid heeft; deze is de nacht des HEEREN, die op het vlijtigst moet gehouden worden, van al de kinderen Israels, onder hun geslachten. ");
INSERT INTO nld_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Voorts zeide de HEERE tot Mozes en Aaron: Dit is de inzetting van het pascha: geen zoon eens vreemdelings zal daarvan eten. ");
INSERT INTO nld_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Doch alle knecht van iedereen, die voor geld gekocht is, nadat gij hem zult besneden hebben, dan zal hij daarvan eten. ");
INSERT INTO nld_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Geen uitlander noch huurling zal er van eten. ");
INSERT INTO nld_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In een huis zal het gegeten worden; gij zult van het vlees niet buiten uit het huis dragen, en gij zult geen been daaraan breken. ");
INSERT INTO nld_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","De ganse vergadering van Israel zal het doen. ");
INSERT INTO nld_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Als nu een vreemdeling bij u verkeert, en den HEERE het pascha houden zal, dat alles, wat mannelijk is, bij hem besneden worde, en dan kome hij daartoe, om dat te houden, en hij zal wezen als een ingeborene des lands; maar geen onbesnedene zal daarvan eten. ");
INSERT INTO nld_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Enerlei wet zij voor den ingeborene, en den vreemdeling, die als vreemdeling in het midden van u verkeert. ");
INSERT INTO nld_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","En alle kinderen Israels deden het; gelijk als de HEERE Mozes en Aaron geboden had, alzo deden zij. ");
INSERT INTO nld_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","En het geschiedde even tenzelfden dage, dat de HEERE de kinderen Israels uit Egypteland leidde, naar hun heiren. ");
INSERT INTO nld_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Heilig Mij alle eerstgeborenen; wat enige baarmoeder opent onder de kinderen Israels, van mensen en van beesten, dat is Mijn. ");
INSERT INTO nld_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Verder zeide Mozes tot het volk: Gedenkt aan dezen zelfden dag, op welken gijlieden uit Egypte, uit het diensthuis, gegaan zijt; want de HEERE heeft u door een sterke hand van hier uitgevoerd; daarom zal het gedesemde niet gegeten worden. ");
INSERT INTO nld_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heden gaat gijlieden uit, in de maand Abib. ");
INSERT INTO nld_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","En het zal geschieden, als u de HEERE zal gebracht hebben in het land der Kanaanieten, en der Hethieten, en der Amorieten, en der Hevieten, en der Jebusieten, hetwelk Hij uw vaderen gezworen heeft u te geven, een land vloeiende van melk en honig; zo zult gij dezen dienst houden in deze maand. ");
INSERT INTO nld_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Zeven dagen zult gij ongezuurde broden eten, en aan den zevenden dag zal den HEERE een feest zijn. ");
INSERT INTO nld_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Zeven dagen zullen ongezuurde broden gegeten worden, en het gedesemde zal bij u niet gezien worden, ja, er zal geen zuurdeeg bij u gezien worden, in al uw palen. ");
INSERT INTO nld_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","En gij zult uw zoon te kennen geven te dienzelven dage, zeggende: Dit is om hetgeen de HEERE mij gedaan heeft, toen ik uit Egypte uittoog. ");
INSERT INTO nld_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","En het zal u zijn tot een teken op uw hand, en tot een gedachtenis tussen uw ogen, opdat de wet des HEEREN in uw mond zij, omdat u de HEERE door een sterke hand uit Egypte uitgevoerd heeft. ");
INSERT INTO nld_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Daarom onderhoudt deze inzetting ter bestemder tijd, van jaar tot jaar. ");
INSERT INTO nld_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Het zal ook geschieden, wanneer u de HEERE in het land der Kanaanieten zal gebracht hebben, gelijk Hij u en uw vaderen gezworen heeft, en Hij het u zal gegeven hebben; ");
INSERT INTO nld_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Zo zult gij tot den HEERE doen overgaan alles, wat de baarmoeder opent; ook alles, wat de baarmoeder opent van de vrucht der beesten, die gij hebben zult; de mannetjes zullen des HEEREN zijn. ");
INSERT INTO nld_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Doch al wat de baarmoeder der ezelin opent, zult gij lossen met een lam; wanneer gij het nu niet lost, zo zult gij het den nek breken; maar alle eerstgeborenen des mensen onder uw zonen zult gij lossen. ");
INSERT INTO nld_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Wanneer het geschieden zal, dat uw zoon u morgen zal vragen, zeggende: Wat is dat, zo zult gij tot hem zeggen: De HEERE heeft ons door een sterke hand uit Egypte, uit het diensthuis, uitgevoerd. ");
INSERT INTO nld_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Want het geschiedde, toen Farao zich verhardde ons te laten trekken, zo doodde de HEERE alle eerstgeborenen in Egypteland, van des mensen eerstgeborene af, tot den eerstgeborene der beesten; daarom offer ik den HEERE de mannetjes van alles, wat de baarmoeder opent; doch alle eerstgeborenen mijner zonen los ik. ");
INSERT INTO nld_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","En het zal tot een teken zijn op uw hand, en tot voorhoofdspanselen tussen uw ogen; want de HEERE heeft door een sterke hand ons uit Egypte uitgevoerd. ");
INSERT INTO nld_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","En het is geschied, toen Farao het volk had laten trekken, zo leidde hen God niet op den weg van het land der Filistijnen, hoewel die nader was; want God zeide: Dat het den volke niet rouwe, als zij den strijd zien zouden, en wederkeren naar Egypte. ");
INSERT INTO nld_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Maar God leidde het volk om, langs den weg van de woestijn der Schelfzee. De kinderen Israels nu togen bij vijven uit Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","En Mozes nam de beenderen van Jozef met zich; want hij had met een zwaren eed de kinderen Israels bezworen, zeggende: God zal ulieden voorzeker bezoeken; voert dan mijn beenderen met ulieden op van hier! ");
INSERT INTO nld_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Alzo reisden zij uit Sukkoth; en zij legerden zich in Etham, aan het einde der woestijn. ");
INSERT INTO nld_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","En de HEERE toog voor hun aangezicht, des daags in een wolkkolom, dat Hij hen op den weg leidde, en des nachts in een vuurkolom, dat Hij hen lichtte, om voort te gaan dag en nacht. ");
INSERT INTO nld_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Hij nam de wolkkolom des daags, noch de vuurkolom des nachts niet weg van het aangezicht des volks. ");
INSERT INTO nld_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Spreek tot de kinderen Israels, dat zij wederkeren, en zich legeren voor Pi-Hachiroth, tussen Migdol en tussen de zee, voor Baal-Zefon; daar tegenover zult gij u legeren aan de zee. ");
INSERT INTO nld_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao dan zal zeggen van de kinderen Israels: Zij zijn verward in het land; die woestijn heeft hen besloten. ");
INSERT INTO nld_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","En Ik zal Farao's hart verstokken, dat hij hen najage; en Ik zal aan Farao en aan al zijn heir verheerlijkt worden, alzo dat de Egyptenaars zullen weten, dat Ik de HEERE ben. En zij deden alzo. ");
INSERT INTO nld_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Toen nu den koning van Egypte werd geboodschapt, dat het volk vluchtte, zo is het hart van Farao en van zijn knechten veranderd tegen het volk, en zij zeiden: Waarom hebben wij dat gedaan, dat wij Israel hebben laten trekken, dat zij ons niet dienden? ");
INSERT INTO nld_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","En hij spande zijn wagen aan, en nam zijn volk met zich. ");
INSERT INTO nld_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","En hij nam zeshonderd uitgelezene wagens, ja, al de wagens van Egypte, en de hoofdlieden over die allen. ");
INSERT INTO nld_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Want de HEERE verstokte het hart van Farao, den koning van Egypte, dat hij de kinderen Israels najaagde; doch de kinderen Israels waren door een hoge hand uitgegaan. ");
INSERT INTO nld_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","En de Egyptenaars jaagden hen na, en achterhaalden hen, daar zij zich gelegerd hadden aan de zee; al de paarden, de wagens van Farao en zijn ruiters, en zijn heir; nevens Pi-Hachiroth, voor Baal-Zefon. ");
INSERT INTO nld_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Als Farao nabij gekomen was, zo hieven de kinderen Israels hun ogen op, en ziet, de Egyptenaars togen achter hen; en zij vreesden zeer; toen riepen de kinderen Israels tot den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","En zij zeiden tot Mozes: Hebt gij ons daarom, omdat er in Egypte gans geen graven waren, weggenomen, opdat wij in deze woestijn sterven zouden? Waarom hebt gij ons dat gedaan, dat gij ons uit Egypte uitgevoerd hebt? ");
INSERT INTO nld_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Is dit niet het woord, dat wij in Egypte tot u spraken, zeggende: Houd af van ons, en laat ons de Egyptenaren dienen? Want het ware ons beter geweest de Egyptenaren te dienen, dan in deze woestijn te sterven. ");
INSERT INTO nld_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Doch Mozes zeide tot het volk: Vreest niet, staat vast, en ziet het heil des HEEREN, dat Hij heden aan ulieden doen zal, want de Egyptenaars, die gij heden gezien hebt, zult gij niet weder zien in eeuwigheid. ");
INSERT INTO nld_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","De HEERE zal voor ulieden strijden, en gij zult stil zijn. ");
INSERT INTO nld_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Toen zeide de HEERE tot Mozes: Wat roept gij tot Mij? Zeg den kinderen Israels, dat zij voorttrekken. ");
INSERT INTO nld_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","En gij, hef uw staf op, en strek uw hand uit over de zee, en klief dezelve, dat de kinderen Israels door het midden der zee gaan op het droge. ");
INSERT INTO nld_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","En Ik, zie, Ik zal het hart der Egyptenaren verstokken, dat zij na hen daarin gaan; en Ik zal verheerlijkt worden aan Farao en aan al zijn heir, aan zijn wagenen en aan zijn ruiteren. ");
INSERT INTO nld_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","En de Egyptenaars zullen weten, dat Ik de HEERE ben, wanneer Ik verheerlijkt zal worden aan Farao, aan zijn wagenen en aan zijn ruiteren. ");
INSERT INTO nld_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","En de Engel Gods, Die voor het heir van Israel ging, vertrok, en ging achter hen; de wolkkolom vertrok ook van hun aangezicht, en stond achter hen. ");
INSERT INTO nld_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","En zij kwam tussen het leger der Egyptenaren, en tussen het leger van Israel; en de wolk was te gelijk duisternis en verlichtte den nacht; zodat de een tot den ander niet naderde den gansen nacht. ");
INSERT INTO nld_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Toen Mozes zijn hand uitstrekte over de zee, zo deed de HEERE de zee weggaan, door een sterken oostenwind, dien gansen nacht, en maakte de zee droog, en de wateren werden gekliefd. ");
INSERT INTO nld_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","En de kinderen Israels zijn ingegaan in het midden van de zee, op het droge; en de wateren waren hun een muur, aan hun rechter hand en aan hun linkerhand. ");
INSERT INTO nld_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","En de Egyptenaars vervolgden hen, en gingen in, achter hen, al de paarden van Farao, zijn wagenen en zijn ruiteren, in het midden van de zee. ");
INSERT INTO nld_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","En het geschiedde in dezelfde morgenwake, dat de HEERE, in de kolom des vuurs en der wolk, zag op het leger der Egyptenaren; en Hij verschrikte het leger der Egyptenaren. ");
INSERT INTO nld_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","En Hij stiet de raderen hunner wagenen weg, en deed ze zwaarlijk voortvaren. Toen zeiden de Egyptenaars: Laat ons vlieden van het aangezicht van Israel, want de HEERE strijdt voor hen tegen de Egyptenaars. ");
INSERT INTO nld_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","En de HEERE zeide tot Mozes: Strek uw hand uit over de zee, dat de wateren wederkeren over de Egyptenaars, over hun wagenen en over hun ruiters. ");
INSERT INTO nld_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Toen strekte Mozes zijn hand uit over de zee; en de zee kwam weder, tegen het naken van den morgenstond, tot haar kracht; en de Egyptenaars vluchtten die tegemoet; en de HEERE stortte de Egyptenaars in het midden der zee. ");
INSERT INTO nld_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Want als de wateren wederkeerden, zo bedekten zij de wagenen en de ruiters van het ganse heir van Farao, dat hen nagevolgd was in de zee; er bleef niet een van hen over. ");
INSERT INTO nld_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Maar de kinderen Israels gingen op het droge, in het midden der zee; en de wateren waren hun een muur, aan hun rechter hand en aan hun linkerhand. ");
INSERT INTO nld_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Alzo verloste de HEERE Israel aan dien dag uit de hand der Egyptenaren; en Israel zag de Egyptenaren dood aan den oever der zee. ");
INSERT INTO nld_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ook zag Israel de grote hand, die de HEERE aan de Egyptenaren bewezen had; en het volk vreesde den HEERE, en geloofde in den HEERE, en aan Mozes, Zijn knecht. ");
INSERT INTO nld_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Toen zong Mozes en de kinderen Israels den HEERE dit lied, en spraken, zeggende: Ik zal den HEERE zingen; want Hij is hogelijk verheven! Het paard en zijn ruiter heeft Hij in de zee geworpen. ");
INSERT INTO nld_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","De HEERE is mijn Kracht en Lied, en Hij is mij tot een Heil geweest; deze is mijn God; daarom zal ik Hem een liefelijke woning maken; Hij is mijns vaders God, dies zal ik Hem verheffen! ");
INSERT INTO nld_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","De HEERE is een krijgsman; HEERE is Zijn Naam! ");
INSERT INTO nld_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Hij heeft Farao's wagenen en zijn heir in de zee geworpen; en de keure zijner hoofdlieden zijn verdronken in de Schelfzee. ");
INSERT INTO nld_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","De afgronden hebben hen bedekt; zij zijn in de diepten gezonken als een steen. ");
INSERT INTO nld_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O HEERE! Uw rechterhand is verheerlijkt geworden in macht; Uw rechterhand, o HEERE! heeft den vijand verbroken! ");
INSERT INTO nld_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","En door Uw grote hoogheid hebt Gij, die tegen U opstonden, omgeworpen; Gij hebt Uw brandenden toorn uitgezonden, die hen verteerd heeft als een stoppel. ");
INSERT INTO nld_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","En door het geblaas van Uw neus zijn de wateren opgehoopt geworden; de stromen hebben overeind gestaan, als een hoop; de afgronden zijn stijf geworden in het hart der zee. ");
INSERT INTO nld_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","De vijand zeide: Ik zal vervolgen, ik zal achterhalen, ik zal den buit delen, mijn ziel zal van hen vervuld worden, ik zal mijn zwaard uittrekken, mijn hand zal hen uitroeien. ");
INSERT INTO nld_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Gij hebt met Uw wind geblazen; de zee heeft hen gedekt, zij zonken onder als lood in geweldige wateren! ");
INSERT INTO nld_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O HEERE! wie is als Gij onder de goden? wie is als Gij, verheerlijkt in heiligheid, vreselijk in lofzangen, doende wonder? ");
INSERT INTO nld_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Gij hebt Uw rechterhand uitgestrekt, de aarde heeft hen verslonden! ");
INSERT INTO nld_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Gij leiddet door Uw weldadigheid dit volk, dat Gij verlost hebt; Gij voert hen zachtkens door Uw sterkte tot de liefelijke woning Uwer heiligheid. ");
INSERT INTO nld_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","De volken hebben het gehoord, zij zullen sidderen; weedom heeft de ingezetenen van Palestina bevangen. ");
INSERT INTO nld_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Dan zullen de vorsten van Edom verbaasd wezen; beving zal de machtigen der Moabieten bevangen; al de ingezetenen van Kanaan zullen versmelten! ");
INSERT INTO nld_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Verschrikking en vrees zal op hen vallen; door de grootheid van Uw arm zullen zij verstommen, als een steen, totdat Uw volk, HEERE! henen doorkome; totdat dit volk henen doorkome, dat Gij verworven hebt. ");
INSERT INTO nld_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Die zult Gij inbrengen, en planten hen op den berg Uwer erfenis, ter plaatse, welke Gij, o HEERE! gemaakt hebt tot Uw woning, het heiligdom, hetwelk Uw handen gesticht hebben, o HEERE! ");
INSERT INTO nld_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","De HEERE zal in eeuwigheid en geduriglijk regeren! ");
INSERT INTO nld_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Want Farao's paard, met zijn wagen, met zijn ruiters, zijn in de zee gekomen, en de HEERE heeft de wateren der zee over hen doen wederkeren; maar de kinderen Israels zijn op het droge in het midden van de zee gegaan. ");
INSERT INTO nld_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","En Mirjam, de profetes, Aarons zuster, nam een trommel in haar hand; en al de vrouwen gingen uit, haar na, met trommelen en met reien. ");
INSERT INTO nld_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Toen antwoordde Mirjam hunlieden: Zingt den HEERE; want Hij is hogelijk verheven! Hij heeft het paard met zijn ruiter in de zee gestort! ");
INSERT INTO nld_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hierna deed Mozes de Israelieten voortreizen van de Schelfzee af; en zij trokken uit tot in de woestijn Sur, en zij gingen drie dagen in de woestijn, en vonden geen water. ");
INSERT INTO nld_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Toen kwamen zij te Mara; doch zij konden het water van Mara niet drinken, want het was bitter; daarom werd derzelver naam genoemd Mara. ");
INSERT INTO nld_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Toen murmureerde het volk tegen Mozes, zeggende: Wat zullen wij drinken? ");
INSERT INTO nld_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Hij dan riep tot den HEERE; en de HEERE wees hem een hout, dat wierp hij in dat water; toen werd het water zoet. Aldaar stelde Hij het volk een inzetting en recht, en aldaar verzocht Hij hetzelve, ");
INSERT INTO nld_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","En zeide: Is het, dat gij met ernst naar de stem des HEEREN uws Gods horen zult, en doen, wat recht is in Zijn ogen, en uw oren neigt tot Zijn geboden, en houdt al Zijn inzettingen; zo zal Ik geen van de krankheden op u leggen, die Ik op Egypteland gelegd heb; want Ik ben de HEERE, uw Heelmeester! ");
INSERT INTO nld_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Toen kwamen zij te Elim, en daar waren twaalf waterfonteinen, en zeventig palmbomen; en zij legerden zich aldaar aan de wateren. ");
INSERT INTO nld_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toen zij van Elim gereisd waren, zo kwam de ganse vergadering der kinderen Israels in de woestijn Sin, welke is tussen Elim en tussen Sinai, aan den vijftienden dag der tweede maand, nadat zij uit Egypteland uitgegaan waren. ");
INSERT INTO nld_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","En de ganse vergadering der kinderen Israels murmureerde tegen Mozes en tegen Aaron, in de woestijn. ");
INSERT INTO nld_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","En de kinderen Israels zeiden tot hen: Och, dat wij in Egypteland gestorven waren door de hand des HEEREN, toen wij bij de vleespotten zaten, toen wij tot verzadiging brood aten! Want gijlieden hebt ons uitgeleid in deze woestijn, om deze ganse gemeente door den honger te doden. ");
INSERT INTO nld_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Toen zeide de HEERE tot Mozes: Zie, Ik zal voor ulieden brood uit den hemel regenen; en het volk zal uitgaan, en verzamelen elke dagmaat op haar dag; opdat Ik het verzoeke, of het in Mijn wet ga, of niet. ");
INSERT INTO nld_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","En het zal geschieden op den zesden dag, dat zij bereiden zullen hetgeen zij ingebracht zullen hebben; dat zal dubbel zijn boven hetgeen zij dagelijks zullen verzamelen. ");
INSERT INTO nld_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Toen zeiden Mozes en Aaron tot al de kinderen Israels: Aan den avond, dan zult gij weten, dat u de HEERE uit Egypteland uitgeleid heeft; ");
INSERT INTO nld_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","En morgen, dan zult gij des HEEREN heerlijkheid zien, dewijl Hij uw murmureringen tegen den HEERE gehoord heeft; want wat zijn wij, dat gij tegen ons murmureert? ");
INSERT INTO nld_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Voorts zeide Mozes: Als de HEERE ulieden aan den avond vlees te eten zal geven, en aan den morgen brood tot verzadiging, het zal zijn, omdat de HEERE uw murmureringen gehoord heeft, die gij tegen Hem murmureert; want wat zijn wij? Uw murmureringen zijn niet tegen ons, maar tegen den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Daarna zeide Mozes tot Aaron: Zeg tot de ganse vergadering der kinderen Israels: Nadert voor het aangezicht des HEEREN, want Hij heeft uw murmureringen gehoord. ");
INSERT INTO nld_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","En het geschiedde, als Aaron tot de ganse vergadering der kinderen Israels sprak, en zij zich naar de woestijn keerden, zo ziet, de heerlijkheid des HEEREN verscheen in de wolk. ");
INSERT INTO nld_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ook heeft de HEERE tot Mozes gesproken, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ik heb de murmureringen van de kinderen Israels gehoord; spreek tot hen, zeggende: Tussen de twee avonden zult gij vlees eten, en aan den morgen zult gij met brood verzadigd worden; en gij zult weten, dat Ik de HEERE uw God ben. ");
INSERT INTO nld_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","En het geschiedde aan den avond, dat er kwakkelen opkwamen, en het leger bedekten; en aan den morgen lag de dauw rondom het leger. ");
INSERT INTO nld_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Als nu de liggende dauw opgevaren was, zo ziet, over de woestijn was een klein rond ding, klein als de rijm, op de aarde. ");
INSERT INTO nld_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Toen het de kinderen Israels zagen, zo zeiden zij, de een tot den ander: Het is Man, want zij wisten niet wat het was. Mozes dan zeide tot hen: Dit is het brood, hetwelk de HEERE ulieden te eten gegeven heeft. ");
INSERT INTO nld_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Dit is het woord, dat de HEERE geboden heeft: Verzamelt daarvan een ieder naar dat hij eten mag, een gomer voor een hoofd, naar het getal van uw zielen; ieder zal nemen voor degenen, die in zijn tent zijn. ");
INSERT INTO nld_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","En de kinderen Israels deden alzo, en verzamelden, de een veel en de ander weinig. ");
INSERT INTO nld_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Doch als zij het met den gomer maten, zo had hij, die veel verzameld had, niets over, en dien, die weinig verzameld had, ontbrak niet; een iegelijk verzamelde zoveel, als hij eten mocht. ");
INSERT INTO nld_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","En Mozes zeide tot hen: Niemand late daarvan over tot den morgen. ");
INSERT INTO nld_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Doch zij hoorden niet naar Mozes, maar sommige mannen lieten daarvan over tot den morgen. Toen wiesen er wormen in, en het werd stinkende; dies werd Mozes zeer toornig op hen. ");
INSERT INTO nld_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Zij nu verzamelden het allen morgen, een iegelijk naardat hij eten mocht; want als de zon heet werd, zo versmolt het. ");
INSERT INTO nld_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","En het geschiedde op den zesden dag, dat zij dubbel brood verzamelden, twee gomers voor een; en al de oversten der vergadering kwamen en verkondigden het aan Mozes. ");
INSERT INTO nld_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Hij dan zeide tot hen: Dit is het, dat de HEERE gesproken heeft: Morgen is de rust, de heilige sabbat des HEEREN! wat gij bakken zoudt, bakt dat, en ziedt, wat gij zieden zoudt; en al wat over blijft, legt het op voor u in bewaring tot den morgen. ");
INSERT INTO nld_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","En zij leiden het op tot den morgen, gelijk als Mozes geboden had; en het stonk niet, en er was geen worm in. ");
INSERT INTO nld_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Toen zeide Mozes: Eet dat heden, want het is heden de sabbat des HEEREN; gij zult het heden op het veld niet vinden. ");
INSERT INTO nld_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Zes dagen zult gij het verzamelen; doch op den zevenden dag is het sabbat, op denzelven zal het niet zijn. ");
INSERT INTO nld_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","En het geschiedde aan den zevenden dag, dat sommigen van het volk uitgingen, om te verzamelen; doch zij vonden niet. ");
INSERT INTO nld_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Toen zeide de HEERE tot Mozes: Hoe lang weigert gijlieden te houden Mijn geboden en Mijn wetten? ");
INSERT INTO nld_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ziet, omdat de HEERE ulieden den sabbat gegeven heeft, daarom geeft Hij u aan den zesden dag voor twee dagen brood; een ieder blijve in zijn plaats! dat niemand uit zijn plaats ga op den zevenden dag! ");
INSERT INTO nld_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Alzo rustte het volk op den zevenden dag. ");
INSERT INTO nld_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","En het huis Israels noemde deszelfs naam Man; en het was als korianderzaad, wit, en de smaak daarvan was als honigkoeken. ");
INSERT INTO nld_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Voorts zeide Mozes: Dit is het woord, hetwelk de HEERE bevolen heeft: Vul een gomer daarvan tot bewaring voor uw geslachten, opdat zij zien het brood, dat Ik ulieden heb te eten gegeven in deze woestijn, toen Ik u uit Egypteland uitleidde. ");
INSERT INTO nld_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ook zeide Mozes tot Aaron: Neem een kruik, en doe een gomer vol Man daarin; en zet die voor het aangezicht des HEEREN, tot bewaring voor uw geslachten. ");
INSERT INTO nld_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Gelijk als de HEERE aan Mozes geboden had, alzo zette ze Aaron voor de getuigenis tot bewaring. ");
INSERT INTO nld_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","En de kinderen Israels aten Man veertig jaren, totdat zij in een bewoond land kwamen; zij aten Man, totdat zij kwamen aan de pale van het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Een gomer nu is het tiende deel van een efa. ");
INSERT INTO nld_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Daarna toog de ganse vergadering van de kinderen Israels, naar hun dagreizen, uit de woestijn Sin, op het bevel des HEEREN, en zij legerden zich te Rafidim. Daar nu was geen water voor het volk om te drinken. ");
INSERT INTO nld_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Toen twistte het volk met Mozes, en zeide: Geeft gijlieden ons water, dat wij drinken! Mozes dan zeide tot hen: Wat twist gij met mij? Waarom verzoekt gij den HEERE? ");
INSERT INTO nld_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Toen nu het volk aldaar dorstte naar water, zo murmureerde het volk tegen Mozes, en het zeide: Waartoe hebt gij ons nu uit Egypte doen optrekken, opdat gij mij, en mijn kinderen, en mijn vee, van dorst deedt sterven? ");
INSERT INTO nld_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Zo riep Mozes tot den HEERE, zeggende: Wat zal ik dit volk doen? Er feilt niet veel aan, of zij zullen mij stenigen. ");
INSERT INTO nld_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Toen zeide de HEERE tot Mozes: Ga heen voor het aangezicht des volks, en neem met u uit de oudsten van Israel; en neem uw staf in uw hand, waarmede gij de rivier sloegt, en ga heen. ");
INSERT INTO nld_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Zie, Ik zal aldaar voor uw aangezicht op de rotssteen in Horeb staan; en gij zult op den rotssteen slaan, zo zal er water uitgaan, dat het volk drinke. Mozes nu deed alzo voor de ogen der oudsten van Israel. ");
INSERT INTO nld_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","En hij noemde den naam dier plaats Massa en Meriba, om den twist der kinderen Israels, en omdat zij den HEERE verzocht hadden, zeggende: Is de HEERE in het midden van ons, of niet? ");
INSERT INTO nld_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Toen kwam Amalek en streed tegen Israel in Rafidim. ");
INSERT INTO nld_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mozes dan zeide tot Jozua: Kies ons mannen, en trek uit, strijd tegen Amalek; morgen zal ik op de hoogte des heuvels staan, en de staf Gods zal in mijn hand zijn. ");
INSERT INTO nld_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozua nu deed, als Mozes hem gezegd had, strijdende tegen Amalek; doch Mozes, Aaron en Hur klommen op de hoogte des heuvels. ");
INSERT INTO nld_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","En het geschiedde, terwijl Mozes zijn hand ophief, zo was Israel de sterkste; maar terwijl hij zijn hand nederliet, zo was Amalek de sterkste. ");
INSERT INTO nld_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Doch de handen van Mozes werden zwaar; daarom namen zij een steen, en legden dien onder hem, dat hij daarop zat; en Aaron en Hur onderstutten zijn handen, de een op deze, de ander op de andere zijde; alzo waren zijn handen gewis, totdat de zon onderging. ");
INSERT INTO nld_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Alzo dat Jozua Amalek en zijn volk krenkte, door de scherpte des zwaards. ");
INSERT INTO nld_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Toen zeide de HEERE tot Mozes: Schrijf dit ter gedachtenis in een boek, en leg het in de oren van Jozua, dat Ik de gedachtenis van Amalek geheel uitdelgen zal van onder den hemel. ");
INSERT INTO nld_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","En Mozes bouwde een altaar; en hij noemde deszelfs naam: De HEERE is mijn Banier! ");
INSERT INTO nld_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","En hij zeide: Dewijl de hand op den troon des HEEREN is, zo zal de oorlog des HEEREN tegen Amalek zijn, van geslacht tot geslacht! ");
INSERT INTO nld_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Toen Jethro, priester van Midian, schoonvader van Mozes, hoorde al wat God aan Mozes, en aan Israel, Zijn volk, gedaan had: dat de HEERE Israel uit Egypte uitgevoerd had; ");
INSERT INTO nld_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Zo nam Jethro, Mozes' schoonvader, Zippora, Mozes' huisvrouw (nadat hij haar wedergezonden had), ");
INSERT INTO nld_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Met haar twee zonen, welker enes naam was Gersom (want hij zeide: Ik ben een vreemdeling geweest in een vreemd land); ");
INSERT INTO nld_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","En de naam des anderen was Eliezer, want, zeide hij, de God mijns vaders is tot mijn Hulpe geweest, en heeft mij verlost van Farao's zwaard. ");
INSERT INTO nld_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Toen nu Jethro, Mozes' schoonvader, met zijn zonen en zijn huisvrouw, tot Mozes kwam, in de woestijn, aan den berg Gods, waar hij zich gelegerd had, ");
INSERT INTO nld_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Zo zeide hij tot Mozes: Ik, uw schoonvader Jethro, kom tot u, met uw huisvrouw, en haar beide zonen met haar. ");
INSERT INTO nld_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Toen ging Mozes uit, zijn schoonvader tegemoet, en hij boog zich, en kuste hem; en zij vraagden de een den ander naar den welstand, en zij gingen naar de tent. ");
INSERT INTO nld_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","En Mozes vertelde zijn schoonvader alles, wat de HEERE aan Farao en aan de Egyptenaren gedaan had, om Israels wil; al de moeite, die hun op dien weg ontmoet was, en dat hen de HEERE verlost had. ");
INSERT INTO nld_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro nu verheugde zich over al het goede, hetwelk de HEERE Israel gedaan had; dat Hij het verlost had uit de hand der Egyptenaren. ");
INSERT INTO nld_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","En Jethro zeide: Gezegend zij de HEERE, Die ulieden verlost heeft uit de hand der Egyptenaren, en uit Farao's hand; Die dit volk van onder de hand der Egyptenaren verlost heeft! ");
INSERT INTO nld_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu weet ik, dat de HEERE groter is dan alle goden; want in de zaak, waarin zij trotselijk gehandeld hebben, was Hij boven hen. ");
INSERT INTO nld_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Toen nam Jethro, de schoonvader van Mozes, Gode brandoffer en slachtofferen; en Aaron kwam, en al de oversten van Israel, om brood te eten met den schoonvader van Mozes, voor het aangezicht Gods. ");
INSERT INTO nld_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Doch het geschiedde des anderen daags, zo zat Mozes om het volk te richten, en het volk stond voor Mozes, van den morgen tot den avond. ");
INSERT INTO nld_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Als de schoonvader van Mozes alles zag, wat hij het volk deed, zo zeide hij: Wat ding is dit, dat gij het volk doet? Waarom zit gij zelf alleen, en al het volk staat voor u, van den morgen tot den avond? ");
INSERT INTO nld_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Toen zeide Mozes tot zijn schoonvader: Omdat dit volk tot mij komt, om God raad te vragen. ");
INSERT INTO nld_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wanneer zij een zaak hebben, zo komt het tot mij, dat ik richte tussen den man en tussen zijn naaste; en dat ik hun bekend make Gods instellingen en Zijn wetten. ");
INSERT INTO nld_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Doch de schoonvader van Mozes zeide tot hem: De zaak is niet goed, die gij doet. ");
INSERT INTO nld_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Gij zult geheel vervallen, zo gij, als dit volk, hetwelk bij u is; want deze zaak is te zwaar voor u, gij alleen kunt het niet doen. ");
INSERT INTO nld_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Hoor nu mijn stem, ik zal u raden, en God zal met u zijn; wees gij voor het volk bij God, en breng gij de zaken voor God; ");
INSERT INTO nld_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","En verklaar hun de instellingen en de wetten, en maak hun bekend den weg, waarin zij wandelen zullen, en het werk, dat zij doen zullen. ");
INSERT INTO nld_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Doch zie gij om, onder al het volk, naar kloeke mannen, God vrezende, waarachtige mannen, de gierigheid hatende; stel ze over hen, oversten der duizenden, oversten der honderden, oversten der vijftigen, oversten der tienen. ");
INSERT INTO nld_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Dat zij dit volk te allen tijde richten; doch het geschiede, dat zij alle grote zaken aan u brengen, maar dat zij alle kleine zaken richten; verlicht alzo uzelven, en laat hen met u dragen. ");
INSERT INTO nld_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Indien gij deze zaak doet, en God het u gebiedt, zo zult gij kunnen bestaan; zo zal ook al dit volk in vrede aan zijn plaats komen. ");
INSERT INTO nld_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mozes nu hoorde naar de stem van zijn schoonvader, en hij deed alles, wat hij gezegd had. ");
INSERT INTO nld_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","En Mozes verkoos kloeke mannen, uit gans Israel, en maakte hen tot hoofden over het volk; oversten der duizenden, oversten der honderden, oversten der vijftigen, en oversten der tienen; ");
INSERT INTO nld_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dat zij het volk te allen tijde richtten, de harde zaak tot Mozes brachten, maar zij alle kleine zaak richtten. ");
INSERT INTO nld_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Toen liet Mozes zijn schoonvader trekken; en hij ging naar zijn land. ");
INSERT INTO nld_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In de derde maand, na het uittrekken der kinderen Israels uit Egypteland, ten zelfden dage kwamen zij in de woestijn Sinai. ");
INSERT INTO nld_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Want zij togen uit Rafidim, en kwamen in de woestijn Sinai, en zij legerden zich in de woestijn; Israel nu legerde zich aldaar tegenover dien berg. ");
INSERT INTO nld_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","En Mozes klom op tot God. En de HEERE riep tot hem van den berg, zeggende: Aldus zult gij tot het huis van Jakob spreken, en den kinderen Israels verkondigen: ");
INSERT INTO nld_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Gijlieden hebt gezien, wat Ik den Egyptenaren gedaan heb; hoe Ik u op vleugelen der arenden gedragen, en u tot Mij gebracht heb. ");
INSERT INTO nld_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nu dan, indien gij naarstiglijk Mijner stem zult gehoorzamen, en Mijn verbond houden, zo zult gij Mijn eigendom zijn uit alle volken, want de ganse aarde is Mijn; ");
INSERT INTO nld_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","En gij zult Mij een priesterlijk koninkrijk, en een heilig volk zijn. Dit zijn de woorden, die gij tot de kinderen Israels spreken zult. ");
INSERT INTO nld_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","En Mozes kwam en riep de oudsten des volks, en stelde voor hun aangezichten al deze woorden, die de HEERE hem geboden had. ");
INSERT INTO nld_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Toen antwoordde al het volk gelijkelijk, en zeide: Al wat de HEERE gesproken heeft, zullen wij doen! En Mozes bracht de woorden des volks weder tot den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","En de HEERE zeide tot Mozes: Zie, Ik zal tot u komen in een dikke wolk, opdat het volk hore, als Ik met u spreek, en dat zij ook eeuwiglijk aan u geloven. Want Mozes had den HEERE de woorden des volks verkondigd. ");
INSERT INTO nld_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ook zeide de HEERE tot Mozes: Ga tot het volk, en heilig hen heden en morgen, en dat zij hun klederen wassen, ");
INSERT INTO nld_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","En bereid zijn tegen den derden dag; want op den derden dag zal de HEERE voor de ogen van al het volk afkomen, op den berg Sinai. ");
INSERT INTO nld_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","En bepaal het volk rondom, zeggende: Wacht u op den berg te klimmen, en deszelfs einde aan te roeren; al wie den berg aanroert, zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Geen hand zal hem aanroeren, maar hij zal zekerlijk gestenigd, of zekerlijk doorschoten worden; hetzij een beest, hetzij een man, hij zal niet leven. Als de ramshoorn langzaam gaat, zullen zij op den berg klimmen. ");
INSERT INTO nld_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Toen ging Mozes van den berg af tot het volk, en hij heiligde het volk; en zij wiesen hun klederen. ");
INSERT INTO nld_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","En hij zeide tot het volk: Weest gereed tegen den derden dag, en nadert niet tot de vrouw. ");
INSERT INTO nld_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","En het geschiedde op den derden dag, toen het morgen was, dat er op den berg donderen en bliksemen waren, en een zware wolk, en het geluid ener zeer sterke bazuin, zodat al het volk verschrikte, dat in het leger was. ");
INSERT INTO nld_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","En Mozes leidde het volk uit het leger, Gode tegemoet; en zij stonden aan het onderste des bergs. ");
INSERT INTO nld_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","En de ganse berg Sinai rookte, omdat de HEERE op denzelven nederkwam in vuur; en zijn rook ging op, als de rook van een oven; en de ganse berg beefde zeer. ");
INSERT INTO nld_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Toen het geluid der bazuin gaande was, en zeer sterk werd, sprak Mozes; en God antwoordde hem met een stem. ");
INSERT INTO nld_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Als de HEERE nedergekomen was op den berg Sinai, op de spits des bergs, zo riep de HEERE Mozes op de spits des bergs; en Mozes klom op. ");
INSERT INTO nld_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","En de HEERE zeide tot Mozes: Ga af, betuig dit volk, dat zij niet doorbreken tot den HEERE, om te zien, en velen van hen vallen. ");
INSERT INTO nld_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Daartoe zullen ook de priesters, die tot den HEERE naderen, zich heiligen, dat de HEERE niet tegen hen uitbreke. ");
INSERT INTO nld_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Toen zeide Mozes tot den HEERE: Het volk zal op den berg Sinai niet kunnen klimmen, want Gij hebt ons betuigd, zeggende: Bepaal den berg, en heilig hem. ");
INSERT INTO nld_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","De HEERE dan zeide tot hem: Ga heen, klim af, daarna zult gij, en Aaron met u, opklimmen; doch dat de priesters en het volk niet doorbreken, om op te klimmen tot den HEERE, dat Hij tegen hen niet uitbreke. ");
INSERT INTO nld_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Toen klom Mozes af tot het volk, en zeide het hun aan. ");
INSERT INTO nld_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Toen sprak God al deze woorden, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ik ben de HEERE uw God, Die u uit Egypteland, uit het diensthuis, uitgeleid heb. ");
INSERT INTO nld_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Gij zult geen andere goden voor Mijn aangezicht hebben. ");
INSERT INTO nld_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gij zult u geen gesneden beeld, noch enige gelijkenis maken, van hetgeen boven in den hemel is, noch van hetgeen onder op de aarde is, noch van hetgeen in de wateren onder de aarde is. ");
INSERT INTO nld_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gij zult u voor die niet buigen, noch hen dienen; want Ik, de HEERE uw God, ben een ijverig God, Die de misdaad der vaderen bezoek aan de kinderen, aan het derde, en aan het vierde lid dergenen, die Mij haten; ");
INSERT INTO nld_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","En doe barmhartigheid aan duizenden dergenen, die Mij liefhebben, en Mijn geboden onderhouden. ");
INSERT INTO nld_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Gij zult den naam des HEEREN uws Gods niet ijdellijk gebruiken; want de HEERE zal niet onschuldig houden, die Zijn naam ijdellijk gebruikt. ");
INSERT INTO nld_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenkt den sabbatdag, dat gij dien heiligt. ");
INSERT INTO nld_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Zes dagen zult gij arbeiden en al uw werk doen; ");
INSERT INTO nld_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Maar de zevende dag is de sabbat des HEEREN uws Gods; dan zult gij geen werk doen, gij, noch uw zoon, noch uw dochter, noch uw dienstknecht, noch uw dienstmaagd, noch uw vee, noch uw vreemdeling, die in uw poorten is; ");
INSERT INTO nld_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Want in zes dagen heeft de HEERE den hemel en de aarde gemaakt, de zee en al wat daarin is, en Hij rustte ten zevenden dage; daarom zegende de HEERE den sabbatdag, en heiligde denzelven. ");
INSERT INTO nld_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Eert uw vader en uw moeder, opdat uw dagen verlengd worden in het land, dat u de HEERE uw God geeft. ");
INSERT INTO nld_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gij zult niet doodslaan. ");
INSERT INTO nld_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gij zult niet echtbreken. ");
INSERT INTO nld_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gij zult niet stelen. ");
INSERT INTO nld_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Gij zult geen valse getuigenis spreken tegen uw naaste. ");
INSERT INTO nld_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gij zult niet begeren uws naasten huis; gij zult niet begeren uws naasten vrouw, noch zijn dienstknecht, noch zijn dienstmaagd, noch zijn os, noch zijn ezel, noch iets, dat uws naasten is. ");
INSERT INTO nld_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","En al het volk zag de donderen, en de bliksemen, en het geluid der bazuin, en den rokenden berg; toen het volk zulks zag, weken zij af, en stonden van verre; ");
INSERT INTO nld_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","En zij zeiden tot Mozes: Spreek gij met ons, en wij zullen horen; en dat God met ons niet spreke, opdat wij niet sterven! ");
INSERT INTO nld_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","En Mozes zeide tot het volk: Vreest niet, want God is gekomen, opdat Hij u verzocht, en opdat Zijn vreze voor uw aangezicht zou zijn, dat gij niet zondigdet. ");
INSERT INTO nld_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","En het volk stond van verre; maar Mozes naderde tot de donkerheid, alwaar God was. ");
INSERT INTO nld_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Toen zeide de HEERE tot Mozes: Aldus zult gij tot de kinderen Israels zeggen: Gij hebt gezien, dat Ik met ulieden van den hemel gesproken heb. ");
INSERT INTO nld_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Gij zult nevens Mij niet maken zilveren goden, en gouden goden zult gij u niet maken. ");
INSERT INTO nld_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Maakt Mij een altaar van aarde, en offert daarop uw brandofferen, en uw dankofferen, uw schapen, en uw runderen; aan alle plaats, waar Ik Mijns Naams gedachtenis stichten zal, zal Ik tot u komen, en zal u zegenen. ");
INSERT INTO nld_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Maar indien gij Mij een stenen altaar zult maken, zo zult gij dit niet bouwen van gehouwen steen; zo gij uw houwijzer daarover verheft, zo zult gij het ontheiligen. ");
INSERT INTO nld_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Gij zult ook niet met trappen tot Mijn altaar opklimmen, opdat uw schaamte voor hetzelve niet ontdekt worde. ");
INSERT INTO nld_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Dit nu zijn de rechten, die gij hun zult voorstellen. ");
INSERT INTO nld_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Als gij een Hebreeuwsen knecht kopen zult, die zal zes jaren dienen; maar in het zevende zal hij voor vrij uitgaan, om niet. ");
INSERT INTO nld_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Indien hij met zijn lijf ingekomen zal zijn, zo zal hij met zijn lijf uitgaan; indien hij een getrouwd man was, zo zal zijn vrouw met hem uitgaan. ");
INSERT INTO nld_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Indien hem zijn heer een vrouw gegeven, en zij hem zonen of dochteren gebaard zal hebben, zo zal de vrouw en haar kinderen haars heren zijn, en hij zal met zijn lijf uitgaan. ");
INSERT INTO nld_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Maar indien de knecht ronduit zeggen zal: Ik heb mijn heer, mijn vrouw en mijn kinderen lief, ik wil niet vrij uitgaan; ");
INSERT INTO nld_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Zo zal hem zijn heer tot de goden brengen, daarna zal hij hem aan de deur, of aan den post brengen; en zijn heer zal hem met een priem zijn oor doorboren, en hij zal hem eeuwiglijk dienen. ");
INSERT INTO nld_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Wanneer nu iemand zijn dochter zal verkocht hebben tot een dienstmaagd, zo zal zij niet uitgaan, gelijk de knechten uitgaan. ");
INSERT INTO nld_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Indien zij kwalijk bevalt in de ogen haars heren, dat hij haar niet ondertrouwd heeft, zo zal hij haar doen lossen; aan een vreemd volk haar te verkopen zal hij niet vermogen, dewijl hij trouweloos met haar gehandeld heeft. ");
INSERT INTO nld_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Maar indien hij haar aan zijn zoon ondertrouwt, zo zal hij met haar doen naar het recht der dochteren. ");
INSERT INTO nld_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Indien hij voor zich een andere neemt, zo zal hij aan deze haar spijs, haar deksel, en haar huwelijksplicht niet onttrekken. ");
INSERT INTO nld_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","En indien hij haar deze drie dingen niet doet, zo zal zij om niet uitgaan, zonder geld. ");
INSERT INTO nld_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wie iemand slaat, dat hij sterft, die zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Doch die hem niet nagesteld heeft, maar God heeft hem zijn hand doen ontmoeten, zo zal Ik u een plaats bestellen, waar hij henen vliede. ");
INSERT INTO nld_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Maar indien iemand tegen zijn naaste moedwillig gehandeld heeft, om hem met list te doden, zo zult gij denzelven van voor Mijn altaar nemen, dat hij sterve. ");
INSERT INTO nld_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Zo wie zijn vader of zijn moeder slaat, die zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Verder, zo wie een mens steelt, hetzij dat hij dien verkocht heeft, of dat hij in zijn hand gevonden wordt, die zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wie ook zijn vader of zijn moeder vloekt, die zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","En wanneer mannen twisten, en de een slaat den ander met een steen, of met een vuist, en hij sterft niet, maar valt te bedde; ");
INSERT INTO nld_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Indien hij weder opstaat, en op straat gaat bij zijn stok, zo zal hij, die hem sloeg, onschuldig zijn; alleen zal hij geven hetgeen hij verzuimd heeft, en hij zal hem volkomen laten helen. ");
INSERT INTO nld_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Wanneer ook iemand zijn dienstknecht of zijn dienstmaagd met een stok slaat, dat hij onder zijn hand sterft, die zal zekerlijk gewroken worden. ");
INSERT INTO nld_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Zo hij nochtans een dag of twee dagen overeind blijft, zo zal hij niet gewroken worden; want hij is zijn geld. ");
INSERT INTO nld_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wanneer nu mannen kijven, en slaan een zwangere vrouw, dat haar de vrucht afgaat, doch geen dodelijk verderf zij, zo zal hij zekerlijk gestraft worden, gelijk als hem de man der vrouw oplegt, en hij zal het geven door de rechters. ");
INSERT INTO nld_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Maar indien er een dodelijk verderf zal zijn, zo zult gij geven ziel voor ziel, ");
INSERT INTO nld_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Oog voor oog, tand voor tand, hand voor hand, voet voor voet. ");
INSERT INTO nld_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brand voor brand, wond voor wond, buil voor buil. ");
INSERT INTO nld_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Wanneer ook iemand het oog van zijn dienstknecht, of het oog van zijn dienstmaagd slaat, en verderft het, hij zal hem vrij laten gaan voor zijn oog. ");
INSERT INTO nld_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","En indien hij een tand van zijn dienstknecht, of een tand van zijn dienstmaagd uitslaat, zo zal hij hem vrijlaten voor zijn tand. ");
INSERT INTO nld_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","En wanneer een os een man of een vrouw stoot, dat hij sterft, zal de os zekerlijk gestenigd worden, en zijn vlees zal niet gegeten worden; maar de heer van den os zal onschuldig zijn. ");
INSERT INTO nld_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Maar indien de os te voren stotig geweest is, en zijn heer is daarvan overtuigd geweest, en hij hem niet bewaard heeft, en hij doodt een man of een vrouw, zo zal die os gestenigd worden, en zijn heer zal ook gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Indien hem losgeld opgelegd wordt, zo zal hij tot lossing zijner ziel geven naar alles, wat hem zal opgelegd worden; ");
INSERT INTO nld_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Hetzij dat hij een zoon gestoten heeft, of een dochter gestoten heeft, naar dat recht zal hem gedaan worden. ");
INSERT INTO nld_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Indien de os een knecht of een dienstmaagd stoot, hij zal zijn heer dertig zilverlingen geven, en de os zal gestenigd worden. ");
INSERT INTO nld_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","En wanneer iemand een kuil opent, of wanneer iemand een kuil graaft, en hij dekt hem niet toe, en een os of ezel valt daarin; ");
INSERT INTO nld_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","De heer des kuils zal het vergelden; hij zal aan deszelfs heer het geld wederkeren; doch dat dode zal zijns wezen. ");
INSERT INTO nld_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wanneer nu iemands os den os van zijn naaste kwetst, dat hij sterft, zo zal men den levenden os verkopen, en het geld daarvan half en half delen, en den dode zal men ook half en half delen. ");
INSERT INTO nld_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Of is het kennelijk geweest, dat die os van te voren stotig was, en zijn heer heeft hem niet bewaard, zo zal hij in alle manier os voor os vergelden; doch de dode zal zijns wezen. ");
INSERT INTO nld_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wanneer iemand een os, of klein vee steelt, en slacht het, of verkoopt het, die zal vijf runderen voor een os wedergeven, en vier schapen voor een stuk klein vee. ");
INSERT INTO nld_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Indien een dief gevonden wordt in het doorgraven, en hij wordt geslagen, dat hij sterft, het zal hem geen bloedschuld zijn. ");
INSERT INTO nld_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Indien de zon over hem opgegaan is, zo zal het hem een bloedschuld zijn; hij zal het volkomen wedergeven; heeft hij niet, zo zal hij verkocht worden voor zijn dieverij. ");
INSERT INTO nld_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Indien de diefstal levend in zijn hand voorzeker gevonden wordt, hetzij os, of ezel, of klein vee, hij zal het dubbel wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Wanneer iemand een veld, of een wijngaard laat afweiden, en hij zijn beest daarin drijft, dat het in eens anders veld weidt, die zal het van het beste zijns velds en van het beste zijns wijngaards wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Wanneer een vuur uitgaat, en vat de doornen, zodat de koornhoop verteerd wordt, of het staande koorn, of het veld; hij, die den brand heeft aangestoken, zal het volkomen wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Wanneer iemand zijn naaste geld of vaten te bewaren geeft, en het wordt uit diens mans huis gestolen; indien de dief gevonden wordt, hij zal het dubbel wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Indien de dief niet gevonden wordt, zo zal de heer des huizes tot de goden gebracht worden, of hij niet zijn hand aan zijns naasten have gelegd heeft. ");
INSERT INTO nld_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Over alle zaak van onrecht, over een os, over een ezel, over klein vee, over kleding, over al het verlorene, hetwelk iemand zegt, dat het zijn is, beider zaak zal voor de goden komen; wien de goden verwijzen, die zal het aan zijn naaste dubbel wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Wanneer iemand aan zijn naaste een ezel, of os, of klein vee, of enig beest te bewaren geeft, en het sterft, of het wordt verzeerd, of weggedreven, dat het niemand ziet; ");
INSERT INTO nld_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Zo zal des HEEREN eed tussen hen beiden zijn, of hij niet zijn hand aan zijns naasten have geslagen heeft; en derzelver heer zal dien aannemen; en hij zal het niet wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Maar indien het van hem zekerlijk gestolen is, hij zal het zijn heer wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Is het gewisselijk verscheurd, dat hij het brenge tot getuige, zo zal hij het verscheurde niet wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","En wanneer iemand van zijn naaste wat begeert, en het wordt beschadigd, of het sterft; zijn heer daar niet bij zijnde, zal hij het volkomen wedergeven. ");
INSERT INTO nld_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Indien zijn heer daarbij geweest is, hij zal het niet wedergeven; indien het gehuurd is, zo is het voor zijn huur gekomen. ");
INSERT INTO nld_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wanneer nu iemand een maagd verlokt, die niet ondertrouwd is, en hij ligt bij haar, die zal haar zonder uitstel een bruidschat geven, dat zij hem ter vrouwe zij. ");
INSERT INTO nld_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Indien haar vader ganselijk weigert haar aan hem te geven, zo zal hij geld geven naar den bruidschat der maagden. ");
INSERT INTO nld_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","De toveres zult gij niet laten leven. ");
INSERT INTO nld_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Al wie bij een beest ligt, die zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wie den goden offert, behalve den HEERE alleen, die zal verbannen worden. ");
INSERT INTO nld_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Gij zult ook den vreemdeling geen overlast doen, noch hem onderdrukken; want gij zijt vreemdelingen geweest in Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Gij zult geen weduwe noch wees beledigen. ");
INSERT INTO nld_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Indien gij hen enigszins beledigt, en indien zij enigszins tot Mij roepen, Ik zal hun geroep zekerlijk verhoren; ");
INSERT INTO nld_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","En Mijn toorn zal ontsteken, en Ik zal ulieden met het zwaard doden; en uw vrouwen zullen weduwen, en uw kinderen zullen wezen worden. ");
INSERT INTO nld_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Indien gij Mijn volk, dat bij u arm is, geld leent, zo zult gij tegen hetzelve niet zijn, als een woekeraar; gij zult op hetzelve geen woeker leggen. ");
INSERT INTO nld_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Indien gij enigszins uws naasten kleed te pand neemt, zo zult gij het hem wedergeven, eer de zon ondergaat; ");
INSERT INTO nld_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Want dat alleen is zijn deksel, het is zijn kleed over zijn huid; waarin zou hij liggen? Het zal dan geschieden, wanneer hij tot Mij roept, dat Ik het zal horen; want Ik ben genadig! ");
INSERT INTO nld_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","De goden zult gij niet vloeken, en de oversten in uw volk zult gij niet lasteren. ");
INSERT INTO nld_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Uw volheid en uw tranen zult gij niet uitstellen; den eerstgeborene uwer zonen zult gij Mij geven. ");
INSERT INTO nld_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Desgelijks zult gij doen met uw ossen en met uw schapen; zeven dagen zullen zij bij hun moeder zijn, op den achtsten dag zult gij ze Mij geven. ");
INSERT INTO nld_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Gij nu zult Mij heilige lieden zijn; daarom zult gij geen vlees eten, dat op het veld gescheurd is, gij zult het den hond voorwerpen. ");
INSERT INTO nld_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Gij zult geen vals gerucht opnemen; en stelt uw hand niet bij den goddeloze, om een getuige tot geweld te zijn. ");
INSERT INTO nld_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Gij zult de menigte tot boze zaken niet volgen; en gij zult niet spreken in een twistige zaak, dat gij u neigt naar de menigte, om het recht te buigen. ");
INSERT INTO nld_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ook zult gij den geringe niet voortrekken en zijn twistige zaak. ");
INSERT INTO nld_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wanneer gij uws vijands os, of zijn dwalenden ezel, ontmoet, gij zult hem denzelven ganselijk wederbrengen. ");
INSERT INTO nld_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wanneer gij uws haters ezel onder zijn last ziet liggen, zult gij dan nalatig zijn, om het uwe te verlaten voor hem? Gij zult het in alle manier met hem verlaten. ");
INSERT INTO nld_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Gij zult het recht uws armen niet buigen in zijn twistige zaak. ");
INSERT INTO nld_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Zijt verre van valse zaken; en den onschuldige en gerechtige zult gij niet doden; want Ik zal den goddeloze niet rechtvaardigen. ");
INSERT INTO nld_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ook zult gij geen geschenk nemen; want het geschenk verblindt de zienden, en het verkeert de zaak der rechtvaardigen. ");
INSERT INTO nld_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Gij zult ook den vreemdeling niet onderdrukken; want gij kent het gemoed des vreemdelings, dewijl gij vreemdelingen geweest zijt in Egypteland. ");
INSERT INTO nld_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Gij zult ook zes jaar uw land bezaaien, en deszelfs inkomst verzamelen; ");
INSERT INTO nld_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Maar in het zevende zult gij het rusten en stil liggen laten, dat de armen uws volks mogen eten, en het overige daarvan de beesten des velds eten mogen; alzo zult gij ook doen met uw wijngaard, en met uw olijfbomen. ");
INSERT INTO nld_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Zes dagen zult gij uw werken doen; maar op den zevenden dag zult gij rusten; opdat uw os en uw ezel ruste, en dat de zoon uwer dienstmaagd en de vreemdeling adem scheppe. ");
INSERT INTO nld_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","In alles, wat Ik tot ulieden gezegd heb, zult gij op uw hoede zijn; en den naam van andere goden zult gij niet gedenken; uit uw mond zal hij niet gehoord worden! ");
INSERT INTO nld_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Drie reizen in het jaar zult gij Mij feest houden. ");
INSERT INTO nld_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Het feest van de ongezuurde broden zult gij houden; zeven dagen zult gij ongezuurde broden eten (gelijk Ik u geboden heb), ter bestemder tijd in de maand Abib, want in dezelve zijt gij uit Egypte getogen; doch men zal niet ledig voor Mijn aangezicht verschijnen. ");
INSERT INTO nld_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","En het feest des oogstes, der eerste vruchten van uw arbeid, die gij op het veld gezaaid zult hebben. En het feest der inzameling, op den uitgang des jaars, wanneer gij uw arbeid uit het veld zult ingezameld hebben. ");
INSERT INTO nld_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Drie malen des jaars zullen al uw mannen voor het aangezicht des Heeren HEEREN verschijnen. ");
INSERT INTO nld_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Gij zult het bloed Mijns offers met geen gedesemde broden offeren; ook zal het vette Mijns feestes tot op den morgen niet vernachten. ");
INSERT INTO nld_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","De eerstelingen der eerste vruchten uws lands zult gij in het huis des HEEREN uws Gods brengen. Gij zult het bokje niet koken in de melk zijner moeder. ");
INSERT INTO nld_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ziet, Ik zende een Engel voor uw aangezicht, om u te behoeden op dezen weg, en om u te brengen tot de plaats, die Ik bereid heb. ");
INSERT INTO nld_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Hoedt u voor Zijn aangezicht, en weest Zijner stem gehoorzaam, en verbittert Hem niet; want Hij zal ulieder overtredingen niet vergeven; want Mijn Naam is in het binnenste van Hem. ");
INSERT INTO nld_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Maar zo gij Zijner stem naarstiglijk gehoorzaamt, en doet al wat Ik spreken zal, zo zal Ik uwer vijanden vijand, en uwer wederpartijders wederpartij zijn. ");
INSERT INTO nld_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Want Mijn Engel zal voor uw aangezicht gaan, en Hij zal u inbrengen tot de Amorieten, en Hethieten, en Ferezieten, en Kanaanieten, Hevieten, en Jebusieten; en Ik zal hen verdelgen. ");
INSERT INTO nld_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Gij zult u voor hun goden niet buigen, noch hen dienen; ook zult gij naar hun werken niet doen; maar gij zult ze geheel afbreken, en hun opgerichte beelden ganselijk vermorzelen. ");
INSERT INTO nld_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","En gij zult den HEERE uw God dienen, zo zal Hij uw brood en uw water zegenen; en Ik zal de krankheden uit het midden van u weren. ");
INSERT INTO nld_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Er zal geen misdrachtige, noch onvruchtbare in uw land zijn; Ik zal het getal uwer dagen vervullen. ");
INSERT INTO nld_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ik zal Mijn schrik voor uw aangezicht zenden, en al het volk, tot hetwelk gij komt, versaagd maken; en Ik zal maken, dat al uw vijanden u den nek toekeren. ");
INSERT INTO nld_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ik zal ook horzelen voor uw aangezicht zenden; die zullen van voor uw aangezicht uitstoten de Hevieten, de Kanaanieten en de Hethieten. ");
INSERT INTO nld_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ik zal hen in een jaar van uw aangezicht niet uitstoten, opdat het land niet woest worde, en het wild gedierte boven u niet vermenigvuldigd worde. ");
INSERT INTO nld_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ik zal hen allengskens van uw aangezicht uitstoten, totdat gij gewassen zijt en het land erft. ");
INSERT INTO nld_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","En Ik zal uw landpalen zetten van de zee Suf tot aan de zee der Filistijnen, en van de woestijn tot aan de rivier; want Ik zal de inwoners van dat land in uw hand geven, dat gij hen voor uw aangezicht uitstoot. ");
INSERT INTO nld_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Gij zult met hen, noch met hun goden, een verbond maken. ");
INSERT INTO nld_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Zij zullen in uw land niet wonen, opdat zij u tegen Mij niet doen zondigen; indien gij hun goden dient, het zal u voorzeker tot een valstrik zijn. ");
INSERT INTO nld_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Daarna zeide Hij tot Mozes: Klim op tot den HEERE, gij en Aaron, Nadab en Abihu, en zeventig van de oudsten van Israel; en buigt u neder van verre! ");
INSERT INTO nld_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","En dat Mozes alleen zich nadere tot den HEERE, maar dat zij niet naderen; en het volk klimme ook niet op met hem. ");
INSERT INTO nld_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Als Mozes kwam en verhaalde aan het volk al de woorden des HEEREN, en al de rechten, toen antwoordde al het volk met een stem, en zij zeiden: Al deze woorden, die de HEERE gesproken heeft, zullen wij doen. ");
INSERT INTO nld_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mozes nu beschreef al de woorden des HEEREN, en hij maakte zich des morgens vroeg op, en hij bouwde een altaar onder aan den berg, en twaalf kolommen, naar de twaalf stammen van Israel. ");
INSERT INTO nld_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","En hij zond de jongelingen van de kinderen Israels, die brandofferen offerden, en den HEERE dankofferen offerden, van jonge ossen. ");
INSERT INTO nld_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","En Mozes nam de helft van het bloed, en zette het in bekkens; en de helft van het bloed sprengde hij op het altaar. ");
INSERT INTO nld_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","En hij nam het boek des verbonds, en hij las het voor de oren des volks; en zij zeiden: Al wat de HEERE gesproken heeft, zullen wij doen en gehoorzamen. ");
INSERT INTO nld_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Toen nam Mozes dat bloed, en sprengde het op het volk; en hij zeide: Ziet, dit is het bloed des verbonds, hetwelk de HEERE met ulieden gemaakt heeft over al die woorden. ");
INSERT INTO nld_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mozes nu en Aaron klommen opwaarts, ook Nadab en Abihu, en zeventig van de oudsten van Israel. ");
INSERT INTO nld_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","En zij zagen den God van Israel, en onder Zijn voeten als een werk van saffierstenen, en als de gestaltenis des hemels in Zijn klaarheid. ");
INSERT INTO nld_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Doch Hij strekte Zijn hand niet tot de afgezonderden van de kinderen Israels; maar zij aten en dronken, nadat zij God gezien hadden. ");
INSERT INTO nld_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Toen zeide de HEERE tot Mozes: Kom tot Mij op den berg, en wees aldaar; en Ik zal u stenen tafelen geven, en de wet, en de geboden, die Ik geschreven heb, om hen te onderwijzen. ");
INSERT INTO nld_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Toen maakte zich Mozes op, met Jozua, zijn dienaar; en Mozes klom op den berg Gods. ");
INSERT INTO nld_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","En hij zeide tot de oudsten: Blijft gij ons hier, totdat wij weder tot u komen; en ziet, Aaron en Hur zijn bij u; wie enige zaken heeft, zal tot dezelve komen. ");
INSERT INTO nld_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Toen Mozes op den berg geklommen was, zo heeft een wolk den berg bedekt. ");
INSERT INTO nld_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","En de heerlijkheid des HEEREN woonde op den berg Sinai, en de wolk bedekte hem zes dagen, en op den zevenden dag riep Hij Mozes uit het midden der wolk. ");
INSERT INTO nld_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","En het aanzien der heerlijkheid des HEEREN was als een verterend vuur, op het opperste diens bergs, in de ogen der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","En Mozes ging in het midden der wolk, nadat hij op den berg geklommen was; en Mozes was op dien berg veertig dagen en veertig nachten. ");
INSERT INTO nld_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Spreek tot de kinderen Israels, dat zij voor Mij een hefoffer nemen. Van alle man, wiens hart zich vrijwillig bewegen zal, zult gij Mijn hefoffer nemen. ");
INSERT INTO nld_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Dit nu is het hefoffer, hetwelk gij van hen nemen zult: goud, en zilver, en koper; ");
INSERT INTO nld_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Als ook hemelsblauw, en purper, en scharlaken, en fijn linnen, en geiten haar. ");
INSERT INTO nld_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","En roodgeverfde ramsvellen, en dassenvellen; en sittimhout; ");
INSERT INTO nld_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Olie tot den luchter, specerijen ter zalfolie, en tot roking welriekende specerijen; ");
INSERT INTO nld_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Sardonixstenen, en vervullende stenen tot den efod, en tot den borstlap. ");
INSERT INTO nld_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","En zij zullen Mij een heiligdom maken, dat Ik in het midden van hen wone. ");
INSERT INTO nld_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Naar al wat Ik u tot een voorbeeld dezes tabernakels, en een voorbeeld van al deszelfs gereedschap wijzen zal, even alzo zult gijlieden dat maken. ");
INSERT INTO nld_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Zo zullen zij een ark van sittimhout maken; twee ellen en een halve zal haar lengte zijn, en anderhalve el haar breedte, en anderhalve el haar hoogte. ");
INSERT INTO nld_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","En gij zult ze met louter goud overtrekken, van binnen en van buiten zult gij ze overtrekken; en gij zult op dezelve een gouden krans maken rondom heen. ");
INSERT INTO nld_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","En giet voor haar vier gouden ringen, en zet die aan haar vier hoeken, alzo dat twee ringen op de ene zijde derzelve zijn, en twee ringen op haar andere zijde. ");
INSERT INTO nld_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","En maak handbomen van sittimhout, en overtrek ze met goud. ");
INSERT INTO nld_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","En steek de handbomen in de ringen, die aan de zijde der ark zijn, dat men de ark daarmede drage. ");
INSERT INTO nld_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","De draagbomen zullen in de ringen der ark zijn; zij zullen er niet uitgetogen worden. ");
INSERT INTO nld_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Daarna zult gij in de ark leggen de getuigenis, die Ik u geven zal. ");
INSERT INTO nld_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Gij zult ook een verzoendeksel maken van louter goud; twee ellen en een halve zal deszelfs lengte zijn, en anderhalve el deszelfs breedte. ");
INSERT INTO nld_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Gij zult ook twee cherubim van goud maken; van dicht goud zult gij ze maken, uit de beide einden des verzoendeksels. ");
INSERT INTO nld_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","En maak u een cherub uit het ene einde aan deze zijde, en den anderen cherub uit het andere einde aan gene zijde; uit het verzoendeksel zult gijlieden de cherubim maken, uit de beide einden van hetzelve. ");
INSERT INTO nld_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","En de cherubim zullen hun beide vleugelen omhoog uitbreiden, bedekkende met hun vleugelen het verzoendeksel; en hun aangezichten zullen tegenover elkander zijn; de aangezichten der cherubim zullen naar het verzoendeksel zijn. ");
INSERT INTO nld_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","En gij zult het verzoendeksel boven op de ark zetten, nadat gij in de ark de getuigenis, die Ik u geven zal, zult gelegd hebben. ");
INSERT INTO nld_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","En aldaar zal Ik bij u komen, en Ik zal met u spreken van boven het verzoendeksel af, van tussen de twee cherubim, die op de ark der getuigenis zijn zullen, alles, wat Ik u gebieden zal aan de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Gij zult ook een tafel maken van sittimhout; twee ellen zal haar lengte zijn, en een el haar breedte, en een el en een halve zal haar hoogte zijn. ");
INSERT INTO nld_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","En gij zult ze met louter goud overtrekken; gij zult ook een gouden krans daaraan maken, rondom heen. ");
INSERT INTO nld_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Gij zult ook een lijst rondom daaraan maken, een hand breed; en gij zult een gouden krans rondom derzelver lijst maken. ");
INSERT INTO nld_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ook zult gij vier gouden ringen daaraan maken; en gij zult de ringen zetten aan de vier hoeken, die aan derzelver vier voeten zijn zullen. ");
INSERT INTO nld_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tegenover de lijst zullen de ringen zijn, tot plaatsen voor de handbomen, om de tafel te dragen. ");
INSERT INTO nld_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Deze handbomen nu zult gij van sittimhout maken, en gij zult dezelve met goud overtrekken; en de tafel zal daaraan gedragen worden. ");
INSERT INTO nld_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Gij zult ook maken haar schotelen, en haar rookschalen, en haar platelen, en haar kroezen (met welke zij bedekt zal worden); van louter goud zult gij ze maken. ");
INSERT INTO nld_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","En gij zult op deze tafel altijd het toonbrood voor Mijn aangezicht leggen. ");
INSERT INTO nld_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Gij zult ook een kandelaar van louter goud maken. Van dicht werk zal deze kandelaar gemaakt worden, zijn schacht, en zijn rietjes; zijn schaaltjes, zijn knopen, en zijn bloemen zullen uit hem zijn. ");
INSERT INTO nld_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","En zes rieten zullen uit zijn zijden uitgaan; drie rieten des kandelaars uit zijn ene zijde, en drie rieten des kandelaars uit zijn andere zijde. ");
INSERT INTO nld_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","In het ene riet zullen drie schaaltjes zijn, gelijk amandelnoten, een knoop en een bloem; en drie schaaltjes, gelijk amandelnoten in een ander riet, een knoop en een bloem; alzo zullen die zes rieten zijn, die uit den kandelaar gaan. ");
INSERT INTO nld_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Maar aan den kandelaar zelven zullen vier schaaltjes zijn, gelijk amandelnoten, met zijn knopen, en met zijn bloemen. ");
INSERT INTO nld_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","En daar zal een knoop zijn onder twee rieten, uit denzelven uitgaande; ook een knoop onder twee rieten, uit denzelven uitgaande; nog een knoop onder twee rieten, uit denzelven uitgaande; alzo zal het zijn met de zes rieten, die uit den kandelaar uitgaan. ");
INSERT INTO nld_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Hun knopen en hun rieten zullen uit hem zijn; het zal altemaal een enig dicht werk van louter goud zijn. ");
INSERT INTO nld_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Gij zult hem ook zeven lampen maken, en men zal zijn lampen aansteken, en doen lichten aan zijn zijden. ");
INSERT INTO nld_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Zijn snuiters en zijn blusvaten zullen louter goud zijn. ");
INSERT INTO nld_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Uit een talent louter goud zal men dat maken, met al dit gereedschap. ");
INSERT INTO nld_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Zie dan toe, dat gij het maakt naar hun voorbeeld, hetwelk u op den berg getoond is. ");
INSERT INTO nld_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Den tabernakel nu zult gij maken van tien gordijnen, van fijn getweernd linnen, en hemelsblauw, en purper, en scharlaken, met cherubim; van het allerkunstelijkste werk zult gij ze maken. ");
INSERT INTO nld_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","De lengte van een gordijn zal van acht en twintig ellen zijn, en de breedte ener gordijn van vier ellen; al deze gordijnen zullen een maat hebben. ");
INSERT INTO nld_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Er zullen vijf gordijnen samengevoegd zijn, de een aan de andere; wederom zullen er vijf gordijnen samengevoegd zijn, de een aan de andere. ");
INSERT INTO nld_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","En gij zult hemelsblauwe striklisjes maken aan den kant van de ene gordijn, aan het uiterste, in de samenvoeging; alzo zult gij ook doen aan den uitersten kant der gordijn, aan de tweede samenvoegende. ");
INSERT INTO nld_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Vijftig striklisjes zult gij aan de ene gordijn maken, en vijftig striklisjes zult gij maken aan het uiterste der gordijn, dat aan de tweede samenvoegende is; deze striklisjes zullen het ene aan het andere samenvatten. ");
INSERT INTO nld_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Gij zult ook vijftig gouden haakjes maken, en zult de gordijnen samenvoegen, de ene aan de andere, met deze haakjes, opdat het een tabernakel zij. ");
INSERT INTO nld_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ook zult gij gordijnen uit geiten haar maken tot een tent over den tabernakel; van elf gordijnen zult gij die maken. ");
INSERT INTO nld_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","De lengte ener gordijn zal dertig ellen zijn, en de breedte ener gordijn vier ellen; deze elf gordijnen zullen een maat hebben. ");
INSERT INTO nld_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","En gij zult vijf dezer gordijnen aan elkander bijzonder voegen, en zes dezer gordijnen bijzonder; en de zesde dezer gordijnen zult gij dubbel maken, recht voorop de tent. ");
INSERT INTO nld_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","En gij zult vijftig striklisjes maken aan den kant van de ene gordijn, het uiterste in de samenvoeging, en vijftig striklisjes aan den kant van de gordijn, die de tweede samenvoegende is. ");
INSERT INTO nld_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Gij zult ook vijftig koperen haakjes maken, en gij zult de haakjes in de striklisjes doen, en gij zult de tent samenvoegen, dat zij een zij. ");
INSERT INTO nld_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Het overige nu, dat overschiet aan de gordijnen der tent, de helft der gordijn, die overschiet, zal overhangen, aan de achterste delen des tabernakels. ");
INSERT INTO nld_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","En een el van deze, en een el van gene zijde van hetgeen, dat overig zijn zal aan de lengte van de gordijnen der tent, zal overhangen aan de zijden des tabernakels, aan deze en aan gene zijde, om dien te bedekken. ");
INSERT INTO nld_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Gij zult ook voor de tent een deksel maken van roodgeverfde ramsvellen, en daarover een deksel van dassenvellen. ");
INSERT INTO nld_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Gij zult ook tot den tabernakel staande berderen maken, van sittimhout. ");
INSERT INTO nld_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","De lengte van een berd zal tien ellen zijn, en een el en een halve el zal de breedte van elk berd zijn. ");
INSERT INTO nld_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Twee houvasten zal een berd hebben, als sporten in een ladder gezet, het ene nevens het andere; alzo zult gij het met al de berderen des tabernakels maken. ");
INSERT INTO nld_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","En de berderen tot den tabernakel zult gij aldus maken: twintig berderen naar de zuidzijde zuidwaarts. ");
INSERT INTO nld_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Gij zult ook veertig zilveren voeten maken onder de twintig berderen; twee voeten onder een berd, aan zijn twee houvasten, en twee voeten onder een ander berd, aan zijn twee houvasten. ");
INSERT INTO nld_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Er zullen ook twintig berderen zijn aan de andere zijde des tabernakels, aan den noorderhoek, ");
INSERT INTO nld_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Met hun veertig zilveren voeten; twee voeten onder een berd, en twee voeten onder een ander berd. ");
INSERT INTO nld_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Doch aan de zijde des tabernakels tegen het westen zult gij zes berderen maken. ");
INSERT INTO nld_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ook zult gij twee berderen maken tot de hoekberderen des tabernakels, aan de beide zijden. ");
INSERT INTO nld_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","En zij zullen van beneden als tweelingen samengevoegd zijn; zij zullen ook als tweelingen aan het oppereinde deszelven samengevoegd zijn, met een ring; alzo zal het met de twee berderen zijn; tot twee hoekberderen zullen zij zijn. ");
INSERT INTO nld_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Alzo zullen de acht berderen zijn met hun zilveren voeten, zijnde zestien voeten; twee voeten onder een berd, wederom twee voeten onder een berd. ");
INSERT INTO nld_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Gij zult ook richelen maken van sittimhout; vijf aan de berderen van de ene zijde des tabernakels; ");
INSERT INTO nld_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","En vijf richelen aan de berderen van de andere zijde des tabernakels; alsook vijf richelen aan de berderen van de zijde des tabernakels, aan de beide zijden westwaarts. ");
INSERT INTO nld_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","En de middelste richel zal midden aan de berderen zijn, doorschietende van het ene einde tot het andere einde. ");
INSERT INTO nld_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","En gij zult de berderen met goud overtrekken, en hun ringen (de plaatsen voor de richelen) zult gij van goud maken; de richelen zult gij ook met goud overtrekken. ");
INSERT INTO nld_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Dan zult gij den tabernakel oprichten naar zijn wijze, die u op den berg getoond is. ");
INSERT INTO nld_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Daarna zult gij een voorhang maken, van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen; van het allerkunstelijkste werk zal men dien maken, met cherubim. ");
INSERT INTO nld_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","En gij zult hem hangen aan vier pilaren van sittim hout, met goud overtogen; hun haken zullen van goud zijn; staande op vier zilveren voeten. ");
INSERT INTO nld_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","En gij zult den voorhang onder de haakjes hangen, en gij zult de ark der getuigenis aldaar binnen den voorhang brengen; en deze voorhang zal ulieden een scheiding maken tussen het heilige, en tussen het heilige der heiligen. ");
INSERT INTO nld_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","En gij zult het verzoendeksel zetten op de ark der getuigenis, in het heilige der heiligen. ");
INSERT INTO nld_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","De tafel nu zult gij zetten buiten den voorhang, en den kandelaar tegen de tafel over, aan de ene zijde des tabernakels, zuidwaarts; maar de tafel zult gij zetten aan de noordzijde. ");
INSERT INTO nld_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Gij zult ook aan de deur der tent een deksel maken, van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen, geborduurd werk. ");
INSERT INTO nld_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","En gij zult tot dit deksel vijf pilaren van sittim hout maken, en die met goud overtrekken; hun haken zullen van goud zijn; en gij zult hun vijf koperen voeten gieten. ");
INSERT INTO nld_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Gij zult ook een altaar maken van sittimhout; vijf ellen zal de lengte zijn, en vijf ellen de breedte (vierkant zal dit altaar zijn), en drie ellen zijn hoogte. ");
INSERT INTO nld_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","En gij zult zijn hoornen maken op zijn vier hoeken; uit hetzelve zullen zijn hoornen zijn, en gij zult het met koper overtrekken. ");
INSERT INTO nld_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Gij zult het ook potten maken, om zijn as te ontvangen, ook zijn schoffelen, en zijn besprengbekkens, en zijn krauwelen, en zijn koolpannen; al zijn gereedschap zult gij van koper maken. ");
INSERT INTO nld_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Gij zult het een rooster maken van koperen netwerk; en gij zult aan dat net vier koperen ringen maken aan zijn vier einden. ");
INSERT INTO nld_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","En gij zult het onder den omloop des altaars van beneden opleggen, alzo dat het net tot het midden des altaars zij. ");
INSERT INTO nld_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Gij zult ook handbomen maken tot het altaar, handbomen van sittimhout; en gij zult ze met koper overtrekken. ");
INSERT INTO nld_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","En de handbomen zullen in de ringen gedaan worden, alzo dat de handbomen zijn aan beide zijden des altaars, als men het draagt. ");
INSERT INTO nld_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Gij zult hetzelve hol van planken maken; gelijk als Hij u op den berg gewezen heeft, alzo zullen zij doen. ");
INSERT INTO nld_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Gij zult ook den voorhof des tabernakels maken; aan den zuidhoek zuidwaarts, zullen aan den voorhof behangselen zijn van fijn getweernd linnen; de lengte ener zijde zal honderd ellen zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ook zullen zijn twintig pilaren, en derzelver twintig voeten, van koper zijn; de haken dezer pilaren, en hun banden zullen van zilver zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Alzo zullen ook aan den noorderhoek, in de lengte, de behangsels honderd ellen lang zijn; en zijn twintig pilaren, en derzelver twintig voeten, van koper; de haken der pilaren, en derzelver banden zullen van zilver zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","En in de breedte des voorhofs, aan den westerhoek, zullen behangselen zijn van vijftig ellen; hun pilaren tien, en derzelver voeten tien. ");
INSERT INTO nld_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Van gelijken zal de breedte des voorhofs, aan den oosterhoek oostwaarts, van vijftig ellen zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Alzo dat er vijftien ellen der behangselen op de ene zijde zijn; hun pilaren drie, en hun voeten drie; ");
INSERT INTO nld_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","En vijftien ellen der behangselen aan de andere zijde; hun pilaren drie, en hun voeten drie. ");
INSERT INTO nld_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","In de poort nu des voorhofs zal een deksel zijn van twintig ellen, hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen, geborduurd werk; de pilaren vier, en hun voeten vier. ");
INSERT INTO nld_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Al de pilaren des voorhofs zullen rondom met zilveren banden bezet zijn; hun haken zullen van zilver zijn, maar hun voeten zullen van koper zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","De lengte des voorhofs zal honderd ellen zijn, en de breedte doorgaans vijftig, en de hoogte vijf ellen, van fijn getweernd linnen; maar hun voeten zullen van koper zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Aangaande al het gereedschap des tabernakels, in al deszelfs dienst, ja, al zijn pennen, en al de pennen des voorhofs, zullen van koper zijn. ");
INSERT INTO nld_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Gij nu zult den kinderen Israels gebieden, dat zij tot u brengen reine olie van olijven, gestoten tot den luchter, dat men geduriglijk de lampen aansteke. ");
INSERT INTO nld_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In de tent der samenkomst, van buiten den voorhang, die voor de getuigenis is, zal ze Aaron en zijn zonen toerichten, van den avond tot den morgen, voor het aangezicht des HEEREN; dit zal een eeuwige inzetting zijn voor hun geslachten, vanwege de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Daarna zult gij uw broeder Aaron, en zijn zonen met hem, tot u doen naderen uit het midden der kinderen Israels, om Mij het priesterambt te bedienen: namelijk Aaron, Nadab en Abihu, Eleazar en Ithamar, de zonen van Aaron. ");
INSERT INTO nld_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","En gij zult voor uw broeder Aaron heilige klederen maken, tot heerlijkheid en tot sieraad. ");
INSERT INTO nld_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gij zult ook spreken tot allen, die wijs van hart zijn, die Ik met den geest der wijsheid vervuld heb, dat zij voor Aaron klederen maken, om hem te heiligen, dat hij Mij het priesterambt bediene. ");
INSERT INTO nld_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Dit nu zijn de klederen, die zij maken zullen: een borstlap, en een efod, en een mantel, en een rok vol oogjes, een hoed en een gordel; zij zullen dan voor uw broeder Aaron heilige klederen maken, en voor zijn zonen, om Mij het priesterambt te bedienen. ");
INSERT INTO nld_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Zij zullen ook het goud, en hemelsblauw, en purper, en scharlaken, en fijn linnen nemen; ");
INSERT INTO nld_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","En zullen den efod maken van goud, hemelsblauw, en purper, scharlaken en fijn getweernd linnen, van het allerkunstelijkste werk. ");
INSERT INTO nld_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hij zal twee samenvoegende schouderbanden hebben aan zijn beide einden, waarmede hij samengevoegd zal worden. ");
INSERT INTO nld_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","En de kunstelijke riem zijns efods, die op hem is, zal zijn gelijk zijn werk, van hetzelfde, van goud, hemelsblauw en purper, en scharlaken, en fijn getweernd linnen. ");
INSERT INTO nld_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","En gij zult twee sardonixstenen nemen, en de namen der zonen van Israel daarop graveren. ");
INSERT INTO nld_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Zes van hun namen op een steen, en de zes overige namen op den anderen steen, naar hun geboorten; ");
INSERT INTO nld_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Naar steensnijderswerk, gelijk men de zegelen graveert, zult gij deze twee stenen graveren, met de namen der zonen van Israel; gij zult ze maken, dat zij omvat zijn in gouden kastjes. ");
INSERT INTO nld_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","En gij zult de twee stenen aan de schouderbanden des efods zetten, zijnde stenen ter gedachtenis voor de kinderen Israels; en Aaron zal hun namen op zijn beide schouders dragen, ter gedachtenis, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Gij zult ook gouden kastjes maken, ");
INSERT INTO nld_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","En twee ketentjes van louter goud; gelijk-eindigende zult gij die maken, gedraaid werk; en de gedraaide ketentjes zult gij aan de kastjes hechten. ");
INSERT INTO nld_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Gij zult ook een borstlap des gerichts maken, van het allerkunstelijkste werk, gelijk het werk des efods zult gij hem maken; van goud, hemelsblauw, en purper, en scharlaken, en van fijn getweernd linnen zult gij hem maken. ");
INSERT INTO nld_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Vierkant zal hij zijn, en verdubbeld; een span zal zijn lengte zijn, en een span zijn breedte. ");
INSERT INTO nld_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","En gij zult vervullende stenen daarin vullen, vier rijen stenen, een rij van een Sardis, een Topaas en een Karbonkel; dit is de eerste rij. ");
INSERT INTO nld_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","En de tweede rij van een Smaragd, een Saffier, en een Diamant. ");
INSERT INTO nld_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","En de derde rij, een Hyacint, Agaat en Amethist. ");
INSERT INTO nld_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","En de vierde rij van een Turkoois, en een Sardonix, en een Jaspis; zij zullen met goud ingevat zijn in hun vullingen. ");
INSERT INTO nld_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","En deze stenen zullen zijn met de twaalf namen der zonen van Israel, met hun namen; zij zullen als zegelen gegraveerd worden, elk met zijn naam; voor de twaalf stammen zullen zij zijn. ");
INSERT INTO nld_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Gij zult ook aan den borstlap gelijk-eindigende ketentjes van gedraaid werk uit louter goud maken. ");
INSERT INTO nld_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Gij zult ook aan den borstlap twee gouden ringen maken; en gij zult de twee ringen aan de twee einden van den borstlap zetten. ");
INSERT INTO nld_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Dan zult gij de twee gedraaide gouden ketentjes in de twee ringen doen, aan de einden van den borstlap. ");
INSERT INTO nld_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Maar de twee einden der twee gedraaide ketentjes zult gij aan die twee kastjes doen; en gij zult ze zetten aan de schouderbanden van den efod, recht op de voorste zijde van dien. ");
INSERT INTO nld_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Gij zult nog twee gouden ringen maken, en zult ze aan de twee einden des borstlaps zetten; inwendig aan zijn rand, die aan de zijde van den efod zijn zal. ");
INSERT INTO nld_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nog zult gij twee gouden ringen maken, die gij zetten zult aan de twee schouderbanden van den efod, beneden aan de voorste zijde, tegenover zijn voege, boven den kunstelijken riem des efods. ");
INSERT INTO nld_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","En zij zullen den borstlap met zijn ringen aan de ringen van den efod opwaarts binden, met een hemelsblauw snoer, dat hij op den kunstelijken riem van den efod zij; en de borstlap zal van den efod niet afgescheiden worden. ");
INSERT INTO nld_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Alzo zal Aaron de namen der zonen van Israel dragen aan den borstlap des gerichts, op zijn hart, als hij in het heilige zal gaan, ter gedachtenis voor het aangezicht des HEEREN geduriglijk. ");
INSERT INTO nld_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Gij zult ook in den borstlap des gerichts de Urim en de Thummim zetten, dat zij op het hart van Aaron zijn, als hij voor het aangezicht des HEEREN ingaan zal; alzo zal Aaron dat gericht der kinderen Israels geduriglijk op zijn hart dragen, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Gij zult ook den mantel des efods geheel van hemelsblauw maken. ");
INSERT INTO nld_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","En het hoofdgat deszelven zal in het midden daarvan zijn; dit gat zal een boord rondom hebben van geweven werk; als het gat eens pantsiers zal het daaraan zijn, dat het niet gescheurd worde. ");
INSERT INTO nld_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","En aan deszelfs zomen zult gij granaatappelen maken van hemelsblauw, en van purper, en van scharlaken, aan zijn zomen rondom, en gouden schelletjes rondom tussen dezelve. ");
INSERT INTO nld_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dat er een gouden schelletje, daarna een granaatappel zij; wederom een gouden schelletje, en een granaatappel, aan de zomen des mantels rondom. ");
INSERT INTO nld_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","En Aaron zal denzelven aanhebben, om te dienen; opdat zijn geluid gehoord worde, als hij in het heilige, voor het aangezicht des HEEREN, ingaat, en als hij uitgaat, opdat hij niet sterve. ");
INSERT INTO nld_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Verder zult gij een plaat maken van louter goud, en gij zult daarin graveren, gelijk men de zegelen graveert: De HEILIGHEID DES HEEREN! ");
INSERT INTO nld_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","En gij zult dezelve aanhechten met een hemelsblauw snoer, alzo dat zij aan den hoed zij; aan de voorste zijde des hoeds zal zij zijn. ");
INSERT INTO nld_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","En zij zal op het voorhoofd van Aaron zijn, opdat Aaron drage de ongerechtigheid der heilige dingen, welke de kinderen Israels zullen geheiligd hebben, in alle gaven hunner geheiligde dingen; en zij zal geduriglijk aan zijn voorhoofd zijn, om henlieden voor het aangezicht des HEEREN aangenaam te maken. ");
INSERT INTO nld_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Gij zult ook een rok vol oogjes maken, van fijn linnen; gij zult ook den hoed van fijn linnen maken; maar den gordel zult gij van geborduurd werk maken. ");
INSERT INTO nld_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Voor de zonen van Aaron zult gij ook rokken maken, en gij zult voor hen gordels maken; ook zult gij voor hen mutsen maken, tot heerlijkheid en sieraad. ");
INSERT INTO nld_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","En gij zult die uw broeder Aaron en ook zijn zonen aantrekken; en gij zult hen zalven, en hun hand vullen, en hen heiligen, dat zij Mij het priesterambt bedienen. ");
INSERT INTO nld_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Maak hun ook linnen onderbroeken, om het vlees der schaamte te bedekken; zij zullen zijn van de lenden tot de dijen. ");
INSERT INTO nld_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron nu en zijn zonen zullen die aanhebben, als zij in de tent der samenkomst gaan, of als zij tot het altaar treden zullen, om in het heilige te dienen; opdat zij geen ongerechtigheid dragen en sterven. Dit zal een eeuwige inzetting zijn, voor hem, en zijn zaad na hem. ");
INSERT INTO nld_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Dit nu is de zaak, die gij hun doen zult, om hen te heiligen, dat zij Mij het priesterambt bedienen: neem een var, het jong eens runds, en twee volkomen rammen; ");
INSERT INTO nld_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","En ongezuurd brood, en ongezuurde koeken, met olie gemengd, en ongezuurde vladen, met olie bestreken; van tarwemeelbloem zult gij dezelve maken. ");
INSERT INTO nld_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","En gij zult ze in een korf leggen, en zult ze in den korf toebrengen, met den var en de twee rammen. ");
INSERT INTO nld_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Alsdan zult gij Aaron en zijn zonen doen naderen aan de deur van de tent der samenkomst; en gij zult hen met water wassen. ");
INSERT INTO nld_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Daarna zult gij de klederen nemen, en Aaron den rok, en den mantel des efods, en den efod, en den borstlap aandoen; en gij zult hem omgorden met den kunstelijken riem des efods. ");
INSERT INTO nld_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","En gij zult den hoed op zijn hoofd zetten; de kroon der heiligheid zult gij aan den hoed zetten. ");
INSERT INTO nld_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","En gij zult de zalfolie nemen, en op zijn hoofd gieten; alzo zult gij hem zalven. ");
INSERT INTO nld_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Daarna zult gij zijn zonen doen naderen, en zult hen de rokken doen aantrekken. ");
INSERT INTO nld_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","En gij zult hen met den gordel omgorden, namelijk Aaron en zijn zonen; en gij zult hun de mutsen opbinden, opdat zij het priesterambt hebben tot een eeuwige inzetting. Voorts zult gij de hand van Aaron vullen, en de hand zijner zonen. ");
INSERT INTO nld_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","En gij zult den var nabij brengen voor de tent der samenkomst; en Aaron en zijn zonen zullen hun handen op het hoofd van den var leggen. ");
INSERT INTO nld_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","En gij zult den var slachten voor het aangezicht des HEEREN, voor de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Daarna zult gij van het bloed des vars nemen, en met uw vinger op de hoornen des altaars doen; en al het bloed zult gij uitgieten aan den bodem des altaars. ");
INSERT INTO nld_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Gij zult ook al het vet nemen, hetwelk het ingewand bedekt, en het net over de lever, en beide nieren en het vet, dat aan dezelve is, en gij zult ze aansteken op het altaar. ");
INSERT INTO nld_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maar het vlees des vars, en zijn vel, en zijn drek, zult gij met vuur verbranden, buiten het leger; het is een zondoffer. ");
INSERT INTO nld_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Daarna zult gij den enen ram nemen, en Aaron en zijn zonen zullen hun handen op het hoofd des rams leggen; ");
INSERT INTO nld_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","En gij zult den ram slachten, en gij zult zijn bloed nemen, en rondom op het altaar sprengen. ");
INSERT INTO nld_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","En den ram zult gij in zijn delen delen; en gij zult zijn ingewand en zijn schenkelen wassen, en op zijn delen, en op zijn hoofd leggen. ");
INSERT INTO nld_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Alzo zult gij den gehelen ram aansteken op het altaar; het is een brandoffer den HEERE, tot een liefelijken reuk, het is een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Daarna zult gij den anderen ram nemen, en Aaron en zijn zonen zullen hun handen op des rams hoofd leggen; ");
INSERT INTO nld_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","En gij zult den ram slachten, en van zijn bloed nemen, en doen het op het rechter oorlapje van Aaron, en op het rechteroorlapje van zijn zonen, desgelijks op den duim hunner rechterhand, en op den groten teen huns rechtervoets; en dat bloed zult gij op het altaar sprengen, rondom heen. ");
INSERT INTO nld_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Dan zult gij nemen van het bloed, dat op het altaar is, en van de zalfolie, en gij zult op Aaron en op zijn klederen sprengen, en op zijn zonen en op de klederen zijner zonen met hem; opdat hij geheiligd zij, en zijn klederen, ook zijn zonen, en de klederen zijner zonen met hem. ");
INSERT INTO nld_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Daarna zult gij van den ram nemen het vet mitsgaders den staart, ook het vet, dat het ingewand bedekt, en het net der lever en de beide nieren, met het vet, dat aan dezelve is, en den rechterschouder; want het is een ram der vulofferen; ");
INSERT INTO nld_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","En een broodbol, en een koek geolied brood, en een vlade, uit den korf der ongezuurde broden, die voor het aangezicht des HEEREN zijn zal; ");
INSERT INTO nld_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","En leg ze alle op de handen van Aaron, en op de handen zijner zonen, en beweeg ze ten beweegoffer voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Neem ze daarna van hun hand, en steek ze aan op het altaar, op het brandoffer, tot een liefelijken reuk voor het aangezicht des HEEREN; het is een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","En neem de borst van den ram der vulofferen, die van Aaron is, en beweeg hem ten beweegoffer voor het aangezicht des HEEREN; en het zal u ten dele zijn. ");
INSERT INTO nld_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","En gij zult de borst des beweegoffers heiligen, en den schouder des hefoffers, die bewogen, en die opgeheven zal zijn van den ram des vuloffers, van hetgeen dat Aarons, en van hetgeen dat zijner zonen is. ");
INSERT INTO nld_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","En het zal voor Aaron en zijn zonen zijn tot een eeuwige inzetting vanwege de kinderen Israels; want het is een hefoffer; en het hefoffer vanwege de kinderen Israels zal zijn van hun dankofferen; hun hefoffer zal voor den HEERE zijn. ");
INSERT INTO nld_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","De heilige klederen nu, die van Aaron zullen geweest zijn, zullen van zijn zonen na hem zijn, opdat men hen in dezelve zalve, en dat men hun hand in dezelve vulle. ");
INSERT INTO nld_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Zeven dagen zal hij ze aantrekken, die uit zijn zonen in zijn plaats priester zal worden, die in de tent der samenkomst gaan zal, om in het heilige te dienen. ");
INSERT INTO nld_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Gij zult den ram der vulling nemen, en gij zult zijn vlees in de heilige plaats zieden. ");
INSERT INTO nld_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron nu en zijn zonen zullen het vlees van dezen ram eten, en het brood, dat in den korf zal zijn, bij de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","En zij zullen die dingen eten, met welke de verzoening zal gedaan zijn, om hun hand te vullen, en om hen te heiligen; maar een vreemde zal ze niet eten, want ze zijn heilig. ");
INSERT INTO nld_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","En indien er wat overblijven zal van het vlees der vulofferen, of van dit brood, tot aan den morgen, zo zult gij het overgeblevene met vuur verbranden; het zal niet gegeten worden, want het is heilig. ");
INSERT INTO nld_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Gij zult dan aan Aaron en aan zijn zonen alzo doen, naar alles, wat Ik u geboden heb; zeven dagen zult gij hun hand vullen. ");
INSERT INTO nld_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Gij zult ook des daags een var des zondoffers bereiden, tot de verzoeningen, en gij zult het altaar ontzondigen, mits doende de verzoening over hetzelve; en gij zult het zalven, om het te heiligen. ");
INSERT INTO nld_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Zeven dagen zult gij verzoening doen voor het altaar, en zult het heiligen; alsdan zal dat altaar een heiligheid der heiligheden zijn; al wat het altaar aanroert, zal heilig zijn. ");
INSERT INTO nld_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Dit nu is het, wat gij op het altaar bereiden zult: twee lammeren, die eenjarig zijn, des daags, geduriglijk. ");
INSERT INTO nld_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Het ene lam zult gij des morgens bereiden; maar het andere lam zult gij bereiden tussen de twee avonden. ");
INSERT INTO nld_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Met een tiende deel meelbloem, gemengd met een vierendeel van een hin gestoten olie; en tot drankoffer een vierde deel van een hin wijn, tot het ene lam. ");
INSERT INTO nld_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Het andere lam nu zult gij bereiden tussen de twee avonden; gij zult daarmede doen gelijk met het morgenspijsoffer, en gelijk met het drankoffer deszelven, tot een liefelijken reuk; het is een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Het zal een gedurig brandoffer zijn bij uw geslachten, aan de deur van de tent der samenkomst, voor het aangezicht des HEEREN; aldaar zal Ik met ulieden komen, dat Ik aldaar met u spreke. ");
INSERT INTO nld_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","En daar zal Ik komen tot de kinderen Israels; opdat zij geheiligd worden door Mijn heerlijkheid. ");
INSERT INTO nld_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","En Ik zal de tent der samenkomst heiligen, mitsgaders het altaar; Ik zal ook Aaron en zijn zonen heiligen, opdat zij Mij het priesterambt bedienen. ");
INSERT INTO nld_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","En Ik zal in het midden der kinderen Israels wonen, en Ik zal hun tot een God zijn. ");
INSERT INTO nld_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","En zij zullen weten, dat Ik de HEERE hun God ben, Die hen uit Egypteland uitgevoerd heb, opdat Ik in het midden van hen wonen zou; Ik ben de HEERE, hun God. ");
INSERT INTO nld_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Gij zult ook een reukaltaar des reukwerks maken; van sittimhout zult gij het maken. ");
INSERT INTO nld_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Een el zal zijn lengte zijn, en een el zijn breedte, vierkant zal het zijn, maar twee ellen deszelfs hoogte; uit hetzelve zullen zijn hoornen zijn. ");
INSERT INTO nld_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","En gij zult het met louter goud overtrekken, zijn dak en deszelfs wanden rondom, als ook zijn hoornen; en gij zult het een gouden krans rondom maken. ");
INSERT INTO nld_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Gij zult ook twee gouden ringen daaraan maken, onder zijn krans; aan zijn twee zijden zult gij dezelve maken, aan zijn beide zijden; en zij zullen zijn tot plaatsen voor de handbomen, dat men het daarmede drage. ");
INSERT INTO nld_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","De draagbomen nu zult gij van sittimhout maken, en gij zult die met goud overtrekken. ");
INSERT INTO nld_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","En gij zult het zetten voor den voorhang, die voor de ark der getuigenis zijn zal; voor het verzoendeksel, hetwelk zijn zal boven de getuigenis, waarheen Ik met u samenkomen zal. ");
INSERT INTO nld_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","En Aaron zal daarop aansteken welriekende specerijen; allen morgen, als hij de lampen wel zal toegericht hebben, zal hij dezelve aansteken. ");
INSERT INTO nld_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","En als Aaron de lampen aansteken zal, tussen de twee avonden, zal hij dat aansteken; het zal een gedurig reukwerk zijn, voor het aangezicht des HEEREN, bij uw geslachten. ");
INSERT INTO nld_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Gij zult geen vreemd reukwerk op hetzelve aansteken, noch brandoffer, noch spijsoffer; gij zult ook geen drankoffer daarop gieten. ");
INSERT INTO nld_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","En Aaron zal eens in het jaar over deszelfs hoornen verzoening doen, met het bloed des zondoffers der verzoeningen; eens in het jaar zal hij verzoening daarop doen bij uw geslachten; het is heiligheid der heiligheden den HEERE! ");
INSERT INTO nld_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Als gij de som van de kinderen Israels opnemen zult, naar de getelden onder hen, zo zullen zij een iegelijk de verzoening zijner ziel den HEERE geven, als gij hen tellen zult; opdat onder hen geen plage zij, als gij hen tellen zult. ");
INSERT INTO nld_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dit zullen zij geven, al die tot de getelden overgaat, de helft eens sikkels, naar den sikkel des heiligdoms (deze sikkel is twintig gera); de helft eens sikkels is een hefoffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Al wie overgaat tot de getelden, van twintig jaren oud en daarboven, zal het hefoffer des HEEREN geven. ");
INSERT INTO nld_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","De rijke zal het niet vermeerderen, en de arme zal niet verminderen van de helft des sikkels, als gij het hefoffer des HEEREN geeft om voor uw zielen verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gij dan zult het geld der verzoeningen van de kinderen Israels nemen, en zult het leggen tot den dienst van de tent der samenkomst; en het zal den kinderen Israels ter gedachtenis zijn, voor het aangezicht des HEEREN, om voor uw zielen verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Gij zult ook een koperen wasvat maken, met zijn koperen voet, om te wassen; en gij zult het zetten tussen de tent der samenkomst, en tussen het altaar, en gij zult water daarin doen; ");
INSERT INTO nld_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Dat Aaron en zijn zonen zich daaruit wassen, hun handen en voeten. ");
INSERT INTO nld_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wanneer zij in de tent der samenkomst zullen gaan, zo zullen zij zich met water wassen, opdat zij niet sterven; of wanneer zij tot het altaar naderen, om te dienen, dat zij het vuuroffer den HEERE aansteken; ");
INSERT INTO nld_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Zij zullen dan hun handen en voeten wassen, opdat zij niet sterven; en dit zal hun een eeuwige inzetting zijn, voor hem en zijn zaad, bij hun geslachten. ");
INSERT INTO nld_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Gij nu, neem u de voornaamste specerijen, de zuiverste mirre, vijfhonderd sikkels, en specerijkaneel, half zoveel namelijk tweehonderd en vijftig sikkels, ook specerijkalmus, tweehonderd en vijftig sikkels; ");
INSERT INTO nld_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Ook kassie, vijfhonderd, naar den sikkel des heiligdoms, en olie van olijfbomen een hin; ");
INSERT INTO nld_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","En maak daarvan een olie der heilige zalving, een zalf, heel kunstiglijk gemaakt, naar apothekerswerk; het zal een olie der heilige zalving zijn. ");
INSERT INTO nld_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","En met dezelve zult gij zalven de tent der samenkomst, en de ark der getuigenis. ");
INSERT INTO nld_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","En de tafel met al haar gereedschap, en den kandelaar met zijn gereedschap, en het reukaltaar; ");
INSERT INTO nld_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","En het altaar des brandoffers, met al zijn gereedschap, en het wasvat met zijn voet. ");
INSERT INTO nld_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Gij zult ze alzo heiligen, dat zij heiligheid der heiligheden zijn; al wat ze aanroert, zal heilig zijn. ");
INSERT INTO nld_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Gij zult ook Aaron en zijn zonen zalven, en gij zult hen heiligen, om Mij het priesterambt te bedienen. ");
INSERT INTO nld_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","En gij zult tot de kinderen Israels spreken, zeggende: Dit zal Mij een olie der heilige zalving zijn bij uw geslachten. ");
INSERT INTO nld_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Op geens mensen vlees zal men ze gieten; gij zult ook naar haar maaksel geen dergelijke maken; het is heiligheid, zij zal ulieden heiligheid zijn. ");
INSERT INTO nld_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","De man, die zulk een zalf maken zal als deze, of die daarvan op wat vreemds doet, die zal uitgeroeid worden uit zijn volken. ");
INSERT INTO nld_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Verder zeide de HEERE tot Mozes: Neem tot u welriekende specerijen, mirresap, en oniche, en galban, deze welriekende specerijen, en zuiveren wierook; dat elk bijzonder zij. ");
INSERT INTO nld_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","En gij zult een reukwerk ener zalf daaruit maken, naar het werk des apothekers, gemengd, rein, heilig. ");
INSERT INTO nld_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","En gij zult van hetzelve heel klein pulver stoten, en gij zult daarvan leggen voor de getuigenis in de tent der samenkomst, waarheen Ik tot u komen zal; het zal ulieden heiligheid der heiligheden zijn. ");
INSERT INTO nld_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Doch naar het maaksel dezes reukwerks, hetwelk gij gemaakt zult hebben, zult gijlieden voor uzelven geen maken; het zal u heiligheid zijn voor den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","De man, die dergelijke maken zal, om daaraan te rieken, die zal uitgeroeid worden uit zijn volken. ");
INSERT INTO nld_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Zie, Ik heb met name geroepen Bezaleel, den zoon van Uri, den zoon van Hur, van den stam van Juda. ");
INSERT INTO nld_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","En Ik heb hem vervuld met den Geest Gods, met wijsheid, en met verstand, en met wetenschap, namelijk in alle handwerk; ");
INSERT INTO nld_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Om te bedenken vernuftigen arbeid; te werken in goud, en in zilver, en in koper, ");
INSERT INTO nld_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","En in kunstige steensnijding, om in te zetten, en in kunstige houtsnijding, om te werken in alle handwerk. ");
INSERT INTO nld_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","En Ik, zie, Ik heb hem bijgevoegd Aholiab, den zoon van Ahisamach, van den stam van Dan; en in het hart van een iegelijk, die wijs van hart is, heb Ik wijsheid gegeven; en zij zullen maken al wat Ik u geboden heb. ");
INSERT INTO nld_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Namelijk de tent der samenkomst, en de ark der getuigenis, en het verzoendeksel, dat daarop zal zijn, en al het gereedschap der tent; ");
INSERT INTO nld_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","En de tafel, met haar gereedschap; en den louteren kandelaar, met al zijn gereedschap; en het reukaltaar; ");
INSERT INTO nld_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ook des brandoffers altaar, met al zijn gereedschap; en het wasvat met zijn voet; ");
INSERT INTO nld_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","En de ambtsklederen, en de heilige klederen van den priester Aaron, en de klederen van zijn zonen, om het priesterambt te bedienen; ");
INSERT INTO nld_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ook de zalfolie, en het reukwerk van welriekende specerijen voor het heiligdom; naar alles, wat Ik u geboden heb, zullen zij het maken. ");
INSERT INTO nld_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Gij nu, spreek tot de kinderen Israels, zeggende: Gij zult evenwel mijn sabbatten onderhouden; want dit is een teken tussen Mij en tussen ulieden, bij uw geslachten; opdat men wete, dat Ik de HEERE ben, Die u heilige. ");
INSERT INTO nld_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Onderhoudt dan den sabbat, dewijl hij ulieden heilig is! Wie hem ontheiligt, zal zekerlijk gedood worden; want een ieder, die op denzelven enig werk doet, die ziel zal uitgeroeid worden uit het midden harer volken. ");
INSERT INTO nld_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Zes dagen zal men het werk doen; doch op den zevenden dag is de sabbat der rust, een heiligheid des HEEREN! Wie op den sabbatdag arbeid doet, zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Dat dan de kinderen Israels den sabbat houden, den sabbat onderhoudende in hun geslachten, tot een eeuwig verbond. ");
INSERT INTO nld_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Hij zal tussen Mij en tussen de kinderen Israels een teken in eeuwigheid zijn; dewijl de HEERE, in zes dagen, den hemel en de aarde gemaakt, en op den zevenden dag gerust en Zich verkwikt heeft. ");
INSERT INTO nld_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","En Hij gaf aan Mozes, als Hij met hem op den berg Sinai te spreken geeindigd had, de twee tafelen der getuigenis, tafelen van steen, beschreven met den vinger Gods. ");
INSERT INTO nld_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Toen het volk zag, dat Mozes vertoog van den berg af te komen, zo verzamelde zich het volk tot Aaron, en zij zeiden tot hem: Sta op, maak ons goden, die voor ons aangezicht gaan; want dezen Mozes, dien man, die ons uit Egypteland uitgevoerd heeft, wij weten niet, wat hem geschied zij. ");
INSERT INTO nld_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron nu zeide tot hen: Rukt af de gouden oorsierselen, die in de oren uwer vrouwen, uwer zonen, en uwer dochteren zijn; en brengt ze tot mij. ");
INSERT INTO nld_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Toen rukte het ganse volk de gouden oorsierselen af, die in hun oren waren; en zij brachten ze tot Aaron. ");
INSERT INTO nld_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","En hij nam ze uit hun hand, en hij bewierp het met een griffie, en hij maakte een gegoten kalf daaruit. Toen zeiden zij: Dit zijn uw goden, Israel! die u uit Egypteland opgevoerd hebben. ");
INSERT INTO nld_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Als Aaron dat zag, zo bouwde hij een altaar voor hetzelve; en Aaron riep uit, en zeide: Morgen zal den HEERE een feest zijn! ");
INSERT INTO nld_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","En zij stonden des anderen daags vroeg op, en offerden brandoffer, en brachten dankoffer daartoe; en het volk zat neder om te eten en te drinken; daarna stonden zij op, om te spelen. ");
INSERT INTO nld_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Toen sprak de HEERE tot Mozes: Ga heen, klim af! want uw volk, dat gij uit Egypteland opgevoerd hebt, heeft het verdorven. ");
INSERT INTO nld_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","En zij zijn haast afgeweken van den weg, dien Ik hun geboden had, zij hebben zich een gegoten kalf gemaakt; en zij hebben zich voor hetzelve gebogen, en hebben het offerande gedaan, en gezegd: Dit zijn uw goden, Israel, die u uit Egypteland opgevoerd hebben. ");
INSERT INTO nld_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Verder zeide de HEERE tot Mozes: Ik heb dit volk gezien, en zie, het is een hardnekkig volk! ");
INSERT INTO nld_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","En nu, laat Mij toe, dat Mijn toorn tegen hen ontsteke, en hen vertere; zo zal Ik u tot een groot volk maken. ");
INSERT INTO nld_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Doch Mozes aanbad het aangezicht des HEEREN zijns Gods, en hij zeide: O HEERE! waarom zou Uw toorn ontsteken tegen Uw volk, hetwelk Gij met grote kracht, en met een sterke hand, uit Egypteland uitgevoerd hebt? ");
INSERT INTO nld_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Waarom zouden de Egyptenaars spreken, zeggende: In kwaadheid heeft Hij hen uitgevoerd, opdat Hij hen doodde op de bergen, en opdat Hij hen vernielde van den aardbodem? Keer af van de hittigheid Uws toorns, en laat het U over het kwaad Uws volks berouwen. ");
INSERT INTO nld_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenk aan Abraham, aan Izak en aan Israel, Uw knechten, aan welke Gij bij Uzelven gezworen hebt, en hebt tot hen gesproken: Ik zal uw zaad vermenigvuldigen als de sterren des hemels; en dit gehele land, waarvan Ik gezegd heb, zal Ik aan ulieder zaad geven, dat zij het erfelijk bezitten in eeuwigheid. ");
INSERT INTO nld_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Toen berouwde het den HEERE over het kwaad, hetwelk Hij gesproken had Zijn volk te zullen doen. ");
INSERT INTO nld_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","En Mozes wendde zich om, en klom van den berg af, met de twee tafelen der getuigenis in zijn hand; deze tafelen waren op haar beide zijden beschreven, zij waren op de ene en op de andere zijde beschreven. ");
INSERT INTO nld_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","En diezelfde tafelen waren Gods werk; het geschrift was ook Gods geschrift zelf, in de tafelen gegraveerd. ");
INSERT INTO nld_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Toen nu Jozua des volks stem hoorde, als het juichte, zo zeide hij tot Mozes: Er is een krijgsgeschrei in het leger. ");
INSERT INTO nld_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Maar hij zeide: Het is geen stem des geroeps van overwinning, het is ook geen stem des geroeps van nederlaag; ik hoor een stem van zingen bij beurte. ");
INSERT INTO nld_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","En het geschiedde, als hij aan het leger naderde, en het kalf, en de reien zag, dat de toorn van Mozes ontstak, en dat hij de tafelen uit zijn handen wierp, en dezelve beneden aan den berg verbrak. ");
INSERT INTO nld_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","En hij nam dat kalf, dat zij gemaakt hadden, en verbrandde het in het vuur, en vermaalde het, totdat het klein werd, en strooide het op het water, en deed het den kinderen Israels drinken. ");
INSERT INTO nld_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","En Mozes zeide tot Aaron: Wat heeft u dit volk gedaan, dat gij zulk een grote zonde over hetzelve gebracht hebt? ");
INSERT INTO nld_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Toen zeide Aaron: De toorn mijns heren ontsteke niet! gij kent dit volk, dat het in den boze ligt. ");
INSERT INTO nld_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Zij dan zeiden tot mij: Maak ons goden, die voor ons aangezicht gaan, want dezen Mozes, dien man, die ons uit Egypteland opgevoerd heeft, wij weten niet, wat hem geschied zij. ");
INSERT INTO nld_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Toen zeide ik tot hen: Wie goud heeft, die rukke het af, en geve het mij; en ik wierp het in het vuur, en dit kalf is er uit gekomen. ");
INSERT INTO nld_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Als Mozes zag, dat het volk ontbloot was, (want Aaron had het ontbloot tot verkleining onder degenen, die tegen hen hadden mogen opstaan), ");
INSERT INTO nld_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Zo bleef Mozes staan in de poort des legers, en zeide: Wie den HEERE toebehoort, kome tot mij! Toen verzamelden zich tot hem al de zonen van Levi. ");
INSERT INTO nld_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","En hij zeide tot hen: Alzo zegt de HEERE, de God van Israel: Een ieder doe zijn zwaard aan zijn heup; gaat door en keert weder, van poort tot poort in het leger, en een iegelijk dode zijn broeder, en elk zijn vriend, en elk zijn naaste! ");
INSERT INTO nld_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","En de zonen van Levi deden naar het woord van Mozes; en er vielen van het volk, op dien dag, drie duizend man. ");
INSERT INTO nld_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Want Mozes had gezegd: Vult heden uw handen den HEERE; want elk zal zijn tegen zijn zoon, en tegen zijn broeder; en dit, opdat Hij heden een zegen over ulieden geve! ");
INSERT INTO nld_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","En het geschiedde des anderen daags, dat Mozes tot het volk zeide: Gijlieden hebt een grote zonde gezondigd; doch nu, ik zal tot den HEERE opklimmen; misschien zal ik een verzoening doen voor uw zonde. ");
INSERT INTO nld_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Zo keerde Mozes weder tot den HEERE, en zeide: Och, dit volk heeft een grote zonde gezondigd, dat zij zich gouden goden gemaakt hebben. ");
INSERT INTO nld_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nu dan, indien Gij hun zonden vergeven zult! doch zo niet, zo delg mij nu uit Uw boek, hetwelk Gij geschreven hebt. ");
INSERT INTO nld_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Toen zeide de HEERE tot Mozes: Dien zou Ik uit Mijn boek delgen, die aan Mij zondigt. ");
INSERT INTO nld_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Doch ga nu heen, leid dit volk, waarheen Ik u gezegd heb; zie, Mijn Engel zal voor uw aangezicht gaan! doch ten dage Mijns bezoekens, zo zal Ik hun zonde over hen bezoeken! ");
INSERT INTO nld_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aldus plaagde de HEERE dit volk, omdat zij dat kalf gemaakt hadden, hetwelk Aaron gemaakt had. ");
INSERT INTO nld_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Voorts sprak de HEERE tot Mozes: Ga heen, trek op van hier, gij en het volk, dat gij uit Egypteland opgevoerd hebt, naar het land, dat Ik Abraham, Izak en Jakob gezworen heb, zeggende: Aan uw zaad zal Ik het geven; ");
INSERT INTO nld_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","En Ik zal een Engel voor uw aangezicht zenden (en Ik zal uitdrijven de Kanaanieten, de Amorieten, en de Hethieten, en de Ferezieten, de Hevieten, en de Jebusieten), ");
INSERT INTO nld_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Naar het land, dat van melk en honig is vloeiende; want Ik zal in het midden van u niet optrekken; want gij zijt een hardnekkig volk; dat Ik u op dezen weg niet vertere. ");
INSERT INTO nld_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Toen het volk dit kwade woord hoorde, zo droegen zij leed; en niemand van hen deed zijn versiersel aan zich. ");
INSERT INTO nld_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","En de HEERE had tot Mozes gezegd: Zeg tot de kinderen Israels: Gij zijt een hardnekkig volk; in een ogenblik zou Ik in het midden van ulieden optrekken, en zou u vernielen; doch nu, legt uw sieraad van u af, en Ik zal weten, wat Ik u doen zal. ");
INSERT INTO nld_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","De kinderen Israels dan beroofden zichzelven van hun versierselen, verre van den berg Horeb. ");
INSERT INTO nld_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","En Mozes nam de tent, en spande ze zich buiten het leger, ver van het leger afwijkende; en hij noemde ze de Tent der samenkomst. En het geschiedde, dat al wie den HEERE zocht, uitging tot de tent der samenkomst, die buiten het leger was. ");
INSERT INTO nld_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","En het geschiedde, wanneer Mozes uitging naar de tent, stond al het volk op, en een ieder stelde zich in de deur zijner tent; en zij zagen Mozes na, totdat hij de tent ingegaan was. ");
INSERT INTO nld_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","En het geschiedde, als Mozes de tent ingegaan was, zo kwam de wolkkolom nederwaarts, en stond in de deur der tent, en Hij sprak met Mozes. ");
INSERT INTO nld_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Als het volk de wolkkolom zag staan in de deur der tent, zo stond al het volk op, en zij bogen zich, een ieder in de deur zijner tent. ");
INSERT INTO nld_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","En de HEERE sprak tot Mozes aangezicht aan aangezicht, gelijk een man met zijn vriend spreekt; daarna keerde hij weder tot het leger; doch zijn dienaar Jozua, de zoon van Nun, de jongeling, week niet uit het midden der tent. ");
INSERT INTO nld_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","En Mozes zeide tot den HEERE: Zie, Gij zegt tot mij: Voer dit volk op! maar Gij laat mij niet weten, wien Gij met mij zult zenden; daar Gij gezegd hebt: Ik ken u bij name! en ook: Gij hebt genade gevonden in Mijn ogen! ");
INSERT INTO nld_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nu dan, ik bidde, indien ik genade gevonden heb in Uw ogen, zo laat mij nu Uw weg weten, en ik zal U kennen, opdat ik genade vinde in Uw ogen; en zie aan, dat deze natie Uw volk is! ");
INSERT INTO nld_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Hij dan zeide: Zou Mijn aangezicht moeten medegaan, om u gerust te stellen? ");
INSERT INTO nld_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Toen zeide hij tot Hem: Indien Uw aangezicht niet medegaan zal, doe ons van hier niet optrekken! ");
INSERT INTO nld_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Want waarbij zou nu bekend worden, dat ik genade gevonden heb in Uw ogen, ik en Uw volk? Is het niet daarbij, dat Gij met ons gaat? Alzo zullen wij afgezonderd worden, ik en Uw volk, van alle volk, dat op den aardbodem is. ");
INSERT INTO nld_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Toen zeide de HEERE tot Mozes: Ook deze zelfde zaak, die gij gesproken hebt, zal Ik doen, dewijl gij genade gevonden hebt in Mijn ogen, en Ik u bij name ken. ");
INSERT INTO nld_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Toen zeide hij: Toon mij nu Uw heerlijkheid! ");
INSERT INTO nld_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Doch Hij zeide: Ik zal al Mijn goedigheid voorbij uw aangezicht laten gaan, en zal den Naam des HEEREN uitroepen voor uw aangezicht; maar Ik zal genadig zijn, wien Ik zal genadig zijn, en Ik zal Mij ontfermen, over wien Ik Mij ontfermen zal. ");
INSERT INTO nld_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hij zeide verder: Gij zoudt Mijn aangezicht niet kunnen zien; want Mij zal geen mens zien, en leven. ");
INSERT INTO nld_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","De HEERE zeide verder: Zie, er is een plaats bij Mij; daar zult gij u op de steenrots stellen. ");
INSERT INTO nld_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","En het zal geschieden, wanneer Mijn heerlijkheid voorbij zal gaan, zo zal Ik u in een kloof der steenrots zetten; en Ik zal u met Mijn hand overdekken, totdat Ik zal voorbijgegaan zijn. ");
INSERT INTO nld_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","En wanneer Ik Mijn hand zal weggenomen hebben, zo zult gij Mijn achterste delen zien; maar Mijn aangezicht zal niet gezien worden! ");
INSERT INTO nld_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Toen zeide de HEERE tot Mozes: Houw u twee stenen tafelen, gelijk de eerste waren, zo zal Ik op de tafelen schrijven dezelfde woorden, die op de eerste tafelen geweest zijn, die gij gebroken hebt. ");
INSERT INTO nld_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","En wees bereid tegen den morgenstond; dat gij in den morgenstond op den berg Sinai klimt, en stel u aldaar voor Mij, op den top des bergs. ");
INSERT INTO nld_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","En niemand zal met u opklimmen; dat er ook niemand gezien worde op den gansen berg; ook het kleine vee, noch runderen zullen tegenover dezen berg niet weiden. ");
INSERT INTO nld_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Toen hieuw hij twee stenen tafelen, gelijk de eerste; en Mozes stond des morgens vroeg op, en klom op den berg Sinai, gelijk als hem de HEERE geboden had; en hij nam de twee stenen tafelen in zijn hand. ");
INSERT INTO nld_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","De HEERE nu kwam nederwaarts in een wolk, en stelde Zich aldaar bij hem; en Hij riep uit den Naam des HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Als nu de HEERE voor zijn aangezicht voorbijging, zo riep Hij: HEERE, HEERE, God, barmhartig en genadig, lankmoedig en groot van weldadigheid en waarheid. ");
INSERT INTO nld_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Die de weldadigheid bewaart aan vele duizenden, Die de ongerechtigheid, en overtreding, en zonde vergeeft; Die den schuldige geenszins onschuldig houdt, bezoekende de ongerechtigheid der vaderen aan de kinderen, en aan de kindskinderen, in het derde en vierde lid. ");
INSERT INTO nld_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mozes nu haastte zich en neigde het hoofd ter aarde, en hij boog zich. ");
INSERT INTO nld_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","En hij zeide: Heere! indien ik nu genade gevonden heb in Uw ogen, zo ga nu de Heere in het midden van ons, want dit is een hardnekkig volk; doch vergeef onze ongerechtigheid en onze zonde, en neem ons aan tot een erfdeel! ");
INSERT INTO nld_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Toen zeide Hij: Zie, Ik maak een verbond; voor uw ganse volk zal Ik wonderen doen, die niet geschapen zijn op de ganse aarde, noch onder enige volken; alzo dat dit ganse volk, in welks midden gij zijt, des HEEREN werk zien zal, dat het schrikkelijk is, hetwelk Ik met u doe. ");
INSERT INTO nld_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Onderhoudt gij hetgeen Ik u heden gebiede! zie, Ik zal voor uw aangezicht uitdrijven de Amorieten, en de Kanaanieten, en de Hethieten, en de Ferezieten, en de Hevieten, en de Jebusieten. ");
INSERT INTO nld_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wacht u, dat gij toch geen verbond maakt met den inwoner des lands, waarin gij komen zult; dat hij misschien niet tot een strik worde in het midden van u. ");
INSERT INTO nld_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Maar hun altaren zult gijlieden omwerpen, en hun opgerichte beelden zult gij verbreken, en hun bossen zult gij afhouwen. ");
INSERT INTO nld_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","(Want gij zult u niet buigen voor een anderen god; want des HEEREN Naam is Ijveraar! een ijverig God is Hij!) ");
INSERT INTO nld_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Opdat gij misschien geen verbond maakt met den inwoner van dat land; en zij hun goden niet nahoereren, noch hun goden offerande doen, en hij u nodigende, gij van hun offerande etet. ");
INSERT INTO nld_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","En gij voor uw zonen vrouwen neemt van hun dochteren; en hun dochteren, haar goden nahoererende, maken, dat ook uw zonen haar goden nahoereren. ");
INSERT INTO nld_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Gij zult u geen gegoten goden maken. ");
INSERT INTO nld_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Het feest der ongezuurde broden zult gij houden; zeven dagen zult gij ongezuurde broden eten, gelijk Ik u geboden heb, ter gezetter tijd der maand Abib; want in de maand Abib zijt gij uit Egypte uitgegaan. ");
INSERT INTO nld_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Al wat de baarmoeder opent, is Mijn; ja, al uw vee, dat mannelijk zal geboren worden, openende de baarmoeder van het grote en kleine vee. ");
INSERT INTO nld_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Doch den ezel, die de baarmoeder opent, zult gij met een stuk klein vee lossen; maar indien gij hem niet zult lossen, zo zult gij hem den nek breken. Al de eerstgeborenen uwer zonen zult gij lossen, en men zal voor Mijn aangezicht niet ledig verschijnen. ");
INSERT INTO nld_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Zes dagen zult gij arbeiden, maar op den zevenden dag zult gij rusten; in den ploegtijd en in den oogst zult gij rusten. ");
INSERT INTO nld_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Het feest der weken zult gij ook houden, zijnde het feest der eerstelingen van den tarweoogst, en het feest der inzameling, als het jaar om is. ");
INSERT INTO nld_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Al wat mannelijk is onder u zal driemaal in het jaar verschijnen voor het aangezicht des Heeren HEEREN, den God van Israel. ");
INSERT INTO nld_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Wanneer Ik de volken voor uw aangezicht uit de bezitting zal verdrijven, en uw landpalen verwijden, dan zal niemand uw land begeren, terwijl gij henen opgaan zult, om te verschijnen voor het aangezicht des HEEREN uws Gods, driemaal in het jaar. ");
INSERT INTO nld_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Gij zult het bloed van Mijn slachtoffer niet offeren met gedesemd brood; het slachtoffer van het paasfeest zal ook niet vernachten tot den morgen. ");
INSERT INTO nld_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","De eerstelingen van de eerste vruchten uws lands zult gij in het huis des HEEREN uws Gods brengen. Gij zult het bokje in de melk zijner moeder niet koken. ");
INSERT INTO nld_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Verder zeide de HEERE tot Mozes: Schrijf u deze woorden; want naar luid dezer woorden heb Ik een verbond met u en met Israel gemaakt. ");
INSERT INTO nld_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","En hij was aldaar met den HEERE, veertig dagen en veertig nachten; hij at geen brood, en hij dronk geen water; en Hij schreef op de tafelen de woorden des verbonds, de tien woorden. ");
INSERT INTO nld_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","En het geschiedde, toen Mozes van den berg Sinai afging (de twee tafelen der getuigenis nu waren in de hand van Mozes, als hij van den berg afging), zo wist Mozes niet, dat het vel zijns aangezichts glinsterde, toen Hij met hem sprak. ");
INSERT INTO nld_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Als nu Aaron en al de kinderen Israels Mozes aanzagen, ziet, zo glinsterde het vel zijns aangezichts; daarom vreesden zij tot hem toe te treden. ");
INSERT INTO nld_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Toen riep Mozes hen; en Aaron, en al de oversten in de vergadering keerden weder tot hem; en Mozes sprak tot hen. ");
INSERT INTO nld_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","En daarna traden al de kinderen Israels toe; en hij gebood hun al wat de HEERE met hem gesproken had op den berg Sinai. ");
INSERT INTO nld_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Alzo eindigde Mozes met hen te spreken, en hij had een deksel op zijn aangezicht gelegd. ");
INSERT INTO nld_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Doch als Mozes voor het aangezicht des HEEREN kwam, om met Hem te spreken, zo nam hij het deksel af, totdat hij uitging; en nadat hij uitgegaan was, zo sprak hij tot de kinderen Israels, wat hem geboden was. ");
INSERT INTO nld_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Zo zagen dan de kinderen Israels het aangezicht van Mozes, dat het vel van het aangezicht van Mozes glinsterde; derhalve deed Mozes het deksel weder op zijn aangezicht, totdat hij inging om met Hem te spreken. ");
INSERT INTO nld_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Toen deed Mozes de ganse vergadering der kinderen Israels verzamelen, en zeide tot hen: Dit zijn de woorden, die de HEERE geboden heeft, dat men ze doe. ");
INSERT INTO nld_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Zes dagen zal men het werk doen; maar op den zevenden dag zal ulieden heiligheid zijn, een sabbat der rust den HEERE; al wie daarop werk doet, zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Gij zult geen vuur aansteken in enige uwer woningen op den sabbatdag. ");
INSERT INTO nld_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Verder sprak Mozes tot de ganse vergadering der kinderen Israels, zeggende: Dit is het woord, dat de HEERE geboden heeft, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Neemt van hetgeen, dat gijlieden hebt, een hefoffer den HEERE; een ieder, wiens hart vrijwillig is, zal het brengen, ten hefoffer des HEEREN: goud, en zilver, en koper; ");
INSERT INTO nld_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Als ook hemelsblauw, en purper, en scharlaken, en fijn linnen, en geiten haar; ");
INSERT INTO nld_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","En roodgeverfde ramsvellen, en dassenvellen, en sittimhout; ");
INSERT INTO nld_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","En olie tot den luchter, en specerijen ter zalfolie, en tot roking welriekende specerijen; ");
INSERT INTO nld_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","En sardonixstenen, en vervullende stenen, tot den efod en tot den borstlap. ");
INSERT INTO nld_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","En allen, die wijs van hart zijn onder ulieden, zullen komen, en maken alles, wat de HEERE geboden heeft: ");
INSERT INTO nld_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","De tabernakel, zijn tent en zijn deksel, zijn haakjes en zijn berderen, zijn richelen, zijn pilaren, en zijn voeten; ");
INSERT INTO nld_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","De ark en haar handbomen, het verzoendeksel en den voorhang des deksels; ");
INSERT INTO nld_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","De tafel en haar handbomen, en al haar gereedschap, en de toonbroden; ");
INSERT INTO nld_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","En den kandelaar tot het licht, en zijn gereedschap, en zijn lampen, en de olie tot het licht; ");
INSERT INTO nld_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","En het reukaltaar, en zijn handbomen, en de zalfolie, en het reukwerk van welriekende specerijen; en het deksel der deur aan de deur des tabernakels; ");
INSERT INTO nld_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Het altaar des brandoffers, en den koperen rooster, dien het hebben zal, zijn handbomen, en al zijn gereedschappen; het wasvat en zijn voet. ");
INSERT INTO nld_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","De behangselen des voorhofs, zijn pilaren en zijn voeten; en het deksel van de poort des voorhofs; ");
INSERT INTO nld_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","De nagelen des tabernakels, en de pennen des voorhofs, met derzelver zelen; ");
INSERT INTO nld_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","De ambtsklederen om in het heilige te dienen, de heilige klederen van den priester Aaron, en de klederen zijner zonen, om het priesterambt te bedienen. ");
INSERT INTO nld_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toen ging de ganse vergadering der kinderen Israels uit van voor het aangezicht van Mozes. ");
INSERT INTO nld_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","En zij kwamen, alle man, wiens hart hem bewoog, en een ieder, wiens geest hem vrijwillig maakte, die brachten des HEEREN hefoffer tot het werk van de tent der samenkomst, en tot al haar dienst, en tot de heilige klederen. ");
INSERT INTO nld_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Zo kwamen dan de mannen met de vrouwen, alle vrijwilligen van hart; zij brachten haken, en oorsierselen, en ringen, en spanselen, alle gouden vaten; en alle man, die een gouden beweegoffer den HEERE offerde, ");
INSERT INTO nld_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","En alle man, bij wien gevonden werd hemelsblauw, en purper, en scharlaken, en fijn linnen, en geiten haar, en roodgeverfde ramsvellen, en dassenvellen, die brachten ze. ");
INSERT INTO nld_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Allen, die een hefoffer van zilver of koper offerden, die brachten het ten hefoffer des HEEREN; en allen, bij welke sittimhout gevonden werd, brachten het tot alle werk van den dienst. ");
INSERT INTO nld_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","En alle vrouwen, die wijs van hart waren, sponnen met haar handen, en zij brachten het gesponnene, de hemelsblauwe zijde, en het purper, het scharlaken, en het fijn linnen. ");
INSERT INTO nld_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","En alle vrouwen, welker hart haar bewoog in wijsheid, die sponnen het geiten haar. ");
INSERT INTO nld_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","De oversten nu brachten sardonixstenen en vulstenen, tot den efod en tot den borstlap; ");
INSERT INTO nld_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","En specerijen en olie, tot den luchter en tot de zalfolie, en tot roking welriekende specerijen. ");
INSERT INTO nld_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Alle man en vrouw, welker hart hen vrijwillig bewoog te brengen tot al het werk, hetwelk de HEERE geboden had te maken door de hand van Mozes; dat brachten de kinderen Israels tot een vrijwillig offer den HEERE. ");
INSERT INTO nld_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Daarna zeide Mozes tot de kinderen Israels: Ziet, de HEERE heeft met name geroepen Bezaleel, den zoon van Uri, den zoon van Hur, van den stam van Juda. ");
INSERT INTO nld_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","En de Geest Gods heeft hem vervuld met wijsheid, met verstand, en met wetenschap, namelijk in alle handwerk; ");
INSERT INTO nld_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","En om te bedenken vernuftigen arbeid, te werken in goud, en in zilver, en in koper, ");
INSERT INTO nld_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","En in kunstige steensnijding, om in te zetten, en in kunstige houtsnijding; om te werken in alle vernuftige handwerk. ");
INSERT INTO nld_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hij heeft hem ook in zijn hart gegeven anderen te onderwijzen, hem en Aholiab, den zoon van Ahisamach, van den stam van Dan. ");
INSERT INTO nld_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Hij heeft hen vervuld met wijsheid des harten, om te maken alle werk eens werkmeesters, en des allervernuftigsten handwerkers, en des borduurders en hemelsblauw, en in purper, in scharlaken, en in fijn linnen, en des wevers; makende alle werk, en bedenkende vernuftigen arbeid. ");
INSERT INTO nld_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Toen wrocht Bezaleel en Aholiab, en alle man, die wijs van hart was, in denwelken de HEERE wijsheid en verstand gegeven had, om te weten, hoe zij maken zouden alle werk ten dienste des heiligdoms naar alles, dat de HEERE geboden had. ");
INSERT INTO nld_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Want Mozes had geroepen Bezaleel en Aholiab, en alle man, die wijs van hart was, in wiens hart God wijsheid gegeven had, al wiens hart hem bewogen had, dat hij toetrad tot het werk, om dat te maken. ");
INSERT INTO nld_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Zij dan namen van voor het aangezicht van Mozes het ganse hefoffer, hetwelk de kinderen Israels gebracht hadden, tot het werk van den dienst des heiligdoms, om dat te maken; doch zij brachten tot hem nog allen morgen vrijwillig offer. ");
INSERT INTO nld_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Derhalve kwamen alle wijzen, die al het werk des heiligdoms maakten, ieder man van zijn werk, hetwelk zij maakten; ");
INSERT INTO nld_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","En zij spraken tot Mozes, zeggende: Het volk brengt te veel, meer dan genoeg is ten dienste des werks, hetwelk de HEERE te maken geboden heeft. ");
INSERT INTO nld_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Toen gebood Mozes, dat men een stem zoude laten gaan door het leger, zeggende: Man noch vrouw make geen werk meer ten hefoffer des heiligdoms! Alzo werd het volk teruggehouden van meer te brengen. ");
INSERT INTO nld_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Want der stoffe was denzelven genoeg tot het gehele werk, dat te maken was; ja, er was over. ");
INSERT INTO nld_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Alzo maakte een ieder wijze van hart, onder degenen, die het werk maakten, den tabernakel van tien gordijnen, van getweernd fijn linnen, en hemelsblauw, en purper, en scharlaken met cherubim; van het allerkunstelijkste werk maakte hij ze. ");
INSERT INTO nld_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","De lengte ener gordijn was van acht en twintig ellen, en de breedte ener gordijn van vier ellen; al deze gordijnen hadden een maat. ");
INSERT INTO nld_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","En hij voegde vijf gordijnen, de ene aan de andere; en hij voegde andere vijf gordijnen, de ene aan de andere. ");
INSERT INTO nld_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Daarna maakte hij striklisjes van hemelsblauw aan den kant ener gordijn, aan het uiterste in de samenvoeging; hij deed het ook aan den uitersten kant der tweede samenvoegende gordijn. ");
INSERT INTO nld_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Vijftig striklisjes maakte hij aan de ene gordijn, en vijftig striklisjes maakte hij aan het uiterste der gordijn; dat aan de tweede samenvoegende was; deze striklisjes vatten de ene aan de andere. ");
INSERT INTO nld_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hij maakte ook vijftig gouden haakjes, en voegde de gordijnen samen, de ene aan de andere, met deze haakjes, dat het een tabernakel werd. ");
INSERT INTO nld_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Verder maakte hij gordijnen van geiten haar, tot een tent over den tabernakel; van elf gordijnen maakte hij ze. ");
INSERT INTO nld_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","De lengte ener gordijn was dertig ellen, en vier ellen de breedte ener gordijn; deze elf gordijnen hadden een maat. ");
INSERT INTO nld_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","En hij voegde vijf gordijnen samen bijzonder; wederom zes dezer gordijnen bijzonder. ");
INSERT INTO nld_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","En hij maakte vijftig striklisjes aan den kant van de gordijn, de uiterste in de samenvoeging; hij maakte ook vijftig striklisjes aan den kant van de gordijn der andere samenvoeging. ");
INSERT INTO nld_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hij maakte ook vijftig koperen haakjes, om de tent samen te voegen, dat zij een ware. ");
INSERT INTO nld_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ook maakte hij voor de tent een deksel van roodgeverfde ramsvellen, en daarover een deksel van dassenvellen. ");
INSERT INTO nld_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Hij maakte ook aan den tabernakel berderen van staand sittimhout. ");
INSERT INTO nld_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","De lengte van een berd was tien ellen, en ene el en ene halve el was de breedte van elk berd. ");
INSERT INTO nld_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Twee houvasten had een berd, als sporten in een ladder gezet, het ene nevens het andere; alzo maakte hij het met al de berderen des tabernakels. ");
INSERT INTO nld_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Hij maakte ook de berderen tot den tabernakel; twintig berderen naar de zuidzijde zuidwaarts. ");
INSERT INTO nld_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","En hij maakte veertig zilveren voeten onder de twintig berderen; twee voeten onder een berd, aan zijn twee houvasten, en twee voeten onder een ander berd, aan zijn twee houvasten. ");
INSERT INTO nld_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Hij maakte ook twintig berderen aan de andere zijde des tabernakels, aan den noorderhoek. ");
INSERT INTO nld_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Met hun veertig zilveren voeten; twee voeten onder een berd, en twee voeten onder een ander berd. ");
INSERT INTO nld_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Doch aan de zijde des tabernakels tegen het westen, maakte hij zes berderen. ");
INSERT INTO nld_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ook maakte hij twee berderen tot hoekberderen des tabernakels, aan de beide zijden. ");
INSERT INTO nld_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","En zij waren van beneden als tweelingen samengevoegd, zij waren ook als tweelingen aan deszelfs oppereinde samengevoegd met een ring; alzo deed hij met die beide, aan de twee hoeken. ");
INSERT INTO nld_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Alzo waren er acht berderen met hun zilveren voeten, zijnde zestien voeten: twee voeten onder elk berd. ");
INSERT INTO nld_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Hij maakte ook richelen van sittimhout; vijf aan de berderen der ene zijde des tabernakels; ");
INSERT INTO nld_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","En vijf richelen aan de berderen van de andere zijde des tabernakels; alsook vijf richelen aan de berderen des tabernakels, aan de beide zijden westwaarts. ");
INSERT INTO nld_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","En hij maakte de middelste richel doorschietende in het midden der berderen, van het ene einde tot het andere einde. ");
INSERT INTO nld_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","En hij overtrok de berderen met goud, en hun ringen (de plaatsen voor de richelen) maakte hij van goud; de richelen overtrok hij ook met goud. ");
INSERT INTO nld_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Daarna maakte hij een voorhang van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen; van het allerkunstelijkste werk maakte hij denzelven, met cherubim. ");
INSERT INTO nld_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","En hij maakte daartoe vier pilaren van sittim hout, die hij overtrok met goud; hun haken waren van goud, en hij goot hun vier zilveren voeten. ");
INSERT INTO nld_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hij maakte ook aan de deur der tent een deksel van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen, geborduurd werk; ");
INSERT INTO nld_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","En de vijf pilaren daarvan, en hun haken; en hij overtrok hun hoofden en derzelver banden met goud; en hun vijf voeten waren van koper. ");
INSERT INTO nld_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Alzo maakte Bezaleel de ark van sittimhout; twee ellen en een halve was haar lengte, en anderhalve el haar breedte, en anderhalve el haar hoogte. ");
INSERT INTO nld_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","En hij overtrok ze met louter goud, van binnen en van buiten; en hij maakte ze een gouden krans rondom. ");
INSERT INTO nld_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","En hij goot voor dezelve vier gouden ringen, aan haar vier hoeken, alzo dat twee ringen op derzelver ene zijde waren, en twee ringen op haar andere zijde. ");
INSERT INTO nld_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","En hij maakte handbomen van sittimhout, en hij overtrok ze met goud. ");
INSERT INTO nld_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","En hij stak de handbomen in de ringen, aan de zijden der ark, om de ark te dragen. ");
INSERT INTO nld_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hij maakte ook een verzoendeksel van louter goud; twee ellen en een halve was deszelfs lengte, en anderhalve el deszelfs breedte. ");
INSERT INTO nld_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ook maakte hij twee cherubim van goud; van dicht werk maakte hij ze, uit de beide einden des verzoendeksels. ");
INSERT INTO nld_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Een cherub uit het ene einde aan deze zijde, en den anderen cherub uit het andere einde aan gene zijde; uit het verzoendeksel maakte hij de cherubim, uit deszelfs beide einden. ");
INSERT INTO nld_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","En de cherubim waren de beide vleugelen omhoog uitbreidende, bedekkende met hun vleugelen het verzoendeksel; en hun aangezichten waren tegenover elkander; de aangezichten der cherubim waren naar het verzoendeksel. ");
INSERT INTO nld_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Hij maakte ook een tafel van sittimhout; twee ellen was haar lengte, en een el haar breedte; en een el en een halve haar hoogte. ");
INSERT INTO nld_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","En hij overtrok ze met louter goud; en hij maakte een gouden krans daaraan, rondom. ");
INSERT INTO nld_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hij maakte daaraan ook een lijst rondom, een hand breed; en hij maakte een gouden krans rondom derzelver lijst. ");
INSERT INTO nld_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Hij goot ook vier gouden ringen daaraan; en hij zette de ringen aan de vier hoeken, die aan derzelver vier voeten waren. ");
INSERT INTO nld_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Tegenover de lijst waren de ringen tot plaatsen voor de handbomen, om de tafel te dragen. ");
INSERT INTO nld_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Hij maakte ook de handbomen van sittimhout; en hij overtrok ze met goud, om de tafel te dragen. ");
INSERT INTO nld_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","En hij maakte het gereedschap, dat op de tafel zijn zoude, haar schotelen, en haar reukschalen, en haar kroezen, en haar platelen (met welke zij bedekt zoude worden), van louter goud. ");
INSERT INTO nld_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hij maakte ook een kandelaar van louter goud. Van dicht werk maakte hij dezen kandelaar, zijn schacht, en zijn rieten; zijn schaaltjes, zijn knopen, en zijn bloemen waren uit hem. ");
INSERT INTO nld_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Zes rieten nu gingen uit zijn zijden; drie rieten des kandelaars uit zijn ene zijde, en drie rieten des kandelaars uit zijn andere zijde. ");
INSERT INTO nld_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","In het ene riet waren drie schaaltjes, gelijk amandelnoten, een knoop en een bloem; en drie schaaltjes, gelijk amandelnoten in een ander riet, een knoop en een bloem; alzo waren die zes rieten, die uit den kandelaar gingen. ");
INSERT INTO nld_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Maar aan den kandelaar zelven waren vier schaaltjes, gelijk amandelnoten, met zijn knopen, en met zijn bloemen. ");
INSERT INTO nld_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","En daar was een knoop onder twee rieten, uit denzelven uitgaande; ook een knoop onder twee rieten, uit denzelven uitgaande; nog een knoop onder twee rieten, uit denzelven uitgaande; alzo was het met de zes rieten, die uit denzelven uitgingen. ");
INSERT INTO nld_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Hun knopen en rieten waren uit hem; het was altemaal een enig dicht werk van louter goud. ");
INSERT INTO nld_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","En hij maakte hem zeven lampen; zijn snuiters en zijn blusvaten waren van louter goud. ");
INSERT INTO nld_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hij maakte denzelven uit een talent louter goud, met al zijn vaten. ");
INSERT INTO nld_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","En hij maakte het reukaltaar van sittimhout; een el was zijn lengte en een el zijn breedte, vierkant, maar twee ellen zijn hoogte; uit hetzelve waren zijn hoornen. ");
INSERT INTO nld_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","En hij overtrok het met louter goud, zijn dak, en zijn wanden rondom, alsook zijn hoornen; en hij maakte het een gouden krans rondom. ");
INSERT INTO nld_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Hij maakte ook twee gouden ringen daaraan, onder zijn krans, aan zijn twee hoeken, aan zijn beide zijden, tot plaatsen voor de handbomen, dat men het daarmede droeg. ");
INSERT INTO nld_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","En hij maakte de handbomen van sittimhout, en hij overtrok ze met goud. ");
INSERT INTO nld_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hij maakte ook de heilige zalfolie, en het reukwerk der zuiverste welriekende specerijen, naar apothekerswerk. ");
INSERT INTO nld_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Hij maakte ook het brandofferaltaar van sittimhout; vijf ellen was deszelfs lengte, en vijf ellen zijn breedte, vierkant, en drie ellen zijn hoogte. ");
INSERT INTO nld_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","En hij maakte deszelfs hoornen op zijn vier hoeken; uit hetzelve waren zijn hoornen; en hij overtrok het met koper. ");
INSERT INTO nld_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hij maakte ook al het gereedschap des altaars, de potten, en de schoffelen, en de besprengbekkens, en de krauwelen, en de koolpannen; al zijn vaten maakte hij van koper. ");
INSERT INTO nld_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ook maakte hij aan het altaar een rooster van koperen netwerk, onder zijn omloop, van beneden tot zijn midden toe. ");
INSERT INTO nld_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","En hij goot vier ringen aan de vier einden des koperen roosters, tot plaatsen voor de handbomen. ");
INSERT INTO nld_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","En hij maakte de handbomen van sittimhout, en hij overtrok ze met koper. ");
INSERT INTO nld_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","En hij deed de handbomen in de ringen, aan de zijden des altaars, dat men het met dezelve droeg; hij maakte hetzelve hol van planken. ");
INSERT INTO nld_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hij maakte ook het koperen wasvat, met zijn koperen voet, van de spiegels der te hoop komende vrouwen, die te hoop kwamen voor de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hij maakte ook den voorhof, aan den zuidhoek zuidwaarts; de behangselen tot den voorhof waren van fijn getweernd linnen, van honderd ellen. ");
INSERT INTO nld_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Hun twintig pilaren en derzelver twintig voeten, waren van koper; de haken dezer pilaren en hun banden waren van zilver. ");
INSERT INTO nld_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","En aan den noorderhoek honderd ellen, hun twintig pilaren en derzelver twintig voeten waren van koper; de haken der pilaren en derzelver banden waren van zilver. ");
INSERT INTO nld_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","En aan den westerhoek waren behangselen van vijftig ellen, hun pilaren tien en derzelver voeten tien; de haken der pilaren en hun banden waren van zilver. ");
INSERT INTO nld_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","En aan den oosterhoek tegen den opgang waren vijftig ellen. ");
INSERT INTO nld_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","De behangselen aan deze zijde waren vijftien ellen, derzelver pilaren drie en hun voeten drie. ");
INSERT INTO nld_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","En aan de andere zijde van de deur des voorhofs, van hier en van daar, waren behangselen van vijftien ellen; hun pilaren drie en derzelver voeten drie. ");
INSERT INTO nld_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Al de behangselen des voorhofs waren rondom van fijn getweernd linnen. ");
INSERT INTO nld_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","De voeten nu der pilaren waren van koper, de haken der pilaren, en hun banden waren van zilver, en het overdeksel hunner hoofden was van zilver, en al de pilaren des voorhofs waren met zilver omtogen. ");
INSERT INTO nld_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","En het deksel van de poort des voorhofs was van geborduurd werk, van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen; en twintig ellen was de lengte, en de hoogte in de breedte was vijf ellen, tegenover de behangselen des voorhofs. ");
INSERT INTO nld_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","En hun vier pilaren en derzelver vier voeten waren van koper, hun haken waren van zilver; ook was het overdeksel hunner hoofden en hun banden van zilver. ");
INSERT INTO nld_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","En al de pennen des tabernakels en des voorhofs rondom waren van koper. ");
INSERT INTO nld_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Dit zijn de getelde dingen van den tabernakel, van den tabernakel der getuigenis, die geteld zijn naar den mond van Mozes, ten dienste der Levieten, door de hand van Ithamar, den zoon van den priester Aaron. ");
INSERT INTO nld_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel nu, de zoon van Uri, den zoon van Hur, van den stam van Juda, maakte al, dat de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","En met hem Aholiab, de zoon van Ahisamach, van den stam van Dan, een werkmeester en vernuftig kunstenaar, en een borduurder in hemelsblauw, en in purper, en in scharlaken, en in fijn linnen. ");
INSERT INTO nld_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Al het goud, dat tot het werk verarbeid is, in het ganse werk des heiligdoms, te weten, het goud des beweegoffers, was negen en twintig talenten, en zevenhonderd en dertig sikkelen, naar den sikkel des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Het zilver nu van de getelden der vergadering was honderd talenten, en duizend zevenhonderd vijf en zeventig sikkelen, naar den sikkel des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Een beka voor elk hoofd, dat is een halve sikkel, naar den sikkel des heiligdoms, van een ieder, die overging tot de getelden, van twintig jaren oud en daarboven, namelijk zeshonderd drie duizend, vijfhonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","En er waren honderd talenten zilver, om te gieten de voeten des heiligdoms, en de voeten des voorhangs; tot honderd voeten waren honderd talenten, een talent tot een voet. ");
INSERT INTO nld_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Maar uit de duizend zevenhonderd vijf en zeventig sikkelen maakte hij de haken aan de pilaren, en hij overtrok hun hoofden, en omtoog ze met banden. ");
INSERT INTO nld_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Het koper nu des beweegoffers was zeventig talenten, en twee duizend vierhonderd sikkelen. ");
INSERT INTO nld_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","En hij maakte daarvan de voeten der deur van de tent der samenkomst, en het koperen altaar, en den koperen rooster, dien het had, en al het gereedschap des altaars. ");
INSERT INTO nld_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","En de voeten des voorhofs rondom, en de voeten van de poort des voorhofs, ook al de pennen des tabernakels, en al de pennen des voorhofs rondom. ");
INSERT INTO nld_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Zij maakten ook ambtsklederen, om in het heilige te dienen, van hemelsblauw, en purper, en scharlaken; ook maakten zij de heilige klederen, die voor Aaron waren, gelijk de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Aldus maakte hij den efod, van goud, hemelsblauw en purper, en scharlaken, en fijn getweernd linnen. ");
INSERT INTO nld_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","En zij rekten uit de dunne platen van goud, en sneden het tot draden, om te doen in het midden van het hemelsblauw, en in het midden van het purper, en in het midden van het scharlaken, en in het midden van het fijn linnen, van het allerkunstelijkste werk. ");
INSERT INTO nld_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Zij maakten samenvoegende schouderbanden daaraan; aan deszelfs beide einden werd hij samengevoegd. ");
INSERT INTO nld_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","En de kunstelijke riem zijns efods, die daarop was, was gelijk zijn werk, van hetzelfde, van goud, van hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen, gelijk als de HEERE aan Mozes bevolen had. ");
INSERT INTO nld_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Zij bereidden ook de sardonixstenen, omvat in gouden kastjes, als zegelgravering gegraveerd, met de namen der zonen van Israel. ");
INSERT INTO nld_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","En hij zette ze op de schouderbanden des efods, tot stenen der gedachtenis voor de kinderen Israels, gelijk de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Hij maakte ook den borstlap van het allerkunstelijkste werk, gelijk het werk des efods, van goud, hemelsblauw, en purper, en scharlaken, en fijn getweernd linnen. ");
INSERT INTO nld_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Hij was vierkant; zij maakten den borstlap dubbel; een span was zijn lengte, en een span was zijn breedte, dubbel zijnde. ");
INSERT INTO nld_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","En zij vulden daarin vier rijen stenen: een rij van een Sardis, een Topaas en een Karbonkel; dit is de eerste rij. ");
INSERT INTO nld_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","En de tweede rij van een Smaragd, een Saffier en een Diamant. ");
INSERT INTO nld_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","En de derde rij van een Hyacint, Agaat, en Amethist. ");
INSERT INTO nld_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","En de vierde rij van een Turkoois, en een Sardonix, en een Jaspis; omvat in gouden kastjes in hun vullingen. ");
INSERT INTO nld_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Deze stenen nu, met de namen der zonen van Israel, waren twaalf, met hun namen, met zegelgravering; ieder met zijn naam, naar de twaalf stammen. ");
INSERT INTO nld_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Zij maakten ook aan den borstlap gelijk-eindigende ketentjes, van gedraaid werk, uit louter goud. ");
INSERT INTO nld_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","En zij maakten twee gouden kastjes, en twee gouden ringen; en zij zetten die twee ringen aan de beide einden des borstlaps. ");
INSERT INTO nld_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","En zij zetten de twee gedraaide gouden ketentjes aan de twee ringen, aan de einden van den borstlap. ");
INSERT INTO nld_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Doch de twee andere einden der twee gedraaide ketenen zetten zij aan de twee kastjes, en zij zetten ze aan de schouderbanden des efods, recht op de voorste zijde van dien. ");
INSERT INTO nld_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Zij maakten ook twee gouden ringen, die zij aan de twee andere einden des borstlaps zetten, inwendig aan zijn boord, die aan de zijde des efods is. ");
INSERT INTO nld_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nog maakten zij twee gouden ringen, die zij zetten aan de twee schouderbanden van den efod, beneden, aan deszelfs voorste zijde, tegenover zijn andere voege, boven den kunstelijken riem des efods. ");
INSERT INTO nld_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","En zij bonden den borstlap met zijn ringen aan de ringen van den efod, met een hemelsblauw snoer, dat hij op den kunstelijken riem van den efod was; opdat de borstlap van den efod niet afgescheiden wierd, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","En hij maakte den mantel des efods van geweven werk, geheel van hemelsblauw. ");
INSERT INTO nld_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","En het gat des mantels was in deszelfs midden, als het gat eens pantsiers; dit gat had een boord rondom, dat het niet gescheurd wierd. ");
INSERT INTO nld_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","En aan de zomen des mantels maakten zij granaatappelen van hemelsblauw, en purper, en scharlaken, getweernd. ");
INSERT INTO nld_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Zij maakten ook schelletjes van louter goud, en zij stelden de schelletjes tussen de granaatappelen, aan de zomen des mantels rondom, tussen de granaatappelen; ");
INSERT INTO nld_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Dat er een schelletje, daarna een granaatappel was; wederom een schelletje, en een granaatappel; aan de zomen des mantels rondom; om te dienen, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Zij maakten ook de rokken van fijn linnen, van geweven werk, voor Aaron en voor zijn zonen; ");
INSERT INTO nld_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","En den hoed van fijn linnen, en de sierlijke mutsen van fijn linnen, en de linnen onderbroeken van fijn getweernd linnen; ");
INSERT INTO nld_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","En den gordel van fijn getweernd linnen, en van hemelsblauw, en purper, en scharlaken, van geborduurd werk, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Zij maakten ook de plaat van de kroon der heiligheid van louter goud, en zij schreven daarop een schrift, met zegelgravering: De HEILIGHEID DES HEEREN. ");
INSERT INTO nld_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","En zij hechtten een snoer van hemelsblauw daaraan, om aan den hoed van boven te hechten, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Aldus werd al het werk des tabernakels, van de tent der samenkomst voleind; en de kinderen Israels hadden het gemaakt naar alles, wat de HEERE aan Mozes geboden had; alzo hadden zij het gemaakt. ");
INSERT INTO nld_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Daarna brachten zij den tabernakel tot Mozes, de tent, en al haar gereedschap, haar haakjes, haar berderen, haar richelen, en haar pilaren, en haar voeten; ");
INSERT INTO nld_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","En het deksel van roodgeverfde ramsvellen, en het deksel van dassenvellen, en den voorhang van het deksel; ");
INSERT INTO nld_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","De ark der getuigenis, en haar handbomen, en het verzoendeksel; ");
INSERT INTO nld_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","De tafel, met al haar gereedschap, en de toonbroden; ");
INSERT INTO nld_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Den louteren kandelaar met zijn lampen, de lampen, die men toerichten moest, en al deszelfs gereedschap, en de olie tot het licht; ");
INSERT INTO nld_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Verder het gouden altaar, en de zalfolie, en het reukwerk van welriekende specerijen, en het deksel van de deur der tent. ");
INSERT INTO nld_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Het koperen altaar, en den koperen rooster, dien het heeft, deszelfs handbomen, en al zijn gereedschap; het wasvat en zijn voet; ");
INSERT INTO nld_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","De behangselen des voorhofs, zijn pilaren en zijn voeten, en het deksel van de poort des voorhofs, zijn zelen, en zijn pennen, en al het gereedschap van den dienst des tabernakels, tot de tent der samenkomst; ");
INSERT INTO nld_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","De ambtsklederen, om in het heiligdom te dienen, de heilige klederen van den priester Aaron, en de klederen van zijn zonen, om het priesterambt te bedienen. ");
INSERT INTO nld_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Naar alles, wat de HEERE aan Mozes geboden had, alzo hadden de kinderen Israels het ganse werk gemaakt. ");
INSERT INTO nld_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mozes nu bezag het ganse werk, en ziet, zij hadden het gemaakt, gelijk als de HEERE geboden had; alzo hadden zij het gemaakt. Toen zegende Mozes hen. ");
INSERT INTO nld_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Op den dag der eerste maand, te weten op den eersten der maand, zult gij den tabernakel, de tent der samenkomst, oprichten. ");
INSERT INTO nld_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","En gij zult aldaar zetten de ark der getuigenis; en gij zult de ark met den voorhang bedekken. ");
INSERT INTO nld_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Daarna zult gij de tafel daarin brengen, en gij zult schikken wat daarop te schikken is; gij zult ook den kandelaar daarin brengen, en zijn lampen aansteken. ");
INSERT INTO nld_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","En gij zult het gouden altaar ten reukwerk voor de ark der getuigenis zetten; dan zult gij het deksel van de deur des tabernakels ophangen. ");
INSERT INTO nld_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Gij zult ook het altaar des brandoffers zetten voor de deur van den tabernakel, van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","En gij zult het wasvat zetten tussen de tent der samenkomst, en tussen het altaar; en gij zult water daar in doen. ");
INSERT INTO nld_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Daarna zult gij den voorhof rondom zetten, en gij zult het deksel ophangen aan de poort des voorhofs. ");
INSERT INTO nld_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Dan zult gij de zalfolie nemen en zalven den tabernakel, en al wat daarin is; en gij zult dezelven heiligen, met al zijn gereedschap, en het zal een heiligheid zijn. ");
INSERT INTO nld_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Gij zult ook het altaar des brandoffers zalven, en al zijn gereedschap; en gij zult het altaar heiligen, en het altaar zal heiligheid der heiligheden zijn. ");
INSERT INTO nld_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Dan zult gij het wasvat zalven, en deszelfs voet; en gij zult het heiligen. ");
INSERT INTO nld_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Gij zult ook Aaron en zijn zonen doen naderen, tot de deur van de tent der samenkomst; en gij zult hen met water wassen. ");
INSERT INTO nld_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","En gij zult Aaron de heilige klederen aantrekken; en gij zult hem zalven, en hem heiligen, dat hij Mij het priesterambt bediene. ");
INSERT INTO nld_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Gij zult ook zijn zonen doen naderen, en zult hun de rokken aantrekken. ");
INSERT INTO nld_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","En gij zult hen zalven, gelijk als gij hun vader zult gezalfd hebben, dat zij Mij het priesterambt bedienen. En het zal geschieden, dat hun hun zalving zal zijn tot een eeuwig priesterdom bij hun geslachten. ");
INSERT INTO nld_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mozes nu deed het naar alles, wat hem de HEERE geboden had; alzo deed hij. ");
INSERT INTO nld_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","En het geschiedde in de eerste maand, in het tweede jaar, op den eersten der maand, dat de tabernakel opgericht werd. ");
INSERT INTO nld_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Want Mozes richtte den tabernakel op, en zette zijn voeten, en stelde zijn berderen, en zette zijn richelen daaraan, en hij richtte deszelfs pilaren op. ");
INSERT INTO nld_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","En hij spreidde de tent uit over den tabernakel, en hij zette het deksel der tent daar bovenop, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Voorts nam hij, en leide de getuigenis in de ark, en deed de handbomen aan de ark, en hij zette het verzoendeksel boven op de ark. ");
INSERT INTO nld_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","En hij bracht de ark in den tabernakel, en hij hing den voorhang van het deksel op, en bedekte de ark der getuigenis, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Hij zette ook de tafel in de tent der samenkomst, aan de zijde des tabernakels tegen het noorden, buiten den voorhang. ");
INSERT INTO nld_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","En hij schikte daarop het brood in orde, voor het aangezicht des HEEREN, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hij zette ook den kandelaar in de tent der samenkomst, recht over de tafel, aan de zijde des tabernakels, zuidwaarts. ");
INSERT INTO nld_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","En hij stak de lampen aan voor het aangezicht des HEEREN, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","En hij zette het gouden altaar in de tent der samenkomst, voor den voorhang. ");
INSERT INTO nld_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","En hij stak daarop aan reukwerk van welriekende specerijen, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hij hing ook het deksel van de deur des tabernakels. ");
INSERT INTO nld_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","En hij zette het altaar des brandoffers aan de deur des tabernakels, van de tent der samenkomst; en hij offerde daarop brandoffer, en spijsoffer, gelijk de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Hij zette ook het wasvat tussen de tent der samenkomst, en tussen het altaar; en hij deed water daarin om te wassen. ");
INSERT INTO nld_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","En Mozes en Aaron, en zijn zonen wiesen daaruit hun handen en hun voeten. ");
INSERT INTO nld_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Als zij ingingen tot de tent der samenkomst, en als zij tot het altaar naderden, zo wiesen zij zich, gelijk als de HEERE aan Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Hij richtte ook den voorhof op, rondom den tabernakel en het altaar, en hij hing het deksel van de poort des voorhofs op. Alzo voleindigde Mozes het werk. ");
INSERT INTO nld_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Toen bedekte de wolk de tent der samenkomst; en de heerlijkheid des HEEREN vervulde den tabernakel. ");
INSERT INTO nld_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Zodat Mozes niet kon ingaan in de tent der samenkomst, dewijl de wolk daarop bleef, en de heerlijkheid des HEEREN den tabernakel vervulde. ");
INSERT INTO nld_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Als nu de wolk opgeheven werd van boven den tabernakel, zo reisden de kinderen Israels voort in al hun reizen. ");
INSERT INTO nld_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Maar als de wolk niet opgeheven werd, zo reisden zij niet tot op den dag, dat zij opgeheven werd. ");
INSERT INTO nld_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Want de wolk des HEEREN was op den tabernakel bij dag, en het vuur was er bij nacht op, voor de ogen van het ganse huis Israels in al hun reizen. ");
INSERT INTO nld_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","En de HEERE riep Mozes, en sprak tot hem uit de tent der samenkomst, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Spreek tot de kinderen Israels, en zeg tot hen: Als een mens uit u den HEERE een offerande zal offeren, gij zult uw offeranden offeren van het vee, van runderen en van schapen. ");
INSERT INTO nld_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Indien zijn offerande een brandoffer van runderen is, zo zal hij een volkomen mannetje offeren; aan de deur van de tent der samenkomst zal hij dat offeren, naar zijn welgevallen, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","En hij zal zijn hand op het hoofd des brandoffers leggen, opdat het voor hem aangenaam zij, om hem te verzoenen. ");
INSERT INTO nld_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Daarna zal hij het jonge rund slachten voor het aangezicht des HEEREN; en de zonen van Aaron, de priesters, zullen het bloed offeren, en het bloed sprengen rondom dat altaar, hetwelk voor de deur van de tent der samenkomst is. ");
INSERT INTO nld_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Dan zal hij het brandoffer de huid aftrekken, en het in zijn stukken delen. ");
INSERT INTO nld_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","En de zonen van Aaron, den priester, zullen vuur maken op het altaar, en zullen het hout op het vuur schikken. ");
INSERT INTO nld_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ook zullen de zonen van Aaron, de priesters, de stukken, het hoofd en het smeer, schikken op het hout, dat op het vuur is, hetwelk op het altaar is. ");
INSERT INTO nld_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Doch zijn ingewand, en zijn schenkelen zal men met water wassen; en de priester zal dat alles aansteken op het altaar; het is een brandoffer, een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","En indien zijn offerande is van klein vee, van schapen of van geiten, ten brandoffer, zal hij een volkomen mannetje offeren. ");
INSERT INTO nld_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","En hij zal dat slachten aan de zijde van het altaar noordwaarts, voor het aangezicht des HEEREN; en de zonen van Aaron, de priesters, zullen zijn bloed rondom op het altaar sprengen. ");
INSERT INTO nld_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Daarna zal hij het in zijn stukken delen, mitsgaders zijn hoofd en zijn smeer; en de priester zal die schikken op het hout, dat op het vuur is, hetwelk op het altaar is. ");
INSERT INTO nld_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Doch het ingewand en de schenkelen zal men met water wassen; en de priester zal dat alles offeren en aansteken op het altaar; het is een brandoffer, een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","En indien zijn offerande voor den HEERE een brandoffer van gevogelte is, zo zal hij zijn offerande van tortelduiven, of van jonge duiven, offeren. ");
INSERT INTO nld_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","En de priester zal die tot het altaar brengen, en deszelfs hoofd met zijn nagel splijten, en op het altaar aansteken; en zijn bloed zal aan den wand des altaars uitgeduwd worden. ");
INSERT INTO nld_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","En zijn krop met zijn vederen zal hij wegdoen, en zal het werpen bij het altaar, oostwaarts, aan de plaats der as. ");
INSERT INTO nld_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Verder zal hij die met zijn vleugelen klieven, niet afscheiden; en de priester zal die aansteken op het altaar, op het hout, dat op het vuur is; het is een brandoffer, een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Als nu een ziel een offerande van spijsoffer den HEERE zal offeren, zijn offerande zal van meelbloem zijn; en hij zal olie daarop gieten, en wierook daarop leggen. ");
INSERT INTO nld_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","En hij zal het brengen tot de zonen van Aaron, de priesters, een van welke daarvan zijn hand vol grijpen zal uit deszelfs meelbloem, en uit deszelfs olie, met al deszelfs wierook; en de priester zal deszelfs gedenkoffer aansteken op het altaar; het is een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Wat nu overblijft van het spijsoffer, zal voor Aaron en zijn zonen zijn; het is een heiligheid der heiligheden van de vuurofferen des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","En als gij offeren zult een offerande van spijsoffer, een gebak des ovens; het zullen zijn ongezuurde koeken van meelbloem, met olie gemengd, en ongezuurde vladen, met olie bestreken. ");
INSERT INTO nld_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","En indien uw offerande spijsoffer is, in de pan gekookt, zij zal zijn van ongezuurde meelbloem, met olie gemengd. ");
INSERT INTO nld_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Breekt ze in stukken, en giet olie daarop; het is een spijsoffer. ");
INSERT INTO nld_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","En zo uw offerande een spijsoffer des ketels is, het zal van meelbloem met olie gemaakt worden. ");
INSERT INTO nld_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Dan zult gij dat spijsoffer, hetwelk daarvan zal gemaakt worden, den HEERE toebrengen; en men zal het tot den priester doen naderen, die het tot het altaar dragen zal. ");
INSERT INTO nld_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","En de priester zal van dat spijsoffer deszelfs gedenkoffer opnemen, en op het altaar aansteken, het is een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","En wat overblijft van het spijsoffer, zal voor Aaron en zijn zonen zijn; het is een heiligheid der heiligheden van de vuurofferen des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Geen spijsoffer, dat gij den HEERE zult offeren, zal met desem gemaakt worden; want van geen zuurdesem, en van geen honig zult gijlieden den HEERE vuuroffer aansteken. ");
INSERT INTO nld_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","De offeranden der eerstelingen zult gij den HEERE offeren; maar op het altaar zullen zij niet komen tot een liefelijken reuk. ");
INSERT INTO nld_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","En alle offerande uws spijsoffers zult gij met zout zouten, en het zout des verbonds van uw God van uw spijsoffer niet laten afblijven; met al uw offerande zult gij zout offeren. ");
INSERT INTO nld_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","En zo gij den HEERE een spijsoffer der eerste vruchten offert, zult gij het spijsoffer uwer eerste vruchten van groene aren, bij het vuur gedord, dat is, het klein gebroken graan van volle groene aren, offeren. ");
INSERT INTO nld_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","En gij zult olie daarop doen, en wierook daarop leggen; het is een spijsoffer. ");
INSERT INTO nld_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Zo zal de priester deszelfs gedenkoffer aansteken van zijn klein gebroken graan en van zijn olie, met al den wierook; het is een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","En indien zijn offerande een dankoffer is; zo hij ze van de runderen offert, hetzij mannetje of wijfje, volkomen zal hij die offeren, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","En hij zal zijn hand op het hoofd zijner offerande leggen, en zal ze slachten voor de deur van de tent der samenkomst; en de zonen van Aaron, de priesters, zullen het bloed rondom op het altaar sprengen. ");
INSERT INTO nld_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Daarna zal hij van dat dankoffer een vuuroffer den HEERE offeren; het vet, dat het ingewand bedekt, en al het vet, hetwelk aan het ingewand is. ");
INSERT INTO nld_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Dan zal hij beide de nieren, en het vet, hetwelk daaraan is, dat aan de weekdarmen is; en het net over de lever, met de nieren, zal hij afnemen. ");
INSERT INTO nld_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","En de zonen van Aaron zullen dat aansteken op het altaar, op het brandoffer, hetwelk op het hout zal zijn, dat op het vuur is; het is een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","En indien zijn offerande van klein vee is, den HEERE tot een dankoffer, hetzij mannetje of wijfje, volkomen zal hij die offeren. ");
INSERT INTO nld_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Indien hij een lam tot zijn offerande offert, zo zal hij het offeren voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","En hij zal zijn hand op het hoofd zijner offerande leggen, en hij zal die slachten voor de tent der samenkomst; en de zonen van Aaron zullen het bloed daarvan sprengen op het altaar rondom. ");
INSERT INTO nld_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Daarna zal hij van dat dankoffer een vuuroffer den HEERE offeren; zijn vet, den gehelen staart, dien hij dicht aan de ruggegraat zal afnemen, en het vet bedekkende het ingewand, en al het vet, dat aan het ingewand is; ");
INSERT INTO nld_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ook beide de nieren, en het vet, dat daaraan is, dat aan de weekdarmen is; en het net over de lever met de nieren, zal hij afnemen. ");
INSERT INTO nld_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","En de priester zal dat aansteken op het altaar; het is een spijs des vuuroffers den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Indien nu zijn offerande een geit is, zo zal hij die offeren voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","En hij zal zijn hand op haar hoofd leggen, en hij zal haar slachten voor de tent der samenkomst; en de zonen van Aaron zullen haar bloed op het altaar sprengen rondom. ");
INSERT INTO nld_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Dan zal hij daarvan zijn offerande offeren, een vuuroffer den HEERE; het vet bedekkende het ingewand, en al het vet, dat aan het ingewand is; ");
INSERT INTO nld_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Mitsgaders de beide nieren, en het vet, dat daaraan is, dat aan de weekdarmen is; en het net over de lever, met de nieren, zal hij afnemen. ");
INSERT INTO nld_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","En de priester zal die aansteken op het altaar; het is een spijs des vuuroffers, tot een liefelijken reuk; alle vet zal des HEEREN zijn. ");
INSERT INTO nld_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Dit zij een eeuwige inzetting voor uw geslachten, in al uw woningen: geen vet noch bloed zult gij eten. ");
INSERT INTO nld_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Spreek tot de kinderen Israels, zeggende: Als een ziel zal gezondigd hebben, door afdwaling van enige geboden des HEEREN, dat niet zou gedaan worden, en tegen een van die zal gedaan hebben; ");
INSERT INTO nld_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Indien de priester, die gezalfd is, zal gezondigd hebben, tot schuld des volks, zo zal hij voor zijn zonde, die hij gezondigd heeft, offeren een var, een volkomen jong rund, den HEERE ten zondoffer. ");
INSERT INTO nld_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","En hij zal dien var brengen tot de deur van de tent der samenkomst, voor het aangezicht des HEEREN; en hij zal zijn hand op het hoofd van dien var leggen, en hij zal dien var slachten voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Daarna zal die gezalfde priester van het bloed van den var nemen, en hij zal dat tot de tent der samenkomst brengen. ");
INSERT INTO nld_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","En de priester zal zijn vinger in dat bloed dopen; en van dat bloed zal hij zevenmaal sprengen voor het aangezicht des HEEREN, voor den voorhang van het heilige. ");
INSERT INTO nld_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ook zal de priester van dat bloed doen op de hoornen des reukaltaars der welriekende specerijen, voor het aangezicht des HEEREN, dat in de tent der samenkomst is; dan zal hij al het bloed van den var uitgieten aan den bodem van het altaar des brandoffers, hetwelk is aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Verder, al het vet van den var des zondoffers zal hij daarvan opnemen; het vet bedekkende het ingewand, en al het vet, dat aan het ingewand is; ");
INSERT INTO nld_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Daartoe de twee nieren, en het vet, dat daaraan is, dat aan de weekdarmen is, en het net over de lever, met de nieren, zal hij afnemen; ");
INSERT INTO nld_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Gelijk als het van den os des dankoffers opgenomen wordt; en de priester zal die aansteken op het altaar des brandoffers. ");
INSERT INTO nld_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Maar de huid van dien var, en al zijn vlees, met zijn hoofd en met zijn schenkelen, en zijn ingewand, en zijn mest; ");
INSERT INTO nld_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","En dien gehelen var zal hij tot buiten het leger uitvoeren, aan een reine plaats, waar men de as uitstort, en zal hem met vuur op het hout verbranden; bij de uitgegoten as zal hij verbrand worden. ");
INSERT INTO nld_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Indien nu de gehele vergadering van Israel afgedwaald zal zijn, en de zaak voor de ogen der gemeente verborgen is, en zij iets gedaan zullen hebben tegen enige van alle geboden des HEEREN, dat niet zoude gedaan worden, en zijn schuldig geworden; ");
INSERT INTO nld_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","En die zonde, die zij daartegen gezondigd zullen hebben, bekend is geworden; zo zal de gemeente een var, een jong rund, ten zondoffer offeren, en dien voor de tent der samenkomst brengen; ");
INSERT INTO nld_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","En de oudsten der vergadering zullen hun handen op het hoofd van den var leggen, voor het aangezicht des HEEREN; en hij zal den var slachten voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Daarna zal die gezalfde priester van het bloed van den var tot de tent der samenkomst brengen. ");
INSERT INTO nld_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","En de priester zal zijn vinger indopen, nemende van dat bloed; en hij zal zevenmaal sprengen voor het aangezicht des HEEREN, voor den voorhang. ");
INSERT INTO nld_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","En van dat bloed zal hij doen op de hoornen van het altaar, dat voor het aangezicht des HEEREN is, dat in de tent der samenkomst is; dan zal hij al het bloed uitgieten, aan den bodem van het altaar des brandoffers, hetwelk is voor de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Daartoe zal hij al zijn vet van hem opnemen, en op het altaar aansteken. ");
INSERT INTO nld_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","En hij zal dezen var doen, gelijk als hij den var des zondoffers gedaan heeft, alzo zal hij hem doen; en de priester zal voor hen verzoening doen, en het zal hun vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Daarna zal hij dien var tot buiten het leger uitvoeren, en zal hem verbranden, gelijk als hij den eersten var verbrand heeft; het is een zondoffer der gemeente. ");
INSERT INTO nld_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Als een overste zal gezondigd hebben, en tegen een van de geboden des HEEREN zijns Gods, door afdwaling, gedaan zal hebben, hetwelk niet zou gedaan worden, zodat hij schuldig is; ");
INSERT INTO nld_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Of men zijn zonde, die hij daartegen gezondigd heeft, aan hem zal bekend gemaakt hebben; zo zal hij tot zijn offer brengen een geitenbok, een volkomen mannetje. ");
INSERT INTO nld_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","En hij zal zijn hand op het hoofd van den bok leggen, en zal hem slachten in de plaats, waar men het brandoffer slacht voor het aangezicht des HEEREN; het is een zondoffer. ");
INSERT INTO nld_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Daarna zal de priester van het bloed des zondoffers met zijn vinger nemen, en dat op de hoornen van het altaar des brandoffers doen; dan zal hij zijn bloed aan den bodem van het altaar des brandoffers uitgieten. ");
INSERT INTO nld_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Hij zal ook al zijn vet op het altaar aansteken, gelijk het vet des dankoffers; zo zal de priester voor hem verzoening doen van zijn zonden, en het zal hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","En zo enig mens van het volk des lands door afdwaling zal gezondigd hebben, dewijl hij iets doet tegen een van de geboden des HEEREN, dat niet gedaan zou worden, zodat hij schuldig is; ");
INSERT INTO nld_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Of men zijn zonde, die hij gezondigd heeft, aan hem zal bekend gemaakt hebben; zo zal hij tot zijn offerande brengen een jonge geit, een volkomen wijfje, voor zijn zonde, die hij gezondigd heeft. ");
INSERT INTO nld_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","En hij zal zijn hand op het hoofd des zondoffers leggen; en men zal dat zondoffer slachten in de plaats des brandoffers. ");
INSERT INTO nld_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Daarna zal de priester van haar bloed met zijn vinger nemen, en doen het op de hoornen van het altaar des brandoffers; dan zal hij al het bloed daarvan aan den bodem van dat altaar uitgieten. ");
INSERT INTO nld_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","En al haar vet zal hij afnemen, gelijk als het vet van het dankoffer afgenomen wordt, en de priester zal het aansteken op het altaar, tot een liefelijken reuk den HEERE; en de priester zal voor hem verzoening doen, en het zal hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Maar zo hij een lam voor zijn offerande ten zondoffer brengt, het zal een volkomen wijfje zijn, dat hij brengt. ");
INSERT INTO nld_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","En hij zal zijn hand op het hoofd des zondoffers leggen, en hij zal dat slachten tot een zondoffer, in de plaats, waar men het brandoffer slacht. ");
INSERT INTO nld_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Daarna zal de priester van het bloed des zondoffers met zijn vinger nemen, en zal het doen op de hoornen van het altaar des brandoffers; dan zal hij al het bloed daarvan aan den bodem van dat altaar uitgieten. ");
INSERT INTO nld_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","En al het vet daarvan zal hij afnemen, gelijk als het vet van het lam des dankoffers afgenomen wordt, en de priester zal die aansteken op het altaar, op de vuurofferen des HEEREN; en de priester zal voor hem verzoening doen over zijn zonde, die hij gezondigd heeft, en het zal hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Als nu een mens zal gezondigd hebben, dat hij gehoord heeft een stem des vloeks, waarvan hij getuige is, hetzij dat hij het gezien of geweten heeft; indien hij het niet te kennen geeft, zo zal hij zijn ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Of wanneer een mens enig onrein ding zal aangeroerd hebben, hetzij het dode aas van een wild onrein gedierte, of het dode aas van onrein vee, of het dode aas van onrein kruipend gedierte; al is het voor hem verborgen geweest, nochtans is hij onrein en schuldig. ");
INSERT INTO nld_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Of als hij zal aangeroerd hebben de onreinigheid van een mens, naar al zijn onreinigheid, waarmede hij onrein wordt; en het is voor hem verborgen geweest, en hij is het gewaar geworden, zo is hij schuldig. ");
INSERT INTO nld_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Of als een mens zal gezworen hebben, onbedacht met zijn lippen uitsprekende, om kwaad te doen, of om goed te doen; naar al wat de mens in den eed onbedacht uitspreekt, en het is voor hem verborgen geweest, en hij is het gewaar geworden, zo is hij aan een van die schuldig. ");
INSERT INTO nld_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Het zal dan geschieden, als hij aan een van die schuldig is, dat hij belijden zal, waarin hij gezondigd heeft; ");
INSERT INTO nld_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","En tot zijn schuldoffer den HEERE voor zijn zonde, die hij gezondigd heeft, brengen zal een wijfje van klein vee, een lam of een jonge geit, voor de zonde; zo zal de priester voor hem vanwege zijn zonde verzoening doen. ");
INSERT INTO nld_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Maar indien zijn hand zoveel niet bereiken kan, als genoeg is tot een stuk klein vee, zo zal hij tot zijn offer voor de schuld, die hij gezondigd heeft, den HEERE brengen twee tortelduiven, of twee jonge duiven, een ten zondoffer, en een ten brandoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","En hij zal die tot den priester brengen, welke eerst die zal offeren, die tot het zondoffer is; en zal haar hoofd met zijn nagel nevens haar nek splijten, maar niet afscheiden. ");
INSERT INTO nld_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","En van het bloed des zondoffers zal hij aan den wand van het altaar sprengen; maar het overgeblevene van dat bloed zal uitgeduwd worden aan den bodem van het altaar; het is een zondoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","En de andere zal hij ten brandoffer maken, naar de wijze; zo zal de priester voor hem, vanwege zijn zonde, die hij gezondigd heeft, verzoening doen, en het zal hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Maar indien zijn hand niet bereiken kan aan twee tortelduiven of twee jonge duiven, zo zal hij, die gezondigd heeft, tot zijn offerande brengen het tiende deel van een efa meelbloem ten zondoffer; hij zal geen olie daarover doen, noch wierook daarop leggen; want het is een zondoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","En hij zal dat tot den priester brengen, en de priester zal daarvan zijn hand vol, der gedachtenis deszelven, grijpen, en dat aansteken op het altaar, op de vuurofferen des HEEREN; het is een zondoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Zo zal de priester voor hem verzoening doen over zijn zonde, die hij gezondigd heeft in enige van die stukken, en het zal hem vergeven worden; en het zal des priesters zijn, gelijk het spijsoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Wijders sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Als een mens door overtreding overtreden, en door afdwaling gezondigd zal hebben, wat onwetende van de heilige dingen des HEEREN, zo zal hij tot zijn schuldoffer den HEERE brengen een volkomen ram uit de kudde, met uw schatting aan zilveren sikkelen, naar den sikkel des heiligdoms, ten schuldoffer. ");
INSERT INTO nld_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Zo zal hij, dat hij zondigende heeft onwetend van de heilige dingen, wedergeven, en zal deszelfs vijfde deel daarenboven toedoen, dat hij den priester geven zal; alzo zal de priester met den ram des schuldoffers voor hem verzoening doen, en het zal hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","En indien een mens zal gezondigd hebben, en gedaan tegen een van alle geboden des HEEREN, hetwelk niet zou gedaan worden, al is het dat hij het niet geweten heeft, nochtans is hij schuldig, en zal zijn ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","En hij zal een volkomen ram uit de kudde tot den priester brengen, met uw schatting, ten schuldoffer; en de priester zal voor hem verzoening doen over zijn afdwaling, door welke hij afgedwaald is, die hij niet geweten had; zo zal het hem vergeven worden. ");
INSERT INTO nld_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Het is een schuldoffer; hij heeft zich voorzeker schuldig gemaakt aan den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Als een mens gezondigd, en tegen den HEERE door overtreding overtreden zal hebben, dat hij aan zijn naaste zal gelogen hebben van hetgeen hem in bewaring gegeven, of ter hand gesteld was, of van roof, of dat hij met geweld zijn naaste onthoudt; ");
INSERT INTO nld_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Of dat hij het verlorene gevonden, en daarover gelogen, en met valsheid gezworen zal hebben; over iets van alles, dat de mens doet, daarin zondigende. ");
INSERT INTO nld_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Het zal dan geschieden, dewijl hij gezondigd heeft, en schuldig geworden is, dat hij wederuitkeren zal den roof, dien hij geroofd, of het onthoudene, dat hij met geweld onthoudt, of het bewaarde, dat bij hem te bewaren gegeven was, of het verlorene, dat hij gevonden heeft; ");
INSERT INTO nld_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Of van al, waarover hij valselijk gezworen heeft, dat hij hetzelve in zijn hoofdsom wedergeve, en nog het vijfde deel daarenboven toedoen zal; wiens dat is, dien zal hij dat geven op den dag zijner schuld. ");
INSERT INTO nld_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","En hij zal den HEERE zijn schuldoffer brengen tot den priester, een volkomen ram uit de kudde, met uw schatting, ten schuldoffer. ");
INSERT INTO nld_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Dan zal de priester voor hem verzoening doen voor het aangezicht des HEEREN, en het zal hem vergeven worden; over iets van al, wat hij doet, waar hij schuld aan heeft. ");
INSERT INTO nld_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Gebied Aaron en zijn zonen, zeggende: Dit is de wet des brandoffers; het is hetgeen, wat door de branding op het altaar den gansen nacht tot aan den morgen opvaart; alwaar het vuur des altaars zal brandende gehouden worden. ");
INSERT INTO nld_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","En de priester zal zijn linnen kleed aantrekken, en de linnen onderbroek over zijn vlees aantrekken, en zal de as opnemen, als het vuur het brandoffer op het altaar zal verteerd hebben, en zal die bij het altaar leggen. ");
INSERT INTO nld_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Daarna zal hij zijn klederen uittrekken, en zal andere klederen aandoen, en zal de as tot buiten het leger uitdragen aan een reine plaats. ");
INSERT INTO nld_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Het vuur nu op het altaar zal daarop brandende gehouden worden, het zal niet uitgeblust worden; maar de priester zal daar elken morgen hout aansteken, en zal daarop het brandoffer schikken, en het vet der dankofferen daarop aansteken. ");
INSERT INTO nld_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Het vuur zal geduriglijk op het altaar brandende gehouden worden; het zal niet uitgeblust worden. ");
INSERT INTO nld_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Dit is nu de wet des spijsoffers; een der zonen van Aaron zal dat voor het aangezicht des HEEREN offeren, voor het altaar. ");
INSERT INTO nld_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","En hij zal daarvan opnemen zijn hand vol, uit de meelbloem des spijsoffers, en van deszelfs olie, en al den wierook, die op het spijsoffer is; dan zal hij het aansteken op het altaar; het is een liefelijke reuk tot deszelfs gedachtenis voor den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","En het overblijvende daarvan zullen Aaron en zijn zonen eten; ongezuurd zal het gegeten worden in de heilige plaats; in den voorhof van de tent der samenkomst zullen zij dat eten. ");
INSERT INTO nld_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Het zal niet gedesemd gebakken worden; het is hun deel, dat Ik gegeven heb van Mijn vuurofferen; het is een heiligheid der heiligheden, gelijk het zondoffer en gelijk het schuldoffer. ");
INSERT INTO nld_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Al wat mannelijk is onder de zonen van Aaron zal het eten; het zij een eeuwige inzetting voor uw geslachten van de vuurofferen des HEEREN; al wat die zal aanroeren, zal heilig zijn. ");
INSERT INTO nld_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Wijders sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Dit is de offerande van Aaron en van zijn zonen, die zij den HEERE offeren zullen, ten dage als hij zal gezalfd worden: het tiende deel ener efa meelbloem, een spijsoffer gedurig; de helft daarvan op den morgen, en de helft daarvan op den avond. ");
INSERT INTO nld_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Het zal in een pan met olie gemaakt worden; geroost zult gij het brengen; en de gebakken stukken des spijsoffers zult gij offeren, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ook zal de priester, die uit zijn zonen in zijn plaats de gezalfde zal worden, hetzelfde doen; het zij een eeuwige inzetting; het zal voor den HEERE geheel aangestoken worden. ");
INSERT INTO nld_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Alzo zal alle spijsoffer des priesters ganselijk zijn; het zal niet gegeten worden. ");
INSERT INTO nld_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Spreek tot Aaron en tot zijn zonen, zeggende: Dit is de wet des zondoffers: in de plaats, waar het brandoffer geslacht wordt, zal het zondoffer voor het aangezicht des HEEREN geslacht worden; het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","De priester, die het voor de zonde offert, zal het eten; in de heilige plaats zal het gegeten worden, in den voorhof van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Al wat deszelfs vlees zal aanroeren, zal heilig zijn; zo wie van zijn bloed op een kleed zal gesprengd hebben, dat, waarop hij gesprengd zal hebben, zult gij in de heilige plaats wassen. ");
INSERT INTO nld_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","En het aarden vat, waarin het gezoden is, zal gebroken worden; maar zo het in een koperen vat gezoden is, zo zal het geschuurd en in water gespoeld worden. ");
INSERT INTO nld_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Al wat mannelijk is onder de priesteren, zal dat eten; het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Maar geen zondoffer, van welks bloed in de tent der samenkomst zal gebracht worden, om in het heiligdom te verzoenen, zal gegeten worden; het zal in het vuur verbrand worden. ");
INSERT INTO nld_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Dit is nu de wet des schuldoffers; het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","In de plaats, waar zij het brandoffer slachten, zullen zij het schuldoffer slachten; en men zal deszelfs bloed rondom op het altaar sprengen. ");
INSERT INTO nld_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","En daarvan zal men al zijn vet offeren, den staart, en het vet, dat het ingewand bedekt; ");
INSERT INTO nld_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ook de beide nieren, en het vet, dat daaraan is, dat op de weekdarmen is; en het net over de lever, met de nieren, zal men afnemen. ");
INSERT INTO nld_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","En de priester zal die aansteken op het altaar, ten vuuroffer den HEERE; het is een schuldoffer. ");
INSERT INTO nld_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Al wat mannelijk is onder de priesteren zal dat eten; in de heilige plaats zal het gegeten worden; het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Gelijk het zondoffer, alzo zal ook het schuldoffer zijn; enerlei wet zal voor dezelve zijn; het zal des priesters zijn, die daarmede verzoening gedaan zal hebben. ");
INSERT INTO nld_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ook de priester, die iemands brandoffer offert, die priester zal de huid des brandoffers hebben, dat hij geofferd heeft. ");
INSERT INTO nld_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Daartoe al het spijsoffer, dat in den oven gebakken wordt, met al wat in den ketel en in den pan bereid wordt, zal des priesters zijn, die dat offert. ");
INSERT INTO nld_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ook alle spijsoffer met olie gemengd, of droog, zal voor alle zonen van Aaron zijn, voor den enen als voor den anderen. ");
INSERT INTO nld_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Dit is nu de wet des dankoffers, dat men den HEERE offeren zal. ");
INSERT INTO nld_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Indien hij dat tot een lof offer offert, zo zal hij, nevens het lofoffer, ongezuurde koeken met olie gemengd, en ongezuurde vladen met olie bestreken, offeren; en zullen die koeken met olie gemengd van geroost meelbloem zijn. ");
INSERT INTO nld_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Benevens de koeken zal hij tot zijn offerande gedesemd brood offeren, met het lofoffer zijns dankoffers. ");
INSERT INTO nld_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","En een daarvan uit de ganse offerande zal hij den HEERE ten hefoffer offeren; het zal voor den priester zijn, die het bloed des dankoffers sprengt. ");
INSERT INTO nld_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Maar het vlees van het lofoffer zijns dankoffers zal op den dag van deszelfs offerande gegeten worden; daarvan zal men niet tot den morgen overlaten. ");
INSERT INTO nld_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","En zo het slachtoffer zijner offerande een gelofte, of vrijwillig offer is, dat zal ten dage als hij zijn offer offeren zal, gegeten worden, en het overgeblevene daarvan zal ook des anderen daags gegeten worden. ");
INSERT INTO nld_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Wat nog van het vlees des slachtoffers overgebleven is, zal op den derden dag met vuur verbrand worden; ");
INSERT INTO nld_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Want zo enigszins van dat vlees zijns dankoffers op den derden dag gegeten wordt, die dat geofferd heeft, zal niet aangenaam zijn; het zal hem niet toegerekend worden, het zal een afgrijselijk ding zijn; en de ziel, die daarvan eet, zal haar ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","En het vlees, dat iets onreins aangeroerd zal hebben, zal niet gegeten worden; met vuur zal het verbrand worden; maar aangaande het andere vlees, dat vlees zal een ieder, die rein is, mogen eten. ");
INSERT INTO nld_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Doch als een ziel het vlees van het dankoffer, hetwelk des HEEREN is, gegeten zal hebben, en haar onreinigheid aan haar is, zo zal die ziel uit haar volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","En wanneer een ziel iets onreins zal aangeroerd hebben, als de onreinigheid des mensen, of het onreine vee, of enig onrein verfoeisel, en zal van het vlees des dankoffers, hetwelk des HEEREN is, gegeten hebben, zo zal die ziel uit haar volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Spreek tot de kinderen Israels, zeggende: Geen vet van een os, of schaap, of geit, zult gij eten. ");
INSERT INTO nld_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Maar het vet van een dood aas, en het vet van het verscheurde, mag tot alle werk gebezigd worden; doch gij zult het ganselijk niet eten. ");
INSERT INTO nld_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Want al wie het vet van vee eten zal, van hetwelk men den HEERE een vuuroffer zal geofferd hebben, die ziel, die het gegeten zal hebben, zal uit haar volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ook zult gij in uw woningen geen bloed eten, hetzij van het gevogelte, of van het vee. ");
INSERT INTO nld_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Alle ziel, die enig bloed eten zal, die ziel zal uit haar volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Voorts sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Spreek tot de kinderen Israels, zeggende: Wie zijn dankoffer den HEERE offert, zal zijn offerande van zijn dankoffer den HEERE toebrengen. ");
INSERT INTO nld_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Zijn handen zullen de vuurofferen des HEEREN brengen; het vet aan de borst zal hij met die borst brengen, om die tot een beweegoffer voor het aangezicht des HEEREN te bewegen. ");
INSERT INTO nld_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","En de priester zal dat vet op het altaar aansteken; doch de borst zal voor Aaron en zijn zonen zijn. ");
INSERT INTO nld_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Gij zult ook den rechterschouder tot een hefoffer den priester geven, uit uw dankofferen. ");
INSERT INTO nld_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Wie uit de zonen van Aaron het bloed des dankoffers en het vet offert, dien zal de rechterschouder ten dele zijn. ");
INSERT INTO nld_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Want de beweegborst en den hefschouder heb Ik van de kinderen Israels uit hun dankofferen genomen, en heb dezelve aan Aaron, den priester, en aan zijn zonen, tot een eeuwige inzetting gegeven, van de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dit is de zalving van Aaron en de zalving van zijn zonen, van de vuurofferen des HEEREN; ten dage als Hij hen deed naderen, om het priesterdom den HEERE te bedienen; ");
INSERT INTO nld_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Hetwelk de HEERE hun van de kinderen Israels te geven geboden heeft, ten dage als Hij hen zalfde; het zij een eeuwige inzetting voor hun geslachten. ");
INSERT INTO nld_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dit is de wet des brandoffers, des spijsoffers, des zondoffers, des schuldoffers, des vuloffers en des dankoffers; ");
INSERT INTO nld_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Die de HEERE Mozes op den berg Sinai geboden heeft, ten dage als Hij den kinderen Israels gebood, dat zij hun offeranden den HEERE, in de woestijn van Sinai, zouden offeren. ");
INSERT INTO nld_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Neem Aaron en zijn zonen met hem, en de klederen, en de zalfolie, daartoe den var des zondoffers, en de twee rammen, en den korf van de ongezuurde broden; ");
INSERT INTO nld_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","En verzamel de ganse vergadering aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mozes nu deed, gelijk als de HEERE hem geboden had; en de vergadering werd verzameld aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Toen zeide Mozes tot de vergadering: Dit is de zaak, die de HEERE geboden heeft te doen. ");
INSERT INTO nld_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","En Mozes deed Aaron en zijn zonen naderen, en wies hen met dat water. ");
INSERT INTO nld_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Daar deed hij hem den rok aan, en gordde hem met den gordel, en trok hem den mantel aan; en deed hij hem den efod aan, en gordde dien met den kunstelijken riem des efods, en ombond hem daarmede. ");
INSERT INTO nld_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Voorts deed hij hem den borstlap aan, en voegde aan den borstlap de Urim en de Thummim. ");
INSERT INTO nld_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","En hij zette den hoed op zijn hoofd; en aan den hoed boven zijn aangezicht zette hij de gouden plaat, de kroon der heiligheid, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Toen nam Mozes de zalfolie, en zalfde den tabernakel, en al wat daarin was, en heiligde ze. ");
INSERT INTO nld_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","En hij sprengde daarvan op het altaar zevenmaal; en hij zalfde het altaar, en al zijn gereedschap, mitsgaders het wasvat en zijn voet, om die te heiligen. ");
INSERT INTO nld_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Daarna goot hij van de zalfolie op het hoofd van Aaron, en hij zalfde hem, om hem te heiligen. ");
INSERT INTO nld_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ook deed Mozes de zonen van Aaron naderen, en trok hun rokken aan, en gordde hen met een gordel, en bond hun mutsen op, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Toen deed hij den var des zondoffers bijeenkomen; en Aaron en zijn zonen leiden hun handen op het hoofd van den var des zondoffers; ");
INSERT INTO nld_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","En men slachtte hem; en Mozes nam het bloed, en deed het met zijn vinger rondom op de hoornen des altaars, en ontzondigde het altaar; daarna goot hij het bloed uit aan den bodem des altaars, en heiligde het, om voor hetzelve verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Voorts nam hij al het vet, dat aan het ingewand is, en het net der lever, en de twee nieren en haar vet; en Mozes stak het aan op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Maar den var met zijn huid, en zijn vlees, en zijn mest, heeft hij buiten het leger met vuur verbrand, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Daarna deed hij den ram des brandoffers bijbrengen; en Aaron en zijn zonen leiden hun handen op het hoofd van den ram. ");
INSERT INTO nld_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","En men slachtte hem; en Mozes sprengde het bloed op het altaar rondom. ");
INSERT INTO nld_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Hij deelde ook den ram in zijn delen; en Mozes stak het hoofd aan, en die delen, en het smeer; ");
INSERT INTO nld_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Doch het ingewand en de schenkelen wies hij met water; en Mozes stak dien gehelen ram aan op het altaar; het was een brandoffer tot een liefelijken reuk, een vuuroffer was het den HEERE, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Daarna deed hij den anderen ram, den ram des vuloffers, bijbrengen; en Aaron met zijn zonen leiden hun handen op het hoofd van den ram. ");
INSERT INTO nld_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","En men slachtte hem; en Mozes nam van zijn bloed, en deed het op het lapje van Aarons rechteroor, en op den duim zijner rechterhand, en op den groten teen van zijn rechtervoet. ");
INSERT INTO nld_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Hij deed ook de zonen van Aaron naderen; en Mozes deed van dat bloed op het lapje van hun rechteroor, en op den duim van hun rechterhand, en op den groten teen van hun rechtervoet; daarna sprengde Mozes dat bloed rondom op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","En hij nam het vet, en den staart, en al het vet, dat aan het ingewand is, en het net der lever, en de beide nieren, en haar vet, daartoe den rechterschouder. ");
INSERT INTO nld_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ook nam hij uit den korf van de ongezuurde broden, die voor het aangezicht des HEEREN was, een ongezuurde koek, en een geolieden broodkoek, en een vlade; en hij leide ze op dat vet, en op den rechterschouder. ");
INSERT INTO nld_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","En hij gaf dat alles in de handen van Aaron, en in de handen zijner zonen; en bewoog die ten beweegoffer, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Daarna nam Mozes ze uit hun handen, en stak ze aan op het altaar, op het brandoffer; zij waren vulofferen tot een liefelijken reuk; het was een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Voorts nam Mozes de borst, en bewoog ze ten beweegoffer voor het aangezicht des HEEREN; zij werd Mozes ten dele van den ram des vuloffers, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mozes nam ook van de zalfolie, en van het bloed, hetwelk op het altaar was, en sprengde het op Aaron, op zijn klederen, en op zijn zonen, en op de klederen zijner zonen met hem; en hij heiligde Aaron, zijn klederen, en zijn zonen, en de klederen zijner zonen met hem. ");
INSERT INTO nld_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","En Mozes zeide tot Aaron en tot zijn zonen: Ziedt dat vlees voor de deur van de tent der samenkomst, en eet hetzelve daar, mitsgaders het brood, dat in den korf des vuloffers is; gelijk als ik geboden heb, zeggende: Aaron en zijn zonen zullen dat eten. ");
INSERT INTO nld_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Maar het overige van het vlees en van het brood zult gij met vuur verbranden. ");
INSERT INTO nld_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ook zult gij uit de deur van de tent der samenkomst, zeven dagen, niet uitgaan, tot aan den dag, dat vervuld worden de dagen uws vuloffers; want zeven dagen zal men uw handen vullen. ");
INSERT INTO nld_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Gelijk men gedaan heeft op dezen dag, heeft de HEERE te doen geboden, om voor u verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Gij zult dan aan de deur van de tent der samenkomst blijven, dag en nacht, zeven dagen, en zult de wacht des HEEREN waarnemen, opdat gij niet sterft; want alzo is het mij geboden. ");
INSERT INTO nld_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron nu en zijn zonen deden al de dingen, die de HEERE door den dienst van Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","En het geschiedde op den achtsten dag, dat Mozes riep Aaron en zijn zonen, en de oudsten van Israel; ");
INSERT INTO nld_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","En hij zeide tot Aaron: Neem u een kalf, een jong rund, ten zondoffer, en een ram ten brandoffer, die volkomen zijn; en breng ze voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Daarna spreek tot de kinderen Israels, zeggende: Neemt een geitenbok ten zondoffer, en een kalf, en een lam, eenjarig, volkomen, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ook een os en ram ten dankoffer, om voor het aangezicht des HEEREN te offeren; en spijsoffer met olie gemengd; want heden zal de HEERE u verschijnen. ");
INSERT INTO nld_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Toen namen zij hetgeen Mozes geboden had, brengende dat tot voor aan de tent der samenkomst; en de gehele vergadering naderde, en stond voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","En Mozes zeide: Deze zaak, die de HEERE geboden heeft, zult gij doen; en de heerlijkheid des HEEREN zal u verschijnen. ");
INSERT INTO nld_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","En Mozes zeide tot Aaron: Nader tot het altaar, en maak uw zondoffer, en uw brandoffer toe; en doe verzoening voor u en voor het volk; maak daarna de offerande des volks toe, en doe de verzoening voor hen, gelijk als de HEERE geboden heeft. ");
INSERT INTO nld_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Toen naderde Aaron tot het altaar, en slachtte het kalf des zondoffers, dat voor hem was. ");
INSERT INTO nld_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","En de zonen van Aaron brachten het bloed tot hem, en hij doopte zijn vinger in dat bloed, en deed het op de hoornen des altaars; daarna goot hij het bloed uit aan den bodem des altaars. ");
INSERT INTO nld_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Maar het vet, en de nieren, en het net van de lever van het zondoffer heeft hij op het altaar aangestoken, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Doch het vlees, en de huid verbrandde hij met vuur buiten het leger. ");
INSERT INTO nld_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Daarna slachtte hij het brandoffer; en de zonen van Aaron leverden aan hem het bloed; en hij sprengde dat rondom op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ook leverden zij aan hem het brandoffer in zijn stukken, met het hoofd; en hij stak het aan op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","En hij wies het ingewand en de schenkelen; en hij stak ze aan op het brandoffer, op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Daarna deed hij de offerande des volks toebrengen; en nam den bok des zondoffers, die voor het volk was, en slachtte hem, en bereidde hem ten zondoffer, gelijk het eerste. ");
INSERT INTO nld_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Verder deed hij het brandoffer toebrengen, en maakte dat toe naar het recht. ");
INSERT INTO nld_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","En hij deed het spijsoffer toebrengen, en vulde daarvan zijn hand, en stak het aan op het altaar, behalve het morgenbrandoffer. ");
INSERT INTO nld_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Daarna slachtte hij den os, en den ram ten dankoffer, dat voor het volk was; en de zonen van Aaron leverden het bloed aan hem, hetwelk hij rondom op het altaar sprengde; ");
INSERT INTO nld_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","En het vet van den os, en van den ram, den staart, en wat het ingewand bedekt, en de nieren, en het net der lever; ");
INSERT INTO nld_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","En zij leiden het vet op de borsten; en hij stak dat vet aan op het altaar. ");
INSERT INTO nld_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Maar de borsten en den rechterschouder bewoog Aaron ten beweegoffer voor het aangezicht des HEEREN, gelijk als Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Daarna hief Aaron zijn handen op tot het volk, en zegende hen; en hij kwam af, nadat hij het zondoffer, en brandoffer, en dankoffer gedaan had. ");
INSERT INTO nld_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Toen ging Mozes met Aaron in de tent der samenkomst; daarna kwamen zij uit, en zegenden het volk; en de heerlijkheid des HEEREN verscheen al het volk. ");
INSERT INTO nld_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Want een vuur ging uit van het aangezicht des HEEREN, en verteerde op het altaar het brandoffer, en het vet. Als het ganse volk dit zag, zo juichten zij, en vielen op hun aangezichten. ");
INSERT INTO nld_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","En de zonen van Aaron, Nadab en Abihu, namen een ieder zijn wierookvat, en deden vuur daarin, en leiden reukwerk daarop, en brachten vreemd vuur voor het aangezicht des HEEREN, hetwelk hij hen niet geboden had. ");
INSERT INTO nld_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Toen ging een vuur uit van het aangezicht des HEEREN, en verteerde hen; en zij stierven voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","En Mozes zeide tot Aaron: Dat is het, wat de HEERE gesproken heeft, zeggende: In degenen, die tot Mij naderen, zal Ik geheiligd worden, en voor het aangezicht van al het volk zal Ik verheerlijkt worden. Doch Aaron zweeg stil. ");
INSERT INTO nld_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","En Mozes riep Misael en Elzafan, de zonen van Uzziel, den oom van Aaron, en zeide tot hen: Treedt toe, draagt uw broederen weg, van voor het heiligdom tot buiten het leger. ");
INSERT INTO nld_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Toen traden zij toe, en droegen hen, in hun rokken, tot buiten het leger, gelijk als Mozes gesproken had. ");
INSERT INTO nld_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","En Mozes zeide tot Aaron, en tot Eleazar, en tot Ithamar, zijn zonen: Gij zult uw hoofden niet ontbloten, noch uw klederen verscheuren, opdat gij niet sterft, en grote toorn over de ganse vergadering kome; maar uw broederen, het ganse huis van Israel, zullen dezen brand, dien de HEERE aan gestoken heeft, bewenen. ");
INSERT INTO nld_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Gij zult ook uit de deur van de tent der samenkomst niet uitgaan, opdat gij niet sterft; want de zalfolie des HEEREN is op u. En zij deden naar het woord van Mozes. ");
INSERT INTO nld_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","En de HEERE sprak tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Wijn en sterken drank zult gij niet drinken, gij, noch uw zonen met u, als gij gaan zult in de tent der samenkomst, opdat gij niet sterft; het zij een eeuwige inzetting onder uw geslachten; ");
INSERT INTO nld_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","En om onderscheid te maken tussen het heilige en tussen het onheilige, en tussen het onreine en tussen het reine; ");
INSERT INTO nld_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","En om den kinderen Israels te leren al de inzettingen, die de HEERE door den dienst van Mozes tot hen gesproken heeft. ");
INSERT INTO nld_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","En Mozes sprak tot Aaron, en tot Eleazar, en tot Ithamar, zijn overgebleven zonen: Neemt het spijsoffer, dat van de vuurofferen des HEEREN overgebleven is, en eet hetzelve ongezuurd bij het altaar; want het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Daarom zult gij dat eten in de heilige plaats, dewijl het uw bescheiden deel en het bescheiden deel uwer zonen uit des HEEREN vuurofferen is; want alzo is mij geboden. ");
INSERT INTO nld_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ook de beweegborst en den hefschouder zult gij in een reine plaats eten, gij, en uw zonen, en uw dochteren met u; want tot uw bescheiden deel, en uwer zonen bescheiden deel, zijn zij uit de dankofferen der kinderen Israels gegeven. ");
INSERT INTO nld_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Den hefschouder en de beweegborst zullen zij nevens de vuurofferen des vets toebrengen, om ten beweegoffer voor het aangezicht des HEEREN te bewegen; hetwelk, voor u en uw zonen met u, tot een eeuwige inzetting zijn zal, gelijk als de HEERE geboden heeft. ");
INSERT INTO nld_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","En Mozes zocht zeer naarstiglijk den bok des zondoffers; en ziet, hij was verbrand. Dies was hij op Eleazar en op Ithamar, de overgebleven zonen van Aaron, zeer toornig, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Waarom hebt gij dat zondoffer niet gegeten in de heilige plaats? Want het is een heiligheid der heiligheden, en Hij heeft u dat gegeven, opdat gij de ongerechtigheid der vergadering zoudt dragen, om over die verzoening te doen voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ziet, deszelfs bloed is niet binnen in het heiligdom gedragen; gij moest dat ganselijk gegeten hebben in het heiligdom, gelijk als ik geboden heb. ");
INSERT INTO nld_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Toen sprak Aaron tot Mozes: Zie, heden hebben zij hun zondoffer en hun brandoffer voor het aangezicht des HEEREN geofferd, en zulke dingen zijn mij wedervaren; en had ik heden het zondoffer gegeten, zou dat goed geweest zijn in de ogen des HEEREN? ");
INSERT INTO nld_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Als Mozes dit hoorde, zo was het goed in zijn ogen. ");
INSERT INTO nld_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","En de HEERE sprak tot Mozes en tot Aaron, zeggende tot hen: ");
INSERT INTO nld_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Spreekt tot de kinderen Israels, zeggende: Dit is het gedierte, dat gij eten zult uit alle beesten, die op de aarde zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Al wat onder de beesten den klauw verdeelt, en de kloof der klauwen in tweeen klieft, en herkauwt, dat zult gij eten. ");
INSERT INTO nld_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Deze nochtans zult gij niet eten, van degenen, die alleen herkauwen, of de klauwen alleen verdelen: den kemel, want hij herkauwt wel, maar verdeelt den klauw niet; die zal u onrein zijn; ");
INSERT INTO nld_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","En het konijntje, want het herkauwt wel, maar verdeelt den klauw niet; dat zal u onrein zijn; ");
INSERT INTO nld_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","En den haas, want hij herkauwt wel, maar verdeelt den klauw niet; die zal u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ook het zwijn, want dat verdeelt wel den klauw, en klieft de klove der klauwen in tweeen, maar herkauwt het gekauwde niet; dat zal u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Van hun vlees zult gij niet eten, en hun dood aas niet aanroeren, zij zullen u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dit zult gij eten van al wat in de wateren is: al wat in de wateren, in de zeeen en in de rivieren, vinnen en schubben heeft, dat zult gij eten; ");
INSERT INTO nld_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Maar al wat in de zeeen en in de rivieren, van alle gewemel der wateren, en van alle levende ziel, die in de wateren is, geen vinnen of schubben heeft, dat zal u een verfoeisel zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ja, een verfoeisel zullen zij u zijn; van hun vlees zult gij niet eten, en hun dood aas zult gij verfoeien. ");
INSERT INTO nld_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Al wat in de wateren geen vinnen en schubben heeft, dat zal u een verfoeisel zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","En van het gevogelte zult gij deze verfoeien, zij zullen niet gegeten worden, zij zullen een verfoeisel zijn: de arend, en de havik, en de zeearend, ");
INSERT INTO nld_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","En de gier, en de kraai, naar haar aard; ");
INSERT INTO nld_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Alle rave naar haar aard; ");
INSERT INTO nld_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","En de struis, en de nachtuil, en de koekoek, en de sperwer naar zijn aard; ");
INSERT INTO nld_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","En de steenuil, en het duikertje, en de schuifuit, ");
INSERT INTO nld_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","En de kauw, en de roerdomp, en de pelikaan, ");
INSERT INTO nld_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","En de ooievaar, de reiger naar zijn aard, en de hop, en de vledermuis. ");
INSERT INTO nld_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alle kruipend gevogelte, dat op vier voeten gaat, zal u een verfoeisel zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Dit nochtans zult gij eten van al het kruipend gevogelte, dat op vier voeten gaat, hetwelk boven aan zijn voeten schenkelen heeft, om daarmede op de aarde te springen; ");
INSERT INTO nld_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Van die zult gij deze eten: den sprinkhaan naar zijn aard, en den solham naar zijn aard, en den hargol naar zijn aard, en den hagab naar zijn aard. ");
INSERT INTO nld_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","En alle kruipend gevogelte, dat vier voeten heeft, zal u een verfoeisel zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","En aan deze zult gij verontreinigd worden; zo wie hun dood aas zal aangeroerd hebben, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Zo wie van hun dood aas gedragen zal hebben, zal zijn klederen wassen, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Alle beest, dat den klauw verdeelt, doch de klove niet in tweeen klieft, en niet herkauwt, zal u onrein zijn; zo wie hetzelve aangeroerd zal hebben, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","En al wat op zijn poten gaat onder alle gedierte, op vier voeten gaande, die zullen u onrein zijn; al wie hun dood aas aangeroerd zal hebben, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ook die hun dood aas zal gedragen hebben, zal zijn klederen wassen, en onrein zijn tot aan den avond; zij zullen u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Verder zal u dit onder het kruipend gedierte, dat op de aarde kruipt, onrein zijn: het wezeltje, en de muis, en de schildpad, naar haar aard; ");
INSERT INTO nld_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","En de zwijnegel, en de krokodil, en de hagedis, en de slak, en de mol; ");
INSERT INTO nld_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Die zullen u onrein zijn onder alle kruipend gedierte; zo wie die zal aangeroerd hebben, als zij dood zijn, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Daartoe al hetgeen, waarop iets van dezelve vallen zal, als zij dood zijn, zal onrein zijn, hetzij van alle houten vat, of kleed, of vel, of zak, of alle vat, waarmede enig werk gedaan wordt; het zal in het water gestoken worden, en onrein zijn tot aan den avond; daarna zal het rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","En alle aarden vat, waarin iets van dezelve zal gevallen zijn, al wat daarin is, zal onrein zijn, en gij zult dat breken. ");
INSERT INTO nld_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Van alle spijze, die men eet, waarop het water zal gekomen zijn, die zal onrein zijn; en alle drank, die men drinkt, zal in alle vat onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","En waarop iets van hun dood aas zal vallen, zal onrein zijn; de oven en de aarden pan zal verbroken worden; zij zijn onrein, daarom zullen zij u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Doch een fontein, of put van vergadering der wateren, zal rein zijn; maar wie hun dood aas zal aangeroerd hebben, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","En wanneer van hun dood aas zal gevallen zijn op enig zaaibaar zaad, dat gezaaid wordt, dat zal rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Maar als water op het zaad gedaan zal worden, en van hun dood aas daarop zal gevallen zijn, dat zal u onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","En wanneer van de dieren, die u tot spijze zijn, iets zal gestorven zijn, wie deszelfs dood aas zal aangeroerd hebben, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ook die van hun dood aas gegeten zal hebben, zal zijn klederen wassen, en onrein zijn tot aan den avond; en die hun dood aas zal gedragen hebben, zal zijn klederen wassen, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Voorts alle kruipend gedierte, dat op de aarde kruipt, zal een verfoeisel zijn; het zal niet gegeten worden. ");
INSERT INTO nld_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Al wat op zijn buik gaat, en al wat gaat op zijn vier voeten, of al wat vele voeten heeft, onder alle kruipend gedierte, dat op de aarde kruipt, die zult gij niet eten, want zij zijn een verfoeisel. ");
INSERT INTO nld_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Maakt uw zielen niet verfoeilijk aan enig kruipend gedierte, dat kruipt; en verontreinigt u niet daaraan, dat gij daaraan verontreinigd zoudt worden. ");
INSERT INTO nld_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Want Ik ben de HEERE, uw God; daarom zult gij u heiligen, en heilig zijn, dewijl Ik heilig ben; en gij zult uw ziel niet verontreinigen aan enig kruipend gedierte, dat zich op de aarde roert. ");
INSERT INTO nld_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Want Ik ben de HEERE, die u uit Egypteland doe optrekken, opdat Ik u tot een God zij, en opdat gij heilig zijt, dewijl Ik heilig ben. ");
INSERT INTO nld_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Dit is de wet van de beesten, en van het gevogelte, en van alle levende ziel, die zich roert in de wateren, en van alle ziel, die kruipt op de aarde; ");
INSERT INTO nld_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Om te onderscheiden tussen het onreine en tussen het reine, en tussen het gedierte, dat men eten, en tussen het gedierte, dat men niet eten zal. ");
INSERT INTO nld_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Spreek tot de kinderen Israels, zeggende: Wanneer een vrouw zaad gegeven, en een knechtje gebaard zal hebben, zo zal zij zeven dagen onrein zijn; volgens de dagen der afzondering harer krankheid zal zij onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","En op den achtsten dag zal het vlees zijner voorhuid besneden worden. ");
INSERT INTO nld_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Daarna zal zij drie en dertig dagen blijven in het bloed harer reiniging; niets heiligs zal zij aanroeren, en tot het heiligdom zal zij niet komen, totdat de dagen harer reiniging vervuld zijn. ");
INSERT INTO nld_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Maar indien zij een meisje gebaard zal hebben, zo zal zij twee weken onrein zijn, volgens haar afzondering; daarna zal zij zes en zestig dagen blijven in het bloed harer reiniging. ");
INSERT INTO nld_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","En als de dagen harer reiniging voor den zoon, of voor de dochter, vervuld zullen zijn, zo zal zij een eenjarig lam ten brandoffer, en een jonge duif, of tortelduif, ten zondoffer brengen, voor de deur van de tent der samenkomst, tot den priester. ");
INSERT INTO nld_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Die zal dat offeren voor het aangezicht des HEEREN, en zal voor haar verzoening doen, zo zal zij rein zijn van den vloed haars bloeds. Dit is de wet dergene, die een knechtje of meisje gebaard heeft. ");
INSERT INTO nld_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Maar indien haar hand niet genoeg voor een lam vindt, zo zal zij twee tortelduiven, of twee jonge duiven nemen, een ten brandoffer, en een ten zondoffer; en de priester zal voor haar verzoening doen; zo zal zij rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Verder sprak de HEERE tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Een mens, als in het vel zijns vleses een gezwel, of gezweer, of witte blaar zal zijn, welke in het vel zijns vleses tot een plaag der melaatsheid zou worden, hij zal dan tot den priester Aaron, of tot een uit zijn zonen, de priesteren, gebracht worden. ");
INSERT INTO nld_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","En de priester zal de plaag in het vel des vleses bezien; zo het haar in die plaag in wit veranderd is, en het aanzien der plaag dieper is dan het vel zijns vleses, het is de plaag der melaatsheid; als de priester hem bezien zal hebben, dan zal hij hem onrein verklaren. ");
INSERT INTO nld_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Maar zo de blaar in het vel zijn vleses wit is, en haar aanzien niet dieper is dan het vel, en het haar niet in wit veranderd is, zo zal de priester hem, die de plaag heeft, zeven dagen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Daarna zal de priester op den zevenden dag hem bezien; indien, ziet, de plaag, naar dat hij zien kan, is staande gebleven, en de plaag in het vel niet uitgespreid is, zo zal de priester hem zeven andere dagen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","En de priester zal hem andermaal op den zevenden dag bezien; indien, ziet, de plaag ingetrokken, en de plaag in het vel niet uitgespreid is, zo zal de priester hem rein verklaren; het was een verzwering; en hij zal zijn klederen wassen, zo is hij rein. ");
INSERT INTO nld_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Maar zo de verzwering in het vel ganselijk uitgespreid is, nadat hij aan den priester tot zijn reiniging zal vertoond zijn, zo zal hij andermaal aan den priester vertoond worden. ");
INSERT INTO nld_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Indien de priester merken zal, dat, ziet, de verzwering in het vel uitgespreid is, zo zal de priester hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nld_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wanneer de plaag der melaatsheid in een mens zal zijn, zo zal hij tot den priester gebracht worden. ");
INSERT INTO nld_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Indien de priester merken zal, dat, ziet, een wit gezwel in het vel is, hetwelk het haar in wit veranderd heeft, en gezondheid van levend vlees in dat gezwel is; ");
INSERT INTO nld_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Dat is een verouderde melaatsheid in het vel zijns vleses; daarom zal hem de priester onrein verklaren; hij zal hem niet doen opsluiten, want hij is onrein. ");
INSERT INTO nld_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","En zo de melaatsheid in het vel ganselijk uitbot, en de melaatsheid het gehele vel desgenen, die de plaag heeft, van zijn hoofd tot zijn voeten, bedekt heeft, naar al het gezicht van de ogen des priesters; ");
INSERT INTO nld_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","En de priester merken zal, dat, ziet, de melaatsheid zijn gehele vlees bedekt heeft, zo zal hij hem, die de plaag heeft, rein verklaren; zij is geheel in wit veranderd; hij is rein. ");
INSERT INTO nld_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Maar ten welken dage levend vlees daarin gezien zal worden, zal hij onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Als dan de priester dat levende vlees gezien zal hebben, zal hij hem onrein verklaren; dat levende vlees is onrein; het is melaatsheid. ");
INSERT INTO nld_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Of als dat levende vlees verkeert, en in wit veranderd zal worden, zo zal hij tot den priester komen. ");
INSERT INTO nld_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Als de priester hem bezien zal hebben, dat, ziet, de plaag in wit veranderd is, zo zal de priester hem, die de plaag heeft, rein verklaren; hij is rein. ");
INSERT INTO nld_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Het vlees ook, als in deszelfs vel een zweer zal geweest zijn, zo het genezen is; ");
INSERT INTO nld_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","En in de plaats van die zweer een wit gezwel, of een witte roodachtige blaar worden zal, zo zal het aan den priester vertoond worden. ");
INSERT INTO nld_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Indien de priester merken zal, dat, ziet, haar aanzien lager is dan het vel, en derzelver haar in wit veranderd is, zo zal de priester hem onrein verklaren; het is de plaag der melaatsheid, zij is door de zweer uitgebot. ");
INSERT INTO nld_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Wanneer nu de priester die bezien zal hebben, dat, ziet, geen wit haar daaraan is, en die niet lager dan het vel, maar ingetrokken is, zo zal de priester hem zeven dagen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Zo zij daarna gans in het vel uitgespreid zal zijn, zo zal de priester hem onrein verklaren; het is de plaag. ");
INSERT INTO nld_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Maar indien de blaar in haar plaats zal staande blijven, niet uitgespreid zijnde, het is de roof van die zweer, zo zal de priester hem rein verklaren; ");
INSERT INTO nld_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Of wanneer in het vel des vleses een vurige brand zal geweest zijn, en het gezonde van dien brand een witte roodachtige of witte blaar is; ");
INSERT INTO nld_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","En de priester die gezien zal hebben, dat, ziet, het haar op de blaar in wit veranderd is, en haar aanzien dieper is dan het vel; het is melaatsheid, door den brand is zij uitgebot; daarom zal hem de priester onrein verklaren; het is de plaag der melaatsheid. ");
INSERT INTO nld_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Maar indien de priester die merken zal, dat, ziet, op de blaar geen wit haar is, en zij niet lager dan het vel, maar ingetrokken is, zo zal de priester hem zeven dagen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Daarna zal de priester hem op den zevenden dag bezien; indien zij gans uitgespreid is in het vel, zo zal de priester hem onrein verklaren; het is de plaag der melaatsheid. ");
INSERT INTO nld_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Maar indien de blaar in haar plaats staande zal blijven, noch in het vel uitgespreid, maar ingetrokken zal zijn, het is een gezwel van den brand; daarom zal de priester hem rein verklaren, want het is de roof van den brand. ");
INSERT INTO nld_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Verder, als in een man of vrouw een plaag zal zijn in het hoofd, of in den baard; ");
INSERT INTO nld_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","En de priester de plaag zal bezien hebben, dat, ziet, haar aanzien dieper is dan het vel, en geelachtig dun haar daarop is, zo zal de priester hem onrein verklaren; het is schurftheid, het is melaatsheid van het hoofd of van den baard. ");
INSERT INTO nld_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Maar als de priester de plaag der schurftheid zal bezien hebben, dat, ziet, haar aanzien niet dieper is dan het vel, en geen zwart haar daarop is, zo zal de priester hem, die de plaag der schurftheid heeft, zeven dagen doen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Daarna zal de priester die plaag op den zevenden dag bezien; indien, ziet, de schurftheid niet uitgespreid, en daarop geen geelachtig haar is, noch het aanzien der schurftheid dieper dan het vel is; ");
INSERT INTO nld_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Zo zal hij zich scheren laten; maar de schurftheid zal hij niet scheren; en de priester zal hem, die de schurftheid heeft, andermaal zeven dagen doen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Daarna zal de priester die schurftheid op den zevenden dag bezien; indien, ziet, de schurftheid in het vel niet uitgespreid is, en haar aanzien niet dieper is dan het vel, zo zal de priester hem rein verklaren; en hij zal zijn klederen wassen, en rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Maar indien de schurftheid in het vel gans uitgespreid is, na zijn reiniging; ");
INSERT INTO nld_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","En de priester hem zal bezien hebben, dat, ziet, de schurftheid in het vel uitgespreid is, de priester zal naar het geelachtig haar niet zoeken; hij is onrein. ");
INSERT INTO nld_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Maar indien die schurftheid, naar dat hij zien kan, is staande gebleven, en zwart haar daarop gewassen is, die schurftheid is genezen, hij is rein; daarom zal de priester hem rein verklaren. ");
INSERT INTO nld_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Verder als een man, of vrouw, aan het vel van hun vlees blaren zullen hebben, witte blaren; ");
INSERT INTO nld_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","En de priester zal gemerkt hebben, dat, ziet, ingetrokken witte blaren in het vel van hun vlees zijn; het is een witte puist in het vel uitgebot, hij is rein. ");
INSERT INTO nld_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","En als een man zijn hoofdhaar zal uitgevallen zijn, hij is kaal, hij is rein. ");
INSERT INTO nld_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","En zo van de zijde zijns aangezichts het haar van zijn hoofd zal uitgevallen zijn, hij is bles, hij is rein. ");
INSERT INTO nld_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Maar zo in de kaalheid, of in de blesse, een witte roodachtige plaag is, dat is melaatsheid, uitbottende in zijn kaalheid, of in zijn blesse. ");
INSERT INTO nld_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Als de priester hem zal bezien hebben, dat, ziet, het gezwel van die plaag in zijn kaalheid, of blesse, wit roodachtig is, gelijk het aanzien der melaatsheid van het vel des vleses; ");
INSERT INTO nld_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Die man is melaats, hij is onrein; de priester zal hem ganselijk onrein verklaren, zijn plaag is op zijn hoofd. ");
INSERT INTO nld_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Voorts zullen de klederen des melaatsen, in wien die plaag is, gescheurd zijn, en zijn hoofd zal ontbloot zijn, en hij zal de bovenste lip bewimpelen; daartoe zal hij roepen: Onrein, onrein! ");
INSERT INTO nld_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Al de dagen, in welke deze plaag aan hem zal zijn, zal hij onrein zijn; onrein is hij, hij zal alleen wonen; buiten het leger zal zijn woning wezen. ");
INSERT INTO nld_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Verder als aan een kleed de plaag der melaatsheid zal zijn, aan een wollen kleed, of aan een linnen kleed, ");
INSERT INTO nld_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Of aan den scheerdraad, of aan den inslag van linnen, of van wol, of aan vel, of aan enig vellenwerk; ");
INSERT INTO nld_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","En die plaag aan het kleed, of aan het vel, of aan den scheerdraad, of aan den inslag, of aan enig vellentuig, groenachtig of roodachtig is; het is de plaag der melaatsheid; daarom zal zij den priester vertoond worden. ");
INSERT INTO nld_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","En de priester zal de plaag bezien; en hij zal hetgeen de plaag heeft, zeven dagen doen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Daarna zal hij op den zevenden dag de plaag bezien; zo de plaag uitgespreid is aan het kleed, of aan den scheerdraad, of aan den inslag, of aan het vel, tot wat werk dat vel zou mogen gemaakt zijn, die plaag is een knagende melaatsheid, het is onrein. ");
INSERT INTO nld_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Daarom zal hij dat kleed, of die werpte, of dien inslag van wol, of van linnen, of alle vellentuig, waarin die plaag zal zijn, verbranden; want het is een knagende melaatsheid; het zal met vuur verbrand worden. ");
INSERT INTO nld_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Doch indien de priester zal zien, dat, ziet, de plaag aan het kleed, of aan den scheerdraad, of aan den inslag, of aan enig vellentuig niet uitgespreid is; ");
INSERT INTO nld_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Zo zal de priester gebieden, dat men hetgeen, waaraan die plaag is, wasse, en hij zal dat andermaal zeven dagen doen opsluiten. ");
INSERT INTO nld_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Als de priester, nadat het gewassen is, de plaag zal bezien hebben, dat, ziet, de plaag haar gedaante niet veranderd heeft, en de plaag niet uitgespreid is, het is onrein, gij zult het met vuur verbranden; het is een ingraving aan zijn achterste of aan zijn voorste zijde. ");
INSERT INTO nld_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Indien nu de priester merken zal, dat, ziet, die plaag, nadat zij zal gewassen zijn, ingetrokken is; dan zal hij ze van het kleed, of van het vel, of van den scheerdraad, of van den inslag afscheuren. ");
INSERT INTO nld_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Maar zo zij nog aan het kleed, of aan den scheerdraad, of aan den inslag, of aan enig vellentuig, gezien wordt, het is uitbottende melaatsheid; gij zult hetgeen, waaraan de plaag is, met vuur verbranden. ");
INSERT INTO nld_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Maar het kleed, of de werpte, of de inslag, of alle vellentuig, dat gij gewassen zult hebben, als de plaag daarvan geweken zal zijn, dat zal andermaal gewassen worden, en het zal rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Dit is de wet van de plaag der melaatsheid, van een wollen of linnen kleed, of een werpte, of een inslag, of alle vellentuig, om dat rein te verklaren, of onrein te verklaren. ");
INSERT INTO nld_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dit zal de wet des melaatsen zijn, ten dage zijner reiniging: dat hij tot den priester zal gebracht worden. ");
INSERT INTO nld_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","En de priester zal buiten het leger gaan; als de priester merken zal, dat, ziet, die plaag der melaatsheid van den melaatse genezen is; ");
INSERT INTO nld_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Zo zal de priester gebieden, dat men voor hem, die te reinigen zal zijn, twee levende reine vogelen neme, mitsgaders cederenhout, en scharlaken, en hysop. ");
INSERT INTO nld_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","De priester zal ook gebieden, dat men den ene vogel slachte, in een aarden vat, over levend water. ");
INSERT INTO nld_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Dien levenden vogel zal hij nemen, en het cederhout, en het scharlaken, en den hysop; en zal die, en den levenden vogel dopen in het bloed des vogels, die boven het levende water geslacht is. ");
INSERT INTO nld_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","En hij zal over hem, die van de melaatsheid te reinigen is, zevenmaal sprengen; daarna zal hij hem rein verklaren, en den levenden vogel in het open veld vliegen laten. ");
INSERT INTO nld_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Die nu te reinigen is, zal zijn klederen wassen, en al zijn haar afscheren, en zich in het water afwassen, zo zal hij rein zijn; daarna zal hij in het leger komen, maar zal buiten zijn tent zeven dagen blijven. ");
INSERT INTO nld_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","En op den zevenden dag zal het geschieden, dat hij al zijn haar zal afscheren, zijn hoofd, en zijn baard, en de wenkbrauwen zijner ogen; ja, al zijn haar zal hij afscheren, en al zijn klederen wassen, en zijn vlees met water baden, zo zal hij rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","En op den achtsten dag zal hij twee volkomen lammeren, en een eenjarig volkomen schaap nemen, mitsgaders drie tienden meelbloem ten spijsoffer, met olie gemengd, en een log olie. ");
INSERT INTO nld_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","De priester nu, die de reiniging doet, zal den man, die te reinigen is, en die dingen, stellen voor het aangezicht des HEEREN, aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","En de priester zal dat ene lam nemen, en hetzelve offeren tot een schuldoffer met den log olie; en zal die ten beweegoffer voor het aangezicht des HEEREN bewegen. ");
INSERT INTO nld_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Daarna zal hij dat lam slachten in de plaats, waar men het zondoffer en het brandoffer slacht, in de heilige plaats; want het schuldoffer, gelijk het zondoffer, is voor den priester; het is een heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","En de priester zal van het bloed des schuldoffers nemen, hetwelk de priester doen zal op het lapje van het rechteroor desgenen, die te reinigen is, en op den duim zijner rechterhand, en op den groten teen zijns rechtervoets. ");
INSERT INTO nld_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","De priester zal ook uit den log der olie nemen, en zal ze op des priesters linkerhand gieten. ");
INSERT INTO nld_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Dan zal de priester zijn rechtervinger indopen, nemende van die olie, die in zijn linkerhand is, en zal met zijn vinger van die olie zevenmaal sprengen, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","En van het overige van die olie, die in zijn hand zal zijn, zal de priester doen op het lapje van het rechteroor desgenen, die te reinigen is, en op den duim zijner rechterhand, en op den groten teen zijns rechtervoets, boven op het bloed des schuldoffers. ");
INSERT INTO nld_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Dat nog overgebleven zal zijn van die olie, die in de hand des priesters geweest is, zal hij doen op het hoofd desgenen, die te reinigen is; zo zal de priester over hem verzoening doen voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","De priester zal ook het zondoffer bereiden, en voor hem, die van zijn onreinigheid te reinigen is, verzoening doen; en daarna zal hij het brandoffer slachten. ");
INSERT INTO nld_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","En de priester zal dat brandoffer en dat spijsoffer op het altaar offeren; zo zal de priester de verzoening voor hem doen, en hij zal rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Maar indien hij arm is, en zijn hand dat niet bereikt, zo zal hij een lam ten schuldoffer, ter beweging nemen, om voor hem verzoening te doen; daartoe een tiende meelbloem, met olie gemengd, ten spijsoffer, en een log olie; ");
INSERT INTO nld_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Mitsgaders twee tortelduiven, of twee jonge duiven, die zijn hand bereiken zal, welker ene ten zondoffer, en een ten brandoffer zijn zal. ");
INSERT INTO nld_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","En hij zal die, op den achtsten dag zijner reiniging, tot den priester brengen, aan de deur van de tent der samenkomst, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","En de priester zal het lam des schuldoffers, en den log der olie nemen; en de priester zal die ten beweegoffer voor het aangezicht des HEEREN bewegen. ");
INSERT INTO nld_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Daarna zal hij het lam des schuldoffers slachten, en de priester zal van het bloed des schuldoffers nemen, en doen op het rechteroorlapje desgenen, die te reinigen is, en op den duim zijner rechterhand, en op den groten teen zijns rechtervoets. ");
INSERT INTO nld_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ook zal de priester van die olie op des priesters linkerhand gieten. ");
INSERT INTO nld_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Daarna zal de priester met zijn rechtervinger van die olie, die op zijn linkerhand is, sprengen, zevenmaal, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","En de priester zal van de olie, die op zijn hand is, doen aan het lapje van het rechteroor desgenen, die te reinigen is, en aan den duim zijner rechterhand, en aan den groten teen zijns rechtervoets, op de plaats van het bloed des schuldoffers. ");
INSERT INTO nld_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","En het overgeblevene van de olie, die in de hand des priesters is, zal hij doen op het hoofd desgenen, die te reinigen is, om de verzoening voor hem te doen, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Daarna zal hij de ene van de tortelduiven, of van de jonge duiven bereiden, van hetgeen zijn hand bereikt zal hebben. ");
INSERT INTO nld_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Van hetgeen zijn hand bereikt zal hebben, zal het een ten zondoffer, en het een ten brandoffer zijn, boven het spijsoffer; zo zal de priester voor hem, die te reinigen is, verzoening doen voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Dit is de wet desgenen, in wien de plaag der melaatsheid zal zijn, wiens hand in zijn reiniging dat niet bereikt zal hebben. ");
INSERT INTO nld_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Verder sprak de HEERE tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Als gij zult gekomen zijn in het land van Kanaan, hetwelk Ik u tot bezitting geven zal, en Ik de plaag der melaatsheid aan een huis van dat land uwer bezitting zal gegeven hebben; ");
INSERT INTO nld_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Zo zal hij, van wien dat huis is, komen, en den priester te kennen geven, zeggende: Het schijnt mij, alsof er een plaag in het huis ware. ");
INSERT INTO nld_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","En de priester zal gebieden, dat zij dat huis ruimen, aleer de priester komt, om die plaag te bezien, opdat niet al wat in dat huis is, onrein worde; en daarna zal de priester komen, om dat huis te bezien. ");
INSERT INTO nld_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Als hij die plaag bezien zal, dat, ziet, die plaag aan de wanden van dat huis zijn groenachtige of roodachtige kuiltjes, en hun aanzien lager is dan die wand; ");
INSERT INTO nld_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","De priester zal uit dat huis uitgaan, aan de deur van het huis, en hij zal dat huis zeven dagen doen toesluiten. ");
INSERT INTO nld_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Daarna zal de priester op den zevenden dag wederkeren; indien hij merken zal, dat, ziet, die plaag aan de wanden van dat huis uitgespreid is; ");
INSERT INTO nld_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Zo zal de priester gebieden, dat zij de stenen, in welke die plaag is, uitbreken, en dezelve tot buiten de stad werpen, aan een onreine plaats; ");
INSERT INTO nld_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","En dat huis zal hij rondom van binnen doen schrabben, en zij zullen het stof, dat zij afgeschrabd hebben, tot buiten de stad aan een onreine plaats uitstorten. ");
INSERT INTO nld_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Daarna zullen zij andere stenen nemen, en in de plaats van gene stenen brengen; en men zal ander leem nemen, en dat huis bestrijken. ");
INSERT INTO nld_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Maar indien die plaag wederkeert, en in dat huis uitbot, nadat men de stenen uitgebroken heeft, en na het afschrabben van het huis, en nadat het zal bestreken zijn; ");
INSERT INTO nld_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Zo zal de priester komen; als hij nu zal merken, dat, ziet, die plaag aan dat huis uitgespreid is, het is een knagende melaatsheid in dat huis, het is onrein. ");
INSERT INTO nld_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Daarom zal men dat huis, zijn stenen, en zijn hout even afbreken, mitsgaders al het leem van het huis, en men zal het tot buiten de stad uitvoeren, aan een onreine plaats. ");
INSERT INTO nld_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","En die in dat huis gaat te enigen dage, als men hetzelve zal toegesloten hebben, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Die ook in dat huis te slapen ligt, zal zijn klederen wassen; insgelijks, die in dat huis eet, zal zijn klederen wassen. ");
INSERT INTO nld_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Maar als de priester zal weder ingegaan zijn, en zal merken, dat, ziet, die plaag aan dat huis niet uitgespreid is, nadat het huis zal bestreken zijn; zo zal de priester dat huis rein verklaren, dewijl die plaag genezen is. ");
INSERT INTO nld_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Daarna zal hij, om dat huis te ontzondigen, twee vogeltjes nemen, mitsgaders cederenhout, en scharlaken, en hysop. ");
INSERT INTO nld_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","En hij zal den enen vogel slachten in een aarden vat, over levend water. ");
INSERT INTO nld_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Dan zal hij dat cederenhout, en dien hysop, en het scharlaken, en den levenden vogel nemen, en zal die in het bloed des geslachten vogels en in het levende water dopen; en hij zal dat huis zevenmaal besprengen. ");
INSERT INTO nld_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Zo zal hij dat huis ontzondigen met het bloed des vogels, en met dat levend water, en met den levenden vogel, en met dat cederenhout, en met den hysop, en met het scharlaken. ");
INSERT INTO nld_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Den levenden vogel nu zal hij tot buiten de stad, in het open veld, laten vliegen; zo zal hij over het huis verzoening doen, en het zal rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Dit is de wet voor alle plage der melaatsheid, en voor schurftheid; ");
INSERT INTO nld_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","En voor melaatsheid der klederen, en der huizen; ");
INSERT INTO nld_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Mitsgaders voor gezwel, en voor gezweer, en voor blaren; ");
INSERT INTO nld_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Om te leren, op welken dag iets onrein, en op welken dag iets rein is. Dit is de wet der melaatsheid. ");
INSERT INTO nld_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Verder sprak de HEERE tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Spreekt tot de kinderen Israels, en zegt tot hen: Een ieder man, als hij vloeiende zal zijn uit zijn vlees, zal om zijn vloed onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Dit nu zal zijn onreinigheid om zijn vloed zijn: zo zijn vlees zijn vloed uitzevert, of zijn vlees van zijn vloed zich verstopt, dat is zijn onreinigheid. ");
INSERT INTO nld_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Alle leger, waarop hij, die den vloed heeft, zal liggen, zal onrein zijn, en alle tuig, waarop hij zal zitten, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Een ieder ook, die zijn leger zal aanroeren, zal zijn klederen wassen, en zich met water baden, en zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","En die op dat tuig zit, waarop hij, die den vloed heeft, gezeten zal hebben, zal zijn klederen wassen, en zich met water baden, en zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","En die het vlees desgenen, die den vloed heeft, aanroert, zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Als ook hij, die den vloed heeft, op een reine zal gespogen hebben, dan zal hij zijn klederen wassen, en zal zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Insgelijks alle zadel, waarop hij, die den vloed heeft, zal gereden hebben, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","En al wie iets aanroert, dat onder hem zal geweest zijn, zal onrein zijn tot aan den avond; en die hetzelve draagt, zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Daartoe een ieder, wien hij, die den vloed heeft, zal aangeroerd hebben, zonder zijn handen met water gespoeld te hebben, die zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ook het aarden vat, hetwelk hij, die den vloed heeft, zal aangeroerd hebben, zal gebroken worden; maar alle houten vat zal met water gespoeld worden. ");
INSERT INTO nld_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Als hij nu, die den vloed heeft, van zijn vloed gereinigd zal zijn, zo zal hij tot zijn reiniging zeven dagen voor zich tellen, en zijn klederen wassen, en hij zal zijn vlees met levend water baden, zo zal hij rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","En op den achtsten dag zal hij voor zich twee tortelduiven of twee jonge duiven nemen; en zal voor het aangezicht des HEEREN, aan de deur van de tent der samenkomst komen, en zal ze den priester geven. ");
INSERT INTO nld_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","En de priester zal die bereiden, een ten zondoffer, en een ten brandoffer; zo zal de priester over hem voor het aangezicht des HEEREN, vanwege zijn vloed, verzoening doen. ");
INSERT INTO nld_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Verder een man, als van hem het zaad des bijliggens zal uitgegaan zijn, die zal zijn ganse vlees met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ook alle kleed, en alle vel, aan hetwelk het zaad des bijliggens wezen zal, dat zal met water gewassen worden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mitsgaders de vrouw, als een man met het zaad des bijliggens bij haar gelegen zal hebben; daarom zullen zij zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Maar als een vrouw vloeiende zijn zal, zijnde haar vloed van bloed in haar vlees, zo zal zij zeven dagen in haar afzondering zijn; en al wie haar aanroert, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","En al hetgeen, waarop zij in haar afzondering zal gelegen hebben, zal onrein zijn; mitsgaders alles, waarop zij zal gezeten hebben, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","En al wie haar leger aanroert, zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ook al wie enig tuig, waarop zij gezeten zal hebben, aanroert, zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Zelfs indien het op het leger geweest zal zijn, of op het tuig, waarop zij zat, als hij dat aanroerde, hij zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Insgelijks zo iemand zekerlijk bij haar gelegen heeft, dat haar afzondering op hem zij, zo zal hij zeven dagen onrein zijn; daartoe alle leger, waarop hij zal gelegen hebben, zal onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wanneer ook een vrouw, vele dagen buiten den tijd harer afzondering, van den vloed haars bloeds vloeien zal, of wanneer zij vloeien zal boven hare afzondering, zij zal al den dagen van den vloed harer onreinigheid, als in de dagen harer afzondering onrein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Alle leger, waarop zij al de dagen haars vloeds gelegen zal hebben, zal haar zijn als het leger harer afzondering; en alle tuig, waarop zij zal gezeten hebben, zal onrein zijn, naar de onreinigheid harer afzondering. ");
INSERT INTO nld_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","En zo wie die dingen aanroert, zal onrein zijn; daarom zal hij zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Maar als zij van haar vloed rein wordt, dan zal zij voor zich zeven dagen tellen, daarna zal zij rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","En op den achtsten dag zal zij voor zich twee tortelduiven, of twee jonge duiven nemen, en zij zal die tot den priester brengen, aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Dan zal de priester een ten zondoffer en een ten brandoffer bereiden; en de priester zal voor haar, van den vloed harer onreinigheid, verzoening doen voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Alzo zult gij de kinderen Israels afzonderen van hun onreinigheid; opdat zij in hun onreinigheid niet sterven, als zij Mijn tabernakel, die in het midden van hen is, verontreinigen zouden. ");
INSERT INTO nld_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dit is de wet desgenen, die den vloed heeft, en van wien het zaad der bijligging uitgaat; zodat hij daardoor onrein wordt; ");
INSERT INTO nld_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Mitsgaders van een zwakke vrouw in haar afzondering, en van degene, die van zijn vloed is vloeiende, voor een man, en voor een vrouw; en voor een man, die bij een onreine zal gelegen hebben. ");
INSERT INTO nld_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","En de HEERE sprak tot Mozes, nadat de twee zonen van Aaron gestorven waren, als zij genaderd waren voor het aangezicht des HEEREN, en gestorven waren; ");
INSERT INTO nld_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","De HEERE dan zeide tot Mozes: Spreek tot uw broeder Aaron, dat hij niet te allen tijde ga in het heilige, binnen den voorhang, voor het verzoendeksel, dat op de ark is, opdat hij niet sterve; want Ik verschijn in een wolk op het verzoendeksel. ");
INSERT INTO nld_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Hiermede zal Aaron in het heilige gaan: met een var, een jong rund ten zondoffer, en een ram ten brandoffer. ");
INSERT INTO nld_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Hij zal den heiligen linnen rok aandoen, en een linnen onderbroek zal aan zijn vlees zijn, en met een linnen gordel zal hij zich gorden, en met een linnen hoed bedekken; dit zijn heilige klederen; daarom zal hij zijn vlees met water baden, als hij ze zal aandoen. ");
INSERT INTO nld_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","En aan de vergadering der kinderen Israels zal hij nemen twee geitenbokken ten zondoffer, en een ram ten brandoffer. ");
INSERT INTO nld_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Daarna zal Aaron den var des zondoffers, die voor hem zal zijn, offeren, en zal voor zich en voor zijn huis verzoening doen. ");
INSERT INTO nld_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hij zal ook beide bokken nemen, en hij zal die stellen voor het aangezicht des HEEREN, aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","En Aaron zal de loten over die twee bokken werpen: een lot voor den HEERE, en een lot voor den weggaanden bok. ");
INSERT INTO nld_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Dan zal Aaron den bok, op denwelken het lot voor den HEERE zal gekomen zijn, toebrengen, en zal hem ten zondoffer maken. ");
INSERT INTO nld_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Maar de bok, op denwelken het lot zal gekomen zijn, om een weggaande bok te zijn, zal levend voor het aangezicht des HEEREN gesteld worden, om door hem verzoening te doen; opdat men hem als een weggaanden bok naar de woestijn uitlate. ");
INSERT INTO nld_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron dan zal den var des zondoffers, die voor hemzelven zal zijn, toebrengen, en voor zichzelven en voor zijn huis verzoening doen, en zal den var des zondoffers, die voor hemzelven zal zijn, slachten. ");
INSERT INTO nld_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Hij zal ook een wierookvat vol vurige kolen nemen van het altaar, van voor het aangezicht des HEEREN, en zijn handen vol reukwerk van welriekende specerijen, klein gestoten; en hij zal het binnen den voorhang dragen. ");
INSERT INTO nld_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","En hij zal dat reukwerk op het vuur leggen, voor het aangezicht des HEEREN, opdat de nevel des reukwerks het verzoendeksel, hetwelk is op de getuigenis, bedekke, en dat hij niet sterve. ");
INSERT INTO nld_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","En hij zal van het bloed van den var nemen, en zal met zijn vinger op het verzoendeksel oostwaarts sprengen; en voor het verzoendeksel zal hij zevenmaal met zijn vinger van dat bloed sprengen. ");
INSERT INTO nld_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Daarna zal hij den bok des zondoffers, die voor het volk zal zijn, slachten, en zal zijn bloed tot binnen in den voorhang dragen, en zal met zijn bloed doen, gelijk als hij met het bloed van den var gedaan heeft, en zal dat sprengen op het verzoendeksel, en voor het verzoendeksel. ");
INSERT INTO nld_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Zo zal hij voor het heilige, vanwege de onreinigheden der kinderen Israels, en vanwege hun overtredingen, naar al hun zonden, verzoening doen; en alzo zal hij doen aan de tent der samenkomst, welke met hen woont in het midden hunner onreinigheden. ");
INSERT INTO nld_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","En geen mens zal in de tent der samenkomst zijn, als hij zal ingaan, om in het heilige verzoening te doen, totdat hij zal uitkomen; alzo zal hij verzoening doen, voor zichzelven, en voor zijn huis, en voor de gehele gemeente van Israel. ");
INSERT INTO nld_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Daarna zal hij tot het altaar, dat voor het aangezicht des HEEREN is, uitkomen, en verzoening voor hetzelve doen; en hij zal van het bloed van den var, en van het bloed van den bok nemen, en doen het rondom op de hoornen des altaars. ");
INSERT INTO nld_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","En hij zal daarop van dat bloed met zijn vinger zevenmaal sprengen, en hij zal dat reinigen en heiligen van de onreinigheden der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Als hij nu zal geeindigd hebben van het heilige, en de tent der samenkomst, en het altaar te verzoenen, zo zal hij dien levenden bok toebrengen. ");
INSERT INTO nld_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","En Aaron zal beide zijn handen op het hoofd van den levenden bok leggen, en zal daarop al de ongerechtigheden der kinderen Israels, en al hun overtredingen, naar al hun zonden, belijden; en hij zal die op het hoofd des boks leggen, en zal hem door de hand eens mans, die voorhanden is, naar de woestijn uitlaten. ");
INSERT INTO nld_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Alzo zal die bok op zich al hun ongerechtigheden in een afgezonderd land wegdragen; en hij zal dien bok in de woestijn uitlaten. ");
INSERT INTO nld_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Daarna zal Aaron komen in de tent der samenkomst, en zal de linnen klederen uitdoen, die hij aangedaan had, als hij in het heilige ging, en hij zal ze daar laten. ");
INSERT INTO nld_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","En hij zal zijn vlees in de heilige plaats met water baden, en zijn klederen aandoen; dan zal hij uitgaan, en zijn brandoffer, en het brandoffer des volks bereiden, en voor zich en voor het volk verzoening doen. ");
INSERT INTO nld_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ook zal hij het vet des zondoffers op het altaar aansteken. ");
INSERT INTO nld_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","En die den bok, welke een weggaande bok was, zal uitgelaten hebben, zal zijn klederen wassen, en zijn vlees met water baden; en daarna zal hij in het leger komen. ");
INSERT INTO nld_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Maar den var des zondoffers, en den bok des zondoffers, welker bloed ingebracht is, om verzoening te doen in het heilige, zal men tot buiten het leger uitvoeren; doch hun vellen, hun vlees en hun mest zullen zij met vuur verbranden. ");
INSERT INTO nld_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Die nu dezelve verbrandt, zal zijn klederen wassen, en zijn vlees met water baden; en daarna zal hij in het leger komen. ");
INSERT INTO nld_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","En dit zal voor u tot een eeuwige inzetting zijn: gij zult in de zevende maand, op den tienden der maand, uw zielen verootmoedigen, en geen werk doen, inboorling noch vreemdeling, die in het midden van u als vreemdeling verkeert. ");
INSERT INTO nld_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Want op dien dag zal hij voor u verzoening doen, om u te reinigen; van al uw zonden zult gij voor het aangezicht des HEEREN gereinigd worden. ");
INSERT INTO nld_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Dat zal u een sabbat der rust zijn, opdat gij uw zielen verootmoedigt; het is een eeuwige inzetting. ");
INSERT INTO nld_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","En de priester, dien men gezalfd, en wiens hand men gevuld zal hebben, om voor zijn vader het priesterambt te bedienen, zal de verzoening doen, als hij de linnen klederen, de heilige klederen, zal aangetrokken hebben. ");
INSERT INTO nld_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Zo zal hij het heilige heiligdom verzoenen, en de tent der samenkomst, en het altaar zal hij verzoenen; desgelijks voor de priesteren, en voor al het volk der gemeente zal hij verzoening doen. ");
INSERT INTO nld_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","En dit zal u tot een eeuwige inzetting zijn, om voor de kinderen Israels van al hun zonden, eenmaal des jaars, verzoening te doen. En men deed, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Spreek tot Aaron, en tot zijn zonen, en tot al de kinderen Israels, en zeg tot hen: Dit is het woord, hetwelk de HEERE geboden heeft, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Een ieder van het huis Israels, die een os, of lam, of geit in het leger slachten zal, of die ze slachten zal buiten het leger; ");
INSERT INTO nld_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","En dezelve aan de deur van de tent der samenkomst niet brengen zal, om een offerande den HEERE voor den tabernakel des HEEREN te offeren; het bloed zal dienzelven man toegerekend worden, hij heeft bloed vergoten; daarom zal dezelve man uit het midden zijns volks uitgeroeid worden; ");
INSERT INTO nld_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Opdat, wanneer de kinderen Israels hun slachtofferen brengen, welke zij op het veld slachten, dat zij die den HEERE toebrengen, aan de deur van de tent der samenkomst tot den priester, en dezelve tot dankofferen den HEERE slachten. ");
INSERT INTO nld_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","En de priester zal het bloed op het altaar des HEEREN, aan de deur van de tent der samenkomst, sprengen; en hij zal het vet aansteken, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","En zij zullen ook niet meer hun slachtofferen den duivelen, welke zij nahoereren, offeren; dat zal hun een eeuwige inzetting zijn voor hun geslachten. ");
INSERT INTO nld_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Zeg dan tot hen: Een ieder van het huis Israels, en van de vreemdelingen, die in het midden van hen als vreemdelingen verkeren, die een brandoffer of slachtoffer zal offeren, ");
INSERT INTO nld_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","En dat tot de deur van de tent der samenkomst niet zal brengen, om hetzelve den HEERE te bereiden; diezelve man zal uit zijn volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","En een ieder uit het huis Israels, en uit de vreemdelingen, die in het midden van hen als vreemdelingen verkeren, die enig bloed zal gegeten hebben, tegen diens ziel, die dat bloed zal gegeten hebben, zal Ik Mijn aangezicht zetten, en zal die uit het midden haars volks uitroeien. ");
INSERT INTO nld_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Want de ziel van het vlees is in het bloed; daarom heb Ik het u op het altaar gegeven, om over uw zielen verzoening te doen; want het is het bloed, dat voor de ziel verzoening zal doen. ");
INSERT INTO nld_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Daarom heb Ik tot de kinderen Israels gezegd: Geen ziel van u zal bloed eten; noch de vreemdeling, die als vreemdeling in het midden van u verkeert, zal bloed eten. ");
INSERT INTO nld_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Een ieder ook van de kinderen Israels en van de vreemdelingen, die als vreemdelingen in het midden van hen verkeren, die enig wild gedierte, of gevogelte, dat gegeten wordt, in de jacht gevangen zal hebben; die zal deszelfs bloed vergieten, en zal dat met stof bedekken. ");
INSERT INTO nld_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Want het is de ziel van alle vlees; zijn bloed is voor zijn ziel; daarom heb Ik tot de kinderen Israels gezegd: Gij zult geens vleses bloed eten; want de ziel van alle vlees, dat is zijn bloed; zo wie dat eet, zal uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","En alle ziel onder de inboorlingen of onder de vreemdelingen, die een dood aas of het verscheurde zal gegeten hebben, die zal zijn klederen wassen, en zich met water baden, en onrein zijn tot aan den avond; daarna zal hij rein zijn. ");
INSERT INTO nld_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Maar indien hij die niet wast, en zijn vlees niet baadt, zo zal hij zijn ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Spreek tot de kinderen Israels en zeg tot hen: Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Gij zult niet doen naar de werken des Egyptischen lands, waarin gij gewoond hebt; en naar de werken des lands Kanaan, waarheen Ik u brenge, zult gij niet doen, en zult in hun inzettingen niet wandelen. ");
INSERT INTO nld_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mijn rechten zult gij doen, en Mijn inzettingen zult gij houden, om in die te wandelen; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ja, Mijn inzettingen en Mijn rechten zult gij houden; welk mens dezelve zal doen, die zal door dezelve leven; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niemand zal tot enige nabestaande zijns vleses naderen, om de schaamte te ontdekken; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Gij zult de schaamte uws vaders en de schaamte uwer moeder niet ontdekken; zij is uw moeder; gij zult haar schaamte niet ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Gij zult de schaamte der huisvrouw uws vaders niet ontdekken; het is de schaamte uws vaders. ");
INSERT INTO nld_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","De schaamte uwer zuster, der dochter uws vaders, of der dochter uwer moeder, te huis geboren of buiten geboren, haar schaamte zult gij niet ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","De schaamte der dochter uws zoons, of der dochter uwer dochter, haar schaamte zult gij niet ontdekken; want zij zijn uw schaamte. ");
INSERT INTO nld_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","De schaamte van de dochter der huisvrouw uws vaders, die uw vader geboren is (zij is uw zuster), haar schaamte zult gij niet ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Gij zult de schaamte van de zuster uws vaders niet ontdekken; zij is uws vaders nabestaande. ");
INSERT INTO nld_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Gij zult de schaamte van de zuster uwer moeder niet ontdekken; want zij is uwer moeder nabestaande. ");
INSERT INTO nld_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Gij zult de schaamte van den broeder uws vaders niet ontdekken; tot zijn huisvrouw zult gij niet naderen; zij is uw moei. ");
INSERT INTO nld_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Gij zult de schaamte uwer schoondochter niet ontdekken; zij is uws zoons huisvrouw; gij zult haar schaamte niet ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Gij zult de schaamte der huisvrouw uws broeders niet ontdekken; het is de schaamte uws broeders. ");
INSERT INTO nld_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Gij zult de schaamte ener vrouw en harer dochter niet ontdekken; de dochter haars zoons, noch de dochter van haar dochter zult gij nemen, om haar schaamte te ontdekken; zij zijn nabestaanden; het is een schandelijke daad. ");
INSERT INTO nld_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Gij zult ook geen vrouw tot haar zuster nemen, om haar te benauwen, mits haar schaamte nevens haar, in haar leven, te ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ook zult gij tot de vrouw in de afzondering van haar onreinigheid niet naderen, om haar schaamte te ontdekken. ");
INSERT INTO nld_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","En gij zult niet liggen bij uws naasten huisvrouw ter bezading, om met haar onrein te worden. ");
INSERT INTO nld_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","En van uw zaad zult gij niet geven, om voor den Molech door het vuur te doen gaan; en den Naam uws Gods zult gij niet ontheiligen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Bij een manspersoon zult gij niet liggen met vrouwelijke bijligging; dit is een gruwel. ");
INSERT INTO nld_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Insgelijks zult gij bij geen beest liggen, om daarmede onrein te worden; een vrouw zal ook niet staan voor een beest, om daarmede te doen te hebben; het is een gruwelijke vermenging. ");
INSERT INTO nld_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Verontreinigt u niet met enige van deze; want de heidenen, die Ik van uw aangezicht uitwerpe, zijn met alle deze verontreinigd; ");
INSERT INTO nld_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Zodat het land onrein is, en Ik over hetzelve zijn ongerechtigheid bezoeke, en het land zijn inwoners uitspuwt. ");
INSERT INTO nld_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Maar gij zult Mijn inzettingen en Mijn rechten onderhouden, en van al die gruwelen niets doen, inboorling noch vreemdeling, die in het midden van u als vreemdeling verkeert. ");
INSERT INTO nld_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Want de lieden dezes lands, die voor u geweest zijn, hebben al deze gruwelen gedaan; en het land is onrein geworden. ");
INSERT INTO nld_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Dat u dat land niet uitspuwe, als gij hetzelve zult verontreinigd hebben; gelijk als het het volk, dat voor u was, uitgespuwd heeft. ");
INSERT INTO nld_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Want al wie enige van deze gruwelen doen zal, die zielen, die ze doen, zullen uit het midden van haar volk uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Daarom zult gij Mijn bevel onderhouden, dat gij niet doet van die gruwelijke inzettingen, die voor u zijn gedaan geweest, en u daarmede niet verontreinigt; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Spreek tot de ganse vergadering der kinderen Israels, en zeg tot hen: Gij zult heilig zijn, want Ik, de HEERE, uw God, ben heilig! ");
INSERT INTO nld_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Want ieder zal zijn moeder en zijn vader vrezen, en Mijn sabbatten houden; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Gij zult u tot de afgoden niet keren, en u geen gegoten goden maken; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","En wanneer gij een dankoffer den HEERE offeren zult, naar uw welgevallen zult gij dat offeren. ");
INSERT INTO nld_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Op den dag van uw offeren, en des anderen daags, zal het gegeten worden; maar wat tot op den derden dag overblijft zal met vuur verbrand worden. ");
INSERT INTO nld_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","En zo het op den derden dag enigszins gegeten wordt, het is een afgrijselijk ding, het zal niet aangenaam zijn. ");
INSERT INTO nld_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","En zo wie dat eet, zal zijn ongerechtigheid dragen, omdat hij het heilige des HEEREN ontheiligd heeft; daarom zal dezelve ziel, uit haar volken uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Als gij ook den oogst uws lands inoogsten zult, gij zult den hoek uws velds niet ganselijk afoogsten, en dat van uw oogst op te zamelen is, niet opzamelen. ");
INSERT INTO nld_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Insgelijks zult gij uw wijngaard niet nalezen, en de afgevallen bezien van uw wijngaard niet opzamelen; den arme en den vreemdeling zult gij die overlaten; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Gij zult niet stelen, en gij zult niet liegen, noch valselijk handelen, een iegelijk tegen zijn naaste. ");
INSERT INTO nld_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Gij zult niet valselijk bij Mijn Naam zweren; want gij zoudt den Naam uws Gods ontheiligen; Ik ben de HEERE. ");
INSERT INTO nld_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Gij zult uw naaste niet bedriegelijk verdrukken, noch beroven; des dagloners arbeidsloon zal bij u niet vernachten tot aan den morgen. ");
INSERT INTO nld_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Gij zult den dove niet vloeken, en voor het aangezicht des blinden geen aanstoot zetten; maar gij zult voor uw God vrezen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Gij zult geen onrecht doen in het gericht; gij zult het aangezicht des geringen niet aannemen, noch het aangezicht des groten voortrekken; in gerechtigheid zult gij uw naaste richten. ");
INSERT INTO nld_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Gij zult niet wandelen als een achterklapper onder uw volken; gij zult niet staan tegen het bloed van uw naaste; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Gij zult uw broeder in uw hart niet haten; gij zult uw naaste naarstiglijk berispen, en zult de zonde in hem niet verdragen. ");
INSERT INTO nld_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Gij zult niet wreken, noch toorn behouden tegen de kinderen uws volks; maar gij zult uw naaste liefhebben als uzelven; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Gij zult Mijn inzettingen houden; gij zult geen tweeerlei aard uwer beesten laten samen te doen hebben; uwen akker zult gij niet met tweeerlei zaad bezaaien, en een kleed van tweeerlei stof, dooreen vermengd, zal aan u niet komen. ");
INSERT INTO nld_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","En wanneer een man, door bijligging des zaads, bij een vrouw zal gelegen hebben, die een dienstmaagd is, bij den man versmaad, en geenszins gelost is, en haar geen vrijheid is gegeven; die zullen gegeseld worden; zij zullen niet gedood worden; want zij was niet vrij gemaakt. ");
INSERT INTO nld_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","En hij zal zijn schuldoffer den HEERE aan de deur van de tent der samenkomst brengen, een ram ten schuldoffer. ");
INSERT INTO nld_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","En de priester zal met den ram des schuldoffers, voor hem over zijn zonde, die hij gezondigd heeft, voor het aangezicht des HEEREN verzoening doen; en hem zal vergeving geschieden van zijn zonde, die hij gezondigd heeft. ");
INSERT INTO nld_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Als gij ook in dat land gekomen zult zijn, en alle geboomte ter spijze geplant zult hebben, zo zult gij de voorhuid daarvan, deszelfs vrucht, besnijden; drie jaren zal het u onbesneden zijn, daarvan zal niet gegeten worden. ");
INSERT INTO nld_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Maar in het vierde jaar zal al zijn vrucht een heilig ding zijn, ter lofzegging voor den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","En in het vijfde jaar zult gij deszelfs vrucht eten, om het inkomen daarvan voor u te vermeerderen; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Gij zult niets met het bloed eten. Gij zult op geen vogelgeschrei acht geven, noch guichelarij plegen. ");
INSERT INTO nld_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Gij zult de hoeken uws hoofds niet rond afscheren; ook zult gij de hoeken uws baards niet verderven. ");
INSERT INTO nld_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Gij zult om een dood lichaam geen snijding in uw vlees maken, noch schrift van een ingedrukt teken in u maken; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Gij zult uw dochter niet ontheiligen, haar ter hoererij houdende; opdat het land niet hoerere, en het land met schandelijke daden vervuld worde. ");
INSERT INTO nld_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Gij zult Mijn sabbatten houden, en Mijn heiligdom zult gij vrezen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Gij zult u niet keren tot de waarzeggers, en tot de duivelskunstenaars; zoekt hen niet, u met hen verontreinigende; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Voor het grauwe haar zult gij opstaan, en zult het aangezicht des ouden vereren; en gij zult vrezen voor uw God; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","En wanneer een vreemdeling bij u in uw land als vreemdeling verkeren zal, gij zult hem niet verdrukken. ");
INSERT INTO nld_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","De vreemdeling, die als vreemdeling bij u verkeert, zal onder u zijn als een inboorling van ulieden; gij zult hem liefhebben als uzelven; want gij zijt vreemdeling geweest in Egypteland; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Gij zult geen onrecht doen in het gericht, met de el, met het gewicht, of met de maat. ");
INSERT INTO nld_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Gij zult een rechte wage hebben, rechte weegstenen, een rechte efa, en een rechte hin; Ik ben de HEERE, uw God, die u uit Egypteland uitgevoerd heb! ");
INSERT INTO nld_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Daarom zult gij al Mijn inzettingen en al Mijn rechten onderhouden, en zult ze doen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Gij zult ook tot de kinderen Israels zeggen: Een ieder uit de kinderen Israels, of uit de vreemdelingen, die in Israel als vreemdelingen verkeren, die van zijn zaad den Molech gegeven zal hebben, zal zekerlijk gedood worden; het volk des lands zal hem met stenen stenigen. ");
INSERT INTO nld_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","En Ik zal Mijn aangezicht tegen dien man zetten, en zal hem uit het midden zijns volks uitroeien; want hij heeft van zijn zaad den Molech gegeven, opdat hij Mijn heiligdom ontreinigen, en Mijn heiligen Naam ontheiligen zou. ");
INSERT INTO nld_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","En indien het volk des lands hun ogen enigszins verbergen zal van dien man, als hij van zijn zaad den Molech zal gegeven hebben, dat het hem niet dode; ");
INSERT INTO nld_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Zo zal Ik Mijn aangezicht tegen dien man en tegen zijn huisgezin zetten, en Ik zal hem, en al degenen, die hem nahoereren, om den Molech na te hoereren, uit het midden huns volks uitroeien. ");
INSERT INTO nld_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Wanneer er een ziel is, die zich tot de waarzeggers en tot de duivelskunstenaars zal gekeerd hebben, om die na te hoereren, zo zal Ik Mijn aangezicht tegen die ziel zetten, en zal ze uit het midden haars volks uitroeien. ");
INSERT INTO nld_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Daarom heiligt u, en weest heilig; want Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","En onderhoudt Mijn inzettingen, en doet dezelve; Ik ben de HEERE, die u heilige. ");
INSERT INTO nld_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Als er iemand is, die zijn vader of zijn moeder zal gevloekt hebben, die zal zekerlijk gedood worden; hij heeft zijn vader of zijn moeder gevloekt; zijn bloed is op hem! ");
INSERT INTO nld_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Een man ook, die met iemands huisvrouw overspel zal gedaan hebben, dewijl hij met zijns naasten vrouw overspel gedaan heeft, zal zekerlijk gedood worden, de overspeler en de overspeelster. ");
INSERT INTO nld_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","En een man, die bij zijns vaders huisvrouw zal gelegen hebben, heeft zijns vaders schaamte ontdekt; zij beiden zullen zekerlijk gedood worden; hun bloed is op hen! ");
INSERT INTO nld_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Insgelijks, als de man bij de vrouw zijns zoons zal gelegen hebben, zij zullen beiden zekerlijk gedood worden; zij hebben een gruwelijke vermenging gedaan; hun bloed is op hen! ");
INSERT INTO nld_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Wanneer ook een man bij een manspersoon zal gelegen hebben, met vrouwelijke bijligging, zij hebben beiden een gruwel gedaan; zij zullen zekerlijk gedood worden; hun bloed is op hen! ");
INSERT INTO nld_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","En wanneer een man een vrouw en haar moeder zal genomen hebben, het is een schandelijke daad; men zal hem, en diezelve met vuur verbranden, opdat geen schandelijke daad in het midden van u zij. ");
INSERT INTO nld_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Daartoe als een man bij enig vee zal gelegen hebben, hij zal zekerlijk gedood worden; ook zult gijlieden het beest doden. ");
INSERT INTO nld_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Alzo wanneer een vrouw tot enig beest genaderd zal zijn, om daarmede te doen te hebben, zo zult gij die vrouw en dat beest doden; zij zullen zekerlijk gedood worden; hun bloed is op hen! ");
INSERT INTO nld_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","En als een man zijn zuster, de dochter zijns vaders, of de dochter zijner moeder, zal genomen hebben, en hij haar schaamte gezien, en zij zijn schaamte zal gezien hebben, het is een schandvlek; daarom zullen zij voor de ogen van de kinderen huns volks uitgeroeid worden; hij heeft de schaamte zijner zuster ontdekt, hij zal zijn ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","En als een man bij een vrouw, die haar krankheid heeft, zal gelegen en haar schaamte ontdekt, haar fontein ontbloot, en zij zelve de fontein haars bloeds ontdekt zal hebben, zo zullen zij beiden uit het midden huns volks uitgeroeid worden. ");
INSERT INTO nld_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Daartoe zult gij de schaamte van de zuster uwer moeder, en van de zuster uws vaders niet ontdekken; dewijl hij zijn nabestaande ontbloot heeft, zullen zij hun ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Als ook een man bij zijn moei zal gelegen hebben, hij heeft de schaamte zijns ooms ontdekt; zij zullen hun zonde dragen; zonder kinderen zullen zij sterven. ");
INSERT INTO nld_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","En wanneer een man zijns broeders huisvrouw zal genomen hebben, het is onreinigheid; hij heeft de schaamte zijns broeders ontdekt; zij zullen zonder kinderen zijn. ");
INSERT INTO nld_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Onderhoudt dan al Mijn inzettingen en al Mijn rechten, en doet dezelve; opdat u dat land, waarheen Ik u brenge, om daarin te wonen, niet uitspuwe. ");
INSERT INTO nld_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","En wandelt niet in de inzettingen des volks, hetwelk Ik voor uw aangezicht uitwerp; want al deze dingen hebben zij gedaan; daarom ben Ik op hen verdrietig geworden. ");
INSERT INTO nld_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","En Ik heb u gezegd: Gij zult hun land erfelijk bezitten, en Ik zal u dat geven, opdat gij hetzelve erfelijk bezit, een land vloeiende van melk en honig; Ik ben de HEERE, uw God, Die u van de volken afgezonderd heb! ");
INSERT INTO nld_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Daarom zult gij onderscheid maken tussen reine en onreine beesten, en tussen het onreine en reine gevogelte; en gij zult uw zielen niet verfoeilijk maken aan de beesten en aan het gevogelte, en aan al wat op den aardbodem kruipt, hetwelk Ik voor u afgezonderd heb, opdat gij het onrein houdt. ");
INSERT INTO nld_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","En gij zult Mij heilig zijn, want Ik, de HEERE, ben heilig; en Ik heb u van de volken afgezonderd, opdat gij Mijns zoudt zijn. ");
INSERT INTO nld_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Als nu een man en vrouw in zich een waarzeggenden geest zal hebben, of een duivelskunstenaar zal zijn, zij zullen zekerlijk gedood worden; men zal hen met stenen stenigen; hun bloed is op hen. ");
INSERT INTO nld_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Daarna zeide de HEERE tot Mozes: Spreek tot de priesters, de zonen van Aaron, en zeg tot hen: Over een dode zal een priester zich niet verontreinigen onder zijn volken. ");
INSERT INTO nld_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Behalve over zijn bloedvriend, die hem ten naaste bestaat, over zijn moeder en over zijn vader, en over zijn zoon, en over zijn dochter, en over zijn broeder. ");
INSERT INTO nld_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","En over zijn zuster, die maagd is, hem nabestaande, die nog geen man toebehoord heeft; over die zal hij zich verontreinigen. ");
INSERT INTO nld_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Hij zal zich niet verontreinigen over een overste onder zijn volken, om zich te ontheiligen. ");
INSERT INTO nld_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Zij zullen op hun hoofd geen kaalheid maken, en zullen den hoek van hun baard niet afscheren, en in hun vlees zullen zij geen sneden snijden. ");
INSERT INTO nld_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Zij zullen hun God heilig zijn, en den Naam huns Gods zullen zij niet ontheiligen; want zij offeren de vuurofferen des HEEREN, de spijze huns Gods; daarom zullen zij heilig zijn. ");
INSERT INTO nld_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Zij zullen geen vrouw nemen, die een hoer of ontheiligde is, noch een vrouw nemen, die van haar man verstoten is; want hij is zijn God heilig. ");
INSERT INTO nld_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Daarom zult gij hem heiligen, omdat hij de spijze uws Gods offert; hij zal u heilig zijn, want Ik ben heilig; Ik ben de HEERE, die u heilige! ");
INSERT INTO nld_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Als nu de dochter van enigen priester zal beginnen te hoereren, zij ontheiligt haar vader; met vuur zal zij verbrand worden. ");
INSERT INTO nld_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","En hij, die de hogepriester onder zijn broederen is, op wiens hoofd de zalfolie gegoten is, en wiens hand men gevuld heeft, om die klederen aan te trekken, zal zijn hoofd niet ontbloten, noch zijn klederen scheuren. ");
INSERT INTO nld_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hij zal ook bij geen dode lichamen komen; zelfs over zijn vader en over zijn moeder zal hij zich niet verontreinigen. ");
INSERT INTO nld_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","En uit het heiligdom zal hij niet uitgaan, dat hij het heiligdom zijns Gods niet ontheilige, want de kroon der zalfolie zijns Gods is op hem; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Hij zal ook een vrouw in haar maagdom nemen. ");
INSERT INTO nld_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Een weduwe, of verstotene, of ontheiligde hoer, dezulke zal hij niet nemen; maar een maagd uit zijn volken zal hij tot een vrouw nemen. ");
INSERT INTO nld_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","En hij zal zijn zaad onder zijn volken niet ontheiligen; want Ik ben de HEERE, die hem heilige! ");
INSERT INTO nld_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Wijders sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Spreek tot Aaron, zeggende: Niemand uit uw zaad, naar hun geslachten, in wien een gebrek zal zijn, zal naderen, om de spijze zijns Gods te offeren. ");
INSERT INTO nld_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Want geen man, in wien een gebrek zal zijn, zal naderen, hij zij een blind man, of kreupel, of te kort, of te lang in leden; ");
INSERT INTO nld_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Of een man, in wien een breuk des voets, of een breuk der hand zal zijn; ");
INSERT INTO nld_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Of die bultachtig, of dwergachtig zal zijn, of een vel op zijn oog zal hebben, of droge schurftheid, of etterige schurftheid, of die gebroken zal zijn aan zijn gemacht. ");
INSERT INTO nld_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Geen man, uit het zaad van Aaron, den priester, in wien een gebrek is, zal toetreden om de vuurofferen des HEEREN te offeren; een gebrek is in hem, hij zal niet toetreden, om de spijs zijns Gods te offeren. ");
INSERT INTO nld_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","De spijs zijns Gods, van de allerheiligste dingen, en van de heilige dingen, zal hij mogen eten; ");
INSERT INTO nld_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Doch tot den voorhang zal hij niet komen, en tot het altaar niet toetreden, omdat een gebrek in hem is; opdat hij Mijn heiligdommen niet ontheilige; want Ik ben de HEERE, die hen heilige! ");
INSERT INTO nld_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","En Mozes sprak zulks tot Aaron en tot zijn zonen, en tot al de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Spreek tot Aaron en tot zijn zonen, dat zij zich van de heilige dingen der kinderen Israels, die zij Mij heiligen, afzonderen, opdat zij de Naam Mijner heiligheid niet ontheiligen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Zeg tot hen: Alle man onder uw geslachten, die uit uw ganse zaad tot de heilige dingen, die de kinderen Israels den HEERE heiligen, naderen zal, als zijn onreinigheid op hem is; diezelve mens zal van voor Mijn aangezicht uitgeroeid worden; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Niemand van het zaad van Aaron, die melaats is, of een vloed heeft, zal van die heilige dingen eten, totdat hij rein is; mitsgaders die iets aanroert, dat onrein is van een dood lichaam, of iemand, wien het zaad der bijligging ontgaat. ");
INSERT INTO nld_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Of zo wie aangeroerd zal hebben enig kruipend gedierte, waarvan hij onrein is, of een mens, waarvan hij onrein is, naar al zijn onreinigheid; ");
INSERT INTO nld_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","De mens, die dat aangeroerd zal hebben, zal onrein zijn tot aan den avond, en hij zal van die heilige dingen niet eten, maar zal zijn vlees met water baden. ");
INSERT INTO nld_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Als de zon zal ondergegaan zijn, dan zal hij rein zijn; en daarna zal hij van die heilige dingen eten; want dat is zijn spijze. ");
INSERT INTO nld_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Het dode aas, en het verscheurde zal hij niet eten, om daarmede onrein te worden; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Zij zullen dan Mijn bevel onderhouden, opdat zij geen zonde daarover dragen en daarin sterven, als zij die ontheiligd zouden hebben; Ik ben de HEERE, die hen heilige! ");
INSERT INTO nld_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ook zal geen vreemde het heilige eten; een bijwoner des priesters, en een dagloner, zullen het heilige niet eten. ");
INSERT INTO nld_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Wanneer dan nog de priester een ziel met zijn geld zal gekocht hebben, die zal daarvan eten; en de ingeborene van zijn huis, die zullen van zijn spijze eten. ");
INSERT INTO nld_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Maar als des priesters dochter een vreemden man zal toebehoren, zij zal van het hefoffer der heilige dingen niet eten. ");
INSERT INTO nld_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Doch als des priesters dochter een weduwe of een verstotene zal zijn, en geen zaad hebben, en tot haars vaders huis, als in haar jonkheid, zal wedergekeerd zijn, zo zal zij van de spijze haars vaders eten; maar geen vreemde zal daarvan eten. ");
INSERT INTO nld_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","En wanneer iemand het heilige door dwaling zal gegeten hebben, zo zal hij deszelfs vijfde deel daarboven toedoen, en zal het den priester met het heilige wedergeven. ");
INSERT INTO nld_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Zo zullen zij niet ontheiligen de heilige dingen der kinderen Israels, die zij den HEERE zullen gegeven hebben; ");
INSERT INTO nld_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","En hen doen dragen de ongerechtigheid der schuld, als zij hun heilige dingen zouden eten; want Ik ben de HEERE, Die hen heilige! ");
INSERT INTO nld_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Spreek tot Aaron, en tot zijn zonen, en tot al de kinderen Israels, en zeg tot hen: Zo wie uit het huis van Israel, en uit de vreemdelingen in Israel is, die zijn offerande zal offeren naar al hun geloften, en naar al hun vrijwillige offeren, die zij den HEERE ten brandoffer zullen offeren; ");
INSERT INTO nld_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Het zal naar uw welgevallen zijn, een volkomen mannetje, van de runderen, van de lammeren, of van de geiten. ");
INSERT INTO nld_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Gij zult niet offeren iets, waarin een gebrek is; want het zou niet aangenaam zijn voor u. ");
INSERT INTO nld_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","En als iemand een dankoffer den HEERE zal offeren, uitzonderende van de runderen of van de schapen een gelofte, of vrijwillig offer, het zal volkomen zijn, opdat het aangenaam zij; geen gebrek zal daarin zijn. ");
INSERT INTO nld_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Het blinde, of gebrokene, of verlamde, of wratte, of droge schurftheid, of etterige schurftheid hebbende, deze zult gij den HEERE niet offeren, en daarvan zult gij den HEERE geen vuuroffer op het altaar geven. ");
INSERT INTO nld_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Doch een os, of klein vee, te lang of te verkrompen in leden, die zult gij tot een vrijwillig offer bereiden; doch tot een gelofte zou het niet aangenaam zijn. ");
INSERT INTO nld_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Het gedrukte, of gestotene, of gescheurde, of gesnedene, zult gij den HEERE niet offeren; dat zult gij in uw land niet doen. ");
INSERT INTO nld_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Gij zult ook uit de hand des vreemden van al deze dingen uw God geen spijs offeren; want hun verdorvenheid is in hen, in dezelve is gebrek, zij zouden niet aangenaam zijn voor u. ");
INSERT INTO nld_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Wijders sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Wanneer een os, of lam, of geit zal geboren zijn, zo zal die zeven dagen onder zijn moeder zijn; daarna, van den achtsten dag en daarover, zal hij aangenaam zijn tot offerande des vuuroffers den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Gij zult ook een os, of klein vee, hem en zijn jong, op een dag niet slachten. ");
INSERT INTO nld_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","En als gij een lofoffer den HEERE zult slachten, naar uw wil zult gij het slachten. ");
INSERT INTO nld_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Het zal op denzelfden dag gegeten worden; gij zult daarvan niet overlaten tot op den morgen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Daarom zult gij Mijn geboden houden, en dezelve doen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","En gij zult Mijn heiligen Naam niet ontheiligen, opdat Ik in het midden der kinderen Israels geheiligd worde; Ik ben de HEERE, die u heilige! ");
INSERT INTO nld_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Die u uit Egypteland uitgevoerd heb, opdat Ik u tot een God zij; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Spreek tot de kinderen Israels, en zeg tot hen: De gezette hoogtijden des HEEREN, welke gijlieden uitroepen zult, zullen heilige samenroepingen zijn; deze zijn Mijn gezette hoogtijden. ");
INSERT INTO nld_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Zes dagen zal men het werk doen, maar op den zevenden dag is de sabbat der rust, een heilige samenroeping; geen werk zult gij doen; het is des HEEREN sabbat, in al uw woningen. ");
INSERT INTO nld_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Deze zijn de gezette hoogtijden des HEEREN, de heilige samenroepingen, welke gij uitroepen zult op hun gezetten tijd. ");
INSERT INTO nld_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In de eerste maand, op den veertienden der maand, tussen twee avonden is des HEEREN pascha. ");
INSERT INTO nld_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","En op den vijftienden dag der derzelver maand is het feest van de ongezuurde broden des HEEREN; zeven dagen zult gij ongezuurde broden eten. ");
INSERT INTO nld_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Op den eersten dag zult gij een heilige samenroeping hebben; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Maar gij zult zeven dagen vuuroffer den HEERE offeren; en op den zevenden dag zal een heilige samenroeping wezen; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Spreek tot de kinderen Israels, en zeg tot hen: Als gij in het land zult gekomen zijn, hetwelk Ik u geven zal, en gij zijn oogst zult inoogsten, dan zult gij een garf der eerstelingen van uw oogst tot den priester brengen. ");
INSERT INTO nld_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","En hij zal die garf voor het aangezicht des HEEREN bewegen, opdat het voor u aangenaam zij; des anderen daags na den sabbat zal de priester die bewegen. ");
INSERT INTO nld_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Gij zult ook op den dag, als gij die garf bewegen zult, bereiden een volkomen lam, dat eenjarig is, ten brandoffer den HEERE; ");
INSERT INTO nld_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","En zijn spijsoffer twee tienden meelbloem, met olie gemengd, ten vuuroffer, den HEERE tot een liefelijken reuk; en zijn drankoffer van wijn, het vierde deel van een hin. ");
INSERT INTO nld_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","En gij zult geen brood, noch geroost koren, noch groene aren eten, tot op dienzelven dag, dat gij de offerande uws Gods zult gebracht hebben; het is een eeuwige inzetting voor uw geslachten, in al uw woningen. ");
INSERT INTO nld_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Daarna zult gij u tellen van den anderen dag na den sabbat, van den dag, dat gij de garf des beweegoffers zult gebracht hebben; het zullen zeven volkomen sabbatten zijn; ");
INSERT INTO nld_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Tot den anderen dag, na den zevenden sabbat, zult gij vijftig dagen tellen, dan zult gij een nieuw spijsoffer den HEERE offeren. ");
INSERT INTO nld_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Gijlieden zult uit uw woningen twee beweegbroden brengen, zij zullen van twee tienden meelbloem zijn, gedesemd zullen zij gebakken worden; het zijn de eerstelingen den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Gij zult ook met het brood zeven volkomen eenjarige lammeren, en een var, het jong van een rund, en twee rammen offeren; zij zullen den HEERE een brandoffer zijn, met hun spijsoffer en hun drankofferen, een vuuroffer, tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ook zult gij een geitenbok ten zondoffer, en twee eenjarige lammeren ten dankoffer bereiden. ");
INSERT INTO nld_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Dan zal de priester dezelve met het brood der eerstelingen ten beweegoffer, voor het aangezicht des HEEREN, met de twee lammeren bewegen; zij zullen den HEERE een heilig ding zijn, voor den priester. ");
INSERT INTO nld_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","En gij zult op dienzelfden dag uitroepen, dat gij een heilige samenroeping zult hebben; geen dienstwerk zult gij doen; het is een eeuwige inzetting in al uw woningen voor uw geslachten. ");
INSERT INTO nld_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Als gij nu den oogst uws lands zult inoogsten, gij zult, in uw inoogsten, den hoek des velds niet ganselijk afmaaien, en de opzameling van uw oogst niet opzamelen; voor den arme en voor den vreemdeling zult gij ze laten; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Spreek tot de kinderen Israels, zeggende: In de zevende maand, op den eersten der maand, zult gij een rust hebben, een gedachtenis des geklanks, een heilige samenroeping. ");
INSERT INTO nld_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Geen dienstwerk zult gij doen; maar gij zult den HEERE vuuroffer offeren. ");
INSERT INTO nld_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Doch op den tienden dezer zevende maand zal de verzoendag zijn, een heilige samenroeping zult gij hebben; dan zult gij uw zielen verootmoedigen, en zult den HEERE een vuuroffer offeren. ");
INSERT INTO nld_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","En op dienzelven dag zult gij geen werk doen; want het is de verzoendag, om over u verzoening te doen voor het aangezicht des HEEREN uws Gods. ");
INSERT INTO nld_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Want alle ziel, welken op dienzelven dag niet zal verootmoedigd zijn geweest, die zal uitgeroeid worden uit haar volken. ");
INSERT INTO nld_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ook alle ziel, die enig werk op dienzelven dag gedaan zal hebben, die ziel zal Ik uit het midden haars volks verderven. ");
INSERT INTO nld_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Gij zult geen werk doen; het is een eeuwige inzetting voor uw geslachten, in al uw woningen. ");
INSERT INTO nld_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Het zal u een sabbat der rust zijn; dan zult gij uw zielen verootmoedigen; op den negenden der maand in den avond, van den avond tot den avond, zult gij uw sabbat rusten. ");
INSERT INTO nld_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Spreek tot de kinderen Israels, zeggende: Op den vijftienden dag van deze zevende maand zal het feest der loofhutten zeven dagen den HEERE zijn. ");
INSERT INTO nld_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Op den eersten dag zal een heilige samenroeping zijn; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Zeven dagen zult gij den HEERE vuurofferen offeren; op den achtsten dag zult gij een heilige samenroeping hebben, en zult den HEERE vuuroffer offeren; het is een verbodsdag; gij zult geen dienstwerk doen. ");
INSERT INTO nld_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Dit zijn de gezette hoogtijden des HEEREN, welke gij zult uitroepen tot heilige samenroepingen, om den HEERE vuuroffer, brandoffer en spijsoffer, slachtoffer en drankofferen, elk dagelijks op zijn dag, te offeren; ");
INSERT INTO nld_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Behalve de sabbatten des HEEREN, en behalve uw gaven, en behalve al uw geloften, en behalve al uw vrijwillige offeren, welke gij den HEERE geven zult. ");
INSERT INTO nld_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Doch op den vijftienden dag der zevende maand, als gij het inkomen des lands zult ingegaderd hebben, zult gij des HEEREN feest zeven dagen vieren; op den eersten dag zal er rust zijn, en op den achtsten dag zal er rust zijn. ");
INSERT INTO nld_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","En op den eersten dag zult gij u nemen takken van schoon geboomte, palmtakken, en meien van dichte bomen, met beekwilgen; en gij zult voor het aangezicht des HEEREN, uws Gods, zeven dagen vrolijk zijn. ");
INSERT INTO nld_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","En gij zult dat feest den HEERE zeven dagen in het jaar vieren; het is een eeuwige inzetting voor uw geslachten; in de zevende maand zult gij het vieren. ");
INSERT INTO nld_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Zeven dagen zult gij in de loofhutten wonen; alle inboorlingen in Israel zullen in loofhutten wonen; ");
INSERT INTO nld_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Opdat uw geslachten weten, dat Ik de kinderen Israels in loofhutten heb doen wonen, als Ik hen uit Egypteland uitgevoerd heb; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Alzo heeft Mozes de gezette hoogtijden des HEEREN tot de kinderen Israels uitgesproken. ");
INSERT INTO nld_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Gebied den kinderen Israels, dat zij tot u brengen zuivere gestoten olijfolie, voor den luchter, om de lampen gedurig aan te steken. ");
INSERT INTO nld_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaron zal die voor het aangezicht des HEEREN gedurig toerichten, van den avond tot den morgen, buiten den voorhang van de getuigenis, in de tent der samenkomst; het is een eeuwige inzetting voor uw geslachten. ");
INSERT INTO nld_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Hij zal op den louteren kandelaar die lampen voor het aangezicht des HEEREN gedurig toerichten. ");
INSERT INTO nld_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Gij zult ook meelbloem nemen, en twaalf koeken daarvan bakken; van twee tienden zal een koek zijn. ");
INSERT INTO nld_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","En gij zult ze in twee rijen leggen, zes in een rij, op de reine tafel, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","En op elke rij zult gij zuiveren wierook leggen, welke het brood ten gedenkoffer zal zijn; het is een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Op elken sabbatdag gedurig zal men dat voor het aangezicht des HEEREN toerichten, vanwege de kinderen Israels, tot een eeuwig verbond. ");
INSERT INTO nld_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","En het zal voor Aaron en zijn zonen zijn, die dat in de heilige plaats zullen eten; want het is voor hem een heiligheid der heiligheden uit de vuurofferen des HEEREN, een eeuwige inzetting. ");
INSERT INTO nld_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","En er ging de zoon ener Israelietische vrouw uit, die, in het midden der kinderen Israels, de zoon van een Egyptische man was; en de zoon van deze Israelietische en een Israelietisch man twistten in het leger. ");
INSERT INTO nld_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Toen lasterde de zoon der Israelietische vrouw uitdrukkelijk den NAAM, en vloekte; daarom brachten zij hem tot Mozes; de naam nu zijner moeder was Selomith, de dochter van Dibri, van den stam Dan. ");
INSERT INTO nld_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","En zij leidden hem in de gevangenis, opdat hem, naar den mond des HEEREN, verklaring geschieden zou. ");
INSERT INTO nld_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Breng den vloeker uit tot buiten het leger, en allen, die het gehoord hebben, zullen hun handen op zijn hoofd leggen; daarna zal hem de gehele vergadering stenigen. ");
INSERT INTO nld_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","En tot de kinderen Israels zult gij spreken, zeggende: Een ieder, als hij zijn God gevloekt zal hebben, zo zal hij zijn zonde dragen. ");
INSERT INTO nld_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","En wie den Naam des HEEREN gelasterd zal hebben, zal zekerlijk gedood worden; de ganse vergadering zal hem zekerlijk stenigen; alzo zal de vreemdeling zijn, gelijk de inboorling, als hij den NAAM zal gelasterd hebben, hij zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","En als iemand enige ziel des mensen zal verslagen hebben, hij zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Maar wie de ziel van enig vee zal verslagen hebben, hij zal het wedergeven, ziel voor ziel. ");
INSERT INTO nld_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Als ook iemand aan zijn naaste een gebrek zal aangebracht hebben; gelijk als hij gedaan heeft, zo zal ook aan hem gedaan worden: ");
INSERT INTO nld_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Breuk voor breuk, oog voor oog, tand voor tand; gelijk als hij een gebrek een mens zal aangebracht hebben, zo zal ook hem aangebracht worden. ");
INSERT INTO nld_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wie dan enig vee verslaat, die zal het wedergeven; maar wie een mens verslaat, die zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Enerlei recht zult gij hebben; zo zal de vreemdeling zijn, als de inboorling; want Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","En Mozes zeide tot de kinderen Israels, dat zij den vloeker tot buiten het leger uitbrengen, en hem met stenen stenigen zouden. En de kinderen Israels deden, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Verder sprak de HEERE tot Mozes, aan den berg Sinai, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Spreek tot de kinderen Israels, en zeg tot hen: Wanneer gij zult gekomen zijn in dat land, dat Ik u geve, dan zal dat land rusten, een sabbat den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Zes jaren zult gij uw akker bezaaien, en zes jaren uw wijngaard besnijden, en de inkomst daarvan inzamelen. ");
INSERT INTO nld_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Doch in het zevende jaar zal voor het land een sabbat der rust zijn, een sabbat den HEERE; uw akker zult gij niet bezaaien en uw wijngaard niet besnijden. ");
INSERT INTO nld_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Wat van zelf van uw oogst zal gewassen zijn, zult gij niet inoogsten, en de druiven uwer afzondering zult gij niet afsnijden; het zal een jaar der ruste voor het land zijn. ");
INSERT INTO nld_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","En de inkomst van den sabbat des lands zal voor u tot spijze zijn, voor u, en voor uw knecht, en voor uw dienstmaagd, en voor uw dagloner, en voor uw bijwoner, die bij u als vreemdelingen verkeren; ");
INSERT INTO nld_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Mitsgaders voor het vee, en voor het gedierte, dat in uw land is, zal al de inkomst daarvan tot spijze zijn. ");
INSERT INTO nld_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Gij zult u ook tellen zeven jaarweken, zevenmaal zeven jaren; zodat de dagen der zeven jaarweken u negen en veertig jaren zullen zijn. ");
INSERT INTO nld_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Daarna zult gij in de zevende maand, op den tienden der maand, de bazuin des geklanks doen doorgaan; op den verzoendag zult gij de bazuin doen doorgaan in uw ganse land. ");
INSERT INTO nld_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","En gij zult dat vijftigste jaar heiligen, en vrijheid uitroepen in het land, voor al zijn inwoners; het zal u een jubeljaar zijn; en gij zult wederkeren een ieder tot zijn bezittingen, en zult wederkeren een ieder tot zijn geslacht. ");
INSERT INTO nld_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Dit jubeljaar zal u het vijftigste jaar zijn; gij zult niet zaaien, noch inoogsten wat van zelf daarin zal gewassen zijn, noch ook de druiven der afzonderingen in hetzelve afsnijden. ");
INSERT INTO nld_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Want dat is het jubeljaar; het zal u heilig zijn; gij zult uit het veld de inkomst daarvan eten. ");
INSERT INTO nld_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Op dat jubeljaar zult gij ieder wederkeren tot zijn bezitting. ");
INSERT INTO nld_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Daarom, wanneer gij aan uw naaste wat veilbaars verkopen, of uit de hand uws naasten kopen zult, dat niemand de een den ander verdrukke. ");
INSERT INTO nld_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Naar het getal der jaren, van het jubeljaar af, zult gij van uw naaste kopen, en naar het getal van de jaren der inkomsten zal hij het aan u verkopen. ");
INSERT INTO nld_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Naar de veelheid der jaren zult gij zijn koop vermeerderen, en naar de weinigheid der jaren zult gij zijn koop verminderen; want hij verkoopt aan u het getal der inkomsten. ");
INSERT INTO nld_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Dat dan niemand zijn naaste verdrukke; maar vreest voor uw God; want Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","En doet Mijn inzettingen, en houdt Mijn rechten, en doet dezelve; zo zult gij zeker wonen in het land. ");
INSERT INTO nld_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","En het land zal zijn vrucht geven, en gij zult eten tot verzadiging toe; en gij zult zeker daarin wonen. ");
INSERT INTO nld_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","En als gij zoudt zeggen: Wat zullen wij eten in het zevende jaar! Ziet, wij zullen niet zaaien, en onze inkomst niet inzamelen; ");
INSERT INTO nld_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Zo zal Ik Mijn zegen gebieden over u in het zesde jaar, dat het de inkomst voor drie jaren zal voortbrengen. ");
INSERT INTO nld_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Het achtste jaar nu zult gij zaaien, en zult van de oude inkomst eten, tot het negende jaar toe; totdat zijn inkomst ingekomen is, zult gij het oude eten. ");
INSERT INTO nld_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Het land ook zal niet voor altoos verkocht worden; want het land is het Mijne, dewijl gij vreemdelingen en bijwoners bij Mij zijt. ");
INSERT INTO nld_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Daarom zult gij, in het ganse land uwer bezitting, lossing voor het land toelaten. ");
INSERT INTO nld_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wanneer uw broeder zal verarmd zijn, en iets van zijn bezitting verkocht zal hebben, zo zal zijn losser, die hem nabestaande is, komen, en zal het verkochte zijns broeders lossen. ");
INSERT INTO nld_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","En wanneer iemand geen losser zal hebben, maar zijn hand bekomen en hij gevonden zal hebben, zoveel genoeg is tot zijn lossing; ");
INSERT INTO nld_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Dan zal hij de jaren zijner verkoping rekenen, en het overschot zal hij den man, wien hij het verkocht had, weder uitkeren; en hij zal weder tot zijn bezitting komen. ");
INSERT INTO nld_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Maar indien zijn hand niet gevonden heeft, wat genoeg is, om aan hem weder uit te keren, zo zal zijn verkochte goed zijn in de hand van deszelfs koper tot het jubeljaar toe; maar in het jubeljaar zal het uitgaan, en hij zal tot zijn bezitting wederkeren. ");
INSERT INTO nld_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Insgelijks, wanneer iemand een woonhuis in een bemuurde stad zal verkocht hebben, zo zal zijn lossing zijn, totdat het jaar zijner verkoping volkomen zal zijn; in een vol jaar zal zijn lossing wezen. ");
INSERT INTO nld_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Maar is het, dat het niet gelost wordt, tegen dat hem het gehele jaar zal vervuld zijn, zo zal dat huis, hetwelk in die stad is, die een muur heeft, voor altoos blijven aan hem, die dat gekocht heeft, onder zijn geslachten; het zal in het jubeljaar niet uitgaan. ");
INSERT INTO nld_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Doch de huizen der dorpen, die rondom geen muur hebben, zullen als het veld des lands gerekend worden; daarvoor zal lossing zijn, en zij zullen in het jubeljaar uitgaan. ");
INSERT INTO nld_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Aangaande de steden der Levieten, en de huizen der steden hunner bezitting; de Levieten zullen een eeuwige lossing hebben. ");
INSERT INTO nld_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","En als men onder de Levieten lossing zal gedaan hebben, zo zal de koop van het huis en van de stad zijner bezitting in het jubeljaar uitgaan; want de huizen van de steden der Levieten zijn hun bezitting in het midden van de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Doch het veld van de voorstad hunner steden zal niet verkocht worden; want het is een eeuwige bezitting voor hen. ");
INSERT INTO nld_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","En als uw broeder zal verarmd zijn, en zijn hand bij u wankelen zal, zo zult gij hem vasthouden, zelfs een vreemdeling en bijwoner, opdat hij bij u leve. ");
INSERT INTO nld_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Gij zult geen woeker noch overwinst van hem nemen; maar gij zult vrezen voor uw God, opdat uw broeder bij u leve. ");
INSERT INTO nld_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Uw geld zult gij hem niet op woeker geven, en gij zult uw spijze niet op overwinst geven. ");
INSERT INTO nld_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ik ben de HEERE, uw God, Die u uit Egypteland gevoerd heb, om u het land Kanaan te geven, opdat Ik u tot een God zij. ");
INSERT INTO nld_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Desgelijks, wanneer uw broeder bij u zal verarmd zijn, en zich aan u verkocht zal hebben, gij zult hem niet doen dienen den dienst van een slaaf; ");
INSERT INTO nld_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Als een dagloner, als een bijwoner zal hij bij u zijn; tot het jubeljaar zal hij bij u dienen. ");
INSERT INTO nld_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dan zal hij van u uitgaan, hij en zijn kinderen met hem, en hij zal tot zijn geslacht wederkeren, en tot de bezitting zijner vaderen wederkeren. ");
INSERT INTO nld_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Want zij zijn Mijn dienstknechten, die Ik uit Egypteland uitgevoerd heb; zij zullen niet verkocht worden, gelijk men een slaaf verkoopt. ");
INSERT INTO nld_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Gij zult geen heerschappij over hem hebben met wreedheid; maar gij zult vrezen voor uw God. ");
INSERT INTO nld_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Aangaande uw slaaf of uw slavin, die gij zult hebben, die zullen van de volken zijn, die rondom u zijn; van die zult gij een slaaf of een slavin kopen. ");
INSERT INTO nld_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Gij zult ze ook kopen van de kinderen der bijwoners, die bij u als vreemdelingen verkeren, uit hen en uit hun geslachten, die bij u zullen zijn, die zij in uw land zullen gewonnen hebben; en zij zullen u tot een bezitting zijn. ");
INSERT INTO nld_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","En gij zult u tot bezitters over hen stellen voor uw kinderen na u, opdat zij de bezitting erven; gij zult hen in eeuwigheid doen dienen; maar over uw broeders, de kinderen Israels, een iegelijk over zijn broeder, gij zult over hem geen heerschappij hebben met wreedheid. ");
INSERT INTO nld_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","En wanneer de hand eens vreemdelings en bijwoners, die bij u is, wat bekomen zal hebben, en uw broeder, die bij hem is, verarmd zal zijn, dat hij zich aan den vreemdeling, den bijwoner, die bij u is, of aan den stam van het geslacht des vreemdelings zal verkocht hebben; ");
INSERT INTO nld_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Nadat hij zich zal verkocht hebben, zal er lossing voor hem zijn; een van zijn broeders zal hem lossen; ");
INSERT INTO nld_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Of zijn oom, of de zoon zijns ooms, zal hem lossen, of die uit de naasten zijns vleses van zijn geslacht is, zal hem lossen; of heeft zijn hand wat bekomen, dat hij zichzelven losse. ");
INSERT INTO nld_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","En hij zal met zijn koper rekenen van dat jaar af, dat hij zich aan hem verkocht heeft tot het jubeljaar toe; alzo dat het geld zijner verkoping zal zijn naar het getal van de jaren, naar de dagen eens dagloners zal het met hem zijn. ");
INSERT INTO nld_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Indien nog vele van die jaren zijn, naar die zal hij tot zijn lossing van het geld, waarover hij gekocht is, wedergeven. ");
INSERT INTO nld_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","En indien er nog weinige van die jaren overgebleven zijn, tot aan het jubeljaar, zo zal hij met hem rekenen; naar zijn jaren zal hij zijn lossing wedergeven. ");
INSERT INTO nld_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Als een dagloner zal hij van jaar tot jaar bij hem zijn; men zal over hem geen heerschappij hebben met wreedheid voor uw ogen. ");
INSERT INTO nld_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","En is het, dat hij hierdoor niet gelost wordt, zo zal hij in het jubeljaar uitgaan, hij en zijn kinderen met hem. ");
INSERT INTO nld_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Want de kinderen Israels zijn Mij tot dienstknechten; Mijn dienstknechten zijn zij, die Ik uit Egypteland uitgevoerd heb; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Gij zult ulieden geen afgoden maken; noch gesneden beeld, noch opgericht beeld zult gij u stellen, noch gebeelden steen in uw land zetten, om u daarvoor te buigen; want Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mijn sabbatten zult gij houden, en Mijn heiligdom zult gij vrezen; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Indien gij in Mijn inzettingen wandelen, en Mijn geboden houden, en die doen zult; ");
INSERT INTO nld_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Zo zal Ik uw regens geven op hun tijd; en het land zal zijn inkomst geven, en het geboomte des velds zal zijn vrucht geven; ");
INSERT INTO nld_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","En de dorstijd zal u reiken tot den wijnoogst, en de wijnoogst zal reiken tot den zaaitijd; en gij zult uw brood eten tot verzadiging toe, en gij zult zeker in uw land wonen. ");
INSERT INTO nld_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ook zal Ik vrede geven in het land, dat gij zult te slapen liggen, en niemand zij, die verschrikke; en Ik zal het boos gedierte uit het land doen ophouden, en het zwaard zal door uw land niet doorgaan. ");
INSERT INTO nld_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","En gij zult uw vijanden vervolgen; en zij zullen voor uw aangezicht door het zwaard vallen. ");
INSERT INTO nld_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vijf uit u zullen honderd vervolgen, en honderd uit u zullen tien duizend vervolgen; en uw vijanden zullen voor uw aangezicht door het zwaard vallen. ");
INSERT INTO nld_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","En Ik zal Mij tot u wenden, en zal u vruchtbaar maken, en u vermenigvuldigen; en Mijn verbond zal Ik met u bevestigen. ");
INSERT INTO nld_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","En gij zult het oude, dat verouderd is, eten; en het oude zult gij vanwege het nieuwe uitbrengen. ");
INSERT INTO nld_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","En Ik zal Mijn tabernakel in het midden van u zetten; en Mijn ziel zal van u niet walgen. ");
INSERT INTO nld_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","En Ik zal in het midden van u wandelen, en zal u tot een God zijn, en gij zult Mij tot een volk zijn. ");
INSERT INTO nld_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ik ben de HEERE, uw God, Die u uit het land der Egyptenaren uitgevoerd heb, opdat gij hun slaven niet zoudt zijn; en Ik heb de disselbomen van uw juk verbroken, en heb u doen rechtop staan. ");
INSERT INTO nld_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Maar indien gij Mij niet zult horen, en al deze geboden niet zult doen; ");
INSERT INTO nld_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","En zo gij Mijn inzettingen zult smadelijk verwerpen, en zo uw ziel van Mijn rechten zal walgen, dat gij niet doet al Mijn geboden, om Mijn verbond te vernietigen; ");
INSERT INTO nld_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Dit zal Ik u ook doen, dat Ik over u stellen zal verschrikking, tering en koorts, die de ogen verteren en de ziel pijnigen; gij zult ook uw zaad te vergeefs zaaien, en uw vijanden zullen dat opeten. ");
INSERT INTO nld_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Daartoe zal Ik Mijn aangezicht tegen ulieden zetten, dat gij geslagen zult worden voor het aangezicht uwer vijanden; en uw haters zullen over u heerschappij hebben, en gij zult vlieden, als u iemand vervolgt. ");
INSERT INTO nld_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","En zo gij Mij tot deze dingen toe nog niet horen zult, Ik zal nog daar toedoen, om u zevenvoudig over uw zonden te tuchtigen. ");
INSERT INTO nld_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Want Ik zal de hovaardigheid uwer kracht verbreken, en zal uw hemel als ijzer maken, en uw aarde als koper. ");
INSERT INTO nld_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","En uw macht zal ijdellijk verdaan worden; en uw land zal zijn inkomsten niet geven, en het geboomte des lands zal zijn vrucht niet geven. ");
INSERT INTO nld_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","En zo gij met Mij in tegenheid wandelen zult, en Mij niet zult willen horen, zo zal Ik over u, naar uw zonden, zevenvoudig slagen toedoen. ");
INSERT INTO nld_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Want Ik zal onder u zenden het gedierte des velds, hetwelk u beroven, en uw vee uitroeien, en u verminderen zal; en uw wegen zullen woest worden. ");
INSERT INTO nld_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Indien gij nog door deze dingen Mij niet getuchtigd zult zijn, maar met Mij in tegenheid wandelen; ");
INSERT INTO nld_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Zo zal Ik ook met u in tegenheid wandelen, en Ik zal u ook zevenvoudig over uw zonden slaan. ");
INSERT INTO nld_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Want Ik zal een zwaard over u brengen, dat de wraak des verbonds wreken zal, zodat gij in uw steden vergaderd zult worden; dan zal Ik de pest in het midden van u zenden, en gij zult in de hand des vijands overgegeven worden. ");
INSERT INTO nld_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Als Ik u den staf des broods zal gebroken hebben, dan zullen tien vrouwen uw brood in een oven bakken, en zullen uw brood bij het gewicht wedergeven; en gij zult eten, maar niet verzadigd worden. ");
INSERT INTO nld_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Als gij ook hierom Mij niet horen zult, maar met Mij wandelen zult in tegenheid; ");
INSERT INTO nld_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Zo zal Ik ook met u in heetgrimmige tegenheid wandelen, en Ik zal u ook zevenvoudig over uw zonden tuchtigen. ");
INSERT INTO nld_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Want gij zult het vlees uwer zonen eten, en het vlees uwer dochteren zult gij eten. ");
INSERT INTO nld_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","En Ik zal uw hoogten verderven, en uw zonnebeelden uitroeien, en zal uw dode lichamen op de dode lichamen uwer drekgoden werpen; en Mijn ziel zal aan u walgen. ");
INSERT INTO nld_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","En Ik zal uw steden een woestijn maken, en uw heiligdommen verwoesten; en Ik zal uw liefelijken reuk niet rieken. ");
INSERT INTO nld_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ja, Ik zal dat land verwoesten; dat uw vijanden, die daarin zullen wonen, zich daarover ontzetten zullen. ");
INSERT INTO nld_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Daartoe zal Ik u onder de heidenen verstrooien; en een zwaard achter u uittrekken; en uw land zal woest, en uw steden zullen een woestijn zijn. ");
INSERT INTO nld_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Dan zal het land aan zijn sabbatten een welgevallen hebben, al de dagen der verwoesting, en gij zult in het land uwer vijanden zijn; dan zal het land rusten, en aan zijn sabbatten een welgevallen hebben. ");
INSERT INTO nld_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Al de dagen der verwoesting zal het rusten, overmits het niet rustte in uw sabbatten, als gij daarin woondet. ");
INSERT INTO nld_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","En aangaande de overgeblevenen onder u, Ik zal in hun hart een wekigheid in de landen hunner vijanden laten komen; zodat het geruis van een gedreven blad hen jagen zal, en zij zullen vlieden, gelijk men vliedt voor een zwaard, en zullen vallen, waar niemand is, die jaagt. ");
INSERT INTO nld_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","En zij zullen de een op den ander als voor het zwaard vallen, waar niemand is, die jaagt; en gij zult voor het aangezicht uwer vijanden niet kunnen bestaan. ");
INSERT INTO nld_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Maar gij zult omkomen onder de heidenen, en het land uwer vijanden zal u verteren. ");
INSERT INTO nld_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","En de overgeblevenen onder u zullen om hun ongerechtigheid in de landen uwer vijanden uitteren; ja, ook om de ongerechtigheden hunner vaderen zullen zij met hen uitteren. ");
INSERT INTO nld_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Dan zullen zij hun ongerechtigheid belijden, en de ongerechtigheid hunner vaderen met hun overtredingen, waarmede zij tegen Mij overtreden hebben, en ook dat zij met Mij in tegenheid gewandeld hebben. ");
INSERT INTO nld_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Dat Ik ook met hen in tegenheid gewandeld, en hen in het land hunner vijanden gebracht zal hebben. Zo dan hun onbesneden hart gebogen wordt, en zij dan aan de straf hunner ongerechtigheid een welgevallen hebben; ");
INSERT INTO nld_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Dan zal Ik gedenken aan Mijn verbond met Jakob, en ook aan Mijn verbond met Izak, en ook aan Mijn verbond met Abraham zal Ik gedenken, en aan het land zal Ik gedenken; ");
INSERT INTO nld_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Als het land om hunnentwil zal verlaten zijn geweest, en aan zijn sabbatten een welgevallen gehad hebben, wanneer het om hunnentwil verwoest was, en zij aan de straf hunner ongerechtigheid een welgevallen zullen gehad hebben; daarom, en omdat zij Mijn rechten hadden verworpen, en hun ziel van Mijn inzettingen gewalgd had. ");
INSERT INTO nld_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","En hierenboven is dit ook; als zij in het land hunner vijanden zullen zijn, zal Ik hen niet verwerpen, noch van hen walgen, om een einde van hen te maken, vernietigende Mijn verbond met hen; want Ik ben de HEERE, hun God! ");
INSERT INTO nld_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maar Ik zal hun ten beste gedenken aan het verbond der voorouderen, die Ik uit Egypteland voor de ogen der heidenen uitgevoerd heb, opdat Ik hun tot een God ware; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dit zijn die inzettingen, en die rechten, en die wetten, welke de HEERE gegeven heeft, tussen Zich en tussen de kinderen Israels, op den berg Sinai, door de hand van Mozes. ");
INSERT INTO nld_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Spreek tot de kinderen Israels, en zeg tot hen: Wanneer iemand een gelofte zal afgezonderd hebben, naar uw schatting zullen de zielen des HEEREN zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Als uw schatting eens mans zal zijn van twintig jaren oud, tot een, die zestig jaren oud is; dan zal uw schatting zijn van vijftig sikkelen zilvers, naar den sikkel des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Maar is het een vrouw, dan zal uw schatting zijn dertig sikkelen. ");
INSERT INTO nld_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","En is het van een, die vijf jaren oud is, tot een, die twintig jaren oud is, zo zal uw schatting van een man twintig sikkelen zijn, en voor een vrouw tien sikkelen. ");
INSERT INTO nld_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Maar is het van een, die een maand oud is, tot een, die vijf jaren oud is, zo zal uw schatting van een man zijn vijf sikkelen zilvers, en uw schatting over een vrouw zal zijn drie sikkelen zilvers. ");
INSERT INTO nld_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","En is het van een, die zestig jaren oud is en daarboven, is het een man, zo zal uw schatting zijn vijftien sikkelen, en voor een vrouw tien sikkelen. ");
INSERT INTO nld_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Maar zo hij armer is, dan uw schatting, zo zal hij zich voor het aangezicht des priesters zetten, opdat de priester hem schatte; naar dat de hand desgenen, die de gelofte gedaan heeft, zal kunnen bekomen, zal de priester hem schatten. ");
INSERT INTO nld_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","En indien het een beest is, waarvan men den HEERE offerande offert; al wat hij daarvan den HEERE zal gegeven hebben, zal heilig zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Hij zal niet vermangelen, noch hetzelve verwisselen, een goed voor een kwaad, of een kwaad voor een goed; indien hij nochtans een beest voor een beest enigszins verwisselt, zo zal dit, en wat daarvoor verwisseld is, heilig zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","En indien het enig onrein beest is, van hetwelk men den HEERE geen offerande offert, zo zal hij dat beest voor het aangezicht des priesters zetten. ");
INSERT INTO nld_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","En de priester zal dat schatten, naar dat het goed of kwaad is; naar uw schatting, priester! zo zal het zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Maar indien hij het immers lossen zal, zo zal hij deszelfs vijfde deel boven uw schatting toedoen. ");
INSERT INTO nld_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","En wanneer iemand zijn huis zal geheiligd hebben, dat het den HEERE heilig zij, zo zal de priester dat schatten, naar dat het goed of kwaad is; gelijk als de priester dat geschat zal hebben, zo zal het stand hebben. ");
INSERT INTO nld_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","En indien hij, die het geheiligd heeft, zijn huis zal lossen, zo zal hij een vijfde deel des gelds uwer schatting daarboven toedoen, zo zal het zijne zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Indien ook iemand van den akker zijner bezitting den HEERE wat geheiligd zal hebben, zo zal uw schatting zijn naar zijn zaad; een homer gerstezaad zal zijn op vijftig sikkelen zilvers. ");
INSERT INTO nld_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Indien hij zijn akker van het jubeljaar af geheiligd zal hebben, zo zal het naar uw schatting stand hebben. ");
INSERT INTO nld_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Maar zo hij zijn akker na het jubeljaar geheiligd zal hebben, dan zal hem de priester het geld rekenen, naar de jaren, die nog overig zijn tot het jubeljaar; en het zal van uw schatting afgetrokken worden. ");
INSERT INTO nld_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","En indien hij, die den akker geheiligd heeft, denzelven ganselijk lossen zal, zo zal hij een vijfde deel des gelds uwer schatting daarboven toedoen, en dezelve zal hem gevestigd zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","En indien hij dien akker niet zal lossen, of indien hij dien akker aan een anderen man verkocht heeft, zo zal hij niet meer gelost worden. ");
INSERT INTO nld_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Maar die akker, nadat hij in het jubeljaar zal uitgegaan zijn, zal den HEERE heilig zijn, als een verbannen akker; de bezitting daarvan zal des priesters zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","En indien hij den HEERE een akker heeft geheiligd, dien hij gekocht heeft, en niet is van den akker zijner bezitting; ");
INSERT INTO nld_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Zo zal de priester hem rekenen de som uwer schatting tot het jubeljaar; en hij zal op denzelven dag uw schatting geven, een heiligheid den HEERE. ");
INSERT INTO nld_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In het jubeljaar zal die akker wederkomen tot dien, van wien hij hem gekocht had, tot hem, wiens de bezitting van dat land was. ");
INSERT INTO nld_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Al uw schatting nu zal naar den sikkel des heiligdoms geschieden; de sikkel zal zijn van twintig gera. ");
INSERT INTO nld_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Maar het eerstgeborene, dat den HEERE van een beest eerstgeboren wordt, dat zal niemand heiligen; hetzij een os, of klein vee, het is des HEEREN. ");
INSERT INTO nld_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Doch is het van een onrein beest, hij zal dat lossen naar uw schatting, en zal zijn vijfde deel daarboven toedoen; en indien het niet gelost wordt, zo zal het verkocht worden, naar uw schatting. ");
INSERT INTO nld_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Evenwel niets, dat verbannen is, dat iemand den HEERE zal verbannen hebben, van al hetgeen hij heeft, van een mens, of van een beest, of van den akker zijner bezitting, zal verkocht noch gelost worden; al wat verbannen is, zal den HEERE een heiligheid der heiligheden zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Al wat verbannen is, dat van de mensen zal verbannen zijn, zal niet gelost worden; het zal zekerlijk gedood worden. ");
INSERT INTO nld_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ook alle tienden des lands, van het zaad des lands, van de vrucht van het geboomte, zijn des HEEREN; zij zijn den HEERE heilig. ");
INSERT INTO nld_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Maar zo iemand van zijn tienden immer iets lossen zal, hij zal zijn vijfde deel daarboven toedoen. ");
INSERT INTO nld_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Aangaande al de tienden van runderen en klein vee, alles wat onder de roede zal doorgaan, het tiende zal den HEERE heilig zijn. ");
INSERT INTO nld_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Hij zal tussen het goede en het kwade niet onderzoeken; hij zal het ook niet verwisselen; maar indien hij het immers verwisselen zal, zo zal dit, en wat daarvoor verwisseld is, heilig zijn; het zal niet gelost worden. ");
INSERT INTO nld_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dit zijn de geboden, die de HEERE Mozes geboden heeft, aan de kinderen Israels, op den berg Sinai. ");
INSERT INTO nld_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Voorts sprak de HEERE tot Mozes, in de woestijn van Sinai, in de tent der samenkomst, op den eersten der tweede maand, in het tweede jaar, nadat zij uit Egypteland uitgetogen ware, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Neem op de som van de gehele vergadering der kinderen Israels, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van al wat mannelijk is, hoofd voor hoofd. ");
INSERT INTO nld_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Van twintig jaren oud en daarboven, allen, die ten heire in Israel uittrekken; die zult gij tellen naar hun heiren, gij en Aaron. ");
INSERT INTO nld_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","En met ulieden zullen zijn van elken stam een man, die een hoofdman is over het huis zijner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Deze zijn nu de namen der mannen, die bij u staan zullen: van Ruben, Elizur, de zoon van Sedeur. ");
INSERT INTO nld_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Van Simeon, Selumiel, de zoon van Zurisaddai. ");
INSERT INTO nld_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Van Juda, Nahesson, de zoon van Amminadab. ");
INSERT INTO nld_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Van Issaschar, Nethaneel, de zoon van Zuar. ");
INSERT INTO nld_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Van Zebulon, Eliab, de zoon van Helon. ");
INSERT INTO nld_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Van de kinderen van Jozef: van Efraim, Elisama, de zoon van Ammihud; van Manasse, Gamaliel, de zoon van Pedazur. ");
INSERT INTO nld_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Van Benjamin, Abidan, de zoon van Gideoni. ");
INSERT INTO nld_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Van Dan, Ahiezer, de zoon van Ammisaddai. ");
INSERT INTO nld_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Van Aser, Pagiel, de zoon van Ochran. ");
INSERT INTO nld_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Van Gad, Eljasaf, de zoon van Dehuel. ");
INSERT INTO nld_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Van Nafthali, Ahira, de zoon van Enan. ");
INSERT INTO nld_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Dezen waren de geroepenen der vergadering, de oversten der stammen hunner vaderen; zij waren de hoofden der duizenden van Israel. ");
INSERT INTO nld_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Toen namen Mozes en Aaron die mannen, welken met namen uitgedrukt zijn. ");
INSERT INTO nld_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","En zij verzamelden de gehele vergadering, op den eersten dag der tweede maand; en die verklaarden hun afkomst, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van die twintig jaren oud was en daarboven, hoofd voor hoofd. ");
INSERT INTO nld_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Gelijk als de HEERE Mozes geboden had, zo heeft hij hen geteld in de woestijn van Sinai. ");
INSERT INTO nld_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Zo waren de zonen van Ruben, den eerstgeborene van Israel, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, hoofd voor hoofd, al wat mannelijk was, van twintig jaren oud en daarboven, allen, die ten heire uittrokken; ");
INSERT INTO nld_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Hun getelden van den stam van Ruben waren zes en veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Van de zonen van Simeon, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, zijn getelden, in het getal der namen, hoofd voor hoofd, al wat mannelijk was, van twintig jaren oud en daarboven, allen, die ten heire uittrokken; ");
INSERT INTO nld_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Hun getelden van den stam van Simeon waren negen en vijftig duizend en driehonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Van de zonen van Gad, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken. ");
INSERT INTO nld_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Waren hun getelden van den stam van Gad vijf en veertig duizend zeshonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Van de zonen van Juda, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Waren hun getelden van den stam van Juda vier en zeventig duizend en zeshonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Van de zonen van Issaschar, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Waren hun getelden van den stam van Issaschar vier en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Van de zonen van Zebulon, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Waren hun getelden van den stam van Zebulon zeven en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Van de zonen van Jozef: van de zonen van Efraim, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Waren hun getelden van den stam van Efraim veertig duizend en vijfhonderd; ");
INSERT INTO nld_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Van de zonen van Manasse, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Waren hun getelden van den stam van Manasse twee en dertig duizend en tweehonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Van de zonen van Benjamin, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Waren hun getelden van den stam van Benjamin vijf en dertig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Van de zonen van Dan, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Waren hun getelden van den stam van Dan twee en zestig duizend en zevenhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Van de zonen van Aser, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Waren hun getelden van den stam van Aser een en veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Van de zonen van Nafthali, hun geboorten, naar hun geslachten, naar het huis hunner vaderen, in het getal der namen, van twintig jaren oud en daarboven, allen, die ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Waren hun getelden van den stam van Nafthali drie en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dezen zijn de getelden, welke Mozes geteld heeft, en Aaron, en de oversten van Israel; twaalf mannen waren zij, elk over het huis zijner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Alzo waren al de getelden der zonen van Israel, naar het huis hunner vaderen, van twintig jaren oud en daarboven, allen, die in Israel ten heire uittrokken, ");
INSERT INTO nld_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Al de getelden dan waren zeshonderd drie duizend vijfhonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Maar de Levieten, naar den stam hunner vaderen, werden onder hen niet geteld. ");
INSERT INTO nld_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Want de HEERE had tot Mozes gesproken, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Alleen den stam van Levi zult gij niet tellen, noch hun som opnemen, onder de zonen van Israel. ");
INSERT INTO nld_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Maar gij, stel de Levieten over den tabernakel der getuigenis, en over al zijn gereedschap, en over alles, wat daartoe behoort; zij zullen den tabernakel dragen, en al zijn gereedschap; en zij zullen dien bedienen, en zij zullen zich rondom den tabernakel legeren. ");
INSERT INTO nld_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","En als de tabernakel zal optrekken, de Levieten zullen denzelven afnemen; en wanneer de tabernakel zich legeren zal, zullen de Levieten denzelven oprichten; en de vreemde, die daarbij komt, zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","En de kinderen Israels zullen zich legeren, een iegelijk bij zijn leger, en een iegelijk bij zijn banier, naar hun heiren. ");
INSERT INTO nld_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Maar de Levieten zullen zich legeren rondom den tabernakel der getuigenis, opdat geen verbolgenheid over de vergadering van de kinderen Israels zij; daarom zullen de Levieten de wacht van den tabernakel der getuigenis waarnemen. ");
INSERT INTO nld_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Zo deden de kinderen Israels; naar alles, wat de HEERE Mozes geboden had, zo deden zij. ");
INSERT INTO nld_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","En de HEERE sprak tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","De kinderen Israels zullen zich legeren, een ieder onder zijn banier, naar de tekenen van het huis hunner vaderen; rondom tegenover de tent der samenkomst zullen zij zich legeren. ");
INSERT INTO nld_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Die zich nu legeren zullen oostwaarts tegen den opgang, zal zijn de banier des legers van Juda, naar hun heiren; en Nahesson, de zoon van Amminadab, zal de overste der zonen van Juda zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Zijn heir nu, en zijn getelden waren vier en zeventig duizend en zeshonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","En nevens zal zich legeren de stam van Issaschar; en Nethaneel, de zoon van Zuar, zal de overste der zonen van Issaschar zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Zijn heir nu, en zijn getelden waren vier en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Daartoe de stam van Zebulon; en Eliab, de zoon van Helon, zal de overste der zonen van Zebulon zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Zijn heir nu, en zijn getelden waren zeven en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Al de getelden des legers van Juda waren honderd zes en tachtig duizend en vierhonderd, naar hun heiren. Zij zullen vooraan optrekken. ");
INSERT INTO nld_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","De banier des legers van Ruben, naar hun heiren, zal tegen het zuiden zijn; en Elizur, de zoon van Sedeur, zal de overste der zonen van Ruben zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Zijn heir nu, en zijn getelden waren zes en veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","En nevens hem zal zich legeren de stam van Simeon; en Selumiel, de zoon van Zurisaddai, zal de overste der zonen van Simeon zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Zijn heir nu, en zijn getelden waren negen en vijftig duizend en driehonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Daartoe de stam van Gad; en Eljasaf, de zoon van Rehuel, zal de overste der zonen van Gad zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Zijn heir nu, en zijn getelden waren vijf en veertig duizend zeshonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Al de getelden in het leger van Ruben waren honderd een en vijftig duizend vierhonderd en vijftig; naar hun heiren. En zij zullen de tweede optrekken. ");
INSERT INTO nld_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Daarna zal de tent der samenkomst optrekken, met het leger der Levieten, in het midden van de legers; gelijk als zij zich legeren zullen, alzo zullen zij optrekken, een iegelijk aan zijn plaats, naar hun banieren. ");
INSERT INTO nld_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","De banier des legers van Efraim, naar hun heiren, zal tegen het westen zijn; en Elisama, de zoon van Ammihud, zal de overste der zonen van Efraim zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Zijn heir nu, en zijn getelden waren veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","En nevens hem de stam van Manasse; en Gamaliel, de zoon van Pedazur, zal de overste der zonen van Manasse zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Zijn heir nu, en zijn getelden waren twee en dertig duizend en tweehonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Daartoe de stam van Benjamin; en Abidan, de zoon van Gideoni, zal de overste der zonen van Benjamin zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Zijn heir nu, en zijn getelden waren vijf en dertig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Al de getelden in het leger van Efraim waren honderd acht duizend en eenhonderd, naar hun heiren. En zij zullen de derde optrekken. ");
INSERT INTO nld_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","De banier des legers van Dan zal tegen het noorden zijn, naar hun heiren; en Ahiezer, de zoon van Ammisaddai, zal de overste der zonen van Dan zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Zijn heir nu, en zijn getelden waren twee en zestig duizend en zevenhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","En nevens hem zal zich legeren de stam van Aser; en Pagiel, de zoon van Ochran, zal de overste der zonen van Aser zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Zijn heir nu, en zijn getelden waren een en veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Daartoe de stam van Nafthali; en Ahira, de zoon van Enan, zal de overste der zonen van Nafthali zijn. ");
INSERT INTO nld_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Zijn heir nu, en zijn getelden waren drie en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Al de getelden in het leger van Dan waren honderd zeven en vijftig duizend en zeshonderd. In het achterste zullen zij optrekken, naar hun banieren. ");
INSERT INTO nld_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Dezen zijn de getelden van de kinderen Israels, naar het huis hunner vaderen; al de getelden der legers, naar hun heiren, waren zeshonderd drie duizend vijfhonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Maar de Levieten werden niet geteld onder de zonen van Israel, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","En de kinderen Israels deden naar alles, wat de HEERE Mozes geboden had, zo legerden zij zich naar hun banieren, en zo trokken zij op, een iegelijk naar zijn geslachten, naar het huis zijner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dit nu zijn de geboorten van Aaron en Mozes; ten dage als de HEERE met Mozes gesproken heeft op den berg Sinai. ");
INSERT INTO nld_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","En dit zijn de namen der zonen van Aaron: de eerstgeborene, Nadab, daarna Abihu, Eleazar, en Ithamar. ");
INSERT INTO nld_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Dit zijn de namen der zonen van Aaron, der priesteren, die gezalfd waren, welker hand men gevuld had, om het priesterambt te bedienen. ");
INSERT INTO nld_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Maar Nadab en Abihu stierven voor het aangezicht des HEEREN, als zij vreemd vuur voor het aangezicht des HEEREN in de woestijn van Sinai brachten, en hadden geen kinderen, doch Eleazar en Ithamar bedienden het priesterambt voor het aangezicht van hun vader Aaron. ");
INSERT INTO nld_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Doe den stam van Levi naderen, en stel hem voor het aangezicht van den priester Aaron, opdat zij hem dienen; ");
INSERT INTO nld_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","En dat zij waarnemen zijn wacht, en de wacht der gehele vergadering, voor de tent der samenkomst, om den dienst des tabernakels te bedienen; ");
INSERT INTO nld_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","En dat zij al het gereedschap van de tent der samenkomst, en de wacht der kinderen Israels waarnemen, om den dienst des tabernakels te bedienen. ");
INSERT INTO nld_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Gij zult dan, aan Aaron en aan zijn zonen, de Levieten geven; zij zijn gegeven, zij zijn hem gegeven uit de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Maar Aaron en zijn zonen zult gij stellen, dat zij hun priesterambt waarnemen; en de vreemde, die nadert, zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","En Ik, zie, Ik heb de Levieten uit het midden van de kinderen Israels genomen, in plaats van allen eerstgeborene, die de baarmoeder opent, uit de kinderen Israels; en de Levieten zullen Mijne zijn. ");
INSERT INTO nld_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Want alle eerstgeborene is Mijn; van den dag, dat Ik alle eerstgeborenen in Egypteland sloeg, heb Ik Mij geheiligd alle eerstgeborenen in Israel, van de mensen tot de beesten; zij zullen Mijn zijn; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","En de HEERE sprak tot Mozes in de woestijn van Sinai, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Tel de zonen van Levi naar het huis hunner vaderen, naar hun geslachten, al wat mannelijk is, van een maand oud en daarboven, die zult gij tellen. ");
INSERT INTO nld_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","En Mozes telde hen naar het bevel des HEEREN, gelijk als hem geboden was. ");
INSERT INTO nld_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Dit nu waren de zonen van Levi met hun namen: Gerson, en Kahath, en Merari. ");
INSERT INTO nld_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","En dit zijn de namen der zonen van Gerson, naar hun geslachten: Libni en Simei. ");
INSERT INTO nld_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","En de zonen van Kahath, naar hun geslachten; Amram en Izhar, Hebron en Uzziel. ");
INSERT INTO nld_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","En de zonen van Merari, naar hun geslachten: Maheli en Musi; dit zijn de geslachten der Levieten, naar het huis hunner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Van Gerson was het geslacht der Libnieten, en het geslacht der Simeieten; dit zijn de geslachten der Gersonieten. ");
INSERT INTO nld_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Hun getelden in getal waren van al wat mannelijk was, van een maand oud en daarboven; hun getelden waren zeven duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","De geslachten der Gersonieten zullen zich legeren achter den tabernakel, westwaarts. ");
INSERT INTO nld_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","De overste nu van het vaderlijke huis der Gersonieten zal zijn Eljasaf, de zoon van Lael. ");
INSERT INTO nld_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","En de wacht der zonen van Gerson in de tent der samenkomst zal zijn de tabernakel en de tent, haar deksel, en het deksel aan de deur van de tent der samenkomst; ");
INSERT INTO nld_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","En de behangselen des voorhofs, en het deksel van de deur des voorhofs, welke bij den tabernakel en bij het altaar rondom zijn; mitsgaders de zelen, tot zijn gansen dienst. ");
INSERT INTO nld_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","En van Kahath is het geslacht der Amramieten, en het geslacht der Izharieten, en het geslacht der Hebronieten, en het geslacht der Uzzielieten; dit zijn de geslachten der Kohathieten. ");
INSERT INTO nld_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","In getal van al wat mannelijk was, van een maand oud en daarboven, waren acht duizend en zeshonderd, waarnemende de wacht des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","De geslachten der zonen van Kohath zullen zich legeren aan de zijde des tabernakels, zuidwaarts. ");
INSERT INTO nld_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","De overste nu van het vaderlijke huis der geslachten van de Kohathieten, zal zijn Elisafan, de zoon van Uzziel. ");
INSERT INTO nld_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Hun wacht nu zal zijn de ark, en de tafel, en de kandelaar, en de altaren en het gereedschap des heiligdoms, met hetwelk zij dienst doen, en het deksel, en al wat tot zijn dienst behoort. ");
INSERT INTO nld_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","De overste nu der oversten van Levi zal zijn Eleazar, de zoon van Aaron, den priester; zijn opzicht zal zijn over degenen, die de wacht des heiligdoms waarnemen. ");
INSERT INTO nld_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Van Merari is het geslacht der Mahelieten, en het geslacht der Musieten; dit zijn de geslachten van Merari. ");
INSERT INTO nld_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","En hun getelden in getal van al wat mannelijk was, van een maand oud en daarboven, waren zes duizend en tweehonderd. ");
INSERT INTO nld_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","De overste nu van het vaderlijke huis der geslachten van Merari zal zijn Zuriel, de zoon van Abihail; zij zullen zich legeren aan de zijde des tabernakels, noordwaarts. ");
INSERT INTO nld_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","En het opzicht der wachten van de zonen van Merari zal zijn over de berderen des tabernakels, en zijn richelen, en zijn pilaren, en zijn voeten, en al zijn gereedschap, en al wat tot zijn dienst behoort; ");
INSERT INTO nld_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","En de pilaren des voorhofs rondom, en hun voeten, en hun pennen, en hun zelen. ");
INSERT INTO nld_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Die nu zich legeren zullen voor den tabernakel oostwaarts, voor de tent der samenkomst, tegen den opgang, zullen zijn Mozes, en Aaron met zijn zonen, waarnemende de wacht des heiligdoms, voor de wacht der kinderen Israels; en de vreemde, die nadert, zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Alle getelden der Levieten, welke Mozes en Aaron, op het bevel des HEEREN, naar hun geslachten, geteld hebben, al wat mannelijk was, van een maand oud en daarboven, waren twee en twintig duizend. ");
INSERT INTO nld_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","En de HEERE zeide tot Mozes: Tel alle eerstgeborenen, wat mannelijk is onder de kinderen Israels, van een maand oud en daarboven; en neem het getal hunner namen op. ");
INSERT INTO nld_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","En gij zult voor Mij de Levieten nemen (Ik ben de HEERE!), in plaats van alle eerstgeborenen onder de kinderen Israels, en de beesten der Levieten, in plaats van alle eerstgeborenen onder de beesten der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mozes dan telde, gelijk als de HEERE hem geboden had, alle eerstgeborenen onder de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","En alle eerstgeborenen, die mannelijk waren, in het getal der namen, van een maand oud en daarboven, naar hun getelden, waren twee en twintig duizend tweehonderd en drie en zeventig. ");
INSERT INTO nld_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Neem de Levieten, in plaats van alle eerstgeboorte onder de kinderen Israels, en de beesten der Levieten, in plaats van hun beesten; want de Levieten zullen Mijn zijn; Ik ben de HEERE! ");
INSERT INTO nld_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Aangaande de tweehonderd drie en zeventig, die gelost zullen worden, die overschieten, boven de Levieten, van de eerstgeborenen van de kinderen Israels; ");
INSERT INTO nld_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Gij zult voor elk hoofd vijf sikkels nemen; naar den sikkel des heiligdoms zult gij ze nemen; die sikkel is twintig gera. ");
INSERT INTO nld_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","En gij zult dat geld aan Aaron en zijn zonen geven, het geld der gelosten die onder hen overschieten. ");
INSERT INTO nld_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Toen nam Mozes dat losgeld van degenen, die overschoten boven de gelosten door de Levieten. ");
INSERT INTO nld_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Van de eerstgeborenen van de kinderen Israels nam hij dat geld, duizend driehonderd vijf en zestig sikkelen, naar den sikkel des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","En Mozes gaf dat geld der gelosten aan Aaron en aan zijn zonen, naar het bevel des HEEREN, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","En de HEERE sprak tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Neemt op de som der zonen van Kohath, uit het midden der zonen van Levi, naar hun geslachten, naar het huis hunner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Van dertig jaren oud en daarboven, tot vijftig jaren oud; al wie tot dezen strijd inkomt, om het werk in de tent der samenkomst te doen. ");
INSERT INTO nld_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Dit zal de dienst zijn der zonen van Kohath, in de tent der samenkomst, te weten de heiligheid der heiligheden. ");
INSERT INTO nld_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","In het optrekken des legers, zo zullen Aaron en zijn zonen komen, en den voorhang des deksels afnemen, en zullen daarmede de ark der getuigenis bedekken. ");
INSERT INTO nld_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","En zij zullen een deksel van dassenvellen daarop leggen, en een geheel kleed van hemelsblauw daar bovenop uitspreiden; en zij zullen derzelver handbomen aanleggen. ");
INSERT INTO nld_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Zij zullen ook op de toontafel een kleed van hemelsblauw uitspreiden, en zullen daarop zetten de schotels, en de reukschalen, en de kroezen, en de dekschotels; ook zal het gedurig brood daarop zijn. ");
INSERT INTO nld_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Daarna zullen zij een scharlaken kleed daarover uitspreiden, en zullen dat met een deksel van dassenvellen bedekken; en zij zullen derzelver handbomen aanleggen. ");
INSERT INTO nld_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Dan zullen zij een kleed van hemelsblauw nemen, en bedekken den kandelaar des luchters, en zijn lampen, en zijn snuiters, en zijn blusvaten, en al zijn olievaten, met welke zij aan denzelven dienen. ");
INSERT INTO nld_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Zij zullen ook denzelven, en al zijn gereedschap, in een deksel van dassenvellen doen, en zullen hem op den draagboom leggen. ");
INSERT INTO nld_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","En over het gouden altaar zullen zij een kleed van hemelsblauw uitspreiden, en zullen dat met een deksel van dassenvellen bedekken; en zij zullen deszelfs handbomen aanleggen. ");
INSERT INTO nld_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Zij zullen ook nemen alle gereedschap van den dienst, met hetwelk zij in het heiligdom dienen, en zullen het leggen in een kleed van hemelsblauw, en zullen hetzelve met een deksel van dassenvellen bedekken; en zij zullen het op den draagboom leggen. ");
INSERT INTO nld_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","En zij zullen de as van het altaar vegen, en zij zullen daarover een kleed van purper uitspreiden. ");
INSERT INTO nld_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","En zij zullen daarop leggen al zijn gereedschap, waarmede zij aan hetzelve dienen, de koolpannen, de krauwelen, en de schoffelen, en de sprengbekkens, al het gereedschap des altaars; en zij zullen daarover een deksel van dassenvellen uitspreiden, en zullen deszelfs handbomen aanleggen. ");
INSERT INTO nld_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Als nu Aaron en zijn zonen, het dekken van het heiligdom, en van alle gereedschap des heiligdoms, in het optrekken des legers, zullen voleind hebben, zo zullen daarna de zonen van Kohath komen om te dragen; maar zij zullen dat heilige niet aanroeren, dat zij niet sterven. Dit is de last der zonen van Kohath, in de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Het opzicht nu van Eleazar, den zoon van Aaron, den priester, zal zijn over de olie des luchters, en het reukwerk der welriekende specerijen, en het gedurig spijsoffer, en de zalfolie; het opzicht des gansen tabernakels, en alles wat daarin is, aan het heiligdom en aan zijn gereedschap. ");
INSERT INTO nld_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","En de HEERE sprak tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Gij zult den stam van de geslachten der Kohathieten niet laten uitgeroeid worden, uit het midden der Levieten; ");
INSERT INTO nld_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Maar dit zult gij hun doen, opdat zij leven en niet sterven, als zij tot de heiligheid der heiligheden toetreden zullen: Aaron en zijn zonen zullen komen, en stellen hen een ieder over zijn dienst en aan zijn last. ");
INSERT INTO nld_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Doch zij zullen niet inkomen om te zien, als men het heiligdom inwindt, opdat zij niet sterven. ");
INSERT INTO nld_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Neem ook op de som der zonen van Gerson, naar het huis hunner vaderen, naar hun geslachten. ");
INSERT INTO nld_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Gij zult hen tellen van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkomt om den strijd te strijden, opdat hij den dienst bediene in de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dit zal zijn de dienst der geslachten van de Gersonieten, in het dienen en in den last. ");
INSERT INTO nld_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Zij zullen dan dragen de gordijnen des tabernakels, en de tent der samenkomst; te weten haar deksel, en het dassendeksel, dat er bovenop is, en het deksel der deur van de tent der samenkomst, ");
INSERT INTO nld_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","En de behangselen des voorhofs, en het deksel der deur van de poort des voorhofs, hetwelk is bij den tabernakel en bij het altaar rondom; en hun zelen, en al het gereedschap van hun dienst, mitsgaders al wat daarvoor bereid wordt, opdat zij dienen. ");
INSERT INTO nld_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","De gehele dienst van de zonen der Gersonieten, in al hun last, en in al hun dienst, zal zijn naar het bevel van Aaron en van zijn zonen; en gijlieden zult hun ter bewaring al hun last bevelen. ");
INSERT INTO nld_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Dit is de dienst van de geslachten der zonen van de Gersonieten, in de tent der samenkomst; en hun wacht zal zijn onder de hand van Ithamar, den zoon van Aaron, den priester. ");
INSERT INTO nld_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Aangaande de zonen van Merari, die zult gij naar hun geslachten, en naar het huis hunner vaderen tellen. ");
INSERT INTO nld_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Gij zult hen tellen van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkomt tot dezen strijd, om te bedienen den dienst van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Dit zal nu zijn de onderhouding van hun last, naar al hun dienst, in de tent der samenkomst: de berderen des tabernakels, en zijn richelen, en zijn pilaren, en zijn voeten; ");
INSERT INTO nld_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Mitsgaders de pilaren des voorhofs rondom, hun voeten, en hun pennen, en hun zelen, met al hun gereedschap, en met al hun dienst; en het gereedschap van de waarneming van hun last zult gij bij namen tellen. ");
INSERT INTO nld_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Dit is de dienst van de geslachten der zonen van Merari, naar hun gansen dienst, in de tent der samenkomst, onder de hand van Ithamar, den zoon van Aaron, den priester. ");
INSERT INTO nld_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mozes dan en Aaron, en de oversten der vergadering telden de zonen der Kohathieten, naar hun geslachten, en naar het huis hunner vaderen: ");
INSERT INTO nld_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkwam tot dezen strijd, tot den dienst in de tent der samenkomst; ");
INSERT INTO nld_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Hun getelden nu waren, naar hun geslachten, twee duizend zevenhonderd en vijftig. ");
INSERT INTO nld_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Dit zijn de getelden van de geslachten der Kohathieten, van al wie in de tent der samenkomst diende, welke Mozes en Aaron geteld hebben, naar het bevel des HEEREN, door de hand van Mozes. ");
INSERT INTO nld_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Insgelijks de getelden der zonen van Gerson, naar hun geslachten, en naar het huis hunner vaderen; ");
INSERT INTO nld_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkwam tot dezen strijd, tot den dienst in de tent der samenkomst; ");
INSERT INTO nld_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Hun getelden waren, naar hun geslachten, naar het huis hunner vaderen, twee duizend zeshonderd en dertig. ");
INSERT INTO nld_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Dezen zijn de getelden van de geslachten der zonen van Gerson, van al wie in de tent der samenkomst diende, welke Mozes en Aaron telden, naar het bevel des HEEREN. ");
INSERT INTO nld_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","En de getelden van de geslachten der zonen van Merari, naar hun geslachten, naar het huis hunner vaderen, ");
INSERT INTO nld_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkwam tot dezen strijd, tot den dienst in de tent der samenkomst; ");
INSERT INTO nld_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Hun getelden nu waren, naar hun geslachten, drie duizend en tweehonderd. ");
INSERT INTO nld_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Dezen zijn de getelden van de geslachten der zonen van Merari, welke Mozes en Aaron geteld hebben, naar het bevel des HEEREN, door de hand van Mozes. ");
INSERT INTO nld_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Al de getelden, welke Mozes en Aaron, en de oversten van Israel geteld hebben van de Levieten, naar hun geslachten, en naar het huis hunner vaderen, ");
INSERT INTO nld_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Van dertig jaren oud en daarboven, tot vijftig jaren oud, al wie inkwam, om den dienst der bediening en den dienst van den last, in de tent der samenkomst, te bedienen; ");
INSERT INTO nld_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Hun getelden waren acht duizend vijfhonderd en tachtig. ");
INSERT INTO nld_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Men telde hen, naar het bevel des HEEREN, door de hand van Mozes, een ieder naar zijn dienst, en naar zijn last; en zijn getelden waren, die de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Gebied den kinderen Israels, dat zij uit het leger wegzenden alle melaatsen, en alle vloeienden, en allen, die onrein zijn van een dode. ");
INSERT INTO nld_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Van den man tot de vrouw toe zult gij hen wegzenden; tot buiten het leger zult gij hen wegzenden; opdat zij niet verontreinigen hun legers, in welker midden Ik wone. ");
INSERT INTO nld_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","En de kinderen Israels deden alzo, en zonden hen tot buiten het leger; gelijk de HEERE tot Mozes gesproken had, alzo deden de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Spreek tot de kinderen Israels: Wanneer een man of een vrouw iets van enige menselijke zonden gedaan zullen hebben, overtreden hebbende door overtreding tegen den HEERE, zo is diezelve ziel schuldig. ");
INSERT INTO nld_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","En zij zullen hun zonde, welke zij gedaan hebben, belijden; daarna zal hij zijn schuld weder uitkeren, naar de hoofdsom daarvan, en derzelfder vijfde deel zal hij daarboven toedoen, en zal het dien geven, aan wien hij zich verschuldigd heeft. ");
INSERT INTO nld_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Maar zo die man geen losser zal hebben, om de schuld aan hem weder uit te keren, zal die schuld, welken den HEERE weder uitgekeerd wordt, des priesters zijn; behalve den ram der verzoening, met welken hij voor hem verzoening doen zal. ");
INSERT INTO nld_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Desgelijks zal alle heffing van alle geheiligde dingen der kinderen Israels, welke zij tot den priester brengen, zijne zijn. ");
INSERT INTO nld_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","En een ieders geheiligde dingen zullen zijne zijn; wat iemand den priester zal gegeven hebben, zal zijne zijn. ");
INSERT INTO nld_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Wijders sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Spreek tot de kinderen Israels, en zeg tot hen: Wanneer van iemand zijn huisvrouw zal afgeweken zijn, en door overtreding tegen hem overtreden zal hebben; ");
INSERT INTO nld_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Dat een man bij haar door bijligging des zaads zal gelegen hebben, en het voor de ogen haars mans zal verborgen zijn, en zij zich verheeld zal hebben, zijnde nochtans onrein geworden; en geen getuige tegen haar is, en zij niet betrapt is; ");
INSERT INTO nld_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","En de ijvergeest over hem gekomen is, dat hij ijvert over zijn huisvrouw, dewijl zij onrein geworden is; of dat over hem de ijvergeest gekomen is, dat hij over zijn huisvrouw ijvert, hoewel zij niet onrein geworden is; ");
INSERT INTO nld_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Dan zal die man zijn huisvrouw tot den priester brengen, en zal haar offerande voor haar medebrengen, een tiende deel van een efa gerstemeel; hij zal geen olie daarop gieten, noch wierook daarop leggen, dewijl het een spijsoffer der ijveringen is, een spijsoffer der gedachtenis, dat de ongerechtigheid in gedachtenis brengt. ");
INSERT INTO nld_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","En de priester zal haar doen naderen; hij zal haar stellen voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","En de priester zal heilig water in een aarden vat nemen; en van het stof, hetwelk op den vloer des tabernakels is, zal de priester nemen, en in het water doen. ");
INSERT INTO nld_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Daarna zal de priester de vrouw voor het aangezicht des HEEREN stellen, en zal het hoofd van de vrouw ontbloten, en zal het spijsoffer der gedachtenis op haar handen leggen, hetwelk het spijsoffer der ijveringen is; en in de hand des priesters zal dat bitter water zijn, hetwelk den vloek medebrengt. ");
INSERT INTO nld_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","En de priester zal haar beedigen, en zal tot die vrouw zeggen: Indien iemand bij u gelegen heeft, en indien gij, onder uw man zijnde, niet afgeweken zijt tot onreinigheid, wees vrij van dit bitter water, hetwelk den vloek medebrengt! ");
INSERT INTO nld_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Maar zo gij, onder uw man zijnde, afgeweken zijt, en zo gij onrein geworden zijt, dat een man bij u gelegen heeft, behalve uw man: ");
INSERT INTO nld_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(Dan zal de priester die vrouw met den eed der vervloeking beedigen, en de priester zal tot die vrouw zeggen:) De HEERE zette u tot een vloek, en tot een eed, in het midden uws volks, mits dat de HEERE uw heup vervallende, en uw buik zwellende make; ");
INSERT INTO nld_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Dat ditzelve water, hetwelk de vervloeking medebrengt, in uw ingewand inga, om den buik te doen zwellen, en de heup te doen vervallen! Dan zal die vrouw zeggen: Amen, amen! ");
INSERT INTO nld_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Daarna zal de priester deze zelfde vloeken op een cedeltje schrijven, en hij zal het met het bitter water uitdoen. ");
INSERT INTO nld_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","En hij zal die vrouw dat bitter water, hetwelk de vervloeking medebrengt, te drinken geven, dat het water, hetwelk de vervloeking medebrengt, in haar tot bitterheden inga. ");
INSERT INTO nld_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","En de priester zal uit de hand van die vrouw het spijsoffer der ijveringen nemen, en hij zal datzelve spijsoffer voor het aangezicht des HEEREN bewegen, en zal dat op het altaar offeren. ");
INSERT INTO nld_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","De priester zal ook van dat spijsoffer, deszelfs gedenkoffer, een handvol grijpen, en zal het op het altaar aansteken; en daarna zal hij dat water die vrouw te drinken geven. ");
INSERT INTO nld_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Als hij haar nu dat water zal te drinken gegeven hebben, het zal geschieden, indien zij onrein geworden is, en tegen haar man door overtreding zal overtreden hebben, dat het water, hetwelk vervloeking medebrengt, tot bitterheid in haar ingaan zal, en haar buik zwellen, en haar heup vervallen zal; en die vrouw zal in het midden van haar volk tot een vloek zijn. ");
INSERT INTO nld_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Doch indien de vrouw niet onrein geworden is, maar rein is, zo zal zij vrij zijn, en zal met zaad bezadigd worden. ");
INSERT INTO nld_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Dit is de wet der ijveringen, als een vrouw, onder haar man zijnde, zal afgeweken en onrein geworden zijn; ");
INSERT INTO nld_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Of als over en man die ijvergeest zal gekomen zijn, en hij over zijn huisvrouw zal geijverd hebben, dat hij de vrouw voor het aangezicht des HEEREN stelle, en de priester aan haar deze ganse wet volbrenge. ");
INSERT INTO nld_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","En de man zal van de ongerechtigheid onschuldig zijn; maar diezelve vrouw zal haar ongerechtigheid dragen. ");
INSERT INTO nld_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Spreek tot de kinderen Israels, en zeg tot hen: Wanneer een man of een vrouw zich afgescheiden zal hebben, belovende de gelofte eens Nazireers, om zich den HEERE af te zonderen; ");
INSERT INTO nld_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Van wijn en sterken drank zal hij zich afzonderen; wijnedik, en edik van sterken drank zal hij niet drinken, noch enige vochtigheid van druiven zal hij drinken, noch verse of gedroogde druiven eten. ");
INSERT INTO nld_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Al de dagen van zijn Nazireerschap zal hij niet eten van iets, dat van den wijnstok des wijns gemaakt is, van de kernen af tot de basten toe. ");
INSERT INTO nld_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Al de dagen der gelofte van zijn Nazireerschap zal het scheermes over zijn hoofd niet gaan; totdat die dagen vervuld zullen zijn, die hij zich den HEERE zal afgezonderd hebben, zal hij heilig zijn, latende de lokken van het haar zijns hoofds wassen. ");
INSERT INTO nld_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Al de dagen, die hij zich den HEERE zal afgezonderd hebben, zal hij tot het lichaam eens doden niet gaan. ");
INSERT INTO nld_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Om zijn vader of om zijn moeder, om zijn broeder of om zijn zuster, om hen zal hij zich niet verontreinigen, als zij dood zijn; want het Nazireerschap zijns Gods is op zijn hoofd. ");
INSERT INTO nld_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Al de dagen van zijn Nazireerschap is hij den HEERE heilig. ");
INSERT INTO nld_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","En zo de gestorvene bij hem onvoorziens haastelijk gestorven ware, dat hij het hoofd van zijn Nazireerschap zou verontreinigd hebben, zo zal hij op den dag zijner reiniging zijn hoofd bescheren; op den zevenden dag zal hij het bescheren. ");
INSERT INTO nld_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","En op den achtsten dag zal hij twee tortelduiven, of twee jonge duiven brengen tot den priester, tot de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","De priester nu zal een bereiden ten zondoffer, en een ten brandoffer, en zal voor hem verzoening doen, van dat hij aan het dode lichaam gezondigd heeft; alzo zal hij zijn hoofd op dienzelfden dag heiligen. ");
INSERT INTO nld_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Daarna zal hij de dagen van zijn Nazireerschap den HEERE afzonderen, en zal een lam, dat eenjarig is, brengen ten schuldoffer; en de vorige dagen zullen vallen, omdat zijn Nazireerschap verontreinigd was. ");
INSERT INTO nld_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","En dit is de wet des Nazireers: op den dag, als de dagen van zijn Nazireerschap zullen vervuld zijn, zal hij dit brengen tot de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Hij dan zal tot zijn offerande den HEERE offeren een volkomen eenjarig lam ten brandoffer, en een volkomen eenjarig ooilam ten zondoffer, en een volkomen ram ten dankoffer. ");
INSERT INTO nld_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","En een korf ongezuurde koeken, koeken van meelbloem, met olie gemengd, en ongezuurde vladen, met olie bestreken, mitsgaders hun spijsoffer, en hun drankofferen; ");
INSERT INTO nld_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","En de priester zal het voor het aangezicht des HEEREN brengen, en zal zijn zondoffer en zijn brandoffer bereiden. ");
INSERT INTO nld_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Hij zal ook den ram ten dankoffer den HEERE bereiden, met den korf der ongezuurde koeken; en de priester zal zijn spijsoffer en zijn drankoffer bereiden. ");
INSERT INTO nld_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Alsdan zal de Nazireer, aan de deur van de tent der samenkomst, het hoofd van zijn Nazireerschap bescheren; en hij zal het hoofdhaar van zijn Nazireerschap nemen, en hij zal het leggen op het vuur, dat onder het dankoffer is. ");
INSERT INTO nld_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Daarna zal de priester een gezoden schouder nemen van den ram, en een ongezuurden koek uit den korf, en een ongezuurde vlade; en hij zal ze op de handen des Nazireers leggen, nadat hij zijn Nazireerschap afgeschoren heeft. ");
INSERT INTO nld_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","En de priester zal die bewegen ten beweegoffer, voor het aangezicht des HEEREN; het is een heilig ding voor den priester, met de borst des beweegoffers, en met den schouder des hefoffers; en daarna zal die Nazireer wijn drinken. ");
INSERT INTO nld_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Dit is de wet des Nazireers, die zijn offerande den HEERE voor zijn Nazireerschap zal beloofd hebben, behalve wat zijn hand bekomen zal; naar zijn gelofte, welke hij beloofd zal hebben, alzo zal hij doen, naar de wet van zijn Nazireerschap. ");
INSERT INTO nld_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Spreek tot Aaron en zijn zonen, zeggende: Alzo zult gijlieden de kinderen Israels zegenen, zeggende tot hen: ");
INSERT INTO nld_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","De HEERE zegene u, en behoede u! ");
INSERT INTO nld_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","De HEERE doe Zijn aangezicht over u lichten, en zij u genadig! ");
INSERT INTO nld_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","De HEERE verheffe Zijn aangezicht over u, en geve u vrede! ");
INSERT INTO nld_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Alzo zullen zij Mijn Naam op de kinderen Israels leggen; en Ik zal hen zegenen. ");
INSERT INTO nld_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","En het geschiedde ten dage, als Mozes geeindigd had den tabernakel op te richten, en dat hij dien gezalfd, en dien geheiligd had, en al zijn gereedschap, mitsgaders het altaar en al zijn gereedschap, en hij ze gezalfd, en dezelve geheiligd had; ");
INSERT INTO nld_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Dat de oversten van Israel, de hoofden van het huis hunner vaderen, offerden; deze waren de oversten der stammen, die over de getelden stonden. ");
INSERT INTO nld_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","En zij brachten hun offerande voor het aangezicht des HEEREN, zes overdekte wagens, en twaalf runderen; een wagen voor twee oversten, en een os voor elk een; en brachten ze voor den tabernakel. ");
INSERT INTO nld_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Neem ze van hen, opdat zij zijn mogen om te bedienen den dienst van de tent der samenkomst; en gij zult dezelve den Levieten geven, een ieder naar zijn dienst. ");
INSERT INTO nld_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Alzo nam Mozes die wagens, en die runderen, en gaf dezelve den Levieten. ");
INSERT INTO nld_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Twee wagens en vier runderen gaf hij den zonen van Gerson, naar hun dienst; ");
INSERT INTO nld_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","En vier wagens en acht runderen gaf hij den zonen van Merari, naar hun dienst; onder de hand van Ithamar, den zoon van Aaron, den priester. ");
INSERT INTO nld_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Maar de zonen van Kohath gaf hij niet; want de dienst der heilige dingen was op hen, die zij op de schouderen droegen. ");
INSERT INTO nld_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","En de oversten offerden ter inwijding des altaars, op den dag als hetzelve gezalfd werd; de oversten dan offerden hun offeranden voor het altaar. ");
INSERT INTO nld_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","En de HEERE zeide tot Mozes: Elke overste zal (een iegelijk op zijn dag) zijn offerande offeren, ter inwijding des altaars. ");
INSERT INTO nld_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Die nu op den eersten dag zijn offerande offerde, was Nahesson, de zoon van Amminadab, voor den stam van Juda. ");
INSERT INTO nld_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","En zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Nahesson, den zoon van Amminadab. ");
INSERT INTO nld_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Op den tweeden dag offerde Nethaneel, de zoon van Zuar, de overste van Issaschar. ");
INSERT INTO nld_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Hij offerde zijn offerande: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","En een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Nethaneel, den zoon van Zuar. ");
INSERT INTO nld_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Op den derden dag offerde de overste der zonen van Zebulon, Eliab, de zoon van Helon. ");
INSERT INTO nld_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Eliab, den zoon van Helon. ");
INSERT INTO nld_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Op den vierden dag offerde de overste der kinderen van Ruben, Elizur, de zoon van Sedeur. ");
INSERT INTO nld_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Elizur, den zoon van Sedeur. ");
INSERT INTO nld_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Op den vijfden dag offerde de overste der kinderen van Simeon, Selumiel, de zoon van Zurisaddai. ");
INSERT INTO nld_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Selumiel, den zoon van Zurisaddai. ");
INSERT INTO nld_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Op den zesden dag offerde de overste der kinderen van Gad, Eljasaf, den zoon van Dehuel. ");
INSERT INTO nld_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; beide vol meelbloem gemengd met olie, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Eljasaf, den zoon van Dehuel. ");
INSERT INTO nld_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Op den zevenden dag offerde de overste der kinderen van Efraim, Elisama, den zoon van Ammihud. ");
INSERT INTO nld_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Elisama, den zoon van Ammihud. ");
INSERT INTO nld_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Op den achtsten dag offerde de overste der kinderen van Manasse, Gamaliel, de zoon van Pedazur. ");
INSERT INTO nld_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Gamaliel, den zoon van Pedazur. ");
INSERT INTO nld_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Op den negenden dag offerde de overste der kinderen van Benjamin, Abidan, de zoon van Gideoni. ");
INSERT INTO nld_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Abidan, den zoon van Gideoni. ");
INSERT INTO nld_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Op den tienden dag offerde de overste der kinderen van Dan, Ahiezer, de zoon van Ammisaddai. ");
INSERT INTO nld_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Ahiezer, den zoon van Ammisaddai. ");
INSERT INTO nld_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Op den elfden dag offerde de overste der kinderen van Aser, Pagiel, de zoon van Ochran. ");
INSERT INTO nld_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Pagiel, den zoon van Ochran. ");
INSERT INTO nld_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Op den twaalfden dag offerde de overste der kinderen van Nafthali, Ahira, de zoon van Enan. ");
INSERT INTO nld_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Zijn offerande was: een zilveren schotel, welks gewicht was honderd dertig sikkelen; een zilveren sprengbekken van zeventig sikkelen, naar den sikkel des heiligdoms; zij waren beide vol meelbloem met olie gemengd, ten spijsoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Een reukschaal van tien gouden sikkelen, vol reukwerks; ");
INSERT INTO nld_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Een var, een jong rund, een ram, een lam, dat eenjarig was, ten brandoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Een geitenbok, ten zondoffer; ");
INSERT INTO nld_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","En ten dankoffer: twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren. Dit was de offerande van Ahira, den zoon van Enan. ");
INSERT INTO nld_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Dit was de inwijding des altaars van de oversten van Israel, op den dag als hetzelve gezalfd werd: twaalf zilveren schotels, twaalf zilveren sprengbekkens, twaalf gouden reukschalen. ");
INSERT INTO nld_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Een zilveren schotel was van honderd dertig sikkelen, en een sprengbekken van zeventig; al het zilver van de vaten was twee duizend en vierhonderd sikkelen, naar den sikkel des heiligdoms. ");
INSERT INTO nld_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Twaalf gouden reukschalen van reukwerks; elke reukschaal was van tien sikkelen, naar den sikkel des heiligdoms; al het goud der reukschalen was honderd en twintig sikkelen. ");
INSERT INTO nld_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Al de runderen ten brandoffer waren twaalf varren, twaalf rammen, twaalf eenjarige lammeren, met hun spijsoffer; en twaalf geitenbokken ten zondoffer. ");
INSERT INTO nld_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","En al de runderen ten dankoffer waren vier en twintig varren, de rammen zestig, de bokken zestig, de eenjarige lammeren zestig. Dit is de inwijding des altaars, nadat hetzelve gezalfd was. ");
INSERT INTO nld_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","En als Mozes in de tent der samenkomst ging, om met Hem te spreken, zo hoorde hij een stem tot hem sprekende, van boven het verzoendeksel, hetwelk is op de ark der getuigenis, van tussen de twee cherubim. Alzo sprak Hij tot hem. ");
INSERT INTO nld_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Spreek tot Aaron, en zeg tot hem: Als gij de lampen aansteken zult, recht tegenover den kandelaar zullen de zeven lampen lichten. ");
INSERT INTO nld_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","En Aaron deed alzo: tegenover vooraan den kandelaar stak hij deszelfs lampen aan; gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Dit werk nu des kandelaars was van dicht goud, tot zijn schacht, tot zijn bloemen was het dicht; naar de gedaante, die de HEERE Mozes vertoond had, alzo had hij den kandelaar gemaakt. ");
INSERT INTO nld_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Neem de Levieten uit het midden van de kinderen Israels, en reinig hen. ");
INSERT INTO nld_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","En aldus zult gij hun doen, om hen te reinigen: spreng op hen water der ontzondiging; en zij zullen het scheermes over hun ganse vlees doen gaan, en zij zullen hun klederen wassen, en zich reinigen. ");
INSERT INTO nld_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Daarna zullen zij nemen een var, een jong rund, met zijn spijsoffer van meelbloem, met olie gemengd; en een anderen var, een jong rund, zult gij nemen ten zondoffer. ");
INSERT INTO nld_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","En gij zult de Levieten voor de tent der samenkomst doen naderen; en gij zult de gehele vergadering der kinderen Israels doen verzamelen. ");
INSERT INTO nld_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ja, gij zult de Levieten voor het aangezicht des HEEREN doen naderen; en de kinderen Israels zullen hun handen op de Levieten leggen. ");
INSERT INTO nld_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","En Aaron zal de Levieten bewegen ten beweegoffer voor het aangezicht des HEEREN, vanwege de kinderen Israels; opdat zij zijn, om den dienst des HEEREN te bedienen. ");
INSERT INTO nld_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","En de Levieten zullen hun handen op het hoofd der varren leggen; daarna bereidt gij een ten zondoffer, en een ten brandoffer den HEERE, om over de Levieten verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","En gij zult de Levieten stellen voor het aangezicht van Aaron, en voor het aangezicht van zijn zonen, en gij zult hen bewegen ten beweegoffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","En gij zult de Levieten uit het midden van de kinderen Israels uitscheiden, opdat de Levieten Mijn zijn. ");
INSERT INTO nld_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","En daarna zullen de Levieten inkomen, om de tent der samenkomst te bedienen; en gij zult hen reinigen, en zult hen ten beweegoffer bewegen. ");
INSERT INTO nld_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Want zij zijn gegeven, zij zijn Mij gegeven uit het midden van de kinderen Israels; voor de opening van alle baarmoeder, voor de eerstgeborenen van een ieder uit de kinderen Israels, heb Ik ze Mij genomen. ");
INSERT INTO nld_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Want alle eerstgeborene onder de kinderen Israels is Mijn, onder de mensen en onder de beesten; ten dage dat Ik alle eerstgeboorte in Egypteland sloeg, heb Ik dezelve Mij geheiligd. ");
INSERT INTO nld_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","En Ik heb de Levieten genomen voor alle eerstgeborenen onder de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","En Ik heb de Levieten aan Aaron en aan zijn zonen tot een gift gegeven, uit het midden van de kinderen Israels, om den dienst van de kinderen Israels in de tent der samenkomst te bedienen, en om voor de kinderen Israels verzoening te doen, dat er geen plage zij onder de kinderen Israels, als de kinderen Israels tot het heiligdom naderen zouden. ");
INSERT INTO nld_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","En Mozes deed, en Aaron, en de ganse vergadering der kinderen Israels, aan de Levieten, naar alles, wat de HEERE Mozes geboden had van de Levieten, zo deden de kinderen Israels aan hen. ");
INSERT INTO nld_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","En de Levieten ontzondigden zich, en wiesen hun klederen, en Aaron bewoog hen ten beweegoffer voor het aangezicht des HEEREN; en Aaron deed verzoening over hen, om hen te reinigen. ");
INSERT INTO nld_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","En daarna kwamen de Levieten, om hun dienst te bedienen in de tent der samenkomst, voor het aangezicht van Aaron, en voor het aangezicht zijner zonen; gelijk als de HEERE Mozes van de Levieten geboden had, alzo deden zij aan hen. ");
INSERT INTO nld_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dit is het, wat de Levieten aangaat: van vijf en twintig jaren oud en daarboven, zullen zij inkomen, om den strijd te strijden, in den dienst van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Maar van dat hij vijftig jaren oud is, zal hij van den strijd van dezen dienst afgaan, en hij zal niet meer dienen. ");
INSERT INTO nld_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Doch hij zal met zijn broederen dienen in de tent der samenkomst, om de wacht waar te nemen; maar den dienst zal hij niet bedienen. Alzo zult gij aan de Levieten doen in hun wachten. ");
INSERT INTO nld_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","En de HEERE sprak tot Mozes in de woestijn van Sinai, in het tweede jaar, nadat zij uit Egypteland uitgetogen waren, in de eerste maand, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Dat de kinderen Israels het pascha houden zouden, op zijn gezetten tijd. ");
INSERT INTO nld_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Op den veertienden dag in deze maand, tussen twee avonden zult gij dat houden, op zijn gezetten tijd; naar al zijn inzettingen, en naar al zijn rechten zult gij dat houden. ");
INSERT INTO nld_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mozes dan sprak tot de kinderen Israels, dat zij het pascha zouden houden. ");
INSERT INTO nld_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","En zij hielden het pascha op den veertienden dag der eerste maand, tussen de twee avonden, in de woestijn van Sinai; naar alles, wat de HEERE Mozes geboden had, alzo deden de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Toen waren er lieden geweest, die over het dode lichaam eens mensen onrein waren, en op denzelven dag het pascha niet hadden kunnen houden; daarom naderden zij voor het aangezicht van Mozes, en voor het aangezicht van Aaron op dienzelven dag. ");
INSERT INTO nld_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","En diezelve lieden zeiden tot hem: Wij zijn onrein over het dode lichaam eens mensen; waarom zouden wij verkort worden, dat wij de offerande des HEEREN op zijn gezetten tijd niet zouden offeren, in het midden van de kinderen Israels? ");
INSERT INTO nld_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","En Mozes zeide tot hen: Blijft staande, dat ik hoor, wat de HEERE u gebieden zal. ");
INSERT INTO nld_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Spreek tot de kinderen Israels, zeggende: Wanneer iemand onder u, of onder uw geslachten, over een dood lichaam onrein, of op een verren weg zal zijn, hij zal dan nog den HEERE het pascha houden. ");
INSERT INTO nld_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","In de tweede maand, op den veertienden dag, tussen de twee avonden, zullen zij dat houden; met ongezuurde broden en bittere saus zullen zij dat eten. ");
INSERT INTO nld_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Zij zullen daarvan niet overlaten tot den morgen, en zullen daaraan geen been breken; naar alle inzetting van het pascha zullen zij dat houden. ");
INSERT INTO nld_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Als een man, die rein is, en op den weg niet is, en nalaten zal het pascha te houden, zo zal diezelve ziel uit haar volken uitgeroeid worden; want hij heeft de offerande des HEEREN op zijn gezetten tijd niet geofferd, diezelve man zal zijn zonde dragen. ");
INSERT INTO nld_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","En wanneer een vreemdeling bij u als vreemdeling verkeert, en hij het pascha den HEERE ook houden zal, naar de inzetting van het pascha, en naar zijn wijze, alzo zal hij het houden; het zal enerlei inzetting voor ulieden zijn, beiden den vreemdeling en den inboorling des lands. ");
INSERT INTO nld_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","En op den dag van het oprichten des tabernakels bedekte de wolk den tabernakel, op de tent der getuigenis; en in den avond was over den tabernakel als een gedaante des vuurs, tot aan den morgen. ");
INSERT INTO nld_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Alzo geschiedde het geduriglijk; de wolk bedekte denzelven, en des nachts was er een gedaante des vuurs. ");
INSERT INTO nld_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Maar nadat de wolk opgeheven werd van boven de tent, zo verreisden ook daarna de kinderen Israels; en in de plaats, waar de wolk bleef, daar legerden zich de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Naar den mond des HEEREN, verreisden de kinderen Israels, en naar des HEEREN mond legerden zij zich; al de dagen, in dewelke de wolk over den tabernakel bleef, legerden zij zich. ");
INSERT INTO nld_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","En als de wolk vele dagen over den tabernakel verbleef, zo namen de kinderen Israels de wacht des HEEREN waar, en verreisden niet. ");
INSERT INTO nld_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Als het nu was, dat de wolk weinige dagen op den tabernakel was, naar den mond des HEEREN legerden zij zich, en naar den mond des HEEREN verreisden zij. ");
INSERT INTO nld_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Maar was het, dat de wolk van den avond tot den morgen daar was, en de wolk in den morgen opgeheven werd, zo verreisden zij; of des daags, of des nachts, als de wolk opgeheven werd, zo verreisden zij. ");
INSERT INTO nld_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Of als de wolk twee dagen, of een maand, of vele dagen vertoog op den tabernakel, blijvende daarop, zo legerden zich de kinderen Israels, en verreisden niet; en als zij verheven werd, verreisden zij. ");
INSERT INTO nld_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Naar den mond des HEEREN legerden zij zich, en naar den mond des HEEREN verreisden zij; zij namen de wacht des HEEREN waar, naar den mond des HEEREN, door de hand van Mozes. ");
INSERT INTO nld_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Maak u twee zilveren trompetten; van dicht werk zult gij ze maken; en zij zullen u zijn tot de samenroeping der vergadering, en tot den optocht der legers. ");
INSERT INTO nld_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Als zij met dezelve blazen zullen, dan zal de gehele vergadering tot u vergaderd worden, aan de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Maar als zij met de ene zullen blazen, dan zullen tot u vergaderd worden de oversten, de hoofden der duizenden van Israel. ");
INSERT INTO nld_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Als gij met een gebroken geklank blazen zult, dan zullen de legers, die tegen het oosten gelegerd zijn, optrekken. ");
INSERT INTO nld_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Maar als gij ten tweeden male met een gebroken klank blazen zult, zullen de legers, die tegen het zuiden legeren, optrekken; met een gebroken klank zullen zij blazen tot hun optochten. ");
INSERT INTO nld_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Maar in het verzamelen van de gemeente, zult gij blazen, doch geen gebroken geklank maken. ");
INSERT INTO nld_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","En de zonen van Aaron, de priesters, zullen met die trompetten blazen; en zij zullen ulieden zijn tot een eeuwige inzetting bij uw geslachten. ");
INSERT INTO nld_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","En wanneer gijlieden in uw land ten strijde zult trekken tegen den vijand, die u benauwt, zult gij ook met die trompetten een gebroken klank maken; zo zal uwer gedacht worden voor het aangezicht des HEEREN, uws Gods, en gij zult van uw vijanden verlost worden. ");
INSERT INTO nld_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Desgelijks ten dage uwer vrolijkheid, en in uw gezette hoogtijden, en in de beginselen uwer maanden, zult gij ook met de trompetten blazen over uw brandofferen, en over uw dankofferen; en zij zullen u ter gedachtenis zijn voor het aangezicht uws Gods; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","En het geschiedde in het tweede jaar, in de tweede maand, op den twintigsten van de maand, dat de wolk verheven werd van boven den tabernakel der getuigenis. ");
INSERT INTO nld_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","En de kinderen Israels togen op, naar hun tochten, uit de woestijn Sinai; en de wolk bleef in de woestijn Paran. ");
INSERT INTO nld_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Alzo togen zij vooreerst op, naar den mond des HEEREN, door de hand van Mozes. ");
INSERT INTO nld_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Want vooreerst toog op de banier van het leger der kinderen van Juda, naar hun heiren; en over zijn heir was Nahesson, de zoon van Amminadab. ");
INSERT INTO nld_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","En over het heir van den stam der kinderen van Issaschar was Nethaneel, den zoon van Zuar. ");
INSERT INTO nld_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","En over het heir van den stam der kinderen van Zebulon was Eliab, de zoon van Helon. ");
INSERT INTO nld_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Toen werd de tabernakel afgenomen, en de zonen van Gerson, en de zonen van Merari togen op, dragende den tabernakel. ");
INSERT INTO nld_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Daarna toog de banier van het leger van Ruben, naar hun heiren; en over zijn heir was Elizur, de zoon van Sedeur. ");
INSERT INTO nld_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","En over het heir van den stam der kinderen van Simeon was Selumiel, de zoon van Zurisaddai. ");
INSERT INTO nld_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","En over het heir van den stam der kinderen van Gad was Eljasaf, de zoon van Dehuel. ");
INSERT INTO nld_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Toen togen op de Kohathieten, dragende het heiligdom; en de anderen richtten den tabernakel op, tegen dat dezen kwamen. ");
INSERT INTO nld_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Daarna toog op de banier van het leger der kinderen van Efraim, naar hun heiren; en over het heir was Elisama, de zoon van Ammihud. ");
INSERT INTO nld_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","En over het heir van den stam der kinderen van Manasse was Gamaliel, de zoon van Pedazur. ");
INSERT INTO nld_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","En over het heir van den stam der kinderen van Benjamin was Abidan, de zoon van Gideoni. ");
INSERT INTO nld_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Toen toog op de banier van het leger der kinderen van Dan, samensluitende al de legers, naar hun heiren; en over zijn heir was Ahiezer de zoon van Ammisaddai. ");
INSERT INTO nld_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","En over het heir van den stam der kinderen van Aser was Pagiel, de zoon van Ochran. ");
INSERT INTO nld_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","En over het heir van den stam der kinderen van Nafthali was Ahira, de zoon van Enan. ");
INSERT INTO nld_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Dit waren de tochten der kinderen Israels, naar hun heiren, als zij reisden. ");
INSERT INTO nld_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mozes nu zeide tot Hobab, den zoon van Rehuel, den Midianiet, den schoonvader van Mozes: Wij reizen naar die plaats, van welke de HEERE gezegd heeft: Ik zal u die geven; ga met ons, en wij zullen u weldoen, want de HEERE heeft over Israel het goede gesproken. ");
INSERT INTO nld_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Doch hij zeide tot hem: Ik zal niet gaan; maar ik zal naar mijn land en naar mijn maagschap gaan. ");
INSERT INTO nld_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","En hij zeide: Verlaat ons toch niet; want dewijl gij weet, dat wij ons legeren in de woestijn, zo zult gij ons tot ogen zijn. ");
INSERT INTO nld_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","En het zal geschieden, als gij met ons zult gaan, en het goede geschieden zal, waarmede de HEERE bij ons weldoen zal, dat wij u ook weldoen zullen. ");
INSERT INTO nld_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Zo togen zij drie dagreizen van den berg des HEEREN; en de ark des verbonds des HEEREN reisde voor hun aangezicht drie dagreizen, om voor hen een rustplaats uit te speuren. ");
INSERT INTO nld_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","En de wolk des HEEREN was des daags over hen, als zij uit het leger verreisden. ");
INSERT INTO nld_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Het geschiedde nu in het optrekken van de ark, dat Mozes zeide: Sta op, HEERE! en laat Uw vijanden verstrooid worden, en Uw haters van Uw aangezicht vlieden! ");
INSERT INTO nld_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","En als zij rustte, zeide hij: Kom weder, HEERE! tot de tien duizenden der duizenden van Israel! ");
INSERT INTO nld_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","En het geschiedde, als het volk zich was beklagende, dat het kwaad was in de oren des HEEREN; want de HEERE hoorde het, zodat Zijn toorn ontstak, en het vuur des HEEREN onder hen ontbrandde, en verteerde, in het uiterste des legers. ");
INSERT INTO nld_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Toen riep het volk tot Mozes; en Mozes bad tot den HEERE; en het vuur werd gedempt. ");
INSERT INTO nld_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Daarom noemde hij den naam dier plaats Thab-era, omdat het vuur des HEEREN onder hen gebrand had. ");
INSERT INTO nld_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","En het gemene volk, dat in het midden van hen was, werd met lust bevangen; daarom zo weenden ook de kinderen Israels wederom, en zeiden: Wie zal ons vlees te eten geven? ");
INSERT INTO nld_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wij gedenken aan de vissen, die wij in Egypte om niet aten; aan de komkommers, en aan de pompoenen, en aan het look, en aan de ajuinen, en aan het knoflook. ");
INSERT INTO nld_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Maar nu is onze ziel dor, er is niet met al, behalve dit Man voor onze ogen! ");
INSERT INTO nld_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Het Man nu was als korianderzaad, en zijn verf was als de verf van den bedolah. ");
INSERT INTO nld_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Het volk liep hier en daar, en verzamelde het, en maalde het met molens, of stiet het in mortieren, en zood het in potten, en maakte daarvan koeken; en zijn smaak was als de smaak van de beste vochtigheid der olie. ");
INSERT INTO nld_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","En wanneer de dauw des nachts op het leger nederviel, viel het Man op hetzelve neder. ");
INSERT INTO nld_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Toen hoorde Mozes het volk wenen door hun huisgezinnen, een ieder aan de deur zijner hut; en de toorn des HEEREN ontstak zeer; ook was het kwaad in de ogen van Mozes. ");
INSERT INTO nld_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","En Mozes zeide tot de HEERE: Waarom hebt Gij aan Uw knecht kwalijk gedaan, en waarom heb ik geen genade in Uw ogen gevonden, dat Gij den last van dit ganse volk op mij legt? ");
INSERT INTO nld_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Heb ik dan al dit volk ontvangen? heb ik het gebaard? dat Gij tot mij zoudt zeggen: Draag het in uw schoot, gelijk als een voedstervader den zuigeling draagt, tot dat land, hetwelk Gij hun vaderen gezworen hebt? ");
INSERT INTO nld_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Van waar zou ik het vlees hebben, om al dit volk te geven? Want zij wenen tegen mij, zeggende: Geef ons vlees, dat wij eten! ");
INSERT INTO nld_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ik alleen kan al dit volk niet dragen; want het is mij te zwaar! ");
INSERT INTO nld_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","En indien Gij alzo aan mij doet, dood mij toch slechts, indien ik genade in Uw ogen gevonden heb; en laat mij mijn ongeluk niet aanzien! ");
INSERT INTO nld_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","En de HEERE zeide tot Mozes: Verzamel Mij zeventig mannen uit de oudsten van Israel, dewelke gij weet, dat zij de oudsten des volks en deszelfs ambtlieden zijn; en gij zult hen brengen voor de tent der samenkomst, en zij zullen zich daar bij u stellen. ");
INSERT INTO nld_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Zo zal Ik afkomen en met u aldaar spreken; en van den Geest, die op u is, zal Ik afzonderen, en op hen leggen; en zij zullen met u den last van dit volk dragen, opdat gij dien alleen niet draagt. ");
INSERT INTO nld_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","En tot het volk zult gij zeggen: Heiligt u tegen morgen, en gij zult vlees eten; want gij hebt voor de oren des HEEREN geweend, zeggende: Wie zal ons vlees te eten geven? want het ging ons wel in Egypte! Daarom zal de HEERE u vlees geven, en gij zult eten. ");
INSERT INTO nld_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Gij zult niet een dag, noch twee dagen eten, noch vijf dagen, noch tien dagen, noch twintig dagen; ");
INSERT INTO nld_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Tot een gehele maand toe, totdat het uit uw neus uitga, en u tot walging zij; overmits gij den HEERE, Die in het midden van u is, verworpen hebt, en hebt voor Zijn aangezicht geweend, zeggende: Waarom nu zijn wij uit Egypte getogen? ");
INSERT INTO nld_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","En Mozes zeide: Zeshonderd duizend te voet is dit volk, in welks midden ik ben; en Gij hebt gezegd: Ik zal hun vlees geven, en zij zullen een gehele maand eten! ");
INSERT INTO nld_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Zullen dan voor hen schapen en runderen geslacht worden, dat voor hen genoeg zij? zullen al de vissen der zee voor hen verzameld worden, dat voor hen genoeg zij? ");
INSERT INTO nld_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Doch de HEERE zeide tot Mozes: Zou dan des HEEREN hand verkort zijn? Gij zult nu zien, of Mijn woord u wedervaren zal, of niet. ");
INSERT INTO nld_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","En Mozes ging uit, en sprak de woorden des HEEREN tot het volk; en hij verzamelde zeventig mannen uit de oudsten des volks, en stelde hen rondom de tent. ");
INSERT INTO nld_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Toen kwam de HEERE af in de wolk, en sprak tot hem, en afzonderende van den Geest, die op hem was, legde Hem op de zeventig mannen, die oudsten; en het geschiedde, als de Geest op hen rustte, dat zij profeteerden, maar daarna niet meer. ");
INSERT INTO nld_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Maar twee mannen waren in het leger overgebleven; des enen naam was Eldad, en des anderen naam Medad; en die Geest rustte op hen (want zij waren onder de aangeschrevenen, hoewel zij tot de tent niet uitgegaan waren), en zij profeteerden in het leger. ");
INSERT INTO nld_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Toen liep een jongen heen, en boodschapte aan Mozes, en zeide: Eldad en Medad profeteren in het leger. ");
INSERT INTO nld_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","En Jozua, de zoon van Nun, de dienaar van Mozes, een van zijn uitgelezen jongelingen, antwoordde en zeide: Mijn heer Mozes, verbied hun! ");
INSERT INTO nld_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Doch Mozes zeide tot hem: Zijt gij voor mij ijverende? Och, of al het volk des HEEREN profeten waren, dat de HEERE Zijn Geest over hen gave! ");
INSERT INTO nld_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Daarna verzamelde zich Mozes tot het leger, hij en de oudsten van Israel. ");
INSERT INTO nld_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Toen voer een wind uit van den HEERE, en raapte kwakkelen van de zee, en strooide ze bij het leger, omtrent een dagreize herwaarts, en omtrent een dagreize derwaarts, rondom het leger; en zij waren omtrent twee ellen boven de aarde. ");
INSERT INTO nld_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Toen maakte zich het volk op, dien gehelen dag, en dien gansen nacht, en den gansen anderen dag, en verzamelden de kwakkelen; die het minst had, had tien homers verzameld; en zij spreidden ze voor zich van elkander rondom het leger. ");
INSERT INTO nld_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Dat vlees was nog tussen hun tanden, eer het gekauwd was, zo ontstak de toorn des HEEREN tegen het volk, en de HEERE sloeg het volk met een zeer grote plaag. ");
INSERT INTO nld_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daarom heet men den naam derzelver plaats Kibroth Thaava; want daar begroeven zij het volk, dat belust was geweest. ");
INSERT INTO nld_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Van Kibroth Thaava verreisde het volk naar Hazeroth; en zij bleven in Hazeroth. ");
INSERT INTO nld_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam nu sprak, en Aaron, tegen Mozes, ter oorzake der vrouw, der Cuschietische, die hij genomen had; want hij had een Cuschietische ter vrouw genomen. ");
INSERT INTO nld_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","En zij zeiden: Heeft dan de HEERE maar alleen door Mozes gesproken? Heeft Hij ook niet door ons gesproken? En de HEERE hoorde het! ");
INSERT INTO nld_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Doch de man Mozes was zeer zachtmoedig, meer dan alle mensen, die op den aardbodem waren. ");
INSERT INTO nld_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Toen sprak de HEERE haastelijk tot Mozes, en tot Aaron, en tot Mirjam: Gij drie, komt uit tot de tent der samenkomst! En zij drie kwamen uit. ");
INSERT INTO nld_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Toen kwam de HEERE af in de wolkkolom, en stond aan de deur der tent; daarna riep Hij Aaron en Mirjam; en zij beiden kwamen uit. ");
INSERT INTO nld_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","En Hij zeide: Hoort nu Mijn woorden! Zo er een profeet onder u is, Ik, de HEERE, zal door een gezicht Mij aan hem bekend maken, door een droom zal Ik met hem spreken. ");
INSERT INTO nld_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Alzo is Mijn knecht Mozes niet, die in Mijn ganse huis getrouw is. ");
INSERT INTO nld_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Van mond tot mond spreek Ik met hem, en door aanzien, en niet door duistere woorden; en de gelijkenis des HEEREN aanschouwt hij; waarom dan hebt gijlieden niet gevreesd tegen Mijn knecht, tegen Mozes, te spreken? ");
INSERT INTO nld_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Zo ontstak des HEEREN toorn tegen hen, en Hij ging weg. ");
INSERT INTO nld_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","En de wolk week van boven de tent; en ziet, Mirjam was melaats, wit als de sneeuw. En Aaron zag Mirjam aan, en ziet, zij was melaats. ");
INSERT INTO nld_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Daarom zeide Aaron tot Mozes: Och, mijn heer! leg toch niet op ons de zonde, waarmede wij zottelijk gedaan, en waarmede wij gezondigd hebben! ");
INSERT INTO nld_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Laat zij toch niet zijn als een dode, van wiens vlees, als hij uit zijns moeders lijf uitgaat, de helft wel verteerd is! ");
INSERT INTO nld_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mozes dan riep tot den HEERE, zeggende: O God! heel haar toch! ");
INSERT INTO nld_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","En de HEERE zeide tot Mozes: Zo haar vader smadelijk in haar aangezicht gespogen had, zou zij niet zeven dagen beschaamd zijn? Laat haar zeven dagen buiten het leger gesloten, en daarna aangenomen worden! ");
INSERT INTO nld_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Zo werd Mirjam buiten het leger zeven dagen gesloten; en het volk verreisde niet, totdat Mirjam aangenomen werd. ");
INSERT INTO nld_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Maar daarna verreisde het volk van Hazeroth, en zij legerden zich in de woestijn van Paran. ");
INSERT INTO nld_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Zend u mannen uit: die het land Kanaan verspieden, hetwelk Ik den kinderen Israels geven zal; van elken stam zijner vaderen zult gijlieden een man zenden, zijnde ieder een overste onder hen. ");
INSERT INTO nld_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mozes dan zond hen uit de woestijn van Paran, naar den mond des HEEREN; al die mannen waren hoofden der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","En dit zijn hun namen: van den stam van Ruben, Sammua, de zoon van Zaccur. ");
INSERT INTO nld_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Van den stam van Simeon, Safat, de zoon van Hori. ");
INSERT INTO nld_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Van den stam van Juda, Kaleb, de zoon van Jefunne. ");
INSERT INTO nld_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Van den stam van Issaschar, Jigeal, de zoon van Jozef. ");
INSERT INTO nld_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Van den stam van Efraim, Hosea, de zoon van Nun. ");
INSERT INTO nld_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Van den stam van Benjamin, Palti, de zoon van Rafu. ");
INSERT INTO nld_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Van den stam van Zebulon, Gaddiel, de zoon van Sodi. ");
INSERT INTO nld_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Van den stam van Jozef, voor den stam van Manasse, Gaddi, de zoon van Susi. ");
INSERT INTO nld_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Van den stam van Dan, Ammiel, de zoon van Gemalli. ");
INSERT INTO nld_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Van den stam van Aser, Sethur, de zoon van Michael. ");
INSERT INTO nld_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Van den stam van Nafthali, Nachbi, de zoon van Wofsi. ");
INSERT INTO nld_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Van den stam van Gad, Guel, de zoon van Machi. ");
INSERT INTO nld_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Dit zijn de namen der mannen, die Mozes zond, om dat land te verspieden; en Mozes noemde Hosea, den zoon van Nun, Jozua. ");
INSERT INTO nld_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mozes dan zond hen, om het land Kanaan te verspieden; en hij zeide tot hen: Trekt dit henen op tegen het zuiden, en klimt op het gebergte; ");
INSERT INTO nld_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","En beziet het land, hoedanig het zij, en het volk, dat daarin woont, of het sterk zij of zwak, of het weinig zij of veel; ");
INSERT INTO nld_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","En hoedanig het land zij, waarin hetzelve woont, of het goed zij of kwaad; en hoedanig de steden zijn, in dewelke hetzelve woont, of in legers, of in sterkten; ");
INSERT INTO nld_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ook hoedanig het land zij, of het vet zij of mager, of er bomen in zijn of niet; en versterkt u, en neemt van de vrucht des lands. Die dagen nu waren de dagen der eerste vruchten van de wijndruiven. ");
INSERT INTO nld_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Alzo trokken zij op, en verspiedden het land, van de woestijn Zin af tot Rechob toe, waar men gaat naar Hamath. ");
INSERT INTO nld_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","En zij trokken op in het zuiden, en kwamen tot Hebron toe, en daar waren Ahiman, Sesai en Talmai, kinderen van Enak; Hebron nu was zeven jaren gebouwd voor Zoan in Egypte. ");
INSERT INTO nld_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Daarna kwamen zij tot het dal Eskol, en sneden van daar een rank af met een tros wijndruiven, dien zij droegen met tweeen, op een draagstok; ook van de granaatappelen en van de vijgen. ");
INSERT INTO nld_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Diezelve plaats noemde men het dal Eskol, ter oorzake van den tros, dien de kinderen Israels van daar afgesneden hadden. ");
INSERT INTO nld_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Daarna keerden zij weder van het verspieden des lands, ten einde van veertig dagen. ");
INSERT INTO nld_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","En zij gingen heen, en kwamen tot Mozes en tot Aaron, en tot de gehele vergadering der kinderen Israels, in de woestijn van Paran, naar Kades; en brachten bescheid weder aan hen, en aan de gehele vergadering, en lieten hun de vrucht des lands zien. ");
INSERT INTO nld_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","En zij vertelden hem, en zeiden: Wij zijn gekomen tot dat land, waarheen gij ons gezonden hebt; en voorwaar, het is van melk en honig vloeiende, en dit is zijn vrucht. ");
INSERT INTO nld_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Behalve dat het een sterk volk is, hetwelk in dat land woont, en de steden zijn vast, en zeer groot; en ook hebben wij daar kinderen van Enak gezien. ");
INSERT INTO nld_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","De Amalekieten wonen in het land van het zuiden; maar de Hethieten, en de Jebusieten, en de Amorieten wonen op het gebergte; en de Kanaanieten wonen aan de zee, en aan den oever van de Jordaan. ");
INSERT INTO nld_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Toen stilde Kaleb het volk voor Mozes, en zeide: Laat ons vrijmoedig optrekken, en dat erfelijk bezitten; want wij zullen dat voorzeker overweldigen! ");
INSERT INTO nld_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Maar de mannen, die met hem opgetrokken waren, zeiden: Wij zullen tot dat volk niet kunnen optrekken, want het is sterker dan wij. ");
INSERT INTO nld_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Alzo brachten zij een kwaad gerucht voort van het land, dat zij verspied hadden, aan de kinderen Israels, zeggende: Dat land, door hetwelk wij doorgegaan zijn, om het te verspieden, is een land, dat zijn inwoners verteert; en al het volk, hetwelk wij in het midden van hetzelve gezien hebben, zijn mannen van grote lengte. ");
INSERT INTO nld_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wij hebben ook daar de reuzen gezien, en de kinderen van Enak, van de reuzen; en wij waren als sprinkhanen in onze ogen, alzo waren wij ook in hun ogen. ");
INSERT INTO nld_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toen verhief zich de gehele vergadering, en zij hieven hun stem op, en het volk weende in dienzelven nacht. ");
INSERT INTO nld_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","En al de kinderen Israels murmureerden tegen Mozes en tegen Aaron; en de gehele vergadering zeide tot hen: Och, of wij in Egypteland gestorven waren! of, och, of wij in deze woestijn gestorven waren! ");
INSERT INTO nld_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","En waarom brengt ons de HEERE naar dat land, dat wij door het zwaard vallen, en onze vrouwen, en onze kinderkens ten roof worden? Zou het ons niet goed zijn naar Egypte weder te keren? ");
INSERT INTO nld_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","En zij zeiden de een tot den ander: Laat ons een hoofd opwerpen, en wederkeren naar Egypte! ");
INSERT INTO nld_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Toen vielen Mozes en Aaron op hun aangezichten, voor het aangezicht van de ganse gemeente der vergadering van de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","En Jozua, de zoon van Nun, en Kaleb, de zoon van Jefunne, zijnde van degenen, die dat land verspied hadden, scheurden hun klederen. ");
INSERT INTO nld_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","En zij spraken tot de ganse vergadering der kinderen Israels, zeggende: Het land, door hetwelk wij getrokken zijn, om hetzelve te verspieden, is een uitermate goed land. ");
INSERT INTO nld_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Indien de HEERE een welgevallen aan ons heeft, zo zal Hij ons in dat land brengen, en zal ons dat geven; een land, hetwelk van melk en honig is vloeiende. ");
INSERT INTO nld_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Alleen zijt tegen den HEERE niet wederspannig! en vreest gij niet het volk dezes lands; want zij zijn ons brood! hun schaduw is van hen geweken, en de HEERE is met ons; vreest hen niet! ");
INSERT INTO nld_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Toen zeide de ganse vergadering, dat men hen met stenen stenigen zoude. Maar de heerlijkheid des HEEREN verscheen in de tent der samenkomst, voor al de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","En de HEERE zeide tot Mozes: Hoe lang zal mij dit volk tergen? En hoe lang zullen zij aan Mij niet geloven, door alle tekenen, die Ik in het midden van hen gedaan heb? ");
INSERT INTO nld_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ik zal het met pestilentie slaan, en Ik zal het verstoten; en Ik zal u tot een groter en sterker volk maken, dan dit is. ");
INSERT INTO nld_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","En Mozes zeide tot den HEERE: Zo zullen het de Egyptenaars horen; want Gij hebt door Uw kracht dit volk uit het midden van hen doen optrekken; ");
INSERT INTO nld_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","En zij zullen zeggen tot de inwoners van dit land, die gehoord hebben, dat Gij, HEERE! in het midden van dit volk zijt; dat Gij, HEERE! oog aan oog gezien wordt, dat Uw wolk over hen staat, en Gij in een wolkkolom voor hun aangezicht gaat des daags, en in een vuurkolom des nachts. ");
INSERT INTO nld_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","En zoudt Gij dit volk als een enigen man doden, zo zouden de heidenen, die Uw gerucht gehoord hebben, spreken, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Omdat de HEERE dit volk niet kon brengen in dat land, hetwelk Hij hun gezworen had, zo heeft Hij hen geslacht in de woestijn! ");
INSERT INTO nld_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nu dan, laat toch de kracht des HEEREN groot worden, gelijk als Gij gesproken hebt, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","De HEERE is lankmoedig en groot van weldadigheid, vergevende de ongerechtigheid en overtreding, die den schuldige geenszins onschuldig houdt, bezoekende de ongerechtigheid der vaderen aan de kinderen, in het derde en in het vierde lid. ");
INSERT INTO nld_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Vergeef toch de ongerechtigheid dezes volks, naar de grootte Uwer goedertierenheid, en gelijk Gij ze aan dit volk, van Egypteland af tot hiertoe, vergeven hebt! ");
INSERT INTO nld_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","En de HEERE zeide: Ik heb hun vergeven naar uw woord. ");
INSERT INTO nld_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Doch zekerlijk, zo waarachtig als Ik leef, zo zal de ganse aarde met de heerlijkheid des HEEREN vervuld worden! ");
INSERT INTO nld_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Want al de mannen, die gezien hebben Mijn heerlijkheid, en Mijn tekenen, die Ik in Egypte en in de woestijn gedaan heb, en Mij nu tienmaal verzocht hebben, en Mijner stem niet zijn gehoorzaam geweest; ");
INSERT INTO nld_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Zo zij het land, hetwelk Ik aan hun vaderen gezworen heb, zien zullen. Ja, geen van die Mij getergd hebben, zullen dat zien! ");
INSERT INTO nld_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Doch Mijn knecht Kaleb, omdat een andere geest met hem geweest is, en hij volhard heeft Mij na te volgen, zo zal Ik hem brengen tot het land, in hetwelk hij gekomen was, en zijn zaad zal het erfelijk bezitten. ");
INSERT INTO nld_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","De Amalekieten nu en de Kanaanieten wonen in het dal; wendt u morgen, en maakt uw reize naar de woestijn, op den weg naar de Schelfzee. ");
INSERT INTO nld_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Daarna sprak de HEERE tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Hoe lang zal Ik bij deze boze vergadering zijn, die tegen Mij zijn murmurerende? Ik heb gehoord de murmureringen van de kinderen Israels, waarmede zij tegen Mij zijn murmurerende. ");
INSERT INTO nld_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Zeg tot hen: Zo waarachtig als Ik leef, spreekt de HEERE, indien Ik ulieden zo niet doe, gelijk als gij in Mijn oren gesproken hebt! ");
INSERT INTO nld_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Uw dode lichamen zullen in deze woestijn vallen; en al uw getelden, naar uw gehele getal, van twintig jaren oud en daarboven, gij, die tegen Mij gemurmureerd hebt. ");
INSERT INTO nld_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Zo gij in dat land komt, over hetwelk Ik Mijn hand opgeheven heb, dat Ik u daarin zou doen wonen, behalve Kaleb, de zoon van Jefunne, en Jozua, de zoon van Nun. ");
INSERT INTO nld_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","En uw kinderkens, waarvan gij zeidet: Zij zullen ten roof worden! die zal Ik daarin brengen, en die zullen bekennen dat land, hetwelk gij smadelijk verworpen hebt. ");
INSERT INTO nld_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Maar u aangaande, uw dode lichamen zullen in deze woestijn vallen! ");
INSERT INTO nld_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","En uw kinderen zullen gaan weiden in deze woestijn, veertig jaren, en zullen uw hoererijen dragen, totdat uw dode lichamen verteerd zijn in deze woestijn. ");
INSERT INTO nld_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Naar het getal der dagen, in welke gij dat land verspied hebt, veertig dagen, elken dag voor elk jaar, zult gij uw ongerechtigheden dragen, veertig jaren, en gij zult gewaar worden Mijn afbreking. ");
INSERT INTO nld_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ik, de HEERE, heb gesproken: zo Ik dit aan deze ganse boze vergadering dergenen, die zich tegen Mij verzameld hebben, niet doe, zij zullen in deze woestijn te niet worden, en zullen daar sterven! ");
INSERT INTO nld_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","En die mannen, die Mozes gezonden had, om het land te verspieden, en wedergekomen zijnde, de ganse vergadering tegen hem hadden doen murmureren, een kwaad gerucht over dat land voortbrengende; ");
INSERT INTO nld_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Diezelfde mannen, die een kwaad gerucht van dat land voortgebracht hadden, stierven door een plaag, voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Maar Jozua, de zoon van Nun, en Kaleb, de zoon van Jefunne, bleven levende van de mannen, die heengegaan waren, om het land te verspieden. ");
INSERT INTO nld_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","En Mozes sprak deze woorden tot al de kinderen Israels. Toen treurde het volk zeer. ");
INSERT INTO nld_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","En zij stonden des morgens vroeg op, en klommen op de hoogte des bergs, zeggende: Ziet, hier zijn wij, en wij zullen optrekken tot de plaats, die de HEERE gezegd heeft; want wij hebben gezondigd! ");
INSERT INTO nld_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Maar Mozes zeide: Waarom overtreedt gij alzo het bevel des HEEREN? Want dat zal geen voorspoed hebben. ");
INSERT INTO nld_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Trekt niet op, want de HEERE zal in het midden van u niet zijn; opdat gij niet geslagen wordt, voor het aangezicht uwer vijanden. ");
INSERT INTO nld_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Want de Amalekieten, en de Kanaanieten zijn daar voor uw aangezicht, en gij zult door het zwaard vallen; want, omdat gij u afgekeerd hebt van den HEERE, zo zal de HEERE met u niet zijn. ");
INSERT INTO nld_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nochtans poogden zij vermetel, om op de hoogte des bergs te klimmen; maar de ark des verbonds des HEEREN en Mozes scheidden niet uit het midden des legers. ");
INSERT INTO nld_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Toen kwamen af de Amalekieten en de Kanaanieten, die in dat gebergte woonden, en sloegen hen, en versmeten hen, tot Horma toe. ");
INSERT INTO nld_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Daarna sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Spreek tot de kinderen Israels, en zeg tot hen: Wanneer gij gekomen zult zijn in het land uwer woningen, dat Ik u geven zal; ");
INSERT INTO nld_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","En gij een vuuroffer den HEERE zult doen, een brandoffer, of slachtoffer, om af te zonderen een gelofte, of in een vrijwillig offer, of in uw gezette hoogtijden, om den HEERE een liefelijken reuk te maken, van runderen of van klein vee; ");
INSERT INTO nld_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Zo zal hij, die zijn offerande den HEERE offert, een spijsoffer offeren van een tiende meelbloem, gemengd met een vierendeel van een hin olie. ");
INSERT INTO nld_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","En wijn ten drankoffer, een vierendeel van een hin, zult gij bereiden tot een brandoffer of tot een slachtoffer, voor een lam. ");
INSERT INTO nld_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Of voor een ram zult gij een spijsoffer bereiden, van twee tienden meelbloem, gemengd met olie, een derde deel van een hin. ");
INSERT INTO nld_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","En wijn ten drankoffer, een derde deel van een hin, zult gij offeren tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","En wanneer gij een jong rund zult bereiden tot een brandoffer of een slachtoffer, om een gelofte af te zonderen, of ten dankoffer den HEERE; ");
INSERT INTO nld_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Zo zal hij tot een jong rund offeren een spijsoffer van drie tienden meelbloem, gemengd met olie, de helft van een hin. ");
INSERT INTO nld_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","En wijn zult gij offeren ten drankoffer, de helft van een hin, tot een vuuroffer van liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Alzo zal gedaan worden met den enen os, of met den enen ram, of met het klein vee, van de lammeren, of van de geiten. ");
INSERT INTO nld_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Naar het getal, dat gij bereiden zult, zult gij alzo doen met elkeen, naar hun getal. ");
INSERT INTO nld_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Alle inboorling zal deze dingen alzo doen, offerende een vuuroffer tot een liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Wanneer ook een vreemdeling bij u als vreemdeling verkeert, of die in het midden van u is, in uw geslachten, en hij een vuuroffer zal bereiden tot een liefelijken reuk den HEERE; gelijk als gij zult doen, alzo zal hij doen. ");
INSERT INTO nld_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Gij, gemeente, het zij ulieden en den vreemdeling, die als vreemdeling bij u verkeert, enerlei inzetting: ter eeuwige inzetting bij uw geslachten, gelijk gijlieden, alzo zal de vreemdeling voor des HEEREN aangezicht zijn. ");
INSERT INTO nld_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Enerlei wet en enerlei recht zal ulieden zijn, en den vreemdeling, die bij ulieden als vreemdeling verkeert. ");
INSERT INTO nld_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Voorts sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Spreek tot de kinderen Israels, en zeg tot hen: Als gij zult gekomen zijn in het land, waarheen Ik u inbrengen zal, ");
INSERT INTO nld_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Zo zal het geschieden, als gij van het brood des lands zult eten, dan zult gij den HEERE een hefoffer offeren. ");
INSERT INTO nld_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","De eerstelingen uws deegs, een koek zult gij tot een hefoffer offeren; gelijk het hefoffer des dorsvloers zult gij dat offeren. ");
INSERT INTO nld_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Van de eerstelingen uws deegs zult gij den HEERE een hefoffer geven, bij uw geslachten. ");
INSERT INTO nld_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Voorts wanneer gijlieden afgedwaald zult zijn, en niet gedaan hebben al deze geboden, die de HEERE tot Mozes gesproken heeft; ");
INSERT INTO nld_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Alles, wat u de HEERE door de hand van Mozes geboden heeft; van dien dag af, dat het de HEERE geboden heeft, en voortaan bij uw geslachten; ");
INSERT INTO nld_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Zo zal het geschieden, indien iets bij dwaling gedaan, en voor de ogen der vergadering verborgen is, dat de ganse vergadering een var, een jong rund, zal bereiden ten brandoffer, tot een liefelijken reuk den HEERE, met zijn spijsoffer en zijn drankoffer, naar de wijze; en een geitenbok ten zondoffer. ");
INSERT INTO nld_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","En de priester zal de verzoening doen voor de ganse vergadering van de kinderen Israels, en het zal hun vergeven worden; want het was een afdwaling, en zij hebben hun offerande gebracht, een vuuroffer den HEERE, en hun zondoffer, voor het aangezicht des HEEREN, over hun afdwaling. ");
INSERT INTO nld_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Het zal dan aan de ganse vergadering der kinderen Israels vergeven worden, ook den vreemdeling, die in het midden van henlieden als vreemdeling verkeert; want het is het ganse volk door dwaling overkomen. ");
INSERT INTO nld_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","En indien een ziel door afdwaling gezondigd zal hebben, die zal een eenjarige geit ten zondoffer offeren. ");
INSERT INTO nld_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","En de priester zal de verzoening doen over de dwalende ziel, als zij gezondigd heeft door afdwaling, voor het aangezicht des HEEREN, doende de verzoening over haar; en het zal haar vergeven worden. ");
INSERT INTO nld_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Den inboorling der kinderen Israels, en den vreemdeling, die in hunlieder midden als vreemdeling verkeert, enerlei wet zal ulieden zijn, dengene, die het door afdwaling doet. ");
INSERT INTO nld_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Maar de ziel, die iets gedaan zal hebben met opgeheven hand, hetzij van inboorlingen of van vreemdelingen, die smaadt den HEERE; en diezelve ziel zal uitgeroeid worden uit het midden van haar volk; ");
INSERT INTO nld_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Want zij heeft het woord des HEEREN veracht en Zijn gebod vernietigd; diezelve ziel zal ganselijk uitgeroeid worden; haar ongerechtigheid is op haar. ");
INSERT INTO nld_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Als nu de kinderen Israels in de woestijn waren, zo vonden zij een man, hout lezende op den sabbatdag. ");
INSERT INTO nld_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","En die hem vonden, hout lezende, brachten hem tot Mozes, en tot Aaron, en tot de ganse vergadering. ");
INSERT INTO nld_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","En zij stelden hem in bewaring; want het was niet verklaard, wat hem gedaan zou worden. ");
INSERT INTO nld_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Zo zeide de HEERE tot Mozes: Die man zal zekerlijk gedood worden; de ganse vergadering zal hem met stenen stenigen buiten het leger. ");
INSERT INTO nld_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toen bracht hem de ganse vergadering uit tot buiten het leger, en zij stenigden hem met stenen, dat hij stierf, gelijk als de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Spreek tot de kinderen Israels, en zeg tot hen: Dat zij zich snoertjes maken aan de hoeken hunner klederen, bij hun geslachten; en op de snoertjes des hoeks zullen zij een hemelsblauwen draad zetten. ");
INSERT INTO nld_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","En hij zal ulieden aan de snoertjes zijn, opdat gij het aanziet, en aan al de geboden des HEEREN gedenkt, en die doet; en gij zult naar uw hart, en naar uw ogen niet sporen, die gij zijt nahoererende; ");
INSERT INTO nld_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Opdat gij gedenkt en doet al Mijn geboden, en uw God heilig zijt. ");
INSERT INTO nld_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ik ben de HEERE, uw God, Die u uit Egypteland uitgevoerd heb, om u tot een God te zijn; Ik ben de HEERE, uw God! ");
INSERT INTO nld_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korach nu, de zoon van Jizhar, zoon van Kohath, zoon van Levi, nam tot zich zo Dathan als Abiram, zonen van Eliab, en On, den zoon van Peleth, zonen van Ruben. ");
INSERT INTO nld_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","En zij stonden op voor het aangezicht van Mozes, mitsgaders tweehonderd en vijftig mannen uit de kinderen Israels, oversten der vergadering, de geroepenen der samenkomst, mannen van naam. ");
INSERT INTO nld_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","En zij vergaderden zich tegen Mozes, en tegen Aaron, en zeiden tot hen: Het is te veel voor u, want deze ganse vergadering, zij allen, zijn heilig, en de HEERE is in het midden van hen; waarom dan verheft gijlieden u over de gemeente des HEEREN? ");
INSERT INTO nld_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Als Mozes dit hoorde, zo viel hij op zijn aangezicht. ");
INSERT INTO nld_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","En hij sprak tot Korach, en tot zijn ganse vergadering, zeggende: Morgen vroeg dan zal de HEERE bekend maken, wie de Zijne, en de heilige is, dien Hij tot Zich zal doen naderen; en wien Hij verkoren zal hebben, dien zal Hij tot Zich doen naderen. ");
INSERT INTO nld_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Doet dit: neemt u wierookvaten, Korach en zijn ganse vergadering; ");
INSERT INTO nld_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","En doet morgen vuur daarin, legt reukwerk daarop voor het aangezicht des HEEREN; en het zal geschieden, dat de man, dien de HEERE verkiezen zal, die zal heilig zijn. Het is te veel voor u, gij, kinderen van Levi! ");
INSERT INTO nld_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Voorts zeide Mozes tot Korach: Hoort toch, gij, kinderen van Levi! ");
INSERT INTO nld_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is het u te weinig, dat de God van Israel u van de vergadering van Israel heeft afgescheiden, om ulieden tot Zich te doen naderen; om den dienst van des HEEREN tabernakel te bedienen, en te staan voor het aangezicht der vergadering, om hen te dienen? ");
INSERT INTO nld_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Daar Hij u, en al uw broederen, de kinderen van Levi, met u, heeft doen naderen; zoekt gij nu ook het priesterambt? ");
INSERT INTO nld_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Daarom gij, en uw ganse vergadering, gij zijt vergaderd tegen den HEERE, want Aaron, wat is hij, dat gij tegen hem murmureert? ");
INSERT INTO nld_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","En Mozes schikte heen, om Dathan en Abiram, de zonen van Eliab, te roepen; maar zij zeiden: Wij zullen niet opkomen! ");
INSERT INTO nld_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is het te weinig, dat gij ons uit een land, van melk en honig vloeiende, hebt opgevoerd, om ons te doden in de woestijn, dat gij ook uzelven ten enenmaal over ons tot een overheer maakt? ");
INSERT INTO nld_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ook hebt gij ons niet gebracht in een land, dat van melk en honig vloeit, noch ons akkers en wijngaarden ten erfdeel gegeven. Zult gij de ogen dezer mannen uitgraven? Wij zullen niet opkomen! ");
INSERT INTO nld_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Toen ontstak Mozes zeer, en hij zeide tot den HEERE: Zie hun offer niet aan! Ik heb niet een ezel van hen genomen, en niet een van hen kwaad gedaan. ");
INSERT INTO nld_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Voorts zeide Mozes tot Korach: Gij, en uw ganse vergadering, weest voor het aangezicht des HEEREN; gij, en zij, ook Aaron, op morgen. ");
INSERT INTO nld_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","En neemt een ieder zijn wierookvat, en legt reukwerk daarin, en brengt voor het aangezicht des HEEREN, een ieder zijn wierookvat, tweehonderd en vijftig wierookvaten; ook gij, en Aaron, een ieder zijn wierookvat. ");
INSERT INTO nld_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Zo namen zij een ieder zijn wierookvat, en deden vuur daarin, en leiden reukwerk daarin; en zij stonden voor de deur van de tent der samenkomst, ook Mozes en Aaron. ");
INSERT INTO nld_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","En Korach deed de ganse vergadering tegen hen verzamelen, aan de deur van de tent der samenkomst. Toen verscheen de heerlijkheid des HEEREN aan deze ganse vergadering. ");
INSERT INTO nld_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","En de HEERE sprak tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Scheidt u af uit het midden van deze vergadering, en Ik zal hen als in een ogenblik verteren! ");
INSERT INTO nld_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Maar zij vielen op hun aangezichten, en zeiden: O God! God der geesten van alle vlees! een enig man zal gezondigd hebben, en zult Gij U over deze ganse vergadering grotelijks vertoornen? ");
INSERT INTO nld_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Spreek tot deze vergadering, zeggende: Gaat op van rondom de woning van Korach, Dathan en Abiram. ");
INSERT INTO nld_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Toen stond Mozes op, en ging tot Dathan en Abiram; en achter hem gingen de oudsten van Israel. ");
INSERT INTO nld_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","En hij sprak tot de vergadering, zeggende: Wijkt toch af van de tenten dezer goddeloze mannen, en roert niets aan van hetgeen hunner is, opdat gij niet misschien verdaan wordt in al hun zonden. ");
INSERT INTO nld_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Zo gingen zij op van de woning van Korach, Dathan en Abiram, van rondom; maar Dathan en Abiram gingen uit, staande in de deur hunner tenten, met hun vrouwen, en hun zonen, en hun kinderkens. ");
INSERT INTO nld_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Toen zeide Mozes: Hieraan zult gij bekennen, dat de HEERE mij gezonden heeft, om al deze daden te doen, dat zij niet uit mijn eigen hart zijn. ");
INSERT INTO nld_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Indien deze zullen sterven, gelijk alle mensen sterven, en over hen een bezoeking zal gedaan worden, naar aller mensen bezoeking, zo heeft mij de HEERE niet gezonden. ");
INSERT INTO nld_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Maar indien de HEERE wat nieuws zal scheppen, en het aardrijk zijn mond zal opendoen, en verslinden hen met alles wat hunner is, en zij levend ter helle zullen nedervaren; alsdan zult gij bekennen, dat deze mannen de HEERE getergd hebben. ");
INSERT INTO nld_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","En het geschiedde, als hij geeindigd had al deze woorden te spreken, zo werd het aardrijk, dat onder hen was, gekloofd; ");
INSERT INTO nld_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","En de aarde opende haar mond, en verslond hen met hun huizen, en allen mensen, die Korach toebehoorden, en al de have. ");
INSERT INTO nld_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","En zij voeren neder, zij en alles wat hunner was, levend ter helle; en de aarde overdekte hen, en zij kwamen om uit het midden der gemeente. ");
INSERT INTO nld_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","En het ganse Israel, dat rondom hen was, vlood voor hun geschrei; want zij zeiden: Dat ons de aarde misschien niet verslinde! ");
INSERT INTO nld_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Daartoe ging een vuur uit van den HEERE, en verteerde die tweehonderd en vijftig mannen, die reukwerk offerden. ");
INSERT INTO nld_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Zeg tot Eleazar, den zoon van Aaron, den priester, dat hij de wierookvaten uit den brand opneme; en strooi het vuur verre weg; want zij zijn heilig; ");
INSERT INTO nld_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Te weten de wierookvaten van dezen, die tegen hun zielen gezondigd hebben; dat men uitgerekte platen daarvan make, tot een overdeksel voor het altaar; want zij hebben ze gebracht voor het aangezicht des HEEREN, daarom zijn zij heilig; en zij zullen den kinderen Israels tot een teken zijn. ");
INSERT INTO nld_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","En Eleazar, de priester, nam de koperen wierookvaten, die de verbranden gebracht hadden, en zij rekten ze uit tot een overtreksel voor het altaar; ");
INSERT INTO nld_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ter nagedachtenis voor de kinderen Israels, opdat niemand vreemds, die niet uit het zaad van Aaron is, nadere om reukwerk aan te steken voor het aangezicht des HEEREN; opdat hij niet worde als Korach, en zijn vergadering, gelijk als hem de HEERE door den dienst van Mozes gesproken had. ");
INSERT INTO nld_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Maar des anderen daags murmureerde de ganse vergadering der kinderen Israels tegen Mozes en tegen Aaron, zeggende: Gijlieden hebt des HEEREN volk gedood! ");
INSERT INTO nld_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","En het geschiedde, als de vergadering zich verzamelde tegen Mozes en Aaron, en zich wendde naar de tent der samenkomst, ziet, zo bedekte haar die wolk; en de heerlijkheid des HEEREN verscheen. ");
INSERT INTO nld_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mozes nu en Aaron kwamen tot voor de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Maak u op uit het midden van deze vergadering, en Ik zal hen verteren, als in een ogenblik! Toen vielen zij op hun aangezichten. ");
INSERT INTO nld_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","En Mozes zeide tot Aaron: Neem het wierookvat, en doe vuur daarin van het altaar, en leg reukwerk daarop, haastelijk gaande tot de vergadering, doe over hen verzoening; want een grote toorn is van voor het aangezicht des HEEREN uitgegaan, de plaag heeft aangevangen. ");
INSERT INTO nld_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","En Aaron nam het, gelijk als Mozes gesproken had, en liep in het midden der gemeente, en ziet, de plaag had aangevangen onder het volk; en hij leide reukwerk daarin, en deed verzoening over het volk. ");
INSERT INTO nld_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","En hij stond tussen de doden en tussen de levenden; alzo werd de plaag opgehouden. ");
INSERT INTO nld_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Die nu aan die plaag gestorven zijn, waren veertien duizend en zevenhonderd, behalve die gestorven waren om de zaak van Korach. ");
INSERT INTO nld_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","En Aaron keerde weder tot Mozes aan de deur van de tent der samenkomst; en de plaag was opgehouden. ");
INSERT INTO nld_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Spreek tot de kinderen Israels, en neem van hen voor elk vaderlijk huis een staf, van al hun oversten, naar het huis hunner vaderen, twaalf staven; eens iegelijken naam zult gij schrijven op zijn staf. ");
INSERT INTO nld_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Doch Aarons naam zult gij schrijven op den staf van Levi; want een staf zal er zijn voor het hoofd van het huis hunner vaderen. ");
INSERT INTO nld_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","En gij zult ze wegleggen in de tent der samenkomst, voor de getuigenis, waarheen Ik met ulieden samenkomen zal. ");
INSERT INTO nld_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","En het zal geschieden, dat de staf des mans, welke Ik zal verkoren hebben, zal bloeien; en Ik zal stillen de murmureringen van de kinderen Israels tegen Mij, welke zij tegen ulieden murmureerden. ");
INSERT INTO nld_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mozes dan sprak tot de kinderen Israels, en al hun oversten gaven aan hem een staf, voor elken overste een staf, naar het huis hunner vaderen, twaalf staven; Aarons staf was ook onder hun staven. ");
INSERT INTO nld_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","En Mozes leide deze staven weg, voor het aangezicht des HEEREN, in de tent der getuigenis. ");
INSERT INTO nld_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Het geschiedde nu des anderen daags, dat Mozes in de tent der getuigenis inging; en ziet, Aarons staf, voor het huis van Levi, bloeide; want hij bracht bloeisel voort, en bloesemde bloesem, en droeg amandelen. ");
INSERT INTO nld_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Toen bracht Mozes al deze staven uit, van voor het aangezicht des HEEREN, tot al de kinderen Israels; en zij zagen het, en namen elk zijn staf. ");
INSERT INTO nld_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Toen zeide de HEERE tot Mozes: Breng de staf van Aaron weder voor de getuigenis, in bewaring, tot een teken voor de wederspannige kinderen; alzo zult gij een einde maken van hun murmureringen tegen Mij, dat zij niet sterven. ");
INSERT INTO nld_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","En Mozes deed het; gelijk als de HEERE hem geboden had, alzo deed hij. ");
INSERT INTO nld_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Toen spraken de kinderen Israels tot Mozes, zeggende: Zie, wij geven den geest, wij vergaan, wij allen vergaan! ");
INSERT INTO nld_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Al wie enigszins nadert tot den tabernakel des HEEREN, zal sterven; zullen wij dan den geest gevende verdaan worden? ");
INSERT INTO nld_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Zo zeide de HEERE tot Aaron: Gij, en uw zonen, en het huis uws vaders met u, zult dragen de ongerechtigheid des heiligdoms; en gij, en uw zonen met u, zult dragen de ongerechtigheid van uw priesterambt. ");
INSERT INTO nld_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","En ook zult gij uw broederen, den stam van Levi, den stam uws vaders, met u doen naderen, dat zij u bijgevoegd worden, en u dienen; maar gij, en uw zonen met u, zult zijn voor de tent der getuigenis. ");
INSERT INTO nld_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","En zij zullen uw wacht waarnemen, en de wacht der ganse tent; doch tot het gereedschap des heiligdoms en het altaar zullen zij niet naderen, opdat zij niet sterven, zo zij als gijlieden. ");
INSERT INTO nld_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Maar zij zullen u bijgevoegd worden, en de wacht van de tent der samenkomst waarnemen, in allen dienst der tent; en een vreemde zal tot u niet naderen. ");
INSERT INTO nld_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Gijlieden nu zult waarnemen de wacht des heiligdoms, en de wacht des altaars; opdat er geen verbolgenheid meer zij over de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Want Ik, zie, Ik heb uw broederen, de Levieten, uit het midden der kinderen Israels genomen; zij zijn ulieden een gave, gegeven den HEERE, om den dienst van de tent der samenkomst te bedienen. ");
INSERT INTO nld_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Maar gij, en uw zonen met u, zult ulieder priesterambt waarnemen in alle zaken des altaars, en in hetgeen van binnen den voorhang is, dat zult gijlieden bedienen; uw priesterambt geve Ik u tot een dienst van een geschenk; en de vreemde, die nadert, zal gedood worden. ");
INSERT INTO nld_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Voorts sprak de HEERE tot Aaron: En Ik, zie, Ik heb u gegeven de wacht Mijner hefofferen, met alle heilige dingen van de kinderen Israels heb Ik ze u gegeven, om der zalving wil, en aan uw zonen, tot een eeuwige inzetting. ");
INSERT INTO nld_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Dit zult gij hebben van de heiligheid der heiligheden, uit het vuur: al hun offeranden, met al hun spijsoffer, en met al hun zondoffer, en met al hun schuldoffer, dat zij Mij zullen wedergeven; het zal u en uw zonen een heiligheid der heiligheden zijn. ");
INSERT INTO nld_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Aan het allerheiligste zult gij dat eten; al wat mannelijk is zal dat eten; het zal u een heiligheid zijn. ");
INSERT INTO nld_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ook zal dit het uwe zijn: het hefoffer hunner gave, met alle beweegofferen der kinderen Israels; Ik heb ze aan u gegeven, en aan uw zonen, en aan uw dochteren met u, tot een eeuwige inzetting; al wie in uw huis rein is, zal dat eten. ");
INSERT INTO nld_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Al het beste van de olie, en al het beste van de most, en van koren, hun eerstelingen, die zij den HEERE zullen geven, u heb Ik ze gegeven. ");
INSERT INTO nld_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","De eerste vruchten van alles, wat in hun land is, die zij den HEERE zullen brengen, zullen uwe zijn; al wie in uw huis rein is, zal dat eten. ");
INSERT INTO nld_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Al het verbannene in Israel zal het uwe zijn. ");
INSERT INTO nld_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Al wat de baarmoeder opent, van alle vlees, dat zij den HEERE zullen brengen, onder de mensen, en onder de beesten, zal het uwe zijn; doch de eerstgeborenen der mensen zult gij ganselijk lossen; ook zult gij lossen de eerstgeborenen der onreine beesten. ");
INSERT INTO nld_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Die nu onder dezelve gelost zullen worden, zult gij van een maand oud lossen, naar uw schatting, voor het geld van vijf sikkelen, naar den sikkel des heiligdoms, die is twintig gera. ");
INSERT INTO nld_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Maar het eerstgeborene van een koe, of het eerstgeborene van een schaap, of het eerstgeborene van een geit zult gij niet lossen, zij zijn heilig; hun bloed zult gij sprengen op het altaar, en hun ver zult gij aansteken, tot een vuuroffer van liefelijken reuk den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","En hun vlees zal het uwe zijn; gelijk de beweegborst, en gelijk de rechterschouder, zal het uwe zijn. ");
INSERT INTO nld_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle hefofferen der heilige dingen, die de kinderen Israels den HEERE zullen offeren, heb Ik aan u gegeven, en aan uw zonen, en aan uw dochteren met u, tot een eeuwige inzetting; het zal een eeuwig zoutverbond zijn, voor het aangezicht des HEEREN, voor u en voor uw zaad met u. ");
INSERT INTO nld_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ook zeide de HEERE tot Aaron: Gij zult in hun land niet erven, en gij zult geen deel in het midden van henlieden hebben; Ik ben uw deel en uw erfenis, in het midden van de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","En zie, aan de kinderen van Levi heb Ik alle tienden in Israel ter erfenis gegeven, voor hun dienst, dien zij bedienen, den dienst van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","En de kinderen Israels zullen niet meer naderen tot de tent der samenkomst, om zonde te dragen en te sterven. ");
INSERT INTO nld_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Maar de Levieten, die zullen bedienen den dienst van de tent der samenkomst, en die zullen hun ongerechtigheid dragen; het zal een eeuwige inzetting zijn voor uw geslachten; en in het midden van de kinderen Israels zullen zij geen erfenis erven. ");
INSERT INTO nld_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Want de tienden der kinderen Israels, die zij den HEERE tot een hefoffer zullen offeren, heb Ik aan de Levieten tot een erfenis gegeven; daarom heb Ik tot hen gezegd: Zij zullen in het midden van de kinderen Israels geen erfenis erven. ");
INSERT INTO nld_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Gij zult ook tot de Levieten spreken, en tot hen zeggen: Wanneer gij van de kinderen Israels de tienden zult ontvangen hebben, die Ik u voor uw erfenis van henlieden gegeven heb, zo zult gij daarvan een hefoffer des HEEREN offeren, de tienden van die tienden; ");
INSERT INTO nld_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","En het zal u gerekend worden tot uw hefoffer, als koren van den dorsvloer, en als de volheid van de perskuip. ");
INSERT INTO nld_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Alzo zult gij ook een hefoffer des HEEREN offeren van al uw tienden, die gij van de kinderen Israels zult hebben ontvangen; en gij zult daarvan des HEEREN hefoffer geven aan den priester Aaron. ");
INSERT INTO nld_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Van al uw gaven zult gij alle hefoffer des HEEREN offeren; van al het beste van die, van zijn heiliging daarvan. ");
INSERT INTO nld_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Gij zult dan tot hen zeggen: Als gij deszelfs beste daarvan offert, zo zal het den Levieten toegerekend worden als een inkomen des dorsvloers, en als een inkomen der perskuip. ");
INSERT INTO nld_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","En gij zult dat eten in alle plaatsen, gij en uw huis; want het is ulieden een loon voor uw dienst in de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Zo zult gij daarover geen zonde dragen, als gij deszelfs beste daarvan offert; en gij zult de heilige dingen van de kinderen Israels niet ontheiligen, opdat gij niet sterft. ");
INSERT INTO nld_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Wijders sprak de HEERE tot Mozes en tot Aaron, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dit is de inzetting van de wet, die de HEERE geboden heeft, zeggende: Spreek tot de kinderen Israels, dat zij tot u brengen een rode volkomen vaars, in welke geen gebrek is, op welke geen juk gekomen is. ");
INSERT INTO nld_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","En gij zult die geven aan Eleazar, den priester; en hij zal ze uitbrengen tot buiten het leger, en men zal haar voor zijn aangezicht slachten. ");
INSERT INTO nld_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","En Eleazar, den priester, zal van haar bloed met zijn vinger nemen, en hij zal van haar bloed recht tegenover de tent der samenkomst zevenmaal sprengen. ");
INSERT INTO nld_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Voorts zal men deze vaars voor zijn ogen verbranden; haar vel, en haar vlees, en haar bloed, met haar mest, zal men verbranden. ");
INSERT INTO nld_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","En de priester zal nemen cederhout, en hysop, en scharlaken, en werpen ze in het midden van den brand dezer vaars. ");
INSERT INTO nld_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Dan zal de priester zijn klederen wassen, en zijn vlees met water baden, en daarna in het leger gaan; en de priester zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ook die haar verbrand heeft, zal zijn klederen met water wassen, en zijn vlees met water baden, en onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","En een rein man zal de as dezer vaars verzamelen, en buiten het leger in een reine plaats wegleggen; en het zal zijn ter bewaring voor de vergadering van de kinderen Israels, tot het water der afzondering; het is ontzondiging. ");
INSERT INTO nld_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","En die de as dezer vaars verzameld heeft, zal zijn klederen wassen, en onrein zijn tot aan den avond. Dit zal den kinderen Israels, en den vreemdeling, die in het midden van henlieden als vreemdeling verkeert, tot een eeuwige inzetting zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wie een dode, enig dood lichaam van een mens, aanroert, die zal zeven dagen onrein zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Op den derden dag zal hij zich daarmede ontzondigen, zo zal hij op den zevenden dag rein zijn; maar indien hij zich op den derden dag niet ontzondigt, zo zal hij op den zevenden dag niet rein zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Al wie een dode, het dode lichaam eens mensen, die gestorven zal zijn, aanroert, en zich niet ontzondigd zal hebben, die verontreinigt den tabernakel des HEEREN; daarom zal die ziel uitgeroeid worden uit Israel; omdat het water der afzondering op hem niet gesprengd is, zal hij onrein zijn; zijn onreinigheid is nog in hem. ");
INSERT INTO nld_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Dit is de wet, wanneer een mens zal gestorven zijn in een tent: al wie in die tent ingaat, en al wie in die tent is, zal zeven dagen onrein zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ook alle open gereedschap, waarop geen deksel gebonden is, dat is onrein. ");
INSERT INTO nld_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","En al wie in het open veld een, die met het zwaard verslagen is, of een dode, of het gebeente eens mensen, of een graf zal aangeroerd hebben, zal zeven dagen onrein zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Voor een onreine nu zullen zij nemen van het stof des brands der ontzondiging, en daarop levend water doen in een vat. ");
INSERT INTO nld_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","En een rein man zal hysop nemen, en in dat water dopen, en sprengen het aan die tent, en op al het gereedschap, en aan de zielen, die daar geweest zijn; insgelijks aan dengene, die een gebeente, of een verslagene, of een dode, of een graf aangeroerd heeft. ");
INSERT INTO nld_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","En de reine zal den onreine op den derden dag, en op den zevenden dag besprengen; en op den zevenden dag zal hij hem ontzondigen; en hij zal zijn klederen wassen, en zich met water baden, en op den avond rein zijn. ");
INSERT INTO nld_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Wie daarentegen onrein zal zijn, en zich niet zal ontzondigen, die ziel zal uit het midden der gemeente uitgeroeid worden; want hij heeft het heiligdom des HEEREN verontreinigd, het water der afzondering is op hem niet gesprengd, hij is onrein. ");
INSERT INTO nld_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Dit zal hunlieden zijn tot een eeuwige inzetting. En die het water der afzondering sprengt, zal zijn klederen wassen; ook wie het water der afzondering aanroert, die zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ja, al wat die onreine aangeroerd zal hebben, zal onrein zijn; en de ziel, die dat aangeroerd zal hebben, zal onrein zijn tot aan den avond. ");
INSERT INTO nld_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Als de kinderen Israels, de ganse vergadering, in de woestijn Zin gekomen waren, in de eerste maand, zo bleef het volk te Kades. En Mirjam stierf aldaar, en zij werd aldaar begraven. ");
INSERT INTO nld_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","En er was geen water voor de vergadering; toen vergaderden zij zich tegen Mozes en tegen Aaron. ");
INSERT INTO nld_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","En het volk twistte met Mozes, en zij spraken, zeggende: Och, of wij den geest gegeven hadden, toen onze broeders voor het aangezicht des HEEREN den geest gaven! ");
INSERT INTO nld_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Waarom toch hebt gijlieden de gemeente des HEEREN in deze woestijn gebracht, dat wij daar sterven zouden, wij en onze beesten? ");
INSERT INTO nld_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","En waarom hebt gijlieden ons doen optrekken uit Egypte, om ons te brengen in deze kwade plaats? Het is geen plaats van zaad, noch van vijgen, noch van wijnstokken, noch van granaatappelen; ook is er geen water om te drinken. ");
INSERT INTO nld_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Toen gingen Mozes en Aaron van het aangezicht der gemeente tot de deur van de tent der samenkomst, en zij vielen op hun aangezichten; en de heerlijkheid des HEEREN verscheen hun. ");
INSERT INTO nld_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Neem dien staf, en verzamel de vergadering, gij en Aaron, uw broeder, en spreekt gijlieden tot de steenrots voor hun ogen, zo zal zij hun water geven; alzo zult gij hun water voortbrengen uit de steenrots, en gij zult de vergadering en haar beesten drenken. ");
INSERT INTO nld_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Toen nam Mozes den staf van voor het aangezicht des HEEREN, gelijk als Hij hem geboden had. ");
INSERT INTO nld_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","En Mozes en Aaron vergaderden de gemeente voor de steenrots, en hij zeide tot hen: Hoort toch, gij wederspannigen, zullen wij water voor ulieden uit deze steenrots hervoorbrengen? ");
INSERT INTO nld_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Toen hief Mozes zijn hand op, en hij sloeg de steenrots tweemaal met zijn staf; en er kwam veel waters uit, zodat de vergadering dronk, en haar beesten. ");
INSERT INTO nld_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Derhalve zeide de HEERE tot Mozes en tot Aaron: Omdat gijlieden Mij niet geloofd hebt, dat gij Mij heiligdet voor de ogen der kinderen van Israel, daarom zult gijlieden deze gemeente niet inbrengen in het land, hetwelk Ik hun gegeven heb. ");
INSERT INTO nld_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Dit zijn de wateren van Meriba, daar de kinderen Israels met den HEERE om getwist hebben; en Hij werd aan hen geheiligd. ");
INSERT INTO nld_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Daarna zond Mozes boden uit Kades tot den koning van Edom, welke zeiden: Alzo zegt uw broeder Israel: Gij weet al de moeite, die ons ontmoet is; ");
INSERT INTO nld_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Dat onze vaders naar Egypte afgetogen zijn, en wij in Egypte vele dagen gewoond hebben; en dat de Egyptenaars aan ons en onze vaderen kwaad gedaan hebben. ");
INSERT INTO nld_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Toen riepen wij tot den HEERE, en Hij hoorde onze stem, en Hij zond een Engel, en Hij leidde ons uit Egypte; en ziet, wij zijn te Kades, en stad aan het uiterste uwer landpale. ");
INSERT INTO nld_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laat ons toch door uw land trekken; wij zullen niet trekken door den akker, noch door de wijngaarden, noch zullen het water der putten drinken; wij zullen den koninklijken weg gaan, wij zullen niet afwijken ter rechter- noch ter linkerhand, totdat wij door uw landpalen zullen getrokken zijn. ");
INSERT INTO nld_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Doch Edom zeide tot hem: Gij zult door mij niet trekken, opdat ik niet misschien met het zwaard uitga u tegemoet! ");
INSERT INTO nld_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Toen zeiden de kinderen Israels tot hem: Wij zullen door den gebaanden weg optrekken, en indien wij van uw water drinken, ik en mijn vee, zo zal ik deszelfs prijs daarvoor geven; ik zal alleenlijk, zonder iets anders, te voet doortrekken. ");
INSERT INTO nld_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Doch hij zeide: Gij zult niet doortrekken! En Edom is hem tegemoet uitgetrokken, met een zwaar volk, en met een sterke hand. ");
INSERT INTO nld_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Alzo weigerde Edom Israel toe te laten door zijn landpale te trekken; daarom week Israel van hem af. ");
INSERT INTO nld_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Toen reisden zij van Kades; en de kinderen Israels kwamen, de ganse vergadering, aan den berg Hor. ");
INSERT INTO nld_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","De HEERE nu sprak tot Mozes, en tot Aaron, aan den berg Hor, aan de pale van het land van Edom, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron zal tot zijn volken verzameld worden; want hij zal niet komen in het land, hetwelk Ik aan de kinderen Israels gegeven heb, omdat gijlieden Mijn mond wederspannig geweest zijt bij de wateren van Meriba. ");
INSERT INTO nld_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Neem Aaron, en Eleazar, zijn zoon, en doe hen opklimmen tot den berg Hor. ");
INSERT INTO nld_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","En trek Aaron zijn klederen uit, en trek ze Eleazar, zijn zoon, aan; want Aaron zal verzameld worden, en daar sterven. ");
INSERT INTO nld_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mozes nu deed, gelijk als de HEERE geboden had; want zij klommen op tot den berg Hor, voor de ogen der ganse vergadering. ");
INSERT INTO nld_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","En Mozes trok Aaron zijn klederen uit, en hij trok ze zijn zoon Eleazar aan; en Aaron stierf aldaar, op de hoogte diens bergs. Toen kwam Mozes en Eleazar van dien berg af. ");
INSERT INTO nld_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Toen de ganse vergadering zag, dat Aaron overleden was, zo beweenden zij Aaron dertig dagen, het ganse huis van Israel. ");
INSERT INTO nld_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Als de Kanaaniet, de koning van Harad, wonende tegen het zuiden, hoorde, dat Israel door den weg der verspieders kwam, zo streed hij tegen Israel, en hij voerde enige gevangenen uit denzelven gevankelijk weg. ");
INSERT INTO nld_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Toen beloofde Israel den HEERE een gelofte, en zeide: Indien Gij dit volk geheel in mijn hand geeft, zo zal ik hun steden verbannen. ");
INSERT INTO nld_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","De HEERE dan verhoorde de stem van Israel, en gaf de Kanaanieten over; en hij verbande hen en hun steden; en hij noemde den naam dier plaats Horma. ");
INSERT INTO nld_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Toen reisden zij van den berg Hor, op den weg der Schelfzee, dat zij om het land der Edomieten heentogen; doch de ziel des volks werd verdrietig op dezen weg. ");
INSERT INTO nld_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","En het volk sprak tegen God en tegen Mozes: Waarom hebt gijlieden ons doen optrekken uit Egypte, opdat wij sterven zouden in de woestijn? Want hier is geen brood, ook geen water, en onze ziel walgt over dit zeer lichte brood. ");
INSERT INTO nld_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Toen zond de HEERE vurige slangen onder het volk, die beten het volk; en er stierf veel volks van Israel. ");
INSERT INTO nld_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Daarom kwam het volk tot Mozes, en zij zeiden: Wij hebben gezondigd, omdat wij tegen den HEERE en tegen u gesproken hebben; bid den HEERE, dat Hij deze slangen van ons wegneme. Toen bad Mozes voor het volk. ");
INSERT INTO nld_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","En de HEERE zeide tot Mozes: Maak u een vurige slang, en stel ze op een stang; en het zal geschieden, dat al wie gebeten is, als hij haar aanziet, zo zal hij leven. ");
INSERT INTO nld_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","En Mozes maakte een koperen slang, en stelde ze op een stang; en het geschiedde, als een slang iemand beet, zo zag hij de koperen slang aan, en hij bleef levend. ");
INSERT INTO nld_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Toen verreisden de kinderen Israels, en zij legerden zich te Oboth. ");
INSERT INTO nld_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Daarna reisden zij van Oboth, en legerden zich aan de heuvelen van Abarim in de woestijn, die tegenover Moab is, tegen den opgang der zon. ");
INSERT INTO nld_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Van daar reisden zij, en legerden zich bij de beek Zered. ");
INSERT INTO nld_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Van daar reisden zij, en legerden zich aan deze zijde van de Arnon, welke in de woestijn is, uitgaande uit de landpalen der Amorieten; want de Arnon is de landpale van Moab, tussen Moab en tussen de Amorieten. ");
INSERT INTO nld_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","(Daarom wordt gezegd in het boek van de oorlogen des HEEREN: Tegen Waheb, in een wervelwind, en tegen de beken Arnon, ");
INSERT INTO nld_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","En den afloop der beken, die zich naar de gelegenheid van Ar wendt, en leent aan de landpale van Moab.) ");
INSERT INTO nld_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","En van daar reisden zij naar Beer. Dit is de put, van welken de HEERE tot Mozes zeide: Verzamel het volk, zo zal Ik hun water geven. ");
INSERT INTO nld_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","(Toen zong Israel dit lied: Spring op, gij put, zingt daarvan bij beurte! ");
INSERT INTO nld_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Gij put, dien de vorsten gegraven hebben, dien de edelen des volks gedolven hebben, door den wetgever, met hun staven.) En van de woestijn reisden zij naar Mattana; ");
INSERT INTO nld_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","En van Mattana tot Nahaliel; en van Nahaliel tot Bamoth; ");
INSERT INTO nld_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","En van Bamoth tot het dal, dat in het veld van Moab is, aan de hoogte van Pisga, en dat tegen de wildernis ziet. ");
INSERT INTO nld_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Toen zond Israel boden tot Sihon, den koning der Amorieten, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laat mij door uw land trekken. Wij zullen niet afwijken in de akkers, noch in de wijngaarden; wij zullen het water der putten niet drinken; wij zullen op den koninklijken weg gaan, totdat wij uw landpale doorgetogen zijn. ");
INSERT INTO nld_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Doch Sihon liet Israel niet toe, door zijn landpale door te trekken; maar Sihon vergaderde al zijn volk, en hij ging uit, Israel tegemoet, naar de woestijn, en hij kwam te Jahza, en streed tegen Israel; ");
INSERT INTO nld_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Maar Israel sloeg hem met de scherpte des zwaards, en nam zijn land in erfelijke bezitting, van de Arnon af tot de Jabbok toe, tot aan de kinderen Ammons; want de landpale der kinderen Ammons was vast. ");
INSERT INTO nld_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Alzo nam Israel al deze steden in; en Israel woonde in al de steden der Amorieten, te Hesbon, en in al haar onderhorige plaatsen. ");
INSERT INTO nld_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Want Hesbon was de stad van Sihon, den koning der Amorieten; en hij had gestreden tegen den vorigen koning der Moabieten, en hij had al zijn land uit zijn hand genomen, tot aan de Arnon. ");
INSERT INTO nld_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daarom zeggen zij, die spreekwoorden gebruiken: Komt tot Hesbon; men bouwe en bevestige de stad van Sihon! ");
INSERT INTO nld_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Want er is een vuur uitgegaan uit Hesbon; een vlam uit de stad van Sihon; zij heeft verteerd Ar der Moabieten, en de heren der hoogten van de Arnon. ");
INSERT INTO nld_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wee u, Moab! Gij, volk Kamoz zijt verloren! Hij heeft zijn zonen, die ontliepen, en zijn dochters in de gevangenis geleverd aan Sihon, den koning der Amorieten. ");
INSERT INTO nld_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","En wij hebben hen nedergeveld! Hesbon is verloren tot Dibon toe; en wij hebben hen verwoest tot Nofat toe, welke tot Medeba toe reikt. ");
INSERT INTO nld_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Alzo woonde Israel in het land van den Amoriet. ");
INSERT INTO nld_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Daarna zond Mozes om Jaezer te verspieden; en zij namen haar onderhorige plaatsen in; en hij dreef de Amorieten, die er waren, uit de bezitting. ");
INSERT INTO nld_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Toen wendden zij zich en trokken op den weg van Basan; en Og, de koning van Basan, ging uit hun tegemoet, hij en al zijn volk, tot den strijd, en Edrei. ");
INSERT INTO nld_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","De HEERE nu zeide tot Mozes: Vrees hem niet; want Ik heb hem in uw hand gegeven, en al zijn volk, ook zijn land; en gij zult hem doen, gelijk als gij Sihon, den koning der Amorieten, die te Hesbon woonde, gedaan hebt. ");
INSERT INTO nld_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","En zij sloegen hem, en zijn zonen, en al zijn volk, alzo dat hem niemand overbleef; en zij namen zijn land in erfelijke bezitting. ");
INSERT INTO nld_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Daarna reisden de kinderen van Israel, en legerden zich in de vlakke velden van Moab, aan deze zijde van de Jordaan van Jericho. ");
INSERT INTO nld_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Toen Balak, de zoon van Zippor, zag al wat Israel aan de Amorieten gedaan had; ");
INSERT INTO nld_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Zo vreesde Moab zeer voor het aangezicht dezes volks, want het was veel; en Moab was beangstigd voor het aangezicht van de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Derhalve zeide Moab tot de oudsten der Midianieten: Nu zal deze gemeente oplikken al wat rondom ons is, gelijk de os de groente des velds oplikt. Te dier tijd nu was Balak, de zoon van Zippor, koning der Moabieten. ");
INSERT INTO nld_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Die zond boden aan Bileam, den zoon van Beor, te Pethor, hetwelk aan de rivier is, in het land der kinderen zijns volks, om hem te roepen, zeggende: Zie, er is een volk uit Egypte getogen; zie, het heeft het gezicht des lands bedekt, en het blijft liggen recht tegenover mij. ");
INSERT INTO nld_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","En nu, kom toch, vervloek mij dit volk, want het is machtiger dan ik; misschien zal ik het kunnen slaan, of het uit het land verdrijven; want ik weet, dat, wien gij zegent, die zal gezegend zijn, en wien gij vervloekt, die zal vervloekt zijn. ");
INSERT INTO nld_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Toen gingen de oudsten der Moabieten, en de oudsten der Midianieten, en hadden het loon der waarzeggingen in hun hand; alzo kwamen zij tot Bileam, en spraken tot hem de woorden van Balak. ");
INSERT INTO nld_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Hij dan zeide tot hen: Vernacht hier dezen nacht, zo zal ik ulieden een antwoord wederbrengen, gelijk als de HEERE tot mij zal gesproken hebben. Toen bleven de vorsten der Moabieten bij Bileam. ");
INSERT INTO nld_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","En God kwam tot Bileam en zeide: Wie zijn die mannen, die bij u zijn? ");
INSERT INTO nld_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Toen zeide Bileam tot God: Balak, de zoon van Zippor, de koning der Moabieten, heeft hen tot mij gezonden, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Zie, er is een volk uit Egypte getogen, en het heeft het gezicht des lands bedekt; kom nu, vervloek het mij; misschien zal ik tegen hetzelve kunnen strijden, of het uitdrijven. ");
INSERT INTO nld_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Toen zeide God tot Bileam: Gij zult met hen niet trekken; gij zult dat volk niet vloeken, want het is gezegend. ");
INSERT INTO nld_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Toen stond Bileam des morgens op, en zeide tot de vorsten van Balak: Gaat naar uw land; want de HEERE weigert mij toe te laten met ulieden te gaan. ");
INSERT INTO nld_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Zo stonden dan de vorsten der Moabieten op, en kwamen tot Balak, en zij zeiden: Bileam heeft geweigerd met ons te gaan. ");
INSERT INTO nld_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Doch Balak voer nog voort vorsten te zenden, meer en eerlijker, dan die waren; ");
INSERT INTO nld_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Die tot Bileam kwamen, en hem zeiden: Alzo zegt Balak, de zoon van Zippor: Laat u toch niet beletten tot mij te komen! ");
INSERT INTO nld_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Want ik zal u zeer hoog vereren, en al wat gij tot mij zeggen zult, dat zal ik doen; zo kom toch, vervloek mij dit volk! ");
INSERT INTO nld_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Toen antwoordde Bileam, en zeide tot de dienaren van Balak: Wanneer Balak mij zijn huis vol zilver en goud gave, zo vermocht ik niet het bevel des HEEREN mijns Gods te overtreden, om te doen klein of groot. ");
INSERT INTO nld_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","En nu, blijft gijlieden toch ook hier dezen nacht, opdat ik wete, wat de HEERE tot mij verder spreken zal. ");
INSERT INTO nld_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God nu kwam tot Bileam des nachts, en zeide tot hem: Dewijl die mannen gekomen zijn, om u te roepen, sta op, ga met hen; en nochtans zult gij dat doen, hetwelk Ik tot u spreken zal. ");
INSERT INTO nld_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Toen stond Bileam des morgens op, en zadelde zijn ezelin, en hij trok heen met de vorsten van Moab. ");
INSERT INTO nld_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Doch de toorn van God werd ontstoken, omdat hij heentoog; en de Engel des HEEREN stelde Zich in den weg, hem tot een tegenpartij; hij reed nu op zijn ezelin, en twee zijner jongeren waren bij hem. ");
INSERT INTO nld_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","De ezelin nu zag den Engel des HEEREN staande in den weg, met Zijn uitgetrokken zwaard in Zijn hand; daarom week de ezelin uit den weg, en ging in het veld. Toen sloeg Bileam de ezelin, om dezelve naar den weg te doen wenden. ");
INSERT INTO nld_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Maar de Engel des HEEREN stond in een pad der wijngaarden, zijnde een muur aan deze, en een muur aan gene zijde. ");
INSERT INTO nld_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Toen de ezelin den Engel des HEEREN zag, zo klemde zij zichzelve aan den wand, en klemde Bileams voet aan den wand; daarom voer hij voort haar te slaan. ");
INSERT INTO nld_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Toen ging de Engel des HEEREN noch verder, en Hij stond in een enge plaats, waar geen weg was om te wijken ter rechter- noch ter linkerhand. ");
INSERT INTO nld_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Als de ezelin den Engel des HEEREN zag, zo leide zij zich neder onder Bileam; en de toorn van Bileam ontstak, en hij sloeg de ezelin met een stok. ");
INSERT INTO nld_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","De HEERE nu opende den mond der ezelin, die tot Bileam zeide: Wat heb ik u gedaan, dat gij mij nu driemaal geslagen hebt? ");
INSERT INTO nld_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Toen zeide Bileam tot de ezelin: Omdat gij mij bespot hebt; och, of ik een zwaard in mijn hand had! want ik zoude u nu doden. ");
INSERT INTO nld_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","De ezelin nu zeide tot Bileam: Ben ik niet uw ezelin, op welke gij gereden hebt van toen af, dat gij mijn heer geweest zijt, tot op dezen dag? Ben ik ooit gewend geweest u alzo te doen? Hij dan zeide: Neen! ");
INSERT INTO nld_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Toen ontdekte de HEERE de ogen van Bileam, zodat hij den Engel des HEEREN zag, staande in den weg, en Zijn uitgetrokken zwaard in Zijn hand; daarom neigde hij het hoofd en boog zich op zijn aangezicht. ");
INSERT INTO nld_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Toen zeide de Engel des HEEREN tot hem: Waarom hebt gij uw ezelin nu driemaal geslagen? Zie, Ik ben uitgegaan u tot een tegenpartij, dewijl deze weg van Mij afwijkt. ");
INSERT INTO nld_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Maar de ezelin heeft Mij gezien, en zij is nu driemaal voor Mijn aangezicht geweken; indien zij voor Mijn aangezicht niet geweken ware, zekerlijk Ik zoude u nu ook gedood, en haar bij het leven behouden hebben. ");
INSERT INTO nld_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Toen zeide Bileam tot den Engel des HEEREN: Ik heb gezondigd, want ik heb niet geweten, dat Gij mij tegemoet op dezen weg stond; en nu, is het kwaad in Uw ogen, ik zal wederkeren. ");
INSERT INTO nld_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","De Engel des HEEREN nu zeide tot Bileam: Ga heen met deze mannen; maar alleenlijk dat woord, wat Ik tot u spreken zal, dat zult gij spreken. Alzo toog Bileam met de vorsten van Balak. ");
INSERT INTO nld_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Als Balak hoorde, dat Bileam kwam, zo ging hij uit, hem tegemoet, tot de stad der Moabieten, welke aan de landpale van de Arnon ligt, die aan het uiterste der landpale is. ");
INSERT INTO nld_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","En Balak zeide tot Bileam: Heb ik niet ernstiglijk tot u gezonden, om u te roepen? Waarom zijt gij niet tot mij gekomen? Kan ik u niet te recht vereren? ");
INSERT INTO nld_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Toen zeide Bileam tot Balak: Zie, ik ben tot u gekomen; zal ik nu enigszins iets kunnen spreken? Het woord, hetwelk God in mijn mond leggen zal, dat zal ik spreken. ");
INSERT INTO nld_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","En Bileam ging met Balak; en zij kwamen te Kirjath-Huzzoth. ");
INSERT INTO nld_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Toen slachtte Balak runderen en schapen; en hij zond aan Bileam, en aan de vorsten, die bij hem waren. ");
INSERT INTO nld_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","En het geschiedde des morgens, dat Balak Bileam nam, en voerde hem op de hoogten van Baal, dat hij van daar zag het uiterste des volks. ");
INSERT INTO nld_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Toen zeide Bileam tot Balak: Bouw mij hier zeven altaren, en bereid mij hier zeven varren en zeven rammen. ");
INSERT INTO nld_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak nu deed, gelijk als Bileam gesproken had; en Balak en Bileam offerden een var en een ram, op elk altaar. ");
INSERT INTO nld_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Toen zeide Bileam tot Balak: Blijf staan bij uw brandoffer, en ik zal heengaan; misschien zal de HEERE mij tegemoet komen; en hetgeen Hij wijzen zal, dat zal ik u bekend maken. Toen ging hij op de hoogte. ");
INSERT INTO nld_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Als God Bileam ontmoet was, zo zeide hij tot Hem: Zeven altaren heb ik toegericht, en heb een var en een ram op elk altaar geofferd. ");
INSERT INTO nld_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Toen leide de HEERE het woord in den mond van Bileam, en zeide: Keer weder tot Balak, en spreek aldus. ");
INSERT INTO nld_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Als hij nu tot hem wederkeerde, ziet, zo stond hij bij zijn brandoffer, hij en al de vorsten der Moabieten. ");
INSERT INTO nld_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Toen hief hij zijn spreuk op, en zeide: Uit Syrie heeft mij Balak, de koning der Moabieten, laten halen, van het gebergte tegen het oosten, zeggende: Kom, vervloek mij Jakob, en kom, scheld Israel! ");
INSERT INTO nld_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Wat zal ik vloeken, dien God niet vloekt; en wat zal ik schelden, waar de HEERE niet scheldt? ");
INSERT INTO nld_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Want van de hoogte der steenrotsen zie ik hem, en van de heuvelen aanschouw ik hem; ziet, dat volk zal alleen wonen, en het zal onder de heidenen niet gerekend worden. ");
INSERT INTO nld_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wie zal het stof van Jakob tellen, en het getal, ja, het vierde deel van Israel? Mijn ziel sterve den dood der oprechten, en mijn uiterste zij gelijk het zijne! ");
INSERT INTO nld_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Toen zeide Balak tot Bileam: Wat hebt gij mij gedaan? Ik heb u genomen, om mijn vijanden te vloeken; maar zie, gij hebt hen doorgaans gezegend! ");
INSERT INTO nld_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Hij nu antwoordde en zeide: Zal ik dat niet waarnemen te spreken, wat de HEERE in mijn mond gelegd heeft? ");
INSERT INTO nld_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Toen zeide Balak tot hem: Kom toch met mij aan een andere plaats, van waar gij hem zult zien; gij zult niet dan zijn einde zien, maar hem niet ganselijk zien; en vervloek hem mij van daar! ");
INSERT INTO nld_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Alzo nam hij hem mede tot het veld Zofim, op de hoogte van Pisga; en hij bouwde zeven altaren, en hij offerde een var en een ram op elk altaar. ");
INSERT INTO nld_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Toen zeide hij tot Balak: Blijf hier staan bij uw brandoffer, en ik zal Hem aldaar ontmoeten. ");
INSERT INTO nld_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Als de HEERE Bileam ontmoet was, zo leide Hij het woord in zijn mond, en Hij zeide: Keer weder tot Balak, en spreek alzo. ");
INSERT INTO nld_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Toen hij tot hem kwam, ziet, zo stond hij bij zijn brandoffer, en de vorsten der Moabieten bij hem. Balak nu zeide tot hem: Wat heeft de HEERE gesproken? ");
INSERT INTO nld_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Toen hief hij zijn spreuk op, en zeide: Sta op, Balak, en hoor! Neig uw oren tot mij, gij, zoon van Zippor! ");
INSERT INTO nld_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is geen man, dat Hij liegen zou, noch eens mensen kind, dat het Hem berouwen zou; zou Hij het zeggen, en niet doen, of spreken, en niet bestendig maken? ");
INSERT INTO nld_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Zie, ik heb ontvangen te zegenen; dewijl Hij zegent, zo zal ik het niet keren. ");
INSERT INTO nld_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Hij schouwt niet aan de ongerechtigheid in Jakob; ook ziet Hij niet aan de boosheid in Israel. De HEERE, zijn God, is met hem, en het geklank des Konings is bij hem. ");
INSERT INTO nld_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God heeft hen uit Egypte uitgevoerd; zijn krachten zijn als van een eenhoorn. ");
INSERT INTO nld_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Want er is geen toverij tegen Jakob noch waarzeggerij tegen Israel. Te dezer tijd zal van Jakob gezegd worden, en van Israel, wat God gewrocht heeft. ");
INSERT INTO nld_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Zie, het volk zal opstaan als een oude leeuw, en het zal zich verheffen als een leeuw; het zal zich niet neerleggen, totdat het den roof gegeten, en het bloed der verslagenen gedronken zal hebben! ");
INSERT INTO nld_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Toen zeide Balak tot Bileam: Gij zult het ganselijk noch vloeken, noch geenszins zegenen. ");
INSERT INTO nld_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Doch Bileam antwoordde en zeide tot Balak: Heb ik niet tot u gesproken, zeggende: Al wat de HEERE spreken zal, dat zal ik doen? ");
INSERT INTO nld_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Verder zeide Balak tot Bileam: Kom toch, ik zal u aan een ander plaats medenemen; misschien zal het recht zijn in de ogen van dien God, dat gij het mij van daar vervloekt. ");
INSERT INTO nld_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Toen nam Balak Bileam mede tot de hoogte van Peor, die tegen de woestijn ziet. ");
INSERT INTO nld_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","En Bileam zeide tot Balak: Bouw mij hier zeven altaren, en bereid mij hier zeven varren en zeven rammen. ");
INSERT INTO nld_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak nu deed, gelijk als Bileam gezegd had; en hij offerde een var en een ram op elk altaar. ");
INSERT INTO nld_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Toen Bileam zag, dat het goed was in de ogen des HEEREN, dat hij Israel zegende, zo ging hij ditmaal niet heen, gelijk meermalen, tot de toverijen; maar hij stelde zijn aangezicht naar de woestijn. ");
INSERT INTO nld_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Als Bileam zijn ogen ophief, en Israel zag, wonende naar zijn stammen, zo was de Geest van God op hem. ");
INSERT INTO nld_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","En hij hief zijn spreuk op, en zeide: Bileam, de zoon van Beor, spreekt, en de man, wien de ogen geopend zijn, spreekt! ");
INSERT INTO nld_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","De hoorder der redenen Gods spreekt, die het gezicht des Almachtigen ziet; die verrukt wordt, en wien de ogen ontdekt worden! ");
INSERT INTO nld_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hoe goed zijn uw tenten, Jakob! uw woningen, Israel! ");
INSERT INTO nld_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Gelijk de beken breiden zij zich uit, als de hoven aan de rivieren; de HEERE heeft ze geplant, als de sandelbomen, als de cederbomen aan het water. ");
INSERT INTO nld_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Er zal water uit zijn emmeren vloeien, en zijn zaad zal in vele wateren zijn; en zijn koning zal boven Agag verheven worden, en zijn koninkrijk zal verhoogd worden. ");
INSERT INTO nld_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God heeft hem uit Egypte uitgevoerd; zijn krachten zijn als van een eenhoorn; hij zal de heidenen, zijn vijanden, verteren, en hun gebeente breken, en met zijn pijlen doorschieten. ");
INSERT INTO nld_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Hij heeft zich gekromd, hij heeft zich nedergelegd, gelijk een leeuw, en als een oude leeuw; wie zal hem doen opstaan? Zo wie u zegent, die zij gezegend, en vervloekt zij, wie u vervloekt! ");
INSERT INTO nld_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Toen ontstak de toorn van Balak tegen Bileam, en hij sloeg zijn handen samen; en Balak zeide tot Bileam: Ik heb u geroepen, om mijn vijanden te vloeken; maar zie, gij hebt hen nu driemaal gedurig gezegend! ");
INSERT INTO nld_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","En nu, pak u weg naar uw plaats! Ik had gezegd, dat ik u hoog vereren zou; maar zie, de HEERE heeft u die eer van u geweerd! ");
INSERT INTO nld_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Toen zeide Bileam tot Balak: Heb ik ook niet tot uw boden, die gij tot mij gezonden hebt, gesproken, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Wanneer mij Balak zijn huis vol zilver en goud gave, zo kan ik het bevel des HEEREN niet overtreden, doende goed of kwaad uit mijn eigen hart; wat de HEERE spreken zal, dat zal ik spreken. ");
INSERT INTO nld_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","En nu, zie, ik ga tot mijn volk; kom, ik zal u raad geven, en zeggen wat dit volk uw volk doen zal in de laatste dagen. ");
INSERT INTO nld_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Toen hief hij zijn spreuk op, en zeide: Bileam, de zoon van Beor, spreekt, en die man, wien de ogen geopend zijn, spreekt! ");
INSERT INTO nld_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","De hoorder der redenen Gods spreekt, en die de wetenschap des Allerhoogsten weet; die het gezicht des Almachtigen ziet, die verrukt wordt, en wien de ogen ontdekt worden. ");
INSERT INTO nld_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ik zal hem zien, maar nu niet; ik zal hem aanschouwen, maar niet nabij. Er zal een ster voortkomen uit Jakob, en er zal een scepter uit Israel opkomen; die zal de palen der Moabieten verslaan, en zal al de kinderen van Seth verstoren. ");
INSERT INTO nld_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","En Edom zal een erfelijke bezitting zijn; en Seir zal zijn vijanden een erfelijke bezitting zijn; doch Israel zal kracht doen. ");
INSERT INTO nld_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","En er zal een uit Jakob heersen, en hij zal de overigen uit de steden ombrengen. ");
INSERT INTO nld_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Toen hij de Amalekieten zag, zo hief hij zijn spreuk op, en zeide: Amalek is de eersteling der heidenen; maar zijn uiterste is ten verderve! ");
INSERT INTO nld_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Toen hij de Kenieten zag, zo hief hij zijn spreuk op, en zeide: Uw woning is vast, en gij hebt uw nest in een steenrots gelegd. ");
INSERT INTO nld_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Evenwel zal Kain verteerd worden, totdat u Assur gevankelijk wegvoeren zal! ");
INSERT INTO nld_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Voorts hief hij zijn spreuk op, en zeide: Och, wie zal leven, als God dit doen zal! ");
INSERT INTO nld_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","En de schepen van den oever der Chitteers, die zullen Assur plagen, zij zullen ook Heber plagen; en hij zal ook ten verderve zijn. ");
INSERT INTO nld_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Toen stond Bileam op, en ging heen, en keerde weder tot zijn plaats. Balak ging ook zijn weg. ");
INSERT INTO nld_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","En Israel verbleef te Sittim, en het volk begon te hoereren met de dochteren der Moabieten. ");
INSERT INTO nld_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","En zij nodigden het volk tot de slachtofferen harer goden; en het volk at, en boog zich voor haar goden. ");
INSERT INTO nld_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Als nu Israel zich koppelde aan Baal-Peor, ontstak de toorn des HEEREN tegen Israel. ");
INSERT INTO nld_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","En de HEERE zeide tot Mozes: Neem al de hoofden des volks, en hang ze den HEERE tegen de zon, zo zal de hittigheid van des HEEREN toorn gekeerd worden van Israel. ");
INSERT INTO nld_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Toen zeide Mozes tot de rechters van Israel: Een iedere dode zijn mannen, die zich aan Baal-Peor gekoppeld hebben! ");
INSERT INTO nld_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","En ziet, een man uit de kinderen Israels kwam, en bracht een Midianietin tot zijn broederen voor de ogen van Mozes, en voor de ogen van de ganse vergadering der kinderen Israels, toen zij weenden voor de deur van de tent der samenkomst. ");
INSERT INTO nld_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Toen Pinehas, de zoon van Eleazar, den zoon van Aaron, den priester, dat zag, zo stond hij op uit het midden der vergadering, en nam een spies in zijn hand; ");
INSERT INTO nld_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","En hij ging den Israelietischen man na in de hoerenwinkel, en doorstak hen beiden, den Israelietischen man en de vrouw, door hun buik. Toen werd de plaag van over de kinderen Israels opgehouden. ");
INSERT INTO nld_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Degenen nu, die aan de plaag stierven, waren vier en twintig duizend. ");
INSERT INTO nld_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Toen sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehas, de zoon van Eleazar, den zoon van Aaron, den priester, heeft Mijn grimmigheid van over de kinderen Israels afgewend, dewijl hij Mijn ijver geijverd heeft in het midden derzelve, zodat Ik de kinderen Israels in Mijn ijver niet vernield heb. ");
INSERT INTO nld_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Daarom spreek: Zie, Ik geef hem Mijn verbond des vredes. ");
INSERT INTO nld_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","En hij zal hebben, en zijn zaad na hem, het verbond des eeuwigen priesterdoms, daarom dat hij voor zijn God geijverd, en verzoening gedaan heeft voor de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","De naam nu des verslagenen Israelietischen mans, die verslagen was met de Midianietin, was Zimri, de zoon van Salu, een overste van een vaderlijk huis der Simeonieten. ");
INSERT INTO nld_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","En de naam der verslagene Midianietische vrouw was Kozbi, een dochter van Zur, die een hoofd was der volken van een vaderlijk huis onder de Midianieten. ");
INSERT INTO nld_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Handel vijandelijk met de Midianieten, en versla hen; ");
INSERT INTO nld_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Want zij hebben vijandelijk tegen ulieden gehandeld door hun listen, die zij listig tegen u bedacht hebben in de zaak van Peor, en in de zaak van Kozbi, de dochter van den overste der Midianieten, hun zuster, die verslagen is, ten dage der plaag, om de zaak van Peor. ");
INSERT INTO nld_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Het geschiedde nu na die plaag, dat de HEERE sprak tot Mozes, en tot Eleazar, den zoon van Aaron, den priester, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Neem de som van de gehele vergadering der kinderen Israels op, van twintig jaren oud en daarboven, naar het huis hunner vaderen, al wie ten heire in Israel uittrekt. ");
INSERT INTO nld_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mozes dan en Eleazar, de priester, spraken hen aan, in de vlakke velden van Moab, aan de Jordaan van Jericho, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Dat men opneme van twintig jaren oud en daarboven; gelijk als de HEERE Mozes geboden had, en den kinderen Israels, die uit Egypteland uitgetogen waren. ");
INSERT INTO nld_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben was de eerstgeborene van Israel. De zonen van Ruben waren: Hanoch, van welken was het geslacht der Hanochieten; van Pallu het geslacht der Palluieten; ");
INSERT INTO nld_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Van Hezron het geslacht der Hezronieten; van Karmi het geslacht der Karmieten. ");
INSERT INTO nld_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dit zijn de geslachten der Rubenieten; en hun getelden waren drie en veertig duizend zevenhonderd en dertig. ");
INSERT INTO nld_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","En de zonen van Pallu waren Eliab. ");
INSERT INTO nld_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","En de zonen van Eliab waren Nemuel, en Dathan, en Abiram; deze Dathan en Abiram waren de geroepenen der vergadering, die gekijf maakten tegen Mozes en tegen Aaron, in de vergadering van Korach, als zij gekijf tegen den HEERE maakten. ");
INSERT INTO nld_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","En de aarde haar mond opendeed, en verslond hen met Korach, als die vergadering stierf, toen het vuur tweehonderd en vijftig mannen verteerde, en werden tot een teken. ");
INSERT INTO nld_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Maar de kinderen van Korach stierven niet. ");
INSERT INTO nld_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","De zonen van Simeon, naar hun geslachten: van Nemuel, het geslacht der Nemuelieten; van Jamin het geslacht der Jaminieten; van Jachin het geslacht der Jachinieten; ");
INSERT INTO nld_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Van Zerah het geslacht der Zerahieten; van Saul het geslacht der Saulieten. ");
INSERT INTO nld_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Dat zijn de geslachten der Simeonieten: twee en twintig duizend en tweehonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","De zonen van Gad, naar hun geslachten: van Zefon het geslacht der Zefonieten; van Haggi het geslacht der Haggieten; van Suni het geslacht der Sunieten. ");
INSERT INTO nld_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Van Ozni het geslacht der Oznieten; van Heri het geslacht der Herieten; ");
INSERT INTO nld_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Van Arod het geslacht der Arodieten; van Areli het geslacht der Arelieten. ");
INSERT INTO nld_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Dat zijn de geslachten der zonen van Gad, naar hun getelden: veertig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","De zonen van Juda waren Er en Onan; maar Er en Onan stierven in het land Kanaan. ");
INSERT INTO nld_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Alzo waren de zonen van Juda naar hun geslachten: van Sela het geslacht der Selanieten; van Perez het geslacht der Perezieten; van Zerah het geslacht der Zerahieten. ");
INSERT INTO nld_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","En de zonen van Perez waren: van Hezron het geslacht der Hezronieten; van Hamul het geslacht der Hamulieten. ");
INSERT INTO nld_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Dat zijn de geslachten van Juda, naar hun getelden: zes en zeventig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","De zonen van Issaschar, naar hun geslachten, waren: van Tola het geslacht der Tolaieten; van Puva het geslacht der Punieten; ");
INSERT INTO nld_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Van Jasub het geslacht der Jasubieten; van Simron het geslacht der Simronieten. ");
INSERT INTO nld_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Dat zijn de geslachten van Issaschar, naar hun getelden: vier en zestig duizend en driehonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","De zonen van Zebulon, naar hun geslachten, waren: van Sered het geslacht der Seredieten; van Elon het geslacht der Elonieten; van Jahleel het geslacht der Jahleelieten. ");
INSERT INTO nld_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Dat zijn de geslachten der Zebulonieten, naar hun getelden: zestig duizend en vijfhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","De zonen van Jozef, naar hun geslachten, waren Manasse en Efraim. ");
INSERT INTO nld_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","De zonen van Manasse waren: van Machir het geslacht der Machirieten; Machir nu gewon Gilead; van Gilead was het geslacht der Gileadieten. ");
INSERT INTO nld_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dit zijn de zonen van Gilead: van Jezer het geslacht der Jezerieten; van Helek het geslacht der Helekieten. ");
INSERT INTO nld_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","En van Asriel het geslacht der Asrielieten; en van Sechem het geslacht der Sechemieten; ");
INSERT INTO nld_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","En van Semida het geslacht der Semidaieten; en van Hefer het geslacht der Heferieten. ");
INSERT INTO nld_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Doch Zelafead, de zoon van Hefer, had geen zonen, maar dochters; en de namen der dochteren van Zelafead waren: Machla en Noa, Hogla, Milka en Tirza. ");
INSERT INTO nld_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Dat zijn de geslachten van Manasse: en hun getelden waren twee en vijftig duizend en zevenhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Dit zijn de zonen van Efraim, naar hun geslachten: van Sutelah het geslacht der Sutelahieten; van Becher het geslacht der Becherieten; van Tahan het geslacht der Tahanieten. ");
INSERT INTO nld_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","En dit zijn de zonen van Sutelah; van Eran het geslacht der Eranieten. ");
INSERT INTO nld_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Dat zijn de geslachten der zonen van Efraim, naar hun getelden: twee en dertig duizend en vijfhonderd. Dat zijn de zonen van Jozef, naar hun geslachten. ");
INSERT INTO nld_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","De zonen van Benjamin, naar hun geslachten: van Bela het geslacht der Belaieten; van Asbel het geslacht der Asbelieten; van Ahiram het geslacht der Ahiramieten; ");
INSERT INTO nld_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Van Sefufam het geslacht der Sufamieten; van Hufam het geslacht der Hufamieten. ");
INSERT INTO nld_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","En de zonen van Bela waren Ard en Naaman; van Ard het geslacht der Ardieten; van Naaman het geslacht der Naamieten. ");
INSERT INTO nld_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dat zijn de zonen van Benjamin, naar hun geslachten; en hun getelden waren vijf en veertig duizend en zeshonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dit zijn de zonen van Dan, naar hun geslachten: van Suham het geslacht der Suhamieten; dat zijn de geslachten van Dan, naar hun geslachten. ");
INSERT INTO nld_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Al de geslachten der Suhamieten, naar hun getelden, waren vier en zestig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","De zonen van Aser, naar hun geslachten, waren: van Imna het geslacht der Imnaieten; van Isvi het geslacht der Isvieten; van Beria het geslacht der Beriieten. ");
INSERT INTO nld_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Van de zonen van Beria waren: van Heber het geslacht der Heberieten; van Malchiel het geslacht der Malchielieten. ");
INSERT INTO nld_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","En de naam der dochter van Aser was Serah. ");
INSERT INTO nld_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Dat zijn de geslachten der zonen van Aser, naar hun getelden: drie en vijftig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","De zonen van Nafthali, naar hun geslachten: van Jahzeel het geslacht der Jahzeelieten; van Guni het geslacht der Gunieten; ");
INSERT INTO nld_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Van Jezer het geslacht der Jezerieten; van Sillem het geslacht der Sillemieten. ");
INSERT INTO nld_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Dat zijn de geslachten van Nafthali, naar hun geslachten; en hun getelden waren vijf en veertig duizend en vierhonderd. ");
INSERT INTO nld_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Dat zijn de getelden van de zonen Israels: zeshonderd een duizend zevenhonderd en dertig. ");
INSERT INTO nld_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Aan dezen zal het land uitgedeeld worden ter erfenis, naar het getal der namen. ");
INSERT INTO nld_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Aan degenen, die veel zijn, zult gij hun erfenis meerder maken, en aan hen, die weinig zijn, zult gij hun erfenis minder maken; aan een iegelijk zal, naar zijn getelden, zijn erfenis gegeven worden. ");
INSERT INTO nld_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Het land nochtans zal door het lot gedeeld worden; naar de namen der stammen hunner vaderen zullen zij erven. ");
INSERT INTO nld_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Naar het lot zal elks erfenis gedeeld worden tussen de velen en de weinigen. ");
INSERT INTO nld_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Dit zijn nu de getelden van Levi, naar hun geslachten: van Gerson het geslacht der Gersonieten; van Kohath het geslacht der Kohathieten; van Merari het geslacht der Merarieten. ");
INSERT INTO nld_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dit zijn de geslachten van Levi: het geslacht der Libnieten, het geslacht der Hebronieten, het geslacht der Machlieten, het geslacht der Muzieten, het geslacht der Korachieten. En Kohath gewon Amram. ");
INSERT INTO nld_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","En de naam der huisvrouw van Amram was Jochebed, de dochter van Levi, welke de huisvrouw van Levi baarde in Egypte; en deze baarde aan Amram, Aaron, en Mozes, en Mirjam, hun zuster. ");
INSERT INTO nld_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","En aan Aaron werden geboren Nadab en Abihu, Eleazar en Ithamar. ");
INSERT INTO nld_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab nu en Abihu waren gestorven, toen zij vreemd vuur brachten voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","En hun getelden waren drie en twintig duizend, al wat mannelijk is, van een maand oud en daarboven; want dezen werden niet geteld onder de kinderen Israels, omdat hun geen erfenis gegeven werd onder de kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Dat zijn de getelden van Mozes en Eleazar, den priester, die de kinderen Israels telden in de vlakke velden van Moab, aan de Jordaan van Jericho. ");
INSERT INTO nld_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","En onder dezen was niemand uit de getelden van Mozes en Aaron, den priester, als zij de kinderen Israels telden in de woestijn van Sinai. ");
INSERT INTO nld_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Want de HEERE had van die gezegd, dat zij in de woestijn gewisselijk zouden sterven; en er was niemand van hen overgebleven, dan Kaleb, de zoon van Jefunne, en Jozua, de zoon van Nun. ");
INSERT INTO nld_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Toen naderden de dochteren van Zelafead, den zoon van Hefer, den zoon van Gilead, den zoon van Machir, den zoon van Manasse, onder de geslachten van Manasse, den zoon van Jozef (en dit zijn de namen zijner dochteren: Machla, Noa, en Hogla, en Milka, en Tirza); ");
INSERT INTO nld_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","En zij stonden voor het aangezicht van Mozes, en voor het aangezicht van Eleazar, den priester, en voor het aangezicht van de oversten, en van de ganse vergadering, aan de deur van de tent der samenkomst, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Onze vader is gestorven in de woestijn, en hij is niet geweest in het midden der vergadering dergenen, die zich tegen den HEERE vergaderd hebben in de vergadering van Korach; maar hij is in zijn zonde gestorven, en had geen zonen. ");
INSERT INTO nld_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Waarom zou de naam onzes vaders uit het midden van zijn geslacht weggenomen worden, omdat hij geen zoon heeft? Geef ons een bezitting in het midden der broederen van onzen vader. ");
INSERT INTO nld_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","En Mozes bracht haar rechtzaak voor het aangezicht des HEEREN. ");
INSERT INTO nld_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","En de HEERE sprak tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","De dochteren van Zelafead spreken recht; gij zult haar ganselijk geven de bezitting ener erfenis, in het midden van de broederen haars vaders; en gij zult de erfenis haars vaders op haar doen komen. ");
INSERT INTO nld_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","En tot de kinderen Israels zult gij spreken, zeggende: Wanneer iemand sterft, en geen zoon heeft, zo zult gij zijn erfenis op zijn dochter doen komen. ");
INSERT INTO nld_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","En indien hij geen dochter heeft, zo zult gij zijn erfenis aan zijn broederen geven. ");
INSERT INTO nld_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Indien hij nu geen broederen heeft, zo zult gij zijn erfenis aan de broederen zijns vaders geven. ");
INSERT INTO nld_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Indien ook zijn vader geen broeders heeft, zo zult gij zijn erfenis geven aan zijn naastbestaande, die hem de naaste van zijn geslacht is, dat hij het erfelijk bezitte. Dit zal den kinderen Israels tot een inzetting des rechts zijn, gelijk als de HEERE Mozes geboden heeft. ");
INSERT INTO nld_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Daarna zeide de HEERE tot Mozes: Klim op dezen berg Abarim, en zie dat land, hetwelk Ik den kinderen Israels gegeven heb. ");
INSERT INTO nld_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Wanneer gij dat gezien zult hebben, dan zult gij tot uw volken verzameld worden, gij ook, gelijk als uw broeder Aaron verzameld geworden is; ");
INSERT INTO nld_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Naardien gijlieden Mijn mond wederspannig zijt geweest in de woestijn Zin, in de twisting der vergadering, om Mij aan de wateren voor hun ogen te heiligen. Dat zijn de wateren van Meriba, van Kades, in de woestijn Zin. ");
INSERT INTO nld_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Toen sprak Mozes tot den HEERE, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Dat de HEERE, de God der geesten van alle vlees, een man stelle over deze vergadering. ");
INSERT INTO nld_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Die voor hun aangezicht uitga, en die voor hun aangezicht inga, en die hen uitleide, en die hen inleide; opdat de vergadering des HEEREN niet zij als schapen, die geen herder hebben. ");
INSERT INTO nld_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Toen zeide de HEERE tot Mozes: Neem tot u Jozua, den zoon van Nun, een man, in wien de Geest is; en leg uw hand op hem; ");
INSERT INTO nld_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","En stel hem voor het aangezicht van Eleazar, den priester, en voor het aangezicht der ganse vergadering; en geef hem bevel voor hun ogen; ");
INSERT INTO nld_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","En leg op hem van uw heerlijkheid, opdat zij horen, te weten de ganse vergadering der kinderen Israels. ");
INSERT INTO nld_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","En hij zal voor het aangezicht van Eleazar, den priester, staan, die voor hem raad vragen zal, naar de wijze van Urim, voor het aangezicht des HEEREN; naar zijn mond zullen zij uitgaan, en naar zijn mond zullen zij ingaan, hij, en al de kinderen Israels met hem, en de ganse vergadering. ");
INSERT INTO nld_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","En Mozes deed, gelijk als de HEERE hem geboden had; want hij nam Jozua, en stelde hem voor het aangezicht van Eleazar, den priester, en voor het aangezicht der ganse vergadering. ");
INSERT INTO nld_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","En hij leide zijn handen op hem, en gaf hem bevel; gelijk als de HEERE door den dienst van Mozes gesproken had. ");
INSERT INTO nld_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Verder sprak de HEERE tot Mozes, zeggende: ");
INSERT INTO nld_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Gebied den kinderen Israels, en zeg tot hen: Mijn offerande, Mijn spijze voor Mijn vuurofferen, Mijn liefelijken reuk, zult gij waarnemen, om Mij te offeren op zijn gezetten tijd. ");
INSERT INTO nld_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","En gij zult tot hen zeggen: Dit is het vuuroffer, hetwelk gij den HEERE offeren zult: twee volkomen eenjarige lammeren des daags, tot een gedurig brandoffer. ");
INSERT INTO nld_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Het ene lam zult gij bereiden des morgens; en het andere lam zult gij bereiden tussen de twee avonden. ");
INSERT INTO nld_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","En een tiende deel ener efa meelbloem ten spijsoffer, gemengd met het vierendeel van een hin van gestoten olie. ");
INSERT INTO nld_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Het is het gedurig brandoffer, hetwelk op den berg Sinai ingesteld was tot een liefelijken reuk, een vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","En zijn drankoffer zal zijn het vierendeel van een hin, voor het ene lam; in het heiligdom zult gij het drankoffer des sterken dranks den HEERE offeren. ");
INSERT INTO nld_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","En het andere lam zult gij bereiden tussen de twee avonden; gelijk het spijsoffer des morgens, en gelijk zijn drankoffer zult gij het bereiden, ten vuuroffer des liefelijken reuks den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Maar op den sabbatdag twee volkomen eenjarige lammeren, en twee tienden meelbloem, ten spijsoffer, met olie gemengd, mitsgaders zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Het is het brandoffer des sabbats op elken sabbat, boven het gedurig brandoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","En in de beginselen uwer maanden zult gij een brandoffer den HEERE offeren: twee jonge varren, en een ram, zeven volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","En drie tienden meelbloem ten spijsoffer, met olie gemengd, tot den enen var; en twee tienden meelbloem ten spijsoffer, met olie gemengd, tot den enen ram; ");
INSERT INTO nld_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","En tot elk tiende deel meelbloem ten spijsoffer, met olie gemengd, tot het ene lam; het is een brandoffer tot een liefelijken reuk, een vuuroffer, den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","En hun drankofferen zullen zijn de helft van een hin tot een var, en een derde deel van een hin tot een ram, en een vierendeel van een hin van wijn tot een lam; dat is het brandoffer der nieuwe maan in elke maand, naar de maanden des jaars. ");
INSERT INTO nld_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Daartoe zal een geitenbok ten zondoffer den HEERE, boven het gedurige brandoffer, bereid worden, met zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","En in de eerste maand, op den veertienden dag der maand, is het pascha den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","En op den vijftienden dag derzelve maand is het feest; zeven dagen zullen ongezuurde broden gegeten worden. ");
INSERT INTO nld_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Op den eersten dag zal een heilige samenroeping zijn; geen dienstwerk zult gijlieden doen; ");
INSERT INTO nld_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Maar gij zult een vuuroffer ten brandoffer den HEERE offeren: twee jonge varren, en een ram, daartoe zeven eenjarige lammeren; volkomen zullen zij u zijn. ");
INSERT INTO nld_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","En hun spijsoffer zal zijn meelbloem, met olie gemengd; drie tienden tot een var, en twee tienden tot een ram zult gij bereiden. ");
INSERT INTO nld_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Tot elk zult gij een tiende deel bereiden tot een lam, tot die zeven lammeren toe. ");
INSERT INTO nld_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Daarna een bok ten zondoffer, om over ulieden verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Behalve het morgenbrandoffer, hetwelk tot een gedurig brandoffer is, zult gij deze dingen bereiden. ");
INSERT INTO nld_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Achtervolgens deze dingen zult gij des daags, zeven dagen lang, de spijze des vuuroffers bereiden tot een liefelijken reuk den HEERE; boven dat gedurig brandoffer zal het bereid worden, met zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","En op den zevenden dag zult gij een heilige samenroeping hebben; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Insgelijks op den dag der eerstelingen, als gij een nieuw spijsoffer den HEERE zult offeren naar uw werken, zult gij een heilige samenroeping hebben; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Dan zult gij den HEERE een brandoffer ten liefelijken reuk offeren: twee jonge varren, een ram, zeven eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","En hun spijsoffer van meelbloem, met olie gemengd: drie tienden tot een var, twee tienden tot een ram; ");
INSERT INTO nld_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Tot elk een tiende tot een lam, tot die zeven lammeren toe; ");
INSERT INTO nld_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Een geitenbok, om voor u verzoening te doen. ");
INSERT INTO nld_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Behalve het gedurig brandoffer, en zijn spijsoffer, zult gij ze bereiden; zij zullen u volkomen zijn met hun drankofferen. ");
INSERT INTO nld_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Desgelijks in de zevende maand, op den eersten der maand, zult gij een heilige samenroeping hebben; geen dienstwerk zult gij doen; het zal u een dag des geklanks zijn. ");
INSERT INTO nld_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dan zult gij een brandoffer, ten liefelijken reuk, den HEERE bereiden: een jongen var, een ram, zeven volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","En hun spijsoffer van meelbloem, met olie gemengd; drie tienden tot den var, twee tienden tot den ram. ");
INSERT INTO nld_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","En een tiende tot een lam, tot die zeven lammeren toe; ");
INSERT INTO nld_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","En een geitenbok ten zondoffer, om over ulieden verzoening te doen; ");
INSERT INTO nld_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Behalve het brandoffer der maand, en zijn spijsoffer, en het gedurig brandoffer, en zijn spijsoffer, met hun drankofferen, naar hun wijze, ten liefelijken reuk, ten vuuroffer den HEERE. ");
INSERT INTO nld_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","En op den tienden dezer zevende maand zult gij een heilige samenroeping hebben, en gij zult uw zielen verootmoedigen; geen werk zult gij doen; ");
INSERT INTO nld_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Maar gij zult brandoffer, ten liefelijken reuk, den HEERE offeren: een jongen var, een ram, zeven eenjarige lammeren; volkomen zullen zij u zijn; ");
INSERT INTO nld_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","En hun spijsoffer van meelbloem, met olie gemengd: drie tienden tot den var, twee tienden tot den enen ram; ");
INSERT INTO nld_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Tot elk een tiende tot een lam, tot die zeven lammeren toe; ");
INSERT INTO nld_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Een geitenbok ten zondoffer, behalve het zondoffer der verzoeningen, en het gedurig brandoffer; en zijn spijsoffer, met hun drankofferen. ");
INSERT INTO nld_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Insgelijks op den vijftienden dag dezer zevende maand, zult gij een heilige samenroeping hebben; geen dienstwerk zult gij doen; maar zeven dagen zult gij den HEERE een feest vieren. ");
INSERT INTO nld_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","En gij zult een brandoffer ten vuuroffer offeren, ten liefelijken reuk den HEERE: dertien jonge varren, twee rammen, veertien eenjarige lammeren; zij zullen volkomen zijn; ");
INSERT INTO nld_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","En hun spijsoffer van meelbloem, met olie gemengd: drie tienden tot een var, tot die dertien varren toe; twee tienden tot een ram, onder die twee rammen; ");
INSERT INTO nld_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","En tot elke een tiende tot een lam, tot die veertien lammeren toe; ");
INSERT INTO nld_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","En een geitenbok ten zondoffer; behalve het gedurig brandoffer, zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Daarna op den tweeden dag: twaalf jonge varren, twee rammen, veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","En hun spijsoffer, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","En een geitenbok ten zondoffer; behalve het gedurig brandoffer, en zijn spijsoffer, met hun drankofferen. ");
INSERT INTO nld_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","En op den derden dag: elf varren, twee rammen, veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","En hun spijsofferen, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","En een bok ten zondoffer; behalve het gedurig brandoffer, en zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Verder op den vierden dag: tien varren, twee rammen, veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Hun spijsoffer, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","En een geitenbok ten zondoffer; behalve het gedurig brandoffer, zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","En op den vijfden dag: negen varren, twee rammen, en veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","En hun spijsoffer, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","En een bok ten zondoffer; behalve het gedurig brandoffer, en zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Daarna op den zesden dag: acht varren, twee rammen, veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","En hun spijsoffer, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","En een bok ten zondoffer; behalve het gedurig brandoffer, zijn spijsoffer, en zijn drankofferen. ");
INSERT INTO nld_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","En op den zevenden dag: zeven varren, twee rammen, veertien volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","En hun spijsoffer, en hun drankofferen tot de varren, tot de rammen, en tot de lammeren, in hun getal, naar hun wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","En een bok ten zondoffer; behalve het gedurig brandoffer, zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Op den achtsten dag zult gij een verbodsdag hebben; geen dienstwerk zult gij doen. ");
INSERT INTO nld_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","En gij zult een brandoffer ten vuuroffer offeren, ten liefelijken reuk den HEERE; een var, een ram, zeven volkomen eenjarige lammeren; ");
INSERT INTO nld_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Hun spijsoffer, en hun drankofferen tot den var, tot den ram, en tot de lammeren, in hun getal, naar de wijze; ");
INSERT INTO nld_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","En een bok ten zondoffer; behalve het gedurig brandoffer, en zijn spijsoffer, en zijn drankoffer. ");
INSERT INTO nld_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Deze dingen zult gij den HEERE doen op uw gezette hoogtijden; behalve uw geloften, en uw vrijwillige offeren, met uw brandofferen, en met uw spijsofferen en met uw drankofferen, en met uw dankofferen. ");
INSERT INTO nld_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","En Mozes sprak tot de kinderen Israels naar al wat de HEERE Mozes geboden had. ");
INSERT INTO nld_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","En Mozes sprak tot de hoofden der stammen van de kinderen Israels, zeggende: Dit is de zaak, die de HEERE geboden heeft: ");
INSERT INTO nld_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Wanneer een man den HEERE een gelofte zal beloofd, of een eed zal gezworen hebben, zijn ziel met een verbintenis verbindende, zijn woord zal hij niet ontheiligen; naar alles, wat uit zijn mond gegaa