﻿USE sofia;
DROP TABLE IF EXISTS sofia.nld1939_vpl;
CREATE TABLE nld1939_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nld1939_vpl WRITE;
INSERT INTO nld1939_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In het begin schiep God hemel en aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Maar de aarde was nog ongeordend en leeg, over de wereldzee heerste duisternis, en Gods Geest zweefde over de wateren. ");
INSERT INTO nld1939_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God sprak: Daar zij licht. En er was licht. ");
INSERT INTO nld1939_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","En God zag, dat het licht goed was. Nu scheidde God het licht van de duisternis; ");
INSERT INTO nld1939_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","het licht noemde Hij dag, en de duisternis noemde Hij nacht. Zo werd het avond en morgen: de eerste dag. ");
INSERT INTO nld1939_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God sprak: Er zij een uitspansel tussen de wateren, om de wateren van elkander te scheiden. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","God maakte het uitspansel, en scheidde het water onder het uitspansel van het water daarboven; ");
INSERT INTO nld1939_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","het uitspansel noemde God hemel. Weer werd het avond en morgen: de tweede dag. ");
INSERT INTO nld1939_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God sprak: Het water onder de hemel moet samenvloeien naar één plaats, zodat het droge te voorschijn komt. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Het droge noemde God aarde, het saamgevloeide water noemde Hij zee. En God zag, dat het goed was. ");
INSERT INTO nld1939_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God sprak: De aarde moet groene planten voortbrengen, zaaddragend gewas en vruchtbomen, die zaadvruchten dragen op aarde, elk naar zijn soort. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","De aarde deed groene planten ontspruiten, zaaddragend gewas, en bomen, die zaadvruchten dragen, elk naar zijn soort. En God zag, dat het goed was. ");
INSERT INTO nld1939_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Weer werd het avond en morgen: de derde dag. ");
INSERT INTO nld1939_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God sprak: Er moeten lichten komen aan het hemelgewelf, om de dag en de nacht van elkaar te scheiden; zij moeten ook tot tekenen dienen voor vaste tijden, dagen en jaren; ");
INSERT INTO nld1939_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","en als lichten staan aan het hemelgewelf, om de aarde te verlichten. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God maakte de beide grote lichten: het grootste licht om de dag te beheersen, en het kleinste om heerschappij te voeren over de nacht; bovendien de sterren. ");
INSERT INTO nld1939_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God plaatste ze aan het hemelgewelf, om de aarde te verlichten, ");
INSERT INTO nld1939_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","om te heersen over de dag en de nacht, en om licht en duisternis van elkander te scheiden. En God zag, dat het goed was. ");
INSERT INTO nld1939_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Weer werd het avond en morgen: de vierde dag. ");
INSERT INTO nld1939_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God sprak: Laat het water krioelen van levend gewemel, en over de aarde de vogels vliegen langs het hemelgewelf. ");
INSERT INTO nld1939_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Toen schiep God de grote zeegedrochten met al het levend gewemel, waarvan het water krioelt, elk naar zijn soort; en al de verschillende soorten van gevleugelde dieren. En God zag, dat het goed was. ");
INSERT INTO nld1939_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Toen zegende God ze, en sprak: Weest vruchtbaar en vermenigvuldigt u; bevolkt het water der zee, en laat ook de vogels zich op aarde vermeerderen. ");
INSERT INTO nld1939_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Weer werd het avond en morgen: de vijfde dag. ");
INSERT INTO nld1939_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God sprak: Laat de aarde levende wezens voortbrengen van allerlei soort; tamme dieren, kruipende dieren en beesten in het wild, elk naar zijn soort. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God maakte de verschillende soorten van wilde en tamme dieren met al wat over de aarde kruipt. En God zag, dat het goed was. ");
INSERT INTO nld1939_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","God sprak: Laat ons den mens maken als ons beeld, op ons gelijkend; hij heerse over de vissen der zee, de vogels in de lucht, de viervoetige dieren, en over heel de aarde met alles, wat er op kruipt. ");
INSERT INTO nld1939_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","En God schiep den mens als zijn beeld. Als het beeld van God schiep Hij hem; Man en vrouw schiep Hij hen. ");
INSERT INTO nld1939_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Toen zegende God ze, en sprak tot hen: Weest vruchtbaar en vermenigvuldigt u; bevolkt de aarde en onderwerpt haar; heerst over de vissen der zee, de vogels in de lucht en over alle levende wezens, die zich op de aarde bewegen. ");
INSERT INTO nld1939_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God sprak: Zie, Ik geef u al het zaaddragend gewas op de hele aarde, met alle bomen, die zaadvruchten dragen; die zullen u tot voedsel dienen. ");
INSERT INTO nld1939_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Maar aan alle wilde beesten, aan alle vogels in de lucht, aan al wat beweegt en leeft op de aarde, geef Ik alle groene planten tot voedsel. Zo geschiedde. ");
INSERT INTO nld1939_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","En God zag dat alles, wat Hij gemaakt had, zeer goed was. Weer werd het avond en morgen: de zesde dag. ");
INSERT INTO nld1939_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Zo werden hemel en aarde voltooid met heel hun heir. ");
INSERT INTO nld1939_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","En toen God op de zevende dag het werk had voltooid, dat Hij gemaakt had, rustte Hij op de zevende dag van al het werk, dat Hij had gedaan. ");
INSERT INTO nld1939_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God zegende de zevende dag, en verklaarde die heilig, omdat God toen rustte van al het werk, dat Hij geschapen en tot stand had gebracht. ");
INSERT INTO nld1939_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dit is de scheppingsgeschiedenis van hemel en aarde. Toen Jahweh God aarde en hemel gemaakt had, ");
INSERT INTO nld1939_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","groeide er op aarde nog geen enkele struik in het wild, en evenmin ontsproot er gras op de velden; want Jahweh God had het nog niet laten regenen op aarde, en er was nog geen mens, om het land te bewerken; ");
INSERT INTO nld1939_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","maar een damp steeg op uit de aarde, die heel de aardbodem drenkte. ");
INSERT INTO nld1939_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Toen vormde Jahweh God den mens uit kleiaarde, en blies levensadem in zijn neus; zo werd de mens een levend wezen. ");
INSERT INTO nld1939_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nu plantte Jahweh God een tuin in Eden, in het oosten, en plaatste daarin den mens, dien Hij gemaakt had. ");
INSERT INTO nld1939_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Uit de bodem liet Jahweh God allerlei bomen opschieten, prachtig van vorm en met heerlijke vruchten; en midden in de tuin stond de levensboom, en de boom der kennis van goed en kwaad. ");
INSERT INTO nld1939_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","In Eden ontsprong een rivier, die de tuin bevloeide, en zich verderop in vier takken splitste. ");
INSERT INTO nld1939_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","De eerste heet de Pisjon; deze stroomt om het hele land Chawila heen, waar het goud wordt gevonden; ");
INSERT INTO nld1939_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","het goud van dat land is voortreffelijk; men vindt daar ook balsemhars en robijnen. ");
INSERT INTO nld1939_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","De tweede stroom heet de Gichon, en deze omspoelt het hele land van Koesj. ");
INSERT INTO nld1939_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","De derde stroom heet de Tigris, en loopt ten oosten van Assjoer. De vierde is de Eufraat. ");
INSERT INTO nld1939_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Daarop plaatste Jahweh God den mens in de tuin van Eden, om die te bewerken en te bewaken. ");
INSERT INTO nld1939_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","En Jahweh God gaf den mens het volgend gebod: Van alle bomen uit de tuin moogt ge eten; ");
INSERT INTO nld1939_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","maar van de boom der kennis van goed en kwaad moogt ge niet eten; want wanneer ge daarvan eet, zult ge sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","En Jahweh God sprak: Het is niet goed voor den mens, dat hij alleen blijft. Ik zal dus een hulp voor hem maken, die hem past. ");
INSERT INTO nld1939_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Toen vormde Jahweh God uit de klei alle dieren op het land en alle vogels in de lucht, en voerde ze naar den mens, om te zien, hoe hij ze zou noemen; want zoals de mens elk levend wezen zou noemen, zo zou het heten. ");
INSERT INTO nld1939_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","De mens gaf dan namen aan alle tamme dieren en aan de vogels in de lucht en aan alle dieren in het wild, maar vond geen hulp, die hem paste. ");
INSERT INTO nld1939_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nu bracht Jahweh God den mens in een diepe slaap; en terwijl hij sliep, nam Hij een van zijn ribben, en zette er vlees voor in de plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dan bouwde Jahweh God een vrouw uit de rib, die Hij uit den mens had genomen, en leidde haar tot den mens. ");
INSERT INTO nld1939_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Toen sprak de mens: Deze is eindelijk been van mijn gebeente En vlees van mijn vlees. Mannin zal zij heten, Omdat zij van den man is genomen. ");
INSERT INTO nld1939_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Daarom verlaat de man zijn vader en moeder, en hecht zich geheel aan zijn vrouw; en zij worden één vlees. ");
INSERT INTO nld1939_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","De mens en zijn vrouw waren allebei naakt, maar zij schaamden zich niet voor elkander. ");
INSERT INTO nld1939_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","De slang was het sluwste van alle dieren in het wild, die Jahweh God had gemaakt. Ze sprak tot de vrouw: Heeft God u dan werkelijk verboden, van de bomen in de tuin te eten? ");
INSERT INTO nld1939_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","De vrouw gaf de slang ten antwoord: We mogen de vruchten eten van al de bomen in de tuin; ");
INSERT INTO nld1939_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","alleen heeft God gezegd: ge moogt niet de vruchten eten van de boom, die midden in de tuin staat, en die zelfs niet aanraken; anders zult ge sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Maar de slang sprak tot de vrouw: Ge zult volstrekt niet sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Maar God weet, dat uw ogen zullen opengaan, wanneer ge daarvan eet, en dat ge gelijk aan God zult worden door de kennis van goed en kwaad. ");
INSERT INTO nld1939_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ook had de vrouw al bemerkt, hoe goed die boom was om van te eten; hoe hij een lust was voor de ogen, en hoe verleidelijk, wanneer men inzicht wil verkrijgen. Ze plukte dus van zijn vrucht en at; ze gaf er ook van aan haar man, die bij haar stond, en ook hij at er van. ");
INSERT INTO nld1939_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nu gingen hun beiden de ogen open; ze merkten, dat ze naakt waren. Ze hechtten daarom vijgeblaren aaneen, en maakten er zich een schaamgordel van. ");
INSERT INTO nld1939_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","En toen zij Jahweh God in de koelte van de middag in de tuin hoorden wandelen, verborgen de mens en zijn vrouw zich voor Jahweh God tussen de bomen van de tuin. ");
INSERT INTO nld1939_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Maar Jahweh God riep den mens, en sprak tot hem: Waar zijt gij? ");
INSERT INTO nld1939_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Hij antwoordde: Toen ik U in de tuin hoorde, werd ik bang, omdat ik naakt ben; en ik heb mij verborgen. ");
INSERT INTO nld1939_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Maar Hij sprak: Wie heeft u verteld, dat ge naakt zijt? Hebt ge soms van de boom gegeten, waarvan Ik u verboden heb te eten? ");
INSERT INTO nld1939_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","De mens antwoordde: De vrouw, die Gij mij tot gezellin hebt gegeven, gaf mij van de boom, en ik at. ");
INSERT INTO nld1939_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nu sprak Jahweh God tot de vrouw: Wat hebt ge gedaan? De vrouw gaf ten antwoord: De slang heeft mij verleid, en ik heb gegeten. ");
INSERT INTO nld1939_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Toen sprak Jahweh God tot de slang: Omdat ge dit gedaan hebt, zijt ge vervloekt Onder alle tamme en wilde dieren; Op uw buik zult ge kruipen, Stof vreten uw leven lang. ");
INSERT INTO nld1939_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ik zal vijandschap wekken tussen u en de vrouw, Tussen uw kroost en haar kroost; Dit zal u de kop verpletteren, Maar gij zult loeren naar zijn hiel. ");
INSERT INTO nld1939_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","En tot de vrouw sprak Hij: De lasten uwer zwangerschap zal Ik verzwaren, In smarten zult ge kinderen baren; Toch zult ge naar uw man verlangen, En hij zal over u heersen. ");
INSERT INTO nld1939_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","En Hij sprak tot den mens: Omdat ge naar uw vrouw hebt geluisterd, En van de boom hebt gegeten, waarvan Ik u verbood te eten; Is om u de aardbodem vervloekt, Alleen door levenslang zwoegen zult ge er van eten. ");
INSERT INTO nld1939_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Distels en doornen zal hij u voortbrengen, Ofschoon gij u met veldgewas moet voeden; ");
INSERT INTO nld1939_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In het zweet van uw aanschijn zult gij uw brood eten, Totdat ge terugkeert tot de grond, waaruit ge genomen zijt. Want ge zijt stof, En tot stof keert ge terug! ");
INSERT INTO nld1939_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","De mens noemde zijn vrouw nu Eva, omdat zij de moeder zou worden van al wat leeft. ");
INSERT INTO nld1939_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","En Jahweh God maakte kleren van dierenhuiden voor den mens en zijn vrouw, en bekleedde hen daarmee. ");
INSERT INTO nld1939_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Toen sprak Jahweh God: Zie, door de kennis van goed en kwaad is de mens geworden als een van ons. Als hij nu zijn hand maar niet uitstrekt, om te plukken en te eten van de levensboom, zodat hij ook nog eeuwig blijft leven! ");
INSERT INTO nld1939_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Daarom verdreef Jahweh God hem uit de tuin van Eden, om de grond te bebouwen, waaruit hij genomen was. ");
INSERT INTO nld1939_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Hij joeg den mens weg, en plaatste ten oosten van Edens tuin de cherubs met de vlam van het bliksemende zwaard, om de weg naar de levensboom te bewaken. ");
INSERT INTO nld1939_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","De mens had gemeenschap met Eva, zijn vrouw; zij werd zwanger, baarde Kaïn, en sprak: Met de hulp van Jahweh heb ik een mannelijk kind ter wereld gebracht. ");
INSERT INTO nld1939_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Daarna baarde zij nog zijn broer Abel. Abel werd schaapherder, en Kaïn landbouwer. ");
INSERT INTO nld1939_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Geruime tijd later droeg Kaïn eens aan Jahweh een offer op van de vruchten der aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ook Abel bracht een offer van de eerstgeborenen van zijn kudde, en wel van de vetste. En Jahweh zag genadig neer op Abel en zijn offer, ");
INSERT INTO nld1939_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","maar op Kaïn en zijn offer sloeg Jahweh geen acht. Daardoor ontstak Kaïn in heftige toorn, en zag somber voor zich uit. ");
INSERT INTO nld1939_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Jahweh vroeg toen aan Kaïn: Waarom zijt gij vertoornd, en waarom is uw gelaat zo somber? ");
INSERT INTO nld1939_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Indien ge onberispelijk leeft, wordt uw offer zeker aanvaard; zo niet, dan loert de zonde aan de deur, gaat naar u haar begeerte, en zult ge ze moeten overwinnen. ");
INSERT INTO nld1939_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Maar Kaïn sprak tot Abel, zijn broer: Kom, laten we het veld ingaan. En toen zij op het veld waren, viel Kaïn zijn broer Abel aan en sloeg hem dood. ");
INSERT INTO nld1939_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nu sprak Jahweh tot Kaïn: Waar is Abel uw broer? Hij zeide: Ik weet het niet; moet ik soms mijn broer nog bewaken? ");
INSERT INTO nld1939_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hij hernam: Wat hebt gij gedaan? Het bloed van uw broer roept luid tot Mij uit de grond. ");
INSERT INTO nld1939_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Wees dan vervloekt door de grond, die zijn muil heeft opengesperd, om het bloed van uw broer uit uw hand te ontvangen. ");
INSERT INTO nld1939_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Als gij de grond bebouwt, zal hij u geen oogst meer geven. Een zwerver en vluchteling zult ge zijn op de aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Toen sprak Kaïn tot Jahweh: Mijn schuld is te groot, om vergeven te worden. ");
INSERT INTO nld1939_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Zie, Gij jaagt mij thans van het akkerland weg, en ik zal mij voor uw aanschijn moeten verbergen; dan zal ik een zwerver en vluchteling zijn op de aarde, en iedereen die mij vindt, zal mij doden. ");
INSERT INTO nld1939_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Maar Jahweh sprak tot hem: Neen; ieder, die Kaïn doodt, zal het zevenmaal boeten. En Jahweh gaf Kaïn een teken, opdat niemand, die hem vinden zou, hem zou doden. ");
INSERT INTO nld1939_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Daarna verdween Kaïn voor het aanschijn van Jahweh, en vestigde zich in het land Nod, ten oosten van Eden. ");
INSERT INTO nld1939_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaïn had gemeenschap met zijn vrouw; zij werd zwanger, en baarde Chanok. Hij bouwde later een stad, en noemde die stad naar Chanok, zijn zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Aan Chanok werd Irad geboren, en Irad verwekte Mechoejaël; Mechoejaël verwekte Metoesjaël, en Metoesjaël weer Lémek. ");
INSERT INTO nld1939_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lémek nam twee vrouwen: de eerste heette Ada, de andere Silla. ");
INSERT INTO nld1939_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada baarde Jabal; deze werd de vader van de tentbewoners en veefokkers. ");
INSERT INTO nld1939_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Zijn broer heette Joebal; hij werd de vader van allen, die spelen op citer en fluit. ");
INSERT INTO nld1939_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ook Silla baarde: Toebal-Kaïn, een smid, den vader van alle brons(-) en ijzersmeden. De zuster van Toebal-Kaïn heette Naäma. ");
INSERT INTO nld1939_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Eens sprak Lémek tot zijn vrouwen: Ada en Silla, hoort mijn stem; Vrouwen van Lémek, luistert naar mijn woorden: Een man sla ik dood om mijn wonden, Een jongeling om een striem; ");
INSERT INTO nld1939_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Want zevenmaal wordt Kaïn gewroken, Maar Lémek zeven en zeventig maal. ");
INSERT INTO nld1939_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Weer hield Adam gemeenschap met zijn vrouw; zij baarde een zoon, dien zij Set noemde. Want, sprak zij, God heeft mij een anderen telg in de plaats van Abel gegeven, omdat Kaïn hem heeft vermoord. ");
INSERT INTO nld1939_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ook Set werd een zoon geboren, dien hij Enos noemde; en deze begon de naam van Jahweh aan te roepen. ");
INSERT INTO nld1939_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dit is de geslachtslijst van Adam. Toen God den mens schiep, maakte Hij hem op God gelijkend; ");
INSERT INTO nld1939_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","man en vrouw schiep Hij hen. En op de dag van hun schepping zegende Hij hen, en noemde hen mens. ");
INSERT INTO nld1939_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam was honderd dertig jaar oud, toen hij als zijn beeld, op zich gelijkend, een zoon verwekte, wien hij de naam Set gaf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","En Adam leefde, nadat hij Set verwekt had, nog achthonderd jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Heel de levensduur van Adam was negenhonderd dertig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set was honderd vijf jaar oud, toen hij Enos verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","En Set leefde, nadat hij Enos verwekt had, nog achthonderd zeven jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Heel de levensduur van Set was negenhonderd twaalf jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos was negentig jaar oud, toen hij Kaïnan verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","En Enos leefde, nadat hij Kaïnan verwekt had, nog achthonderd vijftien jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Heel de levensduur van Enos was negenhonderd vijf jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kaïnan was zeventig jaar oud, toen hij Malaleël verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","En Kaïnan leefde, nadat hij Malaleël verwekt had, nog achthonderd veertig jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Heel de levensduur van Kaïnan was negenhonderd tien jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaleël was vijf en zestig jaar oud, toen hij Járed verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","En Malaleël leefde, nadat hij Járed verwekt had, nog achthonderd dertig jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Heel de levensduur van Malaleël was achthonderd vijf en negentig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Járed was honderd twee en zestig jaar oud, toen hij Henok verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","En Járed leefde, nadat hij Henok verwekt had, nog achthonderd jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Heel de levensduur van Járed was negenhonderd twee en zestig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok was vijf en zestig jaar oud, toen hij Matoesala verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok leefde vertrouwelijk met God. En hij leefde, nadat hij Matoesala verwekt had, nog driehonderd jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Heel de levensduur van Henok was driehonderd vijf en zestig jaar. ");
INSERT INTO nld1939_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","En omdat Henok vertrouwelijk met God had geleefd, nam God hem weg, en men vond hem niet meer. ");
INSERT INTO nld1939_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matoesala was honderd zeven en tachtig jaar oud, toen hij Lámek verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","En Matoesala leefde, nadat hij Lámek verwekt had, nog zevenhonderd twee en tachtig jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Heel de levensduur van Matoesala was negenhonderd negen en zestig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lámek was honderd twee en tachtig jaar oud, toen hij een zoon verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Hij noemde hem Noë, want hij sprak: Deze zal ons uit de bodem, die Jahweh vervloekt heeft, verkwikking verschaffen bij ons werken en zwoegen. ");
INSERT INTO nld1939_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","En Lámek leefde, nadat hij Noë verwekt had, nog vijfhonderd vijf en negentig jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Heel de levensduur van Lámek was zevenhonderd zeven en zeventig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noë was vijfhonderd jaar oud, toen hij Sem, Cham en Jáfet verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Toen de mensen talrijk begonnen te worden op de oppervlakte der aarde, en hun dochters werden geboren, ");
INSERT INTO nld1939_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","zagen de zonen Gods, hoe schoon de dochters der mensen waren, en zij namen zich zoveel vrouwen, als zij maar wilden. ");
INSERT INTO nld1939_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Toen sprak Jahweh: Mijn geest zal niet voor altijd bij de mensen blijven, omdat ze bedorven zijn, en enkel vlees; hun tijd zal nog maar honderd twintig jaar duren. ");
INSERT INTO nld1939_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In die dagen, toen de zonen Gods tot de dochters der mensen waren gekomen, en deze hun kinderen hadden gebaard, waren er reuzen op aarde, en ook nog daarna. Dat waren de krachtmensen uit de oude tijd, beruchte mannen. ");
INSERT INTO nld1939_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Toen Jahweh dan zag, hoe groot op aarde het bederf onder de mensen was geworden, en zij enkel maar zonnen op slechte dingen, ");
INSERT INTO nld1939_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","berouwde het Jahweh, dat Hij den mens op aarde gemaakt had, en kreeg Hij er spijt van. ");
INSERT INTO nld1939_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","En Jahweh sprak: Ik zal den mens, dien Ik geschapen heb, van de aarde verdelgen; zowel den mens als de viervoetige dieren, de kruipende dieren en de vogels in de lucht; want het spijt Mij, dat Ik ze gemaakt heb. ");
INSERT INTO nld1939_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maar Noë vond genade in de ogen van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dit is de geschiedenis van Noë. Noë was een rechtschapen man, en leefde onberispelijk te midden van zijn tijdgenoten; Noë leefde vertrouwelijk met God. ");
INSERT INTO nld1939_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noë verwekte drie zonen: Sem, Cham en Jáfet. ");
INSERT INTO nld1939_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","De aarde was dan bedorven geworden in de ogen van God, en van ongerechtigheid vol. ");
INSERT INTO nld1939_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Toen God dus zag, dat de aarde was bedorven, omdat alle mensen op aarde waren bedorven, ");
INSERT INTO nld1939_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","sprak God tot Noë: Ik heb de ondergang van alle mensen besloten, omdat ze de aarde van hun ongerechtigheid hebben vervuld. Zie, Ik zal ze met de aarde verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Maak nu voor u een ark van pijnhout, verdeel die ark in vakken, en bestrijk ze van binnen en buiten met pek. ");
INSERT INTO nld1939_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Zo moet ge ze maken: de ark moet driehonderd el lang zijn, vijftig el breed, en dertig el hoog. ");
INSERT INTO nld1939_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ge moet op de ark een dak maken, en een el hoog optrekken. In de lengtezijde moet ge de deur aanbrengen. Ge moet er ook een benedenruim, en een tweede en een derde verdek in maken. ");
INSERT INTO nld1939_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Want Ik ga de zondvloed-wateren over de aarde brengen, om alle schepselen met een levende geest onder de hemel te verdelgen; al wat op aarde is zal sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Maar met u zal Ik mijn verbond sluiten: Gij moet de ark binnengaan: gij zelf en uw zonen, uw vrouw en de vrouwen uwer zonen met u. ");
INSERT INTO nld1939_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ook moet ge van alle levende wezens een paar in de ark brengen, om ze met u in het leven te behouden; mannetje en wijfje moeten het zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","En van alle verschillende soorten van vogels, van alle soorten van beesten, van alle soorten van dieren, die kruipen over de aarde; van alles zal er een paar tot u komen om in het leven te blijven. ");
INSERT INTO nld1939_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ge moet u ook van alle eetbare spijzen voorzien, en die meenemen, om u en hun tot voedsel te dienen. ");
INSERT INTO nld1939_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noë deed het; hij deed al wat God hem gebood. ");
INSERT INTO nld1939_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Toen sprak Jahweh tot Noë: Ga met uw gezin in de ark, want Ik heb u rechtvaardig voor mijn aanschijn bevonden te midden van dit geslacht. ");
INSERT INTO nld1939_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Neem van alle reine dieren zeven paar mee, telkens mannetjes met hun wijfjes, maar van de onreine dieren een enkel paar, eveneens mannetje en wijfje; ");
INSERT INTO nld1939_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ook van de vogels in de lucht zeven paar, de mannetjes met hun wijfjes: om hun soort in stand te houden over de hele aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Want over zeven dagen zal Ik het op aarde doen stortregenen, veertig dagen en veertig nachten; en al wat leeft, en wat Ik gemaakt heb, zal Ik van de aarde verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","En Noë deed alles, wat Jahweh hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noë was zeshonderd jaar oud, toen de zondvloed over de aarde kwam. ");
INSERT INTO nld1939_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","En voor het water van de zondvloed vluchtte Noë in de ark met zijn zonen, zijn vrouw en de vrouwen van zijn zonen. ");
INSERT INTO nld1939_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Van de reine en onreine dieren, van de vogels, en van al wat over de aarde kruipt, ");
INSERT INTO nld1939_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kwam telkens een paar, mannetje en wijfje, naar Noë binnen de ark, zoals God Noë geboden had. ");
INSERT INTO nld1939_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","En op de zevende dag stortten de wateren van de zondvloed over de aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In het zeshonderdste levensjaar van Noë, in de tweede maand, op de zeven en twintigste dag van de maand, toen braken alle kolken los van de geweldige afgrond, en werden de sluizen van de hemel geopend; ");
INSERT INTO nld1939_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","er stortte een regen op de aarde, veertig dagen en veertig nachten. ");
INSERT INTO nld1939_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nog diezelfde dag ging Noë in de ark met Sem, Cham en Jáfet, de zonen van Noë, met de vrouw van Noë en de drie vrouwen van zijn zonen; ");
INSERT INTO nld1939_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","zijzelf met alle soorten van wilde en tamme dieren, met alle soorten van wat er over de aarde kruipt, met alle soorten van vogels, alles wat veren en vleugels heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","In paren kwamen alle levende wezens naar Noë in de ark: ");
INSERT INTO nld1939_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","zij kwamen naar het bevel van God: mannetje en wijfje van al wat leeft. En Jahweh deed de deur achter hen dicht. ");
INSERT INTO nld1939_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Toen kwam de zondvloed over de aarde, veertig dagen lang. De wateren stegen, en droegen de ark, zodat zij zich van de aarde verhief. ");
INSERT INTO nld1939_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nog bleef het water wassen en stijgen op aarde, en de ark dreef op het water voort. ");
INSERT INTO nld1939_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hoger en hoger klommen de wateren op aarde, zodat zelfs de hoogste bergen, die onder heel de hemel zijn, werden bedekt. ");
INSERT INTO nld1939_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Vijftien ellen steeg het water boven de bergen, zodat ze helemaal bedolven werden. ");
INSERT INTO nld1939_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Alle schepselen kwamen om, alles wat zich op de aarde beweegt: vogels, tamme en wilde dieren met al wat over de aarde kruipt; en eveneens alle mensen. ");
INSERT INTO nld1939_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Alles stierf, wat op het droge leefde met levensadem in zijn neus. ");
INSERT INTO nld1939_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Al wat op aarde bestond, werd verzwolgen; mens, viervoetige dieren, kruipende dieren en vogels in de lucht werden van de aarde verdelgd. Noë alleen, en wat met hem in de ark was, bleef over. ");
INSERT INTO nld1939_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","De wateren hielden de aarde honderd vijftig dagen bedekt. ");
INSERT INTO nld1939_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Toen dacht God aan Noë, en aan alle wilde en tamme dieren, die met hem in de ark waren. God deed een wind over de aarde waaien, waardoor het water begon te zakken. ");
INSERT INTO nld1939_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","De kolken van de afgrond en de sluizen van de hemel werden gesloten, en de regen uit de hemel hield op. ");
INSERT INTO nld1939_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Het water vloeide langzaam heen, en zakte na verloop van honderd vijftig dagen van de aarde weg. ");
INSERT INTO nld1939_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","In de zevende maand, op de zeventiende dag van de maand, liep de ark op het gebergte Ararat vast. ");
INSERT INTO nld1939_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Het water bleef geleidelijk zakken tot de tiende maand; op de eerste dag der tiende maand werden de toppen der bergen zichtbaar. ");
INSERT INTO nld1939_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","En toen er veertig dagen waren verlopen, opende Noë het venster, dat hij in de ark had gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Hij liet een raaf los, die heen en weer bleef vliegen, tot het water op de aarde was opgedroogd. ");
INSERT INTO nld1939_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Daarna liet hij een duif los, om te zien, of het water al van de aarde weg was. ");
INSERT INTO nld1939_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Maar de duif vond geen plek voor haar pootjes en keerde naar hem terug in de ark; want het water hield nog de hele oppervlakte der aarde bedekt. Hij stak zijn hand uit, pakte ze beet, en haalde ze naar zich toe in de ark. ");
INSERT INTO nld1939_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nu wachtte hij nog zeven dagen, en liet toen opnieuw een duif uit de ark. ");
INSERT INTO nld1939_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","De duif keerde tegen de avond naar hem terug, en droeg een frisse olijftak in de bek. Toen begreep Noë, dat het water van de aarde moest zijn weggezakt. ");
INSERT INTO nld1939_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Weer wachtte hij nu zeven dagen, en liet toen opnieuw de duif uitvliegen; maar nu keerde ze niet meer naar hem terug. ");
INSERT INTO nld1939_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","In het zeshonderd eerste levensjaar van Noë, in het begin van de eerste maand, was het water van de aarde opgedroogd. Nu verwijderde Noë het dak van de ark, en keek naar buiten; en zie, de oppervlakte der aarde was droog. ");
INSERT INTO nld1939_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","In de tweede maand, op de zeven en twintigste dag der maand, was de aarde helemaal droog. ");
INSERT INTO nld1939_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Toen sprak God tot Noë: ");
INSERT INTO nld1939_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ga uit de ark; gij met uw vrouw, uw zonen en de vrouwen uwer zonen. ");
INSERT INTO nld1939_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","En laat ook alle dieren, alle wezens die bij u zijn, tegelijk met u naar buiten komen: de vogels, de viervoetige dieren en al wat op de aarde kruipt; opdat ze zich weer op de aarde bewegen, vruchtbaar zijn, en talrijk worden op aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noë ging er dus uit met zijn zonen, zijn vrouw en de vrouwen van zijn zonen. ");
INSERT INTO nld1939_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ook alle viervoetige dieren, alle vogels en al wat over de aarde kruipt, elk naar zijn soort, kwamen naar buiten uit de ark. ");
INSERT INTO nld1939_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Toen bouwde Noë een altaar voor Jahweh; en hij nam van alle reine dieren en van alle reine vogels, en droeg ze op het altaar als brandoffer op. ");
INSERT INTO nld1939_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jahweh rook de aangename geur, en sprak bij Zich zelf: Nooit meer zal Ik om den mens de aarde vervloeken, want de gedachten van het mensenhart zijn slecht van zijn jeugd af; en nooit meer zal Ik alle levende wezens treffen, zoals Ik nu heb gedaan. ");
INSERT INTO nld1939_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Zolang de aarde bestaat, Zal er zaai(-) en oogsttijd, koude en hitte zijn; Zomer en winter, dag en nacht, Nooit houden ze op! ");
INSERT INTO nld1939_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Toen zegende God Noë met zijn zonen, en sprak tot hen: Weest vruchtbaar en vermenigvuldigt u, en bevolkt de aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Vrees en schrik voor u zal heersen bij alle dieren op de aarde en bij alle vogels in de lucht; al wat over de aarde kruipt en alle vissen in de zee zijn onderworpen aan uw macht. ");
INSERT INTO nld1939_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alles, wat beweegt en leeft zal u tot voedsel strekken; met het groene gewas geef Ik dit alles aan u. ");
INSERT INTO nld1939_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Alleen het vlees, waarin de ziel nog woont, die het bloed is, moogt ge niet eten. ");
INSERT INTO nld1939_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Maar uw eigen levensbloed zal Ik wreken; van alle dieren zal Ik het terugeisen, zowel als van de mensen; van iedereen zal Ik het leven van den evenmens terugvorderen. ");
INSERT INTO nld1939_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wie het bloed van een mens vergiet, Diens bloed zal door mensen worden vergoten; Want als zijn beeld heeft God den mens gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Gij dan weest vruchtbaar en vermenigvuldigt u; wordt talrijk op de aarde, en bevolkt haar. ");
INSERT INTO nld1939_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Daarop sprak God tot Noë en zijn zonen: ");
INSERT INTO nld1939_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Zie, Ik zelf, Ik sluit mijn verbond met u, en met uw kroost na u, ");
INSERT INTO nld1939_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","en met alle levende wezens, die bij u zijn: met de vogels, de viervoetige dieren en alle dieren der aarde, met al wat uit de ark is gekomen, met al wat op de aarde leeft. ");
INSERT INTO nld1939_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ik sluit met u mijn verbond, dat nooit meer een schepsel door de wateren van de zondvloed zal worden verdelgd, en dat er nooit meer een zondvloed zal komen om de aarde te verwoesten. ");
INSERT INTO nld1939_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","En God sprak: Dit is het teken van het verbond, Dat Ik sluit voor alle geslachten, die komen: Tussen Mij en tussen u, En alle levende wezens, die bij u zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mijn boog zet Ik in de wolken Als een teken van het verbond tussen Mij en de aarde! ");
INSERT INTO nld1939_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wanneer Ik op de aarde de wolken samenpak, En de boog verschijnt in de wolken, ");
INSERT INTO nld1939_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Dan zal Ik mijn verbond gedenken Tussen Mij en u en alle levende wezens. De wateren zullen nooit meer zwellen tot een zondvloed, Om alle vlees te verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Als de boog in de wolken staat, Zal Ik hem zien, om het eeuwig verbond te gedenken Tussen God en alle levende wezens, Alle schepselen, die op aarde zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","En God sprak tot Noë: Dit is het teken van het verbond, dat Ik gesloten heb tussen Mij en alle schepselen, die op aarde zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","De zonen van Noë, die de ark verlieten, waren Sem, Cham en Jáfet; Cham was de vader van Kanaän. ");
INSERT INTO nld1939_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dit waren de drie zonen van Noë, en door hen werd de hele aarde bevolkt. ");
INSERT INTO nld1939_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noë begon het land te bebouwen, en plantte een wijngaard. ");
INSERT INTO nld1939_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Hij dronk van de wijn, werd er door bedwelmd, en lag naakt in zijn tent. ");
INSERT INTO nld1939_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Toen Cham, de vader van Kanaän, de schaamte van zijn vader zag, ging hij het buiten aan zijn twee broers vertellen. ");
INSERT INTO nld1939_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Maar Sem en Jáfet haalden een mantel, legden die allebei op hun schouders, liepen achterwaarts binnen, en met afgewend gelaat bedekten ze de schaamte van hun vader, zodat ze de schaamte van hun vader niet zagen. ");
INSERT INTO nld1939_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Toen Noë uit zijn roes was ontwaakt, en vernam, wat zijn jongste zoon hem had gedaan, ");
INSERT INTO nld1939_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sprak hij: Vervloekt zij Kanaän, Een slaaf der slaven zal hij zijn voor zijn broeders. ");
INSERT INTO nld1939_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hij sprak: Gezegend zij Jahweh, de God van Sem, Kanaän zij hem tot slaaf. ");
INSERT INTO nld1939_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Moge God voor Jáfet ruimte maken, Dat hij wone in de tenten van Sem; Kanaän zij hem tot slaaf. ");
INSERT INTO nld1939_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noë leefde na de zondvloed nog driehonderd vijftig jaar. ");
INSERT INTO nld1939_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Heel de levensduur van Noë was negenhonderd vijftig jaar. En hij stierf. ");
INSERT INTO nld1939_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dit is de geslachtslijst van de zonen van Noë: van Sem, Cham en Jáfet; want hun werden na de zondvloed zonen geboren. ");
INSERT INTO nld1939_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","De zonen van Jáfet zijn Gómer, Magog, Madai, Jawan, Toebal, Mésjek en Tiras. ");
INSERT INTO nld1939_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","De zonen van Gómer: Asjkenaz, Rifat en Togarma. ");
INSERT INTO nld1939_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","De zonen van Jawan: Elisja, Tarsjisj, de Kittiërs en de Rodiërs; ");
INSERT INTO nld1939_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","dezen hebben zich over de kustlanden der volken verdeeld. Dit zijn de zonen van Jáfet volgens hun landen, elk naar zijn taal, zijn stam en zijn volk. ");
INSERT INTO nld1939_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","De zonen van Cham zijn Koesj, Egypte, Poet en Kanaän. ");
INSERT INTO nld1939_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","De zonen van Koesj zijn Seba, Chawila, Sabta, Rama en Sabteka. De zonen van Rama zijn Sjeba en Dedan. ");
INSERT INTO nld1939_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Koesj verwekte ook Nimrod. Deze begon machtig te worden op aarde; ");
INSERT INTO nld1939_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","hij was een geweldig jager voor Jahweh. Daarom zegt men “Een geweldig jager voor Jahweh als Nimrod”. ");
INSERT INTO nld1939_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Aanvankelijk heerste hij over Babel, Erek, Akkad en Kalne, in het land Sjinar; ");
INSERT INTO nld1939_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","maar van dat land rukte hij naar Assjoer op, waar hij Ninive bouwde, Rechobot-Ir en Kálach, ");
INSERT INTO nld1939_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","en Résen tussen Ninive en Kálach; dit is de grote stad. ");
INSERT INTO nld1939_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Egypte bracht de Loedieten voort, de Anamieten, de Lehabieten en de Naftoechieten, ");
INSERT INTO nld1939_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","de Patroesieten en de Kasloechieten, waar de Filistijnen en de Kaftorieten uit voortgekomen zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaän verwekte Sidon, zijn eerstgeborene, en Chet; ");
INSERT INTO nld1939_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","verder de Jeboesieten, Amorieten en de Girgasjieten, ");
INSERT INTO nld1939_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","de Chiwwieten, Arkieten en Sinieten, ");
INSERT INTO nld1939_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","de Arwadieten, Semarieten en Chamatieten. Later werden de stammen der Kanaänieten verspreid, ");
INSERT INTO nld1939_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","zodat het gebied der Kanaänieten zich uitstrekte van Sidon af in de richting van Gerar tot Gaza toe, en in de richting van Sodoma, Gomorra, Adma en Seboim tot Lésja toe. ");
INSERT INTO nld1939_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dit zijn de zonen van Cham volgens hun stammen en talen, naar hun landen en volken. ");
INSERT INTO nld1939_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ook Sem, den stamvader van de zonen van Eber en oudsten broer van Jáfet, werden kinderen geboren. ");
INSERT INTO nld1939_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","De zonen van Sem zijn Elam, Assjoer, Arpaksad, Loed en Aram. ");
INSERT INTO nld1939_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","De zonen van Aram zijn Oes, Choel, Géter en Masj. ");
INSERT INTO nld1939_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad verwekte Sála, en Sála weer Eber. ");
INSERT INTO nld1939_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber had twee zonen; de eerste heette Páleg, omdat in zijn tijd de aarde verdeeld werd; zijn broer heette Joktan. ");
INSERT INTO nld1939_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan verwekte Almodad en Sjélef, Chasarmáwet en Jérach, ");
INSERT INTO nld1939_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Oezal en Dikla, ");
INSERT INTO nld1939_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaël, Sjeba, ");
INSERT INTO nld1939_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Chawila en Jobab: allen zonen van Joktan. ");
INSERT INTO nld1939_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Zij woonden van Mesja af in de richting van Sefar, een gebergte in het oosten. ");
INSERT INTO nld1939_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dit zijn de zonen van Sem volgens hun stammen en talen, naar hun landen en volken. ");
INSERT INTO nld1939_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dit zijn dan de geslachten van de zonen van Noë naar hun stammen en volken; uit hen zijn de volken voortgekomen, die zich na de zondvloed over de aarde hebben verspreid. ");
INSERT INTO nld1939_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nog sprak heel de aarde eenzelfde taal en dezelfde woorden. ");
INSERT INTO nld1939_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Toen men uit het oosten was opgetrokken, en een vlakte in het land Sjinar had gevonden, bleef men daar wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nu zeiden ze tot elkander: Komt, laten we stenen maken, en ze hard bakken in vuur. Die tichels moesten hun tot bouwsteen dienen, de asfalt tot mortel. ");
INSERT INTO nld1939_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Later zeiden ze weer: Komt, laten we ons een stad bouwen met een toren, waarvan de spits tot in de hemel reikt; dan maken we ons een herkenningsteken, zodat we niet over heel de aarde worden verstrooid. ");
INSERT INTO nld1939_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Maar Jahweh daalde neer, om de stad en de toren eens te bezien, die de mensenkinderen bouwden. ");
INSERT INTO nld1939_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Want Jahweh sprak: Zie, zij vormen één volk en spreken één taal. En dit is nog maar het begin van hun doen; later zal men niets meer kunnen beletten van al wat zij van plan zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kom, laat ons afdalen, en daar beneden hun spraak in verwarring brengen, zodat zij elkanders taal niet meer verstaan. ");
INSERT INTO nld1939_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Zo verstrooide Jahweh hen over de hele aarde, en staakten zij de bouw der stad. ");
INSERT INTO nld1939_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Daarom noemt men haar Babel, omdat Jahweh daar de spraak van de hele aarde in verwarring heeft gebracht, en omdat Jahweh hen vandaar over de hele aarde heeft verstrooid. ");
INSERT INTO nld1939_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dit is de geslachtslijst van Sem. Sem was honderd jaar oud, toen hij Arpaksad verwekte, twee jaar na de zondvloed. ");
INSERT INTO nld1939_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","En Sem leefde, nadat hij Arpaksad verwekt had, nog vijfhonderd jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad was vijf en dertig jaar oud, toen hij Sála verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksad leefde, nadat hij Sála verwekt had, nog vierhonderd drie jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sála was dertig jaar oud, toen hij Eber verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","En Sála leefde, nadat hij Eber verwekt had, nog vierhonderd drie jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber was vier en dertig jaar oud, toen hij Páleg verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber leefde, nadat hij Páleg verwekt had, nog vierhonderd dertig jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Páleg was dertig jaar, toen hij Ragaoe verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","En Páleg leefde, nadat hij Ragaoe verwekt had, nog tweehonderd negen jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ragaoe was twee en dertig jaar oud, toen hij Seroeg verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","En Ragaoe leefde, nadat hij Seroeg verwekt had, nog tweehonderd zeven jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seroeg was dertig jaar oud, toen hij Nachor verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","En Seroeg leefde, nadat hij Nachor verwekt had, nog tweehonderd jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor was negen en twintig jaar oud, toen hij Tara verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","En Nachor leefde, nadat hij Tara verwekt had, nog honderd negentien jaar, en verwekte zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tara was zeventig jaar oud, toen hij Abram, Nachor en Haran verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","En dit is de geslachtslijst van Tara. Tara verwekte Abram, Nachor en Haran. Haran verwekte Lot. ");
INSERT INTO nld1939_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran stierf nog bij het leven van Tara, zijn vader, in zijn geboorteland, in Oer der Chaldeën. ");
INSERT INTO nld1939_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram en Nachor waren beiden getrouwd. De vrouw van Abram heette Sarai; de vrouw van Nachor heette Milka, en was de dochter van Haran, den vader van Milka en Jiska. ");
INSERT INTO nld1939_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai was onvruchtbaar en had geen kinderen. ");
INSERT INTO nld1939_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tara nam zijn zoon Abram en zijn kleinzoon Lot, den zoon van Haran, en zijn schoondochter Sarai, de vrouw van zijn zoon Abram, met zich mee, en voerde ze weg uit Oer der Chaldeën, om naar het land Kanaän te trekken. Maar eenmaal in Charan gekomen, bleven zij daar wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tara werd tweehonderd vijf jaar oud, en stierf in Charan. ");
INSERT INTO nld1939_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jahweh sprak tot Abram: Trek weg uit uw land, Uit uw stam en uit het huis uws vaders Naar het land, dat Ik u tonen zal. ");
INSERT INTO nld1939_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ik zal een groot volk van u maken, U zegenen en uw naam beroemd maken, Zodat hij ten zegen zal zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ik zal zegenen, die u zegent, Vervloeken, die u vervloekt. En in u zullen alle geslachten der aarde worden gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Toen vertrok Abram, zoals Jahweh hem bevolen had, en Lot ging met hem mee; Abram was vijf en zeventig jaar oud, toen hij uit Charan wegtrok. ");
INSERT INTO nld1939_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram nam Sarai, zijn vrouw, en zijn neef Lot met zich mee, met heel hun bezit, en al de slaven, die zij in Charan hadden verworven; ze gingen op weg naar het land Kanaän, en kwamen daar aan. ");
INSERT INTO nld1939_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram trok het land door tot de plaats Sikem, en de eik van More. De Kanaänieten woonden toen nog in het land. ");
INSERT INTO nld1939_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nu verscheen Jahweh aan Abram, en sprak: Dit land zal Ik aan uw nageslacht geven. Toen bouwde hij daar een altaar ter ere van Jahweh, die hem verschenen was. ");
INSERT INTO nld1939_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Vandaar reisde hij verder naar het bergland ten oosten van Betel, en sloeg zijn tent op tussen Betel ten westen en Ai ten oosten; daar bouwde hij een altaar voor Jahweh, en riep de naam van Jahweh aan. ");
INSERT INTO nld1939_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Daarna trok Abram steeds verder naar het zuiden. ");
INSERT INTO nld1939_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Toen er in het land eens hongersnood uitbrak, zakte Abram naar Egypte af, om daar enige tijd te verblijven; want de hongersnood teisterde het land hevig. ");
INSERT INTO nld1939_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Maar op het punt Egypte binnen te trekken, zeide hij tot Sarai, zijn vrouw: Luister; ik weet, dat gij een mooie vrouw zijt. ");
INSERT INTO nld1939_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Als de Egyptenaren u zien, en denken: dat is zijn vrouw, dan zullen ze mij vermoorden, maar u in leven laten. ");
INSERT INTO nld1939_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Zeg dus, dat gij mijn zuster zijt, dan zal het mij goed gaan om wille van u, en zal ik om uwentwil gespaard blijven. ");
INSERT INTO nld1939_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Zodra Abram nu in Egypte was gekomen, zagen de Egyptenaren, hoe buitengewoon mooi die vrouw was. ");
INSERT INTO nld1939_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","En toen Farao’s hovelingen haar zagen, roemden zij haar bij Farao, met het gevolg, dat de vrouw in het paleis van Farao werd gehaald. ");
INSERT INTO nld1939_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Hij overlaadde Abram om wille van haar met weldaden, zodat hij schapen, runderen en ezels, slaven en slavinnen, ezelinnen en kamelen ontving. ");
INSERT INTO nld1939_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Maar Jahweh trof Farao en zijn huis met zware slagen naar aanleiding van Sarai, de vrouw van Abram. ");
INSERT INTO nld1939_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Toen ontbood Farao Abram, en zeide: Wat hebt ge mij daar aangedaan; waarom hebt ge mij niet meegedeeld, dat het uw vrouw is? ");
INSERT INTO nld1939_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Waarom hebt ge gezegd: het is mijn zuster; zodat ik ze mij tot vrouw heb genomen. Daar hebt ge uw vrouw terug; neem haar mee en vertrek. ");
INSERT INTO nld1939_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","En Farao gaf aan enige mannen bevel, om hem en zijn vrouw, met alles wat hem toebehoorde, uitgeleide te doen. ");
INSERT INTO nld1939_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Zo trok Abram met zijn vrouw en al zijn bezittingen uit Egypte weg, de Négeb in, en Lot met hem. ");
INSERT INTO nld1939_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram was zeer rijk aan vee, aan zilver en goud. ");
INSERT INTO nld1939_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Van de Négeb trok hij geleidelijk voort naar Betel, naar de plaats tussen Betel en Ai, waar al eerder zijn tent had gestaan, ");
INSERT INTO nld1939_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","en waar hij vroeger een altaar had gebouwd; daar riep Abram de naam van Jahweh aan. ");
INSERT INTO nld1939_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ook Lot, die met Abram was meegetrokken, bezat schapen, runderen en tenten. ");
INSERT INTO nld1939_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","De landstreek echter liet niet toe, dat zij bij elkaar bleven wonen; want hun bezittingen waren zo groot, dat zij onmogelijk bij elkaar konden blijven. ");
INSERT INTO nld1939_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Telkens rees er twist tussen de veeherders van Abram en de veeherders van Lot; bovendien woonden ook de Kanaänieten en de Perizzieten nog in die streek. ");
INSERT INTO nld1939_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Daarom zei Abram tot Lot: Laat er toch geen onenigheid zijn tussen mij en u, tussen mijn en uw herders; want we zijn toch broers van elkaar. ");
INSERT INTO nld1939_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ligt niet het hele land voor u open? Trek dus liever van mij weg; gaat gij links, dan ga ik rechts; gaat gij rechts, dan ga ik links. ");
INSERT INTO nld1939_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot sloeg zijn ogen op en zag, dat de hele Jordaanstreek overvloed van water had; voordat Jahweh Sodoma en Gomorra had verdelgd, was ze, tot Sóar toe, als de tuin van Jahweh, als het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Daarom koos Lot de hele Jordaanstreek voor zich, en trok op naar het oosten. Zo gingen ze uiteen. ");
INSERT INTO nld1939_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram bleef in het land Kanaän wonen, maar Lot vestigde zich in de steden van de Jordaanstreek, en sloeg zijn tenten op tot Sodoma toe, ");
INSERT INTO nld1939_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ofschoon de mannen van Sodoma zeer slecht waren en zwaar zondigden tegen Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jahweh sprak tot Abram, nadat Lot zich van hem gescheiden had: Sla uw ogen op, en blik van de plaats, waar ge staat Naar het noorden en zuiden, het oosten en westen. ");
INSERT INTO nld1939_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Al het land, dat ge ziet, zal Ik geven aan u En uw kroost voor altijd. ");
INSERT INTO nld1939_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ik zal uw nageslacht talrijk maken Als het stof der aarde. Als iemand het stof der aarde kan tellen, Dan zal hij ook uw geslacht kunnen tellen. ");
INSERT INTO nld1939_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sta op, doorkruis het land in zijn lengte en breedte, Want aan u zal Ik het geven! ");
INSERT INTO nld1939_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Toen brak Abram zijn tenten op, en ging te Hebron wonen bij de eik van Mamre, en bouwde daar een altaar voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Het gebeurde in die dagen, dat Amrafel de koning van Sjinar, Arjok de koning van Ellasar, Kedor-Laómer de koning van Elam, en Tidal de koning der volken, ");
INSERT INTO nld1939_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","oorlog voerden tegen Béra den koning van Sodoma, Birsja den koning van Gomorra, Sjinab den koning van Adma, Sjeméber den koning van Seboim en den koning van Béla (dat is Sóar), ");
INSERT INTO nld1939_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","en dat al deze laatsten met vereende krachten optrokken naar de vlakte van Siddim, dat is de Zoutzee. ");
INSERT INTO nld1939_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twaalf jaar lang hadden zij Kedor-Laómer gediend, maar in het dertiende jaar waren zij in opstand gekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In het veertiende jaar waren Kedor-Laómer en de koningen, die zijn bondgenoten waren, opgerukt, hadden de Refaieten bij Asjterot-Karnáim verslagen, de Zoezieten bij Ham, de Emieten in de vlakte van Kirjatáim, ");
INSERT INTO nld1939_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","en de Chorieten in het gebergte van Seïr tot aan de eik van Paran, aan de rand der woestijn. ");
INSERT INTO nld1939_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Op hun terugtocht waren zij naar En-Misjpat getrokken, dat is Kadesj, en hadden al de vorsten der Amalekieten verslagen en eveneens de Amorieten, die in Chasason-Tamar wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nu trok de koning van Sodoma op met den koning van Gomorra, den koning van Adma, den koning van Seboim en den koning van Béla (dat is Sóar), en gezamenlijk stelden zij zich in de vlakte van Siddim in slagorde ");
INSERT INTO nld1939_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","tegenover Kedor-Laómer den koning van Elam, Tidal den koning der volken, Amrafel den koning van Sjinar en Arjok den koning van Ellasar; vier koningen tegen vijf. ");
INSERT INTO nld1939_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","In de vlakte van Siddim nu waren talrijke asfaltputten; en toen de koningen van Sodoma en Gomorra moesten vluchten, sprongen zij daarin, terwijl de overigen in de bergen ontkwamen. ");
INSERT INTO nld1939_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","De vijanden maakten alle bezittingen en alle levensmiddelen van Sodoma en Gomorra buit, en trokken af; ");
INSERT INTO nld1939_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ook Lot, den zoon van Abrams broer, namen zij met al zijn have en goed op hun terugtocht mee; want hij woonde in Sodoma. ");
INSERT INTO nld1939_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Een vluchteling kwam het Abram, den Hebreër, berichten; deze woonde toen bij de eik van Mamre, den Amoriet, den broer van Esjkol en Aner, die bondgenoten waren van Abram. ");
INSERT INTO nld1939_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Toen Abram hoorde, dat zijn broer gevangen was meegevoerd, riep hij zijn beproefde mannen op, de driehonderd achttien, die in zijn huis waren geboren, zette de tot Dan achterna, ");
INSERT INTO nld1939_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","overviel ze des nachts van verschillende kanten met zijn dienaars, versloeg ze en joeg ze na tot Choba, ten noorden van Damascus. ");
INSERT INTO nld1939_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hij heroverde heel de buit, en voerde ook zijn broer Lot met zijn have, met vrouwen en manschappen terug. ");
INSERT INTO nld1939_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Toen hij nu terugkeerde van zijn overwinning op Kedor-Laómer en de koningen, die zijn bondgenoten waren, trok de koning van Sodoma hem tegemoet naar de vallei van Sjawe, dat het koningsdal is. ");
INSERT INTO nld1939_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","En Melkisédek, de koning van Salem, die priester was van den allerhoogsten God, offerde brood en wijn, ");
INSERT INTO nld1939_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","zegende hem en sprak: Gezegend zijt gij Abram, door den allerhoogsten God, Den Schepper van hemel en aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","En gezegend zij de allerhoogste God, Die uw vijanden in uw hand heeft geleverd. En Abram gaf hem de tienden van alles. ");
INSERT INTO nld1939_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nu sprak de koning van Sodoma tot Abram: Geef mij de mensen terug, dan kunt gij de goederen voor u behouden. ");
INSERT INTO nld1939_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Maar Abram zei tot den koning van Sodoma: Ik steek mijn hand tot Jahweh op, den allerhoogsten God, den Schepper van hemel en aarde: ");
INSERT INTO nld1939_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","geen draad en geen schoenriem, niets van wat u toebehoort neem ik aan, opdat gij niet zoudt kunnen zeggen: Ik heb Abram rijk gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Dat zij verre van mij! Enkel wat mijn slaven hebben verteerd, en het deel van Aner, Esjkol en Mamre, de mannen, die met mij zijn uitgetrokken: dat mogen ze als hun aandeel behouden. ");
INSERT INTO nld1939_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na deze gebeurtenissen werd in een gezicht het woord van Jahweh gericht tot Abram: Vrees niet Abram: Ik ben u tot schild; Overgroot zal uw loon zijn! ");
INSERT INTO nld1939_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Toen zei Abram: Jahweh, mijn Heer, wat kunt Gij me geven? Kinderloos ga ik heen, en Eliézer uit Damascus zal de bezitter zijn van mijn huis. ");
INSERT INTO nld1939_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","En Abram ging voort: Zie, Gij hebt mij geen nazaat gegeven, en een mijner onderhorigen zal mijn erfgenaam zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Weer werd het woord van Jahweh tot hem gericht: Deze zal uw erfgenaam niet zijn; maar die uit uw eigen lichaam wordt geboren, zal uw erfgenaam zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hij voerde hem naar buiten, en sprak: Zie op naar de hemel en tel de sterren, als ge dat kunt: zó talrijk zal uw nageslacht zijn, zeide Hij hem. ");
INSERT INTO nld1939_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Hij geloofde in Jahweh, en Deze rekende het hem tot gerechtigheid aan. ");
INSERT INTO nld1939_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Daarop sprak Hij tot hem: Ik ben Jahweh, die u uit Oer der Chaldeën heb geleid, om u dit land in eigendom te geven. ");
INSERT INTO nld1939_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hij antwoordde: Jahweh, mijn Heer, waaraan zal ik erkennen, dat ik het eens zal bezitten? ");
INSERT INTO nld1939_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Hij zeide: Breng Mij een driejarige koe en een driejarigen bok en een driejarigen ram, met een tortel en een jonge duif. ");
INSERT INTO nld1939_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Hij haalde die alle, sneed ze middendoor, en legde de stukken tegenover elkaar; maar de vogels sneed hij niet door. ");
INSERT INTO nld1939_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","En toen de roofvogels neerstreken op de dode rompen, joeg Abram ze weg. ");
INSERT INTO nld1939_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Bij het ondergaan der zon werd Abram door een diepe slaap overvallen, en een sombere, geweldige angst greep hem aan. ");
INSERT INTO nld1939_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Toen sprak Hij tot Abram: Weet wel, dat uw nakomelingen als vreemden in een land zullen toeven, dat hun niet toebehoort. Zij zullen daar als slaven dienen, en men zal hen vierhonderd jaar lang verdrukken. ");
INSERT INTO nld1939_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Maar van het volk, dat zij als slaven dienen, zal Ik rekenschap eisen; en daarna zullen zij uittrekken met rijke buit. ");
INSERT INTO nld1939_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Gij zelf zult in vrede tot uw vaderen gaan, en in hoge ouderdom worden begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eerst het vierde geslacht zal hier terugkeren; want eerder is de maat van de misdaden der Amorieten niet vol. ");
INSERT INTO nld1939_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","En toen de zon was ondergegaan, en er een diepe duisternis heerste, verscheen er een rokende oven en een brandende fakkel; deze gingen tussen die stukken door. ");
INSERT INTO nld1939_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Op die dag sloot Jahweh met Abram het volgend verbond: Aan uw nakomelingschap geef Ik dit land in bezit van de beek van Egypte af tot aan de grote rivier de Eufraat; ");
INSERT INTO nld1939_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","met de Kenieten, Kenizzieten en Kadmonieten, ");
INSERT INTO nld1939_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","de Chittieten, Perizzieten en Refaieten, ");
INSERT INTO nld1939_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","de Amorieten, Kanaänieten, Girgasjieten en Jeboesieten. ");
INSERT INTO nld1939_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, de vrouw van Abram, had hem geen kinderen geschonken. Maar zij had een egyptische slavin, Hagar genaamd. ");
INSERT INTO nld1939_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","En Sarai zeide tot Abram: Zie, Jahweh heeft mijn schoot gesloten; ga dus tot mijn slavin: misschien krijg ik kinderen van haar. Abram stemde met Sarai in. ");
INSERT INTO nld1939_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","En Sarai, Abrams vrouw, nam Hagar, haar egyptische slavin, en gaf ze tot vrouw aan Abram, haar man; Abram woonde toen al tien jaar in het land Kanaän. ");
INSERT INTO nld1939_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Hij hield gemeenschap met Hagar, en zij werd zwanger. Toen zij bemerkte, dat zij zwanger was, zag zij minachtend op haar meesteres neer. ");
INSERT INTO nld1939_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Daarom sprak Sarai tot Abram: Gij zijt de schuld van mijn smaad. Ik zelf heb mijn slavin in uw schoot gelegd, en nu zij ziet, dat ze zwanger is, veracht ze mij. Moge Jahweh richten tussen mij en u. ");
INSERT INTO nld1939_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram gaf Sarai ten antwoord: Welnu, uw slavin is in uw macht; doe met haar wat ge wilt. Toen begon Sarai haar te kwellen, zodat zij de vlucht voor haar nam. ");
INSERT INTO nld1939_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","De engel van Jahweh trof haar bij een waterbron in de woestijn, bij de bron aan de weg naar Sjoer. ");
INSERT INTO nld1939_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Hij sprak: Hagar, dienstmaagd van Sarai, waar komt ge vandaan, en waar gaat ge heen? Zij zeide: Ik ben op de vlucht voor Sarai, mijn meesteres. ");
INSERT INTO nld1939_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","De engel van Jahweh sprak toen tot haar: Keer terug naar uw meesteres, en verneder u voor haar. ");
INSERT INTO nld1939_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","En de engel van Jahweh ging voort: Uw kroost zal Ik zó talrijk maken, dat men het om zijn menigte niet meer kan tellen. ");
INSERT INTO nld1939_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nog sprak de engel van Jahweh tot haar: Zie, ge zijt zwanger; een zoon zult ge baren, En hem de naam van Jisjmaël geven; Want Jahweh heeft naar uw schreien gehoord. ");
INSERT INTO nld1939_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hij zal een menselijke woudezel zijn, Zijn hand zal tegen allen wezen, En de hand van allen tegen hem; Verwijderd van al zijn broers zal hij wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Toen noemde zij Jahweh, die met haar had gesproken: “Gij zijt een God, dien ik zie”. Want ze zeide: Waarachtig, ik heb God gezien; en ik leef nog, nadat ik gezien heb. ");
INSERT INTO nld1939_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Die put heet daarom de put Lachai-Roï; hij ligt tussen Kadesj en Béred. ");
INSERT INTO nld1939_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Zo schonk Hagar aan Abram een zoon, en Abram noemde den zoon, dien Hagar hem baarde, Jisjmaël. ");
INSERT INTO nld1939_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was zes en tachtig jaar oud, toen Hagar hem Jisjmaël baarde. ");
INSERT INTO nld1939_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Toen Abram negen en negentig jaar oud was, verscheen Jahweh hem, en sprak tot hem: Ik ben God, de Almachtige: Wandel voor mijn aanschijn, en wees volmaakt! ");
INSERT INTO nld1939_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Dan zal Ik mijn Verbond sluiten tussen Mij en u, En u talrijk maken uitermate. ");
INSERT INTO nld1939_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Toen viel Abram op zijn aangezicht neer, en God sprak tot hem: ");
INSERT INTO nld1939_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Zie, dat is van mijn kant het Verbond met u: Gij zult de vader worden van een menigte volken! ");
INSERT INTO nld1939_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Niet langer zal men u Abram noemen, Maar uw naam zal Abraham zijn: Want Ik maak u tot vader van een menigte volken. ");
INSERT INTO nld1939_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Zeer vruchtbaar zal Ik u maken: Ik zal u tot volken doen groeien, En koningen zullen uit u voortspruiten. ");
INSERT INTO nld1939_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ik zal mijn Verbond gestand doen tussen Mij en u, En uw zaad na u, Van geslacht tot geslacht, als een eeuwig Verbond: Uw God zal Ik zijn, en van uw kroost na u! ");
INSERT INTO nld1939_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ik schenk u, en uw zaad na u Het land, waar ge thans als vreemdeling toeft, Het hele land Kanaän, tot een eeuwig bezit: Hun God zal Ik zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nog sprak God tot Abraham: Maar gij van úw kant moet mijn Verbond onderhouden, Gij en uw nazaat van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dit is mijn Verbond, dat gij moet onderhouden, Tussen Mij en tussen u, en uw kinderen na u: Al wat man onder u is, moet worden besneden, ");
INSERT INTO nld1939_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Het vlees van uw voorhuid moet ge laten besnijden: Dat zal het teken zijn van het Verbond Tussen Mij en tussen u. ");
INSERT INTO nld1939_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ieder mannelijk kind onder u, dat acht dagen oud is, Moet worden besneden, van geslacht tot geslacht; Ook de slaaf, die in uw huis is geboren, Of van vreemden voor geld is gekocht, En niet tot uw nazaten hoort: ");
INSERT INTO nld1939_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ook zij moeten worden besneden, Die in uw huis zijn geboren, Of voor geld zijn gekocht. Zo zal mijn verbond in uw vlees Tot een eeuwig Verbond zijn! ");
INSERT INTO nld1939_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Maar de man, die onbesneden zal zijn, Wien het vlees van de voorhuid niet is besneden, Die man zal uitgeroeid worden uit zijn volk, Omdat hij mijn Verbond heeft verbroken. ");
INSERT INTO nld1939_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nog sprak God tot Abraham: Sarai, uw vrouw, zal geen Sarai meer heten, Maar Sara zal zij worden genoemd. ");
INSERT INTO nld1939_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ik zal haar zegenen, En ook uit háár een zoon u schenken; Haar zegenen, zodat zij tot volken zal worden, En koningen van volken uit haar zullen voortspruiten! ");
INSERT INTO nld1939_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Toen viel Abraham op zijn aangezicht neer, en lachte; want hij dacht bij zich zelf: kan dan een honderdjarige nog een zoon worden geboren, en kan Sara nog baren, ofschoon zij negentig jaar oud is? ");
INSERT INTO nld1939_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Daarom zei Abraham tot God: Moge Jisjmaël voor uw aanschijn leven. ");
INSERT INTO nld1939_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Toen sprak God: Neen: Sara uw vrouw zal u een zoon baren, En Isaäk zult ge hem noemen. Met hem zal Ik mijn Verbond gestand doen voor eeuwig: Zijn God zal Ik zijn, en van zijn kinderen na hem. ");
INSERT INTO nld1939_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ook aangaande Jisjmaël heb Ik u verhoord: Ik zal hem zegenen, vruchtbaar maken, zeer talrijk doen zijn: Twaalf vorsten zal hij verwekken, En een groot volk zal Ik hem maken. ");
INSERT INTO nld1939_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maar mijn Verbond doe Ik aan Isaäk gestand, Dien Sara u zal baren op deze tijd van het volgende jaar. ");
INSERT INTO nld1939_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Toen brak God zijn gesprek met hem af, en steeg op van Abraham weg. ");
INSERT INTO nld1939_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nu nam Abraham zijn zoon Jisjmaël, en alle mannelijke huisgenoten, die bij hem in huis waren geboren of die hij voor geld had gekocht, en besneed nog op diezelfde dag het vlees van hun voorhuid, zoals God hem gezegd had. ");
INSERT INTO nld1939_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was negen en negentig jaar oud, toen zijn voorhuid besneden werd; ");
INSERT INTO nld1939_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","zijn zoon Jisjmaël was dertien jaar oud, toen zijn voorhuid besneden werd. ");
INSERT INTO nld1939_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Op dezelfde dag werden Abraham en zijn zoon Jisjmaël besneden; ");
INSERT INTO nld1939_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","en al de mannelijke huisgenoten, die in zijn huis waren geboren of die hij van vreemden voor geld had gekocht, werden met hem besneden. ");
INSERT INTO nld1939_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Daarna verscheen Jahweh hem bij de eik van Mamre. Eens, toen hij op een hete middag in de opening van zijn tent zat, ");
INSERT INTO nld1939_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","en zijn ogen opsloeg, zag hij drie mannen voor zich staan. Zodra hij ze zag, liep hij ze van de tentingang tegemoet, boog zich ter aarde, ");
INSERT INTO nld1939_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","en sprak: Heer; als ik genade gevonden heb in uw ogen, ga dan uw dienaar niet voorbij. ");
INSERT INTO nld1939_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Sta mij toe, wat water te laten brengen; dan kunt Gij u de voeten wassen, en uitrusten onder de boom. ");
INSERT INTO nld1939_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ik zal ook een stuk brood laten halen, om u wat te verkwikken, eer ge verder trekt; gij zijt nu toch langs uw dienaar gekomen. Zij zeiden: Doe, wat ge zegt. ");
INSERT INTO nld1939_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Vlug ging Abraham zijn tent binnen, naar Sara, en sprak: Neem gauw drie maten fijne bloem, kneed ze en bak er broodkoeken van. ");
INSERT INTO nld1939_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Zelf liep Abraham naar de kudde, om een mals en mooi kalf te halen; hij gaf het aan zijn knecht, die zich haastte, het klaar te maken. ");
INSERT INTO nld1939_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Dan nam hij room en melk met het kalf, dat hij had laten toebereiden, en diende het op; terwijl zij aten, bleef hij zelf bij hen onder de boom staan. ");
INSERT INTO nld1939_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nu zeiden zij hem: Waar is Sara, uw vrouw? Hij antwoordde: Hier in de tent. ");
INSERT INTO nld1939_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Toen zeide Hij: Als Ik over een jaar om deze tijd bij u terugkom, zal uw vrouw Sara een zoon hebben. Sara stond achter hem te luisteren bij de opening van de tent. ");
INSERT INTO nld1939_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nu waren Abraham en Sara beiden oud en hoogbejaard, en het ging Sara niet meer naar de wijze der vrouwen. ");
INSERT INTO nld1939_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Daarom moest Sara heimelijk lachen, en dacht: Zal er dan nog liefdegenot voor mij zijn, nu ik zelf verwelkt ben, en ook mijn heer al oud is! ");
INSERT INTO nld1939_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Maar Jahweh sprak tot Abraham: Waarom lacht Sara toch, en denkt ze: zal ik dan werkelijk nog baren op mijn oude dag? ");
INSERT INTO nld1939_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is er dan iets te moeilijk voor Jahweh? Over een jaar om deze tijd kom Ik bij u terug, en dan heeft Sara een zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara ontkende het in haar angst, en zei: Ik heb niet gelachen. Maar Hij sprak: Ge hebt wèl gelachen. ");
INSERT INTO nld1939_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Daarop stonden de mannen op, en namen de richting van Sodoma, terwijl Abraham mee ging, om ze uitgeleide te doen. ");
INSERT INTO nld1939_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Toen dacht Jahweh bij Zichzelf: Waarom zou Ik voor Abraham geheim houden, wat Ik ga doen? ");
INSERT INTO nld1939_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Want Abraham zal zeker een groot en machtig volk worden, en alle volken der aarde zullen in hem worden gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Daarom juist heb Ik hem uitverkoren, opdat hij aan zijn zonen en zijn nageslacht zou bevelen, de weg van Jahweh te bewaren door gerechtigheid en recht te beoefenen; en Jahweh dus aan Abraham vervullen kan, wat Hij hem heeft beloofd. ");
INSERT INTO nld1939_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Daarom sprak Jahweh: Luid schreit het wraakgeroep over Sodoma en Gomorra, en hun zonde is buitengewoon zwaar. ");
INSERT INTO nld1939_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ik wil er heen, om te zien, of zij zich werkelijk zo gedragen, als het wraakgeroep klinkt, dat tot Mij is doorgedrongen; Ik wil Mij ervan op de hoogte stellen. ");
INSERT INTO nld1939_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Maar toen de mannen vandaar de weg naar Sodoma wilden inslaan, bleef Abraham voor Jahweh staan, ");
INSERT INTO nld1939_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","trad nader, en sprak: Zult Gij nu werkelijk den goede met den kwade verdelgen? ");
INSERT INTO nld1939_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Misschien dat er toch vijftig rechtvaardigen in de stad worden gevonden; zoudt Gij de plaats dan verdelgen, of zoudt Gij haar niet liever vergiffenis schenken om die vijftig rechtvaardigen, die er worden gevonden? ");
INSERT INTO nld1939_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Het zij verre van U, zo te handelen, en de goeden met de kwaden te doden, zodat het den rechtvaardige vergaat als den boze. Neen, dat zij verre van U! Zou Hij, die heel de aarde richt, geen recht laten gelden? ");
INSERT INTO nld1939_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jahweh sprak: Als Ik vijftig rechtvaardigen in de stad Sodoma vind, dan zal Ik de hele plaats om hunnentwil vergiffenis schenken. ");
INSERT INTO nld1939_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham hernam: Zie, ik waag het, tot mijn Heer te spreken, ofschoon ik maar stof ben en as. ");
INSERT INTO nld1939_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Misschien ontbreken er aan de vijftig rechtvaardigen vijf; zoudt Gij dan toch om die vijf de hele stad verdelgen? Hij sprak: Ik zal ze niet verdelgen, als Ik er maar vijf en veertig vind. ");
INSERT INTO nld1939_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nu ging hij voort: Misschien worden er veertig gevonden? Hij sprak: Dan zal Ik het niet doen om wille van die veertig. ");
INSERT INTO nld1939_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Nu zeide hij weer: Laat mijn Heer nu niet toornig worden, als ik blijf spreken; misschien worden er maar dertig gevonden. Hij sprak: Ik zal het niet doen, als Ik er dertig vind. ");
INSERT INTO nld1939_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hij zeide opnieuw: Zie, ik heb het nu toch al gewaagd, tot mijn Heer te spreken; misschien dat er twintig worden gevonden. Hij sprak: Ik zal ze niet verdelgen om wille van die twintig. ");
INSERT INTO nld1939_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hij hield aan: Laat mijn Heer niet toornig worden, als ik nu nog één keer spreek; misschien worden er maar tien gevonden. Hij zeide: Ik zal ze niet verdelgen om die tien. ");
INSERT INTO nld1939_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Toen Jahweh het gesprek met Abraham had beëindigd, ging Hij heen, en keerde Abraham naar zijn woonplaats terug. ");
INSERT INTO nld1939_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","De beide engelen kwamen tegen de avond te Sodoma aan, terwijl Lot juist in de poort van Sodoma was gezeten. Toen Lot hen zag, stond hij op, ging ze tegemoet, boog zich neer met zijn gezicht tegen de grond, ");
INSERT INTO nld1939_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","en zeide: Ik bid u, mijne heren; neemt toch uw intrek in het huis van uw dienaar, om daar te overnachten, en uw voeten te wassen; dan kunt ge morgenvroeg uw reis vervolgen. Zij gaven ten antwoord: Neen, we zullen liever op straat overnachten. ");
INSERT INTO nld1939_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Maar hij nodigde hen zó dringend uit, dat zij naar zijn huis gingen, en hun intrek bij hem namen. Hij richtte een maaltijd voor hen aan, liet ongedesemde broden bakken, en zij aten. ");
INSERT INTO nld1939_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nog hadden ze zich niet ter ruste gelegd, of de mannen van de stad omringden het huis: de mannen van Sodoma, jong en oud, het hele volk tot den laatste toe. ");
INSERT INTO nld1939_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Zij riepen tot Lot: Waar zijn de mannen, die vanavond bij u gekomen zijn? Breng ze naar buiten bij ons, opdat wij er omgang mee hebben. ");
INSERT INTO nld1939_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ging naar buiten naar hen toe, maar sloot de deur achter zich dicht. ");
INSERT INTO nld1939_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","En hij sprak: Broeders, dat kwaad moet ge niet doen. ");
INSERT INTO nld1939_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Luistert eens: ik heb twee dochters, die nog nooit bij een man zijn geweest; die wil ik naar buiten tot u brengen, en ge kunt met haar doen, wat ge wilt. Maar deze mannen moogt ge niets doen; want zij staan onder de schutse van mijn dak. ");
INSERT INTO nld1939_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Zij schreeuwden: Ruk in! Die komt hier als vreemdeling, en wil ons de les lezen. We konden je nog wel eens erger krijgen dan die anderen! Onstuimig drongen ze op tegen den man Lot, en kwamen al dichter en dichter bij, om de deur open te breken. ");
INSERT INTO nld1939_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Toen staken de mannen hun hand uit, trokken Lot naar zich toe, het huis in, en sloten de deur; ");
INSERT INTO nld1939_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","en de mannen, die voor de huisdeur stonden, klein en groot, sloegen zij met verblinding, zodat zij de ingang niet konden vinden. ");
INSERT INTO nld1939_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nu zeiden de mannen tot Lot: Wie ge nog hier hebt: uw schoonzoon, uw zonen en dochters en al de uwen hier in de stad, breng ze hier vandaan. ");
INSERT INTO nld1939_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Waarachtig, we gaan deze plaats verdelgen, want het wraakgeroep over hen schreit luid bij Jahweh; Jahweh heeft ons gezonden, om haar te vernielen. ");
INSERT INTO nld1939_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot ging naar buiten, om met zijn schoonzoons te spreken, die met zijn dochters waren verloofd; en hij zeide: Staat op, trekt gauw hier vandaan; want Jahweh gaat de stad verdelgen. Doch die schoonzoons dachten, dat hij maar schertste. ");
INSERT INTO nld1939_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Maar toen de dageraad aanbrak, drongen de engelen bij Lot aan, en zeiden: Vlug; neem uw vrouw en uw beide dochters mee, die bij u in huis zijn; anders komt ge nog om bij de bestraffing van de stad. ");
INSERT INTO nld1939_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","En toen hij nog talmde, namen de mannen hem, zijn vrouw en zijn twee dochters bij de hand, en brachten hem in veiligheid buiten de stad, omdat Jahweh hem wilde sparen. ");
INSERT INTO nld1939_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","En toen zij hen buiten hadden gebracht, zeiden zij: Vlucht, want het gaat om uw leven; kijk niet om, blijf nergens in de buurt staan, maar vlucht naar de bergen, als ge niet mee wilt omkomen. ");
INSERT INTO nld1939_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Maar Lot zeide tot hen: Och neen, Heer. ");
INSERT INTO nld1939_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Zie, uw dienaar heeft genade gevonden in uw ogen, en gij hebt me reeds grote barmhartigheid bewezen, door mijn leven te redden; het is mij onmogelijk, het gebergte nog te bereiken, eer het onheil mij achterhaalt, en ik sterf. ");
INSERT INTO nld1939_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Zie, het gindse stadje is genoeg dichtbij, om daarheen te vluchten. Het is toch zo klein. Laat me nu daarheen vluchten, en mijn leven behouden. Ach, het is toch zo klein! ");
INSERT INTO nld1939_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Hij sprak tot hem: Ook deze bede van u heb ik verhoord; het stadje, dat ge bedoelt, zal ik niet verwoesten. ");
INSERT INTO nld1939_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Vlucht er nu haastig heen; want ik kan niets beginnen, eer ge daar zijt aangekomen. Daarom wordt die stad Sóar genoemd. ");
INSERT INTO nld1939_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Toen de zon over de aarde was opgegaan, en Lot te Sóar was aangekomen, ");
INSERT INTO nld1939_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","liet Jahweh zwavel en vuur van Jahweh uit de hemel regenen over Sodoma en Gomorra. ");
INSERT INTO nld1939_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hij vernietigde die steden en de hele streek tot de grond toe, met al de bewoners van die steden en al wat op de akkers stond. ");
INSERT INTO nld1939_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","De vrouw van Lot, die achter hem aanliep, keek om, en werd in een zoutklomp veranderd. ");
INSERT INTO nld1939_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Vroeg in de morgen begaf Abraham zich naar de plaats, waar hij voor het aanschijn van Jahweh had gestaan. ");
INSERT INTO nld1939_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Toen hij in de richting van Sodoma en Gomorra en het hele land in de omtrek keek, zag hij een walm van de aarde opstijgen als de rook van een smeltoven. ");
INSERT INTO nld1939_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Zo was God Abraham indachtig, toen Hij de steden van die streek verwoestte, en liet Hij ook Lot aan de verdelging ontkomen, waarmede Hij de steden trof, waarin Lot had gewoond. ");
INSERT INTO nld1939_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Daar Lot niet in Sóar durfde blijven, trok hij uit Sóar weg, ging met zijn twee dochters in het gebergte wonen, en huisde met zijn beide dochters in een grot. ");
INSERT INTO nld1939_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nu zeide de oudste tot de jongste: Onze vader wordt oud, en er is geen man in het land, om op de gebruikelijke manier gemeenschap met ons te houden. ");
INSERT INTO nld1939_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, we moeten onzen vader wijn laten drinken, en bij hem gaan slapen; dan zullen we tenminste van onzen vader kroost verwekken. ");
INSERT INTO nld1939_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Zij gaven haar vader die avond dan wijn te drinken, en de oudste ging bij haar vader liggen; maar hij was er zich niet van bewust, noch dat ze ging liggen, noch dat ze opstond. ");
INSERT INTO nld1939_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","De volgende morgen zei de oudste tot de jongste: Zie, ik heb vannacht bij vader geslapen; laten wij hem vanavond weer wijn geven, en dan moet gij bij hem slapen; dan zullen we van onzen vader kroost verwekken. ");
INSERT INTO nld1939_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ook die avond gaven ze haar vader wijn te drinken, en nu ging de jongste bij hem liggen; maar hij was er zich niet van bewust, noch dat ze ging liggen, noch dat ze opstond. ");
INSERT INTO nld1939_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Zo werden de beide dochters van Lot zwanger van haar vader. ");
INSERT INTO nld1939_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","De oudste baarde een zoon, en noemde hem Moab; hij werd de vader der tegenwoordige Moabieten. ");
INSERT INTO nld1939_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ook de jongste baarde een zoon, en noemde hem Ben-Ammi; hij is de vader der tegenwoordige Ammonieten. ");
INSERT INTO nld1939_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham trok vandaar de Négeb in, en vestigde zich tussen Kadesj en Sjoer. Zolang Abraham in Gerar verbleef, ");
INSERT INTO nld1939_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","vertelde hij van zijn vrouw Sara, dat ze zijn zuster was; zo liet Abimélek, de koning van Gerar, Sara schaken. ");
INSERT INTO nld1939_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Maar God verscheen Abimélek des nachts in een droom, en sprak tot hem: Zie, ge zult sterven, omdat ge die vrouw hebt geschaakt; want ze is al gehuwd. ");
INSERT INTO nld1939_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimélek, die haar nog niet was genaderd, sprak: Heer, zoudt Gij dan een rechtschapen man willen doden? ");
INSERT INTO nld1939_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Heeft hij mij niet gezegd: Het is mijn zuster; en heeft ook zij zelf niet gezegd: Het is mijn broer? Met onschuldig hart en reine handen heb ik dit gedaan. ");
INSERT INTO nld1939_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","En God sprak tot hem in de droom: Omdat Ik wist, dat gij dit met onschuldig hart hebt gedaan, heb Ik er u voor bewaard, tegen Mij te zondigen, en u daarom belet, haar aan te raken. ");
INSERT INTO nld1939_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Geef nu de vrouw van dien man terug; want hij is een profeet. Hij zal voor u bidden, en ge zult blijven leven; maar als ge haar niet terugzendt, weet dan, dat ge zeker zult sterven, gij en al de uwen: ");
INSERT INTO nld1939_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","De volgende morgen riep Abimélek al zijn dienaren bijeen, en deelde hun de hele toedracht mee; zijn mannen schrokken er geweldig van. ");
INSERT INTO nld1939_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nu liet Abimélek Abraham roepen, en zei hem: Wat hebt ge ons aangedaan? Wat heb ik tegen u misdreven, dat gij op mij en op mijn koninkrijk zo’n zware schuld hebt geladen. Ge hebt met mij iets gedaan, wat nog nooit is voorgekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","En Abimélek vervolgde tot Abraham: Wat was eigenlijk uw bedoeling, toen ge dat deedt? ");
INSERT INTO nld1939_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham antwoordde: Ik dacht, er mocht eens in deze stad volstrekt geen vrees voor God worden gevonden; dan zou men er mij om mijn vrouw vermoorden. ");
INSERT INTO nld1939_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Trouwens ze is ook werkelijk mijn zuster: de dochter van mijn vader, maar niet van mijn moeder; zo is ze mijn vrouw geworden. ");
INSERT INTO nld1939_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","En toen God mijn rondzwervingen ver van mijn vaderlijk huis liet beginnen, zei ik tot haar: Ge moet me deze liefdedienst bewijzen: overal waar we komen, moet ge van mij vertellen: hij is mijn broer. ");
INSERT INTO nld1939_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Toen liet Abimélek schapen en runderen, slaven en slavinnen halen, gaf ze Abraham ten geschenke, en zond hem ook zijn vrouw Sara terug. ");
INSERT INTO nld1939_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimélek sprak bovendien: Zie, mijn land ligt voor u open; ga wonen, waar het u bevalt. ");
INSERT INTO nld1939_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","En tot Sara zeide hij: Ziehier, ik geef duizend zilverstukken aan uw broer; dat zal in de ogen van al de uwen een vergoeding voor u zijn; en dan hebt ge in alles voldoening gekregen. ");
INSERT INTO nld1939_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nu bad Abraham tot God; en God genas Abimélek, zijn vrouw en zijn slavinnen, zodat zij kinderen konden krijgen. ");
INSERT INTO nld1939_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Want Jahweh had iedere schoot van Abiméleks huis gesloten om Sara, de vrouw van Abraham. ");
INSERT INTO nld1939_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","En Jahweh trok Zich Sara aan, zoals Hij gezegd had; Jahweh deed Sara zijn belofte gestand. ");
INSERT INTO nld1939_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Zij werd zwanger, en schonk Abraham op zijn oude dag een zoon, juist op de tijd, die God had voorzegd. ");
INSERT INTO nld1939_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham noemde den zoon, die hem was geboren, en dien Sara hem geschonken had, Isaäk. ");
INSERT INTO nld1939_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","En Abraham besneed zijn zoon Isaäk, toen hij acht dagen oud was, zoals God hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was bij de geboorte van zijn zoon Isaäk honderd jaar oud. ");
INSERT INTO nld1939_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara zeide: God heeft mij reden tot lachen gegeven; en ook iedereen, die het hoort, zal lachen. ");
INSERT INTO nld1939_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","En zij zeide: Wie had tot Abraham durven zeggen: Sara zal nog kinderen voeden? Toch heb ik een zoon gebaard op zijn oude dag. ");
INSERT INTO nld1939_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Het kind groeide op, en werd aan de borst ontwend; en toen Isaäk van de borst werd afgenomen, richtte Abraham een groot feestmaal aan. ");
INSERT INTO nld1939_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Maar toen Sara den zoon, dien Hagar de Egyptische aan Abraham geschonken had, haar eigen zoon Isaäk zag uitlachen, ");
INSERT INTO nld1939_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","sprak ze tot Abraham: Jaag die slavin met haar zoon weg; want de zoon van die slavin mag geen erfgenaam worden met mijn zoon Isaäk. ");
INSERT INTO nld1939_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dit woord verdroot Abraham om zijn zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maar God sprak: Wees niet verdrietig om den knaap en om uw slavin. Willig alles in, wat Sara u zegt; want alleen wat van Isaäk afstamt, zal uw nakomelingschap worden genoemd. ");
INSERT INTO nld1939_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Toch zal Ik ook van den zoon der slavin een volk maken, omdat hij uw kind is. ");
INSERT INTO nld1939_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Daarom nam Abraham de volgende morgen brood en een zak water, gaf ze aan Hagar, zette het kind op haar schouder, en zond haar weg. Zij ging heen, maar verdwaalde in de woestijn van Beër-Sjéba. ");
INSERT INTO nld1939_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Toen het water uit de zak op was, legde zij den jongen onder een der struiken neer. ");
INSERT INTO nld1939_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Zelf ging zij op een boogschot afstand daar tegenover zitten; want ze zei: Ik kan het kind niet zien sterven. En terwijl ze zo tegenover hem zat, begon ze hardop te snikken. ");
INSERT INTO nld1939_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God hoorde ook den knaap schreien; en de engel van God riep uit de hemel tot Hagar, en zeide tot haar: Wat is er toch Hagar? Wees maar niet bang; want God heeft het schreien van den jongen gehoord; dat betekent immers zijn naam. ");
INSERT INTO nld1939_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Sta op, neem den knaap op, en houd hem goed vast; want Ik zal een groot volk van hem maken. ");
INSERT INTO nld1939_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Toen opende God haar ogen, zodat zij een waterput zag; zij ging de zak met water vullen, en gaf den jongen te drinken. ");
INSERT INTO nld1939_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","En God was met den knaap. Toen hij groot was geworden, vestigde hij zich in de woestijn, en werd een boogschutter. ");
INSERT INTO nld1939_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Hij woonde in de woestijn van Paran, en zijn moeder nam hem een vrouw uit het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Het was ongeveer in dezelfde tijd, dat Abimélek en zijn legerhoofd Pikol tot Abraham zeiden: God is met u bij al wat ge doet. ");
INSERT INTO nld1939_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Zweer mij hier dus bij God, dat ge mij, noch mijn geslacht en mijn stam, ontrouw zult worden; maar dat ge mij en het land, waarin ge als gast verblijft, dezelfde vriendschap zult bewijzen, als ik u heb getoond. ");
INSERT INTO nld1939_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","En Abraham zeide: Ik zweer het. ");
INSERT INTO nld1939_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Maar tegelijk deed Abraham bij Abimélek zijn beklag, dat de knechten van Abimélek zich met geweld van zijn waterput hadden meester gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimélek zeide: Ik weet niet, wie dat gedaan heeft; ge hebt er mij ook nooit van gesproken, en ik heb er tot nu toe niets van gehoord. ");
INSERT INTO nld1939_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Daarop haalde Abraham schapen en runderen, gaf ze aan Abimélek ten geschenke, en zij sloten een verbond met elkander. ");
INSERT INTO nld1939_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Toen Abraham zeven lammetjes had afgezonderd, ");
INSERT INTO nld1939_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","zei Abimélek tot Abraham: Wat betekenen die zeven lammetjes, die ge afgezonderd houdt? ");
INSERT INTO nld1939_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hij antwoordde: Zeven lammetjes moet ge van mij aannemen; dit zal mij tot getuigenis dienen, dat ik die put heb gegraven. ");
INSERT INTO nld1939_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daarom wordt die plaats Beër-Sjéba genoemd, omdat zij daar beiden een eed hebben gezworen. ");
INSERT INTO nld1939_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","En nadat zij dus een verbond te Beër-Sjéba hadden gesloten, brak Abimélek met zijn legeroverste Pikol op, en keerde naar het land der Filistijnen terug. ");
INSERT INTO nld1939_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham plantte een tamarisk te Beër-Sjéba, en riep daar de naam van Jahweh aan, den eeuwigen God. ");
INSERT INTO nld1939_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nog lang bleef hij in het land der Filistijnen wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Enige tijd later stelde God Abraham op de proef. Hij sprak tot hem: Abraham! Deze antwoordde: Hier ben ik. ");
INSERT INTO nld1939_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Hij sprak: Neem Isaäk, uw enigen zoon, dien ge liefhebt, ga naar het land van de Moria, en offer hem daar als brandoffer op een van de bergen, die Ik u aanwijs. ");
INSERT INTO nld1939_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","De volgende morgen zadelde Abraham zijn ezel, ontbood twee van zijn knechten en zijn zoon Isaäk, en kloofde brandhout voor het offer. Toen trok hij op, en ging naar de plaats, die God hem genoemd had. ");
INSERT INTO nld1939_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","De derde dag sloeg Abraham zijn ogen op, en zag de plaats in de verte. ");
INSERT INTO nld1939_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nu sprak Abraham tot zijn knechten: Blijft hier met den ezel; ik en de jongen gaan daarheen, om te aanbidden; daarna keren we tot u terug. ");
INSERT INTO nld1939_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Daarop nam Abraham het hout voor het offer, en gaf het zijn zoon Isaäk te dragen; zelf droeg hij het vuur en het mes. Zo gingen ze samen op weg. ");
INSERT INTO nld1939_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Maar Isaäk zei tot zijn vader Abraham: Vader! Hij antwoordde: Wat is er, mijn jongen? Hij zeide: Zie, we hebben wel vuur en offerhout, maar waar is het schaap voor het offer? ");
INSERT INTO nld1939_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham antwoordde: God zelf zal wel voor het offerschaap zorgen, mijn kind. En samen gingen ze verder. ");
INSERT INTO nld1939_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Toen zij aan de plaats waren gekomen, die God hem genoemd had, bouwde Abraham daar een altaar, en stapelde het hout op. Dan bond hij zijn zoon Isaäk, en legde hem op het altaar boven op het hout. ");
INSERT INTO nld1939_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","En Abraham strekte zijn hand uit, om het mes te grijpen, en zijn zoon te doden. ");
INSERT INTO nld1939_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Daar riep de engel van Jahweh uit de hemel hem toe, en sprak: Abraham, Abraham! Hij zeide: Hier ben ik. ");
INSERT INTO nld1939_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Hij sprak: Sla uw hand niet aan den knaap, en doe hem geen kwaad. Want nu weet Ik, dat gij God vreest; want ge hebt Mij uw enigen zoon niet willen onthouden. ");
INSERT INTO nld1939_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Nu sloeg Abraham zijn ogen op, en zag een ram, die met zijn horens in het struikgewas zat verward; Abraham greep den ram, en droeg hem als brandoffer op, in plaats van zijn zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham gaf die plaats de naam: “Jahweh draagt zorg”, daarom wordt ook nu nog gezegd: “op de berg van Jahweh wordt zorg gedragen”. ");
INSERT INTO nld1939_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Voor de tweede maal riep de engel van Jahweh Abraham uit de hemel toe, ");
INSERT INTO nld1939_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","en sprak: Ik zweer bij Mijzelf, Luidt de godsspraak van Jahweh! Omdat ge dit hebt gedaan, En uw enigen zoon niet gespaard hebt: ");
INSERT INTO nld1939_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Daarom zal Ik u zegenen, En uw nageslacht talrijk maken als de sterren aan de hemel, En als het zand aan het strand van de zee; Uw kroost zal de poorten van zijn vijanden bezitten. ");
INSERT INTO nld1939_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","In uw zaad zullen alle volken der aarde worden gezegend, Omdat gij naar mijn stem hebt gehoord. ");
INSERT INTO nld1939_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Toen keerde Abraham terug naar zijn knechten; zij trokken op, en gingen naar Beër-Sjéba terug. Abraham bleef te Beër-Sjéba wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Enige tijd later berichtte men Abraham: Ook Milka heeft uw broer Nachor zonen geschonken. ");
INSERT INTO nld1939_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Het waren Oes zijn eerstgeborene, en Boez zijn broer; verder Kemoeël, de vader van Aram, ");
INSERT INTO nld1939_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","en Késed, Chazo, Pildasj, Jidlaf en Betoeël. ");
INSERT INTO nld1939_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Deze Betoeël verwekte Rebekka. Deze acht baarde Milka aan Nachor, den broer van Abraham. ");
INSERT INTO nld1939_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","En zijn bijvrouw, die Reoema heette, baarde Tébach en Gácham, Táchasj en Maäka. ");
INSERT INTO nld1939_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Toen Sara honderd zeven en twintig jaren oud was (dat was de leeftijd van Sara), ");
INSERT INTO nld1939_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","stierf Sara te Kirjat-Arba, nu Hebron genoemd, in het land Kanaän. En nadat Abraham lijkklacht over Sara had gehouden, en haar had beweend, ");
INSERT INTO nld1939_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","verliet Abraham zijn afgestorvene, om met de zonen van Chet te gaan spreken. ");
INSERT INTO nld1939_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Hij zeide: Ik leef maar als gast en vreemde bij u; maar staat mij toch een familiegraf bij u af, waar ik mijn dode, die van mij is heengegaan, kan begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","De zonen van Chet gaven Abraham ten antwoord: ");
INSERT INTO nld1939_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Heer, hoor ons aan. Gij zijt een vorst Gods onder ons! Begraaf dus uw afgestorvene in het mooiste onzer graven; niemand van ons zal u zijn eigen grafstede weigeren, om er uw afgestorvene in te begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Toen stond Abraham op, boog zich ter aarde voor de Chittieten, de bewoners van het land, ");
INSERT INTO nld1939_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","en zeide tot hen: Zo gij er in toestemt, dat ik mijn dode, die van mij is heengegaan, begraaf, weest mij dan terwille, en doet een goed woord voor mij bij Efron, den zoon van Sóchar. ");
INSERT INTO nld1939_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Laat hij mij de grot van Makpela verkopen, die zijn eigendom is, en die aan de rand van zijn akker ligt. Laat hij ze mij in uwe tegenwoordigheid voor de volle prijs tot familiegraf afstaan. ");
INSERT INTO nld1939_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Daar ook Efron zelf in de kring der Chittieten zat, stond dus Efron, de Chittiet, Abraham te woord ten aanhoren van al de zonen van Chet, die naar de poort van zijn stad waren gekomen. Hij sprak: ");
INSERT INTO nld1939_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Zo niet, heer: maar luister naar mij: Ik geef u het land ten geschenke met de grot, die er op ligt; in tegenwoordigheid van mijn stamgenoten sta ik ze u af; begraaf er uw dode. ");
INSERT INTO nld1939_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Weer boog Abraham voor de bewoners van het land zich ter aarde, ");
INSERT INTO nld1939_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","en sprak tot Efron ten aanhoren van alle bewoners van het land: Zo gij de eigenaar zijt, hoor mij dan aan: Ik wil toch liever het land betalen; neem het geld van mij aan, dan kan ik mijn dode daar begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Maar Efron antwoordde weer aan Abraham: ");
INSERT INTO nld1939_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Toch niet, heer, maar luister naar mij: Een stuk land van vierhonderd zilveren sikkels, wat betekent dat nu voor u of mij; begraaf dus uw dode. ");
INSERT INTO nld1939_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham ging in op het aanbod van Efron, en woog het zilver af, dat Efron ten aanhoren van de zonen van Chet had gevraagd: vierhonderd zilveren sikkels, zoals ze bij de kooplui gangbaar zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Zo werd de akker van Efron, die in Makpela ten oosten van Mamre ligt, zowel de akker zelf als de grot, die er op ligt, met de bomen, die op de akker stonden, en die het hele terrein omringden, ");
INSERT INTO nld1939_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahams eigendom in tegenwoordigheid van al de Chittieten, die naar de poort van zijn stad waren gekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nu begroef Abraham zijn vrouw Sara in de grot op de akker van Makpela, ten oosten van Mamre, dat Hebron is, in het land Kanaän. ");
INSERT INTO nld1939_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Zo ging de akker en de grot, die er op ligt, van de zonen van Chet aan Abraham over als familiegraf. ");
INSERT INTO nld1939_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham was oud en hoogbejaard, en Jahweh had Abraham in alles gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Daarom sprak Abraham tot den oudsten dienaar van zijn huis, die het opzicht had over heel zijn bezit: Leg uw hand onder mijn heup; ");
INSERT INTO nld1939_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","want ik wil u doen zweren bij Jahweh, den God des hemels en den God der aarde, dat gij voor mijn zoon geen vrouw zult kiezen uit de dochters der Kanaänieten, in wier midden ik woon; ");
INSERT INTO nld1939_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","maar dat gij naar mijn land en mijn familie zult gaan, om dáár een vrouw voor mijn zoon Isaäk te zoeken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","De dienaar antwoordde: Maar als nu de vrouw mij niet wil volgen naar dit land, moet ik dan uw zoon terugbrengen naar het land, waaruit gij zijt weggetrokken? ");
INSERT INTO nld1939_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Maar Abraham zeide hem: Pas op, dat ge mijn zoon daar niet terugbrengt. ");
INSERT INTO nld1939_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jahweh, de God des hemels, die mij uit mijn vaderlijk huis en uit mijn geboorteland heeft geleid, en die mij gezegd en bezworen heeft: “Aan uw nageslacht geef Ik dit land”: Hij zal zijn engel voor u uit zenden, en u daar voor mijn zoon een vrouw laten vinden. ");
INSERT INTO nld1939_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mocht die vrouw u niet willen volgen, dan verplicht mijn eed u niet langer; maar in geen geval moogt ge mijn zoon daar terugbrengen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Toen legde de dienaar zijn hand onder de heup van Abraham, zijn meester, en zwoer hem de gevraagde eed. ");
INSERT INTO nld1939_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nu nam de dienaar tien kamelen uit de kudde van zijn meester, pakte allerlei kostbaarheden van zijn meester bijeen, trok op en reisde naar Aram-Naharáim, naar de stad van Nachor. ");
INSERT INTO nld1939_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Buiten de stad bij de waterput liet hij de kamelen neerknielen; het was tegen de avond, dus tegen de tijd, dat de vrouwen naar buiten gaan, om water te putten. ");
INSERT INTO nld1939_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Toen sprak hij: Jahweh, God van mijn heer Abraham; ik bid U, laat mij nu slagen, en wees Abraham, mijn meester, genadig. ");
INSERT INTO nld1939_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Zie, ik sta bij de bron, en de dochters van de burgers der stad komen naar buiten, om water te putten. ");
INSERT INTO nld1939_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Wanneer het meisje, tot wie ik zeg: “reik mij uw kruik, om te drinken”, ten antwoord geeft: “drink, en ook uw kamelen zal ik water geven”; dan zal dàt het meisje zijn, dat Gij voor uw dienaar Isaäk hebt bestemd; en daaraan zal ik erkennen, dat Gij mijn heer genadig zijt. ");
INSERT INTO nld1939_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nog had hij niet uitgesproken, of Rebekka kwam met een kruik op haar schouder naar buiten; zij was de dochter van Betoeël, den zoon van Milka, de vrouw van Nachor, Abrahams broer. ");
INSERT INTO nld1939_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Het was een bijzonder mooi meisje; een maagd, die nog met geen man omgang had gehad. Zij daalde af naar de bron, vulde haar kruik, en kwam weer naar boven. ");
INSERT INTO nld1939_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","De dienaar liep op haar toe, en sprak: Laat mij een beetje water drinken uit uw kruik. ");
INSERT INTO nld1939_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Zij antwoordde: Drink, heer. En terstond liet zij de kruik op haar hand zakken, en gaf hem te drinken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","En toen zij hem had laten drinken, zeide zij nog: Ook voor uw kamelen zal ik water putten, tot ze genoeg hebben. ");
INSERT INTO nld1939_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Vlug goot ze haar kruik in de drinkbak leeg, repte zich weer naar de put, om opnieuw te gaan scheppen, en water te putten voor al zijn kamelen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Zwijgend nam de man haar nauwkeuriger op, om te weten, of Jahweh zijn reis had doen slagen, of niet. ");
INSERT INTO nld1939_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","En nadat de kamelen volop hadden gedronken, nam de man een gouden neusring ter waarde van een halve sikkel, stak die in haar neus, deed om haar polsen twee armbanden ter waarde van tien gouden sikkels, ");
INSERT INTO nld1939_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","en vroeg: Wiens dochter zijt gij; vertel me dat eens? Is er in het huis van uw vader plaats voor ons, om te overnachten? ");
INSERT INTO nld1939_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ze gaf hem ten antwoord: Ik ben de dochter van Betoeël, den zoon van Milka, dien zij aan Nachor heeft gebaard. ");
INSERT INTO nld1939_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","En zij ging voort: We hebben stro en voedsel in overvloed, ook plaats om te overnachten. ");
INSERT INTO nld1939_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Toen viel de man op zijn knieën, aanbad Jahweh, ");
INSERT INTO nld1939_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","en sprak: Gezegend zij Jahweh, de God van Abraham, mijn meester, die zijn genade en trouw aan mijn heer niet onthoudt; want Jahweh heeft mij geleid naar het huis van den broer van mijn heer. ");
INSERT INTO nld1939_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Het meisje was al naar huis gelopen, en vertelde thuis aan haar moeder, wat er gebeurd was. ");
INSERT INTO nld1939_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nu had Rebekka een broer, die Laban heette. Laban liep naar den man, die buiten bij de bron stond; ");
INSERT INTO nld1939_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","want hij had de neusring gezien met de armbanden om de polsen van zijn zuster, en zijn zuster Rebekka horen vertellen: zo en zo heeft de man met mij gesproken. Hij trad op hem toe, terwijl hij nog met de kamelen bij de bron stond te wachten, ");
INSERT INTO nld1939_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","en sprak: Kom, gezegende van Jahweh; waarom blijft ge nog buiten staan, terwijl ik het huis en een plaats voor de kamelen al gereed heb? ");
INSERT INTO nld1939_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hij leidde den man naar huis, zadelde de kamelen af, en gaf ze stro en voer; dan bracht hij voor hem en zijn mannen water, om zich de voeten te wassen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Maar toen hem spijzen werden voorgezet, zeide hij: Ik eet niet, eer ik gezegd heb, wat ik moet zeggen. Hij zeide: Spreek op. ");
INSERT INTO nld1939_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","En hij sprak: Ik ben de dienaar van Abraham. ");
INSERT INTO nld1939_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jahweh heeft mijn heer overvloedig gezegend, zodat hij rijk is geworden; Hij heeft hem schapen en runderen, zilver en goud, slaven en slavinnen, kamelen en ezels geschonken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","En Sara, de vrouw van mijn meester, heeft mijn heer een zoon gebaard, toen ze reeds oud was; en aan hem heeft hij heel zijn bezit vermaakt. ");
INSERT INTO nld1939_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nu heeft mijn meester mij een eed laten zweren: Gij moogt voor mijn zoon geen vrouw nemen uit de dochters der Kanaänieten, in wier land ik woon; ");
INSERT INTO nld1939_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","maar ge moet naar het huis van mijn vader gaan en naar mijn stam, om daar een vrouw voor mijn zoon te halen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ik zeide tot mijn heer: Maar als die vrouw mij niet wil volgen? ");
INSERT INTO nld1939_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hij antwoordde mij: Jahweh voor wiens aanschijn ik heb geleefd, Hij zal zijn engel met u zenden, en uw reis doen gelukken; gij zult een vrouw voor mijn zoon krijgen uit mijn stam en uit het huis van mijn vader. ");
INSERT INTO nld1939_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eerst dan zijt gij van de eed, die ik u opleg, ontslagen, als ge bij mijn stam zijt gekomen, en men er u geen geven wil; dan verplicht mijn eed u niet meer. ");
INSERT INTO nld1939_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Toen ik dan vandaag bij de bron was gekomen, zeide ik: Jahweh, God van mijn heer Abraham; ach, laat toch de reis gelukken, die ik heb ondernomen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Zie, ik sta nu bij de waterbron. Wanneer de maagd, die naar buiten komt, om water te putten, en tot wie ik zeg: “geef mij een beetje water te drinken uit uw kruik”, ");
INSERT INTO nld1939_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mij ten antwoord geeft: “drink, en ook voor uw kamelen zal ik putten”, dan zal zij de vrouw zijn, die Jahweh voor den zoon van mijn heer heeft bestemd. ");
INSERT INTO nld1939_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nog had ik bij mezelf niet uitgesproken, of daar kwam Rebekka naar buiten met haar kruik op haar schouder, en daalde af naar de bron, om te putten. En toen ik haar zeide: “laat mij wat drinken”, ");
INSERT INTO nld1939_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","liet ze dadelijk haar kruik zakken, en sprak: “drink, en ook uw kamelen zal ik water geven”. Ik dronk, en ze liet ook de kamelen drinken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ik vroeg haar: Wiens dochter zijt gij? Zij antwoordde: De dochter van Betoeël, den zoon van Nachor, dien Milka hem geschonken heeft. Toen stak ik een ring in haar neus, en deed armbanden om haar polsen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ik viel op mijn knieën om Jahweh te aanbidden, en ik zegende Jahweh, den God van mijn heer Abraham, die mij op de rechte weg had geleid, om voor zijn zoon de dochter van den broer van mijn meester te gaan halen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Welnu dan, als gij mijn heer liefde en trouw wilt bewijzen, zegt het mij dan; maar zo niet, laat het mij eveneens weten, dan kan ik naar rechts of naar links gaan. ");
INSERT INTO nld1939_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban en Betoeël gaven ten antwoord: Dit is een beschikking van Jahweh; we kunnen er niets tegen inbrengen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Zie Rebekka staat te uwer beschikking; neem haar met u mee, opdat zij de vrouw wordt van den zoon van uw heer, zoals Jahweh gezegd heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Toen de dienaar van Abraham had gehoord wat ze zeiden, wierp hij zich ter aarde voor Jahweh neer. ");
INSERT INTO nld1939_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hij haalde zilveren en gouden sieraden en klederen te voorschijn, en schonk ze aan Rebekka; ook aan haar broer en haar moeder gaf hij kostbare geschenken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Toen eerst aten en dronken hij en zijn mannen, en bleven ze overnachten. Zodra men de volgende morgen was opgestaan, sprak hij: Laat mij nu terug gaan naar mijn heer. ");
INSERT INTO nld1939_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Maar haar broer en haar moeder zeiden: Laat het meisje nog een dag of tien bij ons blijven; dan kan ze vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Maar hij antwoordde hun: Houdt me niet tegen, nu Jahweh mijn reis heeft doen slagen; staat mij dus toe, naar mijn heer te vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ze zeiden: We zullen het meisje roepen, en het haar zelf vragen. ");
INSERT INTO nld1939_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Zij riepen Rebekka, en vroegen haar: Wilt ge met dien man meegaan? Zij antwoordde: Ja! ");
INSERT INTO nld1939_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Nu lieten ze hun zuster Rebekka vertrekken, vergezeld van haar min en den dienaar van Abraham met zijn volk. ");
INSERT INTO nld1939_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Zij zegenden Rebekka, en zeiden tot haar: Zuster, moogt ge tot duizend maal tienduizenden groeien, En moge uw kroost de poorten bezitten van die het haten. ");
INSERT INTO nld1939_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Toen maakten Rebekka en haar dienstmaagd zich klaar, stegen op de kamelen, en sloten zich aan bij den man; de dienaar nam Rebekka mee, en vertrok. ");
INSERT INTO nld1939_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Intussen was Isaäk naar de woestijn bij de bron van Lachai-Roï getrokken, en woonde hij in het land van de Négeb. ");
INSERT INTO nld1939_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Eens was Isaäk bij het vallen van de avond het veld ingegaan, om zich wat te verzetten; toevallig sloeg hij zijn ogen op, en zie: daar kwamen kamelen aan. ");
INSERT INTO nld1939_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ook Rebekka sloeg haar ogen op; en toen zij Isaäk zag, liet zij zich van haar kameel afglijden, ");
INSERT INTO nld1939_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","en sprak tot den dienaar: Wie is die man daar, die ons in het veld tegemoet komt? De dienaar antwoordde: Dat is mijn meester. Toen nam ze haar sluier, en bedekte zich. ");
INSERT INTO nld1939_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","En nadat de dienaar alles, wat hij gedaan had, aan Isaäk had verteld, ");
INSERT INTO nld1939_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","leidde Isaäk Rebekka naar de tent van Sara zijn moeder, en nam haar tot vrouw. Isaäk kreeg haar lief, en troostte zich over de dood van zijn moeder. ");
INSERT INTO nld1939_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham had nog een andere vrouw genomen, Ketoera geheten. ");
INSERT INTO nld1939_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Zij baarde hem Zimran, Joksjan, Medan, Midjan, Jisjbak en Sjóeach. ");
INSERT INTO nld1939_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksjan verwekte Sjeba en Dedan. De zonen van Dedan waren de Assjoerieten, de Letoesjieten en de Leoemmieten. ");
INSERT INTO nld1939_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","De zonen van Midjan waren Efa, Efer, Chanok, Abida en Eldaä. Dat waren allen nakomelingen van Ketoera. ");
INSERT INTO nld1939_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham gaf alles, wat hij bezat aan Isaäk. ");
INSERT INTO nld1939_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aan de zonen van zijn bijvrouwen gaf Abraham geschenken, en zond ze nog tijdens zijn leven weg, uit de omgeving van zijn zoon Isaäk naar de overkant, het land van het oosten. ");
INSERT INTO nld1939_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dit is het getal van Abrahams levensjaren; honderd vijf en zeventig jaar. ");
INSERT INTO nld1939_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Op hoge leeftijd is Abraham ontslapen; oud en afgeleefd is hij gestorven, en werd hij bij zijn volk verzameld. ");
INSERT INTO nld1939_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Zijn zonen Isaäk en Jisjmaël begroeven hem in de grot van Makpela, die ten oosten van Mamre ligt, op de akker van Efron, den zoon van Sóchar, den Chittiet. ");
INSERT INTO nld1939_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Het was de akker, die Abraham van de Chittieten gekocht had. Daar liggen Abraham en zijn vrouw Sara begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Toen Abraham gestorven was, zegende God zijn zoon Isaäk. Isaäk bleef wonen bij de bron van Lachai-Roï. ");
INSERT INTO nld1939_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dit is de geslachtslijst van Jisjmaël, den zoon van Abraham, dien Hagar, de egyptische slavin van Sara, Abraham gebaard heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dit zijn de namen van Jisjmaëls zonen volgens de naam van hun geslacht. De eerstgeborene van Jisjmaël was Nebajot; verder Kedar, Adbeël en Mibsam, ");
INSERT INTO nld1939_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misjma, Doema en Massa, ");
INSERT INTO nld1939_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Chadad, Tema, Jetoer, Nafisj en Kédma. ");
INSERT INTO nld1939_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dit zijn de zonen van Jisjmaël, en dat zijn hun namen naar hun nederzettingen en kampementen: twaalf vorsten overeenkomstig het getal van hun stammen. ");
INSERT INTO nld1939_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","De levensjaren van Jisjmaël bedroegen honderd zeven en dertig jaar. Toen ontsliep hij en stierf, en werd bij zijn volk verzameld. ");
INSERT INTO nld1939_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hij woonde van Chawila tot Sjoer, dat tegenover Egypte ligt, en tot Assjoer toe, verwijderd van al zijn broeders. ");
INSERT INTO nld1939_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dit is de geslachtslijst van Isaäk, den zoon van Abraham. Abraham verwekte Isaäk. ");
INSERT INTO nld1939_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Toen Isaäk veertig jaar oud was, huwde hij Rebekka, de dochter van Betoeël, den Arameër van Paddan-Aram, en zuster van den Arameër Laban. ");
INSERT INTO nld1939_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Omdat zijn vrouw onvruchtbaar bleef, bad Isaäk tot Jahweh voor haar; en Jahweh verhoorde hem, zodat zijn vrouw Rebekka zwanger werd. ");
INSERT INTO nld1939_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Maar toen de kinderen in haar schoot tegen elkaar opdrongen, zeide zij: Als dit zo moet gaan, waarom blijf ik dan in leven! Daarom ging zij Jahweh raadplegen. ");
INSERT INTO nld1939_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","En Jahweh sprak tot haar: Twee volken draagt gij in uw schoot, Twee naties gaan uiteen van uw moederlijf af. De ene natie zal machtiger zijn dan de andere, De oudste zal de jongste dienen. ");
INSERT INTO nld1939_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Toen het ogenblik was aangebroken, waarop zij moest baren, was er inderdaad een tweeling in haar schoot. ");
INSERT INTO nld1939_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","De eerste, die te voorschijn kwam, was rossig en helemaal als in een pels gewikkeld; men noemde hem Esau. ");
INSERT INTO nld1939_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Daarna kwam zijn broertje, die met zijn hand de hiel van Esau vasthield; daarom noemde men hem Jakob. Isaäk was zestig jaar oud, toen hij hen verwekte. ");
INSERT INTO nld1939_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Toen de jongens groot waren geworden, werd Esau een behendig jager, een buitenmens; maar Jakob was een rustig man, die in tenten verbleef. ");
INSERT INTO nld1939_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaäk hield van Esau, omdat zijn wild hem smaakte; maar Rebekka beminde Jakob. ");
INSERT INTO nld1939_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Eens was Jakob een gerecht aan het koken, toen Esau moe uit het veld thuiskwam. ");
INSERT INTO nld1939_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","En Esau zeide tot Jakob: Laat me eens gauw eten van dat rode kooksel daar; want ik ben uitgeput. Daarom werd hij ook Edom genoemd. ");
INSERT INTO nld1939_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakob antwoordde: Verkoop me dan eerst uw eerstgeboorterecht. ");
INSERT INTO nld1939_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau hernam: Wel, ik ga toch dood; wat heb ik dan aan een eerstgeboorterecht. ");
INSERT INTO nld1939_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sprak: Zweer het mij eerst! En hij zwoer het hem. Zo verkocht hij aan Jakob zijn eerstgeboorterecht. ");
INSERT INTO nld1939_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Toen gaf Jakob aan Esau brood met het linzenmoes. Deze at en dronk, stond op en ging heen. Zo weinig telde Esau het eerstgeboorterecht. ");
INSERT INTO nld1939_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Toen er eens na de vroegere hongersnood, die in Abrahams dagen had geheerst, opnieuw hongersnood in het land ontstond, vertrok Isaäk naar Gerar, naar Abimélek, den koning der Filistijnen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Daar verscheen hem Jahweh, en sprak tot hem: Daal niet af naar Egypte, maar blijf in het land, dat Ik u aanwijs. ");
INSERT INTO nld1939_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vestig u in dit land, en Ik zal met u zijn en u zegenen; want aan u en uw geslacht zal Ik al deze landen geven, en Ik zal de eed, die Ik uw vader Abraham gezworen heb, gestand doen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ik zal uw nageslacht talrijk maken als de sterren aan de hemel, en aan uw nageslacht al deze landen schenken. In uw zaad zullen alle volken der aarde worden gezegend, ");
INSERT INTO nld1939_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","omdat Abraham naar mijn stem heeft gehoord, en mijn gebod en bevelen, mijn instellingen en wetten heeft onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Zo bleef Isaäk te Gerar wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Toen nu de inwoners van die stad hem polsten over zijn vrouw, zeide hij: Het is mijn zuster. Want hij durfde niet zeggen: Het is mijn vrouw. Hij was bang, dat de inwoners van die stad hem om Rebekka zouden vermoorden; want zij was een knappe verschijning. ");
INSERT INTO nld1939_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nadat hij daar al geruime tijd had vertoefd, gebeurde het eens, dat Abimélek, de koning der Filistijnen, uit zijn venster keek en zag, dat Isaäk zijn vrouw Rebekka aan het liefkozen was. ");
INSERT INTO nld1939_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nu liet Abimélek Isaäk roepen, en zeide hem: Vast en zeker: het is uw vrouw! Hoe hebt ge dan kunnen zeggen: Het is mijn zuster! Isaäk gaf hem ten antwoord: Ik was bang, dat ik om haar zou worden vermoord. ");
INSERT INTO nld1939_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimélek hernam: Maar wat hebt ge ons gedaan! Hoe gemakkelijk had iemand van ons volk met uw vrouw gemeenschap kunnen houden; ge zoudt dan een zware schuld op ons hebben geladen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Toen liet Abimélek aan heel het volk afkondigen: Wie dezen man of zijn vrouw enig leed durft doen, zal sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nu begon Isaäk in dat land te zaaien, en won dat jaar een honderdvoudige oogst; want Jahweh zegende hem. ");
INSERT INTO nld1939_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","De man werd al rijker en rijker, totdat hij grote overvloed bezat. ");
INSERT INTO nld1939_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Hij had talrijke schapen en runderen en een groot aantal slaven, zodat de Filistijnen afgunstig op hem werden. ");
INSERT INTO nld1939_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Daarom begonnen de Filistijnen alle putten, die de knechten van zijn vader in de dagen van zijn vader Abraham gegraven hadden, te verstoppen en met zand dicht te werpen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","En Abimélek zeide tot Isaäk: Ga van ons heen; want gij wordt ons te machtig! ");
INSERT INTO nld1939_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaäk trok dus vandaar weg, sloeg zijn tent op in het dal van Gerar, en bleef daar wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Daar groef Isaäk de waterputten weer open, die men tijdens het leven van zijn vader Abraham had gegraven, maar die de Filistijnen na de dood van Abraham hadden dichtgeworpen; hij gaf ze weer dezelfde namen als zijn vader gedaan had. ");
INSERT INTO nld1939_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Terwijl dus de knechten van Isaäk in het Gerardal aan het graven waren, vonden ze daar een put met stromend water. ");
INSERT INTO nld1939_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Maar de herders van Gerar begonnen met de herders van Isaäk te twisten, en zeiden: Dat water behoort ons. Daarom noemde hij die put Ések, omdat ze daar met hem hadden getwist. ");
INSERT INTO nld1939_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nu groeven zij een andere put, maar ook daarover ontstond strijd; men noemde die Sitna. ");
INSERT INTO nld1939_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Toen trok hij ook vandaar weg, en groef weer een andere put, waarover geen twist meer ontstond. Hij noemde hem Rechobot; want hij zeide: Nu heeft Jahweh ons ruimte gemaakt, zodat we in het land kunnen groeien. ");
INSERT INTO nld1939_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Vandaar trok hij op naar Beër-Sjéba. ");
INSERT INTO nld1939_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Daar verscheen Jahweh hem zekere nacht, en sprak tot hem: Ik ben de God van Abraham, uw vader! Vrees niet, want Ik ben met u. Ik zal u zegenen en uw geslacht talrijk maken, Om wille van Abraham, mijn dienaar. ");
INSERT INTO nld1939_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Daarom bouwde hij daar een altaar, en riep de naam van Jahweh aan. Isaäk sloeg er zijn tent op, en zijn knechten groeven er een put. ");
INSERT INTO nld1939_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nu kwam Abimélek van Gerar uit hem bezoeken in gezelschap van Achoezzat, zijn vertrouweling, en Pikol, zijn legeroverste. ");
INSERT INTO nld1939_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Maar Isaäk zei hem: Waarom komt gij naar mij toe, terwijl gij mij haat en mij van u hebt weggejaagd? ");
INSERT INTO nld1939_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ze antwoordden: We hebben nu duidelijk ingezien, dat Jahweh met u is. Daarom hebben we gedacht: er moest een eedverdrag tussen ons beiden bestaan, tussen ons en u. Wij willen een verbond met u sluiten, ");
INSERT INTO nld1939_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","dat gij ons geen kwaad zult doen, evenmin als wij u enig leed hebben gedaan, maar u enkel vriendschap hebben bewezen, en u in vrede lieten gaan. Waarachtig, gij zijt door Jahweh gezegend! ");
INSERT INTO nld1939_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hierop richtte hij een gastmaal voor hen aan, en zij aten en dronken. ");
INSERT INTO nld1939_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","De volgende morgen zwoeren zij elkander de eed. Toen liet Isaäk hen vertrekken, en zij gingen van hem in vrede heen. ");
INSERT INTO nld1939_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nog diezelfde dag kwamen de knechten van Isaäk hem berichten over een welput, die zij hadden gegraven, en zeiden hem: We hebben water gevonden. ");
INSERT INTO nld1939_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hij noemde die Sjiba; en daarom heet die stad Beër-Sjéba tot op de huidige dag. ");
INSERT INTO nld1939_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Toen Esau veertig jaar oud was, huwde hij Jehoedit, de dochter van den Chittiet Beëri, en Basemat, de dochter van den Chittiet Elon. ");
INSERT INTO nld1939_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Zij waren de oorzaak van bitter verdriet voor Isaäk en Rebekka. ");
INSERT INTO nld1939_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Intussen was Isaäk oud geworden en werden zijn ogen zo zwak, dat hij niet meer kon zien. Daarom riep hij zijn oudsten zoon Esau, en zei hem: Mijn zoon! Deze antwoordde: Hier ben ik! ");
INSERT INTO nld1939_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Hij sprak: Zie, ik ben oud geworden, en weet niet, wanneer ik zal sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Neem daarom uw jachttuig, pijlkoker en boog, ga het veld in, en schiet voor mij een stuk wild; ");
INSERT INTO nld1939_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","maak het smakelijk voor me klaar, zoals ik het graag heb, en breng het me hier, om op te eten. Dan zal ik u zegenen, vóór ik sterf. ");
INSERT INTO nld1939_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Maar Rebekka had afgeluisterd, wat Isaäk tot zijn zoon Esau had gezegd. En toen Esau het veld was ingegaan, om een stuk wild voor zijn vader te schieten, ");
INSERT INTO nld1939_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","zei Rebekka tot haar zoon Jakob: Ik heb zo juist uw vader tegen uw broer Esau horen zeggen: ");
INSERT INTO nld1939_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Breng mij een stuk wild, en maak er een smakelijke schotel van, waarvan ik kan eten; dan zal ik u zegenen voor het aanschijn van Jahweh, eer ik sterf”. ");
INSERT INTO nld1939_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Luister nu naar mij, mijn jongen, en doe wat ik u zeg. ");
INSERT INTO nld1939_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ga naar de kudde en haal mij twee malse geitebokjes; dan maak ik daarvan een smakelijke schotel voor uw vader gereed, zoals hij het gaarne heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Die moet ge naar uw vader brengen, dan kan hij ervan eten. Dan zal hij u zegenen, eer hij sterft. ");
INSERT INTO nld1939_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Doch Jakob zei tot zijn moeder Rebekka: Maar mijn broer Esau is ruig, en ik ben onbehaard. ");
INSERT INTO nld1939_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Als mijn vader mij nu eens betast, zal hij denken, dat ik de spot met hem drijf; en ik zal vloek over mij brengen in plaats van zegen. ");
INSERT INTO nld1939_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Zijn moeder verzekerde hem: Die vloek over u neem ik op mij, mijn jongen; luister maar naar mij, en ga ze halen. ");
INSERT INTO nld1939_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Hij ging ze dus halen, en bracht ze naar zijn moeder; en zijn moeder maakte er een smakelijke schotel van, zoals zijn vader het gaarne had. ");
INSERT INTO nld1939_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Daarna nam Rebekka de beste kleren van haar oudsten zoon Esau, die ze bij zich thuis had, en trok die haar jongsten zoon Jakob aan; ");
INSERT INTO nld1939_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","de vellen van de geitebokjes trok ze over zijn handen en over het onbehaarde deel van zijn hals. ");
INSERT INTO nld1939_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Vervolgens reikte zij haar zoon Jakob de smakelijke schotel met het brood, dat zij gebakken had. ");
INSERT INTO nld1939_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nu ging hij naar zijn vader en sprak: Vader! Deze antwoordde: Ja, mijn jongen, wie zijt ge? ");
INSERT INTO nld1939_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","En Jakob zei tot zijn vader: Ik ben Esau, uw eerstgeborene; ik heb gedaan, wat ge mij gezegd hebt. Ga dus overeind zitten, en eet van het wild; dan kunt ge me zegenen. ");
INSERT INTO nld1939_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Maar Isaäk vroeg zijn zoon: Hoe hebt ge dat zo gauw kunnen vinden, mijn jongen? Deze antwoordde: Jahweh, uw God, heeft het mij tegemoet gestuurd. ");
INSERT INTO nld1939_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Maar nu beval Isaäk aan Jakob: Kom dichter bij, mijn jongen; dan kan ik u eens betasten, of ge werkelijk mijn zoon Esau zijt of niet. ");
INSERT INTO nld1939_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob trad dus op zijn vader Isaäk toe. Deze betastte hem en sprak: De stem is de stem van Jakob, maar de handen zijn de handen van Esau. ");
INSERT INTO nld1939_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hij herkende hem niet, omdat zijn handen behaard waren als de handen van Esau, zijn broer. En toen hij hem wilde zegenen, ");
INSERT INTO nld1939_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","sprak hij nog: Ge zijt toch wezenlijk mijn zoon Esau? Hij antwoordde: Ja, dat ben ik. ");
INSERT INTO nld1939_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Toen zei hij: Dien het mij op, en laat mij eten van het wild van mijn zoon; dan zal ik u zegenen. Hij zette het hem voor, en hij at; daarna bracht hij hem wijn, die hij dronk. ");
INSERT INTO nld1939_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nu sprak zijn vader Isaäk tot hem: Kom hier, mijn zoon, en kus mij. ");
INSERT INTO nld1939_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Hij trad nader, en kuste hem. En toen hij de geur van zijn kleren rook, zegende hij hem, en sprak: Zie, de geur van mijn zoon Is als de geur van een akker, Door Jahweh gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God schenke u dauw van de hemel, En het vette der aarde, Met overvloed van koren en most. ");
INSERT INTO nld1939_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Volken zullen u dienen, En naties zich voor u buigen. Wees een vorst over uw broeders, De zonen uwer moeder werpen zich voor u neer. Vervloekt, die u vloekt, Maar gezegend, die u zegent! ");
INSERT INTO nld1939_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Nauwelijks had Isaäk Jakob gezegend, en was Jakob van zijn vader Isaäk heengegaan, of zijn broer Esau kwam terug van de jacht. ");
INSERT INTO nld1939_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ook hij maakte een smakelijke schotel gereed, bracht die naar zijn vader, en sprak tot zijn vader: Kom overeind zitten, vader, en eet van het wild van uw zoon; dan kunt ge me zegenen. ");
INSERT INTO nld1939_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Zijn vader Isaäk sprak tot hem: Wie zijt gij? Hij antwoordde: Ik ben uw zoon Esau, uw eerstgeborene. ");
INSERT INTO nld1939_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Hevig ontsteld vroeg Isaäk: Maar wie was het dan, die het wild heeft geschoten en het mij heeft gebracht, zodat ik voor uw komst reeds volop heb gegeten? Dien heb ik gezegend, en hij blijft gezegend! ");
INSERT INTO nld1939_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Toen Esau dit van zijn vader vernam, brak hij in luide en bittere jammerklachten los, en zei tot zijn vader: Vader, zegen ook mij! ");
INSERT INTO nld1939_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Deze antwoordde: Uw broer heeft u listig de zegen ontnomen. ");
INSERT INTO nld1939_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","En hij zeide: Terecht wordt hij Jakob genoemd; want hij heeft mij reeds tweemaal bedrogen. Hij heeft mij mijn eerstgeboorterecht ontroofd, en zie, nu steelt hij mijn zegen. En hij ging voort: Hebt ge voor mij geen zegen meer? ");
INSERT INTO nld1939_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaäk gaf Esau ten antwoord: Zie, ik heb hem over u tot vorst gesteld, hem al zijn broeders tot dienaars gegeven, en koren en most hem geschonken. Mijn jongen, wat kan ik dan voor ú nog doen? ");
INSERT INTO nld1939_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Maar Esau zei tot zijn vader: Was dat dan uw enige zegen, vader? Ach, vader, zegen ook mij! En Esau snikte het uit. ");
INSERT INTO nld1939_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Toen sprak zijn vader Isaäk tot hem: Zie, ver van het vette der aarde zult ge wonen, Ver van de hemeldauw uit den hogen, ");
INSERT INTO nld1939_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Van uw zwaard zult ge leven! Uw broeder zult ge dienstbaar zijn; Maar als ge tot macht komt, Schudt ge zijn juk van uw nek! ");
INSERT INTO nld1939_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau haatte Jakob om de zegen, die zijn vader over hem had uitgesproken. En Esau dacht bij zichzelf: De tijd komt spoedig, dat men rouwt over mijn vader; dan zal ik mijn broer Jakob vermoorden. ");
INSERT INTO nld1939_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Toen men aan Rebekka dit plan van haar oudsten zoon Esau overbracht, liet zij haar jongsten zoon Jakob roepen, en zei tot hem: Hoor eens, uw broer Esau wil wraak op u nemen en u vermoorden. ");
INSERT INTO nld1939_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Luister nu naar mij, mijn jongen. Maak u gereed, om naar mijn broer Laban in Charan te vluchten, ");
INSERT INTO nld1939_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","en blijf enige tijd bij hem, totdat de woede van uw broer is bekoeld. ");
INSERT INTO nld1939_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Wanneer de toorn van uw broer over u is bedaard, en hij vergeten is, wat ge hem hebt gedaan, zal ik bericht zenden en u terug laten halen. Waarom zou ik u beiden op één dag verliezen! ");
INSERT INTO nld1939_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Toen zei Rebekka tot Isaäk: Het leven walgt me al om de dochters van Chet. Als nu ook Jakob een vrouw neemt uit de meisjes van het land, wat heb ik dan aan mijn leven? ");
INSERT INTO nld1939_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Toen riep Isaäk Jakob, zegende hem, en beval hem: Neem geen vrouw uit de kanaänietische meisjes. ");
INSERT INTO nld1939_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Maar maak u gereed, om naar Paddan-Aram te gaan, naar het huis van uw grootvader Betoeël; kies u daar een vrouw uit de dochters van uw oom Laban. ");
INSERT INTO nld1939_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Moge de almachtige God u zegenen, en u vruchtbaar en talrijk maken, zodat gij tot een grote menigte volken zult uitgroeien. ");
INSERT INTO nld1939_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hij moge de zegen van Abraham aan u en uw nageslacht schenken, zodat gij het land moogt bezitten, waar ge als vreemdeling woont, maar dat God aan uw vader Abraham gaf. ");
INSERT INTO nld1939_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Zo zond Isaäk Jakob heen, en deze ging naar Paddan-Aram naar Laban, den zoon van den Arameër Betoeël, en broer van Rebekka, de moeder van Jakob en Esau. ");
INSERT INTO nld1939_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau had gemerkt, dat Isaäk Jakob had gezegend en hem naar Paddan-Aram had gezonden, om daar een vrouw te nemen; dat hij hem ook bij zijn zegening had verboden, een vrouw uit de kanaänietische meisjes te nemen, ");
INSERT INTO nld1939_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","en dat Jakob aan zijn vader en moeder had gehoorzaamd en naar Paddan-Aram was gegaan. ");
INSERT INTO nld1939_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau begreep daaruit, dat de kanaänietische vrouwen aan zijn vader Isaäk mishaagden; ");
INSERT INTO nld1939_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","daarom begaf hij zich naar Jisjmaël, en nam Machalat, de dochter van Jisjmaël, Abrahams zoon, de zuster van Nebajot tot vrouw bij de andere vrouwen, die hij al had. ");
INSERT INTO nld1939_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Toen Jakob van Beër-Sjéba was afgereisd en naar Charan trok, ");
INSERT INTO nld1939_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","kwam hij op een plaats, waar hij wilde overnachten, omdat de zon reeds was ondergegaan. Hij legde dus een van de stenen, die daar lagen, bij wijze van kussen onder zijn hoofd, en begaf zich op die plaats ter ruste. ");
INSERT INTO nld1939_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Daar had hij een droom: zie, op de aarde stond een ladder, waarvan de top tot de hemel reikte; en de engelen Gods klommen erop en daalden eraf. ");
INSERT INTO nld1939_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","En zie, Jahweh stond naast hem, en sprak: Ik ben Jahweh, de God van uw vader Abraham En de God van Isaäk! Het land, waarop ge ligt, Zal Ik u en uw nageslacht geven. ");
INSERT INTO nld1939_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Uw geslacht zal wezen Als het stof van de aarde: Gij zult u uitbreiden naar het westen en het oosten, Naar het noorden en het zuiden; In u en uw zaad Zullen alle geslachten der aarde worden gezegend! ");
INSERT INTO nld1939_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ik ben met u; Ik zal u behoeden, waar gij ook gaat, En u terugvoeren naar dit land. Neen, Ik zal u niet verlaten, Totdat Ik heb volbracht, wat Ik u heb beloofd! ");
INSERT INTO nld1939_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakob ontwaakte uit zijn slaap, en sprak: Waarachtig; Jahweh is hier, en ik wist het niet. ");
INSERT INTO nld1939_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Hij werd met ontzetting vervuld, en sprak: Hoe ontzagwekkend is deze plaats; dit is het huis van God en de poort van de hemel. ");
INSERT INTO nld1939_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","De volgende morgen nam Jakob de steen, waarop zijn hoofd had gerust, richtte die tot een gedenksteen op, en goot er olie over uit. ");
INSERT INTO nld1939_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hij noemde die plaats Betel, terwijl de stad vroeger Loez had geheten. ");
INSERT INTO nld1939_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Daarna deed Jakob de volgende gelofte: Als God met mij is, mij behoedt op de reis, die ik onderneem, mij voedsel geeft om te eten, een kleed om mij te kleden, ");
INSERT INTO nld1939_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","en mij in vrede terugbrengt naar mijn vaderlijk huis: dan zal Jahweh mij tot God zijn, ");
INSERT INTO nld1939_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","de steen, die ik als gedenkteken heb opgericht, een Godshuis worden, en zal ik U het tiende schenken van alles, wat Gij mij geeft! ");
INSERT INTO nld1939_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Toen begaf Jakob zich weer op weg, en ging naar het land der Oosterlingen. ");
INSERT INTO nld1939_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Daar zag hij in het veld een put, waarbij drie kudden schapen waren gelegerd; want uit die put werden de kudden gedrenkt. Daar de steen, die de put bedekte, groot was, ");
INSERT INTO nld1939_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","rolde men eerst de steen van de opening van de put, als alle kudden daar waren verzameld; en als men de kudden had laten drinken, wentelde men de steen weer op zijn plaats, op de opening van de put. ");
INSERT INTO nld1939_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob sprak hen aan: Broeders, waar komt gij vandaan? Zij antwoordden: Wij zijn van Charan. ");
INSERT INTO nld1939_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Hij vervolgde: Kent gij dan Laban, den zoon van Nachor? Zij zeiden: Ja! ");
INSERT INTO nld1939_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hij vroeg hun: Gaat het hem goed? Ze zeiden: Uitstekend; zie, daar komt juist zijn dochter Rachel aan met de kudde. ");
INSERT INTO nld1939_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Toen hernam hij: Het is nog volop dag, en nog lang geen tijd, om de kudden bijeen te drijven; geeft dus de kudden te drinken, en laat ze nog grazen. ");
INSERT INTO nld1939_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ze zeiden: Dat kunnen we niet, voordat alle kudden bijeen zijn; dan wordt de steen van de put gewenteld, en kunnen we het vee te drinken geven. ");
INSERT INTO nld1939_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nog was hij met hen in gesprek, toen Rachel naderde met de kudde van haar vader; want zij was een herderin. ");
INSERT INTO nld1939_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Zodra Jakob Rachel, de dochter van zijn oom Laban, met de kudde van zijn oom Laban zag, trad hij vooruit, om de steen van de putopening te wentelen en de kudde van zijn oom Laban te drenken. ");
INSERT INTO nld1939_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Daarop kuste Jakob Rachel, en weende hardop. ");
INSERT INTO nld1939_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","En toen Jakob Rachel had meegedeeld, dat hij de neef van haar vader was en de zoon van Rebekka, ging Rachel het vlug aan haar vader vertellen. ");
INSERT INTO nld1939_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Zodra Laban het nieuws over Jakob, den zoon van zijn zuster, vernam, liep hij hem tegemoet, omhelsde en kuste hem, en leidde hem zijn huis binnen. Daar vertelde hij Laban al wat er gebeurd was. ");
INSERT INTO nld1939_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","En Laban zeide hem: Waarachtig, gij zijt mijn gebeente en vlees! En hij bleef een volle maand bij hem. ");
INSERT INTO nld1939_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Daarna zei Laban tot Jakob: Zoudt ge, omdat ge mijn broeder zijt, mij dienen om niet? Zeg me, wat voor loon ge wilt hebben. ");
INSERT INTO nld1939_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nu had Laban twee dochters: de oudste heette Lea, de jongste Rachel; ");
INSERT INTO nld1939_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea had fletse ogen, maar Rachel was kloek van gestalte en knap van uiterlijk. ");
INSERT INTO nld1939_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","En daar Jakob Rachel beminde, gaf hij ten antwoord: Ik zal u zeven jaar dienen voor Rachel, uw jongste dochter. ");
INSERT INTO nld1939_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","En Laban antwoordde: Ik geef ze liever aan u dan aan een vreemde; blijf dus bij mij. ");
INSERT INTO nld1939_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Zo diende Jakob om Rachel zeven jaar lang; doch ze leken hem maar enkele dagen, zoveel hield hij van haar. ");
INSERT INTO nld1939_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Toen zei Jakob tot Laban: Geef mij mijn vrouw; want mijn tijd is om, en ik wil gemeenschap met haar houden. ");
INSERT INTO nld1939_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nu nodigde Laban alle mannen van de stad uit, en richtte een feestmaal aan. ");
INSERT INTO nld1939_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Maar toen het avond was geworden, haalde hij zijn dochter Lea, en leidde haar tot hem; en hij hield gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban gaf zijn dienstmaagd Zilpa mee als slavin voor zijn dochter Lea. ");
INSERT INTO nld1939_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","De volgende morgen: daar was het Lea! Nu zei hij tot Laban: Wat hebt ge me nu gedaan? Heb ik u niet om Rachel gediend? Waarom hebt ge me dan bedrogen? ");
INSERT INTO nld1939_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban antwoordde: Het is hier in ons land geen gewoonte, om de jongste vóór de oudste uit te huwen. ");
INSERT INTO nld1939_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Breng dus eerst maar met deze de bruiloftsweek door, dan zal ik u ook de andere geven, als ge me opnieuw zeven jaren wilt dienen. ");
INSERT INTO nld1939_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob deed het, en bracht met haar de bruiloftsweek door. Toen gaf Laban hem zijn dochter Rachel tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban gaf aan zijn dochter Rachel zijn dienstmaagd Bilha als slavin mee. ");
INSERT INTO nld1939_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ook met Rachel had Jakob gemeenschap; en hij hield meer van haar dan van Lea. Zo diende hij hem opnieuw zeven jaren. ");
INSERT INTO nld1939_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Toen Jahweh zag, dat Lea achteruit werd gezet, opende Hij haar schoot, terwijl Rachel kinderloos bleef. ");
INSERT INTO nld1939_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea werd zwanger en baarde een zoon. Zij noemde hem Ruben, want ze zeide: Jahweh heeft mijn ellende gezien; nu zal mijn man van mij houden. ");
INSERT INTO nld1939_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Zij werd een tweede maal zwanger, en baarde een zoon. Nu sprak zij: Jahweh heeft gehoord, dat ik een verschoppeling ben, en heeft mij ook dezen gegeven. En ze noemde hem Simeon. ");
INSERT INTO nld1939_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nog eens werd ze zwanger, en baarde een zoon. En ze sprak: Nu zal mijn man zich toch wel aan mij hechten; want ik heb hem al drie zonen gebaard. Daarom noemde zij hem Levi. ");
INSERT INTO nld1939_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Opnieuw werd zij zwanger, en baarde een zoon. En zij sprak: Nu loof ik Jahweh! Daarom noemde zij hem Juda. Daarna kreeg zij een tijdlang geen kinderen meer. ");
INSERT INTO nld1939_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Toen Rachel zag, dat zij Jakob geen kinderen schonk, werd zij jaloers op haar zuster, en zei tegen Jakob: Geef mij zonen, anders ga ik dood. ");
INSERT INTO nld1939_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Toornig gaf Jakob Rachel ten antwoord: Neem ik soms de plaats in van God, die een vrucht aan uw schoot heeft geweigerd? ");
INSERT INTO nld1939_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nu sprak ze: Hier hebt ge Bilha, mijn slavin; houd gemeenschap met haar, dan kan zij op mijn knieën baren, en ook ik door middel van haar uw geslacht opbouwen. ");
INSERT INTO nld1939_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Zij gaf hem dus haar slavin Bilha tot vrouw, en Jakob hield gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha werd zwanger, en baarde Jakob een zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","En Rachel sprak: God heeft mij recht gedaan; Hij heeft ook naar mijn smeken geluisterd en mij een zoon geschonken; daarom noemde ze hem Dan. ");
INSERT INTO nld1939_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Weer werd Bilha, de slavin van Rachel, zwanger en baarde Jakob een tweeden zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nu sprak Rachel: Een heftige kamp heb ik met mijn zuster gestreden, en ik heb overwonnen. En ze noemde hem Neftali. ");
INSERT INTO nld1939_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Toen Lea zag, dat zij geen kinderen meer kreeg, nam zij Zilpa haar dienstmaagd, en gaf haar aan Jakob tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ook Zilpa, de slavin van Lea, baarde Jakob een zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","En Lea zeide: Wat een weelde! En ze noemde hem Gad. ");
INSERT INTO nld1939_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nog baarde Zilpa, de slavin van Lea, Jakob een zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nu sprak Lea: Wat een geluk! Nu prijzen de vrouwen mij gelukkig. En ze noemde hem Aser. ");
INSERT INTO nld1939_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Eens ging Ruben in de tijd van de tarweoogst het veld in, en vond er liefdesappeltjes, die hij naar zijn moeder Lea bracht. Nu vroeg Rachel aan Lea: Geef mij een paar appeltjes van uw zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Maar zij gaf haar ten antwoord: Is het al niet genoeg, dat ge mij mijn man hebt ontstolen; wilt ge me nu ook nog de appeltjes van mijn zoon ontroven? Rachel zeide: Dan mag hij vannacht bij u slapen, in ruil voor de appeltjes van uw zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Toen Jakob dus in de avond van het veld kwam, ging Lea hem tegemoet en sprak: Bij mij moet ge komen; want ik heb er eerlijk voor betaald met de appeltjes van mijn zoon. Die nacht sliep hij dus bij haar. ");
INSERT INTO nld1939_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","En God verhoorde Lea: zij werd zwanger, en baarde Jakob een vijfden zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","En Lea sprak: God heeft mij er voor beloond, dat ik mijn slavin aan mijn man heb gegeven. En zij noemde hem Issakar. ");
INSERT INTO nld1939_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Wederom werd Lea zwanger, en baarde Jakob een zesden zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nu sprak Lea: God heeft mij een mooi geschenk gegeven; nu zal mijn man wel bij me blijven, want ik heb hem zes zonen gebaard. En ze noemde hem Zabulon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Daarna baarde ze nog een dochter, die ze Dina noemde. ");
INSERT INTO nld1939_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nu gedacht God ook Rachel; Hij verhoorde haar, en opende haar schoot. ");
INSERT INTO nld1939_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ook zij werd zwanger, en baarde een zoon. Nu zeide ze: God heeft mijn schande weggenomen. ");
INSERT INTO nld1939_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Zij noemde hem Josef; want ze sprak: Jahweh geve me nog een anderen zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Toen Rachel dan Josef had gebaard, zei Jakob tot Laban: Laat mij nu heengaan, en naar mijn stad en vaderland trekken. ");
INSERT INTO nld1939_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Geef mij mijn vrouwen en kinderen, voor wie ik u heb gediend; dan kan ik vertrekken. Want ge weet, hoe ik voor u heb gezwoegd. ");
INSERT INTO nld1939_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Maar Laban zeide hem: Laat mij genade vinden in uw ogen; want ik heb de tekens waargenomen, dat Jahweh mij om uwentwille heeft gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","En hij ging voort: Bepaal zelf het loon, dat ge van mij wilt hebben, en ik zal het u geven. ");
INSERT INTO nld1939_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Hij gaf hem ten antwoord: Gij weet, hoe ik u heb gediend, en hoe het onder mijn hoede met uw kudde is gegaan. ");
INSERT INTO nld1939_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Want vóór mijn komst was uw bezit slechts gering, maar sedert dien is het geweldig vermeerderd; Jahweh heeft u gezegend bij iedere stap, die ik zette. Wanneer zal ik nu eindelijk eens voor mijn eigen gezin kunnen zorgen? ");
INSERT INTO nld1939_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","zeide: Wat moet ik u geven? Jakob antwoordde: Ge behoeft me eigenlijk helemaal niets te geven; als ge het volgende voorstel aanvaardt, zal ik opnieuw uw kudde weiden en hoeden. ");
INSERT INTO nld1939_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ik zal vandaag uw hele kudde langs gaan, om alle gevlekte en gespikkelde geiten en alle zwarte schapen af te zonderen. Alle gespikkelde en gevlekte geiten en alle zwarte schapen zullen mijn loon zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","In mijn eerlijkheid leg ik voor later deze getuigenis af: Wanneer gij mijn loon zult komen bezien, zal alles, wat niet gevlekt en gespikkeld is onder de geiten en zwart onder de schapen, als door mij gestolen gelden. ");
INSERT INTO nld1939_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ging er op in: Goed, laat het zijn, zoals ge gezegd hebt. ");
INSERT INTO nld1939_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nog diezelfde dag zonderde Laban de gestreepte en gespikkelde bokken met alle gevlekte en gespikkelde geiten af, alles, waar maar iets wits aan was, en eveneens alle zwarte schapen, en liet ze door zijn zonen hoeden. ");
INSERT INTO nld1939_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Hij stelde een afstand van drie dagmarsen tussen hen en Jakob, die de overige kudde van Laban hoedde. ");
INSERT INTO nld1939_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Maar nu nam Jakob jonge takken van gomboom, amandel en plataan, en schilde ze zo, dat het spint van de stokken in witte strepen bloot kwam te liggen. ");
INSERT INTO nld1939_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Toen legde hij de stokken, die hij aldus van hun schors had ontdaan, vlak voor de geiten in de drinkbakken en waterbekkens, waaruit het vee kwam drinken. En als het vee dan bronstig werd, wanneer het kwam drinken, ");
INSERT INTO nld1939_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","besprong het elkaar bij de stokken, en wierp dus gestreepte, gevlekte en gespikkelde lammeren, ");
INSERT INTO nld1939_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","die door Jakob werden afgezonderd. Maar de schapen keerde hij met de koppen naar alle gevlekte en zwarte schapen van de kudde van Laban. Zo vormde hij een afzonderlijke kudde, die hij niet bij de kudde van Laban liet komen. ");
INSERT INTO nld1939_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wanneer nu de sterke beesten bronstig waren, legde Jakob de stokken voor de kudde in de drinkbakken, zodat ze elkander bij de stokken besprongen. ");
INSERT INTO nld1939_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maar bij de zwakke dieren deed hij dat niet. Op die manier kreeg Laban de zwakke dieren en Jakob de sterke. ");
INSERT INTO nld1939_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Zo werd die man buitengewoon rijk, en kreeg hij talrijke kudden, slavinnen en slaven, kamelen en ezels. ");
INSERT INTO nld1939_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakob vernam, dat de zonen van Laban zeiden: Jakob heeft zich meester gemaakt van heel het vermogen van onzen vader, en zich uit de bezittingen van onzen vader al die rijkdom verworven. ");
INSERT INTO nld1939_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ook zag Jakob aan Labans gezicht, dat hij hem niet meer zo gunstig gezind was als vroeger. ");
INSERT INTO nld1939_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Daarenboven sprak Jahweh tot Jakob: Keer terug naar het land uwer vaderen en naar uw familie; Ik zal u bijstaan. ");
INSERT INTO nld1939_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Toen zond Jakob een boodschap naar Rachel en Lea, en liet haar naar het veld bij zijn kudde roepen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Hij zeide tot haar: Ik zie, dat uw vader mij niet meer zo gunstig gezind is als vroeger; maar de God van mijn vader staat mij bij. ");
INSERT INTO nld1939_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Gij weet zelf, dat ik naar best vermogen uw vader gediend heb, ");
INSERT INTO nld1939_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ofschoon uw vader mij heeft bedrogen, en wel tienmaal mijn loon heeft gewijzigd. Maar God stond hem niet toe, mij te benadelen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wanneer hij zeide: de gevlekte dieren zullen uw loon zijn, wierp de hele kudde gevlekte jongen. En als hij zeide: de gestreepte dieren zullen uw loon zijn, wierp de hele kudde gestreepte. ");
INSERT INTO nld1939_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Zo ontnam God aan uw vader wat hij bezat, en gaf het aan mij. ");
INSERT INTO nld1939_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ook gebeurde het eens in de bronstijd der kudde, dat ik in een droom mijn ogen opsloeg en zag, hoe de gestreepte, gespikkelde en gevlekte bokken de geiten besprongen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","En de engel van Jahweh sprak tot mij in de droom: Jakob! Ik antwoordde: Hier ben ik! ");
INSERT INTO nld1939_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Hij sprak: Sla uw ogen op en zie, hoe alle bokken, die de geiten bespringen, gestreept, gespikkeld of gevlekt zijn. Want Ik heb alles gezien, wat Laban u aandoet. ");
INSERT INTO nld1939_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ik ben de God van Betel, waar gij de gedenksteen hebt gezalfd, en Mij een gelofte hebt gedaan. Maak u nu gereed, om uit dit land te vertrekken en terug te keren naar uw geboortegrond. ");
INSERT INTO nld1939_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel en Lea antwoordden hem: Hebben we soms nog deel of erfenis in het huis van onzen vader? ");
INSERT INTO nld1939_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Zijn we door hem niet als vreemden beschouwd. Ja, hij heeft ons verkocht, en bovendien onze bruidsprijs verteerd. ");
INSERT INTO nld1939_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Waarachtig, heel het vermogen, dat God onzen vader heeft ontnomen, behoort aan ons en onze kinderen. Doe dus alles wat God u gezegd heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Toen stond Jakob op, zette zijn zonen en vrouwen op kamelen, ");
INSERT INTO nld1939_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","en voerde zijn vee en al zijn have, die hij bezat, en heel het vermogen, dat hij in Paddan-Aram had verworven, met zich mee, om naar zijn vader Isaäk in het land Kanaän te vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","En terwijl Laban afwezig was, om zijn schapen te scheren, stal Rachel de terafim van haar vader. ");
INSERT INTO nld1939_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob bedroog Laban, den Arameër, door zijn vlucht voor hem verborgen te houden. ");
INSERT INTO nld1939_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Zo nam hij de wijk met alles, wat hij bezat, stak de rivier over, en sloeg de weg in naar het gebergte van Gilad. ");
INSERT INTO nld1939_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Op de derde dag kwam men Laban boodschappen, dat Jakob de vlucht had genomen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Aanstonds verzamelde hij zijn verwanten, zette hem zeven dagen lang achterna, en haalde hem bij het gebergte van Gilad in. ");
INSERT INTO nld1939_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Maar die nacht verscheen God in een droom aan Laban, den Arameër, en sprak tot hem: Pas er voor op, Jakob ook maar iets te verwijten. ");
INSERT INTO nld1939_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban had Jakob ingehaald, toen deze zijn tent had gespannen in het gebergte: en nadat ook Laban zijn tent in het gebergte Gilad had opgeslagen, ");
INSERT INTO nld1939_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","zei Laban tot Jakob: Wat hebt ge gedaan, met mij zo te bedriegen en mijn dochters weg te slepen, als waren ze geroofd met het zwaard in de vuist? ");
INSERT INTO nld1939_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Waarom zijt ge heimelijk gevlucht; waarom hebt ge mij misleid, en mij niets laten weten? Ik zou u uitgeleide hebben gedaan onder jubel en gezang, met tamboerijn en harp. ");
INSERT INTO nld1939_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ge hebt me zelfs belet, om mijn zonen en dochters vaarwel te kussen. Hoe dom hebt ge gedaan! ");
INSERT INTO nld1939_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ik heb het in mijn hand, u kwaad te doen; maar de God van uw vader zeide deze nacht tot mij: Pas er voor op, Jakob ook maar iets te verwijten. ");
INSERT INTO nld1939_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Maar als ge zijt heengegaan, enkel omdat ge zo vurig naar uw vaderlijk huis verlangt, waarom hebt ge dan mijn goden gestolen? Toen gaf Jakob Laban ten antwoord: ");
INSERT INTO nld1939_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Omdat ik bang was en dacht, dat gij mij anders met geweld uw dochters zoudt ontnemen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Maar hij, bij wien gij uw goden vindt, blijft niet in leven! Onderzoek dus in tegenwoordigheid van onze verwanten, wat er van u bij mij wordt gevonden, en neem dat mee. Want Jakob wist niet, dat Rachel ze gestolen had. ");
INSERT INTO nld1939_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban ging dus de tent van Jakob binnen, en daarna de tenten van Lea en van de beide slavinnen, maar hij vond niets. Uit de tent van Lea gekomen, ging hij de tent van Rachel binnen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maar Rachel had de terafim weggenomen, ze in het zadel van haar kameel verstopt, en was er op gaan zitten. Laban doorzocht de hele tent, maar vond niets. ");
INSERT INTO nld1939_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Want ze zei tot haar vader: Mijn heer neme het mij niet kwalijk, dat ik niet voor u kan opstaan; want het gaat me naar de wijze der vrouwen. Hoe hij ook zocht, hij vond de terafim niet. ");
INSERT INTO nld1939_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Toen ontstak Jakob in toorn, en beet Laban nijdig toe: Wat is eigenlijk mijn vergrijp en mijn misdaad, dat ge me zo verwoed achtervolgt, ");
INSERT INTO nld1939_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","en heel mijn hebben en houden doorsnuffelt? Hebt ge soms iets van uw eigen huisraad gevonden? Leg het dan neer voor mijn en uw verwanten, en laten zij tussen ons beiden beslissen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Twintig jaar lang ben ik bij u geweest. Uw schapen en geiten hebben geen misdracht gehad, de rammen van uw kudden heb ik niet opgegeten. ");
INSERT INTO nld1939_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wat door wilde dieren verscheurd werd, heb ik op u niet verhaald, maar het telkens vergoed. Van mij hebt ge terug durven eisen, wat mij des daags of des nachts werd ontstolen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Overdag verging ik van hitte en van koude des nachts, en de slaap vluchtte weg van mijn ogen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Twintig jaar lang ben ik nu in uw huis; veertien jaar diende ik u om uw twee dochters, zes jaar om uw kudde, en mijn loon hebt ge wel tienmaal veranderd. ");
INSERT INTO nld1939_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Als de God van mijn vader, de God van Abraham en de Gevreesde van Isaäk, mij niet had geholpen, dan hadt ge me nu met lege handen laten gaan. Maar God heeft mijn ellende en mijn moeizame arbeid gezien, en in de afgelopen nacht heeft Hij vonnis gewezen. ");
INSERT INTO nld1939_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Toen nam Laban het woord, en zeide tot Jakob: Het zijn mijn eigen dochters en zonen, het is mijn eigen vee, en alles wat gij hier ziet, is van mij. Hoe zou ik dan nu mijn eigen dochters leed kunnen doen, of haar zonen, die zij hebben gebaard? ");
INSERT INTO nld1939_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kom, laten we liever een verbond met elkaar sluiten; en al is er ook niemand anders bij, zie God zal getuige zijn tussen mij en u. ");
INSERT INTO nld1939_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Toen nam Jakob een steen, en richtte die als gedenkteken op. ");
INSERT INTO nld1939_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","En Jakob sprak tot zijn verwanten: Raapt stenen bijeen. Ze verzamelden dus stenen, maakten een steenhoop, en hielden daar op die steenhoop een maaltijd. ");
INSERT INTO nld1939_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban noemde hem Jegar-Sahadoeta, en Jakob noemde hem Gal-Ed. ");
INSERT INTO nld1939_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nu sprak Laban: Deze steenhoop zij heden een getuige tussen mij en u. Daarom noemde hij hem Gal-Ed ");
INSERT INTO nld1939_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","en Mispa. Want hij ging voort: Jahweh zij de Wacht tussen mij en u, wanneer we ons van elkander hebben gescheiden: ");
INSERT INTO nld1939_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","“Ge zult mijn dochters nooit mishandelen, en geen andere vrouwen nemen buiten mijn dochters”. En al is er ook niemand bij, zie, God is getuige tussen mij en u. ");
INSERT INTO nld1939_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","En Laban vervolgde tot Jakob: Zie deze steenhoop en deze gedenksteen, die ik heb opgericht, staan tussen ons in. ");
INSERT INTO nld1939_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Deze steenhoop is getuige, en getuige is ook deze gedenksteen: “Ik zal nooit voorbij deze steenhoop met kwade bedoelingen naar u toe komen, en gij voorbij deze steenhoop en deze gedenksteen niet naar mij! ");
INSERT INTO nld1939_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","De God van Abraham, en de God van Nachor moge oordelen tussen ons beiden”. En Jakob zwoer het bij den Gevreesde van Isaäk, zijn vader. ");
INSERT INTO nld1939_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nu slachtte Jakob een offerande op de berg, en nodigde zijn verwanten tot de maaltijd uit; en nadat zij hadden gegeten, bleven ze op de berg overnachten. ");
INSERT INTO nld1939_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","De volgende morgen brak Laban op, kuste zijn zonen en dochters vaarwel, zegende hen en ging heen, om naar zijn woonplaats terug te keren. ");
INSERT INTO nld1939_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Toen ook Jakob op weg was gegaan, traden hem Gods engelen tegemoet. ");
INSERT INTO nld1939_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Bij hun aanblik riep Jakob uit: Dit is het leger van God! En hij noemde die plaats Machanáim. ");
INSERT INTO nld1939_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nu zond Jakob boden voor zich uit naar zijn broer Esau in het land Seïr, dat in het gebied van Edom ligt. ");
INSERT INTO nld1939_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Hij beval hen: Aldus moet ge spreken tot Esau, mijn heer! Zo spreekt uw dienaar Jakob: “Ik heb bij Laban gewoond, en daar tot nu toe vertoefd. ");
INSERT INTO nld1939_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ik bezit runderen, ezels en schapen, slaven en slavinnen. Ik bericht dit aan mijn heer, om genade in uw ogen te vinden”. ");
INSERT INTO nld1939_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Maar de boden keerden tot Jakob terug met de tijding: Wij zijn uw broer Esau al tegen gekomen; hij trok u al met vierhonderd man tegemoet. ");
INSERT INTO nld1939_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Toen raakte Jakob in hevige angst en benauwdheid. Hij verdeelde het volk, dat hem vergezelde, met de schapen, runderen en kamelen in twee groepen. ");
INSERT INTO nld1939_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Want hij dacht: Als Esau de ene groep overvalt en verslaat, dan zal ten minste de andere ontkomen. ");
INSERT INTO nld1939_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","En Jakob sprak: O God van mijn vader Abraham en God van mijn vader Isaäk, Jahweh, die tot mij hebt gezegd: “Keer terug naar uw land en uw familie, en Ik zal u weldaden bewijzen!” ");
INSERT INTO nld1939_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ik ben alle weldaden en goedheid niet waardig, die Gij uw dienaar hebt willen bewijzen; want alleen met mijn stok trok ik over deze Jordaan, en nu bezit ik twee legerscharen. ");
INSERT INTO nld1939_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ach, red mij toch uit de hand van mijn broer, uit Esau’s hand; want ik ben bang, dat hij komt, om mij met moeder en kinderen te doden. ");
INSERT INTO nld1939_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gij hebt mij toch beloofd: “Ik zal u overvloedige gunsten bewijzen, en uw nageslacht maken als het zand aan de zee, dat niemand vanwege de massa kan tellen”. ");
INSERT INTO nld1939_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Terwijl hij daar die nacht nog verbleef, nam hij uit wat hij bezat een geschenk voor zijn broer Esau: ");
INSERT INTO nld1939_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","twee honderd geiten en twintig bokken, twee honderd schapen en twintig rammen, ");
INSERT INTO nld1939_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","dertig zogende kamelen met haar jongen, veertig koeien en tien stieren, twintig ezelinnen en tien ezelsveulens. ");
INSERT INTO nld1939_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Elke kudde afzonderlijk vertrouwde hij aan een zijner slaven toe, en zeide hun: Trekt voor mij uit, en laat een afstand open tussen de verschillende kudden. ");
INSERT INTO nld1939_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","En hij beval aan den eersten: Wanneer mijn broer Esau u ontmoet en u vraagt: “wien behoort ge toe, waar gaat ge heen, en van wien is dit alles, wat gij voor u uitdrijft?” ");
INSERT INTO nld1939_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","dan moet ge antwoorden: “Het is van Jakob, uw dienaar; het is een geschenk, dat hij zendt aan Esau, mijn heer; zie, hij zelf komt achter ons aan.” ");
INSERT INTO nld1939_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ook den tweeden, den derden en allen, die achter de kudde liepen, beval hij: Ge moet juist hetzelfde zeggen, als ge Esau ontmoet; ");
INSERT INTO nld1939_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","en ge voegt er ook nog aan toe: “Zie, uw dienaar Jakob komt achter ons aan”. Want hij dacht: ik wil hem eerst door het geschenk, dat mij vooruitgaat, verzoenen, en hem dan onder de ogen komen; misschien dat hij mij dan genadig behandelt. ");
INSERT INTO nld1939_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Zo trok het geschenk voor hem uit, terwijl hij zelf die nacht in de legerplaats bleef. ");
INSERT INTO nld1939_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Maar nog in diezelfde nacht stond hij op, nam zijn twee vrouwen, zijn beide slavinnen en zijn elf zonen, en stak het wed van de Jabbok over. ");
INSERT INTO nld1939_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Hij nam ze mee, en zette ze over de stroom; ook heel zijn bezit bracht hij naar de overkant. ");
INSERT INTO nld1939_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakob zelf bleef alleen achter, en een man worstelde met hem tot het morgenrood rees. ");
INSERT INTO nld1939_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Toen deze zag, dat hij hem niet kon overwinnen, stiet hij hem tegen de bovenheup, zodat de heup van Jakob bij de worsteling werd ontwricht. ");
INSERT INTO nld1939_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nu sprak de man: Laat mij gaan, want het morgenrood rijst. Maar hij antwoordde: Ik laat u niet gaan, tenzij ge mij zegent. ");
INSERT INTO nld1939_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Hij sprak tot hem: Hoe is uw naam? Hij antwoordde: Jakob. ");
INSERT INTO nld1939_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hij zeide toen: Voortaan zult ge geen Jakob meer heten, maar Israël; want ge hebt met God en met mensen gestreden, en de overwinning behaald. ");
INSERT INTO nld1939_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nu vroeg Jakob: Zeg mij uw naam! Hij sprak: Hoe vraagt ge nog naar mijn naam. Toen gaf hij hem daar zijn zegen. ");
INSERT INTO nld1939_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob noemde die plaats Penoeël; want ik heb God gezien van aanschijn tot aanschijn, en ben toch in leven gebleven! ");
INSERT INTO nld1939_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","De zon ging juist op, toen hij Penoeël voorbij was. Hij bleef echter mank aan zijn heup. ");
INSERT INTO nld1939_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Daarom eten tot heden toe de zonen Israëls de heupspier niet, die aan de bovenheup ligt; want hij had Jakob tegen de bovenheup gestoten, tegen de spier van het heupgewricht. ");
INSERT INTO nld1939_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nu sloeg Jakob zijn ogen op en keek rond; en zie, daar kwam Esau aan met vierhonderd man. Toen verdeelde hij zijn kinderen onder Lea, Rachel en zijn beide slavinnen. ");
INSERT INTO nld1939_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","De slavinnen met haar kinderen plaatste hij voorop, Lea met haar kinderen daar achter, en Rachel met Josef achteraan. ");
INSERT INTO nld1939_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Zelf stelde hij zich aan hun spits, boog zich zevenmaal ter aarde neer, tot hij zijn broer genaderd was. ");
INSERT INTO nld1939_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Maar Esau snelde hem tegemoet, en omhelsde hem; hij viel hem om de hals, en kuste hem wenend. ");
INSERT INTO nld1939_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Toen hij zijn ogen opsloeg en de vrouwen met de kinderen zag, vroeg hij: Wie hebt ge daar? Hij antwoordde: Het zijn de kinderen, die het God heeft behaagd, aan uw dienaar te schenken. ");
INSERT INTO nld1939_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nu traden de slavinnen met haar kinderen naar voren, en bogen zich voor hem neer. ");
INSERT INTO nld1939_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ook Lea trad met haar kinderen vooruit, en boog zich neer; daarna kwamen ook Josef en Rachel, en bogen zich neer. ");
INSERT INTO nld1939_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Toen sprak hij: Wat moet ge met heel dat leger, dat ik heb ontmoet? Hij antwoordde: Genade vinden in de ogen van mijn heer! ");
INSERT INTO nld1939_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Maar Esau hernam: Ik bezit meer dan genoeg, mijn broeder; behoud wat ge hebt. ");
INSERT INTO nld1939_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob hield aan: Neen, als ik genade gevonden heb in uw ogen, neem dan het geschenk van mij aan; want, daar gij vriendelijk voor mij waart, heb ik uw gelaat gezien, zoals men Gods aanschijn aanschouwt. ");
INSERT INTO nld1939_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Wil toch het blijk van mijn hulde aanvaarden, dat ik u heb aangeboden; want God is mij genadig geweest, zodat ik overvloed heb. Toen hij zo bij hem aandrong, nam hij het aan. ");
INSERT INTO nld1939_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Daarop sprak: Laten we opbreken en verder trekken; ik zal u dan begeleiden. ");
INSERT INTO nld1939_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Maar hij antwoordde: Mijn heer, gij ziet, dat de kinderen nog zwak zijn. Bovendien moet ik voor de schapen en zogende runderen zorgen; als die één dag te veel gejaagd worden, gaat heel de kudde te gronde. ");
INSERT INTO nld1939_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Laat dus mijn heer zijn dienaar vooruitgaan; ik zal op mijn gemak mijn tocht vervolgen in de pas van het vee, dat voor mij uittrekt, en in de pas van de kinderen, tot ik in Seïr kom bij mijn heer. ");
INSERT INTO nld1939_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau hernam: Dan zal ik tenminste enkele van de mannen, die mij vergezellen, te uwer beschikking stellen. Maar hij antwoordde: Waar is dat voor nodig; als ik maar genade vind in de ogen van mijn heer? ");
INSERT INTO nld1939_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Zo keerde Esau nog diezelfde dag naar Seïr terug. ");
INSERT INTO nld1939_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Maar Jakob trok naar Soekkot; hij bouwde daar een huis voor zichzelf, en maakte er hutten voor zijn vee. Daarom wordt die plaats Soekkot genoemd. ");
INSERT INTO nld1939_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Na zijn terugkeer uit Paddan-Aram kwam Jakob behouden aan in de stad Sikem, die in het land Kanaän ligt, en legerde zich ten oosten der stad. ");
INSERT INTO nld1939_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Voor honderd goudstukken kocht hij van de zonen van Hemor, den vader van Sikem, de strook grond, waarop hij zijn tent had gespannen. ");
INSERT INTO nld1939_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Hij richtte daar een altaar op, en riep den God van Israël aan. ");
INSERT INTO nld1939_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Eens ging Dina, de dochter, die Lea aan Jakob had gebaard, uit, om de meisjes van het land te bezoeken. ");
INSERT INTO nld1939_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sikem, de zoon van Hemor, den Chiwwiet, en vorst van dat land, zag haar; hij schaakte haar, ging met haar slapen en verkrachtte haar. ");
INSERT INTO nld1939_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Maar daar Sikem zijn hart aan Dina, de dochter van Jakob, had verloren, het meisje beminde en het vriendelijk bejegende, ");
INSERT INTO nld1939_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","zei hij tot zijn vader Hemor: Neem mij dat meisje tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nu had Jakob wel gehoord, dat zijn dochter Dina onteerd was; maar omdat zijn zonen met de kudde in het veld waren, hield Jakob zich stil tot hun terugkomst. ");
INSERT INTO nld1939_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hemor, de vader van Sikem, ging dus naar Jakob, om eens met hem te spreken. ");
INSERT INTO nld1939_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Intussen waren de zonen van Jakob van het land teruggekeerd. Toen de mannen vernamen, wat er gebeurd was, werden ze verontwaardigd en ontstaken in hevige toorn; door de dochter van Jakob te verkrachten, was er een schanddaad aan Israël begaan. Zo iets was er nog nooit gebeurd. ");
INSERT INTO nld1939_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hemor sprak tot hen: Mijn zoon Sikem hangt met heel zijn hart aan uw dochter; geef haar dus aan hem tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Laten we onder elkander huwen; geeft uw dochters aan ons, en neemt gij de onzen. ");
INSERT INTO nld1939_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ge kunt gerust bij ons blijven wonen; het land ligt voor u open. Blijft hier; trekt er rond, of neemt er een vaste woonplaats. ");
INSERT INTO nld1939_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","En Sikem zeide tot haar vader en haar broeders: Als ik genade vind in uw ogen, zal ik u geven, wat gij vraagt. ");
INSERT INTO nld1939_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ge moogt de bruidsprijs en het geschenk verhogen, zoveel ge wilt; ik geef wat ge mij vraagt; maar geeft me het meisje tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Toen gaven de zonen van Jakob, wier zuster Dina onteerd was, aan Sikem en aan zijn vader Hemor een listig antwoord. ");
INSERT INTO nld1939_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ze zeiden: Wij kunnen daar niet op ingaan; we mogen onze zuster niet aan een onbesnedene geven, want dat is een schande voor ons. ");
INSERT INTO nld1939_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Alleen op deze voorwaarde geven wij u onze toestemming: ge moet alle mannen onder u laten besnijden, zoals wij zijn besneden. ");
INSERT INTO nld1939_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dan zullen wij u onze dochters geven, en wij de uwe nemen, bij u blijven wonen, en één volk met u vormen. ");
INSERT INTO nld1939_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Maar wanneer ge hierop niet ingaat, nemen we onze dochters mee en gaan heen. ");
INSERT INTO nld1939_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hun voorstel beviel aan Hemor en aan zijn zoon Sikem, ");
INSERT INTO nld1939_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","en de jonge man draalde niet, het ten uitvoer te brengen. Want de dochter van Jakob behaagde hem; ook had hij de meeste invloed in de familie. ");
INSERT INTO nld1939_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hemor en zijn zoon Sikem gingen dus naar de stadspoort, en spraken tot hun medeburgers: ");
INSERT INTO nld1939_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Deze mannen zijn ons vreedzaam gezind. Zij willen in het land blijven wonen, en er in rondtrekken; want het land biedt hun aan alle kanten ruimte genoeg. Laten wij hun dochters tot vrouw nemen, en de onzen aan hen geven. ");
INSERT INTO nld1939_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maar alleen onder deze voorwaarde willen die mannen onder ons blijven wonen, en één volk met ons vormen: wij moeten alle mannen onder ons laten besnijden, zoals zij zelf besneden zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dan zal hun bezit, hun have en al hun vee ons eigendom worden. We hoeven slechts op hun voorstel in te gaan, dan blijven ze bij ons. ");
INSERT INTO nld1939_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Alle medeburgers van Hemor en zijn zoon Sikem stemden er in toe, en alle mannen van de stad lieten zich besnijden. ");
INSERT INTO nld1939_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Maar op de derde dag, toen zij met wondkoorts lagen, grepen Simeon en Levi, de twee zonen van Jakob en broers van Dina, hun zwaard, overvielen de stad, die zich in veiligheid waande en vermoordden alle mannen. ");
INSERT INTO nld1939_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ook Hemor en zijn zoon Sikem joegen zij over de kling, haalden Dina uit het huis van Sikem, en trokken af. ");
INSERT INTO nld1939_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nadat de zonen van Jakob zo de zieken hadden overvallen, plunderden ze de stad, omdat men hun zuster had onteerd. ");
INSERT INTO nld1939_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hun schapen, hun runderen en ezels, met alles wat in de stad was of wat op het land stond, roofden ze weg. ");
INSERT INTO nld1939_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Al hun bezittingen met alle kinderen en vrouwen voerden ze mee, en alles wat in de huizen was, maakten ze buit. ");
INSERT INTO nld1939_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Maar Jakob sprak tot Simeon en Levi: Gij stort mij in het ongeluk, door mij in kwade reuk te brengen bij de bewoners van het land, de Kanaänieten en de Perizzieten. Ik heb maar weinig volk; als zij dus tegen mij samenspannen en mij overvallen, word ik met mijn gezin vernietigd. ");
INSERT INTO nld1939_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Zij gaven ten antwoord: Mocht hij dan onze zuster als een deerne behandelen? ");
INSERT INTO nld1939_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nu sprak God tot Jakob: Sta op, vertrek naar Betel, en vestig u daar. Richt daar een altaar op voor den God, die u is verschenen, toen ge op de vlucht waart voor uw broer Esau. ");
INSERT INTO nld1939_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Daarom sprak Jakob tot zijn gezin en tot allen, die hem vergezelden: Verwijdert de vreemde goden, die ge bij u hebt; reinigt u en verwisselt van kleren. ");
INSERT INTO nld1939_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Dan trekken we naar Betel op, waar ik een altaar zal bouwen voor den God, die mij heeft verhoord op de dag van mijn ellende, en die met mij was op de weg, die ik ging. ");
INSERT INTO nld1939_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Toen leverden zij aan Jakob alle vreemde goden uit, die in hun bezit waren, met de ringen, die ze in de oren droegen; en Jakob begroef ze onder de eik, die bij Sikem stond. ");
INSERT INTO nld1939_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Daarna trokken zij op. En de schrik Gods kwam over alle steden in het rond, zodat men de zonen van Jakob niet durfde achtervolgen. ");
INSERT INTO nld1939_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Zo kwam Jakob met al het volk, dat hem vergezelde, te Loez, ook Betel genoemd, dat in het land Kanaän ligt. ");
INSERT INTO nld1939_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Hij bouwde daar een altaar, en noemde die plaats Betel, omdat God zich daar aan hem had geopenbaard, toen hij op de vlucht was voor zijn broer. ");
INSERT INTO nld1939_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Daar stierf Debora, de voedster van Rebekka; zij werd begraven bij Betel onder de eik, die hij daarom Klaageik noemde. ");
INSERT INTO nld1939_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Toen Jakob dus uit Paddan-Aram was teruggekeerd, verscheen God hem opnieuw, en zegende hem. ");
INSERT INTO nld1939_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","En God sprak tot hem: Uw naam is Jakob; voortaan zult ge geen Jakob meer heten, maar Israël zult ge worden genoemd. Zo gaf Hij hem de naam Israël. ");
INSERT INTO nld1939_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","En God sprak tot hem: Ik ben de almachtige God! Wees vruchtbaar en vermenigvuldig u. Een volk, een reeks van volken komt uit u voort, En koningen zullen uw lendenen ontspruiten. ");
INSERT INTO nld1939_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Het land, dat Ik aan Abraham en Isaäk schonk, Zal Ik geven aan u; En aan uw kroost na u Geef Ik dit land in bezit! ");
INSERT INTO nld1939_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Toen steeg God op, en verdween uit zijn ogen. ");
INSERT INTO nld1939_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob stichtte een stenen gedenkteken op de plaats, waar Hij met hem had gesproken, stortte er een plengoffer op, en goot er olie over uit. ");
INSERT INTO nld1939_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","En Jakob noemde de plaats, waar God met hem had gesproken, Betel. ");
INSERT INTO nld1939_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Toen ze nu ook van Betel waren opgetrokken, en nog slechts op korte afstand van Efráta waren, beviel Rachel en had een zware verlossing. ");
INSERT INTO nld1939_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","En terwijl ze in zware barensnood lag, sprak de vroedvrouw tot haar: Wees maar niet bang; want ook ditmaal hebt ge een zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Onder het sterven nog, want ze ging dood, noemde ze hem Ben-Oni; maar zijn vader noemde hem Benjamin. ");
INSERT INTO nld1939_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Zo stierf Rachel; zij werd begraven op de weg naar Efráta of Betlehem. ");
INSERT INTO nld1939_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakob plaatste een gedenkteken op haar graf; dit grafmonument van Rachel staat er tot op de huidige dag. ");
INSERT INTO nld1939_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israël trok nu verder, en spande zijn tent voorbij Migdal-Éder. ");
INSERT INTO nld1939_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Terwijl Israël in deze streek vertoefde, hield Ruben gemeenschap met Bilha, de bijvrouw van zijn vader. Toen Israël het vernam, was hij er hoogst verontwaardigd over. De zonen van Jakob waren twaalf in getal. ");
INSERT INTO nld1939_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","De zonen van Lea waren: Ruben, Jakobs eerstgeborene, Simeon, Levi, Juda, Issakar en Zabulon. ");
INSERT INTO nld1939_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","De zonen van Rachel: Josef en Benjamin. ");
INSERT INTO nld1939_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","De zonen van Bilha, de slavin van Rachel: Dan en Neftali. ");
INSERT INTO nld1939_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","De zonen van Zilpa, de slavin van Lea: Gad en Aser. Dit waren de zonen van Jakob, die hem geboren waren in Paddan-Aram. ");
INSERT INTO nld1939_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Zo bereikte Jakob zijn vader Isaäk te Mamre bij Kirjat-Arba, of Hebron, waar Abraham en Isaäk zich hadden gevestigd. ");
INSERT INTO nld1939_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","En toen Isaäk honderd tachtig jaar oud was, ");
INSERT INTO nld1939_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","gaf hij de geest en stierf; oud en afgeleefd werd hij bij zijn volk verzameld. Zijn zonen Esau en Jakob begroeven hem. ");
INSERT INTO nld1939_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dit zijn de nakomelingen van Esau of Edom. ");
INSERT INTO nld1939_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau had zich de volgende vrouwen uit de kanaänietische meisjes genomen: Ada, de dochter van den Chittiet Elon; Oholibama, de dochter van Ana, de kleindochter van den Chiwwiet Sibon; ");
INSERT INTO nld1939_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemat, de dochter van Jisjmaël, de zuster van Nebajot. ");
INSERT INTO nld1939_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada baarde aan Esau Elifaz; Basemat Reoeël; ");
INSERT INTO nld1939_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama baarde Jeoesj, Jalam en Kórach. Dit zijn de zonen van Esau, die hem in het land Kanaän werden geboren. ");
INSERT INTO nld1939_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Daarna nam Esau zijn vrouwen, zonen en dochters en allen, die tot zijn gezin behoorden, met zijn kudde, runderen en al de bezittingen, die hij in het land Kanaän verworven had, en trok van zijn broer Jakob weg naar een ander land. ");
INSERT INTO nld1939_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Want zij bezaten te veel, om bij elkander te blijven; het land, waar zij woonden, kon hen wegens hun kudden niet onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau of Edom ging zich dus in het gebergte Seïr vestigen. ");
INSERT INTO nld1939_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dit is de geslachtslijst van Esau, den vader van Edom, in het gebergte Seïr. ");
INSERT INTO nld1939_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dit zijn de namen van Esau’s zonen: Elifaz, de zoon van Esau’s vrouw Ada; Reoeël, de zoon van Esau’s vrouw Basemat. ");
INSERT INTO nld1939_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","De zonen van Elifaz waren Teman, Omar, Sefo, Gatam en Kenaz. ");
INSERT INTO nld1939_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna was een bijvrouw van Esau’s zoon Elifaz, en zij baarde aan Elifaz Amalek. Dit waren dus zonen van Esau’s vrouw Ada. ");
INSERT INTO nld1939_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Dit waren de zonen van Reoeël: Náchat en Zérach, Sjamma en Mizza. Ze waren dus zonen van Esau’s vrouw Basemat. ");
INSERT INTO nld1939_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dit waren de zonen van Esau’s vrouw Oholibama, de dochter van Ana, en kleindochter van Sibon. Zij baarde aan Esau Jeoesj, Jalam en Kórach. ");
INSERT INTO nld1939_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dit zijn de stamhoofden van Esau’s zonen: De zonen van Elifaz, den eerstgeborene van Esau, zijn de stamhoofden van Teman, Omar, Sefo en Kenaz, ");
INSERT INTO nld1939_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kórach, Gatam en Amalek. Ze zijn de stamhoofden van de groep Elifaz in het land Edom. Ze zijn zonen van Ada. ");
INSERT INTO nld1939_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Dit zijn de zonen van Esau’s zoon Reoeël: De stamhoofden van Náchat, Zérach, Sjamma en Mizza. Ze zijn de stamhoofden van de groep Reoeël in het land van Edom. Ze zijn zonen van Esau’s vrouw Basemat. ");
INSERT INTO nld1939_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dit zijn de zonen van Esau’s vrouw Oholibama. De stamhoofden van Jeoesj, Jalam en Kórach. Ze zijn de stamhoofden van de groep Oholibama, de dochter van Ana, de vrouw van Esau. ");
INSERT INTO nld1939_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dit zijn dus de zonen van Esau of Edom met hun stamhoofden. ");
INSERT INTO nld1939_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","En dit zijn de zonen van den Choriet Seïr, de eigenlijke bewoners van het land: Lotan, Sjobal, Sibon, en Ana. ");
INSERT INTO nld1939_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Verder Disjon, Éser en Disjan. Ze zijn de stamhoofden van de Chorieten, de zonen van Seïr, in het land Edom. ");
INSERT INTO nld1939_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","De zonen van Lotan waren Chori en Hemam; de zuster van Lotan was Timna. ");
INSERT INTO nld1939_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Dit zijn de zonen van Sjobal: Alwan, Manáchat, Ebal, Sjefo en Onam. ");
INSERT INTO nld1939_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Dit zijn de zonen van Sibon: Ajja en Ana; dit is de Ana, die de hete bronnen vond in de woestijn, toen hij de ezels van zijn vader Sibon weidde. ");
INSERT INTO nld1939_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Dit zijn de kinderen van Ana: Disjon en Oholibama, de dochter van Ana. ");
INSERT INTO nld1939_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dit zijn de zonen van Disjon: Chemdan, Esjban, Jitran en Keran. ");
INSERT INTO nld1939_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dit zijn de zonen van Éser: Bilhan, Zaäwan en Akan. ");
INSERT INTO nld1939_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dit zijn de zonen van Disjan: Oes en Aran. ");
INSERT INTO nld1939_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dit zijn dus de stamhoofden van de Chorieten: de stamhoofden van Lotan, Sjobal, Sibon, Ana, ");
INSERT INTO nld1939_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disjon, Éser en Disjan. Het zijn de stamhoofden van de verschillende chorietische stammen in het land Seïr. ");
INSERT INTO nld1939_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","En dit zijn de koningen, die over het land Edom regeerden, eer er een koning heerste over de zonen Israëls. ");
INSERT INTO nld1939_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, de zoon van Beor regeerde in Edom; zijn hofstad heette Dinhaba. ");
INSERT INTO nld1939_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Na de dood van Béla regeerde Jobab, de zoon van Zérach uit Bosra in zijn plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Na de dood van Jobab regeerde Choesjam uit het land der Temanieten in zijn plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Na de dood van Choesjam regeerde Hadad, de zoon van Bedad in zijn plaats. Hij was het, die Midjan in de vlakten van Moab versloeg; zijn stad heette Awit. ");
INSERT INTO nld1939_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Na de dood van Hadad regeerde Samla uit Masreka in zijn plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Na de dood van Samla regeerde Sjaoel uit Rechobot aan de rivier in zijn plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Na de dood van Sjaoel regeerde Báal-Chanan, de zoon van Akbor in zijn plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Na de dood van Báal-Chanan, den zoon van Akbor, regeerde Hadar in zijn plaats zijn hofstad heette Paoe. Zijn vrouw heette Mehetabel, en was de dochter van Matred en kleindochter van Me-Zahab. ");
INSERT INTO nld1939_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","En dit zijn de namen van de stamhoofden van Esau volgens hun familie, en naar de naam van hun woonplaats. De stamhoofden van Timna, Alwa en Jetet, ");
INSERT INTO nld1939_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela en Pinon, ");
INSERT INTO nld1939_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman en Mibsar, ");
INSERT INTO nld1939_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiël en Iram. Dit zijn dus de stamhoofden van Edom volgens hun woonplaats in het land, dat zij in bezit hadden genomen. Tot zover over Esau, den stamvader van Edom. ");
INSERT INTO nld1939_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob bleef in het land Kanaän wonen, waar ook zijn vader had vertoefd. ");
INSERT INTO nld1939_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","En dit is de familiegeschiedenis van Jakob: Toen Josef zeventien jaar oud en dus nog een knaap was, en hij met zijn broers, met de zonen van Bilha en de zonen van Zilpa, de vrouwen van zijn vader, de kudde weidde, bracht hij de kwade geruchten, die over hen liepen, aan hun vader over. ");
INSERT INTO nld1939_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ook hield Israël meer van Josef dan van zijn andere zonen, omdat hij hem nog op zijn oude dag geboren was; daarom liet hij hem een kleurig gewaad maken. ");
INSERT INTO nld1939_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Toen zijn broeders dus bemerkten, dat hun vader hem meer beminde dan al zijn broers, begonnen zij hem te haten, en gunden hem geen vriendelijk woord meer. ");
INSERT INTO nld1939_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bovendien had Josef eens een droom, die hij aan zijn broers vertelde, met het gevolg, dat zij hem nog meer gingen haten. ");
INSERT INTO nld1939_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Hij sprak tot hen: Luistert eens naar de droom, die ik heb gehad. ");
INSERT INTO nld1939_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ziet, wij waren op het veld aan het schoven binden, toen mijn schoof overeind rees en recht bleef staan, terwijl uw schoven zich er omheen plaatsten, en voor de mijne begonnen te buigen. ");
INSERT INTO nld1939_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Maar zijn broers zeiden tot hem: Wilt ge soms koning over ons worden, of over ons heersen? En ze haatten hem nog meer om die droom, die hij had verhaald. ");
INSERT INTO nld1939_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Later had hij nog een andere droom, die hij eveneens aan zijn broers vertelde. Hij sprak: Ik heb een nieuwe droom gehad. Zie, de zon, de maan en elf sterren bogen zich voor mij neer. ");
INSERT INTO nld1939_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Maar toen hij dit aan zijn vader en zijn broers vertelde, berispte hem zijn vader en zei: Wat moet dat met die droom, die ge gehad hebt; moeten ik, uw moeder en broers ons soms voor u ter aarde komen buigen? ");
INSERT INTO nld1939_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Maar terwijl zijn broers nijdig op hem bleven, prentte zijn vader dat verhaal in zijn geheugen. ");
INSERT INTO nld1939_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nu gebeurde het eens, dat zijn broers naar Sikem waren gegaan, om de kudden van hun vader te weiden. ");
INSERT INTO nld1939_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Toen sprak Israël tot Josef: De broers zijn in Sikem de kudden aan het weiden; ik wilde u er wel eens heen zenden. Hij antwoordde: Heel goed! ");
INSERT INTO nld1939_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Hij hernam: Ga dan eens zien, of alles in orde is met uw broers en ook met het vee, en kom het mij dan vertellen. Zo zond hij hem uit de vallei van Hebron op pad. Toen hij bij Sikem was gekomen, ");
INSERT INTO nld1939_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","en daar in de velden ronddoolde, ontmoette hem iemand, die hem vroeg, wat hij zocht. ");
INSERT INTO nld1939_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Hij antwoordde: Ik ben op zoek naar mijn broers; kunt ge me zeggen, waar zij hun kudde weiden? ");
INSERT INTO nld1939_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","De man gaf ten antwoord: Zij zijn van hier weg; want ik heb ze horen zeggen, dat ze naar Dotan wilden gaan. Josef ging dus zijn broers achterna, en trof hen in Dotan. ");
INSERT INTO nld1939_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Zij zagen hem al uit de verte. En eer hij hen nog had bereikt, hadden ze al het plan beraamd, hem te doden. ");
INSERT INTO nld1939_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ze zeiden tot elkander: Zie, daar komt de dromer aan! ");
INSERT INTO nld1939_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Vooruit nu, laten we hem vermoorden, in een van de putten gooien, en zeggen, dat een wild beest hem heeft verslonden; dan zullen we eens zien, wat er van zijn dromen terecht komt. ");
INSERT INTO nld1939_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Toen Ruben dit hoorde, wilde hij hem uit hun handen redden. Daarom zei hij: We moeten hem niet om het leven brengen. ");
INSERT INTO nld1939_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","En Ruben vervolgde: Ge moet geen bloed vergieten; werpt hem liever in die put daar, in de woestijn, maar raakt hem niet aan. Zo wilde hij hem aan hun handen onttrekken, om hem naar zijn vader terug te brengen. ");
INSERT INTO nld1939_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Toen Josef dan bij zijn broers was gekomen, trokken zij hem het veelkleurig kleed uit, dat hij aanhad, ");
INSERT INTO nld1939_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","grepen hem vast, en wierpen hem in de put. De put was leeg, en er stond geen water in. ");
INSERT INTO nld1939_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Terwijl ze daarna zaten te eten, keken ze op, en bemerkten een karavaan van Jisjmaëlieten, die van Gilad kwam; hun kamelen waren belast met gom, balsem en hars, en waren op weg naar Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nu zei Juda tot zijn broers: Wat hebben we er aan, onzen broer te vermoorden en zijn bloed te bedekken? ");
INSERT INTO nld1939_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Laten we hem liever aan de Jisjmaëlieten verkopen en niet onze handen aan hem slaan; want hij is toch onze broer en ons eigen vlees. Zijn broers stemden er in toe. ");
INSERT INTO nld1939_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","En toen de midjanietische kooplieden voorbijkwamen, trokken zij Josef uit de put omhoog, en verkochten hem voor twintig zilverstukken aan de Jisjmaëlieten, die Josef naar Egypte voerden. ");
INSERT INTO nld1939_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Toen Ruben weer naar de put kwam, maar Josef niet meer in de put was, scheurde hij zijn kleren. ");
INSERT INTO nld1939_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hij liep terug naar zijn broers, en riep: De jongen is weg, wat moet ik nu gaan beginnen! ");
INSERT INTO nld1939_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nu namen zij het kleed van Josef, slachtten een geitebokje, en doopten het kleed in het bloed. ");
INSERT INTO nld1939_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ze stuurden het kleurige kleed naar hun vader, en lieten hem zeggen: Dit hebben we gevonden; zie eens, of dit het kleed van uw zoon is, of niet? ");
INSERT INTO nld1939_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Hij herkende het en zei: Het is het kleed van mijn zoon; een wild beest heeft hem verslonden; ach, Josef is in stukken gescheurd! ");
INSERT INTO nld1939_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","En Jakob scheurde zijn kleren, deed een zak om zijn lenden, en treurde lange tijd om zijn zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Al zijn zonen en dochters kwamen hem troosten; maar hij wilde geen troost. Want hij sprak: Treurend daal ik naar mijn zoon in het dodenrijk af. Zo bleef zijn vader om hem wenen. ");
INSERT INTO nld1939_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Intussen hadden de Midjanieten Josef in Egypte verkocht aan Potifar, een hoveling van Farao, en overste van de lijfwacht. ");
INSERT INTO nld1939_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Omstreeks diezelfde tijd verliet Juda zijn broers, en begaf zich naar een man in Adoellam, Chira genaamd. ");
INSERT INTO nld1939_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Daar zag Juda de dochter van een Kanaäniet, die Sjóea heette; hij nam haar tot vrouw, en hield gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Zij werd zwanger, en baarde een zoon, dien ze Er noemde. ");
INSERT INTO nld1939_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Zij werd nog eens zwanger, en baarde een zoon, dien zij de naam Onan gaf. ");
INSERT INTO nld1939_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Daarna baarde zij nog een zoon, dien zij Sjela noemde. Zij bevond zich te Kezib, toen zij hem baarde. ");
INSERT INTO nld1939_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Later nam Juda voor Er, zijn eerstgeborene, een vrouw, Tamar geheten. ");
INSERT INTO nld1939_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Maar Er, de eerstgeborene van Juda, was slecht in de ogen van Jahweh, zodat Jahweh hem deed sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Toen zeide Juda tot Onan: Ga naar de vrouw van uw broer, sluit een zwagerhuwelijk met haar, en zorg dat ge kinderen verwekt voor uw broer. ");
INSERT INTO nld1939_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Maar Onan, die wist, dat die kinderen niet aan hem zouden behoren, liet telkens, als hij tot zijn schoonzuster kwam, het zaad op de grond verloren gaan, om geen kinderen voor zijn broer te verwekken. ");
INSERT INTO nld1939_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Zijn gedrag was slecht in de ogen van Jahweh; zodat Hij ook hem liet sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Toen sprak Juda tot zijn schoondochter Tamar: Blijf als weduwe in uw vaderlijk huis, tot mijn zoon Sjela volwassen is. Want hij dacht: anders zal ook hij sterven evenals zijn broers. En Tamar ging heen, en bleef in het huis van haar vader wonen. ");
INSERT INTO nld1939_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Geruime tijd later stierf de dochter van Sjóea, Juda’s vrouw. Toen de rouwtijd voorbij was, ging Juda eens in gezelschap van zijn vriend Chira uit Adoellam naar Timna, om zijn schapenscheerders te bezoeken. ");
INSERT INTO nld1939_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Men bracht Tamar het bericht: Uw schoonvader komt naar Timna, om zijn schapen te scheren. ");
INSERT INTO nld1939_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Nu legde zij haar weduwkleed af, hulde zich in een sluier, en ging vermomd bij de poort van Enáim zitten, dat op de weg naar Timna ligt. Want zij wist, dat Sjela groot was geworden, en zij hem toch niet tot vrouw werd gegeven. ");
INSERT INTO nld1939_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Toen Juda haar zag, hield hij haar voor een deerne, omdat zij haar gelaat had gesluierd. ");
INSERT INTO nld1939_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Hij verliet de weg, ging naar haar toe en sprak: Kom, ik wil met u mee. Hij wist immers niet, dat het zijn schoondochter was. Zij antwoordde: Wat geeft ge mij, als ge bij me moogt komen? ");
INSERT INTO nld1939_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Hij zeide: Ik zal u een geitebokje van de kudde sturen. Zij antwoordde: Als ge een pand geeft, tot ge het mij hebt gestuurd. ");
INSERT INTO nld1939_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Hij hernam: Wat voor een pand moet ik u geven? Zij antwoordde: Uw zegel met snoer en de staf, die ge in uw hand hebt. Hij gaf ze haar, hield gemeenschap met haar, en zij ontving van hem. ");
INSERT INTO nld1939_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nu stond zij op, en ging heen; ze legde haar sluier af en trok haar weduwkleed weer aan. ");
INSERT INTO nld1939_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Toen Juda nu door zijn vriend uit Adoellam een geitebokje liet brengen, om het pand uit de handen van de vrouw terug te krijgen, vond deze haar niet. ");
INSERT INTO nld1939_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hij ondervroeg de bewoners van die plaats: Waar is de deerne, die hier bij Enáim langs de weg zit? Maar zij antwoordden: Er is hier geen deerne. ");
INSERT INTO nld1939_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Toen keerde hij naar Juda terug, en zeide: Ik heb haar niet kunnen vinden; en de mensen van die plaats beweren, dat daar nooit een deerne geweest is. ");
INSERT INTO nld1939_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda sprak: Dan moet zij pand maar houden; we kunnen ons toch niet uit laten lachen. Ik heb het bokje gestuurd, maar gij hebt haar niet kunnen vinden. ");
INSERT INTO nld1939_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ongeveer drie maanden later werd aan Juda bericht: Uw schoondochter Tamar heeft ontucht bedreven, en is zwanger geworden. Juda sprak: Brengt ze naar buiten, om ze te verbranden! ");
INSERT INTO nld1939_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Reeds werd ze naar buiten geleid, toen ze haar schoonvader liet zeggen: Van den man, aan wien deze dingen behoren, heb ik ontvangen. En zij liet er aan toevoegen: Kijk eens goed, wien dit zegel met snoer en die staf toebehoren. ");
INSERT INTO nld1939_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda herkende ze en sprak: Zij is tegenover mij in haar recht; want ik heb haar niet aan mijn zoon Sjela gegeven. Maar hij hield verder geen gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Toen de tijd van haar verlossing nabij was, bleek er een tweeling in haar schoot te zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tijdens de verlossing stak er een zijn handje uit. De vroedvrouw greep het vast, bond er een purperen draad om, en zeide: Deze is het eerst gekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Maar hij trok zijn handje terug, en toen kwam zijn broertje te voorschijn. Nu sprak ze: Wat voor een bres hebt gij u gemaakt! En zij noemde hem Fares. ");
INSERT INTO nld1939_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Daarna kwam zijn broertje, die de purperen draad om zijn handje had, en zij noemde hem Zara. ");
INSERT INTO nld1939_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josef was dus naar Egypte gevoerd, waar de Egyptenaar Potifar, een hoveling van Farao en overste van de lijfwacht, hem van de Jisjmaëlieten, die hem daarheen hadden gebracht, had gekocht. ");
INSERT INTO nld1939_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Maar Jahweh stond Josef bij, zodat het hem voorspoedig ging, en hij in het huis van zijn egyptischen meester mocht blijven. ");
INSERT INTO nld1939_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","En toen zijn meester zag, dat Jahweh met hem was, en Jahweh alles, wat hij ondernam, deed gelukken, ");
INSERT INTO nld1939_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","kwam Josef bij hem in de gunst, en moest hem persoonlijk bedienen. Hij gaf hem het toezicht over zijn huis, en vertrouwde hem al zijn bezittingen toe. ");
INSERT INTO nld1939_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","En van het oogenblik af, dat hij hem over zijn huis en al zijn bezittingen had gesteld, zegende Jahweh het huis van den Egyptenaar terwille van Josef. En toen de zegen van Jahweh bleef rusten op heel zijn bezit, in huis en op het land, ");
INSERT INTO nld1939_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","liet hij tenslotte al zijn bezittingen door Josef beheren, en bemoeide zich met niets meer, dan met het brood, dat hij at. Josef was kloek van gestalte en knap van uiterlijk. ");
INSERT INTO nld1939_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Zo gebeurde het na enige tijd, dat de vrouw van zijn meester het oog op Josef liet vallen en zeide: Kom bij mij liggen. ");
INSERT INTO nld1939_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hij weigerde, en zeide tot de vrouw van zijn meester: Zie, mijn heer bemoeit zich met niets in zijn huis buiten mij om, en hij heeft mij al zijn bezittingen toevertrouwd. ");
INSERT INTO nld1939_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hij zelf is hier in huis niet groter dan ik, en niets heeft hij aan mijn macht onttrokken behalve u, omdat ge zijn vrouw zijt. Hoe zou ik dan dit grote kwaad kunnen doen en zondigen tegen God? ");
INSERT INTO nld1939_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","En ofschoon ze dag in dag uit bij Josef aandrong, dat hij bij haar zou komen liggen, en haar terwille zou zijn, luisterde hij niet naar haar. ");
INSERT INTO nld1939_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Maar op zekere dag gebeurde het, dat hij naar huis kwam, om zijn werk te verrichten, en er niemand van de huisgenoten binnen was. ");
INSERT INTO nld1939_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Toen greep ze hem bij zijn kleren vast en zei: Kom bij mij liggen. Doch hij liet zijn kleed in haar handen achter, en vluchtte haastig naar buiten. ");
INSERT INTO nld1939_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Toen zij zag, dat hij zijn kleed in haar handen had achtergelaten en naar buiten was gevlucht, ");
INSERT INTO nld1939_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","schreeuwde zij haar huisgenoten bijeen, en zei hun: Daar hebt ge het nu; men heeft een Hebreër in huis gebracht, om zijn spel met ons te drijven. Hij is naar mij toegekomen, om bij mij te liggen; maar ik ben gaan schreeuwen, zo hard ik kon. ");
INSERT INTO nld1939_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Toen hij mij zo hard hoorde schreeuwen en gillen, liet hij zijn kleed bij mij achter, en vluchtte haastig naar buiten. ");
INSERT INTO nld1939_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ze hield het kleed bij zich achter, totdat zijn meester thuis kwam. ");
INSERT INTO nld1939_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Toen vertelde ze hem hetzelfde: Die hebreeuwse slaaf, dien ge in huis hebt gehaald, is bij mij binnengedrongen, om zijn spel met mij te drijven. ");
INSERT INTO nld1939_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Maar toen ik hard begon te schreeuwen en te gillen, liet hij zijn kleed bij mij achter, en vluchtte haastig naar buiten. ");
INSERT INTO nld1939_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Toen de heer van Josef zijn vrouw hoorde vertellen, hoe zijn slaaf haar zou hebben behandeld, werd hij zeer toornig; ");
INSERT INTO nld1939_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","hij liet Josef grijpen en hem in de kerker werpen, waar de gevangenen van den koning zaten opgesloten. Maar ook toen Josef daar in de gevangenis zat, ");
INSERT INTO nld1939_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","stond Jahweh hem bij, en strekte zijn genade over hem uit. Hij zorgde er voor, dat hij bij den gevangenbewaarder in de gunst kwam, ");
INSERT INTO nld1939_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","zodat deze al die in de kerker zaten opgesloten aan Josef toevertrouwde, en er niets geschiedde buiten hem om. ");
INSERT INTO nld1939_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","De gevangenbewaarder bemoeide zich met niets, van wat hij Josef had toevertrouwd; want Jahweh stond hem bij, en wat hij deed, liet Jahweh gelukken. ");
INSERT INTO nld1939_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Enige tijd daarna begingen de schenker en de bakker van den koning van Egypte een misdrijf tegen den koning van Egypte, hun heer. ");
INSERT INTO nld1939_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","En daar Farao vertoornd was op zijn twee hovelingen, den opperschenker en den hofbakker, ");
INSERT INTO nld1939_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","liet hij hen gevangen zetten in het huis van den overste der lijfwacht, de kerker waar ook Josef zat opgesloten; ");
INSERT INTO nld1939_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","en de overste van de lijfwacht stelde Josef bij hen aan, om voor hen te zorgen. Zo bleven ze geruime tijd gevangen. ");
INSERT INTO nld1939_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Eens hadden beiden, de schenker zowel als de bakker van Egypte’s koning, die in de kerker zaten opgesloten, dezelfde nacht een droom, elk met eigen betekenis. ");
INSERT INTO nld1939_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Toen Josef de volgende morgen bij hen kwam, zag hij aan hen, dat ze terneergeslagen waren. ");
INSERT INTO nld1939_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hij vroeg toen aan de hovelingen van Farao, die met hem in het huis van zijn meester in hechtenis zaten: Waarom kijkt ge vandaag zo somber? ");
INSERT INTO nld1939_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Zij antwoordden hem: Wij hebben een droom gehad, en er is niemand, om hem uit te leggen. Josef zeide hun: God alleen legt dromen uit! Vertelt ze mij eens. ");
INSERT INTO nld1939_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","De opperschenker verhaalde toen zijn droom aan Josef, en zeide hem: In mijn droom zag ik een wijnstok voor mij. ");
INSERT INTO nld1939_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Aan die wijnstok zaten drie ranken; zodra hij begon uit te lopen, zette hij bloesem en droegen zijn trossen rijpe druiven. ");
INSERT INTO nld1939_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ik had de beker van Farao in mijn hand; ik nam de druiven, perste ze uit in Farao’s beker, en reikte die aan Farao over. ");
INSERT INTO nld1939_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Toen zeide Josef tot hem: Dit is de uitleg ervan: de drie ranken betekenen drie dagen. ");
INSERT INTO nld1939_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Over drie dagen zal Farao uw hoofd in de hoogte heffen, door u in uw ambt te herstellen; dan zult ge Farao de beker weer reiken, zoals vroeger, toen ge zijn schenker waart. ");
INSERT INTO nld1939_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Maar wanneer het u goed gaat, denk dan ook eens aan mij, en bewijs mij de gunst, een goed woord voor me te doen bij Farao, en te zorgen, dat ik uit dit huis word bevrijd. ");
INSERT INTO nld1939_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Want ik ben weggeroofd uit het land der Hebreën, en ook hier heb ik niets gedaan, waarvoor men mij in de gevangenis moest zetten. ");
INSERT INTO nld1939_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Toen de hofbakker zag, dat Josef een gunstige uitleg gaf, zeide hij tot hem: Ook ik heb een droom gehad. Zie, ik zag drie broodkorven op mijn hoofd. ");
INSERT INTO nld1939_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In de bovenste korf bevond zich gebak, allerlei soorten gerechten voor Farao; maar de vogels pikten het weg uit de korf op mijn hoofd. ");
INSERT INTO nld1939_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef gaf hem ten antwoord: Dit is de uitleg ervan: de drie korven betekenen drie dagen. ");
INSERT INTO nld1939_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Over drie dagen zal Farao ook uw hoofd in de hoogte heffen, door u aan een paal op te hangen; dan zullen de vogels uw vlees opeten. ");
INSERT INTO nld1939_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Op de derde dag, de verjaardag van Farao, richtte deze voor heel zijn hof een feestmaal aan. Toen hief hij werkelijk het hoofd van den opperschenker en van den hofbakker te midden van zijn dienaren omhoog. ");
INSERT INTO nld1939_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Den opperschenker herstelde hij in zijn ambt van schenker, zodat hij Farao weer de beker mocht reiken. ");
INSERT INTO nld1939_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","den hofbakker hing hij op, zoals Josef het hun had uitgelegd. ");
INSERT INTO nld1939_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","De opperschenker echter dacht niet eens meer aan Josef, maar vergat hem geheel. ");
INSERT INTO nld1939_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Twee jaren later had ook Farao een droom. Zie, hij stond aan de Nijl. ");
INSERT INTO nld1939_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Daar klommen uit de Nijl zeven koeien omhoog, prachtig en vet, die in het oevergras gingen weiden. ");
INSERT INTO nld1939_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Maar zie, daarna klommen zeven andere koeien uit de Nijl omhoog, lelijk en mager, die naast de eerste gingen staan aan de oever van de Nijl. ");
INSERT INTO nld1939_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","De lelijke en magere koeien slokten de zeven prachtige en vette koeien op. Toen ontwaakte Farao. ");
INSERT INTO nld1939_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Hij sliep weer in, en droomde opnieuw. En zie, zeven aren schoten op uit één halm, zwaar en prachtig. ");
INSERT INTO nld1939_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Maar daarna schoten zeven andere aren op, spichtig en door de oostenwind verschroeid. ");
INSERT INTO nld1939_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","En de spichtige aren slokten de dikke en volle op. Toen ontwaakte Farao, en merkte dat het een droom was geweest. ");
INSERT INTO nld1939_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","De volgende morgen was Farao erover verontrust. Hij ontbood alle geleerden en wijzen van Egypte, en verhaalde hun zijn droom. Maar er was niemand, die Farao uitleg kon geven. ");
INSERT INTO nld1939_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Toen sprak de opperschenker tot Farao: Nu moet ik eerlijk mijn schuld bekennen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Toen Farao indertijd vertoornd was op zijn dienaren, had hij mij en den hofbakker gevangen gezet in het huis van den overste van de lijfwacht. ");
INSERT INTO nld1939_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Daar hadden wij in dezelfde nacht een droom; ieder van ons had een droom met eigen betekenis. ");
INSERT INTO nld1939_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nu was daar bij ons een hebreeuwse jongeman, een slaaf van den overste van de lijfwacht. We vertelden hem onze dromen, en hij legde ze voor ons uit, iedere droom met zijn eigen zin. ");
INSERT INTO nld1939_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","En zoals hij het ons had uitgelegd, is het gebeurd. Men heeft mij in mijn ambt hersteld, hem hing men op. ");
INSERT INTO nld1939_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Toen liet Farao Josef roepen. Men haalde hem vlug uit de gevangenis; en nadat hij zich geschoren had en andere kleren had aangetrokken, begaf hij zich naar Farao. ");
INSERT INTO nld1939_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","En Farao sprak Josef toe: Ik heb een droom gehad, en er is niemand, die hem kan uitleggen. Nu heb ik over u horen zeggen, dat gij een droom kunt uitleggen, zodra ge hem hoort. ");
INSERT INTO nld1939_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef gaf Farao ten antwoord: Ik zelf kan niets; maar God zal Farao openbaren, wat hem tot heil strekt. ");
INSERT INTO nld1939_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Toen sprak Farao tot Josef: In mijn droom stond ik aan de oever van de Nijl. ");
INSERT INTO nld1939_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","En zie, uit de Nijl klommen zeven koeien omhoog, vet en prachtig, die in het oevergras gingen weiden. ");
INSERT INTO nld1939_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Maar zie, daarna klommen zeven andere koeien omhoog, schraal, erg lelijk en mager; zo lelijk, als ik ze in heel Egypte nog nooit heb gezien. ");
INSERT INTO nld1939_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","De magere en lelijke koeien slokten de zeven eerste, de vette, op. ");
INSERT INTO nld1939_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ze kwamen in haar buik terecht, maar men merkte er niets van; ze bleven even lelijk als vroeger. Toen werd ik wakker. ");
INSERT INTO nld1939_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Opnieuw zag ik in mijn droom. Zie, zeven aren schoten op uit één halm, vol en prachtig. ");
INSERT INTO nld1939_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maar daarna schoten zeven andere aren op, dor, spichtig en door de oostenwind verschroeid. ");
INSERT INTO nld1939_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","En de spichtige aren slokten de zeven prachtige op. Ik heb het aan de geleerden verhaald, maar niemand kon mij uitleg geven. ");
INSERT INTO nld1939_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nu sprak Josef tot Farao: De dromen van Farao zijn één. God heeft Farao geopenbaard, wat Hij van plan is te doen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De zeven vette koeien betekenen zeven jaren; de zeven vette aren eveneens zeven jaren. Het is maar één droom. ");
INSERT INTO nld1939_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ook de zeven magere en lelijke koeien, die na haar omhoog klommen, betekenen zeven jaren, en de zeven spichtige aren, door de oostenwind verschroeid, eveneens zeven jaren van hongersnood. ");
INSERT INTO nld1939_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Dit bedoelde ik, toen ik tot Farao zeide, dat God aan Farao heeft getoond, wat Hij van plan is te doen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Zie, er gaan voor Egypte zeven jaren van grote overvloed komen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Daarna zullen er zeven jaren van hongersnood aanbreken, waarin heel de overvloed van Egypte zal worden vergeten, en hongersnood het land zal teisteren. ");
INSERT INTO nld1939_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Dan zal men in het land niets meer van overvloed merken door de hongersnood, die er op volgt; want die zal zeer hevig zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","En dat de droom zich voor Farao herhaald heeft, betekent, dat God het vast heeft besloten en het spoedig ten uitvoer zal brengen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Farao moge dus omzien naar een verstandig en kundig man, en dien over Egypteland aanstellen. ");
INSERT INTO nld1939_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Laat Farao aldus te werk gaan: hij stelle opzichters aan over het land, om in de zeven jaren van overvloed het vijfde deel te heffen van de opbrengst van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ze moeten in de goede jaren, die nu gaan komen, allerlei levensmiddelen verzamelen, en in de steden het koren opslaan en bewaren ter beschikking van Farao. ");
INSERT INTO nld1939_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dan zullen die levensmiddelen de voorraad vormen voor het land voor de zeven jaren van hongersnood, die over Egypte gaan komen, en zal het land niet van honger te gronde gaan. ");
INSERT INTO nld1939_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Dit voorstel scheen Farao en heel zijn hof verstandig. ");
INSERT INTO nld1939_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","En Farao sprak tot zijn hovelingen: Zou er een man zijn te vinden, in wien Gods geest is als in hem? ");
INSERT INTO nld1939_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","En Farao zeide tot Josef: Nu God u dat alles heeft geopenbaard, is er niemand zo verstandig en kundig als gij. ");
INSERT INTO nld1939_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gij zult dus niet enkel mijn huis besturen, maar heel het volk zal aan uw bevel gehoorzamen, en alleen door mijn troon zal ik boven u staan. ");
INSERT INTO nld1939_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","En Farao vervolgde tot Josef: Hiermee stel ik u aan over heel het land van Egypte! ");
INSERT INTO nld1939_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","En Farao trok de zegelring van zijn vinger, stak die aan de hand van Josef, trok hem een kostbaar linnen gewaad aan, en hing hem een gouden keten om de hals. ");
INSERT INTO nld1939_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Daarna liet hij hem zijn eigen wagen bestijgen, de beste op een na, en men riep voor hem uit: Op de knieën! Zo stelde Farao Josef aan over heel het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","En hij zeide tot hem: Ik blijf Farao; maar buiten uw wil zal niemand hand of voet verroeren in heel het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao gaf Josef de naam Safenat-Panéach, en schonk hem Asenat, de dochter van Poti-Féra, den priester van On, tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef was dertig jaar oud, toen hij in dienst trad van Farao, den koning van Egypte. Nu ging Josef van Farao heen, en doorreisde heel het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","En terwijl het land in de zeven jaren van overvloed volop droeg, ");
INSERT INTO nld1939_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","verzamelde hij in die zeven jaren, dat er overvloed was in Egypte, allerlei levensmiddelen. Hij stapelde ze op in de steden; in iedere stad sloeg hij de oogst op van de velden rondom. ");
INSERT INTO nld1939_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","En Josef hoopte het koren op als het zand aan de zee; zo ontzaggelijk veel, dat men ophield met meten, omdat het niet meer te meten was. ");
INSERT INTO nld1939_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nog eer het jaar van de hongersnood kwam, kreeg Josef twee zonen, die Asenat, de dochter van Poti-Féra, den priester van On, hem baarde. ");
INSERT INTO nld1939_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef noemde den oudste Manasse; want God heeft me al mijn ellende en heel mijn vaderlijk huis doen vergeten. ");
INSERT INTO nld1939_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den tweede noemde hij Efraïm; want God heeft mij vruchtbaar gemaakt in het land van mijn ongeluk. ");
INSERT INTO nld1939_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Toen nu de zeven jaren van overvloed, die in Egypte heerste, ten einde waren, ");
INSERT INTO nld1939_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","braken de zeven jaren van hongersnood aan, zoals Josef voorspeld had. In alle landen was er gebrek, maar in heel het land van Egypte was brood. ");
INSERT INTO nld1939_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","En toen ook heel Egypte honger begon te krijgen, en het volk tot Farao om brood riep, zeide Farao tot alle Egyptenaren: Gaat tot Josef, en doet wat hij u zegt. ");
INSERT INTO nld1939_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","En toen er hongersnood heerste over het hele land, opende Josef de graanschuren, en verkocht het koren aan de Egyptenaren. En ofschoon er ook in Egypte hongersnood woedde, ");
INSERT INTO nld1939_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","kwamen alle landen naar Egypte, om van Josef koren te kopen; want de hongersnood teisterde ook de hele wereld. ");
INSERT INTO nld1939_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Toen Jakob vernam, dat er in Egypte koren was, zeide hij tot zijn zonen: Wat talmt ge nog? ");
INSERT INTO nld1939_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ik heb gehoord, dat er koren is in Egypte. Trekt daarheen, en gaat er wat voor ons kopen, zodat we in leven blijven en niet sterven. ");
INSERT INTO nld1939_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tien broeders van Josef gingen dus op weg, om in Egypte graan te kopen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Maar Jakob liet Benjamin, den broer van Josef, niet met de andere broers meegaan; want hij was bang, dat hem een ongeluk zou overkomen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Zo kwamen de zonen van Israël, tegelijk met vele anderen, daar aan, om koren te kopen; want er was hongersnood in het land Kanaän. ");
INSERT INTO nld1939_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josef, die toen het land bestuurde, verkocht persoonlijk aan al de volken der aarde. Ook de broers van Josef gingen dus naar hem toe, en bogen zich voor hem ter aarde neer. ");
INSERT INTO nld1939_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zodra Josef zijn broers zag, herkende hij hen, maar hij maakte zich zelf aan hen niet bekend. Bars sprak hij hen toe: Waar komt ge vandaan? Zij antwoordden: Uit het land Kanaän, om koren te kopen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nu wist Josef zeker, dat het zijn broers waren, en dat zij hem niet hadden herkend; ");
INSERT INTO nld1939_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","en hij herinnerde zich toen de dromen, die hij vroeger had gehad. Hij sprak tot hen: Gij zijt spionnen; ge zijt gekomen, om de zwakke punten van het land te verspieden. ");
INSERT INTO nld1939_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Zij antwoordden: Neen, heer; uw dienaars zijn enkel gekomen, om levensmiddelen te kopen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wij allen zijn zonen van één man, en wij zijn betrouwbare mensen; uw dienaars zijn geen spionnen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Hij herhaalde: Niet waar, ge zijt gekomen, om de zwakke punten van het land te verspieden. ");
INSERT INTO nld1939_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ze zeiden: Uw dienaren zijn twaalf in getal geweest; wij zijn broeders en zonen van één man uit het land Kanaän. De jongste is bij onzen vader gebleven, en één is er niet meer. ");
INSERT INTO nld1939_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef hernam: Ik blijf er bij; ge zijt spionnen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Dat is nu juist een punt, om u op de proef te stellen; bij het leven van Farao, gij komt hier niet vandaan, eer uw jongste broer naar hier is gekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Stuur dus een van u, om uw broer te halen; gij blijft hier gevangen achter. Zo kan worden onderzocht, of ge de waarheid hebt gesproken. En zo dit niet het geval is: bij het leven van Farao, dan zijt ge verspieders. ");
INSERT INTO nld1939_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nu liet hij hen drie dagen lang te zamen in de gevangenis opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Op de derde dag sprak Josef tot hen: Ge kunt uw leven redden, zo ge doet wat ik zeg; ook ik ben een godvrezend man. ");
INSERT INTO nld1939_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Wanneer gij betrouwbare mannen zijt, laat dan een van uw broers als gevangene in uw kerker achter; de anderen van u kunnen vertrekken, en koren meenemen, om de honger van uw gezinnen te stillen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Maar ge brengt uw jongsten broeder naar mij toe, om de waarheid van uw woorden te bewijzen; dan zult ge niet sterven. Daar gingen ze op in. ");
INSERT INTO nld1939_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Maar ze zeiden toch onder elkander: Waarachtig, we hebben het aan onzen broer verdiend. Wij hebben zijn doodsangst gezien, maar niet naar hem willen luisteren, toen hij ons om genade smeekte. Daarom komt deze ramp over ons. ");
INSERT INTO nld1939_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben voegde er nog aan toe: Heb ik u niet gezegd, u niet aan den knaap te bezondigen? Maar gij hebt niet willen luisteren. Zie, nu wordt zijn bloed teruggeëist. ");
INSERT INTO nld1939_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ze wisten niet, dat Josef hen verstond; want ze hadden zich van een tolk bediend. ");
INSERT INTO nld1939_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josef weende met de rug naar hen toe. Daarna keerde hij zich om, en onderhield zich met hen. Hij liet Simeon uit hun midden weghalen, en hem voor hun ogen in boeien slaan. ");
INSERT INTO nld1939_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nu gaf Josef bevel, hun zakken met koren te vullen, maar in ieders zak het geld terug te leggen, en hun mondvoorraad mee te geven voor onderweg. Zo deed men. ");
INSERT INTO nld1939_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Zij laadden het koren op hun ezels, en trokken weg. ");
INSERT INTO nld1939_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Maar toen een van hen in het nachtverblijf zijn zak opendeed, om zijn ezel te voeren, vond hij het geld bovenop in de zak. ");
INSERT INTO nld1939_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hij zei tot zijn broers: Mijn geld is terug; daar ligt het in mijn zak. Zij bestierven het van schrik, en zeiden tot elkander: Wat laat God ons nu overkomen? ");
INSERT INTO nld1939_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Zo kwamen zij dan bij hun vader Jakob in het land Kanaän terug, en verhaalden hem alles, wat hun overkomen was. ");
INSERT INTO nld1939_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ze zeiden: Die man, die daar het land regeert, heeft ons bars toegesproken, en ons uitgemaakt voor verspieders van het land. ");
INSERT INTO nld1939_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wij hebben hem geantwoord: Wij zijn betrouwbare mensen en geen spionnen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wij zijn twaalf broeders geweest, zonen van één vader; één is er niet meer, en de jongste is bij zijn vader in het land Kanaän gebleven. ");
INSERT INTO nld1939_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Maar de man, die daar het land regeert, sprak tot ons: Dit zal voor mij het bewijs zijn, dat gij betrouwbare mensen zijt; één van uw broers zal bij me blijven; de anderen van u kunnen vertrekken en koren meenemen, om de honger van uw gezinnen te stillen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Maar brengt uw jongsten broer tot mij; dan zal ik weten, dat gij geen verspieders zijt. Als gij betrouwbare mannen zijt, geef ik uw broer aan u terug, en kunt gij vrij door het land reizen. ");
INSERT INTO nld1939_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Toen zij hun zakken ledigden, vond ieder zijn buidel met geld in zijn zak. Bij het zien van hun buidels met geld, werden zij, zowel als hun vader, bevreesd. ");
INSERT INTO nld1939_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","En hun vader Jakob zeide tot hen: Ge maakt me kinderloos; Josef is weg, Simeon is weg, en nu neemt ge ook nog Benjamin weg; het drukt me allemaal zwaar. ");
INSERT INTO nld1939_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Maar nu zei Ruben tot zijn vader: Ge moogt mijn beide zonen doden, als ik hem niet bij u terugbreng. Vertrouw hem mij toe; ik breng hem u terug. ");
INSERT INTO nld1939_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Maar hij antwoordde: Mijn zoon gaat niet met u mee; want zijn broer is dood, en hij alleen is nog over. Overkomt hem een ongeluk op de reis, die ge onderneemt, dan zoudt ge mijn grijze haren met kommer ten grave doen dalen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Maar de hongersnood bleef het land teisteren. ");
INSERT INTO nld1939_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","En toen al het koren op was, dat zij van Egypte hadden meegebracht, zei hun vader tot hen: Gaat voor ons weer wat levensmiddelen kopen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Maar Juda sprak tot hem: Die man heeft ons uitdrukkelijk gewaarschuwd: Waagt het niet, mij onder de ogen te komen, als ge uw broer niet meebrengt. ");
INSERT INTO nld1939_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Zo gij dus onzen broer met ons meegeeft, zullen wij levensmiddelen voor u gaan kopen; ");
INSERT INTO nld1939_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","maar zo ge hem niet laat gaan, vertrekken we niet. Want die man heeft ons gezegd: Waagt het niet, mij onder de ogen te komen, als uw broer niet bij u is. ");
INSERT INTO nld1939_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israël hernam: Waarom hebt gij mij dit leed aangedaan, met dien man te vertellen, dat gij nog een broer hadt. ");
INSERT INTO nld1939_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Zij antwoordden: Die man vroeg ons uitdrukkelijk naar ons en onze familie. Hij zeide: Leeft uw vader nog; hebt gij nog een anderen broer? Alleen op die vragen hebben we hem geantwoord. Konden we dan weten, dat hij zou zeggen: brengt uw broer hier? ");
INSERT INTO nld1939_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","En Juda drong bij zijn vader Israël aan: Geef den jongen maar met mij mee, en laten we vertrekken; dan kunnen we in leven blijven en behoeven we niet te sterven, wij, gijzelf en onze kinderen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ik blijf borg voor hem; van mij moogt ge hem terugeisen. Als ik hem niet bij u terugbreng en weer voor u doe staan, blijf ik voor u mijn leven lang schuldig. ");
INSERT INTO nld1939_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hadden we maar niet zo getalmd, dan waren we al voor de tweede keer terug. ");
INSERT INTO nld1939_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Toen sprak hun vader Israël tot hen: Als het dan moet, doet het dan maar. Neemt het beste van het land in uw zakken mee, en biedt het dien man als geschenk aan: wat balsem en honing, wat gom en hars, met pimpernoten en amandelen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Neemt ook een dubbel bedrag aan geld met u mee. Want ge moet het geld teruggeven, dat boven in uw zakken werd gevonden; misschien was het maar een vergissing. ");
INSERT INTO nld1939_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Neemt dan uw broer mee, en gaat terug naar dien man. ");
INSERT INTO nld1939_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Geve de almachtige God, dat ge genade vindt bij dien man, en dat hij uw anderen broer en Benjamin met u laat vertrekken. Wat mij betreft, moet ik kinderloos worden, het zij zo. ");
INSERT INTO nld1939_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","De mannen namen dus het geschenk en een dubbel bedrag aan geld met zich mee, vertrokken met Benjamin naar Egypte, en verschenen voor Josef. ");
INSERT INTO nld1939_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Toen Josef hen met Benjamin zag, beval hij zijn hofmeester: Breng die mannen naar binnen; laat het nodige slachten, en maak een maaltijd gereed; want die mannen zullen vanmiddag bij mij eten. ");
INSERT INTO nld1939_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","De man deed zoals Josef beval, en bracht de mannen naar het huis van Josef. ");
INSERT INTO nld1939_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Toen de mannen naar het huis van Josef werden gebracht, werden zij bang en zeiden: We worden weggebracht om het geld, dat de vorige maal in onze zakken is teruggevonden. Men wil ons overrompelen en overvallen, ons tot slaven maken, en onze ezels in beslag nemen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Zij traden op den hofmeester van Josef toe, spraken hem aan bij de deur van het huis, en zeiden tot hem: ");
INSERT INTO nld1939_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Met uw verlof, heer; wij waren vroeger al hier, om koren te kopen. ");
INSERT INTO nld1939_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Maar toen wij in het nachtverblijf kwamen en onze zakken openden, lag ieders geld boven in zijn zak: ons eigen geld naar het volle bedrag. Dit hebben we nu weer meegebracht, ");
INSERT INTO nld1939_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","tegelijk met het andere geld, dat we bij ons hebben, om levensmiddelen te kopen. Wij weten niet, wie ons geld weer in onze zakken heeft gelegd. ");
INSERT INTO nld1939_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hij gaf hun ten antwoord: Weest maar gerust, vreest niet; uw God en de God van uw vader heeft heimelijk een schat in uw zakken gelegd; want ik heb uw geld ontvangen. Nadat de man ook Simeon bij hen had gebracht, ");
INSERT INTO nld1939_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","leidde hij hen naar het huis van Josef, en gaf hun water, om hun voeten te wassen, en voer voor hun ezels. ");
INSERT INTO nld1939_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Zij legden hun geschenken gereed in afwachting van Josef, die tegen de middag zou komen; want zij hadden gehoord, dat hij daar zou eten. ");
INSERT INTO nld1939_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Toen Josef thuis kwam, boden zij hem de geschenken aan, die zij van huis hadden meegenomen, en bogen zich voor hem ter aarde neer. ");
INSERT INTO nld1939_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Hij vroeg hun, hoe zij het maakten, en zei: Maakt ook uw oude vader, van wien ge mij hebt gesproken, het nog goed; is hij nog in leven? ");
INSERT INTO nld1939_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Zij antwoordden: Onze vader, uw dienaar, maakt het goed, en is nog in leven; en weer bogen zij eerbiedig voor hem ter aarde. ");
INSERT INTO nld1939_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Toen hij rondkeek, en zijn broer Benjamin zag, den zoon van zijn moeder, zei hij: Is dat uw jongste broer, van wien ge mij hebt gesproken? En hij voegde er aan toe: God zij u genadig, mijn zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Dan snelde Josef weg, om uit te schreien; want bij het zien van zijn broer was hij diep ontroerd. Hij ging zijn kamer binnen en snikte het uit. ");
INSERT INTO nld1939_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Na zijn gelaat te hebben gewassen, kwam hij weer de kamer uit. Hij vermande zich en sprak: Dient de maaltijd op! ");
INSERT INTO nld1939_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Toen diende men voor ieder afzonderlijk het eten op, voor Josef, voor hen, en voor de Egyptenaren, die met hem aten. Want de Egyptenaren mogen niet met de Hebreën eten: dit is voor de Egyptenaren een gruwel. ");
INSERT INTO nld1939_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Zo zaten de mannen tegenover hem, van den oudste tot den jongste, juist volgens hun leeftijd; verwonderd keken zij elkaar er op aan. ");
INSERT INTO nld1939_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hij liet hen van de gerechten bedienen, die voor hem stonden; maar het deel van Benjamin was vijf maal zo groot als dat van ieder der anderen. Zij dronken met hem, en werden vrolijk. ");
INSERT INTO nld1939_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Daarna gaf hij zijn hofmeester het volgende bevel: Vul de zakken van die mannen met levensmiddelen, zoveel als ze maar kunnen dragen, en leg het geld van ieder boven in zijn zak. ");
INSERT INTO nld1939_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Maar mijn eigen zilveren beker moet ge boven in de zak van den jongste leggen bij het geld voor zijn koren. Hij deed, wat Josef hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Vroeg in de morgen liet men de mannen met hun ezels vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Maar zij waren nog niet ver buiten de stad, toen Josef tot zijn hofmeester zeide: Vooruit, jaag die mannen na, en als ge ze ingehaald hebt, zeg hun dan: “Waarom vergeldt ge goed met kwaad? ");
INSERT INTO nld1939_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Waarom hebt ge de zilveren beker gestolen, en nog wel die, waar mijn heer uit drinkt en waaruit hij de toekomst voorspelt. Ge hebt daar slecht mee gedaan.” ");
INSERT INTO nld1939_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Toen hij hen had ingehaald, sprak hij hen toe, zoals was bevolen. ");
INSERT INTO nld1939_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Zij antwoordden: Hoe kan mijn heer nu zo iets zeggen? Zo iets zouden uw dienaren zeker niet doen. ");
INSERT INTO nld1939_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Zie, het geld, dat wij boven in onze zakken hadden gevonden, hebben we u uit het land Kanaän teruggebracht. Hoe zouden we dan zilver of goud uit het huis van uw heer durven stelen? ");
INSERT INTO nld1939_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Hij, bij wien de beker gevonden wordt, zal sterven; en de anderen van ons zullen de slaven zijn van uw heer. ");
INSERT INTO nld1939_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Hij zeide toen: Eigenlijk moest het gebeuren, zoals ge zegt. Maar zo zal het wezen: bij wien de beker gevonden wordt, hij zal mijn slaaf zijn; maar de anderen van u gaan vrij uit. ");
INSERT INTO nld1939_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Toen zette ieder van hen vlug zijn zak op de grond, en maakte hem open. ");
INSERT INTO nld1939_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hij begon zijn onderzoek bij den oudste om te eindigen bij den jongste; en de beker werd in de zak van Benjamin gevonden. ");
INSERT INTO nld1939_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nu scheurden zij allen hun kleren, laadden hun zak weer op hun ezels, en keerden terug naar de stad. ");
INSERT INTO nld1939_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zo kwamen Juda en zijn broers aan het huis van Josef, waar deze nog altijd vertoefde, en wierpen zich voor hem op de grond. ");
INSERT INTO nld1939_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josef sprak hen aan: Wat hebt ge gedaan; begreept ge dan niet, dat iemand als ik een goed waarzegger is? ");
INSERT INTO nld1939_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda zeide: Wat zullen we onzen heer antwoorden, wat zullen we zeggen, hoe ons rechtvaardigen? God wreekt de schuld van uw dienaren. Zie, wij zijn de slaven van onzen heer, wij met hem, bij wien de beker is gevonden. ");
INSERT INTO nld1939_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hij sprak: Ik denk er niet aan, zo iets te doen; alleen de man, bij wien de beker is gevonden, zal mijn slaaf zijn, maar gij kunt in vrede naar uw vader gaan. ");
INSERT INTO nld1939_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nu trad Juda naar voren, en sprak: Met uw verlof, heer! Laat uw dienaar een enkel woord tot mijn heer mogen spreken, zonder dat gij toornig wordt op uw dienaar; want gij zijt verheven als Farao! ");
INSERT INTO nld1939_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mijn heer heeft aan zijn dienaars gevraagd: “Hebt gij nog een vader of een broer?” ");
INSERT INTO nld1939_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wij hebben onzen heer toen geantwoord: “Wij hebben een ouden vader en een jongen broer, die hem op zijn oude dag is geboren. Zijn broer is dood, zijn moeder heeft hem alleen nog over, en hij is de lieveling van zijn vader”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Gij hebt toen tot uw dienaars gezegd: “Brengt hem naar mij toe, opdat ik hem met eigen ogen kan zien”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wij hebben onzen heer geantwoord: “De jongen kan niet weg van zijn vader; zijn vader zou sterven, als hij hem verliet”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Maar gij hebt toen uw dienaars gedreigd: “Waagt het niet, mij onder de ogen te komen, als uw jongste broer niet met u mee komt”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nadat wij dus waren teruggekeerd naar onzen vader, uw dienaar, hebben wij hem de woorden van onzen heer meegedeeld. ");
INSERT INTO nld1939_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","En toen onze vader beval: “Gaat weer wat levensmiddelen voor ons kopen” ");
INSERT INTO nld1939_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","hebben we geantwoord: “Zo kunnen we niet gaan! Alleen als onze jongste broer met ons meegaat, zullen we vertrekken; want we durven dien man niet meer onder de ogen komen, als onze jongste broeder ons niet vergezelt”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Toen sprak mijn vader, uw dienaar, tot ons: “Ge weet, dat mijn vrouw mij maar twee zonen heeft geschonken. ");
INSERT INTO nld1939_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","De een is van mij heengegaan; ik denk dat hij verscheurd is, want ik heb hem nooit meer gezien. ");
INSERT INTO nld1939_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Als ge nu ook dezen van mij wegneemt, en hem een ongeluk overkomt, dan zoudt ge mijn grijze haren met kommer ten grave doen dalen”. ");
INSERT INTO nld1939_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Wanneer ik nu dus terugkom bij mijn vader, uw dienaar, en de knaap, aan wien hij met heel zijn ziel hangt, ons niet vergezelt, ");
INSERT INTO nld1939_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","dan zal hij sterven, als hij ziet, dat de jongen er niet is, en uw dienaars zullen de grijze haren van onzen vader, uw dienaar, met kommer ten grave doen dalen. ");
INSERT INTO nld1939_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Waarachtig, uw dienaar is borg gebleven voor den knaap bij mijn vader, en heeft hem gezegd: “Als ik hem niet bij u terugbreng, blijf ik mijn leven lang schuldig voor mijn vader.” ");
INSERT INTO nld1939_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Laat dus uw dienaar, in plaats van den jongen, als slaaf van mijn heer achterblijven, maar laat de knaap met zijn broers vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Want hoe zou ik naar mijn vader durven terugkeren, als de jongen mij niet vergezelt! Ik zou de smart niet kunnen aanzien, die mijn vader zou treffen. ");
INSERT INTO nld1939_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nu kon Josef zich voor al de omstanders niet langer bedwingen. Hij riep, dat allen zouden heengaan, zodat er niemand bij was, toen Josef zich aan zijn broeders bekend maakte. ");
INSERT INTO nld1939_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Hij begon hardop te schreien, zodat de Egyptenaren en het hof van Farao het hoorden. ");
INSERT INTO nld1939_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Hij zei tot zijn broers: Ik ben Josef! Leeft vader nog? Maar zijn broers waren niet in staat, hem te antwoorden; ze deinsden van schrik voor hem terug. ");
INSERT INTO nld1939_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Maar Josef sprak tot zijn broers: Komt toch dichter bij me! En toen zij dit hadden gedaan, herhaalde hij: Ik ben Josef, uw broer, dien ge naar Egypte verkocht hebt. ");
INSERT INTO nld1939_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Weest niet bedroefd en boos op uzelf, dat ge mij hierheen hebt verkocht. Neen, God heeft mij voor u uitgezonden, om uw leven te redden. ");
INSERT INTO nld1939_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Want twee jaren heerst er nu al hongersnood in het land, en nog vijf jaar lang zal men ploegen noch oogsten. ");
INSERT INTO nld1939_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God heeft me voor u uitgezonden, om uw geslacht op aarde te behouden en uw eigen leven te redden. ");
INSERT INTO nld1939_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Want niet gij hebt mij hierheen gezonden, maar God zelf. Hij heeft mij tot een vader voor Farao gemaakt, tot meester over heel zijn huis en heerser over heel het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Keert dus terstond terug naar mijn vader, en zegt hem: Zo spreekt uw zoon Josef! “God heeft mij tot heer over heel Egypte verheven; talm dus niet, en kom naar mij toe. ");
INSERT INTO nld1939_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gij kunt met uw zonen en kleinzonen, uw schapen en runderen en al wat u toebehoort in het land Gósjen gaan wonen, zodat ge dicht bij me zult zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ik zal u met uw huisgezin en heel uw bezit onderhouden, opdat gij niet tot armoede vervalt; want de hongersnood zal nog vijf jaren duren.” ");
INSERT INTO nld1939_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Gij ziet het toch met eigen ogen, en mijn broer Benjamin ziet het ook, dat ik in eigen persoon tot u spreek. ");
INSERT INTO nld1939_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Vertelt dus mijn vader van al de glorie, die ik in Egypte geniet, en van alles wat gij hebt gezien, en brengt dan mijn vader zo spoedig mogelijk hier. ");
INSERT INTO nld1939_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Toen omhelsde hij onder tranen zijn broer Benjamin, en ook zijn broer Benjamin schreide bij de omhelzing. ");
INSERT INTO nld1939_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dan kuste hij wenend al zijn broers. Toen eerst durfden zijn broers tot hem spreken. ");
INSERT INTO nld1939_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Het gerucht, dat de broers van Josef waren gekomen, drong door tot het paleis van Farao, en Farao en zijn hof waren erover verheugd. ");
INSERT INTO nld1939_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","En Farao sprak tot Josef: Zeg aan uw broers, dat ze zó moeten doen! “Zadelt uw dieren en trekt naar het land Kanaän, ");
INSERT INTO nld1939_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","om uw vader en uw gezinnen te halen, en komt naar mij terug. Dan zal ik u het puik van Egypte schenken, en ge zult het beste genieten, wat het land opbrengt.” ");
INSERT INTO nld1939_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ook dit moet ge hun gelasten: “Neemt uit Egypte wagens mee voor uw kleine kinderen en vrouwen; vervoert er ook uw vader mee en komt hierheen. ");
INSERT INTO nld1939_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ge behoeft geen spijt om uw huisraad te hebben; want het allerbeste, wat Egypte kan bieden, is voor u!” ");
INSERT INTO nld1939_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Zo deden de zonen van Israël; Josef gaf hun op bevel van Farao wagens, en verschafte hun levensmiddelen voor de reis. ");
INSERT INTO nld1939_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Aan ieder van hen schonk hij een stel feestgewaden, maar aan Benjamin driehonderd zilverstukken en vijf stel feestgewaden. ");
INSERT INTO nld1939_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Eveneens zond hij aan zijn vader tien ezels, die de beste gaven van Egypte droegen, en tien ezelinnen beladen met koren en brood, en voedsel als voorraad voor de reis. ");
INSERT INTO nld1939_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Zo liet hij zijn broers vertrekken, en zei hun nog bij hun vertrek: Doet elkaar onderweg geen verwijten. ");
INSERT INTO nld1939_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Zij vertrokken nu uit Egypte, en gingen naar het land Kanaän, naar Jakob hun vader. ");
INSERT INTO nld1939_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Toen zij hem vertelden, dat Josef nog leefde, en over heel Egypte heerste, bleef hij er ongevoelig voor; want hij geloofde hen niet. ");
INSERT INTO nld1939_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Maar toen zij hem alles hadden verteld, wat Josef tot hen had gesproken, en hij de wagens zag, die Josef had gezonden, om hem te vervoeren, leefde de geest van hun vader Jakob weer op. ");
INSERT INTO nld1939_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","En Israël sprak: Genoeg! Mijn zoon Josef leeft nog. Ik wil hem gaan zien, eer ik sterf! ");
INSERT INTO nld1939_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Toen vertrok Israël met al de zijnen, en ging naar Beër-Sjéba. Daar droeg hij een offer op aan den God van zijn vader Isaäk. ");
INSERT INTO nld1939_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","En God sprak tot Israël in een nachtelijk visioen: Jakob, Jakob! Hij antwoordde: Hier ben ik! ");
INSERT INTO nld1939_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","En Hij zeide: Ik ben God, de God van uw vader! Vrees niet, naar Egypte te trekken; want Ik zal daar een groot volk van u maken. ");
INSERT INTO nld1939_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ik zelf ga met u mee naar Egypte; maar Ik breng u ook terug, en Josef zal u de ogen sluiten. ");
INSERT INTO nld1939_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Daarna trok Jakob uit Beër-Sjéba. De zonen van Israël zetten hun vader Jakob met hun kinderen en vrouwen op de wagens, die Farao gezonden had, om hen te vervoeren, ");
INSERT INTO nld1939_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","en namen hun vee en hun bezittingen mee, die ze in het land Kanaän hadden verworven. Zo trok Jakob met heel zijn geslacht naar Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Zijn zonen en kleinzonen, zijn dochters en kleindochters, heel zijn geslacht voerde hij mee naar Egypte. ");
INSERT INTO nld1939_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dit zijn de namen van de zonen van Israël, die naar Egypte kwamen: Jakob en zijn zonen; de oudste zoon van Jakob was Ruben. ");
INSERT INTO nld1939_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","De zonen van Ruben waren Chanok, Palloe, Chesron en Karmi. ");
INSERT INTO nld1939_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","De zonen van Simeon: Jemoeël, Jamin, Ohad, Jakin, Sóchar en Sjaoel, de zoon van een kanaänietische vrouw. ");
INSERT INTO nld1939_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","De zonen van Levi: Gersjon, Kehat en Merari. ");
INSERT INTO nld1939_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","De zonen van Juda: Er, Onan, Sjela, Fares en Zara. Er en Onan stierven in het land Kanaän. De zonen van Fares waren Esron en Chamoel. ");
INSERT INTO nld1939_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","De zonen van Issakar: Tola, Poewwa, Job en Sjimron. ");
INSERT INTO nld1939_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","De zonen van Zabulon: Séred, Elon en Jachleël. ");
INSERT INTO nld1939_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dit waren de zonen van Lea, die zij Jakob in Paddan-Aram had geschonken; bovendien nog zijn dochter Dina. Allen tezamen drie en dertig zonen en dochters. ");
INSERT INTO nld1939_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","De zonen van Gad waren: Sifjon, Chaggi, Sjoeni, Esbon, Eri, Arodi en Areli. ");
INSERT INTO nld1939_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","De zonen van Aser: Jimna, Jisjwa, Jisjwi en Beria, en Sérach hun zuster. De zonen van Beria waren Chéber en Malkiël. ");
INSERT INTO nld1939_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dit waren de zonen van Zilpa, die Laban aan zijn dochter Lea had gegeven; deze zestien had zij Jakob geschonken. ");
INSERT INTO nld1939_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","De zonen van Jakobs vrouw Rachel waren Josef en Benjamin. ");
INSERT INTO nld1939_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","In Egypte werden Manasse en Efraïm aan Josef geboren uit Asenat, de dochter van Poti-Féra, den priester van On. ");
INSERT INTO nld1939_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","De zonen van Benjamin waren Béla, Béker, Asjbel, Gera, Naäman, Echi, Rosj, Moeppim, Choeppim en Ard. ");
INSERT INTO nld1939_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dit waren de zonen van Rachel, die zij Jakob had geschonken. In het geheel veertien personen. ");
INSERT INTO nld1939_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","De zoon van Dan was Choesjim. ");
INSERT INTO nld1939_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","De zonen van Neftali: Jachseël, Goeni, Jéser en Sjillem. ");
INSERT INTO nld1939_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dit waren de zonen van Bilha, die Laban aan zijn dochter Rachel had gegeven. Dezen had zij Jakob geschonken; in het geheel zeven personen. ");
INSERT INTO nld1939_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Het volledig aantal personen uit Jakob geboren, die met hem naar Egypte trokken, bedroeg zes en zestig, behalve de vrouwen van zijn zonen. ");
INSERT INTO nld1939_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","De zonen van Josef in Egypte geboren waren twee in getal. Dus bedroeg het hele geslacht van Jakob, dat naar Egypte kwam, zeventig personen. ");
INSERT INTO nld1939_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nadat Jakob Juda vooruit had gezonden naar Josef, om hem bij zich in Gósjen te ontbieden, kwamen zij in het land Gósjen aan. ");
INSERT INTO nld1939_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","En Josef spande zijn wagen in, en reed naar Gósjen, om zijn vader Israël te ontmoeten. Toen hij hem zag, viel hij hem snikkend om de hals. ");
INSERT INTO nld1939_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","En Israël sprak tot Josef: Thans kan ik gerust sterven, nu ik u heb teruggezien, en nu ik weet, dat ge nog leeft! ");
INSERT INTO nld1939_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Daarna sprak Josef tot zijn broers en tot het gezin van zijn vader: Ik zal Farao gaan berichten: “Mijn broeders en het gezin van mijn vader, die in het land Kanaän woonden, zijn bij mij aangekomen. ");
INSERT INTO nld1939_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","De mannen willen hun kudde weiden; want het zijn veebezitters, en ze hebben hun schapen en runderen met heel hun bezit met zich meegebracht.” ");
INSERT INTO nld1939_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wanneer Farao u dus ontbiedt en u vraagt, wat uw beroep is, ");
INSERT INTO nld1939_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","moet ge antwoorden: “Uw dienaars zijn als onze vaders veebezitters geweest van onze jeugd af tot heden toe.” Dan zult gij u in het land Gósjen mogen vestigen; want de Egyptenaren hebben een afkeer van schaapherders. ");
INSERT INTO nld1939_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josef ging dus Farao berichten: Mijn vader en mijn broers zijn met hun schapen en runderen en met heel hun bezit uit het land Kanaän aangekomen, en bevinden zich in het land Gósjen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Hij had vijf van zijn broers meegenomen, en stelde ze aan Farao voor. ");
INSERT INTO nld1939_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao vroeg aan zijn broers: Wat is uw beroep? Zij gaven Farao ten antwoord: Uw dienaren zijn schaapherders, van vader op zoon. ");
INSERT INTO nld1939_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","En ze vervolgden tot Farao: We zijn gekomen, om de gastvrijheid van het land te genieten; want uw dienaars hadden geen weidegrond meer voor hun vee, daar de hongersnood het land Kanaän heeft geteisterd. Geef uw dienaren verlof, zich in het land Gósjen te vestigen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Toen sprak Farao tot Josef: Nu uw vader en broers tot u zijn gekomen, ");
INSERT INTO nld1939_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","staat het land van Egypte voor u open. Laat uw vader en broers in het beste deel van het land wonen; ze kunnen in het land Gósjen blijven. En wanneer ge weet, dat er geschikte mannen onder hen zijn, stel ze dan tot opzichters over mijn eigen veestapel aan. ");
INSERT INTO nld1939_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Nu ging Josef zijn vader Jakob halen, en stelde ook hem aan Farao voor. Nadat Jakob Farao met een zegenwens had begroet, ");
INSERT INTO nld1939_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","sprak Farao tot Jakob: Hoeveel jaren telt ge reeds? ");
INSERT INTO nld1939_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob gaf Farao ten antwoord: Het getal van mijn pelgrimsjaren bedraagt honderd dertig: weinig in aantal, maar vol van verdriet zijn mijn levensjaren geweest, en zij hebben niet het getal van die mijner vaderen bereikt in de dagen van hun pelgrimstocht. ");
INSERT INTO nld1939_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Toen zegende Jakob Farao, en ging van Farao heen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josef wees zijn vader en broers een woonplaats aan en gaf hun grondbezit in Egypte, en wel in de streek van Raämses, in het beste deel van het land, zoals Farao bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","En Josef voorzag zijn vader en broers van brood, en heel het gezin van zijn vader naar het getal van de kinderen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Daar intussen de hongersnood hevig bleef woeden, was er in heel het land geen voedsel meer, en raakten Egypte en Kanaän uitgeput van honger. ");
INSERT INTO nld1939_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Nu kreeg Josef al het geld in handen, dat in Egypte en Kanaän werd gevonden, in ruil voor het koren, dat men kocht; en al het geld stortte Josef in de schatkist van Farao. ");
INSERT INTO nld1939_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Toen er in Egypte en Kanaän geen geld meer was, kwamen alle Egyptenaren naar Josef toe, en zeiden: Geef ons brood; waarom moeten wij voor uw ogen sterven, omdat er geen geld meer is. ");
INSERT INTO nld1939_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josef antwoordde: Als ge geen geld meer bezit, geeft dan uw vee, en ik geef u daarvoor brood in de plaats. ");
INSERT INTO nld1939_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Zij brachten dus Josef hun kudden, en Josef gaf hun voedsel in ruil voor hun paarden, schapen, runderen en ezels. Dat jaar voorzag hij hen van brood in ruil voor al hun kudden. ");
INSERT INTO nld1939_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Maar toen het jaar om was, kwamen zij ook in het volgende jaar naar hem toe, en zeiden: We behoeven het niet voor onzen heer te verbergen, dat het geld op is en de veestapel reeds in het bezit van onzen heer is gekomen; we hebben dus niets meer over voor onzen heer, dan onze eigen persoon en onze landerijen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Waarom zouden wij met onze landerijen voor uw ogen te gronde gaan? Koop onszelf en ons land in ruil voor brood; dan zullen wij met ons land dienstbaar zijn aan Farao. Geef ook koren, om te zaaien, dan kunnen we in leven blijven en behoeven we niet te sterven, en zal ook het land niet braak blijven liggen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nu kocht Josef al het land van Egypte voor Farao op; want de Egyptenaren moesten allen hun akkers verkopen, omdat de honger hen kwelde. Zo werd het land Farao’s eigendom. ");
INSERT INTO nld1939_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Bovendien bracht hij het hele volk in lijfeigenschap van het ene eind van Egypte tot het andere. ");
INSERT INTO nld1939_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Alleen het land van de priesters kon hij niet kopen. Want de priesters hadden een vaste toelage van Farao, en leefden van wat Farao hun gaf; daarom behoefden zij hun land niet te verkopen. ");
INSERT INTO nld1939_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nu zei Josef tot het volk: Ik heb nu uw personen en akkers voor Farao gekocht, en gij hebt nu zaaikoren, om het land te bezaaien. ");
INSERT INTO nld1939_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Maar nu moet ge van de opbrengst een vijfde aan Farao afstaan; vier vijfden moogt ge voor u zelf behouden, om er uw velden mee te bezaaien, er met uw gezinnen van te leven, en uw kinderen te onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Zij zeiden: Gij hebt ons het leven gered! Laat ons genade vinden in de ogen van onzen heer, en de slaven van Farao zijn. ");
INSERT INTO nld1939_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Zo maakte Josef het tot wet, die nog heden voor de akkers in Egypte geldt, dat een vijfde aan Farao moet worden opgebracht. Alleen het land van de priesters bleef uitgezonderd, omdat het niet van Farao was. ");
INSERT INTO nld1939_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Zo vestigden de Israëlieten zich in Egypte, in het land Gósjen. Ze kregen daar vaste bezittingen, waren er vruchtbaar, en werden zeer talrijk. ");
INSERT INTO nld1939_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob leefde in Egypte nog zeventien jaar, zodat de hele levensduur van Jakob honderd zeven en veertig jaren bedroeg. ");
INSERT INTO nld1939_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Toen de dag van zijn sterven begon te naderen, ontbood hij zijn zoon Josef, en sprak tot hem: Als ik genade gevonden heb in uw ogen, leg dan uw hand onder mijn heup als bewijs van uw liefde en trouw, dat ge mij niet in Egypte zult begraven, ");
INSERT INTO nld1939_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","maar dat ik bij mijn vaderen zal rusten. Breng me uit Egypte over, en begraaf mij in hun graf. Hij antwoordde: Ik zal doen, wat ge zegt. ");
INSERT INTO nld1939_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Hij sprak: Zweer het mij dan! En toen hij het hem had gezworen, boog Israël zich aanbiddend neer op het hoofdeinde van zijn bed. ");
INSERT INTO nld1939_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Enige tijd later berichtte men Josef: Uw vader is ziek. Terstond ging hij naar Jakob, en nam zijn beide zonen, Manasse en Efraïm, met zich mee. ");
INSERT INTO nld1939_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Toen men Jakob vertelde, dat zijn zoon Josef was gekomen, verzamelde Israël zijn laatste krachten, en richtte zich in zijn bed overeind. ");
INSERT INTO nld1939_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","En Jakob sprak tot Josef: De almachtige God is mij te Loez in het land Kanaän verschenen, en heeft mij gezegend. ");
INSERT INTO nld1939_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Hij heeft mij gezegd: Ik zal u vruchtbaar en talrijk maken, u tot een schaar van volken doen groeien, en dit land aan uw nageslacht schenken tot een eeuwig bezit. ");
INSERT INTO nld1939_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Welnu, uw beide zonen, die u in Egypte geboren zijn, voordat ik tot u in Egypte kwam, Efraïm en Manasse, gelden als zonen van mij; Efraïm en Manasse staan voor mij gelijk met Ruben en Simeon. ");
INSERT INTO nld1939_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Maar de kinderen, die ge na hen zult krijgen, zullen de uwen zijn, en onder de naam van hun broeders hun erfdeel ontvangen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Want toen ik uit Paddan-Aram kwam, is uw moeder Rachel in het land Kanaän op enige afstand van Efráta mij ontvallen, en heb ik haar op de weg naar Efráta, dat nu Betlehem heet, moeten begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Toen Israël de zonen van Josef bemerkte, sprak hij: Wie hebt ge daar? ");
INSERT INTO nld1939_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef gaf zijn vader ten antwoord: Het zijn mijn zonen, die God mij hier heeft gegeven. Hij zeide: Breng ze bij mij; ik wil ze zegenen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Want de ogen van Israël waren verzwakt van ouderdom, zodat hij niet kon zien. Toen Josef ze dus dicht bij hem had gebracht, kuste en omhelsde hij hen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","En Israël sprak tot Josef: Ik had niet gedacht, dat ik u nog zou weerzien; en zie, nu laat God mij nog uw kinderen aanschouwen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nu nam Josef ze van zijn knieën weg, en zij bogen zich ter aarde neer. ");
INSERT INTO nld1939_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Dan nam Josef hen bij de hand: Efraïm bij de rechterhand, dus links van Israël; Manasse bij de linkerhand, dus rechts van Israël; zo plaatste hij ze vóór hem. ");
INSERT INTO nld1939_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Maar Israël kruiste zijn armen: hij stak zijn rechterhand uit en legde die op het hoofd van Efraïm, ofschoon hij de jongste was, en zijn linkerhand op het hoofd van Manasse, ofschoon hij de eerstgeborene was. ");
INSERT INTO nld1939_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Toen zegende hij hen en sprak: De God, voor wiens aanschijn mijn vaderen hebben gewandeld, Abraham en Isaäk: De God, die mij heeft behoed van mijn geboorte af, Tot heden toe: ");
INSERT INTO nld1939_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","De Engel, die mij uit alle nood heeft verlost, Zegene deze knapen! Moge in hen mijn naam blijven leven, en de naam van mijn vaderen, Abraham en Isaäk, En mogen zij vruchtbaar en talrijk worden In het land! ");
INSERT INTO nld1939_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Josef zag tot zijn ontsteltenis, dat zijn vader zijn rechterhand op het hoofd van Efraïm had gelegd. Hij greep de hand van zijn vader, om ze van het hoofd van Efraïm weg te nemen en op het hoofd van Manasse te leggen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","En Josef zei tot zijn vader: Zo niet vader; want dit is de oudste: leg uw rechterhand dus op zijn hoofd. ");
INSERT INTO nld1939_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maar zijn vader weigerde het, en sprak: Ik weet het, mijn zoon, ik weet het! Ook hij zal een volk worden, ook hij zal groot zijn; maar zijn jongere broer zal nog groter worden dan hij, en zijn geslacht een ganse schaar van volken. ");
INSERT INTO nld1939_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","En hij zegende hen op die dag, en sprak: Met uw naam zal Israël zegen wensen en zeggen: God make u als Efraïm en Manasse! Zo stelde hij Efraïm boven Manasse. ");
INSERT INTO nld1939_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nu sprak Israël tot Josef: Zie, ik ga sterven; maar God zal met u zijn, en u terugleiden naar het land uwer vaderen. ");
INSERT INTO nld1939_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ik vermaak u één deel meer dan uw broeders; de bergrug, die ik op de Amorieten met mijn zwaard en mijn boog heb veroverd. ");
INSERT INTO nld1939_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Daarna riep Jakob zijn zonen en sprak: Verzamelt u en ik zal u verkonden, Wat u in de verre toekomst geschiedt. ");
INSERT INTO nld1939_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Komt bijeen en luistert, zonen van Jakob; Hoort naar Israël, uw vader! ");
INSERT INTO nld1939_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, gij mijn eerstgeborene, Mijn kracht en eersteling van mijn mannelijke rijpheid: De eerste moest ge in hoogheid zijn, De eerste in macht. ");
INSERT INTO nld1939_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Maar ge zijt een schuimende beek, Gij zult die voorrang niet hebben: Want ge hebt het bed van uw vader beklommen, Toen mijn sponde ontwijd. ");
INSERT INTO nld1939_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon en Levi, echte broers: List en geweld zijn hun zwaarden: ");
INSERT INTO nld1939_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mijn geest wil in hun plannen niet treden, Mijn hart heeft geen deel aan hun raad. Want in hun toorn hebben zij mannen verslagen, In hun moedwil stieren verminkt! ");
INSERT INTO nld1939_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Vervloekt hun toorn, zo heftig, Hun gramschap, zo fel: Ik zal ze verdelen in Jakob, Ze verstrooien in Israël! ");
INSERT INTO nld1939_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, u prijzen uw broeders; Uw hand drukt op de nek van uw vijand, De zonen van uw vader buigen zich voor u neer! ");
INSERT INTO nld1939_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, als een leeuwenwelp Stijgt gij omhoog na de buit, mijn zoon! Hij kromt zich, hij vlijt zich neer als een leeuw, En als een leeuwin: wie durft hem wekken? ");
INSERT INTO nld1939_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","De schepter zal van Juda niet wijken, De staf niet tussen zijn voeten, Totdat Hij komt, wien ze behoort, En voor wien de volken zich bukken. ");
INSERT INTO nld1939_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Dan bindt hij zijn lastdier aan de wijnstok, Het veulen van zijn ezelin aan de wingerd; Dan wast hij zijn kleren in wijn, En in het druivensap zijn gewaad; ");
INSERT INTO nld1939_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Van wijn worden zijn ogen dan donker, Van de melk zijn tanden wit! ");
INSERT INTO nld1939_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon woont langs de oever der zee, En aan het strand bij de schepen; Hij keert Sidon de rug toe! ");
INSERT INTO nld1939_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar is een bonkige ezel, Die tussen de kudde blijft liggen; ");
INSERT INTO nld1939_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Daar hij het rusten heerlijk vindt, En lieflijk het land: Kromt hij zijn rug om te dragen, En verricht hij slavendienst! ");
INSERT INTO nld1939_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan richt zijn volk Als een van Israëls stammen. ");
INSERT INTO nld1939_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan is een slang op de weg, Een adder op het pad; Hij bijt het paard in de hielen, En zijn berijder slaat achterover. ");
INSERT INTO nld1939_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","- ");
INSERT INTO nld1939_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad: roverbenden stormen op hem aan, Maar hij zit hen op de hielen! ");
INSERT INTO nld1939_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser: heerlijk is zijn brood, Hij biedt koninklijke lekkernijen. ");
INSERT INTO nld1939_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali: een wijdvertakte terebint, Die een prachtige kruin draagt! ");
INSERT INTO nld1939_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Een jonge vruchtboom is Josef, Een jonge vruchtboom aan de bron: Zijn ranken klimmen over de muur. ");
INSERT INTO nld1939_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hoe men hem uitdaagt en tart, Hoe de boogschutters hem ook bekampen: ");
INSERT INTO nld1939_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Zijn boog blijft sterk, De spieren van zijn arm blijven lenig: Door de hulp van den Sterke van Jakob, Door de Naam van zijn Hoeder, Israëls Rots! ");
INSERT INTO nld1939_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Van den God van uw vader, die u helpt, Van den almachtigen God, die u zegent: Stromen zegeningen van de hemel daarboven, Zegeningen van de diepten beneden, Zegeningen van borsten en schoot, ");
INSERT INTO nld1939_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Zegeningen van uw vader! Ze gaan de zegeningen der oude bergen te boven, De kostbare gaven der eeuwige heuvelen; Zij dalen op het hoofd van Josef neer, Op de schedel van den vorst zijner broeders. ");
INSERT INTO nld1939_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is een roofgierige wolf. Des morgens verslindt hij de buit, En des avonds verdeelt hij de roof! ");
INSERT INTO nld1939_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dit zijn al de stammen van Israël, twaalf in getal. En zo sprak hun vader hen toe, toen hij hen zegende, en ieder van hen zijn bijzondere zegen verleende. ");
INSERT INTO nld1939_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Daarna gaf Jakob hun het volgende bevel: Wanneer ik bij mijn volk ben verzameld, begraaft mij dan bij mijn vaderen in de grot, op de akker van Efron, den Chittiet. ");
INSERT INTO nld1939_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Het is de grot op de akker van Makpela, ten oosten van Mamre, in het land Kanaän; de akker, die Abraham als een familiegraf van Efron, den Chittiet, heeft gekocht. ");
INSERT INTO nld1939_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Daar heeft men Abraham en zijn vrouw Sara begraven; daar heeft men Isaäk met zijn vrouw Rebekka begraven; en daar heb ik ook Lea begraven. ");
INSERT INTO nld1939_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Het is het stuk land, dat van de zonen van Chet is gekocht met de grot, die erop ligt. ");
INSERT INTO nld1939_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Toen Jakob de opdracht aan zijn zonen ten einde had gebracht, trok hij zijn voeten terug op het bed, gaf de geest en werd verzameld bij zijn volk. ");
INSERT INTO nld1939_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Wenend wierp Josef zich op het gelaat van zijn vader en kuste het. ");
INSERT INTO nld1939_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Daarna gaf hij de geneesheren onder zijn dienaars bevel, zijn vader te balsemen; en de geneesheren balsemden Israël. ");
INSERT INTO nld1939_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Veertig dagen gingen er mee heen; want zolang duurt de balseming. En zeventig dagen bedreven de Egyptenaren rouw over hem. ");
INSERT INTO nld1939_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Toen de rouwtijd voorbij was, sprak Josef tot het hof van Farao: Als ik genade gevonden heb in uw ogen, wees dan mijn voorspraak bij Farao, en zeg hem, ");
INSERT INTO nld1939_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","dat mijn vader mij heeft bezworen: “Wanneer ik dood ben, moet ge mij begraven in het graf, dat ik voor mij heb uitgehouwen in het land Kanaän.” Daarom zou ik willen vertrekken, om mijn vader te begraven; daarna zal ik terugkeren. ");
INSERT INTO nld1939_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao antwoordde: Ga heen, om uw vader te begraven, zoals hij u bezworen heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Josef vertrok dus, om zijn vader te begraven. Hij werd begeleid door al de dienaren van Farao, door zijn voornaamste hovelingen en alle waardigheidsbekleders van Egypte; ");
INSERT INTO nld1939_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","bovendien door het hele gezin van Josef met zijn broers en het gezin van zijn vader, die alleen hun kleine kinderen, hun schapen en runderen in het land Gósjen achterlieten. ");
INSERT INTO nld1939_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ook wagens en ruiters reden met hem mee: het was een indrukwekkende stoet. ");
INSERT INTO nld1939_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Toen zij Goren-Haätad in het Overjordaanse hadden bereikt, hielden zij er een grote en plechtige rouwklacht; en zeven dagen lang liet hij rouw bedrijven over zijn vader. ");
INSERT INTO nld1939_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","De inwoners van het land, de Kanaänieten, zagen die rouw in Goren-Haätad, en zeiden: Dat is een plechtige rouwklacht van Egypte. Daarom wordt deze plaats Abel-Misraim genoemd. Ze ligt in het Overjordaanse. ");
INSERT INTO nld1939_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Daarna deden zijn zonen, wat hij hun had bevolen. ");
INSERT INTO nld1939_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ze brachten hem naar het land Kanaän over, zoals hij hun had gelast, en begroeven hem in de grot op de akker van Makpela, ten oosten van Mamre, die Abraham als een familiegraf had gekocht van Efron, den Chittiet. ");
INSERT INTO nld1939_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na de begrafenis van zijn vader keerde Josef met al zijn broers en allen, die hem hadden vergezeld, om zijn vader te begraven, naar Egypte terug. ");
INSERT INTO nld1939_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nu hun vader gestorven was, werden de broers van Josef bevreesd, en zeiden: Als Josef ons nu maar niet vijandig behandelt, en ons al het kwaad vergeldt, dat wij hem aangedaan hebben! ");
INSERT INTO nld1939_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Daarom lieten zij Josef berichten: ");
INSERT INTO nld1939_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Uw vader heeft voor zijn dood ons bevolen: “Zo moet ge tot Josef spreken! Vergeef toch de misdaad en de zonde van uw broers en het leed, dat zij u hebben aangedaan.” Vergeef dus de misdaad der dienaars van den God van uw vader! Toen men zo tot hem sprak begon Josef te wenen. ");
INSERT INTO nld1939_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nu kwamen zijn broers zelf, vielen op hun aangezicht neer, en zeiden: Zie, wij zijn uw slaven! ");
INSERT INTO nld1939_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Maar Josef sprak: Ge behoeft niet te vrezen! Bekleed ik soms de plaats van God? ");
INSERT INTO nld1939_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gij hebt mij kwaad willen doen, maar God heeft het ten goede gekeerd, om een talrijk volk in het leven te behouden, zoals nu is geschied. ");
INSERT INTO nld1939_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Weest dus niet bang; ik zal voor u en uw kinderen zorgen. Zo gaf hij hun moed, en onderhield zich minzaam met hen. ");
INSERT INTO nld1939_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef bleef in Egypte wonen met het gezin van zijn vader; hij werd honderd tien jaren oud. ");
INSERT INTO nld1939_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","En Josef mocht nog de kleinkinderen van Efraïm aanschouwen; ook de zonen van Makir, den zoon van Manasse, werden op de knieën van Josef geboren. ");
INSERT INTO nld1939_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Daarna sprak Josef tot zijn broers: Ik ga sterven; maar God zal eenmaal op u neerzien, en u uit dit land geleiden naar het land, dat Hij aan Abraham, Isaäk en Jakob onder ede beloofd heeft. ");
INSERT INTO nld1939_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","En Josef bezwoer de zonen van Israël: Wanneer God op u heeft neergezien, voert dan mijn gebeente van hier mee. ");
INSERT INTO nld1939_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Toen stierf Josef, honderd tien jaren oud. Men balsemde hem in Egypte, en legde hem daar in een kist. ");
INSERT INTO nld1939_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dit zijn de namen van de zonen van Israël, die met Jakob naar Egypte waren gekomen, ieder met zijn gezin: ");
INSERT INTO nld1939_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi en Juda, ");
INSERT INTO nld1939_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zabulon en Benjamin, ");
INSERT INTO nld1939_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan en Neftali, Gad en Aser. ");
INSERT INTO nld1939_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","In het geheel waren het zeventig rechtstreekse afstammelingen van Jakob; Josef was toen reeds in Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Nadat Josef met al zijn broers en heel dat geslacht was gestorven, ");
INSERT INTO nld1939_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","werden de kinderen Israëls vruchtbaar en vermenigvuldigden zij zich; ze werden zó talrijk en een zó grote menigte, dat het land met hen overstroomd werd. ");
INSERT INTO nld1939_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Toen kwam er een nieuwe koning in Egypte aan het bewind, die Josef niet meer had gekend. ");
INSERT INTO nld1939_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Hij sprak tot zijn volk: Zie, het volk van Israël is talrijker dan wij en wordt ons te sterk. ");
INSERT INTO nld1939_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","We moeten dus met beleid tegen hen optreden, anders worden zij nog talrijker en sluiten ze zich, als wij in oorlog raken, bij onze vijanden aan, gaan ons bestrijden, en trekken dan weg uit het land. ");
INSERT INTO nld1939_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Men stelde dus slavendrijvers over hen aan, om hen met dwangarbeid er onder te houden; en zo moesten zij voor Farao de opslagplaatsen Pitom en Raämses bouwen. ");
INSERT INTO nld1939_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Maar hoe meer men ze verdrukte, hoe talrijker ze werden en hoe sterker zij zich vermenigvuldigden, zodat men de Israëlieten begon te vrezen. ");
INSERT INTO nld1939_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Zo maakten de Egyptenaren de kinderen Israëls met geweld tot hun slaven; ");
INSERT INTO nld1939_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","zij verbitterden hun leven door ze zwaar in leem en tichels te laten werken en door allerlei veldarbeid: allemaal slavenwerk, waartoe men hen met geweld dwong. ");
INSERT INTO nld1939_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nu sprak de koning van Egypte tot de vroedvrouwen Sjifra en Poea, die de hebreeuwse vrouwen hielpen: ");
INSERT INTO nld1939_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wanneer gij de hebreeuwse vrouwen bij de bevalling helpt, let dan op het geslacht van het kind. Als het een jongen is, moet ge het doden; is het een meisje, dan mag het blijven leven. ");
INSERT INTO nld1939_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Maar de vroedvrouwen vreesden God; ze deden niet wat de koning van Egypte haar had bevolen en lieten ook de jongens in leven. ");
INSERT INTO nld1939_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Daarom liet de koning van Egypte de vroedvrouwen roepen, en zeide tot haar: Waarom doet gij dit, en laat ge de jongens in leven? ");
INSERT INTO nld1939_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","De vroedvrouwen gaven Farao ten antwoord: De hebreeuwse vrouwen zijn niet als die van Egypte, maar eerder als dieren; voordat de vroedvrouw bij haar is, hebben zij het kind al gebaard. ");
INSERT INTO nld1939_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","En God beloonde de vroedvrouwen. En terwijl het volk zich vermenigvuldigde en hoe langer hoe talrijker werd, ");
INSERT INTO nld1939_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","maakte God de vroedvrouwen tot stammoeders, omdat ze Hem hadden gevreesd. ");
INSERT INTO nld1939_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Toen gaf Farao aan heel zijn volk het bevel: Werpt iederen jongen, die bij de Hebreën geboren wordt, in de Nijl, maar laat de meisjes in leven. ");
INSERT INTO nld1939_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nu was er een man uit de stam van Levi, die een levietisch meisje tot vrouw had genomen. ");
INSERT INTO nld1939_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","De vrouw werd zwanger, en baarde een zoon; en daar ze zag, dat het een flinke jongen was, hield ze hem drie maanden lang verborgen. ");
INSERT INTO nld1939_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Maar toen ze hem niet langer kon verbergen, haalde ze voor hem een biezen mandje, bestreek dat met asfalt en pek, legde het knaapje daarin, en zette het tussen het riet aan de oever van de Nijl, ");
INSERT INTO nld1939_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","terwijl zijn zuster op enige afstand bleef staan, om te weten, wat er met hem zou gebeuren. ");
INSERT INTO nld1939_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Toen nu de dochter van Farao de Nijl inging om te baden, terwijl haar slavinnen langs de oever van de Nijl op en neer wandelden, zag zij het mandje tussen het riet, en liet het door haar dienstmeisje halen. ");
INSERT INTO nld1939_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Zij maakte het open en zag, dat er een jongetje in lag te schreien. Zij had er medelijden mee, en sprak: Dat is zeker een van de hebreeuwse jongetjes. ");
INSERT INTO nld1939_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nu zeide zijn zuster tot de dochter van Farao: Wil ik misschien bij de hebreeuwse vrouwen een min voor u roepen, om het knaapje voor u te voeden? ");
INSERT INTO nld1939_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","De dochter van Farao antwoordde: Doe dat! Het meisje ging toen de eigen moeder van het kind roepen, ");
INSERT INTO nld1939_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","en de dochter van Farao zeide haar: Neem dit kind mee, en voed het voor mij; ik zal u er voor betalen. De vrouw nam dus het kind mee, en voedde het. ");
INSERT INTO nld1939_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Toen de jongen groot genoeg was, bracht ze hem naar de dochter van Farao, die hem als haar zoon behandelde. Zij noemde hem Moses; want, zeide ze, ik heb hem uit het water gehaald. ");
INSERT INTO nld1939_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Toen Moses groot was geworden, ging hij eens naar zijn broeders. Terwijl hij daar naar hun dwangarbeid stond te kijken, zag hij, hoe een Egyptenaar een Hebreër, een van zijn broeders, neersloeg. ");
INSERT INTO nld1939_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Hij keek naar alle kanten uit, en toen hij niemand zag, sloeg hij den Egyptenaar dood en verborg hem in het zand. ");
INSERT INTO nld1939_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Daags daarop ging hij weer, en zag twee Hebreën met elkander vechten. Hij zei nu tot hem, die ongelijk had: Waarom slaat gij uw makker? ");
INSERT INTO nld1939_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Hij antwoordde: Wie heeft u tot heer en rechter over ons aangesteld? Zijt gij soms van plan ook mij te vermoorden, zoals gij dien Egyptenaar hebt gedood? Nu werd Moses bang, want hij dacht: Het is dan toch bekend geworden. ");
INSERT INTO nld1939_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Toen dan ook Farao er van hoorde, wilde hij Moses ter dood laten brengen. Maar Moses vluchtte voor Farao, en zocht een schuilplaats in het land Midjan. Terwijl hij daar neerzat bij een put, ");
INSERT INTO nld1939_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","kwamen de zeven dochters van den priester van Midjan om water te scheppen en de drinkbakken te vullen voor de kudde van haar vader. ");
INSERT INTO nld1939_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Maar daar de herders haar kwamen verjagen, sprong Moses haar te hulp, en gaf haar kudde te drinken. ");
INSERT INTO nld1939_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Toen ze bij haar vader Reoeël kwamen, vroeg hij: Waarom zijt ge vandaag zo vroeg terug? ");
INSERT INTO nld1939_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Zij antwoordden: Een Egyptenaar heeft ons van de herders bevrijd, ook water voor ons geput, en de kudde laten drinken. ");
INSERT INTO nld1939_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Toen zei hij tot zijn dochters: Waar is hij? Waarom hebt gij dien man daar laten staan? Nodigt hem uit, om mee te eten. ");
INSERT INTO nld1939_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Zo besloot Moses bij dien man te blijven; en deze gaf Moses zijn dochter Sippora tot vrouw. ");
INSERT INTO nld1939_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zij baarde een zoon, dien hij Gersjom noemde; want hij zeide: Ik toef als gast in een vreemd land. ");
INSERT INTO nld1939_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","In die lange tussentijd was de koning van Egypte wel gestorven, maar de Israëlieten zuchtten en klaagden nog steeds onder de zware arbeid, en hun geschrei om verlossing uit de slavernij steeg omhoog tot God. ");
INSERT INTO nld1939_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","God hoorde hun kermen en was zijn Verbond met Abraham, Isaäk en Jakob indachtig. ");
INSERT INTO nld1939_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God zag neer op Israëls kinderen en bekommerde Zich om hun lot. ");
INSERT INTO nld1939_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Eens dat Moses de kudde weidde van zijn schoonvader Jitro, priester van Midjan, en hij zijn kudde diep de woestijn in had gedreven, en bij de Horeb, de berg van God, was gekomen, ");
INSERT INTO nld1939_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","verscheen hem de engel van Jahweh in een vlammend vuur midden in een braambos. Hij zag op, en ofschoon het braambos in lichte laaie stond, werd het niet verteerd. ");
INSERT INTO nld1939_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses dacht bij zichzelf: Ik moet dat wondere schouwspel toch eens wat nader gaan bezien en kijken, waarom het braambos niet verbrandt. ");
INSERT INTO nld1939_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Toen Jahweh zag, dat hij dichterbij kwam, om scherper toe te zien, riep God hem midden uit het braambos toe: Moses, Moses! Hij antwoordde: Hier ben ik! ");
INSERT INTO nld1939_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Hij ging voort: Kom hier niet dichterbij, maar doe uw schoenen van uw voeten; want de plaats, waar gij staat, is heilige grond. ");
INSERT INTO nld1939_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","En Hij vervolgde: Ik ben de God van uw vader; de God van Abraham, de God van Isaäk en de God van Jakob. Toen bedekte Moses zijn gelaat, want hij durfde niet naar God opzien. ");
INSERT INTO nld1939_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","En Jahweh sprak: Ik heb de ellende van mijn volk in Egypte gezien en zijn noodkreten om zijn verdrukkers gehoord. Waarachtig, zijn lijden is Mij bekend! ");
INSERT INTO nld1939_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Daarom ben Ik neergedaald, om het uit de macht van Egypte te verlossen, en om het uit dit land te geleiden naar een schoon en uitgestrekt land: naar een land, dat druipt van melk en honing, de woonplaats van de Kanaänieten en Chittieten, Amorieten, Perizzieten, Chiwwieten en Jeboesieten. ");
INSERT INTO nld1939_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ja, het geschrei van Israëls zonen is tot Mij doorgedrongen en Ik heb de verdrukking gezien, waarmede Egypte hen kwelt. ");
INSERT INTO nld1939_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Welnu dan, Ik zal u tot Farao zenden; gij moet mijn volk, de kinderen Israëls, uit Egypte leiden. ");
INSERT INTO nld1939_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Maar Moses zeide tot God: Wie ben ik, dat ik tot Farao zou gaan, en de Israëlieten uit Egypte zou leiden? ");
INSERT INTO nld1939_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Hij hernam: Ik ben met u! En dit zal voor u het teken zijn, dat Ik het ben, die u gezonden heb: wanneer ge het volk uit Egypte zult hebben geleid, zult ge God vereren op deze berg. ");
INSERT INTO nld1939_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Toen zei Moses tot God: Wanneer ik nu tot de zonen Israëls ga en hun zeg: “De God uwer vaderen zendt mij tot u”, wat moet ik dan antwoorden, als ze vragen: Hoe is zijn Naam? ");
INSERT INTO nld1939_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God sprak tot Moses: Ik ben: “Ik ben!” En Hij vervolgde: Dit moet ge aan de Israëlieten antwoorden: “Ik ben” zendt mij tot u! ");
INSERT INTO nld1939_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","En God sprak verder tot Moses: Dit moet gij aan Israëls kinderen zeggen: “Jahweh, de God uwer vaderen, de God van Abraham, de God van Isaäk en de God van Jakob zendt mij tot u!” Dit is voor eeuwig mijn Naam; zo zal Ik heten van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ga nu en roep de oudsten van Israël bijeen, en zeg hun: Jahweh, de God uwer vaderen, is mij verschenen; de God van Abraham, Isaäk en Jakob heeft mij gezegd: “Ik heb vol zorg op u nedergezien en gelet op wat men u in Egypte aandoet. ");
INSERT INTO nld1939_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Daarom heb Ik besloten: Uit de ellende van Egypte voer Ik u weg naar het land der Kanaänieten en Chittieten, Amorieten, Perizzieten, Chiwwieten en Jeboesieten, naar een land, dat druipt van melk en honing!” ");
INSERT INTO nld1939_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Zij zullen aan uw oproep gehoor geven. Dan moet gij met de oudsten van Israël naar den koning van Egypte gaan, en hem zeggen: “Jahweh, de God der Hebreën, is ons verschenen; wij moeten drie dagreizen ver de woestijn in, om aan Jahweh, onzen God, een offer te brengen”. ");
INSERT INTO nld1939_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Maar Ik weet, dat de koning van Egypte u slechts gedwongen zal laten vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Daarom zal Ik mijn hand uitstrekken, om Egypte te treffen met al mijn wonderen, die Ik in dat land zal verrichten; daarna zal hij u laten gaan. ");
INSERT INTO nld1939_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ik zal de Egyptenaren inschikkelijk maken jegens dit volk, zodat ge bij uw vertrek niet met lege handen zult heengaan. ");
INSERT INTO nld1939_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","De vrouwen moeten van haar buren en medebewoners zilveren en gouden sieraden en klederen eisen, die ge uw zonen en dochters moet aandoen. Zo zult ge Egypte uitschudden. ");
INSERT INTO nld1939_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses antwoordde: Zie, ze zullen mij niet geloven en niet naar mij luisteren; maar ze zullen zeggen: “Jahweh is u niet verschenen”. ");
INSERT INTO nld1939_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Toen sprak Jahweh tot hem: Wat hebt ge daar in uw hand? Hij antwoordde: Een staf. ");
INSERT INTO nld1939_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Hij sprak: Werp hem op de grond. Hij wierp hem op de grond en de staf werd een slang, waar Moses voor vluchtte. ");
INSERT INTO nld1939_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Maar Jahweh sprak tot Moses: Steek uw hand uit en grijp haar bij de staart. Hij stak zijn hand uit en greep haar vast, en zij werd in zijn hand weer een staf. ");
INSERT INTO nld1939_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Hierdoor zullen zij geloven, dat Jahweh, de God hunner vaderen, de God van Abraham, Isaäk en Jakob, u is verschenen. ");
INSERT INTO nld1939_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Opnieuw sprak Jahweh tot hem: Steek uw hand in uw boezem. Hij stak zijn hand in zijn boezem, maar toen hij ze terugtrok, was zijn hand melaats, en leek wel sneeuw. ");
INSERT INTO nld1939_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Hij sprak: Steek uw hand opnieuw in uw boezem. Weer stak hij zijn hand in zijn boezem; en toen hij ze er uit trok, zie, daar was ze weer als de rest van zijn lichaam. ");
INSERT INTO nld1939_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Wanneer ze u dan niet willen geloven en aan het eerste teken geen gehoor willen geven, dan zullen ze aan het tweede teken geloven. ");
INSERT INTO nld1939_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Maar wanneer ze na die beide tekenen nog niet geloven en niet naar u luisteren, neem dan water uit de Nijl, en stort dat op het droge. En het water, dat ge uit de Nijl hebt genomen, zal op het droge in bloed veranderen. ");
INSERT INTO nld1939_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Maar Moses sprak tot Jahweh: Ach, Heer, ik ben helemaal niet welbespraakt, ik ben het vroeger nooit geweest, en ben het ook nu nog niet, al hebt Gij tot uw dienaar gesproken; ik ben slechts een stamelaar. ");
INSERT INTO nld1939_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Toen sprak Jahweh tot hem: Wie heeft den mens een mond gegeven; wie maakt hem stom of doof, ziende of blind; Ik, Jahweh, niet waar? ");
INSERT INTO nld1939_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ga dus; Ik zal u in het spreken bijstaan en u ingeven, wat ge moet zeggen. ");
INSERT INTO nld1939_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Maar Moses hield aan: Ach Heer, zend toch liever een ander! ");
INSERT INTO nld1939_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Toen ontstak Jahweh in toorn tegen Moses en sprak: Is uw broeder Aäron, de Leviet, er ook niet? Ik weet, dat hij gemakkelijk spreekt! Zie, hij komt u al tegemoet, en verheugt er zich op, u weer te zien. ");
INSERT INTO nld1939_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tot hem zult ge spreken, en hem de woorden in de mond leggen; Ik zal u bijstaan, u en hem, als ge moet spreken, en u beiden ingeven wat ge moet doen. ");
INSERT INTO nld1939_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Hij zal voor u het woord tot het volk richten; hij zal uw tolk, en gij zult zijn God zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Neem deze staf met u mee, om er de tekenen mee te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Toen ging Moses naar zijn schoonvader Jitro terug en zei tot hem: Ik zou naar mijn broeders in Egypte terug willen keren, om te zien, of ze nog in leven zijn. En Jitro gaf Moses ten antwoord: Ga in vrede! ");
INSERT INTO nld1939_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Jahweh sprak tot Moses in Midjan: Trek op, en keer terug naar Egypte; want allen, die u naar het leven stonden, zijn dood. ");
INSERT INTO nld1939_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses nam dus zijn vrouw en zijn zonen, zette ze op ezels, en keerde naar het land van Egypte terug, Moses nam ook de staf van God met zich mee. ");
INSERT INTO nld1939_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","En Jahweh sprak tot Moses: Wanneer ge teruggekeerd zijt in Egypte, zorg er dan voor, alle wonderen, waartoe Ik u de macht heb gegeven, ten aanschouwen van Farao te verrichten. Maar Ik zal zijn hart verharden, zodat hij het volk niet laat gaan. ");
INSERT INTO nld1939_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dan moet gij tot Farao zeggen: Zo spreekt Jahweh! Israël is mijn eerstgeboren zoon! ");
INSERT INTO nld1939_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ik heb u gezegd: Laat mijn zoon gaan, om Mij te vereren. Ge hebt geweigerd, hem te laten vertrekken; daarom dood Ik uw zoon, uw eerstgeborene! ");
INSERT INTO nld1939_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Terwijl hij onderweg in een nachtverblijf toefde, zocht Jahweh hem op, en wilde hem doden. ");
INSERT INTO nld1939_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Maar Sippora nam een scherpe steen, en sneed de voorhuid van haar zoon af; zij raakte Moses’ voeten daarmee aan, en sprak: Een bloedige bruidegom zijt ge mij. ");
INSERT INTO nld1939_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Toen liet Jahweh hem met rust. Zij had immers bedoeld: een bloedige bruidegom door de besnijdenis. ");
INSERT INTO nld1939_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Intussen had Jahweh tot Aäron gesproken: Ga Moses in de woestijn tegemoet. Hij ging dus op weg, ontmoette hem bij de berg van God en kuste hem. ");
INSERT INTO nld1939_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","En Moses deelde Aäron de hele opdracht van Jahweh mee en alle tekenen, die Hij hem bevolen had te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Daarop gingen Moses en Aäron verder en riepen al de oudsten van de Israëlieten bijeen. ");
INSERT INTO nld1939_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aäron verkondigde alles wat Jahweh tot Moses gesproken had, en Moses verrichtte de tekenen voor de ogen van het volk. ");
INSERT INTO nld1939_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Het volk geloofde; en toen zij hoorden, dat Jahweh de kinderen Israëls had bedacht, en hun ellende had aanschouwd, wierpen zij zich op de knieën en bogen zich ter aarde. ");
INSERT INTO nld1939_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nu gingen Moses en Aäron naar Farao en zeiden: Zo spreekt Jahweh, Israëls God! Laat mijn volk gaan, om Mij ter ere in de woestijn een feest te vieren. ");
INSERT INTO nld1939_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maar Farao antwoordde: Wie is Jahweh wel, dat ik Hem zou gehoorzamen en Israël zou laten vertrekken? Ik ken geen Jahweh, en Israël laat ik niet gaan. ");
INSERT INTO nld1939_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Zij zeiden: De God der Hebreën is ons verschenen! Wij moeten drie dagreizen ver de woestijn in, om Jahweh, onzen God, een offer te brengen; anders slaat Hij ons met de pest of het zwaard. ");
INSERT INTO nld1939_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Maar de koning van Egypte sprak tot Moses en Aäron: Waarom houdt gij het volk van zijn werk af? Gaat zelf aan de arbeid. ");
INSERT INTO nld1939_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","En Farao ging voort: Er is toch al te veel van dat volk, en nu zoudt ge nog willen, dat ze het werk neerlegden. ");
INSERT INTO nld1939_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","En nog diezelfde dag gaf Farao aan de slavendrijvers en onderbazen het bevel: ");
INSERT INTO nld1939_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Geeft in het vervolg aan het volk geen stro meer, om tichels te maken, zoals tot nu toe; ze moeten het zelf maar bij elkaar gaan zoeken. ");
INSERT INTO nld1939_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Toch moet ge evenveel tichels van hen blijven eisen, als zij tot nu toe hebben gemaakt, en er niets van laten schieten. Want ze zijn lui; en daarom schreeuwen ze: We willen onzen God een offer brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Voor die mannen moet het werk worden verzwaard; dan zullen ze daarop blijven letten, en niet op leugens. ");
INSERT INTO nld1939_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","De slavendrijvers en onderbazen brachten het over aan het volk en zeiden: Zo spreekt Farao! Ik geef u geen stro meer; ");
INSERT INTO nld1939_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ge moet het zelf maar gaan halen, waar ge het vindt, maar we laten niets schieten van wat ge moet leveren. ");
INSERT INTO nld1939_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Dus moest het volk heel Egypte afzoeken, om strostoppels te verzamelen. ");
INSERT INTO nld1939_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Maar de slavendrijvers hielden er aan vast: Ge moet iedere dag evenveel blijven leveren, als toen er nog stro werd gegeven. ");
INSERT INTO nld1939_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","De slavendrijvers van Farao ranselden de israëlietische onderbazen af, die ze er voor aansprakelijk hadden gesteld en zeiden: Waarom levert ge nu niet evenveel tichels als vroeger? ");
INSERT INTO nld1939_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","De israëlietische onderbazen gingen zich bij Farao beklagen, en zeiden: Waarom laat ge uw dienaars zo behandelen? ");
INSERT INTO nld1939_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Uw dienaars wordt geen stro meer gegeven, en toch beveelt men ons evenveel tichels te maken. Uw dienaars worden geranseld, maar het is de schuld van uw eigen volk. ");
INSERT INTO nld1939_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Maar hij antwoordde: Lui zijt ge, lui! Daarom zegt ge: We moeten aan Jahweh een offer gaan brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vooruit aan het werk! Ge krijgt geen stro, maar hetzelfde aantal stenen zult ge leveren. ");
INSERT INTO nld1939_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Zo raakten de israëlietische onderbazen in moeilijkheid door het bevel, dat zij het aantal tichels per dag niet mochten verminderen. ");
INSERT INTO nld1939_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Toen zij dan ook van Farao weggingen, en Moses en Aäron ontmoetten, die op hen stonden te wachten, ");
INSERT INTO nld1939_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","zeiden ze hun: Jahweh moge het u vergelden en u straffen; want gij hebt ons gehaat gemaakt bij Farao en zijn dienaars, en hun het zwaard in de hand gedrukt, om ons te vermoorden. ");
INSERT INTO nld1939_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Toen wendde Moses zich tot Jahweh en zeide: Heer, waarom hebt Gij dit volk kwaad berokkend; waarom hebt Gij mij eigenlijk gezonden? ");
INSERT INTO nld1939_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Want van het ogenblik af, dat ik naar Farao ben gegaan, om in uw Naam te spreken, is dit volk er nog slechter aan toe, en Gij hebt uw volk in het geheel niet gered. ");
INSERT INTO nld1939_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Toen sprak Jahweh tot Moses: Nu zult ge zien, wat Ik Farao zal doen. Door sterke hand gedwongen zal hij hen laten gaan; door sterke hand gedwongen zal hij hen zelfs uit zijn land verdrijven. ");
INSERT INTO nld1939_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","En God sprak tot Moses: Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Als de almachtige God ben Ik aan Abraham, Isaäk en Jakob verschenen; maar mijn naam Jahweh heb ik hun niet bekend gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ik heb met hen mijn Verbond gesloten, om hun het land Kanaän te geven, het land waar zij als vreemdelingen hebben vertoefd; ");
INSERT INTO nld1939_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","en thans heb Ik het kermen gehoord van Israëls zonen, die door de Egyptenaren als slaven worden behandeld. Ik zal dus mijn Verbond gedenken! ");
INSERT INTO nld1939_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Zeg daarom tot de Israëlieten: Ik ben Jahweh! Ik zal u bevrijden van het juk van Egypte, u uit de slavernij verlossen en u met gespierde arm en onder zware straffen redden. ");
INSERT INTO nld1939_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ik heb u tot mijn volk gekozen. Ik zal uw God zijn, en gij zult weten, dat Ik Jahweh, uw God, ben, die u red uit de slavernij van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ik zal u brengen naar het land, dat Ik met opgestoken hand aan Abraham, Isaäk en Jakob beloofd heb. Ik zal het u in eigendom geven, zo waarachtig als Ik Jahweh ben. ");
INSERT INTO nld1939_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses bracht die boodschap over; maar de Israëlieten luisterden niet meer naar Moses, omdat zij de moed hadden verloren en onder de zware arbeid gingen gebukt. ");
INSERT INTO nld1939_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Toen sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ga Farao, den koning van Egypte, bevelen, de zonen Israëls uit zijn land te laten vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Maar Moses zeide tot Jahweh: Zie, als zelfs de zonen Israëls niet naar mij willen luisteren, hoe zal Farao dan naar mij luisteren: naar mij, die onbesneden van lippen ben? ");
INSERT INTO nld1939_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","En Jahweh sprak tot Moses en Aäron, en zond hen naar de kinderen Israëls en naar Farao, den koning van Egypte, met de opdracht, om de Israëlieten uit het land van Egypte te leiden. ");
INSERT INTO nld1939_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dit zijn de hoofden hunner geslachten. De zonen van Ruben, den eerstgeborene van Israël, waren Chanok en Palloe, Chesron en Karmi. Dit zijn de geslachten van Ruben. ");
INSERT INTO nld1939_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","De zonen van Simeon waren Jemoeël, Jamin, Ohad, Jakin, Sóchar en Sjaoel, de zoon van een kanaänietische vrouw. Dit zijn de geslachten van Simeon. ");
INSERT INTO nld1939_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Dit zijn de namen van de zonen van Levi naar hun geslachten: Gersjon, Kehat en Merari; Levi leefde honderd zeven en dertig jaar. ");
INSERT INTO nld1939_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","De zonen van Gersjon waren Libni en Sjimi naar hun families. ");
INSERT INTO nld1939_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","De zonen van Kehat waren Amram, Jishar, Chebron en Oezziël; Kehat werd honderd drie en dertig jaar oud. ");
INSERT INTO nld1939_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","De zonen van Merari waren Machli en Moesji. Dit zijn de geslachten van Levi naar hun families. ");
INSERT INTO nld1939_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram nam Jokébed, zijn tante, tot vrouw, en zij baarde hem Moses en Aäron; Amram leefde honderd zeven en dertig jaar. ");
INSERT INTO nld1939_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","De zonen van Jishar waren Kore, Néfeg en Zikri. ");
INSERT INTO nld1939_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","De zonen van Oezziël waren Misjaël, Elsafan en Sitri. ");
INSERT INTO nld1939_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aäron nam Elisjéba, de dochter van Amminadab en zuster van Naässon tot vrouw; zij baarde hem Nadab, Abihoe, Elazar en Itamar. ");
INSERT INTO nld1939_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","De zonen van Kore waren Assir, Elkana en Abiasaf. Dit zijn de families der Korieten. ");
INSERT INTO nld1939_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elazar, de zoon van Aäron, nam een van de dochters van Poetiël tot vrouw, en zij baarde hem Pinechas. Dit zijn de stamhoofden der Levieten naar hun geslachten. ");
INSERT INTO nld1939_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Het waren deze Aäron en Moses, tot wie God had gezegd: Voert de legerscharen van Israëls kinderen uit het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Het waren dezelfde Moses en Aäron, die tot Farao, den koning van Egypte, hebben gesproken, om de Israëlieten uit het land van Egypte te leiden. ");
INSERT INTO nld1939_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","In die tijd, dat Jahweh tot Moses sprak in het land van Egypte, ");
INSERT INTO nld1939_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","had Jahweh tot Moses gezegd: Ik ben Jahweh! Zeg aan Farao, den koning van Egypte, al wat Ik tot u spreken ga. ");
INSERT INTO nld1939_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Maar Moses had Jahweh ten antwoord gegeven: Ik ben onbesneden van lippen; hoe zal Farao naar mij luisteren! ");
INSERT INTO nld1939_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","En Jahweh sprak tot Moses: Zie, Ik heb u tot God over Farao gesteld, en Aäron uw broeder zal uw profeet zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ge moet dus aan uw broeder Aäron alles zeggen, wat Ik u gebieden zal; en deze moet Farao gelasten, de kinderen Israëls uit zijn land te laten vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Maar Ik zal het hart van Farao verharden, om grote tekenen en wonderen in Egypte te wrochten. ");
INSERT INTO nld1939_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Want Ik zal Egypte mijn hand laten voelen, wanneer Farao niet naar u luistert, en onder zware straffen mijn legerscharen, mijn volk, de kinderen Israëls uit Egypte wegleiden. ");
INSERT INTO nld1939_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Wanneer Ik mijn hand over Egypte uitstrek en de kinderen Israëls uit hun midden wegleid, zullen de Egyptenaren beseffen, dat Ik Jahweh ben! ");
INSERT INTO nld1939_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses en Aäron gehoorzaamden en deden alles, wat Jahweh hun geboden had. ");
INSERT INTO nld1939_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was tachtig en Aäron drie en tachtig jaar oud, toen zij tegen Farao optraden. ");
INSERT INTO nld1939_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nu sprak Jahweh tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wanneer Farao tot u zegt: Doet een wonder voor mij; dan moet ge Aäron gelasten: Neem uw staf en werp hem Farao voor de voeten; en de staf zal een slang worden. ");
INSERT INTO nld1939_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Toen gingen Moses en Aäron naar Farao, en deden wat Jahweh hun bevolen had. Aäron wierp zijn staf voor Farao en zijn hovelingen neer, en de staf werd een slang. ");
INSERT INTO nld1939_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Maar Farao riep zijn wijzen en tovenaars, en de egyptische tovenaars deden door hun toverkunsten hetzelfde. ");
INSERT INTO nld1939_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Iedereen wierp zijn staf op de grond, en ze veranderden in slangen; doch de staf van Aäron verslond die van hen. ");
INSERT INTO nld1939_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Farao echter bleef hardnekkig en wilde niet naar hen luisteren, zoals Jahweh voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Toen sprak Jahweh tot Moses: Het hart van Farao is verhard; hij wil het volk niet laten vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ga dus morgenvroeg, als Farao zich naar het water begeeft, naar hem toe; treed hem aan de oever van de Nijl tegemoet, neem de staf, die in een slang werd veranderd, met u mee, ");
INSERT INTO nld1939_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","en zeg hem: Jahweh, de God der Hebreën, heeft mij tot u gezonden met het bevel: “Laat mijn volk vertrekken, om Mij in de woestijn te vereren”. Tot nu toe hebt gij niet willen luisteren. ");
INSERT INTO nld1939_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Maar nu spreekt Jahweh: “Hieraan zult ge weten, dat Ik Jahweh ben”: Zie, ik sla met mijn staf, die ik hier in mijn hand heb, op het water van de Nijl, en het zal in bloed veranderen. ");
INSERT INTO nld1939_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","De vissen in de Nijl zullen sterven, en het water van de Nijl zal zo stinken, dat de Egyptenaren het niet kunnen drinken. ");
INSERT INTO nld1939_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","En Jahweh sprak tot Moses: Zeg aan Aäron: “Neem uw staf, en strek uw hand uit over het water van Egypte; over de beken, kanalen, over de plassen, en over alle plaatsen, waar water staat, en het zal in bloed veranderen. Zo zal het hele land van Egypte vol bloed zijn, tot in de houten en stenen vaten toe”. ");
INSERT INTO nld1939_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses en Aäron deden, wat Jahweh hun bevolen had. Hij hief zijn staf op, sloeg ten aanschouwen van Farao en zijn hof op het water van de Nijl, en al het water van de Nijl werd in bloed veranderd. ");
INSERT INTO nld1939_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","De vissen in de Nijl gingen dood, en de Nijl begon zo te stinken, dat de Egyptenaren het Nijlwater niet konden drinken. Maar ook heel het land van Egypte stond vol bloed. ");
INSERT INTO nld1939_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Daar de egyptische tovenaars hetzelfde deden door hun kunsten, bleef Farao hardnekkig, en wilde hij niet naar hen luisteren, zoals Jahweh voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao keerde om, en ging naar huis, zonder er verder acht op te slaan. ");
INSERT INTO nld1939_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Maar in de omtrek van de Nijl moesten alle Egyptenaren naar drinkwater graven; want het Nijlwater was voor hen niet te drinken. ");
INSERT INTO nld1939_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nadat er zeven volle dagen waren verlopen, sinds Jahweh op de Nijl had doen slaan, ");
INSERT INTO nld1939_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","sprak Jahweh tot Moses: Ga naar Farao en zeg hem: “Laat mijn volk vertrekken, om Mij te vereren. ");
INSERT INTO nld1939_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Zo ge weigert, het te laten vertrekken, teister Ik heel uw gebied met een kikvorsenplaag. ");
INSERT INTO nld1939_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","De Nijl zal wemelen van kikkers; zij zullen uw paleis binnenspringen, uw slaapvertrek en uw legerstede, de huizen van uw hovelingen en uw volk, tot in uw ovens en deegtroggen toe. ");
INSERT INTO nld1939_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Maar ook u zelf, uw volk en heel uw hof zullen de kikkers bespringen.” ");
INSERT INTO nld1939_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Jahweh sprak dus tot Moses: Zeg aan Aäron: “Strek uw hand met uw staf uit over de beken, kanalen en plassen, en laat er kikkers uit springen over het land Egypte.” ");
INSERT INTO nld1939_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","En Aäron strekte zijn hand uit over het water van Egypte, en er sprongen kikvorsen uit op, die het land van Egypte overdekten. ");
INSERT INTO nld1939_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Maar de tovenaars deden door hun kunsten hetzelfde; ook zij lieten kikvorsen springen over Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Toen riep Farao Moses en Aäron en zeide: Bidt Jahweh, dat Hij mij en mijn volk van de kikkers verlost; dan zal ik het volk laten gaan, om een offer aan Jahweh te brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses gaf Farao ten antwoord: Ge moogt zelf bepalen, wanneer ik voor u, uw hof en uw volk zal bidden, om u en uw huis van de kikvorsen te bevrijden, zodat er alleen nog in de Nijl overblijven. ");
INSERT INTO nld1939_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Hij zei: Morgen! En Moses antwoordde: Het zal gebeuren, zoals ge zegt, opdat ge moogt weten, dat Jahweh, onze God, zijns gelijke niet heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Gij en uw huis, uw hovelingen en uw volk zullen van de kikkers worden verlost, zodat er alleen nog in de Nijl zullen overblijven. ");
INSERT INTO nld1939_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Toen gingen Moses en Aäron van Farao weg, en Moses bad Jahweh de kikvorsen weg te nemen, waarmee Hij Farao had bezocht. ");
INSERT INTO nld1939_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Jahweh verhoorde het gebed van Moses: de kikvorsen stierven, en verdwenen uit de huizen, hoven en velden. ");
INSERT INTO nld1939_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Men veegde ze op hopen, zodat het land er van stonk. ");
INSERT INTO nld1939_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Maar toen Farao zag, dat het gevaar was geweken, bleef hij hardnekkig en wilde niet naar hen luisteren, zoals Jahweh voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Toen sprak Jahweh tot Moses: Zeg aan Aäron: “Hef uw staf omhoog en sla op het stof van de grond, en in heel het land van Egypte zal het in muggen veranderen”. ");
INSERT INTO nld1939_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ze deden het: Aäron hief zijn hand met zijn staf omhoog, en sloeg op het stof van de grond; de muggen kwamen af op mensen en vee, over heel Egypte werd het stof op de grond in muggen veranderd. ");
INSERT INTO nld1939_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","De tovenaars deden door hun kunsten hetzelfde; maar de muggen laten verdwijnen konden ze niet. De muggen bleven op mensen en vee. ");
INSERT INTO nld1939_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nu zeiden de tovenaars tot Farao: Dat is de vinger Gods! Maar Farao bleef hardnekkig, en wilde niet naar hen luisteren, zoals Jahweh voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Toen sprak Jahweh tot Moses: Treed morgenvroeg Farao weer tegemoet, wanneer hij naar het water gaat, en zeg hem: “Zó spreekt Jahweh! Laat mijn volk vertrekken, om Mij te vereren. ");
INSERT INTO nld1939_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Zo ge mijn volk niet laat vertrekken, zend Ik horzels op u af, op uw hof, uw volk en uw huis. De huizen der Egyptenaren en zelfs de grond, waarop zij staan, zullen vol zitten van horzels. ");
INSERT INTO nld1939_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Maar Ik zal op die dag een uitzondering maken voor het land Gósjen, waar mijn volk is gevestigd; daar zullen geen horzels zijn, opdat gij moogt weten, dat Ik, Jahweh, in dat land vertoef. ");
INSERT INTO nld1939_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ik zal dus onderscheid maken tussen mijn volk en het uwe. Morgen wordt dit teken gewrocht”. ");
INSERT INTO nld1939_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","En Jahweh deed het. Dichte zwermen horzels drongen het paleis van Farao en van zijn hovelingen binnen, en over heel Egypte werd het land door de horzels verpest. ");
INSERT INTO nld1939_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Nu riep Farao Moses en Aäron en zeide: Gaat heen, en brengt uw God een offer hier in het land. ");
INSERT INTO nld1939_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Maar Moses antwoordde: Dat kunnen we onmogelijk! Want wat wij aan Jahweh, onzen God, als offer brengen, is een gruwel in de ogen der Egyptenaren. Wanneer we dus een offer brengen, dat een gruwel is in de ogen der Egyptenaren, zouden ze ons dan niet stenigen? ");
INSERT INTO nld1939_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","We moeten drie dagreizen ver de woestijn in, om Jahweh, onzen God, een offer te brengen, zoals Hij ons heeft bevolen. ");
INSERT INTO nld1939_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Toen zeide Farao: Ik zal u laten vertrekken, om Jahweh, uw God, in de woestijn een offer te brengen; maar ge moogt u niet te ver verwijderen. Bidt dus voor mij. ");
INSERT INTO nld1939_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses antwoordde: Zie, ik ga van u weg, en zal bidden tot Jahweh; morgen zullen Farao, zijn hof en zijn volk van de horzels zijn verlost. Maar laat Farao niet opnieuw ons bedriegen, door het volk toch niet te laten gaan, om Jahweh offers te brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses ging dus van Farao heen, en bad Jahweh voor hem. ");
INSERT INTO nld1939_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","En Jahweh verhoorde het gebed van Moses: Farao, zijn hof en zijn volk werden van de horzels verlost; geen een bleef er over. ");
INSERT INTO nld1939_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Maar Farao bleef ook nu nog hardnekkig, en liet het volk niet vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Toen sprak Jahweh tot Moses: Ga naar Farao en zeg hem: “Zo spreekt Jahweh, de God der Hebreën! Laat mijn volk vertrekken, om Mij te vereren.” ");
INSERT INTO nld1939_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Want zo gij weigert, het te laten vertrekken, en het nog langer weerhoudt, ");
INSERT INTO nld1939_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","zal de hand van Jahweh uw vee in het veld met een verschrikkelijke pest slaan: paarden, ezels, kamelen, runderen en schapen. ");
INSERT INTO nld1939_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Maar Jahweh zal onderscheid maken tussen het vee van Israël en dat van Egypte; geen enkel beest van de Israëlieten zal verloren gaan. ");
INSERT INTO nld1939_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jahweh heeft ook de tijd bepaald: morgen zal Jahweh dit in het land voltrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","En de volgende morgen voltrok Jahweh het ook: al het vee der Egyptenaren kwam om, maar van de kudden der Israëlieten ging niets verloren. ");
INSERT INTO nld1939_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao stelde een onderzoek in; en werkelijk, geen enkel beest van de Israëlieten was omgekomen Maar Farao bleef hardnekkig, en liet het volk niet vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Toen sprak Jahweh tot Moses en Aäron: Neemt uw handen vol roet uit de oven, en laat Moses het in de lucht strooien voor de ogen van Farao. ");
INSERT INTO nld1939_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Het zal over heel Egypte stuiven, en bij mens en dier in heel Egypte builen verwekken, die in etterende wonden zullen openbreken. ");
INSERT INTO nld1939_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Zij namen dus roet uit de oven, en terwijl zij voor Farao stonden, wierp Moses het in de lucht; en het verwekte builen bij mens en dier, die openbraken in etterende wonden. ");
INSERT INTO nld1939_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Zelfs de tovenaars konden het door de builen bij Moses niet uithouden; want ook zij kregen builen, zoals de rest van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Maar Jahweh verhardde het hart van Farao; hij wilde niet naar hen luisteren, zoals Jahweh Moses voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Jahweh sprak tot Moses: Ga morgen vroeg Farao weer tegemoet, en zeg hem: Zo spreekt Jahweh, de God der Hebreën! Laat mijn volk vertrekken, om Mij te vereren. ");
INSERT INTO nld1939_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Want deze keer zal Ik u, uw hof en uw volk met al mijn plagen meedogenloos treffen, opdat ge moogt weten, dat niemand op de hele aarde gelijk is aan Mij. ");
INSERT INTO nld1939_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Zeker, thans zou Ik mijn hand kunnen uitsteken, en u en uw volk met de pest kunnen slaan, zodat gij van de aarde werdt weggevaagd. ");
INSERT INTO nld1939_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Maar Ik laat u in leven, om u mijn almacht te tonen, en mijn Naam te verkonden over de hele aarde. ");
INSERT INTO nld1939_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Zo ge u dus opnieuw tegen mijn volk durft verzetten, en het niet laat vertrekken, ");
INSERT INTO nld1939_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","zal Ik het morgen op deze tijd zo vreselijk doen hagelen, als nog nooit in Egypte is voorgekomen, zolang het bestaat tot de dag van vandaag. ");
INSERT INTO nld1939_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Laat dus uw kudde en alles, wat ge op het veld hebt staan, in veiligheid brengen; alle mensen en dieren, die zich buiten bevinden en niet onderdak zijn gebracht, zullen door de hagel worden getroffen en sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wie van Farao’s hovelingen het woord van Jahweh vreesde, bracht zijn slaven en vee naar binnen; ");
INSERT INTO nld1939_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","maar wie niet aan het woord van Jahweh geloofde, liet zijn slaven en vee buiten. ");
INSERT INTO nld1939_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Toen sprak Jahweh tot Moses: Strek uw hand uit naar de hemel, om het over heel Egypte te laten hagelen op mens en dier en op het veldgewas van heel Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses hief zijn staf naar de hemel, en Jahweh liet het donderen en hagelen; de bliksem schoot op de aarde, en Jahweh liet een zware hagel neerkletteren op Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","De hagelbui werd doorschoten van bliksemflitsen; zo vreselijk was de hagelslag, als men, sinds er in Egypte mensen wonen, nog nooit had beleefd. ");
INSERT INTO nld1939_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","De hagel teisterde over heel Egypte mens en dier, die zich buitenshuis bevonden: al het gewas op het veld werd door de hagel verpletterd, al de bomen op het land braken middendoor. ");
INSERT INTO nld1939_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Alleen in het land Gósjen, waar de Israëlieten woonden, hagelde het niet. ");
INSERT INTO nld1939_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Nu liet Farao Moses en Aäron ontbieden en zei hun: Thans moet ik wel mijn schuld bekennen; Jahweh is in zijn recht, en ik en mijn volk hebben ongelijk. ");
INSERT INTO nld1939_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Weest dus mijn voorspraak bij Jahweh. Het donderen en hagelen heeft lang genoeg geduurd. Ik zal u laten vertrekken; gij behoeft niet langer hier te blijven. ");
INSERT INTO nld1939_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses antwoordde: Zodra ik buiten de stad ben, zal ik mijn handen tot Jahweh uitstrekken; het onweer zal ophouden, en er zal geen hagel meer vallen, opdat gij moogt weten, dat de aarde aan Jahweh behoort. ");
INSERT INTO nld1939_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Maar ik ben er zeker van, dat gij met uw hof ook nu nog den God Jahweh niet vreest. ");
INSERT INTO nld1939_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Het vlas en de gerst waren intussen vernield: want de gerst rijpte al in de aren, en het vlas stond in bloei. ");
INSERT INTO nld1939_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tarwe en spelt werden niet neergeslagen, omdat die later in de tijd zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Toen Moses van Farao was heengegaan, en buiten de stad was gekomen, strekte hij zijn handen tot Jahweh uit. Het onweer en de hagel hielden op, en er stroomde geen regen meer op de aarde. ");
INSERT INTO nld1939_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Toen Farao zag, dat regen, hagel en onweer hadden opgehouden, bleef hij met zijn hof verstokt in de zonde volharden. ");
INSERT INTO nld1939_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Farao bleef hardnekkig, en liet de Israëlieten niet vertrekken, zoals Jahweh door Moses voorspeld had. ");
INSERT INTO nld1939_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Toen sprak Jahweh tot Moses: Ga naar Farao. Waarachtig, Ik heb zijn hart en dat van zijn dienaars verhard, opdat ik mijn tekenen onder hen zou kunnen verrichten, ");
INSERT INTO nld1939_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","opdat gij uw zonen en kleinzonen zoudt kunnen verhalen, hoe Ik tegen de Egyptenaren ben opgetreden, en welke wonderen Ik onder hen heb gewrocht, en opdat gij zoudt weten, dat Ik Jahweh ben. ");
INSERT INTO nld1939_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moses en Aäron gingen dus naar Farao en zeiden tot hem: Zo spreekt Jahweh, de God der Hebreën! Hoelang weigert gij nog, u aan Mij te onderwerpen? Laat mijn volk vertrekken, om Mij te vereren. ");
INSERT INTO nld1939_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Want zo ge weigert, mijn volk te laten vertrekken, zal Ik morgen met sprinkhanen uw gebied overstromen. ");
INSERT INTO nld1939_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Zij zullen de bodem van het land bedekken, zodat men geen grond meer kan zien; zij zullen het overschot, dat u door de hagel gespaard bleef, tot het laatste toe verslinden, en alle bomen, die op uw velden groeien, kaal vreten. ");
INSERT INTO nld1939_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Uw huizen en de huizen uwer hovelingen en van alle Egyptenaren zullen er zo vol van zijn, als uw vaders en voorvaders nooit hebben beleefd al de tijd, dat zij in dit land wonen tot de dag van vandaag. Toen keerde hij Farao de rug toe, en ging van hem heen. ");
INSERT INTO nld1939_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Maar de hovelingen van Farao zeiden tot hem: Hoelang zal die man ons nog schade moeten berokkenen? Laat die mensen toch vertrekken, om Jahweh, hun God, te vereren. Beseft ge nu nog niet, dat Egypte zo te gronde gaat? ");
INSERT INTO nld1939_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Nu werden Moses en Aäron opnieuw bij Farao ontboden, en hij zeide tot hen: Ge kunt vertrekken, om Jahweh, uw God, te vereren. Maar wie moeten er allemaal mee? ");
INSERT INTO nld1939_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses antwoordde: Jong en oud moet mee; we willen gaan met onze zonen en dochters, met onze schapen en runderen; want we willen feest vieren ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Hij zeide tot hen: Even zeker mag Jahweh u bijstaan, als ik u met uw kinderen laat vertrekken. Het is duidelijk, dat gij kwaad in uw schild voert. ");
INSERT INTO nld1939_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Maar het zal niet gebeuren! De mannen kunnen gaan, om Jahweh te vereren; want dat hebt gij gevraagd. Zo joeg men hen van Farao weg. ");
INSERT INTO nld1939_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Toen sprak Jahweh tot Moses: Strek uw hand uit over Egypte, om de sprinkhanen te laten komen. Zij zullen neerstrijken op het land van Egypte, en al het veldgewas wegvreten, dat de hagel gespaard heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","En Moses strekte zijn staf uit over Egypte. De hele dag en de hele nacht liet Jahweh een oostenwind waaien over het land van Egypte, en in de morgen bracht de oostenwind de sprinkhanen mee. ");
INSERT INTO nld1939_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","De sprinkhanen verspreidden zich over heel Egypte en streken neer op heel het grondgebied van Egypte, in zulke geweldige zwermen, als er tevoren nooit waren geweest, en ook later nooit meer zullen zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Heel de oppervlakte van het land was er mee bedekt, en de grond zag er zwart van. Zij verslonden al het veldgewas en vraten alle vruchtbomen kaal, die door de hagel waren gespaard, zodat er in heel Egypte geen groen aan de bomen bleef en geen gewas op het veld. ");
INSERT INTO nld1939_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nu liet Farao in allerijl Moses en Aäron ontbieden en zeide: Ik heb gezondigd tegen Jahweh, uw God, en tegen u. ");
INSERT INTO nld1939_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Vergeef mij deze keer nog mijn zonden, en bidt tot Jahweh, uw God, dat Hij ten minste deze dodelijke ramp van mij wegneemt. ");
INSERT INTO nld1939_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","En Moses ging van Farao heen, en bad tot Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","En Jahweh keerde de wind, en liet een krachtige westenwind waaien, die de sprinkhanen meevoerde en in de Rode Zee dreef: op het hele grondgebied van Egypte bleef geen enkele sprinkhaan meer over. ");
INSERT INTO nld1939_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Maar Jahweh verhardde het hart van Farao, zodat hij de Israëlieten niet liet vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Toen sprak Jahweh tot Moses: Strek uw hand uit naar de hemel, en er zal een duisternis over Egypte vallen zo dicht, dat men ze tasten kan. ");
INSERT INTO nld1939_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","En Moses strekte zijn hand naar de hemel uit, en er viel een dikke duisternis over heel Egypte, drie dagen lang, ");
INSERT INTO nld1939_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","zodat men elkaar niet kon zien, en drie dagen lang niemand van zijn plaats kon; maar voor de Israëlieten bleef het licht overal, waar zij woonden. ");
INSERT INTO nld1939_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Nu liet Farao Moses en Aäron ontbieden, en zeide: Gaat heen, om Jahweh te vereren. Uw kinderen kunnen met u meegaan, maar uw schapen en runderen blijven hier. ");
INSERT INTO nld1939_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses antwoordde: Onmogelijk; ge moet ons toch slacht(-) en brandoffers mee laten nemen, die wij aan Jahweh, onzen God, zullen brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Daarom moet ook onze kudde met ons mee: geen hoef zal achterblijven. Want daaruit hebben we een keuze te doen, om Jahweh, onzen God, te vereren; anders zouden we niet weten, wat we Jahweh, onzen God, moesten offeren, als we ter plaatse zijn aangekomen. ");
INSERT INTO nld1939_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Maar Jahweh verhardde het hart van Farao, zodat hij weigerde, hen te laten vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao zeide hem: Pak u weg, en waag het niet, mij nog onder de ogen te komen: want wanneer ge me nog eens onder de ogen komt, zult ge sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses antwoordde: Zoals ge zegt; ik zal u niet meer onder de ogen komen. ");
INSERT INTO nld1939_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Jahweh had tot Moses gezegd: Nog één plaag zal Ik over Farao en over Egypte brengen; dan zal hij u van hier laten gaan. En wanneer hij u eindelijk laat vertrekken, zal hij u zelfs met geweld verdrijven. ");
INSERT INTO nld1939_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Zeg dus aan het volk, dat ze allen, mannen en vrouwen, van hun kennissen gouden en zilveren sieraden eisen. ");
INSERT INTO nld1939_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Want reeds had Jahweh de Egyptenaren murw geslagen; bovendien was Moses een man van hoog aanzien in Egypte, zowel bij het hof van Farao als bij het volk. ");
INSERT INTO nld1939_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","En Moses vervolgde: Zo spreekt Jahweh! Te middernacht zal Ik door Egypte trekken. ");
INSERT INTO nld1939_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dan zullen alle eerstgeborenen in het land van Egypte sterven, van den eerstgeborene van Farao af, die op zijn troon is gezeten, tot den eerstgeborene van de slavin, die achter de handmolen zit; en al het eerstgeborene van het vee bovendien. ");
INSERT INTO nld1939_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Er zal een zo luid geschrei over heel Egypte weerklinken, als er nog nooit is geweest, en ook nooit meer zal zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Maar geen hond zal er tegen een van Israëls kinderen blaffen, tegen mens noch dier; opdat gij moogt weten, dat Jahweh onderscheid maakt tussen Egypte en Israël. ");
INSERT INTO nld1939_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dan zal heel dit hof hier naar mij toe komen, zich voor mij ter aarde werpen en zeggen: Ga heen met al het volk, dat u volgen wil. En dan zal ik gaan! Toen liep hij, ziedend van toorn, van Farao weg. ");
INSERT INTO nld1939_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Want Jahweh had Moses en Aäron voorspeld: Farao zal niet naar u luisteren, opdat mijn wonderen in Egypte nog groter worden. ");
INSERT INTO nld1939_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses en Aäron hadden al deze wonderen voor Farao verricht; maar Jahweh had het hart van Farao verhard, zodat hij de Israëlieten niet uit zijn land liet vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Toen sprak Jahweh tot Moses en Aäron in Egypte: ");
INSERT INTO nld1939_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Deze maand zal voor u de beginmaand zijn, de eerste der maanden van het jaar. ");
INSERT INTO nld1939_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Beveelt heel de gemeenschap van Israël: Op de tiende van deze maand moet ieder voor zijn familie een lam nemen, één voor elk gezin. ");
INSERT INTO nld1939_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Indien het gezin voor een lam niet talrijk genoeg is, moet hij er zijn naasten buurman bij uitnodigen; ge moet betreffende het lam het aantal personen berekenen naar wat ieder gewoon is te eten. ");
INSERT INTO nld1939_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Het lam moet zonder gebrek zijn, een mannelijk dier en één jaar oud; ge moogt het uit de schapen of geiten kiezen. ");
INSERT INTO nld1939_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Gij moet het bewaren tot de veertiende dag van deze maand, waarop heel de gemeenschap van Israël het in de avondschemering moet slachten. ");
INSERT INTO nld1939_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Vervolgens moeten zij het bloed ervan nemen, en er de beide deurposten en de bovendorpel mee bestrijken van de huizen, waar zij het zullen eten. ");
INSERT INTO nld1939_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","In diezelfde nacht moeten zij het vlees eten, dat in het vuur gebraden moet zijn, met ongedesemde broden en bittere kruiden er bij. ");
INSERT INTO nld1939_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Niets ervan moogt ge rauw eten of in water gekookt, maar het moet in het vuur zijn gebraden, kop, poten en romp aan één stuk. ");
INSERT INTO nld1939_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ook moogt ge niets tot de morgen bewaren, maar wat er van over is, moet ge tegen de morgen verbranden. ");
INSERT INTO nld1939_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Zó moet ge het eten: uw lenden omgord, schoenen aan de voeten, uw stok in de hand; en gij moet het eten met grote haast, want het is het Pascha van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Want in deze nacht zal Ik door Egypte trekken, in Egypte alle eerstgeborenen slaan van mensen en dieren, en aan alle goden van Egypte mijn straffen voltrekken: Ik Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Maar het bloed aan de huizen zal het teken zijn, dat gij daar woont; en wanneer Ik dat bloed zal zien, zal Ik genadig aan u voorbijgaan, zodat u geen dodelijke slag zal treffen, als Ik Egypte teister. ");
INSERT INTO nld1939_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Deze dag moet voor u een gedenkdag zijn, die ge als een feest ter ere van Jahweh moet vieren. Gij zult hem vieren van geslacht tot geslacht: een eeuwige wet. ");
INSERT INTO nld1939_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Dan moet ge zeven dagen lang ongedesemde broden eten. Reeds op de eerste dag moet ge het zuurdesem uit uw huizen verwijderen; en iedereen die van de eerste tot de zevende dag gedesemd brood durft eten, zal van Israël worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Op de eerste dag zult ge een godsdienstige bijeenkomst houden, en evenzo op de zevende dag; op die dagen mag geen enkele arbeid worden verricht; ge moogt alleen bereiden, wat iedereen voor zijn voedsel nodig heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Onderhoudt dit gebod; want op deze dag heb Ik uw legerscharen uit Egypte geleid. Ge moet deze dag houden van geslacht tot geslacht als een eeuwige wet. ");
INSERT INTO nld1939_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In de eerste maand, van de avond van de veertiende dag af, zult ge dus ongedesemd brood eten tot aan de avond van de een en twintigste van de maand. ");
INSERT INTO nld1939_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Zeven dagen lang mag in uw huizen geen zuurdesem worden gevonden; en iedereen, vreemde zowel als landgenoot, die gedesemd brood durft eten, zal van de gemeenschap van Israël worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Geen gedesemd brood moogt ge eten, waar ge ook woont, maar enkel ongedesemd brood. ");
INSERT INTO nld1939_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Nu ontbood Moses al de oudsten van Israël, en sprak tot hen: Gaat heen, haalt de schapen voor uw gezinnen en slacht het paasoffer. ");
INSERT INTO nld1939_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Dan moet ge een bosje hysop nemen, dit in het bloed dopen, dat in een schaal is opgevangen, en wat bloed uit de schaal aan de bovendorpel en de beide zijposten strijken; daarna mag niemand van u tot de morgen buiten de deur van zijn huis komen. ");
INSERT INTO nld1939_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Want Jahweh zal rondgaan, om Egypte te slaan; maar als Hij het bloed op de bovendorpel en op de beide zijposten ziet, zal Hij die deur genadig voorbijgaan en den verderver beletten, uw huizen binnen te gaan, om u te treffen. ");
INSERT INTO nld1939_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Gij moet dit onderhouden als een eeuwige wet voor u en uw kinderen. ");
INSERT INTO nld1939_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Wanneer gij dus in het land zijt gekomen, dat Jahweh u zal geven, zoals Hij beloofd heeft, onderhoudt dan dit voorschrift. ");
INSERT INTO nld1939_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","En wanneer uw kinderen u vragen, wat dat betekent, ");
INSERT INTO nld1939_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","moet ge hun zeggen: Dit is het paasoffer van Jahweh, die de huizen van Israëls kinderen in Egypte genadig voorbijging en onze gezinnen heeft gespaard, toen Hij de Egyptenaren trof. Toen wierp het volk zich op de knieën en boog zich ter aarde. ");
INSERT INTO nld1939_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Daarna gingen de kinderen Israëls heen, en volbrachtten nauwkeurig, wat Jahweh aan Moses en Aäron bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","In het holst van de nacht sloeg Jahweh al de eerstgeborenen in het land van Egypte, van den eerstgeborene van Farao af, die op de troon was gezeten, tot den eerstgeborene van wie in de gevangenis zat; en eveneens al het eerstgeborene van het vee. ");
INSERT INTO nld1939_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","En Farao met heel zijn hof en heel Egypte vlogen die nacht overeind, en er weerklonk een vreselijk geschrei in Egypte; want er was geen huis, waar geen dode was. ");
INSERT INTO nld1939_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nog in de nacht ontbood hij Moses en Aäron en sprak: Maakt u gereed, trekt weg van mijn volk; gaat heen met de zonen Israëls, om Jahweh te vereren, zoals gij gezegd hebt. ");
INSERT INTO nld1939_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Neemt ook uw schapen en runderen mee, zoals ge gevraagd hebt, als ge maar heen gaat; en bidt ook voor mij om genade. ");
INSERT INTO nld1939_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ook de Egyptenaren drongen aan, dat het volk toch zo vlug mogelijk uit het land zou vertrekken; want ze zeiden: Anders zullen we allen sterven! ");
INSERT INTO nld1939_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","En voordat het deeg gedesemd was, moest het volk het meenemen: hun baktroggen droegen zij in hun mantels gewikkeld op hun schouders. ");
INSERT INTO nld1939_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Maar de Israëlieten deden, wat Moses bevolen had, en eisten van de Egyptenaren zilveren en gouden sieraden en kleren. ");
INSERT INTO nld1939_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","En daar Jahweh de Egyptenaren murw had gemaakt, gaven zij het volk, al wat het maar eiste. Zo schudden zij de Egyptenaren uit. ");
INSERT INTO nld1939_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nu braken de Israëlieten van Raämses op, in de richting van Soekkot; ongeveer zeshonderd duizend man te voet, de kinderen niet meegerekend; ");
INSERT INTO nld1939_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","maar ook een menigte vreemden trok met hen mee, behalve nog de talloze kudden schapen en runderen. ");
INSERT INTO nld1939_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Van het deeg, dat zij uit Egypte hadden meegenomen, moesten zij ongedesemde broden bakken; want ze hadden geen gedesemd deeg, daar de Egyptenaren hen hadden verjaagd, zonder hun de tijd te laten, om voedsel voor de reis te bereiden. ");
INSERT INTO nld1939_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Het verblijf van de Israëlieten in Egypte had vier honderd dertig jaren geduurd. ");
INSERT INTO nld1939_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Er waren op de dag af vierhonderd dertig jaren verlopen, toen al de legerscharen van Jahweh uit het land van Egypte trokken. ");
INSERT INTO nld1939_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Het was een nacht van waken voor Jahweh, toen Hij hen uit Egypte deed trekken; dit is de nacht van Jahweh, de nacht van waken voor alle kinderen Israëls van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jahweh sprak tot Moses en Aäron: Dit is het voorschrift voor het Pascha. Geen buitenlander mag er van eten. ");
INSERT INTO nld1939_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Iedere slaaf, die ge voor geld hebt gekocht, en te voren besneden hebt, mag ervan eten; ");
INSERT INTO nld1939_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","maar een inboorling en dagloner mogen er niet van eten. ");
INSERT INTO nld1939_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In een en hetzelfde huis moet het worden opgegeten, en van het vlees moogt ge niets buitenshuis brengen; ook moogt ge de beenderen niet breken. ");
INSERT INTO nld1939_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Heel de gemeenschap van Israël moet het toebereiden. ");
INSERT INTO nld1939_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","En wanneer een vreemdeling bij u woont en hij wil ter ere van Jahweh het Pascha vieren, dan moeten eerst al de mannelijke leden van zijn gezin worden besneden, voor hij mag aanzitten, om het te vieren; hij staat dan gelijk met een ingezetene. Geen onbesnedene mag ervan eten; ");
INSERT INTO nld1939_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","dit geldt zowel voor den ingezetene, als voor den vreemdeling, die in uw midden woont. ");
INSERT INTO nld1939_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Alle Israëlieten volbrachten nauwkeurig, wat Jahweh aan Moses en Aäron bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Nog op diezelfde dag, dat Jahweh de Israëlieten met hun legerscharen uit het land van Egypte leidde, ");
INSERT INTO nld1939_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","En Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Wijd Mij alle eerstgeborenen toe. Wat bij de kinderen Israëls de moederschoot opent, bij mens of dier, behoort Mij! ");
INSERT INTO nld1939_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","sprak Moses tot het volk: Gedenk deze dag, waarop gij uit Egypte, uit het slavenhuis, zijt getrokken, omdat Jahweh u met sterke hand van hier heeft weggevoerd. Er mag geen gedesemd brood worden gegeten ");
INSERT INTO nld1939_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","op de dag van de maand Abib, waarop gij zijt weggetrokken. ");
INSERT INTO nld1939_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","En wanneer Jahweh u in het land van de Kanaänieten, Chittieten, Amorieten, Chiwwieten en Jeboesieten heeft gebracht: het land, dat Jahweh u geven zal, zoals Hij uw vaderen heeft gezworen, het land, dat druipt van melk en honing: volbrengt dan in deze maand, het volgende gebod: ");
INSERT INTO nld1939_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Eet zeven dagen ongedesemde broden, en op de zevende dag moet het feest zijn ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Gedurende zeven dagen moeten ongedesemde broden worden gegeten: er mag geen gedesemd brood worden gegeten: zelfs mag dan in heel uw gebied geen zuurdesem worden gevonden. ");
INSERT INTO nld1939_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","En op die dag moet gij uw zoon vertellen: Dit geschiedt, om wat Jahweh voor mij heeft gedaan, toen ik uit Egypte trok. ");
INSERT INTO nld1939_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Prent het u in als een merk op uw hand en als een teken op uw voorhoofd, opdat de wet van Jahweh op uw lippen moge blijven; want met sterke hand heeft Jahweh u uit Egypte geleid. ");
INSERT INTO nld1939_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Onderhoudt dit gebod jaar in jaar uit, op de tijd, die daarvoor is bepaald. ");
INSERT INTO nld1939_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wanneer Jahweh u dus naar het land der Kanaänieten heeft gebracht, zoals Hij u en uw vaderen heeft gezworen, en het u heeft gegeven, ");
INSERT INTO nld1939_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","dan moet ge al wat de moederschoot opent, aan Jahweh afstaan. Elk eerste jong, dat ge krijgt van het vee, zal voor Jahweh zijn, als het een mannelijk dier is. ");
INSERT INTO nld1939_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Maar elk eerste jong van een ezelin, moet ge loskopen met een schaap; indien ge het niet wilt lossen, moet ge het de nek breken. Alle eerstgeborenen van de mensen moet ge loskopen, als het jongens zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","En wanneer uw zoon u later vraagt, wat dat betekent, zeg hem dan: “Met sterke hand heeft Jahweh ons uit Egypte geleid, uit het slavenhuis. ");
INSERT INTO nld1939_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Want toen Farao zich hardnekkig tegen ons vertrek bleef verzetten, heeft Jahweh alle eerstgeborenen in Egypte gedood, zowel de eerstgeborenen van de mensen, als van het vee. Daarom breng ik Jahweh ieder mannelijk dier ten offer, dat de moederschoot opent, en koop ik iederen eerstgeboren zoon los. ");
INSERT INTO nld1939_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Prent het u in als een merk op uw hand en als een teken op uw voorhoofd; want met sterke hand heeft Jahweh ons uit Egypte geleid.” ");
INSERT INTO nld1939_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nadat Farao het volk had laten gaan, leidde God hen niet langs de weg, die naar het land der Filistijnen voerde, hoewel die de kortste was. Want God dacht, dat het volk wel eens spijt kon krijgen, wanneer het tegenstand zou ontmoeten, en dan naar Egypte zou willen terugkeren. ");
INSERT INTO nld1939_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Daarom liet God het volk een omweg maken door de woestijn naar de Rode Zee. In volmaakte orde trokken de Israëlieten op uit het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses nam het gebeente van Josef met zich mee; want Josef had de kinderen Israëls bezworen: Wanneer God op u heeft neergezien, voert dan mijn gebeente van hier met u mee. ");
INSERT INTO nld1939_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Zo braken zij van Soekkot op en sloegen hun legerplaats op te Etam aan de rand van de woestijn. ");
INSERT INTO nld1939_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","En Jahweh ging voor hen uit, overdag in een wolkkolom, om hun de weg te wijzen, en des nachts in een vuurzuil, om hen voor te lichten, zodat zij dag en nacht konden trekken. ");
INSERT INTO nld1939_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Overdag week de wolkkolom niet van de spits van het volk, en de vuurzuil niet in de nacht. ");
INSERT INTO nld1939_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nu sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Zeg de kinderen Israëls, dat zij van richting veranderen en zich moeten legeren bij Pi-Hachirot, tussen Migdol en de zee; bij de zee recht tegenover Baal-Sefon moet ge uw legerplaats opslaan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Dan zal Farao denken, dat de Israëlieten in het land zijn verdwaald en in de woestijn zijn blijven steken. ");
INSERT INTO nld1939_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","En Ik zal het hart van Farao verharden, zodat hij hen achterna zal zetten. Dan zal Ik mijn heerlijkheid tonen aan Farao en heel zijn legermacht, en de Egyptenaren zullen weten, dat Ik Jahweh ben. Zo deden ze dan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Toen dan ook aan den koning van Egypte werd bericht, dat het volk was gevlucht, sloeg de stemming van Farao en zijn hovelingen jegens het volk om, en ze dachten: Wat hebben we toch gedaan, dat we Israël uit onze dienst hebben laten wegtrekken? ");
INSERT INTO nld1939_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hij liet zijn wagen inspannen, riep zijn krijgsvolk op, ");
INSERT INTO nld1939_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","en nam zes honderd van de beste strijdwagens, behalve de overige wagens van Egypte, alle met de dapperste strijders bezet. ");
INSERT INTO nld1939_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Want Jahweh had het hart van Farao, den koning van Egypte, verhard, zodat hij de Israëlieten achtervolgde, ofschoon de kinderen Israëls waren vertrokken onder de schutse van een machtige hand. ");
INSERT INTO nld1939_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","De Egyptenaren joegen hen na met al de paarden en wagens van Farao, met zijn ruiters en leger, en bereikten hen, terwijl ze nog aan de zee waren gelegerd bij Pi-Hachirot, tegenover Baal-Sefon. ");
INSERT INTO nld1939_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Toen Farao zo dicht was genaderd, en de Israëlieten hun ogen opsloegen, zagen zij ineens de Egyptenaren achter zich aan. Nu werden de kinderen Israëls zeer beangst, riepen Jahweh aan, ");
INSERT INTO nld1939_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","en zeiden tot Moses: Waren er in Egypte geen graven genoeg, dat ge ons hebt meegenomen, om te sterven in de woestijn? Wat hebt ge gedaan, met ons uit Egypte weg te voeren! ");
INSERT INTO nld1939_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Hebben we u al niet in Egypte gezegd: Laat ons met rust! We willen de Egyptenaren blijven dienen; want het is beter, de Egyptenaren te dienen, dan te sterven in de woestijn. ");
INSERT INTO nld1939_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Maar Moses sprak tot het volk: Weest maar niet bang; blijft staan en ge zult de hulp van Jahweh ondervinden, die Hij u heden verleent. Waarachtig, de Egyptenaren, die ge op het ogenblik ziet, zult ge nooit meer zien, in der eeuwigheid niet! ");
INSERT INTO nld1939_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jahweh zal voor u strijden; gij kunt rustig toeschouwen. ");
INSERT INTO nld1939_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nu sprak Jahweh tot Moses: Wat roept ge tot Mij? Beveel de Israëlieten, op te breken! ");
INSERT INTO nld1939_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Steek uw staf in de hoogte, strek uw hand uit over de zee en splijt haar in tweeën, zodat de kinderen Israëls droogvoets door de zee kunnen gaan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Zie, Ik zal het hart der Egyptenaren verharden, zodat ze achter hen aan zullen trekken; dan zal Ik mijn heerlijkheid tonen aan Farao en zijn legermacht, aan zijn wagens en ruiters. ");
INSERT INTO nld1939_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","En wanneer Ik mijn heerlijkheid aan Farao, zijn wagens en ruiters getoond heb, zullen de Egyptenaren weten, dat Ik Jahweh ben! ");
INSERT INTO nld1939_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Toen veranderde de engel Gods, die het leger van Israël vooruitging, van plaats, en stelde zich achter hen; de wolkkolom verliet de plaats aan hun spits en ging achter hen staan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Zo stond de wolk tussen het leger der Egyptenaren en dat van Israël in: aan de ene kant was zij donker, aan de andere kant verlichtte zij de nacht, zodat gedurende de hele nacht de een den ander niet kon naderen. ");
INSERT INTO nld1939_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nu strekte Moses zijn hand uit over de zee. En Jahweh wierp de zee terug door een sterke oostenwind, die de hele nacht bleef waaien. Hij maakte de zee droog land; want de wateren waren in tweeën gespleten. ");
INSERT INTO nld1939_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","En de kinderen Israëls trokken droogvoets midden door de zee, daar de wateren aan hun rechter(-) en hun linkerzij als een muur bleven staan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","De Egyptenaren joegen hen na, en alle paarden van Farao met zijn wagens en ruiters trokken achter hen aan naar het midden der zee. ");
INSERT INTO nld1939_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Maar in de morgenstond wierp Jahweh in de vuur(-) en wolkkolom een blik op het leger der Egyptenaren: Hij bracht het leger der Egyptenaren in verwarring, ");
INSERT INTO nld1939_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","liet de raderen van hun wagens aflopen, en vertraagde hun mars. En de Egyptenaren riepen: Laat ons vluchten voor Israël; want Jahweh strijdt voor hen tegen Egypte! ");
INSERT INTO nld1939_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nu sprak Jahweh tot Moses: Strek uw hand uit over de zee; dan golven de wateren terug over de Egyptenaren met hun wagens en ruiters. ");
INSERT INTO nld1939_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moses strekte zijn hand uit over het water, en tegen de morgen golfde de zee naar haar oude plaats terug. En toen de Egyptenaren naar de andere kant wilden vluchten, dreef Jahweh ze terug naar het midden der zee; ");
INSERT INTO nld1939_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","de wateren stroomden terug en overstelpten al de wagens en ruiters van het leger van Farao, die hen in de zee achtervolgden; geen een bleef er over. ");
INSERT INTO nld1939_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Maar Israëls kinderen waren droogvoets midden door de zee getrokken, daar de wateren aan hun rechter(-) en linkerzij als een muur bleven staan. ");
INSERT INTO nld1939_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zo redde Jahweh Israël op die dag uit de greep van Egypte, en zag Israël de lijken der Egyptenaren op het strand der zee. ");
INSERT INTO nld1939_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","En toen het volk van Israël het machtige wonder aanschouwde, dat Jahweh aan de Egyptenaren had gewrocht, kreeg het ontzag voor Jahweh, en vertrouwde het op Jahweh en op zijn dienaar Moses. ");
INSERT INTO nld1939_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Toen zongen Moses en Israëls kinderen dit lied ter ere van Jahweh: Laat ons zingen voor Jahweh, Want hoog is Hij verheven; Paard en ruiter wierp Hij in zee! ");
INSERT INTO nld1939_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mijn kracht is Jahweh en mijn roem, Want Hij heeft mij gered. Hij is mijn God, dien ik wil prijzen, De God van mijn vaderen, dien ik verheerlijk. ");
INSERT INTO nld1939_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Een krijgsheld is Jahweh, Jahweh is zijn Naam! ");
INSERT INTO nld1939_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Farao’s wagens en zijn leger wierp Hij in zee, In de Rode Zee ligt de bloem zijner helden verdronken. ");
INSERT INTO nld1939_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","De golven bedekten hen, Zij zakten als een steen in de diepte. ");
INSERT INTO nld1939_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Uw rechterhand, Jahweh, is heerlijk door kracht, Uw rechterhand, Jahweh, verplettert den vijand! ");
INSERT INTO nld1939_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In de volheid van uw majesteit werpt Gij uw tegenstanders neer, Laat Gij de vrije loop aan uw toorn, Die als kaf hen verteert. ");
INSERT INTO nld1939_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Door uw briesen hoopten de wateren zich op, Bleven de golven staan als een dam, Stolden de baren in het midden der zee. ");
INSERT INTO nld1939_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","De vijand sprak: Ik zet ze na, haal ze in, Ik verdeel de buit, ik zal mij verzadigen; Ik trek mijn zwaard, Mijn hand slaat ze neer. ");
INSERT INTO nld1939_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Maar Gij hebt met uw adem geblazen en de zee golfde over hen heen; Zij zonken als lood in de vreselijke wateren. ");
INSERT INTO nld1939_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wie is als Gij onder de goden, o Jahweh, Wie als Gij, heerlijk door heiligheid, Geducht om uw roemvolle daden, En om de wonderen, die Gij wrocht. ");
INSERT INTO nld1939_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Gij strekt uw rechterhand uit, En de aarde verslindt ze! ");
INSERT INTO nld1939_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","In uw goedheid leidt Gij het volk, dat Gij hebt verlost, In uw kracht voert Gij het naar uw heilige woning! ");
INSERT INTO nld1939_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","De volken horen het en beven, Angst overvalt Filistea’s bewoners. ");
INSERT INTO nld1939_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","De vorsten van Edom zijn van schrik overmand, De koningen van Moab rillen ervan. Onrust grijpt alle bewoners van Kanaän aan, ");
INSERT INTO nld1939_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bevangen door angst en ontzetting; Voor uw geweldige kracht Worden ze stom als een steen, Terwijl uw volk, o Jahweh, zijn doortocht voltooit, Het volk, dat Gij U hebt verworven, is overgestoken. ");
INSERT INTO nld1939_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nu brengt en plant Gij hen Op de berg van uw erfdeel; Op de plaats van uw woning, o Jahweh, die Gij U hebt bereid: Heer, in het heilige oord, Dat uw handen hebben gegrond! ");
INSERT INTO nld1939_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jahweh zal heersen Voor eeuwig en immer! ");
INSERT INTO nld1939_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Want toen de paarden van Farao De zee introkken, met zijn wagens en ruiters, Bedolf Jahweh hen met de golven der zee; Maar Israëls kinderen trokken er droogvoets doorheen! ");
INSERT INTO nld1939_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","En Mirjam de profetes, de zuster van Aäron, nam de tamboerijn ter hand, en terwijl alle vrouwen met tamboerijnen haar dansende volgden, ");
INSERT INTO nld1939_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","herhaalde Mirjam voor hen het refrein: Laat ons zingen voor Jahweh, Want hoog is Hij verheven, Paard en ruiter wierp Hij in zee! ");
INSERT INTO nld1939_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Daarna liet Moses Israël van de Rode Zee opbreken en trokken zij naar de woestijn van Sjoer. Toen zij al drie dagreizen ver de woestijn in waren getrokken, zonder water te vinden, ");
INSERT INTO nld1939_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","bereikten zij Mara. Maar ze konden het water van Mara niet drinken, omdat het bitter was; daarom noemde men het Mara. ");
INSERT INTO nld1939_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Toen begon het volk tegen Moses te morren en zeide: Wat moeten we drinken? ");
INSERT INTO nld1939_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Hij bad tot Jahweh, en Jahweh wees hem een stuk hout aan; hij wierp het in het water, en het water werd zoet. Op deze plaats gaf hij hun voorschriften en wetten, en stelde hen daar voor de keus: ");
INSERT INTO nld1939_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Zo ge luistert naar de stem van Jahweh, uw God, en doet wat recht is in zijn ogen, zo ge zijn geboden in acht neemt, en al zijn voorschriften onderhoudt, zal Ik geen van de kwalen, waarmee Ik Egypte heb geteisterd, u laten treffen, maar genees Ik u juist; Ik, Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Vandaar gingen zij naar Elim, waar twaalf waterbronnen zijn en zeventig palmen staan, en zij sloegen de legerplaats op aan het water. ");
INSERT INTO nld1939_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nadat heel de gemeenschap van Israël van Elim was opgebroken, trokken zij naar de woestijn van Sin, die tussen Elim en de Sinaï ligt; het was op de vijftiende dag van de tweede maand na hun uittocht uit Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Weer begon heel de gemeente van Israël in de woestijn tegen Moses en Aäron te morren, ");
INSERT INTO nld1939_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","en de kinderen Israëls zeiden tot hen: Waren we maar in Egypte door de hand van Jahweh gestorven, toen we bij de vleespotten zaten en volop brood konden eten; waarachtig, ge hebt ons naar deze woestijn gebracht, om heel deze menigte van honger te doen sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Toen sprak Jahweh tot Moses: Zie, Ik zal voor u brood uit de hemel doen regenen; en het volk zal iedere dag zijn dagelijks deel kunnen rapen. Maar Ik stel het tegelijk op de proef of het mijn Wet wil beleven of niet: ");
INSERT INTO nld1939_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Op de zesde dag moeten ze het dubbele meebrengen en toebereiden, van wat zij iedere dag rapen. ");
INSERT INTO nld1939_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Nu spraken Moses en Aäron tot al de Israëlieten: Hedenavond zult ge weten, dat Jahweh u uit Egypte heeft geleid, ");
INSERT INTO nld1939_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","en morgen zult ge de glorie van Jahweh aanschouwen, ofschoon Jahweh het gemor tegen Hem heeft gehoord. Want wat betekenen wij, dat gij zoudt morren tegen ons. ");
INSERT INTO nld1939_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","En Moses vervolgde: Als Jahweh u vanavond vlees te eten geeft, en morgenvroeg volop brood, dan is het ondanks uw gemor tegen Jahweh, dat Hij heeft gehoord! Want wat betekenen wij? Niet tegen ons is uw morren maar tegen Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","En Moses zeide tot Aäron: Beveel heel de gemeenschap van Israël: Treedt voor het aanschijn van Jahweh; want Hij heeft uw morren gehoord. ");
INSERT INTO nld1939_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Toen Aäron dit bevel had overgebracht, keerde heel de gemeenschap van Israël zich in de richting van de woestijn; en zie, daar verscheen in de wolk de glorie van Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","En Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ik heb het morren van Israëls kinderen gehoord. Zeg hun nu: Bij het vallen van de avond zult ge vlees kunnen eten, en morgenvroeg volop brood; dan zult ge weten, dat Ik, Jahweh, uw God ben! ");
INSERT INTO nld1939_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","En tegen de avond kwamen er kwartels aangevlogen, die de legerplaats bedekten. Des morgens viel er dauw rondom de legerplaats; ");
INSERT INTO nld1939_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","toen de dauw, die gevallen was, optrok, lag daar over de bodem van de woestijn een dunne korrelige laag, fijn als rijp. ");
INSERT INTO nld1939_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Toen de Israëlieten het zagen, zeiden zij tot elkander: Wat is dat? Want ze wisten niet, wat het was. Maar Moses sprak: Dit is het brood, dat Jahweh u te eten geeft. ");
INSERT INTO nld1939_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","En nu beveelt Jahweh: Laat iedereen ervan rapen, wat hij nodig heeft; een ómer per hoofd moet ge halen, naar het aantal personen, dat in uw tent woont. ");
INSERT INTO nld1939_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","De Israëlieten deden dat. De een raapte meer, de ander minder. ");
INSERT INTO nld1939_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Maar toen ze het met de ómer maten, had hij, die meer had geraapt, niet te veel, en hij, die minder had geraapt, niet te weinig: iedereen had geraapt, wat hij nodig had. ");
INSERT INTO nld1939_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","En Moses beval hun: Niemand mag er iets van tot morgen bewaren. ");
INSERT INTO nld1939_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Maar toen sommigen niet naar Moses luisterden, en er van tot de volgende morgen bewaarden, was het bedorven; er zaten wormen in, en het stonk. Daarom werd Moses vertoornd op hen. ");
INSERT INTO nld1939_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Zo raapten zij iedere morgen bijeen, wat iedereen nodig had; want als de zon warm werd, smolt het weg. ");
INSERT INTO nld1939_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Maar op de zesde dag raapten zij een dubbele hoeveelheid bijeen, twee ómer per man. En toen alle leiders der gemeenschap het aan Moses kwamen vertellen, ");
INSERT INTO nld1939_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","gaf deze ten antwoord: Dit is het juist, wat Jahweh gezegd heeft: Morgen is het een rustdag, een heilige sabbat voor Jahweh! Ge moogt nu bakken zoveel ge wilt, en koken zoveel ge wilt: en wat er overschiet, bewaart dat tot morgen. ");
INSERT INTO nld1939_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Zij bewaarden het dus tot de volgende dag, zoals Moses hun had bevolen; maar nu stonk het niet en was het niet bedorven. ");
INSERT INTO nld1939_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","En Moses sprak: Hier moet ge heden van eten; want vandaag is het sabbat ter ere van Jahweh; vandaag zult ge dus buiten niets vinden. ");
INSERT INTO nld1939_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Zes dagen kunt ge inzameling houden, maar op de zevende dag is het sabbat, dan is er niets. ");
INSERT INTO nld1939_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Toen dan ook op de zevende dag sommigen van het volk toch naar buiten gingen, om het te rapen, vonden zij niets. ");
INSERT INTO nld1939_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","En Jahweh sprak tot Moses: Hoelang weigert ge nog mijn geboden en mijn wetten te onderhouden? ");
INSERT INTO nld1939_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ziet, omdat Jahweh voor u de sabbat heeft vastgesteld, daarom geeft Hij u op de zesde dag brood voor twee dagen. Op de zevende dag blijve dus iedereen thuis, en mag niemand zijn woonplaats verlaten. ");
INSERT INTO nld1939_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Zo hield het volk op de zevende dag sabbat. ");
INSERT INTO nld1939_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","En de kinderen Israëls noemden het manna; het was wit als korianderzaad en het smaakte als honingkoek. ");
INSERT INTO nld1939_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","En Moses sprak: Zo heeft Jahweh bevolen! Vult één ómer daarmee, om het voor uw nageslacht te bewaren, opdat zij het brood mogen zien. dat Ik u in de woestijn tot spijs heb gegeven, toen Ik u uit het land van Egypte had geleid. ");
INSERT INTO nld1939_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Daarom sprak Moses tot Aäron: Neem een kruik, doe daar een volle ómer manna in, en zet die voor het aanschijn van Jahweh, om het voor uw nageslacht te bewaren. ");
INSERT INTO nld1939_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aäron vulde dus een kruik met een volle ómer manna, zoals Jahweh Moses bevolen had, en zette die ter bewaring voor de ark des Verbonds neer. ");
INSERT INTO nld1939_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Veertig jaren lang bleven de kinderen Israëls het manna eten, tot zij in bewoonde streken kwamen; zij aten het manna tot ze de grenzen van het land Kanaän hadden bereikt. ");
INSERT INTO nld1939_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","De ómer is het tiende van een efa. ");
INSERT INTO nld1939_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Daarna brak heel de gemeenschap van Israëls kinderen op, en trok uit de woestijn Sin van halte tot halte verder, volgens de aanwijzingen van Jahweh. Toen zij hun legerplaats te Refidim hadden opgeslagen, bleek daar geen drinkwater voor het volk te zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Het volk begon met Moses te twisten en zeide: Geef ons water te drinken! Moses antwoordde: Waarom zoekt ge twist met mij, en stelt ge Jahweh op de proef? ");
INSERT INTO nld1939_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Maar het volk, dat daar naar water smachtte, bleef tegen Moses morren, en zeide: Waarom hebt ge ons uit Egypte gehaald, om ons, onze kinderen en ons vee te doen sterven van dorst? ");
INSERT INTO nld1939_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Toen riep Moses tot Jahweh: Wat moet ik dan toch met dit volk beginnen; het scheelt niet veel, of ze stenigen mij! ");
INSERT INTO nld1939_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","En Jahweh gaf Moses ten antwoord: Ga met enige oudsten van Israël voor het volk uit, neem de staf mee, waarmee ge op de Nijl hebt geslagen, en begeef u op weg. ");
INSERT INTO nld1939_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Zie, Ik zal daar vóór u staan op de rots, op de Horeb; dan moet ge op de rots slaan en er zal water uitkomen, zodat het volk kan drinken. Moses deed dit ten aanschouwen van Israëls oudsten. ");
INSERT INTO nld1939_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Die plaats werd Massa en Meriba genoemd, omdat de kinderen Israëls daar hadden getwist, en Jahweh op de proef hadden gesteld door te zeggen: Is Jahweh in ons midden, of is Hij er niet? ");
INSERT INTO nld1939_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Te Refidim ook kwamen de Amalekieten, om Israël te bestrijden. ");
INSERT INTO nld1939_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Toen sprak Moses tot Josuë: Kies mannen uit, om tegen Amalek ten strijde te trekken; ik zelf zal morgen op de top van de heuvel gaan staan met de staf van God in mijn hand. ");
INSERT INTO nld1939_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josuë deed wat Moses hem had gezegd. Hij trok uit, om Amalek te bestrijden, terwijl Moses, Aäron en Choer de top van de heuvel beklommen. ");
INSERT INTO nld1939_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Zolang Moses zijn handen omhoog hield, had Israël de overhand, maar zodra hij zijn handen liet zakken, was Amalek sterker. ");
INSERT INTO nld1939_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Maar tenslotte werden de handen van Moses vermoeid. Nu namen zij een steen, legden die onder hem, en hij ging er op zitten; terwijl Aäron en Choer, ieder aan een kant, zijn handen ondersteunden, zodat zijn handen gestrekt bleven tot zonsondergang toe. ");
INSERT INTO nld1939_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Zo joeg Josuë de horden der Amalekieten over de kling. ");
INSERT INTO nld1939_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Toen sprak Jahweh tot Moses: Schrijf het ter gedachtenis in een boek, en prent het Josuë in het geheugen, dat Ik de herinnering aan Amalek onder de zon zal uitwissen. ");
INSERT INTO nld1939_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","En Moses bouwde een altaar en noemde het: Jahweh is mijn banier. ");
INSERT INTO nld1939_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Want hij sprak: De hand aan Jahweh’s banier! Jahweh strijdt tegen Amalek Van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Intussen had Jitro, de priester van Midjan, en schoonvader van Moses, alles vernomen wat God aan Moses en zijn volk had gedaan, en hoe Jahweh Israël uit Egypte had geleid. ");
INSERT INTO nld1939_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Daarom nam Jitro, Moses schoonvader, Sippora, de vrouw van Moses, die Moses vroeger had teruggezonden, ");
INSERT INTO nld1939_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","met haar beide zonen met zich mee. De een heette Gersjom; omdat hij had gezegd: Ik toef als gast in een vreemd land; ");
INSERT INTO nld1939_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","de ander heette Eliézer, want: De God van mijn vader is mijn hulp, daar Hij mij van het zwaard van Farao heeft gered. ");
INSERT INTO nld1939_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","En toen Jitro, de schoonvader van Moses, met Moses’ zonen en vrouw hem in de woestijn had bereikt, waar hij gelegerd was bij de berg van God, ");
INSERT INTO nld1939_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","liet hij Moses berichten: Ik, uw schoonvader Jitro, kom u met uw vrouw en haar beide zonen bezoeken. ");
INSERT INTO nld1939_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses ging zijn schoonvader tegemoet, boog zich neer en kuste hem. En nadat zij elkander de vrede hadden toegewenst, gingen zij de tent binnen. ");
INSERT INTO nld1939_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses verhaalde zijn schoonvader alles, wat Jahweh ter wille van Israël aan Farao en Egypte had gedaan, en hoe Jahweh hen uit alle moeilijkheden had gered, die zij op hun weg hadden ondervonden. ");
INSERT INTO nld1939_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Verheugd over al de weldaden, die Jahweh Israël had bewezen, en dat Hij hen uit de macht van Egypte had gered, ");
INSERT INTO nld1939_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","sprak Jitro: Geprezen zij Jahweh, die u uit de macht van Egypte en uit de hand van Farao heeft gered. ");
INSERT INTO nld1939_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu weet ik, dat Jahweh groter is dan alle goden; want omdat de Egyptenaren hen hadden mishandeld, heeft Hij het volk uit hun macht gered. ");
INSERT INTO nld1939_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Daarom droeg Jitro, Moses’ schoonvader, brand(-) en slachtoffers op ter ere van God, en Aäron kwam met de oudsten van Israël voor het aanschijn van God een offermaal houden met den schoonvader van Moses. ");
INSERT INTO nld1939_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","De volgende dag zette Moses zich neer, om recht te spreken over het volk, dat van de morgen tot de avond voor Moses stond. ");
INSERT INTO nld1939_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Toen de schoonvader van Moses zag, wat hij zo al voor het volk had te doen, zei hij: Wat hebt ge toch veel werk met dit volk! Waarom zit ge hier alleen, terwijl al het volk van de morgen tot de avond voor u staat? ");
INSERT INTO nld1939_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses gaf zijn schoonvader ten antwoord: Het volk komt naar mij toe, om Jahweh te raadplegen; ");
INSERT INTO nld1939_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","en wanneer zij iets met elkander hebben, komen zij eveneens naar mij toe en moet ik scheidsrechter tussen hen zijn; bovendien moet ik hen nog in de voorschriften en wetten van God onderrichten. ");
INSERT INTO nld1939_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nu sprak de schoonvader van Moses tot hem: Zo doet ge toch niet verstandig. ");
INSERT INTO nld1939_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ge vermoeit uzelf veel te veel, evenals het volk, dat voor u staat. Neen, het is voor u veel te zwaar; gij kunt het onmogelijk alleen. ");
INSERT INTO nld1939_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Luister dus naar de raad, die ik u geef, en God sta u bij! Gij moet het volk bij God vervangen, en aan God hun belangen blijven voorleggen; ");
INSERT INTO nld1939_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","gij moet hen ook in de voorschriften en wetten blijven onderrichten en hun de weg blijven leren, die zij moeten bewandelen, en alles, wat ze moeten doen. ");
INSERT INTO nld1939_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Maar verder moet ge de flinkste mannen kiezen van het hele volk, godvrezende, betrouwbare en onbaatzuchtige mensen, en die over hen aanstellen als hoofden van duizend, honderd, vijftig en tien. ");
INSERT INTO nld1939_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Die moeten dan op iedere tijd recht spreken over het volk; zij kunnen de kleinere dingen behandelen, terwijl zij alle gewichtige zaken aan u moeten voorleggen. Zo kunt ge het u zelf lichter maken, en zullen zij de last samen met u dragen. ");
INSERT INTO nld1939_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wanneer ge het zo inricht, en ook God het u zo zal bevelen, kunt gij het volhouden en gaat ook al dat volk bevredigd naar huis. ");
INSERT INTO nld1939_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses volgde de raad van zijn schoonvader en deed alles, wat hij gezegd had. ");
INSERT INTO nld1939_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses koos dus de flinkste mannen van heel Israël, en stelde ze aan tot hoofden over het volk, tot leiders van duizend, honderd, vijftig en tien. ");
INSERT INTO nld1939_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Op iedere tijd spraken zij recht over het volk; de gewichtige zaken brachten zij voor Moses, de kleinere behandelden zij zelf. ");
INSERT INTO nld1939_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Daarna nam Moses afscheid van zijn schoonvader, en keerde deze naar zijn land terug. ");
INSERT INTO nld1939_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In de derde maand, juist op dezelfde dag, dat de Israëlieten uit Egypte waren vertrokken, bereikten zij de woestijn van de Sinaï. ");
INSERT INTO nld1939_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Nadat zij van Refidim opgebroken, en in de woestijn van de Sinaï waren gekomen, sloeg Israël zijn legerplaats op in de woestijn, en legerde zich daar tegenover de berg. ");
INSERT INTO nld1939_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nu klom Moses omhoog naar God. En Jahweh riep tot hem van de berg: Dit moet ge aan het huis van Jakob zeggen, en aan Israëls zonen verkondigen: ");
INSERT INTO nld1939_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Gij hebt gezien, wat Ik aan Egypte gedaan heb, hoe Ik u op adelaarsvleugelen heb gedragen en u tot Mij heb gebracht. ");
INSERT INTO nld1939_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Zo gij Mij gehoorzaamt en mijn Verbond onderhoudt, zult gij onder alle volken mijn bijzonder eigendom zijn; want Mij behoort de hele aarde. ");
INSERT INTO nld1939_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Gij zult Mij een koninkrijk van priesters zijn en een heilig volk”. Zo moet ge tot de zonen Israëls spreken. ");
INSERT INTO nld1939_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Toen Moses terug was gekomen, riep hij de oudsten van het volk bijeen, en bracht hun alle bevelen over, die Jahweh hem had gegeven. ");
INSERT INTO nld1939_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","En het hele volk antwoordde eenstemmig: We zullen alles doen wat Jahweh geboden heeft! Nadat Moses het antwoord van het volk aan Jahweh had overgebracht, ");
INSERT INTO nld1939_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","sprak Jahweh tot Moses: Zie, Ik kom tot u in een donkere wolk, opdat het volk Mij met u zal horen spreken en u voor altijd zal geloven. Toen Moses het antwoord van het volk aan Jahweh had overgebracht, ");
INSERT INTO nld1939_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","sprak Jahweh tot Moses: Ga terug naar het volk, en zorg er voor, dat zij zich vandaag en morgen reinigen en hun kleren wassen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ze moeten zich gereed houden voor overmorgen; want op de derde dag zal Jahweh ten aanschouwen van het hele volk op de berg Sinaï neerdalen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ook moet gij het volk aan alle kanten op een afstand houden, en zeggen: Wacht u er voor, de berg te bestijgen of zelfs zijn voet te naderen. Ieder die de berg nadert, zal sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hij zal worden gestenigd of met pijlen doorboord, want geen hand mag hem aanraken; of het een dier of mens is, hij blijft niet in leven. Eerst wanneer de ramshoorn schalt, mogen zij de berg bestijgen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Nu daalde Moses van de berg af naar het volk, zorgde er voor, dat het volk zich reinigde en zijn kleren waste, ");
INSERT INTO nld1939_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","en beval hun: Houdt u gereed voor overmorgen, en laat niemand een vrouw naderen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","En op de derde dag in de morgen: donderslagen en bliksemflitsen; over de berg een donkere wolk en schetteren van bazuingeschal. Al het volk in de legerplaats rilde van angst. ");
INSERT INTO nld1939_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Maar Moses leidde het volk de legerplaats uit, God tegemoet, en men schaarde zich aan de voet van de berg. ");
INSERT INTO nld1939_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","De berg Sinaï stond van alle kanten in rook door het vuur, waarin Jahweh daar was neergedaald. De rook steeg omhoog als de rook uit een oven, de hele berg schudde heftig, ");
INSERT INTO nld1939_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","en het bazuingeschal schetterde luider en luider. Nu begon Moses te spreken, en God antwoordde hem in de donder. ");
INSERT INTO nld1939_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Want Jahweh was op de berg Sinaï neergedaald, op de top van de berg. Hij had Moses naar de top van de berg ontboden, en Moses was naar boven geklommen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Daarna sprak Jahweh tot Moses: Ga naar beneden, en waarschuw het volk, de omheining niet te verbreken, om Jahweh te naderen en Hem te aanschouwen; want velen van hen zouden vallen. ");
INSERT INTO nld1939_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ook moeten de priesters, die tot Jahweh willen naderen, zich heiligen, anders barst de toorn van Jahweh tegen hen los. ");
INSERT INTO nld1939_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses gaf Jahweh ten antwoord: Het volk kan de berg Sinaï niet bestijgen; want zelf hebt Gij ons dringend bevolen, de berg te omheinen en voor heilig te houden. ");
INSERT INTO nld1939_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Maar Jahweh sprak: Ga naar beneden, en kom dan weer met Aäron en de priesters naar boven; doch laat het volk de omheining niet verbreken, om tot Jahweh op te klimmen; anders barst de toorn van Jahweh tegen hen los. ");
INSERT INTO nld1939_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Toen daalde Moses af naar het volk, en bracht het hun over. ");
INSERT INTO nld1939_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Toen sprak God alles wat volgt: ");
INSERT INTO nld1939_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ik ben Jahweh, uw God, die u uit Egypte, uit het slavenhuis heb geleid; ");
INSERT INTO nld1939_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","gij zult geen andere goden naast Mij hebben. ");
INSERT INTO nld1939_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gij zult u geen godenbeeld maken noch enig beeld van wat in de hemel daarboven, op de aarde beneden, of in het water onder de aarde is. ");
INSERT INTO nld1939_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gij moogt ze niet aanbidden of dienen. Want Ik, Jahweh, uw God, ben een naijverige God, die de zonden der vaders wreekt op de zonen, op het derde en vierde geslacht van hen, die Mij haten, ");
INSERT INTO nld1939_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","maar die genadig is aan het duizendste geslacht van hen, die Mij liefhebben en mijn geboden onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Gij zult de naam van Jahweh, uw God, niet ijdel gebruiken; want wanneer iemand de naam van Jahweh ijdel gebruikt, laat Hij dit niet ongestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenk de sabbat, dat gij die heiligt. ");
INSERT INTO nld1939_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Zes dagen kunt ge werken en al uw arbeid verrichten, ");
INSERT INTO nld1939_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","maar de zevende dag is een sabbat voor Jahweh, uw God; dan moogt ge geen arbeid verrichten; gijzelf, noch uw zoon of uw dochter, noch uw slaaf, uw slavin of uw vee, noch de vreemdeling, die binnen uw poorten woont. ");
INSERT INTO nld1939_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Want in zes dagen heeft Jahweh hemel, aarde en zee gemaakt met al wat er in is; maar op de zevende dag rustte Hij. Daarom heeft Jahweh de sabbat gezegend, en hem voor heilig verklaard. ");
INSERT INTO nld1939_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Eert uw vader en moeder, opdat ge lang moogt blijven in het land, dat Jahweh, uw God, u zal schenken. ");
INSERT INTO nld1939_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gij zult niet doden. ");
INSERT INTO nld1939_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gij zult geen overspel doen. ");
INSERT INTO nld1939_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gij zult niet stelen. ");
INSERT INTO nld1939_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Gij zult tegen uw naaste geen valse getuigenis afleggen. ");
INSERT INTO nld1939_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gij zult het huis van uw naaste niet begeren. Gij zult de vrouw van uw naaste niet begeren, noch zijn slaaf of slavin, zijn rund of zijn ezel, noch iets van wat uw naaste behoort. ");
INSERT INTO nld1939_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Toen heel het volk de donderslagen en bliksemflitsen, het bazuingeschetter en de rokende berg gewaar werd, rilde het van angst, en bleef sidderend op een afstand staan. ");
INSERT INTO nld1939_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","En zij zeiden tot Moses: Spreek gij met ons, dan zullen wij luisteren; maar laat God niet met ons spreken, anders zullen wij sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Maar Moses sprak tot het volk: Weest maar niet bang; want God is gekomen, om u voor de keuze te stellen, en u voor altijd zulk ontzag voor Hem in te prenten, dat ge niet zondigt. ");
INSERT INTO nld1939_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Terwijl dus het volk op een afstand bleef staan, trad Moses nader tot de donkere wolk, waar God in was. ");
INSERT INTO nld1939_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","En Jahweh sprak tot Moses: Ge moet het volgende tot de kinderen Israëls zeggen: Gij hebt zelf gezien, hoe Ik uit de hemel tot u gesproken heb: ");
INSERT INTO nld1939_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","“Gij zult geen goden maken naast Mij, u geen afgoden maken van zilver of goud.” ");
INSERT INTO nld1939_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ge moet een altaar van aarde voor Mij oprichten, en daarop uw brand(-) en vredeoffers opdragen, uw schapen en runderen, overal, waar Ik mijn Naam doe gedenken, waar Ik u zal verschijnen en u zal zegenen. ");
INSERT INTO nld1939_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bouwt ge Mij echter een stenen altaar, dan moogt ge het niet optrekken van gehouwen stenen; want hebt ge ze met uw beitel bewerkt, dan hebt ge ze ontwijd. ");
INSERT INTO nld1939_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ook moogt ge mijn altaar niet langs trappen beklimmen, om uw schaamte daarop niet te ontbloten. ");
INSERT INTO nld1939_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Dit zijn de wetten, die ge hun moet voorhouden: ");
INSERT INTO nld1939_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Wanneer gij een hebreeuwsen slaaf koopt, zal hij u zes jaren dienstbaar zijn; maar in het zevende jaar kan hij zonder enige vergoeding als vrij man heengaan. ");
INSERT INTO nld1939_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Als hij alleen is gekomen, zal hij alleen weggaan; kwam hij gehuwd, dan moet ook zijn vrouw met hem mee. ");
INSERT INTO nld1939_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Wanneer zijn meester hem een vrouw heeft gegeven, die hem zonen en dochters heeft geschonken, dan blijft zijn vrouw met haar kinderen het eigendom van zijn heer, en moet hij alleen vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Maar zo de slaaf uitdrukkelijk verklaart: Ik houd van mijn heer, van mijn vrouw en mijn kinderen, ik wil de vrijheid niet, ");
INSERT INTO nld1939_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dan moet zijn heer hem voor God doen komen, hem vervolgens naar de deur of de deurpost geleiden, en zijn oor met een priem doorboren; dan blijft hij voor altijd zijn slaaf. ");
INSERT INTO nld1939_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Wanneer iemand zijn dochter als slavin verkoopt, zal zij niet op dezelfde manier kunnen vertrekken als de slaven. ");
INSERT INTO nld1939_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Heeft de heer haar voor zich zelf bestemd, maar bevalt ze hem niet, dan kan hij een losprijs voor haar vragen; maar hij heeft niet het recht, haar naar den vreemde te verkopen, als hij genoeg van haar heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Heeft hij haar voor zijn zoon bestemd, dan moet hij haar als een dochter behandelen. ");
INSERT INTO nld1939_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Neemt hij zich nog een andere vrouw, dan mag hij haar niet te kort doen, wat voedsel, kleding en huwelijksgemeenschap betreft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Zo hij haar deze drie dingen niet geeft, mag zij zonder vergoeding en losgeld vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wie iemand zo slaat, dat hij sterft, zal met de dood worden gestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wanneer hij het niet met opzet deed, doch God zijn hand had laten gaan, dan zal Ik u een plaats aanwijzen, waar hij heen kan vluchten. ");
INSERT INTO nld1939_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Maar zo iemand met boos opzet en verraderlijk zijn naaste vermoordt, moet ge hem zelfs van mijn altaar gaan halen, om hem te doden. ");
INSERT INTO nld1939_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wie zijn vader of zijn moeder slaat, zal met de dood worden gestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wie een mens rooft, hetzij hij hem heeft verkocht of nog in zijn macht heeft, zal met de dood worden gestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wie zijn vader of moeder vervloekt, zal eveneens sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Wanneer twee mannen met elkaar vechten, en de een slaat den ander met een steen of met de vuist, zonder dat hij sterft, maar toch zó, dat hij bedlegerig wordt, ");
INSERT INTO nld1939_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","dan zal hij, die hem heeft geslagen, ongestraft blijven, als de ander weer op kan staan en gesteund op zijn stok buiten kan wandelen. Hij moet hem alleen zijn verzuim vergoeden en de kosten van de genezing betalen. ");
INSERT INTO nld1939_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Wanneer iemand zijn slaaf of slavin met een stok zo mishandelt, dat hij onder zijn hand bezwijkt, moet hij ten zwaarste worden gestraft; ");
INSERT INTO nld1939_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","maar blijft hij nog een of twee dagen in leven, dan zal hij niet worden gestraft, want het is zijn eigen bezit. ");
INSERT INTO nld1939_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wanneer mannen met elkaar vechten, en ze raken daarbij een zwangere vrouw, zodat zij wel ontijdig bevalt, maar het leven er niet mee gemoeid is, dan zal de schuldige als boete de schadevergoeding moeten betalen, welke de man van die vrouw hem oplegt. ");
INSERT INTO nld1939_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Maar wanneer het leven er mee is gemoeid, zult ge leven voor leven geven. ");
INSERT INTO nld1939_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Oog voor oog, tand voor tand, hand voor hand, voet voor voet, ");
INSERT INTO nld1939_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brandwond voor brandwond, letsel voor letsel, striem voor striem! ");
INSERT INTO nld1939_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Maar wanneer iemand zijn slaaf of slavin het oog uitslaat, moet hij hun voor het oog de vrijheid geven; ");
INSERT INTO nld1939_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","zo hij zijn slaaf of slavin een tand uitslaat, moet hij hun ook voor de tand de vrijheid geven. ");
INSERT INTO nld1939_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Wanneer een stier een man of een vrouw zo hevig stoot, dat de dood daarop volgt, moet die stier worden gestenigd en zijn vlees mag niet worden gegeten; doch den eigenaar van den stier treft geen schuld. ");
INSERT INTO nld1939_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Maar wanneer de stier reeds te voren stotig was, en de eigenaar, hoewel gewaarschuwd, hem niet heeft bewaakt, dan moet niet alleen de stier, die een man of een vrouw heeft gedood, worden gestenigd, maar ook de eigenaar met de dood worden gestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Eist men losgeld van hem, dan moet hij zoveel voor zijn persoon betalen, als men hem oplegt. ");
INSERT INTO nld1939_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Stoot hij een jongen of een meisje, dan geldt dezelfde regel. ");
INSERT INTO nld1939_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Maar stoot de stier een slaaf of slavin, dan moet de eigenaar dertig zilveren sikkels aan hun meester betalen, en de stier zal worden gestenigd. ");
INSERT INTO nld1939_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Wanneer iemand een put heeft opengelaten, of een kuil heeft gegraven zonder hem af te dekken, en een rund of ezel valt er in, ");
INSERT INTO nld1939_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","dan moet de eigenaar van de put schadeloosstelling geven, en de prijs betalen aan den eigenaar van het dier; het dode dier kan hij behouden. ");
INSERT INTO nld1939_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wanneer iemands stier dien van een ander zo stoot, dat deze sterft, dan moeten ze den levenden stier verkopen, en de opbrengst ervan, zowel als het gedode dier, samen delen. ");
INSERT INTO nld1939_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Maar was het bekend, dat de stier reeds langere tijd stotig was, en heeft de eigenaar hem toch niet bewaakt, dan moet hij hem de volle waarde vergoeden, een stier voor een stier; maar het dode beest mag hij behouden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wanneer iemand een rund of een schaap steelt, en het slacht of verkoopt, moet hij vijf runderen vergoeden voor het rund, en vier schapen voor het schaap. ");
INSERT INTO nld1939_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Wordt een dief bij een nachtelijke inbraak betrapt en doodgeslagen, dan treft wie hem doodt, geen bloedschuld; ");
INSERT INTO nld1939_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","maar zo de zon reeds was opgegaan, dan treft hem die wel. De dief zal het volle bedrag moeten terugbetalen. Bezit hij het niet, dan moet hij worden verkocht, om het gestolene te vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Zo het gestolene, rund, ezel of schaap nog levend in zijn bezit wordt gevonden, zal hij het dubbele moeten geven. ");
INSERT INTO nld1939_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Wanneer iemand bij het afweiden van veld of wijngaard zijn vee los laat rondlopen, en dit het veld van een ander afgraast, dan moet hij de hoogste opbrengst van zijn veld en de hoogste opbrengst van zijn wijngaard als schadevergoeding geven. ");
INSERT INTO nld1939_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Wanneer er een vuur wordt aangestoken, om de doornen te verbranden, en het vernielt de garven, het ongemaaide koren of het hele veld, dan moet hij, die het vuur heeft aangestoken, het verbrande volledig vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Wanneer iemand aan een ander geld of goed in bewaring heeft gegeven, en het wordt uit het huis van dien man gestolen, dan moet de dief, als hij wordt ontdekt, het dubbel vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Wordt de dief niet ontdekt, dan zal de heer des huizes voor God verschijnen en zweren, dat hij zich het goed van een ander niet heeft toegeëigend. ");
INSERT INTO nld1939_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Als er iets gestolen is, hetzij een stier, een ezel, een schaap, een kledingstuk of als er iets verloren is gegaan, en de verliezer zegt daarvan: “Dit is het”, dan moet het geschil tussen beide betrokkenen voor God worden gebracht; en wien God schuldig verklaart, moet het dubbele aan den ander vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Wanneer iemand een ezel, een stier of een schaap of wat voor dier ook, aan de hoede van een ander toevertrouwt, en het beest sterft, breekt zijn poten of wordt weggeroofd, zonder dat iemand het ziet, ");
INSERT INTO nld1939_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","dan zal een eed voor Jahweh tussen hen beiden beslissen, of die ander zijn hand niet aan het goed van zijn naaste heeft geslagen; de eigenaar moet er genoegen mee nemen, en de ander behoeft niets te vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Zo het hem is ontstolen, moet hij het den eigenaar wel vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Is het door een roofdier verscheurd, dan kan hij het verscheurde beest als bewijs laten gelden, en behoeft hij het niet te vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Wanneer iemand van een ander een rund te leen vraagt, en het breekt zijn poten of sterft, terwijl de eigenaar er niet bij is, dan moet hij het vergoeden. ");
INSERT INTO nld1939_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Was de eigenaar er bij, dan behoeft hij het niet te vergoeden. Is het echter gehuurd, dan is de schade in de huurprijs inbegrepen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wanneer iemand een meisje, dat nog niet is verloofd, verleidt en misbruikt, dan moet hij haar huwen en de volle bruidsprijs betalen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Weigert de vader haar te geven, dan moet hij toch zoveel betalen, als de bruidsprijs voor een meisje bedraagt. ");
INSERT INTO nld1939_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Geen tovenares zult ge in leven laten. ");
INSERT INTO nld1939_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Iedereen die een dier misbruikt zal met de dood worden gestraft. ");
INSERT INTO nld1939_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Iedereen die aan goden offert, behalve aan Jahweh alleen, zal met de banvloek worden geslagen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Den vreemdeling moogt ge niet verdrukken en kwellen; want zelf zijt ge vreemdelingen geweest in het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Weduwen en wezen zult ge nimmer verdrukken. ");
INSERT INTO nld1939_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Zo ge hen toch durft verdrukken en zij vol angst tot Mij roepen, zal Ik hun schreien zeker verhoren. ");
INSERT INTO nld1939_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mijn toorn zal ontbranden, en met het zwaard zal Ik u doden; uw vrouwen zullen weduwen worden en uw kinderen wezen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Wanneer gij geld leent aan een arme van mijn volk onder u, zult ge u tegenover hem niet als geldschieter gedragen, en geen rente van hem vragen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Zo ge de mantel van een ander in pand hebt genomen, moet ge hem die voor zonsondergang teruggeven; ");
INSERT INTO nld1939_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","want het is zijn enig kleed, de bedekking voor zijn blote lijf, waarin hij moet slapen. Als hij tot Mij roept, zal Ik hem verhoren; want Ik ben barmhartig. ");
INSERT INTO nld1939_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Gij zult God niet vervloeken, en de overheid van uw volk niet verwensen. ");
INSERT INTO nld1939_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Met de eerstelingen van uw dorsvloer en perskuip zult ge niet achterstallig blijven. Den eerstgeborene van uw zonen zult ge Mij afstaan. ");
INSERT INTO nld1939_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Hetzelfde zult ge doen met uw runderen en uw schapen: zeven dagen mag het jong bij zijn moeder blijven, op de achtste dag zult ge het Mij geven. ");
INSERT INTO nld1939_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Reine mensen zult ge Mij zijn. Het vlees van een dier, dat op het veld ligt verscheurd, moogt ge niet eten; maar ge moet het voor de honden werpen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ge moogt geen vals gerucht rondstrooien. Ge moogt hem, die ongelijk heeft, geen hulp verlenen door valse getuigenis. ");
INSERT INTO nld1939_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Sluit u in kwade zaken niet bij de meerderheid aan, en richt bij uw antwoorden in een geding u niet naar de meerderheid, als ge daardoor het recht zoudt verkrachten. ");
INSERT INTO nld1939_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kies ook in een rechtsgeding niet de partij van den rijke. ");
INSERT INTO nld1939_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wanneer ge een verdwaalden os of ezel van uw vijand aantreft, moet ge ze terstond naar hem terugbrengen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wanneer ge een ezel van uw vijand onder zijn last ziet bezwijken, zult ge den man uw hulp niet weigeren, maar hem helpen afladen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Bij een geding moogt ge het recht van den arme niet verkrachten. ");
INSERT INTO nld1939_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ge zult geen oneerlijke uitspraak doen, en geen doodvonnis vellen over een onschuldige, die in zijn recht is; want ook Ik geef geen gelijk aan hem, die niet in zijn recht is. ");
INSERT INTO nld1939_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ge moogt ook geen geschenken aannemen; want geschenken maken zienden blind en verdraaien het recht. ");
INSERT INTO nld1939_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Eveneens moogt ge den vreemdeling niet verdrukken; want ge weet, hoe een vreemdeling zich moet voelen, daar ge zelf vreemdeling zijt geweest in het land van Egypte. ");
INSERT INTO nld1939_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Zes jaren moogt ge het land bezaaien en de vruchten ervan oogsten; ");
INSERT INTO nld1939_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","maar in het zevende jaar moet ge het braak laten liggen en niet bewerken. Dan zullen de armen onder uw volk er van eten, en de rest zal het wild tot voedsel dienen. Zo zult ge ook met uw wijngaard en uw olijventuin doen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Zes dagen moogt ge werken, maar op de zevende dag zult ge rusten, opdat ook uw rund en uw ezel rust mogen hebben, en de zoon van uw slavin en de vreemdeling tot rust kunnen komen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Onderhoudt alles, wat Ik u heb gezegd. De naam van vreemde goden zult ge niet aanroepen; die mag in uw mond niet worden gehoord! ");
INSERT INTO nld1939_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Drie maal per jaar zult ge ter ere van Mij feest vieren. ");
INSERT INTO nld1939_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ge moet het feest der ongedesemde broden vieren. Dan moet ge zeven dagen lang op de vastgestelde tijd in de maand Abib ongedesemde broden eten, zoals Ik u heb bevolen; want in die maand zijt ge uit Egypte getrokken. ");
INSERT INTO nld1939_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Verder het oogstfeest, wanneer de eerstelingen van uw arbeid, van wat ge op het veld hebt gezaaid, worden geoogst, en het plukfeest op het eind van het jaar, wanneer ge van het veld de vruchten van uw arbeid binnenhaalt. ");
INSERT INTO nld1939_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Deze drie keren in het jaar moeten alle personen van het mannelijk geslacht voor Jahweh, den Heer verschijnen en zij mogen niet met lege handen voor mijn aanschijn komen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ge moogt het bloed van het dier, dat Mij wordt geofferd, niet tegelijk met gedesemd brood opdragen. Het vet van mijn feestoffer mag niet de nacht door tot de volgende morgen worden bewaard. ");
INSERT INTO nld1939_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Het puik der eerstelingen van uw akker zult ge naar het huis van Jahweh, uw God brengen. Gij moogt het geitje niet koken in de melk van zijn moeder. ");
INSERT INTO nld1939_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Zie, Ik zend mijn engel voor u uit, om u onderweg te bewaken, en u naar de plaats te leiden, die Ik u heb bereid. ");
INSERT INTO nld1939_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Wees voor hem op uw hoede, luister naar hem, en wees niet weerspannig tegen hem. Hij zal uw zonden niet vergeven, want in hem woont mijn Naam. ");
INSERT INTO nld1939_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Maar zo ge naar Mij luistert, en alles doet, wat Ik heb gezegd, zal Ik de vijand van uw vijanden zijn en de verdrukker van uw verdrukkers. ");
INSERT INTO nld1939_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Waarachtig, dan zal mijn engel voor u uitgaan, en u aanvoeren tegen de Amorieten, Chittieten, Perizzieten, Kanaänieten, Chiwwieten, Jeboesieten, en Ik zal ze vernietigen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Hun goden moogt ge niet aanbidden of dienen, ge moogt hun daden niet navolgen; maar ge moet ze meedogenloos uitroeien en hun wijstenen verbrijzelen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Jahweh, uw God, moet ge dienen! Dan zal Ik uw brood en uw water zegenen, en de ziekte uit uw midden bannen; ");
INSERT INTO nld1939_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","geen vrouw in uw land zal een miskraam hebben of onvruchtbaar zijn, en het getal uwer dagen maak Ik vol. ");
INSERT INTO nld1939_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Dan zal Ik mijn verschrikking voor u uitzenden, al de volken, waar gij komt, in verwarring brengen en uw vijanden voor u op de vlucht drijven. ");
INSERT INTO nld1939_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Dan zal Ik horzels voor u uitzenden, die de Chiwwieten, Kanaänieten en Chittieten voor u zullen opjagen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Maar Ik drijf ze niet in een enkel jaar voor u weg; anders zou het land een woestenij worden en zouden de wilde dieren de overhand krijgen; ");
INSERT INTO nld1939_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","slechts langzaam aan drijf Ik hen voor u weg, totdat ge zo zijt aangegroeid, dat ge het land in bezit kunt nemen. ");
INSERT INTO nld1939_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Dan zal Ik uw grenzen trekken van de Rode Zee tot aan de zee der Filistijnen, en van de woestijn tot aan de Rivier, en alle bewoners van het land aan u overleveren. Ge moet ze verjagen, ");
INSERT INTO nld1939_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","en moogt geen verbond met hen sluiten, noch met hun goden; ");
INSERT INTO nld1939_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ze mogen zelfs niet in uw land blijven wonen. Want anders verleiden ze u tot zonde tegen Mij; zodat gij hun goden zoudt gaan dienen, en die zouden een valstrik voor u worden. ");
INSERT INTO nld1939_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Toen sprak Hij tot Moses: Klim op tot Jahweh, gij met Aäron, Nadab en Abihoe en zeventig van Israëls oudsten. Zij moeten op een afstand blijven neerknielen; ");
INSERT INTO nld1939_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alleen mag tot Jahweh naderen, niet de anderen, en ook het volk mag niet met hem opstijgen. ");
INSERT INTO nld1939_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Toen ging Moses terug naar het volk, en deelde het alle bevelen en wetten van Jahweh mee. En heel het volk antwoordde eenstemmig: Alles wat Jahweh gezegd heeft, zullen we doen! ");
INSERT INTO nld1939_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","En Moses schreef alle bevelen van Jahweh op. De volgende morgen bouwde hij aan de voet van de berg een altaar, en richtte twaalf wijstenen op naar het getal der twaalf stammen van Israël. ");
INSERT INTO nld1939_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Vervolgens gaf hij aan israëlietische jongemannen bevel, om brandoffers op te dragen en voor Jahweh jonge stieren als vredeoffers te slachten. ");
INSERT INTO nld1939_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Toen nam Moses de helft van het bloed en goot het in schalen; de andere helft sprenkelde hij over het altaar. ");
INSERT INTO nld1939_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Daarna nam hij het verbondsboek en las het voor ten aanhoren van het volk. Zij herhaalden: Alles, wat Jahweh heeft gezegd, zullen we doen en daaraan gehoorzamen. ");
INSERT INTO nld1939_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Nu nam Moses het bloed, sprenkelde het over het volk, en sprak: Zie, dit is het bloed van het Verbond, dat Jahweh met u heeft gesloten: het is gegrond op al deze bevelen. ");
INSERT INTO nld1939_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moses klom dus omhoog met Aäron, Nadab, Abihoe en de zeventig oudsten van Israël. ");
INSERT INTO nld1939_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Daar mochten zij den God van Israël aanschouwen; onder zijn voeten was iets als een vloer van saffier, stralend als de hemel zelf. ");
INSERT INTO nld1939_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","En God strekte zijn hand niet uit tegen de uitverkorenen onder Israëls kinderen, ofschoon ze God hadden aanschouwd. Daarna at en dronk men. ");
INSERT INTO nld1939_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Vervolgens sprak Jahweh tot Moses: Kom tot Mij op de berg en blijf daar; dan zal Ik u de stenen tafelen geven met de wet en de geboden, die Ik tot hun onderrichting heb opgeschreven. ");
INSERT INTO nld1939_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Toen maakte Moses met zijn dienaar Josuë zich gereed, en besteeg Moses de berg Gods. ");
INSERT INTO nld1939_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Hij zei tot de oudsten: Blijft hier, totdat we tot u terugkeren. Zie, Aäron en Choer blijven bij u. Wie een rechtsgeding heeft, kan zich tot hen wenden. ");
INSERT INTO nld1939_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Zo besteeg Moses de berg, die door de wolk bedekt was. ");
INSERT INTO nld1939_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Want de glorie van Jahweh rustte op de berg Sinaï, en de wolk hield hem zes dagen lang omhuld. En uit de wolk riep Hij Moses op de zevende dag. ");
INSERT INTO nld1939_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","En nu straalde op de top van de berg de glorie van Jahweh voor de ogen van de Israëlieten als een verterend vuur. ");
INSERT INTO nld1939_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Toen Moses de berg beklom, kwam hij midden in de wolk. En veertig dagen en veertig nachten bleef Moses op de berg. ");
INSERT INTO nld1939_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Daar sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Zeg de kinderen Israëls, dat ze Mij geschenken brengen; van iedereen, wien het hart het ingeeft, zult ge geschenken aanvaarden. ");
INSERT INTO nld1939_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Dit zijn de geschenken, die ge van hen moet aannemen: goud, zilver en brons, ");
INSERT INTO nld1939_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","violet, purper, karmozijn, getwijnd lijnwaad en geitenhaar, ");
INSERT INTO nld1939_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","roodgeverfde ramsvellen, gelooide huiden en acaciahout; ");
INSERT INTO nld1939_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olie voor de lampen, specerijen voor de zalfolie en voor de geurige wierook; ");
INSERT INTO nld1939_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onyxstenen en andere edelstenen, om er het borstkleed en de borsttas mee te bezetten. ");
INSERT INTO nld1939_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Want ge moet voor Mij een heiligdom maken, opdat Ik in hun midden kan wonen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","En ge moet de tabernakel met toebehoren nauwkeurig naar de modellen vervaardigen, die Ik u nu ga tonen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ge moet een ark vervaardigen van acaciahout, twee en een halve el lang, anderhalve el breed en anderhalve el hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ge moet haar van binnen en van buiten met zuiver goud bekleden en er loofwerk van goud omheen maken. ");
INSERT INTO nld1939_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Dan moet ge er vier gouden krammen voor gieten, en die boven aan de vier poten bevestigen, twee krammen aan iedere kant. ");
INSERT INTO nld1939_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Maak vervolgens handbomen van acaciahout, besla ze met goud, ");
INSERT INTO nld1939_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","en steek ze in de krammen aan weerskanten van de ark, om daarmee de ark te dragen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","De handbomen moeten in de krammen aan de ark blijven, en mogen er niet worden uitgetrokken. ");
INSERT INTO nld1939_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","In de ark moet ge de verbondswet leggen, die Ik u geven zal. ");
INSERT INTO nld1939_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Daarna moet ge ook een verzoendeksel maken van zuiver goud, twee en een halve el lang en anderhalve el breed. ");
INSERT INTO nld1939_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Aan de beide uiteinden van het verzoendeksel moet ge twee gouden cherubs als drijfwerk maken. ");
INSERT INTO nld1939_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Sla een cherub uit aan het ene einde en een cherub aan het andere einde; dus in het verzoendeksel zelf moet ge aan beide uiteinden de cherubs uitslaan. ");
INSERT INTO nld1939_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","De cherubs moeten hun vleugels omhoog spreiden, en met hun vleugels het verzoendeksel overspannen; ze moeten tegenover elkander staan, terwijl hun gezichten naar het verzoendeksel gericht moeten zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Leg dan het verzoendeksel boven op de ark, en de verbondswet, die Ik u geven zal, erin. ");
INSERT INTO nld1939_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Daar zal Ik Mij aan u openbaren, en boven het verzoendeksel tussen de twee cherubs, die op de ark des Verbonds staan, zal Ik alles mededelen, wat Ik u voor de Israëlieten heb te bevelen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Gij moet ook een tafel van acaciahout vervaardigen, twee ellen lang, een el breed en anderhalve el hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Overtrek die met zuiver goud, en maak er loofwerk van goud omheen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Gij moet daar een lijst van een hand breed omheen maken, en om die lijst loofwerk van goud. ");
INSERT INTO nld1939_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Dan moet ge vier gouden krammen maken, en die aan de vier hoeken bij de poten bevestigen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Breng die krammen voor de handbomen van de tafel vlak bij de lijst aan. ");
INSERT INTO nld1939_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","De handbomen moet ge van acaciahout maken, en met goud beslaan; daarmee moet de tafel worden gedragen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Bovendien moet ge nog de nodige schotels, kannen, bekers en schalen vervaardigen voor het uitgieten van de plengoffers; ge moet ze maken van zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ook moet ge er voor zorgen, dat er op de tafel voortdurend toonbroden voor Mij liggen. ");
INSERT INTO nld1939_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Vervolgens moet ge een kandelaar maken van zuiver goud. De kandelaar moet drijfwerk zijn: zijn voetstuk en schacht, zijn bloemkelken, knoppen en bloesems uit één stuk. ");
INSERT INTO nld1939_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Zes armen moeten terzijde uitsteken, drie armen aan de ene kant van de kandelaar en drie armen aan de andere kant. ");
INSERT INTO nld1939_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Aan iedere arm moeten drie bloemkelken zitten in de vorm van amandelbloesem, knoppen en bloesems; dus aan de zes armen, die uit de kandelaar steken op dezelfde manier. ");
INSERT INTO nld1939_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Maar aan de kandelaar zelf moeten vier bloemkelken zitten in de vorm van amandelbloesem, knoppen en bloesems; ");
INSERT INTO nld1939_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","telkens moet één knop onder elk van de drie paar armen zitten, waar de zes armen uit de kandelaar schieten. ");
INSERT INTO nld1939_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","De knoppen en armen moeten met de kandelaar zelf uit één stuk zijn; het geheel één stuk drijfwerk van zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Bovendien moet ge de zeven lampen maken, die er bij horen, en deze er zo boven op plaatsen, dat het licht naar de voorzijde valt. ");
INSERT INTO nld1939_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ook de snuiters en bakjes moeten van zuiver goud zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Een talent zuiver goud moet men gebruiken voor de kandelaar en voor alles wat er bij hoort. ");
INSERT INTO nld1939_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Zorg er voor, dat ge het vervaardigt naar de modellen, die u op de berg zijn getoond. ");
INSERT INTO nld1939_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Daarna moet ge de tabernakel vervaardigen uit tien banen van getwijnd lijnwaad, van violet, purper en karmozijn, met cherubs versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Iedere baan moet acht en twintig el lang zijn en vier el breed; alle banen moeten dezelfde afmetingen hebben. ");
INSERT INTO nld1939_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Vijf aan vijf moeten de banen aan elkander worden gehecht. ");
INSERT INTO nld1939_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Dan moet ge violetkleurige lussen maken aan de zoom van de eerste baan van het ene stel en eveneens aan de zoom van de laatste baan van het andere stel. ");
INSERT INTO nld1939_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Vijftig lussen moet ge maken aan de baan van het ene stel, en vijftig aan de zoom van de baan van het andere stel; zodat de lussen tegenover elkander komen te zitten. ");
INSERT INTO nld1939_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Dan moet ge vijftig gouden haken vervaardigen, waarmee ge de banen aan elkander moet verbinden, zodat de tabernakel een geheel wordt. ");
INSERT INTO nld1939_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Daarna moet gij ook banen van geitenhaar vervaardigen voor een tent over de tabernakel. Elf van zulke banen moet ge maken. ");
INSERT INTO nld1939_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Elke baan moet dertig el lang en vier el breed zijn; alle elf dus van dezelfde afmetingen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Vijf van die banen moet ge afzonderlijk aan elkander hechten, en eveneens de zes andere afzonderlijk; de zesde baan moet ge aan de voorzijde van de tent omslaan. ");
INSERT INTO nld1939_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Dan moet ge vijftig lussen maken aan de zoom van de eerste baan van het ene stel, en vijftig lussen aan de zoom van de laatste baan van het andere stel. ");
INSERT INTO nld1939_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Vervolgens moet ge vijftig bronzen haken maken, en daarmee de lussen vasthechten, om de tent zo samen te voegen, dat ze een geheel wordt. ");
INSERT INTO nld1939_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Het gedeelte van de tentbanen, dat in de breedte nog overschiet, moet ge voor de helft over de achterkant van de tabernakel laten afhangen; ");
INSERT INTO nld1939_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","terwijl de el, die aan weerszijden van de tentbanen in de lengte overblijft, aan beide kanten van de tabernakel moet afhangen, om die te bedekken. ");
INSERT INTO nld1939_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Over deze tent moet ge weer een dek maken van roodgeverfde ramsvellen, en daar overheen nog een dekkleed van gelooide huiden. ");
INSERT INTO nld1939_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Vervolgens moet ge voor de tabernakel rechtopstaande schotten maken van acaciahout. ");
INSERT INTO nld1939_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ieder schot moet tien el hoog en anderhalve el breed zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Onder ieder schot moeten twee pennen recht naast elkander worden aangebracht; zo moet ge met alle schotten van de tabernakel doen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Voor de zuidkant van de tabernakel moet ge twintig schotten maken, ");
INSERT INTO nld1939_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","en onder die twintig schotten veertig zilveren voetstukken; zodat er zich telkens twee onder ieder schot bevinden voor de beide pennen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Voor de andere wand van de tabernakel, dus aan de noordkant, eveneens twintig schotten ");
INSERT INTO nld1939_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","met hun veertig zilveren voetstukken, telkens twee onder ieder schot. ");
INSERT INTO nld1939_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Voor de achterkant van de tabernakel, dus in het westen, moet ge zes schotten maken. ");
INSERT INTO nld1939_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Daarenboven moet ge voor de beide hoeken van de achterwand van de tabernakel twee schotten vervaardigen, ");
INSERT INTO nld1939_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","die van onderen in elkaar grijpen, en evenzo van boven bij de eerste kram; ze moeten zó zijn, omdat zij beiden de hoekstukken vormen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Er moeten dus acht schotten zijn met hun zestien zilveren voetstukken, telkens twee voetstukken onder ieder schot. ");
INSERT INTO nld1939_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ge moet ook bindlatten maken van acaciahout, vijf voor de schotten van de ene zijwand van de tabernakel, ");
INSERT INTO nld1939_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","vijf voor de schotten van de andere zijwand van de tabernakel, en ook vijf voor de schotten aan de achterwand van de tabernakel in het westen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","De middelste bindlat moet midden over de schotten lopen van het ene einde tot het andere. ");
INSERT INTO nld1939_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","De schotten moet ge met goud bekleden; de krammen, waarin de bindlatten rusten van goud vervaardigen; de bindlatten zelf weer met goud overtrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Zo zult ge de tabernakel oprichten naar het model, dat u op de berg is getoond. ");
INSERT INTO nld1939_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ge moet ook een voorhangsel maken van violet, purper, karmozijn en getwijnd lijnwaad met cherubs versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hang dat met gouden ringen aan vier met goud beslagen palen van acaciahout, die op vier zilveren voetstukken staan. ");
INSERT INTO nld1939_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Het voorhangsel moet ge aan de haken der palen ophangen. Breng dan de ark des Verbonds binnen het voorhangsel, zodat het voorhangsel een scheiding vormt tussen het heilige en het heilige der heiligen, ");
INSERT INTO nld1939_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","en leg het verzoendeksel op de ark des Verbonds in het heilige der heiligen. ");
INSERT INTO nld1939_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Maar de tafel moet ge aan de buitenkant van het voorhangsel plaatsen; de kandelaar tegenover de tafel aan de rechterzijde van de tabernakel en de tafel aan de linkerzijde. ");
INSERT INTO nld1939_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Maak ten slotte voor de ingang van de Tent een tapijt van violet, purper, karmozijn en getwijnd lijnwaad met fijn borduurwerk versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Voor dat tapijt moet ge vijf palen maken van acaciahout met goud beslagen; ook de ringen moeten van goud zijn. Ge moet er vijf bronzen voetstukken voor gieten. ");
INSERT INTO nld1939_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Vervolgens moet ge het brandofferaltaar maken van acaciahout; het altaar moet vijf el lang en vijf el breed, dus vierkant zijn, en drie el hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Breng op de vier hoeken de hoornen aan, die met het altaar uit één stuk moeten zijn, en besla ze met brons. ");
INSERT INTO nld1939_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Maak ook de nodige bakken voor het wegruimen van de as, met de schoppen, offerschalen, vorken en vuurpotten; vervaardig al deze benodigdheden van brons. ");
INSERT INTO nld1939_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Maak een netvormig rasterwerk van brons, en aan de vier hoeken van dat rasterwerk vier bronzen krammen. ");
INSERT INTO nld1939_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Breng dat rasterwerk aan beneden onder het raam, waarop het altaar rust, zodat het van beneden af tot halverhoogte het altaar reikt. ");
INSERT INTO nld1939_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Maak ook handbomen van acaciahout voor het altaar, en besla ze met brons. ");
INSERT INTO nld1939_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","De handbomen moeten door de krammen worden gestoken, zodat ze zich aan beide zijden van het altaar bevinden, wanneer men het draagt. ");
INSERT INTO nld1939_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ge moet het altaar hol maken en van planken; en het vervaardigen, zoals het u op de berg is getoond. ");
INSERT INTO nld1939_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Daarna moet ge nog de voorhof van de tabernakel maken. Aan de zuidkant moet de voorhof worden afgezet met gordijnen van getwijnd lijnwaad; de lengte ervan aan deze ene zijde moet honderd el bedragen. ");
INSERT INTO nld1939_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ze moeten hangen aan twintig palen op twintig bronzen voetstukken; de ringen en banden der palen moeten van zilver zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hang eveneens aan de noordzijde gordijnen over een lengte van honderd el, aan twintig palen op hun twintig bronzen voetstukken; de ringen en de banden der palen moeten eveneens van zilver zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Maar hang in de breedte aan de westzijde van de voorhof gordijnen over een lengte van vijftig el aan tien palen op hun tien voetstukken. ");
INSERT INTO nld1939_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","De breedte van de voorhof aan de voorzijde ten oosten moet eveneens vijftig el bedragen. ");
INSERT INTO nld1939_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Aan de ene hoek moet het over een lengte van vijftien el worden afgezet met gordijnen aan drie palen op hun drie voetstukken; ");
INSERT INTO nld1939_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","zo ook de andere hoek over een lengte van vijftien el met gordijnen aan drie palen op hun drie voetstukken, ");
INSERT INTO nld1939_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","terwijl aan de ingang van de voorhof aan vier palen op hun vier voetstukken een tapijt van twintig el moet hangen van violet, purper, karmozijn en getwijnd lijnwaad, met fijn borduurwerk versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Al de palen rond de voorhof moeten van zilveren banden zijn voorzien; ook de ringen moeten van zilver zijn, maar de voetstukken van brons. ");
INSERT INTO nld1939_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","De lengte van de voorhof moet honderd el bedragen, de breedte vijftig en de hoogte vijf el. Het lijnwaad moet getwijnd zijn; de voetstukken van brons. ");
INSERT INTO nld1939_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Alle benodigdheden voor de bouw van de tabernakel, al zijn pinnen en de pinnen van de voorhof moeten van brons zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Beveel ook aan de Israëlieten, dat zij u zuivere olie uit gestoten olijven voor de kandelaar brengen, om de lamp steeds brandend te houden. ");
INSERT INTO nld1939_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aäron en zijn zonen zullen die van de avond tot de morgen voor het aanschijn van Jahweh onderhouden in de openbaringstent buiten het voorhangsel, dat zich voor de ark des Verbonds bevindt. Dit is een eeuwige verplichting voor de Israëlieten van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Zonder u vervolgens uw broeder Aäron en zijn zonen uit de Israëlieten af, om Mij als priester te dienen: Aäron, met Nadab, Abihoe, Elazar en Itamar, de zonen van Aäron. ");
INSERT INTO nld1939_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Gij moet voor uw broeder Aäron heilige gewaden maken, om zijn glorie te doen stralen. ");
INSERT INTO nld1939_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Beveel dus aan alle kunstenaars, die Ik met fijne smaak heb begiftigd, dat zij de gewaden voor Aäron vervaardigen, opdat hij gewijd kan worden, om Mij als priester te dienen. ");
INSERT INTO nld1939_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","De volgende gewaden moeten zij vervaardigen: een borsttas, een borstkleed, een schoudermantel, een geborduurde tuniek, een tulband en een gordel. Voor de heilige gewaden, die ze voor uw broeder Aäron en zijn zonen moeten maken, om Mij als priester te dienen, ");
INSERT INTO nld1939_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","moeten zij goud, violet, purper, karmozijn, en getwijnd lijnwaad gebruiken. ");
INSERT INTO nld1939_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ze moeten uit goud, violet, purper, karmozijn en getwijnd lijnwaad een kunstig bewerkt borstkleed vervaardigen. ");
INSERT INTO nld1939_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Het moet twee schouderbanden hebben, die onderling verbonden zijn, en aan de beide uiteinden ervan moeten worden vastgemaakt. ");
INSERT INTO nld1939_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","De band, die het borstkleed omsluit, moet uit één stuk zijn en van hetzelfde maaksel: van goud, violet, purper, karmozijn en getwijnd lijnwaad. ");
INSERT INTO nld1939_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Dan moet ge twee onyxstenen nemen, en daarin de namen van Israëls zonen snijden: ");
INSERT INTO nld1939_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","zes namen op de ene steen, en zes op de andere, naar de volgorde van hun geboorte. ");
INSERT INTO nld1939_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Als graveerwerk, dat men in zegelstenen snijdt, moet ge de namen van Israëls zonen in de beide stenen griffen en ze dan in gouden zettingen vatten. ");
INSERT INTO nld1939_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","De beide stenen moet ge op de schouderbanden van het borstkleed hechten als gedachtenisstenen voor Israëls zonen, zodat Aäron op zijn beide schouders hun namen voor het aanschijn van Jahweh zal dragen, om hunner indachtig te zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","De zettingen moet ge van goud maken. ");
INSERT INTO nld1939_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Nog moet ge twee kettinkjes maken van zuiver goud als koorden gevlochten, en die aan de zettingen vasthechten. ");
INSERT INTO nld1939_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Verder moet ge een borsttas voor het orakel laten maken, kunstig bewerkt van dezelfde stof als het borstkleed: van goud, violet, purper, karmozijn en getwijnd lijnwaad. ");
INSERT INTO nld1939_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ze moet vierkant zijn en dubbel gevouwen, een span lang en een span breed. ");
INSERT INTO nld1939_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ge moet haar met vier rijen edelstenen bezetten: op de eerste rij een robijn, een topaas en een smaragd; ");
INSERT INTO nld1939_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","op de tweede rij een karbonkel, een saffier en een sardonix; ");
INSERT INTO nld1939_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","op de derde rij een hyacint, een agaat en een ametist; ");
INSERT INTO nld1939_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","en op de vierde rij een chrysoliet, een onyx en een jaspis. Zij moeten in gouden zettingen gevat zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Deze stenen moeten beantwoorden aan de namen van Israëls zonen; ze moeten dus evenals hun namen twaalf in getal zijn, en op iedere steen moet de naam van één der twaalf stammen worden gegrift, op dezelfde manier als men een zegel snijdt. ");
INSERT INTO nld1939_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Aan de borsttas moet ge kettinkjes maken van zuiver goud, als koorden gevlochten; ");
INSERT INTO nld1939_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","aan de beide boveneinden van de borsttas moet ge twee gouden ringen maken; ");
INSERT INTO nld1939_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","bevestig dan de twee gouden snoeren aan de beide ringen, die aan de boveneinden van de borsttas zitten, ");
INSERT INTO nld1939_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","en maak de beide einden van die twee snoeren aan de beide zettingen vast, die ge aan de voorkant der schouderbanden van het borstkleed hebt gehecht. ");
INSERT INTO nld1939_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Vervolgens moet ge nog twee gouden ringen maken, en die aan de beide benedeneinden van de borsttas bevestigen, en wel aan de binnenrand, die tegen het borstkleed ligt; ");
INSERT INTO nld1939_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","bovendien nog twee gouden ringen, die ge onder aan de voorkant van het borstkleed moet hechten, boven de band van het borstkleed, vlak bij de sluiting; ");
INSERT INTO nld1939_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","dan moet ge de ringen van de borsttas met een purperen snoer aan de ringen van het borstkleed vastbinden, zodat de borsttas boven de band van het borstkleed blijft hangen en niet op het borstkleed kan verschuiven. ");
INSERT INTO nld1939_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Zo zal Aäron, wanneer hij het heiligdom binnentreedt, de namen van Israëls zonen op zijn hart aan de orakeltas dragen, om hunner voortdurend indachtig te zijn voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","En in de orakeltas moet ge de Oerim en de Toemmim leggen, zodat zij op het hart van Aäron rusten, wanneer hij voor het aanschijn van Jahweh treedt; en zo zal Aäron altijd het orakel van Israëls zonen op zijn hart dragen voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Over het borstkleed moet ge een schoudermantel maken geheel van violet. ");
INSERT INTO nld1939_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","In het midden moet een opening zijn, om het hoofd er door te steken; die opening moet, als de hals van een wapenrok, rondom met een kunstig geweven zoom zijn afgezet, zodat ze niet kan inscheuren. ");
INSERT INTO nld1939_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Aan de onderrand van de schoudermantel moet ge rondom violette, purperen en karmozijnen granaatappeltjes aanbrengen en aan alle kanten daartussen gouden belletjes; ");
INSERT INTO nld1939_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","om beurt telkens een gouden belletje en een granaatappeltje rond de onderrand van de schoudermantel. ");
INSERT INTO nld1939_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aäron moet hem dragen als hij zijn bediening uitoefent, zodat men hem kan horen, wanneer hij voor het aanschijn van Jahweh het heiligdom binnentreedt of verlaat; anders zal hij sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Verder moet ge een plaat maken van zuiver goud, en daarin als in een zegel graveren: Aan Jahweh gewijd. ");
INSERT INTO nld1939_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ge moet ze met een purperen snoer aan de tulband vastmaken; en wel aan de voorkant. ");
INSERT INTO nld1939_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Zo zal ze tegen het voorhoofd van Aäron liggen, en zal Aäron de fouten op zich nemen, die de kinderen Israëls begaan bij de heilige offers en bij alle heilige gaven, welke zij brengen. Steeds moet zij tegen zijn voorhoofd liggen om hen welgevallig te maken aan Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Vervolgens moet ge een geborduurde tuniek, een tulband van lijnwaad en een kunstig bewerkte gordel maken. ");
INSERT INTO nld1939_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ook voor de zonen van Aäron moet ge tunieken, gordels en hoofddoeken vervaardigen, om hun glorie te doen stralen; ");
INSERT INTO nld1939_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","daarmee zult ge uw broeder Aäron en zijn zonen bekleden. Dan zult ge hen zalven, tot priesters aanstellen en wijden, zodat ze voor Mij hun priesterlijke bediening kunnen uitoefenen. ");
INSERT INTO nld1939_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ook moet ge voor hen linnen heupkleren maken, die van hun lenden tot hun dijen reiken om hun schaamte te bedekken. ");
INSERT INTO nld1939_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aäron en zijn zonen moeten ze dragen, wanneer zij de openbaringstent binnengaan of tot het altaar naderen, om in het heiligdom dienst te verrichten; anders zouden zij schuld op zich laden en sterven. Dit is een altijdgeldend voorschrift voor hem en zijn nakomelingschap. ");
INSERT INTO nld1939_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Deze handelingen moet ge aan hen voltrekken, om hen tot mijn priesters te wijden: Neem één jongen stier en twee rammen, die zonder gebreken zijn; ");
INSERT INTO nld1939_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","daarbij ongedesemde broden en ongedesemde koeken met olie gemengd en ongedesemde offervlaas met olie bestreken, van tarwebloem bereid. ");
INSERT INTO nld1939_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Leg ze in een mand, en breng ze in die mand tegelijk met den jongen stier en de twee rammen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Daarna moet ge Aäron en zijn zonen naar de ingang van de openbaringstent leiden en hen met water wassen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Dan moet ge de gewaden nemen, en Aäron bekleden met de tuniek, de schoudermantel, het borstkleed en de borsttas, hem het borstkleed vastbinden met de band, ");
INSERT INTO nld1939_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","de tulband op zijn hoofd plaatsen en de heilige diadeem aan de tulband bevestigen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Dan moet ge de zalfolie nemen, die over zijn hoofd uitstorten en hem zalven. ");
INSERT INTO nld1939_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Vervolgens moet ge zijn zonen doen toetreden, hen met de tunieken bekleden, ");
INSERT INTO nld1939_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","de gordel ombinden en de hoofddoeken omdoen. Wanneer ge zo Aäron en zijn zonen tot priesters hebt aangesteld, zullen zij de priesterlijke waardigheid bezitten als een eeuwig recht. ");
INSERT INTO nld1939_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Dan moet ge den stier voor de openbaringstent brengen, en Aäron en zijn zonen moeten hun handen op de kop van den stier leggen; ");
INSERT INTO nld1939_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","daarna moet men den stier voor het aanschijn van Jahweh aan de ingang van de openbaringstent slachten. ");
INSERT INTO nld1939_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Neem dan het bloed van den stier, strijk een gedeelte daarvan met uw vinger aan de hoornen van het altaar, en stort de rest tegen het voetstuk van het altaar. ");
INSERT INTO nld1939_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Vervolgens moet ge al het vet nemen, dat de ingewanden omgeeft, en de kwab aan de lever, de beide nieren en het niervet, en dat op het altaar in rook doen opgaan; ");
INSERT INTO nld1939_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","maar het vlees van den stier met zijn vel en darmen moet ge buiten de legerplaats in het vuur verbranden. Dit is het zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Dan moet ge een van de rammen nemen, en Aäron en zijn zonen moeten hun handen op de kop van den ram leggen; ");
INSERT INTO nld1939_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ge moet den ram slachten, zijn bloed opvangen, en er aan alle kanten het altaar mee besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Snijd dien ram vervolgens in stukken, was de ingewanden en poten af, en leg ze bij de andere stukken en de kop. ");
INSERT INTO nld1939_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Den helen ram moet ge op het altaar in rook doen opgaan. Het is een heerlijk geurend brandoffer voor Jahweh, een vuuroffer ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Daarna moet ge den tweeden ram nemen, en Aäron en zijn zonen moeten hun handen op zijn kop leggen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Dan moet ge hem slachten, met zijn bloed de rechteroorlel, rechterduim en rechter grote teen van Aäron en zijn zonen bestrijken, en met het overige bloed aan alle kanten het altaar besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Neem dan wat van het bloed, dat tegen het altaar is gesprenkeld, tegelijk met wat zalfolie, en besprenkel daarmee Aäron en de gewaden van Aäron, zijn zonen en de gewaden van zijn zonen, zodat hij en zijn zonen, alsook de gewaden van beiden zullen gewijd zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Vervolgens moet ge het vet van den ram nemen, met het staartvet en het vet, dat de ingewanden omgeeft, de kwab aan de lever, de beide nieren met het niervet, dat er om heen zit, en daar het een wijdingsram is, ook de rechterschenkel; ");
INSERT INTO nld1939_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","bovendien, uit de mand met ongedesemde broden, die voor het aanschijn van Jahweh staat, één rond brood, één met olie bestreken broodkoek en één vla. ");
INSERT INTO nld1939_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Dit alles moet ge in de handen van Aäron leggen en in die van zijn zonen, en als een strekoffer voor het aanschijn van Jahweh aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Dan moet ge het uit hun handen nemen, en het op het altaar in rook doen opgaan te zamen met het heerlijk geurend brandoffer voor het aanschijn van Jahweh; het is een vuuroffer ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Vervolgens moet ge het borststuk van Aärons wijdingsram nemen, en het als een strekoffer voor het aanschijn van Jahweh aanbieden. Dit zal uw deel zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Zo zult ge door het wijdingsram van Aäron en zijn zonen de borststukken, die als strekoffers worden aangeboden, en de schenkels, die als hefoffers worden opgedragen, heiligen; ");
INSERT INTO nld1939_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","volgens een altijdgeldende wet zullen zij het deel zijn, dat de kinderen Israëls aan Aäron en zijn zonen moeten afstaan. Want het is een hefoffer, en als zodanig moet het door Israëls zonen van hun vredeoffers worden afgestaan, als een gave aan Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","De heilige gewaden van Aäron zullen na hem op zijn zonen overgaan; daarin moeten zij gezalfd en tot priesters worden aangesteld. ");
INSERT INTO nld1939_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","En zeven dagen moet zijn zoon, die hem als priester opvolgt en de openbaringstent binnentreedt, zich daarmee bekleden, om de dienst in het heiligdom uit te oefenen. ");
INSERT INTO nld1939_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Het vlees van den wijdingsram moet ge op een heilige plaats koken. ");
INSERT INTO nld1939_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","En Aäron en zijn zonen zullen het vlees van den ram en het brood uit de mand eten bij de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Zij alleen mogen het eten, omdat zij daardoor de verzoening verkregen, toen men hen tot priester aanstelde en wijdde; een leek mag er niet van eten, want het is heilig. ");
INSERT INTO nld1939_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","En zo er iets van het vlees van het wijdingsoffer of van het brood tot de volgende morgen zou overblijven, moet ge dat overschot verbranden; het mag niet worden gegeten, want het is heilig. ");
INSERT INTO nld1939_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Voltrek dit alles aan Aäron en zijn zonen, juist zoals Ik het u heb bevolen. Zeven dagen moet ge de priesterwijding laten duren. ");
INSERT INTO nld1939_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Iedere dag moet ge tot verzoening een stier opdragen als zondeoffer, en door uw verzoening de onreinheid van het altaar wegnemen; dan moet ge het zalven, om het te wijden. ");
INSERT INTO nld1939_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Zeven dagen lang zult ge voor het altaar de verzoeningsplechtigheid verrichten, om het te wijden. Zo zal het altaar hoogheilig zijn, en iedereen, die het aanraakt, zal als iets heiligs worden behandeld. ");
INSERT INTO nld1939_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Regelmatig iedere dag moet ge twee eenjarig lammeren op het altaar offeren. ");
INSERT INTO nld1939_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Het ene lam moet ge des morgens offeren, het andere tegen de avond. ");
INSERT INTO nld1939_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Bij het eerste lam behoort een issaron meelbloem, gemengd met een kwart hin gestoten olie, en een plengoffer van een vierde hin wijn. ");
INSERT INTO nld1939_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Het andere lam moet ge tegen de avond offeren. Gij moet er eenzelfde spijs(-) en plengoffer bij doen als des morgens. Het moet een heerlijk geurend vuuroffer zijn ter ere van Jahweh, ");
INSERT INTO nld1939_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","een bestendig brandoffer van geslacht tot geslacht, opgedragen aan de ingang van de openbaringstent en voor het aanschijn van Jahweh, waar Ik Mij aan u zal openbaren, om tot u te spreken. ");
INSERT INTO nld1939_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Daar zal Ik Mij openbaren aan de zonen Israëls, en die plaats zal door mijn glorie worden geheiligd. ");
INSERT INTO nld1939_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ik zal de openbaringstent heiligen met het altaar, en Aäron heiligen met zijn zonen, om mijn priesters te zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ik zal wonen te midden van Israëls kinderen en hun God zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Dan zullen zij weten, dat Ik, Jahweh, hun God ben, die hen uit het land van Egypte heb geleid, om in hun midden te wonen: Ik Jahweh, hun God! ");
INSERT INTO nld1939_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Nog moet ge een altaar vervaardigen, om wierook te offeren. Ge moet dat van acaciahout maken, ");
INSERT INTO nld1939_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","een el lang en een el breed, dus vierkant, en twee ellen hoog; zijn hoornen moeten er één geheel mee uitmaken. ");
INSERT INTO nld1939_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ge moet het met zuiver goud overtrekken, zowel het bovenvlak, als alle zijkanten en de hoornen, en loofwerk van goud er omheen maken. ");
INSERT INTO nld1939_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Onder dat loofwerk moet ge aan weerskanten twee gouden krammen aanbrengen, die dienen voor de handbomen, waarmee het gedragen wordt. ");
INSERT INTO nld1939_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Die handbomen moet ge van acaciahout maken, en met goud beslaan. ");
INSERT INTO nld1939_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Gij moet het voor het voorhangsel plaatsen, dat voor de ark des Verbonds en het verzoendeksel boven de verbondswet hangt, waar Ik Mij aan u zal openbaren. ");
INSERT INTO nld1939_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Iedere morgen, wanneer Aäron de lampen in orde brengt, moet hij daarop geurige wierook branden; ");
INSERT INTO nld1939_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","en eveneens wanneer hij tegen de avond de lampen ontsteekt. Het moet een bestendig reukoffer zijn voor het aanschijn van Jahweh van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ge moogt daarop geen andere wierook offeren, dan die is voorgeschreven, noch daarop brand(-) en spijsoffers brengen, of plengoffers daarop uitgieten. ");
INSERT INTO nld1939_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Eenmaal per jaar moet Aäron de verzoeningsplechtigheid verrichten voor de hoornen; met het bloed van het zondeoffer ter verzoening zal hij dat eens per jaar doen. Zo zal het hoogheilig zijn voor Jahweh van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Jahweh vervolgde tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wanneer ge de Israëlieten monstert en ze hoofd voor hoofd telt, moet ieder van hen bij de monstering aan Jahweh een losprijs voor zijn leven betalen, opdat geen ramp hen bij de monstering mag treffen. ");
INSERT INTO nld1939_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dit moet iedereen geven, die op de monsterrol komt: een halve sikkel volgens het heilig gewicht, met twintig gera’s in een sikkel; die halve sikkel is een belasting voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Iedereen die op de monsterrol komt en twintig jaar oud is of meer, moet deze belasting voor Jahweh betalen. ");
INSERT INTO nld1939_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","De rijke zal niet meer en de arme niet minder dan een halve sikkel betalen, als belasting voor Jahweh, en als losprijs voor uw leven. ");
INSERT INTO nld1939_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gij zult het losgeld van Israëls zonen voor de dienst van de tabernakel gebruiken; maar het zal tevens dienen om Israëls kinderen bij Jahweh in gedachtenis te houden, en tot een losprijs voor uw leven. ");
INSERT INTO nld1939_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nog sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Maak ook een bronzen wasbekken met een onderstel van brons, plaats het tussen de openbaringstent en het altaar en vul het met water. ");
INSERT INTO nld1939_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Met dit water moeten Aäron en zijn zonen hun handen en voeten wassen. ");
INSERT INTO nld1939_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wanneer zij de openbaringstent binnengaan, moeten zij zich met het water afwassen, op straffe des doods; of wanneer zij tot het altaar willen naderen, om hun dienst te verrichten door een vuurofffer voor Jahweh te branden, ");
INSERT INTO nld1939_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","moeten zij handen en voeten wassen, op straffe des doods. Dit is voor hen een eeuwige wet, voor hem en zijn nazaat tot in het verste geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nog sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Voorzie u van de kostbaarste specerijen: vijfhonderd sikkels vloeibare myrrhe en half zoveel, dus tweehonderd vijftig sikkels geurige kaneel, tweehonderd vijftig sikkels geurige kalmus, ");
INSERT INTO nld1939_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","en vijf honderd sikkels laurier; alles volgens het heilig gewicht. Voeg er een hin olijfolie aan toe, ");
INSERT INTO nld1939_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","en bereid daarvan de heilige zalfolie. Een geurig mengsel moet het zijn volgens de regels der kunst; want het is de heilige zalfolie. ");
INSERT INTO nld1939_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Hiermee moet ge de openbaringstent zalven, de ark des Verbonds, ");
INSERT INTO nld1939_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","de tafel met haar toebehoren, de kandelaar met alles wat erbij hoort, het reukofferaltaar, ");
INSERT INTO nld1939_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","het brandofferaltaar met zijn toebehoren en het bekken met zijn onderstel. ");
INSERT INTO nld1939_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Daardoor zult ge ze wijden, zodat ze hoogheilig worden, en iedereen, die ze aanraakt, als iets heiligs zal worden behandeld. ");
INSERT INTO nld1939_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ook Aäron en zijn zonen zult ge er mee zalven, en hen wijden, om mijn priesters te zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Maar tot de Israëlieten zult ge zeggen: Dit zal voor Mij de heilige zalfolie zijn van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ge moogt ze niet over het lichaam van gewone mensen uitgieten, en zelfs in deze verhouding geen andere bereiden; want ze is heilig en ook voor u moet ze heilig zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Iedereen dus, die een soortgelijk mengsel bereidt of het aan een leek durft geven, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nog sprak Jahweh tot Moses: Voorzie u van geurige specerijen; van amber, kruidnagel en gom, van kruiden en zuivere hars, alles in gelijke hoeveelheid. ");
INSERT INTO nld1939_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ge moet daarvan volgens de regels der kunst een geurige wierook bereiden, met wat zout gemengd, zuiver en heilig. ");
INSERT INTO nld1939_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Hier moet ge telkens wat van afnemen, het tot poeder wrijven en voor de ark des Verbonds in de openbaringstent brengen, waar Ik Mij aan u zal openbaren. Hij moet hoogheilig voor u zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Als ge wierook voor u zelf wilt maken, moogt ge die niet in deze verhouding bereiden; ge moet hem als iets heiligs voor Jahweh beschouwen. ");
INSERT INTO nld1939_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Iedereen, die iets dergelijks maakt, om van zijn geur te genieten, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Daarna sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Zie, Ik heb Besalel, den zoon van Oeri, zoon van Choer, uit de stam van Juda uitverkoren, ");
INSERT INTO nld1939_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","en hem met Gods geest vervuld; met wijsheid en inzicht, met kennis en vaardigheid, ");
INSERT INTO nld1939_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","om ontwerpen te maken en uit te voeren in goud, zilver en brons, ");
INSERT INTO nld1939_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","om edelstenen te graveren en te zetten, om hout te bewerken, kortom voor elk soort van werk. ");
INSERT INTO nld1939_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Bovendien heb Ik hem Oholiab, den zoon van Achisamak, uit de stam van Dan als medewerker toegevoegd en aan alle bekwame vaklui heb Ik kunstvaardigheid geschonken, om alles te maken wat Ik bevolen heb: ");
INSERT INTO nld1939_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","de openbaringstent, de ark des Verbonds, het verzoendeksel daarop, en alles wat bij de tent behoort; ");
INSERT INTO nld1939_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","de tafel met toebehoren, de kandelaar van zuiver goud met toebehoren, het reukofferaltaar, ");
INSERT INTO nld1939_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","het brandofferaltaar met al zijn toebehoren, het bekken met zijn onderstel; ");
INSERT INTO nld1939_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","de heilige ambtsgewaden voor den priester Aäron en die van zijn zonen, om hun dienst te verrichten, ");
INSERT INTO nld1939_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","de zalfolie en de geurige wierook voor het heiligdom. Dit alles moeten ze maken, zoals Ik het u heb bevolen. ");
INSERT INTO nld1939_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Tenslotte sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Dit moet ge de Israëlieten inprenten! Onderhoudt vooral mijn sabbat; want hij is een teken tussen Mij en u van geslacht tot geslacht, waardoor men zal weten, dat Ik, Jahweh, het ben die u heilig. ");
INSERT INTO nld1939_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Onderhoudt dus de sabbat, want hij is heilig voor u. Iedereen die hem schendt, zal met de dood worden gestraft; iedereen, die op die dag enige arbeid verricht, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Zes dagen kunt ge werken, maar de zevende dag is een dag van volkomen rust, aan Jahweh gewijd. Wie op de sabbat enige arbeid verricht, moet sterven. ");
INSERT INTO nld1939_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Zo moeten de Israëlieten de sabbat onderhouden, en hem vieren van geslacht tot geslacht krachtens een eeuwig verbond. ");
INSERT INTO nld1939_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Hij zal een teken zijn voor eeuwig tussen Mij en de Israëlieten; want in zes dagen heeft Jahweh hemel en aarde gemaakt, maar op de zevende dag heeft Hij gerust en herademd. ");
INSERT INTO nld1939_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Toen Hij zijn onderhoud met Moses op de berg Sinaï had beëindigd, gaf Hij hem de beide tafelen van het Verbond, de stenen tafelen, met Gods eigen vingeren geschreven. ");
INSERT INTO nld1939_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Toen het volk intussen zag, dat Moses nog maar steeds niet van de berg afdaalde, liep het rond Aäron te hoop en zei tot hem: Kom, maak ons een god, die voor ons uittrekt; want we weten niet, wat er met Moses is gebeurd, den man, die ons uit Egypte heeft geleid. ");
INSERT INTO nld1939_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aäron gaf hun ten antwoord: Haalt de gouden ringen uit de oren van uw vrouwen, zonen en dochters, en brengt die bij mij. ");
INSERT INTO nld1939_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","En al het volk legde de gouden oorringen af, en bracht ze naar Aäron. ");
INSERT INTO nld1939_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Deze nam ze van hen aan, goot ze in een kleivorm, en maakte er een gegoten kalf van. Nu riepen zij: Israël, daar is uw God, die u uit Egypte heeft geleid! ");
INSERT INTO nld1939_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Toen Aäron dat zag, bouwde hij er een altaar voor, en kondigde af: Morgen is het feest ter ere van Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","En de volgende morgen droeg men brand(-) en vredeoffers op, en het volk zat neer, om te eten en te drinken, en ging zich vermaken. ");
INSERT INTO nld1939_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Toen sprak Jahweh tot Moses: Ga naar beneden, want uw volk, dat ge uit Egypte hebt geleid, is diep bedorven. ");
INSERT INTO nld1939_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Het heeft nu de weg al verlaten, die Ik het heb voorgeschreven. Zij hebben zich een kalf gegoten, aanbidden het, brengen het offers, en roepen: Israël, dit is uw God, die u uit Egypte heeft geleid! ");
INSERT INTO nld1939_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","En Jahweh vervolgde tot Moses: Ik heb nu gemerkt, wat voor volk het is: een halsstarrig volk. ");
INSERT INTO nld1939_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Laat Mij dus begaan, en mijn woede op hen koelen; Ik zal ze vernietigen en dan van u een groot volk maken. ");
INSERT INTO nld1939_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Maar Moses trachtte Jahweh, zijn God, te vermurwen, en sprak: Ach, Jahweh, waarom zoudt Gij uw woede koelen op uw volk, dat Gij met grote kracht en sterke hand uit Egypte hebt geleid? ");
INSERT INTO nld1939_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Waarom zouden de Egyptenaren zeggen: “Met opzet heeft Hij hen weggeleid, om hen in de bergen te doen omkomen en hen van de aarde te verdelgen!” Laat toch uw ziedende gramschap bedaren, en trek het onheil weer terug van uw volk. ");
INSERT INTO nld1939_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenk toch uw dienaren Abraham, Isaäk en Israël, wien Gij bij Uzelf hebt gezworen: “Ik zal uw kroost talrijk maken als de sterren aan de hemel, en hun heel dit land schenken, dat Ik hun heb beloofd, en zij zullen het als erfdeel bezitten voor eeuwig.” ");
INSERT INTO nld1939_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Toen kreeg Jahweh spijt over het onheil, waarmee Hij zijn volk had bedreigd. ");
INSERT INTO nld1939_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nu daalde Moses af van de berg met de beide tafelen van het Verbond in de hand, die aan beide zijden, van voren en van achteren, waren beschreven. ");
INSERT INTO nld1939_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Die tafelen waren Gods eigen werk, en het schrift in die tafelen gegrift, was Gods eigen schrift. ");
INSERT INTO nld1939_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Toen Josuë het volk hoorde joelen, zei hij tot Moses: Er is strijdrumoer in de legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Maar Moses antwoordde: Dit zijn geen overwinningskreten noch kreten bij een nederlaag; maar ik hoor zingen. ");
INSERT INTO nld1939_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Toen Moses de legerplaats was genaderd, en het kalf en de reidansen zag, barstte zijn gramschap los, wierp hij de tafelen uit zijn handen en smeet ze tegen de voet van de berg aan stukken. ");
INSERT INTO nld1939_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Daarop greep hij het kalf, dat ze hadden gemaakt, verbrandde het, vergruizelde het tot stof, en strooide dit op het water, dat hij de Israëlieten liet drinken. ");
INSERT INTO nld1939_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Toen zei Moses tegen Aäron: Wat heeft dit volk u toch gedaan, dat ge het met zulk een zware schuld hebt beladen? ");
INSERT INTO nld1939_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aäron antwoordde: Laat mijn heer niet toornig worden; gij weet toch zelf, hoe slecht dat volk is. ");
INSERT INTO nld1939_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ze zeiden tot mij: Maak ons een god, die voor ons uittrekt; want we weten niet, wat er met Moses is gebeurd, den man, die ons uit Egypte heeft geleid. ");
INSERT INTO nld1939_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Toen sprak ik tot hen: Wie goud heeft, moet er zich van ontdoen. En ze gaven het mij; ik wierp het in het vuur, en dit kalf kwam er uit. ");
INSERT INTO nld1939_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Toen Moses zag hoe bandeloos het volk was geworden, omdat Aäron de teugels had laten schieten tot leedvermaak van hun vijanden, ");
INSERT INTO nld1939_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ging hij aan de ingang van de legerplaats staan, en riep: Wie voor Jahweh is, hierheen! Alle zonen van Levi schaarden zich om hem heen. ");
INSERT INTO nld1939_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Hij sprak tot hen: Zo spreekt Jahweh Israëls God! Gordt allen uw zwaard aan! Trekt heen en weer de legerplaats door van de ene poort naar de andere, en slaat broeder, vriend en kennis dood. ");
INSERT INTO nld1939_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","De zonen van Levi deden, wat Moses gelastte, en zo vielen er op die dag van het volk ongeveer drieduizend man. ");
INSERT INTO nld1939_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nu sprak Moses: Ge hebt u heden aan Jahweh gewijd, iedereen ten koste van zijn zoon en zijn broeder; zo hebt ge u heden zegen verworven. ");
INSERT INTO nld1939_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","De volgende dag sprak Moses tot het volk: Ge hebt een zware zonde bedreven. Maar ik wil omhoog naar Jahweh gaan; misschien dat ik nog vergiffenis voor uw zonden kan krijgen. ");
INSERT INTO nld1939_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","En Moses keerde naar Jahweh terug, en sprak: Ach Jahweh, het volk heeft zwaar gezondigd; zij hebben zich een god van goud gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Maar vergeef toch hun zonden, of schrap mij uit het boek, dat Gij hebt geschreven. ");
INSERT INTO nld1939_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Jahweh gaf Moses ten antwoord: Ik schrap hem uit mijn boek, die tegen Mij heeft gezondigd! ");
INSERT INTO nld1939_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ga nu, en leid het volk naar de plaats, waarvan Ik u gesproken heb. Zie, een engel zal wel voor u uitgaan; maar als de dag voor mijn wraak is gekomen, zal Ik hen voor hun zonden straffen. ");
INSERT INTO nld1939_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Zo kastijdde Jahweh het volk, omdat zij Aäron het kalf hadden laten maken. ");
INSERT INTO nld1939_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","En Jahweh vervolgde tot Moses: Ga, trek op van hier met het volk, dat gij uit Egypte hebt geleid, naar het land, dat Ik Abraham, Isaäk en Jakob onder ede beloofd heb aan hun nageslacht te zullen schenken. ");
INSERT INTO nld1939_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ik zal dus een engel voor u uitzenden, die de Kanaänieten, Amorieten, Chittieten, Perizzieten, Chiwwieten en Jeboesieten zal verdrijven, ");
INSERT INTO nld1939_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","en u voeren naar het land, dat van melk en honing overvloeit. Maar Ik trek zelf niet in uw midden mee, want ge zijt een weerbarstig volk, en Ik zou u misschien onderweg nog verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Toen het volk deze vreselijke tijding vernam, bedreven zij rouw, en niemand deed zijn sieraden aan. ");
INSERT INTO nld1939_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Toen sprak Jahweh tot Moses: Zeg aan de Israëlieten: Gij zijt een weerbarstig volk; als Ik slechts een ogenblik in uw midden meetrok, zou Ik u verdelgen; maar leg uw sieraden af, dan zal Ik zien, wat Ik voor u kan doen. ");
INSERT INTO nld1939_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Daarom droegen de Israëlieten van de berg Horeb af geen sieraden meer. ");
INSERT INTO nld1939_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Daarom nam Moses zijn tent, sloeg ze op enige afstand buiten de legerplaats op, en noemde ze openbaringstent; en iedereen, die Jahweh wilde raadplegen, moest zich naar de openbaringstent begeven, die buiten de legerplaats lag. ");
INSERT INTO nld1939_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Telkens nu als Moses zich naar de tent begaf, kwam al het volk aan de ingang van zijn tenten staan en staarde Moses na, tot hij de tent was binnengegaan. ");
INSERT INTO nld1939_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Zodra Moses dan binnen de tent was gekomen, daalde de wolkkolom neer, en plaatste zich voor de ingang van de tent, waar Jahweh dan met Moses sprak. ");
INSERT INTO nld1939_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wanneer nu het hele volk de wolkkolom aan de ingang van de tent zag geplaatst, stond het hele volk overeind, en wierpen allen zich aan de ingang van hun tenten neer. ");
INSERT INTO nld1939_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Dan sprak Jahweh tot Moses van aanschijn tot aanschijn, zoals iemand spreekt met zijn vriend; daarna keerde Moses naar de legerplaats terug, terwijl zijn dienaar, de jeugdige Josuë, de zoon van Noen, de tent nooit verliet. ");
INSERT INTO nld1939_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses sprak tot Jahweh: Zie, Gij beveelt mij, dit volk te doen optrekken, maar Gij laat me niet weten, wien Gij met mij mee zult zenden. Toch hebt Gij mij gezegd: Ik heb u uitverkoren, en gij hebt genade gevonden in mijn ogen. ");
INSERT INTO nld1939_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Welnu, als ik genade heb gevonden in uw ogen, maak mij dan uw plannen bekend, opdat ik kan zien, of ik genade heb gevonden in uw ogen, en wete, of dit volk het uwe nog is. ");
INSERT INTO nld1939_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nu sprak Hij: Moet Ik dan zelf met u mee, om u tevreden te stellen? ");
INSERT INTO nld1939_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses antwoordde Hem: Wanneer Gij zelf niet met ons meegaat, doe ons dan niet van hier vertrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Waaraan zal men anders erkennen, dat ik met uw volk genade gevonden heb in uw ogen, en dat ik en uw volk uitverkoren zijn onder alle volken der aarde, tenzij Gij met ons optrekt? ");
INSERT INTO nld1939_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Toen sprak Jahweh tot Moses: Ook dit verzoek sta Ik u toe; want gij hebt genade gevonden in mijn ogen, en Ik heb u uitverkoren. ");
INSERT INTO nld1939_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Nu vroeg Moses: Laat mij dan uw Glorie aanschouwen. ");
INSERT INTO nld1939_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Hij antwoordde: Ik zal al mijn Majesteit aan u doen voorbijgaan, en ten aanhoren van u de naam Jahweh uitroepen; want Ik ben genadig, wien Ik genadig, en barmhartig, wien Ik barmhartig wil zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","En Hij ging voort: Mijn aanschijn kunt ge niet aanschouwen, want geen mens kan Mij zien en in leven blijven. ");
INSERT INTO nld1939_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","En Jahweh vervolgde: Bij Mij is een plaats, waar gij op de rots kunt staan. ");
INSERT INTO nld1939_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Wanneer mijn Glorie zal voorbijgaan, zal Ik u in een rotsholte plaatsen, en met mijn hand u bedekken, tot Ik voorbij ben. ");
INSERT INTO nld1939_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Dan neem Ik mijn hand van u weg, en kunt ge Mij van achteren zien; want mijn aanschijn kan niemand aanschouwen. ");
INSERT INTO nld1939_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Daarna sprak Jahweh tot Moses: Houw u twee stenen tafelen, zoals de vorige; dan zal Ik er de woorden opschrijven, die op de vorige tafelen stonden, welke gij hebt verbrijzeld. ");
INSERT INTO nld1939_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Zorg, dat gij tegen de morgen gereed zijt; bestijg dan de berg Sinaï, en blijf daar op de top van de berg op Mij wachten. ");
INSERT INTO nld1939_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Maar niemand mag met u mee, niemand mag op heel de berg worden gezien; zelfs mogen er geen schapen en runderen weiden in de nabijheid van de berg. ");
INSERT INTO nld1939_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moses hakte dus twee stenen tafelen, gelijk aan de eerste, besteeg vroeg in de morgen de berg Sinaï, zoals Jahweh het hem had bevolen, en nam de twee stenen tafelen met zich mee. ");
INSERT INTO nld1939_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Toen daalde Jahweh neer in de wolk, terwijl Moses daar op Hem wachtte en Jahweh aanriep bij zijn Naam. ");
INSERT INTO nld1939_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nu ging Jahweh hem voorbij, en Jahweh riep: Jahweh is een barmhartige en ontfermende God, lankmoedig, vol van liefde en trouw, ");
INSERT INTO nld1939_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","die duizenden genade bewijst, die misdaden, fouten en zonden vergeeft, zonder ze ongestraft te laten, maar de zonden der vaderen op de zonen en kleinzonen wreekt tot in het derde en vierde geslacht. ");
INSERT INTO nld1939_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Haastig wierp Moses zich op zijn knieën, boog zich ter aarde, ");
INSERT INTO nld1939_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","en sprak: Heer, zo ik genade gevonden heb ik uw ogen, Heer, trek dan mee op, te midden van ons. Zeker het is een weerbarstig volk; maar vergeef ons onze zonde en schuld, en neem ons als uw erfdeel aan. ");
INSERT INTO nld1939_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hij sprak: Zie, Ik sluit een Verbond met u. Ten aanschouwen van heel uw volk zal Ik wonderdaden verrichten, zoals er nog nooit op de ganse aarde en onder enig volk zijn gewrocht; en heel het volk, waaronder gij leeft, zal het werk van Jahweh zien. Ja, ontzaglijk zal het zijn, wat Ik voor u ga verrichten! ");
INSERT INTO nld1939_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Onderhoud slechts, wat Ik u heden gebied; dan drijf Ik de Amorieten, Kanaänieten, Chittieten, Perizzieten, Chiwwieten en Jeboesieten voor u uit. ");
INSERT INTO nld1939_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wacht u ervoor, een verbond te sluiten met de bewoners van het land, waar gij heen trekt, opdat zij onder u geen valstrik worden. ");
INSERT INTO nld1939_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Neen, gij moet hun altaren verwoesten, hun wijstenen omverwerpen en hun heilige bomen omhakken. ");
INSERT INTO nld1939_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Gij zult geen vreemden god aanbidden; want Jahweh wordt ijverzuchtig genoemd, en Hij is een naijverige God. ");
INSERT INTO nld1939_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Sluit geen verbond met de inwoners van het land, die ontuchtig hun goden achterna lopen, en aan hun goden offers brengen. Want anders nodigen zij u daarbij uit, en zoudt gij van hun altaren eten; ");
INSERT INTO nld1939_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","gij zoudt hun dochters als vrouwen voor uw zonen nemen, en hun dochters, die ontuchtig haar goden achterna lopen, zouden ook uw zonen daartoe verleiden. ");
INSERT INTO nld1939_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Gij moogt u geen gegoten godenbeeld maken. ");
INSERT INTO nld1939_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Gij moet het feest der ongedesemde broden vieren. Op de vastgestelde tijd van de maand Abib zult ge zeven dagen lang ongedesemd brood eten, zoals Ik u bevolen heb; want in de maand Abib zijt ge uit Egypte getrokken. ");
INSERT INTO nld1939_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Al wat de moederschoot opent, behoort aan Mij: ieder eerstgeboren mannelijk dier van uw kudde, zowel van runderen als van schapen; ");
INSERT INTO nld1939_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","alleen het eerstgeboren ezelsjong zult ge loskopen met een lam, of het anders de nek breken. Maar al de eerstgeborenen van uw zonen moet ge loskopen, en zij zullen niet met lege handen voor Mij verschijnen. ");
INSERT INTO nld1939_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Zes dagen moogt ge werken, maar op de zevende dag zult gij rusten; zelfs in de ploeg(-) en oogsttijd zult ge dan rusten. ");
INSERT INTO nld1939_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Bij de eerstelingen van de tarweoogst zult ge het feest der weken vieren: en het plukfeest bij de wisseling van het jaar. ");
INSERT INTO nld1939_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Drie maal per jaar moeten alle mannen onder u voor den Heer Jahweh, den God van Israël, verschijnen. ");
INSERT INTO nld1939_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","En wanneer Ik de heidenen voor u heb verdreven en u een uitgestrekt grondgebied heb geschonken, zal niemand uw land zelfs begeren, terwijl gij driemaal per jaar optrekt, om voor Jahweh, uw God, te verschijnen. ");
INSERT INTO nld1939_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Gij zult het bloed van wat Mij is geofferd, niet tegelijk met gedesemd brood ten offer brengen. Van het paasoffer mag niets tot de volgende morgen worden bewaard. ");
INSERT INTO nld1939_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","De eerste vruchten van uw akkers moet ge naar het huis van Jahweh, uw God, brengen. Gij moogt het geitje niet koken in de melk van zijn moeder. ");
INSERT INTO nld1939_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nu sprak Jahweh tot Moses: Schrijf deze geboden op; want op grond van deze geboden, sluit Ik met u en Israël een Verbond. ");
INSERT INTO nld1939_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","En Moses bleef daar met Jahweh veertig dagen en veertig nachten, zonder te eten of te drinken, en Hij schreef op de tafelen de bepalingen van het Verbond: de tien geboden. ");
INSERT INTO nld1939_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Daarna daalde Moses van de berg Sinaï af, met de tafelen van het Verbond in zijn hand. Terwijl Moses van de berg afdaalde, wist hij niet, dat de huid van zijn aangezicht straalde, omdat hij met Jahweh gesproken had. ");
INSERT INTO nld1939_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Toen Aäron en al de Israëlieten zagen, dat de huid van Moses’ aangezicht straalde, durfden zij hem niet naderen. ");
INSERT INTO nld1939_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Eerst toen Moses hen riep, kwamen Aäron en al de leiders van de gemeenschap bij hem, en sprak Moses hun toe. ");
INSERT INTO nld1939_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Nu durfden ook de andere Israëlieten naderen, en deelde Moses hun alles mee, wat Jahweh hem op de berg Sinaï bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Toen Moses zijn toespraak beëindigd had, legde hij een sluier over zijn gelaat. ");
INSERT INTO nld1939_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","En telkens wanneer Moses voor Jahweh verscheen om met Hem te spreken, verwijderde hij de sluier, tot hij weer heenging. Maar als hij dan naar buiten trad, om de Israëlieten alle bevelen mede te delen, ");
INSERT INTO nld1939_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","en dezen zagen hoe de huid van Moses’ aangezicht straalde, legde Moses de sluier over zijn gelaat, totdat hij weer naar binnen ging, om met God te spreken. ");
INSERT INTO nld1939_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Nu riep Moses de hele gemeenschap der Israëlieten bijeen, en sprak: Dit zijn de geboden, die Jahweh u beveelt te onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Zes dagen kunt ge arbeid verrichten, maar op de zevende dag moet gij een heilige sabbat van volkomen rust ter ere van Jahweh houden. Iedereen, die op die dag arbeid verricht, moet sterven; ");
INSERT INTO nld1939_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","zelfs geen vuur moogt ge op de sabbat in uw woningen aansteken. ");
INSERT INTO nld1939_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","En Moses vervolgde tot heel de gemeenschap der Israëlieten: Dit heeft Jahweh bevolen! ");
INSERT INTO nld1939_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Gij moet van uw bezit een bijdrage voor Jahweh afstaan. Iedereen, wien het hart het ingeeft, moet Jahweh geschenken brengen: goud, zilver en brons, ");
INSERT INTO nld1939_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","violet, purper en karmozijn, getwijnd lijnwaad en geitenhaar; ");
INSERT INTO nld1939_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","roodgeverfde ramsvellen, gelooide huiden en acaciahout; ");
INSERT INTO nld1939_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olie voor de lampen en specerijen voor de zalfolie en voor de geurige wierook; ");
INSERT INTO nld1939_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onyxstenen en andere edelstenen, om er het borstkleed en de borsttas mee te bezetten. ");
INSERT INTO nld1939_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Alle kunstenaars, die er onder u zijn, moeten opkomen, en alles vervaardigen, wat Jahweh bevolen heeft: ");
INSERT INTO nld1939_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","de tabernakel met zijn tent en bedekking, zijn haken, schotten en bindlatten, zijn palen met hun voetstukken; ");
INSERT INTO nld1939_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","de ark met haar handbomen, het verzoendeksel en het voorhangsel; ");
INSERT INTO nld1939_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","de tafel en haar handbomen en al wat er bij hoort, en de toonbroden; ");
INSERT INTO nld1939_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","de kandelaar met haar benodigdheden, de lampen en de olie voor de kandelaar; ");
INSERT INTO nld1939_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","het reukofferaltaar met zijn handbomen; de zalfolie en de geurige wierook; het tapijt voor de ingang van de tabernakel; ");
INSERT INTO nld1939_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","het brandofferaltaar met zijn bronzen rasterwerk, zijn handbomen en al zijn benodigdheden; het bekken met zijn onderstel; ");
INSERT INTO nld1939_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","de gordijnen rond de voorhof met hun palen en voetstukken, en het tapijt voor de ingang van de voorhof; ");
INSERT INTO nld1939_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","de pinnen voor de tabernakel en de pinnen voor de voorhof met haar touwen; ");
INSERT INTO nld1939_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","de ambtsgewaden, om in het heiligdom de priesterdienst te verrichten, de heilige gewaden voor den priester Aäron en de priestergewaden voor zijn zonen. ");
INSERT INTO nld1939_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toen ging heel de gemeenschap der Israëlieten van Moses heen; ");
INSERT INTO nld1939_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","en iedereen, wien het hart het ingaf en die zich daartoe voelde aangetrokken, kwam Jahweh geschenken brengen voor de bouw van de openbaringstent, voor de eredienst en de heilige gewaden. ");
INSERT INTO nld1939_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Zowel mannen als vrouwen brachten geschenken, iedereen, wien het hart het ingaf. Iedereen, die Jahweh een wijgeschenk van goud wilde aanbieden, bracht gespen, oorringen, vingerringen, halsketens en allerlei andere gouden sieraden. ");
INSERT INTO nld1939_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Iedereen, die violet, purper en karmozijn, lijnwaad en geitenhaar, roodgeverfde ramsvellen of gelooide huiden bezat, kwam het brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Iedereen, die een geschenk van zilver of koper wilde aanbieden, bracht het als een gave voor Jahweh; en iedereen, die acaciahout bezat, dat overal bij het werk nodig kon zijn, bracht dat. ");
INSERT INTO nld1939_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Alle kunstzinnige vrouwen begonnen eigenhandig te spinnen, en brachten wat ze gesponnen hadden: violet, purper, karmozijn en lijnwaad; ");
INSERT INTO nld1939_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","en alle vrouwen, die door haar vaardigheid er lust in vonden, sponnen het geitenhaar. ");
INSERT INTO nld1939_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","De leiders brachten onyxstenen en edelstenen, om er het borstkleed en de borsttas mee te bezetten; ");
INSERT INTO nld1939_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","bovendien de specerijen, de olie voor de kandelaar, de zalfolie en de geurige wierook. ");
INSERT INTO nld1939_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Zo brachten de kinderen Israëls Jahweh hun vrijwillige gaven; alle mannen en vrouwen, wie het hart het ingaf, om bij te dragen voor heel het werk, dat Jahweh door Moses bevolen had te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Daarop sprak Moses tot de Israëlieten: Ziet, Jahweh heeft Besalel, den zoon van Oeri, zoon van Choer, uit de stam van Juda uitverkoren, ");
INSERT INTO nld1939_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","en hem met Gods geest vervuld: met wijsheid en inzicht, met kennis en vaardigheid, ");
INSERT INTO nld1939_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","om ontwerpen te maken en in goud, zilver of brons uit te voeren, ");
INSERT INTO nld1939_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","om edelstenen te graveren en te zetten, hout te bewerken, en allerlei kunstzinnige arbeid te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hem en Oholiab, den zoon van Achisamak, uit de stam van Dan, heeft Hij geschikt gemaakt, om leiding te geven, ");
INSERT INTO nld1939_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","en vakkennis verleend, om alle soort arbeid te laten verrichten, zowel het werk van ambachtslieden als van kunstenaars, het werk van wevers van violet, purper, karmozijn en lijnwaad, als dat van eenvoudige wevers. Zij zullen dus zowel de uitvoerders zijn van het hele werk, als de ontwerpers ervan. ");
INSERT INTO nld1939_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besalel zal dus het werk voltooien, geholpen door Oholiab en alle kunstenaars, aan wie Jahweh bekwaamheid en inzicht verleend heeft, om met beleid alles te vervaardigen voor de bouw van het heiligdom, juist zoals Jahweh het bevolen heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Nu riep Moses Besalel en Oholiab en alle kunstenaars op, wie Jahweh bekwaamheid had geschonken: allen die zich bezield gevoelden, om aan het werk te gaan en het uit te voeren. ");
INSERT INTO nld1939_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","En onder toezicht van Moses namen zij alle geschenken in ontvangst, die de Israëlieten brachten voor de bouw van het heiligdom. Maar toen men hem iedere morgen opnieuw gaven bleef brengen, ");
INSERT INTO nld1939_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","staakten al de kunstenaars, die de verschillende werkzaamheden aan het heiligdom moesten verrichten, een voor een het werk, waarmee zij bezig waren, ");
INSERT INTO nld1939_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","en zeiden tot Moses: Het volk brengt veel meer dan nodig is voor de uitvoering van het werk, dat Jahweh gelast heeft. ");
INSERT INTO nld1939_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Daarom beval Moses, in het kamp af te kondigen: Niemand, man noch vrouw, behoeft nog iets te vervaardigen als geschenk voor het heiligdom! Zo moest het volk er van worden afgehouden, verdere geschenken te brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Wat al vervaardigd was, was voldoende en meer dan voldoende, om het hele werk ten uitvoer te brengen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Nu begonnen alle kunstenaars onder de werklieden de tabernakel te maken. Ze vervaardigden hem uit tien banen van getwijnd lijnwaad, van violet, purper en karmozijn, met cherubs versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","De lengte van een baan was acht en twintig el, de breedte vier el; alle banen hadden dezelfde afmetingen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Men hechtte de banen vijf bij vijf aan elkander, ");
INSERT INTO nld1939_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","en maakte violetkleurige lussen aan de zoom van de eerste baan van het ene stel en eveneens aan de zoom van de laatste baan van het andere stel. ");
INSERT INTO nld1939_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Vijftig lussen maakte men aan de baan van het ene stel en vijftig lussen aan de zoom van de laatste baan van het andere stel, zodat de lussen tegenover elkander kwamen te zitten. ");
INSERT INTO nld1939_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Vervolgens maakte hij vijftig gouden haken, en hechtte de banen met die haken aaneen, zodat de tabernakel een geheel werd. ");
INSERT INTO nld1939_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Daarna maakte hij banen van geitenhaar voor de tent over de tabernakel; hij maakte elf van deze banen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","De lengte van een baan bedroeg dertig el en de breedte vier el; alle elf banen hadden dezelfde afmetingen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Vijf van die banen hechtte hij afzonderlijk aan elkander vast, en eveneens de zes andere afzonderlijk. ");
INSERT INTO nld1939_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Dan maakte hij vijftig lussen aan de zoom van de laatste baan van het ene stel en evenzo vijftig lussen aan de zoom van de laatste baan van het andere stel; ");
INSERT INTO nld1939_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","vervolgens maakte hij vijftig bronzen haken, om de tent zo samen te voegen, dat ze een geheel werd. ");
INSERT INTO nld1939_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Vervolgens maakte hij over deze tent een dek van roodgeverfde ramsvellen, en nog een dekkleed van gelooide huiden daar overheen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Daarna vervaardigde hij voor de tabernakel rechtopstaande schotten van acaciahout. ");
INSERT INTO nld1939_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ieder schot was tien el hoog, en anderhalve el breed, ");
INSERT INTO nld1939_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","en onder ieder schot zaten twee pennen, recht naast elkaar. Zo deed hij met alle schotten van de tabernakel. ");
INSERT INTO nld1939_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Voor de zuidkant van de tabernakel maakte hij twintig schotten, ");
INSERT INTO nld1939_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","en onder die twintig schotten maakte hij veertig zilveren voetstukken, zodat er zich telkens twee onder ieder schot bevonden voor de beide pennen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Voor de andere wand van de tabernakel dus aan de noordkant, maakte hij eveneens twintig schotten ");
INSERT INTO nld1939_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","met hun veertig zilveren voetstukken, telkens twee onder ieder schot. ");
INSERT INTO nld1939_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Voor de achterkant van de tabernakel, dus in het westen, maakte hij zes schotten; ");
INSERT INTO nld1939_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","daarenboven voor de beide hoeken van de achterwand van de tabernakel twee schotten, ");
INSERT INTO nld1939_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","die van onderen in elkander grepen, en evenzo van boven bij de eerste kram. Zo deed hij voor die twee, daar zij beiden de hoekstukken vormden. ");
INSERT INTO nld1939_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Er waren dus acht schotten met hun zestien zilveren voetstukken, telkens twee voetstukken onder ieder schot. ");
INSERT INTO nld1939_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Vervolgens maakte hij bindlatten van acaciahout, vijf voor de schotten van de ene zijwand van de tabernakel, ");
INSERT INTO nld1939_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","en vijf voor de schotten van de andere zijwand van de tabernakel, en ook vijf voor de schotten aan de achterwand van de tabernakel, in het westen. ");
INSERT INTO nld1939_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","De middelste bindlat maakte hij zo, dat zij midden over de schotten liep van het ene einde tot het andere. ");
INSERT INTO nld1939_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","De schotten bekleedde hij met goud; de krammen, waarin de bindlatten rustten, maakte hij van goud; de bindlatten zelf overtrok hij weer met goud. ");
INSERT INTO nld1939_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Daarna maakte hij het voorhangsel van violet, purper, karmozijn en getwijnd lijnwaad, met cherubs versierd. ");
INSERT INTO nld1939_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Hij maakte daarvoor vier palen van acaciahout, die hij met goud besloeg, met gouden ringen eraan en goot er vier zilveren voetstukken voor. ");
INSERT INTO nld1939_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ten slotte vervaardigde hij voor de ingang van de Tent een tapijt van violet, purper, karmozijn en getwijnd lijnwaad, met fijn borduurwerk versierd; ");
INSERT INTO nld1939_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","daarbij de vijf palen met hun ringen. De koppen en banden der palen overtrok hij met goud, terwijl de vijf voetstukken van brons waren. ");
INSERT INTO nld1939_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Vervolgens maakte Besalel de ark van acaciahout. twee en een halve el lang, anderhalve el breed en anderhalve el hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Hij bekleedde haar van binnen en van buiten met zuiver goud, en maakte er loofwerk van goud omheen. ");
INSERT INTO nld1939_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hij goot er vier gouden krammen voor, boven aan de vier poten, twee krammen dus aan iedere kant. ");
INSERT INTO nld1939_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Hij maakte handbomen van acaciahout, die hij met goud besloeg. ");
INSERT INTO nld1939_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Die handbomen stak hij door de krammen aan weerskanten van de ark, om daarmee de ark te dragen. ");
INSERT INTO nld1939_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Daarna maakte hij een verzoendeksel van zuiver goud, twee en een halve el lang en anderhalve el breed. ");
INSERT INTO nld1939_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Aan de beide uiteinden van het verzoendeksel maakte hij twee gouden cherubs, als drijfwerk. ");
INSERT INTO nld1939_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Een cherub sloeg hij uit aan het ene einde, en een cherub aan het andere einde; zo sloeg hij in het verzoendeksel zelf aan beide uiteinden de cherubs uit. ");
INSERT INTO nld1939_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","De cherubs spreidden hun vleugels omhoog, en overspanden met hun vleugels het verzoendeksel; ze stonden tegenover elkander terwijl hun gezichten naar het verzoendeksel waren gericht. ");
INSERT INTO nld1939_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Vervolgens vervaardigde hij de tafel van acaciahout, twee ellen lang, een el breed en anderhalve el hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Hij overtrok haar met zuiver goud, en maakte er loofwerk van goud omheen. ");
INSERT INTO nld1939_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hij maakte daar een lijst omheen van een hand breed, en om die lijst loofwerk van goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ook goot hij vier gouden krammen en bevestigde die aan de vier hoeken bij de vier poten. ");
INSERT INTO nld1939_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Die krammen zaten vlak bij de lijst, om er de handbomen door te steken, waaraan de tafel gedragen werd. ");
INSERT INTO nld1939_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","De handbomen van de tafel maakte hij van acaciahout, en besloeg ze met goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Bovendien maakte hij het vaatwerk dat bij de tafel behoort, de schotels, kannen, schalen en bekers, waarmee men de plengoffers brengt, van zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Daarna maakte hij de kandelaar van zuiver goud. Hij vervaardigde de kandelaar als drijfwerk: zijn voetstuk, schacht, zijn bloemkelken, knoppen en bloesems uit één stuk. ");
INSERT INTO nld1939_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Zes armen staken terzijde uit, drie armen aan de ene kant van de kandelaar en drie armen aan de andere kant. ");
INSERT INTO nld1939_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Aan iedere arm zaten drie bloemkelken in de vorm van amandelbloesem, knoppen en bloesems; dus aan de zes armen, die uit de kandelaar staken, op dezelfde manier. ");
INSERT INTO nld1939_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Aan de kandelaar zelf zaten vier bloemkelken in de vorm van amandelbloesem, knoppen en bloesems; ");
INSERT INTO nld1939_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","onder de drie paar armen zat telkens een knop, waar de zes armen uit de kandelaar schoten. ");
INSERT INTO nld1939_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","De knoppen en armen waren met de kandelaar uit één stuk: het geheel één stuk drijfwerk van zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bovendien maakte hij de zeven lampen, die er bij horen, met de snuiters en bakjes, van zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hij gebruikte voor het vervaardigen van de kandelaar en alles wat er bij hoort, een talent zuiver goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Vervolgens maakte hij het reukofferaltaar van acaciahout, een el lang en een el breed, dus vierkant, en twee ellen hoog. De hoornen maakten er één geheel mee uit. ");
INSERT INTO nld1939_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Hij overtrok het met zuiver goud, zowel het bovenvlak als alle zijkanten en de hoornen, en maakte er loofwerk van goud omheen. ");
INSERT INTO nld1939_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Onder dat loofwerk bracht hij aan weerskanten twee gouden krammen aan, die moesten dienen voor de handbomen, waarmee het gedragen werd. ");
INSERT INTO nld1939_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","De handbomen maakte hij van acaciahout en besloeg ze met goud. ");
INSERT INTO nld1939_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nog bereidde hij de heilige zalfolie en de wierook van zuivere specerijen, volgens de regels der kunst gemengd. ");
INSERT INTO nld1939_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Vervolgens maakte hij het brandofferaltaar van acaciahout, vijf ellen lang en vijf ellen breed, dus vierkant, en drie ellen hoog. ");
INSERT INTO nld1939_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Op de vier hoeken maakte hij de hoornen, die met het altaar uit één stuk waren, en hij besloeg ze met brons. ");
INSERT INTO nld1939_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hij maakte ook al de benodigdheden voor het altaar: de bakken, schoppen, schalen, vorken en vuurpotten; al die benodigdheden maakte hij van brons. ");
INSERT INTO nld1939_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hij maakte aan het altaar een netvormig rasterwerk van brons beneden onder het raam tot halverhoogte. ");
INSERT INTO nld1939_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Dan goot hij vier krammen voor de vier hoeken van het bronzen rasterwerk, om er de handbomen door te steken; ");
INSERT INTO nld1939_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","deze maakte hij van acaciahout en besloeg ze met brons. ");
INSERT INTO nld1939_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Hij stak ze door de krammen aan de zijden van het altaar, om het daarmee te dragen. Het altaar maakte hij hol en van planken. ");
INSERT INTO nld1939_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Daarna maakte hij nog het bronzen bekken met een bronzen onderstel van de spiegels der vrouwen, die dienst deden aan de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tenslotte maakte hij de voorhof. Aan de zuidkant werd hij afgezet met gordijnen van getwijnd lijnwaad over een lengte van honderd el. ");
INSERT INTO nld1939_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Hij hing ze aan twintig palen op twintig bronzen voetstukken; de ringen en banden der palen waren van zilver. ");
INSERT INTO nld1939_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Aan de noordzijde hing hij eveneens gordijnen over een lengte van honderd el aan twintig palen op hun twintig bronzen voetstukken; de ringen en banden der palen waren van zilver. ");
INSERT INTO nld1939_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Aan de westkant hing hij gordijnen over een lengte van vijftig el, aan tien palen op hun tien voetstukken; de ringen en banden der palen waren van zilver. ");
INSERT INTO nld1939_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","De voorzijde, ten oosten, had een lengte van vijftig el. ");
INSERT INTO nld1939_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","De ene hoek was afgezet met gordijnen over een lengte van vijftien el aan drie palen op hun drie voetstukken. ");
INSERT INTO nld1939_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","De andere hoek naast de ingang van de voorhof was eveneens afgezet met gordijnen over een lengte van vijftien el, aan drie palen op hun drie voetstukken. ");
INSERT INTO nld1939_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alle gordijnen rond de voorhof waren van getwijnd lijnwaad; ");
INSERT INTO nld1939_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","de voetstukken der palen waren van brons, de ringen en banden der palen van zilver; de koppen waren met zilver beslagen, en alle palen van de voorhof waren van zilveren banden voorzien. ");
INSERT INTO nld1939_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Het tapijt voor de ingang van de voorhof was een kunstig weefsel van violet, purper, karmozijn en getwijnd lijnwaad, twintig el lang, en vijf el hoog of breed, evenals de gordijnen van de voorhof. ");
INSERT INTO nld1939_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","De vier palen met hun voetstukken waren van brons: de ringen, koppen en banden van zilver. ");
INSERT INTO nld1939_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Al de pinnen van de tabernakel en van de voorhof rondom waren van brons. ");
INSERT INTO nld1939_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Dit is de berekening der kosten van de tabernakel, de verbondstabernakel, die op bevel van Moses door de Levieten onder leiding van Itamar, den zoon van den priester Aäron, werd opgemaakt. ");
INSERT INTO nld1939_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalel, de zoon van Oeri, zoon van Choer, uit de stam van Juda, had alles vervaardigd, wat Jahweh aan Moses bevolen had; ");
INSERT INTO nld1939_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","en Oholiab, de zoon van Achisamak, uit de stam van Dan, en de ambachtslieden, kunstenaars en wevers van violet, purper, karmozijn en lijnwaad hadden hem ter zijde gestaan. ");
INSERT INTO nld1939_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Al het goud, dat gebruikt werd voor de volledige afbouw van het heiligdom, bestond uit goud, dat vrijwillig bijeen was gebracht, en bedroeg negen en twintig talenten en zeven honderd dertig sikkels volgens het heilig gewicht. ");
INSERT INTO nld1939_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Het zilver, dat de monstering van de gemeenschap had opgebracht, bedroeg honderd talenten en zeventienhonderd vijf en zeventig sikkels volgens het heilig gewicht. ");
INSERT INTO nld1939_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Het had één beka per hoofd bedragen, de helft van de sikkel, volgens het heilig gewicht, voor iedereen die op de monsterrol was gekomen, dus voor iederen man van de ouderdom van twintig jaar en daarboven: zeshonderd drie duizend vijfhonderd vijftig man in het geheel. ");
INSERT INTO nld1939_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Deze honderd talenten zilver dienden, om de voetstukken van het heiligdom en van het voorhangsel te gieten; honderd talenten voor honderd voetstukken, dus per voetstuk één talent. ");
INSERT INTO nld1939_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Van de zeventienhonderd vijf en zeventig sikkels maakte hij de ringen voor de palen, besloeg hij hun koppen, en maakte hij er banden omheen. ");
INSERT INTO nld1939_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Het brons dat vrijwillig bijeen was gebracht, bedroeg zeventig talenten en vier en twintig honderd sikkels. ");
INSERT INTO nld1939_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Daarvan maakte hij de voetstukken voor de ingang van de openbaringstent, het bronzen altaar, zijn bronzen rasterwerk, en al de benodigdheden voor het altaar; ");
INSERT INTO nld1939_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","bovendien de voetstukken van de voorhof rondom en de voetstukken voor de ingang van de voorhof, al de pinnen van de tabernakel en de pinnen van de voorhof rondom. ");
INSERT INTO nld1939_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","De ambtsgewaden voor de dienst in het heiligdom vervaardigde men van violet, purper en karmozijn; men vervaardigde de heilige gewaden van Aäron juist zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hij maakte het borstkleed van goud, violet, purper, karmozijn en getwijnd lijnwaad. ");
INSERT INTO nld1939_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Zij pletten het goud tot bladen en sneden het tot draden, om die kunstig tussen het violet, purper, karmozijn en het lijnwaad te weven. ");
INSERT INTO nld1939_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","De schouderbanden, die onderling verbonden waren, hechtte hij aan de twee uiteinden daarvan vast. ");
INSERT INTO nld1939_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","De band, die het borstkleed omsloot, was uit één stuk, en van hetzelfde maaksel: van goud, violet, purper, karmozijn en getwijnd lijnwaad, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","De beide onyxstenen, waarin de namen van Israëls zonen waren gegrift, zoals men in zegelstenen snijdt, vatte men in gouden zettingen. ");
INSERT INTO nld1939_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Hij hechtte ze op de schouderbanden van het borstkleed als gedachtenisstenen voor Israëls zonen, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Hij maakte de borsttas kunstig bewerkt van dezelfde stof als het borstkleed: van goud, violet, purper, karmozijn, en getwijnd lijnwaad. ");
INSERT INTO nld1939_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","De borsttas was vierkant, en men vouwde haar dubbel; en dubbelgevouwen was zij een span lang en een span breed. ");
INSERT INTO nld1939_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Men bezette haar met vier rijen edelstenen; op de eerste rij: een robijn, een topaas en een smaragd; ");
INSERT INTO nld1939_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","op de tweede rij: een karbonkel, een saffier en een sardonix; ");
INSERT INTO nld1939_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","op de derde rij: een hyacint, een agaat en een ametist; ");
INSERT INTO nld1939_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","en op de vierde rij: een chrysoliet, een onyx en een jaspis. Bij het zetten werden ze in gouden zettingen gevat. ");
INSERT INTO nld1939_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Deze stenen beantwoordden aan de namen van Israëls zonen; ze waren evenals hun namen twaalf in getal, en in iedere steen was de naam van één der twaalf stammen gegrift, zoals men een zegel snijdt. ");
INSERT INTO nld1939_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Aan de borsttas maakte men kettinkjes van zuiver goud als koorden gevlochten. ");
INSERT INTO nld1939_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Men vervaardigde ook twee gouden ringen, die men aan de beide boveneinden van de borsttas vasthechtte. ");
INSERT INTO nld1939_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Dan bevestigde men de twee gouden snoeren aan de beide ringen, die aan de boveneinden van de borsttas zaten. ");
INSERT INTO nld1939_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","De beide einden van de twee snoeren maakte men aan de beide zettingen vast, en hechtte ze aan de voorkant der schouderbanden van het borstkleed. ");
INSERT INTO nld1939_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Vervolgens maakte men nog twee gouden ringen, en bevestigde die aan de beide benedeneinden van de borsttas en wel aan de binnenrand, die tegen het borstkleed lag; ");
INSERT INTO nld1939_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","bovendien nog twee gouden ringen, die men onder aan de voorkant van het borstkleed hechtte, boven de band van het borstkleed en vlak bij de sluiting. ");
INSERT INTO nld1939_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Dan bond men de ringen van de borsttas met een purperen snoer aan de ringen van het borstkleed vast, zodat de borsttas boven de band van het borstkleed bleef hangen, en niet op het borstkleed kon verschuiven: zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Hij maakte over het borstkleed een kunstig geweven schoudermantel, geheel van violet. ");
INSERT INTO nld1939_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","De opening van de mantel was in het midden als de hals van een wapenrok, en was rondom gezoomd, zodat ze niet kon inscheuren. ");
INSERT INTO nld1939_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Aan de onderrand van de schoudermantel bracht men violette, purperen en karmozijnen granaatappeltjes aan. ");
INSERT INTO nld1939_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Men maakte belletjes van zuiver goud, en zette die tussen de granaatappeltjes, rond de onderrand van de schoudermantel; ");
INSERT INTO nld1939_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","dus om beurt telkens een belletje en een granaatappeltje rond de onderrand van de schoudermantel, die voor de eredienst was bestemd, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Vervolgens maakte men voor Aäron en zijn zonen de tunieken van lijnwaad, kunstig bewerkt, ");
INSERT INTO nld1939_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","de tulband en de hoofddoeken van lijnwaad, de linnen heupkleren van getwijnd lijnwaad, ");
INSERT INTO nld1939_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","en de kunstig bewerkte gordel van getwijnd lijnwaad, van violet, purper en karmozijn, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Tenslotte vervaardigde men de plaat, de heilige diadeem, van zuiver goud, en men grifte daarin, als in een zegel: Aan Jahweh gewijd. ");
INSERT INTO nld1939_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Met een purperen snoer maakte men ze aan de tulband vast, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Zo werd heel het werk van de tabernakel, de openbaringstent, voltooid en voerden de Israëlieten alles nauwkeurig uit, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Toen brachten zij de tabernakel naar Moses, de Tent met al haar toebehoren, de haken, schotten en bindlatten, en de palen met hun voetstukken; ");
INSERT INTO nld1939_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","het dek van rood geverfde ramsvellen en het dekkleed van gelooide huiden en het afsluittapijt; ");
INSERT INTO nld1939_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","de ark des Verbonds met haar handbomen en het verzoendeksel; ");
INSERT INTO nld1939_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","de tafel met toebehoren en de toonbroden; ");
INSERT INTO nld1939_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","de kandelaar van zuiver goud met zijn lampen er bovenop, met alle benodigdheden en de olie voor de kandelaar; ");
INSERT INTO nld1939_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","het gouden altaar, de zalfolie, de geurige wierook en het tapijt voor de ingang van de Tent; ");
INSERT INTO nld1939_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","het bronzen altaar met zijn bronzen rasterwerk, zijn handbomen en al wat er bij hoort; het wasbekken met zijn onderstel; ");
INSERT INTO nld1939_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","de gordijnen en palen, met hun voetstukken voor de voorhof; het tapijt voor de ingang van de voorhof; de touwen en pinnen, en alles wat er nodig was voor de bouw van de tabernakel, de openbaringstent; ");
INSERT INTO nld1939_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","de ambtsgewaden voor de eredienst in het heiligdom, de heilige gewaden voor den priester Aäron, en de priestergewaden voor zijn zonen. ");
INSERT INTO nld1939_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","De kinderen Israëls hadden alles vervaardigd, juist zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Toen Moses dan ook al het werk had gezien, en het bleek, dat zij alles volgens de bevelen van Jahweh hadden vervaardigd, zegende hij hen. ");
INSERT INTO nld1939_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Toen sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Op de eerste dag van de eerste maand moet ge de tabernakel, de openbaringstent, oprichten, ");
INSERT INTO nld1939_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","de ark des Verbonds daarin plaatsen, en de ark door het voorhangsel aan het oog onttrekken. ");
INSERT INTO nld1939_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Breng dan de tafel naar binnen, leg er op neer, wat er op hoort, zet de kandelaar er in, en ontsteek de lampen; ");
INSERT INTO nld1939_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","plaats het gouden reukofferaltaar voor de ark des Verbonds en hang het tapijt voor de ingang van de tabernakel. ");
INSERT INTO nld1939_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Plaats vervolgens het brandofferaltaar voor de ingang van de tabernakel, de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","zet het bekken neer tussen de openbaringstent en het altaar, en vul het met water. ");
INSERT INTO nld1939_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Richt daar omheen de voorhof op, en hang het tapijt voor de ingang van de voorhof. ");
INSERT INTO nld1939_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Neem dan de zalfolie, zalf de tabernakel en al wat er in is, en wijd hem en alles wat er bij hoort; dan zal hij geheiligd zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Zalf ook het brandofferaltaar en al zijn benodigdheden en wijd het altaar; en het zal hoogheilig zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Zalf ook het bekken met zijn onderstel, en wijd het. ");
INSERT INTO nld1939_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Laat daarna Aäron en zijn zonen voor de ingang van de openbaringstent treden, en was hen met water. ");
INSERT INTO nld1939_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Bekleed dan Aäron met de heilige gewaden, en zalf en wijd hem; dan zal hij mijn priester zijn. ");
INSERT INTO nld1939_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Laat ook zijn zonen toetreden, en bekleed hen met de tunieken. ");
INSERT INTO nld1939_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Zalf hen, zoals gij hun vader hebt gezalfd; dan zullen zij mijn priesters zijn en door deze zalving het priesterschap eeuwig in hun geslacht bezitten. ");
INSERT INTO nld1939_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","En Moses deed alles, juist zoals Jahweh het hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","En in de eerste maand van het tweede jaar, op de eerste dag van de maand, werd de tabernakel opgericht. ");
INSERT INTO nld1939_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses richtte de tabernakel op; hij plaatste de voetstukken, zette de schotten er in, bevestigde de bindlatten, en richtte de palen op; ");
INSERT INTO nld1939_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","hij spande de tent uit over de tabernakel, en legde het tentdek er over heen, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dan nam hij de verbondstafelen, legde ze in de ark, stak de handbomen aan de ark, legde het verzoendeksel op de ark, ");
INSERT INTO nld1939_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","bracht de ark in de tabernakel, hing het voorhangsel op en onttrok zo de ark des Verbonds aan het oog, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Daarna plaatste hij de tafel in de openbaringstent, aan de noordzijde van de tabernakel buiten het voorhangsel, ");
INSERT INTO nld1939_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","schikte daarop de broden voor het aanschijn van Jahweh, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hij plaatste de kandelaar in de openbaringstent tegenover de tafel aan de zuidzijde van de tabernakel, ");
INSERT INTO nld1939_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","en zette de lampen er op voor het aanschijn van Jahweh, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Hij plaatste ook het gouden altaar in de openbaringstent voor het voorhangsel, ");
INSERT INTO nld1939_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","en ontstak daarop de geurige wierook, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Vervolgens hing hij het tapijt voor de ingang van de tabernakel, ");
INSERT INTO nld1939_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","en plaatste het brandofferaltaar aan de ingang van de tabernakel, de openbaringstent, en offerde daarop het brand(-) en spijsoffer, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Het bekken stelde hij tussen de openbaringstent en het altaar, en vulde het met water voor de wassingen; ");
INSERT INTO nld1939_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","en Moses en Aäron en zijn zonen wasten hun handen en voeten er in, ");
INSERT INTO nld1939_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","telkens wanneer zij de openbaringstent binnengingen of tot het altaar naderden, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Rond de tabernakel en het altaar richtte hij de voorhof op, en hing hij een tapijt voor de ingang van de voorhof. Zo voltooide Moses het werk. ");
INSERT INTO nld1939_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Toen bedekte de wolk de openbaringstent en vervulde Jahweh’s Glorie de tabernakel; ");
INSERT INTO nld1939_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","en Moses kon de openbaringstent niet binnengaan, omdat de wolk daarop rustte en Jahweh’s Glorie de tabernakel vervulde. ");
INSERT INTO nld1939_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","En telkens wanneer de wolk zich boven de tabernakel verhief, braken de Israëlieten op, om hun tocht te hervatten; ");
INSERT INTO nld1939_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","maar zolang de wolk zich niet verhief, wachtten zij met het vertrekken tot het ogenblik, dat zij opsteeg. ");
INSERT INTO nld1939_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Want overdag rustte de wolk van Jahweh op de tabernakel, en des nachts was er een vuur in de wolk ten aanschouwen van heel het huis van Israël op al zijn tochten. ");
INSERT INTO nld1939_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Jahweh riep Moses, en sprak uit de openbaringstent tot hem: ");
INSERT INTO nld1939_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Zeg aan de Israëlieten: Wanneer iemand van u aan Jahweh een offergave wil brengen uit het vee, moet gij uw offergave kiezen uit de runderen of het kleinvee. ");
INSERT INTO nld1939_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Wanneer iemand een rund als brandoffer wil opdragen, moet hij een gaaf mannelijk dier offeren. Om het welgevallig aan Jahweh te maken, moet hij het naar de ingang van de openbaringstent brengen, ");
INSERT INTO nld1939_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","en zijn hand op de kop van het brandoffer leggen; dan zal het goedgunstig worden aanvaard, en vergiffenis voor hem verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Daarna moet hij het rund voor het aanschijn van Jahweh slachten; en de zonen van Aäron, de priesters, moeten het bloed opdragen, en daarmee het altaar, dat bij de ingang van de openbaringstent staat, aan alle kanten besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Vervolgens moet hij het brandoffer villen, en in stukken snijden. ");
INSERT INTO nld1939_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","De zonen van Aäron, de priesters, moeten vuur op het altaar leggen, hout op het vuur stapelen, ");
INSERT INTO nld1939_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","en de stukken met de kop en het vet op het hout leggen, dat op het altaarvuur ligt. ");
INSERT INTO nld1939_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Maar de ingewanden met de poten moet hij met water afwassen; dan moet de priester alles tezamen op het altaar in rook doen opgaan. Het is een brandoffer, een welriekend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Wanneer zijn gave voor het brandoffer uit kleinvee bestaat, uit een schaap of een geit, dan moet hij een gaaf mannelijk dier als offergave brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Hij moet het aan de noordzijde van het altaar voor het aanschijn van Jahweh slachten, en de zonen van Aäron, de priesters, moeten het altaar aan alle kanten met het bloed besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Dan moet hij het in stukken snijden, die de priester met de kop en het vet op het hout moet leggen, dat op het altaarvuur ligt. ");
INSERT INTO nld1939_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","De ingewanden met de poten moet hij met water afwassen; dan moet de priester alles tezamen opdragen en op het altaar in rook doen opgaan. Het is een brandoffer, een welriekend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Wanneer hij gevogelte aan Jahweh als brandoffer wil opdragen, moet hij een tortel of een jonge duif als offergave brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","De priester moet die naar het altaar brengen, haar de kop afknijpen en die op het altaar in rook doen opgaan. Haar bloed moet tegen de zijde van het altaar worden uitgeperst. ");
INSERT INTO nld1939_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Haar krop met de veren moet hij verwijderen, en naast het altaar, aan de oostkant, op de ashoop werpen. ");
INSERT INTO nld1939_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Hij moet de vleugels inscheuren zonder ze er helemaal af te trekken. Dan moet de priester haar op het altaar, op het hout boven het vuur, in rook doen opgaan. Het is een brandoffer, een welriekend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Wanneer iemand een meeloffer als gave aan Jahweh wil brengen, moet zijn offergave uit meelbloem bestaan, waarover hij olie moet gieten, en waar hij wierook bij moet voegen. ");
INSERT INTO nld1939_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dit moet hij naar de zonen van Aäron, de priesters, brengen. Dan moet de priester een handvol van dat meel met die olie nemen, en bovendien alle wierook, en het als een reukoffer op het altaar in rook doen opgaan. Het is een welriekend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","De rest van het spijsoffer is als het hoogheilig deel van Jahweh’s vuuroffers voor Aäron en zijn zonen bestemd. ");
INSERT INTO nld1939_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Wanneer ge als spijsoffer ovengebak wilt brengen, dan moeten het ongedesemde koeken zijn van meelbloem met olie gemengd, en ongedesemde vlaas, met olie bestreken. ");
INSERT INTO nld1939_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Indien uw spijsoffer in de pan is gebakken, moet het van ongedesemde meelbloem zijn, met olie gemengd. ");
INSERT INTO nld1939_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Breek het in stukken en giet er olie over heen; het is een spijsoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Indien uw spijsoffer in de pot is gekookt, moet het bereid zijn uit meelbloem met olie. ");
INSERT INTO nld1939_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Als ge het offer, daaruit bereid, aan Jahweh brengt, moet ge het den priester overhandigen, die het op het altaar zal leggen. ");
INSERT INTO nld1939_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","De priester moet het deel van het spijsoffer, dat voor reukoffer bestemd is, als een hefoffer aanbieden en het op het altaar als een welriekend vuuroffer voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","De rest van het spijsoffer is als het hoogheilig deel van Jahweh’s vuuroffers voor Aäron en zijn zonen bestemd. ");
INSERT INTO nld1939_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Geen spijsoffer, dat ge aan Jahweh brengt, mag met zuurdeeg worden bereid, omdat ge van zuurdeeg of honing niets als een vuuroffer voor Jahweh moogt branden; ");
INSERT INTO nld1939_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","enkel als eerstelingenoffer moogt ge ze aan Jahweh brengen, maar als welriekend reukoffer mogen ze niet op het altaar komen. ");
INSERT INTO nld1939_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ook moet ge al uw spijsoffers zouten, en het zout van het verbond van uw God nimmer aan uw spijsoffers laten ontbreken; bij al uw offergaven moet ge dus zout offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Wanneer ge aan Jahweh een spijsoffer van de eerstelingen brengt, moet ge als uw eerstelingenoffer korenaren, met korrels van het nieuwe graan brengen, die in het vuur zijn geroosterd. ");
INSERT INTO nld1939_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ge moet er olie op doen en er wierook aan toevoegen; want het is een spijsoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","De priester moet een deel der korrels met de olie en al de wierook, die voor het reukoffer zijn bestemd, als een vuuroffer voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Wanneer iemand als vredeoffer een rund wil opdragen, een stier of een koe, dan moet hij een gaaf dier aan Jahweh offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Hij moet zijn hand op de kop van zijn offerdier leggen, en het slachten bij de ingang van de openbaringstent; en de zonen van Aäron, de priesters, moeten het altaar aan alle kanten met het bloed besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Van dit vredeoffer moet hij het vet, dat de ingewanden bedekt, als een vuuroffer aan Jahweh opdragen; bovendien al het vet, dat aan de ingewanden vastzit; ");
INSERT INTO nld1939_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","de beide nieren met het vet, dat daaromheen in de lenden zit, en de kwab aan de lever, die hij met de nieren moet wegnemen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","De zonen van Aäron moeten het op het altaar tegelijk met het brandoffer, dat op het hout boven het vuur ligt, als een welriekend vuuroffer voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Wanneer iemand als vredeoffer een stuk kleinvee aan Jahweh wil opdragen, moet hij een gaaf mannetje of wijfje offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Wanneer hij een lam als offergave wil opdragen, moet hij het voor het aanschijn van Jahweh brengen, ");
INSERT INTO nld1939_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","zijn hand op de kop van zijn offerdier leggen, en het voor de openbaringstent slachten; en de zonen van Aäron moeten het altaar aan alle kanten met het bloed besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Van dit vredeoffer moet hij het vet als een vuuroffer aan Jahweh opdragen: al het staartvet, dat hij dicht bij het staartbeen moet afsnijden; het vet, dat de ingewanden bedekt, met al het vet, dat aan de ingewanden vastzit, ");
INSERT INTO nld1939_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","de beide nieren met het vet, dat daaromheen in de lenden zit, en de kwab aan de lever, die hij met de nieren moet wegnemen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","De priester moet het op het altaar als een vuurofferspijs voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Wanneer hij echter een geit wil offeren, dan moet hij ze voor het aanschijn van Jahweh brengen, ");
INSERT INTO nld1939_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","zijn hand op haar kop leggen, en ze voor de openbaringstent slachten; en de zonen van Aäron moeten het altaar aan alle kanten met haar bloed besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Als zijn offergave moet hij daarvan, als een vuuroffer aan Jahweh, het vet opdragen, dat de ingewanden bedekt; bovendien al het vet, dat aan de ingewanden vastzit; ");
INSERT INTO nld1939_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","de beide nieren met het vet, dat daaromheen in de lenden zit, en de kwab aan de lever, die hij met de nieren moet wegnemen. ");
INSERT INTO nld1939_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","De priester moet dat op het altaar in rook doen opgaan als een welriekende vuurofferspijs; al het vet is voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Dit is een altijd geldende wet voor al uw geslachten, overal waar ge woont: nooit moogt ge vet of bloed nuttigen. ");
INSERT INTO nld1939_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Zeg aan de Israëlieten: Wanneer iemand zonder opzet een fout begaat, en iets doet, wat Jahweh verboden heeft, geldt het volgende: ");
INSERT INTO nld1939_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Wanneer de gezalfde priester zondigt, en zo schuld op het volk laadt, moet hij als zondeoffer voor wat hij verkeerd heeft gedaan, een gaven jongen stier aan Jahweh offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Hij moet den stier aan de ingang van de openbaringstent voor het aanschijn van Jahweh brengen, zijn hand op de kop van den stier leggen, en den stier voor het aanschijn van Jahweh slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Vervolgens moet de gezalfde priester wat bloed van den stier nemen, het binnen de openbaringstent brengen, ");
INSERT INTO nld1939_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","zijn vinger in het bloed dopen, en zeven maal voor het aanschijn van Jahweh voor het voorhangsel van het heiligdom wat bloed sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Daarna moet de priester wat van dat bloed aan de hoornen van het reukofferaltaar strijken, dat voor het aanschijn van Jahweh in de openbaringstent staat, en de rest van het bloed van den stier uitstorten tegen het voetstuk van het brandofferaltaar, dat bij de ingang van de openbaringstent staat. ");
INSERT INTO nld1939_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Al het vet van den stier, die als zondeoffer geldt, moet hij eruit nemen: het vet, dat de ingewanden bedekt met al het vet, dat aan de ingewanden vastzit; ");
INSERT INTO nld1939_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","de beide nieren met het vet, dat daaromheen in de lenden zit, en de kwab aan de lever, die hij met de nieren moet wegnemen, ");
INSERT INTO nld1939_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","zoals bij den stier van het vredeoffer geschiedt. De priester moet dat op het brandofferaltaar in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","De huid van den stier met al het vlees, zijn kop, poten en darmen, ");
INSERT INTO nld1939_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","dus de rest van den stier, moet hij buiten de legerplaats naar een reine plek laten brengen, waar de as wordt gestort, en op een houtstapel verbranden; op de plek, waar de as wordt gestort, moet het worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Wanneer heel de gemeenschap van Israël een fout begaat, zonder dat de gemeente het opzettelijk deed, en zij iets hebben gedaan, wat Jahweh verboden heeft, en dus schuldig zijn geworden; ");
INSERT INTO nld1939_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","dan moet de gemeente, zodra ze zich van de overtreding bewust wordt, een stier als zondeoffer opdragen. Zij moeten dien voor de openbaringstent brengen; ");
INSERT INTO nld1939_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","de oudsten van de gemeenschap moeten voor het aanschijn van Jahweh hun handen op de kop van den stier leggen, en den stier voor het aanschijn van Jahweh slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Vervolgens moet de gezalfde priester wat bloed van den stier binnen de openbaringstent brengen; ");
INSERT INTO nld1939_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","de priester moet zijn vinger in het bloed dopen en zeven maal voor het aanschijn van Jahweh voor het voorhangsel sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Daarna moet hij wat van dat bloed aan de hoornen van het altaar strijken, dat voor het aanschijn van Jahweh in de openbaringstent staat, en de rest van het bloed uitstorten tegen het voetstuk van het brandofferaltaar, dat bij de ingang van de openbaringstent staat. ");
INSERT INTO nld1939_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Al het vet moet hij er uitnemen, en op het altaar in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Verder moet hij met den stier doen, zoals hij met den stier van het zondeoffer gedaan heeft. Zo zal de priester verzoening voor hen verkrijgen en zal hun vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hij moet den stier buiten de legerplaats laten brengen en hem verbranden, zoals hij den vorigen stier heeft verbrand. Dit is het zondeoffer voor de gemeente. ");
INSERT INTO nld1939_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Wanneer een stamhoofd een overtreding begaat, en zonder opzet tegen een of ander gebod van Jahweh, zijn God, misdoet, en dus schuld op zich laadt, ");
INSERT INTO nld1939_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","moet hij, zodra hij zich zijn overtreding bewust wordt, een geitebok zonder gebrek als offer opdragen. ");
INSERT INTO nld1939_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Hij moet zijn hand op de kop van den bok leggen en dien slachten op de plaats, waar men voor het aanschijn van Jahweh het brandoffer slacht; het is een zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Vervolgens moet de priester met zijn vinger wat bloed van het zondeoffer nemen, het aan de hoornen van het brandofferaltaar strijken, en het bloed uitstorten tegen het voetstuk van het brandofferaltaar. ");
INSERT INTO nld1939_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Al het vet moet hij op het altaar in rook doen opgaan, zoals met het vet van het vredeoffer geschiedt. Zo zal de priester voor hem verzoening voor zijn zonde verkrijgen, en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Wanneer iemand van het gewone volk zonder opzet een overtreding begaat, door tegen een der geboden van Jahweh te handelen, en dus schuld op zich laadt, ");
INSERT INTO nld1939_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","moet hij, zodra hij zich zijn overtreding bewust wordt, voor zijn begane fout een geit zonder gebrek als offer brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Hij moet zijn hand op de kop van het zondeoffer leggen, en het slachten op de plaats, waar men het brandoffer slacht. ");
INSERT INTO nld1939_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Vervolgens moet de priester met zijn vinger wat van haar bloed nemen, het aan de hoornen van het brandofferaltaar strijken, en de rest van het bloed uitstorten tegen het voetstuk van het altaar. ");
INSERT INTO nld1939_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Al het vet moet hij er uitnemen, zoals met het vet van het vredeoffer geschiedt, en de priester moet het op het altaar in rook doen opgaan als een welriekend offer voor Jahweh. Zo zal de priester verzoening voor hem verkrijgen en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Wanneer iemand voor zijn overtreding een lam wil offeren, moet hij een gaaf ooilam offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Hij moet zijn hand op de kop van het zondeoffer leggen, en het als zondeoffer slachten op de plaats, waar men het brandoffer slacht. ");
INSERT INTO nld1939_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Vervolgens moet de priester met zijn vinger wat van het bloed van het zondeoffer nemen, het aan de hoornen van het brandofferaltaar strijken, en de rest van het bloed uitstorten tegen het voetstuk van het altaar. ");
INSERT INTO nld1939_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Al het vet moet hij er uitnemen, zoals met het vet van het lam voor een vredeoffer geschiedt en de priester moet het op het altaar in rook doen opgaan, tegelijk met de vuuroffers van Jahweh. Zo zal de priester voor hem verzoening voor zijn overtreding verkrijgen en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Wanneer iemand zondigt, door geen verklaring af te leggen, als hij onder bedreiging met vloek wordt opgeroepen, ofschoon hij als getuige kan optreden, omdat hij het zelf heeft gezien of er kennis van heeft gekregen, dan laadt hij schuld op zich. ");
INSERT INTO nld1939_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Of wanneer iemand onbewust iets onreins aanraakt, hetzij het kreng van een onrein wild dier, van een stuk onrein vee of van onrein gedierte, dan is hij toch onrein en laadt hij schuld op zich. ");
INSERT INTO nld1939_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Of wanneer iemand onbewust de onreinheid van een mens aanraakt, wat dan ook, iets, waardoor men onrein wordt, maar het wordt hem later bekend, dan is hij schuldig. ");
INSERT INTO nld1939_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Of wanneer iemand onbewust lichtvaardig zweert iets kwaads of iets goeds te zullen doen, dus al wat een mens ook maar lichtvaardig kan zweren, maar het wordt hem later bekend, dan laadt hij in beide gevallen schuld op zich. ");
INSERT INTO nld1939_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Wanneer hij dan door een dezer dingen schuld op zich heeft geladen, moet hij zijn zonde bekennen, ");
INSERT INTO nld1939_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","en als boete voor de begane misslag als zijn zondeoffer aan Jahweh een wijfje uit het kleinvee offeren, een lam of een geitje. Zo zal de priester voor hem verzoening voor zijn zonde verkrijgen, en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Maar wanneer iemand de kosten voor een stuk kleinvee niet kan opbrengen, moet hij als zijn zondeoffer, voor wat hij misdeed, twee tortels of twee jonge duiven aan Jahweh offeren; de een als zondeoffer, de ander als brandoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Hij moet ze naar den priester brengen, en deze moet eerst de ene offeren, die voor het zondeoffer is bestemd. Hij moet ze de kop vlak bij de nek afknijpen, maar zonder die er helemaal af te trekken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Een weinig bloed van het zondeoffer moet hij tegen de zijde van het altaar sprenkelen, en de rest van het bloed moet tegen het voetstuk van het altaar worden uitgeperst; dit is het zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","De andere moet hij volgens de vastgestelde regels als brandoffer opdragen. Zo zal de priester voor hem verzoening voor zijn zonde verkrijgen, en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","En wanneer iemand ook de kosten voor twee tortels of voor twee jonge duiven niet kan opbrengen, moet hij als zijn zondeoffer, voor hetgeen hij misdeed, een tiende efa meelbloem offeren. Hij mag er geen olie op doen, en geen wierook aan toevoegen; want het is een zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Hij moet het naar den priester brengen; de priester zal er een handvol als reukoffer afnemen, en het tegelijk met de vuuroffers voor Jahweh op het altaar in rook doen opgaan. Dit is het zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Zo zal de priester voor hem verzoening voor zijn zonde verkrijgen, die hij tegen een dezer punten bedreef en zal hem vergiffenis worden geschonken. De rest zal voor den priester zijn, zoals bij het spijsoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wanneer iemand zich vergrijpt en zonder opzet zich iets toeëigent van wat aan Jahweh is gewijd, dan moet hij voor zijn schuld Jahweh de waarde van een gaven ram uit het kleinvee als zijn schuldoffer brengen, geschat in zilveren sikkels volgens het heilige gewicht; ");
INSERT INTO nld1939_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","bovendien moet hij vergoeden wat hij zich van de heilige gaven had toegeëigend, en er nog het vijfde gedeelte aan toevoegen. Dat moet hij aan den priester geven. Zo zal de priester door den ram van het schuldoffer verzoening voor hem verkrijgen, en zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Wanneer iemand onbewust zondigt, en iets doet, wat Jahweh verboden heeft, is hij toch schuldig en moet hij zijn straf dragen. ");
INSERT INTO nld1939_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Hij moet de waarde van een gaven ram uit het kleinvee als een schuldoffer naar den priester brengen. De priester zal verzoening voor hem verkrijgen voor wat hij zonder opzet en onbewust misdeed, en hem zal vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Het is een schuldoffer; want tegenover Jahweh heeft hij een zware schuld op zich geladen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Wanneer iemand zondigt en een vergrijp tegen Jahweh pleegt, door tegenover zijn naaste te loochenen, dat hem iets is toevertrouwd of in bewaring is gegeven, dat iets door hem is geroofd of van zijn naaste afgeperst; ");
INSERT INTO nld1939_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","of door te loochenen, dat hij iets heeft gevonden, wat verloren was; wanneer hij de loochening van een van deze dingen, waarin een mens kan zondigen, met een valse eed bekrachtigt, ");
INSERT INTO nld1939_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","en zo zondigt en schuld op zich laadt, dan moet hij teruggeven, wat geroofd, of afgeperst, of hem toevertrouwd was, of wat verloren was en hij terugvond, ");
INSERT INTO nld1939_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","en waarover hij een valse eed heeft afgelegd. Hij moet het ten volle vergoeden, met een vijfde der waarde erbij, en het op de dag van zijn schuldoffer aan den eigenaar betalen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Bovendien moet hij voor Jahweh de waarde van een gaven ram uit het kleinvee als zijn schuldoffer naar den priester brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Zo zal de priester verzoening voor hem verkrijgen voor het aanschijn van Jahweh, en zal hem vergiffenis worden geschonken voor alles, wat hij misdreven heeft. ");
INSERT INTO nld1939_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Geef aan Aäron en zijn zonen het volgende bevel: Dit is de wet op het brandoffer! Het brandoffer moet heel de nacht door tot aan de morgen op de vuurhaard van het altaar blijven liggen, en het altaarvuur moet daarop blijven branden. ");
INSERT INTO nld1939_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Dan moet de priester zijn linnen tuniek aandoen en over zijn lichaam het linnen heupkleed aantrekken, vervolgens de as wegruimen, waartoe het brandoffer op het altaar door het vuur is verteerd, en die naast het altaar werpen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Dan moet hij zijn kleren uittrekken en andere aandoen, en de as op een reine plek buiten de legerplaats brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Het vuur op het altaar moet brandend blijven, en mag niet worden gedoofd. Iedere ochtend moet de priester daarop hout ontsteken, het brandoffer erop leggen, en de vette stukken van de vredeoffers daarop in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Altijd moet het vuur op het altaar blijven branden; het mag nooit worden gedoofd. ");
INSERT INTO nld1939_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Dit is de wet op het spijsoffer! De zonen van Aäron moeten het voor het aanschijn van Jahweh voor het altaar brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Dan moet een van hen een handvol meelbloem van het spijsoffer nemen en iets van de daarbij horende olie, met al de wierook, die bij het spijsoffer hoort, en het op het altaar als een welriekend reukoffer voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","De rest moeten Aäron en zijn zonen opeten. Ongedesemd moet het op een heilige plaats worden gegeten in de voorhof van de openbaringstent; ");
INSERT INTO nld1939_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","het mag dus niet gedesemd worden gebakken. Ik sta hun dit af als hun deel van mijn vuuroffers; het is hoogheilig, evenals het zonde(-) en schuldoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Alle kinderen van Aäron, die van het mannelijk geslacht zijn, mogen het eten. Het is voor uw nageslacht een eeuwig geldende wet met betrekking tot de vuuroffers van Jahweh: al wie ze aanraakt, moet als iets heiligs worden behandeld. ");
INSERT INTO nld1939_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Dit is de offergave, die Aäron en zijn zonen Jahweh moeten brengen, wanneer zij worden gezalfd. Als dagelijks spijsoffer moeten zij een tiende efa meelbloem brengen; de ene helft des morgens, de andere helft des avonds. ");
INSERT INTO nld1939_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","In een pan moet het met olie worden toebereid, ge moet het aangemaakt brengen; daarna moet ge het in stukken breken, en als een welriekend spijsoffer Jahweh aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Degene onder zijn zonen, die als zijn opvolger tot priester wordt gezalfd, moet dat doen; dit is een eeuwig geldende wet. Het moet geheel voor Jahweh in rook opgaan; ");
INSERT INTO nld1939_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","want elk spijsoffer van een priester moet helemaal worden verbrand, en niets mag ervan worden genuttigd. ");
INSERT INTO nld1939_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Zeg aan Aäron en zijn zonen: Dit is de wet op het zondeoffer! Op de plaats, waar het brandoffer wordt geslacht, moet ook het zondeoffer voor het aanschijn van Jahweh worden geslacht; het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","De priester, die het zondeoffer opdraagt, moet het ook nuttigen. Op een heilige plaats in de voorhof van de openbaringstent moet het worden gegeten. ");
INSERT INTO nld1939_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Iedereen, die het vlees ervan aanraakt, zal als iets heiligs worden behandeld; en wanneer iets van het bloed op een kleed spat, moet ge het bespatte kleed op een heilige plaats wassen. ");
INSERT INTO nld1939_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Wanneer het in een aarden vat is gekookt, moet dit worden gebroken; wanneer het in een bronzen vat is gekookt, moet dit worden geschuurd en met water uitgespoeld. ");
INSERT INTO nld1939_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Alle mannen onder de priesters mogen het eten; het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Maar een zondeoffer, waarvan het bloed binnen de openbaringstent is gebracht, om er in het heiligdom de verzoeningsplechtigheid mee te verrichten, mag niet worden gegeten; dit moet in het vuur worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Dit is de wet op het schuldoffer: het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Op de plaats, waar men het brandoffer slacht, moet men ook het schuldoffer slachten; en de priester moet het altaar aan alle kanten met zijn bloed besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Alle vetdelen ervan moet hij offeren: het staartvet met het vet, dat de ingewanden bedekt; ");
INSERT INTO nld1939_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","de beide nieren met het vet, dat daaromheen in de lenden zit; de kwab aan de lever, die met de nieren moet worden weggenomen. ");
INSERT INTO nld1939_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","De priester moet het op het altaar in rook doen opgaan als een vuuroffer voor Jahweh; het is een schuldoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alle mannen onder de priesters mogen het eten; op een heilige plaats moet het worden genuttigd; want het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Voor het zonde(-) en het schuldoffer geldt dezelfde wet; het zal den priester behoren, die er de verzoeningsplechtigheid mee verricht. ");
INSERT INTO nld1939_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ook de huid van iemands brandoffer is voor den priester, die het opdraagt. ");
INSERT INTO nld1939_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Elk spijsoffer, dat in de oven is gebakken of in een pot of pan is bereid, komt den priester toe, die het opdraagt. ");
INSERT INTO nld1939_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Maar op alle andere spijsoffers, hetzij ze met olie zijn gemengd of droog zijn, hebben alle zonen van Aäron evenveel recht. ");
INSERT INTO nld1939_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Dit is de wet op de vredeoffers, die men aan Jahweh opdraagt. ");
INSERT INTO nld1939_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Wanneer iemand zijn gave uit dankbaarheid brengt, moet hij bij het dankoffer ongedesemde koeken voegen, gemengd met olie, ongedesemde vlaas met olie bestreken, en meelbloem met olie aangemaakt. ");
INSERT INTO nld1939_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Bij zijn vredeoffer uit dankbaarheid moet hij koeken van gedesemd brood als offergave voegen. ");
INSERT INTO nld1939_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Van al deze soorten van offergaven moet hij Jahweh één stuk als hefoffer brengen; het zal voor den priester zijn, die het bloed van het vredeoffer sprenkelt. ");
INSERT INTO nld1939_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Het vlees van zijn vredeoffer uit dankbaarheid gebracht moet op de dag, dat het geofferd wordt, worden gegeten; niets daarvan mag tot de volgende morgen worden bewaard. ");
INSERT INTO nld1939_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Wanneer iemand een slachtoffer als geloftegave of als vrijwillige gave brengt, dan moet wel het slachtoffer op de dag van de offerande worden genuttigd; maar wat overblijft mag ook de volgende dag nog worden gegeten; ");
INSERT INTO nld1939_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","wat op de derde dag nog over is van het offervlees, moet in het vuur worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Wanneer op de derde dag nog van het vlees van het vredeoffer wordt gegeten, komt het hem, die het heeft gebracht, niet ten goede, en wordt het hem niet toegerekend; integendeel dan is het onrein, en iedereen, die ervan eet, belaadt zich met schuld. ");
INSERT INTO nld1939_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ook als het vlees met iets onreins in aanraking komt, mag het niet meer worden gegeten, maar moet het worden verbrand. Iedereen, die rein is, mag het vlees van het vredeoffer eten. ");
INSERT INTO nld1939_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Maar iedereen, die het vlees van het vredeoffer van Jahweh eet, terwijl hij onrein is, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Eveneens zal iedereen, die iets onreins heeft aangeraakt, iets onreins van een mens of onrein vee of welk onrein gedierte ook, en die toch van het vlees van het vredeoffer van Jahweh eet, van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Zeg aan de Israëlieten: Het vet van een rund, van een schaap of geit moogt ge niet eten; ");
INSERT INTO nld1939_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","het vet van een gestorven of verscheurd dier mag voor alles worden gebruikt, maar ge moogt het niet eten. ");
INSERT INTO nld1939_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Want iedereen, die het vet van runderen eet, die men als vuuroffers aan Jahweh kan brengen, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Waar ge ook woont, nooit moogt ge bloed nuttigen, noch van vogels noch van viervoetige dieren; ");
INSERT INTO nld1939_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","iedereen, die bloed nuttigt, van welk beest ook, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Zeg aan de Israëlieten: Wie Jahweh een vredeoffer brengt, moet zelf zijn gave van dat vredeoffer Jahweh opdragen. ");
INSERT INTO nld1939_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Met eigen handen moet hij de vuuroffers van Jahweh, het vet met de borst opdragen; de borst om ze als strekoffer voor het aanschijn van Jahweh aan te bieden, ");
INSERT INTO nld1939_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","terwijl de priester het vet op het altaar in rook moet doen opgaan. De borst valt dan Aäron en zijn zonen ten deel. ");
INSERT INTO nld1939_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","De rechterschenkel van uw vredeoffer moet ge als hefoffer aan den priester geven. ");
INSERT INTO nld1939_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Wie van Aärons zonen het bloed en het vet van het vredeoffer heeft opgedragen, ontvangt de rechterschenkel als zijn deel. ");
INSERT INTO nld1939_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Want de borst, die als strekoffer en de schenkel, die als hefoffer wordt gebracht, neem Ik van het vredeoffer der Israëlieten af, om ze den priester Aäron en zijn zonen te geven als het deel, dat de Israëlieten hun steeds moeten afstaan. ");
INSERT INTO nld1939_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dit is dus het deel van Jahweh’s vuuroffers, dat Jahweh voor Aäron en zijn zonen heeft bestemd op de dag, dat Hij hen deed aantreden, om zijn priesters te zijn, ");
INSERT INTO nld1939_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","en dat, zoals Jahweh op de dag van hun zalving bevolen heeft, de Israëlieten aan hen moeten afstaan. Het is een eeuwig geldend recht voor hun nageslacht. ");
INSERT INTO nld1939_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dit is dus de wet op de brand(-) en spijsoffers, op de zonde(-) en schuldoffers, op de wijdings(-) en vredeoffers, ");
INSERT INTO nld1939_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","die Jahweh op de berg Sinaï aan Moses heeft voorgeschreven op de dag, dat Hij hem beval, dat de kinderen Israëls in de woestijn van de Sinaï hun offergaven aan Jahweh zouden brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Neem Aäron en zijn zonen met de gewaden, de zalfolie, den stier van het zondeoffer, de twee rammen, de korf met ongedesemde broden, ");
INSERT INTO nld1939_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","en roep de hele gemeenschap bij de ingang van de openbaringstent tezamen. ");
INSERT INTO nld1939_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses deed, wat Jahweh hem had bevolen. En toen het volk aan de ingang van de openbaringstent bijeen was gekomen, ");
INSERT INTO nld1939_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","sprak Moses tot het verzamelde volk: Dit heeft Jahweh bevolen te doen. ");
INSERT INTO nld1939_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Toen liet Moses Aäron en zijn zonen toetreden, en waste hen met water. ");
INSERT INTO nld1939_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Vervolgens trok hij Aäron de tuniek aan, deed hem de gordel om, bekleedde hem met de schoudermantel, sloeg hem het borstkleed om, omgordde hem met de gordel van het borstkleed, en bond het daarmee vast. ");
INSERT INTO nld1939_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hij hing hem de borsttas om, en legde in de borsttas de Oerim en de Toemmim; ");
INSERT INTO nld1939_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","hij zette hem de tulband op, en bevestigde van voren aan de tulband de gouden plaat, de heilige diadeem, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Daarna nam Moses de zalfolie, en zalfde de tabernakel met al wat daarin was, om het te wijden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Hij besprenkelde daarmee zeven maal het altaar, en zalfde het altaar met toebehoren en het wasbekken met zijn onderstel, om ze te wijden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ook op het hoofd van Aäron goot hij een weinig zalfolie uit, en zalfde hem, om hem te wijden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Nu liet Moses de zonen van Aäron naderbij komen. Hij bekleedde ze met de tuniek, legde ze de gordel aan, en bond ze de hoofddoeken om, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Vervolgens liet hij den stier van het zondeoffer voorbrengen; en Aäron en zijn zonen legden hun handen op de kop van den stier van het zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Daarna liet Moses hem slachten, nam het bloed, streek het met zijn vinger aan de hoornen langs alle kanten van het altaar, en nam zo de onreinheid van het altaar weg. De rest van het bloed goot hij uit aan de voet van het altaar. Zo wijdde hij het, door de verzoeningsplechtigheid er aan te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Nu nam Moses al het vet, dat aan de ingewanden zat, de kwab aan de lever, de beide nieren met haar vet, en deed het op het altaar in rook opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Den stier zelf met huid, vlees en darmen, verbrandde hij buiten de legerplaats, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Vervolgens liet hij den ram van het brandoffer brengen; en Aäron en zijn zonen legden hun handen op de kop van den ram. ");
INSERT INTO nld1939_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Daarna liet Moses hem slachten, besprenkelde het altaar aan alle kanten met het bloed, sneed den ram aan stukken en deed de kop, de stukken en het vet in rook opgaan, ");
INSERT INTO nld1939_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","- ");
INSERT INTO nld1939_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","met ingewanden en poten, na die eerst met water te hebben gewassen. Zo deed Moses den helen ram op het altaar in rook opgaan. Het was een welriekend brandoffer, een vuuroffer voor Jahweh, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Vervolgens liet hij den tweeden ram voorbrengen, die voor het wijdingsoffer was bestemd; en Aäron en zijn zonen legden hun handen op de kop van den ram. ");
INSERT INTO nld1939_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Daarna deed Moses hem slachten, nam wat van zijn bloed, en streek het aan de rechteroorlel van Aäron, aan zijn rechterduim en aan de grote teen van zijn rechtervoet; ");
INSERT INTO nld1939_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","daarna liet Moses de zonen van Aäron naderbij komen, en streek eveneens een weinig bloed aan hun rechteroorlel, aan hun rechterduim en aan de grote teen van hun rechtervoet. Met de rest van het bloed besprenkelde hij aan alle kanten het altaar. ");
INSERT INTO nld1939_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nu nam hij het vet, het staartvet en al het vet, dat aan de ingewanden zit, de kwab aan de lever, de beide nieren met haar vet en de rechterschenkel; ");
INSERT INTO nld1939_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","en uit de korf met ongedesemde broden, die voor het aanschijn van Jahweh stond, nam hij een ongedesemde koek, een met olie bereide broodkoek en een vla, en schikte ze op de vette stukken en de rechterschenkel. ");
INSERT INTO nld1939_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Dat alles legde hij in de handen van Aäron en in die van zijn zonen, en liet het als een strekoffer voor het aanschijn van Jahweh aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Toen nam Moses het weer uit hun handen, en deed het op het altaar tegelijk met het brandoffer in rook opgaan; dit was het welriekend wijdingsoffer, het vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Daarna nam Moses het borststuk, en bood het als een strekoffer voor het aanschijn van Jahweh aan; dit was het deel van den wijdingsram, dat Moses toekwam, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Tenslotte nam Moses een weinig zalfolie en wat bloed, dat aan het altaar zat, en besprenkelde Aäron en zijn gewaden ermee, evenals zijn zonen met hun gewaden. Zo wijdde hij Aäron met zijn gewaden en zijn zonen met hun gewaden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Toen sprak Moses tot Aäron en zijn zonen: Kookt het vlees aan de ingang van de openbaringstent, en eet het daar met het brood, dat in de korf van het wijdingsoffer ligt; want mij is bevolen. dat Aäron en zijn zonen het moeten eten. ");
INSERT INTO nld1939_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Wat er overblijft van het vlees en het brood, moet ge in het vuur verbranden. ");
INSERT INTO nld1939_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Zeven dagen lang moogt ge u niet van de ingang van de openbaringstent verwijderen, totdat de dagen van uw wijding zijn verstreken; want zeven dagen zal uw wijding duren. ");
INSERT INTO nld1939_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Zoals men het heden gedaan heeft, heeft Jahweh het ook voor de toekomst bevolen, om de verzoeningsplechtigheden aan u te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Blijft dus dag en nacht aan de ingang van de openbaringstent zeven dagen lang, en onderhoudt de voorschriften van Jahweh, opdat ge niet sterft; want zo is het mij bevolen. ");
INSERT INTO nld1939_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","En Aäron en zijn zonen deden alles, wat Jahweh door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Op de achtste dag riep Moses Aäron met zijn zonen en de oudsten van Israël, ");
INSERT INTO nld1939_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","en sprak tot Aäron: Neem een kalf, het jong van een rund, voor een zondeoffer, en een ram voor een brandoffer, beide zonder gebrek, en breng ze voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","En tot de Israëlieten moet ge zeggen: “Neemt een bok voor een zondeoffer, met een kalf en een schaap, beide een jaar oud en zonder gebrek, voor een brandoffer; ");
INSERT INTO nld1939_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","verder een stier met een ram, om ze voor Jahweh’s aanschijn te slachten als vredeoffer; en tenslotte een spijsoffer met olie gemengd. Want heden zal Jahweh u verschijnen.” ");
INSERT INTO nld1939_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Men bracht dus, wat Moses bevolen had, voor de openbaringstent en heel de gemeenschap trad naderbij, en plaatste zich voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Toen sprak Moses: Dit heeft Jahweh u bevolen te doen, opdat de glorie van Jahweh u moge verschijnen. ");
INSERT INTO nld1939_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","En tot Aäron zei Moses: Treed nader tot het altaar, en draag uw zonde(-) en brandoffer op, om verzoening voor uzelf en voor het volk te verkrijgen; breng dan de gave van het volk en verkrijg verzoening voor hen, zoals Jahweh het heeft bevolen. ");
INSERT INTO nld1939_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Nu trad Aäron op het altaar toe, en slachtte het kalf, dat het zondeoffer voor hem zelf was. ");
INSERT INTO nld1939_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","De zonen van Aäron brachten hem het bloed; hij doopte er zijn vinger in, streek het aan de hoornen van het altaar, en goot de rest van het bloed tegen het voetstuk van het altaar uit. ");
INSERT INTO nld1939_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Het vet van het zondeoffer, met de nieren en de kwab aan de lever, deed hij op het altaar in rook opgaan, zoals Jahweh het Moses bevolen had; ");
INSERT INTO nld1939_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","het vlees en de huid verbrandde hij buiten de legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Vervolgens slachtte hij het brandoffer. De zonen van Aäron reikten hem het bloed, en hij sprenkelde het aan alle kanten tegen het altaar. ");
INSERT INTO nld1939_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Dan reikten ze hem het brandoffer aan, in stukken gesneden, met de kop erbij, en hij deed het op het altaar in rook opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","De ingewanden en de poten waste hij, en deed ze tezamen met het brandoffer op het altaar in rook opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Daarna liet hij de offergave van het volk brengen. Hij nam den bok van het zondeoffer van het volk, slachtte en offerde hem als zondeoffer, zoals den vorige. ");
INSERT INTO nld1939_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hij droeg ook het brandoffer op, en deed ermee, zoals was voorgeschreven. ");
INSERT INTO nld1939_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Toen liet hij ook het spijsoffer brengen, nam er een handvol af en deed het op het altaar in rook opgaan, onverminderd het morgenoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Vervolgens slachtte hij den stier en den ram, als vredeoffer voor het volk. De zonen van Aäron reikten hem het bloed, en hij sprenkelde het aan alle kanten tegen het altaar. ");
INSERT INTO nld1939_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","De vette stukken van den stier en den ram: het staartvet, het vet, dat de ingewanden bedekt, de nieren, de kwab aan de lever, ");
INSERT INTO nld1939_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","legde hij bij de borststukken, en deed die vette stukken op het altaar in rook opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Maar de borststukken en de rechterschenkel bood Aäron als een strekoffer aan voor het aanschijn van Jahweh, zoals Moses het bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","En nadat Aäron de zonde(-), brand(-) en vredeoffers had opgedragen, strekte hij zijn handen uit over het volk en zegende het. Daarna daalde hij af. ");
INSERT INTO nld1939_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Nu gingen Moses en Aäron de openbaringstent binnen. En zodra zij weer naar buiten waren gekomen en het volk hadden gezegend, verscheen aan heel het volk de heerlijkheid van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","En een vuur schoot uit het aanschijn van Jahweh, dat het brandoffer met de vette stukken op het altaar verteerde. Toen het ganse volk dat zag, brak het los in gejubel en viel op zijn aangezicht neer. ");
INSERT INTO nld1939_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab en Abihoe, zonen van Aäron, namen beiden hun wierookvat, deden daar vuur in, en legden er wierook op. Maar zij offerden voor Jahweh’s aanschijn onwettig vuur, tegen zijn voorschriften in. ");
INSERT INTO nld1939_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Toen schoot er vuur uit het aanschijn van Jahweh, dat hen verteerde; zo stierven zij voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Toen zei Moses tot Aäron: Zo spreekt Jahweh! Door wie Mij naderen, wil Ik als heilig worden erkend, En ten aanschouwen van heel het volk wil Ik worden geëerd. Terwijl Aäron stom bleef van schrik, ");
INSERT INTO nld1939_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","riep Moses Misjaël en Elsafan, de zonen van Oezziël, den oom van Aäron, en beval hun: Komt hier, en draagt uw broeders het heiligdom uit en buiten de legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Zij traden toe, om hen in hun tunieken buiten de legerplaats te brengen, zoals Moses gezegd had. ");
INSERT INTO nld1939_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Tot Aäron en zijn zonen Elazar en Itamar zei Moses: Bindt uw haren niet los en scheurt uw klederen niet; anders sterft gij, en barst zijn toorn los tegen heel de gemeenschap. Uw broeders, het hele huis van Israël, mogen de brand bewenen, die Jahweh ontstak; ");
INSERT INTO nld1939_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","maar gij moogt op straffe des doods u niet van de ingang van de openbaringstent verwijderen; want nog rust de zalfolie van Jahweh op u. En zij deden, wat Moses beval. ");
INSERT INTO nld1939_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Jahweh sprak tot Aäron: ");
INSERT INTO nld1939_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Gij noch uw zonen, moogt wijn drinken of sterke drank, wanneer ge de openbaringstent binnen moet gaan: anders sterft ge. Dit is een altijd geldende wet voor uw nageslacht. ");
INSERT INTO nld1939_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Zo moet ge onderscheid maken tussen het heilige en het profane, het onreine en het reine, ");
INSERT INTO nld1939_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","om de Israëlieten alle wetten te leren, die Jahweh door Moses heeft afgekondigd. ");
INSERT INTO nld1939_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","En Moses sprak tot Aäron en zijn nog levende zonen Elazar en Itamar: Neemt het spijsoffer, dat van Jahweh’s vuuroffers is overgebleven, en eet het ongedesemd naast het altaar; want het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ge moet het op een heilige plaats eten; want het is het deel van Jahweh’s vuuroffers, dat u en uw zonen is toegestaan. Zo is het mij bevolen. ");
INSERT INTO nld1939_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Maar het borststuk van het strekoffer en de schenkel van het hefoffer moogt ge met uw zonen en dochters op iedere reine plaats nuttigen; want dit is het deel, dat de kinderen Israëls voor u en uw zonen van hun vredeoffers moeten afstaan. ");
INSERT INTO nld1939_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ze moeten dus de schenkel van het hefoffer en het borststuk van het strekoffer tegelijk met de vette stukken van de vuuroffers brengen, om ze als een strekoffer voor het aanschijn van Jahweh aan te bieden. Dit is het deel, dat u en uw zonen voor altijd toekomt, zoals Jahweh het bevolen heeft. ");
INSERT INTO nld1939_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Toen Moses een onderzoek instelde naar den bok van het zondeoffer, en het bleek, dat deze verbrand was, werd hij vertoornd op Elazar en Itamar, de nog levende zonen van Aäron, en zeide: ");
INSERT INTO nld1939_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Waarom hebt ge het zondeoffer niet op een heilige plaats genuttigd; want het is hoogheilig, en Hij heeft het u gegeven, om de gemeenschap van haar schuld te ontslaan en verzoening voor hen te verkrijgen voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ziet het bloed is niet binnen het heiligdom gebracht; daarom hadt ge het op een heilige plaats moeten opeten, zoals ik het bevolen heb. ");
INSERT INTO nld1939_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aäron gaf Moses ten antwoord: Zie, ze hebben vandaag hun zonde(-) en brandoffers voor Jahweh gebracht, terwijl ik zo zwaar getroffen ben. Als ik heden van een zondeoffer had gegeten, zou dat Jahweh wel hebben behaagd? ");
INSERT INTO nld1939_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Toen Moses dit hoorde, was hij tevreden gesteld. ");
INSERT INTO nld1939_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Zegt aan de Israëlieten: Van alle viervoetige dieren, die op aarde zijn, moogt ge deze eten: ");
INSERT INTO nld1939_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alle viervoetige dieren, die volledig gespleten hoeven hebben, en tevens herkauwers zijn, moogt ge eten. ");
INSERT INTO nld1939_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Maar van de dieren, die herkauwen of gespleten hoeven hebben, moogt ge de volgende niet eten. De kameel, want hij is wel herkauwend, maar heeft geen volledig gespleten hoeven; hij is voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","De klipdas, want hij is wel herkauwend, maar heeft geen gespleten hoeven; hij is voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","De haas, want hij is wel herkauwend, maar heeft geen gespleten hoeven; hij is voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Het zwijn, want het heeft wel volledig gespleten hoeven, maar het herkauwt niet; het is voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Van hun vlees moogt ge niet eten, en hun krengen niet aanraken; zij zijn voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Van alles wat in het water leeft, moogt ge het volgende eten: alles wat in het water leeft, in zeeën of rivieren, en vinnen en schubben heeft, moogt ge eten. ");
INSERT INTO nld1939_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Maar alles, wat in het water leeft, in zeeën of rivieren, doch geen vinnen en schubben heeft, moet een gruwel voor u zijn: zowel het kleine watergewemel als alle grote waterdieren. ");
INSERT INTO nld1939_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ze moeten een gruwel voor u zijn; van hun vlees moogt ge niet eten, en hun krengen moet ge verfoeien. ");
INSERT INTO nld1939_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alles, wat in het water leeft en geen vinnen en schubben heeft, moet een gruwel voor u zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Van de gevleugelde dieren moet ge de volgende verfoeien; omdat ze een gruwel zijn, mogen ze niet worden gegeten: de arend, de lammergier en de aasgier, ");
INSERT INTO nld1939_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","de wouw en de verschillende soorten valken; ");
INSERT INTO nld1939_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","alle soorten raven, ");
INSERT INTO nld1939_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","de struisvogel, de sperwer, de meeuw, en de verschillende soorten haviken; ");
INSERT INTO nld1939_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","de steenuil, de pelikaan, de velduil, ");
INSERT INTO nld1939_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","de nachtuil, de reiger en de stinkgier; ");
INSERT INTO nld1939_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","de ooievaar, de verschillende soorten kraanvogels, de specht en de vleermuis. ");
INSERT INTO nld1939_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ook de gevleugelde insekten, die vier poten hebben, moeten u een gruwel zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Slechts die gevleugelde insekten met vier poten moogt ge eten, die behalve hun poten nog springpoten hebben, om daarmee over de grond te springen. ");
INSERT INTO nld1939_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ge moogt dus daarvan eten de verschillende soorten sprinkhanen; de veelvraat in verschillende soorten, de langpoot in verschillende soorten, en de knaagbek in verschillende soorten. ");
INSERT INTO nld1939_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Overigens moeten alle gevleugelde insekten, die vier poten hebben, u een gruwel zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ge verontreinigt u aan de volgende dieren. ");
INSERT INTO nld1939_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","- ");
INSERT INTO nld1939_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Alle viervoetige dieren, die geen volledig gespleten hoeven hebben en niet herkauwen, zijn voor u onrein; wie ze aanraakt, is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ook alle teengangers onder de viervoeters zijn voor u onrein. Wie hun kreng aanraakt, is tot de avond onrein; ");
INSERT INTO nld1939_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","en wie hun kreng opneemt, moet zijn kleren wassen, en is tot de avond onrein; want zij zijn voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Van het ongedierte, dat over de grond scharrelt, zijn de volgende voor u onrein: de wezel, de muis en de verschillende soorten hagedissen; ");
INSERT INTO nld1939_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","de veldmuis, de mol, de salamander, de muurhagedis en de kameleon. ");
INSERT INTO nld1939_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Deze zijn onder het ongedierte voor u onrein. Wie ze aanraakt, als ze dood zijn, is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Daarenboven is alles, waarop een van die dieren valt, wanneer het dood is, onrein. Elk houten voorwerp, een kleed, een stuk leer, een zak, elk werktuig, waarmee men arbeid verricht, moet in het water worden gelegd, en is tot de avond onrein; eerst daarna wordt het weer rein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Valt een van die beesten in een aarden vat, dan is de inhoud onrein, en het vat zelf moet worden verbrijzeld. ");
INSERT INTO nld1939_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Elke eetbare spijs, waarop water komt uit zulk een vat, is onrein, en elke drank, die genoten kan worden, wordt in zulk een vat onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Alles, waarop zulk een dood dier valt, is onrein. Een bakoven of een haard moeten worden stukgeslagen; ze zijn onrein, en moeten door u als onrein worden beschouwd. ");
INSERT INTO nld1939_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Alleen bronnen en regenbakken, waar zich het water vergaart, blijven rein; maar wie hun kreng, dat er in ligt, aanraakt, is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Wanneer het kreng van die dieren op zaaikoren valt, dat gezaaid moet worden, wat voor soort dit ook is, dan blijft dat rein; ");
INSERT INTO nld1939_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","maar wordt er water op dat koren gedaan, en valt er dan zulk een kreng op, dan is het voor u onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Wanneer een van de dieren, die u tot voedsel dienen, is dood gegaan, dan is hij, die het kreng ervan aanraakt, tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","En wie ervan eet, moet zijn kleren wassen, en is tot de avond onrein; ook wie het opneemt, moet zijn kleren wassen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Alle ongedierte, dat over de grond scharrelt, is een gruwel; het mag niet worden gegeten. ");
INSERT INTO nld1939_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Van het ongedierte, dat over de grond scharrelt, hetzij het kruipt op de buik, hetzij het vier of meer poten heeft, moogt ge niets eten; want het is verfoeilijk. ");
INSERT INTO nld1939_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Bezoedelt u dus niet en verontreinigt u niet door iets van dat kruipend gedierte, waardoor ge onrein wordt. ");
INSERT INTO nld1939_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Want Ik, Jahweh, ben uw God! Gedraagt u dus heilig, en weest heilig, omdat Ik heilig ben. Verontreinigt u niet door al het ongedierte, dat over de grond kruipt; ");
INSERT INTO nld1939_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","want Ik ben Jahweh, die u uit Egypte heb geleid, om uw God te zijn. Weest heilig, omdat Ik heilig ben. ");
INSERT INTO nld1939_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Dit is de wet op de viervoetige dieren, de gevleugelde dieren, alle levende wezens, die in het water wemelen, en alle beesten, die over de grond kruipen; ");
INSERT INTO nld1939_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ter onderscheiding van onrein en rein, van dieren, die gegeten mogen worden, en dieren die ge niet moogt eten. ");
INSERT INTO nld1939_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Zeg aan de Israëlieten: Wanneer een vrouw baart en een jongen krijgt, is zij zeven dagen onrein, even onrein als zij is tijdens haar stonden. ");
INSERT INTO nld1939_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Op de achtste dag moet haar zoon worden besneden. ");
INSERT INTO nld1939_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Daarna moet zij nog drie en dertig dagen in het bloed blijven, waarvan zij gereinigd moet worden; niets heiligs mag zij aanraken noch in het heiligdom komen, eer de dagen van haar reiniging zijn verstreken. ");
INSERT INTO nld1939_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Als ze een meisje krijgt, is ze veertien dagen even onrein als tijdens haar stonden; daarna moet ze nog zes en zestig dagen blijven in het bloed, waarvan ze gereinigd moet worden. ");
INSERT INTO nld1939_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Wanneer de dagen van haar reiniging, nodig voor een zoon of dochter, zijn verstreken, moet zij een eenjarig lam als brandoffer en een jonge duif of een tortel als zondeoffer naar den priester brengen bij de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Deze zal ze voor het aanschijn van Jahweh brengen en voor haar verzoening verkrijgen; zo zal zij van haar bloedvloeiing worden gereinigd. Dit is de wet voor de vrouw, die een jongen of een meisje heeft gebaard. ");
INSERT INTO nld1939_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Zo ze geen schaap kan bekostigen, moet ze twee tortels of twee jonge duiven nemen; de een voor het brandoffer, de ander voor het zondeoffer. En de priester zal verzoening voor haar verkrijgen en zo zal ze worden gereinigd. ");
INSERT INTO nld1939_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wanneer iemand op zijn huid een roof, uitslag of witte vlek krijgt, die zich op zijn huid tot een melaatse plek ontwikkelt, dan moet hij naar den priester Aäron of naar een van de priesters, zijn zonen, worden gebracht. ");
INSERT INTO nld1939_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","De priester moet de plek op zijn huid onderzoeken. Is het haar op die plek wit geworden, en ligt die plek opvallend dieper dan de huid, dan is het melaatsheid. Wanneer de priester dit ziet, moet hij hem onrein verklaren. ");
INSERT INTO nld1939_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Zo het echter een witte vlek op zijn huid is, die niet opvallend dieper ligt dan de huid, en het haar daarop niet wit is geworden, dan moet de priester den lijder zeven dagen lang opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Wanneer de priester hem op de zevende dag weer onderzoekt en bemerkt, dat de plek onveranderd is gebleven en zich niet verder over de huid heeft verspreid, dan moet de priester hem opnieuw zeven dagen lang opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","De priester moet hem op de zevende dag nog eens onderzoeken; en ziet hij, dat de plek dof is geworden en zich niet verder over de huid heeft verspreid, dan moet de priester hem rein verklaren; het is enkel maar uitslag. Hij moet zijn kleren wassen, en is dan rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Maar zo de uitslag zich verder over zijn huid verspreidt, nadat hij zich reeds aan den priester heeft vertoond, om rein te worden verklaard, dan moet hij zich opnieuw door den priester laten onderzoeken. ");
INSERT INTO nld1939_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ziet de priester, dat de uitslag zich verder over zijn huid heeft verspreid, dan moet de priester hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wanneer iemand een melaatse plek heeft, moet hij naar den priester worden gebracht. ");
INSERT INTO nld1939_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ziet de priester, dat er op de huid een witte roof zit, het haar daarop wit is geworden, en er wild vlees in die roof groeit, ");
INSERT INTO nld1939_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","dan is het een verouderde melaatsheid op de huid. De priester moet hem onrein verklaren zonder hem eerst nog op te sluiten; want hij is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wanneer de melaatsheid op zijn huid openbarst, en de melaatsheid heel de huid van den lijder van het hoofd tot de voeten bedekt, zover de priester kan nagaan, ");
INSERT INTO nld1939_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","en ziet de priester, dat de melaatsheid heel zijn lichaam bedekt, dan moet hij den lijder rein verklaren, als hij geheel wit is geworden; hij is rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Maar als zich wild vlees bij hem vertoont, is hij onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Heeft dus de priester het wilde vlees bemerkt, dan moet hij hem onrein verklaren; het wilde vlees is onrein; het is melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Wanneer echter het wilde vlees weer verdwijnt en hij wit wordt, dan moet hij naar den priester gaan. ");
INSERT INTO nld1939_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ziet nu de priester, dat die plek wit is geworden, dan moet hij den lijder rein verklaren; hij is rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Wanneer iemand een zweer op zijn huid heeft, die wel is genezen, ");
INSERT INTO nld1939_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","maar op wier plaats een witte roof of lichtrode vlek is ontstaan, dan moet hij zich aan den priester vertonen. ");
INSERT INTO nld1939_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Bemerkt de priester, dat deze vlek opvallend dieper ligt dan de huid, en dat het haar daarop wit is, dan moet de priester hem voor onrein verklaren; het is melaatsheid, die in de zweer is uitgebroken. ");
INSERT INTO nld1939_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Maar wanneer de priester ziet, dat er geen witte haren op zitten, dat ze niet dieper ligt dan de huid en dof is, dan moet de priester hem zeven dagen opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Indien de plek zich verder over de huid verspreidt, dan moet de priester hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Zo de plek onveranderd is gebleven, en zich niet verder heeft verspreid, dan is het een litteken van de zweer; de priester moet hem dan rein verklaren. ");
INSERT INTO nld1939_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Of wanneer iemand op zijn huid een brandwonde heeft, en er vormt zich in die brandwonde een lichtrode of witte vlek, ");
INSERT INTO nld1939_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","dan moet de priester ze onderzoeken; en is op die vlek het haar wit geworden, ligt ze opvallend dieper dan de huid, dan is in die wond melaatsheid uitgebroken; de priester moet hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Maar zo de priester bemerkt, dat zich op die vlek geen wit haar bevindt, dat ze niet dieper ligt dan de huid en dof is, dan moet de priester hem zeven dagen lang opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Op de zevende dag moet de priester hem onderzoeken. Zo de plek zich over de huid heeft verspreid, moet de priester hem onrein verklaren; het is melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Maar zo de witte vlek onveranderd is gebleven, zich niet verder over de huid heeft verspreid en dof is geworden, dan is het een roof van de brandwonde; de priester moet hem dan rein verklaren, want het is het litteken van de brandwonde. ");
INSERT INTO nld1939_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wanneer een man of een vrouw een plek heeft op het hoofd of in de baard, ");
INSERT INTO nld1939_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","dan moet de priester die plek onderzoeken. Ligt deze opvallend dieper dan de huid en is het haar daarop geel en dun, dan moet de priester hem onrein verklaren; het is een kwaadaardige uitslag, melaatsheid van hoofd of baard. ");
INSERT INTO nld1939_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Maar wanneer de priester bemerkt, dat de plek, door de uitslag aangetast, niet opvallend dieper ligt dan de huid, maar er toch ook geen zwart haar op zit, dan moet de priester den lijder aan de uitslag zeven dagen lang opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Op de zevende dag moet hij de aangetaste plek opnieuw onderzoeken. Heeft de uitslag zich niet uitgebreid, is er geen geel haar op gekomen, en ligt de uitslag niet opvallend dieper dan de huid, ");
INSERT INTO nld1939_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","dan moet de lijder aan uitslag zich scheren, behalve op de plek van de uitslag, en de priester moet hem nogmaals zeven dagen opsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Op de zevende dag moet de priester de uitslag opnieuw onderzoeken. Heeft de uitslag zich niet verder over de huid verspreid en ligt hij niet opvallend dieper dan de huid, dan moet de priester hem rein verklaren. Hij moet zijn kleren wassen, en is rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Maar zo de uitslag zich verder over de huid heeft verspreid, nadat hij zich reeds aan den priester heeft vertoond, om rein te worden verklaard, ");
INSERT INTO nld1939_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","en bemerkt de priester, dat de uitslag zich werkelijk verder over de huid heeft verspreid, dan behoeft de priester niet verder te zoeken naar het gele haar; hij is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Wanneer echter de uitslag onveranderd is gebleven en er zwart haar op groeit, dan is de uitslag genezen; hij is rein, en de priester moet hem rein verklaren. ");
INSERT INTO nld1939_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wanneer een man of een vrouw witte vlekken op hun huid hebben, ");
INSERT INTO nld1939_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","dan moet de priester ze onderzoeken. Zijn die vlekken op hun huid dofwit, dan is het slechts een goedaardige uitslag, die op de huid is uitgebroken; ze zijn rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Wanneer iemand de haren op zijn hoofd verliest, dan is hij alleen maar een kaalhoofd; hij is rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Verliest hij zijn haren van voren, dan heeft hij alleen maar een kaal voorhoofd; hij is rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Maar zo hij op zijn kaal voor(-) of achterhoofd een vaalrode plek heeft, dan is dat melaatsheid, die op zijn kaal voor(-) of achterhoofd is uitgebroken. ");
INSERT INTO nld1939_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","De priester moet hem onderzoeken. Is de roof van die plek op zijn kaal voor(-) of achterhoofd lichtrood, en ziet ze er uit als de melaatsheid van de huid, ");
INSERT INTO nld1939_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","dan is hij melaats; hij is onrein. De priester moet hem onrein verklaren; hij heeft melaatsheid op zijn hoofd. ");
INSERT INTO nld1939_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wie door melaatsheid is getroffen, moet met gescheurde kleren gaan, het hoofd onbedekt, zijn bovenlip omwonden, en hij moet roepen: Onrein, onrein! ");
INSERT INTO nld1939_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Zo lang hij melaats blijft, is hij volslagen onrein: hij moet afgezonderd wonen, en buiten de legerplaats verblijven. ");
INSERT INTO nld1939_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Wanneer de melaatsheid zich op een wollen of linnen kledingstuk vertoont, ");
INSERT INTO nld1939_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","op geweven of geknoopte stof van linnen of wol, op leer of op een of ander ding van leer: ");
INSERT INTO nld1939_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","en die plek op dat kleed of dat leer, op die geweven of geknoopte stof of op een of ander ding van leer, is groen(-) of roodachtig, dan is die plek melaats, en moet aan den priester worden getoond. ");
INSERT INTO nld1939_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","De priester moet die plek onderzoeken, en het besmette zeven dagen lang wegsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Op de zevende dag moet hij de plek opnieuw onderzoeken. Heeft deze plek zich op het kledingstuk, op de geweven of geknoopte stof, op het leer of op een of ander ding van leer verder verspreid, dan is het kwaadaardige melaatsheid; het besmette is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hij moet het kleed, de geweven of geknoopte stof van wol of linnen, of het een of ander ding van leer, waarop de plek zit, verbranden. Want het is kwaadaardige melaatsheid; het ding moet in het vuur worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Maar zo de priester bemerkt, dat de plek zich op het kleed, de geweven of geknoopte stof, of op een of ander ding van leer niet verder heeft uitgebreid, ");
INSERT INTO nld1939_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","dan moet de priester bevelen, het ding, waarop de plek zit, te wassen en het opnieuw zeven dagen lang wegsluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ziet de priester, dat de plek na de wassing van het besmette ding, niet is veranderd, dan is het onrein; ook al heeft die plek zich niet uitgebreid. Ge moet het verbranden; het is een voortkankerende melaatsheid aan de achter(-) of voorkant. ");
INSERT INTO nld1939_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ziet de priester, dat de besmette plek na de wassing dof is geworden, dan moet hij ze van het kleed, van het leer of van de geweven of geknoopte stof afscheuren. ");
INSERT INTO nld1939_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Verschijnt ze opnieuw op het kleed, op de geweven of geknoopte stof, of op een of ander leren ding, dan is het uitbarstende melaatsheid. Gij moet het ding, waarop de plek zit, verbranden. ");
INSERT INTO nld1939_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Maar het kleed, de geweven of geknoopte stof of het een of ander ding van leer, waaruit de plek na wassing is verdwenen, moet opnieuw worden gewassen; dan is het rein. ");
INSERT INTO nld1939_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Dit is de wet op de melaatsheid van een wollen of linnen kleed, van geweven of geknoopte stof of van een of ander ding van leer. Ze dient om iets rein of onrein te verklaren. ");
INSERT INTO nld1939_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dit is de wet op den melaatse. Op de dag van zijn reinverklaring moet hij voor den priester worden gebracht, ");
INSERT INTO nld1939_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","die zich buiten de legerplaats moet begeven. Ziet de priester, dat de melaatse van zijn melaatsheid is genezen, ");
INSERT INTO nld1939_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","dan moet hij voor hem, die rein verklaard moet worden, twee levende reine vogels laten halen met cederhout, karmozijn en hysop. ");
INSERT INTO nld1939_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","De priester moet een der vogels boven een aarden vat met levend water laten slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Vervolgens moet hij de levende vogel nemen; bovendien het cederhout, het karmozijn en de hysop, en die met de levende vogel in het bloed dopen van de vogel, die boven het levend water is geslacht. ");
INSERT INTO nld1939_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Hiermee moet hij zeven maal hem besprenkelen, die van de melaatsheid gereinigd moet worden. Zo reinigt hij hem. Daarna moet hij de levende vogel in het vrije veld loslaten. ");
INSERT INTO nld1939_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Vervolgens moet hij, die gereinigd werd, nog zijn kleren wassen, al zijn haar afscheren, en zich baden; dan is hij rein, en mag hij in de legerplaats komen. Maar hij moet nog zeven dagen lang buiten zijn tent blijven. ");
INSERT INTO nld1939_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Op de zevende dag moet hij al zijn haar afscheren, zijn hoofdhaar, zijn baard en zijn wenkbrauwen; al zijn haar moet hij wegscheren, zijn kleren wassen en zijn lichaam baden; dan is hij rein. ");
INSERT INTO nld1939_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Op de achtste dag moet hij twee gave lammeren nemen en een eenjarig ooilam zonder gebrek; verder drie issaron meelbloem met olie gemengd voor het spijsoffer, en bovendien één log olie. ");
INSERT INTO nld1939_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","De priester, die de reiniging voltrekt, zal hem, die rein verklaard moet worden, met die gaven voor Jahweh’s aanschijn plaatsen aan de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nu moet de priester een van de lammeren nemen, en dit met de log olie als schuldoffer opdragen, en ze als een strekoffer voor het aanschijn van Jahweh aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Dan moet hij het lam slachten op de heilige plaats, waar men het zonde(-) en brandoffer slacht; want dit schuldoffer komt evenals het zondeoffer den priester toe; het is hoogheilig. ");
INSERT INTO nld1939_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Daarna moet de priester wat bloed van het schuldoffer nemen, en het hem, die rein moet worden verklaard op de rechteroorlel strijken, op de rechterduim en op de grote teen van zijn rechtervoet. ");
INSERT INTO nld1939_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Vervolgens moet de priester iets van de log olie nemen, op zijn eigen linker handpalm gieten, ");
INSERT INTO nld1939_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","de vinger van zijn rechterhand in de olie dopen, die op zijn linkerhand ligt, en een weinig van die olie met zijn vinger zeven maal voor het aanschijn van Jahweh sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Van de rest van de olie, die op zijn hand ligt, moet de priester iets op de rechteroorlel, op de rechterduim en op de grote teen van de rechtervoet strijken van hem, die rein verklaard moet worden, en wel bovenop het bloed van het schuldoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Wat dan nog over is van de olie, die op zijn hand ligt, moet de priester op het hoofd uitstorten van hem, die rein verklaard moet worden; zo zal de priester verzoening voor hem verkrijgen voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Vervolgens moet de priester het zondeoffer opdragen, en voor hem, die gereinigd moet worden, verzoening verkrijgen van de onreinheid. Tenslotte moet de priester het brandoffer slachten, ");
INSERT INTO nld1939_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","en het op het altaar met het spijsoffer opdragen. Zo zal de priester voor hem verzoening verkrijgen, en is hij rein. ");
INSERT INTO nld1939_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Wanneer hij te arm is en die kosten niet kan betalen, behoeft hij maar één lam te nemen voor het schuldoffer om het als strekoffer aan te bieden en voor zich verzoening te verkrijgen; bovendien een issaron meelbloem met olie gemengd voor het spijsoffer en een log olie. ");
INSERT INTO nld1939_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Verder twee tortels of twee jonge duiven, naar gelang hij kan betalen; de ene voor het zondeoffer, de andere voor het brandoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Op de achtste dag moet hij ze voor zijn reiniging naar den priester brengen bij de ingang van de openbaringstent, voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nu moet de priester het lam voor het schuldoffer nemen met de log olie, en ze voor het aanschijn van Jahweh als een strekoffer aanbieden; ");
INSERT INTO nld1939_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","en het lam voor het schuldoffer slachten. Daarna moet de priester wat bloed van dat schuldoffer nemen, het hem, die gereinigd moet worden, op de rechteroorlel strijken, op zijn rechterduim en op de grote teen van zijn rechtervoet. ");
INSERT INTO nld1939_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Vervolgens moet de priester wat van de olie op zijn eigen linker handpalm gieten, ");
INSERT INTO nld1939_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","en met zijn rechtervinger zeven maal een weinig van de olie, die op zijn linkerhand ligt, voor het aanschijn van Jahweh sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Van de rest van de olie, die op zijn hand ligt, moet de priester hem, die gereinigd moet worden, iets op de rechteroorlel strijken, op zijn rechterduim en op de grote teen van zijn rechtervoet, en wel boven op het bloed van het schuldoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Wat er dan nog over is van de olie, die op de hand van den priester ligt, moet hij op het hoofd van hem, die gereinigd moet worden, uitstorten om voor het aanschijn van Jahweh verzoening te verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Vervolgens moet hij een van de tortels of een van de jonge duiven, die hij kon betalen, ");
INSERT INTO nld1939_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","als zondeoffer, en de andere als brandoffer opdragen tegelijk met het spijsoffer. Zo zal de priester voor het aanschijn van Jahweh verzoening verkrijgen voor hem, die gereinigd moet worden. ");
INSERT INTO nld1939_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Dit is de wet voor hem, die door de melaatsheid werd getroffen, en de onkosten van zijn reiniging niet kan betalen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wanneer gij in het land Kanaän komt, dat Ik u in bezit zal geven, en Ik op uw grondgebied een huis met melaatsheid sla, ");
INSERT INTO nld1939_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","dan moet de eigenaar van het huis den priester gaan zeggen: Er is iets in mijn huis, dat op melaatsheid lijkt. ");
INSERT INTO nld1939_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","En nog voor hij de ziekte komt onderzoeken, zal de priester bevelen, het huis te ontruimen, opdat niet al wat in het huis is, onrein wordt. Daarna zal de priester het huis gaan bezichtigen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Bemerkt hij nu, dat de ziekte werkelijk in de wanden van het huis zit, en er groene of roodachtige kuiltjes in zijn, die opvallend dieper liggen dan het muurvlak, ");
INSERT INTO nld1939_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","dan moet de priester het huis verlaten, zich naar de deur van het huis begeven, en het huis zeven dagen lang sluiten. ");
INSERT INTO nld1939_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Op de zevende dag moet de priester terugkomen. Bemerkt hij nu, dat de ziekte zich verder over de wanden van het huis heeft verspreid, ");
INSERT INTO nld1939_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","dan moet hij gelasten, de stenen weg te breken waarin de ziekte zit, en die buiten de stad op een onreine plaats te werpen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Vervolgens moet men het huis van binnen aan alle kanten afkrabben, en het afgekrabde leem buiten de stad op een onreine plaats werpen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Daarna moet men andere stenen nemen en ze in de plaats van die stenen zetten, en andere leem, om daarmee het huis te bestrijken. ");
INSERT INTO nld1939_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Wanneer na het wegbreken der stenen en het afkrabben en het bepleisteren van het huis de ziekte opnieuw in het huis uitbreekt, ");
INSERT INTO nld1939_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","dan moet de priester nog eens komen. Bemerkt hij nu, dat de ziekte zich verder in het huis heeft verspreid, dan is er kwaadaardige melaatsheid in het huis; het is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Men moet het huis afbreken, en de stenen, de balken en al het leemwerk van het huis buiten de stad naar een onreine plaats brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Wie het huis binnengaat al de tijd, dat men het gesloten heeft, is tot de avond onrein, ");
INSERT INTO nld1939_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","en wie in het huis slaapt, of er in eet, moet zijn kleren wassen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Maar wanneer de priester bij zijn komst bemerkt, dat de ziekte, nadat men het huis opnieuw heeft bepleisterd, zich niet verder daarin heeft verspreid, dan moet de priester het huis rein verklaren; want dan is de ziekte genezen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Om de smet van het huis weg te nemen, moet hij twee vogels nemen, met cederhout, karmozijn en hysop. ");
INSERT INTO nld1939_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Een der vogels moet hij boven een aarden vat met levend water slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Vervolgens moet hij het cederhout nemen, de hysop met het karmozijn en de levende vogel, ze in het bloed van de geslachte vogel en in het levende water dompelen, en er zeven maal het huis mee besprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Zo moet hij de smet van het huis wegnemen door het bloed van de vogel, door het levend water, door de levende vogel, door het cederhout, de hysop en het karmozijn. ");
INSERT INTO nld1939_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","De levende vogel moet hij buiten de stad in het vrije veld loslaten. Zo zal hij voor het huis de verzoeningsplechtigheid verrichten, en wordt het weer rein. ");
INSERT INTO nld1939_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Dit is de wet op alle soorten van melaatsheid en kwaadaardige uitslag, ");
INSERT INTO nld1939_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","op de melaatsheid in kleren en huizen, ");
INSERT INTO nld1939_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","op roof, uitslag en witte vlekken; ");
INSERT INTO nld1939_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ze dient om te leren, wanneer iets onrein is of rein. Dit is de wet op de melaatsheid. ");
INSERT INTO nld1939_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Zegt tot de kinderen Israëls: Wanneer een man aan ziekelijke vloeiing lijdt uit zijn vlees, dan is dat vocht onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","En het is voor zijn onreinheid bij zijn vloeiing gelijk, of zijn vlees het vocht laat lopen of niet; hij is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ieder bed, waarop zulk een lijder gaat liggen, en alles waarop hij gaat zitten, is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Wie zijn bed aanraakt, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","En wie ergens op gaat zitten, waarop zulk een lijder heeft gezeten, moet eveneens zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ook wie het lichaam van zulk een lijder aanraakt, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Wanneer iemand, die aan vloeiing lijdt, op een ander spuwt, die rein is, dan moet die ander zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Elk zadel, waarop zulk een lijder rijdt, is onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Iedereen, die iets aanraakt, wat onder hem is geweest, is tot de avond onrein; en wie het draagt, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Wanneer zulk een lijder een ander aanraakt, zonder zijn handen te hebben afgespoeld, dan moet de ander zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Een aarden vat, dat de lijder aanraakt, moet worden gebroken, en elk houten vat met water worden afgespoeld. ");
INSERT INTO nld1939_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Wanneer zulk een lijder weer van zijn kwaal is genezen, moet hij nog zeven dagen wachten, eer hij rein is; daarna moet hij zijn kleren wassen en zich in stromend water baden; dan is hij rein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Op de achtste dag moet hij twee tortels of twee jonge duiven nemen, voor het aanschijn van Jahweh bij de ingang van de openbaringstent komen, en ze aan den priester geven. ");
INSERT INTO nld1939_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","De priester moet ze offeren; de een als zonde(-), de ander als brandoffer. Zo zal de priester voor hem verzoening verkrijgen voor het aanschijn van Jahweh, en is hij bevrijd van zijn kwaal. ");
INSERT INTO nld1939_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Wanneer een man een uitstorting heeft gehad, moet hij heel zijn lichaam baden, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Elk kledingstuk en leren voorwerp, dat er door wordt bezoedeld, moet worden gewassen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Wanneer een man gemeenschap met een vrouw heeft gehad, moeten beiden een bad nemen, en zijn tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wanneer een vrouw haar stonden heeft, verkeert zij zeven dagen in staat van onreinheid. Wie haar aanraakt, is tot de avond onrein; ");
INSERT INTO nld1939_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","alles waarop zij in die toestand gaat liggen of zitten, wordt onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Wie haar bed aanraakt, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein; ");
INSERT INTO nld1939_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","wie iets aanraakt, waarop zij heeft gezeten, moet zijn kleren wassen, een bad nemen en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Zelfs wie iets aanraakt, dat op het bed heeft gelegen, of op iets waarop zij heeft gezeten, is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Wanneer een man gemeenschap met haar houdt en door haar wordt bezoedeld, is hij zeven dagen onrein, en elk bed, waarop hij ligt, wordt onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wanneer de vrouw buiten de tijd van haar stonden langere tijd aan vloeiing lijdt, of haar stonden langer dan gewoonlijk duren, dan is zij al die tijd even onrein als tijdens haar stonden. ");
INSERT INTO nld1939_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Voor elk bed, waarop zij al de tijd van haar kwaal gaat liggen, zal hetzelfde gelden als voor het bed van haar stonden; en alles, waarop zij gaat zitten, zal even onrein zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wie iets ervan aanraakt, zal onrein zijn; hij moet zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wanneer zij van haar kwaal is genezen, moet ze nog zeven dagen wachten, eer ze weer rein is. ");
INSERT INTO nld1939_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Op de achtste dag moet zij twee tortels of twee jonge duiven nemen, en die naar den priester bij de ingang van de openbaringstent brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","De priester moet de een als zonde(-), de ander als brandoffer opdragen; zo zal de priester voor haar verzoening verkrijgen voor het aanschijn van Jahweh, en is zij bevrijd van haar onreine kwaal. ");
INSERT INTO nld1939_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Vermaant dus de kinderen Israëls, zich voor onreinheid te hoeden, opdat zij niet wegens hun onreinheid sterven, door mijn tabernakel, dat te midden van hen staat, te bezoedelen. ");
INSERT INTO nld1939_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dit is de wet voor hem, die aan vloeiing lijdt, of uitstorting heeft, waardoor hij onrein wordt; ");
INSERT INTO nld1939_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ook voor haar, die door haar stonden onrein is. Ze geldt zowel voor den man als de vrouw, die aan vloeiing lijdt en voor iedereen, die gemeenschap heeft met de onreine. ");
INSERT INTO nld1939_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Na de dood van de twee zonen van Aäron, die waren gestorven, toen zij voor het aanschijn van Jahweh wilden naderen, sprak Jahweh tot Moses, ");
INSERT INTO nld1939_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","en zeide tot hem: Zeg uw broeder Aäron, dat hij niet ten allen tijde in het heiligdom mag komen achter het voorhangsel en voor het verzoendeksel, dat op de ark ligt; anders zal hij sterven. Want Ik verschijn in de wolk boven het verzoendeksel. ");
INSERT INTO nld1939_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Slechts dan mag Aäron binnen het heiligdom komen, wanneer een jonge stier als zondeoffer en een ram als brandoffer is opgedragen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Hij moet de heilige tuniek van lijnwaad aantrekken, de linnen heupkleren om zijn lichaam dragen, de linnen gordel omdoen, en zijn hoofd met de linnen tulband omwikkelen. Dit zijn de heilige gewaden. Hij moet ze aantrekken na eerst zijn lichaam met water te hebben gewassen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Van de gemeenschap der Israëlieten moet hij twee bokken nemen voor een zondeoffer, en één ram voor een brandoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Dan moet Aäron den stier, die voor zijn eigen zondeoffer is bestemd, opdragen, om voor zichzelf en zijn huis verzoening te verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Vervolgens moet hij de twee bokken nemen, ze voor het aanschijn van Jahweh aan de ingang van de openbaringstent plaatsen, ");
INSERT INTO nld1939_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","en over de beide bokken het lot werpen: één lot voor Jahweh, één lot voor Azazel. ");
INSERT INTO nld1939_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Den bok, waarop het lot voor Jahweh valt, moet hij vóór laten brengen en als zondeoffer opdragen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Den bok, waarop het lot voor Azazel valt, moet hij levend voor het aanschijn van Jahweh plaatsen, om de verzoeningsplechtigheid aan hem te verrichten, en hem dan de woestijn in te jagen naar Azazel. ");
INSERT INTO nld1939_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Vervolgens moet Aäron den stier, die voor zijn zondeoffer bestemd is, vóór doen brengen, verzoening voor zich en zijn huis verkrijgen, en den stier als zijn eigen zondeoffer slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Daarna moet hij een pan vol gloeiende kolen van het altaar, dat voor het aanschijn van Jahweh staat, met twee volle handen fijne geurige wierook nemen, die achter het voorhangsel brengen, ");
INSERT INTO nld1939_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","en de wierook voor Jahweh’s aanschijn op het vuur leggen, zodat de wierookwolken het verzoendeksel boven de wettafelen omhullen; anders zou hij sterven. ");
INSERT INTO nld1939_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Dan moet hij wat bloed van den stier nemen, dat met zijn vinger aan de voorkant op het verzoendeksel en zevenmaal vóór het verzoendeksel sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Daarna moet hij den bok slachten, die voor het zondeoffer van het volk is bestemd, zijn bloed achter het voorhangsel brengen, en daarmee handelen als met het bloed van den stier: het dus op en vóór het verzoendeksel sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Zo moet hij voor het heiligdom de verzoeningsplechtigheid verrichten en het zuiveren van alle onreinheden en overtredingen der Israëlieten, welke hun zonden ook zijn. Vervolgens moet hij hetzelfde doen met de openbaringstent, die bij hen te midden van hun onreinheden staat. ");
INSERT INTO nld1939_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Niemand mag in de openbaringstent aanwezig zijn, van het ogenblik af, dat hij er binnentreedt, om in het heiligdom de verzoeningsplechtigheid te verrichten, totdat hij ze weer verlaat. ");
INSERT INTO nld1939_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Vervolgens moet hij naar buiten gaan naar het altaar, dat voor het aanschijn van Jahweh staat, om ook daarvoor de verzoeningsplechtigheid te verrichten. Hij moet wat bloed van den stier en van den bok nemen, daarmee de hoornen van het altaar aan alle kanten bestrijken, ");
INSERT INTO nld1939_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","en met zijn vinger zeven maal wat bloed daarop sprenkelen. Zo zal hij het zuiveren van de onreinheden der Israëlieten en het weer heiligen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Wanneer hij de verzoeningsplechtigheid voor het heiligdom, de openbaringstent en het altaar heeft beëindigd, moet hij den levenden bok voor laten brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aäron moet zijn beide handen op de kop van den levenden bok leggen, over hem de belijdenis van de misdaden en overtredingen der Israëlieten uitspreken, wat hun zonden ook zijn, ze op de kop van den bok leggen en hem door iemand, die daarvoor is aangewezen, de woestijn in laten jagen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Deze moet den bok in de woestijn loslaten, en de bok zal al hun zonden naar de wildernis dragen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Vervolgens moet Aäron de openbaringstent binnengaan, de linnen gewaden uittrekken, waarmee hij zich had bekleed, toen hij het heiligdom binnentrad, ze daar weer neerleggen, ");
INSERT INTO nld1939_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","zich op een heilige plaats wassen, en zijn eigen kleren weer aandoen. Dan moet hij naar buiten gaan, en zijn eigen brandoffer en dat voor het volk opdragen. Zo moet hij voor zichzelf en het volk verzoening verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Het vet van het zondeoffer moet hij op het altaar in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Hij, die den bok voor Azazel heeft weggebracht, moet zijn kleren wassen en zich baden; dan eerst mag hij in de legerplaats komen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Den stier en den bok van het zondeoffer, wier bloed binnen het heiligdom is gebracht, om verzoening te verkrijgen, moet men buiten de legerplaats brengen, en hun huid, hun vlees en de darmen moet men verbranden. ");
INSERT INTO nld1939_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Die ze verbrand heeft, moet zijn kleren wassen en een bad nemen; dan eerst mag hij in de legerplaats komen. ");
INSERT INTO nld1939_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Dit is voor u een eeuwig geldende wet: Op de tiende dag van de zevende maand moet ge boete doen en u van alle arbeid onthouden; dit geldt zowel voor den ingezetene als den vreemdeling, die in uw midden woont. ");
INSERT INTO nld1939_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Want op die dag zal men de verzoeningsplechtigheid voor u verrichten, om u te reinigen, en zult ge van al uw zonden voor het aanschijn van Jahweh worden bevrijd. ");
INSERT INTO nld1939_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Het moet voor u een volkomen rustdag zijn, waarop ge boete moet doen; dit is een eeuwig geldende wet. ");
INSERT INTO nld1939_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","De priester, dien men zal zalven en als opvolger van zijn vader tot priester zal aanstellen, moet de verzoeningsplechtigheid verrichten. Bekleed met de heilige linnen gewaden, ");
INSERT INTO nld1939_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","moet hij de verzoeningsplechtigheid verrichten voor het heilige der heiligen, voor de openbaringstent, voor het altaar, en eveneens voor de priesters en voor heel de gemeente van het volk. ");
INSERT INTO nld1939_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Dit moet voor u een eeuwig geldende wet zijn, om eenmaal per jaar voor Israëls kinderen verzoening te verkrijgen en kwijtschelding van hun zonden. En Aäron deed, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Beveel Aäron en zijn zonen en alle Israëlieten, en zeg hun: Dit heeft Jahweh bevolen: ");
INSERT INTO nld1939_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Iedereen van Israëls huis, die een stier, een lam of een geit in of buiten de legerplaats slacht, ");
INSERT INTO nld1939_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","en ze niet bij bij de ingang van de openbaringstent brengt om voor de woning van Jahweh een gave aan Jahweh op te dragen, zal het als bloedschuld worden aangerekend; die man heeft bloed vergoten, en zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Daarom moeten de kinderen Israëls hun slachtoffers, die zij gewoon zijn in het open veld te slachten, voor Jahweh naar den priester brengen bij de ingang van de openbaringstent, en als vredeoffers voor Jahweh slachten. ");
INSERT INTO nld1939_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","En de priester moet het bloed op het altaar van Jahweh bij de ingang van de openbaringstent sprenkelen, en het vet als een heerlijk geurend offer voor Jahweh in rook doen opgaan. ");
INSERT INTO nld1939_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ze mogen dus hun offers niet meer voor de bosgeesten slachten, die zij ontuchtig achterna lopen. Dit is voor hen een eeuwig geldende wet van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ge moet hun dus zeggen: Iedereen van Israëls huis en van de vreemdelingen in uw midden, die een brand(-) of slachtoffer opdraagt, ");
INSERT INTO nld1939_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","en het niet naar de openbaringstent brengt, om het Jahweh te offeren, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Iedereen uit het huis van Israël of van de vreemdelingen in uw midden, die enig bloed nuttigt, zal Ik om het nuttigen van dat bloed mijn gramschap doen voelen en hem van zijn volk afsnijden. ");
INSERT INTO nld1939_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Want in het bloed zit het leven van een schepsel. Daarom heb Ik het u enkel voor het altaar gegeven, om voor u verzoening te verkrijgen; want het bloed verkrijgt verzoening door het leven. ");
INSERT INTO nld1939_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Daarom zeg Ik tot de kinderen Israëls: Niemand van u mag bloed nuttigen; ook de vreemdeling niet, die in uw midden woont. ");
INSERT INTO nld1939_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Iedereen van de Israëlieten en van de vreemden in uw midden, die wild of gevogelte heeft gejaagd, dat gegeten mag worden, moet het bloed uitgieten en met aarde bedekken. ");
INSERT INTO nld1939_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Want het leven van elk schepsel zit in zijn bloed. Daarom herhaal Ik tot de Israëlieten: Van geen enkel schepsel moogt ge het bloed nuttigen; want het leven van ieder schepsel zit in zijn bloed. Iedereen, die het nuttigt, zal worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Iedereen, zowel de ingezetene als de vreemde, die een gestorven of een verscheurd dier eet, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein; daarna is hij weer rein. ");
INSERT INTO nld1939_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Als hij zijn kleren niet wast en geen bad neemt, begaat hij een zonde. ");
INSERT INTO nld1939_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Beveel de kinderen Israëls, en zeg hun: Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Gij moogt u niet gedragen naar de zeden van Egypte, waar gij gewoond hebt, noch naar die van Kanaän, waar Ik u heenvoer; naar hun zeden moogt ge niet leven. ");
INSERT INTO nld1939_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mijn wetten moet ge volbrengen, mijn voorschriften onderhouden, en uw gedrag daarnaar richten. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Onderhoudt dus mijn voorschriften en mijn wetten. De mens, die ze volbrengt, zal daardoor het leven behouden. Ik ben Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niemand van u mag zijn naasten bloedverwant naderen, om er gemeenschap mee te houden. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Gij moogt geen gemeenschap houden met uw vader, evenmin met uw moeder; want zij is uw moeder; met haar moogt gij dus geen gemeenschap hebben. ");
INSERT INTO nld1939_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ge moogt geen gemeenschap houden met de vrouw van uw vader; want dan onteert ge uw vader. ");
INSERT INTO nld1939_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ge moogt geen gemeenschap houden met uw zuster, de dochter van uw vader of die van uw moeder, onverschillig of zij in of buiten uw familie geboren is. ");
INSERT INTO nld1939_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ge moogt geen gemeenschap houden met de dochter van uw zoon of met die van uw dochter; want dan onteert ge uzelf. ");
INSERT INTO nld1939_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Gij moogt geen gemeenschap houden met de dochter van uws vaders vrouw, die door uw vader is verwekt; zij geldt voor uw zuster; houd geen gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Gij moogt geen gemeenschap houden met de zuster van uw vader; zij is de naaste bloedverwant van uw vader. ");
INSERT INTO nld1939_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Gij moogt geen gemeenschap houden met de zuster van uw moeder; want zij is de naaste bloedverwant van uw moeder. ");
INSERT INTO nld1939_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Gij moogt geen gemeenschap houden met den broeder van uw vader. Ook zijn vrouw moogt ge niet naderen; zij is uw tante. ");
INSERT INTO nld1939_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Gij moogt geen gemeenschap houden met uw schoondochter; zij is de vrouw van uw zoon; houd geen gemeenschap met haar. ");
INSERT INTO nld1939_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Gij moogt geen gemeenschap houden met de vrouw van uw broer; want dan onteert ge uw broer. ");
INSERT INTO nld1939_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ge moogt geen gemeenschap houden met een vrouw en tegelijk met haar dochter; evenmin moogt ge de dochter van haar zoon of die van haar dochter nemen, om gemeenschap met haar te houden; ze zijn uw bloedverwanten; zo iets is een schanddaad. ");
INSERT INTO nld1939_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Gij moogt geen vrouw als bijvrouw naast haar zuster nemen, om ook met haar gemeenschap te houden, terwijl de andere nog leeft. ");
INSERT INTO nld1939_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Gij moogt een vrouw, die door haar stonden onrein is, niet naderen, om gemeenschap met haar te houden. ");
INSERT INTO nld1939_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Gij moogt niet slapen bij de vrouw van uw naaste; daardoor verontreinigt gij u. ");
INSERT INTO nld1939_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Geen van uw kinderen zult ge afstaan, om ze aan den Molok te wijden; want ge moogt de naam van uw God niet ontheiligen. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Gij moogt niet bij een man liggen als bij een vrouw, dit is een gruweldaad. ");
INSERT INTO nld1939_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Gij moogt geen enkel dier misbruiken; daardoor bezoedelt ge u. Ook zal geen vrouw zich door een dier laten schenden; dit is tegennatuurlijke ontucht. ");
INSERT INTO nld1939_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Bezoedelt u dus niet door dit alles. Want door al deze dingen zijn de volken besmeurd, die Ik voor u zal uitdrijven; ");
INSERT INTO nld1939_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","zo is het land verpest geworden, heb Ik zijn misdaad gewroken, en heeft het land zijn bewoners uitgespuwd. ");
INSERT INTO nld1939_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Onderhoudt dus mijn voorschriften en wetten en laat niemand van de ingezetenen noch van de vreemdelingen, die in uw midden wonen, een van al die schanddaden bedrijven. ");
INSERT INTO nld1939_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Want al die gruwelen werden bedreven door die vóór u het land bewoonden, en het land is verpest geworden. ");
INSERT INTO nld1939_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Laat het land ook u niet uitspuwen, omdat ge het bezoedelt, zoals het de volken heeft uitgespuwd, die er vóór u hebben gewoond. ");
INSERT INTO nld1939_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Waarachtig allen, die zo iets schandelijks bedrijven, zullen van hun volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Onderhoudt dus mijn geboden; gedraagt u niet naar die liederlijke zeden, waarnaar men vóór u heeft geleefd, en bezoedelt u daar niet mee. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Beveel heel de gemeenschap van Israëls kinderen, en zeg hun: Weest heilig; want Ik, Jahweh uw God, ben heilig! ");
INSERT INTO nld1939_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Iedereen van u moet eerbied hebben voor zijn moeder en vader, en mijn sabbatten onderhouden. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Gij moogt u niet tot de afgoden wenden en u geen gegoten goden maken. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Wanneer gij Jahweh een vredeoffer brengt, doet het dan zo, dat het u ten goede komt. ");
INSERT INTO nld1939_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Op de dag, dat ge het offert, of op de volgende dag moet het worden gegeten. Wat er op de derde dag nog van over is, moet worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Zo het op de derde dag wordt gegeten, is het onrein en niet meer welgevallig. ");
INSERT INTO nld1939_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Die het eet, maakt zich schuldig; want hij onteert, wat aan Jahweh is gewijd. Hij zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Wanneer gij de oogst maait, die op uw land staat, moet ge uw akker niet tot de uiterste rand afmaaien, en geen nalezing houden van uw oogst. ");
INSERT INTO nld1939_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ook in uw wijngaard moogt ge geen napluk houden, en de afgevallen vruchten van uw wijngaard niet oprapen. Ge moet ze den arme en den vreemde overlaten. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ge zult niet stelen. Ge moogt niet liegen noch elkander bedriegen. ");
INSERT INTO nld1939_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ge moogt niet vals zweren bij mijn Naam, en de Naam van uw God niet ontheiligen. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ge zult uw naaste niet afzetten of beroven. Ge zult het loon van den dagloner niet tot de volgende morgen bij u houden. ");
INSERT INTO nld1939_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Een dove zult ge niet verwensen, en den blinde geen struikelblok in de weg leggen. Gij zult uw God vrezen; Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Gij zult bij de rechtspraak geen onrecht begaan: den arme niet bevoordelen, maar ook niet de partij van den rijke kiezen; met rechtvaardigheid moet ge uw naaste oordelen. ");
INSERT INTO nld1939_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Gij zult geen laster onder uw volk rondstrooien, en niet naar het bloed van uw naaste dorsten. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Gij moogt tegen uw broeder geen haat koesteren. Gij moet uw naaste terecht wijzen, om niet medeplichtig te worden aan zijn zonde. ");
INSERT INTO nld1939_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Neem geen wraak en blijf ook geen wraak koesteren tegen de zonen van uw volk, maar bemin uw naaste gelijk uzelf. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Onderhoudt mijn voorschriften. Gij moogt geen ongelijksoortige beesten laten paren, geen ongelijksoortig zaad op uw akker zaaien, geen ongelijksoortig kleed, uit verschillende stoffen geweven, dragen. ");
INSERT INTO nld1939_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Wanneer een man gemeenschap heeft met een slavin, die aan een ander is toegezegd, maar nog niet is losgekocht of vrijgelaten, dan zal hem een tuchtiging worden toegediend, maar ze zullen niet worden gedood; want ze was nog niet vrijgelaten. ");
INSERT INTO nld1939_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hij moet voor boete Jahweh een ram als schuldoffer brengen aan de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","De priester moet voor het aanschijn van Jahweh door den ram van het schuldoffer voor hem verzoening verkrijgen voor de zonde, die hij heeft bedreven; dan zal hem de zonde, die hij heeft bedreven, worden vergeven. ");
INSERT INTO nld1939_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Wanneer gij in het land zijt gekomen en allerlei vruchtbomen plant, dan moet ge hun vruchten als hun voorhuid beschouwen; drie jaren moeten ze als onbesneden voor u zijn, en mag er niet van worden gegeten. ");
INSERT INTO nld1939_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In het vierde jaar moeten al hun vruchten als feestgaven aan God worden gewijd. ");
INSERT INTO nld1939_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","In het vijfde jaar moogt ge de vruchten ervan eten; zo zult ge de opbrengst ervan nog vermeerderen. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Gij moogt niet op de bergen eten, en u niet afgeven met waarzeggerij of toverij. ");
INSERT INTO nld1939_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ge moogt uw haar aan uw slapen niet afscheren, de rand van uw baard niet korten, ");
INSERT INTO nld1939_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","uw lichaam niet kerven om een dode, en geen figuren in uw lichaam snijden. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Gij zult uw dochter niet ontwijden door ze tot ontucht aan te zetten, zodat het land losbandig wordt en vol liederlijkheid. ");
INSERT INTO nld1939_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Onderhoudt mijn sabbatdagen, en hebt eerbied voor mijn heiligdom. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Gij moogt uw toevlucht niet nemen tot spoken en waarzeggende geesten, en ze niet ondervragen; daardoor verontreinigt ge u. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Sta op voor den grijsaard, heb eerbied voor de ouderdom, en vrees uw God. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Wanneer een vreemdeling bij u in het land woont, moogt ge hem niet verdrukken. ");
INSERT INTO nld1939_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Als uw eigen landgenoot moet u de vreemdeling zijn, die bij u woont, en gij zult hem beminnen als uzelf; want ook gij zijt vreemdeling in Egypte geweest. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Weest niet oneerlijk bij de rechtspraak; niet oneerlijk in el, gewicht en maat. ");
INSERT INTO nld1939_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Een zuivere weegschaal, juiste gewichten, een juiste efa en hin moet ge hebben. Ik ben Jahweh, uw God, die u uit Egypte heb geleid! ");
INSERT INTO nld1939_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Onderhoudt dus al mijn voorschriften en geboden, en handelt er naar. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Zeg tot de kinderen Israëls: Wie van de Israëlieten en van de vreemden, die in Israël wonen, een van zijn kinderen aan den Molok offert, moet worden gedood. Het volk van het land moet hem stenigen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ik zal zo iemand mijn gramschap doen voelen en hem van zijn volk afsnijden, omdat hij een van zijn kinderen aan den Molok heeft geofferd, om mijn heiligdom te verontreinigen en mijn heilige Naam te ontwijden. ");
INSERT INTO nld1939_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","En al zouden de bewoners van het land voor zo iemand de ogen sluiten en hem niet doden, ofschoon hij een van zijn kinderen aan den Molok heeft geofferd, ");
INSERT INTO nld1939_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Ik zal zo iemand en zijn geslacht mijn gramschap doen voelen, en hem, en allen, die hem volgen in zijn afgodische verering van den Molok, van hun volk afsnijden. ");
INSERT INTO nld1939_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ook hem, die zijn toevlucht neemt tot spoken of waarzeggende geesten, en ze achterna loopt, zal Ik mijn gramschap doen voelen, en hem van zijn volk afsnijden. ");
INSERT INTO nld1939_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Gij moet u heilig gedragen en heilig zijn; want Ik, Jahweh, ben uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Gij moet mijn voorschriften onderhouden, en daarnaar handelen. Ik, Jahweh, ben het, die u heilig! ");
INSERT INTO nld1939_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Iemand die zijn vader of moeder vervloekt, moet worden gedood. Zo hij zijn vader of moeder heeft vervloekt, rust bloedschuld op hem. ");
INSERT INTO nld1939_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Wie overspel begaat met de vrouw van een ander, moet ter dood worden gebracht; de echtbreker zowel als de echtbreekster. ");
INSERT INTO nld1939_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Wie gemeenschap heeft met de vrouw van zijn vader, onteert zijn vader; beiden moeten ter dood worden gebracht: er rust bloedschuld op hen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Wanneer iemand gemeenschap met zijn schoondochter houdt, moeten beiden ter dood worden gebracht; zij hebben een schanddaad begaan: er rust bloedschuld op hen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Wanneer iemand bij een man ligt als bij een vrouw, bedrijven beiden een gruweldaad; zij moeten ter dood worden gebracht: er rust bloedschuld op hen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Wanneer iemand een dochter tegelijk met haar moeder neemt, begaat hij bloedschande; men moet die beiden verbranden: bloedschande mag onder u niet voorkomen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Wie een dier misbruikt, moet ter dood worden gebracht; ook het dier moet worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Wanneer een vrouw zich door een of ander dier laat schenden, moet gij de vrouw en het dier doden; zij moeten worden gedood: er rust bloedschuld op hen. ");
INSERT INTO nld1939_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Wanneer iemand zijn zuster neemt, de dochter van zijn vader of die van zijn moeder, en zij gemeenschap met elkaar houden, dan is dat bloedschande, en zij moeten voor de ogen van hun volksgenoten worden uitgeroeid; zo hij gemeenschap met zijn zuster heeft gehad, moet hij zijn schuld boeten. ");
INSERT INTO nld1939_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Wanneer iemand slaapt bij een vrouw in haar stonden en gemeenschap met haar houdt, zodat hij de plaats van haar vloeiing onthult en zij de plaats van haar bloedvloeiing ontbloot, dan moeten beiden van hun volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Gij moogt geen gemeenschap houden met de zuster van uw moeder of met die van uw vader; want dan heeft men gemeenschap met zijn naaste bloedverwant: hun schuld zullen ze boeten. ");
INSERT INTO nld1939_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Wanneer iemand gemeenschap heeft met zijn tante, onteert hij zijn oom; hun zonde zullen ze boeten en kinderloos sterven. ");
INSERT INTO nld1939_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Wanneer iemand de vrouw van zijn broer neemt, bedrijft hij iets afschuwelijks; hij onteert zijn broer; zij zullen kinderloos blijven. ");
INSERT INTO nld1939_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Onderhoudt al mijn voorschriften en wetten, en volbrengt ze, opdat het land, waarheen Ik u breng, om er te wonen, u niet uitspuwt. ");
INSERT INTO nld1939_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Leeft niet naar de zeden van de volken, die Ik voor u zal verjagen. Want omdat zij dit alles hebben gedaan, heb Ik een afschuw van hen gekregen, ");
INSERT INTO nld1939_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","en u gezegd: Neemt gij hun land in bezit; Ik geef het u in eigendom, een land, dat druipt van melk en honing: Ik Jahweh, uw God, die u van de volken heb afgezonderd! ");
INSERT INTO nld1939_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Maakt dus onderscheid tussen reine en onreine viervoetige dieren, tussen onreine en reine vogels, en bezoedelt u niet aan de viervoetige dieren, de vogels, en aan al wat over de aarde kruipt, die Ik u als onrein heb onthouden. ");
INSERT INTO nld1939_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Gij moet heilig voor Mij zijn, omdat Ik, Jahweh, heilig ben en u van de volken heb afgezonderd, om Mij toe te behoren. ");
INSERT INTO nld1939_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","De man of vrouw, die onder u als tovenaar of waarzegger optreedt, moet worden gedood; men moet hen stenigen, er rust bloedschuld op hen. ");
INSERT INTO nld1939_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Jahweh sprak tot Moses: Beveel de priesters, de zonen van Aäron, en zeg hun: Niemand van hen mag zich aan een dode van zijn familie verontreinigen, ");
INSERT INTO nld1939_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","behalve aan zijn naaste verwanten, aan zijn moeder, vader, zoon, dochter en broer. ");
INSERT INTO nld1939_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Ook aan zijn zuster mag hij zich verontreinigen, wanneer zij nog maagd is, daar ze dan tot de zijnen behoort en niet aan een man; ");
INSERT INTO nld1939_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","maar aan een getrouwde vrouw in zijn familie mag hij zich niet verontreinigen en daardoor ontwijden. ");
INSERT INTO nld1939_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Zij mogen zich echter nooit het hoofd kaal scheren, de rand van hun baard korten noch hun lichaam kerven. ");
INSERT INTO nld1939_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Heilig moeten zij zijn voor hun God, en de Naam van hun God niet ontwijden; want ze dragen de vuuroffers van Jahweh op, de spijs van hun God: daarom moeten zij heilig zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ook mogen zij geen ontuchtige of onteerde vrouw huwen, of een vrouw, die door haar man is verstoten; want hij is aan zijn God toegewijd. ");
INSERT INTO nld1939_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Gij moet hem als heilig beschouwen; want hij offert de spijs van uw God. Hij moet voor u heilig zijn, omdat Ik Jahweh, die hen heilig, zelf heilig ben. ");
INSERT INTO nld1939_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","De dochter van een priester, die zich door een ontuchtig leven onteert, ontwijdt haar vader; zij moet worden verbrand. ");
INSERT INTO nld1939_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Maar de priester, die hoger staat dan zijn broeders, op wiens hoofd de zalfolie is uitgestort, en die is aangesteld om de heilige gewaden te dragen, mag zijn haren niet losbinden en zijn kleren niet scheuren. ");
INSERT INTO nld1939_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hij mag bij geen dode komen, en zich zelfs aan zijn vader of moeder niet verontreinigen. ");
INSERT INTO nld1939_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Hij mag het heiligdom niet verlaten, en het heiligdom van zijn God niet ontwijden; want hij is gewijd met de zalfolie van zijn God. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Hij moet een vrouw nemen, die maagd is. ");
INSERT INTO nld1939_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Hij mag dus geen weduwe, of verstotene, geen onteerde of ontuchtige huwen, slechts een maagd uit zijn familie mag hij tot vrouw nemen, ");
INSERT INTO nld1939_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","om zijn nageslacht in zijn familie niet te ontwijden. Want Ik ben Jahweh, die hem heilig! ");
INSERT INTO nld1939_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Zeg aan Aäron: Wanneer iemand van uw kinderen, ook in uw volgende geslachten, een lichaamsgebrek heeft, mag hij niet naderbij komen, om de spijs van zijn God te offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Want niemand, die een lichaamsgebrek heeft, mag Mij naderen: geen blinde of lamme, geen verminkte of vergroeide; ");
INSERT INTO nld1939_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","niemand met een gebroken been of arm; ");
INSERT INTO nld1939_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","geen bult of dwerg; niemand met een witte vlek op zijn oog, of met uitslag of schurft; niemand ook, die ontmand is. ");
INSERT INTO nld1939_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Niemand van het geslacht van den priester Aäron, die een gebrek heeft, mag naderbij komen, om de vuuroffers van Jahweh te offeren; heeft hij dus een gebrek, dan mag hij de spijs van zijn God niet komen offeren. ");
INSERT INTO nld1939_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Wel mag hij eten van de spijs van zijn God, van het hoogheilige en van het heilige; ");
INSERT INTO nld1939_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","maar hij mag niet binnen het voorhangsel komen en niet tot het altaar naderen; want hij heeft een gebrek, en mag mijn heiligdom niet ontwijden. Want Ik ben Jahweh, die hen heilig! ");
INSERT INTO nld1939_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moses bracht het Aäron, zijn zonen en alle Israëlieten over. ");
INSERT INTO nld1939_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Zeg aan Aäron en zijn zonen, dat zij de heilige gaven, die de Israëlieten Mij wijden, met gepaste eerbied moeten behandelen, en mijn heilige Naam niet ontwijden. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Zeg hun dus: Iedereen onder uw kinderen van geslacht tot geslacht, die in staat van onreinheid de heilige gaven, die de Israëlieten Jahweh hebben gewijd, durft aanraken, zal van mijn aanschijn worden verstoten. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Niemand van Aärons geslacht, die melaats is of aan vloeiing lijdt, mag van de heilige gaven eten, eer hij weer rein is. Ook wie iemand heeft aangeraakt, die door een lijk verontreinigd is of een uitstorting had, ");
INSERT INTO nld1939_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","of wie een of ander ongedierte of een mens, waardoor men onrein wordt, heeft aangeraakt, ");
INSERT INTO nld1939_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","is tot de avond onrein en mag niet van de heilige gaven eten. Eerst als hij een bad heeft genomen, ");
INSERT INTO nld1939_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","en de zon is ondergegaan, is hij weer rein, en mag hij dus van de heilige gaven eten; want het is zijn levensonderhoud. ");
INSERT INTO nld1939_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ook mag hij geen gestorven of verscheurde dieren eten; daardoor wordt hij onrein. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Zij moeten mijn geboden onderhouden, en geen zonden op zich laden; want zij zullen sterven, wanneer zij ze ontwijden. Ik ben Jahweh, die hen heilig! ");
INSERT INTO nld1939_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Niemand, die niet tot een priestergezin behoort, mag het heilige eten. Iemand dus, die bij een priester inwoont of loonarbeider is, mag het heilige niet eten. ");
INSERT INTO nld1939_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Maar wanneer een priester voor geld een slaaf koopt, mag die ervan eten; evenzo mag de slaaf, die in zijn huis is geboren, zijn spijzen eten. ");
INSERT INTO nld1939_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Wanneer een dochter van een priester met een leek is gehuwd, mag zij niet meer van de heilige gaven eten. ");
INSERT INTO nld1939_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Maar wanneer een dochter van een priester weduwe wordt of verstoten is, en omdat zij geen kinderen heeft, naar het huis van haar vader is teruggekeerd, dan mag zij evenals in haar jeugd, de spijzen van haar vader eten. Dus wie niet tot een priestergezin behoort, mag daarvan niet eten. ");
INSERT INTO nld1939_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Wanneer iemand zonder opzet iets heiligs eet, moet hij het heilige aan den priester teruggeven met daarenboven een vijfde van de waarde. ");
INSERT INTO nld1939_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Men mag de heilige gaven, die de Israëlieten aan Jahweh opdragen, niet ontwijden, ");
INSERT INTO nld1939_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","om geen zondeschuld op zich te laden, als men van hun heilige gaven eet. Want Ik, Jahweh, heb ze geheiligd! ");
INSERT INTO nld1939_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Beveel Aäron en zijn zonen en alle Israëlieten, en zeg hun: Wanneer iemand uit het huis van Israël of van de vreemdelingen in Israël zijn gave brengt, krachtens gelofte of vrijwillig, om ze Jahweh als brandoffer op te dragen, ");
INSERT INTO nld1939_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","dan moet ze, wil ze u ten goede komen, uit een gaaf mannelijk dier bestaan uit de runderen, schapen of geiten. ");
INSERT INTO nld1939_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ge moogt niets offeren, wat enig gebrek heeft; want het zou u niet ten goede komen. ");
INSERT INTO nld1939_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ook wanneer iemand een vredeoffer aan Jahweh brengt van runderen of schapen, ofwel om een gelofte te vervullen ofwel als een vrijwillige gave, dan moet het, wil het hem ten goede komen, een gaaf dier zijn, zonder enig gebrek. ");
INSERT INTO nld1939_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Een blind dier of wat iets gebroken heeft, wat verminkt is of wonden, schurft of uitslag heeft, moogt ge niet aan Jahweh offeren, en daarvan geen vuuroffers voor Jahweh op het altaar leggen. ");
INSERT INTO nld1939_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Een rund of een schaap, dat vergroeid of verschrompeld is, moogt ge als vrijwillige gave brengen; maar als gelofteoffer zou het niet welgevallig zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Een dier, dat door wrijven, pletten, uitrukken of snijden ontmand is, moogt ge niet aan Jahweh offeren. In uw eigen land moogt ge ze zo niet behandelen, ");
INSERT INTO nld1939_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","maar ze ook niet van vreemden kopen, om ze uw God als spijs te offeren. Want ze zijn verminkt, en hebben een gebrek; ze zouden u niet ten goede komen. ");
INSERT INTO nld1939_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Een kalf, een lam of een geit moeten na hun geboorte zeven dagen bij hun moeder blijven; eerst van de achtste dag af wordt het aangenomen als een welgevallig vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Een rund of een schaap moogt ge niet op dezelfde dag slachten als hun jong. ");
INSERT INTO nld1939_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Wanneer ge een dankoffer aan Jahweh brengt, moet ge het zo offeren, dat het u ten goede komt. ");
INSERT INTO nld1939_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Op dezelfde dag moet het worden gegeten, en ge moogt er niets van tot de volgende morgen bewaren. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Onderhoudt dus mijn geboden en handelt er naar. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ontwijdt mijn heilige Naam niet. Ik wil onder Israëls kinderen als heilig worden vereerd. Ik ben Jahweh, die u heilig, ");
INSERT INTO nld1939_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","en die u uit Egypte heb geleid, om uw God te zijn. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Beveel de Israëlieten, en zeg hun: De feestdagen van Jahweh, waarop gij een godsdienstige bijeenkomst moet houden, zijn mijn volgende feesten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Zes dagen moogt ge arbeiden, maar de zevende dag is een grote rustdag met een godsdienstige bijeenkomst, waarop ge geen enkele arbeid moogt verrichten; overal waar ge woont, moet het een rustdag zijn ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dit zijn de feestdagen van Jahweh met de godsdienstige bijeenkomsten, die gij op hun vastgestelde tijden moet vieren. ");
INSERT INTO nld1939_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Op de veertiende dag van de eerste maand tegen het vallen van de avond is het Pasen ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","En op de vijftiende dag van dezelfde maand het feest van de ongedesemde broden ter ere van Jahweh; gedurende zeven dagen moet ge dan ongedesemde broden eten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Op de eerste dag moet gij bovendien een godsdienstige bijeenkomst houden, en moogt ge geen enkel slafelijk werk verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Zeven dagen lang moet ge vuuroffers aan Jahweh opdragen, en op de zevende dag weer een godsdienstige bijeenkomst houden, en moogt ge geen enkel slafelijk werk verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Beveel de Israëlieten, en zeg hun: Wanneer ge in het land zijt gekomen, dat Ik u geven zal, en ge zijn oogst afmaait, dan moet ge de eerste schoof van uw oogst den priester brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Hij moet die schoof voor het aanschijn van Jahweh als strekoffer aanbieden, opdat het u ten goede kome; daags na de sabbat moet de priester ze aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Op de dag, dat ge de schoof als strekoffer aanbiedt, moet ge een gaaf eenjarig lam als brandoffer aan Jahweh opdragen, ");
INSERT INTO nld1939_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","met het daarbij horend spijsoffer, namelijk twee issaron meelbloem met olie gemengd, als een heerlijk geurend vuuroffer voor Jahweh; bovendien het vierde van een hin wijn als plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tot deze dag moogt ge geen brood, geen geroosterd of ongeroosterd graan van de nieuwe oogst eten, eer gij uw gave aan uw God hebt gebracht. Dit is een eeuwig geldende wet voor al uw geslachten, waar ge ook woont. ");
INSERT INTO nld1939_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Van de dag na de sabbat, waarop ge de schoof als strekoffer hebt aangeboden, moet ge zeven volle weken tellen; zeven volle weken moeten het zijn, ");
INSERT INTO nld1939_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","tot aan de dag na de zevende sabbat; dus vijftig dagen moet ge tellen. Dan moet ge een nieuw spijsoffer aan Jahweh opdragen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Uit uw woonsteden moet ge als eerstelingen voor Jahweh twee broden voor een strekoffer brengen; ze moeten uit twee issaron meelbloem zijn bereid, en gedesemd worden gebakken. ");
INSERT INTO nld1939_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bij het brood moet ge zeven gave eenjarige lammeren offeren, een jongen stier en twee rammen; zij zullen met het daarbij behorend spijs(-) en plengoffer als een brandoffer voor Jahweh dienen, een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Als zondeoffer moet ge een geitebok offeren, en als vredeoffer twee eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","de priester moet ze voor het aanschijn van Jahweh als een strekoffer aanbieden, tegelijk met het eerstelingenbrood en de twee lammeren. Zij zullen een heilige gave voor Jahweh zijn, en den priester ten deel vallen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Op die dag moet ge een godsdienstige bijeenkomst houden en moogt ge geen slafelijk werk verrichten. Dit is een eeuwig geldende wet voor al uw geslachten, waar ge ook woont. ");
INSERT INTO nld1939_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ook moogt ge, wanneer ge de oogst van uw land maait, uw veld niet tot de uiterste rand afmaaien en geen nalezing van uw oogst houden; ge moet die voor den arme en den vreemdeling overlaten. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Zeg aan de Israëlieten: De eerste dag van de zevende maand moet een rustdag voor u zijn, een dag ter gedachtenis met bazuingeschal en een godsdienstige bijeenkomst. ");
INSERT INTO nld1939_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Dan moogt ge geen slafelijk werk verrichten, en moet ge een vuuroffer aan Jahweh opdragen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Bovendien valt op de tiende dag van de zevende maand de verzoendag. Dan moet ge een godsdienstige bijeenkomst houden, boete doen, en een vuuroffer aan Jahweh brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Op die dag moogt ge geen enkele arbeid verrichten; want het is een verzoendag, om verzoening voor u te verkrijgen voor het aanschijn van Jahweh, uw God. ");
INSERT INTO nld1939_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Iedereen, die op die dag geen boete doet, zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Iedereen, die op die dag enige arbeid verricht, zal Ik uit zijn volk verdelgen; ");
INSERT INTO nld1939_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ge moet u van alle arbeid onthouden. Dit is een eeuwig geldende wet voor al uw geslachten, waar ge ook woont. ");
INSERT INTO nld1939_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Het moet een grote sabbat voor u zijn, waarop ge boete moet doen; van de avond van de negende dag der maand tot de volgende avond moet ge uw rustdag vieren. ");
INSERT INTO nld1939_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Jahweh sprak tot Moses. ");
INSERT INTO nld1939_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Zeg aan de Israëlieten: Op de vijftiende dag van de zevende maand begint het loofhuttenfeest, zeven dagen lang, ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Op de eerste dag moet een godsdienstige bijeenkomst worden gehouden, en moogt ge geen slafelijk werk verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Zeven dagen lang moet ge Jahweh een vuuroffer opdragen. Op de achtste dag moet ge een godsdienstige bijeenkomst houden, en een vuuroffer opdragen ter ere van Jahweh. Het is een hoogtij, waarop ge geen slafelijk werk moogt verrichten. ");
INSERT INTO nld1939_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Dit zijn de feesten van Jahweh, waarop gij godsdienstige bijeenkomsten moet houden, en aan Jahweh vuuroffers opdragen: brand(-) en spijsoffers, slacht(-) en plengoffers, zoals het voor iedere dag is bepaald; ");
INSERT INTO nld1939_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","onverminderd de sabbatdagen van Jahweh, en behalve uw gaven en al uw gelofte(-) en vrijwillige offers, die ge aan Jahweh wilt schenken. ");
INSERT INTO nld1939_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Op de vijftiende dag van de zevende maand, wanneer ge het ooft van het land binnenhaalt, moet ge bovendien zeven dagen lang het feest van Jahweh vieren. De eerste dag moet een rustdag zijn, en de achtste dag eveneens. ");
INSERT INTO nld1939_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Op de eerste dag moet ge kostelijke boomvruchten nemen met palmtakken, twijgen van loofrijke bomen en laurieren, en u zeven dagen lang voor het aanschijn van Jahweh, uw God, verheugen. ");
INSERT INTO nld1939_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ieder jaar moet ge het zeven dagen lang als een feest ter ere van Jahweh vieren; dit is een eeuwig geldende wet voor al uw geslachten. In de zevende maand moet ge het vieren, ");
INSERT INTO nld1939_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","en dan zeven dagen lang in tenten wonen; allen die in Israël zijn geboren moeten dan in tenten wonen; ");
INSERT INTO nld1939_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","opdat uw nageslacht moge weten, dat Ik de Israëlieten in tenten deed wonen, toen Ik hen uit Egypte heb geleid. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Zo maakte Moses de feesten van Jahweh aan de kinderen Israëls bekend. ");
INSERT INTO nld1939_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Jahweh sprak tot Moses. ");
INSERT INTO nld1939_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Beveel de Israëlieten, dat zij u voor de kandelaar zuivere olie uit gestoten olijven brengen, om de lamp daarmee voortdurend te onderhouden. ");
INSERT INTO nld1939_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","In de openbaringstent buiten het voorhangsel voor de verbondsark moet Aäron ze voortdurend voor het aanschijn van Jahweh van de avond tot de morgen onderhouden. Dit is een eeuwig geldende wet voor al uw geslachten. ");
INSERT INTO nld1939_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Op de kandelaar van zuiver goud moet hij zonder onderbreking de lampen onderhouden voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Bovendien moet gij meelbloem nemen, en er twaalf koeken van bakken; twee issaron voor iedere koek. ");
INSERT INTO nld1939_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ge moet ze in twee stapels van zes op de tafel van zuiver goud leggen voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Leg op iedere stapel zuivere wierook; dit is het reukoffer bij het brood, het vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Onafgebroken moet men ze iedere sabbat opnieuw voor Jahweh neerleggen; dit is een eeuwige verplichting voor de kinderen Israëls. ");
INSERT INTO nld1939_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Het zal Aäron en zijn zonen ten deel vallen, en zij moeten het eten op een heilige plaats. Want het is hoogheilig; het is voor eeuwig zijn wettig deel van de vuuroffers van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Eens mengde zich de zoon van een israëlietische vrouw en van een Egyptenaar onder de Israëlieten, en kreeg in de legerplaats twist met een Israëliet. ");
INSERT INTO nld1939_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","En daar de zoon van de Israëlietische de Naam verwenste en vervloekte, bracht men hem tot Moses. Zijn moeder heette Sjelomit, en was de dochter van Dibri uit de stam van Dan. ");
INSERT INTO nld1939_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Men zette hem in verzekerde bewaring, tot Moses een beslissing zou nemen volgens de uitspraak van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","En Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Breng den godslasteraar buiten de legerplaats; laat allen, die het gehoord hebben, hun handen op zijn hoofd leggen, en heel de gemeenschap hem stenigen. ");
INSERT INTO nld1939_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","En tot de Israëlieten moet ge zeggen: Iedereen, die zijn God vervloekt, maakt zich schuldig aan zonde; ");
INSERT INTO nld1939_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","en wie de Naam van Jahweh lastert, moet worden gedood. Heel de gemeenschap moet hem stenigen; zowel de vreemdeling als de ingezetene moet worden gedood, wanneer zij de Naam vervloeken. ");
INSERT INTO nld1939_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Wanneer iemand een mens, wien ook, doodt, moet hij worden gedood; ");
INSERT INTO nld1939_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","leven voor leven. ");
INSERT INTO nld1939_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Wanneer iemand zijn naaste letsel toebrengt, moet hem worden vergolden, wat hij een ander heeft aangedaan. ");
INSERT INTO nld1939_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Breuk voor breuk, oog voor oog, tand voor tand; het letsel, dat iemand een ander toebrengt, moet hem worden toegebracht. ");
INSERT INTO nld1939_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wie een dier doodt, moet het vergoeden; wie een mens doodt, moet worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Diezelfde wet moet bij u gelden voor den vreemdeling zowel als voor den ingezetene. Want Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Zo sprak Moses tot de Israëlieten. Toen bracht men den godslasteraar buiten de legerplaats, en stenigde hem; de Israëlieten deden, wat Jahweh Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Jahweh sprak op de berg Sinaï tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Beveel de Israëlieten, en zeg hun: Wanneer ge in het land zijt gekomen, dat Ik u geven zal, dan moet ook het land ter ere van Jahweh sabbat houden. ");
INSERT INTO nld1939_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Zes jaren kunt ge uw akker bezaaien, zes jaren uw wijngaard snoeien, en de opbrengst ervan inzamelen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Maar in het zevende jaar moet het land volkomen rust houden, een sabbat ter ere van Jahweh; uw akker moogt ge dan niet bezaaien en uw wijngaard niet snoeien. ");
INSERT INTO nld1939_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","En wat vanzelf opschiet na de vorige oogst moogt ge niet oogsten, de druiven van uw ongesnoeide wijnstok niet plukken; het is een jaar van rust voor het land. ");
INSERT INTO nld1939_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Wat tijdens de rust van het land vanzelf groeit, mag echter door u worden gegeten, door u, uw slaaf, uw slavin, uw dagloner, door den inboorling en vreemdeling onder u; ");
INSERT INTO nld1939_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ook door het vee en het wild in uw land mag heel die opbrengst worden gegeten. ");
INSERT INTO nld1939_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Bovendien moet gij zeven weken van jaren tellen, dus zeven maal zeven jaren, zodat ge een tijd van zeven jaarweken of negen en veertig jaren krijgt. ");
INSERT INTO nld1939_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Dan moet ge op de tiende dag van de zevende maand bazuingeschal doen klinken; en op de verzoendag door heel uw land de bazuin laten schallen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Zo moet ge het vijftigste jaar heiligen! Ge moet in het land bevrijding afkondigen voor al zijn bewoners; het is een jubeljaar voor u, waarin ieder van u in zijn bezit moet worden hersteld en naar zijn familie kan terugkeren. ");
INSERT INTO nld1939_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Het vijftigste jaar is een jubeljaar voor u, waarin ge niet moogt zaaien, wat vanzelf opschiet niet oogsten, en van de ongesnoeide wijnstok niet plukken; ");
INSERT INTO nld1939_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","want het is een jubeljaar, en het moet heilig voor u zijn. Maar wat op het veld vanzelf groeit, moogt ge opeten. ");
INSERT INTO nld1939_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In dat jubeljaar moet ieder van u in zijn bezit worden hersteld. ");
INSERT INTO nld1939_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wanneer ge dus iets aan een ander verkoopt of iets van hem koopt, moogt ge elkaar niet benadelen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Naar het aantal jaren. dat het jubeljaar nog uitblijft, naar het aantal oogstjaren berekend, zult gij van een ander kopen, en zal hij ook aan u verkopen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Zijn het nog veel jaren, dan moet ge naar verhouding een hogere koopprijs geven, maar zijn het er nog slechts weinig, dan kunt ge die naar verhouding verminderen; want hij verkoopt u slechts het aantal oogsten. ");
INSERT INTO nld1939_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ge moogt dus elkaar niet benadelen, maar gij zult uw God vrezen. Want Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Zo ge naar mijn wetten leeft, en mijn geboden onderhoudt en volbrengt, zult ge onbezorgd in het land wonen, ");
INSERT INTO nld1939_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","en zal het u zijn vruchten geven, zodat ge volop kunt eten en er onbezorgd kunt wonen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","En wanneer ge zegt: Wat zullen we in het zevende jaar eten, daar we niet mogen zaaien, noch oogsten? ");
INSERT INTO nld1939_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","dan zal Ik in het zesde jaar zo mijn zegen over u uitstorten, dat het u een oogst voor drie jaren zal opleveren. ");
INSERT INTO nld1939_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","In het achtste jaar zult ge zaaien, en nog van de vorige oogst kunnen eten; tot de oogst van het negende jaar binnenkomt, zult ge nog van de vorige eten. ");
INSERT INTO nld1939_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ook moogt ge de grond niet voorgoed verkopen; want de grond behoort Mij: gij zijt slechts vreemden en gasten bij Mij. ");
INSERT INTO nld1939_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Daarom moet ge in heel het land, dat ge bezit, het recht van terugkoop van de grond laten gelden. ");
INSERT INTO nld1939_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wanneer dus uw broeder is verarmd, zodat hij van zijn bezit moet verkopen, dan moet zijn naaste losser komen, en terugkopen, wat zijn broeder heeft verkocht. ");
INSERT INTO nld1939_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Heeft iemand geen losser, maar kan hijzelf de middelen vinden, die voor de terugkoop nodig zijn, ");
INSERT INTO nld1939_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","dan moet hij, de jaren sinds de verkoop in aanmerking nemend, de overige jaren vergoeden aan hem, wien hij verkocht; zo zal hij in zijn bezit worden hersteld. ");
INSERT INTO nld1939_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Wanneer hij geen voldoende middelen kan vinden, om hem te betalen, dan blijft het verkochte tot aan het jubeljaar in het bezit van den koper. Maar in het jubeljaar komt het vrij, en wordt hij weer in zijn bezit hersteld. ");
INSERT INTO nld1939_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Wanneer iemand een woonhuis in een ommuurde stad verkoopt, houdt hij het recht van terugkoop, tot er een jaar na de verkoop is verstreken; een jaar duurt dus het recht van terugkoop. ");
INSERT INTO nld1939_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wanneer echter na een vol jaar een huis, dat in een ommuurde stad ligt, nog niet is teruggekocht, blijft het voorgoed het eigendom van den koper en zijn geslacht, en komt ook in het jubeljaar niet vrij. ");
INSERT INTO nld1939_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Maar huizen in dorpen, die niet door een muur zijn omringd, moeten tot het akkerland worden gerekend. Daarvoor is terugkoop altijd mogelijk, en in het jubeljaar komen zij vrij. ");
INSERT INTO nld1939_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","De huizen die de levieten in de levietensteden bezitten, kunnen altijd door hen worden teruggekocht. ");
INSERT INTO nld1939_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Koopt echter niemand der levieten het terug, dan komt het verkochte huis zo het in een stad ligt, die aan de levieten behoort, toch in het jubeljaar vrij. Want de huizen van de levietensteden blijven hun bezit te midden van de Israëlieten. ");
INSERT INTO nld1939_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","De weidegrond, die tot hun steden behoort, mag niet worden verkocht, want die vormt voor hen een onvervreemdbaar bezit. ");
INSERT INTO nld1939_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Wanneer uw broeder, die bij u woont, verarmt en in nood raakt, moet ge hem ondersteunen, zodat hij bij u kan leven, evengoed als een vreemdeling of een inboorling. ");
INSERT INTO nld1939_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ge moogt geen rente of woekerwinst van hem nemen; maar ge zult uw God vrezen, en uw broeder bij u laten leven. ");
INSERT INTO nld1939_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Geef uw geld niet tegen rente, en leg geen woekerwinst op levensmiddelen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ik ben Jahweh, uw God, die u uit Egypte heb geleid, om u het land Kanaän te geven, en uw God te zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Wanneer uw broeder, die bij u woont, zo is verarmd, dat hij zich als slaaf aan u heeft verkocht, moogt ge hem toch geen slavendienst laten verrichten, ");
INSERT INTO nld1939_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","maar moet hij als een loonarbeider, of een inboorling bij u blijven. Tot het jubeljaar zal hij dus bij u in dienst zijn, ");
INSERT INTO nld1939_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","dan zal hij met zijn zonen vrij van u heengaan, naar zijn familie terugkeren en in zijn vaderlijk bezit worden hersteld. ");
INSERT INTO nld1939_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Want ze zijn mijn dienaars, die Ik uit Egypte heb geleid; zij mogen dus niet als slaven worden verkocht. ");
INSERT INTO nld1939_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Behandel hen niet met hardheid, maar vrees uw God. ");
INSERT INTO nld1939_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Uw slaven en slavinnen, die uw eigendom zullen zijn, kunt ge u kopen uit de volken, die u omringen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ook van de kinderen der inboorlingen, die onder u wonen, kunt ge er kopen, en uit hun families, die ze bij u in het land hebben verwekt. Dezen zullen uw eigendom zijn, ");
INSERT INTO nld1939_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","en gij kunt ze aan uw zonen vermaken als erfelijk bezit. Hen moogt ge voor altijd slavendienst laten verrichten; maar de Israëlieten, uw broeders, moogt ge niet met hardheid behandelen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Wanneer een vreemdeling of een inboorling rijk wordt, en uw broeder daarentegen, die bij hem woont, zo verarmt, dat hij zich aan den vreemdeling, den inboorling of aan iemand van hun familie moet verkopen, ");
INSERT INTO nld1939_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","dan heeft hij, nadat hij zich heeft verkocht, het recht van vrijkoop. Een van zijn broers kan hem loskopen, ");
INSERT INTO nld1939_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","of iemand van zijn familie, zijn oom, zijn neef of een van zijn naaste bloedverwanten. Of zo hij de middelen heeft, kan hij zichzelf loskopen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Hij moet dan met den koper de tijd berekenen van het jaar af, dat hij zich aan hem heeft verkocht, tot aan het jubeljaar, en de som, waarvoor hij zich wil terugkopen, moet in verhouding staan tot dat aantal jaren: de tijd, dat hij bij hem bleef, moet berekend worden als die van een loonarbeider. ");
INSERT INTO nld1939_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Zo het nog veel jaren zijn, moet hij een evenredig bedrag van de koopsom als losgeld terugbetalen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Zo er nog maar weinig jaren over zijn tot aan het jubeljaar, moet hij ze eveneens berekenen, en naar verhouding van zijn jaren het losgeld betalen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Hij zal dus bij hem zijn als iemand die per jaar voor loon arbeidt, en door den ander onder uw ogen niet met hardheid worden behandeld. ");
INSERT INTO nld1939_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Maar ook als hij niet op deze manier wordt vrijgekocht, zal hij toch met zijn zonen in het jubeljaar vrijkomen. ");
INSERT INTO nld1939_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Want de kinderen Israëls zijn mijn dienaren; mijn slaven zijn het, die Ik uit het land van Egypte heb geleid. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Gij moogt u geen afgoden maken, geen afgodsbeelden of wijstenen oprichten, en geen gebeeldhouwde stenen in uw land opstellen, om die te aanbidden; want Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Onderhoudt mijn sabbatdagen, en hebt eerbied voor mijn heiligdom. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Wanneer ge naar mijn wetten leeft, mijn geboden onderhoudt en ze volbrengt, ");
INSERT INTO nld1939_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","dan schenk Ik u regen op de juiste tijd, zodat het land zijn oogst zal geven en de bomen van het veld hun vruchten. ");
INSERT INTO nld1939_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","De dorstijd zal tot de wijnoogst duren, en de wijnoogst weer tot de zaaitijd. Gij zult uw brood eten tot verzadigens toe, en onbezorgd in uw land wonen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Dan zal Ik vrede schenken aan het land, zodat gij u ter ruste kunt leggen, zonder dat iemand u opschrikt. Ik zal de wilde dieren uit het land verjagen, en geen zwaard trekt uw land binnen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Gij zult uw vijanden verjagen, en zij zullen vallen door uw zwaard. ");
INSERT INTO nld1939_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vijf van u zullen er honderd doen vluchten, en honderd van u tienduizend; door uw zwaard zullen uw vijanden vallen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Dan zal Ik mijn blik op u richten, u vruchtbaar maken en vermenigvuldigen, en mijn Verbond met u gestand doen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ge zult nog graan van de oude oogst kunnen eten, en het oude voor het nieuwe weg moeten doen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Dan zal Ik mijn woning onder u opslaan, u nimmer verwerpen, ");
INSERT INTO nld1939_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","en vertrouwelijk met u omgaan. Ik zal uw God, en gij zult mijn volk zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ik ben Jahweh, uw God, die u uit Egypte heb geleid, zodat ge niet langer hun slaven waart; Ik heb de bomen van uw juk verbroken en u weer recht overeind laten gaan. ");
INSERT INTO nld1939_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Maar wanneer ge niet naar Mij luistert en al deze geboden niet onderhoudt, ");
INSERT INTO nld1939_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","wanneer ge mijn voorschriften veracht en mijn wetten versmaadt, mijn geboden verkracht en mijn Verbond verbreekt, ");
INSERT INTO nld1939_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","dan zal Ik zo met u handelen: Ik zal u met ijselijke rampen bezoeken, met tering en koorts, die de ogen doven en de ziel doen versmachten. Dan zaait ge uw zaad tevergeefs; want uw vijanden eten het op. ");
INSERT INTO nld1939_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ik zal u mijn gramschap doen voelen, zodat gij door uw vijanden wordt verslagen, en die u haten, over u zullen heersen, en gij op de vlucht slaat, ofschoon niemand u achtervolgt. ");
INSERT INTO nld1939_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","En als ge Mij dan nog niet gehoorzaamt, dan blijf Ik u tuchtigen voor uw zonden tot zevenmaal toe. ");
INSERT INTO nld1939_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Uw trotse kracht zal Ik breken, de hemel boven u van ijzer maken, en de grond onder u van koper. ");
INSERT INTO nld1939_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Dan put gij uw kracht uit om niet; uw bodem geeft u geen oogst en de bomen der aarde geen vruchten. ");
INSERT INTO nld1939_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","En zo ge u dan nog tegen Mij blijft verzetten, en naar Mij niet wilt luisteren, dan tuchtig Ik u opnieuw voor uw zonden tot zevenmaal toe. ");
INSERT INTO nld1939_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Dan laat Ik wilde dieren op u los, die u kinderloos maken, uw vee verscheuren, en uw getal zo doen slinken, dat uw wegen verlaten liggen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","En zo ge u nog altijd niet door Mij laat gezeggen en u tegen Mij blijft verzetten, ");
INSERT INTO nld1939_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","dan zal ook Ik Mij tegen u verzetten, en u tuchtigen om uw zonden tot zevenmaal toe. ");
INSERT INTO nld1939_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Dan laat Ik het zwaard op u los, om het Verbond bloedig te wreken. Kruipt ge in uw steden bijeen, dan zend Ik de pest onder u, zodat ge toch in de handen van uw vijanden valt. ");
INSERT INTO nld1939_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Dan breek Ik de broodstaf bij u, zodat tien vrouwen uw brood in één oven bakken, het u geven volgens gewicht, en gij niet eens volop kunt eten. ");
INSERT INTO nld1939_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","En wanneer ge dan nog niet gehoorzaamt en u tegen Mij blijft verzetten, ");
INSERT INTO nld1939_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","dan zal ook Ik in mijn woede Mij tegen u blijven verzetten, en u tuchtigen om uw zonden tot zevenmaal toe. ");
INSERT INTO nld1939_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Dan zult ge het vlees van uw zonen eten en het vlees van uw dochters. ");
INSERT INTO nld1939_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Uw offerhoogten zal Ik verwoesten en uw huisaltaren vernielen, uw lijken voor uw afgodsbeelden smijten, en een walg van u krijgen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ik zal uw steden tot puinhopen maken, uw heiligdommen vernielen, de heerlijke geuren van uw reukoffers niet ruiken. ");
INSERT INTO nld1939_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ik zal het land verwoesten, zodat uw vijanden, die het zullen bewonen, er verstomd over staan. ");
INSERT INTO nld1939_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ik zal u verstrooien onder de volken, en het zwaard achter u ontbloten. Dan zal uw land een wildernis worden, en uw steden zullen puinhopen zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Al de tijd, dat het land woest ligt en gij in het land uwer vijanden zijt, haalt het zijn sabbatten in; dan zal het rusten en krijgt het zijn sabbatjaren vergoed. ");
INSERT INTO nld1939_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Al de tijd dat het woest ligt, zal het rusten, omdat het op uw sabbatjaren geen rust heeft gehad, zolang gij er bleeft wonen. ");
INSERT INTO nld1939_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Dan stort Ik hen, die zijn overgebleven en in het land hunner vijanden zijn, een verbijsterende schrik in het hart; het geritsel van een dor blad jaagt hen op, en zij slaan op de vlucht, zoals men wegrent voor een zwaard. Zij zullen vallen, ofschoon niemand hen achtervolgt; ");
INSERT INTO nld1939_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","zij struikelen over elkander als zit hen het zwaard op de hielen, ofschoon niemand achter hen is. Voor uw vijanden zult ge geen stand houden, ");
INSERT INTO nld1939_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","maar onder de volken te gronde gaan, en het land uwer vijanden zal u verslinden. ");
INSERT INTO nld1939_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","En wie van u zijn overgebleven, kwijnen weg om hun zonden in de landen hunner vijanden; ook om de zonden van hun vaderen kwijnen ze weg. ");
INSERT INTO nld1939_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Maar dan zullen zij hun zonde en die hunner vaderen bekennen, hoe zij ontrouw tegen Mij zijn geweest; hoe zij zich tegen Mij hebben verzet, ");
INSERT INTO nld1939_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","en Ik Mij tegen hen moest verzetten, en hen naar het land hunner vijanden heb gevoerd. En wanneer zij dan hun onbesneden hart zullen buigen, en boete doen voor hun zonde, ");
INSERT INTO nld1939_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","zal Ik mijn Verbond met Jakob gedenken, mijn Verbond met Isaäk en Abraham. Dan zal Ik het land weer gedenken, ");
INSERT INTO nld1939_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","het land dat door hen moest worden verlaten en zijn sabbatten inhaalde; dat om hen verwoest bleef liggen, terwijl zij hun zonde moesten boeten, daar ze mijn wetten hadden veracht en mijn voorschriften hadden versmaad. ");
INSERT INTO nld1939_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Neen, zelfs in het land hunner vijanden, verwerp Ik hen niet en stoot ze niet van Mij weg, om hen te verdelgen en mijn Verbond met hen te verbreken; want Ik ben Jahweh, hun God! ");
INSERT INTO nld1939_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maar Ik zal voor hen het Verbond met hun vaderen gedenken, die Ik voor de ogen der volken uit Egypte heb geleid, om hun God te zijn: Ik Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dit zijn de voorschriften, instellingen en wetten, die Jahweh op de berg Sinaï door Moses heeft gegeven als geldend tussen Hem en de kinderen Israëls. ");
INSERT INTO nld1939_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Beveel de Israëlieten, en zeg hun: Wanneer iemand door een gelofte personen naar hun schattingswaarde aan Jahweh wijdt, dan moet ge ze schatten als volgt. ");
INSERT INTO nld1939_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Een man van twintig tot zestig jaar moet op vijftig zilveren sikkels volgens het heilig gewicht, worden geschat. ");
INSERT INTO nld1939_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Zo het een vrouw is, moet zij op dertig sikkels worden geschat. ");
INSERT INTO nld1939_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Zo het iemand is van vijf tot twintig jaar, moet een jongen op twintig sikkels, een meisje op tien sikkels worden geschat. ");
INSERT INTO nld1939_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Is het kind een maand tot vijf jaar oud, dan moet een knaap op vijf zilveren sikkels, een meisje op drie worden geschat. ");
INSERT INTO nld1939_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Een man van zestig jaar en daarboven moet op vijftien sikkels worden geschat, een vrouw op tien. ");
INSERT INTO nld1939_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Wanneer hij te arm is om die schatting te betalen, moet men hem voor den priester brengen, en deze moet hem schatten; en de priester zal het vermogen schatten van hem, die de gelofte heeft afgelegd. ");
INSERT INTO nld1939_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Wanneer het een dier is, dat aan Jahweh als offergave kan worden gebracht, dan blijft het gewijd, als men het eenmaal aan Jahweh heeft gegeven. ");
INSERT INTO nld1939_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Men mag het niet vervangen, en geen beter voor een slechter, of een slechter voor een beter verruilen. Zo men toch het ene dier met het andere verruilt, zijn beide, dus ook het geruilde, gewijd. ");
INSERT INTO nld1939_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Wanneer het een of ander onrein dier is, dat niet als offergave aan Jahweh mag worden gebracht, dan moet men dat dier voor den priester brengen. ");
INSERT INTO nld1939_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","De priester zal het op zijn juiste waarde schatten, en zoals de priester het schat, zal de waarde ervan zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Zo men het wil inlossen, moet men nog het vijfde deel van de geschatte waarde er aan toevoegen. ");
INSERT INTO nld1939_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Wanneer iemand zijn huis als heilige gave aan Jahweh wijdt, zal de priester het op zijn juiste waarde schatten, en zoals de priester het schat, zal de waarde worden bepaald. ");
INSERT INTO nld1939_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Zo hij, die het huis heeft toegewijd, het wil inlossen, moet hij nog het vijfde deel van de geschatte waarde er aan toevoegen; dan zal het weer zijn eigendom zijn. ");
INSERT INTO nld1939_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Wanneer iemand een stuk land, dat hij bezit, aan Jahweh wijdt, dan moet het worden geschat naar de hoeveelheid zaad, die er voor nodig is; een stuk land, waarop een chómer gerst kan worden gezaaid, op vijftig zilveren sikkels. ");
INSERT INTO nld1939_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Wijdt hij zijn akker van het jubeljaar af, dan moet hij de volle schattingsprijs betalen. ");
INSERT INTO nld1939_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Wijdt hij hem na het jubeljaar, dan moet de priester de prijs berekenen naar het aantal jaren, die nog tot aan het jubeljaar moeten verlopen, en die moeten worden afgetrokken van de geschatte som. ");
INSERT INTO nld1939_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Zo hij de akker, die hij gewijd heeft, wil inlossen, moet hij het vijfde deel van de geschatte waarde er aan toevoegen; dan blijft de akker zijn eigendom. ");
INSERT INTO nld1939_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Zo hij de akker niet heeft ingelost, maar hem toch aan een ander verkoopt, dan mag die later niet meer worden ingelost; ");
INSERT INTO nld1939_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","en wanneer de akker met het jubeljaar vrijkomt, zal hij aan Jahweh gewijd blijven, zoals een akker, die onder de banvloek ligt; hij valt dan den priester ten deel. ");
INSERT INTO nld1939_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Wanneer iemand een akker aan Jahweh wijdt, die door koop is verkregen, en niet tot zijn erfgoed behoort, ");
INSERT INTO nld1939_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","dan moet de priester hem de waarde berekenen tot aan het eerst komende jubeljaar, en moet hij het geschatte bedrag nog dezelfde dag als een gewijde gave aan Jahweh schenken; ");
INSERT INTO nld1939_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","en in het jubeljaar keert de akker terug in het bezit van hem, van wien hij hem heeft gekocht en wiens erfgoed hij was. ");
INSERT INTO nld1939_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Al uw schattingen moeten volgens de heilige sikkel zijn, twintig gera de sikkel. ");
INSERT INTO nld1939_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Het eerstgeborene van het vee, dat reeds als eerstgeborene aan Jahweh behoort, mag door niemand meer worden toegewijd; noch dat van een rund, noch dat van een schaap. Het behoort reeds aan Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Zo het een onrein dier is, kan men het inlossen naar de schattingswaarde, maar men moet er een vijfde van de prijs aan toevoegen. Zo het niet wordt gelost, moet het voor de geschatte prijs worden verkocht. ");
INSERT INTO nld1939_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Maar niets wat onder de banvloek ligt, en wat men uit zijn bezit door de ban aan Jahweh heeft gewijd, mens, dier of een stuk land, kan worden verkocht of ingelost; het blijft hoogheilig voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Geen mens, die onder de banvloek ligt, kan worden vrijgekocht; hij moet worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Alle tienden van de grond, van wat op het land is gezaaid, en van de vruchten der bomen, behoren aan Jahweh, en zijn aan Jahweh gewijd. ");
INSERT INTO nld1939_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Zo iemand iets van zijn tienden wil lossen, moet hij een vijfde deel daarvan er aan toevoegen. ");
INSERT INTO nld1939_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ook alle tienden van rundvee en schapen, van alles wat onder de herdersstaf doorgaat, zijn aan Jahweh gewijd. ");
INSERT INTO nld1939_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Men mag geen keuze doen tussen goede of slechte dieren en ze evenmin ruilen; verruilt men ze toch, dan zijn beide, dus ook het geruilde, aan Jahweh gewijd. Ze kunnen dus niet worden ingelost. ");
INSERT INTO nld1939_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dit zijn de geboden, die Jahweh op de berg Sinaï aan Moses voor de kinderen Israëls heeft gegeven. ");
INSERT INTO nld1939_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","In de woestijn van de Sinaï sprak Jahweh tot Moses in de openbaringstent op de eerste dag van de tweede maand in het tweede jaar na hun uittocht uit Egypte: ");
INSERT INTO nld1939_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Neemt het getal op van de hele gemeenschap der Israëlieten, naar hun geslachten en families, door alle mannelijke personen hoofd voor hoofd te tellen. ");
INSERT INTO nld1939_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Alle strijdbare mannen in Israël van twintig jaar af moet gij monsteren volgens hun legerkorpsen; gij en Aäron ");
INSERT INTO nld1939_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","moeten het doen, en uit iedere stam moet één man, een familiehoofd, u helpen. ");
INSERT INTO nld1939_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Hier volgen de namen van de mannen, die u ter zijde moeten staan: Voor Ruben Elisoer, de zoon van Sjedeoer; ");
INSERT INTO nld1939_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","voor Simeon Sjeloemiël, de zoon van Soerisjaddai; ");
INSERT INTO nld1939_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","voor Juda Naässon, de zoon van Amminadab; ");
INSERT INTO nld1939_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","voor Issakar Netanel, de zoon van Soear; ");
INSERT INTO nld1939_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","voor Zabulon Eliab, de zoon van Chelon. ");
INSERT INTO nld1939_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Voor de zonen van Josef, voor Efraïm Elisjama, de zoon van Ammihoed; voor Manasse Gamliël, de zoon van Pedasoer. ");
INSERT INTO nld1939_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Voor Benjamin Abidan, de zoon van Gidoni; ");
INSERT INTO nld1939_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","voor Dan Achiézer, de zoon van Ammisjaddai; ");
INSERT INTO nld1939_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","voor Aser Pagiël, de zoon van Okran; ");
INSERT INTO nld1939_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","voor Gad Eljasaf, de zoon van Deoeël; ");
INSERT INTO nld1939_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","voor Neftali Achira, de zoon van Enan. ");
INSERT INTO nld1939_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Deze moeten uit de gemeenschap worden opgeroepen, als de vorsten van de stammen hunner vaderen en stamhoofden van Israël. ");
INSERT INTO nld1939_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moses en Aäron ontboden dus deze mannen, wier namen zijn opgegeven, ");
INSERT INTO nld1939_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","en riepen op de eerste van de tweede maand de hele gemeenschap bijeen. Zij werden naar hun geslachten en families opgetekend na hoofdelijke telling der personen, die twintig jaar oud waren en meer. ");
INSERT INTO nld1939_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Zo monsterde Moses hen in de woestijn van de Sinaï, zoals Jahweh het hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","De zonen, die van Ruben afstamden, Israëls eerstgeborene, werden naar hun geslachten en families, hoofd voor hoofd, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","uit de stam van Ruben bedroeg in het geheel zes en veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","De zonen, die van Simeon afstamden, werden naar hun geslachten en families, hoofd voor hoofd, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","uit de stam van Simeon bedroeg in het geheel negen en vijftig duizend driehonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","De zonen, die van Gad afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","uit de stam van Gad bedroeg in het geheel vijf en veertig duizend zes honderd vijftig man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","De zonen, die van Juda afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","uit de stam van Juda bedroeg in het geheel vier en zeventig duizend zeshonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","De zonen, die van Issakar afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","uit de stam van Issakar bedroeg in het geheel vier en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","De zonen, die van Zabulon afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","uit de stam van Zabulon bedroeg in het geheel zeven en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","De zonen van Josef, de zonen, die van Efraïm afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","uit de stam van Efraïm bedroeg in het geheel veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","De zonen, die van Manasse afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","uit de stam van Manasse bedroeg in het geheel twee en dertig duizend tweehonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","De zonen, die van Benjamin afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","uit de stam van Benjamin bedroeg in het geheel vijf en dertig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","De zonen, die van Dan afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","uit de stam van Dan bedroeg in het geheel twee en zestig duizend zevenhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","De zonen, die van Aser afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","uit de stam van Aser bedroeg in het geheel een en veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","De zonen, die van Neftali afstamden, werden naar hun geslachten en families, met name geteld; het getal strijdbare mannen van twintig jaar af ");
INSERT INTO nld1939_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","uit de stam van Neftali bedroeg in het geheel drie en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dit waren de mannen, die Moses en Aäron hadden gemonsterd tezamen met de twaalf vorsten van Israël, één uit elke stam, allen familiehoofden. ");
INSERT INTO nld1939_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Het totaal der gemonsterden van de Israëlieten naar hun families, alle strijdbare mannen in Israël van twintig jaar af, ");
INSERT INTO nld1939_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","bedroeg zeshonderd drie duizend vijfhonderd vijftig man. ");
INSERT INTO nld1939_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Maar de stam der Levieten werd niet met hen op de lijst geplaatst. ");
INSERT INTO nld1939_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Want Jahweh had tot Moses gezegd: ");
INSERT INTO nld1939_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","De stam van Levi moet ge niet monsteren en hun getal niet bij de andere Israëlieten opnemen. ");
INSERT INTO nld1939_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","De Levieten moet ge belasten met de zorg voor de tabernakel van het Verbond, voor al zijn benodigdheden en alles, wat er toe behoort. Zij moeten de tabernakel dragen en bedienen met alles, wat er toe behoort, en zich dus rond de tabernakel legeren. ");
INSERT INTO nld1939_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wanneer de tabernakel op moet trekken, moeten de Levieten hem afbreken, en wanneer de tabernakel stil houdt, moeten de Levieten hem oprichten; zo een onbevoegde nadert, moet hij worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","En terwijl de Israëlieten zich volgens hun legerafdelingen in hun kampement en onder hun eigen banier moeten legeren, ");
INSERT INTO nld1939_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","moeten de Levieten zich rond de tabernakel van het Verbond legeren, om de gramschap van God niet te doen losbarsten tegen de gemeenschap van Israëls kinderen; de Levieten moeten dus de dienst van de tabernakel van het Verbond verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","De Israëlieten volbrachten alles nauwkeurig, wat Jahweh Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","De Israëlieten moeten zich onder hun eigen banier en bij de veldtekens van hun familie scharen, en zich op enige afstand rond de openbaringstent legeren. ");
INSERT INTO nld1939_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Zo werd aan de oostkant, waar de zon opkomt, de banier geplant van het leger van Juda, naar zijn afdelingen ingedeeld; de aanvoerder der Judeërs was Naässon, de zoon van Amminadab, ");
INSERT INTO nld1939_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","en zijn afdeling telde vier en zeventig duizend zeshonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Daarnaast legerde zich de stam van Issakar; de aanvoerder der Issakarieten was Netanel, de zoon van Soear, ");
INSERT INTO nld1939_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","en zijn afdeling telde vier en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Bovendien de stam van Zabulon; de aanvoerder der Zabulonieten was Eliab, de zoon van Chelon, ");
INSERT INTO nld1939_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","en zijn afdeling telde zeven en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Het hele aantal manschappen van het leger van Juda, ingedeeld naar hun afdelingen, bedroeg honderd zes en tachtig duizend vierhonderd man. Zij trokken het eerst op. ");
INSERT INTO nld1939_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","De banier van het leger van Ruben, naar zijn afdelingen ingedeeld, werd in het zuiden geplant; de aanvoerder der Rubenieten was Elisoer, de zoon van Sjedeoer, ");
INSERT INTO nld1939_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","en zijn afdeling telde zes en veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Daarnaast legerde zich de stam van Simeon; de aanvoerder der Simeonieten was Sjeloemiël, de zoon van Soerisjaddai, ");
INSERT INTO nld1939_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","en zijn afdeling telde negen en vijftig duizend drie honderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Bovendien de stam van Gad; de aanvoerder der Gadieten was Eljasaf, de zoon van Deoeël; ");
INSERT INTO nld1939_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","en zijn afdeling telde vijf en veertig duizend zeshonderd vijftig man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Het hele aantal manschappen van het leger van Ruben, ingedeeld naar hun afdelingen, bedroeg honderd een en vijftig duizend vierhonderd vijftig man. Zij trokken het tweede op. ");
INSERT INTO nld1939_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Dan trok de openbaringstent op met het leger der Levieten, dat zich in het midden der andere legers bevond; zoals ze gelegerd waren, trokken ze op: ieder op zijn plaats en onder zijn eigen banier. ");
INSERT INTO nld1939_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","De banier van het leger van Efraïm, naar zijn afdelingen ingedeeld, werd in het westen geplant; de aanvoerder der Efraïmieten was Elisjama, de zoon van Ammihoed, ");
INSERT INTO nld1939_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","en zijn afdeling telde veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Daarnaast legerde zich de stam van Manasse; de aanvoerder der Manassieten was Gamliël, de zoon van Pedasoer, ");
INSERT INTO nld1939_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","en zijn afdeling telde twee en dertig duizend tweehonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Bovendien de stam van Benjamin; de aanvoerder der Benjamieten was Abidan, de zoon van Gidoni, ");
INSERT INTO nld1939_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","en zijn afdeling telde vijf en dertig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Het hele aantal manschappen van het leger van Efraïm, ingedeeld naar hun afdelingen, bedroeg honderd acht duizend en honderd man. Zij trokken het derde op. ");
INSERT INTO nld1939_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","De banier van het leger van Dan, naar zijn legerafdelingen ingedeeld, werd aan de noordzijde geplant; de aanvoerder der Danieten was Achiézer, de zoon van Ammisjaddai, ");
INSERT INTO nld1939_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","en zijn afdeling telde twee en zestig duizend zeven honderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Daarnaast legerde zich de stam van Aser; de aanvoerder der Aserieten was Pagiël, de zoon van Okran, ");
INSERT INTO nld1939_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","en zijn afdeling telde een en veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Bovendien de stam van Neftali; de aanvoerder der Neftalieten was Achira, de zoon van Enan, ");
INSERT INTO nld1939_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","en zijn afdeling telde drie en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Het hele aantal manschappen van het leger van Dan bedroeg honderd zeven en vijftig duizend zeshonderd man. Zij trokken met hun banieren het laatste op. ");
INSERT INTO nld1939_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Dit waren de gemonsterden van de Israëlieten naar hun families. Het volledig aantal manschappen van de legers, ingedeeld naar hun afdelingen, bedroeg zeshonderd drieduizend vijfhonderd vijftig man. ");
INSERT INTO nld1939_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Maar de Levieten werden niet met de andere Israëlieten op de lijst geplaatst, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","De kinderen Israëls brachten dus alles ten uitvoer, wat Jahweh Moses bevolen had; zij legerden zich onder hun banieren, en trokken op met hun eigen geslachten en bij hun eigen families. ");
INSERT INTO nld1939_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dit waren de nakomelingen van Aäron, toen Jahweh op de berg Sinaï tot Moses sprak. ");
INSERT INTO nld1939_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Dit zijn de namen van de zonen van Aäron: Nadab, de eerstgeborene, Abihoe, Elazar en Itamar; ");
INSERT INTO nld1939_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","het zijn de namen van Aärons zonen, die als gezalfde priesters werden aangesteld, om de priesterlijke bediening uit te oefenen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab en Abihoe waren voor het aanschijn van Jahweh gestorven, toen zij in de woestijn van de Sinaï voor Jahweh’s aanschijn onwettig vuur offerden. En daar zij geen zonen hadden, oefenden slechts Elazar en Itamar, onder toezicht van hun vader Aäron, het priesterambt uit. ");
INSERT INTO nld1939_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Roep de stam van Levi op, en stel die ter beschikking van den priester Aäron, om hem te dienen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Zij moeten zorgen voor wat hij en heel de gemeenschap bij de openbaringstent nodig hebben, om de dienst van de tabernakel te laten verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Zij moeten zorg dragen voor alle benodigdheden van de openbaringstent en voor wat de Israëlieten behoeven, om de dienst van de tabernakel te laten verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Gij moet de Levieten onder Aäron en zijn zonen plaatsen, ze van de Israëlieten afzonderen, en ze volkomen te hunner beschikking stellen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aäron en zijn zonen moet ge aanstellen, om hun priesterambt uit te oefenen; zo een onbevoegde nadert, moet hij worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Zie, Ik heb de Levieten uit de kinderen Israëls uitverkoren, in plaats van alle eerstgeborenen der Israëlieten, die de moederschoot openen. De Levieten behoren aan Mij! ");
INSERT INTO nld1939_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Want Mij behoren de eerstgeborenen; op de dag dat Ik alle eerstgeborenen in Egypteland trof, heb Ik Mij alle eerstgeborenen in Israël toegewijd, van mens tot dier. Dus behoren ze Mij; Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Jahweh sprak tot Moses in de woestijn van de Sinaï: ");
INSERT INTO nld1939_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Tel de zonen van Levi naar hun families en hun geslachten; alle personen van het mannelijk geslacht van één maand af moet ge inschrijven. ");
INSERT INTO nld1939_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moses schreef hen dus in, zoals het door Jahweh bevolen was. ");
INSERT INTO nld1939_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Dit zijn de namen van de zonen van Levi: Gersjon, Kehat en Merari. ");
INSERT INTO nld1939_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Dit zijn de namen van de zonen van Gersjon naar hun geslachten: Libni en Sjimi; ");
INSERT INTO nld1939_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","van de zonen van Kehat naar hun geslachten: Amram en Jishar, Chebron en Oezziël; ");
INSERT INTO nld1939_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","van de zonen van Merari naar hun geslachten: Machli en Moesji. Dit zijn de geslachten der Levieten naar hun families. ");
INSERT INTO nld1939_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Tot Gersjon behoorde het geslacht der Libnieten en dat der Sjimieten; dit waren de geslachten der Gersjonieten. ");
INSERT INTO nld1939_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Het volledig aantal mannelijke personen van één maand af, die van hen werden ingeschreven, bedroeg vijf en zeventig honderd. ");
INSERT INTO nld1939_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","De geslachten der Gersjonieten waren achter de tabernakel, in het westen, gelegerd. ");
INSERT INTO nld1939_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Het familiehoofd der Gersjonieten was Eljasaf, de zoon van Laël. ");
INSERT INTO nld1939_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","De zonen van Gersjon moesten voor de openbaringstent zorgen, voor de tabernakel, de tent, haar bedekking en het tapijt aan de ingang van de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","voor de gordijnen van de voorhof en het tapijt aan de ingang van de voorhof, die rond de tabernakel en het altaar ligt, en voor de touwen, met al wat daarbij te doen viel. ");
INSERT INTO nld1939_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Tot Kehat behoorde het geslacht der Amramieten, Jisharieten, Chebronieten en Oezziëlieten; dit waren de geslachten der Kehatieten. ");
INSERT INTO nld1939_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Het volledig aantal mannelijke personen van één maand af, bestemd voor de dienst van het heiligdom, bedroeg zes en tachtig honderd. ");
INSERT INTO nld1939_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","De geslachten der Kehatieten waren aan de ene zijde van de tabernakel gelegerd, en wel in het zuiden. ");
INSERT INTO nld1939_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Het familiehoofd van de geslachten der Kehatieten was Elisafan, de zoon van Oezziël. ");
INSERT INTO nld1939_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Zij moesten zorgen voor de ark, de tafel, de kandelaar, de altaren, voor alle gereedschappen van het heiligdom, nodig bij de dienst, voor het voorhangsel, en al wat daarbij te doen viel. ");
INSERT INTO nld1939_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Het opperhoofd van de Levieten was Elazar, de zoon van den priester Aäron; hij had het toezicht over hen, die voor het heiligdom moesten zorgen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Tot Merari behoorde het geslacht der Machlieten en dat der Moesjieten; dit waren de geslachten van Merari. ");
INSERT INTO nld1939_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Het volledig aantal mannelijke personen van één maand af, die van hen werden ingeschreven, bedroeg twee en zestig honderd. ");
INSERT INTO nld1939_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Het familiehoofd van de geslachten van Merari was Soeriël, de zoon van Abicháil. Zij waren aan de andere zijde van de tabernakel gelegerd, en dus in het noorden. ");
INSERT INTO nld1939_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","De taak der zonen van Merari was te zorgen voor de schotten, de bindlatten, de palen en voetstukken van de tabernakel, voor alle gereedschappen en voor al wat daarbij te doen viel, ");
INSERT INTO nld1939_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","voor de palen rond de voorhof met hun voetstukken, pinnen en touwen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aan de oostkant van de tabernakel, dus vóór de openbaringstent, waren Moses en Aäron met zijn zonen gelegerd. Zij hadden de zorg voor de dienst in het heiligdom ten behoeve van de Israëlieten; en zo een onbevoegde naderde, werd hij gedood. ");
INSERT INTO nld1939_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Het hele getal van de Levieten, die Moses op bevel van Jahweh volgens hun geslachten had ingeschreven, dus van alle mannelijke personen van één maand af, bedroeg twee en twintig duizend. ");
INSERT INTO nld1939_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","En Jahweh sprak tot Moses: Tel nu ook al de mannelijke eerstgeborenen der Israëlieten van één maand af, en neem het getal der personen op. ");
INSERT INTO nld1939_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ik ben Jahweh: Gij moet voor Mij de Levieten nemen in plaats van alle eerstgeborenen der Israëlieten, en het vee der Levieten in plaats van al het eerstgeborene onder het vee der Israëlieten. ");
INSERT INTO nld1939_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moses telde dus alle mannelijke eerstgeborenen der Israëlieten, zoals Jahweh hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Het hele getal der mannelijke eerstgeborenen van één maand af, die geteld waren, bedroeg twee en twintig duizend tweehonderd drie en zeventig. ");
INSERT INTO nld1939_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Jahweh sprak toen tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Neem de Levieten in plaats van alle eerstgeborenen der Israëlieten, en het vee der Levieten in plaats van hun vee. De Levieten zullen Mij behoren. Ik ben Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Voor de lossing van de tweehonderd drie en zeventig eerstgeborenen der Israëlieten, die het getal der Levieten overschrijden, ");
INSERT INTO nld1939_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","moet gij vijf sikkels per hoofd nemen, berekend naar het heilig gewicht, twintig gera de sikkel, ");
INSERT INTO nld1939_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","en het geld aan Aäron en zijn zonen geven als losprijs voor die boventalligen. ");
INSERT INTO nld1939_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moses hief dus het losgeld van hen, die er te veel waren, om door de Levieten te worden losgekocht. ");
INSERT INTO nld1939_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Als losgeld van deze eerstgeborenen der Israëlieten hief Moses dertienhonderd vijf en zestig heilige sikkels, ");
INSERT INTO nld1939_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","en gaf het losgeld aan Aäron en zijn zonen, juist zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Neemt van de Levieten het volledig getal der Kehatieten op naar hun geslachten en families, ");
INSERT INTO nld1939_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","van dertig jaar af tot vijftig jaar toe, en wel iedereen die in staat is om dienst te verrichten bij de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","De taak der Kehatieten in de openbaringstent strekt zich tot het hoogheilige uit. ");
INSERT INTO nld1939_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Wanneer het kamp wordt opgebroken, moeten Aäron en zijn zonen naar binnen gaan, het voorhangsel afnemen en de ark des Verbonds er mee bedekken; ");
INSERT INTO nld1939_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","daaroverheen moeten zij een dek van gelooide huiden leggen, daarover nog een geheel violet kleed uitspreiden, en er de draagstokken aan zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ook over de tafel van de toonbroden moeten zij een violet kleed spreiden, en daarop de schotels, pannen, schalen en bekers voor de plengoffers plaatsen, terwijl ook het bestendig brood daarop moet liggen; ");
INSERT INTO nld1939_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","daaroverheen moeten zij een karmozijnen kleed spreiden, het met een dekkleed van gelooide huiden bedekken, en er de draagstokken aan zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Dan moeten zij een violet kleed nemen, de kandelaar er mee bedekken met zijn lampen, snuiters, tangen, bakjes en alle vaatwerk voor de olie, waarmee zij hem verzorgen, ");
INSERT INTO nld1939_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","hem met al zijn benodigdheden in een dekkleed van gelooide huiden wikkelen, en op een draagbaar zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ook over het gouden altaar moeten zij een violet kleed spreiden, het met een dekkleed van gelooide huiden bedekken, en er de draagstokken aan zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Daarna moeten zij alle benodigdheden nemen, waarmee zij de dienst in het heiligdom verrichten, op een violet kleed zetten, ze bedekken met een dekkleed van gelooide huiden, en op een draagbaar zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Vervolgens moeten zij het altaar van as reinigen, en er een purperen kleed over heen spreiden; ");
INSERT INTO nld1939_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","daarop alle benodigdheden plaatsen, waarmee zij de dienst aan het altaar verrichten, de vuurpotten, vorken, schoppen, offerschalen, en alle vaatwerk van het altaar; daaroverheen een dekkleed van gelooide huiden spreiden, en er de draagstokken aan zetten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Eerst wanneer bij het opbreken van het kamp Aäron en zijn zonen gereed zijn gekomen met het bedekken van de heilige zaken en al wat daartoe behoort, mogen de Kehatieten binnen komen, om ze te vervoeren. Zij mogen de heilige zaken niet aanraken; anders zouden zij sterven. Dit is het gedeelte van de openbaringstent, dat door de Kehatieten moet worden gedragen. ");
INSERT INTO nld1939_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Bovendien moet Elazar, de zoon van den priester Aäron, zorg dragen voor de olie van de kandelaar, de wierook, het altijddurend spijsoffer en de zalfolie; hij heeft dus de zorg voor heel de tabernakel en alles wat daarin is, voor de heilige zaken en haar toebehoren. ");
INSERT INTO nld1939_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","En Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Zorgt er voor, dat de tak van het Kehatietengeslacht niet uit de kring der Levieten wordt uitgeroeid. ");
INSERT INTO nld1939_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Doet dus voor hen als volgt, opdat zij leven en niet sterven, wanneer zij het hoogheilige naderen. Aäron en zijn zonen moeten naar binnen gaan, en ieder van hen aanwijzen, wat hij te doen heeft, en wat hij moet dragen. ");
INSERT INTO nld1939_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Zelf mogen zij niet binnengaan, om zelfs maar een ogenblik de heilige zaken te zien; anders zouden zij sterven. ");
INSERT INTO nld1939_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Neem ook het volledig getal van de Gersjonieten op naar hun families en hun geslachten; ");
INSERT INTO nld1939_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","van dertig jaar af tot vijftig jaar toe moet gij allen inschrijven, die in staat zijn dienst te verrichten bij de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dit zal de taak zijn van het geslacht der Gersjonieten bij de dienst en bij het vervoer. ");
INSERT INTO nld1939_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Zij moeten de tentdoeken van de tabernakel dragen, de openbaringstent, haar dekkleden, de bedekking van gelooide huiden, die daaroverheen ligt, het tapijt voor de ingang van de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","de gordijnen van de voorhof en het tapijt bij de ingang der poort van de voorhof, die rond de tabernakel en het altaar ligt, en de touwen met alle benodigdheden voor het werk; alles wat daarmee moet gebeuren, zullen zij verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Al het werk van de zonen der Gersjonieten moet steeds op aanwijzing van Aäron en zijn zonen geschieden, zowel bij het vervoer, als bij de dienst; al wat ze hebben te dragen, moet ge hun stuk voor stuk aanwijzen. ");
INSERT INTO nld1939_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Dit zal de taak van het geslacht van de zonen der Gersjonieten zijn bij de openbaringstent, en hun werkzaamheden zullen onder leiding staan van Itamar, den zoon van den priester Aäron. ");
INSERT INTO nld1939_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ook de Merarieten moet ge inschrijven naar hun geslachten en families. ");
INSERT INTO nld1939_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Van dertig jaar af tot vijftig jaar toe moet ge allen inschrijven, die in staat zijn, dienst te verrichten bij de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Dit zal hun taak zijn bij het vervoer en de werkzaamheden aan de openbaringstent: de schotten van de tabernakel met de bindlatten, de palen met hun voetstukken, ");
INSERT INTO nld1939_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","de palen van de voorhof rondom met hun voetstukken, pinnen en touwen, met wat er verder toe behoort en al de werkzaamheden daaraan verbonden; stuk voor stuk moet ge hun aanwijzen, wat ze hebben te dragen. ");
INSERT INTO nld1939_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Dit zal de taak zijn van het geslacht der Merarieten, en al hun werkzaamheden aan de openbaringstent zullen onder leiding staan van Itamar, den zoon van den priester Aäron. ");
INSERT INTO nld1939_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Daarna schreven Moses, Aäron en de leiders der gemeenschap alle zonen der Kehatieten in naar hun geslachten en families, ");
INSERT INTO nld1939_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","van dertig jaar af tot vijftig jaar toe, die geschikt waren om de dienst bij de openbaringstent te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Naar hun geslachten geteld, bedroeg hun aantal tweeduizend zevenhonderd vijftig man. ");
INSERT INTO nld1939_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Dit waren alle ingeschrevenen der Kehatietengeslachten, die dienst moesten doen bij de openbaringstent, en die Moses en Aäron hadden ingeschreven, zoals Jahweh het door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Alle ingeschrevenen van de Gersjonieten naar hun geslachten en families, ");
INSERT INTO nld1939_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","van dertig jaar af tot vijftig jaar toe, die geschikt waren om dienst te verrichten bij de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","bedroegen tweeduizend zeshonderd dertig man, naar hun geslachten en families geteld. ");
INSERT INTO nld1939_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Dit waren alle gemonsterden van de Gersjonietengeslachten, die dienst moesten doen bij de openbaringstent, en die Moses en Aäron hadden ingeschreven, zoals Jahweh het door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Alle ingeschrevenen van de Merarietengeslachten naar hun geslachten en families, ");
INSERT INTO nld1939_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","van dertig jaar af tot vijftig jaar toe, die geschikt waren om dienst te verrichten bij de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","bedroegen drieduizend tweehonderd man, naar hun geslachten geteld. ");
INSERT INTO nld1939_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Dit waren de ingeschrevenen van de Merarietengeslachten, die Moses en Aäron hadden ingeschreven, zoals Jahweh het door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Alle ingeschreven Levieten, die Moses en Aäron met de leiders van Israël naar hun geslachten en families hadden ingeschreven, ");
INSERT INTO nld1939_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","van dertig jaar af tot vijftig jaar toe, en die geschikt waren voor het dienstwerk, en het vervoer van de openbaringstent, ");
INSERT INTO nld1939_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","telden achtduizend vijfhonderd tachtig man. ");
INSERT INTO nld1939_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Zoals Jahweh het door Moses bevolen had, gaf men ieder zijn taak voor de dienst en het vervoer, en werden zij ingeschreven, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Beveel de Israëlieten, dat zij alle melaatsen, allen die aan vloeiing lijden, en allen, die zich aan een lijk verontreinigd hebben, uit het kamp verwijderen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Zowel mannen als vrouwen moet ge buiten het kamp sturen, opdat ze hun kamp, waar Ik te midden van hen woon, niet verontreinigen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","De Israëlieten deden het, en zonden ze buiten het kamp; zoals Jahweh het Moses bevolen had, voerden de Israëlieten het uit. ");
INSERT INTO nld1939_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Zeg aan de Israëlieten: Wanneer een man of vrouw een zonde tegen den evenmens begaat, waardoor hij zich aan Jahweh vergrijpt en schuld op zich laadt, ");
INSERT INTO nld1939_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","dan moeten zij de zonde, die ze hebben begaan, bekennen, de volle waarde van het ontvreemde vergoeden, het vijfde gedeelte er aan toevoegen, en het teruggeven aan wien het ontvreemd werd. ");
INSERT INTO nld1939_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Wanneer die man geen losser heeft, aan wien het ontvreemde kan worden teruggegeven, dan moet het ontvreemde aan Jahweh worden vergoed, en met den ram der verzoening aan den priester worden gegeven, die verzoening voor hem verkrijgt. ");
INSERT INTO nld1939_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bovendien zullen alle heilige cijnzen, die de Israëlieten aan Jahweh brengen, den priester behoren. ");
INSERT INTO nld1939_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ook de gewijde zaken, die iemand aan den priester geeft, zullen voor dezen zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Beveel de Israëlieten, en zeg hun: Wanneer een vrouw zich heeft misdragen en aan haar man ontrouw is geweest, ");
INSERT INTO nld1939_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","doordat een andere man gemeenschap met haar heeft gehad, maar het voor haar man verborgen is gebleven, daar zij zich in het geheim heeft bezoedeld, en er ook geen getuige tegen haar opstaat, daar zij niet op heterdaad is betrapt; ");
INSERT INTO nld1939_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","of wanneer de man jaloers wordt, zodat hij zijn vrouw gaat verdenken, die zich inderdaad heeft bezoedeld: of wanneer hij jaloers wordt, zodat hij zijn vrouw gaat verdenken, ofschoon zij zich niet heeft bezoedeld: ");
INSERT INTO nld1939_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","dan moet die man zijn vrouw voor den priester leiden. Hij moet voor haar een tiende efa gerst als haar offergave brengen, maar er geen olie over uitgieten en er geen wierook aan toe voegen; want het is een spijsoffer der jaloersheid, een herinneringsoffer, dat zonde doet gedenken. ");
INSERT INTO nld1939_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","De priester moet haar naar voren doen komen, om haar voor het aanschijn van Jahweh te plaatsen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Dan moet de priester heilig water in een aarden vat nemen, wat stof van de vloer van de tabernakel rapen, en dat in het water doen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Vervolgens moet de priester de vrouw voor het aanschijn van Jahweh plaatsen, haar hoofdhaar losmaken en het spijsoffer ter herinnering in haar handen leggen: het is een spijsoffer van ijverzucht. En terwijl de priester het bittere vloekwater in de hand houdt, ");
INSERT INTO nld1939_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","zal hij de vrouw bezweren en tot haar zeggen: Zo geen man gemeenschap met u heeft gehad, zo ge u niet misdragen en bezoedeld hebt, sinds ge uw man behoort, zult ge door dit bittere vloekwater niet worden gedeerd! ");
INSERT INTO nld1939_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Maar wanneer ge u misdragen en bezoedeld hebt, sinds ge uw man behoort, doordat een andere man dan de uwe gemeenschap met u heeft gehad, ");
INSERT INTO nld1939_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","—nu zal de priester over de vrouw de vervloeking uitspreken en tot de vrouw zeggen—”dan zal Jahweh u tot een vloek en een verwensing maken onder uw volk, door uw heup te doen invallen en uw buik te doen zwellen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Dit vloekwater zal in uw binnenste dringen, om uw buik te doen zwellen en uw heup te doen invallen!” En de vrouw moet antwoorden: Amen, Amen! ");
INSERT INTO nld1939_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Dan moet de priester deze vervloekingen op een blad schrijven, ze in het bittere vloekwater uitwissen, ");
INSERT INTO nld1939_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","om het die vrouw te laten drinken, zodat het bittere vloekwater in haar binnenste dringt. ");
INSERT INTO nld1939_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Daarna moet de priester het spijsoffer van jaloersheid uit de hand van de vrouw nemen, het Jahweh als strekoffer aanbieden en naar het altaar brengen; ");
INSERT INTO nld1939_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","dan moet de priester van het spijsoffer een handvol als reukoffer nemen, en op het altaar in rook doen opgaan. Tenslotte zal hij de vrouw het water laten drinken. ");
INSERT INTO nld1939_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Heeft hij haar het water doen drinken, dan zal, zo zij zich bezoedeld heeft en haar man ontrouw is geweest, haar buik zwellen en haar heup invallen, zodra het bittere vloekwater in haar binnenste dringt, en die vrouw zal een vloek worden onder haar volk. ");
INSERT INTO nld1939_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Maar zo die vrouw zich niet heeft bezoedeld, doch rein is, dan blijft ze ongedeerd, en wordt met kinderen gezegend. ");
INSERT INTO nld1939_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Dit is dus de wet op de jaloersheid: Wanneer een vrouw zich heeft misdragen en bezoedeld, sinds ze aan haar man behoort, ");
INSERT INTO nld1939_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","of wanneer een man jaloers wordt, en hij zijn vrouw gaat verdenken, dan zal hij zijn vrouw voor het aanschijn van Jahweh plaatsen, en de priester zal heel deze wet op haar toepassen. ");
INSERT INTO nld1939_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","De man zal dan vrij zijn van schuld, maar de vrouw zal haar schuld moeten boeten. ");
INSERT INTO nld1939_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Beveel de Israëlieten, en zeg hun: Wanneer een man of vrouw een gelofte van nazireaat heeft afgelegd, om zich aan Jahweh te wijden, ");
INSERT INTO nld1939_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dan moet hij zich van wijn en sterke drank onthouden; hij mag zelfs geen azijn uit wijn of uit sterke drank en geen druivensap drinken, noch verse of gedroogde druiven eten. ");
INSERT INTO nld1939_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Al de tijd van zijn nazireaat mag hij niets eten, wat van de wijnstok wordt gewonnen, zelfs geen pitten en schillen. ");
INSERT INTO nld1939_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Al de tijd van zijn nazireaatsgelofte mag ook geen scheermes over zijn hoofd gaan; tot de dagen voorbij zijn, waarvoor hij zich aan Jahweh gewijd heeft, blijft hij Jahweh toegeheiligd, en moet hij zijn hoofdhaar laten groeien. ");
INSERT INTO nld1939_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ook mag hij al de tijd, dat hij aan Jahweh is gewijd, bij geen lijk komen; ");
INSERT INTO nld1939_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","zelfs aan zijn vader of moeder, broer of zuster mag hij zich na hun dood niet verontreinigen. Want het nazireaat van zijn God rust op zijn hoofd; ");
INSERT INTO nld1939_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","heel de tijd van zijn nazireaat is hij aan Jahweh gewijd. ");
INSERT INTO nld1939_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Sterft er onverwacht iemand in zijn nabijheid, en verontreinigt hij zo zijn gewijd hoofd, dan moet hij op de zevende dag, de dag waarop hij weer rein wordt, zijn hoofd scheren. ");
INSERT INTO nld1939_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Op de achtste dag moet hij twee tortels of twee jonge duiven naar den priester brengen bij de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","De priester zal er een als zondeoffer en een als brandoffer opdragen, en voor hem verzoening verkrijgen voor de zonde door aanraking van het lijk. Op dezelfde dag moet hij opnieuw zijn hoofd heiligen, ");
INSERT INTO nld1939_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","zich weer evenlang als vroeger als nazireër aan Jahweh wijden, en een eenjarig lam als schuldoffer brengen. De vorige dagen van zijn nazireaat tellen dus niet mee, omdat hij zijn nazireaat heeft ontwijd. ");
INSERT INTO nld1939_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","En dit is de wet voor den nazireër, als de tijd van zijn nazireaat is geëindigd: men moet hem naar de ingang van de openbaringstent leiden, ");
INSERT INTO nld1939_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","en hij moet als zijn gave aan Jahweh brengen: een gaaf, eenjarig lam als brandoffer, een gaaf, eenjarig ooilam als zondeoffer, en een gaven ram als vredeoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","daarenboven een korf met ongedesemde broden van meelbloem, koeken met olie aangemaakt, en ongedesemde vlaas met olie bestreken, met het spijs- en plengoffer, dat daarbij hoort. ");
INSERT INTO nld1939_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","De priester zal dat voor het aanschijn van Jahweh brengen, en zijn zonde- en brandoffer opdragen. ");
INSERT INTO nld1939_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Den ram en de korf met ongedesemde broden zal de priester met het spijs- en plengoffer, dat daarbij hoort, als een vredeoffer aan Jahweh opdragen. ");
INSERT INTO nld1939_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Daarna moet de nazireër bij de ingang van de openbaringstent zijn gewijd hoofd scheren, het haar van zijn nazireaat nemen en in het vuur werpen, dat onder het vredeoffer brandt. ");
INSERT INTO nld1939_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","En zodra de nazireër zich het haar van zijn nazireaat heeft afgeschoren, moet de priester het gekookte schouderstuk van den ram, een ongedesemde koek uit de korf en een ongedesemde vla nemen, ze in de handen van den nazireër leggen, ");
INSERT INTO nld1939_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","en ze als een strekoffer voor het aanschijn van Jahweh aanbieden; het valt, met de borst van het strekoffer en de schenkel van het hefoffer, als iets heiligs den priester ten deel. Daarna mag de nazireër wijn drinken. ");
INSERT INTO nld1939_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Dit is voor den nazireër, die de gelofte heeft afgelegd, de wet over zijn gave aan Jahweh op grond van zijn nazireaat, afgezien van wat hij vrijwillig brengt; krachtens de wet van zijn nazireaat, moet hij alles zo volbrengen, als hij het Jahweh beloofd heeft. ");
INSERT INTO nld1939_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nog sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Zeg aan Aäron en zijn zonen: Zo moet ge de zegen over Israëls kinderen uitspreken: ");
INSERT INTO nld1939_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Jahweh zegene u, En behoede u; ");
INSERT INTO nld1939_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Jahweh doe zijn aanschijn over u lichten, En zij u genadig; ");
INSERT INTO nld1939_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jahweh wende tot u zijn gelaat, En schenke u de vrede! ");
INSERT INTO nld1939_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Zo zullen zij mijn Naam op de kinderen Israëls doen rusten, en zal Ik hen zegenen. ");
INSERT INTO nld1939_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Toen Moses gereed was gekomen met het oprichten van de tabernakel, en hem, met al wat er bij hoorde, had gezalfd en gewijd, en eveneens het altaar met heel zijn toebehoren had gezalfd en gewijd, ");
INSERT INTO nld1939_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","kwamen de aanvoerders van Israël naderbij. Het waren de familie- en stamhoofden, die over de gemonsterden stonden. ");
INSERT INTO nld1939_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Zij brachten als hun gaven voor het aanschijn van Jahweh zes overdekte wagens en twaalf runderen; twee aanvoerders telkens één wagen en ieder één rund. Toen zij ze voor de tabernakel hadden gebracht, ");
INSERT INTO nld1939_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Neem ze van hen aan; ze moeten voor de dienst van de openbaringstent worden bestemd, en ge moet ze aan de Levieten geven, naar gelang ieder ze voor zijn werk nodig heeft. ");
INSERT INTO nld1939_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moses nam dus de wagens en de runderen aan, en gaf ze aan de Levieten. ");
INSERT INTO nld1939_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Twee wagens en vier runderen gaf hij aan de zonen van Gersjon, naar verhouding tot hun werk. ");
INSERT INTO nld1939_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Vier wagens en acht runderen gaf hij, naar verhouding tot hun werk, aan de zonen van Merari, die onder Itamar, den zoon van den priester Aäron stonden. ");
INSERT INTO nld1939_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Aan de zonen van Kehat gaf hij er geen, omdat zij de heilige zaken, die hun waren toevertrouwd, op hun schouders moesten dragen. ");
INSERT INTO nld1939_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Toen de aanvoerders ook hun wijdingsgave voor het altaar wilden brengen op de dag, dat het gezalfd werd, en hun gaven voor het altaar wilden plaatsen, ");
INSERT INTO nld1939_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","sprak Jahweh tot Moses: Laat iedere aanvoerder op een afzonderlijke dag zijn gave brengen voor de wijding van het altaar. ");
INSERT INTO nld1939_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Op de eerste dag bracht Naässon, de zoon van Amminadab uit de stam van Juda, zijn gave. ");
INSERT INTO nld1939_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Zijn geschenk bestond uit een zilveren schotel ter waarde van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Naässon, den zoon van Amminadab. ");
INSERT INTO nld1939_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Op de tweede dag bracht Netanel, de zoon van Soear, de vorst van Issakar, zijn gave. ");
INSERT INTO nld1939_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Het geschenk, dat hij bracht, bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Netanel, den zoon van Soear. ");
INSERT INTO nld1939_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Op de derde dag de vorst van de zonen van Zabulon, Eliab, de zoon van Chelon. ");
INSERT INTO nld1939_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Eliab, den zoon van Chelon. ");
INSERT INTO nld1939_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Op de vierde dag de vorst van de zonen van Ruben, Elisoer, de zoon van Sjedeoer. ");
INSERT INTO nld1939_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Elisoer, den zoon van Sjedeoer. ");
INSERT INTO nld1939_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Op de vijfde dag de vorst van de zonen van Simeon, Sjeloemiël, de zoon van Soerisjaddai. ");
INSERT INTO nld1939_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Sjeloemiël, den zoon van Soerisjaddai. ");
INSERT INTO nld1939_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Op de zesde dag de vorst van de zonen van Gad, Eljasaf, de zoon van Deoeël. ");
INSERT INTO nld1939_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Eljasaf, den zoon van Deoeël. ");
INSERT INTO nld1939_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Op de zevende dag de vorst van de zonen van Efraïm, Elisjama, de zoon van Ammihoed. ");
INSERT INTO nld1939_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Elisjama, den zoon van Ammihoed. ");
INSERT INTO nld1939_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Op de achtste dag de vorst van de zonen van Manasse, Gamliël, de zoon van Pedasoer. ");
INSERT INTO nld1939_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Gamliël, den zoon van Pedasoer. ");
INSERT INTO nld1939_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Op de negende dag de vorst van de zonen van Benjamin, Abidan, de zoon van Gidoni. ");
INSERT INTO nld1939_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Abidan, den zoon van Gidoni. ");
INSERT INTO nld1939_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Op de tiende dag de vorst van de zonen van Dan, Achiézer, de zoon van Ammisjaddai. ");
INSERT INTO nld1939_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Achiézer, den zoon van Ammisjaddai. ");
INSERT INTO nld1939_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Op de elfde dag de vorst van de zonen van Aser, Pagiël, de zoon van Okran. ");
INSERT INTO nld1939_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Pagiël, den zoon van Okran. ");
INSERT INTO nld1939_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Op de twaalfde dag de vorst van de zonen van Neftali, Achira, de zoon van Enan. ");
INSERT INTO nld1939_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Zijn geschenk bestond uit een zilveren schotel van honderd dertig sikkels, en een zilveren schaal van zeventig sikkels volgens het heilig gewicht, beide gevuld met meelbloem, met olie aangemaakt, voor een spijsoffer; ");
INSERT INTO nld1939_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","uit een schaaltje van tien gouden sikkels gevuld met wierook; ");
INSERT INTO nld1939_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","uit een jongen stier, een ram, een eenjarig lam voor een brandoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","een geitebok voor een zondeoffer, ");
INSERT INTO nld1939_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","en twee runderen, vijf rammen, vijf bokken, vijf eenjarige lammeren voor een vredeoffer. Dit was het geschenk van Achira, den zoon van Enan. ");
INSERT INTO nld1939_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Dit was dus de wijdingsgave der aanvoerders van Israël voor het altaar op de dag, dat het gezalfd werd: twaalf zilveren schotels, twaalf zilveren schalen, twaalf gouden schaaltjes. ");
INSERT INTO nld1939_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Iedere schotel was honderd dertig zilveren sikkels waard, iedere schaal zeventig; al het zilver der vaten bedroeg vier en twintig honderd sikkels volgens het heilig gewicht. ");
INSERT INTO nld1939_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Twaalf gouden schaaltjes met wierook gevuld, ieder van tien gouden sikkels volgens het heilig gewicht, al het goud van die schaaltjes bedroeg honderd twintig gouden sikkels. ");
INSERT INTO nld1939_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Het rundvee voor het brandoffer bedroeg in het geheel twaalf jonge stieren, twaalf rammen, en twaalf eenjarige lammeren, met de daarbij horende spijsoffers. Voor het zondeoffer bedroeg het twaalf geitebokken. ");
INSERT INTO nld1939_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Het rundvee voor het vredeoffer bedroeg in het geheel vier en twintig stieren, zestig rammen, zestig bokken en zestig eenjarige lammeren. Dit was de wijdingsgave voor het altaar, nadat het gezalfd was. ");
INSERT INTO nld1939_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Wanneer Moses de openbaringstent binnentrad, om met Jahweh te spreken, hoorde hij de stem, die tot hem sprak, boven het verzoendeksel op de Verbondsark tussen de beide cherubs. Zo sprak Hij tot hem. ");
INSERT INTO nld1939_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Beveel Aäron en zeg hem:Wanneer ge de lampen opstelt, moeten de zeven lampen naar de voorzijde van de kandelaar haar licht verspreiden. ");
INSERT INTO nld1939_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aäron deed het, en plaatste de lampen zo, dat ze naar de voorkant van de kandelaar waren gekeerd, zoals Jahweh het bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","De kandelaar was uit goud gedreven, zowel zijn schacht als zijn bloesems waren drijfwerk. Naar het model door Jahweh aan Moses getoond, had hij de kandelaar gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Zonder de levieten van de Israëlieten af en reinig ze. ");
INSERT INTO nld1939_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Zo zult ge doen, om hen te reinigen: Ge moet ze met reinigingswater besprenkelen, ze moeten hun hele lichaam scheren en hun kleren wassen; dan zijn ze rein. ");
INSERT INTO nld1939_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Dan moeten ze een jongen stier gaan halen, en meelbloem, met olie aangemaakt, als het spijsoffer, dat daarbij hoort, terwijl gij een anderen jongen stier voor het zondeoffer moet nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Vervolgens moet ge de levieten voor de openbaringstent doen treden, en heel de gemeenschap der Israëlieten verzamelen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Doe de levieten dan voor het aanschijn van Jahweh treden, en laten de kinderen Israëls hun de handen opleggen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Dan moet Aäron de levieten als een strekoffer van Israëls kinderen Jahweh aanbieden. Zo zullen zij voor de dienst van Jahweh worden bestemd. ");
INSERT INTO nld1939_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Daarna moeten de levieten hun handen op de kop der jonge stieren leggen, en den een moet ge als zondeoffer, den ander als brandoffer aan Jahweh opdragen, om verzoening te verkrijgen voor de levieten. ");
INSERT INTO nld1939_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ten slotte moet ge de levieten voor Aäron en zijn zonen plaatsen, en hen als een strekoffer Jahweh aanbieden. ");
INSERT INTO nld1939_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Zo moet ge de levieten van de Israëlieten afzonderen en zullen ze Mij toebehoren! ");
INSERT INTO nld1939_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","En nadat ge ze zo hebt gereinigd en als een strekoffer hebt aangeboden, mogen de levieten hun dienst bij de openbaringstent beginnen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Want ze zijn uit de Israëlieten genomen, en te mijner beschikking gehouden; in plaats van wat de moederschoot opent, in plaats van alle eerstgeborenen van Israëls kinderen heb Ik ze voor Mijzelf behouden. ");
INSERT INTO nld1939_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Want Mij behoren alle eerstgeborenen van Israëls kinderen, mens en dier; op de dag, dat Ik alle eerstgeborenen sloeg in Egypte, heb Ik ze Mij toegewijd. ");
INSERT INTO nld1939_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Maar Ik neem de levieten in plaats van alle eerstgeborenen van Israëls kinderen, ");
INSERT INTO nld1939_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","en Ik neem ze uit de Israëlieten en stel ze ter beschikking van Aäron en zijn zonen, om voor de Israëlieten de dienst in de openbaringstent te verrichten, om verzoening te verkrijgen voor de Israëlieten, en om de kinderen Israëls voor onheil te behoeden, als zij tot het heiligdom zouden naderen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moses, Aäron en heel de gemeenschap der Israëlieten deden dus met de levieten, zoals Jahweh Moses omtrent de levieten bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","De levieten reinigden zich van zonde, en wasten hun kleren; en Aäron bood ze Jahweh als strekoffer aan, verkreeg verzoening voor hen en reinigde hen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Daarna begonnen de levieten hun dienst bij de openbaringstent onder toezicht van Aäron en zijn zonen. Wat Jahweh omtrent de levieten aan Moses bevolen had, bracht men nauwkeurig ten uitvoer. ");
INSERT INTO nld1939_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dit is de wet voor de levieten: Van vijf en twintig jaar af is hij verplicht dienst te verrichten bij de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Na zijn vijftigste jaar is hij van zijn verplichting ontslagen, en behoeft geen dienst meer te doen. ");
INSERT INTO nld1939_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hij mag zijn broeders wel behulpzaam zijn bij de openbaringstent in het uitoefenen van hun ambtsplichten, maar eigenlijk werk behoeft hij niet meer te doen. Deze beschikking zult ge maken omtrent de ambtsplichten der levieten. ");
INSERT INTO nld1939_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Jahweh sprak in de woestijn van de Sinaï tot Moses in de eerste maand van het tweede jaar na hun uittocht uit Egypte: ");
INSERT INTO nld1939_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","De Israëlieten moeten het Pascha vieren op de daarvoor vastgestelde tijd. ");
INSERT INTO nld1939_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Op de veertiende dag van deze maand, bij het vallen van de avond, moeten zij het op de juiste tijd vieren, en daarbij al de voorschriften en wetten erover in acht nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moses beval dus de Israëlieten, het Pascha te vieren. ");
INSERT INTO nld1939_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","En de Israëlieten vierden het in de woestijn van de Sinaï op de veertiende dag der eerste maand, bij het vallen van den avond, en zij namen alles in acht, wat Jahweh Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Maar er waren toen enige mannen, die zich aan een lijk hadden verontreinigd, en dus op die dag het Pascha niet konden vieren. Die mannen verschenen die dag voor Moses en Aäron, ");
INSERT INTO nld1939_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","en zeiden tot hen: Wij hebben ons aan een lijk verontreinigd. Maar waarom is het ons nu niet vergund, het offer van Jahweh te brengen op de vastgestelde tijd te midden van de Israëlieten? ");
INSERT INTO nld1939_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses gaf hun ten antwoord: Blijft hier wachten; dan ga ik horen, wat Jahweh over u beveelt. ");
INSERT INTO nld1939_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","En Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Zeg aan de Israëlieten: Wanneer iemand van u of uw nageslacht zich aan een lijk heeft verontreinigd, of ver weg is op reis, dan moet hij toch het Pascha houden ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ze moeten het dan vieren in de tweede maand, op de veertiende dag, bij het vallen van de avond. Ook zij moeten het met ongedesemde broden en bittere kruiden eten, ");
INSERT INTO nld1939_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","mogen er niets van tot de volgende morgen bewaren, geen been er van breken, en moeten alle voorschriften van het Pascha er bij in acht nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Maar wie verzuimt, het Pascha te vieren, ofschoon hij rein is en niet op reis, zal van zijn volk worden afgesneden, omdat hij het offer van Jahweh niet op de vastgestelde tijd heeft gebracht. Zo iemand zal zijn zonde boeten! ");
INSERT INTO nld1939_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Wanneer een vreemdeling bij u woont, en het Pascha ter ere van Jahweh wil vieren, moet ook hij de voorschriften en wetten van het Pascha in acht nemen. Hetzelfde voorschrift geldt voor u allen, voor den vreemdeling zowel als voor het kind van het land. ");
INSERT INTO nld1939_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Op de dag, dat men de tabernakel had opgericht, bedekte de wolk de tabernakel van de verbondstent, en des avonds rustte er als het ware een vuurgloed op de tabernakel tot aan de morgen. ");
INSERT INTO nld1939_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Zo bleef het voortdurend: de wolk bedekte hem overdag, en een vuurgloed des nachts. ");
INSERT INTO nld1939_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Zodra nu de wolk zich boven de tent verhief, trokken de Israëlieten verder, en op de plaats, waar de wolk zich neerliet, sloegen zij hun legerplaats op. ");
INSERT INTO nld1939_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Op bevel van Jahweh trokken de Israëlieten verder, op bevel van Jahweh sloegen zij hun legerplaats op, en zolang de wolk op de tabernakel bleef rusten, bleven zij in hun legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Wanneer de wolk langere tijd op de tabernakel bleef rusten, richtten de Israëlieten zich naar Jahweh’s beschikking, en trokken niet verder. ");
INSERT INTO nld1939_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Soms bleef de wolk maar enige dagen boven de tabernakel; ook dan legerden zij zich op Jahweh’s bevel en trokken verder op Jahweh’s bevel. ");
INSERT INTO nld1939_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Soms bleef de wolk slechts van de avond tot de morgen; maar als de wolk zich des morgens verhief, braken zij op. En of het dag was of nacht, als de wolk zich verhief, braken zij op. ");
INSERT INTO nld1939_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","En of de wolk twee dagen, of een maand of nog langer, op de tabernakel bleef rusten, zolang zij daarop bleef rusten, bleven de Israëlieten gelegerd en braken niet op; eerst als zij opsteeg, trokken zij verder. ");
INSERT INTO nld1939_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Dus op bevel van Jahweh sloegen zij hun legerplaats op, en op bevel van Jahweh trokken zij verder. Steeds richtten zij zich naar de beschikking van Jahweh, zoals Jahweh het door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nog sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Maak u twee zilveren trompetten van drijfwerk. Zij zullen dienen, om de gemeenschap bijeen te roepen en de kampen te doen opbreken. ");
INSERT INTO nld1939_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Blaast men op beide, dan moet heel de gemeenschap zich bij u verzamelen aan de ingang van de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Blaast men er één, dan moeten de aanvoerders, de stamhoofden van Israël, zich bij u vervoegen. ");
INSERT INTO nld1939_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Maar laat ge ze schetteren, dan moeten de kampen opbreken, die ten oosten zijn gelegerd; ");
INSERT INTO nld1939_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","laat ge ze voor de tweede maal schetteren, dan moeten de kampen opbreken, die in het zuiden zijn gelegerd; laat ge ze voor de derde maal schetteren, dan moeten de kampen opbreken, die in het westen zijn gelegerd; en laat ge ze voor de vierde maal schetteren, dan moeten de kampen opbreken, die in het noorden zijn gelegerd. Het schetteren is dus een teken, om op te breken; ");
INSERT INTO nld1939_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","om de gemeente bijeen te roepen, moet ge blazen, maar niet schetteren. ");
INSERT INTO nld1939_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","De zonen van Aäron, de priesters, moeten op de trompetten blazen; dit is een eeuwige wet van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","En wanneer gij in uw land ten strijde trekt tegen den vijand, die u belaagt, dan moet ge op de trompetten schetteren; zo zult ge bij Jahweh, uw God, in herinnering worden gebracht, en van uw vijanden worden verlost. ");
INSERT INTO nld1939_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ook op uw vreugdedagen en feesten, en op de eerste dag van uw maanden, moet ge bij uw brand- en uw vredeoffers op de trompetten blazen; zo zullen zij u bij uw God in herinnering brengen. Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","In het tweede jaar, in de tweede maand, op de twintigste dag van de maand verhief zich de wolk boven de verbondstabernakel. ");
INSERT INTO nld1939_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Toen braken de Israëlieten op, en trokken van halte tot halte uit de woestijn van de Sinaï weg. Eerst in de woestijn Paran bleef de wolk rusten. ");
INSERT INTO nld1939_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Dit was de eerste keer, dat zij optrokken volgens Jahweh’s bevel, dat hun door Moses was meegedeeld. ");
INSERT INTO nld1939_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Het eerst trok de banier van het leger der Judeërs op, naar hun afdelingen ingedeeld. Over hun eigen afdeling stond Naässon, de zoon van Amminadab; ");
INSERT INTO nld1939_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","over de afdeling van de stam der Issakarieten stond Netanel, de zoon van Soear; ");
INSERT INTO nld1939_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","over de afdeling van de stam der Zabulonieten stond Eliab, de zoon van Chelon. ");
INSERT INTO nld1939_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Dan werd de tabernakel neergehaald, en braken de zonen van Gersjon en Merari op, die de tabernakel moesten dragen. ");
INSERT INTO nld1939_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Daarna trok de banier van het leger der Rubenieten op, naar hun afdelingen ingedeeld. Over hun eigen afdeling stond Elisoer, de zoon van Sjedeoer; ");
INSERT INTO nld1939_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","over de afdeling van de stam der Simeonieten stond Sjeloemiël, de zoon van Soerisjaddai; ");
INSERT INTO nld1939_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","over de afdeling van de stam der Gadieten stond Eljasaf, de zoon van Deoeël. ");
INSERT INTO nld1939_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Dan braken de zonen van Kehat op, die de heilige zaken moesten dragen. Als zij ergens aankwamen, had men de tabernakel weer opgericht. ");
INSERT INTO nld1939_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Vervolgens trok de banier van het leger der Efraïmieten op, naar hun afdelingen ingedeeld. Over hun eigen afdeling stond Elisjama, de zoon van Ammihoed; ");
INSERT INTO nld1939_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","over de afdeling van de stam der Manassieten stond Gamliël, de zoon van Pedasoer; ");
INSERT INTO nld1939_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","over de afdeling van de stam der Benjamieten stond Abidan, de zoon van Gidoni. ");
INSERT INTO nld1939_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Als achterhoede van alle legers trok de banier van het leger der Danieten op, naar hun afdelingen ingedeeld. Over hun eigen afdeling stond Achiézer, de zoon van Ammisjaddai. ");
INSERT INTO nld1939_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Over de afdeling van de stam der Aserieten stond Pagiël, de zoon van Okran; ");
INSERT INTO nld1939_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","over de afdeling van de stam der Neftalieten stond Achira, de zoon van Enan. ");
INSERT INTO nld1939_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Dit was de rangschikking der Israëlieten, ingedeeld naar hun afdelingen. Toen zij vertrokken, ");
INSERT INTO nld1939_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","sprak Moses tot zijn schoonvader Chobab, den zoon van Reoeël, den Midjaniet: Wij vertrekken naar de plaats, die Jahweh ons beloofd heeft te geven. Ga met ons mee, en wij zullen goed voor u zijn; want Jahweh heeft geluk beloofd aan Israël. ");
INSERT INTO nld1939_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Maar hij gaf hem ten antwoord: Ik ga niet met u mee, maar ik vertrek naar mijn land en mijn geboortegrond. ");
INSERT INTO nld1939_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Hij sprak: Verlaat ons toch niet; want gij kent de geschikte legerplaatsen voor ons in de woestijn, en gij kunt onze gids zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Wanneer gij met ons meegaat, dan zullen wij ook u in de voorspoed doen delen, die Jahweh ons zal schenken. ");
INSERT INTO nld1939_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Zo trokken zij weg van de berg van Jahweh drie dagreizen ver. Want de ark van Jahweh’s Verbond ging drie dagen lang voor hen uit, om voor hen een rustplaats te zoeken; ");
INSERT INTO nld1939_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ook toen zij uit de legerplaats waren opgetrokken, bleef de wolk van Jahweh overdag boven hen. ");
INSERT INTO nld1939_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Als de ark dan optrok, sprak Moses: Rijs op, Jahweh, en uw vijanden stuiven uiteen, Die U haten vluchten weg voor uw aanschijn! ");
INSERT INTO nld1939_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","En als zij stil hield, sprak hij: Zet U neder, o Jahweh Bij de duizend maal tienduizenden van Israël! ");
INSERT INTO nld1939_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Eens begon het volk tegen Jahweh te klagen, dat het hun slecht ging. Toen Jahweh dat hoorde, ontstak Hij in gramschap; en het vuur van Jahweh laaide onder hen op, en vernielde een hoek van de legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nu riep het volk tot Moses om hulp; Moses bad tot Jahweh, en het vuur doofde uit. ");
INSERT INTO nld1939_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Hij noemde die plaats Tabera, omdat het vuur van Jahweh onder hen was ontbrand. ");
INSERT INTO nld1939_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Een andere keer liet het uitvaagsel, dat zich onder hen ophield, zich door zijn begeerlijkheid meeslepen, zodat ook de Israëlieten weer begonnen te klagen, en zeiden: Gaf men ons maar eens vlees te eten! ");
INSERT INTO nld1939_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wij denken nog terug aan de vis, die we in Egypte voor niets konden eten, en aan de augurken, meloenen, prei, uien en knoflook; ");
INSERT INTO nld1939_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","nu drogen we uit, en krijgen we niets dan dat manna te zien. ");
INSERT INTO nld1939_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Het manna leek op korianderzaad, en zag er uit als geurige hars. ");
INSERT INTO nld1939_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Het volk trok er op uit, om het bijeen te rapen, maalde het met de molen of stampte het fijn in de vijzel, kookte het in een pot, en maakte er koeken van; en het had de smaak van oliegebak. ");
INSERT INTO nld1939_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","En wanneer des nachts de dauw op de legerplaats viel, daalde ook het manna erop neer. ");
INSERT INTO nld1939_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Toen Moses het volk hoorde klagen, het ene gezin na het andere, iedereen bij de ingang van zijn tent, ontstak Jahweh in heftige toorn. Maar ook Moses werd boos, ");
INSERT INTO nld1939_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","en hij sprak tot Jahweh: Waarom doet Gij uw dienaar dit leed aan, en vind ik zo weinig genade in uw ogen, dat Gij mij de last van heel dit volk maar laat torsen? ");
INSERT INTO nld1939_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Heb ik al dat volk soms ontvangen of gebaard, dat Gij tegen mij zegt: Draag het in uw schoot, zoals een verpleegster een zuigeling draagt, naar het land, dat Gij aan hun vaderen onder ede beloofd hebt. ");
INSERT INTO nld1939_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Waar haal ik het vlees vandaan, om aan al dat volk te geven; want het jammert tegen mij: Geef ons toch vlees te eten! ");
INSERT INTO nld1939_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ik kan al dat volk niet alleen dragen: het is mij te zwaar. ");
INSERT INTO nld1939_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Wanneer Gij mij zo blijft behandelen, dood mij dan liever, indien ik genade gevonden heb in uw ogen, opdat ik mijn ellende niet langer hoef aan te zien. ");
INSERT INTO nld1939_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Toen sprak Jahweh tot Moses: Kies Mij zeventig mannen uit onder de oudsten van Israël, van wie ge weet, dat ze de oudsten van het volk en zijn leiders zijn; breng ze bij de openbaringstent en dat zij zich daar met u opstellen. ");
INSERT INTO nld1939_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Dan zal Ik afdalen, en daar met u spreken; Ik zal een deel van de geest nemen, die op u rust, en die over hen uitstorten, zodat zij te zamen met u de last van het volk kunnen dragen, en gij die niet alleen hoeft te torsen. ");
INSERT INTO nld1939_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","En tot het volk moet gij zeggen: Heiligt u voor morgen; dan zult gij vlees eten. Want Jahweh heeft u horen klagen: “Gaf men ons maar eens vlees te eten; wat hadden we het in Egypte toch goed!” Ja, Jahweh zal u vlees te eten geven! ");
INSERT INTO nld1939_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","En ge zult het eten, niet enkel één dag, niet twee, vijf, tien of twintig dagen, ");
INSERT INTO nld1939_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","maar een hele maand lang, totdat het uw neus uitkomt en gij ervan walgt; want gij hebt Jahweh veracht, die in uw midden woont, en tegen Hem durven klagen: “Waarom zijn wij uit Egypte getrokken?” ");
INSERT INTO nld1939_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","En Moses zei: Het volk waaronder ik toef, is zeshonderd duizend man sterk, en Gij zegt: “Ik zal het een maand lang vlees laten eten!” ");
INSERT INTO nld1939_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kunnen er voor hen genoeg schapen en runderen worden geslacht; of als men alle vissen uit de zee voor hen ving, zou dat genoeg voor hen zijn? ");
INSERT INTO nld1939_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jahweh gaf Moses ten antwoord: Is Jahweh’s hand soms te kort? Nu zult ge zien, of mijn woord uitkomt, of niet! ");
INSERT INTO nld1939_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Toen trad Moses naar buiten, en deelde het volk mee, wat Jahweh gezegd had. Hij koos zeventig mannen uit onder de oudsten van het volk, en stelde ze op rond de Tent. ");
INSERT INTO nld1939_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nu daalde Jahweh neer in de wolk, en sprak tot hem; en Hij nam een deel van de geest, die op Moses rustte, en stortte die over de zeventig oudsten uit. Zodra de geest op hen rustte, profeteerden zij en hielden niet op. ");
INSERT INTO nld1939_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nu waren er twee van die mannen in de legerplaats achtergebleven; de een heette Eldad, de ander Medad. Daar ze waren opgetekend, rustte de geest ook op hen. En ofschoon ze niet naar de Tent waren gegaan, profeteerden ze toch in de legerplaats. ");
INSERT INTO nld1939_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Een knaap ging het ijlings aan Moses berichten, en zeide: Eldad en Medad zijn in de legerplaats aan het profeteren. ");
INSERT INTO nld1939_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","En Josuë, de zoon van Noen, die Moses van zijn jeugd af gediend had, drong aan: Moses, mijn meester, belet het hun. ");
INSERT INTO nld1939_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Maar Moses gaf hem ten antwoord: Zijt gij afgunstig om mijnentwille? O, mocht heel het volk van Jahweh profeet zijn, omdat Jahweh zijn geest op hen had gelegd! ");
INSERT INTO nld1939_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Daarna trok Moses zich met de oudsten van Israël in het legerkamp terug. ");
INSERT INTO nld1939_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Daarop zond Jahweh een wind, die uit de zee kwartels aanvoerde, en ze twee ellen boven de grond over de legerplaats joeg, en rondom de legerplaats een dagreis ver naar alle kanten. ");
INSERT INTO nld1939_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","En het volk bleef heel die dag en die nacht, en nog heel de volgende dag in de weer, om de kwartels te vangen; die het minst ving had nog tien chómer. Zij spreidden ze wijd rond de legerplaats uit. ");
INSERT INTO nld1939_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Maar nog was het vlees onverteerd tussen hun tanden of daar barstte Jahweh’s gramschap los tegen het volk, en richtte Jahweh een grote slachting onder hen aan. ");
INSERT INTO nld1939_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daarom noemde men die plaats Kibrot-Hattaäwa; want men begroef daar het volk, dat gulzig was geweest. ");
INSERT INTO nld1939_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Van Kibrot-Hattaäwa trok het volk naar Chaserot op, en het bleef te Chaserot. ");
INSERT INTO nld1939_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Eens maakten Mirjam en Aäron Moses een verwijt over zijn koesjietische vrouw, die hij zich had genomen; want hij had een vrouw uit Koesj gehuwd. ");
INSERT INTO nld1939_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Zij zeiden: Heeft Jahweh soms alleen tot Moses gesproken; heeft Hij ook niet tot ons gesproken? Jahweh hoorde het. ");
INSERT INTO nld1939_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","En daar Moses een zeer deemoedig man was, meer dan iemand ter wereld, ");
INSERT INTO nld1939_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","sprak Jahweh ogenblikkelijk tot Moses, Aäron en Mirjam: Gaat met uw drieën naar de openbaringstent. En zij gingen er met hun drieën heen. ");
INSERT INTO nld1939_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Toen daalde Jahweh in de wolkkolom neer, en ging bij de ingang van de Tent staan. Hij riep Aäron en Mirjam, en toen beiden naar voren waren getreden, ");
INSERT INTO nld1939_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","sprak Jahweh: Hoort mijn woord! Zo er een profeet onder u is, Openbaar Ik Mij aan hem in een visioen, En spreek tot hem in een droom; ");
INSERT INTO nld1939_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Zo niet met Moses, mijn dienaar, Die getrouw is bevonden in heel mijn huis; ");
INSERT INTO nld1939_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Tot hem spreek Ik van mond tot mond, Niet in visioenen en raadsels: Hij aanschouwt Jahweh in eigen persoon! Waarom vreest ge dan niet, Mijn dienaar Moses verwijten te doen? ");
INSERT INTO nld1939_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ziedend van gramschap ging Jahweh heen. ");
INSERT INTO nld1939_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","En toen de wolk boven de openbaringstent was opgetrokken, was Mirjam melaats, en wit als sneeuw en toen Aäron zich tot Mirjam wendde: daar stond een melaatse. ");
INSERT INTO nld1939_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Nu sprak Aäron tot Moses: Ach, heer; wil toch op ons de zonde niet wreken, die wij in onze dwaasheid hebben begaan. ");
INSERT INTO nld1939_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Laat haar niet op een doodgeborene lijken, wiens vlees voor de helft al verteerd is, als hij uit de moederschoot komt. ");
INSERT INTO nld1939_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","En Moses smeekte Jahweh: Ach neen; wil haar genezen! ");
INSERT INTO nld1939_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Jahweh gaf Moses ten antwoord: Als haar vader haar in het gelaat had gespuwd, zou ze zich dan niet zeven dagen lang hebben geschaamd? Zo zal ze zeven dagen lang buiten de legerplaats worden gesloten; daarna mag ze weer worden toegelaten. ");
INSERT INTO nld1939_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mirjam werd dus zeven dagen lang buiten de legerplaats gesloten; en het volk trok niet op, voor Mirjam weer was toegelaten. ");
INSERT INTO nld1939_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Daarna brak het volk op van Chaserot, en legerde zich in de woestijn Paran. ");
INSERT INTO nld1939_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Daar sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Zend mannen uit, om het land Kanaän te verkennen, dat Ik aan Israëls kinderen zal geven; uit iedere vaderstam moet ge één man zenden en allen moeten het aanvoerders zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moses zond hen dus op Jahweh’s bevel uit de woestijn Paran op weg. Al die mannen waren hoofden van de Israëlieten, ");
INSERT INTO nld1939_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","en dit zijn hun namen: Uit de stam Ruben Sjammóea, de zoon van Zakkoer; ");
INSERT INTO nld1939_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","uit de stam Simeon Sjafat, de zoon van Chori; ");
INSERT INTO nld1939_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","uit de stam Juda Kaleb, de zoon van Jefoenne; ");
INSERT INTO nld1939_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","uit de stam Issakar Jigal, de zoon van Josef; ");
INSERT INTO nld1939_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","uit de stam Efraïm Hosjéa, de zoon van Noen; ");
INSERT INTO nld1939_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","uit de stam Benjamin Palti, de zoon van Rafoe; ");
INSERT INTO nld1939_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","uit de stam Zabulon Gaddiël, de zoon van Sodi; ");
INSERT INTO nld1939_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","uit de stam Josef en wel uit de stam Manasse Gaddi, de zoon van Soesi; ");
INSERT INTO nld1939_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","uit de stam Dan Ammiël, de zoon van Gemalli; ");
INSERT INTO nld1939_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","uit de stam Aser Setoer, de zoon van Mikaël; ");
INSERT INTO nld1939_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","uit de stam Neftali Nachbi, de zoon van Wofsi; ");
INSERT INTO nld1939_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","uit de stam Gad Geoeël, de zoon van Maki. ");
INSERT INTO nld1939_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Dit waren de namen der mannen, die Moses uitzond, om het land te verkennen; maar Moses noemde Hosjéa, den zoon van Noen, Josuë. ");
INSERT INTO nld1939_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses zond ze dus uit, om het land Kanaän te verkennen, en zei hun: Trekt hier de Négeb in, en bestijgt het bergland. ");
INSERT INTO nld1939_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ziet, hoe het met het land is gesteld; of het volk, dat er woont, sterk is of zwak, gering of talrijk; ");
INSERT INTO nld1939_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","of het land, waarin het woont, vruchtbaar of dor is: of de steden, die het bewoont, open zijn of versterkt; ");
INSERT INTO nld1939_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","of de bodem vet is of schraal; of er bomen zijn of niet; toont, dat ge moed hebt. Brengt ook wat vruchten van het land mee; het was toen juist de tijd der eerste druiven. ");
INSERT INTO nld1939_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Zij trokken dan uit, om het land te verkennen van de woestijn Sin tot aan Rechob bij Chamat. ");
INSERT INTO nld1939_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Zij trokken de Négeb in, en bereikten Hebron, waar de Anakskinderen Achiman, Sjesjai en Talmai woonden; Hebron was zeven jaar eerder gebouwd dan het egyptische Sóan. ");
INSERT INTO nld1939_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Zij drongen tot aan de vallei Esjkol door, waar zij een wijnrank met een druiventros afsneden, die zij met hun tweeën aan een stok moesten dragen; bovendien nog wat granaatappels en vijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Men noemt die plaats Esjkol-vallei om de druiventros, die de Israëlieten daar hadden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Na het land te hebben verkend, keerden zij veertig dagen later terug, ");
INSERT INTO nld1939_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","en gingen naar Moses en Aäron en heel de gemeenschap der Israëlieten in de woestijn Paran te Kadesj, waar zij hun en heel de gemeenschap verslag uitbrachten, en hun de vruchten van het land lieten zien. ");
INSERT INTO nld1939_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Zij vertelden hem: Wij zijn dan in het land geweest, waar gij ons hebt heengezonden, en het druipt werkelijk van melk en honing; hier hebt ge zijn vruchten. ");
INSERT INTO nld1939_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Maar het volk, dat het land bewoont, is sterk en de steden zijn ontoegankelijk en zeer groot; bovendien hebben wij daar de Anakskinderen gezien. ");
INSERT INTO nld1939_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","De Amalekieten wonen in de Négeb; de Chittieten, Jeboesieten en Amorieten in de bergen: en de Kanaänieten langs de zee en langs de oever van de Jordaan. ");
INSERT INTO nld1939_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb trachtte nog het volk, dat om Moses stond, gerust te stellen, en sprak: Laat ons zo gauw mogelijk optrekken, en het veroveren; want we kunnen het gemakkelijk aan! ");
INSERT INTO nld1939_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Maar de mannen, die met hem waren opgetrokken, beweerden: We kunnen niet oprukken tegen dat volk; want het is sterker dan wij. ");
INSERT INTO nld1939_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","En nu begonnen ze onder de Israëlieten allerlei praatjes te vertellen over het land, dat zij hadden verkend, en zeiden: Het land, dat we hebben doorkruist, om het te verkennen, verslindt zijn bewoners, en al het volk, dat we daar hebben gezien, is vreselijk groot. ");
INSERT INTO nld1939_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We hebben daar zelfs reuzen gezien, bij wie wij wel sprinkhanen leken, zowel in onze eigen ogen als in die van hen. ");
INSERT INTO nld1939_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toen begon al het volk in die nacht te schreeuwen en te jammeren. ");
INSERT INTO nld1939_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Alle Israëlieten morden tegen Moses en Aäron, en heel de gemeenschap zei tot hen: Ach, waren we toch in het land van Egypte gestorven, of omgekomen in deze woestijn! ");
INSERT INTO nld1939_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Waarom brengt Jahweh ons naar dit land, waar wij door het zwaard zullen vallen, en onze vrouwen en kinderen een prooi zullen worden? Is het niet beter, dat we terugkeren naar Egypte? ");
INSERT INTO nld1939_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","En onder elkander spraken zij af: Laten we een aanvoerder kiezen; dan gaan we terug naar Egypte! ");
INSERT INTO nld1939_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Toen wierpen Moses en Aäron zich voor heel de verzamelde gemeenschap van Israëls kinderen neer. ");
INSERT INTO nld1939_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","En Josuë, de zoon van Noen, en Kaleb, de zoon van Jefoenne, die tot de verkenners van het land hadden behoord, scheurden hun kleren, ");
INSERT INTO nld1939_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","en riepen tot heel de gemeenschap der Israëlieten: Het land, dat wij hebben doorkruist, om het te verkennen, is buitengewoon vruchtbaar. ");
INSERT INTO nld1939_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Zo Jahweh ons genadig is, brengt Hij ons naar dit land, en geeft Hij ons een land, dat druipt van melk en honing. ");
INSERT INTO nld1939_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Neen, weest niet weerspannig tegen Jahweh! Ge behoeft de bewoners van het land niet te vrezen; want ze zijn onze prooi. Hun schaduw is van hen weggegleden, terwijl Jahweh ons bijstaat, vreest hen dus niet. ");
INSERT INTO nld1939_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Maar reeds maakte heel de gemeenschap aanstalten om hen te stenigen, toen eensklaps de Glorie van Jahweh boven de openbaringstent aan alle Israëlieten verscheen. ");
INSERT INTO nld1939_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","En Jahweh sprak tot Moses: Hoe lang zal dit volk Mij verguizen; hoe lang zal het weigeren in Mij te geloven, ondanks alle tekenen, die Ik onder hen heb verricht? ");
INSERT INTO nld1939_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ik zal hen slaan met de pest, en hen uitroeien; dan maak Ik u tot een groter en machtiger volk! ");
INSERT INTO nld1939_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Maar Moses zeide tot Jahweh: De Egyptenaren hebben gehoord, dat Gij door uw kracht dit volk uit hun midden hebt weggevoerd. ");
INSERT INTO nld1939_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ook de bewoners van dit land hebben vernomen, dat Gij, Jahweh, te midden van dit volk vertoeft; dat Gij, Jahweh, voor aller ogen verschijnt, en dat uw wolk boven hen staat, dat Gij in een wolkkolom overdag en des nachts in een vuurkolom voor hen uitgaat. ");
INSERT INTO nld1939_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Wanneer Gij nu dit volk tot den laatsten man doodt, zullen de volken, die uw faam hebben gehoord, zeggen: ");
INSERT INTO nld1939_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Omdat Jahweh niet machtig genoeg was, dit volk naar het land te brengen, dat Hij hun onder ede beloofd had, heeft Hij ze maar in de woestijn vermoord. ");
INSERT INTO nld1939_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Toon nu, Heer, de grootheid van uw kracht, zoals Gij zelf hebt gezegd: ");
INSERT INTO nld1939_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Jahweh is lankmoedig en rijk aan genade. Hij vergeeft de zonden en misdaden wel maar laat ze niet ongestraft; Hij wreekt de misdaad van de vaderen op de zonen tot in het derde en vierde geslacht. ");
INSERT INTO nld1939_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ach, vergeef dan de zonde van dit volk volgens uw grote ontferming, zoals Gij dit volk vergeven hebt van Egypte tot hier toe. ");
INSERT INTO nld1939_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Toen sprak Jahweh: Op uw bede schenk Ik vergiffenis. ");
INSERT INTO nld1939_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Maar, zo waarachtig Ik leef, en heel de aarde van de glorie van Jahweh vervuld is, ");
INSERT INTO nld1939_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","geen van de mannen, die mijn Glorie hebben aanschouwd, en mijn tekenen, die Ik in Egypte en in de woestijn heb gewrocht, maar Mij nu voor de tiende maal tarten en niet naar mijn stem willen luisteren: ");
INSERT INTO nld1939_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","geen van hen zal het land aanschouwen, dat Ik hun vaderen onder ede beloofd heb. Niemand, die Mij heeft verguisd, zal het aanschouwen, ");
INSERT INTO nld1939_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","maar mijn dienaar Kaleb, die van een andere geest is bezield en Mij dan ook trouw is gebleven, zal Ik als beloning in het land brengen, waar hij is binnengetreden, en zijn nakomelingschap zal het bezitten. ");
INSERT INTO nld1939_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(b) Trekt morgen weer de woestijn in, de richting uit van de Rode Zee. ");
INSERT INTO nld1939_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","En Jahweh vervolgde tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Hoe lang zal deze boze gemeenschap nog tegen Mij morren? Het gemor, dat de Israëlieten tegen Mij hebben aangeheven, heb Ik vernomen. ");
INSERT INTO nld1939_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Zeg hun: Zo waar Ik leef, is de godsspraak van Jahweh! Zoals zij te mijnen aanhoren hebben gesproken, zo zal Ik met u doen. ");
INSERT INTO nld1939_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In deze woestijn zullen uw lijken vallen: allen, die van u gemonsterd zijn, allen zonder uitzondering, van twintig jaar af: omdat gij tegen Mij hebt gemord. ");
INSERT INTO nld1939_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Neen, gij komt het land niet binnen, dat Ik u met opgestoken hand als woonplaats beloofd heb, behalve Kaleb, de zoon van Jefoenne en Josuë, de zoon van Noen. ");
INSERT INTO nld1939_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Maar uw kinderen, die gij al tot een prooi hebt verklaard, zal Ik er binnenleiden, en zij zullen het land waarderen, dat gij hebt versmaad. ");
INSERT INTO nld1939_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Uw lijken zullen in deze woestijn blijven liggen, ");
INSERT INTO nld1939_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","en uw zonen zullen veertig jaar lang in de woestijn blijven zwerven en uw tuchteloos gedrag moeten boeten, totdat uw lijken in de woestijn zijn vergaan. ");
INSERT INTO nld1939_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Zoals gij veertig dagen het land hebt verkend, zo zullen zij veertig jaren uw misdaden boeten, een jaar voor iedere dag. Zo zult ge beseffen wat mijn afkeer betekent, ");
INSERT INTO nld1939_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ik, Jahweh, heb het gezegd! Zo zal Ik doen met heel deze boze gemeenschap, die tegen Mij heeft samengespannen; in deze woestijn zullen zij omkomen, daar zullen zij sterven. ");
INSERT INTO nld1939_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","De mannen nu, die Moses had uitgezonden, om het land te verkennen, en die bij hun terugkeer heel de gemeenschap tegen Hem hadden doen morren, door praatjes over dat land te vertellen, ");
INSERT INTO nld1939_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","de mannen, die dergelijke lasterpraat hadden verspreid, stierven voor het aanschijn van Jahweh een plotselinge dood. ");
INSERT INTO nld1939_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Van al de mannen, die het land waren gaan verkennen, bleven alleen Josuë, de zoon van Noen, en Kaleb, de zoon van Jefoenne, in leven. ");
INSERT INTO nld1939_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Toen Moses dit alles aan de Israëlieten had overgebracht, werd het volk diep bedroefd. ");
INSERT INTO nld1939_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Vroeg in de volgende morgen wilden zij de top van de berg beklimmen, en riepen: Zie, we trekken al op naar de plaats, waarvan Jahweh gesproken heeft; want we hebben gezondigd! ");
INSERT INTO nld1939_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Maar Moses sprak: Waarom overtreedt ge Jahweh’s bevel? Het zal u niet lukken. ");
INSERT INTO nld1939_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Trekt niet op; want Jahweh is niet in uw midden. Ge zult zeker door uw vijanden worden verslagen; ");
INSERT INTO nld1939_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","want de Amalekieten en Kanaänieten staan daar tegenover u. Door het zwaard zult ge vallen; want gij hebt u van Jahweh afgekeerd, en Jahweh staat u niet bij. ");
INSERT INTO nld1939_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Maar ze waren vermetel genoeg, om toch de top van de berg te bestijgen, ofschoon de ark van Jahweh’s Verbond en Moses de legerplaats niet verlieten. ");
INSERT INTO nld1939_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Doch de Amalekieten en Kanaänieten, die op de berg woonden, kwamen naar beneden, versloegen ze, en dreven ze terug tot Chorma toe. En de Amalekieten en Kanaänieten hielden het laagland bezet. ");
INSERT INTO nld1939_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Beveel de Israëlieten en zeg hun: Wanneer gij het land, waar gij wonen zult en dat Ik u geven zal, zijt binnengegaan, ");
INSERT INTO nld1939_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","en gij wilt Jahweh een vuuroffer brengen, een brand- of een slachtoffer, als vervulling van een gelofte, als een vrijwillige gave, of bij uw feesten, om zo Jahweh uit het rundvee of kleinvee een heerlijke geur te bereiden: ");
INSERT INTO nld1939_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","dan moet hij, die een lam aan Jahweh offert, als spijsoffer een issaron meelbloem, gemengd met een vierde hin olie, ");
INSERT INTO nld1939_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","als plengoffer een vierde hin wijn bij het brand- of slachtoffer voegen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Bij een ram moet ge als spijsoffer twee issaron meelbloem, gemengd met een derde hin olie, ");
INSERT INTO nld1939_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","en als plengoffer een derde hin wijn opdragen als een heerlijke geur voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Wanneer gij een jong rund als brand- of slachtoffer wilt brengen, als vervulling van een gelofte, of als vredeoffer voor Jahweh, ");
INSERT INTO nld1939_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dan moet ge bij het rund als spijsoffer drie issaron meelbloem, gemengd met een halve hin olie, ");
INSERT INTO nld1939_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","en als plengoffer een halve hin wijn opdragen als een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Zo moet ge doen bij iederen stier, bij iederen ram, bij ieder lam of elke jonge geit. ");
INSERT INTO nld1939_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Zoveel dieren ge offert, zoveel spijsoffers moet ge brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Zo moet ieder landskind handelen, als hij Jahweh een heerlijk geurend vuuroffer wil brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Wanneer een vreemdeling, die tijdelijk bij u vertoeft, of reeds geslachten lang in uw midden woont, Jahweh een heerlijk geurend vuuroffer wil brengen, dan moet hij het op dezelfde manier doen als gij. ");
INSERT INTO nld1939_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hetzelfde voorschrift geldt voor u en voor den vreemdeling, die bij u vertoeft; het is een eeuwig geldend voorschrift van geslacht tot geslacht. Gij en de vreemdeling zullen voor Jahweh gelijk zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Dezelfde wet en dezelfde bepalingen gelden voor u en voor den vreemdeling, die bij u vertoeft. ");
INSERT INTO nld1939_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Beveel de Israëlieten, en zeg hun: Wanneer ge in het land zijt gekomen, waarheen Ik u breng, ");
INSERT INTO nld1939_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","en gij eet het brood van het land, dan moet gij een cijns aan Jahweh afstaan. ");
INSERT INTO nld1939_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Als eersteling van uw meel moet ge een koek als cijns afdragen; als een cijns van de dorsvloer moet ge ze brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Van uw eerste meel moet gij een cijns aan Jahweh brengen van geslacht tot geslacht. ");
INSERT INTO nld1939_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Wanneer de gemeenschap een misstap begaat, en al deze geboden, die Jahweh aan Moses heeft gegeven, niet onderhoudt: ");
INSERT INTO nld1939_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","alles namelijk wat Jahweh u door Moses heeft geboden van de dag af, dat Jahweh het u bevolen heeft tot later bij uw nageslacht: ");
INSERT INTO nld1939_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","maar het buiten weten van de gemeenschap bij vergissing gebeurt, dan moet heel de gemeenschap een jongen stier als een heerlijk geurend brandoffer met zijn voorgeschreven spijs- en drankoffer aan Jahweh opdragen, en een bok als zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","De priester zal voor heel de gemeenschap der Israëlieten verzoening verkrijgen, en hun zal vergiffenis worden geschonken, omdat het een vergissing was, en omdat zij voor hun vergissing hun gaven als een vuuroffer aan Jahweh en hun zondeoffer voor het aanschijn van Jahweh hebben gebracht. ");
INSERT INTO nld1939_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Heel de gemeenschap der Israëlieten zal die vergiffenis moeten verkrijgen, met den vreemdeling, die in uw midden woont; want de vergissing drukt op heel het volk. ");
INSERT INTO nld1939_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Wanneer een enkel persoon bij vergissing een zonde begaat, moet hij een eenjarig geitje als zondeoffer brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","De priester zal voor het aanschijn van Jahweh voor hem, die bij vergissing zonde heeft begaan, verzoening verkrijgen door de verzoeningsplechtigheid voor hem te verrichten; dan zal hem vergiffenis worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dezelfde wet geldt voor u allen, die een vergissing begaat, voor den ingezetene onder de Israëlieten en voor den vreemdeling in uw midden. ");
INSERT INTO nld1939_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Maar wanneer iemand, een ingezetene of een vreemdeling, met opzet zondigt, dan hoont hij Jahweh, en zal van zijn volk worden afgesneden. ");
INSERT INTO nld1939_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Want hij heeft het woord van Jahweh veracht, en zijn gebod overtreden; hij zal onherroepelijk worden afgesneden, en zijn zonde moeten boeten. ");
INSERT INTO nld1939_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Terwijl de Israëlieten in de woestijn vertoefden, betrapten zij een man, die op de sabbat hout aan het sprokkelen was. ");
INSERT INTO nld1939_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Zij, die hem daarbij betrapten, brachten hem voor Moses en Aäron en heel de gemeenschap. ");
INSERT INTO nld1939_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Men zette hem in verzekerde bewaring, omdat er nog niet duidelijk was bepaald, wat er met hem moest gebeuren. ");
INSERT INTO nld1939_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Maar Jahweh sprak tot Moses: Die man moet ter dood worden gebracht; heel de gemeenschap moet hem buiten de legerplaats stenigen. ");
INSERT INTO nld1939_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Heel de gemeenschap voerde hem dus buiten de legerplaats, en stenigde hem dood, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Beveel de Israëlieten, en zeg hun, dat zij en hun nageslacht kwasten moeten maken aan de slippen van hun kleren, en aan de slipkwasten een violette draad. ");
INSERT INTO nld1939_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Dit is de bedoeling der kwasten: Wanneer gij ze ziet, zult ge u alle geboden van Jahweh herinneren, en ze volbrengen, en niet uw harten en ogen volgen, en u daardoor laten verleiden. ");
INSERT INTO nld1939_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Zo zult ge al mijn geboden indachtig zijn, ze volbrengen, en heilig zijn voor uw God. ");
INSERT INTO nld1939_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ik ben Jahweh, uw God, die u uit Egypte heb geleid, om uw God te zijn; Ik ben Jahweh, uw God! ");
INSERT INTO nld1939_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kore, de zoon van Jishar, zoon van Kehat, zoon van Levi, en Datan en Abiram, zonen van Eliab, zoon van Palloe, zoon van Ruben, ");
INSERT INTO nld1939_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","kwamen in opstand tegen Moses met twee honderd vijftig israëlietische mannen, allemaal leiders van de gemeenschap, raadslieden en mannen van aanzien. ");
INSERT INTO nld1939_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Zij schoolden samen tegen Moses en Aäron, en zeiden: Nu is het genoeg, zonen van Levi! Heel de gemeenschap en al haar leden zijn heilig, en Jahweh is in hun midden. Waarom verheft gij u dan boven de gemeente van Jahweh? ");
INSERT INTO nld1939_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Toen Moses dit hoorde, viel hij op zijn aangezicht neer, ");
INSERT INTO nld1939_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","en sprak tot Kore en heel zijn aanhang: Morgen zal Jahweh doen weten, wie Hem behoort, wie heilig is, en tot Hem mag naderen, en wien Hij uitverkoren heeft, om tot Hem te komen. ");
INSERT INTO nld1939_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Laat Kore en heel zijn aanhang dus het volgende doen: Neemt wierookvaten, ");
INSERT INTO nld1939_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","legt daar morgen vuur in, en doet er wierook op voor het aanschijn van Jahweh; wie Jahweh dan zal uitverkiezen, zal heilig zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","En Moses vervolgde tot Kore: Luistert, zonen van Levi! ");
INSERT INTO nld1939_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is het u niet genoeg, dat Israëls God u van de gemeenschap van Israël heeft afgezonderd, om u tot Zich te doen naderen, de dienst in de tabernakel van Jahweh te verrichten, en voor de gemeenschap te staan, om haar te dienen? ");
INSERT INTO nld1939_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Hij heeft u met al de zonen van Levi, uw broeders, tot Zich doen komen, en nu eist ge ook nog het priesterschap? ");
INSERT INTO nld1939_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Dus tegen Jahweh spant gij samen met heel uw aanhang. Want wat is Aäron, dat gij mort tegen hem! ");
INSERT INTO nld1939_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moses liet nu Datan en Abiram, de zonen van Eliab, ontbieden. Maar zij antwoordden: We komen niet. ");
INSERT INTO nld1939_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is het u niet genoeg, dat gij ons hebt weggevoerd uit een land, dat van melk en honing overvloeit, om ons in de woestijn te doen sterven? Wilt ge ons ook nog tiranniseren? ");
INSERT INTO nld1939_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ge hebt ons niet eens naar een land gebracht, dat van melk en honing overvloeit, of ons akkers en wijngaarden gegeven. Wilt gij die mannen zand in de ogen strooien? Wij komen niet! ");
INSERT INTO nld1939_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Toen werd Moses zeer vergramd, en hij sprak tot Jahweh: Neem hun offer niet aan; geen ezel heb ik hun ontnomen, en niemand hunner kwaad gedaan. ");
INSERT INTO nld1939_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Daarna sprak Moses tot Kore: Zorg, dat gij u morgen met heel uw aanhang voor het aanschijn van Jahweh bevindt: gij, de anderen en Aäron. ");
INSERT INTO nld1939_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Iedereen moet zijn wierookvat nemen, er wierook in doen, en het voor het aanschijn van Jahweh brengen; dus twee honderd vijftig wierookvaten, behalve dat van u zelf en Aäron. ");
INSERT INTO nld1939_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Iedereen nam dus zijn wierookvat, legde er vuur in, deed er wierook op, en stelde zich op bij de ingang van de openbaringstent. Zo deden ook Moses en Aäron. ");
INSERT INTO nld1939_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Maar Kore had heel de gemeenschap tegen hen opgeroepen bij de ingang van de openbaringstent. Toen verscheen de heerlijkheid van Jahweh aan heel de gemeenschap. ");
INSERT INTO nld1939_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","En Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Zondert u af van deze gemeenschap; want Ik zal ze in een oogwenk verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Toen vielen zij op hun aangezicht neer, en zeiden: O God! God over het leven van alle schepselen! Een enkel man heeft gezondigd, en Gij zoudt op heel de gemeenschap vergramd zijn! ");
INSERT INTO nld1939_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Jahweh gaf Moses ten antwoord: ");
INSERT INTO nld1939_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Beveel de gemeenschap: Verwijdert u van de aanhang van Kore! ");
INSERT INTO nld1939_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Daarop ging Moses zelf naar Datan en Abiram, en de oudsten van Israël volgden hem. ");
INSERT INTO nld1939_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","En hij beval de gemeenschap: Verwijdert u van de tenten dezer booswichten, en raakt niets aan, wat hun toebehoort, opdat ge niet wordt meegesleept met al hun zonden. ");
INSERT INTO nld1939_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","En men verwijderde zich van de woningen van Kore, Datan en Abiram. Intussen waren Datan en Abiram naar buiten gekomen en met hun vrouwen, zonen en kleine kinderen aan de ingang van hun tenten gaan staan. ");
INSERT INTO nld1939_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Nu sprak Moses: Hieraan zult ge erkennen, dat Jahweh mij heeft gezonden, om dit alles te doen, en dat het geen eigen verzinsel is! ");
INSERT INTO nld1939_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Zo die daar sterven als alle mensen, en het lot aller mensen hen treft, dan heeft Jahweh mij niet gezonden. ");
INSERT INTO nld1939_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Maar zo Jahweh iets ongehoords wrocht, zo de grond zijn muil openspert en hen met al het hunne verslindt, zodat ze levend in het dodenrijk dalen, dan zult ge erkennen, dat die mannen Jahweh hebben gehoond. ");
INSERT INTO nld1939_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Nauwelijks had hij dit alles gezegd, of de grond onder hen scheurde open. ");
INSERT INTO nld1939_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","De aarde opende haar muil, en verslond hen met hun huisgezinnen, met alle mensen, die bij Kore hoorden en heel hun bezit. ");
INSERT INTO nld1939_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Met al de hunnen, daalden ze levend in het dodenrijk af; de aarde bedekte hen, en ze werden verdelgd uit de gemeente. ");
INSERT INTO nld1939_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Heel Israël, dat hen omringde, vluchtte weg bij hun gillen, want ze dachten: Anders verslindt de aarde ook ons! ");
INSERT INTO nld1939_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Toen ging een vuur uit van Jahweh, en verteerde de twee honderd vijftig mannen, die wierook stonden te offeren. ");
INSERT INTO nld1939_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Daarna sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Beveel Elazar, den zoon van den priester Aäron, de wierookvaten uit de brand te redden, en het vuur op enige afstand te verstrooien; ");
INSERT INTO nld1939_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","want de wierookvaten dezer boosdoeners, die hun leven verbeurd hebben, zijn aan het heiligdom vervallen. Slaat ze tot dunne platen, om het altaar te bekleden; want men heeft ze Jahweh aangeboden, en daardoor zijn ze aan het heiligdom vervallen. Zo zullen ze voor de Israëlieten een waarschuwing zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","De priester Elazar nam dus de koperen wierookvaten, die zij, die verbrand waren, hadden aangeboden, en plette ze tot een bekleding van het altaar; ");
INSERT INTO nld1939_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","als een herinnering voor de Israëlieten, dat geen onbevoegde, iemand, die niet tot het geslacht van Aäron behoort, naderbij mag komen, om Jahweh een reukoffer te brengen, opdat het hem niet zal gaan als Kore en zijn aanhang, zoals Jahweh het hem door Moses gezegd had. ");
INSERT INTO nld1939_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Maar nu sloeg heel de gemeenschap der Israëlieten de volgende dag tegen Moses en Aäron aan het morren, en zeide: Gij hebt het volk van Jahweh gedood! ");
INSERT INTO nld1939_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","En daar de gemeenschap tegen Moses en Aäron te hoop liep, begaven zij zich naar de openbaringstent: en zie de wolk overdekte haar, en de heerlijkheid van Jahweh verscheen. ");
INSERT INTO nld1939_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Toen Moses en Aäron voor de openbaringstent waren getreden, ");
INSERT INTO nld1939_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Verwijder u van deze gemeenschap; want in een oogwenk zal Ik ze verdelgen! Maar zij vielen op hun aangezicht neer, ");
INSERT INTO nld1939_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","en Moses sprak tot Aäron: Neem het wierookvat, leg er vuur in van het altaar, doe er wierook op, en loop er gauw mee naar de gemeenschap, om verzoening voor hen te verkrijgen; want de toorn is van Jahweh’s aanschijn uitgegaan, en de straf is al begonnen. ");
INSERT INTO nld1939_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aäron nam zijn wierookvat, zoals Moses bevolen had, en snelde midden tussen de gemeente in. En zie, de straf was onder het volk al begonnen. Hij deed er wierook op, voltrok de verzoeningsplechtigheid over het volk, ");
INSERT INTO nld1939_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","en stelde zich tussen de doden en de levenden, zodat de plaag werd gestuit. ");
INSERT INTO nld1939_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Er waren er veertien duizend zevenhonderd door de plaag gestorven, behalve nog de anderen, die door het gebeurde met Kore waren omgekomen. ");
INSERT INTO nld1939_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Toen keerde Aäron naar Moses bij de openbaringstent terug. De plaag had opgehouden. ");
INSERT INTO nld1939_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Beveel de Israëlieten de staf van al hun stamvorsten te brengen, van elke stam één, dus twaalf staven. Schrijf ieders naam op zijn staf. ");
INSERT INTO nld1939_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Maar op de staf van Levi moet ge de naam van Aäron schrijven; want ook voor hun stamhoofd moet er een staf zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Leg ze dan in de openbaringstent voor de verbondstafelen neer, waar Ik Mij aan u openbaar. ");
INSERT INTO nld1939_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","De staf van den man, dien Ik uitkies, zal gaan bloeien. Zo zal Ik het gemor van de Israëlieten tegen u tot zwijgen brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moses bracht het aan de Israëlieten over, en al hun stamhoofden gaven hem ieder een staf; dus twaalf staven, voor iedere stam één; ook de staf van Aäron bevond zich daarbij. ");
INSERT INTO nld1939_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses legde die staven voor het aanschijn van Jahweh in de openbaringstent neer. ");
INSERT INTO nld1939_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Toen Moses de volgende dag in de verbondstent kwam: waarachtig, daar was de staf van Aäron, die aan de stam van Levi behoorde, gaan bloeien; hij had knoppen en bloesem en droeg rijpe amandelen. ");
INSERT INTO nld1939_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses nam al de staven voor het aanschijn van Jahweh weg, en bracht ze naar alle Israëlieten; deze zagen het ook, en iedereen nam zijn eigen staf terug. ");
INSERT INTO nld1939_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Toen sprak Jahweh tot Moses: Leg de staf van Aäron weer voor de verbondstafelen neer, om hem te bewaren als een waarschuwing voor de weerspannigen, en maak daarmee een eind aan hun morren, opdat zij niet sterven. ");
INSERT INTO nld1939_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","En Moses deed, wat Jahweh hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Maar nu zeiden de Israëlieten tot Moses: Ach, wij sterven, wij gaan te gronde, wij komen allemaal om! ");
INSERT INTO nld1939_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Want iedereen sterft, die tot de tabernakel van Jahweh nadert! Moeten wij dan allen sterven? ");
INSERT INTO nld1939_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Jahweh sprak tot Aäron: Gij, uw zonen en het huis van uw vader zult de verantwoording voor het heiligdom dragen; gij en uw zonen zult de verantwoording voor uw priesterschap dragen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Maar ook uw broeders, de stam van Levi, de stam van uw vader, moet ge met u doen naderen tot de verbondstent, om zich bij u aan te sluiten, en u en uw zonen te dienen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Zij moeten verrichten wat voor uw ambt en de hele dienst van de Tent nodig is; maar zij mogen de heilige zaken en het altaar niet aanraken; anders sterven zij en ook gijzelf. ");
INSERT INTO nld1939_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Zij mogen zich dus bij u aansluiten om de dienst bij de openbaringstent uit te oefenen, bij alles wat er voor de Tent valt te doen; maar geen onbevoegde mag u naderen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Gij moet de dienst van het heiligdom en de dienst van het altaar uitoefenen, opdat de Toorn niet opnieuw tegen de Israëlieten losbarst. ");
INSERT INTO nld1939_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Zie, Ik heb uw broeders, de levieten, onder de Israëlieten uitgekozen, als een geschenk voor u; zij zijn ter beschikking van Jahweh gesteld, om de dienst bij de openbaringstent te verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Maar gij met uw zonen zult het priesterschap uitoefenen, bij alles wat aan het altaar en achter het voorhangsel moet worden verricht; als een geschenk geef Ik u het priesterschap; die onbevoegd durft naderen, moet worden gedood. ");
INSERT INTO nld1939_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Jahweh sprak tot Aäron: Zie, wat van mijn offers overblijft, sta Ik u af; Ik geef het u en uw zonen als uw aandeel van alle gewijde gaven der Israëlieten, als een eeuwig recht. ");
INSERT INTO nld1939_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Van de hoogheilige offers, voor zover ze niet worden verbrand, zullen al hun gaven aan spijs-, zonde- en schuldoffers, die zij Mij brengen, voor u zijn; dit hoogheilige zal voor u en uw zonen zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Op een hoogheilige plaats moet gij het eten; alle mannelijke personen mogen ervan eten. Gij moet het als iets heiligs beschouwen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Van de geschenken, die men brengt, is het volgende voor u bestemd: Alle strekoffers der Israëlieten geef Ik u en uw zonen en dochters als een eeuwig recht; iedereen van uw gezin, die rein is, mag ervan eten. ");
INSERT INTO nld1939_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ook al het beste van de olie, van de most en het koren, die zij als eerstelingen aan Jahweh brengen, geef Ik u. ");
INSERT INTO nld1939_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ook de eerste vruchten, die zij Jahweh brengen, van alles, wat op hun akkers groeit, zijn voor u; iedereen van uw gezin, die rein is, mag ze eten. ");
INSERT INTO nld1939_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ook al wat in Israël met de ban is geslagen, is voor u. ");
INSERT INTO nld1939_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Eveneens al wat de moederschoot opent van mens en dier, dat men Jahweh moet offeren, is voor u. Maar het eerstgeborene van de mensen moet ge laten vrijkopen, evenals het eerstgeborene van de onreine dieren. ");
INSERT INTO nld1939_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ge moet een kind laten loskopen, als het een maand oud is, en zijn losgeld zal de vastgestelde prijs bedragen, vijf sikkels volgens het heilig gewicht, dus twintig gera. ");
INSERT INTO nld1939_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Maar het eerstgeborene van runderen, schapen en geiten, moogt gij niet laten vrijkopen, want zij zijn heilig; hun bloed moet ge tegen het altaar sprenkelen, en hun vet in rook doen opgaan als een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Hun vlees is voor u, evenals de borst van het strekoffer en de rechterschenkel. ");
INSERT INTO nld1939_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Al deze heilige gaven, die de Israëlieten aan Jahweh schenken, geef Ik u en uw zonen en dochters als een eeuwig recht; het is voor u en uw geslacht een eeuwig verbond door zout bekrachtigd voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Maar tot Aäron zei Jahweh: Gij zult in hun land geen erfbezit ontvangen, en geen aandeel onder hen krijgen. Ik ben uw aandeel en erfbezit te midden van Israëls kinderen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Aan de levieten geef Ik alle tienden in Israël tot erfdeel als vergoeding voor hun dienst, die zij bij de openbaringstent verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","De Israëlieten mogen dus niet langer tot de openbaringstent naderen; zij zouden daardoor een dodelijke schuld op zich laden. ");
INSERT INTO nld1939_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Maar de levieten zullen de dienst bij de openbaringstent verrichten, en daarvoor verantwoordelijk zijn; dit is een eeuwige wet van geslacht tot geslacht. Zij zullen onder de Israëlieten geen erfdeel ontvangen; ");
INSERT INTO nld1939_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","want de tienden der Israëlieten, die zij als cijns aan Jahweh moeten opbrengen, geef Ik aan de levieten tot erfdeel. Daarom heb Ik aangaande hen bepaald: Zij zullen geen erfdeel verkrijgen onder Israëls kinderen. ");
INSERT INTO nld1939_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Beveel de levieten, en zeg hun: Wanneer gij van de Israëlieten de tienden ontvangt, die Ik u als uw erfdeel heb gegeven, dan moet gij daarvan een cijns aan Jahweh afdragen, de tienden namelijk van die tienden; ");
INSERT INTO nld1939_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","dit zal worden beschouwd als uw cijns van het koren op de dorsvloer, en van de wijn uit de perskuip. ");
INSERT INTO nld1939_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Dus ook gij moet uw cijns aan Jahweh afdragen, en wel van al uw tienden, die gij van de Israëlieten ontvangt; deze cijns aan Jahweh moet gij aan den priester Aäron afstaan. ");
INSERT INTO nld1939_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Van al wat gij ontvangt moet gij de volle cijns aan Jahweh brengen, en de heilige gaven moeten het beste deel daarvan zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ge moet hun dus zeggen: Slechts wanneer gij het beste deel daarvan afdraagt, zal dit de levieten worden aangerekend als de opbrengst van dorsvloer en perskuip. ");
INSERT INTO nld1939_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","De rest moogt ge met uw gezinnen op alle plaatsen eten; want het is het loon voor uw dienst bij de openbaringstent. ");
INSERT INTO nld1939_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Wanneer gij maar het beste deel afdraagt, zult ge geen schuld op u laden, de heilige gaven der Israëlieten niet ontwijden, en niet sterven. ");
INSERT INTO nld1939_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Jahweh sprak tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dit is het voorschrift van de wet, die Jahweh geeft: Beveel de Israëlieten, dat zij u een rode koe brengen, gaaf en zonder gebrek, die nog geen juk heeft gedragen. ");
INSERT INTO nld1939_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ge moet haar aan den priester Elazar geven, die haar buiten de legerplaats moet brengen, en daar in zijn tegenwoordigheid laten slachten. ");
INSERT INTO nld1939_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Dan moet de priester Elazar met zijn vinger wat van haar bloed nemen, en het zeven maal voor de openbaringstent sprenkelen. ");
INSERT INTO nld1939_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Daarna moet men de koe in zijn tegenwoordigheid verbranden; haar huid, vlees, en bloed moet men met de darmen verbranden. ");
INSERT INTO nld1939_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Vervolgens moet de priester cederhout, hysop en karmozijn nemen, en dat midden op de brandende koe werpen. ");
INSERT INTO nld1939_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Dan moet de priester zijn kleren wassen en een bad nemen, waarna hij in de legerplaats mag komen; maar de priester blijft tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ook de man, die de koe heeft verbrand, moet zijn kleren wassen, een bad nemen, en is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Nu moet iemand, die rein is, de as van de koe verzamelen, en die buiten de legerplaats op een reine plaats leggen; ze moet voor de gemeenschap der Israëlieten worden bewaard, om er het reinigingswater mee te bereiden; die koe is een zondeoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ook de man, die de as van de koe heeft verzameld, moet zijn kleren wassen, en is tot de avond onrein. Voor de Israëlieten zowel als voor den vreemdeling, die in uw midden woont, geldt voor eeuwig de volgende wet. ");
INSERT INTO nld1939_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wie een lijk van een mens aanraakt, is zeven dagen onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Hij moet op de derde en op de zevende dag zich met dit water laten reinigen; dan is hij weer rein. Zo hij zich op de derde en zevende dag niet heeft laten reinigen, is hij niet rein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Iedereen, die het lijk van een mens aanraakt, en zich niet laat reinigen, bezoedelt de tabernakel van Jahweh, en zal van Israël worden afgesneden. Zolang het reinigingswater niet op hem is gesprenkeld, is hij onrein, en blijft hij onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ook dit is wet: Wanneer een mens in een tent sterft, zal iedereen, die de tent binnentreedt, en alles wat in de tent is, zeven dagen lang onrein zijn; ");
INSERT INTO nld1939_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ook elk open vat, dat niet met een doek is afgedekt, zal onrein zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Zo ook is iedereen, die in het open veld iemand aanraakt, die door het zwaard is vermoord, of een natuurlijke dood is gestorven, de beenderen van een mens, of een graf, zeven dagen onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Voor zulk een onreine moet men wat as van het verbrande zondeoffer nemen, en daarop in een vat levend water doen. ");
INSERT INTO nld1939_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Dan moet een rein man hysop nemen, die in het water dompelen, en de tent besprenkelen, alle voorwerpen en alle personen, die er in waren, en hem die de beenderen, den vermoorde, den gestorvene, of het graf heeft aangeraakt. ");
INSERT INTO nld1939_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Zo moet de reine den onreine op de derde en op de zevende dag besprenkelen. Als hij op de zevende dag is gereinigd, moet hij nog zijn kleren wassen, en een bad nemen; dan is hij des avonds weer rein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Maar wanneer zulk een onreine zich niet laat reinigen, zal hij van de gemeente worden afgesneden, omdat hij het heiligdom van Jahweh bezoedelt. Zolang er geen reinigingswater op hem is gesprenkeld, blijft hij onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Dit is voor u een eeuwige wet. Ook hij, die het reinigingswater sprenkelt, moet zijn kleren wassen; en die aan het reinigingswater komt, is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ook wordt alles wat de onreine aanraakt, onrein; en de persoon, die hem aanraakt, is tot de avond onrein. ");
INSERT INTO nld1939_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Toen in de eerste maand heel de gemeenschap der Israëlieten in de woestijn Sin was gekomen, vestigde het volk zich te Kadesj. Daar stierf Mirjam, en werd zij begraven. ");
INSERT INTO nld1939_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Eens toen de gemeenschap geen water had, liep men tegen Moses en Aäron te hoop. ");
INSERT INTO nld1939_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Het volk zocht twist met Moses, en zei: Ach, waren we maar gestorven, toen onze broeders omkwamen voor het aanschijn van Jahweh! ");
INSERT INTO nld1939_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Waarom hebt gij de gemeente van Jahweh naar deze woestijn gevoerd, om ons hier met ons vee te doen omkomen! ");
INSERT INTO nld1939_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Waarom hebt gij ons uit Egypte geleid, om ons naar deze dorre streek te brengen, waar geen plek is, om te zaaien, waar geen vijg is, geen wijnstok of granaat, zelfs geen water om te drinken! ");
INSERT INTO nld1939_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Toen liepen Moses en Aäron van de gemeente weg naar de ingang van de openbaringstent, en vielen op hun aangezicht neer. De heerlijkheid van Jahweh verscheen hun, ");
INSERT INTO nld1939_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","en Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Neem de staf, en roep met uw broeder Aäron de gemeenschap bijeen, en gebied in hun bijzijn de rots, water te geven. Gij moet voor hen water uit de rots doen vloeien, en de gemeente en haar vee te drinken geven. ");
INSERT INTO nld1939_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses nam dus de staf voor het aanschijn van Jahweh weg, zoals Hij hem bevolen had, ");
INSERT INTO nld1939_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","riep met Aäron de gemeente bijeen voor de rots en sprak tot haar: Luistert, rebellen! Kunnen wij wel uit deze rots voor u water doen vloeien! ");
INSERT INTO nld1939_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Daarbij hief Moses zijn hand op, en sloeg twee maal met zijn staf op de rots; toen vloeide er water in overvloed uit, zodat de gemeenschap met haar vee kon drinken. ");
INSERT INTO nld1939_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Maar Jahweh sprak tot Moses en Aäron: Omdat gij Mij niet hebt geloofd, en Mij voor de ogen van de Israëlieten niet als heilig behandeld hebt, zult gij deze gemeente niet binnenleiden in het land, dat Ik hun heb geschonken. ");
INSERT INTO nld1939_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Dit is het water van Meriba, waar de Israëlieten met Jahweh hebben getwist, en Hij Zich aan hen als heilig toonde. ");
INSERT INTO nld1939_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Van Kadesj uit zond Moses gezanten naar den koning van Edom met de boodschap: Zo spreekt uw broeder Israël! Gij kent alle wederwaardigheden, die wij hebben ondervonden. ");
INSERT INTO nld1939_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Onze vaderen zijn naar Egypte getrokken, en wij hebben lange tijd in Egypte gewoond. Maar de Egyptenaren hebben ons evenals onze vaderen mishandeld. ");
INSERT INTO nld1939_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Wij hebben tot Jahweh geroepen, en Hij heeft ons gehoord, en zijn engel gezonden, om ons uit Egypte te leiden. Nu zijn wij in Kadesj, een stad aan de grens van uw gebied, ");
INSERT INTO nld1939_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","en wij zouden graag door uw land trekken. Wij zullen niet door uw velden en wijngaarden gaan, en geen water drinken uit uw putten, maar de koninklijke weg blijven houden, zonder rechts of links af te wijken, zolang wij door uw gebied trekken. ");
INSERT INTO nld1939_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Maar Edom gaf hem ten antwoord: Gij moogt er bij mij niet door; anders trek ik u met het zwaard tegemoet. ");
INSERT INTO nld1939_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","De Israëlieten drongen bij hem aan: Wij zullen de gebaande wegen houden, en mocht ik of mijn vee van uw water drinken, dan zal ik daarvoor betalen. Het heeft toch niets te betekenen, dat ik te voet er doorheen trek. ");
INSERT INTO nld1939_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Hij antwoordde: Ge komt er niet door! En Edom trok hem met veel volk en sterk gewapend tegemoet. ");
INSERT INTO nld1939_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Daar Edom dus aan Israël de doortocht weigerde door zijn gebied, moest Israël om hem heen trekken. ");
INSERT INTO nld1939_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Toen heel de gemeenschap der Israëlieten van Kadesj was opgetrokken, bereikten zij de berg Hor. ");
INSERT INTO nld1939_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","En op de berg Hor, aan de grens van het land van Edom, sprak Jahweh tot Moses en Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aäron zal bij zijn volk worden verzameld; want hij zal het land, dat Ik de Israëlieten heb gegeven, niet binnengaan, omdat gij beiden u bij het water van Meriba tegen mijn bevel hebt verzet. ");
INSERT INTO nld1939_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Neem Aäron en zijn zoon Elazar met u mee, en laat ze de berg Hor bestijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ontdoe Aäron van zijn gewaden, en bekleed er zijn zoon Elazar mee. Dan zal Aäron daar bij zijn volk worden verzameld en daar sterven. ");
INSERT INTO nld1939_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses deed, wat Jahweh hem had bevolen, en ten aanschouwen van heel de gemeenschap bestegen zij de berg Hor. ");
INSERT INTO nld1939_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses ontdeed Aäron van zijn gewaden, en bekleedde er zijn zoon Elazar mee. En Aäron stierf daar op de top van de berg. Toen Moses en Elazar van de berg afdaalden, ");
INSERT INTO nld1939_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","en heel de gemeenschap zag, dat Aäron gestorven was, beweende heel het huis van Israël Aäron dertig dagen lang. ");
INSERT INTO nld1939_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Toen de kanaänietische koning van Arad, die in de Négeb woonde, hoorde, dat Israël de weg naar Atarim had ingeslagen, viel hij Israël aan, en nam enigen hunner gevangen. ");
INSERT INTO nld1939_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Toen deed Israël aan Jahweh deze gelofte: Zo Gij dit volk in mijn hand levert, zal ik hun steden met de ban slaan! ");
INSERT INTO nld1939_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Toen Jahweh Israël had verhoord, en de Kanaänieten had overgeleverd, sloeg men dan ook hun steden met de ban, en noemde die stad Chorma. ");
INSERT INTO nld1939_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Van de berg Hor braken zij op in de richting van de Rode Zee, om rond het land van Edom te trekken. Maar door die tocht werd het volk ongeduldig, ");
INSERT INTO nld1939_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","en sprak tegen God en Moses: Waarom hebt ge ons uit Egypte geleid, om te sterven in de woestijn? Want we hebben geen brood en geen water, en we walgen van die armzalige kost! ");
INSERT INTO nld1939_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Daarom zond Jahweh vergiftige slangen onder het volk, die het beten, zodat er velen van Israël stierven. ");
INSERT INTO nld1939_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Toen liep het volk naar Moses, en sprak: Wij hebben gezondigd; want we zijn onbeschaamd geweest tegen Jahweh en tegen u! Bid Jahweh toch, dat Hij de slangen van ons wegneemt. En Moses bad voor het volk. ");
INSERT INTO nld1939_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Toen sprak Jahweh tot Moses: Maak een slang, en bevestig die aan een paal; dan zal iedereen, die gebeten is en er naar opziet, in leven blijven. ");
INSERT INTO nld1939_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moses maakte een koperen slang, en bevestigde die aan een paal. En wanneer iemand door een slang werd gebeten, en hij zag op naar de koperen slang, dan bleef hij in leven. ");
INSERT INTO nld1939_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Toen trokken de Israëlieten verder, en legerden zich te Obot. ");
INSERT INTO nld1939_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Van Obot trokken zij verder, en legerden zich te Ijje-Haäbarim in de woestijn, ten oosten van Moab. ");
INSERT INTO nld1939_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Van daar trokken zij verder, en legerden zich in het dal Zéred. ");
INSERT INTO nld1939_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Van daar trokken zij verder, en legerden zich aan de overkant van de Arnon, waar hij nog in de woestijn ligt en uit het land der Amorieten komt; want de Arnon is de grens van Moab tussen Moab en de Amorieten. ");
INSERT INTO nld1939_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Daarom heet het in het boek van de oorlogen van Jahweh: Waheb in Soefa, En de kloven van de Arnon: ");
INSERT INTO nld1939_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","De steilste der kloven, Die zich uitstrekt tot de omgeving van Ar En aanleunt tegen de grenzen van Moab. ");
INSERT INTO nld1939_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Van daar trokken zij verder naar Beër; dit is de welput, waar Jahweh tot Moses heeft gesproken: “Roep het volk bijeen, en Ik zal hun water geven”, ");
INSERT INTO nld1939_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","en waar Israël toen dit lied heeft gezongen: Wel op, gij put! Zingt hem ter eer, ");
INSERT INTO nld1939_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","De put, die koningen hebben gegraven, Vorsten van het volk hebben gedolven Met hun schepter, met hun staven. Van Beër trok men verder naar Mattana, ");
INSERT INTO nld1939_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","van Mattana naar Nachaliël, van Nachaliël naar Bamot, ");
INSERT INTO nld1939_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","van Bamot naar het dal in de vlakte van Moab, en naar de top van de Pisga, die oprijst ten oosten van de woestenij. ");
INSERT INTO nld1939_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Nu zond Israël gezanten naar Sichon, den koning der Amorieten, met de boodschap: ");
INSERT INTO nld1939_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ik zou graag door uw land trekken. Wij zullen niet door uw velden en wijngaarden gaan, en geen water drinken uit uw putten, maar de koninklijke weg blijven houden, zolang we door uw gebied trekken. ");
INSERT INTO nld1939_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Maar Sichon stond Israël niet toe, door zijn gebied te trekken. Sichon verzamelde al zijn volk, trok Israël in de woestijn tegemoet, rukte op naar Jáhas en greep Israël aan. ");
INSERT INTO nld1939_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israël joeg hem over de kling, en nam zijn land in bezit van de Arnon af tot de Jabbok, dus tot aan de Ammonieten toe; want Jazer was de grens der Ammonieten. ");
INSERT INTO nld1939_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israël veroverde al de steden der Amorieten, en vestigde zich in die steden, tot zelfs in Chesjbon en al haar onderhorige plaatsen. ");
INSERT INTO nld1939_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Want Chesjbon was de stad van Sichon, den koning der Amorieten, die vroeger tegen den koning van Moab had gestreden, en hem toen al zijn land had ontrukt tot de Arnon toe. ");
INSERT INTO nld1939_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daarom zeggen de zangers: Komt, om Chesjbon te herbouwen, De stad van Sichon te versterken! ");
INSERT INTO nld1939_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Want een vuur ging uit van Chesjbon, Een vlam uit Sichons stad: Het verteerde de steden van Moab, Verslond de hoogten van de Arnon. ");
INSERT INTO nld1939_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wee u, Moab; Gij zijt verloren. volk van Kemosj! Zijn zonen heeft hij tot vluchtelingen gemaakt, Zijn dochters gevangenen van Sichon, den Amorietenkoning; ");
INSERT INTO nld1939_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Hun spruiten kwamen om, van Chesjbon tot Dibon: Hun vrouwen tot Nófach, dat bij Medeba ligt. ");
INSERT INTO nld1939_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Toen Israël in het land der Amorieten vaste voet had gekregen, ");
INSERT INTO nld1939_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","liet Moses Jazer verspieden, nam het met haar onderhorige plaatsen in, en verdreef de Amorieten, die daar woonden. ");
INSERT INTO nld1939_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Daarna veranderden zij van richting, en sloegen de weg in naar Basjan. Maar Og, de koning van Basjan, rukte hen met al zijn volk bij Edréi tegemoet, om hen te bestrijden. ");
INSERT INTO nld1939_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Doch Jahweh sprak tot Moses: Vrees hem niet; want Ik heb hem met heel zijn volk en heel zijn land in uw hand geleverd: ge moet met hem doen, wat ge met Sichon, den koning der Amorieten, hebt gedaan, die in Chesjbon woonde. ");
INSERT INTO nld1939_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Zij versloegen hem dus met zijn zonen en heel zijn volk, tot er geen vluchteling meer overbleef, en zij namen zijn land in bezit. ");
INSERT INTO nld1939_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Daarna trokken de Israëlieten verder, en legerden zich in de velden van Moab, aan de overkant van de Jordaan bij Jericho. ");
INSERT INTO nld1939_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Maar Balak, de zoon van Sippor, had alles gezien, wat Israël de Amorieten had berokkend. ");
INSERT INTO nld1939_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","En Moab werd zeer bevreesd voor het volk, omdat het heel talrijk was; en vol angst voor de Israëlieten ");
INSERT INTO nld1939_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","sprak Moab tot de oudsten van Midjan: Die zwerm zal nog heel de omtrek kaal vreten, zoals het rund de velden afgraast. Daarom zond Balak, de zoon van Sippor, die toen koning van Moab was, ");
INSERT INTO nld1939_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","gezanten naar Balaäm, den zoon van Beor, te Petor aan de Rivier in het land van zijn volksgenoten, om hem te ontbieden. Ze moesten zeggen: Daar is een volk uit Egypte getogen, dat het land overdekt, en zich vlak naast mij heeft genesteld. ");
INSERT INTO nld1939_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kom dus, en vervloek mij dat volk; want het is mij te machtig. Misschien kan ik het dan verslaan, en het uit het land verdrijven; want ik weet: Wien gij zegent, is gezegend, en wien gij vervloekt, is vervloekt. ");
INSERT INTO nld1939_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","De oudsten van Moab en Midjan gingen dus op weg, en namen het waarzeggersloon met zich mee. Ze kwamen bij Balaäm aan, en brachten hem het verzoek van Balak over. ");
INSERT INTO nld1939_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Hij gaf hun ten antwoord: Blijft vannacht hier; dan deel ik u de beslissing mee, die Jahweh mij ingeeft. De vorsten van Moab bleven dus bij Balaäm overnachten. ");
INSERT INTO nld1939_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nu verscheen God aan Balaäm, en sprak: Wie zijn deze mannen, die bij u overnachten? ");
INSERT INTO nld1939_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaäm zeide tot God: Balak, de zoon van Sippor, de koning van Moab, heeft mij laten berichten: ");
INSERT INTO nld1939_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Daar is een volk uit Egypte getogen, dat het land overdekt. Kom dus, en vervloek het voor mij; misschien kan ik het dan overwinnen en verdrijven. ");
INSERT INTO nld1939_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Maar God sprak tot Balaäm: Gij moogt niet met hen meegaan, en dat volk niet vervloeken; want het is gezegend. ");
INSERT INTO nld1939_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Daarom zei Balaäm de volgende morgen tot de vorsten van Balak: Gaat terug naar uw land; want Jahweh wil mij niet toestaan, met u mee te gaan. ");
INSERT INTO nld1939_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","De vorsten van Moab vertrokken dus, kwamen bij Balak aan, en zeiden: Balaäm heeft geweigerd, met ons mee te gaan. ");
INSERT INTO nld1939_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Toen zond Balak opnieuw vorsten, talrijker en aanzienlijker nog dan de eersten. ");
INSERT INTO nld1939_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ook dezen kwamen bij Balaäm aan, en zeiden tot hem: Zo spreekt Balak, de zoon van Sippor! Laat u toch niet weerhouden, tot mij te komen; ");
INSERT INTO nld1939_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","want ik zal u vorstelijk belonen, en al wat gij mij zegt, zal ik doen. Kom slechts, en vervloek mij dat volk. ");
INSERT INTO nld1939_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Maar Balaäm antwoordde de dienaren van Balak: Al gaf Balak mij zijn huis vol zilver en goud, ik kan het bevel van Jahweh, mijn God, niet overtreden, in het kleine noch in het grote. ");
INSERT INTO nld1939_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Maar blijft ook gij vannacht hier; dan zal ik weten, wat Jahweh mij verder beveelt. ");
INSERT INTO nld1939_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","En God verscheen Balaäm des nachts, en sprak tot hem: Zo die mannen gekomen zijn, om u te ontbieden, ga dan met hen mee; maar doe slechts, wat Ik u zeg! ");
INSERT INTO nld1939_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaäm maakte zich dus in de morgen gereed, zadelde zijn ezelin, en ging met de vorsten van Moab mee. ");
INSERT INTO nld1939_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Toch was God vergramd dat hij ging. Daarom plaatste een engel van Jahweh zich op de weg, om hem tegen te houden, terwijl hij vergezeld van twee dienaren op zijn ezelin kwam aangereden. ");
INSERT INTO nld1939_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Toen de ezelin den engel van Jahweh met het getrokken zwaard in de hand op de weg zag staan, week de ezelin van de weg af, en ging het veld in. Balaäm sloeg de ezelin, om haar weer op de weg terug te brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nu plaatste de engel zich op een smal pad, dat tussen de wijngaarden liep, en aan weerskanten een muur had. ");
INSERT INTO nld1939_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Toen de ezelin den engel van Jahweh zag, drong zij zich tegen de muur, en knelde de voet van Balaäm tegen de muur; hij sloeg haar opnieuw. ");
INSERT INTO nld1939_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Daarna ging de engel van Jahweh verder, en plaatste zich op een nauw punt, waar geen gelegenheid was, om naar rechts of links uit te wijken. ");
INSERT INTO nld1939_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Toen de ezelin den engel van Jahweh zag, ging ze onder Balaäm liggen. Balaäm werd kwaad, en ranselde de ezelin met een stok. ");
INSERT INTO nld1939_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Maar nu opende Jahweh de bek van de ezelin, en ze zei tegen Baläam: Wat heb ik u toch gedaan, dat ge me nu voor de derde maal slaat? ");
INSERT INTO nld1939_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaäm antwoordde de ezelin: Omdat ge mij voor de gek houdt; had ik een zwaard in mijn hand, dan sloeg ik je dood. ");
INSERT INTO nld1939_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","De ezelin vervolgde tot Balaäm: Ben ik niet uw ezelin, waarop ge van jongsaf rijdt tot de dag van vandaag; ben ik gewoon, mij zo tegenover u te gedragen? Hij antwoordde: Neen. ");
INSERT INTO nld1939_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Toen opende Jahweh de ogen van Balaäm, zodat hij den engel van Jahweh op de weg zag staan met het getrokken zwaard in zijn hand; hij wierp zich neer, en boog zich met zijn aangezicht ter aarde. ");
INSERT INTO nld1939_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","De engel van Jahweh sprak tot hem: Waarom slaat gij uw ezelin nu al voor de derde maal? Zie, ik ben uitgetrokken, om u tegen te houden; want uw tocht is tegen mijn wil. ");
INSERT INTO nld1939_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","De ezelin heeft mij bespeurd, en is drie maal voor mij uitgeweken; had ze het niet gedaan, dan had ik u gedood, maar haar in leven gelaten. ");
INSERT INTO nld1939_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Toen zei Balaäm tot den engel van Jahweh: Ik heb gezondigd; ik wist immers niet, dat gij op de weg voor mij stondt. Als het u dus niet behaagt, keer ik terug. ");
INSERT INTO nld1939_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Maar de engel van Jahweh zei tot Balaäm: Ga met die mannen mee, doch spreek slechts, wat Ik u zeg. Toen ging Balaäm met de vorsten van Balak mee. ");
INSERT INTO nld1939_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Zodra Balak hoorde, dat Balaäm in aantocht was, trok hij hem tegemoet tot Ar-Moab, dat aan de Arnon ligt, aan de uiterste grens van het land. ");
INSERT INTO nld1939_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","En Balak zei tot Balaäm: Heb ik u niet dringend laten ontbieden? Waarom kwaamt ge dan niet naar mij toe? Gij dacht zeker, dat ik u niet genoeg kon belonen. ");
INSERT INTO nld1939_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Maar Balaäm antwoordde Balak: Zie, ik ben tot u gekomen, maar ik zal geen ander woord kunnen spreken, dan Jahweh mij in de mond legt! ");
INSERT INTO nld1939_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaäm ging met Balak verder, en zij kwamen te Kirjat-Choesot. ");
INSERT INTO nld1939_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Daar offerde Balak runderen en schapen, en liet er van aan Balaäm brengen en aan de vorsten, die hem vergezelden. ");
INSERT INTO nld1939_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","De volgende morgen nam Balak Balaäm met zich mee, en deed hem Bamot-Báal bestijgen, vanwaar hij het volk tot de uiterste rijen kon overzien. ");
INSERT INTO nld1939_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Toen sprak Balaäm tot Balak: Bouw hier voor mij zeven altaren, en maak zeven stieren en zeven rammen voor mij gereed. ");
INSERT INTO nld1939_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak deed zoals Balaäm gezegd had, en offerde een stier en een ram op ieder altaar. ");
INSERT INTO nld1939_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Nu sprak Balaäm tot Balak: Blijf hier bij uw offer, terwijl ik heenga. Misschien dat Jahweh mij verschijnt; dan zal ik u verkondigen, wat Hij mij openbaart. Toen ging hij naar een kale heuvel, ");
INSERT INTO nld1939_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","waar God hem verscheen. Balaäm zeide tot Hem: Ik heb zeven altaren gebouwd, en op ieder altaar een stier en een ram laten offeren. ");
INSERT INTO nld1939_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nu legde Jahweh Balaäm een woord in de mond, en sprak: Keer terug naar Balak, en zeg dit. ");
INSERT INTO nld1939_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Hij keerde dan naar hem terug, terwijl hij nog bij zijn offer stond met al de vorsten van Moab. ");
INSERT INTO nld1939_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Hij hief zijn orakel aan en sprak: Uit Aram heeft mij Balak ontboden, Moabs koning uit de bergen ten oosten: Kom, vloek voor mij Jakob, Kom, verwens Israël! ");
INSERT INTO nld1939_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Maar hoe zal ik vervloeken, Dien God niet vervloekt; Hoe zal ik verwensen Dien Jahweh niet verwenst! ");
INSERT INTO nld1939_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Waarachtig, ik zie het van de top van de rotsen, Ik aanschouw het van de heuvelen af: Zie, een volk dat in afzondering woont, En zich niet onder de volken rekent. ");
INSERT INTO nld1939_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Maar wie zal het stof van Jakob tellen, Wie Israëls drommen berekenen? Mocht ik de dood der rechtvaardigen sterven, Mocht mijn einde zijn als het hunne! ");
INSERT INTO nld1939_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Maar Balak zeide tot Balaäm: Wat doet ge me nu! Ik heb u ontboden om mijn vijanden te vervloeken; en zie, ge spreekt een zegening uit! ");
INSERT INTO nld1939_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Hij gaf hem ten antwoord: Moet ik dan niet eerlijk spreken, wat Jahweh mij in de mond heeft gelegd? ");
INSERT INTO nld1939_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Toen zei Balak tot hem: Kom met mij naar een andere plaats, vanwaar gij slechts zijn uiterste rijen kunt zien, en niet het geheel; vandaar zult ge het voor mij vervloeken. ");
INSERT INTO nld1939_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hij nam hem dus mee naar het Spiedersveld op de top van de Pisga, waar hij zeven altaren bouwde, en op ieder altaar een stier en een ram offerde. ");
INSERT INTO nld1939_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","En Balaäm sprak tot Balak: Blijf hier bij uw offer staan: terwijl ik heenga, om een nieuwe verschijning te hebben. ");
INSERT INTO nld1939_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","En Jahweh verscheen aan Balaäm, legde een woord in zijn mond en sprak: Keer terug naar Balak, en zeg dit. ");
INSERT INTO nld1939_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Hij ging naar hem toe, terwijl deze nog bij zijn offer stond met de vorsten van Moab. Balak vroeg hem: Wat heeft Jahweh gezegd? ");
INSERT INTO nld1939_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Toen hief hij zijn orakel aan en sprak: Sta op, Balak, en hoor: Luister naar mij, zoon van Sippor: ");
INSERT INTO nld1939_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is geen mens, die zijn woord breekt, Geen mensenkind, wien iets berouwt. Zou Hij iets zeggen, dat Hij niet uitvoert; Iets spreken, dat Hij niet houdt? ");
INSERT INTO nld1939_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Zie, ik heb opdracht te zegenen, Ik zegen, en trek het niet terug: ");
INSERT INTO nld1939_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ik aanschouw geen onheil in Jakob, Zie geen rampen in Israël! Jahweh, zijn God, is met hem, Koningsjubel klinkt onder hem op. ");
INSERT INTO nld1939_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God heeft hem uit Egypte geleid, Het heeft hoornen als die van een buffel. ");
INSERT INTO nld1939_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Neen, tegen Jakob helpt geen waarzeggerij, Geen wichelarij tegen Israël: Thans wordt over Jakob gezegd, En over Israël, wat God zal doen. ");
INSERT INTO nld1939_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ziedaar een volk, dat zich opricht als een leeuwin, En als een leeuw zich verheft; Dat niet neerligt, eer het zijn buit heeft verslonden, En het bloed der gesneuvelden heeft gedronken. ");
INSERT INTO nld1939_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Nu zei Balak tot Balaäm: Kunt ge het niet vervloeken, zegen het tenminste niet. ");
INSERT INTO nld1939_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Maar Balaäm antwoordde Balak: Heb ik u niet gezegd: “Al wat Jahweh mij zegt, zal ik doen?” ");
INSERT INTO nld1939_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Toen zei Balak tot Balaäm: Kom, ik zal u naar een andere plaats brengen: misschien behaagt het God, dat gij het van daaruit vervloekt. ");
INSERT INTO nld1939_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak nam Balaäm dus mee naar de top van de Peor, die oprijst ten oosten van de woestenij. ");
INSERT INTO nld1939_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Daar sprak Balaäm tot Balak: Bouw hier voor mij zeven altaren, en maak zeven stieren en zeven rammen voor mij gereed. ");
INSERT INTO nld1939_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak deed, wat Balaäm gezegd had, en offerde een stier en een ram op ieder altaar. ");
INSERT INTO nld1939_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Maar daar Balaäm inzag, dat het Jahweh behaagde Israël te zegenen, ging hij niet heen als de vorige keren, om waarzeggende tekens te vinden, doch liep de woestijn in. ");
INSERT INTO nld1939_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Toen Balaäm echter zijn ogen opsloeg en Israël volgens zijn stammen gelegerd zag, kwam de geest van God op hem. ");
INSERT INTO nld1939_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Hij hief zijn orakel aan, en sprak: Godsspraak van Balaäm, zoon van Beor, Godsspraak van den man, met het open oog; ");
INSERT INTO nld1939_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Godsspraak van een, die Gods woorden hoort, En de gedachte van den Allerhoogste kent; Die gezichten van den Almachtige schouwt. En neerzinkt met ontsluierde blik. ");
INSERT INTO nld1939_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hoe schoon zijn uw tenten, o Jakob, Uw woningen, o Israël: ");
INSERT INTO nld1939_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Als dalen strekken zij zich uit, Als tuinen langs een rivier, Als eiken, door Jahweh geplant, Als ceders langs waterstromen. ");
INSERT INTO nld1939_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Het water vloeit over zijn emmers, Zijn zaad wordt volop gedrenkt. Boven Agag verheft zich zijn koning, En is zijn koningschap verheven. ");
INSERT INTO nld1939_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God heeft hem uit Egypte geleid; Het heeft hoornen als die van een buffel. Hij verslindt de volken, die zijn vijanden zijn, Vermorzelt hun beenderen, verbrijzelt hun lenden, ");
INSERT INTO nld1939_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Hij kromt zich, vlijt zich neer als een leeuw, En als een leeuwin; wie durft hem wekken? Die u zegenen, zijn gezegend, Die u vervloeken, vervloekt! ");
INSERT INTO nld1939_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Maar nu werd Balak woedend op Balaäm; hij sloeg zijn handen ineen, en zei tegen hem: Ik heb u ontboden, om mijn vijanden te vervloeken; en zie, tot driemaal toe spreekt ge zegening uit. ");
INSERT INTO nld1939_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Maak dat ge wegkomt naar huis. Ik heb beloofd, u vorstelijk te belonen, maar Jahweh heeft u het loon niet gegund. ");
INSERT INTO nld1939_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaäm gaf Balak ten antwoord: Heb ik uw boden, die gij naar mij toezondt, niet gezegd: ");
INSERT INTO nld1939_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Al geeft Balak mij zijn huis vol zilver en goud, ik kan het bevel van Jahweh niet overtreden, en uit mijzelf iets doen, goed of kwaad; ik spreek slechts, wat Jahweh beveelt. ");
INSERT INTO nld1939_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nu keer ik terug naar mijn volk; maar ik wil u eerst nog verkonden, wat dit volk aan het uwe zal doen op het einde der tijden. ");
INSERT INTO nld1939_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Toen hief hij zijn orakel aan, en sprak: Godsspraak van Balaäm, zoon van Beor, Godsspraak van den man, met het open oog; ");
INSERT INTO nld1939_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Godsspraak van een, die Gods woorden hoort, En de gedachte van den Allerhoogste kent; Die gezichten van den Almachtige schouwt, En neerzinkt met ontsluierde blik! ");
INSERT INTO nld1939_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ik zie Hem, maar niet in het heden, Ik aanschouw Hem, maar niet van nabij: Een ster rijst omhoog uit Jakob, Een schepter komt uit Israël op; Hij verbrijzelt de slapen van Moab, De schedel van al die verwatenen. ");
INSERT INTO nld1939_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom wordt een wingewest, Een wingewist Seïr. Israël zal dappere daden verrichten, ");
INSERT INTO nld1939_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","En heersen uit Jakob; Zijn vijanden zal Hij verdelgen, De resten van Seïr. ");
INSERT INTO nld1939_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Maar toen hij Amalek zag, hief hij zijn orakel aan, en sprak: De keur der volken is Amalek, Maar zijn nageslacht is ten ondergang gedoemd! ");
INSERT INTO nld1939_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Toen hij den Keniet zag, hief hij zijn orakel aan, en sprak: Uw woning is stevig, En uw nest is gebouwd op de rots, ");
INSERT INTO nld1939_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Toch zal Kaïn worden verwoest: Wanneer voert Assjoer u weg? ");
INSERT INTO nld1939_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hij vervolgde zijn orakel en sprak: Wee, wie zal leven, als God het voltrekt? ");
INSERT INTO nld1939_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Van de kust der Kittiërs komen schepen. Die Assjoer met Eber vernederen; Ook deze is ten ondergang gedoemd! ");
INSERT INTO nld1939_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Toen stond Balaäm op, en keerde naar zijn woonplaats terug; en ook Balak ging zijns weegs. ");
INSERT INTO nld1939_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Toen Israël in Sjittim vertoefde, begon het volk ontucht te plegen met de dochters van Moab, ");
INSERT INTO nld1939_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","en deze nodigden het volk uit tot de offers van haar goden. Het volk nam aan die offermaaltijden deel, aanbad haar goden, ");
INSERT INTO nld1939_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","en Israël diende Báal-Peor. Daarom ontbrandde de toorn van Jahweh tegen Israël. ");
INSERT INTO nld1939_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","En Jahweh sprak tot Moses:Neem alle schuldigen onder het volk, en hang ze voor Jahweh op in de volle zon, opdat Jahweh’s gloeiende toorn van Israël moge wijken. ");
INSERT INTO nld1939_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moses beval dus de rechters van Israël: Ieder moet zijn mannen doden, die Báal-Peor hebben vereerd. ");
INSERT INTO nld1939_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Maar terwijl Moses en heel de gemeenschap der Israëlieten bij de ingang van de openbaringstent weenden, kwam er nog een Israëliet voor hun ogen een midjanietische vrouw naar de zijnen brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Toen Pinechas, de zoon van Elazar, den zoon van den priester Aäron, dit zag, stond hij op uit de kring der gemeenschap, greep een speer, ");
INSERT INTO nld1939_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ging den Israëliet tot in het slaapvertrek achterna, en doorstak hen beiden, den Israëliet en de vrouw in het slaapvertrek. Toen hield die ramp onder de Israëlieten op. ");
INSERT INTO nld1939_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Maar door die ramp waren er intussen vier en twintig duizend gestorven. ");
INSERT INTO nld1939_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nu sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinechas, de zoon van Elazar, den zoon van den priester Aäron, heeft door zijn ijveren onder hen voor mijn zaak, mijn toorn van de Israëlieten afgewend, zodat Ik de Israëlieten in mijn ijverzucht niet hoef te verdelgen. ");
INSERT INTO nld1939_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Zeg daarom: Zie, Ik sluit met hem mijn vredesverbond. ");
INSERT INTO nld1939_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Het zal een verbond van een eeuwig priesterschap zijn voor hem en zijn geslacht, omdat hij voor zijn God heeft geijverd en voor de Israëlieten verzoening heeft verkregen. ");
INSERT INTO nld1939_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","De gedode Israëliet, die met de Midjanietische doorstoken was, heette Zimri; hij was de zoon van Saloe, en een familiehoofd der Simeonieten. ");
INSERT INTO nld1939_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","De gedode midjanietische vrouw heette Kozbi; ze was de dochter van Soer, die stam- en familiehoofd was in Midjan. ");
INSERT INTO nld1939_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Behandel de Midjanieten als vijanden en dood ze. ");
INSERT INTO nld1939_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Want ze hebben u als vijand behandeld met hun listige streken, die zij tegen u hebben bedacht in de geschiedenis met Peor en met hun zuster Kozbi, de dochter van het midjanietisch stamhoofd, die doorstoken werd op de dag van de ramp om Peor. ");
INSERT INTO nld1939_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Na de ramp sprak God tot Moses en tot Elazar, den zoon van den priester Aäron: ");
INSERT INTO nld1939_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Neemt het getal op van heel de gemeenschap der Israëlieten van twintig jaar af, alle strijdbare mannen in Israël naar hun families. ");
INSERT INTO nld1939_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moses en de priester Elazar monsterden ze dus in de velden van Moab aan de Jordaan bij Jericho, ");
INSERT INTO nld1939_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","van twintig jaar af, zoals Jahweh het Moses bevolen had. Dit waren de Israëlieten die uit Egypte waren getrokken: ");
INSERT INTO nld1939_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, Israëls eerstgeborene. De geslachten der Rubenieten waren: Het geslacht der Chanokieten van Chanok; het geslacht der Palloeïeten van Palloe; ");
INSERT INTO nld1939_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","het geslacht der Chesronieten van Chesron; het geslacht der Karmieten van Karmi. ");
INSERT INTO nld1939_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dit waren de geslachten der Rubenieten; hun gemonsterden telden drie en veertig duizend zevenhonderd dertig man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","De zoon van Palloe was Eliab. ");
INSERT INTO nld1939_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","De zonen van Eliab waren: Nemoeël, Datan, en Abiram. Deze Datan en Abiram waren de voormannen geweest, die met de aanhang van Kore tegen Moses en Aäron in verzet waren gekomen bij de opstand tegen Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","De aarde had haar muil geopend en hen met Kore verslonden, toen de bende omkwam, en het vuur de twee honderd vijftig mannen verteerde, zodat zij een waarschuwend teken werden. ");
INSERT INTO nld1939_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","De zonen van Kore waren echter niet omgekomen. ");
INSERT INTO nld1939_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","De geslachten der Simeonieten waren: Het geslacht der Nemoeëlieten van Nemoeël; het geslacht der Jaminieten van Jamin; het geslacht der Jakinieten van Jakin; ");
INSERT INTO nld1939_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","het geslacht der Zarchieten van Zérach; het geslacht der Sjaoelieten van Sjaoel. ");
INSERT INTO nld1939_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Dit waren de geslachten der Simeonieten; hun gemonsterden telden twee en twintig duizend tweehonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","De geslachten der Gadieten waren: het geslacht der Sefonieten van Sefon; het geslacht der Chaggieten van Chaggi; het geslacht der Sjoenieten van Sjoeni; ");
INSERT INTO nld1939_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","het geslacht der Oznieten van Ozni; het geslacht der Erieten van Eri; ");
INSERT INTO nld1939_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","het geslacht der Arodieten van Arod, het geslacht der Arelieten van Areli. ");
INSERT INTO nld1939_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Dit waren de geslachten van de Gadieten; hun gemonsterden telden veertig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","De zonen van Juda waren: Er en Onan. Er en Onan waren in het land Kanaän gestorven. ");
INSERT INTO nld1939_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","De geslachten van de Judeërs waren: het geslacht der Sjelanieten van Sjela; het geslacht der Farsieten van Fares; het geslacht der Zarieten van Zara. ");
INSERT INTO nld1939_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","De zonen van Fares waren: het geslacht der Esronieten van Esron; het geslacht der Chamoelieten van Chamoel. ");
INSERT INTO nld1939_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Dit waren de geslachten van Juda; hun gemonsterden telden zes en zeventig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","De geslachten der Issakarieten waren: Het geslacht der Tolaïeten van Tola; het geslacht der Poewwieten van Poewwa; ");
INSERT INTO nld1939_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","het geslacht der Jasjoebieten van Jasjoeb; het geslacht der Sjimronieten van Sjimron. ");
INSERT INTO nld1939_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Dit waren de geslachten van Issakar; hun gemonsterden telden vier en zestig duizend driehonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","De geslachten der Zabulonieten waren: Het geslacht der Sardieten van Séred; het geslacht der Elonieten van Elon; het geslacht der Jachleëlieten van Jachleël. ");
INSERT INTO nld1939_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Dit waren de geslachten der Zabulonieten; hun gemonsterden telden zestig duizend vijfhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","De zonen van Josef waren Manasse en Efraïm. ");
INSERT INTO nld1939_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","De geslachten der Manassieten waren: het geslacht der Makirieten van Makir. Makir bracht Gilad voort; het geslacht der Giladieten van Gilad. ");
INSERT INTO nld1939_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dit waren de zonen van Gilad: het geslacht der Iëzerieten van Iézer; het geslacht der Chelkieten van Chélek; ");
INSERT INTO nld1939_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","het geslacht der Asriëlieten van Asriël; het geslacht der Sjikmieten van Sjékem; ");
INSERT INTO nld1939_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","het geslacht der Sjemidaïeten van Sjemida; het geslacht der Chefrieten van Chéfer. ");
INSERT INTO nld1939_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofchad, de zoon van Chéfer, had geen zonen, maar alleen dochters; de dochters van Selofchad heetten Machla, Noa, Chogla, Milka en Tirsa. ");
INSERT INTO nld1939_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Dit waren de geslachten van Manasse; hun gemonsterden telden twee en vijftig duizend zevenhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","De geslachten der Efraïmieten waren: het geslacht der Sjoetalchieten van Sjoetélach; het geslacht der Bakrieten van Béker; het geslacht der Tachanieten van Táchan. ");
INSERT INTO nld1939_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","En dit waren de zonen van Sjoetélach: het geslacht der Eranieten van Eran. ");
INSERT INTO nld1939_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Dit waren de geslachten der Efraïmieten; hun gemonsterden telden twee en dertig duizend vijfhonderd man. Dit waren de zonen van Josef volgens hun geslachten. ");
INSERT INTO nld1939_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","De geslachten der Benjamieten waren: het geslacht der Balieten van Béla; het geslacht der Asjbelieten van Asjbel; het geslacht der Achiramieten van Achiram; ");
INSERT INTO nld1939_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","het geslacht der Sjoefamieten van Sjoefam; het geslacht der Choefamieten van Choefam. ");
INSERT INTO nld1939_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","De zonen van Bela waren Ard en Naäman: het geslacht der Ardieten van Ard; het geslacht der Naämieten van Naäman. ");
INSERT INTO nld1939_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dit waren de geslachten der Benjamieten; hun gemonsterden telden vijf en veertig duizend zeshonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dit waren de geslachten der Danieten: het geslacht der Sjoechamieten van Sjoecham. Dit waren de geslachten van Dan volgens hun geslachten. ");
INSERT INTO nld1939_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Dit waren alle geslachten der Sjoechamieten; hun gemonsterden telden vier en zestig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","De geslachten der Aserieten waren: het geslacht der Jimnaïeten van Jimna; het geslacht der Jisjwieten van Jisjwi; het geslacht der Beriïeten van Beria. ");
INSERT INTO nld1939_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Van de zonen van Beria: het geslacht der Chebrieten van Chéber; het geslacht der Malkiëlieten van Malkiël. ");
INSERT INTO nld1939_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","De dochter van Aser heette Sérach. ");
INSERT INTO nld1939_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Dit waren de geslachten der Aserieten; hun gemonsterden telden drie en vijftig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","De geslachten der Neftalieten waren: het geslacht der Jachseëlieten van Jachseël; het geslacht der Goenieten van Goeni; ");
INSERT INTO nld1939_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","het geslacht der Jisrieten van Jéser; het geslacht der Sjillemieten van Sjillem. ");
INSERT INTO nld1939_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Dit waren de geslachten van Neftali volgens hun geslachten; hun gemonsterden telden vijf en veertig duizend vierhonderd man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","De gemonsterde Israëlieten telden dus zes honderd een duizend zevenhonderd dertig man. ");
INSERT INTO nld1939_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Onder dezen moet naar het aantal personen het land in eigendom worden verdeeld. ");
INSERT INTO nld1939_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Aan een grote stam moet ge een groot, aan een kleine een klein erfdeel toewijzen; aan iedereen moet naar het aantal van zijn gemonsterden een erfdeel worden geschonken. ");
INSERT INTO nld1939_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Maar het land moet door het lot worden verdeeld, hoewel de voorvaderlijke stammen hun erfdeel zullen ontvangen naar het aantal personen; ");
INSERT INTO nld1939_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","dus door het lot moet het erfdeel tussen groot en klein worden verdeeld. ");
INSERT INTO nld1939_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Dit waren de Levieten, die naar hun geslachten werden ingeschreven: het geslacht der Gersjonieten van Gersjon; het geslacht der Kehatieten van Kehat; het geslacht der Merarieten van Merari. ");
INSERT INTO nld1939_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dit waren de geslachten van Levi: het geslacht der Libnieten, het geslacht der Chebronieten, het geslacht der Machlieten, het geslacht der Moesjieten, het geslacht der Korieten. Kehat verwekte Amram. ");
INSERT INTO nld1939_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","De vrouw van Amram heette Jokébed; ze was een dochter van Levi, die hem in Egypte werd geboren. Zij schonk aan Amram Aäron, Moses en hun zuster Mirjam. ");
INSERT INTO nld1939_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aan Aäron werden Nadab en Abihoe, Elazar en Itamar geboren. ");
INSERT INTO nld1939_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab en Abihoe stierven, toen zij onwettig vuur voor Jahweh offerden. ");
INSERT INTO nld1939_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Alle ingeschreven mannelijke personen van één maand af waren drie en twintig duizend. Zij waren niet met de andere Israëlieten gemonsterd, omdat hun geen erfdeel onder de Israëlieten was toebedeeld. ");
INSERT INTO nld1939_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Dit waren degenen, die door Moses en den priester Elazar werden geteld, toen zij de Israëlieten monsterden in de velden van Moab aan de Jordaan bij Jericho. ");
INSERT INTO nld1939_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Onder dezen bevond zich niemand van hen, die door Moses en den priester Aäron waren geteld, toen zij de Israëlieten in de woestijn van de Sinaï hadden gemonsterd. ");
INSERT INTO nld1939_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Want Jahweh had hun gezegd: Ze zullen in de woestijn sterven, en er zal niemand van hen overblijven, behalve Kaleb, de zoon van Jefoenne, en Josuë, de zoon van Noen. ");
INSERT INTO nld1939_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Maar nu traden de dochters van Selofchad, den zoon van Chéfer, den zoon van Gilad, den zoon van Makir, den zoon van Manasse, den zoon van Josef naar voren; de namen van zijn dochters waren: Machla, Noa, Chogla, Milka en Tirsa. ");
INSERT INTO nld1939_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Zij plaatsten zich voor Moses en den priester Elazar, en voor de aanvoerders en heel de gemeenschap bij de ingang van de openbaringstent en zeiden: ");
INSERT INTO nld1939_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Onze vader is in de woestijn gestorven. Maar hij behoorde niet tot de aanhang van Kore, die opstand maakte tegen Jahweh; maar hij is om zijn eigen zonde gestorven, zonder zonen na te laten. ");
INSERT INTO nld1939_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Waarom moet nu de naam van onzen vader uit zijn geslacht verdwijnen, omdat hij geen zoon heeft gehad? Geef ons dus eigendom onder de broeders van onzen vader. ");
INSERT INTO nld1939_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moses bracht haar rechtsvraag voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","En Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","De dochters van Selofchad hebben gelijk. Ge moet haar onder de broeders van haar vader een erfelijk grondbezit geven, en het erfdeel van haar vader op haar doen overgaan. ");
INSERT INTO nld1939_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","En aan de Israëlieten moet ge zeggen: Wanneer iemand sterft, zonder een zoon na te laten, moet ge zijn erfdeel op zijn dochters doen overgaan. ");
INSERT INTO nld1939_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Zo hij ook geen dochters heeft, moet gij zijn erfdeel aan zijn broers geven. ");
INSERT INTO nld1939_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Heeft hij geen broers, dan moet gij het aan de broers van zijn vader geven. ");
INSERT INTO nld1939_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Had ook zijn vader geen broers, dan moet gij zijn erfdeel geven aan die hem in zijn geslacht het naast verwant is; die zal het dan erven. Dit is voor de Israëlieten een wettelijk voorschrift geworden, zoals Jahweh het Moses bevolen heeft. ");
INSERT INTO nld1939_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Jahweh sprak tot Moses: Bestijg dit Abarimgebergte, en werp een blik op het land, dat Ik de Israëlieten zal geven. ");
INSERT INTO nld1939_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Wanneer ge het gezien hebt, zult ook gij bij uw volk worden verzameld, evenals uw broeder Aäron, ");
INSERT INTO nld1939_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","omdat gij u in de woestijn Sin bij de opstand van de gemeenschap tegen mijn bevel hebt verzet, en Mij door het water voor hun ogen niet als heilig hebt behandeld. Dit is het water van Meribat-Kadesj in de woestijn van Sin geweest. ");
INSERT INTO nld1939_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moses zei tot Jahweh: ");
INSERT INTO nld1939_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Jahweh, de God over het leven van alle schepselen, stelle dan iemand over de gemeenschap aan, ");
INSERT INTO nld1939_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","die voor hen uitgaat en ingaat, die hen uitleidt en terugvoert, opdat de gemeenschap van Jahweh niet worde als schapen zonder herder. ");
INSERT INTO nld1939_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Toen sprak Jahweh tot Moses: Neem Josuë, den zoon van Noen, een man, die met mijn geest is vervuld, en leg hem uw hand op; ");
INSERT INTO nld1939_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","plaats hem voor den priester Elazar en voor de hele gemeenschap der Israëlieten, en draag hem in hun tegenwoordigheid de leiding over. ");
INSERT INTO nld1939_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Deel hem iets van uw waardigheid mee, zodat heel de gemeenschap der Israëlieten hem gehoorzaamt; ");
INSERT INTO nld1939_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","maar toch zal hij voor den priester Elazar moeten verschijnen, en deze zal voor hem voor het aanschijn van Jahweh de uitspraak der Oerim moeten vragen. En op diens uitspraak zal hij met al de Israëlieten en heel de gemeenschap moeten uittrekken en terugkeren. ");
INSERT INTO nld1939_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses deed, wat Jahweh hem bevolen had. Hij nam Josuë, plaatste hem voor den priester Elazar en heel de gemeenschap, ");
INSERT INTO nld1939_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","legde hem de handen op, en droeg hem de leiding over; zoals Jahweh het door Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Geef de Israëlieten het volgende bevel: Gij moet er voor zorgen, Mij mijn offergaven, mijn spijs, mijn heerlijk geurende vuuroffers, op de vastgestelde tijden te brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Gij moet hun zeggen: Dit is het vuuroffer, dat gij dagelijks als een regelmatig brandoffer aan Jahweh moet brengen: twee gave lammeren van een jaar oud. ");
INSERT INTO nld1939_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Het ene lam moet gij des morgens offeren, het andere lam tegen de avond. ");
INSERT INTO nld1939_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Verder als spijsoffer een tiende efa meelbloem met een vierde hin gestoten olie gemengd. ");
INSERT INTO nld1939_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Dit is het dagelijkse brandoffer, dat op de berg Sinaï is ingesteld, als een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Verder als plengoffer, dat bij ieder lam hoort, een vierde hin wijn; in het heiligdom moogt gij slechts gegiste drank voor Jahweh plengen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Als ge tegen de avond het tweede lam offert, moet gij het evenals des morgens met een spijsoffer en met het daarbij horend plengoffer als een heerlijk geurend vuuroffer aan Jahweh opdragen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Op de sabbat bovendien nog twee gave lammeren van een jaar oud met twee issaron meelbloem, met olie gemengd, als spijsoffer, en het daarbij horend plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Dit is het brandoffer, dat iedere sabbat, behalve het dagelijkse brand- en plengoffer, moet worden opgedragen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Op de eerste van iedere maand moet gij als brandoffer twee jonge stieren, een ram en zeven gave lammeren van een jaar oud aan Jahweh brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Als spijsoffer bij iederen jongen stier drie issaron meelbloem, met olie gemengd; als spijsoffer bij iederen ram twee issaron meelbloem, met olie gemengd; ");
INSERT INTO nld1939_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","en bij ieder lam telkens een issaron meelbloem, met olie gemengd, als spijsoffer. Dit is een brandoffer, een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Vervolgens de plengoffers, die er bij horen; een halve hin wijn bij den jongen stier, een derde hin bij den ram, en een vierde hin bij ieder lam. Dit is dus het brandoffer bij iedere nieuwe maan van alle maanden van het jaar. ");
INSERT INTO nld1939_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Bovendien moet buiten het dagelijkse brandoffer nog een geitebok als zondeoffer aan Jahweh worden opgedragen met het daarbij horend plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Op de veertiende dag van de eerste maand moet het Pascha van Jahweh worden gehouden, ");
INSERT INTO nld1939_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","en op de vijftiende dag van die maand is het feest; zeven dagen lang moeten ongedesemde broden worden gegeten. ");
INSERT INTO nld1939_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Op de eerste dag moet een godsdienstige bijeenkomst worden gehouden, en mag geen slafelijke arbeid worden verricht. ");
INSERT INTO nld1939_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Dan moet ge als vuuroffer aan Jahweh een brandoffer opdragen, dat uit twee jonge stieren, een ram en zeven eenjarige lammeren moet bestaan; gave dieren moet ge nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Verder moet ge als het daarbij horend spijsoffer bij iederen jongen stier drie issaron meelbloem, met olie gemengd, opdragen, bij den ram twee issaron, ");
INSERT INTO nld1939_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","en bij ieder van de zeven lammeren telkens een issaron. ");
INSERT INTO nld1939_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Bovendien nog een bok als zondeoffer, om verzoening voor u te verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Dit alles moet ge opdragen buiten het dagelijkse brandoffer van iedere morgen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Op elk van de zeven dagen moet ge dus buiten het dagelijkse brandoffer, als spijs een heerlijk geurend vuuroffer aan Jahweh opdragen, met het plengoffer dat er bij hoort. ");
INSERT INTO nld1939_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Op de zevende dag moet ge een godsdienstige bijeenkomst houden en moogt ge geen slafelijke arbeid verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Op de dag der eerstelingen, op uw feest der weken, wanneer ge een nieuw spijsoffer aan Jahweh brengt, moet ge een godsdienstige bijeenkomst houden, en moogt ge geen slafelijke arbeid verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Dan moet ge een heerlijk geurend brandoffer aan Jahweh opdragen van twee jonge stieren, een ram, en zeven eenjarige lammeren; gave dieren moet ge nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Verder als het daarbij horende spijsoffer bij iederen stier drie issaron meelbloem, met olie gemengd, twee issaron bij iederen ram, ");
INSERT INTO nld1939_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","en telkens een issaron bij ieder van de zeven lammeren. ");
INSERT INTO nld1939_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Bovendien nog een geitebok, als zondeoffer om verzoening voor u te verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ge moet dat met de daarbij horende plengoffers opdragen buiten het dagelijkse brand- en spijsoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Op de eerste dag van de zevende maand moet ge een godsdienstige bijeenkomst houden, en moogt ge geen slafelijke arbeid verrichten; het zal de dag van bazuingeschal voor u zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dan moet ge een heerlijk geurend brandoffer aan Jahweh opdragen, van een jongen stier, een ram en zeven eenjarige lammeren, gave dieren. ");
INSERT INTO nld1939_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Verder als het daarbij horende spijsoffer, bij den stier drie issaron meelbloem, met olie gemengd, twee issaron bij den ram, ");
INSERT INTO nld1939_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","en een issaron bij ieder van de zeven lammeren. ");
INSERT INTO nld1939_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Bovendien nog een geitebok als zondeoffer om verzoening voor u te verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Dit alles buiten het maandelijkse brandoffer met het daarbij horende spijsoffer, en buiten het dagelijkse brandoffer en de daarbij voorgeschreven plengoffers, als een heerlijk geurend vuuroffer voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Op de tiende van deze zevende maand moet ge een godsdienstige bijeenkomst houden, vasten en moogt ge generlei arbeid verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dan moet ge een heerlijk geurend brandoffer aan Jahweh opdragen van een jongen stier, een ram, zeven eenjarige lammeren; gave dieren moet ge nemen. ");
INSERT INTO nld1939_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Verder als het daarbij horende spijsoffer, bij den stier drie issaron meelbloem, met olie gemengd, twee issaron bij den ram, ");
INSERT INTO nld1939_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","telkens een issaron bij ieder van de zeven lammeren. ");
INSERT INTO nld1939_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Bovendien nog een geitebok als zondeoffer, buiten het zondeoffer voor de verzoening, en het dagelijkse brandoffer met het daarbij horende spijsoffer en de plengoffers. ");
INSERT INTO nld1939_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Op de vijftiende dag van de zevende maand moet ge een godsdienstige bijeenkomst houden, en moogt ge geen slafelijke arbeid verrichten; zeven dagen lang moet ge feest vieren ter ere van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Dan moet ge als een heerlijk geurend vuuroffer aan Jahweh een brandoffer opdragen van dertien jonge stieren, twee rammen, veertien eenjarige lammeren; gave dieren moeten het zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Verder als het daarbij horende spijsoffer, bij ieder van de dertien stieren drie issaron meelbloem met olie gemengd, twee issaron bij ieder van de twee rammen, ");
INSERT INTO nld1939_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","en telkens een issaron bij ieder van de veertien lammeren. ");
INSERT INTO nld1939_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Bovendien nog een geitebok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Op de tweede dag twaalf jonge stieren, twee rammen, veertien eenjarige lammeren, gave dieren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","bovendien een geitebok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijsoffer en de plengoffers. ");
INSERT INTO nld1939_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Op de derde dag elf stieren, twee rammen, veertien gave, eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","bovendien een bok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Op de vierde dag tien stieren, twee rammen, veertien gave, eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","bovendien een geitebok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Op de vijfde dag negen stieren, twee rammen, veertien gave, eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","bovendien een bok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Op de zesde dag acht stieren, twee rammen, veertien gave, eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","bovendien een bok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Op de zevende dag zeven stieren, twee rammen, veertien gave, eenjarige lammeren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","verder het spijsoffer en de plengoffers, die volgens voorschrift bij ieder van de stieren, rammen en lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","bovendien een bok als zondeoffer, behalve nog het dagelijkse brandoffer met het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Op de achtste dag moet ge een feestvergadering houden, en moogt ge geen slafelijke arbeid verrichten. ");
INSERT INTO nld1939_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Dan moet ge als heerlijk geurend vuuroffer aan Jahweh een brandoffer opdragen van een stier, een ram, en zeven eenjarige lammeren, gave dieren; ");
INSERT INTO nld1939_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","verder het spijsoffer en de plengoffers, die volgens voorschrift bij den stier, den ram en ieder van de lammeren horen; ");
INSERT INTO nld1939_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","bovendien een bok als zondeoffer, behalve nog het dagelijkse brandoffer en het daarbij horende spijs- en plengoffer. ");
INSERT INTO nld1939_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Dit moet ge Jahweh op uw feestdagen offeren, behalve uw brand-, spijs-, pleng- en vredeoffers, die uw gelofteoffers of vrijwillige gaven vormen. ");
INSERT INTO nld1939_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","En Moses bracht de Israëlieten alles nauwkeurig over, wat Jahweh hem bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses sprak tot de stamhoofden der Israëlieten: Jahweh heeft het volgende bevolen: ");
INSERT INTO nld1939_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Wanneer men een gelofte aan Jahweh doet, of zich onder ede verplicht, zich van iets te onthouden, dan mag men zijn woord niet breken, maar moet alles volbrengen wat men beloofd heeft. ");
INSERT INTO nld1939_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Wanneer een vrouw die als jong meisje nog in het huis van haar vader woont, een gelofte aan Jahweh doet, of een verplichting op zich neemt, zich van iets te onthouden, ");
INSERT INTO nld1939_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","en haar vader hoort haar gelofte of dergelijke verplichting, die zij op zich neemt, en hij doet er het zwijgen toe, dan zijn al haar geloften en al zulke verplichtingen, die zij op zich heeft genomen, van kracht. ");
INSERT INTO nld1939_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Maar wanneer haar vader, als hij het hoort, er zich tegen verzet, dan is geen van haar geloften en geen van zulke verplichtingen, die zij op zich heeft genomen, van kracht, en Jahweh scheldt ze haar kwijt, omdat haar vader er zich tegen verzet heeft. ");
INSERT INTO nld1939_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Wanneer zij trouwt, terwijl zij door haar gelofte is gebonden, of door een ondoordacht woord een verplichting op zich heeft genomen, om zich van iets te onthouden, ");
INSERT INTO nld1939_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","en haar man hoort het, maar doet er het zwijgen toe, als hij het hoort, dan blijven haar geloften en dergelijke verplichtingen, die zij op zich genomen heeft, van kracht. ");
INSERT INTO nld1939_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Maar wanneer haar man, als hij het hoort, er zich tegen verzet, dan maakt hij haar gelofte, die op haar rust, en die onbezonnen verplichting, die ze heeft aangegaan, ongeldig, en Jahweh scheldt ze haar kwijt. ");
INSERT INTO nld1939_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","De gelofte van een weduwe of van een verstoten vrouw, en iedere verplichting, die zij op zich nemen, om zich van iets te onthouden, blijven voor haar van kracht. ");
INSERT INTO nld1939_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Wanneer zij in het huis van haar man een gelofte doet of onder ede een verplichting op zich heeft genomen om zich van iets te onthouden, ");
INSERT INTO nld1939_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","en haar man hoort het, maar doet er het zwijgen toe en verzet er zich niet tegen, dan zijn al haar geloften en al zulke verplichtingen, die zij op zich heeft genomen, van kracht. ");
INSERT INTO nld1939_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Maar verklaart haar man, als hij het hoort, ze voor ongeldig, dan is niets, wat zij als gelofte of als dergelijke verplichting heeft aangegaan, van kracht; haar man heeft ze ongeldig gemaakt, en ook Jahweh scheldt ze haar kwijt. ");
INSERT INTO nld1939_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Elke gelofte dus en elke eed, waardoor ze zich verplicht, zich van iets te onthouden, kan haar man geldig of ongeldig maken. ");
INSERT INTO nld1939_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Zo haar man tegenover haar van de ene dag tot de andere blijft zwijgen, dan erkent hij al haar geloften en al dergelijke verplichtingen, die zij op zich heeft genomen, als geldig; hij heeft ze bekrachtigd, door te blijven zwijgen, toen hij ze vernam. ");
INSERT INTO nld1939_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Verklaart hij ze echter eerst ongeldig, lang nadat hij er van heeft gehoord, dan maakt hij zich aan zonde schuldig. ");
INSERT INTO nld1939_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Dit zijn de voorschriften, die Jahweh Moses gegeven heeft over de verhouding van den man tot zijn vrouw, en van den vader tot zijn dochter, die als jong meisje nog in het huis van haar vader woont. ");
INSERT INTO nld1939_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Jahweh sprak tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Nog moet ge voor de kinderen Israëls wraak nemen op de Midjanieten; daarna zult ge bij uw volk worden verzameld. ");
INSERT INTO nld1939_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moses zei dus tot het volk: Laat een deel van uw mannen zich wapenen, om tegen Midjan op te rukken, en de wraak van Jahweh aan Midjan te voltrekken. ");
INSERT INTO nld1939_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Van iedere stam van Israël, moet ge duizend man in het veld brengen. ");
INSERT INTO nld1939_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Zo werden uit iedere stam van Israël duizend krijgers aangemonsterd, dus twaalf duizend in het geheel. ");
INSERT INTO nld1939_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","En Moses zond die duizend uit iedere stam ten strijde met Pinechas, den zoon van den priester Elazar, wien hij de heilige vaten en de krijgstrompetten meegaf. ");
INSERT INTO nld1939_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Zij bonden dus de strijd aan tegen de Midjanieten, zoals Jahweh het Moses bevolen had, en doodden alle mannen. ");
INSERT INTO nld1939_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Behalve de anderen, die zij neersabelden, doodden zij ook de koningen van Midjan, Ewi, Rékem, Soer, Choer en Réba, vijf midjanietische koningen; ook Balaäm, den zoon van Beor, doodden zij met het zwaard. ");
INSERT INTO nld1939_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","De Israëlieten maakten de vrouwen en kinderen der Midjanieten krijgsgevangen; al hun vee met al hun have en goed maakten zij buit; ");
INSERT INTO nld1939_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","al de steden, die zij bewoonden, met al hun kampementen staken ze in brand. ");
INSERT INTO nld1939_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Al die roof en buit aan mensen en vee namen zij mee, ");
INSERT INTO nld1939_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","en brachten de gevangenen met roof en buit naar Moses, en den priester Elazar, en naar de gemeenschap der Israëlieten in de legerplaats in de velden van Moab aan de Jordaan bij Jericho. ");
INSERT INTO nld1939_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, de priester Elazar en al de leiders van de gemeenschap trokken hen buiten de legerplaats tegemoet. ");
INSERT INTO nld1939_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Maar Moses werd vertoornd op de aanvoerders van het leger, de hoofdmannen over duizend en honderd, die van de strijd terugkeerden, ");
INSERT INTO nld1939_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","en zei tot hen: Hoe hebt ge al die vrouwen in leven kunnen laten? ");
INSERT INTO nld1939_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Zij zijn toch juist op raad van Balaäm de oorzaak geweest, dat Israël om Peor van Jahweh afviel, zodat er onder de gemeenschap van Jahweh een ramp ontstond. ");
INSERT INTO nld1939_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ge moet dus alle jongens doden, en alle vrouwen, die gemeenschap met een man hebben gehad. ");
INSERT INTO nld1939_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Maar alle meisjes, die nog geen gemeenschap met een man hebben gehad, moogt ge in leven laten en voor u behouden. ");
INSERT INTO nld1939_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Bovendien moet ge zeven dagen lang buiten de legerplaats blijven, en iedereen die een ander heeft gedood of een gesneuvelde heeft aangeraakt, moet zich op de derde en zevende dag reinigen, gij zowel als uw krijgsgevangenen. ");
INSERT INTO nld1939_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ook alle kleren, alle leren voorwerpen, al wat uit geitenhaar is vervaardigd, en al wat van hout is, moet gij reinigen. ");
INSERT INTO nld1939_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","En de priester Elazar zeide tot de krijgslieden, die ten strijde waren getrokken: Dit is het voorschrift van de wet, die Jahweh Moses heeft gegeven! ");
INSERT INTO nld1939_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Goud, zilver, brons, ijzer, tin en lood, ");
INSERT INTO nld1939_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","al wat tegen vuur bestand is, moet ge door het vuur halen; dan zal het rein zijn, en behoeft alleen nog met reinigingswater te worden ontsmet. Maar al wat niet tegen vuur is bestand, moet ge door het water halen. ");
INSERT INTO nld1939_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Op de zevende dag moet gij uw kleren wassen; dan zijt gij weer rein, en kunt in de legerplaats terugkeren. ");
INSERT INTO nld1939_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Daarna sprak Jahweh tot Moses: ");
INSERT INTO nld1939_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Tel met den priester Elazar en de familiehoofden van de gemeenschap mensen en dieren, die aan buit zijn meegebracht, ");
INSERT INTO nld1939_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","en verdeel de buit tussen de krijgers, die ten strijde zijn getrokken, en heel de gemeenschap. ");
INSERT INTO nld1939_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Van de krijgers, die ten strijde zijn getrokken, moet ge als gave voor Jahweh één op de vijfhonderd heffen van mensen, runderen, ezels en kleinvee; ");
INSERT INTO nld1939_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ge moet het van hun helft nemen en het den priester Elazar geven als een cijns voor Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Maar van de helft voor de Israëlieten bestemd moet ge één op de vijftig nemen, van wat voor de hand komt, van mensen, runderen, ezels en kleinvee, en alle andere beesten, en het aan de levieten geven, die dienst doen bij de tabernakel van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moses en de priester Elazar deden, wat Jahweh Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Het overschot van de buit, die het krijgsvolk gemaakt en meegebracht had, bedroeg zes honderd vijf en zeventig duizend schapen, ");
INSERT INTO nld1939_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","twee en zeventig duizend runderen, ");
INSERT INTO nld1939_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","een en zestig duizend ezels, ");
INSERT INTO nld1939_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","en aan mensen, twee en dertig duizend vrouwen, die geen gemeenschap met een man hadden gehad. ");
INSERT INTO nld1939_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","De helft, die toekwam aan hen, die ten strijde waren getrokken, bedroeg: aan schapen drie honderd zeven en dertig duizend vijfhonderd, ");
INSERT INTO nld1939_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","en de gave voor Jahweh daarvan zeshonderd vijf en zeventig; ");
INSERT INTO nld1939_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","aan runderen, zes en dertig duizend, en de gave voor Jahweh daarvan twee en zeventig; ");
INSERT INTO nld1939_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","aan ezels, dertig duizend vijfhonderd, en de gave voor Jahweh daarvan een en zestig; ");
INSERT INTO nld1939_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","aan mensen zestien duizend, en de gave voor Jahweh twee en dertig. ");
INSERT INTO nld1939_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses stelde die gave als cijns voor Jahweh, aan den priester Elazar ter hand, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","De helft, die voor de Israëlieten was bestemd, en die Moses van het krijgsvolk, dat was uitgetrokken, had geheven, ");
INSERT INTO nld1939_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","deze helft voor de gemeenschap bedroeg: aan schapen, drie honderd zeven en dertig duizend vijfhonderd, ");
INSERT INTO nld1939_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","aan runderen, zes en dertig duizend; ");
INSERT INTO nld1939_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","aan ezels dertig duizend vijfhonderd; ");
INSERT INTO nld1939_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","en aan mensen, zestien duizend. ");
INSERT INTO nld1939_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Van deze helft, voor de Israëlieten bestemd, nam Moses één op de vijftig van mensen en vee, zoals het voor de hand kwam, en gaf het aan de levieten, die dienst deden bij de tabernakel, zoals Jahweh het Moses bevolen had. ");
INSERT INTO nld1939_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Toen traden de aanvoerders van de troepen, de hoofdmannen over duizend en honderd, op Moses toe, ");
INSERT INTO nld1939_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","en zeiden tot hem: Uw dienaren hebben de strijders, die onder ons stonden, geteld en er ontbreekt er niet één. ");
INSERT INTO nld1939_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Daarom brengt ieder van ons de gouden sieraden, die hij heeft buitgemaakt, gespen, armbanden, zegelringen, oorringen en kralen, als gave aan Jahweh, om voor ons verzoening te verkrijgen voor het aanschijn van Jahweh. ");
INSERT INTO nld1939_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses en de priester Elazar namen al die gouden sieraden van hen aan. ");
INSERT INTO nld1939_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Al het goud, dat zij als cijns aan Jahweh brachten, bedroeg zestien duizend zeven honderd vijftig sikkels. Dit was van de hoofdmannen over duizend en honderd; ");
INSERT INTO nld1939_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ook de krijgslieden hadden ieder voor zich nog buit behaald. ");
INSERT INTO nld1939_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses en de priester Elazar namen het goud van de hoofdmannen over duizend en honderd in ontvangst en brachten het naar de openbaringstent, om de Israëlieten bij Jahweh in gedachtenis te houden. ");
INSERT INTO nld1939_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","De zonen van Ruben en Gad bezaten zeer talrijke kudden. En daar de Rubenieten en Gadieten zagen, dat het land Jazer en het land Gilad een zeer geschikte streek voor vee was, ");
INSERT INTO nld1939_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","gingen ze naar Moses, den priester Elazar en de aanvoerders van de gemeenschap en zeiden: ");
INSERT INTO nld1939_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot, Dibon, Jazer, Nimra, Chesjbon, Elale, Sibma, Nebo en Báal-Meon, ");
INSERT INTO nld1939_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","het land, dat Jahweh aan de gemeenschap van Israël heeft onderworpen, is een land van veeteelt, en uw dienaren oefenen veeteelt uit. ");
INSERT INTO nld1939_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","En zij vervolgden: Zo wij genade hebben gevonden in uw ogen, laat dan dit land aan uw dienaren als bezitting worden gegeven, en voer ons niet over de Jordaan. ");
INSERT INTO nld1939_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Maar Moses gaf de zonen van Gad en Ruben ten antwoord: Wilt gij dan hier blijven wonen, terwijl uw broeders ten strijde trekken? ");
INSERT INTO nld1939_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Waarom wilt ge de Israëlieten de moed benemen, om naar de overkant te trekken, naar het land, dat Jahweh hun heeft gegeven? ");
INSERT INTO nld1939_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Zo hebben uw vaders gedaan, toen ik hen uitzond van Kadesj-Barnéa, om het land te verkennen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Zij trokken op tot de Esjkol-vallei, en zij verkenden het land; maar toen ontnamen zij de kinderen Israëls de moed, om het land binnen te trekken, dat Jahweh hun had gegeven. ");
INSERT INTO nld1939_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Maar toen ook ontbrandde de gramschap van Jahweh, en zwoer Hij: ");
INSERT INTO nld1939_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","De mannen van twintig jaar oud en daarboven, die uit Egypte zijn opgetrokken, zullen het land niet aanschouwen, dat Ik aan Abraham, Isaäk en Jakob onder ede beloofd heb, omdat zij Mij niet trouw zijn gebleven! ");
INSERT INTO nld1939_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Uitgezonderd werden Kaleb, de Kenizziet, de zoon van Jefoenne, en Josuë, de zoon van Noen; want zij bleven Jahweh getrouw. ");
INSERT INTO nld1939_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Zo ontstak de toorn van Jahweh tegen Israël en liet Hij ze veertig jaar lang in de woestijn zwerven, tot heel het geslacht, dat kwaad had gedaan in de ogen van Jahweh, was gestorven. ");
INSERT INTO nld1939_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","En nu neemt gij de plaats van uw vaderen in, zondig gebroed, en roept gij de grimmige toorn van Jahweh over Israël weer af. ");
INSERT INTO nld1939_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Zo ge u van Hem afwendt, zal Hij het nog langer in de woestijn laten zwerven, en stort gij heel dit volk in het verderf. ");
INSERT INTO nld1939_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Maar zij traden op hem toe, en zeiden: Wij willen hier enkel schaapskooien bouwen voor onze kudden en steden voor onze kinderen; ");
INSERT INTO nld1939_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","maar wij zelf zullen strijdvaardig aan de spits van de Israëlieten optrekken, totdat wij ze naar hun bestemming hebben gebracht; intussen zullen onze kinderen dan in versterkte steden kunnen blijven, om tegen de bewoners van het land beveiligd te zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Wij keren niet naar huis terug, eer ieder van Israëls kinderen zijn aandeel heeft bekomen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ook zullen we geen erfbezit bij hen krijgen aan de overkant van de Jordaan, zo wij ons erfdeel hebben gekregen aan deze zijde, ten oosten van de Jordaan. ");
INSERT INTO nld1939_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Toen sprak Moses tot hen: Wanneer gij dit woord gestand doet, en u voor Jahweh ten strijde gordt, ");
INSERT INTO nld1939_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","en gij allen welbewapend de Jordaan overtrekt voor het aanschijn van Jahweh, totdat Hij zijn vijanden voor Zich heeft uitgedreven, ");
INSERT INTO nld1939_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","en eerst terugkeert als het land aan Jahweh is onderworpen, dan gaat ge vrij uit voor Jahweh en Israël, en zal dit land voor het aanschijn van Jahweh uw eigendom zijn. ");
INSERT INTO nld1939_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Maar doet ge het niet, dan zondigt ge tegen Jahweh, en zult ge de gevolgen van uw zonde ondervinden. ");
INSERT INTO nld1939_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bouwt dus steden voor uw kinderen en kooien voor uw schapen, maar doet, wat ge beloofd hebt. ");
INSERT INTO nld1939_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Toen zeiden de zonen van Gad en Ruben tot Moses: Uw dienaren zullen doen, zoals mijn heer heeft bevolen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Onze kinderen en vrouwen, ons vee, en al onze runderen zullen in de steden van Gilad blijven, ");
INSERT INTO nld1939_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","maar uw dienaren zullen allen, welbewapend, naar de overkant trekken, om voor Jahweh te strijden, zoals mijn heer heeft gezegd. ");
INSERT INTO nld1939_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Nu gaf Moses den priester Elazar en Josuë, den zoon van Noen, met de familiehoofden van Israëls stammen zijn bevelen betreffende hen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses zeide: Wanneer de zonen van Gad en van Ruben, allen welbewapend, met u de Jordaan overtrekken, om voor Jahweh te strijden, en het land aan u onderworpen is, dan moet ge hun het land Gilad in eigendom geven; ");
INSERT INTO nld1939_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","maar zo ze niet welbewapend met u naar de overkant trekken, dan moeten zij worden gedwongen zich onder u in het land Kanaän te vestigen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","De zonen van Gad en Ruben verzekerden: Wat Jahweh uw dienaars bevolen heeft, zullen ze doen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Voor Jahweh’s aanschijn zullen wij welbewapend naar het land Kanaän trekken, en eerst dan zullen we aan deze zijde van de Jordaan vaste bezittingen verkrijgen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Zo gaf Moses aan de zonen van Gad en Ruben en aan de helft van de stam van Manasse, den zoon van Josef, het rijk van Sichon, den koning der Amorieten, en het rijk van Og, den koning van Basjan, zowel de steden van het land als het grondgebied rondom de steden. ");
INSERT INTO nld1939_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","De zonen van Gad herbouwden de vestingsteden Dibon, Atarot en Aroër, ");
INSERT INTO nld1939_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Sjofan, Jazer en Jogbeha, ");
INSERT INTO nld1939_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra, Bet-Haran met haar schaapskooien. ");
INSERT INTO nld1939_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","De zonen van Ruben herbouwden Chesjbon, Elale en Kirjatáim, ");
INSERT INTO nld1939_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Báal-Meon (onder een andere naam) en Sibma, en gaven aan de steden, die ze bouwden, andere namen. ");
INSERT INTO nld1939_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","De zonen van Makir, den zoon van Manasse, trokken naar Gilad, veroverden het en verdreven de Amorieten, die daar woonden. ");
INSERT INTO nld1939_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moses gaf Gilad aan Makir, den zoon van Manasse, die zich daar vestigde. ");
INSERT INTO nld1939_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Ook Jaïr, de zoon van Manasse, trok op, veroverde hun kampementen en noemde ze kampementen van Jaïr. ");
INSERT INTO nld1939_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ook Nóbach trok op, veroverde Kenat met zijn onderhorige plaatsen, en noemde het Nóbach naar zijn eigen naam. ");
INSERT INTO nld1939_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Dit zijn de halten van de Israëlieten, nadat zij onder leiding van Moses en Aäron met hun legerscharen uit Egypte waren opgetrokken. ");
INSERT INTO nld1939_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Op bevel van Jahweh schreef Moses hun zwerftochten op volgens de halten, die zij hadden gemaakt. En dit waren hun verschillende halten, die zij op hun zwerftochten hadden gemaakt. ");
INSERT INTO nld1939_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Op de vijftiende dag van de eerste maand, braken zij op van Raämses, daags na Pasen trokken de Israëlieten onder machtige schutse ten aanschouwen van heel Egypte weg, ");
INSERT INTO nld1939_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","terwijl de Egyptenaren al de eerstgeborenen begroeven, die Jahweh onder hen had getroffen, en Jahweh aan hun goden de strafgerichten voltrok. ");
INSERT INTO nld1939_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Nadat de Israëlieten van Raämses waren opgetrokken, legerden zij zich te Soekkot. ");
INSERT INTO nld1939_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Van Soekkot trokken zij verder en legerden zich te Etam, dat op de grens van de woestijn ligt. ");
INSERT INTO nld1939_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Van Etam trokken zij verder, maar sloegen de richting in naar Pi-Hachirot, dat ten oosten van Báal-Sefon ligt, en legerden zich voor Migdol. ");
INSERT INTO nld1939_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Van Pi-Hachirot trokken zij verder, gingen midden door de zee naar de woestijn, trokken drie dagreizen ver de woestijn Etam in, en legerden zich te Mara. ");
INSERT INTO nld1939_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Van Mara trokken zij verder, en kwamen te Elim; te Elim waren twaalf waterbronnen en zeventig palmbomen, en zij legerden zich daar. ");
INSERT INTO nld1939_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Van Elim trokken zij verder, en legerden zich aan de Rode Zee. ");
INSERT INTO nld1939_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Van de Rode Zee trokken zij verder, en legerden zich in de woestijn Sin. ");
INSERT INTO nld1939_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Van de woestijn Sin trokken zij verder, en legerden zich te Dofka. ");
INSERT INTO nld1939_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Van Dofka trokken zij verder, en legerden zich te Aloesj. ");
INSERT INTO nld1939_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Van Aloesj trokken zij verder, en legerden zich te Refidim; daar was geen water voor het volk, om te drinken. ");
INSERT INTO nld1939_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Van Refidim trokken zij verder, en legerden zich in de woestijn van de Sinaï. ");
INSERT INTO nld1939_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Van de woestijn Sinaï trokken zij verder, en legerden zich te Kibrot-Hattaäwa. ");
INSERT INTO nld1939_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Van Kibrot-Hattaäwa trokken zij verder, en legerden zich te Chaserot. ");
INSERT INTO nld1939_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Van Chaserot trokken zij verder, en legerden zich te Ritma. ");
INSERT INTO nld1939_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Van Ritma trokken zij verder, en legerden zich te Rimmon-Péres. ");
INSERT INTO nld1939_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Van Rimmon-Péres trokken zij verder, en legerden zich te Libna. ");
INSERT INTO nld1939_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Van Libna trokken zij verder, en legerden zich te Rissa. ");
INSERT INTO nld1939_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Van Rissa trokken zij verder, en legerden zich te Keheláta. ");
INSERT INTO nld1939_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Van Keheláta trokken zij verder, en legerden zich bij de berg Sjéfer. ");
INSERT INTO nld1939_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Van de berg Sjéfer trokken zij verder, en legerden zich te Charada. ");
INSERT INTO nld1939_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Van Charada trokken zij verder, en legerden zich te Makhelot. ");
INSERT INTO nld1939_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Van Makhelot trokken zij verder, en legerden zich te Táchat. ");
INSERT INTO nld1939_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Van Táchat trokken zij verder, en legerden zich te Térach. ");
INSERT INTO nld1939_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Van Térach trokken zij verder, en legerden zich te Mitka. ");
INSERT INTO nld1939_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Van Mitka trokken zij verder, en legerden zich te Chasjmona. ");
INSERT INTO nld1939_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Van Chasjmona trokken zij verder, en legerden zich te Moserot. ");
INSERT INTO nld1939_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Van Moserot trokken zij verder, en legerden zich te Bene-Jaäkan. ");
INSERT INTO nld1939_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Van Bene-Jaäkan trokken zij verder, en legerden zich te Chor-Haggidgad. ");
INSERT INTO nld1939_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Van Chor-Haggidgad trokken zij verder, en legerden zich te Jotbáta. ");
INSERT INTO nld1939_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Van Jotbáta trokken zij verder, en legerden zich te Abrona. ");
INSERT INTO nld1939_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Van Abrona trokken zij verder, en legerden zich te Es-jon-Géber. ");
INSERT INTO nld1939_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Van Es-jon-Géber trokken zij verder, en legerden zich in de woestijn Sin, dat is Kadesj. ");
INSERT INTO nld1939_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Van Kadesj trokken zij verder, en legerden zich bij de berg Hor aan de grens van het land Edom. ");
INSERT INTO nld1939_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","De priester Aäron besteeg op bevel van Jahweh de berg Hor, en stierf daar in het veertigste jaar na de uittocht van de Israëlieten uit Egypte, op de eerste van de vijfde maand. ");
INSERT INTO nld1939_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aäron was honderd drie en twintig jaar oud, toen hij op de berg Hor stierf. ");
INSERT INTO nld1939_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Daar de kanaänietische koning van Arad, die in de Négeb van het land Kanaän woonde, vernomen had, dat de Israëlieten in aantocht waren, ");
INSERT INTO nld1939_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","trokken zij van de berg Hor verder, en legerden zich te Salmona. ");
INSERT INTO nld1939_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Van Salmona trokken zij