﻿USE sofia;
DROP TABLE IF EXISTS sofia.nkr_vpl;
CREATE TABLE nkr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nkr_vpl WRITE;
INSERT INTO nkr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Taamada de hai a de Maadua de langi ma henua i lalo, ");
INSERT INTO nkr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","gai henua i lalo e vinigoso, gai se ngadi mommee, de gohu e haoli honga de moana gelo, gai de Hagasaalunga o de Maadua e aheahe saele i honga vai laa. ");
INSERT INTO nkr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Gai de Maadua ga hagadaba, “Gi dahi maalama,” gai gu dahi maalama. ");
INSERT INTO nkr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gai de Maadua gu gidee bolo de maalama gu danuaa; gai ia ga vvae de maalama ma de gohu. ");
INSERT INTO nkr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gai de Maadua ga hagaingoo ange de maalama go de laangi, gai de gohu go de boo. Deenei de ahiahi ma taiao o de hagadahi laangi. ");
INSERT INTO nkr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Gai de Maadua ga hagadaba, “Gi dahi moana i lo te langi gi vaaea ai denga vai i baasi i lunga ma baasi i lalo.”  ");
INSERT INTO nkr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gai de Maadua ne hai lo te moana i lunga ga vvae ai denga vai i baasi i lunga ma vai i baasi i lalo o de moana laa. Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gai de Maadua ga hagaingoo ange lo te moana i lunga go de langi. Deenei de ahiahi ma taiao o de hagalua laangi. ");
INSERT INTO nkr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Gai de Maadua ga hagadaba, “Denga vai alodahi i lalo de langi gi hulo gi dahi mommee daudahi, gai gi sula age de gelegele mmasa.” Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gai de Maadua ga hagaingoo ange de gelegele mmasa go de henua, gai denga lausedi go tai. Gai de Maadua gu gidee bolo gu danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Gai de Maadua ga hagadaba, “Gi ssomo age i honga de henua denga hagadaagangaa manu ssomo alodahi: manu iai golee ma manu ssomo e hhaa mai ai hua gai, dahi manu ma ono hua aama ono golee.” Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Gai gu ssomo age denga hagadaagangaa manu ssomo alodahi i honga de gelegele: manu iai golee, dahi manu ma ono golee, ma manu ssomo e hhaa mai ai hua gai, dahi manu ma ono hua. Gai de Maadua gu gidee bolo gu danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Deenei de ahiahi ma taiao o de hagadolu laangi. ");
INSERT INTO nkr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Gai de Maadua ga hagadaba, “Gi hanu mee hagamaalama i lo te langi i lunga, e vvae ai de laangi ma de boo, gai mee nei ga hagailonga ai denga masavaa, ma laangi aama ngadau. ");
INSERT INTO nkr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Gai gilaadeu ga hagamaalama ai lo te langi i lunga aama honga henua i lalo.” Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gai de Maadua ga hai e lua mee hagamaalama nnui: de mee hagamaalama laumalie e hagamaalama ai de laangi, gai de mee hagamaalama damaa mee e hagamaalama ai de boo. Ia ne hai hogi denga heduu. ");
INSERT INTO nkr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Gai de Maadua ne dugu mee nei i lo te langi i lunga gi hagamaalama ina ai honga henua i lalo, ");
INSERT INTO nkr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma de hagamaalama ai de laangi ma de boo, ma de vvae ai de maalama ma de gohu. Gai de Maadua gu gidee bolo gu danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Deenei de ahiahi ma taiao o de hagahaa laangi. ");
INSERT INTO nkr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Gai de Maadua ga hagadaba, “Lo te lausedi gi honu i denga hagadaagangaa mamu ma mee alodahi e mouli i kilaa, gai denga manu llele gi llele saele i lo te moana i lunga.” ");
INSERT INTO nkr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gai de Maadua ga hai denga hagadaagangaa mamu nnui i lo te dai ma mee alodahi e mouli ma e ngalungaalue saele ma de nnoho i lausedi, dahi manu ma dahi manu ma ono dagodo. Ia ne hai hogi denga hagadaagangaa manu llele alodahi, dahi manu lele ma ono dagodo. Gai de Maadua gu gidee bolo gu danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Gai de Maadua ga hagamanuuia mee nei ga hagadaba, “Goodou hagadili mage haoa ai lo te dai, gai denga manu llele gi hagadili gi haoa ai honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Deenei de ahiahi ma taiao o de hagalima laangi. ");
INSERT INTO nkr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Gai de Maadua ga hagadaba, “Denga hagadaagangaa manu alodahi gi hagadili gi haoa ai honga de henua; go manu haangai, ma manu vaaligiligi e nnoho ma de tolo saele i honga de gelegele, ma manu lodo henua, dahi manu ma ono dagodo.” Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gai de Maadua ga hai denga manu lodo henua, ma manu haangai, ma manu vaaligiligi e nnoho ma de tolo saele i honga de gelegele, dahi manu ma ono dagodo. Gai de Maadua ne gidee bolo gu danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Gai de Maadua ga hagadaba, “Gidaadeu ga hai tangada gi bei odaadeu hagadulagi ma odaadeu dagodo donu; gai gilaadeu ga dagi ai denga mamu i lausedi, ma manu llele i lo te moana i lunga, ma manu haangai, ma manu lodo henua alodahi, ma manu vaaligiligi e nnoho ma de tolo saele i honga de gelegele.”  ");
INSERT INTO nkr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Gai de Maadua ne hai tangada ga hagadulagi ange gi ono dagodo donu, ia ne hai tangada gi bei hagadulagi o de Maadua; ia ne hai taane ma de hine.  ");
INSERT INTO nkr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Gai de Maadua ne hagamanuuia gilaau, ga hai ange, “Gooluu hagadili gi soa, haoa ai henua i lalo ga huahua ai. Gai gooluu ga dagi ai denga mamu i lausedi, ma manu llele i lo te moana i lunga, aama manu dolodolo alodahi i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Gai de Maadua ne hai ange, “Tilo, au gu gaavadu gi gooluu denga manu ssomo vaaligiligi iai hua ma golee i honga de gelegele alodahi, ma manu ssomo nnui iai hua ma golee e gaimee ai gooluu. ");
INSERT INTO nkr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Gai au ne gaavange denga manu ssomo gi denga manu dolodolo alodahi, ma manu llele alodahi i lo te moana i lunga, ma manu alodahi e nnoho ma de tolo saele i honga de gelegele, aama mee alodahi e mouli e gaimee ai gilaadeu.” Gai gu bei donu ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gai de Maadua ga tilo huu mee alodahi aana gu hai, gai ia gu gidee bolo gu danuaa mmao. Deenei de ahiahi ma taiao o de hagaono laangi. ");
INSERT INTO nkr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gai de langi ma henua i lalo ma mee alodahi iai gu lava i de hai. ");
INSERT INTO nkr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Gai de hagahidu laangi huu, gai de Maadua ga hagalava ana hegau alodahi ne hai; gai ia ga hagamabu mai i hegau alodahi aana gu hai. ");
INSERT INTO nkr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gai de Maadua ga hagamanuuia de hidu laangi ga hai gi dabu, go hiidinga deenei de laangi oona ne hagamabu mai ai i mee alodahi aana ne hai. ");
INSERT INTO nkr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Gai deenei taalanga o de langi ma henua i lalo i de masavaa ne hai ai. De masavaa a Tagi Maolunga go de Maadua ne hai ai henua i lalo ma de langi, ");
INSERT INTO nkr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","gai tigi ai donu manu nnui ne ssomo age i lo te duu malaelae be ni manu vaaligiligi ne ssomo, go hiidinga Tagi Maolunga go de Maadua tigi hai gi pala iho de langi gi henua i lalo. Gai tigi ai hogi dangada ne hagabalabala ina de gelegele e doo, ");
INSERT INTO nkr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","gai de mama o denga vai lo te gelegele e hanage ma e hagamaluulu honga de gelegele alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Gai Tagi Maolunga go de Maadua ga hagaholi tangada mai i bela o de gelegele, gai ia ga busi ange de madangi o de mouli gi lodo luoono bongaa usu, gai taane laa gu se dangada e mouli. ");
INSERT INTO nkr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Gai Tagi Maolunga go de Maadua ga doo dahi veelenga i Eden, i de baasi i dua, gai ia ga kave taane aana ne hagaholi laa gi noho ai. ");
INSERT INTO nkr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gai Tagi Maolunga go de Maadua ne hai gi ssomo age, i honga de gelegele denga hagadaagangaa manu ssomo alodahi e danuaa laa i de tilo ma de gai. Gai de manu somo o de mouli, ma de manu somo e maua ai laa gi iloo tanuaa ma de baubau, e ssomo i lo te ungaalodo o de veelenga laa. ");
INSERT INTO nkr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gai dahi saalingaa vai e humai i Eden ma e hagamaluulu de veelenga laa, gai de vai laa e haa ono manga. ");
INSERT INTO nkr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","De ingoo o tahi saalingaa vai go Pishon, gai e sali ma e hano laa luu baasi alodahi o de henua go Havilah, go de mommee iai denga goolo. ");
INSERT INTO nkr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gai goolo o de henua laa ni goolo danuaa, gai luu hadu hagamogomogo go de bdellium, aama de onyx i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","De ingoo o de lua saalingaa vai go Gihon, gai e sali ma e hano laa luu baasi alodahi o de henua go Ethiopia. ");
INSERT INTO nkr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Gai de ingoo o tolu saalingaa vai go Tigris, gai e sali ma e hano gi baasi i dua o Assyria. Gai de haa saalingaa vai go Euphrates. ");
INSERT INTO nkr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Gai Tagi Maolunga de Maadua ga kave taane laa gi noho i lo te veelenga go Eden, gai ia ga hagabalabala ai ga doo aama de tilo ange de veelenga laa. ");
INSERT INTO nkr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Gai Tagi Maolunga go de Maadua ga hai ange gi taane laa, “Koe e maua i de gaimee i hua o denga manu alodahi i lo te veelenga, ");
INSERT INTO nkr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aagai koe e dee maua i de gai hua o de manu somo e maua ai gi iloo tanuaa ma de baubau, go hiidinga de laangi naa huu aau e gai ai ono hua, gai koe e magau donu.” ");
INSERT INTO nkr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Gai Tagi Maolunga go de Maadua ga hagadaba, “E dee danuaa de noho sogosogo o taane, au e gaavange naa gi de ia dahi dangada bale e heohi ange gi de ia.” ");
INSERT INTO nkr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Gai Tagi Maolunga go de Maadua ne hai denga manu lodo henua alodahi, ma manu llele alodahi o lo te moana i lunga i bela o de gelegele. Gai ia ga gaamai gilaadeu gi daho taane laa, gai ia ga gaavange olaadeu ingoo. Gai de ingoo naa huu a taane laa ne gaavange gi dahi manu, gai gu deelaa ai loo dono ingoo. ");
INSERT INTO nkr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gai taane laa e gaavange ingoo o denga manu haangai alodahi, ma manu llele o lo te moana i lunga, ma manu lodo henua alodahi. Aagai teai se ia bale ne gidee moo taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gai Tagi Maolunga go de Maadua ga hai taane laa gi seni tao, gai ia ga aau dahi ono ivi gaogao, gai ga hagaahe ange ga pono ange tuulanga laa. ");
INSERT INTO nkr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gai Tagi Maolunga go de Maadua ga hai de ivi aana ne aau mai laa i de gaogao o taane laa ga hai ai de hine, gai ia ga gaamai de hine laa ga gaavange gi taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Gai Adam ga hagadaba, “Go ogu ivi donu aanei, gai go ogu kano donu aanei; ia e hagaingoo ange naa go de hine, i hiidinga ia ne aau mai i de angaanga o taane.”  ");
INSERT INTO nkr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Deenei de hiidinga o taane e dugu ai laa dono damana ma dono dinana, gai ia ga hagapigi ange gi dono bodu, gai gilaau gu hai ga se angaanga e dahi. ");
INSERT INTO nkr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Gai taane nei ma dono bodu e deai donu olaau malo, gai gilaau e dee dookaa donu. ");
INSERT INTO nkr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Gai de labodo se manu e heiangi ange i denga manu lodo henua alodahi a Tagi Maolunga de Maadua ne hai, gai ia ga hai ange gi de hine, “Ni muna abodonu de Maadua ne hai adu gooluu gi dee gaina hua o dahi manu somo daudahi i lo te veelenga?”  ");
INSERT INTO nkr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Gai de hine laa ga hai ange gi de labodo, “Gimaau e maua i de gai hua o denga manu ssomo i lo te veelenga; ");
INSERT INTO nkr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","aagai de Maadua gu hai mai gimaau gi dee gaina hua o de manu somo i lo te ungaalodo o de veelenga, be gi poo ange aagena, gi dee maakau ai gimaau.” ");
INSERT INTO nkr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Gai de labodo ga hai ange gi de hine laa, “Gooluu e dee maakau naa donu! ");
INSERT INTO nkr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Gai de Maadua e iloo bolo de laangi naa huu ooluu e gai ai hua o de manu laa, gai ooluu mada gu maahuge; gooluu gu bei dagodo o de Maadua gu iloo tanuaa ma de baubau.” ");
INSERT INTO nkr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Gai ga gidee huu e de hine laa bolo hua o de manu laa e danuaa i de gai, gai e tilo danuaa, gai e hai ai tangada ga heiangi, gai ia ga hhagi dahi ono hua ga gai, gai ia ga gaavange hogi hanu gi dono bodu gi gaina. ");
INSERT INTO nkr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Gai gu maahuge olaau ganomada, gai gilaau gu tonu iho bolo gu deai olaau malo, gai gilaau ga dui denga lau o de manu somo go de fig ga haoli ai gilaau. ");
INSERT INTO nkr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gai gilaau gu langona de leo o Tagi Maolunga go de Maadua i dono seesee i lo te veelenga i de maluulu o de ahiahi, gai taane laa ma dono bodu ga hulo ga mmuni i Tagi Maolunga go de Maadua i magavaa o denga manu ssomo i lo te veelenga. ");
INSERT INTO nkr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Gai Tagi Maolunga go de Maadua ga hagahi taane ga ssili ange gi de ia, “I hee iai goe?” ");
INSERT INTO nkr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Gai taane laa ga hai ange, “Au ne langona doo leo i lo te veelenga, gai au gu madagu, go hiidinga au e deai donu ogu malo, gai au ga hano ga mmuni.” ");
INSERT INTO nkr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Gai de Maadua ga ssili ange, “Gai goai ne daalaa adu bolo koe e deai donu oo malo? Koe gu gai naa hua o de manu somo aagu gu tala adu laa koe gi dee gaina?” ");
INSERT INTO nkr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Gai taane laa ga hai ange, “Go de hine aau ne gaamai nei gi noho madali au ne gaamai gi de au hua o de manu laa, gai au ga gai.” ");
INSERT INTO nkr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Gai Tagi Maolunga go de Maadua ne hai ange gi de hine, “Se hegau bee hee aau gu hai nei?” Gai de hine laa ga hai ange, “Go de labodo ne hagasengalia au, gai au ga gai.”  ");
INSERT INTO nkr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Gai Tagi Maolunga go de Maadua ga hai ange gi de labodo, “Go hiidinga koe gu hai de hegau nei, koe gu kii ange de hagamalaia i denga manu haangai alodahi, ma denga manu lodo henua alodahi. Koe e tolo naa i honga doo dinae, ma de gai mama o de gelegele i taulooloa oo laangi e mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au e hai naa gi hai kino gooluu ma de hine, ma au dama ma dono aamuli, gai de aamuli o de hine naa e hagalagohia naa doo biho, gai koe e kadi naa muli dono vae.”  ");
INSERT INTO nkr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Gai ia ga hai ange gi de hine laa, “Au e hai naa gi kona doo mmae i doo masavaa e hai ai oo hagalangona; koe e mmae naa i de masavaa oou e haanau ai. Koe e lodo mmao naa i doo bodu, ma de noho i lalo dana hainga.” ");
INSERT INTO nkr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Gai Tagi Maolunga ga hai ange gi Adam, “Go hiidinga koe ne hagallongo ange gi muna a doo bodu, ga gai ai hua o de manu somo aagu gu hai adu koe gi dee gaina, deelaa ai, de gelegele gu hagamalaia i oo hiidinga; gai koe e gaimee ai naa donu huu noo koe e hagadalea ange aagena, i taulooloa oo laangi e mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Gai denga manu dabeo aama manu daladala e ssomo age naa i honga de gelegele, gai koe e gaimee naa i hua o manu i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Koe e hai hegau naa gi salia goe i taadaa, gai koe ga maua i de gaimee, ga dae ai gi doo ahe ange gi de gelegele, go hiidinga koe ne kave mai i de gelegele; gai koe go de mama donu o de gelegele, deelaa ai, koe e ahe ange naa donu gi de gelegele.” ");
INSERT INTO nkr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Gai taane laa ga hagaingoo ange dono bodu go Eve, i hiidinga go ia tinana o mee alodahi e mouli. ");
INSERT INTO nkr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Gai Tagi Maolunga go de Maadua ga hai hanu malo i gili manu, ga hakahu ange ai Adam ma dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Gai Tagi Maolunga go de Maadua ga hagadaba, “Tilo, tangada gu bei odaadeu dagodo, ia gu iloo ngaadahi tanuaa ma de baubau. Deenei ai, e hagamanavasaa noo ia e hhagi hogi ga gai hua o de manu o de mouli, gai ia e mouli ga hano ai e dee ngado mai.”  ");
INSERT INTO nkr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Gai Tagi Maolunga go de Maadua ga alualu taane laa gi hano gee mai i de veelenga go Eden, gai ia ga hagabalabala ai ga doo de gelegele oona ne daamada mai ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Gai dua huu dana hai taane laa gi hano gee mai i de veelenga, gai ia ga dugu hanu cherubim i de baasi gi dua o de veelenga go Eden, ma dahi gadilaasa ula e luilui saele laa, e hagaloosi ai de haiava e hano laa, gi de manu somo o de mouli. ");
INSERT INTO nkr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Gai Adam ne hagahebaa ma donu bodu go Eve, gai de hine laa gu hai dama, ga haanau a Cain. Gai ia ga hagadaba, “Au gu kave dahi dama daane mai i daho Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Gai muli mai gai a Eve ne haanau taina daane o Cain go Abel. Gai Abel se dangada e hagaloosi ange denga ssiibi, aagai a Cain se dangada hai veelenga. ");
INSERT INTO nkr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Gai dahi laangi huu gai a Cain ga gaamai gi Tagi Maolunga dahi sigidaumaha i huamanu mai i dana veelenga. ");
INSERT INTO nkr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Gai Abel ne gaamai manu ne haanau i taamada i dana hagabuulingaa ssiibi ma olaadeu mee moomuna. Gai Tagi Maolunga ne malangilangi i Abel ma dana sigidaumaha, ");
INSERT INTO nkr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","gai ia tee malangilangi i Cain aabe go dana sigidaumaha. Gai a Cain gu kona mmao dono lili, gai luoono mada gu hagaago mai donu dono lili. ");
INSERT INTO nkr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Gai Tagi Maolunga ga ssili ange gi a Cain, “Gu aha gu lili ai naa goe? Gai gu aha luoo mada gu hagaago mai ai naa doo lili? ");
INSERT INTO nkr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Noo koe e hai de mee heohi, gai koe e dau i ogu daha! Gai noo koe e dee hai de mee heohi, gai de baubau e bei dagodo o de manu alasala e dogoduli laa i ma too haitoga; gai e lodo go ia e huahua i de goe, aagai koe haia go koe e dagina de baubau.” ");
INSERT INTO nkr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Gai a Cain ga hai ange gi dono daina daane, “Gidaau ga hulo gi tuu malaelae.”  Gai de masavaa olaau e nnoho ai i tuu malaelae, gai a Cain ga hebagi ange gi dono daina go Abel, ga daa ia gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Gai Tagi Maolunga ga ssili ange gi a Cain, “I hee iai doo daina go Abel?” Gai ia ga hai ange, “Au e dee iloo, gu aha, go au e diiloo ange dogu daina?” ");
INSERT INTO nkr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Gai Tagi Maolunga ga hai ange, “Se hegau bee hee aau gu hai nei? Tilo, dodo o doo daina e tangi mai gi de au i lo te gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Deenei ai, koe gu hagamalaia ma gu dee maua gi hhua au manu e doo i de gelegele, go de gelegele ne holomia laa dodo o doo daina daane aau ne daa laa ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Gai de masavaa naa huu aau e hagabalabala ai de gelegele e doo, gai e dee maua naa donu gi hanu hua iai, gai koe e hai naa ga se dangada e silivaahea ma de hagadaga saele i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Gai a Cain ga hai ange gi Tagi Maolunga, “Dogu hagaduasala gu kii ange i de mee aagu e mau i de hagauda! ");
INSERT INTO nkr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tilo, anailaa nei gai koe gu hai au gi dee noho i de henua, gai koe e hagammuni naa luoo mada i de au; au e hai naa ga se dangada e silivaahea saele ma tee noho baba i honga de henua, gai be goai naa huu e hedae mai gi de au, gai ia e daa donu au gi magau.” ");
INSERT INTO nkr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Gai Tagi Maolunga ga hai ange gi de ia, “E dee deenaa tagodo! Gai be goai naa huu e daia goe ga magau, gai e sui ange naa gi de ia i e hidu hanonga.” Gai Tagi Maolunga ne hai dahi hagailonga ga maaga ai a Cain, kana hedae ange dahi dangada gi de ia ga daa ia gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Gai a Cain ga hano gee mai i mada luu mada o Tagi Maolunga ga hano ga noho i de henua go Nod, i baasi i dua o Eden. ");
INSERT INTO nkr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Gai a Cain ne hagahebaa ma dono bodu, gai de hine laa gu hai dama ga haanau Enoch. Gai a Cain ga hagaduu age dahi aduhale, ga hagaingoo i de ingoo o dana dama daane go Enoch. ");
INSERT INTO nkr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Gai Enoch ne hagadili Irad, Irad ne hagadili Mehujael, Mehujael ne hagadili Methushael, gai Methushael ne hagadili Lamek. ");
INSERT INTO nkr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Gai Lamek ne hai bodu ange gi e dogolua haahine; de ingoo o dahi go Adah, gai de ingoo o de ia ange laa go Zillah. ");
INSERT INTO nkr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Gai Adah ne haanau Jabal, go ia tamana o dangada e nnoho i lodo hale malo, ma de haangai denga manu. ");
INSERT INTO nkr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Gai de ingoo o dono daina daane go Jubal, go ia tamana o dangada alodahi e hagadangidangi i de harp ma de flute. ");
INSERT INTO nkr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Gai Zillah ne haanau hogi Tubal-Cain, go ia e agona ange gilaadeu e hai hegau i bronze ma iron. Gai taina haahine o Tubal-Cain go Naamah. ");
INSERT INTO nkr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Gai Lamek ga hai ange gi luoono bodu: “Adah ma Zillah, gooluu nnoho mai hagalaangona agu muna, luu bodu o Lamek gi kana ange gi hagalaangona agu muna: au gu daa dahi daane ma gu magau, i hiidinga dana lagohia au, go tama daane ne hagammae ina au. ");
INSERT INTO nkr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Noo e hidu hanonga e sui ange ai de baubau ne hai ange gi a Cain, gai e madahidu ma hidu hanonga e sui ange ai de baubau e hai ange gi Lamek.”  ");
INSERT INTO nkr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Gai Adam ne ahe ange ga hagahebaa ma dono bodu, gai de hine laa gu haanau dahi dama daane ga hagaingoo ange ia go Seth, i hiidinga ia ne hagadaba, “De Maadua gu gaamai gi de au dahi dama e sui ai Abel, go hiidinga a Cain gu daa ia ma gu magau.” ");
INSERT INTO nkr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Gai a Seth ga hagadili hogi dahi dama daane, gai ia ga hagaingoo ange ia go Enos. Gai deenei de masavaa a dangada ne daamada ai de hagahi ange de ingoo go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Deenei de beebaa e tala ai dagodo o de aamuli o Adam. De masavaa a de Maadua ne hai ai tangada, gai ia ne hai tangada gi bei ono hagadulagi. ");
INSERT INTO nkr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ia ne hai taane ma de hine, gai ia ne hagamanuuia gilaau ga hagaingoo ange gilaau go Tangada, i de laangi aana ne hai ai gilaau. ");
INSERT INTO nkr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Gai ga 130 huu ngadau o Adam, gai ia ga hagadili dahi dama daane bei ono hagadulagi aama ono dagodo; gai ia ga hagaingoo ange ia go Seth. ");
INSERT INTO nkr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Gai ne 800 ange ngadau o Adam ne mouli ai, i dua dana hagadili a Seth, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Gai ne 930 ngadau o Adam ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Gai ga 105 huu ngadau o Seth, gai ia ga hagadili Enos. ");
INSERT INTO nkr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Gai ne 807 ange ngadau o Seth ne mouli ai. I dua dana hagadili Enos, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Gai ne 912 ngadau o Seth ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Gai ga 90 huu ngadau o Enos, gai ia ga hagadili Kenan. ");
INSERT INTO nkr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Gai ne 815 ange ngadau o Enos ne mouli ai, i dua dana hagadili Kenan, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Gai ne 905 ngadau o Enos ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Gai ga 70 huu ngadau o Kenan, gai ia ga hagadili Mahalalel. ");
INSERT INTO nkr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Gai ne 840 ange ngadau o Kenan ne mouli ai, i dua dana hagadili Mahalalel, gai e hanu ange ana dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Gai ne 910 ngadau o Kenan ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Gai ga 65 huu ngadau o Mahalalel, gai ia ga hagadili Jared. ");
INSERT INTO nkr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Gai ne 830 ange ngadau o Mahalalel ne mouli ange ai, i dua dana hagadili Jared, gai ne hanu ange ana dama daane ma damaa hine ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Gai ne 895 ngadau o Mahalalel ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Gai ga 162 huu ngadau o Jared, gai ia ga hagadili Enoch. ");
INSERT INTO nkr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Gai ne 800 ange ngadau o Jared ne mouli ai, i dua dana hagadili Enoch, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Gai ne 962 ngadau o Jared ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Gai ga 65 huu ngadau o Enoch, gai ia ga hagadili Methuselah. ");
INSERT INTO nkr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Gai Enoch ne seesee madali de Maadua i e 300 ngadau, i dua dana hagadili Methuselah, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Gai ne 365 ngadau o Enoch ne mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Gai Enoch ne seesee madali de Maadua, gai ia gu dee maleva, i hiidinga de Maadua gu kave gee ia. ");
INSERT INTO nkr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Gai ga 187 huu ngadau o Methuselah, gai ia ga hagadili Lamek. ");
INSERT INTO nkr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Gai ne 782 ange ngadau o Methuselah ne mouli ai, i dua dana hagadili Lamek, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Gai ne 969 ngadau o Methuselah ne mouli ai, gai ia gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Gai ga 182 huu ngadau o Lamek, gai ia ga hagadili dahi dama daane, ");
INSERT INTO nkr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ga hagaingoo ange ia go Noah, i hiidinga ia ne hagadaba, “Tama nei e hagaaneane mai naa gidaadeu, i adaadeu hegau hai ngadaa e hai, i honga de gelegele a Tagi Maolunga gu hagamalaia laa.” ");
INSERT INTO nkr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Gai ne 595 ange ngadau o Lamek ne mouli ai, i dua dana hagadili Noah, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Gai ne 777 ngadau o Lamek ne mouli ai, gai ia gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Gai ga 500 huu ngadau o Noah, gai ia ga hagadili a Shem ma Ham aama Japheth. ");
INSERT INTO nkr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","De masavaa laa gai gu daamada de soa dangada i henua i lalo, gai gilaadeu ga haanau denga damaa hine. ");
INSERT INTO nkr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Gai ga gidee huu e dama a de Maadua de mahamaha o denga damaa hine a dangada, gai gilaadeu ga hili denga damaa hine olaadeu e vaasuu ai ga hai bodu ange aagena. ");
INSERT INTO nkr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Gai Tagi Maolunga ga hagadaba, “Dogu Hagasaalunga e dee dugu ange tangada gi mouli ga hano ai, go hiidinga tangada se angaanga e magau. Gai ia e mouli naa donu huu i e 120 ngadau.” ");
INSERT INTO nkr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","De masavaa laa ma muli mai ange, gai denga doa gu noho i henua i lalo, gai de masavaa huu o denga dama a de Maadua ne hagahebaa ai ma denga damaa hine a dangada, gai gilaadeu ga hagadili hanu dama. Aanei denga daane mmahi madagidagi, go denga daane dau. ");
INSERT INTO nkr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Gai Tagi Maolunga gu gidee bolo gu kona mmao de baubau o dangada i henua i lalo, gai alaadeu dahulinga ma maanadu i olaadeu lodo i masavaa alodahi go de baubau donu huu. ");
INSERT INTO nkr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Gai Tagi Maolunga gu ahe dana maanadu i dana hai tangada i henua i lalo, gai ia gu daemaha mmao ono lodo. ");
INSERT INTO nkr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Gai Tagi Maolunga ga hagadaba, “Au e hai naa gi odi i de maakau dangada aagu ne hai laa i de gelegele; go dangada alodahi ma manu dolodolo, ma manu e tolo i honga de gelegele, aama denga manu llele i lo te moana i lunga, i hiidinga au gu sivi i dagu hai gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aagai Tagi Maolunga ne malangilangi i Noah. ");
INSERT INTO nkr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Deenei taalanga o de huaabodu o Noah. Noah se daane e heohi aama tee haisala i dono atangada; Noah ne seesee madali de Maadua. ");
INSERT INTO nkr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah ne hagadili e dogodolu dama daane: go Shem, ma Ham, aama Japheth. ");
INSERT INTO nkr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","De masavaa laa gai henua i lalo gu kona mmao de hakino gee, i mada luu mada o de Maadua, gai gu laumalie de alasala i henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Gai de Maadua ga tilo huu honga henua i lalo, gai ia gu gidee bolo gu kona donu de hakino gee, go hiidinga hegau alodahi a dangada gu kona donu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Gai de Maadua ga hai ange gi Noah, “Au gu baba ange e daa gi maakau dangada alodahi, go hiidinga henua i lalo gu honu i alaadeu hegau vaivai daakodo. Tilo, au e hagallilo naa gilaadeu madali henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gai koe hagaduulia dahi vaga hale i laagau o de gopher. Gai haia hanu aabi i lo te vaga hale laa, ma de haoli laa lodo ma laa daha i denga tar. ");
INSERT INTO nkr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Gai deenei dau hai e hagaduu ai: e dolulau sugilima de looloa, gai e madalima sugilima de lahalaha, gai e matolu sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gai haia dahi mee e pono iho ai honga de hale vaga, gai koe ga dugu dahi damaa mommee gi mahuge, i de mommee e hedae ai laa denga baabaa i de baasi, ma de mee e pono iho ai laa honga de hale, gai haia gi dahi sugilima tuuduu i luu baasi alodahi. Haia hogi dahi haitoga i de baasi de vaga hale. Gai haia gi dolu ono deege. ");
INSERT INTO nkr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Gai au e hai naa gi dolona honga henua i lalo e daa ai gi maakau mee alodahi e mouli ma e manamanava i lalo de langi. Mee alodahi i henua i lalo e odi naa i de maakau. ");
INSERT INTO nkr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aagai au e hai naa dahi hagatoo donu hagaheloongoi madali goe; gai koe ga ulu ai gi lo te vaga hale laa madali au dama daane, ma doo bodu, ma bodu o au dama. ");
INSERT INTO nkr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Gai koe gaamai e dagilua manu dolodolo, i denga hagadaagangaa manu alodahi gi lo te vaga hale, e dahi manu daane ma e dahi manu hahine, gi mouli ai gilaadeu madali goe. ");
INSERT INTO nkr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","E dagilua mai i denga hagadaagangaa manu llele, ma hagadaagangaa manu dolodolo, ma hagadaagangaa manu e tolo i honga de gelegele, e loomai naa gi oo daha, gi mouli ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Gai koe hagabudulia denga hagadaagangaa gai alodahi, ga doange e gaimee ai goe aama denga manu.” ");
INSERT INTO nkr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Gai Noah ne hai donu ga bei muna alodahi a de Maadua gu tala ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Gai Tagi Maolunga ga hai ange gi Noah, “Hannoo ulu gi lo te vaga hale madali dangada alodahi i doo huaabodu, go hiidinga au gu gidee bolo koe se daane e heohi oo dagodo i de atangada nei. ");
INSERT INTO nkr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Gai koe gaavee e dagihidu mai i denga hagadaagangaa manu gilimalali alodahi, e dahi manu hahine ma dahi manu daane, ma e dagilua mai i denga hagadaagangaa manu e dee gilimalali laa, e dahi manu daane madali dahi manu hahine. ");
INSERT INTO nkr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Gaavee hogi e dagihidu mai denga hagadaagangaa manu llele i lo te moana i lunga, e dahi manu daane ma dahi manu hahine, gi mouli ai gilaadeu, gai gilaadeu ga hagadili i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gai e hidu ange naa donu huu laangi, gai au ga hai gi pala iho de langi gi henua i lalo, i e madahaa laangi ma e madahaa boo, gai au ga daa ai naa gi maakau mee alodahi e mouli aagu ne hai laa.” ");
INSERT INTO nkr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Gai Noah ne hai mee alodahi a Tagi Maolunga ne tala ange ia gi haia. ");
INSERT INTO nkr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Gai Noah gu onolau ono ngadau i de masavaa ne hai ai tolona i henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Gai a Noah ma ana dama daane ma dono bodu ma bodu o ana dama, ga ulu gi lo te vaga hale gi ola mai ai gilaadeu i tolona. ");
INSERT INTO nkr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Gai denga manu gilimalali, ma manu e dee gilimalali, ma denga manu llele, aama manu alodahi e tolo i honga de gelegele, ");
INSERT INTO nkr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","e dahi manu daane ma e dahi manu hahine, ne loomai ga ulu madali Noah gi lo te vaga hale, bei de hai a de Maadua gu tala ange ai laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gai dua huu e hidu laangi, gai gu dolona honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Gai go de onolau ngadau o Noah, i de madaangahulu ma hidu laangi o de lua malama — go de laangi nei ne hhuge ai denga vai i lalo de henua, gai denga abaaba o de langi gu hhuge. ");
INSERT INTO nkr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Gai de langi ne pala iho gi henua i lalo i e madahaa laangi ma e madahaa boo. ");
INSERT INTO nkr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Gai go de laangi laa donu hogi o Noah ma ana dama daane, go Shem, ma Ham, ma Japheth, ma de bodu o Noah, ma bodu o alaau dama daane dogodolu ne ulu ai gi lo te vaga hale, ");
INSERT INTO nkr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","go gilaadeu ma denga hagadaagangaa manu lodo henua alodahi, ma denga hagadaagangaa manu haangai alodahi, ma denga hagadaagangaa manu e tolo i honga de gelegele, aama denga hagadaagangaa manu llele alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gai ne dagilua hogi mai i denga manu alodahi e mouli ne ulu madali Noah gi lo te vaga hale. ");
INSERT INTO nkr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Gai e hanu manu daane ma manu hahine, mai i denga mee e mouli ne ulu gi lodo, bei de hai a de Maadua gu tala ange ai gi Noah. Gai Tagi Maolunga ga pono de haitoga. ");
INSERT INTO nkr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Gai ne madahaa laangi ne dolona ai henua i lalo alodahi, gai gu hagahonu age huu de vai, gai de vaga hale laa gu llanga age ga dahedahea i honga denga vai. ");
INSERT INTO nkr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Gai gu honu baabaa honga de henua i vai, gai de vaga hale laa gu dahedahea i honga de vai. ");
INSERT INTO nkr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Gai tai gu kona de honu honga henua i lalo, gai mounga maolunga alodahi gu haolia i vai. ");
INSERT INTO nkr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Gai de gelo o vai e haoli honga denga mounga gu kii ange i de madaangahulu ma lima sugilima. ");
INSERT INTO nkr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gai mee alodahi e mouli ma e ngalungaalue saele i honga de henua gu maakau — go manu llele, ma manu haangai, ma manu lodo henua, ma manu vaaligiligi alodahi i honga de henua, aama dangada alodahi; ");
INSERT INTO nkr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","mee alodahi e mouli ma e manavanava i honga de henua gu odi i de maakau. ");
INSERT INTO nkr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gai mee alodahi e mouli i honga de henua gu odi i de maakau: go dangada, ma manu dolodolo, ma manu e tolo i honga de gelegele, aama manu llele i henua i lalo. Go Noah donu huu e doe, ma dangada madali ia i lo te vaga hale. ");
INSERT INTO nkr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Gai de vai ne haoli honga de henua i e 150 laangi. ");
INSERT INTO nkr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Gai de Maadua gu manadua e ia a Noah ma denga manu lodo henua, ma manu haangai alodahi e nnoho madali ia i lo te vaga hale. Gai de Maadua ga hai gu ssau mai de madangi mmahi gi honga de henua gi hagaahea ai tai. ");
INSERT INTO nkr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Gai gu tuu de ssali age o denga vai i lalo de henua, gai gu pono denga abaaba o de langi, gai gu sili de langi. ");
INSERT INTO nkr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Gai denga vai gu daamada de aahe ga hulo gee mai i honga de henua, gai dua huu e 150 laangi, gai tai gu masa; ");
INSERT INTO nkr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","gai de madaangahulu ma hidu huu o de hidu malama, gai de vaga hale laa gu gasa i honga de mounga go Ararat. ");
INSERT INTO nkr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Gai denga vai ne hagadagadaga iho de masa ga dae ai gi de madaangahulu malama, gai tahi laangi huu o de malama, malama, gai gu ssula age ulu o denga mounga. ");
INSERT INTO nkr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Gai dua huu de madahaa laangi, gai a Noah ga hhuge de abaaba o de vaga hale aana ne hai laa, ");
INSERT INTO nkr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","gai ia ga hai gi hano dahi raven, gai de manu lele laa ne aheahe saele donu huu, ga dae ai gi de masa tai i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Gai Noah ne ahe ange hogi ga hai gi hano dahi manu kono, e tilo ai be gu kii ange de masa denga tai i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Gai de manu kono laa teai sana mommee ne gidee e toga ange aagena luoono vae, gai ia ga ahe mai gi daho Noah i lo te vaga hale, go hiidinga denga vai goi haoli huu honga de henua alodahi. Gai Noah ne poo de manu kono laa ga dada mai gi ono daha i lo te vaga hale. ");
INSERT INTO nkr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Gai Noah ne tali adu ange e hidu laangi gi ono dua, gai ia ga hai ange hogi de manu kono, i lo te vaga hale laa gi lele gi hano. ");
INSERT INTO nkr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Gai ga ahe mai huu de manu kono laa gi ono daha i de ahiahi, gai ia e kadi dahi lau olive se goodo hhagi laa, i dono ngudu. Gai Noah gu iloo bolo gu kii ange de masa de vai i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Gai ia ne tali ange hogi i e hidu laangi, gai ia ga hai ange hogi gi hano de manu kono laa, gai de manu laa tee ahe mai ange gi ono daha. ");
INSERT INTO nkr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Gai tahi laangi o tahi malama o de 601 ngadau o Noah, gai gu masa de vai i honga de henua. Gai Noah ga hhuge de pono i honga de vaga hale, ga hagadui age ga tilo, gai ia gu gidee bolo gu mmasa honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Gai go de madalua ma hidu laangi o de lua malama ne mmasa i honga de henua alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Gai de Maadua ne basa ange gi Noah, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Koe sao mai i lo te vaga hale, madali doo bodu, ma au dama daane ma bodu o au dama. ");
INSERT INTO nkr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hagassao ina mai hogi denga hagadaagangaa manu alodahi e mouli laa madali goe — go denga manu llele, ma manu dolodolo, aama manu e tolo i honga de gelegele — gai gilaadeu ga hagadili ai gi lagolago i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Gai Noah ga sao mai, madali ana dama daane, ma dono bodu aama bodu o ana dama. ");
INSERT INTO nkr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Gai denga manu dolodolo alodahi, ma manu llele alodahi — go manu alodahi e tolo i honga de gelegele — gu ssao mai i lo te vaga hale. ");
INSERT INTO nkr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Gai Noah ga bae dahi mommee o ssigidaumaha ange gi Tagi Maolunga, ga kave hanu manu mai i denga manu gilimalali alodahi, ma hanu manu llele gilimalali, ga hai ai ssigidaumaha dudu i honga de mommee o ssigidaumaha laa. ");
INSERT INTO nkr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Gai Tagi Maolunga gu dungua de kala o ssigidaumaha laa, gai Tagi Maolunga ga hagadaba i ono lodo: “Au gu dee ahe ange naa donu e hagamalaia de gelegele i hiidinga o dangada, e dee galemu donu maanadu i lodo o tangada, e baubau donu mai i dono gauligi. Au gu dee ahe ange naa donu e daa gi maakau mee alodahi e mouli, bei dagu hai ne hai ai nei i de haonga nei. ");
INSERT INTO nkr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Taulooloa de dahi henua i lalo, gai e dee helui naa donu de doo ma de hagihagi, de masavaa hagamagalili ma de mahanahana, aama de laangi ma de boo.” ");
INSERT INTO nkr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gai de Maadua ne hagamanuuiaNoah ma ana dama daane, ga hai ange gi gilaadeu, “Goodou hagadili gi soa haoa ai henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Gai denga manu lodo henua alodahi, ma manu llele alodahi i lo te moana, ma manu dolodolo alodahi i honga de gelegele, aama mamu alodahi i lausedi; mee nei alodahi e gaavadu naa gi goodou gi dagina. ");
INSERT INTO nkr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gai au e gaavadu hogi gi goodou denga hagadaagangaa manu alodahi e mouli e gaimee ai goodou, bei dagu hai gu gaavadu ai laa hogi gi goodou denga manu ssomo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Aagai goodou e dee gai donu kano iai de mouli, e bei go kano go iai ono dodo. ");
INSERT INTO nkr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Au e hagaduasala naa de manu lodo henua ma tangada e daia dahi goodou ga maakau, gai au e dau ange naa ssala gi tangada e daia ga magau dono daina. ");
INSERT INTO nkr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Be goai e daia dahi dangada ga magau, gai ia e daa naa hogi gi magau; go hiidinga de Maadua ne hai tangada ga hagadulagi ange gi ono dagodo. ");
INSERT INTO nkr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Gai goodou hagadili gi soa ga hhao ai honga henua i lalo ga hai gi soa dangada iai.”  ");
INSERT INTO nkr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Gai de Maadua ga basa ange gi a Noah ma ana dama daane e nnoho madali ia, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ailaa nei gai au e hai dagu hagatoo donu hagaheloongoi adu gi goodou ma oodou aamuli e loomai, ");
INSERT INTO nkr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma denga manu dolodolo alodahi e nnoho madali goodou: go denga manu llele, ma manu haangai, aama manu lodo henua alodahi, go manu alodahi ne ssao mai madali goodou i lo te vaga hale. ");
INSERT INTO nkr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Gai au e hai dagu hagatoo donu hagaheloongoi madali goodou, bolo au e dee ahe ange naa donu e daa gi maakau mee alodahi e mouli i tolona; gai tolona gu dee ahe ange naa donu hogi e oha henua i lalo.” ");
INSERT INTO nkr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Gai de Maadua ga hai ange, “Deenei de hagailonga o de hagatoo donu hagaheloongoi aagu e hai adu gi goodou, ma denga manu alodahi e mouli madali goodou, aama denga atangada alodahi e loomai i muli: ");
INSERT INTO nkr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","au gu hagaduu de umada i lodo giliiga, e hagamaanadu ai de hagatoo donu hagaheloongoi i omaau magavaa ma henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Gai de masavaa naa huu aagu e hai ai gi loage denga giliiga, gai de umada gu gidee i lodo giliiga laa, ");
INSERT INTO nkr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","gai au e manadua naa dagu hagatoo donu hagaheloongoi ange gi mee alodahi e mouli; aagai tolona e dee ahe ange naa donu e hai gi llilo mee alodahi e mouli. ");
INSERT INTO nkr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Gai de masavaa naa huu e duu ai de umada i lodo giliiga, ga gidee e au, gai au ga hagamaanadu de hagatoo donu hagaheloongoi dee ngado mai, i omaadeu magavaa ma mee alodahi e mouli i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Gai de Maadua ga hai ange gi a Noah, “Deenei de hagailonga o de hagatoo donu hagaheloongoi aagu gu hai i omaadeu magavaa ma mee alodahi e mouli i henua i lalo.” ");
INSERT INTO nkr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Gai denga dama daane a Noah ne ssao mai laa i lo te vaga hale go Shem, ma Ham aama Japheth. Gai a Ham e dahi ana dama daane, dono ingoo go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aanei denga dama daane dogodolu a Noah, gai go gilaadeu ne hagadili ga soa ga hhao ai henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Gai go Noah ne damadaa de hai de veelenga ga doo ai denga grape. ");
INSERT INTO nkr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Gai ia ne unu denga uvaini gu senga, gai ia gu deai ono malo ga dagodo ai i lo tono hale malo. ");
INSERT INTO nkr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Gai a Ham, tamana o Canaan, ne gidee bolo dono damana gu maatala ono malo ma gu too, gai ia ga tala ange gi luoono daina daane i duaahaho. ");
INSERT INTO nkr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Gai a Shem ma Japheth ga kave dahi malo ga daohi ange gi honga olaau eu, gai gilaau ga seesee dua ga hulo ga haoli ange delaau damana, gai olaau mada e huuhuli gee mai i delaau damana, gilaau tee gidee bolo ia e deai ono malo. ");
INSERT INTO nkr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Gai de masavaa o Noah ne alahage ai ga iloo mee a dana dama gauligi ne hai ange gi de ia, ");
INSERT INTO nkr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","gai ia ga hagadaba, “Canaan gu hagamalaia; ia e hai naa ga se dangada hai hegau maolalo niio luoono daina daane.” ");
INSERT INTO nkr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ia ne hagadaba hogi, “Duuhia Tagi Maolunga, de Maadua o Shem, gai Canaan gi se dangada hai hegau niio Shem. ");
INSERT INTO nkr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","De Maadua gi hagalaumalie ina de vaaenga o Japheth, gai ia gi noho madali a Shem i lodo ono hale malo, gai Canaan gi se dangada hai hegau niio Japheth.” ");
INSERT INTO nkr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Gai ne 350 ngadau o Noah ne mouli ai i dua tolona. ");
INSERT INTO nkr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Gai ne 950 ngadau alodahi o Noah ne mouli ai, gai ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Gai aanei aamuli o Noah ma ana dama daane: go Shem, ma Ham, aama Japheth. Gai gilaadeu ne hagadili hogi hanu dama i dua tolona. ");
INSERT INTO nkr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Dama daane a Japheth: go Gomer, ma Magog, ma Madai, ma Javan, ma Tubal, ma Meshek, aama Tiras. ");
INSERT INTO nkr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gai dama daane a Gomer: go Ashkenaz, ma Riphath aama Togarmah. ");
INSERT INTO nkr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dama daane a Javan: go Elishah, ma Tarshish, ma Kittim aama Dodanim. ");
INSERT INTO nkr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Gai denga huaadangada i tagudai nei ne hai ga dohu olaadeu vaaenga i olaadeu hagadiilinga ma olaadeu huaahenua, gai dahi huaadangada nei ma ana muna.) ");
INSERT INTO nkr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dama daane a Ham: go Cush, ma Egypt, ma Put, aama Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dama daane a Cush: go Seba, ma Havilah, ma Sabtah, ma Raamah, aama Sabteca. Dama daane a Raamah: go Sheba ma Dedan. ");
INSERT INTO nkr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush ne hagadili Nimrod; gai Nimrod go se daane mmahi i henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Gai ia gi se daane e abo i de dili manu i mada luu mada o Tagi Maolunga; deelaa ai, e hai ange, “Koe e bei dagodo o Nimrod, taane abo i de dili manu i mada luu mada o Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Taamada age o dono nohoanga hodooligi go Babel, ma Erek, ma Accad, ma Calneh, i de henua go Shinar. ");
INSERT INTO nkr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Gai ia ne humai i de henua laa ga hano gi Assyria ne hagaduu age ai Nineveh, ma Rehoboth Ir, ma Calah, ");
INSERT INTO nkr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen i magavaa o Nineveh ma Calah, go de aduhale laumalie. ");
INSERT INTO nkr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Egypt ne hagadili de gau Lud, de gau Anam, de gau Lehab, de gau Naphtuh, ");
INSERT INTO nkr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","de gau Pathrus, de gau Casluh (ne hagadili ai laa de gau Philistia) aama de gau Caphtor. ");
INSERT INTO nkr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan ne hagadili de gau Sidon, dana dama madua, ma de gau Heth, ");
INSERT INTO nkr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ma de gau Jebus, ma de gau Amor, ma de gau Girgash, ");
INSERT INTO nkr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ma de gau Hiv, ma de gau Erek, ma de gau Sin, ");
INSERT INTO nkr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ma de gau Arvad, ma de gau Zemar, aama de gau Hamath. Muli mai gai hagadiilinga o Canaan ne mavaevae saele. ");
INSERT INTO nkr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Gai de henua o de gau Canaan ne hano gi Sidon gai e dae gi Gerar, gai e hano hogi ga dae gi Gaza ma Sodom ma Gomorrah, ma Admah, ma Zeboiim, gai e ngado mai i Lasha. ");
INSERT INTO nkr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Gai aanei dama daane a Ham, ma olaadeu hagadiilinga, ma alaadeu muna, ma olaadeu henua, aama olaadeu huaahenua. ");
INSERT INTO nkr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ne hanu hogi dama a Shem; gai go ia tamana o denga dama a Eber, gai go taina daane madua o Japheth. ");
INSERT INTO nkr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Dama daane a Shem: go Elam, ma Asshur, ma Arpaxad, ma Lud, aama Aram. ");
INSERT INTO nkr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Dama daane a Aram: go Uz, ma Hul, ma Gether, ma Mash. ");
INSERT INTO nkr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaxad ne hagadili Shelah, gai Shelah ne hagadili Eber. ");
INSERT INTO nkr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ne hagadili e dogolua dama daane. De ingoo o dahi go Peleg, (go hiidinga dangada o henua i lalo ne mavaevae i dono masavaa), gai de ingoo o dono daina go Joktan. ");
INSERT INTO nkr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan ne hagadili Almodad, ma Sheleph, ma Hazarmaveth, ma Jerah, ");
INSERT INTO nkr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ma Hadoram, ma Uzal, ma Diklah, ");
INSERT INTO nkr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ma Obal, ma Abimael, ma Sheba, ");
INSERT INTO nkr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ma Ophir, ma Havilah, aama Jobab. Aanei dama alodahi a Joktan. ");
INSERT INTO nkr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Gai de mommee olaadeu e nnoho ai e daamada mai i Mesha ga hano gi Sephar ma de mommee iai duuduu i de henua i baasi i dua. ");
INSERT INTO nkr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aanei dama daane a Shem ma olaadeu hagadiilinga, ma alaadeu muna, ma olaadeu henua aama olaadeu huaahenua. ");
INSERT INTO nkr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aanei hagadiilinga o dama a Noah, ma de hagatauanga o olaadeu huaahenua, ma aamuli olaadeu ne loomai ai. Gai denga huaahenua alodahi ne loomai i denga hagadiilinga nei i dua tolona laumalie laa. ");
INSERT INTO nkr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","De masavaa laa gai ni muna daudahi donu huu o dangada e pasa ai i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Gai ga ngaalue mai huu dangada i de baasi i dua, gai gilaadeu gu gidee de mommee soe i de henua go Shinar, gai gilaadeu ga noho i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Gai gilaadeu ga hagataba i olaadeu magavaa, “Loomai, gidaadeu ga hai hanu duudangaa hadu, ga lala gi makaga.” Gilaadeu ne hagaduu i denga duudangaa hadu e dee go denga ngadi hadu, gai ne hagabigibigi mee nei i denga bitumen. ");
INSERT INTO nkr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Gai gilaadeu ga hagataba, “Loomai, gidaadeu ga hagaduu dahi aduhale moodaadeu, ma dahi hale maolunga, ga hai de ulu gi dae age gi lo te langi i lunga, gai gi duuhia ai e dangada gidaadeu, gai gi dee mavaevae saele ai gidaadeu i henua i lalo.” ");
INSERT INTO nkr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Aagai Tagi Maolunga ne hano iho e tilo de aduhale ma de hale maolunga a dangada gu hagaduu laa. ");
INSERT INTO nkr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Gai Tagi Maolunga ga hagadaba, “Tilo, gilaadeu alodahi se huaadangada e buni, ma de pasa i muna daudahi; gai gilaadeu gu daamada de hai de mee nei, gai e deai donu se mee e maua i de buibui gilaadeu, i de hai mee alaadeu gu hagatau e hai. ");
INSERT INTO nkr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Loomai, gidaadeu ga loiho e hai gi dee heloongoi gilaadeu i alaadeu muna, gi dee maua ai e dahi i de donu ange gi muna a tangada ange laa.” ");
INSERT INTO nkr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Gai Tagi Maolunga ne hai gilaadeu gi hulo gee mai i kilaa, gi mavaevae saele i henua i lalo alodahi, gai gilaadeu ga tuu de hagaduu age de aduhale laa. ");
INSERT INTO nkr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Deelaa ai, gu hagaingoo ange go Babel, go hiidinga go kilaa a Tagi Maolunga ne hai ai ga dee heloongoi denga muna o henua i lalo alodahi, gai go kilaa a Tagi Maolunga ne hai ai dangada gi mavaevae gi henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Aanei denga hagadiilinga o Shem. Gai ga lau huu ngadau o Shem, gai ia ga hagadili Arpaxad, i de lua ngadau i dua tolona. ");
INSERT INTO nkr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Gai ne 500 ange ono ngadau ne mouli ai, i dua dana hagadili Arpaxad, gai e hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Gai de matolu ma lima huu ngadau o Arpaxad, gai ia ga hagadili Shelah. ");
INSERT INTO nkr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Gai ne 403 ange ngadau o Arpaxad ne mouli ai, i dua dana hagadili Shelah, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Gai ga matolu huu ngadau o Shelah, gai ia ga hagadili Eber. ");
INSERT INTO nkr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Gai ne 403 ange ngadau o Shelah ne mouli ai, i dua dana hagadili Eber, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Gai ga matolu ma haa huu ngadau o Eber, gai ia ga hagadili Peleg. ");
INSERT INTO nkr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Gai ne 430 ange ngadau o Eber ne mouli ai, i dua dana hagadili Peleg, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Gai ga matolu huu ngadau o Peleg, gai ia ga hagadili Reu. ");
INSERT INTO nkr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Gai ne 209 ange ngadau o Peleg ne mouli ai, i dua dana hagadili Reu, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Gai ga matolu ma lua huu ngadau o Reu, gai ia ga hagadili Serug. ");
INSERT INTO nkr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Gai ne 207 ange ngadau o Reu ne mouli ai, i dua dana hagadili Serug, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Gai ga matolu huu ngadau o Serug, gai ia ga hagadili Nahor. ");
INSERT INTO nkr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Gai ne 200 ange ngadau o Serug ne mouli ai, i dua dana hagadili Nahor, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Gai ga madalua ma siva huu ngadau o Nahor, gai ia ga hagadili a Terah. ");
INSERT INTO nkr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Gai ne 119 ange ngadau o Nahor ne mouli ai, i dua dana hagadili a Terah, gai ne hanu ange dama daane ma damaa hine aana ne hagadili. ");
INSERT INTO nkr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Gai ga madahidu huu ngadau o Terah, gai ia ga hagadili Abram, ma Nahor, aama Haran. ");
INSERT INTO nkr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Deenei de aamuli o Terah. A Terah ne hagadili Abram, ma Nahor, aama Haran. Gai Haran ne hagadili a Lot. ");
INSERT INTO nkr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Gai Haran ne magau i mua o dono damana go Terah, i dono henua donu, go Ur o de gau Babylon. ");
INSERT INTO nkr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Gai Abram ma Nahor ne hai luoolaau bodu. De ingoo o de bodu o Abram go Sarai, gai de ingoo o de bodu o Nahor go Milcah, tamaa hine a Haran. Haran ne hagadili Milcah ma Iscah. ");
INSERT INTO nkr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Gai Sarai se hine dee hua; ia e deai ana dama. ");
INSERT INTO nkr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Gai a Terah ga kave dana dama daane go Abram, ma dono mogobuna go Lot, tama daane a Haran, aama Sarai dono saulaba ga hulo gee mai ai i Ur o de gau Babylon ga hulo gi Canaan, gai gilaadeu ne hulo ga tae gi Haran ga noho ai. ");
INSERT INTO nkr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Gai ga 205 huu ngadau o Terah, gai ia gu magau i Haran. ");
INSERT INTO nkr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Gai Tagi Maolunga ga hai ange gi Abram, “Hano gee mai i doo henua, ma oo dangada, ma de huaabodu o doo damana, gai koe hannoo gi de henua aagu e hagaago adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Gai au e hai naa goe gi se huaahenua soa mmao, au e hagamanuuia naa goe; au e hai naa doo ingoo gi maolunga, gai koe e hai naa gi se mee e manuuia ai dangada. ");
INSERT INTO nkr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Au e hagamanuuia naa dangada e hagamanuuia ina goe, gai e hagamalaia gilaadeu e hagamalaia ina goe; gai denga huaadangada alodahi o henua i lalo e manuuia naa i oo hiidinga.”  ");
INSERT INTO nkr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Gai Abram ne hano, bei de hai a Tagi Maolunga gu tala ange gi de ia; gai a Lot ne hano madali ia. Gai Abram gu madahidu ma lima ono ngadau i de masavaa oona ne hano gee ai i Haran. ");
INSERT INTO nkr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ia ne kave hogi dono bodu go Sarai, ma Lot, tama daane a dono daina daane, ma alaadeu mee alodahi ne mau, aama de gau hai hegau alaadeu ne kave mai i Haran, gai gilaadeu ne hulo ga tae gi de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Gai Abram ga hano laa lo te henua ga hano ai gu dae gi Shechem, i de mommee iai de oak o Moreh. De masavaa laa gai go de gau Canaan e nnoho i de henua laa. ");
INSERT INTO nkr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Gai Tagi Maolunga ga hakide ange gi Abram, ga hai ange, “Au e gaavange naa gi oo hagadiilinga de henua nei.” Gai Abram ne bae dahi mommee o ssigidaumaha ange gi Tagi Maolunga i kilaa, go de ia ne hakide ange laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Gai ia ne hano gee mai i kilaa ga hano gi de mounga i baasi i dua o Bethel, ga hagaduu dono hale malo; Bethel i de baasi i dai, gai Ai i de baasi i dua. Gai ia ne hagaduu ange hogi dahi mommee o ssigidaumaha ange gi Tagi Maolunga i kilaa, gai ia ga dalodalo ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Gai Abram ne dugu iho ono hale ga ngalue adu ange gi Negev. ");
INSERT INTO nkr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Gai gu onge honga de henua, gai Abram ne hano gi Egypt ga noho ai, go hiidinga gu kona de laumalie de onge i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gai ga dai baa ange huu ia gi Egypt, gai ia ga hai ange gi dono bodu go Sarai, “Au e iloo bolo koe se hine mahamaha, ");
INSERT INTO nkr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","gai de masavaa naa huu a de gau Egypt e gidee ai goe, gai gilaadeu ga hagataba, ‘Deenei dono bodu,’ gai gilaadeu e daa naa au ga magau, gai ga dugu goe gi mouli. ");
INSERT INTO nkr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Aude haihaia, daalaa bolo koe se daina hahine niiogu, gi abodonu mai ai gilaadeu gi de au i oo hiidinga, gai koe ga hagaola ai au.”  ");
INSERT INTO nkr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Gai ga dae huu Abram gi Egypt, gai de gau Egypt gu gidee bolo dono bodu se hine mahamaha mmao. ");
INSERT INTO nkr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Gai ga gidee huu e denga daane hai hegau o Pharaoh Sarai, gai gilaadeu ga tuhi ange ia gi Pharaoh. Gai de hine laa gu gaavee gi de hale o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Gai Pharaoh ga abodonu ange gi Abram i hiidinga o Sarai, gai Abram gu maua hanu ssiibi, ma kaau, ma donkey daane ma donkey haahine, ma daane ma haahine hai hegau, aama gamelo. ");
INSERT INTO nkr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Aagai Tagi Maolunga ga hai gi loomai denga mee hagamaakau gi honga o Pharaoh ma dangada i dono hale, i hiidinga o Sarai, de bodu o Abram. ");
INSERT INTO nkr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Gai Pharaoh ga aalu Abram gi humai, ga hai ange, “Gu aha gu hai mai ai nei goe de hegau nei gi de au? Gu aha tee tala mai ai laa goe bolo de hine nei go doo bodu donu? ");
INSERT INTO nkr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Gai gu aha goe gu hagadaba ai laa goe bolo ia go doo daina hahine? Gai au ne kave ia e hai ai dogu bodu. Tilo, deenei doo bodu, gaavee ia ga hulo ai gooluu mai i kinei!” ");
INSERT INTO nkr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Gai Pharaoh ga basa ange gi ono daane, gai gilaadeu ga hai ia gi hano madali dono bodu ma ana mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Gai Abram ma dono bodu, ma ana mee alodahi, aama Lot ne loomai i Egypt ga hulo gi Negev. ");
INSERT INTO nkr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Gai Abram gu kona donu de lagolago ana manu haangai, ma selevaa, aama goolo. ");
INSERT INTO nkr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Gai ia ne humai i Negev ga hano gi Bethel, go de mommee ne hagaduu ai dono hale malo i taamada, i magavaa o Bethel ma Ai, ");
INSERT INTO nkr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","go de mommee aana ne bae ai de mommee o ssigidaumaha. Gai go kilaa hogi o Abram ne dalodalo ange ai gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Gai Lot, taane e hano saele laa madali Abram, gu lagolago hogi ana ssiibi, ma ana manu haangai, aama ono hale malo. ");
INSERT INTO nkr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Gai gilaau gu dee oo i de nnoho i dahi mommee daudahi i de henua laa, go hiidinga gu kona de lagolago olaau goloa, gilaau gu dee maua i de nnoho i dahi mommee. ");
INSERT INTO nkr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Gai de gau hagaloosi manu o Abram, ma de gau hagaloosi manu o Lot gu dee heloongoi. De masavaa laa gai go de gau Canaan, ma de gau Perez e nnoho i de henua laa. ");
INSERT INTO nkr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Gai Abram ga hai ange gi a Lot, “Au e dangidangi adu, gi deai se hagadaumee i odaau magavaa, aabe go magavaa o odaau dangada hagaloosi manu, go hiidinga gidaau se hai daina. ");
INSERT INTO nkr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","De henua alodahi e dugu adu gi de goe, gai koe ga hilihili ai doo mommee e hano e noho ai. Gai noo koe e hano gi de masui, gai au ga hano gi de madau. Gai noo koe e hano gi de madau, gai au ga hano gi de masui.” ");
INSERT INTO nkr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Gai Lot ne galo ange ga tilo dagodo o de henua, gai ia gu gidee bolo de mommee soe i gaogao o Jordan, se mommee iai vai lagolago, i de baasi ange gi Zoar, gai e bei dagodo o de veelenga a Tagi Maolunga, ma de henua go Egypt. (Mee nei ne hai i mua de oha a Tagi MaolungaSodom ma Gomorrah.) ");
INSERT INTO nkr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Gai a Lot ne kave de mommee soe alodahi i gaogao o Jordan, gai ia ne ngalue ga hano gi de baasi i dua. Gai gilaau gu mavaevae ga nnoho dagidahi. ");
INSERT INTO nkr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram ne noho i de henua go Canaan, gai Lot ne hano ga noho i magavaa o denga aduhale i de mommee soe, ma de hagatuu ono hale malo i de mommee e baa ange gi Sodom. ");
INSERT INTO nkr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Gai de gau Sodom ni dangada baubau, ma de kona de haisala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Gai Tagi Maolunga ga hai ange gi Abram, i dua de hano gee o Lot mai i ono daha, “Dangage age ma gi diiloo, mai i de mommee oou e duu ai naa ga hano ai gi ngaiho, ma ngaage, ma dua aama dai, ");
INSERT INTO nkr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","go hiidinga au e gaavadu naa donu gi de goe ma doo hagadiilinga, de henua alodahi aau e gidee naa ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Gai au e hai naa oo hagadiilinga gi soa bei de lagolago o gelegele o de henua, gai noo e maua i de dau denga gelegele o de henua, gai e maua naa hogi i de dau de soa o doo hagadiilinga. ");
INSERT INTO nkr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hannoo seesee gi de looloa ma de lahalaha o de henua, go hiidinga au e gaavadu donu de henua nei gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Gai Abram ga dugu iho ono hale malo ga hano ga hagatuu i gaogao denga oak o Mamre i Hebron. Gai ia ga bae dahi mommee o ssigidaumaha ange gi Tagi Maolunga i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","De masavaa laa gai Amraphel, de hodooligi o Shinar ma Ariok, de hodooligi o Ellasar, ma Kedorlaomer, de hodooligi o Elam, aama Tidal, de hodooligi o Goiim, ");
INSERT INTO nkr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ne loomai e hebagi ange gi Bera, de hodooligi o Sodom, ma Birsha, de hodooligi o Gomorrah, ma Shinab, de hodooligi o Admah, ma Shemeber, de hodooligi o Zeboiim, aama de hodooligi o Bela, e bei go Zoar. ");
INSERT INTO nkr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Gai gilaadeu nei alodahi ne hagabuni i de geelonga o Siddim, e bei go Tai Soolo. ");
INSERT INTO nkr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Gai gilaadeu nei alodahi ne hai hegau ange gi Kedorlaomer i e madaangahulu ma lua ngadau, aagai de madaangahulu ma dolu ngadau huu gai gilaadeu ga hai baasi ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Gai de madaangahulu ma haa ngadau huu, gai Kedorlaomer ma denga hodooligi e dau ange laa gi de ia ga hagadee kii de gau Repha i Ashteroth Karnaim, ma de gau Zuz i Ham, ma de gau Em i Shaveh Kiriathaim, ");
INSERT INTO nkr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","aama de gau Hor i honga de mounga go Seir, ga dae ai loo gi El Paran, se mommee e baa ange gi de vao. ");
INSERT INTO nkr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Gai gilaadeu ne aahe mai gi En Mishpat (e bei go Kadesh), ga hagadee kii ai de henua alodahi o de gau Amalek, aama de gau Amor e nnoho laa i Hazazon Tamar. ");
INSERT INTO nkr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Gai de hodooligi o Sodom, ma de hodooligi o Gomorrah, ma de hodooligi o Admah, ma de hodooligi o Zeboiim, ma de hodooligi o Bela (e bei go Zoar) ne hulo e hebagi ange gi gilaadeu i de geelonga o Siddim, ");
INSERT INTO nkr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gai gilaadeu ne hebagi ange gi Kedorlaomer, de hodooligi o Elam, ma Tidal, de hodooligi o Goiim, ma Amraphel, de hodooligi o Shinar, ma Ariok, de hodooligi o Ellasar. E dogohaa hodooligi e hai baasi ange gi e dogolima. ");
INSERT INTO nkr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Gai de geelonga o Siddim e honu i denga tar, gai de masavaa huu o denga hodooligi o Sodom ma Gomorrah ne saavini ai e hulo, gai hanu gu too ange gi lodo mommee tar; gai de gau e doe ne saavini ga hulo gi denga mounga. ");
INSERT INTO nkr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Gai de gau i de baasi gee ga kave goloa alodahi o Sodom ma Gomorrah aama alaadeu gai alodahi ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Gai gilaadeu ne kave hogi a Lot, tama daane a taina o Abram ma ono goloa ga hulo ai, go hiidinga ia e noho i Sodom. ");
INSERT INTO nkr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Gai dahi daane ne ola ga hano ga tala ange gi Abram, taane Hebrew. De masavaa laa gai Abram e noho i gaogao denga oak nnui o Mamre, taane Amor, go taina daane o Eshcol ma Aner; gilaadeu nei alodahi ne hagabuni ange gi Abram. ");
INSERT INTO nkr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Gai ga langona huu e Abram bolo dono dangada gu noodia ma gu gaavee gee, gai ia ga dagi e 318 daane ne haanau i dono hale, gu agoago ange laa gi de hebagi, gai gilaadeu ga doolohi de gau laa ga daea adu loo i de mommee go Dan. ");
INSERT INTO nkr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Gai Abram ne vae ono daane hebagi i de boo, ga hebagi ange gi denga daane de baasi gee, ma de doolohi gilaadeu ga hulo gu tae gi Hobah, se mommee i de bido i ngaiho o Damascus. ");
INSERT INTO nkr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Gai ia ga hagaahe mai denga goloa alodahi, gai ia ne hagaahe mai hogi a Lot, tama daane a dono daina ma ono goloa alodahi, ma denga haahine aama de gau ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Gai ga ahe mai huu Abram i dua dana hagadee kii Kedorlaomer, ma denga hodooligi madali ia, gai de hodooligi o Sodom ne humai ga hedae ange gi de ia, i de geelonga go Shaveh (e bei go de geelonga a de hodooligi). ");
INSERT INTO nkr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Gai Melkizedek, de hodooligi o Salem ne humai hogi ga gaamai hanu pelaoaa ma hanu uvaini. Taane nei go tangada haimeedabu o de Maadua Maolunga Mmao laa. ");
INSERT INTO nkr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Gai ia ne hagamanuuia Abram ga hagadaba, “De Maadua Maolunga Mmao laa e hagamanuuia Abram, go de ia ne haia de langi ma henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Duuhia de Maadua Maolunga Mmao laa, go de ia ne hagaola ina goe mai i oo hagadaumee.” Gai Abram ne gaavange gi de ia tahi diba i diba e madaangahulu o mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Gai de hodooligi o Sodom ne hai ange gi Abram, “Hagaahea mai gi de au dangada alodahi, gai koe gaavee denga goloa moou.” ");
INSERT INTO nkr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aagai Abram ga hai ange gi de hodooligi o Sodom, “Au gu hagatoo donu ange gi Tagi Maolunga, go de Maadua Maolunga Mmao laa, go de ia ne haia de langi ma henua i lalo, ");
INSERT INTO nkr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","bolo au e dee kave donu dahi deleisi, aabe se mee e nnoa ai mee vae daudahi mai i oo daha, gi dee hagadaba ai goe, ‘Go au ne haia Abram ga se dangada lava.’ ");
INSERT INTO nkr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Gai au e dee kave donu dahi mee daudahi, deelaa donu huu go gai a denga daane gu gai, aama duuhanga o denga daane ne hulo madali au — go Aner, ma Eshcol, aama Mamre. Gilaadeu gi gaavee olaadeu duuhanga.” ");
INSERT INTO nkr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Dua mee nei gai Tagi Maolunga ne hagaago ange ana muna gi Abram i de midi, ga hai ange, “Abram, aude madagu. Go au dau mee hungihungi, gai go doo hagaoanga laumalie.” ");
INSERT INTO nkr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aagai Abram ga hai ange, “Dogu Ia Aamua go Iahweh, se aha naa aau e gaamai gi de au, gai au e deai sagu dama, gai de ia e bolo ai agu mee go Eliezer taane Damascus?” ");
INSERT INTO nkr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Gai Abram ga hai ange, “Koe tigi gaamai gi de au dahi hagadiilinga, deelaa ai, tangada hai hegau ne haanau nei i dogu hale, go ia aagu e bolo.” ");
INSERT INTO nkr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Gai gu humai de muna a Tagi Maolunga gi de ia, ga hai ange, “E dee go taane nei e gaavee doo boolonga, gai go dau dama donu e hagadili e bolo ai au mee.” ");
INSERT INTO nkr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Gai Tagi Maolunga ga hai Abram gi sao gi duaahaho, gai ia ga hai ange, “Galo age gi lo te langi i lunga mage daulia denga heduu be maua e goe i de dau.” Gai ia ga hai ange gi de ia, “Au e gaavadu naa hogi doo aamuli gi soa bei dagodo o denga heduu.”  ");
INSERT INTO nkr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Gai Abram ne hagadonusia muna a Tagi Maolunga; deelaa ai, Tagi Maolunga gu dau ia bolo se dangada e heohi. ");
INSERT INTO nkr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Gai ia ga hai ange gi Abram, “Go au go Iahweh ne gaamai naa goe i Ur o de gau Babylon, e gaavadu de henua nei e henua ai goe.” ");
INSERT INTO nkr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aagai Abram ga hai ange, “Dogu Ia Aamua go Iahweh, dee hee dagu hai e iloo ai bolo au e henua i de mee nei?” ");
INSERT INTO nkr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Gai Tagi Maolunga ne hai ange gi de ia, “Gaamai dahi kaau gauligi, ma dahi guudi hahine, ma dahi ssiibi daane, gu dagidolu laa olaadeu ngadau, aama dahi manu kono ma dahi pigeon.” ");
INSERT INTO nkr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Gai Abram ga gaamai denga manu nei alodahi gi de ia ga duuduu lua gilaadeu ga hagadau huuhuli ange denga diba o dahi manu ma dahi manu, aagai ia tee duuduu lua denga manu llele. ");
INSERT INTO nkr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Gai gu loiho denga manu llele e gaina laa kano o denga manu maakau e gai mee laa, gai Abram ga dugi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Gai ga danu huu de laa, gai Abram gu seni tao, gai tilo, gu hano iho de madagu ma de gohu laumalie gi ono elunga. ");
INSERT INTO nkr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Gai ia ga hai ange gi Abram, “Koe gi iloo bolo doo aamuli e nnoho gaainga naa i dahi henua gee. Gai gilaadeu e hai naa ga ni dangada hai hegau i kilaa aama de hagaduasala ina i e haalau ngadau. ");
INSERT INTO nkr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Gai au e hagaduasala naa de huaahenua olaadeu e hai hegau ange laa aagena, gai muli mai naa huu gai gilaadeu e kave naa goloa lagolago ga hulo gee mai ai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Gai aanei oo dagodo: koe e noho baba naa ga dae ai gi doo magau, gai koe e magau naa ga danu i de masavaa oou gu madumadua ai. ");
INSERT INTO nkr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Gai de haa atangada naa huu o doo aamuli, gai gilaadeu gu aahe mai gi de henua nei, go hiidinga iainei tigi odi ange baubau o de gau Amor.” ");
INSERT INTO nkr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Gai ga danu huu de laa, ga gohu de mee, gai tilo, de useahi e buu age i lo te gumedi e hhao ai laa de ahi, gai dahi laama ula e aheahe saele i magavaa o denga duudangaa manu laa. ");
INSERT INTO nkr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","De laangi laa gai Tagi Maolunga ne hai dahi hagatoo donu hagaheloongoi madali Abram, ga hai ange, “Au e gaavange naa gi doo hagadiilinga de henua nei, mai i Ssaalingaa Vai o Egypt ga dae ai gi ssaalingaa vai laumalie go Euphrates, ");
INSERT INTO nkr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ma de mommee o de gau Ken, ma de gau Keniz, ma de gau Kadmon, ");
INSERT INTO nkr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ma de gau Heth, ma de gau Perez, ma de gau Repha, ");
INSERT INTO nkr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ma de gau Amor, ma de gau Canaan, ma de gau Girgash, aama de gau o Jebus.” ");
INSERT INTO nkr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Gai Sarai, de bodu o Abram, tigi haanau ange donu dahi dama gi Abram. Aagai e dahi ono hahine hai hegau mai i Egypt, dono ingoo go Hagar. ");
INSERT INTO nkr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Gai Sarai ga hai ange gi Abram, “Tilo, Tagi Maolunga gu buibui gi dee haanau au. Gai koe hannoo hagahebaa ma dogu hahine hai hegau, maanadu ia e maua naa i de haanau hanu dama maagu.” Gai Abram ne hagallongo ange gi muna a Sarai. ");
INSERT INTO nkr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Gai Sarai, dono bodu, ne kave Hagar, dono hahine hai hegau mai i Egypt ga gaavange gi dono bodu go Abram, e hai ai dono bodu. Gai mee nei ne hai i dua de noho o Abram i Canaan, i e madaangahulu ngadau. ");
INSERT INTO nkr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Gai Abram ga hagahebaa ma Hagar, gai Hagar gu hai dama. Gai ga iloo huu e Hagar bolo ia gu hai dama, gai ia ga hagangadi mee dono hahine aamua. ");
INSERT INTO nkr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Gai Sarai ga hai ange gi Abram, “Go koe ne hidi ai dogu hagangadi mee ina. Au ne hai dogu hahine hai hegau gi hagahebaa ma goe, gai ga iloo huu e ia bolo ia gu hai dama, gai ia ga hagangadi mee au. Tagi Maolunga gi hagamodu ina be goai de gidaau e heohi.” ");
INSERT INTO nkr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Gai Abram ga hai ange gi Sarai, “Tilo, doo hahine hai hegau e noho donu i lalo doo sauaa. Gai koe haia ange gi de ia be se aha aau e lodo e hai ange gi de ia.” Gai Sarai ga vaivai hai dono hahine hai hegau, gai ia ga savini ga hano gee mai i ono daha. ");
INSERT INTO nkr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Gai tangada de langi o Tagi Maolunga, gu gidee e ia Hagar i gaogao dahi vai i de vao, go de vai e dagodo laa i gaogao de haiava e hano laa gi Shur. ");
INSERT INTO nkr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Gai ia ga hai ange, “Hagar, de hine hai hegau o Sarai, go hee oou ne humai ai naa? Gai go hee oou e hano naa aagena?” Gai Hagar ga hai ange, “Au ne savini ga hano gee mai i daho dogu hahine aamua go Sarai.” ");
INSERT INTO nkr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Gai tangada de langi o Tagi Maolunga ga hai ange gi de ia, “Ahe gi daho doo hahine aamua, ma gi noho i lalo dana hainga.” ");
INSERT INTO nkr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Gai ia ne hai ange hogi, “Au e hai naa gi soa doo hagadiilinga, gai e dee maua naa donu i de dau i hiidinga de kona delaadeu soa.” ");
INSERT INTO nkr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Gai tangada de langi o Tagi Maolunga ne hai ange hogi, “Tilo, koe gu hai dama, koe e haanau naa dahi dama daane, gai koe ga hagaingoo ange ia go Ishmael, go hiidinga Tagi Maolunga gu langona dagodo o doo vaivai haia. ");
INSERT INTO nkr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Gai ia e hai naa ga bei dagodo o dahi donkey lodo henua, ia e hai baasi ange naa gi dangada alodahi, gai dangada alodahi e hai baasi ange gi de ia, ia e noho naa e hagadaumee ange gi ono daina alodahi.” ");
INSERT INTO nkr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Gai ia ne hagaingoo ange Tagi Maolunga ne basa ange laa gi de ia, “Go koe de Maadua e gidee au,” go hiidinga ia ne hagadaba, “Au gu gidee donu de ia e gidee e dagidiiloo mai au.” ");
INSERT INTO nkr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Deenei ai, de vai laa gu hagaingoo ange go Beer Lahai Roi; gai de vai laa goi dagodo huu i magavaa o Kadesh ma Bered. ");
INSERT INTO nkr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Gai Hagar ga haanau tama daane a Abram, gai Abram ga hagaingoo dana dama daane ange gi Hagar go Ishmael. ");
INSERT INTO nkr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Gai Abram gu madavalu ma ono ono ngadau, i de masavaa a Hagar ne haanau ai dana dama go Ishmael. ");
INSERT INTO nkr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Gai ga massiva ma siva huu ngadau o Abram, gai Tagi Maolunga ga hakide ange gi de ia, ga hai ange, “Go au go de Maadua Mmahi Mmao laa. Koe gi hai hegau i de mee heohi i mada luoogu mada. ");
INSERT INTO nkr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Gai au e hai naa dahi hagatoo donu hagaheloongoi i odaau magavaa, gai au e hai naa gi kona mmao de soa doo aamuli.” ");
INSERT INTO nkr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Gai Abram ga ino gu baa luoono mada gi honga de gelegele, gai de Maadua ga basa ange gi de ia, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tilo, au e hai dahi hagatoo donu hagaheloongoi madali goe, gai koe e hai naa go tamana o denga huaahenua soa. ");
INSERT INTO nkr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Koe gu dee hagaingoo ange go Abram, gai e hagaingoo ange go Abraham, i hiidinga au e hai naa goe go tamana o denga huaahenua soa. ");
INSERT INTO nkr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Gai au e hai naa goe gi hagadili ina gi soa au dama, ma de hai goe gi ni huaahenua soa, gai e hanu naa hodooligi e haanau mai i daho doo aamuli. ");
INSERT INTO nkr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Gai au e hai naa dahi hagatoo donu hagaheloongoi e dee ngado mai adu gi de goe, ma doo hagadiilinga e loomai i oo dua, aama olaadeu atangada alodahi, bolo au go doo Maadua aama de Maadua o doo hagadiilinga e loomai i oo dua. ");
INSERT INTO nkr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gai de henua alodahi o Canaan, oou e noho gaainga ai naa, e gaavadu naa gi doo hagadiilinga e loomai i oo dua ga hano ai; gai au e hai naa go delaadeu Maadua.”  ");
INSERT INTO nkr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Gai de Maadua ga hai ange gi Abraham, “Gai deenei dau mee e hai, koe ma doo hagadiilinga e loomai i oo dua ma olaadeu atangada alodahi gi daohia dagu hagatoo donu hagaheloongoi. ");
INSERT INTO nkr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Deenei dagu hagatoo donu hagaheloongoi oodou e daohi i odaadeu magavaa, aama oo hagadiilinga e loomai i oo dua: denga daane alodahi e hai donu gi tuu dagaholiage. ");
INSERT INTO nkr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Gai goodou e tuu dagaholiage gili o denga daane. De mee nei se hagailonga o de hagatoo donu hagaheloongoi i odaadeu magavaa. ");
INSERT INTO nkr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Gai goodou ga tuu dagaholiage oodou dama daane alodahi i denga atangada alodahi, i de valu laangi i dua delaadeu haanau; go dama e haanau laa i doo hale, ma dama daane a de gau henua gee aau e hagao laa, e dee ni dama niiau. ");
INSERT INTO nkr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Gai koe diiloo duudia dagaholiage ina dangada ne haanau i doo hale aama dangada aau ne hagao. Gai gi dagodo ai de hagailonga o dagu hagatoo donu hagaheloongoi i oodou atangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Gai taane e dee tuu dagaholiage laa e vvae gee donu mai i daho ono dangada; go hiidinga ia gu oha dagu hagatoo donu hagaheloongoi.” ");
INSERT INTO nkr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Gai de Maadua ga hai ange gi Abraham, “Koe gu dee hagaingoo ange doo bodu go Sarai, gai iainei dono ingoo go Sarah. ");
INSERT INTO nkr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Gai au e hagamanuuia naa ia, ga gaavadu gi de goe dahi dama daane mai i ono daha. Au e hagamanuuia naa ia ga hai ia go tinana o huaahenua, gai hodooligi o denga huaadangada e loomai naa i ono daho.” ");
INSERT INTO nkr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Gai Abraham ga ino gu baa luoono mada gi honga de gelegele; gai ia ne gadagada ga hagadaba i ono lodo, “E maua e taane gu lau ono ngadau i de hagadili dahi gauligi? Gai e maua e Sarah, de hine gu massiva laa ono ngadau i de haanau dahi dama?” ");
INSERT INTO nkr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Gai Abraham ne hai ange gi de Maadua, “Mee naa go Ishmael aau e hagamanuuia!” ");
INSERT INTO nkr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Gai de Maadua ga hai ange, “E dee go ia, gai doo bodu go Sarah e haanau adu naa gi de goe dahi dama daane, gai koe ga hagaingoo ange ia go Isaac. Gai au e hai naa dagu hagatoo donu hagaheloongoi madali ia, gai se hagatoo donu hagaheloongoi e deai se ngado mai ange gi dono aamuli i muli mai. ");
INSERT INTO nkr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Gai dagodo o Ishmael, au gu langona dau dangidangi i ono hiidinga. Tilo, au e hagamanuuia naa ia ga hai ia gi hua lagolago, ma de hagadili gi soa. Gai ia e hagadili naa e dinoangahulu ma dogolua dama daane hodooligi, gai au e hai naa ia gi se huaahenua soa. ");
INSERT INTO nkr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Gai au e hai naa dagu hagatoo donu hagaheloongoi madali Isaac, tama a Sarah e haanau adu gi de goe, i de masavaa bee nei i de ngadau e humai nei.” ");
INSERT INTO nkr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Gai ga lava huu olaau pasa, gai de Maadua ga dugu Abraham gai ia ga ahe age gi lunga. ");
INSERT INTO nkr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Gai Abraham ga kave dana dama daane go Ishmael, ma dama daane alodahi ne haanau i dono hale, ma gilaadeu alodahi aana ne hagao, ma daane alodahi i dono hale, ga duuduu dagaholiage i de laangi mau hogi o de Maadua ne basa ange ai laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Gai Abraham gu massiva ma siva ono ngadau i de masavaa oona ne tuu dagaholiage ai. ");
INSERT INTO nkr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Gai Ishmael, dana dama daane gu madaangahulu ma dolu ono ngadau i de masavaa oona ne tuu dagaholiage ai. ");
INSERT INTO nkr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Gai Abraham ma dana dama daane go Ishmael ne tuu dagaholiage ai, de laangi laa donu huu. ");
INSERT INTO nkr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Gai daane alodahi i dono hale, madali gilaadeu ne haanau i dono hale, ma de gau henua gee ne hagao mai laa i daha, ne tuu dagaholiage madali ia. ");
INSERT INTO nkr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Gai Tagi Maolunga ga hakide ange gi Abraham i lalo denga oak o Mamre, i de masavaa oona e noho ai, i ma te haitoga o dono hale malo, i de madohi lua o de laangi. ");
INSERT INTO nkr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Gai Abraham ga dangage age gu gidee adu e ia e dogodolu daane e tuu mai. De masavaa aana ne gidee ai gilaadeu, gai ia ga hidi age ga savini ga hedae ange gi gilaadeu, ga ino gi honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Gai ia ne hai ange, “Dogu dangada aamua, noo koe e abodonu mai gi de au, gai koe gi dee hano gee mai i ogu daha, doo dangada hai hegau. ");
INSERT INTO nkr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Au e dangidangi adu, goodou gi daalia ange gi gaamai hanu momo vai e hhui ai oodou vae, ma de damaa hagammabu iho i lalo de manu somo nei; ");
INSERT INTO nkr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","gai au ga gaamai hanu pelaoaa e hagammahi age ai goodou, gai muli mai gai goodou ga hulo ai, go hiidinga goodou gu tae mai gi daho doodou dangada hai hegau.” Gai gilaadeu ga hai ange, “E danuaa, koe gi haia gi bei au muna.” ");
INSERT INTO nkr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Gai Abraham ne hagamoolau ga hano gi daho Sarah i de hale malo, ga hai ange, “Hagamoolau hagabau ina e dolu hagabaaunga pelaoaa lligi dao ina ai hanu pelaoaa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Gai Abraham ga savini ga hano gi de mommee o denga manu haangai, gai ia ga poo dahi kaau gauligi ma de bedi danuaa ga gaavange gi dahi ono daane hai hegau, gai taane laa ga hagamoolau ga hagadabena de manu laa ga hai gu mmoa. ");
INSERT INTO nkr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gai Abraham ga kave hanu vai uu haduhadu, ma vai uu ma de kaau aana gu hagadabena laa ga gaavange e gaimee ai gilaadeu. Gai ia ga duu i olaadeu gaogao i lalo de manu somo laa, i de masavaa olaadeu e gaimee ai. ");
INSERT INTO nkr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Gai gilaadeu ga ssili ange gi Abraham, “I hee iai doo bodu go Sarah?” Gai ia ga hai ange, “Ia i lo te hale malo.” ");
INSERT INTO nkr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Gai Tagi Maolunga ga hai ange, “Au e ahe mai naa donu gi ooluu daha i de masavaa mau i de ngadau e humai nei. Gai tilo, doo bodu go Sarah e haanau naa dahi dama daane.”  Gai Sarah ne duu ga hagallongo alaadeu muna i gaogao de haitoga o de hale malo i ono dua. ");
INSERT INTO nkr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","De masavaa laa gai Abraham ma Sarah gu madumaatua. Gai Sarah gu ui ono masavaa e hai ai magi o denga haahine. ");
INSERT INTO nkr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Gai Sarah ga gadagada i ono lodo ga hagadaba, “Au gu madumadua, gai dogu dangada aamua gu madumadua hogi; gai e maua huu e gimaau i de hagahebaa?”  ");
INSERT INTO nkr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Gai Tagi Maolunga ga ssili ange gi Abraham, “Gai gu aha Sarah gu gadagada ai laa ma de hagadaba, ‘E maua nei donu e au i de haanau dahi dama, gai au gu madumadua?’ ");
INSERT INTO nkr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","E deai donu se mee daudahi e hai ngadaa i daho Tagi Maolunga! Au e ahe mai naa donu gi ooluu daha i de masavaa gu hagamodu i de ngadau e humai nei, gai Sarah e haanau naa dahi dama daane.”  ");
INSERT INTO nkr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Gai Sarah ga hagassee ga hai ange, “E deai, au tee gadagada donu,” go hiidinga ia gu madagu. Aagai ia ga hai ange, “E deai, koe gu gadagada donu.” ");
INSERT INTO nkr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","De masavaa o denga daane laa ga hiihidi age ai e hulo, gai gilaadeu ne daumada de haiava e hano laa gi Sodom, gai Abraham ne damaa seesee adu madali gilaadeu i honga delaadeu haiava. ");
INSERT INTO nkr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Gai Tagi Maolunga ne hagadaba i ono lodo, “E heohi nei dagu hagammuni i Abraham de hegau aagu ga hai nei? ");
INSERT INTO nkr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham e hai naa ga se huaahenua soa mmao ma de mmahi, gai denga huaahenua alodahi i henua i lalo e manuuia naa i ono hiidinga. ");
INSERT INTO nkr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Gai au gu lava i de hili ia, gai ia e hai naa ana dama ma dangada i dono hale gi daohia de haiava o Tagi Maolunga, ma de hai hegau i de mee heohi ma de hagamodu heohi, gai Tagi Maolunga e gaavange naa gi Abraham mee aana gu hagatoo donu ange ai gi de ia.” ");
INSERT INTO nkr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Gai Tagi Maolunga, ne hai ange, “Muna hagabaubau o Sodom ma Gomorrah gu kona donu de lagolago, gai olaadeu haisala gu kona mmao de hagadaemaha. ");
INSERT INTO nkr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Gai au e hano naa e tilo be alaadeu hegau e bei nei donu dagodo muna hagabaubau gu tae adu gi de au. Aagai noo e deai, gai au e iloo naa donu.” ");
INSERT INTO nkr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Gai luu daane ange laa ne huuhuli e hulo gi Sodom, aagai Abraham goi duu huu i mada i mua o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Gai Abraham ne humai gi baa ange ia gi Tagi Maolunga, ga hai ange, “Koe e daa naa hogi gi magau tangada heohi madali tangada baubau? ");
INSERT INTO nkr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Noo e dinolima donu huu dangada heohi i de aduhale laa? Koe e oha naa de aduhale laa, e dee hagaola de mommee laa, i hiidinga o de gau heohi e dinolima laa? ");
INSERT INTO nkr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","E dee aanei donu dagodo o au hegau e hai — koe e dee daa gi maakau de gau heohi madali de gau baubau, aabe e hai de gau heohi bei dagodo o de gau baubau. E dee aanei donu dagodo o au hegau e hai! E aha, de Ia Hagamodu o henua i lalo alodahi e dee hai naa de mee heohi?” ");
INSERT INTO nkr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Gai Tagi Maolunga ga hai ange, “Noo au e gidee e dinolima dangada heohi i de aduhale o Sodom, gai au e hagaola donu de mommee laa alodahi i olaadeu hiidinga.” ");
INSERT INTO nkr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Gai Abraham ga basa ange hogi, ga hai ange, “Dogu Ia Aamua, aude haihaia, i dagu ahe ange e basa adu gi de goe, e dee galemu donu au e bei dagodo o de mama i honga de gelegele ma lehu; ");
INSERT INTO nkr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","gai noo e dogolima dangada heohi e sogoisi mai ange ai i tinolima? Gai koe e oha huu de aduhale alodahi, i hiidinga e dogolima dangada heohi e sogoisi mai ange ai i tinolima?” Ia ne hai ange, “E deai, au e dee oha donu de aduhale laa, noo au e gidee e dinohaa ma dogolima dangada heohi i kilaa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Gai Abraham ne ahe ange hogi ga ssili, ga hai ange, “Gai noo e dinohaa donu huu aau e gidee i kilaa?” Ia ne hai ange, “Au e dee oha donu de aduhale laa, i hiidinga o tinohaa dangada laa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Gai Abraham ga hai ange, “Dogu Ia Aamua, koe gi dee lili i dagu ahe ange e basa adu. Gai noo e dinodolu donu huu dangada heohi e gidee i kilaa?” Gai ia ga hai ange, “Au e dee oha donu de aduhale laa, noo au e gidee e dinodolu dangada heohi i kilaa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham ne hai ange hogi, “Dogu Ia Aamua, aude haihaia, i dagu ahe ange e basa adu gi de goe. Gai noo e dinolua donu huu dangada heohi e gidee i kilaa?” Gai ia ga hai ange, “Au e dee oha donu de aduhale laa, i hiidinga o tinolua dangada laa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Gai Abraham ne hai ange hogi, “Dogu Ia Aamua, koe gi dee bole, gai au ga ahe ange e basa adu. Noo e dinoangahulu donu huu e gidee i kilaa?” Ia ne hai ange, “Au e dee oha donu de aduhale laa, i hiidinga o tinoangahulu dangada laa.” ");
INSERT INTO nkr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Gai ga lava huu de basa ange o Tagi Maolunga gi Abraham, gai ia ga hano gee mai i kilaa, gai Abraham ne ahe hogi gi dono mommee. ");
INSERT INTO nkr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Gai luu dangada de langi laa ne tae mai gi Sodom i de ahiahi, gai Lot e noho i gaogao de haitoga o de buibui o Sodom. Gai ga gidee huu e Lot gilaau, gai ia ga hidi age ga hano e hedae ange gi gilaau, gai ia ne ino ga baa luoono mada gi honga de gelegele, ");
INSERT INTO nkr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ga hai ange, “Luoogu dangada aamua, au e dangidangi adu, gooluu taa mai gi de hale o dooluu dangada hai hegau, ga nnoho ai aaboo nei. Gai gooluu ga hhui ai ooluu vae ga sseni ai aaboo nei; gai gooluu ga oho age ai ga hulo i boo taiao.” Gai gilaau ga hai ange, “E deai, gimaau e sseni donu huu i duaahaho aaboo nei.” ");
INSERT INTO nkr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aagai ia ne hagammahi ange gilaau, gai gilaau ga hulo ai loo madali ia gi dono hale. Gai Lot ne hai hanu gai e gaimee ai gilaau; ia ne dao hanu pelaoaa dee hagahua, gai luu daane laa ga nnoho ga gaimee. ");
INSERT INTO nkr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aagai i mua delaadeu daakodo iho e sseni, gai denga daane alodahi o de aduhale go Sodom — go denga dama daane ma denga daane maatua — ga loomai ga holiage luu baasi de hale laa. ");
INSERT INTO nkr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Gai gilaadeu ga hagahi a Lot, ga hai ange gi de ia, “I hee iai luu daane ne loomai laa gi doo hale anaboo nei? Hagassao ina mai gilaau, gai gimaadeu ga dagodo haisala ma gilaau.”  ");
INSERT INTO nkr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Gai Lot ga sao gi duaahaho i olaadeu daha, gai ga pono ange de haitoga i ono dua, ");
INSERT INTO nkr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","gai ia ga hai ange, “Ogu daina, au e dangidangi adu, goodou aude haia de hegau baubau nei. ");
INSERT INTO nkr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tilo, e dogolua agu damaa hine tigi hagahebaa ma denga daane; au ga hagassao mai nei gilaau e gaavadu gi goodou, gai goodou ga hai ange gi gilaau, mee alodahi oodou e llodo ai. Aagai goodou aude haia ange hanu mee gi luu daane nei, go hiidinga gilaadeu gu nnoho i lo te buibui o dogu hale.” ");
INSERT INTO nkr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Gai gilaadeu ga hai ange, “Hakii adu i kinaa!” Gai gilaadeu ga hagataba, “Taane nei se daane henua gee ne humai e noho i odaadeu daha, gai iainei ia gu hai go ia e daalaa mai adaadeu mee e hai! Gai e kii ange naa donu de baubau demaadeu hai e hai ai goe i luu daane nei.” Gai gilaadeu ga usu Lot gi daha, gai ga loomai e oha de haitoga o de hale laa. ");
INSERT INTO nkr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Gai luu daane laa ga poo a Lot ga dada mai gi olaau daha i lo te hale, gai ga pono de haitoga. ");
INSERT INTO nkr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Gai gilaau ga hai gu dee kide denga daane i tua de haitoga o de hale, mai i tama daane ga dae ai gi taane madua, gai gilaadeu ne hagammahi ga haahaa saele e ssala de haitoga. ");
INSERT INTO nkr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Gai luu daane laa ga ssili ange gi Lot, “E hanu ange nei oo dangada i kinei — be ni saulaba niiou, aabe ni dama daane be ni damaa hine niiau i lo te aduhale nei? Haia gilaadeu gi ssao gi hulo gee mai i kinei. ");
INSERT INTO nkr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Gimaau gu dai oha naa donu de mommee nei, go hiidinga muna e hagabaubau ai gilaadeu gu lagolago mmao, gai gu tae age donu gi mada luu mada o Tagi Maolunga, gai ia gu hai gimaau gi loomai gi oohaa de aduhale nei.” ");
INSERT INTO nkr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Gai Lot ne sao ange hogi gi duaahaho ga basa ange gi hagababa o luaana damaa hine, ga hai ange, “Gooluu hagamoolau hulo gee mai i de mommee nei, go hiidinga Tagi Maolunga gu dai oha naa de aduhale nei.” Aagai gilaau e maanadu bolo ia e hakadanga ange gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gai ga daiao huu de mee, gai luu dangada de langi laa ga usuusu ange a Lot, ga hai ange, “Hidi age gaavee doo bodu ma luaau damaa hine e nnoho i kinei, goodou kana maakau i de masavaa e hagaduasala ai de aduhale.” ");
INSERT INTO nkr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Gai a Lot e hagamudumudu ana mee, aagai luu daane laa ga poo dono lima ma de lima o dono bodu, aama lima o luaana damaa hine, ga kave gilaadeu gi tua de aduhale, i hiidinga Tagi Maolunga ne abodonu ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Gai ga lava huu i delaau kave gilaadeu gi tua de aduhale, gai dahi gilaau ga hai ange, “Goodou saavini hulo gee gi ola ai goodou! Gai goodou e dee kalo dua donu aabe e nnoho i de mommee e soe! Gai saavini hulo gi denga mounga kana maakau goodou.” ");
INSERT INTO nkr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Gai Lot ga hai ange gi gilaau, “Luoogu dangada aamua, e deai! ");
INSERT INTO nkr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tilo, gooluu gu abodonu mai gi de au, dooluu dangada hai hegau, gai dooluu abodonu mai gi de au, gu laumalie mmao i dooluu hagaola dogu mouli. Aagai au e dee maua i de savini e hano gi denga mounga, kana duu mai de hai ngadaa nei gi de au, ga daa au gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tilo, deenei dahi aduhale e baa mai, e hai ngaohie dogu savini e hano aagena, gai e damaa mee. Dugua mai au gi hano gi kilaa — e aha, e dee se damaa aduhale maasei deelaa? Gai au e ola naa donu.” ");
INSERT INTO nkr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Gai ia ga hai ange gi Lot, “E danuaa, au e dugu adu hogi gi bei dau dangidangi nei; au gu dee oha de aduhale oou e basa ai naa. ");
INSERT INTO nkr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Aagai koe hagamoolau savini gi kilaa, go hiidinga au e dee maua donu i de hai dahi mee daudahi, ga dae ai gi doo dae gi kilaa.” (Deelaa ai, de aduhale laa gu hagaingoo ange go Zoar.) ");
INSERT INTO nkr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Gai de masavaa o Lot ne dae ai gi Zoar gai gu sobo age de laa. ");
INSERT INTO nkr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Gai Tagi Maolunga ga hagamalili iho gi honga o Sodom ma Gomorrah denga maga ahi kaa ma de ahi mai i de langi. ");
INSERT INTO nkr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Gai ia ga oha denga aduhale laa ma mommee alodahi e soe ai de henua aama dangada alodahi e nnoho i denga aduhale laa, aama manu e ssomo i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aagai de bodu o Lot ne huli dua, gai ia gu makaga ga bei dagodo o dahi duludulu soolo. ");
INSERT INTO nkr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Gai Abraham ga oho age i taiao ga hano ga duu i de mommee oona ne duu ai i mada i mua o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Gai ia gu gidee adu de mommee iai Sodom ma Gomorrah aama mommee alodahi e soe ai de henua, gai ia gu gidee hogi de useahi e buu age i de henua, bei dagodo o de useahi o de ahi mmahi laumalie. ");
INSERT INTO nkr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Gai ga lava huu i de oha a de Maadua denga aduhale i de mommee soe, gai de Maadua gu manadua e ia Abraham, gai ia ga hagasao mai Lot i de hai ngadaa ne oohaa laa denga aduhale o Lot nogo noho ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Gai a Lot ga hano gee mai i Zoar ga hano ga noho i de mommee o denga mounga madali luaana damaa hine, go hiidinga ia gu madagu i de noho i Zoar. Gai gilaadeu ma luaana damaa hine ne noho i lo te haonga i gaogao de mounga. ");
INSERT INTO nkr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Gai tamaa hine madua ne hai ange gi tamaa hine gauligi, “Taau damana gu madumadua, gai e deai se daane i henua i lalo odaau e hagahebaa ange aagena, bei dagodo hegau e hai i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Humai, gidaau ga hagaunu gi senga taau damana i uvaini, gai gidaau ga dagodo haisala ma ia, gai gidaau ga hai ai gi dee lilo de aamuli o taau damana.” ");
INSERT INTO nkr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gai gilaau ga hagaunu delaau damana i uvaini i de boo laa, gai tamaa hine madua ne hano ga dagodo haisala ma dono damana. Gai a Lot tee iloo donu e ia de masavaa oona ne dagodo iho ai, aabe go de masavaa oona ne hidi age ai ga hano. ");
INSERT INTO nkr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Taiao age gai tamaa hine madua ne hai ange gi tamaa hine gauligi, “Au ne hano anaboo ga dagodo haisala madali taau damana. Gidaau ga aahe ange e hagaunu ia gi senga i uvaini aaboo nei, gai koe ga hano hogi ga dagodo haisala ma ia, gi maua ai e gidaau i de hai gi dee llilo hagadiilinga o taau damana i ono daha.” ");
INSERT INTO nkr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Gai gilaau ne aahe ange hogi ga hagaunu delaau damana i uvaini i de boo laa, gai tamaa hine gauligi ne hano hogi ga dagodo haisala ma ia. Gai Lot tee iloo donu e ia, de masavaa o tamaa hine laa ne dagodo iho ai, aabe go de masavaa oona ne hidi age ai ga hano. ");
INSERT INTO nkr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Gai luu damaa hine a Lot gu hai tama ange ngaadahi gi delaau damana. ");
INSERT INTO nkr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Gai tamaa hine madua ne haanau dahi dama daane, gai ia ga hagaingoo ange ia go Moab; go ia ne hagadili ina de gau Moab ga dae mai ai gi anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Gai tamaa hine gauligi ne haanau hogi dahi dama daane, gai ia ga hagaingoo ange ia go Ben-Ammi; go ia ne hagadili ina de gau Ammon ga dae mai ai gi anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Gai Abraham ne hano gee mai i kilaa ga hano gi Negev, ga noho i magavaa o Kadesh ma Shur. Gai ia ne noho i Gerar i dahi masavaa, ");
INSERT INTO nkr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","gai Abraham ne tala bolo Sarah se daina hahine niiona. Gai Abimelek, de hodooligi o Gerar, ne aalu mai ga kave Sarah. ");
INSERT INTO nkr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aagai de Maadua ne hakide ange gi Abimelek i de midi, ga hai ange gi de ia, “Tilo, koe e magau donu, i hiidinga o de hine aau gu kave naa; ia se hine gu hai bodu.” ");
INSERT INTO nkr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","De masavaa laa gai Abimelek tigi dagodo haisala ma Sarah. Gai ia ga hai ange, “Dogu Ia Aamua, koe ga daa naa gi maakau dahi huaadangada tigi haisala? ");
INSERT INTO nkr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","E aha, ia tee hai mai laa bolo de hine nei se daina niiona? Gai de hine nei ne hai mai hogi, ‘Ia go dogu daina daane’? Gai au ne hai de hegau nei i de gilimalali tagi, gai luoogu lima e gilimalali hogi.” ");
INSERT INTO nkr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Gai de Maadua ne hai ange gi de ia i de midi, “Au e iloo bolo koe ne hai de hegau nei i de gilimalali tagi o oo lodo. Gai au ne buibui goe gi dee haisala mai gi de au. Deenei ai, au tee dugu adu goe gi poo ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Gai koe hagaahea ange de bodu o taane naa, go hiidinga ia se pelaabisi, gai ia ga dalodalo ai i de goe, gi dee magau ai goe. Aagai noo koe e dee hagaahe ange dono bodu, gai koe gi iloo bolo goodou ma dangada alodahi i doo hale e maakau donu.” ");
INSERT INTO nkr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Gai Abimelek ne oho age i taiao ga hagahi ono dangada hai hegau alodahi, ga tala ange gi gilaadeu mee alodahi gu hai; gai denga daane laa gu kona donu de maatagu. ");
INSERT INTO nkr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Gai Abimelek ga hagahi Abraham, ga hai ange gi de ia, “Se hegau bee hee aau gu hai mai nei gi gimaadeu? Gai se baubau aha aagu gu hai adu gi de goe, gai koe ga hai ai nei gi doo ange au ma dogu nohoanga hodooligi, gi lo te baubau laumalie nei? De hegau aau gu hai mai nei gi de au e dee se hegau danuaa.” ");
INSERT INTO nkr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Gai Abimelek ga hai ange gi Abraham, “Aahee hiidinga aau ne hai ai nei de hegau nei?” ");
INSERT INTO nkr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Gai Abraham ga hai ange, “Go hiidinga au ne maanadu i ogu lodo, ‘Dangada i de mommee nei e dee maatagu donu i de Maadua, gilaadeu e daa naa au ga magau, i hiidinga o dogu bodu.’ ");
INSERT INTO nkr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Gai ni muna abodonu, ia se daina donu niiogu, gimaau se damana daudahi omaau, aagai ni dinana geegee; gai ia ne hai bodu mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Gai de masavaa huu a de Maadua ne hai ai au gi hano gee mai i de hale o dogu damana, gai au ga hai ange gi de ia, ‘Deenei doo hai e abodonu mai ai gi de au: mommee alodahi odaau e hulo aagena, gai koe hagadaba, “Ia se daina daane niiogu.” ’ ” ");
INSERT INTO nkr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Gai Abimelek ga gaavange hanu ssiibi, ma hanu kaau, ma daane ma haahine hai hegau gi Abraham, ma de hagaahe ange gi de ia Sarah, dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Gai Abimelek ga hai ange gi de ia, “Au e hhuge adu gi de goe dogu henua alodahi; gai koe ga noho i de mommee oou e lodo e noho ai.” ");
INSERT INTO nkr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Gai ia ne hai ange hogi gi Sarah, “Au gu gaavange e mano dibaa selevaa gi doo daina daane, ni mee e hagaago ange gi dangada bolo koe tee haisala donu; teai hogi au mee dee heohi ne hai.” ");
INSERT INTO nkr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Gai Abraham ga dalodalo i Abimelek, gai de Maadua ga hagaieiangi Abimelek ma dono bodu ma ono haahine hai hegau, gai gilaadeu gu aahe ange gu haanau; ");
INSERT INTO nkr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","go hiidinga Tagi Maolunga ne buibui denga haahine alodahi i de hale o Abimelek gi dee haanau, i hiidinga o Sarah, de bodu o Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Gai Tagi Maolunga ne abodonu ange gi Sarah, ia ne hagasula donu dana hagatoo donu ange gi Sarah. ");
INSERT INTO nkr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Gai Sarah gu hai dama, gai ia gu haanau ange gi Abraham dahi dama daane i de masavaa oona gu madumadua ai, gai ne hai i de masavaa gu lava laa i de hagailonga, bei dagodo muna a de Maadua ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Gai Abraham ga hagaingoo ange dana dama ne hagadili go Isaac, deenei tama daane a Sarah ne haanau ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Gai Abraham ga tuu dagaholiage Isaac, dana dama daane i dua de valu laangi, bei de hai a de Maadua gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Gai Abraham gu lau ono ngadau i de masavaa o dana dama daane go Isaac ne haanau ai. ");
INSERT INTO nkr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Gai Sarah ga hagadaba, “De Maadua gu hai au gi gadagada i dogu malangilangi; deenei ai, gilaadeu alodahi e langona de mee nei e kada naa madali au.” ");
INSERT INTO nkr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Gai ia ne hagadaba, “E aha, ne maua e dahi dangada i de hai ange gi Abraham bolo au e hakaa unuunu naa hanu gauligi? Aagai au gu haanau ange gi de ia dahi dama daane i de masavaa oogu gu madumadua ai.” ");
INSERT INTO nkr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Gai ga madua huu de gauligi laa, gu dee unuunu, gai Abraham ga hai dahi daonga laumalie i de laangi o Isaac ne hai ai gi dee unuunu. ");
INSERT INTO nkr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Aagai Sarah ne gidee bolo tama daane a Hagar, de hine Egypt, go tama aana ne haanau ange gi Abraham, e hagammae manava Isaac, ");
INSERT INTO nkr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","gai Sarah ga hai ange gi Abraham, “Haia gi hano de hine hai hegau naa ma dana dama daane, go hiidinga tama daane a de hine hai hegau naa e dee bolo donu madali dagu dama go Isaac.”  ");
INSERT INTO nkr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Gai Abraham gu kona mmao tee baba ono lodo, i hiidinga o dana dama go Ishmael. ");
INSERT INTO nkr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Gai de Maadua ga hai ange gi Abraham, “Aude manavasaa i hiidinga o tama naa, aama hiidinga o doo hahine hai hegau. Gai be se aha naa huu a Sarah e hai adu koe gi haia, gai koe haia gi bei, go hiidinga go daho Isaac e hagadili ai doo aamuli. ");
INSERT INTO nkr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Gai au e hai naa tama daane a doo hahine hai hegau gi se huaahenua soa, go hiidinga ia se dama niiau.” ");
INSERT INTO nkr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Gai Abraham ga oho age i taiao ga hagadabena hanu gai, ma dahi gili manu e hhao ai vai, ga hagauda ange gi honga de eu o Hagar madali dana dama, ga hai ia gi hano gee. Gai Hagar ga hano ga silivaahea saele i de vao o Beersheba. ");
INSERT INTO nkr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Gai ga odi huu vai i lo te gili manu laa, gai Hagar ga hagadagodo tama laa i lalo dahi manu somo baa i lalo, ");
INSERT INTO nkr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","gai ia ga hano ga noho i de mommee mmao bei de mmao o tao e tili laa i de mee hholu, go hiidinga ia ne hagadaba, “Au e dee lodo gi gidee e au de magau o dagu dama.” Gai ia ga hano ga nnoho i de mommee laa ga dangi ai. ");
INSERT INTO nkr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gai de Maadua gu langona de leo o tama daane laa, gai tangada de langi o de Maadua ga basa ange gi Hagar mai i de langi, ga hai ange gi de ia, “Gu aha naa goe e Hagar? Aude madagu, go hiidinga de Maadua gu langona de leo o tama i de mommee oona iai. ");
INSERT INTO nkr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hannoo sabaia age dau dama mage boogia dono lima, go hiidinga au e hai naa ia gi se huaahenua soa mmao.” ");
INSERT INTO nkr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Gai de Maadua ga hai ia gi gidee dahi vai geli, gai ia ga hano ga hhao ange hanu vai gi lo tana gili manu ga hagaunu ai tama laa. ");
INSERT INTO nkr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Gai de Maadua ne noho i daho tama laa, gai ia ne madua age i lodo henua, gu se daane dau i de dili manu. ");
INSERT INTO nkr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Gai ia ne noho i de vao o Paran. Gai dono dinana ga gaamai dahi bodu moona mai i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Gai laangi laa gai Abimelek ma Phicol, tagi o ono daane hebagi, ne loomai ga hai ange gi Abraham, “De Maadua gu hagamanuuia goe i mee alodahi aau e hai. ");
INSERT INTO nkr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Gai koe haia mai dahi hagatoo donu gi de au, i kinei i de ingoo o de Maadua, bolo koe e dee hai hegau baubau mai gi de au, ma agu dama aama dogu hagadiilinga. Gai koe abodonu mai gi de au ma de henua oou e noho gaainga ai nei, bei dagu hai gu abodonu ai hogi gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ne hai ange, “Au e hagatoo donu.” ");
INSERT INTO nkr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Gai Abraham ne hagasee Abimelek, i hiidinga o dahi vai geli a de gau hai hegau o Abimelek gu kave laa. ");
INSERT INTO nkr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Gai Abimelek ga hai ange, “Au e dee iloo be goai ne haia de hegau nei. Gai koe tee tala mai hogi gi de au i mua, gai au tigi langona donu hogi mee nei i mua, go anailaa nei donu huu aagu ne langona ai.” ");
INSERT INTO nkr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Gai Abraham ne kave hanu ssiibi ma hanu kaau ga gaavange gi Abimelek, gai gilaau ga hai dahi hagatoo donu hagaheloongoi i olaau magavaa. ");
INSERT INTO nkr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Gai Abraham ne vvae gee e hidu ssiibi haahine mai i dana hagabuulingaa ssiibi, ");
INSERT INTO nkr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","gai Abimelek ga ssili ange gi Abraham, “Dee hee de hagadoonunga o denga ssiibi haahine aau gu vvae nei?” ");
INSERT INTO nkr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham ne hai ange, “Gaavee denga ssiibi haahine e hidu nei mai i ogu daha e hagadonu ai bolo go au ne gelia de vai nei.” ");
INSERT INTO nkr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Deelaa ai, de mommee laa gu hagaingoo ange go Beersheba, go hiidinga gilaau ne hai ai dahi hagatoo donu i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Gai dua huu de hai de hagatoo donu hagaheloongoi laa i Beersheba, gai Abimelek ma Phicol, tagi o ono daane hebagi, ga aahe gi de henua o de gau Philistia. ");
INSERT INTO nkr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Gai Abraham ga doo dahi tamarisk i Beersheba, gai ia ga dalodalo ange gi Tagi Maolunga, de Maadua e mouli laa ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Gai Abraham ne noho i de henua o de gau Philistia i dahi masavaa daulooloa. ");
INSERT INTO nkr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Dua mee nei, gai de Maadua ne hagatale de gai o Abraham. Gai ia ga hai ange gi de ia, “Abraham!”  Abraham ne hai ange, “Deenei au.” ");
INSERT INTO nkr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Gai de Maadua ga hai ange, “Gaavee dau dama dagidahi go Isaac, go tama oou e aloha ai, ma gi hano gi de mommee go Moriah. Gai koe ga daa ia ga hai ai dahi sigidaumaha dudu, i honga de mounga aagu e hagaago adu gi de goe.”  ");
INSERT INTO nkr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Gai Abraham ne oho age i taiao ga hagauda ange mee gi honga dana donkey. Gai ia ne kave madali ia e dogolua ono daane hai hegau, aama dana dama daane go Isaac. Gai ia ne duuduu hanu lahhie e hai ai ssigidaumaha dudu, gai gilaadeu ne seesee ga hulo gi de mommee, a de Maadua gu hagaago ange laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Gai de hagadolu laangi huu, gai Abraham ga dangage gu gidee adu e ia de mommee laa. ");
INSERT INTO nkr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Gai Abraham ga hai ange gi luoono daane hai hegau, “Gooluu nnoho i kinei madali taadeu donkey, gai gimaau ma dagu dama ga hulo gi kilaa e daumaha ai, ga ahe mai ai.” ");
INSERT INTO nkr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Gai Abraham ne kave denga lahhie e hai ai ssigidaumaha dudu, ga hagauda ange gi honga o dana dama go Isaac. Gai ia ne dagidagi de ahi ma de naivi, ga seesee ai gilaau ga hulo. ");
INSERT INTO nkr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Gai Isaac ne hai ange gi Abraham, “Dogu damana.” Abraham ne hai ange, “Deenei au e dagu dama.” Isaac ne hai ange, “Gu dahi ahi ma lahhie, aagai i hee iai ssiibi gauligi e hai ai ssigidaumaha dudu?” ");
INSERT INTO nkr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham ne hai ange, “Dagu dama, go de Maadua e gaamai ssiibi gauligi e hai ai ssigidaumaha dudu.” Gai gilaau ga seesee ai loo ga hulo. ");
INSERT INTO nkr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Gai ga tae huu gilaau gi de mommee a de Maadua gu hagaago ange laa gi de ia, gai Abraham ga bae de mommee o ssigidaumaha, ga hagatau ange denga lahhie gi ono elunga, gai ia ga nnoa dana dama go Isaac, ga dugu ange gi honga denga lahhie i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Gai ia ga poo mai de naivi e velo ai dana dama daane gi magau. ");
INSERT INTO nkr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Aagai tangada de langi o Tagi Maolunga ga hagahi mai ia i de langi, ga hai ange, “Abraham! Abraham!” Gai ia ga hai ange, “Deenei au.” ");
INSERT INTO nkr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tangada de langi laa ne hai ange, “Aude poo ange gi tama daane naa, aabe gi haia ange dahi mee gi de ia. Iainei gai au gu iloo bolo koe e madagu i de Maadua, go hiidinga koe tee daohi donu dau dama dagidahi i de au.” ");
INSERT INTO nkr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Gai Abraham gu gidee adu e ia dahi ssiibi daane gu llave luoono hanga i lodo mee muimui, gai Abraham ga hano ga gaamai ssiibi daane laa, ga hai ai ssigidaumaha dudu, tee hai ssigidaumaha i dana dama. ");
INSERT INTO nkr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Gai Abraham ga hagaingoo ange de mommee laa go Iahweh Jireh, bei de hai gu tala ai laa ga dae mai ai gi anailaa nei, “Tagi Maolunga e gaamai i honga dono mounga.” ");
INSERT INTO nkr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Gai tangada de langi o Tagi Maolunga ga hagaagahi mai Abraham i de langi i de lua hanonga, ");
INSERT INTO nkr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ga hai ange, “E hagadaba Tagi Maolunga: Au e hagatoo donu i dogu ingoo, go hiidinga koe gu hai de hegau nei, koe tee daohi donu dau dama dagidahi, ");
INSERT INTO nkr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","deelaa ai, au e hagamanuuia naa donu goe, ga hai gi soa oo hagadiilinga, bei de lagolago o denga heduu i lo te langi, ma de lagolago o denga gelegele i gaogao tai. Gai oo hagadiilinga e kave naa denga aduhale o olaadeu hagadaumee. ");
INSERT INTO nkr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Gai denga huaahenua alodahi o henua i lalo e manuuia naa i hiidinga o doo hagadiilinga, go hiidinga koe ne daudali i agu muna.”  ");
INSERT INTO nkr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Gai Abraham ga ahe gi daho luoono daane hai hegau, gai gilaadeu alodahi ga aahe gi Beersheba, gai Abraham ne noho i Beersheba. ");
INSERT INTO nkr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Gai dua huu mee nei, gai Abraham gu langona hanu dangada e hagataba, “Tilo, Milcah gu haanau ange hogi hanu dama gi doo daina daane go Nahor: ");
INSERT INTO nkr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","dana dama daane madua go Uz, gai ono daina go Buz, ma Kemuel, tubuna o de gau Syria, ");
INSERT INTO nkr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ma Kesed, ma Hazo, ma Pildash, ma Jidlaph, aama Bethuel.” ");
INSERT INTO nkr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Gai Bethuel ne hagadili Rebekah. Aanei dama dogovalu a Milcah ne haanau ange gi Nahor, taina daane o Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Gai dono bodu laa daha e hagaingoo ange laa go Reumah ne haanau ange hogi gi de ia Tebah, ma Gaham, ma Tahash, aama Maacah. ");
INSERT INTO nkr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah ne 127 ono ngadau ne mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Gai ia ne magau i Kiriath Arba (e bei, go Hebron) i de henua go Canaan. Gai Abraham ne hano e hinangalosaa, ma de dangi i dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Gai Abraham ga hano gee mai i de mommee iai laa de angaanga o Sarah, ga hano ga basa ange gi de gau Heth, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au se dangada henua gee e noho gaainga i oodou daha, gai goodou gaamai dahi mommee i oodou daha e hai ai dahi mommee e hai ai agu daanunga, gai au ga kave dagu magau e danu ai.”  ");
INSERT INTO nkr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Gai de gau Heth ga pasa ange gi Abraham, ga hai ange gi de ia, ");
INSERT INTO nkr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Taane hagadubu, hagalaangona muhuu amaadeu muna, koe se daane hagadubu i omaadeu magavaa. Gaavee dau dangada magau mage danumia i lodo amaadeu daanunga danuaa alodahi. Gai e deai naa donu se dangada i omaadeu magavaa e buibuia goe i de danu dau magau i dana daanunga.” ");
INSERT INTO nkr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Gai Abraham ga hidi age ga ino gi lalo i mada i mua o dangada o de henua laa, go de gau Heth, ");
INSERT INTO nkr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","gai ia ga basa ange, ga hai ange gi gilaadeu, “Noo goodou e llodo au gi danumia dagu magau i oodou daha, gai goodou hagalangona agu muna, goodou hulo pasa ange gi Ephron, tama a Zohar i ogu hiidinga, ");
INSERT INTO nkr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ia gi gaamai gi de au de haonga i Machpelah, go de mommee i de bido o dono alahenua. Gai au ga hagao de mommee laa i oodou madamada i kinei e hai ai dagu daanunga.” ");
INSERT INTO nkr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Gai taane go Ephron e noho donu i magavaa o dangada i kilaa, gai Ephron, taane mai i de aamuli o Heth ga basa ange, ga hai ange gi Abraham i madamada o de gau Heth, gu nnoho laa i gaogao de haitoga o de aduhale, ");
INSERT INTO nkr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“E deai, e dogu dangada aamua, gai koe hagalaangona muhuu agu muna; e dee hagao donu, gai au e gaavadu gi de goe de alahenua ma de haonga iai naa, i madamada o ogu dangada, gai koe ga danu ai dau magau.” ");
INSERT INTO nkr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Gai Abraham ne ahe ange hogi ga ino gi lalo i mada i mua o dangada o de henua laa, ");
INSERT INTO nkr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ga hai ange gi Ephron i madamada o dangada o de henua laa, “Noo e heohi mai i oo daha gai koe hagalaangona agu muna; gaavee de sseene aagu e gaavadu gi de goe e hagao ai de alahenua naa, gai au ga danu ai dagu magau i kilaa.” ");
INSERT INTO nkr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron ne basa ange gi Abraham, ga hai ange gi de ia, ");
INSERT INTO nkr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Dogu dangada aamua, de hagaoanga o de alahenua naa se haalau shekel selevaa, gai ni aha adaau e hai i mee naa? Hannoo danumia dau magau.” ");
INSERT INTO nkr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Gai Abraham gu buni ange gi taelodo a Ephron gu tala ange gi de ia, gai Abraham ga hagahidi taelodo o selevaa laa ga hagao ange ai Ephron i madamada o dangada o de aamuli o Heth, se haalau shekel selevaa laa, gai ne hagahidi i de hagabaaunga e hai hegau ai i de masavaa laa. ");
INSERT INTO nkr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Gai de alahenua o Ephron i Machpelah, se mommee i de baasi ange gi Mamre, go de alahenua laa alodahi ma de haonga i gaogao o tuuduu i kilaa, aama denga manu ssomo alodahi, ");
INSERT INTO nkr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","gu gaavange gi Abraham gi hagao ina i madamada o de gau Heth, aama gilaadeu alodahi ne loomai laa gi de haitoga o de aduhale. ");
INSERT INTO nkr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Gai muli mee nei, gai Abraham ga danu dono bodu go Sarah i lo te haonga i honga de alahenua i Machpelah, i de bido gi ngaiho o Mamre (e bei go Hebron), i de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Gai de alahenua aama de haonga i ono elunga laa gu gaavange gi Abraham mai i daho de gau Heth e hai ai de mommee o ana daanunga. ");
INSERT INTO nkr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","De masavaa laa gai Abraham gu madumadua, gai gu lagolago ono ngadau ne mouli ai, gai Tagi Maolunga gu hagamanuuia ia i mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Gai Abraham ne hai ange gi dono daane hai hegau hugadoo e madua, go taane e diiloo ange ana mee alodahi, “Dugua ange doo lima gi lalo dogu bido i lalo, ");
INSERT INTO nkr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","gai koe ga hagatoo donu mai gi de au, i de ingoo o Tagi Maolunga, de Maadua o de langi ma henua i lalo, bolo koe e dee kave donu dahi bodu moo dagu dama, mai i denga damaa hine a de gau Canaan, go dangada oogu e noho nei i olaadeu magavaa, ");
INSERT INTO nkr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","aagai koe hannoo gi dogu henua ma daho ogu dangada, ga gaamai ai de bodu o dagu dama go Isaac.” ");
INSERT INTO nkr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Gai dono daane hai hegau ga ssili ange gi de ia, “Gai noo tamaa hine laa e dee lodo e humai madali au gi de henua nei; gai koe e dugu mai au gi hagaahea dau dama daane gi de henua oou ne humai ai laa?” ");
INSERT INTO nkr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Gai Abraham ga hai ange gi de ia, “Aude hagaahea donu dagu dama daane gi de henua laa! ");
INSERT INTO nkr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tagi Maolunga, go de Maadua o de langi, ne gaavee gee nei au mai i de hale o dogu damana aama dogu henua donu, ne basa mai gi de au ma de hagatoo donu mai, ga hai mai, ‘Au e gaavange naa gi doo aamuli de henua nei’ — ia e hai naa dono dangada de langi gi hano i oo mada i mua, gai koe ga gaamai ai de bodu o dagu dama daane i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Gai noo de hine laa e dee lodo e humai madali goe, gai koe gu deai oo sala i dagu hagatoo donu nei. Aagai koe diiloo gi dee hagaahea e goe dagu dama daane gi de henua laa.” ");
INSERT INTO nkr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Gai tangada hai hegau laa ga dugu ange dono lima gi lalo de bido i lalo o dono dangada aamua go Abraham, ga hagatoo donu ange gi de ia i de mee nei. ");
INSERT INTO nkr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Gai taane hai hegau laa ne kave e madaangahulu gamelo a dono dangada aamua, gai ia ga kave madali ia denga hagadaagangaa mee danuaa alodahi mai i goloa o dono dangada aamua. Gai ia ga hano gu dae gi Mesopotamia, ga hano gi de aduhale o Nahor e noho ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Gai ia ne hai denga gamelo gi dogoduli i tua de aduhale, i gaogao dahi vai i de ahiahi, gai go de masavaa a denga haahine e loomai ai e asu vai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Gai ia ga dalodalo ga hagadaba, “Tagi Maolunga, de Maadua o dogu dangada aamua go Abraham, au e dangidangi adu, haia gi ssula danuaa dagu hegau ailaa nei, gai abodonu ange gi dogu dangada aamua go Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tilo, au e hano naa e duu i gaogao de vai, i de masavaa o denga damaa hine a dangada o de aduhale e loomai naa e asu vai. ");
INSERT INTO nkr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Gai tamaa hine naa huu aagu e hai ange, ‘Aude haihaia dugua iho dau ssaa vai e unu ai au,’ gai ia gi hai mai gi de au, ‘Unu, gai au e hagaunu naa hogi au gamelo’ — gai gi go ia aau gu hili e hai ai de bodu o Isaac. Deenei dagu hai e iloo ai bolo koe gu abodonu ange gi dogu dangada aamua.” ");
INSERT INTO nkr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Gai i mua de hagalava o dana dalodalo, gai ia gu gidee adu Rebekah e saabai mai dana ssaa, i honga dono eu ma e humai ai. Ia se damaa hine nii Bethuel tama daane a Nahor ma Milcah, dono bodu, gai Nahor go taina daane o Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Gai tamaa hine laa e kona donu de mahamaha, gai se bua moe; tigi ai se daane ne hagahebaa ma ia. Gai ia ne humai ga hano iho gi de vai ga hhao ai dana ssaa ga lava ga aahe age. ");
INSERT INTO nkr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Gai tangada hai hegau laa ne savini ga hedae ange gi de ia, ga hai ange, “Au e dangidangi adu, gaamai hanu momo vai i lo tau ssaa e unu au.” ");
INSERT INTO nkr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Gai Rebekah ga hai ange, “Dogu dangada aamua, unu.” Gai ia ga hagamoolau ga dugu iho dana ssaa ga daohi ange e unu ai taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Gai ga lava huu i dana hagaunu taane laa, gai ia ga hai ange, “Au e asu naa hogi hanu vai e hagaunu ai au gamelo, ga dae ai gi delaadeu boobosu.” ");
INSERT INTO nkr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Gai tamaa hine laa ga hagamoolau ga llingi ange vai i lo tana ssaa, gi lo te mommee unu o denga manu, gai ia ga savini ga ahe gi de vai ga asu mai ange ai hanu vai, e hagaunu ai denga gamelo a taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Gai taane laa tee basa ange donu gi de ia, gai ne duu donu huu ga haaina ia, ga maanadu be deenei de hai a Tagi Maolunga e hagasula ai dana hegau ne humai ai laa aabe deai. ");
INSERT INTO nkr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gai ga odi huu i dana hagaunu denga gamelo laa, gai taane laa ga dada age dahi hakai usu goolo, taemaha o de hakai laa se dahi beka, ma e lua mee gubu lima goolo, taemaha o luu mee laa se madaangahulu shekel. ");
INSERT INTO nkr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Gai ia ga ssili ange gi tamaa hine laa, “Koe se damaa hine niiai? Aude haihaia, daalaa mai be e dahi mommee i de hale o doo damana e nnoho ai gimaadeu aaboo nei?” ");
INSERT INTO nkr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Gai tamaa hine laa ga hai ange, “Au se damaa hine nii Bethuel, go tama daane a Milcah ne haanau ange gi Nahor.” ");
INSERT INTO nkr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Gai ia ga hai ange gi taane laa, “E lagolago donu helii mmasa ma mee e haangai manu i demaadeu hale, aama mommee e seni ai goe.” ");
INSERT INTO nkr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Gai taane laa ga ino gi lalo ga daumaha ange gi Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ga hagadaba, “Duuhia Tagi Maolunga, go de Maadua o dogu dangada aamua go Abraham. Ia tee ngalo donu dono abodonu, ma de hai hegau i de mee abodonu ange gi dogu dangada aamua. Tagi Maolunga gu dagi mai donu au gi de hale o dangada o dogu dangada aamua.” ");
INSERT INTO nkr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Gai tamaa hine laa ne savini ga hano ga tala ange mee gu hai laa, gi dangada i de hale o dono dinana. ");
INSERT INTO nkr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Gai Rebekah e dahi ono daina daane, dono ingoo go Laban; ia ne savini ga hano gi daho taane laa i gaogao de vai. ");
INSERT INTO nkr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","De masavaa aana ne gidee ai de hakai usu, ma mee gubu lima i luu lima o dono daina hahine, ma de langona muna a taane laa gu tala ange gi dono daina hahine go Rebekah, gai ia ga hano e hedae ange gi taane laa; gai ia gu gidee ia e duu madali ana gamelo i gaogao de vai. ");
INSERT INTO nkr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Gai ia ga hai ange, “Humai, koe se dangada gu hagamanuuia i daho Tagi Maolunga. Gai gu aha gu duu ai naa goe i tua de aduhale? Au gu hagadabena dahi mommee moou i de hale, ma dahi mommee moo denga gamelo.” ");
INSERT INTO nkr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Gai taane laa ne hano gi de hale, gai a Laban ga dugu iho goloa a denga gamelo e hagauda laa, gai ia ga gaavange helii ma gai a denga gamelo, aama vai e hhui ai luu vae o tangada laa aama denga daane madali ia. ");
INSERT INTO nkr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Gai de masavaa huu ne gaamai ai denga gai ga dugu ange gi mada i mua o taane laa, gai ia ga hai ange, “Au e dee maua i de gaimee ga dae ai gi dagu tala adu dagodo o de hegau oogu ne humai ai nei.” Laban ne hai ange, “Daalaa mai au muna.” ");
INSERT INTO nkr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Gai ia ga hai ange, “Go au tangada hai hegau o Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tagi Maolunga gu hagamanuuia mmao dogu dangada aamua, ma gu hai ia gi se dangada maolunga. Gai ia gu gaavange gi de ia denga ssiibi, ma kaau, ma selevaa, ma goolo, ma daane ma haahine hai hegau, ma gamelo aama donkey. ");
INSERT INTO nkr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Gai Sarah, de bodu o dogu dangada aamua, gu haanau ange gi de ia dahi dama daane i de masavaa oona gu madumadua ai, gai dogu dangada aamua gu dugu ange ana mee alodahi gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Gai dogu dangada aamua ne hai au gi hagatoo donu gi hagadaba, ‘Aude gaavee donu dahi bodu moo dagu dama daane mai i magavaa o denga damaa hine a de gau Canaan, go dangada o de henua oogu e noho ai nei. ");
INSERT INTO nkr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Aagai koe gi hannoo gi daho ogu dangada, ma daho dogu huaabodu mage saalaa ai de bodu o dagu dama daane.’ ");
INSERT INTO nkr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Gai au ne ssili ange gi dogu dangada aamua, ‘Gai noo tamaa hine laa e dee lodo e humai madali au?’ ");
INSERT INTO nkr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Gai ia ne hai mai gi de au, ‘Tagi Maolunga, de ia oogu e seesee i mada luoono mada, e hai naa gi hano dono dangada de langi i oo mada i mua, gai ia ga hai gi sula danuaa doo hanonga; gai koe ga gaamai ai de bodu o dagu dama daane i daho ogu dangada ma dogu huaabodu. ");
INSERT INTO nkr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Gai noo koe e hano gi daho dogu huaabodu, gai gilaadeu e dee llodo e dugu adu tamaa hine laa gi de goe, gai gu dee haisala i dagu hagatoo donu nei.’ ");
INSERT INTO nkr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","De masavaa oogu ne dae mai ai gi de vai anailaa nei, gai au ne dalodalo, ga hai ange, ‘Tagi Maolunga, de Maadua o dogu dangada aamua go Abraham, aude haihaia, haia gi sula danuaa dogu hanonga ne humai ai nei. ");
INSERT INTO nkr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tilo, au e duu naa i gaogao de vai nei, gai be goai naa huu tamaa hine e humai e asu vai, gai au ga hai ange gi de ia, “Aude haihaia gaamai hanu momo vai i lo tau ssaa e unu au,” ");
INSERT INTO nkr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","gai ia ne hai mai gi de au, “Unu, gai au ga asu hogi hanu vai e hagaunu ange ai au gamelo,” gai go ia tamaa hine donu a Tagi Maolunga gu hili, e hai ai de bodu o tama daane a dogu dangada aamua.’ ");
INSERT INTO nkr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Gai i mua de lava dagu hai talodalo nei i ogu lodo, gai tilo, Rebekah gu hagauda adu dana ssaa i honga dono eu ma e hanadu ai. Gai ia ne hano iho gi lo te vai ga asu age ai ana vai, gai au ne hai ange gi de ia, ‘Au e dangidangi adu, gaamai hanu au vai e unu au.’ ");
INSERT INTO nkr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Gai ia ga hagamoolau ga dugu iho dana ssaa e hagauda laa i honga dono eu, ga hai mai, ‘Unu, gai au ga hagaunu ange hogi au gamelo.’ Deelaa ai, au ne unu gu bosu, gai ia ga hagaunu ange hogi agu gamelo. ");
INSERT INTO nkr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Gai au ga ssili ange gi de ia, ‘Koe se damaa hine niiai?’ Gai ia ne hai mai, ‘Au se damaa hine nii Bethuel, tama daane a Nahor ma Milcah.’ Gai au ga ulumagi ange dahi buulei gi dono usu ma hanu mee gubu lima gi luoono lima. ");
INSERT INTO nkr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Gai au ne ino gi lalo ga daumaha ange gi Tagi Maolunga, ma de tuhi Tagi Maolunga, de Maadua o dogu dangada aamua go Abraham, i dana dagi mai au i de haiava heohi, gai au ga kave ai tamaa hine a taina daane o dogu dangada aamua, e hai ai de bodu o dana dama daane. ");
INSERT INTO nkr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Deenei ai, noo goodou e abodonu aama de hai hegau i de muna abodonu ange gi dogu dangada aamua, gai goodou daalaa mai, gi iloo ai e au be goodou e uaa mai aabe deai; gai au gu iloo be ni aha aagu ga hai.” ");
INSERT INTO nkr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Gai a Laban ma Bethuel ga pasa ange, ga hai ange, “De mee nei se mee mai i daho Tagi Maolunga, gai e deai ange donu amaau muna e maua i de tala adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Gai deenaa Rebekah, gaavee ia e hulo ai gooluu, gai ia ga hai bodu ange ai gi tama daane a doo dangada aamua, bei dagodo muna a Tagi Maolunga laa.” ");
INSERT INTO nkr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Gai ga langona huu e taane hai hegau o Abraham alaau muna, gai ia ga ino gi honga de gelegele ga daumaha ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Gai ia ga dada age mee dau e hai i selevaa ma goolo, aama malo ga gaavange gi Rebekah, gai ia ne gaavange hogi hanu goloa hagamogomogo gi taina daane o Rebekah aama dono dinana. ");
INSERT INTO nkr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Gai tangada hai hegau laa ma denga daane madali ia ga gaimee ma de unu, aama de sseni i kilaa. Taiao age huu, gai taane laa ga hai ange, “Dugua mai au gi ahe gi daho dogu dangada aamua.” ");
INSERT INTO nkr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Gai taina daane o Rebekah ma dono dinana ga hai ange, “Dugua tamaa hine nei gi damaa noho ange i omaadeu daha i e madaangahulu duumaa laangi; gai muli mai gai ia ga hano ai.” ");
INSERT INTO nkr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Aagai ia ga hai ange gi gilaadeu, “Goodou aude daohia au, go hiidinga Tagi Maolunga gu hai ma gu sula danuaa dogu hanonga nei. Deenei ai, au ga ahe nei gi daho dogu dangada aamua.” ");
INSERT INTO nkr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Gai gilaadeu ga hai ange, “Gidaadeu e hagahi naa tamaa hine laa e ssili ange be aahee ono lodo.” ");
INSERT INTO nkr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Gai gilaadeu ga hagahi Rebekah, ga ssili ange gi de ia, “Koe e hano madali taane nei?” Gai ia ga hai ange, “Au e hano.” ");
INSERT INTO nkr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Gai gilaadeu ga dugu Rebekah delaadeu daina ma dono hahine hai hegau gi hulo madali taane hai hegau o Abraham, aama ono daane. ");
INSERT INTO nkr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Gai gilaadeu ne hagamanuuia Rebekah, ga hai ange gi de ia, “Demaadeu daina, koe gi hagadili gi dagisemada dama; oo hagadiilinga gi henua i aduhale o olaadeu hagadaumee.” ");
INSERT INTO nkr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Gai Rebekah ma ono haahine hai hegau ga kage i honga denga gamelo, ga hulo madali taane laa. Gai taane hai hegau laa ga kave Rebekah ga hulo ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Gai Isaac ne humai i Beer Lahai Roi ga hano ga noho i de Negev. ");
INSERT INTO nkr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Dahi ahiahi gai ia ne hano ga seesee i de mommee iai helii; gai ia gu gidee adu hanu gamelo e loomai. ");
INSERT INTO nkr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah ne gidee adu hogi e ia Isaac, gai ia ga iho mai i honga de gamelo, ");
INSERT INTO nkr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ga ssili ange gi taane hai hegau laa, “Goai taane e seesee mai nei e hedae mai gi gidaadeu?” Gai taane hai hegau laa ga hai ange, “Deenaa donu dogu dangada aamua.” Gai Rebekah ga hai dono malo daballahi ga haoli ai luoono mada. ");
INSERT INTO nkr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Gai taane hai hegau laa ga tala ange gi Isaac mee alodahi gu hai. ");
INSERT INTO nkr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Gai Isaac ga gaamai tamaa hine laa gi de hale malo o Sarah, dono dinana, ga hai bodu ange gi de ia; gai Isaac gu aloha i de ia. Deelaa ai, Isaac gu helui dono hinangalosaa i dua de magau o dono dinana. ");
INSERT INTO nkr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Gai Abraham ne hai ange hogi dahi bodu, dono ingoo go Keturah. ");
INSERT INTO nkr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Gai de hine laa ne haanau ange gi de ia Zimran, ma Jokshan, ma Medan, ma Midian, ma Ishbak, aama Shuah. ");
INSERT INTO nkr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan ne hagadili Sheba ma Dedan. Gai Dedan ne hagadili de gau Asshur, ma de gau Letush, aama de gau Leum. ");
INSERT INTO nkr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Gai dama daane a Midian go Ephah, ma Epher, ma Hanok, ma Abida, aama Eldaah. Gilaadeu nei alodahi go hagadiilinga o Keturah. ");
INSERT INTO nkr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Gai Abraham ne bolo ange ana mee alodahi gi Isaac. ");
INSERT INTO nkr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aagai ne gaavange gi dama a ono bodu laa daha hanu mee ngadi gaavange, ga hai gilaadeu gi hulo gee mai i daho dana dama go Isaac, i de masavaa oona goi mouli ai, gai gilaadeu ne hulo ga nnoho i de henua i baasi i dua. ");
INSERT INTO nkr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Gai Abraham ne mouli i e 175 ngadau. ");
INSERT INTO nkr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Gai Abraham ne magau i de masavaa gu kona ai dono madumadua, gai ne daulooloa dono mouli, gai ia ne hagabuni madali ono dangada. ");
INSERT INTO nkr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Gai luu dama daane a Abraham, go Isaac ma Ishmael ga kave ia ga danu i lo te haonga i Machpelah, i de alahenua o Ephron, tama daane a Zohar, taane Heth, i baasi dua o Mamre. ");
INSERT INTO nkr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Gai Abraham ngaadahi ma dono bodu go Sarah ne danu i de alahenua aana ne hagao i daho de gau Heth. ");
INSERT INTO nkr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Dua huu de magau o Abraham, gai de Maadua ne hagamanuuia dana dama daane go Isaac. Gai Isaac e noho i Beer Lahai Roi. ");
INSERT INTO nkr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Gai deenei de aamuli o tama daane a Abraham go Ishmael, go tama a Hagar, de hine Egypt, gai go de hine hai hegau o Sarah, ne haanau ange laa gi Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aanei denga dama daane a Ishmael, mai i tama madua ga hano iho ai: go Nebaiot, tama madua a Ishmael, ma Kedar, ma Adbeel, ma Mibsam, ");
INSERT INTO nkr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ma Mishma, ma Dumah, ma Massa, ");
INSERT INTO nkr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ma Hadad, ma Tema, ma Jetur, ma Naphish, aama Kedemah. ");
INSERT INTO nkr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aanei dama daane a Ishmael, go gilaadeu dagi o denga aamuli e madaangahulu ma lua, olaadeu aduhale ma mommee nnoho gaainga ne gaavange hogi olaadeu ingoo aagena. ");
INSERT INTO nkr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","(Gai Ishmael ne mouli i e 137 ngadau. Gai ia ne hai ana manava hagaodi ga magau, gai ia gu hagabuni madali ono dangada.) ");
INSERT INTO nkr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Gai gilaadeu ne nnoho mai i Havilah ga dae ai gi Shur, i baasi dua o Egypt, i de baasi ange gi Assyria. Gai gilaadeu e kino i olaadeu daina ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Gai deenei taalanga o de huaabodu o Isaac, tama daane a Abraham. Abraham ne hagadili Isaac; ");
INSERT INTO nkr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","gai ga madahaa huu ngadau o Isaac, gai ia ga kave Rebekah, tamaa hine a Bethuel, taane Syria mai i Mesopotamia, go taina hahine o Laban, ga hai bodu ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Gai Isaac ne dalodalo ange gi Tagi Maolunga i dagodo o dono bodu, i hiidinga tigi ai ana dama; gai Tagi Maolunga ga basa ange gi dana dalodalo, gai Rebekah gu hai dama. ");
INSERT INTO nkr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Gai luu dama i lo tono dinae ne hagadau usu, gai ia ga hagadaba, “Gu aha gu dagodo ai nei au bee nei?” Gai ia ne hano ga ssili ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Gai Tagi Maolunga ne hai ange gi de ia, “E lua huaahenua i lo too dinae, gai luu huaadangada i oo lodo naa e dee nnoho hagabuni; dahi e mmahi ange i de ia ange laa, gai tama madua e hai hegau ange naa gi tama gauligi.”  ");
INSERT INTO nkr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Gai de masavaa huu o de hine laa ne haanau ai, gai tilo, se maasanga nogo i lo tono dinae. ");
INSERT INTO nkr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gai tama ne haanau mai i mua e mmea, gai dono angaanga alodahi e huluhulua, gai ia ga hagaingoo ange ia go Esau. ");
INSERT INTO nkr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Gai muli mai, gai dono daina gu haanau, gai ia e kumi de muli de vae o Esau, gai ia ga hagaingoo ange ia go Jacob. Gai Isaac gu madaono ono ngadau, i de masavaa a Rebekah ne haanau ai delaau maasanga. ");
INSERT INTO nkr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Gai ga maatua huu luu gauligi daane laa, gai Esau se daane dau i de dili manu, ia ne noho saele i lodo henua, aagai Jacob se daane dee muu, ia e noho i lodo hale malo. ");
INSERT INTO nkr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Gai Isaac e aloha i Esau, go hiidinga ia e lodo e gai denga kano manu; aagai Rebekah e aloha i Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Dahi laangi gai Jacob ne hai dahi suba, gai Esau ne ahe mai i lodo henua, gai ia gu kona dono saalohia. ");
INSERT INTO nkr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Gai ia ga hai ange gi Jacob, “Aude haihaia gaamai hanu au suba mmea naa e gai au, go hiidinga au gu kona donu dogu saalohia.” (Deelaa ai, ia gu hagaingoo ange go Edom.) ");
INSERT INTO nkr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob ne hai ange, “Hagao ina mai gi de au de boolonga o tama madua.” ");
INSERT INTO nkr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ne hai ange, “Au gu dai magau i dogu saalohia, gai ni haigamaiana aha de boolonga o tama madua mai gi de au iainei?” ");
INSERT INTO nkr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Gai Jacob ga hai ange, “Hagatoo donu mai gi de au i mua.” Gai ia ga hagatoo donu ange gi de ia, ga hagao ange de boolonga o tama madua gi Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Gai Jacob ne gaavange gi Esau hanu pelaoaa ma hanu suba lentil. Gai ia ga noho ga gaimee ma de unu, muli mai gai ia ne hano gee mai i kilaa. Gai Esau ne hagangadi mee donu de boolonga o tama madua. ");
INSERT INTO nkr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gai gu onge honga de henua — bei de onge ne hai laa i de masavaa o Abraham e mouli ai — gai Isaac ne hano ga noho i Gerar i daho Abimelek, de hodooligi o de gau Philistia. ");
INSERT INTO nkr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Gai Tagi Maolunga ne hakide ange gi de ia, ga hai ange, “Aude hano gi Egypt; gai noho i de henua aagu e tala adu koe gi noho ai. ");
INSERT INTO nkr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Noho i de henua nei, gai au e noho madali goe, ga hagamanuuia ai goe. Gai au e gaavadu naa de henua nei alodahi gi de goe ma oo hagadiilinga, ma de hai gi bei dagu hagatoo donu ange gi doo damana go Abraham. ");
INSERT INTO nkr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Gai au e hai naa oo hagadiilinga gi soa, bei de lagolago o denga heduu i lo te langi i lunga, ma de gaavange gi gilaadeu de henua nei alodahi. Gai denga huaahenua alodahi o henua i lalo e manuuia naa i hiidinga o doo hagadiilinga, ");
INSERT INTO nkr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","go hiidinga Abraham ne daudali i agu muna, ma de hai mee alodahi aagu ne lodo ia gi haia, ia ne daohi agu muna ma agu mee gu hagasauaa, aama agu hainga.” ");
INSERT INTO nkr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Gai Isaac e noho i Gerar i de masavaa laa. ");
INSERT INTO nkr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","De masavaa a denga daane o de mommee laa ne ssili ange ai gi de ia dagodo o Rebekah, gai ia ga hai ange, “Ia go dogu daina hahine,” go hiidinga ia gu madagu i de tala ange, bolo Rebekah go dono bodu donu; ia ne maanadu bolo denga daane o de mommee laa, e daa naa ia ga magau i hiidinga o Rebekah, go hiidinga ia se hine mahamaha. ");
INSERT INTO nkr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Gai Isaac ne daulooloa dono noho i kilaa, gai Abimelek, de hodooligi o de gau Philistia ne gidee adu i ma tono abaaba damaa mee Isaac e hagatala ange gi Rebekah, dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Gai Abimelek ga aalu Isaac gi humai, ga hai ange, “De hine naa go doo bodu donu, gai gu aha gu hai mai ai laa goe bolo ia se daina hahine niiou?” Isaac ne hai ange, “Go hiidinga au ne maanadu bolo au e daia naa ga magau i ono hiidinga.” ");
INSERT INTO nkr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Gai Abimelek ga hai ange, “Se hegau bee hee aau gu hai mai naa gi gimaadeu? Ni momo ange donu huu dahi dangada gu dagodo haisala ma doo bodu, gai koe ga hagahaisala ai gimaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Gai Abimelek ga tala ange gi dangada alodahi, ga hai ange, “Be goai naa huu e poo ange gi taane nei ma dono bodu, gai ia e daa donu gi magau.” ");
INSERT INTO nkr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Gai Isaac ne doo hanu veelenga i de henua laa, gai hua ne hagihagi i de ngadau laa se lau hanonga ne lagolago ange ai i ana hua ne doo, go hiidinga Tagi Maolunga ne hagamanuuia ia. ");
INSERT INTO nkr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Gai Isaac gu kona mmao dono lava, gai e hagadagadaga ange donu de lagolago ana mee. ");
INSERT INTO nkr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Gai ana ssiibi ma ana manu ange laa, aama ono dangada hai hegau gu soa mmao, gai de gau Philistia gu magiaa ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Gai denga vai geli alodahi a de gau hai hegau o dono damana ne geli laa, i de masavaa o dono damana go Abraham, gu lava i de hhao a de gau Philistia i denga gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Gai Abimelek ne hai ange gi Isaac, “Koe gi hano gee mai i omaadeu daha, i hiidinga koe gu kii ange de mmahi i gimaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Gai Isaac ne hano gee mai i kilaa ga hano ga hagaduu age dono hale malo i de geelonga o Gerar ga noho ai. ");
INSERT INTO nkr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Gai Isaac ga ahe ange ga geli age denga vai geli ne geli laa i de masavaa o dono damana go Abraham, gai gu lava i de hhao a de gau Philistia i denga gelegele, i dua de magau o Abraham. Gai ia ga ahe ange ga hagaingoo ange denga vai geli laa i denga ingoo a dono damana ne gaavange gi denga vai laa. ");
INSERT INTO nkr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Gai de masavaa huu a de gau hai hegau o Isaac ne geli ai dahi mommee i kilaa, gai gilaadeu gu gidee dahi mommee e ssali age vai i lalo de henua. ");
INSERT INTO nkr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gai de gau hagaloosi manu i Gerar ga hagadaumee ange gi de gau hagaloosi manu o Isaac, ga hai ange, “De vai nei niimaadeu!” Gai Isaac ga hagaingoo ange de vai laa go Esek, go hiidinga gilaadeu ne hagadaumee ange gi de ia i de vai laa. ");
INSERT INTO nkr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Gai ono dangada hai hegau ga geli ange hogi dahi vai geli, gai denga daane o de mommee laa ga hagadaumee ange hogi gi gilaadeu i de vai laa, gai ia ga hagaingoo ange de vai laa go Sitnah. ");
INSERT INTO nkr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Gai ia ne ngalue ange gi dahi mommee gee ga geli ai dahi vai geli, gai gilaadeu teai donu ne hagadaumee ange gi de ia i de vai laa. Gai ia ga hagaingoo ange de vai laa go Rehoboth, go hiidinga ia e hagadaba, “Anailaa nei gai Tagi Maolunga gu hai gi lahalaha demaadeu mommee, gai gimaadeu e hagadili naa ga soa i de henua nei.” ");
INSERT INTO nkr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Gai ia ga hano gee i kilaa ga hano gi Beersheba. ");
INSERT INTO nkr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Gai Tagi Maolunga ne hakide ange gi de ia i de boo laa, ga hai ange, “Go au donu de Maadua o doo damana go Abraham. Aude madagu, go hiidinga au madali goe; au e hagamanuuia naa goe ga hai gi soa doo aamuli, i hiidinga o dogu dangada hai hegau go Abraham.” ");
INSERT INTO nkr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Gai Isaac ga bae dahi mommee o ssigidaumaha i kilaa, ma de dalodalo ange gi Tagi Maolunga. Gai ia ga hagaduu dono hale malo i kilaa, gai ono dangada hai hegau ne geli dahi vai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Gai Abimelek ne humai gi daho Isaac i Gerar, madali dono dangada bale go Ahuzzath, ma Phicol, tagi o ono daane hebagi. ");
INSERT INTO nkr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Gai Isaac ga ssili ange gi gilaadeu, “Gu aha gu loomai ai naa goodou gi ogu daha, gai goodou ne kino i de au, ma de hai au gi hano gee mai i oodou daha?” ");
INSERT INTO nkr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Gai gilaadeu ga hai ange, “Gimaadeu gu gidee bolo Tagi Maolunga e noho madali goe; deelaa ai, gimaadeu ne hagataba, ‘E danuaa taadeu hai dahi hagatoo donu hagaheloongoi i odaadeu magavaa.’ Gidaadeu ga hagaheloongoi madali goe, ");
INSERT INTO nkr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","gi dee haia mai ai e goe de baubau gi gimaadeu, bei demaadeu hai tee poo adu ai naa gi de goe, aabe ne hai adu de baubau gi de goe, gai ne abodonu adu gi de goe, ma de dugu goe gi hano i de noho baba. Iainei gai Tagi Maolunga gu hagamanuuia goe.” ");
INSERT INTO nkr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Gai Isaac ga hai ange dahi daonga gi gilaadeu, gai gilaadeu ga gaimee ai ma de unu. ");
INSERT INTO nkr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Gai taiao age huu gai gilaadeu ga hagatoo donu i olaadeu magavaa. Dua mee laa gai Isaac ga hai gilaadeu gi hulo, gai denga daane laa ne hulo gee mai i ono daha i de nnoho paba. ");
INSERT INTO nkr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","De laangi laa gai de gau hai hegau o Isaac ne loomai ga tala ange gi de ia, dagodo o de vai geli alaadeu gu geli laa, ga hai ange, “Gimaadeu gu gidee hanu vai.” ");
INSERT INTO nkr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Gai ia ga hagaingoo ange de vai laa go Shibah, gai de aduhale laa gu hagaingoo ange go Beersheba ga dae mai ai gi anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Gai ga madahaa huu ngadau o Esau, gai ia ga hai bodu ange gi Judith, tamaa hine a Beeri taane Heth, aama Basemath, tamaa hine a Elon taane Heth. ");
INSERT INTO nkr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Gai luu haahine laa ne hagadaemaha lodo o Isaac ma Rebekah. ");
INSERT INTO nkr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Gai ga madumadua huu Isaac gai ia gu dai dee gide, gai ia ga hagahi dana dama madua go Esau, ga hai ange, “Dagu dama.” Gai ia ga hai ange gi de ia, “Deenei au.” ");
INSERT INTO nkr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac ga hai ange, “Au gu se daane madumadua iainei, gai au e dee iloo be dee hee dogu laangi e magau ai. ");
INSERT INTO nkr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Deenei ai, gaavee oo goloa dili manu — go de mee e hhao ai dau dao ma dau mee hholu, ma gi hannoo gi lodo henua dilia mai ai dahi manu e gai au. ");
INSERT INTO nkr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Gai koe ga hai mai ai de haigai mmammami aagu e lodo laa e gai, gai au ga hagamanuuia ai goe i mua dogu magau.” ");
INSERT INTO nkr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Gai Rebekah ne langona de tala ange o Isaac muna nei gi dana dama daane go Esau, gai de masavaa huu o Esau ne hano ai gi lodo henua e tili mai ai de giidagi a dono damana, ");
INSERT INTO nkr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","gai Rebekah ga tala ange gi dana dama daane go Jacob, ga hai ange, “Au ne langona doo damana ne hai ange gi doo daina daane go Esau, ");
INSERT INTO nkr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Hannoo dilia mai dahi manu e haia ai dahi haigai mmammami e gai au, gai au ga hagamanuuia ai goe i mada luu mada o Tagi Maolunga, i mua dogu magau’. ");
INSERT INTO nkr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Deenei ai, dagu dama, kana ange hagalaangona agu muna mage haia gi bei agu muna e tala adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hannoo gi de buibui o de hagabuulingaa ssiibi ma guudi gaamai ai e lua guudi gauligi pedi, gai au ga hai ai de haigai mmammami a doo damana e lodo e gai. ");
INSERT INTO nkr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Gai koe ga hano ga kave gi doo damana gi gaina, gai ia ga hagamanuuia ai goe i mua dono magau.” ");
INSERT INTO nkr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Gai Jacob ga hai ange gi dono dinana go Rebekah, “Dogu daina daane go Esau e huluhulua dono angaanga, gai au e malali dogu angaanga; ");
INSERT INTO nkr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","gai noo dogu damana e haahaa mai dogu angaanga, gai ia e iloo naa bolo au gu daahanga ia, gai ia ga hagamalaia ai naa au, e dee hagamanuuia.” ");
INSERT INTO nkr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Aagai dono dinana ga hai ange gi de ia, “Dagu dama, go au e gaavee doo malaia, gai koe hagallongo mai donu huu gi agu muna mage hannoo gaamai luu manu laa gi too mai gi ogu daha.” ");
INSERT INTO nkr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gai ia ga hano ga gaamai luu manu laa ga gaavange gi dono dinana, gai dono dinana ga hai ai de haigai mmammami a dono damana e lodo laa e gai. ");
INSERT INTO nkr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Gai Rebekah ga kave malo danuaa hugadoo o dana dama madua go Esau i ono daha i de hale, gai ia ga hakahu ange ai dana dama gauligi go Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Gai ia ga hai gili o luu guudi gauligi laa ga haoli ai luoono lima ma de mommee malali i dono ua. ");
INSERT INTO nkr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Gai Rebekah ga gaavange de haigai mmammami laa ma pelaoaa aana gu hai gi dana dama go Jacob gi gaavee. ");
INSERT INTO nkr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Gai ia ga hano ga hai ange gi dono damana, “Dogu damana.” Isaac ne hai ange, “Deenei au. Dagu dama, go koe goai?” ");
INSERT INTO nkr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Gai Jacob ga hai ange gi dono damana, “Go au go Esau, dau dama madua; au gu hagassula au muna mai gi de au. Hidi age gaina agu giidagi gu gaamai nei, gai koe ga hagamanuuia ai au.” ");
INSERT INTO nkr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Gai Isaac ga hai ange gi dana dama, “Dagu dama, dee hee de hai ne moolau ai naa doo hagalau?” Gai ia ga hai ange, “Go hiidinga Tagi Maolunga, doo Maadua ne hai ga moolau de ssula agu hegau.” ");
INSERT INTO nkr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Gai Isaac ga hai ange gi Jacob, “Dagu dama, humai gi baa mai goe e haahaa adu au goe, e tilo ai be ni muna abodonu go koe go dagu dama daane go Esau aabe deai.” ");
INSERT INTO nkr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Gai Jacob ga hano ga hagabaa ange gi dono damana go Isaac, gai ia ga haahaa ange ia. Gai ia ga hai ange, “Doo leo go de leo o Jacob, gai luoo lima go luu lima o Esau.” ");
INSERT INTO nkr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Gai Isaac tee madea bolo go Jacob deelaa, go hiidinga luoono lima e huluhulua, bei luu lima o Esau dono daina daane, gai ia ga hagamanuuia Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Gai ia ga ssili ange, “Ni muna abodonu go koe go dagu dama go Esau?” Jacob ne hai ange, “Go au donu deenei.” ");
INSERT INTO nkr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Gai Isaac ga hai ange, “Gaamai hanu au giidagi e gai au, gai au ga hagamanuuia ai goe.” Gai Jacob ne gaamai giidagi laa gi dono damana gi gaina; ia ne gaamai hogi hanu uvaini e unu ia. ");
INSERT INTO nkr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Gai dono damana go Isaac ga hai ange gi Jacob, “Dagu dama, humai gi baa mai goe oso ina au.” ");
INSERT INTO nkr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Gai Jacob ne hano ga hagabaa ange ga oso dono damana, gai ga dungua huu e Isaac de nnamu o ono malo, gai ia ga hagamanuuia ia, ga hagadaba, “De nnamu o dagu dama daane e bei de nnamu i lo te duu malaelae a Tagi Maolunga gu hagamanuuia. ");
INSERT INTO nkr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","De Maadua gi gaavadu gi de goe de mee suungia mai i de langi, ma mee moomuna o de gelegele ma grain ma uvaini lagolago. ");
INSERT INTO nkr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gai gi soa huaahenua e hai hegau adu gi de goe, gai denga huaahenua gi ino adu gi de goe. Gai go koe gi dagina oo daina, gai dama a doo dinana gi ino adu gi de goe. Dangada e hagamalaia ina goe gi maalaia naa, gai gilaadeu e hagamanuuia ina goe e manuuia naa.”   ");
INSERT INTO nkr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Gai ga lava huu i de hagamanuuia a Isaac Jacob, gai ia ga sao ga hano gee mai i daho dono damana go Isaac, gai dono daina go Esau gu dae mai ma dana manu ne mau, ");
INSERT INTO nkr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","gai ia ga hagadabena hogi dahi haigai mmammami e gai dono damana, gai ia ga hai ange gi de ia, “Dogu damana, hidi age gaina giidagi a dau dama gu gaamai nei, gai koe ga hagamanuuia ai au.” ");
INSERT INTO nkr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Gai dono damana go Isaac ga ssili ange gi de ia, “Go koe goai?” Gai ia ga hai ange, “Go au go Esau, dau dama madua.” ");
INSERT INTO nkr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Gai Isaac gu bolebole mmao, gai ia ga ssili ange, “Gai goai ne gaamai laa hanu gai ga gai au i mua doo humai? Gai au ga hagamanuuia ai ia, gai ia e manuuia naa donu!” ");
INSERT INTO nkr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Gai ga langona huu e Esau muna a dono damana, gai ia ga oo ga dangi. Gai ia ga hai ange gi dono damana, “Dogu damana, hagamanuuia ina hogi au!” ");
INSERT INTO nkr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Gai Isaac ga hai ange, “Doo daina daane ne humai ga daahanga mai au, ga kave ai doo manuuia.” ");
INSERT INTO nkr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Gai Esau ga hai ange, “E dee deelaa hiidinga oona ne hagaingoo ange ai laa go Jacob? Deenei de lua hanonga aana ne daahanga ai au: ia ne kave dogu boolonga, gai iainei ia gu kave hogi dogu manuuia.” Gai Esau ga hai ange, “Gai e deai laa donu se manuuia aau ne hagadoe mai gi de au?”  ");
INSERT INTO nkr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Gai Isaac ne basa ange ga hai ange gi Esau, “Au gu hai ia go doo dagi, gai ono daina alodahi e hai hegau ange naa gi de ia; gai au gu gaavange gi de ia denga grain, ma uvaini e gaimee ai ia. Gai se aha naa donu aagu e maua i de hai adu maau, e dagu dama?” ");
INSERT INTO nkr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Gai Esau ga hai ange gi dono damana, “Dogu damana, e deai ange laa donu se manuuia e doe i oo daha e hagamanuuia ai hogi au?” Gai Esau ga oo ga dangi. ");
INSERT INTO nkr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Gai dono damana go Isaac ga basa ange, ga hai ange gi de ia, “Tilo, doo mommee noho ai e mmao gee i de gelegele e hhua danuaa ai denga manu ssomo, ma mai i de mommee e hano iho ai de mee suungia o de langi. ");
INSERT INTO nkr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Koe e mouli naa i dau gadilaasa, gai koe e hai hegau ange naa gi doo daina daane. Aagai de masavaa naa huu oou e huli ange ai gi de ia, gai koe e hadihadi naa dana laagau gu hagauda adu gi honga doo eu.”   ");
INSERT INTO nkr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Gai Esau ne golo age dono lili i Jacob, i hiidinga de hagamanuuia a delaau damana ia. Gai Esau ne hagadaba i ono lodo, “Ga odi ange naa donu huu laangi e hinangalosaa ai i dogu damana, gai au ga daa gi magau dogu daina go Jacob.” ");
INSERT INTO nkr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Gai ga langona huu e Rebekah muna a dana dama madua go Esau, gai ia ga aalu gi humai dana dama gauligi go Jacob, ga hai ange gi de ia, “Tilo, doo daina go Esau e hagaaneane ono lodo, i dana hai de hagatau e daa ai goe gi magau. ");
INSERT INTO nkr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Deenei ai, dagu dama, koe gi daudali i agu muna: hidi age savini hannoo gi daho dogu daina daane go Laban i Haran. ");
INSERT INTO nkr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Gai koe noho i ono daha i dahi masavaa, ga dae ai gi de helui de lili o doo daina. ");
INSERT INTO nkr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Gai de masavaa naa huu e helui ai de lili o doo daina, ma de ngalo au mee ne hai ange gi de ia, gai au ga aalu adu goe gi ahe mai i kilaa. Gai gu aha gu hinangalosaa ai au, i gooluu ngaadahi i dahi laangi daudahi?” ");
INSERT INTO nkr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Gai Rebekah ga hai ange gi Isaac, “Au gu goso mmao i de mouli nei i hiidinga o denga damaa hine a de gau Heth, gai noo Jacob e kave hogi dahi bodu mai i denga damaa hine a de gau Heth i de henua nei, gai e deai donu haigamaiana dogu mouli.” ");
INSERT INTO nkr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Gai Isaac ne hagahi Jacob ga hagamanuuia ia ga tala ange ana mee e hai: “Koe e dee kave donu dahi damaa hine Canaan e hai ai doo bodu. ");
INSERT INTO nkr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Gai koe hannoo gi Mesopotamia, gi de hale o Bethuel, tamana o doo dinana, ga kave ai dahi bodu moou mai i denga damaa hine a Laban, taina daane o doo dinana. ");
INSERT INTO nkr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gai de Maadua Mmahi Mmao laa e hagamanuuia naa goe, ma de hai goe gi hagadili gi soa, gai koe ga hai ai hanu hagabuulingaa dangada soa. ");
INSERT INTO nkr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Gai ia e gaavadu naa gi de goe ma doo aamuli de manuuia ne gaavange laa gi Abraham, gai koe e henua naa i de henua oou e noho gaainga ai naa iainei, go de henua a de Maadua gu gaavange gi Abraham.”  ");
INSERT INTO nkr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Gai Isaac ga hai Jacob gi hano gi Mesopotamia i daho Laban, tama daane a Bethuel, taane Syria, gai go taina daane o Rebekah, tinana o Jacob ma Esau. ");
INSERT INTO nkr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Gai Esau ne gidee bolo Isaac gu hagamanuuia Jacob, ma de hai ia gi hano gi Mesopotamia gi haia ai dahi bodu moona i kilaa, gai de masavaa aana ne hagamanuuia ai Jacob, gai ia ne tala ange gi de ia, ga hai ange, “Koe e dee hai bodu ange gi dahi hahine Canaan.” ");
INSERT INTO nkr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Gai Jacob ne hagallongo ange gi muna a dono damana ma dono dinana ga hano gi Mesopotamia. ");
INSERT INTO nkr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Gai ga gidee huu e Esau bolo dono damana go Isaac, e dee malangilangi i denga damaa hine o Canaan, ");
INSERT INTO nkr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","gai ia ga hano gi daho Ishmael, tama daane a Abraham, ga hai bodu ange Mahalath, tamaa hine a Ishmael, go taina hahine o Nebaioth. ");
INSERT INTO nkr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Gai Jacob ga hano gee mai i Beersheba ga hano gi Haran. ");
INSERT INTO nkr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","De masavaa oona ne dae ai gi dahi mommee, gai ia ne noho i kilaa i de boo laa i hiidinga gu ahiahi de mee. Gai ia ne hili dahi hadu i de mommee laa ga ulunga ange aagena, gai ia ga dagodo ga seni i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Gai ia gu hai dahi midi, gai tilo, dahi gaagenga e duu i honga de henua, gai dono ulu e dae gi de langi. Gai tilo, denga dangada de langi o de Maadua e kage age aama de iho ai. ");
INSERT INTO nkr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Gai Tagi Maolunga e duu i de ulu, gai ia ga hai ange, “Go au go Tagi Maolunga, de Maadua o doo dubuna go Abraham, ma de Maadua o Isaac. Au e gaavadu naa gi de goe ma doo aamuli de gelegele oou e dagodo naa i ono elunga. ");
INSERT INTO nkr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Gai oo hagadiilinga e soa naa bei de lagolago o denga gelegele i honga de henua, gai koe e hhao naa ga honu de henua mai i dai ga hano ai gi dua, ma mai i ngaiho ga hano ai gi ngaage. Gai hagadiilinga alodahi o henua i lalo e manuuia naa i oodou hiidinga ma doo hagadiilinga. ");
INSERT INTO nkr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Gai au e noho naa madali goe ma de tilo adu goe i mommee alodahi oou e hano aagena, gai au e hagaahe mai naa donu goe gi de henua nei, gai au e dee tili naa donu goe ga dae ai gi dagu hagassula mee aagu gu hagatoo donu adu gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Gai ga alahage huu Jacob gai ia ga hagadaba, “Ni muna abodonu Tagi Maolunga e noho donu i de mommee nei, gai au tee iloo donu!” ");
INSERT INTO nkr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Gai ia gu madagu ga hagadaba, “Ga dae laa de hagamaatagu de mommee nei! De mommee nei go de hale donu o de Maadua; gai deenei donu de haitoga o de langi.” ");
INSERT INTO nkr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Gai Jacob ga oho age i taiao ga kave de hadu oona ne ulunga ange laa aagena ga hagaduu age e hai ai tuludulu hagamaanadu, gai ia ga llingi ange hanu lolo gi honga de hadu laa. ");
INSERT INTO nkr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Gai ia ga hagaingoo ange de mommee laa go Bethel; i mua gai de ingoo o de aduhale laa go Luz. ");
INSERT INTO nkr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Gai Jacob ne hai dahi hagatoo donu, ga hagadaba, “Noo de Maadua e noho madali au, ma de tilo mai au i dogu sailago, ga gaamai agu mee gai ma ogu malo, ");
INSERT INTO nkr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","gai au e mouli naa ga ahe mai gi de hale o dogu damana, gai au e hai Iahweh go dogu Maadua. ");
INSERT INTO nkr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Gai de hadu aagu gu hagaduu age nei gi se duludulu hagamaanadu, e hai naa go de hale o de Maadua, gai au e gaavadu naa gi de goe dahi diba i diba e madaangahulu, o mee alodahi aau e gaamai gi de au.” ");
INSERT INTO nkr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Gai Jacob ne seesee ga hano gu dae gi de henua o denga huaadangada i baasi dua. ");
INSERT INTO nkr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Gai ia gu gidee dahi vai geli i lo te duu malaelae, gai e dolu hagabuulingaa ssiibi e nnoho i gaogao de vai laa, i hiidinga go de vai geli laa e hagaunu ai denga ssiibi. Gai dahi hadu laumalie e pono de ngudu o de vai geli laa. ");
INSERT INTO nkr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Go kilaa e hagabaa mai aagena denga hagabuulingaa manu alodahi, gai de gau hagaloosi ssiibi ga hagadige gee de hadu e pono ai laa de vai geli, gai ga hagaunu denga ssiibi. Muli mai gai gilaadeu e hagaahe ange de hadu laa ga pono ai de vai. ");
INSERT INTO nkr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Gai Jacob ne ssili ange gi de gau hagaloosi ssiibi laa, “Denga daina, go hee oodou ne loomai ai naa?” Gilaadeu ga hai ange, “Gimaadeu ne loomai i Haran.” ");
INSERT INTO nkr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ia ne ssili ange gi gilaadeu, “Goodou e iloo laa Laban, de mogobuna o Nahor?” Gilaadeu ne hai ange, “Uaa, gimaadeu e iloo ia.” ");
INSERT INTO nkr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Gai ia ne ssili ange gi gilaadeu, “Ia e mahi naa huu?” Gilaadeu ne hai ange, “Uaa, ia e mmahi. Gai deenei dana damaa hine go Rachel e humai nei madali denga ssiibi.” ");
INSERT INTO nkr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Gai Jacob ga hai ange, “Tilo, tigi dai danu loo de laa; tigi dae hogi de masavaa e hagabaa mai ai denga hagabuulingaa ssiibi. Hagaunumia denga ssiibi ga hagaahe gi de mommee iai helii.” ");
INSERT INTO nkr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Gilaadeu ne hai ange, “Gimaadeu e dee maua donu, ga dae ai gi de odi mai o denga hagabuulingaa ssiibi alodahi, gai dua naa huu de hagadige gee o de hadu i ma te vai geli. Gai gimaadeu gu maua i de hagaunu denga ssiibi.” ");
INSERT INTO nkr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Gai de masavaa oona e basa ange ai gi gilaadeu, gai Rachel gu humai madali denga ssiibi a dono damana, go hiidinga ia se hine hagaloosi manu. ");
INSERT INTO nkr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Gai ga gidee huu e Jacob Rachel, tamaa hine a Laban, taina daane o dono dinana, ma de hagabuulingaa ssiibi a Laban, gai Jacob ga hano ga hagadige gee de hadu i ma te vai geli, ga hagaunu ange denga ssiibi a Laban, taina daane o dono dinana. ");
INSERT INTO nkr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Muli mai gai Jacob ne oso Rachel, gai ia ne oo ga dangi. ");
INSERT INTO nkr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Gai ia ga tala ange gi Rachel bolo ia se dangada niio dono damana, gai ia go tama daane a Rebekah. Gai Rachel ga savini ga hano ga tala ange gi dono damana. ");
INSERT INTO nkr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Gai ga langona huu e Laban longo o Jacob, tama daane a dono daina hahine, gai ia ga savini ga hano ga hedae ange gi de ia, gai ia ga buuludi ange ia ga oso ia, gai ia ga kave ia gi dono hale. Gai Jacob ga tala ange gi Laban mee nei alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Gai Laban ga hai ange gi de ia, “Ni muna abodonu, koe se dangada donu niiogu.” Gai ia ne noho i ono daha i e dahi malama. ");
INSERT INTO nkr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Gai Laban ne hai ange gi Jacob, “E dee heohi donu doo ngadi hai hegau mai gi de au, e dee galemu donu gidaau se hai dangada. Daalaa mai be dee hee dagu hai e hagao adu ai goe?” ");
INSERT INTO nkr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Gai Laban e dogolua ana damaa hine; de ingoo o tamaa hine madua go Leah, gai de ingoo o tamaa gauligi go Rachel. ");
INSERT INTO nkr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Gai luu mada o Leah e baageaa, aagai Rachel e somo danuaa dono angaanga, ma de mahamaha. ");
INSERT INTO nkr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gai Jacob ne aloha i Rachel, gai ia ga hai ange, “Au e hai hegau adu gi de goe i e hidu ngadau, gai koe ga gaamai dau damaa hine gauligi go Rachel, e hai ai dogu bodu.” ");
INSERT INTO nkr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Gai Laban ga hai ange, “E danuaa ange dagu gaavadu ia gi de goe, i dagu gaavange ia gi dahi daane gee. Noho i ogu daha i kinei.” ");
INSERT INTO nkr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Gai Jacob ne hai hegau i e hidu ngadau e kave ai Rachel, gai e dagodo be ni laangi sogoisi donu huu, i hiidinga dono aloha i Rachel. ");
INSERT INTO nkr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Gai Jacob ne hai ange gi Laban, “Gaamai dogu bodu, go hiidinga gu odi ange denga ngadau e hidu, gai au ga hano e hagahebaa ma ia.” ");
INSERT INTO nkr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Gai Laban ne hagabuni dangada alodahi i de mommee laa, ga hai dahi daonga. ");
INSERT INTO nkr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Aagai de masavaa huu ne ahiahi ai, gai ia ga kave dana damaa hine go Leah ga gaavange gi Jacob, gai Jacob ga hagahebaa ma ia. ");
INSERT INTO nkr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Gai a Laban ne gaavange dono hahine hai hegau go Zilpah gi dana damaa hine go Leah, e hai ai dono hahine hegau. ");
INSERT INTO nkr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Gai taiao age huu, gai Jacob gu gidee bolo de hine laa go Leah. Gai Jacob ne hai ange gi Laban, “Se hegau bee hee aau gu hai mai nei gi de au? E aha, e dee go hiidinga o Rachel oogu ne hai hegau adu ai laa gi de goe? Gai gu aha goe gu daahanga ai nei au?” ");
INSERT INTO nkr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Gai Laban ga hai ange, “E dee heohi ange gi demaadeu dahulinga, i de hagahai bodu tamaa gauligi i mua o tamaa madua. ");
INSERT INTO nkr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Daalia gi lava ai taonga o de hagahai bodu i de uvigi nei; gai gimaadeu ga gaavadu hogi gi de goe tamaa hine gauligi, gai koe ga hai hegau mai ange ai gi de au i e hidu ngadau.” ");
INSERT INTO nkr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Gai Jacob ne tali gi odi de uvigi laa. Gai Laban ga gaavange hogi dana damaa hine go Rachel gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Gai Laban ne gaavange dono hahine hai hegau go Bilhah gi dana damaa hine go Rachel, e hai ai dono hahine hai hegau. ");
INSERT INTO nkr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Gai Jacob ne hagahebaa hogi ma Rachel, gai e kii Rachel dono aloha ai i Leah. Gai ia ne hai hegau ange gi a Laban i e hidu ange ngadau. ");
INSERT INTO nkr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Gai ga gidee huu e Tagi Maolunga bolo Jacob e dee aloha i Leah, gai ia ga hhuge de mommee o denga dama o Leah, aagai Rachel e deai donu ana dama. ");
INSERT INTO nkr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Gai Leah gu hai dama ga haanau dahi dama daane, gai ia ga hagaingoo ange ia go Reuben, gai ia ne hagadaba, “Tagi Maolunga gu gidee dogu duasala, dua iainei gai dogu bodu e aloha donu i de au.” ");
INSERT INTO nkr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ia ne hai dama ange hogi ga haanau dahi dama daane, gai ia ga hagadaba, “Go hiidinga Tagi Maolunga gu langona bolo dogu bodu e dee aloha i de au, gai ia gu gaamai ange gi de au tama nei.” Gai ia ga hagaingoo ange ia go Simeon. ");
INSERT INTO nkr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Gai ia ne hai dama ange hogi, ga haanau dahi dama daane, gai ia ga hagadaba, “Dua iainei gai dogu bodu e hagapigi mai naa donu gi de au, go hiidinga au gu haanau ange gi de ia e dolu dama daane.” Gai ia ga hagaingoo ange ia go Levi. ");
INSERT INTO nkr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Gai ia ne hai dama ange hogi, ga haanau dahi dama daane, gai ia ga hagadaba, “De masavaa nei gai au e tuhi Tagi Maolunga.” Gai ia ga hagaingoo ange ia go Judah. Gai ia tee haanau ange. ");
INSERT INTO nkr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","De masavaa huu a Rachel ne gidee ai, bolo tigi ai ana dama ange gi Jacob, gai ia gu lodo gaiaa ange gi dono daina hahine. Gai ia ga hai ange gi Jacob, “Haia gi hanu agu dama, kana magau naa huu au!” ");
INSERT INTO nkr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Gai Jacob gu kona mmao dono lili i Rachel, ga hai ange gi de ia, “Go au go de Maadua, de ia tigi dugua adu naa gi hanu au dama?” ");
INSERT INTO nkr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Gai Rachel ga hai ange, “Deenei dogu haahine hai hegau go Bilhah; hannoo hagahebaa ma ia, gai ia ga haanau ai hanu dama maagu, gi hanu ai agu dama mai i ono daha.” ");
INSERT INTO nkr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Gai Rachel ga gaavange dono hahine hai hegau go Bilhah gi Jacob e hai ai dono bodu, gai Jacob ga hano ga hagahebaa ma ia. ");
INSERT INTO nkr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Gai Bilhah gu hai dama ga haanau ange gi Jacob dahi dama daane. ");
INSERT INTO nkr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Gai Rachel ga hagadaba, “De Maadua gu hagamodu bolo au e heohi, gai gu langona hogi e ia dagu dangidangi ma gu gaamai dahi dama daane maagu.” Gai ia ne hagaingoo ange ia go Dan. ");
INSERT INTO nkr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Gai de hine hai hegau o Rachel go Bilhah gu hai dama ange hogi, gai ia ga haanau togolua dama daane ange gi Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Gai Rachel ga hagadaba, “Au ne daudau hagammahi ange gi dogu daina hahine, gai au gu kii.” Gai ia ne hagaingoo ange ia go Naphtali. ");
INSERT INTO nkr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Aagai ga gidee huu e Leah bolo ia gu dee maua gi hanu ange ana dama, gai ia ga kave dono hahine hai hegau go Zilpah ga gaavange gi Jacob, e hai ai dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Gai de hine hai hegau o Leah go Zilpah ne haanau ange gi Jacob dahi dama daane. ");
INSERT INTO nkr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Gai Leah ne hagadaba, “Au gu manuuia!” Gai ia ne hagaingoo ange ia go Gad. ");
INSERT INTO nkr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Gai de hine hai hegau o Leah go Zilpah ne haanau ange hogi gi Jacob dahi dama daane, ");
INSERT INTO nkr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","gai Leah ga hagadaba, “Au gu malangilangi mmao! Denga haahine e hagahi mai naa de malangilangi gi de au.” Gai ia ne hagaingoo ange tama daane laa go Asher. ");
INSERT INTO nkr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","De masavaa e hagihagi ai denga grain, gai Reuben ne hano ga gidee hanu mandrake i lodo henua, gai ia ga gaamai ga gaavange gi dono dinana go Leah. Gai Rachel ne hai ange gi a Leah, “Au e dangidangi adu, gaamai hanu mandrake a dau dama maagu.” ");
INSERT INTO nkr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Aagai Leah ne hai ange gi de ia, “Tigi lava naa donu au mee e kave mai i ogu daha? Koe gu kave gee dogu bodu, gai koe ga kave naa hogi denga mandrake a dagu dama?” Gai Rachel ga hai ange, “Gaamai hanu mandrake a dau dama maagu, gai Jacob ga hanadu gi oo daha aaboo nei.” ");
INSERT INTO nkr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gai de masavaa huu o Jacob ne ahe mai ai i de veelenga i de ahiahi, gai a Leah ga hano ga hedae ange gi de ia, ga hai ange, “Koe e humai gi ogu daha aaboo nei, go hiidinga au gu hagao goe i denga mandrake a dagu dama.” Gai Jacob ne hano ga hagahebaa ma ia i de boo laa. ");
INSERT INTO nkr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gai de Maadua ne hagallongo tangidangi a Leah, gai ia gu hai dama ange hogi, ga haanau ange gi Jacob togolima dama daane. ");
INSERT INTO nkr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Gai Leah ga hagadaba, “De Maadua gu hagao mai au, i hiidinga au ne gaavange dogu hahine hai hegau gi dogu bodu.” Gai ia ga hagaingoo ange tama daane laa go Issachar. ");
INSERT INTO nkr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Gai Leah gu hai dama ange hogi ga haanau togoono dama daane ange gi Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Gai Leah ga hagadaba, “De Maadua gu gaamai dahi mee ngadi gaavange danuaa gi de au. Iainei gai dogu bodu e hagadubu naa donu au, go hiidinga au gu haanau ange gi de ia e dogoono dama daane.” Gai ia ga hagahi ange de ingoo o tama daane laa go Zebulun. ");
INSERT INTO nkr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Muli mai gai ia ne haanau hogi dahi damaa hine, gai ia ga hagaingoo ange ia go Dinah. ");
INSERT INTO nkr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gai de Maadua gu manadua e ia dagodo o Rachel, gai ia ga hagallongo dana dangidangi, ga hhuge de mommee o denga dama. ");
INSERT INTO nkr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Gai ia gu hai dama ga haanau dahi dama daane, ga hagadaba, “De Maadua gu kave gee dogu hagadogaa.” ");
INSERT INTO nkr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Gai ia ga hagaingoo ange ia go Joseph, ia ne hagadaba, “Tagi Maolunga gi gaamai ange dahi dama daane maagu!” ");
INSERT INTO nkr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Dua huu de haanau a Rachel Joseph, gai Jacob ne hai ange gi Laban, “Dugua mai au gi ahe gi dogu mommee ma dogu henua donu. ");
INSERT INTO nkr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Gai gaamai hogi luoogu bodu oogu ne hai hegau adu ai gi de goe, aama agu dama e hulo gimaadeu. Koe e iloo dagodo o dagu hai hegau adu ai gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Aagai Laban ne hai ange gi de ia, “Noo koe e malangilangi i de au, gai koe noho. Gai gu hagaago mai gi de au bolo Tagi Maolunga gu hagamanuuia donu au i oo hiidinga.” ");
INSERT INTO nkr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ia ne hai ange hogi, “Daalaa mai doo hagaoanga, gai au ga hagao adu.” ");
INSERT INTO nkr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob ne hai ange gi de ia, “Koe gu iloo donu dogu hai ne hai hegau adu ai gi de goe ma dagu tilo danuaa ange au manu haangai. ");
INSERT INTO nkr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","I mua dogu dae mai gi oo daha, gai e sogoisi donu huu au mee, gai iainei gu lagolago mmao au mee, gai Tagi Maolunga gu hagamanuuia goe i mee alodahi. Aagai iainei e dee heohi hogi dogu hai hegau ange e hagadanuaa dogu huaabodu donu?” ");
INSERT INTO nkr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ne ssili ange, “Se aha aagu e gaavadu gi de goe?” Jacob ne hai ange, “E deai ange donu au mee e gaamai gi de au. Deenei donu huu dau mee e hai, gai au e duudagi naa donu huu de haangai ma de hagaloosi dau hagabuulingaa manu: ");
INSERT INTO nkr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ailaa nei gai koe dugua mai au gi vaaea gee ssiibi daubulebule alodahi, ma ssiibi dongidongi alodahi, ma denga ssiibi uliuli alodahi aama guudi dongidongi ma de daubulebule mai i au manu alodahi, e kave maagu. Aanei mee e hai ai dogu hagaoanga. ");
INSERT INTO nkr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Gai gi iloo ai e goe bolo au e hai hegau i de muna abodonu i laangi e loomai nei, gai de masavaa naa huu oou e humai ai e tilo dogu hagaoanga, gai noo e hanu manu e dee daubulebule aabe e dee dongidongi i magavaa o denga guudi, aabe ni ssiibi e dee uliuli, gai koe gu iloo bolo ni manu niiagu ne gaiaa.” ");
INSERT INTO nkr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ne hai ange, “E danuaa, haia gi bei au muna.” ");
INSERT INTO nkr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","De laangi laa gai a Laban ne hano ga vvae gee denga guudi daane ma guudi haahine daubulebule ma de dongidongi, (go manu alodahi e hanu mommee e tea i olaadeu gili,) aama ssiibi uliuli alodahi, ga gaavange gi ana dama daane gi diiloo ange. ");
INSERT INTO nkr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Gai ia ne hai gi dolu laangi e mmao ai olaau magavaa ma Jacob, gai Jacob ne duudagi de hagaloosi ange denga manu a Laban ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Gai Jacob ne duuduu hanu laagau hoou mai i de poplar, ma de almond, aama de plane, gai ia ga isiisi olaadeu gili, ga hai gi ssula mai hanu mommee tea i denga laagau laa. ");
INSERT INTO nkr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Gai ia ne hhao denga laagau gu isiisi laa gi lodo mommee iai vai unu a denga manu. Gai de masavaa naa huu o manu laa e loomai ai e unu, gai gilaadeu e gidee denga laagau laa. Gai de masavaa naa huu olaadeu e loomai ai e unu, gai gilaadeu gu llodo e hagadau loange, ");
INSERT INTO nkr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","gai gilaadeu e hagadau loange i de mommee alaadeu e gidee ai laagau laa, gai alaadeu dama e hagadili gu sissisi, ma de daubulebule, aama de dongidongi. ");
INSERT INTO nkr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Gai Jacob ne vvae gee dama a denga ssiibi, gai ne hai gi huuhuli ange denga ssiibi ange laa, gi denga manu sissisi ma manu uli i de hagabuulingaa ssiibi a Laban. Gai ia ne vvae gee ana manu, tee dugu donu ana manu madali manu a Laban. ");
INSERT INTO nkr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Gai masavaa alodahi o denga manu daane e loange ai gi daho denga manu haahine mmahi laa, gai Jacob ne dugu ange denga laagau gu isiisi laa, gi lo te mommee iai vai unu a denga manu, gai denga manu laa e hagadau loange i gaogao denga laagau gu isiisi laa. ");
INSERT INTO nkr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aagai noo denga manu e baageaa, gai ia tee dugu gilaadeu i de mommee iai laagau gu isiisi laa. Deelaa ai, denga manu baageaa gu nii a Laban, gai manu mmahi gu nii Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Gai Jacob gu hagadagadaga ange donu de lava; gu lagolago ana manu, ma ono haahine ma daane hai hegau, ma gamelo aama donkey. ");
INSERT INTO nkr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Gai Jacob gu langona bolo denga dama daane a Laban e hagataba, “Jacob gu kave mee alodahi a demaadeu damana; gai go goloa o demaadeu damana ne haia ia ga se dangada e lava.” ");
INSERT INTO nkr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Gai Jacob gu gidee bolo Laban gu dee malangilangi i de ia, bei dono hai nogo malangilangi ai laa i de ia i mua. ");
INSERT INTO nkr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Gai Tagi Maolunga ne hai ange gi Jacob, “Ahe gi de henua o doo damana ma daho oo dangada donu, gai au e noho donu madali goe.” ");
INSERT INTO nkr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gai Jacob ne aalu Rachel ma Leah gi loomai gi denga mommee malaelae, go de mommee iai de hagabuulingaa ssiibi, ");
INSERT INTO nkr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","gai ia ga hai ange gi gilaau, “Au gu gidee bolo dooluu damana gu dee malangilangi i de au bei taamada age, gai de Maadua o dogu damana e noho madali au. ");
INSERT INTO nkr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Gooluu e iloo, bolo au ne hai hegau ange gi dooluu damana i ogu mahi alodahi, ");
INSERT INTO nkr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","gai dooluu damana ne vaivai dagodo, ga sui dogu hagaoanga i e madaangahulu hanonga, gai de Maadua tee dugu ange ia gi hagalagohia ina au. ");
INSERT INTO nkr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Gai noo Laban ne hai mai, ‘Denga manu daubulebule go doo hagaoanga,’ gai denga ssiibi alodahi gu haanau mai denga manu daubulebule. Gai de masavaa aana ne hai mai ai, ‘Denga manu sissisi go doo hagao,’ gai denga manu alodahi gu haanau mai denga manu sissisi. ");
INSERT INTO nkr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gai de Maadua gu kave gee manu haangai a dooluu damana, ma gu gaamai gi de au. ");
INSERT INTO nkr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Gai de masavaa o denga manu daane ne loange ai gi denga manu haahine, gai au ne gidee i de midi bolo denga guudi daane e loange laa gi daho denga guudi haahine e sissisi, ma de daubulebule aama de dongidongi. ");
INSERT INTO nkr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Gai tangada de langi o de Maadua ne hai mai gi de au i de midi, ‘Jacob.’ Gai au ga hai ange, ‘Deenei au.’ ");
INSERT INTO nkr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Gai ia ga hai mai, ‘Galo ange diiloo bolo denga guudi daane alodahi e loange laa gi denga manu haahine e sissisi, ma de daubulebule aama de dongidongi, go hiidinga au gu gidee mee alodahi a Laban gu hai adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Go au donu de Maadua o Bethel, go de mommee aau ne llingi ange ai laa de lolo gi dahi duludulu hadu, ma de hai mai dahi hagatoo donu gi de au. Hidi age, ma gi hano gee mai i de henua nei, ga ahe gi de henua o oo dangada donu.’ ”  ");
INSERT INTO nkr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Gai Rachel ma Leah ne pasa ange ga hai ange gi de ia, “Gu deai donu semaau diba aabe se boolonga i de huaabodu o demaau damana! ");
INSERT INTO nkr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ia gu hai donu gimaau be ni dangada henua gee i ono daha. Ia ne hagao gimaau gi daha, gai amaau sseene gu odi donu i dana hai. ");
INSERT INTO nkr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ni muna abodonu, de lava alodahi a de Maadua gu kave gee naa, i daho demaau damana gu niiomaadeu ma amaau dama. Gai koe haia mee alodahi a de Maadua gu tala adu koe gi haia.” ");
INSERT INTO nkr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Gai Jacob ga hidi age ga hagauda ange ana dama ma luoono bodu gi honga denga gamelo. ");
INSERT INTO nkr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Gai ia ne hai ana manu haangai alodahi gi hulo i ono mada i mua, aama ana mee alodahi ne mau i Mesopotamia, e hano ai gi daho dono damana go Isaac i de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","De masavaa o Laban ne hano ai e duuduu huluhulu o ana ssiibi, gai Rachel ne gaiaa denga diinonga a de huaabodu o dono damana. ");
INSERT INTO nkr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Gai Jacob ne doo gaiaa a Laban taane Syria, ia tee tala ange donu bolo ia ga savini e hano. ");
INSERT INTO nkr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Gai ia ne kave ana mee alodahi ga savini ai ga hano, ia ne hano gi de baasi laa o Euphrates, gai ia ne seesee e hano gi de mommee iai duuduu o Gilead. ");
INSERT INTO nkr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Gai dua huu e dolu laangi gai Laban gu langona bolo Jacob gu mmuni ma gu hano ai. ");
INSERT INTO nkr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Gai Laban ne kave ono dangada ga doolohi ai Jacob i e hidu laangi, gai gilaadeu gu daea adu ia i de mommee iai duuduu o Gilead. ");
INSERT INTO nkr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Gai de Maadua ne hakide ange gi Laban, taane Syria i de midi, i de boo laa, ga hai ange gi de ia, “Koe kana ange gi au muna e basa ange ai gi Jacob, e dee hilihili be e danuaa aabe e baubau.” ");
INSERT INTO nkr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","De masavaa a Laban ne daea adu ai Jacob, gai a Jacob gu hagaduu dono hale malo i de mommee iai mounga, gai Laban ma ono dangada ne hagatuu hogi olaadeu hale malo i de mommee laa. ");
INSERT INTO nkr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Gai Laban ne hai ange gi Jacob, “Se hegau bee hee aau gu hai nei? Koe ne doo gaiaa au ga mmuni ga hano, ga kave agu damaa hine bei dagodo o dangada ne hagadee kii ina i de hebagi. ");
INSERT INTO nkr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gu aha gu mmuni ai laa goe e hano ai, ma de doo gaiaa au, gai tee tala mai gi de au, gai au ga hai ai taonga e malangilangi ai ma de daahili aama hagadangidangi i denga tambourine ma harp, i mua dagu dugu goe gi hano? ");
INSERT INTO nkr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Gai koe tee dugu mai hogi gi maua e au i de oso ogu mogobuna ma luaagu damaa hine e hagaboo ai gimaadeu. Koe ne hai hegau be se dangada lodo senga. ");
INSERT INTO nkr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Au e maua donu i de hagalagohia goe, aagai de Maadua o doo damana ne hai mai gi de au anaboo, ‘Koe gi kana ange gi au muna e basa ai gi Jacob, e dee hilihili be e danuaa aabe e baubau.’ ");
INSERT INTO nkr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Koe ne hano gee i hiidinga koe gu buliaamoou i dangada i doo huaabodu, aagai gu aha goe gu gaiaa ai laa ogu diinonga?” ");
INSERT INTO nkr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Gai Jacob ne basa ange ga hai ange gi Laban, “Au ne manavasaa, i dagu maanadu bolo koe e kave gee luaau damaa hine mai i ogu daha. ");
INSERT INTO nkr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aagai noo koe e gidee oo diinonga i daho dahi dangada, gai tangada laa e daa donu gi magau. Gai koe saalaa gi gidee i madamada o odaau dangada be e hanu au mee e gidee i ogu daha, gai koe ga kave.” Gai Jacob tee iloo donu bolo go Rachel ne gaiaadia denga diinonga laa. ");
INSERT INTO nkr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Gai Laban ga ulu gi lo te hale malo o Jacob, ma de hale malo o Leah, ma de hale malo o luu haahine hai hegau, gai ia tee gidee ono diinonga. Gai ia ga sao mai i lo te hale malo o Leah ga hano ga ulu gi lo te hale o Rachel. ");
INSERT INTO nkr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Gai Rachel gu lava i de kave denga diinonga laa, ma gu velo ange gi lo te mee e nnoho ange ai tangada gi honga de gamelo, ga noho ange aagena. Gai Laban ne ssala hogi i lo te hale malo laa, gai teai donu ana mee ne gidee. ");
INSERT INTO nkr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Gai Rachel ga hai ange gi dono damana, “Dogu dangada aamua, koe gi dee lili i dogu dee maua i de duu age i oo mada i mua, go hiidinga au gu hai magi o denga haahine”. Gai Laban ne ssala hogi i kilaa, gai tee gidee e ia ono diinonga. ");
INSERT INTO nkr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Gai Jacob gu lili mmao, gai ia ga hagadaumee ange gi Laban. Gai Jacob ne basa ange, ga hai ange gi Laban, “Se baubau aha aagu gu hai laa? Gai se haisala aha aagu gu hai adu gi de goe, gai koe ga doolohi mai ai nei au? ");
INSERT INTO nkr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Koe ne humai ga huli saele ogu goloa alodahi; gai ne dahi laa oo goloa daudahi aau ne gidee i magavaa o ogu goloa? Gaamai be ni aha aau ne gidee, dugua i mada i mua o odaau daina, gai gilaadeu ga hagamodu ai odaau muna. ");
INSERT INTO nkr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Gai gu madalua ogu ngadau ne noho ai i oo daha, gai au ssiibi ma guudi haahine tee maakau donu alaadeu dama, gai au tee gai hogi dahi ssiibi daane daudahi i au manu. ");
INSERT INTO nkr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Gai au tee gaamai donu gi de goe denga manu ne daia ga maakau i denga manu lodo henua; gai ne dau mai donu huu mee nei gi de au. Gai koe ne hai au gi suuia adu mee ne gaiaadia i de laangi be go de boo. ");
INSERT INTO nkr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gai ogu dagodo: au ne duasala i dogu diingia i de laangi, gai ne magalili i de boo, gai au tee seni i de boo. ");
INSERT INTO nkr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Au ne noho madali goe i doo hale i e madalua ngadau. Au ne hai hegau adu gi de goe i e madaangahulu ma haa ngadau, i hiidinga o luaau damaa hine, gai ne tilo ange au manu i e ono ngadau, gai koe ne sui dogu hagaoanga i e madaangahulu hanonga. ");
INSERT INTO nkr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gai noo de Maadua o dogu damana tee noho madali au, go de Maadua o Abraham, go de ia o Isaac e madagu ai laa, gai koe ne hai donu huu au gi ngadi hano. Aagai de Maadua gu gidee dogu hai ngadaa ma dogu hai hegau hagaduasala, gai ia gu hagasee goe anaboo.” ");
INSERT INTO nkr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Gai Laban ne hai ange gi Jacob, “Luu damaa hine nei niiagu, denga dama nei niiagu, gai denga hagabuulingaa manu nei niiagu. Mee alodahi aau e gidee nei niiagu. Gai ni aha naa aagu e maua i de hai ange gi luaagu damaa hine, aabe go denga dama alaau gu haanau nei? ");
INSERT INTO nkr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Deenei ai, humai, gidaau ga hai dahi hagatoo donu hagaheloongoi i odaau magavaa.” ");
INSERT INTO nkr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Gai Jacob ga kave dahi hadu ga hagaduu age e hai ai dahi duludulu hagamaanadu. ");
INSERT INTO nkr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Gai Jacob ga hai ange gi ono dangada, “Goodou hagabudulia mai hanu hadu.” Gai gilaadeu ga hagabudu mai hanu hadu ga hai ai dahi hagabuudungaa hadu, gai gilaadeu ga nnoho ga gaimee, i gaogao de hagabuudungaa hadu laa. ");
INSERT INTO nkr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Gai Laban ne hagaingoo ange de hagabuudungaa hadu laa go Jegar Sahadutha, gai Jacob ne hagaingoo ange de hagabuudungaa hadu laa go Galeed. ");
INSERT INTO nkr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Gai Laban ne hai ange, “De hagabuudungaa hadu nei se mee hagadonu ai de hagatoo donu i odaau magavaa anailaa nei.” Deelaa ai, gu hagaingoo ange go Galeed. ");
INSERT INTO nkr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Gai ne hagaingoo ange hogi go Mizpah, go hiidinga ia ne hagadaba, “Tagi Maolunga gi dagidiiloo gidaau i de masavaa odaau e mavaevae ai. ");
INSERT INTO nkr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Gai noo koe gu vaivai hai luaagu damaa hine, aabe e hai bodu ange hanu haahine gee, e dee go luaagu damaa hine, gai e dee galemu naa donu teai dangada madali gidaau, gai go de Maadua donu e hagadonu ai mee i odaau magavaa.” ");
INSERT INTO nkr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Gai Laban ga hai ange gi Jacob, “Galo ange diiloo de hagabuudungaa hadu nei, ma tuludulu aagu gu hagaduu nei i odaau magavaa. ");
INSERT INTO nkr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","De hagabuudungaa hadu nei se mee hagadonu ai, gai tuludulu nei se mee e hagadonu ai bolo au e dee hanadu gi ui adu gi de baasi naa, gai koe e dee humai gi ui mai gi de baasi nei o de hagabuudungaa hadu ma tuludulu nei, e hai baasi mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Gai de Maadua o Abraham ma Nahor, go de Maadua o delaau damana gi hagamodu ina mee i odaau magavaa.” Gai Jacob ne hagatoo donu i de ia o Isaac e madagu ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Gai ia ga hai dahi sigidaumaha i honga de mounga laa, ga hagahi ono dangada gi loomai e gaimee. Gai dua delaadeu gaimee, gai gilaadeu ne noho i kilaa i de boo laa. ");
INSERT INTO nkr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Gai Laban ne oho age i taiao ga oso ono mogobuna aama luaana damaa hine, ga hagamanuuia gilaadeu, gai ia ga aahe gi dono mommee donu. ");
INSERT INTO nkr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Gai ga hano gee huu Jacob i kilaa, gai hanu dangada de langi o de Maadua gu hedae ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Gai ga gidee huu e Jacob gilaadeu, gai ia ga hagadaba, “Deenei de hagabuulinga hebagi o de Maadua!” Gai ia ne hagaingoo ange de mommee laa go Mahanaim. ");
INSERT INTO nkr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Gai Jacob ne hai hanu dangada gi hulo i ono mada i mua, gi daho dono daina go Esau i de ungaamee go Seir, i de henua go Edom. ");
INSERT INTO nkr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Gai ia ne hai ange gi gilaadeu, “Goodou hulo hai ange gi dogu dangada aamua go Esau, ‘Doo dangada hai hegau go Jacob e hagadaba: Au nogo noho i daho Laban ga dae mai ai gi iainei; ");
INSERT INTO nkr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","gai gu lagolago agu kaau, ma agu donkey, ma agu ssiibi, ma ogu daane ma haahine hai hegau, gai au ne aalu adu muna nei gi de goe, dogu dangada aamua, gai koe ga abodonu mai ai gi de au.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Gai ga aahe mai huu de gau hagailoo laa gi daho Jacob, gai gilaadeu ga hai ange, “Gimaadeu ne hulo gi daho doo daina go Esau, gai ia gu humai e hedae adu gi de goe, gai e haalau daane e loomai madali ia.” ");
INSERT INTO nkr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Gai Jacob gu madagu mmao ma de manavasaa ono lodo, gai ia ga vvae dangada madali ia, ga hai ai e lua hagabuulinga, madali denga ssiibi ma kaau aama gamelo. ");
INSERT INTO nkr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ia ga maanadu i ono lodo, “Noo Esau e humai ga hebagi ange gi dahi hagabuulinga, gai de hagabuulinga ange laa e maua i de saavini e hagaola gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Gai Jacob ne dalodalo ga hai ange, “De Maadua o dogu dubuna go Abraham, ma de Maadua o dogu damana go Isaac, go Tagi Maolunga, koe ne hai mai gi de au, ‘Ahe gi doo henua ma daho oo dangada, gai au e hai naa gi hagadagadaga age goe.’ ");
INSERT INTO nkr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au e dee bau ange gi doo abodonu mai gi de au ma doo hai hegau mai gi de au i de mee abodonu, doo dangada hai hegau. Dogu masavaa ne humai ai laa lo te saalingaa vai go Jordan gai se dogo donu huu aagu e dahi, aagai iainei au gu hai ai e lua hagabuulingaa dangada. ");
INSERT INTO nkr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au e dangidangi adu, koe gi hagaola ina au mai i dogu daina go Esau, go hiidinga au e madagu ia kana humai ga hebagi mai gi gimaadeu ma denga dinana aama denga gauligi. ");
INSERT INTO nkr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Aagai koe ne hai mai, ‘Au e abodonu adu naa gi de goe, ma de hai gi soa doo aamuli gi bei de lagolago o denga gelegele i gabugabu tai, e dee maua laa i de dau.’ ”  ");
INSERT INTO nkr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Gai Jacob ne noho i kilaa i de boo laa. Gai ia ne hili hanu mee e hai ai dahi mee ngadi gaavange maa dono daina go Esau: ");
INSERT INTO nkr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","e lualau guudi haahine, e madalua guudi daane, e lualau ssiibi haahine, e madalua ssiibi daane; ");
INSERT INTO nkr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","e matolu gamelo haahine ma alaadeu dama, e madahaa kaau haahine, e madaangahulu kaau daane, e madalua donkey haahine ma e madaangahulu donkey daane. ");
INSERT INTO nkr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Gai ia ga vaevae ga gaavange gi ono dangada hai hegau. Gai ia ga hai ange gi gilaadeu, “Goodou loadu i ogu mada i mua, gai haia gi mavaevae magavaa o denga hagabuulingaa manu.” ");
INSERT INTO nkr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Gai ia ne hai ange gi taane e dagina: “De masavaa naa huu o dogu daina go Esau e hedae adu ai gi goodou, gai ia ga ssili adu, ga hai adu, ‘Goodou ni dangada hai hegau niioai? Gai ga hulo naa goodou gi hee? Gai niiai denga manu e hulo nei i oodou mada i mua?’, ");
INSERT INTO nkr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","gai goodou ga hai ange, ‘Mee nei nii doo dangada hai hegau go Jacob, gai se ngadi gaavange ne gaamai gi de goe, Esau, dono dangada aamua, gai ia e humai i omaadeu dua.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Gai Jacob ne tala ange hogi muna nei gi de lua hagabuulinga, ma tolu hagabuulinga aama gilaadeu alodahi e daudali mai i dua o denga hagabuulingaa manu, ga hai ange, “Goodou daalaa ange hogi muna nei gi Esau i doodou hedae ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Gai goodou ga hai ange hogi, ‘Tilo, doo dangada hai hegau go Jacob e humai i omaadeu dua.’ ” Gai Jacob ne maanadu i ono lodo, “Au e hai naa gi sili dono lili i denga ngadi gaavange e kave nei i ogu mada i mua; gai dua naa huu mee nei, gai agu made Esau e abodonu mai naa gi de au, i demaau hedae.” ");
INSERT INTO nkr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gai denga mee ngadi gaavange a Jacob ne hulo i ono mada i mua, aagai ia ne noho i de mommee nnoho gaainga i de boo laa. ");
INSERT INTO nkr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","De boo laa gai Jacob ne hidi age ga kave luoono bodu, ma luoono haahine hai hegau, ma ana dama daane e dinoangahulu ma dogodahi ga hulo ai laa lo te saalingaa vai go Jabbok gi de baasi laa. ");
INSERT INTO nkr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Gai ia ne hai gilaadeu gi hulo gi de baasi gee o de vai madali denga goloa. ");
INSERT INTO nkr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Gai go Jacob donu huu e noho i kilaa. Gai dahi daane ne daudau ma ia ga dae ai gi de ao de mee. ");
INSERT INTO nkr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Gai ga gidee huu e taane laa bolo ia gu dee bau ange gi Jacob, gai ia ga poo ange gi ssuguinga o dono gauanga, gai de gauanga o Jacob gu maaguluaa, i de masavaa oona ne daudau ange ai gi taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Gai taane laa ga hai ange, “Dugua au gi hano, go hiidinga gu maalama age.” Aagai Jacob ga hai ange, “Au e dee dugu donu goe gi hano ga dae ai gi dau hagamanuuia au.” ");
INSERT INTO nkr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Gai ia ne ssili ange gi de Jacob, “Goai doo ingoo?” Jacob ne hai ange, “Go Jacob.” ");
INSERT INTO nkr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Gai ia ga hai ange, “Koe gu dee hagaingoo ange go Jacob, aagai go Israel, go hiidinga koe gu daudau ange gi de Maadua ma dangada, gai koe gu kii.”  ");
INSERT INTO nkr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Gai Jacob ga sili ange ga hai ange, “Aude haihaia, daalaa mai be goai doo ingoo?” Aagai ia ne hai ange, “Gu aha gu ssili mai ai naa goe dogu ingoo?” Gai ia ga hagamanuuia Jacob i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gai Jacob ga hagaingoo ange de mommee laa go Peniel, go hiidinga ia e hagadaba, “Au gu gidee luu mada o de Maadua, gai au tee magau.” ");
INSERT INTO nkr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Gai de masavaa oona ne seesee ai e hano gee i Penuel gai gu sula age de laa, gai ia gu hagadodi i hiidinga o dono gauanga gu maaguluaa. ");
INSERT INTO nkr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Deelaa ai, de gau Israel e dee gai kano e pigi ange laa gi de uaua e duudagi ina laa de gauanga ma de vae ga dae mai ai gi anailaa nei, go hiidinga ia ne poo ange ssuguinga o de gauanga o Jacob i de mommee iai de uaua laa. ");
INSERT INTO nkr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Gai Jacob ne dangage age gu gidee adu e ia Esau e humai madali e haalau daane. Gai ia ga vaevae dama a Leah, ma dama a Rachel, ma dama a luu haahine hai hegau. ");
INSERT INTO nkr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Gai ia ga hai luu haahine hai hegau ma alaau dama gi hulo i mua, gai ono dua go Leah ma ana dama, gai Rachel ma Joseph e hagaodia. ");
INSERT INTO nkr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Gai ia ne hano i olaadeu mada i mua ga ino gi honga de gelegele i e hidu hanonga, ga dae ai gi dono hano ga baa ange gi dono daina daane. ");
INSERT INTO nkr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aagai Esau ne savini mai ga hedae ange gi Jacob, ga buuludi ange ia ga oso ia, gai gilaau gu tangi. ");
INSERT INTO nkr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Gai Esau ne gidee e ia denga haahine ma gauligi laa, gai ia ga ssili ange, “Goai aanei ne loomai nei madali goe?” Jacob ne hai ange, “Gilaadeu go dama a de Maadua ne abodonu mai ai gi de au, doo dangada hai hegau.” ");
INSERT INTO nkr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Gai luu haahine hai hegau ma alaau dama ne loomai ga ino gi lalo i mada i mua o Esau. ");
INSERT INTO nkr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Gai Leah ma ana gauligi ne loomai hogi ga ino gi lalo i ono mada i mua, gai muli mai gai Joseph ma Rachel ne loomai hogi ga ino ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Gai Esau ne ssili ange, “Ni hagabuulingaa manu aha gu tae mai nei gi ogu daha?” Jacob ne hai ange, “Dogu dangada aamua, mee naa ni mee e hai gi abodonu mai ai goe gi de au.” ");
INSERT INTO nkr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Aagai Esau ne hai ange, “Dogu daina, au e lagolago donu agu mee, hagaahea adu au mee.” ");
INSERT INTO nkr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob ne hai ange, “Aude haihaia, noo koe gu degi mai gi de au, gai koe gaavee dagu mee ngadi gaavange. Go hiidinga dagu gidee goe e bei donu au gu gidee luu mada o de Maadua, i hiidinga koe gu malangilangi i de au. ");
INSERT INTO nkr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Aude haihaia, gaavee dagu mee ngadi gaavange gu gaamai nei gi de goe, go hiidinga de Maadua gu abodonu mai gi de au, ma gu gaamai gi de au mee alodahi oogu e mouli ai.” Gai ia ga usuusu ange ia, gai Esau ga kave mee laa. ");
INSERT INTO nkr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Gai Esau ne hai ange, “Gidaadeu ga seesee e hulo; gai go au e hano i oo mada i mua.” ");
INSERT INTO nkr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Gai Jacob ga hai ange gi de ia, “Dogu dangada aamua e iloo bolo denga gauligi e baageaa, gai au e manavasaa i denga ssiibi ma kaau goi hakaa unuunu laa alaadeu dama. Noo e hai gi gona odi delaadeu seesee i dahi laangi, gai gilaadeu alodahi e odi donu i de maakau. ");
INSERT INTO nkr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Dogu dangada aamua, au e dangidangi au, hannoo i mada i mua o doo dangada hai hegau, gai au ga seesee maalie adu madali denga manu aama denga gauligi ga dae ai gi dogu hanadu ga dae adu gi oo daha i Seir.” ");
INSERT INTO nkr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau ne hai ange, “Au e lodo e dugu hanu ogu daane gi nnoho madali.” Jacob ne hai ange, “Gai ni haigamaiana aha naa delaadeu nnoho? Dogu dangada aamua, koe gi abodonu mai donu huu gi de au.” ");
INSERT INTO nkr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Gai Esau ne ahe i de laangi laa ga hano gi Seir. ");
INSERT INTO nkr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Aagai Jacob ne hano gi Succoth, ga hagaduu ai dahi hale e noho ai ia, ma hanu baasi hale moo ana manu. Deelaa ai, de mommee laa gu hagaingoo ange go Succoth. ");
INSERT INTO nkr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Gai Jacob ne hano ga dae gi de aduhale go Shechem, i Canaan, i de masavaa oona ne ahe mai ai i Mesopotamia, gai ia ga hagaduu dono mommee noho gaainga i gaogao de aduhale. ");
INSERT INTO nkr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Gai ia ne hagao dahi alahenua i daho denga dama a Hamor, tamana o Shechem i e lau dibaa sseene, go kilaa aana ne hagaduu ai dono hale malo. ");
INSERT INTO nkr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Gai ia ne bae dahi mommee o ssigidaumaha i kilaa, ga hagaingoo ange go El Elohe Israel. ");
INSERT INTO nkr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Gai Dinah, tamaa hine a Leah ange gi Jacob, ne hano e hagadaahao gi daho denga damaa hine o de henua laa. ");
INSERT INTO nkr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Gai Shechem, tama daane a Hamor taane Hiv, de hodooligi o de henua laa ne hedae ange gi de ia, gai ia ga hai gi de mahi Dinah, ga dagodo haisala ma ia. ");
INSERT INTO nkr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Gai ia gu kona donu dono vaasuu i Dinah, tamaa hine a Jacob; ia gu aloha i tamaa hine laa, ga basa maamaane ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Gai Shechem ne hai ange gi dono damana go Hamor, “Gaamai tamaa hine nei e hai ai dogu bodu.” ");
INSERT INTO nkr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Gai Jacob gu langona bolo Shechem gu dagodo haisala ma dana damaa hine go Dinah. De masavaa laa gai ana dama daane e hagaloosi ana manu i lodo henua; gai ia ne noho ga dee muu ga dae ai gi de aahe mai o ana dama. ");
INSERT INTO nkr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Gai tamana o Shechem go Hamor ne humai e basa ange ai gi Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Gai denga dama daane a Jacob ne hagamoolau ga aahe mai i lodo henua, i de masavaa alaadeu ne langona ai mee laa. Gai gilaadeu gu kona donu de daemaha ma de llili, i hiidinga o de hegau baubau a Shechem gu hai ange gi Israel, i dono dagodo haisala ma tamaa hine a Jacob — gai se mee donu e dee hai. ");
INSERT INTO nkr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Aagai Hamor ne hai ange gi gilaadeu, “Dagu dama daane go Shechem gu lodo mmao i doodou damaa hine; au e dangidangi adu, gaavange tamaa hine naa e hai ai dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Gidaadeu ga hagadau hagahai bodu i odaadeu magavaa; goodou gaamai gi gimaadeu oodou damaa hine, gai goodou ga kave amaadeu damaa hine e hai ai oodou bodu. ");
INSERT INTO nkr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Gai goodou ga nnoho i omaadeu magavaa; gai de henua gu mahuge adu gi goodou. Gai goodou ga nnoho i de henua, ga hagao mee ai, ma de hagao ai hanu alahenua moodou.” ");
INSERT INTO nkr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Gai Shechem ne hai ange gi tamana ma daina daane o tamaa hine laa, “Noo goodou e abodonu mai gi de au, gai be se aha naa huu oodou e llodo ai, gai au e gaavadu donu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Goodou daalaa mai be dee hee maa de hagaoanga, ma de mee ngadi gaavange aagu e gaavadu, gai au ga gaavadu donu gi bei doodou mee e llodo ai, aagai goodou gaamai doodou damaa hine e hai ai dogu bodu.” ");
INSERT INTO nkr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Gai denga dama a Jacob tee tala ange de muna abodonu gi Shechem ma dono damana go Hamor, go hiidinga ia ne dagodo haisala ma delaadeu daina hahine go Dinah. ");
INSERT INTO nkr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Gai gilaadeu ga hai ange gi gilaau, “Gimaadeu e dee maua i de hai de hegau nei; gimaadeu e dee maua i de gaavange demaadeu daina hahine, gi dahi daane e dee tuu dagaholiage. De mee nei se mee donu hakino gee i omaadeu daha. ");
INSERT INTO nkr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Gai deenei doodou mee e hai gi maua ai e gimaadeu i de buni adu gi goodou: goodou haia gi bei omaadeu dagodo, ga tuu dagaholiage oodou daane alodahi, ");
INSERT INTO nkr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","gai gimaadeu ga gaavadu gi goodou amaadeu damaa hine, gai gimaadeu ga hai bodu ange gi oodou damaa hine. Gimaadeu e nnoho naa hogi i oodou daha, gai gidaadeu gu se huaadangada e dahi. ");
INSERT INTO nkr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Aagai noo goodou e dee llodo e tuu dagaholiage, gai gimaadeu e kave naa demaadeu damaa hine ga hulo gee ai.” ");
INSERT INTO nkr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Gai alaadeu muna gu heohi ange gi lodo o Hamor ma Shechem, tama daane a Hamor. ");
INSERT INTO nkr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Gai tama daane laa, go tama hugadoo hagadubu i de huaabodu o dono damana, ne hagamoolau ga hagassula mee laa alodahi, go hiidinga ia gu kona donu dono malangilangi i tamaa hine a Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Gai Hamor ma dana dama daane go Shechem, ne hulo gi de haitoga o de aduhale, ga pasa ange ai gi denga daane o delaau aduhale, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Denga daane nei gu hagaheloongoi mai gi gidaadeu. Deenei ai, gidaadeu ga dugua ange gilaadeu gi nnoho i de henua gi hagao mee ai; de henua e dohu ange donu gi delaadeu nnoho ai. Gidaadeu e maua i de hai bodu ange gi alaadeu damaa hine, gai gilaadeu e maua i de hai bodu ange gi adaadeu damaa hine. ");
INSERT INTO nkr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Aagai deenei donu huu de mee alaadeu e llodo gidaadeu gi haia, gi maua ai e gilaadeu i de nnoho madali gidaadeu, gai gidaadeu gu se huaadangada e dahi: odaadeu daane alodahi e tuu dagaholiage bei olaadeu dagodo. ");
INSERT INTO nkr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","E aha, alaadeu manu haangai ma olaadeu goloa alodahi e dee hai naa ga niiodaadeu? Gidaadeu gi buni ange gi olaadeu mee e llodo ai, gi nnoho ai gilaadeu madali gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Gai denga daane alodahi ne hulo laa gi de haitoga o de aduhale ne buni ange gi muna a Hamor ma dana dama go Shechem, gai daane alodahi i de aduhale gu tuu dagaholiage. ");
INSERT INTO nkr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Gai dua huu e dolu laangi, i de masavaa goi mmae olaadeu maanuga, gai Simeon ma Levi, luu dama daane a Jacob, go luu daina daane o Dinah, ne kave luaalaau gadilaasa ga hulo ai gi lo te aduhale ga daa ai denga daane alodahi gu maakau, gai dangada tee angahia donu de hai mee nei. ");
INSERT INTO nkr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Gai gilaau ne daa hogi Hamor, ma Shechem, dana dama daane, gai ga kave Dinah mai i de hale o Shechem ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Gai denga dama daane a Jacob ga hulo gi de mommee gu maakau ai denga daane ga kave ai goloa o de aduhale laa, go hiidinga gilaadeu ne hai gi de mahi delaadeu daina hahine. ");
INSERT INTO nkr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Gai gilaadeu ne kave denga ssiibi ma kaau, ma donkey, aama goloa i lo te aduhale ma mee i tua de aduhale, ");
INSERT INTO nkr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ma alaadeu mee alodahi ma alaadeu dama, ma olaadeu bodu, aama mee alodahi i lodo hale ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Gai Jacob ga hai ange gi Simeon ma Levi, “Gooluu gu hagahai ngadaa au ma de hai gi kino dangada o de henua nei i de au, go de gau Canaan ma de gau Perez. Au e sogoisi ogu daane, gai noo gilaadeu e hagabuni e hebagi mai gi de au, gai gilaadeu e daa donu au ma dogu huaabodu ga maakau.” ");
INSERT INTO nkr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Aagai gilaadeu ga hai ange, “E aha, se mee heohi delaadeu hai demaadeu daina hahine bei dagodo o dahi hahine hai be se manu?” ");
INSERT INTO nkr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Gai de Maadua ga hai ange gi Jacob, “Hidi age hannoo gi Bethel noho ai; gai koe ga bae ai dahi mommee o ssigidaumaha ange gi de Maadua, ne hakide adu laa gi de goe i de masavaa oou ne savini ai ga hano gee mai i doo daina daane go Esau.” ");
INSERT INTO nkr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Gai Jacob ne hai ange gi dono huaabodu, ma dangada alodahi madali ia, “Goodou dilia denga diinonga i oodou daha naa, ma de hagagilimalali goodou ga sui oodou malo. ");
INSERT INTO nkr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Gai gidaadeu ga hulo gi Bethel, gai au ga bae dahi mommee o ssigidaumaha ange gi de Maadua i kilaa, go de ia ne balea mai au i de masavaa oogu ne duasala ai, gai ia ne noho madali au i mommee alodahi oogu ne hano aagena.” ");
INSERT INTO nkr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Gai gilaadeu ga gaavange gi Jacob denga diinonga alodahi ma buulei i olaadeu dalinga; gai Jacob ga danu mee laa i lalo de oak i gaogao o Shechem. ");
INSERT INTO nkr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Gai ga seesee huu gilaadeu e hulo, gai de madagu o de Maadua gu hano iho gi honga o dangada i denga aduhale i olaadeu gaogao alodahi, deelaa ai, teai donu dangada ne dolohia dama a Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Gai Jacob ma dangada alodahi madali ia ga hulo gu tae gi Luz (e bei go Bethel) i de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Gai ia ga bae dahi mommee o ssigidaumaha i kilaa, gai ia ga hagaingoo ange de mommee laa go El Bethel, i hiidinga go kilaa o de Maadua ne hakide ange ai gi de ia, i de masavaa oona ne savini ai ga hano gee mai i dono daina. ");
INSERT INTO nkr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Gai de hine hai hegau o Rebekah go Deborah ne magau ga danu i kilaa, i lalo dahi oak i Bethel, deelaa ai, de mommee laa gu hagaingoo ange go Allon Bacuth. ");
INSERT INTO nkr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Gai dua huu de ahe mai o Jacob i Mesopotamia, gai de Maadua ga hakide ange hogi gi de ia ga hagamanuuia ia. ");
INSERT INTO nkr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Gai de Maadua ne hai ange gi de ia, “Iainei gai doo ingoo go Jacob, aagai doo ingoo gu dee go Jacob. Gai koe gu hagaingoo ange go Israel.” Gai ia ga hagaingoo ange ia go Israel. ");
INSERT INTO nkr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Gai de Maadua ga hai ange gi de ia, “Go au go El-Shaddai; koe gi hagadili gi soa. Dahi huaahenua ma de huaadangada soa e humai naa i oo daha, gai koe e hagadili naa denga hodooligi. ");
INSERT INTO nkr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Gai de henua aagu ne gaavange laa gi Abraham ma Isaac, au e gaavadu naa gi de goe, gai au e gaavange naa gi doo aamuli e loomai i oo dua de henua nei.” ");
INSERT INTO nkr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Gai de Maadua ga ahe age ⌊gi de langi⌋ mai i daho Jacob i de mommee oona ne basa ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Gai Jacob ga hagaduu age dahi duludulu hadu i de mommee o de Maadua ne basa ange ai gi de ia, ga llingi ange gi ono elunga ssigidaumaha o mee unu aama lolo. ");
INSERT INTO nkr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Gai Jacob ga hagaingoo ange de mommee o de Maadua ne basa ange ai laa gi de ia go Bethel. ");
INSERT INTO nkr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Gai gilaadeu ne loomai i Bethel. Gai de masavaa olaadeu goi mmao ai i Ephrath, gai Rachel gu hai ono hagalangona, gai ne hai ngadaa mmao dono haanau. ");
INSERT INTO nkr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Gai de masavaa ne kona ai ono hagalangona, gai de hine hagahaanau ga hai ange gi de ia, “Aude madagu, koe gu haanau ange hogi dahi dama daane.” ");
INSERT INTO nkr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Gai de masavaa huu o Rachel ne dai magau ai, gai ia ga hagaingoo ange dana dama go Ben-Oni, aagai dono damana ne hagaingoo ange ia go Benjamin. ");
INSERT INTO nkr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Gai Rachel ne magau ga danu i gaogao de haiava e hano laa gi Ephrath (e bei go Bethlehem). ");
INSERT INTO nkr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Gai Jacob ne hagaduu dahi hadu i honga dono daanunga. Gai de hadu o taanunga o Rachel goi duu donu huu ga dae mai ai gi anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Gai Israel ne ngalue mai hogi i kilaa ga hagaduu dono hale malo i de baasi gee o hale dagitilo go Eder. ");
INSERT INTO nkr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","De masavaa o Israel e noho ai i de henua laa, gai Reuben ne hano ga dagodo haisala ma Bilhah, dahi bodu laa daha o dono damana, gai Israel gu langona e ia. Gai Jacob e dinoangahulu ma dogolua ana dama daane: ");
INSERT INTO nkr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Dama a Leah: go Reuben, tama madua a Jacob, ma Simeon, ma Levi, ma Judah, ma Issachar aama Zebulun. ");
INSERT INTO nkr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Dama a Rachel: go Joseph ma Benjamin. ");
INSERT INTO nkr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Dama a Bilhah, de hine hai hegau o Rachel: go Dan, ma Naphtali. ");
INSERT INTO nkr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dama a Zilpah, de hine hai hegau o Leah: go Gad, ma Asher. Aanei dama ne haanau ange gi Jacob i Mesopotamia. ");
INSERT INTO nkr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Gai Jacob ga hano gu dae gi daho dono damana go Isaac i Mamre o Kiriath Arba (e bei go Hebron), gai go kilaa hogi o Abraham ma Isaac ne nnoho gaainga ai. ");
INSERT INTO nkr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Gai ne 180 ngadau o Isaac ne mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Gai ia ne magau i de masavaa oona gu madumadua ai, gai ne daulooloa dono mouli, gai ia ne hagabuni madali ono dangada. Gai luaana dama daane go Esau ma Jacob ga danu ia. ");
INSERT INTO nkr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aanei hagadiilinga o Esau (e bei go Edom). ");
INSERT INTO nkr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ne hai bodu ange gi hanu hine o Canaan: go Adah, tamaa hine a Elon taane Heth, ma Oholibamah, tamaa hine a Ana gai de mogobuna hahine o Zibeon taane Hiv, ");
INSERT INTO nkr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ma Basemath, tamaa hine a Ishmael, se daina hahine niio Nebaioth. ");
INSERT INTO nkr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Gai Adah ne haanau ange gi Esau Eliphaz, gai Basemath ne haanau Reuel. ");
INSERT INTO nkr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Gai Oholibamah ne haanau Jeush, ma Jalam, ma Korah; aanei denga dama ne haanau ange gi Esau i de henua o Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Gai Esau ne kave ono bodu, ma ana dama daane ma damaa hine, ma dangada alodahi i dono hale, ma ana hagabuulingaa manu, aama ono goloa alodahi ne mau i de henua go Canaan, ga hano ai gi dahi henua e mmao gee mai i dono daina daane go Jacob, ");
INSERT INTO nkr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","go hiidinga olaau goloa gu kona mmao de lagolago, gai gilaau gu dee maua i de nnoho i de mommee daudahi, gai de henua olaau e nnoho gaainga ai laa gu dee dohu ai gilaau, i hiidinga o alaau hagabuulingaa manu. ");
INSERT INTO nkr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Gai Esau (e bei go Edom) ne noho i de mommee iai duuduu i Seir. ");
INSERT INTO nkr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Gai aanei hagadiilinga o Esau, tamana o de gau Edom, e nnoho laa i de henua iai duuduu o Seir. ");
INSERT INTO nkr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aanei ingoo o dama daane a Esau: go Eliphaz, tama daane a de bodu o Esau go Adah, ma Reuel, tama daane a Basemath, de bodu o Esau ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dama daane a Eliphaz: go Teman, ma Omar, ma Zepho, ma Gatam aama Kenaz. ");
INSERT INTO nkr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Gai Eliphaz, tama daane a Esau, e dahi hogi ono bodu laa daha, go Timna, ia ne haanau Amalek. Aanei mogobuna o Adah, de bodu o Esau. ");
INSERT INTO nkr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Aanei dama daane a Reuel: go Nahath, ma Zerah, ma Shammah, aama Mizzah. Aanei mogobuna o Basemath, de bodu o Esau. ");
INSERT INTO nkr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aanei dama daane a de bodu o Esau go Oholibamah, tamaa hine a Anah gai de mogobuna o Zibeon, go dama aana ne haanau ange gi Esau: go Jeush, ma Jalam, aama Korah. ");
INSERT INTO nkr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Gai aanei dagi o hagadiilinga o Esau: De hagadiilinga o Eliphaz, tama madua a Esau: Denga dagi go Teman, ma Omar, ma Zepho, ma Kenaz, ");
INSERT INTO nkr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ma Korah, ma Gatam, aama Amalek. Aanei dagi o hagadiilinga o Eliphaz i Edom; gilaadeu nei go mogobuna o Adah. ");
INSERT INTO nkr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","De hagadiilinga o Reuel, tama a Esau: Denga dagi go Nahath, ma Zerah, ma Shammah, aama Mizzah. Aanei dagi o de hagadiilinga o Reuel i Edom; gilaadeu nei go mogobuna o Basemath, de bodu o Esau. ");
INSERT INTO nkr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","De hagadiilinga o Oholibamah, de bodu o Esau: Denga dagi go Jeush, ma Jalam, aama Korah. Aanei dagi o hagadiilinga o de bodu o Esau go Oholibamah, tamaa hine a Anah. ");
INSERT INTO nkr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aanei dama daane a Esau (e bei go Edom) ma olaadeu dagi. ");
INSERT INTO nkr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aanei dama daane a Seir, taane Hor, go dangada e nnoho i de henua laa: go Lotan, ma Shobal, ma Zibeon, ma Anah, ");
INSERT INTO nkr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ma Dishon, ma Ezer, aama Dishan. Aanei dama daane a Seir i de henua go Edom, gai ni dagi niio de gau Hor. ");
INSERT INTO nkr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Dama daane a Lotan: go Hori, ma Homam. Gai taina hahine o Lotan go Timna. ");
INSERT INTO nkr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Dama daane a Shobal: go Alvan, ma Manahath, ma Ebal, ma Shepho, aama Onam. ");
INSERT INTO nkr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Dama daane a Zibeon: go Aiah ma Anah. Deenei taane ne gidee e ia denga saalingaa vai hagavvela i de vao, i de masavaa aana nogo hagaloosi ange ai denga donkey a dono damana go Zibeon. ");
INSERT INTO nkr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Dama daane a Anah: go Dishon, ma Oholibamah, tamaa hine a Anah. ");
INSERT INTO nkr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dama daane a Dishon: go Hemdan, ma Eshban, ma Ithran, aama Keran. ");
INSERT INTO nkr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dama daane a Ezer: go Bilhan, ma Zaavan, aama Akan. ");
INSERT INTO nkr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dama daane a Dishan: go Uz aama Aran. ");
INSERT INTO nkr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Gai aanei dagi o de gau Hor: go Lotan, ma Shobal, ma Zibeon, ma Anah, ");
INSERT INTO nkr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ma Dishon, ma Ezer, aama Dishan. Aanei dagi o de gau Hor ma olaadeu vaaenga i de henua o Seir. ");
INSERT INTO nkr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Gai aanei denga hodooligi ne dagina de henua go Edom i mua de dahi hodooligi o de gau Israel: ");
INSERT INTO nkr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","go Bela, tama daane a Beor, ne hodooligi laa i Edom. Gai de ingoo o dono aduhale go Dinhabah. ");
INSERT INTO nkr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Gai ga magau huu Bela, gai Jobab tama daane a Zerah, taane Bozrah ga sui ia ga hodooligi ai. ");
INSERT INTO nkr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Gai ga magau huu Jobab, gai Husham mai i de henua o de gau Teman ga sui ia ga hodooligi ai. ");
INSERT INTO nkr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Gai ga magau huu Husham, gai Hadad tama daane a Bedad, taane ne hagadee kii ina laa de gau Midian i de henua go Moab, ga sui ia ga hodooligi ai. Gai de ingoo o dono aduhale go Avith. ");
INSERT INTO nkr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Gai ga magau huu Hadad, gai Samlah taane Masrekah ga sui ia ga hodooligi ai. ");
INSERT INTO nkr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Gai ga magau huu Samlah, gai Shaul taane mai i Rehoboth i gaogao ssaalingaa vai ga sui ia ga hodooligi ai. ");
INSERT INTO nkr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Gai ga magau huu Shaul, gai Baal-Hanan tama daane a Acbor ga sui ia ga hodooligi ai. ");
INSERT INTO nkr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Gai ga magau huu Baal-Hanan tama daane a Acbor, gai Hadad ga sui ia ga hodooligi ai. Gai de ingoo o dono aduhale go Pau, gai de ingoo o dono bodu go Mehetabel, tamaa hine a Matred, tamaa hine a Me-Zahab. ");
INSERT INTO nkr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Gai aanei ingoo o dagi o de hagadiilinga o Esau ma olaadeu huaabodu aama olaadeu mommee ne dagi ai: go Timna, ma Alvah, ma Jetheth, ");
INSERT INTO nkr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ma Oholibamah, ma Elah, ma Pinon, ");
INSERT INTO nkr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ma Kenaz, ma Teman, ma Mibzar, ");
INSERT INTO nkr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ma Magdiel, aama Iram. Aanei dagi o de gau Edom ma olaadeu mommee i de henua olaadeu ne nnoho ai. Deenei Esau, tamana o de gau Edom. ");
INSERT INTO nkr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Gai Jacob ne noho i Canaan, go de henua o dono damana nogo noho gaainga ai. ");
INSERT INTO nkr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Deenei taalanga o de huaabodu o Jacob. Joseph gu madaangahulu ma hidu ono ngadau, gai ia se dangada hagaloosi manu madali ono daina daane, go dama a Bilhah ma Zilpah, luu bodu laa daha o dono damana. Gai Joseph ne ahe mai ga tala ange gi delaadeu damana, dahulinga baubau a ono daina ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Gai Israel e kii Joseph dono aloha ai i ana dama ange laa alodahi, go hiidinga se dama ne haanau ange gi de ia i de masavaa oona gu madumadua ai. Gai ia ne hai dahi malo lloa hagalaagii moo Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Gai ga gidee huu e ono daina daane ange laa bolo delaadeu damana e kii Joseph dono aloha ai i gilaadeu alodahi, gai gilaadeu gu kino i Joseph, gai gilaadeu gu dee maua i de pasa danuaa ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gai Joseph ne hai dahi midi, gai ia ga tala ange gi ono daina daane, gai gilaadeu gu kii ange donu de kino i de ia. ");
INSERT INTO nkr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ia ne hai ange gi gilaadeu, “Goodou nnoho hagalaangona gai au ga tala adu dagu midi. ");
INSERT INTO nkr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Au ne midi ange bolo gidaadeu e noonoa denga grain i lo te veelenga, gai dagu noodangaa grain ne duu age gi lunga, gai oodou noodanga e duuli luu baasi o dagu noodanga ma e ino ange aagena.” ");
INSERT INTO nkr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Gai ono daina daane ga ssili ange gi de ia, “Se muna abodonu go koe e dagina gimaadeu alodahi? Gai go koe hogi e aamua i odaadeu magavaa?” Gai gilaadeu gu kii ange donu delaadeu llili i de ia, i hiidinga o dana midi ma ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Gai ia gu midi ange hogi, gai ia ga tala ange gi ono daina, ga hai ange, “Au gu hai ange hogi dahi midi, gai au ne gidee de laa ma de maasina ma e madaangahulu ma dahi heduu e duuduli ma e ino mai gi de au.” ");
INSERT INTO nkr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Gai ia ne tala ange hogi dana midi gi dono damana ma ono daina daane; gai dono damana ga hagasee ia, ga hai ange, “Ni midi bee hee aau gu hai naa? Koe e lodo gimaadeu alodahi ma doo dinana ma oo daina gi ino gi honga de gelegele i oo mada i mua?” ");
INSERT INTO nkr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Gai ono daina daane gu magiaa ange gi de ia, gai dono damana ne daohi mee nei i ono lodo. ");
INSERT INTO nkr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Dahi laangi gai ono daina daane gu hulo huu e hagaloosi denga manu a delaadeu damana i Shechem. ");
INSERT INTO nkr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Gai Israel ne hai ange gi Joseph, “Oo daina e hagaloosi denga manu i Shechem. Humai, gai au ga hai goe gi hano gi olaadeu daha.” Gai Joseph ne hai ange gi de ia, “E danuaa!” ");
INSERT INTO nkr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Gai dono damana ne hai ange gi de ia, “Hannoo diiloo be aahee dagodo o oo daina ma denga manu, gai koe ga ahe mai ga tala mai gi de au.” Gai dono damana ne hai ia gi humai i de geelonga o Hebron. De masavaa o Joseph ne dae ai gi Shechem, ");
INSERT INTO nkr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","gai dahi daane ne hedae ange gi de ia i dono hano saele i lodo henua, gai taane laa ne ssili ange gi de ia, “Se aha aau e ssala naa?” ");
INSERT INTO nkr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Gai ia ga hai ange, “Au e ssala ogu daina. Aude haihaia daalaa mai be go hee olaadeu e nnoho ma e hagaloosi ai alaadeu manu.” ");
INSERT INTO nkr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Gai taane laa ga hai ange, “Gilaadeu gu hulo gee mai i kinei, gai au ne langona delaadeu hagadau pasa bolo gilaadeu ga hulo gi Dothan.” Gai Joseph ga hano ga ssala ono daina, gai ia gu gidee gilaadeu i Dothan. ");
INSERT INTO nkr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Aagai ga gidee adu huu e gilaadeu ia i de mommee mmao, i mua dono humai ga dae mai gi olaadeu daha, gai gilaadeu ga hagasaele ange bolo gilaadeu ga daa ia gi magau. ");
INSERT INTO nkr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Gai gilaadeu ga pasa i olaadeu magavaa ga hagataba, “Tilo, gu dae mai taane hai midi! ");
INSERT INTO nkr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Loomai, gidaadeu ga daa ia gi magau e maga ange gi lo te geelinga nei, gai gidaadeu ga tala bolo dahi manu lodo henua gu lava i de gai ia. Gai gidaadeu ga tilo be e hanu haigamaiana o ana midi!” ");
INSERT INTO nkr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Gai ga langona huu e Reuben, gai ia ga hagatale de hagaola Joseph mai i gilaadeu, gai ia ga hai ange, “Gidaadeu e dee daa ia gi magau.” ");
INSERT INTO nkr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Gai Reuben ga hai ange gi gilaadeu, “Gidaadeu e dee daa ia gi magau, aagai e maga ange ia gi lo te geelinga i lodo henua nei, gai gi dee poo ange ai gidaadeu gi de ia.” Ia ne basa ange bee nei go hiidinga ia e lodo e hagaola ia mai i gilaadeu e hagaahe gi daho dono damana. ");
INSERT INTO nkr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Gai ga dae mai huu Joseph gi daho ono daina, gai gilaadeu ga hagaui de malo o Joseph, go de malo lloa hagalaagii oona e gahu ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Gai gilaadeu ga kave ia ga maga ange gi lo te geelinga. Gai de geelinga laa e deai vai iai. ");
INSERT INTO nkr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","De masavaa olaadeu ne nnoho ange ai e gaimee, gai gilaadeu gu gidee adu dahi hagabuulingaa dangada, mai i de aamuli o Ishmael e loomai i Gilead. Alaadeu gamelo e hagauda mai denga mee maanongi, ma balm aama myrrh. Gilaadeu e kave alaadeu mee maanongi e hulo ai gi Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Gai Judah ga ssili ange gi ono daina, “Ni haigamaiana aha taadeu daa taadeu daina gi magau ga hagammuni dono magau? ");
INSERT INTO nkr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Goodou loomai, gidaadeu ga hagao ange ia gi dangada de aamuli o Ishmael. Gidaadeu e dee daa ia gi magau, go hiidinga ia se daina niiodaadeu, gai se dangada donu niiodaadeu.” Gai ono daina gu buni ange gi ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Gai hanu daane hagao mee mai i Midian ne loomai laa kilaa, gai daina o Joseph ga dada age ia i lo te geelinga laa, ga hagao ange gi dangada de aamuli o Ishmael i e madalua dibaa selevaa, gai de gau laa ga kave Joseph madali gilaadeu gi Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Gai ga ahe huu Reuben gi de mommee iai de geelinga laa, gai ga gidee huu ia bolo Joseph gu dee maleva i kilaa, gai ia ga ssae ono malo. ");
INSERT INTO nkr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Gai ia ga ahe gi daho ono daina, ga hai ange, “Tama daane laa gu dee maleva; gai ni aha naa donu aagu ga hai?” ");
INSERT INTO nkr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Gai gilaadeu ga kave de malo lloa o Joseph, ga daa dahi guudi daane ga hagasulu ange de malo gi lodo dodo laa. ");
INSERT INTO nkr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Gai gilaadeu ga kave de malo hagalaagii laa gi delaadeu damana, ga hai ange: “De malo nei se mee niimaadeu ne gidee, diiloo muhuu be go de malo o dau dama?” ");
INSERT INTO nkr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Gai ia ga tilo de malo laa gu madea e ia, gai ia ga hai ange, “Deenei donu de malo o dagu dama. Dahi manu alasala gu lava donu i de daa ia ma gu gai.” ");
INSERT INTO nkr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gai Jacob ga ssae ono malo, gai ia ga gahu i malo daladala ga hinangalosaa ai i dana dama i hanu laangi lagolago. ");
INSERT INTO nkr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Gai ana dama daane ma ana damaa hine alodahi ga loomai e hagaaneane ange ia, gai ia e tee lodo, ga hai ange: “E deai, gai au e hano naa donu gi daho dagu dama i de mommee o de gau maakau, i dogu hinangalosaa i de ia.” Deelaa ai, dono damana ne dangi i hiidinga o Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","De masavaa laa gai de gau hagao mee o Midian gu kave Joseph gi Egypt ga hagao ange gi Potiphar, ia se dagi i lalo o Pharaoh, gai go tagi o de gau hagaloosi. ");
INSERT INTO nkr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Dahi laangi gai a Judah ne hano gee mai i daho ono daina daane ga daa ange gi daho dahi daane Adullam, dono ingoo laa go Hirah. ");
INSERT INTO nkr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Gai Judah gu gidee e ia dahi damaa hine Canaan i kilaa, gai de ingoo o dono damana go Shua; gai ia ga kave ia ga kave de hine laa ga hai bodu ange aagena, ma de hagahebaa ma ia, ");
INSERT INTO nkr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","gai ia gu hai dama ga haanau dahi dama daane, gai ia ga hagaingoo ange ia go Er. ");
INSERT INTO nkr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Gai ia ne hai dama ange hogi ga haanau dahi dama daane, gai ia ga hagaingoo ange ia go Onan. ");
INSERT INTO nkr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Gai ia ne haanau ange hogi dahi dama daane, gai ia ga hagaingoo ange ia go Shelah. Gai ia ne haanau ai tama daane laa i de masavaa oona nogo noho ai i Kezib. ");
INSERT INTO nkr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Gai Judah ga kave dahi bodu moo dana dama madua go Er, dono ingoo go Tamar. ");
INSERT INTO nkr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Gai tama madua a Judah go Er, ne baubau ana hegau ne hai i mada luu mada o Tagi Maolunga, gai Tagi Maolunga ga daa ia gu magau. ");
INSERT INTO nkr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Gai Judah ga hai ange gi Onan, “Hannoo hai bodu ange gi de bodu o doo daina, ga hagasula ai tahulinga ange gi de hine laa, gai koe ga hagadili ai dahi dama maa doo daina daane i ono daha.” ");
INSERT INTO nkr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aagai Onan e iloo e ia bolo tama aana e hagadili laa e dee hagaingoo i dono ingoo; deelaa ai, de masavaa huu oona ne hagahebaa ai ma de bodu o dono daina daane, gai ia ga hai ono bii gi ssali gi honga de gelegele, gi dee hagadili ina ai e ia dahi dama ma dono daina daane. ");
INSERT INTO nkr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gai Tagi Maolunga tee malangilangi i ana hegau ne hai, gai ia ne daa hogi ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Gai Judah ne hai ange gi Tamar, dono saulaba, “Ahe hannoo noho i de hale o doo damana, bei dagodo o de hine gu magau dono bodu, ga dae ai gi de madua dagu dama daane go Shelah.” Go hiidinga Judah e maanadu bolo Shelah e magau naa hogi bei dagodo o luoono daina daane. Gai Tamar ga hano ga noho i de hale o dono damana. ");
INSERT INTO nkr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Gai dua ngadau lagolago gai tamaa hine a Shua, de bodu o Judah gu magau hogi. Gai ga ui huu laangi o Judah e hinangalosaa ai, gai ia ga hanage e hano gi daho dangada e duuduudia huluhulu o ana ssiibi i Timnah, gai ia ne kave dono soa go Hirah, taane Adullam madali ia. ");
INSERT INTO nkr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Gai hanu ne tala ange gi Tamar, “Tilo, doo saulaba gu hano gi Timnah e duuduu ai huluhulu o ana ssiibi.” ");
INSERT INTO nkr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Gai ia ga hagaui malo o de hine gu magau dono bodu, ga haoli ia i de malo haoli gi dee madea ai ia, gai ia ne hano ga noho i gaogao de haitoga o Enaim, se mommee e baa ange gi de haiava e hano laa gi Timnah. Go hiidinga ia gu gidee bolo Shelah gu madua, gai tigi gaavange e hai ai dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Gai de masavaa a Judah ne gidee ai ia, gai ia e maanadu bolo ia se hine hai be se manu, go hiidinga ia gu haoli luoono mada. ");
INSERT INTO nkr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Gai Judah tee iloo donu bolo go dono saulaba deelaa, gai ia ga daa ange gi ono daha i gaogao de haiava, ga hai ange, “Au e dangidangi adu, au e lodo e hagahebaa gidaau.” Gai Tamar ne ssili ange, “Gai se aha aau e gaamai e hagao ai doo humai gi ogu daha?” ");
INSERT INTO nkr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Gai ia ga hai ange, “Au e gaamai naa gi de goe dahi guudi gauligi mai i dagu hagabuulingaa manu.” Gai Tamar ga hai ange, “Gai koe e gaamai dahi mee e hagadonu ai au muna ga dae ai gi dau gaamai de hagaoanga?” ");
INSERT INTO nkr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Gai Judah ne hai ange, “Se aha aagu e gaavadu e hagadonu ai de mee nei?” Gai ia ga hai ange, “Gaamai doo buulei hagailonga, ma taula e dau ai naa doo buulei, aama togo i lo too lima naa.” Gai ia ga gaavange mee laa gi de ia, gai Judah ga dagodo haisala ma ia, gai Tamar gu hai dama ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Dua mee laa gai Tamar ne hano gee mai i kilaa, ga hagaui de mee e haoli ai luoono mada, ga gahu i malo o de hine gu magau dono bodu. ");
INSERT INTO nkr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Gai Judah ga gaavange de guudi gauligi laa gi dono soa mai i Adullam gi gaavee gi de hine laa, gai ia ga hagaahe mai ai goloa hagadonu i daho de hine laa, aagai taane laa tee gidee e ia de hine laa. ");
INSERT INTO nkr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Gai ia ga ssili ange gi denga daane o de mommee laa, ga hai ange, “I hee de hine hai be se manu e noho laa i Enaim i gaogao de haiava?” Gilaadeu ne hai ange, “Tigi ai donu se hine hai be se manu ne humai gi kinei.” ");
INSERT INTO nkr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Gai taane laa ga ahe gi daho Judah ga hai ange, “Au tee gidee de hine laa, gai denga daane o de mommee laa ne hai mai hogi, ‘Tigi ai donu se hine hai be se manu ne humai gi kinei.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Gai Judah ga hai ange, “Dugua ange ai donu huu goloa naa moona, gi dee hagadogaa dangada ai gidaau. Au ne kave de guudi gauligi nei e gaavange gi de ia, gai koe tee gidee ia.” ");
INSERT INTO nkr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Gai dua huu e dolu malama, gai hanu dangada ga tala ange gi Judah, ga hai ange, “Doo saulaba go Tamar gu hai dama i dono hai be se manu.” Gai Judah ne hai ange, “Gaavee ia gi tua de aduhale dudu ai ia gi magau!” ");
INSERT INTO nkr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Gai de masavaa alaadeu e kave ai Tamar gi tua de aduhale, gai ia ga aalu ga hai ange gi dono saulaba, “Aanei goloa o taane oogu ne hai dama ange aagena, diiloo be koe e madea be niioai de buulei hagailonga nei, ma taula aama togo nei.” ");
INSERT INTO nkr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Gai Judah gu madea e ia mee laa, gai ia ga hagadaba, “Tamar e kii ange de heohi i de au, go hiidinga au tee gaavange dagu dama daane go Shelah e hai ai dono bodu.” Gai Judah tee ahe ange e dagodo haisala ma ia. ");
INSERT INTO nkr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Gai de masavaa o de hine laa ne haanau ai, gai se maasanga daane nogo lo tono dinae. ");
INSERT INTO nkr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gai de masavaa o de hine laa e haanau ai, gai dahi luu dama laa ne velo mai dono lima ga sula mai gi daha, gai de hine hagahaanau ga nnoa ange dahi deleisi mmea gi dono lima, ga hagadaba, “Deenei tama ne haanau i mua.” ");
INSERT INTO nkr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Gai de masavaa huu a tama laa ne hagaahe ai dono lima gi lodo, gai dono daina ange laa gu haanau. Gai de hine hagahaanau ga hai ange, “Koe gu hagamasaavava dahi mommee e sao mai ai!” Gai ia ga hagaingoo ange ia go Perez. ");
INSERT INTO nkr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Muli mai gai dono daina ange laa gu haanau mai, go tama ne nnoa ange laa dahi deleisi mmea gi dono lima, gai ia gu hagaingoo ange go Zerah. ");
INSERT INTO nkr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Gai Joseph ne gaavee gi Egypt; gai Potiphar, dahi dagi i lalo o Pharaoh, gai go tagi o de gau hagaloosi ne hagao Joseph i daho de gau Ishmael ne gaamai laa ia gi kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Gai Tagi Maolunga ne noho madali Joseph, gai ia gu hagadagadaga age. Gai ia ne noho i de hale o dono dangada aamua, taane Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Gai dono dagi aamua gu gidee e ia bolo Tagi Maolunga e noho madali Joseph, gai mee alodahi aana e hai gai Tagi Maolunga e hai gi hagadagadaga age. ");
INSERT INTO nkr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Gai Potiphar gu malangilangi i Joseph, ga hai ia go tangada e haia ange ana hegau donu, ma de hai ia go tagi o dono hale alodahi, ma de huahua i ana mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Gai mai i de masavaa a Potiphar ne hai ai Joseph go tagi o dono hale ma ono goloa alodahi, gai Tagi Maolunga ne hagamanuuia de huaabodu laa ma mee alodahi o taane Egypt laa, i hiidinga o Joseph. Gai Tagi Maolunga ne hagamanuuia mee alodahi i dono hale aama ana veelenga. ");
INSERT INTO nkr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gai ia ga dugu ange ana mee alodahi gi Joseph gi huahua ai, gu deai donu ono mee e hakoso ange aagena, go dono gaimee donu huu. Gai Joseph se daane somo danuaa dono angaanga ma de mahamaha, ");
INSERT INTO nkr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","gai dua mee laa gai de bodu o dono dangada aamua gu vaasuu i Joseph, gai ia ga hai ange, “Humai dagodo haisala madali au!” ");
INSERT INTO nkr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Aagai Joseph tee hagallongo ange, gai ia ne hai ange gi de hine laa, “Tilo, dogu dangada aamua e dee hakoso ange donu gi dahi mee daudahi i de hale; gai ia gu dugu mai ana mee alodahi au gi diiloo ange. ");
INSERT INTO nkr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Gai e deai ange donu se dangada e maolunga ange i de au i de hale nei, gai ia tee daohi donu dahi mee daudahi i de au, go koe donu huu, go hiidinga go koe dono bodu. Au e dee maua donu i de hai de hegau baubau laumalie nei e haisala ange ai gi de Maadua.” ");
INSERT INTO nkr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gai laangi alodahi gai de hine laa e usuusu ange Joseph gi haia de hegau nei, aagai ia tee hagallongo ange gi de ia, gai ia tee dagodo haisala ma ia be ne noho i de mommee o de hine laa iai. ");
INSERT INTO nkr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Dahi laangi huu gai Joseph ga hano gi lo te hale e hai ai ana hegau, gai gu deai ange se daane i de hale i de masavaa laa, ");
INSERT INTO nkr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","gai de hine laa ga poo dono malo gahu ga daohi, gai ia ga hai ange, “Humai dagodo haisala madali au.” Aagai Joseph ga tili ange dono malo gi de ia, gai ia ga savini ga hano gi duaahaho. ");
INSERT INTO nkr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Gai ga gidee huu e de hine laa bolo Joseph gu tili ange dono malo gi de ia, gai ga savini ga hano gi duaahaho, ");
INSERT INTO nkr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","gai de hine laa ne hagahi denga daane i dono hale, ga hai ange gi gilaadeu, “Goodou kalo ange diiloo, dogu bodu gu gaamai taane Hebrew nei gi odaadeu daha gi hagangadi mee ina ai gidaadeu. Ia ne humai e hai au gi de mahi, gai au ga oo, ");
INSERT INTO nkr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","gai ga langona huu e ia dogu oo, gai ia ga tili mai dono malo, gai ia ga savini ga hano gi duaahaho.” ");
INSERT INTO nkr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Gai de hine laa ga dugu de malo o Joseph i ono daha ga dae ai gi de humai o tangada aamua o Joseph gi de hale, ");
INSERT INTO nkr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","gai ia ga tala ange gi dono bodu muna nei, ga hai ange, “Taane Hebrew aau ne gaamai nei gi hai hegau i odaadeu daha ne humai e hai au gi de mahi, ");
INSERT INTO nkr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","gai au ga oo, gai ia ga tili mai dono malo gahu, gai ga savini ga hano gi duaahaho.” ");
INSERT INTO nkr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Gai ga langona huu e tangada aamua o Joseph muna a dono bodu ne tala ange laa ga hai ange, “Deenei de hai a doo daane hai hegau ne hai ai au,” gai ia gu kona mmao de lili. ");
INSERT INTO nkr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Gai tangada aamua o Joseph ga kave ia ga hhao gi lo te hale pono, go de mommee iai dangada a de hodooligi gu hhao gi lo te hale pono. Gai de masavaa o Joseph e noho ai i lo te hale pono, ");
INSERT INTO nkr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","gai Tagi Maolunga e noho i ono daha ma de abodonu ange gi de ia; ga hai tagi o de hale pono gi abodonu ange gi Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Gai tagi o de hale pono ga hili Joseph gi diiloo ange dangada alodahi i lo te hale pono. Gai mee alodahi e hai i kilaa, go ia e haia. ");
INSERT INTO nkr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Gai tagi o de hale pono tee hakoso ange donu gi dahi mee daudahi a Joseph e tilo ange, go hiidinga Tagi Maolunga e noho i ono daha ma de hagamanuuia mee alodahi a Joseph e hai. ");
INSERT INTO nkr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Dua mee nei, gai taane e haia mee unu ma taane e haia pelaoaa a de hodooligi o Egypt, ne haisala ange gi delaau dangada aamua, go de hodooligi o Egypt, ");
INSERT INTO nkr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","gai Pharaoh gu lili i luu daane hai hegau laa, go taane e haia mee unu aama taane e haia pelaoaa. ");
INSERT INTO nkr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Gai ia ga hhao gilaau gi lo te hale pono i de hale o tagi o de gau hagaloosi, go de hale pono o Joseph gu noho ai laa hogi. ");
INSERT INTO nkr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Gai tagi o de gau hagaloosi ne hai Joseph gi diiloo ange aama de hai hegau ange gi gilaau. Gai gilaau ne nnoho i lo te hale pono i dahi masavaa daulooloa. ");
INSERT INTO nkr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gai taane e haia mee unu aama taane e haia pelaoaa a de hodooligi o Egypt gu hhao laa i lo te hale pono laa ne hai dagidahi midi i dahi boo, gai alaau midi e dagodo geegee olaau hagadoonunga. ");
INSERT INTO nkr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","De masavaa o Joseph ne humai ai gi olaau daha i taiao age, gai ia gu gidee bolo gilaau e llodo baubau. ");
INSERT INTO nkr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Gai ia ga ssili ange gi luu daane hai hegau o Pharaoh e nnoho laa madali ia i lo te hale pono, i de hale o dono dangada aamua, ga hai ange, “Gu aha gu llodo baubau ai naa gooluu anailaa nei?” ");
INSERT INTO nkr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Gai gilaau ne hai ange, “Gimaau ne hai e dagidahi midi, aagai e deai donu se dangada e hagadonu ina mai luaamaau midi.” Gai Joseph ne hai ange gi gilaau, “E aha, e dee go de Maadua donu huu e maua i de hagaago mai hagadoonunga o denga midi? Gooluu daalaa mai luooluu midi.” ");
INSERT INTO nkr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Gai taane e haia mee unu ne tala ange dana midi gi Joseph, ga hai ange, “Au ne midi ange bolo au ne gidee dahi grapevine, ");
INSERT INTO nkr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","e dolu laa iai. Gai de masavaa ne matili age ai ono huamanu gai gu aala hogi, gai denga gau looloa grape gu hhaa mai hogi ga lleu. ");
INSERT INTO nkr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Gai au gu poo de ubu a Pharaoh i dogu lima, ga hagihagi denga grape laa ga kumi ange gi lo te ubu a Pharaoh, ga dugu ange gi lo tono lima.” ");
INSERT INTO nkr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Gai Joseph ga hai ange gi de ia, “Deenei de hagadoonunga o dau midi: denga laa e dolu laa ni laangi e dolu; ");
INSERT INTO nkr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","e dolu ange naa donu huu laangi, gai Pharaoh ga hagasao mai goe ga hagaahe ange gi doo duulanga, gai koe e poo naa de ubu a Pharaoh ga dugu ange gi lo tono lima, bei doo hai nogo hai hegau ai i mua, i de masavaa go koe ai e haia mee unu a Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aagai koe manadua mai au i de masavaa oou gu duadonu ai, ma de abodonu mai gi de au; daalaa ange ogu dagodo gi Pharaoh, gi hagasao ina mai ai au i lo te hale pono nei. ");
INSERT INTO nkr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Go hiidinga dangada ne hai gi de mahi au ga kave gee au mai i de henua o de gau Hebrew, gai tigi ai hogi agu mee ne hai i kinei e heohi ai dogu noho i lo te hale pono.” ");
INSERT INTO nkr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Gai ga gidee huu e taane e haia pelaoaa bolo ne danuaa de hagadoonunga o de midi laa, gai ia ga hai ange gi Joseph, “Au ne hai hogi dahi midi, gai au e hagauda e dolu gede pelaoaa i ulu dogu biho. ");
INSERT INTO nkr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Gai de gede e mua gi lunga e hhao ai denga hagadaagangaa pelaoaa a Pharaoh, aagai denga manu llele e gai denga pelaoaa i lo te gede i ulu dogu biho laa.” ");
INSERT INTO nkr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Gai Joseph ne hai ange, “Deenei de hagadoonunga o dau midi: denga gede e dolu laa ni laangi e dolu. ");
INSERT INTO nkr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","E dolu ange naa donu huu laangi, gai Pharaoh e hagasao mai naa goe ga tuu doo ua ga daudau age doo angaanga i dahi manu somo. Gai denga manu llele e loomai naa ga gai kano o doo angaanga.” ");
INSERT INTO nkr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Gai dua huu e dolu huu laangi, gai go de laangi o de boo o Pharaoh, gai ia ne hai ange dahi daonga gi ono dangada hai hegau alodahi. Gai ia ga hagassao mai taane e haia mee unu, aama taane e haia pelaoaa. ");
INSERT INTO nkr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Gai ia ga hagaahe ange taane e haia mee unu gi dono duulanga, gai taane laa ne ahe ange ga dugu ange de ubu gi lo te lima o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Aagai ia ne daudau taane e haia pelaoaa i honga dahi manu somo, bei de hai a Joseph ne hagadonu ange ai laa. ");
INSERT INTO nkr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Gai taane e haia mee unu tee manadua e ia Joseph; ia gu ngalo ia. ");
INSERT INTO nkr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Gai dua huu e lua ngadau, gai Pharaoh ne hai dahi midi. Ia ne midi ange bolo ia e duu i gaogao de Nile, ");
INSERT INTO nkr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","gai ia ne gidee e hidu kaau ssomo danuaa ma de pedi ne loage i lo te vai ga gaimee saele i magavaa o denga helii i gaogao de vai. ");
INSERT INTO nkr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Gai tilo, e hidu ange hogi kaau daadaanga sala ma de panga, ne loage i olaadeu dua ga tuu i gaogao denga kaau ange laa i gaogao ssaalingaa vai. ");
INSERT INTO nkr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Gai denga kaau daadaanga sala laa ma de panga ne gai denga kaau ssomo danuaa laa ma de pedi. Gai Pharaoh gu alahage. ");
INSERT INTO nkr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Gai ia ne seni ange hogi, gai ia gu hai ange dahi midi: ia ne gidee e hidu gau looloa grain hhua nnui gu hhaa mai i dahi grain. ");
INSERT INTO nkr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Gai tilo, e hidu ange gau looloa grain gu hhaa mai hogi i olaadeu dua, gai denga gau looloa laa e hua vaaligiligi ma de moosugia, i hiidinga de saudia i de madangi mai i dua, ");
INSERT INTO nkr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","gai denga gau looloa grain hua ligi laa ga holo denga gau looloa grain hua nnui e hidu laa. Gai Pharaoh gu alahage, gai ia gu iloo bolo ia gu hai dahi midi. ");
INSERT INTO nkr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Gai ga ao huu de mee, gai Pharaoh gu kona donu tee baba ono lodo; gai ia ga aalu de gau hai huuhuaa mee alodahi o Egypt, aama ono dangada iloo mee alodahi. Gai ia ga tala ange gi gilaadeu dana midi, aagai teai donu se gilaadeu ne maua i de hagadonu ange dana midi. ");
INSERT INTO nkr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Gai taane e haia mee unu a de hodooligi ne hai ange gi Pharaoh, “Anailaa nei gai au gu manadua ogu haisala. ");
INSERT INTO nkr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hanu masavaa gu hulo gai Pharaoh ne lili i e dogolua ono daane hai hegau, gai ia ne hhao gimaau ma taane e haia pelaoaa gi lo te hale pono gi nnoho i hale o tagi o de gau hagaloosi. ");
INSERT INTO nkr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Gai gimaau ne hai e dagidahi midi i dahi boo; gai luaamaau midi ne dagodo geegee olaau hagadoonunga. ");
INSERT INTO nkr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Gai e dahi dama daane Hebrew e noho madali gimaau; ia se dangada hai hegau niio tagi o de gau hagaloosi, gai gimaau ne tala ange gi de ia luaamaau midi, gai ia ga hagadonu mai luaamaau midi, ga tala mai de hagadoonunga o de midi a dahi ma dahi. ");
INSERT INTO nkr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Gai ne bei donu dana hai ne hagadonu mai ai gi gimaau; de hodooligi ne hagaahe ange au gi dogu duulanga, aagai ne daudau taane ange laa.” ");
INSERT INTO nkr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Gai Pharaoh ga aalu gi gaamai Joseph, gai gilaadeu ga hagamoolau ga hagasao mai ia i lo te hale pono; gai ia ga dahi dono biho ga sui ono malo, ga humai ga duu i mada i mua o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Gai Pharaoh ne hai ange gi Joseph, “Au ne hai dahi midi, gai tigi ai donu se dangada ne maua i de hagadonu mai dagu midi. Aagai au gu langona bolo noo koe gu langona de midi, gai koe e maua i de tala dono hagadoonunga.” ");
INSERT INTO nkr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Gai Joseph ga basa ange gi Pharaoh, ga hai ange, “E dee go au, gai go de Maadua e daalaa ange gi Pharaoh de hagadoonunga heohi o dana midi.” ");
INSERT INTO nkr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Gai Pharaoh ga hai ange gi Joseph, “Au ne midi ange bolo au e duu i gaogao ssaalingaa vai go Nile, ");
INSERT INTO nkr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","gai au ne gidee e hidu kaau pedi ma de ssomo danuaa, e loage i lo te vai laa ma e gaimee saele i magavaa helii. ");
INSERT INTO nkr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Gai au ne gidee ange hogi e hidu kaau dadaanga sala ma de panga ne loage i olaadeu dua, tigi ai ange agu kaau bee laa gu gidee i honga de henua alodahi o Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Gai denga kaau laa ga gai denga kaau pedi e hidu ne loage laa i mua, ");
INSERT INTO nkr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","aagai teai mee ne kii ange ai delaadeu gai denga kaau pedi laa; gilaadeu goi daadaanga sala donu huu. Gai au gu alahage. ");
INSERT INTO nkr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Au ne midi ange hogi bolo e hidu gau looloa grain ssomo danuaa ne hhaa mai i dahi grain. ");
INSERT INTO nkr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Au ne gidee hogi e hidu gau looloa grain hua ligi ne hhaa mai i olaadeu dua, gai gu moosugia i de hai a de madangi mai i dua, ");
INSERT INTO nkr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","gai denga gau looloa grain hua ligi laa ga holo denga gau looloa grain ssomo danuaa e hidu laa. Gai au ne tala ange dagu midi gi de gau hai huuhuaa mee, gai teai se gilaadeu ne maua i de hagadonu mai dagu midi.” ");
INSERT INTO nkr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Gai Joseph ga hai ange gi Pharaoh, “Luu midi nei se hagadoonunga daudahi donu huu olaau. De Maadua gu hagaago ange gi Pharaoh ana mee gu baba ange e hai. ");
INSERT INTO nkr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De hagadoonunga o denga kaau pedi e hidu laa se hidu ngadau, gai denga gau looloa grain danuaa e hidu laa se hidu hogi ngadau; gai se hagadoonunga daudahi donu huu o luu midi nei. ");
INSERT INTO nkr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Denga kaau dadaanga sala ma de panga e hidu ne loage laa i muli se hidu ngadau. Gai denga gau looloa grain hua ligi e hidu laa ma de moosugia i de hai a de madangi mai i dua, go denga ngadau e hidu o de onge. ");
INSERT INTO nkr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Gai e bei dagu hai gu tala ange ai laa gi Pharaoh: de Maadua gu hagaago ange gi Pharaoh ana mee gu baba ange e hai. ");
INSERT INTO nkr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","E hidu naa ngadau e hai ai tau gai laumalie i honga de henua alodahi o Egypt; ");
INSERT INTO nkr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","gai dua naa huu ngadau e hidu laa, gai gu daamada de hidu ngadau o de onge, gai dangada e ngalo naa tau gai laumalie ne hai i honga de henua go Egypt, i hiidinga gu laumalie de onge i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Gai e dagodo naa be teai donu se dau gai ne hai i honga de henua, i hiidinga de onge e humai i dua tau gai laa e laumalie mmao. ");
INSERT INTO nkr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gai ne lua hanonga ne humai ai de midi nei gi Pharaoh, go hiidinga de Maadua gu hagatoo donu de mee nei, gai e moolau naa donu de hagassula a de Maadua mee nei. ");
INSERT INTO nkr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Gai Pharaoh gi saalaa dahi daane iloo mee ma de heiangi, ga hai ia gi se dagi i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Gai Pharaoh gi hilia hanu dagi o de henua gi hagabudulia ma de doange e dahi diba i diba e lima o denga huamanu alodahi i honga de henua go Egypt i denga ngadau e hidu e hai ai laa tau gai. ");
INSERT INTO nkr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Gai gilaadeu gi hagabudulia denga gai alodahi i denga ngadau o tau gai e loomai nei i ssauaa o Pharaoh, ga doange denga huamanu nei i denga aduhale ga dugu ai. ");
INSERT INTO nkr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Gai gi hanu ai gai e hagadabena ange gi de henua i denga ngadau e hidu o de onge gu dai humai laa gi de henua go Egypt, gai gi dee hai ngadaa ai de henua i de masavaa o de onge.” ");
INSERT INTO nkr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Gai Pharaoh ma ono daane hai hegau alodahi ne buni ange gi muna laa. ");
INSERT INTO nkr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Gai Pharaoh ne ssili ange gi ono dangada hai hegau, “E dahi ange nei daane adaadeu e gide bei dagodo o taane nei, se daane e dagodo de hagasaalunga o de Maadua i ono daha?” ");
INSERT INTO nkr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Gai Pharaoh ne hai ange gi Joseph, “Go hiidinga de Maadua ne hagaago adu gi iloo e goe mee nei alodahi, e deai ange donu se dangada e iloo mee ma de heiangi bei oo dagodo. ");
INSERT INTO nkr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iainei gai go koe tagi o dogu hale, gai be se aha naa huu aau e tala ange gi dangada, gai ogu dangada e hai donu gi bei. Gai go dogu nohoanga donu huu e maolunga ange i doo duulanga.”  ");
INSERT INTO nkr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Gai Pharaoh ga hai ange gi Joseph, “Tilo, au gu hai goe gi dagina honga de henua alodahi go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Gai Pharaoh ga unusi de buulei iai laa dono hagailonga mai i dono lima, ga ulumagi ange gi de lima o Joseph, gai ia ga hai gi hakahudia ange ia i malo linen danuaa, ma de hagauda ange dahi hau goolo gi dono ua. ");
INSERT INTO nkr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Gai ia ga hai Joseph go dono dogolua ga hai ia gi hano saele i dahi hada hodooligi, gai dangada ne hevaalogi i ono mada i mua ga hagataba, “Goodou duuduli ino ange gi de ia!” Deenei de hai a Pharaoh ne hai ai Joseph gi dagi i honga de henua alodahi go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Gai Pharaoh ne hai ange gi Joseph, “Go au go Pharaoh, aagai e deai donu se dangada e maua i de hai dahi mee daudahi i de henua go Egypt, noo koe e dee dugu ange.” ");
INSERT INTO nkr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Gai Pharaoh ne hagaingoo ange Joseph go Zaphenath-Paneah. Gai ia ne gaavange Asenath, tamaa hine a Potiphera, taane haimeedabu o On, e hai ai dono bodu. Gai Joseph ne hano ga hagadaga i honga de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Gai Joseph gu matolu ono ngadau i de masavaa oona ne daamada ai de hai hegau ange gi de hodooligi o Egypt go Pharaoh. Gai ia ga hano gee mai i mada i mua o Pharaoh, ga hagadaga i honga de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Gai de masavaa huu o denga ngadau e hidu o tau gai, gai de gelegele gu kona mmao de lagolago ono hua. ");
INSERT INTO nkr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Gai Joseph ga hagabudu denga gai alodahi i honga de henua go Egypt i de hidu ngadau ne hai ai laa tau gai, ga doange i denga aduhale. Ia ne hagabudu denga huamanu i denga veelenga i luu baasi dahi aduhale ga doange i lo te aduhale laa. ");
INSERT INTO nkr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Gai Joseph ne hagabudu ga doange hanu hua grain lagolago mmao, bei de lagolago gelegele i gabugabu tai; gai ia ne tuu de hagahidi mee laa, go hiidinga gu dee maua i de hagahidi. ");
INSERT INTO nkr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Gai Asenath, tamaa hine a Potiphera, tangada haimeedabu o On, ne haanau ange gi Joseph e dogolua dama daane i mua de tae mai ngadau o de onge. ");
INSERT INTO nkr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Gai Joseph ne hagaingoo ange dana dama madua go Manasseh, go hiidinga ia e hagadaba, “De Maadua gu hai gi ngalo e au ogu hai ngadaa alodahi, ma dogu huaabodu alodahi.” ");
INSERT INTO nkr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Gai ia ne hagaingoo ange dana dama gauligi go Ephraim, go hiidinga ia ne hagadaba, “De Maadua gu hai au gi hagadili i de henua oogu ne duasala ai.” ");
INSERT INTO nkr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gai ga odi huu ngadau e hidu o tau gai i de henua go Egypt, ");
INSERT INTO nkr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","gai gu daamada denga ngadau e hidu o de onge, bei de hai a Joseph gu tala ai laa. Gai gu hai de onge i henua i lalo alodahi, aagai Egypt goi hanu huu gai iai. ");
INSERT INTO nkr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gai de masavaa huu o dangada i Egypt ne hiikai ai, gai gilaadeu ga tangi ange gi Pharaoh i mee gai. Gai Pharaoh ga hai ange gi dangada alodahi o Egypt, “Goodou hulo gi daho Joseph, gai be se aha naa huu aana e tala adu, gai goodou haia.”  ");
INSERT INTO nkr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Gai ga dae huu de onge gi henua i lalo alodahi, gai Joseph ga hhuge denga mommee doange gai alodahi, gai ia ga hagao ange denga gai gi de gau Egypt, go hiidinga gu laumalie mmao de onge i honga de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gai dangada alodahi o henua i lalo gu loomai gi daho Joseph i Egypt e hagao gai ai, go hiidinga gu kona mmao de laumalie de onge i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Gai ga iloo huu e Jacob bolo e hanu grain i Egypt, gai ia ga hai ange gi ana dama daane, “Ni aha oodou e nnoho ai naa ma e hagadau kalo ange?” ");
INSERT INTO nkr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Gai ia ga hai ange, “Au gu langona bolo e hanu grain i Egypt. Goodou hulo gi kilaa hagao ina mai ai hanu gai maadaadeu, gi dee maakau ai gidaadeu gai gi mouli.”  ");
INSERT INTO nkr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Gai e dinoangahulu daina daane o Joseph ne hulo gi Egypt e hagao ai grain. ");
INSERT INTO nkr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Aagai Jacob tee dugu Benjamin, taina daane o Joseph gi hano madali ono daina, go hiidinga ia ne manavasaa kana hai ange dahi sala gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Gai denga dama a Israel ne hulo hogi ga hagao mee madali dangada, i hiidinga gu hai hogi de onge i de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","De masavaa laa gai go Joseph de goobenaa i de henua; go ia e hagao ina ange denga grain gi dangada. Deelaa ai, de masavaa huu ne tae mai ai daina daane o Joseph, gai gilaadeu ga ino gu paa olaadeu mada gi honga de gelegele i mada i mua o Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Gai ga gidee huu e Joseph ono daina, gai ia gu madea gilaadeu, aagai ia ga hagadee iloo gilaadeu ma de basa bole ange gi gilaadeu, ga ssili ange ga hai ange, “Go hee oodou ne loomai ai naa?” Gilaadeu ne hai ange, “Gimaadeu ne loomai i de henua go Canaan e hagao hanu gai.” ");
INSERT INTO nkr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph ne madea e ia ono daina daane, gai gilaadeu tee madea ia. ");
INSERT INTO nkr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Gai Joseph gu manadua e ia ana midi i olaadeu dagodo. Gai ia ga hai ange gi gilaadeu, “Goodou ni dangada mulidagi ne loomai e tilo denga mommee o de henua e dee buibui.”  ");
INSERT INTO nkr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Gilaadeu ne hai ange gi de ia, “Deai, e demaadeu dangada aamua, oo dangada hai hegau ne loomai e hagao gai. ");
INSERT INTO nkr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Gimaadeu alodahi ni dama daane nii dahi daane. Gimaadeu ni daane e hai hegau i de mee abodonu. Gimaadeu, oo dangada hai hegau e dee ni dangada mulidagi.” ");
INSERT INTO nkr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Gai ia ga hai ange gi gilaadeu, “E deai, goodou se loomai donu e tilo mommee e dee buibui i de henua.” ");
INSERT INTO nkr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Aagai gilaadeu ga hai ange, “Oo dangada hai hegau ni hai daina e dinoangahulu ma dogolua. Gimaadeu ni dama nii dahi daane mai i de henua go Canaan; gai tama gauligi e noho i daho demaadeu damana iainei, gai e dahi omaadeu daina gu dee maleva.” ");
INSERT INTO nkr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Gai Joseph ga hai ange gi gilaadeu, “E bei donu dagu hai gu tala adu ai laa gi goodou: goodou ni dangada mulidagi. ");
INSERT INTO nkr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Au e hagatale naa goodou e tilo ai oodou dagodo i de mee nei: au e tala hagatoo donu i de ingoo o Pharaoh, bolo goodou e dee hulo gee donu i de henua, ga dae ai gi doodou aalu ga gaamai doodou daina daane gauligi gi kinei. ");
INSERT INTO nkr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Haia dahi goodou gi hano gi gaamai doodou daina gauligi, gai goodou ange naa e hhao gi lo te hale pono, e tilo ai be goodou ne tala de muna abodonu be deai; gai noo e deai, gai au e hagadaba i de ingoo o Pharaoh bolo goodou ni dangada donu mulidagi.” ");
INSERT INTO nkr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Gai Joseph ne hai gilaadeu alodahi gi nnoho i lo te hale pono i e dolu laangi. ");
INSERT INTO nkr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Gai de hagadolu laangi huu, gai Joseph ga hai ange gi gilaadeu, “Deenei doodou mee e hai gi mouli ai goodou, go hiidinga au e madagu i de Maadua: ");
INSERT INTO nkr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","noo goodou ni daane e daalaa de muna abodonu, gai dahi oodou daina daane e nnoa e hhao gi lo te hale pono, gai goodou ange laa gi aahe gi gaavee denga grain e gaimee ai dangada i doodou hale i de masavaa o de onge nei. ");
INSERT INTO nkr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Aagai goodou e aahe ga gaamai doodou daina gauligi gi ogu daha, e hagadonu ai oodou muna, gi dee maakau ai goodou.” Gai gilaadeu ne hai ga bei ana muna. ");
INSERT INTO nkr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Gai gilaadeu ne hagataba i olaadeu magavaa, “Ni muna abodonu, gidaadeu gu haisala ange donu gi taadeu daina daane. Gidaadeu ne gidee de duasala ono lodo, i de masavaa aana ne dangidangi mai gi gidaadeu, gai gidaadeu tee hagallongo ange; aanei hiidinga gu duu mai ai nei de hai ngadaa nei gi gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben ne basa ange, ga hai ange, “E aha, tee hai adu au goodou gi dee haia ange de baubau gi tama laa, gai goodou tee hagallongo mai gi de au? Gai iainei gidaadeu gu kave de hagaoanga o adaadeu hegau.”  ");
INSERT INTO nkr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Gai gilaadeu tee iloo donu bolo Joseph e donu ange gi alaadeu muna, go hiidinga tangada hagadonu ne hagadonu ange alaadeu muna. ");
INSERT INTO nkr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Gai ia ga hano gee mai i olaadeu daha, ia gu dangi; gai ia ga ahe mai ange hogi gi olaadeu daha ga basa ange gi gilaadeu. Gai ia ga kave Simeon mai i olaadeu daha ga nnoa i olaadeu mada i mua. ");
INSERT INTO nkr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Gai Joseph ga hai ange gi de gau hai hegau gilaadeu gi haaoa gi hoohonu alaadeu beagi i grain, gai gi hagaahe ange alaadeu sseene gi lodo alaadeu beagi, gai gi gaavange hogi hanu gai e gaimee ai gilaadeu i delaadeu hulo. Gai mee laa gu gaavange gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Gai gilaadeu ne hagauda ange alaadeu grain gi honga alaadeu donkey ga hulo gee ai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Gai dahi gilaadeu ne hhuge age dana beagi e gaavange ai hanu grain e gai dana donkey i de mommee nnoho gaainga; gai ia gu gidee bolo ana sseene goi daakodo donu huu i lo tana beagi, ");
INSERT INTO nkr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","gai ia ga tala ange gi ono daina daane ange laa, ga hai ange, “Agu sseene e daakodo donu huu i lo tagu beagi.” Gai gilaadeu gu kona mmao tee paba olaadeu lodo ma de maatagu. Gai gilaadeu ne pasa i olaadeu magavaa ga hagataba, “Se aha a de Maadua gu hai mai nei gi gidaadeu?” ");
INSERT INTO nkr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Gai ga aahe huu gilaadeu ga tae gi daho delaadeu damana go Jacob i de henua go Canaan, gai gilaadeu ga tala ange gi de ia mee alodahi ne hai ange gi gilaadeu, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Taane e dagina laa de henua ne basa bole mai gi gimaadeu, gai ne hai gimaadeu be ni dangada ne loadu e mulidagi ina de henua. ");
INSERT INTO nkr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Aagai gimaadeu ne hai ange gi de ia, ‘Gimaadeu ni daane abodonu, aagai e dee ni dangada mulidagi. ");
INSERT INTO nkr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Gimaadeu ni hai daina daane e dinoangahulu ma dogolua, gai se damana daudahi omaadeu; gai dahi gimaadeu gu magau, gai tama gauligi e noho i daho demaadeu damana i de henua go Canaan anailaa nei.’ ");
INSERT INTO nkr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Gai taane e dagia laa de henua ne hai mai gi gimaadeu, ‘Deenei dagu hai e iloo ai bolo goodou ni daane e daalaa de muna abodonu: dugua dahi oodou daina gi noho i ogu daha, gai goodou hulo gaavee grain a doodou huaabodu e gaimee ai i de masavaa o de onge. ");
INSERT INTO nkr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Aagai goodou ga gaamai doodou daina daane gauligi madali goodou gi ogu daha, gi iloo ai e au bolo goodou tee loomai e mulidagi de henua, aagai goodou ni daane e daalaa de muna abodonu. Gai au ga gaavadu ai doodou daina daane nei gi goodou, gai goodou gu maua hogi i de hagao mee i honga de henua.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Gai de masavaa huu alaadeu ne llingi ai alaadeu beagi, gai tilo, sseene a dahi ma dahi goi daakodo donu huu i lodo alaadeu beagi, gai gilaadeu ma delaadeu damana gu kona donu de maatagu. ");
INSERT INTO nkr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Gai delaadeu damana go Jacob ga hai ange gi gilaadeu, “Goodou gu hai au ga hinangalosaa i agu dama: Joseph gu dee maleva, gai Simeon gu dee maleva hogi, gai iainei goodou gu llodo hogi e kave gee Benjamin. Mee alodahi e hai baasi mai donu gi de au!” ");
INSERT INTO nkr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Gai Reuben ne basa ange gi dono damana, ga hai ange, “Koe e maua i de daa gi maakau luaagu dama daane noo au e dee hagaahe mai Benjamin gi oo daha. Gai go au e diiloo ange ia ga hagaahe mai ia gi oo daha.” ");
INSERT INTO nkr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Aagai Jacob ne hai ange, “E deai, dagu dama e dee hano donu madali goodou; dono daina daane gu magau, go ia donu huu e doe. Gai noo ia e hai dahi sala i doodou hulo, gai goodou e hai naa dogu biho sinasinaa nei ga moolau de hano iho gi de mommee o de gau maakau.” ");
INSERT INTO nkr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Gai gu kona huu de laumalie de onge i de henua laa. ");
INSERT INTO nkr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Gai ga odi huu denga grain alaadeu ne gaamai laa i Egypt, gai delaadeu damana ga hai ange gi gilaadeu, “Goodou aahe hulo hagao ina mai ange hanu momo gai maadaadeu.” ");
INSERT INTO nkr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Aagai Judah ga basa ange ga hai ange, “Taane laa ne tala hagasoe mai donu gi gimaadeu, ga hai mai, ‘Goodou e dee maua donu i de aahe ange gi ono daha, noo goodou e dee gaamai doodou daina daane madali goodou.’ ");
INSERT INTO nkr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Noo koe e dugu demaadeu daina daane gi hano madali gimaadeu, gai gimaadeu gu maua i de hulo e hagao mai hanu gai maadaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aagai noo koe e dee dugu ia gi hano madali gimaadeu, gai gimaadeu e dee hulo donu; go hiidinga taane laa ne hai mai donu gi gimaadeu, ‘Goodou e dee maua donu i de aahe ange gi ogu daha, noo doodou daina e dee humai madali goodou.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Gai Israel ga ssili ange, “Gu aha goodou gu hagahai ngadaa ai naa au, i doodou tala ange gi taane laa bolo e dahi ange oodou daina daane?” ");
INSERT INTO nkr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Gai gilaadeu ga hai ange, “Taane laa ne ssili mai dagodo o demaadeu huaabodu, ga hai mai, ‘Doodou damana goi mouli naa huu? Gai e dahi ange oodou daina?’ Gai gimaadeu ga pasa ange donu huu gi de ia muna. Gai gimaadeu tee iloo donu bolo ia e hai mai, ‘Goodou gaamai doodou daina daane madali gimaadeu.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Gai Judah ga hai ange gi dono damana go Israel, “Dugua tama naa gi hano madali au, gai gimaadeu ga hagamoolau e hulo, gi dee maakau ai gidaadeu ma adaadeu dama, gai gi mouli. ");
INSERT INTO nkr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Gai go au donu e hagadonu ai bolo ia e ahe mai donu; gai koe gi dau ina mai gi de au mee alodahi e hai ange gi de ia. Gai noo au e dee hagaahe mai ia, e hagaduu i oo mada i mua, gai koe ga dau mai ssala naa gi de au i taulooloa dogu mouli. ");
INSERT INTO nkr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Gai noo gimaadeu ne hagamoolau ga hulo, gai gu lua odi huu omaadeu hanonga ne hulo ai ga lava ga aahe mai.” ");
INSERT INTO nkr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Gai delaadeu damana go Israel ga hai ange gi gilaadeu, “Noo deenaa tagodo, gai deenei doodou mee e hai: goodou haoa hanu huamanu danuaa hugadoo o de henua gi lodo oodou beagi, ma gi gaavee madali goodou e ngadi gaavange gi taane laa — hanu momo balm, ma hanu hooni, ma hanu mee hagamanongi, ma hanu myrrh, ma hanu pistachio aama hanu almond. ");
INSERT INTO nkr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Goodou gaavee ange hanu sseene madali sseene alaadeu ne hagaahe ange laa, gi lodo oodou beagi madali goodou; agu made gilaadeu tee tilo gi danuaa. ");
INSERT INTO nkr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Goodou gaavee hogi doodou daina daane madali goodou ga aahe ai gi daho taane laa. ");
INSERT INTO nkr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Gai de Maadua Mmahi Mmao laa gi lodo aloha adu gi goodou, i mada i mua o taane laa, gai ia gi dugu adu doodou daina daane ange laa ma Benjamin gi aahe mai madali goodou. Gai noo au gu hinangalosaa i teai agu dama, gai au gu hinangalosaa.” ");
INSERT INTO nkr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gai denga daane laa ga kave de ngadi gaavange, ma hanu sseene ange laa madali gilaadeu, aama Benjamin ga hulo ai gi Egypt. Gai gilaadeu ne hulo ga tuu i mada i mua o Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Gai ga gidee huu e Joseph Benjamin e duu madali gilaadeu, gai ia ga hai ange gi taane e diiloo ange mee i dono hale, “Gaavee denga daane nei gi dogu hale, ga daa dahi manu ga hagadabena hanu gai; go hiidinga gilaadeu e gaimee naa madali au i de hualaangi.” ");
INSERT INTO nkr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Gai taane laa ne hai ga bei muna a Joseph gu tala ange gi de ia; ia ne kave denga daane laa gi de hale o Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Gai denga daane laa gu maatagu, i de masavaa olaadeu ne gaavee ai gi de hale o Joseph. Gilaadeu ga hagataba, “Gilaadeu ne hai gimaadeu gi loomai gi kinei, i hiidinga o sseene ne hagaahe ange laa gi lodo adaadeu beagi, i de hanonga i mua. Ia gu lodo e hebagi mai ma de hagadee kii gidaadeu, ga kave adaadeu donkey ma de hai gidaadeu gi ni dangada hai hegau niiona.” ");
INSERT INTO nkr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Gai gilaadeu ne hulo pasa ange gi taane e diiloo ange de hale o Joseph, i gaogao de haitoga o de hale. ");
INSERT INTO nkr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Gilaadeu ne hai ange, “Demaadeu dangada aamua, ni muna abodonu gimaadeu ne loomai i tahi hanonga e hagao hanu gai. ");
INSERT INTO nkr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Aagai de masavaa omaadeu ne tae ai gi de mommee nnoho gaainga ga hhuge amaadeu beagi, gai dahi ma dahi gu gidee ana sseene alodahi i lo tana beagi. Gai gimaadeu gu hagaahe mai sseene laa madali gimaadeu, ");
INSERT INTO nkr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","gai gu gaamai ange hanu sseene madali gimaadeu e hagao ai amaadeu gai. Gai gimaadeu tee iloo donu be goai ne hagaahe ange amaadeu sseene gi lodo amaadeu beagi.” ");
INSERT INTO nkr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Gai ia ga hai ange, “E danuaa, goodou aude maatagu. Doodou Maadua, go de Maadua o doodou damana gu hhao ange hanu mee hagamogomogo gi lodo oodou beagi; oodou sseene gu i ogu daha.” Gai ia ga hagasao mai Simeon gi olaadeu daha. ");
INSERT INTO nkr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Taane laa ne kave denga daane laa gi de hale o Joseph, ga gaavange hanu vai e hhui ai olaadeu vae, ma de haangai ange alaadeu donkey. ");
INSERT INTO nkr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Gai gilaadeu ga hagadabena ange delaadeu mee ngadi gaavange, gi de masavaa e dae mai ai Joseph i de madohi lua o de laangi, go hiidinga gilaadeu gu langona bolo gilaadeu e gaimee i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","De masavaa o Joseph ne dae mai gi de hale, gai gilaadeu ga gaamai de mee ngadi gaavange alaadeu ne gaamai laa gi lo te hale, gai gilaadeu ga ino gi honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Gai Joseph ne ssili ange olaadeu dagodo, ga hai ange, “Gai aahee dagodo o doodou damana madua, oodou ne tala mai laa ono dagodo gi de au? Ia goi mouli huu?” ");
INSERT INTO nkr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Gilaadeu ne hai ange, “Doo dangada hai hegau, go demaadeu damana e dee beaha, gai ia goi mouli huu.” Gai gilaadeu ne ino ange hogi i ono mada i mua. ");
INSERT INTO nkr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Gai Joseph gu gidee hogi e ia dono daina go Benjamin, go tama a delaau dinana, gai ia ga ssili ange, “Deenei doodou daina gauligi oodou ne tala mai laa?” Gai Joseph ga hai ange gi de ia, “Dagu dama, de Maadua gi hagamanuuia ina goe.” ");
INSERT INTO nkr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Gai Joseph ga hagamoolau ga sao ga hano, i hiidinga ia gu lodo aloha mmao i dono daina daane, ia ne ssala dahi mommee e hano ai e dangi. Gai ia ne hano ga ulu gi lo tono aabi i lodo ga dangi ai. ");
INSERT INTO nkr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Muli mai gai ia ne hhui luoono mada, ga daohi dana dangi, ga sao mai, ga hagadaba, “Dugua mai denga gai.” ");
INSERT INTO nkr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Gai gilaadeu ga vvae ange gai a Joseph i de ia, gai a denga hai daina ange laa i gilaadeu, gai de gau Egypt e gaimee laa madali ia i gilaadeu. De gau Egypt e dee alaange i de gaimee madali de gau Hebrew, i hiidinga se mee hakino gee i daho de gau Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Gai denga hai daina laa ne hagatau i ono mada i mua, mai i tama madua ga hano iho ai gi tama gauligi. Gai denga daane laa ga hagadau kalo ange gu llele olaadeu mouli. ");
INSERT INTO nkr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Gai alaadeu gai ne duha ange gi gilaadeu mai i gai i honga teebele o Joseph, gai tuuhanga o Benjamin e lima hanonga e laumalie ange ai i duuhanga o ono daina ange laa. Gai gilaadeu ga gaimee ma de unu ga malangilangi madali ia. ");
INSERT INTO nkr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Gai Joseph ne hai ange gi taane hai hegau e dagina dono hale, “Haaoa beagi a denga daane naa gi hoohonu i mee alaadeu e maua i de hagauda e kave, gai hagaahea ange sseene a dahi ma dahi gi lo tana beagi. ");
INSERT INTO nkr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Gai koe haaoa ange dagu ubu selevaa gi lo te beagi a tama gauligi hugadoo, madali ana sseene ne gaamai e hagao ai grain.” Gai ia ne hai donu gi bei muna a Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Gai taiao age huu, gai gilaadeu ga hai denga daane laa gi hulo madali alaadeu donkey. ");
INSERT INTO nkr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Gai de masavaa olaadeu ne ssao ai ga hulo gee, gai tigi mmao gee ai loo gilaadeu i de aduhale, gai Joseph ga hai ange gi taane e dagina dono hale, “Hannoo, dolohia gi daea adu e goe denga daane laa, gai koe ga siilia ange gi gilaadeu, ‘Gu aha goodou gu sui ange ai laa tanuaa i de baubau? ");
INSERT INTO nkr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","E dee deenei de ubu a dogu dangada aamua e unu ai laa, ma de tala ai mee e dee iloo? Goodou gu hai dahi hegau baubau.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","De masavaa a taane laa ne daea adu ai gilaadeu, gai ia ga tala ange hogi muna laa gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Aagai gilaadeu ne hai ange gi de ia, “Demaadeu dangada aamua, gu aha goe gu basa mai ai naa bee naa gi gimaadeu? E dee maua donu e gimaadeu, oo dangada hai hegau, i de hai dahi hegau baubau bee naa! ");
INSERT INTO nkr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tilo, gimaadeu ne hagaahe mai gi de goe, sseene amaadeu ne gidee laa i lodo amaadeu beagi, mai i de henua go Canaan; gai gu aha gimaadeu gu gaiaa ai hanu selevaa be ni goolo mai i de hale o doo dangada aamua? ");
INSERT INTO nkr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Gai be goai naa huu i omaadeu magavaa e gidee mai ai de ubu naa, gai ia e daa donu gi magau, gai gimaadeu alodahi e doe e hai gi ni dangada hai hegau niiou, e tangada aamua.” ");
INSERT INTO nkr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Gai ia ga hai ange, “E danuaa, e hai naa donu gi bei oodou muna; be goai naa huu de goodou e gidee mai ai mee nei i ono daha, gai go ia e hai ai dogu dangada hai hegau; gai goodou ange laa gu deai oodou sala.” ");
INSERT INTO nkr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Gai gilaadeu ga hagamoolau ga dugu iho alaadeu beagi gi honga de gelegele, gai tangada nei ma de hhuge dana beagi. ");
INSERT INTO nkr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Gai taane laa ne daamada de ssala de mee laa, mai i daho tama madua ga hano iho ai gi tama gauligi hugadoo. Gai de ubu laa ne gidee mai i lo te beagi a Benjamin. ");
INSERT INTO nkr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Gai gilaadeu ga saesae olaadeu malo i de daemaha o olaadeu lodo, gai gilaadeu ga hagauda alaadeu mee i honga alaadeu donkey ga aahe ai gi de aduhale. ");
INSERT INTO nkr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Gai Joseph goi noho huu i de hale, i de masavaa o Judah ma ono daina daane ne ulu mai ai, gai gilaadeu ne loomai ga hagabaakuu gi honga de gelegele i ono mada i mua. ");
INSERT INTO nkr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Gai Joseph ga hai ange gi gilaadeu, “Se hegau bee hee oodou gu hai nei? Goodou e dee iloo bolo au se dangada e maua i de tala mee e dee iloo?” ");
INSERT INTO nkr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah ne hai ange, “Dogu dangada aamua, dee hee naa demaadeu hai e pasa adu ai i de mee nei? Gai dee hee demaadeu hai e hagaago adu ai bolo gimaadeu e dee haisala? De Maadua gu hagaago mai haisala o oo dangada hai hegau. Deenei ai, gimaadeu gu ni dangada hai hegau niiou, go gimaadeu alodahi madali tama ne gidee mai laa de ubu i ono daha.” ");
INSERT INTO nkr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Gai Joseph ga hai ange, “Au e dee maua i de hai de hegau naa. Gai go tangada donu huu ne gidee mai ai de ubu, e hai ai dogu dangada hai hegau. Gai goodou ange laa, aahe gi daho doodou damana i de nnoho baba.” ");
INSERT INTO nkr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Aagai Judah ga humai ga hagabaa ange gi de ia, ga hai ange, “Dogu dangada aamua, aude haihaia, au e lodo e tala adu agu muna. Gai koe gi dee lili i de au, doo dangada hai hegau, e dee galemu donu koe e maolunga donu bei Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Koe ne ssili mai gi gimaadeu, ‘E dahi oodou damana aabe se daina daane?’ ");
INSERT INTO nkr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tangada aamua, gimaadeu ne hai adu gi de goe, ‘Gimaadeu e dahi omaadeu damana, ia gu madumadua, ma dahi daina daane gauligi, se dama niiana ne hagadili i de masavaa oona gu madumadua ai. Dono daina daane gu magau, gai go tama nei donu huu e doe i dama a dono dinana; gai dono damana e kona donu de aloha i de ia.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Gai koe ne hai mai gi gimaadeu, oo dangada hai hegau, ‘Gaamai ia gi ogu daha gi gidee ai donu au ia.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Gai gimaadeu ne hai adu gi de goe, demaadeu dangada aamua, ‘Tama daane laa e dee maua donu i de hano gee mai i daho dono damana. Noo ia e hano gee mai i ono daha, gai dono damana e magau donu.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Aagai koe ne hai mai gi gimaadeu, oo dangada hai hegau, ‘Noo goodou e dee gaamai doodou daina daane gauligi madali goodou, gai goodou e dee maua donu i de aahe mai e tuu i mada luoogu mada.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Gai de masavaa omaadeu ne aahe ai gi daho demaadeu damana, gai gimaadeu ne tala ange gi de ia au muna. ");
INSERT INTO nkr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Gai demaadeu damana ne hai mai, ‘Goodou aahe hagao ina mai hanu momo gai maadaadeu.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aagai gimaadeu ne hai ange gi de ia, ‘Gimaadeu e dee maua donu i de aahe e hulo gi kilaa, noo demaadeu daina daane gauligi e dee hano madali gimaadeu. Gimaadeu e dee maua i de aahe e tuu i mada i mua o taane laa, noo demaadeu daina gauligi e dee hano madali gimaadeu.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Gai doo dangada hai hegau, go demaadeu damana, ne hai mai gi gimaadeu, ‘Goodou e iloo laa bolo dogu bodu ne haanau mai gi de au e dogolua dama daane; ");
INSERT INTO nkr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","dahi gu dee maleva i ogu daha, gai au e hagadaba bolo ia gu daia i dahi manu, gai au tigi gidee ange donu ia ga dae mai ai gi iainei. ");
INSERT INTO nkr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Gai noo goodou e kave gee hogi tama nei mai i ogu daha, gai gu hai ange dahi sala gi de ia, gai goodou e hai naa dogu biho sinasinaa nei gi moolau de hano gi de mommee o de gau maakau.’ ");
INSERT INTO nkr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Gai tilo, noo au e ahe gi daho doo dangada hai hegau, go demaadeu damana, gai demaadeu damana, (ia e mouli laa donu huu i hiidinga o tama daane gauligi nei,) ");
INSERT INTO nkr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","e gidee e ia bolo tama nei e dee madali gimaadeu, gai ia e magau donu. Gai gimaadeu, oo dangada hai hegau, e hai naa demaadeu damana, ga moolau de hano gi de mommee o de gau maakau, i hiidinga dono hinangalosaa. ");
INSERT INTO nkr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gai au, doo dangada hai hegau, ne hagatoo donu i dogu mouli bolo au e hagaahe tama daane nei gi daho dogu damana. Au ne hai ange, ‘Noo au e dee hagaahe tama daane nei, gai dogu damana e dau mai sala nei gi de au, i taulooloa o dogu mouli!’ ");
INSERT INTO nkr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Deenei ai, au e dangidangi adu, go au e noho e hai ai doo dangada hai hegau, e sui ai tama daane nei, gai koe dugua tama nei gi ahe madali ono daina. ");
INSERT INTO nkr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Gai dee hee dogu hai e ahe ai gi daho dogu damana, noo de gauligi daane nei e dee madali au? Au e dee lodo e tilo de hai ngadaa e duu ange gi dogu damana.” ");
INSERT INTO nkr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Gai Joseph gu dee maua i de golomagi ono lodo i mada i mua o dangada alodahi e tuu madali ia, gai ia ga hagadaba, “Haia gi ssao dangada alodahi gi hulo gee mai i omaadeu daha!” Deelaa ai, teai donu dangada madali gilaadeu, i de masavaa aana ne tala ange ai gi ono daina bolo go ia go Joseph. ");
INSERT INTO nkr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Gai ia ne oo ga dangi, gai de gau Egypt ma dangada alodahi i de hale o Pharaoh gu langona e gilaadeu dono dangi. ");
INSERT INTO nkr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Gai Joseph ne hai ange gi ono daina daane, “Go au go Joseph. Dogu damana goi mouli naa huu?” Gai ono daina gu dee maua i de pasa ange gi de ia, go hiidinga gilaadeu gu llele mouli ma de maatagu i de ia. ");
INSERT INTO nkr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Gai Joseph ga hai ange gi ono daina, “Goodou loomai gi paa mai goodou gi ogu daha.” Gai gilaadeu ne loomai ga hagapaa ange gi de ia, gai ia ga hai ange, “Go au doodou daina daane go Joseph, go de ia oodou ne hagao ga hai gi gaavee gi Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Gai goodou e dee maatagu aabe gi daemaha, i doodou hagao au ga gaamai gi kinei, go hiidinga go de Maadua donu ne gaamai au gi kinei, i mua doodou loomai, e hagaola ai mouli o dangada. ");
INSERT INTO nkr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Deenei de lua ngadau e onge ai honga de henua; gai e lima ange ngadau e dee doe ai manu aabe e hagihagi ai. ");
INSERT INTO nkr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Aagai de Maadua ne hai au gi humai gi kinei, i oodou mada i maua e hai ai gi hanu oodou hagadiilinga e doe i henua i lalo, aama de hagamouli ai dangada soa. ");
INSERT INTO nkr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Deenei ai, e dee go goodou ne gaamai au gi kinei, aagai go de Maadua. Ia gu hai hogi au gi se damana hagadubu niio Pharaoh, gai se dagi i dono hale alodahi aama honga o Egypt alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Gai goodou hagamoolau aahe gi daho dogu damana, ga hai ange gi de ia, ‘Aanei muna a dau dama go Joseph ne hai mai: De Maadua gu hai au gi se dangada aamua i Egypt alodahi. Gai koe hagamoolau humai gi dae mai goe gi ogu daha. ");
INSERT INTO nkr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gai koe ga noho ai i de mommee go Goshen, gi baa ange ai goe gi de au — go koe, ma au dama ma dama a au dama, ma oodou ssiibi ma guudi ma kaau, aama au mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Gai au ga tilo adu ai goe i kilaa, go hiidinga e lima ange ngadau o de onge, kana duasala goe ma dangada i doo hale, aama au mee alodahi.’ ");
INSERT INTO nkr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Gai gi gidee ai e gooluu ma dogu daina go Benjamin bolo go au donu deenei e basa adu nei gi de goe! ");
INSERT INTO nkr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Gai goodou daalaa ange gi dogu damana dagodo o dogu mahamaha alodahi i Egypt, aama mee alodahi oodou gu gidee. Gai goodou ga hagamoolau ga gaamai dogu damana gi kinei.” ");
INSERT INTO nkr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Gai ia ga ino ange gi honga de eu o dono daina go Benjamin ga dangi ai, gai Benjamin gu dangi hogi. ");
INSERT INTO nkr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Gai ia ga oso ono daina alodahi ga ino ange ga dangi i honga olaadeu eu, muli mai gai ono daina ga madaangudu ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Gai ga langona huu e dangada i de hale o Pharaoh, bolo daina daane o Joseph gu loomai, gai Pharaoh ma ono dangada hai hegau gu malangilangi. ");
INSERT INTO nkr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Gai Pharaoh ne hai ange gi Joseph, “Hai ange gi oo daina, gilaadeu gi haia de mee nei: ‘Goodou haoa gi hoohonu oodou beagi ga hagauda ange gi honga oodou manu ga aahe ai gi de henua go Canaan, ");
INSERT INTO nkr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","gai goodou ga gaamai doodou damana ma dono huaabodu ga aahe mai ai gi ogu daha. Gai au ga gaavadu gi goodou de mommee danuaa hugadoo i de henua go Egypt, gai goodou gu maua i de gai mee moomuna o de henua.’ ");
INSERT INTO nkr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Gai koe daalaa ange hogi gi gilaadeu, hai ange, ‘Deenei doodou mee e hai: goodou gaavee hanu hada mai i Egypt e hagauda mai ai oodou gauligi, ma oodou bodu, aama de gaamai ai doodou damana ga aahe mai ai gi kinei. ");
INSERT INTO nkr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gai goodou gi dee manavasaa i oodou goloa, go hiidinga mee danuaa alodahi i de henua o Egypt e gaavadu naa donu gi goodou.’ ” ");
INSERT INTO nkr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Gai dama a Israel ne hagassula muna nei. Gai Joseph ne gaavange gi gilaadeu hanu hada bei dagodo muna a Pharaoh. Gai ia ne gaavange hogi hanu gai e gaimee ai gilaadeu i delaadeu hulo. ");
INSERT INTO nkr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ia ne gaavange hogi gi dahi ma dahi hanu malo, gai ia ne gaavange e dolulau dibaa selevaa ma e lima malo gi dono daina go Benjamin. ");
INSERT INTO nkr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Gai ia ne kave hogi hanu goloa gi dono damana: e madaangahulu donkey daane gu hagauda ange ai denga hagadaagangaa goloa danuaa o Egypt, ma e madaangahulu donkey haahine e hagauda ange aagena denga grain, ma pelaoaa, ma gai a dono damana e gaimee, e humai ai. ");
INSERT INTO nkr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Gai ia ne hai gi hulo ono daina daane, gai ia ga hai ange gi gilaadeu, “Goodou aude hagadaumee i honga de haiava!” ");
INSERT INTO nkr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Gai gilaadeu ne hulo gee mai i Egypt, ga aahe gi daho delaadeu damana, go Jacob i de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Gilaadeu ne tala ange gi de ia, ga hai ange, “Joseph goi mouli huu. Gai ia se dagi i de henua alodahi o Egypt.” Gai Jacob gu lele mmao ono mouli; ia tee hagadonusia alaadeu muna. ");
INSERT INTO nkr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aagai ga langona huu e Jacob muna alodahi a Joseph ne tala ange gi ono daina, ma de gidee denga hada a Joseph ne gaamai e hagauda ai ia, gai delaadeu damana go Jacob gu mmahi age. ");
INSERT INTO nkr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Gai Israel ga hagadaba, “Gu danuaa; dagu dama go Joseph goi mouli huu. Au e hano donu e tilo ia i mua dogu magau.” ");
INSERT INTO nkr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Gai Israel ne kave ono mee alodahi ga hano ai. Gai ga dae huu ia gi Beersheba, gai ia ga hai dahi sigidaumaha, ange gi de Maadua o dono damana go Isaac. ");
INSERT INTO nkr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Gai de Maadua ne hakide ange gi Israel i de midi i de boo laa, ga hai ange, “Jacob, Jacob.” Gai ia ga hai ange, “Deenei au.” ");
INSERT INTO nkr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Gai ia ne hai ange, “Go au go de Maadua, go de Maadua o doo damana; aude madagu i de hano gi Egypt, go hiidinga au e hai naa goe gi se huaahenua soa i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Gai au e hano naa donu madali goe gi Egypt, au e hagaahe mai naa hogi goe. Gai go Joseph e haia gi mmoe luoo mada i doo magau.” ");
INSERT INTO nkr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Gai Jacob ne hano gee mai i Beersheba; gai dama a Israel ne kave delaadeu damana go Jacob, ma alaadeu gauligi, aama olaadeu bodu i honga denga hada a Pharaoh ne gaamai laa e hagauda ai ia. ");
INSERT INTO nkr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Gai Jacob ma ono hagadiilinga alodahi ne kave alaadeu manu haangai, ma goloa alaadeu ne mau i de henua go Canaan ga hulo ai gi Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ia ne kave madali ia gi Egypt ana dama daane, ma ono mogobuna daane, ma ana damaa hine, ma ono mogobuna haahine — go ono hagadiilinga alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aanei ingoo o dama a Israel (e bei go Jacob ma dono hagadiilinga) ne hulo gi Egypt: Reuben go tama daane madua a Jacob. ");
INSERT INTO nkr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Dama daane a Reuben: go Hanok, ma Pallu, ma Hezron, aama Karmi. ");
INSERT INTO nkr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Dama daane a Simeon: go Jemuel, ma Jamin, ma Ohad, ma Jakin, ma Zohar, aama Shaul, go dana dama ange gi dahi hahine Canaan. ");
INSERT INTO nkr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Dama daane a Levi: go Gershon, ma Kohath, aama Merari. ");
INSERT INTO nkr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Dama daane a Judah: go Er, ma Onan, ma Shelah, ma Perez, aama Zerah (aagai Er ma Onan ne maakau i de henua go Canaan). Dama daane a Perez: go Hezron ma Hamul. ");
INSERT INTO nkr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Dama daane a Issachar: go Tola, ma Puah, ma Iob, aama Shimron. ");
INSERT INTO nkr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Dama daane a Zebulun: go Sered, ma Elon, aama Jahleel. ");
INSERT INTO nkr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aanei dama a Leah ne haanau ange gi Jacob i Mesopotamia, aama dana damaa hine go Dinah. Ana dama daane ma ana damaa hine alodahi, se dinodolu ma dogodolu. ");
INSERT INTO nkr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Dama daane a Gad: go Ziphion, ma Haggi, ma Shuni, ma Ezbon, ma Eri, ma Arodi, aama Areli. ");
INSERT INTO nkr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Dama daane a Asher: go Imnah, ma Ishvah, ma Ishvi, ma Beriah. Delaadeu daina hahine go Serah. Dama daane a Beriah: go Heber ma Malkiel. ");
INSERT INTO nkr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Gai dama a Zilpah, ange gi Jacob, go de hine hai hegau a Laban, ne gaavange gi dana damaa hine go Leah, se dinoangahulu ma dogoono. ");
INSERT INTO nkr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dama daane a Rachel, de bodu o Jacob: go Joseph ma Benjamin. ");
INSERT INTO nkr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Gai Joseph ne hagadili Manasseh ma Ephraim i de henua go Egypt, i daho Asenath tamaa hine a Potiphera, tangada haimeedabu o On.  ");
INSERT INTO nkr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Dama daane a Benjamin: go Bela, ma Beker, ma Ashbel, ma Gera, ma Naaman, ma Ehi, ma Rosh, ma Muppim, ma Huppim, aama Ard. ");
INSERT INTO nkr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dama daane a Rachel ange gi Jacob, se dinoangahulu ma dogohaa. ");
INSERT INTO nkr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tama daane a Dan: go Hushim. ");
INSERT INTO nkr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Dama daane a Naphtali: go Jahzeel, ma Guni, ma Jezer, aama Shillem. ");
INSERT INTO nkr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dama daane a Bilhah ange gi Jacob, go de hine hai hegau a Laban ne gaavange laa gi dana damaa hine go Rachel, se dogohidu. ");
INSERT INTO nkr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dangada alodahi ne hulo laa gi Egypt madali Jacob — go dangada mai i dono aamuli — se dinoono ma dogoono, gai bodu ana dama daane tee dau. ");
INSERT INTO nkr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gai Joseph ne hagadili e dogolua dama daane i Egypt, gai dangada alodahi i de hale o Jacob ne hulo gi Egypt se dinohidu. ");
INSERT INTO nkr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gai Jacob ne hai Judah gi hano i ono mada i mua gi daho Joseph, gi hagaagona ange de haiava e hano laa gi Goshen. Gai de masavaa olaadeu ne tae ai gi de mommee go Goshen, ");
INSERT INTO nkr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","gai Joseph gu hagadabena dono hada e hano ai gi Goshen, e hedae ange ai gi dono damana go Israel. Gai de masavaa huu olaau ne hedae ai, gai ia ga ino ange gi honga de eu o dono damana ga dangi ai, i dahi masavaa daulooloa. ");
INSERT INTO nkr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Gai Israel ne hai ange gi Joseph, “Au gu baba ange donu e magau, go hiidinga au gu gidee donu bolo koe goi mouli huu.” ");
INSERT INTO nkr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Gai Joseph ga hai ange gi ono daina daane ma de huaabodu alodahi o dono damana, “Au e hano naa e hai ange gi Pharaoh, ‘Ogu daina daane ma de huaabodu alodahi o dogu damana, nogo nnoho laa i de henua go Canaan, gu loomai gi ogu daha. ");
INSERT INTO nkr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Gilaadeu ni daane hagaloosi manu; gilaadeu ni dangada e diiloo ange denga manu haangai, gai gilaadeu ne gaamai hogi alaadeu ssiibi ma kaau aama olaadeu goloa alodahi madali gilaadeu.’ ");
INSERT INTO nkr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Gai de masavaa naa huu a Pharaoh e hagahi ai goodou ga ssili adu, ‘Ni hegau aha oodou e hai?’, ");
INSERT INTO nkr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","gai goodou ga hai ange, ‘Gimaadeu, oo dangada hai hegau ni dangada haangai manu, mai loo i de masavaa omaadeu e gauligi ai, bei dagodo o omaadeu dubuna madagidagi.’ Gai ia e dugu adu naa goodou gi nnoho i Goshen, go hiidinga de gau haangai manu alodahi, ni dangada e hakino gee i daho de gau Egypt.” ");
INSERT INTO nkr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Gai Joseph ne hano ga basa ange gi Pharaoh, ga hai ange, “Dogu damana ma ogu daina daane gu gaamai alaadeu hagabuulingaa ssiibi ma kaau aama alaadeu mee alodahi, mai i de henua go Canaan, gai iainei gilaadeu e nnoho i Goshen.” ");
INSERT INTO nkr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Gai ia ne hili e dogolima ono daina daane ga kave ga hagatuu i mada i mua o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Gai Pharaoh ne ssili ange gi ono daina, “Ni hegau aha oodou e hai?” Gilaadeu ne hai ange gi Pharaoh, “Gimaadeu, oo dangada hai hegau, ni dangada hagaloosi manu, bei omaadeu dubuna madagidagi.” ");
INSERT INTO nkr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Gai gilaadeu ne hai ange gi Pharaoh, “Gimaadeu ne loomai e nnoho i de henua nei, go hiidinga gu deai donu helii e gaimee ai amaadeu manu, gai gu kona hogi de laumalie de onge i de henua go Canaan. Gai koe gi dee haihaia, dugua mai de mommee go Goshen e nnoho ai gimaadeu, oo dangada hai hegau.” ");
INSERT INTO nkr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Gai Pharaoh ne basa ange ga hai ange gi Joseph, “Doo damana ma oo daina gu loomai gi oo daha, ");
INSERT INTO nkr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","gai de henua go Egypt gu dugu adu gi de goe; haia gi nnoho doo damana ma oo daina, i de mommee danuaa hugadoo i de henua. Dugua ange gilaadeu gi nnoho i Goshen. Gai noo e hanu oo daina, aau e iloo bolo ni daane hai mee, gai koe haia gilaadeu gi diiloo ange agu manu haangai.” ");
INSERT INTO nkr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Gai Joseph ne gaamai dono damana go Jacob gi mada i mua o Pharaoh, gai Jacob ga hagamanuuia Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Gai Pharaoh ne ssili ange gi Jacob, “Gu hia naa oo ngadau?” ");
INSERT INTO nkr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob ne hai ange gi Pharaoh, “Gu 130 ogu ngadau gu noho gaainga saele ai. Ogu ngadau ne mouli ai e sogoisi ma de hai ngadaa, gai au tigi daea donu ngadau o ogu maadua ne nnoho gainga saele ai.” ");
INSERT INTO nkr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Gai Jacob ne hagamanuuia Pharaoh, gai ia ga sao ga hano gee mai i daho Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Gai Joseph ne hai dono damana ma ono daina gi nnoho i Egypt, ma de gaavange gi gilaadeu de mommee danuaa hugadoo, i de ungaamee go Rameses, bei de hai a Pharaoh gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Gai Joseph ne tilo ange dono damana ma ono daina aama de huaabodu alodahi o dono damana, ma de haangai ange gilaadeu, gi bei se soa o alaadeu dama. ");
INSERT INTO nkr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gai ga deai huu gai i de mommee laa alodahi, go hiidinga gu laumalie de onge; gai de henua go Egypt ma de henua go Canaan gu hiikai i hiidinga o de onge. ");
INSERT INTO nkr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gai Joseph ga hagao ange denga grain gi dangada, ma de kave sseene alodahi i honga Egypt aama Canaan, ga gaamai gi de hale o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Gai ga odi huu sseene a dangada i Egypt ma Canaan, gai de gau Egypt alodahi ga loomai ga hai ange gi Joseph, “Gaamai hanu gai e gaimee ai gimaadeu. Ni haigamaiana aha dau gidee demaadeu maakau? Gu odi amaadeu sseene alodahi.” ");
INSERT INTO nkr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Gai Joseph ga hai ange, “Goodou gaamai oodou manu haangai, gai au ga kave oodou manu e hagao ai oodou gai.” ");
INSERT INTO nkr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Gai dangada ga gaamai alaadeu manu haangai gi Joseph, gai ia ga kave alaadeu hoosa, ma ssiibi, ma guudi, ma kaau aama donkey, ga hagahesuihagi i denga gai. Gai ia ne gaavange gai a dangada, ga hagahesuihagi i alaadeu manu, i de ngadau laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Gai ga odi huu de ngadau laa, gai dangada ga loomai gi ono daha i de ngadau mai ange laa, ga hai ange gi de ia, “Demaadeu dangada aamua, gimaadeu e dee maua donu i de hagammuni i de goe, demaadeu dangada aamua, bolo gu odi amaadeu sseene alodahi, gai amaadeu manu gu niiau, gu deai ange donu amaadeu mee e doe, go omaadeu angaanga donu huu ma omaadeu alahenua. ");
INSERT INTO nkr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ni haigamaiana aha dau gidee demaadeu maakau — go gimaadeu ma omaadeu alahenua? Hagao ina gimaadeu ma omaadeu alahenua gai koe ga gaamai ai amaadeu gai. Gai gimaadeu ma omaadeu alahenua e gaavange naa gi Pharaoh. Gai koe gaamai gi gimaadeu denga golee, gi dee maakau ai gimaadeu gai gi mouli, gi dee ngadi daakodo ai omaadeu alahenua.” ");
INSERT INTO nkr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Gai Joseph ga hagao denga gelegele alodahi i Egypt moo Pharaoh. Gai dangada alodahi i Egypt ne hagao olaadeu gelegele, i hiidinga gilaadeu ne duasala i de kona de onge. Gai de gelegele o de henua gu niio Pharaoh, ");
INSERT INTO nkr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","gai Joseph ne hai dangada alodahi o Egypt gi ni dangada hai hegau, mai i dahi bido o Egypt ga dae ai gi de bido ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Aagai ia tee hagao alahenua o de gau haimeedabu, go hiidinga duuhanga o de gau haimeedabu go Pharaoh e haia, gai gilaadeu e gaimee i alaadeu gai mai i daho Pharaoh. Deelaa ai, gilaadeu tee hagao olaadeu alahenua. ");
INSERT INTO nkr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Gai Joseph ne hai ange gi dangada, “Tilo, au gu hagao goodou ma oodou gelegele anailaa nei, ma gu gaavange gi Pharaoh. Gai aanei golee oodou e dooa oodou gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aagai de masavaa naa huu o de hagihagi, gai goodou e gaavange gi Pharaoh dahi diba i diba e lima, gai e haa diba ange laa niiodou ma oodou huaabodu, gai goodou ga doo ai denga veelenga ma de gaimee ai madali oodou dama.” ");
INSERT INTO nkr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Gai gilaadeu ga hai ange, “Demaadeu dangada aamua, koe ne haia ga mouli gimaadeu; koe ne abodonu mai gi gimaadeu. Gimaadeu gu ni dangada hai hegau niio Pharaoh.” ");
INSERT INTO nkr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Gai Joseph ga hagasauaa de hainga laa i de henua go Egypt, ga dae mai ai gi anailaa nei: dahi diba i diba e lima o denga huamanu nii Pharaoh. Gai go veelenga donu huu a de gau haimeedabu tee gaavange gi Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Gai Israel ma dono huaabodu ne noho i de henua go Egypt i Goshen, gai olaadeu goloa gu hagadagadaga ange de lagolago i kilaa, gai gilaadeu gu hagadili hogi ga kona de soa. ");
INSERT INTO nkr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Gai Jacob ne noho i de henua go Egypt i e madaangahulu ma hidu ngadau. Gai ngadau o Jacob ne mouli ai se 147. ");
INSERT INTO nkr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Gai ga baa ange huu gi de magau o Israel, gai ia ga hagahi dana dama go Joseph, ga hai ange gi de ia, “Noo koe e malangilangi i de au, gai koe velosia ange doo lima gi lalo dogu dae, gai koe ga hagatoo donu mai gi de au, bolo koe e abodonu mai ma de hai hegau mai gi de au i de muna abodonu. Gai koe aude danumia au i Egypt, ");
INSERT INTO nkr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","aagai au e danu madali ogu maadua. Gai koe gaavee gee au mai i Egypt, ga danu i de mommee olaadeu e danu ai laa.” Joseph ne hai ange, “Au e hai donu gi bei au muna.” ");
INSERT INTO nkr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Gai ia ga hai ange, “Hagatoo donu mai gi de au.” Gai Joseph ga basa hagatoo donu ange gi de ia. Muli gai Israel ne ino ange gi de ulu o dono dogo ga daumaha.  ");
INSERT INTO nkr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Dua huu mee laa, gai Joseph gu langona bolo dono damana gu magi. Gai ia ga kave luaana dama daane go Manasseh ma Ephraim madali ia. ");
INSERT INTO nkr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Gai dahi ne hai ange gi Jacob, “Dau dama daane go Joseph gu humai gi oo daha.” Gai Israel ga hagammahi ga noho age i honga dono moenga. ");
INSERT INTO nkr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Gai Jacob ga hai ange gi Joseph, “De Maadua Mmahi Mmao laa ne hakide mai gi de au i Luz, i de henua go Canaan, ma de hagamanuuia ai au i kilaa. ");
INSERT INTO nkr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ia ne hai mai gi de au, ‘Tilo, au e hai naa goe gi hagadili naa ga soa. Au e hai naa goe gi se huaadangada soa, gai au e gaavange naa de henua nei, e hai ai de henua o doo aamuli, e loomai i oo dua ga hano ai.’ ");
INSERT INTO nkr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Gai luaau dama daane ne hagadili i Egypt, go Ephraim ma Manasseh, i mua dogu humai gi oo daha i kinei gu niiagu donu; gilaau gu bei donu dagodo o Reuben ma Simeon, gilaau gu niiagu. ");
INSERT INTO nkr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Gai dama aau e hagadili i muli mai niiau. Gilaadeu e kave naa olaadeu mommee i de vaaenga o luoolaadeu daina daane. ");
INSERT INTO nkr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Gai de masavaa oogu ne ahe mai ai i Mesopotamia, gai Rachel ne magau i de henua go Canaan, i de masavaa omaadeu ne loomai ai i honga de haiava, gai gimaadeu gu dai paa ange donu gi Ephrath (e bei go Bethlehem); gai au ne danu ia i gaogao de haiava e hano laa gi Ephrath.”  ");
INSERT INTO nkr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Gai ga gidee huu e Israel luu dama daane a Joseph, gai ia ga ssili ange, “Goai aanei?” ");
INSERT INTO nkr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Gai Joseph ga hai ange gi dono damana, “Aanei luu dama a de Maadua ne gaamai gi de au i kinei.” Israel ne hai ange, “Gaamai gilaau gi ogu daha, gai au ga hagamanuuia ai gilaau.” ");
INSERT INTO nkr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","De masavaa laa gai luu mada o Israel gu dai dee kide, i hiidinga ia gu madumadua, gai ia gu dee gidee danuaa. Gai Joseph ne gaamai luaana dama gi de ia, gai ia ga oso gilaau ma de buuludi ange gilaau. ");
INSERT INTO nkr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Gai Israel ga hai ange gi Joseph, “Au tee maanadu donu bolo au e gidee ange naa goe, gai tilo, de Maadua gu dugu mai hogi au gi gidee luaau dama.” ");
INSERT INTO nkr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Gai Joseph ga aau gee gilaau mai i honga luu vae o dono damana, gai ia ga ino gu baa luoono mada gi honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Gai ia ga gaamai luaana dama ngaadahi gi paa ange gi dono damana; Ephraim i dono madau, e bei go de masui o Israel, gai Manasseh i dono masui, e bei go de madau o Israel. ");
INSERT INTO nkr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Aagai Israel ne haalo dono lima madau, ga dugu ange gi honga de biho o tama gauligi go Ephraim, gai dono lima masui i honga de biho o tama madua go Manasseh; ia ne hagahesuihagi luoono lima. ");
INSERT INTO nkr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Gai ia ne hagamanuuia Joseph ga hagadaba, “De Maadua o ogu maadua, go Abraham ma Isaac ne daumaha ange laa aagena, go de Maadua hogi ne diiloo mai au mai i dogu haanau ga dae mai ai gi anailaa nei, ");
INSERT INTO nkr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","go tangada de langi ne hagaola ina mai au i denga hai ngadaa alodahi — gi hagamanuuia ina hogi luu gauligi daane nei. Gai gilaau gi gaavee dogu ingoo ma ingoo o luoogu damana go Abraham ma Isaac gai gilaau gi hagadili gi soa i henua i lalo.” ");
INSERT INTO nkr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Gai ga gidee huu e Joseph, bolo dono damana ne dugu ange dono lima madau gi honga de biho o Ephraim, gai gu dee heohi ange gi de ia; gai ia ga poo de lima o dono damana e hagangalue gee mai i de biho o Ephraim, e dugu ange gi honga de biho o Manasseh. ");
INSERT INTO nkr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Gai Joseph ga hai ange gi dono damana, “Dogu damana, e dee deenaa, deenei tama madua i kinei, dugua ange doo lima madau gi honga dono biho.” ");
INSERT INTO nkr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aagai dono damana e dee lodo, ga hai ange, “Dagu dama, au e iloo. Ia e hai naa ga se huaadangada soa, ia e sula naa hogi ga maolunga. Aagai dono daina gauligi e maolunga ange naa i de ia, gai ono hagadiilinga e hai ai naa ga ni huaahenua soa.” ");
INSERT INTO nkr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gai ia ga hagamanuuia gilaau i de laangi laa, ga hagadaba, “De gau Israel e hagamanuuia naa, ga hagataba, ‘De Maadua gi haia goe gi bei Ephraim ma Manasseh.’ ” Gai ia ne hai Ephraim gi maolunga ange i Manasseh. ");
INSERT INTO nkr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Gai Israel ne hai ange gi Joseph, “Tilo, au gu dai magau naa, gai de Maadua gi noho madali goodou, ga hagaahe goodou gi de henua o oodou dubuna. ");
INSERT INTO nkr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Gai au e gaavadu naa dahi madadaagodo gi de goe e dee gaavange gi oo daina, de mommee aagu ne kave mai i daho de gau Amor i dagu gadilaasa ma dagu mee hholu.” ");
INSERT INTO nkr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Gai Jacob ga hagahi ana dama daane, ga hai ange, “Goodou hagabuni mai, gai au ga tala adu gi goodou mee e hai adu gi goodou i muli. ");
INSERT INTO nkr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Dama a Jacob, goodou nnoho mai hagalaangona; goodou hagalaangona muna a doodou damana go Israel. ");
INSERT INTO nkr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, go koe dagu dama madua; go tama aagu ne hagadili i de masavaa oogu e mmahi ai, gai go koe hugadoo e maolunga ma de mmahi. ");
INSERT INTO nkr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Koe e bei denga vai e dee maua laa gi malino, gai koe e dee maua naa donu gi maolunga, go hiidinga koe ne hano ga gage ange gi honga de moenga o doo damana ga hai gu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon ma Levi ni hai daina, gai alaau gadilaasa e vaivai hai dangada. ");
INSERT INTO nkr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Au e dee buni ange gi alaau hagasaele; au e dee daudali ange gi alaau hagatau, go hiidinga gilaau ne daa dangada ga maakau i delaau llili, gai ne vaivai hai denga kaau daane ga dee vaa seesee. ");
INSERT INTO nkr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Delaau llili gi hagamalaia, i hiidinga delaau llili e kona mmao, i delaau vaivai hai dangada! Au e hai naa olaau hagadiilinga gi mavaevae saele i magavaa o dangada o Jacob ma magavaa o dangada o Israel. ");
INSERT INTO nkr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, oo daina e tuhi naa goe; gai koe e hagadee kii naa oo hagadaumee, gai dama a doo damana e ino adu naa gi de goe. ");
INSERT INTO nkr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah e bei de laiono mmahi; dagu dama, koe e bei de manu gu daa laa dahi manu ma gu gai. Ia e bei de laiono e dogoduli laa ma e noho ai, ma de laiono hahine — goai e bau ange gi de hai ia gi hidi age? ");
INSERT INTO nkr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","De laagau hodooligi e dee aau gee naa donu i daho Judah, aabe e aau gee togo o tagi mai i magavaa luoono vae, ga dae ai gi de humai o de ia niiona togo laa; gai denga huaahenua e hagallongo ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","E nnoa ange naa dana donkey gi dahi grapevine, gai dana donkey gauligi gi de laa manu danuaa mmao, gai ia e taa naa ono malo i denga uvaini, gai ono malo i vai o denga grape. ");
INSERT INTO nkr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Luoono mada e mmea naa i dana unu uvaini, gai ono niho e tea naa i dana unu denga vai uu. ");
INSERT INTO nkr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun e noho naa i tagudai; gai e hai naa go taulanga o denga vaga, ono goinga e hano naa ga tae gi Sidon. ");
INSERT INTO nkr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar e bei dahi donkey mmahi, e dogoduli laa i magavaa buibui o denga ssiibi. ");
INSERT INTO nkr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","De masavaa naa huu aana e gidee ai tanuaa o dono hagamaabunga, ma de danuaa o de henua laa, gai ia e ino naa ga saabai dana mee hagauda ma de hai ia gi se dangada e hagahai hegau ina. ");
INSERT INTO nkr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan e hagamodu naa muna o ono dangada; ia go dahi aamuli donu o Israel. ");
INSERT INTO nkr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan e bei de labodo i honga de haiava laa, gai se labodo hagammau i gaogao dahi dao haiava, e gadigadia laa muli luu vae o de hoosa gai tangada e gage laa i honga de hoosa e doo iho naa. ");
INSERT INTO nkr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Tagi Maolunga, au e tali dau hagaola. ");
INSERT INTO nkr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Hanu hagabuulinga o de gau gaiaa e hebagi ange naa gi a Gad, aagai ia e doolohi naa gilaadeu ga daa. ");
INSERT INTO nkr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher e gai naa gai moomuna ma de mmammami, gai e hai gai moomuna e heohi ange gi denga hodooligi. ");
INSERT INTO nkr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali e bei dahi dia hahine gu tala gi hano, gai e hagadili naa hanu dama mahamaha. ");
INSERT INTO nkr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph e bei de grapevine hua lagolago, gai se grapevine hua lagolago i gaogao dahi saalingaa vai; ono laa e ssinga ange naa laa honga de buibui. ");
INSERT INTO nkr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dangada e dilia mee hholu e kona de hebagi ange naa gi de ia, e hagammahi naa ga tili ia, ");
INSERT INTO nkr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","aagai dana mee hholu e dee ngalungalue naa donu, luoono lima e hai ga mmahi i hiidinga o de Ia Mmahi o Jacob, go de Ia Hagaloosi, ma de Baba mmahi o Israel. ");
INSERT INTO nkr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Gai de Maadua o doo damana e bale adu naa goe, gai de Ia Mmahi Mmao laa e hagamanuuia naa goe i denga manuuia i lo te langi i lunga, ma manuuia i lo te gelegele i lalo de henua, ma denga manuuia o de gaanuunu ma de mommee o denga dama. ");
INSERT INTO nkr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Denga manuuia a doo damana e danuaa ange i denga manuuia mai i denga mounga e dee ngado mai, ma de lava o denga duuduu gu daakodo mai laa huu madagidagi. Denga manuuia nei gi hagamanuuia ai Joseph, ma honga de biho o de ia gu hili laa mai i magavaa o ono daina daane. ");
INSERT INTO nkr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin se wolf alasala, ia e daa ga gai dahi manu i taiao, gai e vaevae mee aana e mau i de ahiahi.” ");
INSERT INTO nkr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aanei hagadiilinga alodahi e dinoangahulu ma dogolua o Israel, gai aanei muna a delaadeu damana ne tala ange gi gilaadeu, i de masavaa aana ne hagamanuuia ai gilaadeu. Ia ne hagamanuuia dahi ma dahi i de manuuia e heohi ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Gai ia ga bolo ange gi gilaadeu ga hai ange, “Au gu dai magau naa, gai goodou gaavee au danumia i daho ogu dubuna madagidagi i lo te haonga i de alahenua o Ephron, taane Heth, ");
INSERT INTO nkr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","i lo te haonga i honga de alahenua i Machpelah, i baasi dua o Mamre i de henua go Canaan, go de alahenua a Abraham ne hagao mai i daho Ephron, taane Heth e hai ai de mommee o ana daanunga. ");
INSERT INTO nkr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Go kilaa ne danu ai Abraham, ma dono bodu go Sarah, ma Isaac ma dono bodu go Rebekah. Gai go kilaa hogi aagu ne danu ai Leah; ");
INSERT INTO nkr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","go de alahenua ma de haonga ne hagao laa i daho de gau Heth.” ");
INSERT INTO nkr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Gai de masavaa huu ne lava ai muna a Jacob ange gi ana dama, gai ia ga hagapogo mai luoono vae gi honga de moenga, ga hai ana manava hagaodi, gai ia ga hagabuni madali ono dangada. ");
INSERT INTO nkr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Gai Joseph ne ino ange gi honga o dono damana ga dangi ai ga oso ia. ");
INSERT INTO nkr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Gai Joseph ga hai de gau hai magi e hai hegau ange laa gi de ia, gi tao ina de angaanga o dono damana. Gai gilaadeu ga tao de angaanga o Israel, ");
INSERT INTO nkr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","gai se madahaa laangi gu hagailonga e tao ai de angaanga. Gai de gau Egypt ne tangi i de ia i e madahidu laangi. ");
INSERT INTO nkr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Gai ga ui huu laangi olaadeu e tangi ai, gai Joseph ga hai ange gi de gau i de hale o Pharaoh, “Goodou abodonu mai gi de au ma gi daalaa ange agu muna gi Pharaoh, hai ange, ");
INSERT INTO nkr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Dogu damana ne hai au gi hagatoo donu ange gi de ia, ga hai mai: Au gu dai magau; gai koe danumia ngau i lo togu daanunga gu hagadabena mai gi de au i de henua go Canaan.’ Gai dugua mai au gi hano gi danumia dogu damana ga ahe mai ai.”  ");
INSERT INTO nkr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh ne hai ange gi de ia, “Hannoo danumia doo damana bei dau hai gu hagatoo donu ange ai laa gi de ia.” ");
INSERT INTO nkr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Gai Joseph ne hano ga danu dono damana, gai de gau hai hegau alodahi o Pharaoh ne hulo madali ia, ma denga dagi i dono hale, ma de gau aamua alodahi o Egypt, ");
INSERT INTO nkr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ma dangada alodahi i de hale o Joseph ma ono daina daane, aama de huaabodu o dono damana. Go alaadeu gauligi donu huu ma alaadeu ssiibi ma guudi, aama kaau ne nnoho i Goshen. ");
INSERT INTO nkr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Gai ne hanu hogi hada hebagi ma daane e saavini i denga hoosa ne hulo madali ia; gai se hagabuulingaa dangada soa mmao ne hulo. ");
INSERT INTO nkr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Gai gilaadeu ga hulo gu tae gi de mommee hili huamanu o Atad, se mommee i de baasi gee o Jordan, gai gilaadeu ga tangi ma de hinangalosaa i kilaa. Gai ne hidu laangi a Joseph ne hinangalosaa ai i dono damana. ");
INSERT INTO nkr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Gai ga gidee huu e de gau Canaan, go dangada e nnoho i de henua, de tangi o dangada e hai laa i de mommee hili huamanu o Atad, gai gilaadeu ga hagataba, “De gau Egypt gu hai dahi dangi see laumalie!” Deelaa ai, de mommee laa gu hagaingoo ange go Abel Mizraim, se mommee i gaogao Jordan. ");
INSERT INTO nkr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Gai dama a Jacob ne hai donu ga bei ana muna ne tala ange gi gilaadeu; ");
INSERT INTO nkr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","gilaadeu ne hagauda ia ga kave gi de henua go Canaan, ga danu i lo te haonga i de alahenua i Machpelah i de baasi dua o Mamre, go de alahenua a Abraham ne hagao mai i daho taane Heth go Ephron, e hai ai de mommee o ana daanunga. ");
INSERT INTO nkr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Dua huu dana danu dono damana, gai Joseph ma ono daina daane, aama dangada alodahi ne loomai laa madali ia gi de danu o dono damana gu aahe gi Egypt. ");
INSERT INTO nkr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Gai ga gidee huu e denga daina o Joseph bolo gu magau delaadeu damana, gai gilaadeu ga hagataba, “Agu made Joseph e kino naa i gidaadeu ga sui mai mee baubau alodahi adaadeu ne hai ange gi de ia.” ");
INSERT INTO nkr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Gai gilaadeu ga kave dahi gi hano gi hai ange gi Joseph, “Doo damana ne tala mai i mua dono magau, ga hai mai, ");
INSERT INTO nkr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Goodou hai ange gi Joseph: Aude haihaia degi ange gi haisala o oo daina, i hiidinga baubau alaadeu ne hai adu gi de goe.’ Gai iainei gimaadeu e dangidangi adu koe gi degi mai gi haisala o de gau hai hegau o de Maadua o doo damana.” Gai Joseph gu dangi i dana langona alaadeu muna ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Gai ono daina ga loomai hogi ga hagabaakuu gi honga de gelegele i ono mada i mua, gai gilaadeu ga hai ange gi de ia, “Aanei gimaadeu oo dangada hai hegau.” ");
INSERT INTO nkr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Gai Joseph ga hai ange gi gilaadeu, “Goodou aude maatagu; e dee go au go de Maadua! ");
INSERT INTO nkr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Goodou ne maanadu de hai mai de baubau gi de au, aagai de Maadua ne hagahai hegau de mee laa ga hai ai tanuaa, gai ia ga hagamouli ai dangada soa bei doodou hai gu gidee ai naa anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Deenei ai, goodou aude maatagu, gai au e tilo adu naa donu goodou ma oodou dama.” Gai ia ga hagaaneane olaadeu lodo, ga basa maamaane ange gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Gai Joseph ma de huaabodu o dono damana ne nnoho i Egypt; gai ne 110 ngadau o Joseph ne mouli ai. ");
INSERT INTO nkr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Gai Joseph ne mouli ga gidee e ia tolu atangada o dama a Ephraim. Gai Joseph ne hai hogi dama a Makir, tama daane a Manasseh bei dama ange laa. ");
INSERT INTO nkr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Gai Joseph ga hai ange gi ono daina, “Au gu dai magau naa donu; gai de Maadua e tilo adu naa donu goodou, ga kave gee goodou mai i de henua nei ga kave gi de henua aana gu hagatoo donu ange gi Abraham, ma Isaac aama Jacob.” ");
INSERT INTO nkr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Gai Joseph ga hai de hagadiilinga o Israel gi hagatoo donu gi hai ange, “De Maadua e tilo adu naa donu goodou, gai goodou ga kave ai ogu ivi madali goodou ga hulo gee ai i kinei.”  ");
INSERT INTO nkr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Gai Joseph gu 110 ono ngadau i de masavaa oona ne magau ai; gai ia ne duagi ga tao ga hhao ange gi lo te ngavesi i Egypt.");
INSERT INTO nkr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Aanei ingoo o dama a Israel ma olaadeu huaabodu ne hulo madali Jacob gi Egypt: ");
INSERT INTO nkr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","go Reuben, ma Simeon, ma Levi, ma Judah, ");
INSERT INTO nkr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ma Issachar, ma Zebulun, ma Benjamin, ");
INSERT INTO nkr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ma Dan, ma Naphtali, ma Gad aama Asher. ");
INSERT INTO nkr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Gai dangada alodahi i de huaabodu o Jacob i de masavaa laa se dinohidu, gai Joseph gu hano huu i mua ma gu noho i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Muli mai gai Joseph ma ono daina daane aama de atangada laa alodahi gu odi i de maakau. ");
INSERT INTO nkr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Aagai de aamuli o Israel gu hagadili ga soa mmao; gilaadeu gu hagadaga ange donu de soa ma de mmahi, gai gu soa donu gilaadeu e nnoho i honga de henua alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Gai gu dae ange dahi hodooligi hoou ga dagi Egypt, gai ia e dee iloo Joseph. ");
INSERT INTO nkr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Gai ia ga hai ange gi ono dangada, “De gau Israel gu kii ange donu de soa aama de mmahi ange i gidaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Gidaadeu ga hai gi dee maua e gilaadeu i de hagadili gi soa, gilaadeu kana hagabuni ange gi odaadeu hagadaumee i de masavaa o de hebagi, ga hebagi mai ai gi gidaadeu ma de hulo gee mai i de henua.”  ");
INSERT INTO nkr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Deelaa ai, de gau Egypt ne hili hanu dagi gi hagaduasala ina de gau Israel i denga hegau hai ngadaa, ga hai gilaadeu gi hagatuulia luu aduhale e doange ai goloa o Pharaoh, go Pithom ma Raamses. ");
INSERT INTO nkr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Aagai ga kii ange huu de vaivai hai a de gau Egypt gilaadeu, gai de gau Israel gu kii ange hogi de hagadili ga soa i honga de henua laa. Gai de gau Egypt gu maatagu i gilaadeu, ");
INSERT INTO nkr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ga hai de gau Israel gi hai hegau kona, ");
INSERT INTO nkr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ma de hai gilaadeu gi kona iho i de hilo denga bela pigi ga hai ai denga duudangaa hadu, aama de hagahai hegau gilaadeu i lodo veelenga; de gau Egypt ne hai gi kona hegau a de gau Israel e hai. ");
INSERT INTO nkr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Gai de hodooligi o Egypt ga hai ange gi luu haahine hagahaanau o de gau Hebrew, go Shiphrah ma Pua, ");
INSERT INTO nkr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“De masavaa naa huu ooluu e hagahaanau ai denga haahine Hebrew, gai gooluu dagidiiloo de masavaa olaadeu e nnoho ai e haanau i honga de mommee haanau. Gai noo se gauligi daane, gai gooluu daia gi magau, gai noo se gauligi hahine, gai gooluu dugua gi mouli.” ");
INSERT INTO nkr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Gai luu haahine hagahaanau laa ne maatagu i de Maadua. Deelaa ai, gilaau tee daudali i muna a de hodooligi, aagai ne hagaola hogi denga gauligi daane. ");
INSERT INTO nkr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Gai de hodooligi o Egypt ga aalu luu haahine laa ga ssili ange gi gilaau, “Se hegau bee hee ooluu gu hai naa? Gai gu aha gooluu gu hagaola ai laa hogi denga gauligi daane?” ");
INSERT INTO nkr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Gai luu haahine laa ga hai ange gi Pharaoh, “Go hiidinga denga haahine Hebrew e dee bei dagodo o denga haahine Egypt, gilaadeu e mmahi, gai gilaadeu e haanau i mua demaau tae adu gi olaadeu daha.” ");
INSERT INTO nkr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Deelaa ai, de Maadua ne hagamanuuia luu haahine hagahaanau laa, gai de gau Israel gu kii ange donu de soa aama de mmahi. ");
INSERT INTO nkr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Go hiidinga luu haahine hagahaanau laa ne maatagu i de Maadua, gai ia ga abodonu ange gi gilaau, ga hai gi hanu dama i lodo olaau huaabodu. ");
INSERT INTO nkr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Gai Pharaoh ga hagailoo ange gi dangada alodahi, ga hai ange, “Goodou diiloo mage gaavee denga gauligi daane alodahi e haanau i daho de gau Hebrew, mage dilia ange gi lo te saalingaa vai go Nile, gai hagaola ina alaadeu gauligi haahine.”  ");
INSERT INTO nkr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Gai e dahi hagadiilinga o Levi ne hai bodu ange gi dahi damaa hine hogi de hagadiilinga o Levi. ");
INSERT INTO nkr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Gai de hine laa ne hai dama ga haanau dahi dama daane. Gai ga gidee huu e ia bolo dana gaagaa se dama mahamaha, gai ia ga hagammuni ia i e dolu malama. ");
INSERT INTO nkr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Aagai ga dee maua huu e ia i de hagammuni dana gaagaa, gai ia ga llanga dahi gede i denga papyrus ga haoli tua ma lodo i denga tar gi dee vava ai. Gai ia ga hhao ange dana gaagaa gi lo te gede laa, ga kave ga dugu i gaogao de Nile, i magavaa o denga aalege. ");
INSERT INTO nkr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Gai dono daina hahine ne duu i dahi mommee ga dagidiiloo adu ai be ni aha e hai ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gai tamaa hine a Pharaoh ne humai e gaugau i lo te Nile, gai gilaadeu ma ono haahine hai hegau e seesee i gaogao ssaalingaa vai, gai ia gu gidee adu dahi gede i magavaa o denga aalege, gai ia ga hai dahi ono hahine hai hegau gi hano gi gaamai. ");
INSERT INTO nkr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Gai de masavaa huu aana ne hhuge age ai de gede laa, ga gidee e ia de gaagaa i ono lodo e dangi, gai ia gu aloha i de ia. Gai ia ga hagadaba, “De gaagaa nei go dahi dama donu a de gau Hebrew.” ");
INSERT INTO nkr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Gai taina hahine o de gaagaa laa ga humai ga ssili ange gi tamaa hine a Pharaoh, “Koe e lodo gai au ga hano e ssala dahi hahine Hebrew gi humai gi gaavee tamaa gauligi gi hakaa unuunu ina?” ");
INSERT INTO nkr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Gai tamaa hine a Pharaoh ga hai ange, “Hannoo!” Gai taina hahine o de gaagaa laa ga hano ga ssala mai tinana donu o de gaagaa laa. ");
INSERT INTO nkr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Gai tamaa hine a Pharaoh ga hai ange gi de hine laa, “Gaavee de gaagaa nei mage hakaa unuunu ina ma de haele, gai au ga hagao adu goe.” Gai de hine laa ga kave de gaagaa laa ga hakaa unuunu. ");
INSERT INTO nkr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Gai ga madua huu tamaa gauligi laa, gai de hine laa ga kave ia ga gaavange gi tamaa hine a Pharaoh; gai tamaa hine a Pharaoh ga daohi tama daane laa. Gai ia ga hagaingoo ange ia go Moses, go hiidinga ia ne hagadaba, “Au ne dada age ia i lo te vai.”  ");
INSERT INTO nkr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Gai de masavaa huu o Moses ne madua age ai, gai ia ga hano ga hagadaahao gi daho ono dangada, gai ia gu gidee dagodo delaadeu hai ngadaa. Gai ia ne gidee dahi daane Egypt e daa dahi ono dangada Hebrew.  ");
INSERT INTO nkr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Gai Moses ga galogalo saele ga tilo gu deai ana dangada e gide, gai ia ga daa taane Egypt laa gu magau ga danu i lo te gelegele. ");
INSERT INTO nkr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Gai ia ne ahe ange hogi gi daho ono dangada i de laangi i ono dua, gai ia gu gidee e dogolua daane Hebrew e hebagi. Gai ia ga ssili ange gi taane ne damadaa de hebagi, “Gu aha gu hebagi ange ai naa goe gi doo daina?” ");
INSERT INTO nkr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Gai taane laa ga ssili ange gi de ia, “Goai ne gaavadu gi de goe ssauaa e hagamodu ai amaadeu mee e hai? Gai koe ga daa naa hogi au gi magau, bei dau hai ne hai ai taane Egypt anaahi?” Gai Moses gu madagu, ga hagadaba i ono lodo, “Dangada gu iloo donu agu mee ne hai!” ");
INSERT INTO nkr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Gai ga langona huu e Pharaoh mee nei, gai ia ga ssala Moses e daa gi magau, aagai Moses ga savini ga hano gi Midian e mmuni ai i Pharaoh. Gai ia ga hano ga noho ga hagamabu i gaogao dahi vai geli. ");
INSERT INTO nkr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Gai tangada haimeedabu o de gau Midian e dogohidu ana damaa hine; gilaadeu ne loomai gi de vai laa e asu ai vai e hagaunu ai denga ssiibi a delaadeu damana. ");
INSERT INTO nkr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Gai hanu daane hagaloosi manu ne buibui gilaadeu gi dee asu vai, aagai Moses ne hano ga bale ange gilaadeu ga asu ai vai e hagaunu ai alaadeu manu. ");
INSERT INTO nkr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Gai ga aahe huu denga damaa hine laa gi daho delaadeu damana go Reuel, gai ia ga ssili ange gi gilaadeu, “Gu aha gu moolau mai ai naa goodou anailaa nei?” ");
INSERT INTO nkr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Gai gilaadeu ne pasa ange, ga hai ange, “Go hiidinga dahi daane Egypt ne humai ga hagaola gimaadeu mai i de gau hagaloosi ssiibi ange laa. Ia ne bale mai donu hogi gimaadeu ga asu ai vai e hagaunu ai denga ssiibi.” ");
INSERT INTO nkr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Gai taane laa ga ssili ange gi ana damaa hine, “Gai i hee iai taane naa? Gu aha goodou gu dugu ai laa donu huu ia i kilaa? Goodou hulo gaamai ia e gaimee madali gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Deelaa ai, Moses ne noho i daho taane laa, gai Reuel ga gaavange dana damaa hine go Zipporah gi hai bodu ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Gai Zipporah ne hai dama ga haanau dahi dama daane, gai Moses ga hagaingoo ange ia go Gershom, i hiidinga ia ne hagadaba, “Au se dangada e noho gaainga i dahi henua gee.” ");
INSERT INTO nkr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Dua huu hanu ngadau lagolago, gai de hodooligi o Egypt gu magau. Gai de gau Israel gu duasala mmao i delaadeu hagahai hegau kona ina, gai gilaadeu ga dangidangi i de bale, gai de Maadua gu langona e ia delaadeu dangidangi. ");
INSERT INTO nkr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","De masavaa huu a de Maadua ne langona ai delaadeu tangi, gai ia gu manadua dana hagatoo donu hagaheloongoi madali Abraham, ma Isaac, aama Jacob. ");
INSERT INTO nkr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Gai de Maadua ga galo iho ga tilo dagodo o de gau Israel, gai ia gu iloo olaadeu dagodo. ");
INSERT INTO nkr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses ne hagaloosi de hagabuulingaa ssiibi ma guudi a dono saulaba, go Jethro, tangada haimeedabu o Midian. Gai ia ne dagi ssiibi laa ga hulo ai gilaadeu gi de vao i de bido gi dai, ga hulo gu tae gi Horeb, go mounga o de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Gai tangada de langi o Tagi Maolunga ne hakide ange gi de ia i de ahi ula i lo te manu somo baa i lalo. Gai Moses ne galo ange ga tilo de manu somo laa; gai de ahi e ula i ono lodo, aagai de manu laa e dee vvela donu ono lau. ");
INSERT INTO nkr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Gai Moses ne maanadu age, “Au ga hano nei gi baa ange e tilo de mee hagalele mouli nei, gai gu aha gu dee vela ai laa de manu laa.” ");
INSERT INTO nkr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Gai ga gidee huu e Tagi Maolunga bolo Moses gu humai e hagabaa ange e tilo de manu laa, gai de Maadua ga hagahi mai ia i lo te manu somo laa, ga hai ange, “Moses! Moses!” Gai Moses ga hai ange, “Deenei au.” ");
INSERT INTO nkr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Gai ia ga hai ange, “Aude humai gi hagabaa mai gi de mommee nei, gai koe aaua oo mee vae, go hiidinga de mommee oou e duu ai naa se gelegele dabu. ");
INSERT INTO nkr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Go au de Maadua o oo dubuna madagidagi; go au de Maadua o Abraham, ma de Maadua o Isaac, aama de Maadua o Jacob.” Gai Moses ga haoli luoono mada, go hiidinga ia gu madagu i de galo ange e tilo de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Gai Tagi Maolunga ga hai ange gi de ia, “Au gu gidee donu de duasala o ogu dangada i Egypt, au gu langona hogi delaadeu tangi i hiidinga de hai a olaadeu dagi e hagaduasala ai gilaadeu; au gu iloo donu dagodo o delaadeu duasala. ");
INSERT INTO nkr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Gai au gu hano iho e hagaola gilaadeu mai i ssauaa o de gau Egypt, e kave gee gilaadeu i de henua laa, gi dahi henua danuaa ma de laumalie, se henua iai vai uu ma hooni lagolago, go de henua o de gau Canaan, ma de gau Heth, ma de gau Amor, ma de gau Perez, ma de gau Hiv, aama de gau Jebus. ");
INSERT INTO nkr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Tilo, au gu langona de tangi o de gau Israel, gai au gu gidee hogi de hai a de gau Egypt e hagaduasala ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Deenei ai, au e hai naa goe gi hano gi daho Pharaoh, gai koe ga hagassao mai ai dogu huaadangada, go de gau Israel ga kave gee mai i Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Gai Moses ga hai ange gi de Maadua, “Au e dee bau ange donu gi de hano gi Pharaoh, ma de hagassao mai de gau Israel e kave gee mai i Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Gai de Maadua ga hai ange, “Au e noho naa donu madali goe. Gai deenei de hagailonga e hagadonu ai bolo go au donu ne haia goe gi hano: de masavaa naa huu aau e hagassao mai ai de gau Israel i Egypt, gai goodou e loomai naa ga daumaha mai gi de au i honga de mounga nei.”  ");
INSERT INTO nkr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses ne hai ange gi de Maadua, “Gai noo au e hano ga hai ange gi de gau Israel, ‘De Maadua o oodou dubuna madagidagi ne hai au gi humai gi oodou daha,’ gai gilaadeu ga ssili mai naa, ‘Gai goai donu de ingoo o de Maadua naa?’, gai aahee agu muna e tala ange gi gilaadeu?”  ");
INSERT INTO nkr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gai de Maadua ga hai ange gi Moses, “Go Au donu Go Au. Gai koe hai ange gi de gau Israel, ‘Go Au donu ne haia goe gi hanadu gi olaadeu daha.’ ”  ");
INSERT INTO nkr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Gai de Maadua ne hai ange hogi gi Moses, “Aanei au muna e tala ange gi de gau Israel, ‘Iahweh, de Maadua o oodou dubuna madagidagi, de Maadua o Abraham, ma de Maadua o Isaac, aama de Maadua o Jacob ne haia ngau gi humai.’  Gai deenei dogu ingoo ga hano ai, gai deenei de ingoo oodou e hagamaanadu ai au i daho oodou atangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Gai koe hannoo hagabuni ina denga dagi o Israel, hai ange gi gilaadeu, ‘Iahweh, de Maadua o oodou dubuna madagidagi, go de Maadua o Abraham, ma Isaac, aama Jacob, ne hakide mai gi de au, ga hai mai: Au gu hano iho ma gu gidee mee alodahi gu hai adu gi goodou i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Gai au e hagatoo donu bolo au e hagassao mai naa donu goodou i lalo de hagaduasala a de gau Egypt, e kave goodou gi de henua o de gau Canaan, ma de gau Heth, ma de gau Amor, ma de gau Perez, ma de gau Hiv, aama de gau Jebus, se henua iai vai uu ma hooni lagolago.’ ");
INSERT INTO nkr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Gai gilaadeu e hagallongo adu naa gi de goe; gai goodou ma denga daane maatua o de gau Israel ga hulo ga hai ange gi de hodooligi o Egypt, ‘Iahweh, de Maadua o de gau Hebrew, gu hakide mai gi gimaadeu. Gai dugua mai e dolu laangi e hulo ai gimaadeu gi de vao, e sigidaumaha ange ai gi Tagi Maolunga, demaadeu Maadua.’ ");
INSERT INTO nkr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aagai au e iloo bolo de hodooligi o Egypt e dee dugu adu naa donu goodou gi hulo, deelaa donu huu noo au gu hai gi de mahi ia. ");
INSERT INTO nkr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Deelaa ai, au e hagaduasala naa Egypt i denga sauaa alodahi aagu e hai i honga de henua, gai dua naa huu mee nei, gai de hodooligi ga dugu goodou gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Gai au e hai naa de gau Egypt gi abodonu adu gi goodou, gai goodou e dee ngadi hulo naa donu i doodou masavaa e hulo gee ai. ");
INSERT INTO nkr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Gai denga haahine alodahi gi hai ange gi dangada e nnoho i olaadeu gaogao, ma dangada e nnoho i olaadeu daha gi gaavange gi gilaadeu selevaa, ma goolo, aama denga malo. Gai goodou ga hakahu ai oodou dama aama de dau ange mee nei gi olaadeu ua, gai goodou ga kave ai goloa o de gau Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Gai Moses ga ssili ange hogi, “Gai ni aha naa aagu ga hai noo gilaadeu e dee hagadonusia agu muna, aabe e dee hagallongo mai gi de au, ga hai mai bolo Tagi Maolunga tigi hakide mai donu gi de au?” ");
INSERT INTO nkr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Gai Tagi Maolunga ga ssili ange gi Moses, “Se aha aau e poo naa i doo lima?” Gai Moses ga hai ange, “Se dogo.” ");
INSERT INTO nkr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Gai Tagi Maolunga ga hai ange, “Dilia doo dogo gi honga de gelegele i lalo.” Gai Moses ga tili iho dono dogo gi honga de gelegele, gai togo laa gu se labodo, gai ia ga savini ga hano gi dee baa ange ia aagena. ");
INSERT INTO nkr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Aagai Tagi Maolunga ga hai ange gi de ia, “Haalo ina ange doo lima mage boogia age ssugi.” Gai Moses ne haalo ange dono lima ga poo ssugi o de labodo laa, gai gu ahe ange ga se dogo i lo tono lima. ");
INSERT INTO nkr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","⌊Tagi Maolunga ne hai ange hogi,⌋ “De mee nei se hai gi hagadonusia ai e gilaadeu bolo se muna abodonu Tagi Maolunga, de Maadua o oodou dubuna madagidagi go Abraham, ma Isaac, aama Jacob gu hakide adu donu gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Gai Tagi Maolunga ga hai ange hogi, “Dugua ange doo lima gi honga oo hadahada.” Gai Moses ga dugu ange dono lima gi honga ono hadahada, gai de masavaa huu aana ne aau mai ai dono lima, gai dono lima gu lebelaa ma de tea bei dagodo o denga snow. ");
INSERT INTO nkr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Gai ia ga hai ange, “Hagaahea ange doo lima dugua ange gi honga oo hadahada.” Gai Moses ga ahe ange ga dugu ange dono lima gi honga ono hadahada. Gai de masavaa huu aana ne aau mai ai dono lima, gai gu ahe ange ma gu danuaa bei dono angaanga alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Gai Tagi Maolunga ne hai ange, “Noo koe gu dae gi olaadeu daha, gai gilaadeu e dee hagadonusia au muna aama dau hai tahi sauaa, gai gilaadeu e hagadonusia naa donu au muna i dau hai de lua sauaa. ");
INSERT INTO nkr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Aagai noo gilaadeu e dee hagadonusia luu sauaa laa, aabe e dee llodo e hagallongo au muna, gai koe ga asu mai hanu vai i de Nile ga llingi ange gi honga de gelegele, gai vai laa e sui naa ga ni dodo.” ");
INSERT INTO nkr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Gai Moses ga hai ange gi Tagi Maolunga, “Dogu Ia Aamua, aude haihaia, au e dee maua i de basa i honga o dangada; mai i mua ga dae mai ai gi iainei i doo masavaa ne basa mai ai nei gi de au, doo dangada hai hegau. Au e dee maua i de basa ma de tala gi danuaa agu muna.” ");
INSERT INTO nkr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Gai Tagi Maolunga ga ssili ange gi de ia, “Goai ne haia de ngudu o tangada? Gai goai ne haia tangada lau de alelo ma de longoduli, be go tangada dee gide ma tangada e gide? E dee go au, Tagi Maolunga, ne haia gilaadeu nei alodahi? ");
INSERT INTO nkr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Iainei gai koe hannoo, gai au e hano madali goe, ga tala adu gi de goe au muna alodahi e tala.” ");
INSERT INTO nkr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Gai Moses ga hai ange, “Dogu Ia Aamua, aude haihaia, haia dahi dangada gee gi hano.” ");
INSERT INTO nkr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Gai Tagi Maolunga gu bole mmao i hiidinga muna a Moses, gai ia ga ssili ange, “Gai Aaron taane de aamuli o Levi e dee se daina niiou? Au e iloo bolo ia se dangada e maua i de basa i honga o dangada. Ia e humai naa hogi e hedae adu gi de goe. Gai de masavaa naa huu aana e gidee ai goe, gai ia gu malangilangi. ");
INSERT INTO nkr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Gai koe basa ange gi de ia, ga tala ange ana muna e tala; gai au ga tala ai agu muna i ooluu ngudu aama de agoago adu gooluu i ooluu mee e hai. ");
INSERT INTO nkr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Gai go Aaron e daalaa ange au muna gi dangada; ia e hai naa go doo ngudu, gai ange gi de ia koe e bei de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Gai koe gaavee togo nei madali goe ga hai ai denga sauaa.” ");
INSERT INTO nkr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Gai Moses ne ahe ga hano gi daho dono saulaba go Jethro, ga hai ange gi de ia, “Aude haihaia, au ga ahe nei gi daho ogu dangada i Egypt e tilo ai be gilaadeu goi mouli huu.” Gai Jethro ga hai ange gi Moses, “Hannoo i de baba.” ");
INSERT INTO nkr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Gai de masavaa o Moses goi noho ai i Midian, gai Tagi Maolunga ga hai ange gi Moses, “Ahe hannoo gi Egypt, go hiidinga dangada e nnoho laa e daia goe gi magau gu odi i de maakau.” ");
INSERT INTO nkr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Deelaa ai, gai Moses ga hagauda ange dono bodu ma luaana gauligi daane gi honga dahi donkey ga hulo ai gilaadeu gi Egypt, gai ia ne dagidagi togo o de Maadua i dono lima. ");
INSERT INTO nkr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Gai Tagi Maolunga ne hai ange gi Moses, “De masavaa naa huu oou e dae ai gi Egypt, gai koe hagassula ina denga sauaa alodahi aagu gu gaavadu gi de goe i mada luu mada o Pharaoh. Aagai au e hagamakaga naa lodo o Pharaoh gi dee dugua ai e ia de gau Israel gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Gai koe hai ange gi Pharaoh, ‘E hagadaba Tagi Maolunga: Israel go dagu dama daane madua, ");
INSERT INTO nkr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","gai au e hai adu gi de goe: Dugua dagu dama gi hano, gai ia ga daumaha mai ai gi de au. Aagai noo koe e dee dugu ia gi hano, gai au ga daa dau dama daane madua gi magau.’ ”  ");
INSERT INTO nkr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Gai gilaadeu ne sseni i dahi mommee i gaogao de haiava, gai Tagi Maolunga ne hakide ange gi Moses i kilaa, gai ia ne dai daa donu ia ga magau. ");
INSERT INTO nkr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Aagai Zipporah ne hai dahi hadu kangi ga tuu dagaholiage ai dana dama daane, gai ia ne dugu ange de gili laa gi baa ange gi luu vae o Moses, gai de hine laa ga hai ange, “Ni muna abodonu, koe se bodu iai todo mai gi de au.” ");
INSERT INTO nkr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Gai Tagi Maolunga tee daa Moses gi magau. Gai Zipporah ne hai ange gi Moses, “Koe se bodu iai todo,” i hiidinga o de tuu dagaholiage. ");
INSERT INTO nkr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Gai Tagi Maolunga ne hai ange gi Aaron, “Hannoo hedae ange gi Moses i de vao.” Gai ia ga hano ga hedae ange gi Moses i de mounga o de Maadua, ga oso ia. ");
INSERT INTO nkr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Gai Moses ga tala ange gi Aaron muna alodahi a Tagi Maolunga ne gaamai ia gi daalaa, ma sauaa alodahi a Tagi Maolunga gu tala ange ia gi haia. ");
INSERT INTO nkr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Gai Moses ma Aaron ga hulo ga hagabuni mai denga daane maatua alodahi o de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Gai Aaron ga tala ange gi gilaadeu muna alodahi a Tagi Maolunga gu tala ange gi Moses. Gai ia ga hai denga sauaa i madamada o dangada. ");
INSERT INTO nkr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Deelaa ai, dangada alodahi gu hagadonusia alaau muna. Gai ga langona huu e de gau Israel bolo Tagi Maolunga gu humai donu ma gu gidee e ia olaadeu hagaduasala, gai gilaadeu ga ino ga daumaha ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Gai Moses ma Aaron ga hulo ga hai ange gi Pharaoh, “E hagadaba Iahweh, de Maadua o de gau Israel, ‘Dugua dogu huaadangada gi hulo gi de vao gai gilaadeu ga hai mai ai dahi daonga gi de au.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Aagai Pharaoh ga hai ange, “Gai goai donu go Iahweh, gai au ga daudali ai i ana muna, ma de dugu de gau Israel gi hulo? Au e dee iloo donu be goai go Iahweh. Gai au e dee dugu hogi de gau Israel gi hulo.” ");
INSERT INTO nkr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Gai gilaau ga hai ange, “De Maadua o de gau Hebrew gu hakide mai gi gimaau. Deelaa ai, dugua mai gimaadeu gi hulo gi de vao i e dolu laangi e daumaha ange ai gi Tagi Maolunga, demaadeu Maadua, kana daia e ia gimaadeu i de mee hagamaakau be go de gadilaasa.” ");
INSERT INTO nkr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Aagai de hodooligi o Egypt ga hai ange gi Moses ma Aaron, “Gu aha gooluu gu hai ai naa dangada gi dilia alaadeu hegau? Goodou aahe mage hai hegau!” ");
INSERT INTO nkr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Gai Pharaoh ga hai ange, “Gu soa oodou dangada i honga de henua, gai gooluu e hai gilaadeu gi dee haia alaadeu hegau!” ");
INSERT INTO nkr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","De laangi laa gai Pharaoh ga tala ange gi denga daane Egypt e dagina laa hegau, aama denga daane Israel e hagaseesee ina hegau, ");
INSERT INTO nkr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Gu lava oodou lau grain mmasa e gaavange gi dangada e hai ai denga duudangaa hadu bei laangi i mua. Gai haia gilaadeu gi hulo gi saalaa alaadeu lau grain mmasa. ");
INSERT INTO nkr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Aagai goodou diiloo gilaadeu gi haia donu gi odi ange taelodo o denga duudangaa hadu alaadeu e hai i de laa tubua, e dee hagasogoisi mai donu. Go hiidinga gilaadeu e vaiduu, aanei hiidinga alaadeu e hai mai ai nei bolo gi dugua ange gilaadeu e hulo e daumaha ange gi delaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Haia gi kii ange de kona hegau a dangada, gi deai ai olaadeu masavaa e hulo ai e hagallongo hanu ngadi muna, gai gi haia alaadeu hegau.” ");
INSERT INTO nkr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Gai denga daane o Egypt e dagina laa hegau aama denga daane o Israel e hagaseesee ina laa hegau ga hulo ga hai ange gi de gau Israel, “Bolo i Pharaoh, gu lava ana lau grain mmasa e gaavadu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gai goodou hulo donu huu saalaa oodou lau grain mmasa, gai taelodo o denga duudangaa hadu oodou e hai i dahi laangi e dee hai gi sogoisi mai ange.” ");
INSERT INTO nkr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Deelaa ai, dangada ne hulo ga hagadaga i honga Egypt alodahi ga hagabudu ai denga bulubulu lau mmasa e doe e sui ai denga lau grain mmasa. ");
INSERT INTO nkr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gai denga daane Egypt e dagina hegau ga hagasee dangada ga hai ange, “Goodou haia donu gi odi ange taelodo o denga duudangaa hadu oodou e hai i dahi laangi, bei de masavaa e hanu ai laa lau grain mmasa e gaavadu gi goodou.” ");
INSERT INTO nkr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gai denga daane hagaseesee o de gau Israel, ne hili laa i daho denga daane o Pharaoh e hagahai hegau ina laa dangada gu daia, ma de ssili ange gi gilaadeu, “Gu aha goodou tee hai ai laa gi duu taelodo o oodou duudangaa hadu anaahi ma anailaa nei, bei doodou hai nogo hai ai laa i mua?” ");
INSERT INTO nkr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Gai de gau hagaseesee o de gau Israel ga hulo ga tangi ange gi Pharaoh, ga hai ange, “Gu aha goe gu hagaduasala ai naa gimaadeu, oo dangada hai hegau? ");
INSERT INTO nkr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Gu deai donu lau grain mmasa e gaamai gi gimaadeu, oo dangada hai hegau, gai gilaadeu e hagammahi mai huu gimaadeu gi haia denga duudangaa hadu. Gimaadeu gu daia, gai go de gau Egypt donu e hidi mai ai mee nei.” ");
INSERT INTO nkr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Aagai Pharaoh ga hai ange, “Goodou gu kona donu doodou vaiduu, deelaa ai, goodou e hagataba, ‘Dugua mai gimaadeu e hulo e daumaha ange gi Tagi Maolunga.’ ");
INSERT INTO nkr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Goodou aahe hai hegau iainei; go hiidinga e deai donu lau grain mmasa e gaavadu gi goodou, aagai goodou haia donu gi duu taelodo o denga duudangaa hadu oodou e hai laa gi lava i dahi laangi.” ");
INSERT INTO nkr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Gai denga daane hagaseesee o Israel gu tonu iho bolo gilaadeu gu too ange gi dahi hai ngadaa, i delaadeu hai ange, “Goodou e dee hagasogoisi mai donu oodou duudangaa hadu e hai i dahi laangi.” ");
INSERT INTO nkr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Gai ga hulo gee huu gilaadeu mai i daho Pharaoh, gai gilaadeu gu gidee Moses ma Aaron; gilaau e nnoho ma e tali e hedae ange gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Gai gilaadeu ne hai ange gi gilaau, “Tagi Maolunga gi hagaduasala ina gooluu, go hiidinga gooluu gu hai gi kino Pharaoh ma ono dangada hai hegau i gimaadeu, gai e bei donu gooluu gu gaavange dahi gadilaasa gi gilaadeu gi daia ai gimaadeu gi maakau.” ");
INSERT INTO nkr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Gai Moses ga ssili ange hogi gi Tagi Maolunga, “Dogu Ia Aamua, gu aha goe gu hagaduasala ai naa de huaadangada nei? Gai ni haigamaiana aha dau gaamai au gi olaadeu daha? ");
INSERT INTO nkr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mai taamada dogu hano ga tala ange gi Pharaoh au muna, gai ia tigi tuu donu dana hagaduasala de huaadangada nei; gai koe tigi hagaola hogi oo dangada.” ");
INSERT INTO nkr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Ailaa nei, gai koe e gidee naa dagu hai e hai ai Pharaoh; go hiidinga dogu lima mmahi e hai naa ia gi haia de gau Israel gi hulo, gai ia e hagammahi naa ga alualu gilaadeu gi hulo gee mai i de henua.” ");
INSERT INTO nkr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Gai de Maadua ga hai ange hogi gi Moses, “Go au donu go Iahweh; ");
INSERT INTO nkr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","au ne hakide ange gi Abraham, ma Isaac aama Jacob, go de Maadua Mmahi Mmao laa, aagai au tee hagaago ange gi iloo e gilaadeu dogu ingoo go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Gai au ne hagamakaga dagu hagatoo donu hagaheloongoi ange gi gilaadeu, bolo au e gaavange gi gilaadeu de henua go Canaan, de henua olaadeu ne nnoho gaainga ai laa bei dagodo o de gau henua gee. ");
INSERT INTO nkr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Gai au gu langona hogi de tangi o de gau Israel, i hiidinga delaadeu hagahai hegau ina i lalo o de gau Egypt; gai au gu manadua dagu hagatoo donu hagaheloongoi. ");
INSERT INTO nkr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Deenei ai, daalaa ange gi de gau Israel, hai ange, ‘Go au donu go Iahweh, au e kave gee naa goodou mai i mee hagadaemaha a de gau Egypt e hai ange naa gi goodou, ma de hagaola gilaadeu mai i mee oodou hagaduasala ina ai. Gai au e hagaola naa goodou i dogu lima sauaa ma de hai denga hegau hagalele mouli e hagaduasala ai de gau Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Gai au ga hai naa goodou go ogu dangada, gai au go doodou Maadua, gi iloo ai e goodou bolo go au donu go Iahweh doodou Maadua, go au ne gaavee gee goodou mai i mee a de gau Egypt e hagadaemaha ai goodou. ");
INSERT INTO nkr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Gai au ga kave ai goodou gi de henua aagu gu hagatoo donu ange gi Abraham, ma Isaac, aama Jacob, ga gaavadu e henua ai goodou. Go au donu go Iahweh.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Aanei muna a Moses ne tala ange gi de gau Israel, aagai gilaadeu tee llodo e hagallongo ana muna, go hiidinga gilaadeu gu mmade ange olaadeu aalanga i de kona delaadeu vaivai haia. ");
INSERT INTO nkr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Hannoo hai ange gi Pharaoh, de hodooligi o Egypt, ia gi dugua de gau Israel gi hulo gee mai i dono henua.” ");
INSERT INTO nkr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Aagai Moses ga hai ange gi Tagi Maolunga, “De gau Israel e dee hagallongo mai gi de au, gai dee hee naa de hai o Pharaoh e maua ai i de hagallongo agu muna? Au se dangada donu e dee maua i de basa gi danuaa i honga o dangada.” ");
INSERT INTO nkr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Gai Tagi Maolunga ga basa ange gi Moses ma Aaron, ga tala ange gi gilaau alaau muna e tala ange gi de gau Israel aama Pharaoh, de hodooligi o Egypt, gai gilaau ga dagi ai dangada Israel ga kave gee mai i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Gai aanei dagi o denga aamuli o olaadeu dubuna: Dama a Reuben, tama madua a Israel: go Hanok, ma Pallu, ma Hezron, aama Carmi. Aanei denga huaabodu o de aamuli o Reuben. ");
INSERT INTO nkr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Dama a Simeon: go Jemuel, ma Jamin, ma Ohad, ma Jakin, go Zohar, aama Shaul, tama daane a Simeon ange gi dahi hahine Canaan. Aanei denga huaabodu o de aamuli o Simeon. ");
INSERT INTO nkr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Gai aanei ingoo o dama a Levi ma olaadeu atangada: go Gershon, ma Kohath, aama Merari. Gai ngadau o Levi ne mouli ai se 137. ");
INSERT INTO nkr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Dama a Gershon: go Libni ma Shimei, ma olaau huaabodu. ");
INSERT INTO nkr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Dama a Kohath: go Amram, ma Izhar, ma Hebron aama Uzziel. Gai ngadau o Kohath ne mouli ai se 133. ");
INSERT INTO nkr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Dama a Merari: go Mahli ma Mushi. Aanei denga hagadiilinga o de aamuli o Levi ma olaadeu atangada. ");
INSERT INTO nkr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Gai Amram ne hai bodu ange gi taina hahine o dono damana go Jochebed, gai ia ga haanau Aaron ma Moses. Gai ngadau o Amram ne mouli ai se 137. ");
INSERT INTO nkr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Dama a Izhar: go Korah, ma Nepheg, aama Zicri. ");
INSERT INTO nkr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Dama a Uzziel: go Mishael, ma Elzaphan, aama Sithri. ");
INSERT INTO nkr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Gai Aaron ne hai bodu ange gi Elisheba, tamaa hine a Amminadab, gai se daina hahine niio Nahshon, gai ia ne haanau Nadab, ma Abihu, ma Eleazar aama Ithamar. ");
INSERT INTO nkr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Dama a Korah: go Assir, ma Elkanah aama Abiasaph. Aanei denga huaabodu o de aamuli o Korah. ");
INSERT INTO nkr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Gai Eleazar tama daane a Aaron ne hai bodu ange gi dahi damaa hine a Putiel; gai tamaa hine laa ne haanau Phinehas. Aanei dagi o de aamuli o Levi ma olaadeu hagadiilinga. ");
INSERT INTO nkr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aanei Moses ma Aaron a Tagi Maolunga ne hai ange laa, “Gooluu dagina huaadangada o Israel i denga hagabuulinga hebagi mage gaavee gee mai i de henua go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Gai go gilaau ne hai ange laa gi Pharaoh, de hodooligi o Egypt, ga kave gee nei de gau Israel mai i Egypt, go Moses ma Aaron. ");
INSERT INTO nkr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","De laangi o Tagi Maolunga ne basa ange ai gi Moses i Egypt, ");
INSERT INTO nkr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","gai ia ne hai ange, “Go au donu go Iahweh! Gai koe daalaa ange gi Pharaoh, de hodooligi o Egypt agu muna alodahi e tala adu gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Aagai Moses ne hai ange gi Tagi Maolunga, “Tilo, au se dangada e dee maua i de basa i honga o dangada; gai dee hee naa de hai o Pharaoh e maua ai gi hagallongo mai gi agu muna?” ");
INSERT INTO nkr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Au e hai naa goe gi bei dagodo o de Maadua i daho Pharaoh, gai doo daina daane go Aaron e bei naa dagodo o de pelaabisi i oo daha. ");
INSERT INTO nkr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Gai koe ga tala ange gi doo daina go Aaron mee alodahi aagu e tala adu gi de goe, gai ia ga tala ange gi Pharaoh, gi dugua ai e ia de gau Israel gi hulo gee mai i dono henua. ");
INSERT INTO nkr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Aagai au e hagamakaga naa lodo o Pharaoh, gai au ga hai agu hagailonga lagolago ma mee hagalele mouli i de henua go Egypt, ");
INSERT INTO nkr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","aagai Pharaoh e dee hagallongo adu naa donu gi de goe. Gai au e hagaduasala naa Egypt, ga dagi dogu huaadangada go de gau Israel ga kave gee mai i de henua go Egypt, ");
INSERT INTO nkr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","gi iloo ai de gau Egypt bolo go au donu go Iahweh, i de masavaa aagu e hagaduasala ai gilaadeu, ga kave gee de gau Israel mai i olaadeu daha.” ");
INSERT INTO nkr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Gai Moses ma Aaron ga hai gu bei muna a Tagi Maolunga gu tala ange gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Gai Moses gu madavalu ono ngadau, gai Aaron gu madavalu ma dolu ono ngadau, i de masavaa olaau ne hulo ai ga tala ange muna nei gi Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“De masavaa naa huu a Pharaoh e hai adu ai gooluu gi haia dahi mee hagalele mouli, gai koe ga hai Aaron gi dilia iho dono dogo i mada luu mada o Pharaoh, gai togo laa e sui naa ga se labodo.” ");
INSERT INTO nkr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Gai Moses ma Aaron ga hulo gi daho Pharaoh ga hai donu gu bei muna a Tagi Maolunga gu tala ange gi gilaau. Aaron ne tili iho dono dogo gi lalo i madamada o Pharaoh ma ono dangada hai hegau, gai togo laa gu sui ga se labodo. ");
INSERT INTO nkr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Gai Pharaoh ga hagahi ono daane heiangi ma de gau hai huuhuaa mee; gai de gau hai huuhuaa mee o Egypt ga hai hogi olaadeu dogo gu ni labodo. ");
INSERT INTO nkr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gilaadeu alodahi ne tili iho hogi olaadeu dogo gi honga de gelegele, gai denga dogo laa gu sui ga ni labodo. Aagai togo o Aaron ga holo denga labodo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Gai Pharaoh goi hagamakaga huu ono lodo; ia tee hagallongo ange gi alaau muna, bei de hai a Tagi Maolunga gu tala ai laa. ");
INSERT INTO nkr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Gai Tagi Maolunga ga hai ange gi Moses, “Pharaoh goi hagamakaga huu ono lodo, ia e dee lodo e dugu de huaadangada naa gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Hannoo gi daho Pharaoh i boo taiao, i de masavaa oona e hano ai gi de vai; gai koe hannoo basa ange gi de ia i gaogao ssaalingaa vai go Nile, gai koe gaavee togo ne sui laa ga se labodo madali goe. ");
INSERT INTO nkr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Gai koe ga hai ange gi de ia, ‘Iahweh, de Maadua o de gau Hebrew, ne hai au gi humai gi oo daha, gi hai adu: Dugua dogu huaadangada gi hulo gi daumaha mai gi de au i de vao. Gai tilo, koe tigi hagallongo mai donu ga dae mai ai gi iainei. ");
INSERT INTO nkr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","E hagadaba Tagi Maolunga: De mee nei se hai gi iloo ai e goe bolo go au donu go Iahweh. Au e hagaili naa honga ssaalingaa vai go Nile i togo i lo togu lima nei, gai denga vai iai e sui naa ga ni dodo. ");
INSERT INTO nkr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Gai denga mamu i lo te saalingaa vai go Nile e odi naa i de maakau, ga hai de vai laa gu pilo, gai de gau Egypt e kino naa i de unu vai o de Nile.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Gai Tagi Maolunga ga hai ange gi Moses, “Hai ange gi Aaron ia gi boogia dono dogo gi haalo ina ange gi honga denga vai alodahi o Egypt; go honga alaadeu leevaa ma saalingaa vai, ma geelonga iai laa vai, aama mommee alodahi e dugu ai vai, gai denga vai e sui naa gi ni dodo. Gai gi ni dodo ai denga vai alodahi i honga de henua go Egypt, ma denga vai hogi i lodo mee hao vai laagau aama mee hao vai hadu.” ");
INSERT INTO nkr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Gai Moses ma Aaron ne hai donu ga bei muna a Tagi Maolunga gu tala ange gi gilaau; Aaron ne haalo togo ga hagaili ai honga ssaalingaa vai go Nile i mada i mua o Pharaoh ma ono dangada hai hegau, gai denga vai alodahi o de Nile gu sui ga ni dodo. ");
INSERT INTO nkr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Gai mamu i lo te saalingaa vai go Nile gu odi i de maakau. Gai vai o de Nile gu hagapilo; de gau Egypt gu dee maua i de unu ai, gai vai alodahi i honga de henua go Egypt gu ni dodo. ");
INSERT INTO nkr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Aagai denga daane hai huuhuaa mee o Egypt ga helau hogi hanu vai gu ni dodo. Gai Pharaoh tee sui donu de makaga ono lodo; ia tee hagallongo ange gi Moses ma Aaron, bei de hai a Tagi Maolunga gu tala ai laa. ");
INSERT INTO nkr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Gai Pharaoh ga huli ga ahe gi dono hale, ia tee anga ange donu gi mee laa. ");
INSERT INTO nkr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Gai de gau Egypt alodahi ga geli luu baasi o ssaalingaa vai go Nile e ssala ai hanu vai unu, i hiidinga gilaadeu gu dee maua i de unu vai i lo te Nile. ");
INSERT INTO nkr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","De masavaa laa gai gu hidu laangi i dua de hai a Tagi Maolunga ga dee maua i de unu vai i lo te Nile. ");
INSERT INTO nkr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Hannoo hai ange gi Pharaoh, ‘E hagadaba Tagi Maolunga: Dugua dogu huaadangada gi hulo gi daumaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aagai noo koe e dee dugu gilaadeu gi hulo, gai au e hagaduasala naa doo henua alodahi i denga kailu. ");
INSERT INTO nkr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","De Nile e hai naa ga galigi i denga kailu. Gilaadeu e loage naa gi lo too hale ma doo aabi seni ma honga oo moenga, ma de hulo gi lodo hale o oo dangada hai hegau ma doo huaadangada, ma lodo mommee dao gai aama lodo gumedi mmili gai. ");
INSERT INTO nkr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Denga kailu e llele age naa gi honga doo henua ma honga oo dangada aama honga oo dagi alodahi.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Gai Tagi Maolunga ga hai ange gi Moses, “Hai ange gi Aaron ia gi haalo ina ange dono dogo gi honga denga leevaa ma saalingaa vai, ma geelonga iai laa vai, ma gi haia ai gi loage denga kailu gi honga de henua go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Gai Aaron ga poo dono dogo ga haalo ange gi honga denga vai o Egypt; gai denga kailu gu loage ga hhao honga de henua alodahi go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Aagai de gau hai huuhuaa mee ne helau hogi gu loage denga kailu gi honga de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Gai Pharaoh ne hagahi Moses ma Aaron, ga hai ange, “Dangidangi ange gi Tagi Maolunga ia gi haia gi hulo gee denga kailu mai i ogu daha ma daho dogu huaadangada, gai au ga dugu dangada gi hulo gi haia alaadeu sigidaumaha ange gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Gai Moses ga hai ange gi Pharaoh, “Go koe dugua mai de masavaa oogu e dalodalo ai i oodou hiidinga ma oo dangada hai hegau aama doo huaadangada, gi odi ai de maakau denga kailu i oodou daha, ma lodo oodou hale. Gai go denga kailu donu huu i lo te Nile e doe.” ");
INSERT INTO nkr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Gai Pharaoh ga hai ange, “Go daiao.” Gai Moses ga hai ange, “E hai naa donu gi bei au muna, gi iloo ai e goe bolo e deai ange donu e bei dagodo o Iahweh demaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Gai denga kailu e hulo gee naa donu mai i doo daha ma mai i lodo oo hale, ma mai i daho oo dangada hai hegau aama doo huaadangada alodahi. Gai go denga kailu donu huu i lo te Nile e doe.” ");
INSERT INTO nkr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Gai Moses ma Aaron ga hulo gee mai i daho Pharaoh, gai Moses ga dangidangi ange gi Tagi Maolunga gi gaavee gee denga kailu aana ne gaamai laa ga hagaduasala ai Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Gai Tagi Maolunga ga hai gu bei tangidangi a Moses; gai denga kailu i lodo hale ma lodo buibui i luu baasi denga hale, aama mommee i tua de aduhale gu odi i de maakau. ");
INSERT INTO nkr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gai dangada ga hagabudubudu denga kailu ga dugu ai, gai de henua alodahi gu kona donu de pilo. ");
INSERT INTO nkr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Aagai ga gidee huu e Pharaoh bolo de hagaduasala laa gu ui gee, gai ia ga hagamakaga ono lodo; ia tee hagallongo ange gi Moses ma Aaron, bei de hai a Tagi Maolunga gu tala ai laa. ");
INSERT INTO nkr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Gai Tagi Maolunga ga hai ange gi Moses, “Hai ange gi Aaron ia gi haia dono dogo gi hagailihia ai honga de gelegele o de henua, gai gelegele alodahi i honga de henua go Egypt e sui naa gi ni manu hakadigadi.” ");
INSERT INTO nkr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Gai Moses ma Aaron ne hai ga bei muna laa; Aaron ne hai dono dogo ga hagaili ai honga de gelegele, gai denga gelegele gu sui ga ni manu hakadigadi e toga ange gi honga o dangada ma honga o denga manu dolodolo. Gai gelegele alodahi i honga de henua go Egypt gu ni manu hakadigadi. ");
INSERT INTO nkr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Gai denga daane hai huuhuaa mee ne hagatale hogi de helau gi hanu manu hakadigadi, aagai tee maua e gilaadeu i de hai. Gai denga manu hakadigadi laa ne loomai ga toga ange gi honga o dangada aama manu dolodolo. ");
INSERT INTO nkr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Gai denga daane hai huuhuaa mee ga hai ange gi Pharaoh, “De mee nei go de madannia donu o de Maadua.” Aagai Pharaoh goi hagamakaga huu ono lodo, ia tee hagallongo ange donu gi gilaau, bei de hai a Tagi Maolunga gu tala ai laa. ");
INSERT INTO nkr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Gai Tagi Maolunga ga hai ange hogi gi Moses, “Oho age i taiao daiao mage hannoo daalia Pharaoh, i de masavaa oona e hano ai gi de vai, ga hai ange gi de ia, ‘E hagadaba Tagi Maolunga: Dugua dogu huaadangada gi hulo gi daumaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Gai noo koe e dee dugu ogu dangada gi hulo, gai au e hai naa gi loomai de hagabuulingaa lango gi toga i honga oodou ma oo dangada hai hegau ma doo huaadangada, ma de ulu gi lodo oodou hale. Gai lodo hale o de gau Egypt ma honga de gelegele olaadeu e tuu ange laa aagena e hoohonu naa i denga lango. ");
INSERT INTO nkr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","De laangi laa gai au e vae dangada naa i dagu hai e hai ai de mommee go Goshen, e nnoho ai laa dogu huaadangada. Deelaa ai, e deai naa donu se lango daudahi i kilaa, gi iloo ai e goe bolo go au donu go Iahweh, au e noho donu i honga de henua nei. ");
INSERT INTO nkr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Gai au e hai naa gi dagodo gee dagu hai e hai ai dogu huaadangada ma doo huaadangada. Gai de hagailonga nei e hai naa daiao.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Gai Tagi Maolunga ne hai ga bei mee nei. De hagabuulingaa lango ne loomai ga ulu gi lo te hale o Pharaoh ma hale o ono dangada hai hegau, aama de loomai gi honga de henua alodahi o Egypt. Gai de henua gu hakino gee i hiidinga gu honu de lango. ");
INSERT INTO nkr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Gai Pharaoh ga aalu Moses ma Aaron, ga hai ange, “Goodou hulo donu huu sigidaumaha ange gi doodou Maadua i dahi mommee i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Aagai Moses ga hai ange, “E dee danuaa demaadeu hai de hegau nei i honga de henua, go hiidinga de gau Egypt e kino i denga sigidaumaha amaadeu e hai ange gi Tagi Maolunga demaadeu Maadua. Gai noo gimaadeu e hai denga sigidaumaha o de gau Egypt e kino ai laa, gai gilaadeu e dee maga naa gimaadeu i denga hadu? ");
INSERT INTO nkr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Gai e danuaa donu demaadeu hulo gi de vao i e dolu laangi e hai ai demaadeu sigidaumaha ange gi Tagi Maolunga demaadeu Maadua, bei dana hai gu tala mai ai gi gimaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Gai Pharaoh ga hai ange, “Au e dugu adu goodou gi hulo gi haia doodou sigidaumaha ange gi Tagi Maolunga doodou Maadua i de vao, gai goodou e dee hulo gi mmao. Gai goodou dalodalo hogi i de au.” ");
INSERT INTO nkr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Gai Moses ga hai ange, “Tilo, de masavaa naa huu oogu e hano gee mai ai i oo daha, gai au e dangidangi ange naa gi Tagi Maolunga, gai denga hagabuulingaa lango e hulo gee mai naa i daho Pharaoh, ma mai i daho ono dangada hai hegau, aama mai i daho ono dangada daiao. Gai Pharaoh gi dagidiiloo, ia kana ahe ange ga dee dugu de gau Israel gi hulo e sigidaumaha ange gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Gai Moses ga hano gee mai i daho Pharaoh, gai ia ga dangidangi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Gai Tagi Maolunga ga hai gu bei tangidangi a Moses, ga hai gu hulo gee denga lango mai i daho Pharaoh ma ono dangada hai hegau aama dono huaadangada. Gai gu deai donu se lango daudahi e doe i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Aagai Pharaoh ne hagamakaga hogi ono lodo i de hanonga laa, ia tee dugu de gau Israel gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Hannoo gi daho Pharaoh, hai ange gi de ia: ‘E hagadaba Tagi Maolunga de Maadua o de gau Hebrew: Dugua dogu huaadangada gi hulo gi daumaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Gai noo koe e dee dugu gilaadeu gi hulo, gai e daohi huu gilaadeu, ");
INSERT INTO nkr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","gai tilo, Tagi Maolunga e gaamai de magi hagamaakau e daa ai au manu haangai i lo te duu malaelae, go au hoosa, ma donkey, ma gamelo, ma kaau, ma ssiibi aama guudi. ");
INSERT INTO nkr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Aagai Tagi Maolunga e hai naa gi dagodo geegee dana hai e hai ai denga manu haangai a de gau Israel aama manu haangai a de gau Egypt, gai e deai naa donu se manu daudahi a de gau Israel e magau.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Gai Tagi Maolunga ga hagamodu de masavaa, ga hai ange, “Daiao gai Tagi Maolunga e hai naa de hegau nei i honga de henua.” ");
INSERT INTO nkr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Gai Tagi Maolunga ne hai de hegau nei i de laangi mai ange laa; denga manu haangai alodahi a de gau Egypt gu maakau, aagai teai donu se manu daudahi ne magau i manu haangai a de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Gai Pharaoh ne hai hanu gi hulo gi diiloo, gai gilaadeu gu gidee bolo teai donu se manu daudahi a de gau Israel ne magau. Aagai Pharaoh ne hagamakaga ono lodo; ia tee dugu de gau Israel gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, “Gooluu haalia age i ooluu lima hanu lehu mai i de mommee o de ahi, gai Moses gi magaa denga lehu nei gi lo te moana i lunga i mada i mua o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Gai denga lehu nei e sui naa ga se mama i honga de henua o Egypt alodahi, gai denga mama nei e hagahale ai naa denga hagahoa i angaanga o dangada ma manu alodahi i honga de henua go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Deelaa ai, gai gilaau ga hhali age hanu lehu i de mommee o de ahi, ga kave ga hulo ai ga tuu i mada luu mada o Pharaoh, gai Moses ga maga lehu laa gi lo te moana i lunga, gai lehu laa ga hagahale denga hagahoa i angaanga o dangada aama denga manu. ");
INSERT INTO nkr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Gai denga daane hai huuhuaa mee gu dee maua e gilaadeu i de tuu i mada luu mada o Moses i olaadeu hagahoa, go hiidinga denga hagahoa gu ssomo hogi i denga daane hai huuhuaa mee aama de gau Egypt alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Gai Tagi Maolunga ga hagamakaga lodo o Pharaoh, gai ia tee hagallongo ange gi Moses ma Aaron, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Gai Tagi Maolunga ne hai ange gi Moses, “Oho age i taiao hannoo duu i mada i mada o Pharaoh, hai ange gi de ia, ‘E hagadaba Tagi Maolunga, de Maadua o de gau Hebrew: Dugua dogu huaadangada gi hulo gi daumaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Go hiidinga de hanonga nei gai au e gaamai naa denga mee hagamaakau e hagaduasala ai goe, ma oo dangada hai hegau, aama doo huaadangada alodahi, gi iloo ai e goe bolo e deai ange donu e bei ogu dagodo i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Gai au ne maua donu i de daa gi maakau goodou ma oo dangada hai hegau, aama oo dangada alodahi i denga mee hagamaakau, gi dee mouli ai goodou i henua i lalo. ");
INSERT INTO nkr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Aagai au ne dugu goe gi mouli e hagaago adu ai gi de goe dogu sauaa mmahi, gi hagadeledele danuaa ai dogu ingoo i henua i lalo alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Gai koe e duudagi donu huu de hagamaolunga huu i dogu huaadangada, koe tigi dugu donu gilaadeu gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tilo, daiao i de masavaa bee nei, gai au e hai naa gi too iho denga duudangaa haisi nnui ma de daemaha, gai mee nei tigi ai donu se hai i Egypt mai taamada age de dahi o Egypt ga dae mai ai gi iainei. ");
INSERT INTO nkr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Gai goodou hagalilo ina mai oodou manu haangai, ma oodou goloa alodahi i lo te duu malaelae, go hiidinga dangada ma manu alodahi e dee hagalilo mai gi lodo, aagai e nnoho i lo te duu malaelae, e maakau naa donu i delaadeu balabalasia i denga duudangaa haisi.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Gai de gau hai hegau alodahi o Pharaoh e maatagu laa i muna a Tagi Maolunga ne hagalilo mai olaadeu dangada hai hegau ma alaadeu manu haangai gi lodo hale, ");
INSERT INTO nkr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","aagai dangada alodahi ne hagangadi mee ina laa muna a Tagi Maolunga ne dugu donu huu olaadeu dangada hai hegau ma alaadeu manu haangai i lo te duu malaelae. ");
INSERT INTO nkr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Gai Tagi Maolunga ga hai ange gi Moses, “Haalo ina doo lima gi lo te moana i lunga, gi too iho ai denga duudangaa haisi gi honga de henua alodahi go Egypt; gi honga o dangada, ma manu dolodolo aama honga o denga manu ssomo alodahi i de henua o Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Gai Moses ga haalo dono dogo gi lo te moana i lunga; gai Tagi Maolunga ga hagababaa denga hatuli ma de too iho denga duudangaa haisi, gai de ahi ula gu hano iho gi honga de gelegele. Gai Tagi Maolunga ga hai gu too iho denga duudangaa haisi gi honga de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Gai gu too iho denga duudangaa haisi ma de ahi ula madali denga duudangaa haisi laa. Gai tigi ai ange hegau bee nei gu hai i de henua go Egypt mai i dono daamada age ga dae mai ai gi de laangi laa. ");
INSERT INTO nkr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Gai denga duudangaa haisi laa ne too iho ga oha mee alodahi i lo te duu malaelae tee hagalilo mai laa gi lodo i de henua go Egypt; go dangada ma manu dolodolo, ma manu ssomo vaaligiligi aama manu ssomo nnui i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Go Goshen donu huu, de mommee o de gau Israel e nnoho ai laa, teai duudangaa haisi ne too iho aagena. ");
INSERT INTO nkr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Gai Pharaoh ga aalu Moses ma Aaron ga hai ange gi gilaau, “Au gu haisala donu i de hanonga nei; Tagi Maolunga e heohi, gai go gimaadeu ma dogu huaadangada ne baubau. ");
INSERT INTO nkr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Gooluu dangidangi ange gi Tagi Maolunga gi haia gi deai hatuli ma duudangaa haisi aana gu hai laa gi loomai. Gai au e dugu naa goodou gi hulo gi dee nnoho ai goodou i kinei.” ");
INSERT INTO nkr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Gai Moses ga hai ange gi de ia, “Dogu masavaa naa donu huu e sao ai ga hano gee i de aduhale, gai au ga haalo dogu lima ga dalodalo ange gi Tagi Maolunga, gai denga hatuli gu dee babaa, gai gu deai hogi duudangaa haisi e too iho, gi iloo ai e goe bolo henua i lalo niio Tagi Maolunga donu. ");
INSERT INTO nkr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Gai au e iloo bolo goodou ma oo dangada hai hegau tigi maatagu donu i Tagi Maolunga de Maadua.” ");
INSERT INTO nkr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Gai denga flax ma denga barley gu odi i de baubau, go hiidinga de masavaa ne hai ai mee nei gai denga barley gu iai hua, gai denga flax gu aala hogi. ");
INSERT INTO nkr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Gai denga grain ma denga spelt tee baubau, go hiidinga luu manu nei tigi loage gai e loage i muli mai. ");
INSERT INTO nkr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Gai Moses ne hano gee mai i daho Pharaoh, ga sao ga hano gee i de aduhale laa, gai ia ga haalo dono lima ga dalodalo ange gi Tagi Maolunga, gai denga hatuli gu dee babaa, denga duudangaa haisi gu helui de too iho, gai gu dee pala hogi de langi i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Aagai ga gidee huu e Pharaoh bolo gu helui de pala iho de langi ma denga duudangaa haisi, gai denga hatuli gu dee babaa, gai gilaadeu ma ono dangada hai hegau ga aahe ange ga hagamakaga olaadeu lodo. ");
INSERT INTO nkr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Gai lodo o Pharaoh gu kii ange donu i de makaga. Ia tee dugu ange donu de gau Israel gi hulo gee, bei de hai a Tagi Maolunga gu tala ange ai laa i daho Moses. ");
INSERT INTO nkr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Hannoo gi daho Pharaoh, go hiidinga au gu hai gi makaga ono lodo ma lodo o ono dangada hai hegau, gi maua ai e au i de hagaago ange gi gilaadeu agu sauaa hagalele mouli, ");
INSERT INTO nkr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","gai goodou ga tala ange ai gi langona e oodou dama ma oodou mogobuna dagu hai ne hai ai de gau Egypt, aama mee hagalele mouli aagu ne hai i daho de gau Egypt; gai gi iloo ai e goodou bolo go au donu go Iahweh.” ");
INSERT INTO nkr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Gai Moses ma Aaron ga hulo gi daho Pharaoh, ga hai ange gi de ia, “E hagadaba Tagi Maolunga de Maadua o de gau Hebrew, ‘Dee hee maa taulooloa dau dee lodo e hagamaolalo goe i mada luoogu mada? Dugua dogu huaadangada gi hulo, gi maua ai e gilaadeu i de daumaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Gai noo koe e dee dugu dogu huaadangada gi hulo, gai au e gaamai naa denga itebuubuu gi honga doo henua daiao. ");
INSERT INTO nkr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Gilaadeu e loomai naa ga haoli honga de henua, ga dee gidee e dangada de gelegele. Gilaadeu e gai naa momo mee tee oohaa e denga dibadibaa haisi, ma manu ssomo nnui alodahi i honga oodou gelegele. ");
INSERT INTO nkr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gilaadeu e loomai naa ga hhao lodo oo hale ma lodo hale o oo dangada hai hegau aama hale o de gau Egypt alodahi; gai oodou damana ma oodou dubuna tee gidee donu hanu hegau bee nei, mai i de masavaa olaadeu ne haanau ai ga dae mai ai gi anailaa nei.’ ” Gai Moses ga huli ga hano gee mai i daho Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Gai de gau hai hegau o Pharaoh ga hai ange gi de ia, “Dee hee maa taulooloa de hagaduasala a taane nei gidaadeu? Dugua denga daane gi hulo gi daumaha ange gi Tagi Maolunga delaadeu Maadua. Koe e dee gidee iho nei bolo Egypt gu maoha donu?” ");
INSERT INTO nkr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Deelaa ai, Moses ma Aaron gu hagaahea mai ange hogi gi daho Pharaoh. Gai ia ga hai ange gi gilaau, “Goodou hulo daumaha ange gi Tagi Maolunga doodou Maadua. Gai goai donu e hulo i oodou magavaa?” ");
INSERT INTO nkr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Gai Moses ga hai ange, “Go gimaadeu alodahi e hulo madali amaadeu gauligi mmodo ma amaadeu dangada maatua, ma amaadeu dama daane ma damaa hine, ma amaadeu ssiibi ma guudi aama kaau, go hiidinga gimaadeu e hulo naa e hai ange taonga gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Gai Pharaoh ga hai ange gi gilaau, “Tagi Maolunga gi balea adu goodou, go hiidinga au e dee haihai naa donu ga dugu adu goodou gi gaavee oodou gauligi madali goodou! Au e iloo bolo goodou gu maanadu de hai dahi hegau baubau. ");
INSERT INTO nkr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","E deai! Go goodou donu huu denga daane e hulo ga daumaha ange gi Tagi Maolunga, i hiidinga goodou ne llodo e hai de mee nei.” Gai Moses ma Aaron gu alualumia gi hulo gee mai i mada luu mada o Pharaoh. ");
INSERT INTO nkr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Aagai Tagi Maolunga ga hai ange gi Moses, “Haalo ina doo lima gi lo te moana i honga de henua go Egypt, gi loomai ai denga itebuubuu gi honga de henua o Egypt gi gaina denga manu ssomo alodahi a denga duudangaa haisi tee oha.” ");
INSERT INTO nkr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Gai Moses ga poo dono dogo ga haalo gi lo te moana i honga de henua go Egypt, gai Tagi Maolunga ga hai gi ssau mai de madangi i dua i honga de henua alodahi i de laangi laa ma de boo laa alodahi. Gai de masavaa huu ne ao ai de mee, gai de madangi mai i dua gu ili mai denga itebuubuu gi honga de henua. ");
INSERT INTO nkr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Gai denga itebuubuu ne loomai ga hhao honga de henua alodahi go Egypt. Gai gilaadeu ga toga i honga denga ungaamee alodahi o de henua go Egypt, gai gu kona mmao i de lagolago itebuubuu. Gai tigi ai ange donu se lagolago itebuubuu bee nei i denga masavaa gu hulo, aabe go masavaa e loomai. ");
INSERT INTO nkr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Gai denga itebuubuu ne loomai ga hhao honga de gelegele o de henua alodahi, ga hai gu honga de henua. Gai gilaadeu ga gai manu ssomo alodahi tee oohaa i denga duudangaa haisi — go mee alodahi e ssomo i honga de gelegele ma olaadeu hua. Gu deai donu hua aabe ni lau i denga manu ssomo nnui aama manu ssomo vaaligiligi i de henua alodahi o Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Gai Pharaoh ga hagamoolau ga hagahi Moses ma Aaron, ga hai ange, “Au gu haisala ange gi Tagi Maolunga doodou Maadua aama adu gi gooluu. ");
INSERT INTO nkr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Gai au e dangidangi adu gooluu gi degi mai gi ogu haisala i de hanonga nei, mage dangidangi ange gi Tagi Maolunga doodou Maadua gi gaavee gee de mee hagamaakau nei mai i ogu daha.” ");
INSERT INTO nkr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Gai Moses ga hano gee mai i daho Pharaoh ga dalodalo ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Gai Tagi Maolunga ga hai gi dahuli de madangi mmahi ga humai i dai, ga ili denga itebuubuu ga kave gi lo te Dai Mmea, gai gu deai donu se itebuubuu daudahi e doe i honga de henua alodahi o Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Gai Tagi Maolunga ga hagamakaga lodo o Pharaoh gi dee dugua ai e ia de gau Israel gi hulo gee. ");
INSERT INTO nkr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Gai Tagi Maolunga ga hai ange gi Moses, “Haalo ina doo lima gi lo te langi i lunga gi gohu ai honga de henua o Egypt i de gohu boo dangodango.” ");
INSERT INTO nkr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Gai Moses ga haalo dono lima gi lo te langi i lunga, gai gu gohu boo dangodango honga de henua alodahi o Egypt i e dolu laangi. ");
INSERT INTO nkr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Gai gu deai se dangada e gidee dahi dangada gee, aabe se dangada ne maua i de hidi age e hano gi dahi mommee gee i laangi e dolu laa. Aagai de mommee o de gau Israel e nnoho ai laa goi maalama donu huu. ");
INSERT INTO nkr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Gai Pharaoh ga hagahi Moses, ga hai ange, “Goodou gaavee oodou dama mage hulo daumaha ange gi Tagi Maolunga, aagai goodou e dee kave oodou ssiibi ma kaau madali goodou.” ");
INSERT INTO nkr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Aagai Moses ga hai ange, “Koe e dee maua donu i de buibui gimaadeu gi dee gaavee manu e hai ai amaadeu sigidaumaha aama amaadeu sigidaumaha dudu, gi maua ai e gimaadeu i de sigidaumaha ange gi Tagi Maolunga demaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Deelaa ai, amaadeu manu haangai e kave donu madali gimaadeu, e deai donu se manu daudahi e dugu i kinei, go hiidinga gimaadeu e hili naa hanu e daumaha ange ai gi Tagi Maolunga demaadeu Maadua. Gai gimaadeu e dee iloo be aahee manu e heohi ange gi demaadeu daumaha ange ai gi Tagi Maolunga, ga dae ai gi demaadeu tae gi kilaa.” ");
INSERT INTO nkr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Gai Tagi Maolunga ga hagamakaga lodo o Pharaoh, gai ia tee dugu gilaadeu gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Gai Pharaoh ga hai ange gi Moses, “Hagamoolau hano gee mai i kinei! Gai koe kana ahe ange ga humai gi mada luoogu mada, go hiidinga de laangi naa donu huu aau e ahe ange ai ga gidee luoogu mada, gai koe e magau.” ");
INSERT INTO nkr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Gai Moses ga hai ange, “E heohi donu au muna, au e dee ahe ange naa donu ga gidee goe.” ");
INSERT INTO nkr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","De masavaa laa gai Tagi Maolunga ne hai ange gi Moses, “Au e gaamai ange naa dahi mee hagamaakau gi honga o Pharaoh ma Egypt; gai dua naa huu de mee nei gai ia e dugu naa goodou gi hulo. Gai de masavaa aana e dugu adu ai goodou gi hulo, gai ia e usuusu adu naa donu goodou alodahi gi hulo gee. ");
INSERT INTO nkr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Gai koe hai ange gi dangada alodahi o Israel, gilaadeu gi dangidangi ange gi dangada e nnoho i olaadeu gaogao gi gaavange gi gilaadeu denga goloa e hai i goolo ma selevaa.” ");
INSERT INTO nkr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Gai Tagi Maolunga ga hai de gau Egypt gi abodonu ange gi de gau Israel. Gai de gau hai hegau o Pharaoh ma de gau Egypt gu kona donu delaadeu hagadubu Moses. ");
INSERT INTO nkr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Gai Moses ga hai ange, “E hagadaba Tagi Maolunga, ‘Au e humai naa gi Egypt i lo te madohi boo, ");
INSERT INTO nkr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","gai denga dama daane maatua alodahi a de gau Egypt e odi naa i de maakau; mai i tama daane madua a Pharaoh, e noho laa i honga dono nohoanga, ga dae ai loo gi tama madua a de hine hai hegau e miilia laa denga grain, aama tama madua hogi a denga manu haangai. ");
INSERT INTO nkr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Gai dangada alodahi i honga de henua go Egypt e tangi naa; gai tigi ai ange se tangi bee nei mai i mua aabe go muli mai. ");
INSERT INTO nkr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Gai e deai naa donu se gaaduu daudahi e goo ange gi dahi dangada Israel aabe go dahi alaadeu manu haangai.’ Gai goodou e iloo bolo au Tagi Maolunga e dagodo gee dagu hai e hai ai de gau Israel mai i de gau Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Gai oo dangada hai hegau nei alodahi e loomai naa ga ino mai gi de au, ga hai mai bolo au gi hano gee mai i kinei, mage gaavee dangada alodahi e daudali mai laa i de au gi hulo ai. Gai dua naa huu mee nei gai au ga hano gee mai i kinei.” Gai Moses ga hano gee mai i daho Pharaoh gu kona mmao dono lili. ");
INSERT INTO nkr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Gai Tagi Maolunga ne hai ange gi Moses, “Pharaoh e dee hagallongo adu naa donu gi de goe, gai gi lagolago ai agu mee hagalele mouli e hai i honga de henua go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses ma Aaron ne hai denga sauaa hagalele mouli nei alodahi i mada luu mada o Pharaoh, aagai Tagi Maolunga ne hagamakaga lodo o Pharaoh, gai ia tee dugu de gau Israel gi hulo gee mai i dono henua. ");
INSERT INTO nkr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron i de henua go Egypt, ");
INSERT INTO nkr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mai iainei gai de malama nei go doodou dahi malama, gai go de malama e daamada ai doodou ngadau. ");
INSERT INTO nkr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Daalaa ange gi de hagabuulingaa dangada o Israel alodahi hai ange, bolo de madaangahulu laangi naa huu o de malama nei, gai denga daane mai i dahi huaabodu gi hilia dahi ssiibi be se guudi gauligi e dohu ai laa dangada i dahi huaabodu, dahi ssiibi ange gi dahi huaabodu. ");
INSERT INTO nkr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Gai noo dahi huaabodu e dee maua i de gai dahi manu, i hiidinga e sogoisi dangada iai, gai gilaadeu ma dahi huaabodu e baa ange laa gi gilaadeu gi hagabuni gi hilia dahi ssiibi be se guudi gauligi e dohu ai laa dangada, ga hagabau ange mee a dahi dangada e gai. ");
INSERT INTO nkr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Gai goodou hilia dahi ssiibi aabe se guudi daane gu dahi ono ngadau, gai e deai mee baubau i dono angaanga; ");
INSERT INTO nkr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","gai goodou ga tilo ange de manu nei ga dae ai gi de madaangahulu ma haa laangi o de malama, gai de ahiahi naa huu gai de hagabuulingaa dangada alodahi o Israel gi daia alaadeu manu. ");
INSERT INTO nkr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Gai gilaadeu ga kave hanu dodo o de manu laa gi hulu ina ange gi laagau i luu baasi o de haitoga aama de laagau i de ulu o de haitoga o denga hale alaadeu e gai ai kano manu laa. ");
INSERT INTO nkr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Gilaadeu e dunu kano manu laa i honga de ahi i de boo laa donu huu, ga gai madali pelaoaa dee hagahua aama mee mmala e hai i denga manu ssomo. ");
INSERT INTO nkr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Gai goodou e dee oda denga kano manu aabe boale i lodo vai, aagai e dunu i honga de ahi — go de biho, ma denga vae aama denga dae. ");
INSERT INTO nkr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Gai goodou gi dee dugua donu hanu mee gi doe gi taiao age, gai noo ne hanu mee ne doe, gai goodou duungia i de ahi. ");
INSERT INTO nkr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Gai deenei doodou hai e gai ai mee nei: goodou hagabigibigia ange oodou malo lloa gi oodou daogubu, gai gi ulumagi ina ange oodou mee vae, mage boogia oodou dogo i oodou lima, gai goodou ga gaimee gi moolau; deenei Taonga Hagasili a Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Gai lo te madohi boo naa huu, gai au ga hagadaga i Egypt e daa gi maakau denga dama daane maatua a dangada, ma manu dolodolo alodahi a de gau Egypt, aama de hagaduasala denga diinonga alodahi o Egypt. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Gai dodo e hulu ai laa denga haitoga e hagailonga denga hale oodou e nnoho ai. Gai de masavaa naa huu aagu e gidee ai dodo laa, gai au ga hagasili oodou hale. Gai de mee hagamaakau e dee baa i goodou, i de masavaa aagu e hagaduasala ai de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Gai goodou ga dao de laangi nei, ga hai gi se daonga hagamogomogo ange gi Tagi Maolunga i daho oodou atangada e loomai i muli ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","E hidu laangi oodou e gai ai pelaoaa e dee hagahua. Tahi laangi naa huu o denga laangi e hidu nei, gai goodou ga aau gee denga mee hagahua i lodo oodou hale, go hiidinga tangada naa huu e gaina pelaoaa hagahua i denga laangi e hidu nei, gai e vvae gee mai i daho de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Gai de hagadahi laangi ma de hagahidu laangi o denga laangi nei, gai goodou ga hagabuni ga daumaha, gai e deai donu oodou hegau e hai i luu laangi nei, gai go de hai donu huu gai a dangada e gai. ");
INSERT INTO nkr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Gai goodou gi dao ina Taonga o Pelaoaa Dee Hagahua, i hiidinga deenei de laangi aagu ne dagi ai goodou ga kave gee mai i de henua go Egypt. Deelaa ai, goodou duudagina de dao o de laangi nei i daho oodou atangada ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Gai de madaangahulu ma haa laangi huu o tahi malama i de ahiahi, gai goodou ga daamada de gai pelaoaa e dee hagahua ga dae ai gi de madalua ma dahi laangi o de malama i de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","E hidu laangi e hai ai gi deai mee hagahua i lodo oodou hale. Gai be goai naa huu e gaina pelaoaa iai mee hagahua, gai ia e vvae gee donu mai i daho de hagabuulingaa dangada o Israel, e dee hilihili be ia se dangada henua gee aabe se dangada Israel donu. ");
INSERT INTO nkr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Gai goodou gi dee gaina donu pelaoaa e hagahua, gai goodou gaina donu huu pelaoaa e dee hagahua i oodou mommee nnoho alodahi.” ");
INSERT INTO nkr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Gai Moses ga hagahi denga daane maatua alodahi o de gau Israel, ga hai ange, “Dahi ma dahi gi hano gi hilihilia dahi ssiibi be se guudi gauligi e dohu ai dono huaabodu ga daa e hai ai Taonga Hagasili. ");
INSERT INTO nkr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Gai goodou ga kave dahi laa o de hyssop ga hagasulu ange gi lodo dodo i lo te beisini, ga hulu ai de laagau i de ulu o de haitoga aama luu laagau i luu baasi de haitoga o de hale. Gai e deai donu se goodou e sao gi haho ga dae ai gi taiao age. ");
INSERT INTO nkr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Go hiidinga Tagi Maolunga e hagadaga naa e daa de gau Egypt, gai de masavaa naa huu aana e gide ai denga dodo e hulu ai laa de laagau i de ulu aama luu baasi o de haitoga, gai Tagi Maolunga ga hagasili de haitoga laa. Ia e dee dugu ange naa donu tangada de langi o de magau gi ulu i lodo oodou hale gi daia ai goodou. ");
INSERT INTO nkr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Gai goodou ma oodou dama gi dao ina de laangi nei, ga hai gi se hainga e hai hegau ai goodou ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Gai gu tae naa huu goodou gi de henua a Tagi Maolunga gu dai gaavadu gi goodou, bei dana hai gu hagatoo donu ai laa, gai goodou ga duudagi de hai de mee nei. ");
INSERT INTO nkr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Gai noo gu siilia adu e oodou dama ga hai adu, ‘Dee hee de hagadoonunga o taonga nei?’, ");
INSERT INTO nkr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","gai goodou ga hai ange, ‘De mee nei se sigidaumaha ange gi Taonga Hagasili a Tagi Maolunga, hiidinga ia ne hagasili hale o de gau Israel i de masavaa aana ne daa ai de gau Egypt, aagai ga hagaola omaadeu huaabodu.’ ” Gai dangada alodahi ga ino gi lalo ga daumaha. ");
INSERT INTO nkr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Gai dangada o Israel ga hulo ga hai gu bei muna alodahi a Tagi Maolunga ne tala ange gi Moses ma Aaron. ");
INSERT INTO nkr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gai lo te madohi boo huu, gai Tagi Maolunga ga daa gu maakau denga dama daane maatua alodahi i honga de henua go Egypt, mai i tama daane madua a Pharaoh e noho laa i honga dono nohoanga, ga dae ai loo gi tama madua a tangada i lo te hale pono, aama dama maatua alodahi a denga manu haangai. ");
INSERT INTO nkr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Gai Pharaoh ma ono dangada hai hegau aama dangada alodahi o Egypt gu alahage i de boo laa. Gai gu kona mmao de tangi o dangada, go hiidinga hale alodahi gu iai de gau maakau. ");
INSERT INTO nkr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Gai Pharaoh ne aalu Moses ma Aaron i de boo laa ga hai ange, “Gooluu ma de gau Israel, hulo gee mai i omaadeu daha ma ogu dangada. Goodou hulo daumaha ange gi Tagi Maolunga bei doodou hai gu dangidangi mai ai naa. ");
INSERT INTO nkr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Goodou gaavee oodou manu haangai alodahi ga hulo ai goodou, bei dagodo ooluu muna. Gai goodou hagamanuuia ina hogi au.” ");
INSERT INTO nkr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Gai de gau Egypt ne usuusu ange de gau Israel gi hagamoolau gi hulo gee mai i de henua, i hiidinga gilaadeu ne hagataba, “Gidaadeu e odi naa donu i de maakau ⌊noo gilaadeu e dee hulo gee⌋.” ");
INSERT INTO nkr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Gai dangada ne kave alaadeu pelaoaa gu labu, i lodo gumedi mmili gai ga saabini i de malo, i mua de gaavange mee hagahua aagena, gai gilaadeu ga hagauda ange gi honga olaadeu eu ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Gai de gau Israel ne hai ga bei muna a Moses; gilaadeu ne dangidangi ange gi de gau Egypt i goloa e hai i goolo ma selevaa aama malo. ");
INSERT INTO nkr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Gai Tagi Maolunga ga hai de gau Egypt gi abodonu ange gi de gau Israel, gai gilaadeu ga gaavange mee alodahi olaadeu ne dangidangi ange ai. Deelaa ai, de gau Israel ne kave goloa lagolago mai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Gai de gau Israel ne daga mai i Rameses ga hulo gi Succoth. Gai se onoseguli daane e hulo madali denga haahine ma gauligi. ");
INSERT INTO nkr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Gai e soa hogi dangada gee ne hulo madali gilaadeu, ma ssiibi ma guudi aama kaau lagolago mmao. ");
INSERT INTO nkr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Gai gilaadeu ga dao hanu pelaoaa dee hagahua i pelaoaa alaadeu ne labu ga gaamai madali gilaadeu i Egypt, i hiidinga teai mee hagahua ne gaavange aagena, go hiidinga gilaadeu ne daa hagalele donu huu delaadeu haia gi hulo gee mai i Egypt, deelaa ai, gilaadeu tee maua i de hagadabena alaadeu pelaoaa aabe go gai ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Gai se 430 ngadau o de gau Israel ne nnoho ai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Gai ga odi ange huu de 430 ngadau, i de laangi mau, gai denga hagabuulingaa dangada o Tagi Maolunga ga hulo gee mai i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Go hiidinga de boo laa gai Tagi Maolunga ne dagitilo ga hagassao mai gilaadeu i Egypt, gai de gau Israel alodahi e dao e hagadubu ai Tagi Maolunga i olaadeu atangada alodahi i muli mai. ");
INSERT INTO nkr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, “Aanei hainga o Taonga Hagasili: e deai donu dangada henua gee e maua i de gaimee i Taonga Hagasili. ");
INSERT INTO nkr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Gai de gau hai hegau alodahi oodou gu hagao gu lava laa i de tuu dagaholiage e maua i de gaimee i taonga laa, ");
INSERT INTO nkr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","aagai tangada henua gee e noho gaainga i oodou daha i dahi masavaa bodobodo aabe go tangada hai hegau e hagao e dee maua i de gaimee ai. ");
INSERT INTO nkr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Denga kano o de manu e daa laa e gai donu i lo te hale, e dee kave donu hanu gi haho. Gai e dee hhadi hogi dahi ono ivi. ");
INSERT INTO nkr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Gai de hagabuulingaa dangada o Israel gi dao ina donu de laangi nei. ");
INSERT INTO nkr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Gai noo dahi dangada henua gee e humai gi oodou daha, gai ia e lodo e dau i Taonga Hagasili ange gi Tagi Maolunga, gai gilaadeu alodahi ma daane i dono hale gi tuu dagaholiage, gai ia gu maua ai loo i de dau i Taonga Hagasili bei dagodo o de gau Israel. Aagai e deai donu se dangada tigi tuu dagaholiage e maua i de gaimee i Taonga Hagasili. ");
INSERT INTO nkr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","De hainga nei se mee ange gi tangada Israel donu aama tangada henua gee e noho madali goodou.” ");
INSERT INTO nkr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Gai de gau Israel alodahi ne hai donu ga bei muna a Tagi Maolunga gu tala ange gi Moses ma Aaron. ");
INSERT INTO nkr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Gai deenei donu de laangi a Tagi Maolunga ne hagassao mai ai de gau Israel mai i de henua go Egypt i olaadeu hagabuulingaa dangada. ");
INSERT INTO nkr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Goodou hagadabu ina mai gi de au dama a denga manu e haanau i mua ma dama maatua alodahi a de gau Israel; gilaadeu niiagu.”  ");
INSERT INTO nkr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Gai Moses ne hai ange gi de huaadangada, “Goodou dao ina de laangi nei, go de laangi oodou ne ssao mai ai i Egypt, go de mommee oodou nogo hagahai hegau ina ai, go hiidinga Tagi Maolunga ne hagassao mai goodou i de henua laa i dono lima sauaa. Goodou e dee gai pelaoaa iai mee hagahua. ");
INSERT INTO nkr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","De laangi nei, i de malama go Abib, gai goodou e hulo gee mai i kinei. ");
INSERT INTO nkr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","De masavaa naa huu a Tagi Maolunga e kave ai goodou gi de henua o de gau Canaan, ma de gau Heth, ma de gau Amor, ma de gau Hiv aama de gau Jebus — go de henua a Tagi Maolunga ne hagatoo donu ange gi oodou dubuna madagidagi e gaavadu gi goodou, se henua iai vai uu ma hooni lagolago — gai goodou ga dao taonga nei i de malama nei. ");
INSERT INTO nkr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Gai goodou ga gai pelaoaa e dee hagahua i e hidu laangi, gai de hagahidu laangi naa huu, gai goodou ga hai taonga e hagadubu ai Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Gai go pelaoaa dee hagahua donu huu oodou e gai i laangi e hidu nei, gai haia gi deai pelaoaa iai mee hagahua e daakodo i oodou daha, aabe go oodou mommee e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Gai goodou ga hagadonu ange gi oodou dama i laangi o taonga nei, bolo taonga nei se hai e hagamaanadu ai sauaa a Tagi Maolunga ne hai i odaadeu hiidinga, i de masavaa odaadeu ne hulo gee mai ai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Gai de mee nei e bei de hagailonga e nnoa ange laa gi honga oodou lima aama honga oodou lae, gi manadua ai e goodou de hainga a Tagi Maolunga gai goodou ga tala ai, i hiidinga Tagi Maolunga ne hagassao mai goodou i Egypt i dono lima sauaa. ");
INSERT INTO nkr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Deelaa ai, goodou dao ina taonga nei i de laangi gu lava i de hagamodu i ngadau alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Gai de masavaa naa huu a Tagi Maolunga e kave ai goodou gi de henua o de gau Canaan, go de henua aana gu hagatoo donu ange gi oodou dubuna madagidagi e gaavadu gi goodou, ");
INSERT INTO nkr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","gai goodou ga vvae denga dama daane madua alodahi a dangada ma dama a denga manu e haanau i mua mage hagadabu ina ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Aagai denga manu dama alodahi a denga donkey e haanau i taamada, goodou hagahesuihagi ina i dahi ssiibi, gai noo tee hagahesuihagi, gai goodou milosia de ua gi magau. Gai goodou hagao ina oodou dama daane madua alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Gai noo oodou dama daane e ssili adu gi goodou i laangi e loomai nei de hagadoonunga o mee nei, gai goodou hai ange, ‘Tagi Maolunga ne hagassao mai gidaadeu i Egypt, go de mommee omaadeu nogo hai hegau ina ai, i dono lima sauaa; ");
INSERT INTO nkr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","gai Tagi Maolunga ne daa ga maakau denga dama daane madua a dangada aama manu ne haanau i taamada i de henua go Egypt, go hiidinga Pharaoh tee lodo e dugu mai gidaadeu gi hulo gee, gai ne hagamakaga ono lodo. Deelaa ai, gidaadeu e sigidaumaha ange gi Tagi Maolunga denga manu alodahi e haanau i taamada. Gai denga dama daane alodahi e hagao i dahi manu.’ ");
INSERT INTO nkr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Gai de mee nei e hai gi se mee hagailonga e nnoa ange gi honga oodou lima aama honga oodou lae, e hagamaanadu ai de hagassao mai a Tagi Maolunga gidaadeu mai i Egypt i dono lima sauaa.” ");
INSERT INTO nkr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Gai de masavaa huu a Pharaoh ne dugu ai de gau Israel gi hulo gee, gai de Maadua tee dagi gilaadeu laa gaogao de henua o de gau Philistia, go de mommee e bodobodo ai de haiava; i hiidinga de Maadua e iloo bolo dangada e sui naa alaadeu maanadu i kilaa ga ahe ga hulo gi Egypt, noo gilaadeu e hai gi hulo gi hebagi. ");
INSERT INTO nkr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Gai de Maadua ne hai gilaadeu gi holiage saele i de haiava o de vao e hano laa gi Tai Mmea. Gai de gau Israel gu paba ange e hebagi, i de masavaa olaadeu ne ssao ai ga hulo gee mai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Aagai Moses ne kave hogi denga ivi o Joseph madali gilaadeu, go hiidinga Joseph ne hai de gau Israel gi hagatoo donu bolo gilaadeu e kave naa ono ivi madali gilaadeu, i de masavaa a de Maadua e hagaola ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Gai gilaadeu ne daga mai i Succoth ga loomai ga hagatuu olaadeu hale gaainga i Etham, i de hiihii o de vao. ");
INSERT INTO nkr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Gai Tagi Maolunga ne hano i olaadeu mada i mua i lo te duludulu hagausinga i de laangi, gai de boo naa huu gai tuludulu laa gu bei de ahi ula, e hagamaalama ai delaadeu haiava, gi maua ai e gilaadeu i de seesee i de laangi ma de boo. ");
INSERT INTO nkr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gai tuludulu hagausinga alaadeu e gide laa i de laangi, gai gu se duludulu e ula ai de ahi i de boo, tee hano gee donu i mada i mua o dangada. ");
INSERT INTO nkr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Hai ange gi de gau Israel gi aahe gi hagatuulia olaadeu hale gaainga i gaogao Pi Hahiroth, i magavaa o Migdol ma Tai Mmea. Gai gilaadeu gi nnoho i gaogao tai, i de baasi ange gi Baal Zephon. ");
INSERT INTO nkr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Gai Pharaoh e hagadaba naa i ono lodo, ‘De gau Israel e hulo ma e ssenga saele i lodo henua, gai de vao gu buibui delaadeu haiava.’ ");
INSERT INTO nkr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Gai au e hagamakaga naa lodo o Pharaoh, gi dolohia mai ai e ia gilaadeu. Aagai dangada e hagamahamaha ai naa au, i hiidinga o mee aagu ne hai ange gi Pharaoh ma dono hagabuulinga hebagi, gi iloo ai de gau Egypt bolo go au donu go Iahweh.” Gai de gau Israel ne hagasula de mee nei. ");
INSERT INTO nkr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Gai de masavaa huu a hanu ne tala ange ai gi Pharaoh bolo de gau Israel gu odi i de saavini ma gu hulo gee, gai gilaadeu ma ono dangada hai hegau gu sui alaadeu maanadu ga hagataba, “Se hegau bee hee adaadeu gu hai nei? Gidaadeu gu dugu de gau Israel gi hulo gee, gai gilaadeu gu dee hai hegau mai ai loo gi gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Gai Pharaoh ga hagadabena ono hada hebagi ma dono hagabuulinga hebagi e hulo ai gilaadeu, ");
INSERT INTO nkr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","gai ia ne kave e onolau hada hebagi makaga hugadoo madali hada hebagi o Egypt ange laa ga hili ange denga daane dau o de hebagi gi saavini ai. ");
INSERT INTO nkr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Gai Tagi Maolunga ga hagamakaga lodo o de hodooligi o Egypt go Pharaoh, gai ia ga doolohi de gau Israel, i hiidinga gilaadeu se hagamaolunga ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Gai denga daane o Egypt ga doolohi gilaadeu i denga hoosa ma hada hebagi o Pharaoh, ma denga daane e saavini ai, madali dono hagabuulinga hebagi, gu daea adu de gau Israel i de baasi de vai i gaogao Pi Hahiroth i de baasi gee o Baal Zephon. ");
INSERT INTO nkr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Gai ga paa adu huu Pharaoh, gai de gau Israel gu gidee e gilaadeu bolo de gau Egypt gu doolohi adu gilaadeu, gai gilaadeu gu maatagu mmao, gai gilaadeu ga tangi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Gai gilaadeu ga hai ange gi Moses, “E aha, teai laa donu mommee e danu ai dangada i Egypt, gai koe ga gaamai ai nei gimaadeu gi maakau i de vao? Se aha aau ne hai mai nei gi gimaadeu, i dau hagassao mai gimaadeu i Egypt? ");
INSERT INTO nkr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Gai koe e manadua bolo gimaadeu ne hai adu gi de goe i Egypt, bolo koe gi dugua donu huu gimaadeu gi hai hegau ange gi de gau Egypt. E danuaa ange demaadeu hai hegau ange gi de gau Egypt i demaadeu maakau i de vao.” ");
INSERT INTO nkr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Gai Moses ga hai ange gi de huaadangada, “Goodou aude maatagu! Gai goodou tuu i gaogao de vai ga tilo ai de hai a Tagi Maolunga e hagaola ai goodou ailaa nei. Gai goodou e dee aahe ange naa donu ga gidee de gau Egypt oodou e gide nei anailaa nei. ");
INSERT INTO nkr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Gai goodou nnoho donu huu ma gi dee mmuu, gai Tagi Maolunga ga sui goodou e hebagi ai.” ");
INSERT INTO nkr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Gai Tagi Maolunga ga ssili ange gi Moses, “Gu aha gu duudagi ai naa doo dangi mai gi de au? Hai ange gi de gau Israel gilaadeu gi seesee gi hulo. ");
INSERT INTO nkr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Aagai koe boogia doo dogo mage haalo ina ange gi honga de vai e vvae lua ai de vai, gai de gau Israel ga seesee i lo te vai i honga de gelegele mmasa. ");
INSERT INTO nkr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Aagai au e hagamakaga naa lodo o de gau Egypt, gai gilaadeu e doolohi naa goodou. Gai dangada e hagamahamaha ai naa au i hiidinga o agu mee ne hai ange gi Pharaoh ma dono hagabuulinga hebagi, ma ono hada hebagi aama ono daane e kage i honga hoosa. ");
INSERT INTO nkr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Gai de gau Egypt e iloo bolo go au donu go Iahweh, i de masavaa aagu e hagamahamaha ai au i dagu hagadee kii i Pharaoh, ma ono hada hebagi, aama ono daane e kage i denga hoosa.” ");
INSERT INTO nkr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Gai tangada de langi o de Maadua, go de ia e hano laa i mada i mua o de gau Israel, ne ngalue ga hano gi olaadeu dua. Gai tuludulu hagausinga laa ne ngalue mai hogi i olaadeu mada i mua ga hano ga duu i olaadeu dua, ");
INSERT INTO nkr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","gai ne duu i magavaa o de hagabuulinga hebagi o de gau Egypt ma de gau Israel. Gai ne hagagohu de baasi ange ⌊gi de gau Egypt⌋, aagai ne hagamaalama de baasi ange ⌊gi de gau Israel⌋; gai tee maua donu e dahi hagabuulinga, i de hano e hagabaa ange gi de hagabuulinga ange laa, i de boo laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Gai Moses ga haalo ange dono lima gi honga tai, gai Tagi Maolunga ga hai gi humai de madangi mmahi i dua i de boo laa alodahi, gi haia gi masa tai, gi sula age de gelegele. Gai de vai gu vvae lua, ");
INSERT INTO nkr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","gai de gau Israel ga seesee laa lo te vai laa, i honga de gelegele mmasa, gai denga vai gu tuu age gi lunga i de baasi madau ma de baasi masui. ");
INSERT INTO nkr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gai de gau Egypt ga doolohi gilaadeu ga hulo ai gi lo te dai laa, go denga hoosa a Pharaoh, ma ono hada hebagi, aama ono daane i honga hoosa. ");
INSERT INTO nkr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Gai denga aoaa hagaloosi hagaodi huu, i de baasi gi boo taiao, gai Tagi Maolunga ne galo iho i lo te duludulu o de ahi ula ma de hagausinga ga tilo de hagabuulingaa daane hebagi o de gau Egypt, ga hai gilaadeu gi ssenga ange. ");
INSERT INTO nkr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Gai ia ne hai gi llave hagasii o denga hada hebagi gi lo te gelegele gi dee maua ai gi ngalungalue, gai gu dee maua i de saavini. Deelaa ai, denga daane o Egypt ne hagataba, “Gidaadeu ga saavini e hulo gee mai i de gau Israel; go hiidinga Tagi Maolunga e sui naa gilaadeu e hebagi mai ai gi gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Gai Tagi Maolunga ga hai ange gi Moses, “Haalo ina ange doo lima gi honga de vai, gi aahe mai ai denga vai gi haolia denga daane hebagi o Egypt ma olaadeu hada hebagi aama alaadeu hoosa.” ");
INSERT INTO nkr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Deelaa ai, Moses ne haalo ange dono lima gi honga de vai, gai gu ahe ange ga bei ono dagodo i mua i de masavaa ne ao ai de mee. Gai denga daane hebagi o Egypt tee maua i de saavini e hulo gee ai. Gai Tagi Maolunga ne hagaabulu gilaadeu gi lo te vai. ");
INSERT INTO nkr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gai denga vai ga aahe mai ga haoli denga hada hebagi, ma denga daane e saavini i denga hoosa, aama de hagabuulinga hebagi alodahi o Pharaoh ne dolohia laa gilaadeu gi lo te vai; aagai teai donu se gilaadeu ne ola. ");
INSERT INTO nkr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Aagai de gau Israel ne seesee i honga de gelegele mmasa i lo te ungaalodo o de vai; gai denga vai gu budubudu age gi lunga i de baasi madau aama de baasi masui. ");
INSERT INTO nkr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","De laangi laa gai Tagi Maolunga ne hagaola de gau Israel mai i de gau Egypt. Gai de gau Israel ne gidee e gilaadeu angaanga maakau o de gau Egypt i honga de gelegele o de vai laa. ");
INSERT INTO nkr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Gai ga gidee huu e de gau Israel de mmahi o Tagi Maolunga ne hebagi ange ai gi de gau Egypt, gai gilaadeu gu maatagu i Tagi Maolunga aama de hagadonusia Tagi Maolunga ma dono dangada hai hegau go Moses. ");
INSERT INTO nkr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Gai Moses ma de gau Israel alodahi ne daahili ange gi Tagi Maolunga i taahili nei, ga hai ange, “Au e daahili ange gi Tagi Maolunga i hiidinga ia gu kii i de hebagi. Ia gu maga ange denga hoosa ma dangada e savini ai gi lo te vai. ");
INSERT INTO nkr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Go Tagi Maolunga ogu mahi ma dagu daahili, gai go ia dogu Ia Hagaola. Go ia dogu Maadua, gai au e tuhi naa donu ia; ia go de Maadua o dogu damana, gai au e daahili e tuhi ia. ");
INSERT INTO nkr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tagi Maolunga se daane dau i de hebagi, gai dono ingoo go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ia gu maga ange hada hebagi o Pharaoh ma dono hagabuulinga hebagi gi lo te vai. Denga daane dau o Pharaoh gu maalemo i lo te Dai Mmea. ");
INSERT INTO nkr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","De vai gelo gu haoli gilaadeu; gilaadeu gu aabulu gi tagelo bei de hadu. ");
INSERT INTO nkr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tagi Maolunga, doo lima madau e mmahi mmao; Tagi Maolunga, doo lima madau gu hagabalaginagina de hagadaumee. ");
INSERT INTO nkr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Doo mahamaha laumalie gu hagadee kii gilaadeu e hai baasi adu gi de goe; koe gu haula gilaadeu i doo bole bei dagodo o denga lau grain mmasa. ");
INSERT INTO nkr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Koe ne busi i luoo bongaa usu gai denga vai gu hagabudubudu age. Denga vai ne tuu gi lunga bei dagodo o de bae hadu, gai vai i lo te vai gelo laa gu makaga. ");
INSERT INTO nkr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","De hagadaumee ne hagadaba, ‘Au e doolohi naa ga daea adu gilaadeu, au e dae naa ogu lodo i de duha olaadeu goloa. Au e dada naa dagu gadilaasa ga daa ai gilaadeu gi maakau.’ ");
INSERT INTO nkr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Koe ne busi i de madangi o dau manava, gai denga vai gu haoli gilaadeu; gilaadeu ne aabulu i lodo beau nnui bei dagodo o denga soodo daemaha. ");
INSERT INTO nkr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Tagi Maolunga, goai e bei oo dagodo i magavaa o denga diinonga? Goai e bei oo dagodo i de mahamaha gai e dabu? Au hegau e hagamaatagu, gai au sauaa e hagalele mouli! ");
INSERT INTO nkr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Koe ne haalo doo lima madau, gai de gelegele ga holo gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Koe gu dagi de huaadangada aau gu hagaola i doo abodonu. Koe gu dagi gilaadeu i doo sauaa mmahi gi de mommee dabu oou e noho ai. ");
INSERT INTO nkr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Denga huaadangada e maatagu naa i delaadeu langona mee nei; dangada o Philistia gu kona de manavasaa olaadeu lodo. ");
INSERT INTO nkr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Denga dagi o Edom e puni ange naa olaadeu lodo, denga daane mmahi o Moab gu bolebole i delaadeu maatagu, dangada alodahi i Canaan e llilo naa; ");
INSERT INTO nkr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","gilaadeu e maatagu naa ma de manavasaa mmao. Tagi Maolunga, doo sauaa mmahi gu hai gilaadeu ma gu dee vaa ngaalue bei dagodo o de hadu, ga dae ai gi de odi doo huaadangada i de hulo ga ui, ga dae ai gi de ui dangada aau ne hagaola. ");
INSERT INTO nkr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Koe e kave naa gilaadeu ga hagannoho i honga doo mounga donu; Tagi Maolunga, deenei de mommee gu hai ai doo mommee noho; de Ia Aamua, deenei de hale dabu aau gu hagaduu. ");
INSERT INTO nkr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Tagi Maolunga e dagi naa donu ga hano ai e dee ngado mai.” ");
INSERT INTO nkr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","De masavaa o denga hoosa a Pharaoh ma hada hebagi aama denga daane e saavini ai ne loiho gi lo te vai, gai Tagi Maolunga ga hagaahe mai denga vai ga haoli ai gilaadeu. Gai de gau Israel ne seesee ga hulo i honga de gelegele mmasa i lo te ungaalodo o de vai. ");
INSERT INTO nkr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Gai de pelaabisi go Miriam, taina hahine o Aaron, ne dagidagi dana tambourine i lo tono lima; gai denga haahine alodahi ga daudali ange i de ia ma alaadeu tambourine, gai gilaadeu ga hagadangidangi ma de aanu. ");
INSERT INTO nkr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Gai Miriam ne daahili ga hagadaba: “Daahili ange gi Tagi Maolunga, go hiidinga ia gu kii i de hebagi. Ia gu maga ange denga hoosa ma dangada e savini ai gi lo te vai.” ");
INSERT INTO nkr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Dua mee laa, gai Moses ga dagi de gau Israel mai i Tai Mmea ga hulo ai gi de vao go Shur; gai gilaadeu ne seesee i de vao laa e dolu laangi, gai teai alaadeu vai ne gide e unu ai. ");
INSERT INTO nkr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Gai de masavaa huu olaadeu ne tae ai gi Marah, gai gilaadeu tee maua i de unu vai i Marah, go hiidinga e mmala vai iai; deelaa ai, de mommee laa gu hagaingoo ange go Marah. ");
INSERT INTO nkr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Gai dangada ga nnanu i Moses, ga ssili ange, “Ni aha naa donu amaadeu e unu?” ");
INSERT INTO nkr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Gai Moses ne dalodalo ange gi Tagi Maolunga, gai Tagi Maolunga ga hagaago ange gi de ia dahi bido laagau. Gai ia ga maga ange de laagau laa gi lo te vai, gai vai laa gu danuaa i de unu. Gai Tagi Maolunga ne gaavange gi gilaadeu mee gu hagasauaa ma de hainga i kilaa, gai ia ga hagatale dagodo o olaadeu lodo. ");
INSERT INTO nkr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ia ne hai ange, “Noo goodou e kana ange e hagallongo muna a Tagi Maolunga doodou Maadua, ma de hai hegau i de mee heohi i mada luoono mada, noo goodou hagallongo ange gi ana hainga ma de daudali i ana hainga gu hagasauaa alodahi, gai au e dee gaamai naa gi goodou denga hagadaagangaa magi aagu ne gaavange laa gi de gau Egypt, i hiidinga go au donu go Iahweh e hagaieiangi ina goodou.” ");
INSERT INTO nkr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Gai gilaadeu ga hulo gu tae gi Elim, go de mommee iai laa e madaangahulu ma lua vai geli ma e madahidu palm. Gai gilaadeu ga hagatuu olaadeu hale gaainga i gaogao de vai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gai de hagabuulingaa dangada o Israel ne daga mai i Elim ga hulo gu tae gi de vao go Sin, se mommee e duu i magavaa o Elim ma Sinai. Gai gilaadeu ne hulo ga tae gi kilaa i de madaangahulu ma lima laangi o de lua malama i dua delaadeu ssao ga hulo gee mai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Gai de hagabuulingaa dangada o Israel ga nnanu i Moses ma Aaron i de vao, ");
INSERT INTO nkr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ga hai ange gi gilaau, “Mee naa gi ne daia e Tagi Maolunga laa gimaadeu ga maakau i de henua go Egypt, i de masavaa omaadeu e gaimee ai ma e boobosu danuaa i pelaoaa ma giidagi. Gai gooluu gu gaamai gimaadeu gi de vao nei e daa ai de hagabuulingaa dangada soa nei gi maakau i de hiikai.” ");
INSERT INTO nkr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Gai Tagi Maolunga ga hai ange gi Moses, “Au e hagamalili iho naa i de langi oodou gai e gaimee ai. Gai dangada alodahi gi hulo gi hagabudulia alaadeu mee e gaimee ai i dahi laangi. Au se hai mee nei e hagatale ai gilaadeu, e tilo ai be gilaadeu e daudali i agu hainga be deai. ");
INSERT INTO nkr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Gai de ono laangi naa huu o de uvigi, gai gilaadeu gi hagadabena ina alaadeu mee e hagabudu mai, gi lua hanonga e kii ange ai i alaadeu mee e hagabudu i laangi ange laa.” ");
INSERT INTO nkr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Gai Moses ma Aaron ga hai ange gi de gau Israel alodahi, “Ahiahi nei gai goodou e tonu iho naa bolo go Tagi Maolunga donu ne hagassao ina mai goodou i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Gai taiao daiao goodou e gidee naa de mahamaha o Tagi Maolunga, i hiidinga ia gu langona doodou nnanu i de ia. Gai e dee go gimaau donu oodou e nnanu ange naa aagena.” ");
INSERT INTO nkr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Gai Moses ga hai ange, “Tagi Maolunga e gaavadu naa gi goodou giidagi e gaimee ai i de ahiahi, ma pelaoaa e gaimee ai gi boobosu i taiao, go hiidinga ia gu langona doodou nnanu i de ia; gai e dee go gimaau donu oodou e nnanu ai naa, gai goodou e nnanu donu i Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Gai Moses ga hai ange gi Aaron, “Hannoo hai ange gi de hagabuulingaa dangada o Israel, gilaadeu gi hagabuni mai gi daho Tagi Maolunga, go hiidinga ia gu langona delaadeu nnanu.” ");
INSERT INTO nkr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Gai de masavaa o Aaron e basa ange ai gi de huaadangada alodahi o Israel, gai gilaadeu ne huuhuli ga kalo gi de vao, gu gidee adu de mahamaha o Tagi Maolunga e hanage i lo te hagausinga. ");
INSERT INTO nkr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Au gu langona de nnanu o de gau Israel. Koe daalaa ange gi gilaadeu, ‘De ahiahi, gai goodou e gai denga kano manu, gai taiao goodou e boobosu i denga pelaoaa. Gai gi iloo ai e goodou bolo go au donu go Iahweh doodou Maadua.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Gai ga ahiahi huu de mee, gai denga quail gu loomai ga toga iho ga hagadohu ai de mommee nnoho gaainga. Taiao age, gai ssuungia o taiao gu hano iho ga haoli honga de gelegele i luu baasi de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Gai de masavaa huu ne mmasa ai ssuungia o taiao, gai dangada gu gidee hanu mee tea ma de malili gelegele bei dagodo o denga snow gu daakodo i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Gai ga gidee huu e de gau Israel mee laa, gai gilaadeu tee iloo be ni aha aalaa. Gai gilaadeu ga hagadau ssili ga hagataba, “Ni aha aanei?” Gai Moses ga hai ange gi gilaadeu, “Aanei gai a Tagi Maolunga gu gaavadu e gaimee ai goodou. ");
INSERT INTO nkr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tagi Maolunga e tala adu gi goodou bolo tangada gi hano gi hagabudulia ono mee e gaimee ai; gai gi hagabaulia gi lava danuaa mee o dangada alodahi i dono hale e gaimee ai; dahi dangada e dahi ana omer.”  ");
INSERT INTO nkr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Gai de gau Israel ne hai donu ga bei muna ne tala ange gi gilaadeu; hanu ne lagolago alaadeu mee ne hagabudu, gai hanu ne sogoisi. ");
INSERT INTO nkr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Gai ga hagabau huu alaadeu mee i de omer; tangada ne lagolago laa ana mee ne hagabudu ne heohi ange donu huu gi taelodo o dangada i dono hale. Gai tangada ne sogoisi laa ana mee ne hagabudu ne heohi ange donu hogi gi taelodo o dangada i dono hale. ");
INSERT INTO nkr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Gai Moses ga hai ange gi dangada, “Goodou aude dugua donu hanu gai gi doe gi daiao.” ");
INSERT INTO nkr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aagai hanu dangada tee hagallongo ange gi Moses, gilaadeu ne dugu hanu gai gi taiao age, gai gu ilosia ma de pilo; gai Moses gu bole. ");
INSERT INTO nkr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Daiao alodahi gai dangada ne hagabudu gai e heohi ange gi delaadeu gaimee ai, gai de masavaa naa huu e hagavvela ai de laa, gai mee e doe gu vaivai. ");
INSERT INTO nkr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Gai de ono laangi huu gai dangada ga hulo ga hagabudu alaadeu gai, ga hagabau ange e lua laangi; dahi dangada e lua ana omer. Gai denga dagi o de hagabuulingaa dangada ga loomai ga tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Gai ia ga hai ange gi gilaadeu, “Aanei donu muna a Tagi Maolunga gu lava laa i de tala adu: ‘Daiao go de laangi hagammabu, gai go Sabbath dabu a Tagi Maolunga. Goodou hagadabena ina oodou gai, ga dao aabe dunu e gaimee ai goodou, gai goodou ga doange mee doe gi daiao.’ ”  ");
INSERT INTO nkr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Gai dangada ga doange mee ne doe gi taiao age, bei dagodo muna a Moses, gai teai donu mee ne pilo aabe ne ilosia. ");
INSERT INTO nkr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Gai Moses ne hai ange, “Goodou gaimee i mee nei ailaa nei, i hiidinga anailaa nei go Sabbath a Tagi Maolunga. Goodou e dee gidee naa donu hanu mee i honga de gelegele ailaa nei. ");
INSERT INTO nkr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","E ono laangi oodou e hagabudu ai mee nei, aagai de hidu laangi go Sabbath, deelaa ai, e deai naa donu mee e malili iho gi honga de gelegele.” ");
INSERT INTO nkr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Aagai hanu dangada ne hulo e hagabudu hanu gai i de hagahidu laangi, gai teai donu alaadeu mee ne gidee. ");
INSERT INTO nkr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Gai Tagi Maolunga ga hai ange gi Moses, “Dee hee maa taulooloa doodou dee llodo e daudali i agu muna e tala adu gi goodou aama agu hainga? ");
INSERT INTO nkr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Goodou gi iloo bolo Tagi Maolunga gu gaavadu gi goodou Sabbath; deelaa ai, ia gu gaavadu gi goodou oodou gai e gaimee ai i e lua laangi i de ono laangi; gai e deai donu se goodou e sao gi haho i de hidu laangi.” ");
INSERT INTO nkr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Gai dangada alodahi ne hagammabu i de hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Gai de gau Israel ga hagaingoo ange de gai laa go de manna; de gai nei e tea bei de golee o de coriander, gai e mami bei de besgede iai hooni. ");
INSERT INTO nkr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Gai Moses ga hai ange, “Tagi Maolunga gu hagadaba, bolo goodou gi haoa e dahi omer maana ga doange e tilo oodou atangada i muli mai, gi gidee ai e gilaadeu de gai aagu ne haangai adu ai goodou i de vao, i dua dagu dagi goodou ga kave gee mai i de henua go Egypt.” ");
INSERT INTO nkr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Gai Moses ga hai ange gi Aaron, “Gaavee dahi ssaa haoa ange aagena dahi omer manna, e doange ai i mada luu mada o Tagi Maolunga ga dugu ange gi oodou atangada e loomai i muli.”  ");
INSERT INTO nkr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Gai Aaron ne kave de ssaa laa ga dugu i mada i mua o de ngavesi o de Tala Hagadonu e doange ai, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Gai ne madahaa ngadau a de gau Israel ne gai ai denga manna; gilaadeu ne gaimee i mee nei ga dae ai gi delaadeu tae gi de henua e nnoho ai dangada; gilaadeu ne gai hogi manna ga dae ai gi delaadeu tae gi denga goinga o de henua go Canaan. ");
INSERT INTO nkr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gai de omer se dahi diba i diba e madaangahulu o de ephah. ");
INSERT INTO nkr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gai de hagabuulingaa dangada o Israel ne loomai i de vao go Sin ga hagadaga i denga mommee laa, bei de hai a Tagi Maolunga gu tala ange gi gilaadeu. Gilaadeu ne hulo ga tae gi Rephidim ga hagatuu ai olaadeu hale gaainga, gai e deai donu vai e unu ai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Gai dangada ne hagadaumee ange gi Moses, ga hai ange, “Gaamai hanu vai e unu ai gimaadeu.” Gai Moses ga hai ange gi gilaadeu, “Gu aha gu loomai ai naa goodou e hagadaumee mai gi de au? Gai gu aha goodou gu hagatale ai naa Tagi Maolunga?” ");
INSERT INTO nkr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Aagai de huaadangada gu kona i de hieunu i kilaa, gai gilaadeu ga nnanu i Moses, ga hai ange, “Koe se hagassao mai nei gimaadeu mai i Egypt, ma amaadeu dama aama amaadeu manu e daa gi maakau i demaadeu hieunu?” ");
INSERT INTO nkr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Gai Moses ga dangidangi ange gi Tagi Maolunga, ga hai ange, “Dee hee dagu hai e hai ai dangada nei? E momo ange donu huu gilaadeu gu maga ngau i denga hadu.” ");
INSERT INTO nkr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Gai Tagi Maolunga ga hai ange gi Moses, “Gaavee hanu dagi o de gau Israel ma goodou hulo i mua o dangada. Gai koe gaavee hogi madali goe togo aau ne hagaili ai laa honga ssaalingaa vai go Nile. ");
INSERT INTO nkr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tilo, au e hano naa e duu i honga de baba i Horeb i oodou mada i mua; gai koe ga hai doo dogo ga hagaili ai de baba, gai denga vai e ssali mai naa i lo te baba e unu ai dangada.” Gai Moses ga hai mee nei i madamada o dagi o de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Gai Moses ne hagaingoo ange de mommee laa go Massah ma Meribah, go hiidinga de gau Israel ne hai baasi ange aama de hagatale Tagi Maolunga, ga hagataba, “E noho nei donu Tagi Maolunga i odaadeu daha be deai?” ");
INSERT INTO nkr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Gai de gau Amalek ne loomai ga hebagi ange gi de gau Israel i Rephidim. ");
INSERT INTO nkr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Gai Moses ga hai ange gi Joshua, “Hilia hanu daane ma goodou hulo hebagi ange gi de gau Amalek. Gai daiao, au e hano naa ga duu i honga tuuduu ga daohi age ai togo o de Maadua.” ");
INSERT INTO nkr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Gai Joshua ga hai gu bei muna a Moses; ia ne hano ga hebagi ange gi de gau Amalek. Gai Moses, ma Aaron, aama Hur ne loage ga tuu i honga tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Gai de masavaa naa huu a Moses e haalo ai dono lima, gai gu kii de gau Israel; gai ga dugua iho naa huu e ia dono lima, gai gu kii de gau Amalek. ");
INSERT INTO nkr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Aagai de masavaa huu ne mmade ai luu lima o Moses, gai Aaron ma Hur ga gaamai dahi hadu ga haganoho ange ia aagena. Gai Aaron ma Hur ga tuu i ono gaogao ga daohi age ai luoono lima, gai ia gu maua i de haalo luoono lima ga dae ai gi de danu de laa. ");
INSERT INTO nkr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Gai Joshua ne daa ga maakau Amalek ma ono dangada i de gadilaasa. ");
INSERT INTO nkr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Gai Tagi Maolunga ga hai ange gi Moses, “Siia mage daohia mee nei i lo te beebaa e hagamaanadu ange ai gi dangada ma de dau ange gi langona e Joshua, go hiidinga au e hai naa de gau Amalek gi odi i teai, gai gi deai dangada e manadua gilaadeu.”  ");
INSERT INTO nkr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Gai Moses ga hagaduu dahi mommee o ssigidaumaha ga hagaingoo ange go Iahweh Nissi. ");
INSERT INTO nkr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Gai ia ne hagadaba, “Tagi Maolunga gu hagatoo donu bolo ia e duudagi naa donu de hebagi ange gi denga atangada alodahi o de gau Amalek.” ");
INSERT INTO nkr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Gai Jethro, ssaulaba o Moses, tangada haimeedabu o Midian, gu langona e ia mee alodahi a de Maadua gu bale ange ai Moses ma dono huaadangada go Israel, aama dana hagassao mai gilaadeu i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Gai Jethro, ssaulaba o Moses, ne dugu Zipporah, de bodu o Moses i ono daha, i dua de hai a Moses ia gi hano, ");
INSERT INTO nkr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","madali luaana dama daane; de ingoo o dahi go Gershom (go hiidinga ia ne hagadaba, “Au e noho i dahi henua gee”). ");
INSERT INTO nkr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Gai ia ne hagaingoo ange tama daane ange laa go Eliezer (go hiidinga ia ne hagadaba, “De Maadua o dogu damana ne bale mai au ma de hagaola mai au i de gadilaasa a Pharaoh”). ");
INSERT INTO nkr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Gai Jethro, ssaulaba o Moses, ne humai ga gaamai luu dama daane a Moses ma dono bodu madali ia gi de vao, i de mommee o Moses e hagaduu ai dono hale gaainga i gaogao de mounga o de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Gai ia ne hagailoo mai gi Moses, ga hai ange bolo ia gu humai gi ono daha, gai ia gu hagaahe mai madali ia dono bodu ma luaana dama daane. ");
INSERT INTO nkr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Gai Moses ne hano ga hedae ange gi dono saulaba ga ino ange gi de ia, ma de oso ia. Gai gilaau ga madaangudu i mee alaau gu hai, muli mai gai gilaau ne hulo gi de hale malo o Moses e noho ai laa. ");
INSERT INTO nkr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Gai Moses ga tala ange gi dono saulaba mee alodahi a Tagi Maolunga gu hai ange gi Pharaoh ma de gau Egypt, i hiidinga o de gau Israel, ma hai ngadaa alodahi gu paa i gilaadeu i delaadeu seesee ga loomai, aama de hagaola a Tagi Maolunga gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Gai Jethro gu malangilangi i dana langona dagodo de abodonu o Tagi Maolunga ange gi de gau Israel, ma dana hagaola gilaadeu mai i daho de gau Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Gai ia ga hagadaba, “Duuhia Tagi Maolunga i dana hagaola goodou mai i de gau Egypt aama mai i Pharaoh. Gai ia ne hagaola donu de gau Israel mai i lalo o de gau Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Iainei au gu donu bolo Tagi Maolunga e maolunga ange i denga maadua ange laa alodahi, gai ia ne hai de mee nei i daho de gau Egypt, i hiidinga delaadeu hagamaolunga i de gau Israel.” ");
INSERT INTO nkr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Gai Jethro, ssaulaba o Moses, ne hai dahi sigidaumaha dudu aama hanu sigidaumaha ange laa ange gi de Maadua. Gai Aaron ma dagi alodahi o de gau Israel ga loomai ga gaimee madali gilaau ma Moses i mada luu mada o de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","De laangi i ono dua gai Moses ga daamada de hagamodu denga dee heloongoi i magavaa o dangada. De laangi laa gai dangada ne tuu saele ga tali e hedae ange gi Moses mai i taiao ga boo ai de mee. ");
INSERT INTO nkr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Gai ga gidee huu e Jethro mee alodahi a Moses ne hai ange gi dangada, gai ia ga ssili ange gi Moses, “Ni hegau aha aau e hai laa ma e bale ange ai dangada? Gai gu aha go koe ai laa donu huu e hagamodu ina denga dee heloongoi o dangada, gai dangada ange laa alodahi ne tuu saele donu huu mai i taiao ga dae ai gi de ahiahi?” ");
INSERT INTO nkr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Gai Moses ga hai ange gi de ia, “Go hiidinga dangada e loomai gi ogu daha e ssili ai gi iloo e gilaadeu lodo o de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","De masavaa naa huu e dee heloongoi ai magavaa o dangada, gai gilaadeu ga loomai gi ogu daha, gai go au e hagamodu ina de mee heohi i magavaa o dahi dangada ma dono soa, ga tala ange gi gilaadeu denga hagailoo aama hainga a de Maadua.” ");
INSERT INTO nkr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Gai Jethro ga hai ange gi Moses, “E dee danuaa dau hai e hai ai de hegau naa. ");
INSERT INTO nkr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Koe e hagadalea donu huu goe aama dangada alodahi e loomai gi de goe, go hiidinga de hegau naa se hegau hai ngadaa donu, noo go koe donu huu e haia. Koe e dee maua donu i de hai sogosogo de hegau naa. ");
INSERT INTO nkr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Hagalaangona gai au ga tala adu dau hai e hai ai, gai de Maadua gi noho i oo daha. Dau hegau e hai go de hano i magavaa o dangada ma de Maadua, gai koe ga kave olaadeu dee heloongoi gi de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Gai koe agoagona ange dangada i hagamodu a de Maadua ma ana hainga, ma de hagaago ange delaadeu hai e mouli ai, aama mee alodahi alaadeu e hai. ");
INSERT INTO nkr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Gai koe hilia hogi hanu daane maatua abodonu mai i magavaa o dangada — ni daane e maatagu i de Maadua, ma de hai hegau i de mee abodonu aama de kino i mee ngadi gaavange hagasenga — ga vaevae ange dangada gilaadeu gi dagina; hanu e dagimano, hanu e dagillau, hanu e dagimadalima, aagai hanu e dagimadaangahulu. ");
INSERT INTO nkr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Gai gilaadeu gi hagamodu ina muna o dangada i masavaa alodahi; gilaadeu gi gaamai gi de goe mee hai ngadaa, aagai mee hai ngaohie gilaadeu gi hagamodu ina. Gai gi maamaane adu ai gi de goe, gai gilaadeu gi bale adu ai goe i de hegau nei. ");
INSERT INTO nkr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Gai noo koe e hai hegau i de mee nei, bei de hai a de Maadua gu tala adu gi de goe, gai koe e maua donu i de hai de hegau nei, gai dangada alodahi gu maua hogi i de aahe gi olaadeu hale i de baba.” ");
INSERT INTO nkr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Gai Moses ne hagallongo ange gi muna a dono saulaba, ga hai mee alodahi aana gu tala ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses ne hili mai i magavaa o de gau Israel hanu daane maatua abodonu ga vaevae ange dangada gilaadeu gi dagina; hanu e dagi e mano, hanu e dagi e lau, hanu e dagi e dinolima, gai hanu e dagi e dinoangahulu. ");
INSERT INTO nkr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Gai denga daane nei ga hagamodu denga dee heloongoi o dangada e dee hai ngadaa laa; aagai denga dee heloongoi e hai ngadaa, gai gilaadeu ga gaamai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Aagai Moses ga hagaboo ange gi dono saulaba, ga dugu ia gi ahe gi dono henua. ");
INSERT INTO nkr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Gai tolu malama huu i dua de ssao o de gau Israel ga hulo gee mai i de henua go Egypt, gai gilaadeu gu tae gi de vao o Sinai, i de laangi laa donu huu hogi. ");
INSERT INTO nkr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Gai gilaadeu ne loomai i Rephidim ga hulo gu tae gi de vao o Sinai, ga hagatuu age olaadeu hale gaainga i de vao laa; gai de gau Israel ne hagatuu olaadeu hale gaainga i mada i mua o de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Gai Moses ne hanage gi daho de Maadua i ulu de mounga, gai Tagi Maolunga ga hagahi mai ia i ulu de mounga, ga hai ange, “Daalaa ange muna nei gi dangada o Jacob ma de gau Israel: ");
INSERT INTO nkr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Goodou gu gidee dagu hai ne hai ai de gau Egypt, aama dagu hai ne hagauda ai goodou i honga luoogu bakau bei de igele, ga gaamai goodou gi ogu daha i kinei. ");
INSERT INTO nkr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Gai noo goodou e hagallongo mai gi agu muna ma de daudali i dagu hagatoo donu hagaheloongoi, gai au e hili naa goodou mai i magavaa o denga huaahenua alodahi, e hai ai dogu huaadangada hagamogomogo. Niiogu henua i lalo alodahi,  ");
INSERT INTO nkr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","gai goodou e hai naa gi se nohoanga hodooligi o de gau haimeedabu niiogu gai se huaahenua dabu.’ Aanei au muna e tala ange gi de gau Israel.”  ");
INSERT INTO nkr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Deelaa ai, Moses ne ahe iho ga hagahi denga dagi o de gau Israel, ga tala ange muna alodahi a Tagi Maolunga gu tala ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Gai dangada alodahi ne pasa ange, ga hai ange, “Gimaadeu e paba ange donu e daudali i mee alodahi a Tagi Maolunga gu tala adu gi de goe.” Gai Moses ga ahe age e hagailoo ange muna laa gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Gai Tagi Maolunga ga hai ange gi Moses, “Au e hano iho naa e basa adu gi de goe mai i lo te hagausinga maadolu, gi langona ai e de gau Israel alodahi dogu leo e basa adu ai gi de goe, gi hagadonusia ai e gilaadeu goe iainei ga hano ai.” Gai Moses ga tala ange gi Tagi Maolunga muna a dangada. ");
INSERT INTO nkr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Gai Tagi Maolunga ga hai ange gi Moses, “Ahe iho gi daho dangada mage hagadabu ina gilaadeu, ma de hai gilaadeu gi daaia olaadeu malo alodahi gi gilimalali ailaa nei aama daiao; ");
INSERT INTO nkr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","gai gilaadeu gi hagadabena ange gi de hagadolu laangi, go hiidinga au e hano iho naa gi honga de mounga go Sinai i madamada o dangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Gai koe hagailonga ina de mommee i luu baasi de mounga, ga hai ange, ‘Goodou dagidiiloo gi dee loage goodou gi de mounga, aabe gi hagapaa ange gi tahido. Gai be goai naa huu e hagabaa ange aagena, gai e daa donu gi magau; ");
INSERT INTO nkr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","dangada gi dee poo ange gi tangada bee nei, aagai tangada bee nei e maga donu gi magau i denga hadu aabe velo i tao; e dee hilihili be se manu aabe be se dangada, ia e dee dugu donu gi mouli.’ Gai de masavaa naa huu e hagadau looloa ai de ili de hanga manu, gai dangada gu maua i de loage gi de mounga.” ");
INSERT INTO nkr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Gai Moses ne ahe iho i de mounga gi daho dangada, ga hagadabu gilaadeu; gai gilaadeu ga taa olaadeu malo. ");
INSERT INTO nkr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Gai Moses ga hai ange gi dangada, “Goodou haia gi paba ange goodou gi de hagadolu laangi. Gai denga daane gi dee hagahebaa ma olaadeu bodu.” ");
INSERT INTO nkr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Gai taiao huu o de hagadolu laangi, gai gu babaa denga hatuli ma de labalaba denga uila, gai de hagausinga maadolu gu haoli de mounga laa, gai gu kona de nganangana de ili o de hanga manu. Gai dangada alodahi i de mommee nnoho gaainga gu bolebole i delaadeu maatagu.  ");
INSERT INTO nkr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Gai Moses ga dagi mai dangada i de mommee nnoho gaainga e hulo ai gilaadeu e hedae ange gi de Maadua, gai gilaadeu ga hulo ga tuu i gaogao de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Gai de mounga go Sinai gu buu ai de useahi, go hiidinga Tagi Maolunga gu hano iho gi ono elunga i de ahi. Gai de useahi laa gu haoli kilaa bei dagodo o de useahi o de ahi mmahi, gai de mounga laa alodahi gu ngalungalue. ");
INSERT INTO nkr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Gai ga kona huu de nganangana de ili o de hanga manu. Gai Moses ga basa, gai de Maadua ne basa ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Gai Tagi Maolunga ga hano iho gi honga de mounga go Sinai, gai ia ga hagahi mai Moses gi hanage gi ulu de mounga, gai Moses ga hanage. ");
INSERT INTO nkr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Gai Tagi Maolunga ga hai ange gi Moses, “Ahe iho daalaa ange gi dangada, gi dee hagammahi ai gilaadeu gi loomai e tilo au, gai e soa naa gilaadeu e maakau. ");
INSERT INTO nkr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Gai de gau haimeedabu e loomai laa ga paa ange gi Tagi Maolunga gi hagadabu ina hogi gilaadeu, ana vakaa ga daia e Tagi Maolunga gilaadeu ga maakau.” ");
INSERT INTO nkr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Gai Moses ga hai ange gi Tagi Maolunga, “Dangada e dee maua i de loage gi de mounga go Sinai, i hiidinga koe ne hai mai gi gimaadeu, ‘Goodou hagailonga ina dahi ngaadonga i luu baasi de mounga mage hagadabu ina.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Gai Tagi Maolunga ne hai ange gi Moses, “Ahe iho mage gaavage Aaron madali goe, aagai koe aude dugua ange de gau haimeedabu ma dangada gi loage gi de mommee o Tagi Maolunga iai, kana daia e au gilaadeu ga maakau.” ");
INSERT INTO nkr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Gai Moses ga hano iho gi daho dangada ga tala ange muna nei gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Gai de Maadua ne tala muna nei alodahi, ga hagadaba: ");
INSERT INTO nkr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Go au go Iahweh, doo Maadua, ne hagasao ina mai laa goe i de henua go Egypt, go de henua oou nogo hai hegau hagaduasala ina ai. ");
INSERT INTO nkr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Aude haia hanu diinonga gee gi maolunga ange i de au. ");
INSERT INTO nkr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Aude haia dahi diinonga moou, gi hagadagodo ina ange gi dahi mee i de langi, be go dahi mee i henua i lalo, aabe go dahi mee i lo te vai i lalo de henua. ");
INSERT INTO nkr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Aude daumaha ange gi gilaadeu, aabe gi hai hegau ange gi gilaadeu; i hiidinga go au go Iahweh doo Maadua, au se Maadua e maagoda. Au e hagaduasala denga dama, i hiidinga baubau o olaadeu maadua, ga dae ai loo gi tolu ma de haa atangada o dangada e kino i de au, ");
INSERT INTO nkr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","aagai au e abodonu ange gi atangada soa o dangada e aaloha i de au, ma de daohi agu hainga. ");
INSERT INTO nkr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Aude hagangadi mee ina de ingoo o Iahweh doo Maadua, go hiidinga Tagi Maolunga e hagahaisala donu tangada e hagangadi mee ina dono ingoo. ");
INSERT INTO nkr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Manadua de laangi o Sabbath ma gi haia gi dabu. ");
INSERT INTO nkr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","E ono oo laangi e hai hegau ai, ga hagalava au hegau alodahi, ");
INSERT INTO nkr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","aagai de hidu laangi go Sabbath a Tagi Maolunga doo Maadua, aude haia ai dahi hegau daudahi, go koe ma dau dama daane, ma dau damaa hine, ma doo daane hai hegau, ma doo hahine hai hegau, ma au manu, aama tangada henua gee e nnoho i oo daha. ");
INSERT INTO nkr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Go hiidinga ne ono laangi a Tagi Maolunga ne hai ai de langi ma henua i lalo, ma tai ma mee alodahi i ono lodo, aagai ia ne hagamabu i de hagahidu laangi. Deelaa ai, Tagi Maolunga ne hagamanuuia de hidu laangi ga hai gi dabu. ");
INSERT INTO nkr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hagadubu ina doo damana ma doo dinana, gi daulooloa ai doo mouli i honga de henua, a Tagi Maolunga doo Maadua e gaavadu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Aude daia tangada gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Aude dagodo haisala. ");
INSERT INTO nkr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Aude gaiaa. ");
INSERT INTO nkr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Aude hagabaubau ina tangada e baa adu gi de goe i hanu muna hhadu. ");
INSERT INTO nkr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Aude nnoo ange gi de hale o tangada e baa adu gi de goe. Aude nnoo ange gi de bodu o tangada e baa adu gi de goe, be go dono daane hai hegau, be go dono hahine hai hegau, be go dana kaau, be go dana donkey, aabe go dahi ana mee daudahi.”  ");
INSERT INTO nkr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Gai ga langona huu e dangada de babaa denga hatuli ma de labalaba denga uila, gai gu ili de hanga manu, ma de buu age o de useahi i honga de mounga, gai gilaadeu gu maatagu ma de bolebole; gai gilaadeu ga hulo ga tuu i de mommee mmao, ");
INSERT INTO nkr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","gai gilaadeu ga hai ange gi Moses, “Go koe donu e basa mai gi gimaadeu, gai gimaadeu ga hagallongo au muna; aagai e dee go de Maadua e basa mai gi gimaadeu, ana vakaa ga maakau gimaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Gai Moses ga hai ange gi dangada, “Goodou aude maatagu, go hiidinga de Maadua gu humai e hagatale goodou e tilo ai dagodo o oodou lodo, gai gi dagodo ai de madagu o de Maadua i oodou lodo, gi dee haisala ai goodou.” ");
INSERT INTO nkr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Gai dangada ne hulo ga tuu mai i de mommee mmao, gai Moses ga hano ga ulu gi lo te hagausinga uli o de Maadua iai laa. ");
INSERT INTO nkr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Gai Tagi Maolunga ne hai ange gi Moses, “Daalaa ange muna nei gi de gau Israel: ‘Goodou gu gidee ma de langona dogu basa adu gi goodou mai i de langi: ");
INSERT INTO nkr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Goodou aude haia hanu diinonga i ogu gaogao; goodou e dee hai hanu diinonga i selevaa aabe ni goolo. ");
INSERT INTO nkr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Goodou haia dahi mommee o ssigidaumaha i gelegele, ga hai ai oodou sigidaumaha dudu, ma oodou sigidaumaha hagadanuaa magavaa i oodou ssiibi ma guudi aama kaau. Gai be go hee naa huu aagu e hai gi hagadubu ina ai dogu ingoo, gai au e humai naa ga hagamanuuia goe. ");
INSERT INTO nkr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Gai noo koe e bae dahi mommee o ssigidaumaha hadu mai gi de au, gai koe e dee hai i hadu gu hagamalali; go hiidinga noo koe gu daadaa dahi hadu i goloa baalanga gai gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Gai koe aude gage age i de gaagenga gi de mommee o ssigidaumaha, kana gilisau ange goe gi de mommee o ssigidaumaha.’ ");
INSERT INTO nkr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Aanei hainga aau e gaavange gi gilaadeu: ");
INSERT INTO nkr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Noo koe e hagao dahi dangada Hebrew gi hai hegau adu gi de goe, gai ia gi hai hegau adu donu huu gi de goe i e ono ngadau, aagai de hidu ngadau naa huu gai ia gu ilaage, gai ia e dee hagao donu dono ilaage. ");
INSERT INTO nkr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Gai noo ia tigi hai bodu i de masavaa aau ne hagao ai, gai ia gi hano donu i de ia. Gai noo ia gu hai bodu ga humai ai, aagai ia gi gaavee hogi dono bodu madali ia. ");
INSERT INTO nkr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Gai noo go dono dangada aamua ne gaavange dono bodu, gai gu hanu hogi alaau dama, gai de bodu ma denga dama gi nnoho i daho dono dangada aamua, go taane donu huu e hano gee. ");
INSERT INTO nkr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Aagai noo taane hai hegau laa e hagadaba, ‘Au e aloha i dogu dangada aamua, ma dogu bodu aama agu dama; au e dee lodo gi se dangada ilaage au,’ ");
INSERT INTO nkr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","gai dono dangada aamua gi gaavee ia gi de Maadua, ga hagaduu ia gi baa ange gi de haitoga be go de laagau i de baasi de haitoga o de mommee daumaha; gai dono dangada aamua gi haia de mee sugi laagau gi sugia ai dono dalinga; gai taane laa gu se dangada hai hegau ai loo niiona i taulooloa dono mouli. ");
INSERT INTO nkr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Noo dahi daane e hagao gi daha dana damaa hine e hai ai tangada hai hegau, gai ia e dee maua gi ilaage bei dagodo o taane hai hegau. ");
INSERT INTO nkr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Gai noo tangada aamua ne hilia tamaa hine laa e hai ai dono bodu gu dee malangilangi i de ia, gai ia gi dugua tamaa hine laa gi hagao ina dono ilaage. Ia e dee hagao ange ia gi hanu dangada henua gee, go hiidinga ia gu oha dana hagatoo donu. ");
INSERT INTO nkr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Gai noo tangada aamua o tamaa hine laa gu hagahai bodu ange tamaa hine laa gi dana dama daane, gai ia gi haia ia gi bei dana damaa hine donu. ");
INSERT INTO nkr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Gai noo tangada aamua laa gu hai ange dahi bodu gee, gai ia e dee maua donu i de tuu dana hagadanuaa tamaa hine laa i ana mee gai, aama ono malo. Ia gi dee duudia hogi dono hagahebaa ma ia. ");
INSERT INTO nkr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Aagai noo ia e dee hagassula mee e dolu nei, gai tamaa hine laa gu maua e ia i de hano gee mai i ono daha, ia gu ilaage gai e deai donu ana mee e hagao. ");
INSERT INTO nkr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Be goai e hagailiilia dahi dangada ga magau, gai ia e daa donu hogi gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Aagai noo tangada tee se hagabau, gai go de Maadua ne dugua ange gi hai de hegau laa, gai ia gi savini gi hano gi de mommee aagu gu hagailonga. ");
INSERT INTO nkr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Aagai noo tangada se hagabau donu e daa gi magau tangada e baa ange gi de ia, ⌊gai ga savini naa donu ia ga hano gi de mommee o ssigidaumaha,⌋ gai aaua mai ia i de mommee o ssigidaumaha daia gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Gai be goai e hagailihia dono damana, aabe go dono dinana, gai ia e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Be goai e haia gi de mahi dahi dangada ga kave ia ga hagao gi daha, aabe ne gidee mai tangada laa i ono daha, gai ia e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Be goai e basa hagamalaia ina dono damana aabe go dono dinana, gai ia e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Noo gu hebagi e dogolua dangada, gai dahi gilaau ga hai dahi hadu aabe go dono lima ga tugi ai tangada ange laa, gai tangada ange laa tee magau gai gu magi ga dagodo ai, ");
INSERT INTO nkr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","gai taane ne duugia laa ia e dee haisala i de hainga, noo tangada ne lagohia laa gu hidi age ga dogodogo saele; aagai taane ne hagalagohia ina ia, e hagao laangi o tangada laa tee hai hegau ai, aama de tilo ange ia ga dae ai gi dono ieiangi. ");
INSERT INTO nkr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Noo tangada e daa dono daane hai hegau, be se hahine hai hegau i dahi laagau, gai tangada hai hegau laa gu magau, gai tangada laa e hagaduasala donu, ");
INSERT INTO nkr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","aagai ia e dee hagaduasala, noo tangada hai hegau laa e hidi age i dua e dahi aabe e lua laangi, i hiidinga tangada hai hegau laa ni sseene niiana. ");
INSERT INTO nkr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Noo e dogolua daane gu hebagi, gai dahi gilaau ga tugi dahi hahine hai dama ga ssege dana dama, gai teai ange mee ne beaha ai ia — gai taane ne duugia laa de hine laa gi hagao ina ange de bodu o de hine laa i mee a de gau hagamodu muna e hagamodu ange. ");
INSERT INTO nkr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Aagai noo ne hanu ange mee ne hai ange gi de hine laa, gai koe gaavee dono mouli e sui ai de mouli aana gu kave laa, ");
INSERT INTO nkr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","de ganomada e sui ange i de ganomada, de niho e sui ange i de niho, de lima e sui ange i de lima, de vae e sui ange i de vae, ");
INSERT INTO nkr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","de vela e sui ange i de dudu gi vela, de lagohia e sui ange i de hai gi hagalagohia, de hagaili ga lagohia e sui ange i de hagaili gi lagohia. ");
INSERT INTO nkr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Noo tangada e hagaili de ganomada o dono daane aabe se hine hai hegau, gai ia gu dee gide, gai tangada laa gi dugua tangada hai hegau laa gi hano, ia gu ilaage i hiidinga o dono ganomada. ");
INSERT INTO nkr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Gai noo ia e tugi ga doo de niho o dono daane aabe se hine hai hegau, gai ia gi dugua ia gi hano, ia gu ilaage i hiidinga o dono niho. ");
INSERT INTO nkr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Noo dahi kaau gu velo dahi daane be se hine ga magau, gai de kaau laa e maga donu gi magau, gai ono kano e dee gai. Aagai tangada niiana de kaau e dee haisala i de hainga. ");
INSERT INTO nkr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Aagai noo de kaau daane laa gu dee modu dana hagalagohia dangada i laangi i mua, gai gu lava donu i de tala ange gi tangada niiana aagai ia tee nnoa dana manu, gai dana manu gu daa dahi daane aabe se hine ma gu magau, gai de kaau daane laa e maga donu gi magau i denga hadu, gai tangada niiana de kaau laa e daa hogi gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Gai noo gu dugu ange ia gi hagao ina hanu mee gi dee daa ai ia gi magau, gai ia gi hagaola ina dono mouli ga hagao mee alodahi gu hagamodu ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Gai de hainga nei e hai hegau donu e dee hilihili be se dama daane aabe se damaa hine a de kaau daane laa ne velo ga magau. ");
INSERT INTO nkr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Gai noo dahi kaau daane gu velo dahi daane hai hegau aabe se hine hai hegau o dahi dangada gee, gai ia gi gaavange gi dono dangada aamua e matolu shekel selevaa, gai de kaau daane laa e maga donu gi magau i hadu. ");
INSERT INTO nkr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Noo dahi dangada e hhuge aabe e geli dahi geelinga, gai ia tee haoli ono elunga, gai dahi kaau aabe se donkey gu doo ange gi ono lodo ga magau, ");
INSERT INTO nkr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","gai tangada niiana de geelinga gi gaavange gi tangada niiana de manu laa de hagaoanga o dana manu, gai de manu gu magau laa niiana. ");
INSERT INTO nkr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Noo de kaau a tangada e hai ga lagohia de kaau a dahi dangada gee, gai de kaau laa gu magau, gai gilaau gi hagao ina de kaau e mouli laa ga vvae lua gilaau i sseene ne maua ai. Gilaau gi vvae lua hogi i kano o de kaau gu magau laa. ");
INSERT INTO nkr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Aagai noo de kaau laa gu mau donu dana velo manu ange laa i dono hanga, gai tangada niiana de kaau tee nnoa dana manu, gai ia gi hagao ina de kaau ne magau laa i dahi ana kaau, gai de kaau gu magau laa niiana. ");
INSERT INTO nkr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Noo dahi dangada gu gaiaa dahi kaau daane be se ssiibi ga daa be e hagao gi daha, gai ia e sui ange dana kaau ne gaiaa laa i e lima kaau, gai e haa ssiibi e sui ai dana ssiibi ne gaiaa laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Noo tangada gaiaa ne boogia mai ma de hagailia ga magau i de masavaa oona e hagatale ai de ulu e gaiaa, gai e deai donu dangada e haisala ai; ");
INSERT INTO nkr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","aagai noo ne hai mee nei i de laangi, gai tangada ne daia laa ia ga magau e haisala donu i de hainga. Gai tangada ne gaiaa laa e suuia ange donu ana mee ne gaiaa laa, aagai noo ia e dee maua i de sui ange, gai ia e hagao gi daha e hagao ai ana mee gu gaiaa laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Gai noo manu ne gaiaadia laa gu gidee mai i ono daha gai goi mouli huu, e dee hilihili be se kaau be se donkey, aabe se ssiibi, gai ia gi gaavange e dagilua manu e sui ai denga manu aana ne gaiaa laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Noo dahi dangada e dugu ana manu gi gaimee i lo tana veelenga be go dana veelengaa grape, gai ana manu ga hulo hogi ga gai manu i lo te veelenga a dahi dangada gee, gai ia gi gaavange denga huamanu danuaa hugadoo o dana veelengaa aabe dana veelengaa grape e sui ai mee ana manu gu gai laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Noo tangada e dahu dahi ahi i dana veelenga, gai de ahi laa ga dolo ange gi lo te veelenga a dahi dangada gee, ga dudu ai ana grain gu duuduu laa ma gu hagabudubudu, be go grain tigi duuduu laa, aabe dudu de veelenga laa alodahi — gai tangada ne dahu ina laa de ahi gi suuia ange mee alodahi ne vvela laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Noo dahi dangada e gaavange hanu sseene be ni goloa, gi tangada e baa ange gi de ia gi doange ina, gai gu gaiaadia ga gaavee gee mai i de hale laa, gai noo gu gidee mai tangada ne gaiaadia mee laa, gai ia e hagao donu ana mee ne gaiaa laa, gi lua hanonga e lagolago ange ai. ");
INSERT INTO nkr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Aagai noo tee gidee tangada ne gaiaadia sseene laa, gai tangada niiona de hale gi humai gi mada luu mada o de Maadua, e tilo ai be ia gu gaiaa hanu goloa o tangada ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Gai hegau dee heohi alodahi e hai ange gi denga kaau, ma donkey, ma ssiibi, ma malo, aama goloa alodahi gu dee maaleva laa, gai dahi dangada gu hagadaba, ‘De mee nei niiagu,’ gai gaamai luu dangada e hagadaumee laa gi mada i mua o de Maadua. Gai tangada a de Maadua e hagabuu ange ssala aagena, e hagao ange tangada ange laa gi lua hanonga e kii ange ai. ");
INSERT INTO nkr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Gai tangada e gaavange dana donkey, aabe go dana kaau, aabe go dana ssiibi, aabe go hanu ana manu ange laa gi tangada e baa ange gi de ia gi diiloo ange, gai de manu laa ga magau, be lagohia, aabe ne gaiaadia, aagai teai donu dangada ne gidee — ");
INSERT INTO nkr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","gai tangada ne diiloo ange laa de manu laa gi hagatoo donu i de ingoo o Tagi Maolunga bolo e dee go ia ne gaavee de manu a tangada ange laa. Gai tangada niiana laa de manu laa gi hagadonusia ana muna. Gai tangada ne diiloo ange laa dana manu e deai ana mee e hagao. ");
INSERT INTO nkr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Aagai noo de manu laa ne gaiaadia i ono daha, gai ia gi hagao ina ange tangada niiana de manu laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Gai noo de manu laa ne daia e dahi manu aada, gai tangada e diiloo ange laa gi gaamai de magau laa e hagadonu ai mee nei. Gai ia gu deai ai loo ana mee e hagao. ");
INSERT INTO nkr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Gai noo tangada ne haganguu ga kave ai de manu a dahi dangada gee, gai de manu laa gu lagohia aabe gu magau, gai tangada niiana de manu e dee maleva i kilaa, gai tangada ne haganguu ina laa ga kave de manu laa e hagao donu gi odi ange de hagaoanga. ");
INSERT INTO nkr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Aagai noo tangada niiana e noho i de masavaa ne lagohia ai aabe ne magau ai de manu laa, gai tangada ne gaavee laa e deai ana mee e hagao. Gai noo de manu laa ne hagao gi haia dahi hegau, gai go de hagaoanga donu huu o ana hegau e hagao. ");
INSERT INTO nkr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Noo dahi daane e hai gi de mahi dahi bua moe ga dagodo haisala ma ia, gai taane laa gi hagao ina ange tamana o tamaa hine laa i de hagaoanga o de bua moe, gai ia e hai bodu ange donu hogi gi tamaa hine laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Aagai noo tamana o tamaa hine e dee lodo donu e dugu ange dana damaa hine gi hai bodu ange gi taane laa, gai taane laa gi gaavange donu taelodo o sseene e hagao ai laa de bua moe gu dai hai bodu laa. ");
INSERT INTO nkr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Aude dugua donu dahi hahine hai huuhuaa mee gi mouli. ");
INSERT INTO nkr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Be goai e dagodo haisala ma dahi manu e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Be goai e sigidaumaha ange gi dahi diinonga, e dee go Tagi Maolunga, e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Aude haia ange de baubau aabe gi vaivai haia tangada henua gee, i hiidinga goodou nogo nnoho gau mai vaga i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Aude vaivai haia de hine gu magau dono bodu, aabe go de gauligi gu deai sono damana. ");
INSERT INTO nkr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Noo koe e vaivai hai gilaadeu, gai gilaadeu ga tangi mai ai gi de au, gai au e hagallongo donu delaadeu dangidangi mai. ");
INSERT INTO nkr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Gai au e bole naa ga daa goodou gi maakau i de gadilaasa; oodou bodu e hai naa ga ni haahine e deai olaadeu bodu, oodou dama e hai naa ga ni gauligi e deai olaadeu damana. ");
INSERT INTO nkr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Noo koe e bale ange dahi dangada hagaau aloha i oodou magavaa, gai koe gi dee bei dagodo o tangada hagasomo sseene; koe gi dee haia gi kona de laumalie dana mee e hagao i dau sseene ne gaavange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Noo koe e kave gee de malo laa daha o tangada e hagadonu ai dana hagao ana muli, gai koe hagaahea ange dono malo gi de ia i mua nei de danu de laa; ");
INSERT INTO nkr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","go hiidinga deelaa donu huu dono malo e gahu ai i de boo. Gai se aha naa oona e gahu ai e seni? Gai noo ia e dangi mai ai gi de au, gai au e hagallongo donu dana dangidangi, i hiidinga au e lodo aloha. ");
INSERT INTO nkr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Aude basa hagamalaia i de Maadua aabe go dahi dagi o doo huaadangada. ");
INSERT INTO nkr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Aude daohia denga sigidaumaha mai i au mommee hhao huamanu aabe go au mommee kumi uvaini. Koe e gaamai hogi gi de au dau dama daane madua. ");
INSERT INTO nkr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Koe e hai hogi au kaau ma au ssiibi bee nei. Gai dugua gilaadeu gi nnoho i daho olaadeu dinana i e hidu laangi, aagai de hagavalu laangi naa huu gai koe gaamai manu nei gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Goodou ni dangada gu hagadabu mai gi de au; deenei ai, goodou e dee gai kano o de manu e daia laa ga maakau i denga manu lodo henua; gai dilia ange ono kano gi denga gaaduu. ");
INSERT INTO nkr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Aude hagadele ina denga longo hhadu. Aude hagabuni ange gi tangada baubau gi daalaa hagadonu ina ai ana muna hhadu. ");
INSERT INTO nkr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Aude ago ange i dangada soa gi haia ai de baubau, aabe gi hagahaisala ina de hagamodu heohi, i doo hagabuni ange gi dangada soa, ");
INSERT INTO nkr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","gai aude vae dangada ange gi tangada hagaau aloha, i de masavaa e hagamodu ai ono muna. ");
INSERT INTO nkr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Noo koe e gidee dahi kaau be go dahi donkey a doo hagadaumee gu madala ma gu hano gee, gai koe noodia hagaahea mai gi ono daha. ");
INSERT INTO nkr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Noo koe e gidee dahi donkey a tangada e kino i de goe gu baguu ma e dagodo i lalo dana mee e hagauda, gai koe e dee tili donu dana manu i kilaa; aagai koe bale ange hagahidi age de manu laa. ");
INSERT INTO nkr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Aude buibuia de hagamodu heohi ange gi tangada hagaau aloha, i de masavaa e hagamodu ai ono muna. ");
INSERT INTO nkr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Aude hagabaubau ina dahi i hanu muna hhadu, gai koe aude daia gi magau tangada e dee haisala ma de heohi, go hiidinga au e dee degi ange naa donu gi tangada e haia hegau nei. ");
INSERT INTO nkr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Aude gaavee de mee ngadi gaavange hagasenga; go hiidinga de mee bee nei e hai dangada gi dee gidee e gilaadeu de mee heohi ma de hagahaisala muna a dangada heohi. ");
INSERT INTO nkr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Aude vaivai haia tangada henua gee; goodou gu tonu ange donu gi dagodo o tangada henua gee, go hiidinga goodou nogo ni dangada henua gee i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Goodou dooa oodou alahenua ga hagihagi hua o denga manu iai i e ono ngadau; ");
INSERT INTO nkr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","aagai de hidu ngadau naa huu, gai goodou ga dugu oodou gelegele gi ngadi daakodo, gi deai hegau e hai ange aagena. Gai de gau hagaau aloha i oodou magavaa gi gaimee i manu e ssomo ai. Gai mee e doe i delaadeu gai, gai denga manu dolodolo gi gaimee ai. Gai deenei hogi doodou hai e hai ai oodou veelengaa olive aama oodou veelengaa grape. ");
INSERT INTO nkr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","E ono laangi aau e hai ai au hegau, aagai de hidu laangi naa huu gai koe hagamabu; gi hagammabu ai hogi dau kaau, ma dau donkey, ma tama daane a doo hahine hai hegau, aama tangada henua gee e nnoho laa i oo daha. ");
INSERT INTO nkr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Gai goodou kana ange daudali i muna alodahi aagu gu tala adu gi goodou. Goodou aude dalodalo i ingoo o denga diinonga, aabe e dagudagu olaadeu ingoo i oodou ngudu. ");
INSERT INTO nkr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“E dolu hanonga i de ngadau aau e hai mai ai taonga gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Koe haia Taonga o Pelaoaa Dee Hagahua, bei dagu hai gu tala adu ai gi goodou, gai koe ga gai pelaoaa dee hagahua i de masavaa gu hagailonga i e hidu laangi i de malama go Abib, go hiidinga deenei de malama oodou ne ssao mai ai i Egypt. Gai e deai donu se goodou e ngadi humai gi ogu mada i mua. ");
INSERT INTO nkr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Gai koe daoa Taonga o de Hagihagi, ga gaamai huamanu e hagihagi i taamada hugadoo, mai i denga manu e doo i honga doo gelegele. Dao hogi Taonga o de Hagabudu mai o denga huamanu, i de hagaodi o de ngadau, i de masavaa e odi mai ai huamanu i lodo au veelenga. ");
INSERT INTO nkr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","E dolu hanonga i de ngadau o denga daane alodahi i oodou magavaa e loomai ai gi mada luu mada o de Ia Aamua go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Aude haia dahi sigidaumaha mai gi de au i dodo madali mee iai mee hagahua. Mee moomuna o denga sigidaumaha i dagu daonga e dee dugu gi doe gi taiao age. ");
INSERT INTO nkr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Koe gaamai gi de hale o Tagi Maolunga doo Maadua denga hua i taamada o denga manu ssomo i honga doo gelegele. Aude duunaa tama a de guudi i lodo vai uu o dono dinana. ");
INSERT INTO nkr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Gai au e hai naa gi hano i oodou mada i mua tangada de langi gi buibuia ai goodou i honga de haiava, aama de kave goodou gi tae gi de mommee aagu gu hagadabena adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Gai goodou kana ange daudali i ana muna. Goodou aude haia oodou hai ange gi de ia, go hiidinga ia e dee degi adu naa donu gi oodou haisala; i hiidinga dogu sauaa e dagodo i ono daha. ");
INSERT INTO nkr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Aagai noo goodou e hagallongo ange gi ana muna, ga hai mee alodahi aagu e tala adu, gai au e hagadaumee ange naa gi oodou hagadaumee, ma de hai baasi ange gi gilaadeu e hai baasi adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Gai dogu dangada de langi e hano naa i oodou mada i mua ga dagi ai goodou gi de henua o de gau Amor, ma de gau Heth, ma de gau Perez, ma de gau Canaan, ma de gau Hiv, aama de gau Jebus, gai au e daa naa gilaadeu gi odi i de maakau. ");
INSERT INTO nkr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Goodou e dee ino ange gi olaadeu diinonga, be gi daumaha ange gi gilaadeu, aabe gi ago ange i alaadeu mee e hai. Aagai goodou oohaa ina olaadeu diinonga ma duludulu hadu olaadeu e daumaha ange laa aagena. ");
INSERT INTO nkr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Gai goodou gi daumaha mai gi de au, Tagi Maolunga doodou Maadua. Gai au ga hagamanuuia ai oodou gai ma vai unu, aama de kave gee denga hagadaagangaa magi alodahi mai i oodou magavaa, ");
INSERT INTO nkr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","gai e deai naa donu dama e ssege i oodou magavaa aabe se hine dee hua i honga doodou henua. Au e hai gi odi ange laangi oodou e mouli ai. ");
INSERT INTO nkr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Au e hai naa gi maatagu ma de manavasaa lodo o dangada e nnoho i de mommee oodou ga hulo naa aagena, ma de hai oodou hagadaumee gi maatagu gi saavini gi hulo gee mai i goodou. ");
INSERT INTO nkr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Gai au e hai naa gi hulo denga wasp gi haia gi hulo gee de gau Hiv, ma de gau Canaan, aama de gau Heth mai i oodou mada i mua. ");
INSERT INTO nkr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Aagai au e dee aau gee gilaadeu i doodou mommee i e dahi donu huu ngadau, gi dee ngadi dagodo ai de henua, gai gu kona de lagolago manu aada. ");
INSERT INTO nkr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Au e aau gee naa gilaadeu dagi de mommomo, ga dae ai gi doodou hagadili ga soa ga henua i de henua alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Au e hagatuu naa oodou goinga mai i Tai Mmea ga hano ga duu i Tai o Philistia, ma mai i de vao ga dae ai gi ssaalingaa vai go Euphrates. Gai au e hai naa gi kii goodou i dangada e nnoho i de henua, gai goodou ga aau gee ai gilaadeu gi dee nnoho i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Goodou aude haia dahi hagatoo donu hagaheloongoi ange gi gilaadeu ma olaadeu diinonga. ");
INSERT INTO nkr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Gai gilaadeu e dee nnoho i doodou henua, kana haia e gilaadeu goodou ga haisala mai gi de au; gai noo goodou e daumaha ange gi olaadeu diinonga, gai oodou lodo e noodia i de mee nei.” ");
INSERT INTO nkr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Gai Tagi Maolunga ne hai ange gi Moses, “Goodou ma Aaron, ma Nadab, ma Abihu, aama denga dagi o de gau Israel e dinohidu gi kage age gi ogu daha. Gai goodou ga daumaha i de mommee mmao, ");
INSERT INTO nkr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","aagai go Moses donu huu e humai gi baa mai gi Tagi Maolunga; gai de gau ange laa e dee loomai gi paa mai. Gai de huaadangada e dee loomai hogi madali ia.” ");
INSERT INTO nkr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Gai Moses ne humai ga tala ange gi de huaadangada muna alodahi a Tagi Maolunga ma mee alodahi gu hagamodu. Gai dangada ga pasa ange i de leo e dahi, ga hai ange, “Gimaadeu e hai donu gi bei muna alodahi a Tagi Maolunga gu tala adu gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Gai Moses ga sisi ga daohi muna alodahi a Tagi Maolunga. Taiao age gai Moses ga bae de mommee o ssigidaumaha i gaogao de mounga aama de hagatuu age e madaangahulu ma lua duludulu hadu, go taelodo o denga aamuli o Israel e dinoangahulu ma dogolua. ");
INSERT INTO nkr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Gai ia ga hai hanu dama daane mai i de gau Israel gi haia ssigidaumaha dudu, aama ssigidaumaha hagadanuaa magavaa i hanu kaau daane ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Gai Moses ga hagasahu ange dahi luu baasi o dodo laa gi lodo beisini, gai dahi luu baasi gai ia ga dabudabui ange gi honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Gai ia ga kave de beebaa e sisi ai laa de hagatoo donu hagaheloongoi ga dau ange muna e sisi ai gi dangada. Gai gilaadeu ga hai ange, “Gimaadeu e daudali naa donu i muna alodahi a Tagi Maolunga gu tala.” ");
INSERT INTO nkr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Gai Moses ga kave denga dodo ga dabudabui ange gi honga o dangada, ga hai ange gi gilaadeu, “Aanei dodo o de hagatoo donu hagaheloongoi a Tagi Maolunga ne hai madali goodou, bei dagodo o muna nei alodahi.”  ");
INSERT INTO nkr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Dua mee laa gai Moses ma Aaron, ma Nadab, ma Abihu, aama dagi o de gau Israel e dinohidu ga loage gi de mounga, ");
INSERT INTO nkr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","gai gilaadeu ne gidee de Maadua o Israel: de mommee i lalo luoono vae e bei dagodo o de mommee e hai i sapphire, gai e masalaba bei dagodo o lo te langi i lunga. ");
INSERT INTO nkr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Aagai de Maadua tee hagaduasala donu denga dagi aamua o de gau Israel, e dee galemu donu gilaadeu ne gidee de Maadua. Muli mai gai gilaadeu ne gaimee ma de unu i kilaa. ");
INSERT INTO nkr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Gai Tagi Maolunga ga hai ange gi Moses, “Gage age humai gi ogu daha i honga de mounga ma gi noho ai, gai au ga gaavadu gi de goe luu duu hadu e sisi ai hainga ma muna aagu gu lava i de sisi e agoagona ange ai gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Gai Moses ma Joshua, dono dangada bale ne loage gi de mounga, gai go Moses donu huu ne hanage ga dae gi ulu de mounga o de Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Gai ia ne hai ange gi denga dagi, “Goodou daalia gimaau i kinei ga dae ai gi demaau aahe mai. Gai Aaron ma Hur e nnoho i oodou daha; be goai naa huu e hanu alaadeu mee e dee heloongoi ai, gai gilaadeu gi loomai gi olaau daha.” ");
INSERT INTO nkr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Gai Moses ga hanage gi de mounga, gai de hagausinga ga haoli de mounga laa. ");
INSERT INTO nkr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Gai de mahamaha o Tagi Maolunga gu hano iho ga haoli de mounga go Sinai i e ono laangi. Aagai de hidu laangi huu gai ia ga hagahi mai Moses i lo te hagausinga laa. ");
INSERT INTO nkr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Gai de gau Israel ne gidee de mahamaha o Tagi Maolunga bei dagodo o de ahi ula i ulu de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Gai Moses ne hanage i de mounga ga ulu gi lo te hagausinga laa, ga noho i kilaa i e madahaa laangi ma boo. ");
INSERT INTO nkr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Daalaa ange gi de gau Israel gilaadeu gi daohia age hanu mee e hai ai ssigidaumaha mai gi de au. Gai koe ga kave mee alodahi a dangada e malangilangi i de daohi age. ");
INSERT INTO nkr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Gai aanei denga hagadaagangaa goloa alaadeu e daohi age e gaavadu gi de goe, go goolo, ma selevaa, ma bronze, ");
INSERT INTO nkr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ma huga malo buluu, ma de purple, ma de mmea, ma linen danuaa, ma huluhulu guudi, ");
INSERT INTO nkr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ma gili ssiibi gu tao ma gu mmea, ma gili kaau lausedi, ma laagau acacia, ");
INSERT INTO nkr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ma lolo olive e haula ai laama, ma mee hagamanongi e hai ai de lolo hagasulu aama ssigidaumaha o mee maanongi, ");
INSERT INTO nkr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ma hadu hagamogomogo go de onyx, ma hadu hagamogomogo ange laa e hagabigibigi ange gi de ephod, ma de mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Gai gilaadeu gi hagaduulia dahi hale dabu moogu, e noho ai au i olaadeu daha. ");
INSERT INTO nkr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Gai haia de tabernacle nei ma ono goloa alodahi gi bei de hagatau aagu gu hagaago adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Haia gilaadeu gi hagaduulia dahi ngavesi i laagau acacia — e lua sugilima ma de bido de looloa, e dahi ma de baasi sugilima de lahalaha, gai e dahi ma de baasi sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Gai koe haolia tua ma lodo i goolo danuaa, ga hagadagodo dahi dolodolo goolo ga holiage ai. ");
INSERT INTO nkr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Gai koe ga hagadaakodo e haa buulei goolo ga hagabigibigi ange gi denga vae e haa, e lua buulei i dahi baasi gai e lua buulei i de baasi ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Gai koe ga hai e lua dogo acacia ga haoli i goolo, ");
INSERT INTO nkr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ga velo ange gi lodo buulei i luu baasi de ngavesi e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Gai luu dogo naa e dugu donu huu i lodo buulei o de ngavesi nei, e dee aau mai donu. ");
INSERT INTO nkr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Gai koe ga hhao ange gi lo te ngavesi naa de mee Tala Hagadonu aagu e gaavadu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Gai haia hogi de pono o de tala haisala i goolo danuaa. Haia gi lua ma de bido sugilima de looloa, gai e dahi ma de baasi sugilima de lahalaha. ");
INSERT INTO nkr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Gai koe dugidugi hanu goolo i de haamaa haia ai e lua cherubim i luu bido o de pono o de tala haisala. ");
INSERT INTO nkr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Haia dahi cherub i dahi bido gai dahi i de bido ange laa; gai haia luu cherubim i luu bido laa gi buni donu huu ma de pono. ");
INSERT INTO nkr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Gai luu cherubim laa gi hagadau huuhuli ange, gai olaau bakau e doha i honga de pono o de tala haisala. Gai olaau mada gi huuhuli iho gi honga de pono. ");
INSERT INTO nkr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Gai koe ga dugu ange de pono laa gi honga de ngavesi, ga hhao ange de tala hagadonu aagu e gaavadu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Go kilaa, go honga e pono i magavaa luu cherubim i honga de ngavesi o de tala hagadonu, oogu e hedae adu ai gi de goe, gai au ga tala adu ai gi de goe agu muna alodahi ange gi de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Gai koe ga hai hogi dahi deebele i laagau acacia. Haia gi lua sugilima de looloa, e dahi sugilima de lahalaha, gai e dahi ma de baasi sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Gai koe ga haoli teebele i goolo danuaa ga hagadagodo dahi dolodolo goolo ga holiage ai luu baasi. ");
INSERT INTO nkr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Gai haia tolodolo i luu baasi gi dolu inisi de lahalaha, gai haolia tolodolo laa i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Gai koe ga hai e haa buulei goolo ga hagabigibigi ange gi denga dege e haa i honga vae e haa o teebele. ");
INSERT INTO nkr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Gai denga buulei nei e hai gi paa ange gi de hiihii e velo ange aagena denga dogo e saabai ai laa teebele. ");
INSERT INTO nkr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Gai koe ga hai e lua dogo i laagau acacia ga haoli i goolo, e saabai ai teebele. ");
INSERT INTO nkr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Gai haia ono beleidi ma ono gumedi, ma ono ubu, aama boolo e llingia ai denga sigidaumaha o mee unu i goolo danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Gai dugua pelaoaa i Mada Luoono Mada i honga teebele laa i mada luoogu mada i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Gai koe haia dahi mee dugu laama i goolo danuaa. Haia de haamaa dugidugia ai mee e hai ai de mee dugu laama. Dono dahido, ma de angaanga, ma ono ubu, ma ono gau, ma ono huaala e hai gi buni ma de angaanga. ");
INSERT INTO nkr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Gai haia e ono laa gi tuu mai i luu baasi de angaanga; e dolu laa i dahi baasi, gai e dolu laa i de baasi ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Gai e dolu hogi ubu bei huaala o de almond, madali denga gau ma huaala i dahi laa, gai e dolu hogi ubu i de baasi ange laa. Denga laa e ono e tuu mai laa i luu baasi de mee dugu laama e hai gi dagodo daudahi. ");
INSERT INTO nkr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Gai honga de mee dugu laama e haa ubu bei huaala o de almond iai madali olaadeu gau ma huaala. ");
INSERT INTO nkr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Haia e dagidahi gau i daahido o denga laa o de mee dugu laama; e dahi gau i lalo luu laa e mmua gi lunga, e dahi i lalo luu laa i lo te ungaalodo, gai e dahi i lalo luu laa e mmua gi lalo — e ono alodahi laa o de mee dugu laama. ");
INSERT INTO nkr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Gai denga gau ma denga laa e hai gi buni ma de angaanga, gai de laama alodahi e hai goolo danuaa ne tugi i de haamaa. ");
INSERT INTO nkr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Gai koe ga hai e hidu laama moo de mee dugu laama ga dugu age gi ulu ono laa, e hagamaalama ai de mommee i ono mada i mua. ");
INSERT INTO nkr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Gai ono mee diinei laama ma mee e hhao ai lehu e hai hogi i goolo danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Gai haia de mee dugu laama ma ono goloa alodahi i e dahi talent goolo danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Gai koe diiloo haia gi bei de hagatau aagu ne hagaago adu gi de goe i honga de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Gai koe haia de tabernacle i e madaangahulu malo buibui e hai i linen danuaa e amu ga hilo i huga malo buluu, ma de purple, aama de mmea ga hagalaagii i denga cherubim. ");
INSERT INTO nkr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Haia malo buibui nei alodahi gi se haidenga daudahi: e madalua ma lua sugilima de lloa, gai e haa sugilima de llaha. ");
INSERT INTO nkr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Gai koe ga hagapuni e lima malo buibui nei, gai denga malo e lima ange laa e hagapuni i gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Gai koe haia hanu mee hagalaulau buluu i de baasi o de malo e mua gi daha i dahi hagabuulingaa malo laa, gai e bei ai hogi de hagabuulingaa malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Haia e dagimadalima mee hagalaulau i de baasi o dahi luu hagabuulingaa malo laa, gai e madalima hogi mee hagalaulau i de hagabuulingaa malo ange laa; gai koe ga hai gi hagadau ssoe ange denga mee hagalaulau laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Gai koe ga hai e madalima biini goolo ga biini ai denga mee hagalaulau o luu hagabuulingaa malo laa, gi buni ai de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Gai koe ga hai hanu malo i huluhulu guudi e odo ai de tabernacle; haia e madaangahulu ma dahi malo laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Gai haia dahi malo laa gi matolu sugilima de looloa, gai e haa sugilima de lahalaha; haia malo e madaangahulu ma dahi nei gi se haidenga daudahi. ");
INSERT INTO nkr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Gai koe ga hagapuni e lima malo nei i gilaadeu, gai malo e ono ange laa i gilaadeu. Gai de ono malo i de lua hagabuulingaa malo laa e hhedu age i ma te hale malo. ");
INSERT INTO nkr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Gai koe ga hai e madalima mee hagalaulau i de baasi o dahi luu hagabuulingaa malo laa, gai e madalima mee hagalaulau i de hagabuulingaa malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Gai koe ga hai e madalima biini bronze e biini ai denga mee hagalaulau laa, gi buni luu hagabuulingaa malo laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Gai de bido e doe laa i luu hagabuulingaa malo laa e hai gi daudau iho i tua de buibui i de bido gi tua o de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Gai luu sugilima o de malo e hulo laa ma e dubu gi daha, dilia gi daudau iho i luu baasi de tabernacle e haoli ai. ");
INSERT INTO nkr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Gai koe haia hogi dahi malo i gili ssiibi ga tao gi mmea, aama dahi malo i gili kaau lausedi e haoli iho ai laa honga malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Gai haia laagau o de tabernacle i laagau acacia ga hagatuu age. ");
INSERT INTO nkr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Haia dahi laagau gi se madaangahulu sugilima de looloa, gai e dahi sugilima ma de baasi de lahalaha. ");
INSERT INTO nkr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Gai koe haia e lua hakauanga i de bido gi lalo o dahi laagau e hagadau hagamakaga ai denga laagau. Haia laagau alodahi o de tabernacle bee nei. ");
INSERT INTO nkr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Gai haia e madalua laagau ange gi de baasi gi ngaage o de tabernacle ");
INSERT INTO nkr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","gai e madahaa dagelo selevaa e hagatuu ange aagena denga laagau e madalua laa: e dahi laagau e lua ono dagelo ma e lua hakauanga, gai e lua hogi dagelo i lalo denga laagau ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Gai de baasi ngaiho o de tabernacle e madalua hogi laagau, ");
INSERT INTO nkr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ma e madahaa dagelo selevaa: e dagilua dagelo i lalo dahi laagau, gai e lua hogi dagelo i lalo denga laagau ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Haia hogi e ono laagau ange gi de bido gi tua o de tabernacle, go de bido gi dai. ");
INSERT INTO nkr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Gai koe haia e dagilua laagau i luu dege o de tabernacle i de bido gi tua. ");
INSERT INTO nkr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Luu laagau nei e hai gi madoha i bido i lalo, aagai olaau ulu e ulumagi ange gi tahi buulei; deenei dau hai e hai ai denga laagau i luu dege ngaadahi. ");
INSERT INTO nkr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Gai e valu alodahi laagau laa ma e madaangahulu ma ono dagelo selevaa; e dagilua dagelo selevaa e hagaduu ange ai dahi laagau, gai e lua hogi dagelo i lalo de laagau ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Gai koe haia hanu laagau hagamakaga i laagau acacia; e lima ange gi denga laagau i dahi baasi o de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","gai e lima hogi laagau hagamakaga i de baasi ange laa, gai e lima hogi laagau hagamakaga i de bido gi dai o de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Gai de laagau hagamakaga i lo te ungaalodo o denga laagau e velo gi sula gi luu bido. ");
INSERT INTO nkr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Gai koe ga haoli denga laagau i goolo, ma de hai olaadeu buulei i goolo e daohi ai denga laagau hagamakaga; gai koe ga haoli hogi denga laagau hagamakaga i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Gai koe ga hagaduu age de tabernacle bei de hagatau gu hagaago adu gi de goe i honga de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Gai koe ga hai dahi malo buibui i huga malo buluu, ma de purple, ma de mmea aama linen danuaa e amu ga hilo, ga maaga ange aagena denga cherubim. ");
INSERT INTO nkr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Gai koe haia hanu mee hagalaulau goolo, ga daudau ai de malo buibui laa gi denga duludulu acacia e haa, gu haoli laa i goolo, gai e hagatuu ange gi honga e haa dagelo selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Gai koe ga hai denga biini ga daudau age ai de malo buibui nei, ga gaamai de ngavesi o de tala hagadonu gi lo te mommee gu buibui laa; gai de malo buibui nei ga vvae ai magavaa o de Aabi Dabu ma de Aabi Dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Gai koe dugua ange de pono o de tala haisala gi honga de ngavesi o de tala hagadonu i lo te Aabi Dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Gai koe ga gaamai teebele i tua de Aabi Dabu mmao, gai koe ga hagaduu de mee dugu laama i de baasi gi ngaage o de tabernacle i de baasi gee teebele; gai teebele i de baasi gi ngaiho. ");
INSERT INTO nkr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Gai koe ga hai ange dahi malo buibui e dau i de haitoga o de hale malo i huga malo buluu, ma de purple ma de mmea aama linen danuaa e amu ga hilo, ga maaga i de niila. ");
INSERT INTO nkr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Gai koe ga hai e lima duludulu i laagau acacia ga haoli i goolo e daudau age ai de malo buibui, ga hagalau age i denga mee hagalaulau goolo. Gai koe ga hagadaakodo e lima dagelo bronze e hagatuu ange aagena denga duludulu. ");
INSERT INTO nkr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Gai koe haia de mommee o ssigidaumaha i laagau acacia, gai haia gi tuu dege; e lima sugilima de looloa, e lima sugilima de lahalaha, gai e dolu sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Gai koe ga hai denga hanga i honga ono dege e haa; gai haia ono hanga gi buni ma de angaanga o de mommee o ssigidaumaha, gai koe ga haolia de mommee o ssigidaumaha i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Gai koe ga hai hanu anibada e kave ai denga lehu, ma savolo, ma beisini, ma poogo, ma mee e hhao ai denga maga ahi; haia goloa nei alodahi i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Gai koe ga hai hogi e dahi gaini bronze, gai koe ga hai e haa buulei ga hagabigibigi ange gi honga denga dege e haa. ");
INSERT INTO nkr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Gai koe ga dugu ange de gaini gi lalo de hiihii o de mommee o ssigidaumaha, ga hai gi dae iho gi de madohi lua o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Gai koe ga hai e lua dogo e saabai ai de mommee o ssigidaumaha i laagau acacia, ga haoli i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Gai koe ga velo ange luu dogo nei gi lodo buulei laa, gi daakodo ai i luu baasi o de mommee o ssigidaumaha, i de masavaa e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Gai koe ga hagaduu de mommee o ssigidaumaha i hanu baabaa ga hai gi avaava ono lodo; hagaduulia gi bei de hai gu hagaago adu ai gi de goe i honga de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Gai koe haia hogi dahi buibui i luu baasi de tabernacle. Haia denga malo e dau i de baasi gi ngaage i linen danuaa e amu ga hilo, gai e lau sugilima de looloa i dahi baasi. ");
INSERT INTO nkr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Gai e madalua ono duludulu ma e madalua dagelo bronze; gai denga mee hagalaulau ma mee ulumagi i ulu denga duludulu ni selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Gai e bei ai hogi de baasi gi ngaiho o de buibui: denga malo e dau i de baasi i ngaiho e lau sugilima de looloa, gai e madalua ono duludulu ma dagelo bronze; gai denga mee hagalaulau ma mee e ulumagi i ulu denga duludulu laa ni selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Gai de bido gi dai o de buibui e madalima sugilima de lahalaha, gai e madaangahulu ono duludulu ma e madaangahulu dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Gai de lahalaha o de buibui i de bido gi dua, iai laa de haitoga, se madalima sugilima. ");
INSERT INTO nkr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Gai denga malo e dau ai dahi baasi o de haitoga se madaangahulu ma lima sugilima, madali e dolu duludulu ma e dolu dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Gai de malo e dau i de baasi ange laa e madaangahulu ma lima hogi sugilima, madali e dolu duludulu ma e dolu dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Gai de malo e dau i ma te haitoga o de buibui laa daha e hai gi madalua sugilima, gai e hai i huga malo buluu, ma de purple aama de mmea e amu ga hilo i linen danuaa, ga maaga i de niila, madali e haa duludulu ma olaadeu dagelo e haa. ");
INSERT INTO nkr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Gai denga duludulu alodahi i luu baasi de buibui iai mee hagalaulau ma mee e ulumagi ange aagena ni selevaa, gai olaadeu dagelo ni bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Gai de buibui se lau sugilima de looloa, e madalima sugilima de lahalaha, gai e lima sugilima de duuduu. Gai denga malo e dau ai e hai i linen danuaa e amu ga hilo, gai denga dagelo e hai i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Denga goloa alodahi e hai ai hegau o de tabernacle, ma ono baalanga e daohi ai, ma baalanga o de buibui laa daha e hai i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Gai koe daalaa ange gi de gau Israel, gilaadeu gi gaamai gi de goe lolo olive e tugi laa e haula ai laama, gi ula ai i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Gai de mee dugu laama e hagaduu i lo te hale malo hagabuni, i tua de malo e buibui ai laa de aabi o de ngavesi o de tala hagadonu; gai Aaron ma ana dama daane gi haulasia denga laama i mada luu mada o Tagi Maolunga, gi ula mai i de ahiahi ga dae ai gi taiao. De mee nei se hainga ange gi de gau Israel ma olaadeu atangada alodahi ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Gai koe ga gaamai doo daina go Aaron ma ana dama daane, go Nadab, ma Abihu, ma Eleazar, aama Ithamar; ga vvae gee gilaadeu mai i de gau Israel, ga hai gilaadeu gi ni gau haimeedabu e hai hegau mai ai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Gai koe ga hai hanu malo dabu moo doo daina go Aaron, ga hagadubu ai ma de hagamahamaha ai ia. ");
INSERT INTO nkr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gai koe ga tala ange gi de gau dui mee, aagu gu gaavange laa de labagau nei aagena, gai gilaadeu ga dui malo o Aaron e hagadabu ai ia gi se dangada haimeedabu e hai hegau mai ai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Aanei malo alaadeu e hai: e dahi mee e dau i hadahada, e dahi ephod, e dahi malo laa daha, e dahi malo belee, e dahi goobai malo, aama e dahi mee e nnoa ai lo te ungaalodo. Gilaadeu gi haia malo o doo daina go Aaron ma ana dama daane, e hai hegau mai gi de au i hegau a de gau haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Gai gaavange gi denga labagau hanu goolo, ma huga malo buluu ma de purple, ma de mmea, aama linen danuaa gu amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Gilaadeu gi haia de ephod i goolo, ma huga malo buluu, ma de purple, ma de mmea, aama linen danuaa gu amu ga hilo, ga maaga gi hagalaagii. ");
INSERT INTO nkr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Haia e lua beleesese e hagamakaga ange gi honga luu eu e daudau ange aagena de ephod i luu baasi. ");
INSERT INTO nkr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Gai laangaa dahi mee nnoa ungaalodo, gi bei de hai ne hai ai luu beleesese laa; haia i goolo, ma huga malo buluu, ma de purple, ma de mmea, aama linen danuaa gu amu ma gu hilo. ");
INSERT INTO nkr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Haia hogi e lua hadu onyx ga maaga ange aagena ingoo o denga dama daane a Israel, ");
INSERT INTO nkr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","e ono ingoo i honga dahi hadu laa, gai e ono ingoo i honga de hadu ange laa, mai i de madua ga hano iho ai gi de gauligi. ");
INSERT INTO nkr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Gai koe maaga ina ange ingoo o denga dama daane a Israel gi honga luu hadu nei, bei de hai a de labagau e maaga ai laa denga buulei hagailonga. Gai koe ga hagabigibigi ange gi honga denga gaini goolo hagalaagii. ");
INSERT INTO nkr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Gai koe ga hagabigibigi ange luu hadu nei gi honga luu eu o de ephod e hagamaanadu ai de gau Israel. Gai Aaron gi hagaudalia olaadeu ingoo i honga luoono eu e hagamaanadu ai gilaadeu i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Gai koe haia ange hogi e lua dagelo goolo, ");
INSERT INTO nkr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ma e lua seeini goolo danuaa, ga bini be ni daula; ga hagabigibigi ange gi honga luu dagelo goolo laa. ");
INSERT INTO nkr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Gai koe haia hogi de mee dau i hadahada e hagamodu ai lodo o de Maadua; haia gi hagalaagii, bei de hai ne hai ai laa de ephod: i goolo, ma huga malo buluu, ma de purple ma de mmea, aama linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","De mee laa e tuu dege, gai e hai gi dahi ianga de looloa, e dahi ianga de lahalaha, gai e hagapogo lua. ");
INSERT INTO nkr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Gai koe ga hagapigi ange e haa hagataaunga hadu hagamogomogo. Tahi hagataaunga e dahi ruby, e dahi topaz, gai e dahi carbuncle; ");
INSERT INTO nkr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","de lua hagataaunga e dahi emerald, e dahi sapphire, gai e dahi diamond; ");
INSERT INTO nkr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","tolu hagataaunga e dahi jacinth, e dahi agate, e dahi amethyst; ");
INSERT INTO nkr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","gai de haa hagataaunga e dahi beryl, e dahi onyx, gai e dahi jasper. Gai hagabigibigia ange mee nei alodahi gi honga denga gaini goolo. ");
INSERT INTO nkr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Denga hadu e madaangahulu ma lua nei e maaga ange aagena ingoo o denga aamuli e dinoangahulu ma dogolua o Israel, bei de hai e maaga ai laa denga buulei hagailonga; dahi hadu e maaga ange de ingoo o dahi aamuli. ");
INSERT INTO nkr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Gai koe ga bini e lua seeini goolo danuaa e dau ai de mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Gai koe ga hai e lua buulei goolo moo de mee dau i hadahada, ga hagamakaga ange gi luu dege. ");
INSERT INTO nkr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Gai koe ga hagamakaga ange luu seeini goolo laa gi denga buulei i luu dege o de mee dau i hadahada; ");
INSERT INTO nkr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","gai bido gee o luu seeini laa ga hagamakaga ange gi honga luu gaini goolo, ga hagabigibigi ange gi honga luu eu o de ephod i mada i mua. ");
INSERT INTO nkr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Gai koe haia e lua buulei goolo ga hagabigibigi ange gi luu dege i de bido gi lalo o de mee dau i hadahada, i de baasi lodo i gaogao de ephod. ");
INSERT INTO nkr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Gai koe ga hai hogi e lua buulei goolo, ga hagabigibigi ange gi luu beleesese i de bido gi lalo i mada i mua o de ephod, i gaogao tuinga i honga de mee nnoa ungaalodo o de ephod. ");
INSERT INTO nkr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Gai gilaadeu ga nnoa ange luu buulei o de mee dau i hadahada gi luu buulei i honga de ephod i dahi duaini buluu, gi dagodo ai i honga de mee nnoa ungaalodo o de ephod, gai gi dee doo mai ai de mee dau i hadahada i de ephod. ");
INSERT INTO nkr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Gai Aaron ga dau ai ingoo o denga dama a Israel, i lo te mee dau i hadahada e hagamodu ai muna, i honga dono hadu manava, i de masavaa alodahi oona e ulu ai gi lo te Aabi Dabu, e hagamaanadu ai gilaadeu i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Gai koe haoa hogi de Urim ma de Thummim gi lo te mee dau i hadahada, gi dagodo ai i honga de hadu manava o Aaron, i de masavaa alodahi oona e ulu ai gi mada luu mada o Tagi Maolunga. Deenei de hai a Aaron e dau ai mee e hagamodu ange ai muna, gi de gau Israel, i mada luu mada o Tagi Maolunga i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Gai koe haia de malo i lalo de ephod gi buluu alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Gai haia gi dahi mommee e hagaulu ange ai de biho i lo te ungaalodo, gai e dahi dalaa malo e dui i luu baasi de ulu o de malo laa gi dee madala mai ai. ");
INSERT INTO nkr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gai koe ga hai hanu pomegranate i huga malo buluu, ma de purple, aama de mmea, ga hagabigibigi ange gi de bido i lalo o de malo laa daha, ga haohaoa ai denga baalanga goolo vaaligiligi ga holiage ai: ");
INSERT INTO nkr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","e dahi baalanga, e dahi pomegranate, e dahi baalanga, e dahi pomegranate, ga holiage ai de bido i lalo o de malo laa daha. ");
INSERT INTO nkr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Gai Aaron gi gahu i de malo nei i de masavaa oona e hai ai ana hegau, gi langona ai e dangada de tangi o denga baalanga laa, i de masavaa oona e ulu ai gi de Aabi Dabu mmao i mada luu mada o Tagi Maolunga, aama de masavaa oona e sao mai ai, gi dee magau ai ia. ");
INSERT INTO nkr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Gai koe ga hai dahi dibaa goolo danuaa, ga maaga ange aagena muna nei: ‘Hagadabu ange gi Tagi Maolunga’, bei de hai e maaga ai de buulei hagailonga. ");
INSERT INTO nkr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Gai koe ga nnoa ange gi ma te goobai malo i dahi duaini buluu. ");
INSERT INTO nkr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Gai de mee nei e nnoa ange honga de lae o Aaron, gai ia ga tala ai haisala o de gau Israel i sigidaumaha alaadeu gu hagadabu, i alaadeu mee ngadi gaavange dabu alodahi; gai de mee nei e hai gi dagodo i honga de lae o Aaron i masavaa alodahi, gi malangilangi ai Tagi Maolunga i alaadeu sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Gai koe ga llanga hogi dahi malo belee ma dahi goobai malo i linen danuaa, ma dahi mee nnoa ungaalodo ga maaga i de niila. ");
INSERT INTO nkr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Gai koe ga llanga hogi hanu malo belee, ma hanu mee noonooa ungaalodo, aama hanu goobai moo denga dama daane a Aaron, e hagadubu ai gilaadeu ma de hagamahamaha. ");
INSERT INTO nkr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Gai koe ga hakahu ange doo daina go Aaron ma ana dama daane, ga hagasulu gilaadeu i de lolo ma de hagadabu gilaadeu e hai ai de gau haimeedabu, gai gilaadeu ga hai hegau mai ai gi de au i hegau a de gau haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Gai koe ga hai hanu malo laa lodo moolaadeu i linen, gi dee gilisau ai gilaadeu i lalo olaadeu malo; haia gi llilo olaadeu daogubu ga hano iho ai gi olaadeu gauanga. ");
INSERT INTO nkr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Gai Aaron ma ana dama daane gi kahu i malo nei, i de masavaa olaadeu e ulu ai gi lo te hale malo hagabuni, ma de masavaa olaadeu e hulo ai e hagapaa ange, e hai alaadeu hegau i gaogao de mommee o ssigidaumaha i lo te Aabi Dabu; gi dee maakau gilaadeu i delaadeu haisala i de mee nei. De mee nei se hainga gu hagasauaa ange gi Aaron ma dono aamuli ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Gai deenei dau hai e hagadabu ai gilaadeu e haia hegau a de gau haimeedabu. Gaavee dahi kaau daane ma e lua ssiibi daane e deai mee baubau i olaadeu angaanga, ");
INSERT INTO nkr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ma hanu pelaoaa dee hagahua, ma hanu keege dee hagahua e labu ma lolo, ma hanu besgede e dee hagahua ma de hulu ange lolo aagena. Gai koe haia mee nei i pelaoaa o denga grain gu mmili ma gu lligi. ");
INSERT INTO nkr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Gai koe ga hhao ange mee nei gi dahi gede ga gaamai madali de kaau ma luu ssiibi daane laa. ");
INSERT INTO nkr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Gai koe ga gaamai Aaron ma ana dama daane gi de haitoga o de hale malo hagabuni, ga hagagilimalali gilaadeu i vai. ");
INSERT INTO nkr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Gai koe ga gaamai denga malo laa, ga hakahu ange Aaron i de malo belee, ma de malo laa daha, ma de ephod, ma de mee dau i hadahada, ga nnoa lo tono ungaalodo i de mee nnoa ne llanga hagalaagii; ");
INSERT INTO nkr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","gai koe ga dugu ange de goobai malo gi honga dono biho, aama de nnoa ange de hau dabu goolo laa gi de goobai malo. ");
INSERT INTO nkr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Gai koe ga gaamai de lolo hagadabu ga llingi ange gi honga dono biho. ");
INSERT INTO nkr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Gai koe ga gaamai hogi ana dama daane, ga hakahu ange gilaadeu i denga malo belee, ");
INSERT INTO nkr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ga noonooa olaadeu ungaalodo i mee noonooa, ma de noonooa ange denga goobai gi honga olaadeu biho. Gai gilaadeu ga hai ai hegau a tangada haimeedabu ga hano ai. Deenei dau hai e hagadabu ai Aaron ma ana dama daane. ");
INSERT INTO nkr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Gai koe ga gaamai de kaau laa gi ma te hale malo hagabuni, gai Aaron ma ana dama daane gi dugua ange olaadeu lima gi honga de biho o de manu laa, ");
INSERT INTO nkr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","gai koe ga velo gi magau de kaau laa i mada luu mada o Tagi Maolunga, i ma te haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Gai koe ga kave hanu dodo o de kaau laa ga hulu ange gi honga denga hanga e haa o de mommee o ssigidaumaha i doo madannia, gai koe ga llingi ange denga dodo e doe gi tahido o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Gai koe ga kave denga mee moomuna alodahi e pigi ange gi denga dae, ma luu baasi o de ade, ma luu kidney madali denga mee moomuna iai, ga dudu i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aagai denga kano o de kaau laa, ma ono gili, ma denga dae, gai koe ga kave ga dudu i de ahi i tua de mommee nnoho gaainga; de mee nei go ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Gai koe ga gaamai dahi luu ssiibi daane laa, gai Aaron ma ana dama daane gi dugu ange olaadeu lima gi honga dono biho, ");
INSERT INTO nkr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","gai koe ga daa ssiibi laa ga kave ono dodo ga dabudabui ange gi luu baasi o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Gai koe ga duuduu aalanga o ssiibi daane laa ga hhui ono lodo ma denga vae, ga dugu ange gi gaogao o duudanga ange laa aama de biho. ");
INSERT INTO nkr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Gai koe ga dudu ssiibi daane laa alodahi i honga de mommee o ssigidaumaha; deenei ssigidaumaha dudu ange gi Tagi Maolunga; gai se sigidaumaha nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Gai koe ga gaamai ssiibi daane ange laa; gai Aaron ma ana dama daane gi dugua ange olaadeu lima gi honga de biho o ssiibi laa. ");
INSERT INTO nkr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Gai koe ga daa gi magau ssiibi laa, ga kave hanu ono dodo laa ga hulu ange gi hiihii dalinga madau o Aaron ma ana dama daane, ma honga madannia maatua o olaadeu lima madau, aama honga dabuvae maatua o olaadeu vae madau. Gai koe ga dabudabui ange dodo e doe gi luu baasi o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Gai koe ga kave hanu dodo i honga de mommee o ssigidaumaha laa, ma hanu lolo hagadabu ga hagassii ange gi honga o Aaron ma ono malo, aama honga o ana dama daane ma olaadeu malo; gai gilaadeu ma ana dama daane ma olaadeu malo gu hagadabu mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Gai koe ga kave denga mee moomuna o ssiibi daane, ma de muli iai laa mee moomuna, ma denga mee moomuna e pigi ange laa gi denga dae, ma mee moomuna o de ade, ma luu kidney ma mee moomuna iai, ma de aalanga o de vae madau (i hiidinga go ssiibi gu hagadabu ai de gau haimeedabu). ");
INSERT INTO nkr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Gai koe ga kave dahi duudangaa pelaoaa dee hagahua, ma dahi keege dee hagahua e labu ma lolo, aama dahi besgede, mai i lo te gede iai laa pelaoaa dee hagahua i mada luu mada o Tagi Maolunga; ");
INSERT INTO nkr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","gai koe ga dugu ange mee nei gi lodo luu lima o Aaron ma ana dama daane, gai gilaadeu gi daodaohia age mee nei i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Gai koe ga ahe ange ga kave mee laa mai i lodo olaadeu lima, ga dudu madali ssigidaumaha dudu i honga de mommee o ssigidaumaha, e hai ai ssigidaumaha nnamu kala i mada luu mada o Tagi Maolunga. Mee nei se sigidaumaha e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Gai koe ga kave hogi de aalanga o de aloalo ne hagadabu ai laa Aaron, ga daodaohi age i mada luu mada o Tagi Maolunga, e hai ai ssigidaumaha daodaohi age, gai de mee nei go doo duuhanga. ");
INSERT INTO nkr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Gai koe ga hagadabu de aalanga o de aloalo ne hai ai laa ssigidaumaha daodaohi age, ma de aalanga o de vae ne hai ai laa tuuhanga o de gau haimeedabu, mai i ssiibi ne hai ai laa de hagadabu, i hiidinga deenei tuuhanga o Aaron ma ana dama. ");
INSERT INTO nkr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Tuuhanga nei se mee mai i daho de gau Israel ange gi Aaron ma ana dama daane ga hano ai. Deenei tuuhanga o de gau haimeedabu a de gau Israel e gaavange mai i alaadeu sigidaumaha hagadanuaa magavaa; deenei delaadeu sigidaumaha ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Gai denga malo dabu o Aaron ni mee ange hogi gi denga dama daane i dono aamuli i muli mai, gilaadeu gi kahu ai i de masavaa olaadeu e hagasulu ai ga hagadabu. ");
INSERT INTO nkr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Gai tama e gaavee laa tuulanga o Aaron ga hai ai hegau a tangada haimeedabu gi gahu i malo nei i e hidu laangi, i de masavaa oona e ulu ai gi lo te hale malo hagabuni, ga hai ai ana hegau i lo te Aabi Dabu. ");
INSERT INTO nkr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Gai koe ga kave ssiibi daane ne hai ai laa de hagadabu ga boale ono kano i dahi mommee dabu; ");
INSERT INTO nkr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","gai Aaron ma ana dama daane gi gaina kano o ssiibi laa madali denga pelaoaa i lo te gede laa, i gaogao de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Gilaadeu gi gaina mee ne hai ai ssigidaumaha e tala ai olaadeu haisala ma de hagadabu ai gilaadeu, aagai e deai ange donu dangada gee e maua i de gai denga mee nei, go hiidinga mee nei e dabu. ");
INSERT INTO nkr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Gai noo e hanu kano o ssiibi o de hagadabu, be ni pelaoaa e doe i taiao age, gai koe ga dudu i de ahi; mee nei e dee gai donu, go hiidinga ni mee dabu. ");
INSERT INTO nkr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Gai koe ga hai ange gi Aaron ma ana dama daane gi bei mee alodahi aagu gu tala adu gi de goe; gai e hidu laangi aau e hagadabu ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Laangi alodahi gai koe haia ssigidaumaha o haisala i dahi kaau daane. Gai koe hagagilimalali de mommee o ssigidaumaha, i de hai ssigidaumaha nei i ono elunga, ma de llingi ange lolo ga hagadabu ai. ");
INSERT INTO nkr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","E hidu laangi aau e hagagilimalali ai ma de hagadabu de mommee o ssigidaumaha. Gai de mommee o ssigidaumaha e hai naa ga dabu mmao. Gai be se aha naa huu e hagabaa ange gi de mommee o ssigidaumaha, gai gu dabu hogi. ");
INSERT INTO nkr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Gai aanei au manu e hai ai ssigidaumaha i honga de mommee o ssigidaumaha i laangi alodahi: e lua ssiibi gu dagidahi ngadau. ");
INSERT INTO nkr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Gai dahi ssiibi nei e hai ai ssigidaumaha i taiao, gai ssiibi ange laa e hai ai ssigidaumaha i de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Gai ga hagahidi hogi e dahi diba i diba e madaangahulu o dahi ephah pelaoaa lligi gu hilo ma dahi diba i diba e haa o dahi hin lolo ne tugi, aama dahi diba i diba e haa o dahi hin uvaini e hai ai ssigidaumaha o mee unu. ");
INSERT INTO nkr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Gai koe ga daa ssiibi ange laa ga hai ai ssigidaumaha i de ahiahi, madali aama ssigidaumaha o grain ma ssigidaumaha o mee unu, bei de hai ne hai ai i taiao, ga hai ai dahi ssigidaumaha nnamu kala i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ssigidaumaha dudu nei e hai i laangi alodahi i daho oodou atangada i muli mai, gai haia i ma te haitoga o de hale malo hagabuni i mada luu mada o Tagi Maolunga, go kilaa oogu e hedae adu ai gi goodou ma de basa adu ai gi goe. ");
INSERT INTO nkr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Go kilaa hogi oogu e hedae adu ai gi goodou de gau Israel, gai au ga hai ai gi dabu de mommee laa i dogu mahamaha. ");
INSERT INTO nkr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Gai au ga hagadabu ai de hale malo hagabuni ma de mommee o ssigidaumaha, ma de hagadabu ai Aaron ma ana dama daane gi ni dangada haimeedabu, gai gilaadeu ga hai hegau mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Gai au ga noho ai madali de gau Israel, gai go au delaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Gai gi iloo ai e gilaadeu bolo go au donu go Iahweh delaadeu Maadua, ne hagassao ina mai gilaadeu i de henua go Egypt, gai au ga noho ai i olaadeu daha. Go au Tagi Maolunga delaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Gai koe haia dahi mommee o ssigidaumaha o mee maanongi i laagau acacia. ");
INSERT INTO nkr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Haia gi tuu dege; de looloa ma de lahalaha se dahi sugilima, gai dono duuduu se lua sugilima. Gai haia denga hanga e haa gi buni ma de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Gai koe ga haoli ono elunga ma luu baasi aama ono hanga i goolo danuaa. Gai koe ga hai dahi dolodolo goolo i luu baasi ga holiage ai. ");
INSERT INTO nkr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Gai koe ga hagadaakodo e lua buulei goolo, ga hagabigibigi ange gi lalo tolodolo i luu baasi, e velo ange aagena luu laagau e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gai koe haia e lua dogo i laagau acacia, ga haoli i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Gai koe ga kave de mommee o ssigidaumaha laa ga hagaduu i tua de malo buibui o de aabi o de ngavesi o de tala hagadonu, ma de pono o de tala haisala, go kilaa oogu e hedae adu ai gi de goe. ");
INSERT INTO nkr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Gai Aaron ga dudu mee maanongi i ono elunga i daiao alodahi, i de masavaa aana e hagadabena ai denga laama. ");
INSERT INTO nkr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Gai de masavaa naa huu a Aaron e haula ai denga laama i de ahiahi, gai ia ga dudu mee nei, denga mee nei ni mee e dudu i mada luu mada o Tagi Maolunga i daho oodou atangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Goodou e dee dudu hanu mee maanongi gee i honga de mommee o ssigidaumaha nei, be ni sigidaumaha dudu, be go ssigidaumaha o grain; goodou e dee liingia ange hogi ssigidaumaha o mee unu gi ono elunga. ");
INSERT INTO nkr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Dahi hanonga i de ngadau, gai Aaron e hagagilimalali hanga o de mommee o ssigidaumaha o mee maanongi, i dodo o ssigidaumaha e tala ai laa haisala. De mee nei e hai, i ngadau alodahi ange gi denga atangada e loomai. De mommee nei e dabu mmao ange gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“De masavaa naa huu aau e dau ai de gau Israel, gai dahi ma dahi gi gaamai dahi hagaoanga moona e gaavange gi Tagi Maolunga, gi deai ai se mee hagamaakau e duu ange gi gilaadeu i de masavaa aau e hai ai de hegau nei. ");
INSERT INTO nkr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Gilaadeu alodahi ne dau e hagao taelodo nei: e dahi baasi shekel, i de hagabaaunga o shekel o de hale dabu (dahi shekel e madalua gerah) e daohi age e sigidaumaha ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Gilaadeu alodahi ne sisi olaadeu ingoo, go dangada gu madalua olaadeu ngadau ga hanage ai, e daohi age dahi sseene e gaavange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Tangada lava e dee lagolago ange ana mee e daohi age, gai tangada hagaau aloha e dee sogoisi mai ange i de baasi shekel, i de masavaa oodou e daohi age ai mee nei e gaavange gi Tagi Maolunga, e hagao ai oodou mouli. ");
INSERT INTO nkr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gai koe ga kave sseene nei mai i daho de gau Israel, e hagao ai gilaadeu, ga gaavange e hai ai hegau o de hale malo hagabuni; e hagamaanadu ai de gau Israel i mada luu mada o Tagi Maolunga. De mee nei se mee e tala ai oodou haisala.” ");
INSERT INTO nkr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Haia dahi daaba ma dono dagelo i bronze, e hagagilimalali ai. Gai koe ga hagaduu i magavaa de hale malo hagabuni ma de mommee o ssigidaumaha, ga hhao i vai. ");
INSERT INTO nkr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Go kinei o Aaron ma ana dama daane e hhui ai olaadeu lima ma vae. ");
INSERT INTO nkr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","I mua delaadeu hulo e ulu gi lo te hale malo hagabuni, be go de hulo e hagapaa ange gi de mommee o ssigidaumaha, e dudu ai dahi sigidaumaha ange gi Tagi Maolunga, gilaadeu gi hagagilimalali ina gilaadeu i vai, gi dee maakau ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Gilaadeu gi huuia olaadeu lima ma vae gi dee maakau ai gilaadeu; de mee nei se hainga gu hagasauaa ange gi gilaadeu ga hano ai, ange gi Aaron ma dono aamuli i olaadeu atangada alodahi.” ");
INSERT INTO nkr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Gai Tagi Maolunga ne basa ange hogi gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Gaavee hanu mee hagamanongi danuaa: e limalau shekelmyrrh vaivai, ma e 250 shekelcinnamon manongi, ma e 250 shekel madila manongi, ");
INSERT INTO nkr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ma e limalau shekelcassia, i de hagabaaunga o shekel o de hale dabu, ma e dahi hin lolo olive. ");
INSERT INTO nkr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Gai koe ga hilo mee nei e hai ai de lolo hagasulu dabu, bei vai maanongi a de labagau e hai laa; de mee nei se lolo dabu e hagasulu ai. ");
INSERT INTO nkr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Gai koe ga hagasulu ai de hale malo hagabuni ma de ngavesi o de tala hagadonu, ");
INSERT INTO nkr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ma teebele ma ono goloa alodahi, ma de mee dugu laama ma ono goloa alodahi, ma de mommee o ssigidaumaha o mee maanongi, ");
INSERT INTO nkr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ma de mommee o ssigidaumaha dudu ma ono goloa alodahi, aama taaba ma dono dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Gai koe ga hai mee nei gi dabu, gi dabu mmao ai; gai be se aha naa huu e baa ange gi mee nei, gai gu dabu hogi. ");
INSERT INTO nkr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Gai koe ga hagasulu Aaron ma ana dama daane i de lolo, ga hagadabu gilaadeu, gai gilaadeu ga hai hegau mai ai gi de au i hegau a de gau haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Gai koe daalaa ange gi de gau Israel hai ange, ‘De lolo nei se lolo hagasulu dabu i daho oodou atangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","De lolo nei e dee maua donu i de hulu ai de angaanga o dahi dangada gee, gai goodou e dee hilo hogi hanu lolo gi bei de hiilonga ma de hagabaaunga o de lolo nei; de lolo nei e dabu, gai goodou haia de mee nei gi se lolo dabu i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Gai be goai naa huu e hilo ina dahi lolo bee nei, be hulu ai dahi dangada gee, gai ia e vvae gee donu mai i daho de gau Israel.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Gai Tagi Maolunga ga hai ange gi Moses, “Hagabau ina denga mee maanongi nei i de hagabaaunga daudahi, go stacte, ma onycha, ma galbanum, aama frankincense masalaba, ");
INSERT INTO nkr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","gai koe ga hilo mee ga hai ai dahi vai manongi, bei mee a tangada hai vai manongi e hai. De vai nei e gaavange soolo aagena, gai e masalaba ma de dabu. ");
INSERT INTO nkr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Gai koe ga tugi hanu mee nei gi lligi, ga kave hanu ga dugu i mada i mua o de ngavesi o de tala hagadonu i lo te hale malo hagabuni, go de mommee oogu e hedae adu ai gi de goe; mee nei e dabu mmao adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Gai goodou aude haia hanu mee hagamanongi bei mee nei e hagamanongi ai goodou; gai hagadabu ina ange mee nei gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Be goai e haia dahi vai manongi bei nei ga hagamanongi ai, gai ia e vvae gee donu mai i daho de gau Israel.” ");
INSERT INTO nkr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Gai Tagi Maolunga ga basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tilo, au gu hagahi Bezalel tama daane a Uri, tama daane a Hur, mai i de aamuli o Judah, ");
INSERT INTO nkr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","gai au gu hhao ia i ssauaa o dogu Hagasaalunga, ma de hina ma de heiangi, ma de iloo mee, aama denga hagadaagangaa hegau alodahi a de labagau e hai. ");
INSERT INTO nkr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Gai ia ga hai ai denga hagadaagangaa goloa i goolo ma selevaa ma bronze, ");
INSERT INTO nkr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ma de duuduu denga hadu hagamogomogo e hagatau, ma de daadaa denga laagau, aama de hai denga hagadaagangaa hegau o de labagau. ");
INSERT INTO nkr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Gai tilo, au gu hili hogi Oholiab, tama daane a Ahisamak, mai i de aamuli o Dan. Gai au gu gaavange gi daane heiangi alodahi olaadeu hina e hai ai goloa alodahi aagu gu tala adu gi de koe: ");
INSERT INTO nkr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","go de hale malo hagabuni, ma de ngavesi o de tala hagadonu, ma de pono o de tala haisala, ma goloa alodahi o de hale malo, ");
INSERT INTO nkr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ma teebele ma ono goloa, ma de mee dugu laama goolo ma ono goloa alodahi, ma de mommee o ssigidaumaha o mee maanongi, ");
INSERT INTO nkr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ma de mommee o ssigidaumaha dudu ma ono goloa alodahi, ma taaba ma dono dagelo, ");
INSERT INTO nkr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ma denga malo mahamaha o tangada haimeedabu go Aaron ma ana dama daane e kahu e hai ai hegau a tangada haimeedabu, ");
INSERT INTO nkr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ma de lolo hagadabu, ma mee maanongi ange gi de Aabi Dabu. Gai gilaadeu ga hai ai mee nei gi bei de hai aagu gu tala adu ai gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Gai Tagi Maolunga ga basa ange, ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Daalaa ange gi de gau Israel hai ange, ‘Goodou dao ina agu Sabbath, i hiidinga de mee nei se hagailonga mai i ogu daha adu gi goodou ma oodou atangada alodahi, gi iloo ai e goodou bolo go au go Iahweh, ne haia laa goodou gi dabu. ");
INSERT INTO nkr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Gai goodou dao ina de laangi o Sabbath, i hiidinga se laangi dabu niiodou. Be goai e dee hagadabu ina Sabbath, gai ia e daa donu gi magau; gai be goai e hai hegau i de laangi laa, gai ia e vvae gee donu mai i daho dono huaadangada. ");
INSERT INTO nkr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","E ono laangi e hai ai hegau, aagai de hidu laangi go Sabbath, se laangi hagammabu, ma de hagadabu ange gi Tagi Maolunga; be goai e haia hanu hegau i de laangi o Sabbath e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Deelaa ai, de gau Israel gi daohia Sabbath, ma de hai hegau ai i daho olaadeu atangada alodahi, de mee nei se hagatoo donu hagaheloongoi ga hano ai huu. ");
INSERT INTO nkr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","De mee nei se hagailonga niiagu e gaavange gi de gau Israel ga hano ai; go hiidinga Tagi Maolunga ne hai de langi ma henua i lalo i e ono laangi, aagai de hidu laangi huu gai ia ga hagalava ana hegau ga hagamabu.’ ”  ");
INSERT INTO nkr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Gai ga lava huu ana muna i de tala ange gi Moses i honga de mounga go Sinai, gai ia ga gaavange luu duu hadu o de tala hagadonu gi Moses, go mee a de Maadua ne sisi i dono lima donu. ");
INSERT INTO nkr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Gai ga gidee huu e dangada bolo Moses gu mmule de ahe iho i ulu de mounga, gai gilaadeu ga hagabuni mai gi daho Aaron, ga hai ange gi de ia, “Haia hanu diinonga gi dagina gidaadeu, go hiidinga gidaadeu e dee iloo be ni aha gu hai ange gi Moses, taane ne hagassao ina mai gidaadeu i de henua go Egypt.”  ");
INSERT INTO nkr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Gai Aaron ga hai ange gi gilaadeu, “Goodou aaua denga hakai goolo i dalinga o oodou bodu, ma oodou dama alodahi gaamai gi ogu daha.” ");
INSERT INTO nkr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Gai dangada alodahi ga aau hakai i olaadeu dalinga ga gaavange gi Aaron. ");
INSERT INTO nkr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gai Aaron ne kave hakai laa i daho dangada ga hagavaivai, ga hai ai dahi kaau goolo. Gai gilaadeu ga hagataba, “De gau Israel, aanei denga diinonga ne hagassao ina mai goodou i de henua go Egypt.”  ");
INSERT INTO nkr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Gai ga gidee huu e Aaron, gai ia ga hai dahi mommee o ssigidaumaha ga dugu i mada i mua o de kaau goolo laa. Gai ia ga hai dahi hagailoo ga hai ange, “Daiao gai gidaadeu e hai ange taonga gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Gai dangada ne oho age i de laangi i ono dua, ga hai denga sigidaumaha dudu ma de gaamai denga sigidaumaha hagadanuaa magavaa. Gai de huaadangada ga nnoho iho ga gaimee ma de unu, ga lava ga hiihidi age ga hai denga dahulinga baubau. ");
INSERT INTO nkr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Gai Tagi Maolunga ga hai ange gi Moses, “Hagamoolau hano iho gi lalo, go hiidinga au dangada ne hagassao mai i de henua go Egypt, gu hai denga dahulinga hakino gee. ");
INSERT INTO nkr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Gilaadeu ne moolau donu de hulo gee mai i de haiava aagu gu tala ange gi gilaadeu; gilaadeu gu lava i de hai dahi kaau baalanga, ma gu daumaha ma de sigidaumaha ange aagena, ma de hagataba, ‘De gau Israel, aanei denga diinonga ne hagassao ina mai goodou i de henua go Egypt!’ ” ");
INSERT INTO nkr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Gai Tagi Maolunga ne hai ange gi Moses, “Au gu lava donu i dagu gide dagodo o de huaadangada nei, gilaadeu ni dangada donu makaga olaadeu lodo. ");
INSERT INTO nkr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Deenei ai, hano gee mai i ogu daha, gai au ga daa gilaadeu gi odi i de maakau i hiidinga au gu lili mmao i gilaadeu, gai au ga hai goe gi se huaahenua soa.” ");
INSERT INTO nkr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Aagai Moses ne dangidangi ange gi Tagi Maolunga dono Maadua, ga hai ange, “Tagi Maolunga, gu aha gu kona ai naa doo lili i doo huaadangada, aau ne hagassao mai laa i de henua go Egypt, i denga sauaa maolunga ma doo lima mmahi? ");
INSERT INTO nkr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gai gu aha gu hai ai gi maua e de gau Egypt i de hagataba, ‘Tagi Maolunga se hagassao donu huu gilaadeu e kave e daa gi maakau i magavaa denga mounga, ma de hai gi odi gilaadeu i teai i henua i lalo.’ Hagahelui ina doo bole, gai suuia dau hagatau, koe gi dee hagaduasala ina doo huaadangada. ");
INSERT INTO nkr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Manadua Abraham, ma Isaac, aama Israel, oo dangada hai hegau. Koe ne hagatoo donu ange gi gilaadeu i doo ingoo donu, ga hai ange gi gilaadeu, ‘Au e hai naa oodou aamuli gi soa bei de lagolago o denga heduu i lo te langi, gai au e gaavange naa gi oodou aamuli de henua aagu gu hagatoo donu adu gi gilaadeu gi henua ai ga hano ai.’ ”  ");
INSERT INTO nkr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Gai Tagi Maolunga ga sui de hagatau aana ne maanadu laa de hai, ia tee hagaduasala dono huaadangada. ");
INSERT INTO nkr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Gai Moses ga huli ga hano iho i de mounga, gai ia e poo luu duu hadu o de tala hagadonu i luoono lima; luu duu hadu laa e sisi ngaadahi luu baasi, baasi lodo ma baasi i tua. ");
INSERT INTO nkr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Gai luu duu hadu laa go de Maadua ne haia, gai go de lima hogi o de Maadua ne sisi ai muna i honga luu duu hadu laa. ");
INSERT INTO nkr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Gai ga langona huu e Joshua leo o dangada e hevaalogi ai, gai ia ga hai ange gi Moses, “Dangada e hevaalogi i de mommee nnoho gaainga bei de hevaalogi i hiidinga o de hebagi.” ");
INSERT INTO nkr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Gai Moses ga hai ange, “E dee go leo o dangada e hevaalogi i de kii deenei, be go de hevaalogi i delaadeu maakulu; aagai go de leo o taahili aagu e langona adu.” ");
INSERT INTO nkr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Gai ga hano iho huu Moses ga dae iho gi de mommee nnoho gaainga, gai ia gu gidee de kaau goolo laa ma denga aanunga a dangada e hai; aagai Moses gu kona mmao de lili, gai ia ga poo luu duu hadu laa ga maga iho gi gaogao de mounga gu maoha. ");
INSERT INTO nkr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Gai ia ga kave de kaau goolo laa ga dudu ga mmili gu lligi ga hagamalili ange gi lodo vai ga hai de gau Israel gi unumia. ");
INSERT INTO nkr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Gai Moses ga hai ange gi Aaron, “Ni aha a de huaadangada nei ne hai adu laa gi de goe, gai koe ga dugu ange ai nei gilaadeu gi haia de baubau laumalie nei?” ");
INSERT INTO nkr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Gai Aaron ga hai ange, “Dogu dangada aamua, koe gi dee kona doo bole. Koe e iloo naa donu dagodo o de gau nei; gilaadeu e nnoho ange huu e hai de baubau. ");
INSERT INTO nkr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Gilaadeu ne hai mai gi de au, ‘Haia dahi diinonga gi dagina gidaadeu, go hiidinga gidaadeu e dee iloo donu be ni aha gu hai ange gi Moses, taane ne hagassao ina mai nei gidaadeu i de henua go Egypt.’  ");
INSERT INTO nkr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Gai au ne hai ange gi gilaadeu, ‘Be goai e hanu ono mee hagalaagii goolo, gai ia gi aaua gi gaamai gi de au.’ Gai gilaadeu ga hagaui goolo laa ga gaamai, gai au ne maga ange gi lo te ahi, gai gu sula mai ai de kaau goolo nei!” ");
INSERT INTO nkr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Gai ga gidee huu e Moses bolo Aaron gu tili ange donu huu dangada gi haia olaadeu lodo, ma de hai olaadeu hagadaumee gi pasa hakadanga ma de doo mee i gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Gai Moses ne hano ga duu i de haitoga o de mommee nnoho gaainga, gai ia ga hai ange, “Be goai naa huu e dau ange gi Tagi Maolunga, gai ia gi humai gi duu i ogu daha.” Gai de aamuli alodahi o Levi gu loomai ga tuu madali ia. ");
INSERT INTO nkr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Gai Moses ne hai ange gi gilaadeu, “E hagadaba Tagi Maolunga de Maadua o Israel, ‘Dahi ma dahi gi dau ina dana gadilaasa, ma gi hano laa magavaa o dangada i de mommee nnoho gaainga, ga daia ai gi maakau ono daina donu, ma dono soa, aama tangada e paa ange gi de ia.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Gai denga aamuli o Levi ga hulo ga hai gu bei muna a Moses; gai gilaadeu ne daa ga maakau e dolumano dangada i de laangi laa. ");
INSERT INTO nkr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Gai Moses ga hai ange, “Anailaa nei gai goodou gu hagadabu ange goodou gi hegau a Tagi Maolunga, go hiidinga dahi ma dahi gu hai baasi ange donu gi oodou dama ma oodou daina, deelaa ai, ia gu hagamanuuia goodou ailaa nei.” ");
INSERT INTO nkr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","De laangi i ono dua, gai Moses ga hai ange gi dangada, “Goodou gu hai dahi baubau laumalie mmao. Gai au ga hanage nei gi daho Tagi Maolunga e tilo be au e maua i de tala oodou haisala.” ");
INSERT INTO nkr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Gai Moses ne ahe gi daho Tagi Maolunga, ga hai ange, “De huaadangada nei gu hai dahi haisala laumalie mmao! Gilaadeu gu hai hanu diinonga goolo moolaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Aagai noo koe e malangilangi, gai koe degi ange gi olaadeu haisala; gai noo e deai, gai au e dangidangi adu, sooloa dogu ingoo mai i lo tau beebaa gu sisi ai laa ingoo.”  ");
INSERT INTO nkr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Aagai Tagi Maolunga ga hai ange gi Moses, “Be goai naa huu e haisala mai gi de au, gai go ia aagu e ssolo dono ingoo i lo tagu beebaa. ");
INSERT INTO nkr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Iainei gai koe hannoo dagina de huaadangada naa gaavee gi de mommee aagu gu tala adu gi de goe. Gai dogu dangada de langi e hano naa i oo mada i mua. Aagai de laangi naa huu aagu e hagaduasala ai gilaadeu, gai au ga hagaduasala gilaadeu i hiidinga olaadeu haisala.” ");
INSERT INTO nkr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Gai Tagi Maolunga ga gaamai dahi mee hagamaakau gi honga de huaadangada, i hiidinga o de kaau goolo a Aaron ne hai laa. ");
INSERT INTO nkr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Goodou ma dangada aau ne hagassao mai naa i de henua go Egypt hulo gee mai kinei, goodou hulo gi de henua aagu gu hagatoo donu ange laa gi Abraham, ma Isaac, aama Jacob, ma gu hai ange, ‘Au e gaavange naa de henua nei gi doo aamuli.’  ");
INSERT INTO nkr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Gai au e hai naa tangada de langi gi hano i oo mada i mua, gai ia ga hai ai gi hulo gee de gau Canaan, ma de gau Amor, ma de gau Heth, ma de gau Perez, ma de gau Hiv, aama de gau Jebus. ");
INSERT INTO nkr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Goodou loage hulo gi de henua iai vai uu ma hooni lagolago; aagai au e dee hanage madali goodou, go hiidinga goodou ni dangada makaga oodou lodo, kana daia e au goodou ga maakau i taadeu seesee e hulo.” ");
INSERT INTO nkr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Gai ga langona huu e dangada muna hagalodo baubau nei, gai gilaadeu gu daemaha; gai teai donu se gilaadeu ne daulia hanu mee hagalaagii be ne gahu hagadanuaa. ");
INSERT INTO nkr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Go hiidinga Tagi Maolunga gu hai ange gi Moses, “Daalaa ange gi de gau Israel hai ange, ‘Goodou ni dangada makaga oodou lodo; gai noo au e hano madali goodou i dahi damaa masavaa, gai au e daa naa goodou gi odi i de maakau. Deenei ai, goodou aaua gee oodou mee hagalaagii ma mee kahu hagadanuaa, gai au ga hili ai be se aha e hai adu gi goodou.’ ” ");
INSERT INTO nkr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Deelaa ai, de gau Israel ne aau olaadeu mee hagalaagii ma olaadeu malo hagadanuaa, ga daamada mai i de mounga go Horeb ga hulo ai. ");
INSERT INTO nkr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Gai Moses e mau i de kave dahi hale malo ma e hagaduu i tua de mommee nnoho gaainga, i dahi mommee mmao mai i de mommee nnoho gaainga, gai ia ne hagaingoo ange de hale laa go de hale malo hagabuni. Gai tangada naa huu e lodo e dangidangi ange gi Tagi Maolunga i dahi mee, gai ia ga hano gi de hale malo hagabuni, i tua de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Gai de masavaa naa huu o Moses e sao ai e hano gi de hale malo laa, gai dangada alodahi ne hiihidi age ga tuu i gaogao haitoga o olaadeu hale malo ga haaina adu ai Moses, ga dae ai gi dono hano ga ulu gi lo te hale malo laa. ");
INSERT INTO nkr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Gai de masavaa naa huu o Moses e ulu ai i de hale malo laa, gai tuludulu hagausinga ga hano iho ga duu i ma te haitoga o de hale malo laa, gai Tagi Maolunga ga basa ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Gai de masavaa naa huu a dangada e gidee ai tuludulu hagausinga laa gu duu i ma te haitoga o de hale malo, gai gilaadeu alodahi ga hiihidi mai ga duuduli ga daumaha i gaogao haitoga o olaadeu hale malo. ");
INSERT INTO nkr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Deenei hugadoo de hai o Tagi Maolunga e huli ange ai ga madaangudu ange gi Moses, bei dagodo o dahi hai soa. Gai de masavaa naa huu o Moses e ahe mai ai gi de mommee nnoho gaainga, gai Joshua, tama daane a Nun, de ia bale o Moses, gai e gauligi mai ange, e dee hano gee donu i de hale malo laa. ");
INSERT INTO nkr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Gai Moses ga hai ange gi Tagi Maolunga, “Koe ne hai mai au gi gaamai de huaadangada nei, aagai koe tigi tala mai donu be goai aau e hai gi hano madali au. Gai koe gu hai mai hogi, ‘Au e iloo oo dagodo ma de malangilangi i de goe.’ ");
INSERT INTO nkr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Deenei ai, au e dangidangi adu, noo koe e malangilangi i de au, gai koe hagaagona mai oo haiava, gi iloo ai e au goe gai gi malangilangi ai goe i de au. Koe gi manadua bolo de huaahenua nei go oo dangada donu.” ");
INSERT INTO nkr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Gai Tagi Maolunga ga hai ange, “Au e hano donu madali goe, gai au e gaavadu naa gi de goe de noho baba.” ");
INSERT INTO nkr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Gai Moses ga hai ange gi de ia, “Noo koe e dee hano madali au, gai koe gi dee haia gimaadeu gi hulo gee mai i kinei. ");
INSERT INTO nkr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Gai dee hee ai naa de hai a dangada e iloo ai bolo koe e malangilangi i de au, go gimaadeu ma doo huaadangada? E aha, e dee go doo hano madali gimaadeu e haia ga dagodo gee gimaadeu, go au ma oo dangada, mai i denga huaadangada ange laa i henua i lalo?” ");
INSERT INTO nkr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Gai Tagi Maolunga ga hai ange gi Moses, “Au e hai donu gi bei de mee oou gu dangidangi mai ai; go hiidinga au e malangilangi i de goe, gai au e iloo oo dagodo.” ");
INSERT INTO nkr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Gai Moses ga hai ange, “Au e dangidangi adu, koe gi hagaagona mai gi de au doo mahamaha!” ");
INSERT INTO nkr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Gai Tagi Maolunga ga hai ange, “Au e hai naa ogu dagodo danuaa alodahi gi hano i oo mada i mua, gai au e tala naa dogu ingoo, go Iahweh; au e abodonu ange gi gilaadeu oogu e lodo abodonu ange aagena, gai e lodo aloha ange gi gilaadeu oogu e lodo e aloha ange aagena.”  ");
INSERT INTO nkr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Gai ia e hai ange hogi, “Koe e dee maua i de tilo luoogu mada; go hiidinga e deai donu se dangada e gidee au e maua gi mouli!” ");
INSERT INTO nkr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Gai Tagi Maolunga ga hai ange, “Tilo, e dahi mommee i ogu gaogao oou e maua i de duu ai i honga dahi hadu, ");
INSERT INTO nkr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","gai de masavaa naa huu o dogu mahamaha e hanadu ai laa oo gaogao, gai au ga hagaduu ange goe gi magavaa o denga hadu, ga haoli goe i dogu lima ga dae ai gi dogu ui gee. ");
INSERT INTO nkr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Gai au ga aau dogu lima, gai koe e gidee naa dogu dua; aagai e deai donu e maua gi gidee luoogu mada.” ");
INSERT INTO nkr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Gai Tagi Maolunga ga hai ange gi Moses, “Daadaa ina e lua duu hadu bei luu duu hadu aagu ne hai i taamada, gai au ga sisi ange muna aagu ne sisi ange gi honga luu duu hadu i taamada aau ne oha laa. ");
INSERT INTO nkr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Gai haia gi baba oo mee i taiao age, ma gi hanage gi honga de mounga go Sinai, ga duu i ulu de mounga. ");
INSERT INTO nkr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gai e deai ange donu se dangada e humai madali goe, e deai hogi se dangada e nnoho saele laa honga de mounga alodahi; e deai hogi ssiibi be ni kaau e dugu gi gaimee saele i gaogao de mounga.” ");
INSERT INTO nkr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Gai Moses ga daadaa e lua duu hadu bei luu duu hadu i taamada; gai ia ga oho age i taiao ga hanage gi honga de mounga go Sinai, bei de hai a Tagi Maolunga gu tala ange ai gi de ia, ga dagidagi luu duu hadu laa ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Gai Tagi Maolunga ga hano iho i lo te duludulu hagausinga ga duu madali Moses i honga de mounga, gai ia ga hagailoo dono ingoo go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Gai Tagi Maolunga ne hano gi mada i mua o Moses, ga hagadaba, “Tagi Maolunga, Tagi Maolunga, de Maadua e lodo aloha ma de degi, e dee moolau de lili, gai e honu i de aloha aama de hai hegau i de muna abodonu, ");
INSERT INTO nkr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","gai ia e dee helui naa donu dono abodonu ange gi dangada i denga atangada soa, ma de degi ange gi olaadeu baubau, ma olaadeu lodo dee heohi aama haisala. Aagai ia e dee degi ange naa donu gi alaadeu hegau baubau; ia e hagaduasala naa denga dama aama mogobuna i hiidinga baubau o olaadeu maadua, ga dae ai loo gi tolu ma de haa atangada.” ");
INSERT INTO nkr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Gai Moses ga hagamoolau ga ino luoono mada gi honga de gelegele ga daumaha. ");
INSERT INTO nkr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Gai ia ga hai ange, “Dogu Ia Aamua, noo koe e abodonu mai gi de au, gai au e dangidangi adu gi de goe, dogu Ia Aamua, koe gi humai madali gimaadeu. Ni muna abodonu gimaadeu ni dangada e makaga omaadeu lodo; aagai koe degi mai gi omaadeu baubau ma omaadeu haisala, mage haia gimaadeu go oo dangada donu.” ");
INSERT INTO nkr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Gai ia ne hai ange, “Tilo, au e hai dahi hagatoo donu hagaheloongoi madali goe. Au e hai naa denga mee hagalele mouli i madamada o doo huaadangada alodahi, ni mee tigi hai i mua i henua i lalo alodahi, aabe gu hai i dahi huaahenua gee. Gai denga huaadangada alodahi oodou e hulo e nnoho i olaadeu magavaa, e gidee naa hegau hagalele mouli a Tagi Maolunga e hai; go hiidinga se hegau hagamaatagu mmao aagu gu dai hai i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Gai goodou kana ange hagallongo ange gi muna aagu gu tala adu gi goodou anailaa nei. Tilo, au e hai naa gi hulo gee de gau Amor, ma de gau Canaan, ma de gau Heth, ma de gau Perez, ma de gau Hiv, aama de gau Jebus. ");
INSERT INTO nkr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Gai goodou kana ange diiloo gi dee haia e goodou dahi hagatoo donu hagaheloongoi madali dangada e nnoho i de henua oodou gu dai hulo naa aagena, gi dee noodia ai goodou i mee nei bei dagodo o ssele. ");
INSERT INTO nkr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Goodou oha ina olaadeu mommee o ssigidaumaha, ma olaadeu duludulu hadu aama de duuduu iho denga duludulu laagau o Asherah, ");
INSERT INTO nkr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","go hiidinga koe e dee daumaha ange donu gi dahi diinonga gee; i hiidinga Tagi Maolunga, dono ingoo laa go de Maagoda, se Maadua maagoda. ");
INSERT INTO nkr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Gai goodou dagidiiloo gi dee haia e goodou dahi hagatoo donu hagaheloongoi, madali dangada o de henua nei, go hiidinga de masavaa naa huu alaadeu e hai ai denga dahulinga baubau, i delaadeu sigidaumaha ange gi olaadeu diinonga, gai gilaadeu ga gauna adu goodou, gai goodou ga hulo hogi, ga gai mee gu sigidaumaha ange gi olaadeu diinonga; ");
INSERT INTO nkr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","gai goodou e kave naa hogi alaadeu damaa hine ga hagahai bodu ange gi oodou dama daane, gai alaadeu damaa hine ga hai denga dahulinga baubau i delaadeu daumaha ange gi olaadeu diinonga, gai gilaadeu ga hai oodou dama daane gi daumaha ange gi olaadeu diinonga. ");
INSERT INTO nkr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Aude haia hanu diinonga baalanga gi daumaha ange aagena. ");
INSERT INTO nkr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Goodou dao ina Taonga o Pelaoaa Dee Hagahua. E hidu laangi oodou e gai ai pelaoaa dee hagahua, bei dagu hai gu tala adu ai gi goodou, i de masavaa gu hagailonga laa i de malama go Abib; i hiidinga go de malama nei oodou ne ssao mai i Egypt. ");
INSERT INTO nkr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Denga dama daane madua alodahi ma manu daane alodahi a oodou manu haangai bei kaau, ma ssiibi aama guudi e haanau laa i taamada niiagu. ");
INSERT INTO nkr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tama i mua a dahi donkey e hagahesuihagi i dahi ssiibi; aagai noo goodou e dee hagahesuihagi, gai goodou e hhadi dono ua. Gai goodou e hagahesuihagi donu oodou dama daane maatua. Gai e deai donu se goodou e ngadi humai gi mada luoogu mada. ");
INSERT INTO nkr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","E ono oodou laangi e hai ai oodou hegau, aagai de hidu laangi goodou hagammabu; goodou e hagammabu donu hogi i de masavaa o de hagabalabala de gelegele ma de masavaa o de hagihagi. ");
INSERT INTO nkr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Gai goodou dao ina Taonga o Denga Uvigi, i de masavaa e hagihagi ai denga grain i taamada, ma Taonga o de Hagabudu i de hagaodi o de ngadau. ");
INSERT INTO nkr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","E dolu hanonga i de ngadau o denga daane alodahi e loomai ai gi mada luu mada o de Ia Aamua go Iahweh, de Maadua o Israel. ");
INSERT INTO nkr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Au e hai naa gi hulo gee denga huaahenua mai i oodou mada i mua, ma de hagalaumalie doodou mommee; gai e deai naa donu dangada e nnoo ange gi oodou gelegele, i de masavaa oodou e loomai ai gi mada luu mada o Tagi Maolunga doodou Maadua, i e dolu hanonga i de ngadau. ");
INSERT INTO nkr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Aude haia dahi sigidaumaha i dodo madali pelaoaa hagahua. Gai goodou e dee dugu hogi hanu mee o ssigidaumaha o Taonga Hagasili gi doe gi taiao age. ");
INSERT INTO nkr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Koe gi gaamai gi de hale o Tagi Maolunga doodou Maadua, denga huamanu e hhua i taamada i honga doo gelegele. Aude duunaa dahi guudi gauligi i lodo vai uu o dono dinana.”  ");
INSERT INTO nkr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Gai Tagi Maolunga ga hai ange gi Moses, “Siia mage daohia muna nei, go hiidinga aanei muna o de hagatoo donu hagaheloongoi aagu gu hai madali goodou ma de gau Israel.” ");
INSERT INTO nkr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Gai Moses ne noho i daho Tagi Maolunga i kilaa i e madahaa laangi ma e madahaa boo; gai ia tee gaimee be ne unu. Gai ia ne sisi ange gi honga luu duu hadu laa muna o de hagatoo donu hagaheloongoi, go de Madaangahulu Hainga. ");
INSERT INTO nkr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Gai de masavaa huu o Moses ne ahe iho ai i de mounga go Sinai ma luu duu hadu o de tala hagadonu, gai ia tee iloo donu bolo luoono mada gu kona donu de maalama, i hiidinga ia nogo basa ange ai gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Gai de masavaa huu a Aaron ma de gau Israel ne gidee ai Moses, gai luoono mada gu kona donu de maalama, gai gilaadeu gu maatagu i de loomai e hagapaa ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Gai Moses ga hagahi dangada gi loomai gi ono daha; gai Aaron ma dagi alodahi o hagabuulingaa dangada o Israel ga aahe mai gi ono daha; gai Moses ga basa ange gi gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Muli mai gai de gau Israel alodahi ga loomai ga hagapaa mai gi ono daha, gai Moses ga tala ange gi gilaadeu mee alodahi a Tagi Maolunga gu tala ange gi de ia i honga de mounga go Sinai. ");
INSERT INTO nkr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Gai ga lava de basa ange o Moses gi dangada, gai ia ga haoli luoono mada i dahi malo. ");
INSERT INTO nkr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Aagai de masavaa naa huu o Moses e hano ai gi daho Tagi Maolunga e pasa ai gilaau, gai ia ga aau de malo laa ga dae ai gi dono ahe mai. Gai de masavaa naa huu oona e sao mai ai, gai ia ga tala ange gi de gau Israel muna gu tala ange gi de ia, ");
INSERT INTO nkr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","gai de gau Israel gu gidee bolo luu mada o Moses gu kona de maalama. Aagai Moses ga hagaahe ange de malo laa ga haoli ai luoono mada, ga dae ai gi dono ahe e pasa gilaau ma Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Gai Moses ga hagabuni de hagabuulingaa dangada o Israel, ga hai ange gi gilaadeu, “Aanei muna Tagi Maolunga gu tala adu goodou gi haia. ");
INSERT INTO nkr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","E ono laangi e hai ai oodou hegau, aagai de hidu laangi se Sabbath dabu, se laangi hagammabu gu hagadabu ange gi Tagi Maolunga; gai be goai naa huu e haia ai hanu hegau, gai ia e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Goodou aude dahu ina hanu ahi i oodou mommee nnoho i de laangi o Sabbath.” ");
INSERT INTO nkr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Gai Moses ga basa ange gi de hagabuulingaa dangada o Israel, ga hai ange, “Aanei muna a Tagi Maolunga gu tala adu goodou gi haia. ");
INSERT INTO nkr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Goodou daohia age dahi sigidaumaha e gaavange gi Tagi Maolunga. Be goai e lodo malangilangi, gai ia gi gaamai dahi sigidaumaha gi Tagi Maolunga i goolo, ma selevaa, ma bronze; ");
INSERT INTO nkr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ma huga malo buluu, ma de purple ma de mmea ma linen danuaa, ma huluhulu guudi, ");
INSERT INTO nkr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ma gili ssiibi daane gu tao ma gu mmea, ma gili kaau lausedi, ma laagau acacia, ");
INSERT INTO nkr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ma lolo e haula ai laama, ma mee hagamanongi e hai ai de lolo hagadabu, ma mee maanongi, ");
INSERT INTO nkr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ma denga hadu hagamogomogo go onyx, ma hadu hagamogomogo e hagabigibigi ange gi de ephod, ma honga de mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Gai denga labagau alodahi i oodou magavaa gi loomai gi haia mee alodahi a Tagi Maolunga gu tala adu goodou gi haia: ");
INSERT INTO nkr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","go de tabernacle, ma de hale malo, ma malo e odo ai, ma ono mee hagalaulau, ma ono laagau, ma ono laagau hagamakaga, ma ono duludulu ma olaadeu dagelo; ");
INSERT INTO nkr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ma de ngavesi ma luu dogo e saabai ai, ma de pono o de tala haisala, ma de malo buibui; ");
INSERT INTO nkr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ma teebele ma luu dogo e saabai ai, ma ono goloa alodahi, ma pelaoaa i Mada Luoono Mada, ");
INSERT INTO nkr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ma de mee dugu laama, ma ono goloa ma ono laama ma lolo e haula ai denga laama; ");
INSERT INTO nkr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ma de mommee o ssigidaumaha o mee maanongi, ma luu dogo e saabai ai, ma de lolo hagadabu, ma mee maanongi, ma de malo e buibui ai de haitoga o de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ma de mommee o ssigidaumaha dudu, ma dono gaini e hai laa i bronze, ma luoono dogo e saabai ai, ma ono goloa alodahi, ma taaba ma dono dagelo; ");
INSERT INTO nkr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ma malo e dau i luu baasi de buibui o de hale malo, ma denga duludulu ma olaadeu dagelo, ma de malo e dau i ma te haitoga o de buibui laa daha; ");
INSERT INTO nkr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ma baalanga e velo ai e daohi de buibui laa daha ma de tabernacle, ma olaadeu daula; ");
INSERT INTO nkr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ma denga malo mahamaha e hai ai hegau i lo te Aabi Dabu, go malo dabu o tangada haimeedabu go Aaron, ma malo o ana dama daane e hai ai hegau a de gau haimeedabu.” ");
INSERT INTO nkr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Gai de hagabuulingaa dangada o Israel alodahi ga hulo gee mai i daho Moses ga ahe gi olaadeu mommee. ");
INSERT INTO nkr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Gai dangada alodahi ne llodo ma gilaadeu ne lodo malangilangi, ga loomai ga gaamai gi Tagi Maolunga alaadeu mee ne daohi age, e hai ai de hale malo hagabuni, ma ono hai hegau alodahi, aama denga malo dabu. ");
INSERT INTO nkr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Gai denga haahine ma daane alodahi ne malangilangi laa ga gaamai denga biini hagalaagii, ma hakai dalinga ma buulei, ma buulei gubu lima, aama denga hagadaagangaa goloa alodahi e hai i goolo; dahi ma dahi ne gaamai ana goolo e hai ai sigidaumaha daodaohi age ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Gai dangada alodahi e hanu alaadeu huga malo buluu, ma de purple, ma de mmea be ni linen danuaa, be ni huluhulu guudi, be ni gili ssiibi gu tao ma gu mmea, aabe ni gili kaau lausedi ga gaamai mee nei. ");
INSERT INTO nkr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Gai dangada alodahi e maua i de daohi age hanu selevaa be ni bronze ne hai hogi dahi sigidaumaha i mee nei ga gaavange gi Tagi Maolunga. Gai dangada alodahi e hanu alaadeu laagau acacia e hai ai de hegau ne gaamai hogi dahi sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Gai denga haahine alodahi e labagau i de amu ga hilo, ne gaamai hogi alaadeu huga malo buluu ma de purple, ma de mmea, aama linen danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Gai denga haahine alodahi ne lodo malangilangi gai e labagau ne amu ga hilo huluhulu o denga guudi. ");
INSERT INTO nkr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Gai denga dagi ne gaamai denga hadu onyx, ma hadu hagamogomogo e hagabigibigi ange gi de ephod ma de mee dau i hadahada, ");
INSERT INTO nkr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ma mee hagamanongi, ma lolo e haula ai laama, ma de lolo hagadabu, ma mee maanongi. ");
INSERT INTO nkr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Gai denga daane ma haahine alodahi o Israel ne malangilangi laa i de daohi age mee e hai ai hegau a Tagi Maolunga, ne gaamai mee e hai ai de hegau a Tagi Maolunga gu tala ange laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Gai Moses ga hai ange gi de gau Israel, “Tagi Maolunga gu hili ange Bezalel tama daane a Uri, tama daane a Hur, mai i de aamuli o Judah; ");
INSERT INTO nkr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","gai ia ne hhao ia i de Hagasaalunga o de Maadua, ma de labagau, ma de heiangi, ma de iloo mee, aama denga hagadaagangaa hegau alodahi a de labagau e hai laa. ");
INSERT INTO nkr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Gai ia ga hai ai denga hagadaagangaa mee i goolo ma selevaa ma bronze, ");
INSERT INTO nkr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ma de duuduu denga hadu hagamogomogo e hagatau, ma de daadaa denga laagau, aama de hai denga hagadaagangaa hegau o de labagau. ");
INSERT INTO nkr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Gai Tagi Maolunga ne hai gilaau ma Oholiab, tama daane a Ahisamak, mai i de aamuli o Dan, gi maua i de agoago ange dangada i alaau mee e iloo. ");
INSERT INTO nkr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Gai ia ne gaavange gi gilaau de hina e hai ai denga hagadaagangaa hegau alodahi a de labagau, ma de hadu age denga hagadaagangaa mee, ma de maaga mee i huga malo buluu, ma de purple ma de mmea, ma linen danuaa, ma de langa mee, aama denga hagadaagangaa labagau alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bezalel, ma Oholiab aama denga labagau alodahi a Tagi Maolunga gu gaavange aagena de hina ma de heiangi, e hai ai denga hagadaagangaa hegau alodahi e hagaduu age ai de mommee dabu, bei de hai a Tagi Maolunga gu tala ange ai.” ");
INSERT INTO nkr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Gai Moses ga hagahi Bezalel ma Oholiab aama denga labagau alodahi a Tagi Maolunga gu gaavange laa aagena de hina, gai ne lodo malangilangi i de bale de hegau gi loomai gi haia de hegau. ");
INSERT INTO nkr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Gai gilaadeu ga kave mai i daho Moses sigidaumaha alodahi a de gau Israel gu daohi age e hagaduu ai de mommee dabu. Aagai dangada goi duudagi huu de gaamai gi Moses alaadeu mee ngadi gaavange i daiao alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Gai denga labagau alodahi e haia denga hagadaagangaa hegau o de mommee dabu, ne dugu alaadeu hegau gai ga loomai, ");
INSERT INTO nkr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ga hai ange gi Moses, “Mee a dangada gu gaamai gu dubu ange donu i mee e hai ai de hegau a Tagi Maolunga gu tala mai gidaadeu gi haia.” ");
INSERT INTO nkr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Gai Moses ne hai dahi hagailoo ga adi ange gi dangada alodahi i de mommee nnoho gaainga, ga hai ange: “Gu lava mee a denga daane ma haahine alodahi e daohia age ange hanu mee e hai ai dana ssigidaumaha ange gi de mommee dabu.” Gai dangada ne tuu de gaamai alaadeu mee daohi age, ");
INSERT INTO nkr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","go hiidinga denga mee gu daakodo gu tubu donu i de hai ai hegau alodahi, gai e hanu naa donu e doe. ");
INSERT INTO nkr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Gai labagau alodahi i magavaa o dangada ne hai de tabernacle i e madaangahulu malo buibui; malo nei ne hai i linen danuaa e amu ga hilo, i huga malo buluu, ma de purple ma de mmea, ga hagalaagii i denga cherubim. ");
INSERT INTO nkr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dahi malo buibui laa se madalua ma valu sugilima de looloa, gai se haa sugilima de lahalaha; gai denga malo buibui alodahi se haidenga daudahi donu huu. ");
INSERT INTO nkr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Gai ia ne hagapuni e lima malo buibui laa i gilaadeu, gai e bei ai hogi denga malo buibui e lima ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ia ne hai hogi hanu mee hagalaulau buluu i de baasi o de malo e mua gi daha i dahi hagabuulingaa malo laa; gai e bei ai hogi de hagabuulingaa malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ia ne hai e dagimadalima mee hagalaulau i de baasi o dahi luu hagabuulingaa malo laa, gai e madalima hogi mee hagalaulau i de hagabuulingaa malo ange laa; denga mee hagalaulau laa e hagadau ssoe ange. ");
INSERT INTO nkr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ia ne hai hogi e madalima biini goolo ga biini ai e dagidahi mee hagalaulau mai i luu hagabuulingaa malo laa, gi buni ai alodahi de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ia ne hai hogi hanu malo i huluhulu guudi e odo ai de tabernacle; gai ne madaangahulu ma dahi malo aana ne hai. ");
INSERT INTO nkr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Gai dahi malo laa se matolu sugilima de looloa, gai e haa sugilima de lahalaha; denga malo e madaangahulu ma dahi laa se haidenga daudahi. ");
INSERT INTO nkr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ia ne hagapuni e lima malo buibui laa i gilaadeu, gai malo e ono ange laa i gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Gai ia ne hai e madalima mee hagalaulau i de baasi o dahi luu hagabuulingaa malo laa, gai e madalima mee hagalaulau i de hagabuulingaa malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Gai ia ne hai hogi e madalima biini bronze e biini ai denga mee hagalaulau laa, gi buni luu hagabuulingaa malo laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Gai ia ne hai ange hogi dahi malo i gili ssiibi ga tao gu mmea, aama dahi malo i gili kaau lausedi e haoli iho ai laa honga malo ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Gai ia ne hai denga laagau o de tabernacle i laagau acacia ga hagatuu age. ");
INSERT INTO nkr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dahi laagau laa se madaangahulu sugilima de looloa, gai se dahi ma de baasi sugilima de lahalaha. ");
INSERT INTO nkr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Dahi laagau laa e lua ono hakauanga, e hagadau hagamakaga ai denga laagau. Gai ia ne hai denga laagau alodahi o de tabernacle bee nei. ");
INSERT INTO nkr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Gai ia ne hai e madalua laagau ange gi de baasi gi ngaage o de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","gai e madahaa dagelo selevaa e hagatuu ange aagena denga laagau e madalua: e dahi laagau e lua ono dagelo ma e lua hakauanga, gai e lua hogi dagelo i lalo denga laagau ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ia ne hai hogi e madalua laagau i de baasi gi ngaiho o de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ma e madahaa dagelo selevaa: e dagilua dagelo i lalo dahi laagau, gai e lua hogi dagelo i lalo denga laagau ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Gai ia ne hai e ono laagau ange gi de bido gi tua o de tabernacle, go de bido gi dai. ");
INSERT INTO nkr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Gai ia ne hai e dagilua laagau i luu dege o de tabernacle i de bido gi tua. ");
INSERT INTO nkr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Gai luu laagau nei e madoha i bido i lalo, aagai olaau ulu e ulumagi ange gi tahi buulei; gai luu dege nei se dagodo daudahi. ");
INSERT INTO nkr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Gai e valu alodahi laagau laa ma e madaangahulu ma ono dagelo selevaa; e dagilua dagelo selevaa e hagaduu ange ai dahi laagau. ");
INSERT INTO nkr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ia ne hai hogi hanu laagau hagamakaga i laagau acacia; e lima ange gi denga laagau i dahi baasi o de tabernacle; ");
INSERT INTO nkr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","e lima laagau hagamakaga i de baasi ange laa, gai e lima hogi laagau hagamakaga i de bido gi dai o de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Gai ia ne hai de laagau hagamakaga i lo te ungaalodo o denga laagau ga velo gi sula i luu bido ngaadahi. ");
INSERT INTO nkr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Gai ia ne haoli denga laagau i goolo, ma de hai olaadeu buulei i goolo e daohi ai denga laagau hagamakaga laa. Ia ne haoli hogi denga laagau hagamakaga i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Gai ia ne hai dahi malo buibui i huga malo buluu, ma de purple, ma de mmea aama linen danuaa e amu ga hilo, ga maaga ange aagena denga cherubim. ");
INSERT INTO nkr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Gai ia ne hai e haa duludulu i laagau acacia ga haoli i goolo. Gai ia ne hai hanu mee hagalaulau goolo, ma olaadeu dagelo selevaa e haa. ");
INSERT INTO nkr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Gai ia ne hai de malo buibui e dau i de haitoga o de hale malo i huga malo buluu, ma de purple ma de mmea aama linen danuaa e amu ga hilo, ga maaga i de niila, ");
INSERT INTO nkr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ma de hai e lima duludulu madali mee hagalaulau e dau age ai. Gai ia ga haoli ulu o denga duludulu laa ma olaadeu mee hagalaulau i goolo, gai olaadeu dagelo e lima e hai i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Gai Bezalel ga hagaduu de ngavesi o de hagatoo donu hagaheloongoi i laagau acacia; de looloa se lua sugilima ma de bido, de lahalaha se dahi ma de baasi sugilima, gai dono duuduu se dahi ma de baasi sugilima. ");
INSERT INTO nkr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Gai ia ne haoli tua ma lodo i goolo danuaa, ga hagadagodo dahi dolodolo goolo ga holiage ai. ");
INSERT INTO nkr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Gai ia ne hagadaakodo e haa buulei goolo ga hagabigibigi ange gi denga vae e haa laa; e dagilua buulei i luu baasi ngaadahi. ");
INSERT INTO nkr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Gai ia ne hai e lua dogo acacia ga haoli i goolo, ");
INSERT INTO nkr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ga velo ange gi lodo buulei i luu baasi o de ngavesi e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Gai ia ne hai de pono o de tala haisala i goolo danuaa; se lua sugilima ma de bido de looloa, gai e dahi sugilima ma de baasi de lahalaha. ");
INSERT INTO nkr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ia ne tugi hanu goolo i de haamaa ga hai ai e lua cherubim i luu bido o de pono laa, ");
INSERT INTO nkr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","dahi cherub i honga dahi bido, gai e dahi i honga de bido ange laa. Gai ia ne hai luu cherubim i luu bido laa gi buni donu huu ma de pono. ");
INSERT INTO nkr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Gai luu cherubim laa gi hagadau huuhuli ange, gai olaau bakau e doha i honga de pono, gai olaau mada gi huuhuli iho gi honga de pono laa. ");
INSERT INTO nkr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ia ne hagaduu hogi dahi deebele i laagau acacia; se lua sugilima de looloa, se dahi sugilima de lahalaha, gai se dahi ma de baasi sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Gai ia ne haoli teebele nei i goolo danuaa ga hagadagodo dahi dolodolo goolo ga holiage ai. ");
INSERT INTO nkr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Gai ia ne hai hogi dahi dolodolo i luu baasi, gai se dolu inisi de lahalaha; gai ne haoli tolodolo nei i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Gai ia ne hagadaakodo e haa buulei goolo, ga hagabigibigi ange gi denga dege e haa i honga vae e haa o teebele laa. ");
INSERT INTO nkr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gai ia ne hagamakaga ange denga buulei nei gi paa ange gi de hiihii, e velo ange aagena denga dogo e saabai ai teebele. ");
INSERT INTO nkr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ia ne hai hogi denga dogo e saabai ai teebele i laagau acacia, ga haoli i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Gai ia ne hai goloa alodahi o honga teebele i goolo danuaa; go denga gumedi, ma anibada, ma boolo, aama denga ssaa e llingia ai denga sigidaumaha o mee unu. ");
INSERT INTO nkr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Gai ia ne hai hogi dahi mee dugu laama i goolo danuaa. Ia ne hai de haamaa ga dugidugi ai mee e hai ai de mee dugu laama. Dono dahido, ma de angaanga, ma ono ubu, ma ono gau, ma ono huaala e buni ma de angaanga. ");
INSERT INTO nkr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Gai de mee dugu laama e hai gi ono laa; e dolu i dahi baasi gai e dolu i de baasi ange laa. ");
INSERT INTO nkr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Gai e dolu ubu bei huaala o de almond, madali de gau aama de huaala i dahi laa; gai e dolu hogi ubu i de baasi ange laa. Denga laa e ono e tuu mai laa i luu baasi de mee dugu laama e hai gi dagodo daudahi. ");
INSERT INTO nkr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Gai honga de mee dugu laama iai e haa ubu bei huaala o de almond madali olaadeu gau ma huaala, ");
INSERT INTO nkr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","gai e dagidahi gau i daahido o denga laa o de mee dugu laama; e dahi gau i lalo luu laa e mmua gi lunga, e dahi i lalo luu laa i lo te ungaalodo, gai e dahi i lalo luu laa e mmua gi lalo — e ono laa i de mee dugu laama. ");
INSERT INTO nkr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Denga gau ma denga laa ne hai gi buni ma de angaanga, gai de laama alodahi ne hai i goolo danuaa ne dugidugi i de haamaa. ");
INSERT INTO nkr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Gai ia ne hai e hidu laama, ma mee diinei ai laama ma mee hao lehu i goolo danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Gai ne hai de mee dugu laama madali ono goloa alodahi i e dahi talent goolo danuaa. ");
INSERT INTO nkr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Gai ia ne hai de mommee o ssigidaumaha o mee maanongi i laagau acacia gi tuu dege; de looloa ma de lahalaha se dahi sugilima, gai dono duuduu se lua sugilima. Gai ono hanga e buni donu huu ma de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Gai ia ne haoli ono elunga ma denga baasi, aama ono hanga i goolo danuaa. Gai ia ne hai hogi dahi dolodolo goolo i luu baasi ga holiage ai, ");
INSERT INTO nkr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ma de hagadaakodo e lua buulei goolo, ga hagabigibigi ange gi lalo tolodolo i luu baasi, e velo ange aagena luu dogo e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Gai ia ne hai luu dogo e saabai ai i laagau acacia, ga haoli i goolo. ");
INSERT INTO nkr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Gai ia ne hai hogi de lolo hagasulu dabu ma mee hagamanongi e hai ai ssigidaumaha, bei vai maanongi a de labagau e hai laa. ");
INSERT INTO nkr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Gai ia ne hagaduu de mommee o ssigidaumaha dudu i laagau acacia, ga hai gi tuu dege; e lima sugilima de looloa, e lima sugilima de lahalaha, gai e dolu sugilima tuuduu. ");
INSERT INTO nkr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Gai ia ne hai denga hanga i honga denga dege e haa e buni ma de angaanga o de mommee o ssigidaumaha, gai ia ga haoli de mommee o ssigidaumaha i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ia ne hai goloa alodahi o de mommee o ssigidaumaha dudu: go denga anibada, ma savolo, ma beisini, ma poogo, aama denga mee e hhao ai denga maga ahi. Ia ne hai mee nei alodahi i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Gai ia ne hai dahi gaini i bronze ga hagapigi ange gi lalo de hiihii, ga hai gi dae iho gi lo te ungaalodo o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Gai ia ne hai e haa buulei e hagabigibigi ange gi honga dege e haa o de gaini bronze laa e velo ange aagena laagau e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ia ne hai hogi e lua dogo i laagau acacia, ga haoli i bronze. ");
INSERT INTO nkr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Gai ia ne velo ange luu dogo laa, gi lodo buulei i luu baasi de mommee o ssigidaumaha dudu e saabai ai. Ia ne hagaduu hogi de mommee o ssigidaumaha dudu i de baabaa, ga hai gi avaava ono lodo. ");
INSERT INTO nkr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Gai ia ne hai taaba bronze ma dono dagelo i galaasa dilodilo a denga haahine hai hegau i de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Gai ia ne hai dahi buibui i luu baasi de tabernacle. Denga malo e dau i de bido gi ngaage ne hai i linen danuaa e amu ga hilo, gai se lau sugilima de looloa, ");
INSERT INTO nkr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","gai e madalua ono duludulu ma e madalua dagelo bronze; gai mee hagalaulau ma mee ulumagi i ulu denga duludulu laa ni selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Gai de baasi gi ngaiho e lau hogi sugilima de looloa, gai e madalua hogi ono duludulu ma e madalua dagelo bronze; gai denga mee hagalaulau ma mee e ulumagi i ulu denga duludulu laa ni selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Gai de bido gi dai se madalima sugilima de looloa, gai e madaangahulu ono duludulu ma e madaangahulu dagelo; gai mee hagalaulau o denga duludulu ma mee e ulumagi i ulu denga duludulu laa ni selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Gai de bido gi dua iai laa de haitoga, se madalima hogi sugilima. ");
INSERT INTO nkr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Gai denga malo e dau i dahi baasi de haitoga se madaangahulu ma lima sugilima, madali e dolu duludulu ma e dolu dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Gai de malo e dau i de baasi ange laa o de haitoga se madaangahulu ma lima sugilima, madali e dolu duludulu ma e dolu dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Denga malo alodahi e dau i de buibui laa daha ni linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Gai dagelo o denga duludulu alodahi ne hai i bronze, aagai denga mee hagalaulau ma mee e ulumagi ange gi ulu o denga duludulu ne hai i selevaa, gai mee e haoli ai ulu o denga duludulu ni selevaa. Gai duludulu alodahi i luu baasi de buibui laa daha e ulumagi ange gi ulu denga mee e hai i selevaa. ");
INSERT INTO nkr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Gai de malo e dau i ma te haitoga o de buibui laa daha e buluu, ma de purple, ma de mmea aama linen danuaa e amu ga hilo ga maaga i de niila. Se madalua sugilima de looloa, gai e lima sugilima de maolunga, bei de malo buibui i luu baasi de buibui laa daha. ");
INSERT INTO nkr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Gai e haa ono duludulu ma e haa dagelo bronze. Gai denga mee hagalaulau ma mee ulumagi i ulu denga duludulu ni selevaa, gai ulu o denga duludulu ni selevaa hogi. ");
INSERT INTO nkr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Gai denga laagau alodahi e daohi ai de tabernacle ma de buibui i luu baasi ni bronze. ");
INSERT INTO nkr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Deenei de hagaoanga o mee ne hagaduu ai de tabernacle, go de tabernacle o de Tala Hagadonu, go mee a Moses ne tala ange gi denga daane o Levi gi siia gi daohia, i lalo o delaadeu dagi go Ithamar, tama daane a Aaron, tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Gai Bezalel tama daane a Uri, tama daane a Hur, mai i de aamuli o Judah, ne hai mee alodahi a Tagi Maolunga gu tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Gai taane ne balea ange ia go Oholiab, tama daane a Ahisamak, mai i de aamuli o Dan, ia e labagau i de maaga mee, ma de hagatuu denga hagadaagangaa mee, ma de maaga mee i de niila i huga malo buluu, ma de purple ma de mmea aama linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Gai goolo alodahi ne hai ai de hegau, ma de hagaduu ai de mommee dabu, aama goolo alodahi o ssigidaumaha daodaohia age se madalua ma siva talent ma e 730 shekel; gai ne hagabau i de hagabaaunga o shekel o de mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Gai selevaa mai i daho de hagabuulingaa dangada se lau talent ma e 1,775 shekel, gai ne hagabau i de hagabaaunga o shekel o de mommee dabu — ");
INSERT INTO nkr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","dahi daane e dahi ana beka bei de hagabaaunga o shekel o de mommee dabu, gai denga daane alodahi gu dau i taunga, mai i de madalua ngadau ga hanage ai se 603,550 alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Gai se lau talent selevaa ne hagadaakodo ai denga dagelo o de mommee dabu ma de malo buibui daballahi — se lau talent ne hai ai e lau dagelo, e dahi talent ne hai ai dahi dagelo. ");
INSERT INTO nkr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Gai ia ne hai e 1,775 shekel ga hai ai mee hagalaulau o denga duludulu, ma de haoli ai ulu o denga duludulu, aama de hai ai mee e ulumagi ange gi ulu o denga duludulu. ");
INSERT INTO nkr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Gai denga bronze ne daodaohi age se madahidu talent ma e 2,400 shekel. ");
INSERT INTO nkr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Gai gilaadeu ne hai bronze nei ga hai ai dagelo o de haitoga o de hale malo hagabuni, ma de mommee o ssigidaumaha bronze, ma dono gaini, ma ono goloa alodahi, ");
INSERT INTO nkr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ma dagelo i luu baasi o de buibui laa daha, ma denga dagelo o de haitoga, ma baalanga alodahi e daohi ai de tabernacle aama de buibui laa daha. ");
INSERT INTO nkr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Gai gilaadeu ne hai denga huga malo buluu, ma de purple ma de mmea, ga hai ai malo mahamaha dabu e hai ai hegau i lo te Aabi Dabu, gai ne hai malo o Aaron bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Gai ia ne hai de ephod i goolo ma huga malo buluu, ma de purple, ma de mmea ma linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Gilaadeu ne tugi denga goolo gi daballahi ga hai ai denga deleisi ga llanga madali denga huga malo buluu ma de purple, ma de mmea, ma linen danuaa ga hai ai hanu sumu hagalaagii. ");
INSERT INTO nkr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Gai gilaadeu ne hai e lua beleesese e daudau ange aagena de ephod i luu dege. ");
INSERT INTO nkr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gai luu beleesese laa e llanga gi bei de mee nnoa ungaalodo laa, e nnoa ange ai gi de ephod, gai ne hai i goolo, ma huga malo buluu, ma de purple, ma de mmea, ma linen danuaa e amu ga hilo, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Gai gilaadeu ne hai denga hadu onyx ga hagabigibigi ange gi honga denga gaini goolo, ga maaga ange aagena ingoo o denga dama daane a Israel, bei de hai e maaga ai laa de buulei hagailonga. ");
INSERT INTO nkr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Gai ia ga hagabigibigi ange mee nei gi honga luu eu o de ephod e hagamaanadu ai de gau Israel, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Gai ia ne hai hogi de mee dau i hadahada gi hagalaagii, bei de hai ne hai ai de ephod. Ia ne hai i goolo, ma huga malo buluu, ma de purple ma de mmea, aama linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","De mee dau i hadahada e tuu dege, dono looloa ma dono lahalaha se dahi ianga, gai e hagapogo lua. ");
INSERT INTO nkr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gai gilaadeu ne hagabigibigi ange e haa hagataaunga hadu hagamogomogo. Tahi hagataaunga e dahi ruby, e dahi topaz, e dahi carbuncle; ");
INSERT INTO nkr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","de lua hagataaunga e dahi emerald, e dahi sapphire, e dahi diamond; ");
INSERT INTO nkr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","tolu hagataaunga e dahi jacinth, e dahi agate, e dahi amethyst; ");
INSERT INTO nkr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","gai de haa hagataaunga e dahi beryl, e dahi onyx, e dahi jasper. Hadu nei ne hagabigibigi ange gi honga denga gaini goolo. ");
INSERT INTO nkr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Gai denga hadu e madaangahulu ma lua nei e maaga ange aagena ingoo o denga aamuli o Israel e madaangahulu ma lua, bei de hai e maaga ai laa denga buulei hagailonga; dahi hadu e maaga ange ai de ingoo o dahi aamuli. ");
INSERT INTO nkr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Gai gilaadeu ne bini e lua seeini goolo danuaa e dau ai de mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Gilaadeu ne hai hogi e lua gaini goolo ma e lua buulei goolo ga hagamakaga ange luu buulei laa gi luu dege i de bido gi lunga o de mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Gilaadeu ne hagamakaga ange luu seeini goolo laa gi luu buulei i luu dege o de mee dau i hadahada; ");
INSERT INTO nkr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","gai bido gee o luu seeini laa gi hagabigibigi ange gi honga luu gaini goolo, ga hagamakaga ange gi honga luu eu o de ephod i mada i mua. ");
INSERT INTO nkr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Gai gilaadeu ne hai hogi e lua buulei goolo, ga hagabigibigi ange gi luu dege i de bido gi lalo o de mee dau i hadahada, i de baasi lodo i gaogao de ephod. ");
INSERT INTO nkr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Gai gilaadeu ne hai hogi e lua buulei goolo, ga hagabigibigi ange gi luu beleesese i de bido gi lalo i mada i mua o de ephod, i gaogao tuinga i honga de mee nnoa ungaalodo o de ephod. ");
INSERT INTO nkr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Gai gilaadeu ne nnoa ange luu buulei o de mee dau i hadahada gi luu buulei o de ephod i dahi duaini buluu, gi dagodo ai i honga de mee nnoa ungaalodo o de ephod, gai gi dee doo mai ai de mee dau i hadahada, bei de hai a Tagi Maolunga ne tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Gai gilaadeu ne hai de malo i lalo de ephod gi buluu alodahi — bei hegau a tangada langa mee — ");
INSERT INTO nkr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","gai e dahi haonga i de ulu o de malo laa, bei de mommee e hagaulu ange ai laa de biho, gai e dahi dalaa malo e dui i luu baasi de mommee mahuge laa gi dee madala mai. ");
INSERT INTO nkr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Gai gilaadeu ne hai hanu hua pomegranate i huga malo buluu, ma de purple, ma de mmea aama linen danuaa e amu ga hilo, ga hagabigibigi ange gi de bido i lalo o de malo laa daha. ");
INSERT INTO nkr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Gilaadeu ne hai hogi hanu baalanga vaaligiligi i goolo danuaa, ga haohao ai magavaa o denga pomegranate ga holiage ai de bido i lalo o de malo laa: ");
INSERT INTO nkr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","e dahi baalanga, e dahi pomegranate, e dahi baalanga, e dahi pomegranate, ga holiage ai de bido i lalo o de malo laa, e hai ai hegau, bei de hai a Tagi Maolunga ne tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Gilaadeu ne hai hogi hanu malo belee i linen danuaa e kahu ai Aaron ma ana dama daane, ");
INSERT INTO nkr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ma de goobai malo i linen danuaa, ma mee e noonooa ange gi olaadeu biho, aama olaadeu malo laa lodo i linen danuaa e amu ga hilo. ");
INSERT INTO nkr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Gai de mee e nnoa ai de ungaalodo ne hai i linen danuaa e amu ga hilo, ma huga malo buluu, ma de purple, ma de mmea, ga maaga i de niila, bei de hai a Tagi Maolunga ne tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Gai gilaadeu ne dugidugi dahi dibaa goolo danuaa ga hai ai de hau goolo dabu, ga maaga ange muna nei aagena, “Hagadabu ange gi Tagi Maolunga,” bei de hai e maaga ai laa de buulei hagailonga. ");
INSERT INTO nkr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Gai gilaadeu ga nnoa ange gi ma te goobai malo i dahi duaini buluu, bei de hai a Tagi Maolunga ne tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Gai hegau alodahi o de tabernacle, go de hale malo hagabuni, gu lava. Gai de gau Israel ne hai mee alodahi bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Gai gilaadeu ne gaamai goloa alodahi e hai ai de tabernacle gi Moses: go de hale malo ma ono goloa alodahi, ma ono mee hagalaulau, ma ono laagau, ma ono laagau hagamakaga, ma ono duludulu ma olaadeu dagelo; ");
INSERT INTO nkr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ma de malo e odo ai de hale ne hai i gili ssiibi ga tao gu mmea ma gili kaau lausedi, ma de malo buibui daballahi; ");
INSERT INTO nkr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ma de ngavesi o de tala hagadonu, ma ono laagau e saabai ai, ma de pono o de tala haisala; ");
INSERT INTO nkr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ma teebele ma ono goloa alodahi, ma denga pelaoaa i Mada Luoono Mada; ");
INSERT INTO nkr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ma de mee dugu laama goolo, ma ono laama, ma ono goloa alodahi ma lolo e haula ai denga laama; ");
INSERT INTO nkr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ma de mommee o ssigidaumaha goolo, ma de lolo hagadabu, ma mee maanongi, ma de malo e dau i ma te haitoga o de hale malo; ");
INSERT INTO nkr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ma de mommee o ssigidaumaha ne hai i bronze, ma dono gaini bronze, ma luoono laagau e saabai ai, ma ono goloa alodahi, ma taaba ma dono dagelo; ");
INSERT INTO nkr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ma malo e dau ai luu baasi de buibui laa daha, ma denga duludulu ma olaadeu dagelo, ma de malo e dau i ma te haitoga o de buibui laa daha, ma ono daula, ma baalanga e daohi ai, ma denga goloa alodahi e hai ai hegau o de tabernacle, go de hale malo hagabuni; ");
INSERT INTO nkr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ma malo mahamaha o de gau haimeedabu e hai ai alaadeu hegau i lo te Aabi Dabu, go denga malo dabu o tangada haimeedabu go Aaron ma malo o ana dama daane e hai ai hegau a de gau haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Gai de gau Israel ne hai denga hegau nei alodahi bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Gai Moses ga tilo huu denga hegau alodahi gu hai, gai ia gu gidee bolo gilaadeu ne hai mee alodahi gi bei muna a Tagi Maolunga. Gai Moses ne hagamanuuia gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tahi laangi naa huu o tahi malama gai koe ga hagaduu age de tabernacle, go de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Gai koe ga hhao de ngavesi o de tala hagadonu ga dugu ange gi dono mommee, ga dau age de malo buibui ga buibui ai. ");
INSERT INTO nkr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Gai koe ga gaamai teebele ga hagatau ange mee gi ono elunga. Gai koe ga gaamai de mee dugu laama, ga dugu ange denga laama gi olaadeu duulanga. ");
INSERT INTO nkr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Gai koe ga gaamai hogi de mommee o ssigidaumaha goolo o mee maanongi ga hagaduu i mada i mua o de ngavesi o de tala hagadonu, ma de dau age de malo buibui ga pono ai de haitoga o de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hagaduulia de mommee o ssigidaumaha dudu i ma te haitoga o de tabernacle, go de hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ga gaamai taaba hagagilimalali ga dugu i magavaa o de hale malo hagabuni ma de mommee o ssigidaumaha dudu ga hhao i vai. ");
INSERT INTO nkr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Gai koe ga dau age denga malo buibui i luu baasi de buibui laa daha, ga dau age de malo buibui i ma te haitoga o de buibui laa daha. ");
INSERT INTO nkr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Gai koe ga hai de lolo hagasulu ga hagasulu ai de tabernacle ma mee alodahi i ono lodo, ga hagadabu ai mee alodahi, gi dabu ai mee alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Gai koe ga hagasulu de mommee o ssigidaumaha dudu ma ono goloa alodahi ga hai gi dabu, gi dabu mmao ai de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Hagasulu ina hogi taaba hagagilimalali ma dono dagelo, ga hai gi dabu. ");
INSERT INTO nkr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Gai koe ga gaamai Aaron ma ana dama daane gi de haitoga o de hale malo hagabuni ga hagagilimalali ai gilaadeu i vai, ");
INSERT INTO nkr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","gai koe ga hakahu ange Aaron i denga malo dabu, ga hagasulu ma de hagadabu ia, gi se dangada haimeedabu e hai hegau mai ai gi de au. ");
INSERT INTO nkr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Gai koe ga gaamai hogi ana dama daane ga hakahu ange gilaadeu i malo belee, ");
INSERT INTO nkr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ga hagadabu gilaadeu i de lolo bei dau hai ne hagadabu ai delaadeu damana, e hai hegau mai gi de au i hegau a de gau haimeedabu. Gai delaadeu hagadabu i de lolo ange gi hegau o tangada haimeedabu e duudagi naa donu huu i denga atangada alodahi e hano ai.” ");
INSERT INTO nkr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Gai Moses ne hai ga bei muna alodahi a Tagi Maolunga ne tala ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Gai tahi laangi huu o tahi malama, i de lua ngadau, gai de tabernacle gu duu age. ");
INSERT INTO nkr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","De masavaa a Moses ne hagaduu age ai de tabernacle, gai ia ne hagatau denga dagelo i olaadeu mommee, ga velo ange denga laagau gi lodo dagelo laa, gai ia ga hangaabo ange denga laagau hagamakaga, ma de hagatuu age denga duludulu. ");
INSERT INTO nkr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Gai ia ga doha denga malo ga odo ai honga de tabernacle, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Gai ia ga kave luu duu hadu o de tala hagadonu ga hhao ange gi lo te ngavesi, ga velo ange luu laagau o de ngavesi, aama de gaavange de pono o de tala haisala gi honga de ngavesi laa, ");
INSERT INTO nkr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","gai ia ga kave de ngavesi ga hhao gi lo te tabernacle, ga dau age de malo buibui ga buibui ai de ngavesi o de tala hagadonu, bei de hai a Tagi Maolunga ne tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Gai ia ne hagaduu teebele i lo te hale malo hagabuni, i de baasi gi ngaiho i lo te tabernacle, i tua de malo buibui, ");
INSERT INTO nkr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","gai ia ga hagatau ange denga pelaoaa i mada i mua o Tagi Maolunga gi ono elunga, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Gai ia ne hagaduu de mee dugu laama i de baasi gee o teebele i lo te hale malo hagabuni, i de baasi gi ngaage o de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","gai ia ga haula denga laama i mada luu mada o Tagi Maolunga, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Gai ia ne gaamai de mommee o ssigidaumaha goolo gi lo te hale malo hagabuni, i tua de malo buibui, ");
INSERT INTO nkr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ga dudu ssigidaumaha o mee maanongi i ono elunga, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Gai ia ne dau age de malo ga buibui ai de haitoga o de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Gai ia ga hagaduu de mommee o ssigidaumaha dudu i gaogao de haitoga o de tabernacle, go de hale malo hagabuni; gai ia ga hai sigidaumaha dudu ma ssigidaumaha o grain, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Gai Moses ga hagaduu taaba hagagilimalali i magavaa de hale malo hagabuni ma de mommee o ssigidaumaha dudu, ga hhao i vai e hagagilimalali ai, ");
INSERT INTO nkr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","go vai o Moses ma Aaron, aama dama daane a Aaron e hagagilimalali ai olaadeu lima ma vae. ");
INSERT INTO nkr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","De masavaa naa huu olaadeu e hulo ai e ulu gi lo te hale malo hagabuni, ma de masavaa olaadeu e hulo ai ga hagapaa ange gi de mommee o ssigidaumaha dudu, gai gilaadeu gi hagagilimalali ina gilaadeu, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Gai Moses ga hagaduu age de buibui laa daha i luu baasi de tabernacle ma de mommee o ssigidaumaha dudu, gai ia ga dau age de malo buibui o de haitoga o de buibui laa daha. Gai Moses ne hai ga lava hegau laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Gai de hagausinga gu hano iho ga haoli de hale malo hagabuni, gai de mahamaha o Tagi Maolunga gu hhao lo te tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Gai Moses gu dee maua i de ulu gi lo te hale malo hagabuni, go hiidinga de hagausinga gu haoli ono elunga, gai de mahamaha o Tagi Maolunga gu hhao lo te tabernacle. ");
INSERT INTO nkr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","De masavaa olaadeu e hulo saele ai i lodo henua, gai de masavaa naa huu o tuludulu hagausinga laa e hagangalue gee ai i honga tabernacle, gai de gau Israel alodahi ga ngaalue hogi ga hulo, ");
INSERT INTO nkr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","aagai noo de hagausinga laa e dee hagangalue, gai gilaadeu e dee ngaalue donu, ga dae ai gi de laangi e hagangalue ai. ");
INSERT INTO nkr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Gai de hagausinga a Tagi Maolunga e duu i honga tabernacle i de laangi, gai de boo e bei de ahi i mada i mua o dangada o Israel alodahi, i taulooloa delaadeu hagadaga saele.");
INSERT INTO nkr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Gai Tagi Maolunga ne hagahi Moses, ga basa ange gi de ia mai i de hale malo hagabuni, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Basa ange gi de gau Israel, hai ange gi gilaadeu: ‘De masavaa naa huu a tangada e gaamai ai dana sigidaumaha gi Tagi Maolunga, gai ia gi gaamai dahi ana kaau, aabe go dahi ana ssiibi. ");
INSERT INTO nkr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Gai noo ia e hai dana sigidaumaha dudu i dahi manu mai i dana hagabuulingaa manu haangai, gai ia gi gaamai dahi manu daane e deai laa mee baubau i dono angaanga, ga hai ai dana sigidaumaha i de haitoga o de hale malo hagabuni, gi malangilangi ai Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Gai ia ga dugua ange dono lima gi honga de biho o de manu e hai ai laa dana sigidaumaha dudu, gi malangilangi ai Tagi Maolunga gai gi maatala ai ono haisala. ");
INSERT INTO nkr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Gai ia ne daa gi magau de kaau daane laa i mada luu mada o Tagi Maolunga; gai denga dama daane a Aaron go de gau haimeedabu gi gaavee ono dodo gi dabudabui ange gi luu baasi de mommee o ssigidaumaha i gaogao de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Gai tangada niiana ssigidaumaha, gi hoolea de gili o de manu e hai ai laa ssigidaumaha dudu, ga duuduu gi too dagidagi ono aalanga. ");
INSERT INTO nkr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Gai denga dama daane a Aaron, tangada haimeedabu, gi dahua de ahi i honga de mommee o ssigidaumaha ga hagatau ange denga lahhie gi honga de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Gai dama daane a Aaron gi dugua ange denga aalanga, ma de biho, aama denga mee moomuna gi honga lahhie e hai ai laa de ahi, i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Gai ia gi huuia denga dae ma denga vae i vai. Gai tangada haimeedabu gi duungia de manu laa alodahi i honga de mommee o ssigidaumaha; se sigidaumaha dudu, e nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Gai noo tangada e gaamai dahi ssiibi be se guudi e hai ai dana sigidaumaha, gai ia gi hilia mai dahi manu daane e deai laa mee baubau i dono angaanga. ");
INSERT INTO nkr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Gai ia ga daa gi magau de manu laa, i baasi i ngaiho de mommee o ssigidaumaha, i mada luu mada o Tagi Maolunga, gai dama daane a Aaron gi dabudabuia ange dodo o de manu laa, gi luu baasi o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Gai tangada laa gi duuduudia denga aalanga gi too dagidahi, ma de biho ma denga mee moomuna, gai tangada haimeedabu gi hagataulia ange mee nei gi honga denga lahhie e hai ai laa de ahi i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Gai ia gi huuia denga dae ma denga vae i vai. Gai tangada haimeedabu gi duungia de manu laa alodahi i honga de mommee o ssigidaumaha; se ssigidaumaha dudu, e nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Gai noo tangada e hai dana sigidaumaha dudu ange gi Tagi Maolunga i hanu manu llele, gai ia gi gaamai dahi manu kono be se pigeon e hai ai dana sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Gai tangada haimeedabu gi gaavee de manu lele laa gi mommee o ssigidaumaha ga milo gi doo de biho, ga dudu i honga de mommee o ssigidaumaha, gai ono dodo gi hagassali iho i de baasi o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Gai ia gi aaua de mee hhao gai ma denga hulu manu ga tili gi de baasi i dua de mommee o ssigidaumaha, i de mommee iai denga lehu; ");
INSERT INTO nkr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ga lava gai ia gi boogia luu bakau gi daangia gi mahanga lua ai de angaanga o de manu laa, gai e dee hai gi too dagidahi. Gai tangada haimeedabu ga dudu de manu lele laa alodahi i honga denga lahhie i honga de mommee o ssigidaumaha; se sigidaumaha dudu, e nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Noo dahi dangada e hai dahi sigidaumaha ange gi Tagi Maolunga i hanu hua grain, gai ia gi haia i pelaoaa lligi. Gai ia gi liingia ange lolo gi ono elunga, ma de gaavange frankincense aagena, ");
INSERT INTO nkr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ga gaamai gi denga dama daane a Aaron, gu hai laa gi ni dangada haimeedabu. Gai tangada haimeedabu gi buulia hanu pelaoaa gu hilo laa ma lolo aama frankincense, ga dudu hanu i honga de mommee o ssigidaumaha e hai ai de mee hagamaanadu; de mee nei se sigidaumaha e hai i de ahi, gai e nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Gai mee e doe i pelaoaa laa go tuuhanga o Aaron ma ana dama daane; deenei tiba dabu mmao mai i ssigidaumaha e hai laa i de ahi, ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Noo tangada e gaamai hanu hua grain gu dao e hai ai dana sigidaumaha, gai ia gi haia gi ni keege e hai i pelaoaa lligi e deai mee hagahua iai ma de hilo ange lolo aagena, aabe ni besgede dee hagahua e hulu ange lolo aagena. ");
INSERT INTO nkr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Gai noo koe e hai dau ssigidaumaha o grain ga dunu i honga dahi gumedi hadu baabaa, gai haia i pelaoaa lligi e deai mee hagahua iai, gai gu hilo ma lolo; ");
INSERT INTO nkr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","gai koe dohidohi gi lligi, ga llingi ange lolo gi aagena; deenei de hai e hai ai ssigidaumaha o grain. ");
INSERT INTO nkr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Gai noo dau sigidaumaha o grain ga dao i lo te anibada iai de pono, gai haia i pelaoaa lligi ma lolo. ");
INSERT INTO nkr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Gai koe gaamai ssigidaumaha o grain laa ga gaavange gi Tagi Maolunga, gai de masavaa naa huu aau e gaamai ai ga gaavange gi tangada haimeedabu, gai ia ga kave gi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Gai tangada haimeedabu gi aaua hanu mee mai i ssigidaumaha o grain laa ga dudu i honga de mommee o ssigidaumaha e hai ai de mee hagamaanadu, se ssigidaumaha nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Gai mee e doe go tuuhanga a Aaron ma ana dama daane; deenei tiba dabu mmao mai i ssigidaumaha e hai laa i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Gai e deai donu mee hagahua e hilo ange gi denga grain oodou e gaamai e sigidaumaha ange gi Tagi Maolunga; goodou e dee dudu hogi hanu mee hagahua be ni hooni gi lodo oodou ssigidaumaha dudu ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Gai goodou e maua i de sigidaumaha ange mee nei gi Tagi Maolunga madali oodou huamanu e hagihagi i taamada, aagai mee nei e dee dudu i honga de mommee o ssigidaumaha bei ssigidaumaha nnamu kala. ");
INSERT INTO nkr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Gai koe gi gaavange soolo gi denga sigidaumaha alodahi e hai i grain; gai koe gi dee ngalo de gaavange soolo gi au sigidaumaha o grain, de mee nei se hagatoo donu hagaheloongoi i oodou magavaa ma doodou Maadua; oodou sigidaumaha o grain e gaavange soolo aagena. ");
INSERT INTO nkr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Noo koe gu hai dahi sigidaumaha ange gi Tagi Maolunga i grain e hagihagi laa i taamada, gai ssigidaumaha nei e hai i huamanu e hagihagi i taamada e lala gi mmasa denga gau looloa hoou i honga de ahi ga mmili gi lligi. ");
INSERT INTO nkr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Gai koe ga llingi ange lolo ma frankincense aagena; deenei de hai e hai ai ssigidaumaha o grain. ");
INSERT INTO nkr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Gai tangada haimeedabu gi aaua hanu hua grain gu mmili laa ma gu lligi ma de hilo i lolo madali denga frankincense alodahi; de mee nei se sigidaumaha e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Noo dahi dangada e gaamai dana ssigidaumaha hagadanuaa magavaa, i dahi ana kaau, e dee hilihili be se manu daane be se manu hahine, gai ia gi gaamai dahi manu e deai mee baubau i dono angaanga, gi mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Gai tangada gi dugua ange dono lima gi honga de biho o de manu laa, gai ia ga daa gi magau i ma te haitoga o de hale malo hagabuni. Gai denga dama daane a Aaron gu hai laa gi ni dangada haimeedabu gi gaavee denga dodo gi dabudabuia ange gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Gai tangada gi vaaea denga mee e hai ai sigidaumaha dudu ange gi Tagi Maolunga: denga mee moomuna alodahi e pigi ange laa gi denga dae ma magavaa denga dae, ");
INSERT INTO nkr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ma luu kidney ma mee moomuna iai, aama mee moomuna o de ade, aanei ana mee e vvae madali luu kidney. ");
INSERT INTO nkr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Gai denga dama daane a Aaron gi duungia mee nei i honga de mommee o ssigidaumaha madali ssigidaumaha dudu i honga denga lahhie o de ahi; de mee nei se sigidaumaha nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Noo ia e hai dana sigidaumaha hagadanuaa magavaa ange gi Tagi Maolunga i dahi ssiibi be se guudi, e dee hilihili be se manu daane be se manu hahine, gai ia gi haia gi se manu e deai mee baubau i dono angaanga. ");
INSERT INTO nkr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Gai noo ia e hai dana sigidaumaha i dahi ssiibi, gai ia gi gaamai gi mada luu mada o Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ga dugu ange dono lima gi honga de biho o de manu laa, gai ia ga daa gi magau i ma te haitoga o de hale malo hagabuni. Gai denga dama daane a Aaron gi dabudabuia ange denga dodo gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Gai ia gi vaaea mai i ssigidaumaha hagadanuaa magavaa e hai ai sigidaumaha dudu ange gi Tagi Maolunga: denga mee moomuna, ma de muli iai laa mee moomuna, gai duudia gi baa i de ivi laanui, ma denga mee moomuna e pigi ange laa gi denga dae ma magavaa denga dae, ");
INSERT INTO nkr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ma luu kidney ma mee moomuna iai, aama mee moomuna o de ade, aanei ana mee e vvae madali luu kidney. ");
INSERT INTO nkr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Gai tangada haimeedabu gi gaavee mee nei gi duungia i honga de mommee o ssigidaumaha, ni gai e hai ai ssigidaumaha dudu ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Noo tangada e gaamai dahi guudi e hai ai dana sigidaumaha, gai ia gi gaamai gi mada luu mada o Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ga dugua ange dono lima gi honga de biho o de manu laa, gai ia ga daa gi magau i ma te haitoga o de hale malo hagabuni; gai denga dama daane a Aaron gi dabudabuia ange denga dodo gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Gai tangada gi vaaea denga mee e hai ai sigidaumaha dudu ange gi Tagi Maolunga: denga mee moomuna e pigi ange laa gi honga denga dae ma magavaa denga dae, ");
INSERT INTO nkr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ma luu kidney ma mee moomuna iai, aama mee moomuna o de ade, aanei ana mee e vvae madali luu kidney. ");
INSERT INTO nkr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Gai tangada haimeedabu gi gaavee mee nei gi duungia i honga de mommee o ssigidaumaha, aanei gai e hai ai sigidaumaha nnamu kala e hai laa i de ahi. Denga mee moomuna alodahi nii Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","De mee nei se mee gu hagasauaa adu gi goodou ma oodou atangada alodahi, i mommee alodahi oodou e nnoho ai ga hano ai: goodou e dee gai donu denga mee moomuna ma dodo.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Basa ange gi de gau Israel, hai ange, ‘Tangada naa huu e haisala i dahi hainga a Tagi Maolunga gu tala adu goodou gi dee haia, gai e dee se hagabau ga hai ai de mee nei — ");
INSERT INTO nkr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Noo tangada haimeedabu maolunga gu haisala, ga hagahaisala ai de huaadangada, gai ia gi gaamai dahi kaau daane e deai mee baubau i dono angaanga, e hai ai ssigidaumaha o haisala e tala ai ono haisala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Gai ia gi gaamai de kaau daane laa gi de haitoga o de hale malo hagabuni i mada luu mada o Tagi Maolunga. Gai ia ga dugua ange dono lima gi honga de biho o de kaau laa, ga daa gi magau i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Gai tangada haimeedabu maolunga gi gaavee hanu dodo o de kaau daane laa gi lo te hale malo hagabuni; ");
INSERT INTO nkr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","gai ia gi hagasulu ina ange dono madannia gi lodo dodo laa, gai ia ga hagatoo madaua ange hanu dodo gi mada luu mada o Tagi Maolunga i e hidu hanonga, i mada i mua o de malo buibui o de mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Gai tangada haimeedabu gi gaavange hogi hanu dodo gi honga denga hanga o de mommee o ssigidaumaha o mee maanongi i mada luu mada o Tagi Maolunga, i lo te hale malo hagabuni. Gai dodo e doe gai ia gi liingia ange gi tahido o de mommee o ssigidaumaha dudu i ma te haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Gai ia gi vaaea gee denga mee moomuna alodahi o de kaau daane e hai ai laa ssigidaumaha o haisala; go denga mee moomuna e pigi ange laa gi honga denga dae ma magavaa o denga dae, ");
INSERT INTO nkr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ma luu kidney ma mee moomuna iai, ma mee moomuna o de ade, aanei ana mee e vvae gee madali luu kidney, ");
INSERT INTO nkr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","bei de hai e aau ai laa denga mee bee nei i de kaau daane e hai ai laa ssigidaumaha hagadanuaa magavaa. Gai tangada haimeedabu gi gaavee mee nei gi duungia i honga de mommee o ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Aagai de gili o de kaau daane laa ma ono kano, ma dono biho, ma denga vae, ma denga dae aama ono duudae, ");
INSERT INTO nkr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mee nei alodahi e kave gi tua de mommee nnoho gaainga gi dahi mommee gilimalali, e tili ai laa denga lehu, gai ia ga dudu ai i de ahi lahhie; go de mommee e llingi ai laa denga lehu e dudu ai mee nei. ");
INSERT INTO nkr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Noo de huaadangada o Israel gu haisala, gai tee se hagabau ga hagahaisala ai dahi mee a Tagi Maolunga gu tala ange gilaadeu gi dee haia, gai e dee galemu donu noo dangada tee iloo de hai de mee nei, gai gilaadeu gu haisala donu hogi. ");
INSERT INTO nkr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","De masavaa naa huu e iloo mai ai bolo gilaadeu gu oha dahi hainga, gai de huaadangada gi gaamai dahi kaau daane e hai ai ssigidaumaha o haisala; gai gilaadeu gi gaamai gi de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Gai denga dagi o de hagabuulingaa dangada gi dugua ange olaadeu lima gi honga de biho o de kaau daane laa i mada luu mada o Tagi Maolunga, gai ga daa gi magau de kaau daane laa i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Gai tangada haimeedabu maolunga gi gaavee hanu dodo o de kaau daane laa gi lo te hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Gai ia gi hagasulu ina ange dono madannia gi lodo dodo laa, gai ia ga hagatoo madaua dodo laa i e hidu hanonga i mada luu mada o Tagi Maolunga, i mada i mua o de malo buibui. ");
INSERT INTO nkr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Gai ia ne gaavange hogi hanu dodo gi honga denga hanga o de mommee o ssigidaumaha i mada luu mada o Tagi Maolunga lo te hale malo hagabuni; gai ia gi gaavee dodo e doe gi liingia ange gi tahido o de mommee o ssigidaumaha dudu i ma te haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Gai ia gi aaua gee denga mee moomuna alodahi i de manu laa, e dudu i honga de mommee o ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Gai ia gi haia de kaau nei gi bei de hai ne hai ai laa de kaau daane o ssigidaumaha o haisala. Deenei de hai a tangada haimeedabu e tala ai olaadeu haisala, gai olaadeu haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Gai ia gi gaavee de kaau daane laa gi tua de mommee nnoho gaainga ga dudu i de ahi, bei dana hai ne dudu ai laa de kaau daane i taamada. Deenei de hai e hai ai ssigidaumaha o haisala ange gi de huaadangada o Israel. ");
INSERT INTO nkr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","De masavaa naa huu e haisala ai dahi dagi, gai ia e dee se hagabau donu ga hagahaisala dahi mee a Tagi Maolunga dono Maadua gu tala ange ia gi dee haia, gai ia e haisala ai donu. ");
INSERT INTO nkr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Gai noo ia gu iloo iho bolo ia gu haisala, gai ia gi gaamai dahi guudi daane, e deai laa mee baubau i dono angaanga e hai ai dana ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Gai ia ga dugua ange dono lima gi honga de biho o de guudi laa, ga daa gi magau i de mommee e daa ai laa manu e hai ai ssigidaumaha dudu i mada luu mada o Tagi Maolunga; deenei de hai e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Gai tangada haimeedabu gi gaavee hanu dodo o ssigidaumaha o haisala i dono madannia mage gaavange gi honga denga hanga o de mommee o ssigidaumaha dudu; gai ia gi liingia ange denga dodo e doe gi tahido o de mommee o ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Gai ia gi duungia mee moomuna alodahi o de manu laa i honga de mommee o ssigidaumaha, bei de hai e hai ai laa de manu e hai ai ssigidaumaha hagadanuaa magavaa. Deenei de hai a tangada haimeedabu e tala ai ono haisala, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Noo dahi dangada i oodou daha gu haisala, gai ia e dee se hagabau ga hagahaisala ai dahi mee a Tagi Maolunga gu tala ange laa ia gi dee haia, gai ia e haisala ai donu. ");
INSERT INTO nkr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","De masavaa naa huu aana e iloo iho bolo ia gu haisala, gai ia gi gaamai dahi guudi hahine e deai mee baubau i dono angaanga, e hai ai ssigidaumaha ange gi mee oona gu haisala ai. ");
INSERT INTO nkr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Gai ia gi dugua ange dono lima gi honga de biho o de manu e hai ai laa ssigidaumaha o haisala, ga daa gi magau i de mommee e hai ai ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Gai tangada haimeedabu gi gaavee hanu dodo o de manu laa i dono madannia gi gaavange gi honga denga hanga o de mommee o ssigidaumaha dudu, gai ia ga llingi ange dodo e doe gi tahido de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Gai ia vaaea ono mee moomuna alodahi, bei de hai ne vvae ai laa mee moomuna o de manu ne hai ai laa ssigidaumaha hagadanuaa magavaa; gai ia ga dudu i honga de mommee o ssigidaumaha, gi nnamu kala ange ai gi Tagi Maolunga. Deenei de hai a tangada haimeedabu e tala ai ono haisala, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Gai noo ia e gaamai dahi ssiibi e hai ai ssigidaumaha o haisala, gai ia gi gaamai dahi ssiibi hahine e deai laa mee baubau i dono angaanga. ");
INSERT INTO nkr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Gai ia ga dugua ange dono lima gi honga de biho o de manu e hai ai ssigidaumaha o haisala, gai ia ga daa gi magau i de mommee e daa ai manu o ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Gai tangada haimeedabu gi gaavee hanu dodo o ssigidaumaha o haisala i dono madannia gi gaavange gi honga denga hanga o de mommee o ssigidaumaha dudu; gai ia ga llingi ange dodo e doe gi tahido de mommee o ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Gai ia ga vaaea mee moomuna alodahi o de manu laa, bei de hai ne hai ai ssiibi gauligi o ssigidaumaha hagadanuaa magavaa. Gai tangada haimeedabu gi duungia mee nei i honga de mommee o ssigidaumaha, bei de hai e hai ai laa ssigidaumaha dudu ange gi Tagi Maolunga. Deenei de hai a tangada haimeedabu e tala ai ono haisala, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Noo dahi dangada gu haisala i dana dee lodo e tala hagadonu dagodo o dana mee ne gidee aabe ne langona, gai ia e hagaduasala donu i ono baubau. ");
INSERT INTO nkr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Gai noo dahi dangada ne poo dahi mee e dee gilimalali — e dee hilihili be se manu magau i lodo henua, be se kaau magau, aabe go dahi manu e tolo i honga de gelegele, gai ia tee iloo, gai ia gu dee gilimalali donu, gai gu haisala donu hogi. ");
INSERT INTO nkr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Gai noo ia gu poo ange gi mee dee gilimalali o dangada, e dee hilihili be se aha, aagai ia tee iloo — gai ga iloo naa huu e ia ma de donu iho, gai ia e haisala ai donu. ");
INSERT INTO nkr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Gai noo dahi dangada e ngadi hagatoo donu, ma de tala bolo ia e hai dahi mee baubau aabe se mee danuaa, e dee hilihili donu be se aha aana ne hagatoo donu ai, gai ia tee iloo, gai ia e haisala donu i de masavaa aana e iloo ma de donu iho. ");
INSERT INTO nkr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Gai de masavaa naa huu o tangada e iloo ai bolo ia gu haisala i mee nei, gai ia gi daalaa bolo ia gu haisala i de mee laa, ");
INSERT INTO nkr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","gai ia gi gaamai dahi manu gi Tagi Maolunga e hai ai ssigidaumaha o haisala laa, gai ia gi gaamai dahi manu hahine mai i de hagabuulingaa manu, e dee hilihili be se ssiibi be se guudi, e hai ai ssigidaumaha o haisala. Deenei de hai a tangada haimeedabu e tala ai ono haisala. ");
INSERT INTO nkr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Noo ia e dee maua i de gaamai dahi ssiibi gauligi, aagai ia gi gaamai gi Tagi Maolunga e lua manu kono aabe e lua pigeon e hai ai ssigidaumaha o mee aana ne hagahaisala laa; dahi luu manu nei e hai ai ssigidaumaha o haisala, gai dahi e hai ai ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Gai ia gi gaamai luu manu llele nei gi daho tangada haimeedabu, gai tangada haimeedabu ga hai ssigidaumaha o haisala i dahi luu manu llele laa; gai ia ga milo gi hadi de ua o de manu laa, gai e dee hai gi doo de biho, ");
INSERT INTO nkr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","gai ia gi dabudabuia ange hanu dodo o de manu ne hai ai ssigidaumaha o haisala, gi luu baasi de mommee o ssigidaumaha, gai ga llingia ange dodo e doe gi tahido o de mommee o ssigidaumaha. Deenei ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Gai ia gi hagadabena ina de manu ange laa e hai ai ssigidaumaha dudu bei dagodo huulonga o de hainga. Deenei de hai a tangada haimeedabu e tala ai ono haisala, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Aagai noo ia e dee maua i de hagao e lua manu kono aabe e lua pigeon, gai ia gi gaamai e dahi diba i diba e madaangahulu o dahi ephah pelaoaa lligi e hai ai sigidaumaha o ono haisala; gai ia gi dee gaavange lolo be go frankincense aagena, go hiidinga deenei ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Gai ia gi gaamai mee laa gi daho tangada haimeedabu, gai tangada haimeedabu gi buulia hanu mee i lo tono lima e hai ai tiba hagamaanadu ga dudu i honga de mommee o ssigidaumaha, madali denga sigidaumaha e hai laa i de ahi ange gi Tagi Maolunga; deenei ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Deenei de hai a tangada haimeedabu e tala ai ono haisala; gai ono haisala gu maatala. Gai mee e doe go tuuhanga o tangada haimeedabu, bei de hai e hai ai ssigidaumaha o grain.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Noo tangada tee se hagabau donu, gai ia gu haisala ange gi mee gu hagadabu ange gi Tagi Maolunga, gai ia gi gaamai gi Tagi Maolunga dahi ssiibi daane mai i dana hagabuulingaa ssiibi, go dahi manu e deai mee e baubau i dono angaanga, e hagao ai ono haisala, gai ia gi haia gi bei de hagabaaunga o de shekel o de hale dabu, e hai ai ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Gai ia gi hagapunidia ange dahi diba i diba e lima ga gaavange ai gi tangada haimeedabu, e hagao ai ana mee ne hagahaisala laa i mee dabu. Gai tangada haimeedabu gi haia ssigidaumaha o tagasala i ssiibi laa e hagaheohi ai ana mee ne hagahaisala laa, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Noo dahi dangada e haisala i dahi mee a Tagi Maolunga gu tala adu goodou gi dee haia, gai ia tee iloo, ia gu haisala donu gai ia e hagaduasala donu i ono baubau. ");
INSERT INTO nkr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Gai ia gi gaamai gi tangada haimeedabu dahi ssiibi daane mai i dana hagabuulingaa manu, e deai laa mee e baubau i dono angaanga, gai ia gi hagabaulia ange gi mee e hai ai ssigidaumaha o tagasala. Gai tangada haimeedabu ga hai ai ssigidaumaha e tala ai ono haisala, i mee aana tee iloo laa, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Deenei de hai e hai ai ssigidaumaha o tagasala; go hiidinga ia gu haisala ange donu gi Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Noo dahi dangada gu haisala, gai ia tee hai hegau i de muna abodonu ange gi Tagi Maolunga, gai ne hadu muna ange gi tangada ne gaavange dahi mee ia gi doange ina, be ia gu gaiaa mee laa, aabe ne vaivai dagodo ange gi tangada ange laa, ");
INSERT INTO nkr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","be ia gu gidee de goloa o dahi dangada gu tili laa, gai ia ga hadu muna ai, be ia ne basa hagatoo donu i de hadu muna, aabe ia ne hai ange dahi baubau bee nei ange gi tangada ange laa — ");
INSERT INTO nkr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","gai de masavaa naa huu o tangada e donu iho ai bolo ia gu haisala i dana hai mee nei, gai ia gi hagaahea ange mee aana ne gaiaa laa, be go mee aana ne kave laa i de vaivai dagodo, be go mee ne gaavange laa ia gi doange ina, be se mee ne tili gai ia ga gidee, ");
INSERT INTO nkr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","be se mee niiana gu hagatoo donu hadu muna ai. Ia gi hagaahea ange mee nei alodahi ga hagapuni ange dahi diba i diba e lima ga hagaahe ange ai gi tangada niiana mee laa, i de laangi aana e hai ai ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Gai ia gi gaamai gi tangada haimeedabu mee e hai ai ssigidaumaha o tagasala ange gi Tagi Maolunga: e dahi ssiibi daane mai i dana hagabuulingaa manu, e deai mee e baubau i dono angaanga, gai koe hagabaulia ange gi bei de hagaoanga o ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Deenei de hai a tangada haimeedabu e tala ai ono haisala, i mada luu mada o Tagi Maolunga, gai ono haisala gu maatala i mee alodahi gu hagabuu ange ai ssala gi de ia.” ");
INSERT INTO nkr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Basa ange gi Aaron ma ana dama daane, hai ange: ‘Aanei hainga o ssigidaumaha dudu: ssigidaumaha dudu e dugu i honga de mommee o ssigidaumaha i de boo laa alodahi ga dae ai gi taiao age, gai de ahi i honga de mommee o ssigidaumaha e hai donu gi ula. ");
INSERT INTO nkr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Gai tangada haimeedabu gi gahu i dono malo linen, ma dono malo huna linen, go de malo e mua ange gi dono angaanga, gai ia ga aau gee lehu ne doe laa i ssigidaumaha dudu, i honga de mommee o ssigidaumaha, ga dugu ange gi gaogao de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Gai ia ga hagaui ono malo dabu, ga ahe ange ga gahu i ono malo i de laa tubua, gai ia ga kave denga lehu laa ga llingi i dahi mommee gilimalali i tua de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Gai de ahi i honga de mommee o ssigidaumaha e hai donu gi gaa i masavaa alodahi, e dee dugu gi made; gai tangada haimeedabu gi gaavange lahhie gi honga de ahi i denga daiao alodahi, ga hagatau ange mee o ssigidaumaha dudu gi ono elunga, gai ia ga dudu ai denga mee moomuna o ssigidaumaha hagadanuaa magavaa. ");
INSERT INTO nkr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Gai de ahi i honga de mommee o ssigidaumaha e hai donu gi gaa i masavaa alodahi; e dee hai donu gi made. ");
INSERT INTO nkr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Aanei hainga o ssigidaumaha o grain. Go denga dama daane a Aaron e gaamai ssigidaumaha nei gi de mommee o ssigidaumaha, i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Gai dahi gilaadeu gi buulia hanu pelaoaa lligi mai i ssigidaumaha o grain madali denga lolo ma frankincense alodahi gu hilo ange laa aagena, ga dudu i honga de mommee o ssigidaumaha e hai ai de mee hagamaanadu, se mee nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Gai Aaron ma ana dama gi haia mee e doe gi haia ai pelaoaa dee hagahua ga gai i de mommee dabu, i lo te buibui o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Pelaoaa nei e dee labu i mee hagahua ga dao ai. Au gu gaavange tiba nei e hai ai delaadeu duuhanga mai i dagu sigidaumaha e hai laa i de ahi; gai se mee dabu mmao, bei ssigidaumaha o haisala aama ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Denga daane alodahi i de aamuli o Aaron e maua i de gai mee nei, bei de hai a Tagi Maolunga gu hagasauaa ange ai gi oodou atangada alodahi, ni mee mai i denga sigidaumaha e hai i de ahi. Be goai e poo ange gi mee nei gai ia gu dabu hogi.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Deenei ssigidaumaha a Aaron ma ana dama daane e gaavange gi Tagi Maolunga i de laangi o tangada e hagadabu ai i de lolo: e dahi diba i diba e madaangahulu o dahi ephah o pelaoaa lligi bei ssigidaumaha o grain i de laa tubua, dahi luu baasi e hai ai sigidaumaha i taiao gai de baasi ange laa i de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Gai mee nei e hai i lolo ga dunu i honga de pelaini; gai koe e hilo gi danuaa ga gaamai ai e hai ai ssigidaumaha o hua manu bei grain gu maoha, gai gu ni dibadibaa, se mee nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Gai tangada i magavaa dama daane o Aaron e hagadabu ange gi tuulanga o tangada haimeedabu, gi gaamai ssigidaumaha nei e gaavange gi Tagi Maolunga, bei de hai gu hagasauaa ange ai laa gi gilaadeu ga hano ai; ssigidaumaha nei e dudu alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Denga sigidaumaha alodahi a tangada haimeedabu e hai i denga grain e dudu alodahi; e deai donu mee e gai ai.” ");
INSERT INTO nkr_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Basa ange gi Aaron ma ana dama daane, hai ange, ‘Deenei de hai e hai ai ssigidaumaha o haisala. De manu e hai ai sigidaumaha o haisala e daa gi magau i de mommee e daa ai laa de manu o ssigidaumaha dudu i mada luu mada o Tagi Maolunga; gai se mee dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Tangada haimeedabu e haia laa ssigidaumaha o haisala gi gaina kano o de manu laa, i de mommee dabu i lo te buibui o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Gai be goai naa huu e poo ange gi kano o de manu laa gai ia gu dabu hogi; gai noo hanu ono dodo gu ssii ange ga baalau ai dahi malo, gai koe daia de malo laa i dahi mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Gai de gumedi hadu ne boale ai laa ono kano e oha gi maoha; gai noo se gumedi bronze ne boale ai, ga ssolo ono lodo gi danuaa ga hagamaa i vai. ");
INSERT INTO nkr_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Gai de gau haimeedabu alodahi e maua i de gaimee ai; mee nei e dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Aagai e deai donu kano o de manu o ssigidaumaha o haisala e gai, go de manu e kave laa hanu ono dodo gi lo te hale malo hagabuni e tala ai haisala i de mommee dabu; gai e dudu donu i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Aanei hanu hainga o ssigidaumaha o tagasala, gai e dabu mmao: ");
INSERT INTO nkr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Gilaadeu gi daia hogi de manu e hai ai ssigidaumaha o tagasala i de mommee ne daa ai laa de manu o ssigidaumaha dudu, gai dodo o de manu laa e dabudabui ange gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Gai denga mee moomuna alodahi e hai ai ssigidaumaha: go de muli iai laa mee moomuna, ma mee moomuna e pigi ange laa gi denga dae, ");
INSERT INTO nkr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ma luu kidney ma mee moomuna iai, aama mee moomuna o de ade e vvae madali luu kidney. ");
INSERT INTO nkr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Gai tangada haimeedabu gi duungia mee nei i honga de mommee o ssigidaumaha e hai ai ssigidaumaha dudu ange gi Tagi Maolunga. Deenei ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Denga daane alodahi i denga huaabodu o de gau haimeedabu e maua i de gai mee nei; gai mee nei e gai donu huu i dahi mommee dabu; se mee dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Gai ssigidaumaha o tagasala e hai bei ssigidaumaha o haisala, gai se hainga daudahi e hai ai luu sigidaumaha nei: tangada haimeedabu e haia laa ssigidaumaha tagasala gi gaavee tuuhanga mai i ssigidaumaha laa. ");
INSERT INTO nkr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Gai tangada haimeedabu e haia laa ssigidaumaha dudu a dahi dangada gi gaavee de gili o de manu ne hai ai laa ssigidaumaha maana. ");
INSERT INTO nkr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Gai sigidaumaha alodahi e hai i grain ga dao ma mee alodahi e dunu i lo te anibada be go lo te pelaini, nii tangada haimeedabu hogi e haia laa sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Gai sigidaumaha alodahi e hai i grain ga hilo ma lolo be ni mee mmasa e gaavange gi denga dama daane Aaron, gai e vaevae hagahedae ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Aanei hainga o ssigidaumaha hagadanuaa magavaa a tangada e gaamai gi Tagi Maolunga: ");
INSERT INTO nkr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Noo tangada se hai ssigidaumaha nei e hagaahe ange ai de abodonu, gai ia gi gaamai hogi hanu keege gu hilo ma lolo, ma besgede gu hulu ange lolo aagena, aama keege e hai i pelaoaa lligi gu hilo ma lolo, mee nei alodahi e deai donu mee hagahua e gaavange aagena. ");
INSERT INTO nkr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ia gi gaamai hogi hanu duudangaa pelaoaa iai mee hagahua madali dana ssigidaumaha hagadanuaa magavaa. ");
INSERT INTO nkr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Gai ia gi gaavee dagidahi keege mai i denga sigidaumaha nei, gi gaavange gi Tagi Maolunga; mee nei go tuuhanga o tangada haimeedabu e dabudabuia ange laa dodo o ssigidaumaha hagadanuaa magavaa gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Gai kano manu o ssigidaumaha hagadanuaa magavaa ma de hagaahe ange ai de abodonu, e gai donu gi odi i de laangi ne hai ai ssigidaumaha laa; e dee dugu donu hanu gi doe gi taiao age. ");
INSERT INTO nkr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Aagai noo dana sigidaumaha se sigidaumaha niiana gu hagatoo donu ai, aabe se mee ngadi gaavange, gai kano o de manu e hai ai e gai i de laangi a tangada e hai ai dana sigidaumaha, gai mee alodahi e doe e maua hogi i de gai i de laangi i ono dua. ");
INSERT INTO nkr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Gai denga kano ne doe i dana sigidaumaha i dua e dolu laangi e dudu i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Noo tangada e gai kano o de manu ne hai ai dana sigidaumaha hagadanuaa magavaa i dua e dolu laangi, gai dana sigidaumaha e dee dau. Gai gu deai haigamaiana ange gi tangada ne haia, gai gu hakino gee; gai tangada ne gaina mee nei e hagaduasala donu i ono baubau. ");
INSERT INTO nkr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kano manu gu paa ange laa gi hanu mee dee gilimalali e dee gai donu, aagai e dudu i de ahi. Dangada alodahi e gilimalali laa e maua i de gai kano manu o ssigidaumaha e doe laa. ");
INSERT INTO nkr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Aagai tangada e gaina kano o ssigidaumaha hagadanuaa magavaa a Tagi Maolunga gai e hanu mee e dee gilimalali i de ia, tangada bee nei e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Noo tangada gu poo ange gi hanu mee dee gilimalali — e dee hilihili be go mee hakino gee o dangada, be go dahi manu hakino gee, aabe go dahi mee dee gilimalali e tolo i honga de gelegele — gai ia ga gai kano o de manu ne hai ai ssigidaumaha hagadanuaa magavaa a Tagi Maolunga, gai ia e vvae gee donu mai i daho ono dangada.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Basa ange gi de gau Israel, hai ange, ‘Goodou e dee alaange de gai mee moomuna o de kaau, ma ssiibi, aama de guudi. ");
INSERT INTO nkr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Gai mee moomuna o de manu ne ngadi magau laa, ma mee moomuna o de manu gu daia i dahi manu alasala, goodou e maua i de hai ai oodou hegau, aagai goodou e dee gai donu mee nei. ");
INSERT INTO nkr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Gai tangada e gaina mee moomuna o de manu e hai ai laa ssigidaumaha dudu ange gi Tagi Maolunga e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Goodou e dee alaange donu i de gai dodo o dahi manu lele aabe se manu dolodolo, i mommee alodahi oodou e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Gai be goai e gaina dodo, gai ia e vvae gee donu mai i daho ono dangada.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Basa ange gi de gau Israel, hai ange, ‘Be goai naa huu e gaamai dahi sigidaumaha hagadanuaa magavaa gi Tagi Maolunga, gai ia gi vaaea hogi dahi mee ngadi gaavange mai i dana sigidaumaha mage gaavange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Gai ia gi gaamai dana ssigidaumaha dudu ga gaavange gi Tagi Maolunga; ia gi gaamai denga mee moomuna madali de aalanga o de aloalo, ga daodaohia age de aalanga laa i mada luu mada o Tagi Maolunga, e hai ai ssigidaumaha daodaohia age. ");
INSERT INTO nkr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Gai tangada haimeedabu gi gaavee denga mee moomuna laa gi duungia i honga de mommee o ssigidaumaha, gai de aalanga laa go tuuhanga o Aaron ma ana dama daane. ");
INSERT INTO nkr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Gai de aalanga o de vae madau o ssigidaumaha hagadanuaa magavaa e gaavange gi tangada haimeedabu e hai ai donu duuhanga; ");
INSERT INTO nkr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","gai de aalanga o de vae madau go tuuhanga o tama daane a Aaron ne haia laa ssigidaumaha hagadanuaa magavaa i dodo ma mee moomuna. ");
INSERT INTO nkr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Go hiidinga au gu kave de aalanga o de aloalo e daodaohia age laa ma de aalanga o de vae madau o ssigidaumaha hagadanuaa magavaa a de gau Israel, ma gu gaavange gi tangada haimeedabu go Aaron ma ana dama, e hai delaadeu duuhanga mai i daho de gau Israel ga hano ai.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Deenei tuuhanga o Aaron ma ana dama mai i denga sigidaumaha dudu ange gi Tagi Maolunga, gai ne vvae ange gi gilaadeu i de laangi olaadeu ne hagadabu ai gi ni dangada haimeedabu, e hai hegau ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","De laangi laa gai Tagi Maolunga ne hagadaba, bolo de gau Israel gi gaavange de mee nei gi gilaadeu; de mee nei se hainga ange gi olaadeu atangada alodahi e loomai i muli. ");
INSERT INTO nkr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Aanei hainga o ssigidaumaha dudu, ma ssigidaumaha o grain, ma ssigidaumaha o haisala, ma ssigidaumaha o tagasala, ma ssigidaumaha o de hagadabu, aama ssigidaumaha hagadanuaa magavaa, ");
INSERT INTO nkr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","a Tagi Maolunga ne tala ange gi Moses i honga de mounga go Sinai, i de laangi aana ne tala ange ai gi de gau Israel, gilaadeu gi gaamai alaadeu sigidaumaha ange gi Tagi Maolunga, i de vao o Sinai. ");
INSERT INTO nkr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Gai Tagi Maolunga ne basa ange gi Moses, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Gaamai Aaron ma ana dama daane, ma denga malo dabu, ma denga lolo hagadabu, aama de kaau daane e hai ai ssigidaumaha o haisala, ma e lua ssiibi daane, ma e dahi gede pelaoaa e deai mee hagahua iai; ");
INSERT INTO nkr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","gai koe ga hagabuni mai de hagabuulingaa dangada o Israel alodahi gi de haitoga o de hale malo hagabuni.” ");
INSERT INTO nkr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Gai Moses ne hai donu ga bei muna a Tagi Maolunga gu tala ange gi de ia, gai de hagabuulingaa dangada gu hagabuni i de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Gai Moses ne hai ange gi de hagabuulingaa dangada, “Aanei mee a Tagi Maolunga gu tala mai gidaadeu gi haia.” ");
INSERT INTO nkr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Gai Moses ga gaamai Aaron ma ana dama daane ga hagagilimalali gilaadeu i vai. ");
INSERT INTO nkr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Gai ia ga hakahu ange Aaron i dono malo belee, ga nnoa lo tono ungaalodo, ma de hakahu ange ia i de malo laa daha, ga hagauda ange de ephod gi de ia ga nnoa i de malo hagalaagii e nnoa ai laa de ephod. ");
INSERT INTO nkr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gai ia ga hagauda ange gi de ia de mee dau i hadahada, gai ia ga hhao ange de Urim ma de Thummim gi lo te mee dau i hadahada. ");
INSERT INTO nkr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Gai ia ga dugu ange de goobai malo gi honga dono biho, ga nnoa ange talaa baalanga goolo gi ma te goobai laa, go de hau goolo dabu, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Gai Moses ga poo mai de lolo hagadabu, ga hagasulu ai de tabernacle ma mee alodahi i ono lodo, ga hagadabu ai mee laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Gai ia ga hagatoo madaua ange hanu lolo gi honga de mommee o ssigidaumaha i e hidu hanonga, ga hagadabu ai de mommee o ssigidaumaha ma ono goloa alodahi, ma taaba ma ono dagelo. ");
INSERT INTO nkr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Gai ia ne llingi ange hogi hanu lolo hagadabu laa gi honga de biho o Aaron ga hagasulu ai aama de hagadabu ai ia. ");
INSERT INTO nkr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Gai Moses ga gaamai hogi denga dama daane a Aaron, ga hakahu ange gilaadeu i olaadeu malo belee, ga noonooa olaadeu ungaalodo, ma de noonooa ange olaadeu goobai gi honga olaadeu biho, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ia ne gaamai de kaau e hai ai ssigidaumaha o haisala, gai Aaron ma ana dama daane ne dugu ange olaadeu lima gi honga de biho o de manu laa. ");
INSERT INTO nkr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Gai Moses ga daa gu magau de manu laa ga hagasulu ange dono madannia gi lodo ono dodo, ga hulu ange gi denga hanga i honga de mommee o ssigidaumaha, ga hagagilimalali ai de mommee o ssigidaumaha laa. Gai ia ga llingi ange denga dodo e doe laa gi tahido o de mommee o ssigidaumaha, e hagadabu ai, gai gi gilimalali ai. ");
INSERT INTO nkr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Gai ia ne kave denga mee moomuna alodahi e pigi ange gi denga dae, ma mee moomuna o de ade, ma luu kidney ma denga mee moomuna iai, ga dudu i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Aagai ia gi gaavee de kaau laa ma dono gili, ma ono kano, ma ono duudae gi duungia i tua de mommee nnoho gaainga, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Aagai ia ga gaamai hogi ssiibi daane e hai ai laa ssigidaumaha dudu; gai Aaron ma ana dama daane ga dugu ange olaadeu lima gi honga de biho o de manu laa. ");
INSERT INTO nkr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Gai Moses ne daa de manu laa gi magau ga dabudabui ange ono dodo gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Gai ia gi duuduudia ssiibi daane laa, ga dudu de biho, ma denga aalanga aama denga mee moomuna. ");
INSERT INTO nkr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Gai ia ga hhui denga dae ma denga vae i vai, gai Moses ga dudu ssiibi daane laa alodahi i honga de mommee o ssigidaumaha, e hai ai ssigidaumaha dudu, se mee nnamu kala e hai i de ahi ange gi Tagi Maolunga, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ia ne gaamai hogi ssiibi daane ange laa, go ssiibi daane e hai ai de hagadabu; gai Aaron ma ana dama daane ga dugu ange olaadeu lima gi honga de biho o de manu laa. ");
INSERT INTO nkr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Gai Moses ga daa gi magau de manu laa, ga kave hanu ono dodo ga hulu ange gi honga de hiihii talinga madau o Aaron, ma honga de madannia madua o dono lima madau, aama honga tabuvae madua i dono vae madau. ");
INSERT INTO nkr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Gai Moses ga gaamai hogi denga dama daane Aaron, gai ia ga hulu ange hanu dodo gi honga hiihii o olaadeu dalinga madau ma honga madannia maatua o olaadeu lima madau, aama honga dabuvae maatua o olaadeu vae madau; gai Moses ga dabudabuia ange dodo e doe gi luu baasi o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Gai Moses ga kave denga mee moomuna ma de muli iai laa mee moomuna, ma mee moomuna alodahi e pigi ange laa gi honga denga dae, ma mee moomuna alodahi o de ade, ma luu kidney ma mee moomuna iai, ma de aalanga o de vae madau. ");
INSERT INTO nkr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Gai ia ne kave mai i lo te gede iai pelaoaa dee hagahua gu hagadabu ange laa gi Tagi Maolunga, dahi keege dee hagahua, ma dahi keege gu hilo ange lolo aagena, aama dahi besgede, ga dugu ange gi honga o denga mee moomuna ma de aalanga o de vae madau laa. ");
INSERT INTO nkr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Gai ia ne gaavange mee nei gi lo te lima o Aaron ma lodo lima o ana dama daane, gai gilaadeu ga daodaohi age mee laa e hai ai ssigidaumaha daodaohia age i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Gai Moses ga ahe ange ga kave gee mee laa mai i lodo olaadeu lima, ga dudu i honga de mommee o ssigidaumaha madali ssigidaumaha dudu, e hai ai ssigidaumaha o de hagadabu, se sigidaumaha nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Gai Moses ga kave de aalanga o de aloalo ga daodaohi age, e hai ai ssigidaumaha daodaohia age i mada luu mada o Tagi Maolunga; deenei tuuhanga o Moses mai i ssiibi daane ne hai ai laa de hagadabu, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Gai Moses ne kave hanu lolo hagadabu ma hanu dodo mai i honga de mommee o ssigidaumaha, ga hagatoo madaua ange gi honga o Aaron ma ono malo, ma honga o ana dama daane ma olaadeu malo. Gai ia ga hagadabu ai Aaron ma ono malo, aama ana dama daane ma olaadeu malo. ");
INSERT INTO nkr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Gai Moses ga hai ange gi Aaron ma ana dama daane, “Gaavee denga kano manu nei ga boale i gaogao de haitoga o de hale malo hagabuni, gai goodou ga gai ai madali denga pelaoaa mai i lo te gede iai pelaoaa gu hagadabu laa, bei dagu hai gu tala adu ai laa bolo go Aaron ma ana dama e gaina mee nei. ");
INSERT INTO nkr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Gai goodou gi duungia donu mee alodahi e doe i kano manu ma denga pelaoaa nei i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Gai goodou e dee ssao donu e hulo gee mai i de hale malo hagabuni i e hidu laangi, ga dae ai gi de odi ange laangi o doodou hagadabu, i hiidinga e hidu laangi oodou e hagadabu ai. ");
INSERT INTO nkr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Gai mee alodahi ne hai nei anailaa nei ga tala ai oodou haisala, go Tagi Maolunga ne daalaa mai. ");
INSERT INTO nkr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Gai goodou nnoho saele donu huu i gaogao de haitoga o de hale malo hagabuni i e hidu laangi ma e hidu boo, ga hai ai hegau a Tagi Maolunga gu tala adu gi goodou, gi dee maakau ai goodou; go hiidinga gu lava i de tala mai au gi daalaa adu gi goodou.” ");
INSERT INTO nkr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Gai Aaron ma ana dama daane ne hai donu ga bei mee alodahi a Tagi Maolunga gu tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Gai de valu laangi huu i dua mee laa, gai Moses ga hagahi Aaron ma ana dama daane, aama denga daane maatua o Israel, ");
INSERT INTO nkr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","gai ia ga hai ange gi Aaron, “Gaavee dahi kaau gauligi e hai ai ssigidaumaha o haisala, ma dahi ssiibi daane e hai ai ssigidaumaha dudu, gai e deai mee baubau i olaau angaanga, gai koe ga hai ai ssigidaumaha i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Gai koe basa ange gi de gau Israel hai ange, ‘Goodou gaavee dahi guudi daane e hai ai ssigidaumaha o haisala, ma dahi kaau gauligi ma dahi ssiibi gauligi gu dagidahi olaau ngadau, gai e deai mee baubau i olaau angaanga e hai ai ssigidaumaha dudu, ");
INSERT INTO nkr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ma dahi kaau daane ma dahi ssiibi daane e hai ai ssigidaumaha hagadanuaa magavaa i mada luu mada o Tagi Maolunga, madali dahi sigidaumaha o grain e hilo laa maa lolo; i hiidinga ailaa nei gai Tagi Maolunga e hakide adu naa gi goodou.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Gai gilaadeu ne gaamai gi ma te hale malo hagabuni, mee a Moses gu tala ange gi gilaadeu, gai de hagabuulingaa dangada alodahi ne loomai ga tuu i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Gai Moses ga hai ange, “Aanei mee a Tagi Maolunga e tala adu goodou gi haia, gi gidee ai e goodou de mahamaha o Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Gai Moses ga hai ange gi Aaron, “Hannoo gi gaogao de mommee o ssigidaumaha haia ai ssigidaumaha o haisala, aama ssigidaumaha dudu, e tala ai oo haisala ma haisala o de huaadangada; gai koe ga hai ai ssigidaumaha a dangada e tala ai olaadeu haisala, bei de hai a Tagi Maolunga gu tala mai ai.”  ");
INSERT INTO nkr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Gai Aaron ne hano gi gaogao de mommee o ssigidaumaha, gai ia ga daa gu magau de kaau gauligi e hai ai laa ssigidaumaha o haisala e tala ai ono haisala donu. ");
INSERT INTO nkr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Gai dana dama daane ga gaavange denga dodo gi de ia, gai ia ga hagasulu ange dono madannia gi lodo dodo laa ga gaavange gi denga hanga i honga de mommee o ssigidaumaha, gai ga llingi ange dodo e doe gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Aagai ia ga dudu denga mee moomuna ma luu kidney aama denga mee moomuna hugadoo o de ade, mai i de manu o ssigidaumaha o haisala i honga de mommee o ssigidaumaha, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Gai ia gi gaavee denga kano ma gili gi tua de mommee nnoho gaainga ga dudu ai i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Gai ia ne daa hogi de manu o ssigidaumaha dudu; gai ana dama ga gaavange denga dodo gi de ia, gai ia ga dabudabui ange gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Gai gilaadeu ga gaamai gi de ia denga aalanga o de manu o ssigidaumaha dudu aama de biho; gai Aaron ga dudu mee laa i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Gai ia ga hhui denga dae ma denga vae, ga dudu madali ssigidaumaha dudu i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Gai Aaron ga gaamai hogi ssigidaumaha a de gau Israel; ia ga kave de guudi e hai ai ssigidaumaha o haisala o dangada, ga daa gu magau ga hai ai ssigidaumaha, bei de hai ne hai ai ssigidaumaha o haisala i taamada. ");
INSERT INTO nkr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Gai ia ga gaamai de manu o ssigidaumaha dudu, ga hai ai ssigidaumaha bei de hai gu tala ai laa. ");
INSERT INTO nkr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Gai ia ga gaamai denga grain e hai ai laa ssigidaumaha, gai ia ga puli hanu ga dudu i honga de mommee o ssigidaumaha, madali ssigidaumaha dudu e hai laa i taiao. ");
INSERT INTO nkr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Gai ia ga daa de kaau daane ma ssiibi daane laa ga hai ai ssigidaumaha hagadanuaa magavaa ange gi dangada; gai dana dama daane ga gaavange gi de ia denga dodo, gai ia ga dabudabui ange gi luu baasi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aagai denga mee moomuna o de kaau daane ma ssiibi daane laa — go de muli iai laa mee moomuna, ma mee moomuna i denga dae, ma luu kidney, aama mee moomuna i luu baasi de ade — ");
INSERT INTO nkr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","gai gilaadeu ne dugu ange mee nei gi honga o denga aalanga o de aloalo, gai Aaron ga dudu mee moomuna laa i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Gai Aaron ga poo denga aalanga o de aloalo ma aalanga o de vae madau, ga daodaohia age e hai ai ssigidaumaha daodaohi age, i mada luu mada o Tagi Maolunga, bei de hai a Moses gu tala ange ai laa. ");
INSERT INTO nkr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Gai Aaron ne haalo ange luoono lima gi honga o dangada ga hagamanuuia gilaadeu. Gai ia ga iho mai i de mommee ne hai ai ssigidaumaha o haisala ma ssigidaumaha dudu, aama ssigidaumaha hagadanuaa magavaa. ");
INSERT INTO nkr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Gai Moses ma Aaron ne hulo ga ulu gi lo te hale malo hagabuni; gai de masavaa olaau ne ssao mai ai gai gilaau ga hagamanuuia de huaadangada, gai dangada gu gidee de mahamaha o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","De ahi gu hano iho i daho Tagi Maolunga ga dudu ssigidaumaha dudu ma mee moomuna, i honga de mommee o ssigidaumaha laa. Gai de masavaa huu a dangada alodahi ne gidee ai de mee laa, gai gilaadeu ga hevaalogi, ga ino gi honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Gai luu dana daane a Aaron go Nadab ma Abihu, ne kave e dagidahi mee e hhao ai denga maga ahi, ga hhao ange maga ahi gi lodo luu mee laa, ma de dugu ange mee maanongi gi honga maga ahi laa, gai gilaau ga hai ssigidaumaha i ahi e dee alaange de hai, i mada luu mada o Tagi Maolunga, go mee e dee hai. ");
INSERT INTO nkr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Gai de ahi ne humai i mada luu mada o Tagi Maolunga ga dudu gilaau, gai gilaau gu maakau i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Gai Moses ne hai ange gi Aaron, “Aanei muna a Tagi Maolunga gu tala ma gu hagadaba: ‘Au e hagaago ange gi gilaadeu e loomai e hagapaa mai gi de au bolo au e dabu; gai dangada alodahi gi hagamahamaha ina au i olaadeu daha.’ ” Gai Aaron gu dee muu. ");
INSERT INTO nkr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Gai Moses ga hagahi Mishael ma Elzaphan, luu dama daane a Uzziel, taina o tamana o Aaron, ga hai ange gi gilaau, “Gooluu loomai sabaia luooluu daina gaavee gee mai i lo te mommee dabu, mage gaavee gi tua de mommee nnoho gaainga.” ");
INSERT INTO nkr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Gai gilaadeu ga loomai ga saabai luoolaau daina ma olaau malo belee, ga kave gi tua de mommee nnoho gaainga, bei de hai a Moses gu tala ange ai laa. ");
INSERT INTO nkr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Gai Moses ga hai ange gi Aaron, ma luaana dama daane go Eleazar aama Ithamar, “Goodou e dee hai gi lausamua oodou biho, be e saesae oodou malo gi dee maakau ai goodou, gai dae mai ai de lili o Tagi Maolunga gi honga o de huaadangada. Gai oodou daina go de gau Israel alodahi e tangi naa i hiidinga o dangada a Tagi Maolunga ne daa ga maakau i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Gai goodou aude ssao donu gi hulo gee mai i lo te hale malo hagabuni, goodou kana maakau; i hiidinga goodou gu hagasulu i de lolo dabu a Tagi Maolunga.” Gai gilaadeu ne hai donu ga bei muna a Moses. ");
INSERT INTO nkr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Gai Tagi Maolunga ne basa ange gi Aaron, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Goodou ma au dama daane e dee unu uvaini ma mee vii, i de masavaa oodou e ulu ai gi lo te hale malo hagabuni, gi dee maakau ai goodou. De mee nei se hainga gu hagasauaa adu gi goodou ma oodou atangada alodahi ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Goodou gi vaaea gee mee dabu mai i mee e dee dabu, ma mee e dee gilimalali mai i mee gilimalali; ");
INSERT INTO nkr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","gai goodou agoago ina ange de gau Israel i muna alodahi a Tagi Maolunga gu hagasauaa ma gu tala ange gi Moses.” ");
INSERT INTO nkr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Gai Moses ga hai ange gi Aaron ma luaana dama daane goi mouli laa huu, go Eleazar ma Ithamar, “Goodou gaavee hanu grain e doe mai i ssigidaumaha dudu ange gi Tagi Maolunga, ma gi haia ai hanu pelaoaa dee hagahua ga gai i gaogao de mommee o ssigidaumaha, i hiidinga mee nei e dabu mmao; ");
INSERT INTO nkr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","gai goodou ga gai mee nei i de mommee dabu, i hiidinga deenei doodou duuhanga ma au dama, mai i denga sigidaumaha a Tagi Maolunga e hai i de ahi; go hiidinga ni muna niiana gu tala adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Aagai de aalanga o de aloalo e daodaohi age laa, ma de aalanga o de vae e hai ai laa ssigidaumaha, goodou ma oodou dama daane ma oodou damaa hine alodahi e maua i de gai. Gai goodou gaina i dahi mommee gilimalali; mee nei gu gaavadu gi goodou ma oodou dama e hai ai doodou duuhanga mai i sigidaumaha hagadanuaa magavaa a de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Gai de aalanga o de vae e hai ai laa ssigidaumaha ma de aalanga o de aloalo e daodaohi age laa, gi gaamai madali denga mee moomuna e hai ai laa ssigidaumaha dudu, gai goodou ga daodaohi age e hai ai ssigidaumaha daodaohi age i mada luu mada o Tagi Maolunga. Deenei doodou duuhanga ma au dama ga hano ai, bei de hai a Tagi Maolunga gu tala mai ai.” ");
INSERT INTO nkr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Gai Moses ne ssili gi iloo dagodo de guudi e hai ai laa ssigidaumaha o haisala, gai gu iloo bolo gu lava i de dudu. Gai Moses gu lili mmao i Eleazar ma Ithamar, luu dama daane a Aaron goi mouli laa, gai ia ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Gu aha goodou tee gai ai laa kano o de manu ne hai ai ssigidaumaha o haisala i de mommee dabu? Kano nei e dabu mmao, gai ne gaavadu gi goodou, gai goodou ga aau gee ai baubau o dangada, ma de tala ai olaadeu haisala i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Gooluu e iloo bolo dodo o de manu laa tee gaamai gi lo te mommee dabu, gai ne heohi donu doodou gai kano o de manu laa i lo te mommee dabu, bei dagu hai gu tala adu ai laa gi goodou.” ");
INSERT INTO nkr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Gai Aaron ne hai ange gi Moses, “Tilo, anailaa nei gai gilaau ne hai delaau ssigidaumaha o haisala ma delaau sigidaumaha dudu i mada luu mada o Tagi Maolunga; gai mee nei ne hai mai gi de au! Gai noo au ne gai ssigidaumaha o haisala, gai ne malangilangi ai naa Tagi Maolunga?” ");
INSERT INTO nkr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Gai ga langona huu e Moses muna laa, gai ia gu baba ono lodo. ");
INSERT INTO nkr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Gai Tagi Maolunga ne basa ange gi Moses ma Aaron, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Gooluu pasa ange gi de gau Israel, hai ange, ‘Aanei manu dolodolo i magavaa o manu alodahi i honga de henua oodou e gai: ");
INSERT INTO nkr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","go manu dolodolo e vvae lua laa olaadeu dabuvae, gai e luei mai alaadeu gai gu holo ga aahe ange ga maamaa. ");
INSERT INTO nkr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Gai hanu manu dolodolo e luei mai alaadeu gai gu holo ga aahe ange ga maamaa, aabe e vvae lua donu huu olaadeu dabuvae, goodou e dee gai: de gamelo e luei mai ana gai gu holo ga ahe ange ga maamaa, gai e dee vvae lua ono dabuvae; de manu nei e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","De coney e luei mai ana gai gu holo ga ahe ange ga maamaa, gai e dee vvae lua ono dabuvae; de manu nei e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","De rabbit e luei mai ana gai gu holo ga ahe ange ga maamaa, gai e dee vvae lua ono dabuvae; de manu nei e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Gai de biigi, e vvae lua ono dabuvae, gai e dee luei mai ana gai gu holo ga ahe ange ga maamaa, de manu nei e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Goodou e dee gai donu manu nei, goodou e dee poo ange hogi aagena i dua delaadeu maakau; manu nei e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Denga mee mouli e nnoho i lausedi ma lodo saalingaa vai, goodou e maua i de gai mamu e hanu olaadeu dala ma unahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Aagai manu alodahi i lausedi be go lodo vai e deai laa olaadeu dala be ni unahi, go manu vaaligiligi alodahi i lodo lausedi aama lodo vai, ni mee e hakino gee i doodou gai. ");
INSERT INTO nkr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Manu bee nei ni mee e dee gilimalali i oodou daha; goodou e dee gai olaadeu kano, gai denga manu maakau i manu nei gi ni mee hakino gee i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Gai mamu alodahi i lodo vai e deai laa olaadeu dala be ni unahi gi ni mee hakino gee i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Gai aanei manu llele oodou e hai gi ni mee hakino gee, goodou e dee alaange donu de gai mee nei, i hiidinga ni manu hakino gee: go de igele, ma de vulture, ma de vulture uli, ");
INSERT INTO nkr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ma de kite ma denga hagadaagangaa kite uli, ");
INSERT INTO nkr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ma denga hagadaagangaa raven, ");
INSERT INTO nkr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ma de ostrich, ma de nighthawk ma de seagull, ma denga hagadaagangaa hawk, ");
INSERT INTO nkr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ma de owl damaa mee, ma de cormorant, ma de owl laumalie, ");
INSERT INTO nkr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ma de owl tea, ma de owl lodo henua, ma de vulture, ");
INSERT INTO nkr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ma de stork, ma denga hagadaagangaa gava, ma de hoopoe, aama de gimoo lele. ");
INSERT INTO nkr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Gai denga manu llele vaaligiligi alodahi e hanu laa olaadeu bakau, gai e dagihaa olaadeu vae e tolo ai gi ni mee hakino gee i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Gai goodou e alaange i de gai denga manu vaaligiligi e hanu laa olaadeu bakau, gai e dagihaa olaadeu vae e tolo ai, gai olaadeu hadinga e hai gilaadeu gi maua i de lellele i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Goodou e maua i de gai denga hagadaagangaa itebuubuu, ma denga hagadaagangaa cricket, ma denga hagadaagangaa grasshopper. ");
INSERT INTO nkr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Aagai manu vaaligiligi alodahi e llele ange laa, gai e dagihaa olaadeu vae ni manu e hakino gee i oodou daha. ");
INSERT INTO nkr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Gai mee nei e hai naa goodou ga dee gilimalali; tangada e poo ange gi de manu gu magau laa, gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Gai tangada e dagidagina dahi manu magau i mee nei, e taa ono malo, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Gai manu dolodolo alodahi e dee vvae lua olaadeu dabuvae, aabe e dee luei mai alaadeu gai gu holo ga aahe ange e maamaa, e dee gilimalali; gai tangada e poo ange gi manu nei e hakino gee donu. ");
INSERT INTO nkr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Gai manu alodahi e tolo laa i olaadeu alohi vae ma lima e dee gilimalali i oodou daha; be goai e poo ange gi dahi manu bee nei gu magau laa, gai ia e dee gilimalali ga dae ai gi de ahiahi, ");
INSERT INTO nkr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","gai tangada e sabaia manu maakau bee nei gi daia ono malo, gai ia e dee gilimalali ga dae ai gi de ahiahi. Manu bee nei e dee gilimalali adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Gai aanei manu vaaligiligi e tolo i honga de gelegele e dee gilimalali adu gi goodou: go de mole, ma de gimoo, ma denga hagadaagangaa belu nnui alodahi, ");
INSERT INTO nkr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ma de belu, ma denga dabula, ma de galisi, ma de skink, ma de chameleon. ");
INSERT INTO nkr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Aanei manu vaaligiligi alodahi e dee gilimalali adu gi goodou; be goai e poo ange gi manu nei gu maakau ai, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Gai goloa alodahi e too ange hanu manu bee nei aagena i dua delaadeu maakau gu dee gilimalali; e dee hilihili be se goloa laagau be ni malo, be ni gili manu aabe ni beagi. Denga goloa nei e hagagilimalali i vai, gai e dee gilimalali ga dae ai gi de ahiahi; gai ga gilimalali ai. ");
INSERT INTO nkr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Gai noo dahi manu magau nei e too ange gi lodo gumedi hadu, gai mee alodahi i lo te gumedi laa gu dee gilimalali, gai goodou e hhoa donu de gumedi laa gi maoha. ");
INSERT INTO nkr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Gai gai alodahi gu ssii ange laa hanu vai mai i dahi gumedi hadu bee nei gu dee gilimalali; gai mee unu alodahi mai i lo te ssaa e dee gilimalali hogi. ");
INSERT INTO nkr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Gai mee alodahi gu too ange manu maakau bee nei aagena, e dee gilimalali; go de mommee e dao gai, be go de anibada dunu gai gu too ange aagena mee nei, e oha donu gi maoha. Mee nei gu dee gilimalali, gai goodou hagabinga ina bolo ni mee dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","De vai e sali age i lalo de henua be go de mommee e hagasahu ange aagena vai e gilimalali donu huu, aagai mee ange laa alodahi e dee gilimalali, noo gu paa aagena denga manu maakau. ");
INSERT INTO nkr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Gai noo hanu manu maakau bee nei gu too ange gi honga denga golee doo, gai goi gilimalali huu. ");
INSERT INTO nkr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Aagai noo denga golee gu gaavange vai aagena, gai dahi manu magau e doo ange gi ono elunga, gai gu dee gilimalali adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Noo dahi manu dolodolo oodou e alaange laa i de gai gu magau, gai tangada gu poo ange gi de manu magau laa gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Gai tangada e gaina kano o de manu magau laa gi daia ono malo, gai ia gu dee gilimalali ga dae ai gi de ahiahi. Gai tangada ne sabaia laa de manu magau nei gi daia hogi ono malo, gai ia gu dee gilimalali hogi ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Denga manu vaaligiligi alodahi e tolo saele i honga de gelegele e hakino gee; goodou e dee alaange de gai. ");
INSERT INTO nkr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Gai manu alodahi e tolo i honga de gelegele, be go manu e seesee i e haa vae, ma manu e lagolago ange olaadeu vae, goodou e dee gai, go hiidinga e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Goodou e dee hai gi hakino gee goodou i denga manu bee nei. Goodou e dee hai gi dee gilimalali goodou, ga hai ai ga hakino gee goodou. ");
INSERT INTO nkr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Go au go Tagi Maolunga doodou Maadua; goodou vaaea gee goodou ma de hai gi dabu goodou, go hiidinga au e dabu. Goodou e dee hai gi dee gilimalali goodou i hanu manu e tolo i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Go au Tagi Maolunga ne hagassao ina mai laa goodou i de henua go Egypt, gai au ga hai ai go doodou Maadua; deenei ai, goodou gi dabu, i hiidinga au e dabu. ");
INSERT INTO nkr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Gai aanei hainga o denga manu dolodolo ma manu llele ma manu alodahi e mouli i lodo vai, aama manu vaaligiligi alodahi e tolo laa i honga de gelegele, ");
INSERT INTO nkr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","gi iloo ai e goodou manu e dee gilimalali aama manu e gilimalali, ma manu oodou e alaange de gai aama manu oodou e dee alaange de gai.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Basa ange gi de gau Israel, hai ange, ‘Noo de hahine gu haanau dahi dama daane, gai ia e dee gilimalali i e hidu laangi, bei dono hai ne dee gilimalali ai laa i de masavaa e hai ai ono magi haahine. ");
INSERT INTO nkr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Gai de valu laangi naa huu o de gauligi daane, gai ia e tuu dagaholiage. ");
INSERT INTO nkr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Gai de hine laa gi noho ange i e matolu ma dolu laangi, ga dae ai gi dono gilimalali mai i ono dodo. Gai ia e dee poo ange gi denga mee dabu, ia e dee ulu hogi gi lo te mommee dabu, ga dae ai gi de odi ange laangi e hagagilimalali ai. ");
INSERT INTO nkr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Aagai noo ia e haanau dahi gauligi hahine, gai e lua uvigi oona e dee gilimalali ai, bei dono hai e dee gilimalali ai laa i de masavaa e hai ai ono magi haahine. Gai ia gi noho ange i e madaono ma ono laangi, ga dae ai gi de odi ange laangi e hagagilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Gai de masavaa naa huu e odi ange ai ono laangi e hai ai gi gilimalali, i dua dana gauligi daane be go dana gauligi hine, gai ia gi gaamai gi tangada haimeedabu i de haitoga o de hale malo hagabuni dahi ssiibi daane gu dahi ono ngadau e hai ai ssigidaumaha dudu, ma dahi pigeon aabe se manu kono e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Gai tangada haimeedabu ga hai ai ssigidaumaha i mada luu mada o Tagi Maolunga, e tala ai ono haisala; gai ia gu gilimalali mai i ono dodo. Aanei hainga ange gi de hine e hanaua laa dahi gauligi daane aabe se gauligi hahine. ");
INSERT INTO nkr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Gai noo ia e dee maua i de gaamai dahi ssiibi, gai ia gi gaamai e lua manu kono, aabe e lua pigeon, dahi e hai ai ssigidaumaha dudu, gai de manu ange laa e hai ai ssigidaumaha o haisala. Gai tangada haimeedabu ga hai ai ssigidaumaha e tala ai ono haisala, gai ia gu gilimalali.’ ”  ");
INSERT INTO nkr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Gai Tagi Maolunga ne hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“De masavaa naa huu e dahi ai mee e hua, be se mangeo i de gili, aabe se mee augaua i de angaanga o tangada, bei dagodo o de magi lebelaa, gai gaamai ia gi daho tangada haimeedabu go Aaron, aabe go daho dahi ono hagadiilinga, gu hai laa gi se dangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Gai tangada haimeedabu gi diiloo dagodo o de gili laa, gai noo huluhulu i luu baasi gu tea gai gu gelo, gai de mee nei gu se magi lebelaa, gai ia gi hagadaba bolo tangada laa gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Aagai noo tuulanga laa gu tea, gai e dee gelo, gai denga huluhulu iai tigi hulo e tea, gai tangada haimeedabu gi vaaea gee tangada laa mai i daho dangada i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Gai tangada haimeedabu gi ahe ange gi diiloo mee laa, i dua de hidu laangi, gai noo ia e gidee bolo go tagodo mau donu huu, tigi dolo gi daha, gai ia gi vaaea gee tangada laa mai i daho dangada i e hidu ange langi. ");
INSERT INTO nkr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Gai tangada haimeedabu gi ahe ange gi diiloo mee laa i dua e hidu laangi, gai noo gu hagadaga ange de mahu, gai teai ange mee ne ssomo age i de gili o tangada, gai ia gi hagadaba bolo tangada laa gu gilimalali; de mee laa se damaa mangeo donu huu. Gai tangada laa gi daia ono malo, gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Aagai noo mangeo laa gu dolo gi daha, i dua dana hagaago ange gi tangada haimeedabu, e hagadonu ai bolo ia gu gilimalali, gai ia gi ahe mai ange gi daho tangada haimeedabu; ");
INSERT INTO nkr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","gai tangada haimeedabu gi ahe ange gi diiloo de mangeo laa, gai noo gu dolo gi daha, gai tangada haimeedabu gi hagadaba bolo tangada laa gu dee gilimalali; de mee laa go de magi lebelaa. ");
INSERT INTO nkr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","De masavaa naa huu o tangada e hai de magi lebelaa, gai gi gaamai ia gi daho tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Gai tangada haimeedabu ga tilo de mangeo laa, gai noo tuulanga laa gu tea ma de hua, denga huluhulu iai gu tea ma de augau ina, ");
INSERT INTO nkr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","gai de gili lebelaa laa gu dagodo donu i lo te angaanga, gai tangada haimeedabu gi hagadaba bolo tangada laa gu dee gilimalali. Gai ia e dee vvae gee ia mai i daho dangada, i hiidinga ia gu dee gilimalali donu. ");
INSERT INTO nkr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Noo tangada haimeedabu gu gidee bolo de mangeo loo gu ssomo i de angaanga alodahi o tangada laa, mai i de biho ga dae ai gi luoono vae, ");
INSERT INTO nkr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","gai tangada haimeedabu gi ahe ange gi diiloo, gai noo gu dohu dono angaanga alodahi i de gili lebelaa, gai tangada haimeedabu gi hagadaba bolo ia gu gilimalali. Go hiidinga mangeo laa gu odi i de tea, gai tangada laa gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Aagai de masavaa naa donu huu o mangeo laa ga aahe ange ai ga ssula age i dono angaanga, gai ia gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Gai tangada haimeedabu gi ahe ange gi diiloo mangeo laa, gai ia gi hagadaba bolo tangada laa gu dee gilimalali. Mangeo laa e dee gilimalali, i hiidinga go de magi lebelaa. ");
INSERT INTO nkr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Aagai noo denga mangeo laa e aahe ange ga tea, gai tangada gi ahe mai gi daho tangada haimeedabu, ");
INSERT INTO nkr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","gai tangada haimeedabu gi ahe ange gi diiloo, gai noo mangeo laa gu tea donu, gai ia gi hagadaba bolo tangada magi laa gu gilimalali; gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","De masavaa naa huu e somo ai dahi hagahoa i de angaanga o tangada gai gu mahu, ");
INSERT INTO nkr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","gai tuulanga laa gu hua ga mada tea aabe e mada mmea, gai ia gi hano gi hagaagona ange gi tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Gai tangada haimeedabu gi diiloo, gai noo tuulanga laa gu kii ange de gelo, gai huluhulu iai gu tea, gai tangada haimeedabu gi hagadaba bolo tangada laa gu dee gilimalali. Gai tuulanga o de hagahoa laa gu hano ma gu se magi lebelaa. ");
INSERT INTO nkr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Aagai noo tangada haimeedabu e tilo, gai ia gu gidee bolo denga huluhulu i de mommee laa e dee tea, gai tigi kii ange de gelo, gai gu hagadaga ange de mahu, gai ia gi vaaea gee tangada laa mai i daho dangada, i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Gai noo de mangeo laa e kii ange de dolo gi daha, gai tangada haimeedabu gi hagadaba bolo tangada laa gu dee gilimalali; ia gu iai dahi gili baubau. ");
INSERT INTO nkr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Aagai noo de mangeo laa go tagodo mau donu huu, tigi dolo gi daha, gai se duulanga donu huu niio dahi hagahoa gu mahu; gai tangada haimeedabu gi hagadaba bolo tangada laa gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Gai noo tangada gu vela dahi mommee i dono angaanga, gai de mommee laa gu mada mmea be gu mada tea, ");
INSERT INTO nkr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","gai tangada haimeedabu gi diiloo, gai noo huluhulu i de mommee laa gu tea, gai gu kii ange de gelo, gai de mangeo laa gu se gili lebelaa ne hagahale age i de mommee ne vela laa. Gai tangada haimeedabu gi hagadaba bolo tangada laa gu dee gilimalali; mee laa ni gili lebelaa. ");
INSERT INTO nkr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Aagai noo tangada haimeedabu gu tilo, gai denga huluhulu i de tuulanga laa e dee tea, gai tee kii ange de gelo, aagai gu hagadaga ange de mahu, gai tangada haimeedabu gi vaaea gee tangada laa mai i daho dangada i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Gai tangada haimeedabu gi ahe ange gi diiloo dagodo o mee laa, i dua de hidu laangi; gai noo de mangeo laa gu dolo gi daha, gai ia gi hagadaba bolo tangada laa gu dee gilimalali; de mee laa go de magi lebelaa. ");
INSERT INTO nkr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Aagai noo de mommee laa go tagodo mau donu huu, tigi dolo gi daha gai gu hagadaga ange de mahu, de mee laa ne hua donu huu i hiidinga gu vela. Gai tangada haimeedabu gi hagadaba bolo tangada laa gu gilimalali, i hiidinga se duulanga vela gu mahu. ");
INSERT INTO nkr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Noo dahi daane be se hine gu somo dahi mangeo i dono biho be go dono gumigumi, ");
INSERT INTO nkr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","gai tangada haimeedabu gi diiloo gi danuaa; gai noo de mangeo laa gu gelo, gai denga huluhulu iai e ganoango gai gu sogoisi, gai ia gi hagadaba bolo tangada laa gu dee gilimalali; denga mee laa ni gili gadigadi, gai se gili baubau gu somo i dono biho aabe go dono gumigumi. ");
INSERT INTO nkr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Aagai noo tangada haimeedabu e tilo de mangeo laa, gai e dee gelo, tigi ai hogi huluhulu uli ne ssomo ai, gai tangada haimeedabu gi vaaea gee tangada laa mai i daho dangada i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Gai dua naa huu e hidu laangi, gai tangada haimeedabu gi ahe ange diiloo mangeo laa; gai noo de mangeo laa tigi dolo gi daha, gai e deai huluhulu ganoango iai, gai tigi kii ange hogi de gelo, ");
INSERT INTO nkr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","gai tangada iai laa de mangeo laa gi dahia dono biho ma dono gumigumi, gai ia gi dee dahia de mommee e somo ai de mangeo laa; gai tangada haimeedabu gi vaaea gee tangada laa mai i daho dangada i e hidu ange laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Gai dua naa huu e hidu laangi, gai tangada haimeedabu gi ahe ange gi diiloo de mangeo laa, gai noo tigi dolo gi daha, gai tigi kii ange de gelo, gai ia gi hagadaba bolo tangada laa gu gilimalali. Gai tangada laa gi daia ono malo, gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Aagai noo de mangeo laa gu aahe ga dolo gi daha i dua de tala ange bolo ia gu gilimalali, ");
INSERT INTO nkr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","gai tangada haimeedabu gi ahe ange gi diiloo, gai noo mangeo laa gu dolo gi daha, gai tangada haimeedabu e dee tilo donu be hanu laa huluhulu ganoango iai; i hiidinga tangada laa gu dee gilimalali donu. ");
INSERT INTO nkr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Gai noo ia gu gidee bolo de mangeo laa go tagodo mau donu huu, gai gu ssomo ai denga huluhulu uli, gai gu mmahu ma gu dee gadigadi. Gai tangada laa gu gilimalali; tangada haimeedabu gi hagadaba bolo ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","De masavaa naa huu e ssula age ai hanu gili tea i de angaanga o dahi daane be se hine, ");
INSERT INTO nkr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","gai tangada haimeedabu gi diiloo gili laa, gai noo denga gili laa gu daamada de mmahu, gai gili laa ni mee donu huu ne maalanga age i dono angaanga; gai tangada laa e gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Noo tangada gu malili dono biho ga sula dono dumuagi, gai ia e gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Noo huluhulu i ma tono biho ma dono dumuagi o dahi gu malili, gai ia e gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Aagai noo ma tono biho ma dono dumuagi gu mada mmea ma de tea, gai de mee laa se gili baubau gu ssomo i lo tono dumuagi ma ma tono biho. ");
INSERT INTO nkr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Gai tangada haimeedabu gi diiloo tangada laa, gai noo gili ma tono biho ma dono dumuagi gu mada mmea ma de tea, bei dagodo o denga gili baubau, ");
INSERT INTO nkr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","gai tangada laa gu iai gili baubau, ia gu dee gilimalali. Gai tangada haimeedabu gi hagadaba bolo ia gu dee gilimalali, i hiidinga o de mangeo i biho. ");
INSERT INTO nkr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Gai tangada iai gili baubau bee nei gi gahu i malo duai, ga tili dono biho gi lausamua, gai ia gi haolia de bido gi lalo o dono ngudu, gai ia gi oo gi hagadaba, ‘E dee gilimalali! E dee gilimalali!’ ");
INSERT INTO nkr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Gai ia e dee gilimalali i taulooloa de ssomo o denga gili laa i de ia. Gai ia gi noho sogosogo i tua de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“De masavaa naa huu e hanu ai mee dongidongi i dahi malo — e dee hilihili be se malo e hai i huluhulu o denga manu be se malo linen, ");
INSERT INTO nkr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","e dee hilihili be ni malo llanga be malo diadia i linen aabe go huluhulu, be ni gili manu, aabe go hanu mee ange e hai laa i gili manu, ");
INSERT INTO nkr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","gai noo denga mee dongidongi i de malo, be se malo llanga be se malo diadia, be se gili manu, aabe go hanu mee ange ne hai i gili manu, gai e nuui aabe e mada mmea, gai gu dolo hogi gi daha, gai e hagaagona ange donu gi tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Gai tangada haimeedabu gi diiloo mee dongidongi laa, ga vvae gee de malo dongidongi laa i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Gai dua naa huu e hidu laangi, gai ia gi ahe ange gi diiloo de malo dongidongi laa. Gai noo mee dongidongi laa gu dolo gi daha i de malo, e dee hilihili be se malo llanga be se malo diadia, aabe se gili manu, gai mee laa ni mee dongidongi baubau; de malo laa gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Gai tangada haimeedabu gi duungia de malo laa, e dee hilihili be se malo llanga be ne diadia, be ni huluhulu manu be ni linen, aabe go hanu mee ne hai i gili manu, go hiidinga denga mee dongidongi i de malo laa gu iai de manu; de malo laa e dudu donu i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Aagai noo tangada haimeedabu e tilo, gai ia gu gidee bolo mangeo laa tigi dolo gi daha i de malo laa, e dee hilihili be se malo llanga be se malo diadia, aabe go hanu mee e hai i gili manu, ");
INSERT INTO nkr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","gai ia gi haia dangada laa gi daia de malo gu dongidongi laa. Gai ia vaaea gee de malo laa i e hidu ange laangi. ");
INSERT INTO nkr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Gai dua naa huu de taa de malo laa, gai tangada haimeedabu gi ahe ange gi diiloo; gai noo mee dongidongi laa tigi dagodo gee, gai e dee galemu naa donu noo tigi dolo gi daha, gai e dee gilimalali donu. Gai ia gi duungia de malo laa, e dee hilihili be go tua aabe go de aloalo o de malo iai mee dongidongi laa. ");
INSERT INTO nkr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Gai noo tangada haimeedabu e tilo, gai mee dongidongi i de malo laa gu llilo i dua de taa, gai ia gi saea de mommee nogo dongidongi laa ma gi aau gee, e dee hilihili be se gili manu, be se malo llanga, aabe se malo diadia. ");
INSERT INTO nkr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Aagai noo denga mee dongidongi e aahe ange ga ssula age ga dolo gi daha, e dee hilihili be se malo llanga be ne diadia, aabe ni gili manu, gai koe gi duungia mee alodahi gu dongidongi laa i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","De malo, be se malo llanga be ne diadia, aabe ni gili manu gu llilo laa denga dongidongi iai i dua de taa, gai ahe ange taa i de lua hanonga, gai gu gilimalali.” ");
INSERT INTO nkr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Deenei de hainga ange gi denga mee dongidongi i malo, e hai i huluhulu be ni linen, be ni malo llanga be ne diadia, aabe ni gili manu, gi iloo ai be e gilimalali aabe e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Deenei de hainga ange gi tangada magi lebelaa, i de laangi oona e hagagilimalali ai. Ia e hai gi humai gi daho tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Gai tangada haimeedabu gi hano gi tua de mommee nnoho gaainga gi diiloo ai tangada laa. Gai noo tangada laa gu ieiangi ono magi lebelaa, ");
INSERT INTO nkr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","gai tangada haimeedabu gi haia ia gi gaamai e lua manu llele gilimalali e mouli laa, ma dahi bido laagau cedar, ma hanu huga malo mmea aama dahi laa hyssop e hagagilimalali ai ia. ");
INSERT INTO nkr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Gai tangada haimeedabu gi hagadaba bolo gi daia dahi manu lele laa, i honga dahi gumedi hadu iai hanu vai hoou. ");
INSERT INTO nkr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Gai ia gi gaavee de manu lele ange laa, madali de bido laagau cedar ma denga huga malo mmea aama de laa hyssop, gi hagasulu ina ange gi lodo dodo o de manu lele ne daa laa, i honga de gumedi hadu iai laa vai hoou. ");
INSERT INTO nkr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Gai ia gi hagatoo madaua ina ange dodo laa gi honga o tangada gu ieiangi i de gili lebelaa; gai ia gi hagadaba bolo tangada laa gu gilimalali. Muli mai, gai ia gi dugua de manu lele ange laa gi lele gi lo te duu malaelae. ");
INSERT INTO nkr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Gai tangada gu ieiangi laa gi daia ono malo, mage dahia ono ngaangaaulu alodahi, ga gaugau i vai, gai ia gu gilimalali. Gai dua naa huu mee nei gai ia gu maua i de ahe mai gi de mommee nnoho gaainga, gai ia gi dee ulu i dono hale i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Gai dua naa huu e hidu laangi gai ia gi dahia dono biho ma dono gumigumi, ma luoono huluhulu mada, aama ngaangaaulu alodahi i dono angaanga. Gai ia gi daia ono malo, ga gaugau i vai, gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Gai de valu laangi naa huu gai ia gi gaavee e lua ssiibi daane e deai mee baubau i olaau angaanga, ma dahi ssiibi hahine gu dahi laa ono ngadau gai e deai mee baubau i dono angaanga, ma e dolu diba i diba e madaangahulu o dahi ephah pelaoaa lligi gu hilo ma lolo, ma dahi log lolo olive. ");
INSERT INTO nkr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Gai tangada haimeedabu gi haia tangada aana gu dai hagagilimalali laa, ma ana mee e sigidaumaha i mada luu mada o Tagi Maolunga, i gaogao de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Gai tangada haimeedabu gi gaavee dahi ssiibi daane laa gi haia ai ssigidaumaha o tagasala, madali de log lolo olive laa; gai ia gi daodaohi age ssigidaumaha laa i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Gai tangada haimeedabu gi daia ssiibi laa i de mommee e daa ai de manu o ssigidaumaha o haisala ma ssigidaumaha dudu i de mommee dabu laa. Gai de manu e hai ai ssigidaumaha o tagasala go tuuhanga o tangada haimeedabu, bei de manu e hai ai laa ssigidaumaha o tagasala; gai se mee dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Gai tangada haimeedabu gi gaavee hanu dodo o ssigidaumaha o tagasala gi hulu ina ange gi de hiihii o talinga madau o tangada e hagagilimalali laa, ma honga de madannia madua o dono lima madau, aama honga tabuvae madua o dono vae madau. ");
INSERT INTO nkr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Gai tangada haimeedabu gi gaavee hanu lolo gi liingia ange gi lo tono lima masui, ");
INSERT INTO nkr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ga hagasulu ange de madannia o dono lima madau, gi lodo lolo i lo tono lima masui laa, gai ia ga hagatoo madaua ina lolo laa i mada luu mada o Tagi Maolunga i e hidu hanonga. ");
INSERT INTO nkr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Gai ia ga hulu ange hanu lolo e doe laa i lo tono lima, gi honga de hiihii o talinga madau o tangada aana e hagagilimalali laa, ma honga de madannia madua o dono lima madau, ma tabuvae madua o dono vae madau, gi de mommee gu daakodo ai laa dodo o de manu e hai ai ssigidaumaha o tagasala. ");
INSERT INTO nkr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Gai tangada haimeedabu gi liingia ange lolo e doe i lo tono lima gi honga de biho o tangada e hagagilimalali laa. Gai ia ga tala ai haisala o tangada laa i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Gai tangada haimeedabu gi haia ssigidaumaha o haisala, e tala ai haisala o tangada e hagagilimalali laa mai i ono mee tee gilimalali ai laa. Muli mai gai ia gi daia de manu e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","gai ia gi haia ssigidaumaha dudu aama ssigidaumaha o grain i honga de mommee o ssigidaumaha. Deenei de hai a tangada haimeedabu e tala ai haisala o tangada laa, gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Aagai noo tangada laa e hagaau aloha e dee maua e ia i de gaamai mee nei, gai ia gi gaamai dahi ssiibi daane e hai ai ssigidaumaha o tagasala daodaohi age, e tala ai ono haisala, ma e dahi diba i diba e madaangahulu o dahi ephah o pelaoaa lligi gu hilo ma lolo e hai ai ssigidaumaha o grain ma dahi log lolo olive, ");
INSERT INTO nkr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ma e lua manu kono aabe e lua pigeon, go ana mee e mau i de gaamai; dahi luu manu lele laa e hai ai ssigidaumaha o haisala, gai dahi e hai ai ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Gai dua naa huu e valu laangi gai tangada laa gi gaamai mee nei gi daho tangada haimeedabu e hagagilimalali ai ia, i de haitoga o de hale malo hagabuni, i mada luu mada o Tagi Maolunga; ");
INSERT INTO nkr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","gai tangada haimeedabu gi gaavee ssiibi daane e hai ai laa ssigidaumaha o tagasala, ma de log lolo laa, ga daodaohi age e hai ai ssigidaumaha daodaohi age i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Gai tangada haimeedabu gi daia ssiibi daane e hai ai laa ssigidaumaha o tagasala, ga kave hanu ono dodo ga hulu ange gi de hiihii o talinga madau o tangada e hagagilimalali laa, ma honga de madannia madua o dono lima madau, aama honga tabuvae madua o dono vae madau. ");
INSERT INTO nkr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Gai ia gi liingia ange hanu lolo laa gi lo te alohi lima o dono lima masui, ");
INSERT INTO nkr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","gai ia ga hagasulu ange dono madannia madau gi lodo lolo laa, ga hagatoo madaua i mada luu mada o Tagi Maolunga i e hidu hanonga. ");
INSERT INTO nkr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Gai ia gi hulu ina ange hanu lolo i lo tono lima laa, gi de mommee mau aana ne hulu ange laa aagena dodo o ssigidaumaha o tagasala — go de hiihii o talinga madau o tangada e hagagilimalali laa, ma honga de madannia madua o dono lima madau, aama honga tabuvae madua o dono vae madau. ");
INSERT INTO nkr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Gai tangada haimeedabu gi liingia ange lolo e doe i lo tono lima, gi honga de biho o tangada e hagagilimalali laa, e tala ai ono haisala i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Gai tangada haimeedabu laa gi haia ssigidaumaha i luu manu kono laa aabe go luu pigeon a tangada laa ne mau mai; ");
INSERT INTO nkr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","dahi e hai ai ssigidaumaha o haisala, gai dahi e hai ai ssigidaumaha dudu, madali ssigidaumaha o grain. Deenei de hai a tangada haimeedabu ga tala ai haisala o tangada e hagagilimalali laa i mada luu mada o Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Deenei de hainga ange gi tangada lebelaa e dee maua laa i de hagao manu e hai ai ssigidaumaha e hagagilimalali ai ia. ");
INSERT INTO nkr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Gai Tagi Maolunga ne hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“De masavaa naa huu oodou e tae ai gi de henua go Canaan, go de henua aagu gu gaavadu e henua ai goodou, gai au gu hai gi hanu dongidongi i dahi hale i de henua laa, ");
INSERT INTO nkr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","gai tangada niiona de hale gi humai gi hai ange gi tangada haimeedabu, ‘Au gu gidee hanu mee be ni dongidongi i lo togu hale.’ ");
INSERT INTO nkr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Gai tangada haimeedabu gi haia gilaadeu gi aaua gee mee alodahi i lo te hale laa, i mua dono ulu e tilo mee dongidongi laa, gi deai ai se mee i lo te hale laa e hai ga dee gilimalali. Muli mai gai tangada haimeedabu ga ulu ga tilo lo te hale laa. ");
INSERT INTO nkr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Gai ia gi diiloo mee dongidongi i lo te hale alodahi; gai noo denga dongidongi i lo te hale laa gu mada nuui be gu mada mmea, gai noo gu hulo loo gi lodo, ");
INSERT INTO nkr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","gai tangada haimeedabu gi sao gi duaahaho, gai ia ga pono de hale laa ga hagamakaga i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Gai ia gi ahe mai ange gi diiloo de hale laa i dua e hidu laangi. Gai noo de hale alodahi gu dongidongi, ");
INSERT INTO nkr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","gai ia gi haia dangada gi aaua gi dilia denga hadu gu iai hakino gee laa gi dilia gi tua de aduhale. ");
INSERT INTO nkr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Gai ia gi haia dangada gi goigoia lodo lo te hale laa alodahi, ga kave mee ne goigoi laa ga tili gi dahi mommee dee gilimalali i tua de aduhale. ");
INSERT INTO nkr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Gai gilaadeu gi gaamai hanu hadu hoou gi suuia ai hadu ne aau laa, ma de hai hanu bela pigi ga lebu ai de hale laa. ");
INSERT INTO nkr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Gai noo mee dongidongi laa e aahe ange ga ssula age i lo te hale laa, i dua de aau gee hanu hadu ma de goigoi lo te hale laa ga lebu, ");
INSERT INTO nkr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","gai tangada haimeedabu gi ahe ange gi ulu gi diiloo, gai noo lo te hale laa gu dohu i denga mee dongidongi, gai ni mee dongidongi baubau; gai de hale laa gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Gai de hale laa e oohaa donu — denga hadu, ma laagau aama mee alodahi ne lebu ai laa — ga moolia ga kave ga tili gi tua de aduhale i dahi mommee e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Gai tangada e ulu i de hale laa i de masavaa gu pono ai laa, gai ia gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Gai tangada e seni aabe e gaimee i lo te hale laa e taa donu ono malo. ");
INSERT INTO nkr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Aagai noo tangada haimeedabu e humai ga tilo, gai denga mee dongidongi i lo te hale laa tigi dolo gi daha, i dua de lebu, gai ia gi hagadaba bolo de hale laa gu gilimalali, i hiidinga gu deai mee dongidongi iai. ");
INSERT INTO nkr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Gai ia gi gaavee e lua manu llele, madali dahi laagau cedar ma hanu huga malo mmea aama dahi laa hyssop e hagagilimalali ai de hale laa. ");
INSERT INTO nkr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Gai ia gi daia dahi luu manu lele laa i honga de gumedi hadu iai laa hanu vai hoou. ");
INSERT INTO nkr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Gai ia ga kave de laagau cedar ma de laa hyssop, ma huga malo mmea, madali de manu lele goi mouli laa, ga hagasulu ange gi lodo dodo o de manu gu magau laa ma lodo vai hoou laa, ga hagassii ange gi de hale laa i e hidu hanonga. ");
INSERT INTO nkr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Gai ia ga hagagilimalali ai de hale laa i dodo o de manu lele laa, ma vai hoou laa, ma de manu lele goi mouli laa, ma de laagau cedar ma de hyssop aama denga huga malo mmea laa. ");
INSERT INTO nkr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Gai ia gi dugua de manu lele e mouli laa, gi lele gi hano gi lo te duu malaelae, i tua de aduhale. Deenei dana hai e hagagilimalali ai de hale laa, gai de hale laa gu gilimalali.” ");
INSERT INTO nkr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Aanei hainga o denga hagadaagangaa gili baubau, ma gili gadigadi, ");
INSERT INTO nkr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ma denga mee dongidongi i malo ma lo te hale, ");
INSERT INTO nkr_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ma de mee hua be se maanuga aabe se duulanga augaua, ");
INSERT INTO nkr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","gi iloo ai be e gilimalali aabe e dee gilimalali. Aanei hainga o denga gili baubau aama mee dongidongi. ");
INSERT INTO nkr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Gai Tagi Maolunga ne hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Gooluu pasa ange gi de gau Israel hai ange gi gilaadeu: ‘De masavaa naa huu e ssali mai ai hanu vai i mee o taane, gai mee laa e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Gai e dee hilihili donu be goi ssali mai huu i de angaanga o tangada aabe gu tuu de ssali mai, mee nei e hai ia ga dee gilimalali; mee nei gu hai ia ma gu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Gai de moenga o taane e ssali mai i mee nei e dagodo ai laa gu dee gilimalali, gai mee alodahi oona gu noho ange aagena gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Gai tangada e poo ange gi moenga laa, gai ia gi daia ono malo ma de gaugau, gai ia gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Gai be goai e noho ange gi honga mee o tangada e ssali mai ai mee laa gu noho ange aagena, gai ia gi daia ono malo ma de gaugau, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Gai be goai e poo ange gi tangada e ssali mai ai mee laa, gai ia gi daia ono malo ma de gaugau, gai ia gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Gai noo tangada e ssali mai laa mee i de ia, e saavale ange gi dahi dangada gilimalali, gai tangada laa gi daia ono malo ma de gaugau, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Mee alodahi o tangada e gage ga savini ai e dee gilimalali, ");
INSERT INTO nkr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","gai be goai e poo ange gi mee o tangada laa ne gage ga savini ai, gai ia gu dee gilimalali ga dae ai gi de ahiahi. Gai be goai e sabaia mee laa, gi daia ono malo ma de gaugau, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Gai be goai naa huu o tangada e ssali mai ai mee baubau laa e poo ange aagena, gai ia tee hhui luoono lima i vai, gai ia gi daia ono malo ma de gaugau i vai, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Gai de gumedi hadu o tangada e ssali mai ai mee baubau gu poo ange aagena e hhoa donu gi maoha; gai denga gumedi laagau oona e poo ange aagena e hhui i vai. ");
INSERT INTO nkr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Gai de masavaa naa huu o tangada e ssali mai ai mee baubau e ieiangi ai, gai ia gi daalia gi hidu laangi i muli mai, gai ia ga taa ono malo ma de gaugau i vai hoou, gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Gai de hagavalu laangi, ia gi gaamai e lua manu kono aabe e lua pigeon gi Tagi Maolunga i de haitoga o de hale malo hagabuni, ga gaavange gi tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Gai tangada haimeedabu gi haia ssigidaumaha i luu manu llele laa; dahi e hai ai ssigidaumaha o haisala, gai dahi e hai ai ssigidaumaha dudu. Deenei de hai a tangada haimeedabu e hagagilimalali ai tangada e ssali mai ai laa, i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Gai noo dahi daane e ssali mai hanu bii i de ia, gai ia gi hakaugau ina dono angaanga alodahi i vai, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Gai denga malo ma gili manu gu baalau laa i denga bii e taa i vai, gai malo laa e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Gai noo dahi daane ma dahi hahine e hagahebaa, gai gilaau ngaadahi gu baalau i denga bii, gai gilaau gi gaugau i vai, gai gilaau e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Gai de masavaa naa huu o de hine e hai ai ono magi haahine, gai ia e dee gilimalali i e hidu laangi, gai tangada e poo ange gi de ia e dee gilimalali hogi ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Gai mee alodahi o de hine laa e dagodo ange aagena i de masavaa e hai ai ono magi e dee gilimalali, gai mee alodahi oona e noho ange aagena e dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Gai be goai naa huu e poo ange gi dono moenga, gai ia gi daia ono malo ma de gaugau i vai, gai ia gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Gai be goai naa huu e poo ange gi hanu mee oona gu noho ange laa aagena, gai ia gi daia ono malo ma de gaugau i vai, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Gai e dee hilihili donu be se moenga be go hanu mee ange oona ne noho ange aagena, gai be goai e poo ange aagena, gai ia gu dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Noo dahi daane e hagahebaa ma de hine gu hai laa ono magi, gai ia gu baalau i ono dodo, gai taane laa e dee gilimalali i e hidu laangi; gai moenga alodahi o taane laa ne baani ange aagena gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Noo dahi hahine gu hano ai todo i hanu laangi lagolago, bei de masavaa e hai ai laa ono magi i de malama, aabe e duudagi de ssali mai mee i de ia, i dua de hai ono magi, gai ia e dee gilimalali i taulooloa de ssali mai mee laa i de ia, bei laangi e hai ai ono magi haahine. ");
INSERT INTO nkr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Moenga alodahi oona ne baani ange aagena, i de masavaa e ssali mai ai dodo i de ia gu dee gilimalali, gai e bei ai hogi mee oona e noho ange aagena i de masavaa e hai ai ono magi i de malama, mee alodahi gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Gai tangada e poo ange gi mee laa gu dee gilimalali; gai ia gi daia ono malo ma de gaugau, gai ia e dee gilimalali ga dae ai gi de ahiahi. ");
INSERT INTO nkr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Aagai noo gu tuu de ssali mai mee i de hine laa, gai ia gi daalia gi hidu laangi gi muli mai, gai dua naa huu laangi e hidu laa gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Gai de valu laangi naa huu, gai ia gi gaamai e lua manu kono aabe e lua pigeon gi daho tangada haimeedabu, i de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Gai tangada haimeedabu gi haia ssigidaumaha o haisala i dahi manu lele laa, gai dahi e hai ai ssigidaumaha dudu. Deenei de hai a tangada haimeedabu e tala ai haisala o de hine laa i mada luu mada o Tagi Maolunga, i hiidinga o mee dee gilimalali ne ssali mai laa i de ia. ");
INSERT INTO nkr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Deenei dooluu hai e vvae gee ai de gau Israel i denga mee dee gilimalali, gi dee maakau ai gilaadeu i delaadeu hai ga dee gilimalali dogu mommee e noho ai i oodou daha.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aanei hainga o taane e ssali mai ai laa mee baubau, ma taane e ssali mai ai laa bii ga hai ia ga dee gilimalali, ");
INSERT INTO nkr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ma de hine gu dee gilimalali i ono magi haahine, ma taane be go de hine e ssali mai ai mee baubau, aama taane e hagahebaa ma de hine gu dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Gai Tagi Maolunga ne hai ange gi Moses, i dua de maakau o luu dama daane a Aaron, aanei luu dama ne maakau laa, i delaau hulo ga hagapaa ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Gai Tagi Maolunga ne hai ange gi Moses, “Daalaa ange gi doo daina go Aaron, ia gi dee humai gi lo te Aabi Dabu mmao, i lo te malo buibui i mada i mua o de pono o de tala haisala i honga de ngavesi o te hainga, i de masavaa aana e hilihili, gi dee magau ai ia. Go hiidinga au e hagasula mai i lo te hagausinga i honga de pono laa. ");
INSERT INTO nkr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Deenei de hai o Aaron e ulu ai gi de Aabi Dabu mmao laa: ia gi gaamai dahi kaau gauligi e hai ai ssigidaumaha o haisala, ma dahi ssiibi daane e hai ai ssigidaumaha dudu. ");
INSERT INTO nkr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Gai ia gi gahu i de malo gahu dabu e hai laa i linen, ma de malo huna linen, ga nnoa lo tono ungaalodo i de malo nnoa linen, ma de hagauda de goobai linen. Aanei denga malo dabu. Gai ia gi gaugau i mua dono gahu i malo nei. ");
INSERT INTO nkr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Gai ia gi gaavee mai i daho de gau Israel, e lua guudi daane e hai ai ssigidaumaha o haisala, ma e dahi ssiibi daane e hai ai ssigidaumaha dudu mai. ");
INSERT INTO nkr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Gai Aaron gi daia dahi kaau laa e hai ai ssigidaumaha o ono haisala donu, e tala ai ono haisala ma haisala o dono huaabodu. ");
INSERT INTO nkr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Gai ia gi gaavee luu guudi daane laa gi mada luu mada o Tagi Maolunga, i ma te haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Gai ia ga hai tada ange gi luu guudi laa — dahi ange gi Tagi Maolunga gai dahi ange gi Azazel. ");
INSERT INTO nkr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Gai Aaron gi gaamai de guudi ne hilihili ange gi Tagi Maolunga i tada, e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Aagai de guudi ne hilihili ange laa gi Azazel i tada, e gaamai gi mada luu mada o Tagi Maolunga e tala ai haisala o dangada, i de hai gi hano gi daho Azazel i de vao. ");
INSERT INTO nkr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Gai Aaron gi gaamai de kaau daane e hai ai ssigidaumaha o haisala ange gi de ia donu, e tala ai ono haisala ma haisala o dono huaabodu; gai ia gi daia de kaau laa e hai ai ssigidaumaha o ono haisala donu. ");
INSERT INTO nkr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Gai ia gi haoa gi honu dahi gumedi i denga maga ahi i honga de mommee o ssigidaumaha i mada luu mada o Tagi Maolunga, ma de hhao gi hoohonu luoono lima i denga mee maanongi gu mmili gi lligi; gai ia ga kave mee laa gi lo te malo buibui. ");
INSERT INTO nkr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Gai ia gi dugu ange mee maanongi laa gi honga denga maga ahi laa i mada luu mada o Tagi Maolunga, gi buu age ai de useahi o mee maanongi laa, gi honga de pono o de tala haisala, i honga ngavesi o de tala hagadonu, gi dee magau ai ia. ");
INSERT INTO nkr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Gai ia gi gaavee hanu dodo o de kaau daane laa ga hagatoo madaua ange gi de pono, ma de aloalo o de pono laa i dono madannia i e hidu hanonga. ");
INSERT INTO nkr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Gai ia gi daia de guudi e hai ai laa ssigidaumaha o haisala o de gau Israel, ga kave ono dodo gi lo te malo buibui, gai ia gi haia dodo laa bei dana hai ne hai ai laa dodo o de kaau daane: ia gi hagatoo madaua ina ange gi honga de pono o de tala haisala aama de aloalo o de pono laa. ");
INSERT INTO nkr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Gai ia e hai de mee nei e tala ai haisala o de Aabi Dabu mmao, i hiidinga de hakino gee ma de hagamaanege o de gau Israel, e dee hilihili donu be ni haisala aha alaadeu ne hai. Ia gi haia hogi bee nei de hale malo hagabuni, go de hale e duu laa i olaadeu magavaa ma alaadeu mouli dee gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Gai e deai ange donu se dangada e alaange de ulu i de hale malo hagabuni i de masavaa o Aaron e ulu ai e tala haisala i de Aabi Dabu mmao ga dae ai gi dono sao mai, i dua de tala ono haisala ma haisala o dono huaabodu, aama haisala o de huaadangada o Israel. ");
INSERT INTO nkr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Gai ia gi sao mai gi hano gi de mommee o ssigidaumaha i mada luu mada o Tagi Maolunga, ga hagagilimalali ai de mommee o ssigidaumaha. Gai ia gi gaavee hanu dodo o de kaau daane ma hanu dodo o de guudi laa ga hulu ange gi honga denga hanga e haa o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Gai ia gi hagatoo madaua ange hanu dodo gi honga de mommee o ssigidaumaha laa i dono madannia i e hidu hanonga, e hagadabu ai ma de hagagilimalali ai mai i dahulinga dee gilimalali a de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Gai de masavaa naa huu e lava ai dana hagagilimalali de Aabi Dabu mmao, ma de hale malo hagabuni aama de mommee o ssigidaumaha, gai ia gi gaamai de guudi goi mouli laa. ");
INSERT INTO nkr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Gai Aaron gi dugua ange luoono lima gi honga de biho o de guudi mouli laa, ga tala baubau o de gau Israel i honga de manu laa, ma olaadeu dee heohi, aama olaadeu haisala alodahi, ga dugua ange gi honga de biho o de guudi laa, ga gaavange gi tangada gu baba ange laa e hai de hegau laa, gai ia ga hai gi hano gi de vao. ");
INSERT INTO nkr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Gai de guudi laa ga hagauda ai olaadeu baubau alodahi ga kave gi de mommee e deai dangada e nnoho ai; gai tangada laa gi haia de guudi laa gi hano gi de vao. ");
INSERT INTO nkr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Gai Aaron gi ahe gi ulu i lo te hale malo hagabuni, ga hagaui ai ono malo linen ne gahu ai laa i de masavaa oona ne ulu ai gi lo te Aabi Dabu mmao, ga dugu i kilaa. ");
INSERT INTO nkr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Gai ia gi gaugau i vai i dahi mommee dabu, ga ahe ange gi ono malo donu, gai ia ga sao mai ga daa de manu e hai ai laa ssigidaumaha dudu ange gi de ia ma ssigidaumaha dudu a dangada, ga tala ai ono haisala donu ma haisala o de huaadangada. ");
INSERT INTO nkr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Gai ia gi duungia denga mee moomuna o de manu o ssigidaumaha o haisala i honga de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Gai tangada e dugua de guudi gi hano gi Azazel gi daia ono malo ga gaugau i vai, muli mai gai ia gu maua i de ahe mai gi de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Gai de kaau daane ma de guudi ne hai ai laa ssigidaumaha o haisala, ne kave laa hanu olaau dodo gi lo te Aabi Dabu mmao e tala ai haisala, gi gaavee gi dilia i tua de mommee nnoho gaainga; gai olaau gili ma kano aama olaau duudae gi duungia i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Gai tangada e gaavee laa mee laa ga duungia gi daia ono malo ga gaugau i vai, muli mai gai ia gu maua i de ahe mai gi de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","De hainga nei gu hagasauaa adu gi goodou ga hano ai: de hagamadaangahulu laangi naa huu o de hidu malama, gai goodou alodahi ma de gau henua gee i oodou magavaa gi hagahiikai, gai e deai hogi hegau oodou e hai; ");
INSERT INTO nkr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","go hiidinga de laangi nei se laangi e tala ai oodou haisala, ma de hagagilimalali ai goodou mai i oodou haisala alodahi. Gai gi gilimalali ai goodou i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","De laangi nei se Sabbath e hagammabu ai goodou ma de hagahiikai ai; de mee nei se hainga gu hagasauaa ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Gai tangada gu hagasulu laa i lolo ma de hagadabu gi se dangada haimeedabu i tuulanga o dono damana, gi haia de hegau go de tala haisala. Ia gi gahu i malo dabu e hai i linen; ");
INSERT INTO nkr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","gai ia ga hagagilimalali ai de Aabi Dabu mmao, ma de hale malo hagabuni aama de mommee o ssigidaumaha, ma de gau haimeedabu ma de huaadangada alodahi o Israel. ");
INSERT INTO nkr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Deenei de hainga gu hagasauaa adu gi goodou ga hano ai, gai de tala ai haisala e hai ange gi de gau Israel i e dahi hanonga i de ngadau.” Gai Moses ne hai mee laa, bei de hai a Tagi Maolunga gu tala ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Basa ange gi Aaron ma ana dama daane, aama de gau Israel alodahi hai ange, ‘E hagadaba Tagi Maolunga: ");
INSERT INTO nkr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Noo dahi dangada Israel e hai dana sigidaumaha i dahi kaau, be se ssiibi daane, aabe se guudi i lo te mommee nnoho gaainga aabe go tua, ");
INSERT INTO nkr_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ia tee gaamai gi de haitoga o de hale malo hagabuni e sigidaumaha ange gi Tagi Maolunga i ma te tabernacle o Tagi Maolunga — ia e haisala donu i hiidinga o dodo laa; gai ia e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","De hainga nei se hai, gi gaamai ai e de gau Israel alaadeu manu sigidaumaha, e daa laa i lo te duu malaelae gi daho Tagi Maolunga, ma tangada haimeedabu i de haitoga o de hale malo hagabuni, ga daa ai alaadeu manu e hai ai ssigidaumaha e hagadanuaa ai olaadeu magavaa ma Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Gai tangada haimeedabu gi dabudabui ange dodo laa gi de mommee o ssigidaumaha a Tagi Maolunga, i de haitoga o de hale malo hagabuni, ma de dudu denga mee moomuna e hai ai ssigidaumaha nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Gai gilaadeu e dee sigidaumaha ange donu gi denga ⌊diinonga e hagadulagi ange laa gi de⌋ guudi, ga haisala ai gilaadeu. Deenei de hainga gu hagasauaa ange gi gilaadeu ma olaadeu atangada alodahi i muli mai.’ ");
INSERT INTO nkr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Gai koe hai ange gi gilaadeu, ‘Tangada Israel aabe se dangada henua gee e noho i oodou daha, e haia laa dahi sigidaumaha dudu be go dahi sigidaumaha ange laa, ");
INSERT INTO nkr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","gai ia e dee gaamai gi de haitoga o de hale malo hagabuni e hai ai ssigidaumaha ange gi Tagi Maolunga, tangada laa e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Noo dahi dangada Israel be se dangada henua gee i oodou magavaa e gai kano manu iai dodo — gai au e hai baasi ange donu gi tangada e gaina kano iai dodo, ga vvae gee ia mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Go hiidinga de mouli o de mee mouli go lodo dodo iai, gai au gu dugu adu gi goodou e tala ai oodou haisala; i hiidinga go dodo e tala ai haisala o tangada, i hiidinga iai de mouli. ");
INSERT INTO nkr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Deenei ai, au gu tala ange gi de gau Israel, “E deai donu se goodou e gai dodo, de gau henua gee e noho i oodou magavaa e dee gai hogi dodo.” ");
INSERT INTO nkr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Gai be goai naa huu tangada Israel, be se dangada henua gee i oodou daha, e hano ga dili manu dolodolo be ni manu llele e gai laa, gai ia gi liingia ono dodo ga danu ange i gelegele, ");
INSERT INTO nkr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","go hiidinga de mouli o de mee mouli alodahi go ono dodo. Deenei ai, au gu hai ange gi de gau Israel, “Goodou e dee gai dodo o dahi mee mouli, i hiidinga de mouli o mee mouli alodahi go ono dodo; gai be goai e gaina mee nei, gai ia e vvae gee donu mai i daho ono dangada.” ");
INSERT INTO nkr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Gai dangada alodahi e gaina kano o dahi manu ngadi magau, be se manu ne daia i hanu manu alasala, e dee hilihili be se dangada Israel aabe se dangada henua gee, gai ia gi daia ono malo ma de gaugau i vai, gai ia e dee gilimalali ga dae ai gi de ahiahi; gai ia gu gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Aagai noo ia e dee taa ono malo aabe e gaugau, gai ia e hagaduasala donu i ono baubau.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Basa ange gi de gau Israel, hai ange gi gilaadeu, ‘Go au donu Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Goodou aude ago ange i hegau a dangada i Egypt, go de mommee oodou nogo nnoho ai i mua; goodou aude ago ange hogi i hegau a dangada i Canaan, go de henua aagu ga dagi nei goodou e kave aagena. ");
INSERT INTO nkr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Gai goodou haia gi bei agu muna gu hagamodu ma de daohi agu hainga gu hagasauaa. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Goodou daohia agu muna gu hagasauaa ma agu hagamodu, go mee e maua ai gi mouli tangada noo ia e hai hegau ai. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Gai e deai donu se goodou e dagodo haisala madali dono dangada donu. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Aude hagangadi mee ina doo damana i doo dagodo haisala madali doo dinana. Ia go doo dinana; aude dagodo haisala madali ia. ");
INSERT INTO nkr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Aude dagodo haisala ma de bodu o doo damana; e bei donu koe gu hagangadi mee doo damana. ");
INSERT INTO nkr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Aude dagodo haisala ma doo daina hahine, tamaa hine a doo damana, aabe go tamaa hine a doo dinana, e dee hilihili ia ne haanau i doo hale aabe go dahi mommee gee. ");
INSERT INTO nkr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Aude dagodo haisala ma tama daane a dau damaa hine, aabe go tamaa hine a dau damaa hine, e bei donu koe e hagangadi mee donu huu goe. ");
INSERT INTO nkr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Aude dagodo haisala ma tamaa hine ne hagadili i daho doo damana; ia se daina niiou. ");
INSERT INTO nkr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Aude dagodo haisala ma taina hahine o doo damana; ia go taina o doo damana. ");
INSERT INTO nkr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Aude dagodo haisala ma taina hahine o doo dinana, go hiidinga ia se daina donu niio doo dinana. ");
INSERT INTO nkr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Aude hagangadi mee ina taina daane o doo damana, i doo hano ga dagodo haisala ma dono bodu; ia se dinana niiou. ");
INSERT INTO nkr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Aude dagodo haisala ma de bodu o dau dama daane; ia go doo saulaba; aude dagodo haisala ma ia. ");
INSERT INTO nkr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Aude dagodo haisala ma doo maa; e bei donu koe e hagangadi mee doo daina daane. ");
INSERT INTO nkr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Aude dagodo haisala madali dahi dinana ma dana damaa hine. Aude dagodo haisala madali de mogobuna hahine o doo bodu; ia e hai dangada adu gi de goe. De mee nei se mee baubau donu. ");
INSERT INTO nkr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Aude hai bodu ange gi taina hahine o doo bodu, ga hagalili ai doo bodu, i de masavaa oona e mouli ai. ");
INSERT INTO nkr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Aude dagodo haisala ma dahi hahine i de masavaa oona e hai ai ono magi haahine. ");
INSERT INTO nkr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Aude dagodo haisala ma de bodu o tangada e baa adu gi de goe, koe e hai naa ga hakino gee goe i ono daha. ");
INSERT INTO nkr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Aude gaavange dahi au dama e sigidaumaha ange gi tiinonga go Molek, ga hagangadi mee ai de ingoo o doo Maadua. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Aude dagodo haisala ma taane bei de hai e hagahebaa ange ai laa de hine; go hiidinga se hegau donu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Aude dagodo haisala ma dahi manu dolodolo, ga hai ai ga hakino gee goe, gai de hine gi dee dagodo haisala hogi madali dahi manu dolodolo; de mee nei se mee donu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Goodou e dee hai gi hakino gee goodou i hegau bee nei, go hiidinga aanei dahulinga a denga huaahenua ange laa ne hai ga hakino gee ai gilaadeu, gai au ga hai gilaadeu gi hulo gee mai i oodou mada i mua. ");
INSERT INTO nkr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","De henua ne hakino gee hogi, gai au ne hagaduasala de henua i hiidinga ono baubau, gai de henua ga luei mai dangada e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Aagai goodou gi daohia agu hainga gu hagasauaa ma agu hagamodu. Gai goodou ma de gau henua gee i oodou daha gi dee haia denga mee hakino gee nei, ");
INSERT INTO nkr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","go hiidinga aanei dahulinga a dangada nogo nnoho i de henua i oodou mada i mua, gai de henua alodahi gu hakino gee. ");
INSERT INTO nkr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Gai de henua e lueia mai naa hogi goodou, i doodou hai ga hakino gee de henua, bei dana hai ne hai ai denga huaahenua nogo nnoho i de henua i mua doodou loomai. ");
INSERT INTO nkr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Gai tangada e haia hegau hakino gee nei, e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Deenei ai, goodou daohia agu muna gu tala adu gi goodou, gai goodou gi dee ago ange i dahulinga a de gau henua gee nogo nnoho i de henua i mua, gai goodou e dee hai gi hakino gee goodou, i doodou ago ange i alaadeu dahulinga. Go au donu go Iahweh doodou Maadua.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Basa ange gi de hagabuulingaa dangada o Israel, hai ange: ‘Goodou gi dabu, go hiidinga au e dabu, go au go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tangada gi hagadubu ina dono dinana ma dono damana, ma de daohi agu Sabbath. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Aude ino ange gi denga diinonga, aabe gi haia hanu diinonga baalanga gi daumaha ange aagena. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","De masavaa naa huu oodou e hai ai oodou ssigidaumaha hagadanuaa magavaa ange gi Tagi Maolunga, gai goodou haia gi malangilangi ai ia i goodou. ");
INSERT INTO nkr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Gai kano o de manu o dau ssigidaumaha, e maua i de gai i de laangi laa aama de laangi i ono dua; gai mee e doe, i dua luu laangi laa e dudu alodahi i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Gai noo dahi dangada e gai mee laa i dua e lua laangi, gai ssigidaumaha laa gu se mee hakino gee, gai de Maadua gu dee malangilangi ai. ");
INSERT INTO nkr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Gai tangada e gaina mee laa e hagaduasala donu, i hiidinga ia gu hai ma gu hakino gee mee gu hagadabu ange laa gi Tagi Maolunga; tangada laa e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","De masavaa naa huu oodou e hagihagi ai hua o oodou veelenga, gai goodou e dee hagihagi gi dae gi denga dege alodahi, aabe e ogo gi odi mee gu duuduu laa. ");
INSERT INTO nkr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Gai koe e dee hagihagia gi odi hua o au veelengaa grape, ma de ogo gi odi grape gu malili laa; aagai dugua ange mee nei maa de gau hagaau aloha, ma de gau henua gee. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Goodou aude gaiaa. Goodou aude hadu muna. Goodou aude hagadau daahanga ina goodou. ");
INSERT INTO nkr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Goodou aude hagatoo donu i dogu ingoo i de hadu muna, aabe gi hagangadi mee ina de ingoo o doodou Maadua. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Aude vaivai haia tangada i oo gaogao, aabe gi gaiaadia ana mee. Aude daohia de hagaoanga o tangada hai hegau ga dae ai gi de laangi i ono dua. ");
INSERT INTO nkr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Aude basa baubau i tangada longoduli, be gi dugua dahi mee gi laavea ai luoono vae, aagai koe gi madagu i doo Maadua. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Aude hagahaisala ina de hagamodu muna heohi; aude haia gi dagodo gee dau hai e hai ai tangada hagaau aloha ma tangada lava, aagai koe gi hagamodu ina muna o tangada e baa adu gi de goe i de heohi. ");
INSERT INTO nkr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Aude hano gi hagadele ina hanu muna hhadu i magavaa o dangada. Aude hai baasi ange gi tangada, gai balea ange tangada e baa adu gi de goe, i de masavaa e hagamodu ai ono muna. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Aude daohia doo lili i doo daina. Gai hagaseegina ia, gi dee dau adu ai ono haisala gi de goe. ");
INSERT INTO nkr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Aude suuia ange de baubau, aabe e golo age doo lili i dahi oo dangada, aagai koe aloha i tangada e baa adu gi de goe, bei doo aloha donu i de goe. Go au go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Koe gi daohia agu mee gu hagasauaa. Aude hagahai dama ina dau manu i dahi hagadaagangaa manu gee. Aude dooa dau veelenga i e lua hagadaagangaa golee. Aude gahu i malo e hai i e lua hagadaagangaa huga malo. ");
INSERT INTO nkr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Noo dahi daane gu dagodo haisala ma dahi hahine hai hegau, gu lava laa i de hagatoo donu ange gi dahi daane gee, aagai tigi se dangada ne hagao ina ia, aabe ia gu hai gi se hine ilaage, gai gilaau ngaadahi e hagaduasala donu. Aagai e dee daa gilaau gi maakau, go hiidinga de hine laa se hine tigi ilaage. ");
INSERT INTO nkr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Gai taane laa gi gaamai dahi ssiibi daane gi de haitoga o de hale malo hagabuni, e hai ai ssigidaumaha o tagasala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Gai tangada haimeedabu ga tala ai ono haisala, i ssiibi daane e hai ai laa ssigidaumaha o tagasala i mada luu mada o Tagi Maolunga; gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","De masavaa naa huu oodou e tae ai gi de henua, gai goodou ga doo denga hagadaagangaa manu ssomo iai hua gai, gai goodou e dee alaange de gai olaadeu hua. E dolu ngadau oodou e dee gai ai olaadeu hua. ");
INSERT INTO nkr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Gai de haa ngadau naa huu gai olaadeu hua alodahi e dabu, gai se ssigidaumaha e tuhi ai Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Aagai de lima ngadau naa huu, gai goodou gu maua i de gai hua oodou e hagihagi. Mee nei se hai gi hhua lagolago ai oodou manu. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Goodou e dee gai kano manu iai dodo. Goodou e dee hai buubuu e tala i mee e dee iloo, aabe e hai denga huuhuaa mee. ");
INSERT INTO nkr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Goodou e dee duuduu ngaangaaulu i mada oodou biho, aabe e tuu gi podo huluhulu i oodou gumigumi ⌊i doodou hinangalosaa⌋. ");
INSERT INTO nkr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Gai goodou e dee selesele oodou angaanga i hiidinga o dahi dangada magau aabe e maaga oodou angaanga. Go au go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Aude hagangadi mee ina dau damaa hine i dau hai ia gi se hine hai be se manu, gi dee laumalie ai de hai be se manu i honga de henua, gai gu honu i de baubau. ");
INSERT INTO nkr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Goodou gi daohia agu Sabbath ma de hagadubu dogu mommee dabu. Go au go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Aude hano gi denga hilohilo ma eidu, be saalaa ange gilaadeu e pasa ange gi hagasaalunga o de gau maakau, gai gilaadeu ga hai ai ga dee gilimalali goodou. Go au go Iahweh doo Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Koe gi duu age gi hagadubulia tangada gu sinaa de biho, ma de hagadubu tangada madumadua, gai koe gi madagu i de Maadua. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Aude vaivai haia tangada henua gee e noho laa madali goodou i doodou henua. ");
INSERT INTO nkr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Gai haia tangada henua gee e noho i oodou daha gi bei dagodo o tangada de henua donu, gai goodou aaloha i de ia bei doodou aaloha donu i goodou; i hiidinga goodou ni dangada henua gee i de masavaa oodou nogo nnoho ai i de henua go Egypt. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Goodou gi dee hadu muna i doodou haide de looloa, ma de hagahidi taemaha aabe go de honu. ");
INSERT INTO nkr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Gai goodou hai hegau i denga mee hagahidi heohi, ma denga hagabaaunga o taemaha gi heohi, de hagabaaunga o dahi ephah ma dahi hin heohi. Go au donu go Iahweh doodou Maadua, ne hagassao ina mai goodou i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Goodou hai hegau i agu muna alodahi gu hagasauaa ma agu hagamodu mage daudali ai. Go au donu go Iahweh.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Basa ange gi de gau Israel, hai ange, ‘Noo dahi dangada Israel, aabe se dangada henua gee e noho laa i daho de gau Israel, e gaavange dahi ana dama e sigidaumaha ange gi Molek, gai ia e daa donu gi magau. Dangada o de henua gi magaa ia gi magau i denga hadu. ");
INSERT INTO nkr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Au e hai baasi ange gi tangada bee nei, ma de vvae gee ia mai i daho ono dangada, i hiidinga ia gu sigidaumaha ange dahi ana dama gi Molek; ia gu hai ma gu hakino gee dogu mommee dabu, aama de hagangadi mee dogu ingoo dabu. ");
INSERT INTO nkr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Gai noo dangada i de henua e dee anga ange gi tangada, e sigidaumaha ina ange laa dahi ana dama gi Molek, gai e dee daa hogi ia gi magau, ");
INSERT INTO nkr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","gai au e hai baasi ange gi tangada bee nei ma dono huaabodu; au e vvae gee naa gilaadeu mai i daho olaadeu dangada, madali dangada alodahi e daumaha ange gi Molek madali ia. ");
INSERT INTO nkr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Gai noo dahi dangada e ssala tangada e hagahia laa hagasaalunga o de gau maakau ma gilaadeu e pasa ange gi denga hagasaalunga baubau, gai au e hai baasi ange donu gi tangada laa, ga vvae gee ia gi dee nnoho madali ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Deenei ai, goodou vaaea gee goodou, ma de hai gi dabu goodou; i hiidinga go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Goodou daudali i agu hainga gu hagasauaa mage haia gi bei; go au donu go Iahweh ne vaaea gee goodou ga hai gi dabu. ");
INSERT INTO nkr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Be goai e hagangadi mee ina dono damana be go dono dinana e daa donu gi magau, i hiidinga ia gu hagangadi mee dono damana be go dono dinana; ia e hagaduasala donu. ");
INSERT INTO nkr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Noo dahi daane gu dagodo haisala ma de bodu o dahi dangada gee, gai gilaau ngaadahi e daa donu gi maakau. ");
INSERT INTO nkr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Gai taane e dagodo haisala ma dono maa, e bei donu ia gu hagangadi mee dono damana. Gai gilaau ngaadahi e daa donu gi maakau; gai delaau maakau e dau ange donu huu gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Noo dahi daane gu dagodo haisala ma dono saulaba, gai gilaau ngaadahi e daa donu gi maakau. Gilaau gu dahulinga be ni manu, gai delaau maakau e dau ange donu huu gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Noo dahi daane e dagodo haisala ma dahi daane bei de hagahebaa o taane ma de hine, gai gilaau gu hai dahi hegau hakino gee. Gilaau ngaadahi e daa donu gi maakau, gai delaau maakau e dau ange donu huu gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Noo dahi daane e hai bodu ange gi dahi hahine ma dono dinana, gai de mee nei se hegau baubau donu. Taane laa ma luu hahine laa ngaadahi e dudu donu i de ahi, gi deai ai hegau baubau bee nei e hai i oodou magavaa. ");
INSERT INTO nkr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Noo dahi daane e dagodo haisala ma dahi manu dolodolo, gai ia e daa donu gi magau; gai goodou daia hogi gi magau de manu laa. ");
INSERT INTO nkr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Noo dahi hahine e dagodo haisala ma dahi manu dolodolo, gai goodou daia ngaadahi de hine laa ma de manu laa gi maakau. Gilaau e daa donu gi maakau, gai delaau maakau e dau ange donu gi gilaau. ");
INSERT INTO nkr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Noo dahi daane e hai bodu ange gi dono daina hahine, e dee hilihili be gilaau se damana daudahi aabe se dinana daudahi, gai gilaau gu hagahebaa, de mee nei se hegau donu hagadookaa. Gai gilaau ngaadahi e vvae gee donu mai i daho olaau dangada. Taane laa tee hagadubu dono daina hahine, gai dono hagaduasala e dau ange donu gi de ia. ");
INSERT INTO nkr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Noo dahi daane e hagahebaa ma dahi haahine magi haahine, gai taane laa gu hai ma gu gidee de mommee e loomai laa dodo o de hine laa, gai de hine laa gu hai hogi ma gu gidee de mommee laa. Gai gilaau ngaadahi e vvae gee donu mai i daho olaau dangada. ");
INSERT INTO nkr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Aude dagodo haisala ma taina hahine o doo dinana, aabe go taina hahine o doo damana, i hiidinga e bei koe gu hagangadi mee doo dangada donu; gai ooluu haisala e dau adu donu gi gooluu. ");
INSERT INTO nkr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Noo dahi dangada e dagodo haisala ma de bodu o taina daane o dono damana, gai e bei donu ia gu hagangadi mee taina daane o dono damana. Gilaau ngaadahi e hagaduasala donu i olaau haisala, gai gilaau e dee hagadili donu ga maakau ai gilaau. ");
INSERT INTO nkr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Noo dahi daane e hai bodu ange gi de bodu o dono daina daane, de hegau nei se mee hakino gee; gai e bei donu ia gu hagangadi mee dono daina daane, gai gilaau e dee hagadili naa donu. ");
INSERT INTO nkr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Gai goodou daohia agu mee alodahi gu hagasauaa ma agu mee gu hagamodu adu gi goodou ma gi daudali ai, gi dee lueia mai ai goodou e de henua aagu e kave goodou gi nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Gai goodou e dee ago ange i dahulinga a denga huaahenua aagu e aau gee mai i oodou daha. Go hiidinga gilaadeu ne hai mee nei alodahi, deelaa ai, au ne kino i gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Aagai au gu hai adu bolo goodou e kave naa delaadeu henua, gai au e gaavadu naa de henua nei goodou gi henua ai, se henua iai vai uu ma hooni lagolago. Go au donu go Iahweh doodou Maadua, au ne vvae gee goodou mai i denga huaadangada ange laa. ");
INSERT INTO nkr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Deenei ai, goodou vaaea de manu dolodolo gilimalali ma de manu e dee gilimalali, manu llele e dee gilimalali ma manu llele gilimalali. Goodou e dee hai gi hakino gee goodou i denga manu dolodolo be ni manu llele aabe go hanu manu e tolo i honga de gelegele, go mee aagu gu vvae gee laa i hiidinga e dee gilimalali adu gi goodou. ");
INSERT INTO nkr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Goodou gi dabu mai gi de au; i hiidinga go au donu go Iahweh, au e dabu, gai au gu vvae gee goodou mai i denga huaadangada ange laa, e hai ai ogu dangada. ");
INSERT INTO nkr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Gai taane be se hine e hagaagahia ange hagasaalunga o de gau maakau, be se dangada e basa ange gi denga hagasaalunga baubau, e daa donu gi magau. Gai de gau bee nei e maga donu gi maakau i denga hadu; gai olaadeu haisala e dau ange donu gi gilaadeu.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Gai Tagi Maolunga ne hai ange gi Moses, “Basa ange gi de gau haimeedabu, go dama daane a Aaron, hai ange gi gilaadeu: ‘Tangada haimeedabu e dee hai ia gi dee gilimalali, i de magau o dahi dangada gee, ");
INSERT INTO nkr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","aagai go de magau donu huu o dahi ono dangada i donu huaabodu, bei dono dinana, be go dono damana, be go dana dama daane, be go dana damaa hine, be go dono daina daane, ");
INSERT INTO nkr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","be go dono daina hahine tigi ai laa sono bodu, gai go ia e hagadanuaa ina ia, go hiidinga e deai sono bodu — ia e maua i de hai gi dee gilimalali ia i gilaadeu nei. ");
INSERT INTO nkr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Gai ia e dee maua i de hai ia gi dee gilimalali i de gau maakau o dangada o dono bodu, ga hai ai ga hakino gee ia. ");
INSERT INTO nkr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","De gau haimeedabu e dee duuduu ngaangaaulu i olaadeu biho, be gi duuduudia gi podo huluhulu i olaadeu gumigumi, aabe gi seleselea olaadeu angaanga ⌊i delaadeu hinangalosaa⌋. ");
INSERT INTO nkr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Gilaadeu gi dabu ange gi delaadeu Maadua, gai gi dee hagangadi mee ina de ingoo o delaadeu Maadua. Gilaadeu e haia denga sigidaumaha a Tagi Maolunga e hai i de ahi, go gai a delaadeu Maadua; deelaa ai, gilaadeu gi dabu. ");
INSERT INTO nkr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Gilaadeu e dee hai bodu ange hogi gi dahi hahine hai be se manu, be se hine gu hakino gee, aabe se hine gu maavae ange gi dono bodu; i hiidinga tangada haimeedabu gu hagadabu ange gi dono Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Gai koe vaaea gee ia ma gi haia gi dabu, i hiidinga go ia e haia ssigidaumaha o pelaoaa a doodou Maadua. Gai vaaea gee ia ma gi haia gi dabu; go hiidinga go au go Iahweh, au e dabu, go de ia ne vaaea gee goodou ga hai gi dabu. ");
INSERT INTO nkr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Gai noo tamaa hine a dahi dangada haimeedabu gu se hine hai be se manu, ga hagangadi mee ai dono damana, gai ia e dudu donu gi magau i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Gai tangada haimeedabu maolunga, i magavaa ono daina gu hagadabu laa i lolo, ma de hagadabu gi gahu i malo o tangada haimeedabu, gi dee hai dono biho gi lausamua, aabe e saesae ono malo ⌊i dono hinangalosaa⌋. ");
INSERT INTO nkr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ia e dee ulu hogi i de mommee iai dahi dangada magau. Ia e dee hai donu gi dee gilimalali ia, e dee galemu donu go dono damana aabe go dono dinana ne magau. ");
INSERT INTO nkr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Gai ia gi dee hano gee hogi i de mommee dabu, gi dee hagangadi mee ina ai e ia, de mommee dabu o dono Maadua, i hiidinga ia gu hagadabu i de lolo a dono Maadua. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Gai de hine oona e hai bodu ange aagena e hai donu gi se bua moe. ");
INSERT INTO nkr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ia e dee hai bodu ange gi de hahine gu magau dono bodu, be se hine gu maavae, aabe se hine gu hakino gee i de hai be se manu, aagai ia e hai bodu ange donu huu gi dahi bua moe i magavaa o ono dangada, ");
INSERT INTO nkr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","gai gi dee haia ai e ia gi hakino gee ono hagadiilinga i magavaa ono dangada. Go au donu go Iahweh, de ia ne vaaea gee ia ga hai gi dabu.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Hai ange gi Aaron, ‘E deai donu se dangada mai i denga atangada alodahi i doo aamuli, e hanu mee baubau i dono angaanga, e alaange i de humai gi baa mai e hai ssigidaumaha o gai a dono Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Gai e deai donu se dangada e hanu mee baubau i dono angaanga, e maua i de humai e hagabaa mai; e dee hilihili be se dangada dee gide, be se dangada balagelage, be se dangada gu modu dono usu, aabe se dangada e dahi mommee e dee danuaa i dono angaanga; ");
INSERT INTO nkr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","e deai hogi se dangada gu magau dono vae be go dono lima, ");
INSERT INTO nkr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","be se dangada e gogo gi mua, be se dangada e gidigidi laa lalo, be se dangada e baubau luoono ganomada, be se dangada e maanuga ina, aabe se dangada gu tuu luoono golee. ");
INSERT INTO nkr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","E deai donu se hagadiilinga o tangada haimeedabu maolunga go Aaron e alaange i de hai denga sigidaumaha dudu a Tagi Maolunga, noo e hanu mee baubau i dono angaanga; ia e dee maua i de humai e hagabaa mai e sigidaumaha ange gai a dono Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Tangada bee nei e maua i de gaimee i gai gu sigidaumaha ange gi dono Maadua, go mee dabu mmao aama mee dabu, ");
INSERT INTO nkr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","aagai ia e dee maua i de humai e hagabaa ange gi de malo buibui, aabe go de mommee o ssigidaumaha, i hiidinga e hanu mee baubau i dono angaanga, gi dee hagangadi mee ina ai e ia dogu mommee dabu. Go au donu go Iahweh ne vaaea gee gilaadeu ga hai gi dabu.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Gai Moses ne tala ange muna nei gi Aaron ma ana dama daane aama de gau Israel alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Daalaa ange gi Aaron ma ana dama daane gilaadeu gi vaaea gee sigidaumaha dabu, a de gau Israel gu hagadabu mai gi de au, gi dee hagangadi mee ina ai e gilaadeu dogu ingoo dabu. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Hai ange gi gilaadeu: ‘Noo dahi oodou hagadiilinga, mai i denga atangada alodahi e loomai gu dee gilimalali, gai ia e humai e hagabaa ange gi denga sigidaumaha a de gau Israel gu hagadabu ange gi Tagi Maolunga, gai tangada laa e aau gee donu mai i mada luoogu mada. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Gai e deai donu se hagadiilinga o Aaron e magi lebelaa, aabe e ssali mai hanu mee i de ia, e maua i de gai mee o denga sigidaumaha dabu, ga dae ai gi dono ahe ange ga gilimalali. Gai ia e dee gilimalali hogi, noo ia gu poo ange gi hanu mee hakino o tangada magau, aabe go taane e ssali mai hanu mee i de ia, ");
INSERT INTO nkr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","aabe noo ia e poo ange gi hanu manu e tolo i honga de gelegele ga dee gilimalali ai ia, aabe e poo ange gi dahi dangada e dee gilimalali, e dee hilihili donu be ni mee dee gilimalali bee hee — ");
INSERT INTO nkr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","tangada e poo ange gi mee bee nei e dee gilimalali ga dae ai gi de ahiahi. Ia e dee gai hogi denga mee dabu ga dae ai gi dono gaugau ga gilimalali. ");
INSERT INTO nkr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Aagai dua naa huu de danu de laa gai ia gu gilimalali; gai ia gu maua i de gai mee dabu laa, i hiidinga aanei donu ana gai. ");
INSERT INTO nkr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Gai ia e dee maua i de gai de manu ne ngadi magau be se manu ne daia i dahi manu alasala, ga hidi ai dono dee gilimalali. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Gai de gau haimeedabu gi daohia agu muna gu tala ange gi gilaadeu, gi dee maakau ai gilaadeu, i delaadeu hagahaisala ma de hagangadi mee agu muna. Go au go Tagi Maolunga ne vaaea gee gilaadeu ga hai gi dabu. ");
INSERT INTO nkr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Gai tangada e dee se dangada de huaabodu o Aaron e dee gai mee dabu. Tangada henua gee e noho laa i daho tangada haimeedabu, aama tangada hai hegau e hagao e dee gai hogi denga mee dabu. ");
INSERT INTO nkr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Aagai noo tangada haimeedabu e hagao dahi dangada hai hegau, aabe se dangada hai hegau ne haanau i dono hale, gai tangada nei e maua hogi i de gai mee dabu. ");
INSERT INTO nkr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Gai noo tamaa hine a dahi dangada haimeedabu gu hai bodu ange gi dahi daane e dee se dangada haimeedabu, gai ia e dee maua i de gai mee dabu e hai ai laa ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Aagai noo tamaa hine a tangada haimeedabu gu magau dono bodu, aabe gu maavae ange gi dono bodu, gai tigi ai ana dama, gai ia gu ahe mai ma gu noho i de hale o dono damana, bei de masavaa oona nogo gauligi ai laa, gai ia e maua i de gaimee i gai a dono damana. Aagai e deai ange donu dangada laa daha e maua i de gai mee nei. ");
INSERT INTO nkr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Noo dahi dangada gee e gai mee dabu, gai tee se hagabau, gai ia gi suuia ange ana mee gu gai laa, ga hagapuni ange dahi diba i diba e lima madali mee laa ga gaavange ai gi tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Gai de gau haimeedabu gi dee hagangadi mee ina mee dabu a de gau Israel gu hai ai laa alaadeu sigidaumaha ange gi Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","gi dee dau ange ai ssala laa gi gilaadeu, i delaadeu gai denga mee dabu. Go au donu go Iahweh ne vaaea gee gilaadeu ga hai gi dabu.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Hai ange gi Aaron ma ana dama daane aama de gau Israel alodahi, ‘De masavaa naa huu o dahi goodou, aabe go dahi dangada henua gee i Israel, e gaamai ai dahi sigidaumaha ange gi Tagi Maolunga, e dee hilihili be se mee niiana gu hagatoo donu ai aabe se mee ngadi gaavange e hai ai dana sigidaumaha dudu, ");
INSERT INTO nkr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","gai noo sigidaumaha e hai gi se mee e malangilangi ai Tagi Maolunga, gai haia i dahi kaau daane be se ssiibi daane, aabe se guudi daane e deai laa mee baubau i dono angaanga. ");
INSERT INTO nkr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Goodou e dee hai ssigidaumaha i dahi manu e hanu mee baubau i dono angaanga; go hiidinga Tagi Maolunga e dee malangilangi naa i oodou sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","De masavaa naa huu a tangada e hai ai dahi sigidaumaha hagadanuaa magavaa ange gi Tagi Maolunga, e hagasula ai dana hagatoo donu, be se mee ngadi gaavange, mai i ana kaau be go ana ssiibi, gai e hai gi se manu e deai mee baubau i dono angaanga aabe ni mangeo, gi malangilangi ai Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Goodou e dee hai oodou ssigidaumaha e hai i de ahi ange gi Tagi Maolunga, i manu e dee kide, be go manu gu lagolagohia, be go manu gu dee maua i de seesee, be go manu gu tuu, be go manu e ssali mai ai mee baubau, be go manu iai gili baubau, aabe ni mangeo. ");
INSERT INTO nkr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Gai de kaau be se ssiibi e looloa laa dahi ono vae aabe bodobodo, goodou e maua i de ngadi gaavange e hai ai ssigidaumaha; aagai noo se hai e hagasula ai dau hagatoo donu, gai sigidaumaha laa e dee hagamalangilangi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Goodou e dee maua i de sigidaumaha ange gi Tagi Maolunga dahi manu gu lagolagohia luoono golee, be gu pala aabe gu tuu. Goodou e dee maua i de hai mee nei i honga doodou henua, ");
INSERT INTO nkr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","gai goodou e dee kave hogi denga manu bee nei, mai i daho de gau henua gee, e haia ai sigidaumaha ange gi doodou Maadua. Sigidaumaha bee nei e dee hagamalangilangi Tagi Maolunga, go hiidinga iai mee baubau ma de lagolagohia.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“De masavaa naa huu a tama a dahi kaau be se ssiibi aabe se guudi e haanau ai, gai dugua i daho dono dinana i e hidu laangi. Gai dua naa huu e valu laangi, gai gu maua i de hai ai ssigidaumaha ange gi Tagi Maolunga i de ahi. ");
INSERT INTO nkr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Gai goodou aude daia gi maakau dahi kaau hahine ma dana dama aabe go dahi ssiibi hahine ma dana dama i de laangi daudahi. ");
INSERT INTO nkr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Gai de masavaa naa huu oodou e hai ai dahi sigidaumaha e hagaahe ange ai de abodonu gi Tagi Maolunga, gai goodou haia gi se mee e malangilangi ai Tagi Maolunga i goodou. ");
INSERT INTO nkr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Gai mee nei e gai gi odi i de laangi laa donu huu; goodou e dee dugu hanu mee gi doe gi taiao age. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Goodou daohia agu muna gu tala adu gi goodou ma de daudali ai. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Goodou e dee hagangadi mee dogu ingoo dabu. Gai de gau Israel e hai gi dabu au i olaadeu daha. Go au donu go Iahweh, e vaaea gee goodou ga hai gi dabu, ");
INSERT INTO nkr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","gai ne hagassao ina mai goodou i de henua go Egypt, ga hai au go doodou Maadua. Go au donu go Iahweh.” ");
INSERT INTO nkr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Basa ange gi de gau Israel hai ange gi gilaadeu: ‘Aanei daonga a Tagi Maolunga, go daonga gu lava i de hagailonga, gai goodou e hagailoo ina laangi dabu e hagabuni ai goodou. ");
INSERT INTO nkr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘E ono laangi oodou e hai ai oodou hegau; gai de hidu go de laangi o Sabbath e hagammabu ai goodou, gai se laangi hagabuni dabu niiodou. Goodou e dee hai ai hanu hegau; de laangi nei go Sabbath a Tagi Maolunga adu gi goodou, i mommee alodahi oodou e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Aanei daonga a Tagi Maolunga gu hagailonga, ni laangi dabu e hagabuni ai goodou, gai goodou ga hagailoo ange gi dangada denga masavaa gu lava i de hagailonga. ");
INSERT INTO nkr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","De ahiahi o de madaangahulu ma haa laangi i tahi malama go Taonga Hagasili a Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Gai de madaangahulu ma lima laangi o de malama laa go Taonga o Pelaoaa Dee Hagahua ange gi Tagi Maolunga; gai e hidu laangi oodou e gai ai pelaoaa dee hagahua. ");
INSERT INTO nkr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Gai tahi laangi gai goodou hagabuni mage daumaha; goodou aude haia ai dahi hegau daudahi. ");
INSERT INTO nkr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Aagai goodou haia oodou sigidaumaha dudu ange gi Tagi Maolunga i laangi e hidu nei; gai de hidu laangi se laangi hagabuni dabu niiodou; goodou aude haia ai dahi hegau daudahi.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Basa ange gi de gau Israel, hai ange, ‘De masavaa naa huu oodou e hulo ai ga nnoho i de henua aagu e gaavadu gi goodou, gai goodou ga hagihagi hua manu i honga o oodou gelegele, gai goodou gaamai gi tangada haimeedabu dahi noodangaa grain mai i oodou grain e hagihagi i taamada. ");
INSERT INTO nkr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Gai tangada haimeedabu gi daodaohia age de noodanga laa i mada luu mada o Tagi Maolunga, gi malangilangi ai ia i goodou; gai tangada haimeedabu gi daodaohia age hogi mee nei i de laangi i dua Sabbath. ");
INSERT INTO nkr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Gai de laangi naa huu oodou e daodaohi age ai de noodanga laa, gai goodou e hai hogi ssigidaumaha dudu ange gi Tagi Maolunga, i dahi ssiibi daane gu dahi laa ono ngadau, gai e deai mee baubau i dono angaanga. ");
INSERT INTO nkr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Goodou e gaamai hogi e lua diba i diba e madaangahulu o dahi ephah pelaoaa lligi gu hilo ma lolo, e sigidaumaha ange gi Tagi Maolunga i de ahi, se sigidaumaha nnamu kala — madali ssigidaumaha o mee unu o e dahi diba i diba e haa o dahi hin uvaini. ");
INSERT INTO nkr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Gai goodou e dee maua i de gai hanu pelaoaa, be ni grain lala be ni grain mada, ga dae ai gi de laangi oodou e gaamai ai sigidaumaha nei gi doodou Maadua. De mee nei se hainga gu hagasauaa, ange gi oodou atangada alodahi ga hano ai, i mommee alodahi oodou e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Gai goodou ga dau gi hidu uvigi mai i dua de laangi o Sabbath laa, go de laangi oodou e gaamai ai denga noodangaa huamanu e hai ai ssigidaumaha daodaohi age. ");
INSERT INTO nkr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Gai goodou ga dau hogi gi madalima laangi i dua de hidu Sabbath laa; gai goodou ga gaamai dahi ssigidaumaha i hua o denga grain hoou e gaavange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Gai goodou ga gaamai, i oodou mommee nnoho, e dagilua duudangaa pelaoaa e daodaohi age, gai haia i e lua diba i diba e madaangahulu o dahi ephah pelaoaa lligi, ga labu i mee hagahua ga dao, aanei mee e gaavange gi Tagi Maolunga i denga hua i taamada. ");
INSERT INTO nkr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Gai goodou ga gaamai madali luu duudangaa pelaoaa laa, e hidu ssiibi daane gu dagidahi olaadeu ngadau, gai e deai mee baubau i olaadeu angaanga, ma e dahi kaau daane gauligi, ma e lua ssiibi daane. Manu nei ni mee e hai ai ssigidaumaha dudu ange gi Tagi Maolunga, madali ssigidaumaha o denga grain ma ssigidaumaha o mee unu; go sigidaumaha e nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Gai goodou ga hai ssigidaumaha o haisala i dahi guudi daane, gai ga hai ssigidaumaha hagadanuaa magavaa i e lua ssiibi daane gu dagidahi olaau ngadau. ");
INSERT INTO nkr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Gai tangada haimeedabu gi daodaohia age luu ssiibi daane laa i mada luu mada o Tagi Maolunga madali pelaoaa ne hai laa i huamanu i taamada, e hai ai ssigidaumaha daodaohia age; mee nei gu vvae ange gi Tagi Maolunga, e hai ai tuuhanga o tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Gai goodou ga hagailoo i de laangi laa donu huu, de hai de hagabuni dabu; gai goodou gi dee haia ai dahi hegau daudahi. De mee nei se hainga gu hagasauaa adu gi goodou i mommee alodahi oodou e nnoho ai, i oodou atangada alodahi ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Gai de masavaa naa huu oodou e hagihagi ai hua i honga oodou gelegele, gai goodou aude hagihagia gi odi, aabe e hagabudu gi odi mee alodahi oodou gu hagihagi; gai dugua ange gi de gau hagaau aloha ma de gau henua gee. Go au donu go Iahweh doodou Maadua.’ ”  ");
INSERT INTO nkr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Basa ange gi de gau Israel, hai ange, ‘Tahi laangi o de hidu malama se laangi hagammabu niiodou, se laangi hagabuni dabu niiodou, gai e hagamaanadu i de ili o denga hanga manu. ");
INSERT INTO nkr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Goodou e dee hai ai dahi hegau daudahi, aagai goodou e hai ssigidaumaha ange gi Tagi Maolunga i de ahi.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“De madaangahulu laangi o de hidu malama nei, go de Laangi o de Tala Haisala. Gai se masavaa hagabuni dabu niiodou, gai goodou ga hagahiikai, ma de hai dahi sigidaumaha i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Goodou aude haia dahi hegau daudahi i de laangi nei; i hiidinga go de Laangi o de Tala Haisala, gi maatala i oodou haisala i mada luu mada o Tagi Maolunga doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Gai tangada naa huu e dee hagahiigai i de laangi laa, gai ia e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Gai be goai e haia hanu hegau i de laangi nei, gai au e daa donu ia gi magau ga aau gee ia mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Goodou aude haia ai donu hanu hegau. De mee nei se hainga gu hagasauaa ange gi oodou atangada alodahi ga hano ai i mommee alodahi oodou e nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Gai de laangi nei se Sabbath e hagammabu ai goodou, gai goodou ga hagahiikai; gai e daamada i de ahiahi o ssiva laangi o de malama, gai goodou ga dao Sabbath ga dae ai gi de ahiahi mai ange laa.” ");
INSERT INTO nkr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Basa ange gi de gau Israel, hai ange, ‘De madaangahulu ma lima laangi o de hidu malama, gai goodou damadaa de hai Taonga o denga Baasi Hale ange gi Tagi Maolunga i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Gai tahi laangi se laangi dabu e hagabuni ai goodou; goodou e dee hai ai hanu hegau. ");
INSERT INTO nkr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","E hidu laangi oodou e hai ai ssigidaumaha i de ahi ange gi Tagi Maolunga; gai de valu laangi se laangi hagabuni dabu niiodou ma de hai ai oodou sigidaumaha i de ahi ange gi Tagi Maolunga. De mee nei se laangi hagabuni niiodou; gai goodou aude haia ai hanu hegau. ");
INSERT INTO nkr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Aanei daonga a Tagi Maolunga gu hagailonga, go daonga oodou e hagailoo bolo ni laangi dabu e hagabuni ai goodou, ma de hai ai denga sigidaumaha i de ahi ange gi Tagi Maolunga — go sigidaumaha dudu, ma sigidaumaha o grain, ma sigidaumaha ange laa, aama sigidaumaha o mee unu, bei de hai gu hagatau ange ai gi dahi laangi ma dahi laangi. ");
INSERT INTO nkr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Denga sigidaumaha nei ni mee e hagapuni ange gi denga Sabbath a Tagi Maolunga, ma oodou mee ngadi gaavange, ma oodou sigidaumaha gu hagatoo donu ai, madali oodou mee e ngadi gaavange gi Tagi Maolunga.) ");
INSERT INTO nkr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Gai de madaangahulu ma lima laangi naa huu o de hidu malama, i dua doodou hagabudu mai denga huamanu i oodou gelegele, gai goodou ga dao taonga a Tagi Maolunga i e hidu laangi; gai tahi laangi ma de valu laangi ni laangi hagammabu niiodou. ");
INSERT INTO nkr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Gai tahi laangi naa huu o taonga, gai goodou ga duuduu mai hua danuaa o oodou manu lau kohu, ma laa o denga palm, ma denga laa iai lau manu, aama denga willow i gaogao denga saalingaa vai. Gai goodou ga hai taonga ga malangilangi ai, i mada luu mada o Tagi Maolunga doodou Maadua, i e hidu laangi. ");
INSERT INTO nkr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Gai goodou dao ina taonga nei ange gi Tagi Maolunga i e hidu laangi i de ngadau. De mee nei se hainga gu hagasauaa ga hano ai ange gi oodou atangada alodahi; goodou dao ina taonga nei i de hidu malama. ");
INSERT INTO nkr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Gai goodou ga nnoho i lodo baasi hale laa manu i e hidu laangi; de gau Israel alodahi gi nnoho i lodo hale bee nei, ");
INSERT INTO nkr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","gi iloo ai e oodou atangada alodahi bolo go au donu ne haia de gau Israel gi nnoho i lodo baasi hale laa manu i de masavaa aagu ne hagassao mai ai gilaadeu i de henua go Egypt. Go au donu go Iahweh doodou Maadua.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Gai Moses ga hagailoo ange gi de gau Israel daonga a Tagi Maolunga gu hagailonga laa. ");
INSERT INTO nkr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Hai ange gi de gau Israel gilaadeu gi gaamai lolomango o denga olive e kumi laa, e haula ai denga laama, gi ula ai i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Gai Aaron gi diiloo gi haula ina, gi kaa i de ahiahi ga dae ai gi taiao, i mada luu mada o Tagi Maolunga, i masavaa alodahi. Gai ia gi haia mee nei i tua de malo e buibui ai laa de ngavesi o de tala hagadonu, i lo te hale malo hagabuni. De mee nei se hainga adu gi goodou ma oodou atangada ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Gai Aaron gi diiloo gi haula ina gi kaa denga laama, i honga de mee dugu laama goolo, i mada luu mada o Tagi Maolunga i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Gai koe haia hanu pelaoaa lligi haia ai e madaangahulu ma lua duudangaa pelaoaa; gai haia i e lua diba i diba e madaangahulu o dahi ephah pelaoaa lligi, e hai ai dahi duudangaa pelaoaa. ");
INSERT INTO nkr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Gai koe ga hai e lua hagataaunga i honga teebele goolo danuaa laa, i mada luu mada o Tagi Maolunga, gai haia gi ono pelaoaa i dahi hagataaunga. ");
INSERT INTO nkr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Gai koe ga gaavange hanu frankincense danuaa gi honga luu hagataaunga laa, mee nei ni mee e gaavange madali denga pelaoaa e hai ai ssigidaumaha hagamaanadu i de ahi, ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Gai pelaoaa nei e hagatau ange gi mada luu mada o Tagi Maolunga i Sabbath alodahi, e sui ai de gau Israel, gai se hagatoo donu hagaheloongoi ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Gai pelaoaa nei nii Aaron ma ana dama daane, gai gilaadeu e gai mee nei i lo te mommee dabu, go hiidinga mee nei go delaadeu duuhanga dabu mmao, mai i ssigidaumaha e hai i de ahi ange gi Tagi Maolunga, ga hano ai.”  ");
INSERT INTO nkr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","De masavaa laa gai tama daane a dahi hahine Israel gai dono damana se daane Egypt, ne hano gi daho de gau Israel, gai ia ne hebagi ange gi dahi daane Israel i de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Gai tama daane a de hine Israel laa ne hagangadi mee de ingoo o Tagi Maolunga. Gai gilaadeu ga gaamai ia gi Moses. Gai de ingoo o dono dinana go Shelomith, tamaa hine a Dibri, mai i de aamuli o Dan. ");
INSERT INTO nkr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Gai gilaadeu ne hhao ia gi lo te hale pono ga tali ai Tagi Maolunga gi hagaagona ange gi gilaadeu be ni aha e hai ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Hagasao ina mai taane ne basa hagangadi mee i dogu ingoo, ga kave ia gi tua de mommee nnoho gaainga. Gai dangada alodahi ne langona ana muna, gi dugua ange olaadeu lima gi honga dono biho, gai dangada alodahi gi magaa ia gi magau i denga hadu. ");
INSERT INTO nkr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Gai koe basa ange gi de gau Israel, hai ange, ‘Be goai naa huu e hagangadi mee ina dono Maadua, gai e hagaduasala donu i ono haisala. ");
INSERT INTO nkr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Gai tangada e hagangadi mee ina de ingoo o Iahweh, e daa donu gi magau. Gai dangada alodahi gi magaa ia gi magau i hadu. Gai e dee hilihili donu be se dangada henua gee, aabe se dangada Israel, e hagangadi mee ina de ingoo ⌊o Iahweh⌋, gai e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Tangada e daia dahi dangada ga magau e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Gai tangada e daia laa ga magau de manu dolodolo a dahi dangada gi suuia ange de manu gu magau laa i dahi manu mouli. ");
INSERT INTO nkr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Gai noo tangada gu hagalagohia dahi dangada Israel ange laa, gai ia e hai hogi gi lagohia bei dana hai ne hai ai laa tangada laa: ");
INSERT INTO nkr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","de maaguluaa e sui i de maaguluaa, de ganomada e sui i de ganomada, de niho e sui i de niho. Mee a tangada ne hai ange gi tangada ange laa e hai ange hogi gi de ia. ");
INSERT INTO nkr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Tangada e daia ga magau de manu a dahi dangada gi sui ange de manu laa; aagai tangada e daia dahi dangada ga magau e daa donu hogi gi magau. ");
INSERT INTO nkr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Gai se hainga daudahi e hagamodu ai muna o tangada henua gee, aama tangada de henua. Go au donu go Iahweh doodou Maadua.’ ”  ");
INSERT INTO nkr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Gai Moses ne tala ange muna nei gi de gau Israel; gai gilaadeu ga hagasao mai tangada ne hagangadi mee ina laa de ingoo dabu laa, ga kave gi tua de mommee nnoho gaainga, ga maga ia gu magau i hadu. Gai de gau Israel ne hai donu ga bei muna a Tagi Maolunga gu tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Gai Tagi Maolunga ne hai ange gi Moses, i honga de mounga go Sinai, ");
INSERT INTO nkr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Basa ange gi de gau Israel, hai ange, ‘De masavaa naa huu oodou e hulo ai ga nnoho i de henua aagu e gaavadu gi goodou, gai goodou e hai Sabbath o de gelegele ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","E ono ngadau oodou e doo ai oodou gelegele, ma de velevele ai oodou veelengaa grape aama de hagihagi hua iai. ");
INSERT INTO nkr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Aagai de hidu ngadau naa huu, gai de gelegele e hagamabu i Sabbath ange gi Tagi Maolunga. Goodou e dee doo oodou gelegele, aabe e velevele oodou veelengaa grape. ");
INSERT INTO nkr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Goodou e dee hagihagi hua o denga manu e ssomo ai, aabe e hagihagi hua o denga veelengaa grape oodou e dee velevele laa. De gelegele e dugu gi hagamabu i e dahi ngadau. ");
INSERT INTO nkr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Gai goodou ma oodou daane ma haahine hai hegau, ma de gau hai hegau oodou e hagao, aama de gau henua gee e nnoho i oodou daha, e maua i de gai mee e hua mai i denga manu i de ngadau o Sabbath, ");
INSERT INTO nkr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","madali oodou manu haangai ma denga manu lodo henua i honga oodou gelegele. Goodou e maua i de gai mee e hhua mai i denga manu alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Gai goodou e dau e hidu ngadau o Sabbath; goodou e dau gi hidu ngadau e hagalagolago ange gi de hidu, gi duu ai de madahaa ma siva ngadau. ");
INSERT INTO nkr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Gai goodou ga ili de hanga manu i de madaangahulu laangi o de hidu malama; de Laangi o de Tala Haisala, gai goodou ga ili de hanga manu i honga de henua alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Gai goodou ga hai gi dabu de madalima ngadau, ga hagailoo de hai gi ilaage dangada alodahi e nnoho i honga de henua. De ngadau nei go doodou jubilee, go de ngadau a dahi ma dahi e maua ai i de ahe ange gi dono gelegele donu, ma daho dono huaabodu. ");
INSERT INTO nkr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","De ngadau e madalima go doodou jubilee; goodou e dee doo oodou gelegele, be hagabudu hua o manu e ngadi ssomo age laa donu huu, aabe hagihagi hua o denga veelengaa grape oodou e dee velevele laa. ");
INSERT INTO nkr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Gai deenei de ngadau o de jubilee; gai se ngadau dabu niiodou; gai goodou e gai donu huu mee e hhua mai laa i manu e ssomo i honga oodou gelegele. ");
INSERT INTO nkr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","De ngadau o jubilee gai dahi ma dahi gi ahe ange gi dono alahenua donu. ");
INSERT INTO nkr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Gai noo tangada ne hagao ange dahi alahenua gi dahi oo dangada, aabe koe e hagao dahi alahenua i daho dahi dangada, gai goodou e dee hagadau vaivai daakodo i oodou magavaa. ");
INSERT INTO nkr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Gai deenei dau hai e ahe ange ai e hagao doo alahenua mai i daho dahi oo dangada: koe e hagabau taelodo o denga ngadau i dua jubilee gu hano laa. Gai ia gi hagao ina adu gi de goe gi bei taelodo o ngadau aana ne hagihagi ai denga hua iai. ");
INSERT INTO nkr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Noo ni ngadau lagolago, gai koe uea age de hagaoanga, gai noo e sogoisi ngadau e doe, gai koe uea iho de hagaoanga, go hiidinga ia e hagao adu gi de goe, i de hagaoanga o denga huamanu aana e hagihagi ai. ");
INSERT INTO nkr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Gai goodou e dee hagadau vaivai daakodo i oodou magavaa, aagai goodou gi maatagu i de Maadua. Go au go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Goodou daudali i agu hainga gu hagasauaa, ma de hagallongo ange gi agu hagamodu, gi nnoho paba ai goodou i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Gai de gelegele o de henua e hhua lagolago naa, gai goodou e gaimee naa ga boobosu ma tee maatagu i de nnoho i honga de henua. ");
INSERT INTO nkr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Noo goodou e ssili naa, “Gai ni aha naa amaadeu e gai i de hidu ngadau, noo gimaadeu e dee doo aabe hagihagi amaadeu huamanu?” ");
INSERT INTO nkr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Au e hagamanuuia naa goodou i de ono ngadau, gai de gelegele e hhua lagolago naa gi dohu ange gi e dolu ngadau. ");
INSERT INTO nkr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Gai de masavaa naa huu oodou e doo ai oodou gelegele i de valu ngadau, gai goodou goi gaimee donu huu i huamanu ne hagihagi laa i denga ngadau gu hulo, ga dae ai gi doodou aahe ange ga hagihagi i ssiva ngadau. ");
INSERT INTO nkr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Gai denga alahenua e dee maua donu i de hagao gi daha ga hano ai; go hiidinga de henua niiogu, gai goodou ni dangada henua gee e nnoho gaainga i dogu henua. ");
INSERT INTO nkr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Denga alahenua alodahi oodou gu kave, gai goodou haia gi maua e tangada i de ahe ange e hagao dono gelegele. ");
INSERT INTO nkr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Noo dahi oo dangada gu hagaau aloha, gai ia gu hagao gi daha dahi mommee i dono alahenua, gai tangada hugadoo i dono huaabodu e baa ange, gi hagao ina gi hagaahea mai de alahenua a dono dangada gu hagao laa gi daha. ");
INSERT INTO nkr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Gai noo e deai donu se dangada i dono huaabodu e maua i de hagao mai, gai tangada laa e maua i de ahe ange ga hagao i de masavaa aana e maua ai, ");
INSERT INTO nkr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","gai ia gi guumia ange ngadau i dua dana hagao gi daha, ga hagao ange ngadau e doe i mua de jubilee gi tangada aana ne hagao ange laa aagena; gai ia gu maua i de ahe gi dono alahenua. ");
INSERT INTO nkr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Aagai noo ia tigi maua i de ahe ange e hagao dono alahenua, gai de alahenua aana ne hagao laa gi daha e dugu i daho tangada ne hagao ina laa, ga dae ai gi de ngadau o de jubilee. Gai e hagaahe mai i de ngadau o de jubilee, gai tangada laa gu maua i de ahe ange gi dono alahenua. ");
INSERT INTO nkr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Gai noo tangada e hagao gi daha dahi hale i lo te aduhale buibui, gai ia e maua i de ahe ange e hagao mai i dua e dahi ngadau; gai go de ngadau laa donu huu aana e maua ai i de ahe ange e hagao dono hale. ");
INSERT INTO nkr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Gai noo ia tee ahe ange e hagao i de ngadau laa, gai de hale i lo te aduhale buibui laa gu niio tangada ne hagao ina laa ma dono aamuli; gai e dee hagaahe ange i de ngadau o de jubilee. ");
INSERT INTO nkr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Aagai denga hale i denga aduhale vaaligiligi e dee buibui laa e hai bei denga alahenua; hale bee nei e maua i de aahe ange e hagao mai, ma de dugu ange gi tangada niiona i de ngadau o de jubilee. ");
INSERT INTO nkr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Aagai hale o de aamuli o Levi i olaadeu aduhale, gilaadeu e maua i de aahe ange e hagao mai i masavaa alodahi. ");
INSERT INTO nkr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Gai noo dahi dangada mai i de aamuli o Levi tee ahe ange e hagao dono hale gu hagao laa gi daha i lo te laadeu aduhale, gai gi dugua ange i de ngadau o de jubilee; go hiidinga denga hale i lodo aduhale o de aamuli o Levi ni mee gu bolo ange gi gilaadeu i daho de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Aagai denga mommee iai helii i luu baasi de aduhale e dee hagao gi daha; gai ni mommee gu gaavange gi gilaadeu ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Noo dahi dangada i oo daha gu hagaau aloha, ia gu dee maua i de hagadanuaa ia, gai koe balea ange ia bei dau hai e bale ange ai laa tangada henua gee, aabe se dangada e noho gaainga i oo daha, gi maua ai e ia i de noho i oo daha. ");
INSERT INTO nkr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Aude gaavee dahi mee laa honga mee aau ne gaavange gi dahi dangada; aagai koe gi madagu i de Maadua, gi maua ai e tangada laa i de noho madali goe. ");
INSERT INTO nkr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Aude gaavange sseene gi tangada e kave ai dahi sseene laa honga mee aau ne gaavange gi de ia, aabe gi hagao ina ange gi de ia, gai e kave ai dahi sseene laa honga mee aau ne bale ange ai ia. ");
INSERT INTO nkr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Go au donu Tagi Maolunga doodou Maadua, go au ne hagassao ina mai goodou i de henua go Egypt, ga gaavadu gi goodou de henua go Canaan, ma de hai go doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Noo dahi dangada Israel gu hagaau aloha, gai ia e humai koe gi hagao ina ia, e hai ai doo dangada hai hegau, gai koe aude hagahai hegau ina ia gi bei dagodo o tangada hai hegau e dee ilaage. ");
INSERT INTO nkr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Gai koe haia ia gi se dangada hai hegau e hagao, aabe se dangada e noho gaainga i oo daha. Gai ia gi hai hegau adu gi de goe ga dae ai gi de ngadau o jubilee. ");
INSERT INTO nkr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Gai koe gi dugua ia ma ana dama gi hulo, gai gilaadeu ga aahe ai gi daho delaadeu huaabodu, aama de alahenua o olaadeu maadua. ");
INSERT INTO nkr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Go hiidinga de gau Israel ni dangada hai hegau niiogu, gai au ne hagassao ina mai gilaadeu i de henua go Egypt; deelaa ai, gilaadeu e dee hagao gi daha, bei dagodo o de gau hai hegau dee ilaage. ");
INSERT INTO nkr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Aude vaivai haia tangada Israel, aagai koe gi madagu i doo Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Gai oo daane ma haahine hai hegau, koe e maua i de hagao mai gilaadeu i denga henua gee. ");
INSERT INTO nkr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Gai goodou e maua hogi i de hagao dama a de gau henua gee e nnoho gaainga i oodou magavaa, aama mai i dangada o denga huaabodu ne haanau i doodou henua; gai goodou e maua i de hai gilaadeu gi bei oodou goloa donu. ");
INSERT INTO nkr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Gai goodou e maua i de bolo ange gilaadeu gi oodou dama e loomai i oodou dua, gai gilaadeu e maua i de hai gilaadeu gi ni dangada hai hegau i taulooloa olaadeu mouli, aagai goodou e dee hai de gau Israel gi ni dangada hai hegau e dee ilaage, ma de vaivai hai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Gai noo dahi dangada henua gee, aabe se dangada e noho gaainga i oodou magavaa gu se dangada lava, gai dahi dangada Israel gu hagao ange ia gi dahi dangada henua gee, aabe go de hai gi se dangada de huaabodu o tangada henua gee, ");
INSERT INTO nkr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","gai e maua i de ahe ange ga hagao mai ia, i dua dana hagao ia gi daha. Dahi ono dangada gi ahe ange gi hagao ina mai ia. ");
INSERT INTO nkr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Gai taina o dahi luoono maadua, be go tama a taina o dahi luoono maadua, aabe go dahi dangada i dono huaabodu gi ahe ange gi hagao ina ia. Gai noo tangada laa gu maua, gai ia gi hagao donu huu ia. ");
INSERT INTO nkr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Gai gilaau ma tangada ne hagao ina ia gi buni i de hagaoanga o denga ngadau e doe ga dae mai ai de ngadau o jubilee, gai de hagaoanga o dono ilaage e kumi ange gi denga ngadau laa, gai e hagao bei de hagaoanga o tangada hai hegau hagao. ");
INSERT INTO nkr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Gai noo ni ngadau lagolago e doe i mua de dae mai o de jubilee, gai ia gi hagaahea ange dahi baasi o mee ne hagao ai laa ia. ");
INSERT INTO nkr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Gai noo e sogoisi donu huu ngadau e doe i mua de dae mai o de ngadau o de jubilee, gai tangada gi hagabaulia ange de hagaoanga o denga ngadau e doe, ga hagao ange ai tangada oona e hai hegau ange laa aagena. ");
INSERT INTO nkr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Gai ia e hagao i ngadau alodahi bei dagodo o tangada hai hegau hagao; gai dono dangada aamua gi dee vaivai haia ia. ");
INSERT INTO nkr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Gai noo tangada tee maua i de hagao ia i mee nei, gai gilaadeu ma ana dama e dugu gi hulo i de ngadau o de jubilee. ");
INSERT INTO nkr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","I hiidinga de gau Israel ni dangada hai hegau niiogu, gilaadeu go ogu dangada hai hegau aagu ne hagassao mai i de henua go Egypt. Go au donu go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Goodou gi dee hai hanu diinonga be gi hagaduulia dahi diinonga, aabe se duludulu hadu moodou, gai goodou e dee hai dahi diinonga hadu i honga doodou henua ga daumaha ange aagena. Go au go Iahweh doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Goodou dao ina agu Sabbath ma de hagadubu dogu mommee dabu. Go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Noo goodou e daudali i agu hainga gu hagasauaa ma de kana ange ga hagallongo mai gi agu muna, ");
INSERT INTO nkr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","gai au e hai naa gi pala de langi i ono malama donu, gi hhua lagolago ai manu i lodo veelenga, gai manu ssomo i honga de henua e hhua naa hogi. ");
INSERT INTO nkr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Gai goodou e hili naa oodou hua grain ga dae ai gi de masavaa e hagihagi ai denga grape, gai de hagihagi o denga grape e daea adu naa de masavaa e aahe ange ai e doo; gai goodou e gaimee naa ga boobosu i oodou gai, ma de nnoho paba i honga doodou henua. ");
INSERT INTO nkr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Gai au e hai naa gi nnoho paba dangada i honga de henua, gai goodou e sseni danuaa naa, gu deai mee e hagamaatagu ina goodou. Gai au e aau gee naa denga manu alasala mai i honga de henua, gai e deai naa donu hogi hebagi e hai i doodou henua. ");
INSERT INTO nkr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Gai goodou e doolohi naa oodou hagadaumee ga daa gilaadeu gu maakau i de gadilaasa. ");
INSERT INTO nkr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","E dogolima goodou e doolohi naa e lau oodou hagadaumee, gai e lau goodou e doolohi naa e dahisemada oodou hagadaumee, ga daa gilaadeu gu maakau i de gadilaasa. ");
INSERT INTO nkr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Gai au e abodonu adu naa gi goodou ga hai gi hagadili goodou gi soa, ma de hagasula dagu hagatoo donu hagaheloongoi gu hai madali goodou. ");
INSERT INTO nkr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Gai goodou goi gai naa donu huu oodou hua grain ne hagihagi ga doange i de ngadau gu hano, i de masavaa oodou e aau mai ai mee e doe, gi dahi ai mommee e doange ai oodou grain hoou. ");
INSERT INTO nkr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Gai au e hai naa dogu mommee noho i oodou magavaa, au gu dee kino i goodou. ");
INSERT INTO nkr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Au e seesee naa i oodou magavaa, ma de hai go doodou Maadua, gai goodou go ogu dangada. ");
INSERT INTO nkr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Go au donu go Iahweh doodou Maadua, go au ne hagassao ina mai goodou i de henua go Egypt, gi dee hai hegau ange ai goodou gi de gau Egypt; au gu hadihadi denga laagau hagahai hegau i honga oodou eu, ga hai gi maua e goodou i de tuu gi ssoe gi lunga ga seesee ai. ");
INSERT INTO nkr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Aagai noo goodou e dee hagallongo mai, ma tee daudali i muna nei alodahi, ");
INSERT INTO nkr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","gai noo goodou e hagangadi mee agu muna gu hagasauaa, ma de kino i agu hagamodu ma tee daudali i agu hainga alodahi ga oha ai dagu hagatoo donu hagaheloongoi, ");
INSERT INTO nkr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","gai deenei dagu hai e hai ai goodou: au e hai naa gi moolau de tae mai denga mee hagamaatagu gi goodou, ma de magi iviivi, ma de vvela o de angaanga e haia laa ga dee gide tangada, gai mahi o tangada e hagadagadaga mai. Goodou e doo naa oodou veelenga gai e dee haigamaiana adu gi goodou, i hiidinga go oodou hagadaumee e gaina. ");
INSERT INTO nkr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Gai au e huli adu naa ga hai baasi adu gi goodou, ma de hai oodou hagadaumee gi hagadee kii ina goodou; gai dangada e kino laa i goodou e dagi naa goodou, gai goodou e maatagu naa ga saavini gai e deai donu dangada e dolohia goodou. ");
INSERT INTO nkr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Noo goodou e duudagi donu huu tee hagallongo mai gi de au i dua mee nei, gai au e hagaduasala naa goodou gi hidu hanonga e kii ange ai i hiidinga o oodou haisala, ");
INSERT INTO nkr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","gai au e hai naa gi deai se mmahi oodou e hagamaolunga ai naa, gai au e hai naa lo te langi gi bei dagodo o de iron, gai de gelegele o doodou henua gu makaga bei de bronze. ");
INSERT INTO nkr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Goodou e hai hegau kona naa gai e deai naa donu haigamaiana, i hiidinga oodou gelegele e deai naa donu hua iai, gai oodou manu ssomo ange laa e deai naa hogi olaadeu hua. ");
INSERT INTO nkr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Noo goodou e hai baasi mai gi de au, ma tee llodo e hagallongo mai gi de au, gai au e hai gi hidu hanonga, e lagolago ange ai mee hagamaakau e paa i goodou, ma de hai gi bei dagodo o oodou haisala. ");
INSERT INTO nkr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Au e hai naa gi loomai denga manu alasala gi oodou magavaa, gai gilaadeu ga daa ai oodou dama ma oodou kaau, ma de hai goodou gi sogoisi, gai oodou haiava gu deai naa dangada e seesee ai. ");
INSERT INTO nkr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Gai noo de hagaduasala nei e dee maua i de hai goodou gi aahe mai gi de au, aagai goodou e duudagi huu de hai baasi mai gi de au, ");
INSERT INTO nkr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","gai au e hai baasi adu hogi gi goodou, ma de hagaduasala goodou gi kii ange i de hidu hanonga, i hiidinga oodou haisala. ");
INSERT INTO nkr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Gai au e hagaduasala naa goodou i de gadilaasa, e sui adu ai doodou oha dagu hagatoo donu hagaheloongoi. Gai de masavaa naa huu oodou e hagabuni i lodo oodou aduhale, gai au e gaamai naa denga mee hagamaakau gi daia goodou, ma de dugu ange oodou hagadaumee gi hagadee kii ina goodou. ");
INSERT INTO nkr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","De masavaa naa huu aagu e hai ai gi deai oodou gai, gai e dinoangahulu haahine e dao naa alaadeu momo pelaoaa i e dahi umu, gai gilaadeu e hagahidi naa pelaoaa laa ga duha dagi de momo. Goodou e gaimee naa, gai e dee maua gi boobosu. ");
INSERT INTO nkr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Gai noo goodou e dee hagallongo mai gi de au i dua de hai mee nei, gai e duudagi huu de hai baasi mai gi de au, ");
INSERT INTO nkr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","gai au e hai baasi adu naa gi goodou i dogu lili, ma de hagaduasala goodou gi hidu hanonga e kii ange ai i hiidinga oodou haisala. ");
INSERT INTO nkr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Goodou e daa naa oodou dama daane ma damaa hine ga gai. ");
INSERT INTO nkr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Gai au e oha naa oodou mommee daumaha, ma de duuduu iho oodou mommee e sigidaumaha ai mee maanongi, ma de maga ange oodou angaanga gu maakau gi honga oodou diinonga; gai au e kino naa i goodou. ");
INSERT INTO nkr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Au e oha naa gi maoha oodou aduhale, gai ni mommee dabu gi ngadi daakodo, gai au e dee hagadungu naa donu oodou sigidaumaha nnamu kala. ");
INSERT INTO nkr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Au e oha naa gi maoha doodou henua, gai oodou hagadaumee e nnoho laa i kilaa, e llele naa olaadeu mouli i ono dagodo. ");
INSERT INTO nkr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Gai au e hai naa goodou gi mavaevae saele i denga henua gee, au e hai naa gi daia goodou gi maakau i de gadilaasa. Doodou henua e hai naa ga se mommee e deai dangada e nnoho ai, gai oodou aduhale e oha naa ga maoha. ");
INSERT INTO nkr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Gai doodou henua e hagamabu naa i taulooloa teai dangada e nnoho ai, gai goodou gu nnoho i de henua o oodou hagadaumee; gai de henua e malangilangi naa i de hagamabu, ");
INSERT INTO nkr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","i de masavaa o de henua e ngadi dagodo ai. Go hiidinga tee dugu ange gi hagamabu i denga Sabbath, i de masavaa oodou e nnoho ai i kilaa. ");
INSERT INTO nkr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Gai au e hai naa gi maatagu dangada e doe i de henua o olaadeu hagadaumee. Gilaadeu e maatagu naa ga saavini i de ssau mai o de madangi ga ili saele denga lau manu. Gilaadeu e saavini naa bei dagodo o tangada e savini ga hano gee mai i de gadilaasa, gai gilaadeu e baakuu naa donu, e dee galemu e deai donu dangada e dolohia gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Gai gilaadeu e hagadau hedaadoi naa bei dagodo o dangada e saavini laa e hulo gee mai i de gadilaasa, gai e deai donu dangada e dolohia gilaadeu; gai goodou e dee maua naa donu i de hai baasi ange gi oodou hagadaumee. ");
INSERT INTO nkr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Goodou e maakau naa i denga henua gee, ma de maakau ga danu i henua o oodou hagadaumee. ");
INSERT INTO nkr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Gai dangada e doe laa i henua o oodou hagadaumee e odi naa i de maakau i hiidinga olaadeu baubau, ma hiidinga hogi baubau o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Aagai noo gilaadeu e tala olaadeu haisala ma haisala o olaadeu maadua madagidagi — delaadeu hai baasi mai gi de au, ma delaadeu tee hai hegau mai gi de au i de mee abodonu, ");
INSERT INTO nkr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","mee nei gu hai gi hai baasi ange au gi gilaadeu, gai au ne kave gilaadeu gi de henua o olaadeu hagadaumee — gai de masavaa naa huu e hagamaolalo ai olaadeu lodo, gai gilaadeu ga hagaduasala i hiidinga olaadeu haisala, ");
INSERT INTO nkr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","gai au e maanadu naa dagu hagatoo donu hagaheloongoi madali Jacob, ma Isaac aama Abraham, gai au e ahe ange naa ga manadua de henua. ");
INSERT INTO nkr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Aagai gilaadeu e hulo gee naa i de henua, gai de henua e hagamabu naa i de masavaa olaadeu e dee nnoho ai i kilaa; gai gilaadeu ga hagauda de hagaduasala i hiidinga olaadeu haisala, go hiidinga gilaadeu ne tili agu hagamodu, gai ne kino i agu muna gu hagasauaa. ");
INSERT INTO nkr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Aagai e dee galemu naa donu delaadeu hai mee nei alodahi, gai de masavaa naa huu olaadeu e nnoho ai i de henua o olaadeu hagadaumee, gai au e dee tili donu i gilaadeu, be e kino i gilaadeu, aabe daa gilaadeu gi odi i de maakau, ga oha ai dagu hagatoo donu hagaheloongoi ne hai madali gilaadeu. Go au donu go Iahweh delaadeu Maadua. ");
INSERT INTO nkr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Aagai au e hagamaanadu naa donu de hagatoo donu hagaheloongoi aagu ne hai madali olaadeu dubuna madagidagi, go gilaadeu aagu ne hagassao mai laa i de henua go Egypt, i madamada o de gau henua gee, gi go au ai delaadeu Maadua. Go au donu go Iahweh.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Aanei mee gu hagasauaa ma hagamodu aama hainga a Tagi Maolunga, ne hai madali de gau Israel i honga de mounga go Sinai ga gaavange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Basa ange gi de gau Israel, hai ange gi gilaadeu, ‘Noo tangada gu hagatoo donu e gaavange dahi dangada gi Tagi Maolunga, gai ia gi hagao ina taelodo gu lava i de hagamodu: ");
INSERT INTO nkr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","de hagabaaunga o taane gu madalua ono ngadau, ga hano ai gi de madaono se dagimadalima shekel selevaa, gai e hagabau bei shekel o de mommee dabu; ");
INSERT INTO nkr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","gai noo se hine, gai de hagabaaunga se matolu shekel. ");
INSERT INTO nkr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Gai noo go dahi gauligi gu lima ono ngadau, ga hanage ai gi de madalua: de hagabaaunga o de gauligi daane se madalua shekel, gai de gauligi hahine se madaangahulu shekel. ");
INSERT INTO nkr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Gai de gauligi gu dahi laa ono malama ga hanage ai gi de lima ngadau: de hagabaaunga o de gauligi daane se lima shekel selevaa, gai de gauligi hahine se dolu shekel selevaa. ");
INSERT INTO nkr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Gai noo tangada gu madaono ono ngadau ga hanage ai: de hagabaaunga o taane se madaangahulu ma lima shekel, gai de hine se madaangahulu shekel. ");
INSERT INTO nkr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Gai noo tangada ne haia de hagatoo donu e dee maua i de hagao, i hiidinga ia e hagaau aloha, gai ia gi gaamai tangada laa gi daho tangada haimeedabu, gai tangada haimeedabu gi hagabau ina ange de mee a tangada laa e maua i de hagao. ");
INSERT INTO nkr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Gai noo ia ne hagatoo donu i dahi manu dolodolo, e manu laa i de hai ai ssigidaumaha ange gi Tagi Maolunga, gai de manu gu gaavange laa gi Tagi Maolunga, gu dabu. ");
INSERT INTO nkr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Gai tangada ne haia de hagatoo donu laa e dee sui de manu laa, aabe gi hagahesuihagi ina ange de manu gi dahi manu gee, e dee hilihili be se manu danuaa aabe se manu baubau; aagai noo ia e hagahesuihagi ange de manu laa gi dahi manu gee, gai luu manu laa ngaadahi gu dabu. ");
INSERT INTO nkr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Gai noo ia ne hagatoo donu i dahi manu dee gilimalali — se manu e dee maua i de hai ai ssigidaumaha ange gi Tagi Maolunga — gai de manu laa e gaavee gi tangada haimeedabu, ");
INSERT INTO nkr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","gai tangada haimeedabu gi diiloo be se manu danuaa aabe e deai. Gai be dee hee naa huu de hagabaaunga aana e gaavange aagena, gai deelaa donu dono hagabaaunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Aagai noo tangada e lodo e hagao de manu laa e hagaahe mai, gai ia gi hagapunidia ange e dahi i diba i diba e lima gi de hagabaaunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Noo dahi dangada e vvae gee dono hale e hagadabu ange gi Tagi Maolunga, gai tangada haimeedabu gi hagamodu ina be e danuaa be deai; gai dee hee naa huu de hagabaaunga a tangada haimeedabu ne gaavange aagena, gai deelaa donu dono hagabaaunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Gai noo tangada e lodo e hagao dono hale gu lava laa i de hagadabu, gai ia gi hagapunidia ange e dahi diba i diba e lima madali de hagaoanga o de hale laa, gai ia gu maua i de ahe gi dono hale. ");
INSERT INTO nkr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Gai noo tangada gu vvae gee dahi mommee i de gelegele o dono huaabodu e hagadabu ange gi Tagi Maolunga, gai de hagaoanga o de gelegele laa e hagabau ange gi taelodo o denga golee e doo ai: se madalima shekel selevaa i dahi homer golee barley. ");
INSERT INTO nkr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Gai noo ia ne vvae gee dono gelegele ga hagadabu i de ngadau o de jubilee, gai ia e hagao alodahi de hagabaaunga gu gaavange laa aagena. ");
INSERT INTO nkr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Aagai noo tangada e vvae gee dono gelegele ga hagadabu i dua de ngadau o de jubilee, gai tangada haimeedabu gi hagabau ina ange de hagaoanga o denga ngadau e doe ga dae mai gi de ngadau o de jubilee e baa mai, gai de hagaoanga gu kii iho mai ange. ");
INSERT INTO nkr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Gai noo tangada gu lodo e ahe ange e hagao mai de gelegele aana gu vvae gee laa ma gu hagadabu, gai ia gi hagapunidia ange dahi diba i diba e lima madali de hagabaaunga, gai ia gu maua i de ahe ange gi dono gelegele. ");
INSERT INTO nkr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Aagai noo ia e dee lodo e ahe ange e hagao mai de gelegele laa, aabe ia gu hagao ange gi dahi dangada gee, aagai ia gu dee maua i de ahe ange e hagao. ");
INSERT INTO nkr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","De masavaa naa huu e hagaahe ange ai de gelegele i de ngadau o de jubilee, gai de gelegele e dabu, bei de gelegele gu vvae laa ma gu hagadabu ange gi Tagi Maolunga; de gelegele laa gu niio tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Noo tangada e vvae gee dahi gelegele aana gu hagao ga hagadabu ange gi Tagi Maolunga, gai e dee se gelegele ne bolo ange gi dono huaabodu, ");
INSERT INTO nkr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","gai tangada haimeedabu gi hagabaaunga ina ange de hagaoanga mai i de masavaa laa ga dae ai gi de ngadau o de jubilee, gai tangada laa gi hagao ina de hagabaaunga laa i de laangi laa donu huu, bei de mee gu hagadabu ange laa gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Gai de ngadau naa huu o de jubilee gai de gelegele laa e hagaahe ange gi tangada ne hagao ina ai laa gi daha, go tangada niiona de gelegele laa. ");
INSERT INTO nkr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Gai hagabaaunga o mee alodahi e hagabau i shekel o de mommee dabu, gai se madalua gerah i dahi shekel. ");
INSERT INTO nkr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Aagai e dee maua donu e dahi dangada i de ahe ange e hai gi dabu de manu e haanau i taamada, go hiidinga de manu laa gu nii Tagi Maolunga; e dee hilihili be se kaau aabe se ssiibi, de manu nei nii Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Gai noo de manu ne haanau i taamada e dee gilimalali, gai tangada e maua i de ahe ange ga hagao i de hagabaaunga gu hagabau ange aagena, gai ia gi hagapunidia ange e dahi diba i diba e lima madali de hagabaaunga laa. Gai noo ia e dee hagao, gai gi hagao ina gi daha i de hagabaaunga gu hagabau ange aagena. ");
INSERT INTO nkr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Aagai e deai donu se mee gu lava i de vvae gee a tangada ma gu hagadabu ange gi Tagi Maolunga — e dee hilihili be se dangada be se manu dolodolo, aabe se gelegele niio dono huaabodu — e hagao gi daha aabe go de ahe ange e hagao mai; go hiidinga mee alodahi gu vvae gee ma gu hagadabu ange gi Tagi Maolunga e dabu mmao. ");
INSERT INTO nkr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","E deai donu se dangada gu vvae ange laa gi Tagi Maolunga e daa gi magau e maua i de hagao e hagaola; tangada laa e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Gai dahi diba i diba e madaangahulu o de gelegele, e dee hilihili be ni grain be go hua o denga manu ssomo nnui, mee nei nii Tagi Maolunga; mee nei gu hagadabu ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Noo tangada e lodo e ahe ange e hagao hanu mee i dahi diba i diba e madaangahulu, gai ia gi hagapunidia ange dahi diba i diba e lima. ");
INSERT INTO nkr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Gai tahi diba i diba e madaangahulu o denga hagabuulingaa kaau ma ssiibi aau e dau, e hagadabu ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Gai tangada e dee hili denga manu danuaa, ia e dee hagahesuihagi hogi manu laa. Noo ia e hagahesuihagi manu laa, gai luu manu laa ngaadahi gu dabu, gai gu dee maua i de ahe ange e hagao.’ ” ");
INSERT INTO nkr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Aanei muna a Tagi Maolunga ne tala ange gi Moses i honga de mounga go Sinai ia gi daalaa ange gi de gau Israel.");
INSERT INTO nkr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Gai Tagi Maolunga ne hai ange gi Moses i de vao o Sinai i lo te hale malo hagabuni, i tahi laangi o de lua malama o de lua ngadau, i dua delaadeu ssao mai i de henua go Egypt. ");
INSERT INTO nkr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Daulia ga sisi denga daane Israel alodahi, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ga daohi de ingoo o dahi ma dahi. ");
INSERT INTO nkr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Gai gooluu ma Aaron ga dau denga hagabuulinga o denga daane o Israel gu dagimadalua olaadeu ngadau ga hanage ai, gu maua i de dau i de hebagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Gai hilia dagidahi daane mai i denga aamuli alodahi madali gooluu, e hai ai dagi o denga huaabodu i denga aamuli. ");
INSERT INTO nkr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Aanei ingoo o denga daane e balea adu gooluu: Mai i de aamuli o Reuben, go Elizur tama daane a Shedeur; ");
INSERT INTO nkr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","mai i de aamuli o Simeon, go Shelumiel tama daane a Zurishaddai; ");
INSERT INTO nkr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","mai i de aamuli o Judah, go Nahshon tama daane a Amminadab; ");
INSERT INTO nkr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","mai i de aamuli o Issachar, go Nethanel tama daane a Zuar; ");
INSERT INTO nkr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","mai i de aamuli o Zebulun, go Eliab tama daane a Helon; ");
INSERT INTO nkr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","mai i denga dama a Joseph: mai i de aamuli o Ephraim, go Elishama tama daane a Ammihud; mai i de aamuli o Manasseh, go Gamaliel tama daane a Pedahzur; ");
INSERT INTO nkr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","mai i de aamuli o Benjamin, go Abidan tama daane a Gideoni; ");
INSERT INTO nkr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","mai i de aamuli o Dan, go Ahiezer tama daane a Ammishaddai; ");
INSERT INTO nkr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","mai i de aamuli o Asher, go Pagiel tama daane a Ocran; ");
INSERT INTO nkr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","mai i de aamuli o Gad, go Eliasaph tama daane a Deuel; ");
INSERT INTO nkr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","mai i de aamuli o Naphtali, go Ahira tama daane a Enan.” ");
INSERT INTO nkr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aanei denga daane ne hili mai i denga hagabuulinga, e hai ai dagi o denga aamuli o olaadeu dubuna madagidagi. Gai go gilaadeu dagi o denga aamuli o de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Gai Moses ma Aaron ga hagabuni mai denga daane gu dau age nei olaadeu ingoo, ");
INSERT INTO nkr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","gai tahi laangi huu o de lua malama, gai gilaau ga hagabuni dangada alodahi, ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, mai de madalua ngadau ga hanage ai, ");
INSERT INTO nkr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","gai Moses ne dau dangada i de vao go Sinai, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Daane mai i de aamuli o Reuben, tama madua a Israel: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Gai taelodo o denga daane mai i de aamuli o Reuben se 46,500. ");
INSERT INTO nkr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Gai daane mai i de aamuli o Simeon: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Gai taelodo o denga daane mai i de aamuli o Simeon se 59,300. ");
INSERT INTO nkr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gai daane mai i de aamuli o Gad: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gai taelodo o denga daane mai i de aamuli o Gad se 45,650. ");
INSERT INTO nkr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Gai daane mai i de aamuli o Judah: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Gai taelodo o denga daane mai i de aamuli o Judah se 74,600. ");
INSERT INTO nkr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Gai daane mai i de aamuli o Issachar: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Gai taelodo o denga daane mai i de aamuli o Issachar se 54,400. ");
INSERT INTO nkr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Gai daane mai i de aamuli o Zebulun: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Gai taelodo o denga daane mai i de aamuli o Zebulun se 57,400. ");
INSERT INTO nkr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Gai daane mai i de aamuli o Joseph: daane mai i de aamuli o Ephraim: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Gai taelodo o denga daane mai i de aamuli o Ephraim se 40,500. ");
INSERT INTO nkr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Gai daane mai i de aamuli o Manasseh: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Gai taelodo o denga daane mai i de aamuli o Manasseh se 32,200. ");
INSERT INTO nkr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Gai daane mai i de aamuli o Benjamin: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Gai taelodo o denga daane mai i de aamuli o Benjamin se 35,400. ");
INSERT INTO nkr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Gai daane mai i de aamuli o Dan: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Gai taelodo o denga daane mai i de aamuli o Dan se 62,700. ");
INSERT INTO nkr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Gai daane mai de aamuli o Asher: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Gai taelodo o denga daane mai i de aamuli o Asher se 41,500. ");
INSERT INTO nkr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Gai daane mai i de aamuli o Naphtali: go daane alodahi gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau ga sisi olaadeu ingoo madali olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Gai taelodo o dangada mai i de aamuli o Naphtali se 53,400. ");
INSERT INTO nkr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Aanei daane a Moses ma Aaron ne dau, madali dagi o denga aamuli e dinoangahulu ma dogolua o de gau Israel, dahi ma dahi e sui dono huaabodu. ");
INSERT INTO nkr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Gai daane alodahi o Israel, gu dagimadalua olaadeu ngadau ga hanage ai, gai gu maua i de dau i de hebagi, ne dau madali huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Gai taelodo alodahi se 603,550. ");
INSERT INTO nkr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Aagai denga daane de aamuli o Levi tee dau madali daane o denga aamuli ange laa. ");
INSERT INTO nkr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Go hiidinga Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Koe e dee dau de aamuli o Levi, gilaadeu e dee sisi olaadeu ingoo madali de gau Israel ange laa. ");
INSERT INTO nkr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Aagai koe e hili de aamuli o Levi gi haia hegau o de tabernacle o de tala hagadonu, ma de tilo ange ono goloa alodahi, ma mee alodahi iai. Go gilaadeu e sabaia de tabernacle, ma ono goloa alodahi, ma de hai hegau i ono lodo. Gai gilaadeu gi hagatuulia olaadeu hale malo i luu baasi de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Gai de masavaa naa huu e hagangalue ai de tabernacle, gai go de aamuli o Levi e dugua ino iho, gai de masavaa naa huu e hagaahe age ai, gai go gilaadeu hogi e hagaduulia age. Aagai be goai naa huu tangada gee e hano ga hagabaa ange gi de tabernacle, gai e daa donu gi magau. ");
INSERT INTO nkr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Gai de gau Israel gi hagatuulia olaadeu hale malo i olaadeu hagabuulinga, dahi ma dahi ma dono hale gaainga, i gaogao delaadeu hagailonga; ");
INSERT INTO nkr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","aagai de aamuli o Levi e hagatuu olaadeu hale malo i luu baasi de tabernacle o de tala hagadonu, gi dee hagaduasala ina ai e de Maadua denga hagabuulinga o Israel. Gai go de aamuli o Levi gi diiloo ange, ma de hai hegau alodahi o de tabernacle o de tala hagadonu.” ");
INSERT INTO nkr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Gai de gau Israel ne hai donu ga bei muna alodahi a Tagi Maolunga ne tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Gai Tagi Maolunga ne hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“De gau Israel alodahi gi hagatuulia olaadeu mommee nnoho gaainga, i luu baasi de hale malo hagabuni. Dahi ma dahi gi noho i de mommee iai de hagailonga ma de flag o de huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Dangada e hagaduu delaadeu mommee nnoho gaainga i de baasi dua, go de mommee e sobo age ai de laa, go de aamuli o Judah ma olaadeu hagabuulinga, i lalo delaadeu hagailonga. Tagi o dangada o Judah go Nahshon, tama daane a Amminadab. ");
INSERT INTO nkr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Gai taelodo o dono hagabuulinga hebagi se 74,600. ");
INSERT INTO nkr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Gai go de aamuli o Issachar e mua ange gi de ia. Tagi o dangada o Issachar go Nathanael, tama daane a Zuar. ");
INSERT INTO nkr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Gai taelodo o dono hagabuulinga hebagi se 54,400. ");
INSERT INTO nkr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ga lava go de aamuli o Zebulun. Tagi o dangada o Zebulun go Eliab, tama daane a Helon. ");
INSERT INTO nkr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Gai taelodo o dono hagabuulinga hebagi se 57,400. ");
INSERT INTO nkr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Gai taelodo o dangada alodahi i de mommee nnoho gaainga o Judah, i olaadeu hagabuulinga se 186,400. Go gilaadeu e hulo i mada i mua i de masavaa o dangada e daga ai e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Gai de baasi ngaage go de hagailonga o de mommee nnoho gaainga o Reuben, ma olaadeu hagabuulinga. Tagi o dangada o Reuben go Elizur, tama daane a Shedeur. ");
INSERT INTO nkr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Gai taelodo o dono hagabuulinga hebagi se 46,500. ");
INSERT INTO nkr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Gai go de aamuli o Simeon e mua ange gi gilaadeu. Tagi o dangada o Simeon go Shelumiel, tama daane a Zurishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Gai taelodo o dono hagabuulinga hebagi se 59,300. ");
INSERT INTO nkr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ga lava go de aamuli o Gad. Tagi o dangada o Gad go Eliasaph, tama daane a Reuel. ");
INSERT INTO nkr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Gai taelodo o dono hagabuulinga hebagi se 45,650. ");
INSERT INTO nkr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Gai taelodo o dangada alodahi i de mommee nnoho gaainga o Reuben, i olaadeu hagabuulinga se 151,450. Gilaadeu go de lua hagabuulinga e daga e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Gai de hale malo hagabuni, madali de mommee nnoho gaainga o de aamuli o Levi i lo te ungaalodo laa. Gilaadeu e daga ga hulo, bei delaadeu hai e hagatau ai laa i de mommee nnoho gaainga, dahi aamuli i dono mommee i lalo dono hagailonga. ");
INSERT INTO nkr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Gai de baasi dai go de hagailonga o de mommee nnoho gaainga o Ephraim ma olaadeu hagabuulinga. Tagi o dangada o Ephraim go Elishama, tama daane a Ammihud. ");
INSERT INTO nkr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Gai taelodo o dono hagabuulinga hebagi se 40,500. ");
INSERT INTO nkr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Gai go de aamuli o Manasseh e mua ange gi gilaadeu. Tagi o dangada o de aamuli o Manasseh go Gamaliel, tama daane a Pedahzur. ");
INSERT INTO nkr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Gai taelodo o dono hagabuulinga hebagi se 32,200. ");
INSERT INTO nkr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ga lava go de aamuli o Benjamin. Tagi o dangada o Benjamin go Abidan, tama daane a Gideoni. ");
INSERT INTO nkr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Gai taelodo o dono hagabuulinga hebagi se 35,400. ");
INSERT INTO nkr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Gai taelodo o dangada alodahi i de mommee nnoho gaainga o Ephraim, i olaadeu hagabuulinga se 108,100. Gilaadeu go tolu hagabuulinga e daga e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Gai de baasi ngaiho go de hagailonga o de mommee nnoho gaainga o Dan ma olaadeu hagabuulinga. Tagi o dangada o Dan go Ahiezer, tama daane a Ammishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Gai taelodo o dono hagabuulinga hebagi se 62,700. ");
INSERT INTO nkr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Gai go de aamuli o Asher e mua ange gi gilaadeu. Tagi o dangada o Asher go Pagiel, tama daane a Ocran. ");
INSERT INTO nkr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Gai taelodo o dono hagabuulinga hebagi se 41,500. ");
INSERT INTO nkr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ga lava go de aamuli o Naphtali. Tagi o dangada o Naphtali go Ahira, tama daane a Enan. ");
INSERT INTO nkr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Gai taelodo o dono hagabuulinga hebagi se 53,400. ");
INSERT INTO nkr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Gai taelodo o dangada alodahi i de mommee nnoho gaainga o Dan se 157,600. Gai go gilaadeu hugadoo e loadu i muli ma olaadeu hagailonga.” ");
INSERT INTO nkr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Aanei de gau Israel ne dau, i huaabodu o olaadeu dubuna madagidagi. Gai dangada alodahi e nnoho i olaadeu mommee nnoho gaainga, i olaadeu hagabuulinga, se 603,550. ");
INSERT INTO nkr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Aagai de aamuli o Levi tee dau madali de gau Israel, bei de hai a Tagi Maolunga ne tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Gai de gau Israel ne hagassula mee alodahi a Tagi Maolunga ne tala ange gi Moses; gai de hai alaadeu ne hagatuu ai olaadeu mommee nnoho gaainga ma de nnoho i lalo olaadeu hagailonga, go de hai hogi olaadeu ne daga ai ga hulo, dahi ma dahi i dono aamuli ma dono hagadiilinga. ");
INSERT INTO nkr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Gai aanei huaabodu o Aaron ma Moses, i de masavaa a Tagi Maolunga ne basa ange ai gi Moses, i honga de mounga go Sinai. ");
INSERT INTO nkr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ingoo o dama daane a Aaron go Nadab, tama madua, ma Abihu, ma Eleazar aama Ithamar; ");
INSERT INTO nkr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aanei ingoo o dama daane a Aaron ne hagadabu i de lolo, gi haia hegau a de gau haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Gai Nadab ma Abihu ne maakau i mada luu mada o Tagi Maolunga, i de masavaa alaau ne hai ai ssigidaumaha i de ahi, e dee alaange de hai i mada luu mada o Tagi Maolunga, i de vao o Sinai. Gai gilaau teai donu alaau dama, gai go Eleazar ma Ithamar ne haia hegau a de gau haimeedabu, i de masavaa o delaadeu damana go Aaron e mouli ai. ");
INSERT INTO nkr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Gaamai de aamuli o Levi gaavange gilaadeu gi tangada haimeedabu go Aaron, gai gilaadeu ga bale ange ai ia. ");
INSERT INTO nkr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Gai gilaadeu ga hai ai hegau a Aaron aama de huaadangada i de mommee o de hale malo hagabuni, i delaadeu hai hegau i de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Gilaadeu gi diiloo ange denga goloa alodahi o de hale malo hagabuni, ma de hai hegau a de gau Israel i lo te tabernacle. ");
INSERT INTO nkr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Gai koe ga gaavange de aamuli o Levi gi balea ange Aaron ma ana dama daane; gilaadeu e gaavange gi de ia mai i daho de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Gai koe ga hili ange Aaron ma ana dama gi haia hegau a tangada haimeedabu; aagai noo dahi dangada gee e humai ga hagabaa mai, gai ia e daa donu gi magau.” ");
INSERT INTO nkr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Tilo, au gu vvae gee de aamuli o Levi i de gau Israel e sui ai denga dama daane madua e haanau laa i daho de gau Israel. Au gu kave de aamuli o Levi e hai gi niiagu, ");
INSERT INTO nkr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","go hiidinga denga ganimua alodahi niiagu. Go hiidinga de laangi aagu ne daa ai ga maakau denga ganimua i de henua go Egypt, gai au ne vvae gee denga ganimua a de gau Israel ga hai gi niiagu, e dee hilihili be go dama a dangada aabe go dama a denga manu. Gilaadeu nei niiagu. Go au go Iahweh.” ");
INSERT INTO nkr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Gai Tagi Maolunga ga hai ange gi Moses i de vao o Sinai, ");
INSERT INTO nkr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Daulia dama a Levi, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi. Daulia denga gaagaa gu dagidahi olaadeu malama ga hanage ai.” ");
INSERT INTO nkr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Gai Moses ne dau gilaadeu bei de hai a Tagi Maolunga gu tala ange ai laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Aanei ingoo o dama daane a Levi: go Gershon, ma Kohath, aama Merari. ");
INSERT INTO nkr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gai ingoo o dama daane a Gershon ne hai ai olaadeu hagadiilinga: go Libni ma Shimei. ");
INSERT INTO nkr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Gai dama daane a Kohath ne hai ai olaadeu hagadiilinga: go Amram, ma Izhar, ma Hebron, aama Uzziel. ");
INSERT INTO nkr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Gai dama daane a Merari ne hai ai olaadeu hagadiilinga: go Mahli ma Mushi. Aanei hagadiilinga o Levi mai i olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gai go daho Gershon ne daamada mai ai denga hagadiilinga o Libni ma Shimei; aanei hagadiilinga o Gershon. ");
INSERT INTO nkr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Gai taelodo o denga daane alodahi mai i de gaagaa gu dahi laa ono malama ga hanage ai e 7,500. ");
INSERT INTO nkr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gai denga hagadiilinga o Gershon ne hagaduu delaadeu mommee nnoho gaainga i baasi i dai de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","gai go Eliasaph tama daane a Lael tagi o de hagadiilinga o Gershon. ");
INSERT INTO nkr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gai mee a de hagadiilinga o Gershon e hai i de tabernacle: de hale malo ma mee e haoli ai, aama de malo e dau laa i de haitoga o de hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ma de malo e dau laa i luu baasi de buibui laa daha, ma de malo e dau laa i ma te haitoga o de buibui laa daha ma de mommee o ssigidaumaha, aama olaadeu uga, ma hegau alodahi e hai ange gi mee nei. ");
INSERT INTO nkr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Gai go daho Kohath ne daamada mai ai hagadiilinga o Amram, ma Izhar, ma Hebron aama Uzziel; aanei denga hagadiilinga o Kohath. ");
INSERT INTO nkr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Gai taelodo o denga daane alodahi ne dau gi haia hegau o de mommee dabu, mai i de gaagaa gu dahi laa ono malama ga hanage ai, se 8,600. ");
INSERT INTO nkr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Gai denga hagadiilinga o Kohath ne hagaduu delaadeu mommee nnoho gaainga i baasi ngaage de tabernacle, ");
INSERT INTO nkr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","gai go Elizaphan tama daane a Uzziel tagi o denga huaabodu o de hagadiilinga o Kohath. ");
INSERT INTO nkr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Gai go gilaadeu e diiloo ange de ngavesi o de hainga, ma teebele, ma de mee dugu laama, ma denga mommee o ssigidaumaha, ma denga goloa o de mommee dabu e hai ai laa hegau a de gau haimeedabu, ma de malo buibui o de aabi i lodo, ma hegau alodahi e hai ange gi mee nei. ");
INSERT INTO nkr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Gai go Eleazar tama daane a Aaron de hagaseesee o denga dagi o de aamuli o Levi, ma de dagitilo gilaadeu e haia hegau o de mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Gai go daho Merari ne daamada mai ai hagadiilinga o Mahli ma Mushi; aanei denga hagadiilinga o Merari. ");
INSERT INTO nkr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Gai taelodo o denga daane alodahi ne dau olaadeu ingoo, mai i de gaagaa gu dahi laa ono malama ga hanage ai, se 6,200. ");
INSERT INTO nkr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Gai tagi o denga huaabodu o hagadiilinga o Merari go Zuriel tama daane a Abihail; gilaadeu ne hagatuulia olaadeu hale nnoho gaainga i baasi i ngaiho de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Gai de hegau ne gaavange gi de hagadiilinga o Merari go denga laagau e hagaduu ai laa de tabernacle, ma denga laagau hagamakaga, ma duludulu, ma dagelo o denga duludulu, ma olaadeu goloa alodahi, ma hegau alodahi e hai ange gi mee nei; ");
INSERT INTO nkr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ma denga duludulu ma dagelo o de buibui laa daha, ma denga baalanga e daohi ai, aama uga e noonooa ange laa aagena. ");
INSERT INTO nkr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Gai dangada e hagatuulia olaadeu hale gaainga i de bido gi dua o de tabernacle, i ma te haitoga o de hale malo hagabuni, go de bido e sobo age ai de laa, go Moses ma Aaron aama dama daane a Aaron. Gai go gilaadeu e haia hegau i lo te mommee dabu, ma hegau alodahi a de gau Israel; gai noo dahi dangada gee e hagabaa ange gi de mommee laa, gai ia e daa donu gi maakau. ");
INSERT INTO nkr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Gai taelodo o daane alodahi i de aamuli o Levi, a Moses ma Aaron ne dau i denga huaabodu, bei dagodo muna a Tagi Maolunga, mai i denga gauligi gu dagidahi laa olaadeu malama ga hanage ai, se 22,000. ");
INSERT INTO nkr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Gai Tagi Maolunga ga hai ange gi Moses, “Daulia denga dama daane maatua alodahi a de gau Israel, mai i de gaagaa gu dahi laa ono malama ga hanage ai, ga daohi olaadeu ingoo. ");
INSERT INTO nkr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Gai koe ga vvae mai de aamuli o Levi e hai gi niiagu — go au go Iahweh — e sui ai denga dama daane maatua alodahi a de gau Israel, gai manu haangai a de aamuli o Levi, e sui ai dama maatua a manu haangai a de gau Israel ange laa.” ");
INSERT INTO nkr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Gai Moses ne dau denga dama daane maatua alodahi a de gau Israel ange laa, bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Gai taelodo o denga dama daane maatua alodahi ne dau, mai i de gaagaa gu dahi laa ono malama ga hanage ai, se 22,273. ");
INSERT INTO nkr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Gaavee de aamuli o Levi e sui ai denga dama daane maatua a de gau Israel ange laa, gai gaavee manu haangai a de aamuli o Levi, e sui ai manu haangai a dangada ange laa. De aamuli o Levi go ogu dangada; go au donu go Iahweh. ");
INSERT INTO nkr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Gai de hagaoanga o de 273 dama daane maatua a de gau Israel, e dubu ange laa i taelodo o denga daane de aamuli o Levi, ");
INSERT INTO nkr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","gai koe gaavee e dagilima shekel mai i daho denga dama daane maatua laa, ga hagabau i shekel o de mommee dabu; shekel nei se madalua gerah. ");
INSERT INTO nkr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Gai koe e gaavange sseene e hagao ai denga dama daane maatua laa, gi Aaron ma ana dama daane.” ");
INSERT INTO nkr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Gai Moses ne kave denga sseene, mai i daho denga dama daane maatua a de gau Israel, e dubu ange laa i taelodo o denga daane de aamuli o Levi. ");
INSERT INTO nkr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Gai taemaha o shekel ne kave mai, i daho denga dama daane maatua a de gau Israel se 1,365 shekel, gai ne hagabau i shekel o de mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Gai ia ne gaavange sseene laa gi Aaron ma ana dama daane, bei dagodo muna a Tagi Maolunga, ma de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Daulia denga daane i de hagadiilinga o Kohath, mai i de aamuli o Levi, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ga sisi olaadeu ingoo, ");
INSERT INTO nkr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","mai i de matolu ngadau ga hanage ai gi de madalima, go gilaadeu e haia hegau i de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Aanei hegau a de hagadiilinga o Kohath e hai i lo te hale malo hagabuni: go de tilo ange denga goloa dabu mmao alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","De masavaa naa huu o dangada i de mommee nnoho gaainga e ngaalue ai e hulo, gai Aaron ma ana dama daane gi dugua iho de malo buibui, ga haoli ai de ngavesi o de tala hagadonu. ");
INSERT INTO nkr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Gai gilaadeu gi haolia ono elunga i gili kaau lausedi, ga doha ange dahi malo buluu laa honga de gili kaau laa, ma de velo ange luu laagau e saabai ai gi olaau duulanga. ");
INSERT INTO nkr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Gai gilaadeu gi haoli teebele o pelaoaa i Mada Luoono Mada i dahi malo buluu, ga dugu ange denga gumedi gi ono elunga, aama ssaa e hai ai laa ssigidaumaha o mee maanongi; ma denga boolo, ma ubu e hai ai ssigidaumaha o mee unu; gai gi dugu donu huu denga pelaoaa e hagatau laa, i honga teebele i de laa tubua. ");
INSERT INTO nkr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Gai gilaadeu gi haolia teebele laa, ma mee i ono elunga i dahi malo mmea, gai haolia honga de malo laa i gili kaau lausedi, ga velo ange luu laagau e saabai ai gi olaau duulanga. ");
INSERT INTO nkr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Gilaadeu gi haia hogi dahi malo buluu, ga haolia ai de mee dugu laama e hagamaalama ai laa, madali ono laama, ma mee e diinei ai, ma ono gumedi, aama ssaa e hao ai lolo e haula ai laama. ");
INSERT INTO nkr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Gai gilaadeu gi sabinia de mee dugu laama ma ono goloa alodahi, i lo te gili kaau lausedi, ga dugu ange gi honga de hada e hagauda ai laa. ");
INSERT INTO nkr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Gai gilaadeu gi haolia hogi honga de mommee o ssigidaumaha goolo i dahi malo buluu, ga hoolaa ange gi ono elunga dahi malo gili kaau lausedi, ga velo ange luu laagau e saabai ai laa gi olaau duulanga. ");
INSERT INTO nkr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Gai gilaadeu gi hagabudulia denga goloa alodahi, e hai ai laa hegau o de mommee dabu ga hhao ange gi dahi malo buluu, ga doha ange gi honga dahi gili kaau lausedi, ga dugu ange gi honga de hada e saabai ai. ");
INSERT INTO nkr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Gai gilaadeu ga aaua gee denga lehu i honga de mommee o ssigidaumaha, gai ga haolia ono elunga i dahi malo purple. ");
INSERT INTO nkr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Gai gilaadeu ga dugu ange gi ono elunga, denga goloa alodahi e hai ai hegau o de mommee o ssigidaumaha: go mee e hhao ai denga maga ahi, ma poogo, ma savolo, ma boolo. Gai gilaadeu gi haolia ono elunga i dahi gili kaau lausedi, ma de velo ange luu laagau e saabai ai gi lodo olaau duulanga. ");
INSERT INTO nkr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Gai ga lava naa huu i de haoli a Aaron ma ana dama daane de mommee dabu ma ono goloa alodahi, gai de hagadiilinga o Kohath ga loomai ga saabai mee nei i de masavaa o dangada e daga ai e hulo. Aagai gilaadeu e dee poo ange donu gi goloa dabu nei, kana maakau gilaadeu. Aanei goloa o de hale malo hagabuni a de hagadiilinga o Kohath e saabai. ");
INSERT INTO nkr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Gai go Eleazar, tama daane a tangada haimeedabu go Aaron, e diiloo ange denga lolo e haula ai laa denga laama, ma mee maanongi, ma denga grain e hai ai laa ssigidaumaha, ma lolo hagasulu, ma de mommee dabu ma ono goloa alodahi.” ");
INSERT INTO nkr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Gooluu diiloo gi dee llilo denga hagadiilinga o Kohath, mai i magavaa o dangada i de aamuli o Levi. ");
INSERT INTO nkr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Aagai deenei dau hai e hai ai gilaadeu, gi dee maakau ai gilaadeu, i delaadeu loomai e hagapaa ange gi goloa dabu mmao laa: Aaron ma ana dana daane gi ulu gi lodo, gi vaevae ange hegau a dahi ma dahi aama ana mee e saabai. ");
INSERT INTO nkr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Aagai denga dama daane a Kohath e dee alaange i de ulu, i dahi damaa masavaa e tilo denga goloa dabu, gi dee maakau ai gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Daulia hogi denga daane i de hagadiilinga o Gershon, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ga sisi olaadeu ingoo, ");
INSERT INTO nkr_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","mai i de matolu ngadau ga hanage ai gi de madalima, go gilaadeu alodahi gu maua laa i de hai hegau o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Aanei hegau a hagadiilinga o Gershon e hai, go de saabai denga goloa: ");
INSERT INTO nkr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","gilaadeu e saabai malo e dau ai de tabernacle ma de hale malo hagabuni ma ono malo e haoli iho ai, ma gili kaau lausedi e haoli iho ai laa malo i honga de hale malo hagabuni, ma de malo e dau i de haitoga o de hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ma malo e dau ai de buibui laa daha, ma de malo e dau laa i ma te haitoga o de buibui laa daha o de tabernacle ma de mommee o ssigidaumaha, ma uga, aama goloa alodahi e dau ai luu baasi. Gai go gilaadeu e haia hegau alodahi o mee nei. ");
INSERT INTO nkr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gai go Aaron ma ana dama daane e daalaa ange hegau alodahi a de hagadiilinga o Gershon, alaadeu mee alodahi e saabai ma alaadeu hegau e hai. Gai koe ga tala ange gi gilaadeu alaadeu mee alodahi e hai aama de saabai. ");
INSERT INTO nkr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Aanei hegau a de hagadiilinga o Gershon e hai i lo te hale malo hagabuni, gai go Ithamar, tama daane a Aaron tangada haimeedabu delaadeu dagi. ");
INSERT INTO nkr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Gai koe daulia hogi denga daane i de hagadiilinga o Merari, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ga sisi olaadeu ingoo, ");
INSERT INTO nkr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","mai i de matolu ngadau ga hanage ai gi de madalima, go gilaadeu alodahi gu maua i de hai hegau i de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Gai deenei delaadeu hegau e hai i de hale malo hagabuni: gilaadeu e saabai denga laagau e hagaduu ai laa de tabernacle ma ono laagau hagamakaga, ma denga duludulu, aama denga dagelo, ");
INSERT INTO nkr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ma denga duludulu o de buibui laa daha alodahi ma olaadeu dagelo, ma denga baalanga e daohi ai, ma olaadeu uga, madali olaadeu goloa ma mee alodahi e hai ai olaadeu hegau; gai koe ga vvae ange gi dahi ma dahi ana mee e saabai. ");
INSERT INTO nkr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Aanei hegau a de hagadiilinga o Merari e hai, ma alaadeu hegau alodahi i de hale malo hagabuni, gai go Ithamar tama daane a Aaron, tangada haimeedabu delaadeu dagi.” ");
INSERT INTO nkr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Gai Moses ma Aaron aama dagi o dangada ne dau dangada i de hagadiilinga o Kohath, i denga aamuli ma huaabodu o olaadeu dubuna madagidagi. ");
INSERT INTO nkr_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Gai ne dau mai i de matolu ngadau ga hanage ai gi de madalima, go dangada alodahi gu maua i de hai hegau i lo te hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Gai taelodo o dangada ne dau i olaadeu hagadiilinga se 2,750. ");
INSERT INTO nkr_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Deenei taelodo o denga daane alodahi mai i de hagadiilinga o Kohath, go denga daane alodahi gu maua laa i de hai hegau i de hale malo hagabuni, go dangada a Moses ma Aaron ne dau bei dagodo muna a Tagi Maolunga ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gai dangada ne dau i de hagadiilinga o Gershon, mai i denga aamuli ma huaabodu o olaadeu dubuna madagidagi, ");
INSERT INTO nkr_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","mai i de matolu ngadau ga hanage ai gi de madalima, go gilaadeu alodahi gu maua i de hai hegau i lo te hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","gai taelodo alodahi i hagadiilinga ma huaabodu o olaadeu dubuna madagidagi se 2,630. ");
INSERT INTO nkr_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Deenei taelodo o hagadiilinga o Gershon, e haia hegau i de hale malo hagabuni. Gai Moses ma Aaron ne dau gilaadeu bei de hai a Tagi Maolunga gu tala ange ai. ");
INSERT INTO nkr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Gai dangada ne dau i hagadiilinga o Merari, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ");
INSERT INTO nkr_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","mai i de matolu ngadau ga hanage ai gi de madalima, go dangada alodahi gu maua laa i de hai hegau i de hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","gai taelodo ne dau i olaadeu hagadiilinga se 3,200. ");
INSERT INTO nkr_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Deenei taelodo o hagadiilinga o Merari. Gai Moses ma Aaron ne dau gilaadeu bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Gai taelodo o dangada alodahi a Moses ma Aaron, aama dagi o de gau Israel ne dau i de hagadiilinga o Levi, i olaadeu aamuli ma huaabodu o olaadeu dubuna madagidagi, ");
INSERT INTO nkr_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","mai i de matolu ngadau ga hanage ai gi de madalima, go gilaadeu alodahi gu maua laa i de hai hegau ma de saabai mee i de hale malo hagabuni: ");
INSERT INTO nkr_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","gilaadeu alodahi se 8,580. ");
INSERT INTO nkr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Dahi ma dahi ne vvae ange dana hegau aabe go dana mee e saabai i daho Moses, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. Gai Moses ne dau gilaadeu bei de hai a Tagi Maolunga gu tala ange ai gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Daalaa ange gi de gau Israel hai ange, gilaadeu gi dee dugua de gau mmagi lebelaa i de mommee nnoho gaainga, ma dangada alodahi e hanu mee e ssali mai i gilaadeu, ma gilaadeu e dee gilimalali i delaadeu hagapaa ange gi dahi dangada magau. ");
INSERT INTO nkr_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Gai goodou haia taane be go de hine bee nei gi noho i tua de mommee nnoho gaainga, kana haia e gilaadeu ga dee gilimalali de mommee noho gaainga, go de mommee oogu e noho ai i oodou magavaa.” ");
INSERT INTO nkr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Gai de gau Israel ne hai donu ga bei muna laa; gilaadeu ne hai de gau laa gi hulo i tua de mommee nnoho gaainga, bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Daalaa ange gi de gau Israel, hai ange, ‘De masavaa naa huu a dahi daane be se hine e haisala ange ai gi dahi dangada, i hiidinga dono dee hai hegau i de muna abodonu ange gi Tagi Maolunga, gai ia e haisala donu, ");
INSERT INTO nkr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","gai ia gi daalaa dagodo o de baubau aana gu hai laa. Ia ga hagao ana mee ne hagadee heohi laa, ga hagapuni ange dahi diba i diba e lima gi mee laa, ga gaavange gi tangada oona ne haisala ange laa aagena. ");
INSERT INTO nkr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Aagai noo gu deai donu se dangada i de huaabodu o tangada aana e maua i de hagao aagena ana hegau baubau gu hai laa, gai ia gi hagao ina ange mee laa gi Tagi Maolunga, ga gaavange gi tangada haimeedabu, madali dahi ssiibi daane, e tala ai ono haisala. ");
INSERT INTO nkr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Gai mee alodahi a de gau Israel e daohi age ga gaamai gi tangada haimeedabu, ni mee dabu, gai mee nei nii tangada haimeedabu. ");
INSERT INTO nkr_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Mee alodahi a tangada e hai gi dabu niiana donu huu, aagai mee alodahi e gaavange gi tangada haimeedabu, nii tangada haimeedabu.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Basa ange gi de gau Israel hai ange, ‘Noo de hine dau bodu gu haisala, ma tee hai hegau i de muna abodonu ange gi dono bodu, ");
INSERT INTO nkr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","gai dahi daane gee gu dagodo haisala madali de hine laa, gai dono bodu tee gidee, gai tigi iloo bolo ia gu dagodo haisala, (go hiidinga teai se dangada ne hagabaubau ina ia, aabe se dangada ne gidee dana hai de hegau laa), ");
INSERT INTO nkr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","gai noo dono bodu gu maagoda ange gi de hine laa, ma de maanadu bolo ia gu dagodo haisala; aabe ia ne maagoda i de hine laa, gai ia tigi dagodo haisala donu — ");
INSERT INTO nkr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","gai taane laa gi gaamai dono bodu gi daho tangada haimeedabu. Ia gi gaamai hogi dahi ssigidaumaha moo dono bodu: e dahi diba i diba e madaangahulu o dahi ephah pelaoaa lligi e hai i barley. Gai ia e dee gaavange lolo aagena aabe ni frankincense, go hiidinga se sigidaumaha o grain i de maagoda o taane, gai se mee e hai gi sula mai ai de muna abodonu. ");
INSERT INTO nkr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Gai tangada haimeedabu gi gaamai de hine laa gi mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Gai ia gi gaavee hanu vai dabu i lo te ssaa hadu, ma hanu gelegele i honga de gelegele i lo te tabernacle ga tili ange gi lodo vai laa. ");
INSERT INTO nkr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Gai tangada haimeedabu gi gaavee de hine laa gi mada luu mada o Tagi Maolunga, gai ia gi daalaa dono biho, ma de haoa ange gi lodo luu lima o de hine laa hanu hua grain e hai ai laa ssigidaumaha o de maagoda. Gai tangada haimeedabu gi boogia de ssaa, e hhao ai laa vai mmala e hagamalaia ai tangada. ");
INSERT INTO nkr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Gai tangada haimeedabu gi haia de hine laa gi hagatoo donu, ma de hai ange gi de ia, “Noo koe tigi dagodo haisala ma dahi daane gee, gai tigi dagodo haisala i de masavaa oou e hai bodu ange ai gi taane nei, gai koe e ola mai i denga vai mmala e gaamai de hagamalaia. ");
INSERT INTO nkr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Aagai noo koe gu dagodo haisala, i de masavaa oou e hai bodu ange ai gi taane nei, gai koe gu dee gilimalali i doo dagodo haisala ma dahi daane gee,” ");
INSERT INTO nkr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(gai tangada haimeedabu gi haia de hine laa gi haia de hagatoo donu o de hagamalaia, ma de hai ange gi de hine laa), “Tagi Maolunga gi haia goe gi se mee hakino gee ma de hagamalaia i magavaa o oo dangada, i de masavaa aana e hai ai gi mmagi mee i magavaa luoo vae, ma de hai gi hua doo dinae. ");
INSERT INTO nkr_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Gai denga vai aau ga unu nei gi haia de mee hagamalaia nei gi hano gi oo lodo, gi hua ai doo dinae gai mee i magavaa luoo vae gi iai de magi e dee maua laa gi ieiangi.” Gai de hine laa gi hai ange, “Amen, Amen.” ");
INSERT INTO nkr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Gai tangada haimeedabu gi siia muna hagamalaia nei i dahi beebaa, ga hai hanu vai ga hhui ange ai muna gu sisi laa gi lodo vai mmala laa. ");
INSERT INTO nkr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Gai ia ga hai de hine laa gi unumia vai mmala e hagamalaia ai laa, gai vai laa e hulo naa gi ono lodo ga hagamalaia ai ia ma de hai gi mmae ia. ");
INSERT INTO nkr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Gai tangada haimeedabu gi gaavee gee ssigidaumaha o denga grain ange gi de maagoda, mai i lodo luu lima o de hine laa, ga daodaohi age i mada luu mada o Tagi Maolunga, muli mai gai ia ga kave de mee laa gi de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Gai tangada haimeedabu gi buulia hanu mee mai i ssigidaumaha o denga grain, e hagamaanadu ai mee nei, ga dudu i honga de mommee o ssigidaumaha, gai ia ga haia de hine laa gi unumia vai laa. ");
INSERT INTO nkr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Gai dua naa huu dana hai de hine laa gi unumia vai laa, gai noo de hine laa gu hai gi hakino gee ia, gai tee hai hegau ange gi dono bodu i de mee abodonu, gai vai hagamalaia laa e hulo naa gi ono lodo ga hagaduasala ai ia; dono dinae e hua naa, gai mee i magavaa luoono vae e mmagi naa, ia gu dee maua gi ieiangi, gai ia gi se mee hagamalaia i magavaa o ono dangada. ");
INSERT INTO nkr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Aagai noo de hine laa tee hai gi hakino gee ia, gai e gilimalali huu, gai ia e ola mai naa i de hagamalaia laa, gai ia e hai dama naa ga haanau hanu dama. ");
INSERT INTO nkr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Deenei de hainga ange gi de maagoda, i de masavaa o de hine dau bodu e dagodo haisala ai madali dahi daane gee, ga hai ai ga hakino gee ia, ");
INSERT INTO nkr_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","aabe go de masavaa o taane dau bodu, e maagoda ange ai gi dono bodu. Gai ia gi gaavee de hine laa gi mada luu mada o Tagi Maolunga, gai tangada haimeedabu gi haia ange gi de hine laa, mee alodahi e tala laa i de hainga nei. ");
INSERT INTO nkr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Gai taane dau bodu laa e dee haisala donu i dahi mee laa, aagai de hine laa e hagauda donu de hagaduasala i hiidinga ono baubau.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Basa ange gi de gau Israel, hai ange, ‘Noo dahi daane aabe se hine e lodo e hai de hagatoo donu a de Nazirite, e vvae ange ai ia gi Tagi Maolunga; ");
INSERT INTO nkr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","gai ia e dee unu uvaini ma mee vii; ia e dee unu hogi denga vinegar e hai i uvaini aabe go mee mmahi. Ia e dee unu hogi vai o denga grapevine aabe e gai denga hua iai, e dee hilihili be go denga grape hoou, aabe ni grape mmasa. ");
INSERT INTO nkr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Gai ia gi dee gaina hanu mee e hai i denga grape, ia e dee gai donu hogi olaadeu golee be go olaadeu gili, i laangi aana e hai ai de hagatoo donu o de Nazirite. ");
INSERT INTO nkr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ia gi dee duudia hogi dono biho i laangi aana e hai ai de hagatoo donu nei. Ia e dabu ange gi Tagi Maolunga ga dae ai gi de odi ange ono laangi e hai ai gi se Nazirite; gai ia e dugu dono biho gi lloa. ");
INSERT INTO nkr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Gai laangi alodahi aana gu vvae gee ai ia e hagadabu ange gi Tagi Maolunga, gai ia gi dee hano gi hagabaa ange gi dahi dangada magau. ");
INSERT INTO nkr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","E dee hilihili donu be go dono damana be go dono dinana ne magau, aabe go dahi ono daina, ia gi dee alaange i de hai gi dee gilimalali ia; i hiidinga de hagailonga o dono vvae gee e hai gi dabu ange gi dono Maadua go dono biho lloa. ");
INSERT INTO nkr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Taulooloa ono laangi e vvae gee ai ia, gai ia gu hai gi dabu ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Gai noo dahi dangada e daa hagalele donu huu ga magau i ono gaogao, ga hai gu dee gilimalali dono biho gu hai laa ma gu dabu, gai ia gi daalia gi hidu laangi i dua de hai mee laa, gai ia ga dahi dono biho, gai ia gu ahe ange ga gilimalali. ");
INSERT INTO nkr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Gai de valu laangi, ia gi gaamai e lua manu kono be lua pigeon gi daho tangada haimeedabu i de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Gai tangada haimeedabu gi daia dahi manu laa gi haia ai ssigidaumaha o haisala, gai de manu ange laa ga hai ai ssigidaumaha dudu, e tala ai ono haisala, i hiidinga ia gu haisala i dono baa ange gi tangada magau. Gai ia gi vaaea gee dono biho gi haia gi dabu i de laangi laa donu huu, ");
INSERT INTO nkr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","gai ia gi ahe ange gi vaaea gee ia e hagadabu ange gi Tagi Maolunga. Ia gi gaamai dahi ssiibi daane gu dahi laa ono ngadau e hai ai ssigidaumaha o tagasala. Gai ana mee ne hai i mua gu dee dau, go hiidinga ia ne hai ga dee gilimalali, i de masavaa oona e vvae gee ai. ");
INSERT INTO nkr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Deenei de hainga ange gi de Nazirite, i de masavaa e odi ange ai laangi aana e vvae gee ai ia ga hai gi dabu. Ia e humai gi de haitoga o de hale malo hagabuni, ");
INSERT INTO nkr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ma dahi mee ngadi gaavange ange gi Tagi Maolunga: e dahi ssiibi daane gu dahi laa ono ngadau, gai e deai mee baubau i dono angaanga, e hai ai ssigidaumaha dudu, ma dahi ssiibi hahine e deai mee baubau i dono angaanga, gu dahi laa ono ngadau, e hai ai ssigidaumaha o haisala, ma dahi ssiibi daane, e deai mee baubau i dono angaanga, e hai ai ssigidaumaha hagadanuaa magavaa, ");
INSERT INTO nkr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ma dahi gede pelaoaa dee hagahua, go keege e hai i pelaoaa lligi gu hilo ma lolo, ma denga besgede dee hagahua gu hulu ange lolo aagena, madali ssigidaumaha o grain, aama olaadeu mee unu. ");
INSERT INTO nkr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Gai tangada haimeedabu gi gaamai mee nei gi mada luu mada o Tagi Maolunga, e hai ai ssigidaumaha o haisala aama ssigidaumaha dudu, ");
INSERT INTO nkr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","gai ia ga daa gi magau dahi ssiibi daane laa, e hai ai ssigidaumaha hagadanuaa magavaa ange gi Tagi Maolunga, madali denga pelaoaa dee hagahua i lo te gede laa; ia gi haia hogi ssigidaumaha o grain aama ssigidaumaha o mee unu. ");
INSERT INTO nkr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Gai de Nazirite gi dahia dono biho i de haitoga o de hale malo hagabuni, ga kave ngaangaaulu mai i dono biho ne hagadabu laa, ga dugu ange gi honga de ahi e hai ai laa ssigidaumaha hagadanuaa magavaa. ");
INSERT INTO nkr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Gai tangada haimeedabu gi gaavee de aalanga o de lima o ssiibi daane i dua de boale, madali dahi duudangaa pelaoaa ma dahi besgede dee hagahua mai i lo te gede laa, ga dugu ange gi lodo luu lima o de Nazirite, i dua de dahi ga malali dono biho. ");
INSERT INTO nkr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Gai tangada haimeedabu gi daodaohia age mee nei, e hai ai ssigidaumaha daodaohi age i mada luu mada o Tagi Maolunga. Mee nei gu hagadabu ange e hai ai tuuhanga o tangada haimeedabu, madali de aalanga o de aloalo gu daodaohi age laa ma de aalanga o de vae ne hai ai laa sigidaumaha. Gai dua naa huu mee nei gai de Nazirite gu maua i de unu denga uvaini. ");
INSERT INTO nkr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Aanei hainga ange gi de Nazirite e haia dahi hagatoo donu hai ngadaa, ma dana sigidaumaha ange gi Tagi Maolunga i de masavaa oona e hai ai gi se Nazirite. Gai noo ia ne maua i de hagatoo donu i hanu mee laa honga mee nei, gai ia gi haia donu gi bei de hainga oona ne hai ai laa ga se Nazirite.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Basa ange gi Aaron ma ana dama daane, hai ange, ‘Deenei doodou hai e hagamanuuia ai de gau Israel. Goodou hai ange gi gilaadeu: ");
INSERT INTO nkr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Tagi Maolunga gi hagamanuuia ina goe ma de tilo adu goe. ");
INSERT INTO nkr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tagi Maolunga gi hagamaalama ina goe i de maalama o luoono mada, ma de abodonu adu gi de goe. ");
INSERT INTO nkr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tagi Maolunga gi daumada ina goe ma de gaavadu gi de goe de baba.” ’ ");
INSERT INTO nkr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Gai gilaadeu gi hagaamua ina dogu ingoo i olaadeu daha, gai au ga hagamanuuia ai gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","De laangi huu a Moses ne hagaduu ai ga lava de tabernacle, ga hagadabu i lolo madali ono goloa alodahi, aama de hagadabu i lolo de mommee o ssigidaumaha ma ono goloa alodahi, ");
INSERT INTO nkr_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","gai dagi o denga aamuli o de gau Israel, go dagi o denga huaabodu o olaadeu dubuna madagidagi, go dangada gu dau ma gu sisi olaadeu ingoo, gilaadeu nei ne hai alaadeu sigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Gai gilaadeu ne gaamai alaadeu sigidaumaha gi mada luu mada o Tagi Maolunga: e ono hada, e madaangahulu ma lua kaau daane — e dogolua dangada e dahi alaau hada, gai dahi dangada e dahi ana kaau. Gilaadeu ne gaamai mee nei gi de tabernacle. ");
INSERT INTO nkr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Gaavee mee a denga dagi ne gaamai naa e hai ai hegau o de hale malo hagabuni, gai koe gaavange mee naa gi denga daane de aamuli o Levi, e hai ai alaadeu hegau.” ");
INSERT INTO nkr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Gai Moses ga kave denga hada laa ma denga kaau laa ga gaavange gi de aamuli o Levi. ");
INSERT INTO nkr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gai ia ne gaavange e lua hada ma e haa kaau gi de hagadiilinga o Gershon, e hai ai alaadeu hegau; ");
INSERT INTO nkr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","gai ia ne gaavange e haa hada ma e valu kaau gi de hagadiilinga o Merari e hai ai alaadeu hegau, gai go Ithamar tama daane a tangada haimeedabu go Aaron, e dagia gilaadeu ga hai ai alaadeu hegau. ");
INSERT INTO nkr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Aagai ia tee gaavange hanu mee gi de hagadiilinga o Kohath, i hiidinga go gilaadeu e sabaia denga goloa dabu laa i honga olaadeu eu. ");
INSERT INTO nkr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Gai dagi o denga aamuli ne gaamai alaadeu sigidaumaha ange gi de laangi e hagadabu ai ga hagasulu i lolo de mommee o ssigidaumaha; gai gilaadeu ne hai alaadeu sigidaumaha i mada i mua o de mommee o ssigidaumaha. ");
INSERT INTO nkr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Gai Tagi Maolunga ga hai ange gi Moses, “Dahi laangi e dahi dagi e hai dana sigidaumaha ange gi de hagadabu o de mommee o ssigidaumaha.” ");
INSERT INTO nkr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Gai tagi ne haia dana sigidaumaha i de laangi i taamada go Nahshon, tama daane a Amminadab, mai i de aamuli o Judah. ");
INSERT INTO nkr_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Nahshon, tama daane a Amminadab. ");
INSERT INTO nkr_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Gai de lua laangi go Nethanel, tama daane a Zuar, tagi o de aamuli o Issachar. ");
INSERT INTO nkr_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Nethanel, tama daane a Zuar. ");
INSERT INTO nkr_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Gai tolu laangi go Eliab tama daane a Helon, tagi o de aamuli o Zebulun. ");
INSERT INTO nkr_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Eliab, tama daane a Helon. ");
INSERT INTO nkr_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Gai de haa laangi go Elizur, tama daane a Shedeur, tagi o de aamuli o Reuben. ");
INSERT INTO nkr_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Elizur, tama daane a Shedeur. ");
INSERT INTO nkr_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Gai de lima laangi go Shelumiel tama daane a Zurishaddai, tagi o de aamuli o Simeon. ");
INSERT INTO nkr_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Shelumiel, tama daane a Zurishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Gai de ono laangi go Eliasaph, tama daane a Deuel, tagi o de aamuli o Gad. ");
INSERT INTO nkr_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Eliasaph, tama daane a Deuel. ");
INSERT INTO nkr_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Gai de hidu laangi Elishama, tama daane a Ammihud, tagi o de aamuli o Ephraim. ");
INSERT INTO nkr_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Elishama, tama daane a Ammihud. ");
INSERT INTO nkr_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Gai de valu laangi Gamaliel, tama daane a Pedahzur, tagi o de aamuli o Manasseh. ");
INSERT INTO nkr_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Gamaliel, tama daane a Pedahzur. ");
INSERT INTO nkr_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Gai ssiva laangi go Abidan, tama daane a Gideoni, tagi o de aamuli o Benjamin. ");
INSERT INTO nkr_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Abidan, tama daane a Gideoni. ");
INSERT INTO nkr_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Gai de madaangahulu laangi go Ahiezer, tama daane a Ammishaddai, tagi o de aamuli o Dan. ");
INSERT INTO nkr_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi olaadeu ngadau. Deenei ssigidaumaha a Ahiezer, tama daane a Ammishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Gai de madaangahulu ma dahi laangi go Pagiel, tama daane a Ocran, tagi o de aamuli o Asher. ");
INSERT INTO nkr_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Pagiel, tama daane a Ocran. ");
INSERT INTO nkr_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Gai de madaangahulu ma lua laangi go Ahira, tama daane a Enan, tagi o de aamuli o Naphtali. ");
INSERT INTO nkr_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ia ne gaamai e dahi gumedi selevaa baabaa e 130 shekel de daemaha, ma e dahi beisini selevaa e madahidu shekel de daemaha, e hagabau i de hagabaaunga o shekel o de mommee dabu, gai luu gumedi laa ngaadahi e hhao gi hoohonu i pelaoaa lligi gu hilo ma lolo, e hai ai ssigidaumaha o grain; ");
INSERT INTO nkr_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ma e dahi gumedi goolo e madaangahulu shekel de daemaha, e hhao ma e honu i mee maanongi; ");
INSERT INTO nkr_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ma e dahi kaau daane gauligi, ma e dahi ssiibi daane, ma e dahi ssiibi daane gu dahi laa ono ngadau, e hai ai ssigidaumaha dudu; ");
INSERT INTO nkr_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","aama e dahi guudi daane e hai ai ssigidaumaha o haisala; ");
INSERT INTO nkr_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","gai ange gi ssigidaumaha hagadanuaa magavaa: e lua kaau daane, ma e lima ssiibi daane, ma e lima guudi daane, aama e lima ssiibi daane gu dagidahi laa olaadeu ngadau. Deenei ssigidaumaha a Ahira, tama daane a Enan. ");
INSERT INTO nkr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Aanei mee a denga dagi o de gau Israel ne gaamai e hai ai ssigidaumaha e hagadabu ai de mommee o ssigidaumaha, i de laangi ne hagadabu ai: e madaangahulu ma lua gumedi selevaa baabaa, ma e madaangahulu ma lua beisini selevaa, aama e madaangahulu ma lua gumedi goolo; ");
INSERT INTO nkr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","gai dahi gumedi selevaa laa se 130 shekel de daemaha, denga beisini se madahidu shekel taemaha. Denga gumedi selevaa alodahi se dagi 2,400 shekel taemaha, mee nei ne hagabau i shekel o de mommee dabu. ");
INSERT INTO nkr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Gai denga gumedi goolo e madaangahulu ma lua laa e hhao ma e hoohonu i mee maanongi, dahi gumedi laa se madaangahulu shekel de daemaha, gai ne hagabau i shekel o de mommee dabu, gai gumedi goolo laa alodahi se 120 shekel taemaha. ");
INSERT INTO nkr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Gai denga manu alodahi ne gaamai e hai ai ssigidaumaha dudu, se madaangahulu ma lua kaau daane gauligi, ma e madaangahulu ma lua ssiibi daane, ma e madaangahulu ma lua ssiibi daane gu dagidahi olaadeu laa ngadau, madali denga grain e hai ai ssigidaumaha; aama e madaangahulu ma lua guudi daane e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Gai manu alodahi e hai ai ssigidaumaha hagadanuaa magavaa, se madalua ma haa kaau, ma e madaono ssiibi daane, ma e madaono guudi daane, aama e madaono ssiibi daane gu dagidahi laa olaadeu ngadau. Aanei mee ne hai ai ssigidaumaha e hagadabu ai de mommee o ssigidaumaha, i de masavaa ne hagadabu ai. ");
INSERT INTO nkr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Gai de masavaa huu o Moses ne ulu ai gi lo te hale malo hagabuni e basa ange gi Tagi Maolunga, gai ia ne langona dahi leo e basa mai gi de ia i honga de pono o de tala haisala, i honga de ngavesi o de tala hagadonu, i magavaa luu cherubim. ");
INSERT INTO nkr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Basa ange gi Aaron, hai ange gi de ia, ‘De masavaa naa huu aau e dugu age ai denga laama e hidu laa, gi olaadeu duulanga, gai haia laama laa gi hagamaalama ina de mommee i mada i mua o de mee dugu laama laa.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Gai Aaron ne hai ga bei muna nei; ia ne dugu age denga laama gi olaadeu duulanga, ga hai gi huuhuli ange gi mada i mua o de mee dugu laama, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Deenei de hai ne hai ai de mee dugu laama laa: ne dugidugi denga goolo i de haamaa ga hai ai, mai i tahido ga dae age ai gi denga huaala. Gai Moses ne hai de mee dugu laama gi bei de ada a Tagi Maolunga ne hagaago ange laa gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Vaaea gee denga daane de aamuli o Levi mai i de gau Israel, ga hagagilimalali gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Gai deenei dau hai e hai ai gi gilimalali gilaadeu: hagatoo madau ange denga vai hagagilimalali gi gilaadeu, gai gilaadeu ga dahi ngaangaaulu i olaadeu angaanga alodahi, ga taa olaadeu malo ga hai gi gilimalali gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Gai koe ga hai gilaadeu gi gaamai dahi kaau daane gauligi, ma hanu pelaoaa lligi gu hilo laa ma lolo; gai koe e kave hogi dahi kaau daane gauligi e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Gai koe ga hagabuni mai de gau Israel alodahi, ga gaamai denga daane de aamuli o Levi, gi de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Gai de masavaa naa huu aau e gaamai ai denga daane de aamuli o Levi gi Tagi Maolunga, gai de gau Israel alodahi gi dugua ange olaadeu lima gi olaadeu elunga, ");
INSERT INTO nkr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","gai Aaron gi gaavange denga daane de aamuli o Levi gi Tagi Maolunga, e hai ai ssigidaumaha daodaohi age mai i daho de gau Israel, gai gilaadeu ga hai ai hegau a Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Gai denga daane de aamuli o Levi gi dugua ange olaadeu lima gi honga biho o luu kaau laa; gai koe ga daa dahi ga hai ai ssigidaumaha o haisala, gai dahi ga hai ai ssigidaumaha dudu ange gi Tagi Maolunga, e tala ai haisala o denga daane de aamuli o Levi. ");
INSERT INTO nkr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Gai gaamai denga daane de aamuli o Levi gi tuu i mada i mua o Aaron ma ana dama daane, gai koe ga gaavange gilaadeu e hai ai ssigidaumaha daodaohi age ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Deenei dau hai e vvae gee ai denga daane de aamuli o Levi mai i de gau Israel, gai gilaadeu gu niiagu. ");
INSERT INTO nkr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Gai dua naa huu dau hagagilimalali denga daane de aamuli o Levi, ma de hai ssigidaumaha daodaohi age, gai gilaadeu ga ulu ga hai hegau i lo te hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Gilaadeu alodahi gu vvae mai gi de au, mai i magavaa o de gau Israel. Gilaadeu gu sui ai denga dama daane alodahi a de gau Israel e haanau i taamada, au gu kave gilaadeu e hai gi niiagu. ");
INSERT INTO nkr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Denga dama daane maatua alodahi a de gau Israel, ma manu alodahi e haanau i taamada niiagu. Au ne vvae gee gilaadeu e hai gi niiagu, i de laangi aagu ne daa ai ga maakau denga dama daane maatua alodahi i Egypt. ");
INSERT INTO nkr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Gai au gu kave denga daane de aamuli o Levi, e sui ai denga dama daane maatua alodahi a de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Gai au gu gaavange denga daane de aamuli o Levi, mai i magavaa o de gau Israel, e hai ai de mee ngadi gaavange ange gi Aaron ma ana dama daane, gai gilaadeu ga sui ai de gau Israel e hai hegau ai i de hale malo hagabuni, ma de tala ai haisala o de gau Israel, gi deai ai mee hagamaakau e loomai gi de gau Israel, i delaadeu loomai ga hagapaa ange gi de mommee dabu.” ");
INSERT INTO nkr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Gai Moses ma Aaron aama de hagabuulingaa dangada o Israel ne hagadabu denga daane de aamuli o Levi; gilaadeu ne hai denga daane de aamuli o Levi, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Gai denga daane de aamuli o Levi ne hagagilimalali gilaadeu mai i olaadeu haisala, ma de taa olaadeu malo; gai Aaron ga gaamai gilaadeu e hai ai ssigidaumaha daodaohi age ange gi Tagi Maolunga, gai Aaron ga tala olaadeu haisala ma de hagagilimalali gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Gai ga lava huu mee nei, gai denga daane de aamuli o Levi ga ulu ga hai alaadeu hegau i lo te hale malo hagabuni, e bale ange ai Aaron ma ana dama daane. Gai gilaadeu ne hai donu ga bei muna a Tagi Maolunga gu tala ange gi Moses, i dana hai e hai ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Deenei de hainga ange gi denga daane de aamuli o Levi: denga daane gu madalua ma lima olaadeu ngadau ga hanage ai e ulu gi hai hegau i lo te hale malo hagabuni; ");
INSERT INTO nkr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","gai mai i de madalima ngadau o tangada gai ia e hagammabu mai i ana hegau; ia gu lava ono hai hegau. ");
INSERT INTO nkr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Aagai gilaadeu e maua i de balea ange olaadeu daina i lo te hale malo hagabuni e dagitilo ai, gai gu deai donu alaadeu hegau e hai. Deenei dau hai e vaevae ange ai hegau a denga daane de aamuli o Levi.” ");
INSERT INTO nkr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Gai Tagi Maolunga ga basa ange gi Moses i de vao o Sinai, i tahi malama o de lua ngadau i dua delaadeu ssao ga hulo gee mai i de henua go Egypt, ga hai ange, ");
INSERT INTO nkr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Haia de gau Israel gi dao ina Taonga Hagasili i de masavaa gu hagailonga laa. ");
INSERT INTO nkr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Gai de madaangahulu ma haa naa huu laangi o de malama nei, i de ahiahi, gai goodou haia taonga nei i de masavaa gu hagababa; gai goodou ga hai gi bei ono hainga alodahi gu hagasauaa aama mee gu hagamodu e hai ai.” ");
INSERT INTO nkr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Deelaa ai, Moses ne hai ange gi de gau Israel gilaadeu gi dao ina Taonga Hagasili. ");
INSERT INTO nkr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Gai dangada ne hai Taonga Hagasili i de ahiahi o de madaangahulu ma haa laangi o tahi malama, i de vao o Sinai. Gai de gau Israel ne hai donu ga bei muna alodahi a Tagi Maolunga gu tala ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Aagai ne hanu dangada gu dee gilimalali i hiidinga delaadeu hagapaa ange gi dahi dangada magau, deelaa ai, gilaadeu tee maua i de gaimee i Taonga Hagasili i de laangi laa. Gai gilaadeu ne loomai gi daho Moses ma Aaron i de laangi laa, ");
INSERT INTO nkr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","gai denga daane laa ne hai ange gi de ia, “Gimaadeu gu dee gilimalali i demaadeu hagapaa ange gi tangada magau; gai gu aha gu buibui ai gimaadeu gi dee maua i de hai amaadeu sigidaumaha madali de gau Israel ange gi Tagi Maolunga i de masavaa gu baba laa?” ");
INSERT INTO nkr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Gai Moses ga hai ange gi gilaadeu, “Goodou daalia gai au ga hano e hagallongo be aahee muna a Tagi Maolunga e tala mai.” ");
INSERT INTO nkr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Daalaa ange gi de gau Israel hai ange, ‘Noo dahi goodou be go dahi oodou hagadiilinga gu dee gilimalali, i hiidinga ia gu hagabaa ange gi dahi dangada magau, aabe ia gu hano gi dahi mommee mmao, gai ia e maua i de dao Taonga Hagasili ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Gai gilaadeu gi haia Taonga Hagasili i de ahiahi o de madaangahulu ma haa laangi o de lua malama; gilaadeu gi gaina kano manu ma pelaoaa dee hagahua aama mee mmala e hai i denga manu ssomo. ");
INSERT INTO nkr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Gai gilaadeu gi dee dugua hanu kano manu laa gi doe gi taiao age, gai gi dee hadihadia denga ivi o de manu laa, bei dagodo o denga hainga alodahi gu hagasauaa ange gi Taonga Hagasili. ");
INSERT INTO nkr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Aagai tangada naa huu e gilimalali laa, gai tigi hano hogi gi dahi henua mmao, gai ia tee dao Taonga Hagasili, gai ia e vvae gee donu mai i daho ono dangada, i hiidinga ia tee gaavange gi Tagi Maolunga ssigidaumaha i de masavaa gu baba laa; gai ia e hagaduasala donu i ono haisala. ");
INSERT INTO nkr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Gai noo dahi dangada henua gee e noho laa i oodou daha, e lodo e dao Taonga Hagasili ange gi Tagi Maolunga, bei de hai gu hagasauaa ai laa i denga hainga o Taonga Hagasili, gai ia e maua; gai de hainga se mee ange gi de gau henua gee aama adu gi goodou.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Gai de laangi huu ne duu age ai de tabernacle, gai de hagausinga ne haoli de tabernacle, go de hale malo o de tala hagadonu; gai de ahiahi huu gai gu bei dagodo o de ahi ula i honga de tabernacle ga dae ai gi taiao age. ");
INSERT INTO nkr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Gai aanei ono dagodo i masavaa alodahi; de hagausinga e haoli de hale malo hai daumaha i de laangi, gai de boo e ula bei de ahi. ");
INSERT INTO nkr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Gai de masavaa naa huu o de hagausinga laa e ngalue gee ai i honga de hale malo laa, gai de gau Israel ga daga ga hulo; gai be go hee naa huu o de hagausinga laa e hano ga noho ai, gai de gau Israel ga hagatuu age olaadeu hale gaainga i kilaa ga nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Gai de masavaa naa huu a Tagi Maolunga e hai ange ai gilaadeu gi hulo, gai de gau Israel ga daga ga hulo, gai de masavaa naa huu a Tagi Maolunga e hai ange ai gilaadeu gi nnoho, gai gilaadeu ga hagatuu olaadeu hale malo ga nnoho ai. Gai taulooloa de duu o de hagausinga laa i honga de tabernacle, gai gilaadeu e nnoho donu huu i de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Gai ga ni laangi lagolago naa donu o de hagausinga laa e dee ngalue gee ai mai i honga de tabernacle, gai de gau Israel e hai gi bei muna a Tagi Maolunga, gilaadeu e dee ngaalue donu. ");
INSERT INTO nkr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Hanu masavaa gai e sogoisi donu huu laangi o de hagausinga e duu ai i honga de tabernacle, gai dangada e nnoho donu huu i de mommee nnoho gaainga, bei dagodo muna a Tagi Maolunga; gai dangada e ngaalue hogi ga hulo, bei dagodo muna a Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Hanu masavaa gai de hagausinga laa e noho donu huu mai i de ahiahi ga dae ai gi taiao age; gai de masavaa naa huu o de hagausinga laa e ngalue gee ai i taiao age, gai dangada ga daga ga hulo. E dee hilihili be se boo aabe se laangi, o de hagausinga laa e ngalue gee ai, gai de masavaa naa huu e ngalue ai, gai dangada ga ngaalue hogi ga hulo. ");
INSERT INTO nkr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Gai e dee hilihili be e lua laangi, be se dahi malama, aabe se ngadau e duu ai de hagausinga laa i honga de tabernacle, gai de gau Israel e nnoho donu huu i de mommee nnoho gaainga, gilaadeu e dee ngaalue donu; aagai ga ngalue naa huu de hagausinga, gai dangada ga daga ga hulo. ");
INSERT INTO nkr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Gai ga hai ange naa huu Tagi Maolunga gilaadeu gi nnoho, gai gilaadeu gu nnoho. Gai ga hai ange naa huu Tagi Maolunga gilaadeu gi ngaalue ga hulo, gai gilaadeu ga daga ga hulo; bei de hai a Tagi Maolunga gu tala ange ai laa gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Dugidugia hanu selevaa haia ai e lua trumpet; gai koe ga ili luu trumpet laa i de masavaa e hagabuni ai de huaadangada, ma de masavaa o dangada e hagadabena ai e ngaalue e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","De masavaa naa huu e ili ai luu trumpet nei ngaadahi, gai de huaadangada gi hagabuni mai gi oo daha i de haitoga o de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Aagai noo e dahi donu huu trumpet e ili, gai go dagi donu huu o denga hagadiilinga o de gau Israel, e hagabuni mai gi oo daha. ");
INSERT INTO nkr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Gai de masavaa naa huu oodou e ili ai de trumpet i e dahi hanonga, gai dangada e nnoho gaainga i de baasi i dua gi ngaalue gi hulo. ");
INSERT INTO nkr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Gai de masavaa naa huu oodou e ili ai de trumpet i de lua hanonga, gai dangada e nnoho gaainga i baasi i ngaage gi ngaalue gi hulo. Gai go de ili o de trumpet e hagailonga ai de masavaa o dangada e ngaalue ai e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Gai de masavaa naa huu e hagabuni ai de huaadangada, gai e dee ili de trumpet bei hanonga ange laa, gai e ili gi daulooloa. ");
INSERT INTO nkr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Gai go dama daane a Aaron gu hai ai laa de gau haimeedabu e ilihia denga trumpet. Gai de mee nei se hainga gu hagasauaa adu gi goodou ma oodou atangada ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Gai de masavaa naa huu oodou e hebagi ange ai gi oodou hagadaumee i honga doodou henua donu, gai goodou ga ili hagapodo luu trumpet laa, gi manadua ai e Tagi Maolunga doodou Maadua goodou, gai ia ga hagaola ai goodou mai i oodou hagadaumee. ");
INSERT INTO nkr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Gai goodou e ilihia hogi luu trumpet laa, i laangi oodou daonga ai ga malangilangi — go masavaa o oodou daonga gu hagailonga ma daonga o de duu de maasina i dai, i de masavaa e hai ai oodou sigidaumaha dudu, aama oodou sigidaumaha hagadanuaa magavaa, gi manadua ai e Maadua goodou. Go au go Iahweh doodou Maadua.” ");
INSERT INTO nkr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Gai de lua ngadau huu, i de madalua laangi o de lua malama, gai de hagausinga gu ngalue gee mai i honga de tabernacle o de tala hagadonu, ");
INSERT INTO nkr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","gai de gau Israel ne ngaalue gee mai i de vao o Sinai ga hagadaga saele i de vao, ga dae ai gi de hano o de hagausinga laa ga noho i de vao o Paran. ");
INSERT INTO nkr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Deenei tahi hanonga a Tagi Maolunga ne hai ange gi Moses, gilaadeu gi ngaalue gi hulo. ");
INSERT INTO nkr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Gai go denga hagabuulinga o de aamuli o Judah ma delaadeu hagailonga ne hulo i mua. Gai delaadeu dagi go Nahshon, tama daane a Amminadab. ");
INSERT INTO nkr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Gai tagi o denga hagabuulinga o de aamuli o Issachar go Nethanel, tama daane a Zuar. ");
INSERT INTO nkr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Tagi o denga hagabuulinga o de aamuli o Zebulun go Eliab, tama daane a Helon. ");
INSERT INTO nkr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Gai gu dugu iho de tabernacle, gai go denga daane de aamuli o Gershon ma de aamuli o Merari ne sabaia de tabernacle ga hulo ai gilaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Gai go denga hagabuulinga o de aamuli o Reuben, ma delaadeu hagailonga e loadu i olaadeu dua. Gai delaadeu dagi go Elizur, tama daane a Shedeur. ");
INSERT INTO nkr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Gai tagi o de hagabuulinga o de aamuli o Simeon go Shelumiel, tama daane a Zurishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Tagi o de hagabuulinga o de aamuli o Gad go Eliasaph, tama daane a Deuel. ");
INSERT INTO nkr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Gai go de aamuli o Kohath, e loadu i olaadeu dua, gai gilaadeu e saabai denga goloa dabu. Gai de tabernacle e hai gi duu age i mua delaadeu tae gi kilaa. ");
INSERT INTO nkr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Gai go denga hagabuulinga o de aamuli o Ephraim e hanadu i olaadeu dua ma delaadeu hagailonga; gai delaadeu dagi go Elishama tama daane a Ammihud. ");
INSERT INTO nkr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gai tagi o denga hagabuulinga o de aamuli o Manasseh go Gamaliel, tama daane a Pedahzur. ");
INSERT INTO nkr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Tagi o denga hagabuulinga o de aamuli o Benjamin go Abidan, tama daane a Gideoni. ");
INSERT INTO nkr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Gai go denga hagabuulinga o de aamuli o Dan hugadoo, ma delaadeu hagailonga e loadu i muli. Gai delaadeu dagi go Ahiezer, tama daane a Ammishaddai. ");
INSERT INTO nkr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Gai tagi o denga hagabuulinga o de aamuli o Asher go Pagiel, tama daane a Ocran. ");
INSERT INTO nkr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Tagi o denga hagabuulinga o de aamuli o Naphtali go Ahira, tama daane a Enan. ");
INSERT INTO nkr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Deenei de hai ne hagatau ai de gau Israel ma olaadeu hagabuulinga, i de masavaa olaadeu e ngaalue ai e hulo. ");
INSERT INTO nkr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Gai Moses ga hai ange gi Hobab tama daane a Reuel, taane Midian, go dono saulaba, “Gimaadeu ga hulo nei gi de mommee a Tagi Maolunga gu hai mai, ‘Au e gaavadu naa de mommee nei gi goodou.’ Humai madali gimaadeu, gai gimaadeu ga abodonu adu gi de goe, go hiidinga Tagi Maolunga gu hagatoo donu ange mee danuaa gi de gau Israel.” ");
INSERT INTO nkr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ia ga hai ange gi Moses, “Au e dee hano madali goodou; gai au e ahe e hano gi dogu henua ma daho ogu dangada.” ");
INSERT INTO nkr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Gai Moses ga hai ange, “Au e dangidangi adu koe gi dee hano gee i omaadeu daha, go hiidinga koe e iloo denga mommee danuaa gi de nnoho gaainga ai i de vao, gai koe ga dagi ai gimaadeu. ");
INSERT INTO nkr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Noo koe e humai madali gimaadeu, gai be se aha naa huu a Tagi Maolunga e abodonu mai ai gi gimaadeu, gai gimaadeu ga abodonu adu ai hogi gi de goe.” ");
INSERT INTO nkr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Gai de gau Israel ne ngaalue ga hulo gee mai i de mounga o Tagi Maolunga, gai gilaadeu ne seesee ga hulo i e dolu laangi. Gai de ngavesi o de hagatoo donu hagaheloongoi a Tagi Maolunga, e hano i olaadeu mada i mua i laangi e dolu laa, e ssala ai delaadeu mommee e hagammabu ai. ");
INSERT INTO nkr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Gai de hagausinga a Tagi Maolunga e duu i elunga i de laangi, i masavaa olaadeu e ngaalue ai e hulo gee. ");
INSERT INTO nkr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Gai masavaa naa huu o de ngavesi laa e hagangalue ai e hano, gai Moses ga hai ange, “Tagi Maolunga, hidi age haia gi mavaevae saele oo hagadaumee; gai gilaadeu e kino i de goe gi saavini gi hulo gee mai i de goe.”  ");
INSERT INTO nkr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Gai de masavaa naa huu o de ngavesi laa e haganoho ai, gai ia ga hagadaba, “Tagi Maolunga, ahe mai gi daho oo dangada go de gau Israel, e dee maua laa i de dau.” ");
INSERT INTO nkr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Gai dangada ga nnanu i Tagi Maolunga i hiidinga delaadeu hai ngadaa. Gai ga langona huu e Tagi Maolunga, gai ia gu bole mmao, gai de ahi mai i daho Tagi Maolunga gu ula i olaadeu magavaa ga dudu hanu mommee i luu baasi de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Gai dangada ga tangi ange gi Moses; gai Moses ga dalodalo ange gi Tagi Maolunga, gai de ahi laa gu made. ");
INSERT INTO nkr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Deelaa ai, de mommee laa gu hagaingoo ange go Taberah, i hiidinga de ahi a Tagi Maolunga ne ula i olaadeu magavaa. ");
INSERT INTO nkr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Gai de gau henua gee ne hulo laa madali gilaadeu e kona de llodo e gai kano manu; gai de gau Israel ne tangi hogi ga hagataba, “Mee naa gi hanu amaadeu giidagi e gai! ");
INSERT INTO nkr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Gimaadeu e manadua denga mamu amaadeu nogo gai i Egypt, ma kiulii, ma suiigaa, ma leek, ma aaniana, aama garlic; ");
INSERT INTO nkr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","aagai iainei gimaadeu gu mmala amaadeu maanga, i hiidinga gu deai ange donu amaadeu mee e gai, go denga manna nei donu huu.” ");
INSERT INTO nkr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","De manna e bei de golee o de coriander, e mada tea ganoango. ");
INSERT INTO nkr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Gai dangada ne hulo ga hagabudu mai ga mmili i de mee mmili, aabe tugi i denga hadu, ga boale i lodo anibada, ma de hai ai denga keege; gai e mami bei de keege e hai laa i lolo. ");
INSERT INTO nkr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","De masavaa naa huu e hano iho ai de mee suungia gi honga de mommee nnoho gaainga i de boo, gai denga manna gu too iho hogi. ");
INSERT INTO nkr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Gai Moses gu langona de nnanu o dangada i denga huaabodu i gaogao haitoga o olaadeu hale malo; gai Tagi Maolunga gu bole mmao, gai Moses gu dee malangilangi. ");
INSERT INTO nkr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Gai Moses ga hai ange gi Tagi Maolunga, “Gu aha goe gu hai ai nei doo dangada hai hegau bee nei? Koe gu dee malangilangi nei i de au, gai koe ga hai ai nei au gi hagaudalia taemaha o de gau soa nei? ");
INSERT INTO nkr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Go au ne hagadili ina be ne hanaua de gau soa nei? Gai koe ga hai mai ai naa au gi sabaia gilaadeu i dogu aloalo, bei de hai a tamana e saabai ai laa dana dama i dono aloalo, ga kave gilaadeu gi tae gi de henua aau gu hagatoo donu ange gi olaadeu dubuna madagidagi? ");
INSERT INTO nkr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Go hee aagu e hai ai hanu giidagi e gaavange gi de huaadangada nei? Go hiidinga gilaadeu gu tangi ma e hai mai, ‘Gaamai hanu giidagi e gai gimaadeu.’ ");
INSERT INTO nkr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Au gu dee maua i de tilo ange de huaadangada nei alodahi, de hegau nei e gona odi taemaha mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Noo deenei dau hai e hai ai au, gai au e dangidangi adu koe gi daia donu au gi magau iainei, noo koe e malangilangi i de au, gai koe aude hagaduasala ina au i de mee nei.” ");
INSERT INTO nkr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Gai Tagi Maolunga ga hai ange gi Moses, “Gaamai e dinohidu daane maatua o Israel, aau e iloo laa bolo ni dagi gai ni biho i honga o dangada; gaamai gilaadeu gi de hale malo hagabuni gi tuu i kilaa madali goe. ");
INSERT INTO nkr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Gai au e hano iho naa ga basa adu gi de goe i kilaa; gai au e kave naa hanu mahi mai i daho de Hagasaalunga i oo daha naa ga gaavange gi gilaadeu; gai gilaadeu ga bale adu ai goe ga hagauda daemaha o dangada, gi dee go koe ai donu huu e hagauda ina taemaha naa. ");
INSERT INTO nkr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Gai koe hai ange gi dangada, ‘Goodou haia gi dabu goodou ange gi daiao, gai goodou e gai naa donu hanu giidagi. Tagi Maolunga gu langona e ia doodou tangi ma e hagataba: “Mee naa gi hanu amaadeu giidagi e gai! Gimaadeu ne kii ange i de duadonu i Egypt!” Deenei ai, Tagi Maolunga e gaavadu naa donu hanu giidagi e gai goodou. ");
INSERT INTO nkr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Gai e dee dahi naa donu huu oodou laangi e gai ai, be lua laangi, be lima laangi, be madaangahulu laangi, aabe madalua laangi, ");
INSERT INTO nkr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","aagai goodou e gai naa denga giidagi i dahi huaamalama, ga dae ai gi doodou kino i de gai, i hiidinga goodou ne hagangadi mee Tagi Maolunga e noho laa i oodou magavaa, gai goodou ne nnanu ange gi de ia, ga hai ange, “Gu aha gu hagassao mai ai nei gimaadeu i Egypt?” ’ ” ");
INSERT INTO nkr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Aagai Moses ga hai ange, “Se onoseguli dangada alodahi aagu ne dagi mai, gai koe gu hagatoo donu bolo koe e gaavange hanu giidagi e gai gilaadeu i dahi huaamalama! ");
INSERT INTO nkr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Gai e maua naa donu gi dohu gilaadeu noo gu daa amaadeu ssiibi ma amaadeu kaau alodahi e gaimee ai gilaadeu? Gai e maua naa donu gi dohu gilaadeu noo e hagabudu mai denga mamu alodahi i lo te lausedi e gaimee ai gilaadeu?” ");
INSERT INTO nkr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Gai Tagi Maolunga ga hai ange gi Moses, “E dahi nei mee daudahi a ssauaa o Tagi Maolunga e dee maua i de hai? Iainei gai koe e gidee naa be agu muna ni muna abodonu be deai.” ");
INSERT INTO nkr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Deelaa ai, Moses ne hano ga tala ange muna a Tagi Maolunga gi dangada; gai ia ga hagabuni mai e dinohidu daane maatua o de huaahenua ga hai gilaadeu gi tuu i luu baasi de hale malo. ");
INSERT INTO nkr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Gai Tagi Maolunga ga hano iho mai i lo te hagausinga laa ga basa ange gi Moses, gai ia ga kave hanu mahi o de Hagasaalunga i daho Moses ga gaavange gi denga daane maatua e dinohidu laa. Gai de masavaa huu o de Hagasaalunga ne noho ai i olaadeu daha, gai gilaadeu ga pasa pelaabisi, aagai gilaadeu tee aahe ange e pasa pelaabisi i muli mai. ");
INSERT INTO nkr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Gai e dogolua daane maatua laa ne nnoho donu huu i de mommee nnoho gaainga, de ingoo o dahi go Eldad, gai de ingoo o taane ange laa go Medad, gai de Hagasaalunga ne humai hogi gi olaadeu elunga. Gilaau ni daane hogi ne sisi olaau ingoo madali denga daane ange laa, aagai gilaau tee hulo gi de hale malo hagabuni; gai gilaau ne pasa pelaabisi hogi i de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Gai dahi dama daane ne savini ga hano ga tala ange gi Moses, bolo Eldad ma Medad e pasa pelaabisi i de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Gai Joshua tama daane a Nun, tangada bale o Moses, gai go dahi daane ne hili laa, ga hai ange, “Dogu dangada aamua go Moses, hai ange gilaau gi dee pasa pelaabisi!” ");
INSERT INTO nkr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Gai Moses ga hai ange gi de ia, “Koe gu magiaa ange naa gi gilaau i ogu hiidinga? Mee naa dangada alodahi o Tagi Maolunga gi ni pelaabisi gai Tagi Maolunga gi haia gi humai dono Hagasaalunga gi olaadeu elunga!” ");
INSERT INTO nkr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Gai Moses ma denga daane maatua o Israel ga ahe ai loo gi de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Gai Tagi Maolunga ga hai gi ssau mai dahi madangi gi ilihia mai denga quail i honga tai, ga hai denga manu llele laa gi toga i luu baasi de mommee nnoho gaainga; gai de lahalaha de mommee olaadeu ne toga ai se dahi laangi e seesee ai gi tae gi de baasi laa gai e bei ai hogi de baasi ange laa, gai se lua sugilima de duuduu i honga de gelegele. ");
INSERT INTO nkr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Gai de huaadangada ne hulo i de laangi ma de boo laa, aama de laangi i ono dua ga hagabudu denga quail; gai teai donu se dangada ne sogoisi mai ange i de madaangahulu homer. Gai gilaadeu ne gaamai alaadeu quail ga doha saele e hagammasa i de mommee nnoho gaainga alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Aagai de masavaa alaadeu e gai ai ma de maamaa giidagi laa, gai Tagi Maolunga gu bole mmao i hiidinga o dangada, gai ia ga hai gi mmagi dangada i dahi magi hagamaakau. ");
INSERT INTO nkr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Deelaa ai, de mommee laa gu hagaingoo ange go Kibroth Hattaavah, go hiidinga go kilaa ne danu ai de gau aagai. ");
INSERT INTO nkr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Gai dangada ne daga mai i Kibroth Hattaavah ga hulo gu tae gi Hazeroth ga nnoho ai. ");
INSERT INTO nkr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Gai Miriam ma Aaron ne hagadaumee ange gi Moses, i hiidinga o de hine Ethiopia oona ne hai bodu ange laa aagena, go hiidinga Moses ne hai bodu ange gi dahi hahine Ethiopia. ");
INSERT INTO nkr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Gai gilaau ne hagataba, “Gu aha, go Moses donu huu a Tagi Maolunga e tala ange ana muna aagena? Ia tigi tala mai nei hogi ana muna gi gimaau?” Gai Tagi Maolunga gu langona alaau muna. ");
INSERT INTO nkr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Gai Moses se daane daudonu mmao, ia e daudonu ange i dangada alodahi i henua i lalo.) ");
INSERT INTO nkr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","De masavaa laa donu huu, gai Tagi Maolunga ga hai ange gi Moses ma Aaron aama Miriam, “Goodou loomai gi de hale malo hagabuni.” Gai gilaadeu ga hulo. ");
INSERT INTO nkr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Gai Tagi Maolunga ga hano iho i lo te hagausinga, ga duu i de haitoga o de hale malo, gai ia ga hagahi Aaron ma Miriam. Gai gilaau ga loomai ga hagapaa ange, ");
INSERT INTO nkr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","gai ia ga hai ange, “Gooluu nnoho mai hagalaangona agu muna: Noo e dahi pelaabisi i oodou magavaa, gai au, Tagi Maolunga, e hagaago ange naa agu midi hagaago ange gi de ia, ma de basa ange gi de ia i denga midi. ");
INSERT INTO nkr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Gai e dee deenei ogu dagodo ange gi dogu dangada hegau go Moses; ia e hai hegau i de mee abodonu i dogu hale alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Gai gimaau e hagadau madaangudu; au e dee basa ange gi de ia i muna hagasengasenga; gai ia e gidee hogi hoolinga o Tagi Maolunga. Gai gooluu e dee maatagu naa donu i de hagadaumee ange gi dogu dangada hai hegau go Moses?” ");
INSERT INTO nkr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Gai Tagi Maolunga gu kona mmao de lili i gilaau, gai ia ga hano gee mai i olaau daha. ");
INSERT INTO nkr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Gai de masavaa huu o de hagausinga laa ne ngalue gee mai ai i honga de hale malo, gai Miriam gu iai de magi lebelaa, dono angaanga gu tea bei denga snow. Gai de masavaa huu a Aaron ne gidee ai bolo Miriam gu iai de lebelaa, ");
INSERT INTO nkr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","gai ia ga hai ange gi Moses, “Dogu dangada aamua, koe gi dee hagaduasala ina gimaau, i hiidinga gimaau gu haisala, i demaau llodo ssenga. ");
INSERT INTO nkr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Koe gi dee haia Miriam gi bei tama ssege e haanau mai laa, gai dono angaanga gu bala.” ");
INSERT INTO nkr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Gai Moses ga dalodalo ange gi Tagi Maolunga, ga hai ange, “De Maadua, au e dangidangi adu, hagaieiangi ina ia.” ");
INSERT INTO nkr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Gai Tagi Maolunga ne hai ange gi Moses, “Noo tamana o Miriam gu saavale ange gi luoono mada, gai e aha, ia e dee hagangadi mee ina naa i e hidu laangi? Gaavee ia gi noho i tua de mommee nnoho gaainga i e hidu laangi; gai dua naa huu laangi laa gai ia gu maua i de ahe mai.”  ");
INSERT INTO nkr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Gai Miriam ne hano ga noho i tua de mommee nnoho gaainga i e hidu laangi; gai de huaadangada tee ngaalue donu ga dae ai gi dono ahe mai. ");
INSERT INTO nkr_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Dua mee laa, gai de huaadangada ne ngaalue gee i Hazeroth, ga hulo ga nnoho gaainga i de vao o Paran. ");
INSERT INTO nkr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Haia gi hulo hanu daane gi mulidagi ina de henua go Canaan, go de henua aagu e gaavange gi de gau Israel. Gai koe hilia dagidahi dagi mai i denga aamuli o oodou dubuna madagidagi.” ");
INSERT INTO nkr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Gai Moses ne hai gilaadeu gi hulo mai i de vao o Paran, bei de hai a Tagi Maolunga gu tala ange ai. Gai denga daane laa alodahi ni dagi niio de gau Israel. ");
INSERT INTO nkr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Gai aanei ingoo o denga daane ne hulo: mai i de aamuli o Reuben, go Shammua tama daane a Zaccur; ");
INSERT INTO nkr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","mai i de aamuli o Simeon, go Shaphat tama daane a Hori; ");
INSERT INTO nkr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","mai i de aamuli o Judah, go Caleb tama daane a Jephunneh; ");
INSERT INTO nkr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","mai i de aamuli o Issachar, go Igal tama daane a Joseph; ");
INSERT INTO nkr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","mai i de aamuli o Ephraim, go Hosea tama daane a Nun; ");
INSERT INTO nkr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","mai i de aamuli o Benjamin, go Palti tama daane a Raphu; ");
INSERT INTO nkr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","mai i de aamuli o Zebulun, go Gaddiel tama daane a Sodi; ");
INSERT INTO nkr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","mai i de aamuli o Manasseh, (e bei go de aamuli o Joseph), go Gaddi tama daane a Susi; ");
INSERT INTO nkr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","mai i de aamuli o Dan, go Ammiel tama daane a Gemalli; ");
INSERT INTO nkr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","mai i de aamuli o Asher, go Sethur tama daane a Michael; ");
INSERT INTO nkr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","mai i de aamuli o Naphtali, go Nahbi tama daane a Vophsi; ");
INSERT INTO nkr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","gai mai i de aamuli o Gad, go Geuel tama daane a Maki. ");
INSERT INTO nkr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aanei ingoo o denga daane a Moses ne hai gi hulo, gi mulidagi ina de henua laa. (Gai Moses ne sui de ingoo o Hosea tama daane a Nun ga hai go Joshua.) ");
INSERT INTO nkr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","De masavaa a Moses ne hai ai gilaadeu gi hulo, gi mulidagi ina de henua go Canaan, gai ia ne hai ange gi gilaadeu, “Goodou hulo laa Negev ga hulo ai gi de mommee iai mounga. ");
INSERT INTO nkr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Gai goodou ga tilo dagodo o de henua, ma de tilo be dangada e nnoho ai e mmahi be e baageaa, e sogoisi aabe e soa. ");
INSERT INTO nkr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Gai diiloo be aahee dagodo o delaadeu henua e nnoho ai laa, e danuaa be e baubau; gai aahee dagodo o olaadeu aduhale, e buibui aabe e deai; ");
INSERT INTO nkr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","gai aahee dagodo o de gelegele, e danuaa be deai. Gai diiloo be e lagolago manu e ssomo ai be deai. Gai goodou hagammahi gaamai hanu huamanu i de henua madali goodou.” (Gai de masavaa laa go de masavaa e daamada ai de lleu denga grape.) ");
INSERT INTO nkr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Gai gilaadeu ne hulo ga mulidagi de henua laa, mai i de vao o Zin ga dae ai gi Rehob, i de baasi ange gi Lebo Hamath. ");
INSERT INTO nkr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Gilaadeu ne loage laa Negev ga hulo ai gi Hebron; go de mommee o Ahiman, ma Sheshai, aama Talmai e nnoho, gilaadeu ni hagadiilinga niio Anak. (Hebron ne hagaduu i e hidu ngadau i mua de hagaduu o Zoan i Egypt.) ");
INSERT INTO nkr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Gai gilaadeu ne hulo ga tae gi de geelonga o Eshcol, ga tuu iho dahi laa iai de gau looloa grape, ga nnoa ange gi dahi laagau, gai e dogolua daane ga saabai ga hulo ai gilaadeu. Gai gilaadeu ne kave hogi hanu hua pomegranate aama hanu hua fig. ");
INSERT INTO nkr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Gai de mommee laa ne hagaingoo ange go de geelonga o Eshcol, i hiidinga o de gau looloa grape a denga daane o Israel ne tuu iho laa i kilaa. ");
INSERT INTO nkr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Gai dua huu de madahaa laangi, gai denga daane laa gu aahe mai i de mulidagi de henua laa. ");
INSERT INTO nkr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Gai gilaadeu ne aahe mai gi daho Moses ma Aaron aama de hagabuulingaa dangada o Israel i Kadesh, i de vao o Paran. Gai gilaadeu ga tala ange mee alodahi gi de hagabuulingaa dangada o Israel, ma de hagaago ange gi gilaadeu denga huamanu mai i de henua laa. ");
INSERT INTO nkr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Gai gilaadeu ne tala ange gi Moses, ga hai ange, “Gimaadeu ne hulo gi de henua aau ne hai gimaadeu gi hulo aagena; gai de henua laa iai vai uu ma hooni lagolago, gai aanei hanu huamanu o de henua laa. ");
INSERT INTO nkr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Gai dangada e nnoho i de henua laa ni dangada mmahi, olaadeu aduhale e buibui gai e nnui. Gai gimaadeu ne gidee hogi hagadiilinga o Anak i kilaa. ");
INSERT INTO nkr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Gai de gau Amalek e nnoho i Negev; de gau Heth, ma de gau Jebus, aama de gau Amor e nnoho i de mommee iai mounga; gai de gau Canaan e nnoho i tagudai, ma laa gaogao o Jordan.” ");
INSERT INTO nkr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Gai Caleb ga hai dangada e tuu i mada i mua o Moses gi dee hagalongaa, gai ia ga hai ange, “Gidaadeu ga hulo donu iainei e hebagi ange gi de henua laa; i hiidinga gidaadeu e maua donu i de hagadee kii gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Gai denga daane ne hulo laa madali ia ga hai ange, “Gidaadeu e dee maua donu i de hulo e hebagi ange gi de gau laa, go hiidinga gilaadeu e mmahi ange donu i gidaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Gai gilaadeu ne hagadele denga longo baubau, i magavaa o de gau Israel, i dagodo o de henua laa, ga hai ange, “De henua amaadeu ne hulo ga mulidagi e daa gi maakau dangada e nnoho ai; gai dangada alodahi amaadeu ne gidee i kilaa ni doa. ");
INSERT INTO nkr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Gimaadeu ne gidee hogi dangada e hagaingoo ange laa go denga Nephilim (denga Nephilim go hanu aamuli o Anak); gai gimaadeu e bei donu dagodo o denga itebuubuu i olaadeu daha.”  ");
INSERT INTO nkr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","De hagabuulingaa dangada laa ne oo ga tangi; gai gilaadeu ne tangi i de boo laa alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Gai de gau Israel alodahi ga nnanu i Moses ma Aaron; gai de hagabuulingaa dangada laa ga hai ange gi gilaau, “Mee naa gimaadeu ne maakau donu huu i de henua go Egypt, aabe ne maakau donu huu i de vao nei! ");
INSERT INTO nkr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Gai gu aha Tagi Maolunga gu gaamai ai nei gimaadeu gi de henua nei e daa ai gi maakau? Omaadeu bodu ma amaadeu dama e gaavee naa e omaadeu hagadaumee; gai e dee danuaa ange demaadeu aahe gi Egypt?” ");
INSERT INTO nkr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Gai dangada ga hagataba i olaadeu magavaa, “Gidaadeu ga hili dahi dangada gi dagina gidaadeu e aahe ai gi Egypt.” ");
INSERT INTO nkr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Gai Moses ma Aaron ga ino ga hagapaa olaau mada gi honga de gelegele i madamada o de hagabuulingaa dangada o Israel. ");
INSERT INTO nkr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Gai Joshua tama daane a Nun ma Caleb tama daane a Jephunneh, luu daane ne hulo laa madali denga daane ga mulidagi ina de henua, ga saesae olaau malo, ");
INSERT INTO nkr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ga hai ange gi de hagabuulingaa dangada o Israel, “De henua amaadeu ne hulo ga mulidagi se henua danuaa mmao. ");
INSERT INTO nkr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Noo Tagi Maolunga e malangilangi i gidaadeu, gai ia e kave naa donu gidaadeu gi tae gi de henua laa ma de gaamai gi gidaadeu, de henua iai laa vai uu ma hooni lagolago. ");
INSERT INTO nkr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Gai goodou aude hai baasi ange gi Tagi Maolunga, be gi maatagu i dangada o de henua laa, go hiidinga e hai ngaohie donu taadeu hagadee kii gilaadeu. Gilaadeu gu deai selaadeu buibui, aagai Tagi Maolunga e noho madali gidaadeu; goodou aude maatagu i gilaadeu.”  ");
INSERT INTO nkr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Gai de hagabuulingaa dangada laa alodahi gu llodo e magaa gilaau i denga hadu. De masavaa laa donu huu gai de gau Israel alodahi gu gidee de maalama o de mahamaha o Tagi Maolunga gu haoli de hale malo hagabuni. ");
INSERT INTO nkr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Gai Tagi Maolunga ga hai ange gi Moses, “Dee hee maa taulooloa de hagangadi mee a de gau nei au? Gai dee hee maa taulooloa delaadeu dee hagadonu agu muna, gai gilaadeu gu gidee donu denga sauaa alodahi aagu gu hai i olaadeu magavaa? ");
INSERT INTO nkr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Au e daa naa gilaadeu gi maakau i de mee hagamaakau ma de tili gilaadeu, gai au ga hai goe ma doo huaabodu gi se huaahenua soa ma de mmahi ange i gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Aagai Moses ga hai ange gi Tagi Maolunga, “De gau Egypt e langona naa au mee e hai, i hiidinga koe ne hagassao mai de huaadangada nei mai i olaadeu daha i doo sauaa, ");
INSERT INTO nkr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","gai gilaadeu e tala ange naa gi dangada e nnoho i de henua nei. Gilaadeu gu langona bolo koe, Tagi Maolunga, e noho madali de huaadangada nei; gai koe, Tagi Maolunga e hakide mai gi gimaadeu, gai dau hagausinga e duu i olaadeu elunga, gai koe e hano i olaadeu mada i mua, i lo te duludulu hagausinga i de laangi, gai de boo se duludulu e ula ai laa de ahi. ");
INSERT INTO nkr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Gai noo koe e daa gi maakau de huaadangada nei, gai denga huaahenua gu langona laa e gilaadeu oo longo ga hagataba, ");
INSERT INTO nkr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Tagi Maolunga tee maua i de kave de huaadangada nei gi tae gi de henua aana gu hagatoo donu ange gi gilaadeu, deelaa ai, ia gu daa gilaadeu ma gu maakau i de vao.’ ");
INSERT INTO nkr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Dogu Ia Aamua, iainei gai au e dangidangi adu, hagaagona mai de laumalie o doo sauaa, bei dau hai gu hagatoo donu ai, ma gu hagadaba, ");
INSERT INTO nkr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Tagi Maolunga e dee moolau de lili ma de abodonu, gai e laumalie dono abodonu, ia e degi ange gi baubau ma haisala, aagai ia e dee degi ange donu gi hegau baubau, gai e hagaduasala denga dama i hiidinga haisala olaadeu maadua, ga dae ai loo gi tolu ma de haa atangada.’  ");
INSERT INTO nkr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Au e dangidangi adu, degi ange gi baubau o de huaadangada nei, bei dagodo de laumalie doo abodonu, bei dau hai gu degi ange ai naa gi de huaadangada nei, mai loo i Egypt ga dae mai ai gi iainei.” ");
INSERT INTO nkr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Gai Tagi Maolunga ga hai ange, “Au gu degi ange, bei dau hai gu dangidangi mai ai naa. ");
INSERT INTO nkr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Aagai au e hagatoo donu i dogu mouli, ma dogu mahamaha e haoa laa ma e honu henua i lalo alodahi, ");
INSERT INTO nkr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","bolo e deai naa donu se dangada i magavaa o dangada ne gidee laa dogu mahamaha, ma agu hegau sauaa ne hai i Egypt ma de vao, aagai gilaadeu ne hagatale au i denga hanonga e madaangahulu nei, aama tee daudali i agu muna — ");
INSERT INTO nkr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","e gidee de henua aagu gu hagatoo donu ange gi olaadeu dubuna madagidagi. E deai hogi se gilaadeu e hagangadi mee ina au e gidee de henua laa. ");
INSERT INTO nkr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Aagai au e kave naa dogu dangada hai hegau go Caleb gi dae gi de henua oona ne hano laa aagena, gai ono hagadiilinga alodahi e henua ai naa i de henua laa, i hiidinga ia e dagodo gee ono lodo, gai ia ne daudali mai i de au i ono lodo alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Gai go hiidinga de gau Amalek ma de gau Canaan e nnoho i de mommee soe i magavaa mounga, deelaa ai, daiao gai goodou huuhuli aahe gi de vao i de haiava e hano laa gi Tai Mmea.” ");
INSERT INTO nkr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Dee hee maa taulooloa de nnanu o de hagabuulingaa dangada baubau nei i de au? Au gu langona de nnanu o de gau Israel ma delaadeu hai baasi mai gi de au. ");
INSERT INTO nkr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Gai gooluu hai ange gi gilaadeu, ‘E hagadaba Tagi Maolunga, au e hagatoo donu i dogu mouli, bolo au e hai adu naa gi goodou gi bei muna oodou gu langona naa: ");
INSERT INTO nkr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","goodou e maakau naa gai oodou angaanga e daakodo i de vao — go goodou alodahi gu dagimadalua oodou ngadau ga hanage ai, gu dau ma gu sisi oodou ingoo, gai gu hai baasi mai gi de au i doodou nnanu. ");
INSERT INTO nkr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","E deai naa donu se goodou e dae gi de henua aagu gu hagatoo donu e gaavadu e nnoho ai goodou, go Caleb donu huu tama daane a Jephunneh ma Joshua tama daane a Nun e tae. ");
INSERT INTO nkr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Aagai denga dama oodou e hagataba naa bolo e gaavee naa e oodou hagadaumee, go gilaadeu naa aagu e kave gi tae ma de manuuia i de henua oodou e kino ai naa. ");
INSERT INTO nkr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Aagai aanei oodou dagodo: goodou e maakau naa i de vao nei. ");
INSERT INTO nkr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Oodou dama e hai naa ga ni dangada hagaloosi ssiibi i de vao i e madahaa ngadau; gilaadeu e hagaduasala naa i hiidinga doodou dee hai hegau i de muna abodonu, ga dae ai gi de odi goodou i de maakau i de vao. ");
INSERT INTO nkr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Gai taelodo o laangi oodou ne hulo ai ga mulidagi de henua se madahaa, deelaa naa hogi taelodo o denga ngadau oodou e hagaduasala ai, i hiidinga oodou baubau; gi tonu iho ai goodou gi oodou dagodo i dogu hai baasi adu gi goodou.’ ");
INSERT INTO nkr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Go au, Tagi Maolunga, ne daalaa muna nei; gai au e hai ange naa donu mee nei alodahi gi de hagabuulingaa dangada baubau gu hagabuni nei ma e hagadaumee mai gi de au: gilaadeu e odi naa donu i de maakau i de vao nei.” ");
INSERT INTO nkr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Gai go denga daane a Moses ne hai laa gi hulo gi mulidagi ina de henua, gai ne aahe mai ga hai de hagabuulingaa dangada alodahi ga nnanu i Tagi Maolunga, i delaadeu gaamai hanu longo baubau o de henua, ");
INSERT INTO nkr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","— denga daane ne gaamai laa hanu longo baubau o de henua laa — gilaadeu ne maakau i dahi mee hagamaakau i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aagai Joshua tama daane a Nun ma Caleb tama daane a Jephunneh donu huu tee maakau i denga daane ne hulo laa ga mulidagi ina de henua. ");
INSERT INTO nkr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Gai Moses ne tala ange muna laa gi de gau Israel alodahi, gai dangada alodahi gu kona mmao de tangi. ");
INSERT INTO nkr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Gai gilaadeu ne oho age i taiao, ga loage gi denga mommee maolunga i de henua, ga hai ange, “Aanei gimaadeu gu loomai nei e hulo e kave de mommee a Tagi Maolunga gu hagatoo donu mai. Gai gimaadeu e iloo bolo gimaadeu gu haisala donu.” ");
INSERT INTO nkr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Gai Moses ga hai ange, “Gu aha goodou gu hai ai naa gi dee bei muna a Tagi Maolunga gu tala adu gi goodou? Oodou hagatau e dee ssula naa donu. ");
INSERT INTO nkr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Goodou aude hulo oodou hagadaumee kana hagadee kii goodou, go hiidinga Tagi Maolunga e dee hano donu madali goodou. ");
INSERT INTO nkr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Gai de gau Amalek ma de gau Canaan i kilaa, gai goodou e daia naa ga maakau i de gadilaasa. Tagi Maolunga e dee hano naa donu madali goodou, i hiidinga goodou tee daudali i ana muna.” ");
INSERT INTO nkr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Aagai dangada ne hai donu huu olaadeu lodo ga loage ai ga hulo gi de mommee maolunga i de henua, gai de ngavesi o de hagatoo donu hagaheloongoi a Tagi Maolunga, ma Moses ne nnoho donu huu i de mommee nnoho gaainga. ");
INSERT INTO nkr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Gai de gau Amalek ma de gau Canaan e nnoho laa i de henua iai mounga ne loiho ga hebagi ange gi de gau Israel, ga hagadee kii gilaadeu ma de doolohi gilaadeu ga tae ai gi Hormah. ");
INSERT INTO nkr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Gai Tagi Maolunga ne hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Basa ange gi de gau Israel, hai ange gi gilaadeu: ‘De masavaa naa huu oodou e tae ai ga nnoho i de henua aagu e gaavange gi goodou, ");
INSERT INTO nkr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","gai goodou ga hai dahi sigidaumaha dudu ange gi Tagi Maolunga, i oodou kaau be go oodou ssiibi, be se sigidaumaha niiodou gu hagatoo donu ai, be se sigidaumaha e hai i de malangilangi o tangada, aabe se sigidaumaha e hai i de masavaa o denga daonga gu hagailonga, go ssigidaumaha nnamu kala ange gi Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","gai tangada e gaamai laa dana sigidaumaha gi Tagi Maolunga, gi gaamai hogi dahi diba i diba e madaangahulu o dahi ephah pelaoaa lligi, gu hilo laa ma dahi diba i diba e haa o dahi hin lolo. ");
INSERT INTO nkr_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Gai ia gi gaamai madali dahi ssiibi o sigidaumaha dudu be go dahi sigidaumaha ange laa, dahi diba i diba e haa o dahi hin uvaini, e hai ai ssigidaumaha o mee unu. ");
INSERT INTO nkr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Gai noo se ssiibi daane e hai ai ssigidaumaha, gai tangada gi gaamai e lua diba i diba e madaangahulu o dahi ephah pelaoaa lligi madali e dahi diba i diba e dolu o dahi hin lolo, ");
INSERT INTO nkr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ma dahi diba i diba e dolu o dahi hin uvaini, e hai ai ssigidaumaha o mee unu. De mee nei se sigidaumaha nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Gai de masavaa naa huu aau e daa ai dahi kaau daane e hai ai ssigidaumaha dudu, aabe go dahi sigidaumaha ange laa, e hagasula ai dau hagatoo donu, aabe go sigidaumaha hagadanuaa magavaa ange gi Tagi Maolunga, ");
INSERT INTO nkr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","gai koe gaamai hogi madali de kaau laa e dolu diba i diba e madaangahulu o dahi ephah pelaoaa lligi gu hilo ma dahi bido hin lolo olive, ");
INSERT INTO nkr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","gai koe e gaamai hogi dahi bido hin uvaini e hai ai ssigidaumaha o mee unu, de mee nei se ssigidaumaha nnamu kala e hai i de ahi ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Aanei mee e gaamai madali dahi kaau be go dahi ssiibi daane, be ssiibi gauligi aabe go dahi guudi gauligi. ");
INSERT INTO nkr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Gai dee hee naa huu taelodo o manu oodou e hai ai ssigidaumaha, gai deelaa hogi taelodo o mee ange laa oodou e gaamai madali. ");
INSERT INTO nkr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Gai de gau de henua alodahi gi haia gi bei de hai e hai ai mee nei, i de masavaa alaadeu e hai ai alaadeu sigidaumaha e hai i de ahi, go ssigidaumaha nnamu kala ange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Gai noo dahi dangada henua gee se goodo humai ga noho madali goodou, aabe gu noho i dahi masavaa daulooloa, gai ia e lodo e hai dahi sigidaumaha e hai i de ahi, se ssigidaumaha nnamu kala ange gi Tagi Maolunga, gai ia gi haia gi bei doodou hai e hai ai laa. ");
INSERT INTO nkr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Gai de gau de henua ma de gau henua gee e nnoho madali goodou gi daudali i de hainga daudahi gu hagasauaa adu laa gi goodou. De hainga nei gu hagasauaa adu gi goodou ma oodou atangada alodahi ga hano ai; goodou ma de gau henua gee se dagodo daudahi donu huu i mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Gai e dahi donu huu hainga ma hagamodu adu gi goodou aama de gau henua gee e nnoho madali goodou.’ ”  ");
INSERT INTO nkr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Koe daalaa ange gi de gau Israel hai ange, ‘De masavaa naa huu oodou e tae ai gi de henua aagu ga kave nei goodou aagena, ");
INSERT INTO nkr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","gai de masavaa naa huu oodou e gai ai huamanu o de henua laa, gai goodou vaaea gee hogi dahi sigidaumaha e gaavange gi Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Gai goodou haia hogi dahi pelaoaa i pelaoaa lligi o denga grain e hai laa i taamada, bei doodou hai e gaamai ai laa dahi ssigidaumaha mai i de mommee hili huamanu. ");
INSERT INTO nkr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Goodou e gaavange hogi dahi sigidaumaha gi Tagi Maolunga mai i denga pelaoaa lligi o denga grain e mmili i taamada, i oodou atangada ga hano ai. ");
INSERT INTO nkr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Gai noo goodou e dee se hagabau ga hagahaisala ai muna a Tagi Maolunga gu tala ange gi Moses — ");
INSERT INTO nkr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","go hanu muna a Tagi Maolunga gu tala adu gi goodou i daho Moses, mai i de laangi a Tagi Maolunga ne tala adu ai, gai ange hogi gi oodou atangada ga hano ai — ");
INSERT INTO nkr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","gai noo koe e dee se hagabau ga hagahaisala ai mee nei, gai de hagabuulingaa dangada o Israel tee iloo hogi, gai de huaadangada alodahi gi daia dahi kaau gauligi e hai ai ssigidaumaha dudu, go ssigidaumaha nnamu kala ange gi Tagi Maolunga, madali ssigidaumaha o grain ma ssigidaumaha o mee unu, bei de hai gu tala ai laa i de hainga, aama dahi guudi daane e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Gai tangada haimeedabu gi haia ssigidaumaha e tala ai haisala o dangada alodahi o Israel, gai olaadeu haisala gu maatala; go hiidinga gilaadeu e dee se hagabau, gai dangada gu gaamai delaadeu sigidaumaha, e hai i de ahi ange gi Tagi Maolunga, ma ssigidaumaha o haisala gi mada luu mada o Tagi Maolunga. ");
INSERT INTO nkr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Gai haisala o dangada alodahi o Israel ma de gau henua gee e nnoho i olaadeu daha gu maatala, go hiidinga dangada alodahi ne haisala gai e dee se hagabau. ");
INSERT INTO nkr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Noo dahi dangada gu haisala gai e dee se hagabau, gai ia gi gaamai dahi guudi hahine gu dahi laa ono ngadau e hai ai ssigidaumaha o haisala. ");
INSERT INTO nkr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Gai tangada haimeedabu gi haia ssigidaumaha e tala ai haisala o tangada gu haisala laa, gai e dee se hagabau, i mada luu mada o Tagi Maolunga, gai ono haisala gu maatala. ");
INSERT INTO nkr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Gai e dahi donu huu hainga ange gi tangada gu haisala laa, gai e dee se hagabau; e dee hilihili be se dangada Israel donu aabe se dangada henua gee. ");
INSERT INTO nkr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Aagai noo tangada se hagabau donu ga hagangadi mee ai Tagi Maolunga, e dee hilihili be se dangada de henua donu, aabe se dangada henua gee, gai tangada laa e vvae gee donu mai i daho ono dangada. ");
INSERT INTO nkr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ia gu hagangadi mee muna a Tagi Maolunga, ma de oha dana hainga, deelaa ai, tangada laa e aau gee mai i daho dangada; gai ono haisala e dau ange donu gi de ia.’ ” ");
INSERT INTO nkr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","De masavaa o de gau Israel e nnoho ai i de vao, gai gilaadeu ne gidee dahi daane e hano ma e hagabudu lahhie i de laangi o Sabbath. ");
INSERT INTO nkr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Gai dangada ne gidee laa dono hano ga hagabudu lahhie, ne gaamai ia gi daho Moses ma Aaron, aama daho de hagabuulingaa dangada alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Gai gilaadeu ne gaavange ia gi hanu gi dagidiiloo, i hiidinga tigi iloo danuaa be ni aha e hai ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Gai Tagi Maolunga ga hai ange gi Moses, “Taane naa e daa donu gi magau. De hagabuulingaa dangada alodahi gi gaavee ia, gi tua de mommee nnoho gaainga ga maga ai ia gi magau.” ");
INSERT INTO nkr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Gai de hagabuulingaa dangada alodahi ne kave taane laa, gi tua de mommee nnoho gaainga, ga maga ai ia gu magau, bei de hai a Tagi Maolunga gu tala ange ai gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Hai ange gi de gau Israel gilaadeu gi haia hanu huga malo hagalaagii i dege o malo o dangada i denga atangada alodahi, gai gi haia dagidahi uga buluu ga noonooa ange gi huga malo laa. ");
INSERT INTO nkr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Gai denga huga malo nei ni mee e hai gi gidee e goodou, gai gi manadua ai e goodou muna alodahi a Tagi Maolunga, gai goodou ga daudali ai i ana muna, goodou gu dee hai donu huu oodou lodo, bei doodou hai e hai ai naa iainei. ");
INSERT INTO nkr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Gai gi manadua ai e goodou ma de daudali i agu muna alodahi, gai goodou ga hagadabu ange ai goodou ange gi doodou Maadua. ");
INSERT INTO nkr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Go au donu go Iahweh doodou Maadua, ne hagassao ina mai laa goodou i de henua go Egypt, ga hai ai doodou Maadua. Go au donu go Iahweh doodou Maadua.” ");
INSERT INTO nkr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Gai Korah tama daane a Izhar, tama daane a Kohath, tama daane a Levi, aama Dathan, ma Abiram luu dama daane a Eliab, aama On tama daane a Peleth, go hanu hagadiilinga o Reuben, ");
INSERT INTO nkr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ne hagabuni e 250 daane dau i magavaa o de gau Israel, gai ni dagi niio dangada, gai ni daane hagadubu i magavaa o dangada, gai gilaadeu ga hai baasi ange gi Moses. ");
INSERT INTO nkr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Gilaadeu ne loomai ga hagadaumee ange gi Moses ma Aaron, ga hai ange gi gilaau, “Gu gona odi ooluu mee e hai! Dangada alodahi o Israel e dabu, gai Tagi Maolunga e noho i olaadeu daha. Gai gu aha gooluu gu hai ai naa gooluu gi maolunga ange i de hagabuulingaa dangada o Tagi Maolunga?” ");
INSERT INTO nkr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","De masavaa a Moses ne langona ai muna nei, gai ia ga ino ga hagabaa luoono mada gi honga de gelegele; ");
INSERT INTO nkr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ga hai ange gi Korah ma denga daane madali ia, “Boo taiao gai Tagi Maolunga e hagaago mai naa be goai ono dangada gai goai e dabu, gai goai e maua i de hano e hagabaa ange gi de ia. Gai tangada naa huu aana e hili, gai ia gi humai gi hagabaa ange gi de ia. ");
INSERT INTO nkr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Gai deenei doodou mee e hai: Korah ma dono hagabuulinga alodahi, gi gaavee hanu gumedi o denga maga ahi ma mee maanongi, ");
INSERT INTO nkr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","gai daiao naa huu gai goodou ga hhao ange hanu maga ahi ma hanu mee maanongi gi lodo gumedi laa, i mada luu mada o Tagi Maolunga. Gai tangada naa huu a Tagi Maolunga e hili, gai go ia e dabu. Goodou denga daane de aamuli o Levi, gu gona odi donu oodou mee e hai!” ");
INSERT INTO nkr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Gai Moses ga hai ange gi Korah, “Denga daane de aamuli o Levi, goodou nnoho mai hagalaangona agu muna! ");
INSERT INTO nkr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Goodou e hagangadi mee naa donu de hili a de Maadua o Israel goodou, ga vvae gee goodou mai i de hagabuulingaa dangada o Israel, ga hai gi maua e goodou i de loomai e hagapaa ange gi de ia, gi haia ai hegau i lo te tabernacle o Tagi Maolunga, aama de tuu i mada o de hagabuulingaa dangada o Israel, gi hai hegau ange ai gi gilaadeu? ");
INSERT INTO nkr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ia gu gaamai goodou ma dangada alodahi i de aamuli o Levi gi paa ange gi de ia, aagai goodou gu llodo naa hogi e kave tuulanga o tangada haimeedabu? ");
INSERT INTO nkr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Deenei ai, go Tagi Maolunga donu oodou e hai baasi ange naa aagena. Gai goai go Aaron, gai goodou ga hai baasi ange ai naa gi de ia?” ");
INSERT INTO nkr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Gai Moses ga aalu gi loomai Dathan ma Abiram luu dama daane a Eliab. Gai gilaau ne hai ange, “Gimaau e dee loadu! ");
INSERT INTO nkr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Koe e maanadu bolo se mee hai ngaohie dau hagassao mai gimaadeu i de henua iai vai uu ma hooni lagolago, ga gaamai gimaadeu e daa gi maakau i de vao nei? Gai iainei koe gu lodo hogi go koe demaadeu dagi? ");
INSERT INTO nkr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Gai koe tee gaamai hogi gimaadeu gi dahi henua iai vai uu ma hooni lagolago, aabe e bolo mai hanu gelegele ma veelengaa grape moomaadeu. Gai koe ga llao mai naa hogi de ganomada o denga daane nei ⌊ga hai gi ni dangada hai hegau niiou⌋? E deai, gimaau e dee loadu donu!” ");
INSERT INTO nkr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Gai Moses gu kona mmao de lili, gai ia ga hai ange gi Tagi Maolunga, “Koe gi dee hagadubu ina donu delaadeu sigidaumaha. Tigi ai donu se donkey daudahi aagu ne kave mai i olaadeu daha, aabe gu hai ange dahi baubau gi gilaadeu.” ");
INSERT INTO nkr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Gai Moses ga hai ange gi Korah, “Goodou ma de hagabuulingaa daane madali goe loomai gi mada luu mada o Tagi Maolunga daiao, madali Aaron. ");
INSERT INTO nkr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Gai dahi ma dahi gi gaavee dana gumedi e dudu ai laa denga mee maanongi, gai ia gi dugua ange hanu mee maanongi gi ono lodo, gai goodou denga daane e 250 ga gaamai oodou mee dudu mee maanongi gi mada luu mada o Tagi Maolunga; goodou alodahi ma Aaron gi gaamai oodou mee dudu mee maanongi.” ");
INSERT INTO nkr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Deelaa ai, denga daane laa alodahi ne gaamai alaadeu gumedi e dudu ai laa denga mee maanongi, ga hhao ange maga ahi ma mee maanongi aagena, gai gilaadeu ga loomai ga tuu i de haitoga o de hale malo hagabuni madali Moses ma Aaron. ");
INSERT INTO nkr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Gai Korah ne hai gi loomai de hagabuulingaa dangada alodahi gi de haitoga o de hale malo hagabuni, gi hagadaumee ange ai gi luu daane laa. Gai de mahamaha o Tagi Maolunga gu hagasula ange gi de hagabuulingaa dangada laa. ");
INSERT INTO nkr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Gai Tagi Maolunga ga hai ange gi Moses ma Aaron, ");
INSERT INTO nkr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Vaaea gee gooluu mai i de hagabuulingaa dangada naa, gai au ga daa gilaadeu gi maakau iainei donu.” ");
INSERT INTO nkr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Gai gilaau ga ino ga hagapaa olaau mada gi honga de gelegele, ga hai ange, “De Maadua, go de Maadua o hagasaalunga o dangada alodahi, koe ga daohi naa donu huu doo lili i de hagabuulingaa dangada nei, i hiidinga haisala o dahi dangada sogosogo?” ");
INSERT INTO nkr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Hai ange gi de hagabuulingaa dangada alodahi gilaadeu gi ngaalue gee, i de mommee iai hale malo o Korah, ma Dathan aama Abiram.” ");
INSERT INTO nkr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Gai Moses ne hidi age ga hano gi daho Dathan ma Abiram; gai denga daane maatua o de gau Israel ne daudali ange i de ia. ");
INSERT INTO nkr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Gai ia ga hai ange gi de hagabuulingaa dangada, “Goodou hagamoolau ngaalue gee mai, i de mommee iai hale malo o denga daane baubau nei! Goodou e dee poo ange gi hanu olaadeu goloa, gi dee maakau ai goodou, i hiidinga olaadeu haisala.” ");
INSERT INTO nkr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Gai dangada ga ngaalue gee mai i denga hale malo o Korah, ma Dathan aama Abiram. Gai Dathan ma Abiram gu loomai ga tuu i mada haitoga olaau hale malo, madali olaau bodu ma alaau dama, aama alaau gauligi vaaligiligi. ");
INSERT INTO nkr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Gai Moses ga hai ange, “Deenei doodou hai e iloo ai bolo go Tagi Maolunga ne haia au gi humai gi haia hegau nei alodahi, au tee humai donu huu i de au. ");
INSERT INTO nkr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Noo denga daane nei e maakau bei de hai o dangada e maakau ai laa i de laa tubua, gai e dee go Tagi Maolunga ne haia au gi humai. ");
INSERT INTO nkr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Aagai noo Tagi Maolunga e hai dahi mee hagalele mouli hoou, gai de henua e mahanga lua ga holo gilaadeu, madali olaadeu goloa alodahi, ma de tili ange gilaadeu gi de mommee o de gau maakau, i de masavaa olaadeu goi mouli ai, gai goodou gu iloo bolo denga daane nei gu hagangadi mee donu Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Gai de masavaa aana ne tala ai ga lava ana muna nei, gai de gelegele i olaadeu lalo gu mahanga lua; ");
INSERT INTO nkr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","gai de henua gu mahuge ga holo denga daane laa, madali olaadeu huaabodu ma dangada alodahi ne daudali ange i Korah, aama olaadeu goloa alodahi. ");
INSERT INTO nkr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Gai gilaadeu ma olaadeu goloa alodahi gu tili iho gi de mommee o de gau maakau; gai de gelegele gu ahe ange ga buni, gai gilaadeu alodahi gu maakau, ga dee nnoho i magavaa o hagabuulingaa dangada. ");
INSERT INTO nkr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Gai de gau Israel alodahi i olaadeu gaogao ga saavini ga hulo gee, i de masavaa alaadeu ne langona ai delaadeu oo, gilaadeu ne hagataba, “De henua kana holo hogi gidaadeu!” ");
INSERT INTO nkr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Gai de ahi ne humai i daho Tagi Maolunga ga daa gu maakau de 250 daane laa, i de masavaa alaadeu e hai ai alaadeu sigidaumaha i mee maanongi. ");
INSERT INTO nkr_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Gai Tagi Maolunga ga hai ange gi Moses, ");
INSERT INTO nkr_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Hai ange gi Eleazar, tama daane a tangada haimeedabu go Aaron, ia gi aaua mai denga mee hhao maga ahi laa i lo te ahi, ga kave denga maga ahi iai gi dahi mommee mmao ga llingi ai, go hiidinga mee laa e dabu. ");
INSERT INTO nkr_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Gai mee hhao maga ahi a denga daane ne haisala laa ga hidi mai ai delaadeu maakau, dugidugia gi baabaa ga haoli ai de mommee o ssigidaumaha, mee laa gu dabu, go hiidinga gu kave gi mada luu mada o Tagi Maolunga. Gai de mee nei gi se hagailonga e hagakana ange ai de gau Israel.” ");
INSERT INTO nkr_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Gai tangada haimeedabu go Eleazar ne kave mee hhao maga ahi a denga daane laa ne hai ai alaadeu sigidaumaha, ga dugidugi gu baabaa ga haolia ai de mommee o ssigidaumaha, ");
INSERT INTO nkr_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","bei de hai a Tagi Maolunga gu tala ange ai laa gi Eleazar i daho Moses. Gai se mee e hagamanadua ange ai gi de gau Israel, bolo e deai ange donu dangada, go dahi aamuli donu huu o Aaron, e maua i de humai e dudu denga mee maanongi, i mada luu mada o Tagi Maolunga, ia kana bei hogi dagodo o Korah ma dangada ne daudali ange i de ia. ");
INSERT INTO nkr_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","De laangi i dua mee nei, gai de hagabuulingaa dangada alodahi o Israel ne nnanu i Moses ma Aaron, ga hai ange, “Gooluu gu daa ma gu maakau dangada o Tagi Maolunga.” ");
INSERT INTO nkr_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Gai de masavaa o dangada alodahi ne hagabuni ai, e hai baasi ange gi Moses ma Aaron, gai gilaadeu ga huuhuli ange gi de hale malo hagabuni. De masavaa laa donu huu, gai gu haolia i de hagausinga, gai de mahamaha o 