﻿USE sofia;
DROP TABLE IF EXISTS sofia.nkoNT_vpl;
CREATE TABLE nkoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nkoNT_vpl WRITE;
INSERT INTO nkoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo, Owíe Dawid mʋ na, Abraham mʋ na ámʋ ɩlɩ́ntɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham lɔ́kwɩɩ́ Isak. Isak lɔ́kwɩɩ́ Yakob. Yakob lɔ́kwɩɩ́ Yuda mʋa mʋ apio yinhɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda lɔ́kwɩɩ́ Peres mʋa Sera. Amʋ́ yín gyí Tamar. Peres lɔ́kwɩɩ́ Hesron. Hesron lɔ́kwɩɩ́ Ram. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram lɔ́kwɩɩ́ Aminadab. Aminadab lɔ́kwɩɩ́ Nahson. Nahson lɔ́kwɩɩ́ Salmon. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon lɔ́kwɩɩ́ Boas. Boas mʋ yin gyí Rahab. Boas lɔ́kwɩɩ́ Obed. Obed mʋ yin gyí Rut. Obed lɔ́kwɩɩ́ Yisai. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisai lɔ́kwɩɩ́ Owíe Dawid. Owíe Dawid lɔ́kwɩɩ́ Salomo. Salomo mʋ yin gyí ɔtsɩ ɔkʋá tɛkɩ ogyi Uria mʋ ka. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo lɔ́kwɩɩ́ Rehabeam. Rehabeam lɔ́kwɩɩ́ Abia. Abia lɔ́kwɩɩ́ Asa. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa lɔ́kwɩɩ́ Yehosafat. Yehosafat lɔ́kwɩɩ́ Yoram. Yoram lɔ́kwɩɩ́ Usia. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia lɔ́kwɩɩ́ Yotam. Yotam lɔ́kwɩɩ́ Ahas. Ahas lɔ́kwɩɩ́ Hiskia. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia lɔ́kwɩɩ́ Manase. Manase lɔ́kwɩɩ́ Amon. Amon lɔ́kwɩɩ́ Yosia. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia lɔ́kwɩɩ́ Yekonia mʋa mʋ apio yinhɛ́. Mʋ brɛ́sʋ́ bɛkɩtá Israelfɔ, hɩ́ɛ́ amʋ́ bɛɛ bʋyétsiá Babilon ɔmátɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Amʋ́ Babilon yɔtɔ́ á, Yekonia lɔ́kwɩɩ́ Sealtiel. Sealtiel lɔ́kwɩɩ́ Serubabel. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel lɔ́kwɩɩ́ Abihud. Abihud lɔ́kwɩɩ́ Eliakim. Eliakim lɔ́kwɩɩ́ Asor. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor lɔ́kwɩɩ́ Sadok. Sadok lɔ́kwɩɩ́ Akim. Akim lɔ́kwɩɩ́ Elihud. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud lɔ́kwɩɩ́ Eleasar. Eleasar lɔ́kwɩɩ́ Matan. Matan lɔ́kwɩɩ́ Yakob. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob lɔ́kwɩɩ́ Yosef, Yosef létsiá Maria. Maria lɔ́kwɩɩ́ Yesu. Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mʋ́ sʋ tsú Abrahamsʋ bɔtʋ Owíe Dawidsʋ bʋgyi anáin ɩlɩ́ntɔ dúana. Tsú Dawidsʋ bɔtʋ brɛ́á bɔyɔ Babilon ɔmátɔ́ ɛ́ bʋgyi anáin ɩlɩ́ntɔ dúana. Asa tsú amʋ́ Babilon yɔtɔ́ bɔtʋ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) kwɩɩ́sʋ́ ɛ́ bʋgyi anáin ɩlɩ́ntɔ dúana. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɔkpa ánfɩsʋ Yesu Kristo kwɩɩ́ lɔtsʋn nɩ. Bɔpʋ Maria há Yosef bɛɛ otsía. Támɛ asa bétsiá, abʋfia ɔtsɩ mʋ́a oyin á, bowun ánɩ́ Maria dɛ́ ɔmɛ́ Ɔŋɛ Wankɩ́hɛ́ túmitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mʋ kulu Yosef a, mʋ asʋ́n da ɔkpa, támɛ omekle ánɩ́ ɔbɔ́wa mʋ pɛ́lɩtɔ. Mʋ́ sʋ ɔlɔbwɛ agywɩɩn ánɩ́ obékiná mʋ ŋáintɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Támɛ brɛ́á ɔdɛ mʋ́ agywɩɩn bwɛ á, kɩ, Bulu-ɔbɔpʋ ɔkʋ lɛ́lɛ ɩwɩ ɔwan súná mʋ okudetɔ, bláa mʋ ɔbɛ́ɛ, “Yosef, Dawid mʋ na, mánya pɛ́lɩ ánɩ́ fɛ́kpa fʋ́ ká Maria ba fʋ́ wá, tsúfɛ́ ɔmɛ́ ámʋ́ʋ́ ɔdɛ ámʋ itsú Ɔŋɛ Wankɩ́hɛ́ túmitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔbɔ́kwɩɩ́ obiyímbi, bɛ́dɩnká mʋ dá Yesu. (Mʋ́ asɩ gyí, ‘Ɔlɛpʋ́.’) Tsúfɛ́ mʋ ɔbɛ́lɛ mʋ ahá tsú amʋ́ lakpantɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɩ́nɩ lɛ́ha Bulu asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́sʋ ámʋ ɩlɛba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ɔbɛ́ɛ, “Kɩ, obitebí ánɩ́ ɔmɔkʋ́yɔ́ oyin wá kɩ obénya ɔmɛ́. Ɔbɔ́kwɩɩ́ obiyímbi, bɛ́dɩnká mʋ dá Imanuel.” (Mʋ́ asɩ gyí, “Bulu bʋ anɩ wá.”) ");
INSERT INTO nkoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Brɛ́á Yosef létsinkí á, olegyi asʋ́n ámʋ́ʋ́ Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ amʋsʋ. Oletsiá Maria, kpáɩ́n mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Támɛ ɔmɔpʋ ɩbɩ da Maria, kpɛ́fʋn brɛ́á ɔlɔkwɩɩ́ mʋ bi yínhɛ́ gyankpapʋ, ɔlɛdɩnká mʋ dá Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Brɛ́á Owíe Herode dɛ́ iwíe gyí Yudea ɔmátɔ́ bɔkwɩɩ́ Yesu wúlu kʋá bʋtɛtɩ́ mʋ́ Betlehem, ɩbʋ Yudea ɔmátɔ́ ɩnʋ. Mʋ́ ɔma a, anyansapʋ akʋá bʋtowun atɔ́ ntsrakpabitɔ botsu owí ɔdalɩkpa ɔmá kʋtɔ ba Yerusalem wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bɛfɩtɛ́ bɛɛ, “Nkʋ́nʋ́ bakwɩ́ɩ́ Yudafɔ owíe amʋ? Anɩlówun mʋ osúna ánɩ́ igyi ɔtsrakpabi owí ɔdalɩkpa ɩnʋ. Mʋ́ sʋ abá bosúm mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Owíe Herode lónu asʋ́n ánfɩ á, opúni letsií mʋa Yerusalemfɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mʋ́ sʋ ɔlɛtɩ Yudafɔ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ fɛ́ɛ́ fía, fɩ́tɛ́ amʋ́ ɔtɩ́nɛ́á bɔ́kwɩɩ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ). ");
INSERT INTO nkoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɛbláa mʋ bɛɛ “Betlehem wúluá ɩbʋ Yudea ɔmátɔ́. Alɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋ lɔ́wanlɩ́n tswɩ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ɔbɛ́ɛ, ‘Fʋ́ Betlehem, Yudea wúlu, fʋmegyí wúlu túkúrííbi ɔkpagyíɔkpasʋ Yudea awúlu yilé ámʋtɔ. Tsúfɛ́ ɔmásʋ́ ogyípʋ́ ɔkʋ ɔbɛ́dalɩ tsu fʋ́tɔ́á, ɔbɛ́kpa Bulu ahá Israelfɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mʋ́ sʋ Owíe Herode lɛ́tɩ anyansapʋ amʋ nkʋlɛ, fɩ́tɛ́ amʋ́ brɛ́á bowun osúna ɔtsrakpabi amʋ, bɛbláa mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mʋ́ʋ́ ɔlɔwa amʋ́ Betlehem ɔbɛ́ɛ, bʋyódunká kebi ámʋ wankláán. Nɩ́ bowun mʋ a, bʋyínki bɛbláa mʋ, mɛ́nɩ mʋ ɛ́ móyósum mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Olenya bláa amʋ́ tá alɩ bɛnatɩ́. Ɔtsrakpabi amʋ́ʋ́ bowun owí ɔdalɩkpa amʋ, lɛ́kpa amʋ́ alɩɩ yɛ́lɩɩ́ ɔtɩ́nɛ́á kebi ámʋ bʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Brɛ́á bowun ɔtsrakpabi amʋ a, ansɩ́ lɛhɩɛ gyi amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bowie wóyítɔ́ ɩnʋ á, bowun kebi ámʋ mʋa mʋ yin Maria, bɛda akpawunu súm kebi ámʋ. Bɛsankɩ́ amʋ́ akentebi, bekie mʋ sika pɛpɛ, ɔhɩ́ɛ́n pʋ́ ohuam. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mʋ́ ɔma a, Bulu lɔ́wa mbla há amʋ́ okudetɔ ɔbɛ́ɛ, bʋmáyinkí yɔ́tsʋn Herode wá. Mʋ́ sʋ bɔtsʋn ɔkpa bámbásʋ́ yɔ́ amʋ́ wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Brɛ́á anyansapʋ amʋ bɛnatɩ́ á, Bulu-ɔbɔpʋ lɛ́lɛ ɩwɩ ɔwan súná Yosef okudetɔ, bláa mʋ ɔbɛ́ɛ, “Kʋsʋ, afʋkpa kebi ámʋ mʋa mʋ yin srɩ ya Egyipte ɔmátɔ́. Mlɩtsia ɩnʋ yɔ́fʋn brɛ́á nɛ́bláa fʋ mbɛ́ɛ mlɩyínki ba, tsúfɛ́ Owíe Herode obódunká kebi ámʋ, mɔ́ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mʋ́ sʋ Yosef lɔ́kʋsʋ́ onyé-onyé ámʋ, kpá Maria mʋa kebi ámʋ srɩ́ ya Egyipte ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Betsiá ɩnʋ yɔ́fʋn brɛ́á Herode lówu. Ɩ́nɩ lɛ́ha Bulu asʋ́n ánɩ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋsʋ lɛba mʋ́tɔ́. Ɔbɛ́ɛ, “Nɛtɩ mɩ́ bí ámʋ tsú Egyipte ɔmátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Brɛ́á Owíe Herode lówun ánɩ́ anyansapʋ amʋ bamlɛ́ mʋ a, ɔblɔ́ lɛhɩɛ kɩ́tá mʋ́. Ɔlɔwa mʋ ɩsá akɔpʋ́ ɔbɛ́ɛ, bʋyɔ́ Betlehem wúlutɔ pʋ́ mʋ́ nkudasɩ, abʋyɔmɔ abi yinhɛ́ ánɩ́ bahɔ tsú nfinyɔ ba ayasɩ fɛ́ɛ́. Tsúfɛ́ anyansapʋ amʋ bɛbláa mʋ bɛɛ, begyankpá wun ɔtsrakpabi amʋ nfinyɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɩ́nɩ lɛ́ha Bulu asʋ́n ánɩ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yeremiasʋ lɛba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ɔbɛ́ɛ, “Bonu isú mʋ́a olú kʋá ɩmɛká tin Rama wúlutɔ. Rahel dɛ́ mʋ abí sú. Omotsulá ánɩ́ bʋkpáta mʋ, tsúfɛ́ bʋtráa bʋma ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Owíe Herode lowu ɔma a, Bulu-ɔbɔpʋ lɛ́lɛ ɩwɩ ɔwan súná Yosef okudetɔ Egyipte ɩnʋ, bláa mʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kʋsʋ, afʋkpa kebi ámʋ mʋa mʋ yin, amlɩyinki yɔ Israel ɔmátɔ́. Tsúfɛ́ ahá ámʋ́ʋ́ bodunká ánɩ́ bɔ́mɔ kebi ámʋ, bawú.” ");
INSERT INTO nkoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mʋ́ sʋ Yosef lɔ́kʋsʋ́ kpá kebi ámʋ mʋa mʋ yin, beyinkí yɔ́ Israel ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Támɛ brɛ́á bowie ɩnʋ á, olonu ánɩ́ Arkelao latsíá mʋ sɩ Herode obíásʋ́, ɔdɛ Yudea ɔmásʋ́ gyí. Mʋ́ sʋ olenya ifú ánɩ́ ɔbɔ́pʋ kebi ámʋ ya ɩnʋ. Bulu lɛ́lawá mbla há mʋ okudetɔ ɔbɛ́ɛ, ɔpʋ́ʋ mʋ ya Galilea ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mʋ́ sʋ bɔyɔ yétsiá Nasaret wúlutɔ. Ɩ́nɩ lɛ́ha Bulu asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́sʋ ɔbɛ́ɛ, “Bɛ́tɩ mʋ Nasaretyin” amʋ ɩlɛba mʋ́tɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Brɛ́ kʋtɔ á, Asú Ɔbɔpʋ́ Yohane lɛ́ba ɔdɛ Bulu asʋ́n ɔkan da Yudea dimbísʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ɔbɛ́ɛ, “Mlɩdamli klʋntɔ, amlɩsi lakpan bwɛ, tsúfɛ́ Bulu iwíegyí lawíé wóyí tá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohane ɩwɩ asʋ́n Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɔ́wanlɩ́n ɔbɛ́ɛ, “Ɔkʋ dɛ́kplʋn dimbísʋ́ ɔbɛ́ɛ, ‘Mlɩla anɩ Wíe ɔkpa. Mlɩtswii ɩkpa ha mʋ’ ” amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane lɔ́wa kpɔ́sɔ́-imi atadɩɛ, ɔlɔpʋ ɔwʋlʋ́-kpákpá ɔfɛ́ klɩ́ mʋ́sʋ́. Atsantsankʋ pʋ́ ɔkwɛ́n otegyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ahá botsu Yerusalem wúlutɔ, Yudea ɔmátɔ́ pʋ́ Yordan bʋnkpa ɔnɔ́ awúlu fɛ́ɛ́sʋ́ ba bonu mʋ asʋn blɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɛlɛ amʋ́ lakpan blɩ́, ɔlɔbɔ amʋ́ asú Yordan ntsutso. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Támɛ brɛ́á Farisifɔ pʋ́ Sadukifɔ tsɔtsɔɔtsɔ bɛba bɛɛ, ɔbɔ́ɔ amʋ́ asú á, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Abɛ abí-aná, ntɔ gyá mlɩ, mlɩsrɩ́ Bulu ɩsʋbɩtɩ́ ámʋ́ʋ́ ɩbá ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mʋ́mʋ́ mlɩswie abíá ibósuná ánɩ́ lɛ́lɛ́ mlɩladámlí klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mlɩmákɩ mlɩaa, mlɩ náin gyí Abraham. Mʋ́ sʋ Bulu mɛ́ɛbɩtɩ́ mlɩ ɩsʋ. Ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́talɩ́ há abwi ánfɩ ɩbɛ́damlí Abraham abí-aná. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Séi á, Bulu lapʋ́ ɛfɛ́ yi nyí-atsitsitɔ. Oyígyíoyí ánɩ́ imoswie abi wankláán á, bókun mʋ́ dá, wá mʋ́ fɛ́ɛ́ ogyá. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mɩ́ mʋ́ á, ntsu ndɛpʋbɔ́ mlɩ asú pʋ́súná ánɩ́ mlɩladámlí klʋntɔ. Támɛ ɔkʋá ɔdʋn mɩ bʋ ɔma ɔbá. Mmɔfʋn ánɩ́ nɔ́sʋrá mʋ ntʋkʋta kʋ́ráá. Mʋ ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ pʋ́ ogyá bɔ́ mlɩ asú nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔdɛ mʋ ɩlɩ́n, ɔbɔ́pʋfúní ntɛ́tɛ lɛ́ ayó ámʋtɔ. Ɔbɛ́kpa ayó ámʋ wá mʋ odudutɔ. Támɛ ɔbɛ́fɛɩ́ ofuníkpá ɩnʋ wankláán, kpá ntɛ́tɛ amʋ wá ogyá ánɩ́ ɩtamaduntɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu lótsu Galilea ɔmátɔ́ ba Yordan ntsu ɔnɔ́ Yohane wá ɔbɛ́ɛ, ɔbɔ́ mʋ asú. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tɛkɩ Yohane mótsulá ánɩ́ ɔbɔ́bɔ mʋ asú. Ɩ́nɩ sʋ ɔlɛbláa Yesu ɔbɛ́ɛ, “Mɩ́ ilehián ánɩ́ fɔ́bɔ asú. Nkálɩ ígyi sʋ́ faba fɛɛ mɩ́ ɔbɔ́ɔ fʋ́ asú?” ");
INSERT INTO nkoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Séi á, ha atsu mʋ́ alɩ asa, tsúfɛ́ ilehián ánɩ́ abɔ́bwɛ tógyítɔ́á ɩda ɔkpa Bulu ansɩ́tɔ́.” Mʋ́ sʋ Yohane lótsulá. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Brɛ́á ɔlɔbɔ Yesu asú tá, Yesu lɛ́dalɩ ntsu ámʋtɔ alɩ nwʋlʋ́táa lefinkí, olowun Bulu Ɔŋɛ́ dɛkplɩ́ fɛ́ abrɔ́dʋma, ilobogyonká mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɩnʋ ɔmɛ kʋ lotsu ɔsʋ́sʋ́ ɔbɛ́ɛ, “Ɔ́nɩ gyí mɩ́ Bíá ntɔdwɛ́ mʋ, mɩ ansɩ́ tɛhɩ́ɛ́ gyi mʋ ɩwɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɩnʋnʋ Ɔŋɛ Wankɩ́hɛ́ amʋ lɛ́kpa Yesu ya dimbísʋ́, mɛ́nɩ Ɔbʋnsám ɔbɔ́sɔ mʋ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oletsiá ɩnʋ klɩ́ ɔnɔ́ nkɛ adʋana (40), onyé adʋana (40). Mʋ́ sʋ akʋ́n lɛhɩɛ kɩ́tá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ɩnʋ Ɔbʋnsám lɔ́sɔ mʋ kɩ, bláa mʋ ɔbɛ́ɛ, “Nɩ́ Bulu mʋ Bi fʋ́gyi á, mʋ́mʋ́ ha abwi ánfɩ ɩdamli bwɛ bodobodo.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Megyí atogyihɛ wʋlɛ nyankpʋsa obégyi tsiá nkpa, támɛ ɔpʋ́ʋ Bulu asʋn blɩ́hɛ́ ɛ́ tsia nkpa.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɔbʋnsám lɛ́kpa mʋ ya Yerusalem, wúlu wankɩ́hɛ́ amʋtɔ, ɔlɔpʋ mʋ yɛ́lɩɩ́ Bulu ɔtswɛ́kpa obu ámʋ ɔtántra. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ɩnʋ ɔlɛbláa Yesu ɔbɛ́ɛ, “Nɩ́ Bulu mʋ Bi fʋ́gyi lɛ́lɛ́ á, tu kpayi. Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Bulu ɔbɛ́ha mʋ abɔpʋ bɛ́kpatá fʋ́ ɩbɩtɔ, mɛ́nɩ fʋ́ yabi mɛ́ɛda ibwi kʋkʋsʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bɛtrá wanlɩ́n bɛɛ, ‘Mákapʋ́ fʋ́ Wíe Bulu kɩ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mʋ́ ɔma a, Ɔbʋnsám lɔ́pʋ mʋ ya ɩbʋ fʋ́áhɛ́ kʋsʋ, olosuná mʋ ɔyɩ́tɔ́ iwíe ogyíkpá fɛ́ɛ́, pʋ́ mʋ́ numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Nɩ́ fɛ́da akpawunu súm mɩ́ á, nɔ́pʋ ɩ́nɩ fɛ́ɛ́ há fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔbʋnsám, natɩ tɛɩ mɩ́sʋ́! Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Da akpawunu ha fʋ́ Wíe Bulu. Mʋ nkʋlɛ fʋ súm.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɩnʋ Ɔbʋnsám lɛ́natɩ́ mʋ wá, Bulu-abɔpʋ bɛba bɛkɩ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mʋ́ ɔma a, Yesu lónu ánɩ́ bakɩ́tá Yohane tswɩ obu, oleyinkí ba Galilea ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Olotu tsú Nasaret wúlutɔ yɔ́ Kapernaum, wúluá ɩbʋ mantáa Galilea ɔpʋ ɔnɔ́, Sebulon mʋ́a Naftali ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mʋ ɩnʋ yɔ lɛ́ha asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɛ́blɩ́ ámʋ ɩlɛba mʋ́tɔ́. Ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon pʋ́ Naftali ɔsʋlʋ́ʋá ɩda Yordan bʋnkpa ɔnɔ́, mantáa Galilea ɔpʋ. Galilea ɔmátɔ́ ɔmá bámbásʋ́fɔ bʋtsie. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ahá ánfɩ́ bʋtsie oklúntɔ ánfɩ bawun wankɩ kpɔnkpɔɔnkpɔntɩ kʋ. Bʋtsie ɔsʋlʋ́ʋá lowu dɛ́ iwíe gyí mʋ́sʋ́. Wankɩ kʋ lawánkɩ́ wʋ́lɩ́ amʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tsú ɩnʋ Yesu léfi asɩ ɔdɛ Bulu asʋ́n ɔkan da, blɩ́ ɔbɛ́ɛ, “Mlɩdamli klʋntɔ, Bulu iwíegyí lawíé wóyí tá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ɛkɛ ɔkʋá Yesu ná Galilea ɔpʋ ɔnɔ́ á, olowun apíó abanyɔ́ akʋ. Simon ánɩ́ bʋtɛtɩ́ mʋ Petro mʋa mʋ gyama Andrea, bʋdɛ asawu tswɩ́ɩ, tsúfɛ́ aye alɛpʋ́ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩba bobuo mɩ. Nɔ́bwɛ mlɩ anyánkpʋ́sa alɛpʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɩnʋnʋ besi amʋ́ asawu aná tswɩ, kplá buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɔlɛnatɩ́ yɔ́ nkpá kpalobí, olowun apíó abanyɔ́ akʋ ɛ́, Yakobo mʋa mʋ gyama Yohane. Amʋ́a amʋ́ sɩ́ Sebedeo bʋbʋ ɔklʋntɔ, bʋdɛ amʋ́ asawu bɩ́ɩn, Yesu lɛ́tɩ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɩnʋnʋ amʋ́ ɛ́ bɛnatɩ́ sí amʋ́ sɩ́ mʋa ɔklʋn amʋ bobuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu léki Galilea ɔmátɔ́ fɛ́ɛ́, súná atɔ́ Yudafɔ ofíakpa. Ɔlɛda Bulu iwíegyí ámʋ ɩwɩ asʋn wankláán ɔkan. Ɔlɛtsa ɔŋɛ́tɔ́ mʋ́a awútɔ́ ɩlɔ kugyíkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɩ́nɩ sʋ mʋ ɩwɩ asʋ́n lɛklɛɩ́ yɔ́ Siria ɔmátɔ́ fɛ́ɛ́. Bɔpʋ alɔpʋ tsúa ntɩ́nɛ́-ntɩ́nɛ́ ba mʋ. Ɔlɛtsa ɩlɔ kugyíkʋ, ahá ánɩ́ bʋdɛ ɩwɩɔsɩn wúun, amʋ́á ɔŋɛ laláhɛ dɛ́ amʋ́ háan, amʋ́á ɩlɔ dɩ́dahɛ bʋ amʋ́sʋ́ pʋ́ abubúpʋ aná fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mʋ́ sʋ ɔdɔm kpɔnkpɔɔnkpɔntɩ bobuo mʋ. Ahá ánɩ́ botsú Galilea ɔmátɔ́ pʋ́ Dekapoli awúlu amʋsʋ, Yerusalem wúlutɔ, Yudea ɔmátɔ́ pʋ́ Yordan ntsu ɔbɩn ɔsʋlʋ́sʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Brɛ́á Yesu lówun ɔdɔm amʋ a, ɔlɔdʋ yɔ́ ɩbʋ kʋsʋ yétsiá asɩ, mʋ akasɩ́pʋ́ amʋ bɛba mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ɩnʋ olosuná amʋ́ atɔ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bulu layúlá ahá ánɩ́ amʋ́ ansɩ́ mɛdɩ́n tɔtɔsʋ dʋn mʋ Bulu, tsúfɛ́ amʋ́bʋ́ mʋ iwíegyí ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bulu layúlá awɩrɛhɔ agyípʋ́, tsúfɛ́ obólwií amʋ́ klʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bulu layúlá ɩwɩasɩ abápʋ, tsúfɛ́ amʋ́ obégyi ɔsʋlʋ́ʋ amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bulu layúlá ahá ánɩ́ mʋ apɛ́bwɛ akʋ́n mʋ́a ɔmɛwʋ́lɩ dɛ amʋ́, tsúfɛ́ ɔbɛ́ha amʋ́ bɔ́mwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bulu layúlá nwɛ awúnpʋ, tsúfɛ́ obówun amʋ́ nwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bulu layúlá ahá ánɩ́ amʋ́ klʋntɔ lɔwankɩ́, tsúfɛ́ amʋ́ obówun mʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bulu layúlá ahá nsɩnɛ́ alapʋ́, tsúfɛ́ ɔbɛ́tɩ amʋ́ ɔbɛ́ɛ mʋ abí. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bulu layúlá ahá ánɩ́ bʋdɩn amʋ́sʋ́ mʋ apɛ́bwɛ sʋ, tsúfɛ́ amʋ́bʋ́ mʋ iwíegyí amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bulu layúlá mlɩ, nɩ́ bʋdɛ mlɩ sia, bʋdɩn mlɩsʋ, bʋdɛ afunu wa dɩ́nká mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ansɩ́ igyí mlɩ, ɩwɩ ɩsankɩ mlɩ, tsúfɛ́ mlɩ ɩkɔká tsɔ ɔsʋ́sʋ́. Alɩ́ bɔbwɛ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ agyankpapʋ amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mlɩgyí ɔyɩ́tɔ́ nfɔ́lɩ nɩ. Nɩ́ nfɔ́lɩ ɩtá ɔdwɛ á, ntɔ bɛ́lapʋ́wá mʋ́ ɔdwɛ? Ɩtráa ma alɛ há tɔtɔɔtɔ bwɛ. Tsɛɩ́ bʋtɛtsɛ́ɩ́ mʋ́ tsítsá, ahá bʋtɛtsátsa mʋ́sʋ́ tsʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mlɩgyí ɔyɩ́tɔ́ wankɩ ɛ́ nɩ́. Wúluá ɩdɩn bʋsʋ tamaŋáín. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bʋtamanywɛ́ ɔkandɩ́ɛ, pʋ́ ɔlɔ́ bun mʋ́sʋ́. Ɔfʋákpá bʋtɔpʋ́bían, mɛ́nɩ ɩbɔ́wankɩ́ há ahá ánɩ́ bʋtsie wóyí ámʋtɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mʋ́ sʋ mlɩha mlɩ bwɛhɛ́ ɩwankɩ alɩ, mɛ́nɩ ahá bówun mlɩ bwɛhɛ́ wankláán ámʋ, fówun bɛ́kanfʋ́ mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mlɩmákɩ mlɩaa, nɛba Mose Mbla ntɛ́ɛ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ atosunáhɛ́tɔ ɔkakpá. Mmɛba mʋ́tɔ́ ɔkakpá, mboún nɛbá bɔbwɛ mʋ́ ɩfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ɔnɔkwalɩ ndɛ mlɩ bláa, ɔsʋ́ mʋ́a asɩ bɔ́mɔ ɔnɔ́, támɛ itoduáhɛ́ ntɛ́ɛ asʋ́nbi kʋlɛ kʋ́ráá ɩmɛ́ɛdalɩ Mbla ámʋtɔ, yɔ́fʋn brɛ́á mʋ́tɔ́ asʋ́n fɛ́ɛ́ laba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɔhagyíɔha ánɩ́ omobu mbla ámʋtɔ túkúrííbi kʋ, olosuná mʋ aba ɛ́ ɔbɛ́ɛ bʋmábu mʋ́ á, bɛ́tɩ mʋ kebi túkúrííbi ɔsʋ́sʋ́ iwíe ogyíkpá ɩnʋ. Támɛ ɔhá ánɩ́ olegyi mbla ámʋ fɛ́ɛ́sʋ́, súná mʋ aba ánɩ́ bʋgyíi mʋ́sʋ́ á, bɛ́tɩ mʋ ɔha yilé ɔsʋ́sʋ́ iwíe ogyíkpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ mlɩmɔ́bwɛ Bulu apɛ́ dʋn Mose mbla asunápʋ́ pʋ́ Farisifɔ ámʋ a, mlɩmóowie Bulu iwíegyí amʋtɔ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mlɩlanú ánɩ́ bɛbláa mlɩ anáin atɩtɩfɔ ámʋ bɛɛ, ‘Mámɔ ɔha. Ɔhagyíɔha ánɩ́ ɔmɔ́ ɔha a, Bulu obégyi mʋ asʋ́n, há mʋ ɩpɔ́n.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, ɔhagyíɔha ánɩ́ olenya ɔblɔ́ wa mʋ ba á, Bulu obégyi mʋ asʋ́n. Ɔhá ánɩ́ olesia mʋ ba ɔbɛ́ɛ, ‘Ɔhakpan!’ á, obégyi ɩpɔ́n Yudafɔ asʋ́n agyípʋ́ ansɩ́tɔ́. Ɔhagyíɔha ánɩ́ ɔlɛbláa mʋ ba ɛ́ ɔbɛ́ɛ, ‘Raka!’ a, obégyi ɩpɔ́n yɔ́ ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ɩ́nɩ sʋ nɩ́ fotsu atɔ hahɛ́ fɔyɔ́ afɔdɩɛ ɔbɔkpá, fɛkaɩ́n ánɩ́ fapʋ́ asʋn laláhɛ kʋ gyi fʋ́ bá á, ");
INSERT INTO nkoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","si fʋ́ atɔ́ amʋ́ yaɩ afɔdɩɛ-asubwisʋ ɩnʋ. Yɔ fʋ́a mʋnyɔ amlɩla mlɩ nsɩnɛ́, asa afʋba bɔbɔ afɔdɩɛ ámʋ ha Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nɩ́ ɔkʋ ɔsáma fʋ á, wa ɔsa ha abʋyobwií ɩpa ha mʋ asa asʋ́n ámʋ ogyíkɛ́ ɩfʋn, mɛ́nɩ fʋ́ onyabá ámʋ ɔmɛ́ɛha asʋ́n agyípʋ́ bʋmɔ́ɔpʋ fʋ́ ha obu adɩpʋ́sʋ́ ɔkɩ́pʋ, ɔwa fʋ́ obu. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mbláa fʋ ɔnɔkwalɩ, nkɛ́tɩ faká ɩkɔ ámʋ fɛ́ɛ́ tá asa fɛ́dalɩ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mlɩlanú ánɩ́ bɛbláa mlɩ bɛɛ, ‘Mákle ɔkʋ tsiába.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, oyingyíoyin ánɩ́ olowun ɔtsɩ, ɔlɔbwɛ mʋ klé ɩwɩ agywɩɩn á, alatɔ́ mbʋa dodo mʋ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mʋ́ sʋ nɩ́ fʋ́ gyɔpɩ nsíbi tɛhá fʋ́tɔbwɛ́ lakpan á, loti mʋ́ lɛ, tswɩ tsalɩfwɩ. Ɩbʋ alɛ́á fʋ́ ɩwɩ ɔtɩnɛkʋ má ɩnʋ, dʋn ánɩ́ bɔ́tswɩ fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ wá ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mʋ́ sʋ nɩ́ fʋ́ gyɔpɩ ɩbɩ tɛhá fʋ́tɔbwɛ́ lakpan á, ka mʋ́ tswɩ tsalɩfwɩ. Ɩbʋ alɛ́á fʋma ɩbɩ kʋlɛ, dʋn ánɩ́ bɔ́tswɩ fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ wá ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bɛtrá bláa mlɩ bɛɛ, ‘Ɔhagyíɔha ánɩ́ obékiná ɔká á, ɔwánlɩn ɔkákiná ɔwʋlʋ́ ha mʋ asa.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ oyin okíná mʋ ka ánɩ́ ɔmɔkʋ́dálɩ mʋ ɔma a, mʋláhá sʋ ɔtsɩ ámʋ ɔbɛ́dalɩ mʋ ɔma. Oyingyíoyin ánɩ́ otsía ɔtsɩ ánfɩ mʋ kulu lakíná mʋ anfɩ ɛ́ latɔ́ mbʋa. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mlɩlɛ́trá nu ánɩ́ bɛbláa mlɩ anáin atɩtɩfɔ ámʋ bɛɛ, ‘Máka ntam kpaalɩ. Mboún bwɛ dɩnka ntam amʋ́ʋ́ fɛka há Bulu ámʋsʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, máka tɔtɔɔtɔ kʋ́ráá. Mápʋ ɔsʋ́sʋ́ ká ntam, tsúfɛ́ Bulu owíe obíá igyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mápʋ ɔsʋlʋ́ʋ ká ntam. Bulu ayabi oyíkpa igyi. Mápʋ Yerusalem wúlu ká ntam. Awíetɔ Owíe wúlu kpɔnkpɔntɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mlɩmápʋ mlɩ nwun ká ntam, tsúfɛ́ mlɩmɛ́ɛtalɩ́ bwɛ́ imi kʋlɛ futútú ntɛ́ɛ bíbi. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mboún fʋ́ ‘Iin!’ ɩbwɛ́ɛ ‘Iin!’ Fʋ́ ‘Ó-o!’ ɛ́ ɩbwɛ ‘Ó-o!’ Kugyíkʋá fɛ́trá blɩ́ tsɩ́a mʋ́tɔ́ itsú Ɔbʋnsám wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mlɩlanú ánɩ́ bɛblɩ́ bɛɛ, ‘Ɔha obwíé mʋ ba nsíbi a, bʋbwíe mʋ ɛ́ mʋ klɛ ka ɩkɔ. Ɔha otsíí mʋ ba iyín ɛ́ á, bʋtsíi mʋ klɛ ka ɩkɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, mlɩmákplá ɔha laláhɛ. Mboún nɩ́ ɔha ɔdá fʋ́ ɩsʋtɔ á, damli nyɔɔsɩ ɛ́ ha mʋ ɔdáa. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nɩ́ ɔha dékléá ɔbɛ́samáa fʋ, hɔ fʋ́ atadɩɛ á, pʋ fʋ́ tati ɛ́ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɔhá ánɩ́ ɔdʋn fʋ ɔhɩ́ɛ́ fʋ́ ɔbɛ́ɛ, fʋsʋ́ra mʋ atɔ́ máɩlɩ kʋlɛ ha mʋ a, sʋra mʋ́ máɩlɩ anyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɔha ɔkʋ́lɩ́ fʋ́ atɔ́ á, ha mʋ. Nɩ́ ɔkʋ ɛ́ ɔbɛ́ɛ fʋpáan mʋ tɔkʋ á, mákiná. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mlɩlónuá bɛblɩ́ bɛɛ, ‘Dwɛ fʋ́ bá, afʋlu fʋ́ olupʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Támɛ mɩ́ mʋ́ ndɛ mlɩ bláa mbɛ́ɛ, mlɩdwɛ mlɩ alupʋ́. Mlɩbɔ mpáɩ ha ahá ánɩ́ bʋdɩn mlɩsʋ, mɛ́nɩ mlɔ́bwɛ mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ abí. Tsúfɛ́ mʋtɛ́há owí tɛlɩn, ɔtɛhá nyankpʋ ɛ́ itotswie wʋlɩ́ aha wankláán pʋ́ aha laláhɛ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nɩ́ fʋ́ adwɛpʋ́ nkʋlɛ fʋtɔdwɛ́ á, ɩpán mɔmʋ fénya? Lampóo ahɔ́pʋ kʋ́ráá bʋtɔbwɛ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nɩ́ fʋ́ anyawíe nkʋlɛ fʋtɔwá ɔnɔ́ á, ntɔ fakʋkʋ bwɛ dʋbɩ? Alɩ kɛ́n ɔmátɔ́fɔ bʋtɔbwɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ɩ́nɩ sʋ mlɩfʋn fɛ́ alɩá mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ lɔ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mlɩkɩ wankláán ánɩ́ mlɩmɔ́ɔbwɛ mlɩ yilé ahá ansɩ́tɔ́. Nɩ́ mlɔbwɛ́ mʋ́ alɩ á, mlɩméenya ɩkɔká mlɩ Sɩ́á ɔbʋ ɔsʋ́sʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mʋ́ sʋ nɩ́ fɔbwɛ́ yilé há ohiáni á, máda mʋ́ ɔkan fɛ́ alɩá apinabwɛbí abwɛpʋ́ bʋtɔbwɛ́ Yudafɔ ofíakpa pʋ́ dɩnsʋ, mɛ́nɩ ahá bɛ́kanfʋ́ amʋ́. Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, Bulu laká amʋ́ ɩkɔ dodo. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Támɛ nɩ́ fɔbwɛ́ yilé há ohiáni á, máha fʋ́ bɩna ɔbɩ tɔ́á gyɔpɩ labwɛ́. Bwɛ mʋ́ ŋáintɔ, ");
INSERT INTO nkoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","mɛ́nɩ fʋ́ Sɩ́ oklúntɔ atɔ́ owúnpʋ amʋ ɔbɛ́ka fʋ́ ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nɩ́ mlɔ́bɔ mpáɩ á, mlɩmábwɛ fɛ́ apinabwɛbí abwɛpʋ́. Amʋ́ tekle Yudafɔ ofíakpa pʋ́ dɩnsʋ lɩɩ́ bɔ́ mpáɩ, mɛ́nɩ ahá bówun amʋ́. Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, Bulu laká amʋ́ ɩkɔ dodo. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Támɛ nɩ́ fɔ́bɔ mpáɩ á, bítíwíé fʋ́ obutótɔ́, afʋfin obu wa ɩwɩ, bɔ mpáɩ ha fʋ́ Sɩ́ ŋáintɔ. Fʋ́ Sɩ́ ŋáintɔ atɔ́ owúnpʋ amʋ ɔbɛ́ka fʋ́ ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nɩ́ mlɩdɛ́ mpáɩ bɔ á, mlɩmátsiá plá mʋ́tɔ́ há mʋ́ ɩwa swɩ́ fɛ́ ɔmátɔ́fɔ. Bʋtosúsu bɛɛ, nɩ́ bɔbɔ́ mʋ́ ɩwá swɩ́ asa Bulu obónu mʋ́ há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mlɩmábwɛ fɛ́ amʋ́, tsúfɛ́ mlɩ Sɩ́ Bulu yín tɔ́á ɩdɛ mlɩ hián asa mlɩdɛ́ mʋ kʋlɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mʋ́ sʋ mlɩbɔ mpáɩ mlɩaa, ‘Anɩ Sɩ́á fʋ́bʋ ɔsʋ́sʋ́. Ahá bʋbúu fʋ́ dá. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ba begyi iwíe. Ahá bʋbwɛ́ɛ fʋ́ apɛ́ ɔsʋlʋ́sʋ, fɛ́ alɩá bʋtɔbwɛ́ mʋ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ha anɩ atogyihɛá ɩbɔ́fʋn anɩ ndɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Si anɩ lakpan kie anɩ, fɛ́ alɩá anɩtesíkíé ahá ánɩ́ bʋtɔpʋ́ ɩlá gyi anɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mákpa anɩ wá ɩsɔ́kɩtɔ, mboún lɛ anɩ tsu Ɔbʋnsám ɩbɩtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Tsúfɛ́ nɩ́ mlesí ahá lakpan kíé amʋ́ á, mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ ɛ́ obési mlɩ klɛ́ kíé mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Támɛ nɩ́ mlɩmésikíé ahá a, mlɩ Sɩ́ ámʋ ɛ́ oméesikíé mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nɩ́ mlɩdɛ́ ɔnɔ́ klɩ́ á, mlɩmábwɛ mlɩ ɩwɩ bʋ́mbláán fɛ́ alɩá akʋ bʋtepina bwɛ́. Alɩá ahá bówun ánɩ́ bʋdɛ ɔnɔ́ klɩ sʋ́ bʋtɔbwɛ́ ɩwɩ alɩ. Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, Bulu laká amʋ́ ɩkɔ dodo. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mboún nɩ́ mlɩdɛ́ ɔnɔ́ klɩ́ á, mlɩbie ntsu, amlɩfunya nwun, ");
INSERT INTO nkoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mɛ́nɩ ahá bʋmóowun ánɩ́ mlɩdɛ́ ɔnɔ́ klɩ́. Támɛ mlɩ Sɩ́ oklúntɔ atɔ́ owúnpʋ amʋ mʋ́ obówun mlɩ, ká mlɩ ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mlɩmákle atɔ́ yáɩ́ ɔsʋlʋ́ʋ anfɩsʋ. Ɔtɩ́nɛ́ ánfɩ atɛ́plɛ bʋtɔwɩ́ atɔ́, ɩkʋ aná tɔwɩ́ nkanʋ yíntá, awikplu ɛ́ bʋtobwíé wíé obuto wí atɔ́ ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mboún mlɩkle atɔ́ yáɩ́ ɔsʋ́sʋ́. Ɩnʋ mʋ́ á, atɛ́plɛ bʋtamawɩ́ atɔ́, ɩtamawɩ́ nkanʋ, awikplu ɛ́ bʋtamabwíé wíé obuto wí atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tsúfɛ́ ɔtɩ́nɛ́á fʋ́ siadɩɛ bʋ a, ɩnʋ́ fʋ́ agywɩɩn tetsíá. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ansíbi igyi ɔkandɩ́ɛ há nyankpʋsa-oyí. Nɩ́ fʋ́ ansíbi bʋ alɛ́ á, fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ bɔ́wankɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Támɛ nɩ́ fʋ́ ansíbi ma alɛ a, fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ ɩbʋ oklúntɔ. Nɩ́ ɔkandɩ́ɛ ámʋ́ʋ́ ɩbʋ fʋtɔ ámʋ idun a, mʋ́mʋ́ fawíé oklún kpɔnkpɔɔnkpɔntɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ɔhaa mɛ́ɛtalɩ́ súm awie anyɔ. Ɔbɔ́dwɛ ɔkʋlɛ, lú ɔkʋlɛ. Ntɛ́ɛ obóbu ɔkʋlɛ, omóobu ɔkʋlɛ. Fʋmɛ́ɛtalɩ́ súm Bulu, súm kɔ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, mlɩmáhan ɩwɩ tɔ́á mlégyi, tɔ́á mlónu tsiá nkpa pʋ́ tɔ́á mlɛ́dɩdá sʋ. Mbɛ́ɛ, nkpa medéhián dʋn atogyihɛ? Ntɛ́ɛ ɔyʋlʋ́ʋ medéhián dʋn atɔ dɩdáhɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mlɩkɩ mbubwi, bʋtamadú, bʋtamasɩ́ɛ́tɩ́ wá ɩdantɔ, támɛ mlɩ Sɩ́á ɔbʋ ɔsʋ́sʋ́ tɛhá amʋ́ atogyihɛ. Mlɩmá labi dʋn amʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mlɩtɔ ma ɔbɛ́talɩ́ han ɩwɩ pʋ́ brɛ́ kpalobí tsɩ́a mʋ nkɛtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ntogyi sʋ́ mlɩdɛ́ ɩwɩ háan mlɩ atɔ dɩdáhɛ́ sʋ? Mlɩkɩ alɩá pututɔ-oyí ntswɩ́tswɩ tɛdan. Ɩtamayɔ́ agyʋ́má ntɛ́ɛ lʋ́ atati. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Támɛ ndɛ mlɩ bláa mbɛ́ɛ, Owíe Salomo, mʋ inya fɛ́ɛ́tɔ́ a, ɔmɛtalɩ́ hɩ́hɩɛ ɩwɩ, wá akɩ́lɛ fɛ́ oyí ntswɩ́tswɩ anfɩtɔ kʋkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nɩ́ Bulu dɛ́ ɩfá ánɩ́ ndɛ ɩlɩɩ́, ɔkɛ ɩlawú, bawá mʋ́ ogyá tati dɩdá á, ntogyi sʋ́ ɔmɛ́ɛtalɩ́ dɩ́dá mlɩ atati dʋn mʋ́? Mlɩ hógyi mɔtsɔ́! ");
INSERT INTO nkoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mʋ́ sʋ mlɩmáhan ɩwɩ fɩ́tɛ́ mlɩaa, ‘Ntɔ abégyi?’ ntɛ́ɛ ‘Ntɔ abónu?’ ntɛ́ɛ ‘Ntɔ abɛ́dɩdá?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ɩ́nɩ aná ɔmátɔ́fɔ bʋtɛsrɩ́ gya nɩ. Mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ yin ánɩ́ ɩ́nɩ fɛ́ɛ́ dɛ mlɩ hián. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ɩtɔ́á mlɩgyánkpa dunka gyí, Bulu iwíegyí pʋ́ mʋ yilébwɛ, fówun Bulu ɔbɔ́pʋ ɩ́nɩ fɛ́ɛ́ tsɩ́a mʋ́tɔ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mlɩmásusúu ɔkɛ ɩwɩ. Ɔkɛtɔ asʋ́n igyi ɔkɛ klɛ́. Ekekegyíɛkɛtɔ asʋn wunhɛ ɩtsɔ há ɛkɛ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mlɩmálɛ ahá ɩlá, mɛ́nɩ Bulu ɔmɛ́ɛlɛ mlɩ ɩlá. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tsúfɛ́ alɩ ámʋ́ʋ́ mlɩdɛ́ ahá ɩlá lɛ ámʋ a, alɩ Bulu ɔbɛ́lɛ mlɩ ɩlá nɩ́. Ɩtɔ́á fɔpʋ́súsu ha fʋ́ bá á, mʋ́ kɛ́n Bulu ɔbɔ́pʋsúsu ha fʋ́ ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ntogyi sʋ́ fʋ́dɛ ipí túkúrííbi wun fʋ́ bá nsíbisʋ, támɛ fʋmɛdɛ́ ogyakpatín ánɩ́ ɩdɩn fʋ́ klɛ́sʋ mʋ́ wun? ");
INSERT INTO nkoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ntɛ́ɛ ntogyi sʋ́ fʋ́dɛ fʋ́ bá bláa fɛɛ, ‘Ha mɩ́ andɩnkɩ ipí fʋ́ nsíbisʋ?’ brɛ́á ogyakpatín dɩn fʋ́ klɛ́sʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Apinabwɛbí ɔbwɛpʋ́! Gyankpa dɩnkɩ ogyakpatín ámʋ fʋ́ nsíbisʋ, mɛ́nɩ fówun atɔ́ wankláán, tálɩ́ dɩ́nkɩ́ ipí ámʋ fʋ́ bá klɛ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mlɩmápʋ Bulu atɔ wankɩ́hɛ́ há ahá ánɩ́ bʋgyi fɛ́ akɩ́aɩ, Bulu asʋ́n tamawá amʋ́ ogyá. Bénya ɔblɔ́ dámlí dun mlɩ. Alɩ kɛ́n mlɩmápʋ mlɩ abutó wʋlɩhɛ há ahá ánɩ́ bʋgyi fɛ́ mprákuo nɩ́. Tsúfɛ́ bɛ́tsatsáa mʋ́sʋ́, tsɩ́á mʋ́ wá ɔdɩbatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mlɩkʋlɩ Bulu, ɔbɛ́ha mlɩ. Mlɩdunka, mlówun. Mlɩda mʋ klʋnsʋ, obéfinkí mʋ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tsúfɛ́ ɔhá ánɩ́ ɔtɔkʋ́lɩ́ atɔ́ tenyá. Ɔhá ánɩ́ otodúnká atɔ́ towun. Ɔhá ánɩ́ ɔtɛdá klʋnsʋ bʋ́tefínkí há. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ma bʋ́ʋ mlɩtɔá mʋ bi ɔkʋ́lɩ́ mʋ bodobodo a, obótsu ibwi wá mʋ ɩbɩtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ntɛ́ɛ nɩ́ ɔkʋ́lɩ́ mʋ iye a, ɔbɛ́kɩtá ɩwɔ wá mʋ ɩbɩtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mlɩ lakpan abwɛpʋ́ kʋ́ráá mlɩyin alɩá bʋtɔpʋ́ atɔ wankláán há mlɩ abí. Ntogyi sʋ́ mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ mʋ́ mɔ́ɔpʋ atɔ wankláán há ahá ánɩ́ bʋdɛ mʋ kʋlɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bwɛ ha ahá alɩá fʋdeklé fɛɛ bʋbwɛ́ɛ ha fʋ. Ɩ́nɩ Mose Mbla pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ atosunáhɛ́ dɛblɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Mlɩtsʋn ɔkpa kplanhɛ amʋsʋ, mlɔ́yɔ nkpa ánɩ́ ɩtamatátɔ́. Ahá kpalobí pɛ́ tɛbɩ́ mʋ́. Támɛ nɩ́ mlɔtsʋn tɛ́ɩ́hɛ́ ámʋ́ʋ́ ɩbʋ atsʋ́nlɛ amʋsʋ á, mlɔ́yɔ ɔhɩkpá. Ahá tsɔtsɔɔtsɔ tɔ́tsʋn mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mlɩkɩ wankláán ahá ánɩ́ bʋtɔwá afunu bɛɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ bʋgyisʋ. Bʋtepina bwɛ ɩwɩ fɛ́ akúfa ba mlɩ wá, támɛ nkpatakuá bʋbʋ ɩyɩn bʋ́gyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amʋ́ bwɛhɛ́ mlɔ́pʋbɩ́ amʋ́. Bʋtamakpɔ́tɩ́ kankaba okplóto oyísʋ́, bʋtamakpɔ́tɩ́ tsɔkpʋn ɛ́ tʋnkpa ɩflasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Oyi wankláán toswíé abi wankláán. Oyi laláhɛ ɛ́ toswíé abi laláhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Oyi wankláán mɛ́ɛtalɩ́ swíé abi laláhɛ. Alɩ kɛ́n oyi laláhɛ ɛ́ mɛ́ɛtalɩ́ swíé abi wankláán nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oyíá ɩtamaswíé abi wankláán á, kún bʋtokun mʋ́ dá, wá mʋ́ ogyá. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mʋ́ alɩ sʋ á, ɔnɔ́sʋ́ atɔɩ́pʋ́ afunupʋ anfɩ bwɛhɛ́ mlɔ́pʋbɩ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Megyí ɔhagyíɔha ánɩ́ ɔtɛtɩ́ mɩ́ ɔbɛ́ɛ, ‘Mɩ́ Wíé, mɩ́ Wíé’ obówie Bulu iwíegyí ámʋtɔ. Mboún ɔhá ánɩ́ ɔtɔbwɛ́ mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ apɛ́ ɔbɔ́yɔ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bulu asʋ́n ogyíkɛ́ amʋ a, ahá tsɔtsɔɔtsɔ bɛ́fɩtɛ́ mɩ́ bɛɛ, ‘Mɩ́ Wíé, megyí fʋ́ dátɔ́ anɩlɛ́blɩ́ Bulu ɔnɔ́ asʋ́n, gya ɔŋɛ laláhɛ lɛ́ ahátɔ, bwɛ́ ofúla ɛ́ nɩ́?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɩnʋ nɛ́lɛ bláa amʋ́ mbɛ́ɛ, ‘Mmeyín mlɩ ɔkpagyíɔkpasʋ. Mlɩnatɩ tɛɩ mɩ́sʋ́, mlɩ lakpan abwɛpʋ́!’ ");
INSERT INTO nkoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mʋ́ sʋ ɔhagyíɔha ánɩ́ olonu mɩ́ asʋn blɩ́hɛ́ anfɩ, olegyi mʋ́sʋ́ á, ogyi fɛ́ ɔtɩansɩpʋ ɔkʋá oleyi mʋ obu dɩ́nká bʋtásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nyankpʋ lótswíe, ntsu lɔ́bʋlá wa mʋ́, atsufú lɔtsʋn wʋlɩ́ mʋ́sʋ́, támɛ imobwie. Tsúfɛ́ oleyi mʋ́ dɩ́nká bʋtásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Támɛ ɔhagyíɔha ánɩ́ olonu mɩ́ asʋn blɩ́hɛ́ anfɩ, omegyi mʋ́sʋ́ á, ogyi fɛ́ ɔha mimláhɛ ánɩ́ oleyi mʋ obu osublútɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nyankpʋ lótswíe, ntsu lɔ́bʋlá wá mʋ́, atsufú ɛ́ lɔtsʋn wʋlɩ́ mʋ́sʋ́. Obu ámʋ lobwie, ɩlɛda asɩ gbloo!” ");
INSERT INTO nkoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Brɛ́á Yesu lɛ́blɩ́ asʋ́n ánfɩ tá á, mʋ atosunáhɛ́ lɛha ɔnɔ́ lobwie ɔdɔm amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tsúfɛ́ olosuná amʋ́ atɔ́ túmisʋ. Omosuná mʋ́ fɛ́ Mose mbla asunápʋ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Brɛ́á Yesu lɛ́kplɩ́ tsú ɩbʋ ámʋsʋ á, ɔdɔm kpɔnkpɔɔnkpɔntɩ bobuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ɩnʋ á, ɩlɔ pɛpɛ ɔlɔpʋ́ ɔkʋ lɛ́ba bɛda akpawunu mʋ ayabitɔ, kókóli mʋ ɔbɛ́ɛ, “Owíé! Nɩ́ fótsulá á, fɛ́talɩ́ há mɩ́ ɩwɩ bɛ́plɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mʋ́ʋ́ Yesu lɛ́tɩnkɩ́ ɩbɩ da mʋ, bláa mʋ ɔbɛ́ɛ, “Natsúlá, fʋ́ ɩwɩ ɩplɩ́ɩ!” Ɩnʋnʋ mʋ ɩwɩ lɛ́plɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mʋ́ʋ́ Yesu lɛ́da mʋ ɔlá ɔbɛ́ɛ, “Mábla ɔhaa asʋ́n ánfɩ. Natɩ laa afʋpʋ fʋ́ ɩwɩ yosuná Bulu igyí ɔhapʋ́, afʋha mʋ ɩwɩgyʋrátɔ amʋ́ʋ́ Mose mbla losuná tsú ɩlɔ pɛpɛtsa ɩwɩ ámʋ. Igyi adánsɩɛ suna ahá ánɩ́ fʋ́ ɩwɩ laplɩ́ɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu lówie Kapernaum wúlutɔ. Romafɔ ɩsá akɔpʋ́ ɔhandɛ ɔkʋ lɛ́ba mʋ wá, bóbwií ɩpa há mʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Owíé, mɩ́ osúmpʋ́ dɛ́lɔ. Alasin tsukʋlɛ, ɔda wóyítɔ́ ɔdɛ ɩwɩɔsɩn wúun dʋbɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Nɛ́ba bɛtsa mʋ ɩlɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Támɛ ɔhandɛ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, mmɔfʋn ánɩ́ fɛ́ba mɩ́ wóyítɔ́. Fʋ́ mʋ́ blɩ asʋankʋ, ɩwɩ bɔ́wa mɩ́ osúmpʋ́ amʋ ɔnlɩn. Tsúfɛ́ mɩ́ ɛ́ mbʋ ahandɛ akʋ asɩ, ɩsá akɔpʋ́ akʋ ɛ́ bʋbʋ mɩ́ asɩ. Nɛlɛ́ ɔnɔ́ mbɛ́ɛ amʋ́tɔ́ ɔkʋ ɔnátɩ á, ɔtɛnátɩ́. Nɩ́ mbɛ́ɛ ɔbá ɛ́ á, ɔtɛba. Tógyítɔ́á nɛbláa mɩ́ osúmpʋ́ mbɛ́ɛ ɔbwɛ́ɛ á, ɔtɔbwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Brɛ́á Yesu lónu asʋ́n ánfɩ á, ɔnɔ́ lobwie mʋ, ɔlɛdamlí bláa ahá ámʋ́ʋ́ bʋbuo mʋ amʋ, ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, mmɔkʋ́wun ɔhá ánɩ́ ɔbʋ hógyi kpɔnkpɔntɩ ánfɩ odu Israelfɔtɔ kʋ́ráá kɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndɛ mlɩ bláa mbɛ́ɛ, “Ahá tsɔtsɔɔtsɔ bótsu owí ɔdalɩkpa pʋ́ owí ɔkplɩ́wíékpá ba, betsiá atɔ́ ogyíkpá Bulu iwíegyí ámʋtɔ, amʋ́a anɩ anáin Abraham, Isak pʋ́ Yakob aná bɔ́wa ɩbɩ gyi atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Támɛ bɛ́lɛ Israelfɔ ámʋ́ʋ́ tɛkɩ bʋgyi Bulu iwíegyí ámʋtɔ atsiápʋ́ amʋ lɛ́ ɩnʋ, tswɩ amʋ́ wá oklúntɔ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mʋ́ʋ́ ɔlɛlabláa ɩsá akɔpʋ́ ɔhandɛ amʋ ɔbɛ́ɛ, “Natɩ, ɩbá mʋ́tɔ́ ha fʋ fʋ́ hógyi ɔnɔ́.” Alɩ brɛ́ ámʋtɔ pɛ́pɛ́ɛ́pɛ́ osúmpʋ́ amʋ ɩwɩ lɔ́wa mʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu lɔ́yɔ Petro wóyítɔ́. Ɔlɔyɔ á, owísó lakɩ́tá Petro mʋ sia tsɩ́hɛ́, ɔda. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mʋ́ʋ́ ɔlɛyɛ́kɩtá ɔtsɩ ámʋ ɩbɩ. Ɩnʋnʋ owísó amʋ lɔ́kʋsʋ́ mʋsʋ, ɔlɔbwɛ Yesu afɔɔ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mʋ́ ntʋ́pwɛsʋ á, bɔpʋ ahá tsɔtsɔɔtsɔá ɔŋɛ laláhɛ dɛ́ amʋ́ háan ba Yesu. Ɔlɔtɔɩ́ gya ɔŋɛ laláhɛ amʋ, tsá alɔpʋ amʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɩ́nɩ lɛ́ha asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɛ́blɩ́ ámʋ lɛba mʋ́tɔ́. Ɔbɛ́ɛ, “Mʋlɛ́tsa anɩ ɩlɔ, tsú ipian kʋ́sʋ́ anɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu lówun ánɩ́ ɔdɔm babomlí mʋ, ɔlɛbláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha afa Galilea ɔpʋ yɔ mʋ́ ɔbɩn.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ɩnʋ Mose mbla osunápʋ́ ɔkʋ lɛ́bá mʋ wá, bɛbláa mʋ ɔbɛ́ɛ, “Osunápʋ́, nóbuo fʋ yɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á fɔ́yɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Awɩá bʋbʋ mbɔ́, mbubwi ɛ́ bʋbʋ asia, támɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mʋ́ mma ɔtɩ́nɛ́á nɔ́pʋ mɩ́ nwun tswɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ahá ámʋ́ʋ́ bʋbuo mʋ amʋtɔ ɔkʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, ha mɩ́ anyopulá mɩ́ sɩ́ asa ambobuo fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Támɛ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Bobuo mɩ, afʋsi awupʋ́ abʋpula amʋ́ afúli.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu lówie ɔklʋntɔ, mʋ akasɩ́pʋ́ amʋ ɛ́ bowie buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Brɛ́á bɔyɔ́ á, afú kpɔnkpɔɔnkpɔntɩ kʋ lɔ́wa tsʋ́ʋn bɩ. Mʋ́ sʋ ntsu dɛda wíé ɔklʋn amʋtɔ, ideklé ɩmɛ, támɛ Yesu mʋ́ da ɔdɛdɩdɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Akasɩ́pʋ́ amʋ betsinkí mʋ, bláa mʋ bɛɛ, “Anɩ Wíe lɛ anɩ. Anɩdɛ́ ntsu wie!” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ifú nya alɩ? Mlɩ hógyi mɔtsɔ́!” Ɩnʋ ɔlɔkʋsʋ́ lɛ́ ɔnɔ́ wa afú mʋ́a ntsu ámʋ, ɩnʋ fɛ́ɛ́ lɔlʋá. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ifú lɛhɩɛ kɩ́tá amʋ́, bɛfɩtɛ́ aba bɛɛ, “Nyankpʋsa ɔmɔmʋ nɩ, afú mʋ́a ntsu kʋ́ráá tonú mʋ ɔmɛ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Brɛ́á Yesu lówie Galilea ɔpʋ ɔbɩn, Gadarafɔ ɔsʋlʋ́sʋ á, ayin abanyɔ́ akʋá ɔŋɛ laláhɛ bʋ amʋ́tɔ́ bɛdalɩ tsu afúli opulákpá befia mʋ. Amʋ́ ɩyɩn sʋ ɔhaa tamatálɩ́ tsʋn ɔkpa ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɩnʋnʋ bɔkplʋ́n fɩtɛ́ Yesu bɛɛ, “Bulu mʋ Bi, amansʋ igyi? Fɛbá bɛpɩtɩ́ anɩ atɔ́ asa Bulu ɩsʋbɩtɩ́bɩ ɩfʋn?” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mprákuo tsɔtsɔɔtsɔ akʋ bʋdegyí ɩnʋ fʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mʋ́ sʋ ɔŋɛ laláhɛ amʋ bokokóli Yesu bɛɛ, “Nɩ́ fégya anɩ lɛ́ ahá ánfɩtɔ á, ha ayowie mprákuo ánfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ.” Ɩnʋnʋ bɛdalɩ ayin ámʋtɔ yówie mprákuo ámʋtɔ. Amʋ́ fɛ́ɛ́ bɛsrɩ́ kplɩ́ okúku kʋ wíé ɔpʋ amʋtɔ, wúwu. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mprákuo ámʋ akpapʋ́ bɛsrɩ́ yɔ́ wúlutɔ, yɛ́bláa ahá tógyítɔ́á ɩlaba ahá ámʋ́ʋ́ tɛkɩ ɔŋɛ laláhɛ bʋ amʋ́tɔ́ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mʋ́ sʋ wúlu amʋtɔ ahá fɛ́ɛ́ bɛdalɩ ba Yesu wá. Brɛ́á bowun mʋ a, bokokóli mʋ bɛɛ, ɔdálɩ amʋ́ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mʋ́ sʋ Yesu léyinkí wíé ɔklʋntɔ, fá ɔpʋ amʋ yɔ́ wúlu amʋ́ʋ́ otsie mʋ́tɔ́ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɩnʋ á, akʋ bɔsʋrá tsukʋlɛ osínpʋ akpasʋ ba mʋ. Brɛ́á Yesu lówun ánɩ́ bahɔ mʋ gyi a, ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, “Mɩ́ bí, klʋn ɩdɩ́ fʋ́ asɩ. Nasí fʋ́ lakpan kíé fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ɩnʋ Mose mbla asunápʋ́ akʋá bʋtsie ɩnʋ, bɛblɩ́ wá nwuntɔ bɛɛ, “Oyin ánfɩ labɔ́ mbusuo.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ɩ́nɩ odu gywɩɩ́n? ");
INSERT INTO nkoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mɔmʋ bɔ́wa ablɩ́lɛ́ dʋn? ‘Nasí fʋ́ lakpan kíé fʋ́.’ ntɛ́ɛ ‘Kʋsʋ tsu fʋ́ akpa afʋnatɩ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Támɛ ndekléá mlɩbɩ́ɩ ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mbʋ túmi ɔyɩ́ ánfɩtɔ sí ahá lakpan kíé amʋ́.” Ɩnʋ ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, “Ndɛ fʋ́ bláa mbɛ́ɛ, kʋsʋ. Tsu fʋ́ akpa afʋnatɩ yɔ wóyítɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɩnʋ ɔlɔkʋsʋ́ nátɩ́ yɔ́ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ɩ́nɩ lɔ́wa amʋ́ fɛ́ɛ́ wánwan, bɛkanfʋ́ Bulu ánɩ́ alapʋ́ túmiá igyi alɩ há anyánkpʋ́sa. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Brɛ́á Yesu lɔ́pʋ ɔyɔ́ á, olowun lampóo ɔhɔ́pʋ ɔkʋá bʋtɛtɩ́ mʋ Mateo tsie lampóo ɔhɔ́kpa. Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Bobuo mɩ.” Ɩnʋnʋ Mateo lɔ́kʋsʋ́ buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mateo lɛ́tɩ Yesu mʋa mʋ akasɩ́pʋ́ atɔ́ ogyíkpá mʋ wóyítɔ́. Lampóo ahɔ́pʋ pʋ́ lakpan abwɛpʋ́ tsɔtsɔɔtsɔ bɛba atɔ́ ámʋ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisifɔ ámʋ benya wun amʋ́ alɩ, bɛfɩtɛ́ mʋ akasɩ́pʋ́ amʋ bɛɛ, “Ntogyi sʋ́ mlɩ osunápʋ́ mʋa ahá ánfɩ odu bʋtɔwá ɩbɩ gyi atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu lónu asʋ́n ánfɩ, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Alɔpʋ léhián ɩlɔ ɔtsapʋ́, megyí ahá ánɩ́ ɩwɩ bʋ amʋ́ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mlɩyɔ amlɩyɛfɩtɛ́ Bulu asʋ́n ánfɩ bɔwanlɩ́n tswɩ anfɩ asɩ. Bɛɛ, ‘Nwewúun ntekle, megyí igyíha.’ Mmɛba aha wankláán ɔtɩkpá, lakpan abwɛpʋ́ ɔtɩkpá nɛba.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ɛkɛ ɔkʋ Asú Ɔbɔpʋ́ Yohane akasɩ́pʋ́ bɛba Yesu wá bɛfɩtɛ́ mʋ bɛɛ, “Ntogyi sʋ́ anɩa Farisifɔ anɩtɛklɩ́ ɔnɔ́, támɛ fʋ́ akasɩ́pʋ́ mʋ́ bʋtamaklɩ́ ɔnɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔtsɩ ɔkpaɩ́npʋ́ anyawíeá bʋbʋ mʋ wá bégyi awɩrɛhɔ? Ɛkɛkɛɛkɛ! Támɛ ɛkɛ kʋ bɛ́ba ánɩ́ bɛ́kpa ɔká otsiápʋ amʋ nátɩ́ sí amʋ́. Alɩ nkɛ ámʋtɔ bɛ́klɩ́ ɔnɔ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ɔhaa tamapʋ́ tati pɔpwɛ tan tati dada. Tsúfɛ́ tati pɔpwɛ amʋ bɛ́kpɩkpɩ́ɩ tsií dáda amʋ kʋ lɛ́, há ɔtánkpa ɩnʋ bɛ́latɛ́ɩ́ tsɩ́a. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Alɩ kɛ́n bʋtamapʋ́ nta pɔpwɛ wá ɔwʋlʋ́-kpákpá kɛntɛ wuhɛ́tɔ́ nɩ́. Nta pɔpwɛ amʋ ibófu fá kɛntɛ amʋ, tsítsá, ibéyintá kɛntɛ amʋ ɛ́. Ɩ́nɩ sʋ ɔwʋlʋ́-kpákpá kɛntɛ pɔpwɛtɔ bʋ́tɔpʋ́ nta pɔpwɛ wá, mɛ́nɩ mʋ́ anyɔ ámʋ fɛ́ɛ́ bétsiá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Brɛ́á Yesu dɛ́tɔɩ́ á, Yudafɔ ofíakpa ɔhandɛ ɔkʋ lɛ́ba bɛda akpawunu mʋ ayabitɔ, kókóli mʋ ɔbɛ́ɛ, “Mɩ́ bí tsɩ́hɛ́ lawú sésééséi, támɛ ba afʋbɔpʋ ɩbɩ dɩnka mʋsʋ onya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mʋ́ sʋ Yesu lɔ́kʋsʋ́, mʋa mʋ akasɩ́pʋ́ bobuo ɔhandɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ɔtsɩ ɔkʋá obugya dɛ mʋ wʋlɩ́ nfí dúanyɔ nɩ́ lɔ́tsʋn yɔ Yesu ɔma, pʋ́ ɩbɩ da mʋ tati osiebí. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsúfɛ́ ɔlɛblɩ́ wá mʋ nwuntɔ ɔbɛ́ɛ, “Nɩ́ nɔpʋ́ ɩbɩ da mʋ tati kpán á, ɩlɔ bési mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu lɛ́damlí kɩ mʋ, bláa mʋ ɔbɛ́ɛ, “Mɩ́ bí, klʋn ɩdɩ́ fʋ́ asɩ. Fʋ́ hógyi latsá fʋ́ ɩlɔ.” Ɩnʋnʋ ɔtsɩ ámʋ ɩwɩ lɔ́wa mʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Brɛ́á olowie ɔhandɛ amʋ wóyítɔ́ a, olowun ɩkpɛ afʋlɩ́pʋ́, nú awɩrɛhɔ agyípʋ́ amʋ okitikíti. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Olegya amʋ́ ɔbɛ́ɛ, “Mlɩdalɩ nfɩ! Otsibi amʋ mɔ́kʋ́wú, dɩdɩ́ ɔdɛ.” Ahá ámʋ bɔmɔsɩ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Brɛ́á amʋ́ fɛ́ɛ́ bɛdalɩ ba wunsɩnɛ́sʋ́ a, Yesu lébitíwíé obu ámʋ́ʋ́ otsibi amʋ da mʋ́tɔ́ ámʋtɔ yɛ́kɩtá mʋ ɩbɩ, ɔlɔkʋsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Asʋ́n ánfɩ lɛ́klɛɩ́ wá ɔmá ámʋtɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu lɛ́dalɩ ɔyɔ́ á, ansibi abwiepʋ́ abanyɔ́ akʋ bobuo mʋ, bʋdɛ okitikíti sʋrá kpólí mʋ bɛɛ, “Owíe Dawid mʋ na, wun anɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Brɛ́á olowie wóyítɔ́ a, ansibi abwiepʋ́ ámʋ bɛba mʋ wá. Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩlahogyi mlɩaa, nɛ́talɩ́ há mlɩ ansíbi bóbwií?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩ Wíé, Ee!” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mʋ́ʋ́ ɔlɔpʋ ɩbɩ dada amʋ́ ansíbi, bláa amʋ́ ɔbɛ́ɛ, “Ɩbá mʋ́tɔ́ ha mlɩ, mlɩ hógyi ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɩnʋ bɔwa atɔ́ wun bɩ. Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, bʋmábláa ɔhaa. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Támɛ brɛ́á bɛdalɩ bɔyɔ́ á, bɛda mʋ ɔkan ɔmá ámʋ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Benya nátɩ́ alɩ, bɔpʋ oyin ɔkʋá ɔŋɛ laláhɛ bʋ mʋtɔ, sʋ alatɔ́ omúmu ba Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Olenya gya ɔŋɛ laláhɛ amʋ lɛ́ oyin ámʋtɔ alɩ, ɔlɔwa tɔɩ́ bɩ. Ahá ámʋ fɛ́ɛ́ bowun, sʋ ɔnɔ́ lobwie amʋ́. Mʋ́ sʋ bɛblɩ́ bɛɛ, “Anɩmɔ́kʋ́wun ɩ́nɩ odu Israelfɔtɔ kɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farisifɔ ámʋ bɛblɩ́ bɛɛ, “Ɔŋɛ laláhɛ owíe túmi ɔdɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu léki awúlu pʋ́ nkuda fɛ́ɛ́ asɩ, súná atɔ́ Yudafɔ ofíakpa. Ɔlɛda Bulu iwíegyí ámʋ ɩwɩ asʋn wankláán ɔkan. Ɔlɛtsa ɩlɔ kugyíkʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Brɛ́á olowun ɔdɔm amʋ a, amʋ́ asʋ́n lɔ́wa mʋ nwɛ. Bʋgyi fɛ́ akúfa ánɩ́ bʋma ɔkpapʋ́, tsúfɛ́ asʋ́n dɛ amʋ́ háan, bʋma tɔtɔ bwɛtɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mʋ́ sʋ ɔlɛbláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Atɔ kpɔtɩ́hɛ́ amʋ ɩtsɔ, támɛ mʋ́ akpɔtɩ́pʋ́ bʋmɔtsɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mʋ́ sʋ mlɩkokoli ndɔ mʋ wie, ɔwa atɔ́ akpɔtɩ́pʋ́ tsɔtsɔ abʋba bɔkpɔtɩ́ atɔ́ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu lɛ́tɩ mʋ akasɩ́pʋ́ dúanyɔ ámʋ, ɔlɛha amʋ́ túmi ánɩ́ bʋgyíi ɔŋɛ laláhɛsʋ. Bʋgyáa amʋ́ lɛ́ ahátɔ, abʋtsa ɩlɔ mʋ́a ɩwɩɔsɩn kugyíkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sumbí ayɔpʋ́ dúanyɔ ámʋ adá nɩ́: Ogyankpapʋ gyí Simon ánɩ́ bʋtɛtɩ́ mʋ Petro mʋa mʋ pio Andrea. Yakobo mʋa mʋ pio Yohane ánɩ́ bʋgyi Sebedeo abí; ");
INSERT INTO nkoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, Bartolomeo, Toma, lampóo ɔhɔ́pʋ Mateo, Alfeo mʋ bi Yakobo, Tadeo, ");
INSERT INTO nkoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ánɩ́ ogyi ɩwɩsʋtsiá adunkápʋ́ ɔpasuatɔ ɔha pʋ́ Yuda Iskariot ánɩ́ ɔlɛlɛ Yesu há. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɔlɔwa sumbí ayɔpʋ́ dúanyɔ ámʋ sɩ́sɩ́, wá mbla há amʋ́ ɔbɛ́ɛ, “Mlɩmáyɔ ahá ánɩ́ bʋmegyí Yudafɔ ɔsʋlʋ́ʋ pʋ́ Samariafɔ awúlu kʋkʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mboún mlɩyɔ Israelfɔ wá. Bʋgyi fɛ́ akúfa ánɩ́ bafwɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɩ́ mlɔyɔ́ á, mlɩda asʋ́n ámʋ ɔkan mlɩaa, ‘Bulu iwíegyí amʋ lawíé wóyí tá.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mlɩtsa ɩlɔ, amlɩtsinki afúli. Mlɩtsa ɩlɔ pɛpɛ alɔpʋ́, amlɩgya ɔŋɛ laláhɛ lɛ ahátɔ. Mlɩmáhɔ amʋ́ tɔtɔ. Mlɩbwɛ mʋ́ pʋkie amʋ́, fɛ́ alɩá napʋ́kíé mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mlɩmátsu sika kʋkʋʋkʋ wá mlɩ akɛntɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mlɩmátsu akpankogyo ánɩ́ mlɔ́pʋ atɔ́ wá mʋ́tɔ́ há ɔkpa ámʋ tu. Mlɩmátsu atadɩɛ nyɔɔsɩ, ntʋkʋta pʋ́ oyi yiáhɛ́. Tsúfɛ́ agyʋ́má ɔyɔpʋ́ bʋtɛhá atogyihɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nɩ́ mlɔyɔ́swɩɩ́ wúlu kugyíkʋsʋ á, mlɩdunka ɔha wankláán, amlɩswɩɩ mʋ wá. Mlɩtsia ɩnʋ kpɛfʋn ɛkɛá mlɛ́natɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Nɩ́ mlowíé wóyítɔ́ ɩnʋ á, mlɩha amʋ́ itsiá mlɩaa, ‘Bulu ɔhá mlɩ iwilwii.’ Nɩ́ wóyí ámʋtɔfɔ bɔhɔ mlɩ á, mlɩ oyúla amʋ isín amʋ́sʋ́. Támɛ nɩ́ bʋmɔhɔ mlɩ á, mʋ́mʋ́ mlɩ oyúla amʋ ɩsánki ba mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɩ́ bʋmɔhɔ mlɩ, ntɛ́ɛ nú mlɩ asʋ́n á, mlɩdalɩ wóyí ntɛ́ɛ wúlu amʋtɔ, amlɩkpakpa mlɩ ayabitɔ-ɩsɩ wʋlɩ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́bɩtɩ́ amʋ́ ɩsʋ dʋn Sodom mʋ́a Gomorafɔ mʋ asʋ́n ogyíkɛ́ amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ɔlɛtrá bláa amʋ́ ɔbɛ́ɛ, “Mlɩbɩ ánɩ́ ndɛ mlɩ wa fɛ́ akúfa ánɩ́ bɔyɔ́ nkpatakutɔ. Mlɩfwifwi ansɩ́ fɛ́ awɔ, amlɩha mlɩ ɩwɩ ɩtɩn fɛ́ abrɔ́dʋma. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mlɩkɩ mlɩ ɩwɩ wankláán anyánkpʋ́sasʋ. Tsúfɛ́ bɛ́kɩtá mlɩ ya asʋ́n ogyíkpá, nwɛ́n mlɩ atɔ́ amʋ́ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mɩ́ sʋ bɛ́kpa mlɩ ya ɔmásʋ́ agyípʋ́ pʋ́ awíe ansɩ́tɔ́, mɛ́nɩ mlégyi mɩ́ ɩwɩ adánsɩɛ súná amʋ́a ɔmátɔ́fɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nɩ́ bɛkɩ́tá mlɩ ya a, mlɩmágywɩ́ɩn asʋ́n ánɩ́ mlɛ́blɩ́ pʋ́ alɩá mlɛ́lɛ mʋ́ ɔnɔ́. Bɔ́pʋ asʋ́n ánɩ́ mlɛ́blɩ́ brɛ́ ámʋtɔ wá mlɩ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tsúfɛ́ megyí mlɩ ɔbɔ́tɔɩ́. Mlɩ Sɩ́ Ɔŋɛ́ ámʋ ɔbɔ́tɔɩ́ tsʋn mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Apíó bɛ́lɛ amʋ́ apíó há lowu. Abí asɩ́ bɛ́lɛ amʋ́ abí há. Abí ɛ́ bɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ akwɩɩ́pʋ́sʋ, há bɔ́mɔ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɩ́ sʋ ahá fɛ́ɛ́ bólu mlɩ, támɛ nɩ́ mlɛ́talɩ́ wá klʋn lɩ́ɩ́ kínkíínkín yɔ́fʋn mʋ́ ɔnɔ́mɔ á, Bulu ɔbɔ́hɔ mlɩ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nɩ́ bʋdɩn mlɩsʋ wúlu kʋtɔ á, mlɩsrɩ yɔ wúlu bámbátɔ́. Ɔnɔkwalɩ ndɛ mlɩ bláa. Mlɩméeki Israel awúlu amʋ fɛ́ɛ́sʋ́ tá asa mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ néyinkí ba. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Okasɩ́pʋ́ tamadʋn mʋ osunápʋ́. Osúmpʋ́ ɛ́ tamadʋn mʋ wie. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ɩbɔ́wa alɛ́ nɩ́ ɔkasɩ́pʋ́ ɔbɔ́bwɛ fɛ́ mʋ osunápʋ́, osúmpʋ́ ɛ́ ɔbɔ́bwɛ fɛ́ mʋ wie. Nɩ́ batálɩ́ bʋdɛ wóyí mʋ wie amʋ tɩ bɛɛ, ‘Ɔbʋnsám’ ntɛ́ɛ ‘Beelsebul’ a, mʋ́mʋ́ ɩda laláhɛ mɔmʋ bʋmɔ́ɔpʋtɩ́ mʋ wóyítɔ́ atsiápʋ́ mʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Támɛ mlɩmánya ifú. Tɔtɔ má ɩnʋá babun atɔ́ mʋ́sʋ́ ánɩ́ bʋmóobwií mʋ́sʋ́. Tógyítɔ́ ɛ́ ma ɩnʋá ileŋaín ánɩ́ ɩmɛ́ɛlɩn ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nɩ́ nɛlɛ́ atɔ́ súná mlɩ onyé á, mlɩkplʋn blɩ mʋ́ ɔpa. Mlɩda asʋ́n ánɩ́ nɛ́bláa mlɩ nklobítɔ ɛ́ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mlɩmánya nyankpʋsa ifú. Ɔbɛ́talɩ́ mɔ́ mlɩ ɔyʋlʋ́ʋ, támɛ ɔmɛ́ɛtalɩ́ mɔ́ mlɩ ɔkláa. Mboún ɔhá ánɩ́ mlɩnyá ifú gyí Bulu. Mʋ ɔbɛ́talɩ́ yíntá ɔyʋlʋ́ʋ mʋ́a ɔkláa amʋ fɛ́ɛ́ ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Megyí káplɛ bʋtɛfɛ́ akénsire anyɔ kɛ́kɛ́? Támɛ amʋ́tɔ́ ɔkʋkʋ tamakpádá ɔsʋlʋ́tɔ ánɩ́ mlɩ Sɩ́ ámʋ méyín mʋ́ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tsúfɛ́ Bulu yin mlɩ nwunsʋ-imi kʋ́ráá klátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mʋ́ sʋ mlɩmánya ifú, tsúfɛ́ mlɩbʋ ibíá dʋn akénsire tsɔtsɔɔtsɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nɩ́ ɔkʋ lɛ́talɩ́ gyi mɩ́ ɩwɩ adánsɩɛ ahátɔ á, mɩ́ ɛ́ négyi mʋ ɩwɩ adánsɩɛ súná mɩ́ Sɩ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Támɛ nɩ́ ɔkʋ lékiná mɩ́ ahátɔ á, mɩ́ ɛ́ nékiná mʋ mɩ́ Sɩ́ ansɩ́tɔ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ɩmábwɛ mlɩ fɛ́ iwilwii nɔpʋba ɔsʋlʋ́ʋ anfɩsʋ. Megyí iwilwii, mboún ɔdayí ɩya anyɔ nɔpʋba. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tsúfɛ́ abi yinhɛ́ mʋ́a amʋ́ asɩ́ nsɩnɛ́ béyintá. Abi tsɩhɛ́ mʋ́a amʋ́ ayín ɛ́ nsɩnɛ́ béyintá. Osia tsɩhɛ́ mʋ́a mʋ sia tsɩ́hɛ́nyɔ ɛ́ nsɩnɛ́ béyintá. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɔha alupʋ́ bótsu mʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ɔhá ánɩ́ ɔtɔdwɛ́ mʋ sɩ ntɛ́ɛ mʋ yin dʋn mɩ mɔ́fʋn ánɩ́ ɔbɔ́bwɛ mɩ́ ɔkasɩ́pʋ́. Ɔhá ánɩ́ ɔtɔdwɛ́ mʋ bi tsɩ́hɛ́, ntɛ́ɛ mʋ bi yínhɛ́ dʋn mɩ ɛ́ mɔ́fʋn ánɩ́ ɔbɔ́bwɛ mɩ́ ɔkasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɔhá ánɩ́ omotsu mʋ oyikpalíhɛ bobuo mɩ ɛ́ mɔ́fʋn ánɩ́ ɔbɔ́bwɛ mɩ́ ɔkasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɩ́ ɔkʋ lɛ́prɩ mʋ nkpa á, ɔbɔ́hʋlɩ́ɩ mʋ́. Nɩ́ ɔkʋ ɛ́ lɔ́hʋlɩ́ɩ mʋ nkpa mɩ́ sʋ á, obénya mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ɔhá ánɩ́ ɔlɔhɔ mlɩ lahɔ mɩ. Nɩ́ ɔkʋ lɔ́hɔ mɩ ɛ́ á, alahɔ mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɩ́ fɔhɔ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔfɔɔ́ á, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ oyúla fénya. Ɔhá ánɩ́ ɔlɔhɔ yilé ɔbwɛpʋ́ ɛ́ ɔfɔɔ́ obénya yilé ɔbwɛpʋ́ oyúla. ");
INSERT INTO nkoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ ɔlɛha mɩ́ akasɩ́pʋ́tɔ ɔkʋsʋ kʋ́ráá ntsu-owebi ɔbɔ olonu a, ɔmɔ́ɔhʋlɩ́ɩ mʋ ɩpán.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Brɛ́á Yesu lɔ́pʋ agyʋ́má ánfɩ wá mʋ akasɩ́pʋ́ dúanyɔ ámʋ ɩbɩtɔ tá á, ɔlɔyɔ yéki Galilea awúlusʋ, súná ahá atɔ́, dá asʋ́n ámʋ ɛ́ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Asú Ɔbɔpʋ́ Yohane da obu, olonu Kristo bwɛhɛ́. Mʋ́ sʋ ɔlɔwa mʋ akasɩ́pʋ́ abanyɔ́ sɩ́sɩ́ Yesu ɔbɛ́ɛ, bʋyɛ́fɩtɛ́ mʋ bɛɛ, “Fʋ́gyí ɔhá ámʋ́ʋ́ ɔbɛ́ba amʋ nɩ, ntɛ́ɛ akɩ́ɩ ɔha bambá ɔkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩyinki yɛbláa Yohane asʋ́n ánɩ́ mlɩlabonu pʋ́ atɔ́á mlɩlabowun. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mlɩlabowun ánɩ́ ansibi abwiepʋ́ bʋdɛ atɔ́ wun, abɔ bʋna. Ɩlɔ pɛpɛ alɔpʋ́ ɩwɩ dɛplɩ́ɩ. Ɩsʋ atínpʋ bʋdɛ asʋ́n nu. Afúli bʋdetsinkí, ahiánfɔ ɛ́ bʋdɛ asʋn wankláán ámʋ nu. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bulu obóyulá ɔhá ánɩ́ mɩ́ bwɛhɛ́ mɔkʋsʋ́ lɩ́ɩ́ mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Brɛ́á Yohane akasɩ́pʋ́ ámʋ beyinkí bɔyɔ́ á, Yesu lɔ́wa tɔɩ́ tsú Yohane ɩwɩ súná ɔdɔm amʋ bɩ. Ɔbɛ́ɛ, “Brɛ́á mlɩlɛ́dalɩ yɔ dimbísʋ́ ɩnʋ á, ntɔ ɔkɩ́kpa mlɩlɔ́yɔ? Fɩtáa ánɩ́ afú dɛ mʋ́ tsʋ́ʋn lóó? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nɩ́ megyí mʋ́ á, ntɔ kóún ɔkɩ́kpa mlɩlɔ́yɔ? Ɔhá ánɩ́ ɔdɩdɩ́ ntsrim? Ɛkɛkɛɛkɛ! Awíe wóyí atati ámʋ odu adɩdápʋ́ bʋtetsíá. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mlɩbla mɩ! Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ mlɩlɛ́dalɩ yɛ́kɩ? Ee, Yohane nɩ. Ɔdʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mʋ ɩwɩ asʋ́n Bulu lɛ́blɩ́ bɔwanlɩ́n mʋ́ tswɩ bɛɛ, ‘Kɩ, ndɛ obí wa gya fʋ nkpá. Mʋ ɔbɛ́la ɔkpa há fʋ́ nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, ɔhagyíɔha ánɩ́ ɔha tsɩhɛ́ lakɛn kwɩɩ́ mɔ́fʋn Asú Ɔbɔpʋ́ Yohane, támɛ mʋ ɛ́ ɔmɔfʋn Bulu iwíegyí ámʋtɔ ɔkʋsʋ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tsú Yohane brɛ́sʋ́ bɔtʋ ndɛ á, ahá bʋdɛ Bulu iwíegyí ámʋ prɩ́ɩ ɔwʋnlɩ́nsʋ́. Awʋnlɩ́npʋ́ bʋdɛ mʋ́ prɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tsúfɛ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ pʋ́ Mose Mbla ámʋ bɔfʋn Yohanesʋ fɛ́ɛ́ bɔtɔɩ́ tsú Bulu iwíegyí ámʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nɩ́ mlɔ́hɔ asʋ́n ámʋ gyi a, mʋ́mʋ́ mlɛ́bɩ ánɩ́ mʋgyí Elia. Mʋ ɔbɛ́ba nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɔhá ánɩ́ ɔbʋ asʋ onúu. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Séi ánfɩ á, amɛndɩ nɔ́pʋ ndɛmba-abí ánfɩ kápʋ́? Bʋgyi fɛ́ nyebíá bʋtsie dɩnsʋ bʋdɛ aba kpolí, ");
INSERT INTO nkoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","blɩ́ bɛɛ, ‘Anɩlapléí ansigyísʋ́, mlɩmɛ́tsa. Mʋ́ sʋ anɩlalá wá awɩrɛhɔ ɩlʋ, támɛ mlɩmósu.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mlɩgyí fɛ́ nyebí ánfɩ, tsúfɛ́ Yohane lɛ́ba á, oletsiá klɩ́ ɔnɔ́, omonu ntá, támɛ mlɩaa, ‘Ɔŋɛ laláhɛ bʋ mʋtɔ!’ ");
INSERT INTO nkoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Támɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mʋ́ naba ndɛ atɔ́ gyí, ndɛ ntá núu. Mʋ́ ɛ́ mlɩaa, ‘Mlɩkɩ opotsuapʋ pʋ́ nta ɔbʋpʋ́, lakpan abwɛpʋ́ pʋ́ lampóo ahɔ́pʋ onyawíe.’ Támɛ Bulu ɔha tsiátɔ́ tɛlɛ́ mʋ nyánsa ɔwan.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu lɔ́pʋ ɔblɔ́ tɔ́ɩ́ tsú awúlu akʋ ɩwɩ. Awúlu amʋá ɔlɔbwɛ ofúla akpɔnkpɔntɩ mʋ́tɔ́, támɛ bʋmɛdamlí klʋntɔ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɔbɛ́ɛ, “Korasinfɔ, mlɩgyɔwɩ. Betsaidafɔ, mlɩgyɔwɩ nɩ́. Nɩ́ Tiro pʋ́ Sidon awúlu laláhɛ amʋtɔ nɔbwɛ ofúla akpɔnkpɔntɩ ánfɩ nɔbwɛ mlɩtɔ á, tɛkɩ bɛdamlí klʋntɔ dodoodo. Tɛkɩ bʋda akpekpetɔ, bakpá nsúó wá nwuntɔ pʋ́súná ánɩ́ badámlí klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mlɩbɩ ánɩ́ Bulu ɔbɛ́bɩtɩ́ mlɩ ɩsʋ mʋ asʋ́n ogyíkɛ́ dʋn Tiro mʋ́a Sidonfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mlɩ Kapernaumfɔ, mlɩdéklé mlɩaa mlótsu ɩwɩ fʋ́á alɩɩ yɔ́wɔ ɔsʋ́sʋ́? Ɛkɛkɛɛkɛ! Bulu ɔbɛ́ba mlɩ asɩ yówie afúlitɔ. Tsúfɛ́ nɩ́ Sodom wúlutɔ nɔbwɛ ofúla akpɔnkpɔntɩ ánfɩ odu á, tɛkɩ wúlu amʋ ɩtráa bʋ ɩnʋ bɔtʋ ndɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mlɩkaɩn ánɩ́ Bulu obówun Sodomfɔ nwɛ asʋ́n ogyíkɛ́ amʋ dʋn mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Alɩ brɛ́ ámʋtɔ á, Yesu lɔ́bɔ mpáɩ blɩ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́, ɔsʋ́ mʋa asɩ Owíé! Nɛdá fʋ́ ɩpán ánɩ́ falɛ́ tɔ́á fɔpʋŋáín anyansapʋ pʋ́ asʋ́n abɩpʋ́ ɔwan súná ahá ánɩ́ bʋmeyín ɔlala, bʋgyi fɛ́ nyebí. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Mɩ́ Sɩ́! Alɩ́ fʋdeklé fɛɛ ɩbá mʋ́tɔ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mɩ́ Sɩ́ lɔ́pʋ tógyítɔ́ wá mɩ́ ɩbɩtɔ. Ɔhaa méyín Obí ámʋ, nkɛ́tɩ Ɔsɩ́ ámʋ nkʋlɛ. Ɔhaa méyín Ɔsɩ́ ámʋ ɛ́, nkɛ́tɩ Obí ámʋ pʋ́ ɔhá ánɩ́ Obí ámʋ latsúlá ánɩ́ ɔbɛ́lɛ mʋ súná mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mlɩba mɩ́ wá, mlɩ ahá ánɩ́ ɩlapíán mlɩ, mlɩ atɔ sʋráhɛ́ dɛ mlɩ dʋ́ʋn. Nɛ́ha mlɛ́da ɔkpʋ́nʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mlɩba ɩwɩasɩ ha mɩ, amlɩsuan mɩ, tsúfɛ́ nɛba ɩwɩasɩ, nolwií, mɛ́nɩ mlénya iwilwii. ");
INSERT INTO nkoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tsúfɛ́ mɩ́ wá tsiá bʋ atsiálɛ́. Mɩ́ atɔ sʋráhɛ́ ɛ́ mɔ́ɔdʋn mlɩ sʋrá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yesu mʋa mʋ akasɩ́pʋ́ bɔtsʋn ayó ndɔ kʋtɔ ɔkpʋ́nʋ́ ɔdakɛ́. Akʋ́n dɛ akasɩ́pʋ́ amʋ, sʋ bɔpʋsáa ayó ámʋ kʋ wɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisifɔ akʋ bowun amʋ́, bɛbláa Yesu bɛɛ, “Kɩ, fʋ́ akasɩ́pʋ́ amʋ bʋdɛ tɔ́á mbla mɛha ɔkpa bwɛ ɔkpʋ́nʋ́ ɔdakɛ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩmɔ́kʋ́kla nu tɔ́á Owíe Dawid lɔ́bwɛ brɛ́á akʋ́n dɛ mʋa mʋ abúopʋ kɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Olebitíwíé Bulu osúmkpa yótsu bodobodoá bapʋ́há Bulu igyí ba, mʋa mʋ abúopʋ amʋ begyi. Bulu igyí ahapʋ́ nkʋlɛ bɛha ɔkpa, bʋtegyi alɩ bodobodo amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mlɩlakla Mose Mbla, nú ánɩ́ Bulu igyí ahapʋ́ ámʋ bʋtɔyɔ́ agyʋ́má Bulu ɔtswɛ́kpa ɩnʋ ɔkpʋ́nʋ́ ɔdakɛ́, támɛ bʋtamahá amʋ́ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ndɛ mlɩ bláa mbɛ́ɛ, ɔhá ánɩ́ ɔdʋn Bulu ɔtswɛ́kpa amʋ bʋ́ʋ nfɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bulu asʋ́n lɛblɩ́ ɔbɛ́ɛ, ‘Nwewúun ntekle, megyí igyíha.’ Nɩ́ mlɩyin mʋ́ asɩ á, tɛkɩ mlɩmɛ́ɛha ahá ánfɩ amʋ́ asʋ́n da ɔkpa ánfɩ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ gyí ɔkpʋ́nʋ́ ɔdakɛ́ mʋ wie nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu lɛ́natɩ́ ɩnʋ, ɔlɔyɔ Yudafɔ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Olowun oyin ɔkʋá mʋ ɩbɩ kʋlɛ lawú ɩnʋ. Farisifɔ ámʋ bʋdɛ Yesu tɛ́ɛ. Mʋ́ sʋ bɛfɩtɛ́ mʋ bɛɛ, “Mbla lɛha ɔkpa ánɩ́ bʋtsáa ɩlɔ ɔkpʋ́nʋ́ ɔdakɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɩtɔ ɔkʋ bʋ kufa, alakpádá wíé ibúntɔ́ ɔkpʋ́nʋ́ ɔdakɛ́ á, ɔmɛ́ɛlɛ mʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yɛ́ɛ nyankpʋsa bʋ labi dʋn kufa a? Mʋ́ sʋ mbla lɛha ɔkpa ánɩ́ ɔha ɔbɔ́bwɛ yilé ɔkpʋ́nʋ́ ɔdakɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mʋ́ʋ́ ɔlɛbláa oyin ámʋ́ʋ́ mʋ ɩbɩ lawú ámʋ ɔbɛ́ɛ, “Tɩnkɩ fʋ́ ɩbɩ amʋ.” Olenya tɩ́nkɩ́ mʋ́ alɩ pɛ́, ɔŋɛ́ lowie mʋ́tɔ́ fɛ́ nyɔɔsɩ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Támɛ mʋ́ ó á, Farisifɔ ámʋ bɛdalɩ yɛ́kɩtá agywɩɩn alɩá bɔ́bwɛ bɔ́mɔ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛnatɩ́ ɩnʋ. Ɔdɔm bobuo mʋ, ɔlɛtsa amʋ́tɔ́ alɔpʋ fɛ́ɛ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mʋ́ʋ́ ɔlɛda amʋ́ ɔlá ɔbɛ́ɛ, bʋmáha ahá abʋbɩ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɩ́nɩ lɛ́ha asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia lɛ́blɩ́ yáɩ́ ámʋ lɛ́ba mʋ́tɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ɔbɛ́ɛ, “Kɩ, mɩ́ osúmpʋ́á nalɛ́ nɩ́. Ntɔdwɛ́ mʋ, mɩ ansɩ́ tegyi mʋ ɩwɩ. Nɔ́pʋ mɩ́ Ɔŋɛ Wankɩ́hɛ́ wá mʋtɔ. Ɔbɛ́bláa ɔmátɔ́fɔ ɔbɛ́ɛ, ‘négyi amʋ́ asʋ́n ɔnɔkwalɩsʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Oméegyi nwɛ́ɛn, ɔmɔ́ɔkplʋ́n. Ɔhaa móonu mʋ ɔnɔ́ brɔnʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Obénya klʋn há ahá ánɩ́ amʋ́ hógyi ɔnɔ́ ma ɔnlɩn, bábwɛ́ fɛ́ oyíá ɩlatá bia tá. Ɔbɔ́wa awɩtɔlɛ há ahá ánɩ́ bʋma ɔwʋnlɩ́n, bábwɛ́ fɛ́ ɔkandɩ́ɛá nfɔ latá mʋ́tɔ́, yɔ́fʋn brɛ́á bɛ́bɩ ánɩ́ ntegyi asʋ́n ɔnɔkwalɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ahá ánɩ́ bʋmegyí Yudafɔ bɔ́pʋ ansɩ́ dɩ́nká mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɩnʋ bɔpʋ oyin ɔkʋ ba Yesu, ɔŋɛ laláhɛ bʋ mʋtɔ. Mʋ́ sʋ ɩlɛha mʋ ansíbi lobwie; álatɔ́ omúmu ɛ́. Yesu lɛ́tsa mʋ ɩlɔ, ɔdɛ atɔ́ wúun, ɔdɛtɔɩ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɔnɔ́ lobwie ahá ámʋ fɛ́ɛ́, bɛfɩtɛ́ bɛɛ, “Megyí Dawid mʋ na ámʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Támɛ Farisifɔ ámʋ bonu asʋ́n ánfɩ á, bɛblɩ́ bɛɛ, “Ɔŋɛ laláhɛ owíe Beelsebul túmi ɔ́dɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Iwíe ogyíkpá ánɩ́ ɩlaye anyɔ, bʋdɛ aba kɔ bɛ́dɩda. Alɩ kɛ́n wúlu ntɛ́ɛ wóyí oduá mʋ́tɔ́ atsiápʋ́ bʋdɛ aba kɔ ɛ́ itobwíé nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mʋ́ sʋ nɩ́ Ɔbʋnsám dɛ́ mʋ ɩwɩ gyáa a, mʋ iwíegyí bɛ́dɩda. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nɩ́ Beelsebul túmi ndɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ á, mʋ́mʋ́ ma túmi mlɩ abí ɛ́ bʋdɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ? Mlɩ abí ámʋ onutó obégyi mlɩ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Támɛ ɩ́nɩá Bulu Ɔŋɛ́ ndɛpʋgya ɔŋɛ laláhɛ sʋ á, mlɩbɩ ánɩ́ Bulu iwíegyí ámʋ laba mlɩ wá dodo.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ɔhaa mɛ́ɛtalɩ́ wíé ɔwʋnlɩ́npʋ́ wóyítɔ́ yɔ́kʋlá mʋ atɔ́, nkɛ́tɩ alagyankpá kɩ́klɩ mʋ tswɩ, asa ɔbɛ́talɩ́ kʋ́lá mʋ atɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɔhá ánɩ́ omobuo mɩ dɛ́ mɩ́ lu. Ɔhá ánɩ́ ɔmɛdɛ́ mɩ́ tsa akpa ahá ba Bulu ɛ́ dɛ́ amʋ́ gyáa tɛɩ́a mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ɩ́nɩ sʋ ndɛ mlɩ bláa mbɛ́ɛ, Bulu obési ahá lakpan pʋ́ abususʋ kugyíkʋ kíé amʋ́. Támɛ nɩ́ ɔkʋ ɔblɩ́ Ɔŋɛ Wankɩ́hɛ́ amʋ ɩwɩ abususʋ a, Bulu méesikíé mʋ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nɩ́ ɔkʋ lɛ́blɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ ɩwɩ asʋn laláhɛ a, Bulu ɔbɛ́talɩ́ sikíé mʋ. Támɛ nɩ́ ɔkʋ lɛ́blɩ́ Ɔŋɛ Wankɩ́hɛ́ amʋ ɩwɩ asʋn laláhɛ mʋ́ á, Bulu méesikíé ɔhá ámʋ ndɛ ɔyɩ kɛhɛ, ntɛ́ɛ brɛ́ ámʋ́ʋ́ ɩbá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Oyí abí bʋtɔpʋ́bɩ́ mʋ́. Oyi wankláán toswíé abi wankláán. Oyi laláhɛ ɛ́ toswíé abi laláhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mlɩ awɔ abí-aná! Nkálɩ mlɩ aha laláhɛ mlɛ́talɩ́ blɩ́ asʋn wankláán? Tsúfɛ́ tɔ́á ɩdʋn ɔha klʋn a, mʋ́tɛ́dálɩ tsu mʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɔha wankláán tɛblɩ́ asʋn wankláán tsú mʋ klʋntɔ, ɔha laláhɛ ɛ́ tɛblɩ́ asʋn laláhɛ tsú mʋ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ndɛ mlɩ bláa mbɛ́ɛ, ɔhagyíɔha ɔbɛ́lɛ asʋn laláhɛ kugyíkʋá ɔlɛblɩ́ ɔnɔ́ Bulu asʋ́n ogyíkɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsúfɛ́ ɔha asʋn blɩ́hɛ́ Bulu ɔbɔ́pʋhá mʋ asʋ ntɛ́ɛ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mʋ́ʋ́ Farisifɔ pʋ́ Mose mbla asunápʋ́ amʋ akʋ bɛbláa Yesu bɛɛ, “Osunápʋ́, anɩdéklé anɩaa fʋbwɛ́ɛ osúna kʋ suna anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɔlɛbláa amʋ́ ɔbɛ́ɛ “Mlɩ ndɛmba-abí laláhɛ ánɩ́ mlɩladálɩ Bulu ɔma. Mlɩdɛ́ osúna dunká amlɩwun, támɛ mlɩmóowun kʋkʋʋkʋ dʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yona osúna amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Alɩ ámʋ́ʋ́ Yona létsiá bonsu ɩwɩtɔ nkɛnsá, ɔpa mʋ́a onyé ámʋ a, alɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ nétsiá ɔsʋlʋ́ʋ ɔtɔ́tɔ́ nkɛnsá, ɔpa mʋ́a onyé nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niniwefɔ ɛ́ bɔ́kʋsʋ́ Bulu asʋ́n ogyíkɛ́ amʋ, há mlɩ ndɛmba-abí ánfɩ ɩpɔ́n. Tsúfɛ́ brɛ́á Yona lɛ́da Bulu asʋ́n ɔkan súná amʋ́ á, bɛdamlí klʋntɔ ba Bulu wá. Mlɩkɩ, ɔhá ánɩ́ ɔdʋn Yona onutó lɩ́ɩ́ nfɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Seba owíe tsɩhɛ́ ɔbɔ́kʋsʋ́ lɩ́ɩ́ Bulu asʋ́n ogyíkɛ, há mlɩ ndɛmba-abí ánfɩ ɩpɔ́n. Tsúfɛ́ olotsu ɔsaasɩ́ ɔmá ɩkʋtɔ kéín gya ɔkpa ba, bonu Salomo nyánsa atosunáhɛ́. Mlɩkɩ, ɔhá ánɩ́ ɔdʋn Salomo lɩ́ɩ́ nfɩ á.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nɩ́ ɔŋɛ laláhɛ ɩdálɩ ɔhatɔ á, iteyéki dimbísʋ́ dúnká ɔkpʋ́nʋ́ ɔdakpá, támɛ ɩtamanyá. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ɩnʋ ɩtɛblɩ́ ánɩ́ ibéyinkí yɔ́ mʋ́ wóyí dadatɔ. Nɩ́ ɩsánkí yɔ́ á, itowun ánɩ́ bafɛ́ɩ́ mʋ́tɔ́, lá mʋ́tɔ́ wankláán, ɩda kpan. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iteyínkí yɛ́kpa mʋ́ aba asienɔ́ ánɩ́ bʋtɔbwɛ́ lalahɛ dʋn mʋ́, bʋtɛba betsiá ɩnʋ. Ɩnʋ ɔhá ámʋ tsiátɔ́ teyíntá dʋn alɩá igyi yáɩ́. Alɩ́ ɩbɛ́ba ha mlɩ ndɛmba-abí laláhɛ anfɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Brɛ́á Yesu trá ɔdɛ ahá ámʋ asʋ́n bláa a, mʋ yin mʋa mʋ apíó bɛba bɛlɩɩ́ kpankpá, bʋdedunká ánɩ́ bɛ́bláa mʋ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ahá ámʋtɔ ɔkʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Kɩ, fʋ́ yín mʋa fʋ́ apíó bʋlɩɩ́ kpankpá. Bʋdɛ fʋ́ dunká, abʋbla fʋ asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Amɛndɩ gyí mɩ́ yín mʋa mɩ́ apíó?” ");
INSERT INTO nkoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɩnʋ ɔlɛtɩnkɩ́ ɩbɩ sɩ́sɩ́ mʋ akasɩ́pʋ́ amʋ, blɩ́ ɔbɛ́ɛ, “Mlɩkɩ, mɩ́ yín mʋa mɩ́ apíó gyí ahá ánfɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ɔhagyíɔha ánɩ́ ɔtɔbwɛ́ mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ apɛ́ á, mʋgyí mɩ́ yín mʋ́a mɩ́ píó nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ɛkɛ ámʋ kɛ́n á, Yesu lɛ́dalɩ tsu wóyítɔ́ yétsiá ɔpʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛba befia bomlí mʋ. Mʋ́ sʋ ɔlɔdʋ wíé ɔklʋntɔ, yétsiá ɔpʋ amʋsʋ, ahá ámʋ ɛ́ bʋlɩɩ́ ɔpʋ ɔnɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɩnʋ olosuná amʋ́ atɔ́ tsɔtsɔɔtsɔ ayébitɔ ɔbɛ́ɛ, “Ɔdɔtɔpʋ ɔkʋ lɔ́yɔ atɔ́-abí owunyákpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Brɛ́á ɔdɛ mʋ́ wunyáa a, ɩkʋ lɔ́wʋlɩ́ ɔkpatɔ, mbubwi bɛba bɔtswɛtswɛ́ɛ mʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɩkʋ ɛ́ lɔwʋlɩ́ abʋtásʋ́, ɔtɩ́nɛ́á ɩsɩ kpalobí dɩn. Mʋ́ sʋ ɩlɔwa ɔsa kwɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","támɛ brɛ́á owí lɛlɩn a, ɩlɔtɔ mʋ́ mɔ́, tsúfɛ́ mʋ́ nlín mɔyɔ ɔtɔ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Abí ámʋ kʋ lobun awutɔ, awu ámʋ lɔbʋlá kɩ́tá mʋ́. Mʋ́ sʋ ɩmɛdan. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Támɛ abí ámʋ kʋ ɛ́ lobun ɔsʋlʋ́ʋ wankláánsʋ́, ɩlɔkwɛ, dan, swie abí. Ɩkʋ lafa (100), ɩkʋ aduesie (60), ɩkʋ ɛ́ adʋasa (30).” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu lɔ́mɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Ɔha ánɩ́ ɔbʋ asʋ onúu!” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mʋ akasɩ́pʋ́ amʋ bɛba bɛfɩtɛ́ mʋ bɛɛ, “Ntogyi sʋ́ fʋdɛ amʋ́ asʋ́n bláa ayébisʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mʋ́ʋ́ ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩ mʋ́ á, Bulu lahá mlɩ ɔkpa ɔbɛ́ɛ, mlɩbɩ́ɩ mʋ iwíegyí ámʋ ɩwɩ asʋn ŋaínhɛ́, támɛ ɔmɛha amʋ́ mʋ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tsúfɛ́ ɔhá ánɩ́ odekléá obónu mɩ́ atosunáhɛ́ amʋ asɩ á, Bulu ɔbɔ́pʋ ɩkʋ tsɩ́a mʋ́tɔ́ há mʋ, mɛ́nɩ ɔbɛ́tra bɩ tsɩ́a mʋ́tɔ́. Támɛ ɔhá ánɩ́ omedékléá obónu mʋ́ asɩ á, Bulu ɔbɔ́swɩɩ́ mʋ kpalobí ámʋ́ʋ́ alabɩ́ ámʋ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tɔ́á sʋá ndɛ amʋ́ asʋ́n bláa ayébisʋ gyí, bʋdɛ mʋ́ nu, támɛ bʋmɛdɛ́ mʋ́ asɩ nu. Bʋdɛ mʋ́ wúun, támɛ bʋmɛdɛ́ mʋ́ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ahá ánfɩ sʋ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia asʋ́n ánɩ́ ɔlɛblɩ́ tswɩ́ɩ laba mʋ́tɔ́ nɩ́. Ɔbɛ́ɛ, ‘Bónu lánú, támɛ bʋmóonu mʋ́ asɩ. Bɛ́kɩ lákɩ, támɛ bʋmóowun mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tsúfɛ́ amʋ́ agywɩɩn lawú. Batílá asʋ, bun ansíbi ɛ́. Ɩ́nɩ sʋ bʋmóonu, bʋmóowun ɛ́. Nɩ́ megyí alɩ á, tɛkɩ bówun atɔ́, bónu asʋ́n, amʋ́ agywɩɩn bóbwií, bɛ́damlí ba mɩ́ wá, nɛ́tsa amʋ́ ɩlɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Támɛ mlɩ mʋ́ á, Bulu layúlá mlɩ. Mlɛ́talɩ́ pʋ́ ansíbi wun atɔ́, pʋ́ asʋ nú asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ɔnɔkwalɩ ndɛ mlɩ bláa. Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ pʋ́ yilé abwɛpʋ́ tsɔtsɔɔtsɔ bekleá bɔ́pʋ amʋ́ ansíbi wun atɔ́ ánfɩ, abʋpʋ amʋ́ asʋ nu asʋ́n ánfɩ mlɩdénu, támɛ bʋmenya mʋ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mlɩnu atɔ́-abí owunyápʋ yébi amʋ asɩ ngya. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ahá ánɩ́ bonú Bulu iwíegyí ɩwɩ asʋ́n ámʋ, támɛ bʋmonu mʋ́ asɩ á, bʋgyi fɛ́ abí ámʋ́ʋ́ ilobun ɔkpatɔ ámʋ. Ɔbʋnsám tɛba bɛlɛ asʋ́n ámʋ́ʋ́ bodu wá amʋ́ klʋntɔ ámʋ nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ abʋtásʋ́ amʋ gyí ahá ámʋ́ʋ́ bonú asʋ́n ámʋ pɛ́, bahɔ mʋ́ ansigyísʋ́, ");
INSERT INTO nkoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","támɛ ɩ́nɩá bʋma nlín sʋ á, ɩtamatsíá amʋ́tɔ́ yɔ́. Mʋ́ sʋ nɩ́ bʋdɩn amʋ́sʋ́ ntɛ́ɛ ɩwɩɔsɩn kʋ ɩtʋ́ amʋ́ asʋ́n ámʋ sʋ á, ɩnʋnʋ bʋtɛdɩda. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ awutɔ ámʋ gyí ahá ámʋ́ʋ́ bonú asʋ́n ámʋ a, bahɔ mʋ́, támɛ ɔyɩ́ ánfɩtɔ atɔ hiánhɛ ɩwɩ gywɩɩ́n pʋ́ mʋ́tɔ́ atonyahɛ́ ɩwɩ ɔnsɩ́pɛ tegyi Bulu asʋ́n ámʋsʋ. Ɩ́nɩ sʋ bʋtamaswíé abí. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ ɔsʋlʋ́ʋ wankláánsʋ́ amʋ gyí ahá ámʋ́ʋ́ bʋtonú asʋ́n ámʋ, nú mʋ́ asɩ. Ɩ́nɩ sʋ ɩtɛhá bʋtɔbwɛ́ yilé fɛ́ alɩá atɔ́-abí ámʋ loswie, ɩkʋ lafa (100), ɩkʋ aduesie (60), ɩkʋ ɛ́ adʋasa (30) ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu lɛ́trá ha ahá ámʋ yébi kʋ ɔbɛ́ɛ, “Bulu iwíegyí ámʋ igyi fɛ́ ɔdɔtɔpʋ ɔkʋá oloyódu ayó wankláán mʋ ndɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Támɛ onyé, brɛ́á ahá bɛdɩ á, mʋ olupʋ́ lóyódu ɩfa laláhɛ ánɩ́ ɩlɛlɩan ayó ámʋ wá mʋ́tɔ́, ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Brɛ́á ayó ámʋ lɛ́dan, ɩdɛkwɩɩ́ á, ɩfá ámʋ ɛ́ lɛlɩn ɔwan mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɔdɔtɔpʋ amʋ apafɔ botsu ndɔ ámʋtɔ ba bɛfɩtɛ́ mʋ bɛɛ, ‘Anɩ wíé, megyí ayó fodu wá fʋ́ ndɔ ámʋtɔ? Nkʋ́nʋ́ ɩfa laláhɛ ɛ́ itsú mʋ́tɔ́?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, ‘Mɩ́ olupʋ́ bwɛhɛ́ nɩ́.’ Ɩnʋ bɛbláa mʋ bɛɛ, ‘Nɩ́ fótsulá á, ha ayetsitsíi mʋ́ lɛ ayó ámʋtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, ‘Ó-o! Mlɩha mʋ́ itsia. Nɩ́ mlɩdɛ́ mʋ́ tsií á, mlétsií mɩ́ ayó ámʋ ɛ́ kʋ tsítsá. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mlɩsi mʋ́ fɛ́ɛ́ ɩlɩɩ yɔ́fʋn mʋ́ tɩ́nbɩ. Nɩ́ ɩfʋn a, nɛ́bláa mʋ́ atɩ́npʋ mbɛ́ɛ, bʋgyánkpa saɩn ɩfa laláhɛ amʋ, abʋklɩ mʋ́ tswɩ ha mʋ́ ogyá wa, asa abʋtɩn ayó ámʋ yɔwa mɩ́ odudutɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu lɛ́trá ha amʋ́ yébi ɔbɛ́ɛ, “Bulu iwíegyí ámʋ igyi fɛ́ takyí-akpin ibí, oyin ɔkʋ lódu wá mʋ ndɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mʋ́gyí túkúrííbi nyí-abí fɛ́ɛ́tɔ́ nɩ, támɛ nɩ́ ɩdan a, ɩtɔbwɛ́ ɩfá fʋ́áhɛ́ dʋn ɩfá kugyíkʋ. Mʋ́ abámbi tekpíkpli, mbubwi bʋtogyónká mʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu lɛ́trá ha amʋ́ yébi kʋ ɔbɛ́ɛ, “Bulu iwíegyí ámʋ igyi fɛ́ bodobodotu-afá ánɩ́ ɔtsɩ ɔkʋ lɔ́pʋtsɩ́á bodobodo nfúó kɛntɛ kʋlɛ, ɩlɛha mʋ́ lotu.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ayébi anfɩ odu tsɔtsɔɔtsɔ oletsiá pʋ́bláa ɔdɔm amʋ asʋ́n nɩ́. Ɔmɛbláa amʋ́ asʋ́n kʋkʋá imegyí ayébi ɔlɔpʋtɔ́ɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɩ́nɩ lɛ́ha asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋ lɛ́blɩ́ yáɩ́ ámʋ lɛ́ba mʋ́tɔ́. Ɔbɛ́ɛ, “Nɔ́tɔɩ́ ayébisʋ pʋ́lɛ́ asʋ́n ánɩ́ Bulu lɔ́pʋŋáín tsú ɔyɩ́ asɩtsuábɩ ɔwan.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu lɛ́natɩ́ ɔdɔm amʋ wá ba wóyítɔ́. Mʋ́ʋ́ mʋ akasɩ́pʋ́ amʋ bɔyɔ mʋ wá yɛ́bláa mʋ bɛɛ, “Lɛ ndɔ ámʋtɔ ɩfa laláhɛ ɩwɩ yébi amʋ asɩ suna anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mʋ́ʋ́ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ gyí atɔ́-abí wankláán odupʋ́ ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ndɔ ámʋ gyí ɔyɩ́ ánfɩ. Atɔ́-abí wankláán ámʋ gyí Bulu iwíegyí ámʋtɔ abí. Ɩfa laláhɛ amʋ gyí Ɔbʋnsám abí. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Olupʋ́ ámʋ́ʋ́ olodu ɩfa laláhɛ abí ámʋ gyí Ɔbʋnsám. Atɔ́tɩnbɩ amʋ gyí ɔyɩ́ ɔnɔ́mɔkɛ́. Atɔ́ atɩ́npʋ amʋ ɛ́ gyí Bulu-abɔpʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Alɩ ámʋ́ʋ́ bɛsaɩ́n ɩfa laláhɛ amʋ, wá mʋ́ ogyá ámʋ a, alɩ́ kɛ́n ɩbɛ́ba ha aha laláhɛ ɔyɩ́ ɔnɔ́mɔkɛ́ ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɔ́wa mɩ́ abɔpʋ bɛ́kpa tógyítɔ́á ɩtɛhá ɔha tɔbwɛ́ lakpan pʋ́ lalahɛ abwɛpʋ́ fɛ́ɛ́ lɛ́ mɩ́ iwíegyí amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bɔ́tswɩ amʋ́ fɛ́ɛ́ wá ogyá kpɔnkpɔntɩtɔ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Támɛ yilé abwɛpʋ́ mʋ́ bɔ́wankɩ́ fɛ́ owí amʋ́ Sɩ́ Bulu iwíe ogyíkpá ɩnʋ. Ɔhá ánɩ́ ɔbʋ asʋ onúu.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu lɛ́trá ha amʋ́ yébi kʋ ɛ́ ɔbɛ́ɛ, “Bulu iwíegyí ámʋ igyi fɛ́ siadɩɛ kʋá bopulá ɔsʋlʋ́ʋ kʋsʋ. Oyin ɔkʋ lɛ́yɛ́mɛntɩ́ mʋ́, láŋáín mʋ́. Mʋ́ ɩwɩ ansigyí sʋ á, ɔlɛyɛ́fɛ mʋ atɔ́ fɛ́ɛ́ pʋ́bɔhɔ ɔsʋlʋ́ʋ amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bulu iwíegyí ámʋ ɩtráa gyi fɛ́ ibíá ogyípʋ́ ɔkʋá ɔna ɔdɛ abutó wʋ́lɩhɛ dunká ɔhɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Brɛ́á olowun butóbi wʋlɩhɛ kʋlɛ pɛ́á ɩhɩ́ɛ́ bʋ ibíá á, ɔlɛfɛ mʋ atɔ́ fɛ́ɛ́ pʋ́yɔ́hɔ butóbi amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bulu iwíegyí ámʋ lɛ́la igyi fɛ́ asawu ánɩ́ bɔtswɩ wa ɔpʋtɔ lɛ́ aye ɔtsan-ɔtsan. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Brɛ́á aye lɔbʋlá mʋ́ á, aye alɛpʋ́ ámʋ bɛbɩtɩ́a mʋ́ ba ɔpʋ ɔnɔ́. Betsiá asɩ, tɔ́sɩ́ gyíhɛ amʋ wá blanwɛ́tɔ́, tswɩ mʋ́á bʋtamagyi tsítsá. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Alɩ́ ɩbɛ́ba ɔyɩ́ ɔnɔ́mɔkɛ́ ámʋ nɩ. Bulu-abɔpʋ bɛ́ba bɔtɔsɩ́ aha laláhɛ lɛ́ aha wankláántɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Fówun batswɩ aha laláhɛ amʋ wá ogyá kpɔnkpɔntɩtɔ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu lɛ́fɩtɛ́ mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Mlɩlanú mʋ́ fɛ́ɛ́ asɩ?” Bɛɛ, “Ee, anɩlanú mʋ́ asɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mbla osunápʋ́ oduá alakásɩ́ Bulu iwíegyí ámʋ ɩwɩ asʋ́n ɛ́ bɩ́ á, ogyi fɛ́ wóyí mʋ wie oduá ɔtɛlɛ́ atɔ pɔpwɛ mʋ́a dáda fɛ́ɛ́ tsú mʋ atɔ́ ɔyaɩ́kpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu lénya mɔ́ mʋ ayébi amʋ ɔnɔ́ alɩ, ɔlɛnatɩ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Oleyinkí yɔ́ mʋ onutó wúlutɔ Nasaret, oloyósuná atɔ́ Yudafɔ ofíakpa. Mʋ atosunáhɛ́ lɛha ɔnɔ́ lobwie ahá ámʋ fɛ́ɛ́. Mʋ́ sʋ bɛfɩtɛ́ aba bɛɛ, “Nkʋ́nʋ́ olenya nyánsa mʋ́a ofúlabwɛ túmi ánfɩ ɛ́ tsú? ");
INSERT INTO nkoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Megyí atɔ́ osrépʋ́ mʋ bi ámʋ nɩ? Megyí mʋ yin gyí Maria, mʋ apio yinhɛ́ gyí Yakobo mʋa Yosef pʋ́ Simon mʋa Yuda? ");
INSERT INTO nkoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yɛ́ɛ anɩa mʋ apio tsɩhɛ́ tsie nfɩ á? Mʋ́ʋ́ nkʋ́nʋ olenya ɩ́nɩ fɛ́ɛ́ tsú?” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɩ́nɩ sʋ mʋ asʋ́n lɔ́kʋsʋ́ lɩ́ɩ́ amʋ́sʋ́. Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ahá bʋtobú Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔtɩ́nɛgyíɔtɩ́nɛ́, támɛ mʋ onutó wúlutɔfɔ pʋ́ mʋ wóyítɔ́ ahá mʋ́ bʋtamabú mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ɩ́nɩá bʋmɔhɔ mʋ gyi sʋ á, ofúla kpalobí kʋ pɛ́ ɔlɔbwɛ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Galilea ɔmásʋ́ ogyípʋ́ Herode lónu Yesu ɩwɩ asʋ́n alɩ brɛ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mʋ́ʋ́ ɔlɛbláa mʋ asúmpʋ́ ɔbɛ́ɛ, “Asú Ɔbɔpʋ́ Yohane amʋ nɩ. Mʋlákʋ́sʋ́ tsú afúlitɔ. Mʋ́ sʋ́ ɔdɛ ofúla anfɩ odu bwɛ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Brɛ́ kʋtɔ á, Yohane létsiá bláa Owíe Herode ɔbɛ́ɛ, mbla mɛha ɔkpa ánɩ́ otsía mʋ pio Filipo mʋ ka Herodia. Ɩ́nɩ sʋ Herode lɛ́ha bɛkɩtá Yohane, wá mʋ ɩkan, pʋ́ mʋ wá obu. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɔlɔbwɛ agywɩɩn ánɩ́ ɔbɔ́mɔ Yohane, támɛ olenya ahá ámʋ ifú, tsúfɛ́ bʋtobú Yohane ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Támɛ ɛkɛ ɔkʋá Owíe Herode dɛ́ mʋ ɔkwɩɩ́kɛ́ gyí a, mʋ ka Herodia mʋ bi tsɩ́hɛ́ lóbowie ɔbʋntɔ tsa Herode mʋa mʋ ahandɛ ansɩ́tɔ́. Mʋ ɩtsáa amʋ lɔ́wa owíe amʋ ansigyí. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mʋ́ sʋ ɔlɛka ntam ɔbɛ́ɛ, ɔbɛ́ha mʋ tógyítɔ́á odeklé. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Otsibi amʋ mʋ yin lɛ́ha mʋ ɔlɛbláa Herode ɔbɛ́ɛ, “Ndekléá fʋpʋ́ Asú Ɔbɔpʋ́ Yohane nwun dɩnka ɩlɩ́nsʋ́ ha mɩ sésééséi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Asʋ́n ánfɩ lɛ́hɩɛ han Herode, támɛ mʋ ntam amʋ́ʋ́ ɔlɛka, pʋ́ ahá ámʋ́ʋ́ bʋbʋ ɩnʋ ámʋ sʋ á, ɔlɛha mʋ ahá ɔtɩ́npʋ ɔkpa ɔbɛ́ɛ, ɔbwɛ́ɛ tɔ́á otsibi amʋ lafɩ́tɛ́ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ahá ɔtɩ́npʋ amʋ lɛ́yɛtɩn Yohane nwun obu ɔdɩkpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mʋ́ʋ́ ɔlɔpʋ nwun ámʋ dɩ́nká ɩlɩ́nsʋ́ ba otsibi amʋ, mʋ ɛ́ ɔlɔpʋya mʋ yin Herodia. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Asú Ɔbɔpʋ́ Yohane akasɩ́pʋ́ bɛba botsu mʋ satin yópulá. Mʋ́ ɔma a, bɔyɔ yɛ́bláa Yesu asʋ́n ánɩ́ ɩlaba. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu lénya nú asʋ́n ámʋ alɩ, olowie ɔklʋntɔ, fá ntsu yétsiá ɔtɩnɛkʋ mʋ nkʋlɛ. Támɛ ɔdɔm ámʋ bɛbɩ ɔtɩ́nɛ́á ɔyɔ́. Mʋ́ sʋ bɛnatɩ́ ayabitɔ tsú amʋ́ awúlusʋ gya mʋ nkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Brɛ́á ɔlɛkplɩ́ dalɩ ɔklʋn amʋtɔ, wun ɔdɔm kpɔnkpɔɔnkpɔntɩ á, amʋ́ asʋ́n lɔwa mʋ nwɛ. Mʋ́ sʋ ɔlɛtsa amʋ́tɔ́ alɔpʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Owí lɔpɔn a, akasɩ́pʋ́ amʋ bɛba mʋ wá bɛbláa mʋ bɛɛ, “Dimbísʋ́ nfɩ gyí, owí ɛ́ dɛta. Mʋ́ sʋ ha amʋ́ abʋyɔ awúluá ɩbʋ bomlí nfɩ asɩ yɔhɔ tɔkʋ gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Támɛ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Imehián ánɩ́ bɔ́yɔ. Mlɩdunka tɔkʋ ha amʋ́ abʋgyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mʋ akasɩ́pʋ́ amʋ bɛbláa mʋ bɛɛ, “Tɔ́á anɩbʋ fɛ́ɛ́ gyí bodobodo apin anu pʋ́ ntsutso iye bwáhɛ́ anyɔ pɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩtsu ba mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mʋ́ʋ́ ɔlɛha ahá ámʋ betsiatsía ɩfa bɔbwɛ amʋsʋ. Ɩnʋ olotsu bodobodo anu pʋ́ ntsutso iye bwáhɛ́ anyɔ ámʋ. Ɩnʋ olotsu ansɩ́ fʋ́á kɩ ɔsʋ́sʋ́, ɔlɛda Bulu ɩpán. Mʋ́ʋ́ olebiabía bodobodo amʋtɔ há akasɩ́pʋ́ amʋ, amʋ́ ɛ́ beye mʋ́ ha ahá ámʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Amʋ́ fɛ́ɛ́ begyi mwɛ sian. Akasɩ́pʋ́ amʋ bɔtɔsɩ́ síanhɛ amʋ. Ɩlɔbʋlá alakpá dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ayin ánɩ́ begyi atɔ́ ámʋ nkʋlɛ bʋgyi fɛ́ mpɩ́m-nu (5,000). Bʋmɛkla atsɩ mʋ́a nyebí mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mʋ́ʋ́ Yesu lɛ́ha akasɩ́pʋ́ amʋ ɔbɛ́ɛ, bʋwíe ɔklʋntɔ, abʋgyankpa fa ɔpʋ amʋ yɔ mʋ́ ɔbɩn. Mʋ mʋ́ olesin ɔma sí ahá ámʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Brɛ́á olesi amʋ́ ɔkpa tá á, ɔlɔdʋ yɔ́ bʋsʋ yɔ́bɔ mpáɩ. Mʋ nkʋlɛ oletsiá ɩnʋ yɔ́fʋn owi tahɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Alɩ brɛ́ ámʋtɔ á, ɔklʋn amʋ lawíé ntsu nsɩnɛ́. Ilefia afú kpɔnkpɔntɩ kʋ, ɔpʋ amʋ lɔ́wa dabɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bakɛ-bakɛ a, Yesu lɛ́natɩ́ ntsu ámʋsʋ ayabitɔ buo amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Brɛ́á bowun mʋ, ɔna ɔpʋ amʋsʋ á, benya ifú sʋ́rá okitikíti, blɩ́ bɛɛ, “Fúli ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Támɛ ɔlɔwa ɔsa bláa amʋ́ ɔbɛ́ɛ, “Mlɩwa klʋn. Mɩ́ nɩ́. Mlɩmánya ifú.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petro lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, nɩ́ fʋ́ nɩ́ mʋ́ á, ha mɩ́ ɛ́ annatɩ ɔpʋ amʋsʋ bɔtʋ fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Natɩ ba.” Petro lɛ́dalɩ ɔklʋn amʋtɔ ɔna ɔpʋ amʋsʋ ɔyɔ́ Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Támɛ brɛ́á olowun alɩá afú ámʋ ɔnɔ́ bʋ ɔnlɩn á, ifú lowie mʋ ayetɔ. Mʋ́ sʋ ɔlɔwa mɛ bɩ. Mʋ́ʋ́ ɔlɔkplʋ́n kpolí Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, hɔ mɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɩnʋnʋ Yesu lɛ́tɩnkɩ́ ɩbɩ kɩ́tá mʋ, bláa mʋ ɔbɛ́ɛ, “Fʋ́ hógyi mɔtsɔ́. Ntogyi sʋ́ fʋ́dɛ nwɛ́ɛn gyí?” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Benya dʋ́ wíé ɔklʋn amʋtɔ alɩ, afú ámʋ lɛ́ka itin. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɩnʋ ahá ámʋ́ʋ́ bʋbʋ ɔklʋn amʋtɔ ámʋ bɛda akpawunu Yesu ayabitɔ, blɩ́ bɛɛ, “Lɛ́lɛ́, Bulu mʋ Bi fʋ́gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu mʋa amʋ́nyɔ bɛfa ɔpʋ amʋ yési Genesaret otsubúnɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Brɛ́á ɩnʋfɔ bɛbɩ ánɩ́ mʋ nɩ á, bɔwa abí ya amʋ́ awúlu fɛ́ɛ́sʋ́, há amʋ́ bɔpʋ alɔpʋ fɛ́ɛ́ ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bokokóli Yesu bɛɛ, ɔhá alɔpʋ amʋ abʋpʋ ɩbɩ da mʋ atadɩɛ ɔdanʋ́ kpán. Amʋ́á bɔpʋ ɩbɩ da mʋ́ fɛ́ɛ́ benya ɩlɔtsá. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mʋ́ ɔma a, Farisifɔ pʋ́ Mose mbla asunápʋ́ akʋ botsu Yerusalem ba Yesu wá, bɛfɩtɛ́ mʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ntogyi sʋ́ fʋ́ akasɩ́pʋ́ amʋ bʋtamagyi anɩ anáin amándɩ́ɛ́sʋ́. Bʋtamafwɩ́ ɩbɩ amándɩ́ɛ́ ɔkpasʋ asa bʋtegyi atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩ ɛ́ mlɩ anáin amándɩ́ɛ́ sʋ mlɩmɛ́dɛ́ Bulu mbla ámʋsʋ gyí? ");
INSERT INTO nkoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mose lɔ́wanlɩ́n wá Bulu mbla ámʋtɔ ɔbɛ́ɛ, ‘Bu fʋ́ sɩ́ mʋa fʋ́ yín,’ ɔlɛtrá wanlɩ́n ɔbɛ́ɛ, ‘Nɩ́ ɔkʋ lɛ́blɩ́ asʋkpan tsú mʋ sɩ ntɛ́ɛ mʋ yin ɩwɩ á, bʋmɔ́ɔ mʋ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Támɛ mlɩ mʋ́ mlɩaa, ɔha ɔbɛ́talɩ́ bláa mʋ sɩ ntɛ́ɛ mʋ yin ɔbɛ́ɛ, ‘Tɔ́á tɛkɩ nɔ́pʋhá fʋ́ á, napʋ́há Bulu. Imehián ánɩ́ nɛ́trá kɩ fʋ.’ Mlɩ anáin amándɩ́ɛ́ sʋ mlɩtráa mlɩmɛ́dɛ́ Bulu mblasʋ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Apinabwɛbí abwɛpʋ́! Ɔnɔkwalɩ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia lɛ́blɩ́ tsú mlɩ ɩwɩ tswɩ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ahá ánfɩ bʋdɛpʋ amʋ́ ɔnɔ́ bú mɩ́, támɛ amʋ́ klʋn bʋ ɩfɔ́ mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kpaalɩ bʋdɛ mɩ́ sum, tsúfɛ́ basí Bulu mbla tswɩ, yɔ́ bʋdɛ anyánkpʋ́sa mbla suná.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu lɛ́trá tɩ ɔdɔm amʋ ba mʋ ɩwɩ wá, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩyaa asʋ, mɛ́nɩ mlónu ɩ́nɩ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Megyí tɔ́á ɔha tegyi tɔ́kpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́, mboún mʋ́á ɩtɛdálɩ tsu mʋ ɔnɔ́ tɔ́kpɔ́ɩ́ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɩnʋ mʋ akasɩ́pʋ́ amʋ bɛba mʋ wá bɛfɩtɛ́ mʋ bɛɛ, “Fʋyin ánɩ́ fʋ́ asʋn blɩ́hɛ́ anfɩ lawɔ Farisifɔ ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bópulí oyígyíoyí ánɩ́ megyí mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ lóswíe tsitsá. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mlɩsi Farisifɔ ámʋ asʋ́n. Ansibi abwiepʋ́ bʋgyi, bʋdɛ ansibi abwiepʋ́ kpa. Nɩ́ nsibi obwiepʋ́ dɛ́ nsibi obwiepʋ́ kpa á, ɔbɔ́tɔ́ amʋ́ abanyɔ́ bʋtɛkpá wíé.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mʋ́ʋ́ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Lɛ yébi amʋ asɩ suna anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mʋ́ sʋ mlɩ ɛ́ mlɩtamanú asʋ́n asɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mlɩméyín ánɩ́ tɔ́á iwíé ɔha ɔnɔ́ á, mʋ iputɔ itowíé, ɔtɛyɛ́lɛ mʋ́ wá ɔkpʋntɔ? ");
INSERT INTO nkoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Asʋ́ngyíasʋ́n ánɩ́ ɩtɛdálɩ tsu ɔha ɔnɔ́ á, mʋ klʋntɔ ɩ́tɛdálɩ tsu. Mʋ́tɔkpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsúfɛ́ ɔha klʋntɔ ágywɩɩn laláhɛ tɛdálɩ tsu. Mʋ́tɛ́há ɔtɔmɔ́ ɔha, ɔtɔtɔ́ mbʋa, ɔtɔwá atsɩ mʋ́a ayin asʋ́n, otowí atɔ́, ɔtɔwá afunu, otetsii ɔha. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɩ́nɩ aná tɔ́kpɔ́ɩ́ ɔha, támɛ nɩ́ ɔha mɔ́fwɩ ɩbɩ amándɩ́ɛ́ ɔkpasʋ asa olegyi atɔ́ á, ɩtamakpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu lɛ́natɩ́ ɩnʋ yɔ́ Tiro mʋ́a Sidon nsáɩntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanaanyintse ɔkʋá otsie ɩnʋ lɛ́ba Yesu wá. Ɔdɛ okitikíti sʋrá, olokokóli Yesu ɔbɛ́ɛ, “Dawid mʋ na, wun mɩ nwɛ! Ɔŋɛ laláhɛ bʋ mɩ́ bí tsɩ́hɛ́tɔ́. Ɩdɛ mʋ háan dʋbɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Támɛ Yesu mɛ́kpla mʋ. Ɩnʋ mʋ akasɩ́pʋ́ amʋ bobwií ɩpa há mʋ bɛɛ “Ha ɔtsɩ ámʋ ɔnatɩ, tsúfɛ́ obuo anɩ ɔdɛ okitikíti sʋrá dʋbɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu lɛ́bláa ɔtsɩ ámʋ ɔbɛ́ɛ, “Israel akúfa fwɩhɛ́ pɛ́ wá Bulu lɔ́wa mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Támɛ ɔtsɩ ámʋ lɛ́da akpawunu mʋ ayabitɔ, bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, gyi mɩ bʋalɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɩma alɛá fɔ́swɩɩ́ nyebí atogyihɛ pʋ́há akɩ́aɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɔtsɩ ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Owíé, ɩbʋ mʋ́tɔ́ alɩ, támɛ akɩ́aɩ ɛ́ bʋtegyi atogyihɛ mpupubi ánɩ́ ɩtɛkpákpa bun amʋ́ wíe ɔpʋ́nʋ́asɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔtsɩ, fʋ́ hógyi lomoní. Ɩbá mʋ́tɔ́ ha fʋ alɩá fʋdeklé.” Ɩnʋnʋ ɩwɩ lɔ́wa mʋ bi ámʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsú ɩnʋ á, Yesu lɔ́tsʋn Galilea ɔpʋ ɔnɔ́, dʋ́ yétsiá okúku kʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ahá tsɔtsɔɔtsɔ bɔpʋ abubúpʋ, ansibi abwiepʋ́, abɔ, amúmu pʋ́ ɩlɔ bámbá alɔpʋ́ bobun Yesu ayabiasɩ, ɔlɛtsa amʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ahá ámʋ ɔnɔ́ lobwie amʋ́ brɛ́á bowun amúmu bʋdɛtɔɩ́, abubúpʋ ɩwɩ lawá amʋ́ ɔnlɩn, abɔ bʋna, ansibi abwiepʋ́ ɛ́ bʋdɛ atɔ́ wúun, bɛkanfʋ́ Israel Bulu ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu lɛ́tɩ mʋ akasɩ́pʋ́, bláa amʋ́ ɔbɛ́ɛ, “Ahá ánfɩ asʋ́n dɛ mɩ́ nwɛ wa. Ndɛ ɛkɛ sáásɩ́ ɔpá bʋbuo mɩ, bʋtráa bʋma tɔtɔá bégyi. Nɩ́ nɛhá amʋ́ bɔpʋ́ akʋ́n nátɩ́ á, ansɩ́tɔ́ béyebi amʋ́ ɔkpatɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Nkʋ́nʋ́ abénya atogyihɛ há ɔdɔm anfɩ dimbí ánfɩsʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bodobodo afɩnɩ mlɩbʋ?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Asienɔ́ pʋ́ aye pútúpútú kpalobí kʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu lɛ́ha ɔdɔm amʋ betsiá asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mʋ́ʋ́ olotsu bodobodo asienɔ́ pʋ́ aye amʋ, dá Bulu ɩpán, olebiabía mʋ́tɔ́ há akasɩ́pʋ́ amʋ, beye ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amʋ́ fɛ́ɛ́ begyi mwɛ. Bɔtɔsɩ́ síanhɛ amʋ bʋ́lá alakpá yílé asienɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ayin ánɩ́ begyi atɔ́ ámʋ nkʋlɛ bʋgyi mpɩ́m-na (4,000). Bʋmɛkla atsɩ mʋ́a nyebí. ");
INSERT INTO nkoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɩnʋ Yesu lési ahá ámʋ ɔkpa, olowie ɔklʋntɔ fá ɔpʋ yɔ́ Magadanfɔ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɛkɛ ɔkʋ Farisifɔ pʋ́ Sadukifɔ akʋ bɛba Yesu ɔsɔ́kɩkpa. Mʋ́ sʋ bɛbláa mʋ bɛɛ, ɔbwɛ́ɛ osúna pʋsuna amʋ́ ánɩ́ lɛ́lɛ́ otsú Bulu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ owí ɩpɔn, nsaɩntɔ ɩpɛ́ á, mlɩtɛblɩ́ mlɩaa, ‘Ɔkɛ nsaɩntɔ bɛ́dɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nɩ́ nyankpʋ obílá tuun nyankɩ a, mlɩtɛblɩ́ mlɩaa, ‘Ndɛ nyankpʋ obótswie tsʋn afú.’ Mlɩtɛtálɩ́ kɩ nsaɩntɔ, bɩ́ tɔ́á ɩbɛ́ba. Ntogyi sʋ́ mlɩmɛ́tálɩ́ nú tɔ́á mlɩdéwúun séi ánfɩ mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mlɩ ndɛmba-abí laláhɛ ánɩ́ mlɩladálɩ Bulu ɔma, mlɩdɛ́ osúna dunká amlɩwun, támɛ mlɩmóowun kʋkʋʋkʋ dʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yona osúna amʋ odu.” Ɩ́nɩ sʋ ɔlɛnatɩ́ sí amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu akasɩ́pʋ́ amʋ bʋmɛkaɩ́n tsú bodobodo kɩ́tá asa bɛfa ɔpʋ amʋ yɔ́ ɔbɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩkɩ wankláán Farisifɔ pʋ́ Sadukifɔ Bodobodotu-afásʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Akasɩ́pʋ́ amʋ bɛfɩtɛ́ aba bɛɛ, “Bodobodo amʋ́ʋ́ anɩmɛ́dɛ́ ámʋ sʋ́ ɔdɛ asʋ́n ánfɩ blɩ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu lónu asʋ́n ánɩ́ bʋdɛblɩ́. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Óo, mlɩ hógyi mɔ́tsɔ́. Ntogyi sʋ́ mlɩdɛ́blɩ́ mlɩaa bodobodo ámʋ́ʋ́ mlɩmɛ́dɛ́ ámʋ sʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɩmɔkʋ́wánkɩ́ mlɩ kɩ? Mlɩlatan bodobodo apin anu ámʋ́ʋ́ nɛha ahá mpɩ́m-nu (5,000) begyi amʋsʋ? Alakpá afɩnɩ lésían mlɩlɔ́tɔsɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ntɛ́ɛ mlɩlatan bodobodo apin asienɔ́ ámʋ́ʋ́ nɛha ahá mpɩ́m-na (4,000) begyi amʋsʋ? Alakpá afɩnɩ lésián mlɩlɔ́tɔsɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ntogyi sʋ́ ɩmɔkʋ́wánkɩ́ mlɩ ánɩ́ megyí bodobodo ɩwɩ asʋ́n ndɛblɩ́? Bláa ndɛ mlɩ bláa mbɛ́ɛ, “Mlɩkɩ wankláán Farisifɔ pʋ́ Sadukifɔ Bodobodotu-afásʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɩnʋ asa ɩlɔwankɩ́ amʋ́ ánɩ́ megyí Bodobodotu-afásʋ́ ɔdɛ, mboún amʋ́ atosunáhɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Brɛ́á Yesu lówie Kaesarea Filipi nsáɩntɔ á, ɔlɛfɩtɛ́ mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Ma ahá bɛɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ngyi?” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Akʋ bɛɛ, fʋ́gyí Asú Ɔbɔpʋ́ Yohane. Akʋ bɛɛ, Bulu Ɔnɔ́sʋ́ Ɔtɔɩ́pʋ́ Elia. Akʋ ɛ́ bɛɛ, Yeremia ntɛ́ɛ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ bambá ɔkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩ ɛ́ mɛ́? Mlɩa mɩ́gyí ma?” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ. Bulu Ɔkɩankpapʋ amʋ mʋ Bi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɩnʋ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Bulu layúlá fʋ́ Simon, Yona mʋ bi, tsúfɛ́ megyí nyankpʋsa ɔkʋkʋ lɛ́lɛ ɔnɔkwalɩ anfɩ ɔwan súná fʋ́. Mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɩ́nɩ sʋ mɩ́ ɛ́ ndɛ fʋ́ bláa mbɛ́ɛ, fʋ́ dá gyí Petro. Mʋ́ asɩ gyí, ‘Bʋtá.’ Bʋtá ánfɩsʋ néyi mɩ́ ɔpasua dɩ́nká nɩ́. Lowu túmi mɛ́ɛtalɩ́ gyí mʋ́sʋ́ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nɔ́pʋ Bulu iwíegyí ámʋ asáafɩ wá fʋ́ ɩbɩtɔ. Asʋ́ngyíasʋ́n ánɩ́ fékiná ɔsʋlʋ́ʋ anfɩsʋ á, Bulu ɛ́ obékiná mʋ́ ɔsʋ́sʋ́. Mʋ́á fótsulá á, Bulu ɛ́ obótsulá mʋ́sʋ́ ɔsʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ɩnʋ ɔlɛda amʋ́ ɔlá kpákpáákpá ɔbɛ́ɛ, bʋmábláa ɔhaa ánɩ́ mʋgyí Kristo amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsú brɛ́ ámʋsʋ á, Yesu léfi asɩ ɔdɛ asʋ́ntɔ́ lɛ súná amʋ́ ɔbɛ́ɛ, “Ilehián ánɩ́ mɔ́yɔ Yerusalem yówun ɩwɩɔsɩn tsɔtsɔɔtsɔ Yudafɔ ahandɛ, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ ɩbɩtɔ. Bɔ́mɔ mʋ, támɛ Bulu ɔbɛ́lakʋ́sʋ́a mʋ ɛkɛ sáásɩ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mʋ́ sʋ Petro lɛ́tɩ mʋ ya ɩtsɛ́tɔ́, yɛ́ka mʋ itin ɔbɛ́ɛ, “Mɩ́ Wíé, Bulu ogyáa mʋ́ tɛ́ɩ́ ya fʋ́ ɩwɩ. Ɩ́nɩ mába fʋsʋ ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ɩnʋ ɔlɛdamlí bláa Petro ɔbɛ́ɛ, “Satan, natɩ tɛɩ mɩ́sʋ́! Fʋdɛ mɩ́ ɔkpa tíin. Megyí tɔ́á Bulu dɛ́gywɩɩ́n fʋdɛgywɩɩ́n, anyánkpʋ́sa klɛ́ fʋdɛgywɩɩ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mʋ́ʋ́ ɔlɛbláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Nɩ́ ɔkʋ dékléá obóbuo mɩ á, osíi tɔ́á otekle bwɛ, otsu mʋ oyikpalíhɛ bobuo mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tsúfɛ́ nɩ́ ɔkʋ lɛ́prɩ mʋ nkpa á, ɩbɔ́hʋlɩ́ɩ mʋ. Támɛ nɩ́ ɔkʋ lési mʋ nkpa há mɩ́ sʋ á, ɔbɛ́lanyá nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɩ́ ɔkʋ onyá ɔyɩ́tɔ́ atɔ́ fɛ́ɛ́, támɛ ɔhʋ́lɩ mʋ ɔkláa a, labi mɔmʋ ɩlɔwa há mʋ? Ntɛ́ɛ ntɔ ɔha ɔbɛ́talɩ́ pʋ́tsɛ mʋ nkpa? ");
INSERT INTO nkoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́ba mɩ́ Sɩ́ numnyamtɔ, mɩ́a mʋ abɔpʋ. Ɩnʋ́ nɛ́ka ɔhagyíɔha ɩkɔ alɩá mʋ tsiátɔ́ gyi nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɔnɔkwalɩ ndɛ mlɩ bláa. Akʋ bʋbʋ mlɩtɔ nfɩ ánɩ́ bʋmóowu, yɔ́fʋn brɛ́á bawun ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛbá mɩ́ iwíe ogyíkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nkensíé ɔma a, Yesu lɛ́kpa Petro mʋa Yakobo pʋ́ mʋ pio Yohane, bɔdʋ yɔ́ ɩbʋ kʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Amʋ́ ansɩ́tɔ́ ɩnʋ á, Yesu ɩwɩ lɛtsɛ. Mʋ ansɩ́tɔ́ lɔ́wankɩ́ fɛ́ owí, mʋ atadɩɛ ɛ́ lɛdamlí fútútúútú. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɩnʋnʋ mʋ akasɩ́pʋ́ abasá ámʋ bowun ánɩ́ Mose mʋa Elia bɛlɛ ɩwɩ ɔwan, amʋ́a Yesu bʋdɛtɔɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mʋ́ʋ́ Petro lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, ɩbʋ alɛ́á abétsiá nfɩ. Nɩ́ fótsulá á, ha ada abú asa. Fʋ́ klɛ́ kʋlɛ, Mose klɛ́ kʋlɛ, Elia ɛ́ klɛ́ kʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Brɛ́á ɔdɛ asʋ́n ánfɩ blɩ́ á, agyinde wánkɩ́hɛ́ kʋ lobobun amʋ́sʋ́. Ɩnʋ ɔmɛ kʋ lɛdalɩ tsu agyinde ámʋtɔ ɔbɛ́ɛ, “Ɔ́nɩ gyí mɩ́ Bí ɔdwɛpʋ́á olegyi mɩ ansɩ́ nɩ́. Mlɩnu mʋ ɔmɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ifú lɛhɩɛ kɩ́tá amʋ́ brɛ́á bonu asʋ́n ánfɩ. Mʋ́ sʋ bɔwa ɔsa mlí bun ɔsʋlʋ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mʋ́ʋ́ Yesu lɛ́ba bɔpʋ ɩbɩ dada amʋ́, bláa amʋ́ ɔbɛ́ɛ, “Mlɩkʋsʋ, mlɩmánya ifú.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ɩnʋ bɔwa ansɩ́ kɩ a, bʋmɛtrá wun ɔhaa dʋn Yesu nkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Brɛ́á bʋdɛ ɩbʋ ámʋ kplɩ́ á, Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, bʋmábláa ɔhaa tɔ́á bayówun, yɔ́fʋn ɛkɛá Bulu ɔbɔ́kʋsʋ́a Nyankpʋsa-Mʋ-Bi ámʋ tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Ntogyi sʋ́ Mose mbla asunápʋ́ amʋ bɛɛ, ilehián ánɩ́ Elia obéyinkí bá asa Kristo amʋ ɔbɛ́ba?” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ igyi. Elia obégyankpá bá bɛla tógyítɔ́ yáɩ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ndɛ mlɩ bláa mbɛ́ɛ, Elia layínkí bá dodoodo, támɛ ɔhaa mɛ́bɩ mʋ. Bɔwa mʋ amʋmʋyɔ. Alɩ kɛ́n mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ nówun ɩwɩɔsɩn amʋ́ ɩbɩtɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɩnʋ á, ɩlɔwankɩ́ akasɩ́pʋ́ amʋ ánɩ́ Asú Ɔbɔpʋ́ Yohane ɩwɩ asʋ́n ɔdɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Brɛ́á beyinkí kplɩ́ bowie ɔdɔm amʋ wá á, oyin ɔkʋ lɛ́ba bɛda akpawunu Yesu ayabitɔ, bláa mʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mɩ́ Wíé, wun mɩ́ bí ánfɩ nwɛ, tsúfɛ́ ɩlɔ dɩ́dahɛ dɛ mʋ háan. Otetsíá dɩda wíé ntsu mʋ́a ogyátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɔpʋ mʋ ba fʋ́ akasɩ́pʋ́ amʋ, támɛ bʋmɛtalɩ́ tsá mʋ ɩlɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ndɛmba-abíá mlɩmá hógyi, mlɩ tsiátɔ́ ma alɛ. Alɩ́ nétsiá mlɩ wá yɔ́ ekekegyíɛkɛ nɩ́? Nnyá klʋn ha mlɩ yɔ́fʋn ɔmɛnkɛ? Mlɩkpa kebi ámʋ ba mɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɩnʋ ɔlɔkplʋ́n gya ɔŋɛ laláhɛ amʋ. Ɩlɛdalɩ kebi ámʋtɔ, ɩwɩ lɔ́wa mʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mʋ́ ɔma a, akasɩ́pʋ́ amʋ bɛfɩtɛ́ Yesu ɩtsɛ́tɔ́ bɛɛ, “Ntogyi sʋ́ anɩ mʋ́ anɩmɛ́talɩ́ gya ɔŋɛ laláhɛ amʋ dálɩ kebi ámʋtɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩ hógyi mɔtsɔ́ kʋ́ráá. Mbláa mlɩ ɔnɔkwalɩ. Nɩ́ mlɩ hógyi lomoní fɛ́ takyí-akpin ibí á, tɛkɩ mlɛ́talɩ́ bláa ɩbʋ ánfɩ mlɩaa ipúli. Lɛ́lɛ́ ibópulí, tɔtɔɔtɔ mɔ́ɔdʋn mlɩ bwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Brɛ́á akasɩ́pʋ́ amʋ fɛ́ɛ́ bɛba befia Galilea ɔmátɔ́ á, Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há adʋ́n bɔ́mɔ mɩ́, támɛ Bulu ɔbɔ́kʋsʋ́a mɩ ɛkɛ sáásɩ́.” Asʋ́n ánfɩ lɛhɩɛ han akasɩ́pʋ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu mʋa mʋ akasɩ́pʋ́ bɛba Kapernaum wúlutɔ. Ɩnʋ Bulu ɔtswɛ́kpa ofíkɔ ahɔ́pʋ akʋ bɛba bɛfɩtɛ́ Petro bɛɛ, “Fʋ́ wíe tɛká Bulu ɔtswɛ́kpa ofí ɩkɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔtɛká.” Brɛ́á Petro lɔ́yɔ wóyítɔ́ a, Yesu légyankpá fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Simon, nkálɩ gyí fʋ́ agywɩɩn? Amɛndɩ tɛ́ká dútɛ mʋ́a lampóo há awíe? Afɔɔ́ ntɛ́ɛ wúlu awíe?” ");
INSERT INTO nkoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Afɔɔ́ tɛká.” Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Yɛ́ɛ mʋ́mʋ́ wúlu awíe bagyi ɩwɩ nɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Támɛ mmedéklé mbɛ́ɛ, abɔ́kʋsʋ́ lɩ́ɩ́ amʋ́sʋ́ sʋ á, tsu ɔdadʋwa afʋyɔ ɔpʋ ɔnɔ́ yɔtswɩ. Kɩ klɛmɛtɩ́ gyankpapʋ ánɩ́ fɛ́lɛ ɔnɔ́tɔ́. Fénya kɔ́ba ánɩ́ ɩbɔ́fʋn anɩ abanyɔ́ ofíkɔ ámʋ ka. Lɛ mʋ́, afʋyɛka ha amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bɛba Kapernaum wúlutɔ, akasɩ́pʋ́ amʋ bɛba Yesu wá bɛfɩtɛ́ mʋ bɛɛ, “Ma gyí ɔhandɛ Bulu iwíegyí ámʋtɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu lɛ́tɩ kebi ɔkʋ bɛlɩɩ́ amʋ́ ansɩ́tɔ́, ");
INSERT INTO nkoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɔlɛblɩ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Nɩ́ mlɩmɛ́tsɛ, bwɛ ɩwɩ fɛ́ nyebí á, mlɩmóowie Bulu iwíegyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɔhagyíɔha ánɩ́ ɔlɛba ɩwɩasɩ fɛ́ kebi ánfɩ á, mʋgyí ɔhandɛ Bulu iwíegyí ámʋtɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɔhagyíɔha ánɩ́ ɔlɔhɔ kebiá ogyi alɩ mɩ́ dátɔ́ lahɔ mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nɩ́ ɔkʋ lɛ́ha ahá ánfɩ bʋmɔkʋ́dan mɩ́sʋ́ hógyitɔ ánfɩtɔ ɔkʋ lɔ́bwɛ lakpan á, nɩ́ bɛda nfúókwɛbʋ síán mʋ ɔmɛtɔ, tswɩ mʋ wá ɔpʋ okluklúkpá, mɔ́ mʋ pó á, ɩbʋ alɛ́ dʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɔyɩ́tɔ́ atsiápʋ́ bʋgyɔ́wɩ nɩ́. Tsúfɛ́ ɩtɔ́á ɩtɛhá ɔha tɔbwɛ́ lakpan bʋ ɩnʋ. Ɩbɛ́ba alɩ, támɛ ɔhá ánɩ́ ɩna mʋsʋ mʋ ba lɔ́bwɛ lakpan ɔgyɔ́wɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mʋ́ sʋ nɩ́ fʋ́ ɩbɩ ntɛ́ɛ fʋ́ yabi tɛ́há fʋtɛdɩda hógyitɔ á, ka mʋ́ lɛ, afʋtswɩ mʋ́ tsalɩfwɩ. Ɩbʋ alɛ́á fɔ́pʋ ɩbɩ kʋlɛ ntɛ́ɛ yabi kʋlɛ nyá nkpa ánɩ́ ɩtamatá, dʋn ánɩ́ fɔ́pʋ ɩbɩ anyɔ ntɛ́ɛ ayabi anyɔ wíé ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɩ́ fʋ́ nsíbi tɛ́há fʋ́tɔbwɛ́ lakpan á, loti mʋ́ lɛ, afʋtswɩ mʋ́ tsalɩfwɩ. Ɩbʋ alɛ́á fɔ́pʋ nsibi kʋlɛ nyá nkpa ánɩ́ ɩtamatá, dʋn ánɩ́ fɔ́pʋ ansibi anyɔ wíé ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Mlɩkɩ wankláán ánɩ́ mlɩmɛ́ɛkɩ nyebí pútúpútú ánfɩtɔ ɔkʋkʋ ansɩ́tɔ́ kótíkótí. Ndɛ mlɩ bláa mbɛ́ɛ, bʋbʋ Bulu-abɔpʋ ánɩ́ bʋtɔkɔ́sɩ́ pʋ́ amʋ́ asʋ́n ya mɩ́ Sɩ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mlɩyɔ asʋ́n ánfɩtɔ amlɩkɩ. Nɩ́ ɔkʋ bʋ akúfa lafakʋlɛ (100), amʋ́tɔ́ ɔkʋlɛ ɔfwɩ́ á, ntɔ ɔhá ámʋ tɔbwɛ́? Megyí si otesí adukwebá-kwebá (99) atráhɛ amʋ lɩ́ɩ́ okúku amʋsʋ, yódunká ɔkʋlɛ pɛ́ ámʋ́ʋ́ alafwɩ́ ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ɔnɔkwalɩ ndɛ mlɩ bláa. Nɩ́ owun mʋ a, mʋ ansɩ́ bégyi mʋ ɩwɩ dʋn adukwebá-kwebá atráhɛ amʋ́ʋ́ bʋmɔfwɩ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Alɩ kɛ́n mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ médékle ɔbɛ́ɛ, nyebí pútúpútú ánfɩtɔ ɔkʋkʋ ɛ́ ɔfwɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nɩ́ fʋ́ bá ohógyipʋ ɔpʋ́ ɩlá gyi fʋ á, yɔ mʋ wá, mlɩ abanyɔ́ pɛ́ amlɩblɩ mʋ́. Nɩ́ olonu ɩwɩasɩ á, falányá opíó. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Támɛ nɩ́ omonu ɩwɩasɩ á, kpa ɔbakʋ́lɛ ntɛ́ɛ abanyɔ́ manta ɩwɩsʋ amlɩyɔ mʋ wá, mɛ́nɩ bégyi asʋ́ngyíasʋ́n ánɩ́ mlɛ́blɩ́ ɩwɩ adánsɩɛ fɛ́ alɩá Bulu asʋ́n lɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nɩ́ omonu amʋ́ asʋ́n ɛ́ á, pʋ asʋ́n ámʋ ya mlɩ ɔpasuafɔ. Támɛ nɩ́ omonu amʋ́ asʋ́n ɛ́ á, mʋ́mʋ́ bu mʋ ɔmátɔ́yín ntɛ́ɛ lampóo ɔhɔ́pʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ɔnɔkwalɩ ndɛ mlɩ bláa. Asʋ́ngyíasʋ́n ánɩ́ mlékiná ɔsʋlʋ́ʋ anfɩsʋ á, Bulu obékiná mʋ́ ɔsʋ́sʋ́. Mʋ́á mlótsulá á, Bulu obótsulá mʋ́sʋ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ntráa ndɛblɩ́ mbɛ́ɛ, nɩ́ mlɩ abanyɔ́ mlɔbwɛ́ agywɩɩn kʋlɛ ɔsʋlʋ́ʋ anfɩsʋ kʋ́lɩ́ tɔkʋ á, mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ ɔbɔ́bwɛ mʋ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsúfɛ́ ɔtɩ́nɛgyíɔtɩ́nɛ́ ánɩ́ ahá abanyɔ́-abasá befia mɩ́ dátɔ́ á, mbʋ amʋ́ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mʋ́ʋ́ Petro lɛ́ba bɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, tsefɩnɩ nsíkie mɩ́ bá nɩ́ ɔpʋ́ ɩlá gyi mɩ? Tse sienɔ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ó-o, megyí tse sienɔ́ fésikíé mʋ, tsé aduesienɔ́ (70) aku asienɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ɩ́nɩ sʋ Bulu iwíegyí ámʋ igyi fɛ́ asʋ́n ánfɩ. Owíe ɔkʋ lɔ́bwɛ agywɩɩn ánɩ́ mʋa mʋ asúmpʋ́ bóbu akúnta. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Brɛ́á olefi mʋ́ asɩ á, mʋ asúmpʋ́ bɛkpa amʋ́tɔ́ ɔkʋá ɔdɛ mʋ ɩkɔ mpɩ́m-mpɩ́mtɔ́ ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Támɛ osúmpʋ́ amʋ má tɔtɔá ɔbɔ́pʋká ɩkɔ ámʋ sʋ á, owíe amʋ lɛ́ha ɔbɛ́ɛ bʋfɛ́ɛ mʋa mʋ ka, mʋ abí pʋ́ mʋ atɔ́ fɛ́ɛ́ pʋ́kɩ́tá ɩkɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɩnʋ á, osúmpʋ́ amʋ lɔ́kʋsʋ́ dá akpawunu owíe amʋ ayabitɔ, bwíí ɩpa há mʋ ɔbɛ́ɛ, ‘Mɩ́ Wíé, nya klʋn ha mɩ. Ɩbwɛ́ nɛ́ka fʋ́ ɩkɔ ámʋ fɛ́ɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mʋ asʋ́n lɔwa mʋ wie amʋ nwɛ. Mʋ́ sʋ olesi ɩkɔ ámʋ fɛ́ɛ́ kíé mʋ, há mʋ ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Támɛ brɛ́á osúmpʋ́ amʋ lɛ́dalɩ ɩnʋ á, ɔlɔyɔ́tʋ mʋ osúmba ɔkʋá ɔdɛ mʋ ɩkɔ kpalobí kʋ. Ɔlɛkɩtá mʋ ba ámʋ ɔmɛtɔ kínkíínkín, bláa mʋ ɔbɛ́ɛ, ‘Pʋ mɩ́ kɔ́ba ha mɩ!’ ");
INSERT INTO nkoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mʋ osúmba amʋ ɛ́ lɛ́da akpawunu bwíí ɩpa há mʋ, bláa mʋ ɔbɛ́ɛ, ‘Nya klʋn ha mɩ. Ɩbwɛ́ nɛ́ka fʋ́ kɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Támɛ osúmpʋ́ anfɩ mʋ́ mótsulá. Ɔlɛha ánɩ́ bʋpʋ́ʋ mʋ yɔwa obu yɔ́fʋn ɛkɛá ɔbɛ́ka mʋ ɩkɔ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mʋ asúmba bowun tɔ́á alapʋ́gyi mʋ ba ámʋ a, ilowie amʋ́ ɩwɩtɔ. Mʋ́ sʋ bɔyɔ yɛ́bláa amʋ́ wíe asʋ́n ámʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mʋ́ʋ́ amʋ́ wíe amʋ lɛ́ha bɛtɩ osúmpʋ́ amʋ ba, ɔlɛbláa mʋ ɔbɛ́ɛ, ‘Osúmpʋ́ owuntɔlɩnpʋ, fʋ́ ɩpabwií sʋ nesi ɩkɔ tsɔtsɔɔtsɔ ámʋ́ʋ́ fʋ́dɛ mɩ́ ámʋ fɛ́ɛ́ kíé fʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ɩma alɛá fʋ́ mʋ́ fówun fʋ́ bá ámʋ nwɛ fɛ́ alɩá nowun fʋ nwɛ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɔblɔ́ lɛkɩtá owíe amʋ. Mʋ́ sʋ ɔlɛha ɔbɛ́ɛ, bʋwáa mʋ obu, abʋpɩtɩ mʋ atɔ́ yɔ́fʋn ɛkɛá ɔbɛ́ka ɩkɔ ámʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Alɩ́ mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ ɔbɔ́bwɛ mlɩtɔ okugyíɔkʋá omesi mʋ ba lakpan kíé mʋ tsú mʋ klʋntɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Brɛ́á Yesu lɔ́tɔɩ́ tá á, ɔlɛnatɩ́ Galilea ɔmátɔ́ yɔ́ Yudea ɔmátɔ́ Yordan ntsu ámʋ ɔbɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ɔdɔm kpɔnkpɔɔnkpɔntɩ bobuo mʋ, ɔlɛtsa amʋ́ ɩlɔ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisifɔ akʋ bɛba mʋ wá bɔsɔ mʋ kɩ, fɩ́tɛ́ mʋ bɛɛ, “Anɩ Mbla lɛ́ha ɔkpa ánɩ́ oyin ɔbɛ́talɩ́ kíná mʋ ka ɔkpagyíɔkpasʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmɔ́kʋ́kla Bulu asʋ́n ámʋ kɩ ánɩ́ brɛ́ ámʋ́ʋ́ Bulu léfi ɔyɩ́ asɩ á, ɔtsɩ mʋ́a oyin ɔ́lɔbwɛ? ");
INSERT INTO nkoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bulu lɛ́blɩ́ ɔbɛ́ɛ, ‘Ɩ́nɩ sʋ oyin obótu sí mʋ sɩ mʋa mʋ yin yɛ́mantá mʋ kasʋ, amʋ́ abanyɔ́ bɔ́bwɛ ɔyʋlʋ́ʋ kʋlɛ nɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, bʋtráa bʋmegyí abanyɔ́, támɛ babwɛ́ ɔbakʋ́lɛ. Ahá ánɩ́ Bulu labwɛ́ amʋ́ ɩkʋlɛ a, ɔhaa mámaɩ́n amʋ́ abasʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisifɔ ámʋ bɛfɩtɛ́ mʋ bɛɛ, “Ntogyi sʋ́ Mose lɔ́wa mbla ɔbɛ́ɛ, oyin ɔbɛ́talɩ́ wánlɩ́n ɔkákiná ɔwʋlʋ́ pʋ́kíná mʋ ka?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ klʋntɔ odwin sʋ́ Mose lɛ́ha mlɩ ɔkpa ɔbɛ́ɛ, mlɩkína mlɩ aká, tɛkɩ megyí alɩ Bulu lɔ́bwɛ mʋ́ brɛ́á olefi ɔyɩ́ ámʋ asɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Támɛ ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ oyin okíná mʋ ka láyétsiá ɔtsɩ bámbá á, alatɔ́ mbʋa. Ɔkpa oduásʋ́á oyin ɔbɛ́talɩ́ kíná mʋ ka pɛ́ gyí aladálɩ mʋ ɔma.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mʋ́ʋ́ mʋ akasɩ́pʋ́ amʋ bɛblɩ́ bɛɛ, “Nɩ́ alɩ okúlu mʋa ɔká abatsiátɔ asʋ́n igyi nɩ́ mʋ́ á, mʋ́mʋ́ ɩma alɛ́á oyin mʋa ɔtsɩ bétsiá aba pó.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Megyí ahá fɛ́ɛ́ ɔbɛ́talɩ́ hɔ atosunáhɛ́ anfɩ. Nkɛ́tɩ ahá ánɩ́ Bulu lɔ́pʋhá amʋ́ pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tsúfɛ́ ɩna ɔkpa tsɔtsɔɔtsɔsʋ ayin akʋ bʋtamatsía aká. Ayin ámʋ akʋ á, alɩ́ bɔkwɩɩ́ amʋ́ nɩ́. Akʋ ɛ́ anyánkpʋ́sa láflo amʋ́. Akʋ ɛ́ basin kpankʋ Bulu iwíegyí ámʋ sʋ. Ɔhá ánɩ́ ɔbɛ́talɩ́ á, ɔhɔ́ɔ mɩ́ atosunáhɛ́ anfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aha akʋ bɛkpa nyebí ba Yesu bɛɛ, ɔpʋ́ʋ ɩbɩ dɩnka amʋ́sʋ́, ɔkʋlɩ Bulu oyúla ha amʋ́. Támɛ akasɩ́pʋ́ amʋ bɔwa ɩyɩn wá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mʋ́ʋ́ Yesu lɛ́bláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha nyebí ámʋ ɔkpa abʋba mɩ́ wá. Mlɩmátin amʋ́ ɔkpa, tsúfɛ́ ahá ánfɩ odu bʋ́ Bulu iwíegyí ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mʋ́ʋ́ ɔlɔpʋ ɩbɩ dɩ́ndɩ́nka amʋ́sʋ́, ɔlɛnatɩ́ ɩnʋ á. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɛkɛ ɔkʋ oyin ɔkʋ lɛ́ba Yesu wá bɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Osunápʋ́, yilé mɔmʋ nɔ́bwɛ asa nénya nkpa ánɩ́ ɩtamatá?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntogyi sʋ́ fʋdɛ mɩ́ yilé ɩwɩ asʋ́n fɩtɛ́? Ɔbakʋ́lɛ pɛ́ gyí ɔha yilé. Mʋgyí Bulu. Támɛ nɩ́ fʋdekléá fʋnyáa nkpa ánɩ́ ɩtamatá á, mʋ́mʋ́ gyi Bulu mbla asʋ́n ámʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oyin ámʋ lɛ́lafɩ́tɛ́ mʋ ɔbɛ́ɛ, “Mʋ́tɔ́ mɔmʋ?” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mámɔ ɔha, mátɔ mbʋa, máwi atɔ́, máka asʋ́n dɩ́nká fʋ́ básʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bu fʋ́ sɩ́ mʋa fʋ́ yín, afʋdwɛ fʋ́ bá fɛ́ fʋ́ ɩwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɔyasubi ámʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Ntegyi mʋ́ fɛ́ɛ́sʋ́. Ntɔ ɛ́ ntráa bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ fʋdekléá fɔ́fʋn mʋ́ á, yɛfɛ fʋ́ ɩwɩsʋ atɔ́ fɛ́ɛ́, afʋye kɔ́ba amʋ ha ahiánfɔ, mɛ́nɩ fénya siadɩɛ ɔsʋ́sʋ́. Fɔbwɛ́ mʋ́ tá á, ba afʋbobuo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Brɛ́á ɔyasubi ámʋ lónu asʋ́n ánfɩ á, ɩlɛhɩɛ́ han mʋ, ɔlɛnatɩ́ díín, tsúfɛ́ ɔhɩ́ɛ́ ɔbʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mʋ́ʋ́ Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, ɩbɛ́hɩɛ wá ɔnlɩn asa ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ntráa ndɛ mlɩ bláa mbɛ́ɛ, ɩlɔpɔn ha kpɔ́sɔ́ ánɩ́ ɔbɔ́tsʋn ɔbɩn-atɔ ɔbɔ́tɔ́, dʋn ánɩ́ ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Akasɩ́pʋ́ amʋ bonu asʋ́n ánfɩ á, ɔnɔ́ lobwie amʋ́. Ɩ́nɩ sʋ bɛfɩtɛ́ bɛɛ, “Mʋ́mʋ́ ma mɛɛ Bulu ɔbɔ́hɔ nkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ɩnʋ Yesu lɛ́lɩɩ́ kɩ amʋ́ alɩɩ. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Anyánkpʋ́satɔ mʋ́ á, ɔhaa mɛ́ɛtalɩ́ bwɛ́ ɩ́nɩ, támɛ Bulu mʋ́ tɛtálɩ́ bwɛ́ tógyítɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mʋ́ʋ́ Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ɩ́nɩá anɩlasí tógyítɔ́ tswɩ bobuo fʋ á, ntɔ abénya tsú fʋ́ búotɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Brɛ́á Bulu ɔbwɛ́ ɔyɩ́ pɔpwɛ amʋ, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ netsíá mɩ́ numnyam owíe obíá ámʋsʋ á, mlɩ ahá ánfɩ mlɩbuo mɩ ánfɩ ɛ́ mlétsiá awíe mbíá dúanyɔsʋ, gyi Israel abusuan dúanyɔ ámʋ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɔhagyíɔha ánɩ́ alanátɩ́ sí mʋ wóyí, mʋ apíó, mʋ sɩ mʋa mʋ yin, mʋ abí ntɛ́ɛ ɔsʋlʋ́ʋ mɩ́ sʋ á, Bulu ɔbɛ́la há mʋ mʋ́ tsé dú tsé lafa, trá lahá mʋ nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Támɛ agyankpapʋ akʋ bɛ́ba bemlí amapʋ, amapʋ amʋ akʋ ɛ́ bébemlí agyankpapʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu lɛ́trá bláa amʋ́ ɔbɛ́ɛ, “Mʋ́ sʋ Bulu iwíegyí ámʋ igyi fɛ́ asʋ́n ánfɩ. Ɔdɔtɔpʋ ɔkʋ létsiá. Ɛkɛ ɔkʋ ɔlɔkʋsʋ́ nyankɩ-nyankɩ ɔyɔ́ ɩpa agyípʋ́ odunkákpá, abʋyɔyɔ agyʋ́má mʋ ndɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mʋa amʋ́nyɔ begyi bíá ánɩ́ ɔbɛ́ka amʋ́ alɩá bʋtɔhɔ ɛkɛwʋ́lɛ, ɔlɔpʋ amʋ́ sɩ́sɩ́ agyʋ́má ámʋ ɔyɔkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dokwebátɔ́ a, ɔlɛdalɩ yɔ dɩnsʋ, oloyówun akʋ ɛ́ bʋlɩɩ́, bʋmɛdɛ́ tɔtɔ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Olotsu amʋ́ ɛ́ ɔbɛ́ɛ bʋyɔ́yɔ agyʋ́má mʋ ndɔtɔ ha mʋ. Ɩbwɛ́ ɔbɛ́ka amʋ́ tɔ́á ɩbʋ alɛ́. Mʋ́ sʋ bɔyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dódúanyɔ pʋ́ dɔsatɔ ɛ́ á, ɔlɛtrá pʋ akʋ sɩ́sɩ́ ndɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ntʋ́pwɛ donutɔ, brɛ́á ɔlɛdalɩ a, ɔlɛtrá wun akʋá bʋlɩɩ́ kpaalɩ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, ‘Ntogyi sʋ́ ndɛ fɛ́ɛ́ mlɩlɩ́ɩ́ nfɩ, mlɩmɛ́dɛ́ tɔtɔ bwɛ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bɛbláa mʋ bɛɛ, ‘Ɔhaa mɔ́kʋ́bɔ́ anɩ ɩpa.’ Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, ‘Mʋ́mʋ́ mlɩ ɛ́ mlɩbɔtsʋn yɔyɔ agyʋ́má mɩ́ ndɔtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Brɛ́á owí lɔpɔn a, ɔdɔtɔpʋ amʋ lɛ́tɩ mʋ agyʋ́másʋ́ ɔkɩ́pʋ bláa mʋ ɔbɛ́ɛ, ɔtɩ́ɩ ɩpa agyípʋ́ ámʋ fɛ́ɛ́, ɔkáa amʋ́ akɔ. Ɔkáa amʋ́ tsu amapʋ amʋsʋ alɩɩ bɔtʋ agyankpapʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Brɛ́á ɩpa agyípʋ́ amʋ bɛba a, agyʋ́másʋ́ ɔkɩ́pʋ amʋ lɛ́ka ahá ámʋ́ʋ́ bɔyɔ donutɔ ámʋ alɩá bʋtɔhɔ ɛkɛwʋ́lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Brɛ́á ɩlɔtʋ agyankpapʋ amʋ a, bʋkɩ bɛɛ bénya dʋn alɩ, támɛ alɩ kɛ́n ɔlɛka amʋ́ ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mʋ́ sʋ ɔlɛka amʋ́ akɔ tá á, agyankpapʋ amʋ bɔwa tɔtɔ́ɩ ɔdɔtɔpʋ amʋsʋ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bɛblɩ́ bɛɛ, ‘Amapʋ anfɩ mʋ́ á, dɔnhwɩ́rɩ kʋlɛ pɛ́ bɔyɔ agyʋ́má. Anɩ mʋ́ anɩlalɩ́ɩ́ owí kpankpli ánfɩsʋ yɔ́ agyʋ́má, támɛ faká anɩa amʋ́nyɔ fɛ́ɛ́ akɔ kʋlɛ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ɔdɔtɔpʋ amʋ lɛ́bláa amʋ́tɔ́ ɔkʋlɛ ɔbɛ́ɛ, ‘Agya, yɛ́ɛ mmɔkʋ́tafá fʋ o! Megyí ɩtɔ́ ámʋ́ʋ́ mɩ́a fʋnyɔ anɩlɛ́blɩ́ ámʋ napʋ́há fʋ́ á? ");
INSERT INTO nkoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pʋ fʋ́ atɔ́ natɩ. Mɩ́déklé mbɛ́ɛ, nɛ́ha amapʋ amʋ alɩá naká fʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mma ɔkpa ánɩ́ nɔ́pʋ mɩ́ kɔ́ba bwɛ́ tɔ́á ndeklé? Ntɛ́ɛ mɩ́ awɩtɔlɛwa dɛ́ fʋ́ ɩwɩtɔ wie?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Alɩ́ amapʋ bɔ́bwɛ agyankpapʋ, agyankpapʋ ɛ́ bɔ́bwɛ amapʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Brɛ́á Yesu ɔyɔ́ Yerusalem a, ɔlɛkpa akasɩ́pʋ́ dúanyɔ ámʋ ya ɩtsɛ́tɔ́ bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mlɩnu! Ayɔ́ Yerusalem. Ɩnʋ á, bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́. Bɛ́ha mɩ́ lowu ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bɔ́pʋ mɩ́ wá ahá ánɩ́ bʋmegyí Yudafɔ ɩbɩtɔ bɔ́bwɛ mɩ́ ahinlá, bɔ́nwɛn mɩ́ mplɩ, dá mɩ́ mántá oyikpalíhɛsʋ. Támɛ Bulu ɔbɛ́lakʋ́sʋ́a mɩ ɛkɛ sáásɩ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mʋ́ʋ́ Sebedeo mʋ ka lɛ́kpa mʋ abi anyɔ bɛba, ɔlɛda akpawunu Yesu ayabitɔ, kʋ́lɩ́ mʋ ɔbɛ́ɛ, ɔbwɛ́ɛ tɔkʋ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntɔ fʋdeklé?” Ɔtsɩ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Ha mɩ́ abi anyɔ ánfɩtɔ ɔkʋlɛ otsia fʋ́ gyɔpɩsʋ, ɔkʋlɛ ɛ́ otsia fʋ́ bɩnasʋ brɛ́á fʋ́dɛ iwíe gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩméyín tɔ́á mlɩdɛ́kʋlɩ́.” Ɔlɛfɩtɛ́ Yohane mʋa Yakobo ɔbɛ́ɛ, “Mlɛ́talɩ́ wun ɩwɩɔsɩn ámʋ́ʋ́ nɛbá bowun amʋ?” Bɛbláa mʋ bɛɛ, “Ee, abɛ́talɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlówun ɩwɩɔsɩn ámʋ mʋ́, támɛ mma túmi ánɩ́ nɛ́lɛ ahá ánɩ́ bétsiá mɩ́ gyɔpɩsʋ ntɛ́ɛ mɩ́ bɩnasʋ. Otsiákpá ɩnʋ ɩda gyo ahá ámʋ́ʋ́ mɩ́ Sɩ́ Bulu lalá ɩnʋ yáɩ́ há ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Brɛ́á akasɩ́pʋ́ dú atráhɛ amʋ bonu asʋ́n ánfɩ á, Yakobo mʋa Yohane ɩwɩ lɔ́wa amʋ́ ɔblɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mʋ́ʋ́ Yesu lɛ́tɩ amʋ́, bláa amʋ́ ɔbɛ́ɛ, “Mlɩyin ánɩ́ ɔmátɔ́fɔsʋ agyípʋ́ bʋtɛhɩ́ɛ́ amʋ́ ahá, amʋ́ ahandɛ ɛ́ bʋtenyá túmi amʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Támɛ mlɩtɔ mʋ́ á, ɩmába alɩ. Ɔhagyíɔha ánɩ́ odekléá ɔbɔ́bwɛ mlɩtɔ ɔhandɛ a, ɔbwɛ́ɛ mʋ ɩwɩ osúmpʋ́ ha mʋ aba atráhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ɔhá ánɩ́ odekléá ɔbɔ́bwɛ mlɩ nkpá ogyápʋ ɔbwɛ́ɛ mlɩ ɔkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Alɩ kɛ́n mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ mmɛba mbɛ́ɛ, bʋsúm mɩ́ nɩ́. Ahá osúmkpá nɛba, ampʋ mɩ́ nkpa hɔ ahá tsɔtsɔɔtsɔ nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ bʋdɛdalɩ Yeriko wúlutɔ bɔyɔ́ á, ɔdɔm kpɔnkpɔɔnkpɔntɩ bobuo amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ansibi abwiepʋ́ abanyɔ́ akʋ bʋtsie ɔkpa ámʋtɔ, bonu ánɩ́ Yesu dɛ́tsʋ́ʋn. Ɩnʋ bɔkplʋ́n blɩ́ bɛɛ, “Anɩ Wíe, Dawid mʋ na, wun anɩ nwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɔdɔm amʋ bɔkplʋ́n wa amʋ́ bɛɛ bʋkpá ɔnɔ́ bun. Támɛ bɛlakplʋ́n dʋn alɩ bɛɛ, “Anɩ Wíe, Dawid mʋ na, wun anɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mʋ́ʋ́ Yesu lési lɩɩ́, tɩ́ amʋ́, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ mlɩdéklé mlɩaa, mbwɛ́ɛ ha mlɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bɛbláa mʋ bɛɛ, “Anɩ Wíe, ha anɩ awun atɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɩnʋ amʋ́ asʋ́n lɔ́wa Yesu nwɛ, ɔlɔpʋ mʋ ɩbɩ dada amʋ́ ansíbi. Ɩnʋnʋ bowun atɔ́, bɛkplá buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ bɛbɛ́ɛn Yerusalem wúlu, bɛta Betfage wúlu ánɩ́ ɩbʋ Nfɔ-nyíbʋ ámʋ asɩ wie tá á, ɔlɔwa mʋ akasɩ́pʋ́ abanyɔ́ gyankpá. Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ wúlu anfɩ́ ɩda mlɩ ansɩ́tɔ́ ánfɩsʋ. Nɩ́ mlowíé wúlu amʋ ɔnɔ́ á, mlówun afrímú tsɩ́hɛ́ ɔkʋá ɔda ɔfɛ́tɔ́, mʋ bi lɩ́ɩ́ mʋ wá. Mlɩsankɩ mʋ, amlɩkpa amʋ́ ba mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɩ́ ɔkʋ ɔfɩ́tɛ́ mlɩ asʋankʋ á, mlɩbla mʋ mlɩaa, ‘Anɩ Wíe dɛ́ amʋ́ hián.’ Ɩnʋnʋ ɔbɛ́ha mlɔ́pʋ amʋ́ ba mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɩ́nɩ lɛ́ha Bulu asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́sʋ ámʋ lɛ́ba mʋ́tɔ́. Ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mlɩbla Sionfɔ mlɩaa, Mlɩkɩ, mlɩ Wíe ɔbá mlɩ wá. Ololwií, ɔdɩn afrímúsʋ́. Ɔdɩn afrímú ibí yínhɛ́sʋ́ ɔbá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu akasɩ́pʋ́ abanyɔ́ ámʋ bɔyɔ́bwɛ alɩ ámʋ́ʋ́ Yesu lɛ́bláa amʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bɛkpa afrímú mʋa mʋ bi ámʋ ba, bɛyaɩ́ amʋ́ atati dɩ́nká amʋ́sʋ́, ɔlɔdʋ bian mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛyaɩ́ amʋ́ atati tswɩ ɔkpatɔ, akʋ ɛ́ bebiabía afɩtáa bunbun ɔkpa ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɔdɔm amʋ́ʋ́ bʋgya Yesu nkpá mʋ́a ɔma amʋ bɔsʋrá okitikíti bɛɛ, “Hosiána há Dawid mʋ na ámʋ! Bulu oyúla owíe anfɩ ɔbá mʋ dátɔ́ ánfɩ! Hosiána bʋ ɔsʋ́sʋ́ʋ́sʋ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Brɛ́á Yesu lówie Yerusalem a, wúlu amʋtɔ fɛ́ɛ́ lɛda kpokiti, bʋdɛfɩtɛ́ bɛɛ, “Ma gyí ɔhá ánfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɔdɔm amʋ́ʋ́ bʋbuo mʋ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ɔ́nɩ gyí Yesu, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ amʋ́ʋ́ otsú Nasaret wúluá ɩbʋ Galilea ɔmátɔ́ ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mʋ́ʋ́ Yesu lɔ́yɔ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, yégya atɔ́ afɛpʋ́ pʋ́ atɔ́ ahɔ́pʋ fɛ́ɛ́ dalɩ. Olowuwúta kɔ́ba atsɛ́pʋ mpʋ́nʋ́ dá, súnsúnki abrɔ́dʋma afɛpʋ́ ɛ́ mbíá dá. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Bɛ́tɩ mɩ́ ɔtswɛ́kpa bɛɛ, mpáɩ ɔbɔkpá.’ Támɛ mlɩlapʋ́ ɩnʋ mlí awikplu ɔŋaínkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ansibi abwiepʋ́ pʋ́ abubúpʋ akʋ bɛba mʋ wá Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, ɔlɛtsa amʋ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Brɛ́á Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ amʋ bowun ofúla ánɩ́ Yesu dɛ́bwɛ, pʋ́ alɩá nyebí bʋdɛkplʋ́n Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ bɛɛ, “Hosiána há Dawid mʋ na ámʋ!” a, ɔblɔ́ lɛkɩtá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mʋ́ sʋ bɛfɩtɛ́ Yesu bɛɛ, “Fʋmedénu asʋ́n ánɩ́ nyebí ánfɩ bʋdɛblɩ́?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ndenu. Mlɩmɔ́kʋ́kla asʋ́n ánɩ́ Bulu asʋ́n wanlɩ́nhɛ́ amʋ lɛ́blɩ́? Ɔbɛ́ɛ, ‘Fasúná nyebí pʋ́ amʋ́á bʋmɔkʋ́tɩn nyɔ́pʋ alɩá bʋkánfʋ fʋ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu lɛ́dalɩ wúlu amʋtɔ sí amʋ́ yɔ́ Betania. Ɩnʋ́ ɔlɛdɩ ɛkɛ ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ɔyɩ kɛhɛ nyankɩ, brɛ́á Yesu léyinkí ɔbá Yerusalem a, akʋ́n dɛ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mʋ́ sʋ brɛ́á olowun pɔntɔ kʋá ɩlɩɩ́ mantáa ɔkpa á, ɔlɛbaɩ́ yɔ́ mʋ́ asɩ. Ɔlɔyɔ á, omowun abí kʋkʋ mʋ́tɔ́, afɩtáa sɔ́ɔ́n bʋ mʋ́sʋ́. Ɩnʋ ɔlɛbláa pɔntɔ ámʋ ɔbɛ́ɛ, “Tsú ndɛ fʋmɛ́ɛtrá swie abí ɛkɛkɛɛkɛ!” Ɩnʋnʋ oyí ámʋ lówu. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mʋ akasɩ́pʋ́ amʋ bowun alɩá oyí ámʋ labwɛ́ á, ɔnɔ́ lobwie amʋ́. Mʋ́ sʋ bɛfɩtɛ́ bɛɛ “Ntogyi sʋ́ oyí ánfɩ lawú ɔtsáwʋlɛ pɛ́ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Nɩ́ mlɔhɔ Bulu gyi, mlɩmégyi nwɛ́ɛn a, mlɛ́talɩ́ bwɛ́ ɩtɔ́ ánfɩ nabwɛ́ oyí ánfɩ pʋ́ mʋ́á ɩdʋn mʋ́. Mlɛ́talɩ́ bláa ɩbʋ ánfɩ mlɩaa, ‘Puli yowie ɔpʋtɔ.’ Ibópulí yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɩ́ mlɔhɔ Bulu gyi, mlɔkʋ́lɩ́ mʋ tógyítɔ́ á, mlɩ ɩbɩ bɛ́da mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu léyinkí bowie Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ. Brɛ́á ɔdɛ atɔ́ suná á, Bulu igyi ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛba mʋ wá. Bɛfɩtɛ́ mʋ bɛɛ, “Ma lɛ́ha fʋ́ ɔkpa, fʋ́dɛ ntobí ánfɩ bwɛ? Ma lɛ́ha fʋ́ túmi?” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ ɛ́ nfɩ́tɛ mlɩ asʋn kua kʋlɛ. Nɩ́ mlɛlɛ́ mʋ́ ɔnɔ́ á, nɛ́bláa mlɩ túmi oduá ndɛpʋbwɛ́ ntobí ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bulu wá Asú Ɔbɔpʋ́ Yohane lénya túmi pʋ́bɔ́ ahá asú, ntɛ́ɛ nyankpʋsa?” Amʋ́ wʋlɛwʋlɛ bɔyɔ asʋ́n ánfɩtɔ bɛɛ, “Nɩ́ ablɩ́ anɩaa itsú Bulu wá á, ɔbɛ́fɩtɛ́ anɩ ɔbɛ́ɛ, mʋ́ ntogyi sʋ́ anɩmɔ́hɔ mʋ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ntɛ́ɛ ablɩ́ɩ anɩaa, anyánkpʋ́sa wá itsú.” Támɛ bʋdɛ tɔ́á ahá tsɔtsɔɔtsɔ ámʋ bɔ́bwɛ amʋ́ ifú nya. Tsúfɛ́ amʋ́ fɛ́ɛ́ bohogyi ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yohane gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mʋ́ sʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ohwée! Anɩméyín ɔtɩ́nɛ́á olenya mʋ túmi tsú.” Mʋ́ʋ́ Yesu ɛ́ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mɩ́ ɛ́ mmɛ́ɛbláa mlɩ túmi oduá ndɛpʋbwɛ́ ntobí ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mlɩyɔ asʋ́n ánfɩtɔ amlɩkɩ. Oyin ɔkʋ mʋa mʋ abi anyɔ betsiá. Ɛkɛ ɔkʋ ɔlɔyɔ yɛ́bláa ɔdɛ́hɛn ɔbɛ́ɛ, ‘Mɩ́ bí, ndɛ yɔyɔ agyʋ́má mɩ́ ndɔtɔ ha mɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɔlɛbláa mʋ sɩ ɔbɛ́ɛ, ‘Mmɔ́ɔyɔ.’ Mʋ́ ɔma a, ɔlɛlatsɛ mʋ agywɩɩn, yɔ́ ndɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Amʋ́ sɩ́ lɛ́natɩ́ yɔ́ ɔkʋsʋ amʋ ɛ́ wá yɛ́bláa mʋ alɩ kɛ́n. Ɔkʋsʋ amʋ lótsulá ɔbɛ́ɛ, ‘Mɩ́ sɩ́, nɔ́yɔ.’ Támɛ ɔmɔyɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ɩnʋ Yesu lɛ́fɩtɛ́ ahá ámʋ ɔbɛ́ɛ, “Abi anyɔ ámʋtɔ ɔmɔmʋ lɔ́bwɛ dɩ́nká mʋ sɩ asʋ́nsʋ́?” Yudafɔ igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛbláa mʋ bɛɛ, “Ɔdɛ́hɛn amʋ.” Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Lampóo ahɔ́pʋ pʋ́ obu-ɔnɔ́ atsiápʋ́ bówie Bulu iwíegyí ámʋtɔ sí mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tsúfɛ́ Asú Ɔbɔpʋ́ Yohane lóbosuná mlɩ tsiátɔ́ oduá ɩda ɔkpa Bulu ansɩ́tɔ́, támɛ mlɩmɔ́hɔ mʋ gyi. Lampóo ahɔ́pʋ pʋ́ obu-ɔnɔ́ atsiápʋ́ bɔhɔ mʋ gyi. Ɔma mlɩlówun ánɩ́ amʋ́ kʋ́ráá batsɛ a, mlɩmɛ́tsɛ mlɩ agywɩɩn hɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mlɩnu yébi ɩkʋ ɛ́. Ɔdɔtɔpʋ ɔkʋ lɔ́dɔ wáɩn ndɔ. Olegyi ɩban bómlí mʋ́. Olokwi wáɩn amʋ onyimɛ́kpá. Ɔlɔpwɛ obu fʋ́áhɛ́ kʋ há ndɔ ámʋ agyópʋ. Mʋ́ʋ́ ɔlɔpʋ ndɔ ámʋ wá apafɔ ɩbɩtɔ, olotu ɔkpa yɔ́ ɔmá ɩkʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Brɛ́á wáɩn-abí amʋ kpɔtɩ́bɩ lɔ́fʋn a, ɔlɔwa mʋ asúmpʋ́ apafɔ ámʋ wá ɔbɛ́ɛ, bʋyɔ́hɔ mʋ ogyíkpá ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Támɛ apafɔ ámʋ bɛkɩtá amʋ́, dá ɔkʋlɛ, mɔ́ ɔkʋlɛ, dá ɔkʋlɛ ɛ́ abwi. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ndɔ mʋ wie amʋ lɛ́trá wa mʋ asúmpʋ́ bámbá ánɩ́ bʋtsɔ dʋn agyankpapʋ amʋ. Apafɔ ámʋ bɔbwɛ amʋ́ ɛ́ alɩ kɛ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mʋ́ tráhɛ kʋ́ráá á, ɔlɛblɩ́ ɔbɛ́ɛ, ‘Oo, bóbu mɩ́ bí kwɩ́ɩ́hɛ́ mʋ́.’ Mʋ́ sʋ ɔlɔwa mʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Támɛ brɛ́á apafɔ ámʋ bowun mʋ bi ámʋ sɩ́sɩ́ á, bɛbláa aba bɛɛ, ‘Ɔ́nɩ obégyi mʋ sɩ atɔ́ nɩ́. Mlɩha amɔ mʋ, mɛ́nɩ ndɔ ámʋ ibémlí anɩ klɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mʋ́ sʋ bɛkɩtá mʋ, bɩ́tɩ́a mʋ dálɩ ndɔ ámʋtɔ yɔ́mɔ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nɩ́ ndɔ mʋ wie ɔbá á, ntɔ mlɩlahogyi mlɩaa, ɔbɔ́bwɛ apafɔ ánfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yudafɔ igyi ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ɔbɛ́ha aha laláhɛ anfɩ bówu lowu sɩ́nsɩ́n, ɔbɛ́lapʋ́ ndɔ ámʋ wá apafɔ bámbá ɩbɩtɔ. Amʋ́á bétsiá pʋ́ mʋ atɔ́-abí ba mʋ mʋ́ kpɔtɩ́bɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɛ́ɛ mlɩmɔ́kʋ́kla Bulu asʋn wanlɩ́nhɛ́ amʋ kɩ? Bɔwanlɩ́n bɛɛ, ‘Ibwi ámʋ́ʋ́ obu ayípʋ bekiná ámʋ lébemlí okonkísʋ́bwi nɩ́. Bulu lɔ́bwɛ mʋ́ alɩ. Ɩbʋ wánwan.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɔ́hɔ mʋ iwíegyí ámʋ lɛ́ mlɩ ɩbɩtɔ pʋ́há ɔmá ánɩ́ bɔbwɛ tɔ́á otekle. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Ɩ́nɩ sʋ ɔhá ánɩ́ ɔlɛdɩda ibwi ámʋsʋ obébiabía blúblúblúblú. Nɩ́ ibwi ámʋ isúnkí dá ɔkʋsʋ ɛ́ á, ɩbɔ́kwɛ mʋ fɩ́kɔ́fɩ́kɔ́fɩ́kɔ́ fɛ́ nfúó.” ");
INSERT INTO nkoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Brɛ́á Bulu igyi ahapʋ́ dɛhɛn pʋ́ Farisifɔ ámʋ bonu Yesu ayébi anfɩ á, ɩlɔwankɩ́ amʋ́ ánɩ́ amʋ́ ɔdɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tɛkɩ bekleá bɛ́kɩtá mʋ, támɛ benya ifú, tsúfɛ́ ɔdɔm amʋ bʋtobú Yesu ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Yesu lɛ́trá bláa Yudafɔ igyi ahapʋ́ pʋ́ Yudafɔ ahandɛ amʋ asʋ́n yébitɔ ɔbɛ́ɛ, “Bulu iwíegyí ámʋ igyi fɛ́ asʋ́n ánfɩ. Owíe ɔkʋ dɛ́ ɔtsɩ kpaɩ́n há mʋ bi, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ɔlɛtɩ ahá ɔbɛ́ɛ, bʋbá nkɛ ámʋ asɩ. Brɛ́á owíe ámʋ lɔ́bwɛ tá á, ɔlɔwa mʋ asúmpʋ́ ɔbɛ́ɛ, bʋyɛ́tɩ ahá ámʋ abʋba, támɛ bekiná bá. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mʋ́ sʋ ɔlɛlawá mʋ asúmpʋ́ bámbá ɔbɛ́ɛ, ‘Mlɩtra yɛbláa ahá ámʋ mlɩaa, nabwɛ́ tógyítɔ́ tá. Bamɔ́ mɩ́ nnantswie akpɔnkpɔntɩ ámʋ pʋ́ amʋ́á bawá nfɔ, nɩ́ná atɔ́ ámʋ fɛ́ɛ́ tá. Mʋ́ sʋ bʋbá ɔtsɩ ɔkpaɩ́nkpá ɩnʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Támɛ ahá ámʋ́ʋ́ bɛyɛ́tɩ ámʋ bʋmɛkplá amʋ́. Bɛnatɩ́ sí amʋ́ yɔ́ amʋ́ agyʋ́másʋ́. Akʋ bɛnatɩ́ yɔ́ amʋ́ ndɔtɔ. Akʋ ɛ́ bɛnatɩ́ yɔ́ amʋ́ ibíá ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Amʋ́ atráhɛ bɛkɩtá asúmpʋ́ amʋ, dá amʋ́, mɔ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Brɛ́á owíe amʋ lónu asʋ́n ánfɩ á, ɔblɔ́ lɛhɩɛ́ kɩ́tá mʋ. Mʋ́ sʋ ɔlɔwa mʋ ɩsá akɔpʋ́, bɔyɔ́mɔ ahá ámʋ́ʋ́ bɔmɔ mʋ asúmpʋ́ amʋ, wá amʋ́ wúlu ogyá. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mʋ́ʋ́ ɔlɛbláa mʋ asúmpʋ́ bámbá ɔbɛ́ɛ, ‘Banɩ́ná ɔtsɩkpaɩ́n atogyihɛ amʋ tá, támɛ ahá ámʋ́ʋ́ nɛtɩ ámʋ bʋmɔfʋn ha mɩ́ wóyítɔ́ ba. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mʋ́ sʋ mlɩwie awúlutɔ, amlɩtɩ ɔhagyíɔha ánɩ́ mlówun, ɔba ɔtsɩ ɔkpaɩ́nkpá ɩnʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɩnʋ asúmpʋ́ amʋ bowie awúlutɔ. Bɛtɩ ɔhagyíɔha ánɩ́ bowun, aha wankláán pʋ́ aha laláhɛ fɛ́ɛ́. Mʋ́ sʋ ahá bɔbʋlá ɔtsɩ ɔkpaɩ́nkpá ɩnʋ dɛ́dɛ́ɛ́dɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Támɛ brɛ́á owíe amʋ lɛ́bɛkɩ ahá ámʋ́ʋ́ batɩ́ ámʋ a, olowun oyin ɔkʋá ɔmɔwa ɔtsɩkpaɩ́n nkɛtɔ atadɩɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mʋ́ʋ́ ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, ‘Agya, nkálɩ ɩlɔbwɛ fʋmɔwa ɔtsɩkpaɩ́n nkɛtɔ atadɩɛ asa fɛba nfɩ?’ Oyin ámʋ mɛ́talɩ́ lɛ́ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mʋ́ʋ́ owíe amʋ lɛ́labláa mʋ asúmpʋ́ ɔbɛ́ɛ, ‘Mlɩklɩ mʋ ayabi pʋ́ mʋ ɩbɩ, amlɩtswɩ mʋ wa oklún amʋtɔ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu lɔ́mɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Bulu tɛtɩ́ ahá tsɔtsɔɔtsɔ, támɛ ahá kpalobí pɛ́ ɔtɛlɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisifɔ ámʋ bɔyɔ́bwɛ ɔnɔ-ɔkʋlɛ ánɩ́ bɛ́tɛtɛ́ɛ Yesu ɔnɔ́tɔ́ asʋ́n nú, abʋnya mʋ akɩtálɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mʋ́ sʋ bɔwa amʋ́ akasɩ́pʋ́ pʋ́ Owíe Herode ahá Yesu wá bɛɛ bʋyɛ́fɩtɛ́ mʋ bɛɛ, “Osunápʋ́, anɩyin ánɩ́ ɔnɔkwalɩpʋ fʋgyi, fʋ́tosúná Bulu asʋ́n ámʋ ɛ́ ɔnɔkwalɩsʋ. Fʋtamahá ɔhaa ɔtsɛ fʋ́ agywɩɩn, tsúfɛ́ fʋtamakɩ ɔhaa ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mʋ́ sʋ anɩdɛ́ fʋ́ fɩtɛ́ anu. Anɩ mbla lɛ́ha ɔkpa ánɩ́ akáa lampóo ha Roma owíe dɛhɛn Kaesare, ntɛ́ɛ anɩmáka?” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Támɛ Yesu lówun amʋ́ agywɩɩn laláhɛ amʋ. Mʋ́ sʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Apinabwɛbí abwɛpʋ́, ntogyi sʋ́ mlɩdɛ́ mɩ́ sɔ́ɔ kɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mlɩtsu kɔ́ba amʋ́ʋ́ bʋtɔpʋ́ká lampóo amʋ ɩkʋ ba mɩ ankɩ.” Bɔpʋba mʋ, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma nwun pʋ́ mʋ dá dɩ́n mʋ́sʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Kaesare.” Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mlɩpʋ tɔ́á igyi Kaesare klɛ́ ha Kaesare, amlɩpʋ mʋ́á igyi Bulu klɛ́ ɛ́ ha Bulu.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu mbuaɩ ánfɩ lóbwie amʋ́ ɔnɔ́. Mʋ́ sʋ bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ɛkɛ ámʋ kɛ́n á, Sadukifɔ akʋ bɛba Yesu wá. Bʋgyi ɔpasua kʋá bʋtɛblɩ́ bɛɛ, kʋsʋ́ tsú afúlitɔ má ɩnʋ. Bɛfɩtɛ́ mʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Osunápʋ́, Mose lɔ́wanlɩ́n tswɩ anɩ ɔbɛ́ɛ, ‘Nɩ́ ɔkʋ mʋa mʋ ka bʋmɔkwɩɩ́ asa olowu sí mʋ ka ámʋ a, mʋ pio otsú mʋ ka ámʋ tsia, fɛ́kɩ ɔkwɩɩ ha owupʋ́ ámʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oyin ɔkʋlɛ abí abasíénɔ́ akʋ betsiá. Amʋ́tɔ́ ogyankpapʋ létsiá ɔká, támɛ ɔmɔkwɩɩ́ asa olowu. Mʋ pio lótsu ɔsʋrapʋka amʋ tsía, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","támɛ mʋ ɛ́ ɔmɔkwɩɩ́. Ɔsaasɩ lótsu ɔtsɩ ámʋ tsía. Mʋ ɛ́ ɔmɔkwɩɩ́. Alɩɩ yɔ́tʋ osienɔ́sɩ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɔma-ɔma a, ɔsʋrapʋ mʋ ɛ́ lóbowu. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Afúli ɔkʋsʋ́kɛ́ a, amʋ́tɔ́ ɔmɔmʋ ɔbɔ́bwɛ mʋ kulu? Tsúfɛ́ amʋ́ abasíénɔ́ ámʋ fɛ́ɛ́ betsiá mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mʋ́ʋ́ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí mlɩ ológyi. Mlɩméyín Bulu asʋn wanlɩ́nhɛ́ amʋ ntɛ́ɛ Bulu túmi. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nɩ́ afúli bɔkʋ́sʋ́ á, bɔ́bwɛ fɛ́ Bulu-abɔpʋ. Bʋméetsiá aká mʋ́a akúlu. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mlɩmɔ́kʋ́kla asʋ́n ánɩ́ Bulu onutó lɛ́bláa mlɩ tsú afúlikʋsʋ́ ɩwɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Bulu asʋn wanlɩ́nhɛ́ lɛ́blɩ́ ɔbɛ́ɛ, ‘Mɩ́gyí mlɩ anáin Abraham mʋa Isak pʋ́ Yakob Bulu ámʋ nɩ.’ Ɩ́nɩ sʋ megyí awupʋ́ Bulu ógyi, akɩankpapʋ Bulu ógyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Brɛ́á ɔdɔm amʋ bonu asʋ́n ánfɩ á, mʋ atosunáhɛ́ anfɩ lɛha ɔnɔ́ lobwie amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Brɛ́á Farisifɔ bowun ánɩ́ Yesu lalɛ́ Sadukifɔ ámʋ asʋ́n ɔnɔ́, asʋ́n lawú wá amʋ́ ɔnɔ́ á, bɛkpa aba ya Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Amʋ́tɔ́ ɔkʋlɛá ogyi mbla osunápʋ́ lɛ́fɩtɛ́ Yesu asʋ́n, ɔpʋsɔ mʋ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Osunápʋ́, Bulu mbla ámʋtɔ mɔmʋ dʋ́n?” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “ ‘Pʋ fʋ́ klʋn, fʋ́ ɔkláa pʋ́ fʋ́ agywɩɩn fɛ́ɛ́ dwɛ fʋ́ Wíe Bulu.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɩ́nɩ gyí mbla ámʋtɔ gyankpapʋ ánɩ́ ɩdʋn mʋ́ fɛ́ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nyɔɔsɩ ɛ́ igyi fɛ́ mʋ́. ‘Dwɛ fʋ́ bá fɛ́ fʋ́ ɩwɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose Mbla pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ atosunáhɛ́ fɛ́ɛ́ ɩlɩɩ́ mbla anyɔ ánfɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ɩ́nɩá Farisifɔ ámʋ bebefia sí bʋlɩɩ́ sʋ á, Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nkálɩ mlɩdɛ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) ɩwɩ gywɩɩ́n? Ma mʋ na nɩ́?” Bɛbláa mʋ bɛɛ, “Owíe Dawid mʋ na nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ɔlɛlafɩ́tɛ́ amʋ́ ɔbɛ́ɛ, “Mʋ́ ntogyi sʋ́ Ɔŋɛ Wankɩ́hɛ́ lɛ́ha Owíe Dawid lɛ́tɩ mʋ ɔbɛ́ɛ ‘Mɩ́ Wíé?’ Tsúfɛ́ Owíe Dawid lɛ́blɩ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anɩ Wíe Bulu lɛ́bláa mɩ́ Wíe ɔbɛ́ɛ, Tsia mɩ́ gyɔpɩsʋ nfɩ yɔ́fʋn brɛ́á nɛ́ha fɛ́tsatsáa fʋ́ alupʋ́sʋ́?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɩ́ Owíe Dawid onutó lɛ́tɩ ɔhá ánfɩ Bulu ladá ofúli anfɩ ɔbɛ́ɛ, mʋ wie a, nkálɩ sʋ́ ɔtráa ogyi mʋ na?” ");
INSERT INTO nkoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Amʋ́tɔ́ ɔkʋkʋ mɛ́talɩ́ lɛ́ mʋ́ ɔnɔ́. Tsú ɛkɛ ámʋ a, ɔhaa mɛ́trá wa klʋn fɩtɛ́ mʋ asʋansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Asʋ́n ánfɩ ɔma a, Yesu lɛ́bláa ɔdɔm amʋ pʋ́ mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mose mbla Farisifɔ pʋ́ Mbla asunápʋ́ amʋ bʋdesuná. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mʋ́ sʋ mlɩgyi amʋ́ asʋn blɩ́hɛ́ fɛ́ɛ́sʋ́, támɛ mlɩmátsiá amʋ́ atsiábi. Tsúfɛ́ bʋtamagyi amʋ́ onutó asʋn blɩ́hɛ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bʋtɔpʋ́ atɔ dwindwín sʋ́rá ahá, támɛ amʋ́ onutó bʋtamapʋ́ osrebi ɔkʋlɛ kʋ́ráá tsá amʋ́ tsu. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bʋtɔbwɛ́ amʋ́ tógyítɔ́ ahá ansɩ́sʋ́. Bʋtɔwánlɩ́n Bulu asʋ́n dɩ́nká tati tɛ́ɩ́hɛ́sʋ, pʋ́klɩ́ amʋ́ ɔsʋkpɩ pʋ́ amʋ́ bɩna ɩbasʋ. Bʋtɔlʋ́ nfɛ́ tɩ́ntɩ́ɩ́ntɩ́n síánsían amʋ́ atadɩɛ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bʋtekle otsiákpá yilé tsiá nkɛ ogyíkpá pʋ́ Yudafɔ Ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɛdálɩ yɔ dɩnsʋ á, bʋtekle bɛɛ ahá bʋtɩ́ɩ amʋ́ bɛɛ, ‘Asunápʋ́,’ abʋbun ha amʋ́ itsiá. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mlɩ fɛ́ɛ́ á, apíó mlɩgyí. Mʋ́ sʋ mlɩmáha abʋtɩ mlɩtɔ ɔhaa osunápʋ́. Ɔbakʋ́lɛ pɛ́ gyí mlɩ osunápʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Alɩ kɛ́n mlɩmátɩ ɔhaa mlɩ sɩ́ ɔsʋlʋ́ʋ anfɩsʋ nɩ́. Tsúfɛ́ Ɔsɩ́ ɔkʋlɛ pɛ́ mlɩbʋ, ɔbʋ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tráhɛtráhɛ a, mlɩtɔ ɔhaa máha abʋtɩ mʋ nkpá ogyápʋ. Tsúfɛ́ nkpá ogyápʋ ɔkʋlɛ pɛ́ mlɩbʋ. Mʋgyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ). ");
INSERT INTO nkoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mlɩtɔ ɔhandɛ ɔbwɛ́ɛ mlɩ osúmpʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsúfɛ́ fʋ́á fotsu ɩwɩ á, Bulu ɔbɛ́ba fʋ asɩ. Fʋ́á fɛba ɩwɩasɩ ɛ́ á, Bulu obótsu fʋ fʋ́á. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Mlɩlatin Bulu iwíegyí ámʋ ɔkpa wá ahá. Mlɩ onutó mlɩmédékléá mlówie ɩnʋ, mlɩdɛ́ ahá ánɩ́ bʋdɛ mbɔ́dɩ́ bɔ bɛɛ bówie ɩnʋ ɛ́ ɔkpa tíin. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Tsúfɛ́ mlɩtɛfá ɩlɩn fá ɔpʋ, dʋ́ ɩbʋ kplɩ́ ɩbʋ há ɔha tɛdámlí klʋntɔ. Támɛ nɩ́ ɔdámlí klʋntɔ tá á, mlɩtɛlábwɛ́ mʋ otemlí ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ ɔyɔpʋ́ dʋn mlɩ onutó. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ansibi abwiepʋ́ ánɩ́ mlɩdɛ́ ahá kpa, mlɩgyɔwɩ nɩ́. Mlɩtɛblɩ́ mlɩaa, ‘Nɩ́ ɔkʋ ɔká Bulu ɔtswɛ́kpa obu ámʋ ntam a, imehián ánɩ́ obégyi mʋ́sʋ́. Támɛ nɩ́ ɔká sika pɛpɛ atɔ́á ɩbʋ ɔtswɛ́kpa obuto ɩnʋ mʋ́ ntam a, ilehián ánɩ́ obégyi mʋ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ansibi abwiepʋ́! Aha mimláhɛ! Mʋ́tɔ́ mɔmʋ bʋ labi dʋn? Sika pɛpɛ atɔ́ ámʋ lóó, ntɛ́ɛ Bulu ɔtswɛ́kpa obu ámʋ́ʋ́ ɩlahá sika ámʋ lamlí Bulu klɛ́ amʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mlɩtɛtráa blɩ́ mlɩaa, ‘Nɩ́ ɔkʋ ɔká afɔdɩɛ-asubwi ntam a, imehián ánɩ́ obégyi mʋ́sʋ́. Támɛ nɩ́ ɔká afɔdɩɛ-abɔtɔ́ ámʋ ntam mʋ́ á, ilehián ánɩ́ obégyi mʋ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ansibi abwiepʋ́! Mʋ́tɔ́ mɔmʋ bʋ labi dʋn? Afɔdɩɛ-abɔtɔ́ ámʋ ntɛ́ɛ afɔdɩɛ-asubwi ámʋ́ʋ́ ɩlahá mʋ́ ɩlamlí Bulu klɛ́ amʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nɩ́ fɛká afɔdɩɛ-asubwi amʋ ntam a, faká ibwi ámʋ pʋ́ atɔ́á ɩdɩn mʋ́sʋ́ fɛ́ɛ́ ntam. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɩ́ fɛká Bulu ɔtswɛ́kpa amʋ ntam a, faká Bulu mʋa mʋ otsiákpá ntam. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɩ́ fɛká ɔsʋ́sʋ́ ntam a, faká Bulu mʋa mʋ owíe obíá ntam. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Mlɩteye mlɩ ɔtsʋtsʋ́ pʋ́ kpántánkplámá aná fɛ́ɛ́tɔ́ idú, pʋ́ idúsɩ́ há Bulu. Támɛ mlɩmɛ́dɛ́ Bulu mbla amʋ́ʋ́ ɩhɩ́ɛ́ dehián, igyi asʋ́ngyí ɔnɔkwalɩsʋ, aba nwewúun pʋ́ ɔnɔkwalɩwa ámʋsʋ gyi. Mʋ́déhián nɩ, támɛ mlɩmákiná iyétɔ dúsɩ́ amʋ ɛ́ ha. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ansibi abwiepʋ́ ánɩ́ mlɩdɛ́ ahá kpa, mlɩgyɔwɩ nɩ́. Mlɩtɔtsrɔ́ mbépi lɛ́ oputsútɔ́, támɛ mlɩtɛmɛ́ mbéwun. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Tsúfɛ́ mlɩtɔfwɩ́ mlɩ nwɛ pʋ́ mlɩ nlɛpɛ ɔma wankláán, támɛ atɔ́á mlɩlapʋ́ owi mʋ́a ɔnsɩpɛ swɩ́ɩ́ ahá sɔ́ɔ́n bʋ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisifɔ ansibi abwiepʋ́, mlɩgyankpa fwɩ nwɛ mʋ́a nlɛpɛ ámʋtɔ, mʋ́ ɔma ɛ́ bɛ́tɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Mlɩlabwɛ́ fɛ́ ntsán ánɩ́ bakpá mʋ́ afá futútúútú, mʋ́ ɩwɩ lawá akɩ́lɛ. Támɛ mʋ́tɔ́ mʋ́ á, afúli awú pʋ́ atɔ plɔ́hɛ́ sɔ́ɔ́n bɔ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Alɩ kɛ́n mlɩgyí nɩ́. Ahá bʋtɛkɩ mlɩ ánɩ́ mlɩgyí yilé abwɛpʋ́. Támɛ mlɩ klʋntɔ mʋ́ á, apinabwɛbíbwɛ mʋ́a lalahɛbwɛ sɔ́ɔ́n bɔ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Mlɩ Farisifɔ pʋ́ Mose mbla asunápʋ́, apinabwɛbí abwɛpʋ́, mlɩgyɔwɩ nɩ́. Tsúfɛ́ mlɩtɔpwɛ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ pʋ́ yilé abwɛpʋ́ ámʋ́ʋ́ betsiá ámʋ ntsán, lá mʋ́ ɩwɩ wankláán, blɩ́ mlɩaa, ‘Nɩ́ anɩlétsiá anɩ anáin brɛ́sʋ́ asa bɔmɔ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ anfɩ á, tɛkɩ anɩmɔ́wa ɩbɩ mʋ́tɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mlɩ asʋn blɩ́hɛ́ anfɩ désuná ánɩ́ mlɩgyí Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amɔpʋ́ ámʋ abí-aná nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mlɩwuna yɔ mʋ́sʋ́, amlɩmɔ mlɩ anáin bwɛhɛ́ ámʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Awɔ, abɛ abí-aná! Mlɛ́talɩ́ srɩ́ sí ɩpɔ́n ámʋ́ʋ́ Bulu ɔbɛ́ha mlɩ, kpá mlɩ wá ɩsʋbɩtɩ́ ogyá ámʋ́ʋ́ ɩtamaduntɔ ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mʋ́ sʋ ndɛ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́, anyansapʋ pʋ́ Mose mbla asunápʋ́ wa sɩ́sɩ́ mlɩ. Támɛ mlɔ́mɔ akʋ, dá amʋ́tɔ́ akʋ mántá oyikpalíhɛsʋ. Mlɔ́nwɛn amʋ́tɔ́ akʋ mplɩ mlɩ ofíakpa, dɩ́nká akʋsʋ tsú awúlusʋ yɔ́ awúlusʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɩ́nɩ sʋ yilé abwɛpʋ́ ámʋ́ʋ́ mlɩa mlɩ anáin mlɩlamɔ́ tsú Habelsʋ bɔfʋn Sakaria, ogyi Barakia mʋ bi ámʋ́ʋ́ mlɩlɔ́mɔ Bulu ɔtswɛ́kpa obu mʋ́a afɔdɩɛ-asubwi amʋ nsɩnɛ́ ámʋ fɛ́ɛ́ obugya bɛ́ba mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɩ́nɩ aná fɛ́ɛ́ sʋ Bulu ɩsʋbɩtɩ́ bɛ́ba mlɩ ndɛmba-abí ánfɩsʋ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Óo Yerusalemfɔ, Yerusalemfɔ! Mlɩtɔ́mɔ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́, dá abí ánɩ́ Bulu lawá sɩ́sɩ́ mlɩ abwi mɔ́ nɩ́. Ntekleá nóbun mlɩ abísʋ́ brégyíbrɛ́, fɛ́ alɩá batɛ tobun mʋ abísʋ́, támɛ mlɩtamahá mɩ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mlɩkɩ, Bulu obési mlɩ ɔtswɛ́kpa tswɩ mlɩ, ɩbɛ́dɩ kpan. ");
INSERT INTO nkoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tsúfɛ́ ndɛ mlɩ bláa mbɛ́ɛ, mlɩmɛ́ɛtrá wun mɩ ɛkɛkɛɛkɛ, yɔ́fʋn ɛkɛá mlɛ́blɩ́ mlɩaa, ‘Bulu oyúla ɔhá ámʋ́ʋ́ ɔbá mʋ ɩdátɔ́.’ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Brɛ́á Yesu lɛ́dalɩ Bulu ɔtswɛ́kpa ɩnʋ ɔyɔ́ á, mʋ akasɩ́pʋ́ amʋ bɛnatɩ́ yɔ́tʋ mʋ, súná mʋ ɔtswɛ́kpa ɩnʋ mbu ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩlawun mbu akpɔnkpɔɔnkpɔntɩ ánfɩ fɛ́ɛ́? Ɔnɔkwalɩ ndɛ mlɩ bláa. Bóbwie mʋ́ fɛ́ɛ́ bun. Ibwi kʋlɛ kʋ́ráá méesian dɩnká mʋ́ básʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Brɛ́á Yesu tsie Nfɔ-nyíbʋ ámʋsʋ, ɔdɛ Bulu ɔtswɛ́kpa amʋ kɩ́ɩ a, mʋ akasɩ́pʋ́ amʋ nkʋlɛ bɛfɩtɛ́ mʋ bɛɛ, “Bla anɩ, brɛ́ mɔmʋtɔ ɩ́nɩ fɛ́ɛ́ bɛ́ba? Osúna mɔmʋ ɛ́ ɔbɛ́ba, ibósuná ánɩ́ fʋ́ bábɩ pʋ́ ɔyɩ́ ɔnɔ́mɔkɛ́ lafʋn?” ");
INSERT INTO nkoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɩnʋ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩkɩ wankláán, mɛ́nɩ ɔhaa mɛ́ɛmlɛ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsúfɛ́ ahá tsɔtsɔɔtsɔ bɔ́pʋ mɩ́ dá ba bɛɛ, amʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ. Bɛ́mlɛ́ ahá tsɔtsɔɔtsɔ bɔ́fwɩ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɩ́ mlonúá ɩsá ladá mantáa mlɩ ntɛ́ɛ ɔtɩnɛkʋ á, opúni mátsií mlɩ. Tsúfɛ́ lehián ánɩ́ ɩ́nɩ aná fɛ́ɛ́ bɛ́ba, támɛ imedésuná ánɩ́ ɔyɩ́ ɔnɔ́mɔkɛ́ ámʋ lafʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tsúfɛ́ ɔmá bɔ́kɔ aba. Awíe bɔ́kʋsʋ́ lɩ́ɩ́ abasʋ. Akʋ́n bɛ́ba, ɔsʋlʋ́ʋ bɛ́kpɩnkɩ́ ntɩ́nɛ́-ntɩ́nɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɩ́nɩ fɛ́ɛ́ igyi fɛ́ ɩwɩɔsɩn ánɩ́ ɔtsɩ towun brɛ́á ɩkwɩ́ɩ dɛ mʋ dwiín. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Alɩ brɛ́ ámʋtɔ á, mɩ́ sʋ ɔmá-ɔmá bólu mlɩ. Bɛ́dɩnká mlɩsʋ, pʋ́ mlɩ há bɔ́wa mlɩ amʋmʋyɔ, mɔ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mlɩtɔ ahá tsɔtsɔɔtsɔ bɛ́dɩda hógyitɔ. Bólu aba, lɛ́ aba há. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Afunu awapʋ́ bɛ́blɩ́ bɛɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ bʋgyi tsɔtsɔɔtsɔ bɛ́ba bɛmlɛ́ ahá tsɔtsɔɔtsɔ, há amʋ́ bɔ́fwɩ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lalahɛbwɛ bómoní. Mʋ́ sʋ ahá tsɔtsɔɔtsɔ bʋmɛ́ɛtrá dwɛ aba. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Támɛ ɔhá ánɩ́ ɔlɛtalɩ́ lɩ́ɩ́ kínkíínkín yɔ́fʋn ɔyɩ́ ɔnɔ́mɔkɛ́ á, Bulu ɔbɔ́hɔ mʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mʋ́ óó á, ahá bɛ́da Bulu iwíegyí ámʋ ɩwɩ asʋn wankláán ánfɩ ɔkan ɔyɩ́tɔ́ fɛ́ɛ́, mɛ́nɩ ahá fɛ́ɛ́ bónu mʋ́, asa ɔyɩ́ ɩbɔ́mɔ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nɩ́ mlowun akisítɔá itobwíé ɔmá, ɩda Ɔwankɩ́kpá ɩnʋ, ɩdɛ Bulu ɔtswɛ́kpa ɩnʋ kpɔɩ́, fɛ́ alɩá Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Daniel lɛ́blɩ́ tswɩ a, —Aklápʋ, mlɩnu mʋ́ asɩ!— ");
INSERT INTO nkoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mʋ́mʋ́ ahá ánɩ́ bʋbʋ Yudea ɔmátɔ́ bʋsrɩ́ɩ yɔ abʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɔhá ánɩ́ ɔdɩn obusʋ mákplɩ ɔbɛ́ɛ, moyótsu tɔtɔ obuto. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ɔhá ánɩ́ ɔbʋ ndɔtɔ ɛ́ ɔmáyinkí ba wóyítɔ́ botsu mʋ tati. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amenyapʋ́ pʋ́ abí-ayín ánɩ́ bʋpia abi bɔbwɛ alɩ brɛ́ ámʋtɔ, bʋgyɔ́wɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mlɩkokoli Bulu mlɩaa, mlɩ ɔsrɩ́kɛ́ amʋ ɩmábwɛ nyankpʋ mʋ́a atsalɩbɩ́ ntɛ́ɛ ɔkpʋ́nʋ́ ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsúfɛ́ tsú ɔyɩ́ asɩtsuábɩ a, asʋn wunhɛ ánɩ́ ɩbɛ́ba alɩ brɛ́ ámʋtɔ odu kʋkʋ mɔ́kʋ́ba kɩ. Mʋ́ odu kʋkʋ ɛ́ mɛ́ɛtrá ba ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɩ́ Bulu mɛ́dɩnkɩ́ nkɛ ámʋsʋ á, tɛkɩ ɔhaa méesian ɔyɩ́tɔ́. Támɛ ahá ámʋ́ʋ́ alalɛ́ pʋ́bwɛ́ mʋ klɛ amʋ sʋ aladɩ́nkɩ́ nkɛ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Alɩ brɛ́ ámʋtɔ á, nɩ́ ɔkʋ lɛ́bláa fʋ ɔbɛ́ɛ, ‘Kɩ, Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) bʋ nfɩ ntɛ́ɛ nána’ á, máhogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsúfɛ́ ahá ánɩ́ bɛɛ amʋ́gyí Kristo amʋ pʋ́ ahá ánɩ́ bɔ́wa afunu bɛɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ bʋgyi tsɔtsɔɔtsɔ bɛ́ba ɔyɩ́tɔ́. Bɔ́bwɛ ofúla pʋ́ osúna akpɔnkpɔntɩ pʋ́mlɛ́ ahá. Nɩ́ bɛ́talɩ́ kʋ́ráá á, bɛ́mlɛ́ ahá ámʋ́ʋ́ Bulu lalɛ́ ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mlɩnu, ndɛ mlɩ ɔlá da yáɩ́ asa ɩba. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nɩ́ ɔkʋ ɔbláa mlɩ ɔbɛ́ɛ, ‘Kɩ, Kristo amʋ laba ɔbʋ dimbísʋ́’ a, mlɩmádalɩ yɛ́kɩ. Alɩ kɛ́n nɩ́ bɛblɩ́ bɛɛ, ‘Ɔbʋ obutótɔ́’ ɛ́ mlɩmáhogyi nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɔbákɛ ɩbɔ́bwɛ fɛ́ alɩ ámʋ́ʋ́ nyankpʋ tɔfwɩ́ ɩbɩ, bʋtowun mʋ́ tsú owí ɔdalɩkpa yɛ́dalɩ owí ɔkplɩ́wíékpá amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ɔtɩ́nɛ́á ɩtɔ wuhɛ́ da a, ɩnʋ́ alása bʋtefia. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ɩwɩɔsɩn wúun amʋ ɔma a, owí ɔbɛ́ta, ɔtsra ɛ́ ɔmɛ́ɛtrá fɛɩ́. Ntsrakpabi bɛ́kpa tsú ɔsʋ́sʋ́ bɛda. Nwʋlʋ́táa mʋ́a mʋ́tɔ́ atɔ́ fɛ́ɛ́ bɛ́kpɩnkɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mʋ́ ɔma a, mlówun mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩbá ɩwɩ osúna ɔsʋ́sʋ́. Ɔyɩ́tɔ́ ahá fɛ́ɛ́ bósu. Ɔhagyíɔha obówun ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ napʋ́ túmi mʋ́a numnyam kpɔnkpɔntɩ mbʋ nwʋlʋ́táatɔ tsú ɔsʋ́sʋ́ nɛbá. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɩnʋ á, ɔkpɛ kʋ ɩbɛ́lɩn kʋ́klʋ́kʋ́ʋ́, Bulu ɔbɔ́wa mʋ abɔpʋ bɛ́yɛkpa mʋ ahá ámʋ́ʋ́ alalɛ́ ámʋ tsú ɔyɩ́ afʋnka ana ámʋ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mlɩpʋkɩ pɔntɔ oyí. Nɩ́ mʋ́ abámbi dɛpɔɩ́, ɩdɛ atɛ pɔpwɛ lɛ á, mlɩtɛbɩ́ ánɩ́ awikpan brɛ́ lafʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Alɩ kɛ́n, nɩ́ mlowun ánɩ́ ntobí ánfɩ fɛ́ɛ́ ɩdɛ mʋ́tɔ́ bá a, mlɛ́bɩ ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩbábɩ lafʋn ta nɩ́. Nawíé wóyí ámʋ ɔnɔ́ tá. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, ndɛmba-abí ánfɩ fɛ́ɛ́ bʋmóowu tá asa ɩ́nɩ fɛ́ɛ́ bɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ɔsʋ́ mʋ́a asɩ fɛ́ɛ́ bɔ́tsʋn, támɛ mɩ́ asʋn blɩ́hɛ́ mɔ́ɔtsʋn ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ɔhaa méyín ɛkɛ ntɛ́ɛ brɛ́á ntobí ánfɩ fɛ́ɛ́ ɩbɛ́ba. Bulu-abɔpʋ bʋmeyín. Bulu mʋ Bi ámʋ ɛ́ méyín, nkɛ́tɩ anɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ nkʋlɛ pɛ́ yin. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Alɩ ámʋ́ʋ́ ilegyi Noa brɛ́sʋ́ amʋ a, alɩ́ ibégyi mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ ɩbábɩ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsúfɛ́ asa ntsubʋlábɩ́ amʋ lɔfʋn a, ahá betsiá bʋ́dɛ atɔ́ gyí, bʋdɛ ntá núu, bʋdɛ aká tsiá, bʋdɛ atsɩ kɩ́tá há akúlu alɩɩ yɔ́fʋn ɛkɛá Noa lówie mʋ dáka kpɔnkpɔɔnkpɔntɩ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɔhaa mɛ́bɩ tɔ́á ɩdɛ mʋ́sʋ́ yɔ, kpɛ́fʋn brɛ́á ntsu ámʋ lɔbʋlá sʋ́rá amʋ́ fɛ́ɛ́ nátɩ́. Alɩ kɛ́n bʋmɛ́ɛbɩ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩbábɩ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Alɩ brɛ́ ámʋtɔ á, nɩ́ ayin abanyɔ́ bʋlɩɩ́ ndɔ kʋlɛtɔ bʋdɛ agyʋ́má yɔ á, Bulu obótsu ɔkʋlɛ sí ɔkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nɩ́ atsɩ abanyɔ́ bʋdɛ nfúó kwɛ á, Bulu obótsu ɔkʋlɛ sí ɔkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mlɩdɩnka ansɩ́ ɩwɩsʋ, tsúfɛ́ mlɩméyín ɛkɛá mlɩ Wíe ɔbɛ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Támɛ mlɩnu asʋ́n ánfɩ. Nɩ́ wóyí mʋ wie yin onyé brɛ́á owikplu ɔbɛ́ba mʋ wóyítɔ́ a, tɛkɩ ologyo mʋ wóyí, owikplu móbwie wíé, wí mʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mʋ́ sʋ mlɩ ɛ́ mlɩgyo, tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́ba brɛ́á mlɩ ansɩ́ mɛdɩ́n mɩ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ma mɛɛ gyí osúmpʋ́á ɔlɛtɩn ansɩ́, ɔbʋ ɔnɔkwalɩ? Mʋ ɩbɩtɔ mʋ wie tɔpʋ́ mʋ aba atráhɛ wá, ɔbɛ́ɛ ɔhá amʋ́ atogyihɛ dɩnka brɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ansɩ́ bégyi osúmpʋ́ amʋ, nɩ́ mʋ wie amʋ ɔbá bowun ánɩ́ lɛ́lɛ́ ɔdɛ mʋ́ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɔnɔkwalɩ ndɛ mlɩ bláa. Mʋ wie amʋ ɔbɔ́pʋ mʋ atɔ́ fɛ́ɛ́ wá mʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Támɛ nɩ́ osúmpʋ́ laláhɛ ogyi, ɔlɛblɩ́ wá nwuntɔ ɔbɛ́ɛ, ‘Mɩ́ wíe mɛ́ɛba séi.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ɩ́nɩ sʋ olefi asɩ ɔdɛ mʋ aba asúmpʋ́ da, mʋa ntá abʋpʋ́ bʋdɛ atɔ́ gyí si amʋ́, bʋdɛ ntá núu bʋ á, ");
INSERT INTO nkoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mʋ wie amʋ ɔbɛ́ba bófwie mʋtɔ ɛkɛá ɔmɛdɩ́n ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mʋ wie amʋ ɔbɛ́hɩɛ tɩ́tɩ mʋtɔ, trá bɩtɩ́ mʋa apinabwɛbífɔ ámʋ asʋ kɛ́kɛ́ɛ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bulu iwíegyí ámʋ ɩbɔ́bwɛ fɛ́ mbitebí dú akʋá botsu amʋ́ nkandɩ́ɛ dálɩ beyéfia ɔká pɔpwɛ otsiápʋ ɔkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Amʋ́tɔ́ abanú bemimláa, abanú ɛ́ bɛtɩn ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aha mimláhɛ amʋ botsu amʋ́ nkandɩ́ɛ, támɛ bʋmotsu nfɔ kʋkʋ kɩ́tá. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Támɛ atɩansɩpʋ amʋ botsu nfɔ wá atɔ́tɔ́ kɩ́tá. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɔká otsiápʋ amʋ mɔ́kɔsɩ́ ba. Mʋ́ sʋ mbitebí ámʋ fɛ́ɛ́ bɔgyɔsɩ́, tsʋn mʋ́tɔ́ dɩ́dɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ɔyɩ́-nsɩnɛ́ á, ɔkʋ lɔ́sʋrá okitikíti ɔbɛ́ɛ, ‘Anɩ pɩ, ɔká otsiápʋ amʋ ɔbá o! Mlɩdalɩ yefia mʋ!’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ɩnʋ mbitebí ámʋ fɛ́ɛ́ bɔkʋsʋ́ nywɛ́ amʋ́ nkandɩ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aha mimláhɛ amʋ bɛbláa atɩansɩpʋ amʋ bɛɛ, ‘Anɩ nkandɩ́ɛ dedúun. Mʋ́ sʋ mlɩha anɩ nfɔ kpalobí awa anɩ klɛ́tɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mʋ́ʋ́ atɩansɩpʋ amʋ bɛbláa amʋ́ bɛɛ, ‘Ó-o, ɩmɔtsɔ́. Ɩmɔ́ɔfʋn anɩa mlɩnyɔ. Mlɩyɔ afɛpʋ́ wá, amlɩyɔhɔ mlɩ klɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Brɛ́á aha mimláhɛ amʋ bɔpʋ ɔkpa bɔyɔ́ á, ɔká otsiápʋ amʋ lɛ́ba. Amʋ́ ámʋ́ʋ́ bɛda ɩwɩsʋ ámʋ bobuo ɔká otsiápʋ amʋ wíé ɔká otsiákpá ɩnʋ, oyin ámʋ asúmpʋ́ befin obu ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mʋ́ ɔma a, mbitebí atráhɛ amʋ ɛ́ bɛba bɛlɩɩ́ klʋn ɔma, blɩ́ bɛɛ, ‘Anɩ sɩ́, finki ha anɩ awie.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Támɛ ɔká otsiápʋ amʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, ‘Ɔnɔkwalɩ ndɛ mlɩ bláa, mmeyín mlɩ ɔkpagyíɔkpasʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu lɔ́mɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɩ́nɩ sʋ mlɩda ɩwɩsʋ, tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́ba brɛ́á mlɩ ansɩ́ mɛdɩ́n mɩ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nyankpʋsa-Mʋ-Bi ámʋ ɩbábɩ bɔ́bwɛ fɛ́ ɔkʋá ɔdɛ ɔkpa tu, ɔlɛtɩ mʋ asúmpʋ́, ye mʋ atɔ́ há amʋ́ ɔbɛ́ɛ, bʋkɩ́ɩ mʋ́sʋ́ yaɩ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔlɔpʋ sika pɛpɛ akɛntɛ anu há ɔkʋlɛ, pʋ́ akɛntɛ anyɔ há onyɔɔsɩ, ɔlɔpʋ kɛntɛ kʋlɛ ɛ́ há ɔsaasɩ. Ɔlɛha okugyíɔkʋ mʋ ɔwʋnlɩ́n ɔnɔ́ asa ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Osúmpʋ́ ámʋ́ʋ́ olenya akɛntɛ anu ámʋ lɔ́wa ɔsa pʋ́ kɔ́ba amʋ fi ibíágyí asɩ. Mʋ́ sʋ ɩmɔwa ɔpá kʋkʋ, olenya akɛntɛ anu dɩ́nká mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Onyɔɔsɩ amʋ ɛ́ lɛ́damlí ɩbɩ mʋ sika pɛpɛ akɛntɛ anyɔ ámʋsʋ alɩ kɛ́n. Mʋ́ sʋ olenya akɛntɛ anyɔ dɩ́nká mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Támɛ ɔsaasɩ amʋ́ʋ́ olenya kɛntɛ kʋlɛ amʋ mʋ́ lóyókwi ɔbɔ́, pʋ́ mʋ wie sika pɛpɛ amʋ ŋáín mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ɩlɔwa ɔpá asa amʋ́ wíe amʋ lótsu mʋ ɔkpa ámʋ ba, ɔlɛtɩ amʋ́ ɔbɛ́ɛ, mʋa amʋ́nyɔ bóbu akúnta. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Osúmpʋ́ ámʋ́ʋ́ olenya sika pɛpɛ akɛntɛ anu ámʋ lótsu mʋ́a mʋ́sʋ́ ɔdɩ́nka akɛntɛ anu ámʋ ba mʋ wie, bɛbláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, fɛha mɩ́ sika pɛpɛ akɛntɛ anu. Mɩ́ ɛ́ nanyá akɛntɛ anu dɩ́nká mʋ́sʋ́. Mʋ́ nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mʋ wie amʋ lɛ́da mʋ ɩpán, blɩ́ ɔbɛ́ɛ, ‘Fabwɛ́ atɔ́. Osúmpʋ́ wankláán fʋ́gyi. Ɩ́nɩá fawá ɔnɔkwalɩ atɔ́ túkúrííbi ánfɩtɔ sʋ á, nɔ́pʋ fʋ́ yáɩ́ mɩ́ atɔ́ tsɔtsɔɔtsɔ ɔnɔ́. Ba afʋbetsiá mɩ́ wá, anya ansigyí.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Osúmpʋ́ onyɔɔsɩ amʋ́ʋ́ olenya sika pɛpɛ akɛntɛ anyɔ ámʋ ɛ́ lɛ́bláa mʋ wie ɔbɛ́ɛ, ‘Mɩ́ wíé, sika pɛpɛ akɛntɛ anyɔ fɛha mɩ́. Mɩ́ ɛ́ nanyá anyɔ dɩ́nká mʋ́sʋ́. Mʋ́ nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mʋ wie amʋ lɛ́da mʋ ɩpán, blɩ́ ɔbɛ́ɛ, ‘Fabwɛ́ atɔ́. Osúmpʋ́ ɔnɔkwalɩpʋ fʋgyi. Ɩ́nɩá fawá ɔnɔkwalɩ atɔ́ túkúrííbi ánfɩtɔ sʋ á, nɔ́pʋ fʋ́ yáɩ́ mɩ́ atɔ́ tsɔtsɔɔtsɔ ɔnɔ́. Ba afʋbetsiá mɩ́ wá, anya ansigyí.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mʋ́ʋ́ osúmpʋ́ amʋ́ʋ́ olenya sika pɛpɛ kɛntɛ kʋlɛ amʋ ɛ́ lɛ́bɛbláa mʋ wie ɔbɛ́ɛ, ‘Mɩ́ wíé, nyin ánɩ́ fʋ́ asʋ́n bʋ ɔnlɩn. Fʋtɔkpɔ́tɩ́ atɔ́ ɔtɩ́nɛ́á fʋmodu; fʋtɛkpá atɔ́-abí ɔtɩ́nɛ́á fʋmɛfɩtá. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʋ́ sʋ nenya ifú pʋ́ fʋ́ sika pɛpɛ amʋ ŋáín ɔbɔ́tɔ́. Mʋ́ nɩ́, hɔ fʋ́ atɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ɩnʋ mʋ wie amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Osúmpʋ́ laláhɛ, ɔwʋlɩyɔpʋ́ fʋ́gyi. Fʋyin ánɩ́ ntɔkpɔ́tɩ́ atɔ́ ɔtɩ́nɛ́á mmodu, ntɛkpá atɔ́-abí ɔtɩ́nɛ́á mmɛfɩtá atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ɩ́nɩá fʋyin mʋ́ alɩ á, tɛkɩ fɔpʋ yɔ́tswɩ sika ɔyaɩ́kpá. Ɩ́nɩá naba a, tɛkɩ nɔ́yɔhɔ mʋ́a mʋ́sʋ́ abí.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mʋ́ʋ́ oyin ámʋ lɛ́bláa mʋ asúmpʋ́ amʋ ɔbɛ́ɛ, ‘Mlɩswɩɩ mʋ sika pɛpɛ kɛntɛ kʋlɛ amʋ ha ɔmʋamʋ́ʋ́ alanyá akɛntɛ idú ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsúfɛ́ ɔhá ánɩ́ ɔbʋ tsɔtsɔ á, bɛtrá pʋ ɩkʋ tsɩ́a mʋ́tɔ́ há mʋ, obénya tsɔtsɔɔtsɔ. Támɛ ɔhá ánɩ́ ɔma á, bɔ́swɩɩ́ mʋ kpalobíbiá ɔbʋ, ");
INSERT INTO nkoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","amlɩtswɩ osúmpʋ́ anfɩ́ ɔma labi ánfɩ wa oklúntɔ. Ɩnʋ́ isú mʋ́a kpisíi bʋ nɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛbá mɩ́ iwíe ogyíkpá, Bulu-abɔpʋ fɛ́ɛ́ bʋbuo mɩ á, nétsiá mɩ́ ɔsʋ́sʋ́ numnyam owíe obíásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bɛ́kpa ɔyɩ́tɔ́ ahá fɛ́ɛ́ befia mɩ́ ansɩ́tɔ́. Ɩnʋ nɔ́tɔsɩ́ amʋ́tɔ́, fɛ́ alɩá mbwɩ ɔkpapʋ́ tɔtɔ́sɩ́ akúfa lɛ́ akpalátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Fówun nahá akúfa amʋ balɩ́ɩ́ mɩ́ gyɔpɩsʋ, akpaláa amʋ ɛ́ balɩ́ɩ́ mɩ́ bɩnasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ɩnʋ mɩ́ ánfɩ ngyi Owíe anfɩ nɛ́bláa ahá ámʋ́ʋ́ bʋlɩɩ́ mɩ́ gyɔpɩsʋ ámʋ mbɛ́ɛ, ‘Mlɩ ahá ánfɩ mɩ́ Sɩ́ layúlá ánfɩ mlɩba, amlɩbetsiá iwíegyí ámʋ́ʋ́ ɔlɛlayáɩ́ há mlɩ tsú ɔyɩ́ asɩtsuábɩ ɔpá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tsúfɛ́ akʋ́n lɛkɩtá mɩ́ á, mlɩlɛ́ha mɩ́ atɔ́ negyi. Ɔmɛwʋ́lɩ lɛkɩtá mɩ́, mlɩlɛ́ha mɩ́ ntsu nonu. Nɔbwɛ ɔfɔɔ́, mlɩlɔ́hɔ mɩ ɔfɔɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nɛnatɩ́ yayá, mlɩlɛ́ha mɩ́ tati nɛdɩdá. Nɔlɔ, mlɩlɛ́kɩ mɩ. Nɛdɩ obu, mlɩlɛ́bá bɛkɩ mɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ɩnʋ yilé abwɛpʋ́ ámʋ bɛ́fɩtɛ́ mɩ́ bɛɛ, ‘Anɩ Wíé, ɔmɛnkɛ anɩlówun ánɩ́ akʋ́n dɛ fʋ́, anɩlɛ́ha fʋ́ atɔ́ fegyi? Ɔmɛwʋ́lɩ dɛ fʋ́, anɩlɛ́ha fʋ́ ntsu fonu? ");
INSERT INTO nkoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Fɔbwɛ ɔfɔɔ́, anɩlɔ́hɔ fʋ ɔfɔɔ́? Ɔmɛnkɛ fɛnatɩ́ yayá, anɩlɛ́ha fʋ́ tati fɛdɩdá? ");
INSERT INTO nkoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɔmɛnkɛ fɔlɔ, ntɛ́ɛ fɛdɩ obu, anɩlɛ́bá bɛkɩ fʋ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ɩnʋ mɩ́ ánfɩ ngyi Owíe ánfɩ nɛ́bláa amʋ́ mbɛ́ɛ, ‘Ɔnɔkwalɩ ndɛ mlɩ bláa. Tógyítɔ́á mlɩlɔ́bwɛ há mɩ́ apíó ánfɩ ahá bʋtamabú amʋ́ wá ahátɔ ánfɩtɔ ɔkʋ á, mɩ́ mlɩlɔ́bwɛ mʋ́ há á.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ɩnʋ nɛ́bláa ahá ámʋ́ʋ́ bʋlɩɩ́ mɩ́ bɩnasʋ ámʋ ɛ́ mbɛ́ɛ, ‘Mlɩkpʋkpɛ tɛɩ nfɩ. Bulu lalwɩ́ɩ́ mlɩ. Mlɩyɔ ogyá ámʋ́ʋ́ ɩtamadun, Bulu lɛ́layáɩ́ há Ɔbʋnsám mʋ́a mʋ abɔpʋ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tsúfɛ́ akʋ́n lɛkɩtá mɩ́, mlɩmɛ́ha mɩ́ atogyihɛ. Ɔmɛwʋ́lɩ lɛkɩtá mɩ́, mlɩmɛ́ha mɩ́ ntsu annu. ");
INSERT INTO nkoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɔbwɛ ɔfɔɔ́, mlɩmɔ́hɔ mɩ ɔfɔɔ́. Nɛnatɩ́ yayá, mlɩmɛ́ha mɩ́ tati andɩda. Nɔlɔ, nɛdɩ obu; mlɩmɛ́kɩ mɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ɩnʋ amʋ́ ɛ́ bɛ́fɩtɛ́ mɩ́ bɛɛ, ‘Anɩ Wíé, ɔmɛnkɛ anɩlówun ánɩ́ akʋ́n dɛ fʋ́, ɔmɛwʋ́lɩ dɛ fʋ́, fʋgyi ɔfɔɔ́, fʋna yayá, fʋdɛlɔ ntɛ́ɛ fʋda obu; anɩmɛ́bɛkɩ fʋ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ɩnʋ mɩ́ ánfɩ ngyi Owíe anfɩ nɛ́bláa amʋ́ mbɛ́ɛ, ‘Ɔnɔkwalɩ ndɛ mlɩ bláa. Alɩ ámʋ́ʋ́ mlɩmɔ́bwɛ mʋ́ há mɩ́ apíó ánfɩ ahá bʋtamabú amʋ́ wá ahátɔ ánfɩtɔ ɔkʋ á, mɩ́ mlɩmɔ́bwɛ há á.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bulu ɔbɛ́ha amʋ́ bɔ́yɔ ɩwɩɔsɩn ánɩ́ ɩtamatátɔ́, támɛ yilé abwɛpʋ́ ámʋ mʋ́ bénya nkpa ánɩ́ ɩtamatá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Brɛ́á Yesu lósuná atɔ́ ánfɩ fɛ́ɛ́ tá á, ɔlɛbláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mlɩyin ánɩ́ ɩlasí nkenyɔ́ bégyi Israelfɔsʋ Katsʋn Nkɛ. Nkɛ ámʋtɔ á, ɔkʋ ɔbɔ́pʋ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ wá mɩ́ alupʋ́ ɩbɩtɔ, bɛ́da mɩ́ mántá oyikpalíhɛsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Alɩ brɛ́ ámʋtɔ á, Yudafɔ Bulu igyí ahapʋ́ dɛhɛn pʋ́ amʋ́ ahandɛ befia igyí ɔhapʋ́ dɛhɛn Kaiafa wóyítɔ́, kɩ́tá agywɩɩn ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ kɩ́tá Yesu ŋáintɔ, mɔ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Támɛ bɛblɩ́ bɛɛ bʋmɔ́ɔbwɛ mʋ́ nkɛ ámʋtɔ, mɛ́nɩ kpokiti mɛ́ɛda ɔmá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Brɛ́á Yesu bʋ Betania wúlutɔ, Simon ɔkʋá alalɔ́ ɩlɔ pɛpɛ kɩ wóyítɔ́ ɔdɛ atɔ́ gyí a, ");
INSERT INTO nkoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ɔtsɩ ɔkʋ lɛ́ba mʋ wá. Ɔdɛ prɛntʋa wankláán kʋá ofobí fánfán ánɩ́ ɩbʋ bíá bɔ mʋ́, ɔlɛtsɛɩ́ ofobí ámʋ wʋ́lɩ́ Yesu nwuntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu akasɩ́pʋ́ amʋ benya ɔblɔ́ brɛ́á bowun ɩ́nɩ. Mʋ́ sʋ bɛfɩtɛ́ bɛɛ, “Ntogyi sʋ́ ɔtsɩ ánfɩ layíntá ofobí fánfán ánfɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Abɛ́talɩ́ fɛ́ mʋ́ ibíá kpékplé, pʋ́ kɔ́ba amʋ há ahiánfɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu lɛ́bɩ ánɩ́ ɔblɔ́ lakɩ́tá amʋ́. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ mʋ háan? Ɩtɔ yilé alabwɛ́ há mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ahiánfɔ bétsiá mlɩtɔ ekekegyíɛkɛ, támɛ mɩ́ mʋ́ mméetsiá mlɩ wá yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Alatsɛ́ɩ́ ofobí fánfán ánfɩ wʋ́lɩ́ mɩ́, pʋ́lá mɩ́ ɔyʋlʋ́ʋ yáɩ́ há mɩ́ opulákɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔyɩ́tɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á bɛ́da Bulu asʋn wankláán ámʋ ɔkan a, bɛ́blɩ́ tɔ́ ánfɩ ɔtsɩ ánfɩ labwɛ́ ánfɩ pʋ́káɩ́n mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mʋ́ ɔma a, mʋ akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋá bʋtɛtɩ́ mʋ Yuda Iskariot lɔ́yɔ Bulu igyí ahapʋ́ dɛhɛn amʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ɔlɛyɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nɩ́ nɛlɛ́ Yesu há mlɩ á, ntɔ mlɛ́ha mɩ́?” Mʋ́ sʋ bɛkla sika futútú adʋasa (30) wá mʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsú brɛ́ ámʋtɔ ɔlɔwa ɔkpa dunká ánɩ́ ɔbɔ́tsʋn mʋ́sʋ́ lɛ́ Yesu há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Israelfɔ Bodobodo Mátúhɛ́Nkɛ ámʋtɔ ɛkɛ gyankpapʋ a, akasɩ́pʋ́ amʋ bɛba Yesu wá bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Wíé, obu mɔmʋtɔ ayɛla ha fʋ, afʋgyi Israelfɔsʋ Katsʋn Nkɛ atogyihɛ amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ asímasi wá wúlutɔ, amlɩyɛbláa mʋ mlɩaa, ‘Osunápʋ́ amʋ ɔbɛ́ɛ, mɩ́ brɛ́ lafʋn. Ɩ́nɩ sʋ mɩ́a mɩ́ akasɩ́pʋ́ abá begyi Israelfɔsʋ Katsʋn Nkɛ ámʋ fʋ́ wóyítɔ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mʋ́ sʋ akasɩ́pʋ́ amʋ bɔyɔ́bwɛ alɩ ámʋ́ʋ́ Yesu lɛ́bláa amʋ́ ámʋ pɛ́pɛ́ɛ́pɛ́. Bɛla obu ámʋtɔ, bwɛ́ Katsʋn Nkɛtɔ atogyihɛ amʋ yáɩ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Brɛ́á nsaɩntɔ deklúun a, Yesu mʋa mʋ akasɩ́pʋ́ bɛba betsiá ɔpʋ́nʋ́ ámʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Atɔ́ ámʋ ogyíkpá a, Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, mlɩtɔ ɔkʋlɛ ɔbɛ́lɛ mɩ́ há.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Asʋ́n ánfɩ lɛ́hɩɛ han akasɩ́pʋ́ amʋ. Mʋ́ sʋ befi asɩ bʋdɛ mʋ fɩtɛ́ kʋlɛkʋlɛ bɛɛ, “Mɩ́ Wíé, mɩ́ nɩ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ mɩ́a mʋnyɔ anɩdɛ́ ɩbɩ wa ɔlɛpɛ ɔkʋlɛtɔ ámʋ ɔbɛ́lɛ mɩ́ há. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nówu fɛ́ alɩá bɔwanlɩ́n tswɩ́ɩ, támɛ ɔhá ámʋ́ʋ́ ɔbɛ́lɛ mɩ́ há ámʋ ɔgyɔ́wɩ nɩ́. Nɩ́ bʋmetepí kwɩ́ɩ́ mʋ kʋ́ráá á, tɛkɩ ɩbʋ alɛ́ há mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda Iskariot amʋ́ʋ́ ɔlɛlɛ mʋ há ámʋ ɛ́ lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Osunápʋ́, mɩ́ nɩ́ lóó?” Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ee, fablɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Brɛ́á bʋdɛ atɔ́ ámʋ gyí a, Yesu lɛ́lɛ bodobodo ipín, ɔlɛda Bulu ɩpán, bíábía mʋ́tɔ́ pʋ́há mʋ akasɩ́pʋ́ amʋ, blɩ́ ɔbɛ́ɛ, “Mlɩhɔ amlɩgyi. Mɩ́ ɔyʋlʋ́ʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ɩnʋ olotsu ntá-ɛwɛ, ɔlɛda Bulu ɩpán, pʋ́há amʋ́ ɔbɛ́ɛ, “Mlɩ fɛ́ɛ́ mlɩhɔ amlɩnu. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mɩ́ obugya nɩ. Mʋ́ Bulu dɛ́pʋsí mʋ ntam ánɩ́ alaká há ahásʋ nɩ́. Bɛ́tsɛɩ́ mʋ́ wʋ́lɩ́ asɩ, mɛ́nɩ obési ahá tsɔtsɔɔtsɔ lakpan kíé amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndɛ mlɩ bláa mbɛ́ɛ, mmɛ́ɛtrá nu wáɩn-abí ntá ánfɩ alɩɩ yɔ́fʋn ɛkɛá mɩ́a mlɩnyɔ abɛ́lanu mʋ́ pɔ́pwɛ mɩ́ Sɩ́ iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Benya wá ɩlʋ dá Bulu ɩpán tá alɩ, bɛnatɩ́ yɔ́ Nfɔ-nyíbʋ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Brɛ́á bowie Nfɔ-nyíbʋ ámʋsʋ á, Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ “Mlɩ fɛ́ɛ́ mléyinkí mɩ́ ɔma onyenɩ. Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Nɛ́da akúfa ɔkpapʋ́ ámʋ lɛ́dá, mʋ akúfa bɛ́dasáɩ́n.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mʋ́ʋ́ ɔlɛtrá blɩ́ ɔbɛ́ɛ, “Támɛ nɩ́ Bulu ɔkʋ́sʋ́a mɩ tsú afúlitɔ á, négya mlɩ nkpá yɔ́ Galilea ɔmátɔ́. Ɩnʋ mlɔ́bɔtʋ mɩ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ amʋ́ fɛ́ɛ́ beyinkí fʋ́ ɔma kʋ́ráá á, mɩ́ mʋ́ mméeyinkí ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ fʋ́ bláa. Onyenɩ, asa batɛ ɔbɛ́lɛ ɔnɔ́ á, fɔ́swɩɩ́ pʋ́ ɩbɩ wá ogyá tse sa fɛɛ fʋmeyín mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ɩnʋ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ lowu ígyi kʋ́ráá á, mméekiná fʋ́ ɛkɛkɛɛkɛ.” Alɩ kɛ́n akasɩ́pʋ́ atráhɛ amʋ ɛ́ bɛblɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu mʋa mʋ akasɩ́pʋ́ bɔyɔ ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Getsemane. Brɛ́á bowie ɩnʋ á, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩtsia nfɩ, nɔyɔ́ nkpá yɔ́bɔ mpáɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɔlɛkpa Sebedeo abi anyɔ, bʋgyi Yakobo mʋa mʋ pio Yohane pʋ́ Petro ya. Ɩnʋ asʋ́n lɛhɩɛ́ han mʋ, mʋ ansɩ́ lɛpɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Asʋ́n ɩhɩ́ɛ́ dɛ mɩ́ háan, ideklé ɩmɔ mɩ́. Mlɩtsia nfɩ, mɩ́a mlɩnyɔ agyo.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɩnʋ ɔlɛnatɩ́ yɔ́ nkpá kpalobí, ɔlɛda akpawunu pʋ́ ansɩ́tɔ́ bun ɔsʋlʋ́tɔ, kókóli Bulu ɔbɛ́ɛ, “Mɩ́ Sɩ́, nɩ́ ɩbɔ́wa alɛ́ á, ha ntá-ɛwɛ ánfɩ ɩtsʋn mɩsʋ. Támɛ megyí tɔ́á ndeklé, mboún mʋ́á fʋdeklé ɩbá mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mʋ́ʋ́ oleyinkí ba akasɩ́pʋ́ amʋ wá bowun ánɩ́ bʋdɛdɩdɩ. Ɩ́nɩ sʋ ɔlɛfɩtɛ́ Petro ɔbɛ́ɛ, “Mʋ́ sʋ mlɩmɛ́talɩ́ tsíá, mɩ́a mlɩnyɔ agyo dɔnhwɩ́rɩ kʋlɛ kpán? ");
INSERT INTO nkoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mlɩgyo amlɩkokoli Bulu, mɛ́nɩ mlɩmóowie ɩsɔ́kɩtɔ, tsúfɛ́ mlɩ ɔŋɛ́ deklé, támɛ nyankpʋsa-oyí lɔpɔn.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu lɛ́trá yókokóli Bulu ɔbɛ́ɛ, “Mɩ́ Sɩ́, nɩ́ ntá-ɛwɛ ánfɩ mɔ́ɔtsʋn mɩsʋ, ɩbwɛ́ alɩágyíalɩ́á nónu mʋ́ á, mʋ́mʋ́ tɔ́á fʋdeklé ɩbá mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɔlɛtrá yinkí ba bowun ánɩ́ akasɩ́pʋ́ amʋ bʋtráa bʋdɛdɩdɩ, tsúfɛ́ dɩdɩ́ dɛ amʋ́ bʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mʋ́ sʋ ɔlɛnatɩ́ sí amʋ́, trá yókokóli Bulu otse saasɩ, blɩ́ asʋ́n ámʋ kɛ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oleyinkí ba akasɩ́pʋ́ amʋ wá, bɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩlatráa si mlɩda mlɩdɛ́ ɔkpʋ́nʋ́ da? Mlɩkɩ, brɛ́ ámʋ lafʋn ánɩ́ bɔ́pʋ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ wá lakpan abwɛpʋ́ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mlɩkʋsʋ ayɔ. Mlɩkɩ, ɔhá ámʋ́ʋ́ ɔdɛ mɩ́ lɛ há ámʋ ná á.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ɔnɔ́ mesi asa akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛá bʋtɛtɩ́ mʋ Yuda lóbowie ɩnʋ. Ɔdɔm kpɔnkpɔɔnkpɔntɩá bʋdɛ ndayí pʋ́ nkpotí bʋbuo mʋ. Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ lɔ́wa amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda amʋ́ʋ́ ɔbɛ́lɛ Yesu há ámʋ lɛ́bláa ɔdɔm amʋ yáɩ́ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ nɛ́latá pútá ámʋ gyí ɔhá ámʋ nɩ. Mlɩkɩta mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɩ́nɩ sʋ ɔlɛnatɩ́ laa yɛ́ha Yesu itsiá ɔbɛ́ɛ, “Osunápʋ́, tsia nɩ́!” Ɔlɛlatá mʋ pútá. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Agya, bwɛ tɔ́á ɔbwɛkpá fɛba.” Ɩnʋ ahá ámʋ bɛnatɩ́ tʋ́ Yesu, kɩ́tá mʋ kínkíínkín. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɩnʋ Yesu akasɩ́pʋ́ amʋtɔ ɔkʋlɛ lɔ́tswɩ mʋ ɔdayí, kpá Bulu igyí ɔhapʋ́ dɛhɛn osúmbi ɔkʋ ɩsʋ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Yinkia fʋ́ ɔdayí wa mʋ́ ɔflɛtɔ. Tsúfɛ́ ɔhá ánɩ́ ɔtɛnátɩ́ kɩ́tá ɔdayí á, ɔdayí ɔnɔ́ otesin. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fʋmeyín fɛɛ nɛ́talɩ́ kókóli mɩ́ Sɩ́ ɔbɛ́ha mʋ abɔpʋ tsɔtsɔɔtsɔ akú dúanyɔ bɛ́ba bɔkɔ hɔ mɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Támɛ nɩ́ ɩbá alɩ á, nkálɩ ɩbɔ́bwɛ asa Bulu asʋn wanlɩ́nhɛ́ amʋ ɩbɛ́ba mʋ́tɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɩnʋ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ogyo otswapʋ́ ngyi, sʋ́ mlɩlatsú nkpotí pʋ́ ndayí mlɛbá mɩ́ ɔkɩtákpá? Ntsie mlɩ wá Bulu ɔtswɛ́kpa ɩnʋ ekekegyíɛkɛ ndɛ mlɩ atɔ́ suná, mlɩmɛ́kɩtá mɩ́ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Támɛ ɩ́nɩ fɛ́ɛ́ laba mʋ́tɔ́, mɛ́nɩ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ asʋ́n wanlɩ́nhɛ́ amʋ ɩbɛ́ba mʋ́tɔ́.” Ɩnʋ akasɩ́pʋ́ amʋ fɛ́ɛ́ bɛsrɩ́ sí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mʋ́ʋ́ Yesu akɩtápʋ́ amʋ bɛkpa mʋ ya Bulu igyí ɔhapʋ́ dɛhɛn Kaiafa. Ɩnʋ́ mʋa Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ befia nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Támɛ Petro lɛ́pɛtɩ́ obuo amʋ́ ɔma tsútsúútsú alɩɩ bowie igyí ɔhapʋ́ dɛhɛn wóyítɔ́ ɩnʋ. Oleyétsiá amʋ́ agyópʋ wá, mɛ́nɩ obówun alɩá asʋ́n ámʋ ɩbɔ́mɔ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɩnʋ Bulu igyí ɔhapʋ́ dɛhɛn amʋ mʋa Yudafɔ asʋ́n agyípʋ́ amʋ fɛ́ɛ́ bodunká ahá ánɩ́ bɛ́ka asʋ́n dɩ́nká Yesusʋ, mɛ́nɩ bɛ́lɩɩ́ mʋ́sʋ́ mɔ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Afunupʋ tsɔtsɔɔtsɔ bɛdalɩ ba, támɛ amʋ́ fɛ́ɛ́ ɔnɔ́ lɔtsʋn ɔtsan. Mʋ́ ɔma a, ahá abanyɔ́ bɛdalɩ bɛlɩɩ́ ahandɛ amʋ ansɩ́tɔ́, ");
INSERT INTO nkoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","blɩ́ bɛɛ, “Oyin ánfɩ lɛ́blɩ́ ɔbɛ́ɛ, ‘Nɛ́talɩ́ bwíé Bulu ɔtswɛ́kpa amʋ, lápʋ́ nkɛnsá yi mʋ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mʋ́ʋ́ Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɔ́kʋsʋ́ lɩ́ɩ́ fɩ́tɛ́ Yesu ɔbɛ́ɛ, “Fʋma ɔnɔ́ lɛ́? Fʋma asʋansʋ blɩ́ pʋ́lɛ́ fʋ́ ɩwɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Támɛ Yesu móbwií ɔnɔ́. Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́labláa Yesu ɔbɛ́ɛ, “Nɛká Bulu Ɔkɩankpapʋ amʋ, nɩ́ fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli), ogyi Bulu mʋ Bi ámʋ a, bláa anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mʋ́ fablɩ́ á. Támɛ mlɩbɩ ánɩ́ tsú ndɛ pʋ́ya a, mlówun mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ntsie Bulu Otúmípʋ gyɔpɩsʋ ánfɩ, ndɩn ɔsʋ́sʋ́ nwʋlʋ́táasʋ nɛbá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mʋ́ʋ́ Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́kɩtá mʋ atadɩɛ bálɩ́ mʋ́ kɩaan, blɩ́ ɔbɛ́ɛ “Alabɔ́ mbusuo! Adánsɩɛ mɔmʋ anɩtráa anɩgyó? Yɛ́ɛ mlɩlanú abususʋ ánɩ́ alablɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nkálɩ gyí mlɩ agywɩɩn?” Bɛbláa mʋ bɛɛ, “Ilehián ánɩ́ obówu!” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɩnʋ botutúu atsʋnɔ́ wʋlɩ́ mʋ ansɩ́tɔ́, wɔwɔ mʋ atswɛ. Akʋ ɛ́ bɛdadáa mʋ asʋtɔ, ");
INSERT INTO nkoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","fɩ́tɛ́ mʋ bɛɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Kristo, ma ládá fʋ́? Bla anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petro tsie wunsɩnɛ́sʋ́ ɩnʋ, otsibi ɔkʋ lɔ́bɔtʋ mʋ. Ɔlɛbláa Petro ɔbɛ́ɛ, “Fʋ́a Yesu Galileayin amʋ nyɔ ná.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Támɛ Petro lɔ́wa ɔnɔlɩ́ ahá ámʋ fɛ́ɛ́ ansɩ́tɔ́ ɔbɛ́ɛ, “Mmeyín asʋ́n ánfɩ fʋdɛblɩ́ ánfɩ ɩwɩ kʋkʋʋkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mʋ́ ɔma wóyí ɔnɔ́ ɩnʋ ɛ́ á, otsibi ɔkʋ ɛ́ lɛ́bɩ Petro. Mʋ́ sʋ ɔlɛbláa ahá ánɩ́ bʋlɩɩ́ ɩnʋ ɔbɛ́ɛ, “Oyin ánfɩ mʋa Yesu Nasaretyin amʋnyɔ tɛ́nátɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɩnʋ Petro lɔ́pʋ ɔnɔlɩ́ ká ntam, blɩ́ ɔbɛ́ɛ, “Mmeyín mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mʋ́ ɔma a, ahá ámʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋtɔ akʋ bɛba bɛbláa Petro bɛɛ, “Lɛ́lɛ́ mʋ́ á, anɩyin ánɩ́ fʋ́a Yesunyɔ ná, tsúfɛ́ fʋ́ tɔ́ɩtɔ dɛ anɩ suná alɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ɩnʋ Petro lɔ́wa ntam kakáa bɩ ɔbɛ́ɛ, “Nɛká tógyítɔ́, mmeyín oyin ámʋ́ʋ́ mlɩdɛ́ mʋ ɩwɩ asʋ́n blɩ́ ámʋ!” Ɩnʋnʋ batɛ lɔ́bɔn. ");
INSERT INTO nkoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petro lɛ́kaɩ́n ánɩ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fɔ́swɩɩ́ tse sa fɛɛ fʋmeyín mɩ́ asa batɛ ɔbɛ́lɛ ɔnɔ́.” Ɩnʋ ɔlɛdalɩ hɩ́ɛ́ yósu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɔyɩ kɛhɛ nyankɩ-nyankɩ a, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛkɩtá agywɩɩn bɛɛ, bɔ́mɔ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mʋ́ sʋ bɛklɩ́ɩ mʋ, pʋ́ mʋ yɔ́wa Pilato ɩbɩtɔ. Mʋgyí Roma ɔhandɛá ɔdɛ Yudea ɔmásʋ́ gyí nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda amʋ́ʋ́ ɔlɛlɛ Yesu há ámʋ lówun ánɩ́ bahá Yesu pɔ́n. Ɩlɛhan mʋ. Mʋ́ sʋ oleyinkía sika futútú adʋasa ámʋ ya Bulu igyí ɔhapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nalɛ́ ɔhá ánɩ́ ɔmɔkʋ́bwɛ́ lakpan kʋkʋ há. Mʋ́ sʋ nabwɛ́ lakpan.” Mʋ́ʋ́ bɛbláa mʋ bɛɛ, “Anɩméyín mʋ́ ɩwɩ kʋkʋ. Fʋ́ asʋ́n igyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mʋ́ sʋ Yuda lɔ́tswɩ sika futútú ámʋ sɩ́sɩ́ amʋ́ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, nátɩ́ yésián ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bulu igyí ahapʋ́ dɛhɛn amʋ bɔtɔsɩ́ kɔ́ba amʋ, blɩ́ bɛɛ, “Anɩ mbla mɛha ɔkpa ánɩ́ apʋ́ʋ kɔ́ba anfɩ odu wa Bulu ɔtswɛ́kpa kɔ́batɔ, tsúfɛ́ mʋ́ ɩwɩ mɛtɩn. Obugya kɔ́ba igyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mʋ́ sʋ bɔbwɛ agywɩɩn, pʋ́ kɔ́ba ámʋ yɔ́hɔ atɔ́ ɔpwɛpʋ́ ɔkʋ ɔsʋlʋ́ʋ, pʋ́ ɩnʋ bwɛ́ afɔɔ́ ánɩ́ bʋbʋ Yerusalem opulákpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɩ́nɩ sʋ bɔtʋ ndɛ bʋtɛtɩ́ ɩnʋ bɛɛ, “Obugya ɔsʋlʋ́ʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ɩ́nɩ lɛ́ha Bulu asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yeremiasʋ ámʋ lɛ́ba mʋ́tɔ́. Ɔbɛ́ɛ, “Botsu sika futútú adʋasa ámʋ́ʋ́ Israelfɔ begyi mʋ ibíá, hɔ mʋ amʋ yɔ́hɔ atɔ́ ɔpwɛpʋ́ ɔkʋ ɔsʋlʋ́ʋ fɛ́ alɩá Bulu lɛ́bláa mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu lɩ́ɩ́ ɔmásʋ́ ɔkɩ́pʋ Pilato ansɩ́tɔ́. Mʋ́ʋ́ Pilato lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋ́gyí Yudafɔ owíe amʋ nɩ?” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ee, mʋ́ fablɩ́ á.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Támɛ brɛ́á Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛka asʋ́n dɩ́nká Yesusʋ á, ɔmɛlɛ kʋkʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mʋ́ʋ́ Pilato lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋmɛdɛ́ asʋ́n ánfɩ bakla dɩnká fʋ́sʋ́ ánfɩ nu?” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Támɛ Yesu métepí bwíí ɔnɔ́. Mʋ́ sʋ ilobwie Roma ɔhandɛ amʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ofífígyíofí, nɩ́ bʋdɛ Israelfɔsʋ Katsʋn Nkɛ gyí a, Roma ɔhandɛ amʋ tesí obu ɔdɩpʋ́ ɔkʋlɛá ɔdɔm amʋ bʋdeklé há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Alɩ brɛ́ ámʋtɔ á, obu ɔdɩpʋ́ ɔkʋá alahɔ dá, bʋtɛtɩ́ mʋ Baraba da obu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mʋ́ sʋ brɛ́á Yudafɔ ámʋ fɛ́ɛ́ bebefia a, Pilato lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma nsíi ha mlɩ? Baraba lóó, ntɛ́ɛ Yesu, bʋtɛtɩ́ mʋ Kristo amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tsúfɛ́ Pilato yin ánɩ́ Yesu ɩwɩ olu sʋ́ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bakɩ́tá mʋ ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Brɛ́á Pilato tsie ɔdɛ Yesu asʋ́n ámʋ gyí a, mʋ ka lɔ́wa obí mʋ wá ɔbɛ́ɛ, “Mábwɛ oyin ánfɩ mʋ asʋ́n da ɔkpa ánfɩ tɔtɔ. Tsúfɛ́ ígye onyé á, nokun okude wun mʋ, ifú lɛhɩɛ́ kɩ́tá mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Támɛ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛha ɔdɔm amʋ ɔnɔ́ bɛɛ, bʋkókoli Pilato osi Baraba, abʋmɔ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mʋ́ sʋ Roma ɔhandɛ amʋ lɛ́lafɩ́tɛ́ ɔdɔm amʋ ɔbɛ́ɛ, “Ahá abanyɔ́ ánfɩtɔ ɔmɔmʋ nsíi ha mlɩ?” Botsu ɔnɔ́ bɛɛ, “Baraba!” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mʋ́ʋ́ Pilato lɛ́trá fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ mbwɛ́ɛ Yesu, bʋtɛtɩ́ mʋ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ)?” Amʋ́ fɛ́ɛ́ bɛbláa mʋ bɛɛ, “Ha abʋda mʋ manta oyikpalíhɛsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ! Tsitsa mɔmʋ alabwɛ́?” Ɩnʋ bɛlakplʋ́n kʋ́klʋ́kʋ́ʋ́ bɛɛ, “Ha abʋda mʋ manta oyikpalíhɛsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Brɛ́á Pilato lówun ánɩ́ alabwɛ́ kásíán, kpokiti mboún deklé ɩda ɩnʋ á, olotsu ntsu fwɩ́ ɩbɩ amʋ́ ansɩ́tɔ́ ɩnʋ, bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ ɩbɩ anyɔ ɩma oyin ánfɩ lowutɔ. Mlɩ asʋ́n igyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yudafɔ ámʋ fɛ́ɛ́ bɛbláa mʋ bɛɛ, “Mʋ lowu ɩsʋbɩtɩ́ ɩbá anɩa anɩ abí-anásʋ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɩnʋ Pilato lési Baraba há amʋ́, ɔlɛha mʋ ɩsá akɔpʋ́ bɛpɩtɩ́ Yesu atɔ́, ɔlɔpʋ mʋ wá amʋ́ ɩbɩtɔ ɔbɛ́ɛ, bʋyɛ́da mʋ manta oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ɩnʋ ɔmásʋ́ ogyípʋ́ amʋ ɩsá akɔpʋ́ bɛkpa Yesu ya mʋ wóyítɔ́. Bɛtɩ amʋ́ aba ɩsá akɔpʋ́ atráhɛ amʋ fɛ́ɛ́, bɛda Yesu ɔbʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɔwɔɩ́ Yesu atadɩɛ, pʋ́ ligá pɛpɛ kʋ wá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bɔlʋ obungyo-awu, bwɛ́ mʋ́ owíepa bun mʋ nwun. Bɔpʋ oyí kʋ wá mʋ gyɔpɩ ɩbɩtɔ, fɛ́ akɔnfra. Bɛda akpawunu mʋ ansɩ́tɔ́, bʋdɛ mʋ ahinlá bwɛ bɛɛ, “Yudafɔ Owíe, fʋ́ nkpasʋ ɔnlɩnsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Botu atsʋnɔ́ wʋ́lɩ́ Yesu, swɩ́ɩ́ mʋ oyí ámʋ pʋ́pɩ́tɩ́ mʋ nwuntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bɔbwɛ mʋ ahinlá tá á, bɔwɔɩ́ amʋ́ ligá pɛpɛ amʋ, yínkía mʋ onutó atadɩɛ wá mʋ, bɛkpa mʋ dálɩ bɔyɔ́ abʋyɛda mʋ manta oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Brɛ́á bɔyɔ́ á, befia Kireneyin ɔkʋá bʋtɛtɩ́ mʋ Simon. Ɩsá akɔpʋ́ ámʋ bɛka mʋ hɩ́ɛ́ bɛɛ, ɔhɔ́ɔ oyikpalíhɛ amʋ sʋra. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Boyówie ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Golgota. Mʋ́ asɩ gyí, “Nwun Okokobi Otsiákpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bɔpʋ afá kɩ́tákɩ́tá wá ntátɔ́ tin Yesu ɔnɔ́ bɛɛ onúu, támɛ brɛ́á ɔlɛda mʋ́ ɔnɔ́ á, olekiná nu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bɛda mʋ mántá oyikpalíhɛ amʋsʋ tá á, beye mʋ atadɩɛtɔ. Ɩnʋ bɔtswɩ abi pʋ́kɩ ɔhagyíɔha ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Besi bʋtsie ɩnʋ, bʋdɛ mʋ ɩwɩ gyóo. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mʋ́ʋ́ bɔwanlɩ́n tɔ́á sʋá bʋdɛ mʋ da mántá oyikpalíhɛsʋ, dá mántá mʋ awunso bɛɛ, “Yesu, Yudafɔ owíe amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɛda awikplu abanyɔ́ ɛ́ mántá nyikpalíhɛsʋ tsɩ́a mʋtɔ. Ɔkʋlɛ bʋ mʋ gyɔpɩsʋ, ɔkʋlɛ ɛ́ bʋ mʋ bɩnasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɩnʋ atsʋ́npʋ bɔkpʋkpʋ́ʋ nwuntɔ, blɩ́ Yesu ɩwɩ abususʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yɛ́ɛ fʋ́ fɛɛ fɛ́talɩ́ bwíé Bulu ɔtswɛ́kpa amʋ, lápwɛ́ mʋ́ nkɛnsá owítɔ́ nɩ́? Hɔ fʋ́ ɩwɩ! Nɩ́ lɛ́lɛ́ Bulu mʋ Bi fʋ́gyi á, kplɩ tsu oyí ámʋsʋ akɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Alɩ kɛ́n Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ ɛ́ bɔbwɛ mʋ ahinlá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Bɛblɩ́ bɛɛ, “Ɔlɔhɔ ahá nkpa, támɛ ɔmɛtálɩ́ hɔ mʋ ɩwɩ. Nɩ́ mʋgyí Israelfɔ owíe amʋ a, ɔkplɩ́ɩ tsu oyí ámʋsʋ, mɛ́nɩ abɔ́hɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yɛ́ɛ ɔbɛ́ɛ Bulu mʋ Bi mʋgyi, mʋ ansɩ́ dɩn Bulusʋ. Bulu ɔlɛ́ mʋ séi, akɩ ánɩ́ otekle mʋ asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Alɩ kɛ́n awikplu ámʋ́ʋ́ bɛda mántá nyikpalíhɛsʋ mʋ wá ámʋ ɛ́ bɔbwɛ mʋ ahinlá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Owí lɛta ɔsʋlʋ́ʋ amʋsʋ fɛ́ɛ́, tsú dódúanyɔtɔ alɩɩ yɔ́fʋn ntʋ́pwɛ dɔsatɔ. Owí mɛtrá lɩn ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dɔsa ámʋtɔ á, Yesu lɔ́kplʋn kʋ́klʋ́kʋ́ʋ́ Hebri ɔblɩ́tɔ ɔbɛ́ɛ, “Eli, Eli, Lama Sabaktani?” Mʋ́ asɩ gyí, “Mɩ́ Bulu, mɩ́ Bulu, ntogyi sʋ́ fakpá mɩ́ ɔma?” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Brɛ́á ahá ámʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋtɔ akʋ bonu asʋ́n ánfɩ á, bɛblɩ́ bɛɛ, “Ɔdɛ Elia kpolí.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɩnʋ amʋ́tɔ́ ɔkʋ lɛ́srɩ́ yótsu ɔsapɔ, pʋ́dá ntá ɔdáɩtɔ, pʋ́yi oyísʋ́, tsú mʋ́ fʋ́á, pʋ́tin mʋ ɔnɔ́ ɔbɛ́ɛ onúu. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Támɛ mʋ aba atráhɛ amʋ bɛbláa mʋ bɛɛ, “Si, alɩɩ kɩ bɛɛ Elia ɔbɛ́ba bɔhɔ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu lɛ́trá kplʋ́n kʋ́klʋ́kʋ́ʋ́, ɔlɛlɛ ɔŋɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɩnʋ Bulu lɛ́balɩ́ tati ámʋ́ʋ́ bɔpʋká Bulu Ɔtswɛ́kpa obu ámʋtɔ anyɔ, tsú awunso beyi asɩ kɩaan. Bulu lɛ́ha ɔsʋlʋ́ʋ lɛkpɩnkɩ́, ɔlɛha abʋtá lɛmamáɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Olefinfínki ntsán, aha wankɩ́hɛ́ tsɔtsɔɔtsɔ bɔkʋsʋ́ tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu kʋsʋ́ tsú afúlitɔ ɔma a, aha wankɩ́hɛ́ anfɩ́ bakʋ́sʋ́ tsú afúlitɔ ánfɩ bɔyɔ Yerusalem wúlu wankɩ́hɛ́ amʋtɔ, yɛ́lɛ ɩwɩ ɔwan súná ahá tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Brɛ́á ɩsá akɔpʋ́ ɔhandɛ pʋ́ ɩsá akɔpʋ́ ámʋ́ʋ́ bʋdɛ Yesu ɩwɩ gyóo amʋ bowun ɔsʋlʋ́kpɩnkɩ́ ámʋ pʋ́ tɔ́á ɩdɛ mʋ́sʋ́ yɔ fɛ́ɛ́ á, ifú lɛhɩɛ kɩ́tá amʋ́, bɛblɩ́ bɛɛ, “Lɛ́lɛ́, Bulu mʋ Bi óyin ánfɩ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Atsɩ tsɔtsɔɔtsɔ bobuo Yesu, bʋdɛ mʋsʋ kɩ́ɩ tsu Galilea ɔmátɔ́. Amʋ́ ɛ́ besi lɩɩ́ tsútsúútsú, bʋdɛ mʋ kɩ́ɩ sɩsɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Amʋ́tɔ́ akʋ gyí, Magdalayintse Maria mʋa Maria ánɩ́ ɔlɔkwɩɩ́ Yakobo mʋa Yosef pʋ́ Sebedeo mʋ ka ánɩ́ ogyi Yakobo mʋa Yohane aná oyín. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Brɛ́á owí dɛpɔ́ɔn a, Arimateayin ɩwɩ onyapʋ́ ɔkʋá bʋtɛtɩ́ mʋ Yosef, alamlí Yesu ɔkasɩ́pʋ́ lɔ́yɔ Pilato wá, yɔ́kʋlɩ́ mʋ ɔbɛ́ɛ, osíi Yesu fúli amʋ ha mʋ. Pilato lɛ́ha ánɩ́ bʋsíi fúli amʋ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mʋ́ sʋ Yosef lɔ́pʋ ɔhráda ánɩ́ ɩlɛtɩn wankláán kɩ́klɩ fúli amʋ ɩwɩ, ");
INSERT INTO nkoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɔlɔpʋ mʋ yɔ́wa ɔbɔ́ pɔpwɛ ánɩ́ aladá bʋtátɔ́ yáɩ́ há mʋ ɩwɩtɔ. Mʋ́ʋ́ olemináa ibwi yíléyílé kʋ tin ɔbɔ́ ámʋ ɔnɔ́, ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdalayintse Maria mʋa Maria nyɔɔsɩ amʋ besi bʋtsie ɩnʋ fʋ́n bʋdɛ ntsán ámʋ kɩ́ɩ sɩsɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yudafɔ ɩwɩsʋ ɔdakɛ́ ɔyɩ kɛhɛ, igyi ɔkpʋ́nʋ́ ɔdakɛ́ á, Bulu igyí ahapʋ́ dɛhɛn, Farisifɔ ámʋ fɛ́ɛ́ pʋ́ Pilato befia. ");
INSERT INTO nkoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bɛbláa mʋ bɛɛ, “Owíe, anɩlakáɩ́n ánɩ́ brɛ́á ofunupʋ anfɩ tsie nkpa á, ɔlɛblɩ́ ɔbɛ́ɛ, ‘Nkɛnsá ɔma a, Bulu ɔbɛ́lakʋ́sʋ́a mɩ tsú afúlitɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mʋ́ sʋ ha abʋyogyo mʋ ntsán ámʋ ɔnɔ́ wankláán, yɔ́fʋn ɛkɛ sáásɩ́. Nɩ́ megyí alɩ á, mʋ akasɩ́pʋ́ amʋ bóyówi mʋ lɛ́, bɛmlɛ́ ahá bɛɛ alakʋ́sʋ́. Ɩbá alɩ á, akasɩ́pʋ́ amʋ ahámlɛ́ bɔ́dʋn mʋ klɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɩsá akɔpʋ́ nɩ́. Mlɩha amʋ́ abʋyogyo ɩnʋ wankláán alɩá mlɛ́talɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mʋ́ sʋ bɛyɛ́tan ɔbɔ́ ámʋ ɔnɔ́ wankláán, há agyópʋ bogyo mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yudafɔ ɔkpʋ́nʋ́ ɔdakɛ́ ɔyɩ kɛhɛ, igyi Kwasieda bakɛ a, Magdalayintse Maria mʋa Maria nyɔɔsɩ amʋ bɔkʋsʋ́ yɔ́ Yesu ntsán ámʋ ɔkɩ́kpa. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɩnʋnʋ á, ɔsʋlʋ́ʋ lɛkpɩnkɩ́ kʋ́klʋ́kʋ́ʋ́, Bulu-ɔbɔpʋ lɛ́kplɩ́ tsú ɔsʋ́sʋ́ bemináa ibwi yílé ámʋ lɛ́ ɔbɔ́ ámʋ ɔnɔ́, tsíá mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mʋ ansɩ́tɔ́ lɛhɩɛ wankɩ́, ɩdɛ ogyá kpa. Mʋ atadɩɛ ɛ́ lofulí futútúútú fɛ́ opuli-mpútɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Brɛ́á bowun mʋ a, ifú lɛhɩɛ́ kɩ́tá ɩnʋ agyópʋ amʋ, bɛkpɩnkɩ́ kpakpakpakpa, dɩda, lwíí fɛ́ afúli. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bulu-ɔbɔpʋ amʋ lɛ́bláa atsɩ ámʋ ɔbɛ́ɛ, “Mlɩmánya ifú! Nawun ánɩ́ Yesu amʋ́ʋ́ bɛda mántá oyikpalíhɛsʋ ámʋ mlɩdédunká. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔma nfɩ. Bulu lakʋ́sʋ́a mʋ fɛ́ alɩá ɔlɛblɩ́ yáɩ́. Mlɩbɛkɩ ɔtɩ́nɛ́ ámʋ́ʋ́ bɔpʋ mʋ tswɩ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mlɩwa ɔsa yɛbláa mʋ akasɩ́pʋ́ amʋ mlɩaa, Bulu lakʋ́sʋ́a mʋ tsú afúlitɔ. Alagya mlɩ nkpá ɔyɔ́ Galilea ɔmátɔ́. Ɩnʋ́ mlówun mʋ nɩ. Asʋ́n ánɩ́ mbʋ ha mlɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ifú lɛkɩtá atsɩ ámʋ, támɛ bɔpʋ ansigyí tsíí ɔsrɩ́ɩ tsú opulákpá ɩnʋ bɔyɔ́ yɛ́bláa akasɩ́pʋ́ amʋ tɔ́á bawun. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɩmɔwa ɔpá kʋkʋ Yesu léfía amʋ́, há amʋ́ ɩtɛ́. Ɩnʋ bɛda akpawunu kɩ́tá mʋ ayabi, súm mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmánya ifú. Mlɩyɛbláa mɩ́ apíó ámʋ mlɩaa, bʋyɔ́ Galilea ɔmátɔ́. Ɩnʋ́ bówun mɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Brɛ́á atsɩ ámʋ bɔpʋ bɔyɔ́ á, ntsán agyópʋ amʋ akʋ ɛ́ bɔyɔ wúlutɔ yɛ́bláa Bulu igyí ahapʋ́ dɛhɛn amʋ tɔ́á ɩlaba fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ɩ́nɩ sʋ Bulu igyí ahapʋ́ dɛhɛn amʋ bɛtɩ Yudafɔ ahandɛ amʋ fɛ́ɛ́ fía, kɩ́tá agywɩɩn. Bɛha ntsán agyópʋ amʋ kɔ́ba tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bɛha amʋ́ ɔnɔ́ bɛɛ, “Mlɩblɩ mlɩaa, ‘Onyé, brɛ́á anɩdɛ́dɩdɩ á, Yesu akasɩ́pʋ́ amʋ bɛ́ba bowi mʋ nátɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɩ́ Roma ɔhandɛ onú á, anɩa mʋnyɔ abɛ́blɩ́ mʋ́, mɛ́nɩ mlɩmóowie asʋ́ntɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mʋ́ sʋ ntsán agyópʋ amʋ botsulá hɔ kɔ́ba amʋ, begyi dɩnká Bulu igyí ahapʋ́ dɛhɛn amʋ asʋn blɩ́hɛ́ anfɩsʋ. Ɔnɔ́ ánfɩ bɛha amʋ́ ánfɩ lobwie wá Yudafɔ ɔmá ámʋ fɛ́ɛ́tɔ́ bɔfʋn ndɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Akasɩ́pʋ́ dúɔkʋn ámʋ bɛnatɩ́ yɔ́ Galilea ɔmátɔ́, ɩbʋ ámʋ́ʋ́ Yesu lósuná amʋ́ ɔbɛ́ɛ bʋfía mʋ mʋ́sʋ́ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Brɛ́á bowun mʋ a, bɛda akpawunu súm mʋ, támɛ ɩmɔwankɩ́ amʋ́tɔ́ akʋ ánɩ́ mʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mʋ́ʋ́ Yesu lɔ́kpʋkpɛ́ ba amʋ́ wá, blɩ́ ɔbɛ́ɛ, “Bulu lapʋ́ ɔsʋ́ mʋ́a asɩ túmi fɛ́ɛ́ wá mɩ́ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mʋ́ sʋ mlɩyɔ ɔyɩ́tɔ́ fɛ́ɛ́, amlɩbwɛ ahá fɛ́ɛ́ mɩ́ akasɩ́pʋ́. Mlɩbɔ amʋ́ asú Ɔsɩ́, Obí pʋ́ Ɔŋɛ Wankɩ́hɛ́ dátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mlɩsuna amʋ́ abʋgyi mbla ámʋ́ʋ́ nɔwa há mlɩ ámʋ fɛ́ɛ́sʋ́. Mlɩbɩ ánɩ́ mbʋ mlɩ wá brégyíbrɛ́, yɔ́fʋn ɔyɩ́ ɔnɔ́mɔ.”");
INSERT INTO nkoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Alɩ́ Bulu mʋ Bi Yesu Kristo ɩwɩ asʋn wankláán ámʋ ilotsuá asɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ɩlɛba mʋ́tɔ́ fɛ́ alɩá Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɔ́wanlɩ́n wá mʋ ɔwʋlʋ́tɔ́ ɔbɛ́ɛ, “Kɩ, ndɛ obí wa gya fʋ nkpá. Mʋ ɔbɛ́la ɔkpa há fʋ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ɔkʋ dɛ́kplʋn dimbísʋ́ ɔbɛ́ɛ, ‘Mlɩla anɩ Wíe ɔkpa. Mlɩtswii ɩkpa ha mʋ!’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Asú Ɔbɔpʋ́ Yohane lɛ́ba ɔdɛ ahá asú bɔ, ɔdɛ Bulu asʋ́n ɔkan da Yudea dimbísʋ́ ɔbɛ́ɛ, “Mlɩdamli klʋntɔ, amlɩsi lakpan bwɛ. Bulu osikie mlɩ, ambɔ mlɩ asú.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ahá botsu Yerusalem wúlutɔ pʋ́ Yudea ɔmátɔ́ fɛ́ɛ́ bá mʋ wá. Bɛlɛ amʋ́ lakpan blɩ́, ɔlɔbɔ amʋ́ asú Yordan ntsutso. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane lɔ́wa kpɔ́sɔ́-imi atadɩɛ, ɔlɔpʋ ɔwʋlʋ́-kpákpá ɔfɛ́ klɩ́ mʋ́sʋ́. Atsantsankʋ pʋ́ ɔkwɛ́n otegyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Oletsiá dá asʋ́n ɔkan, blɩ́ ɔbɛ́ɛ, “Ɔkʋá ɔdʋn mɩ bʋ ɔma ɔbá. Mmɔfʋn ánɩ́ nógyonká sánkɩ́ mʋ ntʋkʋta ɔfɛ́ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɩ́ mʋ́ á, ntsu ndɛpʋbɔ́ mlɩ asú, támɛ mʋ mʋ́ ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ bɔ́ mlɩ asú.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nkɛ ámʋtɔ á, Yesu lótsu Nasaret, wúluá ɩbʋ Galilea ɔmátɔ́ ba Yohane wá, Yohane lɔ́bɔ mʋ asú Yordan ntsutso. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu lénya dálɩ ntsu ámʋtɔ alɩ, olowun nwʋlʋ́táa lefinkí, Ɔŋɛ Wankɩ́hɛ́ dɛ́kplɩ́ dalɩ mʋ́tɔ́ fɛ́ abrɔ́dʋma, ɩlobogyonká mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɩnʋ ɔmɛ kʋ lótsu ɔsʋ́sʋ́ ɔbɛ́ɛ, “Fʋ́gyí mɩ́ bíá ntɔdwɛ́, mɩ ansɩ́ tɛhɩ́ɛ́ gyí fʋ́ ɩwɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ɩnʋnʋ Ɔŋɛ Wankɩ́hɛ́ amʋ lɛ́kpa Yesu ya dimbísʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Oletsiá ɩnʋ nkɛ adʋana, Satan létsiá bɔsɔ mʋ kɩ. Mʋa pututɔ-mbwɩ létsiá, Bulu-abɔpʋ bɛba bɛkɩ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bɛkɩtá Yohane tswɩ obu ɔma a, Yesu lɔ́yɔ Galilea ɔmátɔ́, ɔdɛ Bulu asʋn wankláán ámʋ ɔkan da. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ɔbɛ́ɛ, “Brɛ́ ámʋ lafʋn. Bulu iwíegyí ámʋ lawíé wóyí tá. Mlɩdamli klʋntɔ ba Bulu wá, amlɩhɔ mʋ asʋn wankláán ámʋsʋ gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ɛkɛ ɔkʋ Yesu ná Galilea ɔpʋ ɔnɔ́, olowun Simon mʋa mʋ gyama Andrea. Bʋdɛ asawu tswɩ́ɩ, tsúfɛ́ aye alɛpʋ́ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩba bobuo mɩ. Nɔ́bwɛ mlɩ anyánkpʋ́sa alɛpʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɩnʋnʋ besi amʋ́ asawu aná tswɩ, kplá buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔlɛnatɩ́ yɔ́ nkpá kpalobí á, olowun Sebedeo abí, Yakobo mʋa mʋ gyama Yohane ɛ́. Bʋbʋ ɔklʋntɔ, bʋdɛ amʋ́ asawu bɩ́ɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ɩnʋnʋ Yesu lɛ́tɩ amʋ́ ɛ́, bɛnatɩ́ sí amʋ́ sɩ́ mʋ́a mʋ apafɔ wá ɔklʋn amʋtɔ ba bobuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu mʋa mʋ akasɩ́pʋ́ bɔyɔ Kapernaum wúlutɔ. Ɔlɔyɔ Yudafɔ ofíakpa yósuná atɔ́ ɔkpʋ́nʋ́ ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mʋ atosunáhɛ́ lobwie amʋ́ ɔnɔ́, tsúfɛ́ olosuná amʋ́ atɔ́ túmisʋ. Megyí fɛ́ Mose mbla asunápʋ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oyin ɔkʋ lɛ́ba ofíakpa ɩnʋ, ɔŋɛ laláhɛ bʋ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ɔlɔkplʋ́n blɩ́ ɔbɛ́ɛ, “Yesu Nasaretyin, amansʋ bʋ́ʋ anɩa fʋnyɔ nsɩnɛ́? Anɩ ɔhɩkpá fɛbá lóó? Nyin ɔhá oduá fʋgyi. Fʋ́gyí Bulu Ɔha Wankɩ́hɛ́ amʋ nɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu lɔ́kplʋn wa ɔŋɛ́ ámʋ ɔbɛ́ɛ, “Kpa ɔnɔ́ bun, afʋdalɩ mʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ɩnʋ ɔŋɛ laláhɛ amʋ lɔ́wʋsʋ́ʋ oyin ámʋ ɔwʋnlɩ́nsʋ́, sʋ́rá okitikíti kʋ́klʋ́kʋ́ʋ́, dálɩ mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɔnɔ́ lobwie amʋ́ fɛ́ɛ́, bɛfɩtɛ́ aba bɛɛ, “Ntɔ ofúla nɩ? Ɩ́nɩ mʋ́ á, atosunáhɛ́ pɔpwɛ nɩ. Oyin ánfɩ bʋ túmi, ɔtɔkplʋ́n wa ɔŋɛ laláhɛ, itobú mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɩ́nɩ sʋ Yesu ɩdá lɛklɛɩ́ wá Galilea ɔmá ámʋtɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu mʋa mʋ akasɩ́pʋ́ benya dálɩ Yudafɔ ofíakpa ɩnʋ alɩ, bɔyɔ Simon mʋa Andrea wóyítɔ́. Yakobo mʋa Yohane ɛ́ bʋbʋ amʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bɔyɔ á, owísó lakɩ́tá Simon mʋ sia tsɩ́hɛ́, ɔda. Ɩnʋnʋ bɛbláa Yesu ɔtsɩ ámʋ ɩwɩ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mʋ́ʋ́ ɔlɔyɔ yɛ́kɩtá ɔtsɩ ámʋ ɩbɩ, tsú mʋ kʋ́sʋ́. Ɩnʋnʋ owísó ámʋ lɔ́kʋsʋ́ mʋsʋ, ɔlɔbwɛ amʋ́ afɔɔ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mʋ́ ntʋ́pwɛ fɔɔn a, bɔpʋ alɔpʋ pʋ́ ahá ánɩ́ ɔŋɛ laláhɛ dɛ amʋ́ háan fɛ́ɛ́ ba Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wúlu amʋ fɛ́ɛ́ bɛba befia wóyí ámʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu lɛ́tsa ahá tsɔtsɔɔtsɔá bʋdɛ ɩlɔ ɔtsan-ɔtsan lɔ, olegya ɔŋɛ laláhɛ tsɔtsɔɔtsɔ ɛ́ lɛ́ ahátɔ. Ɔmɛha ɔŋɛ laláhɛ amʋ abʋtɔɩ, tsúfɛ́ amʋ́ fɛ́ɛ́ bʋyin mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mʋ́ ɔyɩ kɛhɛ bakɛ a, Yesu lɛ́dalɩ wúlu amʋtɔ yɔ ɩtsɛ́tɔ́ ɔdɛ mpáɩ bɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Támɛ Simon mʋa mʋ aba bɔbɔ mbɔ́dɩ́ dúnká mʋ alɩɩ yówun mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Brɛ́á bowun mʋ a, bɛbláa mʋ bɛɛ, “Ahá fɛ́ɛ́ bʋdɛ fʋ́ dunká.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ “Mlɩha ayɔ awúlu bámbásʋ́, anyɛda Bulu asʋ́n ámʋ ɔkan ɩnʋ ɛ́, tsúfɛ́ ɩ́nɩ sʋ nɛba nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɩnʋ ɔlɔyɔ yéki Galilea ɔmátɔ́ fɛ́ɛ́, ɔdɛ asʋ́n ámʋ ɔkan da Yudafɔ ofíakpa fɛ́ɛ́, ɔdɛ ɔŋɛ laláhɛ ɛ́ gyáa lɛ ahátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɩlɔ pɛpɛ ɔlɔpʋ́ ɔkʋ lɛ́ba bɛda akpawunu Yesu ayabitɔ, kókóli mʋ ɔbɛ́ɛ, “Owíé! Nɩ́ fótsulá á, fɛ́talɩ́ há mɩ́ ɩwɩ bɛ́plɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mʋ asʋ́n lɔ́wa Yesu nwɛ. Mʋ́ sʋ ɔlɛtɩnkɩ́ ɩbɩ da mʋ, bláa mʋ ɔbɛ́ɛ, “Natsúlá, fʋ́ ɩwɩ ɩplɩ́ɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɩnʋnʋ ɩlɔ pɛpɛ amʋ ɩlɛta, mʋ ɩwɩ lɛ́plɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mʋ́ʋ́ Yesu lɛ́da mʋ ɔlá ɔbɛ́ɛ, “Mábla ɔhaa asʋ́n ánfɩ. Natɩ laa afʋpʋ fʋ́ ɩwɩ yosuná Bulu igyí ɔhapʋ́, afʋha mʋ ɩwɩgyʋrátɔ amʋ́ʋ́ Mose mbla lósuná tsú ɩlɔ pɛpɛtsa ɩwɩ ámʋ. Igyi adánsɩɛ suna ahá ánɩ́ fʋ́ ɩwɩ laplɩ́ɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Támɛ oyin ámʋ lénya dálɩ ɩnʋ alɩ, ɔlɔwa mʋ́ ɔkan da bɩ. Ɔlɛda asʋ́n ámʋ ɔkan wúlu amʋtɔ fɛ́ɛ́ fíá. Mʋ́ sʋ Yesu mɛ́tra talɩ́ lɛ́ ɩwɩ ɔwan wíé wúlu kʋkʋtɔ, ɩtsɛ́tɔ́ oletsiá tsíá. Támɛ mʋ́ ó á, ahá betsiá tsú ntɩ́nɛ́-ntɩ́nɛ́ ba mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nkɛ kpalobí kʋ ɔma a, Yesu léyinkí yɔ́ Kapernaum wúlutɔ. Ahá bonu ánɩ́ alaba wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mʋ́ sʋ ahá tsɔtsɔɔtsɔ bɛba bɔbʋlá wóyí ámʋ. Ɔkpa kʋ́ráá ɩtráa ma ɩnʋá fɔ́tsʋn wie mʋ́tɔ́. Yesu lɛ́da Bulu asʋ́n ámʋ ɔkan súná amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ahá abaná bɔsʋrá tsukʋlɛ osínpʋ ɔkʋ akpasʋ ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ɔdɔm amʋ sʋ bʋmenya ɔkpa pʋ́ mʋ wíé Yesu wá. Ɩ́nɩ sʋ bɔyɔ́dʋ obu ámʋ awunso, dá mʋ́ ɔtɩnɛkʋ tíí, bɛkplɩ́a akpa amʋ tsʋn ɔbɔ́ ámʋtɔ, pʋ́ mʋ tswɩ Yesu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Brɛ́á Yesu lówun ánɩ́ bahɔ mʋ gyi a, ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, “Mɩ́ bí, nasí fʋ́ lakpan kíé fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɩnʋ Mose mbla asunápʋ́ akʋá bʋtsie ɩnʋ, bɛblɩ́ wá nwuntɔ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ntɔ asʋ́n oyin ánfɩ dɛ́blɩ́ alɩ? Megyí mbusuo álabɔ́ á? Ma ɛ́ ɔbɛ́talɩ́ sí lakpan kíé ahá dʋn Bulu nkʋlɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu lɛ́bɩ ánɩ́ bʋdɛ nwɛ́ɛn gyí amʋ́ nwuntɔ. Mʋ́ sʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ɩ́nɩ odu gywɩɩ́n? ");
INSERT INTO nkoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mɔmʋ bɔ́wa ablɩ́lɛ́ ánɩ́ nɛ́bláa tsukʋlɛ osínpʋ anfɩ? ‘Nasí fʋ́ lakpan kíé fʋ́’ ntɛ́ɛ ‘Kʋsʋ tsu fʋ́ akpa afʋnatɩ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Támɛ ndekléá mlɩbɩ́ɩ ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mbʋ túmi ɔyɩ́ ánfɩtɔ sí ahá lakpan kíé amʋ́.” Ɩnʋ ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndɛ fʋ́ bláa mbɛ́ɛ, kʋsʋ! Tsu fʋ́ akpa afʋnatɩ yɔ wóyítɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɩnʋnʋʋnʋ ɔlɔkʋsʋ́, tsú mʋ akpa, nátɩ́ amʋ́ ansɩ́tɔ́ ɩnʋ. Ɩ́nɩ lɔ́wa amʋ́ fɛ́ɛ́ wánwan, bɛkanfʋ́ Bulu blɩ́ bɛɛ, “Anɩmɔ́kʋ́wun ofúla anfɩ odu kɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu lɛ́trá yɔ Galilea ɔpʋ ɔnɔ́. Ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛba mʋ wá, olosuná amʋ́ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Brɛ́á ɔlɔpʋ ɔyɔ́ á, olowun Alfeo mʋ bi Lewi tsie mʋ lampóo ɔhɔ́kpa. Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Bobuo mɩ.” Ɩnʋnʋ ɔlɔkʋsʋ́ buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mʋ́ ɔma a, Lewi lɛ́tɩ Yesu mʋa mʋ akasɩ́pʋ́ atɔ́ ogyíkpá mʋ wóyítɔ́. Lampóo ahɔ́pʋ pʋ́ lakpan abwɛpʋ́ tsɔtsɔɔtsɔ ɛ́ bobuo mʋ ba atɔ́ ámʋ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Brɛ́á Mose mbla asunápʋ́ amʋtɔ akʋá bʋgyi Farisifɔ bowun ánɩ́ Yesu mʋa lakpan abwɛpʋ́ pʋ́ lampóo ahɔ́pʋ bʋdɛ atɔ́ gyí a, bɛfɩtɛ́ mʋ akasɩ́pʋ́ bɛɛ, “Ntogyi sʋ́ mʋa lakpan abwɛpʋ́ pʋ́ lampóo ahɔ́pʋ bʋdɛ ɩbɩ wa gyi atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu lónu asʋ́n ánfɩ, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Alɔpʋ léhián ɩlɔ ɔtsapʋ́, megyí ahá ánɩ́ ɩwɩ bʋ amʋ́ ɔnlɩn. Mmɛba aha wankláán ɔtɩkpá, mboún lakpan abwɛpʋ́ ɔtɩkpá nɛba.” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Asú Ɔbɔpʋ́ Yohane akasɩ́pʋ́ pʋ́ Farisifɔ bʋtetsíá klɩ́ ɔnɔ́. Ɛkɛ ɔkʋ akʋ bɛba bɛfɩtɛ́ Yesu bɛɛ, “Ntogyi sʋ́ Yohane akasɩ́pʋ́ pʋ́ Farisifɔ akasɩ́pʋ́ bʋtɛklɩ́ ɔnɔ́, támɛ fʋ́ akasɩ́pʋ́ mʋ́ bʋtamaklɩ́ ɔnɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ ɔtsɩ ɔkpaɩ́npʋ́ bʋ mʋ anyawíe wá á, bɛ́klɩ́ ɔnɔ́? Ɛkɛkɛɛkɛ! Ɩ́nɩá ɔbʋ amʋ́ wá ánfɩ mʋ́ á, bʋmɛ́ɛklɩ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Támɛ ɛkɛ kʋ bɛ́ba ánɩ́ bɛ́kpa ɔká otsiápʋ amʋ nátɩ́ sí amʋ́. Alɩ nkɛ ámʋtɔ bɛ́klɩ́ ɔnɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ɔhaa tamapʋ́ tati pɔpwɛ tan tati dada. Tsúfɛ́ tati pɔpwɛ amʋ bɛ́kpɩkpɩ́ɩ tsií dáda amʋ ɩkʋ lɛ́, há ɔtánkpa ɩnʋ bɛ́latɛ́ɩ́ tsɩ́a. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Alɩ kɛ́n bʋtamapʋ́ nta pɔpwɛ wá ɔwʋlʋ́-kpákpá kɛntɛ wuhɛ́tɔ́ nɩ́. Nta pɔpwɛ amʋ ibófu fá kɛntɛ amʋ tsítsá, yíntá kɛntɛ amʋ ɛ́. Ɩ́nɩ sʋ ɔwʋlʋ́-kpákpá kɛntɛ pɔpwɛtɔ bʋ́tɔpʋ́ nta pɔpwɛ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu mʋa mʋ akasɩ́pʋ́ bɔtsʋn ayó ndɔ kʋtɔ ɔkpʋ́nʋ́ ɔdakɛ́, mʋ akasɩ́pʋ́ bɔpʋsáa ayó ámʋ kʋ wɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisifɔ akʋ bowun amʋ́, bɛfɩtɛ́ Yesu bɛɛ, “Kɩ, ntogyi sʋ́ bʋdɛ tɔ́á anɩ mbla mɛha ɔkpa bwɛ ɔkpʋ́nʋ́ ɔdakɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩmɔ́kʋ́kla nu tɔ́á Owíe Dawid lɔ́bwɛ brɛ́á akʋ́n dɛ mʋa mʋ abúopʋ, bʋma tɔtɔá bégyi kɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Olebitíwíé Bulu osúmkpa yótsu bodobodoá bapʋ́há Bulu igyí ba, mʋa mʋ abúopʋ amʋ begyi, Bulu igyí ɔhapʋ́ dɛhɛn Abiata bɩ́sʋ́. Bulu igyí ahapʋ́ nkʋlɛ bɛlɛ ɔkpa bʋ́tegyi alɩ bodobodo amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mʋ́ʋ́ ɔlɛtrá bláa amʋ́ ɔbɛ́ɛ, “Nyankpʋsa sʋ́ Bulu lɔ́bwɛ ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ. Megyí ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ sʋ́ Bulu lɔ́bwɛ nyankpʋsa. ");
INSERT INTO nkoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mʋ́ sʋ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ gyí ɔkpʋ́nʋ́ ɔdakɛ́ mʋ wie!” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu lɛ́trá yɔ Yudafɔ ofíakpa ɩnʋ á, oyin ɔkʋ tsie ɩnʋ, mʋ ɩbɩ kʋlɛ lawú. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aha akʋ bʋdɛ Yesu tɛ́ɛ, abʋkɩ bɛɛ ɔbɛ́tsa mʋ ɩlɔ ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ, mɛ́nɩ bénya mʋ ɩwɩ asʋ́n blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu lɛ́bláa oyin ámʋ́ʋ́ mʋ ɩbɩ kʋlɛ lawú ámʋ ɔbɛ́ɛ, “Kʋsʋ bɛlɩɩ́ amʋ́ ansɩ́tɔ́ nfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ anɩ mbla lɛ́ha ɔkpa ánɩ́ abwɛ́ɛ ɔkpʋ́nʋ́ ɔdakɛ́? Yilé lóó, ntɛ́ɛ lalahɛ. Ahɔ́ɔ ɔha nkpa lóó, ntɛ́ɛ amɔ́ɔ mʋ?” Támɛ ɔhaa mɛ́lɛ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu lɔ́pʋ ɔblɔ́ kɩ amʋ́ bómlí. Ɩlɔhɔ mʋ ɔsɩn, tsúfɛ́ klʋntɔ bʋ amʋ́ odwin. Mʋ́ʋ́ ɔlɛbláa oyin ámʋ ɔbɛ́ɛ, “Tɩnkɩ fʋ́ ɩbɩ amʋ.” Olenya tɩ́nkɩ́ mʋ́ alɩ pɛ́, ɔŋɛ́ lowie mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisifɔ ámʋ bɛdalɩ yɔ, amʋ́a Owíe Herode ahá bɛkɩtá agywɩɩn ɩnʋnʋ alɩá bɔ́bwɛ bɔ́mɔ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu mʋa mʋ akasɩ́pʋ́ bɛnatɩ́ bɔyɔ́ Galilea ɔpʋ ɔnɔ́. Ɔdɔm kpɔnkpɔɔnkpɔntɩ bobuo mʋ tsú Galilea mʋ́a Yudea ɔmátɔ́, Yerusalem, Idumea, Yordan bʋnkpa ɔbɩn pʋ́ Tiro mʋ́a Sidon nsáɩntɔ ba mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ahá ámʋ bɔdʋbɩ. Mʋ́ sʋ ɔlɛbláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, bʋdúnka ɔklʋn kʋ yaɩ ha mʋ, mɛ́nɩ bʋmóoputá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tsúfɛ́ alatsá ahá tsɔtsɔɔtsɔ ɩlɔ. Mʋ́ sʋ alɔpʋ amʋtɔ okugyíɔkʋ dékléá ɔbɔ́pʋ ɩbɩ da mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nɩ́ ahá ánɩ́ ɔŋɛ laláhɛ bʋ amʋ́sʋ́ benyá wun mʋ alɩ á, badɩda mʋ ayabiasɩ, sʋ́rá okitikíti blɩ́ bɛɛ, “Fʋ́gyí Bulu mʋ Bi ámʋ nɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Támɛ ɔlɛda ɔŋɛ laláhɛ amʋ ɔlá kínkíínkín ɔbɛ́ɛ, ɩmáha ahá abʋbɩ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu lɔ́dʋ yɔ́ bʋsʋ, ɔlɛtɩ ahá ánɩ́ mʋ onutó odeklé, bɔyɔ́tʋ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Mʋ́ʋ́ ɔlɛlɛ amʋ́tɔ́ ahá dúanyɔ, ɔlɛtɩ amʋ́ mʋ sumbí ayɔpʋ́ ánɩ́ mʋa amʋ́nyɔ bétsiá, otsia wa amʋ́ abʋyɛda mʋ asʋ́n ɔkan, abʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ahá dúanyɔ ámʋ adá gyí, Simon ánɩ́ ɔlɛdɩnká mʋ Petro; ");
INSERT INTO nkoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeo abí Yakobo mʋa mʋ pio Yohane (ɔlɛdɩnká amʋ́ adá ɔbɛ́ɛ, “Boanerges.” Mʋ́ asɩ gyí, “Ɔpráda abí.”); ");
INSERT INTO nkoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Atráhɛ gyí, Andrea, Filipo, Bartolomeo, Mateo, Toma, Alfeo mʋ bi Yakobo, Tadeo mʋa Simon ánɩ́ ogyi ɩwɩsʋtsiá adunkápʋ́ ɔpasuatɔ ɔha; ");
INSERT INTO nkoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pʋ́ Yuda Iskariot ánɩ́ ɔlɛbɛlɛ mʋ há. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Brɛ́á Yesu lɔ́yɔ wóyítɔ́ a, ɔdɔm bɛtrá ba ɩnʋ. Mʋa mʋ akasɩ́pʋ́ bʋmenyá ɔkpa ánɩ́ bégyi atɔ́ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Brɛ́á mʋ wóyítɔ́ ahá bonu mʋ ɩwɩ asʋ́n á, bɔyɔ bɛyɛ́kpa mʋ, tsúfɛ́ bʋkɩ bɛɛ mʋ nwun layíntá. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mose mbla asunápʋ́ akʋá botsu Yerusalem ba ɩnʋ bɛblɩ́ bɛɛ, “Ɔŋɛ laláhɛ owíe Beelsebul tsíe mʋtɔ. Mʋ túmi ɔdɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mʋ́ sʋ Yesu lɛ́tɩ amʋ́ ba mʋ ɩwɩ wá, ɔlɛbláa amʋ́ asʋ́n ayébitɔ ɔbɛ́ɛ, “Nkálɩ Ɔbʋnsám ɔbɛ́talɩ́ gya mʋ ɩwɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iwíe ogyíkpá ánɩ́ ɩlaye anyɔ, bʋdɛ aba kɔ ɩbɛ́dɩda. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wóyí oduá mʋ́tɔ́ atsiápʋ́ bʋdɛ aba kɔ ɛ́ itobwíé. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mʋ́ sʋ nɩ́ Ɔbʋnsám dɛ́ mʋ ɩwɩ gyáa a, ɔmɛ́ɛtalɩ́ lɩ́ɩ́. Mʋ ɔnɔ́ ɔmɔkpá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ɔhaa mɛ́ɛtalɩ́ wíé ɔwʋnlɩ́npʋ́ wóyítɔ́ yɔ́kʋlá mʋ atɔ́, nkɛ́tɩ alagyankpá kɩ́klɩ mʋ tswɩ, asa ɔbɛ́talɩ́ kʋ́lá mʋ atɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́talɩ́ sí lakpan pʋ́ abususʋ kugyíkʋ kíé nyankpʋsa. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Támɛ nɩ́ ɔkʋ ɔblɩ́ abususʋ Ɔŋɛ Wankɩ́hɛ́ amʋ ɩwɩ á, Bulu méesikíé mʋ ɛkɛkɛɛkɛ, tsúfɛ́ alabwɛ́ lakpan ánɩ́ sikíé ma mʋ́ ɩwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aha akʋ bɛblɩ́ bɛɛ, ɔŋɛ laláhɛ bʋ́ Yesutɔ. Mʋ́ sʋ ɔdɛ ɩ́nɩ blɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu mʋ yin mʋa mʋ apio bɛba bɛlɩɩ́ kpankpá, bɔwa ɔkʋ bɛɛ, ɔtɩ́ɩ mʋ ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɔdɔm bʋtsie bomlí mʋ, bɛbláa mʋ bɛɛ, “Fʋ́ yín mʋa fʋ́ apíó bʋlɩɩ́ kpankpá, bʋdɛ fʋ́ dunká.” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Amɛndɩ gyí mɩ́ yín mʋa mɩ́ apíó?” ");
INSERT INTO nkoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mʋ́ʋ́ ɔlɛkɩ ahá ámʋ́ʋ́ bʋtsie bomlí mʋ amʋ, blɩ́ ɔbɛ́ɛ, “Mlɩkɩ, mɩ́ yín mʋa mɩ́ apíó gyí ahá ánfɩ á! ");
INSERT INTO nkoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɔhagyíɔha ánɩ́ ɔtɔbwɛ́ Bulu apɛ́ a, mʋgyí mɩ́ píó pʋ́ mɩ́ yín nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu lɛ́trá kʋsʋ́ yɔ́ ɔdɛ atɔ́ suná Galilea ɔpʋ ɔnɔ́ ɛkɛ ɔkʋ. Ɔdɔm amʋ bobomlí mʋ. Mʋ́ sʋ ɔlɔdʋ wíé ɔklʋntɔ, yétsiá ɔpʋ amʋsʋ, ahá ámʋ ɛ́ bʋlɩɩ́ ɔpʋ ɔnɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ɩnʋ olosuná amʋ́ atɔ́ tsɔtsɔɔtsɔ ayébitɔ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mlɩnu! Ɔdɔtɔpʋ ɔkʋ lɔ́yɔ atɔ́-abí owunyákpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Brɛ́á ɔdɛ mʋ́ wunyáa a, ɩkʋ lɔwʋlɩ́ ɔkpatɔ, mbubwi bɛba bɔtswɛtswɛ́ɛ mʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɩkʋ ɛ́ lɔwʋlɩ́ abʋtásʋ́, ɔtɩ́nɛ́á ɩsɩ kpalobí dɩn. Ɩlɔwa ɔsa kwɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","támɛ brɛ́á owí lɛlɩn a, ɩlɔtɔ mʋ́ mɔ́, tsúfɛ́ mʋ́ nlín mɔyɔ ɔtɔ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Abí ámʋ kʋ lobun awutɔ, awu ámʋ lɔbʋlá kɩ́tá mʋ́, ɩmɛdan. Mʋ́ sʋ imoswie abí. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Támɛ abí ámʋ kʋ ɛ́ lɔwʋlɩ́ ɔsʋlʋ́ʋ wankláánsʋ́, ɩlɔkwɛ, dan, swie abí, ɩkʋ adʋasa (30). Ɩkʋ aduesie (60), ɩkʋ ɛ́ lafa (100).” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ɩnʋ ɔlɔmɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔhá ánɩ́ ɔbʋ asʋ onúu!” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Brɛ́á ilesi Yesu mʋa sumbí ayɔpʋ́ dúanyɔ ámʋ pʋ́ ahá kpalobí akʋá bʋbuo mʋ a, bobwií ɩpa há mʋ bɛɛ, ɔlɛ́ yébi anfɩ asɩ suna amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩ mʋ́ á, Bulu lahá mlɩ ɔkpa ɔbɛ́ɛ, mlɩbɩ́ɩ mʋ iwíegyí ámʋ ɩwɩ asʋn ŋaínhɛ́. Támɛ ndɛ aha bambá asʋ́n bláa ayébisʋ, ");
INSERT INTO nkoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘mɛ́nɩ bówun láwun, támɛ bʋmɛ́ɛbɩ mʋ́. Bónu lánú, támɛ bʋmóonu mʋ́ asɩ. Nɩ́ megyí alɩ tɛkɩ bɛ́damlí klʋntɔ, Bulu obési amʋ́ lakpan kíé amʋ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɩmónu yébi anfɩ asɩ á, mʋ́ nkálɩ mlɔ́bwɛ asa mlónu tráhɛ fɛ́ɛ́ asɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Atɔ́-abí ámʋ́ʋ́ owunyápʋ amʋ déwunyáa amʋ gyí Bulu asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ ɔkpasʋ ámʋ gyí ahá ámʋ́ʋ́ benyá nú Bulu asʋ́n ámʋ alɩ Ɔbʋnsám labɛlɛ mʋ́ lɛ́ amʋ́ klʋntɔ nátɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ abʋtásʋ́ amʋ gyí ahá amʋ́ʋ́ bonú asʋ́n ámʋ pɛ́, bahɔ mʋ́ ansigyísʋ́, ");
INSERT INTO nkoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","támɛ ɩ́nɩá bʋma nlín sʋ á, asʋ́n ámʋ ɩtamatsíá amʋ́tɔ́ yɔ́. Mʋ́ sʋ nɩ́ bʋdɩn amʋ́sʋ́ ntɛ́ɛ ɩwɩɔsɩn kʋ ɩtʋ́ amʋ́ asʋ́n ámʋ sʋ á, ɩnʋnʋ bʋtɛdɩda. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ awutɔ ámʋ gyí ahá amʋ́ʋ́ bonú asʋ́n ámʋ a, bahɔ mʋ́, ");
INSERT INTO nkoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","támɛ ɔyɩ́ ánfɩtɔ atɔ hiánhɛ ɩwɩ gywɩɩ́n, pʋ́ mʋ́tɔ́ atonyahɛ́ ɩwɩ ɔnsɩ́pɛ tegyi asʋ́n ámʋsʋ. Ɩ́nɩ sʋ bʋtamaswíé abí. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ ɔsʋlʋ́ʋ wankláánsʋ́ amʋ gyí ahá amʋ́ʋ́ bonú asʋ́n ámʋ a, bʋtegyi mʋ́sʋ́. Ɩ́nɩ sʋ ɩtɛhá bʋtɔbwɛ́ yilé fɛ́ alɩá atɔ́-abí ámʋ loswie, ɩkʋ adʋasa (30), ɩkʋ aduesie (60), ɩkʋ ɛ́ lafa (100) ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bʋtonywɛ́ ɔkandɩ́ɛ pʋ́ ɔlɔ́ bun mʋ́sʋ́, ntɛ́ɛ pʋ́wá mpá ayasɩ? Megyí ɔfʋákpá bʋtɔpʋ́bian? ");
INSERT INTO nkoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tɔtɔ ma ɩnʋá ibéŋaín, ɩmɛ́ɛlɩn ɔwan. Asʋn ŋaínhɛ́ kʋkʋ ɛ́ ɩma ɩnʋá bʋmɛ́ɛbɩ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɔhagyíɔha ánɩ́ ɔbʋ asʋ onúu!” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Mlɩyaa asʋ wankláán mlɩ asʋ́n-nutɔ́. Ɩtɔ́á mlɔ́pʋsúsu ha mlɩ aba á, mʋ́ kɛ́n Bulu ɔbɔ́pʋsúsu mʋ́ wankláán, lápʋ́ ɩkʋ tsɩ́a mʋ́tɔ́ há mlɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsúfɛ́ ɔhá ánɩ́ odekléá obónu mɩ́ atosunáhɛ́ amʋ asɩ á, Bulu ɔbɔ́pʋ ɩkʋ tsɩ́a mʋ́tɔ́ há mʋ. Támɛ ɔhá ánɩ́ omedékléá obónu mʋ́ asɩ á, Bulu ɔbɔ́swɩɩ́ mʋ kpalobí ámʋ́ʋ́ alabɩ́ ámʋ kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu lɛ́trá blɩ́ ɔbɛ́ɛ, “Bulu iwíegyí amʋ igyi fɛ́ alɩá ɔha todú oyí-ibí mʋ ndɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nɩ́ owí ɩtá á, ɔhá ámʋ tɛklɛdɩ. Nɩ́ ɔyɩ́ ɩkɛ a, ɔtɛlákʋ́sʋ́, támɛ omeyín alɩá ɩtɔbwɛ́ asa oyí-ibí ámʋ ɩtɔkwɛ dan. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ɔsʋlʋ́ʋ onutó tɛhá mʋ́ tɔkwɛ. Itegyankpá lɛ́ atɛ, wá ntswɩ́tswɩ́ɩ, asa ɩtɔbɔbwɛ abí onutó. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Támɛ ayó ámʋ inyá blɩ pɛ́, ɔdɔ́pʋ amʋ latsú mʋ ɔdayí ɔyɛ́tɩn mʋ́, tsúfɛ́ mʋ́ tɩ́nbɩ lafʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɩnʋ Yesu lɛ́fɩtɛ́ ɔbɛ́ɛ, “Ntɔ Bulu iwíegyí ámʋ lɛlɩan? Ntɛ́ɛ yébi mɔmʋ nɔ́pʋsúná alɩá igyi? ");
INSERT INTO nkoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Igyi fɛ́ takyí-akpin ibí. Mʋ́gyí túkúrííbi nyí-abítɔ́ fɛ́ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Támɛ nɩ́ ɩdan a, ɩtɔbwɛ́ ɩfá fʋ́áhɛ́ dʋn ɩfá kugyíkʋ. Mʋ́ abámbi tekpíkpli, mbubwi bʋtogyónká mʋ́ asɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oletsiá pʋ́ ayébi anfɩ odu tsɔtsɔɔtsɔ súná amʋ́ atɔ́, yɔ́fʋn alɩá ahá ámʋ bɛ́talɩ́ nú mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔmɛbláa amʋ́ asʋ́n kʋkʋá imegyí ayébi ɔlɔpʋtɔ́ɩ́. Támɛ nɩ́ isí mʋa mʋ akasɩ́pʋ́ nkʋlɛ a, ɔtɛlɛ́ tógyítɔ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Alɩ ɛkɛ ámʋ ntʋ́pwɛsʋ á, Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Mlɩha afa Galilea ɔpʋ yɔ mʋ́ ɔbɩn!” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mʋ́ʋ́ bowie ɔklʋntɔ, akasɩ́pʋ́ amʋ bɛplá mʋ́, bɛnatɩ́ sí ɔdɔm amʋ. Nklʋn bámbá kʋ ɛ́ lobuo amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Afú kpɔnkpɔɔnkpɔntɩ kʋ lɔ́wa tsʋ́ʋn bɩ. Mʋ́ sʋ ntsu dɛda wíé ɔklʋn amʋtɔ, ideklé ɩmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Támɛ Yesu mʋ́ ŋɛ́lɩ́n sumuɛsʋ ɔklʋn amʋ ɔma ɔdɛdɩdɩ. Akasɩ́pʋ́ amʋ betsinkí mʋ. Mʋ́ʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, ɩ́nɩá anɩdɛ́ ntsu wie á, fʋmotsu kʋkʋ lɛ́ mʋ́tɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ɩnʋ Yesu lɔ́kʋsʋ́ lɛ́ ɔnɔ́ wa afú ámʋ, ɔlɛbláa ɔpʋ amʋ ɔbɛ́ɛ, “Kpa ɔnɔ́ bun! Dɩ díín!” Ɩnʋ afú ámʋ lési tsʋ́ʋn, ɩnʋ fɛ́ɛ́ lɔlʋá. ");
INSERT INTO nkoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ifú nya alɩ? Mlɩmá hógyi?” ");
INSERT INTO nkoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ifú lɛhɩɛ kɩ́tá amʋ́, bɛfɩtɛ́ aba bɛɛ, “Nyankpʋsa ɔmɔmʋ nɩ, afú mʋ́a ntsu kʋ́ráá tonú mʋ ɔmɛ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ amʋ bowie Galilea ɔpʋ amʋ ɔbɩn Gerasefɔ ɔsʋlʋ́sʋ á, ");
INSERT INTO nkoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","olenya kplɩ́ dálɩ ɔklʋntɔ alɩ, oyin ɔkʋá ɔŋɛ laláhɛ bʋ mʋtɔ lɛ́dalɩ tsu afúli opulákpá befia mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oyin ánfɩ lapʋ́ afúli opulákpá ɩnʋ bwɛ́ mʋ otsiákpá. Ɔhɩ́ɛ́ ɔbʋ ɩyɩn. Mʋ́ sʋ ɔhaa tamatráa talɩ́ bwɛ́ mʋ otsia díín, ntɛ́ɛ wá mʋ ɩkan. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tsúfɛ́ tɛkɩ betsiá wá mʋ ayabi pʋ́ mʋ ɩbɩ ɩkan, támɛ oletsiá tɩn mʋ́, bíábía ɩkan amʋ tsálɩ́fwɩ́. Ɔhaa ɛ́ má ɔwʋnlɩ́n ánɩ́ ɔbɛ́talɩ́ pɔ́n mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ekekegyíɛkɛ ɔpa mʋ́a onyé fɛ́ɛ́ á, ɔbʋ afúli opulákpá ɩnʋ mʋ́a abʋsʋ, ɔdɛ okitikíti, ɔdɛpʋ abwi tsantsan ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Olenya wun Yesu sɩ́sɩ́ alɩ, ɔlɛsrɩ́ yɛ́da akpawunu mʋ ayabitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mʋ́ʋ́ ɔlɔsʋrá okitikíti kʋ́klʋ́kʋ́ʋ́ ɔbɛ́ɛ, “Ɔsʋ́sʋ́ʋ́sʋ́ Bulu mʋ Bi Yesu, amansʋ igyi? Tanʋ Bulu ánɩ́ fʋmɛ́ɛpɩtɩ́ mɩ́ atɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔlɛblɩ́ asʋ́n ánfɩ, tsúfɛ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔŋɛ laláhɛ, dalɩ oyin ánfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ɩnʋ Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Nkálɩ bʋtɛtɩ́ fʋ́?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ dá gyí, ‘Ɔdɔm’, tsúfɛ́ anɩhɩ́ɛ́ anɩ tsɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɩnʋ ɔŋɛ laláhɛ amʋ bɛhɩɛ kókóli mʋ bɛɛ, ɔmágya amʋ́ lɛ́ Gerasefɔ ɔsʋlʋ́ʋ amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mprákuo tsɔtsɔɔtsɔ akʋ bʋdegyí okúku kʋsʋ ɩnʋ fʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɔŋɛ laláhɛ amʋ bokokóli mʋ bɛɛ, ɔhá amʋ́ abʋyowie mprákuo ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mʋ́ʋ́ ɔlɛha amʋ́ ɔkpa. Bɛdalɩ oyin ámʋtɔ yówie mprákuo ánɩ́ bɔ́bwɛ fɛ́ mpɩ́m-anyɔtɔ (2,000). Amʋ́ fɛ́ɛ́ bɛsrɩ́ kplɩ́ okúku kʋ wíé ɔpʋ amʋtɔ, wúwu. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mprákuo ámʋ akpapʋ́ bɛsrɩ́ yɛ́blɩ́ asʋ́n ánfɩ ɩlaba anfɩ awúlusʋ pʋ́ nkudasɩ fɛ́ɛ́. Ahá bɛdalɩ bɛɛ bɛbá bɛkɩ tɔ́á ɩlaba. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Brɛ́á bɛba bowie Yesu wá á, bowun ánɩ́ oyin ámʋ́ʋ́ ɔŋɛ laláhɛ betsiá mʋtɔ ámʋ ansɩ́tɔ́ ladɩ́, alawá atadɩɛ otsie. Ɩlɔwa amʋ́ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ahá ámʋ́ʋ́ bowun tɔ́á ɩlɛba oyin ámʋ́ʋ́ tɛkɩ ɔŋɛ laláhɛ tsie mʋtɔ ámʋ pʋ́ mprákuo ámʋsʋ ámʋ bɛbláa amʋ́ tɔ́á ɩlaba fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɩnʋ bokokóli Yesu bɛɛ, ɔdálɩ amʋ́ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Brɛ́á olowie ɔklʋn amʋtɔ á, oyin ámʋ́ʋ́ tɛkɩ ɔŋɛ laláhɛ tsie mʋtɔ ámʋ lókokóli mʋ ɔbɛ́ɛ, ɔhá amʋbuo mʋ natɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Támɛ Yesu mɛ́ha mʋ ɔkpa. Mboún ɔlɛbláa mʋ ɔbɛ́ɛ, “Yinki yɔ fʋ́ apíó wá wóyítɔ́, afʋyɛbláa amʋ́ ɩtɔ yiléá anɩ Wíe Bulu labwɛ́ há fʋ́, pʋ́ alɩá alawun fʋ nwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mʋ́ sʋ oyin ámʋ lɛ́natɩ́ tsʋntsʋn, ɔdɛ ɩtɔ yilé ámʋ́ʋ́ Yesu labwɛ́ há mʋ blɩ́ Dekapoli awúlu amʋ fɛ́ɛ́tɔ́. Ɔnɔ́ lobwie ahá ámʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu lɛ́la fá ɔpʋ amʋ yɔ́ mʋ́ ɔbɩn. Brɛ́á ɔbʋ ɔpʋ ɔnɔ́ ɩnʋ á, ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛba bobomlí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɩnʋ Yudafɔ ofíakpa ɔhandɛ ɔkʋá bʋtɛtɩ́ mʋ Yairo lɛ́ba ɩnʋ. Brɛ́á olowun Yesu a, ɔlɛda akpawunu mʋ ayabitɔ, ");
INSERT INTO nkoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kókóli mʋ ɔbɛ́ɛ, “Mɩ́ bí tsɩ́hɛ́ déwu. Ba, afʋbɔpʋ ɩbɩ dɩnka mʋsʋ, mʋ awútɔ́ ɩwa mʋ ɔnlɩn, onya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mʋ́ʋ́ mʋa Yesu bɛnatɩ́ bɔyɔ́ á. Ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛkplá buo mʋ, kpá pútá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɔtsɩ ɔkʋ ɛ́ bʋ ahá ámʋtɔ, obugya dɛ mʋ wʋlɩ́ nfí dúanyɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Alahɩ́ɛ́ wun ipian ɩlɔ atsapʋ́ tsɔtsɔɔtsɔ ɩbɩtɔ, hʋ́lɩ mʋ ɩwɩsʋ atɔ́ fɛ́ɛ́, támɛ ɩlɔ ámʋ ɩmɛkálá bwɛ́ mʋ. Ɩyɩn ɩdɛwa tsɩ́a. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Brɛ́á ɔtsɩ ánfɩ lónu Yesu nka á, ɔlɔtsʋn yɔ mʋ ɔma, fifítíwie ɔdɔm amʋtɔ yɔ́pʋ ɩbɩ da Yesu atadɩɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tsúfɛ́ ɔlɛblɩ́ wá mʋ nwuntɔ ɔbɛ́ɛ, “Nɩ́ nɔpʋ́ ɩbɩ da mʋ atadɩɛ kpán á, ɩlɔ ámʋ ibési mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Olenya pʋ́ ɩbɩ da mʋ atadɩɛ ámʋ alɩ, obugya amʋ lɛ́ka itin. Olonu mʋ́ nka mʋ awútɔ́ ánɩ́ ɩlɔ ámʋ lasí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ɩnʋ Yesu lónu mʋ́ nka mʋ awútɔ́ mʋ ɛ́ ánɩ́ ɔŋɛ́ kʋ ladálɩ mʋtɔ. Ɩnʋnʋ ɔlɛdamlí kɩ ɔdɔm amʋ, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma lápʋ́ ɩbɩ da mɩ́ atadɩɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mʋ́ʋ́ mʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Fʋ́ onutó fawun ánɩ́ ɔdɔm bakpá pútá fʋ. Mʋ́ʋ́ fʋtráa fʋdɛfɩtɛ́ fɛɛ, ‘Ma lápʋ́ ɩbɩ da mɩ?’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu lɔ́wa ansɩ́ kɩ amʋ́tɔ́ fɛ́ɛ́, ɔdɛ ɔhá ánɩ́ ɔlɔpʋ ɩbɩ da mʋ dunká. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ifú lɛ́kɩtá ɔtsɩ ámʋ. Mʋ́ sʋ ɔlɔwa kpɩnkɩ́ kpakpakpakpa bɩ, tsúfɛ́ oyin ɩtɔ́á alanyá. Ɩnʋ ɔlɛba bɛda akpawunu Yesu ayabitɔ, bláa mʋ ɔnɔkwalɩ amʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ bí, fʋ́ hógyi lahɔ fʋ nkpa. Natɩ iwilwiitɔ. Fʋ́ ɩlɔ ámʋ ɩta.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Brɛ́á Yesu bʋ mʋ́sʋ́ ɔdɛtɔɩ́ á, aha akʋ botsu ofíakpa ɔhandɛ amʋ wóyítɔ́ ba bɛbláa mʋ bɛɛ, “Ɔhandɛ, fʋ́ bí tsɩ́hɛ́ ámʋ ɔdɩkpa mɔ́wa alɛ́. Mátepí trá wa osunápʋ́ tɔ́ɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu mɛ́kplá asʋ́n ámʋ́ʋ́ bʋdɛblɩ́ ámʋ. Mboún ɔlɛbláa mʋ ɔbɛ́ɛ, “Mánya ifú. Fʋ́ mʋ́ hogyi wʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu mɛ́ha ɔhaa ɔkpa obuo mʋ dʋn Petro pʋ́ Yakobo mʋa mʋ pio Yohane nkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Brɛ́á bowie ɔhandɛ amʋ wóyítɔ́ á, Yesu lówun ánɩ́ ahá babʋ́lá ɩnʋ, bʋdesú, bʋdɛ okitikíti. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Olowie ɩnʋ fɩ́tɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ipian wúun, mlɩdɛ́ okitikíti alɩ? Otsibi amʋ mɔ́kʋ́wú, dɩdɩ́ ɔdɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ahá ámʋ bɔmɔsɩ́ mʋ. Mʋ́ʋ́ olegya amʋ́ fɛ́ɛ́ dálɩ ba wunsɩnɛ́, ɔlɛkpa obí ámʋ akwɩɩ́pʋ́ pʋ́ mʋ akasɩ́pʋ́ amʋ́ʋ́ bʋbuo mʋ amʋ bebitíwíé obu ámʋ́ʋ́ otsibi amʋ da mʋ́tɔ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɩnʋ ɔlɛkɩtá kebi ámʋ ɩbɩ, bláa mʋ amʋ́ ɔblɩ́tɔ ɔbɛ́ɛ, “Talita Kuum!” (Mʋ́ asɩ gyí, “Obitebí, kʋsʋ!”) ");
INSERT INTO nkoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɩnʋnʋ ɔlɔkʋsʋ́ ɔna. (Otsibi amʋ lahɔ nfí dúanyɔ.) Ilobwie ahá ámʋ fɛ́ɛ́ ɔnɔ́ dáfá. ");
INSERT INTO nkoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mʋ́ʋ́ ɔlɛda amʋ́ ɔlá kínkíínkín ɔbɛ́ɛ, bʋmábláa ɔhaa asʋ́n ánfɩ. Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, bʋháa kebi ámʋ atɔ́ ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu mʋa mʋ akasɩ́pʋ́ bɛdalɩ ɔmá ámʋtɔ yínkí yɔ́ mʋ wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɔkpʋ́nʋ́ ɔdakɛ́ lenya fʋn alɩ, ɔlɔyɔ ɔdɛ atɔ́ suná Yudafɔ ofíakpa. Mʋ atosunáhɛ́ lɛha ɔnɔ́ lobwie ahá tsɔtsɔɔtsɔá bonu mʋ́. Mʋ́ sʋ bɛfɩtɛ́ aba bɛɛ, “Nkʋ́nʋ́ olenya nyánsa mʋ́a ofúlábwɛ túmi ánfɩ ɛ́ tsú? ");
INSERT INTO nkoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Megyí atɔ́ osrépʋ́ amʋ nɩ. Megyí mʋ yin gyí Maria, mʋ apio yinhɛ́ gyí Yakobo, Yosef, Yuda pʋ́ Simon? Yɛ́ɛ anɩa mʋ apio tsɩhɛ́ ɛ́ tsie nfɩ á?” Benya ɔblɔ́ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ahá bʋtobú Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔtɩ́nɛgyíɔtɩ́nɛ́, támɛ mʋ wúlutɔfɔ, mʋ abusuanfɔ pʋ́ mʋ wóyítɔ́ ahá mʋ́ bʋtamabú mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɩ́nɩá bʋmɔhɔ mʋ gyi sʋ ɔmɛtalɩ́ bwɛ́ ofúla kʋkʋ, dʋn ahá kpalobí akʋsʋ ɔ́lɔpʋ ɩbɩ dɩ́nká, tsá amʋ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɩlɔwa mʋ ifú ánɩ́ bʋmɔhɔ mʋ gyi. Yesu léki nkuda ánɩ́ ɩbʋ bomlí ɩnʋ asɩ, ɔdɛ atɔ́ suná. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɩnʋ ɔlɛtɩ akasɩ́pʋ́ dúanyɔ ámʋ ba mʋ ɩwɩ wá. Mʋ́ʋ́ ɔlɔwa amʋ́ sumbí abanyɔ́-abanyɔ́. Ɔlɛha amʋ́ túmiá bɔ́pʋgyi ɔŋɛ laláhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɔlɛda amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩmátsu tɔtɔ kɩ́tá yɔ́ ɔkpa ámʋ, dʋn mlɩ oyi yiáhɛ́! Mlɩmátsu atogyihɛ ntɛ́ɛ akpankogyo, ntɛ́ɛ kɔ́ba kɩ́tá! ");
INSERT INTO nkoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mlɩwa ntʋkʋta, támɛ mlɩmátsu atadɩɛ nyɔɔsɩ kɩ́tá! ");
INSERT INTO nkoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wóyígyíwóyíá mlɔswɩ́ɩ́ mʋ́tɔ́ á, mlɩtsia ɩnʋ yɔ́fʋn brɛ́á mlɛ́dalɩ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɩ́ mlɔyɔ́ wúlu kʋsʋ, bʋmɔhɔ mlɩ, ntɛ́ɛ bʋmekleá bónu mlɩ atosunáhɛ́, mlɩdɛ́dalɩ mʋ́tɔ́ mlɔyɔ́ á, mlɩkpakpa mlɩ ayabitɔ-ɩsɩ wʋlɩ ɩnʋ, isuna ánɩ́ bʋmɛbɩ bwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mʋ́ sʋ bɔyɔ yɛ́da asʋ́n ámʋ ɔkan bɛɛ, ahá bʋdámli klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Begya ɔŋɛ laláhɛ tsɔtsɔɔtsɔ lɛ́ ahátɔ, bɛkpa alɔpʋ tsɔtsɔɔtsɔ ɛ́ ofobí, tsá amʋ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Galilea ɔmásʋ́ ogyípʋ́ Herode lónu Yesu ɩwɩ asʋ́n ánfɩ, tsúfɛ́ mʋ ɩdayilé dɛ ɔtɩ́nɛgyíɔtɩ́nɛ́. Akʋ bʋdɛblɩ́ bɛɛ, “Asú Ɔbɔpʋ́ Yohane lákʋ́sʋ́ tsú afúlitɔ. Mʋ́ sʋ́, ɔdɛ ofúla anfɩ odu bwɛ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Támɛ akʋ ɛ́ bɛɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ dada Elia nɩ́.” Akʋ ɛ́ bɛɛ, “Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ dada amʋtɔ ɔkʋ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Brɛ́á Herode lónu asʋ́n ámʋ a, ɔlɛblɩ́ ɔbɛ́ɛ, “Yohane amʋ́ʋ́ nɛha bɛtɩn amʋ látsínkí tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herode lɛ́ha bɛkɩtá Yohane, wá mʋ ɩkan, pʋ́ mʋ wá obu. Tsúfɛ́ oletsiá bláa Herode ɔbɛ́ɛ, mbla mɛha ɔkpa ánɩ́ obétsiá mʋ pio Filipo mʋ ka Herodia amʋ́ʋ́ otsia amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mʋ́ sʋ Herodia lɔ́hɔ Yohane asʋ́n wá ɩwɩtɔ. Ɔlɔbwɛ agywɩɩn ánɩ́ ɔbɔ́mɔ mʋ, támɛ ɔmɛtálɩ́, tsúfɛ́ Herode mɛ́há mʋ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode yin ánɩ́ Yohane asʋ́n da ɔkpa, ogyi ɔha wankɩ́hɛ́. Mʋ́ sʋ olenya mʋ ifú, ɔlɛkɩ mʋsʋ wankláán ánɩ́ tɔtɔ mɔ́ɔbwɛ mʋ. Ɩbʋ mʋ́tɔ́á Yohane asʋn blɩ́hɛ́ tɛhan Herode, támɛ otekle mʋ́ nu. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tɔ́á Herodia dédunká lɛ́ba ha mʋ. Ɛkɛ ɔkʋá Herode dɛ́ mʋ ɔkwɩɩ́kɛ́ gyí a, ɔlɔtswɩ ɔpʋ́nʋ́, tɩ́ ahandɛ pʋ́ ɩsá akɔpʋ́ dɛhɛn pʋ́ Galileafɔ ahandɛ ba atɔ́ ámʋ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Brɛ́á Herodia mʋ bi tsɩ́hɛ́ lóbowie ɔbʋntɔ tsa a, ɩlɔwa Herode mʋa ahandɛ amʋ fɛ́ɛ́ ansigyí. Herode lɛ́bláa mʋ ɔbɛ́ɛ, “Fɩtɛ mɩ́ tógyítɔ́á fʋdeklé, nɛ́ha fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɩnʋ ɔlɛka ntam há mʋ ɔbɛ́ɛ, “Nɛ́ha fʋ́ tótógyítɔ́á fɛ́fɩtɛ́ mɩ́. Nɩ́ igyi mɩ́ iwíe ogyíkpá ɩfʋn kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Otsibi amʋ lɛ́dalɩ yɛ́fɩtɛ́ mʋ yin ɔbɛ́ɛ, “Ntɔ nfɩ́tɛ?” Mʋ yin lɛ́bláa mʋ ɔbɛ́ɛ, “Fɩtɛ Asú Ɔbɔpʋ́ Yohane nwun.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɔsasʋ otsibi amʋ lɛ́ba bɛbláa Herode ɔbɛ́ɛ, “Ndekléá fʋpʋ́ Asú Ɔbɔpʋ́ Yohane nwun dɩnka ɩlɩ́nsʋ́ ha mɩ sésééséi.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Asʋ́n ámʋ lɛ́hɩɛ han owíe amʋ, támɛ mʋ ntam amʋ́ʋ́ ɔlɛka, pʋ́ ahá ámʋ́ʋ́ bʋbʋ ɩnʋ ámʋ sʋ á, omekleá ɔbɔ́tʋn ntam amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɩnʋnʋ ɔlɔwa mʋ ahá ɔtɩ́npʋ ɔbɛ́ɛ, ɔyɛ́tɩn Yohane nwun ba mʋ. Ɔlɔyɔ yɛ́tɩn Yohane nwun obu ɔdɩkpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mʋ́ʋ́ ɔlɔpʋ nwun ámʋ dɩ́nká ɩlɩ́nsʋ́ ba otsibi amʋ, mʋ ɛ́ ɔlɔpʋyáa mʋ yin Herodia. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Brɛ́á Yohane akasɩ́pʋ́ bonu asʋ́n ánfɩ á, bɛba botsu mʋ satin yópulá. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu sumbí ayɔpʋ́ ámʋ beyinkí bá bɛbláa mʋ atɔ́á bayɔ́bwɛ pʋ́ mʋ́á bayósuná fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mʋ́ ɔma a, ahá bʋna amʋ́ wá alɩɩ, bʋmenyá ɔkpa gyi atɔ́ kʋ́ráá. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩha ayɔ ɩtsɛ́tɔ́ flɛ́ɛ́n, ayɛda ɔkpʋ́nʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɩnʋ bowie ɔklʋntɔ, pʋ́ ɔkpa bɔyɔ́ ɩtsɛ́tɔ́ ɔtɩnɛkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Támɛ ahá tsɔtsɔɔtsɔ bowun amʋ́, bɩ́ ɔtɩ́nɛ́á bɔyɔ́. Mʋ́ sʋ botsu awúlu ámʋ fɛ́ɛ́sʋ́, tsíí ɔsrɩ́ɩ gyankpá yówie ɔtɩ́nɛ́ ámʋ́ʋ́ Yesu aná bɔyɔ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Brɛ́á Yesu lɛ́kplɩ́ dálɩ ɔklʋn amʋtɔ, wun ɔdɔm kpɔnkpɔɔnkpɔntɩ ámʋ a, amʋ́ asʋ́n lɔwa mʋ nwɛ, tsúfɛ́ bʋgyi fɛ́ akúfa ánɩ́ bʋma ɔkpapʋ́. Mʋ́ sʋ olosuná amʋ́ atɔ́ tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Owí lɔpɔn a, akasɩ́pʋ́ amʋ bɛba mʋ wá bɛbláa mʋ bɛɛ, “Ɩtsɛ́tɔ́ nfɩ gyí, owí ɛ́ latá. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ha amʋ́ abʋyɔ nkuda mʋ́a awúlu ánɩ́ ɩbʋ bomlí nfɩ asɩ yodunká tɔkʋ gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Támɛ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩdunka atɔ́ ha amʋ́ abʋgyi.” Mʋ́ʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Abɛ́talɩ́ nyá sika hɔ atɔ́ há ahá ánfɩ fɛ́ɛ́ bégyi?” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bodobodo apin afɩnɩ mlɩbʋ? Mlɩyɔ amlɩyɛkɩ!” Beyinkí bɛbláa mʋ bɛɛ, “Bodobodo apin anu pʋ́ ntsutso iye bwáhɛ́ anyɔ bʋ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩha amʋ́ abʋtsiatsia ɩfá bɔbwɛ amʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Betsiá asɩ akúsʋ́-akúsʋ́, akʋ lafa (100), akʋ ɛ́ aduenu (50). ");
INSERT INTO nkoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ɩnʋ olotsu bodobodo anu pʋ́ ntsutso iye bwáhɛ́ anyɔ ámʋ. Mʋ́ʋ́ olotsu ansɩ́ fʋ́á kɩ ɔsʋ́sʋ́, ɔlɛda Bulu ɩpán. Ɩnʋ olebiabía bodobodo amʋ há mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, bʋyée ha amʋ́. Oleye iye bwáhɛ́ anyɔ ámʋ ɛ́ há amʋ́, bɔpʋhá ahá ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amʋ́ fɛ́ɛ́ begyi mwɛ sian. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Akasɩ́pʋ́ amʋ bɔtɔsɩ́ bodobodo mʋ́a iye sianhɛ amʋ a, ɩlɔbʋlá alakpá dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ayin ánɩ́ begyi atɔ́ ámʋ nkʋlɛ bʋgyi mpɩ́m-nu (5,000). ");
INSERT INTO nkoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Benya gyi atɔ́ ámʋ tá alɩ, Yesu lɛ́bláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, bʋwíe ɔklʋntɔ abʋgyankpa fa ɔpʋ amʋ yɔ Betsaida wúlutɔ. Mʋ mʋ́ olesin ɔma sí ɔdɔm amʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Brɛ́á olesi amʋ́ ɔkpa tá á, ɔlɔdʋ yɔ́ bʋsʋ yɔ́bɔ mpáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Brɛ́á owí lɛta, ɔklʋn amʋ lawíé ntsu nsɩnɛ́ á, ilesi Yesu nkʋlɛ ɩbʋ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɩnʋ olowun ánɩ́ ɔklʋn amʋ plá dɛ ɔnlɩn wa wá akasɩ́pʋ́ amʋ, tsúfɛ́ afú kpɔnkpɔntɩ dɛtsʋ́ʋn fia amʋ́. Bakɛ-bakɛ a, Yesu lɛ́natɩ́ ntsu ámʋsʋ ayabitɔ buo amʋ́, odeklé ɔtsʋn amʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Támɛ brɛ́á bowun mʋ a, bʋkɩ bɛɛ, fúli ogyi. Mʋ́ sʋ bɔsʋrá okitikíti. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Opúni letsií amʋ́ fɛ́ɛ́. Támɛ ɔlɔwa ɔsa bláa amʋ́ ɔbɛ́ɛ, “Mlɩwa klʋn. Mɩ́ nɩ́. Mlɩmánya ifú.” ");
INSERT INTO nkoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mʋ́ʋ́ ɔlɔdʋ wíé ɔklʋn amʋtɔ, afú ámʋ lɛka itin á. Asʋ́n ánfɩ lɔ́wa amʋ́ wánwan. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amʋ́ klʋntɔ-odwin sʋ bʋmɔkʋ́nyá nú bodobodo ɩwɩ asʋ́n ámʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu mʋa amʋ́nyɔ bɛfa ɔpʋ amʋ yési Genesaret otsubúnɔ, bɔwa ɔfɛ́ kɩ́tá ɔklʋn amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Benya kplɩ́ dálɩ ɔklʋn amʋtɔ alɩ́ ahá bowun Yesu, bɩ́ mʋ ɔtsáwʋlɛ pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mʋ́ sʋ bɛsrɩ́ yótsu amʋ́ alɔpʋ sʋ́rá akpasʋ, tsú ntɩ́nɛ́-ntɩ́nɛ́ bɔtʋ mʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ɔtɩ́nɛgyíɔtɩ́nɛ́á Yesu lɔ́yɔ, igyi wúlutɔ ntɛ́ɛ akuda ó á, bɔpʋ amʋ́ alɔpʋ bɔtswɩ brɔnʋsʋ, kókóli mʋ bɛɛ, ɔhá alɔpʋ amʋ abʋpʋ ɩbɩ da mʋ atadɩɛ ɔdanʋ́ kpán. Amʋ́á bɔpʋ ɩbɩ da mʋ́ fɛ́ɛ́ benya ɩlɔtsá. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisifɔ pʋ́ Mose mbla asunápʋ́ akʋ botsu Yerusalem ba befia Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mʋ́ʋ́ bowun ánɩ́ mʋ akasɩ́pʋ́ amʋ akʋ bʋmɔfwɩ ɩbɩ amándɩ́ɛ́ ɔkpasʋ asa bʋdɛ atɔ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tsúfɛ́ Yudafɔ, títriu Farisifɔ bʋmɔkʋ́sí amʋ́ anáin amándɩ́ɛ́tɔ́. Mʋ́ sʋ nɩ́ bʋmɔkʋ́fwɩ́ ɩbɩ amándɩ́ɛ́ ɔkpasʋ á, bʋtamagyi atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Alɩ kɛ́n nɩ́ bʋmɔkʋ́gyʋ́ra ɩwɩ á, bʋtamagyi tɔ́á bɔpʋtsúa bíásʋ́ ba nɩ. Amándɩ́ɛ́ bámbá kʋ aná ɛ́ bʋ ɩnʋ, bʋtráa bʋdɛ mʋ́tɔ́ tsú nwɛ núu ntsu, nlɔ́ pʋ́ nlanka ɩwɩ.) ");
INSERT INTO nkoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mʋ́ sʋ amʋ́a Mose mbla asunápʋ́ bɛfɩtɛ́ Yesu bɛɛ, “Ntogyi sʋ́ fʋ́ akasɩ́pʋ́ amʋ bʋtamagyi anɩ anáin amándɩ́ɛ́sʋ́, bʋmɔfwɩ ɩbɩ amándɩ́ɛ́ ɔkpasʋ asa abʋgyi atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɛ́blɩ́ tswɩ tsú mlɩ apinabwɛbí abwɛpʋ́ ánfɩ ɩwɩ ɔbɛ́ɛ, ‘Ahá ánfɩ bʋdɛpʋ amʋ́ ɔnɔ́ bú mɩ́, támɛ amʋ́ klʋn bʋ ɩfɔ́ mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kpaalɩ bʋdɛ mɩ́ sum, tsúfɛ́ basí Bulu mbla tswɩ, yɔ́ bʋdɛ anyánkpʋ́sa mbla suná.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mlɩlasí Bulu mbla ámʋ tswɩ, mlɩdɛ́ mlɩ anáin amándɩ́ɛ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩlapina si Bulu mbla ámʋ tswɩ nyánsatɔ, mɛ́nɩ mlégyi mlɩ onutó amándɩ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tsúfɛ́ Mose lɔ́wanlɩ́n wá Bulu mbla ámʋtɔ ɔbɛ́ɛ, ‘Bu fʋ́ sɩ́ mʋa fʋ́ yin.’ Ɔlɛtrá wanlɩ́n ɔbɛ́ɛ, ‘Nɩ́ ɔkʋ lɛ́blɩ́ asʋkpan tsú mʋ sɩ ntɛ́ɛ mʋ yin ɩwɩ á, bʋmɔ́ɔ mʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Támɛ mlɩ mʋ́ mlɩaa, ɔha ɔbɛ́talɩ́ bláa mʋ sɩ ntɛ́ɛ mʋ yin ɔbɛ́ɛ, ‘Tɔ́á tɛkɩ nɔ́pʋhá fʋ́ á, napʋ́bwɛ́ Koban.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mlɩlahá ahá bʋmɛdɛ́ tɔtɔ bwɛ há amʋ́ akwɩɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mlɩ anáin amándɩ́ɛ́ sʋ mlɩtráa mlɩmɛ́dɛ́ Bulu mblasʋ gyí. Ntobí tsɔtsɔɔtsɔ ɛ́ bʋ ɩnʋá mlɩtráa mlɩdɛ́bwɛ tsɩ́a ɩ́nɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu lɛ́trá tɩ ɔdɔm amʋ ba mʋ ɩwɩ wá, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩ fɛ́ɛ́ mlɩyaa asʋ amlɩnu ɩ́nɩ asɩ! ");
INSERT INTO nkoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Megyí tɔ́á ɔha tegyi tɔ́kpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́. Mboún mʋ́á ɩtɛdálɩ tsu mʋ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Brɛ́á ɔlɛnatɩ́ sí ɔdɔm amʋ yɔ́ wóyítɔ́ a, mʋ akasɩ́pʋ́ amʋ bɛfɩ́tɛ́ mʋ yébi anfɩ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩ ɛ́ mlɩtamanú asʋ́n asɩ? Mlɩméyín ánɩ́ tɔ́á itowíé ɔha ɔnɔ́ tamakpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́? ");
INSERT INTO nkoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tsúfɛ́ megyí mʋ klʋntɔ itowíé, mboún mʋ iputɔ itowíé, ɔtɛyɛ́lɛ mʋ́ wá ɔkpʋntɔ.” (Yesu lɛ́lɛ mʋ́tɔ́ pʋ́súná ánɩ́ atogyihɛ kugyíkʋ ɩwɩ lɛtɩn.) ");
INSERT INTO nkoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Tɔ́á ɩtɛdálɩ tsu ɔha klʋntɔ tɔ́kpɔ́ɩ́ mʋ Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsúfɛ́ ɔha klʋntɔ ágywɩɩn laláhɛ kugyíkʋ tɛdálɩ tsu. Mʋ́tɛhá mʋ ɔtɔwá atsɩ mʋ́a ayin asʋ́n, otowí atɔ́, ɔtɔmɔ́ ɔha, ɔtɔtɔ́ mbʋa, ");
INSERT INTO nkoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɔtɔwá ɔnsɩpɛ, ɔtɔbwɛ́ lalahɛ, ɔtɛmlɛ́ ahá, ɔtɔwá hakpan, ɔtɔwá olu, otetsii ɔha, ototsú ɩwɩ, ɔtɔbwɛ́ mimlála. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɔha klʋntɔ, atɔ laláhɛ anfɩ fɛ́ɛ́ ɩtɛdálɩ tsu. Mʋ́tɔ́kpɔ́ɩ́ mʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu lɛ́natɩ́ ɩnʋ yɔ́ Tiro nsáɩntɔ. Ɔlɔyɔ́swɩɩ́ wóyí kʋtɔ. Omedéklé ɔbɛ́ɛ ahá bʋbɩ́ɩ ánɩ́ maba ɩnʋ, támɛ ɔmɛtalɩ́ ŋáín mʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ɔŋɛ laláhɛ bʋ ɔtsɩ ɔkʋ mʋ bi tsɩ́hɛ́tɔ́. Olenya nú Yesu nka alɩ, ɔlɔwa ɔsa bɛda akpawunu mʋ ayabitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Griikiyintse ɔtsɩ ánfɩ gyí. Bɔkwɩɩ́ mʋ Siro Foenike ɔsʋlʋ́sʋ. Olokokóli Yesu ɔbɛ́ɛ, ogyáa ɔŋɛ laláhɛ amʋ lɛ mʋ bi ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Támɛ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ha nyebí ámʋ abʋmwɛ asa, tsúfɛ́ ɩma alɛá fɔ́swɩɩ́ nyebí atogyihɛ pʋ́há akɩ́aɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɔtsɩ ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Owíé, ɩbʋ mʋ́tɔ́ alɩ, támɛ akɩ́aɩ ánɩ́ bʋda ɔpʋ́nʋ́ ámʋ asɩ ɛ́ bʋtegyi nyebí atogyihɛ mpupubiá ɩtɛkpákpa bun amʋ́ ɔpʋ́nʋ́asɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fabɩ́ lɛ́ mʋ́ ɔnɔ́. Mʋ́ sʋ natɩ, ɔŋɛ laláhɛ amʋ ladálɩ fʋ́ bí tsɩ́hɛ́ ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Brɛ́á ɔtsɩ ámʋ lɔ́yɔ wóyítɔ́ a, olowun ánɩ́ ɔŋɛ laláhɛ amʋ ladálɩ mʋ bi ámʋtɔ, alasí ɔda mpásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu lɛ́natɩ́ Tiro ɩnʋ yɔ́ Sidon yóbomlí kplɩ́ ba Dekapoli awúlu amʋ nsáɩntɔ asa ɔlɛladʋ́ yɔ́ Galilea ɔpʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bɔpʋ ɩsʋtín ɔkʋ ba mʋ, ɔtamatálɩ́ tɔ́ɩ́ wankláán. Bokokóli mʋ bɛɛ, ɔpʋ́ʋ ɩbɩ dɩnka mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mʋ́ʋ́ ɔlɛkpa oyin ámʋ ya ɩfʋ́ntɔ́, pʋ́ mʋ asrebi wá oyin ámʋ asʋtɔ, olotu atsʋnɔ́ dɩ́nká mʋ osrebisʋ, pʋ́dá oyin ámʋ ɔdandʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ɩnʋ olotsu ansɩ́ fʋ́á kɩ ɔsʋ́sʋ́, lʋ́n ɔŋɛ́ fʋ́. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Hefata.” Hebri ɔblɩ́tɔ. Mʋ́ asɩ gyí, “Finki.” ");
INSERT INTO nkoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɩnʋnʋ mʋ asʋ lefinkí, mʋ ɔdandʋ ɛ́ lɛsankɩ́, ɔlɔtɔɩ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mʋ́ʋ́ Yesu lɛ́da ahá ámʋ ɔlá kpákpáákpá ɔbɛ́ɛ, bʋmábláa ɔhaa. Támɛ tsé dʋ́dʋ́ʋ́dʋ́á ɔlɛda amʋ́ ɔlá á, alɩ kɛ́n bɛda asʋ́n ámʋ ɔkan nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɔnɔ́ lɛhɩɛ bwíé amʋ́, bɛblɩ́ bɛɛ, “Alabwɛ́ tógyítɔ́ wankláán. Alahá asʋtín bʋdɛ asʋ́n nu, amúmu ɛ́ bʋdɛtɔɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nkɛ ámʋtɔ á, ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛtrá befia Yesu wá. Amʋ́ atogyihɛ lɛta. Mʋ́ sʋ Yesu lɛ́tɩ mʋ akasɩ́pʋ́, bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ahá ánfɩ asʋ́n dɛ mɩ́ nwɛ wa. Ndɛ ɛkɛ sáásɩ́ ɔpá bʋbuo mɩ. Bʋtráa bʋma tɔtɔá bégyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɩ́ nɛhá amʋ́ bɔpʋ́ akʋ́n nátɩ́ bɔyɔ́ wóyí á, ansɩ́tɔ́ béyébi amʋ́ ɔkpatɔ, tsúfɛ́ amʋ́tɔ́ akʋ ɔkpa bʋ ɩfɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mʋ́ʋ́ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Nkʋ́nʋ́ abénya atogyihɛ há ahá ánfɩ fɛ́ɛ́ bégyi mwɛ dimbí ánfɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bodobodo afɩnɩ mlɩbʋ?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Asienɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu lɛ́ha ɔdɔm amʋ betsiá ɔsʋlʋ́tɔ. Mʋ́ʋ́ olotsu bodobodo asienɔ́ ámʋ, dá Bulu ɩpán, olebiabía mʋ́tɔ́ há akasɩ́pʋ́ amʋ beye mʋ́ há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bʋbʋ ntsutso iye bwáhɛ́ kpalobí kʋ ɛ́. Yesu lóyulá mʋ́sʋ́, ɔlɔpʋ mʋ́ ɛ́ há akasɩ́pʋ́ amʋ, beye ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Amʋ́ fɛ́ɛ́ begyi mwɛ. Akasɩ́pʋ́ amʋ bɔtɔsɩ́ isíanhɛ bʋ́lá alakpá yilé asienɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ahá ámʋ bɔ́bwɛ fɛ́ mpɩ́m-na (4,000), Yesu lési amʋ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɩnʋnʋ mʋa mʋ akasɩ́pʋ́ bɔdʋ wíé ɔklʋntɔ ba Dalmanutafɔ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisifɔ bonu ánɩ́ Yesu laba ɩnʋ, bɛba bʋdɛ mʋ asʋ́n fɩtɛ́. Bɛbláa mʋ bɛɛ, ɔbwɛ́ɛ osúna pʋsuna amʋ́ ánɩ́ lɛ́lɛ́ otsú Bulu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu lɔ́lʋn ɔŋɛ́ fʋ́. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩ ndɛmba-abí mlɩdɛ́ osúna dunká amlɩwun? Mbláa mlɩ ɔnɔkwalɩ. Mmɔ́ɔbwɛ osúna kʋkʋ súná mlɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɩnʋ ɔlɛnatɩ sí amʋ́, yɔ́ dʋ wíé ɔklʋntɔ, fá ɔpʋ ámʋ yɔ́ mʋ́ ɔbɩn. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu akasɩ́pʋ́ amʋ bʋmɛkaɩ́n tsú bodobodo kɩ́tá. Ipin kʋlɛ pɛ́ bʋ ɔklʋn amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Brɛ́á bʋdɩn ntsu ámʋsʋ bɔyɔ́ á, Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩkɩ wankláán Farisifɔ pʋ́ ɔmásʋ́ ogyípʋ́ Herode bodobodotu-afásʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Akasɩ́pʋ́ amʋ bɛfɩtɛ́ aba bɛɛ, “Bodobodo amʋ́ʋ́ anɩmɛ́dɛ́ ámʋ sʋ́ ɔdɛ asʋ́n ánfɩ blɩ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu lónu asʋ́n ánɩ́ bʋdɛblɩ́. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́blɩ́ mlɩaa, mlɩmɛ́dɛ́ bodobodo? Mʋ́ sʋ ɩklʋntɔ bʋ mlɩ odwin mlɩ ɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mlɩ ansíbi tamawun atɔ́, mlɩ asʋ ɛ́ tamanú asʋ́n? Mlɩtamakáɩ́n asʋ́nsʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Brɛ́á neye bodobodo apin anu ámʋ há ahá mpɩ́m-nu (5,000) á, isíanhɛ alakpá afɩnɩ mlɩlɔ́tɔsɩ́?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Dúanyɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bodobodo apin asienɔ́ ámʋ́ʋ́ neye ha ahá mpɩ́m-na ámʋ ɛ́ mɛ́, isíanhɛ alakpá yílé afɩnɩ mlɩlɔ́tɔsɩ́?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Asienɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɩnʋ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ɩmɔkʋ́wánkɩ́ mlɩ kɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu mʋa mʋ akasɩ́pʋ́ bɛba Betsaida wúlutɔ. Aha akʋ bɛkpa ansibi obwiepʋ́ ɔkʋ ba. Bobwií ɩpa há mʋ bɛɛ, ɔpʋ́ʋ ɩbɩ da mʋ, ɔtsa mʋ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu lɛ́kɩtá ansibi obwiepʋ́ ámʋ ɩbɩ, kpá mʋ dálɩ wúlu amʋtɔ. Ɩnʋ olotu atsʋnɔ́ dɩ́nká oyin ámʋ ansíbisʋ, pʋ́ ɩbɩ dɩ́nká mʋsʋ. Mʋ́ʋ́ ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋdɛ atɔ́ wúun?” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ansibi obwiepʋ́ ámʋ lótsu nwun fʋ́á kɩ, ɔlɛblɩ́ ɔbɛ́ɛ, “Ndɛ anyánkpʋ́sa wúun, támɛ bʋgyi fɛ́ nyí bʋna.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɩnʋ Yesu lɛ́trá pʋ mʋ ɩbɩ dɩ́nká mʋ ansíbisʋ. Oyin ámʋ lóbwií ansíbi kɩ a, mʋ ansíbi lawá alɛ́, ɔdɛ tógyítɔ́ wúun wankláán ngya. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu léyinkía mʋ sɩ́sɩ́ wóyítɔ́ ɔbɛ́ɛ, “Natɩ laa yɔ wóyí. Mátepí wíé wúlu amʋtɔ kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu mʋa mʋ akasɩ́pʋ́ amʋ bɛnatɩ́ ɩnʋ bɔyɔ́ Kaesarea Filipi awúlusʋ. Brɛ́á bʋna ɔkpatɔ á, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma ahá bɛɛ ngyi?” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Akʋ bɛɛ, fʋ́gyí Asú Ɔbɔpʋ́ Yohane. Akʋ bɛɛ, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Elia. Akʋ ɛ́ bɛɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋtɔ ɔkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩ ɛ́ mɛ́? Mlɩa mɩ́gyí ma?” Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɩnʋ ɔlɛda amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩmábláa ɔhaa mɩ́ ɩwɩ asʋ́n ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɩnʋ Yesu léfi asɩ ɔdɛ asʋ́ntɔ́ lɛ súná amʋ́ ɔbɛ́ɛ, “Ilehián ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́hɩɛ wun ɩwɩɔsɩn tsɔtsɔɔtsɔ. Yudafɔ ahandɛ, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ fɛ́ɛ́ bekiná mɩ́ bɛɛ, megyí mɩ́gyí Kristo amʋ. Bɔ́mɔ mɩ́, támɛ Bulu ɔbɛ́lakʋ́sʋ́a mɩ tsú afúlitɔ nkɛnsá ɔma.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɔmɔpʋ asʋ́n ánfɩ ŋáín amʋ́. Mʋ́ sʋ Petro lɛ́tɩ mʋ ya ɩtsɛ́tɔ́ yɛ́ka mʋ itin ɔbɛ́ɛ, ɔmátrá blɩ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ɩnʋ ɔlɛdamlí kɩ akasɩ́pʋ́ amʋ, ɔlɔkplʋ́n wa Petro ɔbɛ́ɛ, “Satan, natɩ tɛɩ mɩ́sʋ́! Megyí tɔ́á Bulu dɛ́gywɩɩ́n fʋdɛgywɩɩ́n, anyánkpʋ́sa klɛ́ fʋdɛgywɩɩ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ɩnʋ ɔlɛtɩ ɔdɔm amʋ pʋ́ mʋ akasɩ́pʋ́ ba mʋ ɩwɩ wá. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ ɔkʋ dékléá obóbuo mɩ á, osíi tɔ́á otekle bwɛ, otsu mʋ oyikpalíhɛ bobuo mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tsúfɛ́ nɩ́ ɔkʋ lɛ́prɩ mʋ nkpa á, ɔbɔ́hʋlɩ́ɩ mʋ́. Nɩ́ ɔkʋ ɛ́ lɔ́hʋlɩ́ɩ mʋ nkpa mɩ́a Bulu asʋn wankláán ámʋsʋ á, Bulu ɔbɔ́hɔ mʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nɩ́ ɔkʋ onyá ɔyɩ́tɔ́ atɔ́ fɛ́ɛ́, támɛ ɔhʋ́lɩ mʋ ɔkláa a, labi mɔmʋ ɩlɔwa há mʋ? ");
INSERT INTO nkoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ntɛ́ɛ ntɔ ɔha ɔbɛ́talɩ́ pʋ́tsɛ mʋ nkpa? ");
INSERT INTO nkoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tsúfɛ́ nɩ́ ɔkʋ onyá mɩ́a mɩ́ atosunáhɛ́ pɛ́lɩ ndɛmba-abí laláhɛá badámlí ɔma há Bulu ansɩ́tɔ́ á, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ nénya mʋ pɛ́lɩ brɛ́á mɩ́a Bulu-abɔpʋ wánkɩ́hɛ́ amʋ anɩná mɩ́ Sɩ́ numnyamtɔ abá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu lɔ́yɔ mʋ tɔ́ɩsʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Akʋ bʋbʋ mlɩtɔ nfɩ bʋmóowu, yɔ́fʋn brɛ́á bawun ánɩ́ Bulu iwíegyí amʋ ɩna túmisʋ ɩbá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nkensíé ɔma a, Yesu lɛ́kpa Petro, Yakobo mʋa Yohane, mʋa amʋ́nyɔ bɔdʋ yɔ́ ɩbʋ kʋsʋ amʋ́ nkʋlɛ. Ɩnʋ Yesu lɛ́tsɛ amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mʋ atadɩɛ lɛdamlí futútúútú, ɩdɛ ogyá kpa. Tɔtɔ ma ɔsʋlʋ́ʋ anfɩsʋá ɩbɛ́talɩ́ bwɛ́ mʋ́ ibófulí alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɩnʋ Elia mʋa Mose bɛlɛ ɩwɩ ɔwan, amʋ́a Yesu bʋdɛtɔɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mʋ́ʋ́ Petro lɛ́bláa Yesu ɔbɛ́ɛ, “Osunápʋ́, ɩbʋ alɛ́á abétsiá nfɩ. Ha ada abú asa. Fʋ́ klɛ́ kʋlɛ, Mose klɛ́ kʋlɛ, Elia ɛ́ klɛ́ kʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ifú lɛhɩɛ kɩ́tá Petro mʋa mʋ aba ámʋ dʋbɩ. Mʋ́ sʋ omowun asʋ́n ánɩ́ ɔblɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɩnʋ agyinde kʋ lobobun amʋ́sʋ́, ɔmɛ kʋ lɛdalɩ tsu mʋ́tɔ́ ɔbɛ́ɛ, “Ɔ́nɩ gyí mɩ́ Bí ɔdwɛpʋ́ nɩ́! Mlɩyaa asʋ amlɩnu mʋ asʋ́n!” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ɩnʋ bɛlakɩ, támɛ bʋmɛtrá wun ɔhaa dʋn Yesu nkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Brɛ́á bʋdɛ ɩbʋ ámʋ kplɩ́ á, Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, “Mábláa ɔhaa tɔ́á bayówun, yɔ́fʋn ɛkɛá Bulu ɔbɔ́kʋsʋ́a mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Asʋ́n ánfɩ lesin amʋ́ nwuntɔ, betsiá fɩ́tɛ́ aba bɛɛ, “Kʋsʋ́ tsú afúlitɔ ánfɩ asɩ mɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɩnʋ bɛfɩtɛ́ Yesu bɛɛ, “Ntogyi sʋ́ Mose mbla asunápʋ́ amʋ bɛɛ, ilehián ánɩ́ Elia obéyinkí bá asa Kristo amʋ ɔbɛ́ba?” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ igyi, ánɩ́ Elia obégyankpá bá bɛla tógyítɔ́ yáɩ́ wankláán. Mʋ́ ntogyi sʋ́ Bulu asʋn wanlɩ́nhɛ́ amʋ kɛ́n lɛ́blɩ́ tsú mɩ́ ɩwɩ ɔbɛ́ɛ, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́hɩɛ wun ipian, ahá bɔ́sʋpáa mɩ? ");
INSERT INTO nkoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ndɛ mlɩ bláa mbɛ́ɛ, Elia layínkí bá dodo. Ahá bɔbwɛ mʋ alɩá bʋdeklé, fɛ́ alɩá bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Brɛ́á beyinkí bowie akasɩ́pʋ́ atráhɛ amʋ wá á, bowun ánɩ́ ɔdɔm kpɔnkpɔɔnkpɔntɩ bafia bomlí amʋ́, Mose mbla asunápʋ́ akʋ bʋdɛ akasɩ́pʋ́ amʋ nwɛ́ɛn gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Brɛ́á ɔdɔm amʋ bowun Yesu a, ɩlɔwa amʋ́ wánwan, bɛsrɩ́ yéfia mʋ, há mʋ ayɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu lɛ́fɩtɛ́ mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Amansʋ mlɩa amʋ́nyɔ mlɩdɛ́bɩtɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɔdɔm amʋtɔ ɔkʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Osunápʋ́, nɛkpa mɩ́ bí yínhɛ́ ba fʋ mbɛ́ɛ afʋtsa mʋ ɩlɔ. Ɔŋɛ laláhɛ lahá ɔtamatɔ́ɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Brégyíbrɛ́á ɔŋɛ laláhɛ amʋ ɩba mʋsʋ á, ɩtɔwʋ́sʋ mʋ, fɩn mʋ dá ɔsʋlʋ́tɔ. Mʋ ɔnɔ́ tɔbwɛ́ afu, ɔtɔwɩ́ ayín, ɔtɛsɩ́nsɩn. Nɛbláa fʋ́ akasɩ́pʋ́ mbɛ́ɛ, bʋgyáa ɔŋɛ́ ámʋ lɛ mʋtɔ ha mɩ, támɛ bʋmɛtalɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ndɛmba-abíá mlɩmá hógyi, alɩ́ nétsiá mlɩ wá yɔ́ nɩ́? Yɔ́fʋn ɔmɛnkɛ nnyá klʋn ha mlɩ? Mlɩkpa kebi ámʋ ba mɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bɛkpa kebi ámʋ ba Yesu. Ɔŋɛ laláhɛ amʋ lénya wun Yesu alɩ, ɩlɔwʋsʋ́ʋ kebi ámʋ fɩn mʋ dá. Odemináa, mʋ ɔnɔ́ ɛ́ ɩdɛ afu. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu lɛ́fɩtɛ́ obí mʋ sɩ ámʋ ɔbɛ́ɛ, “Tsú brɛ́ mɔmʋtɔ ɩlɔ ánfɩ lefi asɩ?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Tsú mʋ nyebitɔ ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɩtɔtswɩ mʋ wá ogyá mʋ́a ntsu aná fɛ́ɛ́tɔ́, itekleá ɩbɔ́mɔ mʋ, támɛ nɩ́ fɛ́talɩ́ bwɛ́ tɔkʋ tsú mʋ́ ɩwɩ á, wun anɩ nwɛ afʋgyi anɩ bʋalɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Blɩ́ fʋdɛ fɛɛ, nɩ́ nɛ́talɩ́? Tógyítɔ́ lɔpɔn ha ohógyipʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ɩnʋ obí mʋ sɩ ámʋ lɔ́kplʋn blɩ́ ɔbɛ́ɛ, “Nohogyi, támɛ mɩ́ hógyi mɔtsɔ́. Gyi mɩ bʋalɛ, mɩ́ hógyi imoní!” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Brɛ́á Yesu lówun ánɩ́ ɔdɔm amʋ bʋtráa bʋsrɩ́ bɛbá á, ɔlɔkplʋ́n wa ɔŋɛ laláhɛ amʋ ɔbɛ́ɛ, “Fʋ́ ɔdandʋbiabía mʋ́a ɩsʋtín ɔŋɛ́, dalɩ kebi ámʋtɔ. Mátrá wie mʋtɔ ɛkɛkɛɛkɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɔŋɛ laláhɛ amʋ lɔ́sʋrá okitikíti kʋ́klʋ́kʋ́ʋ́, ɩlɛtrá wʋsʋ́ʋ mʋ nyányányányáa, ɩlɛdalɩ mʋtɔ. Ɔŋɛ́ lɛta mʋ. Mʋ́ sʋ ahá ámʋtɔ akʋ bɛblɩ́ bɛɛ, “Alawú.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Támɛ Yesu lɛ́kɩtá mʋ ɩbɩ tsú mʋ fʋ́á, ɔlɔkʋsʋ́ lɩ́ɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mʋ́ ɔma, brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ amʋ nkʋlɛ bʋbʋ wóyítɔ́ a, bɛfɩtɛ́ mʋ bɛɛ, “Ntogyi sʋ́ anɩ mʋ́ anɩmɛ́talɩ́ gya ɔŋɛ laláhɛ amʋ dálɩ kebi ámʋtɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɩ́nɩ odu mʋ́ á, nkɛ́tɩ mpáɩ pɛ́ mlɛ́talɩ́ pʋ́gya mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ amʋ bɛnatɩ́ ɩnʋ á, bɔtsʋn Galilea ɔsʋlʋ́sʋ, támɛ Yesu mékléá ɔhaa ɔbɩ́ɩ ɔtɩ́nɛ́á mʋbʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tsúfɛ́ ɔdɛ akasɩ́pʋ́ amʋ atɔ́ suná ɔbɛ́ɛ, “Bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há adʋ́n bɔ́mɔ mɩ́, támɛ Bulu ɔbɛ́lakʋ́sʋ́a mɩ ɛkɛ sáásɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Akasɩ́pʋ́ amʋ bʋmonu mʋ́ asɩ, ifú ɛ́ dɛ amʋ́ ánɩ́ bɛfɩtɛ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɛba Kapernaum wúlutɔ. Brɛ́á bowie wóyítɔ́ á, Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ nwɛ́ɛn mlɩdégyí ɔkpatɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bɛkpa ɔnɔ́ bun mʋ́sʋ́, tsúfɛ́ ɩhandɛ bʋdɛprɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu létsiá asɩ, ɔlɛtɩ akasɩ́pʋ́ dúanyɔ ámʋ, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɩtɔ ɔkʋ dékléá ɔbɔ́bwɛ mlɩ nkpá ogyápʋ a, ɔbwɛ́ɛ mʋ ɩwɩ ɔma ogyápʋ pʋ́ mlɩ fɛ́ɛ́ osúmpʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɩnʋ ɔlɛkpa kebi ɔkʋ bɛlɩɩ́ amʋ́ ansɩ́tɔ́, látá mʋ pútá, ɔlɛbláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɔhagyíɔha ánɩ́ ɔlɔhɔ kebiá ogyi alɩ mɩ́ dátɔ́ lahɔ mɩ. Ɔhagyíɔha ánɩ́ ɔhɔ mɩ á, megyí mɩ́ ɔlɔhɔ, mboún ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane lɛ́bláa Yesu ɔbɛ́ɛ, “Osunápʋ́, anɩlówun oyin ɔkʋ dɛ́pʋ fʋ́ dá gya ɔŋɛ laláhɛ, anɩlɛ́ka mʋ tin, tsúfɛ́ ɔma anɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmáka mʋ itin! Tsúfɛ́ ɔhaa má ɩnʋá ɔbɔ́bwɛ ofúla mɩ́ dátɔ́, láblɩ́ mɩ́ ɩwɩ asʋn laláhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsúfɛ́ ɔhá ánɩ́ ɔmɔkʋsʋ́ lɩ́ɩ́ anɩsʋ buo anɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ ɔkʋ ɔhá mlɩ ntsu-owebi mlonu, mɩ́ dá ánɩ́ ɩdɩn mlɩsʋ sʋ á, ɔmɔ́ɔhʋlɩ́ɩ mʋ ɩpán. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nɩ́ ɔkʋ lɛ́ha ahá ánfɩ bʋmɔkʋ́dan mɩ́sʋ́ hógyitɔ ánfɩtɔ ɔkʋ lɔ́bwɛ lakpan á, nɩ́ bɛda nfúókwɛbʋ síán mʋ ɔmɛtɔ, tswɩ mʋ wá ɔpʋtɔ pó á, ɩbʋ alɛ́ dʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nɩ́ fʋ́ ɩbɩ kʋlɛ tɛ́há fʋ́tɔbwɛ́ lakpan á, ka mʋ́ lɛ! Ɩbʋ alɛ́á fɔ́pʋ ɩbɩ kʋlɛ nyá nkpa ánɩ́ ɩtamatá, dʋn ánɩ́ fɔ́pʋ ɩbɩ anyɔ wíé ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nɩ́ fʋ́ yabi kʋlɛ tɛ́há fʋ́tɔbwɛ́ lakpan á, ka mʋ́ tswɩ tsalɩfwɩ! Ɩbʋ alɛ́á fɔ́pʋ yabi kʋlɛ nyá nkpa ánɩ́ ɩtamatá, dʋn ánɩ́ fɔ́pʋ ayabi anyɔ wíé ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɩ́ fʋ́ nsíbi tɛ́há fʋ́tɔbwɛ́ lakpan á, loti mʋ́ lɛ. Ɩbʋ alɛ́á fɔ́pʋ nsibi kʋlɛ wíé Bulu iwíegyí ámʋtɔ, dʋn ánɩ́ fɔ́pʋ ansibi anyɔ wíé ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɔtɩ́nɛ́á ɩnʋ anyambi bʋtamawú, ɩnʋ ogyá ɛ́ ɩtamadun. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tsúfɛ́ bɔ́pʋ ogyá tɩn ɔhagyíɔha ɩwɩ, fɛ́ alɩá bʋtɔpʋ́ nfɔ́lɩ tɩn afɔdɩɛ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nfɔ́lɩ bʋ ɔdwɛ, támɛ nɩ́ ɩtá ɔdwɛ á, ntɔ bɛ́lapʋ́wá mʋ́ ɔdwɛ? “Mlɩha ɔdwɛ itsia mlɩtɔ fɛ́ nfɔ́lɩ, iwilwii itsia mlɩa mlɩ aba nsɩnɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu lɔ́kʋsʋ́ tsú ɩnʋ yɔ́ Yudea ɔmátɔ́, Yordan ntsu ɔbɩn. Ɔdɔm bɛtrá befia bomlí mʋ, ɔlɛtrá suná amʋ́ atɔ́ fɛ́ alɩá ɔtɔbwɛ́ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisifɔ akʋ bɛba mʋ wá, bʋdekléá bɔ́sɔ mʋ kɩ. Mʋ́ sʋ bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Mbla lɛha ɔkpa ánɩ́ oyin ɔbɛ́talɩ́ kíná mʋ ka?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nkálɩ anɩ náin Mose lɔ́wa mbla há mlɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɛlɛ mʋ ɔnɔ́ bɛɛ, “Mose lɛ́ha ɔkpa ánɩ́ oyin ɔwánlɩn ɔkákiná ɔwʋlʋ́ pʋkina mʋ ka.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ klʋntɔ-odwin sʋ́ Mose lɔ́wanlɩ́n mbla ánfɩ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tsú brɛ́á Bulu lɛ́lɛ ɔyɩ́ á, ɔtsɩ mʋ́a oyin ɔ́lɔbwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɩ́nɩ sʋ oyin obótu sí mʋ sɩ mʋa mʋ yin yɛ́mantá mʋ kasʋ, ");
INSERT INTO nkoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","amʋ́ abanyɔ́ bɔ́bwɛ ɔyʋlʋ́ʋ kʋlɛ nɩ. Bʋtráa bʋmegyí abanyɔ́, mboún babwɛ́ ɔbakʋ́lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ɩ́nɩ sʋ ahá ánɩ́ Bulu labwɛ́ amʋ́ ɩkʋlɛ a, ɔhaa mámaɩ́n amʋ́ abasʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Brɛ́á beyinkí ba wóyítɔ́ a, Yesu akasɩ́pʋ́ amʋ bɛtrá fɩtɛ́ mʋ asʋ́n tsú asʋ́n ánfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ oyin okíná mʋ ka láyétsiá ɔtsɩ bámbá á, alatɔ́ mbʋa. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Alɩ kɛ́n nɩ́ ɔtsɩ okíná mʋ kulu láyétsiá oyin bámbá á, alatɔ́ mbʋa nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aha akʋ bɛkpa nyebí ba Yesu bɛɛ, ɔpʋ́ʋ ɩbɩ dɩnka amʋ́sʋ́, támɛ mʋ akasɩ́pʋ́ amʋ bɔwa ɩyɩn wá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Brɛ́á Yesu lówun a, ɔblɔ́ lɛkɩtá mʋ. Mʋ́ʋ́ ɔlɛbláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha nyebí ámʋ ɔkpa abʋba mɩ́ wá. Mlɩmátin amʋ́ ɔkpa, tsúfɛ́ ahá ánfɩ odu bʋ́ Bulu iwíegyí ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhá ánɩ́ ɔmɔhɔ Bulu iwíegyí amʋ fɛ́ kebi á, omóowie mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mʋ́ʋ́ ɔlɛlatá amʋ́ pútá, pʋ́ ɩbɩ dɩ́ndɩ́nka amʋ́sʋ́, oloyulá amʋ́ á. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Brɛ́á Yesu lɔ́pʋ ɔkpa ɔyɔ́ á, oyin ɔkʋ lɛ́srɩ́ ba bɛda akpawunu mʋ ayabitɔ fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Osunápʋ́ yilé, ntɔ nɔ́bwɛ asa nénya nkpa ánɩ́ ɩtamatá?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntogyi sʋ́ fʋdɛ mɩ́ tɩ ɔha yilé? Ɔhaa mégyí ɔha yilé, nkɛ́tɩ Bulu nkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yɛ́ɛ fʋyin Bulu mbla ámʋ dodo? Ɔbɛ́ɛ, mámɔ ɔha, mátɔ mbʋa, máwi atɔ́, máka asʋ́n dɩ́nká fʋ́ básʋ́, másisíi ɔha, bu fʋ́ sɩ́ mʋa fʋ́ yín.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Oyin ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Osunápʋ́, tsú mɩ́ nyebitɔ ɔpá ndɛ ɩ́nɩ fɛ́ɛ́sʋ́ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu lɛ́kɩ mʋ díín, mʋ asʋ́n lɔwa mʋ ɔdwɛ. Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Ɩlasí tokukʋlɛá fɔ́bwɛ. Yɛfɛ fʋ́ ɩwɩsʋ atɔ́ fɛ́ɛ́, afʋye kɔ́ba amʋ ha ahiánfɔ, mɛ́nɩ fénya siadɩɛ ɔsʋ́sʋ́. Fɔbwɛ́ mʋ́ tá á, ba afʋbobuo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Brɛ́á oyin ámʋ lónu asʋ́n ánfɩ á, ɩwɩ lowu mʋ. Mʋ́ sʋ ɔlɛnatɩ́ díín, tsúfɛ́ ɔhɩ́ɛ́ ɔbʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu lɛ́kɩ bomlí, ɔlɛbláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Ɩbɛ́hɩɛ wá ɔnlɩn asa ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Brɛ́á akasɩ́pʋ́ amʋ bonu asʋ́n ánfɩ á, ɔnɔ́ lobwie amʋ́. Támɛ Yesu lɛ́labláa amʋ́ ɔbɛ́ɛ, “Mɩ́ abí, Bulu iwíegyí ámʋtɔ wie ɩbɛ́hɩɛ wá ɔnlɩn! ");
INSERT INTO nkoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɩlɔpɔn ha kpɔ́sɔ́ ánɩ́ ɔbɔ́tsʋn ɔbɩn-atɔ ɔbɔ́tɔ́, dʋ́n ánɩ́ ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Asʋ́n ánfɩ lɛha ɔnɔ́ lɛhɩɛ bwíé amʋ́. Mʋ́ sʋ bɛfɩtɛ́ aba bɛɛ, “Mʋ́mʋ́ ma mɛɛ Bulu ɔbɔ́hɔ nkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu lɛ́kɩ amʋ́ díín, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Tɔ́á ɩdʋn nyankpʋsa bwɛ mɔdʋ́n Bulu, tsúfɛ́ Bulu mʋ́ tɛtálɩ́ bwɛ́ tógyítɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mʋ́ʋ́ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Yɛ́ɛ anɩ mʋ́ anɩlasí tógyítɔ́ tswɩ bobuo fʋ o!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ olesi mʋ wóyí, mʋ apíó, mʋ sɩ mʋa mʋ yin, mʋ abí ntɛ́ɛ mʋ ɔsʋlʋ́ʋ ɔmagyáa, mɩ́a mɩ́ asʋn wankláán ámʋ sʋ á, ");
INSERT INTO nkoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɔbɛ́lanyá mʋ wóyí, mʋ apíó, mʋ ayín, mʋ abí pʋ́ mʋ agyapadɩɛ ámʋ odu tsé lafa séi. Bɛ́dɩnká mʋsʋ ɛ́ séi, támɛ obénya nkpa ánɩ́ ɩtamatá brɛ́ ámʋ́ʋ́ ɩbá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Támɛ agyankpapʋ tsɔtsɔɔtsɔ bɛ́ba bemlí amapʋ, amapʋ ɛ́ bɛ́ba bemlí agyankpapʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu mʋa mʋ akasɩ́pʋ́ amʋ bɔpʋ ɔkpa bɔyɔ́ Yerusalem wúlutɔ, Yesu gyánkpá. Ɩlɔwa amʋ́ wánwan, ifú lɛkɩtá ahá ámʋ́ʋ́ bʋbuo amʋ́ ámʋ. Mʋ́ʋ́ ɔlɛkpa akasɩ́pʋ́ dúanyɔ ámʋ ya ɩtsɛ́tɔ́, ɔlɛtrá bláa amʋ́ tɔ́á ɩbɛ́ba mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔbɛ́ɛ, “Mlɩnu! Nɩ́ awíé Yerusalem a, bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́. Bɛ́ha mɩ́ lowu ɩpɔ́n, pʋ́ mɩ́ wá ahá ánɩ́ bʋmegyí Yudafɔ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bɔ́bwɛ mɩ́ ahinlá, tú atsʋnɔ́ wʋ́lɩ́ mɩ́, nwɛ́n mɩ́ mplɩ, mɔ́ mɩ́, támɛ ɛkɛ sáásɩ́ a, Bulu ɔbɔ́kʋsʋ́a mɩ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedeo abí Yakobo mʋa Yohane bɔkpʋkpɛ́ mantáa Yesu bláa mʋ bɛɛ, “Osunápʋ́, anɩdékléá fʋbwɛ́ɛ tɔkʋ ha anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ mlɩdéklé mlɩaa mbwɛ́ɛ ha mlɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bɛbláa mʋ bɛɛ, “Ha anɩtɔ ɔkʋlɛ otsia fʋ́ gyɔpɩsʋ, ɔkʋlɛ ɛ́ otsia fʋ́ bɩnasʋ brɛ́á Bulu ɔwá fʋ́ numnyam.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩméyín tɔ́á mlɩdɛ́kʋlɩ́! Mlɛ́talɩ́ wun ɩwɩɔsɩn ámʋ́ʋ́ nɛbá bowun amʋ, ntɛ́ɛ mlɛ́talɩ́ wú lowu ámʋ́ʋ́ nówu ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ee abɛ́talɩ́.” Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlówun ɩwɩɔsɩn ámʋ́ʋ́ nɛbá bowun amʋ, wú lowu ámʋ́ʋ́ nówu ámʋ ɛ́, ");
INSERT INTO nkoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","támɛ mma túmi ánɩ́ nɛ́lɛ ɔhá ánɩ́ obétsiá mɩ́ gyɔpɩ ntɛ́ɛ bɩnasʋ. Alɩ otsiákpá anfɩ mʋ́ ɩda gyo ahá ámʋ́ʋ́ Bulu lalá ɩnʋ yáɩ́ há ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Brɛ́á akasɩ́pʋ́ idú atráhɛ amʋ bonu asʋ́n ánfɩ á, Yakobo mʋa Yohane ɩwɩ lɔ́wa amʋ́ ɔblɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu lɛ́tɩ amʋ́ fɛ́ɛ́ ba mʋ ɩwɩ wá, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩyin ánɩ́ ahá ánɩ́ bʋtobú amʋ́á bʋgyi ɔmátɔ́fɔsʋ agyípʋ́ bʋtɛhɩ́ɛ́ amʋ́ ahá, amʋ́ ahandɛ ɛ́ bʋtenyá túmi amʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Támɛ mlɩtɔ mʋ́ á, ɩmába alɩ. Ɔhá ánɩ́ odekléá ɔbɔ́bwɛ mlɩtɔ ɔhandɛ ɔbwɛ́ɛ mlɩ fɛ́ɛ́ ɔkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nɩ́ mlɩtɔ ɔkʋ ɛ́ dékléá ɔbɔ́bwɛ mlɩ nkpá ogyápʋ a, ɔbwɛ́ɛ mlɩ fɛ́ɛ́ ɔkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ mmɛba mbɛ́ɛ, bʋsúm mɩ́. Ahá osúmkpá nɛba, ampʋ mɩ́ nkpa hɔ ahá tsɔtsɔɔtsɔ nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Boyówie Yeriko wúlutɔ. Brɛ́á mʋa mʋ akasɩ́pʋ́ pʋ́ ɔdɔm kpɔnkpɔɔnkpɔntɩ ámʋ́ʋ́ bʋbuo mʋ amʋ bʋdɛdalɩ ɩnʋ á, bowun Timeo mʋ bi Bartimeo. Mʋ ansíbi labwíé, otsie ɔkpatɔ ɔdɛ atɔ́ kʋlɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Brɛ́á olonu ánɩ́ Yesu Nasaretyin amʋ dɛ́tsʋ́ʋn a, ɔlɔwa kplʋ́n bɩ ɔbɛ́ɛ, “Anɩ Wíe Dawid mʋ na Yesu, wun mɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bɔkplʋ́n wa mʋ bɛɛ, ɔkpá ɔnɔ́ bun, támɛ mʋ mʋ́ ɔlɛlakplʋ́n dʋn alɩ ɔbɛ́ɛ, “Anɩ Wíe Dawid mʋ na, wun mɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu lési lɩɩ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩtɩ mʋ ha mɩ.” Bokpolí ansibi obwiepʋ́ ámʋ, bɛbláa mʋ bɛɛ, “Fʋ́ klʋn ɩdɩ́ fʋ́ asɩ, afʋkʋsʋ ba. Ɔdɛ fʋ́ tɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɩnʋ oyin ámʋ lɔ́tswɩ mʋ ɔsʋ́sʋ́ atadɩɛ tsálɩ́fwɩ́, wáan kʋsʋ́ ba Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntɔ fʋdeklé fɛɛ mbwɛ́ɛ ha fʋ?” Ɩnʋ ansibi obwiepʋ́ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Osunápʋ́, ha mɩ́ anwun atɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɩnʋ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Natɩ, fʋ́ hógyi latsá fʋ́ ɩlɔ.” Ɩnʋnʋ mʋ ansíbi lobwií, ɔlɛkplá buo Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Brɛ́á bowie Betfage mʋ́a Betania, awúlu ánɩ́ ɩbʋ Nfɔ-nyíbʋ ámʋ asɩ, batá Yerusalem wie tá á, ɔlɔwa mʋ akasɩ́pʋ́ abanyɔ́ gyankpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ɔbɛ́ɛ, “Mlɩyɔ wúlu anfɩ́ ɩda mlɩ ansɩ́tɔ́ ánfɩtɔ. Nɩ́ mlowíe wúlu amʋ ɔnɔ́ á, mlówun afrímú kanáhɛ ɔkʋ da ɔfɛ́tɔ́, ɔhaa mɔ́kʋ́tsíá mʋsʋ kɩ. Mlɩsankɩ mʋ, amlɩkpa mʋ ba mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɩ́ ɔkʋ ɔfɩ́tɛ́ mlɩ ɔbɛ́ɛ, ‘Ntogyi sʋ́ mlɩdɛ́ mʋ sankɩ́?’ á, mlɩbla mʋ mlɩaa, ‘Anɩ Wíe dɛ́ mʋ hián. Obéyinkía mʋ ba séi.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bɔyɔ á, bɔyɔ́tʋ afrímú ibí ámʋ da ɔfɛ́tɔ́ wóyí ámʋ ɔnɔ́ ɔkpabáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Brɛ́á bʋdɛ mʋ sankɩ́ á, aha akʋá bʋlɩɩ́ ɩnʋ bɛfɩtɛ́ amʋ́ bɛɛ, “Ntogyi sʋ́ mlɩdɛ́ afrímú ibí ámʋ sankɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɛlɛ mʋ́ ɔnɔ́ alɩ ámʋ́ʋ́ Yesu lɛ́bláa amʋ́ ámʋ pɛ́pɛ́ɛ́pɛ́. Besi amʋ́; akasɩ́pʋ́ amʋ bɛsankɩ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bɛkpa afrímú ibí ámʋ ba Yesu. Bɛyaɩ́ amʋ́ atati dɩ́nká mʋsʋ, ɔlɔdʋ bian mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bɛyaɩ́ amʋ́ atati tswɩ ɔkpatɔ, akʋ ɛ́ bebiabía afɩtáa bunbun ɔkpa ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ahá ámʋ́ʋ́ bʋgya Yesu nkpá mʋ́a ɔma amʋ bɔsʋrá okitikíti bɛɛ, “Hosiána! Bulu oyúla ɔhá ánfɩ ɔbá anɩ Wíe dátɔ́ ánfɩ! ");
INSERT INTO nkoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bulu oyúla anɩ náin Dawid iwíegyí ámʋ́ʋ́ ɩbá ámʋ! Hosiána bʋ ɔsʋ́sʋ́ʋ́sʋ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Brɛ́á Yesu lówie Yerusalem a, ɔlɔyɔ Bulu ɔtswɛ́kpa, ɔlɔwa ansɩ́ kɩ tógyítɔ́ wunsɩnɛ́sʋ́ ɩnʋ wankláán. Owí lapɔn. Mʋ́ sʋ mʋa mʋ akasɩ́pʋ́ dúanyɔ ámʋ beyinkí yɔ́ Betania wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɔyɩ kɛhɛ brɛ́á beyinkí tsú Betania bɛbá á, akʋ́n dɛ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Olowun pɔntɔ kʋá ɩlahɩ́ɛ́ pɔ́ɩ́ sɩ́sɩ́, ɩlɩɩ́ mantáa ɔkpa. Ɔlɔyɔ yɛ́kɩ bɛɛ obénya kʋ mʋ́tɔ́. Támɛ olowie mʋ́ asɩ á, afɩtáa sɔ́ɔ́n bʋ mʋ́sʋ́, tsúfɛ́ oyí ámʋ swiebɩ́ mɔkʋ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ɩnʋ ɔlɛbláa oyí ámʋ ɔbɛ́ɛ, “Tsú ndɛ pʋ́ya a, ɔhaa mɛ́ɛtrá gyi fʋ́ abi swiehɛ́.” Mʋ akasɩ́pʋ́ amʋ ɛ́ bonu asʋ́n ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Brɛ́á bowie Yerusalem a, Yesu lɔ́yɔ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́. Ɩnʋnʋ ɔlɔwa atɔ́ afɛpʋ́ pʋ́ atɔ́ ahɔ́pʋ amʋ aná fɛ́ɛ́ gyáa dalɩ ɩnʋ bɩ. Olowuwúta kɔ́ba atsɛ́pʋ mpʋ́nʋ́ dá, súnsúnki abrɔ́dʋma afɛpʋ́ mbíá dá. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɔmɛha atɔ́ ɔfɛpʋ́ ɔkʋkʋ ɔsʋra mʋ atɔ fɛhɛ́ ka tsʋn Ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Olosuná amʋ́ atɔ́ ɔbɛ́ɛ, “Bʋmɔwanlɩ́n wá Bulu asʋn wanlɩ́nhɛ́ amʋtɔ bɛɛ, ‘Bɛ́tɩ mɩ́ ɔtswɛ́kpa bɛɛ, ɔmá fɛ́ɛ́ mpáɩ ɔbɔkpá?’ Támɛ mlɩlapʋ́ ɩnʋ mlí awikplu ɔŋaínkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Brɛ́á Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ amʋ bonu tɔ́á alabwɛ́ á, bodunká ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ mɔ́ mʋ. Benya ifú, tsúfɛ́ mʋ atosunáhɛ́ amʋ lɛha ɔnɔ́ lobwie ɔdɔm amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Brɛ́á owí lɔpɔn a, Yesu mʋa mʋ akasɩ́pʋ́ bɛdalɩ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Brɛ́á bʋdɛtsʋ́ʋn nyankɩ a, bowun ánɩ́ pɔntɔ oyí ámʋ ɩlawú tsú mʋ́ ɔsʋ́ beyi asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ɩnʋ Petro lɛ́kaɩ́n asʋ́n ánɩ́ Yesu lɛ́bláa pɔntɔ oyí ámʋ. Mʋ́ʋ́ ɔlɛbláa Yesu ɔbɛ́ɛ, “Osunápʋ́, kɩ, pɔntɔ oyí ámʋ́ʋ́ fɔlwɩɩ́ ámʋ ɩlawú!” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩhɔ Bulu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɔnɔkwalɩ ndɛ mlɩ bláa, ɔhagyíɔha ánɩ́ ɔbɛ́bláa ɩbʋ ánfɩ ɔbɛ́ɛ, ‘Púli yowie ɔpʋtɔ’, omegyi nwɛ́ɛn mʋ klʋntɔ, olohogyi ánɩ́ asʋ́n ámʋ́ʋ́ mablɩ́ ámʋ ɩbɛ́ba mʋ́tɔ́ á, ibópulí yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɩ́nɩ sʋ ndɛ mlɩ bláa mbɛ́ɛ, tógyítɔ́á mlɔkʋ́lɩ́ Bulu á, mlɩhogyi ánɩ́ mlɩlanyá mʋ́ dodo. Mlɩ ɩbɩ bɛ́da mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Nɩ́ mlɩlɩ́ɩ́ mlɩdɛ́ mpáɩ bɔ, ɔkʋ asʋ́n bʋ mlɩ klʋntɔ á, mlɩsi ɔhá ámʋ lakpan kie mʋ, mɛ́nɩ mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ ɛ́ obési mlɩ klɛ́ kíé mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu mʋa mʋ akasɩ́pʋ́ amʋ bɛtrá yinkí ba Yerusalem. Brɛ́á ɔna odeki Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ á, Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ bɛba mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bɛfɩtɛ́ mʋ bɛɛ, “Túmi mɔmʋ fʋ́dɛpʋbwɛ́ ntobí ánfɩ? Ma lɛ́ha fʋ́ túmi ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu lɛ́lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nfɩ́tɛ mlɩ asʋn kua kʋlɛ. Nɩ́ mlɛlɛ́ mʋ́ ɔnɔ́ há mɩ́ á, mɩ́ ɛ́ nɛ́bláa mlɩ túmi oduá ndɛpʋbwɛ́ ntobí ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bulu wá Asú Ɔbɔpʋ́ Yohane lénya túmi pʋ́bɔ́ ahá asú lóó, ntɛ́ɛ nyankpʋsa? Mlɩbla mɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Amʋ́ wʋlɛwʋlɛ bɔyɔ asʋ́n ánfɩtɔ bɛɛ, “Nɩ́ ablɩ́ anɩaa itsú Bulu wá á, ɔbɛ́fɩtɛ́ anɩ ɔbɛ́ɛ, mʋ́ ntogyi sʋ́ mlɩmɔ́hɔ mʋ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ntɛ́ɛ ablɩ́ɩ anɩaa itsú anyánkpʋ́sa wá?” Támɛ bʋdɛ ahá ámʋ ifú nya, tsúfɛ́ amʋ́ fɛ́ɛ́ bohogyi ánɩ́ lɛ́lɛ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ onutó Yohane gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mʋ́ sʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ohwée! Anɩméyín ɔtɩ́nɛ́á olenya mʋ túmi tsú.” Mʋ́ʋ́ Yesu ɛ́ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mɩ́ ɛ́ mmɛ́ɛbláa mlɩ túmi oduá ndɛpʋbwɛ́ ntobí ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu lɔ́wa amʋ́ asʋ́n bláa ayébitɔ bɩ. Ɔbɛ́ɛ, “Oyin ɔkʋ lɔ́dɔ wáɩn ndɔ. Olegyi ɩban bómlí mʋ́. Olokwi wáɩn amʋ onyimɛ́kpá, ɔlɔpwɛ obu fʋ́áhɛ́ kʋ há ndɔ ámʋ agyópʋ. Mʋ́ʋ́ ɔlɔpʋ ndɔ ámʋ wá apafɔ ɩbɩtɔ, olotu ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Brɛ́á wáɩn-abí ámʋ kpɔtɩ́bɩ lɔfʋn a, ɔlɔwa mʋ osúmpʋ́ apafɔ ámʋ wá ɔbɛ́ɛ, ɔyɔ́hɔ mʋ ogyíkpá ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Támɛ apafɔ ámʋ bɛkɩtá mʋ, dá mʋ, gya mʋ sɩ́sɩ́ ɩbɩkpan. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ndɔ mʋ wie amʋ lɛ́trá wa mʋ osúmpʋ́ nyɔɔsɩ amʋ́ wá. Apafɔ ámʋ bɛda mʋ ɛ́, pílan mʋ nwuntɔ, sʋ́pa mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɔlɛtrá lawá ɔbambá. Mʋ mʋ́ á, bɔmɔ mʋ. Alɩ kɛ́n bɔbwɛ atráhɛ ɛ́ nɩ́. Bɛda akʋ, mɔ́ akʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ilesi mʋ onutó mʋ bi ɔkʋlɛ pɛ́á ɔtamatsúlá mʋsʋ. Ɔkɩ ɔbɛ́ɛ, bóbu mʋ mʋ́. Mʋ́ sʋ ɔlɔwa mʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Támɛ apafɔ ámʋ bɛblɩ́ bɛɛ, ‘Ɔ́nɩ obégyi mʋ sɩ atɔ́ nɩ́. Mlɩha amɔ mʋ, mɛ́nɩ ndɔ ámʋ ibémlí anɩ klɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mʋ́ sʋ bɛkɩtá mʋ, mɔ́ mʋ́, tswɩ mʋ dálɩ ndɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ɛkɛá ndɔ mʋ wie amʋ ɔbá á, ntɔ mlɩlahogyi mlɩaa ɔbɔ́bwɛ apafɔ ánfɩ? Ɔbɛ́ha bɔmɔ amʋ́. Ɔbɛ́lapʋ́ ndɔ ámʋ wá apafɔ bámbá ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ntɛ́ɛ mlɩmɔ́kʋ́kla Bulu asʋn wanlɩ́nhɛ́ amʋ kɩ? Bɔwanlɩ́n bɛɛ, ‘Ibwi ámʋ́ʋ́ obu ayípʋ bekiná ámʋ lébemlí okonkísʋ́bwi nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bulu lɔ́bwɛ mʋ́ alɩ. Ɩbʋ wánwan.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɩnʋ Yudafɔ ámʋ bekleá bɛ́kɩtá Yesu, tsúfɛ́ bɛbɩ ánɩ́ amʋ́ sʋ alahá yébi ánfɩ, támɛ bʋdɛ ɔdɔm amʋ ifú nya. Mʋ́ sʋ bɛnatɩ́ sí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɔma a, bɔwa Farisifɔ pʋ́ Owíe Herode ahá bɛɛ, bʋyɛ́tɛtɛ́ɛ Yesu ɔnɔ́tɔ́ asʋ́n nu, abʋnya mʋ akɩtálɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Brɛ́á bɛba mʋ wá á, bɛbláa mʋ bɛɛ, “Osunápʋ́, anɩyin ánɩ́ ɔnɔkwalɩpʋ fʋgyi. Fʋtamahá ɔhaa ɔtsɛ fʋ́ agywɩɩn, tsúfɛ́ fʋtamakɩ ɔhaa ansɩ́tɔ́. Mboún Bulu asʋ́n ámʋ́ʋ́ igyi ɔnɔkwalɩ amʋ fʋdesuná. Mʋ́ sʋ anɩdɛ́ fʋ́ fɩtɛ́ anu. Anɩ mbla lɛha ɔkpa ánɩ́ akáa lampóo ha Roma owíe dɛhɛn Kaesare, ntɛ́ɛ anɩmáka?” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu lɛ́bɩ ánɩ́ bʋkɩ ansɩ́. Mʋ́ sʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Apinabwɛbí abwɛpʋ́, ntogyi sʋ́ mlɩdɛ́ mɩ́ sɔ́ɔ kɩ? Mlɩtsu kɔ́ba amʋ ɩkʋ ba mɩ ankɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɔpʋba mʋ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma nwun pʋ́ mʋ ɩdá dɩ́n mʋ́sʋ́?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Kaesare.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mlɩpʋ tɔ́á igyi Kaesare klɛ́ ha Kaesare, amlɩpʋ mʋ́á igyi Bulu klɛ́ ɛ́ ha Bulu.” Mʋ ɩwɩ lɔ́wa amʋ́ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɔpasua kʋá bʋtɛtɩ́ mʋ́ Sadukifɔ akʋ bɛba Yesu wá. Bʋgyi ɔpasua kʋá bʋtɛblɩ́ bɛɛ, kʋsʋ́ tsú afúlitɔ ma ɩnʋ. Bɛfɩtɛ́ mʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Osunápʋ́, Mose lɔ́wanlɩ́n tswɩ anɩ ɔbɛ́ɛ, ‘Nɩ́ ɔkʋ mʋa mʋ ka bʋmɔkwɩɩ́ asa olowu sí mʋ ka ámʋ a, mʋ pio otsú mʋ ka ámʋ tsia, fɛ́kɩ ɔkwɩɩ ha owupʋ́ ámʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oyin ɔkʋlɛ abí abasíénɔ́ akʋ betsiá. Amʋ́tɔ́ ogyankpapʋ létsiá ɔká, támɛ ɔmɔkwɩɩ́ asa olowu. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mʋ gyama lótsu ɔsʋrapʋka amʋ tsía, támɛ mʋ ɛ́ ɔmɔkwɩɩ́. Ɔsaasɩ lótsu ɔtsɩ ámʋ tsía. Mʋ ɛ́ ɔmɔkwɩɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Alɩɩ yɔ́tʋ osienɔ́sɩ́ amʋ. Amʋ́tɔ́ ɔkʋkʋ mɔ́kwɩɩ́ asa olowu. Ɔma-ɔma a, ɔsʋrapʋ amʋ ɛ́ lóbowu. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Afúli ɔkʋsʋ́kɛ́ a, amʋ́tɔ́ ɔmɔmʋ ɔbɔ́bwɛ mʋ kulu? Tsúfɛ́ amʋ́ abasíénɔ́ ámʋ fɛ́ɛ́ betsiá mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mʋ́ʋ́ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí mlɩ ológyi. Mlɩméyín Bulu asʋn wanlɩ́nhɛ́ amʋ ntɛ́ɛ Bulu túmi. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tsúfɛ́ nɩ́ afúli bɔkʋ́sʋ́ á, bɔ́bwɛ fɛ́ Bulu-abɔpʋ. Bʋméetsiá aká mʋ́a akúlu. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Támɛ afúlikʋsʋ́ ɩwɩ mʋ́ á, yɛ́ɛ mlɩlakla Mose ɔwʋlʋ́, nú asʋ́n ámʋ́ʋ́ Bulu lɛ́bláa mʋ dimbísʋ́ brɛ́á olowun oyíbi kʋ dɛ ogyá tsií, támɛ ɩmɛdɛ́hɔ́ɔ amʋ? Ɔbɛ́ɛ, ‘Mɩ́gyí mlɩ anáin Abraham mʋa Isak pʋ́ Yakob Bulu ámʋ nɩ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Megyí awupʋ́ Bulu ógyi, akɩankpapʋ Bulu ógyi. Mlɩ mʋ́ mlɩlafwɩ́ fɛ́ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mose mbla asunápʋ́ amʋtɔ ɔkʋlɛ lɔ́bɔtʋ amʋ́ ɩnʋ, olonu asʋ́n ánɩ́ bʋdɛbɩtɩ́. Olowun ánɩ́ Yesu lalɛ́ Sadukifɔ ámʋ asʋ́n ɔnɔ́ wankláán. Mʋ́ sʋ ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Bulu mbla ámʋtɔ mɔmʋ dʋ́n?” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bulu mbla ámʋtɔ mʋ́á ɩdʋn nɩ. ‘Israelfɔ, mlɩnu. Bulu ɔkʋlɛ pɛ́ anɩ Wíe Bulu gyí. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mʋ́ sʋ pʋ fʋ́ klʋn, fʋ́ ɔkláa, fʋ́ agywɩɩn pʋ́ fʋ́ ɔwʋnlɩ́n fɛ́ɛ́ dwɛ fʋ́ Wíe Bulu.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mʋ́ nyɔɔsɩ ɛ́ gyí, ‘Dwɛ fʋ́ bá fɛ́ fʋ́ ɩwɩ.’ Mbla kʋkʋ ɩtráa ma ɩnʋá ɩdʋn ɩ́nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mbla osunápʋ́ amʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Osunápʋ́, fablɩ́ ɔnɔkwalɩ. Anɩ Wíe Bulu nkʋlɛ pɛ́ bʋ ɩnʋ, ɔkʋkʋ trá ɔma ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Apʋ́ʋ anɩ klʋn, anɩ agywɩɩn pʋ́ anɩ ɔwʋnlɩ́n fɛ́ɛ́ dwɛ́ mʋ, adwɛ anɩ aba fɛ́ anɩ ɩwɩ. Ɩdʋn mbwɩ tɔ́hɛ́ pʋ́ afɔdɩɛ kugyíkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu lówun ánɩ́ alabɩ́ lɛ́ asʋ́n ámʋ ɔnɔ́ wankláán, ɔlɛbláa mʋ ɔbɛ́ɛ, “Fʋma ɩfɔ́ Bulu iwíegyí ámʋtɔ.” Mʋ́ ɔma a, ɔhaa mɛ́trá wa klʋn fɩtɛ́ mʋ asʋansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Brɛ́á Yesu dɛ́ atɔ́ suná Bulu ɔtswɛ́kpa nwunsɩnɛ́sʋ́ ɩnʋ á, ɔlɛfɩtɛ́ ɔbɛ́ɛ, “Nkálɩ sʋ́ Mose mbla asunápʋ́ amʋ bɛtalɩ́ blɩ́ bɛɛ, Owíe Dawid mʋ na gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu lɛ́da mʋ ofúli amʋ)? ");
INSERT INTO nkoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tsúfɛ́ Ɔŋɛ Wankɩ́hɛ́ lɛ́ha Owíe Dawid onutó lɛ́blɩ́ ɔbɛ́ɛ, ‘Anɩ Wíe Bulu lɛ́bláa mɩ́ Wíe ɔbɛ́ɛ, “Tsia mɩ́ gyɔpɩsʋ nfɩ yɔ́fʋn brɛ́á nɛ́ha fɛ́tsatsáa fʋ́ alupʋ́sʋ́.” ’ ");
INSERT INTO nkoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Owíe Dawid onutó lɛ́tɩ mʋ ɔbɛ́ɛ mʋ wie. Nkálɩ sʋ ɔtráa ogyi mʋ na?” Asʋ́n ánfɩ lɔ́wa ɔdɔm kpɔnkpɔɔnkpɔntɩ ámʋ́ʋ́ befia bomlí mʋ amʋ ɔdwɛ, bɔpʋ ansigyí nú mʋ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu lɛ́blɩ́ mʋ atosunáhɛ́ amʋtɔ ɔbɛ́ɛ, “Mlɩkɩ wankláán Mose mbla asunápʋ́sʋ. Bʋtekle ligá wa nátɩ́ kí, bʋtekle bɛɛ, ahá bʋbún ha amʋ́ itsiá dɩnsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Otsiákpá yilé bʋtekle tsiá Yudafɔ ofíakpa pʋ́ nkɛ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bʋtesísi asʋrapʋ, swɩ́ɩ́ amʋ́ amʋ́ wóyí. Bʋtepina bɔ mpáɩ tɩ́ntɩ́ɩ́ntɩ́n ahátɔ pʋ́bun amʋ́ lalahɛsʋ. Bulu ɔbɛ́bɩtɩ́ amʋ́ ɩsʋ kínkíínkín!” ");
INSERT INTO nkoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu létsiá mantáa tswɩtswɩ dáka Bulu ɔtswɛ́kpa ɩnʋ, ɔdɛ ahá kɩ́ɩ bʋdɛpʋ amʋ́ tswɩtswɩ bɔwa mʋ́tɔ́. Ahá ánɩ́ amʋ́ ɩbɩtɔ bʋ odwin bʋdɛpʋ kɔ́ba akpɔnkpɔntɩ bɔwa. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɩnʋ ɔsʋrapʋ ɔkʋá ɔma tɔtɔ ɛ́ lɔ́pʋ mʋ kɔ́ba-ana bɔwa dáka ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mʋ́ʋ́ ɔlɛtɩ mʋ akasɩ́pʋ́ amʋ ba mʋ wá, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, tswɩtswɩá ɔsʋrapʋ anfɩ́ ɔma tɔtɔ lawá á, ɩdʋn ɔhagyíɔha klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tsúfɛ́ atráhɛ amʋ fɛ́ɛ́ á, amʋ́ kɔ́ba tsɔtsɔɔtsɔtɔ balɛ́ kpalobí tsú bɔwa. Támɛ ɩ́nɩá ɔsʋrapʋ anfɩ mʋ́ má tɔtɔ sʋ tɔ́á ɔbʋ fɛ́ɛ́ alapʋ́ bɔwa á.” ");
INSERT INTO nkoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Brɛ́á Yesu lɛ́dalɩ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ ɔyɔ́ á, mʋ akasɩ́pʋ́ amʋtɔ ɔkʋlɛ lɛ́bláa mʋ ɔbɛ́ɛ, “Osunápʋ́, kɩ mbu wankláán pʋ́ abwi akpɔnkpɔntɩ ánfɩ bɔpʋyi mʋ́ ánfɩ akɩ́lɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Yɛ́ɛ fawun mbu akpɔnkpɔɔnkpɔntɩ ánfɩ? Bóbwie mʋ́ fɛ́ɛ́ bun. Ibwi kʋlɛ kʋ́ráá méesian dɩnká mʋ́ básʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Brɛ́á Yesu tsie Nfɔ-nyíbʋ ámʋsʋ, ɔdɛ Bulu ɔtswɛ́kpa mbu ámʋ kɩ́ɩ a, Petro, Yakobo, Yohane mʋa Andrea nkʋlɛ bɛfɩtɛ́ mʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bla anɩ, brɛ́ mɔmʋtɔ ɩ́nɩ fɛ́ɛ́ bɛ́ba? Osúna mɔmʋ ɛ́ ɔbɛ́ba, ibósuná ánɩ́ mʋ́ brɛ́ lafʋn?” ");
INSERT INTO nkoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩkɩ wankláán, mɛ́nɩ ɔhaa mɛ́ɛmlɛ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ahá tsɔtsɔɔtsɔ bɔ́pʋ mɩ́ dá ba bɛɛ, amʋ́gyí Kristo amʋ nɩ. Bɛ́mlɛ́ ahá tsɔtsɔɔtsɔ bɔ́fwɩ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɩ́ mlonúá ɩsá ladá mantáa mlɩ ntɛ́ɛ ɔtɩnɛkʋ á, opúni mátsií mlɩ Tsúfɛ́ lehián ánɩ́ ɩ́nɩ aná fɛ́ɛ́ bɛ́ba, támɛ imedésuná ánɩ́ ɔyɩ́ ɔnɔ́mɔkɛ́ ámʋ lafʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tsúfɛ́ ɔmá bɔ́kɔ aba. Awíe bɔ́kʋsʋ́ lɩ́ɩ́ abasʋ. Ɔsʋlʋ́ʋ bɛ́kpɩnkɩ́ ntɩ́nɛ́-ntɩ́nɛ́. Akʋ́n ɛ́ bɛ́ba. Ɩ́nɩ fɛ́ɛ́ igyi fɛ́ ɩwɩɔsɩn ánɩ́ ɔtsɩ towun brɛ́á ɩkwɩ́ɩ dɛ mʋ dwiín. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mʋ́ sʋ mlɩ mʋ́ mlɩkɩ mlɩ ɩwɩ wankláán. Tsúfɛ́ mɩ́ sʋ bɔ́pʋ mlɩ há Yudafɔ asʋ́n agyípʋ́, bɛ́da mlɩ amʋ́ ofíakpa awúlu-awúlusʋ. Bɛ́kpa mlɩ ya ɔmásʋ́ agyípʋ́ pʋ́ awíe ansɩ́tɔ́, mɛ́nɩ mlégyi mɩ́ ɩwɩ adánsɩɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Támɛ ilehián ánɩ́ bégyankpá dá asʋn wankláán ámʋ ɔkan súná ɔyɩ́tɔ́ ahá fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nɩ́ bɛkɩ́tá mlɩ ya a, mlɩmágywɩ́ɩn asʋ́n ánɩ́ mlɛ́blɩ́. Mlɩblɩ asʋ́ngyíasʋ́n ánɩ́ Bulu ɔbɔ́pʋwá mlɩ ɔnɔ́ alɩ brɛ́ ámʋtɔ. Tsúfɛ́ megyí mlɩ onutó ɔbɔ́tɔɩ́, Ɔŋɛ Wankɩ́hɛ́ ɔbɔ́tɔɩ́ tsʋn mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Apíó bɛ́lɛ amʋ́ apíó há lowu. Abí asɩ́ bɛ́lɛ amʋ́ abí há. Abí ɛ́ bɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ akwɩɩ́pʋ́sʋ, há bɔ́mɔ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mɩ́ sʋ ahá fɛ́ɛ́ bólu mlɩ, támɛ nɩ́ mlɛ́talɩ́ wá klʋn lɩ́ɩ́ kínkíínkín yɔ́fʋn mʋ́ ɔnɔ́mɔ á, Bulu ɔbɔ́hɔ mlɩ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Támɛ nɩ́ mlowun akisítɔá itobwíé ɔmá, ɩda ɔtɩ́nɛ́á mlɩmɛ́dɩ́n ansɩ́ ánɩ́ ɩbɛ́ba a, (aklápʋ, mlɩnu mʋ́ asɩ.) Mʋ́mʋ́ ahá ánɩ́ bʋbʋ Yudea ɔmátɔ́ bʋsrɩ yɔ abʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɔhá ánɩ́ ɔdɩn obusʋ mákplɩ botsu tɔtɔ obuto! ");
INSERT INTO nkoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɔhá ánɩ́ ɔbʋ ndɔtɔ ɛ́ máyinkí botsu mʋ tati. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amenyapʋ́ pʋ́ abí-ayín ánɩ́ bʋpia abi bɔbwɛ alɩ brɛ́ ámʋtɔ, bʋgyɔ́wɩ nɩ́! ");
INSERT INTO nkoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mlɩkokoli Bulu mlɩaa, mlɩ ɔsrɩ́kɛ́ amʋ ɩmábwɛ nyankpʋ mʋ́a atsalɩbɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsúfɛ́ asʋn wunhɛ ánɩ́ ɩbɛ́ba alɩ brɛ́ ámʋtɔ odu mɔkʋ́ba tsú brɛ́á Bulu lɔ́bwɛ ɔyɩ́ ɔpá kɩ. Mʋ́ odu kʋkʋ ɛ́ ɩmɛ́ɛtrá ba ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nɩ́ Bulu mɛ́dɩnkɩ́ nkɛ ámʋsʋ á, tɛkɩ ɔhaa méesian ɔyɩ́tɔ́. Támɛ ahá ámʋ́ʋ́ alalɛ́ pʋ́bwɛ́ mʋ klɛ amʋ sʋ aladɩ́nkɩ́ nkɛ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Alɩ brɛ́ ámʋtɔ á, nɩ́ ɔkʋ lɛ́bláa fʋ ɔbɛ́ɛ, ‘Kɩ, Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) bʋ nfɩ ntɛ́ɛ nána’ á, máhógyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tsúfɛ́ ahá ánɩ́ bɛɛ amʋ́gyí Kristo amʋ pʋ́ ahá ánɩ́ bɔ́wa afunu bɛɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ bʋgyi tsɔtsɔɔtsɔ bɛ́ba ɔyɩ́tɔ́. Bɔ́bwɛ ofúla pʋ́ osúna pʋ́mlɛ́ ahá. Nɩ́ bɛ́talɩ́ kʋ́ráá á, bɛ́mlɛ́ ahá ámʋ́ʋ́ Bulu lalɛ́ ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Támɛ mlɩkɩ wankláán! Nabláa mlɩ tógyítɔ́ asa ɩbɛ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ɩwɩɔsɩn wúun amʋ ɔma a, owí ɔbɛ́ta, ɔtsra ɛ́ ɔmɛ́ɛtrá fɛɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ntsrakpabi bɛ́kpa tsú ɔsʋ́sʋ́ bɛda. Nwʋlʋ́táa mʋ́a mʋ́tɔ́ atɔ́ fɛ́ɛ́ bɛ́kpɩnkɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɔhagyíɔha obówun ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ napʋ́ túmi mʋ́a numnyam kpɔnkpɔntɩ mbʋ nwʋlʋ́táatɔ tsú ɔsʋ́sʋ́ nɛbá. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɩnʋ Bulu ɔbɔ́wa mʋ abɔpʋ bɛ́yɛkpa mʋ ahá ámʋ́ʋ́ alalɛ́ ámʋ tsú ɔyɩ́ afʋnka ana ámʋ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mlɩpʋkɩ pɔntɔ oyí. Nɩ́ mʋ́ abámbi dɛpɔɩ́, ɩdɛ atɛ pɔpwɛ lɛ á, mlɩtɛbɩ́ ánɩ́ awikpan brɛ́ lafʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Alɩ kɛ́n, nɩ́ mlowun ánɩ́ ntobí ánfɩ fɛ́ɛ́ ɩdɛ mʋ́tɔ́ bá a, mlɛ́bɩ ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩbábɩ lafʋn ta nɩ́. Nawíé wóyí ámʋ ɔnɔ́ tá. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ndɛmba-abí anfɩ fɛ́ɛ́ bʋmóowu tá, asa ɩ́nɩ fɛ́ɛ́ bɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ɔsʋ́ mʋ́a asɩ fɛ́ɛ́ bɔ́tsʋn, támɛ mɩ́ asʋn blɩ́hɛ́ mɔ́ɔtsʋn ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Támɛ ɔhaa méyín ɛkɛ ntɛ́ɛ brɛ́á ntobí ánfɩ fɛ́ɛ́ ɩbɛ́ba. Bulu-abɔpʋ bʋmeyín. Bulu mʋ Bi ámʋ ɛ́ méyín, nkɛ́tɩ anɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ nkʋlɛ pɛ́ yin. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mlɩdɩnka ansɩ́ ɩwɩsʋ, tsúfɛ́ mlɩméyín ɛkɛá brɛ́ ámʋ ɩbɔ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Igyi fɛ́ ɔkʋá ɔdɛ ɔkpa tu, olesi mʋ wóyí wá mʋ asúmpʋ́ ɩbɩtɔ. Ɔlɛha okugyíɔkʋ agyʋ́má ɔbɛ́ɛ ɔbwɛ́ɛ. Ɔlɛbláa wóyí ámʋ ogyópʋ ɛ́ ɔbɛ́ɛ, ɔyɩ́rɩ ɩwɩ ogyo wóyí ámʋ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mʋ́ sʋ mlɩdɩnka ansɩ́ ɩwɩsʋ, tsúfɛ́ mlɩméyín brɛ́á wóyí mʋ wie amʋ ɔbɛ́ba. Fíalɩ ntʋ́pwɛ o, ɔyɩ́-nsɩnɛ́ o, bakɛ o, ntɛ́ɛ nyankɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mlɩdɩnka ansɩ́ ɩwɩsʋ, mɛ́nɩ ɔbá bofwie mlɩtɔ á, ɔmɔbɔtʋ mlɩ ánɩ́ mlɩladídɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Asʋ́n ánfɩ ndɛ mlɩ bláa anfɩ kɛ́n ndɛ ɔyɩ́tɔ́ ahá fɛ́ɛ́ bláa. Mbɛ́ɛ, ‘Mlɩdɩnka ansɩ́ ɩwɩsʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ilesi nkenyɔ́ Yudafɔ abʋgyi Israelfɔsʋ Katsʋn Nkɛ pʋ́ Bodobodo Mátúhɛ́Nkɛ. Alɩ brɛ́ ámʋtɔ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ bodunká ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ kɩ́tá Yesu ŋáintɔ, mɔ́ mʋ kokooko. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Támɛ bɛblɩ́ bɛɛ, “Megyí Katsʋn Nkɛ ánfɩtɔ abɔ́mɔ mʋ, mɛ́nɩ kpokiti mɛ́ɛda ɔmá ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Brɛ́á Yesu bʋ Betania wúlutɔ, Simon ɔkʋá alalɔ́ ɩlɔ pɛpɛ kɩ wóyítɔ́ ɔdɛ atɔ́ gyí a, ɔtsɩ ɔkʋ lɛ́ba ɩnʋ; ɔdɛ prɛntʋa wankláán kʋá ofobí fánfán ánɩ́ ɩbʋ ibíá bʋ mʋ́tɔ́. Oletií mʋ́ ɔnɔ́, ɔlɛtsɛɩ́ ofobí ámʋ wʋ́lɩ́ Yesu nwuntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Akʋ bʋbʋ ɩnʋá ɩmɔwa amʋ́ ɔdwɛ. Bɛfɩtɛ́ aba bɛɛ, “Ntogyi sʋ́ ɔdɛ ofobí ánfɩ yintá? ");
INSERT INTO nkoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tɛkɩ abɛ́talɩ́ fɛ́ ofobí fánfán ánfɩ, mʋ́ ibíá bɔ́dʋn ɔbakʋ́lɛ ofi ɔkʋlɛ ɩkɔká ánfɩ, pʋ́há ahiánfɔ.” Bɛhɩɛ wá ɩyɩn wá ɔtsɩ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Támɛ Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mlɩsi mʋ! Ntogyi sʋ́ mlɩdɛ́ mʋ háan? Ɩtɔ yilé alabwɛ́ há mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ahiánfɔ bétsiá mlɩ wá ekekegyíɛkɛ. Brégyíbrɛ́á mlɩdéklé a, mlɛ́talɩ́ wá awɩtɔlɛ há amʋ́, támɛ mɩ́ mʋ́ mméetsiá mlɩtɔ yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Alabwɛ́ mʋ́á ɔbɛ́talɩ́ pʋ́lá mɩ́ ɔyʋlʋ́ʋ yáɩ́ há mɩ́ opulákɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔyɩ́tɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á bɛ́da Bulu asʋn wankláán ámʋ ɔkan a, bɛ́blɩ́ tɔ́ ánfɩ ɔtsɩ ánfɩ labwɛ́ ánfɩ pʋ́káɩ́n mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mʋ́ ɔma a, mʋ akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛá bʋtɛtɩ́ mʋ Yuda Iskariot lóyówun Bulu igyí ahapʋ́ dɛhɛn amʋ, mɛ́nɩ ɔbɛ́lɛ Yesu há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Brɛ́á bonu asʋ́n ánfɩ á, ɩlɛhɩɛ wá amʋ́ ɔdwɛ. Bɛhɩɛ mʋ asɩ ánɩ́ bɛ́ka mʋ ɩkɔ. Mʋ́ sʋ olodunká ɔkpa ánɩ́ ɔbɔ́tsʋn mʋ́sʋ́ lɛ́ Yesu há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bodobodo Mátúhɛ́Nkɛ ámʋtɔ ɛkɛ gyankpapʋá bʋtɔmɔ́ Israelfɔsʋ Katsʋn Nkɛ akúfa lɔ́fʋn. Yesu akasɩ́pʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, obu mɔmʋtɔ ayɛla ha fʋ, afʋgyi Katsʋn Nkɛtɔ atogyihɛ amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mʋ́ʋ́ ɔlɔwa amʋ́tɔ́ abanyɔ́, bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ Yerusalem wúlutɔ, mléfia oyin ɔkʋá ɔsʋ ntsu-ɔlɔ́, mlɩbuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wóyí oduátɔ́ obówie á, mlɩfɩtɛ wóyí mʋ wie amʋ mlɩaa, ‘Nkʋ́nʋ́ afɔɔ́ ɔswɩɩ́kpá bʋ, ánɩ́ mɩ́a mɩ́ akasɩ́pʋ́ abɛ́ba begyi Israelfɔsʋ Katsʋn atogyihɛ amʋ?’ ");
INSERT INTO nkoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Obósuná mlɩ abansʋ́rʋ yílé kʋá balá mʋ́tɔ́ yáɩ́. Mlɩbwɛ atɔ́ ámʋ yaɩ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesu akasɩ́pʋ́ amʋ bɔyɔ wúlu amʋtɔ á, bowun tógyítɔ́ alɩ ámʋ́ʋ́ Yesu lɛ́bláa amʋ́ ámʋ pɛ́pɛ́ɛ́pɛ́, bɔbwɛ Israelfɔsʋ Katsʋn atogyihɛ amʋ yáɩ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Brɛ́á nsaɩntɔ deklúun a, Yesu mʋa mʋ akasɩ́pʋ́ bɛba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Atɔ́ ámʋ ogyíkpá a, Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, mlɩtɔ ɔkʋlɛá mɩ́a mʋnyɔ ɩbɩ da ɔlɛpɛtɔ ɔbɛ́lɛ mɩ́ há.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Asʋ́n ánfɩ lɛ́hɩɛ han akasɩ́pʋ́ amʋ. Mʋ́ sʋ befi asɩ bʋdɛ mʋ fɩtɛ́ ɩkʋlɛ-kʋlɛ bɛɛ, “Mɩ́ nɩ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ ahá dúanyɔ ánfɩtɔ ɔkʋlɛá mɩ́a mʋnyɔ ɩbɩ da ɔlɛpɛtɔ ɔbɛ́lɛ mɩ́ há nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nówu fɛ́ alɩá bɔwanlɩ́n tswɩ, támɛ ɔhá ámʋ́ʋ́ ɔbɛ́lɛ mɩ́ há ámʋ ɔgyɔ́wɩ nɩ́. Nɩ́ bʋmetepí kwɩ́ɩ́ mʋ kʋ́ráá á, tɛkɩ ɩbʋ alɛ́ há mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Brɛ́á bʋdɛ atɔ́ ámʋ gyí a, Yesu lɛ́lɛ bodobodo ipín, ɔlɛda Bulu ɩpán, bíábía mʋ́tɔ́ pʋ́há amʋ́, blɩ́ ɔbɛ́ɛ, “Mlɩhɔ, mɩ́ ɔyʋlʋ́ʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ɩnʋ olotsu ntá-ɛwɛ, ɔlɛda Bulu ɩpán, pʋ́há amʋ́ fɛ́ɛ́ bonu. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mɩ́ obugya nɩ. Mʋ́ Bulu dɛ́pʋsí mʋ ntam ánɩ́ alaká há ahásʋ nɩ́. Bɛ́tsɛɩ́ mʋ́ wʋ́lɩ́ asɩ ahá tsɔtsɔɔtsɔ lakpan sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ɔnɔkwalɩ ndɛ mlɩ bláa, mmɛ́ɛtrá nu wáɩn-abí ntá ánfɩ alɩɩ yɔ́fʋn ɛkɛá nónu mʋ́ pɔ́pwɛ Bulu iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Benya wá ɩlʋ dá Bulu ɩpán tá alɩ, bɛnatɩ́ yɔ́ Nfɔ-nyíbʋ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ fɛ́ɛ́ mléyinkí mɩ́ ɔma. Tsúfɛ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Nɛ́da akúfa ɔkpapʋ́ ámʋ lɛ́dá, mʋ akúfa bɛ́dasáɩ́n.’ ");
INSERT INTO nkoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Támɛ nɩ́ Bulu ɔkʋ́sʋ́a mɩ tsú afúlitɔ á, négya mlɩ nkpá yɔ́ Galilea ɔmátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ amʋ́ fɛ́ɛ́ beyinkí fʋ́ ɔmá kʋ́ráá á, mɩ́ mʋ́ mméeyinkí ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ fʋ́ bláa. Onyenɩ, asa batɛ ɔbɛ́lɛ ɔnɔ́ tse nyɔ á, fɔ́swɩɩ́ pʋ́ ɩbɩ wá ogyá tse sa fɛɛ fʋmeyín mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɩnʋ Petro lɛ́fɩn yabi yi ɔbɛ́ɛ, “Nɩ́ lowu igyi kʋ́ráá á, mméekiná fʋ́ ɛkɛkɛɛkɛ.” Alɩ kɛ́n atráhɛ amʋ ɛ́ fɛ́ɛ́ bɛblɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Boyówie ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Getsemane. Mʋ́ʋ́ Yesu lɛ́bláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩtsia nfɩ, nɔyɔ́bɔ mpáɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɔlɛkpa Petro mʋa Yakobo pʋ́ Yohane buo ɩwɩ. Ɩnʋ asʋ́n lɛhɩɛ́ han mʋ, mʋ ansɩ́ lɛpɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Asʋ́n ɩhɩ́ɛ́ dɛ mɩ́ háan. Ideklé mɔ mɩ́. Mlɩtsia nfɩ, amlɩgyo.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɩnʋ ɔlɛnatɩ́ yɔ́ nkpá kpalobí, ɔlɛda akpawunu kókóli Bulu ɔbɛ́ɛ, “Nɩ́ ɩbɔ́wa alɛ́ á, ha brɛ́ ánfɩ ɩtsʋn mɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Abba Mɩ́ Sɩ́, fʋtɛtálɩ́ bwɛ́ tógyítɔ́. Ha ntá-ɛwɛ ánfɩ ɩtsʋn mɩsʋ! Támɛ megyí tɔ́á ndeklé, mboún mʋ́á fʋdeklé ɩbá mʋ́tɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oleyinkí bá akasɩ́pʋ́ amʋ wá bowun ánɩ́ bʋdɛdɩdɩ. Ɩ́nɩ sʋ ɔlɛfɩtɛ́ Petro ɔbɛ́ɛ, “Simon, fʋdɛdɩdɩ? Fʋmɛtalɩ́ gyo dɔnhwɩ́rɩ kʋlɛ kpán? ");
INSERT INTO nkoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mlɩgyo amlɩkokoli Bulu, mɛ́nɩ mlɩmóowie ɩsɔ́kɩtɔ. Tsúfɛ́ ɔŋɛ́ ámʋ déklé, támɛ nyankpʋsa lɔ́pɔn.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɔlɛtrá yɔ́bɔ mpáɩ, bláa Bulu asʋn kua kʋlɛ amʋ kɛ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɔlɛtrá yinkí ba bowun ánɩ́ akasɩ́pʋ́ amʋ bʋtráa bʋdɛdɩdɩ, tsúfɛ́ dɩdɩ́ dɛ amʋ́ bʋ. Bʋmɛtalɩ́ bláa mʋ asʋansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Brɛ́á ɔlɛba otse saasɩ a, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩlatráa si mlɩda mlɩdɛ́ ɔkpʋ́nʋ́ da? Itsía alɩ ngya! Brɛ́ ámʋ lafʋn ánɩ́ bɔ́pʋ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ wá lakpan abwɛpʋ́ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mlɩkʋsʋ ayɔ. Mlɩkɩ, ɔhá ámʋ́ʋ́ ɔdɛ mɩ́ lɛ há ámʋ ná á!” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ɔnɔ́ mesi asa akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛá bʋtɛtɩ́ mʋ Yuda lóbowie ɩnʋ. Ɔdɔm ánɩ́ bʋdɛ ndayí pʋ́ nkpotí bʋbuo mʋ. Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ lɔ́wa amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda amʋ́ʋ́ ɔlɛlɛ Yesu há ámʋ lɛ́bláa ɔdɔm amʋ yáɩ́ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ nɛ́latá pútá ámʋ gyí ɔhá ámʋ nɩ. Mlɩkɩta mʋ kínkíínkín, amlɩkpa mʋ natɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ɩnʋ ɔlɛnatɩ́ laa yɔ́ Yesu wá, yókpolí mʋ ɔbɛ́ɛ, “Osunápʋ́!” Ɔlɛlatá mʋ pútá. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɩnʋ ahá ámʋ bɛnatɩ́ tʋ́ Yesu, kɩ́tá mʋ kínkíínkín. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Támɛ ɩnʋ alɩɩ́pʋ́ amʋtɔ ɔkʋlɛ lɔ́tswɩ mʋ ɔdayí kpá Bulu igyí ɔhapʋ́ dɛhɛn osúmbi ɔkʋ ɩsʋ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ɩnʋ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ogyo otswapʋ́ ngyi, sʋ́ mlɩlatsú nkpotí pʋ́ ndayí mlɛbá mɩ́ ɔkɩtákpá? ");
INSERT INTO nkoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ntsie mlɩ wá Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ ekekegyíɛkɛ, ndɛ mlɩ atɔ́ suná, mlɩmɛ́kɩtá mɩ́ ɛkɛkɛɛkɛ. Ɩ́nɩ lahá Bulu asʋn wanlɩ́nhɛ́ amʋ ɩlaba mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɩnʋ mʋ akasɩ́pʋ́ amʋ fɛ́ɛ́ bɛsrɩ́ sí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ilesi ɔyasubi ɔkʋá ɔlɔwa ligá nkʋlɛ. Bɛkɩtá mʋ, ");
INSERT INTO nkoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","támɛ ɔlɔkɔlɩ, sí mʋ ligá ámʋ wá amʋ́ ɩbɩtɔ, pʋ́ yayá srɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɛkpa Yesu ya Bulu igyí ɔhapʋ́ dɛhɛn wóyí. Igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ fɛ́ɛ́ bafia ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro lɛ́pɛtɩ́ buo amʋ́ ɔma tsútsúútsú, alɩɩ yówie wóyítɔ́ ɩnʋ. Ɩnʋ oleyétsiá ɩnʋ asúmpʋ́ wá, ɔdɛ ogyá núu. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɩnʋ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ asʋ́n agyípʋ́ atráhɛ fɛ́ɛ́ bodunká ahá ánɩ́ bɛ́ka asʋ́n dɩ́nká Yesusʋ, mɛ́nɩ bɛ́lɩɩ́ amʋ́ asʋn blɩ́hɛ́sʋ mɔ́ mʋ, támɛ bʋmenya. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tsúfɛ́ ahá tsɔtsɔɔtsɔ bɔwa afunu dɩ́nká mʋsʋ, támɛ amʋ́ fɛ́ɛ́ ɔnɔ́ lɔtsʋn ɔtsan. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɩnʋ akʋ bɔkʋsʋ́ ká asʋ́n dɩ́nká mʋsʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Anɩlónuá ɔlɛblɩ́ ɔbɛ́ɛ, ‘Nóbwie Bulu ɔtswɛ́kpa anfɩ bapʋ́ ɩbɩ yi anfɩ, támɛ nkɛnsá ɔma a, nɛ́layi pɔ́pwɛá megyí nyankpʋsa ɔbɔ́pʋ ɩbɩ yi mʋ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Támɛ amʋ́ ɛ́ amʋ́ ɔnɔ́ mɔbwɛ kʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɩnʋ Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ fɛ́ɛ́ ansɩ́tɔ́, ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Fʋma ɔnɔ́ lɛ́? Fʋma asʋansʋ blɩ́ pʋ́lɛ́ fʋ́ ɩwɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Támɛ Yesu mɛ́lɛ asʋansʋ ɔnɔ́. Mʋ́ʋ́ Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́trá fɩtɛ́ mʋ ɔbɛ́ɛ, “Bulu ámʋ́ʋ́ bʋtɛkánfʋ́ ámʋ mʋ Bi gyí fʋ́? Fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu lɛ́da mʋ ofúli amʋ) nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee! Mɩ́ nɩ́! Mlówun ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ntsie Bulu Otúmípʋ gyɔpɩsʋ ánfɩ ndɩn nwʋlʋ́táasʋ tsú ɔsʋ́sʋ́ nɛbá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́kɩtá mʋ atadɩɛ bálɩ́ mʋ́ kɩaan. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Adánsɩɛ mɔmʋ anɩtráa anɩgyó? ");
INSERT INTO nkoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mlɩlanú abususʋ ánɩ́ alablɩ́. Nkálɩ gyí mlɩ agywɩɩn?” Amʋ́ fɛ́ɛ́ botsulá ánɩ́ olegyi pɔ́n, bʋmɔ́ɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Amʋ́tɔ́ akʋ bɔwa atsʋnɔ́ tutúu wʋlɩ́ mʋ bɩ. Bɔpʋ atɔ́ tin mʋ ansíbi, bɔfʋlɩ́ mʋ atswɛ, bláa mʋ bɛɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́, suna anɩ ɔhá ánɩ́ ɔlɔfʋlɩ́ fʋ́ ɩtswɛ!” Ɩnʋ agyópʋ amʋ ɛ́ bɛdadáa mʋ asʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petro lési otsie wunsɩnɛ́sʋ́ ɩnʋ, Bulu igyí ɔhapʋ́ dɛhɛn amʋ osúmbi tsɩ́hɛ́ ɔkʋ lɛ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Brɛ́á olowun Petro tsie ɔdɛ ogyá núu a, ɔlɛkɩ mʋ díín. Mʋ́ʋ́ ɔlɛfɩtɛ́ Petro ɔbɛ́ɛ, “Fʋ́a Yesu Nasaretyin amʋ nyɔ ná.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Támɛ Petro lɔ́swɩɩ́ blɩ́ ɔbɛ́ɛ, “Mmeyín tɔtɔ tsú asʋ́n ánfɩ fʋdɛblɩ́ ánfɩ ɩwɩ!” Ɔlɛnatɩ́ yɛ́lɩɩ́ ɔkpa ɔnɔ́, ɩnʋ batɛ lɔ́bʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Osúmbi tsɩ́hɛ́ ámʋ lɛ́trá yɔ́tʋ mʋ ɩnʋ, ɔlɔwa ahá ámʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋ bláa bɩ ɔbɛ́ɛ, “Amʋ́tɔ́ ɔkʋlɛ gyí oyin ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Támɛ Petro lɛ́trá swɩɩ́ pʋ́ ɩbɩ wá ogyá. Ɩlɔbwɛ kpalobí á, ahá ámʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋ bɛbláa Petro bɛɛ, “Lɛ́lɛ́ mʋ́ á, amʋ́tɔ́ ɔkʋlɛ fʋgyi, tsúfɛ́ Galileayin fʋ́ ɛ́ fʋ́gyi?” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɩnʋ Petro lɔ́wa ntam kakáa bɩ ɔbɛ́ɛ, “Nɛká tógyítɔ́, mmeyín oyin ánfɩ mlɩdɛ́ mʋ ɩwɩ asʋ́n blɩ́ ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ɩnʋ batɛ lɔ́bɔn otse nyɔɔsɩ. Mʋ́ʋ́ Petro lɛ́kaɩ́n asʋ́n ámʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fɔ́swɩɩ́ tse sa fɛɛ fʋmeyín mɩ́ asa batɛ ɔbɛ́lɛ ɔnɔ́ tse nyɔ.” ámʋsʋ. Mʋ́ʋ́ ɔlɛkpa isú yi, hɩ́ɛ́ sú woo. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɔyɩ kɛhɛ nyankɩ-nyankɩ a, Yudafɔ ahandɛ-ahandɛ amʋ fɛ́ɛ́ befia kɩtá agywɩɩn. Akʋ bʋgyi, Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ atráhɛ. Ɩnʋ bɛha bɛklɩ́ɩ Yesu, pʋ́ mʋ yɔ́wa Pilato ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Fʋ́gyí Yudafɔ owíe amʋ nɩ?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee, mʋ́ fablɩ́ á!” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɩnʋ igyí ahapʋ́ dɛhɛn amʋ bɛka asʋ́n tsɔtsɔɔtsɔ dɩ́nká Yesusʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mʋ́ sʋ Pilato lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Kɩ asʋ́n tsɔtsɔɔtsɔá baká dɩ́nká fʋ́sʋ́, fʋma mʋ́ ɔnɔ́ lɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Támɛ Yesu mɛlɛ asʋansʋ ɔnɔ́. Mʋ sʋ ɩlɔwa Pilato wánwan. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Katsʋn Nkɛ kugyíkʋtɔ á, igyi ɔmásʋ́ ogyípʋ́ Pilato amándɩ́ɛ́ ánɩ́ obési obu adɩpʋ́tɔ́ ɔkʋlɛá amʋ́ onutó bʋdeklé há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oyin ɔkʋá bʋtɛtɩ́ mʋ Baraba mʋa mʋ aba bʋda obu alɩ brɛ́ ámʋtɔ. Bɔkʋsʋ́ lɩ́ɩ́ ɔmásʋ́, kpokiti lɛ́da, bɔmɔ ɔha mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɔdɔm amʋ́ʋ́ bɔyɔ Pilato wá yóbwií ɩpa há mʋ bɛɛ, osíi obu ɔdɩpʋ́ ɔkʋlɛ ha amʋ́ alɩ ámʋ́ʋ́ otetsíá bwɛ́ há amʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mʋ́ʋ́ Pilato lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩdéklé mlɩaa, nsíi Yudafɔ Owíe anfɩ ha mlɩ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ɔlɛfɩtɛ́ amʋ́ alɩ, tsúfɛ́ olowun ánɩ́ Yesu ɩwɩ olu sʋ́ Bulu igyí ahapʋ́ dɛhɛn amʋ bakɩ́tá mʋ ba mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Igyí ahapʋ́ dɛhɛn amʋ bɛha ɔdɔm amʋ ɔnɔ́ bɛɛ, bʋkókoli Pilato, osi Baraba mboún ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato lɛ́trá fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ mbwɛ́ɛ ɔhá ámʋ́ʋ́ mlɩdɛ́tɩ mlɩaa, Yudafɔ Owíe amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɩnʋ amʋ́ fɛ́ɛ́ bɔsʋrá okitikíti bɛɛ, “Da mʋ manta oyikpalíhɛsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Tsitsa mɔmʋ alabwɛ́?” Támɛ bɛlasʋ́rá okitikíti kʋ́klʋ́kʋ́ʋ́ bɛɛ “Da mʋ manta oyikpalíhɛsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato dékléá ɔbɔ́bwɛ ɔdɔm amʋ apɛ́ há amʋ́. Mʋ́ sʋ olesi Baraba há amʋ́, ɔlɛha mʋ ɩsá akɔpʋ́ bɛpɩtɩ́ Yesu mplɩ, ɔlɔpʋ mʋ wá amʋ́ ɩbɩtɔ ɔbɛ́ɛ, bʋyɛ́da mʋ manta oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɩsá akɔpʋ́ ámʋ bɛkpa Yesu ya ɔmásʋ́ ogyípʋ́ amʋ wóyítɔ́. Bɛtɩ amʋ́ aba ɩsá akɔpʋ́ atráhɛ amʋ fɛ́ɛ́, bɛda Yesu ɔbʋn. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bɔpʋ ligá pɛpɛ kʋ wá mʋ, bɔlʋ obungyo-awu, bwɛ́ mʋ́ owíepa bun mʋ nwun. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɩnʋ bɔbwɛ mʋ ahinlá, bɛtɩ mʋ bɛɛ, “Yudafɔ Owíe, fʋ́ nkpasʋ ɔnlɩnsʋ!” Bɔtswɩ opé! ");
INSERT INTO nkoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɩnʋ bɔpʋ oyí sísi mʋ nwuntɔ, tutúu atsʋnɔ́ wʋ́lɩ́ mʋ, dá akpawunu mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bɔbwɛ mʋ ahinlá tá á, bɔwɔɩ́ amʋ́ ligá pɛpɛ amʋ, yínkía mʋ onutó atadɩɛ wá mʋ, bɛkpa mʋ dálɩ bɛyɛ́da mʋ mántá oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Befia Kireneyin ɔkʋá bʋtɛtɩ́ mʋ Simon, ogyi Aleksandro mʋa Rufo ɔsɩ́. Otsú abú asɩ ɔbá, bɛka mʋ hɩ́ɛ́ bɛɛ, ɔsʋ́ra oyikpalíhɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mʋ́ʋ́ bɛkpa Yesu ya ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Golgota. Mʋ́ asɩ gyí, “Nwun Okokobi Otsiákpá.” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bɔpʋ afá kʋá ɩtɛba ɩwɩɔsɩn asɩ wá ntátɔ́ tin Yesu ɔnɔ́ bɛɛ onúu, támɛ omonu. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bɛda mʋ mántá oyikpalíhɛ amʋsʋ tá á, beye mʋ atadɩɛtɔ. Ɩnʋ bɔtswɩ abi pʋ́kɩ ɔhagyíɔha ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ɩbɔ́bwɛ fɛ́ nyankɩ dokwebátɔ́ bɛda mʋ mántá oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mʋ́ʋ́ bɔwanlɩ́n tɔ́á sʋá bʋdɛ mʋ da mántá oyikpalíhɛ amʋsʋ dɩ́nká mʋ awunso bɛɛ, “Yudafɔ Owíe.” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bɛda awikplu abanyɔ́ akʋ ɛ́ mántá nyikpalíhɛsʋ tsɩ́a mʋtɔ. Ɔkʋlɛ bʋ mʋ gyɔpɩsʋ, ɔkʋlɛ ɛ́ bʋ mʋ bɩnasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɩnʋ atsʋ́npʋ bɔkpʋkpʋ́ʋ nwuntɔ, blɩ́ mʋ ɩwɩ abususʋ bɛɛ, “Yɛ́ɛ fʋ́ fɛɛ, fɛ́talɩ́ bwíé Bulu ɔtswɛ́kpa amʋ, lápwɛ́ mʋ nkɛnsá owítɔ́ nɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hɔ fʋ́ ɩwɩ, afʋkplɩ tsu oyí ámʋsʋ akɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ amʋ ɛ́ bɔbwɛ mʋ ahinlá bɛɛ, “Ɔlɔhɔ ahá nkpa, támɛ ɔmɛtálɩ́ hɔ mʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nɩ́ mʋgyí Israelfɔ owíe, Kristo, (ɔhá ámʋ́ʋ́ Bulu lɛ́da mʋ ofúli) a, ɔkplɩ́ɩ tsu oyí ámʋsʋ awun, ahɔ mʋ gyi!” Ahá ámʋ́ʋ́ bɛda mántá oyísʋ́ mʋ gyɔpɩsʋ mʋ́a bɩnasʋ ámʋ ɛ́ bɔbwɛ mʋ ahinlá. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Brɛ́á dódúanyɔ lɛda á, owí lɛta ɔsʋlʋ́ʋ amʋsʋ fɛ́ɛ́ alɩɩ yɔ́fʋn ntʋ́pwɛ dɔsatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dɔsa ámʋtɔ a, Yesu lɔ́kplʋn kʋ́klʋ́kʋ́ʋ́, blɩ́ ɔbɛ́ɛ, “Eloi, Eloi, Lama Sabaktani?” Mʋ́ asɩ gyí, “Mɩ́ Bulu, mɩ́ Bulu, ntogyi sʋ́ fakpá mɩ́ ɔma?” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ahá amʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋtɔ akʋ bonu asʋ́n ánfɩ, bɛblɩ́ bɛɛ, “Mlɩnu, ɔdɛ Elia kpolí.” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɩnʋ amʋ́tɔ́ ɔkʋ lɛ́srɩ́ tsú ɔsapɔ, pʋ́dá ntá ɔdáɩtɔ, pʋ́yi oyísʋ́, tsú mʋ́ fʋ́a pʋ́tin mʋ ɔnɔ́ ɔbɛ́ɛ, onúu. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Mlɩlɩɩ akɩ bɛɛ, Elia ɔbɛ́ba bɛsɩɛɩ́ mʋ lɛ́ oyí ámʋsʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ɩnʋ Yesu lɔ́kplʋn kʋ́klʋ́kʋ́ʋ́, ɔlɛlɛ ɔŋɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɩnʋnʋ Bulu lɛ́balɩ́ tatiá bɔpʋká ɔtswɛ́kpa obu ámʋtɔ anyɔ, tsú awunso beyi asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Brɛ́á ɩsá akɔpʋ́ ɔhandɛá ɔlɩɩ́ Yesu ansɩ́tɔ́ ɔdɛkɩ́ɩ lówun alɩá Yesu lɛ́lɛ ɔŋɛ́ tráhɛ a, ɔlɛblɩ́ ɔbɛ́ɛ “Lɛ́lɛ́, Bulu mʋ Bi oyin ánfɩ gyí!” ");
INSERT INTO nkoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Atsɩ akʋ ɛ́ bʋlɩɩ́ ɩfʋ́ntɔ́ bʋdɛkɩ́ɩ sɩsɩ́. Amʋ́tɔ́ akʋ gyí, Magdalayintse Maria, Salome pʋ́ Maria ánɩ́ ɔlɔkwɩɩ́ Yakobo mʋa mʋ gyama Yosef. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amʋ́ ɛ́ betsiá buo Yesu, tsíá kɩ mʋsʋ brɛ́á ɔbʋ Galilea. Atsɩ tsɔtsɔɔtsɔ akʋá bobuo mʋ ba Yerusalem ɛ́ bʋbʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɛkɛ ámʋ igyi ɛkɛá Yudafɔ bʋtɔpʋ́lá ɩwɩ asa bʋtegyi amʋ́ ɔkpʋ́nʋ́ ɔdakɛ́. Brɛ́á owí dɛpɔ́ɔn a, ");
INSERT INTO nkoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimateayin Yosef lɔ́wa ɩklʋn yɔ́ Pilato wá yɔ́kʋlɩ́ mʋ ɔbɛ́ɛ, osíi Yesu fúli ha mʋ amʋpula. Yudafɔ asʋ́n ogyípʋ́ ogyi, bʋtobú mʋ. Mʋ ɛ́ ɔdɛ Bulu iwíegyí ámʋ ɔkpa kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ɩlɔwa Pilato wánwan ánɩ́ Yesu lawúna wu. Mʋ́ sʋ ɔlɛtɩ mʋ ɩsá akɔpʋ́ ɔhandɛ, fɩ́tɛ́ mʋ nɩ́ olowu ɩlawá ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Brɛ́á ɩsá akɔpʋ́ ɔhandɛ amʋ lótsulá mʋ́sʋ́ á, Pilato lési fúli amʋ há Yosef. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mʋ́ʋ́ Yosef lɔ́hɔ ɔhráda, ɔlɔyɔ yɛ́sɩɛɩ́ Yesu lɛ́ oyí ámʋsʋ, kɩ́klɩ mʋ wá ɔhráda ámʋtɔ, tsú mʋ yópulá ɔbɔ́ kʋá bɛda bʋtátɔ́, olemináa ibwi yíléyílé kʋ tin ɔbɔ́ ámʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdalayintse Maria mʋa Yosef mʋ yin Maria bowun Yesu opulákpá. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yudafɔ ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ ɩlɔtsʋn a, Magdalayintse Maria mʋa Yakobo mʋ yin Maria pʋ́ Salome bɔhɔ ofobí fánfán kʋ bɛɛ, bɛyɛ́kpa Yesu fúli amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kwasieda nyankɩ, brɛ́á owí lopwié a, bɔyɔ Yesu opulákpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Brɛ́á bʋna ɔkpatɔ á, amʋ́ wʋlɛwʋlɛ bʋdɛ aba fɩtɛ́ bɛɛ, “Ma abénya obémináa ibwi ámʋ lɛ́ ɔbɔ́ ámʋ ɔnɔ́ há anɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Botsu ansɩ́ kɩ a, bamína ibwi ámʋ lɛ́ ɔbɔ́ ámʋ ɔnɔ́ dodo. Ibwi ámʋ lɛ́hɩɛ móní. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Brɛ́á bebitíwíé ɔbɔ́ ámʋtɔ á, bowun ánɩ́ ɔyasubi ɔkʋ lɔ́wa ligá futútúútú, otsie ɔbɔ́ ámʋ gyɔpɩsʋ. Ifú lɛkɩtá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɔyasubi ámʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmánya ifú. Nawun ánɩ́ Yesu Nasaretyin amʋ́ʋ́ bɛda mántá oyikpalíhɛsʋ ámʋ mlɩdédunká. Bulu lakʋ́sʋ́a mʋ, ɔma nfɩ. Mlɩkɩ ɔtɩ́nɛ́ ámʋ́ʋ́ bopulá mʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mlɩyɛbláa mʋ akasɩ́pʋ́ amʋ pʋ́ Petro mlɩaa, alagya mlɩ nkpá ɔyɔ́ Galilea ɔmátɔ́. Ɩnʋ́ mlówun mʋ fɛ́ alɩ ámʋ́ʋ́ ɔlɛbláa mlɩ ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɩnʋ bɛsrɩ́ dalɩ ɔbɔ́ ámʋtɔ, tsúfɛ́ opúni letsií amʋ́, ɔnɔ́ ɛ́ lobwie amʋ́. Mʋ́ sʋ brɛ́á bɔyɔ á, bʋmɛbláa ɔhaa, tsúfɛ́ ifú dɛ amʋ́, bʋdɛkpɩnkɩ́ kpakpakpakpa. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kwasieda bakɛ, brɛ́á Yesu lɔ́kʋsʋ́ tsú afúlitɔ á, olegyankpá lɛ́ ɩwɩ ɔwan súná Magdalayintse Maria amʋ́ʋ́ olegya ɔŋɛ laláhɛ asienɔ́ lɛ́ mʋtɔ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mʋ ɛ́ ɔlɛyɛ́bláa Yesu abúopʋ amʋ́ʋ́ bʋdɛ mʋ sú, bʋdɛ awɩrɛhɔ gyí amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Támɛ brɛ́á ɔlɛbláa amʋ́ ɔbɛ́ɛ, Yesu lakʋ́sʋ́, mawun mʋ a, bʋmohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɩ́nɩ ɔma a, Yesu lɛ́lɛ ɩwɩ ɔwan ɔkpa bámbásʋ́ súná mʋ abúopʋ abanyɔ́ brɛ́á bʋna bɔyɔ́ akuda, támɛ bʋmɔkɔsɩ́ bɩ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Amʋ́ ɛ́ beyinkí yɛ́bláa atráhɛ amʋ, támɛ amʋ́ ɛ́ bʋmohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɩ́nɩ fɛ́ɛ́ ɔma a, Yesu lɛ́lɛ ɩwɩ ɔwan súná mʋ akasɩ́pʋ́ dúɔkʋn ámʋ brɛ́á bʋdɛ atɔ́ gyí. Amʋ́ klʋntɔ-odwin pʋ́ amʋ́ máhógyi sʋ ɔlɔwa ɩyɩn wá amʋ́. Tsúfɛ́ bʋmɔhɔ ahá ámʋ́ʋ́ bowun mʋ mʋ kʋsʋ́ tsú afúlitɔ ɔma amʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ ɔyɩ́tɔ́ fɛ́ɛ́, amlɩyɛda Bulu asʋn wankláán ámʋ ɔkan ha ahá fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɔha ánɩ́ olohogyi, bɔbɔ mʋ asú á, Bulu ɔbɔ́hɔ mʋ nkpa, támɛ ɔhá ánɩ́ omohogyi obégyi pɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Osúna anfɩ obóbuo ahá ánɩ́ bohogyi nɩ. Bégya ɔŋɛ laláhɛ mɩ́ ɩdátɔ́, bɛ́blɩ́ ɔblɩ́ɩ bámbá, ");
INSERT INTO nkoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bɛ́kɩtá awɔ ɩbɩtɔ, bónu afá ánɩ́ ɩtɔmɔ́ kugyíkʋ, támɛ ɩmɔ́ɔbwɛ amʋ́ tɔtɔ. Bɔ́pʋ ɩbɩ dɩ́nká alɔpʋsʋ, ɩwɩ bɔ́wa amʋ́ ɔnlɩn.” ");
INSERT INTO nkoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Brɛ́á anɩ Wíe Yesu lɛ́bláa amʋ́ asʋ́n tá á, Bulu lótsu mʋ ya ɔsʋ́sʋ́, oleyétsiá mʋ gyɔpɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mʋ akasɩ́pʋ́ amʋ befi asɩ bʋdɛ asʋ́n ámʋ ɔkan da ɔtɩ́nɛgyíɔtɩ́nɛ́. Anɩ Wíe Yesu lɛ́lɩɩ́ amʋ́ ɔma bɔyɔ agyʋ́má. Ɔlɔtsʋn osúna ánɩ́ bɔbwɛsʋ, wá asʋ́n ámʋ ɔwʋnlɩ́n.");
INSERT INTO nkoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Onumnyampʋ Tiofilo: Ahá tsɔtsɔɔtsɔ babɔ́ mbɔ́dɩ́ wanlɩ́n tɔ́á ɩlɛba anɩtɔ tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bɔwanlɩ́n tɔ́á ahá ámʋ́ʋ́ bʋbʋ ɩnʋ tsú mʋ́ nfiasɩ́, bʋgyi mʋ́ asúmpʋ́ amʋ bowun, dá mʋ́ ɔkan amʋ bɛbláa anɩ pɛ́pɛ́ɛ́pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Onumnyampʋ Tiofilo, mɩ́ ɛ́ nabɔ́ mbɔ́dɩ́ kwí mʋ́tɔ́ wankláán tsú mʋ́ nfiasɩ́. Mʋ́ sʋ ndekléá nɔ́wanlɩ́n mʋ́ pɛ́pɛ́ɛ́pɛ́ há fʋ́, ");
INSERT INTO nkoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mɛ́nɩ fɛ́bɩá atɔ́ ámʋ́ʋ́ basúná fʋ́ ámʋ igyi ɔnɔkwalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Brɛ́á Herode dɛ́ iwíe gyí Yudea ɔmátɔ́ á, Bulu igyí ɔhapʋ́ ɔkʋ létsiá, bʋtɛtɩ́ mʋ Sakaria. Otsú Bulu igyí ahapʋ́ ɔpasua kʋá bʋtɛtɩ́ mʋ́ Abiatɔ. Mʋ ka gyí Elisabet, otsú Bulu igyí ɔhapʋ́ Aaron abí-anátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mʋa mʋ ka asʋ́n da ɔkpa Bulu ansɩ́tɔ́. Bʋtegyi anɩ Wíe Bulu mbla pʋ́ mʋ nhɩhɩɛ́ fɛ́ɛ́sʋ́ pɛ́pɛ́ɛ́pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bʋma obí, tsúfɛ́ Elisabet mégyí ɔtsɩ kwɩ́ɩ́pʋ́. Mʋa mʋ kulu fɛ́ɛ́ bahɩ́ɛ́ dan. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɛkɛ ɔkʋ ɩlɔtʋ Sakaria aná ɔpasua ánɩ́ amʋ́ ɔbɛ́ha Bulu igyí. Sakaria lɔ́yɔ ɔbʋ Bulu ansɩ́tɔ́ ɔdɛ mʋ agyʋ́má yɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Abi bʋtɔtswɩ pʋlɛ́ ɔhá ánɩ́ obébitíwíe Ɔwankɩ́kpá ɩnʋ yɔ́wa ɔhɩ́ɛ́n ogyá, igyí ahapʋ́ ámʋ amándɩ́ɛ́ ɔnɔ́. Bɔtswɩ a, ileyi Sakariasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Brɛ́á ɔdɛ ɔhɩ́ɛ́n ámʋ ogyá wa á, ɔdɔm ánɩ́ bɔyɔ ɔtswɛ́kpa ɩnʋ fɛ́ɛ́ bʋlɩɩ́ kpankpá bʋdɛ mpáɩ bɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bulu-ɔbɔpʋ ɔkʋ lɛ́bɛlɩɩ́ afɔdɩɛ-asubwi ámʋ gyɔpɩsʋ, lɛ́ ɩwɩ ɔwan súná Sakaria. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Brɛ́á olowun Bulu-ɔbɔpʋ amʋ a, ɔlɔwan, ifú lowie mʋ ayetɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɩnʋ Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Sakaria, mánya ifú! Bulu lanú fʋ́ isú. Fʋ́ ká obénya ɔmɛ́ kwɩ́ɩ́ obi yinhɛ́ há fʋ́. Dɩnka mʋ dá ‘Yohane.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Obí ánfɩ kwɩɩ́ bɔ́wa mlɩ ɔdwɛ, wá mlɩ ansigyí. Ɩbɔ́wa ahá tsɔtsɔɔtsɔ ɛ́ ansigyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tsúfɛ́ kebi ámʋ ɔbɔ́bwɛ ɔha kpɔnkpɔntɩ Bulu ansɩ́tɔ́. Nta bʋhɛ́ kʋkʋ máda mʋ ɔnɔ́ ɛkɛkɛɛkɛ. Ɔŋɛ Wankɩ́hɛ́ ɔbɔ́bʋlá mʋtɔ tsú brɛ́á ɔbʋ mʋ yin ɩwɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔbɛ́ha Israelfɔ tsɔtsɔɔtsɔ bɛ́damlí klʋntɔ ba amʋ́ Wíe Bulu wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Elia túmi pʋ́ mʋ ɔŋɛ́ bétsiá mʋtɔ. Obégya anɩ Wíe nkpá bá. Ɔbɛ́ha abí asɩ́ bɔ́dwɛ amʋ́ abí, ɔbɛ́damlí ahá ánɩ́ bʋtɔkʋ́sʋ́ lɩ́ɩ́ Bulusʋ agywɩɩn, ɩbwɛ fɛ́ yilé abwɛpʋ́ klɛ́, mɛ́nɩ ɔbɛ́la ahá yáɩ́ wankláán há anɩ Wíe.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria lɛ́fɩtɛ́ Bulu-ɔbɔpʋ amʋ ɔbɛ́ɛ, “Ntɔ nɔ́pʋbɩ́ ánɩ́ asʋ́n ánfɩ ɩbɛ́ba mʋ́tɔ́? Tsúfɛ́ mɩ́a mɩ́ ká anɩlapɔn.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɩnʋ Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ dá gyí Gabriel. Bulu ansɩ́tɔ́ ɔlɩɩ́pʋ́ ngyi. Mʋláwá mɩ́ ɔbɛ́ɛ, mbɛ́bláa fʋ asʋn wankláán ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tsú ndɛ pʋ́ya ɛkɛá asʋ́n ánfɩ ɩbɛ́ba mʋ́tɔ́ á, fɔ́tɔ omúmu, tsúfɛ́ fʋmɔhɔ mɩ́ asʋn blɩ́hɛ́ anfɩ́ ɩbɛ́ba mʋ́ brɛ́tɔ́ anfɩsʋ gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ɩlɔbwɛ alɩ á, ɩmɔwánkɩ́ ahá ámʋ́ʋ́ bʋlɩɩ́ bʋgyo Sakaria amʋ tɔ́á sʋá alawá ɔpá ɔtswɛ́kpa obutótɔ́ ɩnʋ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Brɛ́á ɔlɛdalɩ ba a, alatɔ́ omúmu. Mʋ́ sʋ bowun ánɩ́ alawun tɔkʋ obutótɔ́ ɩnʋ. Ɩ́nɩá ɔmɛtálɩ́ tɔ́ɩ́ sʋ á, ɔlɔpʋ mʋ ɩbɩ mʋ́a mʋ nwun bláa amʋ́ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaria létsiá ɔtswɛ́kpa ɩnʋ yɔ́fʋn ɛkɛá ɔlɛha Bulu igyí tá, oleyinkí yɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nkɛ ámʋ ɔma a, Elisabet lénya ɔmɛ́, tsíá ŋáín ɩwɩ alɩɩ tsra anu kɛ́kɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet lɛ́blɩ́ ɔbɛ́ɛ, “Ɩ́nɩ mɩ́ Wíe Bulu labwɛ́ há mɩ́ nɩ́. Alawun mɩ́ nwɛ, dɩ́nkɩ́ nsʋ́pa lɛ́ mɩ́sʋ́ ahátɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Brɛ́á Elisabet ɔmɛ́ lɔhɔ tsra asie á, Bulu lɔ́wa mʋ ɔbɔpʋ Gabriel wúlu kʋá ɩbʋ Galilea ɔmátɔ́, bʋtɛtɩ́ mʋ́ Nasaret. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bulu lɔ́wa mʋ obitebí ɔkʋá ɔmɔkʋ́dɩ́ oyin wá kɩ, bʋtɛtɩ́ mʋ Maria wá. Alɩ brɛ́ ámʋtɔ bʋdɛpʋ obitebí ámʋ há oyin ɔkʋá bʋtɛtɩ́ mʋ Yosef, ogyi owíe Dawid mʋ na bɛɛ otsía. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bulu-ɔbɔpʋ amʋ lɛ́ba Maria wóyítɔ́ bɛha mʋ itsiá, bláa mʋ ɔbɛ́ɛ, “Bulu lagyi fʋ bʋalɛ, alahɩ́ɛ́ yúlá fʋ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Asʋ́n ánfɩ lɛha Maria légyigyáa, ɔlɛfɩtɛ́ mʋ ɩwɩ ɔbɛ́ɛ, “Ngya ntɔ itsiá odu ɔhá ánfɩ lahá mɩ́ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Maria, mánya ifú. Bulu lahɩ́ɛ́ yúlá fʋ́! ");
INSERT INTO nkoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kɩ, fénya ɔmɛ́ kwɩ́ɩ́ obi yinhɛ́. Dɩnka mʋ dá ‘Yesu.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔbɔ́bwɛ ɔha yilé. Bɛ́tɩ mʋ Ɔsʋ́sʋ́ʋ́sʋ́ Bulu mʋ Bi. Anɩ Wíe Bulu ɔbɛ́yaɩ́ mʋ mʋ nain Owíe Dawid obíásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Obégyi iwíe Yakob wóyísʋ́ brɛ́ fɛ́ɛ́tɔ́. Mʋ iwíegyí mɔ́ɔmɔ ɔnɔ́ ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria lɛ́fɩtɛ́ Bulu-ɔbɔpʋ amʋ ɔbɛ́ɛ, “Nkálɩ ɩbɔ́bwɛ asa ɩ́nɩ ɩbɛ́ba mʋ́tɔ́, tsúfɛ́ mmeyín oyin.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bulu-ɔbɔpʋ amʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔŋɛ Wankɩ́hɛ́ ɔbɛ́ba fʋsʋ. Ɔsʋ́sʋ́ʋ́sʋ́ Bulu ámʋ túmi bóbun fʋsʋ. Ɩ́nɩ sʋ ahá bɛ́tɩ Obi wankɩ́hɛ́ amʋ́ʋ́ fɔ́kwɩɩ́ ámʋ bɛɛ, ‘Bulu mʋ Bi.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kɩ, fʋ́ obusuanyin Elisabet kʋ́ráá ɔbá bɔkwɩɩ́ obi yinhɛ́ mʋ tsɩdɛhɛn anfɩtɔ. Ahá bɛɛ, megyí ɔtsɩ kwɩ́ɩ́pʋ́ ogyi, támɛ mʋ ɔmɛ́ lahɔ tsra asie dodo. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsúfɛ́ tɔtɔ mɔdʋ́n Bulu bwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɩnʋ Maria lɛ́bláa Bulu-ɔbɔpʋ amʋ ɔbɛ́ɛ, “Bulu osúmbi ngyi. Ɩbá mʋ́tɔ́ ha mɩ fɛ́ alɩá fablɩ́.” Ɩnʋ á, Bulu-ɔbɔpʋ amʋ lɛ́natɩ́ sí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nkɛ ámʋtɔ á, Maria lɔ́kʋlá atɔ́, wa ɔsa yɔ́ Yudea abʋsʋ wúlu kʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mʋ́ʋ́ olowie Sakaria wóyítɔ́ há Elisabet itsiá. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet lénya nú itsiá ámʋ alɩ́ kebi ámʋ lɛ́kan ɩwɩ mʋ ɩwɩtɔ, Ɔŋɛ Wankɩ́hɛ́ lɔbʋlá mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ɩnʋ ɔlɔkplʋ́n blɩ́ ɔbɛ́ɛ, “Bulu layúlá fʋ́ atsɩ fɛ́ɛ́tɔ́. Alayúlá fʋ́ ɩwɩtɔ obí ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iyé! Mɩ́ Wíe mʋ yin onutó lába mɩ́ wá á? Ntogyi sʋ́ Bulu lawá mɩ́ numnyam anfɩ odu? ");
INSERT INTO nkoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kɩ, nenyanú fʋ́ itsiá ámʋ alɩ obí ámʋ́ʋ́ ɔbʋ mɩ́ ɩwɩtɔ ámʋ lɛ́kan ɩwɩ ansigyísʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bulu layúlá fʋ́, tsúfɛ́ fahogyi ánɩ́ tɔ́á alahɩ́ɛ́ há fʋ́ ɩbɛ́ba mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɩnʋ Maria lɔ́wa ɩlʋ ɔbɛ́ɛ, “Mɩ́ ɔkláa dɛ́ mɩ́ Wíe Bulu kanfʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mɩ́ Nkpa Ɔhɔ́pʋ Bulu lahá ansɩ́ dɛ mɩ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tsúfɛ́ alakáɩ́n mɩ́ mʋ osúmbi ánɩ́ ɔma tɔtɔ bwɛtɔ́sʋ́, wun mɩ nwɛ. Tsú séi pʋ́ya a, abí-aná fɛ́ɛ́ bɛ́blɩ́ bɛɛ, Bulu layúlá mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bulu Otúmípʋ amʋ labwɛ́ atɔ́ kpɔnkpɔntɩ há mɩ́. Ɔlɔwankɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Otowun ɩlɩ́n kugyíkʋtɔ ahá ánɩ́ bʋtenyá mʋ ifú nwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Alapʋ́ mʋ túmi bwɛ́ atɔ́ akpɔnkpɔntɩ, pʋ́dá ɩwɩ atsupʋ́ nwuntɔ asʋ́n sáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Alakplɩ́ awíe mbíásʋ́, tsú ahá ánɩ́ bʋma tɔtɔ bwɛtɔ́ fʋ́á. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Alahá ahiánfɔ bamlí ɩwɩ anyapʋ́, há ɩwɩ anyapʋ́ banátɩ́ ɩbɩkpan. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Alakpá mʋ asúmpʋ́ Israelfɔ. Ɔmɛtan ánɩ́ ɔlɛblɩ́ ɔbɛ́ɛ, mówun anɩ anáin Abraham mʋa mʋ abí-aná nwɛ brɛ́ fɛ́ɛ́, fɛ́ alɩá ɔlɛbláa amʋ́.” Alɩ Maria lɔ́mɔ mʋ ɩlʋ ámʋ ɔnɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oletsiá Elisabet wá fɛ́ tsra asa asa oleyinkí yɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Brɛ́á Elisabet lɔ́bɔkwɩɩ́ á, ɔlɔkwɩɩ́ obi yinhɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mʋ abusuanfɔ pʋ́ mʋ aba bonu ánɩ́ anɩ Wíe Bulu lahɩ́ɛ́ wun mʋ nwɛ. Mʋ́ sʋ ansɩ́ légyi amʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Obí ámʋ lénya ndawɔ́tswɩ́ á, mʋ ɩwɩsʋ ahá bɛba mʋ obuto ɔlɛkpá, abʋtɩn mʋ keté, dɩnka mʋ dá. Tɛkɩ bɛɛ abʋpʋ mʋ sɩ dá Sakaria dɩnka mʋ, ");
INSERT INTO nkoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","támɛ mʋ yin lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ó-o! Mlɩdɩnka mʋ Yohane.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ahá ámʋ bɛbláa mʋ bɛɛ, “Anɩmɔ́kʋ́nú abʋtɩ fʋ́ obusuanyin ɔkʋkʋ alɩ kɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɩnʋ bɔbwɛ mʋ sɩ ɩbɩ, fɩ́tɛ́ mʋ alɩá bʋtɩ́ɩ kebi ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria lɔ́bwɛ ɩbɩ ɔbɛ́ɛ bʋtsúu tɔkʋ ha mʋ amʋwanlɩn mʋ́ dɩnka mʋ́sʋ́, ɔlɔwanlɩ́n ɔbɛ́ɛ, “Mʋ dá gyí ‘Yohane.’ ” Ilofwie amʋ́ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɩnʋnʋ mʋ ɔdandʋ lɛsankɩ́, ɔlɔtɔɩ́ kánfʋ́ Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ifú lɛkɩtá apíó aba ámʋ fɛ́ɛ́. Alɩ asʋ́n ánfɩ lɛklɛɩ́ wá Yudea abʋsʋ awúlu amʋ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɔhagyíɔha ánɩ́ olonu asʋ́n ánfɩ lɛ́fɩtɛ́ mʋ ɩwɩ ɔbɛ́ɛ, “Ntɔ obí kebi ánfɩ ɔbɔ́bwɛ ɛkɛkʋ́?” Tsúfɛ́ ɩlɔwankɩ́ amʋ́ ánɩ́ Bulu ɩbɩ dɩ́n mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɩnʋ á, Ɔŋɛ Wankɩ́hɛ́ lɔbʋlá Sakariatɔ, ɔlɔwa asʋ́n ánɩ́ Bulu lapʋ́há mʋ blɩ́ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ɔbɛ́ɛ, “Mlɩha akanfʋ anɩ Wíe Israel Bulu. Tsúfɛ́ alabɛlɛ mʋ ahá, há anɩlagyi ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Alalɛ́ Ɔhɔ́pʋ Ɔwʋnlɩ́npʋ́ ɔkʋ tsú mʋ osúmpʋ́ Owíe Dawid abusuantɔ há anɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Fɛ́ alɩá ɔlɛblɩ́ tsʋn mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́ wankɩ́hɛ́ amʋsʋ tswɩ dodoodo.) ");
INSERT INTO nkoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ɔbɛ́ɛ, mɛ́lɛ anɩ tsú anɩ alupʋ́ pʋ́ ahá ánɩ́ bʋtamafia anɩ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ɔbɛ́ɛ, mówun anɩ anáin nwɛ. Ɔmɛ́ɛtan mʋ ntam wankɩ́hɛ́ amʋ́ʋ́ ɔlɛka há anɩ náin Abraham amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ɔbɛ́ɛ, mɛ́lɛ anɩ tsú anɩ alupʋ́ ɩbɩtɔ, mɛ́nɩ abɛ́talɩ́ súm mʋ, anɩméenya adʋ́n ifú. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ɔbɛ́ha abɔ́bwɛ mʋ ahá, bwɛ́ yilé mʋ ansɩ́sʋ́ anɩ nkpatɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mɩ́ bí, fʋ́ mʋ́ á, ahá bɛ́tɩ fʋ́ bɛɛ, ‘Ɔsʋ́sʋ́ʋ́sʋ́ Bulu ámʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́.’ Tsúfɛ́ fégya anɩ Wíe nkpá, lá ɔkpa há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fɛ́bláa mʋ ahá fɛɛ, Bulu ɔbɛ́talɩ́ hɔ amʋ́ nkpa tsʋn lakpansikíésʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anɩ Wíe Bulu nwewúun sʋ Kristo amʋ ɔbɛ́dalɩ fɛ́ owí tsú ɔsʋ́sʋ́ ba anɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ɔbɔ́wankɩ́ wʋ́lɩ́ ahá ámʋ́ʋ́ bʋtsie oklúntɔ pʋ́ lowu ɔkpasʋ ámʋ fɛ́ɛ́sʋ́. Ɔbɛ́kpa anɩ tsʋn iwilwii ɔkpasʋ.” Ɩ́nɩ Sakaria lɔ́pʋmɔ́ mʋ asʋ́n ɔnɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kebi ámʋ lɛ́dan, nya Ɔŋɛ́tɔ́ ɔwʋnlɩ́n. Oletsiá dimbísʋ́ alɩɩ yɔ́fʋn ɛkɛá ɔlɛlɛ ɩwɩ ɔwan súná Israelfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Alɩ brɛ́ ámʋtɔ á, Roma owíe dɛhɛn Augusto lɔ́wa mbla ɔbɛ́ɛ, bʋkláa ahá ánɩ́ bʋbʋ Romafɔ asɩ fɛ́ɛ́, abʋwanlɩn amʋ́ adá. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mʋ́gyí ahákla gyankpapʋ nɩ. Alɩ brɛ́ ámʋtɔ á, oyin ɔkʋá bʋtɛtɩ́ mʋ Kirenio dɛ́ Siria ɔmásʋ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɩ́nɩ sʋ ɔhagyíɔha lɔ́yɔ dá ɔwanlɩ́nkpá mʋ onutó wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosef ɛ́ lɔ́kʋsʋ́ tsú Nasaret wúlu ánɩ́ ɩbʋ Galilea ɔmátɔ́ dʋ́ yɔ́ Yudea ɔmátɔ́, Owíe Dawid wúlutɔ Betlehem. Tsúfɛ́ Owíe Dawid mʋ na ógyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mʋa Maria amʋ́ʋ́ bapʋ́há mʋ bɛɛ otsía, ɔna odwinsʋ ámʋ nyɔ lɔ́yɔ dá ámʋ ɔwanlɩ́nkpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Brɛ́á bʋbʋ Betlehem ɩnʋ á, ɩkwɩ́ɩ lɛkan Maria, ");
INSERT INTO nkoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ɔlɔkwɩɩ́ mʋ bitɩ́, ogyi oyin. Ɔlɛkɩklɩ́ɩ mʋ wá tatidatɔ, pʋ́ mʋ tswɩ mbwɩ atogyihɛ dákatɔ, tsúfɛ́ bʋmenya otsiákpá afɔɔ́ ɔswɩɩ́kpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Alɩ brɛ́ ámʋtɔ á, akúfa akpapʋ́ akʋ bʋbʋ ɩnʋ fʋ́n dimbítɔ́, bʋdɛ amʋ́ akúfa ɩwɩ gyo onyé. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bulu-ɔbɔpʋ lɛ́lɛ ɩwɩ ɔwan súná amʋ́, Bulu numnyam lɔ́wankɩ́ wʋ́lɩ́ amʋ́sʋ́. Mʋ́ sʋ ifú lɛhɩɛ kɩ́tá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ɩnʋ á, Bulu-ɔbɔpʋ amʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmánya ifú! Mlɩkɩ, napʋ́ asʋn wankláán ánɩ́ ɩbɔ́wa mlɩa ɔyɩ́tɔ́ ahá fɛ́ɛ́ ansigyí ba mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ndɛ bakwɩ́ɩ́ nkpa Ɔhɔ́pʋ, anɩ Wíe Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) há mlɩ Owíe Dawid wúlutɔ! ");
INSERT INTO nkoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tɔ́á mlɔ́pʋbɩ́ mʋ gyí, mlówun kebi bɔbwɛ ɔkʋá bapʋ́ tatida kɩ́klɩ mʋ ɩwɩ, ɔda mbwɩ atogyihɛ dákatɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɔtsáwʋlɛ pɛ́ á, Bulu-abɔpʋ tsɔtsɔɔtsɔ bɛba bɛtsɩá Bulu-ɔbɔpʋ amʋtɔ, bʋdɛ Bulu kanfʋ́ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mlɩha apʋ numnyam ha Buluá ɔbʋ ɔsʋ́sʋ́ʋ́sʋ́! Ɩwɩ ilwii ahá ánɩ́ Bulu ansɩ́ tegyi amʋ́ ɩwɩ ɔsʋlʋ́sʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Brɛ́á Bulu-abɔpʋ amʋ beyinkí yɔ́ ɔsʋ́sʋ́ á, akúfa akpapʋ́ ámʋ bɛbláa aba bɛɛ, “Mlɩha ayɔ Betlehem, ayɛkɩ ɩtɔ́ ánfɩ ɩlaba, Bulu lalɛ́ súná anɩ ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɩ́nɩ sʋ bɔwa ɔsa yɔ́. Lɛ́lɛ́ á, bowun Maria mʋa Yosef pʋ́ kebi bɔbwɛ amʋ, ɔda mbwɩ atogyihɛ dákatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Brɛ́á bowun kebi ámʋ a, bɛlɛ mʋ ɩwɩ asʋ́n ámʋ́ʋ́ bonu ámʋ blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Akúfa akpapʋ́ asʋ́n ánfɩ lɔ́wa ahá ánɩ́ bonu mʋ́ fɛ́ɛ́ wánwan. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Támɛ Maria mʋ́ lɛ́kɩtá asʋ́n ámʋ fɛ́ɛ́ wá nwuntɔ, tsíá gywɩɩ́n mʋ́ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Brɛ́á akúfa akpapʋ́ ámʋ beyinkí bɔyɔ́ á, bʋna bʋdɛ Bulu adábi da, kánfʋ́ mʋ, asʋ́n ámʋ́ʋ́ bonu pʋ́ ɩtɔ́ ámʋ́ʋ́ bayówun fɛ́ alɩ ámʋ́ʋ́ Bulu-ɔbɔpʋ amʋ lɛ́bláa amʋ́ ámʋ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kebi ámʋ obuto ɔlɛkɛ́ á, bɛtɩn mʋ keté, dɩ́nká mʋ dá Yesu. Ɩdá ánfɩ Bulu-ɔbɔpʋ amʋ lɛ́ha mʋ asa mʋ yin lénya mʋ ɔmɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Brɛ́á mʋ akwɩɩ́pʋ́ bɔ́gyʋráa ɩwɩ Mose Mbla ɔnɔ́ lɔfʋn a, bɔpʋ mʋ dʋ́ yɔ́ Yerusalem, pʋ́ mʋ yɔ́pʋ wá Bulu ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Tsúfɛ́ bɔwanlɩ́n wá Mose Mbla ámʋtɔ bɛɛ, “Ilehián ánɩ́ Israelfɔ bɔ́pʋ amʋ́ bitɩ́ okugyíɔkʋ há Bulu.”) ");
INSERT INTO nkoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mʋ́ sʋ bɔyɔ́bɔ afɔdɩɛ ámʋ Mbla ámʋ ɔnɔ́. Abrɔ́dʋma anyɔ ntɛ́ɛ aklobi anyɔ bɔpʋbɔ́ alɩ afɔdɩɛ ánfɩ há Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Alɩ brɛ́ ámʋtɔ á, oyin dɛhɛn ɔkʋ bʋ Yerusalem, bʋtɛtɩ́ mʋ Simeon. Yilé ɔbwɛpʋ́ ógyi, otenyá Bulu ifú. Ɔŋɛ Wankɩ́hɛ́ bʋ mʋsʋ, otsie ogyo brɛ́á Bulu ɔbɔ́pʋ Ɔlɛpʋ́ ba mʋ ahá Israelfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɔŋɛ Wankɩ́hɛ́ amʋ lɛ́lɛ súná mʋ ánɩ́ omóowu, yɔ́fʋn brɛ́á alawun Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) asa. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɔŋɛ Wankɩ́hɛ́ amʋ lɛ́ha Simeon lɔ́yɔ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́. Alɩ brɛ́ ámʋtɔ á, Yesu akwɩɩ́pʋ́ baba mʋ amándɩ́ɛ́ ánfɩ ɔbwɛkpá fɛ́ alɩá Mose Mbla ámʋ lɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ɩnʋ Simeon lɔ́hɔ kebi bɔbwɛ amʋ, ɔlɛkanfʋ́ Bulu ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mɩ́ Wíé! Asʋ́n ámʋ́ʋ́ fɛblɩ́ tswɩ amʋ ɩlaba mʋ́tɔ́. Séi mʋ́ á, mɩ́ fʋ́ osúmbi anfɩ nɛ́talɩ́ wú iwilwiitɔ ngya. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tsúfɛ́ mɩ́ onutó napʋ́ mɩ́ ansíbi wun Ɔlɛpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Fʋ́ onutó falá mʋ bwɛ́ ahá fɛ́ɛ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wankɩ ogyi, ɔbɛ́lɛ fʋ́ súná ahá ánɩ́ bʋmegyí Israelfɔ, pʋ́ numnyam ba fʋ́ ahá Israelfɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Asʋ́n ánfɩ Simeon lɛ́blɩ́ tsú kebi bɔbwɛ anfɩ ɩwɩ lɛha ɔnɔ́ lobwie mʋ akwɩɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon lóyulá amʋ́, ɔlɛbláa obí mʋ yin Maria ɔbɛ́ɛ, “Ɩna kebi ánfɩ sʋ Israelfɔ ɔfan bɛ́dɩda, ɔfan ɛ́ bɛ́lɩɩ́. Osúna ogyi tsú Bulusʋ, ahá bɔ́kʋsʋ́ lɩ́ɩ́ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɩ́nɩ sʋ Bulu ɔbɛ́ha ahá tsɔtsɔɔtsɔ klʋnsʋ asʋ́n bɛ́lɩn ɔwan. Fʋ́ ɛ́ á, awɩrɛhɔ bɛ́hɩɛ kɩ́tá fʋ́ klʋn. Ɩbɔ́hɔ fʋ ɔsɩn fɛ́ ɔdayí ɩya anyɔ bakpíé yi fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɔtsɩ dɛhɛn ɔkʋá ogyi Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɛ́ bʋ ɩnʋ. Mʋ dá gyí Hana. Mʋ sɩ gyí Fanuel, otsú Asa abusuantɔ. Ɔtsɩ dɛhɛn anfɩ mʋa mʋ kulu betsiá aba nfinsienɔ́, mʋ kulu lówu. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Olosu ɩsʋra alɩɩ bɔfʋn brɛ́á ɔlɔhɔ nfí adukwe-na (84). Ɔlɔpʋ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ mlí mʋ ɔdɩkpa, ɔdɛ Bulu súm, klɩ́ ɔnɔ́, bɔ́ mpáɩ ɔpa mʋ́a onyé. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mʋ ɛ́ ɔlɛdalɩ ba bɛkanfʋ́ Bulu, blɩ́ kebi bɔbwɛ amʋ ɩwɩ asʋ́n súná ahá ámʋ́ʋ́ bʋdɛ Yerusalemfɔ ɩwɩgyí ɔkpa kɩ́ɩ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Brɛ́á Yesu akwɩɩ́pʋ́ bɔbwɛ amándɩ́ɛ́ ámʋ tá Bulu mbla ámʋ ɔnɔ́ á, beyinkí kplɩ́ yɔ́ amʋ́ wúlutɔ Nasaret, Galilea ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kebi ámʋ lɛ́dan, nyá ɔwʋnlɩ́n, nyá nyánsa, Bulu ɛ́ lóyulá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu akwɩɩ́pʋ́ bʋtetsíá yɔ́ Yerusalem yégyi Israelfɔsʋ Katsʋn Nkɛ ofífígyíofí. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Brɛ́á Yesu lɔ́hɔ nfí dúanyɔ á, mʋa amʋ́nyɔ bɔyɔ nkɛ ámʋ ogyíkpá fɛ́ alɩá bʋtɔyɔ́ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Brɛ́á begyi nkɛ ámʋ tá beyinkí á, Yesu akwɩɩ́pʋ́ bʋmɛbɩ ánɩ́ alasin ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bʋkɩ bɛɛ mʋa mʋ abanyɔ ná. Mʋ́ sʋ bɛnatɩ́ ɛkɛwʋ́lɛ owítɔ́ asa bɔwa mʋ dunká apíó abatɔ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Brɛ́á bodunká mʋ kásíán á, beyinkí yɔ́ Yerusalem, yódunká mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ɛkɛ sáásɩ́ a, boyówotií mʋsʋ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ. Otsie Mose mbla asunápʋ́ wá, ɔdɛ asʋ yáa amʋ́ asʋ́ntɔ́, ɔdɛ amʋ́ asʋ́n fɩtɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɔnɔ́ lobwie ahá ánɩ́ bʋbʋ ɩnʋ fɛ́ɛ́, tsú alɩá ɔdɛ asʋ́n ámʋ asɩ nu pʋ́ alɩá ɔdɛ mʋ́ ɔnɔ́ lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ɔnɔ́ lobwie mʋ akwɩɩ́pʋ́ brɛ́á bowun mʋ. Mʋ yin lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ bí, ntogyi sʋ fabwɛ́ anɩ alɩ? Mɩ́a fʋ́ sɩ́nyɔ ansɩ́ lapɛ́ anɩdɛ́ fʋ́ dunká.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɩnʋ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ mlɩdɛ́ mɩ́ dunká? Ilehián ánɩ́ mlɛ́bɩ ánɩ́ mɩ́ Sɩ́ wóyítɔ́ nétsiá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Támɛ mʋ akwɩɩ́pʋ́ bʋmonu asʋ́n ánɩ́ ɔdɛ amʋ́ bláa asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mʋa amʋ́nyɔ beyinkí yɔ́ Nasaret, ɔlɛba ɩwɩasɩ há amʋ́. Maria lɛ́kɩtá asʋ́n ámʋ fɛ́ɛ́ wá kpawunutɔ, tsíá gywɩɩ́n mʋ́ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu lɛ́dan, wa ɔwʋnlɩ́n, nyá nyánsa, Bulu mʋ́a anyánkpʋ́sa fɛ́ɛ́ ansɩ́ legyi mʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Roma owíe dɛhɛn Tiberio iwíegyí ofí dúanusɩtɔ á, Bulu lɛ́bláa mʋ igyí ɔhapʋ́ Sakaria mʋ bi Yohane dimbísʋ́ ɔbɛ́ɛ, ɔdáa mʋ asʋ́n ɔkan. (Alɩ brɛ́ ámʋtɔ á, Pontio Pilato dɛ́ Yudea ɔmásʋ́ gyí. Herode dɛ́ Galilea ɔmásʋ́ gyí. Herode mʋ dɛhɛn Filipo ɛ́ dɛ́ Iturea pʋ́ Trakoniti ɔmásʋ́ gyí, Lisania ɛ́ dɛ́ Abilene ɔmásʋ́ gyí. Bulu igyí ahapʋ́ dɛhɛn ánɩ́ bʋbʋ ɩnʋ alɩ brɛ́ ámʋtɔ ɛ́ gyí Hana mʋa Kaiafa.) ");
INSERT INTO nkoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mʋ́ sʋ Yohane léki Yordan bʋnkpa ɔnɔ́, ɔdɛ ɔkan da blɩ́ ɔbɛ́ɛ, “Mlɩdamli klʋntɔ, amlɩsi lakpan bwɛ. Bulu osikie mlɩ, ambɔ mlɩ asú.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́Yesaia lɔ́wanlɩ́n Yohane ɩwɩ asʋ́n wá mʋ ɔwʋlʋ́tɔ́ ɔbɛ́ɛ, “Ɔkʋ dɛ́kplʋn dimbísʋ́ ɔbɛ́ɛ, ‘Mlɩla anɩ Wíe ɔkpa. Mlɩtswii ɩkpa ha mʋ! ");
INSERT INTO nkoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mlɩtin bʋnkpa kugyíkʋ, amlɩbwiebwie abʋ mʋ́a nkúku fɛ́ɛ́. Mlɩtswíi ɩkpa, amlɩla mʋ́sʋ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ahá fɛ́ɛ́ bówun Bulu nkpahɔ́ɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɔdɔm bɛba Yohane wá bɛɛ, ɔbɔ́ amʋ́ asú. Ɔlɛfɩtɛ́ amʋ ɔbɛ́ɛ, “Abɛ abí-aná, ntɔ gyá mlɩ, mlɩsrɩ́ Bulu ɩsʋbɩtɩ́ ámʋ́ʋ́ ɩbá ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mʋ́mʋ́ mlɩswie abí oduá ibósuná ánɩ́ lɛ́lɛ́ mlɩladámlí klʋntɔ. Mlɩmákɩ mlɩaa, mlɩ náin gyí Abraham. Ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́talɩ́ há abwi ánfɩ ɩbɛ́damlí Abraham abí-aná. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Séi á, Bulu lapʋ́ ɛfɛ́ yi nyí-atsitsitɔ. Oyígyíoyí ánɩ́ imoswie abi wankláán á, bókun mʋ́ dá, wá mʋ́ fɛ́ɛ́ ogyá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɔdɔm amʋ bɛfɩtɛ́ Yohane bɛɛ, “Ntɔ mɛɛ abwɛ́ɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohane lɛ́bláa amʋ́ ɔbɛ́ɛ, “Fʋ́á fʋbʋ atadɩɛ anyɔ á, pʋ kʋlɛ ha ɔhá ánɩ́ ɔma kʋkʋ. Fʋ́á fʋbʋ atogyihɛ ɛ́ bwɛ mʋ́ alɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lampóo ahɔ́pʋ akʋ ɛ́ bɛba asú ɔbɔkpá. Bɛfɩtɛ́ Yohane bɛɛ, “Osunápʋ́, ntɔ ilehián ánɩ́ abɔ́bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohane lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmátswɩ dɩnká ahá. Mlɩhɔ tɔ́á bɛɛ mlɩhɔ́ɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɩsá akɔpʋ́ akʋ ɛ́ bɛfɩtɛ́ Yohane bɛɛ, “Anɩ ɛ́ mɛ́, ntɔ abwɛ́ɛ?” Yohane lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmápʋ ɔwʋnlɩ́n swɩ́ɩ́ ɔhaa kɔ́ba, ntɛ́ɛ wá afunu dɩ́nká ɔhaasʋ. Mlɩ akatua igyí mlɩ ansɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɩ́nɩá amʋ́ ansɩ́ dɩn Kristo amʋsʋ, bʋdɛ mʋ ɔkpa kɩ́ɩ sʋ á, ɩmɔwánkɩ́ amʋ́ nɩ́ Yohane gyí Kristo amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mʋ́ sʋ Yohane lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔkʋá ɔdʋn mɩ bʋ ɔma ɔbá. Mmɔfʋn ánɩ́ nɛ́sankɩ́ mʋ ntʋkʋta ɔfɛ́ kʋ́ráá. Mɩ́ mʋ́ á, ntsu ndɛpʋbɔ́ mlɩ asú. Mʋ ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ pʋ́ ogyá bɔ́ mlɩ asú nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔdɛ mʋ ɩlɩ́n, ɔbɔ́pʋfúní ntɛ́tɛ lɛ́ ayó ámʋtɔ. Ɔbɛ́kpa ayó ámʋ wá mʋ odudutɔ. Támɛ ɔbɛ́fɛɩ́ ofuníkpá ɩnʋ wankláán, kpá ntɛ́tɛ amʋ wá ogyá ánɩ́ ɩtamaduntɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohane lɛ́da asʋn wankláán ámʋ ɔkan, bláa ahá ámʋ asʋ́n tsɔtsɔɔtsɔ ɔbɛ́ɛ, bʋdámli klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ɩsʋ ogyípʋ́ Herode laswɩɩ́ mʋ dɛhɛn Filipo mʋ ka Herodia tsía, trá bwɛ lalahɛ tsɔtsɔɔtsɔ tsɩ́a mʋ́tɔ́. Mʋ́ sʋ Yohane lékiná há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mʋ́á ɩdʋn kʋ́ráá gyí, Herode lɛ́ha bɛkɩtá Yohane wá obu. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Brɛ́á Yohane dɛ́ ahá ámʋ asú bɔ á, Yesu ɛ́ lɛ́ba, Yohane lɔ́bɔ mʋ asú. Brɛ́á Yesu dɛ́ mpáɩ bɔ á, nwʋlʋ́táa lefinkí, ");
INSERT INTO nkoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɔŋɛ Wankɩ́hɛ́ lɛ́damlí fɛ́ abrɔ́dʋma, kplɩ́ bogyonká mʋsʋ. Ɔmɛ kʋ lotsu ɔsʋ́sʋ́ ɔbɛ́ɛ, “Fʋ́gyí mɩ́ bíá ntɔdwɛ́, mɩ ansɩ́ tɛhɩ́ɛ́ gyi fʋ́ ɩwɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Brɛ́á Yesu lɔ́hɔ fɛ́ nfí adʋasa á, olefi Bulu asʋ́n ɔkanda asɩ. Ahá mʋ́ bʋyin ánɩ́ Yosef mʋ bi nɩ́. Yosef mʋ sɩ gyí Eli. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli mʋ sɩ gyí Martat. Martat mʋ sɩ gyí Lewi. Lewi mʋ sɩ gyí Melki. Melki mʋ sɩ gyí Yanai. Yanai mʋ sɩ gyí Yosef. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef mʋ sɩ gyí Martatia. Martatia mʋ sɩ gyí Amos. Amos mʋ sɩ gyí Nahum. Nahum mʋ sɩ gyí Hesli. Hesli mʋ sɩ gyí Nagai. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mʋ sɩ gyí Mahat. Mahat mʋ sɩ gyí Martatia. Martatia mʋ sɩ gyí Semein. Semein mʋ sɩ gyí Yosek. Yosek mʋ sɩ gyí Yoda. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mʋ sɩ gyí Yohanan. Yohanan mʋ sɩ gyí Resa. Resa mʋ sɩ gyí Serubabel. Serubabel mʋ sɩ gyí Sealtiel. Sealtiel mʋ sɩ gyí Neri. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mʋ sɩ gyí Melki. Melki mʋ sɩ gyí Adi. Adi mʋ sɩ gyí Kosam. Kosam mʋ sɩ gyí Elmadam. Elmadam mʋ sɩ gyí Er. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mʋ sɩ gyí Yosua. Yosua mʋ sɩ gyí Elieser. Elieser mʋ sɩ gyí Yorim. Yorim mʋ sɩ gyí Martat. Martat mʋ sɩ gyí Lewi. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi mʋ sɩ gyí Simeon. Simeon mʋ sɩ gyí Yuda. Yuda mʋ sɩ gyí Yosef. Yosef mʋ sɩ gyí Yonam. Yonam mʋ sɩ gyí Eliakim. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim mʋ sɩ gyí Melea. Melea mʋ sɩ gyí Mena. Mena mʋ sɩ gyí Martata. Martata mʋ sɩ gyí Natan. Natan mʋ sɩ gyí Owíe Dawid. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Owíe Dawid mʋ sɩ gyí Yisai. Yisai mʋ sɩ gyí Obed. Obed mʋ sɩ gyí Boas. Boas mʋ sɩ gyí Salmon. Salmon mʋ sɩ gyí Nahson. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahson mʋ sɩ gyí Aminadab. Aminadab mʋ sɩ gyí Admin. Admin mʋ sɩ gyí Arni. Arni mʋ sɩ gyí Hesron. Hesron mʋ sɩ gyí Peres. Peres mʋ sɩ gyí Yuda. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda mʋ sɩ gyí Yakob. Yakob mʋ sɩ gyí Isak. Isak mʋ sɩ gyí Abraham. Abraham mʋ sɩ gyí Tera. Tera mʋ sɩ gyí Nahor. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor mʋ sɩ gyí Serug. Serug mʋ sɩ gyí Reu. Reu mʋ sɩ gyí Peleg. Peleg mʋ sɩ gyí Eber. Eber mʋ sɩ gyí Sala. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mʋ sɩ gyí Kainan. Kainan mʋ sɩ gyí Arfaksad. Arfaksad mʋ sɩ gyí Sem. Sem mʋ sɩ gyí Noa, Noa ɛ́ mʋ sɩ gyí Lamek. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mʋ sɩ gyí Metusela. Metusela mʋ sɩ gyí Enok. Enok mʋ sɩ gyí Yared. Yared mʋ sɩ gyí Mehalaleel. Mehalaleel mʋ sɩ gyí Kenan. ");
INSERT INTO nkoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan mʋ sɩ gyí Enos. Enos mʋ sɩ gyí Set. Set mʋ sɩ gyí Adam. Adam ɛ́ mʋ sɩ gyí Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Brɛ́á Yesu léyinkí tsú Yordan ntsu ɔnɔ́ á, Ɔŋɛ Wankɩ́hɛ́ lɔbʋlá mʋtɔ, ɩlɛkpa mʋ ya dimbísʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Brɛ́á ɔbʋ ɩnʋ á, Ɔbʋnsám létsiá bɔsɔ mʋ kɩ nkɛ adʋana kɛ́kɛ́. Yesu mégyíi tɔtɔ nkɛ ámʋtɔ fɛ́ɛ́. Mʋ́ sʋ brɛ́á nkɛ ámʋ ɩlɔmɔ ɔnɔ́ á, akʋ́n hɩ́ɛ́ dɛ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɩnʋ Ɔbʋnsám lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ Bulu mʋ Bi fʋgyi á, mʋ́mʋ́ ha ibwi ánfɩ ɩdamli bodobodo.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Megyí atogyihɛ wʋlɛ nyankpʋsa ogyíi tsia nkpa.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ɔbʋnsám lɔ́pʋ mʋ ya ɩbʋ fʋ́áhɛ́ kʋsʋ. Olosuná mʋ ɔyɩ́tɔ́ iwíe ogyíkpá fɛ́ɛ́ ɔtsáwʋlɛ pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Nɔ́pʋ ɔmá ánfɩ fɛ́ɛ́ túmi pʋ́ amʋ́ numnyam há fʋ́, tsúfɛ́ mɩ́ ɩbɩtɔ bapʋ́wá. Ɔhá ánɩ́ ndeklé a, mʋ nɔ́pʋhá. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mʋ́ sʋ nɩ́ fosúm mɩ́ á, nɔ́pʋ mʋ́ fɛ́ɛ́ há fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Da akpawunu ha fʋ́ Wíe Bulu. Mʋ nkʋlɛ fʋ súm.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ɔbʋnsám lɛ́kpa mʋ ya Yerusalem, ɔlɔpʋ mʋ yɛ́lɩɩ́ Bulu ɔtswɛ́kpa obu ámʋ ɔtántra. Ɩnʋ ɔlɛbláa Yesu ɔbɛ́ɛ, “Nɩ́ Bulu mʋ Bi fʋ́gyi lɛ́lɛ́ á, tu kpayi. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Bulu ɔbɛ́ha mʋ abɔpʋ bɛ́kɩ fʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bɛ́kpatá fʋ́ ɩbɩtɔ, mɛ́nɩ fʋ́ yabi mɛ́ɛda ibwi kʋkʋsʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bɛtrá wanlɩ́n bɛɛ, ‘Mákapʋ́ fʋ́ Wíe Bulu kɩ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Brɛ́á Ɔbʋnsám lɔ́mɔ ɩsɔ́kɩ anfɩ fɛ́ɛ́ ɔnɔ́ á, ɔlɔkʋ nátɩ́ sí mʋ asa. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ɔŋɛ Wankɩ́hɛ́ túmi lɛkpa Yesu, oleyinkí yɔ́ Galilea ɔmátɔ́. Mʋ ɩwɩ asʋ́n lɛklɛɩ́ wa ɔmá ámʋ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Oletsiá súná atɔ́ Yudafɔ ofíakpa, ahá ámʋ fɛ́ɛ́ bɛkanfʋ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ɩnʋ Yesu léyinkí bá Nasaret, ɔtɩ́nɛ́á oletsiá dan. Fɛ́ alɩá otetsíá bwɛ́ á, ɔlɔyɔ Yudafɔ ofíakpa ɔkpʋ́nʋ́ ɔdakɛ́. Brɛ́á ɔlɔkʋsʋ́ yɛ́lɩɩ́ amʋ́ ansɩ́tɔ́ ɔbɛ́kla Bulu asʋ́n á, ");
INSERT INTO nkoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","botsu Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia ɔwʋlʋ́ há mʋ. Ɔlɛsankɩ́ mʋ́ á, olowun ɔtɩnɛkʋá bɔwanlɩ́n wá bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anɩ Wíe Bulu ladá mɩ́ ofúli. Ɩ́nɩ sʋ mʋ Ɔŋɛ́ bʋ mɩsʋ. Alalɛ́ mɩ́ ɔbɛ́ɛ, ndáa asʋn wankláán ámʋ ɔkan suna ahá ánɩ́ bʋma tɔtɔ. Ɔbɛ́ɛ, mbɛ́bláa nkpábi mbɛ́ɛ, masí amʋ́ ɩwɩ há amʋ́. Mɩ́ ambla ansibi abwiepʋ́ mbɛ́ɛ, mabwíí amʋ́ ansíbi. Ɔbɛ́ɛ mbɛ́bláa ahá ánɩ́ bʋdɛ amʋ́ ipiantɔ wa ɛ́ mbɛ́ɛ, malɛ́ amʋ́ ipiantɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Fówun mɩ́ amblɩ mbɛ́ɛ, anɩ Wíe ahá nwewúunbɩ lafʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ɩnʋ olokuntá ɔwʋlʋ́ ámʋ, yínkía ha mʋ́sʋ́ ɔkɩ́pʋ, ɔlɔwɔɩ́ tɩ́á asɩ. Ahá ámʋ́ʋ́ bʋbʋ ofíakpa ɩnʋ ámʋ fɛ́ɛ́ besi bʋdɛ mʋ kɩ́ɩ díín. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ndɛ, Bulu asʋn wanlɩ́nhɛ́ anfɩ laba mʋ́tɔ́. Mʋ́ mlɩlanú á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ahá ámʋ fɛ́ɛ́ bonu asʋn wankláán ámʋ́ʋ́ ɩlɛdalɩ mʋ ɔnɔ́ ámʋ. Ɔnɔ́ lobwie amʋ́, bɛfɩtɛ́ bɛɛ, “Megyí Yosef mʋ bi ámʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nyin ánɩ́ mlɛ́ha mɩ́ yébi anfɩ mlɩaa, ‘Ɩlɔ ɔtsapʋ́, tsa fʋ́ ɩwɩ!’ Mlɛ́labláa mɩ mlɩaa, ‘Bwɛ atɔ́ ámʋ́ʋ́ anɩlanú ánɩ́ fʋ́dɛbwɛ Kapernaum amʋ fʋ́ wúlutɔ nfɩ ɛ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɩnʋ oleyinkí bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Bʋtamahɔ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋkʋ asʋ́n mʋ wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Mlɩnu, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Elia bɩ́sʋ́ á, nyankpʋ mótswíe nfinsa mʋ́a ɩfʋn kɛ́kɛ́. Akʋ́n lɛhɩɛ ba Israel ɔmátɔ́ fɛ́ɛ́. Ɩbʋ mʋ́tɔ́ ánɩ́ asʋrapʋ tsɔtsɔɔtsɔ betsiá Israel ɔmátɔ́ alɩ brɛ́ ámʋtɔ, ");
INSERT INTO nkoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","támɛ Bulu mɛ́ha Elia ɔyɔ amʋ́tɔ́ ɔkʋkʋ wá. Ɔsʋrapʋ ɔkʋá ɔbʋ Sarefat wúlutɔ, Sidon ɔmátɔ́ nkʋlɛ wá ɔlɛha mʋ ɔlɔyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɩlɔ pɛpɛ alɔpʋ́ tsɔtsɔɔtsɔ ɛ́ betsiá Israel ɔmátɔ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Elisa bɩ́sʋ́. Támɛ ɔmɛha ɔkʋkʋ ɩwɩ mɛplɩ́, dʋn Naaman ánɩ́ otsú Siria nkʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ɔblɔ́ lɛhɩɛ kɩ́tá ahá ámʋ́ʋ́ bʋbʋ ofíakpa ɩnʋ ámʋ, brɛ́á bonu Yesu asʋn blɩ́hɛ́ anfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bɔkʋsʋ́ gya mʋ dálɩ amʋ́ wúlutɔ. Wúlu amʋ ɩdɩn bʋsʋ. Begya mʋ alɩɩ yówie wúlu amʋ ɔnɔ́, bɛɛ abʋwuta mʋ wa tsonkolitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yesu lɛ́natɩ́ tsʋn amʋ́tɔ́ yɔ́ ɔtɩ́nɛ́á ɔyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɩnʋ Yesu lɛ́kplɩ́ yɔ́ Kapernaum, Galilea wúlu kʋtɔ. Olosuná amʋ́ atɔ́ amʋ́ ofíakpa ɔkpʋ́nʋ́ ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mʋ atosunáhɛ́ lobwie amʋ́ ɔnɔ́, tsúfɛ́ olosuná amʋ́ atɔ́ túmisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oyin ɔkʋ bʋ ofíakpa ɩnʋ, ɔŋɛ laláhɛ bʋ mʋsʋ. Ɔlɔkplʋ́n blɩ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kɩ mɩ! Yesu Nasaretyin, amansʋ bʋ anɩa fʋnyɔ nsɩnɛ́? Ntɛ́ɛ anɩ ɔhɩkpá fɛbá lóó? Nyin ɔhá oduá fʋ́gyi. Fʋ́gyí Bulu Ɔha Wankɩ́hɛ́ amʋ nɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu lɔ́kplʋn wa ɔŋɛ́ ámʋ ɔbɛ́ɛ, “Kpa ɔnɔ́ bun, afʋdalɩ mʋtɔ.” Ɩnʋ ɔŋɛ laláhɛ amʋ lɛ́fɩn oyin ámʋ dá ahá ámʋtɔ ɩnʋ, dálɩ mʋtɔ. Tɔtɔ mɔbwɛ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɔnɔ́ lobwie amʋ́ fɛ́ɛ́, bɛfɩtɛ́ aba bɛɛ, “Amansʋ nɩ? Oyin ánfɩ bʋ túmi, ɔdɛkplʋ́n wa ɔŋɛ laláhɛ, ɩdɛ mʋ bu, dálɩ ahátɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mʋ ɩwɩ asʋ́n lɛklɛɩ́ wá ɔmá ámʋ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu lɛ́dalɩ Yudafɔ ofíakpa ɩnʋ yɔ́ Simon wóyítɔ́. Ɔlɔyɔ á, owísó lakɩ́tá Simon mʋ sia tsɩ́hɛ́, ɔda kínkíínkín. Bɛbláa Yesu bɛɛ, ogyíi mʋ bʋalɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu lɔ́kpʋkpɛ́ tʋ́ ɔtsɩ ámʋ, ɔlɔkplʋ́n wa owísó ámʋ ɔbɛ́ɛ, ɩkʋ́sʋ mʋsʋ. Ɩnʋnʋ ɩlɔkʋsʋ́ mʋsʋ, ɔtsɩ ámʋ lɔ́kʋsʋ́ bwɛ́ amʋ́ afɔɔ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Brɛ́á owí dɛta á, ahá bɔsʋrá amʋ́ ahá ánɩ́ bʋdɛ ɩlɔ ɔtsan-ɔtsan lɔ ba, Yesu lɔ́pʋ ɩbɩ dɩ́nká amʋ́sʋ́ tsá amʋ́tɔ́ okugyíɔkʋ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɔŋɛ laláhɛ bʋ amʋ́tɔ́ akʋtɔ. Yesu lɔ́kplʋn wa ɔŋɛ laláhɛ amʋ. Bɛdalɩ, bʋdɛ okitikíti bɛɛ, “Fʋ́gyí Bulu mʋ Bi ámʋ nɩ.” Támɛ Yesu lɔ́wa mbla wá ɔŋɛ laláhɛ amʋ ánɩ́ bʋmátɔɩ́, tsúfɛ́ bʋyin ánɩ́ mʋgyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mʋ́ ɔyɩ kɛhɛ bakɛ a, Yesu lɛ́dalɩ wúlu amʋtɔ yɔ́ ɩtsɛ́tɔ́ ɔtɩnɛkʋ. Ahá bodunká mʋ alɩɩ yɔ́tʋ mʋ, bokokóli mʋ bɛɛ ɔmánatɩ́ sí amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Támɛ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ilehián ánɩ́ nɛ́da Bulu iwíegyí ɩwɩ asʋn wankláán ámʋ ɔkan awúlu atráhɛ amʋ ɛ́sʋ́. Tsúfɛ́ mʋ́ ɔbwɛkpá Bulu lɔ́wa mɩ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɩ́nɩ sʋ oleki Yudea ɔmátɔ́ fɛ́ɛ́, dá Bulu asʋn wankláán amʋ ɔkan amʋ́ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɛkɛ ɔkʋ Yesu lɩ́ɩ́ Genesaret paatɩ ɔnɔ́, ahá tsɔtsɔɔtsɔ bɛba boputá mʋ ánɩ́ bónu Bulu asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Olowun nklʋn anyɔ paatɩ ámʋ ɔnɔ́. Aye alɛpʋ́ ámʋ bakplɩ́ yɔ́ bʋdɛ amʋ́ asawutɔ da. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu lɔ́dʋ wíé kʋlɛá igyi Simon klɛ́tɔ. Mʋ́ʋ́ ɔlɛbláa Simon ɔbɛ́ɛ, osún mʋ́ kpalobí dɩnka ntsusʋ. Ɩnʋ oletsiá mʋ́tɔ́ súná ahá ámʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Brɛ́á ɔlɔtɔɩ́ tá á, ɔlɛbláa Simon ɔbɛ́ɛ, “Mlɩpla ɔklʋn amʋ ya okluklúkpá, amlɩyɔtswɩ asawu lɛ aye.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mʋ́ʋ́ Simon lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, anɩlɔ́bwɛ kásíán ígye onyé fɛ́ɛ́, anɩménya tɔtɔ. Támɛ ɩ́nɩá fɛɛ ayɔ́, sʋ nɔ́yɔtswɩ asawu amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Brɛ́á bɔyɔ́tswɩ asawu amʋ a, bɛlɛ aye tsɔtsɔɔtsɔ. Mʋ́ sʋ asawu amʋ lɔ́wa tɩtɩ́ɩ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɩnʋ bɔbwɛ ɩbɩ tɩ́ amʋ́ agyʋ́má ayɔbá ámʋ́ʋ́ bʋbʋ ɔklʋn nyɔɔsɩtɔ ámʋ bɛɛ bʋbɛ́tsa amʋ́. Bɛba bɛtsa amʋ́, bɛlɛ aye amʋ bʋ́lá nklʋn anyɔ ámʋ dɛ́dɛ́ɛ́dɛ́, ideklé ɩmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Brɛ́á Simon Petro lówun mʋ́ alɩ á, ɔlɛda akpawunu Yesu ayabitɔ, bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, mákpʋkpɛ́ mantáa mɩ! Lakpan ɔbwɛpʋ́ ngyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tsúfɛ́ aye amʋ́ʋ́ balɛ́ ámʋ lɔwa mʋa mʋ aba ámʋ wánwan. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Alɩ kɛ́n ɩlɔwa Sebedeo abí Yakobo mʋa Yohane, bʋgyi Simon agyʋ́má ayɔbá ámʋ ɛ́ wánwan nɩ́. Mʋ́ʋ́ Yesu lɛ́bláa Simon ɔbɛ́ɛ, “Mánya ifú! Tsú ndɛ pʋ́ya a, anyánkpʋ́sa fɛ́lɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simon mʋa mʋ aba ámʋ benya plá nklʋn amʋ besi otsubúnɔ alɩ, besi tógyítɔ́ tswɩ, kplá buo Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɛkɛ ɔkʋ Yesu bʋ wúlu kʋsʋ, ɩlɔ pɛpɛ ɔlɔpʋ́ ɔkʋ lówun mʋ. Ɩnʋ ɔlɛbɛda akpawunu, pʋ́ ɔsʋkpɩ yi ɔsʋlʋ́tɔ, kókóli mʋ ɔbɛ́ɛ, “Owíé, nɩ́ fótsulá á, fɛ́talɩ́ há mɩ́ ɩwɩ bɛ́plɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu lɛ́tɩnkɩ́ ɩbɩ da mʋ, bláa mʋ ɔbɛ́ɛ, “Natsúlá, fʋ́ ɩwɩ ɩplɩ́ɩ.” Ɩnʋnʋ ɩlɔ ámʋ lɛ́ŋa lɛ mʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ɩnʋ Yesu lɛ́da mʋ ɔlá ɔbɛ́ɛ, “Mábla ɔhaa. Natɩ laa afʋpʋ fʋ́ ɩwɩ yosuná Bulu igyí ɔhapʋ́, afʋha mʋ ɩwɩgyʋrátɔ amʋ́ʋ́ Mose mbla losuná tsú ɩlɔ pɛpɛtsa ɩwɩ ámʋ. Igyi adánsɩɛ suna ahá ánɩ́ fʋ́ ɩwɩ laplɩ́ɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Támɛ Yesu ɩwɩ asʋ́n lɛ́trá klɛɩ́ yɔ́ ntɩ́nɛ́ dɩ́nká mʋ́sʋ́. Ɔdɔm bɛba mʋ atosunáhɛ́ onukpá, ɔtsa amʋ́tɔ́ alɔpʋ ɛ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Támɛ oletsiá dálɩ amʋ́tɔ́ brɛ́ kʋ yɔ́ dimbísʋ́ ɔtɩnɛkʋ mʋ nkʋlɛ yɔ́bɔ mpáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɛkɛ ɔkʋ Yesu dɛ́ atɔ́ suná. Farisifɔ, Mose mbla asunápʋ́ akʋá botsú Galilea pʋ́ Yudea ɔmátɔ́ pʋ́ Yerusalem bɛba betsiá asɩ ɩnʋ. Bulu túmi bʋ Yesutɔ há ɩlɔtsa. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɩnʋ á, ayin akʋ bɔsʋrá tsukʋlɛ osínpʋ akpasʋ ba. Bekleá bɔ́pʋ mʋ wíé wóyítɔ́, pʋ́ mʋ tswɩ Yesu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ɔdɔm amʋ sʋ bʋmenya ɔkpa. Ɩ́nɩ sʋ bɔyɔ́dʋ obu ámʋ awunso, dá mʋ́ ɔtɩnɛkʋ tíí, bɛkplɩ́a akpa amʋ tswɩ ahá ámʋtɔ Yesu ansɩ́tɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Brɛ́á Yesu lówun ánɩ́ bahɔ mʋ gyi a, ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, “Opíó, nasí fʋ́ lakpan kíé fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mose mbla asunápʋ́ pʋ́ Farisifɔ ámʋ bɛblɩ́ wá nwuntɔ bɛɛ, “Ma gyí oyin ánfɩ ɔdɛ abususʋ blɩ́ ánfɩ? Ma ɔbɛ́talɩ́ sí lakpan kíé ahá dʋn Bulu nkʋlɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ɩ́nɩ odu gywɩɩ́n? ");
INSERT INTO nkoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mɔmʋ lɔ́pɔn ha blɩ́? ‘Nasí fʋ́ lakpan kíé fʋ́.’ lóó, ntɛ́ɛ ‘Kʋsʋ tsu fʋ́ akpa afʋnatɩ?’ ");
INSERT INTO nkoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Támɛ ndekléá mlɩbɩ́ɩ ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mbʋ túmi ɔyɩ́ ánfɩtɔ sí ahá lakpan kíé amʋ́.” Ɩnʋ ɔlɛbláa tsukʋlɛ osínpʋ amʋ ɔbɛ́ɛ, “Ndɛ fʋ́ bláa mbɛ́ɛ, kʋsʋ. Tsu fʋ́ akpa afʋnatɩ yɔ wóyí!” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ɩnʋnʋʋnʋ tsukʋlɛ osínpʋ amʋ lɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ fɛ́ɛ́ ansɩ́tɔ́, tsú mʋ akpa, ɔlɔpʋ ɔkpa ɔyɔ́ wóyí ɔdɛ Bulu kanfʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɔnɔ́ lobwie ahá ámʋ fɛ́ɛ́. Ifú lowie amʋ́ fɛ́ɛ́tɔ́, bɛkanfʋ́ Bulu bɛɛ, “Ndɛ anɩlawun ofúla!” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mʋ́ ɔma brɛ́á Yesu lɛ́dalɩ ɩnʋ á, olowun lampóo ɔhɔ́pʋ ɔkʋá bʋtɛtɩ́ mʋ Lewi, tsie mʋ lampóo ɔhɔ́kpa. Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Bobuo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɩnʋ Lewi lɔ́kʋsʋ́, sí mʋ tógyítɔ́ ɔmagyáa, yóbuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mʋ́ ɔma a, Lewi lɔ́tswɩ ɔpʋ́nʋ́ mʋ wóyítɔ́ há Yesu. Lampóo ahɔ́pʋ tsɔtsɔɔtsɔ pʋ́ aha bambá ɛ́ bɛba atɔ́ ámʋ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisifɔ pʋ́ Mose mbla asunápʋ́ ánɩ́ bʋbʋ Farisifɔ ámʋtɔ bɛfɩtɛ́ Yesu akasɩ́pʋ́ amʋ bɛɛ, “Ntogyi sʋ́ mlɩa lampóo ahɔ́pʋ pʋ́ lakpan abwɛpʋ́ mlɩdɛ́ ɩbɩ wa gyi atɔ́, mlɩdɛ́ ntá nú?” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Alɔpʋ léhián ɩlɔ ɔtsapʋ́, megyí ahá ánɩ́ ɩwɩ bʋ amʋ́ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mmɛba aha wankláán ɔtɩkpá. Mboún lakpan abwɛpʋ́ ɔtɩkpá nɛba, mɛ́nɩ bɛ́damlí klʋntɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aha akʋ bɛbláa Yesu bɛɛ, “Asú Ɔbɔpʋ́ Yohane akasɩ́pʋ́ bʋtetsíá klɩ́ ɔnɔ́ bɔ́ mpáɩ. Farisifɔ akasɩ́pʋ́ ɛ́ bʋtɔbwɛ́ alɩ, támɛ fʋ́ akasɩ́pʋ́ mʋ́ bʋdegyí, bʋdenúu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ɔtsɩ ɔkpaɩ́npʋ́ anyawíe bɛ́klɩ́ ɔnɔ́ brɛ́á ɔbʋ amʋ́ wá? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Támɛ ɛkɛ ɔkʋ bɛ́ba ánɩ́ bɛ́kpa mʋ nátɩ́ sí amʋ́. Alɩ nkɛ ámʋtɔ bɛ́klɩ́ ɔnɔ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɩnʋ ɔlɛha amʋ́ yébi ɔbɛ́ɛ, “Ɔhaa tamapʋ́ tati pɔpwɛ tan tati dada. Nɩ́ ɔbwɛ́ mʋ́ alɩ á, alayíntá pɔpwɛ amʋ, pɔpwɛ amʋ pʋ́ dada amʋ ansɩ́ ɛ́ ɩmɛ́ɛkanáa aba. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Alɩ kɛ́n bʋtamapʋ́ nta pɔpwɛ wá ɔwʋlʋ́-kpákpá kɛntɛ wuhɛ́tɔ́ nɩ́. Nta pɔpwɛ amʋ ibófu fá kɛntɛ amʋ tsítsá, yíntá kɛntɛ amʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɩ́nɩ sʋ ɔwʋlʋ́-kpákpá kɛntɛ pɔpwɛtɔ bʋ́tɔpʋ́ nta pɔpwɛ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɔhaa tamafɩ́tɛ́ nta pɔpwɛsʋ brɛ́á alanu dánhɛ. Tsúfɛ́ ɔtɛblɩ́ ɔbɛ́ɛ, ‘Ɩdánhɛ amʋ bʋ alɛ́ dʋn.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu mʋa mʋ akasɩ́pʋ́ bɔtsʋn ayó ndɔ kʋtɔ ɔkpʋ́nʋ́ ɔdakɛ́. Mʋ akasɩ́pʋ́ amʋ bɔprʋ́ʋn atɔ́-abí ámʋ kʋ, bɔpʋsáa mʋ́ wɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisifɔ ámʋ akʋ bɛfɩtɛ́ amʋ́ bɛɛ, “Ntogyi sʋ́ mlɩdɛ́ tɔ́á anɩ mbla mɛha ɔkpa ánɩ́ bʋbwɛ́ɛ ɔkpʋ́nʋ́ ɔdakɛ́ bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩmɔ́kʋ́kla nu tɔ́á Owíe Dawid lɔ́bwɛ brɛ́á akʋ́n dɛ mʋa mʋ abúopʋ kɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Olebitíwíé Bulu osúmkpa yótsu bodobodoá bapʋ́há Bulu igyí ba, mʋa mʋ abúopʋ amʋ begyi. Bulu igyí ahapʋ́ nkʋlɛ bɛlɛ ɔkpa bʋ́tegyi alɩ bodobodo amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mʋ́ʋ́ Yesu ɔlɔmɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ gyí ɔkpʋ́nʋ́ ɔdakɛ́ mʋ wie.” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yesu lɔ́yɔ atɔ́ osunákpá Yudafɔ ofíakpaɔkpʋ́nʋ́ ɔdakɛ́ bámbá. Oyin ɔkʋá mʋ gyɔpɩ ɩbɩ lawú bʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mose mbla asunápʋ́ pʋ́ Farisifɔ akʋ bɛtɛ Yesu kɩ bɛɛ, ɔbɛ́tsa ɩlɔ ɔkpʋ́nʋ́ ɔdakɛ́, mɛ́nɩ bénya mʋ ɩwɩ asʋ́n, pʋ́yɛ́natɩ́ mʋsʋ súná ahandɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu yin amʋ́ nwuntɔ asʋ́n. Mʋ́ sʋ ɔlɛbláa oyin ámʋ́ʋ́ mʋ ɩbɩ kʋlɛ lawú ámʋ ɔbɛ́ɛ, “Kʋsʋ bɛlɩɩ́ amʋ́ ansɩ́tɔ́ nfɩ.” Ɩnʋ oyin ámʋ lɔ́kʋsʋ́ bɛlɩɩ́ amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ndɛ mlɩ fɩtɛ́, ntɔ mbla ámʋ lɛ́ha ɔkpa ánɩ́ abwɛ́ɛ ɔkpʋ́nʋ́ ɔdakɛ́? Yilé lóó, ntɛ́ɛ lalahɛ? Ahɔ́ɔ ɔha nkpa lóó, ntɛ́ɛ amɔ́ɔ mʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ɩnʋ ɔlɛdamlí kɩ amʋ́ fɛ́ɛ́ fíá. Mʋ́ʋ́ ɔlɛbláa oyin ámʋ ɔbɛ́ɛ, “Tɩnkɩ fʋ́ ɩbɩ amʋ.” Olenya tɩ́nkɩ́ ɩbɩ amʋ alɩ pɛ́, ɔŋɛ́ lowie mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɔblɔ́ lɛkɩtá amʋ́, bɛfɩtɛ́ aba bɛɛ, “Ntɔ kóún abɛ́hɩɛ bwɛ́ Yesu anfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ɛkɛ ɔkʋ Yesu lɔ́dʋ yɔ́ ɩbʋsʋ yɔ́bɔ mpáɩ há Bulu tsú onyé yɛ́ha ɔyɩ kɛhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mʋ́ ɔyɩ kɛhɛ a, ɔlɛtɩ mʋ akasɩ́pʋ́, ɔlɛlɛ amʋ́tɔ́ dúanyɔ, ɔlɛtɩ amʋ́ mʋ sumbí ayɔpʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Amʋ́gyí, Simon ánɩ́ ɔlɛdɩnká mʋ Petro mʋa mʋ pio Andrea; Yakobo mʋa Yohane; Filipo, Bartolomeo, ");
INSERT INTO nkoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Toma, Alfeo mʋ bi Yakobo, Simon ánɩ́ ogyi ɩwɩsʋtsiá adunkápʋ́ ɔpasuatɔ ɔha; ");
INSERT INTO nkoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakobo ɔkʋ mʋ bi Yuda pʋ́ Yuda Iskariot ánɩ́ ɔlɛbɛlɛ Yesu há. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu mʋa sumbí ayɔpʋ́ ámʋ bɛkplɩ́ tsú ɩbʋ ámʋsʋ ba ɔsʋlʋ́ʋ tantasʋ. Mʋ abúopʋ tsɔtsɔɔtsɔ pʋ́ ɔdɔm kpɔnkpɔɔnkpɔntɩá botsú Yudea ɔmátɔ́, Yerusalem pʋ́ ɔpʋ ɔnɔ́ awúlu Tiro mʋ́a Sidonsʋ bɛba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɛba bɛɛ bɛbá bonu mʋ asʋn blɩ́hɛ́, ɔtsa amʋ́ ɩlɔ. Ahá ánɩ́ ɔŋɛ laláhɛ dɛ amʋ́ háan ɛ́ bɛba, olegya ɔŋɛ laláhɛ lɛ́ amʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Amʋ́ fɛ́ɛ́ bekleá bɔ́pʋ ɩbɩ da mʋ, tsúfɛ́ ɔŋɛ́ dɛdalɩ mʋtɔ, ɔlɛtsa amʋ́ fɛ́ɛ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu lótsu ansɩ́ kɩ mʋ akasɩ́pʋ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Bulu layúlá mlɩá mlɩmá tɔtɔ, tsúfɛ́ mlɩbʋ́ mʋ iwíegyí amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bulu layúlá mlɩá akʋ́n dɛ mlɩ séi, tsúfɛ́ mlɛ́ba begyi mwɛ. Bulu layúlá mlɩá mlɩdésú séi, tsúfɛ́ mlɛ́ba bɔmɔsɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Bulu layúlá mlɩá bʋdɛ mlɩ lu, bʋdɛ mlɩ gyáa lɛ amʋ́tɔ́, síá mlɩ, tɩ́ mlɩ ɩda laláhɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ansɩ́ igyí mlɩ ɛkɛ ámʋ, amlɩfuli kpayi ansigyísʋ́, tsúfɛ́ mlɩ ɩkɔká tsɔ ɔsʋ́sʋ́. Alɩ́ amʋ́ anáin bɔbwɛ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Támɛ mlɩ ánɩ́ mlɩlanyá ɩwɩ séi, mlɩgyɔwɩ nɩ́. Tsúfɛ́ mlɩ ansigyí fɛ́ɛ́ mlɩlanyá á. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mlɩ ánɩ́ mlɩlamwɛ́ séi, mlɩgyɔwɩ nɩ́. Tsúfɛ́ akʋ́n bɛ́ba bɛkɩtá mlɩ. Mlɩ ánɩ́ mlɩdɛ́mɔsɩ́ séi, mlɩgyɔwɩ nɩ́. Tsúfɛ́ mlɛ́ba begyi awɩrɛhɔ, su. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mlɩ ánɩ́ ahá fɛ́ɛ́ bʋdɛ mlɩ kanfʋ́, mlɩgyɔwɩ, tsúfɛ́ alɩ́ mlɩ anáin bɛkanfʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ afunupʋ amʋ ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Támɛ ndɛ mlɩ ánɩ́ mlónu bláa mbɛ́ɛ, Mlɩdwɛ mlɩ alupʋ́, amlɩbwɛ yilé ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mlɩyula ahá ánɩ́ bʋtɔlwɩ́ɩ́ mlɩ, amlɩbɔ mpáɩ ha ahá ánɩ́ bʋtesíá mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɩ́ ɔha ɔdá fʋ́ ɩsʋtɔ a, damli nyɔɔsɩ ɛ́ ha mʋ ɔda. Nɩ́ ɔkʋ ɔswɩ́ɩ́ fʋ́ tati á, wɔɩ fʋ́ atadɩɛ ɛ́ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nɩ́ ɔkʋ ɔkʋ́lɩ́ fʋ́ atɔ́ á, ha mʋ. Nɩ́ ɔkʋ ɛ́ otsú fʋ́ atɔ́ á, máyɔ́hɔ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bwɛ ha ahá alɩá fʋdeklé fɛɛ bʋbwɛ́ɛ ha fʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nɩ́ fʋ́ adwɛpʋ́ nkʋlɛ fʋtɔdwɛ́ á, ɩpán mɔmʋ fénya? Lakpan abwɛpʋ́ kʋ́ráá bʋtɔdwɛ́ amʋ́ adwɛpʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nɩ́ ɔhá ánɩ́ ɔtɔbwɛ́ yilé há fʋ́ nkʋlɛ fʋ́tɔbwɛ́ yilé há á, ntogyi sʋ́ Bulu ɔdáa fʋ́ ɩpán? Lakpan abwɛpʋ́ ɛ́ bʋtɔbwɛ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nɩ́ ɔhá ánɩ́ fʋyin ánɩ́ obénya há fʋ́ nkʋlɛ fʋtɛhá ɩpán a, ntogyi sʋ́ Bulu ɔdáa fʋ́ ɩpán? Lakpan abwɛpʋ́ óó bʋtɔpʋ́ atɔ́ pan amʋ́ aba, yínkí hɔ mʋ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mʋ́ sʋ mlɩdwɛ mlɩ alupʋ́, mlɩbwɛ yilé ha amʋ́, mlɩpan amʋ́ atɔ́, mlɩmátɩ amʋ́ akɔ, mɛ́nɩ Bulu ɔbɛ́ka mlɩ ɩkɔ tsɔtsɔɔtsɔ. Fówun mlɩlabwɛ́ Ɔsʋ́sʋ́ʋ́sʋ́ Bulu ámʋ abí. Tsúfɛ́ ɔbʋ awɩtɔlɛ há ahá ánɩ́ atɔ́ tamagyi amʋ́ ansɩ́ pʋ́ aha laláhɛ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mlɩbwɛ nwɛ awúnpʋ fɛ́ alɩá mlɩ Sɩ́ Bulu gyí nwɛ owúnpʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mlɩmálɛ ahá ɩlá, mɛ́nɩ Bulu mɛ́ɛlɛ mlɩ ɩlá. Mlɩmáha ɔhaa ɩpɔ́n, mɛ́nɩ Bulu ɛ́ ɔmɛ́ɛha mlɩ pɔ́n. Mlɩsi mlɩ aba ɩlá kie amʋ́, Bulu osi mlɩ klɛ́ kie mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mlɩha ahá tɔ́á dɛ amʋ́ hián, Bulu ɔbɛ́lahá mlɩ. Ɔbɔ́pʋ atɔ susúhɛ wankláán wá mʋ́, wʋ́sʋ́ʋ mʋ́, sílá mʋ́, ɩbɔ́bʋlá tsítsá há mlɩ. Tsúfɛ́ tɔ́á fɔpʋ́súsu ha fʋ́ bá á, mʋ́ kɛ́n Bulu ɔbɔ́pʋsúsu ha fʋ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu lɛ́trá ha amʋ́ yébi ɔbɛ́ɛ, “Nsibi obwiepʋ́ ɔbɛ́talɩ́ kpá nsibi obwiepʋ́? Amʋ́ fɛ́ɛ́ bʋmɛ́ɛkpa wíé ɔbɔ́tɔ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɔkasɩ́pʋ́ tamadʋn mʋ wie, támɛ ɔkasɩ́pʋ́ ɔkásɩ́ bɩ́ á, ɔtɔbwɛ́ fɛ́ mʋ wie. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ntogyi sʋ́ fʋ́dɛ ipí túkúrííbi wúun fʋ́ bá nsíbisʋ, támɛ fʋmɛdɛ́ ogyakpatín ánɩ́ ɩdɩn fʋ́ klɛ́sʋ mʋ́ wúun? ");
INSERT INTO nkoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ntɛ́ɛ ntogyi sʋ́ fʋ́dɛ fʋ́ bá bláa fɛɛ, ‘Mɩ́ píó, ha mɩ́ andɩnkɩ ipí fʋ́ nsíbisʋ’, támɛ fʋmɛdɛ́ ogyakpatín ánɩ́ ɩdɩn fʋ́ klɛ́sʋ mʋ́ wun? Apinabwɛbí ɔbwɛpʋ́, gyankpa dɩnkɩ ogyakpatín ámʋ fʋ́ nsíbisʋ, mɛ́nɩ fówun atɔ́ wankláán, tálɩ́ dɩ́nkɩ́ ipí ámʋ fʋ́ bá klɛ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Oyi wankláán mɛ́ɛtalɩ́ swíé abi laláhɛ. Alɩ kɛ́n oyi laláhɛ ɛ́ mɛ́ɛtalɩ́ swíé abi wankláán nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tsúfɛ́ oyí-ibí bʋtɔpʋ́bɩ́ mʋ́. Bʋtamakpɔ́tɩ́ kankaba okplóto oyísʋ́, bʋtamakpɔ́tɩ́ tsɔkpʋn ɛ́ tʋnkpa ɩflasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɔha wankláán tɛlɛ́ tsiátɔ́ wankláán ɔwan tsú mʋ klʋntɔ, ɔha laláhɛ ɛ́ tɛlɛ́ tsiátɔ́ laláhɛ ɔwan tsú mʋ klʋntɔ. Tsúfɛ́ tɔ́á ɩdʋn ɔha klʋn a, mʋ́tɛ́dálɩ́ tsu mʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ntogyi sʋ́ mlɩdɛ́ mɩ́ tɩ mlɩaa, ‘Mɩ́ Wíé! Mɩ́ Wíé!’ támɛ mlɩtamagyi mɩ́ asʋn blɩ́hɛ́sʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nósuná mlɩ alɩá ɔhá ánɩ́ ɔlɛba mɩ́ wá bonu mɩ́ asʋ́n, gyi dɩnká mʋ́sʋ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ogyi fɛ́ ɔhá ánɩ́ ɔbá beyi obu á, olegyankpá kwí mʋ́ ntswɩasɩ ɔbɔ́ yɔ́tʋ bʋtá, ɔlɔwa ntswɩasɩ ámʋ dɩ́nká mʋ́sʋ́. Brɛ́á ntsu lɔ́bʋlá kɩ́tá mʋ́ á, ɩmɛtalɩ́ kpɩ́nkɩ́ obu ámʋ, tsúfɛ́ oleyi mʋ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Támɛ ɔhagyíɔha ánɩ́ olonu mɩ́ asʋn blɩ́hɛ́, omegyi mʋ́sʋ́ gyí fɛ́ ɔhá ánɩ́ oleyi mʋ obu ɔsʋlʋ́sʋ kɛkɛ, ɔmɔwa mʋ́ ntswɩasɩ. Brɛ́á ntsu lɔbʋlá wa mʋ́ á, ilobwie dá gbloo ɩnʋnʋ, yíntá fɛ́ɛ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Brɛ́á Yesu lɛ́bláa ahá ámʋ asʋ́n ánfɩ fɛ́ɛ́ tá á, ɔlɔyɔ Kapernaum wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romafɔ ɩsá akɔpʋ́ ɔhandɛ ɔkʋ bʋ ɩnʋ. Ɔbʋ osúmpʋ́ ɔkʋá ɔtɛhɩ́ɛ́ kle mʋ asʋ́n. Osúmpʋ́ amʋ dɛ́lɔ, odeklé owu. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Brɛ́á ɩsá akɔpʋ́ ɔhandɛ amʋ lónu Yesu nka á, ɔlɔwa Yudafɔ ahandɛ akʋ sɩ́sɩ́ Yesu ɔbɛ́ɛ, bʋyókokóli mʋ ɔbɛtsa mʋ osúmpʋ́ amʋ ɩlɔ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ahandɛ amʋ bɛhɩɛ kókóli Yesu bɛɛ, “Abwíí ɩpa, nɩ́ ɔkʋ léhián fʋ́ mbʋa á, mʋ́mʋ́ oyin ánfɩ nɩ́! ");
INSERT INTO nkoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tsúfɛ́ ɔtɔdwɛ́ anɩ pɩ. Mʋléyi anɩ ofíakpa kʋ́ráá há anɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mʋ́ sʋ Yesu mʋa amʋ́nyɔ bɔpʋ ɔkpa. Brɛ́á bɛta wóyí ámʋtɔ wie tá á, ɩsá akɔpʋ́ ɔhandɛ amʋ lɔ́wa mʋ anyawíe ɔbɛ́ɛ bʋyéfia Yesu, abʋbla mʋ bɛɛ, mbɛ́ɛ, “Owíé! Máhan fʋ́ ɩwɩ, tsúfɛ́ mmɔfʋn ánɩ́ fɛ́ba mɩ́ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nawun ánɩ́ mɩ́ ɛ́ mmɔfʋn ánɩ́ nɛ́ba fʋ́ wá. Fʋ́ mʋ́ blɩ asʋankʋ, ɩwɩ bɔ́wa mɩ́ osúmpʋ́ amʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tsúfɛ́ mɩ́ ɛ́ mbʋ ahandɛ akʋ asɩ. Ɩsá akɔpʋ́ akʋ ɛ́ bʋbʋ mɩ́ asɩ. Nɛlɛ́ ɔnɔ́ mbɛ́ɛ amʋ́tɔ́ ɔkʋ ɔnátɩ á, ɔtɛnátɩ́. Nɩ́ mbɛ́ɛ ɔbá ɛ́ á, ɔtɛba. Tógyítɔ́á nɛbláa mɩ́ osúmpʋ́ mbɛ́ɛ ɔbwɛ́ɛ á, ɔtɔbwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Brɛ́á Yesu lónu asʋ́n ánfɩ á, ɔnɔ́ lobwie mʋ, ɔlɛdamlí bláa ɔdɔm amʋ́ʋ́ bʋbuo mʋ amʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ asʋ́n, ndɛ mlɩ bláa, mmɔkʋ́wun ɔhá ánɩ́ ɔbʋ hógyi kpɔnkpɔntɩ ánfɩ odu Israelfɔtɔ kʋ́ráá kɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Brɛ́á abɔpʋ amʋ́ʋ́ ɩsá akɔpʋ́ ɔhandɛ amʋ lɔ́wa ámʋ beyinkí yɔ́ wóyítɔ́ a, bowun ánɩ́ osúmpʋ́ amʋ ɩwɩ lawá mʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɩmɔwa ɔpá kʋkʋ Yesu lɔ́yɔ Nain wúlutɔ. Ɔdɔm bʋbuo mʋa mʋ akasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Brɛ́á olowie wúlu ɔnɔ́ á, ɔlɔtʋ akʋ, bʋsʋn fúli akpasʋ bɛbá. Obi yinhɛ́ ɔkʋlɛ pɛ́ ogyi há ɔsʋrapʋ ɔkʋ. Ɔdɔm kpɔnkpɔɔnkpɔntɩá botsú wúlu amʋtɔ ɛ́ bʋbuo ɔtsɩ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Brɛ́á anɩ Wíe lówun ɔtsɩ ámʋ a, mʋ asʋ́n lɔwa mʋ nwɛ, ɔlɛbláa mʋ ɔbɛ́ɛ, “Másu!” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mʋ́ʋ́ ɔlɔyɔ́pʋ ɩbɩ da akpa amʋ, asʋrápʋ́ amʋ besi lɩɩ́. Ɩnʋ ɔlɛbláa fúli amʋ ɔbɛ́ɛ, “Ɔyasubi, ndɛ fʋ́ bláa mbɛ́ɛ, kʋsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɩnʋ fúli amʋ lɔ́kʋsʋ́ tsíá, wá tɔɩ́ bɩ. Yesu lɔ́pʋ mʋ wá mʋ yin ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ifú lɛkɩtá ahá ámʋ fɛ́ɛ́, bɛkanfʋ́ Bulu bɛɛ, “Bulu labɔbʋá mʋ ahá! Mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ kpɔnkpɔntɩ ɔkʋ lalɩn anɩtɔ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu ɩwɩ asʋ́n ánfɩ lɛklɛɩ́ wá Yudea ɔmá pʋ́ awúlu ánɩ́ ɩbʋ nsɩnɛ́ ɩnʋ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Asú Ɔbɔpʋ́ Yohane akasɩ́pʋ́ bɛyɛ́bláa mʋ asʋ́n ánfɩ fɛ́ɛ́. Mʋ́ sʋ ɔlɔwa amʋ́tɔ́ abanyɔ́ sɩ́sɩ́ Yesu ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bʋyɛ́fɩtɛ́ mʋ bɛɛ, “Fʋ́gyí ɔhá ámʋ́ʋ́ ɔbɛ́ba amʋ nɩ, ntɛ́ɛ akɩ́ɩ ɔha bambá ɔkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Brɛ́á ahá ámʋ bɛba bowie Yesu wá á, bɛbláa mʋ bɛɛ, “Asú Ɔbɔpʋ́ Yohane ɔbɛ́ɛ abɛ́fɩtɛ́ fʋ́ anɩaa, ‘Fʋ́gyí ɔhá ámʋ́ʋ́ ɔbɛ́ba amʋ nɩ, ntɛ́ɛ akɩ́ɩ ɔha bambá ɔkpa?’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yesu lɛ́tsa alɔpʋ pʋ́ ahá ánɩ́ ɩwɩ dɛ́ amʋ́ ɔsɩn tsɔtsɔɔtsɔ alɩ brɛ́ ámʋtɔ. Olegya ɔŋɛ laláhɛ lɛ́ ahátɔ, bwíí ansibi abwiepʋ́ tsɔtsɔɔtsɔ ɛ́ ansíbi. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɩnʋ ɔlɛlɛ Yohane akasɩ́pʋ́ asʋ́n ámʋ ɔnɔ́ ɔbɛ́ɛ, “Mlɩyinki yɛbláa Yohane tɔ́á mlɩlabowun pʋ́ mʋ́a mlɩlabonu. Mlɩlabowun ánɩ́ ansibi abwiepʋ́ bʋdɛ atɔ́ wúun, abɔ bʋna. Ɩlɔ pɛpɛ alɔpʋ́ ɩwɩ dɛplɩ́ɩ, ɩsʋ atínpʋ bʋdɛ asʋ́n nu. Afúli bʋdetsinkí, ahiánfɔ ɛ́ bʋdɛ asʋn wankláán ámʋ nu. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bulu obóyulá ɔhá ánɩ́ mɩ́ bwɛhɛ́ mɔkʋsʋ́ lɩ́ɩ́ mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Brɛ́á abí ámʋ́ʋ́ Yohane lɔ́wa sumbí ámʋ beyinkí bɔyɔ́ á, Yesu lɔ́wa tɔɩ́ tsú Yohane ɩwɩ súná ɔdɔm amʋ bɩ. Ɔbɛ́ɛ, “Brɛ́á mlɩlɛ́dalɩ yɔ dimbísʋ́ ɩnʋ á, ntɔ ɔkɩ́kpa mlɩlɔ́yɔ? Fɩtáa ánɩ́ afú dɛ mʋ́ tsʋ́ʋn lóó? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nɩ́ megyí mʋ́ á, ntɔ kóún ɔkɩ́kpa mlɩlɔ́yɔ? Ɔhá ánɩ́ ɔdɩdɩ́ ntsrim. Ɛkɛkɛɛkɛ! Ahá ánɩ́ bʋtɛdɩ́dá tati ámʋ odu gyi ɔdwɛ á, awíe wóyí bʋtetsíá. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mlɩbla mɩ! Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ mlɩlɛ́dalɩ yɛ́kɩ? Ee, Yohane nɩ. Ɔdʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mʋ ɩwɩ asʋ́n Bulu lɛ́blɩ́ bɔwanlɩ́n mʋ́ tswɩ bɛɛ, ‘Kɩ, ndɛ obí wa gya fʋ nkpá. Mʋ ɔbɛ́la ɔkpa há fʋ́ nɩ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu lɔ́yɔ mʋ asʋ́nsʋ́ ɔbɛ́ɛ, “Ndɛ mlɩ bláa mbɛ́ɛ, ɔhagyíɔha ánɩ́ ɔha tsɩhɛ́ lakɛn kwɩɩ́ mɔ́fʋn mʋ, támɛ mʋ ɛ́ ɔmɔfʋn Bulu iwíegyí ámʋtɔ ɔkʋsʋ kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aha ánɩ́ bonu Yesu asʋ́n ánfɩ pʋ́ lampóo ahɔ́pʋ kʋ́ráá bowun ánɩ́ Bulu asʋ́n da ɔkpa. Botsulá há Asú Ɔbɔpʋ́ Yohane lɔ́bɔ amʋ́ asú. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Támɛ Farisifɔ pʋ́ Mose mbla asunápʋ́ amʋ mʋ́ bʋmɛha Yohane ɔbɔ amʋ́ asú. Bekiná tɔ́á Bulu lɛ́hɩhɩ́ɛ ha amʋ́ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu lɔ́yɔ mʋ asʋ́nsʋ́ ɔbɛ́ɛ, “Séi ánfɩ á, amɛndɩ nɔ́pʋkápʋ́ ndɛmba-abí ánfɩ? Ntɔ bɛlɩan? ");
INSERT INTO nkoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bʋgyi fɛ́ nyebíá bʋtsie dɩnsʋ bʋdɛ aba kpolí, blɩ́ bɛɛ, ‘Anɩlapléí ansigyísʋ́, mlɩmɛ́tsa. Mʋ́ sʋ anɩlawá awɩrɛhɔ ɩlʋ, támɛ mlɩmósú.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mlɩgyí fɛ́ nyebí ánfɩ, tsúfɛ́ Yohane lɛ́ba á, oletsiá klɩ́ ɔnɔ́, omonu ntá, támɛ mlɩaa, ‘Ɔŋɛ laláhɛ bʋ mʋtɔ!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mʋ́ naba ndɛ atɔ́ gyí, ndɛ ntá núu. Mʋ́ ɛ́ mlɩaa, ‘Mlɩkɩ opotsuapʋ pʋ́ nta ɔbʋpʋ́. Lakpan abwɛpʋ́ pʋ́ lampóo ahɔ́pʋ onyawíe.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Támɛ ɔhá ánɩ́ ɔbʋ Bulu nyánsa á, mʋ tsíátɔ́ tɛlɛ́ mʋ́ ɔwan.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisiyin ɔkʋ lɛ́tɩ Yesu atɔ́ ogyíkpá mʋ wóyítɔ́. Brɛ́á Yesu tsie ɔpʋ́nʋ́ ámʋ asɩ á, ");
INSERT INTO nkoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ɔtsɩ ɔkʋá ɔbʋ wúlu amʋtɔ, ogyi lakpan ɔbwɛpʋ́ lónu Yesu nka ánɩ́ batswɩ ɔpʋ́nʋ́ há mʋ Farisiyin amʋ wóyítɔ́. Ɩnʋ olotsu mʋ ofobí fánfán ánɩ́ ɩbʋ bíá prɛntʋa wankláán ɔbɔ ba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ɔlɛbɛda akpawunu Yesu ayabiasɩ, ɔlɛkpa isú yi woo. Ɔlɔpʋ mʋ ntsú fwɩ́ Yesu ayabiasɩ, pʋ́ mʋ nwunsʋ-imi tsítsi mʋ́. Ɔlɔkʋlá Yesu ayabi pútá, tsɛ́ɩ́ ofobí fánfán ámʋ wʋ́lɩ́ mʋ ayabisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Brɛ́á Farisiyin amʋ́ʋ́ ɔlɛtɩ Yesu amʋ lówun ɩ́nɩ á, ɔlɛblɩ́ wá nwuntɔ ɔbɛ́ɛ, “Nɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ oyin ánfɩ gyí lɛ́lɛ́ á, tɛkɩ alawun ɔhá oduá ɔtsɩ ánfɩ gyí asa ɔdɛpʋ ɩbɩ da mʋ, tsúfɛ́ lakpan ɔbwɛpʋ́ ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu lɛ́bláa oyin ámʋ ɔbɛ́ɛ, “Simon, mbʋ asʋankʋ bláa fʋ.” Simon lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Osunápʋ́, amansʋ igyi? Bla mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ahá abanyɔ́ akʋ bɛpan sika oyin ɔkʋ wá. Ɔkʋlɛ lɛ́pan blɩba-anu (5,000,000), ɔkʋlɛ ɛ́ lɛ́pan mpɩ́m lafanu (500,000). ");
INSERT INTO nkoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bʋmenyá kɔ́ba amʋ ká. Mʋ́ sʋ oyin ámʋ lésikíé amʋ́ abanyɔ́ fɛ́ɛ́. Bla mɩ, amʋ́tɔ́ ɔmɔmʋ ɔbɔ́dwɛ oyin ámʋ dʋn?” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon lɛ́bláa mʋ ɔbɛ́ɛ, “Nahogyiá ɔmʋamʋ́ʋ́ mʋ ɩkɔ tsɔ dʋn amʋ.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ igyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɩnʋ Yesu léyinkí kɩ ɔtsɩ ámʋ, ɔlɛbláa Simon ɔbɛ́ɛ, “Fawun ɔtsɩ ánfɩ? Nɛba fʋ́ wóyítɔ́ a, fʋmɛha mɩ́ ntsu anfwɩ ayabiasɩ. Támɛ ɔtsɩ ánfɩ mʋ́ lapʋ́ mʋ ntsú fwɩ́ mɩ́ ayabiasɩ, pʋ́ mʋ nwunsʋ-imi tsítsi mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fʋmɛlatá mɩ́ pútá, támɛ tsú brɛ́á nɛba nfɩ ɔpá á, ɔtsɩ ánfɩ mɔ́kʋ́sí mɩ́ ayabi kʋlá pútá. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fʋmɛtsɛɩ́ ofobí wʋ́lɩ́ mɩ́ nwuntɔ, támɛ mʋ mʋ́ alatsɛ́ɩ́ ofobí fánfán wʋ́lɩ́ mɩ́ ayabisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mʋ́ sʋ ndɛ fʋ́ bláa mbɛ́ɛ, ɔdwɛ tsɔtsɔɔtsɔ ánfɩ alalɛ́ súná mɩ́ ánfɩ idesuná ánɩ́ Bulu lasí mʋ lakpan tsɔtsɔɔtsɔ ámʋ fɛ́ɛ́ kíé mʋ. Támɛ ɔhá ánɩ́ Bulu osíi lakpan kpalobí kíé á, ɔdwɛ kpalobí ɔtɛlɛ́ súná.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɩnʋ Yesu lɛ́bláa ɔtsɩ ámʋ ɔbɛ́ɛ, “Nasí fʋ́ lakpan fɛ́ɛ́ kíé fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ahá ámʋ́ʋ́ amʋ́a Yesu bʋtsie ɔpʋ́nʋ́asɩ ámʋ, bɛblɩ́ wá nwuntɔ bɛɛ, “Ma gyí oyin ánfɩ ɔbɛ́ɛ mʋna mʋdɛ ahá lakpan sikíé amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mʋ́ʋ́ Yesu lɛ́bláa ɔtsɩ ámʋ ɔbɛ́ɛ, “Fʋ́ hógyi lahɔ fʋ nkpa. Natɩ iwilwiitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Ɩmɔwa ɔpá kʋkʋ, Yesu léki awúlu mʋ́a nkuda asɩ, ɔdɛ Bulu iwíegyí ámʋ ɩwɩ asʋn wankláán ɔkan da. Mʋ akasɩ́pʋ́ dúanyɔ ámʋ pʋ́ atsɩ akʋá olegya ɔŋɛ laláhɛ lɛ́ amʋ́tɔ́, tsá amʋ́ ɩlɔ bobuo mʋ. Atsɩ ámʋ gyí, Magdalayintse Maria ánɩ́ Yesu légya ɔŋɛ laláhɛ asienɔ́ lɛ́ mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Owíe Herode wóyísʋ́ ɔkɩ́pʋ Kusa mʋ ka Yohana. Ɔtsɩ ɔkʋá bʋtɛtɩ́ mʋ Susana pʋ́ atsɩ tsɔtsɔɔtsɔá betsiá pʋ́ amʋ́ atɔ́ kɩ Yesu mʋa mʋ akasɩ́pʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Brɛ́á ɔdɔm kpɔnkpɔɔnkpɔntɩ botsu awúlu-awúlusʋ ba befia Yesu wá á, ɔlɛha amʋ́ yébi ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ɔdɔtɔpʋ ɔkʋ lɔ́yɔ atɔ́-abí owunyákpa. Brɛ́á ɔdɛ mʋ́ wunyáa a, ɩkʋ lɔ́wʋlɩ́ ɔkpatɔ, ahá bɛtsatsáa mʋ́sʋ́, mbubwi ɛ́ bɔtswɛtswɛ́ɛ mʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɩkʋ lɔ́wʋlɩ́ abʋtásʋ́, ɔtɩ́nɛ́á ɩsɩ kpalobí dɩn. Ɩlɔwa ɔsa kwɛ, támɛ brɛ́á owí lɛlɩn a, ɩlɔtɔ mʋ́ mɔ́, tsúfɛ́ imenya ntsu. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Abí ámʋ kʋ lɔwʋlɩ́ awutɔ, awu ámʋ lɔbʋlá kɩ́tá mʋ́, ɩmɛdan. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Abí ámʋ kʋ lɔwʋlɩ́ ɔsʋlʋ́ʋ wankláánsʋ́, dan. Iloswie abí tsɔtsɔɔtsɔ fɛ́ mʋ́ ámʋ́ʋ́ olodu ámʋ odu tsé lafa.” Yesu lɔ́mɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Ɔhá ánɩ́ ɔbʋ asʋ onúu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu akasɩ́pʋ́ bɛfɩtɛ́ mʋ yébi anfɩ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Bulu lahá mlɩ ɔkpa ɔbɛ́ɛ, mlɩbɩ́ɩ mʋ iwíegyí ámʋ ɩwɩ asʋn ŋaínhɛ́. Támɛ ndɛ aha bambá asʋ́n bláa ayébisʋ, mɛ́nɩ bówun, támɛ bʋmɛ́ɛbɩ. Bónu, támɛ bʋmóonu mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Yébi amʋ asɩ nɩ́. Atɔ́-abí ámʋ gyí Bulu asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ ɔkpatɔ ámʋ gyí ahá ánɩ́ bʋtonú asʋ́n ámʋ, támɛ Ɔbʋnsám tɛba bɛlɛ mʋ́ lɛ́ amʋ́ klʋntɔ, mɛ́nɩ bʋmɔ́ɔhɔ mʋ́sʋ́ gyi, fówun bénya nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ abʋtásʋ́ amʋ gyí ahá ámʋ́ʋ́ bonú asʋ́n ámʋ pɛ́, bahɔ mʋ́ ansigyísʋ́, támɛ bʋma nlín. Mʋ́ sʋ bʋtamahogyi wa ɔpá. Nɩ́ ɩsɔ́kɩ kʋ inyá tʋ́ amʋ́ pɛ́, badɩda. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ awutɔ ámʋ gyí ahá ánɩ́ bonú asʋ́n ámʋ a, bahɔ mʋ́, támɛ ɔyɩ́ ánfɩtɔ atɔ hiánhɛ ɩwɩ gywɩɩ́n, pʋ́ mʋ́tɔ́ atonyahɛ́ ɩwɩ ansigyí tegyi asʋ́n ámʋsʋ. Ɩ́nɩ sʋ bʋtamaswíé abí dan. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Abí ámʋ́ʋ́ ɩlɔwʋlɩ́ ɔsʋlʋ́ʋ wankláánsʋ́ ámʋ gyí ahá ámʋ́ʋ́ bonú asʋ́n ámʋ a, bʋtɔhɔ mʋ wá klʋn wankláán ánɩ́ itonú asʋ́n, gyi mʋ́sʋ́tɔ́. Ɩ́nɩ sʋ bʋtotomi swíé abí tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ɔhaa tamanywɛ́ ɔkandɩ́ɛ pʋ́ atɔ́ bun mʋ́sʋ́, ntɛ́ɛ pʋ́wá mpá ayasɩ. Ɔfʋákpá ɔtɔpʋ́bian, mɛ́nɩ ɩbɔ́wankɩ́ há ahá ánɩ́ bɛ́ba wóyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Tsúfɛ́ tɔtɔ má ɩnʋá ibéŋaín, ɩmɛ́ɛlɩn ɔwan. Asʋn ŋaínhɛ́ kʋkʋ ɛ́ ma ɩnʋá bʋmɛ́ɛbɩ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mlɩkɩ wankláán mlɩ asʋ́n-nutɔ́. Tsúfɛ́ ɔhá ánɩ́ odekléá obónu mɩ́ atosunáhɛ́ amʋ asɩ á, Bulu ɔbɔ́pʋ ɩkʋ tsɩ́a mʋ́tɔ́ há mʋ. Támɛ ɔhá ánɩ́ omedékléá obónu mʋ́ asɩ á, Bulu ɔbɔ́swɩɩ́ mʋ kpalobí ámʋ́ʋ́ olosusúu ánɩ́ alabɩ́ ámʋ kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu mʋ yin mʋa mʋ apíó bɛba mʋ wá, támɛ ɔdɔm amʋ sʋ bʋmɛtalɩ́ wíé ba mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ahá ámʋtɔ ɔkʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Fʋ́ yín mʋa fʋ́ apíó bʋlɩɩ́ kpankpá, bʋdekléá bówun fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ yín mʋa mɩ́ apíó gyí ahá ánɩ́ bʋtonú Bulu asʋ́n ámʋ, gyi mʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɛkɛ ɔkʋ Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Mlɩha afa Galilea ɔpʋ yɔ mʋ́ ɔbɩn.” Mʋ́ sʋ bɔpʋ ɔkpa bɔyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Brɛ́á bɔyɔ́ á, Yesu lɛ́dɩdɩ. Ɩnʋ afú kpɔnkpɔɔnkpɔntɩ kʋ lɔ́wa tsʋ́ʋn bɩ. Ntsu ámʋ ɩdɛda wíé ɔklʋn amʋtɔ, ideklé ɩmɛ. Ɩlɔtʋ amʋ́ ansɩ́ pɛpɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mʋ́ sʋ betsinkí Yesu, bláa mʋ bɛɛ, “Anɩ Wíe! Anɩdɛ́ ntsu wie!” Yesu lɔ́kʋsʋ́ lɛ́ ɔnɔ́ wa afú mʋ́a ntsu ámʋ, ɩnʋ fɛ́ɛ́ lɔlʋá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɩnʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩ hógyi mɛ?” Ifú lɛkɩtá amʋ́, ɔnɔ́ lobwie amʋ́, bɛfɩtɛ́ aba bɛɛ, “Nyankpʋsa ɔmɔmʋ nɩ, alalɛ́ ɔnɔ́ wa afú mʋ́a ntsu kʋ́ráá, banú mʋ ɔmɛ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu mʋa mʋ akasɩ́pʋ́ bɛfa ɔpʋ tsú Galilea yówie Gerasefɔ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Brɛ́á Yesu dɛ́dalɩ ɔklʋn amʋtɔ á, oyin ɔkʋá otsú wúlu amʋtɔ, ɔŋɛ laláhɛ bʋ mʋtɔ lébefia mʋ. Oyin ánfɩ lɛ́kpa atɔ́, tú dálɩ wóyítɔ́, yɔ́ otsie afúli opulákpá ɩlawá ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Brɛ́á olowun Yesu a, ɔlɔsʋrá okitikíti, dá akpawunu Yesu ayabitɔ, kplʋ́n blɩ́ ɔbɛ́ɛ, “Ɔsʋ́sʋ́ʋ́sʋ́ Bulu mʋ Bi Yesu, amansʋ igyi? Kókoli, mápɩtɩ́ mɩ́ atɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alɩ brɛ́ ámʋtɔ á, Yesu lakplʋ́n wa ɔŋɛ laláhɛ amʋ ɔbɛ́ɛ, ɩdálɩ mʋtɔ dodo. Mʋ́ sʋ oyin ámʋ lɛ́blɩ́ alɩ nɩ́. Ɔŋɛ́ laláhɛ amʋ itowíé mʋtɔ brégyíbrɛ́. Mʋ́ sʋ bʋtɔwá mʋ ɩbɩ pʋ́ mʋ ayabi ɩkan, gyo mʋ ɩwɩ. Mʋ́ óó á, otebíá ɩkan amʋ, ɔŋɛ laláhɛ amʋ ɩtɛhá mʋ ɔtɛsrɩ́ wíé aputu. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɩnʋ Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Nkálɩ bʋtɛtɩ́ fʋ́?” Oyin ámʋ lɛ́lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ dá gyí ‘Ɔdɔm.’ ” Tsúfɛ́ ɔŋɛ laláhɛ tsɔtsɔɔtsɔ bʋ mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɔŋɛ laláhɛ amʋ bokokóli Yesu ɔbɛ́ɛ, ɔmágya amʋ́ yɔ́wa ɩlán klúklúúklúá ɩma ɔkatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mprákuo tsɔtsɔɔtsɔ akʋ bʋdegyí okúku kʋsʋ ɩnʋ fʋ́n. Mʋ́ sʋ ɔŋɛ laláhɛ amʋ bokokóli Yesu bɛɛ, ɔhá abʋyowie mprákuo ámʋtɔ. Ɔlɛha amʋ́ ɔkpa ɔbɛ́ɛ bʋyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɩnʋnʋ bɛdalɩ oyin ámʋtɔ yówie mprákuo ámʋtɔ, amʋ́ fɛ́ɛ́ bɛsrɩ́ kpákplɩ́ okúku amʋ wíé ɔpʋtɔ, wúwu. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Brɛ́á mprákuo akpapʋ́ ámʋ bowun tɔ́á ɩlaba a, bɛsrɩ́ yɛ́blɩ́ asʋ́n ánfɩ wúlutɔ pʋ́ ɔmá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɩnʋ ahá bɛba bɛkɩ tɔ́á ɩlaba. Bowun ánɩ́ oyin ámʋ́ʋ́ tɛkɩ ɔŋɛ laláhɛ bʋbʋ mʋtɔ ámʋ ansɩ́tɔ́ ladɩ́, alawá atadɩɛ otsie Yesu wá. Ɩlɔwa amʋ́ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ahá ámʋ́ʋ́ bowun ɩtɔ́ ámʋ́ʋ́ ɩlɛba amʋ bɛbláa amʋ́ alɩá oyín ámʋ́ʋ́ ɔŋɛ laláhɛ bʋbʋ mʋtɔ ámʋ lénya mʋ ɩlɔtsá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ɔmá ámʋtɔ ahá fɛ́ɛ́ bokokóli Yesu bɛɛ, ɔdálɩ amʋ́ ɔmátɔ́, tsúfɛ́ ifú lɛhɩɛ kɩ́tá amʋ́. Mʋ́ sʋ Yesu lówie ɔklʋn amʋtɔ ɔbɛ́ɛ amʋnatɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Oyin ámʋ́ʋ́ tɛkɩ ɔŋɛ laláhɛ tsie mʋtɔ ámʋ lókokóli mʋ ɔbɛ́ɛ, “Ha mɩ́ ambuo fʋ yɔ.” Támɛ Yesu mɛ́ha mʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mboún ɔlɛbláa mʋ ɔbɛ́ɛ, “Yinki yɔ wóyí, afʋyɛbláa mlɩ pɩ toyiléá Bulu labwɛ́ há fʋ́.” Mʋ́ sʋ oyin ámʋ léki wúlu amʋ fɛ́ɛ́ fíá, ɔdɛ toyilé ámʋ́ʋ́ Yesu labwɛ́ há mʋ amʋ blɩ́ wúlu amʋtɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Brɛ́á Yesu léyinkí yówie ɔpʋ amʋ ɔbɩn a, ɔdɔm bɔhɔ mʋ atúu, tsúfɛ́ bʋdɛ mʋ ɔkpa kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɩnʋ oyin ɔkʋá bʋtɛtɩ́ mʋ Yairo, ogyi Yudafɔ ofíakpa ɔhandɛ lɛ́ba bɛda akpawunu mʋ ayabitɔ, kókóli mʋ ɔbɛ́ɛ, ɔbá abʋyɔ mʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mʋ bi tsɩ́hɛ́ ɔkʋlɛ pɛ́á ɔbʋ, alahɔ nfí dúanyɔ da odewu. Brɛ́á Yesu lɔ́pʋ ɔyɔ́ ɩnʋ á, ɔdɔm amʋ́ʋ́ bʋbuo mʋ amʋ bɛkpa buo mʋ yɛɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɔtsɩ ɔkʋá obugya dɛ mʋ wʋlɩ́ nfí dúanyɔ nɩ́, ɔhaa mɔ́kʋ́tálɩ́ tsá mʋ, alayíntá mʋ́ ɩwɩsʋ atɔ́ fɛ́ɛ́ ɩlɔ atsapʋ́ ɩbɩtɔ bʋ ahá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɔtsɩ ánfɩ lɔ́tsʋn yɔ Yesu ɔma, pʋ́ ɩbɩ da mʋ tati osiebí. Ɩnʋnʋ obugya amʋ lɛka itin. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ ɔbɛ́ɛ “Ma lápʋ́ ɩbɩ da mɩ?” Brɛ́á ahá ámʋ fɛ́ɛ́ bɛɛ bʋmɔkʋ́pʋ́ ɩbɩ da mʋ a, Petro lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, ɔdɔm anfɩ́ bʋpu fʋ́ ánfɩ á, mʋ́ fʋ́dɛ asʋ́n ánfɩ fɩtɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Támɛ Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Ɔkʋ lapʋ́ ɩbɩ da mɩ. Nawun ánɩ́ ɔŋɛ́ kʋ ladálɩ mɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Brɛ́á ɔtsɩ ámʋ lówun ánɩ́ ɩtɔ́ ámʋ́ʋ́ mabwɛ́ ámʋ lalɩn ɔwan á, ɔlɛdalɩ ba. Ɔdɛkpɩnkɩ́ kpakpakpakpa, ɔlɛyɛ́da akpawunu Yesu ayabitɔ, bláa mʋ ahá ámʋ fɛ́ɛ́ ansɩ́tɔ́ tɔ́á sʋá mɔpʋ ɩbɩ da mʋ, pʋ́ alɩá manyá ɩlɔtsá. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ɩnʋ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ bí, fʋ́ hógyi latsá fʋ́ ɩlɔ. Natɩ iwilwiitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Brɛ́á Yesu bʋ mʋ tɔ́ɩ anfɩsʋ á, ɔkʋ lɛ́srɩ́ tsú Yairo wóyítɔ́ ba bɛbláa Yairo ɔbɛ́ɛ, “Fʋ́ bí ámʋ ɔdɩkpa mɔwa alɛ́. Mátepí trá wa osunápʋ́ tɔ́ɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Brɛ́á Yesu lónu asʋ́n ánfɩ á, ɔlɛbláa Yairo ɔbɛ́ɛ, “Mánya ifú. Fʋ́ mʋ́ hogyi wʋlɛ, obénya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Brɛ́á Yesu lówie wóyítɔ́ ɩnʋ á, ɔmɛha ɔhaa obuo mʋ yɔ obuá kebi ámʋ da mʋ́tɔ́, dʋn Petro, Yohane, Yakobo pʋ́ kebi ámʋ akwɩɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Alɩ brɛ́ ámʋtɔ á, ahá ámʋ fɛ́ɛ́ bʋdesú, bʋdɛ okitikíti. Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩsi okitikíti sʋrá. Ɔmɔkʋ́wú, dɩdɩ́ ɔdɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ahá ámʋ fɛ́ɛ́ bʋyin ánɩ́ otsibi amʋ lawú. Mʋ́ sʋ bɔmɔsɩ́ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ɩnʋ Yesu lɛ́kɩtá otsibi amʋ ɩbɩ, kpólí mʋ ɔbɛ́ɛ, “Obí, kʋsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɔŋɛ́ lɛlawíé mʋ, ɔlɔkʋsʋ́ lɩ́ɩ́ ɔtsáwʋlɛ pɛ́. Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩdunka tɔkʋ ha mʋ ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɔnɔ́ lobwie otsibi amʋ akwɩɩ́pʋ́, támɛ Yesu lɛ́da amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩmábláa ɔhaa asʋ́n ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu lɛ́tɩ akasɩ́pʋ́ dúanyɔ ámʋ fia, ɔlɛha amʋ́ túmi, há amʋ́ ɔkpa ɔbɛ́ɛ, bʋgyáa ɔŋɛ laláhɛ fɛ́ɛ́, abʋtsa ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɔlɔwa amʋ́ ɔbɛ́ɛ, bʋyɛ́da Bulu iwíegyí ámʋ ɔkan, abʋtsa alɔpʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɔyɔ́ á, mlɩmátsu tɔtɔ. Mlɩmátsu oyi yiáhɛ́, akpankogyo, atogyihɛ, kɔ́ba ntɛ́ɛ atadɩɛ nyɔɔsɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wóyígyíwóyítɔ́á bɔ́hɔ mlɩ á, mlɩtsia ɩnʋ yɔ́fʋn ɛkɛá mlɛ́dalɩ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɩ́ bʋmɔhɔ mlɩ wúlu kʋsʋ, mlɩdɛ́dalɩ mlɔyɔ́ á, mlɩkpakpa mlɩ ayabitɔ-ɩsɩ wʋlɩ wúlu amʋtɔ, isuna ánɩ́ bʋmɛbɩ bwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bɛnatɩ́ kí nsɩnɛ́ ɩnʋ awúlu fɛ́ɛ́sʋ́, bʋdɛ asʋn wankláán ámʋ ɔkan da, tsá ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Brɛ́á Galilea ɔmásʋ́ ogyípʋ́ Herode lónu tɔ́á ɩdɛ mʋ́sʋ́ yɔ á, olegyigyáa. Tsúfɛ́ akʋ bʋdɛblɩ́ bɛɛ, “Asú Ɔbɔpʋ́ Yohane lakʋ́sʋ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Akʋ ɛ́ bɛɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ dada Elia lálɛ́ ɩwɩ ɔwan.” Akʋ ɛ́ bɛɛ, “Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ dada amʋtɔ ɔkʋ lákʋ́sʋ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herode lɛ́blɩ́ ɔbɛ́ɛ, “Nahá batɩn Yohane. Ngya oyin ɔmɔmʋ ɩwɩ asʋ́n ntráa ndenu alɩ?” Mʋ́ sʋ ɔlɔbɔ mbɔ́dɩ́ ánɩ́ mówun Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu sumbí ayɔpʋ́ amʋ beyinkí bá bɛbláa mʋ tɔ́á bayɔ́bwɛ. Ɔlɛkpa amʋ́ buo ɩwɩ, amʋ́ nkʋlɛ bɔyɔ Betsaida wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Brɛ́á ɔdɔm amʋ bɛbɩ ánɩ́ ɔbʋ ɩnʋ á, begya mʋ ɔkpa yɔ́ ɩnʋ. Yesu lɔ́hɔ amʋ́ atúu, ɔlɛbláa amʋ́ Bulu iwíegyí amʋ ɩwɩ asʋ́n, ɔlɛtsa amʋ́á bʋdɛlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Brɛ́á owí dɛpɔ́ɔn a, sumbí ayɔpʋ́ dúanyɔ ámʋ bɛba bɛbláa Yesu bɛɛ, “Ha amʋ́ abʋnatɩ, mɛ́nɩ bɛ́talɩ́ yɔ́ awúlu ánɩ́ ɩbʋ mantáa nfɩsʋ yódunká atogyihɛ mʋ́a ɔdɩkpa, tsúfɛ́ anɩméenya tɔtɔ há amʋ́ dimbí ánfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Támɛ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩdunka atɔ́ ha amʋ́ abʋgyi.” Akasɩ́pʋ́ amʋ bɛbláa mʋ bɛɛ, “Tɔ́á anɩbʋ fɛ́ɛ́ gyí bodobodo apin anu pʋ́ ntsutso iye bwáhɛ́ anyɔ. Nkɛ́tɩ anɩlayɔ́hɔ atogyihɛ ba ahá ánfɩ fɛ́ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ayin ánɩ́ bʋbʋ ɩnʋ bɔ́bwɛ fɛ́ mpɩ́m-nu (5,000).) Yesu lɛ́bláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha amʋ́ abʋtsia okútɔ́. Iku kʋlɛ ɩbwɛ́ɛ fɛ́ ahá aduenu (50).” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Akasɩ́pʋ́ amʋ bɔbwɛ dɩ́nká mʋ́sʋ́, ɔhagyíɔha létsiá asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ɩnʋ olotsu bodobodo anu pʋ́ ntsutso iye bwáhɛ́ anyɔ ámʋ. Ɩnʋ olotsu ansɩ́ fʋ́á kɩ́ɩ ɔsʋ́sʋ́, ɔlɛda Bulu ɩpán. Mʋ́ʋ́ olebiabía mʋ́tɔ́ pʋ́há akasɩ́pʋ́ amʋ ɔbɛ́ɛ, bʋyée mʋ́ ha ahá ámʋ fɛ́ɛ́ abʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amʋ fɛ́ɛ́ begyi mwɛ sian. Brɛ́á akasɩ́pʋ́ amʋ bɔtɔsɩ́ isíanhɛ amʋ a, ɩlɔbʋlá alakpá dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɛkɛ ɔkʋ Yesu nkʋlɛ dɛ́ mpáɩ bɔ, mʋ akasɩ́pʋ́ amʋ bʋbʋ ɩnʋ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma ahá bɛɛ ngyi?” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Akʋ bɛɛ, fʋ́gyí Asú Ɔbɔpʋ́ Yohane. Akʋ bɛɛ, Bulu Ɔnɔ́sʋ́ Ɔtɔɩ́pʋ́ Elia. Akʋ ɛ́ bɛɛ, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ dada ɔkʋ lákʋ́sʋ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩ ɛ́ mɛ́? Mlɩa mɩ́gyí ma?” Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ɩnʋ Yesu lɛ́da amʋ́ ɔlá kpákpáákpá ɔbɛ́ɛ, bʋmábláa ɔhaa mʋ ɩwɩ asʋ́n ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɔlɛtrá bláa amʋ́ ɔbɛ́ɛ, “Ilehián ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́hɩɛ wun ɩwɩɔsɩn tsɔtsɔɔtsɔ Yudafɔ ahandɛ, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ ɩbɩtɔ; amʋ́ fɛ́ɛ́ békiná mɩ́, há bɔ́mɔ mɩ́, támɛ Bulu ɔbɛ́lakʋ́sʋ́a mɩ tsú afúlitɔ ɛkɛ sáásɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɩnʋ ɔlɛbláa ahá ámʋ ɔbɛ́ɛ, “Nɩ́ ɔkʋ dékléá obóbuo mɩ á, osíi tɔ́á otekle bwɛ, otsu mʋ oyikpalíhɛ ekekegyíɛkɛ bobuo mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tsúfɛ́ nɩ́ ɔkʋ lɛ́prɩ mʋ nkpa á, ɔbɔ́hʋlɩ́ɩ mʋ́. Nɩ́ ɔkʋ ɛ́ lési mʋ nkpa há mɩ́ sʋ ɛ́ á, Bulu ɔbɔ́hɔ mʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nɩ́ ɔkʋ onyá ɔyɩ́tɔ́ atɔ́ fɛ́ɛ́, támɛ ɔhʋ́lɩ mʋ ɔkláa a, labi mɔmʋ ɩlɔwa há mʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɩ́ ɔkʋ onyá mɩ́a mɩ́ atosunáhɛ́ pɛ́lɩ a, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ nénya mʋ pɛ́lɩ brɛ́á nna mɩ́a mɩ́ Sɩ́ pʋ́ mʋ abɔpʋ wánkɩ́hɛ́ numnyamtɔ nɛbá. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ɔnɔkwalɩ ndɛ mlɩ bláa. Akʋ bʋbʋ mlɩtɔ nfɩ bʋmóowu asa bówun Bulu iwíegyí amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu lɛ́blɩ́ asʋ́n ánfɩ ndawɔ́tswɩ́ ɔma a, ɔlɛkpa Petro mʋa Yohane pʋ́ Yakobo buo ɩwɩ, bɔdʋ yɔ́ mpáɩ ɔbɔkpá ɩbʋ kʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Brɛ́á ɔdɛ mpáɩ ámʋ bɔ á, mʋ ansɩ́tɔ́ lɛtsɛ. Mʋ atadɩɛ lofulí hʋ́nánáná, ɩdɛ ogyá kpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ɩnʋ á, ahá abanyɔ́ ánɩ́ batsíá kɩ, bʋgyi Mose mʋa Elia bɛlɛ ɩwɩ ɔwan ɔsʋ́sʋ́ numnyamtɔ. Amʋ́a Yesu bɔtɔɩ́ tsú mʋ lowuá Bulu lɛ́hɩɛ tswɩ mʋ ánɩ́ ɩmɔ́ɔwa ɔpá obówu Yerusalem ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro mʋa mʋ aba ámʋ bɛdɩdɩ. Brɛ́á bɔwan tsinkí á, bowun Yesu numnyam, ahá abanyɔ́ ámʋ ɛ́ bʋlɩɩ́ mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Brɛ́á ahá abanyɔ́ ámʋ bʋdɛnatɩ́ á, Petro lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, ɩbʋ alɛ́á abétsiá nfɩ. Ha ada abú asa. Fʋ́ klɛ́ kʋlɛ, Mose klɛ́ kʋlɛ, Elia ɛ́ klɛ́ kʋlɛ.” (Ɔmɛbɩ tɔ́á ɔdɛblɩ́). ");
INSERT INTO nkoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Brɛ́á ɔdɛ asʋ́n ánfɩ blɩ́ á, agyinde kʋ lobobun amʋ́ fɛ́ɛ́sʋ́. Ɩnʋ ifu lɛkɩtá amʋ́ abasá ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ɩnʋ á, ɔmɛ kʋ lɛdalɩ tsu agyinde amʋtɔ ɔbɛ́ɛ, “Ɔ́nɩ gyí mɩ́ Bíá nalɛ́ nɩ́. Mlɩyaa asʋ amlɩnu mʋ ɔmɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɔmɛ amʋ lótsutsúa ɩbɛka tin á, ɩlasí Yesu nkʋlɛ ɩnʋ. Akasɩ́pʋ́ amʋ bɛkpa ɔnɔ́ bun asʋ́n ánfɩsʋ nkɛ ámʋtɔ. Bʋmɛbláa ɔhaa ɩtɔ́á bayówun. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mʋ́ ɔyɩ kɛhɛ a, Yesu mʋa akasɩ́pʋ́ abasá ámʋ bɛkplɩ́ tsú ɩbʋ ámʋsʋ, ɔdɔm amʋ befia mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ɩnʋ amʋ́tɔ́ ɔkʋ lɔ́kplʋn ɔbɛ́ɛ, “Osunápʋ́, kókoli, damli kɩ mɩ́ bí ha mɩ. Obi yinhɛ́ ɔkʋlɛ pɛ́ ogyi mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɔŋɛ laláhɛ kʋ towíé mʋtɔ, ɔtɔkplʋ́n. Ɔtɛdɩda gbla, ɔdɛkɔ tsikitsiki, mʋ ɔnɔ́ tɔbwɛ́ afu. Ipiantɔ asa itesí mʋ, ɩdɛ mʋ yintá. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nobobwií ɩpa há fʋ́ akasɩ́pʋ́ amʋ mbɛ́ɛ, bʋgyáa mʋ́ lɛ mʋtɔ, támɛ bʋmɛtalɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ndɛmba-abíá mlɩmá hógyi, mlɩ tsiátɔ́ ma alɛ. Alɩ́ nétsiá mlɩ wá, nyá klʋn há mlɩ ekekegyíɛkɛ nɩ́?” Ɩnʋ ɔlɛbláa oyin ámʋ ɔbɛ́ɛ, “Kpa fʋ́ bí ámʋ ba mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Brɛ́á ɔlɛkpa kebi ámʋ ɔbá á, ɔŋɛ laláhɛ amʋ lɛ́fɩn mʋ dá, ɔdɛkɔ tsikitsiki. Támɛ Yesu lɔ́kplʋn wa ɔŋɛ laláhɛ amʋ, tsá kebi ámʋ. Ɩnʋ oleyinkía mʋ há mʋ sɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bulu túmi kpɔnkpɔntɩ ámʋ lɛha ɔnɔ́ lobwie ahá ámʋ fɛ́ɛ́. Brɛ́á mʋ bwɛhɛ́ ɩdɛ ɔhagyíɔha wánwan wa á, Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mlɩhɩɛ yaa asʋ amlɩnu. Bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há adʋ́n bɔ́mɔ mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Támɛ akasɩ́pʋ́ amʋ bomonu mʋ́ asɩ. Bulu lɔ́pʋ mʋ́ asɩnu ŋáín amʋ́. Mʋ́ sʋ ɩmɔwankɩ́ amʋ́ asʋ́n ánɩ́ ɔdɛblɩ́. Ifú ɛ́ dɛ amʋ́ ánɩ́ bɛ́fɩtɛ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nwɛ́ɛn kʋ lɛ́ba akasɩ́pʋ́ amʋ nsɩnɛ́, tsú amʋ́tɔ́ ɔhá ánɩ́ ɔbɔ́bwɛ ɔhandɛ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛkpa kebi ɔkʋ bɛlɩɩ́ mʋ ɩwɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔhagyíɔha ánɩ́ ɔlɔhɔ kebi ánfɩ mɩ́ dátɔ́ lahɔ mɩ. Ɔhagyíɔha ánɩ́ ɔhɔ mɩ ɛ́ lahɔ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ. Tsúfɛ́ ɔhá ánɩ́ ogyi ɔtráhɛ mlɩtɔ fɛ́ɛ́ gyí ɔdɛ́hɛn.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohane lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, anɩlówun oyin ɔkʋ dɛ́pʋ fʋ́ dá gya ɔŋɛ laláhɛ, anɩlɛ́ka mʋ tin, tsúfɛ́ ɔma anɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩmáka mʋ tin! Tsúfɛ́ ɔhá ánɩ́ ɔmɔkʋsʋ́ lɩ́ɩ́ mlɩsʋ buo mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Brɛ́á nkɛá Bulu obótsu Yesu ya ɔsʋ́sʋ́ dɛkpʋkpɛ́ ba a, ɔlɔbwɛ agywɩɩn ánɩ́ ɔbɔ́yɔ Yerusalem kokooko. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɔlɔwa abí gyankpá yɔ́ Samaria wúlu kʋsʋ ɔbɛ́ɛ, bʋyɛ́la ɩnʋ yaɩ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Támɛ bʋmɔhɔ mʋ wúlu amʋtɔ, tsúfɛ́ Yerusalem ɔyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Brɛ́á mʋ akasɩ́pʋ́ Yakobo mʋa Yohane bowun alɩ á, bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Wíé, fʋdeklé fɛɛ ahá ogyá itsu ɔsʋ́sʋ́ bɔhɔ amʋ́ mɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Támɛ Yesu lɛ́damlí, wá ɩyɩn wá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mʋ́ʋ́ bɔpʋ ɔkpa yɔ́ wúlu bámbásʋ́ a. ");
INSERT INTO nkoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Brɛ́á bʋna ɔkpatɔ bɔyɔ́ á, oyin ɔkʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Nóbuo fʋ yɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á fɔyɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu lɛ́bláa oyin ámʋ ɔbɛ́ɛ, “Awɩá bʋbʋ mbɔ́, mbubwi ɛ́ bʋbʋ asia, támɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ mʋ́ á, mma ɔtɩ́nɛ́á nɔ́pʋ mɩ́ nwun tswɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu lɛ́bláa ɔha bambá ɛ́ ɔbɛ́ɛ, “Bobuo mɩ.” Támɛ oyin ámʋ lɛ́bláa mʋ ɔbɛ́ɛ “Owíé, ha mɩ́ anyopulá mɩ́ sɩ́ asa ambobuo fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Si awupʋ́ abʋpula amʋ́ afúli. Támɛ fʋ́ mʋ́ yɔ afʋyɛda Bulu iwíegyí ámʋ ɔkan.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɔkʋ ɛ́ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, nóbuo fʋ, támɛ ha mɩ́ anyinki yɛklá mɩ́ wóyítɔ́ ahá asa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔhá ánɩ́ ɔtɛsrɩ́ dámlí kɩ ɔma mɔ́fʋn ha Bulu iwíegyí ámʋtɔ agyʋ́má yɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɩ́nɩ ɔma a, Yesu lɛ́lɛ mʋ akasɩ́pʋ́ aduesienɔ́-nyɔ (72) akʋ ɛ́, ɔlɔwa amʋ́ abanyɔ́-abanyɔ́ ɔbɛ́ɛ bʋgyánkpa yɔ́ wúlugyíwúluá mʋ onutó mɔ́yɔ mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Atɔ kpɔtɩ́hɛ́ amʋ ɩtsɔ, támɛ mʋ́ akpɔtɩ́pʋ́ bʋmɔtsɔ́. Mʋ́ sʋ mlɩkokoli ndɔ mʋ wie, ɔwa akpɔtɩ́pʋ́ tsɔtsɔ abʋba bɔkpɔtɩ́ mʋ atɔ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mlɩnatɩ, mlɩbɩ ánɩ́ ndɛ mlɩ wa fɛ́ akúfabi ɔyɔ́ adúndutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mlɩmátsu sika kɛntɛ, akpankogyo ntɛ́ɛ ntʋkʋta kɩ́tá. Nɩ́ mlɩná ɔkpatɔ á, mlɩmálɩɩ́ tʋ́ntʋn ahá. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nɩ́ mlowíé wóyígyíwóyítɔ́á a, mlɩgyankpa bla amʋ́ mlɩaa, ‘Bulu ɔhá mlɩ iwilwii.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɩ́ wóyí mʋ wie amʋ tekle iwilwii a, mlɩ iwilwii bésin wóyí ámʋsʋ. Támɛ nɩ́ ɔtamakle iwilwii a, ɩbɛ́sankí bá mlɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mlɩtsia wóyí ámʋ́ʋ́ bɔhɔ mlɩ mʋ́tɔ́ ámʋtɔ. Mlɩgyi atɔ́, amlɩnu tógyítɔ́á bɛ́ha mlɩ, tsúfɛ́ agyʋ́má ɔyɔpʋ́ bʋtɛká ɩkɔ. Mlɩmátu láyétsiá wóyí bámbátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nɩ́ mlowíe wúlu kʋsʋ, bɔhɔ mlɩ á, mlɩgyi tɔ́á bɛ́ha mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mlɩtsa alɔpʋ ánɩ́ bʋbʋ wúlu amʋtɔ, amlɩbla wúlu amʋtɔ ahá mlɩaa, ‘Bulu iwíegyí lawíé wóyí tá.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Támɛ nɩ́ mlowíé wúlu kʋsʋ, bʋmɔhɔ mlɩ á, mlɩdalɩ yɛlɩɩ́ brɔnʋsʋ, amlɩblɩ mlɩaa, ");
INSERT INTO nkoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Anɩdɛ́ mlɩ wúlutɔ otútúu amʋ́ʋ́ ɩlawʋ́lɩ́ anɩ ayabiasɩ amʋ kʋ́ráá kpakpáa wʋlɩ́. Támɛ mlɩbɩ ánɩ́ Bulu iwíegyí ámʋ lawíé wóyí tá.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́bɩtɩ́ wúlu amʋtɔ ahá ɩsʋ dʋn Sodomfɔ mʋ asʋ́n ogyíkɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasinfɔ, mlɩgyɔwɩ. Betsaidafɔ, mlɩgyɔwɩ nɩ́. Nɩ́ Tiro pʋ́ Sidon awúlu laláhɛ amʋtɔ nɔbwɛ ofúla akpɔnkpɔntɩ ánfɩ nɔbwɛ mlɩtɔ ánfɩ á, tɛkɩ bʋda akpekpetɔ, bakpá nsúó wá nwuntɔ pʋ́súná ánɩ́ badámlí klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Támɛ mlɩbɩ ánɩ́ Bulu ɔbɛ́bɩtɩ́ mlɩ ɩsʋ mʋ asʋ́n ogyíkɛ́ dʋn Tiro mʋ́a Sidonfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mlɩ Kapernaumfɔ, mlɩdéklé mlɩaa mlótsu ɩwɩ fʋ́á alɩɩ yɔ́wɔ ɔsʋ́sʋ́? Ɛkɛkɛɛkɛ! Bulu ɔbɛ́ba mlɩ asɩ yówie afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu lɛ́bláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Ɔhá ánɩ́ ɔhɔ mlɩ asʋ́n lahɔ mɩ. Ɔhá ánɩ́ olekiná mlɩ asʋ́n hɔ lakíná mɩ́ asʋ́n hɔ. Ɔhá ánɩ́ olekiná mɩ́ asʋ́n hɔ ɛ́ lakíná mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ asʋ́n hɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Akasɩ́pʋ́ aduesienɔ́-nyɔ ámʋ beyinkí ba ansigyísʋ́. Bɛbláa Yesu bɛɛ, “Anɩ Wíé, nɩ́ akplʋ́n wa ɔŋɛ laláhɛ kʋ́ráá fʋ́ dátɔ́ a, bʋtobú anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nowun ánɩ́ Satan lɛ́kpa tsú ɔsʋ́sʋ́ fɛ́ alɩá nsaɩntɔ tɔfwɩ́ ɩbɩ bɛda ɔsʋlʋ́tɔ pɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mlɩnu! Nahá mlɩ túmi ánɩ́ mlɩtsatsa awɔ pʋ́ nyankpʋkpíesʋ tsʋn, amlɩgyi Ɔbʋnsám túmi fɛ́ɛ́sʋ́. Tɔtɔɔtɔ mɔ́ɔbwɛ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Támɛ ansɩ́ mágyi mlɩ ánɩ́ ɔŋɛ laláhɛ labú mlɩ. Mboún ansɩ́ igyi mlɩ ánɩ́ Bulu lawánlɩ́n mlɩ adá tswɩ ɔsʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Alɩ brɛ́ ámʋtɔ á, Ɔŋɛ Wankɩ́hɛ́ lɛ́ha ansɩ́ lɛhɩɛ gyi Yesu. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́, ɔsʋ́ mʋa asɩ Owíé! Nɛdá fʋ́ ɩpán ánɩ́ falɛ́ tɔ́á fɔpʋŋáín anyansapʋ pʋ́ asʋ́n abɩpʋ́ ɔwan súná ahá ánɩ́ bʋmeyín ɔlala, bʋgyi fɛ́ nyebí. Ee, Mɩ́ Sɩ́! Alɩ́ fʋdeklé fɛɛ ɩbá mʋ́tɔ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mʋ́ʋ́ ɔlɛbláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mɩ́ Sɩ́ lapʋ́ tógyítɔ́ wá mɩ́ ɩbɩtɔ. Ɔhaa méyín ɔhá ánɩ́ Obí ámʋ gyí, nkɛ́tɩ Ɔsɩ́ ámʋ nkʋlɛ. Ɔhaa méyín Ɔsɩ́ ámʋ ɛ́, nkɛ́tɩ Obí ámʋ, pʋ́ ɔhá ánɩ́ Obí ámʋ latsúlá ánɩ́ ɔbɛ́lɛ mʋ súná mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Brɛ́á ɔhaa má amʋ́ wá á, ɔlɛdamlí kɩ amʋ́, bláa amʋ́ ɔbɛ́ɛ, “Mlɩ mʋ́ á, Bulu layúlá mlɩ, mlɩdɛ́ atɔ́ ánfɩ wúun. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ pʋ́ awíe tsɔtsɔɔtsɔ bekle ánɩ́ bówun atɔ́ ánfɩ, abʋnu asʋ́n ánfɩ mlɩdénu, támɛ bʋmenya mʋ́ alɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mose mbla osunápʋ́ ɔkʋ lɔ́kʋsʋ́ lɩ́ɩ́ fɩ́tɛ́ Yesu asʋ́n ánfɩ pʋ́sɔ mʋ kɩ. Ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Osunápʋ́, ntɔ mbwɛ́ɛ asa anya nkpa ánɩ́ ɩtamatá?” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Nkálɩ Mose Mbla lɛ́blɩ́? Nkálɩ fonu mʋ́ asɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Oyin ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Pʋ fʋ́ klʋn, fʋ́ ɔkláa, fʋ́ ɔwʋnlɩ́n pʋ́ fʋ́ agywɩɩn fɛ́ɛ́ dwɛ fʋ́ Wíe Bulu, afʋdwɛ fʋ́ bá fɛ́ fʋ́ ɩwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mʋ́ fablɩ́ á. Bwɛ mʋ́, fénya nkpa ánɩ́ ɩtamatá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Támɛ oyin ámʋ lékléá obósuná ánɩ́ mʋ́ asʋ́n da ɔkpa. Mʋ́ sʋ ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Ma gyí mɩ́ bá?” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Brɛ́ kʋsʋ oyin ɔkʋ lɛ́kplɩ́ tsú Yerusalem ɔyɔ́ Yeriko. Brɛ́á ɔna ɔkpatɔ á, oleyéfia ogyo atswapʋ́ akʋ. Ahá ánfɩ bɛkpa mʋ tati, swɩ́ɩ́ mʋ atɔ́ fɛ́ɛ́, dá mʋ sian mʋ mɔ, nátɩ́ sí mʋ tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bulu igyí ɔhapʋ́ ɔkʋ ná ɔkpa ámʋ kɛ́nsʋ́. Brɛ́á olowun mʋ sɩ́sɩ́ á, ɔlɛbaɩ́ tsʋn ɩfʋ́ntɔ́ nátɩ́ sí mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Alɩ kɛ́n Lewiyin ɔkʋ ɛ́ lɔ́bɔtʋ mʋ, báɩ́ tsʋn ɩfʋ́ntɔ́ nátɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Támɛ Samariayin ɔkʋá ɔná ɔkpa ámʋsʋ mʋ́ lɛ́ba bowotií mʋsʋ. Brɛ́á olowun oyin ámʋ a, ɔlɔwa mʋ nwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔlɛnatɩ́ yɔ́tʋ mʋ. Ɔlɛtsɛɩ́ nta kpekplé wʋ́lɩ́ mʋ nlɔsʋ, yí ofobí wá mʋ́, klɩ́ mʋ́, tsú mʋ dɩ́nká mʋ afrímúsʋ́, pʋ́ mʋ ya afɔɔ́ ɔswɩɩ́kpá yɛ́kɩ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mʋ́ ɔyɩ kɛhɛ a, Samariayin amʋ lɛ́lɛ sika futútú anyɔ há afɔɔ́ ɔswɩɩ́kpá ɩnʋsʋ ɔkɩ́pʋ ɔbɛ́ɛ, ‘Kɩ mʋsʋ ha mɩ. Nɩ́ feyintá tɔkʋ tsɩ́a a, neyínkí nɛ́ka fʋ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu lɔ́mɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋ́ atɔ kɩhɛtɔ á, ahá abasá ánfɩtɔ ɔmɔmʋ gyí oyin ámʋ́ʋ́ olefia ogyo atswapʋ́ ámʋ mʋ ba?” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mose mbla osunápʋ́ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Oyin ámʋ́ʋ́ olowun mʋ nwɛ ámʋ.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mʋ́mʋ́ yɔ afʋyɔbwɛ mʋ́ odu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Brɛ́á Yesu mʋa mʋ akasɩ́pʋ́ bʋna ɔkpatɔ bɔyɔ́ Yerusalem a, bowie wúlu kʋsʋ. Ɔtsɩ ɔkʋá bʋtɛtɩ́ mʋ Marta lɔ́hɔ mʋ ɔfɔɔ́, ɔlɛkpa mʋ ya mʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mʋ pio tsɩhɛ́ gyí Maria. Maria anfɩ lébetsiá Yesu ayabiasɩ, ɔdɛ mʋ atosunáhɛ́ nu. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta nkʋlɛ dɛ́damlí tsʋn mʋ́tɔ́, alɩá ɩbɔ́bwɛ ɔbɔ́bwɛ amʋ́ afɔɔ́tɔ. Ɩlɔdʋn mʋ. Mʋ́ʋ́ ɔlɛnatɩ́ yɔ́ Yesu wá, yɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, fawun ánɩ́ mɩ́ píó lasí agyʋ́má ámʋ fɛ́ɛ́ tswɩ mɩ nkʋlɛsʋ? Bla mʋ ɔbɛtsa mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Óo Marta, Marta! Fʋdɛ fʋ́ ɩwɩ háan ntobí tsɔtsɔɔtsɔ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Toku kʋlɛ pɛ́ déhián, Maria lalɛ́ mʋ́á ɩbʋ alɛ́ dʋn. Ɔhaa mɛ́ɛtalɩ́ swɩ́ɩ́ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɛkɛ ɔkʋ Yesu bʋ ɔtɩnɛkʋ ɔdɛ mpáɩ bɔ. Brɛ́á ɔlɔbɔ mpáɩ ámʋ tá á, mʋ akasɩ́pʋ́ amʋtɔ ɔkʋlɛ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, suna anɩ mpáɩ bɔ fɛ́ alɩá Asú Ɔbɔpʋ́ Yohane lósuná mʋ akasɩ́pʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɔ́bɔ mpáɩ á, mlɩbɔ mʋ́ alɩ. ‘Anɩ Sɩ́, ahá bʋbúu fʋ́ dá. Ba begyi iwíe. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ha anɩ atogyihɛá ɩbɔ́fʋn anɩ ekekegyíɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Si anɩ lakpan kie anɩ, fɛ́ alɩá anɩtesíkíé ahá ánɩ́ bʋtɔpʋ́ ɩlá gyi anɩ. Mákpa anɩ wá ɩsɔ́kɩtɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɩtɔ ɔkʋ bʋ onyawíe a, ɔbɔ́kʋsʋ́ yɔ́ mʋ wá ɔyɩ́nsɩnɛ́ yɛ́bláa mʋ ɔbɛ́ɛ, ‘Mɩ́ nyáwíé, pan mɩ bodobodo apin asa. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mɩ́ nyáwíe ɔkʋ labɔswɩɩ́ mɩ́ sésééséi. Mma tɔtɔá nɛ́ha mʋ obégyi.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Mʋ nyawie amʋ ɔbɛ́bláa mʋ sɩ́sɩ́ ɔbɛ́ɛ, ‘Máwa mɩ́ tɔ́ɩ. Mɩ́a mɩ́ abí anɩladɩ́. Nafin obu, mmɛ́ɛtalɩ́ kʋ́sʋ́ bɛha fʋ́ tɔtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndɛ mlɩ bláa mbɛ́ɛ, fíalɩ onyawíe ɔkpasʋ á, ɔmɔ́ɔkʋsʋ́ há mʋ. Támɛ alɩá ɔdɛ mʋ kokóli kótóó sʋ á, ɔbɔ́kʋsʋ́ há mʋ alɩá odeklé. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, mlɩkʋlɩ Bulu, ɔbɛ́ha mlɩ. Mlɩdunka, mlówun. Mlɩda mʋ klʋnsʋ, obéfinkí mʋ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsúfɛ́ ɔhá ánɩ́ ɔtɔkʋ́lɩ́ atɔ́ tenyá. Ɔhá ánɩ́ otodúnká atɔ́ towun. Ɔhá ánɩ́ ɔtɛdá klʋnsʋ bʋ́tefínkí há. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ɔsɩ́ ɔmɔmʋ bʋ ɩnʋ, mʋ bi ɔkʋ́lɩ́ mʋ iye a, ɔbɛ́kɩtá ɩwɔ wá mʋ ɩbɩtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ntɛ́ɛ nɩ́ ɔkʋ́lɩ́ mʋ bɔnɔ a, ɔbɛ́kɩtá nyankpʋkpíe wá mʋ ɩbɩtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mlɩ lakpan abwɛpʋ́ kʋ́ráá mlɩyin alɩá bʋtɔpʋ́ atɔ wankláán há mlɩ abí. Ntogyi sʋ́ mlɩ Sɩ́ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ mʋ́ mɔ́ɔpʋ Ɔŋɛ Wankɩ́hɛ́ há ahá ánɩ́ bʋdɛ mʋ kʋlɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu légya ɔŋɛ laláhɛ lɛ́ oyin ɔkʋá alatɔ́ omúmutɔ. Brɛ́á ɔŋɛ laláhɛ amʋ lɛ́dalɩ a, oyin ámʋ lɔ́wa tɔɩ́ bɩ. Mʋ́ sʋ ɔnɔ́ lobwie ɔdɔm amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Támɛ amʋ́tɔ́ akʋ bɛblɩ́ bɛɛ, “Ɔŋɛ laláhɛ owíe Beelsebul túmi ɔdɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amʋ́tɔ́ akʋ ɛ́ bekleá bɔ́sɔ Yesu kɩ. Mʋ́ sʋ bɛbláa mʋ bɛɛ, ɔbwɛ́ɛ osúna pʋsuna ánɩ́ lɛ́lɛ́ otsú Bulu wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Támɛ Yesu lɛ́bɩ amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Iwíe ogyíkpá ánɩ́ ɩlaye anyɔ, bʋdɛ aba kɔ tɛdɩda. Wóyí oduá mʋ́tɔ́ atsiápʋ́ bʋdɛ aba kɔ ɛ́ tobwíé. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɩ́ Satan iwíe ogyíkpá labɔ́ɩ́ anyɔ, bʋdɛ aba kɔ á, mʋ iwíegyí bɛ́dɩda. Támɛ mlɩdɛ́blɩ́ mlɩaa, Beelsebul dátɔ́ ndɛ ɔŋɛ laláhɛ gyáa lɛ ahátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɩ́ Beelsebul túmi ndɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ á, mʋ́mʋ́ ma túmi mlɩ abí ɛ́ bʋdɛpʋgya ɔŋɛ laláhɛ lɛ́ ahátɔ? Mlɩ abí ámʋ onutó obégyi mlɩ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Támɛ ɩ́nɩá Bulu túmi ndɛpʋgya ɔŋɛ laláhɛ sʋ á, mlɩbɩ ánɩ́ Bulu iwíegyí ámʋ laba mlɩ wá dodo. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tsúfɛ́ nɩ́ ɔwʋnlɩ́npʋ́ bʋ akɔtɔ́, ɔdɛ mʋ wóyí gyo a, mʋ tɔtɔ tamafwɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Támɛ nɩ́ ɔhá ánɩ́ ɔbʋ ɔwʋnlɩ́n dʋn mʋ ɔbá begyi mʋsʋ á, ɔtɔswɩ́ɩ́ mʋ mʋ akɔtɔ́ ámʋ́ʋ́ mʋ ansɩ́ dɩn mʋ́sʋ́ ámʋ, yée mʋ atɔ́á olenya ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ɔhá ánɩ́ omobuo mɩ dɛ́ mɩ́ lu. Ɔhá ánɩ́ ɔmɛdɛ́ mɩ́ tsa akpa ahá ba Bulu ɛ́ dɛ́ amʋ́ gyáa tɛɩ́a mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nɩ́ ɔŋɛ laláhɛ ɩdálɩ ɔhatɔ á, iteyéki dimbísʋ́ dúnká otsiákpá, támɛ ɩtamanyá. Ɩnʋ ɩtɛblɩ́ ánɩ́ ibéyinkí yɔ́ mʋ́ wóyí dadatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nɩ́ ɩsánkí yɔ́ á, itowun ánɩ́ bafɛ́ɩ́ mʋ́tɔ́, lá mʋ́tɔ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iteyínkí yɛ́kpa mʋ́ aba asienɔ́ ánɩ́ bʋtɔbwɛ́ lalahɛ dʋn mʋ, bʋtɛba betsiá ɩnʋ. Ɩnʋ ɔhá ámʋ tsiátɔ́ teyíntá dʋn alɩá igyi yáɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Brɛ́á Yesu dɛ́ asʋ́n ánfɩ blɩ́ á, ɔtsɩ ɔkʋ bʋ ɔdɔm amʋtɔ. Ɔtsɩ ámʋ lótsu ɔmɛ fʋ́á blɩ́ ɔbɛ́ɛ, “Bulu layúlá opúni amʋ́ʋ́ fɛdɩ mʋ́tɔ́ pʋ́ nyɔ́pʋ amʋ́ʋ́ fɔnyɔpʋ́ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Támɛ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ahá ánɩ́ bʋtonú Bulu asʋ́n, gyí mʋ́sʋ́ mboún Bulu layúlá!” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Brɛ́á ɔdɔm amʋ bʋdemoní tsɩ́a a, Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Ndɛmba-abí laláhɛ, mlɩdɛ́ osúna dunká amlɩwun, támɛ mlɩmóowun kʋkʋʋkʋ dʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yona osúna amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tsúfɛ́ alɩ ámʋ́ʋ́ Yona lɔ́bwɛ osúna há Niniwefɔ ámʋ a, alɩ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ nɔ́bwɛ osúna há ndɛmba-abí nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Seba owíe tsɩhɛ́ ɔbɔ́kʋsʋ́ lɩ́ɩ́ Bulu asʋ́n ogyíkɛ́, há mlɩ ndɛmba-abí ánfɩ ɩpɔ́n. Tsúfɛ́ olotsu ɔsaasɩ́ ɔmá kʋtɔ kéín gya ɔkpa ba, bonu Salomo nyánsa atosunáhɛ́. Mlɩkɩ, ɔhá ánɩ́ ɔdʋn Salomo lɩ́ɩ́ nfɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwefɔ ɛ́ bɔ́kʋsʋ́ lɩ́ɩ́ Bulu asʋ́n ogyíkɛ́ amʋ, há mlɩ ndɛmba-abí ánfɩ ɩpɔ́n. Tsúfɛ́ brɛ́á Yona lɛ́da Bulu asʋ́n ɔkan súná amʋ́ á, bɛdamlí klʋntɔ ba Bulu wá. Mlɩkɩ, ɔhá ánɩ́ ɔdʋn Yona onutó lɩ́ɩ́ nfɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ɔhaa tamanywɛ́ ɔkandɩ́ɛ pʋ́ŋáín, ntɛ́ɛ pʋ́ ɔlɔ́ bun mʋ́sʋ́. Ɔfʋákpá ɔtɔpʋ́bian, mɛ́nɩ ɩbɔ́wankɩ́ há ahá ánɩ́ bɛ́ba wóyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fʋ́ ansíbi igyi ɔkandɩ́ɛ há fʋ́ nyankpʋsa-oyí. Nɩ́ fʋ́ ansíbi bʋ alɛ́ á, fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ bɔ́wankɩ́. Támɛ nɩ́ fʋ́ ansíbi ma alɛ a, fʋ́ nyankpʋsa-oyí ámʋ fɛ́ɛ́ ibóklun. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mʋ́ sʋ mlɩkɩ ánɩ́ wankɩ onutó bʋ́ mlɩtɔ, megyí oklún. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nɩ́ fʋ́ nyankpʋsa-oyí ámʋ lɔ́wankɩ́, oklún ma ɔtɩnɛtɩnɛ a, fʋ́ ɩwɩ fɛ́ɛ́ bɔ́wankɩ́ fɛ́ alɩá ɔkandɩ́ɛ tɔwánkɩ́ wʋ́lɩ́ fʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Brɛ́á Yesu lɔ́tɔɩ́ tá á, Farisiyin ɔkʋ lɛ́tɩ mʋ atɔ́ ogyíkpá mʋ wóyítɔ́. Mʋ́ sʋ Yesu lɔ́yɔ yétsiá ɔpʋ́nʋ́ ámʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ɩlɔwa Farisiyin amʋ wánwan ánɩ́ Yesu mɔ́fwɩ ɩbɩ pʋ́gyʋ́ra ɩwɩ asa ɔdɛ atɔ́ ámʋ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɩ́nɩ sʋ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mlɩ Farisifɔ mlɩtɔfwɩ́ mlɩ nwɛ pʋ́ mlɩ ablanwɛ́ wankláán, támɛ ɔnsɩ́pɛ mʋ́a owuntɔlɩn sɔ́ɔ́n lábʋ́lá mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mlɩ aha mimláhɛ, megyí mʋ́tɔ́ mʋ́a mʋ́ ɔma fɛ́ɛ́ Bulu lɔ́bwɛ? ");
INSERT INTO nkoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mlɩpʋ mlɩ atonyahɛ́ ámʋ ha ahiánfɔ, tógyítɔ́ ɩwɩ bɛ́tɩn ha mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisifɔ, mlɩgyɔwɩ nɩ́! Mlɩteye mlɩ ɔtsʋtsʋ́ pʋ́ kpántánkplámá aná fɛ́ɛ́tɔ́ idú, pʋ́ idúsɩ́ amʋ há Bulu. Támɛ mlɩmɛ́dɛ́ Bulu mbla ámʋ́ʋ́ ɩhɩ́ɛ́ dehián, igyi asʋ́ngyí ɔnɔkwalɩsʋ pʋ́ Buludwɛ ámʋsʋ gyí. Mʋ́déhián nɩ, támɛ mlɩmákiná iyétɔ dúsɩ́ amʋ ɛ́ ha. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisifɔ, mlɩgyɔwɩ nɩ́! Mlɩtekle otsiákpá yílé tsiá Yudafɔ ofíakpa. Mlɩtekle mlɩaa, ahá bʋbún ha mlɩ itsiá dɩnsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mlɩgyɔwɩ nɩ́! Mlɩlabwɛ́ fɛ́ ntsán ánɩ́ bʋmɛhɩɛ mʋ́ nsʋ, ahá bʋtɔtsʋn mʋ́sʋ́ bʋmeyín ánɩ́ ntsán igyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mose mbla asunápʋ́ amʋtɔ ɔkʋlɛ lɛ́bláa Yesu ɔbɛ́ɛ, “Osunápʋ́, nɩ́ fɛblɩ́ alɩ á, fasíá anɩ ɛ́ o.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mose mbla asunápʋ́, mlɩ ɛ́ mlɩgyɔwɩ nɩ́! Tsúfɛ́ mlɩtɔpʋ́ atɔ dwindwín sʋ́rá ahá, támɛ mlɩtamapʋ́ osrebi ɔkʋlɛ kʋ́ráá tsá amʋ́ sʋrá. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mlɩgyɔwɩ nɩ́! Tsúfɛ́ mlɩtɔpwɛ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ́ʋ́ mlɩ anáin bɔmɔ ámʋ ntsán wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɩ́nɩ désuná ánɩ́ mlɩlatsúlá dɩ́nká mlɩ anáin bwɛhɛ́ ámʋsʋ nɩ́. Tsúfɛ́ mlɩ anáin bɔmɔ amʋ́, mlɩ ɛ́ mlɩlapwɛ́ amʋ́ ntsán. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mʋ́ sʋ Bulu lɔ́pʋ mʋ nyánsa blɩ́ ɔbɛ́ɛ, ‘Nɔ́wa mɩ́ ɔnɔ́sʋ́ atɔɩ́pʋ́ pʋ́ mɩ́ sumbí ayɔpʋ́ amʋ́tɔ́. Bɔ́mɔ akʋ, dɩ́nká akʋ ɛ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bulu ɔbɛ́fɩtɛ́ mlɩ ndɛmba-abí ánfɩ mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́ ámʋ obugya amʋ́ʋ́ ɩlɔwʋlɩ́ asɩ tsú brɛ́á ɔyɩ́ lɛlɩn ɔpá ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ɔbɛ́fɩtɛ́ tsú Habel obugyasʋ alɩɩ bɔfʋn Sakaria klɛ́sʋ. Mʋ bɔmɔ afɔdɩɛ-asubwi mʋ́a Bulu ɔtswɛ́kpa amʋ nsɩnɛ́ nɩ́. Ee! Ndɛ mlɩ bláa mbɛ́ɛ, Bulu ɔbɛ́fɩtɛ́ mʋ́ tsú mlɩ ndɛmba-abí ánfɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mose mbla asunápʋ́, mlɩgyɔwɩ nɩ́! Tsúfɛ́ mlɩdɛ́ asʋ́nbɩ sáafɩ amʋ. Mlɩméfínkí wíé, mlɩmɛ́há ahá ɔkpa ɛ́ abʋwie.” ");
INSERT INTO nkoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Brɛ́á Yesu lɛ́natɩ́ ɩnʋ ɔyɔ́ á, Mose mbla asunápʋ́ pʋ́ Farisifɔ ámʋ bɔpʋ mʋ ɩwɩ ɔblɔ́, yɔ́ bʋdɛ mʋ asʋ́n tsɔtsɔɔtsɔ fɩtɛ́ pʋ́fɩ́nɩ mʋ yibi, ");
INSERT INTO nkoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kɩ bɛɛ bénya mʋ ɔnɔ́tɔ́ asʋankʋ pʋ́kɩ́tá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Igyi alɩ, brɛ́á ahá mpɩ́m-mpɩ́m bɛba befia ɩnʋ, bʋdɛ aba ayabiasɩ tsatsáa a, Yesu légyankpá dá mʋ akasɩ́pʋ́ amʋ ɔlá ɔbɛ́ɛ, “Mlɩkɩ wankláán Farisifɔ Bodobodotu-afásʋ́, tsúfɛ́ apinabwɛbí abwɛpʋ́ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tɔtɔ má ɩnʋá babun atɔ́ mʋ́sʋ́ ánɩ́ bʋmóobwií mʋ́sʋ́. Tógyítɔ́ ɛ́ ma ɩnʋá ileŋaín ánɩ́ ɩmɛ́ɛlɩn ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bɛ́da asʋ́n ánɩ́ mlɩlɛ́blɩ́ nklobítɔ ɔkan. Kugyíkʋá igyi, ɩplɔ́ bóbon. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Apíó aba, ndɛ mlɩ bláa mbɛ́ɛ, mlɩmánya nyankpʋsa ifú. Ɔbɛ́talɩ́ mɔ́ mlɩ ɔyʋlʋ́ʋ, támɛ ɔmɛ́ɛtalɩ́ bwɛ́ mlɩ tɔtɔ mʋ́ ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nósuná mlɩ ɔhá ánɩ́ mlɩnyá ifú. Mʋgyí Bulu. Mʋ ɔmɔ́ mlɩ ɔma a, ɔbʋ túmi tswɩ mlɩ ɔkláa ɛ́ wá ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ. Ee! Mʋ mlɩnyá ifú nɩ́! ");
INSERT INTO nkoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Afɩnɩ bʋtɔkʋkʋ fɛ akénsire anu kɛ́kɛ́? Megyí kɔ́ba ana? Amʋ́ kʋ́ráá á, Bulu tamatan ɔkʋkʋsʋ, ");
INSERT INTO nkoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","mɛ́nɩ bɛɛ mlɩá Bulu yin mlɩ nwunsʋ imi kʋ́ráá klátɔ. Mʋ́ sʋ mlɩmánya ifú. Mlɩbʋ ibíá dʋn akénsire tsɔtsɔɔtsɔ! ");
INSERT INTO nkoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ ɔkʋ lɛ́talɩ́ gyi mɩ́ ɩwɩ adánsɩɛ ahátɔ á, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ négyi mʋ ɩwɩ adánsɩɛ Bulu-abɔpʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Támɛ nɩ́ ɔkʋ lékiná mɩ́ ahátɔ á, mɩ́ ɛ́ nékiná mʋ Bulu-abɔpʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ɔhagyíɔha ánɩ́ ɔlɛblɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩwɩ asʋn laláhɛ a, Bulu ɔbɛ́talɩ́ sikíé mʋ. Támɛ nɩ́ ɔkʋ lɛ́blɩ́ Ɔŋɛ Wankɩ́hɛ́ amʋ ɩwɩ abususʋ a, Bulu méesikíé ndɛ, oméesikíé mʋ ɔkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nɩ́ bɛkpá mlɩ ya Yudafɔ ofíakpa, ntɛ́ɛ ɔmásʋ́ agyípʋ́ pʋ́ awíe ansɩ́tɔ́ á, mlɩmágywɩ́ɩn asʋ́n ánɩ́ mlɛ́blɩ́ pʋ́ká ɩwɩ lɛ́ ntɛ́ɛ alɩá mlɛ́lɛ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tsúfɛ́ Ɔŋɛ Wankɩ́hɛ́ amʋ obósuná mlɩ alɩá mlɛ́blɩ́ alɩ brɛ́ ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ɔdɔm amʋtɔ ɔkʋ lɛ́bláa Yesu ɔbɛ́ɛ, “Osunápʋ́, bla mɩ́ dɛ́hɛn, ɔha mɩ́a mʋnyɔ aye atɔ́á anɩ sɩ́ lési yáɩ́ anɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Támɛ Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Agya, ma lɛ́yaɩ́ mɩ́ asʋ́n ogyípʋ́ ntɛ́ɛ atɔ́tɔ́ oyépʋ há mlɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mʋ́ʋ́ ɔlɛbláa ahá ámʋ fɛ́ɛ́ ɔbɛ́ɛ, “Mlɩkɩ wankláán ɔnsɩ́pɛwasʋ, tsúfɛ́ nyankpʋsa nkpa ɩma atonyahɛ́ tsɔtsɔɔtsɔtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɩnʋ ɔlɛha amʋ́ yébi ɔbɛ́ɛ, “Osikani ɔkʋ ndɔtɔ atɔ́ lɛhɩɛ wá alɛ́ ofi ɔkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mʋ́ʋ́ ɔlɛfɩtɛ́ mʋ ɩwɩ ɔbɛ́ɛ, ‘Nkálɩ nɔ́bwɛ mɩ́ atɔ́-abí? Mma ɔtɩ́nɛ́á nɔ́pʋyáɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɩnʋ ɔlɛblɩ́ ɔbɛ́ɛ, ‘Nyin tɔ́á nɔ́bwɛ. Nóbwie mɩ́ ɩdan, láwá akpɔnkpɔntɩ. Mʋ́tɔ́ nɔ́pʋ mɩ́ atɩ́kɔ pʋ́ mɩ́ ntobí ámʋ wá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fówun nabláa mɩ́ ɔkláa mbɛ́ɛ, “Mɩ́ ɔkláa, ɩklʋn ɩdɩ́ fʋ́ asɩ. Kɩ, fʋbʋ atɔ́ tsɔtsɔɔtsɔá ɩda ha fʋ́ nfí-nfí. Gyi, afʋnu, ansɩ́ igyi fʋ.” ’ ");
INSERT INTO nkoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ɩnʋ Bulu lɛ́bláa mʋ ɔbɛ́ɛ, ‘Ɔha mimláhɛ! Onyenɩ ndɛ fʋ́ ɔkláa hɔ́ɔ lɛ fʋ́ ɩbɩtɔ. Ma obégyi atɔ́ ánfɩ fakle yáɩ́ ánfɩ fɛ́ɛ́?’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu lɔ́mɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Alɩ́ bɔ́bwɛ ɔhá ánɩ́ olekle atɔ́ yáɩ́ há mʋ ɩwɩ ɔsʋlʋ́ʋ anfɩsʋ, támɛ ɔma tɔtɔ Bulu wá nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɩnʋ Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, mlɩmáhan ɩwɩ tɔ́á mlégyi, tɔ́á mlónu pʋ́ tɔ́á mlɛ́dɩdá sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nyankpʋsa nkpa dehián dʋn atogyihɛ. Mʋ ɔyʋlʋ́ʋ ɛ́ ɩdʋn atɔ dɩdáhɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mlɩkɩ aklankpa. Bʋtamadú, bʋtamasɩ́ɛ́tɩ́ wá ɩdantɔ. Bʋma ɩdan ntɛ́ɛ ɩfa, támɛ Bulu tɛhá amʋ́ atogyihɛ. Mlɩmá labi dʋn mbubwi? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mlɩtɔ ma ɔbɛ́talɩ́ han ɩwɩ pʋ́ brɛ́ kpalobí tsɩ́a mʋ nkɛtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɩ́ mlɩmɛ́ɛtalɩ́ bwɛ́ ɩtɔ́ túkúrííbi ánfɩ kʋ́ráá á, ntogyi sʋ́ mlɩdɛ́ ɩwɩ háan tráhɛ amʋsʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mlɩkɩ alɩá pututɔ-oyí ntswɩ́tswɩ́ɩ tɛdan. Ɩtamayɔ́ agyʋ́má ntɛ́ɛ lʋ́ atati. Támɛ ndɛ mlɩ bláa mbɛ́ɛ, Owíe Salomo, mʋ inya fɛ́ɛ́tɔ́ a, ɔmɛtalɩ́ hɩ́hɩɛ ɩwɩ wá akɩ́lɛ fɛ́ oyí ntswɩ́tswɩ́ɩ anfɩtɔ kʋkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nɩ́ Bulu dɛ́ ɩfá ánɩ́ ndɛ ɩlɩɩ́, ɔkɛ ɩlawú, bawá mʋ́ ogyá tati dɩdá á, ɔmɛ́ɛtalɩ́ dɩ́dá mlɩ atati dʋn mʋ́? Ntogyi sʋ́ mlɩ hógyi mɔtsɔ́ alɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mʋ́ sʋ mlɩmágywɩ́ɩn tɔ́á mlégyi ntɛ́ɛ tɔ́á mlónu ɩwɩ, ɩha mlɩ ansɩ́ ɩpɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsúfɛ́ ɩ́nɩ aná ɔmá-ɔmá bʋtɛsrɩ́ gya nɩ. Mlɩ Sɩ́ ámʋ yin ánɩ́ ɩdɛ mlɩ hián. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɩtɔ́á mlɩgyánkpa dunka gyí Bulu iwíegyí, Bulu ɔbɔ́pʋ ɩ́nɩ tsɩ́a mʋ́tɔ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ɔpasua túkúrííbi, mlɩmánya ifú. Tsúfɛ́ ɩbʋ mlɩ Sɩ́ ámʋ ɔdwɛ ánɩ́ ɔbɔ́pʋ iwíe ogyíkpá amʋ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mlɩfɛ mlɩ ɩwɩsʋ atɔ́, amlɩpʋ kɔ́ba amʋ kie ahá ánɩ́ bʋma tɔtɔ. Mlɩbɩn akɛntɛá iméeyintá ha mlɩ ɩwɩ. Mʋ́gyí, mlɩyaɩ mlɩ siadɩɛ ɔsʋ́sʋ́. Ɩnʋ mʋ́ á, kʋkʋ mɛ́ɛdalɩ mʋ́tɔ́, tsúfɛ́ awikplu bʋma ɩnʋ, atɛ́plɛ ɛ́ bʋtamawɩ́ atɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tsúfɛ́ ɔtɩ́nɛ́á fʋ́ siadɩɛ bʋ a, ɩnʋ́ fʋ́ agywɩɩn tetsíá. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mlɩwa atadɩɛ, amlɩnywɛ mlɩ nkandɩ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mlɩbwɛ ɩwɩ fɛ́ asúmpʋ́á bʋdɛ amʋ́ wíe ɔkpa kɩ́ɩ, obótsu ɔká otsiákpá ba. Fɛ́kɩ nɩ́ ɔbá bɛda klʋnsʋ á, béfinkí há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ansɩ́ bégyi asúmpʋ́ oduá amʋ́ wíe ɔbɛ́ba bɔtʋ amʋ́ bʋtsie bʋgyo mʋ. Ɔnɔkwalɩ ndɛ mlɩ bláa. Amʋ́ wíe amʋ ɔbɛ́sabáa tati, há amʋ́ bétsiá ɔpʋ́nʋ́asɩ, mʋ onutó ɔbɔ́kɔnkɩ́ atogyihɛ amʋ há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ansɩ́ bégyi amʋ́, nɩ́ ɔbá bɔtʋ amʋ́ bʋtsie bʋgyo mʋ, ɔyɩ́nsɩnɛ́ ntɛ́ɛ bakɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Támɛ mlɩnu asʋ́n ánfɩ. Nɩ́ wóyí mʋ wie yin brɛ́á owikplu ɔbɛ́ba mʋ wóyítɔ́ a, tɛkɩ omesi wóyí ámʋ tswɩ, owikplu móbwie wíé wí mʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mlɩ ɛ́ mlɩgyo, tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́ba brɛ́á mlɩ ansɩ́ mɛdɩ́n mɩ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Anɩ nkʋlɛ fʋdɛ yébi anfɩ ha lóó, ntɛ́ɛ anɩa ahá ánfɩ fɛ́ɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Ma mɛɛ gyí osúmpʋ́á ɔlɛtɩn ansɩ́, ɔbʋ ɔnɔkwalɩ? Mʋ ɩbɩtɔ mʋ wie tɔpʋ́ mʋ aba atráhɛ wá, ɔbɛ́ɛ ɔhá amʋ́ atogyihɛ dɩnka brɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ansɩ́ bégyi osúmpʋ́ amʋ nɩ́ mʋ wie amʋ ɔbá bowun ánɩ́ lɛ́lɛ́ ɔdɛ mʋ́ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɔnɔkwalɩ ndɛ mlɩ bláa. Mʋ wie amʋ ɔbɔ́pʋ mʋ atɔ́ fɛ́ɛ́ wá mʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Támɛ nɩ́ osúmpʋ́ amʋ lɛ́blɩ́ wá nwuntɔ ɔbɛ́ɛ, ‘Mɩ́ wíe ɩbábɩ mɔkʋ́fʋn, ɔbɔ́wa ɔpá.’ Ɩ́nɩ sʋ olefi asɩ ɔdɛ mʋ aba asúmpʋ́ atsɩ mʋ́a ayin da, ɔdɛ atɔ́ gyí si amʋ́, ɔdɛ ntá núu bʋ á, ");
INSERT INTO nkoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mʋ wie amʋ ɔbɛ́ba bofwie mʋtɔ ɛkɛá ɔmɛdɩ́n ansɩ́. Mʋ wie amʋ ɔbɛ́hɩɛ tɩ́tɩ mʋtɔ, trá bɩtɩ́ mʋa ahá ánɩ́ bɔmɔhɔ mʋ gyi ɩsʋ kɛ́kɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Osúmpʋ́ oduá oyin tɔ́á igyi mʋ wie apɛ́, támɛ ɔmɛla ɩwɩ bwɛ́ yáɩ́ á, mʋ wie ɔbɛ́hɩɛ pɩ́tɩ́ mʋ atɔ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Támɛ osúmpʋ́á omeyín mʋ wie apɛ́, ɔlɔbwɛ tɔ́á ilehián ha atɔ́ pɩtɩ́ á, mʋ wie ɔbɛ́pɩtɩ́ mʋ kpalobí. Bulu tɛfɩ́tɛ́ tsɔtsɔ tsú ɔhá ánɩ́ ɔlɛha mʋ tsɔtsɔ wá, ɔtɛfɩ́tɛ́ tsɔtsɔɔtsɔ ɛ́ tsú ɔhá ánɩ́ ɔlɛha tsɔtsɔɔtsɔ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ogyá ɔdʋdákpá nɛba ɔsʋlʋ́ʋ anfɩsʋ. Nɩ́ mɩ́ nkʋlɛ sʋ mʋ́ á, tɛkɩ idetsií dodoodo. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Asúbɔ kʋ ɩda mɩsʋá bɔ́bɔ mɩ́. Mɩ́ klʋn mɛ́ɛdɩ mɩ́ asɩ yɔ́fʋn brɛ́á ɩlamɔ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɩmábwɛ mlɩ fɛ́ iwilwii nɔpʋba ɔsʋlʋ́ʋ anfɩsʋ. Megyí iwilwii, ahá nsɩnɛ́ yintá nɔpʋba. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tsúfɛ́ tsú séi pʋ́ya a, wóyí ánɩ́ ahá abanú bʋbʋ mʋ́tɔ́ á, abasá bɔ́kʋsʋ́ lɩ́ɩ́ abanyɔ́sʋ́. Abanyɔ́ ɛ́ bɔ́kʋsʋ́ lɩ́ɩ́ abasásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abi yinhɛ́ mʋ́a amʋ́ asɩ́ nsɩnɛ́ béyintá. Abi tsɩhɛ́ mʋ́a amʋ́ ayín ɛ́ nsɩnɛ́ béyintá. Osia tsɩhɛ́ mʋ́a mʋ sia tsɩ́hɛ́ nsɩnɛ́ ɛ́ béyintá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu lɛ́trá bláa ahá ámʋ ɔbɛ́ɛ, “Nɩ́ nyankpʋ obílá bʋsʋ á, mlɩtɛblɩ́ mlɩaa, ndɛ nyankpʋ obótswie, lɛ́lɛ́ ototswie. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɩ́ nsaɩntɔ itsú fʋ́á á, mlɩtɛblɩ́ mlɩaa, ndɛ owí ɔbɛ́lɩn, lɛ́lɛ́ ɩtɛlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Apinabwɛbí abwɛpʋ́! Mlɩyin alɩá bʋtɛlɛ́ ɔsʋlʋ́sʋ pʋ́ nwʋlʋ́táasʋ atɔ́ asɩ. Ntogyi sʋ́ mlɩmɛ́tálɩ́ nú ɩtɔ́ ánfɩ ɩdɛbá séi ánfɩ mʋ́ asɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ntogyi sʋ́ mlɩtamatálɩ́ gyí asʋ́n wankláán há mlɩ ɩwɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nɩ́ ɔkʋ ɔsáma fʋ á, wa ɔsa ha amlɩblɩ mʋ́ wóyítɔ́, mɛ́nɩ fʋ́ onyabá mɔ́ɔpʋ fʋ́ ya asʋ́n ogyíkpá. Fówun asʋ́n ogyípʋ́ méegyi fʋ́ asʋ́n, pʋ́ fʋ́ wá prósiyin ɩbɩtɔ, ɔwa fʋ́ obu. ");
INSERT INTO nkoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nɩ́ megyí alɩ á, mmɛ́ɛmlɛ́ fʋ́, nkɛ́tɩ faká tógyítɔ́ tá asa fɛ́dalɩ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ahá ámʋ́ʋ́ bʋbʋ ɩnʋ alɩ brɛ́ ámʋtɔ akʋ bɛbláa Yesu bɛɛ, Pilato lamɔ́ Galileafɔ akʋ brɛ́á bʋdɛ afɔdɩɛ bɔ há Bulu, Yerusalem Bulu ɔtswɛ́kpa ɩnʋ, há obugya lada afɔdɩɛ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩkɩ́ mlɩaa, Galileafɔ ánfɩ bʋgyi lakpan abwɛpʋ́ dʋn Galileafɔ atráhɛ, sʋ́ bowun ɩwɩɔsɩn ánfɩ odu? ");
INSERT INTO nkoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ndɛ mlɩ bláa mbɛ́ɛ, megyí alɩ ígyi! Nɩ́ mlɩ ɛ́ mlɩmɛ́damlí klʋntɔ á, mlɩ fɛ́ɛ́ mlówu fɛ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ntɛ́ɛ ahá dúkwe ámʋ́ʋ́ abansʋ́rʋ lobwie dá mɔ́ Siloam ɔmanti ánɩ́ ɩbʋ Yerusalemtɔ ámʋ mɛ́, mlɩkɩ́ mlɩaa, lakpan abwɛpʋ́ bʋgyi dʋn aha atráhɛ ánɩ́ betsiá Yerusalem alɩ brɛ́ ámʋtɔ fɛ́ɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ndɛ mlɩ bláa mbɛ́ɛ, megyí alɩ ígyi. Nɩ́ mlɩmɛ́damlí klʋntɔ á, mlɩ ɛ́ mlówu fɛ́ amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mʋ́ʋ́ ɔlɛha amʋ́ yébi ɔbɛ́ɛ, “Oyin ɔkʋ lótswíe pɔntɔ mʋ ndɔtɔ. Ɛkɛ ɔkʋ ɔlɔyɔ yɛ́kɩ bɛɛ, abí kʋ ɩdɩn mʋ́tɔ́. Ɔlɔyɔ á, kʋkʋ mɛdɩ́n mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ɩ́nɩ sʋ ɔlɛbláa mʋ ɔpayin ɔbɛ́ɛ, ‘Nfinsa nɩ́, nna oyí ánfɩ asɩ. Mmɔkʋ́wun kʋkʋʋkʋ mʋ́tɔ́. Ntogyi sʋ́ ɩbɛ́trá lɩɩ́ yíntá ɔsʋlʋ́ʋ? Kun mʋ́ da!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Támɛ ɔpayin amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, fʋ́ mʋ́ si mʋ́ ɩtra lɩɩ ofi ɔkʋlɛ, ampulipuli mʋ́ asɩ, kpa wúna wa mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nɩ́ ofíébá iloswie á, ɩbʋ alɛ́, támɛ nɩ́ imoswie á, nakun mʋ́ dá.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu lɔ́yɔ ɔdɛ atɔ́ suná Yudafɔ ofíakpa ɔkpʋ́nʋ́ ɔdakɛ́ ɩkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔtsɩ ɔkʋá ɔŋɛ laláhɛ lɔ́wa mʋ ɩlɔ nfí dúkwe nɩ́, ɩlahá mʋ alaklo, ɔmɛtálɩ́ bwíí nátɩ́ bʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Brɛ́á Yesu lówun mʋ á, ɔlɛtɩ mʋ bláa mʋ ɔbɛ́ɛ, “Anɩ yín, ɩwɩ ɩwá fʋ́ ɔnlɩn!” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ɩnʋ ɔlɔpʋ ɩbɩ da ɔtsɩ ámʋ. Ɩnʋnʋ olotswií lɩ́ɩ́ kánfʋ́ Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ofíakpa ɔhandɛ amʋ lénya ɔblɔ́ ánɩ́ Yesu latsá ɔha ɔkpʋ́nʋ́ ɔdakɛ́. Mʋ́ sʋ ɔlɛbláa ahá ámʋ ɔbɛ́ɛ, “Nkensíé bʋ ɩnʋ há agyʋ́má yɔ. Mlɩba nkɛ ámʋtɔ, abʋtsa mlɩ ɩlɔ. Megyí ɔkpʋ́nʋ́ ɔdakɛ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Anɩ Wíe Yesu lɛ́lɛ mɔ́ ɔnɔ́ ɔbɛ́ɛ, “Apinabwɛbí abwɛpʋ́! Mlɩtɔ okugyíɔkʋ tɔwɔ́ɩ́ mʋ nnantswie ntɛ́ɛ afrímú lɛ́ ɩbantɔ, pʋ́ amʋ́ ya ntsu onúkpa ɔkpʋ́nʋ́ ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mʋ́ ɩma alɛá mɩ́ mʋ́ nɛ́sankɩ́ Abraham mʋ na ánfɩ Ɔbʋnsám lakɩ́klɩ mʋ nfí dúkwe kɛ́kɛ́ ánfɩ ɔkpʋ́nʋ́ ɔdakɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mʋ asʋn blɩ́hɛ́ anfɩ lɛ́ha pɛ́lɩ lɛ́kɩtá mʋ alupʋ́ ámʋ, ansɩ́ légyi atráhɛ amʋ fɛ́ɛ́, ofúla kpɔnkpɔntɩ ámʋ́ʋ́ ɔdɛbwɛ ámʋ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɩnʋ Yesu lɛ́fɩtɛ́ ɔbɛ́ɛ, “Ntɔ Bulu iwíegyí ámʋ lɛlɩan? Ntɛ́ɛ ntɔ nɔ́pʋkápʋ́ mʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Igyi fɛ́ takyí-akpin ibí, oyin ɔkʋ lódu wá mʋ ndɔtɔ. Ɩlɛdan mlí oyi yilé, mbubwi bʋtogyónká mʋ́ abámbitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu lɛ́trá blɩ́ ɔbɛ́ɛ, “Ntɔ mpʋ́kapʋ Bulu iwíegyí ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Igyi fɛ́ Bodobodotu-afá ánɩ́ ɔtsɩ ɔkʋ lɔ́pʋtsɩ́á bodobodo nfúó kɛntɛ kʋlɛ, ɩlɛha mʋ́ ilotu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Brɛ́á Yesu ɔyɔ́ Yerusalem a, ɔlɔtsʋn nkudasɩ pʋ́ awúlusʋ. Ɔna ɔdɛ amʋ́ atɔ́ suná. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɔha ɔkʋ lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Owíé, ahá kpalobí kʋ obénya nkpa?” Yesu lɛ́bláa ahá ámʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mlɩbɔ mbɔ́dɩ́ amlɩtsʋn obu-ɔnɔ́ kplánhɛ amʋtɔ. Tsúfɛ́ ahá tsɔtsɔɔtsɔ bɔ́bɔ mbɔ́dɩ́ ánɩ́ bɔ́tsʋn wie ɩnʋ, támɛ bʋmɛ́ɛtalɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Támɛ nɩ́ wóyí mʋ wie ɔkʋ́sʋ́ fin obu ámʋ, mlɛbá bɛlɩɩ́ klʋn ɔma, dá klʋn amʋsʋ mlɩaa, ‘Owíé, finki ha anɩ!’ á, ɔbɛ́bláa mlɩ ɔbɛ́ɛ, ‘Mmeyín mlɩ, mmeyín ɔtɩ́nɛ́á mlotsú.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɩnʋ́ mlɛ́blɩ́ mlɩaa, ‘Anɩa fʋnyɔ létsiá gyi atɔ́, nú ntá, fetsiá súná atɔ́ anɩ dɩnsʋ!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Támɛ ɔbɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Mmeyín mlɩ. Mmeyín ɔtɩ́nɛ́á mlotsú. Mlɩnatɩ tɛɩ mɩ́sʋ́, mlɩ lalahɛ abwɛpʋ́ fɛ́ɛ́!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nɩ́ mlowun Abraham, Isak, Yakob pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ fɛ́ɛ́ bʋbʋ Bulu iwíe ogyíkpá, támɛ bʋmɛha mlɩ mʋ́ ɔkpa amlɩwie ɩnʋ á, ɩnʋ́ mlósu kpisíi nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ahá bótsu owí ɔdalɩkpa pʋ́ owí ɔkplɩ́wíékpá, bɩnasʋ mʋ́a gyɔpɩsʋ ba betsiá atɔ́ ogyíkpá Bulu iwíegyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ɔnɔkwalɩ, amapʋ akʋ bémlí agyankpapʋ. Agyankpapʋ akʋ ɛ́ bémlí amapʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ɩnʋ Farisifɔ akʋ bɛba Yesu wá bɛbláa mʋ bɛɛ, “Dalɩ Galilea ɔmátɔ́ nfɩ, tsúfɛ́ ɔmásʋ́ ogyípʋ́ Herode dékléá ɔbɔ́mɔ fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɛbláa ɔkpataku ámʋ mlɩaa, ‘Négya ɔŋɛ laláhɛ lɛ́ ahátɔ, tsá ahá ɩlɔ ndɛ, gya lɛ ɔkɛ, mɔ́ mʋ́ ɔnɔ́ kláɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Támɛ ilehián ánɩ́ nɔ́yɔ mɩ́ ɔnátɩ amʋsʋ ndɛ, ɔkɛ mʋ́a kláɩ. Tsúfɛ́ ɔkpa má ɩnʋá bɔ́mɔ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋkʋ ɔtɩnɛtɩnɛ, dʋn Yerusalem! ");
INSERT INTO nkoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Óo Yerusalemfɔ, Yerusalemfɔ! Mlɩtɔ́mɔ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́, dá abí ánɩ́ Bulu lawá sɩ́sɩ́ mlɩ abwi mɔ́ nɩ́. Ntekleá nóbun mlɩ abísʋ́ brégyíbrɛ́, fɛ́ alɩá batɛ tobun mʋ abísʋ́, támɛ mlɩtamahá mɩ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mlɩkɩ, Bulu obési mlɩ ɔtswɛ́kpa tswɩ mlɩ. Ndɛ mlɩ bláa mbɛ́ɛ, mlɩmɛ́ɛtrá wun mɩ ɛkɛkɛɛkɛ, yɔ́fʋn ɛkɛá mlɛ́blɩ́ mlɩaa, ‘Bulu oyúla ɔhá ámʋ́ʋ́ ɔbá mʋ dátɔ́’ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Farisifɔ ɔhandɛ ɔkʋ lɛ́tɩ Yesu atɔ́ ogyíkpá mʋ wóyítɔ́ ɔkpʋ́nʋ́ ɔdakɛ́. Ahá bɔpʋ ansɩ́ yi Yesusʋ, bʋdɛ mʋ tɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɩnʋ oyin ɔkʋá alapúnyá lɛ́ba Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu lɛ́fɩtɛ́ Mose mbla asunápʋ́ pʋ́ Farisifɔ ámʋ ɔbɛ́ɛ, “Anɩ mbla lɛ́ha ɔkpa ánɩ́ bʋtsáa ɩlɔ ɔkpʋ́nʋ́ ɔdakɛ́ lóó, ntɛ́ɛ ɩmɛha ɔkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amʋ́tɔ́ ɔkʋkʋ móbwií ɔnɔ́. Mʋ́ʋ́ Yesu lɛ́kɩtá oyin ámʋ, tsá mʋ ɩlɔ, olesi mʋ ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɩnʋ ɔlɛfɩtɛ́ ahá ámʋ ɔbɛ́ɛ, “Mlɩtɔ ma mʋ bi ntɛ́ɛ mʋ ɔnantswie ɔbɛ́kpadá wíé ibúntɔ́ ɔkpʋ́nʋ́ ɔdakɛ́, ɔmɔ́ɔkɔsɩ́ lɛ́ mʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bʋmɛtalɩ́ lɛ́ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ɩnʋ Yesu lówun ánɩ́ ahá ámʋ́ʋ́ bɛtɩ atɔ́ ogyíkpá ɩnʋ ámʋtɔ akʋ bʋdɛ otsiákpá yilé dunká bétsiá. Mʋ́ʋ́ ɔlɛha amʋ́ yébi ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nɩ́ ɔkʋ ɔtɩ́ fʋ́ ɔká otsiákpá a, máyétsiá ɔfʋákpá. Fíalɩ ɔlɛtɩ ɔhandɛ ɔkʋá ɔdʋn fʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɩnʋ ɔhá ámʋ́ʋ́ ɔlɛtɩ mlɩ ámʋ ɔbɛbláa fʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, kʋsʋ pʋ obíá ha ɔhá ánfɩ.’ Ɩnʋ pɛ́lɩ bɛ́kɩtá fʋ́, fɛ́pɛtɩ́ yódunká ɔtɩnɛkʋ tsíá. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mʋ́ sʋ nɩ́ ɔha ɔtɩ́ fʋ́ atɔ́ ogyíkpá a, yetsiá obíá kusubisʋ mboún, ɔhá ámʋ ɔbɛbláa fʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, betsiá ɔfʋákpá nfɩ.’ Ɩ́nɩ obótsu fʋ́ ansɩ́tɔ́ fʋ́á ahá ámʋ fɛ́ɛ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsúfɛ́ ɔhagyíɔha ánɩ́ ototsú ɩwɩ á, Bulu tɛba mʋ asɩ. Ɔhagyíɔha ánɩ́ ɔtɛba ɩwɩasɩ ɛ́ á, Bulu totsú mʋ fʋ́á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu lɛ́bláa ɔhá ámʋ́ʋ́ ɔlɛtɩ mʋ atɔ́ ogyíkpá amʋ ɛ́ ɔbɛ́ɛ, “Nɩ́ fɔtswɩ ɔpʋ́nʋ́ ɔpa onyé á, mátɩ fʋ́ anyawíe, fʋ́ apíó, fʋ́ abusuanfɔ ntɛ́ɛ ɩwɩ anyapʋ́á bʋtsie mantáa fʋ́. Nɩ́ fɔbwɛ́ mʋ́ alɩ á, amʋ́ ɛ́ bɛ́latɩ́ fʋ́ amʋ́ klɛ asɩ ká ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mboún tɩ ahiánfɔ, tsukʋlɛ asínpʋ, abubúpʋ pʋ́ ansibi abwiepʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bulu obóyulá fʋ́, tsúfɛ́ bʋma tɔtɔá bɔ́pʋká fʋ́ ɩkɔ. Bulu ɔbɛ́ka fʋ́ ɩkɔ ɛkɛá ɔbɔ́kʋsʋ́a aha yilé tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ahá ámʋ́ʋ́ amʋ́a Yesu bʋtsie ɔpʋ́nʋ́asɩ ámʋtɔ ɔkʋlɛ lónu mʋ asʋn blɩ́hɛ́ anfɩ, ɔlɛblɩ́ ɔbɛ́ɛ, “Ansɩ́ bégyi ahá ánɩ́ bégyi atɔ́ Bulu ɔpʋ́nʋ́ ɔtswɩ́kɛ mʋ iwíegyí ámʋtɔ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Támɛ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Oyin ɔkʋ lɔ́tswɩ ɔpʋ́nʋ́ kpɔnkpɔɔnkpɔntɩ kʋ, ɔlɛtɩ ahá tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Brɛ́á bɛnɩná atogyihɛ amʋ tá á, ɔlɔwa mʋ asúmpʋ́ ɔbɛ́ɛ bʋyɛ́bláa ahá ámʋ́ʋ́ ɔlɛtɩ ámʋ bɛɛ, ‘Babwɛ́ tá!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Támɛ amʋ́ fɛ́ɛ́ bɛblɩ́ bɛɛ amʋ́ ɩbɩ dɛ. Ogyankpapʋ ɔbɛ́ɛ, ‘Nahɔ ɔsʋlʋ́ʋ kʋ. Ilehián ánɩ́ nɛ́yɛ́kɩ mʋ́. Mʋ́ sʋ mlɩkɩta mʋ́tɔ́ ha mɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Onyɔɔsɩ ɛ́ ɔbɛ́ɛ, ‘Nahɔ nnantswie yínhɛ́ idú, bópulipúli mɩ́ ndɔtɔ há mɩ́. Nɛyɛ́kapʋ́ amʋ́ kɩ. Mʋ́ sʋ mlɩkɩta mʋ́tɔ́ ha mɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ɔbambá ɛ́ ɔbɛ́ɛ, ‘Nwɛ́ɛn kótóó netsiá ɔká. Mʋ́ sʋ mmɛ́ɛtalɩ́ ba.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ɩnʋ osúmpʋ́ amʋ léyinkí bɛbláa mʋ wie. Ɔblɔ́ lɛkɩtá mʋ wie amʋ, ɔlɛbláa mʋ ɔbɛ́ɛ, ‘Wa ɔsa srɩ yeki dɩnsʋ pʋ́ brɔnʋsʋ, afʋkpa ahiánfɔ, tsukʋlɛ asínpʋ, ansibi abwiepʋ́ pʋ́ abubúpʋ ba.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ɩmɔwa ɔpá osúmpʋ́ amʋ lɛ́ba bɛbláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, nayɔ́ sumbí ámʋ, támɛ otsiákpá trá da.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mʋ wie amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Tsʋn mmuátse mʋ́a nkpakwí fɛ́ɛ́. Tɩ ɔhagyíɔha ánɩ́ fówun fɛɛ ɔbá, mɛ́nɩ ahá bɔ́bʋlá mɩ́ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nɛkásɛ, ahá ámʋ́ʋ́ nɛhɩɛ tɩ́ ámʋtɔ ɔkʋkʋ mɛ́ɛda mɩ́ atɔ́ ánfɩ ɔnɔ́!’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu mʋa ɔdɔm kpɔnkpɔɔnkpɔntɩ ámʋ ná bɔyɔ́. Mʋ́ʋ́ ɔlɛdamlí bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ɔhagyíɔha ánɩ́ ɔlɛba mɩ́ wá, támɛ ɔdɛ mʋ sɩ, mʋ yin, mʋ otsiába, mʋ abí, mʋ apíó, mʋ onutó kʋ́ráá ɩwɩ dwɛ dʋn mɩ á, ɔmɛ́ɛtalɩ́ bwɛ́ mɩ́ ɔkasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɔhá ánɩ́ omotsu mʋ oyikpalíhɛ bobuo mɩ mɔ́fʋn ánɩ́ ɔbɔ́bwɛ mɩ́ ɔkasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mlɩtɔ ɔmɔmʋ bʋ́ ɩnʋ, nɩ́ obéyi obu kpɔnkpɔntɩ á, oméetsiá asɩ kɩ tɔ́á obéyintá, wun ánɩ́ mʋ kɔ́ba bɔ́fʋn? ");
INSERT INTO nkoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nɩ́ ɔmɛkɩ mʋ́ alɩ, asa ɔlɔkʋsʋ́ wá obu ámʋ ntswɩasɩ, pwɛ́ mʋ́ fʋn ɔkpatɔ, ɔmɛtalɩ́ mɔ́ mʋ́ ɔnɔ́ á, obu ámʋ awúnpʋ fɛ́ɛ́ bɔ́mɔsɩ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bɛ́blɩ́ bɛɛ, ‘Oyin ánfɩ lɔ́kʋsʋ́ ɔdɛ obu yíi, ɔmɛtalɩ́ mɔ́ mʋ́ ɔnɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ntɛ́ɛ owíe ɔmɔmʋ bʋ ɩnʋá nɩ́ owíe ɔkʋ dɛ́ akɔpʋ́ mpɩ́m-adʋanyɔ (20,000) ɔbá bɔkɔ mʋ a, oméetsiá asɩ kɩ alɩá ɔbɔ́bwɛ ɔbɔ́pʋ mʋ ɩsá akɔpʋ́ mpɩ́m-dú (10,000) yéfia amʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nɩ́ owun ánɩ́ ɔmɛ́ɛtalɩ́ á, ɔbɔ́wa abí ɔsasʋ bóyókokóli mʋ há ɩkʋlɛbwɛ, brɛ́á bʋmɔkʋ́nyá kpʋ́kpɛ́ ba. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɩ́nɩ sʋ mlɩtɔ ɔhá ánɩ́ omesi mʋ tógyítɔ́ ɔmagyáa ɔmɛ́ɛtalɩ́ bwɛ́ mɩ́ ɔkasɩ́pʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nfɔ́lɩ bʋ alɛ́, támɛ nɩ́ ɩtá ɔdwɛ á, ntɔ bɛ́lapʋ́wá mʋ́ ɔdwɛ? ");
INSERT INTO nkoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɩtráa ma alɛ há tɔtɔɔtɔ bwɛ. Tsɛɩ́ bʋtɛtsɛ́ɩ́ mʋ́ tsítsá wúnasʋ. Ɔhá ánɩ́ ɔbʋ asʋ onúu asʋ́n ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɛkɛ ɔkʋ lampóo ahɔ́pʋ pʋ́ lakpan abwɛpʋ́ bɛba Yesu asʋn blɩ́hɛ́ onukpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisifɔ pʋ́ Mose mbla asunápʋ́ amʋ bowuntí mʋ bɛɛ, “Oyin ánfɩ mʋa lakpan abwɛpʋ́ tɛ́nátɩ́, bʋtɔwá ɩbɩ gyi atɔ́ kʋ́ráá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mʋ́ sʋ Yesu lɛ́ha yébi pʋ́súná amʋ́ atɔ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mlɩtɔ ma bʋ́ akúfa lafakʋlɛ (100), ɔkʋlɛ ɔfwɩ́ á, omesi adukwebá-kwebá (99) tráhɛ wá dimbítɔ́ ɩnʋ, yódunká mʋ alɩɩ kpɛ́fʋn brɛ́á obówun mʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nahogyi mbɛ́ɛ, nɩ́ owun mʋ a, ansɩ́ bégyi mʋ, obótsu mʋ wá nkɔnkɔ, ");
INSERT INTO nkoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","pʋ́ mʋ ya wóyítɔ́. Ɔbɛ́tɩ mʋ anyawíe pʋ́ mʋ aba, bláa amʋ́ ɔbɛ́ɛ, ‘Mlɩha anya ansigyí. Nawun mɩ́ kufa amʋ́ʋ́ ɔlɔfwɩ ámʋ!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Alɩ kɛ́n ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ lakpan ɔbwɛpʋ́ ɔkʋlɛ pɛ́ ɔdámlí klʋntɔ á, ansɩ́ bɛ́hɩɛ gyi ahá ɔsʋ́sʋ́ ɩnʋ dʋn alɩá ibégyi amʋ́ aha wankláán adukwebá-kwebá (99) ánɩ́ bʋmɛtrá hián klʋntɔdamlí ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ntɛ́ɛ nɩ́ ɔtsɩ ɔkʋ bʋ sika futútú dú, mʋ́tɔ́ kʋlɛ lafwɩ́ á, omóonywɛ ɔkandɩ́ɛ kɩkɩ mʋ wóyítɔ́ wankláán, kpákpá ntobítɔ́ kɩ, fɛ́ɩ́ wóyí ámʋtɔ wankláán yɔ́fʋn brɛ́á alawun mʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nɩ́ owun mʋ́ á, ɔbɛ́tɩ mʋ apíó aba, bláa amʋ́ ɔbɛ́ɛ, ‘Mlɩha anya ansigyí. Nawun mɩ́ sika futútú ámʋ́ʋ́ ɩlɔfwɩ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ndɛ mlɩ bláa mbɛ́ɛ, alɩ́ ansɩ́ bɛ́hɩɛ gyi Bulu-abɔpʋ nɩ́ lakpan ɔbwɛpʋ́ ɔkʋlɛ ɔdámlí klʋntɔ nɩ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu lɛ́trá ha amʋ́ yébi ɔbɛ́ɛ, “Oyin ɔkʋ létsiá, ɔbʋ abi yinhɛ́ anyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɔkʋsʋ amʋ lɛ́bláa mʋ sɩ ɔbɛ́ɛ, ‘Mɩ́ sɩ́, ye fʋ́ atɔ́tɔ́, afʋpʋ mɩ́ klɛ́ ha mɩ.’ Ɩnʋ mʋ sɩ lɛ́kɩtá mʋ atɔ́tɔ́ ye há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Imegyi nkɛ kʋkʋ ɔkʋsʋ amʋ lɔ́kʋlá mʋ atɔ́ fɛ́ɛ́, olotu ɔkpa yɔ́ tsútsúútsú ɔmá kʋtɔ. Ɩnʋ oleyétsiá nkpa laláhɛ yíntá mʋ atɔ́ ámʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Brɛ́á oleyintá atɔ́ ámʋ tá á, akʋ́n kpɔnkpɔntɩ kʋ lɛ́ba ɔmá ámʋtɔ, ɔlɔwa akʋ́n dɩ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mʋ́ sʋ ɔlɔpʋ ɩwɩ yɛ́mantá ɩnʋyin ɔkʋsʋ, oyin ámʋ lɛ́kpa mʋ yáa mʋ ibúasɩ ɔbɛ́ɛ, ɔyɛ́kɩ mʋ mprákuosʋ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tɛkɩ olekleá obétsiá gyi mprákuo atogyihɛ amʋ kʋ, támɛ ɔhaa mɛ́ha mʋ mʋ́ ɩwɩ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Brɛ́á mʋ ansɩ́ leyinkí ba mʋ ɩwɩsʋ á, ɔlɛfɩtɛ́ mʋ ɩwɩ ɔbɛ́ɛ, ‘Apafɔ amɔmʋ kʋ́ráá má mɩ́ sɩ́ wóyítɔ́, bʋmɛdɛ́ atɔ́ gyí sian ekekegyíɛkɛ? Mʋ́ ntsie nfɩ, akʋ́n dɛ mɩ́ mɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nɔ́kʋsʋ́ yínkí yɔ́ mɩ́ sɩ́ wá, yɛ́bláa mʋ mbɛ́ɛ, mɩ́ sɩ́, napʋ́ ɩlá gyí Bulu, pʋ́gyi fʋ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mmɛkanáa ánɩ́ fɛ́trá tɩ mɩ́ fʋ́ bí. Pʋ mɩ́ bwɛ́ɛ fʋ́ apafɔ ámʋtɔ ɔkʋlɛ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mʋ́ sʋ ɔlɔkʋsʋ́ pʋ́ ɔkpa ɔbá mʋ sɩ wá. “Brɛ́á olowotií, mʋ sɩ lówun mʋ sɩ́sɩ́ á, ɔlɔwa mʋ nwɛ, ɔlɛsrɩ́ yéfia mʋ, látá mʋ pútá. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɩnʋ mʋ bi ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Mɩ́ sɩ́, napʋ́ ɩlá gyí Bulu, pʋ́gyi fʋ́ ɛ́. Mmɛkanáa ánɩ́ fɛ́trá tɩ mɩ́ fʋ́ bí.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Támɛ mʋ sɩ lɛ́tɩ mʋ asúmpʋ́, bláa amʋ́ ɔbɛ́ɛ, ‘Mlɩwa ɔsa yotsu atadɩɛ wankláán ámʋ bɔwa mʋ. Mlɩwa mʋ opetia, amlɩwa mʋ ntʋkʋta. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mlɩyɛlɛ ɔnantswie yínhɛ́ kánáhɛ amʋ́ʋ́ alawá nfɔ ámʋ ba, amlɩbɔmɔ mʋ, apʋgyi nkɛ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tsúfɛ́ mɩ́ bí ánfɩ lawú tsínkí. Ɔlɔfwɩ, anɩlawun mʋ.’ Ɩnʋ bɔwa nkɛ gyí bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Alɩ brɛ́ ámʋtɔ á, obi dɛhɛn amʋ bʋ ndɔtɔ. Brɛ́á olotsu ndɔ ámʋtɔ ɔbá, alatá wóyítɔ́ wie tá á, olonu ánɩ́ pléi dɛ wóyítɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mʋ́ sʋ ɔlɛtɩ mʋ sɩ asúmpʋ́ amʋtɔ ɔkʋlɛ, fɩ́tɛ́ ɔbɛ́ɛ, ‘Amansʋ lába?’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Osúmpʋ́ amʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Fʋ́ píó laba. Mʋ́ sʋ fʋ́ sɩ́ lahá bamɔ́ ɔnantswie kánáhɛ amʋ, tsúfɛ́ alayínkí bɔtʋ mʋ, ɔbʋ nkpa, ɔbʋ ɔnlɩn.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ɔblɔ́ lɛkɩtá ɔdɛ́hɛn amʋ. Mʋ́ sʋ olesin mmuáa. Mʋ sɩ lɛ́dalɩ ba bokokóli mʋ ɔbɛ́ɛ, ɔbá wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Támɛ ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Mɩ́ sɩ́, kɩ nfí dʋ́dʋ́ʋ́dʋ́á napʋ́tsíá fʋ́ wá súm fʋ́. Mmɔkʋ́bwɛ́ mábúla kʋkʋ kɩ. Támɛ fʋmɔkʋ́há mɩ́ ɔkpalábi fɛɛ mɩ́a mɩ́ aba apʋ́wa ɩwɩ ansigyí kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Támɛ fʋ́ bí ánfɩ alayíntá fʋ́ tógyítɔ́, mʋa akipʋ́ bayégyi nkpa ánfɩ mʋ́ laba a, famɔ́ ɔnantswie yinhɛ́ kánáhɛ amʋ́ʋ́ alawá nfɔ ámʋ há mʋ!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɩnʋ mʋ sɩ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Mɩ́ bí, yɛ́ɛ fʋ́ mʋ́ fʋ́bʋ mɩ́ wá brégyíbrɛ́. Fʋ́bʋ́ mɩ́ atɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Fʋ́ píó ánfɩ lawú tsínkí. Ɔlɔfwɩ, anɩlawun mʋ. Mʋ́ sʋ lehián ánɩ́ abégyi mʋ́ nkɛ, nyá ansigyí.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Ɩwɩ onyapʋ́ ɔkʋ létsiá, ɔbʋ agyʋ́másʋ́ ɔkɩ́pʋ. Ahá bowi tsá mʋ wie amʋsʋ bɛɛ ɔdɛ mʋ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɩ́nɩ sʋ ɔlɛtɩ oyin ámʋ, fɩ́tɛ́ mʋ ɔbɛ́ɛ, ‘Ntɔ asʋ́n ndenu tsú fʋ́ ɩwɩ alɩ? Bobu akúnta ha mɩ, tsúfɛ́ fʋmɛ́ɛtrá kɩ mɩ́ agyʋ́másʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Agyʋ́másʋ́ ɔkɩ́pʋ amʋ lɛ́fɩtɛ́ mʋ ɩwɩ ɔbɛ́ɛ, ‘Nkálɩ nɔ́bwɛ? Mɩ́ wíe ɔbá begya mɩ. Mma ɔwʋnlɩ́n ánɩ́ nɛ́natɩ́ dɔ ha ahá. Ɩbʋ mɩ pɛ́lɩ ánɩ́ nɛ́natɩ́ kʋ́lɩ́ atɔ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɩbʋ alɛ́! Nyin tɔ́á nɔ́bwɛ, mɛ́nɩ nɩ́ osí mɩ́ á, nénya ahá ánɩ́ bɔ́hɔ mɩ wá amʋ́ wóyítɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Mʋ́ sʋ ɔlɛtɩ ahá ánɩ́ bʋdɛ mʋ wie ɩkɔ kʋlɛkʋlɛ. Ɔlɛfɩtɛ́ ogyankpapʋ ɔbɛ́ɛ, ‘Ɩkɔ afɩnɩ fʋ́dɛ mɩ́ wíe?’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɩkɔ ɔkɩtápʋ́ amʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Nfɔ agbɔngbɔ́ lafa-anyɔ (200).’ Agyʋ́másʋ́ ɔkɩ́pʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Tsan fʋ́ adánsɩɛ ɔwʋlʋ́ ámʋtɔ, afʋwanlɩn lafakʋlɛ (100).’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɔlɛfɩtɛ́ ɔkʋ ɛ́ ɔbɛ́ɛ, ‘Ɩkɔ afɩnɩ fʋ́dɛ?’ Ɩkɔ ɔkɩtápʋ́ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Bodobodo nfúó akɛntɛ ɔpɩ́m-ɔkʋlɛ (1,000).’ Agyʋ́másʋ́ ɔkɩ́pʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Tsan fʋ́ adánsɩɛ ɔwʋlʋ́ ámʋtɔ afʋwanlɩn lafakwe (800).’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Osikani ámʋ lɛ́kanfʋ́ agyʋ́másʋ́ ɔkɩ́pʋ anfɩ́ ɔma ɔnɔkwalɩ ánfɩ ánɩ́ alatálɩ́ tɩn ansɩ́ alɩ.” Yesu lɔ́mɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ndɛmba-abí ánɩ́ bʋbuo ɔyɩ́tɔ́ atɔ́ ansɩtɩ́ɩn ánɩ́ bɔpʋ bʋtsie amʋ́ abatɔ ɩdʋn amʋ́á bʋyin Bulu klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ndɛ mlɩ bláa mbɛ́ɛ, mlɩpʋ ɔyɩ́tɔ́ atɔ́ bwɛ apíó, mɛ́nɩ nɩ́ ɩtá á, Bulu ɔbɔ́hɔ mlɩ wá mʋ wóyíá ɩbʋ ɩnʋ brɛ́ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɔhá ánɩ́ ɔlɛtalɩ́ kɩ́tá atɔ́ túkúrííbi, olegyi ɔnɔkwalɩ mʋ́sʋ́ á, mʋ kɛ́n obégyi ɔnɔkwalɩ atɔ́ kpɔnkpɔntɩ ɛ́sʋ́ nɩ. Támɛ ɔhá ánɩ́ ɔmɔwa ɔnɔkwalɩ atɔ́ túkúrííbisʋ ɔmɔ́ɔwa ɔnɔkwalɩ atɔ́ kpɔnkpɔntɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʋ́ sʋ nɩ́ mlɩmá ɔnɔkwalɩ ɔyɩ́tɔ́ atɔ́sʋ́ a, ma mɛɛ ɔbɔ́hɔ mlɩsʋ gyi, pʋ́ ɔsʋ́sʋ́ atɔ́ onutó wá mlɩ ɩbɩtɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ntɛ́ɛ nɩ́ fʋma ɔnɔkwalɩ ɔkʋ klɛ́sʋ á, ma mɛɛ ɔbɔ́pʋ fʋ́ klɛ́ há fʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Osúmpʋ́ ɔkʋkʋ mɛ́ɛtalɩ́ súm awie anyɔ. Ɔbɔ́dwɛ ɔkʋlɛ, lú ɔkʋlɛ. Ntɛ́ɛ obóbu ɔkʋlɛ, omóobu ɔkʋlɛ. Fʋmɛ́ɛtalɩ́ súm Bulu, súm Kɔ́ba.” ");
INSERT INTO nkoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisifɔ bʋtɔdwɛ́ kɔ́ba. Mʋ́ sʋ brɛ́á bonu Yesu asʋn blɩ́hɛ́ anfɩ á, bɔbwɛ mʋ ahinlá. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩtɛlɛ́ ɩwɩ súná ánɩ́ aha yilé mlɩgyí ahá ansɩ́tɔ́, támɛ Bulu mʋ́ yin mlɩ klʋntɔ. Tsúfɛ́ tɔ́á nyankpʋsa tɛkɩá ɩbʋ labi igyi Bulu akisítɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose Mbla ámʋ pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋn wanlɩ́nhɛ́ lɔyɔ agyʋ́má alɩɩ bɔfʋn Asú Ɔbɔpʋ́ Yohane brɛ́sʋ́. Tsú mʋsʋ bʋdɛ Bulu iwíegyí ámʋ ɩwɩ asʋn wankláán ɔkan da, ahá ɛ́ bʋdɛprɩ́ɩ wie mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ɔsʋ́ mʋ́a asɩ bɛ́talɩ́ mɔ́ ɔnɔ́, támɛ itoduáhɛ́ ntɛ́ɛ asʋ́nbi ɩkʋlɛ kʋ́ráá móowu Mose Mbla ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oyin okíná mʋ ka láyétsiá ɔtsɩ bámbá á, alatɔ́ mbʋa. Oyingyíoyin ánɩ́ otsía ɔtsɩ ánfɩ mʋ kulu lakíná mʋ ɛ́ latɔ́ mbʋa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɩwɩ onyapʋ́ ɔkʋ létsiá. Atati wʋlɩhɛ ɔtɛdɩ́dá, otegyi nkpa wankláán ekekegyíɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Atɔ́ ɔkʋ́lɩ́pʋ́ ɔkʋá mʋ ɩwɩ letsitsíí nlɔ ɛ́ létsiá. Bʋtɛtɩ́ mʋ Lasaro. Betsiá pʋ́ ohiáni ánfɩ yɛ́yaɩ́ ɩwɩ onyapʋ́ ámʋ ɔkpa ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔkɩá obénya atogyihɛ mpupubiá ɩbɛ́kpakpáa bun oyin ámʋ ɔpʋ́nʋ́asɩ gyi. Akɩ́aɩ létsiá beyintá mʋ nlɔ ámʋ kʋ́ráátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Brɛ́á ohiáni ánfɩ lówu á, Bulu-abɔpʋ botsu mʋ ya, oleyétsiá anɩ náin Abraham wá ɔsʋ́sʋ́. Ɩwɩ onyapʋ́ ánfɩ ɛ́ lóbowu, bopulá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ɔlɔyɔ ɔbʋ ɩsʋbɩtɩ́ ogyá ánɩ́ ɩtamaduntɔ, ɔdɛ ɩwɩɔsɩn wúun. Olotsu ansɩ́ fʋ́á, olowun ánɩ́ Lasaro tsie Abraham wá tsútsúútsú. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɩnʋ ɔlɔkplʋ́n ɔbɛ́ɛ, ‘Anɩ sɩ́ Abraham-ée! Wun mɩ nwɛ, afʋha Lasaro ɔyɔpʋ mʋ osrebi da ntsutso pʋbɛda mɩ́ ɔdandʋsʋ, ilwii kpalobí. Ndɛ ɩwɩɔsɩn wúun ogyá ánfɩtɔ dʋbɩ!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Támɛ Abraham lɛ́bláa mʋ ɔbɛ́ɛ, ‘Obí, kaɩn, fʋ́ nkpatsiátɔ́ a, fegyi ɔdwɛ, Lasaro ɛ́ letsiá ɔsɩntɔ. Séi á, ɔbʋ ɔdwɛtɔ, fʋ́ ɛ́ fʋ́bʋ ɔsɩntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɔma a, ɩlán kpɔnkpɔɔnkpɔntɩ kʋ da anɩa fʋnyɔ nsɩnɛ́. Mʋ́ sʋ ɔhaa mɛ́ɛtalɩ́ fá tsú nfɩ ba fʋ́ wá ɩnʋ, ɔhaa ɛ́ mɛ́ɛtalɩ́ fá tsú ɩnʋ ba anɩ wá nfɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Oyin ámʋ lɛ́bláa Abraham ɔbɛ́ɛ, ‘Mʋ́mʋ́ nobwíí ɩpa, anɩ sɩ́ Abraham, wa Lasaro sɩsɩ mɩ́ sɩ́ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mbʋ apio yinhɛ́ abanú akʋ ɩnʋ, ɔyɛda amʋ́ ɔlá, mɛ́nɩ bowú á, bʋmɛ́ɛba bowun ɩwɩɔsɩn ánfɩ odu.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Mose mʋa Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ nwʋlʋ́ bʋ amʋ́ wá, ɩdɛ amʋ́ ɔlá da. Bʋnúu mʋ́, abʋgyi mʋ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Oyin ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, ‘Anɩ sɩ́ Abraham, asʋ́n ámʋ nu kɛkɛ mɛ́ɛha amʋ́ abʋdamli klʋntɔ. Mboún nɩ́ ɔkʋ ɔkʋ́sʋ́ tsú afúlitɔ yɔ́ amʋ́ wá á, bɛ́damlí klʋntɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Támɛ Abraham lɛ́bláa mʋ ɔbɛ́ɛ, ‘Nɩ́ bʋmegyi Mose mʋa Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ nwʋlʋ́tɔ́ asʋ́n ámʋsʋ á, ɔkʋ ɔkʋ́sʋ́ tsú afúlitɔ yɔ́ ɩnʋ kʋ́ráá á, bʋmóonu ɔhá ámʋ asʋ́n.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu lɛ́bláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Ɩbwɛ́bwɛ́ɛ́bwɛ́ á, tɔkʋ bɛ́ha nyankpʋsa ɔbɔ́bwɛ lakpan, támɛ ɔhá ánɩ́ ɩna mʋsʋ mʋ ba lɔ́bwɛ lakpan ɔgyɔ́wɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nɩ́ ɔkʋ lɛ́ha ahá ánfɩ bʋmɔkʋ́dan mɩ́sʋ́ hógyitɔ ánfɩtɔ ɔkʋ lɔ́bwɛ lakpan á, nɩ́ bɛda nfúókwɛbʋ síán mʋ ɔmɛtɔ, tswɩ mʋ wá ɔpʋ okluklúkpá pó á, ɩbʋ alɛ́ dʋn. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mʋ́ sʋ mlɩkɩ mlɩ ɩwɩ wankláán. “Nɩ́ fʋ́ bá ɔpʋ́ ɩlá gyi fʋ á, wa ɩyɩn wa mʋ. Nɩ́ ɔlɛdamlí klʋntɔ á, sikie mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nɩ́ ɔlɔpʋ ɩlá gyi fʋ tse sienɔ́ ɛkɛwʋ́lɛ owítɔ́, ɔlɛla bobwií ɩpa há fʋ́ á, sikie mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu sumbí ayɔpʋ́ ámʋ bɛbláa mʋ bɛɛ, “Ha anɩ hógyi imoni tsɩa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ mlɩ hógyi lómoní fɛ́ takyí-akpin ibí á, mlɛ́talɩ́ bláa kɛlɩ ánfɩ mlɩaa, ‘Puli yɛlɩɩ́ ɔpʋtɔ.’ Ɩbɔ́bwɛ dɩ́nká mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nɩ́ mlɩtɔ ɔkʋ bʋ osúmpʋ́á ɔtɔyɔ́ agyʋ́má mʋ ndɔtɔ ntɛ́ɛ ɔtɛkɩ mʋ akúfasʋ, otsú agyʋ́mátɔ́ ba a, bláa mʋ wie tɛbláa mʋ ɔbɛ́ɛ, ‘Wa ɔsa bwɛ afʋgyi atɔ́?’ Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bláa ɔtɛbláa mʋ ɔbɛ́ɛ, ‘Tsu tati saba, afʋbɔtswɩ ɔpʋ́nʋ́ ha mɩ. Bɛlɩɩ́ mɩ́ angyi atɔ́. Negyi ta á, fayégyi fʋ́ klɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɔtɛdá osúmpʋ́ amʋ ɩpán ɔbɛ́ɛ, alabwɛ́ tɔ́á mɔwa mʋ bwɛ? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɩ́nɩ sʋ nɩ́ mlɩ ɛ́ mlɔbwɛ́ tɔ́á bɔwa mlɩ bwɛ tá á, mlɩblɩ mlɩaa, ‘Asúmpʋ́ kɛkɛ anɩgyí. Tɔ́á igyi anɩ bwɛhɛ́ anɩlabwɛ́ á.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu ná Samaria pʋ́ Galileafɔ ɔkasʋ ɔyɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Brɛ́á ɔlɛta wúlu kʋsʋ wie tá á, ɩlɔ pɛpɛ alɔpʋ́ dú akʋ bʋna bɛbá befia mʋ, besi lɩɩ́ tsútsú. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ɩnʋ bɔkplʋ́n blɩ́ bɛɛ, “Yesu! Owíé! Wun anɩ nwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu lótsu ansɩ́ kɩ amʋ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩpʋ mlɩ ɩwɩ yosuná Bulu igyí ɔhapʋ́.” Brɛ́á bɔpʋ ɔkpa bɔyɔ́ á, amʋ́ ɩwɩ lɛ́plɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ɔkʋlɛ mʋ́ lówun ánɩ́ mʋ ɩwɩ laplɩ́ɩ a, oleyinkí ɔdɛkplʋ́n kanfʋ́ Bulu kʋ́klʋ́kʋ́ʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Olebemlí bún Yesu ayabitɔ, ɔdɛ mʋ ɩpán da. Samariayin oyin ánfɩ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ɩnʋ Yesu lɛ́fɩtɛ́ ɔbɛ́ɛ, “Megyí ahá idú natsá? Mʋ́ kwebá atráhɛ mɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mʋ́ sʋ amʋ́tɔ́ ɔkʋkʋ mɛ́ba bɛkanfʋ́ Bulu dʋn Samariayin ɔfɔɔ́ ánfɩ nkʋlɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɩnʋ ɔlɛbláa oyin ámʋ ɔbɛ́ɛ, “Kʋsʋ natɩ. Fʋ́ hógyi latsá fʋ́ ɩlɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisifɔ akʋ bɛfɩtɛ́ Yesu bɛɛ, “Ɔmɛnkɛ Bulu iwíegyí ámʋ ɩbɛ́ba?” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Megyí tɔ́á ɔha ɔbɔ́pʋ ansíbi wun Bulu iwíegyí ámʋ igyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɔhaa mɛ́ɛtalɩ́ blɩ́ ɔbɛ́ɛ, ‘Kɩ, mʋ́bʋ nfɩ.’ Ntɛ́ɛ ‘Mʋ́bʋ nána á.’ Tsúfɛ́ mlɩ klʋntɔ Bulu iwíegyí amʋ bʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɩnʋ Yesu lɛ́bláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Ɛkɛ ɔkʋ ɩbá, mlódunká ánɩ́ mlówun mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛkɛwʋ́lɛ pɛ́, támɛ mlɩmóowun mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ahá bɛ́bláa mlɩ bɛɛ, ‘Ɔbʋ nfɩ.’ ntɛ́ɛ ‘Ɔbʋ nána,’ támɛ mlɩmásrɩ́ buo amʋ́ yɛ́kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tsúfɛ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɔbákɛ bɔ́bwɛ fɛ́ alɩ ámʋ́ʋ́ nyankpʋ tɔfwɩ́ ɩbɩ, bʋtowun mʋ́ nsaɩntɔ fɛ́ɛ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Támɛ négyankpá wun ɩwɩɔsɩn tsɔtsɔɔtsɔ, ndɛmba-abí ánfɩ ɛ́ békiná mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Alɩ ámʋ́ʋ́ ilegyi Noa brɛ́sʋ́ amʋ a, alɩ́ ibégyi mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɛ́ ɩbábɩ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ahá betsiá, bʋdɛ atɔ́ gyí, bʋdɛ ntá núu; bʋdɛ aká tsiá, bʋdɛ atsɩ kɩ́tá há akúlu alɩɩ yɔ́fʋn ɛkɛá Noa lówie mʋ dáka kpɔnkpɔntɩ ámʋtɔ, ntsu lɔ́bʋlá bɔmɔ amʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Alɩ kɛ́n ɩlɛba Lot ɛ́ brɛ́sʋ́ nɩ. Ahá betsiá, bʋdɛ atɔ́ gyí, bʋdɛ ntá núu, bʋdɛ atɔ́ hɔ́ɔ, bʋdɛ atɔ́ fɛ; bʋdɛ atɔ́ du, bʋdɛ ibu yíi, ");
INSERT INTO nkoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","yɔ́fʋn ɛkɛá Lot lɛ́dalɩ Sodom wúlutɔ, ogyá mʋ́a atonkodu lotswie tsu ɔsʋ́sʋ́ bɛhɩ amʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Alɩ́ kɛ́n mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩwɩɔwanlɛkɛ́ bófwie ahátɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ɛkɛ ámʋ a, ɔhá ánɩ́ ɔdɩn obusʋ, mʋ atɔ́ ɩbʋ obuto ɔmákplɩ́ botsu tɔtɔ. Alɩ kɛ́n ɔhá ánɩ́ ɔbʋ ndɔtɔ ɛ́ máyinkí botsu tɔtɔ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mlɩkaɩn Lot mʋ ka asʋ́nsʋ́! ");
INSERT INTO nkoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tsúfɛ́ nɩ́ ɔkʋ lódunká ánɩ́ ɔbɛ́prɩ mʋ nkpa á, ɔbɔ́hʋlɩ́ɩ mʋ́. Támɛ nɩ́ ɔkʋ lɔ́hʋlɩ́ɩ mʋ nkpa á, ɔbɛ́lanyá mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndɛ mlɩ bláa mbɛ́ɛ, alɩ ɛkɛ ámʋ onyé á, nɩ́ ahá abanyɔ́ bʋda ɔklan kʋlɛsʋ á, Bulu obótsu ɔkʋlɛ sí ɔkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","“Nɩ́ atsɩ abanyɔ́ bʋdɛ nfúó kwɛ á, Bulu obótsu ɔkʋlɛ sí ɔkʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Wíe, nkʋ́nʋ́ ɩbɛ́ba?” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔtɩ́nɛ́á ɩtɔ wuhɛ́ da a, ɩnʋ́ alása bʋtefia nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ɩnʋ Yesu lɛ́ha yébi kʋ pʋ́súná ánɩ́ bʋbɔ́ɔ mpáɩ brégyíbrɛ́, ɩmákpɔn amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Asʋ́n ogyípʋ́ ɔkʋ létsiá wúlu kʋsʋ. Ɔtamanyá Bulu ifú, ɔtamanyá ɔhaa ɛ́ pɛ́lɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɔsʋrapʋ ɔkʋ ɛ́ létsiá wúlu amʋtɔ. Oletsiá bokokóli mʋ ɔbɛ́ɛ, ogyíi mʋ asʋ́n ɔnɔkwalɩsʋ ha mʋ, ɔlɛ mʋ tsu mʋ olupʋ́ ɩbɩtɔ! ");
INSERT INTO nkoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tɛkɩ olekle okina, támɛ ɔma-ɔma a, ɔlɛbláa mʋ ɩwɩ ɔbɛ́ɛ, ‘Ɩbʋ mʋ́tɔ́á ntamanyá Bulu ifú, ntamanyá ɔhaa ɛ́ pɛ́lɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Támɛ alɩ ánfɩ ɔsʋrapʋ anfɩ ná ɔdɛ mɩ́ háan anfɩ sʋ á, négyi mʋ asʋ́n ɔnɔkwalɩsʋ. Nɩ́ megyí alɩ á, oméesi mɩ́ tɔ́ɩ wa. Ɔmɛ́ɛha mméenya ɔkpa bwɛ́ tɔtɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesu lɔ́yɔ mʋ́sʋ́ ɔbɛ́ɛ, “Mlɩkɩ alɩá asʋ́n ogyípʋ́ anfɩ́ ɔtamagyi asʋ́n ɔnɔkwalɩsʋ ánfɩ lablɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mʋ́mʋ́ nkálɩ Bulu mʋ́ méegyi mʋ ahá ámʋ́ʋ́ alalɛ́, bʋdesú kpolí mʋ ɔpa-onyé ámʋ asʋ́n ɔnɔkwalɩsʋ? Obési amʋ́ asʋ́n wá obíátɔ́? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ndɛ mlɩ bláa mbɛ́ɛ, obégyi mʋ́ ɔnɔkwalɩsʋ há amʋ́ ɔsasʋ. Támɛ ndɛfɩtɛ́ mbɛ́ɛ, nɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ neyínkí bá a, nówun ahógyipʋ akʋ ɔsʋlʋ́ʋ anfɩsʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu lɛ́trá ha yébi kʋ pʋ́súná amʋ́ atɔ́ tsú ahá ánɩ́ bʋtɛkɩ amʋ́ ɩwɩ yilé abwɛpʋ́ dʋn amʋ́ aba. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ɔlɛha yébi amʋ ɔbɛ́ɛ, “Ayin abanyɔ́ akʋ bɔdʋ yɔ́ mpáɩ ɔbɔkpá Bulu ɔtswɛ́kpa. Amʋ́tɔ́ ɔkʋlɛ gyí Farisiyin, ɔkʋlɛ ɛ́ gyí lampóo ɔhɔ́pʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Farisiyin amʋ lɔ́kʋsʋ́ lɩ́ɩ́, bɔ́ mpáɩ wá nwuntɔ ɔbɛ́ɛ, ‘Bulu, nɛdá fʋ́ ɩpán ánɩ́ mmegyí fɛ́ akʋ. Mɩ́ mʋ́ mma ɔnsɩ́pɛ, ntamasísi ɔha, ntamatɔ́ mbʋa, mmegyí fɛ́ Lampóo ɔhɔ́pʋ anfɩ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ntɛklɩ́ ɔnɔ́ tse nyɔ ndawɔ́tswɩ́ ɩkʋlɛtɔ. Nteye mɩ́ atɔ́ fɛ́ɛ́tɔ́ dú, lɛ́ idúsɩ́ há fʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Támɛ lampóo ɔhɔ́pʋ amʋ mʋ́ lɛ́yɛlɩɩ́ tsútsú, oloko nwuntɔ wá. Omotsulá tsú ansɩ́ kʋ́ráá fʋ́á kɩ ɔsʋ́sʋ́. Ɔlɔpʋ ɔbɩmáa dá ɩbɩtɔ, kókóli Bulu ɔbɛ́ɛ, ‘Óo Bulu, wun mɩ nwɛ, lakpan ɔbwɛpʋ́ ngyi.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu lɔ́mɔ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ndɛ mlɩ bláa mbɛ́ɛ, asa beyinkí yɔ́ wóyí á, Bulu ansɩ́ légyi lampóo ɔhɔ́pʋ amʋ ɩwɩ dʋn Farisiyin amʋ. Tsúfɛ́ ɔhá ánɩ́ ototsú ɩwɩ á, Bulu ɔbɛ́ba mʋ asɩ. Ɔhá ánɩ́ ɔtɛba ɩwɩasɩ ɛ́ á, Bulu obótsu mʋ fʋ́á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aha akʋ bɔpʋ amʋ́ abí ba Yesu bɛɛ, ɔpʋ́ʋ ɩbɩ dɩnka amʋ́sʋ́, oyula amʋ́. Mʋ akasɩ́pʋ́ bowun amʋ́. Mʋ́ sʋ bɔwa ɩyɩn wá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Támɛ Yesu lɛ́tɩ nyebí ámʋ ba mʋ ɩwɩ wá, ɔlɛbláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha nyebí ámʋ abʋba mɩ́ wá. Mlɩmátin amʋ́ ɔkpa, tsúfɛ́ ahá ánfɩ odu bʋ́ Bulu iwíegyí amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhá ánɩ́ ɔmɔhɔ Bulu iwíegyí ámʋ fɛ́ kebi á, omóowie mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɛkɛ ɔkʋ Yudafɔ ɔhandɛ ɔkʋ lɛ́bɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Osunápʋ́ yilé, ntɔ nɔ́bwɛ asa nénya nkpa ánɩ́ ɩtamatá?” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntogyi sʋ́ fʋdɛ mɩ́ tɩ ɔha yilé? Ɔhaa mégyí ɔha yilé, nkɛ́tɩ Bulu nkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yɛ́ɛ fʋyin Bulu mbla ámʋ o. Mʋ́gyí, mátɔ mbʋa, mámɔ ɔha, máwi atɔ́, máka asʋ́n dɩ́nká fʋ́ básʋ́, bu fʋ́ sí mʋa fʋ́ yín.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɔhandɛ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Tsú mɩ́ nyebitɔ ɔpá ndɛ mʋ́ fɛ́ɛ́sʋ́ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu lónu mʋ asʋn blɩ́hɛ́ anfɩ á, ɔlɛbláa mʋ ɔbɛ́ɛ, “Toku kʋlɛ ɩlasí ánɩ́ fɔ́bwɛ. Yɛfɛ fʋ́ ɩwɩsʋ atɔ́ fɛ́ɛ́, afʋye kɔ́ba amʋ ha ahiánfɔ, mɛ́nɩ fénya siadɩɛ ɔsʋ́sʋ́. Fɔbwɛ́ mʋ́ tá á, ba afʋbobuo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Brɛ́á oyin ámʋ lónu asʋ́n ánfɩ á, ɩlɔtɔ mʋ klʋn, tsúfɛ́ ɔhɩ́ɛ́ ɔbʋ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu lówun ánɩ́ ɩlahan mʋ. Mʋ́ sʋ ɔlɛblɩ́ ɔbɛ́ɛ, “Ɩbʋ ɔnlɩn asa ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lɛ́lɛ́ mʋ́ á, ɩlɔpɔn ha kpɔ́sɔ́ ánɩ́ ɔbɔ́tsʋn ɔbɩn-atɔ ɔbɔ́tɔ́, dʋn ánɩ́ ɩwɩ onyapʋ́ obówie Bulu iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ahá ánɩ́ bonu asʋ́n ánfɩ bɛfɩtɛ́ bɛɛ, “Mʋ́mʋ́ ma mɛɛ Bulu ɔbɔ́hɔ nkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Tɔ́á nyankpʋsa mɛ́ɛtalɩ́ bwɛ́ mɔdʋ́n Bulu bwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ɩnʋ Petro lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíe, kɩ, anɩlasí anɩ wóyí tswɩ bobuo fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhaa má ɩnʋá obési mʋ wóyí, mʋ ka, mʋ apíó, mʋ akwɩɩ́pʋ́ ntɛ́ɛ mʋ abí tswɩ Bulu iwíegyí ámʋ sʋ, ");
INSERT INTO nkoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Bulu mɛ́ɛlawá mʋ́ otsiákpá há mʋ tsé dú tsé lafa séi, láha mʋ nkpa ánɩ́ ɩtamatá brɛ́ ámʋ́ʋ́ ɩbá ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu lɛ́tɩ akasɩ́pʋ́ dúanyɔ ámʋ ya ɩtsɛ́tɔ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ayɔ́ Yerusalem. Ɩnʋ́ asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɔwanlɩ́n tsú mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɩwɩ ámʋ fɛ́ɛ́ bɛ́ba mʋ́tɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bɛ́lɛ mɩ́ há ahá ánɩ́ bʋmegyí Yudafɔ. Bɔ́bwɛ mɩ́ ahinlá, síá mɩ́, tú atsʋnɔ́ wʋ́lɩ́ mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɛ́pɩtɩ́ mɩ́ atɔ́, mɔ́ mɩ́. Mʋ́ ɛkɛ sáásɩ́ a, nɔ́kʋsʋ́ tsú afúlitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Akasɩ́pʋ́ amʋ bʋmonu ɩ́nɩ asɩ, tsúfɛ́ Bulu lɔ́pʋŋáín amʋ́. Bʋmɛbɩ tɔ́á ɔdɛblɩ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu lɛ́ta Yeriko wúlutɔ wie tá á, ansibi obwiepʋ́ ɔkʋ tsie ɔkpa ɔnɔ́, ɔdɛ atɔ́ kʋlɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ansibi obwiepʋ́ ámʋ lónu ánɩ́ ɔdɔm bʋdɛtsʋ́ʋn. Mʋ́ʋ́ ɔlɛfɩtɛ́ ɔbɛ́ɛ, “Amansʋ igyi?” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ahá bɛbláa mʋ bɛɛ, “Yesu Nasaretyin amʋ dɛ́tsʋ́ʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɩnʋ ansibi obwiepʋ́ ámʋ lɔ́kplʋn blɩ́ ɔbɛ́ɛ, “Anɩ wíe Dawid mʋ na Yesu, wun mɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ahá ámʋ́ʋ́ bʋgya Yesu nkpá ámʋ bɔkplʋ́n wa ansibi obwiepʋ́ ámʋ bɛɛ, ɔwáa ɔsa kpa ɔnɔ́ bun. Ɔlɛlakplʋ́n dʋn alɩ ɔbɛ́ɛ, “Anɩ wíe Dawid mʋ na, wun mɩ nwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu lési lɩɩ́, ɔlɛha ɔbɛ́ɛ bʋkpá mʋ ba mʋ. Brɛ́á bɛkpa mʋ ba a, Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ntɔ fʋdeklé fɛɛ mbwɛ́ɛ ha fʋ?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Owíe, ha mɩ́ anwun atɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́ hógyi latsá fʋ́ ɩlɔ. Wun atɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ɩnʋnʋ mʋ ansíbi lobwií, ɔlɛkplá buo Yesu, ɔdɛ Bulu kanfʋ́. Ɔdɔm amʋ fɛ́ɛ́ bowun ɩ́nɩ, amʋ́ ɛ́ bɛkanfʋ́ Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu dɛ́ka tsʋn Yeriko wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lampóo ahɔ́pʋ ɔhandɛ ɔkʋá ɔbʋ kɔ́ba bʋ wúlu amʋtɔ, bʋtɛtɩ́ mʋ Sakeo. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Oyin ánfɩ dékléá ɔbɔ́pʋ ansíbi wun Yesu, támɛ ɔma ɩswɩ́, ahá ɛ́ bɔdʋbɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mʋ́ sʋ ɔlɛsrɩ́ yɔ́dʋ pɔntɔ-oyí kʋá Yesu ɔbɔ́tsʋn mʋ́ asɩ, mɛ́nɩ obówun mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Brɛ́á Yesu lówie oyí ámʋ asɩ á, olotsu ansɩ́ fʋ́á, wun Sakeo, ɔlɛbláa mʋ ɔbɛ́ɛ, “Sakeo, wa ɔsa kplɩ ba. Ndɛ, fʋ́ wóyí nɔ́swɩɩ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeo lɔ́wa ɔsa kplɩ́, pʋ́ ansigyí kpá mʋ ya wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ahá ánɩ́ bowun mʋ́ fɛ́ɛ́ bowuntí bɛɛ, “Oyin ánfɩ layɔ́swɩɩ́ lakpan ɔbwɛpʋ́ wóyítɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakeo lɔ́kʋsʋ́ lɩ́ɩ́ wóyítɔ́ ɩnʋ, bláa anɩ Wíe Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, kɩ, néye mɩ́ atɔ́tɔ́ anyɔ, pʋ́ ɩfʋn kíé ahiánfɔ. Nɩ́ nasísi ɔkʋ ɛ́ á, nɛ́lahá mʋ mʋ́ aku ana.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ndɛ Bulu lahɔ wóyí ánfɩ nkpa, tsúfɛ́ Abraham mʋ na ɔ́nɩ ánfɩ ɛ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ahá ánɩ́ bafwɩ́ odunkákpá mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛba, anhɔ amʋ́ nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ahá ámʋ bʋdɛ asʋ́n ámʋ́ʋ́ Yesu dɛ́blɩ́ ámʋ nu. Alɩ brɛ́ ámʋtɔ á, Yesu latá Yerusalem wie tá. Mʋ́ sʋ ɔlɛha amʋ́ yébi pʋ́tswíí amʋ́, tsúfɛ́ bʋdesusúu bɛɛ Bulu iwíegyí béfi asɩ ɩnʋnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɔlɛha yébi amʋ ɔbɛ́ɛ, “Ɩwɩ onyapʋ́ ɔkʋ lɔ́bwɛ agywɩɩn ɔbɛ́ɛ, mótu ɔkpa yɔ́ amʋ́ owíe dɛhɛn wá, ɔyaɩ mʋ owíe, oyinki begyi iwíe mʋ ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Asa ɔbɔ́yɔ á, ɔlɛtɩ mʋ asúmpʋ́ idú, oleye pɔ́ɔnʋ kʋlɛkʋlɛ há amʋ́ fɛ́ɛ́. Ɔlɛbláa amʋ́ ɔbɛ́ɛ bʋpʋ́yɔ agyʋ́má yɔ́fʋn ɛkɛá mɛ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Támɛ mʋ wúlutɔ ahá bolu mʋ, wá abí buo mʋ bɛɛ, bʋmedékléá ɔbwɛ́ɛ amʋ́ owíe. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Támɛ mʋ́ óó á, owíe dɛhɛn amʋ lɛ́yaɩ́ mʋ iwíe amʋ, ɔlɛsankí ba wóyí. Olenya wíé pɛ́ ɔlɛha bɛtɩ mʋ asúmpʋ́ amʋ, ɔkɩ tɔ́á banyá dɩ́nká kɔ́ba amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ogyankpapʋ lɛ́ba bɛbláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, nanyá pɔ́ɔnʋ dú tsɩ́a fʋ́ klɛ́ amʋtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mʋ́ʋ́ ɔlɛbláa osúmpʋ́ amʋ ɔbɛ́ɛ, ‘Fabwɛ́ atɔ́. Osúmpʋ́ wankláán fʋ́gyi. Ɩ́nɩá fawá ɔnɔkwalɩ ɩtɔ́ túkúrííbi ánfɩ ɩwɩ sʋ á, nɔ́pʋ awúlu idú wá fʋ́ ɩbɩtɔ, fɛ́kɩ mʋ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Onyɔɔsɩ lɛ́ba bɛbláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, nanyá pɔ́ɔnʋ anu tsɩ́a fʋ́ klɛ́ amʋtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Owíe amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Fʋ́ ɛ́ fɛ́kɩ awúlu anusʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ɔbambá ɛ́ lɛ́ba bɛbláa mʋ ɔbɛ́ɛ, ‘Mɩ́ wíé, fʋ́ sika ámʋ nɩ. Nɛda mʋ́ wá dúkubi ɔnɔ́ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nyin fʋ. Ndɛ fʋ́ ifú nya, tsúfɛ́ fʋ́ asʋ́n bʋ ɔnlɩn. Fʋtotsú atɔ́ ɔtɩ́nɛ́á fʋmɔpʋ tɔtɔ yáɩ́, fʋ́tɔkpɔ́tɩ́ atɔ́ ɛ́ ɔtɩ́nɛ́á fʋmodu tɔtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mʋ wie amʋ lɛ́bláa mʋ ɔbɛ́ɛ, ‘Osúmpʋ́ laláhɛ. Fʋ́ ɔnɔ́tɔ́ asʋ́n nɔ́pʋgyi fʋ asʋ́n. Yɛ́ɛ fʋyin ánɩ́ mɩ́ asʋ́n ɩhɩ́ɛ́ bʋ ɔnlɩn, ntotsú atɔ́ ɔtɩ́nɛ́á mmɔpʋ tɔtɔ tswɩ, kpɔ́tɩ́ atɔ́ ɔtɩ́nɛ́á mmodu tɔtɔ a? ");
INSERT INTO nkoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mʋ́ ntogyi sʋ́ fʋmɔpʋ mɩ́ kɔ́ba amʋ yɔ́tswɩ sika ɔyaɩ́kpá. Fɛ́kɩ nɩ́ neyínkí ba a, nɔ́yɔhɔ mʋ́a mʋ́sʋ́ abí?’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ɩnʋ owíe amʋ lɛ́bláa ahá ánɩ́ bʋbʋ ɩnʋ ɔbɛ́ɛ, ‘Mlɩswɩɩ osúmpʋ́ anfɩ kɔ́ba amʋ ha ɔmʋamʋ́ʋ́ olenya idú ámʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Támɛ ahá ámʋ bɛbláa mʋ bɛɛ, ‘Nanáin, ɔbʋ pɔ́ɔnʋ dú dodo o!’ ");
INSERT INTO nkoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Owíe amʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, ‘Ndɛ mlɩ bláa mbɛ́ɛ, ɔhá ánɩ́ odekléá obónu mɩ́ atosunáhɛ́ amʋ asɩ á, Bulu ɔbɔ́pʋ ɩkʋ tsɩ́a mʋ́tɔ́ há mʋ. Támɛ ɔhá ánɩ́ omedékléá obónu mɩ́ atosunáhɛ́ amʋ asɩ á, Bulu ɔbɔ́swɩɩ́ mʋ kpalobí ámʋ́ʋ́ alabɩ́ ámʋ kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Séi á, mlɩkpa ahá ámʋ́ʋ́ bɔkʋsʋ́ lɩ́ɩ́ mɩ́sʋ́ bɛɛ mmágyi iwíe amʋ ba, amlɩbɔmɔmɔ́ɔ amʋ́ mɩ́ ansɩ́tɔ́ nfɩ!’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu lɛ́ha amʋ́ yébi anfɩ tá á, ɔlɔtsʋn gyankpá pʋ́ ɔyɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɔlɛta Betfage mʋ́a Betania awúluá ɩdɩn Nfɔ-nyíbʋ ámʋsʋ wie tá á, ɔlɔwa mʋ akasɩ́pʋ́ abanyɔ́ gyankpá, ");
INSERT INTO nkoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ wúlu anfɩ́ ɩda mlɩ ansɩ́tɔ́ ánfɩsʋ. Nɩ́ mlowíé wúlu ɔnɔ́ á, mlówun afrímú kanáhɛ ɔkʋ da ɔfɛ́tɔ́, ɔhaa mɔ́kʋ́tsíá mʋsʋ kɩ. Mlɩsankɩ mʋ ba mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɩ́ ɔkʋ ɔfɩ́tɛ́ mlɩ ɔbɛ́ɛ, ‘Ntogyi sʋ́ mlɩdɛ́ mʋ sankɩ́?’ á, mlɩbla mʋ mlɩaa, ‘Anɩ Wíe dɛ́ mʋ hián.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Akasɩ́pʋ́ abanyɔ́ ámʋ bɔyówun afrímú kánáhɛ ámʋ fɛ́ alɩá Yesu lɛ́bláa amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Brɛ́á bʋdɛ mʋ sankɩ́ á, mʋ awíe bɛfɩtɛ́ amʋ́ bɛɛ, “Ntogyi sʋ́ mlɩdɛ́ mʋ sankɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩ Wíe dɛ́ mʋ hián.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Besi bɛkpa afrímú kánáhɛ amʋ ba Yesu, bɛyaɩ́ amʋ́ atati dɩ́nká mʋsʋ, tsú Yesu bian mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Brɛ́á Yesu tsie mʋsʋ ɔyɔ́ á, ahá ámʋ bɛkpa amʋ́ atati yáɩ́ tswɩ ɔkpatɔ, ɔlɛnatɩ́ mʋ́sʋ́ tsʋn. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Brɛ́á Yesu lɔ́wa Nfɔ-nyíbʋ ámʋ kplɩ́ ɔyɔ́ Yerusalem wúlutɔ bɩ a, mʋ abúopʋ amʋ fɛ́ɛ́ bɔtswɩ opé kánfʋ́ Bulu kʋ́klʋ́kʋ́ʋ́, ofúla amʋ́ʋ́ ɔlɔbwɛ, bowun amʋ fɛ́ɛ́ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɛɛ, “Bulu oyúla owíe anfɩ ɔbá mʋ dátɔ́ ánfɩ! Iwilwii bʋ ɔsʋ́sʋ́. Numnyam ɩbwɛ́ɛ Bulu klɛ́ ɔsʋ́sʋ́ʋ́sʋ́ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisifɔ akʋ bʋbʋ ɔdɔm amʋtɔ. Ɩnʋ bɛbláa Yesu bɛɛ, “Osunápʋ́, ka fʋ́ abúopʋ anfɩ itin!” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ ahá ánfɩ bɛhɩ́ɛ́ kpá ɔnɔ́ bun kʋ́ráá á, abwi ánfɩ bɔ́kplʋn kanfʋ́ Bulu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Brɛ́á Yesu lɛ́ta Yerusalem wie tá, olowun wúlu amʋ sɩ́sɩ́ á, olosu ha mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ɔbɛ́ɛ, “Yerusalemfɔ, tɛkɩ ilehián ánɩ́ mlɛ́bɩ tɔ́á ɩtɔpʋ́ iwilwii ba ndɛ, támɛ mlɩmɛ́tálɩ́ bɩ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Brɛ́ kʋ ɩbá, mlɩ alupʋ́ bɛ́kafía mlɩ abuntíi, pwɛ́ okpó wá mlɩ, sá mlɩ tin ɔkpagyíɔkpasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bɛ́hɩ wúlu anfɩ pʋ́ mʋ́tɔ́ atsiápʋ́. Bʋméesi ibwi kʋlɛ dɩ́nká mʋ́ básʋ́, tsúfɛ́ mlɩmɛ́bɩ brɛ́á Bulu lɛ́ba mlɩ nkpa ɔhɔ́kpa!” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Brɛ́á Yesu lówie Yerusalem a, ɔlɔyɔ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́. Olenya wíé ɩnʋ alɩ, ɔlɔwa ibíá agyípʋ́ gyáa bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Bɛ́tɩ mɩ́ ɔtswɛ́kpa bɛɛ, mpáɩ ɔbɔkpá.’ Támɛ mlɩlapʋ́ ɩnʋ mlí awikplu ɔŋaínkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Oletsiá súná atɔ́ Bulu ɔtswɛ́kpa ɩnʋ ekekegyíɛkɛ. Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ amʋ bodunká ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ mɔ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Támɛ bʋmenya, tsúfɛ́ ahá ámʋ fɛ́ɛ́ bʋbuo mʋ asʋn blɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɛkɛ ɔkʋ Yesu bʋ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ ɔdɛ Bulu asʋ́n wankláán ámʋ ɔkan da, ɔdɛ atɔ́ suná. Ɩnʋ Bulu igyí ahapʋ́ dɛhɛn, Mose mbla asunápʋ́ pʋ́ Yudafɔ ahandɛ bɛba bɔtʋ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bɛfɩtɛ́ mʋ bɛɛ, “Ma lɛ́ha fʋ́ ɔkpa fʋ́dɛ ntobí ánfɩ bwɛ? Ma lɛ́ha fʋ́ túmi?” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ ɛ́ nfɩ́tɛ mlɩ asʋn kua kʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bulu wá Asú Ɔbɔpʋ́ Yohane lénya túmi pʋ́bɔ́ ahá asú lóó, ntɛ́ɛ nyankpʋsa? Mlɩbla mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Amʋ́ wʋlɛwʋlɛ bɔyɔ asʋ́n ánfɩtɔ bɛɛ, “Nɩ́ ablɩ́ anɩaa itsú Bulu wá á, ɔbɛ́fɩtɛ́ anɩ ɔbɛ́ɛ, mʋ́ ntogyi sʋ́ anɩmɔ́hɔ mʋ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nɩ́ ablɩ́ anɩaa nyankpʋsa wá ɛ́ á, ɔdɔm anfɩ bɛ́da anɩ abwi mɔ́, tsúfɛ́ bohogyi ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yohane gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mʋ́ sʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ohwée! Anɩméyín ɔtɩ́nɛ́á olenya mʋ túmi tsú.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mɩ́ ɛ́ mmɛ́ɛbláa mlɩ túmi oduá ndɛpʋbwɛ́ ntobí ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɩnʋ Yesu lɛ́trá ha amʋ́ yébi ɔbɛ́ɛ, “Ɔdɔtɔpʋ ɔkʋ lɔ́dɔ wáɩn ndɔ, ɔlɔpʋ ndɔ ámʋ wá apafɔ ɩbɩtɔ, tú ɔkpa yɔ́ ɔmá kʋtɔ yétsiá ɩnʋ nfí-nfí. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Brɛ́á wáɩn-abí ámʋ kpɔtɩ́bɩ lɔfʋn a, ɔlɔwa mʋ osúmpʋ́ apafɔ ámʋ wá ɔbɛ́ɛ, ɔyɔ́hɔ mʋ ogyíkpá ba mʋ. Támɛ apafɔ ámʋ bɛda obí ámʋ, gya mʋ sɩ́sɩ́ ɩbɩkpan. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɔdɔtɔpʋ amʋ lɛ́lawá mʋ osúmpʋ́ nyɔɔsɩ amʋ́ wá. Apafɔ ámʋ bɛda mʋ, sʋ́pa mʋ, gya mʋ ɛ́ sɩ́sɩ́ ɩbɩkpan. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɔlɛtrá lawá ɔba sáásɩ́. Apafɔ ámʋ bepilán mʋ, gya mʋ lɛ́ ndɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mʋ́ʋ́ ndɔ mʋ wie amʋ lɛ́blɩ́ ɔbɛ́ɛ, ‘Nkálɩ kʋ́ráá nɔ́bwɛ? Nɔ́wa mɩ́ onutó mɩ́ bí ɔdwɛpʋ́ amʋ́ wá. Fíalɩ bóbu mʋ mʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Támɛ brɛ́á apafɔ ámʋ bowun mʋ bi ámʋ sɩ́sɩ́ á, bɛbláa aba bɛɛ, ‘Ɔ́nɩ obégyi mʋ sɩ atɔ́ nɩ́. Mlɩha amɔ mʋ, mɛ́nɩ ndɔ ámʋ ibémlí anɩ klɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɩnʋ bɛkɩtá mʋ, bɩ́tɩ́a mʋ dálɩ ndɔ ámʋtɔ yɔ́mɔ mʋ. “Ntɔ mlɩlahogyi mlɩaa ndɔ mʋ wie amʋ ɔbɔ́bwɛ apafɔ ánfɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɔbɛ́ba bɔmɔ amʋ́, pʋ́ ndɔ ámʋ wá apafɔ bámbá ɩbɩtɔ.” Brɛ́á ahá ámʋ bonu asʋ́n ánfɩ á, bɛblɩ́ bɛɛ, “Ɩ́nɩ mʋ́ ɩtsʋ́ʋn anɩsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu lɛ́kɩ amʋ́ ansɩ́tɔ́ díín, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bulu asʋ́n ánfɩ asɩ mɛ́? ‘Ibwi ámʋ́ʋ́ obu ayípʋ bekiná ámʋ lébemlí okonkísʋ́bwi nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɔhagyíɔha ánɩ́ ɔlɛdɩda ibwi ámʋsʋ obébiabía blúblúblúblú. Nɩ́ ibwi ámʋ isúnkí dá ɔkʋsʋ ɛ́ á, ɩbɔ́kwɛ mʋ fɩ́kɔ́fɩ́kɔ́fɩ́kɔ́ fɛ́ nfúó.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɩlɔwankɩ́ Mose mbla asunápʋ́ pʋ́ Bulu igyí ahapʋ́ amʋ ánɩ́ amʋ́ ɩwɩ yébi alahá. Ɩnʋ bekleá bɛ́kɩtá mʋ, támɛ benya ahá ámʋ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mʋ́ sʋ bodunká ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ kɩ́tá Yesu. Ɩnʋ bɛlɛ ahá bɛɛ bʋpína bwɛ ɩwɩ fɛ́ aha wankláán, abʋtɛ mʋ kɩ bɛɛ bónu asʋankʋ tsú mʋ ɔnɔ́, mɛ́nɩ bɛ́lɩɩ́ mʋ́sʋ́ kɩ́tá mʋ ya ɔmásʋ́ ogyípʋ́. Mʋbʋ́ʋ túmi gyi mʋ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yesu atɛ́pʋ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, anɩyin ánɩ́ ɔnɔkwalɩpʋ fʋgyi, fʋ́tosúná mʋ́ ɛ́. Fʋtamakɩ ɔhaa ansɩ́tɔ́. Mboún fʋtosúná Bulu ɔkpa ámʋ ɔnɔkwalɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Afɩ́tɛ fʋ́! Anɩ mbla lɛha ɔkpa ánɩ́ akáa lampóo ha Roma owíe dɛhɛn Kaesare, ntɛ́ɛ anɩmáka?” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Támɛ Yesu lówun amʋ́ agywɩɩn. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mlɩpʋ kɔ́ba amʋ kʋ ba mɩ́ ankɩ.” Bɔpʋba mʋ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ma nwun pʋ́ mʋ ɩdá dɩ́n mʋ́sʋ́?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Kaesare.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mlɩpʋ tɔ́á igyi Kaesare klɛ́ ha Kaesare, amlɩpʋ mʋ́á igyi Bulu klɛ́ ɛ́ ha Bulu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mʋ́ sʋ bʋmɛtalɩ́ lɩ́ɩ́ Yesu asʋn blɩ́hɛ́ anfɩsʋ kɩ́tá mʋ ahá ámʋ ansɩ́tɔ́. Ɔnɔ́ ɛ́ lobwie amʋ́, bʋmɛtalɩ́ trá bwií ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukifɔ ɔpasua bʋtɛblɩ́ bɛɛ, kʋsʋ́ tsú afúlitɔ ma ɩnʋ. Amʋ́tɔ́ akʋ bɛba Yesu wá, ");
INSERT INTO nkoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, Mose lɔ́wanlɩ́n tswɩ anɩ ɔbɛ́ɛ, ‘Nɩ́ ɔkʋ mʋa mʋ ka bʋmɔkwɩɩ́ asa olowu sí mʋ ka ámʋ a, mʋ pio otsú mʋ ka ámʋ tsia, fɛ́kɩ ɔkwɩɩ ha owupʋ́ ámʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oyin ɔkʋlɛ abí abasíénɔ́ akʋ betsiá. Amʋ́tɔ́ ogyankpapʋ létsiá ɔká, támɛ ɔmɔkwɩɩ́ asa olowu. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mʋ gyama lótsu ɔsʋrapʋka amʋ tsía, támɛ mʋ ɛ́ ɔmɔkwɩɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɔsaasɩ ɛ́ lótsu ɔtsɩ ámʋ tsía. Mʋ ɛ́ ɔmɔkwɩɩ́. Alɩɩ yɔ́tʋ osienɔ́sɩ́ amʋ. Amʋ́tɔ́ ɔkʋkʋ mɔ́kwɩɩ́ asa olowu. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɔma-ɔma a, ɔsʋrapʋ amʋ ɛ́ lóbowu. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Afúli ɔkʋsʋ́kɛ́ a, amʋ́tɔ́ ɔmɔmʋ ɔbɔ́bwɛ mʋ kulu? Tsúfɛ́ amʋ́ abasíénɔ́ ámʋ fɛ́ɛ́ betsiá mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mʋ́ʋ́ Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔyɩ́ ánfɩtɔ ahá tétsía aká mʋ́a akúlu. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Támɛ ɩmɛ́ɛba alɩ brɛ́ ámʋ́ʋ́ ɩbá ámʋtɔ. Ahá ámʋ́ʋ́ bɔfʋn ánɩ́ bɔ́kʋsʋ́ tsú afúlitɔ, tsíá nkpa ɔyɩ́ ámʋ́ʋ́ ɩbɛ́ba amʋtɔ ámʋ mʋ́ bʋméetsiá akúlu, bʋméetsiá aká. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bʋmɛ́ɛtrá wu, tsúfɛ́ bɔ́bwɛ fɛ́ Bulu-abɔpʋ. Bulu ahá bʋgyi, tsúfɛ́ bakʋ́sʋ́ tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Anɩ náin Mose kʋ́ráá lɔ́wanlɩ́n atɔ́ tsú afúlikʋsʋ́ ɩwɩ. Tsúfɛ́ ɔlɔwanlɩ́n ɔbɛ́ɛ, ɛkɛ ámʋ́ʋ́ olowun oyíbi kʋ dɛ ogyá tsií, támɛ ɩmɛdɛ́hɔ́ɔ amʋ a, ɔlɛtɩ Bulu ɔbɛ́ɛ, ‘Abraham mʋa Isak pʋ́ Yakob Bulu.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Megyí awupʋ́ Bulu ógyi, akɩankpapʋ Bulu ógyi, tsúfɛ́ mʋ ansɩ́tɔ́ mʋ́ á, amʋ́ fɛ́ɛ́ bʋbʋ nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɩnʋ Mose mbla asunápʋ́ amʋ akʋ bɛblɩ́ bɛɛ, “Osunápʋ́, fabɩ́ lɛ́ mʋ́ ɔnɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mʋ́ sʋ amʋ́tɔ́ ɔkʋkʋʋkʋ mɛ́trá wa klʋn fɩtɛ́ mʋ asʋansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɩnʋ Yesu lɛ́fɩtɛ́ mbla asunápʋ́ amʋ ɔbɛ́ɛ, “Nkálɩ ɩlɔbwɛ asa ahá bɛɛ, Owíe Dawid mʋ na gyí Kristo amʋ? ");
INSERT INTO nkoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tsúfɛ́ owíe Dawid onutó lɛ́blɩ́ Israelfɔ ɩlʋ ámʋtɔ ɔbɛ́ɛ, ‘Anɩ Wíe Bulu lɛ́bláa mɩ́ Wíe ɔbɛ́ɛ, Tsia mɩ́ gyɔpɩsʋ, ");
INSERT INTO nkoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","yɔ́fʋn brɛ́á nɔ́pʋ fʋ́ alupʋ́ bwɛ́ fʋ́ ayabi oyíkpa.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Owíe Dawid lɛ́tɩ Kristo amʋ ɔbɛ́ɛ, mʋ wie. Mʋ́ nkálɩ sʋ ɔtráa ogyi mʋ na?” ");
INSERT INTO nkoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ɩnʋ ɔlɛbláa mʋ akasɩ́pʋ́ ahá ámʋ ansɩ́tɔ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mlɩkɩ Mose mbla asunápʋ́ anfɩ wankláán. Bʋtekle ligá wa nátɩ́ kí. Bʋtekle bɛɛ ahá bʋbún ha amʋ́ itsiá dɩnsʋ. Otsiákpá yilé bʋtekle tsiá Yudafɔ ofíakpa pʋ́ nkɛ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bʋtɔswɩ́ɩ́ asʋrapʋ amʋ́ wóyí, bʋtepina bɔ mpáɩ tɩ́ntɩ́ɩ́ntɩ́n ahátɔ pʋ́bun amʋ́ lalahɛsʋ. Bulu ɔbɛ́bɩtɩ́ amʋ́ ɩsʋ kínkíínkín!” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Brɛ́á Yesu tsie mantáa tswɩtswɩ dáka ámʋ Bulu ɔtswɛ́kpa ɩnʋ á, olowun alɩá ahá ánɩ́ amʋ́ ɩbɩtɔ bʋ odwin bʋdɛpʋ kɔ́ba akpɔnkpɔntɩ bɔwa dáka ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɩnʋ ɔsʋrapʋ ohiáni ɔkʋ ɛ́ lɔ́pʋ mʋ kɔ́ba ana bɔwa mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mʋ́ʋ́ Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, tswɩtswɩá ɔsʋrapʋ anfɩ, ɔma tɔtɔ anfɩ lawá á, ɩdʋn ɔhagyíɔha klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsúfɛ́ atráhɛ amʋ fɛ́ɛ́ á, amʋ́ kɔ́ba tsɔtsɔɔtsɔtɔ balɛ́ kpalobí tsú bɔwa. Támɛ ɔsʋrapʋ anfɩ mʋ́ ɩ́nɩá ɔma tɔtɔ sʋ tɔ́á ɔbʋ fɛ́ɛ́ alapʋ́ bɔwa á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu akasɩ́pʋ́ akʋ bʋdɛtɔɩ́ tsú alɩá bɔpʋ abwi ánɩ́ ɩbʋ bíá yi Bulu ɔtswɛ́kpa amʋ, pʋ́ atokiehɛ́ wankláán lá mʋ́tɔ́. Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Brɛ́ kʋ ɩbá, bóbwie mʋ́ fɛ́ɛ́ bun. Ibwi kʋlɛ kʋ́ráá méesian dɩnká mʋ́ básʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mʋ́ʋ́ mʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, brɛ́ mɔmʋtɔ ɩ́nɩ fɛ́ɛ́ bɛ́ba? Osúna mɔmʋ abɔ́pʋbɩ́á brɛ́ ámʋ ɩlafʋn?” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩkɩ wankláán, mɛ́nɩ ɔhaa mɛ́ɛmlɛ́ mlɩ. Tsúfɛ́ ahá tsɔtsɔɔtsɔ bɔ́pʋ mɩ́ dá ba bɛɛ, amʋ́gyí Kristo amʋ nɩ. Mʋ́ brɛ́ lafʋn ta, támɛ mlɩmábuo amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nɩ́ mlonúá ɩsá mʋ́a kpokiti ladá á, opúni mátsií mlɩ. Tsúfɛ́ ilehián ánɩ́ ɩ́nɩ aná bégyankpá bá, támɛ ɔyɩ́ ɔnɔ́mɔkɛ́ ɩmɛ́ɛba ɩnʋnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔmá bɔ́kɔ aba. Awíe bɔ́kʋsʋ́ lɩ́ɩ́ abasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɔsʋlʋ́ʋ ɩbɛ́kpɩnkɩ́ ntɩ́nɛ́-ntɩ́nɛ́. Akʋ́n mʋ́a ɩlɔ tsánkɩ́hɛ́ ɛ́ bɛ́ba ntɩ́nɛ́-ntɩ́nɛ́. Ntobíá ɩhɩ́ɛ́ bʋ ifú pʋ́ osúna akpɔnkpɔntɩ bɛ́ba tsú ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Támɛ asa mʋ́ fɛ́ɛ́ bɛ́ba a, bɛ́kɩtá mlɩ, bɛ́hɩɛ dɩ́nká mlɩsʋ, pʋ́ mlɩ ya Yudafɔ ofíakpa yégyi mlɩ asʋ́n, wá mlɩ obu. Mɩ́ sʋ bɛ́kpa mlɩ ya awíe pʋ́ ɔmásʋ́ agyípʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɩ́nɩ ɔbɛ́ha mlɩ ɔkpa mlɛ́talɩ́ gyi mɩ́ ɩwɩ adánsɩɛ súná amʋ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Támɛ mlɩmáhan mlɩ ɩwɩ susúu alɩá mlɛ́lɛ ɩwɩ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tsúfɛ́ nɛ́ha mlɩ nyánsa mʋ́a ɔnɔwankɩ, mlɩ anyabá ámʋtɔ ɔkʋkʋ mɛ́ɛtalɩ́ gyi mlɩ nwɛ́ɛn. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mlɩ akwɩɩ́pʋ́, mlɩ apíó, mlɩ wóyítɔ́ ahá pʋ́ mlɩ anyawíe kʋ́ráá bɛ́lɛ mlɩ há, bɔ́mɔ mlɩtɔ akʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mɩ́ sʋ ahá fɛ́ɛ́ bólu mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Támɛ mlɩ nwunsʋ-imi kʋlɛ kʋ́ráá mɔ́ɔfwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nɩ́ mlɛtálɩ́ lɩ́ɩ́ kínkín á, mlénya nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nɩ́ mlowun ánɩ́ ɩsá akɔpʋ́ bakáfía Yerusalem wúlu a, mlɩbɩá wúlu amʋ ɩbá obwiekpá. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mʋ́mʋ́ ahá ánɩ́ bʋbʋ Yudea ɔmátɔ́ bʋsrɩ́ɩ yɔ abʋsʋ. Ahá ánɩ́ bʋbʋ Yerusalem wúlutɔ bʋdálɩ. Amʋ́á bʋma wúlu amʋtɔ ɛ́ bʋmáyinkí ba. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsúfɛ́ alɩ nkɛ ámʋ ɩbɔ́bwɛ Israelfɔ ɩsʋbɩtɩ́ nkɛ fɛ́ alɩá Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɔwanlɩ́n tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Amenyapʋ́ pʋ́ abí ayín ánɩ́ bʋpia abi bɔbwɛ alɩ brɛ́ ámʋtɔ, bʋgyɔ́wɩ nɩ́. Tsúfɛ́ asʋn wunhɛ amʋ ɔnɔ́ bɔ́wa ɔnlɩn. Ɩkplán kpɔnkpɔntɩ bɛ́ba ɔsʋlʋ́sʋ, ɩsʋbɩtɩ́ kpɔnkpɔntɩ ɛ́ ɩbɛ́ba mʋ́sʋ́ atsiápʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Amʋ́tɔ́ akʋ bésin ɔdayí ɔnɔ́. Bɛ́kɩtá amʋ́ akʋ ɛ́ ndoun ya ɔmá-ɔmátɔ́. Yerusalem wúlu bétsiá ɔmá bámbásʋ́fɔ asɩ, alɩɩ yɔ́fʋn brɛ́á amʋ́ ɔmá ámʋ asɩtsiábɩ́ lamɔ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bówun osúna owí, ɔtsra pʋ́ ntsrakpabisʋ. Ɔpʋ bɛ́da ifúsʋ́. Ɔsʋlʋ́sʋ atsiápʋ́ bénya ifú, bʋmɛ́ɛbɩ tɔ́á bʋbwɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nwʋlʋ́táa mʋ́a mʋ́tɔ́ atɔ́ fɛ́ɛ́ bɛ́kpɩnkɩ́. Mʋ́ sʋ ahá bénya ifú, tɩ́ɩn ŋɛ́ tɔ́á ɩdɛbá sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Alɩ brɛ́ ámʋtɔ á, ɔhagyíɔha obówun ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ napʋ́ túmi mʋ́a numnyam kpɔnkpɔntɩ mbʋ nwʋlʋ́táatɔ tsú ɔsʋ́sʋ́ nɛbá. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nɩ́ ntobí ánfɩ ɩdɛ mʋ́sʋ́ yɔ á, mlɩkʋsʋ lɩɩ, amlɩtsu ansɩ́ fʋa kɩ, tsúfɛ́ mlɩ nkpahɔ́bɩ lafʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu lɛ́ha amʋ́ yébi ɔbɛ́ɛ, “Mlɩpʋkɩ pɔntɔ mʋ́a nyí atráhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nɩ́ ɩdɛ atɛ pɔpwɛ lɛ á, mlɩtowun mʋ́, bɩ́ ánɩ́ awikpan brɛ́ lafʋn ta. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Alɩ kɛ́n, nɩ́ mlowun ánɩ́ ntobí ánfɩ fɛ́ɛ́ ɩdɛ mʋ́tɔ́ bá a, mlɩbɩ ánɩ́ Bulu iwíegyí ámʋ ɩlawíé wóyí tá. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ɔnɔkwalɩ ndɛ mlɩ bláa. Ndɛmba-abí ánfɩ fɛ́ɛ́ bʋmóowu tá, asa ɩ́nɩ fɛ́ɛ́ bɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ɔsʋ́ mʋ́a asɩ fɛ́ɛ́ bɔ́tsʋn, támɛ mɩ́ asʋn blɩ́hɛ́ mɔ́ɔtsʋn ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mlɩkɩ wankláán, mɛ́nɩ opotsuawa, ntábʋ pʋ́ ɔyɩ́tɔ́ atɔ́ ɔmagyáa méegyi mlɩ agywɩɩnsʋ, mɛ́nɩ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɔbákɛ amʋ mɛ́ɛbɛkɩtá mlɩ fɛ́ yibi. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tsúfɛ́ ɩbɛ́ba ɔyɩ́tɔ́ ahá fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɩ́nɩ sʋ mlɩgyo, amlɩbɔ mpáɩ, mɛ́nɩ mlénya ɔwʋnlɩ́n tálɩ́ tsʋn ofúla amʋ fɛ́ɛ́tɔ́, bɛlɩɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ansɩ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nkɛ ámʋtɔ á, Yesu létsiá yósuná atɔ́ Bulu ɔtswɛ́kpa ɩnʋ ɔpa. Onyé á, alanátɩ́ yɔ́ Nfɔ-nyíbʋ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ahá tsɔtsɔɔtsɔ bʋtɔkʋ́sʋ́ ba Ɔtswɛ́kpa ɩnʋ bakɛ, bonu mʋ asʋn blɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Israelfɔ Bodobodo Mátúhɛ́Nkɛ, igyi amʋ́sʋ́ Katsʋn Nkɛ ámʋ gyí ɩbá bɔfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ amʋ bodunká ɔkpa ánɩ́ bɔ́tsʋn mʋ́sʋ́ kɩ́tá Yesu ŋáintɔ, mɔ́ mʋ, tsúfɛ́ bʋdɛ ahá ámʋ ifú nya. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɩnʋ Ɔbʋnsám lówie Yuda Iskariot, ogyi Yesu akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mʋ́ sʋ ɔlɔyɔ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Bulu ɔtswɛ́kpa agyópʋ dɛhɛn wá, bɛkɩtá agywɩɩn alɩá ɔbɛ́lɛ Yesu há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ansɩ́ légyi amʋ́. Mʋ́ sʋ botsulá ánɩ́ bɛ́ka mʋ ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda lótsulá. Mʋ́ sʋ olodunká ɔkpa ánɩ́ ɔbɔ́tsʋn mʋ́sʋ́ hɩ́ɛ́ɛ́ lɛ́ Yesu há amʋ́, brɛ́á ahá tsɔtsɔɔtsɔ ámʋ bʋma ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bodobodo Mátúhɛ́Nkɛ ámʋtɔ ɛkɛá bʋtɔmɔ́ Israelfɔsʋ Katsʋn Nkɛ akúfa lɔfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu lɔ́wa Petro mʋa Yohane ɔbɛ́ɛ, bʋyɔ́bwɛ Israelfɔsʋ Katsʋn atogyihɛ amʋ yaɩ ha amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Petro mʋa Yohane bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Wíé, nkʋ́nʋ ayɔ́bwɛ mʋ́ yaɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlowíé wúlu ɔnɔ́ á, mléfia oyin ɔkʋá ɔsʋ ntsu-ɔlɔ́. Mlɩbuo mʋ yɔ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mlowíé á, mlɩfɩtɛ wóyí mʋ wie amʋ mlɩaa, ‘Osunápʋ́ ɔbɛ́ɛ, afɩ́tɛ fʋ́, nkʋ́nʋ afɔɔ́ ɔswɩɩ́kpá bʋ, ánɩ́ mɩ́a mɩ́ akasɩ́pʋ́ abɛ́ba begyi Katsʋn atogyihɛ amʋ?’ ");
INSERT INTO nkoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Obósuná mlɩ abansʋ́rʋ yílé kʋá balá mʋ́tɔ́ yáɩ́. Mlɩbwɛ atɔ́ ámʋ yaɩ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Petro mʋa Yohane bɔpʋ ɔkpa. Boyówun tógyítɔ́ alɩ ámʋ́ʋ́ Yesu lɛ́bláa amʋ́ ámʋ pɛ́pɛ́ɛ́pɛ́, bɔbwɛ Katsʋn atogyihɛ amʋ yáɩ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Atɔ́ ámʋ gyíbɩ lɔfʋn, Yesu mʋa mʋ sumbí ayɔpʋ́ bɛba betsiá ɔpʋ́nʋ́ ámʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nhɩ́ɛ́ ndeklé mbɛ́ɛ, mɩ́a mlɩnyɔ abégyi Katsʋn Nkɛtɔ atogyihɛ anfɩ asa mɩ́ anwun ɩwɩɔsɩn. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tsúfɛ́ ndɛ mlɩ bláa mbɛ́ɛ, mmɛ́ɛtrá gyi mʋ́ ɛkɛkɛɛkɛ yɔ́fʋn ɛkɛá ɩtɔ́ ámʋ́ʋ́ atogyihɛ anfɩ ɩlɩɩ́ há ámʋ laba mʋ́tɔ́ Bulu iwíegyí amʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɩnʋ olotsu ntá-ɛwɛ, dá Bulu ɩpán, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩhɔ amlɩnu ha aba. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tsúfɛ́ ndɛ mlɩ bláa mbɛ́ɛ, mmɛ́ɛtrá nu wáɩn-abí ntá ánfɩ ɛkɛkɛɛkɛ yɔ́fʋn brɛ́á Bulu iwíegyí ámʋ ɩbɛ́ba.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɩnʋ ɔlɛlɛ bodobodo ipín, ɔlɛda Bulu ɩpán, bíábía mʋ́tɔ́ pʋ́há amʋ́, blɩ́ ɔbɛ́ɛ, “Mɩ́ ɔyʋlʋ́á mlɩ sʋ nasí há nɩ́. Mlɩtsia bwɛ ɩ́nɩ pʋkaɩn mɩ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Alɩ kɛ́n, brɛ́á begyi atɔ́ ámʋ tá á, olotsu ntá-ɛwɛ ámʋ há amʋ́, blɩ́ ɔbɛ́ɛ, “Ntá-ɛwɛ ánfɩ gyí Bulu ntam pɔpwɛ ánɩ́ nɛ́tsɛɩ́ mɩ́ obugya wʋ́lɩ́ pʋ́sí mʋ́sʋ́ há mlɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ɩ́nɩá ndɛblɩ́ á, mɩ́a ɔhá ámʋ́ʋ́ ɔbɛ́lɛ mɩ́ há ámʋ ɩbɩ da ɔlɛpɛ ɔkʋlɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nówu fɛ́ alɩá Bulu lɛ́hɩɛ yáɩ́, támɛ ɔhá ámʋ́ʋ́ ɔbɛ́lɛ mɩ́ há ámʋ ɔgyɔ́wɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ɩnʋ befi asɩ bʋdɛ aba fɩtɛ́ bɛɛ, “Ngya anɩtɔ ma ɔbɔ́bwɛ ɩ́nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nwɛ́ɛngyí lɛ́ba sumbí ayɔpʋ́ ámʋtɔ, amʋ́tɔ́ ɔmʋá ɔbɔ́bwɛ ɔhandɛ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔmátɔ́fɔ awíe bʋbʋ túmi amʋ́ ahásʋ. Ahá ámʋ bʋtɛtɩ́ amʋ́ ahandɛ bɛɛ, ‘Bʋalɛ agyípʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Támɛ mlɩtɔ mʋ́ á, ɩmába alɩ. Ɔhá ánɩ́ odekléá ɔbɔ́bwɛ mlɩtɔ ɔhandɛ ɔbwɛ́ɛ mʋ ɩwɩ ɔtráhɛ. Ɔhá ánɩ́ odeklé ɔbɛ́ɛ, mɔ́bwɛ mlɩ nkpá ogyápʋ ɛ́ ɔbwɛ́ɛ mʋ ɩwɩ fɛ́ osúmpʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma dʋ́n mʋ ba? Ɔhá ánɩ́ otsie ɔpʋ́nʋ́asɩ lóó, ntɛ́ɛ ɔhá ánɩ́ odesúm ɔpʋ́nʋ́ ámʋ asɩ? Megyí ɔhá ámʋ́ʋ́ otsie mʋ́ asɩ ámʋ dʋn? Támɛ mbʋ mlɩtɔ fɛ́ osúmpʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mlɩlɔ́wa klʋn buo mɩ mɩ́ ɩsɔ́kɩ fɛ́ɛ́tɔ́ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Alɩ ámʋ́ʋ́ mɩ́ Sɩ́ layáɩ́ mɩ́ owíe amʋ a, alɩ́ mɩ́ ɛ́ ndɛ mlɩ yaɩ́ nɩ́, ");
INSERT INTO nkoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mɛ́nɩ mlétsiá mɩ́ ɔpʋ́nʋ́asɩ, gyi atɔ́, nú ntá mɩ́ iwíe ogyíkpá ɩnʋ. Mlétsiá awíe mbíásʋ́, gyi Israel abusuan dúanyɔ ámʋ asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu lɛ́bláa Simon Petro ɔbɛ́ɛ, “Simon, Simon! Kɩ, Ɔbʋnsám dɛ́ ɔkpa kʋlɩ́ ɔbɛ́ɛ, obófuní mlɩ fɛ́ ayó. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Támɛ nakókóli Bulu há fʋ́ mbɛ́ɛ, fʋmádɩda hógyitɔ. Nɩ́ feyínkí ba mɩ́ wá á, wa fʋ́ aba ámʋ ɛ́ ɔwʋnlɩ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé natsúlá, nɩ́ obu igyi kʋ́ráá mɩ́a fʋnyɔ abɛ́dɩ. Nɩ́ lowu ígyi ɛ́ á, mɩ́a fʋnyɔ abówu.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Petro, ndɛ fʋ́ bláa mbɛ́ɛ, ndɛ, asa batɛ ɔbɛ́lɛ ɔnɔ́ á, fɔ́swɩɩ́ pʋ́ ɩbɩ wá ogyá tse sa fɛɛ fʋmeyín mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɩnʋ Yesu lɛ́fɩtɛ́ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Brɛ́á nɔwa mlɩ sumbí, mlɩmɛ́dɛ́ sika akɛntɛ, mlɩmɛ́dɛ́ akpankogyo ntɛ́ɛ ntʋkʋta nyɔɔsɩ a, tɔkʋ lehián mlɩ?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ɛkɛkɛɛkɛ! Tɔtɔ mehián anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Támɛ séi mʋ́ á, fʋ́á fʋ́bʋ sika kɛntɛ, ntɛ́ɛ akpankogyo a, tsu kɩta. Nɩ́ mlɩtɔ ɔkʋ má ɔdayí ɩya anyɔ á, ɔfɛ́ mʋ tati pʋhɔ kʋ! ");
INSERT INTO nkoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tsúfɛ́ ilehián ánɩ́ mɩ́ ɩwɩ asʋ́n ámʋ́ʋ́ ɩbʋ Bulu asʋn wanlɩ́nhɛ́tɔ ámʋ ɩbɛ́ba mʋ́tɔ́. Bɔwanlɩ́n bɛɛ, ‘Bɛkla mʋ wá lakpan abwɛpʋ́tɔ́.’ Tsúfɛ́ asʋ́n ámʋ́ʋ́ bɔwanlɩ́n tsú mɩ́ ɩwɩ ámʋ ɩbá lafʋn ta.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Akasɩ́pʋ́ amʋ bɛbláa mʋ bɛɛ, “Anɩ Wíe, kɩ, ndayí anyɔ nɩ́.” Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɩtsɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu lɛ́dalɩ wúlutɔ yɔ́ Nfɔ-nyíbʋ ámʋsʋ, fɛ́ alɩá otetsíá yɔ́ ɩnʋ yáɩ́. Mʋ akasɩ́pʋ́ ɛ́ bobuo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Brɛ́á bowie ɩnʋ á, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩkokoli Bulu, mɛ́nɩ mlɩmóowie ɩsɔ́kɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mʋ́ʋ́ ɔlɛdalɩ amʋ́tɔ́ yɔ́ nkpá kpalobí fɛ́ nfɩ mʋ́a nfɩ, yɛ́da akpawunu bɔ́ mpáɩ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mɩ́ Sɩ́, nɩ́ fótsulá á, ha ntá-ɛwɛ ánfɩ ɩtsʋn mɩsʋ. Támɛ megyí tɔ́á ndeklé, mʋ́a fʋdeklé ɩbá mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ɩnʋ Bulu-ɔbɔpʋ lótsu ɔsʋ́sʋ́ bá bɛlɛ ɩwɩ ɔwan súná mʋ, wá mʋ ɔwʋnlɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Asʋ́n ɩhɩ́ɛ́ dɛ mʋ háan. Mʋ́ sʋ ɔlɔbɔ mpáɩ kínkíínkín. Ɩlɛha mʋ apípi lemlí fɛ́ obugya, ɩdɛtɩ́ɩn da ɔsʋlʋ́tɔ ta-ta-ta. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Brɛ́á ɔlɔkʋsʋ́ tsú mpáɩ ámʋ ɔbɔkpá, yínkí ba akasɩ́pʋ́ amʋ wá á, olowun ánɩ́ bʋdɛdɩdɩ. Awɩrɛhɔ dɛ amʋ́. Mʋ́ sʋ ɩwɩ lawú amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́dɩdɩ? Mlɩkʋsʋ amlɩkokoli Bulu, mɛ́nɩ mlɩmóowie ɩsɔ́kɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ɔnɔ́ mesi, ɔdɔm bowotií amʋ́sʋ́. Akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛá bʋtɛtɩ́ mʋ Yuda gyá amʋ́ nkpá. Ɩnʋ ɔlɛnatɩ́ tʋ́ Yesu ɔbɛ́ɛ, amʋlata mʋ puta, ");
INSERT INTO nkoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","támɛ Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Yuda, latá fɛ́latá mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ pútá, pʋ́lɛ́ mɩ́ há?” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Akasɩ́pʋ́ amʋ́ʋ́ bʋbʋ Yesu wá ámʋ bowun tɔ́á ɩbá. Mʋ́ sʋ bɛfɩtɛ́ Yesu bɛɛ, “Akɔ́ɔ amʋ́? Anɩbʋ ndayí.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɩnʋ amʋ́tɔ́ ɔkʋlɛ lɔ́tswɩ mʋ ɔdayí kpá Bulu igyí ɔhapʋ́ dɛhɛn osúmpʋ́ ɔkʋ gyɔpɩ-ɩsʋ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu lɛ́bláa ɔkasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mábwɛ! Isíi mlɩ ɔka!” Ɩnʋ ɔlɔpʋ ɩbɩ da osúmpʋ́ amʋ ɩsʋ ámʋ, ileyinkí tsá. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ Bulu igyí ahapʋ́ dɛhɛn, Bulu ɔtswɛ́kpa agyópʋ ahandɛ pʋ́ Yudafɔ ahandɛ amʋ́ʋ́ bɛba mʋ ɔkɩtákpá amʋ ɔbɛ́ɛ, “Ogyo otswapʋ́ ngyi, sʋ́ mlɩlatsú nkpotí pʋ́ ndayí mlɛbá mɩ́ ɔkɩtákpá? ");
INSERT INTO nkoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ntsie mlɩ wá Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ekekegyíɛkɛ, mlɩmɔ́pʋ ɩbɩ da mɩ ɛkɛkɛɛkɛ. Támɛ mlɩ brɛ́ nɩ́, oklún túmi dɛ́ iwíe gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɩnʋ ahá ámʋ bɛkɩtá Yesu, kpá mʋ ya Bulu igyí ɔhapʋ́ dɛhɛn wóyítɔ́. Petro lɛ́pɛtɩ́ obuo amʋ́ ɔma tsútsúútsú. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Támɛ brɛ́á bosun agyabi wunsɩnɛ́sʋ́ ɩnʋ, bʋtsie mʋ́ asɩ á, Petro léyétsiá amʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Otsibi ɔkʋá ogyi osúmpʋ́ ɩnʋ lówun ánɩ́ Petro tsie ogyá ámʋ asɩ, ɔlɛkɩ mʋ díín, blɩ́ ɔbɛ́ɛ, “Oyin ánfɩ ɛ́ buo Yesu!” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Támɛ Petro lɔ́pʋ ɔnɔlɩ́ blɩ́ ɔbɛ́ɛ, “Ɔtsɩ, mmeyín mʋ ɔtɩnɛtɩnɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɩlɔbwɛ kpalobí á, ɔha ɔkʋ ɛ́ lówun Petro, ɔlɛbláa Petro ɔbɛ́ɛ, “Fʋ́ ɛ́ fʋ́bʋ amʋ́tɔ́.” Támɛ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, megyí mɩ́ nɩ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fɛ́ dɔnhwɩ́rɩ kʋlɛ ɔma a, ɔha bambá ɛ́ lɛ́ba botsulá mʋ́sʋ́ ɔbɛ́ɛ, “Lɛ́lɛ́, oyin ánfɩ ɛ́ létsiá mʋ wá, tsúfɛ́ Galileayin ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Támɛ Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Agya! Kɩ, mmeyín asʋ́n ánfɩ ɩwɩ kʋkʋ.” Petro ɔnɔ́ mesi, batɛ lɔ́bɔn. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Anɩ Wíe Yesu lɛ́damlí kɩ Petro. Ɩnʋ Petro lɛ́kaɩ́n asʋ́n ámʋ́ʋ́ anɩ Wíe lɛ́bláa mʋ ɔbɛ́ɛ, “Fɔ́swɩɩ́ tse sa fɛɛ fʋmeyín mɩ́ asa batɛ ɔbɛ́lɛ ɔnɔ́ onyenɩ.” ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɩnʋ ɔlɛdalɩ yɔ́ kpankpá hɩ́ɛ́ yósu. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesusʋ akɩ́pʋ befi asɩ bʋdɛ mʋ ahinlá bwɛ, bʋdɛ mʋ da. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bɔpʋ atɔ́ klɩ́ mʋ ansíbi, fɩ́tɛ́ mʋ bɛɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́, maládá fʋ́? Bla anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bɛkpa mʋ asiabí, bláa mʋ nyányála. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yudafɔ ahandɛ, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Mose mbla asunápʋ́ amʋ befia ɔyɩ kɛhɛ nyankɩ-nyankɩ, bɛbɩtɩ́a Yesu bɛlɩɩ́ amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bɛbláa Yesu bɛɛ, “Nɩ́ fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) a, bla anɩ.” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ nɛbláa mlɩ kʋ́ráá, mlɩmóohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɩ́ nɛfɩtɛ́ mlɩ asʋankʋ ɛ́ á, mlɩmɛ́ɛlɛ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Támɛ tsú séi pʋ́ya a, mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nétsiá Bulu Otúmípʋ amʋ gyɔpɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Amʋ́ fɛ́ɛ́ bɛfɩtɛ́ Yesu bɛɛ, “Mʋ́ sʋ fʋ́gyí Bulu mʋ Bi ámʋ nɩ?” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ee, ɔnɔkwalɩ amʋ mlɩlablɩ́ á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɩnʋ bɛfɩtɛ́ aba bɛɛ, “Ntogyi sʋ́ abɛ́trá dunká adansɩfɔ bámbá? Mʋ́ anɩlanú tsú mʋ onutó ɔnɔ́ á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɩnʋ ahá ámʋ́ʋ́ befia ɩnʋ ámʋ bɔkʋsʋ́ kpá Yesu ya ɔmásʋ́ ogyípʋ́ Pilato. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bɛka asʋ́n dɩ́nká mʋsʋ bɛɛ, “Anɩlawun ánɩ́ oyin ánfɩ dɛ́ ɔmá ánfɩtɔ ahá yintá. Ɔdɛ amʋ́ bláa ɔbɛ́ɛ, bʋmátra ka lampóo há Roma owíe dɛhɛn. Ɔdɛblɩ́ ɛ́ ɔbɛ́ɛ, mʋgyí Kristo, (ɔhá ánɩ́ Bulu ladá mʋ ofúli amʋ), idesuná ánɩ́ owíe ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Fʋ́gyí Yudafɔ owíe amʋ nɩ?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee, mʋ́ fablɩ́ á.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato lɛ́bláa Bulu igyí ahapʋ́ dɛhɛn pʋ́ ɔdɔm amʋ ɔbɛ́ɛ, “Mmɔkʋ́wun tsitsa kʋkʋá oyin ánfɩ labwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Támɛ amʋ́ mʋ́ bʋdɛ mʋ́tɔ́ kótóó bɛɛ, “Ɔdɛpʋ mʋ atosunáhɛ́ tɩ́ ɩtrɛ́ mʋ́a ɩkɔ́ wá Yudea ɔmá ánfɩtɔ. Olefi mʋ́ asɩ tsú Galilea, alapʋ́ bowie nfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Brɛ́á Pilato lónu asʋ́n ánfɩ á, ɔlɛfɩtɛ́ ɔbɛ́ɛ, “Galileayin oyin ánfɩ gyí?” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Brɛ́á ɔlɛbɩ ánɩ́ Yesu otsú Galilea, ɔtɩ́nɛ́á owíe Herode dɛ́ iwíe gyí a, ɔlɛha bɛkpa mʋ ya Herode. Alɩ brɛ́ ámʋtɔ á, Herode bʋ Yerusalem wúlutɔ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Brɛ́á owíe Herode lówun Yesu a, ansɩ́ lɛhɩɛ gyi mʋ. Tsúfɛ́ olodunká ánɩ́ obówun mʋ dodoodo, mʋ ɩwɩ asʋ́n ánɩ́ alanú sʋ. Odeklé ánɩ́ Yesu ɔbwɛ́ɛ osúna kʋ suna mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mʋ́ sʋ ɔlɛfɩtɛ́ Yesu asʋ́n tsɔtsɔɔtsɔ, támɛ Yesu mɛ́lɛ kʋkʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bulu igyí ahapʋ́ dɛhɛn amʋ pʋ́ Mose mbla asunápʋ́ amʋ bʋlɩɩ́ ɩnʋ, bʋdɛkplʋ́n ka asʋ́n dɩ́nká mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Owíe Herode mʋa mʋ ɩsá akɔpʋ́ ámʋ ɛ́ bɔsʋpáa mʋ, bwɛ́ mʋ ahinlá. Bɔpʋ srɩ́kɩ ligá kʋ wá mʋ, beyinkía mʋ ya Pilato. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Owíe Herode mʋa Pilato bemlí anyawíe tsú ɛkɛ ámʋ. Tɛkɩ amʋ́ nsɩnɛ́ ɩma alɛ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato lɛ́tɩ Bulu igyí ahapʋ́ dɛhɛn, Yudafɔ ahandɛ pʋ́ ɔmá ámʋ fɛ́ɛ́ befia. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩlɛ́kpa oyin ánfɩ ba mɩ mlɩaa, ɔdɛ ɔmá ámʋ agywɩɩn yintá. Nafɩtɛ́ mʋ ɔnɔ́tɔ́ asʋ́n mlɩ ansɩ́tɔ́, nawun ánɩ́ asʋ́n ámʋ́ʋ́ mlɩlɛ́ka dɩ́nká mʋsʋ ámʋ ɩma mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Owíe Herode ɛ́ lawun mʋ́ alɩ. Mʋ́ sʋ́ alayínkía mʋ sɩ́sɩ́ anɩ nɩ́. Oyin ánfɩ mɔ́kʋ́bwɛ́ tɔtɔá bɔ́mɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ɩ́nɩ sʋ nɛ́ha bɛ́pɩtɩ́ mʋ atɔ́, mɩ́ ansi mʋ ɔnatɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Ɩnʋ ɔdɔm amʋ fɛ́ɛ́ bɔkplʋ́n blɩ́ bɛɛ, “Lɛ mʋ ɩnʋ, afʋsi Baraba ha anɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba anfɩ da obu, tsúfɛ́ ɔlɔkʋsʋ́ lɩ́ɩ́ wúlu amʋsʋ, ɔlɔmɔ ɔha ɛ́ mʋ́tɔ́.) ");
INSERT INTO nkoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato lékléá obési Yesu. Mʋ́ sʋ ɔlɛtrá tɔɩ́ kplá ɔdɔm amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Támɛ bɔkplʋ́n kʋ́klʋ́kʋ́ʋ́ bláa mʋ bɛɛ, “Da mʋ manta oyikpalíhɛsʋ! Da mʋ manta oyikpalíhɛsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato lɛ́bláa amʋ́ otse saasɩ ɔbɛ́ɛ, “Tsitsa mɔmʋ alabwɛ́? Mmɔkʋ́wun tɔ́á alabwɛ́, sʋ́ nɛ́ha bɔ́mɔ mʋ. Nɛ́ha abʋpɩtɩ mʋ atɔ́, ɔnatɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Támɛ bʋbʋ mʋ́sʋ́ bʋdɛkplʋ́n kʋklʋ́kʋ́ʋ́ bɛɛ, ɔháa abʋda mʋ manta oyikpalíhɛsʋ. Ɩnʋ bɔdʋn mʋ ɔnɔlɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mʋ́ sʋ Pilato lɔ́bwɛ dɩ́nká tɔ́ ámʋ́ʋ́ bʋdedunká ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Olesi oyin ámʋ́ʋ́ ɔlɔkʋsʋ́ lɩ́ɩ́ ɔmá ámʋsʋ, mɔ́ ɔha mʋ́tɔ́ sʋ́ ɔda obu ámʋ, olesi Yesu há mʋ ɩsá akɔpʋ́ ɔbɛ́ɛ bʋbwɛ́ɛ mʋ alɩá ahá ámʋ bʋdeklé. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Brɛ́á bɛkpa Yesu bɔyɔ́ á, befia Kireneyin ɔkʋá bʋtɛtɩ́ mʋ Simon. Otsú abúasɩ. Ɩsá akɔpʋ́ ámʋ bɛka mʋ hɩ́ɛ́ bɛɛ ɔsʋ́ra oyikpalíhɛ amʋ buo Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɔdɔm bobuo Yesu. Atsɩá bʋbʋ amʋ́tɔ́ bʋpu amʋ́ anyɔ́pʋ, bʋhɩ́ɛ́ bʋdesú ha Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu lɛ́damlí, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Yerusalemfɔ atsɩ, mlɩmásu mɩ. Mlɩsu mlɩ ɩwɩ pʋ́ mlɩ abí. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tsúfɛ́ nkɛ kʋ ɩbá mlɛ́blɩ́ mlɩaa, ‘Bulu layúlá atsɩá bʋmɔkʋ́kwɩ́ɩ́ kɩ, obí mɔ́kʋ́dɩ́ amʋ́ opúnitɔ kɩ, obí mɔ́kʋ́nyɔ́pʋ́ amʋ́ ɛ́ kɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Alɩ brɛ́ ámʋtɔ á, ahá bɛ́bláa abʋ bɛɛ, ‘Mlɩbwie bun anɩsʋ. Nkúku, mlɩpula anɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tsúfɛ́ nɩ́ bʋdɛ oyi bɔbwɛ ogyá wa alɩ á, nkálɩ bɔ́bwɛ oyi wʋlɩhɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɩsá akɔpʋ́ ámʋ bɛkpa lalahɛ abwɛpʋ́ abanyɔ́ ɛ́ mántá Yesusʋ, bɔyɔ́mɔ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Brɛ́á bowie ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ “Nwun Okokobi” a, bɛda Yesu mántá oyikpalíhɛsʋ. Bɛda amʋ́ abanyɔ́ ámʋ ɛ́ mántá nyikpalíhɛsʋ. Ɔkʋlɛ bʋ Yesu gyɔpɩsʋ, ɔkʋlɛ ɛ́ bʋ mʋ bɩnasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ɩnʋ Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́, sikie amʋ́, tsúfɛ́ bʋmeyín tɔ́á bʋdɛbwɛ.” Ɩsá akɔpʋ́ ámʋ bɔtswɩ abi ye Yesu atadɩɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ahá tsɔtsɔɔtsɔ ámʋ́ʋ́ bobuo amʋ́ yɔ́ ɩnʋ ámʋ besi bʋlɩɩ́ ɩnʋ bʋdɛ mʋ kɩ́ɩ. Yudafɔ ahandɛ amʋ bɔbwɛ mʋ ahinlá bɛɛ, “Ɔlɔhɔ ahá nkpa. Nɩ́ lɛ́lɛ́ mʋgyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli), mʋ Bulu lalɛ́ nɩ́ á, ɔhɔ́ɔ mʋ ɩwɩ nkpa!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Ɩsá akɔpʋ́ ámʋ ɛ́ bɔpʋ ntá ɔdáɩ tin mʋ ɔnɔ́, bwɛ́ mʋ ahinlá bɛɛ, “Nɩ́ fʋ́gyí Yudafɔ owíe amʋ nɩ á, lɛ fʋ́ ɩwɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɔwanlɩ́n atɔ́ mántá oyikpalíhɛ amʋ awunso bɛɛ, “Yudafɔ Owíe amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lalahɛ abwɛpʋ́ ámʋ́ʋ́ bɛda mántá oyikpalíhɛsʋ ámʋtɔ ɔkʋlɛ lɛ́blɩ́ Yesu ɩwɩ abususʋ ɔbɛ́ɛ, “Megyí fʋ́gyí Kristo amʋ nɩ? Lɛ fʋ́ ɩwɩ, afʋlɛ anɩ mɛɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Támɛ onyɔɔsɩ amʋ lɔ́wa ɩyɩn wá mʋ ɔbɛ́ɛ, “Fʋmɛdɛ́ Bulu ifú nya! Fʋ́a mʋnyɔ fɛ́ɛ́ dɛ́ ɩsʋbɩtɩ́ kʋlɛ hɔ́ɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Anɩ mʋ́ á, anɩ ɩsʋbɩtɩ́ ɩda ɔkpa, anɩ lakpan ánɩ́ anɩlɔ́bwɛ sʋ. Támɛ oyin ánfɩ mʋ́ mɔ́kʋ́bwɛ́ laláhɛ kʋkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mʋ́ʋ́ ɔlɛbláa Yesu ɔbɛ́ɛ, “Yesu, nɩ́ fɛbá fʋ́ iwíe ogyíkpá a, kaɩn mɩ́sʋ́!” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ fʋ́ bláa. Ndɛ, mɩ́a fʋnyɔ abétsiá Paradiso.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Alɩ brɛ́ ánfɩ ɩbɔ́bwɛ fɛ́ ɔpa dódúanyɔ. Owí lɛta ɔsʋlʋ́ʋ amʋsʋ fɛ́ɛ́ alɩɩ yɔ́fʋn ntʋ́pwɛ dɔsatɔ. Owí mɛtrá lɩn ɛ. Ɩnʋ á, tati ámʋ́ʋ́ bɔpʋká Bulu Ɔtswɛ́kpa obu ámʋtɔ ɩlɛbalɩ́ anyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu lɔ́kplʋn kʋ́klʋ́kʋ́ʋ́ blɩ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́, napʋ́ mɩ́ ɔŋɛ́ wá fʋ́ ɩbɩtɔ.” Olenya blɩ́ alɩ tá pɛ́, ɔlɛlɛ ɔŋɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Brɛ́á ɩsá akɔpʋ́ ɔhandɛ amʋ lówun tɔ́á ɩlaba a, ɔlɛkanfʋ́ Bulu ɔbɛ́ɛ, “Lɛ́lɛ́, ɔha yilé oyin ánfɩ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ahá ámʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋ fɛ́ɛ́ bowun tɔ́á ɩlaba, bɔpʋ awɩrɛhɔ nátɩ́ bɔyɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Támɛ amʋ́á bʋyin Yesu pʋ́ atsɩ ámʋ́ʋ́ bobuo mʋ tsú Galilea ɔmátɔ́ ámʋ besi bʋlɩɩ́ tsútsúútsú bʋdɛ ɩtɔ́á ɩdɛ mʋ́sʋ́ yɔ kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Oyin ɔkʋ létsiá, bʋtɛtɩ́ mʋ Yosef. Otsú Yuda wúlu kʋá bʋtɛtɩ́ mʋ́ Arimateatɔ. Ɔha yilé ogyi, obú ɛ́ bʋ mʋsʋ. Ɩbʋ mʋ́tɔ́á ɔbʋ ɔmá ámʋ asʋ́n agyípʋ́tɔ, támɛ omotsulá dɩ́nká amʋ́ agywɩɩn pʋ́ amʋ́ bwɛhɛ́ ánfɩsʋ. Otsie ogyo Bulu iwíegyí ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Oyin ánfɩ lɔ́yɔ Pilato wá, yɔ́kʋlɩ́ mʋ ɔkpa ɔbɛ́ɛ, osíi Yesu fúli amʋ ha mʋ. Pilato lɛ́ha mʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ɩnʋ Yosef lɛ́yɛsɩɛɩ́ Yesu fúli, ɔlɔpʋ ɔhráda kɩ́klɩ mʋ ɩwɩ, pʋ́ mʋ yɔ́wa ɔbɔ́ kʋá mʋ onutó ɔlɛha bɛda bʋtátɔ́ há mʋ ɩwɩ, bʋmɔkʋ́púlá ɔhaa mʋ́tɔ́ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛkɛ ámʋ igyi Fieda. Ɛkɛ ámʋ igyi ogyá ɔdʋdákɛ́. Owí inyá tá pɛ́, ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ lafi asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Atsɩ ámʋ́ʋ́ bʋbuo mʋ tsú Galilea amʋ bobuo Yosef yɛ́kɩ Yesu opulákpá pʋ́ alɩá ɔlɔpʋ fúli amʋ tswɩ ɔbɔ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Beyinkí yɔ́ wóyí yɔ́kwɛ ohuam, ɔhɩ́ɛ́n pʋ́ ofobí fánfán ánɩ́ bɔ́pʋ yɛ́kpa Yesu. Botsutsúa abʋbwɛ ta á, owí latá, bɛda ɔkpʋ́nʋ́ ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ fɛ́ alɩá Mose Mbla lɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kwasieda, igyi ndawɔ́tswɩ́tɔ́ ɛkɛ gyankpapʋ bakɛ a, atsɩ ámʋ bɔkʋsʋ́ tsú afá ámʋ́ʋ́ bɔkwɛ yáɩ́ ámʋ yɔ́ Yesu ntsán ámʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bowun ánɩ́ bamína ibwi ámʋ́ʋ́ bɔpʋtin ɔbɔ́ ámʋ ɔnɔ́ ámʋ lɛ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mʋ́ sʋ bebitíwíé ɔbɔ́ ámʋtɔ, támɛ bʋmowun Yesu fúli amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Besi bʋlɩɩ́, bʋdɛ nwuntɔ bu. Bɛkɩ a, ayin abanyɔ́ akʋ lɩ́ɩ́ amʋ́ wá ɩnʋ á. Amʋ́ atadɩɛ dɛ ogyá kpa. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ifú lɛkɩtá atsɩ ámʋ, bɛda akpawunu pʋ́ ansɩ́tɔ́ bun ɔsʋlʋ́tɔ. Támɛ ayin ámʋ bɛfɩtɛ́ amʋ́ bɛɛ, “Ntogyi sʋ́ mlɩdɛ́ ɔkɩankpapʋ dunká afúlitɔ? ");
INSERT INTO nkoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔma nfɩ, alakʋ́sʋ́! Mlɩkaɩn asʋ́n ámʋ́ʋ́ ɔlɛbláa mlɩ brɛ́á mlɩa mʋnyɔ mlɩbʋ Galilea ɔmátɔ́ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ɔbɛ́ɛ, ‘Ilehián ánɩ́ bɛ́lɛ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ há lakpan abwɛpʋ́. Bɛ́da mɩ́ mántá oyikpalíhɛsʋ. Mʋ́ ɛkɛ sáásɩ́ a, nɔ́kʋsʋ́ tsú afúlitɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ɩnʋ atsɩ ámʋ bɛkaɩ́n Yesu asʋ́n ánfɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Beyinkí tsú ntsán ámʋ asɩ bɛbláa sumbí ayɔpʋ́ dúɔkʋn ámʋ pʋ́ aha atráhɛ amʋ́ʋ́ bʋbʋ ɩnʋ ámʋ fɛ́ɛ́ tɔ́á bayówun. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Atsɩá bɔyɔ ntsán ámʋ asɩ gyí, Magdalayintse Maria, Yohana pʋ́ Yakobo mʋ yin Maria. Amʋ́a atsɩ akʋá bʋbʋ amʋ́tɔ́ lɛ́kla asʋ́n ánfɩ suná sumbí ayɔpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Asʋ́n ámʋ lɔbwɛ sumbí ayɔpʋ́ ámʋ fɛ́ mimlála. Mʋ́ sʋ bʋmɔhɔ mʋ́sʋ́ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Támɛ Petro mʋ́ lɔ́kʋsʋ́, tsíí ɔsrɩ yɔ́ ntsán ámʋ asɩ. Olobun kpɛlɛ́kɩ ɔbɔ́ ámʋtɔ. Tati ámʋ́ʋ́ bɔpʋpúlá Yesu nkʋlɛ olowun ánɩ́ ɩda ɩfʋ́ntɔ́. Oleyinkí yɔ́ wóyítɔ́, ɔdɛ nwuntɔ bu tsú asʋ́n ánfɩ ɩlaba anfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ɛkɛ ámʋ kɛ́n á, abúopʋ amʋ abanyɔ́ bɛnatɩ́ bɔyɔ́ wúlu kʋá bʋtɛtɩ́ mʋ́ Emaustɔ. Tsú Yerusalem ya ɩnʋ bɔ́bwɛ fɛ́ máɩlɩ asienɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amʋ́ nkʋlɛ bʋna bʋdɛ nkɔmbɔ gyí tsu asʋ́n ámʋ́ʋ́ ɩlaba amʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Brɛ́á bʋdɛ mʋ́tɔ́ yɔ á, Yesu onutó ɛ́ lɔ́bɔtʋ amʋ́, mʋa amʋ́nyɔ bʋna. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bulu létin amʋ́ ansɩ́. Mʋ́ sʋ bʋmɛbɩ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Amansʋ ɩwɩ nkɔmbɔ mlɩná mlɩdégyí alɩ?” Besi lɩɩ́ tikpa, awɩrɛhɔ lɛkɩtá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Amʋ́tɔ́ ɔkʋlɛá bʋtɛtɩ́ mʋ Kleopa lɛ́fɩtɛ́ ɔbɛ́ɛ, “Fʋ́ nkʋlɛ gyí ɔfɔɔ́ Yerusalem wúlutɔ, fʋ́meyín asʋ́n ánɩ́ ɩlaba ɩnʋ nkɛ ánfɩtɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Amansʋ igyi?” Bɛbláa mʋ bɛɛ, “Yesu, Nasaretyin amʋ ɩwɩ asʋ́n igyi. Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ogyi. Ɔlɔbwɛ ofúla akpɔnkpɔntɩ, blɩ́ Bulu asʋ́n túmisʋ, Bulu mʋa anyánkpʋ́sa fɛ́ɛ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Anɩ Bulu igyí ahapʋ́ dɛhɛn pʋ́ wúlu ahandɛ bapʋ́ mʋ há ahá, bahá mʋ lowu ɩpɔ́n, dá mʋ mántá oyikpalíhɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tɛkɩ mʋgyí ɔhá ánɩ́ anɩlɛ́kɩ ɔkpa anɩaa, ɔbɛ́ha anɩ Israelfɔ abégyi ɩwɩ nɩ́. Ndɛ ɛkɛ sáásɩ́ ɔpá asʋ́n ánfɩ lɛ́bá. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mʋ́á ɩdʋn kʋ́ráá á, anɩtɔ atsɩ akʋ bayɔ́ mʋ ntsán ámʋ asɩ bakɩɛnɩ, támɛ bʋmowun mʋ fúli amʋ. Bɛɛ, bayówun Bulu-abɔpʋ akʋ babláa amʋ́ bɛɛ, ɔbʋ nkpa. Tɔ́á beyinkí bɛbláa anɩ lawá anɩ wánwan. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɩ́nɩ sʋ anɩtɔ akʋ ɛ́ basrɩ́ yɔ́ ntsán ámʋ asɩ, bayówun mʋ́ fɛ́ alɩá atsɩ ámʋ bɛba bɛblɩ́. Amʋ́ ɛ́ bʋmowun fúli amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩlémimlá o! Mlɩ agywɩɩn tamayɔ́ agyʋ́má ɔsasʋ. Nkálɩ igyi sʋ́ mlɩmɔ́hɔ asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɛblɩ́ tswɩ amʋ fɛ́ɛ́sʋ́ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mlɩméyín mlɩaa, ilehián ánɩ́ Kristo, (ɔhá ánɩ́ Bulu ladá mʋ ofúli amʋ) obówun ɩwɩɔsɩn, asa obénya mʋ numnyam?” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɩnʋ Yesu lɛ́lɛ mʋ ɩwɩ asʋ́n ánɩ́ bɔwanlɩ́n wá Bulu asʋn wanlɩ́nhɛ́ amʋtɔ, tsú Mosesʋ bɔtʋ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ fɛ́ɛ́sʋ́ asɩ súná amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Brɛ́á bowie wúlu amʋtɔ bɔyɔ́ á, Yesu lɔ́bwɛ fɛ́ ɔdɛtsʋ́ʋn ɔyɔ́ ɔtɩnɛ bambá. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Támɛ abúopʋ amʋ bɛbláa mʋ bɛɛ, “Anɩ sɩ́, owí lapɔn, dɩ anɩ wá ndɛ.” Mʋ́ sʋ Yesu lɛ́baɩ́ yɔ́ amʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Brɛ́á bʋdɛ atɔ́ gyí a, Yesu lɛ́lɛ bodobodo ipín, dá Bulu ɩpán. Mʋ́ʋ́ olebiabía mʋ́tɔ́ pʋ́há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ɩnʋnʋ amʋ́ ansɩ́sʋ́ lɛtɩtɩ́ɩ amʋ́, bɛbɩ mʋ, támɛ ɔlɔfwɩ sí amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɩnʋ bɛfɩtɛ́ aba bɛɛ, “Ansɩ́ mɛhɩɛ gyí anɩ brɛ́ ámʋ́ʋ́ anɩa mʋnyɔ anɩná, ɔdɛ anɩ asʋ́n bláa, ɔdɛ Bulu asʋn wanlɩ́nhɛ́ amʋ asɩ lɛ súná anɩ ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bɔkʋsʋ́ ɩnʋnʋ yínkí ba Yerusalem. Bɛba a, sumbí ayɔpʋ́ dúɔkʋn ámʋ pʋ́ aha tráhɛ bafia, ");
INSERT INTO nkoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bʋ́dɛblɩ́ bɛɛ, “Lɛ́lɛ́, anɩ Wíe lakʋ́sʋ́. Alalɛ́ ɩwɩ ɔwan súná Simon!” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mʋ́ sʋ ahá abanyɔ́ ámʋ ɛ́ bɛblɩ́ tɔ́á bayówun ɔkpatɔ. Tɔ́á bɔpʋbɩ́ mʋ gyí bodobodo amʋ́ʋ́ oleye ha amʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ahá abanyɔ́ ámʋ bʋbʋ mʋ́sʋ́ bʋdɛtɔɩ́ alɩ á, Yesu onutó lɛ́ba bɛlɩɩ́ amʋ́ nsɩnɛ́. Ɔlɛblɩ́ ɔbɛ́ɛ, “Ɩwɩ ilwíi mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Opúni letsií amʋ́, bɔwan. Ɩlɔbwɛ amʋ́ fɛ́ fúli bʋdewúun. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ɩnʋ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdɛ́ ifú nya, mlɩdɛ́ nwɛ́ɛn gyí mlɩ klʋntɔ alɩ? ");
INSERT INTO nkoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mlɩkɩ mɩ́ ɩbɩ, amlɩkɩ mɩ́ ayabiasɩ. Megyí mɩ́ onutó nɩ́? Mlɩkɩta mɩ́ amlɩkɩ. Fúli má ɔyʋlʋ́ʋ mʋ́a awú fɛ́ alɩá mbʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Brɛ́á ɔlɛblɩ́ asʋ́n ánfɩ tá á, ɔlɔpʋ mʋ ɩbɩ pʋ́ mʋ ayabi súná amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ansɩ́ lɛhɩɛ gyi amʋ́, asʋ́n ámʋ ɛ́ lɔ́wa amʋ́ wánwan. Mʋ́ sʋ bʋmohogyi ánɩ́ lɛ́lɛ́ mʋ nɩ. Ɩnʋ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩbʋ atogyihɛ kʋ nfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bɛha mʋ iye tɔhɛ́ itin kʋ, ");
INSERT INTO nkoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ɔlɔhɔ mʋ́, wɩ́ mʋ́ amʋ́ ansɩ́tɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɩ́nɩ gyí asʋ́n ánɩ́ nɛbláa mlɩ brɛ́á mbʋ mlɩ wá nɩ́. Nɛbláa mlɩ mbɛ́ɛ, ilehián ánɩ́ mɩ́ ɩwɩ asʋ́n kugyíkʋá bɔwanlɩ́n wá Mose Mbla, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ nwʋlʋ́ pʋ́ Israelfɔ ɩlʋ ɔwʋlʋ́tɔ́ fɛ́ɛ́ bɛ́ba mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɩnʋ olobwií amʋ́ agywɩɩn, mɛ́nɩ bónu Bulu asʋn wanlɩ́nhɛ́ amʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Bɔwanlɩ́n tswɩ bɛɛ, Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) amʋ obówun ɩwɩɔsɩn, wú. Bulu ɔbɔ́kʋsʋ́a mʋ mʋ́ ɛkɛ sáásɩ́ tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mʋ́ ɔma a, ahá bɛ́da Bulu asʋn wankláán ámʋ ɔkan mɩ́ ɩdátɔ́ há ɔmá fɛ́ɛ́ bɛɛ bʋdámli klʋntɔ, fɛ́kɩ Bulu obési amʋ́ lakpan kíé amʋ́. Béfi mʋ́ asɩ tsú Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mlɩgyí mɩ́ adansɩfɔ há asʋ́n ánfɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ amʋ́ʋ́ mɩ́ Sɩ́ lɛ́hɩɛ yáɩ́ há mlɩ ámʋ sɩ́sɩ́ mlɩ. Mʋ́ sʋ mlɩtsia wúlu anfɩtɔ alɩɩ yɔ́fʋn ɛkɛá Ɔŋɛ Wankɩ́hɛ́ amʋ obótsu ɔsʋ́sʋ́ bá bɛha mlɩ túmi.” ");
INSERT INTO nkoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Brɛ́á Yesu lɛ́blɩ́ asʋ́n ánfɩ tá á, ɔlɛkpa amʋ́ dálɩ, bɔyɔ Betania wúlutɔ. Ɩnʋ olotsu ɩbɩ fʋ́á, yúlá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Brɛ́á ɔdɛ amʋ́ yulá á, mʋa amʋ́nyɔ nsɩnɛ́ lɔ́wa ɩfɔ́ wa bɩ, Bulu lótsu mʋ ya ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɩnʋ bɛda akpawunu súm mʋ, bɔpʋ ansigyí kpɔnkpɔntɩ yínkí yétsiá Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Betsiá yɔ́ Bulu ɔtswɛ́kpa ɩnʋ brégyíbrɛ́, yɛ́kanfʋ́ Bulu.");
INSERT INTO nkoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asa ɔyɩ́ lɛbɛlɩn a, Asʋ́n ámʋ bʋ ɩnʋ. Asʋ́n ámʋ mʋa Bulu bʋ ɩnʋ. Asʋ́n ámʋ gyí Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Asʋ́n ámʋ mʋa Bulu bʋ ɩnʋ asa ɔyɩ́ lɛbɛlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mʋsʋ́ Bulu lɔ́tsʋn bwɛ tógyítɔ́. Tɔtɔɔtɔ má ɩnʋá Bulu lɔ́bwɛ tsʋn mʋ ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mʋtɔ nkpa itsú. Nkpa ámʋ tɔ́pʋ́ wankɩ ba ahá fɛ́ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wankɩ anfɩ tɔwánkɩ́ oklúntɔ, támɛ oklún mɔ́kʋ́gyi mʋ́sʋ́ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bulu lɔ́wa oyin ɔkʋá bʋtɛtɩ́ mʋ Yohane sɩ́sɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ɔlɛba bɛbláa ahá wankɩ amʋ ɩwɩ asʋ́n, mɛ́nɩ ahá fɛ́ɛ́ bɔ́hɔ asʋ́n ámʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Megyí Yohane onutó gyí wankɩ amʋ. Mʋ mʋ́ wankɩ amʋ ɩwɩ asʋ́n ɔlɛba bɛbláa ahá. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɔhá ámʋ́ʋ́ ogyi wankɩ onutó, ɔtɔwánkɩ́ há ɔhagyíɔha amʋ ɔbá ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɔbʋ ɔyɩ́ ánfɩtɔ. Mʋsʋ́ Bulu lɔ́tsʋn bwɛ ɔyɩ́, támɛ ɔyɩ́ ánfɩtɔ atsiápʋ́ bʋmɛbɩ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔlɛba mʋ onutó ɔmátɔ́, támɛ mʋ pɩ bʋmɔhɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Támɛ ɔlɛha ahá ánɩ́ bɔhɔ mʋ, hɔ mʋ gyi fɛ́ɛ́ ɔkpa ánɩ́ bʋbwɛ́ɛ Bulu abí. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Amʋ́ Bulu abí bwɛ motsú ɩlɩ́ntɔ, ntɛ́ɛ nyankpʋsa apɛ́bwɛtɔ, ntɛ́ɛ oyin ɔwɔ́lɩ ɔkpasʋ. Mboún Bulu onutó lɔ́bwɛ amʋ́ mʋ abí. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Asʋ́n ámʋ lébemlí nyankpʋsa, oletsiá anɩtɔ. Awɩtɔlɛ pʋ́ ɔnɔkwalɩ sɔ́ɔ́n létsiá mʋtɔ. Anɩlówun mʋ numnyam. Mʋ Sɩ lɔ́wa mʋ numnyam amʋ, tsúfɛ́ Obí ɔkʋkʋ́nʋ́ ɔkʋlɛ pɛ́ ogyi há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane lɛ́lɛ mʋ súná, tɔ́ɩ́ tsú mʋ ɩwɩ ɔbɛ́ɛ, “Ɔ́nɩ ɩwɩ asʋ́n nɛblɩ́ mbɛ́ɛ, ‘Ɔhá ámʋ́ʋ́ obuo mɩ ɔbá ámʋ dʋn mɩ, tsúfɛ́ ɔbʋ ɩnʋ asa bɔkwɩɩ́ mɩ́’ ” nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mʋ awɩtɔlɛ ɩtsɔ. Ɩ́nɩ sʋ́ ɔdɛ awɩtɔlɛ tsɔtsɔɔtsɔ ánfɩ wa há anɩ fɛ́ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesʋ Bulu mbla ámʋ ná ɩlɛba, támɛ ɔnɔkwalɩ mʋ́a awɩtɔlɛ mʋ́ ɩna anɩ Wíe Yesu Kristosʋ ɩlɛba. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ɔhaa mɔ́kʋ́wun Bulu kɩ. Obí ɔkʋkʋ́nʋ́ ɔkʋlɛ pɛ́, mʋ onutó ogyi Bulu, otsie Ɔsɩ́ ámʋ gyɔpɩsʋ, Ɔsɩ́ ámʋ tɛhɩ́ɛ́ kle mʋ asʋ́n ámʋ, nkʋlɛ labláa anɩ alɩá Bulu gyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Yudafɔ ahandɛ ánɩ́ bʋbʋ Yerusalem bɔwa Bulu igyí ahapʋ́ pʋ́ Lewifɔ Yohane wá bɛɛ bʋyɛ́fɩtɛ́ mʋ bɛɛ, ma ogyi? Yohane mési asʋansʋ ŋáín amʋ́. Ɔlɛlɛ bláa amʋ́ ɔbɛ́ɛ, “Megyí mɩ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ).” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bɛfɩtɛ́ mʋ bɛɛ, “Mʋ́mʋ́ fʋ́gyí ma? Fʋ́gyí Elia?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí mɩ́gyí Elia.” Bɛtrá fɩtɛ́ mʋ bɛɛ, “Fʋ́gyí Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ amʋ́ʋ́ ɔbɛ́ba amʋ?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ó-o.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mʋ́ʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Ma fʋhɩ́ɛ́ fʋgyi? Bla anɩ, mɛ́nɩ abɛ́yɛ́bláa ahá ámʋ́ʋ́ bɔwa anɩ ámʋ. Nkálɩ fʋ́dɛblɩ́ tsú fʋ́ onutó ɩwɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane lɔ́pʋ asʋ́n ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia lɛ́blɩ́ tswɩ lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́gyí ɔhá ámʋ́ʋ́ ɔdɛkplʋ́n dimbísʋ́ ɔbɛ́ɛ, ‘Mlɩtswii anɩ Wíe ɩkpa ámʋ ha mʋ’ amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ɩnʋ Farisifɔ akʋá bɔwa Yohane wá ɛ́ bɛfɩtɛ́ mʋ bɛɛ, “Nɩ́ megyí fʋ́gyí Kristo amʋ, megyí fʋ́gyí Elia ntɛ́ɛ Bulu Ɔnɔ́sʋ́ Ɔtɔɩ́pʋ́ amʋ́ʋ́ ɔbɛ́ba amʋ ɛ́ á, ntogyi sʋ́ fʋdɛ ahá asú bɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ntsu ndɛpʋbɔ́ ahá asú, támɛ ɔha ɔkʋ bʋ mlɩtɔ nfɩ, mlɩméyín mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mʋgyí ɔhá ánɩ́ obuo mɩ ɔbá nɩ́. Mmɔfʋn ánɩ́ nɛ́sankɩ́ mʋ ntʋkʋta ɔfɛ́ kpán.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Asʋ́n ánfɩ fɛ́ɛ́ lɛ́ba Yordan ntsu ɔbɩn Betania wúlutɔ. Ɩnʋ́ Yohane létsiá bɔ́ ahá asú nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɔyɩ kɛhɛ a, Yohane lówun ánɩ́ Yesu ná ɔbá mʋ wá. Mʋ́ʋ́ ɔlɛbláa ahá ámʋ ɔbɛ́ɛ, “Mlɩkɩ, Bulu Okúfabi amʋ ɔbá á. Mʋsʋ́ Bulu tɔtsʋn sí ɔyɩ́tɔ́ ahá lakpan kíé amʋ́ nɩ́! ");
INSERT INTO nkoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mʋ ɩwɩ asʋ́n nɛblɩ́ mbɛ́ɛ, ‘Ɔkʋ buo mɩ ɔbá. Ɔdʋn mɩ, tsúfɛ́ ɔbʋ ɩnʋ asa bɔkwɩɩ́ mɩ́’ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɩ́ onutó mmeyín mʋ, támɛ nɛba ndɛ ahá asú bɔ, mɛ́nɩ Israelfɔ bɛ́bɩ ɔhá ánɩ́ ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane lɛ́blɩ́ ɔbɛ́ɛ, “Nowun Ɔŋɛ Wankɩ́hɛ́ amʋ, ɔlɛkplɩ́ tsú ɔsʋ́sʋ́ fɛ́ abrɔ́dʋma bogyonká mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɩ́ onutó mmeyín mʋ, támɛ Bulu lɔ́wa mɩ́ ɔbɛ́ɛ mbá bɔpʋ ntsu bɔ ahá asú. Mʋlɛ́bláa mɩ ɔbɛ́ɛ, ‘Ɔhá ámʋ́ʋ́ fówun Ɔŋɛ Wankɩ́hɛ́ amʋ ɔbɛ́kplɩ́ tsú ɔsʋ́sʋ́ bogyonká mʋsʋ ámʋ ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ amʋ bɔ́ ahá asú nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nawun ánɩ́ ɩlaba mʋ́tɔ́. Mʋ́ sʋ ndɛ mʋ ɩwɩ adánsɩɛ gyí mbɛ́ɛ, mʋgyí Bulu mʋ Bi ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mʋ́ ɔyɩ kɛhɛ a, Yohane mʋa mʋ akasɩ́pʋ́ abanyɔ́ bɛsankí ba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Brɛ́á Yohane lówun Yesu dɛ́tsʋ́ʋn a, ɔlɛblɩ́ ɔbɛ́ɛ, “Mlɩkɩ, Bulu Okúfabi amʋ ná ɩnʋ á.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Akasɩ́pʋ́ abanyɔ́ ámʋ bonu asʋ́n ánfɩ. Mʋ́ sʋ bɛkplá buo Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu lɛ́damlí kɩ wun ánɩ́ bʋbuo mʋ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ntɔ mlɩdédunká?” Bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, nkʋ́nʋ fʋtsie?” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩba bɛkɩ.” Mʋ́ sʋ ayin abanyɔ́ ámʋ bobuo Yesu yɛ́kɩ mʋ otsiákpá. Ɩbɔ́bwɛ fɛ́ ntʋ́pwɛ dɔnatɔ. Betsiá mʋ wá tá owí. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ayin ámʋ́ʋ́ bonu asʋ́n ánɩ́ Yohane lɛ́blɩ́ tsú Yesu ɩwɩ, bɛkplá buo Yesu amʋtɔ ɔkʋlɛ gyí Simon Petro mʋ pio Andrea. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mʋ́ ɔma a, ɩtɔ gyankpapʋá Andrea lɔ́bwɛ gyí, oloyódunká mʋ pio Simon, bláa mʋ ɔbɛ́ɛ, “Anɩlawun Mesia.” (Mʋ́ asɩ gyí, “Kristo”, ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɩnʋ ɔlɛkpa Simon ba Yesu wá. Yesu lɛ́kɩ mʋ díín, ɔlɛblɩ́ ɔbɛ́ɛ, “Fʋ́gyí Yohane mʋ bi Simon nɩ. Tsú ndɛ pʋ́ya a, bɛ́tɩ fʋ́ Kefa.” (Griiki ɔblɩ́tɔ “Petro.” Mʋ́ asɩ gyí, “Bʋtá.”) ");
INSERT INTO nkoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɔyɩ́ kɛhɛ a, Yesu lɔ́bwɛ ɔbɛ́ɛ mɔ́yɔ Galilea ɔmátɔ́, olowun Filipo. Mʋ́ʋ́ ɔlɛbláa Filipo ɔbɛ́ɛ, “Buo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo otsú Betsaida, Andrea mʋa Petro wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo lówun Nataniel, ɔlɛbláa mʋ ɔbɛ́ɛ, “Anɩlawun oyin ámʋ́ʋ́ Mose lɔ́wanlɩ́n mʋ ɩwɩ asʋ́n wá Bulu mbla ámʋtɔ, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ ɛ́ bɔwanlɩ́n mʋ ɩwɩ asʋ́n ámʋ. Mʋ dá gyí Yesu. Mʋ sɩ gyí Yosef, otsú Nasaret wúlutɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ɩtɔ yilé kʋ bɛ́talɩ́ dalɩ tsu Nasaret wúlutɔ?” Filipo lɛ́bláa mʋ ɔbɛ́ɛ, “Ba afʋbɛkɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Brɛ́á Yesu lówun Nataniel ɔbá mʋ wá á, ɔlɛblɩ́ ɔbɛ́ɛ, “Israelyin onutónutó nɩ́. Afunu kʋkʋ ma mʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Nkálɩ lɔbwɛ fɛbɩ mɩ́?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nowun fʋ brɛ́á fʋbʋ pɔntɔ-oyí ámʋ asɩ ɩnʋ, asa Filipo lɛ́bɛtɩ fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel lɛ́bláa mʋ ɔbɛ́ɛ, “Osunápʋ́, fʋ́gyí Bulu mʋ Bi Israel Owíe amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Alɩ ámʋ́ʋ́ nabláa fʋ mbɛ́ɛ, nowun fʋ pɔntɔ-oyí ámʋ asɩ ámʋ sʋ fahogyi? Fówun ofúla ánɩ́ ɩdʋn ɩ́nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu lɛ́trá bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, mlówun ánɩ́ ɔsʋ́sʋ́ lafínkí, Bulu-abɔpʋ bʋdɛ ɔsʋ́sʋ́ yɔ yínkí bá Nyankpʋsa-Mʋ-Bi ámʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ɛkɛ sáásɩ́ a, betsiá ɔká Kana wúlu ánɩ́ ɩbʋ Galilea ɔmátɔ́. Yesu mʋ yin bʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bɛtɩ Yesu mʋa mʋ akasɩ́pʋ́ ɛ́ mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Brɛ́á amʋ́ ntá lɛta á, Yesu mʋ yin lɛ́bláa mʋ ɔbɛ́ɛ, “Bʋtráa bʋma ntá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Amʋ́ yín, yɛ́ɛ megyí mɩ́ asʋ́n igyi o! Mɩ́ brɛ́ mɔkʋ́nyá fʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mʋ yin lɛ́bláa wóyí ámʋtɔ asúmpʋ́ ɔbɛ́ɛ, “Mlɩbwɛ dɩnka asʋ́ngyíasʋ́n ánɩ́ ɔbɛ́bláa mlɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yudafɔ bʋtɔfwɩ́ ɩwɩ amʋ́ amándɩ́ɛ́ ɔkpasʋ. Mʋ́ sʋ bɔpʋ awʋndɩ akpɔnkpɔɔnkpɔntɩ asie yáɩ́ wóyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu lɛ́bláa ɩnʋ asúmpʋ́ amʋ ɔbɛ́ɛ, “Mlɩsa ntsu bʋla awʋndɩ ámʋ fɛ́ɛ́.” Lɛ́lɛ́ bɛsa. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩsa ɩkʋ ya nkɛsʋ ɔkɩ́pʋ amʋ.” Bɛsa ya mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɔlɛda mʋ́ ɔnɔ́ á, ɩladámlí bwɛ́ ntá. Omeyín ɔtɩ́nɛ́á benya ntá ámʋ tsú. (Támɛ asúmpʋ́ amʋ mʋ́ bʋyin.) Ɩnʋ ɔlɛtɩ ɔká otsiápʋ amʋ ya ɩtsɛ́tɔ́, ");
INSERT INTO nkoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɔlɛbláa mʋ ɔbɛ́ɛ, “Nta wankláán ɔhagyíɔha tegyankpá yáɩ́. Nɩ́ bonu mʋ́ tá asa bʋtɔpʋ́ mʋ́á ɩma alɛ ba. Támɛ fʋ́ mʋ́ fapʋ́ wankláán ámʋ yáɩ́ bɔfʋn séi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɩ́nɩ gyí osúna gyankpapʋ ánɩ́ Yesu lɔ́bwɛ nɩ́. Ɔlɔbwɛ mʋ́ Kana ánɩ́ ɩbʋ Galilea ɔmátɔ́, pʋ́lɛ́ mʋ numnyam ɔwan. Ɩlɛha mʋ akasɩ́pʋ́ bɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɩ́nɩ ɔma a, Yesu mʋa mʋ yin, mʋ apíó pʋ́ mʋ akasɩ́pʋ́ bɔyɔ Kapernaum wúlutɔ, yétsiá ɩnʋ nkɛ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Brɛ́á nkɛá Yudafɔ bɔ́pʋgyi Israelfɔsʋ Katsʋn Nkɛ lowie wóyí tá á, Yesu lɔ́dʋ yɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɔlɔyɔ Bulu ɔtswɛ́kpa amʋ wunsɩnɛ́sʋ́ yówun ánɩ́ ahá bʋdɛ nnantswie, akúfa pʋ́ abrɔ́dʋma fɛ. Olowun akʋ ɛ́ bʋtsie mpʋ́nʋ́asɩ bʋdɛ kɔ́ba tsɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ɩnʋ ɔlɔbwɛ mplɩ, wíé amʋ́tɔ́, gyáa amʋ́a mbwɩ ámʋ fɛ́ɛ́ dálɩ. Olowutá kɔ́ba atsɛ́pʋ amʋ mpʋ́nʋ́ dá, dá amʋ́ kɔ́ba sáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mʋ́ʋ́ ɔlɛbláa abrɔ́dʋma afɛpʋ́ ámʋ ɔbɛ́ɛ, “Mlɩlɛ amʋ́ nfɩ! Mlɩmápʋ mɩ́ Sɩ́ wóyítɔ́ bwɛ́ mlɩ ibíá ogyíkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɩ́nɩá ɩlɛba alɩ sʋ á, mʋ akasɩ́pʋ́ amʋ bɛkaɩ́n Bulu asʋn wanlɩ́nhɛ́ anfɩsʋ. “Fʋ́ osúmkpá amʋ asʋ́n ɩhɩ́ɛ́ igyi mɩ́ asʋnbogya.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yudafɔ ahandɛ amʋ bɛba Yesu wá bɛfɩtɛ́ mʋ bɛɛ, “Osúna mɔmʋ fɔ́bwɛ pʋ́súná anɩ ánɩ́ Bulu túmitɔ fʋ́dɛ ɩ́nɩ bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩbwie Bulu ɔtswɛ́kpa anfɩ, nɔ́pʋ nkɛnsá yí mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yudafɔ ahandɛ amʋ bɛbláa mʋ bɛɛ, “Nfí adʋana-sie kɛ́kɛ́ bɔpʋyi obu ánfɩ. Mʋ́ fʋ́ mʋ́ fɛɛ, fɔ́pʋ nkɛnsá yí mʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Támɛ mʋ nyankpʋsa-oyí ɩwɩ asʋ́n ɔdɛblɩ́, megyí Bulu ɔtswɛ́kpa amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Brɛ́á Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ ɔma a, mʋ akasɩ́pʋ́ amʋ bɛkaɩ́n ánɩ́ ɔlɛblɩ́ asʋ́n ánfɩ. Mʋ́ sʋ bɔhɔ Bulu asʋ́n pʋ́ Yesu asʋn blɩ́hɛ́ amʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu lɔ́bwɛ osúna tsɔtsɔɔtsɔ Israelfɔsʋ Katsʋn Nkɛ ámʋtɔ brɛ́á ɔbʋ Yerusalem, ahá tsɔtsɔɔtsɔ bowun. Mʋ́ sʋ bɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Támɛ Yesu mɔ́pʋ ansɩ́ dɩ́nká amʋ́sʋ́, tsúfɛ́ oyin alɩá amʋ́ fɛ́ɛ́ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mehián ánɩ́ ɔhaa ɔbɛ́bláa mʋ ɔha ɩwɩ asʋ́n, tsúfɛ́ mʋ onutó oyin asʋ́n ánɩ́ ɩbʋ nyankpʋsa klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yudafɔ ɔhandɛ ɔkʋ létsiá, bʋtɛtɩ́ mʋ Nikodemo. Farisiyin ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɔlɛba Yesu wá ɛkɛ ɔkʋ onyé bɛbláa mʋ ɔbɛ́ɛ, “Osunápʋ́, anɩyin ánɩ́ Bulu lɔ́wa fʋ́ sɩ́sɩ́ fɛ́ atɔ́ osunápʋ́. Tsúfɛ́ ɔhaa mɛ́ɛtalɩ́ bwɛ́ osúna anfɩ fʋ́dɛbwɛ ánfɩ, nɩ́ Bulu móbúo mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ fʋ́ bláa, ɔhaa mɛ́ɛtalɩ́ nyá Bulu ogyi iwíe mʋsʋ, nkɛ́tɩ balákwɩ́ɩ́ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Nkálɩ́ bɛ́lakwɩ́ɩ́ ɔhá ánɩ́ aladan? Ɔbɛ́talɩ́ sánkí wíé mʋ yin iputɔ, ɔbɛ́lakwɩ́ɩ́ mʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ fʋ́ bláa. Nɩ́ bʋmɛlakwɩ́ɩ́ ɔkʋ tsʋn ntsu mʋ́a Ɔŋɛ Wankɩ́hɛ́tɔ á, ɔmɛ́ɛtalɩ́ wíé Bulu iwíegyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ɔyʋlʋ́ʋ nkpa itsú nyankpʋsatɔ, ɔŋɛ́tɔ́ klɛ́ ɛ́ itsú Bulu Ɔŋɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mʋ́ sʋ máha mʋ́ ɩwa fʋ́ wánwan ánɩ́ nabláa fʋ mbɛ́ɛ, ilehián ánɩ́ bɛ́lakwɩ́ɩ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Afú tɔtsʋn yɔ ɔtɩ́nɛ́á ideklé. Fʋtonú mʋ́ nka, támɛ fʋmeyín ɔtɩ́nɛ́á itsú pʋ́ ɔtɩ́nɛ́á ɩyɔ́. Alɩ kɛ́n igyi há ɔhagyíɔha ánɩ́ bakwɩ́ɩ́ mʋ tsú Ɔŋɛ́ ámʋtɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ngya ntɔ asʋ́n nɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Israelfɔ osunápʋ́ yilé fʋ́gyi, mʋ́ fɛɛ fʋmɔkʋ́nú asʋ́n ánfɩ asɩ? ");
INSERT INTO nkoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ɔnɔkwalɩ ndɛ fʋ́ bláa. Tɔ́á anɩyin ɩwɩ anɩdɛ́tɔɩ́ tsú, tɔ́á anɩlawun ɛ́ ɩwɩ anɩdɛ́ adánsɩɛ gyí, támɛ mlɩtamahɔ anɩ asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɩ́ nɛbláa mlɩ tɔ́á ɩdɛ mʋ́sʋ́ yɔ ɔyɩ́ ánfɩtɔ, mlɩmóhogyi a, nkálɩ ɩbɔ́bwɛ nɛbláa mlɩ tɔ́á ɩdɛ mʋ́sʋ́ yɔ ɔsʋ́sʋ́ mboún mlóhogyi? ");
INSERT INTO nkoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ɔhaa mɔ́kʋ́dʋ́ yɔ́ ɔsʋ́sʋ́ ɩnʋ kɩ, nkɛ́tɩ Nyankpʋsa-Mʋ-Bi ámʋ́ʋ́ olotsu ɩnʋ ba amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Alɩ ámʋ́ʋ́ Mose lɔ́pʋ kɔɔ́brɩ ɩwɔ síán oyísʋ́, tsú mʋ́ lɩ́ɩ́ dimbísʋ́ ɩnʋ ámʋ a, alɩ kɛ́n ilehián ánɩ́ bɛ́da Nyankpʋsa-Mʋ-Bi ámʋ mántá oyísʋ́, tsú mʋ́ lɩ́ɩ́, ");
INSERT INTO nkoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mɛ́nɩ ɔhagyíɔha ánɩ́ ɔlɔhɔ mʋ gyi obénya nkpa ánɩ́ ɩtamatá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tsúfɛ́ dwɛ́ Bulu lɛ́hɩɛ dwɛ́ anyánkpʋ́sa. Mʋ́ sʋ ɔlɔpʋ mʋ Bi ɔkʋkʋ́nʋ́ ɔkʋlɛ pɛ́ ámʋ há, mɛ́nɩ ɔhagyíɔha ánɩ́ ɔlɔhɔ mʋ gyi omóowu, mboún obénya nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bulu mɔ́pʋ mʋ Bi ámʋ sɩ́sɩ́ ɔyɩ́ ánfɩtɔ ɔbɛ́ɛ, ɔbá begyi ahá asʋ́n, ɔha ahá ɩpɔ́n, mboún ɔbɛ́ɛ, ɔbá bɔhɔ ahá nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ɔhá ánɩ́ ɔlɔhɔ mʋ Bi ámʋ gyi lagyi asʋ. Ɔhá ánɩ́ ɔmɔhɔ mʋ Bi ámʋ gyi a, Bulu lahá mʋ ɩpɔ́n dodo, tsúfɛ́ ɔmɔhɔ mʋ Bi ɔkʋlɛ pɛ́ ámʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Alɩá ɔbɛ́ha ɩpɔ́n ámʋ gyí, wankɩ amʋ laba ɔyɩ́tɔ́, támɛ ahá bɔdwɛ oklún dʋn wankɩ amʋ, tsúfɛ́ lalahɛ abwɛpʋ́ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ɔhagyíɔha ánɩ́ ɔtɔbwɛ́ lalahɛ tolú wankɩ amʋ. Ɔtamakpʋ́kpɛ́ mantáa mʋ́, tsúfɛ́ ɔdɛ ifú nya ánɩ́ mʋ bwɛhɛ́ bɛ́lɩn ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Támɛ ɔhá ánɩ́ ɔtɔbwɛ́ yilé tɛhá wankɩ amʋ tɔwánkɩ́ wʋ́lɩ́ mʋsʋ, mɛ́nɩ ahá bówun ánɩ́ Bulu apɛ́ ɔdɛbwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɩ́nɩ ɔma a, Yesu mʋa mʋ akasɩ́pʋ́ bɛdalɩ Yerusalem yɔ́ Yudea ɔmátɔ́. Betsiá ɩnʋ kpalobí, oletsiá bɔ ahá asú. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Alɩ brɛ́ ámʋtɔ á, Yohane ɛ́ dɛ́ ahá asú bɔ Aenon nsáɩntɔ, mantáa Salim wúlu. Tsúfɛ́ ntsu dada nsɩnɛ́ ɩnʋ. Ahá betsiá yɔ́ mʋ wá, oletsiá bɔ́ amʋ́ asú. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Bʋmɔkʋ́nyá kɩ́tá Yohane tswɩ obu alɩ brɛ́ ámʋtɔ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɩwɩgyʋráa ɩwɩ nwɛ́ɛngyí kʋ lɛba Yohane akasɩ́pʋ́ pʋ́ Yudayin ɔkʋ nsɩnɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɩnʋ Yohane akasɩ́pʋ́ bɔyɔ mʋ wá yɛ́bláa mʋ bɛɛ, “Osunápʋ́, yɛ́ɛ fakáɩ́n oyin ámʋ́ʋ́ fʋ́a mʋnyɔ mlɩlétsiá Yordan bʋnkpa ɔbɩn, fegyi mʋ ɩwɩ adánsɩɛ wankláán ámʋsʋ? Ɔdɛ ahá asú bɔ, ahá fɛ́ɛ́ bʋdɛ mʋ wá yɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔhaa mɛ́ɛtalɩ́ bwɛ́ tɔtɔ, nkɛ́tɩ Bulu lahá mʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mlɩ onutó mlɛ́talɩ́ gyi mɩ adánsɩɛ ánɩ́ nɛbláa mlɩ mbɛ́ɛ, ‘Megyí mɩ́gyí Kristo amʋ, támɛ Bulu lɔ́wa mɩ́ gya mʋ nkpá.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ɩnʋ ɔlɛha amʋ́ yébi ɔbɛ́ɛ, “Ɔká otsiápʋ bʋ́ mʋ ka. Ɔká otsiápʋ amʋ mʋ nyawie ɛ́ tetsíá ɔká otsiákpá ɩnʋ, mɛ́nɩ ansɩ́ bégyi mʋ nɩ́ onú mʋ nyawie amʋ ɔmɛ. Alɩ kɛ́n ansɩ́ dɛ mɩ́ gyí séi nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mɩ́ atʋmabi bɛ́ta wíé mʋ klɛtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɔhá ámʋ́ʋ́ otsú ɔsʋ́sʋ́ ámʋ dʋn ɔhagyíɔha. Ɔhá ánɩ́ otsú ɔsʋlʋ́sʋ ɛ́ gyí ɔsʋlʋ́sʋ ɔha. Ɔsʋlʋ́sʋ asʋ́n ɔtɛblɩ́, támɛ ɔhá ánɩ́ otsú ɔsʋ́sʋ́ dʋn ɔhagyíɔha. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Otegyi tɔ́á alawun pʋ́ tɔ́á alanú ɩwɩ adánsɩɛ, ɔhaa tamahɔ mʋ asʋn blɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Támɛ ɔhagyíɔha ánɩ́ ɔlɔhɔ mʋ asʋn blɩ́hɛ́sʋ gyi dɛ́ mʋ́sʋ́ si ánɩ́ Bulu asʋ́n igyi ɔnɔkwalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɔhá ámʋ́ʋ́ Bulu lɔ́wa ámʋ tɛlɛ́ Bulu asʋ́n blɩ́, tsúfɛ́ Bulu tɔpʋ́ Ɔŋɛ́ ámʋ bʋ́lá mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ɔsɩ́ ámʋ tɔdwɛ́ mʋ Bi ámʋ, alapʋ́ túmi fɛ́ɛ́ wá mʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ɔhagyíɔha ánɩ́ ɔlɔhɔ mʋ Bi ámʋ gyi bʋ nkpa ánɩ́ ɩtamatá. Ɔhagyíɔha ánɩ́ ɔmɔhɔ mʋ gyi má nkpa ánɩ́ ɩtamatá. Bulu ɩsʋbɩtɩ́ ɛ́ ɩdɩn mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisifɔ bonu ánɩ́ Yesu dɛ́ abúopʋ nya, bɔ́ amʋ́ asú dʋn Yohane. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Támɛ megyí Yesu onutó dɛ́ amʋ́ bɔ. Mʋ akasɩ́pʋ́ dɛ́ amʋ́ bɔ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Brɛ́á Yesu lɛ́bɩ ánɩ́ Farisifɔ ámʋ banú asʋ́n ánfɩ á, ɔlɛdalɩ Yudea ɔmátɔ́ yínkí yɔ́ Galilea ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Támɛ lehián ánɩ́ ɔbɔ́tsʋn Samariafɔ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu lóyówie Sikar ánɩ́ igyi Samaria wúlu kʋtɔ. Wúlu anfɩ bʋ mantáa ɔsʋlʋ́ʋ kʋá Yakob lɔ́pʋhá mʋ bi Yosef bɩ́mbɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɩnʋ́ Yakob ibún bʋ nɩ. Ɔkpa ámʋ bʋ ɩfɔ́. Mʋ́ sʋ Yesu lótsutsúa obowie ɩnʋ á, ɩlapíán mʋ. Mʋ́ sʋ oletsiá ibún ámʋ asɩ. Alɩ brɛ́ ámʋtɔ á, ɩlabwɛ́ fɛ́ ɔpawísʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɩnʋ á, Samariayintse ɔkʋ lɛ́ba ntsu ɔsakpá. Yesu lɔ́kʋlɩ́ mʋ ɔbɛ́ɛ, “Nobwíí ɩpa, ha mɩ́ ntsu annu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Alɩ brɛ́ ámʋtɔ á, Yesu akasɩ́pʋ́ bɔyɔ́ wúlutɔ yɔ́hɔ atogyihɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yudafɔ bʋtamapʋ́ ɩbɩ da Samariafɔ nwɛ núu ntsu. Mʋ́ sʋ ɔtsɩ ámʋ lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Yudayin fʋgyi, mɩ́ ɛ́ Samariayintse ngyi. Nkálɩ igyi sʋ́ fʋdɛ mɩ́ ntsu kʋlɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ fʋyin Bulu atokiehɛ́ pʋ́ ɔhá ánɩ́ ɔdɛ fʋ́ ntsu kʋlɩ́ á, tɛkɩ fɔ́kʋlɩ́ mʋ, ɔbɛ́ha fʋ́ ntsu ánɩ́ ɩtɛhá nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɔtsɩ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Anɩ sɩ́, fʋmɛdɛ́ ɔfɛ́, ibún ánfɩtɔ ɛ́ bʋ oklú. Nkʋ́nʋ fénya ntsu ánɩ́ ɩtɛhá nkpa? ");
INSERT INTO nkoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fʋ́dʋn anɩ náin Yakob ánɩ́ olokwi ibún ánfɩ há anɩ, mʋa mʋ abí pʋ́ amʋ́ mbwɩ bonu ntsu mʋ́tɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔmɛwʋ́lɩ bɛ́lakɩ́tá ɔhagyíɔha ánɩ́ otonu ibún ánfɩtɔ ntsu. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Támɛ ɔhagyíɔha ánɩ́ obónu ntsuá nɛ́ha mʋ a, ɔmɛwʋ́lɩ mɛ́ɛtrá kɩtá mʋ ɛkɛkɛɛkɛ. Ntsu ámʋ́ʋ́ nɛ́ha mʋ amʋ ɩbɛ́damlí ntsu ɔwɩ́kpa mʋtɔ ánɩ́ ɩbɛ́lɩn ha nkpa ánɩ́ ɩtamatá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɔtsɩ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Anɩ sɩ́, ha mɩ́ ntsu ánfɩ kʋ, mɛ́nɩ ɔmɛwʋ́lɩ mɛ́ɛtrá kɩtá mɩ́, mmɛ́ɛtrá ba nfɩ ɛ́ bɛsa ntsu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Yɛtɩ fʋ́ kúlu amlɩba.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɔtsɩ ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mma okúlu.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔnɔkwalɩ igyi fablɩ́ ánɩ́ fʋma okúlu. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tsúfɛ́ fatsía akúlu tse nu kɩ. Mégyí fʋ́ kúlu gyí oyin ámʋ́ʋ́ fʋ́a mʋnyɔ mlɩná séi ámʋ ɛ́. Fawá ɔnɔkwalɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mʋ́ʋ́ ɔtsɩ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Anɩ sɩ́, nawun ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ fʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anɩ anáin Samariafɔ bosúm Bulu ɩbʋ ánfɩsʋ, támɛ mlɩ Yudafɔ mʋ́ mlɩaa Yerusalem kóún lehián ánɩ́ ɔhagyíɔha obósum Bulu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔtsɩ, hɔ mɩ́ asʋ́n ánfɩsʋ gyi. Brɛ́ kʋ bɛ́ba ánɩ́ ahá bʋmɛ́ɛtrá súm Ɔsɩ́ ámʋ ɩbʋ ánfɩsʋ ntɛ́ɛ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mlɩ Samariafɔ mlɩméyín ɔhá ánɩ́ mlɩdésum. Anɩ Yudafɔ mʋ́ anɩyin ɔhá ánɩ́ anɩdésum, tsúfɛ́ Yudafɔsʋ ɩna nkpahɔ́ɔ lɛba ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Brɛ́ ɩbá, ɩlafʋn ta ánɩ́ Bulu asúmpʋ́ anɔkwalɩpʋ bósum Ɔsɩ́ ámʋ ɔŋɛ́tɔ́ pʋ́ ɔnɔkwalɩsʋ. Tsúfɛ́ ahá ánfɩ odu Ɔsɩ́ ámʋ dédunká ɔbɛ́ɛ bʋsúm mʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ɔŋɛ́ Bulu gyí. Mʋ́ sʋ ilehián ánɩ́ ahá ánɩ́ bʋtosúm mʋ bósum mʋ ɔŋɛ́tɔ́ pʋ́ ɔnɔkwalɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɔtsɩ ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Nyin ánɩ́ Mesia, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) ɔbɛ́ba. Nɩ́ ɔbá á, ɔbɛ́lɛ asʋ́ngyíasʋ́n asɩ súná anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ ánfɩ ndɛ fʋ́ asʋ́n bláa anfɩ gyí Kristo amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɩnʋ akasɩ́pʋ́ amʋ bɛsankí tsú wúlutɔ ba bɔtʋ amʋ́. Ɩlɔwa amʋ́ wánwan ánɩ́ bawun Yesu mʋa ɔtsɩ bʋlɩɩ́ bʋdɛtɔɩ́. Támɛ amʋ́tɔ́ ɔkʋkʋ mɛ́talɩ́ fɩtɛ́ ɔbɛ́ɛ, “Ntɔ fʋdedunká tsú mʋ wá, ntɛ́ɛ ntogyi sʋ́ fʋ́a ɔtsɩ ámʋ mlɩdɛ́tɔɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɔtsɩ ámʋ lési mʋ ɔlɔ́ yáɩ́ ɩnʋ, yínkí yɔ́ wúlutɔ yɛ́bláa ahá ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mlɩba amlɩbɛkɩ oyin ɔkʋá alabláa mɩ tɔ́á nabwɛ́ kɩ fɛ́ɛ́. Mlɩlahogyi mlɩaa, megyí Kristo amʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mʋ́ sʋ ahá bɛdalɩ tsu wúlu amʋtɔ bɛkɩ Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Alɩ brɛ́ ámʋtɔ á, mʋ akasɩ́pʋ́ ámʋ bʋdɛ mʋ kokóli bɛɛ, ogyíi atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Támɛ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mbʋ tɔ́á négyi, mlɩméyín mʋ́ ɩwɩ kʋkʋʋkʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mʋ́ sʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ aba bɛɛ, “Ntɛ́ɛ ɔkʋ labɛha mʋ tɔkʋ alagyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ atogyihɛ gyí ánɩ́ nɔ́bwɛ tɔ́á ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ ɔbɛ́ɛ mbwɛ́ɛ, ammɔ mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yɛ́ɛ mlɩtɛblɩ́ mlɩaa, ‘Tsra ana pɛ́ lasí ayó tɩ́nbɩ bɔ́fʋn?’ Támɛ ndɛ mlɩ bláa mbɛ́ɛ, mlɩtsu ansɩ́ kɩ adɔbʋ́ʋ amʋtɔ, ayó ámʋ ɩlablɩ fʋn tɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bʋdɛ mʋ atɩ́npʋ akɔ ka dodo. Bʋdɛ mʋ́ tɩ́n yaɩ́ há nkpa ánɩ́ ɩtamatá. Mʋ́ sʋ ansɩ́ bégyi adupʋ́ mʋ́a atɩ́npʋ amʋ fɛ́ɛ́ ɛkɛwʋ́lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mʋ́ sʋ ɔnɔkwalɩ igyi bʋtɛblɩ́ bɛɛ, ‘Ɔkʋ todú, ɔkʋ ɛ́ tɛtɩn.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɔwa mlɩ mbɛ́ɛ mlɩyɛ́tɩn ayóá mlɩmɔ́yɔ mʋ́ odukpá. Aha bambá lɔ́yɔ mʋ́ ɩwɩ agyʋ́má, ɩlawá labi há mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariafɔá bʋbʋ wúlu amʋtɔ tsɔtsɔɔtsɔ bɔhɔ Yesu gyi, adánsɩɛ ámʋ́ʋ́ ɔtsɩ ámʋ légyi suná amʋ́ ɔbɛ́ɛ, “Alabláa mɩ tógyítɔ́á nabwɛ́ mɩ́ nkpatɔ fɛ́ɛ́” ámʋ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɩ́nɩ sʋ brɛ́á bɛba Yesu wá á, bokokóli mʋ bɛɛ, otsía amʋ́ wá. Yesu létsiá ɩnʋ nkenyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesu asʋn blɩ́hɛ́ sʋ Samariafɔ ámʋ tsɔtsɔɔtsɔ ɛ́ bɛlahɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bɛbláa ɔtsɩ ámʋ bɛɛ, “Megyí fʋ́ asʋ́n ámʋ sʋ́ anɩlɛ́trá hɔ mʋ gyi ngya o. Anɩ onutó anɩlanú, anɩlawun ánɩ́ lɛ́lɛ́ oyin ánfɩ gyí ɔyɩ́tɔ́ Nkpa Ɔhɔ́pʋ amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nkenyɔ́ ámʋ ɔma a, Yesu lɛ́natɩ́ yɔ́ Galilea ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Tsúfɛ́ mʋ onutó olowun blɩ́ ɔbɛ́ɛ, “Bʋtamabú Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ mʋ onutó ɔmátɔ́.”) ");
INSERT INTO nkoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Brɛ́á olowie Galilea a, ɩnʋfɔ bɔhɔ mʋ atúu, tsúfɛ́ amʋ́ onutó bɔyɔ Yerusalem Yudafɔsʋ Katsʋn Nkɛ ámʋ ogyíkpá. Mʋ́ sʋ bowun tɔ́á ɔlɔbwɛ ɩnʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu lɛ́trá yinkí yɔ́ Galilea ɔmátɔ́, Kana wúlutɔ, ɔtɩ́nɛ́ ámʋ́ʋ́ ɔlɛdamlí ntsu bwɛ́ ntá ámʋ. Ɔmá ɔhandɛ ɔkʋ tsie Kapernaum wúlutɔ. Ɔbʋ obi yinhɛ́ ɔkʋá ɔda ɔdɛlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Brɛ́á ɔhandɛ amʋ lónu ánɩ́ Yesu latsú Yudea ba Galilea a, olegya mʋ ɔkpa yókokóli mʋ ɔbɛ́ɛ, mʋ bi yínhɛ́ lawú tá, ɔkplɩ́ɩ ba Kapernaum, ɔbɛtsa mʋ ɩlɔ ha mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mʋ́ sʋ nɩ́ mlɩmɔ́kʋ́wun osúna a, mlɩmɔ́ɔhɔ mɩ gyi ɛkɛkɛɛkɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɔmá ɔhandɛ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé! Nɩ́ anɩ ayabi mɔwa ɔsa á, kebi ámʋ obówu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Yɔ! Fʋ́ bí ámʋ obénya nkpa!” Oyin ámʋ lɔ́hɔ asʋ́n ámʋ́ʋ́ Yesu lɛ́bláa mʋ amʋsʋ gyi, oleyinkí ɔyɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Brɛ́á ɔyɔ́ á, mʋ asúmpʋ́ bɛba befia mʋ, bláa mʋ bɛɛ, “Fʋ́ bí ámʋ lanyá nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɩnʋ ɔlɛfɩtɛ́ amʋ́ brɛ́á ɩwɩ lɔ́wa mʋ bi ámʋ ɔnlɩn. Bɛbláa mʋ bɛɛ, “Owísó ámʋ lési mʋ ígye ɔpa ɔdɔ-kʋlɛtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɩnʋ á, ɔlɛkaɩ́n ánɩ́ alɩ brɛ́ ámʋtɔ kɛ́n Yesu lɛ́bláa mʋ ɔbɛ́ɛ, mʋ bi ámʋ obénya nkpa nɩ́. Ɩ́nɩ sʋ mʋa mʋ wóyítɔ́fɔ fɛ́ɛ́ bɔhɔ Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɩ́nɩ gyí osúna nyɔɔsɩá Yesu lɔ́bwɛ brɛ́á olotsu Yudea ba Galilea nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Asʋ́n ánfɩ ɔma a, Yesu lɔ́dʋ yɔ́ Yerusalem Yudafɔ Bulusúm nkɛ kʋ ogyíkpá. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bɔpwɛ buntíi wá wúlu amʋ. Bokwi ibún kʋ mantáa buntíi amʋ ɔkpa ɔnɔ́ kʋá bʋtɛtɩ́ mʋ́ Akúfa Ɔtsʋ́nkpa. Bʋtɛtɩ́ ibún ámʋ Betesda Hebri ɔblɩ́tɔ. Beyi mbu anu bómlí mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Alɔpʋ tsɔtsɔɔtsɔ bʋbun ibún ámʋ asɩ mbu ánfɩtɔ. Amʋ́tɔ́ akʋ bʋgyi ansibi abwiepʋ́, abɔ pʋ́ tsukʋlɛ asínpʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oyin ɔkʋá alasin tsukʋlɛ nfí adʋasa-kwe (38) kɛ́kɛ́ da ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Brɛ́á Yesu lówun mʋ a, olowun ánɩ́ alalɔ́, dɩ́ ɩnʋ wá ɔpá. Mʋ́ sʋ ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋdeklé fɛɛ ɩwɩ ɩwá fʋ́ ɔnlɩn?” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tsukʋlɛ osínpʋ amʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Owíé, nɩ́ bowúli ntsu ámʋtɔ á, mma ɔhá ánɩ́ obótsu mɩ́ wá mʋ́tɔ́. Nótsutsúa ambɔbwɛ á, ɔkʋ lagyankpá wíé mʋ́tɔ́ dodo.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Kʋsʋ! Tsu fʋ́ ɔklan, afʋnatɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɩnʋnʋʋnʋ oyin ámʋ ɩwɩ lɔ́wa mʋ ɔnlɩn, ɔlɔkʋsʋ́ tsú mʋ ɔklan, wá natɩ́ bɩ. Alɩ ɛkɛ ámʋ igyi Yudafɔ Ɔkpʋ́nʋ́ Ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mʋ́ sʋ Yudafɔ ahandɛ bɛka oyin ámʋ́ʋ́ Yesu latsá mʋ ɩlɔ ámʋ ansɩ́tɔ́, blɩ́ bɛɛ, “Ndɛ igyi Ɔkpʋ́nʋ́ Ɔdakɛ́. Anɩ mbla mɛha ɔkpa ánɩ́ fɔ́sʋrá fʋ́ ɔklan.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ ɔlɛtsa mɩ́ ɩlɔ ámʋ lɛ́bláa mɩ́ ɔbɛ́ɛ, ‘Tsu fʋ́ ɔklan, afʋnatɩ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mʋ́ sʋ bɛfɩtɛ́ mʋ bɛɛ, “Ma lɛ́bláa fʋ ɔbɛ́ɛ, fʋtsúu fʋ́ ɔklan afʋnatɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Oyin ámʋ mɛ́bɩ ɔhá ánɩ́ ɔlɛtsa mʋ ɩlɔ, tsúfɛ́ ahá bʋhɩ́ɛ́ bʋtsɔ ɩnʋ, Yesu lɔ́fwɩ wá amʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɔma a, Yesu lóyówun mʋ Bulu ɔtswɛ́kpa ɩnʋ. Mʋ́ʋ́ ɔlɛbláa mʋ ɔbɛ́ɛ, “Yɛ́ɛ fawun ánɩ́ ɩwɩ lawá fʋ́ ɔnlɩn. Mátrá bwɛ lakpan, mɛ́nɩ mʋ́á ɩdʋn ɩ́nɩ mɛ́ɛba fʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oyin ámʋ lɛ́yɛ́bláa Yudafɔ ahandɛ amʋ ɔbɛ́ɛ, Yesu lɛ́tsa mʋ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɩ́nɩá Yesu dɛ́ ntobí ánfɩ odu bwɛ ɔkpʋ́nʋ́ ɔdakɛ́ sʋ á, Yudafɔ ahandɛ amʋ bɔwa mʋ kpɛkpɛ́ɛ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́ mɔ́kʋ́sí agyʋ́má yɔ. Mʋ́ sʋ mɩ́ ɛ́ mmɔkʋ́sí.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mʋ asʋn blɩ́hɛ́ anfɩ sʋ á, Yudafɔ ahandɛ amʋ bekle ánɩ́ bɔ́mɔ mʋ ɔkpagyíɔkpasʋ. Tsúfɛ́ megyí ɔkpʋ́nʋ́ ɔdakɛ́ mbla ámʋ nkʋlɛ tʋ́ʋn sʋ, mboún ɔlɛblɩ́ ɔbɛ́ɛ, mʋ sɩ gyí Bulu, ilosuná ánɩ́ mʋa Bulunyɔ bʋgyi kɛ́kɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Mɩ́ Bulu mʋ Bi ánfɩ onutó mmɛ́ɛtalɩ́ bwɛ́ tɔtɔ mɩ́ ɩwɩsʋ. Tɔ́á nowun ánɩ́ mɩ́ Sɩ́ dɛ́bwɛ á, mʋ́ ntɔbwɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tsúfɛ́ mɩ́ Sɩ́ tɔdwɛ́ mɩ́, otosúná mɩ́ ɩtɔ́á mʋ onutó ɔdɛbwɛ fɛ́ɛ́. Inn! Ɩbɔ́wa mlɩ wánwan ánɩ́ obósuná mɩ́ mʋ́á ɩdʋn alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Alɩ ámʋ́ʋ́ mɩ́ Sɩ́ tɔkʋ́sʋá ahá tsú afúlitɔ, há amʋ́ nkpa ámʋ a, alɩ mɩ́ ɛ́ ntɛhá ahá ánɩ́ ndeklé nkpa nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mɩ́ Sɩ́ tamagyi asʋ́n há ɩpɔ́n, támɛ alapʋ́ asʋ́ngyí fɛ́ɛ́ wá mɩ́ ɩbɩtɔ, ");
INSERT INTO nkoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mɛ́nɩ ɔhagyíɔha obóbu mɩ́ fɛ́ alɩá otobú mɩ́ Sɩ́ ámʋ. Ɔhá ánɩ́ ɔtamabú mɩ́ tamabú mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔpʋ mɩ́ sɩ́sɩ́ ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ɔnɔkwalɩ ndɛ mlɩ bláa mbɛ́ɛ, ɔhagyíɔha ánɩ́ otonú mɩ́ asʋ́n, ɔtɔhɔ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ gyi, bʋ nkpa ánɩ́ ɩtamatá. Bulu méegyi mʋ asʋ́n, há mʋ pɔ́n, tsúfɛ́ aladálɩ lowutɔ ba nkpatɔ dodo. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɔnɔkwalɩ ndɛ mlɩ bláa. Brɛ́ kʋ ɩbá. Brɛ́ ámʋ ɩlawúna fʋn ánɩ́ ahá ánɩ́ bʋgyi fɛ́ aha wuhɛ́ bónu Bulu mʋ Bi ámʋ ɔmɛ. Amʋ́á bonu mʋ́ bénya nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tsúfɛ́ mɩ́ Sɩ́ bʋ́ʋ túmi, ɔtɛhá nkpa. Alɩ kɛ́n alahá mɩ́ ánfɩ ngyi mʋ Bi ánfɩ túmi, ɔbɛ́ɛ nháa ahá nkpa nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Alahá mɩ́ túmi ɔbɛ́ɛ, ngyíi ahá asʋ́n, tsúfɛ́ mɩ́gyí Nyankpʋsa-Mʋ-Bi ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Asʋ́n ánfɩ ɩmáwa mlɩ wánwan. Brɛ́ kʋ ɩbá, afúli fɛ́ɛ́ bónu mɩ́ ɔmɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kʋ́sʋ́. Amʋ́á bɔbwɛ yilé bɛ́lakʋ́sʋ́, nyá nkpa ánɩ́ ɩtamatá. Amʋ́á bɔbwɛ laláhɛ a, négyi amʋ́ asʋ́n, há amʋ́ ɩpɔ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mmɛ́ɛtalɩ́ bwɛ́ tɔtɔɔtɔ mɩ́ ɩwɩsʋ. Asʋ́n ánɩ́ nonú tsú mɩ́ Sɩ́ wá á, mʋ́ ntɔpʋ́gyí asʋ́n. Mʋ́ sʋ́ ntegyi asʋ́n ɔnɔkwalɩsʋ nɩ́. Tsúfɛ́ ntamabwɛ́ tɔ́á mɩ́ onutó ndeklé, mboún tɔ́á ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ tekle.” ");
INSERT INTO nkoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu lɔ́yɔ mʋ́sʋ́ blɩ́ ɔbɛ́ɛ, “Nɩ́ mɩ́ onutó negyi mɩ́ ɩwɩ adánsɩɛ á, mlɩmɔ́ɔhɔ mʋ́ ánɩ́ ɔnɔkwalɩ igyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bulu ɛ́ tegyi mɩ́ ɩwɩ adánsɩɛ. Nyin ánɩ́ mɩ́ ɩwɩ adánsɩɛ ámʋ́ʋ́ odegyí amʋ igyi ɔnɔkwalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mlɩlawá abí sɩ́sɩ́ Yohane. Alabláa mlɩ ɔnɔkwalɩ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɩ́ mʋ́ á, mmehián anyánkpʋ́sa adánsɩɛ. Mboún ndɛ mlɩ asʋ́n ánfɩ bláa, mɛ́nɩ Bulu ɔbɔ́hɔ mlɩ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane asʋn blɩ́hɛ́ lɔbwɛ fɛ́ ɔkandɩ́ɛ ánɩ́ ɩdɛwankɩ́. Mʋ́ sʋ mlɩlótsulá gyi mʋ́ ɔdwɛ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mbʋ tɔ́á itegyi mɩ́ ɩwɩ adánsɩɛ, ɩdʋn Yohane klɛ́ amʋ. Agyʋ́má ámʋ́ʋ́ mɩ́ Sɩ́ lawá ɔbɛ́ɛ mbwɛ́ɛ mɔ mʋ́ ɔnɔ́, ndɛ mʋ́ bwɛ ámʋ dɛ́ adánsɩɛ gyí ánɩ́ mʋlɔ́wa mɩ́ sɩ́sɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ onutó lagyi mɩ́ ɩwɩ adánsɩɛ. Mlɩmɔ́kʋ́nu mʋ ɔmɛ, mlɩmɔ́kʋ́wun mʋ ɛ́ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mlɩmɔ́hɔ mʋ asʋ́n wá mlɩ klʋntɔ, tsúfɛ́ mlɩmɔ́hɔ mɩ́ ámʋ́ʋ́ ɔlɔwa sɩ́sɩ́ ámʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mlɩkɩ́á mlénya nkpa ánɩ́ ɩtamatá tsú Bulu asʋn wanlɩ́nhɛ́ amʋtɔ. Mʋ́ sʋ́ mlɩ ansɩ́ lapɛ́, mlɩdɛ́ mʋ́ kasɩ́ nɩ́. Mɩ́ ɩwɩ adánsɩɛ Bulu asʋn wanlɩ́nhɛ́ amʋ idegyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Támɛ mlɩlakíná mɩ́ wá bá, mɛ́nɩ mlénya nkpa ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mmedédunká mbɛ́ɛ, ahá bʋkánfʋ mɩ́, ");
INSERT INTO nkoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","tsúfɛ́ nyin mlɩ dodo. Nyin ánɩ́ mlɩtamadwɛ́ Bulu tsú mlɩ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naba mɩ́ Sɩ́ dátɔ́, mlɩmɔ́hɔ mɩ. Támɛ nɩ́ ɔha bambá ɔbá mʋ onutó ɩwɩsʋ á, mlɔ́hɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mlɩtekleá mlɛ́kanfʋ́ aba, támɛ mlɩtamabɔ́ mbɔ́dɩ́ ánɩ́ Bulu ɔkʋlɛ pɛ́ ámʋ ɔkánfʋ mlɩ. Nkálɩ ɩbɔ́bwɛ mlɔ́hɔ mɩ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mlɩmákɩ mlɩaa, nɛ́lɛ mlɩ ɩlá mɩ́ Sɩ́ ansɩ́tɔ́. Mose amʋ́ʋ́ mlɩ ansɩ́ ɩdɩn mʋsʋ mlɩaa ɔbɔ́hɔ mlɩ nkpa ámʋ mboún ɔbɛ́lɛ mlɩ ɩlá Bulu ansɩ́tɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nɩ́ lɛ́lɛ́ mlɩlɔ́hɔ Mose asʋ́nsʋ́ gyi a, tɛkɩ mlɔ́hɔ mɩ́ asʋ́nsʋ́ gyi, tsúfɛ́ mɩ́ ɩwɩ asʋ́n ɔlɔwanlɩ́n tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Támɛ ɩ́nɩá mlɩmɔ́hɔ tɔ́á ɔlɔwanlɩ́n tswɩ́sʋ gyi a, nkálɩ ɩbɔ́bwɛ mlɔ́hɔ mɩ́ asʋn blɩ́hɛ́sʋ gyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɩ́nɩ ɔma a, Yesu mʋa mʋ akasɩ́pʋ́ bɛfa Galilea ɔpʋá bʋtɛtɩ́ mʋ́ Tiberia amʋ yɔ́ mʋ́ ɔbɩn. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɔdɔm betsiá buo mʋ, tsúfɛ́ ɔdɛ alɔpʋ tsa wánwansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mʋa mʋ akasɩ́pʋ́ bɔdʋ yɔ́ okúku kʋsʋ, yétsiá asɩ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Alɩ brɛ́ ámʋtɔ á, Yudafɔ nkɛá bɔ́pʋgyi Israelfɔsʋ Katsʋn Nkɛ ámʋ ɩlafʋn ta.) ");
INSERT INTO nkoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ɩnʋ Yesu lótsu ansɩ́ fʋ́á wun ánɩ́ ɔdɔm kpɔnkpɔɔnkpɔntɩ bɛbá mʋ wá. Mʋ́ʋ́ ɔlɛfɩtɛ́ Filipo ɔbɛ́ɛ, “Nkʋ́nʋ́ abénya atogyihɛ hɔ ha ahá ánfɩ bégyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu lɛ́blɩ́ asʋ́n ánfɩ pʋ́sɔ Filipo kɩ, tsúfɛ́ oyin tɔ́á ɔbɔ́bwɛ dodo.) ");
INSERT INTO nkoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ apʋ́ tsra kwe ɩkɔká hɔ atogyihɛ kʋ́ráá á, ɩmɔ́ɔfʋn ánɩ́ okugyíɔkʋ obénya kpalobí gyí!” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Simon Petro mʋ pio Andrea, ogyi akasɩ́pʋ́ amʋtɔ ɔkʋlɛ lɛ́bláa Yesu ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Oyimbi ɔkʋ dɛ́ bodobodo apín pútúpútú anu pʋ́ ntsutso iye bwáhɛ́ anyɔ. Támɛ ntɔ ɩ́nɩ bɔ́bwɛ ahá tsɔtsɔɔtsɔ ánfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu lɛ́bláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩha amʋ́ abʋtsiatsia asɩ.” Ahá ámʋ fɛ́ɛ́ betsiá ɩfásʋ́. Ayin ánɩ́ bʋbʋ amʋ́tɔ́ bɔ́bwɛ fɛ́ mpɩ́m-nu (5,000). ");
INSERT INTO nkoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mʋ́ʋ́ Yesu lɔ́hɔ bodobodo amʋ, dá Bulu ɩpán, ɔlɛha beye mʋ́ há ahá ámʋ́ʋ́ bʋtsie ɩnʋ ámʋ. Alɩ kɛ́n ɔlɔbwɛ ntsabi bʋáhɛ́ amʋ ɛ́ nɩ́. Amʋ́tɔ́ okugyíɔkʋ lénya alɩá odeklé. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Begyi mwɛ sian. Yesu lɛ́bláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Mlɩkʋla síanhɛ amʋ, mɛ́nɩ ɩmɔ́ɔbwɛ atɔ yintáhɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lɛ́lɛ́, bɔtɔsɩ́ síanhɛ amʋ́ʋ́ benya tsú bodobodo anu ámʋtɔ ámʋ. Ɩlɔbʋlá alakpá dúanyɔ kɛ́kɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ahá ámʋ bowun osúna anfɩ Yesu labwɛ́ ánfɩ. Mʋ́ sʋ bɛblɩ́ bɛɛ, “Lɛ́lɛ́, oyin ánfɩ gyí Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ amʋ́ʋ́ bɔwanlɩ́n mʋ ɩwɩ asʋ́n wá Bulu asʋ́ntɔ́ bɛɛ, ɔbɛ́ba ɔyɩ́tɔ́ ámʋ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu lówun ánɩ́ ahá ámʋ babwɛ́ agywɩɩn bɛɛ, bɛ́ba bɛkɩtá mʋ ɔwʋnlɩ́ntɔ́ yáɩ́ mʋ iwíe. Mʋ́ sʋ mʋ nkʋlɛ ɔlɛladʋ́ yɔ́ nkpá sí amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Brɛ́á owí lɔpɔn a, Yesu akasɩ́pʋ́ bɛkplɩ́ ba Galilea ɔpʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Owí latá, támɛ Yesu mɔ́kʋ́yínkí bɔtʋ amʋ́. Mʋ́ sʋ bɔdʋ wíé ɔklʋntɔ, bʋdɛfa bɔyɔ́ Kapernaum. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Afú kpɔnkpɔntɩ kʋ lɛ́ba ɩdɛtsʋ́ʋn, ɔpʋ amʋ lɔ́wa dabɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Alɩ brɛ́ ámʋtɔ á, akasɩ́pʋ́ amʋ baplá ɔklʋn amʋ yɔ́ fɛ́ máɩlɩ asa ntɛ́ɛ ana. Ɩnʋ bowun ánɩ́ Yesu ná ɔpʋ amʋsʋ ɔbá amʋ́ wá. Mʋ́ sʋ ifú lɛkɩtá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Támɛ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ nɩ́, mlɩmánya ifú!” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɩnʋ botsu mʋ wá ɔklʋn amʋtɔ ansigyísʋ́. Ilotsutsúa ɩwankɩ amʋ́ á, ɔklʋn amʋ lawíé otsubúnɔ, ɔtɩ́nɛ́ amʋ́ʋ́ bɔyɔ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɔyɩ́ kɛhɛ a, ɔdɔm amʋ́ʋ́ besi bʋbʋ ɔpʋ amʋ ɔbɩn ɩnʋ ámʋ bowun ánɩ́ ɔklʋn kʋkʋ ɩtráa mɛlɩ́ɩ́ ɩnʋ. Mʋ́á tɛkɩ ɩlɩɩ́ ɩnʋtɔ akasɩ́pʋ́ amʋ bowie nátɩ́ nɩ́. Bowun ánɩ́ Yesu mówie mʋ́tɔ́ asa bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mʋ́ ɔma a, nklʋn akʋ lótsu Tiberia wúlutɔ bɛlɩɩ́ mantáa ɔtɩ́nɛ́ ámʋ́ʋ́ begyi bodobodo amʋ́ʋ́ Yesu lɛ́da Bulu ɩpán pʋ́há amʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɔdɔm amʋ bowun ánɩ́ Yesu lanátɩ́ ɩnʋ, mʋ akasɩ́pʋ́ amʋ ɛ́ bʋma ɩnʋ. Mʋ́ sʋ bɔdʋ wíé nklʋn amʋtɔ yɔ́ Kapernaum, bʋdɛ Yesu dunká. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Brɛ́á ɔdɔm amʋ boyówun Yesu ntsu ɔbɩn ɩnʋ á, bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, brɛ́ mɔmʋ fobowie nfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Megyí osúna amʋ́ʋ́ ndɛbwɛ mlɩdéwúun amʋ sʋ mlɩgyá mɩ́ ɔkpa. Mboún bodobodo amʋ́ʋ́ nɛha mlɩ, mlɩlégyí mwɛ ámʋ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mlɩmáwun ipian atogyihɛ ánɩ́ iteyíntá sʋ. Mboún mlɩwun ipian mʋ́á ibétsiá yɔ́, ɩbɛ́ha nkpa ánɩ́ ɩtamatá, ánɩ́ mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ nɛ́ha mlɩ sʋ. Tsúfɛ́ mɩ́ mɩ́ Sɩ́ Bulu lahɩɛ nsʋ ánɩ́ mbʋ ɔkpa há mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bɛfɩtɛ́ Yesu bɛɛ, “Gyʋma mɔmʋ abwɛ́ɛ isuna ánɩ́ anɩdɛ́ tɔ́á Bulu tekle bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Tɔ́á Bulu déklé ɔbɛ́ɛ mlɩbwɛ́ɛ gyí, mlɩhɔ mɩ́ ánfɩ ɔlɔwa sɩ́sɩ́ ánfɩ gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɩnʋ bɛfɩtɛ́ Yesu bɛɛ, “Osúna mɔmʋ fɔ́bwɛ abówun, mɛ́nɩ abɔ́hɔ fʋ gyi? Ntɔ fɔ́bwɛ? ");
INSERT INTO nkoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Anɩ anáin begyi mana dimbí ámʋsʋ. Bɔwanlɩ́n mʋ́ wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Mose lɛ́ha amʋ́ atɔ́á ilotsu ɔsʋ́sʋ́ bá begyi.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Megyí Mose lɛ́ha mlɩ atogyihɛ amʋ tsú ɔsʋ́sʋ́. Mɩ́ Sɩ́ lɛ́ha mlɩ bodobodo onutónutó ámʋ tsú ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tsúfɛ́ bodobodo ánɩ́ Bulu tɛhá gyí mɩ́ ánfɩ natsú ɔsʋ́sʋ́ bá, nɛbá bɛha ɔyɩ́tɔ́ ahá nkpa ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ahá ámʋ bɛbláa mʋ bɛɛ, “Owíé, tsia ha anɩ bodobodo anfɩ brégyíbrɛ́, tsú séi pʋ́ya.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́gyí bodobodo amʋ́ʋ́ ɩtɛhá nkpa ámʋ nɩ. Akʋ́n mɛ́ɛkɩtá ɔhá ánɩ́ ɔlɛba mɩ́ wá ɛkɛkɛɛkɛ. Ɔmɛwʋ́lɩ mɛ́ɛkɩtá ɔhá ánɩ́ ɔlɔhɔ mɩ gyi ɛ́ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Fɛ́ alɩá nɛbláa mlɩ á, mlɩlawun mɩ, támɛ mlɩmɔ́kʋ́hɔ mɩ gyi bɔfʋn séi. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɔhagyíɔha ánɩ́ Ɔsɩ́ ámʋ lɛ́ha mɩ́ ɔbɛ́ba mɩ́ wá. Mméegya ɔhagyíɔha ánɩ́ ɔlɛba mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tsúfɛ́ mmotsu ɔsʋ́sʋ́ ba mbɛ́ɛ, nɛbá bɔbwɛ tɔ́á ndeklé. Mboún tɔ́á ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ déklé ɔbwɛkpá nɛba. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tɔ́á ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ déklé gyí, ahá ámʋ́ʋ́ ɔlɔpʋhá mɩ́ ámʋtɔ ɔkʋkʋ mádalɩ mɩ́ ɩbɩ. Mboún nkʋ́sʋa amʋ́ fɛ́ɛ́ tsu afúlitɔ ɛkɛ tráhɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tɔ́á mɩ́ Sɩ́ ámʋ tekle gyí, ɔhagyíɔha ánɩ́ olowun mɩ́, mʋ Bi ánfɩ, hɔ mɩ gyi obénya nkpa ánɩ́ ɩtamatá. Nɔ́kʋsʋ́a mʋ tsú afúlitɔ ɛkɛ tráhɛ amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Ɩ́nɩá Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mɩ́gyí bodobodo amʋ́ʋ́ notsu ɔsʋ́sʋ́ ba amʋ nɩ” sʋ á, Yudafɔ ámʋ bɔwa mʋ wuntí bɩ. Bɛɛ, “Megyí Yosef mʋ bi Yesu amʋ nɩ? Anɩméyín mʋ sɩ mʋa mʋ yin? Ɔkpa mɔmʋ sʋ́ ɔdɛblɩ́ ɔbɛ́ɛ, ‘Ɔsʋ́sʋ́ notsu nɛba?’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩsi wuntí mlɩ wʋlɛwʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɔhaa mɛ́ɛtalɩ́ ba mɩ́ wá, nkɛ́tɩ mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ lakpá mʋ ba mɩ. Mɩ́ ɛ́ nɔ́kʋsʋ́a mʋ tsú afúlitɔ ɛkɛ tráhɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋtɔ ɔkʋ lɔ́wanlɩ́n tswɩ ɔbɛ́ɛ, ‘Bulu obósuná ahá fɛ́ɛ́ atɔ́.’ Ɔhagyíɔha ánɩ́ alanú mɩ́ Sɩ́ asʋ́n, kásɩ́ mʋ́ tsú mʋ wá tɛba mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɔhaa mɔ́kʋ́wun Ɔsɩ́ ámʋ kɩ. Mɩ́ ánfɩ notsu Bulu wá bá anfɩ nkʋlɛ láwun mʋ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ gyi bʋ nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɩ́gyí bodobodoá ɩtɛhá nkpa nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ɩ́nɩá mlɩ anáin begyi mana dimbísʋ́ óó á, amʋ́ fɛ́ɛ́ bowu. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Támɛ bodobodo anfɩ gyí mʋ́a ɩlatsú ɔsʋ́sʋ́ bá, mɛ́nɩ ɔhagyíɔha ánɩ́ obégyi mʋ́ móowu nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɩ́gyí bodobodo amʋ́ʋ́ ntɛhá nkpa, natsú ɔsʋ́sʋ́ ba amʋ nɩ. Ɔhagyíɔha ánɩ́ ogyi bodobodo anfɩ obétsiá nkpa, omóowu ɛkɛkɛɛkɛ. Mɩ́ ɔyʋlʋ́ʋ gyí bodobodo amʋ. Mʋ́ nési há, mɛ́nɩ ɔyɩ́tɔ́fɔ bénya nkpa nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ɩnʋ Yudafɔ ámʋ benya asʋ́n anfɩ́ Yesu lablɩ́ ánfɩ ɩwɩ ɔblɔ́. Amʋ́ wʋlɛwʋlɛ begyi aba nwɛ́ɛn bɛɛ, “Nkálɩ oyin ánfɩ ɔbɛ́talɩ́ pʋ́ mʋ ɔyʋlʋ́ʋ há anɩ ɔbɛ́ɛ agyíi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Nɩ́ mlɩmégyi mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ ɔyʋlʋ́ʋ, nu mɩ́ obugya a, mlɩmá nkpa ánɩ́ ɩtamatá kʋkʋʋkʋ mlɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɔhá ánɩ́ olegyi mɩ́ ɔyʋlʋ́ʋ, nu mɩ́ obugya bʋ nkpa ánɩ́ ɩtamatá. Nɔ́kʋsʋ́a mʋ tsú afúlitɔ ɛkɛ tráhɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tsúfɛ́ mɩ́ ɔyʋlʋ́ʋ igyi atogyihɛ onutó, mɩ́ obugya ɛ́ igyi atonuhɛ onutó. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɔhá ánɩ́ ogyi mɩ́ ɔyʋlʋ́ʋ, nu mɩ́ obugya tsie mɩtɔ, mɩ́ ɛ́ ntsie mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mɩ́ Sɩ́ Ɔkɩankpapʋ amʋ lɔ́wa mɩ́ sɩ́sɩ́. Mʋ sʋ́ mbʋ nkpa. Mʋ́ sʋ fʋ́á fegyi mɩ a, mɩ́ sʋ fʋ́ ɛ́ fʋbʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mɩ́gyí bodobodo onutóá notsu ɔsʋ́sʋ́ ba nɩ. Mlɩ anáin begyi mána, támɛ bowu. Ɔhá ánɩ́ ogyi bodobodo anfɩ mʋ́ obétsiá nkpa ánɩ́ ɩtamatá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu lɛ́blɩ́ asʋ́n ánfɩ brɛ́á ɔdɛ atɔ́ suná Kapernaum, Yudafɔ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu abúopʋ tsɔtsɔɔtsɔ ámʋtɔ akʋ bonu asʋ́n ánfɩ á, bɛblɩ́ bɛɛ, “Atosunáhɛ́ ánfɩ mʋ́ bʋ ɔnlɩn o! Ma ɔbɛ́talɩ́ hɔ mʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu lówun ánɩ́ mʋ abúopʋ amʋtɔ akʋ bʋdɛ wunti ánɩ́ alablɩ́ alɩ sʋ á, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Asʋ́n ánfɩ ɩlahan mlɩ? ");
INSERT INTO nkoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mʋ́mʋ́ nɩ́ mlowun Nyankpʋsa-Mʋ-Bi ámʋ ɔyɔ́ ɔtɩ́nɛ́á olotsu ba mɛ, nkálɩ mlɔ́bwɛ? ");
INSERT INTO nkoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bulu Ɔŋɛ́ ámʋ tɛ́há nkpa. Nyankpʋsa ɔwʋnlɩ́n mʋ́ á, kpaalɩ ígyi. Asʋ́n ánfɩ ndɛ mlɩ bláa anfɩ itsú Ɔŋɛ́ ámʋ́ʋ́ ɔtɛhá nkpa ámʋ wá, ");
INSERT INTO nkoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","támɛ mlɩtɔ akʋ bʋmɔhɔ mʋ́sʋ́ gyi.” Yesu lówun amʋ́á bʋmɔhɔ mʋ́sʋ́ gyi pʋ́ ɔhá ánɩ́ ɔbɛ́lɛ mʋ há yáɩ́ dodoodo. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɔlɛtrá bláa amʋ́ ɔbɛ́ɛ, “Ɩ́nɩ sʋ́ nɛbláa mlɩ mbɛ́ɛ, ɔhaa mɛ́ɛtalɩ́ ba mɩ́ wá, nkɛ́tɩ mɩ́ Sɩ́ lakpá mʋ ba mɩ” nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tsú ɛkɛ ámʋ a, Yesu abúopʋ amʋ tsɔtsɔɔtsɔ beyinkí mʋ ɔma, bʋmɛtrá buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mʋ́ sʋ Yesu lɛ́fɩtɛ́ mʋ akasɩ́pʋ́ dúanyɔ ámʋ ɔbɛ́ɛ, “Mlɩ ɛ́ mlɩdékléá mléyinkí mɩ́ ɔma lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, ma wá abɔ́yɔ? Fʋ́ wá asʋ́n ánɩ́ ɩtɛhá nkpá ánɩ́ ɩtamatá bʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Anɩlahogyi, anɩlabɩ́ ánɩ́ fʋ́gyí Ɔha Wankɩ́hɛ́ amʋ́ʋ́ fotsú Bulu wá ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ ahá dúanyɔ nɛlɛ, támɛ mlɩtɔ ɔkʋ gyí ɔbʋnsám!” ");
INSERT INTO nkoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Simon Iskariot mʋ bi Yuda ɔdɛ á. Tsúfɛ́ ogyi akasɩ́pʋ́ dúanyɔ ámʋtɔ ɔkʋlɛ. Mʋ ɔbɛ́lɛ mʋ há nɩ́.) ");
INSERT INTO nkoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mʋ́ ɔma a, Yesu létsiá kí Galilea ɔmátɔ́. Omekleá ɔbɔ́yɔ Yudea ɔmátɔ́, tsúfɛ́ Yudafɔ ahandɛ amʋ bʋdɛ mʋ tɛ́ɛ abʋmɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Támɛ Yudafɔ Kantankpatɔtsiá Nkegyí lafʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mʋ́ sʋ mʋ apio yinhɛ́ bɛbláa mʋ bɛɛ, “Natɩ yɔ Yudea nkɛ ámʋ ogyíkpá, mɛ́nɩ fʋ́ abúopʋ amʋ́ʋ́ bʋbʋ ɩnʋ ámʋ ɛ́ bówun ofúla ánɩ́ fʋdɛbwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɔhá ánɩ́ odekléá ahá bʋbɩ́ɩ mʋ gyumagyihɛ tamaŋáín ɩwɩ. Ɩ́nɩá fʋ́dɛ ntobíá igyi alɩ bwɛ á, wuna lɛ mʋ́ suna, ɔyɩ́ fɛ́ɛ́ abʋwun.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Mʋ apíó ámʋ kʋ́ráá bʋmɔhɔ mʋ gyi. Mʋ́ sʋ bɛbláa mʋ alɩ nɩ́.) ");
INSERT INTO nkoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ɩ́nɩ sʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Brɛ́á nɔ́yɔ ɩnʋ mɔkʋ́nyá fʋn. Mlɩ mʋ́ mlɛ́talɩ́ yɔ́ ɩnʋ brégyíbrɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɔyɩ́tɔ́fɔ bʋmɛ́ɛtalɩ́ lú mlɩ, támɛ mɩ́ mʋ́ bʋdɛ mɩ́ lu, tsúfɛ́ ndɛ amʋ́ ɩlá lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mlɩyɔ nkɛ ámʋtɔ. Mɩ́ mʋ́ mmɔkʋ́nyá yɔ́, tsúfɛ́ mɩ́ brɛ́ mɔkʋ́fʋn.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu lɛ́blɩ́ asʋ́n ánfɩ tá á, olesi tsiá Galilea ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Támɛ brɛ́á Yesu apíó ámʋ bɛnatɩ́ yɔ́ nkɛ ámʋ ogyíkpá a, mʋ ɛ́ oleŋaín ɩwɩ yɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yudafɔ ahandɛ amʋ bodunká mʋ nkɛ ámʋ ogyíkpá, bʋdɛ ahá fɩtɛ́ bɛɛ, “Oyin ámʋ mɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɔdɔm amʋ bɛblɩ́ asʋ́n tsɔtsɔɔtsɔ nklobítɔ tsú Yesu ɩwɩ. Akʋ bɛɛ, “Ɔha wankláán ogyi.” Akʋ ɛ́ bɛɛ, “Ɛkɛkɛɛkɛ, ɔdɛ ahá mlɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Támɛ amʋ́tɔ́ ɔhaa mɛ́talɩ́ blɩ́ mʋ ɩwɩ asʋ́n kʋ́klʋ́ ahá abʋnu, tsúfɛ́ bʋdɛ Yudafɔ ahandɛ amʋ ifú nya. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Brɛ́á bowie nkɛ ámʋ nsɩnɛ́ á, Yesu lɔ́dʋ wíé Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ yéfi atɔ́ suná asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mʋ atosunáhɛ́ lobwie Yudafɔ ahandɛ amʋ ɔnɔ́. Mʋ́ sʋ bɛfɩtɛ́ aba bɛɛ, “Oyin ánfɩ mɔ́kʋ́kásɩ́ ɔwʋlʋ́ yɔ́ nkpá. Nkálɩ ɩlɔbwɛ asa ɔlɛbɩ ɔwʋlʋ́ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí mɩ́ wá atosunáhɛ́ anfɩ itsú. Itsú Bulu wá. Mʋlɔ́wa mɩ́ sɩ́sɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nɩ́ ɔkʋ dékléá ɔbɔ́bwɛ Bulu apɛ́ á, obówun nɩ́ atosunáhɛ́ anfɩ itsú mɩ́ wá ntɛ́ɛ Bulu wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɔhá ánɩ́ ɔdɛ mʋ onutó asʋ́n blɩ́ dɛ́ mʋ numnyam dunká. Támɛ nɩ́ ɔkʋ todúnká numnyam há ɔhá ánɩ́ ɔlɔwa mʋ sɩ́sɩ́ á, ɔnɔkwalɩpʋ ɔhá ámʋ gyí. Ɔtamawá afunu. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yɛ́ɛ Mose lɔ́pʋ mbla ámʋ ba mlɩ a? Támɛ mlɩtɔ ɔkʋkʋ mɛ́dɛ́ mʋ́sʋ́ gyi. Ntogyi sʋ mlɩdékléá mlɔ́mɔ mɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɩnʋ ɔdɔm amʋ bɛbláa mʋ bɛɛ, “Ɔŋɛ laláhɛ bʋ fʋtɔ! Ma dékléá ɔbɔ́mɔ fʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ofúla kʋlɛ pɛ́ nɔbwɛ ɔkpʋ́nʋ́ ɔdakɛ́, mlɩ fɛ́ɛ́ ɔnɔ́ lobwie mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose lɔ́wa mbla há mlɩ ɔbɛ́ɛ, mlɩtɩ́ɩn keté. (Ɩbʋ mʋ́tɔ́ ánɩ́ megyí Mose lɔ́tsɔ keté tɩ́n, mlɩ anáin léfi mʋ́ asɩ.) Yɛ́ɛ mʋ́ sʋ́ mlɩtɛtɩn ahá keté ɔkpʋ́nʋ́ ɔdakɛ́ nɩ́ a? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nɩ́ mlɩdɛ́ keté tɩ́ɩn ɔkpʋ́nʋ́ ɔdakɛ́, mɛ́nɩ mlɩmɔ́ɔkʋsʋ́ lɩ́ɩ́ Mose mbla ámʋsʋ á, ntogyi sʋ́ mlɩlanyá ɔblɔ́ mɩ́sʋ́ mlɩaa, natsá nyankpʋsa kɛ́ɩ́n ɔkpʋ́nʋ́ ɔdakɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mlɩyɔ asʋ́ntɔ́ wankláán, asa amlɩha ɩpɔ́n. Mlɩpʋ ɔnɔkwalɩ gyi asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalemfɔ akʋ bɛfɩtɛ́ amʋ́ ɩwɩ bɛɛ, “Megyí oyin ánfɩ Yudafɔ ahandɛ bʋdedunká abʋmɔ nɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Megyí mʋ lɩ́ɩ́ ahátɔ ɔdɛtɔɩ́, amʋ́tɔ́ ɔkʋkʋ mɛ́kpla mʋ a? Ntɛ́ɛ ɩlawánkɩ́ amʋ́ ánɩ́ mʋgyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oyin ánfɩ mʋ́ a, anɩ fɛ́ɛ́ anɩyin ɔtɩ́nɛ́á otsú, támɛ nɩ́ Kristo ámʋ ɔbá á, ɔhaa mɛ́ɛbɩ ɔtɩ́nɛ́á otsú.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Brɛ́á Yesu bʋ mʋ́sʋ́ ɔdɛ atɔ́ ámʋ suná Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ á, olotsu ɔnɔ́ fʋ́á blɩ́ ɔbɛ́ɛ, “Mlɩyin mɩ, mlɩyin ɔtɩ́nɛ́á notsú, támɛ megyí mɩ́ onutó túmisʋ nɛba. Ɔnɔkwalɩpʋ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ gyí. Mlɩméyín mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Támɛ mɩ́ mʋ́ nyin mʋ, tsúfɛ́ mʋlɔ́wa mɩ́ sɩ́sɩ́. Mʋ wá notsu ba.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɩnʋ bekle abʋkɩta mʋ, támɛ bʋmɔpʋ ɩbɩ da mʋ, tsúfɛ́ mʋ brɛ́ mɔkʋ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Támɛ amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bɔhɔ mʋ gyi. Mʋ́ sʋ bɛfɩtɛ́ bɛɛ “Nɩ́ Kristo amʋ ɔbá á, ɔbɛ́talɩ́ bwɛ́ osúna dʋn mʋ́ ánfɩ oyin ánfɩ dɛ́bwɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Brɛ́á Farisifɔ ámʋ bonu ánɩ́ ɔdɔm amʋ bʋdɛ Yesu ɩwɩ asʋ́n blɩ́ nklobítɔ á, amʋ́a Bulu igyí ahapʋ́ dɛhɛn amʋ bɔwa Bulu ɔtswɛ́kpa agyópʋ bɛɛ bʋkɩ́ta Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ɩ́nɩ sʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɩlasí nkɛ kpalobí pɛ́ nétsiá mlɩ wá. Mʋ́ ɔma a, néyinkí yɔ́ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mlódunká mɩ́, támɛ mlɩmóowun mɩ. Mlɩmɛ́ɛtalɩ́ ba ɔtɩ́nɛ́á mbʋ ɛ́ ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yudafɔ ahandɛ amʋ bɛfɩtɛ́ aba bɛɛ, “Nkʋ́nʋ́ oyin ánfɩ obótu ɔkpa yɔ́, sʋ abódunká mʋ anɩmóowun mʋ? Ntɛ́ɛ odekléá ɔbɔ́yɔ Griikifɔ awúlu amʋ́ʋ́ anɩ pɩ badásáɩ́n yɔ́ mʋ́sʋ́ ámʋsʋ, ntɛ́ɛ obóyósuná Griikifɔ ámʋ atɔ́? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Asʋ́n ánfɩ ɔdɛblɩ́ ɛ́ asɩ mɛ́? Ɔbɛ́ɛ, ‘Mlódunká mɩ́, támɛ mlɩmóowun mɩ. Mlɩmɛ́ɛtalɩ́ ba ɔtɩ́nɛ́á mbʋ ɛ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nkɛ ámʋ ɛkɛ tráhɛá ígyi ɛkɛ títriu á, Yesu lɔ́kʋsʋ́ lɩ́ɩ́ kplʋn blɩ́ ɔbɛ́ɛ, “Nɩ́ ɔmɛwʋ́lɩ dɛ ɔkʋ á, ɔbá mɩ́ wá obonu ntsu. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ gyi a, ‘Nkpa ntsu bɔ́wɩ dalɩ mʋtɔ.’ Alɩ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Ɔŋɛ Wankɩ́hɛ́ amʋ́ʋ́ Bulu ɔbɛ́ha ahá ánɩ́ bɔ́hɔ mʋ gyi amʋ ɩwɩ asʋ́n ɔdɛblɩ́. Alɩ brɛ́ ámʋtɔ á, Ɔŋɛ Wankɩ́hɛ́ amʋ mɔ́kʋ́nyá ba, tsúfɛ́ Bulu mɔ́kʋ́nyá wá Yesu numnyam.) ");
INSERT INTO nkoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Brɛ́á ɔdɔm amʋ bonu Yesu asʋn blɩ́hɛ́ anfɩ á, amʋ́tɔ́ akʋ bɛblɩ́ bɛɛ, “Lɛ́lɛ́, Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ amʋ́ʋ́ anɩdɛ́ mʋ ɔkpa kɩ́ɩ amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Akʋ ɛ́ bɛɛ, “Kristo amʋ nɩ!” Támɛ amʋ́tɔ́ akʋ ɛ́ bɛblɩ́ bɛɛ, “Yɛ́ɛ megyí Galilea ɔmátɔ́ Kristo amʋ obótsu o. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, Owíe Dawid abusuantɔ Kristo amʋ ɔbɛ́dalɩ tsu. Bɔ́kwɩɩ́ mʋ Betlehem, Dawid wúlutɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɩna Yesu ɩwɩ asʋ́n ánfɩ sʋ ɩkʋlɛbwɛ metsiá amʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amʋ́tɔ́ akʋ bekle abʋkɩta Yesu, támɛ ɔhaa mɔ́pʋ ɩbɩ da mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɔma-ɔma a, Bulu ɔtswɛ́kpa agyópʋ amʋ́ʋ́ bɔwa sumbí ámʋ bɛsankí ba Bulu igyí ahapʋ́ dɛhɛn pʋ́ Farisifɔ ámʋ wá. Bɛfɩtɛ́ agyópʋ amʋ bɛɛ, “Ntogyi sʋ mlɩmɛ́kɩtá mʋ ba?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ɔhaa mɔ́kʋ́tɔ́ɩ́ fɛ́ oyin ánfɩ kɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisifɔ ámʋ bɛfɩtɛ́ amʋ́ bɛɛ, “Mʋ́ sʋ oyin ámʋ lamlɛ́ mlɩ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mlɩlawun ɔhandɛ ntɛ́ɛ Farisiyin ɔkʋ lahɔ mʋ gyi kɩ? ");
INSERT INTO nkoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɛkɛkɛɛkɛ! Ɔdɔm anfɩ bʋmeyín Mose mbla ámʋ ɩwɩ tɔtɔ. Mʋ́ sʋ Bulu ɔlwɩ́ɩ amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ɩnʋ Farisifɔ ámʋtɔ ɔkʋlɛ, ogyi Nikodemo amʋ́ʋ́ ɔlɔyɔ Yesu wá onyé ámʋ lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Anɩ mbla lɛha ɔkpa ánɩ́ abɛ́ha ɔkʋ ɩpɔ́n asa abɛ́fɩtɛ́ mʋ ɔnɔ́tɔ́ asʋ́n nú?” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bɛfɩtɛ́ mʋ bɛɛ, “Galileayin fʋ́ ɛ́ fʋ́gyi? Kɩ Bulu asʋ́n ámʋtɔ wankláán. Fówun ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋkʋʋkʋ móotsu Galilea ɔmátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ɩnʋ amʋ́ fɛ́ɛ́ bɛnatɩ́ yɔ́ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Brɛ́á ahá amʋ bɛdasáɩ́n á, Yesu lɔ́dʋ yɔ́ Nfɔ-nyíbʋ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mʋ́ ɔyɩ kɛhɛ bakɛ a, oleyinkí ba Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ. Ahá ámʋ fɛ́ɛ́ bɛba mʋ wá. Mʋ́ sʋ oletsiá asɩ, olefi asɩ ɔdɛ amʋ́ atɔ́ suná. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Brɛ́á ɔdɛtɔɩ́ á, Farisifɔ pʋ́ Mose mbla asunápʋ́ amʋ bɛkpa ɔtsɩ ɔkʋá bakɩ́tá mʋ, ɔdɛ mbʋatɔ ba bɛlɩɩ́ amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mʋ́ʋ́ bɛbláa Yesu bɛɛ, “Osunápʋ́, bakɩ́tá ɔtsɩ ánfɩ mbʋa ɔtɔkpá. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mose Mbla ámʋ lɛ́blɩ́ ɔbɛ́ɛ, adáa atsɩ ánfɩ odu abwi mɔ. Nkálɩ fʋdɛblɩ́ tsú asʋ́n ánfɩ ɩwɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Asʋ́nklé sʋ́ bɛfɩtɛ́ mʋ asʋ́n ánfɩ, abʋyɔtɔ mʋ ha ahandɛ. Ɩnʋ Yesu lóbun, pʋ́ osrebi ɔdɛ atɔ́ wanlɩ́n ɔsʋlʋ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Brɛ́á bʋtráa bʋdɛ asʋ́n ámʋ fɩtɛ́ plá á, olobwií tsíá, bláa amʋ́ ɔbɛ́ɛ, “Mlɩtɔ ɔhá ánɩ́ ɔmɔkʋ́bwɛ́ lakpan kɩ ogyánkpa da ɔtsɩ ánfɩ ibwi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ɔlɛblɩ́ mʋ́ alɩ á, oleyinkí bun ɔdɛ mʋ atɔ́ wanlɩ́n ɔsʋlʋ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Brɛ́á ahá ámʋ bonu mʋ asʋ́n ánfɩ á, bɔwa natɩ́ ɩkʋlɛ-kʋlɛ bɩ, tsú ahandɛsʋ bɔtʋ nyebísʋ́. Ilebesi Yesu mʋa ɔtsɩ ámʋ nkʋlɛ ɔbʋn nsɩnɛ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu lóbwií tsíá, ɔlɛfɩtɛ́ ɔtsɩ ámʋ ɔbɛ́ɛ, “Ɔtsɩ, nkɩ́ɩ ahá ámʋ mɛ? Ɔkʋkʋ mésían ánɩ́ ɔbɛ́ha fʋ́ ɩpɔ́n?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɔtsɩ ámʋ lɛ́lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Owíé! Ɔkʋkʋ mɛ́ha mɩ́ pɔ́n o!” Mʋ́ʋ́ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɩbʋ alɛ́! Mɩ́ ɛ́ mmɛ́ɛha fʋ́ ɩpɔ́n! Natɩ, mátrá bwɛ lakpan.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɩ́nɩ ɔma a, Yesu léyinkí bláa Farisifɔ ámʋ ɔbɛ́ɛ, “Mɩ́gyí ɔyɩ́tɔ́ wankɩ nɩ. Ɔhagyíɔha ánɩ́ obuo mɩ obénya wankɩ ánɩ́ ɩbɛ́ha mʋ nkpa, oméesin oklúntɔ ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ɩnʋ á, Farisifɔ ámʋ bɛbláa mʋ bɛɛ, “Nfɔ́lɩ tamakánfʋ́ mʋ ɩwɩ. Fʋmɔkʋ́blɩ́ tɔtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mɩ́ onutó ndɛ mɩ́ ɩwɩ adánsɩɛ gyí ó á, ɔnɔkwalɩ igyi. Tsúfɛ́ mɩ́ mʋ́ nyin ɔtɩ́nɛ́á notsú pʋ́ ɔtɩ́nɛ́á nɔyɔ́. Támɛ mlɩméyín ɔtɩ́nɛ́á notsú pʋ́ ɔtɩ́nɛ́á nɔyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Anyánkpʋ́sa asʋ́ngyí ɔkpasʋ mlɩtegyi asʋ́n tsʋn, támɛ mɩ́ mʋ́ ntamagyi ɔhaa asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nɩ́ negyi asʋ́n ó á, ɔnɔkwalɩ ɔkpasʋ negyi mʋ́ tsʋn. Tsúfɛ́ megyí mɩ́ nkʋlɛ tegyi mʋ́. Mɩ́a mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ nyɔ tegyi mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bɔwanlɩ́n wá mlɩ onutó Mbla ámʋtɔ bɛɛ, ‘Nɩ́ adansɩfɔ abanyɔ́ bɛblɩ́ asʋn kua kʋlɛ a, amʋ́ asʋ́n ɩbʋ mʋ́tɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɩ́ onutó ntegyi mɩ́ ɩwɩ adánsɩɛ. Mɩ́ Sɩ́ lɔ́wa mɩ́ sɩ́sɩ́. Mʋ ɛ́ otegyi mɩ́ ɩwɩ adánsɩɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bɛfɩtɛ́ mʋ bɛɛ, “Nkʋ́nʋ́ fʋ́ sɩ́ bʋ?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩméyín mɩ́ wankláán, mlɩméyín mɩ́ Sɩ́ ámʋ ɛ́. Nɩ́ mlɩyin mɩ wankláán á, tɛkɩ mlɛ́bɩ mɩ́ Sɩ́ ámʋ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu lɛ́blɩ́ asʋ́n ánfɩ brɛ́á ɔdɛ atɔ́ suná Bulu ɔtswɛ́kpa tswɩtswɩ adáka otsiákpá. Támɛ ɔhaa mɛ́kɩtá mʋ, tsúfɛ́ mʋ brɛ́ mɔkʋ́nyá fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu lɛ́trá bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ mʋ́ nɔyɔ́. Mlódunká mɩ́. Mlówu wá mlɩ lakpantɔ. Mlɩmɛ́ɛtalɩ́ ba ɔtɩ́nɛ́á nɔyɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yudafɔ ahandɛ amʋ bɛfɩtɛ́ bɛɛ, “Mɔ́ ɔbɔ́mɔ mʋ ɩwɩ, sʋ́ ɔdɛblɩ́ ɔbɛ́ɛ, mlɩmɛ́ɛtalɩ́ ba ɔtɩ́nɛ́á nɔyɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩ mʋ́ mlotsú ɔyɩ́ ánfɩtɔ, támɛ mɩ́ mʋ́ notsú ɔsʋ́sʋ́. Ɔyɩ́ ánfɩtɔfɔ mlɩgyí. Mmegyí ɔyɩ́ ánfɩtɔyin mɩ́ mʋ́ ngyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mʋ́ sʋ́ ndɛ mlɩ bláa mbɛ́ɛ, mlówu wá mlɩ lakpantɔ nɩ́. Mlówu wá mlɩ lakpantɔ, nɩ́ mlɩmóhógyi ánɩ́ ‘Mɩ́gyí ɔhá ámʋ́ʋ́ mbɛ́ɛ ngyi ámʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bɛfɩtɛ́ mʋ bɛɛ, “Fʋ́gyí ma?” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ ntɛbláa mlɩ yáɩ́ mbɛ́ɛ, ngyi ámʋ kɛ́n ntráa ndɛ mlɩ bláa a. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mbʋ asʋ́n tsɔtsɔɔtsɔá nɛ́blɩ́ tsú mlɩ ɩwɩ pʋ́há mlɩ pɔ́n. Támɛ ɔnɔkwalɩpʋ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ gyí. Asʋ́n ánɩ́ nonu tsú mʋ wá ndɛ mlɩ ɔyɩ́tɔ́fɔ bláa.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɩmɔwankɩ́ amʋ́ ánɩ́ mʋ Sɩ ámʋ́ʋ́ ɔbʋ ɔsʋ́sʋ́ ámʋ ɩwɩ asʋ́n ɔdɛ amʋ́ bláa. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mʋ́ sʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɛdá Nyankpʋsa-Mʋ-Bi ámʋ mántá oyikpalíhɛsʋ, tsú mʋ́ lɩ́ɩ́ á, mlówun ánɩ́ ‘Mɩ́gyí ɔhá ámʋ́ʋ́ mbɛ́ɛ ngyi’ ámʋ. Mlɛ́bɩ ánɩ́ ntamabwɛ́ tɔtɔɔtɔ mɩ́ onutó túmitɔ. Mʋ́á mɩ́ Sɩ́ lɔ́pʋwá mɩ ɔnɔ́ á, mʋ́ ntɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ buo mɩ. Ɔmɔkʋ́yínkí mɩ́ ɔma, tsúfɛ́ tɔ́á itegyi mʋ ansɩ́ ntɔbwɛ́ brégyíbrɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ɩnʋ ahá ámʋ́ʋ́ bonu mʋ asʋ́n ánfɩtɔ tsɔtsɔɔtsɔ bɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu lɛ́bláa Yudafɔ ámʋ́ʋ́ bɔhɔ mʋ gyi amʋ ɔbɛ́ɛ, “Nɩ́ mlobuo mɩ́ atosunáhɛ́ a, mlɩgyí mɩ́ akasɩ́pʋ́ lɛ́lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mlɛ́bɩ ɔnɔkwalɩ amʋ. Ɔnɔkwalɩ amʋ ɩbɛ́ha mlégyi ɩwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bɛblɩ́ bɛɛ, “Abraham abí-aná anɩgyí. Anɩmɔ́kʋ́bwɛ́ ɔhaa nkpábi kɩ. Mʋ́ ntogyi sʋ́ fʋ́dɛ anɩ bláa fɛɛ, ‘Mlégyi ɩwɩ?’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ ɔtɔbwɛ́ lakpan á, ogyi lakpan ɔkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɔkpábi tamatsíá mʋ wie wóyí yɔ́, obí tetsíá mʋ sɩ wóyí yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mʋ́ sʋ nɩ́ Bulu mʋ Bi ámʋ ɔhá mlegyi ɩwɩ á, mʋ́mʋ́ mlɩlagyi ɩwɩ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyin ánɩ́ Abraham abí-aná mlɩgyí, támɛ mlɩdékléá mlɔ́mɔ mɩ́, tsúfɛ́ mlɩmɔ́hɔ mɩ́ atosunáhɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tɔ́á nowun tsu mɩ́ Sɩ́ wá ndɛblɩ́. Mlɩ ɛ́ asʋ́n ánɩ́ mlɩlónu tsú mlɩ sɩ́ wásʋ́ mlɩdégyí.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bɛbláa mʋ bɛɛ, “Anɩ sɩ́ gyí Abraham.” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ Abraham abí mlɩgyí á, tɛkɩ mlɩ bwɛhɛ́ lɛlɩan Abraham. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mlɩdékléá mlɔ́mɔ mɩ́, tsúfɛ́ ndɛ mlɩ ɔnɔkwalɩá nonu tsú Bulu wá bláa. Abraham mɔ́bwɛ alɩ! ");
INSERT INTO nkoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mlɩ sɩ́ bwɛhɛ́ mlɩdɛ́bwɛ.” Bɛbláa Yesu bɛɛ, “Megyí mbʋa bɔtɔ kwɩ́ɩ́ anɩ. Bulu onutó gyí anɩ Sɩ́. Anɩmá ɔsɩ́ ɔkʋkʋ tsɩ́a mʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mlɩ Sɩ́ gyí Bulu á, tɛkɩ mlɩtɔdwɛ́ mɩ́, tsúfɛ́ mʋ wá notsu ba. Mʋlɔ́wa mɩ́ sɩ́sɩ́. Megyí mɩ́ onutó túmitɔ nɛba. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ntogyi sʋ́ mlɩmɛ́dɛ́ mɩ́ asʋn blɩ́hɛ́ asɩ nu? Mlɩmɛ́dɛ́ mʋ́ asɩ nu, tsúfɛ́ mɩ́ asʋ́n dɛ mlɩ asʋtɔ wɔ́ɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɔbʋnsám gyí mlɩ sɩ́. Mʋ́ sʋ mlɩtekleá mlɔ́bwɛ tɔ́á mlɩ sɩ́ tekle. Ahá ɔmɔpʋ́ ogyi tsú nfiasɩ́. Ɔtamabuo ɔnɔkwalɩ. Mʋ́ sʋ ɔnɔkwalɩ kʋkʋ ɩma mʋtɔ. Nɩ́ ɔwá afunu a, mʋ tsiátɔ́ ɔwan ɔdɛlɛ, tsúfɛ́ ofunupʋ ogyi. Mʋgyí afunupʋ fɛ́ɛ́ ɔsɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Támɛ ntɛblɩ́ ɔnɔkwalɩ. Mʋ́ sʋ mlɩtamahɔ mɩ́ asʋ́nsʋ́ gyi nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mlɩtɔ ma ɔbɛ́talɩ́ súná ánɩ́ lakpan ɔbwɛpʋ́ ngyi? Nɩ́ ndɛ ɔnɔkwalɩ blɩ́ á, mʋ́ ntogyi mlɩmɔ́ɔhɔ mɩ gyi? ");
INSERT INTO nkoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɔhá ánɩ́ otsú Bulu wá tɛyáá asʋ nú mʋ asʋ́n. Mlɩ mʋ́ mlɩmótsú mʋ wá. Mʋ́ sʋ mlɩtamayáá asʋ nú mʋ asʋ́n nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yudafɔ ámʋ bɛbláa mʋ bɛɛ, “Nɩ́ ablɩ́ anɩaa Samariayin fʋgyi, ɔŋɛ laláhɛ bʋ fʋtɔ á, anɩlawá afunu?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔŋɛ laláhɛ ma mɩ́tɔ́. Ntobú mɩ́ Sɩ́, támɛ mlɩ mʋ́ mlɩtamabú mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mmɛdɛ́ mɩ́ ɩwɩ numnyam wa. Ɔha ɔkʋ bʋ ɩnʋá ɔdɛ mʋ́ dunká há mɩ́. Mʋgyí asʋ́n ogyípʋ́ wankláán ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ otegyi mɩ́ atosunáhɛ́sʋ omóowu ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ɩnʋ Yudafɔ ámʋ bɛbláa mʋ bɛɛ, “Séi ánfɩ mʋ́ á, anɩlawun ánɩ́ lɛ́lɛ́ ɔŋɛ laláhɛ bʋ fʋtɔ! Abraham mʋa Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bawú. Támɛ fʋ́ mʋ́ fʋdɛblɩ́ fɛɛ, ɔhagyíɔha ánɩ́ otegyi fʋ́ atosunáhɛ́sʋ omóowu ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Anɩ náin Abraham lówu. Fʋkɩ fɛɛ fʋdʋn mʋ? Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ ɛ́ bowu. Nkálɩ fʋ́dɛ fʋ́ ɩwɩ kɩ́ɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ nɔwá mɩ́ ɩwɩ numnyam a, kpaalɩ ígyi. Mɩ́ Sɩ́ gyí ɔhá ánɩ́ ɔtɔwá mɩ́ numnyam. Mʋ mlɩdɛ́blɩ́ mlɩaa ogyi mlɩ Bulu nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ɩbʋ mʋ́tɔ́ ánɩ́ mlɩméyín mʋ, támɛ mɩ́ mʋ́ nyin mʋ. Nɩ́ nɛblɩ́ mbɛ́ɛ mmeyín mʋ a, nabwɛ́ ofunupʋ fɛ́ mlɩ. Mɩ́ mʋ́ nyin mʋ, ntegyi mʋ asʋ́nsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mlɩ náin Abraham lénya ansigyí ánɩ́ mówun mɩ́ bábɩ. Olowun mʋ́ ɛ́, ansɩ́ legyi mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yudafɔ ámʋ bɛbláa mʋ bɛɛ, “Fʋmɔkʋ́hɔ nfí aduenu (50) kʋ́ráá, mʋ́ fɛɛ fɔtʋ Abraham?” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Mbʋ ɩnʋ asa bɔkwɩɩ́ Abraham.” ");
INSERT INTO nkoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesu lénya blɩ́ alɩ pɛ́, ahá ámʋ bɔkʋlá abwi bɛɛ abʋtswɩ da mʋ mɔ. Támɛ Yesu lɔ́bwɛ hɩ́ɛ́ɛ́, dálɩ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ɛkɛ ɔkʋ Yesu mʋa mʋ akasɩ́pʋ́ bʋna ɔkpatɔ, bowun oyin ɔkʋá bɔkwɩɩ́ mʋ ansibi obwiepʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesu akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, ma lakpan sʋ́ bɔkwɩɩ́ oyin ánfɩ ansibi obwiepʋ́? Mʋ onutó lakpan sʋ lóó, ntɛ́ɛ mʋ akwɩɩ́pʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí mʋ ntɛ́ɛ mʋ akwɩɩ́pʋ́ lakpan sʋ bɔkwɩɩ́ mʋ ansibi obwiepʋ́. Mboún alɩá Bulu ɔbɛ́lɛ mʋ túmi súná tsʋn mʋ ɩlɔ ámʋtɔ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ɩlasí kpalobí owí ɔbɛ́ta. Ɔhaa mɛ́ɛtalɩ́ trá yɔ agyʋ́má. Mʋ́ sʋ ilehián ánɩ́ abɔ́yɔ agyʋ́má ámʋ́ʋ́ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ lɔ́wa mɩ́ ɔbɛ́ɛ nyɔ́ɔ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ɩ́nɩá nenya mbʋ ɔyɩ́ ánfɩtɔ á, mɩ́gyí ɔyɩ́ ánfɩtɔ wankɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Brɛ́á Yesu lɛ́bláa amʋ́ asʋ́n ánfɩ tá á, olotu atsʋnɔ́ tswɩ ɔsʋlʋ́tɔ, ɔlɔpʋ osrebi tsɩ́á ɩsɩ, tɩ́tɩ mʋ́ tan ansibi obwiepʋ́ ámʋ ansíbisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mʋ́ʋ́ ɔlɛbláa ansibi obwiepʋ́ ámʋ ɔbɛ́ɛ, “Natɩ yɔfwɩ ansɩ́tɔ́ Siloam paatɩtɔ.” (Siloam asɩ gyí, “Bɔwa mʋ sɩ́sɩ́.”) Oyin ámʋ lɔ́yɔ́fwɩ ansɩ́tɔ́ yínkí ɔbá wóyí á, ɔdɛ atɔ́ wúun. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mʋ aba pʋ́ ahá ánɩ́ bʋtowun mʋ ɔdɛ atɔ́ kʋlɩ́ bɛfɩtɛ́ bɛɛ, “Megyí oyin ánfɩ tetsíá kʋ́lɩ́ atɔ́ brɛ́ ámʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amʋ́tɔ́ akʋ bɛɛ, “Mʋ nɩ!” Akʋ ɛ́ bɛɛ, “Ó-o, lɩ́an ɔlɛlɩan mʋ.” Ɩnʋ oyin ámʋ onutó lɛ́blɩ́ ɔbɛ́ɛ, “Mɩ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bɛfɩtɛ́ mʋ bɛɛ, “Nkálɩ ɩlɔbwɛ asa fʋdɛ atɔ́ wúun ngya?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Oyin ámʋ́ʋ́ bʋtɛtɩ́ mʋ Yesu amʋ lɔ́bwɛ ɔdɩba tan mɩ́ ansíbisʋ. Mʋ́ʋ́ ɔlɛbláa mɩ ɔbɛ́ɛ, nnátɩ yɔfwɩ ansɩ́tɔ́ Siloam paatɩtɔ. Nɔyɔ́fwɩ, mʋ́ʋ́ ndɛ atɔ́ wúun a.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɛfɩtɛ́ mʋ bɛɛ, “Nkʋ́nʋ́ ɔbʋ?” Mʋ́ʋ́ ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ohwée.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ɩnʋ bɛkpa oyin ámʋ́ʋ́ tɛkɩ ogyi ansibi obwiepʋ́ ámʋ yáa Farisifɔ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ɛkɛ ámʋ́ʋ́ Yesu lɔ́bwɛ ɔdɩba pʋ́bwíí mʋ ansíbi amʋ igyi ɔkpʋ́nʋ́ ɔdakɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mʋ́ sʋ Farisifɔ ámʋ bɛlafɩ́tɛ́ oyin ámʋ alɩá ɩlɔbwɛ asa ɔdɛ atɔ́ wúun. Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔdɩba ɔlɔpʋtan mɩ́ ansíbisʋ, nɔyɔ́fwɩ ansɩ́tɔ́. Mʋ́ʋ́ ndɛ atɔ́ wúun ngya a.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisifɔ ámʋ akʋ bɛblɩ́ bɛɛ, “Megyí Bulu ɔha oyin ámʋ́ʋ́ olobwií mʋ ansíbi amʋ gyí, tsúfɛ́ ɔtamagyi ɔkpʋ́nʋ́ ɔdakɛ́ mbla ámʋsʋ.” Támɛ akʋ ɛ́ bɛfɩtɛ́ bɛɛ, “Nkálɩ lakpan ɔbwɛpʋ́ ɔbɛ́talɩ́ bwɛ́ osúna anfɩ odu? Asʋ́n ánfɩ sʋ bʋmɛtrá bwɛ kʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mʋ́ sʋ bɛlafɩ́tɛ́ oyin ámʋ bɛɛ, “Fɛɛ mʋlóbwií fʋ́ ansíbi. Amansʋ fʋbʋ blɩ́ tsú mʋ ɩwɩ?” Oyin ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ogyi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudafɔ ahandɛ amʋ bʋmohogyi ánɩ́ lɛ́lɛ́, bɔkwɩɩ́ mʋ ansibi obwiepʋ́ asa séi ɔdɛ atɔ́ wúun, kpɛ́fʋn brɛ́á bɛtɩ mʋ akwɩɩ́pʋ́ ba. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bɛfɩtɛ́ amʋ́ bɛɛ, “Mlɩ bí ámʋ́ʋ́ mlɩaa, mʋ ansíbi lobwie asa mlɩlɔ́kwɩɩ́ mʋ amʋ nɩ? Nkálɩ ɩlɔbwɛ asa ɔdɛ atɔ́ wúun ngya?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mʋ akwɩɩ́pʋ́ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩyin ánɩ́ anɩ bí nɩ́. Anɩyin ánɩ́ anɩlɔ́kwɩɩ́ mʋ ansibi obwiepʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Támɛ alɩá ɩlɔbwɛ asa ɔdɛ atɔ́ wúun pʋ́ ɔhá ánɩ́ olobwií mʋ ansíbi mʋ́ á, anɩméyín. Kókoli mlɩ, mlɩfɩtɛ mʋ onutó. Megyí kebi ógyi, aladan. Ɔbɛ́talɩ́ lɛ́ mʋ́ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mʋ akwɩɩ́pʋ́ amʋ bʋdɛ Yudafɔ ahandɛ amʋ ifú nya. Mʋ́ sʋ bɛblɩ́ alɩ nɩ́. Tsúfɛ́ ahandɛ amʋ bablɩ́ tswɩ bɛɛ, ɔhagyíɔha ánɩ́ ɔbɛ́blɩ́ ɔbɛ́ɛ, Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) a, bégya mʋ lɛ́ Yudafɔ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mʋ́ sʋ mʋ akwɩɩ́pʋ́ amʋ bɛɛ, “Megyí kebi ógyi, aladan, mlɩfɩtɛ mʋ onutó!” nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bɛlatɩ́ oyin ámʋ́ʋ́ bɔkwɩɩ́ mʋ ansibi obwiepʋ́ ámʋ otse nyɔɔsɩ, bláa mʋ bɛɛ, “Ka ntam Bulu ansɩ́tɔ́ ánɩ́ fɛ́blɩ́ ɔnɔkwalɩ. Anɩyin ánɩ́ lakpan ɔbwɛpʋ́ oyin ámʋ́ʋ́ olobwií fʋ́ ansíbi amʋ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mʋ́ʋ́ oyin ámʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ lakpan ɔbwɛpʋ́ ogyi o, yilé ɔbwɛpʋ́ ogyi o, mɩ́ mʋ́ mmeyín. Toku kʋlɛ pɛ́ nyin. Mʋ́gyí, tɛkɩ brɛ́ ámʋ ntamawun atɔ́, támɛ séi mʋ́ ndewúun.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mʋ́ʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Nkálɩ ɔlɔbwɛ fʋ́? Nkálɩ olobwií fʋ́ ansíbi amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mʋ́ʋ́ ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nabláa mlɩ dodoodo, támɛ mlɩmónu. Ntogyi sʋ́ ntráa bla mlɩ? Mlɩ ɛ́ mlɩdékléá mlɔ́bwɛ mʋ akasɩ́pʋ́ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Besia mʋ, bláa mʋ bɛɛ, “Fʋ́gyí mʋ ɔkasɩ́pʋ́. Anɩ náin Mose akasɩ́pʋ́ anɩ mʋ́ anɩgyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anɩyin ánɩ́ Bulu lɔ́tɔɩ́ bláa Mose asʋ́n, támɛ anɩméyín ɔtɩ́nɛ́á oyin ánfɩ mʋ́ otsú.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Oyin ámʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Ngya ntɔ asʋ́n nɩ́? Mlɩméyín ɔtɩ́nɛ́á otsú, támɛ mʋlábwíí mɩ́ ansíbi nɩ o. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anɩ fɛ́ɛ́ anɩyin ánɩ́ Bulu tamanú lakpan abwɛpʋ́ isu. Ɔhá ánɩ́ otobú mʋ́, otegyi mʋ mblasʋ isu otonú. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tsú brɛ́á Bulu lɔ́bwɛ ɔyɩ́ ɔpá á, ɔhaa mɔ́kʋ́nú ánɩ́ ɔkʋ labwíí ɔhá ánɩ́ bɔkwɩɩ́ mʋ ansibi obwiepʋ́ ansíbi kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nɩ́ megyí Bulu ɔha oyin ánfɩ gyí á, tɛkɩ ɔmɛ́ɛtalɩ́ bwɛ́ tɔtɔɔtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ahandɛ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Fʋ́ ánfɩ fʋgyi lakpan ɔbwɛpʋ́ tsú brɛ́á bɔkwɩɩ́ fʋ́ ánfɩ dékléá fósuná anɩ asʋ́n?” Ɩnʋnʋ begya mʋ lɛ́ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu lónu ánɩ́ bagya oyin ámʋ lɛ́ ofíakpa ɩnʋ. Mʋ́ sʋ brɛ́á olowun mʋ a, ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Fɔhɔ Nyankpʋsa-Mʋ-Bi ámʋ gyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oyin ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Owíé, suna mɩ́ ɔhá ánɩ́ ogyi, mɩ́ anhɔ mʋ gyi!” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fawun mʋ dodo. Mʋgyí ɔhá ánfɩ ɔdɛ fʋ́ asʋ́n bláa séi ánfɩ á.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mʋ́ʋ́ oyin ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, nahɔ fʋ gyi.” Ɩnʋ olosúm Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Asʋ́n ogyíkpa nɛba ɔyɩ́ ánfɩtɔ, mɛ́nɩ ahá ánɩ́ bʋmɛdɛ́ atɔ́ wúun bówun atɔ́. Ahá ánɩ́ bʋdewúun ɛ́ ansíbi ibwie.” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisifɔ akʋá bʋbʋ Yesu wá ɩnʋ bonu asʋ́n ánfɩ. Mʋ́ʋ́ bɛfɩtɛ́ mʋ bɛɛ, “Mʋ́ sʋ fʋdɛblɩ́ fɛɛ anɩ ɛ́ anɩgyí ansibi abwiepʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ ansibi abwiepʋ́ mlɩgyí á, tɛkɩ Bulu mɛ́ɛha mlɩ ɩpɔ́n. Támɛ ɩ́nɩá mlɩaa mlɩdɛ́ atɔ́ wúun sʋ á, mlɩ lakpan lasin mlɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhá ánɩ́ ɔdʋ́ tsʋn akúfa ɩbansʋ wíé mʋ́tɔ́, ɔmɔtsʋn ɔkpa ɔnɔ́ á, owikplu pʋ́ ogyo otswapʋ́ ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tsúfɛ́ ɩban ɔnɔ́ akúfa ɔkpapʋ́ tɔtsʋn wie mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɩban ámʋsʋ ɔkɩ́pʋ tefínkí mʋ́ há akúfa ɔkpapʋ́ ámʋ tebítíwíé. Ɔtɔpʋ́ akúfa amʋ dá tɩ́ amʋ́, bʋtonú mʋ ɔmɛ, ɔtɛkpá amʋ́ dálɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nɩ́ ɔkpá akúfa amʋ fɛ́ɛ́ dálɩ a, otegya amʋ́ nkpá, bʋtobuo mʋ, tsúfɛ́ bʋyin mʋ ɔmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bʋtamabuo ɔfɔɔ́. Srɩ́ bʋtɛsrɩ́ sí mʋ, tsúfɛ́ bʋmeyín mʋ ɔmɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu lɛ́ha amʋ́ yébi anfɩ, támɛ bʋmonu mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu lɛ́trá bláa amʋ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa. Mɩ́gyí akúfa ɩban ámʋ ɔnɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Awikplu pʋ́ ogyo atswapʋ́ ahá ánɩ́ begyankpá ba fɛ́ɛ́ bʋgyi. Akúfa amʋ bʋmɛbɩ amʋ́ ɔmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɩ́gyí akúfa ɩban ámʋ ɔnɔ́ nɩ́. Nɩ́ ɔkʋ ɔtsʋn mɩtɔ wíé dálɩ a, tɔtɔ mɔ́ɔbwɛ mʋ́. Obéyénya atɔ́ gyí mwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Owikplu agywɩɩn gyí, ɔbá bowi, ɔmɔ, oyinta atɔ́. Mɩ́ mʋ́ nɛba, mɛ́nɩ ahá bénya nkpa ánɩ́ ɩlɔfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mɩ́gyí akúfa ɔkpapʋ́ wankláán ámʋ nɩ. Akúfa ɔkpapʋ́ wankláán totsúlá hʋ́lɩ mʋ nkpa há mʋ akúfa. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Támɛ akúfa ɔkpapʋ́ ánɩ́ ɔdɛ ɩpa gyí, megyí mʋ onutó bʋ́ akúfa amʋ tɛsrɩ́ nɩ́ owun ɔkpataku ɔbá bɛkɩtá amʋ́. Ɔkpataku ámʋ tɛkɩ́tá akúfa amʋtɔ ɔkʋ, atráhɛ bʋtɛdásáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Oyin ámʋ tɛsrɩ́, tsúfɛ́ ɩpa kɛkɛ odegyí. Akúfa amʋ nkpa tamahían mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mɩ́gyí akúfa ɔkpapʋ́ wankláán ámʋ nɩ. Nyin mɩ́ akúfa, mɩ́ akúfa ɛ́ bʋyin mɩ, ");
INSERT INTO nkoNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","fɛ́ alɩá mɩ́ Sɩ́ ámʋ yin mɩ á, alɩ́ mɩ́ ɛ́ nyin mʋ nɩ. Ntɔhʋ́lɩ mɩ́ nkpa há mɩ́ akúfa. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mbʋ akúfa bámbá akʋ ɛ́. Bʋma akúfa ɩban ánfɩtɔ. Ilehián ánɩ́ nɛ́kpa amʋ́ ɛ́ ba. Amʋ́ ɛ́ bónu mɩ́ ɔmɛ. Amʋ́ fɛ́ɛ́ bɔ́bwɛ akúfa iku kʋlɛ pʋ́ ɔkpapʋ́ ɔkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ɩ́nɩ sʋ́ mɩ́ Sɩ́ tekle mɩ asʋ́n nɩ́. Tsúfɛ́ natsúlá ánɩ́ nɔ́hʋlɩ́ɩ mɩ́ nkpa há ahá, mɛ́nɩ nɛ́lanyá mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɔhaa mɛ́ɛtalɩ́ swɩ́ɩ́ mɩ́. Mɩ́ onutó latsúlá ánɩ́ nɔ́hʋlɩ́ɩ mʋ́. Mbʋ ɔkpa hʋ́lɩ mɩ́ nkpa, mbʋ ɔkpa lányá mʋ́ ɛ́. Ɩ́nɩ mɩ́ Sɩ́ lɛ́bláa mɩ ɔbɛ́ɛ mbwɛ́ɛ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mʋ asʋn blɩ́hɛ́ anfɩ sʋ Yudafɔ ahandɛ amʋ bʋmɛtrá bwɛ kʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Amʋ́tɔ́ akʋ bɛblɩ́ bɛɛ, “Ɔŋɛ laláhɛ bʋ mʋtɔ. Mʋ nwun ideyintá. Ɔhaa mátrá nu mʋ asʋn blɩ́hɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Akʋ ɛ́ bɛɛ, “Ɔhá ánɩ́ ɔŋɛ laláhɛ bʋ mʋtɔ mɛ́ɛtalɩ́ blɩ́ asʋ́n ánfɩ odu. Ɔŋɛ laláhɛ ɔbɛ́talɩ́ bwíí ansibi obwiepʋ́ ansíbi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɛkɛá bʋtɔpʋ́káɩ́n Bulu ɔtswɛ́kpa gyʋrásʋ Yerusalem lɔfʋn. Alɩ brɛ́ ámʋ igyi lɩlɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu lɔ́yɔ odeki Bulu ɔtswɛ́kpatɔ ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ “Salomo Abrándaásʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yudafɔ ahandɛ amʋ akʋ befia bomlí mʋ. Bɛfɩtɛ́ mʋ bɛɛ, “Ɔmɛnkɛ kéín asa fɛ́bláa anɩ ɔnɔkwalɩ amʋ? Nɩ́ fʋ́gyí Kristo, (ɔhá amʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) a, wuna lɛ mʋ́ tii anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɛbláa mlɩ bɔtsʋn, támɛ mlɩmédéhogyi. Ofúla amʋ́ʋ́ ndɛbwɛ mɩ́ Sɩ́ dátɔ́ ámʋ dɛ́ mɩ́ ɩwɩ adánsɩɛ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Támɛ mlɩmédéhogyi, tsúfɛ́ mlɩmá mɩ́ akúfatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɩ́ akúfa bʋtonú mɩ́ ɔmɛ. Nyin amʋ́, bʋtobuo mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ntɛhá amʋ́ nkpa ánɩ́ ɩtamatá. Bʋmóowu ɛkɛkɛɛkɛ. Ɔhaa mɛ́ɛtalɩ́ swɩ́ɩ́ mɩ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɩ́ Sɩ́ ámʋ́ʋ́ ɔlɔpʋ amʋ́ há mɩ́ ámʋ dʋn tógyítɔ́. Ɔhaa mɛ́ɛtalɩ́ swɩ́ɩ́ amʋ́ lɛ́ mɩ́ Sɩ́ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mɩ́a mɩ́ Sɩ́ anɩgyí kʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɩnʋ á, Yudafɔ ahandɛ amʋ bɛtrá kʋlá abwi bɛɛ abʋtswɩ da Yesu mɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Támɛ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nabwɛ́ ofúla tsɔtsɔɔtsɔá itsú mɩ́ Sɩ́ wá súná mlɩ. Mʋ́tɔ́ mɔmʋ sʋ́ mlɩdékléá mlɛ́da mɩ́ abwi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bɛbláa mʋ bɛɛ, “Megyí ofúla ánɩ́ fabwɛ́ kʋkʋʋkʋ sʋ́ anɩaa abɛ́da fʋ́ abwi. Alɩ ámʋ́ʋ́ fablɩ́ abususʋ pʋ́kʋ́sʋ́ lɩ́ɩ́ Bulusʋ ámʋ sʋ. Nyankpʋsa fʋgyi, támɛ fɛɛ Bulu fʋ́gyi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Bʋmɔwanlɩ́n wá mlɩ Mbla ɔwʋlʋ́ ámʋtɔ bɛɛ, Bulu ɔbɛ́ɛ, ‘Mlɩgyí fɛ́ Bulu?’ ");
INSERT INTO nkoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anɩyin ánɩ́ ɔnɔkwalɩ Bulu asʋ́n igyi. Mʋ́ sʋ nɩ́ Bulu lɛ́tɩ ahá ámʋ́ʋ́ ɔlɔpʋ mʋ asʋ́n há ámʋ ɔbɛ́ɛ, bʋgyi fɛ́ mʋ a, ntogyi sʋ́ mlɩdɛ́ ɔblɔ́ nya? ");
INSERT INTO nkoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mɩ́ mʋ́ á, mɩ́ Sɩ́ lɛ́lɛ mɩ́ yáɩ́, ngyi mʋ klɛ, ɔlɔwa mɩ́ sɩ́sɩ́ ɔyɩ́ ánfɩtɔ. Ntogyi sʋ́ mlɩdɛ́blɩ́ mlɩaa nablɩ́ mbɛ́ɛ, ‘Bulu mʋ Bi ngyi’ sʋ nablɩ́ abususʋ pʋ́kʋ́sʋ́ lɩ́ɩ́ mʋsʋ? ");
INSERT INTO nkoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɩ́ megyí mɩ́ Sɩ́ agyʋ́má ndɛbwɛ mʋ́ á, mlɩmáhɔ mɩ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Támɛ nɩ́ mɩ́ Sɩ́ agyʋ́má ndɛbwɛ, asa mlɩmɔ́hɔ mɩ gyi kʋ́ráá á, mʋ́mʋ́ mlɩhɔ ofúla amʋ́ʋ́ ndɛbwɛ ámʋ mʋ́ gyi, amlɩbɩ ánɩ́ Mɩ́ Sɩ́ ámʋ bʋ mɩtɔ, mɩ́ ɛ́ mbʋ mʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bɛtrá bwɛ ánɩ́ bɛ́kɩtá mʋ, támɛ ɔlɛdalɩ amʋ́ ɩbɩ, nátɩ́ sí amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu léyinkí fá Yordan ɔbʋ́n ba ɔtɩ́nɛ́ ámʋ́ʋ́ Yohane létsiá bɔ́ ahá asú ámʋ, olesi tsiá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ahá tsɔtsɔɔtsɔ bɛba mʋ wá, bʋdɛ aba bláa bɛɛ, “Yohane mɔ́bwɛ osúna kʋkʋʋkʋ, támɛ asʋ́n ánɩ́ Yohane lɛ́blɩ́ tsú oyin ánfɩ ɩwɩ fɛ́ɛ́ laba mʋ́tɔ́ pɛ́pɛ́ɛ́pɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ahá tsɔtsɔɔtsɔ bɔhɔ mʋ gyi ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oyin ɔkʋá bʋtɛtɩ́ mʋ Lasaro mʋa mʋ apio tsɩhɛ́ Maria pʋ́ Marta betsiá Betania wúlutɔ. Oyin ámʋ lɔ́lɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria anfɩ lɛ́tsɛɩ́ mʋ ofobí fánfáánfán wʋ́lɩ́ anɩ Wíe Yesu ayabisʋ, pʋ́ mʋ imi tsítsi mʋ́ nɩ. Mʋ pio yínhɛ́ gyí Lasaro anfɩ́ ɔda ɔdɛlɔ á. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mʋ́ sʋ mʋ apio tsɩhɛ́ ánfɩ bɔwa abí sɩ́sɩ́ Yesu bɛɛ, “Owíé, fʋ́ ɔdwɛpʋ́ dɛ́lɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu lónu asʋ́n ámʋ a, ɔlɛblɩ́ ɔbɛ́ɛ, “Megyí ɩlɔ ánfɩ ɔbɔ́mɔ mʋ, mboún ɩbɛ́lɛ Bulu numnyam ɔwan. Ɩbɔ́wa mɩ́ Bulu mʋ Bi ánfɩ ɛ́ numnyam.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu tekle Marta mʋa Maria pʋ́ Lasaro fɛ́ɛ́ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Támɛ brɛ́á olonu ánɩ́ Lasaro dɛ́lɔ á, ɔlɛtrá si tsiá ɔtɩ́nɛ́á ɔbʋ nkenyɔ́ kɛ́kɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mʋ́ ɔma a, ɔlɛbláa mʋ akasɩ́pʋ́ ɔbɛ́ɛ, “Mlɩha ayinki yɔ Yudea.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mʋ akasɩ́pʋ́ amʋ bɛfɩtɛ́ mʋ bɛɛ, “Osunápʋ́, nwɛ́n nfɩ Yudafɔ ahandɛ bakle abʋda fʋ́ abwi mɔ. Mʋ́ fɛɛ fɛ́trá yinkí yɔ́ ɩnʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu lɔ́pʋ yébi lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Megyí dɔnhwɩ́rɩ dúanyɔ bʋ ɛkɛwʋ́lɛtɔ? Nɩ́ ɔha ná ɔyɩ kɛhɛtɔ á, ɔtamasúti, tsúfɛ́ nsaɩntɔ lɔ́wankɩ́, sʋ odewúun. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Támɛ nɩ́ ɔkʋ ná oklúntɔ á, otosúti, tsúfɛ́ ɔmɛdɛ́ atɔ́ wúun.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Asʋ́n ánfɩ ɔma a, ɔlɛtrá blɩ́ ɔbɛ́ɛ, “Anɩ nyáwíe Lasaro ladɩ́dɩ, támɛ nɔyɔ́ anyetsinkí mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Akasɩ́pʋ́ amʋ bɛbláa mʋ bɛɛ, “Anɩ Wíe, nɩ́ ɔdɛdɩdɩ mʋ́ á, ɩwɩ bɔ́wa mʋ ɔnlɩn!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasaro lowu ɩwɩ asʋ́n Yesu dɛ́blɩ́, támɛ akasɩ́pʋ́ amʋ mʋ́ bʋkɩ bɛɛ mʋ dɩdɩ́ kɛkɛ ɩwɩ asʋ́n ɔdɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɩnʋ Yesu lówunáa kpa mʋ́ opulu ɔbɛ́ɛ, “Lasaro lawú. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mlɩ sʋ ɩlawá mɩ́ ansigyí ánɩ́ mma ɩnʋ asa olowu, mɛ́nɩ mlɔ́hɔ mɩ gyi. Mlɩba ayɛkɩ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ɩnʋ Toma ánɩ́ ogyi Tabí lɛ́bláa mʋ aba ámʋ ɔbɛ́ɛ, “Mlɩha anɩa mʋnyɔ fɛ́ɛ́ ayɔ, mɛ́nɩ nɩ́ lowu ígyi kʋ́ráá á, anɩa mʋnyɔ awu!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu lówie Betania wúlutɔ á, bɛbláa mʋ bɛɛ bopulá Lasaro ɩlagyi nkɛná. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tsú Betania ya Yerusalem mɔfʋn máɩlɩ anyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mʋ́ sʋ Yudafɔ tsɔtsɔɔtsɔ bɛba Maria mʋa Marta gyɔwɩ ɔhakpá, amʋ́ píó lowu sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Benya bláa Marta ánɩ́ Yesu ɔbá alɩ, ɔlɔkʋsʋ́ yéfia mʋ ɔkpa. Maria mʋ́ lésin wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mʋ́ʋ́ Marta lɛ́bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíe, tɛkɩ nɩ́ fʋbʋ nfɩ á, tɛkɩ mɩ́ píó mówu sí mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Támɛ séi kʋ́ráá nyin ánɩ́ tógyítɔ́á fɔ́kʋlɩ́ Bulu á, ɔbɛ́ha fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́ píó ámʋ ɔbɛ́lakʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta lɛ́bláa mʋ ɔbɛ́ɛ, “Nyin ánɩ́ ɔbɔ́kʋsʋ́ ɛkɛ tráhɛ amʋ́ʋ́ afúli bɔ́kʋsʋ́ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́gyí ɔhá ánɩ́ ntɔkʋ́sʋ́a ahá tsú afúlitɔ, há amʋ́ nkpa. Ɔhá ánɩ́ ɔlɔhɔ mɩ gyi owú kʋ́ráá á, ɔbɛ́trá tsiá nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ɔhá ánɩ́ otsie nkpa, ɔlɔhɔ mɩ gyi ɛ́ móowu ɛkɛkɛɛkɛ. Fahɔ mʋ́sʋ́ gyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta lótsulá mʋ́sʋ́ ɔbɛ́ɛ, “Ee! Mɩ́ Wíe, nahogyi ánɩ́ fʋ́gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli), Bulu mʋ Bi ámʋ́ʋ́ bɛɛ ɔbɛ́ba ɔyɩ́tɔ́ ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Brɛ́á Marta lɛ́blɩ́ alɩ tá á, oleyinkí ba wóyítɔ́ bɛtɩ Maria ya ɩtsɛ́tɔ́, bláa mʋ ɔbɛ́ɛ, “Osunápʋ́ laba, ɔdɛ fʋ́ tɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria lénya nú mʋ́ alɩ, ɔlɔkʋsʋ́ yɔ́ Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Alɩ brɛ́ ámʋtɔ á, Yesu mɔ́kʋ́nyá wíé wúlutɔ. Ɔlɩɩ́ ɔtɩ́nɛ́ ámʋ́ʋ́ Marta lɔ́yɔ́tʋ mʋ amʋ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Brɛ́á ahá ámʋ́ʋ́ bʋtsie Maria wá wóyítɔ́, bʋdɛ mʋ klʋn yiá ámʋ bowun ánɩ́ alakʋ́sʋ́ ɔtsáwʋlɛ pɛ́ ɔyɔ́ á, bɔkʋsʋ́ buo mʋ. Bʋkɩ bɛɛ ɔyɔ́ opulákpá ɩnʋ yósu. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Brɛ́á Maria lówie Yesu wá á, ɔlɛda akpawunu, bláa Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, nɩ́ fʋbʋ nfɩ á, tɛkɩ mɩ́ píó mówu sí mɩ́!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Brɛ́á Yesu lówun ánɩ́ Maria mʋa ahá ámʋ́ʋ́ bʋbuo mʋ amʋ fɛ́ɛ́ bʋdesú a, ɩlɛhɩɛ han mʋ. Mʋ́ sʋ mʋ ansɩ́ lɛpɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nkʋ́nʋ́ mlɩlópulá mʋ.” Ɩnʋ bɛbláa mʋ bɛɛ, “Anɩ Wíe, bɛkɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ɩnʋ Yesu lósú. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mʋ́ sʋ Yudafɔ ámʋ bɛblɩ́ bɛɛ, “Kɩ alɩá ɔtɛhɩ́ɛ́ dwɛ́ Lasaro!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Támɛ amʋ́tɔ́ akʋ bɛblɩ́ bɛɛ, “Megyí oyin ánfɩ lóbwií ansibi obwiepʋ́ ámʋ ansíbi nɩ. Ntogyi sʋ́ ɔmɛtalɩ́ kɩ́tá Lasaro yáɩ́, alawú?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu ansɩ́ lɛ́trá pɛ́, ɔlɛnatɩ́ yɔ́ opulákpá ɩnʋ. Ibwi alatɔ bopulá mʋ, bemináa ibwi tin mʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩmina ibwi ámʋ lɛ ɔbɔ́ ámʋ ɔnɔ́.” Támɛ owupʋ́ ámʋ mʋ pio tsɩ́hɛ́ Marta lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, ndɛ aná mʋ́ á, alayíntá. Ndɛ ɛkɛ náásɩ́ ɔpá bopulá mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mmɛbláa fʋ mbɛ́ɛ nɩ́ fohogyi a, fówun alɩá Bulu ɩwɩ bʋ ifú?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɩnʋ bemináa ibwi ámʋ lɛ́ ɔbɔ́ ámʋ ɔnɔ́. Yesu lótsu ansɩ́ fʋ́á kɩ ɔsʋ́sʋ́, blɩ́ ɔbɛ́ɛ, “Mɩ́ Sɩ́, nɛdá fʋ́ ɩpán ánɩ́ fanú mɩ́ ɔmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nyin ánɩ́ fʋtonú mɩ́ mpáɩ ekekegyíɛkɛ. Támɛ ahá ánfɩ bʋlɩɩ́ nfɩ ánfɩ sʋ́ nablɩ́ alɩ, mɛ́nɩ bóhogyi ánɩ́ fʋ́lɔ́wa mɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Brɛ́á ɔlɔbɔ mpáɩ ánfɩ tá á, ɔlɔkplʋ́n blɩ́ ɔbɛ́ɛ, “Lasaro, dalɩ ba!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasaro lɛ́dalɩ a, tati klɩ mʋ ɩbɩ pʋ́ mʋ ayabi. Dúku ɛ́ klɩ mʋ ansɩ́tɔ́. Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩsankɩ mʋ ɔnatɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yudafɔ ámʋ́ʋ́ bobuo Maria ba ɩnʋ ámʋ bowun tɔ́á Yesu labwɛ́. Mʋ́ sʋ amʋ́ tsɔtsɔɔtsɔ bɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Támɛ amʋ́tɔ́ akʋ bɔyɔ yɛ́bláa Farisifɔ ámʋ tɔ́á Yesu labwɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ɩnʋnʋ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Farisifɔ ámʋ bɛtɩ aba asʋ́n agyípʋ́ fia. Mʋ́ʋ́ bɛfɩtɛ́ aba bɛɛ, “Nkálɩ abɔ́bwɛ? Lɛ́lɛ́ mʋ́ á, oyin ánfɩ dɛ́ osúna tsɔtsɔɔtsɔ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nɩ́ anɩmɛ́ka mʋ itin á, ɔhagyíɔha ɔbɔ́hɔ mʋ gyi. Ɩbɛ́ha Romafɔ bɛ́ba bobwie anɩ Bulu ɔtswɛ́kpa amʋ, yíntá anɩ ɔmá!” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Támɛ amʋ́tɔ́ ɔkʋlɛá bʋtɛtɩ́ mʋ Kaiafa, ogyi Bulu igyí ɔhapʋ́ dɛhɛn ofí ámʋtɔ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ mʋ́ mlɩméyín ɔlala! ");
INSERT INTO nkoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mlɩmɔ́kʋ́bɩ́ ánɩ́ ɩbʋ alɛ́á ɔbakʋ́lɛ obówu ahá fɛ́ɛ́ nwunsʋ, dʋn ánɩ́ ɔmá ámʋtɔ ahá fɛ́ɛ́ bɛ́hɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Megyí Kaiafa onutó agywɩɩn ɔ́lɔpʋblɩ́ asʋ́n ánfɩ. Támɛ ɩ́nɩá ofí ámʋtɔ mʋgyí Bulu igyí ɔhapʋ́ dɛhɛn sʋ á, igyi asʋ́n ánɩ́ ɔlɛblɩ́ tswɩ ánɩ́ ilehián ánɩ́ Yesu obówu há Yudafɔ ɔmá. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Megyí bɛɛ ɔmá ámʋ nkʋlɛ pɛ́ sʋ obówu, mboún alɩá ɔbɛ́kpa Bulu ahá ánɩ́ badásáɩ́n fɛ́ɛ́ bɔwa abatɔ, bɔ́bwɛ ɩkʋlɛ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tsú ɛkɛ ámʋ bɔwa agywɩɩn bwɛ ánɩ́ bɔ́mɔ Yesu bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɩ́nɩ sʋ Yesu mɛ́trá tsiá lɛ́ ɩwɩ ɔwan Yudafɔtɔ. Mboún ɔlɛnatɩ́ yɔ́ wúlu kʋá bʋtɛtɩ́ mʋ́ Efraim, ánɩ́ ɩbʋ dimbísʋ́. Mʋa mʋ akasɩ́pʋ́ amʋ betsiá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Brɛ́ ámʋtɔ á, Yudafɔ nkɛá bɔ́pʋgyi Israelfɔsʋ Katsʋn Nkɛ ámʋ lawíé wóyí tá. Ahá tsɔtsɔɔtsɔ botsu awúlusʋ dʋ́ yɔ́ Yerusalem ánɩ́ bɔyɔ́gyʋráa ɩwɩ asa nkɛ ámʋ ɩfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Brɛ́á bɔyɔ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ á, bodunká ánɩ́ bówun Yesu. Mʋ́ sʋ bɛfɩtɛ́ aba bɛɛ, “Nkálɩ mlɩdɛ́kɩ́ɩ? Mlɩlahogyi mlɩaa, ɔbɛ́ba nkɛ ánfɩtɔ lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Támɛ brɛ́ ámʋtɔ á, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Farisifɔ ámʋ babláa ahá bɛɛ, nɩ́ ɔkʋ owun ɔtɩ́nɛ́á Yesu bʋ a, ɔhá amʋ́ ɩbɩ, mɛ́nɩ bɛyɛ́kɩtá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ilesi nkensíé abʋgyi Israelfɔsʋ Katsʋn Nkɛ a, Yesu lɔ́yɔ Lasaro amʋ́ʋ́ ɔlɔkʋsʋ́a tsu afúlitɔ ámʋ wúlutɔ Betania. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mʋ́ ntʋ́pwɛsʋ bɔtswɩ ɔpʋ́nʋ́ há mʋ. Marta léye atogyihɛ ɔpʋ́nʋ́ ámʋ asɩ. Lasaro mʋa ahá ámʋ́ʋ́ bɛtɩ ámʋ bɔwa ɩbɩ gyi atɔ́ Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ɩnʋ Maria lɔ́pʋ ofobí fánfáánfán ánɩ́ ɩbʋ ibíá prɛntʋa yílé ɔbɔ bɛtsɛɩ́ wʋ́lɩ́ Yesu ayabisʋ, ɔlɔpʋ mʋ nwunsʋ-imi tsítsi mʋ́. Ofobí ámʋ ɔfan lɔhɔ wóyí ámʋtɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Támɛ Yuda Iskariot, ogyi Yesu akasɩ́pʋ́ amʋtɔ ɔkʋlɛ, ɔbɛ́lɛ Yesu há ámʋ mʋ́ lɛ́blɩ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ofobí ánfɩ bʋ bíá. Ntogyi sʋ́ bʋmɛfɛ mʋ́, pʋ́ kɔ́ba amʋ há ahiánfɔ? Mʋ́ bíá bɔ́bwɛ ɔbakʋ́lɛ ofi ɔkʋlɛ akatua.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Megyí ahiánfɔ nwewúun sʋ Yuda dɛ́ asʋ́n ánfɩ blɩ́. Owikplu ógyi sʋ. Mʋ wá sika okentebi bʋ, otetsíá wí kʋ lɛ́ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mlɩsi mʋ ɔpʋ ofobí ánfɩ wʋlɩ mɩ́ ha mɩ́ opulákɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ahiánfɔ mʋ́ bétsiá mlɩ wá ekekegyíɛkɛ, támɛ mɩ́ mʋ́ mméetsiá mlɩ wá yɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yudafɔ tsɔtsɔɔtsɔ bonu ánɩ́ Yesu laba Betania. Mʋ́ sʋ begya ɔkpa yɔ́ mʋ ɔkɩ́kpa. Megyí mʋ nkʋlɛ sʋ bɔyɔ́ ɩnʋ. Bɛyɛ́kɩ Lasaro amʋ́ʋ́ Yesu lɔ́kʋsʋ́a tsu afúlitɔ ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mʋ́ sʋ Bulu igyí ahapʋ́ dɛhɛn amʋ bɔbwɛ agywɩɩn bɛɛ bɔ́mɔ Lasaro ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tsúfɛ́ mʋ kʋsʋ́a tsu afúlitɔ sʋ Yudafɔ tsɔtsɔɔtsɔ bʋdɛ ɔma yinkí bɔhɔ Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɔyɩ kɛhɛ a, ɔdɔm amʋ́ʋ́ baba nkɛ ogyíkpá amʋ bonu ánɩ́ Yesu ɔbá Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mʋ́ sʋ bɛka mbláa, bɔpʋ ɔkpa beyéfia mʋ. Bʋdɛ okitikíti bɛɛ, “Hosiána! Bulu oyúla ɔhá anfɩ́ ɔna anɩ Wíe Bulu dátɔ́ ɔbá ánfɩ! Bulu oyúla Israel Owíe amʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu lénya afrímú ɔkʋ, ɔlɔdʋ bian mʋsʋ, fɛ́ alɩá bɔwanlɩ́n wá Bulu asʋ́ntɔ́ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sionfɔ, mlɩmánya ifú! Mlɩ Wíe dɩ́n afrímú ibísʋ́ ɔbá á!” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu akasɩ́pʋ́ amʋ bʋmɔkɔsɩ́ nú asʋ́n ánfɩ asɩ. Támɛ brɛ́á Bulu lɔ́kʋsʋ́a Yesu tsú afúlitɔ, wá mʋ numnyam ɔma a, bɛkaɩ́n ánɩ́ bɔwanlɩ́n asʋ́n ánfɩ tsú mʋ ɩwɩ. Mʋ́ bɔbwɛ há mʋ a. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aha ánɩ́ bobuo Yesu brɛ́á ɔlɛtɩ Lasaro fúli-ɔbɔ́tɔ́, kʋ́sʋ́a mʋ tsú afúlitɔ bɔyɔ mʋ́sʋ́ dá asʋ́n ánfɩ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɩ́nɩ sʋ ɔdɔm amʋ beyéfia mʋ nɩ. Bonu ánɩ́ alabwɛ́ osúna anfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisifɔ amʋ bɛbláa aba bɛɛ, “Mlɩlawun ánɩ́ anɩlabwɛ́ kásíán. Mlɩkɩ, ahá fɛɛ bayɔ́ bʋbuo mʋ o!” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Griikifɔ akʋ bʋbʋ ahá ámʋ́ʋ́ bɛba Bulu osúmkpá Yerusalem Israelfɔsʋ Katsʋn Nkɛ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bɔyɔ Filipo ánɩ́ otsu Betsaida ánɩ́ ɩbʋ Galilea ɔmátɔ́ wá yɛ́bláa mʋ bɛɛ, “Owíé, anɩdékléá abówun Yesu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo lɛ́bláa Andrea, mʋa mʋnyɔ bɛyɛ́bláa Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Brɛ́ lafʋn ánɩ́ bɔ́wa Nyankpʋsa-Mʋ-Bi ámʋ numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ɔnɔkwalɩ ndɛ mlɩ bláa. Nɩ́ kpolibí mɔkʋ́wíé ɔbɔ́tɔ́, ɩkwɛ, plɔ́ á, kpoli ibi-kʋlɛ amʋ kɛ́n igyi. Támɛ nɩ́ ɩkwɛ, plɔ́ á, ɩtɔbwɛ́ abí tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nɩ́ ɔkʋ tɔdwɛ́ mʋ nkpa ɔyɩ́ ánfɩtɔ á, ɔbɔ́hʋlɩ́ɩ mʋ́. Nɩ́ ɔkʋ ɛ́ tamadwɛ́ mʋ nkpa á, obénya nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nɩ́ mlɩtɔ ɔkʋ ɔbɛ́ɛ mósum mɩ́ á, ilehián ánɩ́ obóbuo mɩ, mɛ́nɩ obétsiá ɔtɩ́nɛ́á mbʋ. Nɩ́ ɔkʋ dɛ́ mɩ́ sum á, mɩ́ Sɩ́ ɔbɔ́wa mʋ numnyam.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu lɔ́yɔ mʋ́sʋ́ ɔbɛ́ɛ, “Séi á, asʋ́n dɛ́ mɩ́ klʋn háan! Amansʋ nɛ́blɩ́? Blɩ́ ntɛblɩ́ mbɛ́ɛ, Mɩ́ Sɩ́, lɛ mɩ́ tsu asʋn wunhɛ anfɩtɔ lóó? Ó-o, mʋ́ sʋ nɛba nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mɩ́ Sɩ́, wa fʋ́ ɩwɩ numnyam!” Ɩnʋ á, ɔmɛ ɔkʋ lótsu ɔsʋ́sʋ́ ba ɔbɛ́ɛ, “Nawá mɩ́ ɩwɩ numnyam dodo. Nɛ́trá wa mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Brɛ́á ɔdɔm amʋ́ʋ́ bʋlɩɩ́ ɩnʋ ámʋ bonu ɔmɛ amʋ a, bɛblɩ́ bɛɛ “Ɔpráda lapʋ́tɩ́.” Akʋ ɛ́ bɛɛ, “Bulu-ɔbɔpʋ lábláa mʋ asʋ́n!” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɩnʋ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ sʋ ɔmɛ anfɩ lalɩn, megyí mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Brɛ́á Bulu obégyi ɔyɩ́tɔ́fɔ asʋ́n nɩ́. Brɛ́á Bulu ɔbɛ́kplɩ́ Ɔbʋnsám, ɔyɩ́sʋ́ ogyípʋ́ amʋ obíásʋ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Támɛ mɩ́ mʋ́ á, nɩ́ bɛdá mɩ́ mántá oyikpalíhɛsʋ, tsú mʋ́ lɩ́ɩ́ á, nɛ́kpa ahá fɛ́ɛ́ ba mɩ́ ɩwɩ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Yesu lɛ́blɩ́ asʋ́n ánfɩ pʋ́súná lowu oduá mówu.) ");
INSERT INTO nkoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɩnʋ ɔdɔm amʋ bɛfɩtɛ́ mʋ bɛɛ, “Anɩ mʋ́ anɩlónu tsú anɩ Mbla ɔwʋlʋ́ ámʋtɔ ánɩ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) obétsiá brɛ́ fɛ́ɛ́. Mʋ́ ntogyi sʋ fʋ́dɛblɩ́ fɛɛ, ilehián ánɩ́ bɛdá Nyankpʋsa-Mʋ-Bi ámʋ mántá oyísʋ́, tsú mʋ́ lɩ́ɩ́? Ma gyí Nyankpʋsa-Mʋ-Bi ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Brɛ́ kpalobí kʋ pɛ́ ɩlasí ánɩ́ Wankɩ amʋ ɔbɛ́trá tsiá mlɩ wá. Ɩ́nɩá Wankɩ amʋ trá ɔbʋ mlɩ wá á, mlɩnatɩ wankɩ amʋtɔ, mɛ́nɩ owí mɛ́ɛta wá mlɩ. Tsúfɛ́ ɔhá ánɩ́ ɔna oklúntɔ tamabɩ́ ɔtɩnɛ́á ɔyɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Brɛ́ ánfɩ wankɩ amʋ trá ɔbʋ mlɩ wá á, mlɩhɔ mʋ gyi, mɛ́nɩ mlɔ́bwɛ wankɩ amʋ abí.” Brɛ́á Yesu lɛ́bláa amʋ́ asʋn anfɩ tá á, ɔlɛnatɩ́ yéŋaín. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɩ́nɩá ɔlɔbwɛ osúna tsɔtsɔɔtsɔ amʋ́ ansɩ́tɔ́ ó á, bʋmɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɩ́nɩ lɛ́ha Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tswɩ dodo amʋ lɛ́ba mʋ́tɔ́. Ɔbɛ́ɛ, “Anɩ Wíe, ma láhɔ asʋ́n ámʋ́ʋ́ anɩlɛ́blɩ́ ámʋsʋ gyi? Ma anɩ Wíe lalɛ́ mʋ túmi súná?” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mʋ́ sʋ bʋmɛtálɩ́ hɔ Yesu gyi, tsúfɛ́ Yesaia lɛ́trá blɩ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anɩ Wíe Bulu lahá bʋmedéwúun, bʋ́mɛdɛ́ asʋ́n nu, Mʋ́ sʋ bʋmóowun atɔ́, bʋmóonu asʋ́n, mɛ́nɩ bɛ́damlí ba mɩ́ wá, nɛ́tsa amʋ́ ɩlɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaia lówun Yesu numnyam. Mʋ́ sʋ ɔlɛblɩ́ asʋ́n ánfɩ tsú mʋ ɩwɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mʋ́ ó á, Yudafɔ ahandɛ amʋ tsɔtsɔɔtsɔ bɔhɔ mʋ gyi, támɛ bʋmɛlɛ amʋ́ hógyi ɔwan. Tsúfɛ́ benya ifú ánɩ́ Farisifɔ ámʋ bɛ́bɩ amʋ́, gya amʋ́ lɛ́ amʋ́ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tsúfɛ́ bʋtekle bɛɛ ahá bʋkánfʋ amʋ́ dʋn ánɩ́ Bulu ɔbɛ́kanfʋ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu lɔ́kplʋn blɩ́ ɔbɛ́ɛ, “Megyí mɩ́ nkʋlɛ ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ gyi déhógyi. Ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɔhagyíɔha ánɩ́ ɔdɛ mɩ́ wúun dɛ́ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ ɛ́ wúun. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naba ɔyɩ́ ánfɩtɔ fɛ́ wankɩ, fɛ́kɩ ɔsʋlʋ́ʋ anfɩsʋ ɩwankɩ, mɛ́nɩ ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ gyi méesin oklúntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nɩ́ ɔkʋ onú mɩ́ asʋ́n, támɛ omegyi mʋ́sʋ́ á, megyí mɩ́ ɔbɛ́ha mʋ ɩpɔ́n. Tsúfɛ́ mmɛba asʋ́n ogyíkpá. Ahá nkpa ɔhɔ́kpa nɛba. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɔha ánɩ́ okíná mɩ́, ɔmɔhɔ mɩ́ asʋ́n ɛ́ bʋ asʋ́n ánɩ́ bɔ́pʋhá mʋ ɩpɔ́n. Mɩ́ asʋn blɩ́hɛ́ amʋ ɩbɛ́ha mʋ ɩpɔ́n ɛkɛ tráhɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tsúfɛ́ megyí mɩ́ onutó túmi nɔpʋtɔ́ɩ́. Mɩ́ Sɩ́ lɔ́wa mɩ́ sɩ́sɩ́. Mʋlɛ́ha mɩ́ asʋ́n ánɩ́ mblɩ́ɩ, pʋ́ alɩá mblɩ́ɩ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nyin ánɩ́ mʋ asʋ́n ámʋ ɩtɛhá nkpa ánɩ́ ɩtamatá. Mʋ́ sʋ asʋ́n ánɩ́ ɔtɔwá mɩ́ blɩ́ kóún ntɛblɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Asa béfi Israelfɔsʋ Katsʋn Nkɛ ámʋ gyí asɩ á, Yesu lɛ́bɩ ánɩ́ mʋ brɛ́ lafʋn ánɩ́ mɛ́dalɩ ɔyɩ́ ánfɩtɔ yɔ́ mʋ Sɩ wá. Ɔlɔdwɛ ahá ámʋ́ʋ́ bʋgyi mʋ klɛ ɔsʋlʋ́sʋ nfɩ ámʋ alɩɩ yɔ́fʋn mʋ owukɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mʋa mʋ akasɩ́pʋ́ amʋ befia ntʋ́pwɛ atɔ́ ogyíkpá. Alɩ brɛ́ ámʋtɔ á, ɔbʋnsám lawúna wie Simon Iskariot mʋ bi Yuda klʋntɔ ánɩ́ ɔyɛ́lɛ Yesu ha. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu yin ánɩ́ mʋ Sɩ lɔ́pʋ tógyítɔ́ wá mʋ ɩbɩtɔ. Oyin ánɩ́ Bulu wá motsu ba, mʋ wá méyinkí yɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mʋ́ sʋ ɔlɛlɛ ɩbɩ ɔlɛpɛ ámʋtɔ, ɔlɔkʋsʋ́ wɔ́ɩ́ mʋ atadɩɛ tswɩ, tsú ɔsan sába. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ɔlɛtsɛɩ́ ntsu wá onuwétɔ́, olefi asɩ ɔdɛ mʋ akasɩ́pʋ́ amʋ ayabiasɩ fwɩ. Ɔfwɩ́ ɔmáyín a, alapʋ́ mʋ osíétɔ́ ɔsan ámʋ tsítsi mʋ ayabiasɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Brɛ́á ɩlɔtʋ Simon Petro a, ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, fʋ́ ɔbɔ́fwɩ mɩ́ ayabiasɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋmóonu tɔ́ ánfɩ ndɛbwɛ ánfɩ asɩ séi. Ɔma asa fóbonu mʋ́ asɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mʋ́ʋ́ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Ó-o! Mméesi, afʋfwɩ mɩ́ ayabiasɩ ɛkɛkɛɛkɛ.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ mmɔfwɩ fʋ́ ayabiasɩ á, fʋméenya ogyíkpa mɩ́ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, megyí mɩ́ ayabi nkʋlɛ. Wuna fwɩ mɩ́ ɩbɩ pʋ́ mɩ́ nwuntɔ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔhá ánɩ́ alabie ntsu mɛ́trá hián ntsubíe. Mboún mʋ ayabiasɩ fwɩ pɛ́, tsúfɛ́ alalɩn dodo. Mlɩ ɩwɩ lalɩn, támɛ megyí mlɩ fɛ́ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesu lɛ́bláa mʋ alɩ, tsúfɛ́ oyin ɔhá ánɩ́ ɔbɛ́lɛ mʋ há. Mʋ́ sʋ ɔlɛblɩ́ ɔbɛ́ɛ, “Megyí mlɩ fɛ́ɛ́ lálɩn” nɩ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Brɛ́á ɔlɔfwɩ amʋ́ ayabiasɩ tá á, ɔlɛlatsú mʋ atadɩɛ wá, yínkí yétsiá ɔpʋ́nʋ́ ámʋ asɩ. Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩlanú ɩtɔ́ ánfɩ nabwɛ́ há mlɩ ánfɩ asɩ? ");
INSERT INTO nkoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mlɩtɛtɩ́ mɩ́ ‘Osunápʋ́,’ mlɩtɛtɩ́ mɩ́ ‘Owíé.’ Mʋ́ ɔkpa nɩ́, tsúfɛ́ mʋ́ ngyi nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɩ́ mɩ́ ánɩ́ ngyi mlɩ osunápʋ́ pʋ́ mlɩ Wíe, nafwɩ́ mlɩ ayabiasɩ á, mʋ́mʋ́ ilehián ánɩ́ mlɩ ɛ́ mlɔ́fwɩ mlɩ aba ayabiasɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nabwɛ́ súná mlɩ, mɛ́nɩ mlɔ́bwɛ mʋ́ alɩ ámʋ́ʋ́ nabwɛ́ mʋ́ há mlɩ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ɔnɔkwalɩ ndɛ mlɩ bláa. Osúmpʋ́ ɔkʋkʋ mɔ́dʋn mʋ wie. Alɩ kɛ́n sumbí ɔyɔpʋ́ mɔ́dʋn ɔhá ánɩ́ ɔlɔwa mʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ɩ́nɩá mlɩlabɩ́ ɔnɔkwalɩ anfɩ á, Bulu obóyulá mlɩ nɩ́ mlegyi mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Megyí mlɩ fɛ́ɛ́ ɩwɩ asʋ́n ndɛblɩ́. Tsúfɛ́ nyin ahá ánɩ́ nalɛ́. Támɛ lehián ánɩ́ Bulu asʋ́n ánfɩ ɩbɛ́ba mʋ́tɔ́. Asʋ́n ámʋ ɔbɛ́ɛ, ‘Ɔhá ámʋ́ʋ́ mɩ́a mʋnyɔ anɩdɛ́ ɩbɩ wa ɔlɛpɛtɔ ámʋ lakʋ́sʋ́ lɩ́ɩ́ mɩ́sʋ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndɛ mlɩ bláa séi asa ɩba, mɛ́nɩ nɩ́ ɩbá á, mlɔ́hɔ mɩ gyi ánɩ́ mɩ́gyí ɔhá ámʋ́ʋ́ mbɛ́ɛ ngyi ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ ɔlɔhɔ ɔhá ánɩ́ nɔwa sumbí lahɔ mɩ. Alɩ kɛ́n ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ lahɔ mɩ́ Sɩ́ ámʋ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ ɛ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Brɛ́á Yesu lɛ́blɩ́ asʋ́n ánfɩ tá á, asʋ́n ɩhɩ́ɛ́ dɛ mʋ háan mʋ klʋntɔ. Mʋ́ sʋ olowunáa kpa mʋ́ tati ɔbɛ́ɛ, “Ɔnɔkwalɩ ndɛ mlɩ bláa, mlɩtɔ ɔkʋlɛ ɔbɛ́lɛ mɩ́ há.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Akasɩ́pʋ́ amʋ bɛkpɛlɛ́ kɩ aba ansɩ́tɔ́, tsúfɛ́ bʋmeyín amʋ́tɔ́ ɔmʋá ɔdɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Akasɩ́pʋ́ amʋtɔ ɔkʋlɛá otsie mantáa Yesu, gyí ɔmʋá Yesu tɛhɩ́ɛ́ dwɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mʋ́ sʋ Simon Petro lóbun mʋ ansíbi ɔbɛ́ɛ, ɔfɩ́tɛ mʋ ɔhá ánɩ́ ɔbɛ́lɛ mʋ há. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mʋ́ʋ́ ɔkasɩ́pʋ́ amʋ léyinkí kpɩ́sá Yesusʋ, fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, ma ɔbɛ́lɛ fʋ́ há?” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔhá ámʋ́ʋ́ nébia bodobodo, pʋ́dá oputsútɔ́ há ámʋ gyí mʋ nɩ.” Ɩnʋ olebia bodobodo pʋ́dá oputsútɔ́ há Yuda, ogyi Simon Iskariot mʋ bi. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Olenya hɔ mʋ́ alɩ, Ɔbʋnsám lówie mʋtɔ. Mʋ́ sʋ Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Bwɛ tɔ́á fʋdekléá fɔ́bwɛ sasa!” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ahá ámʋ́ʋ́ bʋtsie ɔpʋ́nʋ́ ámʋ asɩ ámʋtɔ ɔkʋkʋ mɛ́bɩ tɔ́á sʋá Yesu lɛ́bláa mʋ asʋ́n ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amʋ́tɔ́ akʋ bʋkɩ bɛɛ, Yuda gyí amʋ́ sikasʋ ɔkɩ́pʋ. Fíalɩ Yesu dɛ́ mʋ bláa ɔbɛ́ɛ, ɔyɔ́hɔ atɔ́á bɔ́pʋgyi nkɛ ámʋ, ntɛ́ɛ ɔpʋ́ʋ tɔkʋ ya ahiánfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda lénya hɔ bodobodo amʋ alɩ́, ɔlɛdalɩ. Owí latá alɩ brɛ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda lénya dálɩ obuto ɩnʋ alɩ Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Brɛ́á Mɩ́, Nyankpʋsa-Mʋ-Bi ánfɩ numnyam bɛ́lɩn ɔwan nɩ́. Bulu ɔbɔ́tsʋn mɩsʋ lɛ́ mʋ numnyam ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nɩ́ ɔtsʋn mɩsʋ lɛ́ mʋ numnyam ɔwan á, alɩ kɛ́n ɔbɔ́tsʋn mʋ ɩwɩsʋ lɛ́ mɩ́ numnyam ɔwan nɩ́. Ɔbɔ́wa mɩ́ numnyam ɩnʋnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mɩ́ abí, mmɛ́ɛtrá tsiá mlɩ wá, wá ɔpá. Mlódunká mɩ́. Alɩ ámʋ́ʋ́ nɛbláa Yudafɔ ahandɛ amʋ mbɛ́ɛ, ‘Mlɩmɛ́ɛtalɩ́ ba ɔtɩ́nɛ́á nɔyɔ́ ámʋ’ a, alɩ kɛ́n ndɛ mlɩ bláa mlɩ ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mbla pɔpwɛ ndɛwa há mlɩ mbɛ́ɛ, mlɩdwɛ aba. Alɩ ámʋ́ʋ́ nɔdwɛ mlɩ ámʋ a, alɩ kɛ́n mlɩpʋ́ ɔdwɛ ámʋ dwɛ mlɩ aba nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɩ́ mlɩdɛ́ aba dwɛ á, ibósuná ahá fɛ́ɛ́ ánɩ́ mɩ́ akasɩ́pʋ́ mlɩgyí.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petro lɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, nkʋ́nʋ fɔyɔ́?” Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔtɩ́nɛ́ ámʋ́ʋ́ nɔyɔ́ ámʋ a, fʋmɛ́ɛtalɩ́ buo mɩ yɔ́ ɩnʋ séi. Támɛ ɔma a, fóbobuo mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, ntogyi sʋ́ mmɛ́ɛtalɩ́ buo fʋ séi. Nówu fʋ́ sʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Fówu mɩ́ sʋ? Ɔnɔkwalɩ ndɛ fʋ́ bláa. Fɔ́swɩɩ́ pʋ́ ɩbɩ wá ogyá tse sa fɛɛ fʋmeyín mɩ́ asa batɛ ɔbɛ́lɛ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu lɛ́bláa mʋ akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Opúni mátsií mlɩ. Mlɩhɔ Bulu gyi, amlɩhɔ mɩ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Otsiákpá tsɔtsɔɔtsɔ bʋ mɩ́ Sɩ́ wóyítɔ́. Nɩ́ otsiákpá ma ɩnʋ á, tɛkɩ mmɛbláa mlɩ mbɛ́ɛ nɛyɛ́la ɩnʋ yáɩ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɩ́ nɔyɔ́ yɛ́la otsiákpá amʋ yáɩ́ mlɩ tá á, néyinkí bá bɛkpa mlɩ yáa mɩ́ ɩwɩ wá, mɛ́nɩ mlétsiá ɔtɩ́nɛ́á mbʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mlɩyin ɔkpa ánɩ́ ɩda yɔ ɔtɩ́nɛ́ ámʋ́ʋ́ nɔyɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ɩnʋ Toma lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ Wíé, anɩméyín ɔtɩ́nɛ́á fɔyɔ́, nkálɩ abɔ́bwɛ abɛ́bɩ ɔkpa ámʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́gyí ɔkpa ámʋ, ɔnɔkwalɩ amʋ pʋ́ nkpa ámʋ. Ɔhaa mɛ́ɛtalɩ́ yɔ́ mɩ́ Sɩ́ ámʋ wá, nkɛ́tɩ alatsʋn mɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɩ́ mlɩyin mɩ lɛ́lɛ́ á, tɛkɩ mlɩlabɩ́ mɩ́ Sɩ́ ámʋ ɛ́. Támɛ séi mʋ́ mlɩlawun mʋ, mlɩlabɩ́ mʋ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo lɛ́bláa mʋ ɔbɛ́ɛ, “Anɩ Wíé, suna anɩ fʋ́ Sɩ́ ámʋ. Mʋ́ kpán tsɔ anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Filipo! Mbʋ mlɩ wá dodoodo. Mʋ́ sʋ fʋmɔkʋ́bɩ́ mɩ́? Ɔhagyíɔha ánɩ́ alawun mɩ kɩ lawun mɩ́ Sɩ́ ámʋ. Ntogyi sʋ́ fʋ́dɛblɩ́ fɛɛ, nsúna mlɩ Ɔsɩ́ ámʋ? ");
INSERT INTO nkoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fʋmohogyi ánɩ́ mbʋ mɩ́ Sɩ́ ámʋtɔ, mʋ ɛ́ ɔbʋ mɩtɔ? Asʋ́n ánfɩ ndɛ mlɩ bláa anfɩ motsú mɩ́ onutó wá. Mboún mɩ́ Sɩ́ ámʋ́ʋ́ ɔbʋ mɩtɔ ámʋ dɛ́ mʋ agyʋ́má yɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nɩ́ ndɛ mlɩ bláa mbɛ́ɛ, mbʋ mɩ́ Sɩ́ ámʋtɔ, mʋ ɛ́ ɔbʋ mɩtɔ á, mlɩhɔ mɩ gyi. Nɩ́ mlɩmɔ́ɔhɔ asʋ́n ámʋsʋ gyi óó á, ofúla amʋ́ʋ́ ndɛbwɛ ámʋ sʋ mlɩhɔ mɩ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ɔnɔkwalɩ ndɛ mlɩ bláa. Ɔhagyíɔha ánɩ́ ɔlɔhɔ mɩ gyi a, ɔbɔ́bwɛ ɩtɔ́á ndɛbwɛ. Ɔbɔ́bwɛ mʋ́ dʋn mɩ́ klɛ́, tsúfɛ́ mɩ́ mʋ́ nɔyɔ́ mɩ́ Sɩ́ ámʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nɔ́bwɛ tógyítɔ́á mlɔ́kʋlɩ́ mɩ́ ɩdátɔ́ há mlɩ, mɛ́nɩ nɔ́wa mɩ́ Sɩ́ ámʋ numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɩ́ mlɔkʋ́lɩ́ tógyítɔ́ mɩ́ ɩdátɔ́ á, nɔ́bwɛ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nɩ́ mlɩtɔdwɛ́ mɩ́ á, mlégyi mɩ́ mblasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɔ́kʋlɩ́ mɩ́ Sɩ́, ɔbɔ́pʋ Ɔma Ɔlɩɩ́pʋ́ bambá sɩ́sɩ́ mlɩ, ɔbɛ́ba betsiá mlɩ wá brɛ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mʋgyí Ɔŋɛ Wankɩ́hɛ́. Mʋtósúná ɔnɔkwalɩ ánɩ́ ɩbʋ Bulutɔ. Ɔyɩ́tɔ́ ahá bʋmɛ́ɛtalɩ́ hɔ mʋ, tsúfɛ́ bʋmɛdɛ́ mʋ dunká. Bʋmɛ́ɛbɩ mʋ ɛ́, támɛ mlɩ mʋ́ mlɩyin mʋ, tsúfɛ́ ɔbʋ mlɩ wá, obétsiá mlɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Mméesi mlɩ tswɩ fɛ́ awumbi. Néyinkí bá mlɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɩlasí kpalobí ɔyɩ́tɔ́ ahá bʋmɛ́ɛtrá wun mɩ, támɛ mlɩ mʋ́ mlówun mɩ. Ɩ́nɩá mbʋ nkpa sʋ á, mlɩ ɛ́ mlétsiá nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nɩ́ ɛkɛ ámʋ ɩfʋn a, mlɛ́bɩ ánɩ́ mbʋ mɩ́ Sɩ́ ámʋtɔ. Mlɩ ɛ́ mlɩbʋ mɩtɔ fɛ́ alɩ ámʋ́ʋ́ mɩ́ ɛ́ mbʋ mlɩtɔ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ahá ánɩ́ bʋdɛ mɩ́ mblasʋ gyí a, amʋ́gyí mɩ́ adwɛpʋ́ nɩ́. Ɔhagyíɔha ánɩ́ ɔtɔdwɛ́ mɩ́ á, mɩ́ Sɩ́ ɔbɔ́dwɛ mʋ. Mɩ́ ɛ́ nɔ́dwɛ mʋ, lɛ́ mɩ́ ɩwɩ ɔwan súná mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mʋ́ʋ́ Yuda (megyí Yuda Iskariot) lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mɩ́ Wíe, ntogyi sʋ́ anɩ nkʋlɛ pɛ́ fɛ́lɛ ɩwɩ ɔwan súná, megyí ɔyɩ́tɔ́ ahá fɛ́ɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ ɔkʋ dɛ́ mɩ́ dwɛ á, ɔbɔ́bwɛ dɩ́nká mɩ́ atosunáhɛ́sʋ. Mɩ́ Sɩ́ ɔbɔ́dwɛ mʋ. Mɩ́a mɩ́ Sɩ́ ámʋ nyɔ abɛ́ba betsiá mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɔhá ánɩ́ ɔtamadwɛ́ mɩ́ ɔmɔ́ɔbwɛ dɩ́nká mɩ́ atosunáhɛ́sʋ. Asʋ́n ánfɩ ndɛblɩ́ mlɩdénu ánfɩ motsú mɩ́ onutó wá. Mɩ́ Sɩ́ lɔ́wa mɩ́, mʋ wá itsú. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ndɛ mlɩ asʋ́n ánfɩ bláa, séi ánfɩ mbʋ mlɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Támɛ Ɔma Ɔlɩɩ́pʋ́, ogyi Ɔŋɛ Wankɩ́hɛ́ amʋ́ʋ́ mɩ́ Sɩ́ ɔbɔ́pʋsɩ́sɩ́ mɩ́ ɩdátɔ́ ámʋ obósuná mlɩ tógyítɔ́. Ɔbɛ́kaɩ́n mlɩ asʋ́ngyíasʋ́n ánɩ́ nɛbláa mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Iwilwii ndɛ mlɩ ha! Napʋ́ mɩ́ iwilwii há mlɩ. Megyí mʋ́ ámʋ́ʋ́ ɔyɩ́tɔ́fɔ bʋtɛhá ámʋ odu. Mlɩmáha opúni itsii mlɩ. Ifú ɛ́ mákɩtá mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nabláa mlɩ bɔtsʋn mbɛ́ɛ, ndɛnatɩ́, támɛ néyinkí bá mlɩ wá. Nɩ́ mlɩtɔdwɛ́ mɩ́ á, tɛkɩ mlénya ansigyí ánɩ́ nɔyɔ́ mɩ́ Sɩ́ wá, tsúfɛ́ ɔdʋn mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndɛ mlɩ ɩ́nɩ fɛ́ɛ́ bláa yaɩ́, mɛ́nɩ nɩ́ ɩbá mʋ́tɔ́ á, mlóhogyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mmɛ́ɛtrá tɔɩ́ yɔ́ nkpá, tsúfɛ́ ɔyɩ́sʋ́ ogyípʋ́ ámʋ ɔbá. Ɔma túmi mɩ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ntonú mɩ́ Sɩ́ ɔmɛ, mɛ́nɩ ɔyɩ́tɔ́fɔ bɛ́bɩ ánɩ́ ntɔdwɛ́ mʋ. “Mlɩkʋsʋ anatɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu lɛ́blɩ́ ɔbɛ́ɛ, “Mɩ́gyí wáɩn ɩfla onutó. Mɩ́ Sɩ́ gyí mʋ́ ɔdɔ́pʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bámbigyíbámbiá ɩbʋ mɩ́ ɩwɩ, ɩtamaswíé á, ɔtɛkpálɩ́ mʋ́ tsítsá. Támɛ kugyíkʋá itoswíé á, ɔtɛlá mʋ́ wankláán, mɛ́nɩ ibóswie tsɔtsɔɔtsɔ dʋn. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mɩ́ atosunáhɛ́ anfɩ mlɩlanú ánfɩ sʋ mlɩ ɩwɩ latɩn dodo. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mlɩtsia mɩ́tɔ́, mɩ́ ɛ́ antsia mlɩtɔ. Bámbi kʋkʋʋkʋ mɛ́ɛtalɩ́ swíé abí, nkɛ́tɩ ɩtsa mʋ́ oyísʋ́ brégyíbrɛ́. Alɩ kɛ́n mlɩ ɛ́ mlɩmɛ́ɛtalɩ́ swíé abí, nkɛ́tɩ mlɩbʋ mɩtɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mɩ́gyí wáɩn ɩfla ámʋ. Mlɩgyí mʋ́ abámbi. Ɔhá ánɩ́ ɔbʋ mɩtɔ, mɩ́ ɛ́ mbʋ mʋtɔ obóswie abí tsɔtsɔɔtsɔ, tsúfɛ́ mlɩmɛ́ɛtalɩ́ bwɛ́ tɔtɔɔtɔ tsʋn mɩ́ ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɔhagyíɔha ánɩ́ ometsie mɩtɔ gyí fɛ́ bámbiá bakpálɩ́ mʋ́ bun, ɩbɔ́wʋlɩ, bɛ́kpa mʋ́ wá ogyá. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɩ́ mlɩtsie mɩtɔ, mɩ́ asʋ́n ɛ́ ɩbʋ mlɩtɔ á, mlɛ́fɩtɛ mɩ́ Sɩ́ tógyítɔ́á mlɩdéklé, ɔbɛ́ha mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɩ́ mloswíé abí tsɔtsɔɔtsɔ á, ɩbɔ́wa mɩ́ Sɩ́ numnyam. Mʋ́ obósuná ánɩ́ mɩ́ akasɩ́pʋ́ mlɩgyí nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Alɩ ámʋ́ʋ́ mɩ́ Sɩ́ tɔdwɛ́ mɩ́ ámʋ a, alɩ kɛ́n mɩ́ ɛ́ ntɔdwɛ́ mlɩ nɩ́. Mlɩtsia mɩ́tɔ́, mɛ́nɩ nɔ́dwɛ mlɩ yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɩ́ mlegyi mɩ́ mblasʋ á, nɔ́dwɛ mlɩ yɔ́, fɛ́ alɩ ámʋ́ʋ́ mɩ́ ɛ́ ntegyi mɩ́ Sɩ́ mblasʋ, ɔtɔdwɛ́ mɩ́ yɔ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nabláa mlɩ asʋ́n ánfɩ fɛ́ɛ́, mɛ́nɩ ansigyí ámʋ́ʋ́ ɩbʋ mɩtɔ ámʋ bétsiá mlɩtɔ. Fówun ansɩ́ bégyi mlɩ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mbla ánɩ́ ndɛpʋhá mlɩ gyí; mlɩdwɛ aba fɛ́ alɩá ntɔdwɛ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ɔdwɛ kʋkʋ mɔdʋ́n ánɩ́ ɔkʋ obówu mʋ nyawie nwunsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nɩ́ mlegyi mɩ́ mblasʋ á, mɩ́ anyawíe mlɩgyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mmɛ́ɛtrá tɩ mlɩ mɩ́ asúmpʋ́. Tsúfɛ́ osúmpʋ́ méyín tɔ́á mʋ wie dɛ́bwɛ. Ndɛ mlɩtɩ mɩ́ anyawíe, tsúfɛ́ nabláa mlɩ tógyítɔ́á nonu tsú mɩ́ Sɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Megyí mlɩ lɛ́lɛ mɩ́. Mɩ́lɛ́lɛ mlɩ yáɩ́ mbɛ́ɛ, mlɩyɔ́ɔ amlɩyoswie abíá ibétsiá brɛ́ fɛ́ɛ́, mɛ́nɩ mɩ́ Sɩ́ ɔbɛ́ha mlɩ tógyítɔ́á mlɔ́kʋlɩ́ mʋ mɩ́ ɩdátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mbla ánɩ́ ndɛwa há mlɩ gyí, ‘Mlɩdwɛ aba.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nɩ́ ɔyɩ́tɔ́ ahá bʋdɛ mlɩ lu á, mlɩkaɩn ánɩ́ mɩ́ begyankpá lú. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɩ́ ɔyɩ́tɔ́ ahá mlɩgyí a, tɛkɩ ɔyɩ́tɔ́ ahá bɔ́dwɛ mlɩ fɛ́ amʋ́ abí. Támɛ nalɛ́ mlɩ tsú ɔyɩ́tɔ́fɔtɔ, sʋ mlɩmá amʋ́tɔ́. Ɩ́nɩ sʋ ɔyɩ́tɔ́fɔ bʋtolú mlɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mlɩkaɩn asʋ́n ámʋ́ʋ́ nɛbláa mlɩ mbɛ́ɛ, ‘Osúmpʋ́ ɔkʋkʋ mɔ́dʋn mʋ wie’ amʋsʋ. Nɩ́ ahá bʋdɩn mɩ́sʋ́ a, mlɩ ɛ́ bɛ́dɩnká mlɩsʋ. Nɩ́ begyi mɩ́ asʋ́nsʋ́ á, mlɩ ɛ́ bégyi mlɩ asʋ́nsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Támɛ mɩ́bʋ́ mlɩ, sʋ bɔ́pʋ ɩ́nɩ fɛ́ɛ́ gyi mlɩ, tsúfɛ́ bʋmeyín ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nɩ́ mmɔkʋ́bláa amʋ́ asʋansʋ á, tɛkɩ bʋma ɩpɔ́n kʋkʋ gyí. Támɛ séi ánfɩ mʋ́ bʋma ɔnɔ́ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɔhagyíɔha ánɩ́ otolú mɩ́ tolú mɩ́ Sɩ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nabɔbwɛ agyʋ́má ánɩ́ ɔhaa mɔ́kʋ́bwɛ́ mʋ́ odu kɩ amʋ́tɔ́. Nɩ́ bʋmɔpʋ amʋ́ ansíbi wun mʋ́ á, tɛkɩ Bulu mɛ́ɛha amʋ́ ɩpɔ́n. Bowun tɔ́á nɔbwɛ asa bʋdɛ mɩ́a mɩ́ Sɩ́ lu. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ilehián ánɩ́ ɩbɛ́ba alɩ, mɛ́nɩ asʋ́n ámʋ́ʋ́ bɔwanlɩ́n wá amʋ́ Mblatɔ bɛɛ, ‘Bolu mɩ́ kpaalɩ’ ámʋ ɩbɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nɔ́wa Ɔma Ɔlɩɩ́pʋ́ obótsu mɩ́ Sɩ́ wá bá. Mʋgyí Ɔŋɛ Wankɩ́hɛ́ amʋ. Mʋtósúná ɔnɔkwalɩ ánɩ́ ɩbʋ Bulutɔ. Obégyi mɩ́ ɩwɩ adánsɩɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mlɩ ɛ́ mlégyi mɩ́ ɩwɩ adánsɩɛ, tsúfɛ́ mlɩlatsíá mɩ́ wá tsú brɛ́á nefi atɔ́ suná asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nabláa mlɩ asʋ́n anfɩ fɛ́ɛ́, mɛ́nɩ mlɩmɛ́ɛdɩda hógyitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yudafɔ ahandɛ bégya mlɩ lɛ́ amʋ́ ofíakpa. Brɛ́ kʋ kʋ́ráá ɩbɛ́ba ánɩ́ ahá bɔ́mɔ mlɩ, súsu bɛɛ Bulu agyʋ́má bʋdɛyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bɔ́pʋ ɩ́nɩ gyi mlɩ, tsúfɛ́ bʋmɔkʋ́bɩ́ mɩ́ ntɛ́ɛ mɩ́ Sɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Támɛ nabláa mlɩ asʋ́n ánfɩ, mɛ́nɩ nɩ́ ɩbá á, mlɛ́kaɩ́n ánɩ́ nɛbláa mlɩ yáɩ́. “Mmɔkɔsɩ́ bláa mlɩ asʋ́n ánfɩ, tsúfɛ́ mbʋ mlɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Támɛ séi ndɛ mlɩ bláa, tsúfɛ́ nɔyɔ́ ɔhá ámʋ́ʋ́ ɔlɔwa mɩ́ sɩ́sɩ́ ámʋ wá. Támɛ mlɩtɔ ɔkʋkʋ mɛ́fɩtɛ́ mɩ́ ɔbɛ́ɛ, ‘Nkʋ́nʋ́ fɔyɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ɩ́nɩá nabláa mlɩ asʋ́n ánfɩ sʋ á, awɩrɛhɔ lahɩ́ɛ́ kɩ́tá mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Támɛ ndɛ mlɩ ɔnɔkwalɩ bláa. Ɔkláa lawá mlɩ ogyá ánɩ́ nɔyɔ́. Tsúfɛ́ nɩ́ mmɔyɔ á, Ɔma Ɔlɩɩ́pʋ́ amʋ ɔmɛ́ɛba mlɩ wá. Támɛ nɩ́ nɔyɔ́ á, nɔ́pʋ mʋ sɩ́sɩ́ mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɩ́ ɔbá á, ɔbɛ́lɛ súná ɔyɩ́tɔ́ ahá ánɩ́ lakpanbwɛ sʋ bafwɩ́, ɔbɛ́lɛ tɔ́á igyi Bulu yilébwɛ pʋ́ mʋ asʋ́ngyí ɛ́ súná amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bɛ́bɩ ánɩ́ mɩ́sʋ́ máhógyi igyi lakpan. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bɛ́bɩ tɔ́á igyi Bulu yilébwɛ, tsúfɛ́ nɔyɔ́ mɩ́ Sɩ́ wá, mlɩmɛ́ɛtrá wun mɩ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bɛ́bɩ tɔ́á igyi Bulu asʋ́ngyí, tsúfɛ́ Bulu lahá ɔbʋnsám, ogyi ɔyɩ́sʋ́ ogyípʋ́ amʋ ɩpɔ́n dodo. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mbʋ asʋ́n tsɔtsɔɔtsɔ ánɩ́ nɛ́bláa mlɩ, támɛ mlɩmɛ́ɛtalɩ́ nú mʋ́ fɛ́ɛ́ asɩ séi. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ɔŋɛ Wankɩ́hɛ́ amʋ tósúná ɔnɔkwalɩ ánɩ́ ɩbʋ Bulutɔ. Nɩ́ ɔbá á, ɔbɛ́lɛ asʋ́n ánɩ́ igyi ɔnɔkwalɩ fɛ́ɛ́ súná mlɩ. Tsúfɛ́ megyí mʋ onutó túmitɔ ɔbɔ́tɔɩ́, mboún ɔbɛ́blɩ́ asʋ́n kugyíkʋá olonu. Ɔbɛ́bláa mlɩ mʋ́á ɩbɛ́ba ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɔŋɛ́ ámʋ ɔbɔ́wa mɩ́ numnyam, tsúfɛ́ ɔbɛ́bláa mlɩ asʋ́n ánɩ́ ntɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tógyítɔ́á mɩ́ Sɩ́ bʋ́ʋ a, mɩ́ bʋ́. Mʋ́ sʋ nabláa mlɩ mbɛ́ɛ, Ɔŋɛ́ ámʋ ɔbɛ́bláa mlɩ asʋ́n ánɩ́ ntɛblɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ɩlasí kpalobí mlɩmɛ́ɛtrá wun mɩ, támɛ ɩmɔ́ɔwa ɔpá kʋkʋ mlɛ́lawun mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Akasɩ́pʋ́ amʋtɔ akʋ bɛfɩtɛ́ aba bɛɛ, “Ngya ntɔ asʋ́n nɩ́? Ɔbɛ́ɛ, Ɩlasí kpalobí, anɩmɛ́ɛtrá wun mʋ, támɛ ɩmɔ́ɔwa ɔpá kʋkʋ, abɛ́lawun mʋ. Ɔdɛblɩ́ ɛ́ ɔbɛ́ɛ, ‘Nɔyɔ́ mɩ́ Sɩ́ wá?’ ");
INSERT INTO nkoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Ɩlasí kpalobí’ ánfɩ asɩ mɛ́? Anɩmɛ́dɛ́ asʋ́n ánfɩ ɔdɛblɩ́ ánfɩ asɩ nu.” ");
INSERT INTO nkoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu lɛ́bɩ ánɩ́ akasɩ́pʋ́ amʋ bʋdeklé abʋfɩtɛ mʋ asʋ́n ámʋtɔ. Mʋ́ sʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Blɩ́ ndɛblɩ́ mbɛ́ɛ, ɩlasí kpalobí mlɩmɛ́ɛtrá wun mɩ. Támɛ ɩmɔ́ɔwa ɔpa kʋkʋ mlɛ́lawun mɩ. Ɩ́nɩ mlɩdɛ́ aba fɩtɛ́ nɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ɔnɔkwalɩ ndɛ mlɩ bláa. Mlósu kpisíi, támɛ ɔyɩ́tɔ́ ahá mʋ́ bénya ansigyí. Mlégyi awɩrɛhɔ, támɛ mlɩ awɩrɛhɔgyí amʋ ɩbɛ́ba bemlí ansigyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nɩ́ ɩkwɩ́ɩ dɛ ɔtsɩ dwiín á, ahʋmɩtɩ tɛkɩ́tá mʋ, tsúfɛ́ mʋ ɩwɩɔsɩn wúunbɩ lafʋn. Támɛ onyákwɩ́ɩ́ tá pɛ́ ɔtɛtan mʋ ɩwɩɔsɩn ámʋsʋ, tsúfɛ́ ansɩ́ dɛ mʋ gyí ánɩ́ makwɩ́ɩ́ obí wá ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Alɩ kɛ́n igyi há mlɩ nɩ́. Ahʋmɩtɩ dɛ mlɩ séi, támɛ nɛ́lawun mlɩ. Mʋ́ sʋ mlɛ́hɩɛ nyá ansigyí ánɩ́ ɔhaa mɛ́ɛtalɩ́ ká mlɩ itin. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Alɩ ɛkɛ ámʋ a, mlɩmɛ́ɛtrá kʋlɩ́ mɩ́ tɔtɔɔtɔ. Ɔnɔkwalɩ ndɛ mlɩ bláa. Tógyítɔ́á mlɔ́kʋlɩ́ mɩ́ Sɩ́ mɩ́ ɩdátɔ́ a, ɔbɛ́ha mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bɔtʋ ndɛ mlɩmɔ́kʋ́fɩ́tɛ́ tɔtɔɔtɔ mɩ́ ɩdátɔ́. Mlɩfɩtɛ, ɔbɛ́ha mlɩ, mɛ́nɩ ɩbɛ́hɩɛ wá mlɩ ansigyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ndɛ mlɩ asʋ́n ánfɩ bláa ayébisʋ, támɛ brɛ́ kʋ bɛ́ba, mmɛ́ɛtrá tɔɩ́ ayébisʋ. Nówuná kpa mɩ́ Sɩ́ asʋ́n tati súná mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tsú brɛ́ ámʋsʋ pʋ́ya a, mlɔ́kʋlɩ́ mɩ́ Sɩ́ ámʋ atɔ́ mɩ́ ɩdátɔ́. Mmɛdɛ́blɩ́ mbɛ́ɛ, mɩ́ ɔbɔ́kʋlɩ́ mʋ atɔ́ há mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tsúfɛ́ mɩ́ Sɩ́ ámʋ onutó tɔdwɛ́ mlɩ. Ɔtɔdwɛ́ mlɩ, tsúfɛ́ mlɩtɔdwɛ́ mɩ́, mlɩlahogyi ánɩ́ notsú mʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mɩ́ Sɩ́ wá notsu ba ɔyɩ́tɔ́. Séi á, ndeyinkí tsú ɔyɩ́tɔ́ nɔyɔ́ mɩ́ Sɩ́ ámʋ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɩnʋ akasɩ́pʋ́ amʋ bɛbláa mʋ bɛɛ, “Ɛhɛ́ɛn! Séi mʋ́ á, fʋtráa fʋmɛdɛ́tɔɩ́ ayébisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Séi mʋ́ anɩlabɩ́ ánɩ́ fʋyin tógyítɔ́. Mʋ́ sʋ mehián ánɩ́ ɔhaa ɔbɛ́trá fɩtɛ́ fʋ́ asʋansʋ. Ɩ́nɩ lahá anɩlahogyi ánɩ́ lɛ́lɛ́ fotsú Bulu wá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Séi mʋ́ mlɩlahogyi? ");
INSERT INTO nkoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Brɛ́ kʋ ɩbá. Ɩlafʋn ta, mlɛ́dasáɩ́n. Mlɩtɔ okugyíɔkʋ ɔbɔ́yɔ mʋ otsukpá sí mɩ́. Támɛ iméesi mɩ́ nkʋlɛ, tsúfɛ́ mɩ́ Sɩ́ ámʋ bʋ mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nabláa mlɩ asʋ́n ánfɩ fɛ́ɛ́, mɛ́nɩ mlɔ́tsʋn mɩsʋ nyá iwilwii. Mlówun ɩwɩɔsɩn ɔyɩ́ ánfɩtɔ, támɛ mlɩwa klʋn, tsúfɛ́ nagyi ɔyɩ́sʋ́ dodo!” ");
INSERT INTO nkoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu lɛ́blɩ́ asʋ́n ánfɩ tá, olotsu ansɩ́ fʋ́á kɩ ɔsʋ́sʋ́ bɔ́ mpáɩ ɔbɛ́ɛ, “Óo mɩ́ Sɩ́, brɛ́ lafʋn. Wa mɩ́ numnyam, mɛ́nɩ mɩ́ ɛ́ nɔ́wa fʋ́ numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tsúfɛ́ fɛha mɩ́ túmi ahá fɛ́ɛ́sʋ́, ánɩ́ nháa ahá ánɩ́ fɛha mɩ́ fɛ́ɛ́ nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nkpa ánɩ́ ɩtamatá ámʋ gyí, bʋbɩ́ɩ fʋ́ Bulu Ɔnɔkwalɩpʋ ɔkʋkʋ́nʋ́ ɔkʋlɛ pɛ́ ánfɩ, abʋbɩ mɩ́ Yesu Kristo anfɩ fɔpʋsɩ́sɩ́ ɔyɩ́tɔ́ ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nawá fʋ́ numnyam ɔsʋlʋ́ʋ anfɩsʋ, tsúfɛ́ namɔ́ agyʋ́má ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋ fɛ́ɛ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mɩ́ Sɩ́! Wa mɩ́ numnyam fʋ́ ansɩ́tɔ́ ngya, fɛ́ alɩ ámʋ́ʋ́ mbʋ mʋ́ fʋ́ wá yáɩ́ asa fɔbwɛ ɔyɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nalɛ́ fʋ́ súná ahá ámʋ́ʋ́ fɛlɛ ɔyɩ́tɔ́ há mɩ́ ámʋ. Fʋ́bʋ́ amʋ́, fɔpʋ amʋ́ há mɩ́, bagyi fʋ́ asʋ́nsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Séi babɩ́ ánɩ́ tógyítɔ́á mbʋ itsú fʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tsúfɛ́ nabláa amʋ́ asʋ́n ánɩ́ fɔpʋhá mɩ́ fɛ́ɛ́, banú. Babɩ́ ánɩ́ lɛ́lɛ́ fʋ́ wá notsú, bahogyi ánɩ́ fʋ́lɔ́wa mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ndɛ fʋ́ kokóli ha amʋ́. Megyí ɔyɩ́tɔ́ ahá fɛ́ɛ́ ndɛ mpáɩ bɔ há. Mboún ahá ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋ, tsúfɛ́ fʋ́bʋ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɩ́ klɛ́ igyi fʋ́ klɛ́, fʋ́ klɛ́ ɛ́ igyi mɩ́ klɛ́. Fatsʋn amʋ́sʋ́ lɛ́ mɩ́ numnyam ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nɛbá fʋ́ wá séi. Mmɛ́ɛtrá tsiá ɔyɩ́tɔ́, támɛ amʋ́ mʋ́ bʋbʋ ɔyɩ́tɔ́. Mɩ́ Sɩ́ Wankɩ́hɛ́, pʋ fʋ́ ɩdá ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋ túmi kɩ amʋ́sʋ́, mɛ́nɩ bɔ́bwɛ kʋlɛ fɛ́ alɩ ámʋ́ʋ́ mɩ́a fʋnyɔ anɩgyí kʋlɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Brɛ́á mbʋ amʋ́ wá á, nɛkɩtá amʋ́ wankláán, ɩdá ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋ túmitɔ. Nɛlɛ ansɩ́ kɩ́tá amʋ́ wankláán. Mmɛha amʋ́tɔ́ ɔkʋkʋ mɔ́fwɩ, dʋn ɔmʋamʋ́ʋ́ ɩda yaɩ́ ánɩ́ ɔbɛ́hɩ ámʋ, fɛ́kɩ Bulu asʋn wanlɩ́nhɛ́ amʋ ɩbɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nɛbá fʋ́ wá séi. Támɛ brɛ́ ánfɩ ntráa mbʋ ɔyɩ́tɔ́ nfɩ ndɛ asʋ́n ánfɩ blɩ́, mɛ́nɩ bénya ansigyí fɛ́ alɩ ámʋ́ʋ́ mɩ́ ɛ́ mbʋ ansigyítɔ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nabláa amʋ́ asʋ́n ámʋ́ʋ́ fɛbláa mɩ ámʋ. Mʋ́ sʋ ɔyɩ́tɔ́ ahá bʋdɛ amʋ́ lu, tsúfɛ́ bʋtráa bʋmegyí ɔyɩ́tɔ́fɔ, fɛ́ alɩ ámʋ́ʋ́ mɩ́ ɛ́ mmegyí ɔyɩ́tɔ́yín amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mmɛdɛ́blɩ́ mbɛ́ɛ, fʋlɛ́ɛ amʋ́ lɛ ɔyɩ́tɔ́. Mboún mbɛ́ɛ fʋkɩ́ɩ amʋ́sʋ́ wankláán, mɛ́nɩ bʋmóowie lalahɛ ɔbwɛpʋ́ ámʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Alɩ ámʋ́ʋ́ mmegyí ɔyɩ́tɔ́yín ngyi ámʋ a, alɩ́ amʋ́ ɛ́ bʋmegyí ɔyɩ́tɔ́fɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Fʋ́ asʋ́n ámʋ gyí ɔnɔkwalɩ. Tsʋn mʋ́sʋ́ afʋpʋ amʋ́ bwɛ fʋ́ klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Alɩ ámʋ́ʋ́ fɔwa mɩ́ sɩ́sɩ́ ɔyɩ́tɔ́ ámʋ a, alɩ́ mɩ́ ɛ́ nawá amʋ́ sɩ́sɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amʋ́ sʋ nɔpʋ ɩwɩ há fʋ́, mɛ́nɩ amʋ́ ɛ́ bɔ́tsʋn ɔnɔkwalɩ amʋsʋ mlí fʋ́ klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Megyí mɩ́ akasɩ́pʋ́ amʋ nkʋlɛ ndɛ mpáɩ bɔ há. Mboún ahá ánɩ́ bɔ́tsʋn amʋ́ atosunáhɛ́sʋ hɔ mɩ gyi fɛ́ɛ́ ndɛbɔ há. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ndɛ mpáɩ bɔ mbɛ́ɛ, amʋ́ fɛ́ɛ́ bʋbwɛ́ɛ kʋlɛ. Mɩ́ Sɩ́, alɩ ámʋ́ʋ́ fʋbʋ mɩtɔ, mɩ́ ɛ́ mbʋ fʋtɔ ámʋ a, ha amʋ́ ɛ́ abʋtsia anɩtɔ alɩ kɛ́n, fówun ɔyɩ́tɔ́ ahá bóhogyi ánɩ́ fʋ́lɔ́wa mɩ́ sɩ́sɩ́ ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nawá ahá ánfɩ numnyam amʋ́ʋ́ fɔwa mɩ́ ámʋ, mɛ́nɩ bɔ́bwɛ kʋlɛ fɛ́ alɩá ntsu tamatsʋn mɩ́á fʋnyɔ nsɩnɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mbʋ amʋ́tɔ́ fɛ́ alɩá fʋbʋ mɩtɔ, mɛ́nɩ bɔ́bwɛ kʋlɛ, ntsu mɔ́ɔtsʋn amʋ́ nsɩnɛ́. Nɩ́ ɩbá alɩ á, ɔyɩ́tɔ́ ahá bɛ́bɩ ánɩ́ fʋ́lɔ́wa mɩ́, fʋtɔdwɛ́ amʋ́ fɛ́ alɩ ámʋ́ʋ́ fʋtɔdwɛ́ mɩ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mɩ́ Sɩ́! Ndeklé mbɛ́ɛ ahá ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋ bétsiá mɩ́ wá ɔtɩ́nɛ́ ámʋ́ʋ́ mbʋ amʋ. Fówun bówun numnyam amʋ́ʋ́ fɔwa mɩ́ ámʋ. Tsúfɛ́ fʋtɔdwɛ́ mɩ́ asa fɔbwɛ ɔyɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mɩ́ Sɩ́ Yilé ɔbwɛpʋ́! Ɔyɩ́tɔ́fɔ bʋmɛbɩ fʋ́, támɛ mɩ́ mʋ nyin fʋ. Ahá ánfɩ ɛ́ bʋyin ánɩ́ fʋ́lɔ́wa mɩ́ sɩ́sɩ́ ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɛlɛ fʋ́ súná amʋ́. Nɛ́trá lɛ fʋ́ súná amʋ́. Fówun ɔdwɛ ámʋ́ʋ́ fʋtɔdwɛ́ mɩ́ ámʋ itsia amʋ́tɔ́, mɛ́nɩ mɩ́ ɛ́ nétsiá amʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu lɔ́bɔ mpáɩ ánfɩ tá á, mʋa mʋ akasɩ́pʋ́ amʋ bɛnatɩ́ yɔ́tsʋn Kidron tsonkolitɔ wíé ndobíi kʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda amʋ́ʋ́ ɔlɛlɛ Yesu há ámʋ ɛ́ yin ndobíi amʋtɔ, tsúfɛ́ Yesu mʋa mʋ akasɩ́pʋ́ bʋtetsíá yéfia ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mʋ́ sʋ Yuda lɛ́kpa Romafɔ ɩsá akɔpʋ́ pʋ́ Bulu ɔtswɛ́kpa agyópʋ akʋá Bulu igyí ahapʋ́ dɛhɛn pʋ́ Farisifɔ bɔwa, bɔyɔ ɩnʋ. Bʋdɛ mbia, nkandɩ́ɛ pʋ́ akɔtɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ɩ́nɩá Yesu yin tɔ́á ɩbá mʋsʋ sʋ á, ɔlɛdalɩ fia amʋ́, fɩ́tɛ́ amʋ́ ɔbɛ́ɛ, “Ma mlɩdédunká?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Yesu Nasaretyin amʋ.” Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ nɩ́.” (Yuda amʋ́ʋ́ ɔdɛ mʋ lɛ há ámʋ ɛ́ lɩ́ɩ́ amʋ́ wá ɩnʋ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Brɛ́á Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ nɩ́!” á, bɛsankí yɛ́dɩda lalá kpla. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu lɛ́lafɩ́tɛ́ amʋ́ ɔbɛ́ɛ, “Mbɛ́ɛ, ma mlɩdédunká?” Bɛbláa mʋ bɛɛ, “Yesu Nasaretyin amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nakʋ́ bláa mlɩ mbɛ́ɛ, mɩ́ nɩ́. Mʋ́ sʋ nɩ́ mɩ́ mlɩdédunká mʋ́ á, mlɩha ahá ánfɩ abʋnatɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ɔlɛbláa amʋ́ alɩ, mɛ́nɩ asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ ámʋ ɩbɛ́ba mʋ́tɔ́. Ɔbɛ́ɛ, “Ahá ámʋ́ʋ́ fɔpʋhá mɩ́ ámʋtɔ ɔkʋkʋ mɔ́fwɩ.”) ");
INSERT INTO nkoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ɩnʋ á, Simon Petro dɛ́ ɔdayí ɩya anyɔ, ɔlɛbɩtɩ́ mʋ́ lɛ́, kpá Bulu igyí ɔhapʋ́ dɛhɛn osúmpʋ́ gyɔpɩ ɩsʋ. Osúmpʋ́ amʋ ɩdá gyí Malkus. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu lɛ́bláa Petro ɔbɛ́ɛ, “Sankia fʋ́ ɔdayí wa mʋ́ ɔflɛtɔ! Imehián ánɩ́ nówun ɩwɩɔsɩn ánɩ́ mɩ́ Sɩ́ lahá mɩ́ ɔbɛ́ɛ nwúun lóó?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɩnʋ ɩsá akɔpʋ́ ámʋ, amʋ́ ɔhandɛ pʋ́ Bulu ɔtswɛ́kpa agyópʋ amʋ bɛkɩtá Yesu, klɩ́ mʋ ɩbɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Begyankpá kpá mʋ ya Kaiafa mʋ sia Hana. Kaiafa gyí Bulu igyí ɔhapʋ́ dɛhɛn ofí ámʋtɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mʋlɛ́bláa Yudafɔ ahandɛ amʋ ɔbɛ́ɛ, ɩbʋ alɛ́á ɔbakʋ́lɛ obówu ahá fɛ́ɛ́ nwunsʋ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petro mʋa ɔkasɩ́pʋ́ bambá bobuo Yesu. Bulu igyí ɔhapʋ́ dɛhɛn amʋ yin ɔkasɩ́pʋ́ bámbá ánfɩ wankláán. Mʋ́ sʋ olobuo Yesu bítíwíé Bulu igyí ɔhapʋ́ dɛhɛn amʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Támɛ Petro mʋ́ lési ɔlɩɩ́ wóyí ámʋ ɔnɔ́. Ɔkasɩ́pʋ́ bámbá ánfɩ óyin Bulu igyí ɔhapʋ́ dɛhɛn anfɩ lɛ́dalɩ yɛ́bláa otsibi ɔkʋá ɔdɛ wóyí ámʋ ɔnɔ́ gyo, ɔlɛkpa Petro ba wóyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Otsibi amʋ lɛ́fɩtɛ́ Petro ɔbɛ́ɛ, “Megyí oyin ámʋ akasɩ́pʋ́ amʋtɔ ɔkʋ fʋ́gyi?” Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɛkɛkɛɛkɛ. Mma amʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Atsalɩ bʋ ɩnʋ. Mʋ́ sʋ asúmpʋ́ pʋ́ agyópʋ amʋ bɔdʋdá ogyá, bʋlɩɩ́ mʋ́ asɩ. Petro ɛ́ lɛ́yɛlɩɩ́ amʋ́ wá, ɔdɛ ogyá ámʋ núu. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́fɩtɛ́ Yesu asʋ́n, tsú mʋ akasɩ́pʋ́ pʋ́ mʋ́ atosunáhɛ́ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ahá ansɩ́tɔ́ nɛlɩɩ́ blɩ́ mɩ́ asʋ́n fɛ́ɛ́. Netsiá súná atɔ́ Yudafɔ ofíakpa pʋ́ Bulu ɔtswɛ́kpa, ɔtɩ́nɛ́á ahá fɛ́ɛ́ bʋtefia. Mmɛblɩ́ asʋansʋ ŋáintɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ntogyi sʋ́ fʋ́dɛ mɩ́ asʋ́n ánfɩ fɩtɛ́. Fɩtɛ ahá ánɩ́ bonu asʋ́n ánɩ́ nɛblɩ́. Amʋ́ yín asʋ́n ánɩ́ nɛblɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Brɛ́á Yesu lɛ́blɩ́ asʋ́n ánfɩ á, ɩnʋ agyópʋ amʋtɔ ɔkʋlɛá ɔlɩɩ́ mantáa mʋ lɛ́da mʋ ɩsʋtɔ, fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Alɩ́ fɛ́lɛ Bulu igyí ɔhapʋ́ dɛhɛn asʋ́n ɔnɔ́ nɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Nɩ́ nablɩ́ asʋkpan á, lɛ mʋ́ blɩ́ ɔhagyíɔha onu. Támɛ nɩ́ ɔnɔkwalɩ nablɩ́ á, ntogyi sʋ fʋ́dɛ mɩ́ da?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesu trá ɔda ɔfɛ́tɔ́ ɔhandɛ Hana lɔ́pʋ mʋ sɩ́sɩ́ Bulu igyí ɔhapʋ́ dɛhɛn Kaiafa. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petro trá ɔlɩɩ́ ogyá ámʋ asɩ, ɔkʋ lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Megyí oyin ánfɩ akasɩ́pʋ́ amʋtɔ ɔkʋlɛ fʋgyi?” Petro lɔ́swɩɩ́ ɔbɛ́ɛ, “Ɛkɛkɛɛkɛ. Mma amʋ́tɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bulu igyí ɔhapʋ́ dɛhɛn amʋ osúmpʋ́ ɔkʋ, ogyi ɔhá ámʋ́ʋ́ Petro lɛ́kpa mʋ ɩsʋ kʋlɛ amʋ mʋ pio lɛ́fɩtɛ́ Petro ɔbɛ́ɛ, “Megyí fʋ́a mʋnyɔ nowun ndobíi amʋtɔ nɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro lɛ́trá swɩɩ́ pʋ́ ɩbɩ wá ogyá. Ɩnʋnʋ batɛ lɔ́bɔn. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɔyɩ kɛhɛ bakɛ-bakɛ a, bɛkpa Yesu tsú Kaiafa wóyítɔ́ ya Roma ɔhandɛ ánɩ́ ɔdɛ Yudea ɔmásʋ́ gyí wóyítɔ́. Yudafɔ ahandɛ amʋ bʋmedékléá bɔ́pʋ ifin da ɩwɩ. Mʋ́ sʋ bʋmebitíwíé wóyítɔ́ ɩnʋ. Tsúfɛ́ bʋdekléá bɛ́kɩ ánɩ́ amʋ́ ɩwɩ lɛtɩn, mɛ́nɩ bɛ́talɩ́ gyi Israelfɔsʋ Katsʋn Nkɛ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mʋ́ alɩ sʋ Pilato lɛ́dalɩ ba kpankpá bɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Amansʋ mlɩbʋ blɩ́ tsú oyin ánfɩ ɩwɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bɛbláa mʋ bɛɛ, “Nɩ́ ɔhá ánfɩ mɔ́kʋ́bwɛ́ lakpan á, tɛkɩ anɩmɛ́kpa mʋ ba fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ́mʋ́ mlɩkpa mʋ ya, amlɩyegyi mʋ asʋ́n mlɩ mbla ɔnɔ́.” Yudafɔ ahandɛ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩmá ɔkpa mɔ́ ɔha.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Asʋ́n ánfɩ lɛ́ba mʋ́tɔ́, mɛ́nɩ asʋ́n ámʋ́ʋ́ Yesu lɛ́blɩ́ tsú mʋ lowu ánɩ́ obówu ɩwɩ ámʋ ɩbɛ́ba mʋ́tɔ́.) ");
INSERT INTO nkoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɩnʋ Pilato léyinkí wíé wóyítɔ́. Mʋ́ʋ́ ɔlɛtɩ Yesu, fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Fʋ́gyí Yudafɔ owíe amʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Fʋ́ onutó asʋn fɩtɛ́hɛ́ igyi, ntɛ́ɛ akʋ lábláa fʋ mɩ́ ɩwɩ asʋ́n?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Yudayin ngyi? Fʋ́ onutó ahá pʋ́ Bulu igyí ahapʋ́ dɛhɛn lɛ́kpa fʋ́ ba mɩ. Ntɔ fabwɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Megyí ɔyɩ́ ánfɩtɔ ndɛ iwíe gyí. Nɩ́ ɔyɩ́ ánfɩtɔ á, tɛkɩ mɩ́ abúopʋ bɔ́kɔ hɔ mɩ. Bʋmɛ́ɛha bʋmɔ́ɔpʋ mɩ́ wá Yudafɔ ahandɛ ɩbɩtɔ, támɛ megyí ɔyɩ́ ánfɩtɔ ndɛ iwíe gyí!” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Mʋ́mʋ́ yɛ́ɛ owíe fʋgyi á?” Yesu lɛ́lɛ́ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ɔnɔkwalɩ fablɩ́ fɛɛ Owíe ngyi. Mɩ́ á, bɔkwɩɩ́ mɩ́ nɛba ɔyɩ́ ánfɩtɔ ánɩ́ mbá ambegyi ɔnɔkwalɩ amʋ ɩwɩ adánsɩɛ. Ɔhagyíɔha ánɩ́ ogyi Ɔnɔkwalɩ amʋ klɛ́ tɛyaa asʋ nú mɩ́ ɔmɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntɔ gyí ɔnɔkwalɩ amʋ?” Pilato lɛ́blɩ́ asʋ́n ánfɩ tá á, ɔlɛtrá dalɩ yɔ Yudafɔ ámʋ wá wóyí ɔnɔ́ ɩnʋ. Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mmɔkʋ́wun lalahɛ kʋkʋʋkʋá nɔ́pʋhá oyin ánfɩ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Támɛ mlɩ amándɩ́ɛ́ ɔnɔ́ á, ntesí obu ɔdɩpʋ́ ɔkʋlɛ há mlɩ Katsʋn Nkɛ kugyíkʋtɔ. Mlɩdéklé mlɩaa, nsíi Yudafɔ Owíe anfɩ ha mlɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bɔkplʋ́n lɛ mʋ́ ɔnɔ́ bɛɛ, “Ɛkɛkɛɛkɛ! Megyí mʋ. Si Baraba ha anɩ.” (Ogyo otswapʋ́ Baraba ɛ́ gyí). ");
INSERT INTO nkoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɩnʋ Pilato lɛ́ha bɛkpa Yesu ya, yɛ́pɩtɩ́ mʋ atɔ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɩsá akɔpʋ́ ámʋ bɔlʋ obungyo-awu, bwɛ́ mʋ́ owíepa bun mʋ nwun, bɔwa mʋ ligá pɛpɛ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɩnʋ bɛnatɩ́ bwɛ́ mʋ ahinlá bɛɛ, “Yudafɔ Owíe, fʋ́ nkpasʋ ɔnlɩnsʋ!” Fówun badá mʋ ɩsʋtɔ kpa. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato lɛ́trá dalɩ yɔ wóyí ɔnɔ́ ɩnʋ yɛ́bláa amʋ́ ɔbɛ́ɛ, “Nakpá mʋ nɛba mlɩ, amlɩwun ánɩ́ mmɔkʋ́wun lalahɛ kʋkʋ mʋ ɩwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Brɛ́á Yesu lɛ́dalɩ ba a, obungyo-awu ɩpa ámʋ bun mʋ nwun, ɔlɔwa ligá pɛpɛ amʋ. Pilato lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ nɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bulu igyí ahapʋ́ dɛhɛn pʋ́ Bulu ɔtswɛ́kpa agyópʋ amʋ benya wun mʋ pɛ́, bɔsʋrá okitikíti blɩ́ bɛɛ, “Da mʋ manta oyikpalíhɛsʋ! Da mʋ manta oyikpalíhɛsʋ!” Pilato lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩ onutó mlɩkpa mʋ ya, amlɩyɛda mʋ manta oyikpalíhɛsʋ. Mɩ́ mʋ́ mmɔkʋ́wun lalahɛ kʋkʋ mʋ ɩwɩá nɔ́pʋhá mʋ ɩpɔ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yudafɔ ámʋ bɛbláa mʋ bɛɛ, “Anɩ mbla ɔnɔ́ á, ilehián ánɩ́ obówu. Tsúfɛ́ ɔlɛblɩ́ ɔbɛ́ɛ, Bulu mʋ Bi mʋgyi.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Brɛ́á Pilato lónu asʋ́n ánfɩ á, ifú lɛ́trá kɩtá mʋ tsɩ́a mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oleyinkí yɔ́ mʋ wóyítɔ́ yɛ́fɩtɛ́ Yesu ɔbɛ́ɛ, “Nkʋ́nʋ́ fotsú?” Támɛ Yesu mɛ́kpla mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mʋ́ sʋ Pilato lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋmɛ́ɛkplá mɩ́? Fʋmeyín ánɩ́ mbʋ túmiá nɛ́talɩ́ sí fʋ́ ntɛ́ɛ nɛ́talɩ́ há bɛda fʋ́ mántá oyikpalíhɛsʋ mɔ́ fʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ megyí Bulu lɛ́ha fʋ́ ɔkpa á, tɛkɩ fʋma túmi kʋkʋ mɩ́sʋ́. Ɩ́nɩ sʋ ɔhá ámʋ́ʋ́ ɔlɔpʋ mɩ́ wá fʋ́ ɩbɩtɔ ámʋ lakpan dʋn fʋ́ klɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato lónu asʋ́n ánfɩ á, olekle osi Yesu. Támɛ Yudafɔ ámʋ bɔsʋrá okitikíti kʋ́klʋ́kʋ́ʋ́ blɩ́ bɛɛ, “Nɩ́ fesi ɔhá ánfɩ á, mʋ́mʋ́ megyí Roma owíe dɛhɛn mʋ nyawie fʋgyi. Tsúfɛ́ ɔhagyíɔha ánɩ́ ɔblɩ́ ɔbɛ́ɛ owíe mʋgyi á, alakʋ́sʋ́ lɩ́ɩ́ Roma owíe dɛhɛnsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Brɛ́á Pilato lónu asʋ́n ánfɩ á, ɔlɛkpa Yesu dálɩ ba kpankpá, tsíá mʋ asʋ́ngyí obíá ánɩ́ itsie ɔtɩnɛkʋá bɔpʋ abwi bwɛ́ ɩnʋ, bʋtɛtɩ́ ɩnʋ “Abwitɔ” sʋ. (Bʋtɛtɩ́ ɩnʋ “Gabata” Hebri ɔblɩ́tɔ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ɛkɛ ámʋ igyi ogyá ɔdʋdákɛ́ há Israelfɔsʋ Katsʋn Nkɛ. Ɩbɔ́bwɛ fɛ́ ɔpa dódúanyɔtɔ á, Pilato lɛ́bláa Yudafɔ ámʋ ɔbɛ́ɛ, “Mlɩ Owíe amʋ nɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bɔsʋrá okitikíti bɛɛ, “Kpa mʋ ya, kpa mʋ ya, afʋyɛda mʋ manta oyikpalíhɛsʋ.” Pilato lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Ndáa mlɩ owíe manta oyikpalíhɛsʋ?” Bulu igyí ahapʋ́ dɛhɛn amʋ bɛbláa mʋ bɛɛ, “Anɩmá owíe ɔkʋkʋ dʋn Roma owíe dɛhɛn!” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ɩnʋ Pilato lési Yesu há amʋ́ ɔbɛ́ɛ bʋyɛ́da mʋ manta oyikpalíhɛsʋ. Ɩsá akɔpʋ́ ámʋ bɛkpa Yesu nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mʋ onutó olotsu mʋ oyikpalíhɛ dɩ́nká mʋ nkanta alɩɩ yéwie ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ “Nwun Okokobi Otsiákpá.” (Bʋtɛtɩ́ ɩnʋ “Golgota” Hebri ɔblɩ́tɔ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bɛda Yesu mántá oyikpalíhɛsʋ ɩnʋ, bɛda ayin abanyɔ́ akʋ ɛ́ mántá nyikpalíhɛsʋ mʋ wá ɩnʋ. Ɔkʋlɛ bʋ Yesu bɩnasʋ, ɔkʋlɛ ɛ́ bʋ mʋ gyɔpɩsʋ, Yesu bʋ amʋ́ nsɩnɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato lɔ́wanlɩ́n asʋ́n mántá oyikpalíhɛ amʋ awunso. Asʋ́n ámʋ gyí, “Yesu Nasaretyin, Yudafɔ Owíe.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yudafɔ tsɔtsɔɔtsɔ bɛkla asʋn wanlɩ́nhɛ́ anfɩ. Tsúfɛ́ ɔtɩ́nɛ́ ámʋ́ʋ́ bɛda Yesu mántá oyikpalíhɛsʋ ámʋ ɩbʋ mantáa Yerusalem. Ɔlɛha bɔwanlɩ́n asʋ́n ámʋ Hebri ɔblɩ́ɩ, Roma ɔblɩ́ɩ pʋ́ Griiki ɔblɩ́tɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bulu igyí ahapʋ́ dɛhɛn amʋ bɛbláa Pilato bɛɛ, “Máwanlɩ́n fɛɛ, ‘Yudafɔ Owíe.’ Mboún wanlɩn fɛɛ, ‘Oyin ánfɩ ɔbɛ́ɛ, mɩ́gyí Yudafɔ Owíe.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mʋ́á nawánlɩ́n á, nawánlɩ́n mʋ́ dodo.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ɩsá akɔpʋ́ ámʋ bɛda Yesu mántá oyikpalíhɛ amʋsʋ tá á, botsu mʋ atadɩɛ, beye mʋ́tɔ́ aku ana. Okugyíɔkʋ klɛ́ kʋlɛ. Botsu mʋ ligá ánɩ́ bɔlʋ mʋ́ tsú ɔsʋ́sʋ́ beyi asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɩnʋ bɛbláa aba bɛɛ, “Mlɩmáha abalɩ atadɩɛ ánfɩ mʋ́tɔ́. Mlɩha atswɩ abi kɩ bɛɛ, ma obénya mʋ́.” Asʋ́n ánfɩ lɛ́ba, mɛ́nɩ Bulu asʋ́n ámʋ́ʋ́ bɔwanlɩ́n tswɩ bɛɛ, “Beye mɩ́ atadɩɛtɔ, bɔtswɩ abi mɩ́ ligásʋ́” amʋ ɩbɛ́ba mʋ́tɔ́. Ɩsá akɔpʋ́ ámʋ bɔbwɛ dɩ́nká mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu mʋ yin, mʋ yin mʋ pio tsɩ́hɛ́ Maria, ogyi Klopa mʋ ka pʋ́ Magdalayintse Maria bʋlɩɩ́ oyikpalíhɛ amʋ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Brɛ́á Yesu lówun mʋ yin pʋ́ mʋ ɔkasɩ́pʋ́ ámʋ́ʋ́ ɔtɛhɩ́ɛ́ dwɛ́ ámʋ, bʋlɩɩ́ mantáa ɩnʋ á, ɔlɛbláa mʋ yin ɔbɛ́ɛ, “Amʋ́ yín, fʋ́ bí nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mʋ́ʋ́ ɔlɛbláa ɔkasɩ́pʋ́ amʋ ɛ́ ɔbɛ́ɛ, “Fʋ́ yín nɩ́.” Tsú ɛkɛ ámʋ a, ɔkasɩ́pʋ́ amʋ lɛ́kpa mʋ ya mʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ɩ́nɩ ɔma a, Yesu lówun ánɩ́ mʋ agyʋ́má lamɔ́ ɔnɔ́. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Ɔmɛwʋ́lɩ dɛ mɩ́.” Ɩ́nɩ lɛha Bulu asʋ́n ámʋ́ʋ́ bɔwanlɩ́n tswɩ amʋ ɩlɛba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Onuwé kʋ tsie ɩnʋ, ntá ɔdáɩ ɩbɔ mʋ́. Ɩsá akɔpʋ́ ámʋ bɔpʋ ɔsapɔ dá ntá ámʋtɔ pʋ́síán oyísʋ́, tsú mʋ́ fʋ́á yétin mʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu lɛ́kpɩkpɩ́ɩ mʋ́ mɛ́. Ɩnʋ ɔlɛblɩ́ ɔbɛ́ɛ, “Ɩlatá!” Mʋ́ʋ́ oloko nwuntɔ wá, ɔlɛlɛ ɔŋɛ́ á. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ɛkɛ ámʋ igyi Fieda. Mʋ́ ɔyɩ kɛhɛ igyi ɔkpʋ́nʋ́ ɔdakɛ́ kpɔnkpɔntɩ há Yudafɔ. Mʋ́ sʋ bʋmekle ánɩ́ ahá ámʋ bʋsían nyikpalíhɛ amʋsʋ yɔ́fʋn owi tahɛ́. Mʋ́ sʋ bɔkʋlɩ́ Pilato ɔkpa bɛɛ ɔháa mʋ ɩsá akɔpʋ́ abʋyebiabía amʋ́ ayabi, mɛ́nɩ bɔ́kɔsɩ́ wú, fówun bɛ́lɛ amʋ́ tsu nyikpalíhɛ amʋsʋ asa owí ɔta. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mʋ́ sʋ bɔyɔ yébiabía ayin abanyɔ́ ámʋ ayabi. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Támɛ brɛ́á bowie Yesu wá á, bowun ánɩ́ alawú dodo. Mʋ́ sʋ bumebia mʋ ayabi. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Támɛ ɩsá akɔpʋ́ ámʋtɔ ɔkʋlɛ lɔ́pʋ mʋ pɩ́a wɔ Yesu abɩntɔ, ntsu mʋ́a obugya lɛfɛn dalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ɔhá ámʋ́ʋ́ olowun mʋ́ ámʋ légyi mʋ́ ɩwɩ adánsɩɛ, fówun mlɩ ɛ́ mlóhogyi. Megyí afunu igyi. Oyin ánɩ́ ɔnɔkwalɩ asʋ́n mʋdɛblɩ́.) ");
INSERT INTO nkoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɩ́nɩ fɛ́ɛ́ lɛ́ba mʋ́tɔ́, mɛ́nɩ Bulu asʋ́n ámʋ́ʋ́ bɔwanlɩ́n tswɩ bɛɛ, “Bʋméebia mʋ iwú kʋkʋʋkʋ” ámʋ ɩbɛ́ba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bulu asʋn wanlɩ́nhɛ́ amʋ kɛ́n lɛblɩ́ ɔbɛ́ɛ, “Bɛ́kɩ ɔhá ámʋ́ʋ́ bɔwɔ mʋ abɩntɔ pɩ́a ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɩ́nɩ fɛ́ɛ́ ɔma a, Arimateayin Yosef lɛ́ba bokokóli Pilato ɔbɛ́ɛ, ɔpʋ́ʋ Yesu fúli amʋ ha mʋ. (Yosef anfɩ buo Yesu ŋáintɔ, tsúfɛ́ ɔdɛ Yudafɔ ahandɛ amʋ ifú nya.) Pilato lɛ́ha mʋ ɔkpa. Mʋ́ sʋ Yosef lɛ́yɛlɛ Yesu fúli amʋ oyópulá. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo amʋ́ʋ́ ɔlɛba Yesu wá ɛkɛ ɔkʋ onyé ámʋ ɛ́ lɛ́ba. Ɔlɔpʋ afá fánfáánfán aku anyɔ ánɩ́ bɔkwɛ mʋ́ wá abatɔ tsɔtsɔɔtsɔ ba. Mʋ́ odwin bɔ́bwɛ kílo adʋasa (30). ");
INSERT INTO nkoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ayin ánfɩ bɔpʋ́ ɔhráda kɩ́klɩ afá ámʋ mántá fúli amʋ ɩwɩ fɛ́ alɩá Yudafɔ bʋtɔbwɛ́ amʋ́ afúli asa bʋtopúlá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ndobíi kʋ ɩbʋ mantáa ɔtɩ́nɛ́ ámʋ́ʋ́ bɛda Yesu mántá oyikpalíhɛsʋ ámʋ. Bolotí bʋtátɔ́ bwɛ́ mʋ́ fúli-ɔbɔ́ ɩnʋ. Bʋmɔkʋ́púlá ɔhaa mʋ́tɔ́ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɩ́nɩá ɛkɛ ámʋ igyi ogyá ɔdʋdákɛ́, fúli ɔbɔ́ ámʋ ɛ́ ɩbʋ mantáa ɩnʋ sʋ á, bopulá Yesu mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ndawɔ́tswɩ́tɔ́ ɛkɛ gyankpapʋ, igyi Kwasieda bakɛ-bakɛ, brɛ́á nsaɩntɔ mɔ́kʋ́tɩ́tɩ a, Magdalayintse Maria lɔ́yɔ Yesu opulákpá ɩnʋ. Olenya wíe ɩnʋ alɩ́ olowun ánɩ́ bamína ibwi ámʋ lɛ́ ɔbɔ́ ámʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mʋ́ sʋ oleyinkí srɩ́ ba ɔkasɩ́pʋ́ ámʋ́ʋ́ Yesu tɛhɩ́ɛ́ dwɛ́ mʋ amʋ mʋa Simon Petro wá, bɛbláa amʋ́ ɔbɛ́ɛ, “Balɛ́ Yesu ɔbɔ́ ámʋtɔ. Anɩméyín ɔtɩ́nɛ́á bapʋ́ mʋ yɔ́wa!” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mʋ́ʋ́ Petro mʋa mʋnyɔ bɔpʋ ɔkpa bɔyɔ́ opulákpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Amʋ́ abanyɔ́ ámʋ fɛ́ɛ́ betsií ɔsrɩ́ɩ, támɛ ɔlɛsrɩ́ sí Petro gyankpá yówie opulákpá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Brɛ́á olobun kɩ ntsán ámʋtɔ á, olowun ánɩ́ ɔhráda ámʋ kpán dá, támɛ omebitíwíé mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petro lɔ́bɔtʋ mʋ, ɔlɔtsʋn bítíwíé ntsán ámʋtɔ, olowun ɔhráda amʋ da. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Olowun ɔhráda ámʋ́ʋ́ bɔpʋtɔ́ mʋ nwun ámʋ ɛ́, ilokuntá ɩda ɩfʋ́ntɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɔkasɩ́pʋ́ amʋ́ʋ́ olegyankpá wíé ɩnʋ ámʋ ɛ́ lébitíwíé mʋ́tɔ́, wun ɔhráda ámʋ pʋ́ mʋ́ ámʋ́ʋ́ bɔpʋtɔ́ mʋ nwun ámʋ alɩ́ olohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Brɛ́ ámʋtɔ á, Bulu asʋn wanlɩ́nhɛ́ amʋ́ʋ́ ɩlɛblɩ́ ɔbɛ́ɛ, ilehián ánɩ́ Yesu ɔbɔ́kʋsʋ́ tsú afúlitɔ ámʋ mɔkʋ́nyá wánkɩ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Beyinkí yɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Támɛ Maria lési ɔlɩɩ́ opulákpá ɩnʋ odesú. Brɛ́á odesú a, olobun kɩ ɔbɔ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɩnʋ olowun Bulu-abɔpʋ abanyɔ́ ánɩ́ bɔwa atadɩɛ futútúútú, bʋtsie ɔtɩ́nɛ́ ámʋ́ʋ́ bɔpʋ Yesu fúli tswɩ amʋ. Ɔkʋlɛ tsie mʋ adɩanwun, ɔkʋlɛ tsie ayabiasɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bɛfɩtɛ́ mʋ bɛɛ, “Amʋ́ yín, nkálɩ igyi sʋ́ fʋdesú?” Ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Balɛ́ mɩ́ Wíe nátɩ́. Mmeyín ɔtɩ́nɛ́á bapʋ́ mʋ yɔ́tswɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɔlɛblɩ́ tá á, ɔlɛdamlí kɩ ɔma. Ɔkɩ a, Yesu lɩ́ɩ́ mʋ ɔma, támɛ ɔmɛbɩá Yesu nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Amʋ́ yín, nkálɩ ígyi sʋ́ fʋdesú? Ma fʋdedunká?” Mʋ mʋ́ ɔkɩ ánɩ́ ndobíi amʋtɔ agyʋ́má ɔyɔpʋ́ nɩ́. Mʋ́ sʋ ɔlɛbláa Yesu ɔbɛ́ɛ, “Anɩ sɩ́, nɩ́ fʋ́latsú mʋ yɔ́tswɩ ɔtɩnɛkʋ á, suna mɩ́, anyetsu mʋ natɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu lókpolí mʋ ɔbɛ́ɛ, “Maria.” Ɔlɛdamlí kɩ, kpólí Yesu Hebri ɔblɩ́tɔ ɔbɛ́ɛ, “Rabuni!” (Mʋ́ asɩ gyí, “Osunápʋ́.”) ");
INSERT INTO nkoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Mápʋ ɩbɩ da mɩ, tsúfɛ́ mmɔkʋ́nyá yɔ́ ɔsʋ́sʋ́ mɩ́ Sɩ́ wá. Mboún natɩ yɛbláa mɩ́ apíó ámʋ fɛɛ, nɔyɔ́ mɩ́ Sɩ́ ánɩ́ ogyi mlɩ Sɩ́ wá. Nɔyɔ́ mɩ́ Bulu ánɩ́ ogyi mlɩ Bulu wá.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdalayintse Maria lɛ́yɛbláa akasɩ́pʋ́ amʋ ɔbɛ́ɛ, “Nawun anɩ Wíe!” Ɔlɛbláa amʋ́ asʋ́n ánɩ́ Yesu lɛ́bláa mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kwasieda ámʋ ntʋ́pwɛsʋ á, akasɩ́pʋ́ amʋ befia. Befin obu wá ɩwɩ, tsúfɛ́ bʋdɛ Yudafɔ ahandɛ amʋ ifú nya. Ɩnʋ á, Yesu lɛ́bɛlɩɩ́ amʋ́ nsɩnɛ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɩwɩ ilwíi mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɔlɛbláa amʋ́ alɩ tá á, ɔlɔpʋ mʋ ɩbɩtɔ pʋ́ mʋ abɩntɔ súná amʋ́. Ansɩ́ légyi amʋ́, tsúfɛ́ bawun amʋ́ Wíe. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu lɛ́trá bláa amʋ́ ɔbɛ́ɛ, “Ɩwɩ ilwíi mlɩ. Alɩ ámʋ́ʋ́ mɩ́ Sɩ́ lawá mɩ́ ámʋ a, alɩ́ ndɛ mlɩ wa nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɩnʋ ɔlɔlʋn ɔŋɛ́ fʋ́ wʋ́lɩ́ amʋ́sʋ́, bláa amʋ́ ɔbɛ́ɛ, “Mlɩhɔ Ɔŋɛ Wankɩ́hɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɩ́ mlesí ahá lakpan kíé amʋ́ á, Bulu lasíkíé amʋ́. Támɛ nɩ́ mlɩmésikíé amʋ́ á, Bulu méesikíé amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Brɛ́á Yesu lɛ́ba a, amʋ́tɔ́ ɔkʋlɛá bʋtɛtɩ́ mʋ Toma, bʋtɛlátɩ́ mʋ Tabí má ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mʋ́ sʋ akasɩ́pʋ́ atráhɛ amʋ bɛbláa mʋ bɛɛ, “Anɩlawun anɩ Wíe!” Támɛ Toma lɛ́bláa amʋ́ ɔbɛ́ɛ, “Nɩ́ mmɔkʋ́wun mʋ ɩbɩtɔ ndatobi nlɔ ámʋ, kpíé osrebi wá mʋ́tɔ́, kpíé ɩbɩ wá mʋ abɩntɔ ɔlɔ ámʋtɔ á, mmóohogyi ɛkɛkɛɛkɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nkekwé ɔma a, akasɩ́pʋ́ amʋ bɛtrá fia obu ámʋtɔ. Alɩ ɛkɛ ámʋ mʋ́ á, Toma bʋ́ amʋ́tɔ́. Befin obu ámʋ, támɛ Yesu lɛ́bɛlɩɩ́ amʋ́ nsɩnɛ́, bláa amʋ́ ɔbɛ́ɛ, “Ɩwɩ ilwíi mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mʋ́ʋ́ ɔlɛbláa Toma ɔbɛ́ɛ, “Kɩ mɩ́ ɩbɩtɔ, kpie osrebi wa nfɩ. Kpie fʋ́ ɩbɩ wa mɩ́ abɩntɔ. Si nwɛ́ɛn gyí, afʋhogyi!” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ Wíé pʋ́ mɩ́ Bulu!” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Alɩ ámʋ́ʋ́ fawun mɩ ámʋ sʋ fahogyi lóó? Ansɩ́ bégyi ahá ámʋ́ʋ́ bʋmɔpʋ amʋ́ ansíbi wun, asa bohogyi amʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu lɛ́trá bwɛ osúna tsɔtsɔɔtsɔ mʋ akasɩ́pʋ́ amʋ ansɩ́tɔ́ ánɩ́ bʋmɔwanlɩ́n wá ɔwʋlʋ́ ánfɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Támɛ bawánlɩ́n ɩ́nɩ, mɛ́nɩ mlóhogyi ánɩ́ Yesu gyí Bulu mʋ Bi Kristo amʋ. Asʋ́n ánfɩsʋ hógyi ɔbɛ́ha mlénya nkpa ánɩ́ ɩtamatá mʋ ɩdátɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɩ́nɩ ɔma a, Yesu lɛ́trá lɛ ɩwɩ ɔwan súná mʋ akasɩ́pʋ́ Tiberia ɔpʋ ɔnɔ́ tsʋn ɔkpa ánfɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petro mʋa Toma ánɩ́ bʋtɛlátɩ́ mʋ Tabí, Nataniel, otsú Kana wúluá ɩbʋ Galilea ɔmátɔ́, Sebedeo abí ámʋ pʋ́ akasɩ́pʋ́ abanyɔ́ ɛ́ befia. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petro lɛ́kla amʋ́ ɔbɛ́ɛ, “Nɔyɔ́ ɔpʋsʋ yɛ́lɛ aye.” Bɛbláa mʋ bɛɛ, “Anɩ ɛ́ abóbuo fʋ yɔ́.” Ɩ́nɩ sʋ boyówie ɔklʋntɔ nátɩ́. Támɛ betsiá ntsusʋ onyé ámʋ fɛ́ɛ́, bʋmenya tɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Brɛ́á ɔyɩ́ ɩbá bɛkɛ a, bowun ɔkʋ lɩ́ɩ́ ɔpʋ amʋ ɔnɔ́. Bʋmɛbɩ ánɩ́ Yesu nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mʋ́ʋ́ Yesu lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mɩ́ anyawíe, mlɩménya tɔtɔ?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ee!” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩtswɩ asawu amʋ wa gyɔpɩsʋ fʋ́n, mlɛ́lɛ aye.” Mʋ́ sʋ bɔtswɩ wa ɩnʋ. Aye lɔbʋlá asawu amʋ, bʋmɛtalɩ́ bɩ́tɩ́ mʋ́ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mʋ́ʋ́ ɔkasɩ́pʋ́ amʋ́ʋ́ Yesu tɛhɩɛ́ dwɛ́ ámʋ lɛ́bláa Petro ɔbɛ́ɛ, “Anɩ Wíe Yesu nɩ!” Brɛ́á Petro lónu ánɩ́ anɩ Wíe Yesu nɩ á, olotsu mʋ atadɩɛ mla ɩwɩ. (Tsúfɛ́ ɔlɔwɔɩ́ mʋ atadɩɛ tswɩ), olotu wíé ntsu ámʋtɔ gyuaa, ɔdɛpɩtɩ́ ɔyɔ́ Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Támɛ akasɩ́pʋ́ atráhɛ amʋ́ʋ́ bʋbʋ ɔklʋntɔ ámʋ bɛbɩtɩ́a asawu amʋ́ʋ́ aklɛmɛtɩ́ bʋbɔ mʋ́ ámʋ ba otsubúnɔ, tsúfɛ́ bʋma ɩfɔ́ ɔpʋ ɔnɔ́ ɩnʋ. Mʋ́ ɩfɔ́tɔ́ bɔ́bwɛ fɛ́ ayabi lafasa (300). ");
INSERT INTO nkoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Brɛ́á bowie ɔpʋ ɔnɔ́ á, bowun ánɩ́ bawá agyawunu ogyá, bʋdɛ iye tɔ mʋ́sʋ́, bodobodo ɛ́ da mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mʋ́ʋ́ Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩlɛ aklɛmɛtɩ́ ámʋ́ʋ́ mlɩlalɛ́ ámʋ kʋ ba.” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mʋ́ sʋ Simon Petro léyinkí dʋ́ wíé ɔklʋn amʋtɔ, ɔlɛyɛ́bɩtɩ́a asawu amʋ́ʋ́ aklɛmɛtɩ́ akpɔnkpɔntɩ bʋbɔ mʋ́ ámʋ bɔtswɩ ɔpʋ ɔnɔ́. Aklɛmɛtɩ́ ámʋ bʋgyi lafakʋlɛ aduenu-sa (153). Ɩ́nɩá bʋtsɔ ó á, asawu amʋ mɛtɩtɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu lɛ́tɩ amʋ́ ɔbɛ́ɛ, “Mlɩbegyi atɔ́.” Amʋ́tɔ́ ɔkʋkʋ mɛ́talɩ́ wá klʋn fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Ma fʋgyi?” Tsúfɛ́ bɛbɩ ánɩ́ amʋ́ Wíe nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu lótsu bodobodo amʋ há amʋ́, olotsu aye amʋ ɛ́ há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bulu lɔ́kʋsʋ́a Yesu tsú afúlitɔ ɔma a, ɩ́nɩ gyí otse saasɩ ánɩ́ ɔlɛlɛ ɩwɩ ɔwan súná mʋ akasɩ́pʋ́ amʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Brɛ́á begyi nyankɩ atogyihɛ amʋ tá á, Yesu lɛ́fɩtɛ́ Simon Petro ɔbɛ́ɛ, “Yohane mʋ bi Simon, fʋtɔdwɛ́ mɩ́ dʋn fʋ́ aba ánfɩ lóó?” Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee, mɩ́ Wíé, fʋyin ánɩ́ ntɔdwɛ́ fʋ́.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Kɩ mɩ́ akúfabi amʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɔlɛtrá fɩtɛ́ Petro otse nyɔɔsɩ ɔbɛ́ɛ, “Yohane mʋ bi Simon, fʋtɔdwɛ́ mɩ́?” Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee, mɩ́ Wíe, fʋyin ánɩ́ ntɔdwɛ́ fʋ́.” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Kpa mɩ́ akúfa amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu lɛ́fɩtɛ́ mʋ otse saasɩ ɔbɛ́ɛ, “Yohane mʋ bi Simon, fʋtɔdwɛ́ mɩ́ lɛ́lɛ́?” Ɩlɛhan Petro, tsúfɛ́ otse saasɩ Yesu lafɩ́tɛ́ mʋ ɔbɛ́ɛ, “Fʋtɔdwɛ́ mɩ́?” á. Mʋ́ sʋ ɔlɛlɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ Wíé, fʋ́ onutó fʋyin tógyítɔ́. Yɛ́ɛ fʋyin ánɩ́ ntɛhɩ́ɛ́ dwɛ́ fʋ́!” Yesu lɛ́bláa mʋ ɔbɛ́ɛ, “Kɩ mɩ́ akúfa amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ɔnɔkwalɩ ndɛ mlɩ bláa. Brɛ́á fʋ́gyi ɔyasubi á, fʋ́ onutó fʋtɛtálɩ́ tsú fʋ́ atadɩɛ hɩ́hɩɛ ɩwɩ, kʋ́sʋ́ yɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á fʋdeklé. Támɛ nɩ́ fɔbwɛ́ oyin dɛhɛn a, fɛ́tɩnkɩ́ ɩbɩ, há ɔkʋ ɔbɛ́dɩdá fʋ́ atɔ́, kpá fʋ́ ya ɔtɩ́nɛ́á fʋmedékle.” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu lɛ́blɩ́ asʋ́n ánfɩ, pʋ́súná ɔkpa ánɩ́ Petro ɔbɔ́tsʋn mʋ́sʋ́ wú pʋ́wá Bulu numnyam.) Ɩnʋ ɔlɛbláa Petro ɔbɛ́ɛ, “Buo mɩ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro lɛ́damlí kɩ a, Yesu ɔkasɩ́pʋ́ amʋ́ʋ́ ɔtɛhɩ́ɛ́ dwɛ́ ámʋ buo amʋ́. (Mʋgyí ɔhá ámʋ́ʋ́ oleyinkí kpɩ́sá Yesusʋ ntʋ́pwɛ atɔ́ ogyíkpá, fɩ́tɛ́ mʋ ɔbɛ́ɛ, “Owíé, ma ɔbɛ́lɛ fʋ́ há?” ámʋ nɩ.) ");
INSERT INTO nkoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Brɛ́á Petro lówun mʋ a, ɔlɛfɩtɛ́ Yesu ɔbɛ́ɛ, “Mɩ́ Wíé, ntɔ ɔbɛ́ba oyin ánfɩ ɛ́sʋ́?” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nɩ́ ndeklé mbɛ́ɛ otsía nkpa yɔ́fʋn brɛ́á néyinkí ba a, fʋ́ asʋ́n igyi? Fʋ́ mʋ́ buo mɩ wʋlɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Asʋ́n ánfɩ ɩlɛklɛɩ́ wá Yesu abúopʋ amʋtɔ, ánɩ́ alɩ ɔkasɩ́pʋ́ amʋ mʋ́ móowu. Támɛ Yesu mɛ́blɩ́ ɔbɛ́ɛ, omóowu. Blɩ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Nɩ́ ndeklé mbɛ́ɛ, otsía nkpa yɔ́fʋn brɛ́á néyinkí ba a, fʋ́ asʋ́n igyi?” ");
INSERT INTO nkoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mʋgyí ɔkasɩ́pʋ́á olowun ɩ́nɩ fɛ́ɛ́, ɔlɔwanlɩ́n mʋ́ tswɩ nɩ. Anɩyin ánɩ́ mʋ asʋn blɩ́hɛ́ anfɩ igyi ɔnɔkwalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Atɔ́ tsɔtsɔɔtsɔ ɩtráa bʋ ɩnʋá Yesu lɔ́bwɛ tsɩ́a ɩ́nɩtɔ. Nɩ́ bɔwanlɩ́n mʋ́ fɛ́ɛ́ wá nwʋlʋ́tɔ́ ɩkʋlɛ-kʋlɛ a, tɛkɩ bʋméenya nwʋlʋ́ ámʋ ɔyaɩ́kpá ɔsʋlʋ́ʋ anfɩsʋ. Natɔ́ɩ́ tá.");
INSERT INTO nkoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mɩ́ wíé Tiofilo, Mɩ́ Luka dɛ́ ɔwʋlʋ́ ánfɩ wanlɩ́n sɩ́sɩ́ fʋ́. Mɩ́ ɔwʋlʋ́ gyankpapʋ amʋtɔ á, nɔwanlɩ́n Yesu atɔ bwɛhɛ́ pʋ́ mʋ atosunáhɛ́ fɛ́ɛ́; tsú brɛ́á olefi mʋ agyʋ́má asɩ, ");
INSERT INTO nkoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bɔfʋn ɛkɛá Bulu lótsu mʋ ya ɔsʋ́sʋ́. Asa Bulu lótsu mʋ nátɩ́ á, ɔlɔtsʋn Ɔŋɛ Wankɩ́hɛ́ túmitɔ bláa ahá ámʋ́ʋ́ ɔlɛlɛ ɔbɛ́ɛ, bʋbwɛ́ɛ mʋ sumbí ayɔpʋ́ ámʋ tɔ́á bʋbwɛ́ɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mʋ ɩwɩɔsɩn wúun pʋ́ mʋ lowu ɔma a, oletsiá lɛ́ ɩwɩ ɔwan ɔkpa ɔtsan-ɔtsansʋ súná amʋ́, pʋ́súná ánɩ́ lɛ́lɛ́ otsie nkpa nkɛ adʋana ánɩ́ ɔlɛlatsíá ɔsʋlʋ́sʋ fɛ́ɛ́; ɔdɛ Bulu iwíegyí ɩwɩ asʋ́n blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Brɛ́ kʋá mʋa amʋ́nyɔ befia a, ɔlɛda amʋ́ ɔlá ɔbɛ́ɛ, “Mlɩmánatɩ́ Yerusalem. Mlɩtsia ɩnʋ gyo mɩ́ Sɩ́ atokiehɛ́ ámʋ́ʋ́ ɔlɛhɩɛ yáɩ́ ɔbɛ́ɛ mɛ́ha mlɩ, nɛbláa mlɩ mʋ́ ɩwɩ asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Asú Ɔbɔpʋ́ Yohane lɔ́pʋ ntsu bɔ́ ahá asú, támɛ nkɛ kútúklú kʋ ɔma a, Bulu ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ amʋ bɔ́ mlɩ asú.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mʋ́ sʋ brɛ́á mʋa amʋ́nyɔ bɛlafia a, bɛfɩtɛ́ mʋ bɛɛ, “Anɩ Wíé, brɛ́ ánfɩtɔ féyinkía iwíegyí amʋ há Israelfɔ nɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu lɛ́bláa amʋ́ ɔbɛ́ɛ, “Imehián ánɩ́ mlɛ́bɩ nkɛ ntɛ́ɛ brɛ́á mɩ́ Sɩ́ nkʋlɛ lahɩ́ɛ́ mʋ onutó túmitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mboún nɩ́ Ɔŋɛ Wankɩ́hɛ́ amʋ owíé mlɩtɔ á, mlénya túmi tálɩ́ gyi mɩ́ ɩwɩ adánsɩɛ tsú Yerusalem wúlutɔ, Yudea pʋ́ Samaria ɔmátɔ́ fɛ́ɛ́ yɔ́fʋn ɔyɩ́ ɔka.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Brɛ́á ɔlɛblɩ́ asʋ́n ánfɩ tá á, amʋ́ ansɩ́tɔ́ ɩnʋ Bulu lótsu mʋ ya ɔsʋ́sʋ́, ɔlɔfwɩ wíé nwʋlʋ́táatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Besi bʋdɛ nwʋlʋ́táa kɩ́ɩ alɩɩ. Bɛlákɩ a, ayin abanyɔ́ akʋá bɔwa atadɩɛ futútú lɩ́ɩ́ amʋ́ wá á. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ayin ámʋ bɛfɩtɛ́ amʋ́ bɛɛ, “Óo Galileafɔ ayin, ntɔ mlɩdɛ́kɩ́ɩ nwʋlʋ́táasʋ alɩ? Alɩ ánfɩ mlɩlawun Bulu latsú Yesu ɔya ɔsʋ́sʋ́ ánfɩ á, alɩ kɛ́n obéyinkía mʋ ba nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ɩnʋ beyinkí kplɩ́ tsú Nfɔ-nyíbʋ ámʋsʋ ba Yerusalem. Ɔkpa ámʋ ɩbɔ́bwɛ máɩlɩ fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bowie wúlutɔ á, bɔdʋ yɔ́ abansʋ́rʋtɔ, ɔtɩ́nɛ́ ámʋ́ʋ́ bʋtsie yaɩ́ ámʋ. Sumbí ayɔpʋ́á bɔyɔ ɩnʋ gyí: Petro, Yohane, Yakobo mʋa Andrea, Filipo mʋa Toma, Bartolomeo mʋa Mateo, Alfeo mʋ bi Yakobo, Simon ánɩ́ ogyi ɩwɩsʋtsiá adunkápʋ́ ɔpasuatɔ ɔha pʋ́ oyin ɔkʋá bʋtɛtɩ́ mʋ Yakobo mʋ bi Yuda. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ahá ánɩ́ bɛtrá dʋ yɔ́ ɩnʋ gyí, atsɩ akʋ, Yesu mʋ yin Maria pʋ́ Yesu apíó. Ahá ánfɩ fɛ́ɛ́ létsiá bwɛ́ ɩkʋlɛ bɔ́ mpáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nkɛ ámʋtɔ á, ahógyipʋ bɔ́bwɛ fɛ́ lafakʋlɛ-adʋanyɔ (120) befia. Ɩnʋ Petro lɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ nsɩnɛ́ bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mɩ́ apíó ahógyipʋ, Ɔŋɛ Wankɩ́hɛ́ asʋ́n ámʋ́ʋ́ ɔlɛblɩ́ tsʋn Owíe Dawidsʋ, ɩbʋ Bulu asʋn wanlɩ́nhɛ́ amʋtɔ, tsú Yuda Iskariot ámʋ́ʋ́ ɔlɛkpa ahá bɛyɛ́kɩtá Yesu ɩwɩ ámʋ ɩlaba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda Iskariot anfɩ létsiá anɩtɔ. Anɩa mʋnyɔ lɔ́yɔ osum agyʋ́má ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yuda lɔ́pʋ mʋ lalahɛ ánɩ́ ɔlɔbwɛ ɩkɔá bɛka mʋ yɔ́hɔ ɔsʋlʋ́ʋ kʋ. Ɔlɛkpa tsú ɔsʋ́sʋ́ bɛda ɔsʋlʋ́ʋ amʋsʋ pɔ, mʋ ipu lɛfa po, mʋ mpúni ɛ́ lɛfɛn dalɩ wʋrɔdɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɔhagyíɔha ánɩ́ ɔbʋ Yerusalem lónu asʋ́n ánfɩ. Bɛdɩnká ɔsʋlʋ́ʋ amʋ dá amʋ́ ɔblɩ́tɔ bɛɛ, “Hakeldama.” Mʋ́ asɩ gyí, “Ɔsʋlʋ́ʋá obugya lawʋ́lɩ́ mʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petro lɔ́yɔ mʋ asʋ́nsʋ́ ɔbɛ́ɛ, “Tsúfɛ́ bɔwanlɩ́n wá Israelfɔ ɩlʋ ɔwʋlʋ́ ámʋtɔ bɛɛ, ‘Mʋ wóyí ɩdɩ́ kpan. Ɔhaa mátsiá mʋ́tɔ́.’ Bɛtrá wanlɩ́n tswɩ bɛɛ, ‘Ɔha bambá otsía mʋ otsiákpá.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mʋ́ sʋ ilehián ánɩ́ ɔkʋ ɔbɛ́tsa anɩ Yesu afúlitɔkʋsʋ́ ánfɩ ɩwɩ adánsɩɛ gyí. Ilehián ánɩ́ ɔhá ámʋ obótsu ayin ámʋ́ʋ́ betsiá anɩtɔ brɛ́ ámʋ́ʋ́ anɩlóbuo anɩ Wíe Yesu, nátɩ́ kí ntɩ́nɛ́-ntɩ́nɛ́ amʋtɔ. Ɔhá ánɩ́ olobuo anɩ tsú brɛ́á Asú Ɔbɔpʋ́ Yohane lɛ́blɩ́ asúbɔ asʋ́n alɩɩ bɔfʋn ɛkɛ ámʋ́ʋ́ Bulu lótsu Yesu ya ɔsʋ́sʋ́ sí anɩ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɩ́nɩ sʋ bɛlɛ ahá abanyɔ́, bʋgyi Yosef ánɩ́ bʋtɛtɩ́ mʋ Barsaba, bʋtɛtráa tɩ mʋ Yustus mʋa Matia. ");
INSERT INTO nkoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mʋ́ʋ́ bɔbɔ mpáɩ bɛɛ, “Anɩ Wíe, fʋyin ɔhagyíɔha klʋntɔ asʋ́n. Suna anɩ ahá ánfɩtɔ ɔmʋá falɛ́, ");
INSERT INTO nkoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","otsia Yuda amʋ́ʋ́ alakíná agyʋ́má ánfɩ, nyá mʋ ɩsʋbɩtɩ́ ámʋ otsiákpá, ɔyɔ fʋ́ osum agyʋ́má ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mʋ́ʋ́ bɛkapʋ́ atɔ́ amʋ́ abanyɔ́ nwunsʋ. Ileyi Matiasʋ. Mʋ́ sʋ bɔpʋ mʋ wá sumbí ayɔpʋ́ dúɔkʋn ámʋtɔ, bɛlabwɛ́ dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekoste Ɛkɛ, igyi Israelfɔ atɔ pɔpwɛ ɔnɔ́ ɔdakɛ́ ámʋ lɔfʋn a, ahógyipʋ amʋ fɛ́ɛ́ bɛba befia amʋ́ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ɔtsáwʋlɛ pɛ́ á, olú kʋá igyi fɛ́ afú kpɔnkpɔntɩ ilotsu ɔsʋ́sʋ́ bɔbʋlá wóyí ámʋ́ʋ́ bʋbʋ mʋ́tɔ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ɩnʋ bowun tɔkʋá igyi fɛ́ ogya plɛnplɛn, ɩlɛlɩan ɔdandʋ. Ɩlɛdasáɩ́n dɩ́nká amʋ́tɔ́ okugyíɔkʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɔŋɛ Wankɩ́hɛ́ lɔbʋlá okugyíɔkʋtɔ, ɩlɛha okugyíɔkʋ léfi asɩ ɔdɛ ɔblɩ́ɩ bámbá blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Brɛ́ ámʋtɔ á, Yudafɔá bʋtenyá Bulu ifú, bʋbʋ ndɩ́tɔ́ fɛ́ɛ́ baba bʋtsie Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Brɛ́á ɔdɔm anfɩ bonu okitikíti amʋ a, bɛsrɩ́ befia ɩnʋ. Amʋ́tɔ́ okugyíɔkʋ lónu mʋ wúlutɔ ɔblɩ́ɩ. Mʋ́ sʋ ɔnɔ́ lobwie amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɩlɔwa amʋ́ ifú, wá amʋ́ wánwan. Mʋ́ sʋ bɛfɩtɛ́ bɛɛ, “Ahá ánfɩ bʋdɛtɔɩ́ á, megyí Galileafɔ sɔ́ɔ́n bʋgyi? ");
INSERT INTO nkoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mʋ́ nkálɩ ɩlɔbwɛ asa anɩdénuá bʋdɛ anɩtɔ okugyíɔkʋ wúlutɔ ɔblɩ́ɩ blɩ́? ");
INSERT INTO nkoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anɩtɔ akʋ atsú Partia, Media, Elam, Mesopotamia, Yudea, Kapadokia, Ponto, Asia, ");
INSERT INTO nkoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Egyipte ɔmátɔ́ pʋ́ Libia awúlu ánɩ́ ɩbʋ mantáa Kirene wúlutɔ. Akʋ ɛ́ botsú Roma wúlutɔ, ");
INSERT INTO nkoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","bʋ́gyi Yudafɔ pʋ́ amʋ́á bʋmegyí Yudafɔ bawíé Yudafɔ Bulusúmtɔ́ aná fɛ́ɛ́ bʋbʋ anɩtɔ. Kretafɔ pʋ́ Arabifɔ ɛ́ bʋbʋ anɩtɔ. Támɛ anɩdénuá bʋdɛ Bulu atɔ kpɔnkpɔntɩ ánɩ́ alabwɛ́ blɩ́ anɩtɔ okugyíɔkʋ ɔblɩ́tɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Alɩ ámʋ́ʋ́ asʋ́n ámʋ ilobwie amʋ́ ɔnɔ́ ámʋ sʋ bɔbwɛ yɔɔ, sí bʋdɛ amʋ́ aba fɩtɛ́ bɛɛ, “Ngya amansʋ ɛ́ nɩ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Támɛ amʋ́tɔ́ akʋ bɔbwɛ ahógyipʋ amʋ ahinlá bɛɛ, “Ntá banu bʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ɩnʋ Petro mʋa mʋ aba dúɔkʋn ámʋ bɔkʋsʋ́ lɩ́ɩ́. Mʋ́ʋ́ Petro lótsu ɔmɛ fʋ́á bláa ɔdɔm amʋ ɔbɛ́ɛ, “Apíó aba Yudafɔ pʋ́ mlɩ fɛ́ɛ́á mlɩbʋ Yerusalem, mlɩhɩɛ yaa asʋ, anlɛ asʋ́ntɔ́ suna mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mlɩmákɩ mlɩaa ahá ánfɩ babʋ́, tsúfɛ́ ɔyɩ́ mɔkʋ́kɛ. Brɛ́á dokwebá ladá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mboún asʋ́n ánfɩ ɩlaba ndɛ ánfɩ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yoel lɛ́blɩ́ yáɩ́ nɩ́. Ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Bulu ɔbɛ́ɛ, “Nkɛ tráhɛ amʋtɔ á, nɔ́pʋ mɩ́ Ɔŋɛ́ wá anyánkpʋ́sa fɛ́ɛ́tɔ́. Mlɩ abi yinhɛ́ pʋ́ mlɩ abi tsɩhɛ́ bɛ́blɩ́ asʋ́n ánɩ́ nɔ́pʋwá amʋ́ ɔnɔ́. Mlɩ nyasubi bówun atɔ́. Mlɩ ayin dɛhɛn bókun nkude. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nkɛ ámʋtɔ á, nɔ́pʋ mɩ́ Ɔŋɛ́ wá mɩ́ asúmpʋ́ atsɩ mʋ́a ayin fɛ́ɛ́tɔ́. Mʋ́ sʋ bɛ́blɩ́ asʋ́n ánɩ́ nɔ́pʋwá amʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɔ́bwɛ ofúla nwʋlʋ́táasʋ, bwɛ́ osúna ɔsʋlʋ́sʋ. Ogyá, obugya pʋ́ ogyási tuun bɛ́ba ɔyɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Owí ɔbɛ́ta ɔpá. Ɔtsra ɛ́ ɔbɛ́pɛ kɔɔ fɛ́ obugya, asa anɩ Wíe numnyam ɛkɛ kpɔnkpɔntɩ ámʋ ɩbɔ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɩbɛ́ba ánɩ́ ɔhagyíɔha ánɩ́ okpólí anɩ Wíe a, ɔbɛ́ha mʋ obénya nkpa.” ’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petro lɔ́yɔ mʋ́sʋ́ ɔbɛ́ɛ, “Mɩ́ apíó Israelfɔ, mlɩyaa asʋ amlɩnu asʋ́n ánfɩ. Bulu lɔ́bwɛ ofúla mʋ́a atɔ́ kpɔnkpɔntɩ pʋ́ osúna tsɔtsɔɔtsɔ tsʋn Yesu Nasaretyin amʋsʋ, pʋ́súná ánɩ́ mʋlɔ́wa mʋ. Mlɩ fɛ́ɛ́ mlɩlówun mʋ́, tsúfɛ́ mlɩ ansɩ́sʋ́ ɩ́nɩ fɛ́ɛ́ lɛba. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Igyi tɔ́á Bulu yin yaɩ́ dodo, igyi mʋ apɛ́ ánɩ́ bɛ́lɛ Yesu há mlɩ. Mlɩlɛ́ha ahá ánɩ́ bʋtamagyi mblasʋ bɛda mʋ mántá oyikpalíhɛsʋ, mɔ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Támɛ Bulu lɛ́lɛ mʋ lowu sɩ́nsɩ́ɩ́nsɩ́ntɔ́, kʋ́sʋ́a mʋ tsú afúlitɔ. Tsúfɛ́ lowu mɛ́ɛtalɩ́ gyi mʋsʋ, osin afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ɩ́nɩ sʋ́ Owíe Dawid lɛ́blɩ́ mʋ ɩwɩ asʋ́n ɔbɛ́ɛ, ‘Brégyíbrɛ́ á, ntowun anɩ Wíe mɩ́ ansɩ́sʋ́. Tsúfɛ́ ɔlɩɩ́ mɩ́ gyɔpɩsʋ, sʋ tɔtɔ mɔ́ɔwa mɩ́ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mʋ́ sʋ ansɩ́ tegyi mɩ, ntɔtɔ́ɩ́ ansigyísʋ́. Nyankpʋsa ngyi. Lowu da gyo mɩ́, támɛ ndɛ Bulu ɔkpa kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tsúfɛ́ fʋméesi mɩ́ ɔkláa wá afúlitɔ. Fʋmɛ́ɛha mɩ́ fʋ́ osúmpʋ́ wankɩ́hɛ́ mmɔ́ɔplɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fʋ́lósuná mɩ́ ɔkpa ánɩ́ ntsʋ́ʋn mʋ́sʋ́, mɩ́ anya nkpa ánɩ́ ɩtamatá. Nɩ́ fʋ́bʋ mɩ́ wá á, ansɩ́ bégyi mɩ ekekegyíɛkɛ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petro lɛ́trá bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó Israelfɔ, mbʋ́a hɩɛ bla mlɩ amlɩnu. Anɩ náin Owíe Dawid lówu, bopulá mʋ. Bɔ́tʋ ndɛ mʋ ntsán da anɩ wá nfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ogyi, oyin ánɩ́ ntam ánɩ́ Bulu lɛ́ka há mʋ bɛ́ba mʋ́tɔ́. Bulu lɛ́ka ntam há mʋ ɔbɛ́ɛ, mɛ́ha mʋ natɩna ɔkʋ obétsiá mʋ obíásʋ́ ɛkɛ kʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ɩ́nɩá anɩ náin Owíe Dawid lówun mʋ́ yáɩ́ sʋ á, ɔlɔtɔɩ́ tsú Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) kʋsʋ́ tsú afúlitɔ ɩwɩ ɔbɛ́ɛ, ‘Bulu méesi mʋ wá afúlitɔ. Mʋ́ sʋ mʋ ɔyʋlʋ́ʋ mɔ́ɔplɔ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Petro lɔ́yɔ mʋ́sʋ́ ɔbɛ́ɛ, “Yesu gyí ɔhá ánɩ́ Bulu lɔ́kʋsʋ́a tsu afúlitɔ, anɩ fɛ́ɛ́ anɩgyí mʋ́ adansɩfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bulu lótsu Yesu ya ɔsʋ́sʋ́, há mʋ otsiákpá yilé mʋ gyɔpɩsʋ. Anɩ Sɩ́ Bulu lɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ ánɩ́ ɔlɛhɩɛ yáɩ́ ɔbɛ́ɛ, mɔ́pʋhá mʋ ahógyipʋ há mʋ. Ɔŋɛ́ ámʋ Yesu lapʋ́há anɩ á. Mʋ́ gyumagyihɛ mlɩdéwúun, mlɩdénu á. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Megyí Owíe Dawid Bulu lótsu ya ɔsʋ́sʋ́, támɛ mʋlɛ́blɩ́ yáɩ́ ɔbɛ́ɛ, ‘Anɩ Wíe Bulu lɛ́bláa mɩ́ Wíe ɔbɛ́ɛ, Tsia mɩ́ gyɔpɩsʋ, ");
INSERT INTO nkoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yɔ́fʋn brɛ́á nɔ́pʋ fʋ́ alupʋ́ bwɛ́ fʋ́ ayabi oyíkpa.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mʋ́ sʋ mlɩ Israelfɔ fɛ́ɛ́ mlɩnu. Ɩbʋ mʋ́tɔ́á mlɩlɛ́da Yesu mántá oyikpalíhɛsʋ. Támɛ mlɩhɩɛ bɩ ánɩ́ Bulu ladá mʋ ofúli, bwɛ́ mʋ Kristo pʋ́ anɩ Wíe.” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Brɛ́á Israelfɔ ámʋ bonu asʋ́n ánfɩ á, ɩlɛhɩɛ han amʋ́. Mʋ́ sʋ bɛfɩtɛ́ Petro mʋa mʋ aba sumbí ayɔpʋ́ atráhɛ amʋ bɛɛ, “Apíó, ntɔ abwɛ́ɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mʋ́ʋ́ Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mlɩtɔ okugyíɔkʋ ɔdámli klʋntɔ, abɔ mlɩ asú Yesu Kristo dátɔ́, mɛ́nɩ Bulu obési mlɩ lakpan kíé mlɩ, há mlɩ Ɔŋɛ Wankɩ́hɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tsúfɛ́ mlɩa mlɩ abí-aná pʋ́ ahá ánɩ́ bʋbʋ tsútsúútsú ánɩ́ Bulu ɔbɛ́tɩ fɛ́ɛ́ ɔlɛhɩɛ Ɔŋɛ Wankɩ́hɛ́ anfɩ há.” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro lɛ́blɩ́ asʋ́n tsɔtsɔɔtsɔ, pʋ́tɔ́ɩ́ kplá amʋ́ ɔbɛ́ɛ, “Mlɩlɛ mlɩ ɩwɩ tsu ndɛmba-abí laláhɛ anfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bɔhɔ Petro asʋ́n ámʋ. Mʋ́ sʋ bɔbɔ amʋ́ asú. Ɛkɛ ámʋ a, ahá bɔ́bwɛ fɛ́ mpɩ́m-sa (3,000) bɛtsɩá ahógyipʋ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ahógyipʋ amʋ bɛlɛ ansɩ́ kɩ́tá sumbí ayɔpʋ́ ámʋ atosunáhɛ́, amʋ́ ɩkʋlɛbwɛ tógyítɔ́tɔ́, ɔpasua ámʋtɔ atogyihɛtɔ yée pʋ́ mpáɩbɔtɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sumbí ayɔpʋ́ ámʋ bɔbwɛ ofúla pʋ́ osúna tsɔtsɔɔtsɔ, ɔnɔ́ lobwie ɔhagyíɔha. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ahógyipʋ amʋ fɛ́ɛ́ bɔbwɛ tógyítɔ́ kʋlɛ. Betsiá ye amʋ́ atɔ́ há aba. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Betsiá fɛ́ amʋ́ atɔ́, ye kɔ́ba ánɩ́ benyatɔ há amʋ́tɔ́ okugyíɔkʋá ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Amʋ́ fɛ́ɛ́ betsiá fía Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ekekegyíɛkɛ. Bɔpʋ amʋ́ klʋntɔ-ɔdwɛ tsíá gyi atɔ́ ɔpasuatɔ amʋ́ aba wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Betsiá kánfʋ́ Bulu, ahá fɛ́ɛ́ bekle amʋ́ asʋ́n, anɩ Wíe Bulu létsiá pʋ́ ahá ánɩ́ ɔdɛlɛ bɛtsɩá amʋ́tɔ́ ekekegyíɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɛkɛ ɔkʋ ntʋ́pwɛ dɔsatɔ mpáɩbɔ brɛ́ á, Petro mʋa Yohane bɔyɔ Bulu ɔtswɛ́kpa amʋ wunsɩnɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oyin ɔkʋá bɔkwɩɩ́ mʋ ɩbɔ tetsíá Bulu ɔtswɛ́kpa amʋ ɔkpa ɔnɔ́ kʋá bʋtɛtɩ́ mʋ́ “Ɔkpa ɔnɔ́ Wankláán.” Ahá bʋtotsú mʋ ba bɛyaɩ́ ɩnʋ ekekegyíɛkɛ, ɔtɔkʋ́lɩ́ ahá ánɩ́ bówie Ɔtswɛ́kpa ɩnʋ kɔ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Brɛ́á ɩbɔ amʋ lówun ánɩ́ Petro mʋa Yohane bʋdebitíwíé Ɔtswɛ́kpa ɩnʋ á, ɔlɔkʋlɩ́ amʋ́ kɔ́ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petro mʋa Yohane besi lɩ́ɩ́ bʋdɛ mʋ kɩ́ɩ díín. Mʋ́ʋ́ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́ mʋ́ kɩ anɩ wʋlɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɩbɔ amʋ kɩ ɔbɛ́ɛ, bɛ́ha mʋ tɔkʋ. Mʋ́ sʋ olotsu ansɩ́ fʋ́á ɔdɛ amʋ́ kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Támɛ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Mma sika futútú ntɛ́ɛ pɛ́pɛ, támɛ nɛ́ha fʋ́ tɔ́á mbʋ. Kʋsʋ lɩɩ, afʋnatɩ Yesu Kristo Nasaretyin amʋ dátɔ́!” ");
INSERT INTO nkoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ɩnʋ Petro lɛ́kɩtá mʋ gyɔpɩ bɩ, tsú mʋ lɩ́ɩ́, ɩnʋnʋ ɔwʋnlɩ́n lowie mʋ ayabi pʋ́ mʋ ntsakpátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Olofulí kpáyi ɔtsáwʋlɛ pɛ́, wá natɩ́ bɩ. Mʋ́ sʋ ɔlɛkplá buo Petro aná wíé Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ; ɔna odefulí kpáyi; ɔdɛ Bulu kanfʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ahá ánɩ́ bʋbʋ ɩnʋ fɛ́ɛ́ bowun mʋ ánɩ́ ɔna ɔdɛ Bulu kanfʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mʋ́ sʋ brɛ́á ɩlɔwankɩ́ amʋ́ ánɩ́ ɩbɔ amʋ́ʋ́ otetsíá Ɔkpa Ɔnɔ́ Wankláán ɩnʋ kʋ́lɩ́ atɔ́ ámʋ nɩ á, ɩlɔwa amʋ́ wánwan, bwíé amʋ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Oyin ámʋ pú Petro mʋa Yohane kínkíínkín Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́, ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Salomo Abrándaásʋ́. Mʋ ɩlɔtsa lɔwa amʋ́ wánwan. Mʋ́ sʋ bɛsrɩ́ ba amʋ́ wá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Brɛ́á Petro lówun amʋ́ á, ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó Israelfɔ, ntogyi sʋ́ asʋ́n ánfɩ lawá mlɩ wánwan alɩ? Ntogyi sʋ́ mlɩlaba mlɩdɛ́ anɩ kɩ́ɩ alɩ? Mlɩkɩ́ mlɩaa, anɩ onutó túmi ntɛ́ɛ anɩ Bulusúm wankláán láhá sʋ oyin ánfɩ lakʋ́sʋ́ ɔna? ");
INSERT INTO nkoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bulu ámʋ́ʋ́ anɩ anáin Abraham, Isak pʋ́ Yakob bosúm ámʋ lɔ́wa mʋ osúmpʋ́ Yesu numnyam. Támɛ mlɩlɔ́pʋ mʋ há mlɩaa bʋmɔ́ɔ mʋ. Mlɩlékiná ɔhá ánfɩ tɛkɩ Pilato lɔ́bwɛ agywɩɩn ánɩ́ mési mʋ ɔnatɩ ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mlɩlékiná Ɔha Wankɩ́hɛ́ pʋ́ Yilé Ɔbwɛpʋ́ ánfɩá bɔwanlɩ́n mʋ ɩwɩ asʋ́n wá Bulu asʋ́n ɔwʋlʋ́tɔ́ anfɩ, bláa Pilato mlɩaa, osíi ahá ɔmɔpʋ́ ámʋ mboún ha mlɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mlɩlɛ́ha bɔmɔ nkpa ɔhapʋ́ ánfɩ, támɛ Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ. Anɩgyí mʋ́ ɩwɩ adansɩfɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu túmi láhá ɩbɔ anfɩ́ mlɩyin yaɩ́, mlɩdɛ́kɩ́ɩ anfɩ ɩwɩ lawá mʋ ɔnlɩn. Anɩ Yesu hógyi látsá mʋ, mlɩ fɛ́ɛ́ mlɩdéwúun a. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ɩ́nɩ sʋ mɩ́ apíó, nyin ánɩ́ mábɩ́ lɛ́ha mlɩa mlɩ ahandɛ mlɩlɔ́pʋ ɩ́nɩ fɛ́ɛ́ gyi Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Támɛ a, Bulu lɛ́blɩ́ tsʋn mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ fɛ́ɛ́sʋ́ yáɩ́ ɔbɛ́ɛ, ‘Kristo, (ɔhá ámʋ́ʋ́ nɛda mʋ ofúli amʋ) obówun ɩwɩɔsɩn.’ Mʋ́ sʋ ɔlɛha ɩlɛba alɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mʋ́ sʋ mlɩdamli klʋntɔ, amlɩyinki ba Bulu wá, mɛ́nɩ obési mlɩ lakpan fɛ́ɛ́ kíé mlɩ, wá mlɩ ɔwʋnlɩ́n pɔpwɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","lápʋ́ Yesu sɩ́sɩ́ mlɩ. Mʋ Bulu lɛ́da ofúli yáɩ́ há mlɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ilehián ánɩ́ Yesu obétsiá ɔsʋ́sʋ́ ɩnʋ yɔ́fʋn brɛ́á Bulu ɔbɛ́la tógyítɔ́ bwɛ́, fɛ́ alɩá ɔlɛha mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́ wankɩ́hɛ́ amʋ bɛblɩ́ tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Anɩ náin Mose lɛ́blɩ́ ɔbɛ́ɛ, ‘Mlɩ Wíe Bulu ɔbɛ́ha mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋá ogyi fɛ́ mɩ́ ɔbɛ́dalɩ tsú mlɩtɔ há mlɩ. Mlɩgyi mʋ asʋn blɩ́hɛ́ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɔhagyíɔha ánɩ́ omobu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ anfɩ á, Bulu ɔbɛ́lɛ mʋ lɛ́ mʋ ahátɔ, mɔ́ mʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tsú Samuelsʋ á, Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́á bɛba fɛ́ɛ́ bɔtɔɩ́ tsú asʋ́n ánfɩ ɩdɛbá nkɛ ánfɩtɔ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mlɩgyí Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ abí-aná. Mlɩbʋ́ ɩtɔ́ ámʋ́ʋ́ Bulu lɛ́hɩɛ yáɩ́ há anɩ anáin amʋ. Tsúfɛ́ Bulu lɛ́bláa Abraham ɔbɛ́ɛ, ‘Nɔ́tsʋn fʋ́ abí-anásʋ́ yúlá ɔyɩ́tɔ́ ahá fɛ́ɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɩ́nɩ sʋ́ brɛ́á Bulu lɛ́lɛ mʋ osúmpʋ́ Yesu a, olegyankpá pʋ́ mʋ sɩ́sɩ́ mlɩ Israelfɔ, ɔbɛ́ɛ obóyulá mlɩ, amlɩsi lakpan bwɛ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Brɛ́á Petro mʋa Yohane bʋbʋ mʋ́sʋ́ bʋdɛtɔɩ́ kplá ahá ámʋ a, Bulu igyí ahapʋ́ mʋ́a Bulu ɔtswɛ́kpa agyópʋ ɔhandɛ pʋ́ Sadukifɔ akʋ bɛba bɔtʋ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɔblɔ́ lɛkɩtá ahandɛ anfɩ. Tsúfɛ́ sumbí ayɔpʋ́ ámʋ bʋdɛ ahá ámʋ atɔ́ suná bɛɛ, Yesu lawú kʋ́sʋ́ tsú afúlitɔ. Mʋ́ sʋ wukʋ́sʋ́ bʋ ɩnʋ há ɔhagyíɔha. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ahandɛ amʋ bɛkɩtá Petro mʋa Yohane. Owí dɛta sʋ bɔpʋ amʋ́ yɔ́wa obu yɛ́ha ɔyɩ kɛhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Támɛ ahá ámʋ́ʋ́ bonu amʋ́ atosunáhɛ́ amʋtɔ ahá tsɔtsɔɔtsɔ bohogyi, bɛtsɩá ahógyipʋ amʋtɔ. Mʋ́ sʋ ahógyipʋ amʋtɔ ayin bɔbwɛ fɛ́ mpɩ́m-nu (5,000). ");
INSERT INTO nkoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɔyɩ kɛhɛ nyankɩ a, Yudafɔ awíe, amʋ́ ahandɛ pʋ́ Mose mbla asunápʋ́ bɛba befia Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ahá ánfɩ pʋ́ ahandɛ ánɩ́ befia asʋ́n ámʋ asɩ gyí; Bulu igyí ɔhapʋ́ dɛhɛn Hana, mʋ wóyítɔ́ ahandɛ Kaiafa, Yohane, Aleksandro pʋ́ wóyí ámʋtɔ ahá fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bɛha bɔpʋ Petro mʋa Yohane bɛlɩɩ́ amʋ́ ansɩ́tɔ́, bɛfɩtɛ́ amʋ́ bɛɛ, “Ma túmitɔ ntɛ́ɛ ma dátɔ́ mlɩlɛ́tsa oyin ánfɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ɩnʋ á, Ɔŋɛ Wankɩ́hɛ́ lɔbʋlá Petrotɔ. Mʋ́ sʋ ɩlɛha mʋ túmi ɔlɛbláa Yudafɔ awíe pʋ́ amʋ́ ahandɛ amʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Ndɛ mʋ́ mlɩdɛ́ anɩ fɩtɛ́ tɔ́á sʋá anɩlawá awɩtɔlɛ há ɩbɔ anfɩ, tsá mʋ ɩlɔ? ");
INSERT INTO nkoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mʋ́mʋ́ tsú ndɛ mlɩa Israelfɔ fɛ́ɛ́ mlɩbɩ ánɩ́ Yesu Kristo, Nasaretyin amʋ túmi pʋ́ mʋ dátɔ́ oyin ánfɩ ɔ́lɩɩ́ mlɩ ansɩ́tɔ́ ánfɩ lanyá ɩlɔtsá. Mʋgyí ɔhá ámʋ́ʋ́ mlɩlɛ́da mántá oyikpalíhɛsʋ mɔ́ mʋ asa Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ ámʋ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu anfɩ ɩwɩ asʋ́n bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Ibwi ámʋ́ʋ́ mlɩ obu ayípʋ mlɩlékiná ámʋ lábɔbwɛ okonkísʋ́bwi nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu anfɩ nkʋlɛ pɛ́ gyí ɔhá ánɩ́ Bulu lɔ́pʋhá anɩ ɔyɩ́ ánfɩtɔ ɔbɛ́ɛ, atsʋ́ʋn mʋsʋ nya nkpa. Ɔhaa trá ɔma ɩnʋá ɔdʋn mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɩ́nɩá Yudafɔ ahandɛ amʋ bʋyin ánɩ́ Petro mʋa Yohane bʋmɔkʋ́kásɩ́ ɔwʋlʋ́ kɩ, támɛ ifú mɛdɛ́ amʋ́ sʋ á, ɔnɔ́ lobwie amʋ́. Ɩlɔwankɩ́ amʋ́ ánɩ́ babuo Yesu kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ahandɛ amʋ bʋmenya asʋansʋ blɩ́. Tsúfɛ́ bowun ánɩ́ ɩbɔ amʋ́ʋ́ alanyá ɩlɔtsá ámʋ lɩ́ɩ́ Petro mʋa Yohane wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mʋ́ sʋ bɛbláa Petro aná bɛɛ, bʋdálɩ asʋ́n ogyíkpá ɩnʋ kpalobí, abʋkɩta agywɩɩn. Mʋ́ʋ́ ahandɛ amʋ bɛfɩtɛ́ aba bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nkálɩ abɔ́bwɛ ahá ánfɩ? Ɔhagyíɔha labɩ́ Yerusalem wúlutɔ ánɩ́ amʋ́ labwɛ́ osúna kpɔnkpɔntɩ ánfɩ. Anɩmɛ́ɛtalɩ́ gyi mʋ́ nwɛ́ɛn. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Támɛ alɩá ɩbɔ́bwɛ asʋ́n ánfɩ mɛ́ɛtrá klɛɩ́ á, mlɩha ada amʋ́ ɔlá kínkíínkín anɩaa bʋmátra bláa ɔhaa asʋansʋ Yesu dátɔ́ ɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ɩnʋ bɛlatɩ́ Petro mʋa Yohane ba obuto ɩnʋ, bɛda amʋ́ ɔlá bɛɛ, bʋmátra bláa ɔhaa asʋ́ngyíasʋ́n ntɛ́ɛ súná atɔ́ Yesu dátɔ́ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mʋ́ʋ́ Petro mʋa Yohane bɛbláa amʋ́ bɛɛ, “Mlɩ onutó mlɩkɩ. Mɔmʋ bʋ alɛ́ Bulu ansɩ́tɔ́, ánɩ́ abónu mlɩ asʋ́n lóó, ntɛ́ɛ Bulu klɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tsúfɛ́ anɩ mʋ́ anɩmɛ́ɛtalɩ́ sí tɔ́á anɩlawun pʋ́ asʋ́n ánɩ́ anɩlanú blɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bʋmɛtalɩ́ bɩ́tɩ́ amʋ́ ɩsʋ, tsúfɛ́ ahá ámʋ fɛ́ɛ́ bʋdɛ Bulu kanfʋ́ ofúla kpɔnkpɔntɩ ámʋ́ʋ́ alabwɛ́ ámʋ sʋ. Mʋ́ sʋ ahandɛ amʋ bɛtrá da amʋ́ ɔlá kínkíínkín, besi amʋ́ bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oyin ámʋ ɩlɔtsá lɔ́wa ifú, tsúfɛ́ alahɔ dʋn nfí adʋana (40) alɩ brɛ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yudafɔ ahandɛ amʋ benya sí amʋ́ alɩ, Petro mʋa Yohane beyinkí ba amʋ́ aba ahógyipʋ amʋ wá. Bɛbláa amʋ́ asʋ́n ánɩ́ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ amʋ bɛblɩ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Brɛ́á ahógyipʋ amʋ bonu asʋ́n ámʋ a, amʋ́ fɛ́ɛ́ bɔpʋ ɔmɛ kʋlɛ kʋ́lɩ́ Bulu bɛɛ, “Anɩ Wíe Bulu Otúmípʋ, fʋ́lɔ́bwɛ ɔsʋ́ fɔbwɛ asɩ, ɔpʋ mʋ́a ntsu pʋ́ mʋ́tɔ́ atɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fɔtsʋn Ɔŋɛ Wankɩ́hɛ́sʋ há anɩ náin Dawid, ogyi fʋ́ osúmpʋ́ lɛ́blɩ́ ɔbɛ́ɛ, ‘Ntogyi sʋ́ ɔmá-ɔmá banyá ɔblɔ́? Ntogyi sʋ́ ahá fɛ́ɛ́ babwɛ́ agywɩɩn kʋkʋ kpaalɩ? ");
INSERT INTO nkoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ɔsʋlʋ́sʋ awíe badɩ́dá atɔ́. Wúlu ahandɛ batɩ́ aba fia, kɩ́tá agywɩɩn laláhɛ anɩ Wíe Bulu mʋa Kristo, (ɔhá ámʋ́ʋ́ ɔlɛda mʋ ofúli) amʋsʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Petro lɔ́yɔ mʋ asʋ́nsʋ́ ɔbɛ́ɛ, “Lɛ́lɛ́ á, asʋ́n ánfɩ laba mʋ́tɔ́. Owíe Herode mʋa Pontio Pilatoá bʋmegyí Yudafɔ pʋ́ Israelfɔ babwɛ́ kʋlɛ wúlu anfɩtɔ, kʋ́sʋ́ lɩ́ɩ́ Yesusʋ. Mʋgyí fʋ́ osúmpʋ́ wankɩ́hɛ́á fɛ́da mʋ ofúli nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Támɛ bʋmɛbɩ ánɩ́ tɔ́á fɛhɩhɩ́ɛ yaɩ́ fɛɛ ɩbɛ́ba mʋ́tɔ́ fʋ́ apɛ́ pʋ́ fʋ́ túmitɔ dodo babwɛ́ á. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anɩ Wíe Bulu, kɩ alɩá baká anɩsʋ, afʋkpa fʋ́ asúmpʋ́, mɛ́nɩ abɛ́talɩ́ blɩ́ fʋ́ asʋ́n ámʋ, anɩméenya ifú. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tsa ahá ɩlɔ fʋ́ túmitɔ, afʋha abwɛ ofúla pʋ́ osúna fʋ́ osúmpʋ́ wankɩ́hɛ́ Yesu dátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Brɛ́á bɔbɔ mpáɩ ánfɩ tá á, amʋ́ ofíakpa ɩnʋ fɛ́ɛ́ ɩlɔkpɩnkɩ́. Ɔŋɛ Wankɩ́hɛ́ lɔ́bʋlá amʋ́tɔ́. Mʋ́ sʋ bɔwa klʋn dá Bulu asʋ́n ámʋ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ahógyipʋ amʋ fɛ́ɛ́ bɔpʋ klʋn kʋlɛ mʋ́a agywɩɩn kʋlɛ tsíá. Ɔkʋkʋ mɛ́blɩ́ ɔbɛ́ɛ tɔ́á mʋbʋ igyi mʋ nkʋlɛ klɛ́. Mboún okugyíɔkʋ atɔ́ lɔbwɛ amʋ́ fɛ́ɛ́ klɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sumbí ayɔpʋ́ ámʋ bɔpʋ túmi kpɔnkpɔɔnkpɔntɩ gyi anɩ Wíe Yesu ɩwɩ adánsɩɛ bɛɛ, Bulu lakʋ́sʋ́a mʋ tsú afúlitɔ. Bulu lɛ́hɩɛ wá awɩtɔlɛ há ahógyipʋ amʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Amʋ́tɔ́ ɔkʋkʋ mégyi ohian, tsúfɛ́ amʋ́á bʋbʋ ɔsʋlʋ́ʋ pʋ́ wóyí betsiá fɛ́ mʋ́, pʋ́ mʋ́ ɔnɔ́ kɔ́ba ba ");
INSERT INTO nkoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","sumbí ayɔpʋ́ ámʋ, betsiá ye mʋ́ há ɔhagyíɔha alɩá ilehián mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Mʋ́ sʋ alɩ kɛ́n Lewiyin ɔkʋá bʋtɛtɩ́ mʋ Yosef lɛ́fɛ ɔsʋlʋ́ʋ, ɔlɔpʋ kɔ́ba amʋ ba sumbí ayɔpʋ́ ámʋ nɩ. Yosef anfɩ otsú Kipro ɔmátɔ́, sumbí ayɔpʋ́ bɛha mʋ ɩdá Barnaba, (mʋ́ asɩ gyí, “Ahá atɛtɔ-ɔnlɩn ɔwapʋ́.”) ");
INSERT INTO nkoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɩnʋ oyin ɔkʋá bʋtɛtɩ́ mʋ Anania mʋa mʋ ka Safira ɛ́ bɛfɛ amʋ́ siadɩɛ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Támɛ Anania lɛ́lɛ kɔ́ba amʋ kʋ ŋáín, mʋ ka ɛ́ yin mʋ́ ɩwɩ. Ɔlɔpʋ kɔ́ba amʋ tráhɛ ba sumbí ayɔpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mʋ́ʋ́ Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Anania, ntogyi sʋ́ fahá Ɔbʋnsám lagyi fʋsʋ, fapʋ́ kɔ́ba amʋ́ʋ́ fenya ámʋ kʋ ŋáín, bɔ́wa afunu suná Ɔŋɛ Wankɩ́hɛ́? ");
INSERT INTO nkoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fʋ́bʋ́ fʋ́ ɔsʋlʋ́ʋ asa fɛfɛ mʋ́. Ɩ́nɩá fɛfɛ mʋ́ ɛ́ á, fʋ́bʋ́ fʋ́ kɔ́ba. Ntɔ láhan fʋ sʋ́ fabwɛ́ ɩtɔ́á igyi alɩ? Bulu fawá afunu súná o, megyí anyánkpʋ́sa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania lénya nú asʋ́n ánfɩ alɩ á, ɔlɛtɩn da wú. Mʋ́ sʋ ifú lɛhɩɛ kɩ́tá ahá ánɩ́ bonu asʋ́n ánfɩ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ɩnʋ nyasubi akʋ bɔkʋsʋ́ tsú tati kɩ́klɩ mʋ ɩwɩ, tsú mʋ yópulá. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ilegyi fɛ́ dɔnhwɩ́rɩ asa ɔma asa mʋ ka Safira ɛ́ lóbowie ɩnʋ. Alɩ brɛ́ ámʋtɔ á, omeyín tɔ́á ɩlaba mʋ kulusʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Safira, bla mɩ. Kɔ́ba anfɩ gyí tɔ́á fʋ́a fʋ́ kulu mlɩlénya brɛ́á mlɩlɛ́fɛ ɔsʋlʋ́ʋ amʋ nɩ?” Safira lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ee, alɩ anɩlénya nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mʋ́ sʋ Petro lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Ntogyi sʋ fʋ́a fʋ́ kulu mlɩlabwɛ́ ɔnɔ-ɔkʋlɛ mlɩaa mlɔ́sɔ Anɩ Wíe Ɔŋɛ́ kɩ? Kɩ, nyasubi ánɩ́ bayópulá fʋ́ kulu yínkí lawíé obu-ɔnɔ́ ɩnʋ á. Bɔ́sʋrá fʋ́ ɛ́ ya.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɩnʋnʋ ɔtsɩ ámʋ ɛ́ lɛ́tɩn da Petro ayabitɔ ɩnʋ wú. Brɛ́á nyasubi ámʋ bobowie ɩnʋ á, bowun ánɩ́ Safira ɛ́ lawú, sʋ botsu mʋ yópulá mʋ mantáa mʋ kulu. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ifú lɛhɩɛ wíé ɔpasua ámʋ pʋ́ ahá ánɩ́ bonu asʋ́n ánfɩ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bulu lɔ́tsʋn sumbí ayɔpʋ́ ámʋsʋ bwɛ́ ofúla pʋ́ osúna tsɔtsɔɔtsɔ wúlu amʋtɔ. Ahógyipʋ amʋ fɛ́ɛ́ bɔbwɛ kʋlɛ tsíá fia ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Salomo Abrándaásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ahá ánɩ́ bʋmegyí ahógyipʋ kʋ́ráá bɛtɩ ahógyipʋ amʋ ɩdayilé. Támɛ ɔkʋkʋ mɔ́bwɛ agywɩɩn ɔbɛ́ɛ, mɛ́bɛtsɩá ahógyipʋ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Igyi alɩ óó á, atsɩ mʋ́a ayin tsɔtsɔɔtsɔ bɔhɔ anɩ Wíe Yesu gyi. Bulu létsiá pʋ́ amʋ́ tsɩ́a ahógyipʋ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sumbí ayɔpʋ́ ámʋ ofúlábwɛ sʋ wúlu amʋtɔ ahá betsiá tsú amʋ́ alɔpʋ ba brɔnʋsʋ, bɛyaɩ́ nklan tswɩ pʋ́ amʋ́ tswɩ mʋ́sʋ́. Fówun nɩ́ Petro ɔbá bɔtsʋn ɩnʋ á, mʋ yiyí bɔ́wʋlɩ́ amʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɔdɔm ánɩ́ botsú awúluá ɩbʋ bomlí Yerusalemtɔ ɛ́ bɔpʋ amʋ́ alɔpʋ pʋ́ ahá ánɩ́ ɔŋɛ laláhɛ dɛ́ amʋ́ háan ba, sumbí ayɔpʋ́ ámʋ bɛtsa amʋ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sumbí ayɔpʋ́ ámʋ ɩwɩ lɔ́wa Bulu igyí ɔhapʋ́ dɛhɛn amʋ mʋa mʋ aba ánɩ́ bʋbʋ Saduki ɔpasuatɔ olu. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɩ́nɩ sʋ bɛkɩtá sumbí ayɔpʋ́ ámʋ wá obu. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Támɛ onyé, Bulu-ɔbɔpʋ ɔkʋ lɛ́ba befinkí obu ámʋ, kpá sumbí ayɔpʋ́ ámʋ dálɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Bulu-ɔbɔpʋ amʋ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩyɔ amlɩyɛlɩɩ́ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, amlɩbla ahá nkpa pɔpwɛ amʋ ɩwɩ asʋ́n fɛ́ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sumbí ayɔpʋ́ ámʋ begyi Bulu-ɔbɔpʋ amʋ asʋ́nsʋ́. Mʋ́ sʋ bɛnatɩ́ yɔ́ wunsɩnɛ́sʋ́ ɩnʋ bakɛ, bʋdɛ ahá atɔ́ suná. Ɔma-ɔma a, Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́tɩ Yudafɔ asʋ́n agyípʋ́ amʋ fɛ́ɛ́ fia. Mʋ́ʋ́ bɔwa abí bɛɛ bʋyɛ́lɛ sumbí ayɔpʋ́ ámʋ ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Támɛ bɔyɔ á, sumbí ayɔpʋ́ ámʋ bʋma ɩnʋ. Ɩ́nɩ sʋ beyinkí bɛbláa ahandɛ amʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Anɩlɔ́yɔ ɩnʋ á, anɩlówun ánɩ́ aklʋn amʋ fin wankláán. Obu adɩpʋ́sʋ́ akɩ́pʋ amʋ bʋlɩɩ́ bʋdɛ aklʋn amʋ ɔnɔ́ gyo. Támɛ brɛ́á anɩléfinkí aklʋn amʋ a, anɩmówun ɔhaa obu ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bulu ɔtswɛ́kpa agyópʋ ɔhandɛ mʋa Bulu igyí ahapʋ́ dɛhɛn amʋ bonu asʋ́n ánfɩ a, bɔbwɛ yɔɔ, sí bʋdɛ asʋ́n ánɩ́ ɩbɛ́ba mʋ́ ɔma gywɩɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ɩnʋ ɔha ɔkʋ lɛ́bɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩkɩ, ahá ámʋ́ʋ́ mlɩlɔ́wa obu ámʋ bʋlɩɩ́ Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, bʋdɛ ahá atɔ́ suná.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mʋ́ sʋ Bulu ɔtswɛ́kpa agyópʋ ɔhandɛ amʋ mʋa mʋ aba bɔyɔ yɛ́kpa sumbí ayɔpʋ́ ámʋ ba. Bɛkpa amʋ́ díín pʋ́ amʋ́ ba, tsúfɛ́ benya ifú ánɩ́ nɩ́ bɔpʋ́ ɩbɩ da amʋ́ á, ahá bɛ́da amʋ́ abwi. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bɔpʋ amʋ́ ba bɛlɩɩ́ Yudafɔ asʋ́n agyípʋ́ amʋ ansɩ́tɔ́. Mʋ́ʋ́ Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Anɩmɛ́da mlɩ ɔlá anɩaa, mlɩmátrá tɩ oyin ánfɩ dá súná atɔ́? Támɛ mlɩkɩ tɔ́á mlɩlabwɛ́. Mlɩlahá mlɩ atosunáhɛ́ labʋ́lá Yerusalem wúlutɔ fɛ́ɛ́. Mlɩdékléá mlɔ́pʋ mʋ lowu sʋ́rá anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petro mʋa sumbí ayɔpʋ́ atráhɛ amʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Bulu asʋ́nsʋ́ lehián ánɩ́ abégyi, megyí anyánkpʋ́sa. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mlɩlɛ́da Yesu mántá oyikpalíhɛsʋ mɔ́ mʋ. Támɛ anɩ anáin Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Olotsu mʋ ya ɔsʋ́sʋ́, pʋ́ mʋ yɛ́yaɩ́ mʋ gyɔpɩsʋ, bwɛ́ mʋ ahá Ɔkpapʋ́ pʋ́ Nkpa Ɔhɔ́pʋ. Fówun ɔkpa ɩdɩ ha Israelfɔ abʋdamli klʋntɔ, Bulu osi amʋ́ lakpan kie amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Anɩgyí alɩ asʋ́n ánfɩ ɩwɩ adansɩfɔ nɩ́. Ɔŋɛ Wankɩ́hɛ́ amʋ́ʋ́ Bulu lɔ́pʋkíé ahá ánɩ́ bʋtegyi mʋ asʋ́nsʋ́ amʋ ɛ́ dɛ́ mʋ́ ɩwɩ adánsɩɛ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Brɛ́á Yudafɔ ahandɛ amʋ bonu asʋ́n ánfɩ á, ɩlɔwa amʋ́ ɔblɔ́. Mʋ́ sʋ bɔbwɛ agywɩɩn bɛɛ, bɔ́mɔ sumbí ayɔpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Támɛ Yudafɔ ahandɛ amʋtɔ ɔkʋá ogyi Farisiyin, mʋ dá gyí Gamaliel, ogyi Mose mbla osunápʋ́ ánɩ́ ahá fɛ́ɛ́ bʋtobú mʋ lɔ́kʋsʋ́ lɩ́ɩ́, blɩ́ ɔbɛ́ɛ bʋkpá sumbí ayɔpʋ́ ámʋ dalɩ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɩnʋ ɔlɛbláa Yudafɔ ahandɛ amʋ ɔbɛ́ɛ, “Israelfɔ ayin, mlɩkɩ wankláán ɩtɔ́ ánfɩ mlɩaa mlɔ́pʋgyi ahá ánfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mlɩkaɩn ánɩ́ brɛ́ kʋtɔ á, oyin ɔkʋá bʋtɛtɩ́ mʋ Teuda létsiá. Ɔlɔbwɛ mʋ ɩwɩ fɛ́ ɔha kpɔnkpɔntɩ ɔkʋ. Mʋ́ sʋ ahá bɔ́bwɛ fɛ́ lafana (400) sɔ́ɔ́n bobuo mʋ. Támɛ bɔmɔ mʋ, mʋ abúopʋ fɛ́ɛ́ bɛdasáɩ́n, mʋ bwɛhɛ́ ɛ́ fɛ́ɛ́ lowie ntsu. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mʋ ɔma a, Yuda ánɩ́ ogyi Galileayin ɛ́ lɛ́ba aháklábɩ. Mʋ ɛ́ ɔlɛkpa ɔdɔm buo ɩwɩ. Támɛ bɔmɔ mʋ, mʋ abúopʋ amʋ fɛ́ɛ́ bɛdasáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, mlɩsi ahá ánfɩ. Mlɩmápʋ ɩbɩ da amʋ́. Tsúfɛ́ nɩ́ itsú anyánkpʋ́sa wá á, mʋ́ fɛ́ɛ́ ɩbɛ́ba bɔtsʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Támɛ nɩ́ itsú Bulu wá á, mlɩmɛ́ɛtalɩ́ ká amʋ́ itin. Mʋ́ sʋ mlɩmábwɛ amʋ́ tɔtɔ, mɛ́nɩ ɩmɔ́ɔbwɛ fɛ́ mlɩa Bulunyɔ mlɩdɛ́kɔ.” Yudafɔ ahandɛ amʋ botsulá dɩ́nká Gamaliel asʋ́n ánfɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɩnʋ bɛha bɛtɩ sumbí ayɔpʋ́ ámʋ ba obuto ɩnʋ. Bɛha bɔnwɛn amʋ́ atɔ́, bɛda amʋ́ ɔlá bɛɛ, bʋmátra tɩ Yesu dá súná atɔ́ ɛkɛkɛɛkɛ, besi amʋ́ bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Brɛ́á sumbí ayɔpʋ́ ámʋ bɛdalɩ Yudafɔ asʋ́n ogyíkpa ɩnʋ bɔyɔ́ á, ansɩ́ dɛ amʋ́ gyí. Tsúfɛ́ Bulu lahá amʋ́ ɛ́ bawun ɩwɩɔsɩn Yesu sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sumbí ayɔpʋ́ ámʋ betsiá súná atɔ́ ekekegyíɛkɛ, dá Bulu asʋn wankláán ámʋ ɔkan Bulu ɔtswɛ́kpa ɩnʋ pʋ́ wóyígyíwóyítɔ́ bɛɛ, Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ). ");
INSERT INTO nkoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Brɛ́á akasɩ́pʋ́ amʋ bɛba bʋdɛklɛɩ́ á, ɩtrɛ́ lɛda Yudafɔ Griiki ablɩ́pʋ́ amʋ́ʋ́ bʋtɛblɩ́ Hebri ɔblɩ́ɩ amʋ nsɩnɛ́. Griiki ablɩ́pʋ́ amʋ bɛɛ, ekekegyíɛkɛ, nɩ́ bʋdɛ atɔ́ yée a, bʋtamahá Griikifɔ asʋrapʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mʋ́ sʋ sumbí ayɔpʋ́ dúanyɔ ámʋ bɛtɩ ahógyipʋ amʋ fɛ́ɛ́ fia, bláa amʋ́ bɛɛ, “Ɩma alɛá abési Bulu asʋ́n ɔkanda betsiá ye atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ɩ́nɩ sʋ apíó, mlɩkɩ mlɩtɔ amlɩlɛ ahá abasíénɔ́ ánɩ́ obú bʋ amʋ́sʋ́, Ɔŋɛ Wankɩ́hɛ́ mʋ́a nyánsa ɩtsɔ amʋ́tɔ́. Fówun apʋ amʋ́ lɩɩ atɔ́tɔ́ yée ɔnɔ́, ");
INSERT INTO nkoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","mɛ́nɩ anɩ ɛ́ abɛ́lɛ ansɩ́ kɩ mpáɩbɔ pʋ́ Bulu asʋ́n ámʋ ɔkanda.” ");
INSERT INTO nkoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ansɩ́ legyi ahógyipʋ amʋ fɛ́ɛ́ asʋ́n ánfɩ ɩwɩ. Mʋ́ sʋ bɛlɛ oyin ɔkʋá mʋ hógyi ɔnɔ́ bʋ ɔnlɩn, Ɔŋɛ Wankɩ́hɛ́ ɛ́ ɩtsɔ mʋtɔ, bʋtɛtɩ́ mʋ Stefano mʋa Filipo, Prokoro, Nikanor, Timon, Parmena pʋ́ Nikolao, ogyi Griikiyin ɔkʋá otsú Antiokia asa alawíé Yudafɔ osúmtɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɔpʋ ahá ánfɩ bosuná sumbí ayɔpʋ́ ámʋ, sumbí ayɔpʋ́ ámʋ ɛ́ bɔpʋ ɩbɩ dɩ́nká amʋ́sʋ́, bɔ́ mpáɩ há amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ɩ́nɩ sʋ Bulu asʋ́n ámʋ lɛklɛɩ́, akasɩ́pʋ́ amʋ bomoní Yerusalem. Bulu igyí ahapʋ́ ámʋ óó tsɔtsɔɔtsɔ bɔhɔ Yesu asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bulu lɔ́wa awɩtɔlɛ há Stefano túmi kpɔnkpɔɔnkpɔntɩ. Mʋ́ sʋ ɔlɔbwɛ ofúla pʋ́ osúna akpɔnkpɔntɩ ɔmá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Támɛ akʋ bɔkʋsʋ́ lɩ́ɩ́ mʋsʋ. Ahá ánfɩ botsú ofíakpa kʋá bʋtɛtɩ́ mʋ́ “Nkpábiá Bahɔ Ɩwɩsʋtsiá.” Amʋ́ akʋ bʋgyi Yudafɔá botsú Kirene pʋ́ Aleksandria awúlusʋ. Akʋ ɛ́ botsú Kilikia pʋ́ Asia ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Támɛ Ɔŋɛ Wankɩ́hɛ́ lɛ́ha Stefano nyánsa ɔlɔpʋtɔ́ɩ́. Mʋ́ sʋ bʋmɛtalɩ́ gyí mʋ nwɛ́ɛn. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ɩ́nɩ sʋ bɛha akʋ ɔnɔ́ bɛɛ bʋblɩ́ bɛɛ, bonu ánɩ́ Stefano dɛ́tɔɩ́ wɔ Mose mʋa Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɩ́nɩ lɛ́ha ahá ánɩ́ bʋbʋ ɩnʋ pʋ́ Yudafɔ ahandɛ pʋ́ Mose mbla asunápʋ́ amʋ benya ɔblɔ́ Stefanosʋ. Ɩnʋ bɛnatɩ́ yɔ́tʋ mʋ, kɩ́tá mʋ, kpá mʋ ya Yudafɔ Asʋ́n Agyípʋ́ amʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bɛlahá akʋ bɔwa afunu dɩ́nká mʋsʋ bɛɛ, “Oyin ánfɩ tɔtɔ́ɩ́ wɔ Bulu ɔtswɛ́kpa wankɩ́hɛ́ pʋ́ Mose mbla ámʋ ekekegyíɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Anɩlónu ánɩ́ ɔdɛblɩ́ ɔbɛ́ɛ, ‘Yesu Nasaretyin amʋ obóbwie Bulu ɔtswɛ́kpa amʋ, tsɛ amándɩ́ɛ́ ánɩ́ Mose lósuná anɩ fɛ́ɛ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yudafɔ Asʋ́n Agyípʋ́ amʋ fɛ́ɛ́ besi bʋdɛ Stefano kɩ́ɩ díín. Ɩnʋ bɛkɩ a, mʋ ansɩ́tɔ́ dɛ ogyá kpa fɛ́ Bulu-ɔbɔpʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bulu igyí ɔhapʋ́ dɛhɛn amʋ lɛ́fɩtɛ́ Stefano ɔbɛ́ɛ, “Asʋ́n ánfɩ bablɩ́ tsú fʋ́ ɩwɩ ánfɩ fɛ́ɛ́ bʋ mʋ́tɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Mɩ́ apíó pʋ́ mɩ́ asɩ́, mlɩyaa asʋ amlɩnu! Bulu Onumnyampʋ amʋ lɛ́lɛ ɩwɩ ɔwan súná anɩ náin Abraham brɛ́á otsie Mesopotamia ɔmátɔ́, Kaldeafɔtɔ asa olotu yétsiá Haran wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","4","Ɩnʋ Bulu lɛ́bláa mʋ ɔbɛ́ɛ, ‘Tu dalɩ fʋ́ ɔmátɔ́ si fʋ́ abusuan, afʋyɔ ɔsʋlʋ́ʋ kʋá nósuná fʋ́sʋ́.’ Mʋ́ sʋ Abraham lótu tsú Kaldeafɔ ɔsʋlʋ́sʋ yétsiá Haran wúlutɔ. Mʋ sɩ lowu ɔma a, Bulu lɛ́ha mʋ olotu ba ɔtɩ́nɛ́ ánfɩ mlɩtsie ndɛ ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Brɛ́ ámʋtɔ á, Bulu mɔ́kʋ́nyá há Abraham ɔsʋlʋ́ʋ anfɩ yabi oyíkpa kʋlɛ kʋ́ráá. Támɛ Bulu lɛ́hɩɛ mʋ asɩ yaɩ́ ɔbɛ́ɛ, mʋa mʋ abí-aná obégyi ɔsʋlʋ́ʋ anfɩ ɛkɛkʋ́. Alɩ brɛ́ ámʋtɔ á, Abraham mɔ́kʋ́kwɩ́ɩ́ obí. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Asʋ́n ánɩ́ Bulu lɛ́bláa mʋ gyí, ‘Fʋ́ abí-aná bɔ́bwɛ afɔɔ́ ɔsʋlʋ́ʋ kʋsʋ. Bɔ́pʋ amʋ́ bwɛ́ nkpábi, wá amʋ́ amʋmʋyɔ nfí lafana (400). ");
INSERT INTO nkoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Támɛ négyi ɔmá ámʋ́ʋ́ fʋ́ abí-aná béyetsiá amʋ́ asɩ ámʋ asʋ́n, bɩ́tɩ́ amʋ́ ɩsʋ. Mʋ́ ɔma a, nɛ́lɛ amʋ́ lɛ́ amʋ́ ɩbɩtɔ, fówun bɛ́ba bosúm mɩ́ nfɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bulu lɛ́ka ntam há Abraham. Ntam amʋ ɔnɔ́ á, Abraham ɔbɛ́tɩn mʋ abí-aná keté. Mʋ́ sʋ mʋ bi Isak lɔ́hɔ nkekwé á, Abraham lɛ́tɩn mʋ keté. Isak ɛ́ lɛ́tɩn mʋ bi Yakob keté. Yakob ɛ́ lɛ́tɩn mʋ abí, bʋgyi anɩ anáin dúanyɔ ámʋ keté amʋ́ nyebitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Anɩ anáin anfɩ bɛfɛ amʋ́ gyama Yosef, mʋ ɩwɩ olu sʋ. Mʋ́ sʋ ɔlɔyɔ yɛ́bwɛ ɔkpábi Egyipte ɔmátɔ́. Támɛ Bulu lɛ́lɩɩ́ mʋ ɔma, ");
INSERT INTO nkoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","lɛ́ mʋ lɛ́ mʋ asʋn wunhɛ fɛ́ɛ́tɔ́. Bulu lɛ́ha mʋ nyánsa, há Egyipte owíe lénya mʋ ɩwɩ ansigyí. Mʋ́ sʋ ɔlɔbwɛ Yosef mʋ ɔmá pʋ́ mʋ wóyí fɛ́ɛ́sʋ́ ɔkɩ́pʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Akʋ́n kʋ lɛ́bá Egyipte pʋ́ Kanaan ɔsʋlʋ́sʋ fɛ́ɛ́. Ɩlɔpʋ ɩkplán ba ɔmá ámʋtɔ. Anɩ anáin amʋ bʋmenyá atɔ́ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mʋ́ sʋ brɛ́á Yakob lónu ánɩ́ atogyihɛ bʋ Egyipte a, ɔlɔwa anɩ anáin anfɩ sɩ́sɩ́. Bɔyɔ ɩnʋ ɛkɛ gyankpapʋ yénya atogyihɛ ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Beyinkí yɔ́ otse nyɔɔsɩ a, Yosef lɛ́lɛ ɩwɩ ɔwan súná amʋ́ ɔbɛ́ɛ, mʋgyí amʋ́ gyama Yosef nɩ. Ɩ́nɩ sʋ Egyipte owíe ɛ́ lɛ́bɩ Yosef abusuan. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mʋ́ ɔma a, Yosef lɔ́wa mʋ apíó sɩ́sɩ́ ɔbɛ́ɛ, bʋyɛ́kpa mʋ sɩ Yakob pʋ́ mʋ abusuanfɔ, bɔ́bwɛ fɛ́ ahá aduesienɔ́-nu (75) ba, abʋbetsiá Egyipte ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ɩnʋ Yakob lɔ́yɔ Egyipte. Ɩnʋ́ mʋa anɩ anáin amʋ bowu nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nfí tsɔtsɔɔtsɔ ɔma a, bɔpʋ amʋ́tɔ́ akʋ afúli ya Sekem. Wúlu anfɩtɔ Abraham légyankpá tsíá nɩ́. Bopulá amʋ́ ɩlán kʋá Abraham lɔ́pʋ kɔ́ba hɔ tsu oyin ɔkʋá bʋtɛtɩ́ mʋ Hamor abí wátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nkɛ ámʋ́ʋ́ Bulu lɛ́hɩɛ Abraham amʋ lotsutsúa ɩbɔfʋn a, anɩ anáin amʋ baklɛ́ɩ́ wá Egyipte ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ɔma a, Egyipte owíe ɔkʋá ɔmɛbɩ Yosef lébetsiá obíá ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Owíe anfɩ lɔ́wa owuntɔlɩn anɩ anáin amʋsʋ. Ɔlɛka amʋ́ hɩ́ɛ́ ɔbɛ́ɛ, bʋtswɩ́ɩ amʋ́ abi bɔbwɛ tsalɩfwɩ abʋwu. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Alɩ brɛ́ ámʋtɔ bɔkwɩɩ́ Mose nɩ. Ogyi obí ánɩ́ ɔhɩ́ɛ́ ɔbʋ akɩ́lɛ, Bulu ansɩ́ legyi mʋ ɩwɩ. Mʋ yin lɛ́yaɩ́ mʋ tsra asa mʋ sɩ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Brɛ́á bɛlɛ mʋ mʋ wóyítɔ́ a, Farao mʋ bi tsɩ́hɛ́ lótsu mʋ, pʋ́ mʋ bwɛ́ mʋ bi alɩɩ, ɔlɛdan. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egyiptefɔ bosuná Mose amʋ́ amándɩ́ɛ́ kugyíkʋ. Ɔlɔbwɛ ɔha kpɔnkpɔntɩ mʋ ɩtɔ́ɩ pʋ́ mʋ bwɛhɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Brɛ́á Mose lɔ́hɔ nfí adʋana (40) á, ɔlɔbwɛ agywɩɩn ɔbɛ́ɛ, mɔ́yɔ yɛ́kɩ alɩá Egyiptefɔ bɔpʋ bʋdɛ mʋ apíó Israelfɔ kpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɩnʋ á, olowun ánɩ́ Egyipteyin dɛ́ mʋ apíó Israelfɔ ámʋtɔ ɔkʋ da. Mʋ́ sʋ ɔlɔyɔ ɔyɔ́hɔ mʋ pio ámʋ́ʋ́ ɩdɛ mʋ dʋ́ʋn amʋ, ilemlí mʋa Egyipteyin amʋ nyɔ. Ɩnʋ ɔlɛda Egyipteyin ámʋ mɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose mʋ́ kɩ ɔbɛ́ɛ, ɩbɔ́wankɩ́ mʋ apíó Israelfɔ ánɩ́ Bulu dɛ́pʋ mʋ hɔ amʋ́ nkpa, támɛ ɩmɔwankɩ́ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mʋ́ ɔyɩ kɛhɛ a, olowun Israelfɔ abanyɔ́ bʋdɛkɔ. Ɔlɔyɔ ɔyɛ́kpatá amʋ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, ‘Mlɩkɩ, apíó mlɩgyí. Ntogyi sʋ́ mlɩ wʋlɛwʋlɛ mlɩdɛ́ aba amʋmʋyɔ wa?’ ");
INSERT INTO nkoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Támɛ ɔmʋamʋ́ʋ́ ɔdɛ mʋ ba da ámʋ lówutá Mose sɩ́sɩ́, fɩ́tɛ́ mʋ ɔbɛ́ɛ, ‘Ma lɔ́wa fʋ́ ɔbɛ́ɛ fʋbégyi anɩsʋ, afʋgyi anɩ nsɩnɛ́ asʋ́n? ");
INSERT INTO nkoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fʋdekléá fɔ́mɔ mɩ́, fɛ́ alɩ ámʋ́ʋ́ ígye fɔmɔ Egyipteyin amʋ lóó?’ ");
INSERT INTO nkoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose lénya nú asʋ́n ánfɩ alɩ, ɔlɛsrɩ́ dalɩ Egyipte ɔmátɔ́ yɔ́ Midiafɔ ɔsʋlʋ́sʋ. Oletsiá ɩnʋ kwɩ́ɩ́ abi anyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nfí adʋana ɔma a, Bulu-ɔbɔpʋ lɛ́lɛ ɩwɩ ɔwan súná Mose dimbísʋ́ oyíbi kʋá ɩbʋ awu, ogyá detsií mʋ́tɔ́tɔ́, mantáa Sinaibʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose lówun mʋ́ á, ɩlɔwa mʋ ifú. Brɛ́á ɔlɔkpʋkpɛ́ ɔyɔ́ yɛ́kɩ mʋ́ wankláán á, Bulu lɛ́bláa mʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɩ́gyí fʋ́ anáin Abraham, Isak pʋ́ Yakob Bulu.’ Mose lénya ifú, ɔdɛkpɩnkɩ́ kpakpakpakpa. Mʋ́ sʋ ɔmɛtalɩ́ kɩ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Anɩ Wíe Bulu lɛ́bláa mʋ ɔbɛ́ɛ, ‘Wɔɩ fʋ́ ntʋkʋta tswɩ, tsúfɛ́ ɔtɩ́nɛ́ ánfɩ fʋlɩɩ́ ánfɩ igyi ɔtɩnɛ wankɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nawun ánɩ́ mɩ́ ahá bʋdɛ ɩwɩɔsɩn wúun Egyipte ɔsʋlʋ́sʋ. Nanú amʋ́ isú. Mʋ́ sʋ nakplɩ́ nɛbá bɔhɔ amʋ́. Ba, anwa fʋ́ Egyipte.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose anfɩ́ Israelfɔ bekiná Egyipte ɔmátɔ́, fɩ́tɛ́ mʋ bɛɛ, ‘Ma lɔ́wa fʋ́ ɔbɛ́ɛ fʋbégyi anɩsʋ, afʋgyi anɩ nsɩnɛ́ asʋ́n?’ nɩ́. Mose anfɩ kɛ́n Bulu lɛ́ha ɔbɛ́ɛ, ɔbwɛ́ɛ anɩ anáin amʋ́sʋ́ ogyípʋ́ pʋ́ amʋ́ ɔlɛpʋ́ nɩ́. Bulu lɔ́wa mʋ sumbí ánfɩ tsʋn Bulu-ɔbɔpʋ amʋ́ʋ́ ɔlɛlɛ ɩwɩ súná mʋ ogya plɛnplɛntɔ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mʋ kɛ́n gyí ɔhá ánɩ́ ɔlɛkpa amʋ́ dalɩ Egyipte, bwɛ́ ofúla pʋ́ osúna tsɔtsɔɔtsɔ Egyipte ɔsʋlʋ́sʋ, Ɔpʋ Pɛpɛ amʋ ɔnɔ́ pʋ́ dimbí ámʋsʋ nfí adʋana (40) kɛ́kɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mʋ kɛ́n lɛ́bláa Israelfɔ ámʋ ɔbɛ́ɛ, ‘Bulu ɔbɛ́lɛ mʋ ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋá ogyi fɛ́ mɩ́ tsú mlɩtɔ há mlɩ’ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Brɛ́á mʋa Israelfɔ ámʋ befia dimbí ámʋsʋ á, Mose anfɩsʋ Bulu-ɔbɔpʋ amʋ lɔ́tɔɩ́ tsʋn Sinaibʋ ámʋsʋ há anɩ anáin amʋ nɩ. Mʋ kɛ́nsʋ́ Bulu lɔ́pʋ mʋ nkpa asʋ́n ámʋ tsʋn, ɩdɛ anɩ ɛ́ tʋ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Támɛ anɩ anáin bʋmobu mʋ. Bekiná mʋ asʋ́n nu. Amʋ́ nkʋlɛ sʋ mʋ́ á, tɛkɩ bʋtráa bʋbʋ Egyipte ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɩ́nɩ sʋ bɛbláa Aaron bɛɛ, ɔyáɩ ɩkpɩ ánɩ́ bɛ́kpa amʋ́ ha amʋ́. Tsúfɛ́ bʋmeyín tɔ́á ɩlabwɛ́ Mose amʋ́ʋ́ ɔlɛkpa amʋ́ tsú Egyipte amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Alɩ brɛ́ ámʋtɔ á, bɛblɩ́ sika pɛpɛ ɔnantswiebí pʋ́bwɛ́ ɔkpɩ, tsíá há mʋ́ igyí. Amʋ́ ansɩ́ legyi amʋ́ ɩbɩ ɔnɔ́ ɩtɔ bwɛhɛ́ ánfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bulu lési amʋ́ asʋ́n, bɔyɔ bʋdɛ owí mʋ́a ɔtsra pʋ́ ntsrakpabi tswɛ́ɛ. Fɛ́ alɩá bɔwanlɩ́n wá Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ ɔwʋlʋ́tɔ́ bɛɛ, ‘Israelfɔ! Megyí mɩ́ mlɩlɔ́mɔ mbwɩ bɔ́ afɔdɩɛ há nfí adʋana (40) ámʋ́ʋ́ mlɩlétsiá dimbí ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mboún ɔkpɩ Molok tati-obu pʋ́ Refan ntsrakpabi ɔkpɩ mlɩlɔ́bwɛ sʋ́rá, nátɩ́ tswɛ. Ɩ́nɩ sʋ négya mlɩ yɔ́wa Babilonfɔ ɔsʋlʋ́ʋ ɔma ɔtɩnɛkʋ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tati-obu ámʋ́ʋ́ itosúná amʋ́ ánɩ́ Bulu bʋ amʋ́ wá ámʋ ɛ́ letsiá anɩ anáin amʋ wá dimbí ámʋsʋ. Mose lɔ́bwɛ mʋ́ alɩá Bulu lósuná mʋ ɔbɛ́ɛ, ɔbwɛ́ɛ mʋ́ pɛ́pɛ́ɛ́pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Anɩ anáin amʋ bowu sí Bulu tati-obu ámʋ há anɩ asɩ́, Yosua légya amʋ́ nkpá bɔpʋba ɔsʋlʋ́ʋ anfɩsʋ. Amʋ́ onutó ansɩ́tɔ́ Bulu légya ɔmá-ɔmá lɛ́ ɔsʋlʋ́ʋ anfɩsʋ pʋ́há amʋ́. Bulu tati-obu ámʋ letsiá amʋ́ wá alɩɩ bɔtʋ Owíe Dawid brɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Bulu ansɩ́ legyi Owíe Dawid ɩwɩ. Mʋ́ sʋ Dawid lɔ́kʋlɩ́ mʋ ɔbɛ́ɛ, mʋyíi obu ha mʋ, mɛ́nɩ anɩ Yakob abí-aná fɛ́ɛ́ abósum mʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Támɛ Owíe Salomo mboún lébeyi obu ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Támɛ Ɔsʋ́sʋ́ʋ́sʋ́ Bulu tamatsíá nyankpʋsa obu yihɛtɔ. Fɛ́ alɩá Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔkʋ lɛ́blɩ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Anɩ Wíe Bulu ɔbɛ́ɛ, “Ɔsʋ́sʋ́ gyí mɩ́ owíe obíá, ɔsʋlʋ́ʋ ɛ́ igyi mɩ́ ayabi oyíkpa. Ntɔ obu mlɩaa mléyi ha mɩ́? Nkʋ́nʋ gyí mɩ́ ɔkpʋ́nʋ́ ɔdakpá? ");
INSERT INTO nkoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Megyí mɩ́ lɔ́bwɛ ntobí ánfɩ fɛ́ɛ́?” ’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefano lɔ́mɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Asʋtɔ-ɔnlɩn awíé, klʋntɔ bʋ mlɩ odwin. Mlɩlakíná Bulu asʋ́n ámʋ nu. Mlɩ ɛ́ mlɩtɔkʋ́sʋ́ lɩ́ɩ́ Ɔŋɛ Wankɩ́hɛ́ amʋ asʋ́nsʋ́ brégyíbrɛ́, fɛ́ alɩá mlɩ anáin amʋ betsiá bwɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ ɔmɔmʋsʋ́ mlɩ anáin bʋmɛdɩnká? Bɔmɔ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ́ʋ́ bɛblɩ́ yáɩ́ bɛɛ, Yilé Ɔbwɛpʋ́ ámʋ ɔbɛ́ba amʋ ɛ́. Mlɩlɛ́lɛ Yilé Ɔbwɛpʋ́ ámʋ há, bɔmɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mlɩlɔ́hɔ Mose mbla ámʋ tsú Bulu-abɔpʋ ámʋ wá nɩ́, támɛ mlɩmégyi mʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Brɛ́á Yudafɔ ahandɛ amʋ bonu Stefano asʋn blɩ́hɛ́ anfɩ á, ɔblɔ́ lɛhɩɛ kɩ́tá amʋ́, bɛda ansɩ́tɔ́ kpʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Támɛ Ɔŋɛ Wankɩ́hɛ́ lɔ́bʋlá Stefanotɔ, olotsu ansɩ́ fʋ́á, ɔdɛ ɔsʋ́sʋ́ kɩ́ɩ. Olowun Bulu numnyam, Yesu lɩ́ɩ́ Bulu gyɔpɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩkɩ, nawun ánɩ́ ɔsʋ́sʋ́ lafínkí, Nyankpʋsa-Mʋ-Bi ámʋ lɩ́ɩ́ Bulu gyɔpɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Brɛ́á bonu ɩ́nɩ á, bɔpʋ ɩbɩ tin asʋ. Ɩnʋ amʋ́ fɛ́ɛ́ bɔsʋrá okitikíti tú bun mʋsʋ, ");
INSERT INTO nkoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bɛbɩtɩ́a mʋ dalɩ wúlu amʋtɔ bɛyɛ́da mʋ abwi mɔ́. Adansɩfɔ ámʋ bɔwɔɩ́ amʋ́ awunso atadɩɛ tswɩ ɔyasubi ɔkʋá bʋtɛtɩ́ mʋ Saulo wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bʋdɛ mʋ abwi da alɩɩ, olokpolí anɩ Wíe ɔbɛ́ɛ, “Mɩ́ Wíe Yesu, hɔ mɩ́ ɔŋɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ɩnʋ á, ɔlɛda akpawunu, kplʋ́n kʋklʋ́kʋ́ʋ́ ɔbɛ́ɛ, “Mɩ́ Wíe, si lakpan ánfɩ kie amʋ́.” Olenya blɩ́ alɩ pɛ́, olomu ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ɛ́ lótsulá dɩ́nká Stefano mɔsʋ. Tsú ɛkɛ ámʋsʋ á, bɛdɩnká ɔpasua ámʋ́ʋ́ ɩbʋ Yerusalem amʋsʋ, wá amʋ́ mɔ bɩ. Mʋ́ sʋ ɔpasua ámʋ fɛ́ɛ́ bɛdasáɩ́n wá Yudea pʋ́ Samaria ɔmátɔ́, sí sumbí ayɔpʋ́ ámʋ nkʋlɛ pɛ́ wá ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Támɛ Bulu asúmpʋ́ akʋ bosu Stefano, bɩn mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo mʋ́ léfi ɔpasua ámʋ bwie asɩ. Oletsiá kí ahá wóyítɔ́, bɩ́tɩ́a ahógyipʋ atsɩ mʋ́a ayin fɛ́ɛ́ yɔ́wa obu. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ahógyipʋ amʋ bɛda Bulu asʋn wankláán ámʋ ɔkan ɔtɩ́nɛgyíɔtɩ́nɛ́ ánɩ́ bɛdasáɩ́n yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mʋ́ sʋ Filipo lɔ́yɔ Samaria wúlu yilé kʋtɔ yɛ́bláa amʋ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) ɩwɩ asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Afíapʋ amʋ fɛ́ɛ́ bonu mʋ asʋn blɩ́hɛ́, bowun osúna ánɩ́ ɔlɔbwɛ ɛ́. Mʋ́ sʋ bɔhɔ mʋ asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɔŋɛ laláhɛ lɔ́sʋrá okitikíti dálɩ ahá tsɔtsɔɔtsɔtɔ. Ahá ánɩ́ amʋ́ ɩfʋ́n lawú pʋ́ tsukʋlɛ asínpʋ tsɔtsɔɔtsɔ ɛ́ benya ɩlɔtsá. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mʋ́ sʋ ansɩ́ lɛhɩɛ gyi Samariafɔ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Alɩ brɛ́ ámʋtɔ á, ɔfápʋ́ kpɔnkpɔntɩ ɔkʋá bʋtɛtɩ́ mʋ Simon bʋ wúlu amʋtɔ. Brɛ́á Filipo mɔ́kʋ́ba ɩnʋ á, ɔtɔbwɛ́ túmila súná mʋ pɩ amʋ, ɩtɔwá amʋ́ ifú. Ɔtɔpʋ́ ɩbɩ sí kántɔ́ blɩ́ ɔbɛ́ɛ, otúmípʋ kpɔnkpɔntɩ mʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nyebí ahandɛ fɛ́ɛ́ bʋtobú mʋ, blɩ́ bɛɛ, “Oyin ánfɩ dɛ́ Bulu túmi kpɔnkpɔntɩ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɩ́nɩá ɔdɛpʋ mʋ asuma bwɛ́ ofúla suná amʋ́, ɩlawá ɔpá sʋ á, amʋ́ fɛ́ɛ́ bɔhɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Támɛ brɛ́á Filipo lɛ́ba bɛda Bulu iwíegyí pʋ́ Yesu Kristo ɩwɩ asʋn wankláán ámʋ ɔkan a, atsɩ mʋ́a ayin bɔhɔ mʋ asʋ́n ámʋsʋ gyi, ɔlɔbɔ amʋ́ asú. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon onutó ɛ́ lóhogyi, ɔlɛha Filipo lɔ́bɔ mʋ asú. Mʋ asúbɔ ɔma a, ɔlɔpʋ ɩwɩ mantáa Filipo. Brɛ́á olowun alɩá Filipo dɛ́ ofúla mʋ́a osúna bwɛ á, ɔnɔ́ lobwie mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sumbí ayɔpʋ́ ámʋ́ʋ́ bʋbʋ Yerusalem amʋ bonu ánɩ́ Samariafɔ bahɔ Bulu asʋ́n ámʋ. Mʋ́ sʋ bɔwa Petro mʋa Yohane amʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Brɛ́á boyówie ɩnʋ á, bɔbɔ mpáɩ há Samariafɔ ahógyipʋ amʋ bɛɛ, bʋnyáa Ɔŋɛ Wankɩ́hɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsúfɛ́ asú kɛkɛ babɔ́ amʋ́ anɩ Wíe Yesu dátɔ́, támɛ amʋ́tɔ́ ɔkʋkʋ mɔ́kʋ́nyá Ɔŋɛ Wankɩ́hɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ɩnʋ Petro mʋa Yohane bɔpʋ ɩbɩ dɩ́nká amʋ́ nwunsʋ, Bulu lɛ́ha amʋ́ Ɔŋɛ Wankɩ́hɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon lówun ánɩ́ ɩbɩ kɛkɛ sumbí ayɔpʋ́ amʋ bapʋ́ dɩ́nká ahógyipʋ amʋ nwunsʋ, Bulu lahá amʋ́ Ɔŋɛ Wankɩ́hɛ́. Mʋ́ sʋ ɔlɛlɛ kɔ́ba há Petro mʋa Yohane, ");
INSERT INTO nkoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩha mɩ́ túmi ánfɩ kʋ, mɛ́nɩ nɩ́ mɩ́ ɛ́ nɔpʋ́ ɩbɩ dɩ́nká ɔkʋ nwunsʋ á, Bulu ɔbɛ́ha mʋ Ɔŋɛ Wankɩ́hɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Támɛ Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́a fʋ́ kɔ́ba ámʋ nyɔ fɛ́ɛ́ mlɩhɩ. Tsúfɛ́ fʋkɩ fɛɛ, fɛ́talɩ́ pʋ́ kɔ́ba hɔ Bulu itokiehɛ́ ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fʋma ogyíkpá ntɛ́ɛ ɔlɩɩ́kpá anɩ gyumagyihɛ anfɩtɔ, tsúfɛ́ fʋ́ klʋntɔ mɛtɩn Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Damli klʋntɔ tsu fʋ́ lakpan ánfɩtɔ, afʋkʋlɩ anɩ Wíe Bulu. Fíalɩ obési agywɩɩn laláhɛ anfɩ́ fabwɛ́ ánfɩ kíé fʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tsúfɛ́ nawun ánɩ́ fʋhɩ́ɛ́ fʋ́bʋ ɔnsɩpɛ, lakpan lagyi fʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon lɛ́bláa Petro mʋa Yohane ɔbɛ́ɛ, “Nobwíí ɩpa, mlɩkokoli mlɩ Wíe Bulu ha mɩ, mɛ́nɩ ɔmɛ́ɛha asʋ́n ánfɩ fablɩ́ ánfɩtɔ kʋkʋ mɛ́ɛba mɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Brɛ́á Petro mʋa Yohane begyi adánsɩɛ, dá Yesu ɩwɩ asʋ́n ámʋ ɔkan tá á, beyinkí yɔ́ Yerusalem. Brɛ́á bʋna bɔyɔ́ á, bɛda asʋn wankláán ámʋ ɔkan Samaria nkuda tsɔtsɔɔtsɔ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Alɩ brɛ́ ámʋtɔ á, Bulu-ɔbɔpʋ lɛ́bláa Filipo ɔbɛ́ɛ, “Kʋsʋ pʋ ɔsaasɩ́ dimbísʋ́ ɔkpa ámʋ́ʋ́ ɩda tsu Yerusalem ɩyɔ́ Gasa amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mʋ́ʋ́ Filipo lɔ́kʋsʋ́ pʋ́ ɔkpa. Brɛ́á ɔyɔ́ á, ɔlɔtʋ Etiopia ɔmá ɔhandɛ ɔkʋá baflo mʋ. Ɔhandɛ amʋ gyí Etiopia owíe tsɩhɛ́ Kandake sikasʋ ɔkɩ́pʋ. Oyin ánfɩ layɔ́ Yerusalem yósum Bulu, ");
INSERT INTO nkoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yínkí ɔyɔ́ wóyí, otsie mʋ kekétɔ́, mpɔnkɔ bʋdɛ mʋ bɩtɩ́. Ɔdɛ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia ɔwʋlʋ́ ámʋ kláa. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mʋ́ʋ́ Ɔŋɛ Wankɩ́hɛ́ lɛ́bláa Filipo ɔbɛ́ɛ, “Kpʋkpɛ manta keké ánfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo lɛ́srɩ́ tʋ́ keké ámʋ wun ánɩ́ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaia ɔwʋlʋ́ ámʋ oyin ámʋ dɛ́ kláa. Mʋ́ sʋ ɔlɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Ɔhandɛ, fʋdɛ asʋ́n ámʋ́ʋ́ fʋdɛkláa amʋ asɩ nu?” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɔhandɛ amʋ lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Nkálɩ ɩbɔ́bwɛ nónu mʋ́ asɩ nɩ́ ɔkʋ mɛ́lɛ mʋ́ asɩ súná mɩ́?” Mʋ́ sʋ ɔlɛbláa Filipo ɔbɛ́ɛ, “Dʋ tsia mɩ́ wá ayɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bulu asʋ́n ánɩ́ ɔdɛkláa ɔwʋlʋ́ ámʋtɔ gyí: “Ɔlɔbwɛ díín fɛ́ kufa ánɩ́ bapʋ́ bɛya ɔmɔkpá. Ɔmobwií mʋ nnonyɔ. Ɔlɔbwɛ díín fɛ́ alɩá kufa tɔbwɛ́ nɩ́ bʋdɛ mʋ ɩwɩ imi dɩnkɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɔkpɔɩ́ mʋ, bʋmegyi mʋ asʋ́n ɔnɔkwalɩsʋ. Ɔhaa mɛ́ɛtalɩ́ súná mʋ abí-aná, tsúfɛ́ bɛka mʋ nkpa tin ɔsʋlʋ́ʋ anfɩsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mʋ́ʋ́ ɔmá ɔhandɛ amʋ lɛ́fɩtɛ́ Filipo ɔbɛ́ɛ, “Ma ɩwɩ asʋ́n Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ anfɩ dɛ́blɩ́, mʋ onutó ntɛ́ɛ ɔha bambá?” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ɩnʋ Filipo lɛ́lɩɩ́ Yesaia asʋn wanlɩ́nhɛ́ anfɩsʋ bláa mʋ Yesu ɩwɩ asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Bɔpʋ bɔyɔ́ á, bɔtʋ ntsu kʋ. Mʋ́ʋ́ ɔmá ɔhandɛ amʋ lɛ́fɩtɛ́ Filipo ɔbɛ́ɛ, “Ntsu dá a, ntɔ létin mɩ́ asúbɔ ɔkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mʋ́ sʋ ɔmá ɔhandɛ amʋ lɛ́ha mʋ keké ámʋ ɔbɩtɩ́pʋ́ lɛ́lɩɩ́. Mʋa Filipo bɛkplɩ́ wíé ntsu ámʋtɔ, Filipo lɔ́bɔ mʋ asú. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Brɛ́á bɛdalɩ ntsu ámʋtɔ á, anɩ Wíe Ɔŋɛ́ lotsu Filipo nátɩ́. Ɔmá ɔhandɛ amʋ mɛ́trá wun mʋ, támɛ ɔlɔpʋ ansigyí natɩ́ ɔyɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo ɛ́ lɛ́yɛdalɩ Asoto wúlutɔ. Ɔlɛnatɩ́ kí ɩnʋ awúlusʋ dá asʋn wankláán ámʋ ɔkan alɩɩ, oloyówie Kaesarea wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Alɩ brɛ́ ánfɩtɔ fɛ́ɛ́ á, Saulo mɔ́kʋ́sí Yesu akasɩ́pʋ́ amʋ bláa ɔbɛ́ɛ, mɔ́mɔ amʋ́. Mʋ́ sʋ ɔlɔyɔ Bulu igyí ɔhapʋ́ dɛhɛn wá yɔ́kʋlɩ́ mʋ ɔbɛ́ɛ, ɔwánlɩn ɔwʋlʋ́ pʋlɛ mʋ suna Damasko Yudafɔ ofíakpa ahandɛ, mɛ́nɩ nɩ́ mʋ ɩbɩ da oyin ntɛ́ɛ ɔtsɩ ɔkʋ, ɔna anɩ Wíe ɔkpa ámʋsʋ a, mɛ́kɩtá mʋ, kpá mʋ ba Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo lɔ́pʋ ɔkpa ɔyɔ́ Damasko. Ɔlɛta wie tá á, nsaɩntɔ lɛkpa ogyá wa mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɔlɛdɩda ɔsʋlʋ́tɔ kpla. Ɩnʋ olonu ɔmɛ kʋ. Ɔmɛ amʋ lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Saulo, Saulo, ntogyi sʋ́ fʋ́dɩn mɩ́sʋ́ alɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo lɛ́fɩtɛ́ ɔbɛ́ɛ, “Fʋ́ ma nɩ, mɩ́ Wíé?” Mʋ́ʋ́ ɔmɛ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ Yesu nɩ. Mɩ́sʋ́ fʋdɩn nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kʋsʋ, afʋyɔ wúlutɔ ɩnʋ. Ɔkʋ obósuná fʋ́ tɔ́á lehián ánɩ́ fɔ́bwɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo aba ánɩ́ mʋa amʋ́nyɔ bʋna besi lɩ́ɩ́ díín. Bonu ɔmɛ amʋ, támɛ bʋmowun ɔhaa. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo lɔ́kʋsʋ́ lɩ́ɩ́. Olobwií ansíbi, támɛ ɔmɛdɛ́ atɔ́ wúun. Mʋ́ sʋ bɛkɩtá mʋ ɩbɩ, kpá mʋ ya Damasko wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oletsiá nkɛnsá owítɔ́ omowun atɔ́. Omegyi atɔ́, omonu tɔtɔ ɛ́ alɩ brɛ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Alɩ brɛ́ ámʋtɔ á, Yesu ɔkasɩ́pʋ́ ɔkʋ bʋ Damasko, bʋtɛtɩ́ mʋ Anania. Olowun atɔ́. Mʋ́tɔ́ á, anɩ Wíe Yesu lókpolí mʋ ɔbɛ́ɛ, “Anania!” Olotsulá ɔbɛ́ɛ, “Mɩ́ Wíé, mɩ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mʋ́ʋ́ anɩ Wíe lɛ́bláa mʋ ɔbɛ́ɛ, “Kʋsʋ, yɔ brɔnʋ ámʋ́ʋ́ bʋtɛtɩ́ mʋ́ ‘Ɔkpa Tswííhɛ́’ amʋsʋ. Wie Yuda wóyítɔ́, afʋfɩtɛ oyin ámʋ́ʋ́ otsú Tarso, bʋtɛtɩ́ mʋ Saulo amʋsʋ. Alaba, ɔbʋ ɩnʋ ɔdɛ mpáɩ bɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Alawun ánɩ́ oyin ɔkʋá bʋtɛtɩ́ mʋ Anania laba bɔpʋ ɩbɩ dɩ́nká mʋsʋ, mʋ ansíbi labwíí.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mʋ́ʋ́ Anania lɛ́bláa anɩ Wíe ɔbɛ́ɛ, “Mɩ́ Wíé, nanú oyin ánfɩ ɩwɩ asʋ́n. Alɩá ɔdɛpʋ lalahɛ gyi fʋ́ ahá ánɩ́ bʋbʋ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Igyí ahapʋ́ dɛhɛn amʋ ɛ́ bahá mʋ túmi bɛɛ, ɔbá Damasko bɛkɩtá ahá ánɩ́ bʋtɔbɔ́ mpáɩ fʋ́ dátɔ́ fɛ́ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Anɩ Wíe lɛ́bláa mʋ ɔbɛ́ɛ, “Yɔ, mɩ́lalɛ́ mʋ mbɛ́ɛ, ɔbwɛ́ɛ mɩ́ osúmpʋ́, ɔha ɔmá bámbátɔ́fɔ, amʋ́ awíe pʋ́ Israelfɔ fɛ́ɛ́ abʋbɩ mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɩ́ onutó nósuná mʋ alɩá ɔbɔ́kʋkʋ wun ipian mɩ́ sʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mʋ́ sʋ Anania lɔ́yɔ Yuda wóyítɔ́, yɔ́pʋ ɩbɩ dɩ́nká Saulosʋ, bláa mʋ ɔbɛ́ɛ “Opíó Saulo, anɩ Wíe Yesu amʋ́ʋ́ ɔlɛlɛ ɩwɩ ɔwan súná fʋ́ brɛ́ ámʋ́ʋ́ fɛbá nfɩ ámʋ láwá mɩ́ fʋ́ wá. Ɔbɛ́ɛ, mbɛha fʋ́ afʋlawun atɔ́, Ɔŋɛ Wankɩ́hɛ́ ɔbʋla fʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tɔkʋá igyi fɛ́ klɛmɛtɩ́ afwɩ lɛ́maɩ́n lɛ́ mʋ ansíbisʋ kpádá ɩnʋnʋ. Mʋ́ sʋ ɔlɛla ɔdɛ atɔ́ wúun. Ɩnʋ ɔlɔkʋsʋ́, bɔbɔ mʋ asú. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bɛha mʋ atɔ́ olegyi, ɔwʋnlɩ́n lɛlawíé mʋ. Saulo létsiá akasɩ́pʋ́ amʋ wá nkɛ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ɩnʋnʋ ɔlɛnatɩ́ yɔ́ amʋ́ ofíakpa, yéfi Yesu ɩwɩ asʋ́n ɔkan da asɩ ɔbɛ́ɛ, “Yesu gyí Bulu mʋ bi ámʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ahá ánɩ́ bonu mʋ asʋn blɩ́hɛ́ anfɩ fɛ́ɛ́ ɔnɔ́ lobwie amʋ́. Mʋ́ sʋ bɛfɩtɛ́ bɛɛ, “Megyí mʋdɛ́ Yesu asúmpʋ́ mɔ Yerusalem nɩ? Megyí amʋ́ ɔkɩtákpá ɔlɛba nfɩ, ɔkpa amʋ́ ya igyí ahapʋ́ dɛhɛn amʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Támɛ Saulo lɛ́lanyá túmi blɩ́ asʋ́n ámʋ ɔwʋnlɩ́nsʋ́ ɔbɛ́ɛ, lɛ́lɛ́ Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ). Alɩá ɔlɛhɩɛ lɛ́ asʋ́n ámʋtɔ lɛha Yudafɔ ánɩ́ bʋbʋ Damasko ɩnʋ bɔbwɛ basaa. Bʋmowun mʋ́á bótsu. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nkɛ tsɔtsɔɔtsɔ ɔma a, Yudafɔ ámʋ befia kɩ́tá agywɩɩn bɛɛ bɔ́mɔ Saulo. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mʋ́ sʋ betsiá gyo wúlu amʋ ɔnɔ́ ɔpa onyé, mɛ́nɩ bénya mʋ mɔ́ mʋ. Támɛ akʋ bowi tsá Saulosʋ bɛɛ, alɩ́ Yudafɔ ámʋ babwɛ́ agywɩɩn nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mʋ́ sʋ ɛkɛ ɔkʋ onyé á, Saulo abúopʋ amʋtɔ akʋ botsu mʋ wá lakpátɔ́, pʋ́ mʋ tsʋn ikwitɔ kplɩ́ mʋ yi ɩban ɔma, ɔlɛsrɩ́ nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Brɛ́á Saulo lówie Yerusalem a, ɔlɔtsʋn ɔkpa kugyíkʋsʋ ánɩ́ obówie Yesu akasɩ́pʋ́ amʋtɔ. Támɛ bʋmohogyi ánɩ́ alabwɛ́ ɔkasɩ́pʋ́. Mʋ́ sʋ benya mʋ ifú. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ɩnʋ Barnaba lɛ́kpa mʋ ya, yɛ́lɛ mʋ súná sumbí ayɔpʋ́ amʋ. Ɔlɛbláa amʋ́ alɩá anɩ Wíe lɛ́lɛ ɩwɩ ɔwan súná Saulo Damasko ɔkpatɔ, mʋa Yesunyɔ batɔ́ɩ́; pʋ́ alɩá Saulo lɔ́wa klʋn dá Bulu asʋ́n ámʋ ɔkan ɔwʋnlɩ́nsʋ́ Yesu dátɔ́ Damasko wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mʋ́ sʋ Saulo lówie amʋ́tɔ́, beki Yerusalem wúlutɔ. Ɔlɔwa klʋn blɩ́ Bulu asʋ́n ámʋ Yesu dátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mʋa Yudafɔ ámʋ́ʋ́ bʋtɛblɩ́ Griiki ɔblɩ́ɩ amʋ betsiá tɔ́ɩ́, gyi aba nwɛ́ɛn. Támɛ alɩ brɛ́ ámʋtɔ fɛ́ɛ́ á, bʋdɛ agywɩɩn bwɛ ánɩ́ bɔ́mɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Brɛ́á mʋ́ afú lɔwʋlɩ́ ahógyipʋ amʋ a, bɛkpa mʋ yáa Kaesarea, há mʋ ɔlɛnatɩ́ yɔ́ Tarso. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mʋ́ sʋ ɩwɩ lolwií ɔpasua ánɩ́ bʋ Yudea, Galilea pʋ́ Samaria ɔmátɔ́. Ɔŋɛ Wankɩ́hɛ́ lɛ́kpa amʋ́ bɛklɛɩ́, dan hógyitɔ, betsiá tsiátɔ́á ilegyi anɩ Wíe Yesu ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro lɛ́natɩ́ ki Samaria nkudasɩ. Ɛkɛ ɔkʋ ɔlɛyɛ́kɩ Bulu ahá ánɩ́ bʋbʋ Lida wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɩnʋ á, oleyéfia oyin ɔkʋá bʋtɛtɩ́ mʋ Enea, olesin tsukʋlɛ nfikwe nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro lɛ́bláa mʋ ɔbɛ́ɛ, “Enea, Yesu Kristo latsá fʋ́ ɩlɔ. Kʋsʋ kunta fʋ́ ɔklan.” Ɩnʋ Enea lɔ́kʋsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ahá ánɩ́ bʋtsie Lida wúlutɔ pʋ́ Saron nsáɩntɔ fɛ́ɛ́ bowun oyin ámʋ. Mʋ́ sʋ bohogyi, bobuo anɩ Wíe. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ɔtsɩ ɔkʋ bʋ Yopa wúlutɔ, ogyi ɔkasɩ́pʋ́. Bʋtɛtɩ́ mʋ Tabita. Mʋ dá ámʋ asɩ Griiki ɔblɩ́tɔ gyí, “Dorka.” Mʋ́ asɩ gyí, “Abrɛ.” Yilé ɔbwɛpʋ́ ogyi. Ɔbʋ awɩtɔlɛ há ahiánfɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Brɛ́á Petro bʋ Lida a, ɩlɔ lɛda Tabitasʋ. Olowu, bebie mʋ ntsu, sí mʋ tswɩ abansʋ́rʋ kʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa mʋ́a Lida awúlu ɩmafɔ́ aba wá. Mʋ́ sʋ brɛ́á akasɩ́pʋ́ amʋ́ʋ́ bʋbʋ Yopa amʋ bonu lowu ánfɩ á, bɔwa abi anyɔ sɩ́sɩ́ Petro bɛɛ, bobwíí ɩpa há mʋ, ɔwáa ɔsa tʋ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ɩnʋ Petro lɔ́wa ɔsa bwɛ́, mʋ́a amʋ́nyɔ bɛnatɩ́. Brɛ́á olobowie ɩnʋ á, bɛkpa mʋ ya abansʋ́rʋ amʋtɔ. Wúlu amʋtɔ asʋrapʋ fɛ́ɛ́ bʋbʋ fúli amʋ asɩ. Bɛkpa pútá Petro bʋdesú, bʋdɛ atadɩɛá Dorka lɔ́bwɛ brɛ́á otsie nkpa pʋsúná mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro légya asʋrapʋ amʋ fɛ́ɛ́ lɛ́ obu ámʋtɔ. Mʋ́ʋ́ ɔlɛda akpawunu bɔ́ mpáɩ, asa ɔlɛdamlɩ́ kɩ fúli amʋ blɩ́ ɔbɛ́ɛ, “Tabita, kʋsʋ.” Ɩnʋ Tabita lóbwií ansíbi. Brɛ́á olowun Petro a, ɔlɔkʋsʋ́ tsíá. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ɩnʋ Petro lɛ́kɩtá mʋ bɩ, ɔlɔkʋsʋ́ lɩ́ɩ́. Petro lɛ́tɩ asʋrapʋ amʋ pʋ́ ahógyipʋ atráhɛ amʋ. Mʋ́ʋ́ ɔlɔpʋ Tabita súná amʋ́ ánɩ́ alatsínkí. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Asʋ́n ánfɩ lɛklɛɩ́ wá Yopa wúlutɔ. Mʋ́ sʋ ahá tsɔtsɔɔtsɔ bɔhɔ anɩ Wíe gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro létsiá Simon ánɩ́ ɔtɔyɔ́ ɔwʋlʋ́-kpákpá ɩwɩ agyʋ́má wá Yopa ɩnʋ wá ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Oyin ɔkʋ létsiá Kaesarea ɩnʋ, bʋtɛtɩ́ mʋ Konelio. Ogyi Romafɔ ɩsá akɔpʋ́ ɔpasua kʋá bʋtɛtɩ́ mʋ́ Italia ɔhandɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɔbʋ nsi Bulusúm ɩwɩ. Mʋa mʋ wóyítɔ́fɔ fɛ́ɛ́ bʋtosúm Bulu. Konelio tekíé Yudafɔ ahiánfɔ atɔ́. Ɔtɔbɔ́ mpáɩ há Bulu brégyíbrɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ɛkɛ ɔkʋ Konelio lówun atɔ́ ntʋ́pwɛ dɔsatɔ. Mʋ atowunhɛ amʋtɔ á, olowun Bulu-ɔbɔpʋ ansɩ́ káɩ́n, Bulu-ɔbɔpʋ amʋ lókpolí mʋ ɔbɛ́ɛ, “Konelio!” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ifú lɛkɩtá mʋ. Mʋ́ sʋ olesi ɔdɛ Bulu-ɔbɔpʋ amʋ kɩ́ɩ. Mʋ́ʋ́ ɔlɛfɩtɛ́ Bulu-ɔbɔpʋ amʋ ɔbɛ́ɛ, “Mɩ́ Wíé, nkálɩ́ igyi?” Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Bulu lahɔ fʋ́ mpáɩ. Fʋ́ ahá atɔ́ kie ɛ́ lagyi mʋ ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wa abí abʋyɔ Yopa yɛtɩ Simon Petro ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔlɔyɔ́swɩɩ́ ɔwʋlʋ́-kpákpá ɩwɩ agyʋ́má ɔyɔpʋ́ Simon wóyítɔ́, mantáa ɔpʋ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Brɛ́á Bulu-ɔbɔpʋ amʋ lɛ́natɩ́ á, Konelio lɛ́tɩ mʋ asúmpʋ́ abanyɔ́ ánɩ́ bʋbʋ mʋ wóyítɔ́ pʋ́ mʋ ɔbɩsʋfɛ ánɩ́ ogyi ɩsá ɔkɔpʋ́, otenyá Bulu ifú. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ɔlɛbláa amʋ́ asʋ́n ánɩ́ ɩlaba fɛ́ɛ́, ɔlɔwa amʋ́ sɩ́sɩ́ Yopa. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mʋ́ ɔyɩ kɛhɛ bɔkʋsʋ́ bɔyɔ́ Yopa. Bɛta ɩnʋ wie tá á, ɩbɔ́bwɛ fɛ́ ɔpa dódúanyɔtɔ. Petro ɛ́ dɛ́dʋ ɔyɔ́ obu awunso mpáɩ ɔbɔkpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Akʋ́n ɩhɩ́ɛ́ dɛ mʋ. Mʋ́ sʋ olekle ánɩ́ obénya tɔkʋ wá ɔnɔ́. Brɛ́á bʋdɛ atɔ́ ámʋ nɩná há mʋ a, Petro lówun atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Atowunhɛ amʋtɔ á, olowun ánɩ́ ɔsʋ́sʋ́ lafínkí, tɔkʋá igyi fɛ́ ɔhráda tɛ́ɩ́hɛ́, bʋdɛ mʋ nsiebí ana, ɩdɛkplɩ́ ɩbá ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ɔyɩ́tɔ́ mbwɩ ɔtsan-ɔtsan, mbwɩá bʋbʋ ayín, támɛ bʋtɛká abɔnɔ pʋ́ ɔyɩ́tɔ́ mbubwi fɛ́ɛ́ bʋbʋ ɔhráda ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mʋ́ʋ́ olonu ɔmɛ kʋ lɛ́dalɩ ɔbɛ́ɛ, “Petro, kʋsʋ mɔ mbwɩ ánfɩ afʋwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Támɛ Petro lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Ó-o! Mɩ́ Wíé, bɔkwɩɩ́ mɩ́ ɔpá á, mmɔkʋ́gyi tɔ́á Yudafɔ amándɩ́ɛ́ lekisí ntɛ́ɛ mʋ́ ɩwɩ mɛtɩn kɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɔmɛ amʋ lɛ́la bláa mʋ ɔbɛ́ɛ, “Mátɩ tɔ́á Bulu latɩn mʋ́ ɩwɩ atokisíhɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Atowunhɛ amʋ pʋ́ ɔmɛ amʋ lɛ́ba tse sa. Mʋ ansɩ́tɔ́ ɩnʋ á, botsu ɔhráda ámʋ ya ɔsʋ́sʋ́ ɔtsáwʋlɛ pɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Brɛ́á Petro dɛ́ nwuntɔ bu tsú atowunhɛ anfɩ ɩwɩ á, Konelio abí ámʋ ɛ́ bafɩ́tɛ́ wun Simon wóyítɔ́, ba bʋlɩɩ́ ɔkpa ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Konelio abí ámʋ bokpolí fɩ́tɛ́ bɛɛ, “Ɔfɔɔ́ ɔkʋ tsie nfɩ, bʋtɛtɩ́ mʋ Simon Petro?” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petro trá ɔdɛ nwuntɔ bu tsú atowunhɛ amʋ ɩwɩ, Ɔŋɛ Wankɩ́hɛ́ lɛ́bláa mʋ ɔbɛ́ɛ, “Simon, ahá abasá akʋ baba bʋdɛ fʋ́ dunká. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kʋsʋ bwɛ, afʋkplɩ yefia amʋ́ amlɩnatɩ. Mágyi nwɛ́ɛn, tsúfɛ́ mɩ́lawá amʋ́ fʋ́ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ɩnʋ Petro lɛ́kplɩ́ yɔ́tʋ amʋ́, bláa amʋ́ ɔbɛ́ɛ, “Mɩ́gyí ɔhá ámʋ́ʋ́ mlɩdédunká ámʋ nɩ. Ntogyi sʋ́ mlɩná?” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ahá ámʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩmɛ́dɛ́ tsitsa. Ɩsá akɔpʋ́ ɔhandɛ Konelio ánɩ́ otenyá Bulu ifú, Yudafɔ fɛ́ɛ́ bʋtɛtɩ́ mʋ ɩdayilé lɔ́wa anɩ fʋ́ wá. Bulu-ɔbɔpʋ ɔkʋ labɛbláa mʋ ɔbɛ́ɛ, ɔbá bɛtɩ fʋ́ afʋba mʋ wóyítɔ́, mɛ́nɩ obónu asʋ́n ánɩ́ fʋ́bʋ blɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mʋ́ʋ́ Petro lɛ́kpa amʋ́ wá wóyítɔ́, ɔlɛha amʋ́ ɔdɩkpa. Ɔyɩ kɛhɛ a, Petro mʋa amʋ́nyɔ bɔkʋsʋ́ pʋ́ ɔkpa bɔyɔ́ Kaesarea. Brɛ́á bɔyɔ́ á, ahógyipʋ akʋá bʋbʋ Yopa ɩnʋ ɛ́ bobuo amʋ́ yɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mʋ́ ɔyɩ kɛhɛ a, boyówie Kaesarea wúlutɔ. Botsutsúa abʋwie ɩnʋ á, Konelio latɩ́ mʋ wóyítɔ́ ahá pʋ́ mʋ anyawíe kláklá befia, ɔdɛ amʋ́ ɔkpa kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Brɛ́á Petro lówie wóyí ámʋ ɔnɔ́ á, Konelio lɔ́kʋsʋ́ yéfia mʋ, dá akpawunu mʋ ayabitɔ súm mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Támɛ Petro lɛ́ha mʋ ɔlɔkʋsʋ́. Ɔlɛbláa Konelio ɔbɛ́ɛ, “Kʋsʋ, máda akpawunu há mɩ́. Nyankpʋsa mɩ́ ɛ́ ngyi.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petro mʋa mʋnyɔ bʋna bʋdɛtɔɩ́ alɩɩ olowie wóyítɔ́. Ɩnʋ olowun ánɩ́ ahá tsɔtsɔɔtsɔ bafia. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩ onutó mlɩyin ánɩ́ Yudafɔ mbla mɛha ɔkpa ánɩ́ Yudayin mʋa ɔmá bámbátɔ́yin bʋbwɛ́ɛ anyawíe ntɛ́ɛ ɔbɔ́yɔ mʋ wá kpán. Támɛ Bulu lahá mɩ́ nabɩ́ ánɩ́ mmákɩ mbɛ́ɛ ɔkʋ ɩwɩ mɛtɩn ntɛ́ɛ ɔmɔfʋn amándɩ́ɛ́ ɔkpasʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mʋ́ sʋ́ brɛ́á fɔwa abí fɛ́ɛ́ bʋbɛ́tɩ mɩ́ á, mmɔkpʋkpʋ́ʋ nwuntɔ nɩ́. Amansʋ igyi? Bla mɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mʋ́ʋ́ Konelio lɛ́bláa mʋ ɔbɛ́ɛ, “Ndɛ ɛkɛ náásɩ́, ntʋ́pwɛ dɔsatɔ mbʋ wóyítɔ́ ndɛ mpáɩ bɔ. Ɔtsáwʋlɛ pɛ́ á, nowun oyin ɔkʋ lɩ́ɩ́ mɩ́ ansɩ́tɔ́. Oyin ámʋ lɔ́wa atadɩɛ futútú. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Oyin ámʋ lɛ́bláa mɩ ɔbɛ́ɛ, ‘Konelio, Bulu lanú fʋ́ mpáɩ. Fʋ́ ahá atɔ́ kie ɛ́ lagyi mʋ ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mʋ́ sʋ wa abí abʋyɔ Yopa wúlutɔ yɛtɩ Simon Petro ba. Ɔwʋlʋ́-kpákpá ɩwɩ agyʋ́má ɔyɔpʋ́ Simon wóyí ɔlɔswɩɩ́. Otsie mantáa ɔpʋ ɔnɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mʋ́ sʋ ɩnʋnʋ nɔwa abí sɩ́sɩ́ fʋ́. Ɩbʋ alɛ́á faba. Séi á, anɩ fɛ́ɛ́ anɩlafia Bulu dátɔ́. Anɩgyó anɩ Wíe asʋ́n ánɩ́ alapʋ́há fʋ́ ɔbɛ́ɛ, fʋbláa anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mʋ́ʋ́ Petro lótsu ɔnɔ́ blɩ́ ɔbɛ́ɛ, “Nawun ánɩ́ lɛ́lɛ́ Bulu tamakɩ ɔhaa ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mboún ɔhá ánɩ́ otenyá mʋ ifú, ɔtɔbwɛ́ yilé asʋ́n otekle ɔmágyíɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mlɩyin asʋn wankláán ánɩ́ Bulu lɔ́pʋhá Israelfɔ. Asʋ́n ámʋ gyí, Bulu lapʋ́ iwilwii ba tsʋn Yesu Kristo, ahá fɛ́ɛ́ Owíe amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mlɩyin asʋ́n kpɔnkpɔntɩ ánɩ́ ɩlɛba Yudea ɔmátɔ́ fɛ́ɛ́. Ilotsu asɩ tsú Galilea ɔmátɔ́, brɛ́á Asú Ɔbɔpʋ́ Yohane lɛ́da asúbɔ ɔkan ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mlɩyin anɩ Wíe Yesu Nasaretyin amʋ. Mlɩyin ánɩ́ Bulu lɔ́pʋ mʋ Ɔŋɛ Wankɩ́hɛ́ pʋ́ túmi wá mʋtɔ, oleki ɔtɩ́nɛgyíɔtɩ́nɛ́ bwɛ́ yilé, tsá ahá ánɩ́ bʋbʋ ɔbʋnsám túmi asɩ ɩlɔ, tsúfɛ́ Bulu buo mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Anɩgyí ahá ánɩ́ anɩlówun mʋ bwɛhɛ́ ánɩ́ ɔlɔbwɛ Yudea pʋ́ Yerusalem ɔmátɔ́ fɛ́ɛ́ nɩ́. Bɛda mʋ mántá oyikpalíhɛsʋ mɔ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Támɛ mʋ́ ɛkɛ sáásɩ́ a, Bulu lɔ́kʋsʋ́a mʋ, lɛ́ mʋ ɔwan, ahá bowun mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Megyí ɔyɩ́tɔ́ ahá fɛ́ɛ́ lówun mʋ, támɛ anɩ ahá ámʋ́ʋ́ Bulu lɛ́lɛ yáɩ́ ɔbɛ́ɛ, abwɛ́ɛ mʋ adansɩfɔ ámʋ mʋ́ anɩlówun mʋ. Mʋ kʋ́sʋ́ tsú afúlitɔ ɔma a, anɩa mʋnyɔ légyi, anɩlɔ́wɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ɔlɛhɩɛ anɩ ɔbɛ́ɛ, adáa mʋ asʋn wankláán ámʋ ɔkan suna ahá, agyi mʋ ɩwɩ adánsɩɛ ánɩ́ mʋgyí ɔhá ánɩ́ Bulu lalɛ́á obégyi akɩankpapʋ pʋ́ awupʋ́ fɛ́ɛ́ asʋ́n nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ fɛ́ɛ́ bɛblɩ́ bɛɛ lɛ́lɛ́, ɔhagyíɔha ánɩ́ ɔlɔhɔ Kristo gyi a, Bulu obési mʋ lakpan fɛ́ɛ́ kíé mʋ Kristo dátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Brɛ́á Petro dɛ́ asʋ́n ánfɩ blɩ́ á, Ɔŋɛ Wankɩ́hɛ́ lɛ́bá ahá ámʋ́ʋ́ bʋdɛ mʋ asʋ́n ámʋ nu ámʋ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ɔnɔ́ lobwie Yudafɔ ahógyipʋ amʋ́ʋ́ bobuo Petro ba ɩnʋ ámʋ ánɩ́ Bulu lapʋ́ mʋ Ɔŋɛ Wankɩ́hɛ́ amʋ kíé ahá ánɩ́ bʋmegyí Yudafɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tsúfɛ́ bowun ánɩ́ ahá ámʋ bʋdɛ ɔblɩ́ɩ bámbá blɩ́, bʋhɩ́ɛ́ bʋdɛ Bulu kanfʋ́. Mʋ́ sʋ Petro lɛ́bláa amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bulu lahá ahá ánfɩ ɛ́ Ɔŋɛ Wankɩ́hɛ́ fɛ́ anɩ. Ɔkʋ ɔbɛ́talɩ́ tin amʋ́ ɔkpa ɔbɛ́ɛ bʋmábɔ amʋ́ asú?” ");
INSERT INTO nkoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mʋ́ sʋ ɔlɛblɩ́ ɔbɛ́ɛ, bʋbɔ́ amʋ́ asú Yesu Kristo dátɔ́. Mʋ́ ɔma a, bokokóli Petro bɛɛ, otsía amʋ́ wá kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu sumbí ayɔpʋ́ ámʋ pʋ́ ahógyipʋ amʋ́ʋ́ bʋbʋ Yudea ɔmátɔ́ ámʋ bonu ánɩ́ ɔmá bámbátɔ́fɔ ɛ́ bahɔ Bulu asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mʋ́ sʋ brɛ́á Petro lɔ́yɔ Yerusalem wúlutɔ á, mʋa ahógyipʋ akʋá bʋtekleá ahá bʋtɩ́ɩn keté asa abʋwie ɔpasua ámʋtɔ bɛbɩtɩ́ asʋ́n. Bɛfɩtɛ́ mʋ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ntogyi sʋ fayɔ́ ahá ánɩ́ bʋmɛtɩn keté wóyí, fʋ́a amʋ́nyɔ mlɩlawá ɩbɩ gyi atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mʋ́ sʋ Petro lɛ́lɛ asʋ́n ánɩ́ ɩlɛbatɔ súná amʋ́ ɩkʋlɛ-kʋlɛ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mbʋ Yopa wúlutɔ ndɛ mpáɩ bɔ nowun atɔ́. Mʋ́tɔ́ á, nowun ánɩ́ tɔkʋá igyi fɛ́ ɔhráda tɛ́ɩ́hɛ́, bʋdɛ mʋ́ nsiebí ana lɛ́kplɩ́ tsú ɔsʋ́sʋ́ bá mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nowun pututɔ-mbwɩ pʋ́ wúlutɔ mbwɩ, mbwɩá bʋbʋ ayín, támɛ bʋtɛká abɔnɔ pʋ́ ɔyɩ́tɔ́ mbubwi fɛ́ɛ́ ɔhráda ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ɩnʋ nonu ɔmɛ kʋ lɛdalɩ bláa mɩ ɔbɛ́ɛ, ‘Petro, kʋsʋ mɔ mbwɩ ánfɩ afʋwɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Mʋ́ʋ́ nɛblɩ́ mbɛ́ɛ, ‘Mɩ́ Wíe, ɛkɛkɛɛkɛ. Bɔkwɩɩ́ mɩ́ ɔpá á, mmɔkʋ́gyi tɔ́á Yudafɔ amándɩ́ɛ́ lekisí ntɛ́ɛ mʋ́ ɩwɩ mɛtɩn kɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Mʋ́ʋ́ ɔmɛ amʋ lótsu ɔsʋ́sʋ́ lábláa mɩ ɔbɛ́ɛ, ‘Mátɩ tɔ́á Bulu latɩn mʋ́ ɩwɩ atokisíhɛ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsesa sɔ́ɔ́n nowun atowunhɛ anfɩ. Mʋ́ ɔma a, ɩlɛlayínkí yɔ́ ɔsʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Alɩ brɛ́ ámʋtɔ kɛ́n á, ayin abasá akʋá bɔwa mɩ́ wá tsú Kaesarea baba bʋlɩɩ́ wóyí ámʋ́ʋ́ ntsie mʋ́tɔ́ ámʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɔŋɛ Wankɩ́hɛ́ lɛ́bláa mɩ ɔbɛ́ɛ, mbúo amʋ́ yɔ, mmágyi nwɛ́ɛn. Apíó abasíé ánfɩ botsú Yopa anfɩ ɛ́ bobuo mɩ yɔ́ Kaesarea, anɩ fɛ́ɛ́ anɩlɔ́yɔ Konelio wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Konelio lɛ́bláa anɩ ɔbɛ́ɛ, mowun Bulu-ɔbɔpʋ ɔkʋ mʋ wóyítɔ́, ɔlɛbláa mʋ ɔbɛ́ɛ, ‘Wa abí abʋyɔ Yopa yɛtɩ oyin ɔkʋá bʋtɛtɩ́ mʋ Simon Petro ba. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ɔbɛ́bláa fʋ asʋ́n ánɩ́ fʋ́a fʋ́ wóyítɔ́ ahá fɛ́ɛ́ mlɔ́tsʋn mʋ́sʋ́ nyá nkpa.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Nenya tsú ɔnɔ́ ndɛtɔɩ́ alɩ, Ɔŋɛ Wankɩ́hɛ́ lɛ́ba amʋ́sʋ́ fɛ́ alɩá ɩlɛba anɩsʋ ɛkɛ gyankpapʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ɩnʋ nɛkaɩ́n anɩ Wíe asʋn blɩ́hɛ́sʋ. Ɔbɛ́ɛ, ‘Yohane lɔ́pʋ ntsu bɔ́ ahá asú. Támɛ mlɩ mʋ́ á, Bulu ɔbɔ́pʋ Ɔŋɛ Wankɩ́hɛ́ bɔ́ mlɩ asú.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mʋ́ sʋ nɩ́ Bulu lapʋ́ mʋ atokiehɛ́ ámʋ kíé amʋ́, fɛ́ alɩá ɔlɔpʋkíé anɩ ahá ámʋ́ʋ́ anɩlɔ́hɔ anɩ Wíe Yesu Kristo gyi amʋ a, mɩ́gyí ma ánɩ́ nétin Bulu ɔkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Brɛ́á sumbí ayɔpʋ́ ámʋ bonu asʋ́n ánfɩ á, besi Petro tɔ́ɩ wa, bɛkanfʋ́ Bulu bɛɛ, “Mʋ́mʋ́ Bulu lahá ahá ánɩ́ bʋmegyí Yudafɔ ɔkpa ɔbɛ́ɛ, amʋ́ ɛ́ bʋdámli klʋntɔ, abʋnya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefano lowu ɔma a, bɛdɩnká ahógyipʋ amʋsʋ. Mʋ́ sʋ bɛdasáɩ́n yɔ́ Foinike mʋ́a Kipro ɔsʋlʋ́sʋ pʋ́ Antiokia wúlutɔ. Yudafɔ nkʋlɛ bɛbláa Bulu asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Támɛ amʋ́tɔ́ akʋ mʋ́ botsu Kipro pʋ́ Kirene ɔmátɔ́ ba Antiokia bɛbláa Griikifɔ ámʋ anɩ Wíe ɩwɩ asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Anɩ Wíe Bulu lɛ́lɩɩ́ amʋ́ ɔma. Mʋ́ sʋ amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bohogyi, dámlí klʋntɔ ba anɩ Wíe Yesu wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yerusalem ɔpasua ámʋ bonu asʋ́n ánfɩ. Mʋ́ sʋ bɔwa Barnaba sɩ́sɩ́ Antiokia. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnaba gyí ɔha wankláán, Ɔŋɛ Wankɩ́hɛ́ pʋ́ hógyi ɛ́ ɩtsɔ mʋtɔ. Brɛ́á olowie Antiokia, olowun alɩá Bulu lagyi amʋ́ bʋalɛ a, ansɩ́ legyi mʋ. Mʋ́ʋ́ ɔlɔtɔɩ́ kplá amʋ́ ɔbɛ́ɛ, bʋpʋ́ʋ amʋ́ klʋn fɛ́ɛ́ dɩnka anɩ Wíe Yesusʋ, abʋgyi mʋ mblasʋ. Ɩ́nɩ sʋ ahá tsɔtsɔɔtsɔ bɔtsʋn mʋ asʋ́n ámʋsʋ hɔ anɩ Wíe gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mʋ́ ɔma a, Barnaba lɔ́yɔ Tarso wúlutɔ yódunká Saulo. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Brɛ́á olowun mʋ a, ɔlɛkpa mʋ ba Antiokia. Betsiá ɩnʋ ofi ɔkʋlɛ, tsíá fía ɔpasua ámʋ, súná amʋ́ atɔ́. Antiokia begyankpá tɩ́ akasɩ́pʋ́ amʋ bɛɛ “Akristofɔ” nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ akʋ botsu Yerusalem ba Antiokia alɩ brɛ́ ámʋtɔ kɛ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Amʋ́tɔ́ ɔkʋlɛ dá gyí Agabo. Ɔlɔkʋsʋ́ lɩ́ɩ́, blɩ́ Ɔŋɛ Wankɩ́hɛ́ túmitɔ tswɩ ɔbɛ́ɛ, “Akʋ́n kpɔnkpɔntɩ kʋ bɛ́ba Roma ɔmátɔ́ fɛ́ɛ́.” Ɩlɛba mʋ́tɔ́ brɛ́á Roma Owíe Klaudio tsie obíásʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Akasɩ́pʋ́ amʋ bɔbwɛ agywɩɩn bɛɛ, amʋ́tɔ́ okugyíɔkʋ obódunká tɔ́á obénya, abʋpʋ yekie apíó ahógyipʋ ánɩ́ bʋbʋ Yudea ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Begyi dɩnká mʋ́sʋ́, bɔpʋhá Barnaba mʋa Saulo bɔpʋya ɔpasua ámʋ ahandɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Alɩ brɛ́ ámʋtɔ á, Owíe Herode lɛ́dɩnká ɔpasua ámʋtɔ akʋsʋ, wá amʋ́ amʋmʋyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔlɛha bɛtɩn Yohane mʋ pio Yakobo ɔdayítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herode lówun ánɩ́ ɩbʋ Yudafɔ ámʋ ɔdwɛ. Mʋ́ sʋ omesi, ɔlɛyɛ́kɩtá Petro ɛ́. Alɩ brɛ́ ámʋtɔ bʋdɛ Israelfɔ Bodobodo Mátúhɛ́Nkɛ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mʋ́ sʋ brɛ́á ɔlɛkɩtá Petro a, ɔlɔpʋ mʋ tswɩ obu, ɔlɛlɛ ɩsá akɔpʋ́ dúasie ɔbɛ́ɛ, bʋtsía gyo mʋ ɩwɩ abaná-abaná. Ɔlɔbwɛ agywɩɩn ɔbɛ́ɛ, begyi Nkɛ ámʋ tá á, mégyi Petro asʋ́n dɩnsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bɔwa Petro obu, támɛ ɔpasua ámʋ bɔbɔ mpáɩ kínkíínkín há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Onyé asa ɔyɩ́ ɔbɛ́kɛ Owíe Herode ɔbɛ́lɛ Petro ba dɩnsʋ begyi mʋ asʋ́n á, bɔwa Petro ɩkan anyɔ kɛ́kɛ́, ɔda ɔdɛdɩdɩ ɩsá akɔpʋ́ abanyɔ́ nsɩnɛ́. Ɩsá akɔpʋ́ akʋ ɛ́ bʋlɩɩ́ bʋdɛ obu ámʋ ɔnɔ́ gyo. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ɔtsáwʋlɛ pɛ́ á, Bulu-ɔbɔpʋ ɔkʋ lɛ́bɛlɩɩ́ amʋ́ wá obuto ɩnʋ, ɩnʋ fɛ́ɛ́ lɔ́wankɩ́. Bulu-ɔbɔpʋ amʋ lɔ́pʋ ɩbɩ da Petro abɩntɔ, oletsinkí. Ɔlɛbláa Petro ɔbɛ́ɛ, “Wa ɔsa kʋsʋ.” Ɩnʋ ɩkan amʋ lɔ́wɔɩ́ lɛ́ mʋ ɩbɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mʋ́ʋ́ Bulu-ɔbɔpʋ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Kʋsʋ pʋ ɔfɛ́ klɩ́ osíétɔ́, afʋtsu fʋ́ ntʋkʋta wa.” Petro lɔ́bwɛ. Mʋ́ʋ́ ɔlɛtrá bláa Petro ɔbɛ́ɛ, “Tsu fʋ́ ligá wa afʋba ayɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro lóbuo Bulu-ɔbɔpʋ amʋ dálɩ obu ámʋtɔ. Ɩmɔwankɩ́ Petro nɩ́ akɩ́ankpatɔ ntɛ́ɛ atowunhɛtɔ Bulu-ɔbɔpʋ amʋ dɛ́ mʋ asʋ́n bláa. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mʋa Bulu-ɔbɔpʋ amʋ bɔtsʋn obu-ɔnɔ́ gyankpapʋ pʋ́ nyɔɔsɩ agyópʋsʋ. Bɛba bɔtʋ dátɔ ɩklʋn ánɩ́ fɔ́pʋdálɩ wie wúlutɔ. Ɩklʋn amʋ onutó lefinkí há amʋ́ bɔtsʋn. Bɔpʋtsʋn brɔnʋ kʋsʋ bɔyɔ́ á, Bulu-ɔbɔpʋ amʋ lɔ́fwɩ sí Petro. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Brɛ́á Petro ansɩ́tɔ́ lɛtɩtɩ́ɩ mʋ a, ɔlɛblɩ́ ɔbɛ́ɛ, “Séi mʋ́ nawun ánɩ́ lɛ́lɛ́ Bulu lawá mʋ ɔbɔpʋ, alabɛlɛ mɩ́ Owíe Herode ɩbɩ pʋ́ tɔ́á Yudafɔ bʋdɛ ɔkpa kɩ́tɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ɩ́nɩá Petro lówun mʋ́ alɩ sʋ á, ɔlɛnatɩ́ yɔ́ Yohane ánɩ́ bʋtɛtráa tɩ mʋ Marko mʋ yin Maria wóyí. Alɩ brɛ́ ámʋtɔ á, ahá tsɔtsɔɔtsɔ bafia ɩnʋ bʋdɛ mpáɩ bɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petro lɛ́da amʋ́ ɩklʋnsʋ, osúmbi tsɩhɛ́ ɔkʋá bʋtɛtɩ́ mʋ Rode lɛ́bɛkɩ ɔhá ánɩ́ ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Brɛ́á Rode lɛ́bɩ ánɩ́ Petro ɔmɛ nɩ á, ansɩ́ lɛhɩɛ gyi mʋ. Mʋ́ sʋ ɔlɛtan obu ámʋ finkí. Mboún oleyinkí srɩ́ yɛ́bláa amʋ́ ɔbɛ́ɛ, “Petro laba ɔlɩɩ́ obu-ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ahá ámʋ bɛbláa mʋ bɛɛ, “Fʋ́ nwun layíntá.” Támɛ ɔlɔyɔ mʋ́sʋ́, ɔdɛblɩ́ ɔbɛ́ɛ, “Lɛ́lɛ́ a.” Mʋ́ sʋ bɛbláa mʋ bɛɛ, “Mʋ́mʋ́ fíalɩ Bulu-ɔbɔpʋá ɔtɛkɩ Petrosʋ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Alɩ brɛ́ ámʋtɔ fɛ́ɛ́ á, Petro trá ɔdɛ ɩklʋn amʋsʋ da. Brɛ́á bɔyɔ yéfinkí mʋ́, bowun Petro a, ɔnɔ́ lobwie amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petro lɔ́bwɛ ɩbɩ súná amʋ́ ɔbɛ́ɛ bʋkásʋ, ɔlɛbláa amʋ́ alɩá anɩ Wíe lalɛ́ mʋ obu. Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩbla Yakobo mʋa apíó ahógyipʋ atráhɛ amʋ asʋ́n ánfɩ.” Mʋ́ʋ́ ɔlɛnatɩ́ amʋ́ wá yɔ́ ɔtɩnɛ bambá á. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Brɛ́á ɔyɩ́ lɛkɛ a, ɩsá akɔpʋ́ ámʋ fɛ́ɛ́ begyigyáa, fɩ́tɛ́ aba bɛɛ, “Nkɩ́ɩ Petro mɛ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Owíe Herode lɛ́ha bodunká Petro ɔtɩ́nɛgyíɔtɩ́nɛ́, támɛ bʋmowun mʋ. Mʋ́ sʋ ɔlɛtɩ obu adɩpʋ́sʋ́ akɩ́pʋ amʋ, fɩ́tɛ́ amʋ́ asʋ́n, ɔlɛha bɔmɔ amʋ́. Mʋ́ ɔma a, ɔlɛnatɩ́ Yudea ɔmátɔ́ yétsiá Kaesarea wúlutɔ nkɛnsá kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Brɛ́ kʋtɔ á, ɔblɔ́ lɛhɩɛ kɩ́tá Owíe Herode Tiro mʋ́a Sidonfɔ sʋ. Mʋ́ sʋ awúlu anyɔ ánfɩ bɛlɛ abí bɛɛ bʋyókokóli mʋ, iwilwii itsia amʋ́ nsɩnɛ́. Tsúfɛ́ Owíe Herode ɔmátɔ́ bʋtenyá atogyihɛ tsú. Ahá ámʋ begyankpá yɛ́lɛ asʋ́ntɔ́ súná Owíe Herode wóyísʋ́ ɔkɩ́pʋ ɔkʋá bʋtɛtɩ́ mʋ Blasto, olotsulá gya amʋ́ nkpá bɔyɔ Owíe Herode wá yókokóli mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Owíe Herode lɛ́hɩɛ amʋ́ ɛkɛ. Ɛkɛ ámʋ lɔ́fʋn a, ɔlɛhɩhɩ́ɛ ɩwɩ dálɩ betsiá mʋ obíásʋ́, bláa amʋ́ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ahá ámʋ bɔkplʋ́n blɩ́ bɛɛ, “Megyí nyankpʋsa dɛ́tɔɩ́, mboún ɔkpɩ dɛ́tɔɩ́ o!” ");
INSERT INTO nkoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ɩnʋnʋ Bulu-ɔbɔpʋ lɛ́da Herode, anyambi bɔwɩ mʋ, olowu. Tsúfɛ́ ɔmɔpʋ numnyam há Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bulu asʋ́n lɔyɔ mʋ́sʋ́, klɛ́ɩ́ yɔ́ tsútsúútsú. ");
INSERT INTO nkoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba mʋa Saulo bɔyɔ amʋ́ agyʋ́má tá Yerusalem, bɛkpa Yohane ánɩ́ bʋtɛtráa tɩ mʋ Marko buo ɩwɩ yínkí yɔ́ Antiokia. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ pʋ́ atɔ́ asunápʋ́ akʋ betsiá Antiokia ɔpasua ámʋtɔ. Amʋ́gyí: Barnaba, Simeon ánɩ́ bʋtɛtɩ́ mʋ Obibi, Lukio ánɩ́ otsú Kirene ɔmátɔ́, Manaen ánɩ́ bɛyaɩ́ mʋa Galilea ɔmásʋ́ ogyípʋ́ Herodenyɔ tsukʋlɛ pʋ́ Saulo. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Brɛ́á bɛklɩ́ ɔnɔ́, bʋdɛ anɩ Wíe súm á, Ɔŋɛ Wankɩ́hɛ́ lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mlɩlɛ Barnaba mʋa Saulo ha mɩ, abʋyɔ agyʋ́má ámʋ́ʋ́ nɛtɩ amʋ́ mbɛ́ɛ bʋbɔ́yɔ ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mʋ́ sʋ brɛ́á bɛklɩ́ ɔnɔ́ ámʋ bɔ́ mpáɩ tá á, bɔpʋ ɩbɩ dɩ́nká amʋ́ nwunsʋ, sí amʋ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ɔŋɛ Wankɩ́hɛ́ lɔ́wa Barnaba mʋa Saulo sumbí. Bɔyɔ Seleukia wúlutɔ yótsu ntsusʋ-yibi fá yɔ́ ɔsʋlʋ́ʋ kʋá ɩbʋ ntsu nsɩnɛ́, bʋtɛtɩ́ mʋ́ Kiprosʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Brɛ́á bowie wúlu kʋá ɩbʋ ɩnʋ, bʋtɛtɩ́ mʋ́ Salamisʋ á, bɔyɔ Yudafɔ ofíakpa yɛ́da Bulu asʋ́n ámʋ ɔkan. Yohane ámʋ́ʋ́ bʋtɛtráa tɩ mʋ Marko amʋ ɛ́ lóbuo amʋ́ yɛ́tsa amʋ́ agyʋ́má yɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bɛdalɩ Salami wúlutɔ, bɛnatɩ́ alɩɩ bowie ɔsʋlʋ́ʋ kʋá bʋtɛtɩ́ mʋ́ Pafosʋ. Ɩnʋ befia ɔfápʋ́ kpɔnkpɔntɩ ɔkʋá bʋtɛtɩ́ mʋ Bar-Yesu. Ogyi Yudayin, ɔtɔwá afunu ɔbɛ́ɛ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ mʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mʋ nyawie gyí ɩnʋ ɔmásʋ́ ogyípʋ́ Sergio Paulo. Ɔmásʋ́ ogyípʋ́ anfɩ lɛ́tɩn ansɩ́. Ɔlɔwa bɛyɛ́tɩ Barnaba mʋa Saulo ba mʋ wóyítɔ́. Tsúfɛ́ odekléá mónu Bulu asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Támɛ ɔfápʋ́ Bar-Yesu anfɩ́ mʋ dá asɩ gyí, Elima Griiki ɔblɩ́tɔ anfɩ mɛ́ha amʋ́ ɔkpa abʋbla ɔmásʋ́ ogyípʋ́ amʋ Bulu asʋ́n ámʋ. Ɔlɔbɔ mbɔ́dɩ́ ánɩ́ ɔmásʋ́ ogyípʋ́ amʋ mánu Yesu ɩwɩ asʋ́n ámʋ, fówun ɔmɔ́ɔhɔ mʋ́sʋ́ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɩnʋ Ɔŋɛ Wankɩ́hɛ́ lɔ́bʋlá Saulo amʋ́ʋ́ bʋdɛ mʋ tɩ Paulo amʋtɔ, olesi ɔlɩɩ́ ɔdɛ ɔfápʋ́ amʋ ansɩ́tɔ́ kɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Mʋ́ʋ́ ɔlɛbláa ɔfápʋ́ amʋ ɔbɛ́ɛ, “Ɔbʋnsám mʋ bi, fʋtekísí ɩtɔ wankláán kugyíkʋ. Fapʋ́ ahámlɛ́ pʋ́ lalahɛgyí bwɛ́ fʋ́ agyʋ́má. Mʋ́ sʋ fʋméesi Bulu ɔnɔkwalɩ amʋ afunutɔ wa? ");
INSERT INTO nkoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kɩ, Bulu ɔbɛ́bɩtɩ́ fʋ́ ɩsʋ. Fʋ́ ansíbi bóbwie. Fʋmɛ́ɛtrá wun ɔyɩ kɛhɛtɔ owí alɩɩ yɔ́fʋn brɛ́ kʋ.” Ɩnʋnʋ Elima ansɩ́tɔ́ loklun mʋ. Mʋ́ sʋ ɔlɔwa tatápʋ bɩ, ɔdɛ ɔkʋ dunká ɔkɩta mʋ oyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Brɛ́á ɔmásʋ́ ogyípʋ́ amʋ lówun tɔ́á ɩlaba a, ɔlɔhɔ anɩ Wíe gyi. Anɩ Wíe ɩwɩ asʋ́n ámʋ́ʋ́ bʋdɛ mʋ suná ámʋ lɛha ɔnɔ́ lobwie mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo mʋa mʋ aba ámʋ botsu ntsusʋ-yibi tsú Pafo wúlutɔ yɔ́ Perge ánɩ́ ɩbʋ Pamfilia ɔsʋlʋ́sʋ. Támɛ Yohane Marko mʋ́ léyinkí amʋ́ ɔma tsú ɩnʋ yɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bɔkʋsʋ́ tsú Perge yɔ́ Antiokia ánɩ́ ɩbʋ Pisidia ɔsʋlʋ́sʋ. Ɔkpʋ́nʋ́ ɔdakɛ́ á, bɔyɔ ɩnʋ Yudafɔ ofíakpa yétsiá asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bɛkla atɔ́ tsú Mose Mbla pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ nwʋlʋ́tɔ́ ta á, ofíakpa amʋ ahandɛ bɔwa abí bɛyɛ́bláa Paulo aná bɛɛ, “Apíó, nɩ́ mlɩdɛ́ asʋankʋá mlɛ́blɩ́ pʋ́wá ahá ánfɩ ɔwʋnlɩ́n á, ɔkpa da.” ");
INSERT INTO nkoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mʋ́ʋ́ Paulo lɔ́kʋsʋ́ lɩ́ɩ́, ɔlɔbwɛ amʋ́ ɩbɩ ɔbɛ́ɛ bʋkásʋ. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Apíó Israelfɔ pʋ́ ɔmá bámbásʋ́fɔá mlɩtenyá Bulu ifú, mlɩyaa asʋ amlɩnu. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel Bulu lɛ́lɛ anɩ anáin bwɛ́ mʋ ahá. Ɔlɛha bɛklɛɩ́ brɛ́á bʋgyi afɔɔ́ Egyipte ɔsʋlʋ́sʋ. Ɔlɔpʋ mʋ túmi kpɔnkpɔɔnkpɔntɩ kpá amʋ́ dalɩ ɔmá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Olenya klʋn kpá amʋ́ nfí adʋana (40) kɛ́kɛ́ dimbí ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Oleyintá ɔmá asienɔ́ kɛ́kɛ́ Kanaan ɔsʋlʋ́sʋ, oleye amʋ́ ɔsʋlʋ́ʋ amʋ pʋ́bwɛ́ siadɩɛ há anɩ anáin. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nfí lafana aduenu (450), ɔlɔpʋbwɛ́ ɩ́nɩ fɛ́ɛ́ há amʋ́. “Mʋ́ ɔma a, ɔlɛha asʋ́n agyípʋ́ bɛkpa amʋ́ alɩɩ bɔtʋ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Samuel. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Brɛ́á bɛbláa Bulu bɛɛ ɔyáɩ awíe ha amʋ́ á, Bulu lɛ́yaɩ́ Kis mʋ bi Saulo owíe há amʋ́. Saulo otsú Benyamin abusuantɔ. Olegyi iwíe nfí adʋana (40). ");
INSERT INTO nkoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Brɛ́á Bulu lɛ́kplɩ́ mʋ a, ɔlɛha bɛyaɩ́ Dawid obíásʋ́ há amʋ́. Asʋ́n ánfɩ Bulu lɛ́blɩ́ tsú mʋ ɩwɩ nɩ́. Ɔbɛ́ɛ, ‘Yisai mʋ bi Dawid gyí ɔhá ánɩ́ mɩ́ klʋn dɩn mʋsʋ, tsúfɛ́ ɔbɔ́bwɛ tógyítɔ́á nɛ́bláa mʋ mbɛ́ɛ ɔbwɛ́ɛ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Dawid anfɩ abí-anátɔ́ Bulu labɛlɛ Yesu tsú há Israelfɔ ɔbɛ́ɛ, ɔbwɛ́ɛ amʋ́ Ɔlɛpʋ́ fɛ́ alɩá ɔlɛhɩɛ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Asa Yesu lɛ́bá a, Asú Ɔbɔpʋ́ Yohane légyankpá dá ɔkan súná Israelfɔ fɛ́ɛ́ ɔbɛ́ɛ, bʋdámli klʋntɔ, abʋha mʋ ɔbɔ amʋ́ asú. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Brɛ́á Yohane ɔbá bɔmɔ mʋ agyʋ́má ɔnɔ́ á, ɔlɛfɩtɛ́ ahá ámʋ ɔbɛ́ɛ, ‘Ma mlɩdésusúu mlɩaa ngyi? Megyí mɩ́gyí ɔhá ámʋ́ʋ́ mlɩdɛ́ ɔkpa kɩ́ɩ amʋ. Mʋ mʋ́ ɔbɛ́ba mɩ́ ɔma. Mmɔfʋn ánɩ́ nɔ́wɔɩ́ mʋ ntʋkʋta.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mɩ́ apíó, Abraham abí-aná pʋ́ ɔmá bámbásʋ́fɔá mlɩtenyá Bulu ifú, mlɩyaa asʋ amlɩnu. Anɩgyí ahá ánɩ́ Bulu lɔ́pʋ nkpahɔ́ɔ asʋ́n ámʋ sɩ́sɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem atsiápʋ́ pʋ́ amʋ́ ahandɛ bʋmɛbɩ ánɩ́ Yesu gyí Ɔlɛpʋ́. Bʋmonu Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋ́n ánɩ́ bɔwanlɩ́n tswɩ asɩ. Bʋtɛkla mʋ́ ɔkpʋ́nʋ́ ɔdakɛ́ kugyíkʋ. Támɛ begyi Yesu asʋ́n, há mʋ ɩpɔ́n, mɔ́ mʋ; ɩlɛha Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋ́n ánfɩ lɛba mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bʋmenya Yesu ɩwɩ asʋ́n kʋkʋá bɛ́lɩɩ́ mʋ́sʋ́ mɔ́ mʋ, támɛ bɛbláa Pilato bɛɛ ɔhá abʋmɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mʋ́ sʋ brɛ́á bɔbwɛ tɔ́á bɔwanlɩ́n tsú mʋ ɩwɩ fɛ́ɛ́ tá á, bɛlɛ mʋ tsú oyikpalíhɛ amʋsʋ yópulá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Támɛ Bulu lɔ́kʋsʋ́a Yesu tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mʋ́ ɔma a, oletsiá lɛ ɩwɩ súná ahá ámʋ́ʋ́ mʋa amʋ́nyɔ bɛnatɩ́ tsú Galilea yɔ́ Yerusalem amʋ brɛ́ tsɔtsɔɔtsɔtɔ. Ahá ánfɩ gyí ahá ánɩ́ bʋdɛ mʋ ɩwɩ adánsɩɛ gyí suná Israelfɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Anɩ mʋ́ anɩdɛ́ mlɩ asʋn wankláán ámʋ bláa. Mʋ́gyí, Bulu labwɛ́ tɔ́ ámʋ́ʋ́ ɔlɛhɩɛ anɩ anáin amʋ há amʋ́ abí-aná. Amʋ́gyí anɩ á. Tsúfɛ́ alakʋ́sʋ́a Yesu tsú afúlitɔ há anɩ, fɛ́ alɩá bɔwanlɩ́n wá Israelfɔ ɩlʋ nyɔɔsɩtɔ bɛɛ, ‘Mɩ́ Bí gyí fʋ́. Ndɛ nabwɛ́ fʋ́ Sɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bulu lɛ́trá tɔɩ́ tsú Yesu kʋsʋ́ tsú afúlitɔ pʋ́ mʋ ɔyʋlʋ́ʋ amʋ́ʋ́ ɩmɔ́ɔplɔ́ wá ɔbɔ́tɔ́ ɛkɛkɛɛkɛ ámʋ ɩwɩ ɔbɛ́ɛ, ‘Nɔ́pʋ mɩ́ oyúla wankɩ́hɛ́ amʋ́ʋ́ nɛhɩɛ mbɛ́ɛ, ɩbwɛ́ alɩágyíalɩ́á nɔ́pʋhá Dawid amʋ há mlɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Owíe Dawid ɛ́ lɛ́trá lawánlɩ́n wá Israelfɔ Ɩlʋ bámbátɔ́ ɔbɛ́ɛ, ‘Fʋmɛ́ɛha fʋ́ osúmpʋ́ wankɩ́hɛ́ mɔ́ɔplɔ́ wá fúli ɔbɔ́tɔ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Owíe Dawid lósum Bulu mʋ nkpatɔ, bwɛ́ Bulu apɛ́ tá á, olowu, bopulá mʋ mʋ anáintɔ, ɔlɔplɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Támɛ Yesu anfɩ́ Bulu lɔ́kʋsʋ́a tsu afúlitɔ ánfɩ mʋ́ mɔ́plɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Mʋ́ sʋ apíó, mlɩnu asʋ́n ánfɩ anɩdɛ́ mlɩ bláa anfɩ asɩ. Yesu anfɩ nkʋlɛsʋ mlɔ́tsʋn nya lakpansikíé. Mose mbla mɛ́talɩ́ há amlɩgyi asʋ Bulu ansɩ́tɔ́. Támɛ ɔhagyíɔha ánɩ́ alahɔ Yesu anfɩ gyi obégyi asʋ Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mʋ́ sʋ mlɩkɩ wankláán, mɛ́nɩ asʋ́n ámʋ́ʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ bɛblɩ́ tswɩ amʋ mɛ́ɛba mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Asʋ́n ámʋ gyí, ‘Asʋ́n ámʋ ɩwá mlɩ ahá ánɩ́ mlɩtɔwá Bulu asʋ́n nyányáa ifú, amlɩwu. Tsúfɛ́ nɩ́ ndɛ ɔkʋ ɔblɩ́ gyʋma ánɩ́ ndegyí mlɩtɔ kʋ́ráá á, mlɩmóohogyi.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Brɛ́á Paulo mʋa Barnaba bʋdɛdalɩ Yudafɔ ofíakpa ɩnʋ á, ahá ámʋ bɔkʋlɩ́ amʋ́ bɛɛ bʋbá ɔkpʋ́nʋ́ ɔdakɛ́ ámʋ́ʋ́ ɩbá ámʋ, abʋtra bɔtɔɩ́ tsu asʋ́n ámʋ ɩwɩ suna amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Brɛ́á ahá ámʋ bɛdalɩ Yudafɔ ofíakpa ɩnʋ á, Yudafɔ tsɔtsɔɔtsɔ pʋ́ ɔmá bámbátɔ́ abí ánɩ́ bawíé Yudafɔ osúmtɔ́ bɛkplá buo Paulo mʋa Barnaba. Mʋ́ sʋ sumbí ayɔpʋ́ ánfɩ bɔtɔɩ́ kplá amʋ́ bɛɛ, bʋpʋ́ʋ ansɩ́ dɩnka Bulu awɩtɔlɛsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ɔkpʋ́nʋ́ ɔdakɛ́ amʋ́ʋ́ bɛbláa amʋ́ bɛɛ bʋbá amʋ lɔ́fʋn a, ilesi kpalobí tɛkɩ ahá bɛta wúlu amʋtɔ. Amʋ́ fɛ́ɛ́ bɛba Bulu asʋ́n onukpá Yudafɔ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Brɛ́á Yudafɔ bowun ɔdɔm amʋ a, Paulo aná ɩwɩ lɔ́wa amʋ́ olu. Ɩ́nɩ sʋ begyi Paulo asʋn blɩ́hɛ́ amʋ nwɛ́ɛn, síá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Támɛ Paulo mʋa Barnaba bɔwa klʋn bláa ahá ámʋ bɛɛ, “Tɛkɩ mlɩ lehián ánɩ́ abégyankpá bláa Bulu asʋ́n ánfɩ. Támɛ ɩ́nɩá mlɩlékiná mʋ́ nu, mlɩdɛ́ mlɩ ɩwɩ kɩ́ɩ mlɩaa, mlɩméhián nkpa ánɩ́ ɩtamatá ámʋ sʋ á, anɩlayínkí ayɔ́ ɔmá bámbásʋ́fɔ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tsúfɛ́ alɩ́ Bulu lɔ́wa anɩ nɩ́. Ɔbɛ́ɛ, ‘Napʋ́ fʋ́ bwɛ́ ɔkandɩ́ɛ há ɔmá bámbásʋ́fɔ. Ɔyɩ́tɔ́ ahá fɛ́ɛ́ bɔ́tsʋn fʋsʋ nyá nkpa ánɩ́ ɩtamatá.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Brɛ́á ɔmá bámbásʋ́fɔ ámʋ bonu asʋ́n ánfɩ á, ansɩ́ legyi amʋ́, bɛ́kanfʋ́ anɩ Wíe asʋ́n ámʋ. Ɩnʋ ahá ánɩ́ Bulu lalɛ́ ɔbɛ́ɛ, bʋnyáa nkpa ánɩ́ ɩtamatá bɔhɔ asʋ́n ámʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Anɩ Wíe asʋ́n ámʋ ɩlɛklɛɩ́ wíé ɔmá ámʋtɔ ɔtɩ́nɛgyíɔtɩ́nɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Támɛ Yudafɔ ámʋ pʋ́ atsɩá bʋbʋ Yudafɔ osúmtɔ́, obú bʋ amʋ́sʋ́ pʋ́ wúlu ahandɛ bɔkʋsʋ́ lɩ́ɩ́ Paulo mʋa Barnabasʋ, gya amʋ́ lɛ́ ɔmá ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sumbí ayɔpʋ́ ámʋ bɛkpakpáa amʋ́ ayabitɔ-ɩsɩ wʋ́lɩ́ amʋ́ nwunsʋ, bɛnatɩ́ yɔ́ Ikonion wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Támɛ Ɔŋɛ Wankɩ́hɛ́ pʋ́ ansigyí lɔbʋlá Antiokia akasɩ́pʋ́ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonion wúlutɔ ɛ́ á, alɩ kɛ́n Paulo mʋa Barnaba bɔyɔ Yudafɔ ofíakpa nɩ. Bɛblɩ́ Bulu asʋ́n ɩnʋ wankláán. Mʋ́ sʋ Yudafɔ pʋ́ Griikifɔ tsɔtsɔɔtsɔ bɔhɔ Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Támɛ Yudafɔ ámʋ́ʋ́ bʋmohogyi amʋ bɔtɔɩ́ wá ɔmátɔ́fɔ ámʋ asʋtɔ, há amʋ́ bɔkʋsʋ́ lɩ́ɩ́ ahógyipʋ amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ifú mɛkɩtá Paulo mʋa Barnaba. Betsiá ɩnʋ wá ɔpá blɩ́ anɩ Wíe Yesu asʋ́n ámʋ wankláán. Yesu ɛ́ lɛ́lɩɩ́ amʋ́ ɔma, sʋ bɔbwɛ ofúla pʋ́ osúna pʋ́súná ánɩ́ mʋ awɩtɔlɛ asʋ́n ámʋ́ʋ́ bʋdɛblɩ́ ámʋ igyi ɔnɔkwalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mʋ́ sʋ wúlu amʋtɔ ɩlɔbɔɩ́ anyɔ. Akʋ bobuo Yudafɔ ámʋ, akʋ ɛ́ bobuo sumbí ayɔpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mʋ́ ɔma a, Yudafɔ, ɔmátɔ́fɔ pʋ́ amʋ́ ahandɛ bɔbwɛ agywɩɩn bɛɛ, bɔ́wa sumbí ayɔpʋ́ ámʋ ɩwɩɔsɩntɔ, dá amʋ́ abwi mɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sumbí ayɔpʋ́ ámʋ bonu asʋ́n ánfɩ. Mʋ́ sʋ bɛsrɩ́ yɔ́ Likaonia awúlu yilé Listra mʋ́a Derbe pʋ́ awúluá ɩbʋ mantáa ɩnʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bɛda asʋn wankláán ámʋ ɔkan ɩnʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Oyin ɔkʋ létsiá Listra wúlutɔ, bɔkwɩɩ́ mʋ ɩbɔ. Ɔmɔkʋ́kʋ́sʋ́ lɩ́ɩ́ mʋ ayabisʋ kɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɩbɔ anfɩ tsie ɔdɛ Paulo asʋn blɩ́hɛ́ nu. Paulo lési lɩɩ́ kɩ mʋ alɩɩ, olowun ánɩ́ alahogyiá Bulu ɔbɛ́talɩ́ tsá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mʋ́ sʋ ɔlɔkplʋ́n kʋklʋ́kʋ́ʋ́ blɩ́ ɔbɛ́ɛ, “Kʋsʋ lɩɩ fʋ́ ayabi anyɔsʋ.” Ɩnʋ oyin ámʋ lɔ́kʋsʋ́ ɔtsáwʋlɛ pɛ́, wá natɩ́ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Brɛ́á ɔdɔm amʋ bowun tɔ́á Paulo labwɛ́ á, bɔkplʋ́n blɩ́ Likaonia ɔblɩ́tɔ bɛɛ, “Ɩkpɩ ámʋ badámlí anyánkpʋ́sa kplɩ́ ba anɩ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mʋ́ sʋ bɔpʋ amʋ́ ɔkpɩ kpɔnkpɔntɩ dá tɩ́ Barnaba bɛɛ, “Seus.” Bɔpʋ mʋ ɔtsɩámɩ dá tɩ́ Paulo bɛɛ, “Hermes,” tsúfɛ́ Paulo lɩ́ɩ́ amʋ́ ɔnɔ́, ɔdɛtɔɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ɔkpɩ Seus ɔtswɛ́kpa bʋ wúlu ɔnɔ́. Seus igyí ɔhapʋ́ lɔ́yɔ́pʋ nnantswie pʋ́ oyí ntswɩ́tswɩ́ɩ ba wúlu ɔnɔ́ ɩnʋ. Tsúfɛ́ mʋa ɔdɔm amʋ bʋdekléá bɔ́tswɛ sumbí ayɔpʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Brɛ́á Barnaba mʋa Paulo bonu tɔ́á bɛbá bɔbwɛ á, bɛkɩtá amʋ́ atadɩɛ bálɩ́. Ilosuná ánɩ́ bʋmotsulá dɩ́nká ɩtɔ́ ámʋ́ʋ́ bɛbá bɔbwɛ ámʋsʋ. Bɛsrɩ́ wíé ɔdɔm amʋtɔ blɩ́ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ntogyi mlɩdɛ́ ɩ́nɩ bwɛ? Anɩ ɛ́ anyánkpʋ́sa anɩgyí fɛ́ mlɩ. Bulu asʋn wankláán abá bɛbláa mlɩ, amlɩsi atɔkpan ánfɩ ɔmagyáa bobuo anɩ Wíe Bulu Ɔkɩankpapʋ. Mʋlɔ́bwɛ ɔsʋ́ mʋ́a asɩ, ɔpʋ pʋ́ mʋ́tɔ́ atɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bɩ́mbɩ́ ámʋ a, olesi ɔkpa há ɔmágyíɔmá ánɩ́ bʋbwɛ́ɛ tɔ́á bʋdeklé. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Támɛ mʋ́ ó á, Bulu mɔ́kʋ́sí atɔ wankláán tsɔtsɔɔtsɔ bwɛ, pʋ́súná ánɩ́ mʋbʋ ɩnʋ. Mʋtɛ́há nyankpʋ totswie, mlɩ ndɔtɔ atɔ́ tɔwá alɛ́. Mʋtɛ́há mlɩ atogyihɛ, ɔtɛhá ansɩ́ tegyi mlɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paulo aná asʋn blɩ́hɛ́ anfɩ fɛ́ɛ́ ɔma a, ɩlɔwa ɔnlɩn asa bɛtalɩ́ ká ɔdɔm amʋ tin bɛɛ, bʋmátɩn mbwɩ wʋ́lɩ́ amʋ́ ayabiasɩ tswɛ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mʋ́ ɔma a, Yudafɔ akʋ botsu Antiokia ánɩ́ ɩbʋ Pisidia ɔmátɔ́ pʋ́ Ikonion wúlutɔ ba bɛblɩ́ asʋ́n pʋ́tsɛ ɔdɔm amʋ agywɩɩn, bɔkʋsʋ́ lɩ́ɩ́ Paulosʋ. Bɛda Paulo abwi, bɩ́tɩ́a mʋ dálɩ wúlu amʋtɔ. Bʋkɩ bɛɛ alawú, sʋ besi mʋ tswɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Támɛ brɛ́á akasɩ́pʋ́ amʋ bɛba bobomlí Paulo a, ɔlɔkʋsʋ́ yínkí yɔ́ wúlu amʋtɔ. Mʋ́ ɔyɩ kɛhɛ a, mʋa Barnaba bɛnatɩ́ yɔ́ Derbe wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo mʋa Barnaba bɛda asʋn wankláán ámʋ ɔkan Derbe. Ahá tsɔtsɔɔtsɔ bɛdamlí klʋntɔ mlí Yesu akasɩ́pʋ́. Mʋ́ʋ́ bɛlayínkí yɔ́ Listra, tsʋn yɔ Ikonion alɩɩ bɛbɛdalɩ Antiokia ánɩ́ ɩbʋ Pisidia ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɩnʋ Paulo mʋa Barnaba bɔwa akasɩ́pʋ́ amʋ atɛtɔ-ɔnlɩn bɛɛ, bʋkɩ́ta hógyi amʋtɔ. Bɛbláa amʋ́ bɛɛ, “Ilehián ánɩ́ abɔ́tsʋn ipian tsɔtsɔɔtsɔtɔ asa abówie Bulu iwíegyí ámʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bɔtʋ́ ɔpasua kugyíkʋ á, bʋtɛklɩ́ ɔnɔ́ bɔ́ mpáɩ, yáɩ́ ahandɛ há amʋ́, pʋ́ amʋ́ wá anɩ Wíe amʋ́ʋ́ amʋ́ ansɩ́ dɩn mʋsʋ ámʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Beki Pisidia ɔmátɔ́ ɔpasua ámʋsʋ tá á, bɛba Pamfilia ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bɛda Bulu asʋn wankláán ámʋ ɔkan Perge wúlutɔ. Bɔkʋsʋ́ tsú ɩnʋ yɔ́ Atalia wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Paulo mʋa Barnaba bɛlatsíá ntsusʋ-yibitɔ tsú ɩnʋ bowie Antiokia. Ɩnʋ gyí ɔtɩ́nɛ́á ahógyipʋ amʋ begyankpá klɩ́ ɔnɔ́ bɔ́ mpáɩ, ánɩ́ Bulu ɔwáa awɩtɔlɛ ha amʋ́, mɛ́nɩ bɔ́yɔ agyʋ́má ánfɩ bamɔ́ mʋ́ ɔnɔ́ ánfɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Brɛ́á bowie Antiokia a, bɛtɩ ɔpasua ámʋ fɛ́ɛ́ fia. Bɛbláa amʋ́ alɩá Bulu lapʋ́ amʋ́ gyi gyʋma, pʋ́ alɩá Bulu lahá ahá ánɩ́ bʋmegyí Yudafɔ ɛ́ bahɔ mʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Betsiá akasɩ́pʋ́ amʋ wá nkɛ tsɔtsɔɔtsɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Brɛ́á Paulo mʋa Barnaba bʋbʋ Antiokia a, ayin akʋ botsu Yudea ɔmátɔ́ ba ɩnʋ. Bosuná ahógyipʋ ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ atɔ́ bɛɛ, nɩ́ bʋmɔkʋ́tɩ́n keté Mose mbla ɔnɔ́ á, Bulu mɔ́ɔhɔ amʋ́ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo mʋa Barnaba bɔkʋsʋ́ lɩ́ɩ́ asʋ́n ánfɩsʋ. Mʋ́ sʋ amʋ́a atɔ́ asunápʋ́ amʋ begyi mʋ́ nwɛ́ɛn kínkíínkín. Ɩ́nɩ sʋ bɛblɩ́ bɛɛ, bɔ́wa Paulo mʋa Barnaba pʋ́ Antiokia ahógyipʋ amʋ akʋ Yerusalem, abʋyowun Yesu sumbí ayɔpʋ́ pʋ́ ɩnʋ ɔpasua ahandɛ amʋ tsú asʋ́n ánfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɔpasua ámʋ besi ahá ámʋ ɔkpa bɛnatɩ́. Brɛ́á bɔyɔ́ á, bʋna Foenike pʋ́ Samaria ɔmátɔ́. Bɛbláa ɩnʋfɔ ámʋ bɛɛ, ahá ánɩ́ bʋmegyí Yudafɔ ɛ́ badámlí klʋntɔ ba Bulu wá. Asʋ́n ánfɩ lɛhɩɛ wá ahógyipʋ amʋ fɛ́ɛ́ ansigyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Brɛ́á bowie Yerusalem a, ɔpasua ámʋ, amʋ́ ahandɛ pʋ́ sumbí ayɔpʋ́ ámʋ bɔhɔ amʋ́ atúu. Paulo aná bɛbláa amʋ́ tɔ́á Bulu labwɛ́ tsʋn amʋ́sʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Támɛ ahógyipʋ amʋ akʋá botsú Farisifɔtɔ bɔkʋsʋ́ lɩ́ɩ́ blɩ́ bɛɛ, “Ilehián ánɩ́ ɔmá bámbásʋ́fɔ ámʋ bɛ́tɩn keté, gyi Mose mbla ɛ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sumbí ayɔpʋ́ ámʋ pʋ́ ɔpasua ahandɛ amʋ befia yɔ asʋ́n ánfɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bɛbɩtɩ́ asʋ́n ánfɩ wá ɔpá. Mʋ́ ɔma a, Petro lɔ́kʋsʋ́ lɩ́ɩ́, bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó, mlɩyin ánɩ́ tsú brɛ́ kʋtɔ á, Bulu lɛ́lɛ mɩ́ tsú mlɩtɔ ɔbɛ́ɛ, mbláa ahá ánɩ́ bʋmegyí Yudafɔ mʋ asʋn wankláán ámʋ, mɛ́nɩ amʋ́ ɛ́ bónu, hɔ mʋ́sʋ́ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bulu yín nyankpʋsa klʋntɔ. Ɔlɔpʋ Ɔŋɛ Wankɩ́hɛ́ amʋ há amʋ́, fɛ́ alɩá ɔlɔpʋhá anɩ pʋ́súná ánɩ́ alahɔ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Olosuná ánɩ́ bʋmegyí ɔtsan há anɩ, tsúfɛ́ ɔlɛha amʋ́ klʋntɔ lɛtɩn brɛ́á amʋ́ ɛ́ bohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ntogyi sʋ mlɩdɛ́ Bulu sɔ́ɔ kɩ? Ntogyi sʋ́ mlɩdɛ́pʋ Mose mbla ánfɩ anɩa anɩ anáin anɩmɛ́talɩ́ gyi mʋ́sʋ́ ánfɩ han akasɩ́pʋ́ anfɩ? ");
INSERT INTO nkoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɛkɛkɛɛkɛ! Anɩlahogyi ánɩ́ Bulu ɔbɔ́tsʋn anɩ Wíe Yesu awɩtɔlɛsʋ hɔ anɩ nkpa fɛ́ amʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Brɛ́á Petro lɔ́tɔɩ́ tá á, afíapʋ amʋ fɛ́ɛ́ bɔbwɛ díín. Mʋ́ʋ́ Paulo mʋa Barnaba bɛbláa amʋ́ alɩá Bulu lɔ́tsʋn amʋ́sʋ́ bwɛ́ ofúla pʋ́ osúna tsɔtsɔɔtsɔ ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Brɛ́á Paulo mʋa Barnaba bɔtɔɩ́ tá á, Yakobo lɔ́yɔ mʋ́sʋ́ ɔbɛ́ɛ, “Apíó, mlɩyaa asʋ amlɩnu. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petro labláa anɩ ɔbɛ́ɛ, Bulu légyankpá lɛ́ súná ánɩ́ otekle ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ asʋ́n. Mʋ́ sʋ ɔlɛlɛ amʋ́tɔ́ akʋ bwɛ́ mʋ ahá. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Asʋ́n ánfɩ pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋn blɩ́hɛ́ labwɛ́ kʋlɛ. Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bulu ɔbɛ́ɛ. Ɩ́nɩ ɔma a, nɛ́latsú Dawid iwíegyí amʋ́ʋ́ ɩladɩda ámʋ kʋ́sʋ́. Nɛ́layi mʋ́ abuntíi fɛ́ɛ́, há mʋ́ bɛ́lɩɩ́ wankláán, ");
INSERT INTO nkoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","mɛ́nɩ aha tráhɛ amʋ pʋ́ amʋ́á bʋmegyí Yudafɔ, mɩ́ dá dɩn amʋ́sʋ́ fɛ́ɛ́ bódunká mɩ́á ngyi amʋ́ Wíe, wun mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Alɩ́ mɩ́, mlɩ Wíe Buluá nɛlɛ ɩ́nɩ súná tsú bɩ́mbɩ́ ndɛblɩ́ nɩ́.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ɩ́nɩ sʋ tɔ́á mɩ́ Yakobo ndɛblɩ́ gyí, mlɩmáha apʋ asʋansʋ kɩ́klɩ ahá ánfɩ bʋmegyí Yudafɔ, badámlí klʋntɔ ba Bulu wá ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mboún mlɩha awanlɩn ɔwʋlʋ́ bláa amʋ́ anɩaa, bʋmágyi atogyihɛá bapʋ́há ɩkpɩ, tsúfɛ́ mʋ́ ɩwɩ mɛtɩn. Bʋmáwa atsɩ mʋ́a ayin asʋ́n. Bʋmágyi ɔbwɩá bɔpʋsáa mʋ mɔ́ pʋ́ obugya. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tsúfɛ́ bɩ́mbɩ́ ɔpá á, bʋtɛdá Mose mbla ámʋ ɔkan wúlugyíwúlutɔ, bʋtɛkla mʋ́ Yudafɔ ofíakpa kugyíkʋ ɔkpʋ́nʋ́ ɔdakɛ́ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mʋ́ sʋ sumbí ayɔpʋ́ ámʋ, ɔpasua ahandɛ amʋ pʋ́ ɔpasua ámʋ bɔbwɛ agywɩɩn bɛɛ, bɛlɛ ayin akʋ tsú amʋ́tɔ́ abʋbuo Paulo mʋa Barnaba yɔ Antiokia. Bɛlɛ Yuda ánɩ́ bʋtɛtɩ́ mʋ Barsaba mʋa Silas. Amʋ́ fɛ́ɛ́ bʋgyi akpapʋ́ há ahógyipʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɔwʋlʋ́ ánɩ́ bɔpʋhá amʋ́ bɔpʋyátɔ asʋ́n gyí: “Ahógyipʋá mlɩmégyí Yudafɔ, mlɩbʋ Antiokia, Siria pʋ́ Kilikia ɔmátɔ́. Mlɩ apíó sumbí ayɔpʋ́ pʋ́ ɔpasua ahandɛ dɛ́ ɔwʋlʋ́ ánfɩ wanlɩ́n sɩ́sɩ́ mlɩ. “Anɩdɛ́ mlɩ itsiá ha. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Anɩlónu ánɩ́ anɩ apíó akʋ botsu anɩtɔ ba mlɩ wá ɩnʋ, bɔpʋ asʋankʋ kɩ́klɩ mlɩ, pʋ́yíntá mlɩ agywɩɩn. Anɩmɔ́kʋ́wá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɩ́nɩ sʋ anɩlafia, tsúlá ánɩ́ abɛ́lɛ aha akʋ abʋkpa anɩ apíó adwɛpʋ́ Barnaba mʋa Paulo ba mlɩ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ahá ánfɩ lásí amʋ́ nkpa há anɩ Wíe Yesu Kristo agyʋ́má ámʋ sʋ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mʋ́ sʋ anɩdɛ́ Yuda mʋa Silas wa anɩaa, bʋpʋ́ʋ ɔnɔ́ bɛbláa mlɩ asʋ́n ámʋ́ʋ́ anɩlawánlɩ́n wá ɔwʋlʋ́ ámʋtɔ ámʋ kɛ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ɔŋɛ Wankɩ́hɛ́ lalɛ́ súná anɩ, anɩ ɛ́ anɩlahɔ mʋ́ ánɩ́ ɩma alɛá abɔ́pʋ atɔ dwindwín kʋkʋ sʋ́rá mlɩ, dʋn mbla ánfɩ mʋ́ ɩwɩ dehián anfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mbla ámʋ gyí, ‘Mlɩmágyi atogyihɛá bapʋ́há ɩkpɩ. Mlɩmágyi ɔbwɩá bɔpʋsáa mʋ mɔ́ pʋ́ obugya. Mlɩmáwa atsɩ mʋ́a ayin asʋ́n.’ “Nɩ́ mlɩdɛ́ mbla ánfɩsʋ gyi a, ɩbɔ́wa alɛ́ há mlɩ. Anɩlafʋn nfɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bɔwanlɩ́n ɔwʋlʋ́ ánfɩ há amʋ́ tá á, besi amʋ́a sumbí ayɔpʋ́ ámʋ ɔkpa bɔpʋya Antiokia. Boyówie ɩnʋ tɩ́ ahógyipʋ amʋ fɛ́ɛ́ fía, pʋ́ ɔwʋlʋ́ ámʋ wá amʋ́ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bɛkla ɔwʋlʋ́ ámʋ a, ansɩ́ lɛhɩɛ gyi amʋ́, tsúfɛ́ mʋ́tɔ́ asʋ́n lɛha klʋn lɛ́dɩ amʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda mʋa Silas, bʋgyi Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɔtɔɩ́ kplá amʋ́ wankláán pʋ́wá amʋ́ ɔwʋnlɩ́n, wá amʋ́ atɛtɔ-ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Betsiá amʋ́ wá nkɛ kpalobí, ɔpasua ámʋ lési amʋ́ ɔkpa iwilwiitɔ, beyinkí yɔ́ ahá ámʋ́ʋ́ bɔwa amʋ́ sumbí ámʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo mʋa Barnaba ɛ́ betsiá Antiokia ɩnʋ yɔ́fʋn brɛ́ kʋ. Amʋ́a ɩnʋ ahógyipʋ amʋ akʋ betsiá súná atɔ́, tsíá dá anɩ Wíe asʋn wankláán ámʋ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Brɛ́ kʋ ɔma a, Paulo lɛ́bláa Barnaba ɔbɛ́ɛ, “Ha ayinki yɔ awúluá anɩladá anɩ Wíe asʋn wankláán ámʋ ɔkan fɛ́ɛ́sʋ́, ayɛkɩ alɩá bʋtsie.” ");
INSERT INTO nkoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba lékléá bɛ́kpa Yohane ánɩ́ bʋtɛtɩ́ mʋ Marko buo ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Támɛ Paulo lɛ́blɩ́ ɔbɛ́ɛ, ɩma alɛá Marko obóbuo amʋ́, tsúfɛ́ ɔmɛtrá buo amʋ́ abʋyɔ Bulu agyʋ́má ámʋ. Oleyinkí amʋ́ ɔma tsú Pamfilia wúlutɔ ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paulo mʋa Barnaba bɛprɩ́ɩ asʋ́n ánfɩ kínkíínkín, ɩlɛha bɛmaɩ́n abasʋ. Barnaba lɛ́kpa Marko buo ɩwɩ, botsu ntsusʋ-yibi yɔ́ Kipro ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo ɛ́ lɛ́kpa Silas buo ɩwɩ, Antiokia ahógyipʋ amʋ bɔpʋ amʋ́ wá Bulu ɩbɩtɔ, bɔpʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulo lɔ́yɔtsʋn Siria mʋ́a Kilikia ɔmátɔ́; ɔlɔwa ɔpasua ámʋ́ʋ́ ɩbʋbʋ ɩnʋ ámʋ ɔwʋnlɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo mʋa Silas bɛnatɩ́ yɔ́ Derbe pʋ́ Listra. Ohógyipʋ ɔkʋá bʋtɛtɩ́ mʋ Timoteo bʋ Listra wúlutɔ ɩnʋ. Mʋ yin gyí Yudayin ánɩ́ ɔlɔhɔ Yesu gyi, támɛ mʋ sɩ gyí Griikiyin. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Apíó ánɩ́ bʋbʋ Listra pʋ́ Ikonion bɛtɩ Timoteo ɩdayilé. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo lékléá ɔbɛ́kpa Timoteo nátɩ́. Mʋ́ sʋ ɔlɛha bɛtɩn Timoteo keté, tsúfɛ́ Yudafɔ ámʋ́ʋ́ bʋbʋ ɩnʋ ámʋ fɛ́ɛ́ bʋyin ánɩ́ Griikiyin Timoteo mʋ sɩ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Brɛ́á bɔyɔ́ á, bowíé wúlugyíwúlusʋ bʋtosúná ɩnʋ ahógyipʋ mbla oduá Yesu sumbí ayɔpʋ́ ámʋ pʋ́ ɔpasua ahandɛ amʋ́ʋ́ bʋbʋ Yerusalem amʋ bawá bɛɛ bʋgyíi mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ɩ́nɩ sʋ ɔpasua ámʋ benya ɔwʋnlɩ́n hógyitɔ, klɛ́ɩ́ ekekegyíɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo mʋa mʋ aba ámʋ bɔtsʋn Frigia pʋ́ Galatia ɔmásʋ́. Tsúfɛ́ Ɔŋɛ Wankɩ́hɛ́ mɛ́ha amʋ́ ɔkpa ɔbɛ́ɛ, bʋdáa Bulu asʋ́n ámʋ ɔkan Asia ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Brɛ́á bowie Misia ɔsʋlʋ́ʋ ɔka á, bɔbwɛ agywɩɩn bɛɛ béyinkí tsʋn yɔ Bitinia ɔmátɔ́, támɛ Yesu Ɔŋɛ́ mɛha amʋ́ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mʋ́ sʋ bɔtsʋn Misia ɔsʋlʋ́sʋ kplɩ́ yɔ́ Troa wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mʋ́ onyé á, Paulo lówun atɔ́. Olowun ánɩ́ Makedoniayin ɔkʋ lɩ́ɩ́ mʋ ansɩ́tɔ́, ɔdɛ mʋ kokóli ɔbɛ́ɛ, “Fa ɔpʋ amʋ ba Makedonia, afʋbegyi anɩ bʋalɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo lénya wun atɔ́ ámʋ alɩ, ɩlɔwankɩ́ mʋ ánɩ́ Bulu dɛ́ anɩ wa ɔbɛ́ɛ, ayɔ́ yɛda asʋn wankláán ámʋ ɔkan ɩnʋ. Mʋ́ sʋ anɩlɔ́pʋ ɔkpa yɔ́ Makedonia. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Anɩlówie ntsusʋ-yibitɔ tsú Troa, fá ɔpʋ yɔ́ Samotrake ɔsʋlʋ́sʋ. Mʋ́ ɔyɩ kɛhɛ a, anɩlɛ́latsíá yɔ́ Neapoli wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Anɩlɔ́pʋ ayabitɔ tsú Neapoli yɔ́ Filipi wúlutɔ. Filipi gyí Makedonia wúlu yilé nɩ́. Romafɔ bʋ́ʋ wúlu anfɩtɔ. Anɩlétsiá ɩnʋ nkɛ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ɔkpʋ́nʋ́ ɔdakɛ́ á, anɩlɛ́dalɩ wúlutɔ yɔ́ ɔpʋ ɔnɔ́ ɔtɩnɛkʋá anɩkɩ́ anɩaa, abówun ɔtɩ́nɛ́á Yudafɔ bʋtefia bɔ mpáɩ. Anɩlétsiá ɩnʋ bláa atsɩ akʋá bebefia ɩnʋ Bulu asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Atsɩá bonu asʋ́n ámʋtɔ ɔkʋlɛ gyí Lidia. Tiatirayin ogyi, ɔtɛfɛ́ tatiá mʋ́ ntsu lɛpɛ, ɩbʋ bíá. Bulu osúmpʋ́ ogyi. Anɩ Wíe lɛ́ha mʋ olonu Paulo asʋn blɩ́hɛ́ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mʋ́ sʋ brɛ́á anɩlɔ́bɔ mʋa mʋ wóyítɔ́ ahá asú á, olobwií ɩpa há anɩ, blɩ́ ɔbɛ́ɛ, “Nɩ́ mlɩlahogyi ánɩ́ nahɔ Yesu gyi a, mlɩbetsiá mɩ́ wóyítɔ́.” Ɔtsɩ ánfɩ bʋ anɩsʋ alɩɩ anɩlóbuo mʋ yɔ́ mʋ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɛkɛ ɔkʋ ayɔ́ Yudafɔ mpáɩ ɔbɔkpá ɩnʋ á, anɩlɔ́tʋ otsibi ɔkʋá ogyi ɔkpábi ɩnʋ. Atɔ́la ɔŋɛ́ bʋ mʋsʋ, ɔtɛlá atɔ́, blɩ́ asʋ́n ánɩ́ ɩbɛ́ba. Ɔtɔbwɛ́ kɔ́ba tsɔtsɔɔtsɔ há mʋ awíe tsú mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Otsibi anfɩ lɛ́kplá buo anɩa Paulonyɔ. Ɔna ɔdɛkplʋ́n blɩ́ ɔbɛ́ɛ, “Ahá ánfɩ gyí Ɔsʋ́sʋ́ʋ́sʋ́ Bulu ámʋ asúmpʋ́ nɩ. Amʋ́dɛ́ mlɩ nkpahɔ́ɔ ɔkpa suná nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɔlɔbwɛ mʋ́ nkɛ tsɔtsɔɔtsɔ. Ɩ́nɩ lɛhan Paulo. Mʋ́ sʋ ɔlɛdamlí bláa otsibi amʋ ɔbɛ́ɛ, “Atɔ́la ɔŋɛ́, ndɛ mbla wa há fʋ́ Yesu Kristo dátɔ́, dalɩ mʋtɔ!” Ɩnʋnʋ ɔŋɛ́ ámʋ lɛ́dalɩ mʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɔkpábi amʋ awíe bowun ánɩ́ amʋ́ kɔ́ba ɔkpa latin. Mʋ́ sʋ bɛkɩtá Paulo mʋa Silas, bɩ́tɩ́a amʋ́ ya wúlu ahandɛ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bɔpʋ amʋ́ ya Romafɔ asʋ́n agyípʋ́ bɛɛ, “Yudafɔ ahá ánfɩ bʋgyi, bʋdɛ asʋ́n klée wa anɩ wúlu anfɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bʋdɛ amándɩ́ɛ́ laláhɛ ánɩ́ anɩ mbla mɛha mʋ́ ɩwɩ ɔkpa suná. Romafɔ anɩ mʋ́ anɩgyí. Anɩmɛ́ɛtalɩ́ hɔ amʋ́ amándɩ́ɛ́ ámʋ gyi mʋ́sʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ɩnʋ ɔdɔm amʋ botu bun Paulo mʋa Silasʋ. Asʋ́n agyípʋ́ amʋ bɛha bɛɛ bʋwɔ́ɩ amʋ́ atadɩɛ, abʋnwɛn amʋ́ mplɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bɛpɩtɩ́ Paulo mʋa Silas atɔ́ wankláán tá á, bɛha bɔpʋ amʋ́ tswɩ obu. Bɛbláa obu adɩpʋ́sʋ́ ɔkɩ́pʋ bɛɛ, ogyóo amʋ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Asʋ́n ámʋ́ʋ́ bɛbláa obu adɩpʋ́sʋ́ ɔkɩ́pʋ amʋ sʋ ɔlɔpʋ amʋ́ yɛ́tswɩ obutótɔ́, wá amʋ́ ayabi kplakitsi. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mʋ́ ɔyɩ́-nsɩnɛ́ á, Paulo mʋa Silas bʋdɛ mpáɩ bɔ, bʋdɛ ɩlʋ wa kánfʋ́ Bulu. Obu adɩpʋ́ atráhɛ amʋ ɛ́ bʋda bʋdenu. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ɔtsáwʋlɛ pɛ́ á, ɔsʋlʋ́ʋ lɛ́kpɩnkɩ́ ɔwʋnlɩ́nsʋ́, ɩlɛkpɩnkɩ́ obu ámʋ ntswɩasɩ. Mʋ́ aklʋn fɛ́ɛ́ lefinkí. Obu adɩpʋ́ ámʋ ɩkan pʋ́ amʋ́ kplakitsi amʋ fɛ́ɛ́ lɔwɔɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Obu adɩpʋ́sʋ́ ɔkɩ́pʋ amʋ létsinkí, wun ánɩ́ aklʋn amʋ fɛ́ɛ́ lafínkí. Ɩnʋ ɔlɛlɛ ɔdayí ɩya anyɔ ɔbɛ́ɛ amʋwɔ ɩwɩ, tsúfɛ́ ɔkɩ ɔbɛ́ɛ obu adɩpʋ́ ámʋ fɛ́ɛ́ badálɩ srɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Támɛ Paulo lɔ́kplʋn kʋ́klʋ́kʋ́ʋ́ bláa mʋ ɔbɛ́ɛ, “Mábwɛ ɩwɩ tɔtɔ. Anɩ fɛ́ɛ́ anɩbʋ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Obu adɩpʋ́sʋ́ ɔkɩ́pʋ amʋ lɛ́ha botsu ɔkandɩ́ɛ ba mʋ, ɔlɔwa ɔsa wíé obu ámʋtɔ. Ifú dɛ mʋ, sʋ ɔdɛkpɩnkɩ́ kpakpakpakpa. Ɔlɛyɛ́da akpawunu Paulo mʋa Silas ayabitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ɩnʋ ɔlɛkpa amʋ́ dálɩ yɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mɩ́ awíé, ntɔ mbwɛ́ɛ asa Bulu ɔhɔ mɩ nkpa?” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mʋ́ʋ́ Paulo mʋa Silas bɛbláa mʋ bɛɛ, “Hɔ Yesu gyi, mɛ́nɩ Bulu ɔbɔ́hɔ fʋ́a fʋ́ wóyítɔ́ ahá fɛ́ɛ́ nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mʋ́ʋ́ bɛbláa mʋa mʋ wóyítɔ́ ahá fɛ́ɛ́ anɩ Wíe Yesu asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Onyé-onyé ámʋ a, oyin ámʋ léyiá amʋ́ ɩwɩ nlɔ ámʋ́ʋ́ benya brɛ́ ámʋ́ʋ́ bɛpɩtɩ́ amʋ́ atɔ́ ámʋ. Ɔlɛha amʋ́ bɔbɔ mʋa mʋ wóyítɔ́ ahá ámʋ asú ɩnʋnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Obu adɩpʋ́sʋ́ ɔkɩ́pʋ anfɩ lɔ́pʋ amʋ́ ya mʋ wóyítɔ́, ɔlɛyɛ́ha bɛnɩná atɔ́ há amʋ́ begyi. Ɩ́nɩá mʋa mʋ wóyítɔ́ ahá fɛ́ɛ́ bahɔ Bulu gyi sʋ á, ansɩ́ lɛhɩɛ gyi amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mʋ́ ɔyɩ kɛhɛ a, asʋ́n agyípʋ́ amʋ bɔwa ahá akɩtápʋ́ akʋ bɛɛ bʋyɛ́bláa obu adɩpʋ́sʋ́ ɔkɩ́pʋ amʋ bɛɛ, osíi ahá ámʋ abʋnatɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mʋ́ sʋ oyin ámʋ lɛ́bláa Paulo ɔbɛ́ɛ, “Asʋ́n agyípʋ́ amʋ bapʋ́ ɔmɛ sɩ́sɩ́ mɩ́ bɛɛ, nsíi fʋ́a Silas amlɩnatɩ. Mʋ́ sʋ mlɩnatɩ iwilwiitɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Támɛ Paulo lɛ́bláa ahá akɩtápʋ́ amʋ akʋ ɔbɛ́ɛ, “Bʋmegyi anɩ asʋ́n, támɛ banwɛ́n anɩ atɔ́ ɔbʋntɔ. Romafɔ anɩgyí, támɛ bawá anɩ obu. Ntogyi sʋ bʋdekléá bési anɩ ŋáintɔ? Ɛkɛkɛɛkɛ! Asʋ́n agyípʋ́ amʋ onutó bʋbá bɛlɛ anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ahá akɩtápʋ́ amʋ beyinkí yɔ́ yɛ́bláa asʋ́n agyípʋ́ amʋ. Brɛ́á bonu ánɩ́ Romafɔ Paulo mʋa Silas bʋgyi á, ifú lɛhɩɛ́ kɩ́tá amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mʋ́ sʋ boyóbwií ɩpa há Paulo aná, bɛkpa amʋ́ dalɩ yókokóli amʋ́ bɛɛ bʋdálɩ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ɩnʋ Paulo mʋa Silas bɛnatɩ́ yɔ́ Lidia wóyítɔ́. Befia apíó ahógyipʋ amʋ ɩnʋ, tɔɩ́ kplá amʋ́, wá amʋ́ ɔwʋnlɩ́n asa bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Brɛ́á Paulo mʋa Silas bɛnatɩ́ tsú ɩnʋ bɔyɔ́ á, bʋna Amfipoli pʋ́ Apolonia awúlusʋ bɛba Tesalonika. Yudafɔ ofíakpa kʋ bʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Fɛ́ alɩá Paulo tɔbwɛ́ brégyíbrɛ́ á, ɔlɔyɔ ofíakpa ɩnʋ ɔkpʋ́nʋ́ ɔdakɛ́, mʋa amʋ́nyɔ bɔyɔ Bulu asʋn wanlɩ́nhɛ́ amʋtɔ. Ɔlɔbwɛ mʋ́ alɩ tse sa sɔ́ɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ɔlɛlɛ Bulu asʋ́n ámʋtɔ súná amʋ́, dɩ́nká ibwi mʋ́sʋ́ ɔbɛ́ɛ, “Ilehián ánɩ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ), obówun ɩwɩɔsɩn wú, lákʋ́sʋ́ tsú afúlitɔ.” Ɔlɔyɔ mʋ asʋ́n ámʋsʋ ɔbɛ́ɛ, “Yesu anfɩ́ ndɛ mʋ ɩwɩ asʋ́n blɩ́ ánfɩ gyí Kristo amʋ nɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Paulo asʋ́n ánfɩ lɔwankɩ́ Yudafɔ ámʋtɔ akʋ. Mʋ́ sʋ bobuo mʋa Silas. Alɩ kɛ́n Griikifɔ Bulu asúmpʋ́ pʋ́ atsɩá obú bʋ amʋ́sʋ́ tsɔtsɔɔtsɔ ɛ́ bobuo amʋ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ɩ́nɩ lɛ́ha Paulo mʋa Silas ɩwɩ lɔ́wa Yudafɔ ámʋ olu. Mʋ́ sʋ bɛkpa aha laláhɛ akʋ buo ɩwɩ tsú brɔnʋsʋ, bɔpʋ ahá tsɔtsɔɔtsɔ yɛ́han agywɩɩn wúlu amʋtɔ. Betsií yɔ́ oyin ɔkʋá bʋtɛtɩ́ mʋ Yason wóyítɔ́, bʋdɛ Paulo mʋa Silas dunká abʋbɩtɩa amʋ́ ba ɔdɔm amʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Támɛ bʋmowun Paulo mʋa Silas. Mʋ́ sʋ bɛbɩtɩ́a Yason mʋa ahógyipʋ amʋ akʋ ya wúlu ahandɛ ansɩ́tɔ́, bʋdɛ okitikíti bɛɛ, “Ahá ánfɩ ná bʋdɛ agywɩɩn háan ɔyɩ́tɔ́ fɛ́ɛ́ nɩ́. Bawíé nfɩ, ");
INSERT INTO nkoNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason lahɔ amʋ́ yáɩ́ mʋ wóyítɔ́. Amʋ́ fɛ́ɛ́ bʋdɛkʋsʋ́ lɩ́ɩ́ Roma Owíe Dɛhɛn mblasʋ. Tsúfɛ́ bʋdɛ ahá bláa bɛɛ, owíe bambá ɔkʋ bʋ ɩnʋ, mʋ dá gyí Yesu.” ");
INSERT INTO nkoNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Brɛ́á wúlu ahandɛ pʋ́ ɔdɔm amʋ bonu asʋ́n ánfɩ á, ɩlɛhɩɛ han amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Támɛ bɛbɩtɩ́ Yason mʋa mʋ aba ámʋ ɩsʋ, bɛka ɩkɔ, ká ntam bɛɛ bʋmɛ́ɛtrá han agywɩɩn, besi amʋ́ bɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Besi owí lɛta, ahógyipʋ amʋ bɛha Paulo mʋa Silas bɛnatɩ́ yɔ́ Beroia wúlutɔ. Benya wíé ɩnʋ alɩ, bɔyɔ Yudafɔ ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yudafɔá bʋbʋ wúlu anfɩtɔ botsulá hɔ asʋ́n ámʋ dʋn amʋ́á bʋbʋ Tesalonika. Bɔpʋ ansigyí hɔ Bulu asʋ́n ámʋ, tsíá yɔ́ Bulu asʋn wanlɩ́nhɛ́ amʋtɔ ekekegyíɛkɛ kɩ bɛɛ, ɔnɔkwalɩ Paulo dɛ́ amʋ́ bláa. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yudafɔ tsɔtsɔɔtsɔ pʋ́ Griikifɔ atsɩ mʋ́a ayin ánɩ́ obú bʋ amʋ́sʋ́ ɛ́ bɔhɔ asʋ́n ámʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yudafɔ ámʋ́ʋ́ bʋbʋ Tesalonika amʋ bonu ánɩ́ Paulo layɔ́ ɔdɛ Bulu asʋ́n ámʋ ɔkan da Beroia. Ɩ́nɩ sʋ begya ɔkpa yɔ́ ɩnʋ bʋdɛ ɩnʋfɔ ámʋ agywɩɩn yintá. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ɔsasʋ, ahógyipʋ amʋ bɛlɛ Paulo lɛ́ wúlu amʋtɔ ya ɔpʋ ɔnɔ́, támɛ Silas mʋa Timoteo mʋ́ besi bʋbʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ahá ámʋ́ʋ́ beyési Paulo ɔkpa ámʋ bɛkpa mʋ alɩɩ yówie Atene wúlutɔ. Brɛ́á bʋdeyinkí á, Paulo lɔ́pʋ ɔmɛ sɩ́sɩ́ Silas mʋa Timoteo ɔbɛ́ɛ, bʋwáa ɔsa bɔtʋ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Brɛ́á Paulo lési otsie ogyo Silas mʋa Timoteo Atene wúlutɔ á, ɩnʋ tsiá lɛhɩɛ han mʋ. Tsúfɛ́ olowun ánɩ́ ɩkpɩ sɔ́ɔ́n bʋ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mʋ́ sʋ nɩ́ ɔyɔ́ Yudafɔ ofíakpa ɩnʋ á, mʋa Yudafɔ pʋ́ Griikifɔ ámʋ́ʋ́ bʋdɛ Bulu súm ámʋ bʋtetsíá lɛ́ asʋ́ntɔ́ há aba. Alɩ kɛ́n mʋa dɩnsʋ atsiápʋ́ ɛ́ betsiá tɔ́ɩ́ tsú mʋ́ ɩwɩ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mʋa atɩansɩpʋ akʋá botsu Epikuro pʋ́ Stoak ɔpasuatɔ ba ɩnʋ ɛ́ betsiá bɩ́tɩ́ asʋ́n ánfɩ. Amʋ́tɔ́ akʋ bɛfɩtɛ́ bɛɛ, “Ntɔ ɔkan ɔnɔ́tɔ́ ɔkapʋ́ ánfɩ dɛ́da?” Aha akʋ bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Ɩdɛbwɛ fɛ́ ɩkpɩ akʋ ɩwɩ ɔdɛtɔɩ́ tsú.” Tsúfɛ́ Paulo dɛ́ Yesu mʋa afúlikʋsʋ́ ɩwɩ asʋ́n ɔkan da. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mʋ́ʋ́ bɛkɩtá Paulo, kpá mʋ ya Areopago, igyi amʋ́ wúlu ahandɛ ofíakpa. Ahandɛ amʋ bɛbláa Paulo bɛɛ, “Anɩdéklé anɩaa, fʋtɔ́ɩ tsu fʋ́ atosunáhɛ́ pɔpwɛ amʋ ɩwɩ suna anɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Anɩmɔ́kʋ́nú asʋ́n ánfɩ kɩ. Mʋ́ sʋ anɩdéklé anɩaa, fʋlɛ́ɛ mʋ́tɔ́ suna anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tsúfɛ́ Atenefɔ pʋ́ afɔɔ́á bʋbʋ ɩnʋ fɛ́ɛ́ bʋtamabwɛ́ tɔtɔ dʋn asʋ́n ánɩ́ ɩlaba nu pʋ́ mʋ́ blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ɩnʋ Paulo lɔ́kʋsʋ́ lɩ́ɩ́ afíapʋ amʋ ansɩ́tɔ́ ɔbɛ́ɛ, “Atenefɔ, nawun ánɩ́ mlɩtɛhɩ́ɛ́ tswɛ ɩkpɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tsúfɛ́ ɩ́nɩá ndeki wúlu anfɩtɔ fɛ́ɛ́ á, nawun ntobí oduá mlɩtɔtswɛ. Nawun afɔdɩɛ-asubwi kʋá bɔwanlɩ́n dɩ́nká mʋ́sʋ́ bɛɛ, ‘Buluá Anɩméyín Mʋ.’ Mʋ́ sʋ Bulu ámʋ́ʋ́ mlɩdésum, mlɩméyín mʋ dá ámʋ ɩwɩ ɔkan ndɛda súná mlɩ á. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bulu lɔ́bwɛ ɔyɩ́ pʋ́ mʋ́tɔ́ atɔ́ fɛ́ɛ́. Mʋgyí ɔsʋ́ mʋ́a asɩ Owíe. Ɔtamatsíá ɔtswɛ́kpa ánɩ́ anyánkpʋ́sa ɩbɩ léyi mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɔtamadúnká tɔtɔ tsú ɔhaa wá, mɛ́nɩ ɩbwɛ fɛ́ tɔkʋ tehían mʋ. Tsúfɛ́ mʋtɛ́há ahá fɛ́ɛ́ nkpa, ɔŋɛ́ pʋ́ tógyítɔ́á itehían amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mʋlɛ́ha sʋ ahá fɛ́ɛ́ bɛlɩn tsu ɔbakʋ́lɛ pɛ́tɔ́, ɔlɛha bɛklɛɩ́ wá ɔyɩ́tɔ́ fɛ́ɛ́. Mʋlɛ́ha ɔmá kugyíkʋ ɔtɩ́nɛ́á bʋtsie pʋ́ brɛ́á bétsiá yɔ́fʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɔlɔbwɛ mʋ́ alɩ, mɛ́nɩ nyankpʋsa obódunká mʋ wun mʋ. Támɛ tɛkɩ ɔma ɩfɔ́ anɩtɔ ɔkʋkʋ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tsúfɛ́ ɔkʋ lɛ́blɩ́ ɔbɛ́ɛ, ‘Bulu sʋ anɩtsie nkpa. Mʋ sʋ́ anɩtɛkán ɩwɩ, anɩgyí alɩá anɩgyí.’ Fɛ́ alɩá mlɩ ɩlʋ awapʋ́ akʋ bɛblɩ́ bɛɛ, ‘Bulu ahá anɩ ɛ́ anɩgyí.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ɩ́nɩá Bulu ahá anɩgyí sʋ á, anɩmákɩ anɩaa, Bulu gyí fɛ́ tunkuá nyankpʋsa lapʋ́ sika pɛpɛ, sika futútú ntɛ́ɛ ibwi pwɛ́ mʋ́ alɩá odeklé. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bɩ́mbɩ́ ámʋ a, ahá bʋmɛbɩ alɩá Bulu gyí. Bulu lóbun ansíbi mʋ́sʋ́, támɛ séi mʋ́ á, alabláa anyánkpʋ́sa fɛ́ɛ́ ɔbɛ́ɛ, bʋdámli klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bulu lalɛ́ ɛkɛ yáɩ́ ánɩ́ ɔbɔ́tsʋn ɔhá ámʋ́ʋ́ alalɛ́ yáɩ́ ámʋsʋ gyi ɔyɩ́tɔ́ ɔhagyíɔha asʋ́n ɔnɔkwalɩsʋ. Odeklé ɔbɛ́ɛ ahá bʋbɩ́ɩ ánɩ́ ɔnɔkwalɩ igyi. Mʋ́ sʋ́ ɔlɔkʋsʋ́a ɔhá ámʋ tsú afúlitɔ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ɩ́nɩá Paulo lɔ́tɔɩ́ tsú afúlikʋsʋ́ ɩwɩ sʋ á, akʋ bɔmɔsɩ́ mʋ. Támɛ amʋ́tɔ́ akʋ bɛblɩ́ bɛɛ, “Anɩdéklé anɩaa, fʋtráa ba afʋbɛbláa anɩ asʋ́n ánfɩ kʋ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ɩnʋ Paulo lɔ́kʋsʋ́ dálɩ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Támɛ ahá kpalobí kʋ bɔhɔ Paulo asʋ́n ámʋsʋ gyi, bobuo mʋ. Amʋ́tɔ́ ɔkʋlɛ dá gyí Dionisio, oletsiá wúlu ahandɛ amʋtɔ. Mʋa ɔtsɩ ɔkʋá bʋtɛtɩ́ mʋ Damari pʋ́ aha akʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɩ́nɩ ɔma a, Paulo lɔ́kʋsʋ́ tsú Atene yɔ́ Korinto wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ɔlɔyɔ́tʋ Yudayin ɔkʋá bʋtɛtɩ́ mʋ Akwila, bɔkwɩɩ́ mʋ Italia ɔmanti kʋá bʋtɛtɩ́ mʋ́ Pontotɔ. Akwila mʋa mʋ ka Priskila bɛba Korinto ɩnʋ mɔkʋ́wá ɔpá. Tsúfɛ́ alɩ brɛ́ ámʋtɔ á, Roma Owíe Klaudio lagya Yudafɔ fɛ́ɛ́ lɛ́ Roma wúlutɔ. Paulo lɔ́yɔ amʋ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tati-obubí abwɛpʋ́ amʋ́ ɛ́ bʋgyi. Mʋ́ sʋ Paulo létsiá amʋ́ wá, mʋa mʋnyɔ betsiá bwɛ́ tati-obubí ámʋ fɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ɔkpʋ́nʋ́ ɔdakɛ́ kugyíkʋ á, Paulo tɔyɔ́ Yudafɔ ofíakpa yɛ́lɛ Bulu asʋ́n ámʋtɔ wankláán súná Yudafɔ pʋ́ Griikifɔ ámʋ, mɛ́nɩ bɔ́hɔ Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Brɛ́á Silas mʋa Timoteo botsu Makedonia bɔtʋ Paulo a, olesi agyʋ́má ámʋ yɔ, pʋ́ Bulu asʋ́n ámʋ ɔkanda kóún bwɛ́ mʋ gyumagyihɛ. Oletsiá gyi adánsɩɛ súná Yudafɔ ámʋ ɔbɛ́ɛ, Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Támɛ bʋmɔhɔ mʋ asʋ́n ámʋ. Bɔkʋsʋ́ lɩ́ɩ́ mʋsʋ, síá mʋ. Mʋ́ sʋ Paulo lɔ́fwɩ ɩbɩ lɛ́ amʋ́ asʋ́ntɔ́, bláa amʋ́ ɔbɛ́ɛ, “Tsú ndɛ pʋ́ya a, nalɛ́ ɩbɩ mlɩ asʋ́ntɔ́. Nɩ́ lowu mlɩdéklé a, ɩbá mlɩsʋ. Nɛ́yɛ́bláa ahá ánɩ́ bʋmegyí Yudafɔ mboún Bulu asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ɩ́nɩ sʋ Paulo lɛ́dalɩ Yudafɔ ofíakpa ɩnʋ yétsiá oyin ɔkʋá bʋtɛtɩ́ mʋ Tito Yustus wóyítɔ́. Megyí Yudayin oyin ámʋ gyí, támɛ ogyi Bulu osúmpʋ́. Mʋ wóyí ɩbʋ mantáa Yudafɔ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Támɛ Krispu ánɩ́ ogyi Yudafɔ ofíakpa ɩnʋ ɔhandɛ mʋa mʋ wóyítɔ́fɔ fɛ́ɛ́ mʋ́ bɔhɔ anɩ Wíe Yesu gyi. Korintofɔ ámʋ tsɔtsɔɔtsɔ ɛ́ bohogyi, bɔ́bɔ amʋ́ asú. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ɛkɛ ɔkʋ onyé á, Paulo lówun atɔ́. Mʋ́tɔ́ á, anɩ Wíe lɛ́bláa mʋ ɔbɛ́ɛ, “Mánya ifú. Yɔ mʋ́sʋ́ afʋda asʋ́n ámʋ ɔkan wʋlɛ. Mákpa ɔnɔ́ bun. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tsúfɛ́ mɩ́a fʋnyɔ ná. Ɔhaa mɛ́ɛtalɩ́ bwɛ́ fʋ́ tɔtɔ. Mɩ́ ahá bʋtsɔ wúlu anfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mʋ́ sʋ Paulo létsiá Korinto ɩnʋ súná ahá ámʋ Bulu asʋ́n ofi ɔkʋlɛ mʋ́a ɩfʋn. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Brɛ́á Galio létsiá Roma owíe otsiákpá, ɔdɛ Griikifɔ ɔsaasɩ́ ɔmanti kʋá bʋtɛtɩ́ mʋ́ Akaiasʋ kɩ́ɩ a, Yudafɔ ámʋ bɔbwɛ ɔnɔ-ɔkʋlɛ, kɩ́tá Paulo, pʋ́ mʋ ya mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bɛɛ, “Oyin ánfɩ dɛ́ ahá asʋkpan suná ɔbɛ́ɛ bʋsúm Bulu tsʋn ɔkpa ánɩ́ ɩlɔkʋsʋ́ lɩ́ɩ́ anɩ mblasʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo lénya bwíí ɔnɔ́ ɔbɛ́ɛ amʋtɔɩ alɩ Galio lɛ́bláa Yudafɔ ámʋ ɔbɛ́ɛ, “Nɩ́ tsitsa ntɛ́ɛ lakpan kʋ oyin ánfɩ labwɛ́ á, tɛkɩ ɩbʋ alɛ́á nɛ́yaa asʋ nú mlɩ asʋ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Támɛ ɩ́nɩá adá pʋ́ mlɩ onutó mbla ɩwɩ asʋ́n ɩwɩ nwɛ́ɛn mlɩdégyí sʋ á, mlɩyɔ amlɩyɛblɩ́ mʋ́. Mméegyi asʋ́n ánfɩ odu.” ");
INSERT INTO nkoNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mʋ́ʋ́ ɔlɛha begya amʋ́ lɛ́ asʋ́n ogyíkpá ɩnʋ á. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ahá ámʋ fɛ́ɛ́ bowunáa kɩ́tá Sostene ánɩ́ ogyi Yudafɔ ofíakpa ɩnʋ ɔhandɛ, dá mʋ ɩnʋ. Támɛ Galio mótsu kʋkʋ lɛ́ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo létsiá ahógyipʋ amʋ wá Korinto yɔ́fʋn brɛ́ kʋ. Mʋ́ʋ́ ɔlɛklá amʋ́, mʋa Priskila pʋ́ Akwila bɛnatɩ́ yɔ́ Kenkrea wúlutɔ. Paulo lɛ́kpa mʋ nwun Kenkrea ɩnʋ, pʋ́súná ánɩ́ alamɔ́ ntam kʋá ɔlɛka ɔnɔ́. Mʋ́ʋ́ botsu ntsusʋ-yibi pʋ́ bɔyɔ́ Siria ɔmátɔ́ á. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Brɛ́á bowie Efeso wúlutɔ á, Paulo lɛ́natɩ́ sí Priskila mʋa Akwila, yɔ́ Yudafɔ ofíakpa, mʋa Yudafɔ ámʋ bʋdɛ asʋ́ntɔ́ lɛ há aba. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bokokóli mʋ bɛɛ, ɔtráa tsia amʋ́ wá kpalobí, omotsulá. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Támɛ brɛ́á ɔdɛdalɩ ɔyɔ́ á, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Nɩ́ Bulu lótsulá á, néyinkí ba mlɩ wá.” Ɩnʋ olowie ntsusʋ-yibitɔ tsú Efeso ɩnʋ nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Brɛ́á ɔlɛkplɩ́ Kaesarea a, ɔlɔdʋ yɔ́ Yerusalem yɛ́ha ɔpasua ámʋ tsiá. Mʋ́ʋ́ oleyinkí kplɩ́ yɔ́ Antiokia a. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Oletsiá Antiokia ɩnʋ kpalobí. Mʋ́ ɔma a, ɔlɛnatɩ́ ɩnʋ beki Galatia pʋ́ Frigia ɔsʋlʋ́sʋ, ɔdɛ akasɩ́pʋ́ amʋ Bulu asʋ́n bláa, pʋ́wá amʋ́ ɔwʋnlɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Alɩ brɛ́ ámʋtɔ á, Yudayin ɔkʋá bʋtɛtɩ́ mʋ Apolo laba ɔbʋ Efeso wúlutɔ. Bɔkwɩɩ́ mʋ Aleksandria, wúlu ánɩ́ ɩbʋ Egyipte ɔmátɔ́. Oyin tɔɩ́, oyin Bulu asʋn wanlɩ́nhɛ́ amʋ ɛ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bosuná mʋ anɩ Wíe ɔkpa ámʋ. Mʋ́ sʋ Yesu ɩwɩ ɔnɔkwalɩ amʋ blɩ́ tɛhɩ́ɛ́ wá mʋ ansigyí. Támɛ Asú Ɔbɔpʋ́ Yohane asúbɔ ámʋ pɛ́ oyin. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo ménya ifú. Ɔlɔwa klʋn súná atɔ́ Yudafɔ ofíakpa ɩnʋ wankláán. Brɛ́á Priskila mʋa Akwila bonu mʋ asʋn blɩ́hɛ́ a, bɛkpa mʋ yáa wóyítɔ́ yósuná mʋ Bulu ɔkpa ámʋ wankláán dʋn alɩá oyin yaɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Brɛ́á Apolo lɔ́bwɛ agywɩɩn ɔbɛ́ɛ, ɔbɔ́yɔ Akaia ɔsʋlʋ́sʋ á, ahógyipʋ amʋ bɔwa mʋ atɛtɔ-ɔnlɩn. Bɔwanlɩ́n ɔwʋlʋ́ sɩ́sɩ́ ɩnʋ ahógyipʋ bɛɛ, bʋhɔ́ɔ mʋ wankláán. Brɛ́á oloyówie ɩnʋ á, ɔlɛhɩɛ bʋ́a ahá ánɩ́ ɩna Bulu awɩtɔlɛsʋ bahɔ Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolo mʋa Yudafɔ ámʋ begyi Bulu asʋn wanlɩ́nhɛ́ amʋ ɩwɩ nwɛ́ɛn, ɔlɔtɔɩ́ lɛ́ asʋ́ntɔ́ túmisʋ pʋ́gyi amʋ́sʋ́. Ɔlɔpʋ Bulu asʋn wanlɩ́nhɛ́ amʋ súná amʋ́ ánɩ́ Yesu gyí Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ). ");
INSERT INTO nkoNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Brɛ́á Apolo bʋ Korinto a, Paulo lɔ́dʋ yɔ́tsʋn ɔsʋ́sʋ́ awúlusʋ bɛdalɩ tíí Efeso. Ɔlɔtʋ akasɩ́pʋ́ akʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mʋ́ʋ́ ɔlɛfɩtɛ́ amʋ́ ɔbɛ́ɛ, “Mlɩlénya Ɔŋɛ Wankɩ́hɛ́ brɛ́á mlɩlóhogyi?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Anɩmɔ́kʋ́nú kɩ ánɩ́ Ɔŋɛ Wankɩ́hɛ́ kʋ bʋ ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo lɛ́trá fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Asú mɔmʋ bɔbɔ mlɩ?” Bɛlɛ mʋ́ ɔnɔ́ bɛɛ, “Yohane asú ámʋ bɔbɔ anɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo lɛ́bláa amʋ́ ɔbɛ́ɛ, “Yohane lɔ́bɔ ahá ánɩ́ badámlí klʋntɔ asú. Ɔlɛbláa amʋ́ ɔbɛ́ɛ bʋhɔ́ɔ ɔhá ámʋ́ʋ́ obuo mʋ ɔbá ámʋsʋ gyi. Mʋgyí Yesu.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Brɛ́á ahá ámʋ bonu asʋ́n ánfɩ á, bɛha bɔbɔ amʋ́ asú anɩ Wíe Yesu dátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Mʋ́ ɔma a, Paulo lɔ́pʋ ɩbɩ dɩ́nká amʋ́ nwunsʋ, Ɔŋɛ Wankɩ́hɛ́ lɛba amʋ́sʋ́. Bɛblɩ́ ɔblɩ́ɩ bámbá, blɩ́ Bulu ɔnɔ́ asʋ́n ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Amʋ́ fɛ́ɛ́ bɔ́bwɛ ayin dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo lɛ́latsiá yɔ́ Yudafɔ ofíakpa ɩnʋ. Ɔlɔwa klʋn tɔ́ɩ́ lɛ́ asʋ́ntɔ́ súná amʋ́ tsra asa kɛ́kɛ́. Omenya ifú, mɛ́nɩ bɔ́hɔ asʋ́n ámʋ́ʋ́ ɔdɛblɩ́ tsú Bulu iwíegyí ɩwɩ ámʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Támɛ amʋ́ akʋ bɔwa klʋntɔ odwin, bʋmɔhɔ mʋ asʋ́nsʋ́ gyi. Bɔtɔɩ́ wɔ anɩ Wíe Ɔkpa ámʋ́ʋ́ Paulo dɛ́ amʋ́ súná ámʋ ahátɔ ɩnʋ. Mʋ́ sʋ Paulo lɛ́kpa akasɩ́pʋ́ amʋ nátɩ́, oletsiá súná amʋ́ atɔ́ oyin ɔkʋá bʋtɛtɩ́ mʋ Tirano atɔ́ ɔkasɩ́kpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paulo lósuná amʋ́ atɔ́ nfinyɔ kɛ́kɛ́. Mʋ́ sʋ Yudafɔ pʋ́ Griikifɔ ánɩ́ bʋbʋ Asia ɔmátɔ́ fɛ́ɛ́ bonu anɩ Wíe asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bulu lɔ́tsʋn Paulosʋ bwɛ́ ofúla akpɔnkpɔntɩ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ahá bɔkʋlá mʋ adúkubi pʋ́ mʋ ɩwɩsʋ atɔ́ yɛ́dɩnká alɔpʋsʋ, benya ɩlɔtsá, ɔŋɛ laláhɛ ɛ́ lɛdalɩ ahátɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yudafɔ akʋ ɛ́ bʋbʋ nsɩnɛ́ ɩnʋ bʋna bʋdeki gya ɔŋɛ laláhɛ lɛ́ ahátɔ. Bɔwa klʋn bɛɛ, bɔ́pʋ anɩ Wíe Yesu dá gya ɔŋɛ laláhɛ lɛ́ ahátɔ. Mʋ́ sʋ bɔkplʋ́n wa ɔŋɛ laláhɛ bɛɛ, “Dalɩ Yesu amʋ́ʋ́ Paulo dɛ́ mʋ ɩwɩ asʋ́n ɔkan da ámʋ dátɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Igyí ahapʋ́ ɔhandɛ ɔkʋá bʋtɛtɩ́ mʋ Skewa abi yinhɛ́ abasíénɔ́ létsiá bwɛ́ ɩ́nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɛkɛ ɔkʋ ɔŋɛ laláhɛ lɛ́fɩtɛ́ amʋ́ ɔbɛ́ɛ, “Nyin Yesu, nabɩ́ Paulo, mlɩ ɛ́ mɛ́, amɛndɩ mlɩgyí?” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɔhá ámʋ́ʋ́ ɔŋɛ laláhɛ bʋ mʋtɔ ámʋ lótu wíé amʋ́tɔ́, dá amʋ́, tɩ́tɩ amʋ́ atadɩɛ fɛ́ɛ́. Ɩnʋ amʋ́ fɛ́ɛ́ bɔpʋ amʋ́ yayá pʋ́ amʋ́ ɩwɩ nlɔ srɩ́ dalɩ wóyí ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yudafɔ pʋ́ Griikifɔá bʋbʋ Efeso ɩnʋ fɛ́ɛ́ bonu asʋ́n ánfɩ. Ifú lɛkɩtá amʋ́. Mʋ́ sʋ bɔpʋ obú há anɩ Wíe Yesu. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ahá ámʋ́ʋ́ bohogyi amʋtɔ tsɔtsɔɔtsɔ bɛlɛ amʋ́ lakpan blɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Amʋ́tɔ́ akʋ bʋgyi okó alɛpʋ́. Botsu okó ámʋ nwʋlʋ́ ba bɔwa mʋ́ fɛ́ɛ́ ogyá ahá ansɩ́tɔ́ ɩnʋ. Bobu amʋ́ nwʋlʋ́ ámʋ ibíá á, ɩlɔbwɛ sika futútú mpɩ́m-aduenu (50,000). ");
INSERT INTO nkoNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ɩna anɩ Wíe Yesu túmisʋ mʋ asʋ́n ámʋ lenya ɔkpa klɛ́ɩ́ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Asʋ́n ánfɩ fɛ́ɛ́ ɔma a, Bulu Ɔŋɛ́ ámʋ lɛ́ha Paulo lɔ́bwɛ agywɩɩn ánɩ́ ɔbɔ́yɔ Makedonia pʋ́ Akaia ɔsʋlʋ́sʋ, fówun ɔyɔ Yerusalem. Mʋ́ʋ́ Paulo lɛ́blɩ́ ɔbɛ́ɛ, “Nɩ́ nowíé ɩnʋ á, ilehián ánɩ́ nɛ́yɛ́kɩ Roma wúlutɔ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mʋ́ sʋ ɔlɔwa mʋ abʋápʋ abanyɔ́, bʋgyi Timoteo mʋa Erasto sɩ́sɩ́ Makedonia. Mʋ onutó olesi tsiá Asia ɔmátɔ́ kpalobí. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Alɩ brɛ́ ámʋtɔ á, anɩ Wíe Ɔkpa ámʋ́ʋ́ bʋdɛ ahá suná ámʋ sʋ asʋ́n kpɔnkpɔntɩ kʋ lɛda Efeso ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Oyin ɔkʋá ɔtɔbwɛ́ sika futútú atɔ́, bʋtɛtɩ́ mʋ Demetrio bʋ ɩnʋ. Oyin ánfɩ tɔpʋ́ sika futútú bwɛ́ ɔkpɩ yílé Artemi ɔtswɛ́kpa akusubi ánɩ́ ɩlɛlɩan mʋ ɔtswɛ́kpa yílé ámʋ fɛ́. Mʋa mʋ aba agyʋ́má ánfɩ ayɔpʋ́ bʋtenyá kɔ́ba tsɔtsɔɔtsɔ tsú mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ɔlɛtɩ mʋ aba ámʋ pʋ́ ahá ánɩ́ bʋtɔbwɛ́ agyʋ́má ámʋ odu fia. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó, mlɩyin ánɩ́ agyʋ́má ánfɩ sʋ́ anɩ fɛ́ɛ́ anɩlawá alɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yɛ́ɛ mlɩtsie mlɩdénu, mlɩdéwúun tɔ́á Paulo dɛ́bwɛ? Alatá ahá bláa ta Efeso wúlutɔ pʋ́ Asia ɔmátɔ́ fɛ́ɛ́ fía ɔbɛ́ɛ, ɩkpɩ ánɩ́ ahá bapʋ́ ɩbɩ pwɛ́ bʋmegyí tɔtɔ. Alatá ahá ɔnɔ́ mlɛ́ tá, bʋdɛ mʋ asʋ́nsʋ́ hógyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Megyí anɩ agyʋ́má wʋlɛ ibéyintá. Ɔhaa mɛ́ɛtrá bu ɔkpɩ tsɩ́hɛ́ Artemi ɔtswɛ́kpa yílé ámʋ. Ɔkpɩ ámʋ dá ɛ́ bɔ́fwɩ lɛ́ ɔyɩ́tɔ́. Támɛ tɛkɩ mʋgyí ɔkpɩá ahá fɛ́ɛ́ bʋtɔtswɛ Asia ɔmátɔ́ pʋ́ ɔyɩ́tɔ́ fɛ́ɛ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Brɛ́á ɔdɔm amʋ bonu asʋ́n ánfɩ á, benya ɔblɔ́, sʋ́rá okitikíti bɛɛ, “Ɔkpɩ kpɔnkpɔntɩ anɩ Efesofɔ ɔkpɩ Artemi gyí!” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kpokiti lɛda wúlu amʋtɔ fɛ́ɛ́. Ahá ámʋ bɛkɩtá Paulo abúopʋ Gaio mʋa Aristarko ánɩ́ botsú Makedonia srɩ́ pʋ́ amʋ́ ya wúlu ofíakpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo onutó lékléá ɔbɔ́yɔ ofíakpa ɩnʋ, ɔyɔtɔɩ́ kpla ɔdɔm amʋ, támɛ akasɩ́pʋ́ amʋ bʋmɛha mʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ɔmá ámʋtɔ ahandɛ akpɔnkpɔntɩ akʋá bʋgyi Paulo anyawíe ɛ́ bɔwa obí lóyóbwií ɩpa há mʋ bɛɛ, ɔmáyɔ ofíakpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kpokiti lɛ́da ofíakpa ɩnʋ. Ánɩ bɛɛ alɩ, anɩ ɛ́ bɛɛ alɩ. Amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bʋmɛbɩ tɔ́á sʋá befia ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yudafɔ ámʋ akʋ bɔyɔ ofíakpa ɩnʋ. Bowutá Aleksandro sɩ́sɩ́ ɔbʋntɔ, bʋdɛ mʋ asʋ́n ánɩ́ ɔyɛ́blɩ́ bláa. Ɩ́nɩ sʋ Aleksandro lótsu ɩbɩ fʋ́á, ɔbɛ́ɛ amʋlɛ mʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Támɛ brɛ́á bowun ánɩ́ Yudayin ogyi á, bɛlasʋ́rá okitikíti, blɩ́ asʋn kua kʋlɛ dɔnhwɩ́rɩ anyɔ kɛ́kɛ́ bɛɛ “Ɔkpɩ kpɔnkpɔntɩ anɩ Efesofɔ ɔkpɩ Artemi gyí!” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ɩ́nɩ fɛ́ɛ́ ɔma a, wúlu atɔ́ ɔwanlɩ́npʋ́ lɛ́ha ɔdɔm amʋ bɛkpa ɔnɔ́ bun. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Efesofɔ ayin, ma méyín ánɩ́ Efeso nfɩ gyí anɩ ɔkpɩ kpɔnkpɔntɩ Artemi pʋ́ mʋ ibwi ámʋ́ʋ́ ɩlɛkpa tsú ɔsʋ́sʋ́ ámʋ nwun? ");
INSERT INTO nkoNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɔhaa má ɩnʋá ɔbɛ́talɩ́ gyí asʋ́n ánfɩ ɩwɩ nwɛ́ɛn? Mlɩnya klʋn, mɛ́nɩ mlɩmóoko mli. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ahá ánfɩ mlɩlakpá ba nfɩ ánfɩtɔ ɔkʋkʋ mɔ́kʋ́wí tɔtɔ tsú ɔtswɛ́kpa ɩnʋ. Bʋmɔkʋ́blɩ́ asʋansʋ kʋ́sʋ́ lɩ́ɩ́ anɩ ɔkpɩ tsɩ́hɛ́ Artemisʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Támɛ nɩ́ Demetrio mʋa mʋ aba agyʋ́má ayɔpʋ́ amʋ bɛɛ bʋbʋ ɔkʋ ɩwɩ asʋ́n á, asʋ́n agyípʋ́ bʋbʋ ɩnʋ, asʋ́n ogyíkpá ɛ́ bʋ ɩnʋ. Bɛ́talɩ́ pʋ́ asʋ́n ámʋ ya ɩnʋ kpɛ́blɩ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nɩ́ mlɩbʋ asʋn bambá kʋ tsɩ́a ɩ́nɩtɔ mʋ́ á, bɛ́talɩ́ yɛ́blɩ́ mʋ́ ɔtɩ́nɛ́ ámʋ́ʋ́ anɩ fɛ́ɛ́ anɩtefia gyi asʋ́n ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tsúfɛ́ nɩ́ anɩmɛ́kɩ wankláán á, abénya asʋ́n ánɩ́ anɩlahan wúlu amʋ agywɩɩn ndɛ. Nɩ́ bɛfɩ́tɛ́ anɩ ɛ́ á, anɩméenya asʋansʋ pʋ́lɛ́ mʋ́ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Olenya blɩ́ asʋ́n ánfɩ tá alɩ, ɔlɛha amʋ́ fɛ́ɛ́ bɛdasáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kpokiti amʋ ɔma a, Paulo lɛ́ba bɛtɩ akasɩ́pʋ́ amʋ fɛ́ɛ́ fía, tɔ́ɩ́ kplá amʋ́, wá amʋ́ atɛtɔ-ɔnlɩn. Ɔlɛklá amʋ́ asa ɔlɔpʋ ɔkpa ɔyɔ́ Makedonia ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Oleki nsɩnɛ́ ɩnʋ ɔpasua ámʋsʋ tɔ́ɩ́ kplá amʋ́ asa olobowie Griikifɔ ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Oletsiá ɩnʋ tsra asa. Brɛ́á ɔlɔbwɛ agywɩɩn ɔbɛ́ɛ, mɛ́fa ɔpʋ yɔ́ Siria ɔsʋlʋ́sʋ á, olowun ánɩ́ Yudafɔ bʋdɛ mʋ tɛ́ɛ abʋkɩta mʋ. Mʋ́ sʋ ɔlɔbwɛ agywɩɩn ɔbɛ́ɛ mɛ́layɔ́tsʋn Makedonia ɔsʋlʋ́sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ahá ánɩ́ bɛkpa mʋ ya ɩnʋ gyí Beroiayin Sopater, ogyi Piro mʋ bi; Tesalonikafɔ Aristarko mʋa Sekundo pʋ́ Derbeyin Gaio; amʋ́a Timoteo pʋ́ Asiafɔ Tihiko mʋa Trofimo. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Alɩ ahá ánfɩ begyankpá yógyo anɩ Troa wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Israelfɔ begyi amʋ́ Bodobodo Mátúhɛ́Nkɛ ɔma a, anɩlétsiá ntsusʋ-yibitɔ tsú Filipi wúlutɔ. Anɩlɛ́natɩ́ nkɛná owítɔ́. Ɛkɛ núúsɩ́ a, anɩlɔ́bɔtʋ nkpá agyápʋ amʋ Troa wúlutɔ. Anɩ fɛ́ɛ́ anɩlétsiá ɩnʋ nkensíénɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kwasieda, igyi ndawɔ́tswɩ́ ámʋtɔ ɛkɛ gyankpapʋ ntʋ́pwɛsʋ á, anɩléfía abégyi atɔ́ abatɔ fɛ́ alɩá anɩ Wíe lósuná anɩ. Ɩ́nɩá Paulo dékléá ɔbɛ́natɩ́ ɔyɩ kɛhɛ sʋ á, ɔlɔtɔɩ́ kplá amʋ́ alɩɩ yɛ́ha ɔyɩ́nsɩnɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nkandɩ́ɛ tsɔtsɔɔtsɔ bʋ ɔsʋ́sʋ́ obu ámʋ́ʋ́ anɩléfía mʋ́tɔ́ ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Oyimbi ɔkʋá bʋtɛtɩ́ mʋ Eutiko lɔ́dʋ bian nfánsrɩ́ ɔnɔ́, ɔdɛ asʋ́n ámʋ nu. Ɩ́nɩá Paulo lɔ́tɔɩ́ wá ɔpá sʋ á, dɩdɩ́ lowie mʋ, fʋ́rʋ mʋ. Ɔlɛkpa tsú ɔsʋ́sʋ́ abansʋ́rʋ saasɩ nfánsrɩ́tɔ́ ɩnʋ bɛda ɔsʋlʋ́tɔ. Brɛ́á boyótsu mʋ a, alawú fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mʋ́ʋ́ Paulo lɛ́kplɩ́ yɔ́ ɩnʋ, yémlí bun mʋsʋ, látá mʋ pútá, blɩ́ ɔbɛ́ɛ, “Opúni mátsií mlɩ, ɔŋɛ́ bʋ mʋtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paulo léyinkí dʋ́ yɔ́ ɔsʋ́sʋ́ ɩnʋ, mʋa mʋ aba ámʋ nyɔ bebiabía bodobodo gyi. Ɔlɔyɔ mʋ tɔ́ɩ amʋsʋ alɩɩ yɔ́fʋn ɔyɩ kɛhɛ, ɔlɛnatɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mʋ́ʋ́ ahá ámʋ bɛ́kpa kebi ámʋ ya wóyí á. Ansɩ́ lɛhɩɛ gyi amʋ́ ánɩ́ ɔbʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Anɩlégyankpá yówie ntsusʋ-yibi ámʋtɔ ayɔ́ Aso wúlutɔ yótsu Paulo ɩnʋ. Tsúfɛ́ Paulo lɛ́ha anɩ ɩbɩ ɔbɛ́ɛ, ɔbɔ́tsʋn ayabitɔ ɔkpa ká tíí ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Brɛ́á anɩa mʋnyɔ anɩléyéfia aba Aso wúlutɔ ɩnʋ á, olowie ntsusʋ-yibi ámʋtɔ, anɩlɛ́fa yɔ́ Mitilene wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Anɩlɛ́natɩ́ ɩnʋ ɔyɩ kɛhɛ, anɩlɔ́kʋsʋ́ ɩnʋ yówie Kio. Ɛkɛ nyɔɔsɩ a, anɩlɔ́kʋsʋ́ ɩnʋ yówie Samo wúlutɔ. Mʋ́ ɛkɛ sáásɩ́ ɛ́ á, anɩlɛ́trá kʋsʋ́ ɩnʋ yówie Mileto wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo mékléá obéyintá brɛ́ Asia ɔmátɔ́. Mʋ́ sʋ ɔmɛkplɩ́ Efeso wúlutɔ, tsúfɛ́ ɔdɛkɔsɩ́ ánɩ́ nɩ́ ɔbɛ́talɩ́ á, obóyówie Yerusalem asa abʋgyi Pentekoste nkɛ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Brɛ́á anɩlóyowie Mileto wúlutɔ á, Paulo lɔ́wa abí sɩ́sɩ́ Efeso ɔpasua ahandɛ ɔbɛ́ɛ, bʋbá bɔtʋ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Brɛ́á ahandɛ amʋ bebefia mʋ a, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩyin alɩá mɩ́a mlɩnyɔ anɩlɔ́pʋtsíá tsú ɛkɛ gyankpapʋ ánɩ́ nɛba Asia ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mlɩyin alɩá nɛba ɩwɩasɩ yɔ́ agyʋ́má há mɩ́ Wíe, pʋ́ alɩá Yudafɔ bɔkʋsʋ́ lɩ́ɩ́ mɩ́sʋ́, nowun ipian, su kʋ́ráá. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mlɩyin ánɩ́ mmɔpʋ asʋ́n ánɩ́ ɩbɛ́kpa mlɩ ŋáín mlɩ brɛ́á nɛda Bulu asʋ́n ámʋ ɔkan dɩnsʋ pʋ́ mlɩ wóyítɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Alɩá nɔtɔɩ́ kplá Yudafɔ pʋ́ Griikifɔ fɛ́ɛ́ mbɛ́ɛ, bʋsíi lakpan bwɛ abʋdamli ba Bulu wá, abʋbɔhɔ anɩ Wíe Yesu gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Séi ánfɩ á, nɔyɔ́ Yerusalem, fɛ́ alɩá Ɔŋɛ Wankɩ́hɛ́ labláa mɩ. Mmeyín tɔ́á ɩbɛ́ba mɩsʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Támɛ mʋ́á Ɔŋɛ Wankɩ́hɛ́ tɛbláa mɩ́ wúlugyíwúlusʋ, nyin gyí, asʋn wunhɛ pʋ́ obudɩ da gyo mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Támɛ mmotsu mʋ́ asʋnbogya. Mboún alɩá nɔ́mɔ agyʋ́má ámʋ́ʋ́ anɩ Wíe Yesu lɛ́ha mɩ́ ámʋ ɔnɔ́. Agyʋ́má ámʋ gyí, nɛ́bláa ahá Bulu awɩtɔlɛ asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Séi ánfɩ a, nyin ánɩ́ mlɩ ahá ánfɩ nɛbɛda Bulu iwíegyí ɩwɩ asʋ́n ɔkan mlɩtɔ ánfɩtɔ ɔkʋkʋ mɛ́ɛtrá wun mɩ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mʋ́ sʋ ndɛ mlɩ bláa mbɛ́ɛ, nɩ́ mlɩtɔ ɔkʋ ménya nkpa ánɩ́ ɩtamatá á, megyí mɩ́ sʋ omenya. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tsúfɛ́ nabláa mlɩ tógyítɔ́á Bulu déklé ɔbɛ́ɛ mlɩbɩ́ɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Mʋ́ sʋ mlɩkɩ mlɩ ɩwɩ pʋ́ ahá ámʋ́ʋ́ Ɔŋɛ Wankɩ́hɛ́ lɔ́pʋwá mlɩ ɩbɩtɔ ámʋsʋ wankláán. Mlɩkpa Bulu ɔpasua ámʋ́ʋ́ ɔlɛyaɩ́ tsʋn mʋ onutó mʋ bi lowusʋ ámʋ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nyin ánɩ́ nɛnátɩ́ á, akʋá bʋgyi fɛ́ nkpataku, bʋbʋ ɩyɩn bɛ́ba bowie mlɩtɔ, dá ɔpasua ámʋ sáɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mlɩtɔ akʋ óó bɔ́kʋsʋ́, dámlí ɔnɔkwalɩ amʋ pʋ́bɩ́tɩ́a mlɩtɔ akʋ buo ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mʋ́ sʋ mlɩda ɩwɩsʋ. Mlɩkaɩn ánɩ́ netsiá mlɩ wá nfinsa sɔ́ɔ́n, pʋ́ ansɩ́ ntsú yɩ́rɩ ɩwɩ súná mlɩ atɔ́ ɔpa onyé. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Mʋ́ sʋ séi á, ndɛpʋ mlɩ wá Bulu mʋa mʋ awɩtɔlɛ asʋ́n ámʋtɔ. Mʋ awɩtɔlɛ asʋ́n ámʋ ɩwá mlɩ ɔwʋnlɩ́n, ɩha amlɩdan, talɩ lɩɩ kínkín, amlɩnya atɔ́ ámʋ́ʋ́ ɔlɛhɩɛ yáɩ́ há mʋ ahá ámʋ́ʋ́ bamlí mʋ klɛ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Brɛ́á mbʋ mlɩ wá á, mmɛpɛ ansɩ́ ɔhaa sika pɛpɛ, mʋ sika futútú ntɛ́ɛ mʋ atɔ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mlɩ onutó mlɩyin ánɩ́ mɩ́ ɩbɩ anfɩ nɔpʋyɔ́ agyʋ́má nyá tɔ́á ɩdɛ mɩ́a mɩ́ aba ámʋ hián fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Natsʋn ɔkpagyíɔkpasʋ súná mlɩ alɩá mlɔ́pʋ ɩbɩ yɔ́ agyʋ́má, pʋ́gyi ahá ánɩ́ ɩwɩ ma amʋ́ ɔnlɩn bʋalɛ. Mlɩkaɩn anɩ Wíe Yesu onutó asʋn blɩ́hɛ́sʋ. Ɔbɛ́ɛ, ‘Bulu toyúlá ɔhá ánɩ́ otekíé atɔ́ dʋn ɔhá ánɩ́ bʋtekíé mʋ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Brɛ́á Paulo lɛ́blɩ́ asʋ́n ánfɩ tá á, mʋa amʋ́nyɔ fɛ́ɛ́ bɛda akpawunu bɔ́ mpáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Amʋ́ fɛ́ɛ́ bosu brɛ́á bɛlatá aba pútá, klá aba. ");
INSERT INTO nkoNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tɔ́á ɩlɔwa amʋ́ ahʋmɩtɩ gyí mʋ́ ámʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, mʋmɛ́ɛtrá wun amʋ́ ɛkɛkɛɛkɛ ámʋ. Besi mʋ ɔkpa yówie ɔpʋ ɔnɔ́, olowie ntsusʋ-yibitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Brɛ́á anɩlégyí nkla tá á, anɩlówie ntsusʋ-yibitɔ, nátɩ́ laa yɔ́ Ko wúlutɔ. Ɛkɛ nyɔɔsɩ a, anɩlɔ́yɔ Rodo. Tsú ɩnʋ á, anɩlɛ́bá Patara otsubúnɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Anɩlénya ntsusʋ-yibi kʋá ɩyɔ́ Foinike otsubúnɔ, anɩlówie mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Brɛ́á ayɔ́ á, anɩlówun ɔsʋlʋ́ʋ kʋá bʋtɛtɩ́ mʋ́ Kipro sɩ́sɩ́. Anɩlési mʋ́ tswɩ bɩnasʋ ɩfʋ́n, tsʋn yɔ Siria ɔmátɔ́. Anɩlɛ́yɛkplɩ́ Tiro otsubúnɔ, tsúfɛ́ ɩnʋ́ bɛ́lɛ ntsusʋ-yibi ámʋtɔ atɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Anɩlɔ́tʋ akasɩ́pʋ́ akʋ ɩnʋ, anɩlétsiá amʋ́ wá nkensíénɔ́. Ɔŋɛ Wankɩ́hɛ́ lɛ́lɛ súná amʋ́ ɔbɛ́ɛ, Paulo máyɔ Yerusalem wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Anɩ nkɛ lɔfʋn, anɩlɔ́tʋá anɩ ɔkpasʋ. Brɛ́á anɩdɛ́natɩ́ á, akasɩ́pʋ́ amʋ, amʋ́ aká pʋ́ amʋ́ abí fɛ́ɛ́ beyési anɩ ɔkpa alɩɩ yówie ɔpʋ ɔnɔ́. Ɩnʋ á, anɩ fɛ́ɛ́ anɩlɛ́da akpawunu bɔ́ mpáɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Anɩlégyí nkla, anɩlówie ntsusʋ-yibi ámʋtɔ pʋ́ ayɔ́, amʋ́ ɛ́ beyinkí yɔ́ wóyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Anɩlɛ́dɩnká ɔpʋsʋ tsú Tiro alɩɩ bowie Ptolemai otsubúnɔ. Brɛ́á anɩlówie ɩnʋ á, anɩlɛ́yɛha ahógyipʋ ánɩ́ bʋbʋ ɩnʋ itsiá, anɩlétsiá amʋ́ wá ɛkɛwʋ́lɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ɔyɩ kɛhɛ a, anɩlɔ́kʋsʋ́ tsú ɩnʋ ba Kaesarea otsubúnɔ. Anɩlɔ́yɔswɩɩ́ Bulu asʋ́n ɔkan ɔdapʋ́ Filipo wóyí. Oyin ánfɩ gyí ahá abasíénɔ́ ámʋ́ʋ́ bɛlɛ Yerusalem bɛɛ, bʋtsáa ahandɛ agyʋ́má yɔ ámʋtɔ ɔkʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipo bʋ abi tsɩhɛ́ abaná, bʋmɔkʋ́yɔ́ ayin wá kɩ. Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ mʋ abi tsɩhɛ́ ánfɩ bʋgyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Anɩlégyí nkɛ kpalobí ɩnʋ. Ɛkɛ ɔkʋ Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Agabo lótsu Yudea ɔmátɔ́ ba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Olenya bowie laa alɩ́ olotsu Paulo osíétɔ́ ɔfɛ́ klɩ́ mʋ onutó ɩbɩ pʋ́ mʋ ayabi. Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Ɔŋɛ Wankɩ́hɛ́ ɔbɛ́ɛ, ‘Alɩ́ Yudafɔá bʋbʋ Yerusalem bɛ́klɩ́ ɔhá ámʋ́ʋ́ ɔbʋ ɔfɛ́ ánfɩ, pʋ́ mʋ wá ahá ánɩ́ bʋmegyí Yudafɔ ɩbɩtɔ nɩ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Brɛ́á anɩlónu asʋ́n ánfɩ á, anɩa ahá ámʋ́ʋ́ bʋbʋ ɩnʋ ámʋ fɛ́ɛ́ anɩlókokóli Paulo anɩaa ɔmáyɔ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ɩnʋ Paulo lɛ́fɩtɛ́ anɩ ɔbɛ́ɛ, “Ntogyi sʋ́ mlɩdésú, mlɩlahá ɩwɩ lawú mɩ́ alɩ? Mɩ́ mʋ́ á, megyí klɩ́ ámʋ́ʋ́ bɛ́kɩklɩ́ɩ mɩ Yerusalem amʋ pɛ́ nalá ɩwɩ yáɩ́ há. Mboún nalá ɩwɩ yáɩ́ ánɩ́ nówu anɩ Wíe Yesu sʋ ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Paulo ɔnɔ́ lɔdʋn anɩ. Mʋ́ sʋ anɩlési mʋ tɔ́ɩ wa. Mʋ́ʋ́ anɩlɛ́blɩ́ anɩaa, “Ɩbá mʋ́tɔ́ alɩá anɩ Wíe déklé.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɩ́nɩ ɔma a, anɩlɔ́kʋlá anɩ atɔ́ dʋ yɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Anɩa Kaesareafɔ akasɩ́pʋ́ akʋ lɔ́yɔ ɩnʋ. Bɛkpa anɩ ya oyin ɔkʋá bʋtɛtɩ́ mʋ Mnason wóyítɔ́ bɛɛ, aswɩ́ɩ mʋ wá. Akasɩ́pʋ́ agyankpapʋ amʋtɔ ɔkʋlɛ ogyi, otsú Kipro ɔmátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Brɛ́á anɩlówie Yerusalem ɩnʋ á, ahógyipʋ amʋ bɔhɔ anɩ atúu. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ɔyɩ kɛhɛ anɩa Paulonyɔ anɩlɛ́yɛkɩ Yakobo. Ɔpasua ahandɛ amʋ fɛ́ɛ́ bɛba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo lɔ́wa amʋ́ ɔnɔ́, ɔlɛbláa amʋ́ tógyítɔ́á Bulu latsʋn mʋsʋ bwɛ́ ahá ánɩ́ bʋmegyí Yudafɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Brɛ́á bonu Paulo asʋ́n ánfɩ á, amʋ́ fɛ́ɛ́ bɛkanfʋ́ Bulu. Mʋ́ʋ́ bɛbláa mʋ bɛɛ, “Opíó nu, Yudafɔ mpɩ́m-mpɩ́m ánɩ́ badámlí klʋntɔ fɛ́ɛ́ bʋdɛ Mose mbla ámʋtɔ kínkíínkín. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Támɛ akʋ babláa amʋ́ bɛɛ, fasúná Yudafɔ ánɩ́ bʋbʋ ɔmá bámbásʋ́ fɛ́ɛ́ fɛɛ, bʋmágyi Mose mbla ámʋsʋ. Ɔma ɛ́ á, fɛɛ bʋmátɩn amʋ́ abí keté, bʋmágyi anɩ amándɩ́ɛ́ ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ɩbwɛ́bwɛ́ɛ́bwɛ́ á, ahá bónu ánɩ́ faba nfɩ. Nkálɩ abɔ́bwɛ tsú mʋ́ ɩwɩ? ");
INSERT INTO nkoNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Abɛ́bláa fʋ tɔ́á fʋbwɛ́ɛ. Ayin abaná akʋá bʋbʋ anɩtɔ baká ntam há Bulu. Ilehián ánɩ́ bɔ́gyʋráa ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kpa amʋ́ ya, amlɩyɔgyʋráa ɩwɩ. Ka amʋ́ atɔ yintáhɛ́ fɛ́ɛ́ ɩkɔ, mɛ́nɩ bɛ́kpa amʋ́ nwun. Ɩ́nɩ ɔbɛ́ha ahá fɛ́ɛ́ bɛ́bɩ ánɩ́ fʋtegyi Mose mbla ámʋsʋ. Ɩ́nɩ sʋ fʋ́ ɩwɩ asʋ́n ámʋ́ʋ́ bonu ámʋ ɩma mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Anɩlawánlɩ́n ɔwʋlʋ́ sɩ́sɩ́ ahógyipʋá bʋmegyí Yudafɔ dodo. Anɩlɔ́wanlɩ́n anɩaa, anɩlablɩ́ ánɩ́ bʋmágyi atogyihɛá bapʋ́há ɩkpɩ. Bʋmágyi obugya pʋ́ ɔbwɩá bapʋ́sa mɔ. Bʋmáwa atsɩ mʋ́a ayin asʋ́n ɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mʋ́ sʋ brɛ́á ɔyɩ́ lɛkɛ a, Paulo lɛ́kpa ayin abaná ámʋ ya, mʋa amʋ́nyɔ bɔyɔ́gyʋráa ɩwɩ. Ɔlɔyɔ Bulu ɔtswɛ́kpa ɩnʋ yɛ́blɩ́ ɛkɛá amʋ́ ɩwɩgyʋráa amʋ ɩbɔ́mɔ ɔnɔ́, ɔbɛ́ba bɔbɔ afɔdɩɛ há amʋ́tɔ́ okugyíɔkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Brɛ́á nkensíénɔ́ ámʋ ɩbá bɔfʋn a, Yudafɔ akʋá botsú Asia ɔmátɔ́ bowun Paulo Bulu ɔtswɛ́kpa ɩnʋ. Ɔdɔm amʋ́ʋ́ bʋbʋ wunsɩnɛ́sʋ́ ɩnʋ ámʋ fɛ́ɛ́ benya ɔblɔ́ Paulosʋ, bɛkɩtá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bɔsʋrá okitikíti bɛɛ, “Israelfɔ ayin, mlɩdalɩ ba oo! Oyin ámʋ́ʋ́ ɔna ɔdɛ ahá atɔ́ suná, yíntá amʋ́ agywɩɩn ámʋ nɩ. Mʋdɛ́kʋsʋ́ lɩ́ɩ́ ɔmá ánfɩ, Mose Mbla pʋ́ Bulu ɔtswɛ́kpa amʋsʋ nɩ́. Alakpá Griikifɔ kʋ́ráá ba Bulu ɔtswɛ́kpa wunsɩnɛ́sʋ́ nfɩ. Mʋ́ sʋ alapʋ́ ifin da ɔwankɩ́kpá amʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bɛblɩ́ mʋ́ alɩ, tsúfɛ́ bowun Efesoyin ɔkʋá bʋtɛtɩ́ mʋ Trofimo mʋa Paulo wúlu amʋtɔ dodo. Ɩ́nɩ sʋ bʋkɩ bɛɛ Paulo lɔ́pʋ oyin ámʋ yáa Bulu ɔtswɛ́kpa ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wúlu amʋtɔ fɛ́ɛ́ lɛda kpokiti. Ahá bɛdalɩ tsu amʋ́ wóyítɔ́ srɩ́ ba bɛkɩtá Paulo, bɛbɩtɩ́a mʋ dálɩ ɔtswɛ́kpa wunsɩnɛ́sʋ́ ɩnʋ, fin ɩban ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Brɛ́á bʋdɛ mʋ da, bʋdekléá bɔ́mɔ mʋ a, ɔkʋ lɛ́yɛbláa Romafɔ ɩsá akɔpʋ́ ɔhandɛ ɔbɛ́ɛ, “Kpokiti ladá Yerusalem wúlutɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɩnʋnʋ ɔhandɛ amʋ lɛ́kpa ɩsá akɔpʋ́ ámʋ akʋ pʋ́ amʋ́ ahandɛ akʋ bɛsrɩ́ yɔ́ ɩnʋ. Ɔdɔm amʋ benya wun amʋ́ alɩ besi Paulo dá. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ɔhandɛ amʋ lɛ́natɩ́ yɔ́tʋ Paulo, ɔlɛha mʋ ɩsá akɔpʋ́ ámʋ bɛkɩtá mʋ, wá mʋ ɩkan anyɔ. Mʋ́ʋ́ ɔlɛfɩtɛ́ ahá ámʋ ɔbɛ́ɛ, “Ma gyí oyin ánfɩ? Ntɔ alabwɛ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ɔdɔm amʋ bʋdɛ okitikíti, bʋdɛtɔtɔ́ɩ. Akʋ bɛɛ alɩ, akʋ ɛ́ bɛɛ alɩ. Okitikíti amʋ ɔnɔ́ lɔwa ɔnlɩn. Mʋ́ sʋ ɔhandɛ amʋ mɛ́bɩ ɔnɔkwalɩá ɩbʋ asʋ́n ámʋtɔ. Ɩ́nɩ sʋ ɔlɛha ɔbɛ́ɛ, bʋkpá Paulo ya ɩsá akɔpʋ́ ámʋ otsiákpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Brɛ́á bowie obu-ɔnɔ́ ɔdʋkpá á, ɔdɔm amʋ bʋdɛ ɩyɩn wa. Mʋ́ sʋ ɩsá akɔpʋ́ ámʋ botsu Paulo wá nkɔnkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ahá ámʋ fɛ́ɛ́ bʋbuo Paulo, bʋdɛ okitikíti bɛɛ, “Mlɩha awuna mɔ mʋ! Mlɩha awuna mɔ mʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Brɛ́á bowie obu ámʋ ɔnɔ́, bɔ́dʋ wíé amʋ́ otsiákpá ɩnʋ á, Paulo lɛ́bláa ɔhandɛ amʋ ɔbɛ́ɛ, “Nobwíí ɩpa, mbláa fʋ asʋankʋ.” Ɔhandɛ amʋ lɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Fʋtonú Griiki ɔblɩ́ɩ? ");
INSERT INTO nkoNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mʋ́ sʋ megyí fʋ́gyí Egyipteyin amʋ́ʋ́ ɔlɛha kpokiti lɛda brɛ́ kʋtɔ, ɔlɛkpa ahá amɔpʋ́ mpɩ́m-na (4,000) buo ɩwɩ ya dimbísʋ́ ámʋ nɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ɩnʋ Paulo lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Yudayin ngyi mɩ́ mʋ́. Tarso ánɩ́ ɩbʋ Kilikia ɔmátɔ́ bɔkwɩɩ́ mɩ́. Megyí wúlubitɔ notsú. Nobwíí ɩpa, ha mɩ́ ambla ahá ánfɩ asʋ́n.” ");
INSERT INTO nkoNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ɩsá akɔpʋ́ ɔhandɛ amʋ lɛ́ha mʋ ɔkpa. Mʋ́ sʋ Paulo lɛ́yɛlɩɩ́ obu-ɔnɔ́ ɔdʋkpá ɩnʋ, bwɛ́ ahá ámʋ ɩbɩ bɛ́kasʋ. Ɩnʋ lɔ́tɔ diin. Mʋ́ʋ́ Paulo lɛ́bláa amʋ́ asʋ́n Hebri ɔblɩ́tɔ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mɩ́ asɩ́, apíó aba, mlɩyaa asʋ mɩ́ anlɛ mɩ́ ɔnɔ́ amlɩnu.” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Brɛ́á bonu ánɩ́ Hebri ɔblɩ́tɔ Paulo dɛ́tɔɩ́ á, ɩnʋ lɔtɔ diin. Mʋ́ʋ́ Paulo lɔ́yɔ mʋ asʋ́nsʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yudayin ngyi. Tarso wúlutɔ bɔkwɩɩ́ mɩ́ Kilikia ɔsʋlʋ́sʋ, támɛ Yerusalem nfɩ bɛyaɩ́ mɩ́. Gamaliel lósuná mɩ́ anɩ anáin mbla ámʋ wankláán. Nɔwa nsi Bulusúm ɩwɩ fɛ́ alɩá mlɩ ɛ́ mlɩdɛ́ mʋ súm ndɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ahá ánɩ́ bʋna anɩ Wíe ɔkpa ánfɩsʋ á, nɛdɩnká amʋ́sʋ́. Nɔmɔ akʋ kʋ́ráá. Nɛkɩtá amʋ́tɔ́ atsɩ mʋ́a ayin akʋ, kɩ́klɩ amʋ́ yɔ́twsɩ obu. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bulu igyí ɔhapʋ́ dɛhɛn pʋ́ Yudafɔ asʋ́n agyípʋ́ amʋ fɛ́ɛ́ bɛ́talɩ́ gyi asʋ́n ánfɩ ɩwɩ adánsɩɛ. Amʋ́ wá nɔhɔ ɔwʋlʋ́ tsú pʋ́ nɛya apíó ánɩ́ bʋbʋ Damasko wúlutɔ, mɩ́ anyɛkɩtá alɩ ahá ámʋ wa amʋ́ ɩkan, pʋ amʋ́ ba Yerusalem, abʋbɩtɩ amʋ́ ɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ɛkɛá nɔpʋ ɔkpa nɔyɔ́, nɛta Damasko wúlutɔ wie tá, ɩbɔ́bwɛ fɛ́ ɔpa dódúanyɔtɔ á, ɔtsáwʋlɛ pɛ́, wankɩ kʋá mʋ́ ɔnɔ́ ɩhɩ́ɛ́ bʋ ɔnlɩn, itsú ɔsʋ́sʋ́ lɔwankɩ́ wʋ́lɩ́ mɩ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mʋ́á nówun a, nda ɔsʋlʋ́tɔ. Ɩnʋ nonu ɔmɛ kʋ. Ɔmɛ amʋ lɛ́fɩtɛ́ mɩ́ ɔbɛ́ɛ, ‘Saulo, Saulo, ntogyi sʋ́ fʋdɩn mɩ́sʋ́ alɩ?’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ɩnʋ nɛfɩtɛ́ mbɛ́ɛ, ‘Fʋ́ ma nɩ, Owíé?’ Mʋ́ʋ́ ɔmɛ amʋ lɛ́bláa mɩ ɔbɛ́ɛ, ‘Mɩ́ Yesu, Nasaretyin ámʋ́ʋ́ fʋ́dɩn mɩ́sʋ́ amʋ nɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mɩ́ aba ámʋ́ʋ́ mɩ́a amʋ́nyɔ anɩná ámʋ bowun wankɩ amʋ, támɛ bʋmonu asʋ́n ánɩ́ ɔmɛ amʋ dɛ́ mɩ́ bláa. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nɛfɩtɛ́ mbɛ́ɛ, ‘Owíé, ntɔ mbwɛ́ɛ?’ Anɩ Wíe lɛ́bláa mɩ ɔbɛ́ɛ, ‘Kʋsʋ, afʋyɔ Damasko wúlutɔ. Bɛ́bláa fʋ tógyítɔ́á Bulu lahá fʋ́ ɔbɛ́ɛ fʋbwɛ́ɛ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wankɩ amʋ ɔnɔ́ bʋ ɔnlɩn. Mʋ́ sʋ mmɛtrá wun tɔtɔ. Ɩ́nɩ sʋ mɩ́ aba ámʋ lɛ́kɩtá mɩ́ ɩbɩ, kpá mɩ́ ya Damasko wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Oyin ɔkʋá bʋtɛtɩ́ mʋ Anania, otenyá Bulu ifú bʋ wúlu amʋtɔ. Otegyi Mose mbla ámʋsʋ wankláán. Mʋ́ sʋ Yudafɔ ánɩ́ bʋbʋ wúlu amʋtɔ fɛ́ɛ́ bʋtɛtɩ́ mʋ ɩdayilé. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Oyin ánfɩ lɛ́ba bɛlɩɩ́ mɩ́ ansɩ́tɔ́, bláa mɩ ɔbɛ́ɛ, ‘Opíó Saulo, bwii ansíbi afʋkɩ atɔ́.’ Ɩnʋnʋ mɩ́ ansíbi lobwií, nowun mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ɔlɛbláa mɩ ɔbɛ́ɛ, ‘Anɩ anáin Bulu ámʋ lɛ́lɛ fʋ́ yáɩ́ ɔbɛ́ɛ, fʋbɛ́bɩ mʋ apɛ́, afʋbɩ mʋ Bi Yilé Ɔbwɛpʋ́ ámʋ, afʋnu mʋ ɔmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tsúfɛ́ fɛ́ba begyi mʋ ɩwɩ adánsɩɛ, bláa ahá fɛ́ɛ́ asʋ́n ánɩ́ fonu pʋ́ mʋ́á fowun. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ntɔ fʋtráa fʋgyo? Kʋsʋ kokoli anɩ Wíe, afʋha abʋbɔ fʋ́ asú, ɔfwɩ fʋ́ lakpan fɛ́ɛ́ lɛ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Brɛ́á neyinkí yɔ́ Yerusalem wúlutɔ ndɛ mpáɩ bɔ Bulu ɔtswɛ́kpa ɩnʋ á, nowun atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mʋ́tɔ́ á, nowun anɩ Wíe Yesu, ɔlɛbláa mɩ́ ɔbɛ́ɛ, ‘Wa ɔsa bwɛ, afʋdalɩ Yerusalem nfɩ. Tsúfɛ́ bʋmɔ́ɔhɔ fʋ́ adánsɩɛ ánɩ́ fégyi tsu mɩ́ ɩwɩ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ɩnʋ nɛbláa mʋ mbɛ́ɛ, ‘Mɩ́ Wíe, amʋ́ onutó bʋyin ánɩ́ netsiá yɔ́ Yudafɔ ofíakpa yɛ́kɩtá ahá ánɩ́ bɔhɔ fʋ gyi, dá amʋ́, wá amʋ́ obu. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Bʋyin ánɩ́ brɛ́á bɔmɔ fʋ́ ɔdansɩyin Stefano a, mbʋ ɩnʋ. Nɛlɩɩ́ amʋ́ ɔma mbɛ́ɛ bʋmɔ́ɔ mʋ, nɔhɔ ámʋ atadɩɛ kʋ́ráá kɩ́tá.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Támɛ anɩ Wíe lɛ́bláa mɩ ɔbɛ́ɛ, ‘Natɩ, nɔ́wa fʋ́ fɔ́yɔ tsútsúútsú, ahá ánɩ́ bʋmegyí Yudafɔ wá.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ahá tsɔtsɔɔtsɔ amʋ bɛya asʋ nú Paulo asʋn blɩ́hɛ́ alɩɩ bɔtʋ brɛ́á ɔlɛblɩ́ ɔbɛ́ɛ, Bulu lɔ́wa mʋ ahá ánɩ́ bʋmegyí Yudafɔ wá. Ɩnʋ bɔsʋrá okitikíti kʋ́klʋ́kʋ́ʋ́, blɩ́ bɛɛ, “Mlɩlɛ mʋ ɩnʋ! Ɩma alɛá obétsiá ɔsʋlʋ́ʋ anfɩsʋ!” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɩnʋ bɔsʋrá okitikíti, nyá ɔblɔ́ wɔ́ɩ́ amʋ́ atadɩɛ tswɩ tsalɩ́fwɩ́, kpá ɩsɩ tswɩ wá afútɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mʋ́ʋ́ ɩsá akɔpʋ́ ɔhandɛ amʋ lɛ́bláa mʋ ahá ɔbɛ́ɛ, “Mlɩkpa Paulo, amlɩpʋ mʋ ya mlɩ otsiákpá. Mlɩpɩtɩ mʋ atɔ́ ɔblɩ ɔnɔkwalɩ, abɩ tɔ́á sʋá ahá ámʋ bʋdɛ okitikíti sʋrá mʋ nwunsʋ alɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Brɛ́á bɛklɩ́ Paulo tá, bɛɛ abʋda mʋ a, ɔlɛfɩtɛ́ ɩsá ɔkɔpʋ́ ɔhandɛ ɔkʋá ɔlɩɩ́ mʋ wá ɔbɛ́ɛ, “Mbla lɛha ɔkpa ánɩ́ mlɩpɩ́tɩ Romayin oduá bʋmɔkʋ́gyi mʋ asʋ́n, há mʋ ɩpɔ́n atɔ́?” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Brɛ́á ɩsá akɔpʋ́ ɔhandɛ amʋ lónu asʋ́n ánfɩ á, ɔlɛyɛ́bláa mʋ ɔhandɛ amʋ ɔbɛ́ɛ, “Fakle afʋsɛ wʋlʋ manta ɩwɩ. Sáa Romayin oyin ámʋ gyí oo!” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mʋ́ʋ́ ɔhandɛ amʋ lɛ́ba Paulo wá, bɛfɩtɛ́ mʋ ɔbɛ́ɛ, “Bla mɩ, lɛ́lɛ́ Romayin fʋgyi?” Paulo lɛ́bláa mʋ ɔbɛ́ɛ, “Romayin ngyi.” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mʋ́ʋ́ ɔhandɛ amʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ mʋ́ á, ɩkɔ kpɔnkpɔntɩ nɛka asa nemlí Romayin.” Támɛ Paulo lɛ́bláa mʋ ɔbɛ́ɛ, “Mɩ́ mʋ́ á, Romayin onutónutó ngyi.” ");
INSERT INTO nkoNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɩnʋnʋ ahá ámʋ́ʋ́ bɛɛ abʋfɩtɛ Paulo asʋ́n ámʋ fɛ́ɛ́ badásáɩ́n. Ifú lɛkɩtá ɔhandɛ amʋ onutó ó, brɛ́á ɔlɛbɩ ánɩ́ Romayin Paulo gyí asa alahá bawá mʋ ɩkan. ");
INSERT INTO nkoNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ɔyɩ kɛhɛ a, ɔhandɛ amʋ lékléá ɔbɛ́bɩ tɔ́á Paulo lɔ́bwɛ, sʋ́ Yudafɔ bʋdɛ asʋ́n kláa dɩnká mʋsʋ. Mʋ́ sʋ ɔlɛha bɔwɔɩ́ Paulo lɛ́ ɩkan amʋtɔ, ɔlɛha bɛtɩ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ asʋ́n agyípʋ́ amʋ befia. Mʋ́ʋ́ ɔlɛha bɛkpa Paulo bɛlɩɩ́ amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo lótsu ansɩ́ kɩ Yudafɔ asʋ́n agyípʋ́ amʋ díín. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó Israelfɔ, nyin mɩ́ klʋntɔ ánɩ́ mmɔkʋ́tsíá nkpa laláhɛ Bulu ansɩ́tɔ́ bɔtʋ ndɛ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mʋ́ʋ́ igyí ɔhapʋ́ dɛhɛn Anania lɛ́bláa ahá ámʋ́ʋ́ bʋlɩɩ́ mantáa mʋ amʋ ɔbɛ́ɛ, bʋdáa mʋ ɔnɔ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ɩnʋ Paulo lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́ Bulu ɔbɛ́da. Fabwɛ́ ɩwɩ fɛ́ buntíiá bakpá mʋ́ afá futútú, fabetsiá asɩ fɛɛ fɔ́pʋ Mose Mbla gyi mɩ́ asʋ́n. Fʋdɛ ahá bláa fɛɛ bʋdá mɩ́ ansɩ́tɔ́. Fʋ́ mʋ́ megyí mbla ámʋ fatʋ́n a?” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aha akʋá bʋlɩɩ́ mantáa Paulo bɛfɩtɛ́ mʋ bɛɛ, “Bulu igyí ɔhapʋ́ dɛhɛn fʋdesia alɩ á?” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo lɛ́bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó, mmeyín mbɛ́ɛ, mʋgyí Bulu igyí ɔhapʋ́ dɛhɛn. Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, ‘Máblɩ́ ɔhá ánɩ́ ɔdɛ fʋ́ ɔmásʋ́ gyí ɩwɩ asʋn laláhɛ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Brɛ́á Paulo lówun ánɩ́ Yudafɔ asʋ́n agyípʋ́ amʋtɔ akʋ bʋgyi Sadukifɔ, akʋ ɛ́ bʋgyi Farisifɔ á, ɔlɔsʋrá okitikíti asʋ́n ogyíkpá ɩnʋ ɔbɛ́ɛ, “Mɩ́ apíó, mɩ́ ánfɩ nlɩɩ́ á, Farisiyin ngyi. Mɩ́ anáin ɛ́ á, Farisifɔ bʋgyi. Mɩ́ ɛ́ nohogyi ánɩ́ awupʋ́ bɛ́lakʋ́sʋ́. Mʋ́ ndɛblɩ́ sʋ bakpá mɩ́ ba asʋ́n ogyíkpá nfɩ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Olenya blɩ́ alɩ pɛ́, ahá tsɔtsɔɔtsɔ amʋtɔ leye anyɔ. Farisifɔ ámʋ pʋ́ Sadukifɔ ámʋ bɔwa aba nwɛ́ɛngyí bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tsúfɛ́ Sadukifɔ bʋtɛblɩ́ bɛɛ, kʋsʋ́ tsú afúlitɔ kʋkʋ má ɩnʋ. Bulu-abɔpʋ pʋ́ ɔŋɛ laláhɛ kʋkʋ ɛ́ ma ɩnʋ. Támɛ Farisifɔ mʋ́ bohogyi ánɩ́ ɩ́nɩ fɛ́ɛ́ bʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɩ́nɩ lɛ́ha nwɛ́ɛn amʋ ɔnɔ́ lɛhɩɛ wá ɔnlɩn. Mbla asunápʋ́á bʋgyi Farisifɔ bɔkʋsʋ́ lɩ́ɩ́ blɩ́ bɛɛ, “Anɩmɔ́kʋ́wun tsitsa kʋkʋ oyin ánfɩ ɩwɩ. Fíalɩ ɔŋɛ́ kʋ ntɛ́ɛ Bulu-ɔbɔpʋ ɔkʋ lɛ́bláa mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nwɛ́ɛn amʋ ɔnɔ́ lɛhɩɛ wa ɔnlɩn, ideklé imli ɩkɔ́. Ɩnʋ ɩsá akɔpʋ́ ɔhandɛ amʋ lénya ifú ánɩ́ bɔ́bwɛ tɩ́tɩ Paulo. Mʋ́ sʋ ɔlɛbláa ɩsá akɔpʋ́ ámʋ ɔbɛ́ɛ, “Mlɩwa ɔsa kpa Paulo ya mlɩ otsiákpá ɩnʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mʋ́ onyé á, anɩ Wíe lɛ́bɛlɩɩ́ Paulo wá, bláa mʋ ɔbɛ́ɛ, “Wa klʋn! Alɩ ánfɩ fagyi mɩ́ ɩwɩ adánsɩɛ Yerusalem nfɩ á, alɩ kɛ́n fʋyégyi mʋ́ Roma wúlutɔ ɛ́ nɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mʋ́ ɔyɩ kɛhɛ a, Yudafɔ ámʋ akʋ befia, kɩ́tá Paulo ɩwɩ agywɩɩn. Bɛka ntam bɛɛ nɩ́ bʋmɔkʋ́mɔ́ Paulo bʋméegyi atɔ́, bʋmóonu ntsu. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ahá ámʋ́ʋ́ bɛka ntam amʋ bʋdʋn adʋana (40). ");
INSERT INTO nkoNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bɔyɔ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ wá, yɛ́bláa amʋ́ bɛɛ, “Anɩlahɩ́ɛ́ ká ntam anɩaa, nɩ́ anɩmɔ́kʋ́mɔ́ Paulo anɩmɛ́ɛda tɔtɔ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mʋ́ sʋ tɔ́á anɩdéklé anɩaa fʋ́a Yudafɔ asʋ́n agyípʋ́ amʋ mlɩbwɛ́ɛ ha anɩ gyí, mlɩkɩ ansɩ́ wa abí sɩsɩ ɩsá akɔpʋ́ ɔhandɛ amʋ mlɩaa, ɔpʋ́ʋ Paulo ba, amlɩlanu mʋ asʋ́ntɔ́. Anɩladá ɩwɩsʋ anɩaa, obótsutsúa obowie nfɩ anɩlamɔ́ mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paulo mʋ bitɛpʋ ɔkʋ lónu asʋ́n ánfɩ fɛ́ɛ́. Mʋ́ sʋ ɔlɛsrɩ́ yɔ́ ɩsá akɔpʋ́ otsiákpá ɩnʋ yówi tsá Paulosʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ɩnʋ Paulo lɛ́tɩ ɩsá akɔpʋ́ ɔhandɛ ɔkʋ, bláa mʋ ɔbɛ́ɛ, “Kpa ɔyasubi ánfɩ ya mlɩ ɔhandɛ wá. Ɔdɛ asʋankʋ, ɔbɛ́bláa mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ɩsá akɔpʋ́ ɔhandɛ amʋ lɛ́kpa ɔyasubi ámʋ ya amʋ́ ɔhandɛ wá, yɛ́bláa mʋ ɔbɛ́ɛ, “Obu ɔdɩpʋ́ Paulo ɔbɛ́ɛ, nkpá ɔyasubi ánfɩ ba fʋ. Ɔdɛ asʋankʋ, ɔbɛ́bláa fʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ɔhandɛ amʋ lɛ́kɩtá ɔyasubi ámʋ ɩbɩ, kpá mʋ yáa ɩtsɛ́tɔ́ yɛ́fɩtɛ́ mʋ ɔbɛ́ɛ, “Amansʋ fʋbʋ ánɩ́ fɛ́bláa mɩ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ɔyasubi ámʋ lɛ́bláa mʋ ɔbɛ́ɛ, “Yudafɔ ahandɛ babwɛ́ agywɩɩn bɛɛ bépina wa abí fʋ́ wá bɛɛ, fʋkpá Paulo ba obowun amʋ́ ɔkɛ, abʋlanu mʋ asʋ́n ámʋtɔ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Támɛ máhɔ mʋ́sʋ́ gyi, tsúfɛ́ amʋ́ ayin ánɩ́ bʋdʋn adʋana (40) bɛɛ béŋaín ɔkpatɔ gyo Paulo, mɔ́ mʋ. Amʋ́ fɛ́ɛ́ baká ntam bɛɛ, tɔtɔ mɛ́ɛda amʋ́ ɔnɔ́, kpɛ́fʋn brɛ́á bamɔ́ mʋ. Fʋ́ nkʋlɛ bʋgyo séi ánɩ́ fótsulá kpá mʋ ba.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mʋ́ʋ́ ɔhandɛ amʋ lɛ́da ɔyasubi ámʋ ɔlá ɔbɛ́ɛ, “Máyɛ́bláa ɔhaa fɛɛ fawí asʋ́n ánfɩ tsá mɩ́sʋ́.” Olesi mʋ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ɩnʋ ɔhandɛ amʋ lɛ́tɩ ɩsá akɔpʋ́ ahandɛ abanyɔ́, ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mlɩlɛ ɩsá akɔpʋ́ lafanyɔ (200), mpɔnkɔsʋ adɩnkápʋ́ aduesienɔ́ (70) pʋ́ pɩ́a atswɩ́pʋ lafanyɔ (200) abʋkʋsʋ onyenɩ dokwebátɔ́ yɔ Kaesarea. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mlɩha Paulo mpɔnkɔ, odɩnká amʋ́sʋ́ yɔ. Mlɩkpa mʋ, amlɩha mʋ oyowie ɔmásʋ́ ogyípʋ́ Felike wá pisii.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ɔhandɛ amʋ lɔ́wanlɩ́n ɔwʋlʋ́ mántá mʋsʋ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mɩ́ Klaudio Lisia dɛ́ ɔwʋlʋ́ ánfɩ wanlɩ́n sɩ́sɩ́ fʋ́, ɔmásʋ́ ogyípʋ́ onumnyampʋ Felike. Ndɛ fʋ́ itsiá ha. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ndɛ fʋ́ ɩbɩ ha ánɩ́ Yudafɔ lɛ́kɩtá oyin ánfɩ, bʋdekléá bɔ́mɔ mʋ, támɛ mɩ́a ɩsá akɔpʋ́ tsɔtsɔɔtsɔ anɩlɔ́yɔ́hɔ mʋ lɛ́ amʋ́ ɩbɩ. Tsúfɛ́ nonu ánɩ́ Romayin ogyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ndeklé mbɛ́ɛ, nɛ́bɩ tɔ́á ɔlɔbwɛ. Mʋ́ sʋ nɔpʋ mʋ ya amʋ́ Yudafɔ asʋ́n agyípʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ɩnʋ nowun ánɩ́ amʋ́ mbla ɩwɩ nwɛ́ɛn bʋdegyí. Mʋ́ sʋ ɔmɔkʋ́bwɛ́ lakpan kʋkʋá bɔ́mɔ mʋ, ntɛ́ɛ bɔ́wa mʋ obu. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Támɛ ɔkʋ laba bowi tsá mɩ́sʋ́ ɔbɛ́ɛ, Yudafɔ ámʋ akʋ babwɛ́ agywɩɩn bɛɛ bɔ́mɔ mʋ. Ɩnʋ́ nɔbwɛ agywɩɩn mbɛ́ɛ, nɔ́pʋ mʋ sɩ́sɩ́ fʋ́. Nabláa mʋ anyabá ámʋ ɛ́ mbɛ́ɛ bʋpʋ́ʋ amʋ́ asʋ́n ba fʋ. Nafʋn nfɩ. Nɛhá fʋ́ itsiá gyágyáágyá.” ");
INSERT INTO nkoNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ɩsá akɔpʋ́ ámʋ bɔbwɛ dɩ́nká amʋ́ ɔhandɛ asʋn blɩ́hɛ́sʋ. Onyé-onyé ámʋ bɛkpa Paulo kɔnkɔɔnkɔn alɩɩ yówie Antipatri wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Brɛ́á ɔyɩ́ lɛkɛ a, bɛha mpɔnkɔsʋ adɩnkápʋ́ amʋ bɛkpa mʋ yáa Kaesarea, ayabitɔ anatɩ́pʋ́ amʋ beyinkí yɔ́ amʋ́ otsukpá. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Brɛ́á mpɔnkɔsʋ adɩnkápʋ́ amʋ boyówie ɩnʋ a, bɔpʋ Paulo pʋ́ ɔwʋlʋ́ ámʋ wá ɔmásʋ́ ogyípʋ́ amʋ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ɔmásʋ́ ogyípʋ́ amʋ lɛ́kla ɔwʋlʋ́ ámʋ, ɔlɛfɩtɛ́ Paulo ɔbɛ́ɛ, “Nkʋ́nʋ yin fʋgyi?” Brɛ́á ɔlɛbɩ ánɩ́ Kilikia ɔmátɔ́ Paulo otsú á, ");
INSERT INTO nkoNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ɔlɛbláa Paulo ɔbɛ́ɛ, “Nɩ́ fʋ́ anyabá ámʋ bɛbá á, nónu fʋ́ ɔnɔ́ asʋ́n.” Ɩnʋ ɔlɛbláa amʋ́ ɔbɛ́ɛ, bʋpʋ́ʋ Paulo yɔwa Owíe Herode wóyítɔ́, abʋgyo mʋ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nkenú ɔma a, igyí ɔhapʋ́ dɛhɛn Anania mʋa Yudafɔ ahandɛ akʋ pʋ́ Mose mbla ɔbɩpʋ́ ɔkʋá bʋtɛtɩ́ mʋ Tertulo bɛba Kaesarea. Bɛbá bɛkla asʋ́n ánɩ́ bʋbʋ tsu Paulo ɩwɩ súná ɔmásʋ́ ogyípʋ́ Felike. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bɛtɩ Paulo bɛlɩɩ́. Mʋ́ʋ́ Tetulo lɛ́kla mʋ asʋ́n ɔbɛ́ɛ, “Onumnyampʋ Felike, fahá iwilwii laba ɔmá ánfɩtɔ. Fʋ́ nyánsa lalá atɔ́ tsɔtsɔɔtsɔ bwɛ́ anɩ ɔmá ánfɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Fʋ́ bwɛhɛ́ legyi anɩ ansɩ́ ɔtɩ́nɛgyíɔtɩ́nɛ́. Fʋ́dɛ́ atɔ́ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mmedéklé mbɛ́ɛ néyintá fʋ́ brɛ́ tsɔtsɔ. Mʋ́ sʋ nokókóli fʋ, nya klʋn ha anɩ, afunu anɩ asʋ́n tinbí ánfɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Anɩlawun ánɩ́ atɔ́ oyintápʋ́ oyin ánfɩ gyí. Ɔtɛhá kpokiti tɛdá Yudafɔtɔ ɔyɩ́tɔ́ ɔtɩ́nɛgyíɔtɩ́nɛ́á ɔtɔyɔ́. Ɔtráa ogyi Nasaret ɔpasua ámʋ Bulu igyí ɔhapʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Alakle ɔpʋ ifin da Bulu ɔtswɛ́kpa ɩnʋ, asa ɔkláa ogyá anɩlɛ́kɩtá mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nɩ́ fʋ́ onutó fɛfɩ́tɛ́ mʋ a, fówun ánɩ́ asʋ́n ánfɩ anɩdɛ́blɩ́ tsú mʋ ɩwɩ ánfɩ fɛ́ɛ́ bʋ mʋ́tɔ́ ntɛ́ɛ ɩma mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ɩnʋ ámʋ fɛ́ɛ́ botsulá mʋ́sʋ́ bɛɛ, asʋ́n ámʋ́ʋ́ alablɩ́ ámʋ bʋ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ɔmásʋ́ ogyípʋ́ Felike lɔ́bwɛ Paulo ɩbɩ ɔbɛ́ɛ, ɔlɛ́ mʋ ɔnɔ́. Ɩnʋ Paulo lɛ́blɩ́ ɔbɛ́ɛ, “Nyin ánɩ́ fʋdɛ asʋ́n gyí ɔmá ánfɩtɔ ɩlawá ɔpá. Ɩ́nɩ sʋ ɩbʋ mɩ ɔdwɛ ánɩ́ nɛ́lɛ mɩ́ ɔnɔ́ fʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nobwíí ɩpa, fɛ́talɩ́ fɩ́tɛ́ nú ánɩ́ ɩbʋ mʋ́tɔ́á nɔyɔ Yerusalem yósum Bulu, ɩmɔkʋ́dʋn nkɛ dúanyɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mɩ́ anyabá ánfɩ bʋmowun mɩ́a ɔhaa agyi nwɛ́ɛn Bulu ɔtswɛ́kpa ɩnʋ. Bʋmowun mɩ́ anha kpokiti ɩda Yudafɔ ofíakpa kʋkʋ ntɛ́ɛ ɔtɩnɛtɩnɛ wúlu amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bʋma asʋansʋá bɔ́pʋgyi adánsɩɛ ánɩ́ amʋ́ asʋ́n ánfɩ bʋ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Támɛ natsúlá ánɩ́ ntosúm anɩ anáin Bulu tsʋn anɩ Wíe Ɔkpa ámʋ́ʋ́ bʋdɛ mʋ́ tɩ ɔpasua laláhɛ amʋsʋ. Nɔhɔ Mose Mbla ámʋ pʋ́ mʋ́á Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɔwanlɩ́n tswɩ ɛ́ fɛ́ɛ́sʋ́ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ndɛ ɔkpa kɩ́ɩ fɛ́ alɩá amʋ́ ɛ́ bʋdɛ ɔkpa kɩ́ɩ ánɩ́ Bulu ɔbɔ́kʋsʋ́a aha yilé pʋ́ aha laláhɛ fɛ́ɛ́ tsú afúlitɔ ɛkɛ kʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ɩ́nɩ sʋ ntɔbɔ́ mbɔ́dɩ́ ánɩ́ mɩ́ klʋn méetsiá há mɩ́ pɔ́n Bulu mʋa anyánkpʋ́sa fɛ́ɛ́ ansɩ́tɔ́ brégyíbrɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ɩ́nɩá nɛdalɩ Yerusalem ɩlawá ɔpá á, nayínkí ba ɩnʋ, napʋ́ atokiehɛ́ nɛbá mɩ́ ahá abʋpʋha ahiánfɔ, mɩ́ anha Bulu igyí. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mʋ́ ɔbwɛkpá mbʋ Bulu ɔtswɛ́kpa ɩnʋ. Brɛ́á nɔgyʋráa ɩwɩ tá amándɩ́ɛ́ ámʋ ɔnɔ́ á, bɛba bɔtʋ mɩ́ ɩnʋ. Megyí mɩ́a ɔdɔm kʋkʋ lɔ́yɔ ɩnʋ. Kpokiti kʋkʋ ɛ́ mɛda ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yudafɔ akʋ botsu Asia ɔmátɔ́ ba bʋbʋ ɩnʋ. Nɩ́ nɔbwɛ ɩtɔ laláhɛ kʋ á, tɛkɩ amʋ́ kʋ́ráá ɔbɛ́ba bɛbláa fʋ, mɩ́a amʋ́nyɔ abɛ́blɩ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nɩ́ ɩbɔ́wa alɛ́ kʋ́ráá á, ha ahá ánfɩ onutó abʋblɩ tsitsa oduá Yudafɔ asʋ́n agyípʋ́ amʋ bowun mɩ́ ɩwɩ, brɛ́á bɔpʋ mɩ́ ya amʋ́ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Asʋn kua kʋlɛ pɛ́á nɔkplʋ́n blɩ́ brɛ́á nlɩɩ́ Yudafɔ asʋ́n agyípʋ́ amʋ ansɩ́tɔ́ gyí, ‘Mlɩdɛ́ mɩ́ asʋ́n gyí ndɛ, tsúfɛ́ nohogyi ánɩ́ awupʋ́ bɛ́lakʋ́sʋ́ tsú afúlitɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ɩ́nɩá onumnyampʋ Felike yin anɩ Wíe ɔkpa ámʋ wankláán sʋ á, olotu asʋ́n ámʋ hɩ́ɛ́. Ɔlɛblɩ́ ɔbɛ́ɛ, “Nɩ́ ɩsá akɔpʋ́ ɔhandɛ Lisia ɔbá nfɩ á, nówun alɩá nɔ́mɔ asʋ́n ámʋ ɔnɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ɔlɛbláa ɩsá akɔpʋ́ ɔhandɛ ámʋ ɔbɛ́ɛ, ogyóo Paulo ɩwɩ wankláán, ɔha mʋ otsia iwilwiitɔ. Ɔhá mʋ aba ɔkpa abʋkɩ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nkɛ kpalobí kʋ ɔma a, Felike mʋa mʋ ka Drusila ánɩ́ ogyi Yudayintse bɛba. Felike lɛ́ha bɛyɛ́kpa Paulo ba, ɔlɔbɔtɔɩ́ tsú mʋ hógyi ánɩ́ ɔbʋ Kristo Yesutɔ ɩwɩ súná amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Támɛ brɛ́á ɔdɛtɔɩ́ tsú yilébwɛ, ɩwɩsʋgyí pʋ́ Bulu asʋ́n ogyíkɛ́ amʋ́ʋ́ ɩbá ámʋ ɩwɩ á, ifú lɛkɩtá Felike. Mʋ́ sʋ ɔlɛbláa Paulo ɔbɛ́ɛ, “Kʋ yinki asa. Nenyá brɛ́ wankláán kʋ á, nɛ́latɩ́ fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Brɛ́ ámʋtɔ fɛ́ɛ́ Felike lɛ́kɩ ɔkpa ánɩ́ Paulo obódunká tɔkʋ bɛha mʋ ɔnɔ́. Mʋ́ sʋ ɩbʋ nʋ bʋ ɩnʋ á, alapina wa abí bayɛ́tɩ Paulo, mʋa mʋnyɔ batɔ́ɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nfinyɔ ɔma a, Felike lɛ́natɩ́. Porkio Festo lébetsiá mʋ obíásʋ́. Ɩ́nɩá Felike déklé ɔbɛ́ɛ, mʋ asʋ́n ɩwá Yudafɔ ámʋ ɔdwɛ sʋ á, olesi Paulo wá obu nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ɔmásʋ́ ogyípʋ́ Porkio Festo lébetsiá obíásʋ́ Kaesarea. Mʋ́ ɛkɛ sáásɩ́ a, ɔlɔdʋ yɔ́ Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ɩnʋ Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ akʋ bɔpʋ Paulo ɩwɩ asʋ́n yɔ́tswɩ mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bɔbwɛ agywɩɩn ánɩ́ bɔ́yɔwa obúun ɔkpatɔ, mɔ́ Paulo. Mʋ́ sʋ bɔyɔ́kʋlɩ́ Festo bɛɛ, ɔpʋ́ʋ Paulo ba Yerusalem. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Támɛ Festo lɛ́bláa amʋ́ ɔbɛ́ɛ, “Paulo da obu Kaesarea wúlutɔ dodo. Ɩmɔ́ɔwa ɔpá mɩ́ ɛ́ néyinkí yɔ́ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mlɩha mlɩ ahandɛ amʋ akʋ abʋbuo mɩ yɔ ɩnʋ, abʋyɛblɩ́ tsitsa oduá alabwɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo lɛ́trá tsiá Yerusalem nkekwé ntɛ́ɛ nkɛ dú asa oleyinkí yɔ́ Kaesarea. Olowie ɩnʋ á, ɔlɔwa bɔyɔ́pʋ Paulo ba, oletsiá asʋ́n ámʋsʋ ɔyɩ kɛhɛ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo lénya wíé ɩnʋ alɩ, ahandɛ amʋ́ʋ́ botsu Yerusalem ba amʋ bɛkafía mʋ, kla asʋ́n tsɔtsɔɔtsɔ dɩ́nká mʋsʋ. Támɛ bʋmɛtalɩ́ nyá tɔtɔ pʋ́súná ánɩ́ asʋ́n ámʋ ɩbʋ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mʋ́ʋ́ Paulo lɛ́lɛ mʋ ɔnɔ́ ɔbɛ́ɛ, “Mmɔkʋ́tʋ́n Yudafɔ mbla kʋkʋ, ntɛ́ɛ bwɛ́ tɔkʋ pʋ́ ifin da Bulu ɔtswɛ́kpa amʋ ntɛ́ɛ pʋ́ lalahɛ kʋkʋ ɛ́ gyi Roma owíe dɛhɛn.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festo déklé ɔbɛ́ɛ mʋ asʋ́n ɩwá Yudafɔ ámʋ ɔdwɛ. Mʋ́ sʋ ɔlɛfɩtɛ́ Paulo ɔbɛ́ɛ, “Fʋdeklé fɛɛ fɔ́yɔ Yerusalem, mɩ́ anyegyi fʋ́ asʋ́n ɩnʋ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo lɛ́lɛ mʋ́ ɔnɔ́ ɔbɛ́ɛ, “Roma Owíe Dɛhɛn asʋ́n ogyíkpá nlɩɩ́. Nfɩ́ ilehián ánɩ́ bégyi mɩ́ asʋ́n. Fʋ́ onutó fʋyin ánɩ́ mmɔkʋ́bwɛ́ Yudafɔ tɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nɩ́ natʋ́n mbla, ilehián lowu á, mmɔkʋ́tin ɔkpa mbɛ́ɛ bʋmámɔ mɩ́. Támɛ nɩ́ asʋ́n ánfɩ Yudafɔ bablɩ́ dɩ́nká mɩ́sʋ́ anfɩ ma mʋ́tɔ́ á, ɔhaa má ɔkpa ánɩ́ ɔbɔ́pʋ mɩ́ wá amʋ́ ɩbɩtɔ. Mʋ́ sʋ mʋ́ bʋpʋ́ʋ mɩ́ asʋ́n ya Roma Owíe Dɛhɛn onutó ogyi mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ɩnʋ Festo mʋa mʋ ahandɛ bɔyɔ abrɩwa wá. Mʋ́ʋ́ ɔlɛbɛbláa Paulo ɔbɛ́ɛ, “Fʋ́ onutó fɛɛ, Roma Owíe Dɛhɛn ogyíi fʋ́ asʋ́n. Mʋ́ sʋ abɔ́pʋ fʋ́ ya mʋ wá.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nkɛ kʋ ɔma a, Owíe Agripa mʋa Berenike bɛba Kaesarea. Bɛbá bɛha Festo nwunkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Betsiá ɩnʋ wá ɔpá. Mʋ́ sʋ Festo lɛ́bláa amʋ́ Paulo ɩwɩ asʋ́n. Ɔbɛ́ɛ, “Felike lɔ́wa oyin ɔkʋ obu nfɩ, olesi mʋ wá nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Brɛ́á nɔyɔ Yerusalem a, Bulu igyí ahapʋ́ dɛhɛn pʋ́ Yudafɔ ahandɛ bɛba bɛblɩ́ asʋ́n tsɔtsɔɔtsɔ dɩ́nká mʋsʋ, bláa mɩ bɛɛ nháa mʋ ɩpɔ́n, abʋmɔ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Támɛ nɛbláa amʋ́ mbɛ́ɛ, ‘Ɩma anɩ Romafɔ amándɩ́ɛ́tɔ́ ánɩ́ bɛ́ha ɔkʋ ɩpɔ́n, nkɛ́tɩ mʋa mʋ anyabá bafia gyi asʋ́n.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mʋ́ sʋ ɛkɛá mɩ́a Yudafɔ ámʋ anɩlóbowie Kaesarea nfɩ á, mmesi wá obíátɔ́. Ɔyɩ kɛhɛ kótóó nɛha bɔyɔ́pʋ oyin ámʋ ba, netsiá asʋ́n ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nkɩ mbɛ́ɛ mʋ anyabá ámʋ bénya tsitsa kʋ tsú mʋ ɩwɩ, támɛ bʋmenya. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Mboún amʋ́ Bulusúm pʋ́ Yesu ɔkʋá alawú tsʋn, támɛ Paulo ɔbɛ́ɛ, ɔtráa otsie nkpa ɩwɩ asʋ́n bʋdɛbɩtɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mʋ́ sʋ mmowun alɩá nɔ́yɔ asʋ́n ámʋtɔ. Nɛfɩtɛ́ Paulo mbɛ́ɛ, obótsulá abʋyɔ Yerusalem, yégyi asʋ́n ámʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Támɛ ɔlɛblɩ́ ɔbɛ́ɛ, mʋdekléá mʋ asʋ́n ɩyɔ́ Roma Owíe Dɛhɛn ansɩ́tɔ́. Mʋ́ sʋ nɛha bɔwa mʋ obu yɔ́fʋn brɛ́á nɔ́pʋ mʋ sɩ́sɩ́ Roma Owíe Dɛhɛn.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mʋ́ʋ́ Agripa lɛ́bláa Festo ɔbɛ́ɛ, “Mɩ́ ɛ́ ndeklé mbɛ́ɛ nónu asʋ́n ánfɩ tsú mʋ onutó ɔnɔ́tɔ́.” Festo lɛ́bláa mʋ ɔbɛ́ɛ, “Ɔkɛ nɛ́ha bɔ́pʋ mʋ ba, ɔbɛlɛ asʋ́n ámʋtɔ suna fʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ɔyɩ kɛhɛ a, Agripa mʋa Berenike bɛhɩ́hɩɛ ɩwɩ, ɩsá akɔpʋ́ pʋ́ wúlu ahandɛ bobuo amʋ́ ba. Festo lɛ́ha bɛkpa Paulo ba ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mʋ́ʋ́ ɔlɛblɩ́ ɔbɛ́ɛ, “Owíe Agripa mʋa ahá ánɩ́ bafia nfɩ fɛ́ɛ́, mlɩlawun oyin ánfɩ ɔlɩɩ́? Yudafɔ ánɩ́ bʋbʋ nfɩ pʋ́ Yerusalem fɛ́ɛ́ bɔpʋ mʋ asʋ́n ba mɩ. Bɛɛ, mehián ánɩ́ ɔbɛ́trá tsiá nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Brɛ́á nɔyɔ asʋ́n ámʋtɔ á, mmowun tɔ́á alabwɛ́ sʋ bɔ́mɔ mʋ. Támɛ mʋ onutó ɔbɛ́ɛ, mpʋ́ʋ mʋ asʋ́n ya Roma Owíe Dɛhɛn. Mʋ́ sʋ nabwɛ́ agywɩɩn mbɛ́ɛ, nɛ́ha bɔ́pʋ mʋ ya. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Támɛ mmowun tsitsa kʋkʋ mʋ ɩwɩ ánɩ́ nɔ́wanlɩ́n mántá mʋsʋ bɔ́pʋ mʋ ya. Mʋ́ sʋ́ nakpá mʋ ba mlɩ ansɩ́tɔ́ nɩ́, títriu fʋ́ Owíe Agripa. Ndekléá atɛ́tɛ asʋ́n ámʋtɔ, ɔtɩ́nɛ́á ileyéyi a, mɩ́ anya asʋankʋ wanlɩ́n sɩ́sɩ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tsúfɛ́ nawun ánɩ́ ɩma alɛá bɔ́pʋ obu ɔdɩpʋ́ sɩ́sɩ́, bʋmɔwanlɩ́n tɔ́á alabwɛ́ mántá mʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mʋ́ʋ́ Owíe Agripa lɛ́bláa Paulo ɔbɛ́ɛ, “Nahá fʋ́ ɔkpa, kʋsʋ lɛ fʋ́ ɔnɔ́.” Paulo lótsu ɩbɩ fʋ́á, lɛ́ mʋ ɔnɔ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Owíe Agripa, nawun ánɩ́ ɔkláa lawá mɩ́ ogyá nlɩɩ́ fʋ́ ansɩ́tɔ́, ndɛ mɩ́ ɔnɔ́ lɛ tsú asʋ́n ánfɩ Yudafɔ bakla dɩnká mɩ́sʋ́ anfɩ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mʋ́á ɩbʋ ansigyí kʋ́ráá gyí, fʋyin Yudafɔ amándɩ́ɛ́ pʋ́ tɔ́á bʋtegyi mʋ́ ɩwɩ nwɛ́ɛn fɛ́ɛ́. Ɩ́nɩ sʋ kókoli, nya klʋn afʋnu mɩ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yudafɔ fɛ́ɛ́ bʋyin mɩ́ tsiátɔ́. Bʋyin alɩá nɔpʋtsíá mɩ́ ɔmátɔ́ tsú mɩ́ nyebitɔ pʋ́ alɩá nɔpʋtsíá Yerusalem wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Amʋ́ fɛ́ɛ́ bʋyin mɩ dodoodo. Nɩ́ bʋdeklé a, amʋ́ onutó bɛ́talɩ́ bláa fʋ ánɩ́ Farisiyin ngyi wankláán. Farisifɔ ɛ́ bʋtegyi Yudafɔ Bulusúm mbla ámʋsʋ wankláán dʋn ɔpasua kugyíkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Tɔ́á sʋá ndɛ nlɩɩ́ nfɩ, fʋdɛ mɩ́ asʋ́n gyí gyí, ndɛ ɔkpa kɩ́ɩ ánɩ́ Bulu ɔbɔ́bwɛ dɩ́nká mʋ asʋ́n ámʋ́ʋ́ ɔlɛka mʋ́ ɩwɩ ntam há anɩ anáin amʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Anɩ abusuan dúanyɔ ámʋ fɛ́ɛ́ bɔpʋ ansɩ́ dɩ́nká ntam anfɩsʋ ánɩ́ ɩbɛ́ba mʋ́tɔ́ há amʋ́. Mʋ́ sʋ́ bʋdɛ Bulu súm ekekegyíɛkɛ nɩ́. Nanáin, ntam anfɩ sʋ́ Yudafɔ bʋdɛ asʋ́n kláa dɩnká mɩ́sʋ́ nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ntogyi sʋ́ mlɩ Yudafɔ ánfɩ mʋ́ mlɩmɛ́tálɩ́ hógyi ánɩ́ Bulu ɔbɛ́talɩ́ kʋ́sʋ́a ahá tsú afúlitɔ? ");
INSERT INTO nkoNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Tɛkɩ mɩ́ óó nohogyiá nɔ́bwɛ tógyítɔ́á nɛ́talɩ́ pʋ́tin Yesu Nasaretyin amʋ gyumagyihɛ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ɩ́nɩ gyí tɔ́á nɔbwɛ Yerusalem nɩ. Bulu igyí ahapʋ́ dɛhɛn amʋ bɛha mɩ́ túmi bɛɛ, nkɩ́ta Bulu ahá ámʋ tswɩ obu. Nɩ́ bɔ́mɔ amʋ́ ɛ́ á, mɩ́ ɛ́ ntotsúlá mbɛ́ɛ bʋmɔ́ɔ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Netsiá yɔ́ Yudafɔ ofíakpa kugyíkʋtɔ, ntɛhá bʋtɛkɩ́tá amʋ́, bɩ́tɩ́ amʋ́ ɩsʋ, hɩ́ɛ́ amʋ́ bʋtɛblɩ́ Yesu ɩwɩ abususʋ. Amʋ́ ɩwɩ ɔblɔ́ sʋ ntɛdɩ́nká amʋ́sʋ́ yɔ́ ɔmá bámbásʋ́ yɛ́kɩ́tá amʋ́, bɩ́tɩ́ amʋ́ ɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Mʋ́ ɔkpa ɛkɛ ɔkʋ Bulu igyí ahapʋ́ dɛhɛn amʋ bɛha mɩ́ nɔyɔ́ Damasko wúlutɔ yɔ́bwɛ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Brɛ́á nna ɔkpatɔ nɔyɔ́ á, Nanáin, ɩbwɛ fɛ́ ɔpa dódúanyɔtɔ, wankɩ kʋ lɔ́wankɩ́ tsú ɔsʋ́sʋ́ wʋ́lɩ́ mɩ́sʋ́. Ɩlɔwankɩ́ dʋn owí. Ɩlɔwankɩ́ wʋ́lɩ́ mɩ́a mɩ́ aba ámʋ́ʋ́ anɩná ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ɩnʋ anɩ fɛ́ɛ́ anɩlɛ́dɩda. Nonu ɔmɛ kʋ Hebri ɔblɩ́tɔ ɔbɛ́ɛ, ‘Saulo, Saulo, ntogyi sʋ́ fʋ́dɩn mɩ́sʋ́ alɩ? Ɩwɩ tɔ́ɩ fʋdɛwa.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mʋ́ʋ́ nɛfɩtɛ́ mbɛ́ɛ, ‘Owíé, fʋ́ ma nɩ?’ Mʋ́ʋ́ anɩ Wíe lɛ́bláa mɩ ɔbɛ́ɛ, ‘Mɩ́ Yesu nɩ. Mɩ́sʋ́ fʋdɩn nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nabɛlɛ ɩwɩ ɔwan súná fʋ́, mɛ́nɩ fɔ́bwɛ mɩ́ osúmpʋ́. Kʋsʋ, afʋyɛbláa ahá tɔ́á fawun tsu mɩ́ ɩwɩ ndɛ, pʋ́ mʋ́á nɛ́lɛ súná fʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nɔ́kɔ hɔ fʋ tsú ahá ámʋ́ʋ́ ndɛ fʋ́ wa sɩ́sɩ́, bʋgyi fʋ́ onutó ahá Yudafɔ pʋ́ amʋ́á bʋmegyí Yudafɔ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Fóbwií amʋ́ ansɩ́, bɛ́dalɩ tsu oklúntɔ ba wankɩtɔ. Fɛ́lɛ amʋ́ tsú Satan túmi asɩ ba Bulu wá, mɛ́nɩ obési amʋ́ lakpan kíé amʋ́, fówun bénya otsiákpá ahá ámʋ́ʋ́ Bulu latsʋn amʋ́ hógyisʋ bwɛ́ amʋ́ mʋ ahá amʋtɔ.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nanáin Agripa, ɩ́nɩ sʋ nɔbwɛ dɩ́nká atɔ́ ámʋ́ʋ́ nowun itsú ɔsʋ́sʋ́ ámʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Gyankpapʋ a, nɔyɔ Damasko wúlutɔ. Mʋ́ ɔma a, nɔyɔ Yerusalem pʋ́ Yudea ɔmátɔ́ fɛ́ɛ́. Nɔyɔ ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ ɛ́ wá. Nɛyɛ́bláa amʋ́ mbɛ́ɛ, bʋsíi lakpan bwɛ, abʋdamli ba Bulu wá, abʋtsia tsiátɔ́ ánɩ́ ilosuná ánɩ́ badámlí klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ɩ́nɩ sʋ́ Yudafɔ ámʋ bɛkɩtá mɩ́ brɛ́á mbʋ Bulu ɔtswɛ́kpa ɩnʋ bɛɛ bɔ́mɔ mɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Támɛ Bulu dɛ́ mɩ́ kpa alɩɩ bɔfʋn ndɛ. Mʋ́ sʋ́ nlɩɩ́ nfɩ ndɛ, ndɛ mlɩ nyebí-ahandɛ fɛ́ɛ́ tɔ́á nawun bláa nɩ. Asʋ́n ánɩ́ Mose mʋa Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ bɛblɩ́ bɛɛ ɩbɛ́ba mʋ́tɔ́ kɛ́n ndɛblɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bɛɛ, ‘Ilehián ánɩ́ Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ) obówun ɩwɩɔsɩn wú, mɛ́nɩ ɔbɔ́bwɛ ɔha gyankpapʋ ánɩ́ ɔbɔ́kʋsʋ́ tsú afúlitɔ. Ɔbɔ́pʋ wankɩ ba Yudafɔ pʋ́ ahá ánɩ́ bʋmegyí Yudafɔ ɛ́.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Brɛ́á Paulo lɛ́blɩ́ ɩ́nɩ á, ɔmásʋ́ ogyípʋ́ Festo lɔ́kplʋn wa Paulo ɔbɛ́ɛ, “Paulo, fʋ́ nwun layíntá! Fʋ́ ɔwʋlʋ́bɩ dʋbɩdʋbɩ amʋ lahá fʋdɛ gbedé lɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mʋ́ʋ́ Paulo lɛ́bláa mʋ ɔbɛ́ɛ, “Onumnyampʋ Festo, mmɛdɛ́ gbedé lɔ. Ɔnɔkwalɩ onutónutó ndɛ mlɩ bláa. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nanáin Agripa yin asʋ́n ánfɩ fɛ́ɛ́ ɩwɩ. Nɛ́talɩ́ bláa mʋ faan. Nahogyi ánɩ́ megyí asʋn ŋaínhɛ́ igyi há mʋ, tsúfɛ́ bʋmɔbwɛ mʋ́ ŋáín. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nanáin Agripa, fɔhɔ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ asʋn wanlɩ́nhɛ́ amʋsʋ gyi? Nyin ánɩ́ fɔhɔ mʋ́sʋ́ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ɩnʋ Owíe Agripa lɛ́bláa Paulo ɔbɛ́ɛ, “Fahogyi fɛɛ fɛ́talɩ́ dámlí mɩ́ bwɛ́ Okristoyin brɛ́ tinbí ánfɩtɔ?” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo lɛ́bláa mʋ ɔbɛ́ɛ, “Brɛ́ tinbí o, brɛ́ tsɔtsɔɔtsɔ o, mɩ́ mpáɩ ánɩ́ ndɛbɔ há Bulu gyí, fʋ́a ahá ánfɩ mlɩdɛ́ mɩ́ asʋn blɩ́hɛ́ nu ndɛ ánfɩ fɛ́ɛ́ mlɛ́ba bɔbwɛ fɛ́ mɩ́. Támɛ bʋmáwa mlɩ ɩkan anfɩ mʋ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ɩnʋ á, Owíe Agripa mʋa ɔmásʋ́ ogyípʋ́ Festo pʋ́ Berenike mʋa ahá ámʋ́ʋ́ bʋtsie ɩnʋ ámʋ fɛ́ɛ́ bɔkʋsʋ́ dálɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bɛyɛ́lɩɩ́ ɩtsɛ́tɔ́, amʋ́ wʋlɛwʋlɛ bʋdɛblɩ́ bɛɛ, “Oyin ánfɩ mɔ́kʋ́bwɛ́ tɔtɔá ilehián ha mʋ lowu ntɛ́ɛ mʋ obuwa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Mʋ́ʋ́ Owíe Agripa lɛ́bláa Festo ɔbɛ́ɛ, “Tɛkɩ nɩ́ oyin ánfɩ mɛ́blɩ́ ɔbɛ́ɛ, Roma owíe dɛhɛn kóún ogyíi mʋ asʋ́n á, tɛkɩ fɛ́talɩ́ sí mʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Brɛ́á bɛblɩ́ alɩ tá á, bɛkɩtá agywɩɩn bɛɛ, abɔ́tsʋn ɔpʋsʋ yɔ́ Italia ɔmátɔ́. Bɔpʋ Paulo mʋa obu adɩpʋ́ akʋ ɛ́ wá Romafɔ ɩsá akɔpʋ́ ɔhandɛ ɔkʋá bʋtɛtɩ́ mʋ Yulio ɩbɩtɔ. Ɔhandɛ anfɩ bʋ Roma Owíe Dɛhɛn Augusto ɩsá akɔpʋ́ ɔpasuatɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Anɩlówie ntsusʋ-yibi kʋá itsú Adramitio fʋ́n, ɩyɔ́ ɔpʋ ɔnɔ́ awúluá ɩbʋ Asia ɔmátɔ́. Makedoniayin Aristarko, otsú Tesalonika amʋ ɛ́ bʋ anɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɔyɩ kɛhɛ a, anɩlɛ́lɩɩ́ Sidon ɔpʋ ɔnɔ́. Ɩsá akɔpʋ́ ɔhandɛ Yulio lówun Paulo nwɛ, ɔlɛha mʋ ɔlɔyɔ mʋ aba wá, mɛ́nɩ bɛ́ha mʋ atɔ́á ibéhián mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Anɩlɔ́kʋsʋ́ tsú ɩnʋ, afú lefia anɩ ɔpʋ amʋsʋ. Mʋ́ʋ́ anɩlɔ́yɔtsʋn Kipro ɔsʋlʋ́ʋ awunso fʋ́n, tsúfɛ́ afú ámʋ mɛdɛ́tsʋ́ʋn ɩnʋ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Anɩlɔ́tsʋn ɔpʋsʋ yɔ́tsʋn Kilikia pʋ́ Pamfilia fʋ́nsʋ́ yówie Likia ɔsʋlʋ́sʋ, Mira wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɩsá akɔpʋ́ ɔhandɛ amʋ lówun ntsusʋ-yibi kʋá itsú Aleksandria wúlutɔ ɩyɔ́ Italia ɔmátɔ́, ɔlɛlɛ anɩ wá mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Anɩdɩ́n ɔpʋ amʋsʋ pʋtɔɔ. Mʋ́ sʋ anɩlégyí nkɛ tsɔtsɔɔtsɔ ɔkpatɔ. Ilepian anɩ asa anɩlówie Knido. Afú ámʋ mɛ́ha anɩ ɔkpa. Mʋ́ sʋ anɩlɔ́pʋ yɔ́tsʋn mantáa Kreta ɔmá. Ɩnʋ á, anɩlɔ́pʋkplɩ́ tsʋn Salmone wúlu ɔsaasɩ́ fʋ́n. Tsúfɛ́ afú mɛdɛ́tsʋ́ʋn ɩnʋ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ɩ́nɩá anɩlɔ́tsʋn ɔpʋ ɔnɔ́-ɔnɔ́ kʋ́ráá ó á, ilepian anɩ asa anɩlóbowie ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ “Otsubúnɔ Wankláán,” ɩbʋ mantáa Lasea wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nkɛ tsɔtsɔɔtsɔ lɔ́bɔtsʋn, nkɛá bʋtɔpʋ́klɩ́ ɔnɔ́ kʋ́lɩ́ lakpansikíé ɛ́ ɩlɔtsʋn. Nkɛ ámʋtɔ ɛ́ á, ɔpʋ amʋ ɩdɛda. Mʋ́ sʋ mʋ́sʋ́ tsʋn lɔwa ifú. Ɩ́nɩ sʋ Paulo lɔ́tɔɩ́ kplá amʋ́ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mɩ́ awíé, nawun ánɩ́ nɩ́ anɩmɛ́kɩ wankláán anɩ ɔkpa ánfɩ natɩ́tɔ́ a, abɔ́hʋlɩ́ɩ atɔ́ tsɔtsɔɔtsɔ. Megyí atɔ́ pʋ́ ntsusʋ-yibi ámʋ wʋlɛ, anɩ onutónutó ɛ́ abésin mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Támɛ ɩsá akɔpʋ́ ɔhandɛ amʋ lɔ́hɔ ntsusʋ-yibi ámʋtɔ ɔhandɛ pʋ́ mʋ wie asʋ́n sí Paulo. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɩ́nɩá otsubúnɔ ɩnʋ ɩma alɛá abétsiá ɩnʋ nyankpʋtswíebɩ sʋ á, amʋ́tɔ́ ahá tsɔtsɔɔtsɔ bɛblɩ́ bɛɛ abɛ́natɩ́ ɩnʋ. Amʋ́ ansɩ́ dɩn ánɩ́ abóyówie Foinike, igyi Kreta otsubúnɔ, ɩbʋ owí ɔkplɩ́wíékpá fʋ́n, tsíá ɩnʋ nyankpʋtswíebɩ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ɩnʋ afú kʋá itsú gyɔpɩsʋ lɔ́wa tsʋ́ʋn brɛʋʋ bɩ. Ɩ́nɩ sʋ ahá ámʋtɔ akʋ bosusúu ánɩ́ amʋ́ agywɩɩn ámʋ bɛ́kanáa. Mʋ sʋ bɛlatsú símpiá ɩtɛhá ntsusʋ-yibi tɛlɩ́ɩ́ tsukʋlɛ wá ntsusʋ-yibi ámʋtɔ, bɔpʋtsʋn Kreta ɔpʋ ɔnɔ́-ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Támɛ ɩmɔwa ɔpá kʋkʋ afú kpɔnkpɔntɩ kʋ lɔ́kʋsʋ́ tsú Kreta ɩfʋ́nsʋ́. Afú ámʋ dá gyí “Bɩnasʋ-owí-ɔdalɩkpa-afú.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Afú ámʋ lébefia anɩ. Ɩ́nɩá anɩmɛ́talɩ́ sánkɩ́a ntsusʋ-yibi ámʋ sʋ á, anɩlési ɩwɩ há afú ámʋ, ɩlɔpʋ ntsusʋ-yibi ámʋ nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ɩlɔpʋ mʋ́ srɩ́ yɔ́tsʋn mantáa ɔpʋ nsɩnɛ́ ɔsʋlʋ́ʋ kʋá bʋtɛtɩ́ mʋ́ Kauda asɩ. Ɩlɔwa ɔnlɩn asa bɛtalɩ́ tsú ɔklʋnbi ámʋ́ʋ́ bʋtɔpʋ́lɛ́ ahá ánɩ́ bʋdɛ ntsu wie, isian ntsusʋ-yibi ámʋ ɔma amʋ wá yibi ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ɩnʋ ntsusʋ-yibi ámʋtɔ agyʋ́má ayɔpʋ́ bɛbɩtɩ́a ɔklʋnbi ámʋ wá ntsusʋ-yibi ámʋtɔ. Bɔpʋ ɔfɛ́ klɩ́ ntsusʋ-yibi ámʋ kínkíínkín, mɛ́nɩ ɩmɛ́ɛmaɩ́n. Benya ifú bɛɛ afú ámʋ ɩbɔ́tsʋan ntsusʋ-yibi ámʋ yówie Libia otsubúnɔ osublútɔ. Mʋ́ sʋ bɛlɛ tati ánɩ́ isian ntsusʋ-yibi ámʋsʋ, mɛ́nɩ ntsusʋ-yibi ámʋ bɛ́natɩ́ pʋtɔɔ. Mʋ́ óó á, afú ámʋ lɔ́tsʋan ntsusʋ-yibi ámʋ nátɩ́ ɔwʋnlɩ́nsʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mʋ́ ɔyɩ kɛhɛ a, afú ámʋ ɔnɔ́ lɛhɩɛ́ wá ɔnlɩn. Mʋ́ sʋ bɔwa amʋ́ atɔ sʋráhɛ́ lɛ wá ɔpʋtɔ bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ɔkɛ sáásɩ́ a, bɛlɛ ntsusʋ-yibi ámʋ ɩwɩ ntobí kugyíkʋá amʋ́ ɩbɩ lɛ́da wá ɔpʋ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Anɩtráa anɩmɛ́dɛ́ owí mʋ́a ntsrakpabi wúun nkɛ tsɔtsɔɔtsɔ, afú ámʋ ɔnɔ́ ɛ́ ɩtráa bʋ ɔnlɩn. Mʋ́ sʋ anɩ ansɩ́ mɛtrá dɩnká tɔtɔsʋ dʋn lowu. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nkɛ tsɔtsɔɔtsɔ lɔtsʋn, ahá ámʋ bʋtráa bʋmɛdɛ́ atɔ́ gyí. Ɩnʋ Paulo lɔ́kʋsʋ́ lɩ́ɩ́ amʋ́ fɛ́ɛ́ ansɩ́tɔ́, bláa amʋ́ ɔbɛ́ɛ, “Mɩ́ awíé, tɛkɩ nɩ́ mlɩlónu mɩ́ ɔmɛ, anɩmɛ́natɩ́ Kreta otsubúnɔ a, tɛkɩ anɩmɔ́kʋ́ befia ipian, hʋ́lɩ anɩ atɔ́ alɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Támɛ séi á, mbláa mlɩ amlɩnu. Mlɩwa klʋn, tsúfɛ́ anɩtɔ ɔkʋkʋ móowu, ntsusʋ-yibi ánfɩ wʋlɛ obéyintá. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ígye onyé á, mɩ́ Buluá ntosúm lɔ́wa mʋ ɔbɔpʋ mɩ́ wá. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ɔlɛbláa mɩ ɔbɛ́ɛ, ‘Paulo, mánya ifú. Ɩbwɛ́bwɛ́ɛ́bwɛ́ á, fɛ́lɩɩ́ Roma Owíe Dɛhɛn ansɩ́tɔ́. Bulu lawá awɩtɔlɛ há fʋ́. Mʋ́ sʋ alahɔ ahá ánfɩ fʋ́a amʋ́nyɔ mlɩná ánfɩ fɛ́ɛ́ nkpa.’ ");
INSERT INTO nkoNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Mʋ́ sʋ mɩ́ awíé, mlɩnya klʋn, tsúfɛ́ mɩ́ ansɩ́ dɩn ánɩ́ Bulu ɔbɛ́ha ɩbɛ́ba mʋ́tɔ́ fɛ́ alɩá mʋ ɔbɔpʋ labɛbláa mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Támɛ ɩbwɛ́bwɛ́ɛ́bwɛ́ á, afú ámʋ ɩbɛ́da anɩ ya ɔpʋ nsɩnɛ́ ɔsʋlʋ́ʋ kʋsʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ɛkɛ dúanasɩ onyé á, afú ámʋ bʋ mʋ́sʋ́ ɩdɛ anɩda yáa nsɩnɛ́ ɩnʋ ɔpʋá bʋ́tɛtɩ́ mʋ́ Adriasʋ. Mʋ́ ɔyɩ́nsɩnɛ́ á, ntsusʋ-yibi ámʋtɔ agyʋ́má ayɔpʋ́ bosusúu ánɩ́ anɩlatá ɔsʋlʋ́ʋ tʋ tá. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mʋ́ sʋ bɔpʋ ɔfɛ́ kápʋ́ ɔpʋ amʋ oklú kɩ. Benya ayabi lafakʋlɛ adʋanyɔ (120). Brɛ́ kpalobí ɔma bɛtrá kapʋ́ mʋ́ kɩ a, benya ayabi adukwebá (90). ");
INSERT INTO nkoNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ifú lɛkɩtá ntsusʋ-yibitɔ agyʋ́má ayɔpʋ́ ámʋ ánɩ́ abɔ́dʋ abʋtásʋ́. Mʋ́ sʋ bɛda asímpi ánɩ́ bʋtɔpʋ́kɩ́tá ntsusʋ-yibi lɩ́ɩ́ ana kɛ́kɛ́ síán mʋ́ ɔma, sí mʋ́ wá ɔpʋ amʋtɔ. Bokokóli Bulu bɛɛ ɔyɩ́ ɩkɛ́ɛ amʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Agyʋ́má ayɔpʋ́ amʋ akʋ bekleá bɛ́srɩ́ dalɩ ntsusʋ-yibi ámʋtɔ. Mʋ́ sʋ bɛkɩ ansɩ́ lɛ́ ɔklʋn kusubi ámʋ dɩ́nká ɔpʋ amʋsʋ hɩ́ɛ́ɛ́, fɛ́ símpi ámʋ bʋdɛpʋsíán ɔklʋn ámʋ ɔnɔ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Támɛ Paulo lɛ́bláa ɩsá akɔpʋ́ ámʋ pʋ́ amʋ́ ɔhandɛ ɔbɛ́ɛ, “Nɩ́ ntsusʋ-yibi ámʋtɔ agyʋ́má ayɔpʋ́ bʋmetsiá mʋ́tɔ́ á, mlɩméenya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Mʋ́ sʋ ɩsá akɔpʋ́ amʋ bɛka ɔklʋn kusubi ámʋ ɔfɛ́ tɩn, há afú lɔtsʋan mʋ́ nátɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ɔyɩ́ ɩbá bɛkɛ a, Paulo lóbwií ɩpa há amʋ́ fɛ́ɛ́ ɔbɛ́ɛ, bʋgyíi atɔ́. Ɔlɛblɩ́ ɔbɛ́ɛ, “Kwasieda anyɔ sɔ́ɔ́n nɩ́, atogyihɛ mɛdɩnká mlɩ ɔwɔ́lɩ. Mlɩmɔ́kʋ́gyi tɔtɔɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nobwíí ɩpa há mlɩ, mlɩgyi atɔ́ ngya, mɛ́nɩ mlɩmóowu. Mlɩtɔ ɔkʋkʋ nwunsʋ-imi kʋlɛ kʋ́ráá mɔ́ɔfwɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paulo lɔ́tɔɩ́ tá á, ɔlɛlɛ bodobodo ipín, dá Bulu ɩpán amʋ́ fɛ́ɛ́ ansɩ́tɔ́, ɔlɛmaɩ́n kʋ wá gyí bɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ɩnʋ anɩtɔ okugyíɔkʋ lɔ́wa klʋn gyi atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Anɩ ahá lafanyɔ aduesienɔ́-sie (276) bʋ ntsusʋ-yibi ámʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Brɛ́á amʋ́ fɛ́ɛ́ begyi atɔ́ alɩá bɛ́talɩ́ á, bɛlɛ ayó ámʋ́ʋ́ ɩbʋ ntsusʋ-yibi ámʋtɔ ámʋ fɛ́ɛ́ wá ɔpʋtɔ, há ntsusʋ-yibi ámʋ lɛta odwin. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Brɛ́á ɔyɩ́ dɛkɛ́ a, agyʋ́má ayɔpʋ́ ámʋ bowun ánɩ́ ɔpʋ amʋ bámbi lowie ɔsʋlʋ́ʋ kʋsʋ, támɛ bʋmɛbɩ otsubúnɔ oduá igyi. Ɩnʋ bɔbwɛ agywɩɩn bɛɛ bɛ́kan ntsusʋ-yibi ámʋ ya ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mʋ́ sʋ bɛkakáa símpi ámʋ tɩntɩn wa ɔpʋtɔ. Bɛsankɩ́ ntsusʋ-yibi ámʋ mpaɩ ɛ́. Mʋ́ʋ́ botsu tati yílé ámʋ́ʋ́ isian ntsusʋ-yibi ámʋ ansɩ́tɔ́ ámʋ fʋ́á, fía afú ámʋ, bɔpʋ bɔyɔ́ ɔpʋ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Támɛ ntsusʋ-yibi ámʋ lɔyɔ́dʋ ŋɛsɩsʋ, sin ɩnʋ, ɔpʋ amʋ lɛda wʋ́lɩ́ ɔklʋn amʋ ɔma máɩ́n-máɩ́n mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ɩsá akɔpʋ́ ámʋ bɔbwɛ agywɩɩn bɛɛ bɔ́mɔ obu adɩpʋ́ ámʋ fɛ́ɛ́, mɛ́nɩ ɔkʋkʋ mɛ́ɛpɩtɩ́ dalɩ, srɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Támɛ amʋ́ ɔhandɛ léklé ánɩ́ ɔbɔ́hɔ Paulo nkpa. Mʋ́ sʋ ɔmɛha amʋ́ ɔkpa ánɩ́ bʋmɔ́ɔ obu adɩpʋ́ ámʋ. Támɛ ɔlɛbláa amʋ́ ɔbɛ́ɛ, ɔhagyíɔha ánɩ́ ɔbɛ́talɩ́ á, otúu wie ɔpʋ amʋtɔ, ɔpɩtɩ dalɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ɔma a, ɔlɛha atráhɛ amʋ ɛ́ bɔdʋ dɩ́nká ntsusʋ-yibi ámʋ afʋnsʋ yówie ogbémgbesʋ. Amʋ́ fɛ́ɛ́ begyi mbla ámʋsʋ, bɔyɔ ogbémgbesʋ ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Anɩ fɛ́ɛ́ anɩlɛ́dɩnká ogbémgbe amʋsʋ. Ɔma asa anɩlɛ́bɩ ánɩ́ ɔpʋ nsɩnɛ́ ɔsʋlʋ́ʋ kʋá bʋtɛtɩ́ mʋ́ Malta nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nyankpʋ détswíe, sʋ atsalɩ bʋ ɩnʋ. Támɛ ɩnʋ atsiápʋ́ amʋ begyi anɩ bʋalɛ dʋ́dá ogyá ɔpʋ ɔnɔ́ ɩnʋ há anɩ, anɩ fɛ́ɛ́ anɩlétsiá mʋ́ asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo lɛ́kpa ngyayibí ɔbɛ́ɛ amʋpʋwa ogyá ámʋtɔ. Sáa ɩbɛ bʋ mʋ́tɔ́. Ogyá ámʋ okunkúu sʋ ɩbɛ ámʋ lɔ́tswɩ yi Paulo ɔbɩwɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Brɛ́á ɩnʋ atsiápʋ́ amʋ bowun ánɩ́ ɩwɔ ámʋ yí mʋ a, bɛbláa aba bɛɛ, “Ahá ɔmɔpʋ́ oyin ánfɩ gyí. Ɩbʋ mʋ́tɔ́ ánɩ́ aladálɩ ɔpʋ amʋtɔ, támɛ anɩ ɔkpɩ ámʋ́ʋ́ ɔtɛbɩ́tɩ́ ɩsʋ ámʋ médékle ɔbɛ́ɛ otsía nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ɩnʋ Paulo lɔ́wʋnáa ɩbɩ, ɩwɔ ámʋ lɛ́kpa wíé ogyá, támɛ tɔtɔ mɔ́bwɛ Paulo. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Amʋ́ fɛ́ɛ́ besi bʋlɩɩ́ bʋdɛkɩ́ɩ. Bʋkɩ bɛɛ Paulo obópunyá, ntɛ́ɛ ɔbɛ́tɩn wu. Támɛ brɛ́á bɛlɩɩ́ wá ɔpá tɔtɔ mɛ́ba a, bɛladámlí amʋ́ agywɩɩn blɩ́ bɛɛ, “Ɔkpɩ ɔkʋ ɔhá ánfɩ gyí.” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ɔhandɛ ɔkʋ bʋ ɔsʋlʋ́ʋ kʋ ɔpʋ nsɩnɛ́ ɩnʋ. Mʋ dá gyí Publio. Ɔlɔhɔ anɩ atúu, kpá anɩ ya mʋ wóyítɔ́, anɩlétsiá mʋ wá nkɛnsá kɛ́kɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Alɩ brɛ́ ámʋtɔ á, owísó lakɩ́tá ɔhandɛ amʋ mʋ sɩ, mʋ ɩwɩtɔ latú; ɔda. Paulo lɛ́yɛkɩ mʋ, ɔlɔpʋ ɩbɩ dɩ́nká mʋsʋ bɔ́ mpáɩ há mʋ, ɩwɩ lɔwa mʋ ɔnlɩn. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Mʋ́ ɔma a, bɔpʋ alɔpʋá bʋbʋ ɔsʋlʋ́ʋ amʋsʋ fɛ́ɛ́ ba, Paulo lɛ́tsa amʋ́ ɩlɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Anɩlétsiá ɩnʋ tsra asa, ɩnʋfɔ ámʋ bɔwa anɩ numnyam, kíé anɩ atɔ́ tsɔtsɔɔtsɔ. Brɛ́á anɩdɛ́natɩ́ á, bɔpʋ atɔ́á ibéhián anɩ ɔkpatɔ fɛ́ɛ́ sí anɩ ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Anɩlɔ́yɔ ɔpʋ ɔnɔ́ yótsu ntsusʋ-yibi kʋá ɩlatsíá ɩnʋ nyankpʋtswíebɩ amʋ fɛ́ɛ́. Itsú Aleksandria wúlutɔ. Besré atabí akʋá bʋgyi ɩkpɩ yi ntsusʋ-yibi ámʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Anɩlɛ́yɛlɩɩ́ ɔpʋ nsɩnɛ́ ɔsʋlʋ́ʋ kʋ otsubúnɔ, bʋtɛtɩ́ mʋ́ Sirakus, anɩlétsiá ɩnʋ nkɛnsá. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tsú ɩnʋ á, anɩlóbomlí tsʋn bowie wúlu yílé kʋá bʋtɛtɩ́ mʋ́ Regiosʋ. Mʋ́ ɔyɩ kɛhɛ a, afú kʋ lɔ́wa tsʋ́ʋn bɩ tsu ayasɩ fʋ́n. Nkenyɔ́ ɔma a, anɩlóyowie otsubúnɔ kʋá bʋtɛtɩ́ mʋ́ Puteoli. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Anɩléfía ahógyipʋ akʋ ɩnʋ. Bokokóli anɩ bɛɛ, atsía amʋ́ wá nkensíénɔ́. Anɩlɔ́kʋsʋ́ tsú ɩnʋ á, anɩlɔ́yɔ Roma wúlutɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Apíó ánɩ́ bʋbʋ Roma wúlutɔ bonu ánɩ́ abá. Mʋ́ sʋ amʋ́tɔ́ akʋ bɛba ibíá ogyíkpá, bʋtɛtɩ́ ɩnʋ Apia. Akʋ ɛ́ bɛba ɔtɩnɛkʋá bʋtɛtɩ́ ɩnʋ Afɔɔ́ Ɔswɩɩ́kpá Asa, ɩbʋ ɔkpatɔ befia anɩ. Brɛ́á Paulo lówun amʋ́ á, mʋ ansɩ́ legyi, ɔlɛda Bulu ɩpán. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Brɛ́á anɩlóyowie Roma wúlutɔ á, Roma aban lɛ́ha Paulo ɔkpa ánɩ́ ɔbɛ́talɩ́ yétsiá ɔtɩ́nɛ́á odeklé, támɛ ɩsá ɔkɔpʋ́ ɔkʋ obógyo mʋ ɩwɩ brégyíbrɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ɛkɛ sáásɩ́ a, Paulo lɛ́tɩ Yudafɔ ahandɛá bʋbʋ ɩnʋ fɛ́ɛ́ fia. Mʋ́ʋ́ ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Mɩ́ apíó, ɩbʋ mʋ́tɔ́á mmɔpʋ lalahɛ kʋkʋʋkʋ gyi mɩ́ ɔmátɔ́fɔ, mmeyintá anɩ anáin amándɩ́ɛ́ kʋkʋ ɛ́. Támɛ anɩ ahandɛ ánɩ́ bʋbʋ Yerusalem bɛkɩtá mɩ́ ya Romafɔ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bɔyɔ mɩ́ asʋ́ntɔ́ á, tɛkɩ bekleá bési mɩ́, tsúfɛ́ bomowun tsitsa kʋkʋ mɩ́ ɩwɩ asa bɛɛ bʋmɔ́ɔ mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Támɛ Yudafɔ ámʋ bʋmotsulá ánɩ́ bʋsíi mɩ. Amʋ́ bwɛhɛ́ sʋ nɔkʋlɩ́ ɔkpa mbɛ́ɛ, Roma Owíe Dɛhɛn onutó ogyíi mɩ́ asʋ́n. Megyí bɛɛ mbʋ mɩ́ ɔmá ɩwɩ asʋansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mʋ́ sʋ natɩ́ mlɩ fia nɩ. Tsúfɛ́ ɔhá ámʋ́ʋ́ Israelfɔ bʋdɛ mʋ ɔkpa kɩ́ɩ amʋ sʋ́ nda ɩkan anfɩtɔ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Amʋ́ ɛ́ bɛbláa Paulo bɛɛ, “Anɩmɔ́kʋ́hɔ ɔwʋlʋ́ kʋkʋ tsú Yudea ɔmátɔ́ tsú fʋ́ ɩwɩ. Anɩ apíó Yudafɔ ámʋtɔ ɔkʋkʋ ɛ́ mɔ́kʋ́tsú ɩnʋ bɛbláa anɩ asʋn laláhɛ kʋkʋ tsú fʋ́ ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Támɛ ha anɩ abɩ fʋ́ agywɩɩn. Tsúfɛ́ anɩyin ánɩ́ ahá bʋtɛblɩ́ asʋn laláhɛ tsú Bulusúm ɔpasua ánfɩ fʋ́bʋ mʋ́tɔ́ ánfɩ ɩwɩ ɔtɩ́nɛgyíɔtɩ́nɛ́.” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Mʋ́ sʋ mʋa Yudafɔ ámʋ bɛhɩɛ ɛkɛá béfia. Ɛkɛ ámʋ lɔ́fʋn a, Yudafɔ tsɔtsɔɔtsɔ bɛba befia Paulo wóyí ɩnʋ. Paulo lɔ́tɔɩ́ kplá amʋ́. Ɔlɔpʋ Mose Mbla pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋn wanlɩ́nhɛ́ lɛ́ Bulu iwíegyí ámʋ ɩwɩ asʋ́ntɔ́ súná amʋ́ tsú nyankɩ pɔn owí. Ɔlɔbɔ mbɔ́dɩ́ ánɩ́ ɔbɛ́damlí amʋ́ abʋhɔ Yesu Kristo ɩwɩ asʋ́n ámʋsʋ gyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Amʋ́tɔ́ akʋ bohogyi, támɛ akʋ bʋmohogyi. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Amʋ́ wʋlɛwʋlɛ amʋ ɔnɔ́ mɔbwɛ kʋlɛ, bɔwa asʋ́n ámʋ prɩ́ɩ bɩ. Támɛ Paulo lɛ́trá bláa amʋ́ asʋn kua kʋlɛ asa bɛdasáɩ́n. Ɔlɛbláa amʋ́ ɔbɛ́ɛ, “Ɔŋɛ Wankɩ́hɛ́ lɛ́bláa mlɩ anáin ɔnɔkwalɩ amʋ tsʋn Bulu ɔnɔ́sʋ́ ɔtɔɩ́pʋ́ Yesaiasʋ. Ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Yɔ ahá ánfɩ wá afʋyɛbláa amʋ́ fɛɛ, Bónu lánú, támɛ bʋmóonu mʋ́ asɩ. Bɛ́kɩ lákɩ, támɛ bʋmɛ́ɛbɩ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tsúfɛ́ klʋntɔ bʋ amʋ́ odwin. Batílá asʋ, bun ansíbi ɛ́. Nɩ́ megyí alɩ á, tɛkɩ bówun atɔ́ bónu asʋ́n, amʋ́ agywɩɩn bóbwií. Bɛ́damlí ba mɩ́ wá, nɛ́tsa amʋ́ ɩlɔ.’ ” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Paulo lɔ́mɔ mʋ asʋ́n ɔnɔ́ ɔbɛ́ɛ, “Mʋ́ sʋ ndekléá mlɩbɩ́ɩ ánɩ́ Bulu nkpahɔ́ɔ asʋ́n ámʋ lawíé ahá ánɩ́ bʋmegyí Yudafɔ ɛ́ wá dodo. Amʋ́ mʋ́ bɔ́hɔ asʋ́n ámʋ.” ");
INSERT INTO nkoNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo létsiá ɩnʋ nfinyɔ kɛ́kɛ́. Oletsiá mʋ onutó obu háɩhɛtɔ. Oletsiá hɔ afɔɔ́ ánɩ́ bɛba bɛsɩnáa mʋ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ɔlɔwa klʋn dá Bulu iwíegyí ámʋ ɩwɩ asʋ́n ɔkan, olosuná anɩ Wíe Yesu Kristo ɩwɩ asʋ́n ɛ́ ahá fɛ́ɛ́ ansɩ́tɔ́. Ɔhaa métin mʋ ɔkpa.");
INSERT INTO nkoNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mɩ́ Yesu Kristo osúmbi Paulo dɛ́ ɔwʋlʋ́ ánfɩ wanlɩ́n sɩ́sɩ́ mlɩ Romafɔ. Bulu lɛ́tɩ mɩ́ ɔbɛ́ɛ, mbɔ́bwɛ mʋ sumbí ɔyɔpʋ́. Ɔlɛlɛ mɩ́ yáɩ́ ánɩ́ nɛ́da mʋ asʋn wankláán ámʋ ɔkan. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Bulu lɛ́hɩɛ asʋn wankláán ánfɩ yáɩ́ tsʋn mʋ ɔnɔ́sʋ́ atɔɩ́pʋ́sʋ dodoodo, bɔwanlɩ́n mʋ́ wá mʋ asʋn wanlɩ́nhɛ́ amʋtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Asʋn wankláán ámʋ ɩlɔtɔɩ́ tsú mʋ Bi, ogyi anɩ Wíe Yesu Kristo ɩwɩ. Anyánkpʋ́sa ɔkpasʋ á, ɔlɛlɩn Owíe Dawid abusuantɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Bulu lɛ́lɛ súná ánɩ́ lɛ́lɛ́ mʋ Bi nɩ́. Ɔlɔtsʋn Ɔŋɛ Wankɩ́hɛ́ túmitɔ kʋ́sʋ́a mʋ tsú afúlitɔ. Mʋgyí anɩ Wíe Yesu Kristo. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ɩna mʋsʋ Bulu lawá awɩtɔlɛ lɛ́ mɩ́ mʋ sumbí ɔyɔpʋ́, mɛ́nɩ nɛ́kpa ɔmá bámbásʋ́fɔ bɔ́hɔ mʋ gyi, nú mʋ ɔmɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mlɩ Romafɔ ánfɩ Bulu latɩ́ ɔbɛ́ɛ, mlɩbɔ́bwɛ Yesu Kristo klɛ́ ɛ́ mlɩbʋ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ɩ́nɩ sʋ mɩ́ Paulo ndɛ ɔwʋlʋ́ ánfɩ wanlɩ́n sɩ́sɩ́ mlɩá mlɩbʋ Roma fɛ́ɛ́. Bulu lahɩ́ɛ́ dwɛ́ mlɩ, tɩ́ mlɩ, pʋ́ mlɩ bwɛ́ mʋ ahá. Ndɛ anɩ Sɩ́ Bulu mʋa anɩ Wíe Yesu Kristo kokóli mbɛ́ɛ, bʋgyíi mlɩ bʋalɛ, abʋha mlɩ iwilwii. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Gyankpapʋ a, nna Yesu Kristosʋ ndɛ mɩ́ Bulu ɩpán da mlɩtɔ okugyíɔkʋ nwunsʋ. Tsúfɛ́ mlɩ Kristo hógyi sʋ mlɩ dá dɛ ɔyɩ́tɔ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Napʋ́ mɩ́ klʋn fɛ́ɛ́ ndɛ Bulu súm tsʋn mʋ Bi Yesu ɩwɩ asʋn wankláán ɔkan ámʋ́ʋ́ ndɛda ámʋsʋ. Obégyi mɩ adánsɩɛ ánɩ́ ntɛkáɩ́n mlɩsʋ brégyíbrɛ́á ndɛ mpáɩ bɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ntetsíá kokóli mʋ ekekegyíɛkɛ mbɛ́ɛ, otsúla finki ɔkpa ha mɩ, antalɩ bɛsɩnáa mlɩ nkɛ ánfɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Tsúfɛ́ ɩdɩn mɩ́ ɔwɔ́lɩá mɩ́a mlɩnyɔ abéfia, mɛ́nɩ nɛ́bɛha mlénya Ɔŋɛ Wankɩ́hɛ́ atokiehɛ́ ánɩ́ ɩbɔ́wa mlɩ ɔwʋnlɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mʋ́á ndɛblɩ́ gyí, nɩ́ nɛbá mlɩ wá á, mɩ́ hógyi bɔ́wa mlɩ ɔwʋnlɩ́n, mlɩ klɛ́ ɛ́ ɩbɔ́wa mɩ́ ɔwʋnlɩ́n. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mɩ́ apíó, ndekléá nɛha mlɩ bɩ ánɩ́ nabwɛ́bwɛ́ɛ́bwɛ́ agywɩɩn ánɩ́ nɛ́bɛsɩnáa mlɩ, támɛ tɔkʋ dɛ mɩ́ ɔkpa tíin bɔfʋn ndɛ. Ndekléá nɛ́ba ɩnʋ bɔtɔɩ́ kplá ahá, mɛ́nɩ bɔ́hɔ Yesu gyi, fɛ́ alɩá nahá ahá bahɔ mʋ gyi ɔmá bámbátɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ɩ́nɩ gyí tɔ́á ilehián ánɩ́ nɔ́bwɛ ahá fɛ́ɛ́tɔ́ nɩ. Ilehián ánɩ́ nɔ́bwɛ mʋ́ Griikifɔ pʋ́ ɔblɩ́ɩ bámbá ablɩ́pʋ́, atɩansɩpʋ pʋ́ aha mimláhɛ fɛ́ɛ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ɩ́nɩ sʋ mɩ́ ansɩ́ lapɛ́ ánɩ́ nɛ́bláa mlɩ ahá ánɩ́ mlɩbʋ Roma wúlutɔ ɛ́ asʋn wankláán ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Bulu asʋn wankláán ámʋ ɩma mɩ́ pɛ́lɩ. Tsúfɛ́ mʋ́gyí Bulu túmi ánɩ́ ɔdɛpʋhɔ ɔhagyíɔha ánɩ́ ɔlɔhɔ Kristo gyi nkpa nɩ́. Yudafɔ gyánkpá, asa ahá ánɩ́ bʋmegyí Yudafɔ bʋbuo. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Tsúfɛ́ asʋn wankláán ámʋtɔ Bulu lɛ́lɛ alɩá ɔtɔbwɛ́ ɔha yilé ɔbwɛpʋ́ súná. Mʋ́ ɔsʋ́-asɩ fɛ́ɛ́ ɩlɩɩ́ hógyisʋ. Ɩ́nɩ Bulu asʋn wanlɩ́nhɛ́ amʋ lɛblɩ́ nɩ́. “Ɔhá ánɩ́ mʋ hógyi sʋ Bulu latsú mʋ ánɩ́ mʋ asʋ́n da ɔkpa obénya nkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Bulu lɛ́lɛ mʋ ɔblɔ́ súná tsú ɔsʋ́sʋ́. Olenya ɔblɔ́ ahá ánɩ́ bʋtamanyá mʋ ifú, bʋdɛ lalahɛ bwɛ, bapʋ́ amʋ́ owuntɔlɩn bʋdɛ Bulu asʋ́n ánɩ́ igyi ɔnɔkwalɩ ɔkpa tíin. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Bulu ɔbɛ́bɩtɩ́ amʋ́ ɩsʋ. Tsúfɛ́ tɔ́á ilehián ánɩ́ bɛ́bɩ tsú Bulu ɩwɩ ɩda amʋ́ ansɩ́tɔ́ dodo. Bulu onutó lɛ́lɛ mʋ́ ɔwan súná ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ɩbʋ mʋ́tɔ́ ánɩ́ ɔhaa tamawun Bulu túmiá ɩtamatá pʋ́ alɩá ogyi. Támɛ tsú brɛ́á Bulu lɔ́bwɛ ɔyɩ́ ɔpá á, Bulu tsiátɔ́ meŋaín. Tsúfɛ́ mʋ atɔ bwɛhɛ́ lɛlɛ mʋ́ súná wankláán ánɩ́ ahá bɛ́talɩ́ wun mʋ́, pʋ́bɩ́ mʋ. Ɩ́nɩ sʋ ɔhaa má ɔnɔ́ kʋkʋ lɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bʋyin Bulu, támɛ bʋmɔwa mʋ numnyam ánɩ́ iletsiá mʋ, bʋmɔpʋ ɩpán kʋkʋ ɛ́ há mʋ. Mboún tɔ́á ɩma asɩ bʋ́tɔgywɩ́ɩn tsu Bulu ɩwɩ. Bʋtamatráa nu mʋ asʋ́n ámʋ asɩ. Basin oklúntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bʋtɛkɩ amʋ́ ɩwɩ bɛɛ bɛtɩn ansɩ́, támɛ bemimláa. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Basí Bulu ɔkɩankpapʋ amʋ tswɩ, yɔ́ bʋdɛ ɩkpɩ ánɩ́ bʋma nkpa súm. Bɔpwɛ amʋ́, ntɛ́ɛ sré amʋ́ fɛ́ nyankpʋsa ánɩ́ otowú, ntɛ́ɛ mbubwi, ntɛ́ɛ mbwɩ pʋ́ awɔ akʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ɩ́nɩ sʋ Bulu ladámlí ɔma há amʋ́, basí bʋdɛ atɔ laláhɛá bʋdeklé tsu amʋ́ klʋntɔ bwɛ, amʋ́a amʋ́ aba bʋdɛ ɩwɩ sʋpáa. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bʋtamatráa hɔ Bulu ɔnɔkwalɩ amʋsʋ gyi. Asʋ́n ánɩ́ ɩma mʋ́tɔ́ mboún bʋdehógyi. Ɩ́nɩ sʋ bayɔ́ bʋdɛ Bulu atɔ bwɛhɛ́ mboún súm, sí atɔ́ fɛ́ɛ́ Ɔbwɛpʋ́ ámʋ onutó. Kanfʋ́ letsiá mʋ brɛ́ fɛ́ɛ́! Amen. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Amʋ́ bwɛhɛ́ ánfɩ sʋ Bulu lɛ́damlí ɔma há amʋ́, bʋna bʋdɛ hakpanla bwɛ. Amʋ́ atsɩ kʋ́ráá besi ayin wá dɩ, fɛ́ alɩá ɩda yaɩ́, amʋ́ wʋlɛwʋlɛ bʋda aba wá. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Alɩ kɛ́n ayin ɛ́ besi atsɩ wá dɩ fɛ́ alɩá bʋtɔbwɛ́ mʋ́ yáɩ́, bʋda aba wá nɩ́. Hakpanla anfɩ bwɛ sʋ Bulu lɛ́bɩtɩ́ amʋ́ ɩsʋ ánɩ́ lɛkanáa ha amʋ́, bʋdɛ mʋ́ wúun nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ɩ́nɩá bakíná Bulu bɩ sʋ á, Bulu ladámlí ɔma há amʋ́, bʋdɛ asʋkpan susúu, bʋdɛ tɔ́á ɩma alɛá ɔha ɔbɔ́bwɛ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Lalahɛ sɔ́ɔ́n bʋ amʋ́tɔ́. Ɩkʋ gyí; lakpanbwɛ, opotsuawa, olu, ɔnsɩ́pɛ, ahámɔ, mblɩ́kpɛ́ɛ, ahámlɛ́, agywɩɩn laláhɛ bwɛ pʋ́ ahátsíi. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ahá ɔnɔ́tɩn, Bulu asʋ́nkiná, atɔ́mábú, ɩwɩtsú, ɩwɩ adábi da. Lakpan ɔkpagyáa, akwɩɩ́pʋ́sʋ kʋsʋ́lɩ́ɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bʋtamagywɩ́ɩn, bʋtamagyi amʋ́ asʋn blɩ́hɛ́sʋ. Bʋtamadwɛ́ ahá, bʋtamawun ahá nwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ɩ́nɩá bʋyin ánɩ́ Bulu mbla ámʋ losuná ánɩ́ ɔhá ánɩ́ otsíá atsiábi anfɩ odu obówu óó á, megyí ɩ́nɩ ánfɩ nkʋlɛ bʋdɛbwɛ. Bʋtráa bʋdɛ lalahɛ abwɛpʋ́ ɛ́ atɛtɔ-ɔnlɩn wa dɩ́nká mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ɩ́nɩ sʋ fʋ́á fʋtsie fʋdɛ fʋ́ aba ɩlá lɛ, fʋma ɔnɔ́ kʋkʋ lɛ́ Bulu ansɩ́tɔ́. Tsúfɛ́ fʋdɛ akʋ ɩlá lɛ, támɛ fʋdɛ mʋ́ odu kɛ́n bwɛ. Mʋ́ sʋ nɩ́ fʋdɛ amʋ́ ɩlá lɛ á, ɩwɩ pɔ́n fʋ́dɛha. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Anɩyin ánɩ́ Bulu ɔbɛ́ha ahá ánɩ́ bʋdɛ ɩ́nɩ odu bwɛ ɩpɔ́n. Anɩyin ɛ́ ánɩ́ mʋ asʋ́n da ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Mʋ́ sʋ nɩ́ fʋ́dɛ ahá ɩlá lɛ lakpan ánɩ́ fʋ́ onutó fʋ́dɛbwɛ sʋ á, bɩ ánɩ́ Bulu ɛ́ ɔbɛ́ha fʋ́ ɩpɔ́n. Fʋmɛ́ɛtalɩ́ kɔlɩ dalɩ mʋ ɩbɩ. Ntɛ́ɛ fʋmeyín alɩ? ");
INSERT INTO nkoNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Bulu lalɛ́ mʋ yilé pʋ́ mʋ awɩtɔlɛ ɔwan súná fʋ́, alanyá klʋn há fʋ́, támɛ fʋmobu mʋ. Ntɛ́ɛ fʋmeyín ánɩ́ alɩá fɛ́damlí klʋntɔ yínkí ba mʋ wá sʋ alalɛ́ mʋ awɩtɔlɛ súná fʋ́? ");
INSERT INTO nkoNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Támɛ klʋntɔ bʋ fʋ odwin, asʋtɔ bʋ fʋ ɔnlɩn. Mʋ́ sʋ ɩsʋtɔbɩtɩ́ ánɩ́ ɩda gyo fʋ́ ɛkɛá Bulu Ɔnɔkwalɩpʋ obégyi asʋ́n ɩtráa démoní tsɩ́a. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Bulu ɔbɛ́ka ɔhagyíɔha ɩkɔ mʋ bwɛhɛ́ ɔnɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Akʋ bapʋ́ ansɩ́ dɩ́nká ánɩ́ bénya numnyam, ɩdayilé pʋ́ nkpa ánɩ́ ɩtamatá. Mʋ́ sʋ banyá klʋn bʋdɛ yilé bwɛ ekekegyíɛkɛ. Amʋ́ Bulu ɔbɛ́ha nkpa ánɩ́ ɩtamatá nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Támɛ akʋá bʋbʋ ɔnsɩ́pɛ, bakíná ɔnɔkwalɩ amʋ pʋ́ yilébwɛ, bʋbuo lalahɛ mʋ́ á, Bulu ɔbɔ́pʋ ɔblɔ́ gyi amʋ́ asʋ́n, bɩ́tɩ́ amʋ́ ɩsʋ wankláán. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Asʋn wunhɛ mʋ́a ɩwɩɔsɩn bɛ́ba lalahɛ abwɛpʋ́ fɛ́ɛ́sʋ́. Ibégyankpá tʋ́ Yudafɔ, asa ɩbɔ́tʋ ahá ánɩ́ bʋmegyí Yudafɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Támɛ Bulu ɔbɔ́wa yilé abwɛpʋ́ numnyam, há amʋ́ iwilwii, trá ha amʋ́ ayɛ. Obégyankpá há Yudafɔ, asa ɩbɔ́tʋ ahá ánɩ́ bʋmegyí Yudafɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tsúfɛ́ Bulu tegyi asʋ́n ɔnɔkwalɩsʋ, ɔtamakɩ ɔhaa ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ahá ámʋ́ʋ́ bʋmeyín Mose Mbla ámʋ, bʋdɛ lakpan bwɛ ámʋ óó bɔ́fwɩ. Támɛ Bulu mɔ́ɔpʋ mbla ámʋ gyi amʋ́ asʋ́n. Ahá ámʋ́ʋ́ bʋyin mbla ámʋ asa bʋdɛ lakpan bwɛ ámʋ mʋ́ á, Bulu ɔbɛ́lɩɩ́ mbla ámʋsʋ há amʋ́ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Tsúfɛ́ megyí ahá ánɩ́ bʋyin Mose Mbla ámʋ asʋ́n da ɔkpa Bulu ansɩ́tɔ́. Mboún ahá ánɩ́ bʋtegyi mʋ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɩbʋ mʋ́tɔ́á ahá ámʋ́ʋ́ bʋmegyí Yudafɔ bʋmeyín Mose Mbla ámʋ. Támɛ nɩ́ amʋ́ onutó bʋdɛ mbla ámʋsʋ gyí a, bʋdesuná ánɩ́ bʋyin yilé mʋ́a lalahɛ amʋ́ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Amʋ́ bwɛhɛ́ ánfɩ desuná ánɩ́ Bulu lɔ́wanlɩ́n mbla ámʋ dɩ́nká amʋ́ klʋnsʋ. Amʋ́ klʋn dɛ adánsɩɛ gyí ánɩ́ lɛ́lɛ́ bʋyin mʋ́. Tsúfɛ́ brɛ́ kʋtɔ á, amʋ́ agywɩɩn tɛhá amʋ́ ɩpɔ́n, brɛ́ kʋtɔ ɛ́ á, ɩtɛhá amʋ́ asʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Alɩ kɛ́n ɩbɛ́ba ɛkɛ ámʋ́ʋ́ Bulu ɔbɔ́tsʋn Yesu Kristosʋ gyi tɔ́á ahá babwɛ́ ŋáintɔ ɩwɩ asʋ́n nɩ́. Alɩ́ Kristo ɩwɩ asʋn wankláán ámʋ́ʋ́ ndɛ mʋ́ ɔkan da ámʋ idesuná nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Fʋ́ fɛɛ Yudayin fʋgyi, fʋ́ ansɩ́ dɩn Mose Mbla ámʋsʋ, fʋ́dɛpʋ ɩbɩ sí kántɔ́ fɛɛ Bulu mʋ bi fʋ́gyi. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Fʋyin Bulu apɛ́, tsúfɛ́ fakásɩ́ Mose Mbla ámʋ. Mʋ́ sʋ fʋyin tɔ́á ɩbʋ alɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Fʋtɛkɩ fʋ́ ɩwɩ ansibi abwiepʋ́ ɔkpapʋ́, fʋ́gyi fɛ́ ɔkandɩ́ɛ há ahá ánɩ́ bʋmeyín Bulu, basin oklúntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Fʋ́ fɛɛ fʋgyi aha mimláhɛ ansɩ́ ɔtɩ́npʋ. Fɛ́talɩ́ súná ahá ánɩ́ bʋmeyín ɔlala tɔ́á ɩbʋ alɛ́. Tsúfɛ́ fatsúlá fɛɛ Mose Mbla ámʋ sʋ fabɩ́ tógyítɔ́, fabɩ́ ɔnɔkwalɩ kugyíkʋ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Támɛ ɩ́nɩá fʋ́dɛ ahá yilé suná á, ntogyi sʋ fʋmóosuná fʋ́ ɩwɩ mʋ́? Fʋdɛ ɔkan da bláa ahá fɛɛ bʋmáwi atɔ́, támɛ fʋ́ onutó fʋdewi? ");
INSERT INTO nkoNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Fɛɛ bʋmátɔ mbʋa, támɛ fʋdɛ mbʋa tɔ? Fɛɛ bʋmásum ɩkpɩ, támɛ fʋtowí ɔkpɩasɩ atɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Fʋtotsú ɩwɩ Mose Mbla ámʋ sʋ, támɛ fʋtɛpán mʋ́sʋ́. Ɩ́nɩ sʋ fʋdɛ Bulu kpɔɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Bulu asʋn wanlɩ́nhɛ́ amʋ lɛ́blɩ́ ɔbɛ́ɛ, “Mlɩ Yudafɔ bwɛhɛ́ sʋ ahá ánɩ́ bʋmegyí Yudafɔ bʋdɛ Bulu ɩwɩ asʋn laláhɛ blɩ́.” ");
INSERT INTO nkoNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nɩ́ mlɩdɛ́ Bulu mbla ámʋsʋ gyí á, mlɩ ketétɩ́ɩn bʋ labi. Támɛ nɩ́ mlɩtamagyi mʋ́sʋ́ á, mlɩgyí fɛ́ ahá ánɩ́ bʋmɛtɩn keté. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nɩ́ ɔkʋ mɛ́tɩn keté, ɔdɛ Mose Mbla ámʋsʋ gyí a, ogyi fɛ́ keté ɔtɩ́npʋ Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mlɩ Yudafɔ mlɩyin mbla ámʋ, tsúfɛ́ bɔwanlɩ́n mʋ́ tswɩ mlɩ, bɛtɩn mlɩ keté ɛ́, támɛ mlɩtɛpán Mose Mbla ámʋsʋ. Mʋ́ sʋ ɔhá ánɩ́ ɔmɛtɩn keté kʋ́ráá, támɛ ɔdɛ mbla ámʋsʋ gyí ɔbɛ́lɛ mlɩ ɩlá. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tsúfɛ́ megyí keté ɔtɩ́npʋ gyí Yudayin onutó. Ketétɩ́ɩn onutónutó bʋ ɩnʋ. Megyí ɔyʋlʋ́sʋ ketétɩ́ɩn kɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nɩ́ ɔkʋ gyí Yudayin onutónutó á, mʋ klʋntɔ tósúná. Ketétɩ́ɩn onutó itsú klʋntɔ. Bulu Ɔŋɛ́ ámʋ tɔ́bwɛ́ mʋ́, megyí mbla ámʋ́ʋ́ bɔwanlɩ́n tswɩ amʋsʋ gyí. Ɔhá ánɩ́ Bulu Ɔŋɛ́ ámʋ ɩlɛtɩn mʋ keté á, Bulu onutó tɛ́kánfʋ́ mʋ, megyí nyankpʋsa. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mʋ́mʋ́ labi mɔmʋ Yudafɔ bʋbʋ dʋn ahá ánɩ́ bʋmegyí Yudafɔ? Ntɛ́ɛ labi mɔmʋ ketétɩ́ɩn bʋ? ");
INSERT INTO nkoNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ɩbʋ mʋ́tɔ́á labi ámʋ ɩhɩ́ɛ́ ɩtsɔ! Gyankpapʋ gyí, Bulu lɔ́pʋ mʋ klʋnsʋ asʋ́n wá Yudafɔ ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ɩbʋ mʋ́tɔ́ ánɩ́ amʋ́tɔ́ akʋ bʋmɔhɔ Bulu asʋ́n ámʋsʋ gyi. Támɛ amʋ́ tsiátɔ́ anfɩ odu ɩbɛ́talɩ́ há Bulu obési tɔ́á ɔlɛhɩɛ ánɩ́ ɔbɔ́bwɛ lóó? ");
INSERT INTO nkoNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ɛkɛkɛɛkɛ! Megyí alɩ ígyi! Nɩ́ afunupʋ ahá fɛ́ɛ́ bʋgyi óó á, Bulu mʋ́ á, ɔnɔkwalɩpʋ ogyi. Igyi fɛ́ alɩá Owíe Dawid lɛ́bláa Bulu ɔbɛ́ɛ, “Nɩ́ fɔtɔ́ɩ́ á, ahá bʋblɩ́ bɛɛ fʋ́ asʋ́n igyi ɔnɔkwalɩ. Nɩ́ begyi fʋ́ asʋ́n ɛ́ á, bʋblɩ́ bɛɛ fʋ́ asʋ́n da ɔkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nɩ́ anɩ tsiátɔ́ laláhɛ lalɛ́ Bulu tsiátɔ́ wankláán súná á, mʋ́mʋ́ nɩ́ ɔdɛ anɩ ɩsʋ bɩtɩ́ anɩ tsiátɔ́ laláhɛ sʋ á, nkálɩ abɛ́blɩ́? Abɛ́blɩ́ anɩaa, Bulu má ɔkpa bɩ́tɩ́ anɩ ɩsʋ? (Nyankpʋsa asʋn blɩ́hɛ́ ndɛblɩ́ á.) ");
INSERT INTO nkoNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ɛkɛkɛɛkɛ! Ɩma mʋ́tɔ́ alɩ. Nɩ́ Bulu asʋ́n mɛda ɔkpa á, nkálɩ obégyi ɔyɩ́tɔ́ ahá fɛ́ɛ́ asʋ́n? ");
INSERT INTO nkoNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ɔkʋ ɔbɛ́fɩtɛ́ ɔbɛ́ɛ, nɩ́ mɩ́ ɔnɔkwalɩmáwá lalɛ́ súná ánɩ́ Bulu bʋ ɔnɔkwalɩ, ɩlatsú mʋ dá fʋ́á á, mʋ́mʋ́ ntɔ sʋ́ Bulu ɔbɛ́trá ha mɩ́ pɔ́n ɔbɛ́ɛ lalahɛ ɔbwɛpʋ́ ngyi? ");
INSERT INTO nkoNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nɩ́ igyi alɩ á, mʋ́mʋ́ ntɔ sʋ́ anɩmɛ́ɛblɩ́ anɩaa, “Mlɩha abwɛ lakpan, fówun Bulu tsiátɔ́ wankláán ɩlɩn ɔwan?” Fɛ́ alɩ ámʋ́ʋ́ akʋ bʋdɛ mɩ́ ɔnɔ́ tɩn bɛɛ, nna ndɛblɩ́ ámʋ. Bulu ɔbɛ́ha amʋ́ ɩpɔ́n alɩá ɩlɛkanáa. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nkálɩ mɛɛ abɛ́blɩ́ pʋ́mɔ́ mʋ́ ɔnɔ́? Mʋ́ sʋ anɩ Yudafɔ anɩdʋn ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ lóó? Ɛkɛkɛɛkɛ! Anɩmɔ́dʋn amʋ́ ɔkpagyíɔkpasʋ. Nablɩ́ bɔtsʋn mbɛ́ɛ, ɩkʋlɛ Yudafɔ pʋ́ ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ fɛ́ɛ́ bʋgyi. Tsúfɛ́ lakpan lagyi amʋ́ fɛ́ɛ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Bulu asʋ́n lɛblɩ́ ɔbɛ́ɛ, “Ɔhaa asʋ́n mɛda ɔkpa Bulu ansɩ́tɔ́. Ɔbakʋ́lɛ kʋ́ráá mɛ́dalɩ mʋ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ɔhaa tamanú Bulu asʋ́n asɩ; ɔhaa tamadúnká Bulu ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Amʋ́ fɛ́ɛ́ badámlí ɔma há Bulu, ámʋ́ fɛ́ɛ́ bafwɩ́. Yilé ɔbwɛpʋ́ ɔkʋkʋ má ɩnʋ. Ɔbakʋ́lɛ kʋ́ráá mɛ́dalɩ mʋ́tɔ́.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Bulu asʋ́n ámʋ lɛ́trá blɩ́ ɔbɛ́ɛ, “Bʋtekle asʋkpan blɩ́. Bʋtɔpʋ́ amʋ́ ɔnɔ́ mlɛ́ ahá. Amʋ́ ɔnɔ́tɔ́ asʋn blɩ́hɛ́ tɔmɔ́ fɛ́ ɩwɔ elín.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bulu asʋ́n ámʋ lɛ́trá blɩ́ ɔbɛ́ɛ, “Ɩlwɩɩ́ pʋ́ asʋn-sɩnsɩ́n blɩ́ bʋtegyi dɩ.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ɔlɛtrá blɩ́ ɔbɛ́ɛ, “Ahámɔ ma amʋ́ ɔpá. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ɔtɩ́nɛgyíɔtɩ́nɛ́á bʋna á, bʋdɛ ahá yintá, bʋdɛ ahá ipiantɔ wa. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bʋmeyín ɔkpa ánɩ́ ɩtɔpʋ́ iwilwii ba.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bulu asʋ́n ámʋ kʋ ɛ́ lɛblɩ́ ɔbɛ́ɛ, “Bʋtamanyá Bulu ifú.” ");
INSERT INTO nkoNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Séi á, anɩyin ánɩ́ asʋ́ngyíasʋ́n ánɩ́ Mose Mbla ámʋ losuná á, ɩda ha Yudafɔ ámʋ́ʋ́ bɔpʋ mbla ámʋ há ámʋ. Mʋ́ sʋ ɔkʋkʋ méenya ɔkpa lɛ́ asʋansʋ ɔnɔ́ brɛ́á Bulu dɛ́ ahá fɛ́ɛ́ asʋ́n gyí. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Tsúfɛ́ Mose Mbla ámʋsʋ gyí mɛ́ɛtalɩ́ há ɔha ogyi asʋ Bulu ansɩ́tɔ́. Há mbla ámʋ ɩtɛhá anɩtɛbɩ́ ánɩ́ lakpan abwɛpʋ́ anɩgyí. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Séi á, Bulu lasúná ɔkpa ánɩ́ ɔtɔtsʋn mʋ́sʋ́ há ɔha asʋ. Ɩmɛná Mose Mbla ámʋsʋ gyísʋ. Támɛ Mose Mbla ámʋ pʋ́ Bulu ɔnɔ́sʋ́ atɔɩ́pʋ́ amʋ asʋn wanlɩ́nhɛ́ lɛ́blɩ́ ɔkpa ámʋ ɩwɩ asʋ́n yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ɔkpa ámʋ gyí ɔkpa ánɩ́ Bulu tɔtsʋn há ɔha asʋ mʋ ansɩ́tɔ́ nɩ́. Yesu Kristo hógyisʋ Bulu tɔtsʋn hɔ ɔhagyíɔha. Ma fʋgyi o, ma fʋmegyí o, nkʋ́nʋ fotsú o, nkʋ́nʋ fʋmotsú o, ɔhaa mɔ́tsʋn ɔtsan Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Tsúfɛ́ ahá fɛ́ɛ́ babwɛ́ lakpan. Mʋ́ sʋ bahʋ́lɩ Bulu numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Awɩtɔlɛ Bulu lawá há anɩ. Mʋ́ sʋ́ nyankpʋsa obégyi asʋ mʋ ansɩ́tɔ́ nɩ́. Awɩtɔlɛ anfɩ ɩna Kristo Yesusʋ. Mʋlɛ́ka nyankpʋsa nwunsʋ ɩkɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Anyánkpʋ́sa bʋdɛ lakpan bwɛ tsú brɛ́ ɔpá, támɛ Bulu lénya klʋn há amʋ́, ɔmɛbɩtɩ́ amʋ́ ɩsʋ. Séi á, Bulu labɔpʋ Yesu bɔ́ afɔdɩɛ, pʋ́ mʋ obugya lɛ́ anɩ ɩwɩ mbusuo, mɛ́nɩ abɔ́tsʋn mʋ hógyisʋ nyá lakpansikíé. Bulu lɔ́bwɛ mʋ́ alɩ pʋ́súná ánɩ́ mʋ asʋ́n da ɔkpa, mɛ́nɩ ibósuná nkɛ ánfɩtɔ ánɩ́ yilé ɔbwɛpʋ́ ogyi. Ototsú ahá ánɩ́ bɔhɔ Yesu gyi ánɩ́ amʋ́ asʋ́n da ɔkpa mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Séi mɛ́, tɔkʋ bʋ ɩnʋá abótsu ɩwɩ mʋ́sʋ́? Tɔtɔ má ɩnʋ. Ntogyi sʋ́ anɩmɛ́ɛtalɩ́ tsú ɩwɩ? Mose Mbla ámʋ sʋ lóó? Ó-o! Anɩ hógyi sʋ anɩmɛ́ɛtalɩ́ tsú ɩwɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Megyí atɔ wankláán ámʋ́ʋ́ Mose Mbla losuná anɩ bwɛ ámʋ sʋ anɩtegyi asʋ Bulu ansɩ́tɔ́. Ɩna Kristosʋ hógyisʋ abégyi asʋ Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Yudafɔ nkʋlɛ Bulu ógyi? Megyí ahá ánɩ́ bʋmegyí Yudafɔ mʋ́ Bulu ogyi? Ee! Amʋ́ ɛ́ amʋ́ Bulu nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bulu ɔkʋlɛ pɛ́ bʋ ɩnʋ. Mʋ́ sʋ ɩna hógyisʋ olotsulá ánɩ́ Yudafɔ asʋ́n da ɔkpa. Ɩna hógyi kɛ́nsʋ́ ɔlɔhɔ ahá ámʋ́ʋ́ bʋmegyí Yudafɔ ámʋ ɛ́ ánɩ́ amʋ́ asʋ́n da ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mʋ́ sʋ ilehián ánɩ́ abɔ́hɔ Yesu gyi, sí Mose Mbla ámʋsʋ hógyi lóó? Ɛkɛkɛɛkɛ! Megyí alɩ ígyi. Yesu hógyi tɛ́há anɩtɛkɩ́tá mbla ámʋtɔ kínkíínkín. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Séi á, amansʋ anɩ Yudafɔ abɛ́blɩ́ tsú anɩ náin Abraham ɩwɩ? Ntɔ olowun tsu Bulu aháhɔ asʋ́n ánfɩ ɩwɩ? ");
INSERT INTO nkoNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nɩ́ yilébwɛ sʋ́ Abraham légyí asʋ Bulu ansɩ́tɔ́ á, mʋ́mʋ́ ɔbʋ tɔ́á ɔbɔ́pʋtsú ɩwɩ, támɛ megyí Bulu ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nkálɩ Bulu asʋn wanlɩ́nhɛ́ amʋ lɛ́blɩ́? Ɔlɛblɩ́ ɔbɛ́ɛ, “Abraham lɔ́hɔ Bulu gyi. Mʋ́ sʋ Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nɩ́ ɔkʋ ɔyɔ́ agyʋ́má á, bʋtɛká mʋ ɩkɔ. Megyí atokiehɛ́ ɩkɔká ámʋ gyí. Igyi tɔ́á ilehián ánɩ́ obénya tsú mʋ agyʋ́má yɔtɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Támɛ megyí ahá bwɛhɛ́ sʋ, mboún amʋ́ hógyi sʋ́ Bulu totsú amʋ́ ánɩ́ amʋ́ asʋ́n da ɔkpa. Tsúfɛ́ Bulu tɛ́há lakpan abwɛpʋ́ ánɩ́ bɔhɔ mʋ gyi bʋtegyi asʋ mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Owíe Dawid lɛ́blɩ́ oyúla asʋ́n ánfɩ kɛ́n dodo. Ɔlɔtɔɩ́ tsú ahá ánɩ́ Bulu mɛ́kɩ amʋ́ bwɛhɛ́ asa olotsu amʋ́ ánɩ́ amʋ́ asʋ́n da ɔkpa ɩwɩ. Ɔlɔwanlɩ́n mʋ́ wá Bulu asʋn ámʋtɔ ɔbɛ́ɛ, ");
INSERT INTO nkoNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Bulu layúlá ahá ánɩ́ alasí amʋ́ lakpan kíé amʋ́, alagyʋ́ra amʋ́! ");
INSERT INTO nkoNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ahá ámʋ́ʋ́ Bulu lasí amʋ́ lakpan kíé amʋ́, ɔmɛ́ɛtrá kaɩ́n mʋ́sʋ́ ámʋ bégyi ɔdwɛ!” ");
INSERT INTO nkoNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Keté atɩ́npʋ nkʋlɛ bʋ́ ɔdwɛgyí anfɩ́ Owíe Dawid dɛ́ mʋ́ ɩwɩ asʋ́n blɩ́ ánfɩ? Ó-o! Ahá ámʋ́ʋ́ bʋmɛtɩn keté ámʋ ɛ́ bʋbʋ mʋ́tɔ́. Kaɩn ánɩ́ anɩlakla asʋankʋ Bulu asʋn wanlɩ́nhɛ́ amʋtɔ. Anɩa, “Abraham lɔ́hɔ Bulu gyi. Mʋ́ sʋ Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Brɛ́ mɔmʋ Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa? Ɔlɛtɩn keté asa lóó? Ɛkɛkɛɛkɛ! Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa dodoodo. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ɔma-ɔma asa ɔlɛbɛtɩn keté pʋ́hɩ́ɛ mʋ nsʋ. Ilosuná ánɩ́ mʋ hógyi sʋ́ Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa. Ɩ́nɩ sʋ ogyi fɛ́ ahá ámʋ́ʋ́ bʋmɛtɩn keté, támɛ bɔhɔ Bulu gyi, Bulu lótsu amʋ́ ánɩ́ amʋ́ asʋ́n da ɔkpa ámʋ. Mʋ́ sʋ ogyi amʋ́ fɛ́ɛ́ ɔsɩ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ogyi keté atɩ́npʋ amʋ ɛ́ ɔsɩ́. Tsúfɛ́ megyí amʋ́ ketétɩ́ɩn sʋ, mboún amʋ́ Buluhógyi sʋ. Fɛ́ alɩ ámʋ́ʋ́ Abraham lɔ́hɔ Bulu gyi asa bɛtɩn mʋ keté ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bulu lɛ́hɩɛ Abraham mʋa mʋ abí-aná ánɩ́ ɔyɩ́tɔ́ fɛ́ɛ́ ɩbɔ́bwɛ amʋ́ klɛ́. Megyí bɛɛ Abraham légyi Mose mblasʋ, sʋ Bulu lɛ́blɩ́ asʋ́n ánfɩ. Támɛ ɩ́nɩá ɔlɔhɔ Bulu gyi, Bulu ɛ́ lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa mʋ ansɩ́tɔ́ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nɩ́ ahá ánɩ́ bʋdɛ Mose Mbla ámʋtɔ obégyi Bulu atɔ́ á, mʋ́mʋ́ ɔha Bulu hógyi igyi kpaalɩ. Bulu nhɩhɩɛ́ há ɔha ɛ́ ma labi kʋkʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tsúfɛ́ Bulu ɔblɔ́ mbla ámʋ tɛtɩ́. Támɛ nɩ́ mbla má ɩnʋ á, mblatʋn ɛ́ ɩma ɩnʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Mʋ́ alɩ sʋ ɩna hógyisʋ ahá bɛ́talɩ́ nyá atɔ́á Bulu lɛ́hɩɛ yáɩ́ há amʋ́. Atokiehɛ́ ámʋ́ʋ́ ɔbɔ́pʋhá Abraham abí-aná ámʋ ɩbɛ́da amʋ́ ɩbɩ. Megyí ahá ánɩ́ bʋtegyi mblasʋ nkʋlɛ bʋ́, támɛ ahá ánɩ́ bɔhɔ Bulu gyi fɛ́ Abraham ɛ́. Tsúfɛ́ Abraham gyí anɩ fɛ́ɛ́ ɔsɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Fɛ́ alɩ ámʋ́ʋ́ Bulu asʋn wanlɩ́nhɛ́ amʋ ɩlɛblɩ́ ɔbɛ́ɛ, “Napʋ́ fʋ́ bwɛ́ ɔmá tsɔtsɔɔtsɔ ɔsɩ́ ámʋ. Abraham gyí anɩ fɛ́ɛ́ ɔsɩ́ Bulu ansɩ́tɔ́.” Tsúfɛ́ olohogyi ánɩ́ Bulu tɛ́há awupʋ́ nkpa, ɔtɛhá tɔ́á ɩma ɩnʋ yáɩ́ ɩtɛba mʋ́tɔ́ fɛ́ tɔ́á ɩbʋ ɩnʋ yáɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Brɛ́á tɔtɔ má ɩnʋá Abraham ɔbɔ́pʋ mʋ ansɩ́ dɩ́nká mʋ́sʋ́ á, ɔlɔhɔ Bulu gyi ánɩ́ ɔbɔ́bwɛ mʋ ɔmá tsɔtsɔɔtsɔ ɔsɩ́ alɩ ámʋ́ʋ́ ɔlɛblɩ́ yáɩ́ ámʋ. Bulu lɛ́bláa mʋ ɔbɛ́ɛ, “Fʋ́ abí-aná bɛ́klɛɩ́ fɛ́ ntsrakpabi.” ");
INSERT INTO nkoNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Alɩ brɛ́ ámʋtɔ á, Abraham lahɔ nfí lafakʋlɛ (100). Mʋ́ sʋ aladan tsʋn kwɩɩ́sʋ́. Alɩ kɛ́n mʋ ka Sara ɛ́ ɔkwɩɩ́púni lawú, ɔmɛ́ɛtrá kwɩɩ́ nɩ́. Oyin ɩ́nɩ fɛ́ɛ́, támɛ ɔmɛkpa mʋ hógyi ɔma. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ɩ́nɩ fɛ́ɛ́ ɔma a, omegyi nwɛ́ɛn ɔbɛ́ɛ, ɩtɔ́ ámʋ́ʋ́ Bulu lɛ́hɩɛ mʋ amʋ ɩmɛ́ɛba mʋ́tɔ́. Mboún ɔlɛkɩtá mʋ hógyitɔ kínkíínkín, ɔlɛkanfʋ́ Bulu mʋ́ sʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Tsúfɛ́ ɔhɩ́ɛ́ oyin ánɩ́ Bulu ɔbɛ́talɩ́ bwɛ́ ɩtɔ́ ámʋ́ʋ́ alahɩ́ɛ́ há mʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Mʋ hógyi anfɩ sʋ́ Bulu lɛ́blɩ́ ɔbɛ́ɛ, mʋ asʋ́n da ɔkpa nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Megyí mʋ nkʋlɛ sʋ bɔwanlɩ́n wá Bulu asʋ́n ámʋtɔ bɛɛ, “Bulu lótsu mʋ ánɩ́ mʋ asʋ́n da ɔkpa.” ");
INSERT INTO nkoNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Anɩ ɛ́, anɩ sʋ bɔwanlɩ́n mʋ́. Nɩ́ anɩlɔ́hɔ Bulu gyi a, obótsu anɩ ánɩ́ anɩ asʋ́n da ɔkpa. Mʋgyí ɔhá ánɩ́ ɔlɔkʋsʋ́a anɩ Wíe Yesu tsú afúlitɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Anɩ lakpan sʋ́ Bulu lɛ́ha bɛlɛ mʋ há bɔmɔ mʋ. Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ, mɛ́nɩ obótsu anɩ ɛ́ ánɩ́ anɩ asʋ́n da ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Anɩ hógyi sʋ́ Bulu latsú mʋ́ ánɩ́ anɩ asʋ́n da ɔkpa. Mʋ́ sʋ anɩ Wíe Yesu Kristo lalá anɩa Bulunyɔ nsɩnɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Hógyi sʋ ɔkpa lafínkí há anɩ ngya. Ɩ́nɩá anɩ Wíe Yesu sʋ́ Bulu awɩtɔlɛ anfɩ laba anɩsʋ, anɩlapʋ́ hogyi nyá ɔlɩɩ́kpá ngya a, ɩhɩ́ɛ́ bʋ anɩ ɔdwɛ. Tsúfɛ́ anɩdɩ́n ansɩ́ ánɩ́ abébenya mʋ numnyam amʋ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ansɩ́ ɩtráa dɛ anɩ gyí ánɩ́ anɩdɛ́ ipian wúun. Tsúfɛ́ ipian tɛ́há anɩtɔwá nsi. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Nsiwa tɛhá anɩtɛbɩ́ tsíá alɩá ilegyi Bulu ansɩ́. Nɩ́ abɩ́ tsíá alɩá ilegyi mʋ ansɩ́ á, abɛ́dɩnká ansɩ́ mʋsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ansɩ́ pʋdɩ́nká Bulusʋ mɛ́ɛha pɛ́lɩ mɛ́ɛkɩtá anɩ. Tsúfɛ́ Bulu lɔ́tsʋn Ɔŋɛ Wankɩ́hɛ́ amʋ́ʋ́ ɔlɔpʋhá anɩ ámʋsʋ pʋ́ mʋ ɔdwɛ wá anɩ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Brɛ́á anɩtráa anɩgyí lakpan abwɛpʋ́, anɩmá ɔwʋnlɩ́n á, Kristo lóbowu há anɩ lalahɛ abwɛpʋ́ brɛ́á Bulu onutó lɛ́hɩɛtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nɩ́ ɔkʋ asʋ́n da ɔkpa kʋ́ráá á, ɩbɔ́wa ɔnlɩn asa ɔkʋ obótsulá wú há mʋ. Fíalɩ ɔha yilé mʋ́ á, ɔkʋ ɔbɔ́wa klʋn wú há mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Támɛ tɔ́á ilosuná ánɩ́ Bulu tɛhɩ́ɛ́ dwɛ́ anɩ gyí, brɛ́á anɩgyí lakpan abwɛpʋ́ á, ɔlɛha Kristo lóbowu há anɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ɩna Yesu Kristo obugya amʋ́ʋ́ ɩlɔwʋlɩ́ asɩ ámʋsʋ Bulu lési anɩ lakpan kíé anɩ, tsú anɩ ánɩ́ anɩ asʋ́n da ɔkpa. Kristo sʋ ɔbɛ́lɛ anɩ kokooko. Ɔmɛ́ɛbɩtɩ́ anɩ ɩsʋ lakpan abwɛpʋ́ ɩsʋ-ɔbɩtɩ́kɛ́ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Tɛkɩ Bulu alupʋ́ anɩgyí. Támɛ tsʋ́ʋn mʋ Bi ámʋ lowusʋ á, alabwɛ́ anɩ mʋ anyawíe kláklá. Ɩ́nɩá anɩlabwɛ́ mʋ anyawíe sʋ á, ɔbɔ́hɔ anɩ nkpa kokooko. Tsúfɛ́ Kristo ɛ́ bʋ nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Megyí mʋ́ wʋlɛ. Mʋ́á ɩtráa dʋn kʋ́ráá gyí, anɩdɛ́ ɔdwɛ gyí. Tsúfɛ́ anɩ Wíe Yesu Kristo lalá anɩa Bulunyɔ nsɩnɛ́. Mʋ́ sʋ anɩlabwɛ́ Bulu anyawíe. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Adam nkʋlɛ bwɛhɛ́ sʋ lakpan lɛ́ba ɔyɩ́tɔ́. Mʋ lakpan ámʋ sʋ́ lowu lɛ́ba ɔyɩ́tɔ́. Ɩ́nɩ sʋ lowu lénya túmi ɔhagyíɔhasʋ, tsúfɛ́ ahá fɛ́ɛ́ babwɛ́ lakpan. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Lakpan bʋ ɔyɩ́tɔ́ asa Bulu lɔ́pʋ mʋ mbla ba Mose. Támɛ brɛ́á Bulu mɔ́kʋ́pʋ́ mbla ámʋ ba mʋ a, olobun ansíbi lakpansʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Tsú Adam brɛ́sʋ́ bɔtʋ Mose brɛ́sʋ́ lowu legyi iwíe anyánkpʋ́sa fɛ́ɛ́sʋ́. Ɩbʋ mʋ́tɔ́ ánɩ́ bʋmɔtʋn mbla kʋkʋ fɛ́ Adam, támɛ amʋ́ ɛ́ bowu. Akɩ́ɩ alɩá Adam léklé ɔlɩan ɔmapʋ amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Adam ná ɔtsan há Yesu Kristo. Tsúfɛ́ Bulu awɩtɔlɛ amʋ megyí fɛ́ Adam lakpan ámʋ. Adam nkʋlɛ lakpan sʋ́ ahá fɛ́ɛ́ bowu. Támɛ Yesu Kristo nkʋlɛ awɩtɔlɛwa sʋ Bulu laláwá awɩtɔlɛ, pʋ́ mʋ atokiehɛ́ há ahá tsɔtsɔɔtsɔ. Mʋ atokiehɛ́ ámʋ ɩbʋ bíá dʋn lowu ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Tɔ́á anyánkpʋ́sa benya tsú Bulu atokiehɛ́ ámʋtɔ ɩna ɔtsan há tɔ́á benya tsú Adam lakpan ámʋtɔ. Mʋ lakpan kʋlɛ pɛ́ amʋ lɛ́ha ɔhagyíɔha légyi pɔ́n Bulu ansɩ́tɔ́. Mʋ́lɔ́pʋ lowu ba, támɛ lakpan tsɔtsɔɔtsɔ ɔma a, Bulu atokiehɛ́ kʋlɛ pɛ́ lɛha Bulu lótsu ahá fɛ́ɛ́ ánɩ́ amʋ́ asʋ́n da ɔkpa mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ɔbakʋ́lɛ lakpan sʋ lowu légyi iwíe ahásʋ. Támɛ alɩá Bulu lahɩ́ɛ́ wá awɩtɔlɛ há ahá ɩbʋ wánwan. Alatsʋn Yesu Kristo nkʋlɛsʋ tsú anɩ ánɩ́ anɩ asʋ́n da ɔkpa, anɩa mʋnyɔ abégyi iwíe anɩ nkpatɔ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ɩ́nɩ sʋ alɩ ámʋ́ʋ́ ɔbakʋ́lɛ lakpan sʋ Bulu lɛ́ha ahá fɛ́ɛ́ pɔ́n ámʋ a, alɩ kɛ́n ɔbakʋ́lɛ yilébwɛ sʋ Bulu lahá ahá fɛ́ɛ́ bagyi asʋ mʋ ansɩ́tɔ́, alahá amʋ́ nkpa ánɩ́ ɩtamatá ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Alɩ ámʋ́ʋ́ ɩna ɔbakʋ́lɛ asʋtɔ-ɔnlɩn sʋ ahá fɛ́ɛ́ bemlí lakpan abwɛpʋ́ ámʋ a, alɩ kɛ́n ɩna ɔbakʋ́lɛ obú sʋ Bulu obótsu ahá tsɔtsɔɔtsɔ ánɩ́ amʋ́ asʋ́n da ɔkpa nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Bulu lɔ́pʋ mbla ámʋ ba, mɛ́nɩ ahá bówun lakpan ánɩ́ bʋdɛbwɛ wankláán. Támɛ brɛ́á lakpan dɛ́klɛɩ́ á, Bulu awɩtɔlɛ ɛ́ ɩdɛklɛɩ́ tsɩ́a. ");
INSERT INTO nkoNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Lakpan légyi ahásʋ, ɩlɛha ahá bowu. Alɩ kɛ́n Bulu lawá awɩtɔlɛ tsú ahá ánɩ́ amʋ́ asʋ́n da ɔkpa mʋ ansɩ́tɔ́ nɩ́. Ɩ́nɩ lahá ahá batsʋn anɩ Wíe Yesu Kristosʋ nyá nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Nkálɩ abɛ́blɩ́ séi? Ilehián ánɩ́ abɔ́yɔ anɩ lakpanbwɛsʋ, mɛ́nɩ Bulu awɩtɔlɛ bómoní tsɩ́a? ");
INSERT INTO nkoNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ɛkɛkɛɛkɛ! Igyi fɛ́ anɩlawú, mʋ́ sʋ lakpan ma túmi anɩsʋ. Ntogyi sʋ abɛ́trá tsiá bwɛ́ lakpan? ");
INSERT INTO nkoNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Brɛ́ ámʋ́ʋ́ bɔbɔ anɩ asú ámʋ a, anɩa Kristo Yesunyɔ anɩlɔ́bwɛ kʋlɛ. Mlɩyin mʋ́ alɩ? Alɩ brɛ́ ámʋtɔ á, anɩa Kristonyɔ lówu, ");
INSERT INTO nkoNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","bopulá anɩ, tsúfɛ́ anɩa mʋnyɔ anɩlabwɛ́ kʋlɛ. Mʋ́ sʋ alɩ ámʋ́ʋ́ anɩ Sɩ́ Onumnyampʋ amʋ lɔ́kʋsʋ́a mʋ tsú afúlitɔ ámʋ a, alɩ kɛ́n anɩ ɛ́ abétsiá itsiá pɔpwɛtɔ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Mʋ́ sʋ ɩ́nɩá anɩa mʋnyɔ anɩlɔ́bwɛ kʋlɛ mʋ lowutɔ á, alɩ kɛ́n anɩa mʋnyɔ lɔ́bwɛ kʋlɛ mʋ kʋsʋ́ tsú afúlitɔ ɛ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Mlɩbɩ ánɩ́ brɛ́á bɛda Yesu mántá oyikpalíhɛ amʋsʋ á, mʋa anɩ tsiátɔ́ dada amʋ lówu, mɛ́nɩ anɩmɛ́ɛtrá bwɛ lakpan nkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Tsúfɛ́ nɩ́ ɔha owú á, ɔtamatráa bwɛ lakpan. Lakpan má mʋsʋ túmi. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ɩ́nɩá anɩa mʋnyɔ anɩlawú sʋ á, anɩbʋ hógyi ánɩ́ anɩa mʋnyɔ abétsiá nkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Anɩyin ánɩ́ Bulu lɔ́kʋsʋ́a Kristo tsú afúlitɔ. Ɔmɛ́ɛtrá wu ɛkɛkɛɛkɛ. Lowu ɩtráa ma mʋsʋ túmi. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Yesu lówunáa wu ɔtsáwʋlɛ, mɛ́nɩ ɔbɛ́lɛ lakpan ɩnʋ. Támɛ ɩ́nɩá otsie nkpa á, otsie ha Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Mlɩ ɛ́ mlɩkɩ mlɩ ɩwɩ ánɩ́ mlɩlawú há lakpan, amlɩlɛ mlɩ ɩwɩ lɛ mʋ́ túmi asɩ. Mlɩtsia nkpa ha Bulu, tsúfɛ́ mlɩa Kristo Yesunyɔ mlɩlabwɛ́ kʋlɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ɩ́nɩ sʋ mlɩmáha lakpan igyi mlɩ nyankpʋsa-oyí ánfɩ ibówu ánfɩsʋ, mɛ́nɩ ɩmɛ́ɛha ɔwɔ́lɩ laláhɛ igyi mlɩsʋ, amlɩbwɛ tɔ́á ideklé. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mlɩmápʋ mlɩ nyankpʋsa-oyí ɩwɩ atɔ́ há lalahɛbwɛ. Mboún mlɩpʋ mlɩ ɩwɩ fɛ́ɛ́ ha Bulu, fɛ́ ahá ánɩ́ alakʋ́sʋ́a amʋ́ tsú afúlitɔ ba nkpatɔ, ɔpʋ mlɩ bwɛ tɔ́á ɩda ɔkpa. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ɩma alɛá lakpan ɔbɛ́trá gyi mlɩsʋ, tsúfɛ́ séi mlɩtráa mlɩmá Mose Mbla ámʋ asɩ. Bulu awɩtɔlɛ asɩ mboún mlɩbʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ɩ́nɩ ɔma a, amansʋ abɛ́blɩ́? Ɩbʋ alɛ́á abɛ́trá bwɛ lakpan séi ánfɩ ánɩmá mbla ámʋ asɩ, anɩbʋ Bulu awɩtɔlɛ mboún asɩ? Ɛkɛkɛɛkɛ! ");
INSERT INTO nkoNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mlɩméyín ánɩ́ nɩ́ mlɛba ɩwɩasɩ há tɔkʋ, mlɩdɛ́ mʋ́ apɛ́ bwɛ, mlɩdɛ́ mʋ́ súm fɛ́ mlɩ wíe a, mlɩlabwɛ́ mʋ́ nkpábi? Nɩ́ mlɛba ɩwɩasɩ há lakpan á, mʋ́mʋ́ mlówu, támɛ nɩ́ mlɛba ɩwɩasɩ há Bulu á, mlégyi asʋ mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mlɩlɔ́bwɛ nkpábi há lakpan brɛ́ kʋtɔ. Séi á, mlɩlapʋ́ mlɩ klʋn fɛ́ɛ́ hɔ atosunáhɛ́ amʋ́ʋ́ bapʋ́há mlɩ ámʋ, mlɩdɛ́ mʋ́sʋ́ gyí. Mʋ́ sʋ ndɛ Bulu ɩpán da. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Bulu lahá mlɩlagyi ɩwɩ lɛ́ lakpan ɩbɩtɔ, mlɩlabwɛ́ nkpábi há yilébwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Alɩá ɩbɔ́bwɛ mlónu asʋ́n ánfɩ asɩ, sʋ́ napʋ́ nkpábi tsiátɔ́ ndɛ mlɩ suná. Brɛ́ kʋtɔ á, mlɩlɔ́bwɛ mlɩ ɩwɩ nkpábi há hakpan mʋ́a lalahɛbwɛ. Alɩ kɛ́n ilehián ánɩ́ mlɔ́bwɛ mlɩ ɩwɩ nkpábi ha yilébwɛ, mɛ́nɩ mlɔ́fʋn yi nɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Brɛ́ ámʋ́ʋ́ mlɩgyí nkpábi há lakpanbwɛ ámʋ a, yilébwɛ má túmi mlɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Labi mɔmʋ mlɩlénya tsú lakpan ámʋ́ʋ́ mlɩlɔ́bwɛ, ndɛ ɩbʋ mlɩ pɛ́lɩ amʋtɔ? Mʋ́ labi gyí lowu. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Támɛ séi mʋ́ á, Bulu lahá mlɩlagyi ɩwɩ lakpanbwɛ túmi asɩ. Mlɩlamlí mʋ nkpábi. Labiá mlénya tsú mʋ́tɔ́ gyí; mlétsiá tsiátɔ́á ɩlɔfʋn yi, nyá nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Tsúfɛ́ lakpanbwɛ ɩkɔká gyí lowu, támɛ Bulu atokiehɛ́ gyí nkpa ánɩ́ ɩtamatá. Mʋ́ ɔlɔpʋgyi anɩ bʋalɛ tsʋn anɩa anɩ Wíe Kristo Yesu ɩkʋlɛbwɛsʋ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Mɩ́ apíó, mlɩ fɛ́ɛ́ mlɩyin Mose Mbla ámʋ. Mlɩyin ánɩ́ brɛ́á ɔha tsie nkpa á, ɔbʋ mbla asɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Fɛ́ nɩ́ ɔtsɩ tsia okúlu, mʋ kulu amʋ mɔ́kʋ́wú á, ɔbʋ mʋ kulu amʋ asɩ. Támɛ nɩ́ mʋ kulu amʋ owú a, alagyi ɩwɩ, okúlu wóyí mbla kʋkʋ ɩtráa mɛdɛ́ mʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Mʋ́ alɩ sʋ nɩ́ mʋ kulu amʋ mɔ́kʋ́nyá wú, ɔdálɩ mʋ ɔma a, alatɔ́ mbʋa. Támɛ nɩ́ mʋ kulu amʋ owú mʋ́ á, ɔtráa ɔma okúlu wóyí mbla asɩ. Mʋ́ sʋ nɩ́ ɔláyétsiá oyin bámbá á, ɔmɔkʋ́tɔ́ mbʋa. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Mɩ́ apíó, alɩ kɛ́n igyi há mlɩ nɩ́. Mlɩ ɛ́ brɛ́á mlɩlɔ́hɔ Kristo gyi a, mlɩa mʋnyɔ mlɩlówu. Mʋ́ sʋ mlɩtráa mlɩmá Mose Mbla asɩ. Séi á, mlɩlabwɛ́ ɔhá ámʋ́ʋ́ Bulu lɔ́kʋsʋ́a tsu afúlitɔ ámʋ klɛ́, mɛ́nɩ mlɔ́bwɛ yilé há Bulu. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Tsúfɛ́ brɛ́á anɩbʋ anɩ tsiátɔ́ dada amʋtɔ á, mbla ámʋ lɛ́ha anɩ ɔwɔ́lɩ laláhɛ legyi anɩsʋ. Mʋ́ sʋ anɩlɔ́bwɛ tɔ́á ɩtɔpʋ́ lowu ba. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Támɛ séi mʋ́ á, Bulu lahá anɩlagyi ɩwɩ tsú mbla ámʋ́ʋ́ tɛkɩ anɩbʋ mʋ́ asɩ ámʋ ɩbɩtɔ. Anɩa Kristonyɔ lówu. Mʋ́ sʋ mbla ámʋ ɩtráa ma túmi anɩsʋ. Anɩlagyi ɩwɩ, anɩdɛ́ Bulu súm tsʋn ɔkpa pɔpwɛ ánɩ́ Ɔŋɛ Wankɩ́hɛ́ dɛ́ anɩ sunásʋ́. Megyí ɔkpa ánɩ́ mbla wánlɩ́nhɛ́ amʋ lósuná anɩsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Mʋ́ sʋ anɩdɛ́blɩ́ anɩaa, ɩtɔ laláhɛ Mose Mbla ámʋ gyí? Ɛkɛkɛɛkɛ! Mbla ámʋ ɩbɛ́ha abɛ́bɩ tɔ́á lakpan gyí. Tɛkɩ nɩ́ mbla ámʋ ɩmɛblɩ́ ɔbɛ́ɛ, “Mápɛ ansɩ́ fʋ́ bá atɔ́sʋ́” a, tɛkɩ mmɛbɩ tɔ́á gyí ɔnsɩ́pɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ɩna alɩ mbla ánfɩ sʋ lakpan lénya ɔkpa pʋ́ ɔnsɩ́pɛ kugyíkʋ wá mɩ́tɔ́. Tsúfɛ́ nɩ́ mbla ámʋ má ɩnʋ á, tɛkɩ lakpan má túmi mɩ́sʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mɩ́ onutó netsiá brɛ́ kʋtɔ, mmɛbɩ mbla ámʋ. Támɛ brɛ́á nɛbɛbɩ mʋ́ á, nowun ánɩ́ napán mʋ́sʋ́. Lakpan ɔbwɛpʋ́ ngyi. Mʋ́ sʋ nówu. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Nowun ánɩ́ mbla ámʋ́ʋ́ nkɩ mbɛ́ɛ, ɩbɛ́ha mɩ́ nkpa ámʋ lɔ́pʋ lowu ba mɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Tsúfɛ́ lakpan lénya ɔkpa tsʋn mbla ámʋsʋ mlɛ́ mɩ́, mɔ́ mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tsiátɔ́ mbla ámʋ mʋ́ á, tsitsa kʋkʋ ma mʋ́ ɩwɩ. Mʋ́ nhɩhɩɛ́ kugyíkʋ lɔwankɩ́, ɩda ɔkpa, ɩbʋ alɛ́ ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Mʋ́ sʋ idesuná ánɩ́ Bulu mbla ánfɩ́ ɩbʋ alɛ́ ánfɩ lɔ́pʋ lowu ba mɩ? Ɛkɛkɛɛkɛ! Megyí alɩ ígyi. Lakpan lɔ́tsʋn ɩtɔ wankláán ámʋsʋ pʋ́ lowu ba mɩ. Ɩna mbla ámʋsʋ lakpan lɛ́lɛ ɩwɩ súná ánɩ́ itépí ma alɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Anɩyin ánɩ́ ɔŋɛ́tɔ́ atɔ́ mbla ámʋ gyí, támɛ mɩ́ mʋ́ á, nyankpʋsa ngyi. Nabwɛ́ lakpan ɔkpábi. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mmɛtálɩ́ bɩ́ mɩ́ tsiátɔ́, tsúfɛ́ megyí tɔ́á ndeklé ntɔbwɛ́, tɔ́á mmedéklé mboún ntɔbwɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nɩ́ tɔ́á mmedéklé ndɛbwɛ mʋ́ á, natsúlá ánɩ́ Mose Mbla ámʋ ɩbʋ alɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Idesuná ánɩ́ megyí mɩ́ dɛ́ alɩ atɔ́ ánfɩ bwɛ. Mboún lakpan túmiá ɩbʋ mɩsʋ tɛ́há ntɔbwɛ́ mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nyin ánɩ́ brɛ́ ánfɩ mbʋ mɩ́ tsiátɔ́ dada anfɩtɔ á, ɩtɔ wankláán kʋkʋ má mɩ́tɔ́, tsúfɛ́ nyankpʋsa ngyi. Ntekleá nɔ́bwɛ yilé, támɛ nakásíán. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mmɛdɛ́ yiléá ndeklé bwɛ. Lalahɛ amʋ́ʋ́ mmedékléá nɔ́bwɛ ámʋ mboún ndɛbwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nɩ́ ndɛ lalahɛ amʋ́ʋ́ mmedékléá nɔ́bwɛ ámʋ bwɛ á, mʋ́mʋ́ idesuná ánɩ́ megyí mɩ́ onutó dɛ́ mʋ́ bwɛ. Mboún lakpan túmi ámʋ́ʋ́ ɩbʋ mɩtɔ ámʋ dɛ́ mʋ́ bwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Mʋ́ sʋ nawun ánɩ́ mbla ánfɩ lagyi mɩsʋ. Nɩ́ ndekléá nɔ́bwɛ yilé á, lalahɛ kóún ntɔbwɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Tsúfɛ́ nhɩ́ɛ́ ndekléá négyi Bulu mbla ámʋsʋ tsú mɩ́ klʋntɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Támɛ ntowun ánɩ́ mbla kʋ dɛ́ mbla ámʋ́ʋ́ ɩbʋ mɩ́ klʋntɔ ámʋ ɩsá kɔ, gyi mʋ́sʋ́, bwɛ́ mɩ́ lakpan ɔkpábi. Ɩlahá lakpan ámʋ́ʋ́ ɩbʋ mɩtɔ ámʋ ɩdɛ mɩ́ bwɛhɛ́ kugyíkʋsʋ gyí. ");
INSERT INTO nkoNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kɩ ipian kpɔnkpɔɔnkpɔntɩá mbʋ mʋ́tɔ́! Ɩlapʋ́ mɩ́ ɩya lowutɔ. Ma ɔbɛ́lɛ mɩ́ tsú mʋ́tɔ́? ");
INSERT INTO nkoNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Támɛ anɩ Wíe Yesu Kristo sʋ ndɛ Bulu ɩpán da ánɩ́ alalɛ́ mɩ́! Mɩ́ klʋntɔ mʋ́ á, tɛkɩ ndekléá nɔ́bwɛ Bulu mbla ámʋ ɔkpábi. Támɛ tsiátɔ́ laláhɛ amʋ́ʋ́ ɩbʋ mɩtɔ ámʋ lahá nabwɛ́ lakpan ɔkpábi mboún. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ɩ́nɩ sʋ séi á, Bulu mɛ́ɛtrá ha ahá ánɩ́ amʋ́a Kristo Yesunyɔ babwɛ́ kʋlɛ ɩpɔ́n. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Tsúfɛ́ Kristo Yesu sʋ Ɔŋɛ Wankɩ́hɛ́ túmi ánɩ́ ɩtɛhá nkpa lahá anɩlagyi ɩwɩ tsú lakpanbwɛ mʋ́a lowu ɩbɩtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mose Mbla ámʋ mɛ́talɩ́ lɛ́ anɩ tsú anɩ lakpantɔ. Tsúfɛ́ anɩ tsiátɔ́ dada amʋ́ʋ́ ɩtɛhá anɩtɔbwɛ́ lakpan ámʋ ɩmɛha anɩmégyí mbla ámʋ atosunáhɛ́sʋ. Támɛ Bulu lɔ́tsʋn ɔkpa pɔpwɛsʋ hɔ anɩ. Ɔlɔwa mʋ Bi onutó lɛ́bá fɛ́ nyankpʋsa ánɩ́ ɔtɔbwɛ́ lakpan, támɛ mʋ mʋ́ ɔmɔbwɛ lakpan. Bulu lɔ́tsʋn mʋ lowusʋ mɔ́ anɩ tsiátɔ́ dada amʋ́ʋ́ lakpan legyi mʋ́sʋ́ ámʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ɔlɔbwɛ mʋ́ alɩ, mɛ́nɩ nɩ́ anɩbuo Ɔŋɛ Wankɩ́hɛ́ amʋ a, abɛ́talɩ́ tsíá tsiátɔ́ wankláán ámʋ́ʋ́ tɛkɩ mbla ámʋ lósuná ámʋ, anɩmɛ́ɛtrá tsiá anɩ tsiátɔ́ dada amʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tsúfɛ́ lalahɛ ahá ánɩ́ tsiátɔ́ dada ámʋ́ʋ́ ɩtɔbwɛ́ lakpan ɩdɛ amʋ́sʋ́ gyí bʋtɔgywɩ́ɩn. Támɛ ahá ánɩ́ bʋbuo Ɔŋɛ Wankɩ́hɛ́ amʋ a, tɔ́á Ɔŋɛ́ ámʋ tekle bʋtɔgywɩ́ɩn. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ɔhá ánɩ́ lakpan lagyi mʋ tsiátɔ́sʋ tenyá lowu tsú mʋ́tɔ́. Támɛ ɔhá ánɩ́ Ɔŋɛ Wankɩ́hɛ́ lagyi mʋsʋ mʋ́ tenyá nkpa mʋ́a iwilwii. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Tsúfɛ́ ɔha ánɩ́ lakpan lagyi mʋ tsiátɔ́sʋ tolú Bulu. Ɔtamagyi Bulu mblasʋ, tsúfɛ́ ɔmɛ́ɛtalɩ́ gyi mʋ́sʋ́ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ahá ánɩ́ lakpan lagyi amʋ́ tsiátɔ́sʋ bʋmɛ́ɛtalɩ́ gyi Bulu ansɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Támɛ Bulu Ɔŋɛ́ bʋ mlɩtɔ lɛ́lɛ́. Mʋ́ sʋ mlɩmɛ́ɛtrá tsiá mlɩ tsiátɔ́ amʋ́ʋ́ lakpan legyi mʋ́sʋ́ ámʋ. Mlɔ́bwɛ tɔ́á Ɔŋɛ Wankɩ́hɛ́ amʋ tekle. Nɩ́ ɔkʋ má Kristo Ɔŋɛ́ ámʋ a, omegyí mʋ klɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ɩbʋ mʋ́tɔ́á lakpan sʋ mlɩ nyankpʋsa-oyí ánfɩ obówu. Támɛ nɩ́ Kristo bʋ mlɩtɔ á, mlɩ ɔkláa bʋ nkpa. Tsúfɛ́ Bulu latsú mlɩ ánɩ́ mlɩ asʋ́n da ɔkpa mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Bulu lɔ́kʋsʋ́a Kristo tsú afúlitɔ lɛ́lɛ́. Mʋ́ sʋ nɩ́ mʋ Ɔŋɛ́ bʋ mlɩtɔ á, mʋ́mʋ́ ɔbɔ́tsʋn Ɔŋɛ́ ámʋsʋ há mlɩ nyankpʋsa-oyí ámʋ́ʋ́ ibówu ámʋ nkpa pɔpwɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ɩ́nɩ sʋ mɩ́ apíó, imehián ánɩ́ abɛ́trá tsiá anɩ tsiátɔ́ dada amʋ, bwɛ́ tɔ́á anɩ ɔwɔ́lɩ laláhɛ tekle. Mboún lehián ánɩ́ abɔ́bwɛ tɔ́á Ɔŋɛ Wankɩ́hɛ́ tekle. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Tsúfɛ́ nɩ́ mletsíá mlɩ tsiátɔ́ dada amʋtɔ á, mlówu tsítsá. Támɛ nɩ́ mlɔtsʋn Bulu Ɔŋɛ́ ámʋsʋ kíná mlɩ nyankpʋsa-oyí ámʋ apɛ́ bwɛ á, mlétsiá nkpa ánɩ́ ɩtamatá. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Tsúfɛ́ ahá ánɩ́ bahá Bulu Ɔŋɛ́ dɛ amʋ́ kpa gyí Bulu abí. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Megyí Ɔŋɛ́ ánɩ́ ɩbɛ́ha mlɔ́bwɛ nkpábi, tsíá nyá ifú Bulu lɔ́pʋwá mlɩtɔ. Mboún Ɔŋɛ́ ámʋ lɔ́bwɛ mlɩ Bulu abí. Ɔŋɛ́ ámʋ sʋ anɩtɛtálɩ́ su kpolí Bulu anɩaa, “Abba, mɩ́ Sɩ́!” ");
INSERT INTO nkoNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ɔŋɛ́ ámʋ totsúlá há anɩ ánɩ́ lɛ́lɛ́ á, Bulu abí anɩgyí. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nɩ́ Bulu abí anɩgyí á, mʋ́mʋ́ anɩgyí mʋ atɔ́ agyípʋ́. Anɩa Kristonyɔ obégyi mʋ atɔ́. Tsúfɛ́ nɩ́ awun Kristo ipian ámʋ kʋ á, mʋ́mʋ́ abénya mʋ numnyam amʋ ɛ́ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nɩ́ nɛkɩ numnyam ánɩ́ ɩda gyo anɩ, Bulu ɔbɛ́lɛ súná anɩ á, ipian ánfɩ anɩdéwúun brɛ́ ánfɩtɔ ɩmɔfʋn mʋ́ ɔtɩnɛtɩnɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Bulu atɔ bwɛhɛ́ fɛ́ɛ́ bʋhɩ́ɛ́ bʋdɛ ɔkpa kɩ́ɩ ha ɛkɛá Bulu ɔbɛ́lɛ mʋ abí numnyam ɔwan. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Tsúfɛ́ Bulu atɔ bwɛhɛ́ fɛ́ɛ́ lasí ɩda kɛkɛ. Megyí mʋ́ onutó apɛ́ igyi. Mboún mʋlɔ́bwɛ mʋ́ alɩ, ɩha mʋ atɔ bwɛhɛ́ fɛ́ɛ́ ɩkɩ ɔkpa ");
INSERT INTO nkoNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ánɩ́ ɛkɛkʋ́ á, ɔbɛ́ha amʋ́ fɛ́ɛ́ bégyi ɩwɩ, bʋmɛ́ɛtrá yintá ɛkɛkɛɛkɛ. Mʋ atɔ bwɛhɛ́ ámʋ ibénya mʋ abí ɩwɩgyí pʋ́ amʋ́ numnyam amʋ kʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Anɩyin ánɩ́ bɔtʋ ndɛ á, Bulu atɔ bwɛhɛ́ fɛ́ɛ́ ɩdɛ ɩwɩɔsɩn wúun. Ɩdɛkɩmɩ́ fɛ́ alɩá ɩkwɩ́ɩ todwíín ɔtsɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Megyí Bulu atɔ bwɛhɛ́ ámʋ nkʋlɛ dɛ́kɩmɩ́. Anɩ ámʋ́ʋ́ alapʋ́ mʋ Ɔŋɛ́, igyi mʋ atokiehɛ́ gyankpapʋ wá anɩtɔ ámʋ ɛ́ anɩdɛ́kɩmɩ́ anɩ klʋntɔ. Anɩhɩ́ɛ́ anɩtsie anɩgyó ɛkɛá Bulu ɔbɛ́ha anɩ nyankpʋsa-oyí ánfɩ obégyi ɩwɩ, ɔbɔ́bwɛ anɩ mʋ abí. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Tsúfɛ́ ɔkpakɩ́ɩ anfɩ sʋ ɔlɔhɔ anɩ nkpa. Bʋtamakɩ tɔ́á fʋ́bʋ ɔkpa, tɔ́á fʋma ɔkpa bʋtɛkɩ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Nɩ́ anɩdɛ́ tɔ́á anɩmá ɔkpa kɩ́ɩ a, anɩtenyá klʋn tsíá gyo mʋ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ɔŋɛ Wankɩ́hɛ́ amʋ tɛtsá anɩ anɩ pɔ́ntɔ. Tsúfɛ́ anɩméyín alɩá abɔ́kʋlɩ́ Bulu atɔ́, ibégyi mʋ ansɩ́. Ɔŋɛ́ ámʋ onutó tɛhɩ́ɛ́ kɩ́mɩ́ pʋ́kʋ́lɩ́ Bulu atɔ́ há anɩ, dʋn alɩá anɩ onutó abɛ́talɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Bulu yin ɔhagyíɔha klʋntɔ asʋ́n. Mʋ́ sʋ oyin mʋ Ɔŋɛ́ ámʋ agywɩɩn. Tsúfɛ́ Ɔŋɛ́ ámʋ tokókóli Bulu há mʋ ahá alɩá Bulu onutó dɛ́ mʋ́ klé. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Anɩyin ánɩ́ Bulu tɛhá tógyítɔ́ tɔwá alɛ́ há mʋ adwɛpʋ́. Amʋ́gyí ahá ánɩ́ mʋ onutó ɔlɛtɩ mʋ nhɩhɩɛ́ ɔnɔ́ nɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Tsúfɛ́ ahá ámʋ́ʋ́ Bulu yin yaɩ́ ámʋ a, amʋ́ ɔlɛlɛ. Ahá ámʋ́ʋ́ ɔlɛlɛ ámʋ ɔlɛtɩ ɔbɛ́ɛ, bʋbɛ́lɩan mʋ Bi ámʋ. Fówun mʋ Bi ámʋ ɔbɔ́bwɛ ɔdɛ́hɛn mʋ abí tsɔtsɔɔtsɔtɔ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ahá ámʋ́ʋ́ Bulu yin yaɩ́ dodo amʋ ɔlɛtɩ. Ahá ámʋ́ʋ́ ɔlɛtɩ ámʋ olotsu ánɩ́ amʋ́ asʋ́n da ɔkpa mʋ ansɩ́tɔ́. Ahá ámʋ́ʋ́ olotsu ánɩ́ amʋ́ asʋ́n da ɔkpa ámʋ ɔlɔwa numnyam. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Amansʋ anɩtráa anɩbʋ blɩ́ tsú ɩ́nɩ ɩwɩ? Nɩ́ Bulu bʋ anɩ wá á, ma ɔbɛ́talɩ́ kʋ́sʋ́ lɩ́ɩ́ anɩsʋ? Ɔhaa má ɩnʋ! ");
INSERT INTO nkoNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Bulu mékiná mʋ onutó mʋ Bi ámʋ si há lowu anɩ fɛ́ɛ́ nwunsʋ. Olesi mʋ há faan. Nkálɩ sʋ́ ɔmɔ́ɔpʋ atɔ́ tráhɛ fɛ́ɛ́ tsɩ́a mʋ Bi ámʋtɔ há anɩ? ");
INSERT INTO nkoNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ma ɔbɛ́talɩ́ ká asʋ́n dɩ́nká ahá ámʋ́ʋ́ Bulu lalɛ́ ámʋsʋ? Bulu lóó? Ɛkɛkɛɛkɛ! Mʋgyí ɔhá ánɩ́ alatsú anɩ ánɩ́ anɩ asʋ́n da ɔkpa mʋ ansɩ́tɔ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ma ɔbɛ́talɩ́ há anɩ ɩpɔ́n? Ɔhaa má ɩnʋ! Tsúfɛ́ Kristo Yesu gyí ɔhá ánɩ́ olobowu há anɩ, Bulu lɔ́kʋsʋ́a mʋ tsú afúlitɔ. Alayɔ́ otsie Bulu gyɔpɩsʋ, ɔdɛ mʋ kokóli anɩ nwunsʋ. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ma ntɛ́ɛ ntɔ ɔbɛ́talɩ́ tɩ́tɩ anɩa Kristonyɔ nsɩnɛ́ ɔdwɛtɔ? Asʋn wunhɛ lóó, ntɛ́ɛ ɩkplán? Nɩ́ bʋdɩn anɩsʋ lóó, ntɛ́ɛ akʋ́n? Yayá natɩ́ lóó, ntɛ́ɛ lowu? ");
INSERT INTO nkoNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Tsúfɛ́ bɔwanlɩ́n wá Bulu asʋn wanlɩ́nhɛ́ amʋtɔ bɛɛ, “Fʋ́ sʋ bʋdɛ anɩ mɔ ekekegyíɛkɛ. Bʋdɛ anɩ kɩ́ɩ fɛ́ akúfa ánɩ́ bapʋ́ bɛya ɔmɔkpá.” ");
INSERT INTO nkoNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Támɛ ɩ́nɩ fɛ́ɛ́tɔ́ a, ɔdwɛ ámʋ́ʋ́ Kristo bʋ ha anɩ ámʋ sʋ anɩlagyi ɩsʋ dáfá. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Tsúfɛ́ nhɩ́ɛ́ nyin ánɩ́ tɔtɔ mɛ́ɛtalɩ́ ká ɔdwɛá Bulu bʋ ha anɩtɔ. Lowu o, nkpa o, Bulu-abɔpʋ o, túmi kugyíkʋá ɩtráa dɛ iwíe gyí ɔsʋ́sʋ́ o, atɔ́á ɩbʋ nʋ séi pʋ́ mʋ́á ɩbɛ́ba o. ");
INSERT INTO nkoNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Tógyítɔ́á ɩbʋ ɔsʋ́ pʋ́ asɩ ntɛ́ɛ ɔsʋlʋ́ʋ ayasɩ kʋkʋʋkʋ mɛ́ɛtalɩ́ ká ɔdwɛ ámʋ́ʋ́ Bulu ladwɛ́ anɩ tsʋn anɩ Wíe Kristo Yesusʋ ámʋtɔ ɛkɛkɛɛkɛ. ");
INSERT INTO nkoNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mɩ́a Kristonyɔ anɩlabwɛ́ kʋlɛ. Mʋ́ sʋ ɔnɔkwalɩ asʋ́n ndɛblɩ́ séi. Ɔŋɛ Wankɩ́hɛ́ dɛ́ mɩ́ kpa. Mʋ́ sʋ mɩ́ klʋn ɛ́ dɛ mɩ́ bláa ánɩ́ mmɛdɛ́ afunu wa. ");
INSERT INTO nkoNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Mɩ́ pɩ Israelfɔ sʋ asʋ́n ɩhɩ́ɛ́ dɛ mɩ́ háan, ahʋmɩtɩá ɩmɛká itin dɛ mɩ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nɩ́ ɩbɔ́wa alɛ́á nénya ɩlwɩɩ́, mɩ́a Kristonyɔ nsɩnɛ́ béyintá, mɛ́nɩ bénya nkpa ánɩ́ ɩtamatá kʋ́ráá á, tɛkɩ nɔ́pʋ ɩwɩ há. ");
INSERT INTO nkoNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Mɩ́ pɩ Israelfɔ gyí ahá ánɩ́ Bulu lɛ́lɛ pʋ́bwɛ́ mʋ abí. Amʋ́ ɔlɛlɛ mʋ numnyam súná. Ɔlɛka ntam há amʋ́, pʋ́ mʋ mbla wá amʋ́ ɩbɩtɔ. Olosuná amʋ́ ɔkpa ánɩ́ bɔ́pʋtswɛ mʋ. Ɔlɛbláa amʋ́ tɔ́á alahɩ́ɛ́ ánɩ́ ɔbɔ́pʋhá amʋ́ fɛ́ɛ́. ");
INSERT INTO nkoNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Amʋ́ lɛ́lɩn tsu Israelfɔ anáin akpɔnkpɔntɩ ámʋtɔ. Mʋ́á ɩdʋn kʋ́ráá á, amʋ́tɔ́ Kristo amʋ lɛ́bɛlɩn ɔsʋlʋ́ʋ anfɩsʋ. Kanfʋ́ letsiá Kristo, (ɔhá ámʋ́ʋ́ Bulu ladá mʋ ofúli amʋ), ogyi Bulu, atɔ́ fɛ́ɛ́sʋ́ ogyípʋ́ amʋ brɛ́ fɛ́ɛ́tɔ́! Amen! ");
I