﻿USE sofia;
DROP TABLE IF EXISTS sofia.nkn_vpl;
CREATE TABLE nkn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nkn_vpl WRITE;
INSERT INTO nkn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Livulu lia vakukuluila va Yesu Kilistu, muna Ndaviti, muna Avilahama. ");
INSERT INTO nkn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Avilahama uapuile ishe ya Isake, kaha Isake uapuile ishe ya Yakomba, kaha Yakomba uapuile ishe ya Yunda na vamunaina, ");
INSERT INTO nkn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","kaha Yunda uapuile ishe ya Peleze na Zela vaje vaina vapuile Tamale, kaha Pelezi uapuile ishe ya Hezelone, kaha Hezelone uapuile ishe ya Lama, ");
INSERT INTO nkn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","kaha Lama uapuile ishe ya Aminandave, kaha Aminandave uapuile ishe ya Naheshone, kaha Naheshone uapuile ishe ya Salemone, ");
INSERT INTO nkn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","kaha Salemone uapuile ishe ya Mbouasi uje vaina vapuile Luhave, kaha Mbouasi uapuile ishe ya Ovende uje vaina vapuile Lute, kaha Ovende uapuile ishe ya Njesi, ");
INSERT INTO nkn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kaha Njesi uapuile ishe ya muene Ndaviti. Kaha Ndaviti uapuile ishe ya Solomoni uje vaina vapuile te mpuevo ya Uliya, ");
INSERT INTO nkn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","kaha Solomoni uapuile ishe ya Lehovouame, kaha Lehovouame uapuile ishe ya Aviya, kaha Aviya uapuile ishe ya Asa, ");
INSERT INTO nkn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kaha Asa uapuile ishe ya Njosefati, kaha Njosefati uapuile ishe ya Njeholame, kaha Njeholame uapuile ishe ya Uziya, ");
INSERT INTO nkn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","kaha Uziya uapuile ishe ya Yotame, kaha Yotame uapuile ishe ya Ahaze, kaha Ahaze uapuile ishe ya Hezekiya, ");
INSERT INTO nkn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kaha Hezekiya uapuile ishe ya Manase, kaha Manase uapuile ishe ya Amoni, kaha Amoni uapuile ishe ya Yosiya, ");
INSERT INTO nkn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kaha Yosiya uapuile ishe ya Yehoyakine na vamunaina, ha ntsimbu ije vavatualele ku vunzinda mu lifuti lia Mbambilone. ");
INSERT INTO nkn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kaha kuhuma hakuvatuala ku Mbambilone, Yehoyakine uapuile ishe ya Sheyaletiyele, kaha Sheyaletiyele uapuile ishe ya Zelumbambele, ");
INSERT INTO nkn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kaha Zelumbambele uapuile ishe ya Aviyunde, kaha Aviyunde uapuile ishe ya Eliakime, kaha Eliakime uapuile ishe ya Azole, ");
INSERT INTO nkn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","kaha Azole uapuile ishe ya Zandoke, kaha Zandoke uapuile ishe ya Akime, kaha Akime uapuile ishe ya Eliunde, ");
INSERT INTO nkn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","kaha Eliunde uapuile ishe ya Eliazale, kaha Eliazale uapuile ishe ya Matane, kaha Matane uapuile ishe ya Yakomba, ");
INSERT INTO nkn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kaha Yakomba uapuile ishe ya Yosefa uje uapuile yala lia Maliya uje uasemene Yesu, uje ivatumbula Kilistu. ");
INSERT INTO nkn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kaha honi vikota vioshe kuhuma kuli Avilahama nakutuala kuli Ndaviti viapuile likumi na viuana, kaha kuhuma kuli Ndaviti kutuala noho vavatualele ku Mbambilone viapuile vikota likumi na viuana, kaha kuhuma hakuvatuala ku Mbambilone kuneha noho kuli Kilistu viapuile vikota likumi na viuana. ");
INSERT INTO nkn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Honi kusemuka ca Yesu Kilistu cezile mucifua eci. Omo vaina Maliya vamulamene kuli Yosefa, kaha te kanda valimoneho vamumuene nguavo akemita lizimo lia nzili yaku Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kaha Yosefa uje uamulamene hakupua ua vusunga, katondele kumuvuisa shuamua kaha uasinganiekele kuviana vulo muvushueke. ");
INSERT INTO nkn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Vuno honi te acili nakusinganieka eci, taleni, kangelo ua Muene uasholokele kuli ikeye mu cilota nakuhandeka nguendi, “Yosefa, muna Ndaviti keti uteue kuambata Maliya mpueyove, omuo eci kuimita cali naco cinapu caku Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Akasema muana ua yala, kaha ukamuluka lizina liendi Yesu, omuo ikeye akovola vantu vendi ku vipi viavo.” ");
INSERT INTO nkn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vioshe evi vialingiuile mukushulisisa vije viahandekele Muene kuhitila muli kananguizi ua Njambi nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Taleni, mpuevo uje kanda alimone na yala akemita kaha akasema muana ua yala, kaha lizina liendi vakamutumbula Manuuele” (kulumbununa Njambi ali netu.) ");
INSERT INTO nkn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Omo Yosefa uahindukile mutulo, ualingile ngue muje muamushikile kangelo ua Muene. Uambatele mpueyendi, ");
INSERT INTO nkn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","vuno honi kalimuene nendi kuvanga noho hasemenene muana ua yala, kaha uamulukile lizina liendi Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Honi omo Yesu uasemukile mu Mbetelehema ku Yundeya mu matangua a muene Helonde, taleni vaka mana vahumine ku ngangela vezile ku Yelusalema, ");
INSERT INTO nkn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","vehuile nguavo, “Ali kuli ou nasemuka muene ua Vayunda? Tunamono ntanga tanga yendi mu ngangela, kaha tuneja nakumulemesa.” ");
INSERT INTO nkn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Omo muene Helonde uevuile eci, ualiniengele cikuma, hamo navoshe vaje vakele nendi mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaha uakunguluile vakuluntu voshe va tusasendote na valongisi va mezi a lishiko, kaha uavehuile kuje Kilistu napande kusemukila. ");
INSERT INTO nkn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Vamulekele nguavo, “Mu Mbetelehema ku Yundeya,” omuo omu mukemo muvavisonekelele kuli kananguizi ua Njambi, ");
INSERT INTO nkn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Nove Mbetelehema, mu nganda ya Yundeya, keti usinganieke nguove u uamundende hhakati kavaka kuyula vamu Yundeya, omuo kuli yove kukahuma muka kuyula uje akatuamenena vantu vange va Isaleli.’” ");
INSERT INTO nkn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Amba honi Helonde uasanene vaka mana muvushueke, uavehuisisile ntsimbu muka ije ntanga ntanga yasholokele. ");
INSERT INTO nkn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kaha uavatumine ku Mbetelehema uavalekele nguendi, “Yeni mukatondesese cikuma ha kanike ou, kaha omo muamuuana, muije muakunjileke linga nange naua njije nakumulemesa.” ");
INSERT INTO nkn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Omo vevuile vije via handekele muene kaha vaile, kaha taleni, ntanga ntanga ivamuene mu ngangela yakele kulutue luavo noho yezile nakutulila ha cihela cije hakele muana. ");
INSERT INTO nkn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Omo vamuene ije ntanga ntanga, vavuahelelele cikuma na nzolela yakama. ");
INSERT INTO nkn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kaha omo vakovelele mu njivo vamuene muana na vaina Maliya, kaha vatsikamene ha mavuli avo nakumulemesa. Ambahoni vafukuile mu viambatelo viavo via vufuko nakumuhana mavuana a seho a ngolinde na mazi a kunika luengo luacili a fulankininsense na miila. ");
INSERT INTO nkn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kaha hanima yakuvanangula mu cilota linga keti vahiluke kuli Helonde, vahilukile ku cifuti cavo na ngila yeka. ");
INSERT INTO nkn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Honi omo vaile, kaha taleni, kangelo ua Muene uasholokele kuli Yosefa mu cilota kaha auhandekele nguendi, “Hinduka ambata muana na vaina, kaha teuela ku Ingito, kaha yakakale kuje noho njikakuleka, omuo Helonde alinakutonda muana linga a mutsihe.” ");
INSERT INTO nkn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ambahoni uahindukile nakuambata muana na vaina ha vutsiki vuje vene nakuya ku Ingito. ");
INSERT INTO nkn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Vakele kuje noho Helonde uatsile. Cije capuile kushulisisa vije viahandekele Muene kuhitila muli kananguizi ua Njambi nguendi, “Njasanene munange uje uakele mu Ingito.” ");
INSERT INTO nkn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ambahoni Helonde omo uamuene nguendi vaka mana vanamukuisa, uanienguele cikuma, kaha uashikile linga vatsihe vanike voshe vava mala mu Mbetelehema na mu vihela viakulihatako voshe vaje vakele na miaka ivali na vaje vakele muintsi lia miaka ivali yakusemuka, kuya ku ntsimbu ije yalilongesele ku vaka mana. ");
INSERT INTO nkn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ambahoni vialishulisile vije viahandekele kananguizi ua Njambi Njelemiya nguendi: ");
INSERT INTO nkn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Vovuile Lizi mu Lama lizi lia kulila na kulinienga cikuma, Lakele alilila muomu ya vana vendi, katavele kumuzembeleka, muomu voshe vatsile.” ");
INSERT INTO nkn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Vuno honi omo Helonde uatsile, taleni, kangelo ua Muene uasholokele mu cilota kuli Yosefa mu Ingito, ua handekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hinduka ambata muana na vaina linga muye ku cihela ca Isaleli, muomu vaje vasinganiekele kutsiha muana vanatsi.” ");
INSERT INTO nkn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kaha uahindukile nakuambata muana na vaina nakuya ku cihela ca Isaleli. ");
INSERT INTO nkn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Vuno honi omo uevuile ngeci Alekelau nasuana Yundeya mu cihela ca ishe Helonde, kaha uateuele kuya kuje. Kaha honi hakumunangula mu cilota, kaha uaile ku cihela ca Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaha uaile nakukala mu mbonge ivasana Nazaleta, linga vije vivahandekele tunanguizi va Njambi vilishulisise nguavio, “Vaka mutumbula Kanazaleta.” ");
INSERT INTO nkn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu matangua aje kuezile Iuano muka kumbuitika, uakele nakuambulula mu mpambo ya Yundeya, ");
INSERT INTO nkn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nguendi “Tengulukeni, muomu vumuene vua muilu vuli muyehi.” ");
INSERT INTO nkn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Omuo ou ikeye ivahandekele kuli Kananguizi ua Njambi Isaya, omo uahandekele nguendi, “Lizi lia umo ali nakutambeka mu mpambo ngualio, Vuaheseni ngila ya Muene kaha sungameseni ngila yendi.” ");
INSERT INTO nkn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Honi Iuano uazalele vuzalo vuakupanga ha maka a kamelu kaha ualikutile muiva ua cilambu mu mbunda yendi, na viakulia viendi viapuile vambimba na vuci. ");
INSERT INTO nkn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vantu vezile kuli ikeye kuhuma ku Yelusalema na ku Yundeya yoshe, na ku vihela vioshe viakulihata na ndonga ya Yundau. ");
INSERT INTO nkn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Valitavelele vipi viavo kaha uavambuitikile mu ndonga ya Yundau. ");
INSERT INTO nkn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Vuno honi omo uamuene Vafaliseo na Vasanduki vavengi valinakuija mukuvambuitika, kaha uahandekele kuli vakevo nguendi, “Yeni vana vamanoka iya naminangula linga muteue ku vutenu ovu vuli nakuija? ");
INSERT INTO nkn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imeni vushuka vuje vumuesa ngeci muatenguluka. ");
INSERT INTO nkn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kaha keti musinganieke ngueni muhasa kuhandeka kuli yeni vavenia ngueni, ‘Tuli na Avilahama tatetu’, omuo njimileka nguange, Njambi asa kupuisa aua mavue kupua vana va Avilahama. ");
INSERT INTO nkn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Cipue hano vene ngimbu inalivuahesela laja kuteta miti kuputukila ku mizi, nankuma muti uoshe uje kuuimi vushuka vuacili vakauteta nakuumbila mu tuhia. ");
INSERT INTO nkn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yange njimimbuitika na mema linga cipue cimueso ngeci munatenguluka, vuno honi ou eja munima yange anjipulakana ku nzili, kunjafuililile cipue kuambata vinkaku viendi, ikeye akamimbuitika na Cimbembesi Uakulela na tuhia. ");
INSERT INTO nkn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Lisehua liendi lili mu livoko liendi, kaha akakomba ku lijunguilo liendi, kaha akakunguluila tiliku mu cishete cendi, vuno honi mujungu akautsimika na tuhia tuakuhona kuhua.” ");
INSERT INTO nkn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ambahoni Yesu uahumine ku Ngalileya nakuya ku ndonga ya Yundau linga vakamumbuitike kuli Iuano. ");
INSERT INTO nkn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vuno honi Iuano uatondele kumuvindika kaha uahandekele nguendi, “Yange capande kunjimbuitika kuli yove, nkuma naua yove uija kuli yange?” ");
INSERT INTO nkn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Vuno honi Yesu uamukumbuluile nguendi, “Cilingiue ngoco vene hano, cacili kuli yetu kushulisisa vije vioshe Njambi atonda kuli yetu.” Ambahoni Iuano uatavele. ");
INSERT INTO nkn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hanima yakumbuitika Yesu, kaha hajevene uahumine mu mema, kaha taleni, melu ashokolokele kaha uamuene Cimbembesi ca Njambi cishuluka ngue livembe nakumutonkama. ");
INSERT INTO nkn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaha lizi liahumine muilu ngualio, “Ou ikeye Munange injazanga, muli ikeye njivuahelela.” ");
INSERT INTO nkn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ambahoni Yesu vamutualele kuli Cimbembesi mu mpambo linga vakamueseke kuli Liyavolo. ");
INSERT INTO nkn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ualiuminine kulia ha matangua makumi auana vutsiki na mutania, kaha hanima yakuliumina kulia uevuile njala. ");
INSERT INTO nkn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kaha muka kumueseka uezile kuli ikeye nakuhandeka nguendi, “Nga u Muna Njambi, shika aua mavue linga ahimpuke mbolo.” ");
INSERT INTO nkn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Vuno honi Yesu uamukumbuluile nguendi, “Vanacisoneka nguavo, ‘Muntu kasa kuyoya na mbolo lika kuahi, vuno honi na mezi oshe aje Njambi ahandeka.’” ");
INSERT INTO nkn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ambahoni Liyavolo uamutualele mu nganda yakulela, uamuhakele helu lia kashongua ka Njivo ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kaha uahandekele kuli ikeye nguendi, “Nga u Muna Njambi,” “liumbile ha mavu. Muomu vanacisoneka nguavo, “‘Akashika tungelo vendi hali yove, kaha vakakukavuila na mavoko avo, linga viliato viove keti vikansunsuke ku mavue.’” ");
INSERT INTO nkn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu uamukumbuluile nguendi, “Vanacisoneka naua nguavo, ‘Keti ueseke Muene Njambi yove.’” ");
INSERT INTO nkn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kaha naua Liyavolo uamutualele ku munkinda ualaha cikuma, uamumuesele vumuene vuoshe vua hano ha mavu na vumpau vuavuo. ");
INSERT INTO nkn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kaha uahandekele kuli Yesu nguendi, “Vioshe evi njikakuhanavio, nga ukatsikama ha mavu na kunjilemesa.” ");
INSERT INTO nkn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu uamukumbuluile nguendi, “Huma kuli yange Satana! Omuo vanacisoneka nguavo, ‘Ukalemesa Muene Njambi yove na kumupangela ikeye lika!’” ");
INSERT INTO nkn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ambahoni Liyavolo uamusezele, kaha tungelo vezile nakumukuasa. ");
INSERT INTO nkn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Omo Yesu uevuile nguendi Iuano vanamukutu, kaha uaile ku Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kaha hakuhuma mu Nazaleta uaile nakukakala mu Kapenauma kuyehi na mema a kalunga a Ngalileya, mu nginga ya Zembuloni na Nafetali, ");
INSERT INTO nkn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","linga cije cahandekele kananguizi ua Njambi Isaya cilishulisise nguendi: ");
INSERT INTO nkn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Cihela ca Zembuloni na cihela ca Nafetali, vije viakala mu ngila yakuya ku mema a kalunga, kulutue lua Yundau, Ngalileya, lifuti lia vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vantu vaje vakala mu milima vanamono ceke cakama. Kaha na vaje vakala mu cihela na mu cimbembe ca kutsa, ceke cinavatuila.” ");
INSERT INTO nkn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuhuma ha ntsimbu ije Yesu uaputukile kuambulula nguendi, “Tengulukeni ku vipi vieni, omuo vumuene vua muilu vuli muyehi.” ");
INSERT INTO nkn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Omo Yesu uakele nakuenda kucikulo ca cisali ca Ngalileya, uamuene vamunaina vavali, Simoni uje ivatumbula Petulu namunaina Anduleo, vatele manda avo mu cisali, omuo vapuile vakakuta vantsi. ");
INSERT INTO nkn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kaha uahandekele kuli vakevo nguendi, “Njikaveni, kaha njikamipuisa vakakuta vantu.” ");
INSERT INTO nkn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kaha hajevene vasezele manda avo nakumukava. ");
INSERT INTO nkn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Omo uakele nakutualelelaho kuya kaha naua uamuene muntu mukuavo na munaina, Tiango muna Zembendeo na munaina Iuano mu vuato hamo na ishavo Zembendeo vakele nakutungulula manda avo, kaha uavasanene. ");
INSERT INTO nkn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kaha hajevene vasezele vuato na ishavo, kaha vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu uahitanganene mu Ngalileya muoshe, nakulongesa muvi njivo viavo via malombelo, na kuambulula muzimbu uacili ua vumuene nakukanguisa mishongo yoshe ya vantu yakuliseza seza na vakakuvavala. ");
INSERT INTO nkn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kutsimana cendi cevuikile naku Siliya kuoshe, kaha vamunehelele vaka kuvavala voshe, na vaka mishongo yakuli seza seza na kuvua kuvavala, na vaka mahamba, na vaka kushinia, na vaka tulepa, kaha voshe uavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaha vivunga viakama via vantu kuhuminina mu Ngalileya, namu Ndekapolisi na ku Yelusalema, na ku Yundeya, na musinia lia ndonga ya Yundau, viamukavele. ");
INSERT INTO nkn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Omo Yesu hakumona vivunga via vantu, kaha ualondele cindende ha munkinda, kaha omo uatumamene ha mavu vandongisi vendi vezile kuli ikeye, ");
INSERT INTO nkn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kaha uaputukile kuvalongesa nakuhandeka nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Vakukuisula vaje vanapu vihutu mu Cimbembesi, muomu vumuene vua muilu vunapu vuavo.” ");
INSERT INTO nkn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Vakukuisula vaje valinakulila, muomu vaka vazembeleka!” ");
INSERT INTO nkn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Vakukuisula vaje valikehesa, muomu vakasuana mavu!” ");
INSERT INTO nkn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Vakukuisula vaje vevua njala na mpuila muomu ya vusunga, muafua vakakuta!” ");
INSERT INTO nkn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Vakukuisula vaje vali na cikeketima, muomu navo vakavevuila cikeketima!” ");
INSERT INTO nkn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Vakukuisula vaje na lele mu mitima, muomu vakamona Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Vakukuisula vaje vakakulinga ciyulo, muomu vakavasana vana va Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Vakukuisula vaje vavalinakupakesa muomu ya vusunga, muafua vumuene vua muilu vunapu vuavo!” ");
INSERT INTO nkn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Munapu vakukuisula omo vantu vamishaula nakumipakesa nakuhandeka viuma vioshe via vipi via makuli hali yeni muomu yange.” ");
INSERT INTO nkn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Joleleni nakuvuahelela muomu vuana vueni vukapua vuakama cikuma muilu, muafua omu mukemo vantu vayandesele tunanguizi va Njambi vaje vakeleko tele kanda yeni. ");
INSERT INTO nkn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yeni munapu muongua uaha mavu, vuno honi nga muongua unashamuka, kaha vatihoni kutovala cauo cikahiluka? Ku ukapu naseho naua ku cuma coshe kuvanga lika vaumbile kuti kaha na vantu vakauliatangela.” ");
INSERT INTO nkn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yeni mu ceke ca vaka mavu. Nganda yakutungila ha munkinda kuyasa kulishueka.” ");
INSERT INTO nkn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nankuma naumo uahi asa kushuameka ndeya naku ihaka muintsi lia muhela, vuno honi aihaka ha citumbiko, kaha ituila ceke kuli voshe vaje vali mu njivo. ");
INSERT INTO nkn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mucifua cimo vene eceleni ceke ceni citue ku vantu, linga vamone vipangi vieni viacili, kaha vakahana vumpau kuli Ishueni uje ali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Keti musinganieke ngueni njineja nakumanusula Lishiko lia Mosesa, cipue vilongesa via tunanguizi va Njambi, kunjezile nakuvimanusula vuno honi nakuvishulisisa. ");
INSERT INTO nkn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Muavusunga njimileka nguange kuvanga lilu na mavu vinahiti, nacimo cahi cikahita keti cipue cisona, cipue citoma kuhuma ku Lishiko, kuvanga noho viuma vioshe vanavimanusula. ");
INSERT INTO nkn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nankuma uoshe uje kononoka cipue koma kakandende kaku mashiko aua kaha acilongesa na vakuavo naua linga vacilinge kaha vakamutumbula uamundende mu vumuene vua muilu, vuno honi uoshe uje aniunga na kulongesa mashiko aua vakamutumbula uakama mu vumuene vua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nankuma njimileka nguange, nga vusunga vueni kuvupulakana vusunga vua valongisi va mezi a lishiko lia Mosesa na Vafaliseo, kaha kumuka kovela mu vumuene vua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muevuile muje muvalekele vantu va kunsenkulu nguavo, ‘Keti mukatsihe, kaha uoshe uje atsiha mukuavo vaka musompesa.’” ");
INSERT INTO nkn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Vuno honi njimileka nguange uoshe uje anienguela munaina vanapande kumusompa, kaha uoshe uje atuka munaina vaka musompa ku nzango, kaha na uoshe uje ahandeka mukuavo nguendi yove cilema, vakamutuala mu ngehena ya tuhia. ");
INSERT INTO nkn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nankuma nga utonda kulambula vuana vuove ha mutula, kaha nga uanuka mulonga uje u uapihisilile mukueni, ");
INSERT INTO nkn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","seza vuana vuove ha mutula kaha yatahi ukalisambuese nendi, kaha kuhuma oho hiluka ukalambuile vuana vuove. ");
INSERT INTO nkn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Lisambuese vuasi vuasi nauje yunapihisila oku muli nakuya hamo ku nzango, kuteua yunapihisila akakutuala kuli lihako, kaha lihako akakuhana kuli lisualale, kaha lisualale akakuhaka mu kamenga.” ");
INSERT INTO nkn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Muavusunga njikuleka nguange, kukahumumo kuvanga noho ukamanusula kufueta kambongo ka mamanusuilo ku mulonga uove. ");
INSERT INTO nkn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muevuile muje vacihandekele nguavo, ‘Keti mulinge vupangala.’ ");
INSERT INTO nkn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Vuno honi njimileka nguange, uoshe uje atala mpuevo ntoma na lishungu lia lipi na lingi laja nendi vupangala mu mutima uendi. ");
INSERT INTO nkn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nga lisho liove liaku cilio likusevuisa kulinga vupi, licokovolemo uliumbile kuti! Muomu cacili kuli yove cilio cove cimo ca muvila cinonge kupulakana kumbila muvila uove uoshe mu ngehena. ");
INSERT INTO nkn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kaha nga livoko liove lia cilio likusevuisa kulinga vupi, livatule, kaha liumbile kuti! Muomu cacili kuli yove cilio cove cimo ca muvila cinonge kupulakana kumbila muvila uove uoshe mu ngehena. ");
INSERT INTO nkn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kaha naua vacihandekele nguavo, ‘Uoshe uje akondola mpuevo yendi, napande kumuhana mukanda uakutsiha vulo.’ ");
INSERT INTO nkn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Vuno honi yange njimileka nguange, uoshe uje akondola mpuevo yendi, kuakuhona mulonga ua vupangala, amupuisa ngue nalingi vupangala, kaha na uje uoshe akamuambata akapua lika lipangala. ");
INSERT INTO nkn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Naua muevuile muje valekele vakukuluila kunsenkulu nguavo, ‘Keti upokole cisingo cove, vuno honi linga vije viualisingile ku mesho a Muene.’ ");
INSERT INTO nkn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Vuno honi njihandeka kuli yeni nguange keti mukalisingeho, cipue na lilu, omuo liapua litanda lia Njambi, ");
INSERT INTO nkn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","cipue na mavu, omuo apua ha cituamo ca vialiatelo vuendi, cipue na Yelusalema, omuo yapua nganda ya Muene uakama. ");
INSERT INTO nkn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kaha naua keti ulisinge na mutue uove, omuo kuuasa kutokesa cinkambu cimo cipue kucizivalesa. ");
INSERT INTO nkn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kuhandeka ceni kupue ‘Eyo’ cipue ‘houe’ omuo coshe cakupulakana eci cihuminina kuli citozi. ");
INSERT INTO nkn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muevuile muje vahandekele nguavo, ‘Lisho ku lisho, kaha lizo ku lizo.’ ");
INSERT INTO nkn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Vuno honi njihandeka kuli yeni nguange keti muhiluisile vupi ku muntu uje akupihisila. Vuno honi nga muntu akupupa ku litama liove lia cilio, mutenguluisile naua ku litama likuavo. ");
INSERT INTO nkn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kaha nga muntu atonda kukusompesa ngeci akunieke cikovelo cove, muhane naua na kazaku kove. ");
INSERT INTO nkn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kaha nga muntu akusindiya ngeci uende nendi vungenzi vua ntunda imo, enda nendi vungenzi vua vintunda vivali. ");
INSERT INTO nkn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Uoshe uje akulomba muhane, uoshe uje akulomba mukuli keti umumine. ");
INSERT INTO nkn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Munevu muje vahandekele nguavo, ‘Zanga mukueni, kaha zinda citozi cove.’ ");
INSERT INTO nkn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Vuno honi njimileka nguange, zangeni vitozi veni, kaha lombeleleni vaje valinakumipakesa, ");
INSERT INTO nkn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","linga mupue vana va Ishueni uje ali muilu. Omuo ikeye akatuisa litangua liendi kuli vaka vupi na kuli vaka vacili, kaha akanokesa kalunga kuli vaka vusunga na kuli vaka kuhona vusunga. ");
INSERT INTO nkn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Muomu nga muzanga lika vaje vamizanga, kaha vuana muka mukauana? Nkuma omu keti mukemo muvakalingila vaka kutambula lisimu ndi? ");
INSERT INTO nkn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kaha nga mulihinduisa lika na vamuanoko, kaha mualisezela haka na vakueni? Nkuma omu keti mukemo muvakalingila na vaje keti Vayunda ndi? ");
INSERT INTO nkn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nankuma yeni munapande kupua vaka kusungama, ngue muje Ishueni ua muilu uapua uakusungama.” ");
INSERT INTO nkn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Zangameni linga keti mulinge vucili vueni ku mesho a vantu, ngeci vamimone, nga mucilinga eci kaha kuvakamihana vuana kuli Ishueni ua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaha nga uhana uje nahonoua, keti usike tolombita, ngue muje muvakalingila vaka civembulu mu vinjivo via malombelo na mu vitapalo, linga vavashangazale ku vantu. Muavusunga njimileka nguange, vanatambula laja vuana vuavo. ");
INSERT INTO nkn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Vuno honi omo ukuasa vaje vanahonua, keti utavese livoko liove lia cimoshue lizivuke vije livoko liove liacilio vililinakulinga, ");
INSERT INTO nkn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","linga kukuasa ceni kuli vaje vanahonua cipue ca vushueke, kaha Ishueni uje amona vije vili mu vushueke akamihana vuana. ");
INSERT INTO nkn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kaha omo mulombela, keti mulombele ngue vaka civembulu, muomu vakevo vazanga kuimana nakulombela mu vinjivo via malombelo na mu vitapalo, linga vantu vavamone. Muavusunga njimileka nguange, vanatambula laja vuana vuavo. ");
INSERT INTO nkn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vuno honi omo ulombela, ya mu mulili uove, shoka ku cikolo kaha lombela kuli Isho uje ali mu vushueke. Kaha Isho uje amona via mu vushueke akakuhana vuana. ");
INSERT INTO nkn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kaha omo mulombela, keti muhandeke cikuma ngue muje muvakalingila vaje keti Vayunda, muomu vakasinganieka nguavo vakavevua omuo ya mezi avo akuhona seho. ");
INSERT INTO nkn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Keti mupue ngue vakevo, muomu Ishueni azivuka laja vije vimutonda kanda mumulombe. ");
INSERT INTO nkn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lombeleni ngueni, “‘Tatetu uli muilu, Valemese lizina liove, ");
INSERT INTO nkn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Vumuene vuove vuije, Cizango cove vacilinge hano ha mavu, ngue muje vacilinga muilu. ");
INSERT INTO nkn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tuhane lelo kulia cetu caha litangua na litangua, ");
INSERT INTO nkn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tukonekele ku milonga yetu, ngue muje yetu tukakonekela vaka kutuvulumuina. ");
INSERT INTO nkn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Keti ututuamenene ku vieseko viakama, vuno honi tuohiele ku citozi!’ ");
INSERT INTO nkn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Omuo nga mukonekela vantu vaje vanamipihisila, kaha neni naua vakamikonekela kuli Ishueni ua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vuno honi nga kumukonekela vantu vaje vamipihisila, neni naua Ishueni kakamikonekela ku milonga yeni. ");
INSERT INTO nkn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kaha omo muliumina kulia, keti mulimuese ngue muazeye, ngue muje muvakalingila vaka civembulu muje muvaka pihisa kuvihanga viavo, linga ku liumina kulia cavo vacizivuke ku vantu. Muavusunga njimileka nguange vanatambula laja vuana vuavo mukushula. ");
INSERT INTO nkn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Vuno honi omo muliumina kulia, likuiteni mazi ku mitue yeni kaha taneni ku mesho eni, ");
INSERT INTO nkn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","linga kuliumina kulia ceni keti vacizivuke ku vantu vuno honi vacizivuke kuli Ishueni uje ali muvushueke, kaha Ishueni uje amona muvushueke akamihana vuana. ");
INSERT INTO nkn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Keti mulitulikile vufuko vua hano ha mavu, vuje tuntembulu na nkalaue vakavupihisa, naua vuje vezi vatuva nakuiva. ");
INSERT INTO nkn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vuno honi litulikileni vufuko vua muilu, vuje tuntembulu na nkalaue kuvasa kuvupihisa, cipue vezi kuvasa kuvutuva na kuvuiva. ");
INSERT INTO nkn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Omuo kuje kuli vufuko vuove, kukeko naua kukakala mutima uove. ");
INSERT INTO nkn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mesho akeuo ndeya ya muvila. Nankuma nga mesho ove amona muacili, na muvila uove uoshe ushula na ceke. ");
INSERT INTO nkn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Vuno honi nga mesho ove akutsitsivala, muvila uove uoshe ukashula na milima. Nga ceke cije cili muli yove cinapu milima, kaha milima ikapua yaingi cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Naumo uahi asa kupangela vimiene vavali, akazindaho umo nakuzangaho mukuavo, akalihana kuli umo nakusembulula mukuavo. Kuuasa kupangela Njambi na vimbongo. ");
INSERT INTO nkn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nankuma, njimileka nguange, keti mulinienge ha vuyoye vueni, vika mukalia cipue ngueni vika mukanua, cipue ngueni vika tukazala ha mivila yetu. Nkuma miono yeni keti ya seho kupulakana viakulia, cipue mivila yeni kupulakana vuzalo ndi? ");
INSERT INTO nkn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Taleni tuzila va muilu, kuvekukuna cipue kuteja cipue kutulikila mu vishete, vuno honi Ishueni ua muilu alinakuvalisa. Nkuma keti yeni muli na seho yakama kupulakana tuzila ndi? ");
INSERT INTO nkn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kaha iya hhakati keni muomu yakulinienga asa kuvuezelelako hola imo ku muono uendi? ");
INSERT INTO nkn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nkuma vika mulinienga ha vuzalo? Taleni vinsani via mu lihia muvikakolo, vikevio ku viekupanga cipue kulitongela vuzalo. ");
INSERT INTO nkn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vuno honi njimileka nguange, cipue Solomoni mu vumpau vuendi vuoshe, kazaleleho vuzalo vuacili ngue vua vinsani evi. ");
INSERT INTO nkn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kaha nga Njambi azika muila ua mu lihia uje ukalako lelo lika, imene vaumbila mu tuhia, nkuma kasa kumizika muacili ndi? Yeni vantu va lutsilielo lua lundende! ");
INSERT INTO nkn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nankuma keti mulinienge ngueni, ‘Tukalia vika?’ Cipue ‘Tukanua vika?’ Cipue ‘Tukazala vika?’ ");
INSERT INTO nkn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Omuo viuma vioshe evi vakavitondo vaje keti Vayunda. Vuno honi yeni Ishueni ua muilu azivuka nguendi muvitonda vioshe. ");
INSERT INTO nkn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vuno honi tondeni tahi vumuene vuendi na vusunga vuendi, kaha viuma vioshe evi akamihanavio. ");
INSERT INTO nkn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nankuma keti mulinienge via imene, omuo imene likalinienga likelio vavenia. Muomu litangua na litangua lili na tuyando tualio tuakupuamo.” ");
INSERT INTO nkn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Keti musompe vakueni, linga neni keti vamisompe. ");
INSERT INTO nkn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Muomu kusompa cije musompa naco vakueni, cikeco civakamisompa naco, kaha seteko ije museteka nayo vakueni, ikeyo ivaka miseteka nayo. ");
INSERT INTO nkn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Vika umuena cishoni cili ha lisho lia muanoko, vuno honi ku umono mukambo uje uli mu lisho liove? ");
INSERT INTO nkn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Cipue vika uhandeka kuli muanoko nguove, ‘Teua njikuhumise cishoni cili mu lisho liove,’ vuno honi yove ulina mukambo mu lisho liove? ");
INSERT INTO nkn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yove muka civembulu! Hakulivanga humisa tahi mukambo uje uli mu lisho liove, ambahoni umone muacili hakuhumisa cishoni cije cili mu lisho lia muanoko. ");
INSERT INTO nkn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Keti muhane vije via kulela ku tutali, muomu vaka mitengulukila nakumiluisa. Keti mumbile vusanga vueni kulutue lia vangulu, muomu vaka vuliatangela na viliato viavo. ");
INSERT INTO nkn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Lombeni, kaha muka tambula, tondeni, kaha mukauana, toteni ha cikolo, kaha vaka mishokoluela. ");
INSERT INTO nkn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Muomu uoshe uje alomba atambula, kaha uoshe uje atonda auana, kaha uoshe uje atota vaka mushokoluela cikolo. ");
INSERT INTO nkn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nkuma iya hhakati keni nga munendi amulomba mbolo, kaha ikeye amuhana livue? ");
INSERT INTO nkn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Cipue nga amulomba intsi, kaha ikeye amuhana linoka? ");
INSERT INTO nkn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kaha nga yeni vaka vupi, muzivuka kuhana mavuana acili kuli vana veni, kaha cikafua vati honi kuli Ishueni uje ali muilu uje akahana viuma viacili kuli vaje vamulomba! ");
INSERT INTO nkn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kaha vioshe vije mutonda ngueni vakueni vamilingilevio, neni naua valingilenivio, omuo eli likelio Lishiko lia Mosesa na vilongesa via tunanguizi va Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Koveleni mu cikolo ca cindende, omuo cikolo cakama na ngila yaco yapua yayasi ije ituala kukunonga, kaha na vaje vakovelamo vapua vavengi. ");
INSERT INTO nkn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Vuno honi cikolo ca cindende na ngila yaco yapua ya ikalu, ije ituala ku muono, kaha na vaje vaiuana vapua vavandende. ");
INSERT INTO nkn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Zangameni na tunanguizi va makuli, vaje veja kuli yeni mu vuzalo ngue vampanga, vuno honi mukati kavo vanapu tungunga vamu musenge. ");
INSERT INTO nkn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muka vazivukila ku vushuka vuavo. Nkuma vushuka vua viniu vaka vutomona ku muti ua vimbimbo, cipue vushuka vua mukuyu ku shaku ije ili na mambimbo ndi? ");
INSERT INTO nkn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mucifua cimo vene muti uoshe uacili ukemi vushuka vuacili, vuno honi muti ua upi ukemi vushuka vua vupi. ");
INSERT INTO nkn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muti uacili kuuasa kuima vushuka vua vupi, kaha naua muti ua upi kuuasa kuima vushuka vuacili. ");
INSERT INTO nkn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Muti uoshe uje kuuimi vushuka vuacili vaka uteta naku umbila mu tuhia. ");
INSERT INTO nkn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nankuma muka vazivukila ku vushuka vuavo. ");
INSERT INTO nkn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Keti muntu uoshe uje ahandeka kuli yange nguendi, ‘Muene, Muene,’ akakovela mu vumuene vua muilu, vuno honi kuvanga lika uje alinga cizango ca Tate uje hali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ha litangua lije vavengi vakahandeka kuli yange nguavo, ‘Muene, Muene! Nkuma kutuahandekele vunanguizi mu lizina liove, nakuhumisa mahamba mu lizina liove, kaha tualingile viuma viavingi viakukomouesa mu lizina liove?’ ");
INSERT INTO nkn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ambahoni njikahandeka kuli vakevo nguange, ‘Kunjamitantekeyele, humeni kuli yange, yeni vaka kulinga via vipi!’ ");
INSERT INTO nkn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kaha muntu uoshe uje evua aua mezi ange naku akavangeya napu ngue uje yala uakuzangama uje uatungile njivo yendi ha livu. ");
INSERT INTO nkn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kaha kalunga uanokele, na livazi liezile, kaha mpunzi yezile nakuningangesa ije njivo. Vuno honi kuyauile, muomu luvula luayo valutungilile ha livue. ");
INSERT INTO nkn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Vuno honi uoshe uje evua aua mezi ange, kaha ka akavangeya, napu ngue uje yala ua cilema uje uatungilile njivo yendi ha museke seke, ");
INSERT INTO nkn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kaha kalunga uanokele, na livazi liezile, kaha mpunzi yapekumukile nakuningangesa ije njivo, kaha yauile, kaha kuua cayo capuile cacipi cikuma!” ");
INSERT INTO nkn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kaha omo Yesu uamanusuile kuhandeka viuma evi, vivunga via vantu vialikomokelele ha kulongesa cendi. ");
INSERT INTO nkn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Muomu uavalongesele ngue uje alina nzili yakama keti ngue valongisi vavo va mezi mashiko. ");
INSERT INTO nkn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Omo Yesu uasikumukile kuhuma ha munkinda, vivunga viakama viamukavele, ");
INSERT INTO nkn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","kaha taleni, muka mbumba uezile kuli ikeye nakumutsikamena nakuhandeka nguendi, “Muene nga utonda uasa kunjilelesa.” ");
INSERT INTO nkn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kaha Yesu uoluele livoko liendi nakumukuata nakuhandeka nguendi, “Njitonda, lela.” Kaha hajevene uje yala uakangukile ku mbumba yendi. ");
INSERT INTO nkn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kaha Yesu uahandekele kuli ikeye nguendi, “Keti ukalekeko cipue umo, vuno honi ya ukalimuese kuli kasasendote, kaha ukahane vuana vuje vuashikile Mosesa, linga cipue vukaleho ku vantu.” ");
INSERT INTO nkn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Omo Yesu uakovelele mu Kapenauma, mukuluntu ua masualale va Loma uezile kuli ikeye mukumulomba vukuasi ");
INSERT INTO nkn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kaha uahandekele nguendi “Muene, ngamba yange nakosa mu njivo ali nakuvavala kalepa, kaha alinakuvua cikuma kuvavala.” ");
INSERT INTO nkn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kaha Yesu uahandekele kuli ikeye nguendi, “Njija nakumukanguisa.” ");
INSERT INTO nkn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Vuno honi uje mukuluntu ua masualale uamukumbuluile nguendi, “Muene, kucanjipandele yove kukovela mu njivo yange, vuno honi handeka lika lizi, kaha ngamba yange akakanguka. ");
INSERT INTO nkn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Muomu nange naua nji yala uje ali muintsi lia nzili yakama, kaha na masualale naua vali muintsi liange, kaha njihandeka kuli umo nguange, ‘Ya,’ kaha aya, kaha kuli mukuavo naua nguange ‘Ija,’ kaha eja, kuli ndungo yange nguange, ‘Linga eci,’ kaha acilinga.” ");
INSERT INTO nkn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Omo Yesu uevuile vije viahandekele, ualikomokelele cikuma, kaha uahandekele kuli vaje vakele naku mukava nguendi, “Muavusunga njimileka nguange, cipue mu Isaleli kunjauanene lutsilielo luangacije. ");
INSERT INTO nkn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Njimileka nguange vavengi vakeja, vakahuma mu ngangela na mu kangombe kayambi, kaha vakatumama ku ciuano hamo na Avilahama, na Isake, na Yakomba, mu vumuene vua muilu, ");
INSERT INTO nkn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","vuno honi vana va vumuene vakavombila mu milima hambanza, kuje kukakala kulila na kulishumanga ku mazo avo.” ");
INSERT INTO nkn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kaha Yesu uahandekele kuli uje mukuluntu ua masualale nguendi, “Ya, cilingiue ngoco kuli yove ngue muje munatsiliela.” Kaha ngamba yendi uakangukile ha ntsimbu ije vene. ");
INSERT INTO nkn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kaha omo Yesu uakovelele mu njivo ya Petulu, uauanene vainamueno ya Petulu vanakosa vakele nakuvavala lisika sika. ");
INSERT INTO nkn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kaha uamukuatele ku livoko liendi, kaha lisika sika liamuhumine, kaha uahindukile nakuputuka kumupangela. ");
INSERT INTO nkn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kaha kucinguezi cije vene vamunehelele vantu vavengi vaje vakele na mahamba, kaha uahumisile vimbembesi na lizi, kaha uakanguisile vakakuvavala voshe. ");
INSERT INTO nkn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eci capuile linga vilishulisise vije viahandekele kananguizi ua Njambi Isaya nguendi, “Uambatele makalu etu, kaha uambatele mishongo yetu.” ");
INSERT INTO nkn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Omo Yesu uamuene civunga cakama cinamuzengeleka, uashikile vandongisi vendi linga vaye musinia lia cisali. ");
INSERT INTO nkn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kaha mulongisi ua mashiko uezile kuli ikeye nakuhandeka nguendi, “Mulongisi, njikukavangeya kuoshe ku ukaya.” ");
INSERT INTO nkn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kaha Yesu uamukumbuluile nguendi, “Vambanje valina mena, kaha naua na tuzila va muilu valina mashua, vuno honi Muna Muntu kesi na cihela cakuhuimina.” ");
INSERT INTO nkn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kaha naua umo ua vandongisi vendi uahandekele kuli ikeye nguendi, “Muene, tahi njiye njikatsinde tate.” ");
INSERT INTO nkn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Vuno honi Yesu uahandekele kuli ikeye nguendi, “Njikave, kaha seza vatsi vatsinde vatsi vakuavo.” ");
INSERT INTO nkn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kaha omo Yesu uakovelele mu vuato, vandongisi vendi vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kaha taleni, kuakatukile mankimba akama cikuma ha cisali, kaha vuato vuakele nakuninganga na mankimba, vuno honi Yesu te nakosa. ");
INSERT INTO nkn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kaha vaile nakumuhindula nakuhandeka nguavo, “Tuovole Muene, tuli nakunonga.” ");
INSERT INTO nkn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kaha uahandekele kuli vakevo nguendi, “Vika muteua, yeni vamala va lutsilielo lualundende?” Ambahoni uakatukile nakutenukila mpunzi na mankimba, kaha aholokele kuluu. ");
INSERT INTO nkn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kaha vandongisi vendi valikomokelele cikuma nakuhandeka nguavo, “Muntu uacifua muka ou, uje cipue mpunzi na mankimba vimuononoka!” ");
INSERT INTO nkn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Omo Yesu uahetele musinia lia cisali ku cihela ca Ngandalena, ualiuanene na vamala vavali vaje vakele na mahamba tele vahuminina ha vihilo. Kaha omuo ya vutenu vuavo naumo uahi uasele kuhita ngila ije. ");
INSERT INTO nkn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kaha vatambekele nguavo, “Utonda kulinga vika netu yove Muna Njambi? Uneja nakutuhana kashitiku oku kanda ntsimbu yetu iheteho ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kuyehi navo kuakele vutanga vua vangulu vavengi vaje vakele nakulia. ");
INSERT INTO nkn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kaha mahamba amulombele nguauo, “Nga utuhumisa, tutavese linga tukakovele mu vutanga vua vangulu.” ");
INSERT INTO nkn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kaha Yesu uahandekele kuli vakevo nguendi, “Yeni.” Kaha aje mahamba ahumine nakukakovela mu vutanga vua vangulu. Hajevene vuje vutanga vua vangulu vuoshe vuasikumukile nakushatukila mu cisali. Kaha vuakanongelelemo mu mema. ");
INSERT INTO nkn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vaje vantu vaje vakele nakuniunga vangulu vashatukilile mu nganda nakukambulula vije vioshe vamuene navije vialingiuile kuli vaje vamala vaka mahamba. ");
INSERT INTO nkn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kaha taleni, vantu voshe vahumine mu nganda vezile nakuliuana na Yesu, kaha omo vamumuene, vamulombele ngeci ahume mu cihela cavo. ");
INSERT INTO nkn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Omo Yesu uakovelele mu vuato, uajavukikile musinia, kaha uayile kuimbo liendi. ");
INSERT INTO nkn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kaha hajevene vamunehelelele muka kalepa uakosele ha muhela uendi. Kaha omo Yesu uamuene lutsilielo luavo, uahandekele kuli uje muka kalepa nguendi, “Simpa, munange, vupi vuove vana vusambuesa.” ");
INSERT INTO nkn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kaha vamo valongisi va Lishiko valihandekesele umo na mukuavo nguavo, “Ou yala alinakushaula Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Vuno honi Yesu hakutantekeya viyongola viavo uahandekele nguendi, “Vika muli nakuyonguela viuma via vipi mu mitima yeni? ");
INSERT INTO nkn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nkuma cacasi cika kuhandeka nguange, vupi vuove vanavusambuesa, cipue kuhandeka nguange katuka uende? ");
INSERT INTO nkn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngeci mutantekeye ngueni Muna Muntu hali na nzili yakama cikuma hano ha mavu yakusambuesa vupi.” Kaha uahandekele kuli uje muka kalepa nguendi, “Katuka, ambata muhela uove, kaha ya kuimbo!” ");
INSERT INTO nkn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kaha uakatukile, nakuya kuimbo. ");
INSERT INTO nkn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Omo civunga vacimuene, vakele na liova, kaha vashangazalele Njambi, uje uahanene nzili yakama cikuma ku vantu. ");
INSERT INTO nkn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Omo Yesu uahumine kuje ku cihela, uamuene yala ivatumbula nguavo Mateu uatumamene mu njivo ya kutambuila lisimo. Kaha uahandekele kuli ikeye nguendi, “Njikave.” Kaha uakatukile nakumukava. ");
INSERT INTO nkn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Omo uatumamene ku mesa mu njivo, kaha vavengi vaka kutambula lisimo na vaka vupi vezile nakutumama hamo na Yesu na vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kaha omo Vafaliseo vacimuene, vahandekele kuli vandongisi vendi nguavo, “Vika mulongisi ueni alinakulia na vaka kutambula lisimo na vaka vupi?” ");
INSERT INTO nkn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Vuno honi omo uavevuile, uahandekele nguendi, “Vakangule kuvekusetela cimbanda, vuno honi kuvanga lika vaka kuvavala. ");
INSERT INTO nkn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yemuye mukalilongese vika eci cilumbunuka, ‘Njishunguiya cikeketima, keti cikombelo.’ Muomu kunjezile mukusana vaka vusunga, vuno honi vaka vupi.” ");
INSERT INTO nkn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kaha vandongisi va Iuano muka kumbuitika vezile kuli ikeye nakuhandeka nguavo, “Vika yetu na Vafaliseo tukaliumina kulia, vuno honi vandongisi vove kuvekuliumina kulia?” ");
INSERT INTO nkn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma vangenzi vaje vali ku ciuano ca vulo vanapande kulila oku liavenia vulo acili navo ndi? Matangua akeja omo uje liavenia vulo vakamuambata hali vakevo ambahoni vakaliumine kulia. ");
INSERT INTO nkn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Naumo uahi asa kutongela citope ca ntanga yaiha ha kazaku kalaja, omuo cije citope caciha cikatavula kaje kazaku kaha mukasala mbengua yakama kupulakana mu muje yakele. ");
INSERT INTO nkn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naumo uahi asa kuhaka viniu via viha mu vinjenge via vilambu via laja, nga mulinga ngoco kaha vije vinjeke via vilambu vikatavuka, kaha vije viniu vikahitila muangoco na vije vilambu kaha vikapihia, vuno honi viniu via viha vaka vihaka mu vinjeke via vilambu via viha kaha mukulinga ngoco vioshe vivali vikakala muacili.” ");
INSERT INTO nkn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te Yesu acilinakuhandeka navo, taleni muka kuyula ua Vayunda uezile kuli ikeye nakumutsikamena, uahandekele nguendi, “Munange ua mumbanda natsi hano vene, vuno honi ija nakumusaleka livoko liove, kaha akayoya.” ");
INSERT INTO nkn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kaha Yesu uakatukile nakumukava hamo na vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kaha taleni, mpuevo uje uayandele ku mushongo ua kuhita maninga ha miaka yakupua likumi na ivali uezile munima yendi kaha uamukuatele ku mukunduilo ua kazaku kendi, ");
INSERT INTO nkn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","omuo uahandekele kuli ikeye vavenia nguendi, “Nga njikuata lika ku kazaku kendi kaha njikanguka.” ");
INSERT INTO nkn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Omo Yesu uatengulukile uamumuene kaha uahandekele kuli ikeye nguendi, “Simpa, munange ua mpuevo, lutsilielo luove luakukanguisa.” Kaha hajevene uje mpuevo uakangukile. ");
INSERT INTO nkn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kaha omo Yesu uakovelele mu njivo ya uje mukuluntu ua masualale, uamuene vaje vakakuimba miaso yaha viakutsa na civunga cakele nakulila, ");
INSERT INTO nkn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kaha uahandekele nguendi, “Tuhukeni! Omuo ou kanike uampuevo katsile vuno honi nakosa lika.” Kaha vamujolele. ");
INSERT INTO nkn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Vuno honi omo civunga catuhukile hambanza, uakovelele mukati kaha uakuatele uje kanike ku livoko nakumuhindula, kaha uje kanike uahindukile. ");
INSERT INTO nkn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kaha muzimbu ou ualishanduokelele mu mbonge yoshe ije. ");
INSERT INTO nkn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kaha omo Yesu uahumine kuje, tupuputua vavali vamukavele, vatambekele nguavo, “Tuivuileko cikeketima Muna Ndaviti,” ");
INSERT INTO nkn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Omo uakovelele mu njivo, vaje tupuputua vavali vezile kuli ikeye, kaha Yesu uahandekele kuli vakevo nguendi, “Mutsiliela ngueni njasa kucilinga eci ndi?” Kaha vamukumbuluile nguavo, “Eyo Muene.” ");
INSERT INTO nkn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ambahoni uakuatele ha mesho avo nakuhandeka nguendi, “Kuya ku lutsilielo lueni cilingiue ngocovene kuli yeni.” ");
INSERT INTO nkn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kaha mesho avo emukile, kaha Yesu uavashikile nguendi, “Keti mukalekeko muntu cipue umo.” ");
INSERT INTO nkn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Vuno honi vaile nakushanduola lutsimo luendi mu mbonge muoshe muje. ");
INSERT INTO nkn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Omo vaje vamala vakele nakuya, kaha kuakele vamo vantu vanehelelele Yesu yala ua kaveveve uje uakele na lihamba. ");
INSERT INTO nkn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kaha omo lije lihamba valihumisile, uje yala ua kaveveve uaputukile kuhandeka, kaha vivunga via valikomokelele cikuma nakuhandeka nguavio, “Nacimo cahi cakufua ngue eci cituamona muno mu Isaleli.” ");
INSERT INTO nkn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Vuno honi Vafaliseo vahandekele nguavo, “Akahumisa mahamba na nzili ya muene ua mahamba.” ");
INSERT INTO nkn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kaha Yesu uendanganene mu vimbonge vioshe na mu membo oshe, uakele nakulongesa mu vinjivo viavo via malombelo nakuambulula muzimbu uacili ua vumuene, uakanguisile mishongo yoshe na mavezi oshe. ");
INSERT INTO nkn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Omo uamuene vivunga via vantu kaha uavivuililile ngozi, omuo vakele nakulinienga nakuhona viakulinga ngue vampanga vaje vakuhona kaniungi. ");
INSERT INTO nkn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kaha uahandekele kuli vandongisi vendi nguendi, “Viakuteja vinapu viavingi vuno honi vaka kupanga vavandende. ");
INSERT INTO nkn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nankuma lombeleni kuli Muene ua vaka kuteja linga atume vaka kupanga kuviakuteja viendi.” ");
INSERT INTO nkn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kaha Yesu uasanene vandongisi vendi likumi na vavali, kaha uavahanene nzili yakama ha vimbembesi viakujuala, nakuvihumisa, nakukanguisa mishongo yoshe na vaka kuvavala. ");
INSERT INTO nkn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mazina a tunganda likumi na vavali aua, uakulivanga Simoni uje ivatumbula nguavo Petulu, na munaina Anduleo, na Tiango muna Zembendeo, na munaina Iuano. ");
INSERT INTO nkn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu na Mbatolomeo, Tomasi na Mateu muka kutambula lisimu, na Tiango muna Alufeya, na Tandeo, ");
INSERT INTO nkn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni uaku Kanana, na Yunda Sakaliote uje uendele Yesu vungungu. ");
INSERT INTO nkn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kaha Yesu uatumine likumi na vavali, uavashikile nguendi, “Keti muye kuli vaje keti Vayunda, kaha keti mukovele mu mbonge ya Samaliya. ");
INSERT INTO nkn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Vuno honi yeni ku vampanga vaje vazimbala va mu njivo ya Isaleli. ");
INSERT INTO nkn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kaha oku muli nakuya ambululeni ngueni, ‘Vumuene vua muilu vuli muyehi.’ ");
INSERT INTO nkn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kanguiseni vaka kuvavala, hinduleni vaka kutsa, kanguiseni vaka mbumba, muhumise mahamba. Muatambuile kuakuhona kufueta, kaha haneni kuakuhona kufuetesa. ");
INSERT INTO nkn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Keti muambate Ngolinde cipue Siliva cipue vunengu mu vinkombe vieni, ");
INSERT INTO nkn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","keti muambate lipakumuna ha vungezi vueni cipue vikovelo vivali cipue vinkaku, cipue mbueti, omo muka kupanga napande kutambula kulia. ");
INSERT INTO nkn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kaha nganda cipue limbo lioshe mukovela, tondeni muntu iya uje napande ku mitambula muacili, kaha tumameni nendi noho mukahumamo. ");
INSERT INTO nkn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Omo mukovela mu njivo, menekeni vaje muuanamo. ");
INSERT INTO nkn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kaha nga muje mu njivo vanamitambula vuino, ciyulo ceni cikale navo, vuno honi nga kuvamitambuile vuino, kaha ciyulo ceni cimihilukile. ");
INSERT INTO nkn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kaha nga kuli umo uje kamitambula cipue kuvuilila ku mezi eni, kaha totomoneni likungu ku viliato vieni, omo muhuma muje mu njivo cipue muje mu nganda. ");
INSERT INTO nkn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Muavusunga njimileka nguange, ha litangua lia kusompa Njambi akahana kashitiku cikuma ku cihela cije kupulakana Sondoma na Ngomola. ");
INSERT INTO nkn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Taleni, njimituma ngue vampanga hakati ka tungunga, kaha zangameni ngue linoka kaha ononokeni ngue mavembe. ");
INSERT INTO nkn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Zangameni ku vantu, omuo vakamituala ku vinzango, na kumipupanga mu vinjivo viavo via malombelo. ");
INSERT INTO nkn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kaha vakamituala ku vanguvulu na kuli vimiene omuo yange, linga cikapue vukaleho kuli vakevo na kuli vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Omo vamituala, keti mulishoshomuene mumuka handekela cipue vimukahandeka, ha hola ije. ");
INSERT INTO nkn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Omuo keti yeni mukahandeka, vuno honi Cimbembesi ca Ishueni cikahandeka muli yeni. ");
INSERT INTO nkn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Muanaye akatuala munaina mukutsa, kaha ishe na munendi, kaha vana vakaluisa visemi vavo na kuvatsiha. ");
INSERT INTO nkn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaha vakamizinda voshe omuo ya lizina liange. Vuno honi uje akakateya na kumamanusuilo akovoka. ");
INSERT INTO nkn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Omo vamiyandesa mu mbonge imo, teueleni mukuavo, muavusunga njimileka nguange kumukendangana mu vimbonge vioshe ya Isaleli ntsimbu kanda muna muntu eja. ");
INSERT INTO nkn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ndongisi kasa kupulakana mulongisi uendi, cipue ngamba kupulakana muene yendi. ");
INSERT INTO nkn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Capande ngeci ndongisi kupua ngue mulongisi uendi, na ngamba kupua ngue muene yendi. Nga vanatumbula muene ua njivo nguavo Mbelezembulu, kaha cikapua vati ku vaka njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kaha keti mukale na liova navo, omuo kukuesi civanafuiki cikahona kucifukula, cipue cakushueka cikahona kucitantekeya. ");
INSERT INTO nkn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vinjimileka mu milima mu vihandeke mu ceke, kaha vije vimuvua vayeveta vihandekeleni helu lia njivo. ");
INSERT INTO nkn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kaha keti muteue vaje vatsiha muvila vuno honi kuvasa kutsiha muono, vuno honi teueni uje asa kunongesa muono na muvila mu ngehena. ");
INSERT INTO nkn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nkuma keti tumpiasa vavali vakavalandesa ha muuaya uaya umo ndi? Vuno honi naumo uavo uahi akau ha mavu kuakuhona cizango ca Ishueni. ");
INSERT INTO nkn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vuno honi yeni cipue vinkambu via ku mutue ueni vanavitanda. ");
INSERT INTO nkn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Keti muteue, nankuma yeni muli naseho yakama kupulakana tumpiasa vavengi. ");
INSERT INTO nkn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Uoshe uje akanjihandeka hakati ka vantu, nange naua njikamuhandeka kuli Tate uje hali muilu, ");
INSERT INTO nkn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","vuno honi uoshe uje akanjiviana ku mesho a vantu, nange naua njikamuviana ku mesho a Tate uje hali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Keti musinganieke ngueni njinanehe ciyulo ha mavu, kunjezile nakuneha ciyulo, vuno honi mukuale. ");
INSERT INTO nkn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Njineja nakulinga muana aluise ishe, kaha muana uampuevo aluisa vaina, vaina mueno aluise vanayemueno, ");
INSERT INTO nkn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kaha vitozi va muntu vakapua vavushoko vendi. ");
INSERT INTO nkn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Uoshe uje azanga ishe cipue ina cikuma kupulakana yange kaha kanjipandele, kaha uoshe uje azanga munendi ua yala cipue uampuevo cikuma kupulakana yange kaha kanjipandele, ");
INSERT INTO nkn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","kaha uoshe uje kambata cilindakano cendi nakuhona kunjikava kaha kanjipandele. ");
INSERT INTO nkn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kaha uoshe uje atonda muono uendi akauzimbalesa, kaha na uoshe uje a zimbalesa muono uendi omuo yange akau uana. ");
INSERT INTO nkn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Uoshe uje amitambula natambula yange, kaha uoshe uje anjitambula natambula uje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaha uoshe uje akatambula kananguizi omuo ikeye kananguizi akatambula vuana vua kananguizi, kaha uoshe uje akatambula yala ua vusunga omuo ikeye napu yala ua vusunga akatambula vuana vua yala ua vusunga. ");
INSERT INTO nkn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kaha uoshe uje ahana kuli umo uava vanike vavandende cipue nganja ya mema akutontola omuo napu ndongisi, muavusunga njihandeka kuli yeni nguange kakazimbalesaho vuana vuendi.” ");
INSERT INTO nkn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Omo Yesu uamanusuile kushika vandongisi vendi likumi na vavali, uahumine kuje kaha uaile nakulongesa nakuambulula mu vinganda viavo. ");
INSERT INTO nkn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Honi omo Iuano te hali mu kamenga uevuile vije vialingile Kilistu, kaha uatumine vandongisi vendi na mezi aua nguendi ");
INSERT INTO nkn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yemuye mukahandeke kuli ikeye nguendi, “Yove uje hali nakuija indi tuvandamene mukuavo naua?” ");
INSERT INTO nkn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kaha Yesu uavakumbuluile nguendi, “Yemuye mukaleke Iuano vije munevu navije munamono, ");
INSERT INTO nkn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tupuputua vamona na vilema venda, vaka mbumba vanajele na tuveveve vevua, vatsi vasanguka, kaha na vihutu vali nakuvambuluila muzimbu uacili. ");
INSERT INTO nkn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nakuisuliua uje katsutsuka omuo yange.” ");
INSERT INTO nkn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Omo vakele nakuya, Yesu uaputukile kuhandeka ku civunga via Iuano nguendi, “Vika muaile mukumona mu mpambo? Muaile mukumona lihongo litepuzoka na mpunzi ndi? ");
INSERT INTO nkn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Indi vika honi muaililile kuje? Muaile mukumona muntu nazala vuzalo vuasenga ndi? Taleni, vaje vazala vuzalo vuasenga vakala mu mapela a muene. ");
INSERT INTO nkn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Vika muaililile kuje? Muaile mukumona kananguizi ndi? Eyo, njimileka nguange muakamuene viavingi kupulakana kananguizi. ");
INSERT INTO nkn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ou ikeye vene uje ivasonekele nguavo, ‘Tala njikatuma kanganda kange kulutue luove, uje akavuahesa ngila yove. ");
INSERT INTO nkn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Muavusunga njimileka nguange, hhakati ka vaje vanasemuka ku mpuevo naumo uahi uakama nahumuho kupulakana Iuano muka kumbuitika, vuno honi uoshe uje alikehesa mu vumuene vua muilu napu uakama kupulakana ikeye. ");
INSERT INTO nkn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuhuma ku matangua a Iuano muka kumbuitika kuheta kulelo lino, vumuene vua muilu vunayanda cikuma kaha vantu vakukaluua mitima vanavuambata nampindangano. ");
INSERT INTO nkn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Omuo voshe tunanguizi va Njambi na valongisi va mashiko vahandekele vunanguizi noho Iuano, ");
INSERT INTO nkn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","kaha nga mutonda kucitava, Iuano ikeye Eliya uje akeja. ");
INSERT INTO nkn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uoshe uje hali na matuitui evue. ");
INSERT INTO nkn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vuno honi vika njasa kusetekesa na vantu valelo? Njivasetekesa ngue vanike vaje vanatumama ku cihela ca kulandesela oku valisana muvakehela nguavo, ");
INSERT INTO nkn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuamiohieselele miaso, vuno honi kumuakinine, tuamimbilile miaso ya ha kutsa vuno honi kumualilile.’ ");
INSERT INTO nkn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Omuo Iuano uezile kuakuhona kulia cipue kunua, kaha vahandekele nguavo, ‘Ali na lihamba!’ ");
INSERT INTO nkn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kaha omo Muna Muntu uezile oku alia na kunua, kaha vahandeka nguavo, ‘Mutaleni uamutupu na cipenda, kavusamba ua vaka kutambula lisimu na vaka vupi!’ Vuno honi mana a Njambi vanaashulisisa na vilinga viendi.” ");
INSERT INTO nkn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kaha Yesu uaputukile kutenuka mu vinganda muje mualingile cikuma vikomoueso viendi, omuo kuvatengulukile. ");
INSERT INTO nkn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Cisingo kuli yove Kolazini! Cisingo kuli yove Mbetesainda! Omuo nga vije vikomoueso vialingiuile muli yeni, ngue vialingiuililile mu Tile na Sindone ngue vatengulukile laja mukuzala vinjeke naku likuita muto. ");
INSERT INTO nkn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Vuno honi njimileka nguange, ha litangua lia kusompa Njambi akevuila cikeketima Tile na Sindone kupulakana yeni. ");
INSERT INTO nkn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaha yove Kapenauma, nkuma uatondele kulijundula yove vavenia muilu ndi? Houe, vakakuneha ha mavu mu ngehena. Omuo nga vikomoueso vije vialingiuile kuli yove ngue vialingiuililile mu Sondoma, ngue nganda ije hanga kuicili na lelo lino. ");
INSERT INTO nkn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Vuno honi njimileka nguange, ha litangua lia kusompa Njambi akevuila cikeketima lifuti lia Sondoma kupulakana yove.” ");
INSERT INTO nkn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kaha ha ntsimbu ije Yesu uahandekele nguendi, “Njitsantsela kuli yove Tate, Muene ua muilu na mavu, omuo unashueke evi viuma kuli vaka mana na vaka kulilongesa, kaha unavisholola ku vanike vavandende. ");
INSERT INTO nkn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eyo Tate, omuo mukemo muuatondele linga cilingiue. ");
INSERT INTO nkn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Viuma vioshe Tate nanjihanavio, kaha naumo uahi atantekeya Muana kuvanga lika Ishe, kaha naua naumo uahi atantekeya Ishe kuvanga lika Muana na kuli vaje Muana ahangula linga avashololueye. ");
INSERT INTO nkn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ijeni kuli yange yeni voshe vaje vanahono nakuambata viteli viakulema, kaha njikamihana kuhuima. ");
INSERT INTO nkn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lituikeni mutiyo uange, kaha lilongeseni kuli yange omuo yange njapua uakulikehesa nakulihana, kaha mukauana kuhuima mu miono yeni. ");
INSERT INTO nkn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Omuo mutiyo uange uapua ua uasi, kaha na citeli cange capua ca cehu.” ");
INSERT INTO nkn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ha ntsimbu ije Yesu uahitile mu mehia a tiliku ha litangua lia Sapalalo. Vandongisi vendi vatsile njala, kaha vaputukile kutomona mitue ya tiliku nakulia. ");
INSERT INTO nkn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Vuno honi omo Vafaliseo vacimuene vahandekele kuli Yesu nguavo, “Tala vandongisi vove valinakulinga vije lishiko kulitavesa kulinga ha litangua lia Sapalalo.” ");
INSERT INTO nkn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kaha Yesu uavakumbuluile nguendi, “Nkuma kumuatandele vije Ndaviti ualingile na vaje vakele navo omo vatsile njala, ");
INSERT INTO nkn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","muje muakovelele mu njivo ya Njambi nakulia mbolo ije ivalambuile kuli Njambi, cije kucapuile lishiko kuli ikeye ku ilia cipue vaje vakele navo, vuno honi kuvanga lika tusasendote ndi? ");
INSERT INTO nkn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Cipue nkuma kumuatandele mu lishiko vati muje ha litangua lia Sapalalo tusasendote mu Njivo ya Njambi muvapokuele mashiko a ha litangua lia Sapalalo, vuno honi kuvakele na mulonga ndi? ");
INSERT INTO nkn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Njimileka nguange, cuma cakama kupulakana njivo ya Njambi cino cili kuno. ");
INSERT INTO nkn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kaha nga muatantekeya vika evi vilumbununa, ‘Njatonda cikeketima, keti nkombelo,’ ngue kumuahisile vaje kuvesi na mulonga. ");
INSERT INTO nkn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Omuo Muna Muntu ikeye Muene ua litangua lia Sapalalo.” ");
INSERT INTO nkn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu uahumine ku cihela cije kaha uaile nakukakovela mu njivo ya malombelo. ");
INSERT INTO nkn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kaha hajevene kuakele yala uakusekua livoko, kaha vehuile Yesu nguavo, “Nkuma lishiko litavesa kukanguisa ha litangua lia Sapalalo ndi?” Vatondele linga vamuvangeyeleho. ");
INSERT INTO nkn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kaha Yesu uahandekele kuli vakevo nguendi, “Nga umo haliyeni hali na mpanga kaha auila mu cina ha litangua lia sapalalo, nkuma kumuasa kumuhumisamo ndi? ");
INSERT INTO nkn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nkuma muntu kapuile uaseho cikuma kupulakana mpanga! Nankuma, cinapande kuya ku lishiko kulinga cacili ha litangua lia Sapalalo.” ");
INSERT INTO nkn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ambahoni uahandekele kuli uje yala nguendi, “Olola livoko liove.” Kaha uje yala uoluele livoko liendi, kaha liolokele kupua hamo nalikuavo. ");
INSERT INTO nkn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Vuno honi Vafaliseo vatuhukilemo kaha vakatumbile vutumbe muje vati vasa kutsihila Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Vuno honi Yesu uatantekeyele vutumbe vuavo, kaha uahumineko. Kaha vavengi vamukavele, kaha voshe uavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kaha uavashikile nguendi keti vamutsimanese. ");
INSERT INTO nkn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eci capuile linga vilishulisise vije viahandekele kananguizi ua Njambi Isaya nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Taleni ngamba yange injinahangula, uje injazanga kaha muli ikeye muono uange uvuahelela. Njikahaka Cimbembesi cange hali ikeye, Kaha akahandeka vusunga kuli vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kakakalaho na vimpata cipue kulila, kaha na umo uahi akevua lizi liendi mu vitapalo. ");
INSERT INTO nkn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kakapokolaho lihongo liakuhenga Kakazimiho tuhia tuje tucili nakutuhuisa vuisi. Kuvanga noho nanehe vusunga ku kuhiana.” ");
INSERT INTO nkn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kaha mu lizina liendi mukemo vakatsiliela vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ambahoni vantu vamo vanehelele Yesu yala uje ua kapuputua nakuhona kuhandeka uje uakele na lihamba kaha uamukanguisile, kaha uje yala ua kaveveve uaputukile kuhandeka nakumona. ");
INSERT INTO nkn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaha vantu voshe valikomokelele cikuma nakuhandeka nguavo, “Nkuma ou keti ikeye muna Ndaviti ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Vuno honi omo Vafaliseo vaviuvuile vahandekele nguavo, “Kuvanga lika na nzili ya Mbelezembulu muene ua mahamba, ikeyo ou yala yalinakuhumisa nayo mahamba.” ");
INSERT INTO nkn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu uatantekeyele visinganieka viavo kaha uahandekele kuli vakevo nguendi, “Vumuene vuoshe vuje vukalitepe hhakati nakuliluisa vukalipihisa, naimo yahi nganda cipue njivo vije vililuisa vikevio vavenia vikemana. ");
INSERT INTO nkn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kaha nga satana ahumisa mukuavo satana, kaha nalitepe hhakati ikeye vavenia, kaha vatihoni vumuene vuendi vukakola? ");
INSERT INTO nkn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kaha nga njikahumisa mahamba na nzili ya Mbelezembulu, nkuma na nzili yeya vana veni vaka ahumisa? Nankuma vakevo vakamisompa. ");
INSERT INTO nkn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Vuno honi nga njikalikuasesa Cimbembesi ua Njambi mukuhumisa mahamba, kaha vumuene vua Njambi vuneja hali yeni. ");
INSERT INTO nkn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Cipue vatihoni muntu asa kukovela mu njivo ya yala uanzili nakuambata viuma viendi, nkuma keti tahi akuta uje yala uanzili ndi? Ambahoni apukule njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Uje kesi nange anjiluisa, uje kalipandakana nange ashandola. ");
INSERT INTO nkn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nankuma njimileka nguange, vupi vuoshe nakushaula coshe ca vantu vakavikonekela, vuno honi kushaula Cimbembesi kuvaka cikonekela. ");
INSERT INTO nkn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kaha uoshe uje ahandeka lizi lia kuluisa Muna Muntu vakamukonekela, Vuno honi uoshe uje ahandeka viakuluisa Cimbembesi Uakulela kuvaka mukonekela cipue mu miaka ino cipue mu miaka ije ilinakuija. ");
INSERT INTO nkn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kukala na vushuka vuacili kuvanga muti uao upua ua cili, cipue kukala na muti ua upi na vushuka vuao vupua vua upi, omuo muti vakautantekeya kuvushuka vuauo. ");
INSERT INTO nkn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yeni vana vamanoka, muasa kuhandeka vati viacili omo yeni muapua mu vaka vupi? Omuo vije viashula ku mutima vikevio kanua kakahandeka. ");
INSERT INTO nkn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yala uacili akahumisa vuima viacili vije viakatulika mu citulikilo cendi ca cili, kaha yala ua mupi akahumisa viuma via vipi mu citulikilo cendi ca cipi. ");
INSERT INTO nkn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Njimileka nguange, ha litangua lia kusompa vantu vaka vasompa kuya ku mezi avo aje avakahandeka akuhona seho, ");
INSERT INTO nkn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","omuo kuya ku mezi ove mukemo muvaka kusompa kaha kuya ku mezi ove akeo avakakuhisa nao.” ");
INSERT INTO nkn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ambahoni vamo valongisi va mezi na Vafaliseo vahandekele kuli ikeye nguavo, “Mulongisi tutonda yove linga utulingileko cimueso.” ");
INSERT INTO nkn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Vuno honi uavakumbuluile nguendi, “Vantu vavupi na vupangala vantsimbu ino vakevo vatonda cimueso, vuno honi nacimo cahi cimueso civakavahana kuvanga lika cimueso ca kananguizi ua Njambi Yona. ");
INSERT INTO nkn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Omuo Yona uakele muzimo lia intsi ha matangua atatu na matsiki atatu, mucifua cimo vene na Muna Muntu akakala mu vukalo vua vatsi ha matangua atatu na matsiki atatu. ");
INSERT INTO nkn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Vantu vaku Ninive vakemana ha litangua lia kusompa na vantu vantsimbu ino kaha vaka vahisa, omuo vatengulukile ha kuambulula ca Yona, kaha taleni cuma cakama cikuma kupulakana Yona cino cili kuno. ");
INSERT INTO nkn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Muene ua mpuevo uaku Shemba akemana ha litangua lia kusompa na vantu vantsimbu ino nakuvahisa, omuo uahumine kuntsongo ya cifuti kuija nakuvuilila mana a Solomoni, kaha taleni umo uakama kupulakana Solomoni uno hali kuno. ");
INSERT INTO nkn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Omo cimbembesi cacipi cihuma muli muntu, cikahiti mu vindinda kutonda kuakuhuimina, vuno honi kucekuuana cipue hamo. ");
INSERT INTO nkn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ambahoni cihandeka nguaco ‘Njihilukila ku njivo yange kuje njahuminine.’ Kaha omo cihiluka ciuana ije njivo mupulungua, muakukomba nakuivuahesa muje muinapande kukelamo. ");
INSERT INTO nkn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ambahoni ciya nakuambata vikuavo vimbembsi vitanu na vivali vije via vipi cikuma kupulakana cikeco, kaha vakovelamo nakukakalamo, kaha cifua ca uje yala ca mamanusuilo cikapua cacipi kupulakana caha kulivanga. Omu mukemo vene mu vakafua na vantu vantsimbu ino.” ");
INSERT INTO nkn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tele Yesu acili nakuhandeka ku vantu, taleni vaina na vamunaina vemanene hambanza, vatondele linga vahandeka nendi. ");
INSERT INTO nkn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kaha umo ua vantu vaje kuje uamulekele nguendi, “Tala, vanoko na vamuanoko vanemana hambanza vatonda kuhandeka nove.” ");
INSERT INTO nkn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Vuno honi Yesu uamukumbuluile nguendi, “Iya vanana, kaha iya naua vamuanetu?” ");
INSERT INTO nkn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kaha uoluele livoko liendi kuli vandongisi vendi nakuhandeka nguendi, “Ava vakevo vanana na vamuanetu! ");
INSERT INTO nkn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Omuo uoshe uje alinga cizango ca Tate ua muilu ikeye napu muanetu ua yala na uampuevo na nana.” ");
INSERT INTO nkn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ha Litangua lije vene, Yesu uahumine mu njivo kaha uaile nakukatumama ku mukulo ua cisali. ");
INSERT INTO nkn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaha vivunga viakama viezile kuli ikeye nakumuzengeleka, nankuma uakovelele mu vuato nakukatumama, kaha civunga coshe cemanene ha ntunda. ");
INSERT INTO nkn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kaha uavalekele viuma viavingi mukulikuasesa visimo nguendi, “Muka kukuva uaile nakukuva. ");
INSERT INTO nkn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kaha omo uakele nakukuva vimbuto vimo viauililile ku mukulo ua ngila, kaha tuzila vezile nakuvilia. ");
INSERT INTO nkn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kaha vimbuto vikuavo viauililile ha mavue aje kuhakele livu lialingi, kaha hajevene viasokele, omuo kuhakele livu lia lingi. ");
INSERT INTO nkn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Vuno honi omo litangua liatuhukile kaha vije vimbuto viajujuamene, kaha omuo mizi yavio kuyakovelele cikuma mu livu, kaha vije vimbuto viomine. ");
INSERT INTO nkn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Vimbuto vikuavo viauililile hhakati ka mingonga, kaha ije mingonga yakolele nakuvituva. ");
INSERT INTO nkn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Vimbuto vikuavo viauililile ha mavu acili kaha viemine muacili, vimo vimbuto vihita, vimo viemine vimbuto makumi atanu na limo, kaha vikuavo naua viemine vimbuto makumi atatu kupulakana vije vivakunine. ");
INSERT INTO nkn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Uoshe uje hali na matuitui ovue.” ");
INSERT INTO nkn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ambahoni vandongisi vezile kuli Yesu nakuhandeka nguavo, “Vika honi ukahandekela navo mu visimo?” ");
INSERT INTO nkn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kaha uavakumbuluile nguendi, “Yeni vanamihana kutantekeya vushueke vua vumuene vua muilu, vuno honi kuli vakevo kuvavahanenevuo. ");
INSERT INTO nkn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Omuo uoshe uje alinavio vakamuvuezelako vikuavo naua, kaha akakala na viavingi, vuno honi uje kesi cipue nacimo, cipue cije cali naco vakamuniekaco. ");
INSERT INTO nkn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eci cikeco canehesa linga njihandeke navo mu visimo omuo vakevo vamona, vuno honi kuvamonesesa, kaha vovua, vuno honi kuvevuisisa. ");
INSERT INTO nkn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cilivene kuli vakevo vinalishulisisa vije viahandekele kananguizi ua Njambi Isaya nguendi, “‘Cilivene mukevua vuno honi kumukevuisisa, kaha cilivene mukamona vuno honi kumukamonesesa. ");
INSERT INTO nkn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Omuo mitima yava vantu inahono mana, kaha na matuitui avo anaziki, kaha na mesho avo vana azimi, keti ngoconi mesho avo akamona kaha na matuitui avo akevua, kaha na mitima yavo ikevuisisa, nakutengulukila kuli yange linga njivakanguise.’ ");
INSERT INTO nkn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Vuno honi anakuisuliua mesho eni omuo amona, na matuitui eni, omuo ovua. ");
INSERT INTO nkn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Muavusunga njihandeka kuli yeni nguange, tunanguizi va Njambi va Njambi vavengi na vantu va vusunga, vatondele kumona cikuma evi vimuli nakumona, vuno honi kuvavimuene, nakuivua vije vimulinakuivua, vuno honi kuvaviuvuile. ");
INSERT INTO nkn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ambahoni ivuilileni cisimo ca uje muka kukuva. ");
INSERT INTO nkn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Omuo uoshe uje ovua lizi lia vumuene kaha kaliuvuisisa, kaha uje muka vupi eja nakuambata vije vivanakuvu mu mutima uendi, eyi ikeyo mbuto ije ivakuvile ku mukulo uangila. ");
INSERT INTO nkn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kaha mbuto ije ivakuvile ha mavue, ou ikeye uje ovua lizi kaha hajevene alitambula nanzolela, ");
INSERT INTO nkn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","vuno honi kuliesi na mizi muli ikeye, kaha likala lika muka ntsimbu kandende. Kaha omo tuyando cipue mapakeso vija omuo ya lizi, kaha hajevene kalikavangeya. ");
INSERT INTO nkn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kaha vimbuto vije vivakuvile ha mingonga, ou ikeye uje ovua lizi, vuno honi omo ha kuzanga via ha mavu nakuzanga vufuko vua mavu kaha vikatuva lije lizi, kaha kulikemi vushuka. ");
INSERT INTO nkn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kaha ije mbuto ivakuvile ha mavu acili, ou ikeye uje ovua lizi nakulivuisisa, ikeye cilivene akema vushuka vavuingi vuakupua vimo vimbuto vihita, vimo, vikuavo viemine makumi atanu na limo, kaha vikuavo naua viemine makumi atatu kupulakana vije vivakuvile.” ");
INSERT INTO nkn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kaha Yesu uavatelele cisimo cikuavo naua nguendi, “Vumuene vua muilu tuhasa kuvuesekesa ngue yala uje uakuvile mbuto yacili mu lihia liendi, ");
INSERT INTO nkn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","vuno honi tele vantu vanakosa, citozi cendi uezile nakukuva shaku muje mu lihia lia tiliku, kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Omo ije tiliku yakolele nakuhaka vinona ambahoni naikeyo ije shaku yasholokele. ");
INSERT INTO nkn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaha vaje vangamba vendi vezile kuli ikeye nakumuleka nguavo, ‘Muene nkuma kuuakunine lika mbuto yacili mu lihia liove ndi? Kaha cineja vati honi linga mukale naua na shaku?’ ");
INSERT INTO nkn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kaha uahandekele kuli vakevo nguendi, ‘Kuli citozi uje nalingi eci.’ Kaha vaje vangamba vendi vahandekele kuli ikeye nguavo, ‘Nkuma utonda linga tuye tukaitukulemo ndi?’ ");
INSERT INTO nkn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Vuno honi uavakumbuluile nguendi, ‘Kuahi!’ Omuo muje mu mukaitukulamo ije shaku hamo mukatukuila kumo na tiliku. ");
INSERT INTO nkn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vieceleni vioshe linga vikole kuvanga noho ha ntsimbu yakuteja, kaha ha ntsimbu yakuteja njikaleka vaka kuteja nguange, ‘Tukulenimo tahi shaku muikute mikuta, kaha itsimikeni, vuno honi kungululeni tiliku nakuihaka mu cishete cange.’” ");
INSERT INTO nkn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kaha Yesu uavatelele cisimo cikuavo naua nguendi, “Vumuene vua muilu vunapu ngue nona ya mbuto ya musalata ije muntu uambatele nakukuna mu lihia liendi. ");
INSERT INTO nkn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yapua yaindende cikuma ku vimbuto vioshe, vuno honi omo ikola ikapu ciputa cakama na kukola kupua muti, nankuma tuzila va muilu vakeja nakutungila mashua ha mitango yauo.” ");
INSERT INTO nkn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kaha Yesu uavatelele naua cisimo cikuavo nguendi, “Vumuene vua muilu vuapua ngue cimbaluila cije mpuevo uambatele nakucishingasanena ha lilonga haje hakele vinganja vitatu via vunga vua tiliku kuvanga noho vioshe viafutunukile.” ");
INSERT INTO nkn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vioshe evi Yesu uavihandekele ku vivunga mu visimo, cilivene nacimo cahi cahandekele kuli vakevo kuakuhona kulikuasesa cisimo. ");
INSERT INTO nkn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eci capuile kushulisisa vije viahandekele kananguizi ua Njambi nguendi, “Njikafukula kanua kange mu visimo. Njikahande vioshe vije vialishueka hume ha luvula lua mavu.” ");
INSERT INTO nkn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ambahoni Yesu uasezele civunga nakuya mu njivo kaha vandongisi vendi vezile kuli ikeye nakuhandeka nguavo, “Tulumbunuine cisimo ca shaku ya mu lihia.” ");
INSERT INTO nkn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kaha uavakumbuluile nguendi, “Uoshe uje akuna mbuto yacili napu Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lihia likelio mavu, kaha mbuto ije yacili ilumbununa vana va vumuene, kaha naije shaku inapu vana va muka vupi, ");
INSERT INTO nkn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","kaha uje citozi uje uaikuninemo ikeye napu Satana. Kaha kuteja cikeco kuhua ca mavu, kaha vaka kuteja vakevo tungelo. ");
INSERT INTO nkn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngue mujevene muvaka kungungulula shaku nakuitsimika na tuhia, mukemovene mu cikafua naku mamanusuililo a mavu. ");
INSERT INTO nkn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Muna Muntu akatuma tungelo vendi, kaha vaka kunguluila hamo vije vikanehesa vupi navaje vakalingi vupi mu vumuene vuendi, ");
INSERT INTO nkn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nakuvombila mu litende lia tuhia, kuje vantu vaka lila nakulishumanga ku mazo avo. ");
INSERT INTO nkn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ambahoni vaka vusunga vakaviakuma ngue litangua mu vumuene vua Ishavo, uoshe uje hali na matuitui ovue. ");
INSERT INTO nkn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Vumuene vua muilu vunapu ngue vufuko vuakushueka mu lihia, vuje omo muntu avuuana kaha avushueka naua ambahoni hakuvuahelela cendi aya nakukalandesa vioshe vije alinavio kaha alanda lije lihia. ");
INSERT INTO nkn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naua vumuene vua muilu vunapu ngue muntu uje muka kulandesa uje atonda vusanga vuacili, ");
INSERT INTO nkn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","uje omo auana vusanga vumo vua seho yakama, kaha aya nakukalandesa vioshe vije alinavio kaha akavulanda. ");
INSERT INTO nkn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Naua vumuene vua muilu vunapu ngue vuanda vua kuta vatsi vuje vuvanate mu cisali kaha vutsiha muyati uoshe ua vatsi, ");
INSERT INTO nkn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","omo vuashulile vamala vavukokelele ha ntunda kaha vatumamene nakuhangulamo vatsi vacili nakuvahaka mu mitonga yavo vuno honi vombilile vaje vakupihia. ");
INSERT INTO nkn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nankuma omu mukemo mucikafua naku mamanusuilo a mavu. Tungelo vakeja nakutepesa vaka vupi ku vaka vusunga, ");
INSERT INTO nkn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nakuvombila mu litende lia tuhia, kuje vantu vakalila nakulishumanga ku mazo avo. ");
INSERT INTO nkn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Yesu uavehuile nguendi, nkuma munoviuvuisisa viuma vioshe evi ndi?” Kaha vamukumbuluile nguavo, “Eyo.” ");
INSERT INTO nkn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kaha uahandekele kuli vakevo nguendi, “Nankuma uoshe mulongisi ua mashiko uje ivalongesele via vumuene vua muilu napu ngue uje vavenia njivo, uje ahumisa vufuko vuendi vua laja novu vua vuha mu citulikilo cendi.” ");
INSERT INTO nkn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kaha omo Yesu uamanusuile kuta vije visimo, uahumineko kuje, ");
INSERT INTO nkn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nakuya ku cifuti cendi nakukavalongesa mu njivo yavo ya malombelo, kaha vaje voshe vamuvuile vali komokelele cikuma nakuhandeka nguavo, “Nkuma kuli ou yala kuanauana mana aua na vikomoueso evi? ");
INSERT INTO nkn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nkuma ou keti ikeye muna uje muka kushonga ndi? Nkuma vaina keti Maliya? Nkuma vamunaina keti Tiango, na Yosefa, na Simoni na Yunda ndi? ");
INSERT INTO nkn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nkuma vashongo vendi voshe va vampuevo keti ava tuli hamo navo ndi? Nkuma kuli honi ou yala nauana vioshe evi?” ");
INSERT INTO nkn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kaha vamuvianene. Vuno honi Yesu uahandekele kuli vakevo nguendi, “Kananguizi ua Njambi kuvekumusingimika mu cifuti cendi cipue muimbo liendi kuvanga lika kueka.” ");
INSERT INTO nkn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaha kalingilileko vikomoueso kuje omuo ya kuhona kutsiliela cavo. ");
INSERT INTO nkn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ha ntsimbu ije muene Helonde omo uevuile lutsimo lua Yesu, ");
INSERT INTO nkn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kaha uahandekele kuli vangamba vendi nguendi, “Ou ikeye Iuano muka kumbuitika, vanamusangula ku vatsi, mukemo evi vinzili vili nakupanga muli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Omuo Helonde uakuatele Iuano nakumukuta nakumuhaka mu kamenga, omuo ya mulonga ua Helondiya mpuevo ya munaina Filipu, ");
INSERT INTO nkn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","omuo Iuano uahandekele kuli ikeye nguendi, “Kuya ku lishiko yove kuuapandele kumuambata.” ");
INSERT INTO nkn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Cipue vene uatondele kumutsiha, vuno honi kamutsihile uateuele vantu, omuo vamuivuile nguavo uapuile kananguizi ua Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Omo litangua lia kuanuka kusemuka ca Helonde liahetele, muna Helondiya uampuevo uakinine hhakati ka civunga ca vantu kaha uavuahelesele Helonde, ");
INSERT INTO nkn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kaha uamukulahesele nakulisinga kumuhana vioshe viatondele kulomba. ");
INSERT INTO nkn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Omuo vaina vamusindiiye, kaha ualombele nguendi, “Njihane mutue ua Iuano muka kumbuitika ha lilonga.” ");
INSERT INTO nkn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Vuno honi muene uovuile vusiua, vuno honi omuo hakulisinga cendi na hali vangezi vendi, kaha uashikile linga vamuhaneuo, ");
INSERT INTO nkn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","uatumine kukateta mutue ua Iuano mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kaha mutue uendi vaunehele ha lilonga nakuuhana kuli muana mpuevo, kaha uauhanene vaina. ");
INSERT INTO nkn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kaha vandongisi va Iuano vezile nakuambata muvila uendi nakuutsinda, kaha vaile nakulekesa Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Honi omo Yesu uovuile eci, uahumine kuje mu vuato kaha uaile kumutambela ua likaliendi. Vuno honi omo vivunga vievuile eci, viamukavele ha mavu kuhuma ku vimbonge. ");
INSERT INTO nkn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Omuo Yesu uaile ha ntunda uamuene civunga cakama, kaha uavovuililile ngozi, kaha uavakanguisile ku mishongo yavo. ");
INSERT INTO nkn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Omo capuile cinguezi, vandongisi va Yesu vezile kuli ikeye nakuhandeka nguavo, “Cino cinapu cihela ca kuholoka, kaha litangua honi liatoko, kaha leka vivunga linga vaye ku membo linga vakalilandele viakulia vakevo vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kaha Yesu uahandekele nguendi, “Kuvapandele kuya, vahaneni vimo valie.” ");
INSERT INTO nkn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kaha vahandekele kuli ikeye nguavo, “Tuli lika na vimbolo vitanu na vatsi vavali.” ");
INSERT INTO nkn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kaha Yesu uahandekele nguendi, “Vineheni kuno kuli yange.” ");
INSERT INTO nkn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kaha uashikile vivunga linga vatumame ha muila, kaha uambatele vimbolo vitanu na vatsi vavali kaha uatalele kuilu, kaha uavikuisuile, nakutavuozola vimbolo nakuvihana kuli vandongisi vendi, kaha vandongisi vendi vavihanene ku vivunga. ");
INSERT INTO nkn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kaha voshe valile nakukuta. Kaha vakunguilile mitonga ya vimbazuvuila ya kushula ya kupua likumi na ivali. ");
INSERT INTO nkn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kaha vaje valile vapuile ngue makulukazi atanu a vamala, kuhumisako vampuevo na vanike. ");
INSERT INTO nkn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ambahoni Yesu ualekele vandongisi vendi linga vakovele mu vuato vaye kulutue luendi musinia tele ikeye acili na kuleka vivunga linga vaye. ");
INSERT INTO nkn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kaha hanima ya kuleka vivunga linga vaye, uaille helu lia munkinda lika liendi mukulombela. Uakele kuje likaliendi noho cinguezi, ");
INSERT INTO nkn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","vuno honi ha ntsimbu ije vuato vuakele hhakati ka cisali kaha vuakele nakulininganga na mankimba omuo mpunzi yakele nakuvuluisa. ");
INSERT INTO nkn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kaha ku vandemba Yesu uezile kuli vakevo, oku alinakuenda helu lia cisali. ");
INSERT INTO nkn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vuno honi omo vandongisi vendi vamumuene hali nakuenda ha cisali, vovuile liova cikuma kaha vahandekele nguavo, “Ndumba ya muntu!” Kaha vatambekele naliova. ");
INSERT INTO nkn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kaha hajevene Yesu uahandekele kuli vakevo nguendi, “Simpeni keti muteue yange vene.” ");
INSERT INTO nkn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kaha Petulu uahandekele kuli ikeye nguendi, “Muene, nga yove, njileke njije kuli yove nange njende ha mema.” ");
INSERT INTO nkn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kaha Yesu uahandekele nguendi, “Ija.” Kaha Petulu uahumine mu vuato nakuenda ha mema kuya kuli Yesu, ");
INSERT INTO nkn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","vuno honi omo uamuene mpunzi uateuele, kaha uaputukile kuvombela kaha uatambekele nguendi, “Muene njovole.” ");
INSERT INTO nkn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hajevene Yesu uoluele livoko liendi, nakumukuata kaha uahandekele nguendi, “Muntu ua lutsilielo lualundende, vika ku utsiliela?” ");
INSERT INTO nkn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kaha omo vakovelele mu vuato mpunzi yahuile. ");
INSERT INTO nkn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kaha vaje vakele mu vuato vamulemesele nguavo, “Muavusunga u Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kaha omo Yesu na vandongisi vendi vajavukilile musinia, vezile ku cihela ca Ngenesaleta. ");
INSERT INTO nkn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kaha omo vantu vakumutambela uje vamutantekeyele, vatumine voshe vaku cihela cije nakumunehela vaka kuvavala voshe, ");
INSERT INTO nkn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Vamulombele linga vakuate cipue ku mukunduilo ua kazaku kendi, kaha voshe vaje vakuateleko vakangukile. ");
INSERT INTO nkn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ambahoni Vafaliseo vamo na valongisi va lishiko vezile kuli Yesu kuhuminina ku Yelusalema kaha vahandekele nguavo, ");
INSERT INTO nkn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Vikahoni vandongisi vove kuvekuononoka cisemua ca vakuluntu? Omuo kuvekutana ku mavoko avo omo valia.” ");
INSERT INTO nkn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kaha Yesu uavakumbuluile nguendi, “Nkuma neni kumuekuononoka lishiko lia Njambi omuo ya cisemua ceni ndi? ");
INSERT INTO nkn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Omuo Njambi uashikile nguendi, ‘Singimika isho na noko,’ kaha ‘uoshe uje ashaula ishe cipue ina, cilivene atse.’ ");
INSERT INTO nkn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Vuno honi yeni mukahandeka ngueni nga uoshe uje aleka ishe cipue ina nguendi, ‘Vije vimunapandele kuhana kuli yange vanavihana Njambi,’ ");
INSERT INTO nkn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kaha muntu ou kononokele ishe. Nankuma, omuo ya cisemua ceni, munaseze lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yeni vaka civembulu! Nkuma Isaya uahandekele via vusunga hali yeni, omuo uahandekele vunanguizi nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Ava vantu vanjisingimika na tunua tuavo, vuno honi mitima yavo ili kulahako nange. ");
INSERT INTO nkn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Vakanjilemesa lika muangoco, vakalongesa mashiko a vantu lika!’” ");
INSERT INTO nkn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kaha Yesu uasanene vantu linga veje kuli ikeye kaha uavalekele nguendi, “Ivueni kaha ivuisiseni. ");
INSERT INTO nkn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Keti coshe cije cikakovela mu kanua ka muntu cikalingisa muntu linga keti apue uakulela, vuno honi vije vikahumu mu kanua ka muntu vikevio vikalingisa muntu linga apue uakuhona kulela.” ");
INSERT INTO nkn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ambahoni vandongisi vezile kuli Yesu nakuhandeka nguavo, “Nkuma uatantekeya nguove Vafaliseo vapihilile ku mitima omo vevuile mezi aua ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kaha Yesu uavakumbuluile nguendi, “Muti uoshe uje Tate ua muilu kakunine vakau tukula. ");
INSERT INTO nkn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Veceleni lika, vanapu vantuamena va tupuputua, kaha nga kapuputua atuamenena kapuputua mukuavo, voshe vakauila mu cina.” ");
INSERT INTO nkn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Vuno honi Petulu uahandekele kuli Yesu nguendi, “Tulumbunuine eci cisimo.” ");
INSERT INTO nkn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kaha uahandekele kuli ikeye nguendi, “Nkuma nove naua hanga kanda ucinongonone eci ndi? ");
INSERT INTO nkn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nkuma ku umono nguove coshe cije cikovela mu kanua cikahiti muzimo nakuhitilila ndi? ");
INSERT INTO nkn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vuno honi vije vioshe vikahumu mu kanua vikahumu ku mutima, kaha evi vikevio vikalingisa muntu kupua uakuhona kulela. ");
INSERT INTO nkn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Omuo ku mutima kukeko kukahuminina visinganieka via vipi via kutsiha, vupangala, vukoyi, kuiva, vukaleho vua makuli, na vungumba. ");
INSERT INTO nkn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Evi vikevio vikalingisa muntu linga apue uakuhona kulela, vuno honi kulia cakuhona kutana ku mavoko kucekulingisa muntu linga apue uakuhona kulela.” ");
INSERT INTO nkn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kaha Yesu uahumine kuje nakuya ku cihela ca Tile na ku Sindone. ");
INSERT INTO nkn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kaha taleni, mpuevo ua ku Kanana uje uahuminine ku cihela kuje vene ualilile nguendi, “Njivuileko cikeketima Muene, Muna Ndaviti, munange uampuevo ali na lihamba lia lipi cikuma.” ");
INSERT INTO nkn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Vuno honi Yesu kamukumbuluile cipue lizi limo, kaha vandongisi vendi vezile nakumulambelela nguavo, “Mulekese linga aye omuo hali nakutupangela kalua.” ");
INSERT INTO nkn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kaha Yesu uavakumbuluile nguendi, “Vanjitumine lika ku vampanga vakuzimbala vaku Isaleli.” ");
INSERT INTO nkn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vuno honi uje mpuevo uezile nakutsikama kuli ikeye nguendi, “Muene njikuase.” ");
INSERT INTO nkn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kaha Yesu uamukumbuluile nguendi, “Keti cacili kumbila mbolo ya vanike ku tutali.” ");
INSERT INTO nkn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kaha uje mpuevo uamukumbuluile nguendi, “Eyo Muene, vuno honi cipue vene tutali vakali vishaniu vije vikau ku mesa ya muene uavo.” ");
INSERT INTO nkn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kaha Yesu uamukumbuluile nguendi, “Nanaa ove mpuevo lutsilielo liove luakama cikuma. Cilingiue kuya muje mu utondela.” Kaha hajevene munendi uampuevo uakangukile. ");
INSERT INTO nkn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kaha Yesu uahumine kuje kaha uahitile kuyehi na cisali ca Ngalileya. Kaha uaile kumukulo ua munkinda nakukatuma. ");
INSERT INTO nkn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kaha civunga cakama cezile kuli ikeye, vamunehelele vilema, visualonda, tupuputua na tuveveve, na vakuavo veka naua, kaha vavanehele ku viliato viendi, kaha uavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nankuma cije civunga calikomokelele cikuma, omo vamuene vaje tuveveve vahandeka, na visualonda vanapu vamutuntu, na vilema venda, na tupuputua vamona, kaha vahanene vumpau kuli Njambi ua Isaleli. ");
INSERT INTO nkn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ambahoni Yesu uasanene vandongisi vendi nakuvaleka nguendi, “Njilinakuivuila ngozi eci civunga, omuo vanakala nange ha matangua atatu, kaha kuvalileho cipue cimo, kaha kunjitondo linga njiveceli vaye na njala, hamo valezumukila mu ngila.” ");
INSERT INTO nkn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kaha vandongisi vahandekele kuli ikeye nguavo, “Kuli honi tuasa kuuana mbolo muno mu ndinda ya kulisa civunga cakama eci?” ");
INSERT INTO nkn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kaha Yesu uahandekele kuli vakevo nguendi, “Muli na mikasha ingahi?” Vamukumbuluile nguavo, “Itanu na ivali, na vatsi vavandende.” ");
INSERT INTO nkn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kaha Yesu uashikile cije civunga linga vatumame ha mavu, ");
INSERT INTO nkn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","kaha uambatele ije mikasha itanu na ivali na vatsi, kaha hanima yakuhana citsantsela, uavipazuile nakuvihana kuli vandongisi, kaha vandongisi vavihanene kuli vije vivunga. ");
INSERT INTO nkn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kaha voshe valile nakukuta. Kaha vandongisi vakunguilile mitonga ya kushula ya kupua itanu na ivali ya vije vimbazuvuila viasaleleho. ");
INSERT INTO nkn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kaha vaje valile vapuile makulukazi auana a vamala (4, 0 0 0), kuakuhona vampuevo na vanike. ");
INSERT INTO nkn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kaha uecelele cije civunga linga vaye, kaha uakovelele mu vuato nakuya ku cihela ca Mangandane. ");
INSERT INTO nkn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kaha Vafaliseo na Vasanduki vezile kuli Yesu nakumueseka, vamuihuile linga avamuese cimueso cakuhuminina kuilu. ");
INSERT INTO nkn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kaha uavakumbuluile nguendi, “Omo nga cinguezi, mukahandeka ngueni, ‘Kukaca vuino, omuo lilu livenga.’ ");
INSERT INTO nkn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kaha kucimene muhandeka ngueni, ‘Lelo kukakala mashuela, omuo lilu livenga na kuteuesa.’ Muatantekeya kulumbununa cifua ca lilu, vuno honi kumuhasa kulumbununa vimueso via vi ntsimbu. ");
INSERT INTO nkn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Vantu vantsimbu ino va vupi na vupangala vatonda cimueso, vuno honi kukuesi cimueso civakavahana kuvanga lika cimueso ca Yona.” kaha uavasezele nakuya. ");
INSERT INTO nkn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Omo vandongisi vahetele musinia, vasuvile kuambata mbolo. ");
INSERT INTO nkn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kaha Yesu uahandekele kuli vakevo nguendi, “Linuingeni kaha zangameni ku cimbaluila ca Vafaliseo na Vasanduki.” ");
INSERT INTO nkn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kaha vakele nakuhandeka hhakati kavo vavenia nguavo, “Kutuezile na mbolo.” ");
INSERT INTO nkn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kaha Yesu, hakutantekeya eci, uahandekele nguendi, “Yeni valutsilielo lualundende, vika muli nakuhandeka hhakati keni vavenia ngueni kumuesi na mbolo? ");
INSERT INTO nkn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nkuma kanda muvuisise ndi? Nkuma kumuanuka mikasha itanu ya vimbolo, ya vantu makulukazi atanu, kaha mitonga ingahi muakunguluile? ");
INSERT INTO nkn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Cipue mikasha itanu na ivali ya vimbolo ya vantu makulukazi auana, nkuma mitonga ingahi muakunguluile? ");
INSERT INTO nkn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nkuma vika kumuvuisisa ngueni kunjahandekele neni via mbolo? Zangameni ku cimbaluila ca Vafaliseo na Vasanduki.” ");
INSERT INTO nkn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kaha vevuisisile nguavo nkuma kavalekele kuzangama ku cimbaluila cakupangesa mbolo, vuno honi ha vilongesa via Vafaliseo na Vasanduki. ");
INSERT INTO nkn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Omo Yesu uahetele ku mbonge ya Sesaliya Filipu, kaha uehuile vandongisi vendi nguendi, “Vantu vahandeka nguavo Muna Muntu ikeye iya?” ");
INSERT INTO nkn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vamukumbuluile nguavo, “Vamo nguavo Iuano muka kumbuitika, vamo nguavo Eliya, vamo nguavo Njelemiya cipue umo ua tunanguizi va Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kaha Yesu uahandekele kuli vakevo nguendi, “Vuno honi yeni ngueni Yange iya?” ");
INSERT INTO nkn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulu uamukumbuluile nguendi, “Yove Kilistu, Muna Njambi uakuyoya.” ");
INSERT INTO nkn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu uamukumbuluile nguendi, “Uakuisuliua Simoni muna Yona! Omuo keti vuntu vuasholuele evi kuli yove, vuno honi Tate uje hali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kaha njikuleka nguange yove Petulu, ha livue eli njikatunga cikungulukilo cange, kaha nzili ya kutsa ku ikacihiana. ");
INSERT INTO nkn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Njikakuhana masapi a vumuene vua muilu, kaha coshe cije civakavindika hano hamavu na muilu vakacivindika, kaha coshe cije civakatavesa hano ha mavu na muilu vakacitavesa.” ");
INSERT INTO nkn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ambahoni uashikile vandongisi vendi linga keti valekeko muntu umo nguavo ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuhuma ha ntsimbu ije Yesu uaputukile kulumbunuina vandongisi vendi nguendi, njapande kuya ku Yelusalema naku kayanda viuma viavingi kuli vakuluntu na kuli vakuluntu vatusasendote na kuli valongisi va mashiko, kaha vakanjitsiha, vuno honi hanima ya matangua atatu njikasanguka. ");
INSERT INTO nkn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kaha Petulu uamuambatele nakumutuala kualikaliavo na kuputuka kumutenukila nguendi, “Njambi vindika, Muene! Eci kucikalingiua kuli yove!” ");
INSERT INTO nkn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Vuno honi Yesu uatengulukile nakuhandeka kuli Petulu nguendi, “Huma kuli yange yove Satana! Yove unapu citsutsukiso kuli yange, omuo kuukundama kuli Njambi, vuno honi ku vantu.” ");
INSERT INTO nkn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ambahoni Yesu ualekele vandongisi vendi nguendi, “Nga uoshe uje atonda kunjikava, napande kuliviana ikeye vavenia nakuambata cilindakano cendi na kunjikava. ");
INSERT INTO nkn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Omuo uoshe uje atonda kuniunga muono uendi akauzimbalesa, vuno honi uoshe uje azimbalesa muono vuendi omo yange akauuana. ");
INSERT INTO nkn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kaha cikakuasa vika kuli muntu, nga alikunguilila viuma via ha mavu vioshe nakuzimbalesa muono uendi? Kaha vika muntu viakahana linga ahingisemo muono uendi? ");
INSERT INTO nkn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Omuo Muna Muntu akeja na tungelo vendi mu vumpau vua Ishe, kaha akafueta muntu na muntu uoshe kuya ku vilinga viendi. ");
INSERT INTO nkn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Muavusunga njimileka nguange kuli vamo hano vaje ku vakatsi kuvanga noho vanamono Muna muntu neja mu vumuene vuendi.” ");
INSERT INTO nkn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hanima ya matangua atanu na limo Yesu uambatele Petulu na Tiango na munaina Iuano, kaha vahile hamo ku munkinda ualaha kua likaliavo lika. ");
INSERT INTO nkn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaha Yesu ualihimpuile ha mesho avo, kaha na cihanga cendi caviakumine ngue litangua kaha na vuzalo vuendi vuatokele too ngue ceke. ");
INSERT INTO nkn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kaha taleni, ambahoni kuasholokele Mosesa na Eliya vaje vakele na kuhandeka nendi. ");
INSERT INTO nkn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kaha Petulu uahandekele kuli Yesu nguendi, “Muene, cacili yetu kukala kuno, nga utonda njikatunga vimbalaka vitatu kuno, imo yove kaha ikuavo ya Mosesa na ikuavo ya Eliya.” ");
INSERT INTO nkn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tele acili nakuhandeka, kaha hajevene lishelua liakuviakuma liavafuikile, kaha muje mulishelua muahumine lizi ngualio, “Ou ikeye munange injazanga, uje muli ikeye njivuahelela, muivuilileni.” ");
INSERT INTO nkn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Omo vandongisi vevuile evi, vavulumanene ha mavu, kaha vovuile liova cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Vuno honi Yesu uezile nakuvakuata kaha uahandekele nguendi, “Katukeni keti muteue.” ");
INSERT INTO nkn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kaha omo vemukile mesho avo, kuvamuene ueka vuno honi Yesu lika. ");
INSERT INTO nkn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kaha omo vasikumukile kuhuma ha munkinda, Yesu uavashikile nguendi, “Keti valekeko muntu hali uoshe cije cimona, kuvanga noho Muna Muntu vanamusangula ku vatsi.” ");
INSERT INTO nkn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vandongisi vamuhuile nguavo, “Nkuma vika valongisi va lishiko vahandeka nguavo Eliya eje tahi ikeye?” ");
INSERT INTO nkn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu uavakumbuluile nguendi, “Eliya eja nakuhiluisila naua viuma vioshe, ");
INSERT INTO nkn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","vuno honi njimileka nguange Eliya neja laja, kaha kuvamutantekeyele, vuno honi vamulingile muoshe muje muvatondelelemo, omu mukemo vene na Muna Muntu vakamuyandesela.” ");
INSERT INTO nkn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ambahoni vandongisi vevuisisile nguavo alinakuhandeka kuli vakevo via Iuano muka kumbuitika. ");
INSERT INTO nkn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kaha omo vezile ku civunga, yala umo uezile kuli Yesu nakutsikama nakuhandeka nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Muene ivuila cikeketima munange, omuo hali na mushongo uakushinia kaha ukamuyandesa cikuma, omuo ha vintsimbu viavingi akauila mu tuhia na mu mema. ");
INSERT INTO nkn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kaha njamunehele kuli vandongisi vove, vuno honi kuvasele kumukanguisa.” ");
INSERT INTO nkn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kaha Yesu uamukumbuluile nguendi, “Yeni vantu va ntsimbu ino vakuhona lutsilielo na vupi, njikakala neni lungahi? Njikamileka lungahi? Muneheni kuno kuli yange.” ");
INSERT INTO nkn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kaha Yesu uatenukilile lije lihamba, kaha lije lihamba liahumine muli ikeye, kaha hajevene uje kanike uakangukile. ");
INSERT INTO nkn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ambahoni vandongisi vezile kuli Yesu muvushueke nakuhandeka nguavo, “Vika honi yetu kutuasele kulihumisa?” ");
INSERT INTO nkn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kaha uahandekele kuli vakevo nguendi, “Omuo ya lutsilielo lueni lualundende. Muavusunga njimileka nguange nga muli na lutsilielo ngue nona ya mbuto ya musalata, ngue muasa kuhandeka ku munkinda ou ngueni, ‘Huma kuno ya kuje kaha ukaya, kaha na cimo cahi cimukahonoua.’” ");
INSERT INTO nkn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Vuno honi lihamba liangacije kuliekuhuma ngoco kuvanga na lilombelo na kuliumina kulia. ");
INSERT INTO nkn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Omo valikunguluile hamo mu Ngalileya, Yesu uahandekele kuli vakevo nguendi, “Muna Muntu vanapande kumuhana ku mavoko a vantu, ");
INSERT INTO nkn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","vaka mutsihia, kaha vakamusangula munima ya matangua atatu.” Kaha vandongisi vevuile vusiua cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Omo Yesu na vandongisi vendi vezile ku Kapenauma, kaha vaka kutambula lisimu lia mu njivo ya Njambi vaile kuli Petulu nakuhandeka nguavo, “Nkuma mulongisi ueni kekufueta lisimo ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kaha Petulu uavakumbuluile nguendi, “Eyo.” Kaha omo Petulu uakovelele mu njivo, Yesu uahandekele kuli ikeye hakulivanga nguendi, “Simoni vika usinganieka? Nkuma honi kuli veya vimiene va hano ha mavu vakatambula lisimu? Kuli vana vavo indi kuveka?” ");
INSERT INTO nkn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kaha omo Petulu uakumbuluile nguendi, “Kuveka,” kaha Yesu uahandekele kuli ikeye nguendi, “Nankuma vana vanapatuka. ");
INSERT INTO nkn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nankuma keti tuvapihisile, ya lika ku cisali ukalovele, kaha ukambate intsi uje uamaputukilo kaha omo ukafukula mukanua kendi ukauanamo mbongo ya muuaya uaya, kaha yakayambate nakuvahanayo, linga ikapue lisimu liange nove.” ");
INSERT INTO nkn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ha ntsimbu ije vandongisi vezile kuli Yesu nakuhandeka nguavo, “Iya uakama cikuma mu vumuene vua muilu?” ");
INSERT INTO nkn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kaha Yesu uasanene kanike nakumuhaka hhakati kavo, ");
INSERT INTO nkn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kaha uahandekele nguendi, “Muavusunga njihandeka kuli yeni nguange, kuvanga mutenguluke kupua ngue ava vanike, keti ngoconi kumukakovela mu vumuene vua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Uoshe uje alikehesa ikeye vavenia ngue ou kanike, ikeye napu uakama mu vumuene vua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Uoshe uje atambula kanike ou mu lizina liange na tambula yange. ");
INSERT INTO nkn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Vuno honi uoshe uje alingisa ava vanike vavandende vaje vatsiliela muli yange kulinga vupi, cacili kuli ikeye kumukutilila livue liakulolela vunga mu ntsingo yendi kaha nakumukokela ha seta ya cisali. ");
INSERT INTO nkn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Cisingo ha mavu omuo ya vieseko vije vituala ku vupi! Omuo cilivene vieseko evi vija, vuno honi cisingo kuli muntu uje vieseko evi vizila! ");
INSERT INTO nkn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kaha nga livoko liove cipue mukono uove vikulingisa linga ulinge vupi, vitete nakuviumbila kuti, cacili kuli yove kukovela mu muono oku ucisualonda cipue cilema kupulakana na mavoko avali cipue mikono ivali nakukumbila mu tuhia tua miaka yoshe ya yaye. ");
INSERT INTO nkn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kaha nga lisho liove likulingisa linga ulinge vupi, kaha licokovolemo nakuliumbila kuti, cacili kuli yove kukovela mu muono na lisho limo kupulakana na mesho avali aje akanehesa linga vakakumbile mu ngehena ya tuhia. ");
INSERT INTO nkn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Taleni keti musembulule ava vanike vavandende, omuo njimileka nguange muilu muli tungelo vaje ntsimbu yoshe vakamono cihanga ca Tate uje hali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Omuo Muna Muntu uezile nakuovola vaje vanazimbala. ");
INSERT INTO nkn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Vika musinganieka? Nga yala hali na vampanga cihita, kaha umo uavo nazimbala, nkuma kaseze vaje makumi atanu na auana na vatanu na vauana (99) ha munkinda nakuya mukutonda uje nazimbala ndi? ");
INSERT INTO nkn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kaha nga amuuana, muavusunga njimileka nguange akavuahelele cikuma omuo yendi kupulakana vaje makumi atanu na auana na vatanu na vauana (99) vaje kuvazimbalele. ");
INSERT INTO nkn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mucifua cimo vene Tate ua muilu katondo ngeci umo uava vanike vavandende vanonge. ");
INSERT INTO nkn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nga mukueni na kupihisila, ya uye ukamuleke vije via nakupihisila, muvuvali vueni lika. Nga akuivuilila kaha uamuovola. ");
INSERT INTO nkn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Vuno honi nga ka kuivuilila, kaha ambatako umo cipue vavali linga mezi oshe akapue navukaleho vua vantu vavali cipue vatatu. ");
INSERT INTO nkn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nga aviana kuvevuilila, kaha lekesako cikungulukilo, kaha nga naua aviana kuivuilila cipue ku cikungulukilo, mupuise ngue vaje keti Vayunda na vaka kutambula lisimu. ");
INSERT INTO nkn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Muavusunga njimileka nguange, coshe cije civakavindika hano hamavu na muilu naua vakacivindika, kaha coshe cije civakatavesa hano hamavu na muilu naua vakacitavesa. ");
INSERT INTO nkn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kaha naua njimileka nguange, nga muvuvali vueni mulitavasana hano ha mavu ha cuma mukalomba, vakamilingilaco kuli Tate ua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Omuo kuje kunakungulukila vavali cipue vatatu mu lizina liange, kuje vene nange naua njili hhakati kavo.” ");
INSERT INTO nkn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ambahoni Petulu uezile kuli Yesu nakuhandeka nguendi, “Muene, nkuma lungahi njasa kukonekela muanetu nga na njipihisila? Nkuma lualuingi vintsimbu vitanu na vivali ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu uamukumbuluile nguendi, “Njikulekesa nguange keti luakupua vintsimbu vitanu na vivali, vuno honi luakupua makumi atanu na avali na vintsimbu vitanu na vivali.” ");
INSERT INTO nkn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nankuma vumuene vua muilu tuvuesekesa na muene uje uatondele kufueta vangamba vendi. ");
INSERT INTO nkn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Omo uaputukile linga avafuete, kaha vamunehelele yala uje uakele na mukuli kuli ikeye ua vimbazuvuila via ngolinde viakupua makulukazi likumi (10 0 0). ");
INSERT INTO nkn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kaha omo uje yala uahonouele kumufueta, uje muene uendi uashikile linga vamulandese hamo na mpueyendi, na vana vendi na vioshe vije viakele navio linga afuete. ");
INSERT INTO nkn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kaha uje ngamba uatsikamene ha mavuli endi ku mesho endi nakumulomba nguendi, ‘Muene acinjivandameneko tahi, kaha njikakufueta vioshe!’” ");
INSERT INTO nkn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaha uje muene uevuililile ngozi uje ngamba kaha uamuecelele nakumukonekela mukuli uendi. ");
INSERT INTO nkn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Vuno honi uje vene ngamba omo uaile ualiuanene na umo uavakuavo vangamba uje uakele na mukuli uendi uakupua cihita ca vimbongo via muuayauaya. Kaha uamukuatele ha milivu nakuhandeka nguendi, ‘Njifuete mukuli uange.’ ");
INSERT INTO nkn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kaha uje mukuavo ngamba uauililile ha mavu nakumulambelela nguendi, ‘Acinjivandameneko tahi, kaha njikakufueta.’ ");
INSERT INTO nkn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Vuno honi uavianene kaha uamutualele mu kamenga noho hakafuetela uje mukuli uendi. ");
INSERT INTO nkn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Omo vakuavo vangamba vamuene vije vialingiuile, kuvevuile muacili, kaha vaile nakuambulula kuli muene uavo vije vioshe vialingiuile. ");
INSERT INTO nkn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ambahoni uje muene uendi uamusanene nakuhandeka kuli ikeye nguendi, ‘Yove ngamba uamupi! Njakukonekelele uje mukuli uoshe omuo uanjilambelelele. ");
INSERT INTO nkn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kaha vika honi yove kuuamuvuilileko cikeketima mukueni ngamba, ngue muje munjakuivuililile cikeketima yange?’ ");
INSERT INTO nkn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kaha na vutenu uje muene yendi uamutualele ku vaka kamenga linga vamuzangamese kuvanga noho akafueta mukuli uoshe uje uakele nauo.” ");
INSERT INTO nkn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Omu mukemo vene na Tate ua muilu akalinga yeni voshe, nga kumukakonekela vamuanoko kuhuminina ku mitima yeni.” ");
INSERT INTO nkn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Omo Yesu uamanusuile kuhandeka evi, uahumine mu Ngalileya uaile ku cihela ca Yundeya musinia lia ndonga ya Yundau. ");
INSERT INTO nkn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kaha civunga cakama ca mukavele, kaha ua vakanguisile kuje. ");
INSERT INTO nkn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Vafaliseo vamo vezile kuli ikeye nakumueseka, mukumuihula nguavo, “Nkuma capua lishiko yala kukondola mpuevo yendi ha mulonga uli uoshe indi?” ");
INSERT INTO nkn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nankuma Yesu uavakumbuluile nguendi, “Kumuatandele nguavo uje uavatangele ku maputukilo ua vatangele yala na mpuevo.” ");
INSERT INTO nkn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Uahandekele nguendi, “Omuo hacifua eci yala akaseza vaishe na vaina na kulipandakana hamo na mpuevo yendi, kaha vavali va kapua muvila umo lika.” ");
INSERT INTO nkn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaha kuvapu vavali vuno honi vapua muvila umo lika. Kaha cije Njambi napandakana hamo keti vakacihangunune. ");
INSERT INTO nkn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kaha Vafaliseo vahandekele kuli ikeye nguavo, “Nkuma vikahoni Mosesa uashikile umo yala kuhana mukanda uakukondola kuli mpueyendi nakumusheka?” ");
INSERT INTO nkn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kaha Yesu uahandekele kuli vakevo nguendi, “Omuo yakukaluua ca mitima yeni Mosesa uamitavesele linga mukondole vampuevo veni, vuno honi kumaputukilo kucapuile ngoco. ");
INSERT INTO nkn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kaha njihandeka kuli yeni nguange, uoshe akondola mpuevo yendi, kuakuhona kulinga vupangala, nakuambata mpuevo ueka, kaha alinga vupangala.” ");
INSERT INTO nkn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vandongisi vahandekele kuli ikeye nguavo, “Nga mukemo ngoco hali yala na mpuevo yendi, nkuma cacili kuhona kuambata.” ");
INSERT INTO nkn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Vuno honi uahandekele kuli vakevo nguendi, “Keti muntu uoshe atambula evi vihandeka, kuvanga lika kuli vaje vavanavihana. ");
INSERT INTO nkn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Omuo kuli vamo vaje kuvasa kuambata omuo vasemukile muje vene, kaha kuvali vamo vaje kuvasa kuambata omuo vantu vanavalingimo, kaha naua kuvali vamo vaje kuvambata omuo vanalingi vakevo vavenia ngoco vene omuo ya vumuene vua muilu. Kaha uoshe uje atambula evi, avitambule.” ");
INSERT INTO nkn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ambahoni vanehele vanike vavandende kuli Yesu linga avasaleke mavoko endi nakuvalombelela. Vuno honi vandongisi vatenukilile vaje vantu vavanehele. ");
INSERT INTO nkn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Vuno honi Yesu uahandekele nguendi, “Eceleni vanike vavandende veje kuli yange, keti muvavindike, omuo vumuene vua muilu vunapu vuavo.” ");
INSERT INTO nkn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kaha uavasalekele mavoko endi kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kaha taleni, umo muntu uezile kuli Yesu nakumuihula nguendi, “Mulongisi, cuma muka cacili njapande kulinga, linga njikakale na muono uayaye?” ");
INSERT INTO nkn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu uahandekele kuli ikeye nguendi, “Vika unjihuila vije via cili?” Kuli lika umo ikeye uacili. Vuno honi nga utonda kukovela mu vuyoye, niunga mashiko. ");
INSERT INTO nkn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Uje muntu uamuihuile nguendi, “Vika?” Kaha Yesu uamukumbuluile nguendi, “Keti ukatsihe, keti ukalinge vupangala, keti ukeve, keti ukahane vukaleho vua makuli, ");
INSERT INTO nkn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","singimika isho na noko, kaha zanga mukueni ngue muje muualizangela yove vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kaha uje mukuenje uamuhuile nguendi, “Vioshe evi njaviniungu.” Vika naua vikuavo vinjasa kulinga? ");
INSERT INTO nkn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kaha Yesu uahandekele kuli ikeye nguendi, “Nga utonda kupua uakusungama, ya linga ukalandese viuli navio kaha uvihane ku vihutu, kaha ukakala na vufuko muilu, kaha ija, njikave.” ");
INSERT INTO nkn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Omo uje mukuenje uevuile evi uaile navusiua, omuo uakele na vufuko vua vuingi cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kaha Yesu uahandekele kuli vandongisi vendi nguendi, “Muavusunga njihandeka kuli yeni nguange, cikapua ca cikalu kuli muka kufuka kukovela mu Vumuene vua muilu. ");
INSERT INTO nkn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Njimileka naua nguange, ca casi kamelu kuhita mu lisho lia nguya, kupulakana muka kufuka kukovela mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Omo vandongisi vovuile eci, valikomokelele cikuma, nakuhandeka nguavo, “Kaha iya honi akovoka?” ");
INSERT INTO nkn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Vuno honi Yesu uavatalele nakuhandeka kuli vakevo nguendi, “Eci cacikalu ku vantu vuno honi kuli Njambi vioshe viapua viaviasi.” ");
INSERT INTO nkn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kaha Petulu uahandekele nguendi, “Tuaseze vioshe nakukukava. Vika honi tukakala navio?” ");
INSERT INTO nkn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu uavakumbuluile nguendi, “Muavusunga njimileka nguange, mu mavu a maha, omo Muna Muntu akatumama ha litanda liendi lia vumpau, yeni vaje muanjikavele mukatumama ha matanda makumi na avali, mukusompa miyati likumi na ivali ya Isaleli. ");
INSERT INTO nkn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Uoshe uje naseza vinjivo viendi, cipue vamunaina vavamala, cipue vamunaina vavampuevo, cipue vaishe, cipue vaina, cipue vana vendi cipue vihela, omuo ya lizina liange, akatambula cihita ku vioshe nakusuana muono ua yaye. ");
INSERT INTO nkn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Vuno honi vavengi vaje vakulivanga vakapua vakumanusuila, kaha vakumanusuila vakapua vakulivanga.” ");
INSERT INTO nkn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Omuo vumuene vua muilu vunapu ngue vavenia njivo uje cimene mene uaile nakulania vaka kupanga mu lihia liendi lia viniu. ");
INSERT INTO nkn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hanima yakulitavasana na vaka kupanga ha fueto ya ha litangua, kaha uavatumine mu lihia liendi lia viniu. ");
INSERT INTO nkn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kaha ha ntsimbu ya muciuana ku cimene omo uaileko uamuene vamo vanemana ngoco ku cihela cakulandesela, ");
INSERT INTO nkn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","kaha uahandekele kuli vakevo nguendi, ‘Neni naua yemuye mukapange mu lihia lia viniu, kaha njikamifueta fueto ije inapandemo. Kaha vaile.’ ");
INSERT INTO nkn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kaha uaileko naua ku ntsimbu ya likumi na vivali ya mutania na ntsimbu ya likumi na vitanu na vivali ku mutania uacinguezi, kaha uatumineko vakuavo naua. ");
INSERT INTO nkn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kaha ku ntsimbu ya mu citanu ya cinguezi uaile naua ku cihela ca kulandesela kaha uakauanene naua veka vanemana ngoco, kaha uahandekele kuli vakevo nguendi, ‘Nkuma vika honi munemanena lika kuno ngoco ha litangua lioshe liamutuntu?’ ");
INSERT INTO nkn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kaha vahandekele kuli ikeye nguavo, ‘Omuo naumo uahi natulania.’ Kaha uahandekele kuli vakevo nguendi, ‘Yemuye mu lihia neni.’ ");
INSERT INTO nkn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kaha omo cinguezi cahetele, uje vavenia lihia uahandekele kuli muka kutuamenena vaka kupanga nguendi, ‘Sana vaka kupanga linga uvafuete fueto yavo, putukila na vaje vakukotokela kaha manusuila na vaje vakulivanga.’ ");
INSERT INTO nkn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kaha omo vaje vavalaniene ha ntsimbu ya mucitanu ya mutania ua cinguezi vezile, umo na umo uavo uatambuile fueto ya ha litangua limo. ");
INSERT INTO nkn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Honi omo vaje valivangele vezile, vasinganiekele nguavo hamo vakatambula viavingi, vuno honi umo na umo uavo navo uatambuile fueto ya ha litangua limo. ");
INSERT INTO nkn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kaha omo vatambuile vaputukile kulinienieta kuli uje vavenia lihia ");
INSERT INTO nkn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nguavo, ‘Ava vakukotokela vanapanga lika hola imo, kaha unavapuisa hamo netu vaje vanapanga litangua lioshe mukatania.’ ");
INSERT INTO nkn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Vuno honi vavenia lihia uakumbuluile umo uavo nguendi, ‘Kavusamba, kunjakulingile mua mupi, nkuma kutualitavasanene kupangela fueto ya ha litangua limo ndi?’ ");
INSERT INTO nkn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ambata vije vinakupande kaha ya, njinahangula kuhana vaje vakukotokela eci ngue muje munjinahanena yove. ");
INSERT INTO nkn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nkuma kunjasa kulinga muje munjitondela na vimbongo viange ndi? Cipue nkuma yove uli nacipululu omuo ya ngozi yange ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kaha omu mukemo vene mucikafua, vaka kukotokela vakapua vaka kulivanga, kaha vaka kulivanga vakapua vaka kukotokela. ");
INSERT INTO nkn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Omo Yesu tele alinakuya ku Yelusalema, uaile hamo na vandongisi vendi likumi na vavali kuavo lika, kaha mu ngila uahandekele kuli vakevo muvushueke nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Taleni, tulinakuya ku Yelusalema, kaha Muna Muntu vakamuhana kuli vakuluntu va tusasendote nakuli valongisi va mashiko kaha vakamuhisa nakumutuala ku kutsa, ");
INSERT INTO nkn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kaha vakamuhana kuli vaje keti Vayunda linga vaka mushendumune nakumupupanga nakumushukika ha cilindakano, kaha vakamusangula hanima ya matangua atatu.” ");
INSERT INTO nkn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ambahoni naye ya vana va Zembendeo uezile kuli Yesu hamo na vana vendi, uatsikamene ku mesho endi kaha uamulombele cuma cimo. ");
INSERT INTO nkn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kaha Yesu uahandekele kuli ikeye nguendi, “Vika utonda?” uamukumbuluile nguendi, “Shika linga ava vana vange vavali linga vatumame umo ku livoko liove liacilio mukuavo kulia cimoshue mu vumuene vuove.” ");
INSERT INTO nkn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Vuno honi Yesu uamukumbuluile nguendi, “Ku utantekeya vika vije ulinakulomba. Nkuma muasa kunua nganja ije injikanuina ndi?” Vamukumbuluile nguavo “Tuasa.” ");
INSERT INTO nkn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu uahandekele kuli vakevo nguendi, “Mukanuina mu nganja yange, vuno honi kutumama ku livoko liange liacilio na lia cimoshueni, keti yange njili nanzili yakucitavesa, vuno honi cinapu cavaje Tate navuahesele laja.” ");
INSERT INTO nkn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kaha omo vaje likumi vacuvuile, vanienguelele vaje vamunaina vavali. ");
INSERT INTO nkn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Vuno honi Yesu uavasanene nakuhandeka nguendi, “Muatantekeya ngueni vaka kuyula va vaje keti Vayunda vali nanzili hali vakevo, kaha na vantuama vavo vali na nzili yakama hali vakevo. ");
INSERT INTO nkn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kucikafu muje hali yeni. Vuno honi uoshe uje akapua uakama hali yeni akapua ngamba yeni, ");
INSERT INTO nkn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kaha uoshe akapua uakulivanga hali yeni akapua ngamba yeni, ");
INSERT INTO nkn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","cipue Muna Muntu kezile mukumuovola vuno honi mukuovola, nakuhana muono uendi ngue fueto mukuovola vavengi.” ");
INSERT INTO nkn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kaha omo Yesu na vandongisi vendi vahumine ku Yeliko, civunga cakama camukavele. ");
INSERT INTO nkn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kaha taleni, vamala vatupuputua vavali vatumamene ku mukulo ua tapalo, kaha omo vevuile nguavo Yesu alinakuhita, vatambekele nguavo, “Tuvuileko cikeketima Muna Ndaviti.” ");
INSERT INTO nkn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaha cije civunga cavatenukilile nguavo vaholoke kuluu, vuno honi vatambakanene cikuma honi nguavo, “Muene, tuvuileko cikeketima, Muna Ndaviti!” ");
INSERT INTO nkn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kaha Yesu uemanene nakuvasana nguendi, “Vika mutonda linga njimilingile?” ");
INSERT INTO nkn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Vahandekele kuli ikeye nguavo, “Muene tutonda kumona.” ");
INSERT INTO nkn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kaha Yesu hakuvevuila cikeketima uakuatele ha mesho avo, kaha hajevene vaputukile kumona kaha vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kaha omo Yesu na vandongisi vendi vahetele kuyehi na Yelusalema, vaile ku Mbetafanje ku munkinda ua Oliveta, ambahoni Yesu uatumine vandongisi vavali, ");
INSERT INTO nkn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nakuhandekele kuli vakevo nguendi, “Yeni ku limbo lije lia litala neni, kaha hajevene mukauana cimulu vanamukutu na munendi, kaha vazituleni munjinehelevo. ");
INSERT INTO nkn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nga muntu umo akahandeka cimo kuli yeni, mukahandeke ngueni, ‘Muene hali nakuvatonda, kaha akavahiluisa mu vuasi vuasi.’” ");
INSERT INTO nkn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Evi vialingiuile linga vilishulisise vije viahandekele kananguizi ua Njambi nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Leka muana ua mpuevo ua Siyoni nguove, Tala, muene yove hali nakuija kuli yove Uje uakulikehesa kaha nalondo ha cimulu, na hali muna cimulu.” ");
INSERT INTO nkn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kaha vandongisi vaile nakukalinga muje muavashikilililemo Yesu, ");
INSERT INTO nkn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ambahoni vanehele uje cimulu na munendi, kaha vajalele tuzaku tuavo ha miongo ya vimulu, kaha Yesu uatumameneho. ");
INSERT INTO nkn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Vuingi vua vivunga vajalele tuzaku tuavo mu ngila, kaha vakuavo naua vatetele mitango ya miti vajalele mu ngila. ");
INSERT INTO nkn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kaha cije civunga caile halutue liendi na vaje vamukavangeyele vatambekele cikuma nguavo, “Hosana kuli Muna Ndaviti! Njambi amukuisule ou eja mu lizina lia Muene! Lemeseni Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kaha omo uakovelele mu Yelusalema, nganda yoshe ya lijajelelele vahandekele nguavo, “Iya ou?” ");
INSERT INTO nkn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kaha vivunga via vantu vahandekele nguavo, “Ou ikeye kananguizi ua Njambi Yesu uaku Nazaleta yamu Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kaha Yesu uakovelele mu mbalanda ya njivo ya Njambi nakusheka voshe vaje vakele nakulandesa na vaje vakele nakulanda mu njivo ya Njambi, kaha uafulumikile vimesa via vaje vakele nakulandulula vimbongo na vitumamo via vaje vakele nakulandesa mavembe. ");
INSERT INTO nkn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kaha uahandekele kuli vakevo nguendi, “Vacisoneka nguavo, njivo yange vakaitumbula njivo ya malombelo, vuno honi yeni muaipuisa cihela ca vezi.” ");
INSERT INTO nkn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kaha tupuputua na vilema vezile kuli ikeye mu njivo ya Njambi, kaha uavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Vuno honi omo vakuluntu vatusasendote na valongisi va mezi omo vamuene viuma viacili vije vialingile, na vanike vavandende vatambekele mu njivo ya Njambi nguavo, “Hosana Muna Ndaviti,” Nankuma vanienguele cikuma, ");
INSERT INTO nkn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","kaha vahandekele kuli ikeye nguavo, “Uli nakuvua evi vivalinakuhandeka ava ndi?” Kaha Yesu uahandekele kuli vakevo nguendi, “Eyo, nkuma kumuatandele nguavo, ‘Mu tunua tua vanike na vaje vali nakujamua mukemo mukahumu kulemesa ca vusunga ndi’?” ");
INSERT INTO nkn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kaha Yesu uavasezele, uahumine mu nganda nakuya ku Mbeteniya kukeko kuakakosele. ");
INSERT INTO nkn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cimenemene omo Yesu uakele nakuhiluka ku nganda ya Yelusalema, uevuile njala. ");
INSERT INTO nkn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kaha omo uamuene muti ua mukuyu ku mukulo ua ngila, uaileko kaha uauaneneko nacimo cahi kuvanga maputa lika. Kaha uahandekele kuli ukeuo nguendi, “Keti ukeme vushuka naua!” Kaha hajevene uje muti ua mukuyu uomine. ");
INSERT INTO nkn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Omo vandongisi vacimuene valikomokelele cikuma, kaha vahandekele nguavo, “Nkuma vati honi ahavene ou muti ua mukuyu unomu?” ");
INSERT INTO nkn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kaha Yesu uavakumbuluile nguendi, “Muavusunga njimileka nguange, nga muli na lutsilielo nakuhona kulikanouela, kumukalingi lika evi vinalingiua ku muti ua mukuyu, vuno honi cipue nga mukahandeka kuli ou munkinda ngueni, ‘Katuka linga ukaliumbile mu mema a kalunga, kaha cikalingiua.’ ");
INSERT INTO nkn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nga muli na lutsilielo, vioshe vimukalomba muli lombelo mukavitambula.” ");
INSERT INTO nkn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kaha omo Yesu uakovelele mu mbalanda ya njivo ya Njambi, tele acili nakulongesa, vakuluntu va tusasendote na vakuluntu vezile kuli ikeye nakuhandeka nguavo, “Nzili muka yakama ulinakulinga nayo viuma evi, iya uakuhanene eyi nzili yakama?” ");
INSERT INTO nkn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kaha Yesu uavakumbuluile nguendi, “Nange naua njimihula cihula kaha nga munjikumbulula, kaha nange naua njikamileka nzili yakama injikalingi nayo evi vuima. ");
INSERT INTO nkn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nkuma kumbuitika ca Iuano cahumine kuli? Cahumine kuilu indi cahumine ku vantu?” Kaha valikananganene umo na mukuavo nguavo, “Nga tuhandeka nguetu cahumine muilu, kaha akahandeka kuli yetu nguendi, ‘Nkuma vika honi kumua mutsilielelele?’ ");
INSERT INTO nkn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Vuno honi nga tuhandeka nguetu, ‘Cahumine ku vantu,’ kaha tuteua civunga ca vantu, omo voshe vatsilielele nguavo Iuano uapuile kananguizi ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaha vakumbuluile Yesu nguavo, “Kututantekeya,” Kaha uahandekele kuli vakevo nguendi, Kaha nange naua kunjimilekesa kuje kunjikahumisa eyi nzili yakama injili nakulinga nayo viuma evi. ");
INSERT INTO nkn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nkuma yeni vika muhandekaho? Kuakele yala uje uakele na vana vavali va vamala, kaha uaile kuli uakulivanga nakuhandeka kuli ikeye nguendi, ‘Lelo ya ukapange mu lihia lia mikolovozi.’ ");
INSERT INTO nkn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kaha uamukumbuluile nguendi, ‘Kunjiiko’ vuno honi muka ntsimbu lika uatengulukile nakuya. ");
INSERT INTO nkn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kaha uaile kuli uamucivali nakukahandeka viakulifua, kaha uamukumbuluile nguendi ‘Njiya muene,’ vuno honi kaile. ");
INSERT INTO nkn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nkuma hali ava vavali iya ualingile cizango ca ishe?” Vamukumbuluile nguavo, “Uakulivanga.” Kaha Yesu uahandekele kuli vakevo nguendi, muavusunga njihandeka kuli yeni nguange, vaka kutambula lisimu na vikoyi vakovela mu vumuene vua Njambi yeni kanda. ");
INSERT INTO nkn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Omo Iuano uezile kuli yeni mu ngila ya vusunga, kaha kumuamutsilielele, vuno honi vaka kutambula lisimu na vikoyi vamutsilielele, vuno honi cipue vene muacimuene, vuno honi kumuatengulukile nakumutsiliela. ");
INSERT INTO nkn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kaha Yesu uahandekele naua nguendi, “Ivuilileni cisimo cikuavo, Kuakele liavenia njivo uje uakunine lihia lia mikolovozi, kaha uazenguisileko cipatanga, kaha uahindile cina ca kukamuinamo viniu, kaha uatungile kaposhi nakusezelako vaka kupanga, kaha uaile ku cifuti ceka. ");
INSERT INTO nkn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Omo ntsimbu ya kuteja vushuka yakele muyehi, uatumine vangamba vendi kuli vaka kupanga, linga vakambate vushuka vuendi, ");
INSERT INTO nkn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kaha vaje vaka kupanga vakuatele vangamba vendi kaha vapupileho umo, nakutsihaho umo, kaha nakuashaho umo mavue. ");
INSERT INTO nkn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kaha naua uatumine vangamba veka, kupulakana va kulivanga, kaha navakevo vene vavalingile cifua cimo. ");
INSERT INTO nkn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuhuma haje uatumine munendi kuli vakevo nguendi, ‘Vakamusingimika munange.’ ");
INSERT INTO nkn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vuno honi vaje vaka kupanga omo vamuene uje muana, valihandekese umo na mukuavo nguavo, ‘Ou ikeye muna uje vavenia lihia, tuyeni tumutsihe kaha tukasuana lihia liendi.’ ");
INSERT INTO nkn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kaha vamukuatele nakumumbila hambanza ya lihia lia mikolovozi, nakumutsiha. ");
INSERT INTO nkn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nankuma omo liavenia lihia lia mikolovozi ua viniu akeja, nkuma akalinga vika kuli vaje vaka kupanga?” ");
INSERT INTO nkn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vahandekele kuli ikeye nguavo, “Akatsiha vaje vantu va vapi kaha vakatsa mua mupi, kaha akahana lije lihia lia mikolovozi ua viniu kuvaka kupanga veka vaje vakamuhana vushuka mu ntsimbu yavo.” ");
INSERT INTO nkn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu uahandekele kuli vakevo nguendi, “Nkuma kumuatandele mu visoneka nguavio, “‘Livue lije vene vaka kutunga vavianene, likelio linapu nsina ya mu mbango. Eci cikeco calingile Muene, kaha cinapu cakukomouesa kuli yetu.’” ");
INSERT INTO nkn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nankuma njimileka nguange, “Vumuene vua Njambi vaka miniekavuo nakuvuhana ku vantu vaje vema vushuka vuauo.” ");
INSERT INTO nkn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kaha muntu uoshe uje auila ha livue eli likamutetanga vipindi pindi, vuno honi nga uoshe uje likauila, likamutsena. ");
INSERT INTO nkn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Omo vakuluntu vatusasendote na Vafaliseo vovuile visimo viendi, vatantekeyele nguavo hali nakuhandeka vakevo. ");
INSERT INTO nkn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Vuno honi omo vesekele kumukuta, vateuele civunga ca vantu, omuo vatantekeyele nguavo ikeye kananguizi ua Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kaha naua Yesu uahandekele kuli vakevo mu visimo nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Vumuene vua muilu vunapu kusetekesa ngue muene uje ualingile ciuano ca vulo vua munendi ua yala, ");
INSERT INTO nkn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kaha uatumine vangamba vendi mukusana vaje valaniene ku ciuano ca vulu, vuno honi kuvezileko. ");
INSERT INTO nkn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kaha uatumine vangamba vakuavo naua nguendi, ‘Lekeni vaje vavanalania, Taleni njavuahesa laja viakulia viange, vangombe vange na vimuna vange vakuhindala vanavatsihi, kaha viuma vioshe vinavuaha laja, ijeni ku ciuano ca vulo!’ ");
INSERT INTO nkn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Vuno honi kuvahakeleleko mana, vaile kuavo, umo ku lihia liendi, mukuavo kumingoso yendi, ");
INSERT INTO nkn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","vakuavo vakuatele vaje vangamba vendi nakuvayandesa mua mupi, kaha va vatsihile. ");
INSERT INTO nkn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kaha muene uanienguele cikuma, kaha uatumine masualale vendi nakukavanongesa vaje vatsihile vangamba vendi nakukatsimika vinganda viavo. ");
INSERT INTO nkn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kaha uahandekele kuli vangamba vendi nguendi, ‘Ciuano ca vulo cavuaha laja, vuno honi vaje valaniene kuvezile. ");
INSERT INTO nkn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nankuma yemuye mu vimbango via vitapalo, kaha mukalanie voshe vaje vamukauana veje ku ciuano ca vulo’ ");
INSERT INTO nkn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kaha vaje vangamba vaile mu vitapalo nakukungulula voshe vaje vavauanene, voshe vacili na vaje va vapi, kaha ije njivo ya ciuano ca vulo yashulile na vangezi. ");
INSERT INTO nkn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Vuno honi omo muene uezile nakukovela mukumona vaje vangezi, uamuene ngeci yala umo kazalele vuzalo via ha vulo, ");
INSERT INTO nkn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","kaha uahandekele kuli ikeye nguendi, ‘Kavusamba uakovela vati muno kuakuhona kuzala vuzalo vua ha vulo?’ Kaha uahonouele viakuhandeka. ");
INSERT INTO nkn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ambahoni muene uahandekele kuli vaje vaka kukuasa vangezi nguendi, ‘Mukuteni ku mavoko na ku mikono, mutualeni hambanza mu milima, kuje vantu vaka lila na kulishumanga ku mazo avo.’” ");
INSERT INTO nkn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Omuo vavengi vanavalania, vuno honi vavandende lika vavanahangula.” ");
INSERT INTO nkn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ambahoni Vafaliseo vaile nakutumba vutumbe ngeci vakamueseke navihandeka viendi. ");
INSERT INTO nkn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaha vatumine vandongisi vavo kuli ikeye hamo na Helonde nguavo, “Mulongisi tutantekeya nguetu u yala uavusunga kaha ukalongesa vingila via Njambi mu vusunga, cakuhona kuteua muntu hali uoshe, omuo kuuekutala muntu muafuilamo. ");
INSERT INTO nkn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tuleke vika usinganieka? Nkuma cinapu lishiko kufueta lisimu kuli Sezale, indi kuahi?” ");
INSERT INTO nkn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Vuno honi Yesu uatantekeyele laja vupi vuavo kaha uahandekele nguendi, “Yeni vaka civembulu, vika honi munjesekela? ");
INSERT INTO nkn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Njimueseni vimbongo via lisimu.” Kaha vamunehelele mbongo ya muuaya uaya. ");
INSERT INTO nkn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kaha Yesu uahandekele kuli vakevo nguendi, “Cihanga ceya eci?” “Kaha lizina lieya vanasonekaho?” ");
INSERT INTO nkn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vahandekele nguavo, “Via Sezale.” Ambahoni uahandekekele kuli vakevo nguendi, “Haneni viuma via Sezale kuli Sezale, kaha haneni viuma via Njambi kuli Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Omo vovuile eci valikomokelele cikuma kaha vamusezele vaile. ");
INSERT INTO nkn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ha litangua lije vene Vasanduki vezile kuli Yesu, vaje vakatsiliela nguavo kuesi kusanguka kuvatsi. Kaha vamuhuile cihula nguavo, ");
INSERT INTO nkn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mulongisi, Mosesa uahandekele nguendi, “Nga yala atsa kuakuhona kuseza vana, kaha uje muanaye napande kuambata uje ntuluue, linga asemeneko vana vaje vanapandele kusemenako muanaye. ");
INSERT INTO nkn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ambahoni vapuile vatanu na vavali vamuanaye, kaha uakulivanga uambatele, kaha uatsile, kaha kasezele vana kaha uasezele uje mpueyendi kuli muanaye. ");
INSERT INTO nkn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cuma cakulifua calingiuile kuli uamucivali na kuli uamucitatu, nakuli uje uamu citanu na vavali. ");
INSERT INTO nkn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kumamanuisilo uje mpuevo uatsile. ");
INSERT INTO nkn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kaha mukusanguka, nankuma, akapua mpuevo yeya ha vantu ava vatanu na vavali? Omuo voshe vamuambatele.” ");
INSERT INTO nkn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Vuno honi Yesu uavakumbuluile nguendi, “Yeni muapihisa, omuo kumutantekeya visoneka cipue nzili ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Omuo mukusanguka ku vatsi kukukakala kuambata cipue kushombuesa, vuno honi vakapua ngue tungelo va muilu. ");
INSERT INTO nkn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kaha ngue ha kusanguka kuvatsi, nkuma kumuatandele vije viahandekele Njambi kuli yeni nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yange Njambi ua Avilahama, na Njambi ua Isake, na Njambi ya Yakomba.’ Keti Njambi ua vaka kutsa, vuno honi Njambi ua vaka kuyoya.” ");
INSERT INTO nkn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kaha omo vivunga via vantu vovuile eci, valikomokelele cikuma ha kulongesa cendi. ");
INSERT INTO nkn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Vuno honi omo Vafaliseo vevuile nguavo naholuesa Vasanduki, kaha valikunguluile hamo lika. ");
INSERT INTO nkn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kaha umo uavo, uje uapuile muka kuimanena mashiko, uamuhuile cihula cakumueseka nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mulongisi, nkuma lishiko muka liakama ku mashiko oshe?” ");
INSERT INTO nkn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","“Kaha Yesu uahandekele kuli ikeye nguendi, ‘Ukazanga Muene Njambi yove na mutima uove uoshe, na muono uove uoshe, na mana ove oshe.’ ");
INSERT INTO nkn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eli likelio lishiko liakama lia kulivanga. ");
INSERT INTO nkn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kaha lia mucivali eli, ‘Zanga mukueni ngue muje muualizangela yove vavenia.’ ");
INSERT INTO nkn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ha mashiko aua avali hakeho hanemana mashiko oshe na tunanguizi va Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Honi omo Vafaliseo valikunguluile hamo, Yesu uavehuile cihula, ");
INSERT INTO nkn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","uahandekele nguendi, “Vika musinganieka hali Kilistu? Uapua Muna iya?” Vamukumbuluile nguavo, “Muna Ndaviti.” ");
INSERT INTO nkn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kaha Yesu uavehuile nguendi, “Capuile vati honi, nkuma Ndaviti” vamulongesele kuli Cimbembesi, linga amusane Muene, omo uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Muene uahandekele kuli Muene yange nguendi, Tumama ku livoko liange lia cilio, noho njikahaka vitozi vove muintsi lia viliato viove’? ");
INSERT INTO nkn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nga Ndaviti amusana nguendi Muene, nkuma akapua vati naua munendi?” ");
INSERT INTO nkn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaha naumo uahi uasele kumutava lizi, nankuma kuhuma ha litangua lije vene naumo uahi uesekele kumuihula cihula naua. ");
INSERT INTO nkn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ambahoni Yesu uahandekele ku civunga na kuli vandongisi vendi nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Valongisi va lishiko na Vafaliseo vatumama ha cituamo ca Mosesa, ");
INSERT INTO nkn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","kaha lingeni nakutala vioshe vije vamileka, vuno honi keti vije vivalinga, omuo vakambulula vije kuvekulinga. ");
INSERT INTO nkn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vakakutu viteli via kulema vije viavikalu kuviambata, nakuvituika ha vitsili via vantu, vuno honi vakevo kuvekujundulako cipue na munie uavo ha kuvijundula. ");
INSERT INTO nkn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vioshe vije vivakalingi, vakavilingila linga vantu vavamone, omuo vakakutiliya mikanda ya visoneka ha maholo avo na ha mavoko avo, na vulaha vua tundombe tua tuzaku tuavo, ");
INSERT INTO nkn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","kaha vakevo vazanga cihela ca vulemu ku viuano na vitumamo viacili mu vinjivo via malombelo, ");
INSERT INTO nkn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","nakuvameneka nakasingimiko ku vihela via kulandesela, nakuvasana nguavo ‘Mulongisi’ ku vantu. ");
INSERT INTO nkn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vuno honi yeni keti vamisane mulongisi, omuo muli lika na mulongisi umo lika, kaha yeni voshe muva vusamba. ");
INSERT INTO nkn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kaha keti mukasaneho muntu hali uoshe ‘Tate’ hano ha mavu, omuo muli lika na Ishueni umo, uje hali muilu. ");
INSERT INTO nkn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naua keti vakamisane muene, omuo muli lika na muene umo, ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Uoshe uje uakama hhakati keni akapua ngamba yeni. ");
INSERT INTO nkn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uoshe uje alijundula ikeye vavenia vaka mukehesa, kaha uoshe uje alikehesa ikeye vavenia vaka mujundula. ");
INSERT INTO nkn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Vuno honi tuyando kuli yeni, valongisi va mashiko na Vafaliseo, yeni vaka civembulu! Omuo mukashoko vikolo via vumuene vua muilu ku vantu, omuo neni vavenia kumue kukovelamo, cipue kutavesa vaje vatonda linga vakovele. ");
INSERT INTO nkn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Cisingo kuli yeni, valongisi va mashiko na Vafaliseo, yeni vaka civembulu! Omuo yeni mukapihisa vinjivo via vantuluue mukulimuesa ha kulombela malombelo alaha. Nankuma mukatambula cihiso cakama. ");
INSERT INTO nkn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Cisingo kuli yeni, valongisi va mashiko na Vafaliseo, yeni vaka civembulu! Omuo yeni mukendangana ku mema a kalunga naku ntunda linga mutengululeko muntu umo, kaha omo natenguluka, mukamupuisa luvali kupua muana ua ngehena ngue yeni. ");
INSERT INTO nkn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Cisingo kuli yeni vantuama vatupuputua, yeni vaje mukahandeka ngueni, ‘Nga umo alisinga na njivo ya Njambi, kaha cinapu cangoco, vuno honi nga umo alisinga na ngolinde ya njivo ya Njambi, kaha vanamukutu nacisingo cendi.’ ");
INSERT INTO nkn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yeni tupuputua va vilema! Nkuma cika cakama, ngolinde indi njivo ya Njambi ije ilingisa ngolinde linga ipue yakulela? ");
INSERT INTO nkn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kaha mukahandeka ngueni, ‘Nga umo alisinga na mutula, kaha cinapu cangoco, vuno honi nga umo alisinga na vuana vuje vuli ha mutula, kaha vanamukutu nacisingo cendi.’ ");
INSERT INTO nkn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yeni vantu vatupuputua! Nkuma cika cakama, vuana indi mutula uje ulingisa vuana linga vupue vuakulela? ");
INSERT INTO nkn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nankuma uoshe uje alisinga na mutula, nalisingi nauo na vioshe vije viliho, ");
INSERT INTO nkn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kaha uoshe uje alisinga na njivo ya Njambi, nalisingi nayo na uoshe uje uakalamo, ");
INSERT INTO nkn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kaha uoshe uje alisinga na lilu, nalisingi na litanda lia Njambi na uoshe uje uatumamaho. ");
INSERT INTO nkn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Cisingo kuli yeni, valongisi va lishiko na Vafaliseo, yeni vaka civembulu! Omuo yeni mukahana cavulikumi ca viuma vije mukatovesa mu visapa sapa via minte na ndilu na kumine, nakuyengula viuma viaseho via lishiko, via vusunga na cikeketima na lutsilielo, vije vimuapandele kulinga cakuhona kuyengula vikuavo. ");
INSERT INTO nkn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yeni vantuama vatupuputua, mukahumisa mbulumbulu mu viakunua vieni nakuminisa kamelu! ");
INSERT INTO nkn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Cisingo kuli yeni, valongisi va lishiko na Vafaliseo, yeni vaka civembulu! Omuo yeni mukakushu nganja na lilonga hambanza yavio, vuno honi mukati kavio muashulu nalizangamena nakulizanga yeni vavenia. ");
INSERT INTO nkn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yeni Vafaliseo vatupuputua! Cakulivanga tahi kusheni mukati ka nganja na lilonga, kaha na helu liavio hakatoka. ");
INSERT INTO nkn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Cisingo kuli yeni valongisi va lishiko na Vafaliseo, yeni vaka civembulu! Omuo yeni munapu ngue vihilo vije vivanakushu kaha vinatoko too, vije hambanza liavio vimoneka muacili, vuno honi mukati kavio munashulu na vitsihia via vantu vakutsa na via mazilo vioshe. ");
INSERT INTO nkn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Omu mukemo neni vene mumuli nakusholoka, hambanza musholoka ngue vaka vusunga ku vantu, vuno honi mukati keni munashulu na civembulu na vupi. ");
INSERT INTO nkn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Cisingo kuli yeni valongisi va lishiko na Vafaliseo, yeni vaka civembulu! Omuo yeni mukatungu vihilo via tunanguizi va Njambi va Njambi nakupesapesa viakumunga via vaka vusunga, ");
INSERT INTO nkn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nakuhandeka ngueni, ‘Nga tuayoyele mu matangua aje a vatatetu, ngue kutualingile vije vivalingile vakevo viakumuania maninga a tunanguizi va Njambi va Njambi.’ ");
INSERT INTO nkn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nankuma mulina vukaleho hali yeni vavenia, ngueni mu vana va vaje vatsihile tunanguizi va Njambi va Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nkumani shulisiseni seteko ya va ishueni. ");
INSERT INTO nkn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yeni manoka, yeni vana va manoka, nkuma mukateua vati cihiso ca ngehena? ");
INSERT INTO nkn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nankuma njimitumina tunanguizi va Njambi va Njambi na vaka mana na valongisi va lishiko, vamo vaje vamukatsihia na kushukika ha cilindakano, kaha vamo mukavapupa mu vinjivo vieni via malombelo, nakuvapakesa huma mu mbonge na kuya mbonge ikuavo. ");
INSERT INTO nkn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaha mukatambula kashitiku ka kutsiha vantu voshe vaje vakuhona mulonga, kuhuma ku maninga aua vusunga Avele kuya ku maninga a Zakaliya muna Mbelekiya, uje imuatsihilile mukati ka njivo ya Njambi na mutula. ");
INSERT INTO nkn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Muavusunga njimileka nguange, cihiso coshe cikeja hali vantu va ntsimbu ino. ");
INSERT INTO nkn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yove Yelusalema, Yelusalema, mukakutsiha tunanguizi va Njambi va Njambi nakuasha mavue vaje va vanatumu kuli yove! Nkuma vintsimbu vingahi njakunguluile vana vove hamolika ngue cali muakavutamena vana vendi mu mambava endi, kaha yove kuuatondelemo! ");
INSERT INTO nkn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tala, njivo yove vanaiseze kaha ili mupulungua. ");
INSERT INTO nkn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaha njikuleka nguange, ku ukanjimonoho naua, kuvanga noho ukahandeka nguove ‘Nakuisuliua uje eja mu lizina lia Muene.’” ");
INSERT INTO nkn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu uahumine mu njivo na kuya, kaha vandongisi vendi vezile kuli ikeye nakumumuesa vinjivo via Njambi. ");
INSERT INTO nkn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Vuno honi uavakumbuluile nguendi, “Munamono viuma vioshe evi, indi kuahi? Muavusunga njihandeka kuli yeni nguange, kukuesi cipue livue limo likasala halikuavo, lije kuvakombila ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kaha omo Yesu uatumamene ha munkinda ua Oliveta, vandongisi vendi vezile kuli ikeye muvusueke nakuhandeka nguavo, “Tuleke ntsimbu muka eci cikalingika, kaha cimueso muka cikalingiua hakuija cove na ha ntsimbu ya kuhua ca mavu?” ");
INSERT INTO nkn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kaha Yesu uavakumbuluile nguendi, “Zangameni linga keti umo akamikuise. ");
INSERT INTO nkn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Omuo vavengi vakeja mu lizina liange, nguavo, ‘Yange Kilistu!’ kaha vakakuisa vavengi. ");
INSERT INTO nkn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaha mukevua vinzita nakalua ka vinzita, keti mukakomoke, omuo evi viapande kulingiua, vuno honi eci keti cikeco kukotoka ca mavu. ");
INSERT INTO nkn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Omuo lifuti likatengulukila lifuti likuavo, vumuene vukatengulukila vumuene vukuavo, ku kakala njala ya liangangala na mandunduma ku mitambela ya kuliseza seza. ");
INSERT INTO nkn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Evi vinapu ngue kuputuka ca mushongo uakusema. ");
INSERT INTO nkn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ambahoni vakamituala mukuyanda, nakumitsiha, kaha vaka mafuti voshe vaka mizinda omuo ya lizina liange. ");
INSERT INTO nkn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kaha ambahoni vavengi lutsilielo luavo lukahua, kaha vakalienda vungungu umo na mukuavo na kulizinda umo na mukuavo. ");
INSERT INTO nkn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kaha tunanguizi va Njambi va makuli vavengi vakeja na kukuisa vavengi. ");
INSERT INTO nkn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Omuo kulivuezelela ca vupi cinapu cakama, kaha cizango ca vantu vavengi cikatontola. ");
INSERT INTO nkn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vuno honi uoshe uje akakateya nankuma manusuilo a kovoka. ");
INSERT INTO nkn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kaha muzimbu uacili ou ua vumuene vaka uambulula ha mavu oshe, kupua ngue vukaleho ku mafuti oshe, ambahoni mamanusuilo akeja. ");
INSERT INTO nkn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nankuma omo mukamona cimueso ca shuama cije cahandekele kananguizi Ndaniele cinemana mu cihela ca kulela,” (Yove uli na kutanda uvuisisa muvinalumbunukila!) ");
INSERT INTO nkn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kaha eceleni vaje vali mu Yundeya vateuele ku minkinda, ");
INSERT INTO nkn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","uoshe uje hali helu lia njivo keti ashuluke ha mavu, linga ambate vije vili mu njivo yendi, ");
INSERT INTO nkn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kaha uoshe hali mu lihia keti ahiluke kunima nakuambata cikovelo cendi. ");
INSERT INTO nkn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Caluvinda kuli vaje vali navana na kuli vaje vajamuesa mu matangua aje! ");
INSERT INTO nkn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lombeleni linga keti cikalingike mu cisika cipue ha litangua lia sapalalo. ");
INSERT INTO nkn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Omuo honi ha matangua aje kukakala tuyando, tuje kutuakeleko hume kuputuka ca lifuti kuheta na lelo, kuahi, kaha ku cikakalako naua. ");
INSERT INTO nkn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kaha nga aje matangua kauakehesele nga na muntu uahi akovoka, vuno honi omuo ya vantu vendi vaje vahanguile, matangua aje vaka akehesa. ");
INSERT INTO nkn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Vuno honi, nga umo ahandeka kuli yeni nguendi, ‘Taleni Kilistu uno!’ cipue ‘Uje ali kuje!’ keti mucitsiliele.” ");
INSERT INTO nkn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Omuo Vakilistu va makuli na tunanguizi va Njambi va makuli vakasholoka nakulinga vitantekeyeso na vikomouesa, linga vamizimbalese, nga casiua nakuli vaje vavanahangula. ");
INSERT INTO nkn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vuno honi njamileke ntsimbu kanda ihete. ");
INSERT INTO nkn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Cipue nga vahandeka kuli yeni nguavo, ‘Taleni ali mu mpambo,’ keti muyeko, cipue nga vahandeka nguavo, ‘Taleni, ali mu mulili ua mukati!’ keti mucitsiliele. ");
INSERT INTO nkn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Omuo ngue mulengi ukahuma ku ngangela nakatua ceke kuheta na ku kangombe ka yambi, eci cikapua kuija ca Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kuoshe kuje kuli civimbi kukeko kukalikunguluila makuvi. ");
INSERT INTO nkn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Hanima ya tuyando hamatangua aje litangua likalava, kaha ngonde kuikatu ceke, na vintanga ntanga vikaua kuhuma kuilu, kaha nzili ya melu ikaninganga. ");
INSERT INTO nkn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ambahoni kukasholoka cimueso ca Muna Muntu muilu, kaha miyati yoshe ya hamavu ikalila, kaha vakamona Muna Muntu eja mu mashuela amuilu na nzili na vumpau vuakama. ");
INSERT INTO nkn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kaha akatuma tungelo vendi na mutambi ua lipenga, kaha akakungulula vantu vendi vahanguile kuhuma ku vimpunzi viuana, kuhuma ku mamanusuilo a muilu nakukuavo.” ");
INSERT INTO nkn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Lilongeseni cilongesa ca muti ua mukuyu, omuo mintango yauo ishoshela nakuhaka maputa, kaha muatantekeya ngueni ntondue ili muyehi. ");
INSERT INTO nkn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kaha omo mumona viuma vioshe evi, kaha mutantekeye ngueni ntsimbu ili muyehi, ku vikolo. ");
INSERT INTO nkn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Muavusunga njimileka nguange, vantu va ntsimbu ino kuvakatsi kuvanga vuima vioshe evi vinalingiua. ");
INSERT INTO nkn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Melu na mavu vioshe vikahita, vuno honi mezi ange kuuakahu.” ");
INSERT INTO nkn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Vuno honi ha litangua lije cipue hola naumo uahi atantekeya, cipue vene tungelo va muilu, cipue Muana, vuno honi kuvanga lika Tate. ");
INSERT INTO nkn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngue mucafuile ku matangua a Noua, mukemo vene mucikafua hakuija ca Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Omuo ngue mu matangua aje tele livazi kanda lije vantu valile na kunua, kuambata na kushombuesa, kutuala na ha litangua Noua uakovelele mu vuato, ");
INSERT INTO nkn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kaha kuvatantekeyele noho livazi liezile nakuvanongesa voshe, kaha mukemo mu cikafua akuija kua Muna Mutu. ");
INSERT INTO nkn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kaha vamala vavali vakapua mulihia, kaha umo vakamuambata umo vakamuseza. ");
INSERT INTO nkn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaha vampuevo vavali vakatua mucini cimo, kaha umo va kamuambata, mukuavo vakamuseza. ");
INSERT INTO nkn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Zangameni omuo kumutantekeya litangua lije Muene yeni akeja. ");
INSERT INTO nkn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vuno honi tantekeyeni eci, nga liavenia njivo akatantekeya ntsimbu muka ya vutsiki muizi akeja, kaha nga akavandamena, nakumona nguendi njivo yendi kuvaituvu. ");
INSERT INTO nkn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nankuma neni naua munapande kulivuahesela, omuo Muna Muntu akeja ha hola ije kumutantekeya.” ");
INSERT INTO nkn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Iya honi ngamba ua kulongua na mana uje muene uendi uamuhakele kuendesa vakuavo vangamba nakuvahana viakulia ha ntsimbu ya kupuamo? ");
INSERT INTO nkn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nakuisuliua uje ngamba omo muene uendi omo ahiluka amuuana hali nakulinga mujevene. ");
INSERT INTO nkn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Muavusunga njimileka nguange, akamupuisa kupua mukuluntu ua vufuko vuendi vioshe. ");
INSERT INTO nkn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Vuno honi nga uje ngamba uendi uamupi ahandeka kuli ikeye vavenia nguendi, ‘Muene uange neshuala kuhiluka,’ ");
INSERT INTO nkn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kaha aputuka kupupa vangamba vakuavo, na kulia na kunua na vaka kupenda, ");
INSERT INTO nkn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","muene ua uje ngamba akeja ha litangua olio ka muvandamenene na hola ije katantekeya, ");
INSERT INTO nkn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kaha akamuhana kashitiko na kumuhaka hamo nava kacivembulu, vantu vaje vakalila na kulishumanga ku mazo.” ");
INSERT INTO nkn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ha ntsimbu ije vumuene vua muilu vaka vuesekesa ngue vambanda likumi vaje vambatele vindeya viavo nakuya linga vakaliuane na liavenia vulo. ");
INSERT INTO nkn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vuno honi ava vatanu vapuile viheve, kaha vatanu vapuile vamana. ");
INSERT INTO nkn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Omo vaje vambanda vakuheva vambatele vindeya viavo, kuvambatele na mazi eka naua, ");
INSERT INTO nkn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","vuno honi vaje vamana vambatele mazi mu vintsazi na mu vindeya viavo. ");
INSERT INTO nkn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kaha omo uje liavenia vulo uakotokelele kuija, kaha voshe vaje vambanda vanengukile na kuya mutulo.” ");
INSERT INTO nkn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Vuno honi mukati ka vutsiki vevuile mutambi nguavo, ‘Taleni liavenia vulo uje hali nakuija! Tuhukeni linga muliuane nendi.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kaha voshe vaje vambanda vahindukile nakushukumisa vindeya viavo. ");
INSERT INTO nkn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kaha vaje vakuheva vahandekele kuli vamana nguavo, ‘Tuhaneniko amo mazi eni, omuo vindeya vietu vitonda kuzima.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vuno honi vaje vambanda vamana vakumbuluile nguavo, ‘Kutupuisamo kulipangelauo yetu neni, yemuye kuli vakakulandesa linga mukalilandele yeni vavenia.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kaha tele vanayi mukulanda, liavenia vulo uezile, kaha vaje valivuaheselele vaile nendi ku ciuano ca vulo, kaha vashokele ku cikolo.” ");
INSERT INTO nkn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Hanima honi vaje vambanda vaviheve vezile vahandekele nguavo, ‘Muene, muene, tushokolueleko.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Vuno honi uavakumbuluile nguendi, ‘Muavusunga njihandeka kuli yeni nguange, kunjimitantekeya.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nankuma zangameni, omuo kumutantekeya litangua cipue hola. ");
INSERT INTO nkn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kaha naua Yesu uavalekele nguendi, vumuene vua muilu vukafua ngue yala omo aya mu vungenzi kaha asana vangamba vendi, nakuvasezela vupite vuendi. ");
INSERT INTO nkn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kuli umo uahanene makulukazi atanu a vimbazuvuila via ngolinde, kuli mukuavo makulukazi avali a vimbazuvuila via ngolinde, kuli mukuavo likulukazi limo lia vimbazuvuila via ngolinde, kuya kuvipangi viavo kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kaha uje uatambuile makulukazi atanu a vimbazuvuila via ngolinde uaile hajevene uakavilanduluile, kaha uakapangeleleho naua makulukazi atanu a vimbazuvuila via ngolinde. ");
INSERT INTO nkn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kaha naua na uje mukuavo uatambuile makulukazi avali a vimbazuvuila via ngolinde, uapangeleleho naua makulukazi avali a vimbazuvuila via ngolinde. ");
INSERT INTO nkn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Vuno honi uje ngamba uatambuile likulukazi limo lia vimbazuvuila via ngolinde uaile, nakukahinda cina nakushitikamo vimbongo via muene uendi.” ");
INSERT INTO nkn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Omo kuetile matangua amengi muene ua vaje vangamba uehilukile kaha uatandele navo vije vimbazuvuila via ngolinde. ");
INSERT INTO nkn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kaha uje uatambuile makulukazi atanu a vimbazuvuila via ngolinde uezile, kaha uaneheleleho naua makulukazi atanu a vimbazuvuila via ngolinde, nakuhandeka nguendi, ‘Muene uanjihanene makulukazi atanu a vimbazuvuila via ngolinde, kaha naua njapangelaho makulukazi atanu a vimbazuvuila via ngolinde eka naua.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Muene uendi uahandekele kuli ikeye nguendi, ‘Ualingi muacili, ngamba uacili uakukonkama! Unapu uakunkokama a viuma via vindende, njikakupuisa mukuluntu uaviuma viavingi. Kovela mukuvuahelele ca muene yove.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kaha na uje uatambuile makulukazi avali a vimbazuvuila via ngolinde uezile kuli ikeye nguendi, ‘Muene uanjihanene makulukazi avali a vimbazuvuila via ngolinde, hano njapangelaho makulukazi avali a vimbazuvuila via ngolinde eka naua.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Muene uendi uahandekele kuli ikeye nguendi, ‘Ualingi muacili, ngamba uacili uakunkokama! Unapu uakunkokama a viuma via vindende, njikakupuisa mukuluntu uaviuma viavingi. Kovela mukuvuahelele ca muene yove.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kaha na uje uatambuile likulukazi limo, lia ngolinde uezile, uahandekele kuli muene uendi nguendi, ‘Muene njakutantekeya nguange uapua u muntu uamukalu cikuma, ukateja vije kuuakuvile, kaha ukakungulula vije kuuashanduile, ");
INSERT INTO nkn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","kaha njevuile liova, kaha njaile nakushitika ngolinde yove mu livu. Viuma viove evi.’” ");
INSERT INTO nkn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Vuno honi muene uendi uamukumbuluile nguendi, “Yove ngamba uamupi ua cilenda! Uatantekeyele nguove njikateje kuje kunjakuvile, kaha njikakungulula vije kunjashanduile? ");
INSERT INTO nkn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ambahoni uasinganiekele kutulikisa vimbongo viange kuli vakakutulika vimbongo, kaha nga hakuija cange ngue njatambuile vije viapuile viange na kakondueso kayo. ");
INSERT INTO nkn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Mutambuleni vimbongo vije vili kuli ikeye, kaha vianeni kuli uje hali na makulukazi avimbongo likumi. ");
INSERT INTO nkn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Omuo uje alinavio vakamuvuezelelako, kaha akakala na viavingi, vuno honi uje kesi navio, cipue vene vije via vindende vialinavio vakamuniekavio. ");
INSERT INTO nkn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nakushekela ngamba uje kesi nacimo ha mbaza ya milima, kuje vantu vakalila na kulishumanga mazo avo.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Omo Muna Muntu akeja mu vumpau vuendi, hamo na tungelo vendi voshe, kaha akatumama halitanda liendi lia vumpau. ");
INSERT INTO nkn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kuli ikeye miyati yoshe ya vantu ikalikungulula, kaha akavatepesa umo ku mukuavo ngue kaniungi muakatepesa vampanga ku vampembe, ");
INSERT INTO nkn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kaha akahaka vampanga ku livoko liendi lia cilio, vuno honi vampembe ku livoko liendi lia cimoshue. ");
INSERT INTO nkn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ambahoni Muene akahandeka kuli vaje vali ku livoko liendi lia cilio nguendi, ‘Ijeni, yeni vanakuisuliua kuli Tate suaneni vumuene vuje vuanamivuaheselele kuhuma ha luvula lua mavu. ");
INSERT INTO nkn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Omuo njakele na njala muanjihanene viakulia, kaha omo njakele na mpuila muanjihanene mema akunua, kaha omo njakele njimungezi muanjitambuile, ");
INSERT INTO nkn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","njakele mitotototo muacizikile, njakele nakuvavala kaha muanjimenekelele, njakele mu kamenga kaha muezile mukunjimona.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ambahoni vaka vusunga vakamukumbulula nguavo, ‘Muene, kuli tuakumuene uli na njala kaha tuakulisile, cipue unevu mpuila kaha tuakunuisile? ");
INSERT INTO nkn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kaha kuli tuakumuene umungezi kaha tuakutambuile cipue mutotototo kaha tuakuzikile? ");
INSERT INTO nkn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kaha kuli tuakumuene uli nakuvavala cipue uli mu kamenga kaha tuezile nakukumona?’ ");
INSERT INTO nkn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaha muene akavakumbulula nguendi, ‘Muavusunga njimileka nguange omo muacilingile ku vamo ava va vusamba vange, mua cilingile kuli yange.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ambahoni akahandeka kuli voshe vaje vali ku livoko liendi lia cimoshue nguendi, ‘Humeni kuli yange, yeni vaka kusingiua! Yeni mu tuhia tua miaka yoshe tuje tuvanavuahesela liyavolo na tungelo vendi. ");
INSERT INTO nkn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Omuo njakele na njala kumuanjihanene via kulia, njakele na mpuila kumuanjihanene mema akunua, ");
INSERT INTO nkn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","njakele njimungezi kaha kumuanjitambuile, njakele mitotototo kaha kumuanjizikile, njavavalele nakukala mukamenga kaha kumuacimenekelele.’ ");
INSERT INTO nkn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ambahoni navakevo vakakumbulula nguavo, ‘Muene kuli tuakumuene uli na njala, cipue uli na mpuila, cipue umungezi, cipue mutotototo, cipue uvavala, cipue mu kamenga, kaha kutuakukuasele?’ ");
INSERT INTO nkn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ambahoni akavakumbulula nguendi, ‘Muavusunga njimileka nguange, ngue muje kumuacilingile kuli umo uava vavandende, kumuacilingile kuli yange’ ");
INSERT INTO nkn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kaha vakaya mukashitiko ka miaka yoshe, vuno honi vaka vusunga vakakovela mu muono ua yaye.” ");
INSERT INTO nkn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Omo Yesu uamanusuile kuhandeka vuima vioshe evi, uahandekele kuli vandongisi vendi nguendi, ");
INSERT INTO nkn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Muatantekeya ngueni omo munima ya matangua avali paseka ili na kuija, kaha Muna Muntu vaka muhana linga vakamushukike hacilindakano.” ");
INSERT INTO nkn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ambahoni vakuluntu vatusasendote na vakuluntu va vantu valikunguluile mu lipela lia kasasendote uakama, uje ivatumbuile nguavo Kayafase, ");
INSERT INTO nkn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kaha vatumbile vutumbe hamo linga vakute Yesu mu vushueke nakumutsiha. ");
INSERT INTO nkn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Vuno honi vahandekele nguavo, “Keti a ciuano, hamo vantu vakaneha mpindangano.” ");
INSERT INTO nkn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kaha omo Yesu uakele ku Mbeteniya mu njivo ya Simoni yala uje uakele na mbumba, ");
INSERT INTO nkn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Omo Yesu te uakele nakulia kumesa, mpuevo umo uezile kuli ikeye na ntsazi ya mazi andando yakama hakunika luengo luacili, kaha uahetilile ha mutue ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vuno honi omo vandongisi vacimuene vanienguele cikuma nakuhandeka nguavo, “Nkuma vika apihisila mazi? ");
INSERT INTO nkn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Omuo mazi aua vapandele kuualandesa na ndando yakama, nakuana vimbongo vihutu.” ");
INSERT INTO nkn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Vuno honi Yesu uatantekeyele vioshe evi, uahandekele kuli vakevo nguendi, “Nkuma vika muli nakushupila ou mpuevo? Omuo na lingi cuma ca cili kuli yange. ");
INSERT INTO nkn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Omuo yeni ntsimbu yoshe muakala na vihutu, vuno honi ntsimbu yoshe yeni kumukakala nange. ");
INSERT INTO nkn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ha kunjitila aua mazi a muvila uange na cilingi kunjivuahesela kunjitsinda. ");
INSERT INTO nkn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Muavusunga njimileka nguange, kuoshe kuje ku vakambulula muzimbu uacili ha mavu uoshe, evi vianalingi ou mpuevo vakavihandeka mukumuvulukilaho.” ");
INSERT INTO nkn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kaha umo ua vaje vandongi likumi na vavali uje ivatumbuile nguavo Yundasa Isakaliote, uaile kuli vakuluntu vatusasendote, ");
INSERT INTO nkn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kuhandeka nguendi, “Vika mukanjihana nga njiminehelaye?” Kaha vamufuetele makumi atatu a vimbongo via siliva. ");
INSERT INTO nkn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kaha kuhuma ha ntsimbu ije uatondesesele ngila ya kuendelamo Yesu vungungu. ");
INSERT INTO nkn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ha litangua lia kulivanga lia mbolo ya kuhona cimbaluila vandongisi vezile kuli Yesu nakuhandeka nguavo, “Kuli utonda yetu nguove tukuvuahesele linga ukalileko paseka?” ");
INSERT INTO nkn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Uahandekele nguendi, “Yeni mu nganda kuli yala umo, kaha mukahandeke kuli ikeye ngueni, ‘Mulongisi nahandeka nguendi, ntsimbu yange inahete, njikalinga ciuano ca paseka mu njivo yove hamo na vandongisi vange.’” ");
INSERT INTO nkn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kaha vaje vandongisi valingile ngue muje Yesu uavalekele, kaha vavuahesele ciuano ca paseka. ");
INSERT INTO nkn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Omo vetele ku cinguezi, Yesu uatumamene kumesa na vandongisi likumi na vavali, ");
INSERT INTO nkn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","kaha omo vakele na kulia, uahandekele nguendi, “Muavusunga, Njihandeka ku liyeni nguange, umo ueni akanjenda vungungu.” ");
INSERT INTO nkn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kaha vakele na vusiua cikuma, kaha vaputukile kuhandeka kuli umo na mukuavo nguavo, “Muene yange ndi?” ");
INSERT INTO nkn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu uavakumbuluile nguendi, “Uje akatanta hamo nange mu lilonga, ikeye vene akanjenda vungungu. ");
INSERT INTO nkn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Omuo Muna Muntu akatsa ngue muje vanacisoneka hali ikeye, vuno honi tuyando hali uje yala enda vungungu Muna Muntu! Ngue capuile cacili kuli uje yala nga kasemukile.” ");
INSERT INTO nkn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yundasa uje uamuendele vungungu uendekele nguendi, “Muene yange ndi?” Yesu uahandekele kuli ikeye nguendi, “Omo vene munahandeka.” ");
INSERT INTO nkn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaha honi omo vakele nakulia, Yesu ua mbatele mbolo, na ku ikuisula, kaha uaipazuile, naku ihana kuli vandongisi vendi, nguendi “Ambateni mulie ou ukeuo muvila uange.” ");
INSERT INTO nkn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kaha uambatele nganja, kaha omo uamanuisuile kusantsela uavahanene, nguendi “Nuenimo mu vavoshe, ");
INSERT INTO nkn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","omuo aua akeuo maninga ange a litavasano lihaliha, aje anamuaniena hali vavengi mukukonekela vupi. ");
INSERT INTO nkn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Njimileka nguange, kunjikanuho naua vushuka vua viniu kuvanga noho ha litangua lije omo njikanua neni vushuka vua viniu vuavuha mu vumuene vua Tate,” ");
INSERT INTO nkn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kaha omo vamanusuile kuimba muaso, vaile ku munkinda ua Oliveta. ");
INSERT INTO nkn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kaha Yesu uahandekele kuli vandongisi vendi nguendi, “Muva voshe mukateua omuo yange vutsiki vuno vene, omuo vacisoneka nguavo, ‘Njikapupa kanuingi, kaha vutanga vua vampanga vukalishandoka!’ ");
INSERT INTO nkn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vuno honi hanima ya kunjisangula, njikaya kulutue lueni ku Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulu uahandekele kuli ikeye nguendi, “Cipue vene voshe vakakuteua, yange kunjikakuteue.” ");
INSERT INTO nkn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu uahandekele kuli Petulu nguendi, “Muavusunga njikuleka nguange, vutsiki vuno vene, ntsimbu kanda ndemba atambeke ukanjiviana lutatu nguove kuunjitantekeya.” ");
INSERT INTO nkn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulu uahandekele kuli ikeye nguendi, “Cipue vene nga kutsa nove, kunjikakuviana.” Kaha na vandongisi vakuavo voshe vahandekele ngoco vene. ");
INSERT INTO nkn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ambahoni Yesu uaile navo kumutambela uvatumbuile nguavo Ngetesemani, kaha uahandekele kuli vandongisi vendi nguendi, “Tumameni hano ntsimbu njiciya nakulombela.” ");
INSERT INTO nkn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kaha uaile na Petulu na vana va Zembendeo vavali, kaha hajevene uaputukile kulivua vusiua na kulinienga. ");
INSERT INTO nkn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kaha uahandekele kuli vakevo nguendi, “Muono uange uli muvusiua noho kukutsa, saleni hano, nakutalelela hamo nange.” ");
INSERT INTO nkn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kaha uaile halahako cindende, uatsikamene hamavu na kulombela nguendi, “Tate, nga casiua, ecela eyi nganja injipulakane, keti kulingiue cizango cange, vuno honi kulingiue cizango cove.” ");
INSERT INTO nkn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kaha uehilukile kuli vandongisi vendi uavauanene vanakosa tulo, kaha uahandekele kuli Petulu nguendi, “Nkuma kuuasa kutalelela nange cipue hola imo lika indi? ");
INSERT INTO nkn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Taleleni nakulombela linga keti mukovele mu vieseko, cilivene cimbembesi citonda, vuno honi ntsitu inazeye.” ");
INSERT INTO nkn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Uaile naua lua mucivali na kulombela nguendi, “Tate, nga kucasiua nganja eyi kunjipulaka kuvanga vene njiinuine, kaha ecela cizango cove cilingiue.” ");
INSERT INTO nkn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kaha naua uahilukile nakuuana vanakosa tulo, omuo mesho avo alemene. ");
INSERT INTO nkn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nankuma, uavasezele naua, uaile nakulombela luamucitatu, uahandekele mezi acifua cimo. ");
INSERT INTO nkn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kaha uezile kuli vandongisi vendi nakuhandeka nguendi, “Nkuma hanga muacikosa na kuhuima? Taleni, hola inahete laja, kaha Muna muntu vanamuende vungungu nakumuhana ku mavoko a vaka vupi. ");
INSERT INTO nkn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hindukeni tuyeni, taleni muka kunjenda vungungu uno hali hano.” ");
INSERT INTO nkn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tele Yesu acili nakuhandeka, Yundasa uezile, uje umo ua vandongisi likumi na vavali, kaha uezile na vivunga viakama vezile na mikuale na vimbueti, kuhuminina kuli vakuluntu va tusasendote na vakuluntu va vantu. ");
INSERT INTO nkn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kaha honi mukakuenda vungungu uavahanene cimueso uahandekele nguendi, “Uje njikatsemba ikeye yala mukakuata.” ");
INSERT INTO nkn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaha hajevene uezile kuli Yesu nakuhandeka nguendi, “Uahinduka vati, mulongisi!” Kaha uamutsembele. ");
INSERT INTO nkn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu uamukumbuluile nguendi “Yove kavusamba, linga vuasi vije viunezila.” Mukemo honi vezile nakumukuata nakumuvumbatela cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kaha taleni, umo ua vaje vakele navo Yesu uahumisile mukuale uendi, nakuluisa ngamba ua kasasendote uakama kaha uamutetele lituitui liendi. ");
INSERT INTO nkn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ambahoni Yesu uahandekele kuli ikeye nguendi, “Haka mukuale uove mu cindalo cauo, omuo voshe vaje vakambata mukuale vakatsa ku mukuale. ");
INSERT INTO nkn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nkuma musinganieka ngueni kunjasa kulomba kuli Tate, kaha hajevene akanjitumina masualale va tungelo likumi na vavali ndi? ");
INSERT INTO nkn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Vuno honi kaha vatihoni visoneka vikalishulisisa, ngeci cikafue muje?” ");
INSERT INTO nkn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ha hola ijevene Yesu uahandekele ku vivunga nguendi, “Nkuma muneja ngue muakuluisa muhuza, na mikuale na vimbueti mukukuata yange ndi? Ha litangua na litangua njatumamene mu njivo ya Njambi nakulongesa kaha kumuanjikutile. ");
INSERT INTO nkn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vuno honi vioshe evi vinalingiua linga visoneka via tunanguizi va Njambi va Njambi vilishulisise.” Ambahoni vandongisi vendi voshe vamusezele nakuteua. ");
INSERT INTO nkn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ambahoni vaje vakutile Yesu vamutualele kuli Kayafase kasasendote uakama, kuje kuvaliku nguluilile valongisi va lishiko na vakuluntu. ");
INSERT INTO nkn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Vuno honi Petulu uakele nakumukava halahako, halahako noho vahetele ku cipango ca kasasendote uakama, kaha omo uakovelele mukati uatumamene na vaka kuniunga linga amone vika vikalingiua. ");
INSERT INTO nkn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaha honi vakuluntu va tusasendote na mpunga yoshe vahanene vukaleho vua makuli hali Yesu linga vamutsihileho, ");
INSERT INTO nkn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","vuno honi kuvauaneneho cipue vumo, cipue vene nguavo kuakele vakaleho vavengi va makuli. Kaha kumamanusuilo vavali vezile kulutue, ");
INSERT INTO nkn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nakuhandeka nguavo, “Ou mukuetu uahandekele nguendi, ‘Njasa kusiula eyi njivo ya Njambi nakuitunga naua mu matangua atatu.’” ");
INSERT INTO nkn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kaha uje kasasendote uakama uemanene nakuhandeka nguendi, “Nkuma kuuesi nacikumbululo ndi? Vikahoni ava vamala alinaku kuvangeya?” ");
INSERT INTO nkn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Vuno honi Yesu uaholokele lika kuluu. Kaha kasasendote uakama uahandekele kuli ikeye nguendi, “Njikusinga mu lizina lia Njambi uakuyoya, tuleke nga yove Kilistu, Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kaha Yesu uahandekele kuli ikeye nguendi, “Omu vene munahandeka mukemo. Vuno honi njimileka nguange, kuhuma ha ntsimbu ino mukamona Muna Muntu natumama ku livoko liacilio lia muka Nzili yoshe, kaha akeja mu mashelua a muilu.” ");
INSERT INTO nkn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ambahoni uje kasasendote uakama uatavuile cikovelo cendi nakuhandeka nguendi, “Nashaula Njambi. Vika naua tutondela vakaleho veka? Munevu honi kushaula cendi. ");
INSERT INTO nkn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nkuma musompa ngueni vati?” Vamukumbuluile nguavo, “Napande kutsa.” ");
INSERT INTO nkn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ambahoni vamujekuilile ku cihanga cendi nakumupupa, kaha vamo vamupupile vimbanda ");
INSERT INTO nkn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nakuhandeka nguavo, “Kilistu, handeka vunanguizi kuli yetu! Iya nakupupu?” ");
INSERT INTO nkn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Honi Petulu uatumamene hambanza lia cipango. Kaha ngamba uampuevo uezile kuli ikeye nakuhandeka nguendi, “Nove vene uakele na Yesu uaku Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Vuno honi uavianene ku mesho avo voshe nguendi, “Kunjitantekeya evi uli nakuhandeka.” ");
INSERT INTO nkn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kaha omo uaile hambanza lia cikolo, ngamba mukuavo uampuevo uamumuene kaha uahandekele ku vantu vaje vemanene kuje nguendi, “Ou yala uakele hamo na Yesu uaku Nazaleta.” ");
INSERT INTO nkn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kaha naua uavianene nacisingo nguendi, “Kunjimutantekeya ou yala.” ");
INSERT INTO nkn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hanima ya kantsimbu kakandende vaje vantu vemanene kuje vezile nakuhandeka kuli Petulu nguavo, “Cilivene nove naua umo uavo, omuo handekesi yove ikeyo ikujombolola.” ");
INSERT INTO nkn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ambahoni Petulu uaputukile kuhandeka visingo hali ikeye vavenia nakulisinga nguendi, “Kunjimutantekeya ou yala.” Kaha hajevene ndemba uatambekele. ");
INSERT INTO nkn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kaha Petulu uanukile vije viahandekele Yesu nguendi, “Kanda ndemba atambeke ukanjiviana lutatu.” Kaha uaile hambanza nakulila cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Omo cimene cahetele vakuluntu vatusasendote voshe na vakuluntu va vantu vatumbile vutumbe vuakuluisa Yesu ngeci vamutsihe. ");
INSERT INTO nkn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kaha vamukutile nakumutuala kuli Pilato uje uapuile nguvulu. ");
INSERT INTO nkn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Omo Yundasa uje uamuendele vungungu uamuene nguendi vanamuhisa, uatengulukile nakuhiluisa vije vimbongo via siliva makumi atatu kuli vakuluntu vatusasendote na vakuluntu, ");
INSERT INTO nkn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","uahandekele nguendi, “Njinalingi vupi hakuenda vungungu maninga akuhona mulonga.” Kaha vamukumbuluile nguavo, “Vikahoni ovio kuli yetu? Ouo mulonga uove.” ");
INSERT INTO nkn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kaha Yundasa uombilile vije vimbongo via siliva mu njivo ya Njambi, kaha uaile nakukalishukika. ");
INSERT INTO nkn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vuno honi vakuluntu vatusasendote omo vambatele vije vimbongo via siliva, vahandekele nguavo, “Kuya ku lishiko kucapandele kuvihaka mu mbango, omuo vinapu vimbongo via maninga.” ");
INSERT INTO nkn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nankuma valitavasanene linga vavilande lihia lia uje muka kushonga vindeho, ngeci lipue lia kutsindila vangezi. ");
INSERT INTO nkn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nankuma, nakuheta nalelo lino lije lihia valisana nguavo lihia lia maninga. ");
INSERT INTO nkn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ambahoni vialishulisilile vije viahandekele kananguizi ua Njambi Yelemaya nguendi, “Kaha vambatele vimbongo via siliva makumi atatu, a ndando yendi ije ndando ivayonguele vamo vana va Isaleli, ");
INSERT INTO nkn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kaha vavipangesele kulanda lihia lia muka-kushonga vindeho, ngue muje Muene muavashikilililemo.” ");
INSERT INTO nkn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kaha Yesu uemanene ku mesho a nguvulu ua Valoma, kaha nguvulu uamuhuile nguendi, “Yove Muene ua Vayunda ndi?” Yesu uamukumbuluile nguendi, “Omu munahandeka mukemo vene.” ");
INSERT INTO nkn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Vuno honi omo vamuvangeyele kuli vakuluntu va tusasendote na vakuluntu, kavakumbuluile. ");
INSERT INTO nkn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ambahoni Pilato uahandekele kuli ikeye nguendi, “Nkuma kuuesi nakuvua viuma evi vivali nakuhana vukaleho hali yove indi?” ");
INSERT INTO nkn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Vuno honi kamukumbuluile cipue kamandende, Kaha honi nguvulu ualikomokelele cikuma. ");
INSERT INTO nkn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Honi ku ciuano uje nguvulu kuya ku lishiko liavo, uapandele kuhumisila civunga umo ua vinzinda uje ivatondele. ");
INSERT INTO nkn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kaha ha ntsimbu ije kuakele cinzinda uje uakuhona kuivua, ivatumbuile nguavo Mbalambasa. ");
INSERT INTO nkn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Omo valikunguilile hamo Pilato uahandekele kuli vakevo nguendi, “Iya mutonda linga njimihumisile Mbalambasa indi Yesu uje ivatumbula nguavo Kilistu indi?” ");
INSERT INTO nkn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Omuo Pilato uatantekeyele nguendi omo ya cipululu cavo mukemo vamuneheleleye Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oku tele Pilato natumama ha citumamo cakusompela, mpuevo yendi uatumine lizi kuli ikeye nguendi, “Keti ulinge cimo kuli ou yala ua vusunga, omuo njinayanda cikuma kumulota.” ");
INSERT INTO nkn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kaha vakuluntu vatusasendote na vakuluntu visindiyile vantu linga valombe Mbalambasa kaha Yesu vamutsihe. ");
INSERT INTO nkn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaha nguvulu uavehuile naua nguendi, “Kuli ava vantu vavali iya mutonda linga njimihumisile?” Vahandekele nguavo, “Mbalambasa.” ");
INSERT INTO nkn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato uahandekele kuli vakevo nguendi, “Amba vika honi njikalinga nou Yesu ivatumbula Kilistu?” Kaha voshe vahandekele nguavo, “Mushukike.” ");
INSERT INTO nkn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kaha uahandekele nguendi, “Vupi muka vuanalingi?” Vuno honi voshe vatambekele cikuma nguavo, “Vamushukike.” ");
INSERT INTO nkn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kaha honi omo Pilato uamuene nguendi nacimo cauanaho cahi, vuno honi mpindangano ili nakuputuka, uambatele mema na kutana ku mavoko endi ha mesho acivunga, nakuhandeka nguendi, “Yange kunjesi namulonga ha maninga ou yala, limueneni yeni vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kaha vantu voshe vamukumbuluile nguavo, “Maninga endi akale hali yetu na vana vetu!” ");
INSERT INTO nkn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kaha uavahanene Mbalambasa, kaha hakumanusula kupupa Yesu, uavahaneneye linga vamushukike. ");
INSERT INTO nkn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ambahoni masualale vanguvulu vambatele Yesu nakumutuala mulipela, kaha vakunguluile civunga coshe ca masualale kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vamushuluile, nakumuzika kazaku kakuvenga. ");
INSERT INTO nkn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kaha vavindile cilongo ca mambimbo vacakele kumutue uendi, kaha vamuakele lihongo mu livoko liendi lia cilio. Vatsikamene ku mesho endi na kumushendumuna nguavo, “Uahinduka, Muene ua Vayunda!” ");
INSERT INTO nkn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kaha vamujekuilile mate, kaha vambatele lihongo vamupupile ku mutue. ");
INSERT INTO nkn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Munima ya kumushendumuna, vamushuluile kazaku, nakumuzika vuzalo vuendi nakumutuala mukumushukika. ");
INSERT INTO nkn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Omuo vakele nakuya, valiuanene na yala uaku Silene, lizina liendi Simoni, ou yala vamusindiiye kuambata cilindakano ca Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kaha omo vahetele ha cihela civasana nguavo Ngolongota (Cije cilumbununa nguaco cihela ca cikola), ");
INSERT INTO nkn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","vamuhanene viniu linga anue, va vikumbasanene na niangua, vuno honi omo uamakeleleko, kavinuine. ");
INSERT INTO nkn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kaha omo vamanusuile ku mushukika, valipangezelele vuzalo vuendi hhakati kavo mukuta nkela, ");
INSERT INTO nkn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ambahoni vatumamene hamavu oku vali nakumutalela. ");
INSERT INTO nkn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kaha helu lia mutue uendi vahakeleho cimueso cavije vamuhisile navio nguavio, “Ou ikeye Yesu, Muene ua Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Honi vamushukikile na mihuza vavali, umo kucilio umo kucimoshue. ");
INSERT INTO nkn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kaha vaje vakele nakuhita vamushauile, nakuningangesa mitue yavo. ");
INSERT INTO nkn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kaha vahandekele nguavo, “Yove uatondele kusiula njivo ya Njambi nakuitunga mu matangua atatu, liovole yove vavenia! Nga u Muna Njambi, huma ha cilindakano.” ");
INSERT INTO nkn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nankuma vakuluntu vatusasendote na va valongisi va lishiko na vakuluntu vamushendumuine nguavo, ");
INSERT INTO nkn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Uovuela vakuavo, vuno honi kasa kuliovola ikeye vavenia. Ikeye Muene ua Isaleli, ashuluke kuhuma hacilindakano, kaha tumutsiliela. ");
INSERT INTO nkn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uatsiliela muli Njambi, eceni Njambi amuohiele hano vene, nga amuzanga, omuo uahandekele nguendi, ‘Yange Muna Njambi!’ ” ");
INSERT INTO nkn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kaha na mihuza vaje vavamushukikile hamo nendi vamutukile navo naua. ");
INSERT INTO nkn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Honi kuhuma mutania kutuala ha hola ya mucitatu ya mutania uacinguezi kuakele milima ha mavu hoshe. ");
INSERT INTO nkn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kaha ha hola ya mucitatu ya mutania uacinguezi Yesu ualilile mukutambakana nguendi, “Eloi, Eloi, lema sambakatani?” Kulumbununa nguavo, “Njambi yange, Njambi yange, vika uanjisezela?” ");
INSERT INTO nkn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaha vamo vantu vaje vemanene kuje omo vovuile eci, vahandekele nguavo, “Ou yala alinakusana Eliya.” ");
INSERT INTO nkn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kaha umo uavo hajevene uashatukile nakukambata mupelo, kaha ua umbuitikile mu viniu via kushasha naku ukutilila ku lihongo kaha uamuhanene linga anue. ");
INSERT INTO nkn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vuno honi vamo vahandekele nguavo, “Vandameneni, tuyeni tumone indi Eliya eja nakumuovola.” ");
INSERT INTO nkn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kaha Yesu ualilile nakutambakana naua, kaha uecelele cimbembesi cendi. ");
INSERT INTO nkn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kaha taleni, ntanga ya mu njivo ya Njambi yatavukile hhakati, kuhuma kuilu nakuheta ha mavu. Kaha mavu aningangele, kaha na mavue atavukile, ");
INSERT INTO nkn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","na vihilo naua navio viashokolokele, kaha mivila yaingi ya vaje vaka kulela vaje vatsile vaisanguile. ");
INSERT INTO nkn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kaha omo vahumine mu vihilo hanima yakusanguka ca Yesu, vaile mu nganda ya kulela nakukalisholola ku vantu vavengi. ");
INSERT INTO nkn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Omo uje mukuluntu ua masualale na vaje vakele navo vaje vakele nakuniunga Yesu, vamuene mandunduma na vije vialingiuile, kaha vovuile liova cikuma nakuhandeka nguavo, “Muavusunga vene ou uapuile Muna Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kuje vene kuakele naua na vampuevo vavengi, vaje vakele nakutalela alahako, vaje vakavele Yesu kuhuma ku Ngalileya oku tele vali nakumupangela. ");
INSERT INTO nkn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Vamo vavo vapuile Maliya Mangandalena, na Maliya vaina ya Tiango na Yosefa, na vaina ya vana va Zembendeo. ");
INSERT INTO nkn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Omo cinguezi cahetele, kuezile yala umo ua kufuka uaku Alamatiya, lizina liendi Yosefa, uje na ikeye naua uapuile ndongisi ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Uahile kuli Pilato nakulomba muvila ua Yesu. Ambahoni Pilato uashikile nguendi linga vamuhaneuo. ");
INSERT INTO nkn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaha Yosefa uambatele muvila ua Yesu naku uzengela ha ntanga ya iha ya liniu, ");
INSERT INTO nkn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kaha ua ulangekele mu cihilo caciha cendi vavenia, cije cacokuele mu livue, kaha uakokelele livue liakama ku cikolo ca cihilo, kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Mangandalena na Maliya mukuavo vatumamene kuje oku vanatalesa ha cihilo. ");
INSERT INTO nkn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Liamukuavo, hanima ya litangua liakulivuahesela lije likelio litangua lia Sapalalo, vakuluntu va tusasendote na Vafaliseo valikunguluilile kuli Pilato, ");
INSERT INTO nkn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kaha vahandekele nguavo, “Muene, tuanuka muje uje muka kukuisa uahandekele tele aciyoya nguendi, ‘Hanima ya matangua atatu njikasanguka naua.’ ");
INSERT INTO nkn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nankuma shika vaje tuniungi linga vaniunge muacili cihilo noho ha litangua lia mucitatu. Keti ngoconi hamo vandongisi vendi vakeja nakuiva muvila uendi, kaha vakaleka vantu nguove, ‘Nasanguka kuvatsi,’ kaha aua makuli akukotokela akapua amapi cikuma kupulakana aje akulivanga.” ");
INSERT INTO nkn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato uahandekele kuli vakevo nguendi, “Muli na mukakuniunga ua masualale, yeni mukaniunge muacili cihilo kuya muje mumuaselamo.” ");
INSERT INTO nkn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nankuma vaile nakuniunga cije cihilo, kaha vaciniungile mukuhaka kasateso ku livue nakuhakako muka kuniunga. ");
INSERT INTO nkn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Honi hanima ya sapalalo, ha ntsimbu yakuca ca litangua liakulivanga musondo, Maliya Mangandalena na Maliya mukuavo vaile mukumona ku cihilo. ");
INSERT INTO nkn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kaha taleni, kuakele mandunduma akama, omuo kangelo ua Muene uashulukile kuhuma muilu, kuija nakuhumisa livue lije liakele ku cihilo kaha uatumameneho. ");
INSERT INTO nkn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Cifua cendi cafuile ngue muhiato, kaha vuzalo vuendi vuatokele too ngue mpemba. ");
INSERT INTO nkn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Omuo ya liova lia kangelo, vaje vaka kuniunga ku cihilo vajajele cikuma kaha valezumukile. ");
INSERT INTO nkn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vuno honi uje kangelo uahandekele kuli vaje vampuevo nguendi, “Keti muvue liova, omuo njatantekeya nguange mulinakutonda Yesu, uje ivashukikile. ");
INSERT INTO nkn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Uahimo muno, nasanguka, ngue muje muahandekele. Ijeni, taleni mu cihela muje muakosele. ");
INSERT INTO nkn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ambahoni yeni vuasi vuasi, mukaleke vandongisi vendi ngueni, ‘Nasanguka ku vatsi, kaha taleni, nalivanga laja kuya ku Ngalileya, kuje kukeko kumukamumuena.’ Taleni njamileke.” ");
INSERT INTO nkn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kaha vaje vampuevo vahumine ku cihilo vuasi vuasi na liova na kujolelela cikuma, vashatukile na kukaleka vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kaha taleni, hajevene Yesu ualiuanene navo nakuhandeka nguendi, “Tambokeni.” Kaha vezile kuli ikeye nakumukuata ku viliato viendi nakumulemesa. ");
INSERT INTO nkn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ambahoni Yesu uahandekele kuli vakevo nguendi, “Keti muvue liova, yeni mukalekese vamuanetu vaye ku Ngalileya, kaha kuje kukeko vakanjimuena.” ");
INSERT INTO nkn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tele vali nakuya, taleni, vamo va masualale vaile mu nganda nakuleka vakuluntu va tusasendote vioshe vije vialingiuile. ");
INSERT INTO nkn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kaha omo valiuanene hamolika na vakuluntu nakutumba vutumbe vuavo, vahanene vimbongo masualale ");
INSERT INTO nkn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nakuhandeka nguavo, “Lekeni vantu ngueni, ‘Vandongisi vendi vanezile vutsiki nakuiva muvila uendi tele tuli mutulo.’ ");
INSERT INTO nkn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngahoni eci ciheta mu matuitui a nguvulu, tukamuzika zika, linga keti mukale muvukalu.” ");
INSERT INTO nkn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ambahoni vambatele vije vimbongo kaha valingile ngue muje vavalekesele, kaha lutsimo lua muzimbu ou luashandokelele hhakati ka Vayunda kuheta na lelo lino. ");
INSERT INTO nkn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Honi vandongisi likumi na umo vaile ku Ngalileya, ku munkinda kuje Yesu uavalekele. ");
INSERT INTO nkn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kaha omo vamumuene vamulemesele, vuno honi vamo valikanouelele. ");
INSERT INTO nkn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kaha Yesu uezile nakuhandeka kuli vakevo nguendi, “Nzili yoshe yakama ya muilu na ya ha mavu vanaihana kuli yange. ");
INSERT INTO nkn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nankuma yeni mukapuise mafuti oshe vandongisi, mukavambuitike mu lizina lia Tate, na lia Muana, na lia Cimbembesi Uakulela, ");
INSERT INTO nkn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","valongeseni kuononoka viuma vioshe vije vinjinamishiki, kaha taleni, njikakala neni kutuala ku mamanusuilo a mavu.”");
INSERT INTO nkn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kuputuka kua muzimbu uacili ua Yesu Kilistu, Muna Njambi. ");
INSERT INTO nkn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngue omuo vacisoneka kuli kananguizi ua Njambi Isaya nguavo, “Taleni, ‘Njikatuma kanganda kange kulutue luove, uje akavuahesa ngila yove.’ ");
INSERT INTO nkn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Lizi liaumo hali nakutambeka mu mpambo, vuaheseni ngila ya Muene, sungameseni ngila yendi.’ ” ");
INSERT INTO nkn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kaha Iuano muka kumbuitika uasholokele mu mpambo, uambuluile kumbuitika ca kutenguluka ca kusambua ku vupi. ");
INSERT INTO nkn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kaha vantu voshe vaile kuli ikeye, vaje vahumine mu lifuti lia Yundeya, na vantu voshe va mu Yelusalema, valitavelele vipi vuavo kaha vavambuitikile kuli ikeye mu Ndonga ya Yundau. ");
INSERT INTO nkn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kaha Iuano uazalele vuzalo vua maka a kamelu, na muiva ua cilambu mu mbunda yendi, naua uakele nakulia vambimba na vuci. ");
INSERT INTO nkn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kaha uambuluile nguendi, “Munima yange muli nakuija uje hali na nzili kupulakana yange, cipue miva ya vinkaku viendi kunjasa kukotama na kuizitula. ");
INSERT INTO nkn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Njamimbuitika na mema, vuno honi ikeye akamimbuitika na Cimbembsi Uakulela.” ");
INSERT INTO nkn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ha matangua aje, Yesu uahumine ku Nazaleta mu Ngalileya, kaha vamumbuitikile kuli Iuano mu Yundau. ");
INSERT INTO nkn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kaha omuo Yesu uahumine mu mema, hajevene uamuene melu ashokoloka, kaha Cimbembesi uashulukilile hali ikeye mucifua ca livembe. ");
INSERT INTO nkn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kaha lizi liahumine muilu ngualio, “U Munange injazanga, muli yove njivuahelela.” ");
INSERT INTO nkn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hajevene Cimbembesi ua mutualele mu mpambo. ");
INSERT INTO nkn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kaha uakele mu mpambo matangua makumi auana, mukumueseka kuli Satana. Uakele nakuyoya na vikashama kaha tungelo vamusimpisile. ");
INSERT INTO nkn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hanima yakukuta Iuano muka kumbuitika, Yesu uaile ku Ngalileya, mukuambulula muzimbu uacili ua Njambi, ");
INSERT INTO nkn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kaha uahandekele nguendi, “Ntsimbu inalishulisisa, vumuene vua Njambi vuli muyehi, tengulukeni, kaha tsilieleni mu muzimbu uacili.” ");
INSERT INTO nkn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kaha omo uakele nakuhita kumukulo ua cisali ca Ngalileya, uamuene Simoni na muanaye Anduleo valinakuta manda vuavo mu cisali, omuo vapuile vakakuta vantsi. ");
INSERT INTO nkn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kaha Yesu uahandekele kuli vakevo nguendi, “Njikaveni njimipuise vakakuta vantu.” ");
INSERT INTO nkn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kaha hajevene vasezele manda avo kaha vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kaha omo uatualeleleho kuenda, uamuene Tiango muna Zembendeo na Iuano muanaye, vaje vakele mu vuato vuavo nakutungulula manda avo. ");
INSERT INTO nkn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hajevene uavasanene kaha vasezele ishavo Zembendeo mu vuato hamo na vangamba vaje va vakumuine, kaha vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na vandongisi vauana vaile ku Kapenauma, kaha omo liapuile lia sapalalo uakovelele mu njivo ya malombelo na kulongesa. ");
INSERT INTO nkn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kaha vakomokele hakulongesa kuendi, omuo uavalongesele ngue uje hali na nzili yakama, keti ngue muvakalongesela valongisi va mashiko. ");
INSERT INTO nkn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hajevene mu njivo ya malombelo muakele yala uje uakele na cimbembesi cacipi, ");
INSERT INTO nkn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","kaha uatambekele nguendi, “Utonda vika kuli yetu, Yesu ua ku Nazaleta? Uneja nakutunongesa ndi? Njakutantekeya yove uje Umo Uakulela ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kaha Yesu uamutenukilile nguendi, “Holoka kuluu, huma muli ikeye!” ");
INSERT INTO nkn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kaha cimbembesi cacipi ca mupindisile, nakulila na lizi liakutambeka, kaha cahumine muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaha vantu voshe valikomokelele, nakulihozola umo na mukuavo nguavo, “Nkuma cika eci? Cilongesa caciha! Na nzili yakama asa kushika cipue cimbembesi cacipi, kaha cimuononoka.” ");
INSERT INTO nkn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kaha hajevene lutsimo luendi lua tsimanene kumitambela yoshe ya ku zenguluka Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hajevene Yesu uahumine mu njivo ya malombelo, kaha uakakovelele mu njivo ya Simoni na Anduleo, hamo na Tiango na Iuano. ");
INSERT INTO nkn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Honi vaina mueno ya Simoni vakosele omuo vakele nakuvavala lisikasika, kaha hajevene valekesele Yesu kuvavala cendi. ");
INSERT INTO nkn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kaha uezile nakumukuata ku livoko, uamuhinduile, kaha masikasika amuecelele, uaputukile kuvapangela. ");
INSERT INTO nkn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kaha ku cinguezi, omo litangua lia lahukile Yesu vamunehelele voshe vaka kuvavala na vaje vakele na mahamba. ");
INSERT INTO nkn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaha vantu voshe va mu nganda valikunguluile hamo ku cikolo. ");
INSERT INTO nkn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu uakanguisile vavengi vaka kuvavala mishongo yakuliseza seza, nakuhumisa mahamba amengi, kaha katavesele mahamba kuhandeka, omuo vamutantekeyele. ");
INSERT INTO nkn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaha ku cimene mene Yesu uahindukile, nakuya ku cihela calikaliendi lika nakulombela. ");
INSERT INTO nkn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kaha Simoni na vaje vakele nendi, vamukavele nakumutonda, ");
INSERT INTO nkn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vamuuanene kaha vahandekele kuli ikeye nguavo, “Muntu uoshe alinakukutonda.” ");
INSERT INTO nkn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kaha Yesu uahandekele kuli vakevo nguendi, “Tuyeni ku vimbonge via kulihata, linga njikambulule muzimbu nakuje naua, omuo eci cikeco njezilile.” ");
INSERT INTO nkn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kaha uaile muoshe mu Ngalileya, nakuambulula muzimbu uacili mu vinjivo via malombelo avo nakuhumisa mahamba. ");
INSERT INTO nkn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kaha uje yala uakele na mbumba uezile kuli ikeye nakumulambelela, uatsikamene nakuhandeka kuli ikeye nguendi, “Nga utonda, njipuise uakulela.” ");
INSERT INTO nkn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu hakuivua ngozi, uoluele livoko liendi na kumukuata, nakuhandeka kuli ikeye nguendi, “Njitonda, lela.” ");
INSERT INTO nkn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kaha hajevene mbumba yamuhumine, kaha uapuile uakulela. ");
INSERT INTO nkn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Uamunanguile cikuma, nakumuleka aye vuasi vuasi, ");
INSERT INTO nkn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","nakumuleka nguendi, “Keti uhandeke cuma cimo kuli uoshe, vuno honi ya, linga ukalimuese yove vavenia kuli tusasendote, kaha ukahane nkombelo ije Mosesa uashikile ha kulela cove linga vupue vukaleho kuli vantu.” ");
INSERT INTO nkn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Vuno honi uaile nakuhandeka oku nazituka, kaha muzimbu uashanduokelele kuoshe, linga Yesu keti akovela mu mbonge citona muelu, vuno honi uaile ku mitambela yeka ya lifuti, kaha vantu vakele nakuija kuli ikeye mu vintsimbu. ");
INSERT INTO nkn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hanima ya matangua amandende, Yesu uahilukile naua mu Kapenauma, kaha vantu vovuile nguavo Yesu nahiluka kuimbo. ");
INSERT INTO nkn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vantu vakungulukile muvuingi, kaha kukuakele cipue mulili umo uasaleleko uahi, cipue hambanza ya cikolo, kaha uambuluile lizi kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vamo vamala vauana vambatele yala ua kalepa kaha vamunehele kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kaha omuo vahonouele kushuena kuli Yesu omuo ya civunga, kaha vatuvile mbengua ha ciluli mukemo vasoselele cije citala tala cije uje yala uakalepa ha kosele na kucineha ha mavu. ");
INSERT INTO nkn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kaha omuo Yesu uamuene lutsilielo luavo, uahandekele kuli uje muka kalepa nguendi, “Munange vipi viove vanavisambuesa.” ");
INSERT INTO nkn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nankuma vamo valongisi va lishiko vaje vatumamene kuje, vakele na kulihuozola mu mitima yavo nguavo, ");
INSERT INTO nkn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Vika ou yala ahandekela ngacije? Alinakushaula! Iya asa kusambuesa vipi, vuno honi Njambi lika?” ");
INSERT INTO nkn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hajevene Yesu mu cimbembesi uatantekeyele vivakele na kusinganieka mu mitima yavo, kaha uavehuile nguendi “Vikahoni muli na kulihozola mu mitima yeni? ");
INSERT INTO nkn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cili cinapu cacasi, kuhandeka kuli muka kalepa nguove, ‘Vipi viove vanavisambesa,’ cipue kuhandeka nguove ‘Katuka, ambata citala tala cove uye’? ");
INSERT INTO nkn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vuno honi njitonda nguange mutantekeye ngueni Muna Muntu hali na nzili yakama ya kusambesa vupi hano ha mavu.” Uahandekele kuli uje yala ua kalepa nguendi, ");
INSERT INTO nkn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Njikuleka nguange, katuka, ambata citala tala cove uye kuimbo.” ");
INSERT INTO nkn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kaha uakatukile, hajevene uambatele citala tala cendi nakuya oku vantu voshe vamumono, kaha vakomokele nakulemesa Njambi nguavo, “Kanda tumoneho cuma cakufua ngacije!” ");
INSERT INTO nkn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu uaile naua ku ngenge ya cisali, kaha civunga cakama cakungulukile kuli ikeye, kaha uaputukile kuvalongesa. ");
INSERT INTO nkn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kaha omuo uahitile, uamuene Levi muna Alufeya, natumama ku njivo yakutambuila lisimu, kaha Yesu uahandekele kuli ikeye nguendi, “Njikave.” Kaha Levi uakatukile nakumukava. ");
INSERT INTO nkn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kaha omuo uatumamene ku mesa mu njivo yendi, vuingi vuavakakutambula lisimu na vaka vupi vatumamene na Yesu na vandongisi vendi, omuo vavengi vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kaha valongisi va lishiko vaje vapuile Vafaliseo omo vamuene Yesu hali nakulia na vaka vupi na vakakutambula lisimu, vehuile vandongisi vendi nguavo, “Vika vialila na vakakutambula lisimu na vaka vupi?” ");
INSERT INTO nkn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kaha omo Yesu vovuile eci, uahandekele kuli vakevo nguendi, “Vaje kuvavavala kuvasa kutonda cimbanda, vuno honi kuvanga lika vaje vavavala, kunjezile nakusana vaje vaka vusunga, vuno honi vaka vupi.” ");
INSERT INTO nkn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Omo vandongisi va Iuano na Vafaliseo valiuminine kulia, kaha vantu vamo vezile kuli Yesu nakumuihula nguavo, “Vatihoni vandongisi va Iuano na vandongisi va Vafaliseo valuimina kulia, vuno honi vandongisi vove kuva luimina kulia?” ");
INSERT INTO nkn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma nga mungenzi neja ku ciuano ca vulo asa kuluimina kulia oku vavenia vulo hali navo ndi? Kuahi kuvasa kuluimina kulia nga vali na vavenia vulo. ");
INSERT INTO nkn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Vuno honi matangua akeja, omo vavenia vulo vakamuhumisa kuli vakevo, ambahoni valuimine kulia. ");
INSERT INTO nkn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Naumo uahi asa kutongela citopeko ca ntanga yaiha ha kazaku kalaja, nga alinga ngoco, kaha citopeko cikatavula kazaku kalaja nakuseza mbengua. ");
INSERT INTO nkn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaha naumo uahi ahaka viniu via viha mu vinjeke via vilambu via laja, nga alinga ngoco, kaha viniu vitavula vilambu, kaha na viniu vikahita, na vilambu naua navikevio vikapihia, vuno honi viniu viaviha viapande kukala mu vilambu viaviha.” ");
INSERT INTO nkn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ha litangua limo lia sapalalo Yesu uahitile mu mehia a tiliku, kaha omo vakele nakuhita vandongisi vendi vaputukile kutomona mitue ya vinona. ");
INSERT INTO nkn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kaha Vafaliseo vahandekele kuli ikeye nguavo, “Tala, vika valingila evi vivanavindika mu lishiko ha litangua lia sapalalo?” ");
INSERT INTO nkn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kaha uahandekele kuli vakevo nguendi, “Kanda mutandeho vialingile Ndaviti, omo uatsile njala kaha uatondele kulia, ikeye navaje vakele navo, ");
INSERT INTO nkn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","uakovelele mu njivo ya Nambi, omo Aviyatale uapuile kasasendote uakama ha ntsimbu ije, kaha ualile mbolo ya cikombelo ca Njambi cije kucapuile lishiko kuli muntu uoshe kuvanga lika kuli tusasendote ku vilia, kaha naua uahaneneko nakuli vaje vakele navo.” ");
INSERT INTO nkn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kaha uahandekele kuli vakevo nguendi, “Sapalalo vaipangelele omuo muntu, keti muntu ivatangelele sapalalo, ");
INSERT INTO nkn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","kaha Muna Muntu ikeye vene Muene ya sapalalo.” ");
INSERT INTO nkn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naua Yesu uakovelele mu njivo ya malombelo, muje muakele uje yala uakusekua livoko. ");
INSERT INTO nkn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kaha vamutalelele linga vamone indi amukanguisa ha litangua lia sapalalo, linga vamuuaneneho mulonga. ");
INSERT INTO nkn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kaha uahandekele kuli uje yala uakusekua livoko nguendi, “Ija kuno.” ");
INSERT INTO nkn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kaha uahandekele kuli vakevo nguendi, “Kuya ku lishiko lia Sapalalo, nkuma cinapu cacili kulinga muacili indi kuvulumuna, kuyoyesa muono indi kutsiha?” Vuno honi vaholokele kuluu. ");
INSERT INTO nkn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Uavatalele oku te naniengua, nakulivua vusiua ha kukolesa mitima yavo, kaha uahandekele kuli uje yala uakusekua livoko nguendi, “Olola livoko liove.” Ualioluele, kaha livoko liendi liakangukile. ");
INSERT INTO nkn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Vafaliseo vatuhukilemo, kaha hajevene vakele na mpunga ya Helonde linga vauane ngila ya kumutsihilamo. ");
INSERT INTO nkn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na vandongisi vendi vahumine ku cisali, kaha civunga cakama caku Ngalileya neci ca ku Yundeya camukavele, ");
INSERT INTO nkn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","naku Yelusalema naku Indumeya vamo musinia ya Yundau, vamo vahumine ku Tile na Sindone, civunga cakama omuo covuile vije vialingile vezile kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaha Yesu ualekele vandongisi vendi linga vamuvuahesele vuato omuo ya civunga kuteua vamutseka, ");
INSERT INTO nkn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","omuo ha kukanguisa vavengi, ngeci navaje voshe vakele na mishongo vamusindakanene linga vamukuate. ");
INSERT INTO nkn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kaha hali hoshe omo vaje vakele na vimbembesi via vipi vamumuene, vauililile ha mavu ku mesho endi nakutambeka nguavo, “Yove Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kaha uavashika linga keti vamutantekeyese. ");
INSERT INTO nkn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kaha Yesu uaile helu lia munkinda, uasanene vaje vatondele, kaha vezile kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kaha uahanguile likumi na vavali, linga vakale nendi, ngeci avatume kuya nakuambulula lizi, ");
INSERT INTO nkn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na kupua na nzili yakama yakuhumisa mahamba. ");
INSERT INTO nkn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ava vakevo likumi na vavali vaje vahanguile, Simoni uje ya lukile Petulu, ");
INSERT INTO nkn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiango muna Zembendeo, na Iuano munaina ya Tiango, vaje valukile Mboanengesi, nkumbu yalio ngualio, “Vana va cililimo.” ");
INSERT INTO nkn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduleo, na Filipu, na Mbatolomeo, na Mateu, na Tomasi, na Tiango muna Alufeya, na Tandeo, na Simoni uaku Kanana, ");
INSERT INTO nkn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yundasa Sakaliote, uje uendele Yesu vungungu. ");
INSERT INTO nkn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu na vandongisi vendi vakovelele mu njivo, kaha civunga caliuanene hamo naua, kaha vahonouele kulia. ");
INSERT INTO nkn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kaha omo ntanga yendi yovuile ha cuma eci, vaile na kumuambata omuo vamuene nguavo, “Nazaluka.” ");
INSERT INTO nkn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kaha valongisi va lishiko vaje vasikumukile kuhuma ku Yelusalema vahandekele nguavo, “Vali nakumupangesa kuli Mbelezembulu, muene ua mahamba ikeye namuhana nzili yakuhumisa mahamba.” ");
INSERT INTO nkn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaha Yesu uavasanene linga veje kuli ikeye, kaha uahandekele kuli vakevo mu visimo nguendi, “Nkuma vati Satana asa kuhumisa Satana? ");
INSERT INTO nkn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nga vumuene vulipanga hhakati kavuo vavenia, kaha vumuene vuje vukanonga. ");
INSERT INTO nkn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaha nga njivo ilipanga hhakati ikeyo vavenia, ije njivo kuikemana. ");
INSERT INTO nkn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kaha nga Satana aliluisa ikeye vavenia kaha alipanga, kahasa kuimana, vuno honi alinakuya ku mamanusuilo. ");
INSERT INTO nkn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kaha naumo uahi akovela mu njivo ya yala ua nzili nakupukula vitenga viendi, cakulivanga kuvanga akute uje yala ua nzili, ambahoni apukule njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Cilivene, njihandeka kuli yove nguange, vupi vuoshe vua vantu vakavukonekela, nakushaula kuje kuvakahandeka, ");
INSERT INTO nkn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","vuno honi uoshe uje ashaula Cimbembesi Uakulela ku vakamukonekela, omuo nalingi vupi vuakuhona kuhua.” ");
INSERT INTO nkn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","omuo vahandekele nguavo, “Alina na Cimbembesi cacipi.” ");
INSERT INTO nkn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kaha vaina na vamuanaye vezile nakuimana hambanza nakumutumina muntu linga vakamusane. ");
INSERT INTO nkn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kaha civunga cije camuzengelekele te vatumama, vahandekele kuli ikeye nguavo, “Vanoko na vamuanoko vali hambanza, mu kukutonda.” ");
INSERT INTO nkn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kaha uavakumbuluile nguendi, “Veya vanana nava muanetu?” ");
INSERT INTO nkn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kaha omuo uatalele vaje vamuzengelekele, uahandekele nguendi, “Ava vakevo vanana na vamuanetu! ");
INSERT INTO nkn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uoshe uje alinga cizango ca Njambi, ikeye muanetu, na ndumbuange, na vanana.” ");
INSERT INTO nkn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kaha naua Yesu uaputukile kulongesa ku cikuma ca cisali. Kaha na civunga ca vantu calikunguluile kuli ikeye, kaha uakovelele nakutumama mu vuato ha cisali, kaha civunga coshe cakele ku cikuma ca cisali ha ntunda. ");
INSERT INTO nkn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kaha uavalongesele viavingi mu visimo, kaha mu vilongesa viendi uahandekele kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ivuilileni! Muka kukuva uaile nakukuva. ");
INSERT INTO nkn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kaha omo uakunine, imo mbuto yauilile kumukulo ua ngila, kaha tuzila vezile nakuilia. ");
INSERT INTO nkn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imo mbuto yauililile ha mavue aje kuuakele na mavu amengi, kaha hajevene yasokele omuo kuhakele mavu amengi, ");
INSERT INTO nkn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kaha omuo litangua lia tuhukile vije vimbuto via jujuamene, omuo mizi kuyakovelele cikuma mu mavu kaha yomine. ");
INSERT INTO nkn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ikuavo mbuto yauilile mu mingonga kaha mingonga yakolele nakuituva, kaha kuya hakele vinona. ");
INSERT INTO nkn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kaha vikuavo vimbuto viauililile mu mavu acili, kaha viahakele vinona viavingi, kaha viakolele nakulivuezelela kuima, vimo viemine makumi atatu, vikuavo viemine makumi atanu na limo, kaha vikuavo viemine cihita.” ");
INSERT INTO nkn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kaha Yesu uahandekele kuli vakevo nguendi, “Uoshe hali na matuitui ovue.” ");
INSERT INTO nkn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Omo uakele lika liendi, kaha vaje vakele kuyehi nendi hamo na vandongisi vendi likumi na vavali vamuhuile via ha visimo. ");
INSERT INTO nkn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kaha uahandekele kuli vakevo nguendi, “Kuli yeni vaje vavanahana vushueke vua vumuene vua Njambi, vuno honi kuli vaje vali hambanza vioshe vili mu visimo, ");
INSERT INTO nkn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nankuma linga, “Vamone vuno honi keti vamonesese, kaha linga vovue, vuno honi keti vovuisise. Omo nga valingamo vakatenguluke na kuvasambesa.” ");
INSERT INTO nkn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma kumuesi nakuvuisisa eci cisimo ndi? Kaha nkuma vatihoni mukevivuisisa visimo vioshe? ");
INSERT INTO nkn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muka kukuva akakuvu lizi. ");
INSERT INTO nkn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ava vakevo vantu vanalifu ngue vimbuto vije viauilile kumukulo ua ngila, kuje lizi valikuva, kaha omo valivua, kaha hajevene Satana eja nakuambata lije lizi livanakuvu muli vakevo. ");
INSERT INTO nkn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kaha vamo vantu vanapu ngue vimbuto vije vivakuvile ha mavue, omo vevua lizi, kaha hajevene valitambula nanzolela, ");
INSERT INTO nkn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kaha kuvesi na mizi muli vakevo, vuno honi kuvakasimbula nalio, kaha omo tuyando cipue mapakeso vikeja omuo ya lizi, kaha hajevene vakaua. ");
INSERT INTO nkn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kaha vamo vanapu ngue vimbuto vije vivakuvile mu mingonga, ava vakevo vaje vevua lizi, ");
INSERT INTO nkn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","vuno honi vakevo vaniunga via mavu na kuzanga vufuko, kaha nalishungu lia viuma vieka vikovela nakutuva lizi, kaha kulimi vushuka. ");
INSERT INTO nkn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Vuno honi vije vivakuvile mu mavu acili, vanapu vaje vevua lizi nakulitambula na kuima vushuka, makumi atatu na makumi atanu na limo, na cihita.” ");
INSERT INTO nkn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma muntu akanehe ndeya nakuihaka muntsi lia liendeko, cipue muntsa muhela ndi? Nkuma kaihaka ha citumbiko cayo ndi? ");
INSERT INTO nkn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Omuo nacimo cahi cuma cakushueka, cihonoua kuija hakutoka, kaha naua nacimo cahi ca vushueke civahonoua kuneha ku ceke. ");
INSERT INTO nkn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nga uoshe uje hali na matuitui evue.” ");
INSERT INTO nkn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kaha uahandekele kuli vakevo nguendi, “Niungeni vimuli na kuivua, seteko muhana ikeyo vakamihana neni naua, vuno honi yeni vakamivuezelelako. ");
INSERT INTO nkn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Uoshe hali naviavingi vakamuvuezelelako, kaha uje kesi, cipue cije cali naco va kamutambulaco.” ");
INSERT INTO nkn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kaha Yesu uahandekele nguendi, “Vumuene vua Njambi vunapu ngue muntu akuva mbuto mu mavu, ");
INSERT INTO nkn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","cipue vene akosa tulo omo ahinduka vije vimbuto vimena na kukola vutsiki na mutania, vuno honi katantekeya muvili nakukolelamo. ");
INSERT INTO nkn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cakulivanga mavu akahaka cishati, kaha mutue, kaha vinona ku mitue. ");
INSERT INTO nkn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Vuno honi omo vimbuto vinahi, hajevene uavitejele na mpoko ya kutejesa omuo ntsimbu ya kuteja yahetele.” ");
INSERT INTO nkn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kaha Yesu uahandekele nguendi, “Vumuene vua Njambi tukavusetekesa na vika, cipue cisimo muka tukalikuasesa hali vukevuo? ");
INSERT INTO nkn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Vunapu ngue nona ya musalata, ije omo vaikuva mu mavu, kaha ikeyo yapua yaindende cikuma ku vimbuto vioshe via ha mavu. ");
INSERT INTO nkn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Vuno honi omo vaikuva kaha ikakola na kupua yakama kupulakana viputa vioshe, kaha ikahaka mintango yakama, ngeci tuzila va muilu vapangelemo mashua mu cimbembe cayo.” ");
INSERT INTO nkn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Omuo ya visimo viavingi evi, Yesu uahandekele lizi kuli vakevo kuya nomu muvahaselele kulivuisisa. ");
INSERT INTO nkn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kahandekele kuli vakevo kuakuhona cisimo, vuno honi kumukulo uakele nakulumbunuina vandongisi vendi viuma voshe. ");
INSERT INTO nkn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ha litangua lije, omo capuile cinguezi, Yesu uahandekele kuli vandongisi vendi nguendi, “Tuyeni musinia lia cisali.” ");
INSERT INTO nkn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kaha omo vasezele civunga vaile nakukovela nendi mu vuato. Kaha na mato eka akele nendi. ");
INSERT INTO nkn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaha linkimba liakama lia mpunzi liezile, kaha na mankimba aputukile kukovela mu vuato, kaha na vuato vuaputukile kushula. ");
INSERT INTO nkn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Vuno honi Yesu uakele kuntongo uakosele tulo oku najendamena ha musato, kaha vamuhinduile nakuhandeka kuli ikeye nguavo, “Mulongisi, kuuazivukile nguove tutsa ndi?” ");
INSERT INTO nkn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kaha uahindukile nakutenukila mpunzi, kaha uahandekele ku mankimba nguendi, “Ciyulo! Holoka!” Kaha mpunzi yaholokele, kaha kuakele kuholoka cakama kuluu. ");
INSERT INTO nkn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kaha uahandekele kuli vakevo nguendi, “Vika muteua? Kumuesi na lutsilielo ndi?” ");
INSERT INTO nkn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kaha vakele na liova, kaha vahandekele kuli umo na mukuavo nguavo, “Iya honi ou, cipue mpunzi na mankimba vimuivuila?” ");
INSERT INTO nkn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na vandongisi vendi vaile musinia lia cisali, ku lifuti lia Ngelasa. ");
INSERT INTO nkn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kaha omo uahumine mu vuato, ualiuanene na yala ha vihilo uje uakele na cimbembesi cacipi, ");
INSERT INTO nkn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","uakele nakukala ha vihilo, kaha na muntu uahi uasele kumukuta, cipue na malienge, ");
INSERT INTO nkn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","omuo lualuingi vakele nakumukuta na tukunju na malienge, vuno honi uakele nakuvatuzola malienge na kupokozola tukunju mu vimbazuvuila, kaha naumo uahi uakele na nzili ya ku muononuesa. ");
INSERT INTO nkn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vutsiki na mutania uakele ha vihilo na ha minkinda oku alila, nakulivetuesa ikeye vavenia na mavue. ");
INSERT INTO nkn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kaha omo uamuene Yesu kulahako, uashatukilile kuli ikeye na kumulemesa, ");
INSERT INTO nkn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kaha ualilile na lizi liakutambeka nguendi, “Vika utonda kuli yange, Yesu, Muna Njambi ua Helu lia Vioshe? Njilomba mu lizina lia Njambi, keti unjiyandese.” ");
INSERT INTO nkn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Omuo uahandekele kuli ikeye nguendi, “Huma muli ou yala, yove cimbembesi cacipi!” ");
INSERT INTO nkn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kaha Yesu ua muihuile nguendi, “Yove iya?” Kaha uamukumbuluile nguendi, “Yange civunga, omuo tuvavengi.” ");
INSERT INTO nkn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kaha vamulombele cikuma linga keti avasheke mu lifuti lije. ");
INSERT INTO nkn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nankuma kuakele vutanga vua vangulu vakele na kulia kuje ku munkinda, ");
INSERT INTO nkn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kaha vije vimbembesi viavipi via mulombele nguavio, “Tushekele kuje ku vutanga vua vangulu, linga tukakovele muli vakevo.” ");
INSERT INTO nkn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kaha uavatavesele. Kaha vije vimbembesi viavipi viamuhumine, kaha viakovelele mu vutanga vua vangulu, nankuma vangulu voshe vapuile makulukazi avali, kaha vashatukile nakukakovela mu cisali muje muvakanongelele. ");
INSERT INTO nkn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vaje tuniungi vateuele, kaha vakalekele vije vivamuene mu nganda na mu cifuti. Kaha vantu vezile nakumona vije vialingikile. ");
INSERT INTO nkn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kaha vezile kuli Yesu, kaha vamuene uje yala uakele na vimbembesi viavipi natumama kuje, nazala vuino na mana acili anahiluka muli ikeye, yala uje uakele na vimbembesi viavingi viavipi, kaha vateuele. ");
INSERT INTO nkn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kaha vaje vacimuene vahandekele vije vialingiuile kuli uje yala uakele na vimbembesi viavipi naku vutanga vua vangulu. ");
INSERT INTO nkn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kaha vaputukile kulambelela Yesu linga ahume mu cihela cavo. ");
INSERT INTO nkn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kaha omo uatondele ku kovela mu vuato, uje yala uakele na mahamba ua lombele linga akale nendi. ");
INSERT INTO nkn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Vuno honi ua vianene, kaha uahandekele kuli ikeye nguendi, “Ya kuimbo kuli vavusamba vove, ukavalekese via nakulingila Muene, nomu muanakela nacikeketima hali yove.” ");
INSERT INTO nkn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaha uaile na kuputuka kuambulula mu Ndikapolisi (kulumbununa vinganda likumi) viuma vije viamulingilile Yesu. Kaha vantu voshe valikomokelele. ");
INSERT INTO nkn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kaha omo Yesu uajavukile naua mu vuato kuya musinia ya cisali, civunga cakama ca vantu cakele nendi, kaha uakele kumukulo ya cisali. ");
INSERT INTO nkn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kaha umo mukuluntu uamu njivo ya malombelo, lizina liendi ikeye Njailosi, omo uamuene Yesu uauililile ku viliato viendi, ");
INSERT INTO nkn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ua mulambelele nguendi, “Munange ua mpuevo alinakutonda kutsa. Ija ukamusaleke mavoko ove, linga akanguke na kuyoya.” ");
INSERT INTO nkn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kaha uaile nendi. Civunga cakama ca mukavele oku vamutseka. ");
INSERT INTO nkn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kaha kuakele mpuevo uakele na kuhita maninga ha miaka likumi naivali, ");
INSERT INTO nkn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","uje uayandele cikuma ku vimbanda, uapihisile viuma vioshe viakele navio, vuno honi kakangukile, vuno honi mushongo uendi uatualeleho kuya kuintsi cikuma. ");
INSERT INTO nkn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kaha omo uovuile lutsimo lua Yesu, uamukavele munima yendi mu civunga na kumukuata ku kazaku kendi. ");
INSERT INTO nkn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Omuo uahandekele nguendi, “Nga njikakuata cipue lika ku kazaku kendi kaha njikakanguka.” ");
INSERT INTO nkn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kaha hajevene aje maninga emanene, kaha uovuile mu muvila uendi nguendi nakanguka ku mushongo uendi. ");
INSERT INTO nkn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kaha Yesu uovuile nzili yahumine mu muli ikeye, kaha hajevene uatengulukilile ku civunga, nakuhandekele nguendi, “Iya nakuata ku kazaku kange?” ");
INSERT INTO nkn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kaha vandongisi vendi vahandekele kuli ikeye nguavo, “Unamono civunga cili nakukutseka vuno honi uhandeka nguove, Iya nanjikuata?” ");
INSERT INTO nkn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaha uatalele talele linga amone uje ualingile eci. ");
INSERT INTO nkn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vuno honi uje mpuevo ha kutantekeya cije calingiuile kuli ikeye, uezile kuli Yesu na liova oku alina kujaja nakuuila ku viliato viendi, na kumulekesa vusunga vuoshe. ");
INSERT INTO nkn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kaha uahandekele kuli ikeye nguendi, “Munange ua mpuevo, lutsilielo luove luakukanguisa, ya mu ciyulo kaha kanguka ku mushongo uove.” ");
INSERT INTO nkn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Omo te acili nakuhandeka kuezile vantu kuhuma ku njivo ya mu kakuyula vamo vahandekele nguavo, “Munove ua mpuevo natsi. Vika uyandesela Mulongisi naua?” ");
INSERT INTO nkn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Vuno honi kahakeleko mangana kuli vije viva handekele, Yesu uahandekele kuli muka kuyula ua mu njivo ya malombelo nguendi, “Keti uteue, tsiliela lika.” ");
INSERT INTO nkn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Katavesele muntu uoshe kumukava kuvanga lika Petulu na Tiango na Iuano munaina ya Tiango. ");
INSERT INTO nkn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Omo vahetele ku njivo ya muka kuyula ua njivo ya malombelo, uamuene vitanga, na vantu valila nakukangoka cikuma. ");
INSERT INTO nkn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kaha omo uakovelele, uahandekele kuli vakevo nguendi, “Vika mukangokela na kulila? Kanike katsile vuno honi nakosa tulo.” ");
INSERT INTO nkn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kaha vamujolele. Kaha uavatuhuisile voshe hambanza, kaha uambatele vaishe ya muana na vanaye navaje vakele navo, kaha vaile muje muakele uje kanike. ");
INSERT INTO nkn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uamukuatele ku livoko nakuhandeka kuli ikeye nguendi, “Talita kumi.” Kulumbununa, “Kanike ka mpuevo, njihandeka kuli yove nguange hinduka.” ");
INSERT INTO nkn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hajevene uje kanike ka mpuevo uahindukile na kuenda (uakele na miaka likumi na ivali), kaha voshe valikomokelele. ");
INSERT INTO nkn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kaha ua vasinkikile cikuma nguendi, keti kukale cipue umo napande kutantekeya eci, kaha uavalekele vamuhane viakulia alie. ");
INSERT INTO nkn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kaha Yesu uahumine kuje na kuya ku lifuti liendi, na vandongisi vendi vamukavele. ");
INSERT INTO nkn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kaha ha litangua lia sapalalo uaputukile kulongesa mu njivo ya malombelo, kaha vavengi vamuivuile valikomokelele, nakuhandeka nguavo, “Ou yala kulihoni kuanauana evi vioshe? Mana muka vamuhanene ikeye? Vikomouesa muka viali nakupanga na mavoko endi! ");
INSERT INTO nkn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nkuma ou keti ikeye muka kushonga, muna Maliya na muanaye Tiango na Yosefa na Yundasa na Simoni ndi? Kaha vandumbueni kutuesi navo hano ndi?” Kaha vakevo vamuvianene. ");
INSERT INTO nkn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kaha Yesu uahandekele kuli vakevo nguendi, “Kananguizi kuvamusingimika mu cifuti cendi, naku vantu vendi na mu njivo yendi vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaha kalingile vikomoueso viakama kuje, kuvanga lika kusaleka mavoko endi ku vantu vavandende vaka kuvavala na kuvakanguisa. ");
INSERT INTO nkn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaha ualikomokelele omuo hakuhona lutsiluelo luavo. Kaha uendanganene mu membo na kulongesa. ");
INSERT INTO nkn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kaha uasanene vaje likumi na vavali uaputukile nakuvatuma vaye vali na vavali, nakuvahana nzili yakama ha vimbembesi viavipi. ");
INSERT INTO nkn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Uavashikile nguendi “Keti vambate cimo mu vungenzi vuavo kuvanga lika mbueti, kuakuhona mbolo, cipue njeke, cipue vimbongo mu miva yavo, ");
INSERT INTO nkn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","vuno honi muzale vinkaku keti kuzala vikovelo vivali.” ");
INSERT INTO nkn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","kaha mu njivo yoshe mukovela, “tumamenimo kutuala noho mukahuma mu cihela cije. ");
INSERT INTO nkn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kaha nga cihela coshe cije kuvamitambula na kuviana kumivuilila, omo mukahumamo, litotomoneni likungu lili kuviliato vieni linga vupue vukaleho vueni hali vakevo!” ");
INSERT INTO nkn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaha vaile nakuambulula nguavo vantu vapande kutenguluka. ");
INSERT INTO nkn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kaha vahumisile mahamba vavengi, nakuvuavesa vantu vavengi vaka kuvavala na mazi nakuvakanguisa. ");
INSERT INTO nkn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Omo muene Helonde uevuile nguendi lizina lia Yesu liatsimanene cikuma. Kaha vamo vahandekele nguavo, “Iuano mukakumbuitika na sanguka kuvatsi, mukemo eyi nzili ili nakupanga muli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vuno honi vamo vahandekele nguavo, “Ikeye Eliya.” Veka naua nguavo, “Ikeye kananguizi, ngue ua vamo va vaje tunanguizi va Njambi va laja.” ");
INSERT INTO nkn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Vuno honi omo Helonde vovuile eci uahandekele nguendi, “Iuano uje njavatuile mutue nasanguka.” ");
INSERT INTO nkn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Omuo Helonde uatumine linga vakuate Iuano, na kumukuta na kumutuala mu kamenga, ualingile eci omuo ya Helondiya, mpuevo ya muanaye Filipu omuo uamuambatele. ");
INSERT INTO nkn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Omuo Iuano uahandekele kuli Helonde nguendi, “Keti lishiko kuambata mpuevo ya muanove.” ");
INSERT INTO nkn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kaha Helondiya uakele na citela nendi, kaha uatondele kumutsiha vuno honi uahonouele, ");
INSERT INTO nkn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","omuo Helonde uateuele Iuano, omuo uatatentekeyele nguendi uapua ua vusunga na uakulela, kaha ua muniungile muacili. Omo vamuivuile, ualikomokelele mu mutima uendi, vuno honi cipue ngoco uamutolililile. ");
INSERT INTO nkn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Halitangua lije liasemukile Helonde ua uavuahesele viakulia vakakuyula na vakakushika vaje vahumine ku Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kaha kuezile muna Helondiya ua mpuevo na kukina, uavuahelesele Helonde na vangezi vendi, kaha muene uahandekele kuli uje mumbanda nguendi. “Njilombe coshe cije utonda, kaha njikakuhanaco.” ");
INSERT INTO nkn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kaha ua lisingile kuli ikeye nguendi, “Coshe ulomba kuli yange njikakuhana, cipue mbazuvuila ya vumuene vuange.” ");
INSERT INTO nkn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kaha uaile hambanza, nakuihula vaina nguendi, “Vika njikalomba?” Kaha vaina vamukumbuilile nguavo, “Lomba mutue ua Iuano mu kakumbuitika.” ");
INSERT INTO nkn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hajevene uezile kuli muene nakulomba nguendi, “Njitonda linga unjihane mutue ua Iuano mukakumbuitika ha lilonga hano vene.” ");
INSERT INTO nkn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kaha muene uakele na vusiua vuakama, vuno honi omuo ha kulisinga nguendi na hali vangenzi vendi, katondele kupokola mezi endi aje ahandekele kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaha hajevene muene uatumine lisualale uje mu ka kuniunga kaha ua mushikile linga anehe mutue ua Iuano. Kaha uaile nakumuteta mutue mukamenga, ");
INSERT INTO nkn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kaha vanehele mutue mulilonga, nakuhana uje mutue mumbanda, kaha uje mumbanda uauhanene vaina. ");
INSERT INTO nkn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Omo vandongisi vendi vacuvuile, vezile nakumbata muvila uendi, nakuutsinda mucihilo. ");
INSERT INTO nkn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tunganda vahilukile kuli Yesu, na kumulekesa vioshe vivalingile nevi valongesele. ");
INSERT INTO nkn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kaha uahandekele kuli vakevo nguendi, “Tuyeni ku cihela calikalietu, tukahuimeko cindende.” Omuo vavengi vakele na kuija nakuya, kaha kuvauanene cipue ntsimbu ya kulia. ");
INSERT INTO nkn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaha vakovelele mu vuato nakuya ku cihela cakulishueka kua likaliavo. ");
INSERT INTO nkn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nkuma vavengi vavamuene oku valinakuya, kaha naua vavatantekeyele, kaha vashatukilile kuli ikeye kuhuma ku vinganda vioshe, kaha uavauanene kulutue luendi. ");
INSERT INTO nkn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kaha omo muaile ha ntunda uamuene civunga cakama, kaha uavoviulile ngozi, muomu vapuile ngue vampanga vakuhona kaniungi, kaha naua uaputukile kuvalongesa viuma viavingi. ");
INSERT INTO nkn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Omo kuapuile cinguezi, vandongisi vendi vezile kuli ikeye nakuhandeka nguavo, “Cino cinapu cihela ca kulishueka naua kuatoko, ");
INSERT INTO nkn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","valeke vaye na kuzenguluka mu cifuti na mu membo vazenguluke linga vakalilandele viakulia vakevo vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Vuno honi uavakumbuilile nguendi, “Vahaneni viakulia valie.” Kaha vahandekele kuli ikeye nguavo, “Tuye nakulanda vimbolo mu vimbongo viakupua vihita vivali ndinali, kaha tuvahane valie?” ");
INSERT INTO nkn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kaha uahandekele kuli vakevo nguendi, “Muli na vimbolo vingahi? Yeni mukamone.” Kaha omo vaile nakumona, vahandekele nguavo, “Kuli vimbolo vitanu, na vantsi vavali.” ");
INSERT INTO nkn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kaha ua vashikile nguendi, vatumame hamavu ha vishoni muvivunga. ");
INSERT INTO nkn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kaha vatumamene hamavu muvivunga, muvihita na mumakumi atanu. ");
INSERT INTO nkn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kaha Yesu uambatele vimbolo vitanu na vantsi vavali kaha uatalele kuilu, na kuvivezikisa, kaha uapazuile vije vimbolo, kaha uahanene vandongisi vendi linga vahane vantu, kaha uavapangelele vaje vatsi vavali voshe. ");
INSERT INTO nkn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kaha voshe valile nakukuta. ");
INSERT INTO nkn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vandongisi va Yesu vakunguilile vimbazuvuila via vimbolo na vatsi vije viasaleleho via kupua mitonga likumi na ivali. ");
INSERT INTO nkn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kaha vantu vaje valile vimbolo vapuile vamala makulukazi atanu. ");
INSERT INTO nkn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hajevene Yesu ualekele vandongisi vendi linga vakovele mu vuato vaye kulutue luendi kusinia ya Mbetesainda, te ikeye acili na kushandola civunga. ");
INSERT INTO nkn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kaha omo uavasezele, uaile ku munkinda nakulombela. ");
INSERT INTO nkn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kaha omo kuapuile cinguezi, vuato vuakele hhakati ka cisali kaha uakele likaliendi ha ntunda. ");
INSERT INTO nkn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kaha uamuene vandongisi vendi vali mu vukalu vua mpunzi yakele na kuvaluisa. Kaha omo ntsimbu kanda kuce, uezile kuli vakevo, oku hali nakuenda ha mema. Te hali na kuvatuvakana, ");
INSERT INTO nkn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","vuno honi omo vamumuene hali na kuenda ha cisali vasinganiekele nguavo ndumba ya muntu, kaha vatambekele cikuma, ");
INSERT INTO nkn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nankuma omo vamumuene, kaha vovuile liova cikuma. Vuno honi hajevene uahandekele kuli vakevo nguendi, “Kuateni mitima, yange, keti muteue.” ");
INSERT INTO nkn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kaha uakovelele mu vuato navo kaha na mpunzi ya holokele. Kaha valikomokelele cikuma, ");
INSERT INTO nkn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","omuo ku vovuisile via vije vimbolo, omuo vakolesele mitima yavo. ");
INSERT INTO nkn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kaha omo vajavukile, vahetele ku Ngenesaleta, kaha vakutile vuato ku cikuma. ");
INSERT INTO nkn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kaha omo vahumine mu vuato, hajevene vantu vamutantekeyele Yesu, ");
INSERT INTO nkn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kaha vashatukilile mu vihela vioshe kaha vaputukile kuneha vakakuvavala ha manala avo nakuvatuala kuli kuoshe kuva muivuililile. ");
INSERT INTO nkn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kaha kuoshe kuje kuaile, ku membo, na muvinganda cipue mu mafuti, vakosesele vakakuvavala ha manala avo kuje ku mihela yakulandesela, vamulambelelele linga vaje vakakuvavala vamukuate kumukundilo ua kazaku kendi, kaha voshe vaje vakuateleko vakangukile. ");
INSERT INTO nkn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Honi omo Vafaliseo vakungulukile hamo kuli ikeye, na vamo valongisi va mashiko, vaje vahumine ku Yelusalema, ");
INSERT INTO nkn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","vamuene nguavo vamo va vandongisi vendi vali na kulia na mavoko a kuhona kulela, aje akuhona kutana. ");
INSERT INTO nkn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Omuo Vafaliseo na Vayunda voshe, kuve kulia kuakuhona kutana ku mavoko, mukuniunga cisemua ca vakuluntu vavo. ");
INSERT INTO nkn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kaha omo vahuma ku vihela via kulandesela, kuve kulia kuvanga vavalilelesa vakevo vavenia, kaha kuli visemua viavingi vikuavo vivakaniungu, nge via kukusha vinganja na vindeho na milili.) ");
INSERT INTO nkn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaha Vafaliseo na valongisi va mashiko vehuile Yesu nguavo, “Vika honi vandongisi vove kuve kuyoya kuya na cisemua ca vakuluntu, vuno honi vakali na mavoko akuhona kulela?” ");
INSERT INTO nkn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kaha uahandekele kuli vakevo nguendi, “Isaya uahandekele muacili ha vunanguizi vuendi hali yeni vaka civembulu nguendi, ngue muje vacisoneka nguavo, “Vantu ava, vanjilemesa na tunua tuavo, vuno honi mitima yavo ili kulako nange. ");
INSERT INTO nkn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Vanjishangazala muangoco, vilongesa viavo vinapu via vuntu! ");
INSERT INTO nkn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Museza lishiko lia Njambi, nakukuatelela kulinga cisemua ca vantu.” ");
INSERT INTO nkn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kaha Yesu uahandekele kuli vakevo nguendi, “Munasembulula lishiko lia Njambi, linga muniungilemo cisemua ceni! ");
INSERT INTO nkn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Omuo Mosesa uahandekele nguendi, ‘Singimika isho na noko’, kaha, ‘Uoshe ahandeka via vipi hali ishe cipue vaina, cilivene napande kutsa’, ");
INSERT INTO nkn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","vuno honi muhandeka ngueni, Nga muntu aleka ishe cipue vaina nguendi, ‘Viunanganiala kuli yange inapu Kombani’ (kulumbununa, civanahana kuli Njambi), ");
INSERT INTO nkn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kaha ku umutavesa kulinga cili coshe kuli ishe cipue vaina, ");
INSERT INTO nkn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","eci cinapu kuteua lizi lia Njambi mu cisemua ceni cije muakuata. Kaha na viavingi vije mukalingi.” ");
INSERT INTO nkn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kaha Yesu uasanene vantu linga veje kuli ikeye naua, kaha uahandekele kuli vakevo nguendi, “Njivuilileni, muva voshe, nakuvuisisa. ");
INSERT INTO nkn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nacimo cahi cihuma kumbanza ya muntu cije cikovela muli ikeye cije cihonoua kumulelesa, vuno honi viuma vije vihuma muli muntu vikevio vimupuisa linga keti apue uakulela.” ");
INSERT INTO nkn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nga uoshe uje hali na matuitui evuilile. ");
INSERT INTO nkn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kaha omo uakovelele mu njivo, nakuseza vantu, vandongisi vendi vamuhuile ha cije cisimo. ");
INSERT INTO nkn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma neni naua,” kumuesi nakuvuisisa ndi? Nkuma kumumono ngueni, “vioshe vije vikovela mu muntu viakuhuma kumbanza kuviasa kuhona kumulelesa, ");
INSERT INTO nkn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","muomu ku cekukovela mu mutima uendi, vuno honi muzimo liendi, kaha na kutuvakana ndi?” (Nankuma mucifua eci Yesu natavesa viakulia vioshe kupua via kulela.) ");
INSERT INTO nkn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaha Yesu uahandekele kuli vakevo nguendi, “Vije vikahumu muli muntu vikevio kuviekulelesa muntu. ");
INSERT INTO nkn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Omuo kuhuma mukati, mu mutima ua muntu, mukahumu visinganieka via vupi, vukoyi, kuiva, kutsiha, vupangala, ");
INSERT INTO nkn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kuliveya, nakulinga viuma vioshe via vipi, kukuisa, na mesho mesho, cipululu, vungumba, kulihalesa, na vulema. ");
INSERT INTO nkn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Viuma vioshe evi via vipi vikahuminina mukati, kaha nakupuisa muntu kuhonoua kupua uakulela.” ");
INSERT INTO nkn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kaha Yesu kuhuma kuje uakatukile nakuya ku cihela ca Tile na ku Sindone. Kaha uakovelele mu njivo, cakuhona muntu uoshe kutantekeya, vuno honi kasele kulishueka. ");
INSERT INTO nkn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vuno honi hajevene kuakele mpuevo uakele na munendi ua mpuevo uje uakele na cimbembesi cacipi, vovuile via Yesu, kaha uezile kuli ikeye nakuuila ku viliato viendi. ");
INSERT INTO nkn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nankuma uje mpuevo uapuile Kangelengu, uasemukilile ku Fonisiya mu Siliya. Kaha ualambelele Yesu linga ahumise lihamba muli munendi. ");
INSERT INTO nkn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kaha Yesu uahandekele kuli ikeye nguendi, “Eceni vanike vavandende valivange kulia, omuo keti cacili kuambata mbolo ya vanike na kuyashela tutali.” ");
INSERT INTO nkn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vuno honi uje mpuevo uamukumbuluile nguendi, “Eyo Muene, cipue vene tutali vaje vavutama muintsi lia mesa valia vije vanasezeho vanike!” ");
INSERT INTO nkn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaha Yesu uahandekele kuli ikeye nguendi, “Omuo yakuhandeka ngacije uasa kuya, lihamba linahumu muli munove.” ");
INSERT INTO nkn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaha uahilukile kuimbo, uauanene kanike nakosa ha muhela, na lihamba liamuhumu. ");
INSERT INTO nkn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kaha Yesu uahumine ku cihela ca Tile uahitile mu Sindone na kuya ku cisali ca Ngalileya, nakuheta mu cihela ca Ndikapolisi (kulumbununa vinganda likumi). ");
INSERT INTO nkn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kaha vantu vanehele yala kuli Yesu uje uapuile kasenda matuitui na kalaka, kaha valambelelele Yesu linga a musaleke mavoko endi. ");
INSERT INTO nkn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kaha Yesu uamuhumisile ha civunga ca vantu nakuya nendi kua likaliavo, uakovelesele minie yendi mu matuitui endi, uajekuile, nakumukuata ha ndaka yendi, ");
INSERT INTO nkn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kaha Yesu uatalele kuilu, kaha uasisimukile, nakuhandeka kuli ikeye nguendi, “Efefata,” kulumbununa nguavo, “shokoloka.” ");
INSERT INTO nkn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kaha matuitui tui endi ashokolokele, na ndaka yendi yazitukile, kaha uaputukile kuhandeka muacili. ");
INSERT INTO nkn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kaha Yesu uashikile vantu linga keti valekeko cimo umo, vuno honi cipue uavashikile ngoco ambahoni vatualeleleho kuambulula. ");
INSERT INTO nkn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaha vantu vakomokele cikuma nakuhandeka nguavo, “Nalingi viuma vioshe muacili, cipue tusenda matuitui tui vovua na tuveveve vahandeka.” ");
INSERT INTO nkn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ha matangua aje, omo civunga cakama naua cakungulukile, kaha vahonouele viakulia, Yesu uasanene vandongisi vendi, kaha uahandekele kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Njivua ngozi ha civunga eci, omuo vanakala nange honi matangua atatu, kuakuhona kulia, ");
INSERT INTO nkn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","kaha nga njivaleka nguange vaye na njala ku membo avo, vasa kulezumukila mu ngila, omuo vamo vanahumu kulahako.” ");
INSERT INTO nkn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kaha vandongisi vendi vamukumbuluile nguavo, “Iya asa kulisa vantu ava na mbolo muno mu mpambo?” ");
INSERT INTO nkn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kaha Yesu uahandekele kuli vakevo nguendi, “Muli na vimbolo vingahi?” Vahandekele nguavo, “Vitanu na vivali.” ");
INSERT INTO nkn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kaha uashikile civunga linga vatumame ha mavu, kaha uambatele vimbolo vitanu na vivali, kaha uatsatselelele na kuvipazula kaha uahanene vandongisi vendi linga vahane vaje vantu, kaha vahanene civunga. ");
INSERT INTO nkn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kaha vakele na vantsi vavandende, kaha hanima ya kuvavezikisa, uashikile naua linga avahanevo. ");
INSERT INTO nkn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kaha valile, nakukuta, kaha vakunguluile vije vimbazuvuila vivasezeleho, viapuile mitonga itanu na ivali yakushula. ");
INSERT INTO nkn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Voshe vantu vapuile nge makulukazi auana. ");
INSERT INTO nkn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kaha uavalekele linga vaye, kaha hajevene uakovelele mu vuato na vandongisi vendi, kaha vaile ku cihela ca Ndalamanuta. ");
INSERT INTO nkn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vafaliseo vezile kuli Yesu nakuputuka kulinga nendi vimpata, vatondele ikeye linga avalingile citantekeyeso cakuhuma muilu, linga vamueseke. ");
INSERT INTO nkn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kaha Yesu ualisisumuine mu Cimbembesi cendi, nakuhandeka nguendi, “Omuo vika vantu va cisemua cino vatondela citantekeyeso? Muavusunga, njihandeka kuli yeni nguange, na cimo cahi citantekeyeso cikalingiua ku cisemua cino.” ");
INSERT INTO nkn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kaha uavasezele, uakovelele mu vuato nakuya musinia lia cisali. ");
INSERT INTO nkn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kaha vasuvile kuambata vimbolo, kaha vakele lika na mbolo imo lika mu vuato. ");
INSERT INTO nkn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kaha Yesu uavananguile nguendi, “Liniungeni, nakuzangama ku cimbaluila ca Vafaliseo na cimbaluila ca Helonde.” ");
INSERT INTO nkn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kaha vakele nakuhandeka kuli umo na mukuavo nguavo, “Kutuesi na mbolo.” ");
INSERT INTO nkn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kaha omo Yesu uacitantekeyele, uahandekele kuli vakevo nguendi, “Vika muhandekela ngueni kumuesi na vimbolo? Ku muatantekeyele cipue kuivuisisa ndi? Nkuma vati mitima yeni inakolo? ");
INSERT INTO nkn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muli na mesho vuno honi nkuma kumumono, muli na matuitui nkuma kumuvu indi? Nkuma naua ku muanuka ndi? ");
INSERT INTO nkn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Omo njapazuile vimbolo vitanu via kulisa vantu makulukazi atanu, muakunguluile mitonga ya kushula ya vimbazuvuila vingahi?” Vakumbuluile nguavo “Likumi na ivali.” ");
INSERT INTO nkn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Kaha naua omo njapazuile vimbolo vitanu na vivali via kulisa vantu vakupua makulukazi auana, muakunguluile mitonga ya kushula ya vimbazuvuila ingahi?” Kaha vamukumbuluile nguavo, “Itanu na ivali.” ");
INSERT INTO nkn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kaha uahandekele kuli vakevo nguendi, “Nkuma naku ntsimbu ino hanga ku muvuisisa?” ");
INSERT INTO nkn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kaha vaile ku Mbetesainda. Kaha vantu vamo vanehele muntu umo kuli Yesu uje uapuile kapuputua, vambelelele Yesu linga amukuate. ");
INSERT INTO nkn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kaha Yesu uakuatele uje yala ua kapuputua ku livoko, kaha ua muhumisile hembo, kaha omo ua mujekuila malenzi ha mesho endi kaha uamusalekele mavoko endi, kaha ua muihuile nguendi, “Ulinakumona cimo?” ");
INSERT INTO nkn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kaha uje yala uatalele kuilu nakuhandeka nguendi, “Njimona vantu, vuno honi valinakumoneka ngue miti ili na kuenda.” ");
INSERT INTO nkn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kaha naua uamusalekele mavoko endi ha mesho endi, kaha ua mutalele sui kaha uakangukile, kaha uamuene vioshe muacili. ");
INSERT INTO nkn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kaha uamulekele aye kuimbo liavo, uamulekele nguendi, “Keti ukovele cipue muimbo.” ");
INSERT INTO nkn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kaha Yesu uatualeleho kuya na vandongisi vendi, ku membo a Sesiliya Filipu, kaha omo vaile mu ngila Yesu uehuile vandongisi vendi nguendi, “Vantu vahandeka nguavo Yange iya?” ");
INSERT INTO nkn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kaha vamulekele nguavo, “Vamo vahandeka nguavo yove Iuano Muka kumbuitika, vamo naua nguavo yove Eliya, vamo nguavo yove umo ua vaje tunanguizi va Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kaha uavehuile nguendi, “Vuno honi yeni munjisana ngueni yange iya?” Petulu uamukumbuilile nguendi, “Yove Kilistu.” ");
INSERT INTO nkn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kaha uavashikile nguendi keti valekeko cipue umo muntu hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kaha uaputukile ku valongesa nguendi Muna Muntu napanda kuyanda mu viuma viavingi, nakumuviana kuli vakuluntu na kuli tusasendote vakama na kuli valongisi va mashiko, na kumutsiha, kaha hanima ya matangua atatu akasanguka naua. ");
INSERT INTO nkn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Uavalumbunuine eci muacili kuli vakevo. Kaha Petulu uamutualele kuali kaliavo nakuputuka kumutenukila. ");
INSERT INTO nkn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Vuno honi omo uatengulukile nakumona vandongisi vendi, uatenukilile Petulu, nakuhandeka nguendi, “Hita kunima yange Satana! Omuo kuuesi kumutambela ua Njambi, vuno honi uli kumutambela ua vantu.” ");
INSERT INTO nkn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kaha Yesu uasanene civunga ca vantu hamo na vandongisi vendi linga veje kuli ikeye, kaha uahandekele kuli vakevo nguendi, “Nga kuli uoshe atonda kunjikava, napande kuliviana ikeye vavenia kaha ambate cilindakano cendi na kunjikava. ");
INSERT INTO nkn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Omuo uoshe uje ayoyesa muono uendi akauzimbalesa, kaha uoshe azimbalesa muono uendi omuo yange na muzimbu uacili aka uyoyesa. ");
INSERT INTO nkn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cikuasa vika kuli muntu kuli kunguilila cifuti coshe na kuzimbalesa muono uendi? ");
INSERT INTO nkn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Cuma cika muntu asa kuhingisa mu muono uendi? ");
INSERT INTO nkn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Omuo uoshe uje anjivuila shuamua, na mezi ange mu cisemua cino ca vupangala na vupi, na Muna Muntu naua akamiuvuila shuamua, omo akeja mu vumpau vua Ishe na tungelo va kulela.” ");
INSERT INTO nkn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaha uatualeleleho kuhandeka nguendi, “Cilivene, njimileka nguange, kuli vamo vanemana hano kuvakamono kutsa kuvanga noho vanamono vumuene vua Njambi mu vuija na nzili.” ");
INSERT INTO nkn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hanima ya matangua atanu na limo Yesu uambatele Petulu na Iuano na Tiango kaha vaile ku munkinda ualaha kua likaliavo, kaha Yesu uahimpukile ha mesho avo, ");
INSERT INTO nkn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","kaha na vuzalo vuendi vua viazimine, nakutoka cikuma, kaha naumo uahi ha mavu uasele ku vukusha. ");
INSERT INTO nkn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hhakati kavo kuasholokele Eliya na Mosesa, kaha vakele na kuhandeka na Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kaha Petulu uahandekele kuli Yesu nguendi, “Muene, muacili tuli hano, tutunge vinjivo vitatu, imo yove kaha ikuavo ya Mosesa na ikuavo ya Eliya.” ");
INSERT INTO nkn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Omuo katantekeyele viakele nakuhandeka, omuo vateuele cikuma. ");
INSERT INTO nkn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kaha mashelua avafuikile, na lizi lia huminine mu lishelua ngualio, “Ou ikeye Munange injazanga, muivuilileni.” ");
INSERT INTO nkn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kaha hajevene omo vatalele kuvamuene cipue umo kuvanga Yesu lika. ");
INSERT INTO nkn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kaha omo vakele nakusikumuka kuhuma ku munkinda, uavashikile linga keti valekeko cipue umo ha viuma vije vamuene, kuvanga noho Muna Muntu akasanguka ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kaha valiniungilile evi vimpande vakevo vavenia, nakulihuozola nguavo kusanguka ku vatsi cilumbununa vika. ");
INSERT INTO nkn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kaha vamuihuile nguavo, “Omuo vika valongisi va mashiko vahandeka nguavo Eliya napande kulivanga kuija?” ");
INSERT INTO nkn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kaha uahandekele kuli vakevo nguendi, “Eliya alivanga kuija nakuhiluisa viuma vioshe evi, nkuma vacisoneka vati hali Muna Muntu, nguavo napande kuyanda mu viuma viavingi na kumuviana ndi? ");
INSERT INTO nkn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Vuno honi njimileka nguange Eliya neja laja, kaha vamulingile muoshe muvatondelele, nge omuo vanacisoneke hali ikeye.” ");
INSERT INTO nkn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kaha omo vezile kuli vandongisi vakuavo, vamuene civunga cakama cavazenguluka, kaha na valongisi va lishiko vakele nakulinga vimpata navo. ");
INSERT INTO nkn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaha hajevene omo civunga coshe ca mumuene calikomokelele kaha vaile kuli ikeye nakumumeneka. ");
INSERT INTO nkn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kaha Yesu uavehuile nguendi, “Vika mulinakuhandeka navo?” ");
INSERT INTO nkn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kaha umo uavaje va civunga uamukumbuluile nguendi, “Mulongisi, njinaneha munange ua yala kuli yove, omo hali na cimbembesi ca vuveveve, ");
INSERT INTO nkn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","kaha oshe hacimu uanena cimbembesi cacipi, kaha cimuuisila ha mavu, kaha a huma lifulu ku kanua na kulishumanga ku mazo kaha ominina ngoo, kaha njehuile vandongisi vove linga vacihumise, vuno honi vacihonouele kucihumisa.” ");
INSERT INTO nkn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kaha uakumbuluile nguendi, “Ho yeni cisemua cakuhona lutsilielo, njikakala neni ha ntsimbu yakupua hali? Vintsimbu vingahi honi njinapande kuyanda neni? Munehe kuli yange!” ");
INSERT INTO nkn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaha vamunehele kuli ikeye, kaha omo cimbembesi cacipi camuene Yesu, hajevene capindisile uje kanike ua yala, kaha uauililile ha mavu nakulialumuna, nakuhuma lifulu ku kanua. ");
INSERT INTO nkn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kaha Yesu uehuile ishe nguendi, “Ntsimbu yakupua hali uaputukile?” “Kaha uahandekele nguendi, kuputuka ku vuanike vuendi.” ");
INSERT INTO nkn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Kaha lualuingi cimbembesi cacipi cikamuuisila mu tuhia na mu mema, linga cimunongese, vuno honi nga ulingaho cimo, tuivuileko ngozi nakutukuasa.” ");
INSERT INTO nkn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kaha Yesu uahandekele kuli ikeye nguendi, “Nga uasa! Viuma vioshe vinapu via viasi kuli uje atsiliela.” ");
INSERT INTO nkn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kaha hajevene ishe ya uje kanike uatambekele na kuhandeka nguendi, “Njitsilielia, njikuase yange uakuhona lutsilielo!” ");
INSERT INTO nkn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kaha omo Yesu uamuene civunga cilinakuija hamo nakushatuka, kaha uatenukilile cije cimbembesi cacipi nakuhandeka kuli cikeco nguendi, “Yove cimbembesi cavuveve navusenda matuitui, njikushika, huma muli ikeye, kaha keti ukamuhilukile naua.” ");
INSERT INTO nkn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hanima yakutambeka nakumualumuisa muakuteuesa, kaha camuhumine, kaha uje kanike ua lezumukile, kaha vavengi vasinganiekele nguavo, “Natsi.” ");
INSERT INTO nkn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaha Yesu uamukuatele ku livoko na kumukatula kaha uakatukile. ");
INSERT INTO nkn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kaha omo uakovelele mu njivo, vandongisi vendi vamuihuile ku vushueka nguavo, “Vika honi tuahonouelele ku cihumisa?” ");
INSERT INTO nkn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kaha uahandekele kuli vakevo nguendi, “Cifua ca cimbembesi eci kucasa kuhuma lika kuvanga na lilombelo lika.” ");
INSERT INTO nkn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Vahumine kuje kaha vatualeleleleho noho vahitile mu Ngalileya. Kaha Yesu katondele muntu umo linga atantekeyele kuje kuvaya, ");
INSERT INTO nkn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","omuo uakele nakulongesa vandongisi vendi nguendi, “Muna Muntu vakamuhana mu mavoko a vantu, kaha vakamutsiha, kaha nga vanamutsihi, hanimama ya matangua atatu a kasanguka.” ");
INSERT INTO nkn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Vuno honi kuvevuisisile viahandekele, kaha vateuele kumuihula. ");
INSERT INTO nkn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaha vezile ku Kapenauma, omo uakele mu njivo uavehuile nguendi, “Vika munakala nakuhandeka mu ngila?” ");
INSERT INTO nkn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Vuno honi vaholokele, omuo mu ngila vahandekele nguavo iya uakama cikuma. ");
INSERT INTO nkn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kaha uatumamene nakusana vaje likumi na vavali, kaha uahandekele kuli vakevo nguendi, “Nga uoshe atonda kupua uakulivanga, apue uakumanusuilila ku voshe na kupua ngamba ua voshe.” ");
INSERT INTO nkn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kaha uambatate kanike, nakumuhaka mukati kavo, kaha uamuambatele mu mavoko endi, kaha uahandekele kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uoshe uje atambula kanike uamundende mu lizina liange natambula yange, kaha uoshe uje atambula yange, katambuile yange vuno honi uje uanjitumine.” ");
INSERT INTO nkn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kaha Iuano uahandekele kuli Yesu nguendi, “Mulongisi, tuamuene yala ahumisa mahamba mu lizina liove, kaha tuamuvindikile, omuo keti umo uetu.” ");
INSERT INTO nkn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Vuno honi Yesu uahandekele kuli ikeye nguendi, “Keti mumuvindike,” naumo uahi alinga vipangi viakukomouesa mu lizina liange uje muka ntsimbu naua ase kuhandeka via vipi hali yange. ");
INSERT INTO nkn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Omo uoshe katuluisa napu uetu. ");
INSERT INTO nkn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cilivene njimileka nguange, uoshe amihana nganja ya mema akunua omuo muli na lizina lia Kilistu, kakahonoua kuuana vuana vuendi. ");
INSERT INTO nkn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Uoshe alingisa vanike vavandende vaje vanatsiliela muli yange kulinga vupi, cacili nge muntu uanga cije vamukutile livue liakama liakulolela vunga mu ntsingo yendi nakumumbila mu mema a kalunga. ");
INSERT INTO nkn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaha nga livoko liove likulingisa linga ulinge vupi, litete, cacili kuli yove kukovela mu muono na livoko limo kupulakana kukovela na mavoko avali aje akutuala ku ngehena, ku tuhia tuakuhona kuhua. ");
INSERT INTO nkn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Muje mavuno amuo ke kutsa, na tuhia tuamuo kutue kuzima. ");
INSERT INTO nkn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kaha nga ciliato cove cikulingisa linga ulinge vupi citeteko, cacili kuli yove kukovela mu muono na vusualonda kupulakana kukovela na viliato vivali nakukumbila mu ngehena. ");
INSERT INTO nkn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Muje mavuno amuo ke kutsa, na tuhia tuamuo kutue kuzima. ");
INSERT INTO nkn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kaha nga lisho liove likulingisa linga ulinge vupi, lihumisemo, cacili kuli yove kukovela mu vumuene vua Njambi na lisho limo kupulakana na mesho avali nakukumbila mungehen, ");
INSERT INTO nkn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kuje mavuno vavo kuve kutsa, na tuhia kutue kuzima. ");
INSERT INTO nkn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Muntu uoshe vakamujelesa na muongua mu tuhia. ");
INSERT INTO nkn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Muongua uacili, vuno honi nga muongua uashamuka, ukapua vati naua muongua? “Pueni muongua yeni vavenia, kaha kaleni na ciyulo yeni vavenia.” ");
INSERT INTO nkn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kaha uahumine kuje nakuya kucihela ca ku Yundeya na kutuvakana Yondao, kaha vivunga via kungulukile kuli ikeye naua, kaha naua, kuya ku kapandi kendi, uavalongesele. ");
INSERT INTO nkn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kaha Vafaliseo vezile nakumueseka kaha vamuihuile nguavo, “Capua lishiko yala kulukulula mpuevo yendi?” ");
INSERT INTO nkn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kaha uavakumbuilile nguendi, “Mosesa ua mishikile vati?” ");
INSERT INTO nkn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kaha vahandekele nguavo, “Mosesa uatavesele yala kusoneka mukanda uakulukula, nakumulekesa linga aye kuimbo liavo.” ");
INSERT INTO nkn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Vuno honi Yesu uahandekele kuli vakevo nguendi, “Hakukola ca mitima yeni mukemo muasonekelele eli lishiko. ");
INSERT INTO nkn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Vuno honi hume hakuputuka ca kutanga, ‘Njambi uatangele yala na mpuevo.’ ");
INSERT INTO nkn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Omuo ha cuma eci yala akaseza ishe na naye na kukali pandakana na mpuevo yendi, ");
INSERT INTO nkn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kaha vaje vavali vakapua muvila umo. ");
INSERT INTO nkn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaha cije Njambi napandakana, naumo uahi napande kucizitula.” ");
INSERT INTO nkn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kaha omo vakele mu njivo vandongisi va Yesu vamuihuile naua a cimpande eci. ");
INSERT INTO nkn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kaha uahandekele nguendi, “Uoshe alukulula mpuevo yendi nakuambata ueka, alinga vupangala, ");
INSERT INTO nkn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kaha nga mpuevo alukulula yaliendi nakukashomboka kuueka, kaha nalingi vupangala.” ");
INSERT INTO nkn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kaha vakele nakuneha vanike kuli Yesu, linga a vakuate kaha vandongisi vendi vavatenukilile. ");
INSERT INTO nkn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kaha omo Yesu uacimuene ualuvalele, kaha uahandekele kuli vakevo nguendi, “Eceni vanike vavandende veje kuli yange, keti muvavindike, omuo vumuene vua Njambi vunapu vuavo. ");
INSERT INTO nkn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cilivene, njihandeka kuli yeni, uoshe katambula vumuene vua Njambi ngue kanike uamundende ka kavukovela.” ");
INSERT INTO nkn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kaha uavambatele mu mavoko endi na kuvavezikisa, nakuvakambeka mavoko endi hali vakevo. ");
INSERT INTO nkn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kaha omo Yesu uakele nakuya mu vungenzi vuendi, yala uashatukile na kuija na kutsikama mavuli kuli ikeye, na kumuihula nguendi, “Mulongisi uacili, njilinge vati linga njikasuane vumuene vua muono ua yaye?” ");
INSERT INTO nkn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kaha Yesu uahandekele kuli ikeye nguendi, “Vika unjitumbuila nguove njiuacili? Naumo uahi uacili kuvanga Njambi lika liendi. ");
INSERT INTO nkn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uatantekeya mashiko, ‘Keti utsihe, Keti ulinge vupangala, Keti uive, Keti uhane vukaleho vua makuli, Keti ukuise, Singimika isho na vanoko.’” ");
INSERT INTO nkn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kaha uahandekele kuli ikeye nguendi, “Mulongisi, vioshe evi njaviniungu hume ku vuanike vuange.” ");
INSERT INTO nkn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kaha Yesu omo uamutalele kaha uamuzangele, kaha uahandekele kuli ikeye nguendi, “Uahono cuma cimo, ya, ukalandese viuli navio, uhane vihutu, kaha ukapua na vufuko muilu, kaha ija, linga unjikave.” ");
INSERT INTO nkn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Omuo uevuile evi uakotamesele cihanga cendi, kaha uaile na vusiua, omuo uakele navufuko vuavuingi. ");
INSERT INTO nkn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kaha Yesu uatalele talele, kaha uahandekele kuli vandongisi vendi nguendi, “Capua cacikalu kuli vaje vakakufuka kukovela mu vumuene vua Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kaha vandongisi vendi vakomokele ha mezi endi. Vuno honi Yesu uahandekele kui vakevo naua nguendi, “Vanike, cacikalu vati kukovela mu vumuene vua Njambi! ");
INSERT INTO nkn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cacasi kamelu kukovela mulisho lia nguya kupulakana mukakufuka kukovela mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaha valikomokele cikuma, kaha vahandekele kuli vakevo nguavo, “Iya honi vakamusambesa?” ");
INSERT INTO nkn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu uavatalele kaha uahandekele kuli vakevo nguendi, “Ku vantu cacikalu, vononi keti kuli Njambi, omuo viuma vioshe viaviasi kuli Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulu uaputukile kuhandekele kuli ikeye nguendi, “Tala, tuaseze viuma vioshe nakukukava.” ");
INSERT INTO nkn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu uahandekele nguendi, “Cilivene,” njimileka nguange, “naumo uahi naseze njivo cipue vandumbueni cipue vamuanetu cipue vaina cipue vaishe cipue vanike na mavu, natuyando, omuo yange na muzimbu uacili, ");
INSERT INTO nkn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iya kakatambula cihita muntsimbu ino, vinjivo navandumbu na vamuanetu na vananetu na vanike na mavu, na tuyando, na mu miaka ikeja ya muono ua yaye. ");
INSERT INTO nkn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vuno honi vavengi vaje vali kulutue va kapua kunima, kaha vakunima vakapua kulutue.” ");
INSERT INTO nkn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kaha vakele nakuya mungila, kukanduka ku Yelusalema, kaha Yesu uakele na kuvatuamenena kulutue, kaha vakomokele, navaje vamukavele vovuile liova. Kaha vambatele naua vaje likumi na vavali, uaputukile kuvaleka vije vikalingiua kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nguendi, “Taleni, tulinakukanduka ku Yelusalema, kaha muna Njambi vakamuhana kuli vakuluntu va tutasesondote na valongisi va mashiko kaha vakamuhisa nakumutuala kukutsa, nakumuhana kuli vaje keti vaje Vayunda, ");
INSERT INTO nkn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","kaha vakamushendumuna, na kumujekuila malanzi, nakumupupa, nakumutsiha kaha hanima ya matangua atatu akasanguka.” ");
INSERT INTO nkn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kaha Tiango na Iuano, vana va Zembendeo, vezile kuli ikeye, kaha vahandekele kuli ikeye nguavo, “Mulongisi, tutonda utulingile vioshe tutonda kuli yove.” ");
INSERT INTO nkn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kaha uahandekele kuli vakevo nguendi, “Vika vimutonda kuli yange kumilingila?” ");
INSERT INTO nkn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kaha vahandekele kuli ikeye nguendi, “Tutavese linga tutumame, umo ku livoko liove liacilio mukuavo kulia cimoshue, mu vumpau.” ");
INSERT INTO nkn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Vuno honi Yesu uahandekele nguendi, “Kumuatantekeyele vimuhulisa. Muhasa kunua nganja ije njinua, cipue kumimbuitika mu cimbuitikilo civanjimbuitikile naco?” ");
INSERT INTO nkn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kaha vahandekele kuli ikeye nguavo, “Tuhasa.” Kaha Yesu uahandekele kuli vakevo nguendi, “Nganja ije njinua neni mukainua, na cimbuitikilo ci vananjimbuitika naco, cikeco vakamimbuitika naco, ");
INSERT INTO nkn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","vuno honi kutumama ku livoko liange lia cilio cipue lia cimuoshe keti yange kutava, vuno honi viavaje vanavuaheselele.” ");
INSERT INTO nkn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kaha omo vaje vandongisi likumi vevuile eci, valuvalelele Tiango na Iuano. ");
INSERT INTO nkn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaha Yesu ua vasanene vaije kuli ikeye kaha uahandekele kuli ikeye nguendi, “Muatantekeya ngueni vaje vanapandele kuyula vaje keti Vayunda valiyongola nguavo vali na nzili hali vantu vavo, kaha naua vantuama vavo vali na nzili yakama hali vakevo. ");
INSERT INTO nkn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Vuno honi ku cikafu ngoco hhakati keni, vuno honi uoshe atonda mukuluntu hhakati keni napande kupua ndungo yeni muvoshe. ");
INSERT INTO nkn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kaha naua uoshe atonda kupua ua kulivanga hhakati keni napande kupua ndungo ua voshe. ");
INSERT INTO nkn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Omuo Muna Muntu kezile mukumupangela vuno honi mukupanga, nakuhana muono uendi linga apatule vantu vavengi.” ");
INSERT INTO nkn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kaha vahetele ku Yeliko, kaha omo uakele nakuhuma mu Yeliko na vandongisi vendi na civunga cakama ca vantu, Mbatimeo, uje kapuputua mukakulomba, muna Timeo, uatumamene kumukulo ua ngila. ");
INSERT INTO nkn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kaha omo vovuile nguavo Yesu uaku Nazaleta, uaputukile kutambeka nguendi, “Yesu Muna Ndaviti, njivuileko ngozi!” ");
INSERT INTO nkn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaha vantu vavengi vamuvindikile, vamulekele nguavo aholoke, vuno honi uatambekele cikuma nguendi, “Muna Ndaviti, njivuileko ngozi!” ");
INSERT INTO nkn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kaha Yesu uemanene kaha uahandekele nguendi, “Musaneni.” Kaha vasanene uje kapuputua, kaha uahandekele kuli ikeye nguendi, “Kuata mutima, katuka, alinakukusana.” ");
INSERT INTO nkn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kaha uombilile vuzalo vuendi kaha uemanene nakuya kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kaha Yesu uahandekele kuli ikeye nguendi, “Vika utonda kuli yange linga njikulingile?” Kaha uje yala uakapuputua uahandekele kuli ikeye nguendi, “Muene, njitonda njimone.” ");
INSERT INTO nkn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kaha Yesu uahandekele kuli ikeye nguendi, “Ya, lutsilielo luove lua kukanguisa.” Kaha hajevene uatonene kaha uaputukile na kumukava. ");
INSERT INTO nkn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kaha omo vatondele kuheta kuyehi na Yelusalema, ku Mbetafanje na Mbeteniya, ku munkinda ua Oliveta, uatumine vandongisi vendi vavali, ");
INSERT INTO nkn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kaha uahandekele kuli vakevo nguendi, “Yeni ku limbo lije lili ku kulutue lueni, kaha omo mu kakovelamo mukauana muna cimulu ivanakutu, uje kanda vacimulondeho laja, kaha muzituleni mumunehe kuno. ");
INSERT INTO nkn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nga umo ahandeka kuli yeni nguendi, ‘Vika mulingila eci?’ handekeni ngueni, ‘Muene alina kumutonda kaha tumuhiluisako naua ololo.’” ");
INSERT INTO nkn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaha vaile, nakuuana muna cimulu vanamukutilila ku cikolo mu ngila, kaha vamuzituile. ");
INSERT INTO nkn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kaha vaje vemanene kuje vahandekele kuli vakevo nguavo, “Vika mulinga kuli ou muna cimulu?” ");
INSERT INTO nkn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kaha vavalekele muje muavalekelele Yesu, kaha vavecelele vaile nendi. ");
INSERT INTO nkn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kaha vanehele uje muna cimulu kuli Yesu, kaha vajalele vuzalo vuavo hali uje muna cimulu, kaha ua tumameneho. ");
INSERT INTO nkn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kaha vavengi vajalele vintanga viavo mungila, vamo vajalele maputa a mintango ije vatetele kumehia avo. ");
INSERT INTO nkn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kaha vaje vakele kulutue navaje vakele nakukavangeya munima vakele nakutambeka nguavo, “Hosana! Uakukuisula uje eja mu lizina lia Muene! ");
INSERT INTO nkn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vuakukuisula vumuene vua tatetu Ndaviti vuje vuli nakuija! Hosana ua muilu mulahako!” ");
INSERT INTO nkn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kaha uakovelele mu Yelusalema, nakukakovela mu njivo ya Njambi, kaha omo uatalele talele ku vioshe, kaha omo naua tele kuatoko laja, kaha uaile ku Mbeteniya hamo na vandongisi vendi likumi na vavali. ");
INSERT INTO nkn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Liamukuavo, omo uahumine ku Mbeteniya, kaha Yesu uatsile njala. ");
INSERT INTO nkn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaha uamuene muti ua mukuyu uje uakele kulahako uje uakele na maputa, kaha uaileko nguendi hamo akauanako vushuka. Omo uahetele kuli ukeuo, kauaneneko vushuka vuno honi maputa lika, omuo kuyapuile ntsimbu ya vushuka. ");
INSERT INTO nkn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kaha uahandekele kuli ukeuo nguendi, “Naumo uahi muntu akalia vushuka kuhuma kuli yove naua.” Kaha vandongisi vendi vovuileko. ");
INSERT INTO nkn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kaha vahetele ku Yelusalema nakukovela mu Njivo ya Njambi kaha uaputukile kusheka vaje vakele na kulandesa na kulandulula mu Njivo ya Njambi, kaha uafulumikile vimesa via vaje vakele na kulandulula vimbongo na vituamo via vaje vakele na kulandesa mavembe. ");
INSERT INTO nkn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kaha katavesele naumo kuambata cuma mu Njivo ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kaha uavalongesele, nakuhandeka kuli vakevo nguendi, “Nkuma ku vacisonekele nguavo, ‘Njivo yange ikapua Njivo ya malombelo ya vakamafuti oshe’? Vuno honi muaipuisa muhela ua vezi.” ");
INSERT INTO nkn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kaha vakuluntu va tusasendote na valongisi va mezi a mashiko vacuvuile kaha vatondele ngila ya kumutsihilamo, omuo vamuteuele, omuo civunga coshe cakomokele ha vilongesa viendi. ");
INSERT INTO nkn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kaha omo cinguezi cahetele va humine mu nganda. ");
INSERT INTO nkn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaha omo vahitile cimene, vamuene uje muti ua mukuyu unomu naku mizi. ");
INSERT INTO nkn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kaha Petulu uavulukile kaha uahandekele kuli ikeye nguendi, “Muene, tala! Uje muti ua mukuyu ua singile unomu.” ");
INSERT INTO nkn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kaha Yesu uavakumbuluile nguendi, “Kaleni na lutsilielo muli Njambi. ");
INSERT INTO nkn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cilivene njimileka nguange, uoshe ahandeka kuli ou munkinda nguendi, ‘Katuka uliumbile mu mema a kalunga,’ kaha nga kalingi vimpata mu mutima uendi, vuno honi atsiliela nguendi vioshe ahandeka vikalingika, vaka mu lingila vio. ");
INSERT INTO nkn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nankuma njimileka nguange, vioshe mulomba mu lilombelo, tsilieleni ngueni muavitambula laja, kaha cikapua ceni. ");
INSERT INTO nkn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kaha ha ntsimbu yoshe uimana nakulombela, konekela mukueni nga uli nacimo nendi, linga ishueni ali muilu akamikonekele ku milonga yeni. ");
INSERT INTO nkn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Vuno honi nga kumukonekela, kaha na ishueni ua muilu kakamikonekela ku milonga yeni.” ");
INSERT INTO nkn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kaha vezile naua ku Yelusalema. Kaha omo uakele nakuenda mu njivo ya Njambi, tusasendote vakama, navalongisi va mezi a mashiko, na vakuluntu vezile kuli ikeye, ");
INSERT INTO nkn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kaha vahandekele kuli ikeye nguavo, “Nzili yakama muka uli na kulikuasesa hakulinga viuma evi, cipue iya uakuhanene nzili yakama linga ulinge evi?” ");
INSERT INTO nkn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu uahandekele kuli vakevo nguendi, “Njimihula cihula, kaha munjikumbulule, kaha njimileka ha nzili yakama njili nakulikuasesa hakulinga evi viuma. ");
INSERT INTO nkn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Cimbuitiko ca Iuano cahumine muilu indi ku vantu? Njikumbululeni.” ");
INSERT INTO nkn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kaha valingile vimpata umo na mukuavo nguavo, “Nga tuhandeka nguetu, ‘Cakuhuminine muilu,’ kaha ahandeka nguendi, ‘Vika honi muateuele ku mutsiliela?’ ");
INSERT INTO nkn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Vuno honi nga tuhandeka nguetu, ‘Cahuminine ku vantu’?” Vateuele vantu, omuo voshe vatantekeyele nguavo Iuano uapuile kananguizi ua vusunga. ");
INSERT INTO nkn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaha vakumbuluile Yesu nguavo, “Kututantekeya.” Kaha Yesu uavakumbuilile nguendi, “Kunjimileke nzili yakama njilinakuli kuasesa kulinga viuma evi.” ");
INSERT INTO nkn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kaha uaputukile kuhandeka kuli vakevo mu visimo nguendio, “Yala uakunine citungu ca mikolovozi, kaha uazinguisileko cipatanga, kaha uahindile cina ca kukamuinamo viniu, kaha naua uatungile kaposhi, nakusezela vaka kupanga, kaha uaile ku lifuti lieka. ");
INSERT INTO nkn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kaha omo ntsimbu yakuteja yahetele, uatumine ngamba kuli vaka kupanga, linga vambate vushuka mu citungu ca mikolovozi. ");
INSERT INTO nkn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kaha vamukuatele na kumupupa, na kumusheka mavoko voko. ");
INSERT INTO nkn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kaha naua uatumine mukuavo ngamba, kaha vamuvetuesele ku mutue, nakumulinga muashuamua. ");
INSERT INTO nkn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kaha uatumine mukuavo, kaha naua vamutsihile, navakuavo naua vavalingile muje vene, vamo vavapupangele vamo vava tsihile. ");
INSERT INTO nkn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kaha kuasalele umo, muana ua yala yazangele, ha mamanusuilo uamutumine kuli vakevo, nakuvalekesa nguendi, ‘Vakasingimika munange.’ ");
INSERT INTO nkn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vuno honi vaje vaka kupanga vahandekele kuli umo na mukuavo nguavo, ‘Ou ikeye muna vavenia citungu, ijeni, tumutsihe, kaha vufuko vupua vuetu.’ ");
INSERT INTO nkn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaha vamukuatele nakumutsiha, nakumumbila kusinia lia citungu.” ");
INSERT INTO nkn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kaha Yesu uavehuile nguendi, “Vika honi, viakalinga vavenia citungu ca mikolovozi?” Kaha vamukumbuluile nguavo, “Akeja nakutsiha vaka kupanga, nakuhana citungu ca mikolovozi ku veka.” ");
INSERT INTO nkn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ku muatandele evi visoneka? “‘Livue lije vaka kutunga vavianene likelio linapu lia seho kuli voshe, ");
INSERT INTO nkn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","eci cikeco calingile Muene, kaha cinapu cakukomokesa kuli yetu.’” ");
INSERT INTO nkn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kaha vesekele linga vamukute, vuno honi vateuele civunga ca vantu, omuo vasinganiekele nguavo nahandeka cisimo eci kuluisa vakevo, kaha vamusezele na kuya. ");
INSERT INTO nkn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kaha vatumine vamo Vafaliseo na vaka mpunga ya Helonde, kuli Yesu linga vamukuate kuya nomu muahandekela. ");
INSERT INTO nkn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kaha vezile nakuhandeka kuli ikeye nguavo, “Mulongisi, tuatantekeya nguetu uapua ua vusunga, omuo kuesi kutala hali muntu cipue uapua ua vulemu cipue kuahi kuuesi kulipesa ha muntu ha viyongola via muntu, kuuesi kutala hacituamo ca muntu, kaha naua ukalongesa via vusunga via Njambi. Capandemo kufueta lisimu kuli Sezale, indi kuahi?” ");
INSERT INTO nkn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tuvafuete indi, keti tuvafuete? Vuno honi Yesu hakumona visinganieka via vipi, uahandekele kuli vakevo nguendi, “Vika munjesekela? Njineheleni mbongo ya muuaya uaya, njiyitale.” ");
INSERT INTO nkn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Vanehele ije mbongo ya muuaya uaya. Kaha uahandekele kuli vakevo nguendi, “Cihanga ceya eci ciliho na lizina lieya liliho?” Vahandekele kuli ikeye nguavo, “Via Sezale.” ");
INSERT INTO nkn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kaha Yesu uahandekele kuli vakevo nguendi, “Haneni Kasezale viakundama kuli Kasezale, na kuli Njambi viakundama kuli Njambi.” Kaha voshe vakomokele hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kaha Vasanduki vezile kuli ikeye, vaje vakahandeka nguavo kukuesi kusanguka ku vatsi, kaha vamuhuile cihula nguavo, ");
INSERT INTO nkn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mulongisi, Mosesa uatusonekelele nguendi, ‘Nga muanaye atsa kaha naseze mpuevo, vuno honi kasezele muana, uje yala napande kuambata uje mpuevo, linga asemeneko vana vaje vanapandele kusemenako ikeye.’ ");
INSERT INTO nkn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mulizimo liavo vapuile vatanu na vavali, uakulivanga uambatele mpuevo, kaha omo uatsile kasezele vana, ");
INSERT INTO nkn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kaha ua mucivali ua muambatele, kaha nendi naua uatsile, kasezele vana, na ua mucitatu naikeye naua cifua cimo, ");
INSERT INTO nkn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","kaha voshe kuvasezele vana. Kumamanuisilo uje mpue vo uatsile. ");
INSERT INTO nkn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hakusanguka uje mpuevo a kapua ueya? Vaje vatanu na vavali voshe uapuile mpuevo yavo.” ");
INSERT INTO nkn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma ku muatantekeye ngueni muapihisa, omuo kumutantekeya visoneka cipue nzili ya Njambi? ");
INSERT INTO nkn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Omo vakahinduka ku vatsi, ku vakambata cipue kushuombuesa, vuno honi vakapua ngue tungelo va muilu. ");
INSERT INTO nkn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kaha ha kusanguka vatsi, kumuatandele mu livulu lia Mosesa, hali lije liputa, omo Njambi uahandekele kuli ikeye nguendi, ‘Yange Njambi ua Avilahama, na Njambi ua Isake, na Njambi ua Yakomba’? ");
INSERT INTO nkn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Keti Njambi uavakakutsa, vuno honi Njambi ua vakakuyoya, unapihisa.” ");
INSERT INTO nkn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kaha umo ua valongisi va mashiko uahetele kaha ua vovuile valinga vimpata kuli umo na mukuavo, kaha hakumona ngeci Yesu uavakumbuluile muacili, kaha vamuihuile nguavo, “Lishiko muka ku mashiko oshe lia kulivanga?” ");
INSERT INTO nkn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu uavakumbuluile nguendi, “Cakulivanga eci, ‘Tolilila, Yove Isaleli! Muene Njambi yetu, uapua Muene umo, ");
INSERT INTO nkn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kaha mu kazanga Muene yeni na mitima yeni yoshe, na muono ueni uoshe, na mana eni oshe, na nzili yeni yoshe.’ ");
INSERT INTO nkn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lishiko lia mu civali eli, ‘Zanga mukueni ngue muje muualizanga yove vavenia.’ Kukuesi naua lishiko liakama cikuma lipulakana aua.” ");
INSERT INTO nkn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kaha mulongisi ua mashiko vehuile Yesu nguendi, “Uahandeka vusunga, Mulongisi, vusunga vene uapua umo lika, kaha kukuesi ueka kuvanga ikeye lika, ");
INSERT INTO nkn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","kaha ku muzanga na mutima uoshe, nakuvuisisa kuoshe, na nzili yoshe, nakuzanga mukueni ngue omuo ualizangela yove vavenia, viapulakana na tusitu va cikombelo na vikombelo vikuavo naua.” ");
INSERT INTO nkn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kaha omo Yesu uamuene nguendi uakumbuluile na mana, uahandekele kuli ikeye nguendi, “Kuuesi kulahako na vumuene vua Njambi.” Kuhuma haje naumo uahi naua uamuihuile cihula. ");
INSERT INTO nkn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kaha omo Yesu uakele nakulongesa mu njivo ya Njambi, uahandekele nguendi, “Cijavati honi linga vaka kulongesa mashiko vahandeke nguavo Kilistu muna Ndaviti? ");
INSERT INTO nkn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ndaviti vavenia, vamuvuavesele na Cimbembesi Uakulela kaha uahandekele nguendi, “‘Muene uahandekele kuli Muene yange nguendi, tumama ku livoko liange lia cilio, kuvanga noho njikahaka vitozi veni ku viliato vieni.’ ");
INSERT INTO nkn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndaviti vavenia amusana nguendi ‘Muene,’ kaha cifua vati honi linga apue munendi?” Civunga covuilille kuli ikeye nakuvuahelela. ");
INSERT INTO nkn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kaha omo Yesu uakele nakulongesa uahandekele nguendi, “Zangameni kuli valongisi va mashiko, vaje vakai nakuenda mu tuzaku tualaha linga vavasingimike mu mihela ya kulandesela, ");
INSERT INTO nkn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na vituamo viacili via mu vi njivo ya malombelo na mihela ya kasingimiko ya ku viuano, ");
INSERT INTO nkn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vaje vali na kupihisa vinjivo via vantuluue mukulimuesa ha kulombela malombelo alaha. Vakatambula cihiso cakama.” ");
INSERT INTO nkn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kaha Yesu uatumamene kuyehi nakuakutambuila milambu, kaha uakele nakutala vantu omo vakele na kuhaka vimbongo mu cikuama ca njivo ya Njambi. Vavengi vakakufuka vakele nakulambuila vimbongo viavingi. ");
INSERT INTO nkn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kaha ntuluue uakuhutua uezile, kaha ualambuile tuuaya uaya tuvali tua vunengu tuatundende. ");
INSERT INTO nkn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kaha uasanene valongisi vendi linga veje kuli ikeye, kaha uahandekele kuli vakevo nguendi, “Cilivene njimileka nguange, ou ntuluue uacihutu nalambula viavingi kupulakana voshe vaje vanalambula mu cikuama. ");
INSERT INTO nkn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Omuo voshe vanalambuile kusetekesa na vufuko vuavo vuavuingi, vuno honi ikeye nalambuila kuya mukuhutua cendi kaha naua ualambuila vioshe vimbongo viakele navio, viaku muyoyesa mu vuyoye vuendi.” ");
INSERT INTO nkn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kaha omo Yesu uahumine mu njivo ya Njambi, kaha umo uavandongisi vendi uahandekele kuli ikeye nguendi, “Tala, Mulongisi, kuvuaha ca mavue aua na kuvuaha kua vinjivo evi!” ");
INSERT INTO nkn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kaha Yesu uahandekele kuli ikeye nguendi, “Uli nakumona evi vinjivo viakama ndi? Na limo liahi livue likasalaho helu lia likuavo, oshe vaka ombila kuti.” ");
INSERT INTO nkn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kaha omo Yesu uatumamene ha munkinda ua Oliveta ha lutue lua njivo ya Njambi, Petulu na Tiango na Iuano na Anduleo vamuihuile kualikaliavo nguavo, ");
INSERT INTO nkn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuleke eci cikalingika ntsimbu muka, kaha cimueso muka cikalingiua omo vioshe evi vikalingiua?” ");
INSERT INTO nkn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kaha Yesu uaputukile kuhandeka kuli vakevo nguendi, “Zangameni linga keti umo akamikuise. ");
INSERT INTO nkn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vavengi vakeja mu lizina liange, nguavo, ‘Yange vene!’ kaha vakakuisa vantu vavengi. ");
INSERT INTO nkn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kaha omo mukevua vinzita na kalua ka vinzita, keti mukakomoke, evi viapande kusholoka, vuno honi keti kukotoka ca mavu. ");
INSERT INTO nkn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Omuo lifuti likatengulukila lifuti likuavo, vumuene vukatengulukila vumuene vukuavo, kukakala mandunduma ku mitambela ya kuliseza seza, ku kakala njala ya liangengela. Evi vinapu ngue kuputuka ca mushongo uakusema. ");
INSERT INTO nkn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Vuno honi linuingeni yeni vavenia, omuo vakamituala ku vaka mpunga na kumisompa, kaha vakamipupa mu vinjivo via malombelo, kaha mukemana ha mesho a vanguvulu na vimiene omuo yange, linga muhane vukaleho ha mesho avo. ");
INSERT INTO nkn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kaha muzimbu uacili muapande ku uambulula ku mafuti oshe. ");
INSERT INTO nkn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kaha omo vakamineha ku kumisompa, na kumikuata keti mukateue vimukahandeka. Vuno honi mukahandeke vije vioshe vije vakamihana ha ola ijevene, omuo keti yeni muka vihandeka, vuno honi Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kaha muanaye a kenda vungungu munaina naku mutuala kukutsa, kaha ishe akalinga ngoco na munendi, kaha vana vakatengulukila visemi viavo naku vatsiha, ");
INSERT INTO nkn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","kaha voshe vakamizinda omuo yange. Vuno honi uoshe akatualelaho na kumamanusuilo akovoka. ");
INSERT INTO nkn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Vuno honi nga mukamona cimueso ca shuama ca kukomouesa cije cikaneha kunonga cinemana kuje kucapandele kuimana.” (Muka kutanda ovuisise), kaha vaje vali mu Yundeya vateuele ku minkinda, ");
INSERT INTO nkn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","uoshe uje hali helu lia njivo keti ashuluke ha mavu, cipue kukovela mu njivo yendi, linga ambate cuma, ");
INSERT INTO nkn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","kaha uoshe hali mu lihia keti ahiluke kunima nakuambata cikovelo cendi. ");
INSERT INTO nkn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Caluvinda kuli vaje vanemita na kuli vaje vakajamuesa mu matangua aje! ");
INSERT INTO nkn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lombeleni linga keti cikalingike mu cisika. ");
INSERT INTO nkn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Omuo ha matangua aje kukakala tuyando tuje kutuakeleko hume ha kutanga lifuti lije Njambi uatangele kuheta na ntsimbu ino, kaha ku tukakalako naua. ");
INSERT INTO nkn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kaha nga Njambi kakehesele matangua, nga na muntu uahi akovoka, vuno honi omuo ya vantu vendi vaje vahanguile, uakehesele ku matangua. ");
INSERT INTO nkn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kaha ha ntsimbu ije nga kukakala umo akamileka nguendi, ‘Taleni, Kilistu uno!’ cipue nguavo, ‘Taleni, uje hali kuje!’ keti mutsiliele. ");
INSERT INTO nkn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Omuo kukasholoka Vakilistu va makuli na tunanguizi va Njambi va makuli nakulinga vitantekeyeso na vikomouesa linga vamizimbalese vaje vanahangula Njambi, nga casiua na. ");
INSERT INTO nkn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Vuno honi zangameni njamileke vuima vioshe ntsimbu kanda ihete. ");
INSERT INTO nkn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Vuno honi ha matangua aje hanima ya tuyando, litangua lika zivala, kaha ngonde kuikatu ceke, ");
INSERT INTO nkn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","na vintanga ntanga vikaua kuhuma kuilu, na lilu likaninganga. ");
INSERT INTO nkn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kaha vakamona Muna Muntu eja mu mashuela, na nzili yakama na vumpau. ");
INSERT INTO nkn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kaha akatuma tungelo vendi nakukungulula vantu vendi vahanguile na mahunzi auana, kuhuma ku mamanusuilo a mavu nakumamanusuilo a melu. ");
INSERT INTO nkn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Lilongeseni cilongesa ca muti ua mukuyu, omuo mintango ishoshela na kuhaka maputa, kaha muatantekeya ngueni ntondue ili muyehi. ");
INSERT INTO nkn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kaha naua omo mumona viuma evi vilingiua, kaha mutantekeye ngueni vili muyehi, vili ku cikolo. ");
INSERT INTO nkn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cilivene njimileka nguange, vantu ava vali na kuyoya ntsimbu ino kuvakatsi kuvanga vuima vioshe evi vinalingiua. ");
INSERT INTO nkn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Melu na mavu vioshe vikahua, vuno honi mezi ange kuuakahu. ");
INSERT INTO nkn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Vuno honi ha litangua lije cipue hola naumo uahi atantekeya, cipue vene tungelo va muilu, cipue Muana, vuno honi Tate lika. ");
INSERT INTO nkn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nangukeni, taleleleni, omuo ku mutantekeya hola muka akeja. ");
INSERT INTO nkn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cinapu ngue yala nayi mu vungenzi, kaha omo ahuma hembo aseza vangamba vendi linga vaniunge, umo na umo na vipangi viendi, na kushika muka kuniunga ku cikolo linga atalelele. ");
INSERT INTO nkn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nankuma taleleleni, omuo ku muatantekeyele vavenia njivo akeja, indi ku cinguezi, cipue mukati kavutsiki, cipue ha vandemba cipue ku cimene. ");
INSERT INTO nkn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nga eja vuasi keti akumiuane muakosa tulo. ");
INSERT INTO nkn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kaha vinjimileka vikevio vinjileka voshe nguange, taleleleni!” ");
INSERT INTO nkn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaha kuasalele lika matangua avali linga Paseka na ciuano ca mbolo yakuhona cimbaluila. Kaha vakuluntu va tusasendote na valongisi va mashiko vakele nakutonda ngila yavushueke ya kukuatelamo Yesu nakumutsiha. ");
INSERT INTO nkn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kaha vahandekele nguavo, “Kutuapandele ku cilinga ha ciuano, hamo vantu vakaneha mpindangano.” ");
INSERT INTO nkn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kaha tele Yesu hali ku Mbeteniya mu njivo ya Simoni uje uakele na mbumba. Omo te Yesu uatumamene ku mesa na kulia, mpuevo uezile kuli ikeye na nsuua yakupanga ha livue lia kutoka ya kushula na mazi akutula nakunika na luengo luacili. Uapazuile ije nsuua kaha uetilile ku mutue ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vuno honi kuakele vamo vaje vahandekele kuli umo na mukuavo oku vaniengua nguavo, “Vika vana pihisila aua mazi? ");
INSERT INTO nkn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngue aua mazi vana alandesele ha ndando ya kupulakana vihita vitatu via muuaya uaya (300) ya vimbongo vije vinapande kuhana tuhutu!” Kaha vaniengetelele cikuma hali uje mpuevo. ");
INSERT INTO nkn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Vuno honi Yesu uahandekele kuli vakevo nguendi, “Mueceni, vika muli na kumupakesela? Nalingi cuma cacili kuli yange. ");
INSERT INTO nkn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Omuo yeni ntsimbu yoshe muli na tuhutu, kaha naua ntsimbu yoshe mutonda, muhasa kulinga muacili kuli vakevo, vuno honi kumukakala nange ntsimbu yoshe. ");
INSERT INTO nkn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nalingi muanasela, na vuavesa muvila uange mukunjivuahesela kunjitsinda. ");
INSERT INTO nkn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kaha cilivene njimileka nguange, kuoshe kuje kuvanambulula muzimbu uacili mu lifuti lioshe, ca nalingi vakacihandeka na kumuanukilaho.” ");
INSERT INTO nkn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kaha Yundasa Sakaliote, umo ua vaje vandongisi likumi na vavali, uaile kuli vakuluntu va tusasendote linga akamuende vungungu kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vavuahelele hakuivua vije viahandekele, kaha vamukulahesele kumuhana vimbongo. Kaha Yundasa uaputukile kutonda ngila yakumuendelamo vungungu. ");
INSERT INTO nkn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ha litangua liakulivanga lia mbolo yakuhona cimbaluila, omo valingile cikombelo ca mpanga ca ha paseka, vandongisi vendi vahandekele kuli ikeye nguavo, “Kuli utonda linga tukakuvuahesele kuje ukalila paseka?” ");
INSERT INTO nkn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kaha uatumine vandongisi vendi vavali, kaha uavalekele nguendi, “Yeni mu nganda kaha mukauana yala nambata nsuua ya mema kaha akeja kuli yeni, kaha mukamukave, ");
INSERT INTO nkn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kaha muje muakakovela muka handeke kuli vavenia njivo ngueni, ‘Mulongisi nguendi, ulikuli mulili uange uje ua vangenzi, muje njinapandelele kulila paseka hamo na vandongisi vange?’ ");
INSERT INTO nkn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kaha akamimuesa mulili uakama uakuvuahesa vuino uli helu ya milili ikuavo, kukeko mukavuahesa.” ");
INSERT INTO nkn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kaha vandongisi vendi vaputukileko nakuya kuje ku nganda, kaha vakauanene ngue muje vene muavalekeselelemo, kaha vavuahesele paseka. ");
INSERT INTO nkn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kaha omo capuile cinguezi uezile na vandongisi vendi likumi na vavali. ");
INSERT INTO nkn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kaha omo vakele ku mesa na kulia, Yesu uahandekele nguendi, “Muavusunga vene njimileka nguange, umo ueni akanjenda vungungu, umo uje alinakulia nange.” ");
INSERT INTO nkn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vaputukile kulinienga, nakuhandeka kuli umo na mukuavo nguavo, “Yange ndi?” ");
INSERT INTO nkn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kaha uahandekele kuli vakevo nguendi, “Umo ua vandongisi likumi na vavali, umo uje hali nakutanta mbolo yendi mu lilonga nange. ");
INSERT INTO nkn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Omuo Muna Muntu akaya ngue muje muvanacisoneka hali ikeye, vuno honi luvinda hali uje yala nende vungungu Muna Muntu! Capuile muacili ngue uje yala kasemukile.” ");
INSERT INTO nkn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaha omo vakele nakulia, Yesu uambatele mbolo, na kuivezikisa, kaha uaipazuile, naku ihana kuli vakevo, kaha uahandekele nguendi, “Ambateni, ou ukeuo muvila uange.” ");
INSERT INTO nkn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kaha uambatele nganja naua, kaha muamanesele kutsatsela uavahanene, kaha voshe vanuinemo. ");
INSERT INTO nkn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kaha uahandekele kuli vakevo nguendi, “Aua akeuo maninga ange a litavasano, aje anahitikila vavengi. ");
INSERT INTO nkn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Muavusunga vene njimileka nguange, kunjikanuho naua neni viniu kuvanga noho ha litangua lije omo njikanua neni viniu via viha mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kaha omo vamanesele kuimba muaso, vahuminemo nakuya ku munkinda ua Oliveta. ");
INSERT INTO nkn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kaha Yesu uahandekele kuli vakevo nguendi, “Muva voshe mukateua, omuo vacisoneka nguavo, ‘Njikapupa kaniungi, kaha vampanga vakalishandoka.’ ");
INSERT INTO nkn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vuno honi hanima yakunjisangula, njikaya kulutue lueni ku Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kaha Petulu uahandekele kuli ikeye nguendi, “Cipue voshe vakateua, vuno honi yange kunjikateue.” ");
INSERT INTO nkn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kaha Yesu uahandekele kuli ikeye nguendi, “Muavusunga vene njikuleka nguange, vuno vene vutsiki, ntsimbu kanda ndemba atambeke luvali, ukanjiviana lutatu.” ");
INSERT INTO nkn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Vuno honi uavianene cikuma nguendi, “Nga kutsa nove kaha njikatsa, kunjikakuviana.” Kaha voshe vahandekele cifua cimo. ");
INSERT INTO nkn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kaha vezile ku cihela civasanene Ngetesemani, kaha Yesu uahandekele kuli vandongisi vendi nguendi, “Tumameni hano ntsimbu njilombela.” ");
INSERT INTO nkn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Uambatele Petulu na Tiango na Iuano kukala nendi. Kaha uaputukile kuzeya na vusiua. ");
INSERT INTO nkn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kaha uahandekele kuli vakevo nguendi, “Njivua vusiua vuakama mu mutima uange, cipue ku kutsa, tumameni hano mutalele.” ");
INSERT INTO nkn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Uaile halahako kavundende, kaha uauililile ha mavu nakulombela nguendi, nga casiua, eyi hola imutuvakane. ");
INSERT INTO nkn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kaha uahandekele nguendi, “Tate, Tate, vuima vioshe via viasi kuli yove, humisa eyi nganja kuli yange, vuno honi keti nge ku cizango cange, vuno honi cizango cove cilingiue.” ");
INSERT INTO nkn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kaha uahilukile uavauanene vakosa tulo, kaha uahandekele kuli Petulu nguendi, “Simoni, unakosa? Nkuma kuuasa kutona cipue ha hola? ");
INSERT INTO nkn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Toneni na kulombela linga keti mukovele mu vieseko, cimbembesi cili na kutonda, vuno honi ntsitu inazeye.” ");
INSERT INTO nkn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kaha naua uaile na kulombela, mezi a cifua cimo. ");
INSERT INTO nkn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kaha uahilukile ua vauanene vakosa tulo, omuo mesho avo alemene, kaha ku vatantekeyele mua kumukumbuilila. ");
INSERT INTO nkn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kaha uelukile lua mucitatu, kaha uahandekele kuli vakevo nguendi, “Hanga muakosa na kuhuima? Munapuisamo, hola inahete, Muna Muntu vana muende vungungu na kumuhana mumavoko avaka vupi. ");
INSERT INTO nkn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Indukeni, tuyeni, taleni, vakakunjenda vungungu vali muyehi.” ");
INSERT INTO nkn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kaha hajevene, omo te Yesu alinakuhandeka, Yundasa uezile, uje uapuile umo ua vandongisi likumi na vavali kaha uakele na civunga cije cambatele mikuale na vimbueti, vahumine kuli vakuluntu va tusasendote na valongisi va mashiko na vakuluntu va Vayunda. ");
INSERT INTO nkn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kaha honi uje muka kuenda vungungu uahanene cimueso nguendi, “Uje umo njikatsuemba ikeye yala mukakuata nakumutuala hamo nava kakunuinga.” ");
INSERT INTO nkn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaha hajevene omo uezile, uaile kuli ikeye kaha uahandekele nguendi, “Mulongisi!” Kaha uamutsuembele. ");
INSERT INTO nkn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kaha vamukuatele na mavoko avo nakumukuta. ");
INSERT INTO nkn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Vuno honi kuakele uje umo uemanene kumukulo uahumisile mukuale uendi nakuteta lituitui lia ngamba ua kasasendote uakama. ");
INSERT INTO nkn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kaha Yesu uahandekele kuli vakevo nguendi, “Nkuma muneja ngue muluisa muhuza, na mikuale na vimbueti mukunjikuata ndi? ");
INSERT INTO nkn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hatangua na tangua njinakala neni mu njivo ya Njambi nakulongesa, kaha ku muanjikuatele. Vuno honi linga visoneka vilishulisise.” ");
INSERT INTO nkn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kaha vandongisi vendi voshe vamusezele, na kuteua. ");
INSERT INTO nkn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kaha mukuenje umo uamukavele, na cimo cahi cakele naco kuvanga lika cikovelo ca linui cazalele, kaha vatondele kumukuata, ");
INSERT INTO nkn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vuno honi uasezele ije ntanga ya linui nakuteua mutoto toto. ");
INSERT INTO nkn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kaha vatualele Yesu kuli kasasendote uakama, kaha vakuluntu va tusasendote na vakuluntu, na valongisi va mezi a mashiko vakungulukilile hamo. ");
INSERT INTO nkn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kaha Petulu uamukavele halahako, ku cipango ca kasasendote uakama, kaha uatumamene na vaka kunuinga nakuota tuhia. ");
INSERT INTO nkn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kaha honi vakuluntu vatusasendote na mpunga yoshe vatondele vukaleho hali Yesu linga va mutsihe, vuno honi ku vavuuanene vuahi. ");
INSERT INTO nkn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Omuo vavengi vahandekele vukaleho vua makuli hali Yesu, vuno honi vukaleho vuavo ku vualitombuele. ");
INSERT INTO nkn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vamo vemanene nakuhandeka vukaleho vua makuli hali ikeye, nguavo, ");
INSERT INTO nkn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tua muivuile ahandeka nguendi, ‘njikapihisa eyi njivo ya Njambi ya kutunga na mavoko, kaha mu matangua atatu nji katunga ikuavo naua, ije keti ya kutunga na mavoko.’” ");
INSERT INTO nkn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kaha cipue ngoco vene vukaleho vuavo kuvua litombuele. ");
INSERT INTO nkn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kaha uje kasesondote uakama uemanene hhakati kavo, kaha uehuile Yesu nguendi, “Nkuma kuuesi naviakuvakumbulula? Nkuma cuma muka eci vantu vali nakukuvangeya hakuhana vukaleho vua makuli hali yove?” ");
INSERT INTO nkn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Vuno honi Yesu uaholokele kulu kaha kahanene cikumbululo. Ceka naua kasasendote uakama uamuihuile nguendi, “Nkuma yove Kilistu, Muana uakukuisuliua ndi?” ");
INSERT INTO nkn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kaha Yesu uahandekele nguendi, “Yange vene, kaha mukamona Muna Muntu natumama ku livoko liacilio lia nzili, kaha akahuminina muilu mu mashelua.” ");
INSERT INTO nkn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kaha uje kasasendote uakama uatavuile cikovelo cendi, kaha uahandekele nguendi, “Nkuma vika tutondela naua vakaleho vukuavo? ");
INSERT INTO nkn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Munevu muanashaula. Nkuma visinganieka vieni vika?” Kaha voshe valitavasanene nguavo napande kutsa. ");
INSERT INTO nkn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vamo vaputukile ku mujekuila, nakumufuika ku mesho, nakumupupa, nakuhandeka kuli ikeye nguavo, “Nangula!” Kaha vaka kunuinga vamupupile vinkome. ");
INSERT INTO nkn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Omo Petulu te acili mucipango umo ngamba ua mpuevo ua kasasendote uakama uezile kuyehi nendi. ");
INSERT INTO nkn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kaha omo uamuene Petulu hali nakuota tuhia, uamutalele sui, kaha uahandekele kuli ikeye nguendi, “Nove, vene, uakele na Yesu uaku Nazaleta.” ");
INSERT INTO nkn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Vuno honi uavianene nguendi, “Kunjimutantekeya, kaha kunjitantekeya nevi uli nakuhandeka,” kaha uatuhukile nakuya. Kaha hajevene ndemba uatambekele. ");
INSERT INTO nkn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kaha uje ngamba ua mpuevo uamumuene kaha ualekesele vaje vemanene nendi nguendi, “Nendi vene ua umo uavo!” ");
INSERT INTO nkn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Vuno honi Petulu uavianene naua. Ha kantsimbu kakandende lika vaje vemanene kuje vahandekele kuli Petulu naua nguavo, “Kuuasa kuviana nguove nove umo uavo, omuo cilivene, uhuma ku Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kaha Petulu uaputukile kuhandeka visingo hali ikeye vavenia nguendi, “Njilisinga nguange kunjimutantekeya ou yala muli nakuhandeka!” ");
INSERT INTO nkn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kaha hajevene ndemba uatambekele lua mu civali, kaha Petulu uanukile muahandekele kuli ikeye nguendi, “Ntsimbu kanda ndema atambeke luvali, ukanjiviana lutatu nguove ku unjitantekeya.” Kaha ualilile. ");
INSERT INTO nkn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Omo te cimene vakuluntu va tusasendote na vakuluntu, na valongisi va mezi a mashiko, na vaka mpunga voshe valiuanene nakukutata Yesu nakumutuala kuli Pilato. ");
INSERT INTO nkn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kaha Pilato uamuihuile nguendi, “Yove Muene ua Vayunda?” Kaha uamukumbuluile nguendi, “Omo vene munahandeka.” ");
INSERT INTO nkn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kaha vakuluntu vatusasendote vamuvangeyele vuima viavingi. ");
INSERT INTO nkn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaha Pilato uamuihuile naua nguendi, “Kuuesi na cikumbululo ca kuhandeka ndi? Tala vuima vali nakukuvangeya.” ");
INSERT INTO nkn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Vuno honi Yesu kamukumbuluile, kaha Pilato ualikomokelele. ");
INSERT INTO nkn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kaha ha ciuano uakele nakuvahumisila umo mukamenga uje vakele na kutonda vantu. ");
INSERT INTO nkn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kaha hhakati ka vinzinda vaje vakele mu kamenga, vaje vaka kutsiha vantu omuo ya mpindangano, hakele yala ivatumbuile nguavo Mbalambasa. ");
INSERT INTO nkn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kaha civunga cezile nakuputuka kulomba Pilato linga alinge ngue muje muakalingila kuli vakevo ntsimbu yoshe. ");
INSERT INTO nkn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kaha Pilato uavakumbuluile nguendi, “Mutonda njimihumisile Muene ua Vayunda ndi?” ");
INSERT INTO nkn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Omuo uatantekeyele nguendi capuile kutonda lika kua vakuluntu vatusasendote linga vatuale Yesu kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Vuno honi vakuluntu vatusasendote vashongangeyele civunga linga pilato ahumise Mbalambasa. ");
INSERT INTO nkn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kaha Pilato uahandekele kuli vakevo naua nguendi, “Kaha njilinge vika nou yala ou umutumbula ngueni Muene ua Vayunda?” ");
INSERT INTO nkn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kaha vatambekele cikuma naua nguavo, “Mushukike.” ");
INSERT INTO nkn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kaha Pilato uahandekele kuli vakevo nguendi, “Vika, vupi muka vuanalingi?” Vuno honi vatambekele cikuma nguavo, “Mushukike.” ");
INSERT INTO nkn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kaha omo Pilato uatondele kuvuahelesa civunga, uavahumisilile Mbalambasa. Kaha uapupile Yesu na kuvahanaye linga vamushukike. ");
INSERT INTO nkn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kaha masualale vamutualele mu lipela (mu cipango ca Nguvulu). Kaha vasanene voshe masualele. ");
INSERT INTO nkn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kaha vamuzikile ntanga ya vunengu, nakuzenga cilongo ca vimbimbo nakumuzika. ");
INSERT INTO nkn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kaha vaputukile kumumeneka nguavo, “Haaa, Muene ua Vayunda!” ");
INSERT INTO nkn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kaha vamupupile ku mutue na lihongo, nakumujekuila, kaha vatsikamene nakumulemesa. ");
INSERT INTO nkn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kaha hanima ya kumushendumuna, vamushuluile ije ntanga ya vunengu, nakumuzika vuzalo vuendi. Kaha vamutualele nakumushukika. ");
INSERT INTO nkn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaha valiuanene na yala umo ua lizina lia Simoni uaku Silene, uje uezile mu lifuti uapuile ishe ya Elekizanda na Lufuse, kaha vamusindiyiye linga ambate cilindakano. ");
INSERT INTO nkn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kaha vamutualele ku cihela vatumbuile nguavo Ngolongota (kulumbununa nguavo cihela ca cikola). ");
INSERT INTO nkn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kaha kuje vamuhanene viniu viakupandakana na miila, vuno honi Yesu kavinuine. ");
INSERT INTO nkn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kaha vamushukikile ha cilindakano, nakulipangezela vuzalo vuendi hhakati kavo, na kuta nkela linga vauane muntu na muntu ambataho cika. ");
INSERT INTO nkn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaha yapuile hola ya mu citatu na viuana ku cimene, omo vamushukikile. ");
INSERT INTO nkn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kaha vasonekeleho canukiso ca kumuvangeya nguavo, “Muene ua Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kaha vashukikile vezi vavali hamo na Yesu umo ku livoko lia cilio mukuavo ku livoko lia cimoshue. ");
INSERT INTO nkn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mu ngila eyi vene visoneka viapuilemo vije vihandeka nguavio, “Vamushukikile hamo na vaka vupi.” ");
INSERT INTO nkn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kaha vaje vakele nakuhita vamushauile, na kuningangesa mitue yavo, na kuhandeka nguavo, “Aha! Yove uasa kupihisa njivo ya Njambi na kuitunga naua mu matangua atatu, ");
INSERT INTO nkn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","liyoyese yove vavenia, kaha shuluka ha cilindakano!” ");
INSERT INTO nkn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kaha naua cifua cimovene vakuluntu vatusasendote na valongisi va mezi a mashiko vamushendumuine, na kuhandeka nguavo, “Uayoyesele vakuavo vuno honi kasa kuliyoyesa ikeye vavenia, ");
INSERT INTO nkn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","eceleni ou Kilistu, Muene ua Isaleli linga ashuluke ha cilindakano linga tumumone nakutsiliela.” Vaje vavamushukikile hamo nendi navakevo naua vamutengulukilile nakumushaula. ");
INSERT INTO nkn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaha omo yapuile hola ya likumi na vivali ya mutania, kuakele milima ha mavu hoshe kutuala ha hola ya mucitatu ya mutania. ");
INSERT INTO nkn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kaha ha hola ya mucitatu ya mutania Yesu uasanene na lizi liakutambeka nguendi, “Eloi, Eloi, lama sambakatani?” Kulumbununa nguavo, “Njambi yange, Njambi yange, vika uanjisezela?” ");
INSERT INTO nkn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kaha vamo vaje vakele nakuhita omo vevuile eci vahandekele nguavo, “Taleni, alinakusana Eliya.” ");
INSERT INTO nkn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kaha umo uambuitikile mupelo mu viniu, naku haka ku lihongo na kumuhana linga anue, kaha uahandekele nguendi, “Vandameneni, tumone indi Eliya eja nakumushuluisa.” ");
INSERT INTO nkn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kaha Yesu uatambekele na lizi liakama, kaha uatsile. ");
INSERT INTO nkn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kaha ntanga ya mu njivo ya Njambi ya tavukile hhakati kuhuma kuilu nakuheta kuintsi. ");
INSERT INTO nkn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kaha mukuluntu ua masualale omo uevuile te alinakulila kaha uezile nakumona muje muatsililile kaha uahandekele nguendi, “Cilivene ou yala uapuile Muna Njambi!” ");
INSERT INTO nkn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kuakele vampuevo vamo naua vaje vakele nakutalelela kulahako, hhakati kavo kuakele Maliya Mandalena, na Maliya vaina ya Tiango shongo ya Yosefa na Salome, ");
INSERT INTO nkn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","vaje omo te hali mu Ngalileya vamukavele nakumukuasa kaha naua na vampuevo vavengi vezile nendi ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kaha omo cinguezi cahetele, naua liapuile litangua lia kulivuahesela, litangua lije ntsimbu kanda sapalalo ihete, ");
INSERT INTO nkn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","kaha Yosefa uaku Alamatiya, uasingimikile vaka mpunga, kaha naua uavandamenene kuija ca vumuene vua Njambi, uasimpile nakuya kuli Pilato nakulomba muvila ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kaha Pilato ualikomokelele indi nga Yesu natsi laja, kaha uasanene mukuluntu ua masualale nakumuihula ndi Yesu natsi laja. ");
INSERT INTO nkn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kaha omo uovuile kuli mukuluntu ua masualale nguendi natsi laja, uahanene muvila kuli Yosefa. ");
INSERT INTO nkn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kaha ualandele ntanga ya liniu, nakuneha muvila ha mavu, kaha uamuzengelele muje mu ntanga ya liniu nakuutsinda mu cihilo cije ca kucokola mu livue, kaha uasindumuinineko livue ku cikolo ca cihilo. ");
INSERT INTO nkn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Mandalena na Maliya vaina ya Yosefa vamuene kuje va mutsindile. ");
INSERT INTO nkn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kaha omo sapalalo yahitile, Maliya Mandalena, na Maliya vaina ya Tiango, na Salome, kaha valandele nkundu linga vakavuavese Yesu. ");
INSERT INTO nkn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kaha omo capuile cimene mene ca litangua liakulivanga ha calumingu vaile ku cihilo omo litangua liatuhukile. ");
INSERT INTO nkn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaha vahandekele kuli umo na mukuavo nguavo, “Iya honi akasa kukatuhumisila lije livue liakulema lije lili ku cikolo ca cihilo?” ");
INSERT INTO nkn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kaha vatalele kuilu, vamuene lije livue valihumisako, liapuile liakama. ");
INSERT INTO nkn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kaha vakovelele mu cihilo, kaha vamuene yala natumama ku cilio, nazala kazaku ka kutoka kalaha, kaha valikomokelele. ");
INSERT INTO nkn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kaha uahandekele kuli vakevo nguavo, “Keti muli komokele, mulinakutonda Yesu ua Nazaleta, uje vashukikile. Nasanguka, uahimo, mu cihela muvamutsindile. ");
INSERT INTO nkn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vuno honi yeni, mukaleke vandongisi vendi na Petulu ngueni alivanga kulutue lueni ku Ngalileya, kuje mu kamumona, nge omo muamilekelele.” ");
INSERT INTO nkn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaha vahuminemo nakuteua, nakujaja nakulikomokela, kaha na cimo cahi civahandekele kuli muntu uoshe, omuo vovuile liova. ");
INSERT INTO nkn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Honi omo Yesu uasangukile ha litangua liakulivanga cimene ca calumingu, ualisholuele ha kulivanga kuli Maliya Mandalena, uje yahumisile mahamba vatanu na vavali. ");
INSERT INTO nkn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kaha uaile nakuleka vaje vakele navo, vakele na vusiua na kulila. ");
INSERT INTO nkn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Vuno honi cipue omo vovuile nguavo hali nakuyoya kaha na ikeye uamumuene, vuno honi kuvamutsilielele. ");
INSERT INTO nkn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hanima yeci ualisholuele mucifua ceka naua kuli vamo vantu vavali, omo vakele nakuenda muli lifuti. ");
INSERT INTO nkn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kaha vahilukile nakuleka voshe, vuno honi kuvavatsilielele. ");
INSERT INTO nkn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hanima yevi Yesu ualisholuele kuli vandongisi vendi likumi na umo omo vatumanene ku mesa, kaha uavatenukilile omuo hakuhona lutsilielo na kukola ca mitima yavo, omuo kuvatsilielele vaje vamumuene te nasanguka. ");
INSERT INTO nkn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kaha uahandekele kuli vakevo nguendi, “Yeni mu lifuti lioshe nakuambulula muzimbu uacili kuli muntu voshe. ");
INSERT INTO nkn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uoshe uje atsiliela nakumumbuitika akovoka, vuno honi uje katsiliela vakamuhisa. ");
INSERT INTO nkn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaha vitantekeyeso vikakala na vaje vakatsiliela mu lizina liange, vakahumisa mahamba kaha vakahandeka na mu vindaka vieka, ");
INSERT INTO nkn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","vakakuata manoka, kaha cipue vakanua cuma ca kutsiha ku cikavavulumuna, vakasaleka mavoko avo hali vaka kuvavala, kaha vakakanguka.” ");
INSERT INTO nkn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kaha hanima yakuhandeka navo, Muene Yesu vamutualele muilu, nakutumama ku livoko lia cilio lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kaha vaile nakuambulula kuoshe, kaha Muene uapangele navo nakushulisa mezi a vitantekeyeso vije vivalingile. Ameni.");
INSERT INTO nkn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vantu vavengi vanesekele kusoneka vukaleho vua viuma vije vialishulisilile hhakati ketu. ");
INSERT INTO nkn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vantu vamo vamuene vukaleho vua viuma evi hume hambangelo. Vapangelele Njambi mukulekesa vantu Muzimbu uendi. Vantu ava vahanene vimpande vije viapangahalele kuli yetu. ");
INSERT INTO nkn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nankuma, nange njinayongola nguange njapande kukusonenavio yove mukuluntu Telefilo muvialikavelele, omuo njinavivuisisa vioshe hume havia putukilile. ");
INSERT INTO nkn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Njapanga evi linga utantekeye vusunga vuacili vua viuma vije vivakulongesele. ");
INSERT INTO nkn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ha matangua a Helonde, muene ua Nganda ya Yundeya, kuakele kasasendote lizina liendi Zakaliya, ua kumuyati ua tusasendote va Aviya. Lizina lia mpuevo yendi liapuile Elizaveta, nendi naua uapuile uaku ntanga ya Alone. ");
INSERT INTO nkn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Voshe vapuile vaka vusunga ku mesho a Njambi, vendele muacili na kuononoka Mashiko oshe a Muene Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Vuno honi vakevo kuvakele na muana omuo Elizaveta uapuile ntsimpi, kaha voshe vavali vapuile vakulukazi. ");
INSERT INTO nkn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ha litangua limo Zakaliya uakele nakupanga vipangi viendi via vusasendote mu njivo ya Muene Njambi, omuo yapuile ntsimbu yendi yahete ya kupanga. ");
INSERT INTO nkn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ngue kucilika civakavele tusasendote, Zakaliya vamuhanguile hakuta nkela linga akovele Kumutambele Uakulela cikuma mu njivo ya Muene Njambi nakutsimika insense ha mutula. ");
INSERT INTO nkn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ha ntsimbu Zakaliya uakele na kutsimika insense, civunga ca vantu vakele hambanza na kulombela, ");
INSERT INTO nkn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","kaha kuamusholokelele kangelo ka Muene Njambi, uemanene kucilio ca mutula uakutsimikila insense. ");
INSERT INTO nkn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Omo Zakaliya uamumuene uaniangumukile, kaha uovuile liova. ");
INSERT INTO nkn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Vuno honi Kangelo uahandekele kuli ikeye nguendi, “Keti uvue liova Zakaliya! Njambi novu lilombelo liove. Mpuevo yove Elizaveta akakusemena muana ua yala, kaha ukamuluka lizina liendi Iuano. ");
INSERT INTO nkn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ukavuahelela na kujolela, kaha vavengi vakalisamba ha kusemuka cendi! ");
INSERT INTO nkn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ou muana akapua uakama ku mesho a Muene Njambi. Kakanu viniu cipue viuma viakushasha vije vipendesa. Hume kanda asemuke na ha kusemuka cendi Cimbembesi ca Kulela cika mutuamenena. ");
INSERT INTO nkn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaha akahiluisila vantu vavengi va Isaleli kuli Muene Njambi yavo. ");
INSERT INTO nkn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Akaya kulutue lua Muene, ngue ku nzili na cifua ca vilinga via Eliya kananguizi ua Njambi. Akahiluisa vaishavo na vana vavo hamolika. Akatengulula vaka kuhona kuononoka na kuvahiluisila naua kungila yakuyongola ngue vaka vusunga. Akavuahesela vualumo vantu linga vavandamene Muene.” ");
INSERT INTO nkn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kaha Zakaliya uehuile kangelo nguendi, “Njikatantekeya vatihoni nga cuma eci mucikapua? Omuo yange njinakolo laja, kaha naua mpuevo yange nakolo laja.” ");
INSERT INTO nkn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kaha kangelo uamukumbuluile nguendi, “Yange Ngambiliyele njinemana ku mesho a Njambi. Nanjitumu kuhandeka nove nakukunehela muzimbu ou uacili. ");
INSERT INTO nkn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tolilila honi ukapua u kaveveve omuo kuua kulahelele mezi ange, aje akapua a vusunga omo ntsimbu yauo ikaheta. Ukaholoka kuluu noho litangua lije likulaheso liange kuli yove likapua lia vusunga.” ");
INSERT INTO nkn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vantu vavandamena Zakaliya hambanza kaha valikomokelele cikuma omo uasimbuile cikuma mu Njivo ya Muene Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Omo Zakaliya uatuhukilemo kasele kuhandeka kuli vakevo. Kaha hakuhona kuhandeka lizi limo, uapangesele vitantekeyeso na mavoko endi, kaha vantu vakele hambanza vatantekeyele nguavo namono cimona mu Njivo ya Muene Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaliya omo uamanesele vipangi viendi mu Njivo ya Muene Njambi, kaha uahilukile kunjivo yendi. ");
INSERT INTO nkn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Munima yevi mpuevo yendi Elizaveta uakele na lizimo, uakele mu njivo vingonde vitanu. ");
INSERT INTO nkn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kaha Elizaveta uahandekele nguendi, “Hakukotoka Muene Njambi nanjimuesa kavumbi, nanjihumisa shuamua ku mesho a vantu.” ");
INSERT INTO nkn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Omo Elizaveta uakele na vingonde vitanu na imo via lizimo, Njambi uatumine kangelo Ngambiliyele aye ku Nazaleta mu nganda ya Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kangelo uakele na lizi kuli muana mpuevo umo kanda alimone na yala lizina liendi Maliya. Uje uapuile uakulama kuli yala lizina liendi Yosefa, uaku ntanga ya muene Ndaviti. ");
INSERT INTO nkn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kaha kangelo uezile kuli Maliya uamumenekele na kuhandekele nguendi, “Muene hali nove, kaha nakukuisula cikuma!” ");
INSERT INTO nkn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya uakele na citanga ha lizi lije liahandekele kangelo, uasinganiekele mu mutima uendi nguendi, “Majui aua analumbunuka vika?” ");
INSERT INTO nkn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kaha kangelo uahandekele kuli ikeye nguendi, “Keti uvue liova Maliya, omuo unauana kavumbi kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tala, ukakala na lizimo, kaha ukasema muana ua yala, ukamuluka lizina liendi Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ou muana akapua uakama, kaha vakamutumbula Muna Njambi ua helu lia vioshe. Kaha Muene Njambi akamupuisa muene, ngue muapuile kukuyendi Ndaviti. ");
INSERT INTO nkn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kaha akapua muene ua miyati ya Yakomba kumiaka yoshe, na vumuene vuendi kuvukahu!” ");
INSERT INTO nkn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kaha Maliya uahandekele kuli kangelo nguendi, “Eci cikapua vati? Omuo yange njimuana mpuevo uje kanda alimone na yala.” ");
INSERT INTO nkn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kaha kangelo uamukumbuluile nguendi, “Cimbembesi ca Kulela cikeja hali yove, na nzili ya Njambi Uakuhiana ikakufuika. Nankuma, ha cuma eci uje muana Uakulela vakamutumbula Muna Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tala! Munanoko Elizaveta na ikeye nemita muana ua yala muvukuluntu vuendi. Kaha ino inapu ngonde ya mucitanu na imo ya lizimo liendi cipue vene vamutumbuile nguavo ntsimpi. ");
INSERT INTO nkn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Omuo cuma nacimo cahi cahona Njambi kulinga.” ");
INSERT INTO nkn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kaha Maliya uakumbuluile kangelo nguendi, “Yange njinapu njingamba ya Muene Njambi, cilingiue kuli yange ngue munahandekela.” Kaha munima yevi kangelo uamusezele. ");
INSERT INTO nkn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hanima ya matangua amandende, Maliya ualivuaheselele na kuya ku mbonge ya mu minkinda ya mu nganda ya Yundeya. ");
INSERT INTO nkn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Omo uahete kaha uakovelele mu njivo ya Zakaliya, kaha uahinduisile Elizaveta. ");
INSERT INTO nkn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Omo Elizaveta uovuile kuhinduisa ca Maliya, kaha kakeke uaniangumukile muzimo liendi. Kaha Elizaveta uashulile na Cimbembesi ca Kulela, ");
INSERT INTO nkn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kaha uahandekele na lizi liakama nguendi, “Yove uakukuisula hhakati ka vampuevo voshe, nakuisuliua muana uje iukasema!” ");
INSERT INTO nkn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Omuo vikahoni cuma cakama eci cilingiua kuli yange, ngeci vaina ya Muene yange veje kuli yange? ");
INSERT INTO nkn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tala! Omo vene njovuile lizi liakuhinduisa kuove, haje vene kakeke muzimo liange uaniangumukile na kujolela. ");
INSERT INTO nkn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yove uuakukuisula omuo uakutsiliela ngeci lizi lia Muene Njambi kuli yove likapua lia vusunga! ");
INSERT INTO nkn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya uahandekele nguendi, “Mutima uange ushangazala vukama vua Muene Njambi, ");
INSERT INTO nkn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Muono uange unavuahelela omuo Njambi Muyoyesi uange, ");
INSERT INTO nkn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Omuo nanuka yange ngamba yendi uamundende! Kuhuma hano nakuya kulutue, vantu voshe vakanjitumbula nguavo njimukakuvezika, ");
INSERT INTO nkn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Omuo Njambi muka nzili yoshe nanjilingila viakama. Lizina liendi lia kulela. ");
INSERT INTO nkn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ikeye akamuesa cikeketima kuli voshe vamusingimika, kuhuma kucisemua cimo kutuala ku cisemua cikuavo. ");
INSERT INTO nkn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ikeye nolola livoko liendi lia nzili, nashandula vaka viyongola via kulihalesa. ");
INSERT INTO nkn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nahumisa vamiene vakama ha matanda avo, kaha nahaka vaje vavandende kuvukama. ");
INSERT INTO nkn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nalisa vaje vali na njala na viakulia viacili, kaha vaka kufuka navasheke mavoko voko. ");
INSERT INTO nkn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ikeye naniungu likulaheso lije lia lingile na vakuluntu vetu, kaha neja nakukuasa ngamba yendi Isaleli. ");
INSERT INTO nkn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nanuka kumuesa cikeketima kuli Avilahama naku vikota viendi vioshe ku miaka yoshe!” ");
INSERT INTO nkn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kaha Maliya uasikamene na Elizaveta vingote vitatu, kaha uahilukile kuimbo liavo. ");
INSERT INTO nkn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ntsimbu ya Elizaveta yakutota yahete kaha uapapele muana uayala. ");
INSERT INTO nkn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vandambo na vavushoko vendi vovuile muje Muene Njambi muanamumuesa ngozi yakama, kaha voshe vavuahelelele hamo nendi. ");
INSERT INTO nkn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kaha ha litangua lia mucitanu na atatu, vezile nakutuhula muana ku mukanda, vatondele kumuhindula ishe Zakaliya. ");
INSERT INTO nkn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Vuno honi vaina vahandekele nguavo, “houe! Mulukeni Iuano.” ");
INSERT INTO nkn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vamukumbuluile nguavo, “Kukuesi kavushoko kove ivaluka lizina eli!” ");
INSERT INTO nkn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kaha vaniatele ishe na kulinga vitantekeyeso na mavoko avo ku muihula nguavo, “Lizina muka utonda kuluka munove?” ");
INSERT INTO nkn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kaha Zakaliya ualombele citale asonekeho, omo vacinehele uasonekeleho nguendi, “Lizina liendi Iuano.” Kaha voshe vali komokelele cikuma! ");
INSERT INTO nkn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ha ntsimbu ijevene Zakaliya uasele kuhandeka naua, kaha uaputukile kushangazala Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Vandambo voshe vakele na liova, kaha muzimbu ua uatsimanene ku mutambela uoshe ua minkinda mu nganda ya Yundeya. ");
INSERT INTO nkn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Voshe vaje vovuile muzimbu ou vasinganiekeleho, kaha valihozuele nguavo, “Ou kanike akafua vati?” Omuo casholokele muacili ngeci nzili ya Muene Njambi yakele hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ishe ya Iuano, Zakaliya, uashulile na Cimbembesi ca kulela, kaha uahandekele vimpande vije Njambi uamusholuelele nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kalemeso kuli Muene Njambi ya Isaleli! Neja nakukuasa vantu vendi na kuvapatula. ");
INSERT INTO nkn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Natuhana muyoyesi ua nzili, mutekulu ua ngamba yendi Ndaviti. ");
INSERT INTO nkn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uakulahesele laja muli tunanguizi va Njambi vendi va kulela ");
INSERT INTO nkn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","linga vakatuamene ku nzili ya vitozi vetu voshe vaje vatuzinda. ");
INSERT INTO nkn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ualingile eci kumuesa cikeketima kuli vakukuluila vetu na kushulisilila litavasano liendi lia kulela. ");
INSERT INTO nkn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Eci cikeco cisingo cije ca lisingile na cisemi cetu Avilahama. ");
INSERT INTO nkn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Uakulahesele kutuohiela ku mavoko avitozi vetu, linga tukamupangele cakuhona liova, ");
INSERT INTO nkn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","linga tupue vakulela na vaka vusunga ku mesho endi ku matangua oshe a muono uetu. ");
INSERT INTO nkn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Kaha yove munange, vakakutumbula kananguizi ka Njambi uahelu lia vioshe. Kaha ukatuama kulutue lua Muene muku vuahesa ngila yendi, ");
INSERT INTO nkn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","nakuleka vantu vendi ngeci vakavovola haku vakonekela ku vupi vuavo. ");
INSERT INTO nkn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Omuo Njambi yetu uakala na cikeketima cakama akatumenekela ngue litangua lituhuka kuhuminina kuilu. ");
INSERT INTO nkn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Akatuila ceke kuli voshe vaje vanatumama mu milima na mucimbembe ca kutsa, nakutuamenena mikono yetu mu ngila ya ciyulo.” ");
INSERT INTO nkn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iuano uakolele mu muvila na mu Cimbembesi. Uakele mu mpambo noho litangua liendi lia kulisholola lia hete ku vantu va Isaleli. ");
INSERT INTO nkn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Capuile ngacije ha ntsimbu ije, kuli Sezale Angushitu kua humine lizi lia kushika, linga vasonekese voshe vantu mu vumuene vua Maloma. ");
INSERT INTO nkn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Eci kusoneka cije ca katete civa lingile omo Kiliniu uapuile nguvulu ua Silia. ");
INSERT INTO nkn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaha voshe vaile ku membo avo, va kavasonekeleko. ");
INSERT INTO nkn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kaha Yosefa uahumine ku mbonge ya Nazaleta mu nganda ya Ngalileya, uaile ku mbonge ya Mbetehema mu Yundeya ku limbo lia semukilile Muene Ndaviti, muomu uapuile muka muyati ua Ndaviti. ");
INSERT INTO nkn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uaile nakumusoneka hamo na Maliya uje ya lamene ikeye, uje uakele na lizimo. ");
INSERT INTO nkn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Capuile ngacije omo vakele kuje matangua endi a kutota a hete. ");
INSERT INTO nkn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kaha uapapele munendi ua ntuatua ua yala, kaha ua muzengelele ha ntanga, kaha uamu hakele mu cikasa ca kulila vangombe muomu kukuakele cihela cavo cakukala. ");
INSERT INTO nkn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ku mutambela uje vene kuakele tuniungi mucana, vakelenakuniuka vampanga vavo vutsiki. ");
INSERT INTO nkn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kangelo ua Muene uasholokele kuli vakevo, kaha vumpau vua Muene vuatuile ceke hhakati kavo. Vovuile liova liakama cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kangelo uahandekele kuli vakevo nguendi, “Keti muvue liova! Omo njinaneha Muzimbu Uacili kuli yeni, uje ukaneha kujolela cakama kuli vantu voshe. ");
INSERT INTO nkn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vutsiki vunovene mu mbonge ya Ndaviti munasemuka Muyoyesi ueni, ikeye Kilistu Muene! ");
INSERT INTO nkn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kaha eci cikapua cizivukiso ceni, mukauana kakeke vanamuzengela ha vintanga vana mulangeka mu cikasa caku lila vangombe.” ");
INSERT INTO nkn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hajevene kuasholokele civunga cakama ca masualale ca tungelo va muilu vemanene hamo na kangelo uje uanehele muzimbu, vembile na kulemesa Njambi nguavo, ");
INSERT INTO nkn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Vumpau kuli Njambi ua muilu, ciyulo cikale hano ha mavu kuli vantu vaje valema!” ");
INSERT INTO nkn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Omo tungelo vahilukile muilu kuhuma kuli tuniungi, kaha tuniungi valihandekesele umo na mukuavo nguavo, “Tuyeni honi ku Mbetehema linga tuka mone eci cuma cinalingiuako, cije cana tusholuela Muene.” ");
INSERT INTO nkn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nankuma, vaile hajevene vuasi vuasi vakauanene Maliya na Yosefa na kakeke vana mulangeka mucikasa caku lila vangombe. ");
INSERT INTO nkn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Omo tuniungi vamumuene, vambuluile mezi aje avalekele kangelo hali kakeke. ");
INSERT INTO nkn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaha voshe vaje vovuile valikomokelele ha viuma vije vivahandekele tuniungi. ");
INSERT INTO nkn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Vuno honi Maliya uaniungile mezi oshe aje naku uayongola mu mutima uendi. ");
INSERT INTO nkn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kaha tuniungi vahilukile na kushangazala na kulemesa Njambi ha viuma vioshe voviule, na vije vamuene. Viuma vioshe vialingiuile ngue vene muje muavalekele kangelo. ");
INSERT INTO nkn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Omo kunahiti matangua atanu na atatu, omo ntsimbu yahete yakutuhula kakeke ku mukanda, kaha vamulukile lizina liendi Yesu, lizina lije lia mulukile kangelo ntsimbu kanda amuimite. ");
INSERT INTO nkn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kaha omo matangua apuilemo akulilelesa, Yosefa na Maliya valingile ngue ku Lishiko lia Mosesa. Nankuma, vatualele kanike ku Yelusalema linga vaka mukundike kuli Muene Njambi, ");
INSERT INTO nkn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ngue muvanasoneka mu Lishiko lia Muene Njambi, “Muana uoshe ua ntuatua ua yala vaka mukundike kuli Muene Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mu Lishiko lia Muene Njambi naua lihandeka ngualio visemi vanapande kukombelela nkombelo ya tute vavali cipue vana va mavembe vavali, eci cikeco civalingile Yosefa na Maliya. ");
INSERT INTO nkn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kaha honi kuakele yala umo mu Yelusalema lizina liendi Simoni. Uapuile muka vusunga kaha naua uazangele Njambi, uavandamanene kuovoka kua Isaleli. Cimbembesi cakulela cakele hali ikeye, ");
INSERT INTO nkn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kaha vavisholuele kuli ikeye kuli Cimbembesi uakulela kakatsi kuakuhona kumono Kilistu Muene. ");
INSERT INTO nkn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simoni ha kumutuamenena kuli Cimbembesi ca kulela, uakovelele mu Njivo ya Muene Njambi. Omo visemi vanehele kakeke Yesu mu Njivo ya Muene Njambi va mulinge ngue ku Lishiko vatumbikile lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni uatambuile kakeke mu mavoko endi, uatsatselele kuli Njambi na kuhandeka nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vuavuno Muene Njambi unaniungu likulaheso liove kuli yange, vuavuno tava yange ngamba yove njije nakukala nove mu ciyulo, ");
INSERT INTO nkn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","omuo mesho ange anamono Muyoyesi iunatumu. ");
INSERT INTO nkn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Vantu voshe vakamono kuamena cije ciunavuahesa. ");
INSERT INTO nkn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cikapua ceke cakusholola kuli vaje keti Vayunda, nakuneha vumpau kuli vantu vove va Isaleli.” ");
INSERT INTO nkn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ishe na vaina vali komokelele hali vije via handekele Simoni hali Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kaha Simoni uavakuisuile na kuhandeka kuli Maliya vanaye nguendi, “Tala! kakeke ou vamuhanguile kuli Njambi mukunongesa na kuamena vavengi mu Isaleli. Akapua cimueso ca kuhuma kuli Njambi, cije vantu vavengi vaka muluisa. ");
INSERT INTO nkn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Cimueso cije vantu vavengi cikamuesa viyongola viavo via kushueka. Kaha yove Maliya vusiua vukatuva mutima uove ngue mukuale uakuhomona.” ");
INSERT INTO nkn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kuakele umo kananguizi uamukuluntu ua mpuevo ua ntuluue, lizina liendi Ana muna Fanuele uaku muyati ua Ashele. Uashombokele ha miaka itanu na ivali, ");
INSERT INTO nkn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kaha honi uapuile ntuluue. Uakele na miaka makumi atanu na atatu na miaka iuana. Ikeye kahumine mu njivo ya Muene Njambi, mutania na vutsiki uakele nakulemesa Njambi ha kuliumina kulia na kulombela. ");
INSERT INTO nkn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ha ntsimbu ijevene uahete kuli Maliya na Yosefa uahanene cikandelela kuli Njambi. uahandekele hali uje muana kuli voshe vaje vavandamenene Njambi mukupatula Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Omo Yosefa na Maliya vamanesele vioshe ngue ku Lishiko lia muene Njambi, vahilukile kuimbo liavo ku Nazaleta mu Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kaha muana uakolele uakele na nzili. Uakolele mu mana, kaha vikuisulo via Njambi viakele hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ha muaka na muaka visemi va Yesu vakele nakuya ku Yelusalema ku Ciuano ca Paseka. ");
INSERT INTO nkn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Omo Yesu uakele na miaka likumi na ivali, kaha vaile nendi ku Yelusalema ku cilika ca ciuano ngue ntsimbu yoshe. ");
INSERT INTO nkn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Omo matangua aje a ciuano ahuile, kaha vaputukile kuya kuimbo, vuno honi Yesu uasalele munima mu Yelusalema. Visemi vendi kuvatantekeyele, ");
INSERT INTO nkn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","vayonguele nguavo hamo hali ha cendo, nankuma vendele vungezi vua litangua limo, kaha vaputukile kumutonda hhakati kava vushoko vuavo nava vusamba vavo, ");
INSERT INTO nkn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","vuno honi kuva muuanene. Nankuma, vahilukile naua ku Yelusalema na kumutonda. ");
INSERT INTO nkn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kaha ha litangua lia mu citatu vamuuanene mu Njivo ya Muene Njambi, natumama hhakati ka valongisi va mashiko a Njambi, na kuvovuilila naku vehozola vihula. ");
INSERT INTO nkn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kaha voshe vaje vovuile vali komokelele cikuma mangana endi nakukumbulula cendi. ");
INSERT INTO nkn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Visemi vendi omo vamumuene valikomokelele, kaha vaina vahandekele kuli ikeye nguavo, “Munange, vika unatulingilamo? Tala! Isho nange tunaliniengele na kukutonda cikuma ngeci tukuuane.” ");
INSERT INTO nkn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kaha Yesu uavakumbuluile nguendi, “Vika munanjitondela? Nkuma kumuatantekeyele ngueni njinapande kukala mu njivo ya tate ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Vuno honi vakevo kuvatantekeyele kulumbunuka cakukumbulula cendi. ");
INSERT INTO nkn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kaha Yesu uaile navo ku Nazaleta, kaha kuje uatualeleleho kuvononoka. Vaina vaniungile vioshe evi mu mutima uavo. ");
INSERT INTO nkn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kaha Yesu uakolele mu muvila, na mu mana, uauanene kavumbi kakama kuli Njambi na vantu. ");
INSERT INTO nkn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Evi vioshe vialingiuile omo Sezale Timbeliase te hanga aciyula ha miaka likumi na itanu mu vumuene vua Loma. Ha ntsimbu ije Pontiyu Pilato uapuile nguvulu uamu Yundeya, na Helonde uasuanene mu Ngalileya, munaina Filipu uasuanene mu nganda ya Ituleya na nganda ya Talakoniti, Lisaniya uasuanene mu nganda ya Ambilene, ");
INSERT INTO nkn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anase na Kayafase vapuile Tusasendote Vakama. Ha ntsimbu ijevene Njambi uahandekele kuli Iuano muna Zakaliya omo uakele mu mpambo. ");
INSERT INTO nkn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kaha Iuano uaile ku cihela na cihela ca Ndonga ya Yundau na kuambulula nguendi, “Tengulukeni ku vupi vueni vamimbuitike, kaha Njambi akamisambesa ku vupi vueni.” ");
INSERT INTO nkn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngue muvana soneka mu livulu lia Isaya kananguizi ua Njambi nguavo, “lizi lia umo atambeka mu mpambo nguendi, ‘Vuaheseni tapalo ya Muene Njambi, sungameseni ngila yendi linga akuhitilemo! ");
INSERT INTO nkn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vimbongo vioshe vanapande ku viofuela, minkinda yoshe yakama neyi yaindende vaka viniekumuna, na vingila via kuhenga vanapande kuviolola visungame, na vingila via kuzika vanapande kuvilambesa. ");
INSERT INTO nkn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vantu voshe vakamona kuamena ca Njambi.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaha Iuano ualekele vije vivunga via vantu vezile kuli ikeye nakuvambuitika nguendi, “Eni manoka! Iya honi naminangula linga muteue vukalu vua Njambi vuje vuli nakuija? ");
INSERT INTO nkn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nga mutonda kuteua kuvukalu vua Njambi lingeni viuma vije vimuesa ngeci munatenguluka ku vupi vueni. Keti mu lihandekese mu mitima yeni ngueni ‘Tuli na cisemi cetu Avilahama.’ Mua vusunga njimileka nguange Njambi asa kutengulula mavue aua naku uapuisa vatekulu va Avilahama! ");
INSERT INTO nkn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngimbu vanaihaka laja kumizi ya muti, muti uoshe kuuimi vushuka vua cili vaka uteta nakuumbila mu tuhia.” ");
INSERT INTO nkn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Vantu vamuihuile nguavo, “Kaha honi tulinga vati?” ");
INSERT INTO nkn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Uavakumbuluile nguendi, “Ou hali na vikovelo vivali ahaneko cimo uje kesi naco, kaha nou alina via kulia ahaneko vakuavo.” ");
INSERT INTO nkn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Vaka kutambula lisimo vezile linga avambuitike, kaha vamuihuile nguavo, “Mulongisi, yetu tunapande kulinga vika?” ");
INSERT INTO nkn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kaha uavalekele nguendi, “Keti mukatambule kupulakana omo muvemika.” ");
INSERT INTO nkn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Masualale vamo naua vamuihuile nguavo, “Netu naua tunapande kulinga vika?” Kaha uavalekele nguendi, “Keti muka pukule viuma via vakueni, cipue kuvangela, simpeni na fueto yeni.” ");
INSERT INTO nkn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vantu vakele nalikulahelo lia kuvandamena nguavo Kilistu eja honi, voshe vakele na kulihozola mu mutima yavo hali Iuano nguavo hamo ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaha Iuano uahandekele kuli voshe nguendi, “Njimimbuitika mu mema, vuno honi ouo akeja napu uakama kupulakana yange. Ku njapandele cipue kuzitula mikole ya ha vinkaku viendi. Ikeye akamimbuitika na Cimbembesi ca kulela na mu tuhia. ");
INSERT INTO nkn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Lisehua lili mu livoko liendi, ikeye akapekula na kulelesa muacili vinona vioshe kulijunguilo liendi, kaha tiliku akaitulika mu cishete cendi, vuno honi mujungu uoshe akautsimika na tuhia tuakuhona kuzima!” ");
INSERT INTO nkn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ha kuvasindiya cikuma Iuano uambuluile Muzimbu ua Cili ku vantu. ");
INSERT INTO nkn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Naua Iuano uatenukilile muene Helonde, omo Helonde uambate Helondiya mpuevo ya munaina Filipu, kaha naua uamutenukilile omuo ualingile viuma vieka via vipi. ");
INSERT INTO nkn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cuma cacipi cikuma ca lingile naua Helonde ca kuhaka Iuano mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kaha omo Iuano uakele nakumbuitika vantu voshe na Yesu naua vamumbuitikile. Ha ntsimbu ijevene Yesu omo uakele na kulombela, lilu liashokolokele. ");
INSERT INTO nkn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kaha Cimbembesi ca kulela ca shulukile hali ikeye mucifua ca livembe. Kaha muilu mua humine lizi ngualio, “Yove munange injazema, njili na kuvuahelela hali yove.” ");
INSERT INTO nkn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu uaputukile kuambulula na kulongesa kucivunga te hali na miaka makumi atatu. Kaha vantu vamu tantekeyele nguavo ikeye muna Yosefa. Yosefa uapuile muna Heli, ");
INSERT INTO nkn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli uapuile muna Matati, Matati uapuile muna Levi, Levi uapuile muna Meleki, Maleki uapuile muna Njanayi, Njanayi uapuile muna Yosefa, ");
INSERT INTO nkn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefa uapuile muna Matiyasi, Matayasi uapuile muna Amose, Amose uapuile muna Nashumi, Nashumi uapuile muna Eseli, Eseli uapuile muna Nangai, ");
INSERT INTO nkn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nangai uapuile muna Maate, Maate uapuile muna Matatiya, Matatiya uapuile muna Semehine, Semehine uapuile muna Yoseke, Yoseke uapuile muna Yonda, ");
INSERT INTO nkn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yonda uapuile muna Youanane, Youanane uapuile muna Lehesa, Lehesa uapuile muna Zelumbambele, Zelumbambele uapuile muna Sheyaletiyele, Sheyaletiyele uapuile muna Neli. ");
INSERT INTO nkn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli uapuile muna Meleki, Meleki uapuile muna Andi, Andi uapuile muna Kosame, Kosame uapuile muna Elemandame, Elemandame uapuile muna Ele, ");
INSERT INTO nkn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ele uapuile muna Yoshiua, Yoshiua uapuile muna Ezazale, Ezazale uapuile muna Yolime, Yolime uapuile muna Matata, Matata uapuile muna Levi, ");
INSERT INTO nkn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi uapuile muna Simioni, Simioni uapuile muna Yunda, Yunda uapuile muna Yosefa, Yosefa uapuile muna Njoname, Njoname uapuile muna Eliakime, ");
INSERT INTO nkn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakime uapuile muna Meleya, Meleya uapuile muna Mena, Mena uapuile muna Matata, Matata uapuile muna Natane, Natane uapuile muna Ndaviti, ");
INSERT INTO nkn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndaviti uapuile muna Njesi, Njesi uapuile muna Ovende, Ovende uapuile muna Mbouasi, Mbouasi uapuile muna Salemone, Salemone uapuile muna Naheshoni, ");
INSERT INTO nkn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashone uapuile muna Aminandave, Aminandave uapuile muna Andemine, Andamine uapuile muna Aleni, Aleni uapuile muna Izeloni, Izeloni uapuile muna Peleze, Peleze uapuile muna Yunda, ");
INSERT INTO nkn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yunda uapuile muna Yakomba, Yakomba uapuile muna Isake, Iseke uapuile muna Avilahama, Avilahama uapuile muna Tela, Tela uapuile muna Nahole, ");
INSERT INTO nkn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahole ua puile muna Selunge, Selunge uapuile muna Leu, Leu uapuile muna Pelenge, Pelenge uapuile muna Hevele, Hevele uapuile muna shela, ");
INSERT INTO nkn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela uapuile muna Kainane, Kainane uapuile muna Alepakeshande, Alepakeshande uapuile muna Shemi, Shemi uapuile muna Noua, Noua uapuile muna Lameki ");
INSERT INTO nkn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki uapuile muna Matusela, Matusela uapuile muna Enoki, uapuile muna Njalende, Njalende uapuile muna Maalalele, Maalalele uapuile muna Kenane ");
INSERT INTO nkn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane uapuile muna Enoshe, Enoshe uapuile muna Sete, Sete uapuile muna Andama, Andama uapuile muna Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu hakushula na Cimbembesi ca kulela, uahumine ku Ndonga ya Yundau, kaha Cimbembesi camutuamenenene mu mpambo, ");
INSERT INTO nkn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kuje Satana uakamuesekele matangua makumi auana. Ha ntsimbu ije yoshe Yesu kalile nacimo cahi, omo matangua aje ahuile, kaha uovuile njala. ");
INSERT INTO nkn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kaha Satana uahandekele kuli ikeye nguendi, “Nga u Muna Njambi shika livue eli linga lilihimpule mbolo.” ");
INSERT INTO nkn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Vuno honi Yesu uamukumbuluile nguendi, “Vanavisoneka mu Visoneka nguavo, ‘Muntu kasa kuyoya na mbolo lika kuahi.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kaha Satana ualondesele Yesu helu lia munkinda ualaha, kaha uamumuesele muka ntsimbu kakandende vumuene vuoshe vuahano ha mavu. ");
INSERT INTO nkn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kaha Satana uahandekele kuli ikeye nguendi, “Njikakuhana vumuene ovu na vufuko vuoshe vilimo, omuo vanjihanavio, kaha njikavihana kuli uoshe uje injitonda. ");
INSERT INTO nkn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nga unjilemesa, kaha vioshe evi vikapua viove.” ");
INSERT INTO nkn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu uahandekele kuli ikeye nguendi, “Vanavisoneka mu Visoneke nguavo, ‘Ukalemesa Muene Njambi yove, ikeye lika iukapangela!’” ");
INSERT INTO nkn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kaha Satana uamutualele ku Yelusalema, uamuhakele ha kashongua ka njivo ya Muene Njambi, uahandekele kuli ikeye nguendi, “Nga u Muna Njambi, liumbile ha mavu kuhuma kuno kuilu, ");
INSERT INTO nkn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","omuo vanavisoneka mu Visoneka nguavo, ‘Njambi akashika tungelo vendi na kukuniunga.’ ");
INSERT INTO nkn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kaha vanavisoneka mu Visoneka naua nguavo, ‘Vakakukuata, linga viliato viove keti vikatsutsuke ku livue.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Vuno honi Yesu uahandekele kuli ikeye nguendi, “Vanavisoneka mu Visoneka nguavo, ‘Keti ueseke Muene Njambi yove.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Omo Satana uamanesele kueseka Yesu mu vingila vioshe, kaha uamusezele noho hakauana ntsimbu ikuavo. ");
INSERT INTO nkn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kaha Yesu uahilukile ku Ngalileya, na nzili ya Cimbembesi ca kulela yakele muli ikeye. Kaha muzimbu uendi uatsimanene mu nganda yoshe ya Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu uavalongesele mu vinjivo viavo via malombelo, kaha voshe vamushangazalele. ");
INSERT INTO nkn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu uaile ku Nazaleta, kuje kuakolelele, kaha uakovelele mu njivo ya malombelo ha litangua lia Sapalalo ngue ku cilika cendi. Kaha uemanene na kutanda Visoneka. ");
INSERT INTO nkn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Vamuhanene livulu lia sonekele Isaya Kananguizi ua Njambi. Kaha uazengunuine lije livulu liakuzenga, uauanene ha mutambela uje uatondele kutanda. Kaha uatandele nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Cimbembesi ca Muene Njambi cili muli yange, omuo nanjihangula kuambulula Muzimbu ua Cili kuli vihutu. Nanjitumu kuambulula linga vinzinda vaka vapatule, nakuambulula linga tupuputua vakamone, nakunjituma kupatula vaje vavali nakuyandesa, ");
INSERT INTO nkn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nakunjituma kuambulula ngeci ntsimbu inahete ya kavumbi ka Muene Njambi ku vantu vendi.” ");
INSERT INTO nkn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu uazengele lije livulu, ualihanene naua kuli muka kuniunga, kaha uatumamene. Vantu voshe vakele muje mu njivo ya malombelo vamutalele ntooma, ");
INSERT INTO nkn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","kaha uahandekele kuli vakevo nguendi, “Visoneka evi lelo vinapuisamo ku mesho eni, ngue omo munovu vanakele nakulitanda.” ");
INSERT INTO nkn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kaha voshe vamushangazalele, valikomokelele ku mezi endi acili aje ahandekele, vahandekele nguavo, “Ou ikeye uje muna Yosefa ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kaha uahandekele kuli vakevo nguendi, “Mua vusunga mukanjitela cisimo eci ngueni, ‘Ove cimbanda likanguise yove vavenia!’ Cimukalumbununa cikapua ngueni, ‘Yove linga viuma vioshe muno muimbo liove, vijevene vituovuile viualingile mu Capenama.’ ");
INSERT INTO nkn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mua vusunga njimileka, naumo uahi kananguizi ua Njambi ivakatava muimbo liendi. ");
INSERT INTO nkn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Vuno honi muavusunga njimileka mu lifuti lietu lia Isaleli muakele vantuluue vavengi ha matangua a Eliya kananguizi ua Njambi, omo kalunga kanokele miaka itatu na vingonde vitanu na imo naua honi kuakele njala mu lifuti lioshe. ");
INSERT INTO nkn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliya kuvamutumine kuli voshe, vuno honi kuli ntuluue uje keti Kayunda uje uakele mu limbo lia Zelefani kuyehi na mbonge ya Sindone. ");
INSERT INTO nkn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kuakele vantu vavengi vakele nakuvavala mbumba mu Isaleli ha ntsimbu ya Elisha kananguizi ua Njambi, vuno honi naumo uahi yakanguisile kuvanga lika Namane keti Kayunda uaku Silia.” ");
INSERT INTO nkn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Omo vantu vaje vakele mu njivo ya malombelo vazivile evi, vakele na litoto. ");
INSERT INTO nkn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Vakatukile, kaha vakokelele Yesu hambaza ya nganda, vamutualele kuntsongo ya munkinda haje ha vatungile nganda yavo. Vatondele ngeci vakamumbile mu cimbongo. ");
INSERT INTO nkn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kaha uahitile mukati kavo nakuya. ");
INSERT INTO nkn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu uaile ku Kapenama, mbonge ya mu Ngalileya, kuje uakalongesele vantu lia Sapalalo. ");
INSERT INTO nkn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vantu voshe vakomokele cikuma kuambulula nguendi, omuo mezi endi akele na nzili. ");
INSERT INTO nkn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kaha mu njivo ya malombelo muakele yala umo uakele na Cimbembesi ca kujuala, catambekele cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Haa! Yove Yesu uaku Nazaleta utonda kulinga vika kuno netu? Uneja nakutunongesa ndi? Nja kutantekeya yove uapua umo Uakulela ua Njambi!” ");
INSERT INTO nkn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kaha honi Yesu uashikile Cimbembesi ca kujuala nguendi, “Kuluu huma muli muntu ou!” Kaha cije Cimbembesi ca kujuala cauisilile uje yala ha mavu ku mesho avo voshe, kaha ca humine muli ikeye kuakuhona kumuvetuesa. ");
INSERT INTO nkn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vantu voshe valikomokelele cikuma vaputukile kulihandekesa umo na mukuavo nguavo, “Majui muka aua? Muntu ou hali na nzili ya kushika vimbembesi via kujuala kaha vimuivuila.” ");
INSERT INTO nkn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kaha vialingile vioshe viovuikile mu cihela ca lifuti lije. ");
INSERT INTO nkn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kaha Yesu uahumine mu njivo ya malombelo uaile ku njivo ya Simoni. Uauanene vainamueno ya Simoni vavavala lisika sika liakama cikuma. Valombele Yesu linga amukangule. ");
INSERT INTO nkn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kaha Yesu uaile kuli ikeye nakumukotamena, kaha uashikile lije lisika sika kuhua kaha uakangukile na kuimana nakuputuka kuvapangela via kulia. ");
INSERT INTO nkn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hakulahuka kua litangua, voshe vaje vakele na mishongo yakuli sezaseza vavanehele kuli Yesu, voshe uavahakele mavoko na kuvakanguisa. ");
INSERT INTO nkn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kaha vimbembesi via kujuala naua via huminemo mu vantu vavengi na kutambeka nguavio, “Yove u Muna Njambi!” Vuno honi ikeye uashikile vimbembesi via kujuala ngeci keti vihandeka nacimo cahi naua, omuo vikevio viamutantekeyele nguavio ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Omo kuacele Yesu uatuhukile, nakuya kuali kaliendi lika. Vantu vaputukile kumutondezeka, omo vamuuanene vatondele kumuvindika ngeci keti ahume kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Vuno honi uahandekele kuli vakevo nguendi, “Njapande kuambulula Muzimbu Viacili via vumuene vua Njambi mu vimbonge vieka naua, omuo evi vikevo via njitumine kulinga Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Uakele na kuambulula mu vinjivo via malombelo via Njambi vioshe viamu Yundeya. ");
INSERT INTO nkn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Litangua limo Yesu uemanene ha ntunda ya cisali ca Ngenesaleta te vantu vakele nakulisindika kuya kuli ikeye linga vovue lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kaha uamuene mato avali vanaatutika ku mukulo ua cisali. Vaka kuta vatsi vahumine mu mato na kukusha manda avo. ");
INSERT INTO nkn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu uakovelele mu vuato vumo, vuakele vua Simoni, kaha uamulombele ngeci avusindikile alahako kamandende na hantunda. Yesu uatumamene mu vuato, kaha ualongesele cije civunga. ");
INSERT INTO nkn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Omo Yesu uamanesele kuhandeka, kaha uahandekele kuli Simoni nguendi, “Sindikila vuato haje ha mema a kulova, kaha yove na vakueni teni manda eni linga mujevele vantsi.” ");
INSERT INTO nkn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni uamukumbuluile nguendi, “Muene, tunapanga cikuma vutsiki vuoshe vuno honi nakamo tunakuata kahi. Vuno honi omuo ukahandeka ngoco, kaha tuta manda.” ");
INSERT INTO nkn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kaha omo vate manda vakuate vatsi vavengi cikuma, kaha manda aputukile kutavuka. ");
INSERT INTO nkn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nankuma, vaniatele vavusamba vavo vakele mu vuato vukuavo veje vaku vakuase. Vezile vashulisile mato oshe na vatsi mukemo vaputukile kuvombela. ");
INSERT INTO nkn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Omo Simoni Petulu uamuene vije vialingiuile, uatsikamene ha mavuli ku mesho a Yesu na kuhandeka nguendi, “Muene, huma kuli yange, omuo yange njimuka vupi!” ");
INSERT INTO nkn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na vakuavo vali komokelele cikuma ha kumona vatsi vavengi vava kuatele. ");
INSERT INTO nkn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simoni uakele navavusamba vendi vavali mazina avo apuile Yakomba na Iuano vana va Zembendeo, nava kevo naua vali komokele cikuma. Yesu uahandekele kuli Simoni nguendi, “Keti uzive liova, hume hano ukata vantu.” ");
INSERT INTO nkn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Vatutikile mato avo ku ntunda, vasezele vioshe, kaha vakavele Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Litangua limo Yesu uakele mu mbonge imo muje muakele yala umo uakele nakuyanda na mushongo ua mbumba. Omo uamuene Yesu, uauile nacihanga cendi ha mavu amulambelelele nguendi, “Muene, nga utonda, uasa kunjikanguisa!” ");
INSERT INTO nkn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu uoluele livoko liendi uamukuate uahandekele nguendi, “Njitonda, kanguka!” Hajevene uakangukile. ");
INSERT INTO nkn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu uamushikile nguendi, “Keti ulekeko muntu umo cuma eci kuahi, vuno honi ya ukalisholole kuli kasasendote linga vantu voshe vatantekeye nguavo vakukangula, ambahoni ukakombelele nkombelo ije yashikile Mosesa.” ");
INSERT INTO nkn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Vuno honi muzimbu uahali Yesu uakele nakushanduokela kuoshe, kaha vivunga via vantu vezile nakumuivuilila na kuvakanguisa ku mishongo yavo. ");
INSERT INTO nkn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Vuno honi Yesu kakengi uakele nakuvaseza nakuya kuali kaliendi lika na kulombela. ");
INSERT INTO nkn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Litangua limo omo Yesu uakele nakulongesa, Vafaliseo vamo na valongisi va mezi a Lishiko lia Mosesa vatumamene kuje, vahumine mu membo a ku Ngalileya na ku Yundeya na ku mbonge yakama ya Yelusalema. Nzili ya Muene Njambi yakele hali Yesu mukukanguisa vantu. ");
INSERT INTO nkn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kaha vamala vamo vanehele yala muka kalepa vamulangeka ha citalatala, vesekele kumukovelesa mu njivo linga vamulangeke ku lutue lua Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Omuo civunga ca vantu, kuvauanene ngila yaku mukovelesela mukati. Nankuma, vamutualele helu lia njivo, vatuvile mbengua mu mateya, kaha vamusoselele na citalatala cendi ha mavu mukati ka civunga kulutue lua Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Omo Yesu uavamuene lutsilielo luavo, uahandekele kuli uje yala nguendi, “Kavusamba kange, vipi viove vana visambesa.” ");
INSERT INTO nkn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Valongisi va mezi a Lishiko lia Mosesa na Vafaliseo vaputukile kusinganieka nguavo, “Iya ou yala alinakushaula Njambi? Njambi lika ikeye muka kusambuesa vupi!” ");
INSERT INTO nkn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu uazivukile viyongola viavo, kaha uahandekele kuli vakevo nguendi, “Vikahoni mulina kuyonguela viuma via ngacije? ");
INSERT INTO nkn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Cacasi cika, kuhandeka nguange, ‘Vipi viove vana visambesa,’ indi kuhandeka nguange, ‘Katuka uende’? ");
INSERT INTO nkn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Njimimuesa linga mutantekeye ngueni Muna Muntu hali na nzili hano ha mavu ya kusambuesa vipi.” Kaha uahandekele kuli uje muka kakalepa nguendi, “Njikuleka nguange katuka, ambata citalatala cove, uye ku njivo yove!” ");
INSERT INTO nkn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kaha hajevene uakatukile hhakati kavo, uambate citalatala cendi uaile ku njivo nakushangazala Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaha voshe valikomokelele cikuma! Vovuile liova, vashangazalele Njambi vahandekele nguavo, “Lelo tunamono viuma via kukomokesa!” ");
INSERT INTO nkn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Munima yevi, Yesu uatuhukile, kaha uamuene muka kutambula lisimu, lizina liendi Levi, natumama mu njivo yendi ya kutambuila lisimu. Kaha Yesu uahandekele kuli ikeye nguendi, “Njikave.” ");
INSERT INTO nkn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kaha Levi uakatukile, uasezele vioshe na kumukava. ");
INSERT INTO nkn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kaha Levi calingiuile Yesu ciuano cakama cakulia mu njivo yendi, kaha hhakati kavaje vavalaniene hakele vaka kutambula lisimu na vantu veka vavengi. ");
INSERT INTO nkn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Vafaliseo vamo na valongisi va mezi a Lishiko lia Mosesa vaje vakundamene ku mpunga yavo valiniengelele kuli vandongisi va Yesu. Vehuile nguavo, “Vikahoni mulia na kunua hamo na vaka kutambula lisimu na vaka vupi?” ");
INSERT INTO nkn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu uavakumbuluile nguendi, “Vakangule kuvekutonda cimbanda kuahi, kuvanga vaka kuvavala lika. ");
INSERT INTO nkn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngoco vene yange kunjezile mukusana vantu vaje vanalimono vakevo vavenia nguavo vaka vusunga linga vatenguluke, vuno honi vantu vaje vaka vupi.” ");
INSERT INTO nkn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vantu vamo vahandekele kuli Yesu nguavo, “Vandongisi va Iuano vakalikela kulia vintsimbu viavingi na kulombela, na vandongisi va Vafaliseo naua vakalingi cuma cimo, vuno honi vandongisi vove vakali na kunua ntsimbu yoshe.” ");
INSERT INTO nkn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kaha Yesu uavakumbuluile nguendi, “Nkuma yeni mutalelela vangenzi ku ciuano ca vulo linga vaye na njala ndi? Muavusunga vene kuahi! Omo vavenia vulo acili navo kuvapandele kulinga ngacije. ");
INSERT INTO nkn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Vuno honi litangua likeja omo vakahumisa vavenia vulo hhakati kavo, ambahoni vakalikela kulia.” ");
INSERT INTO nkn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu uavatelele naua cisimo eci nguendi, “Kuuasa kutavula cikamba ku kazaku kakaha na kucitongela ha kazaku ka laja. Nga ulingamo, kaha utavula kazaku kakaha, cikamba caciha kucilitombola na ntanga yalaja. ");
INSERT INTO nkn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naua vene kuvekulongela viniu viavihia mu vinjeke via vilambu vialaja. Nga ulingamo vije vinjeke via vilambu vitavuka kaha viniu vihitikila muangoco. ");
INSERT INTO nkn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vuno honi viniu viavihia vaka vilongela mu vinjeke via vilambu viavihia. ");
INSERT INTO nkn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuuasa kunua viniu viavihia omo unanu laja viniu vialaja. Uhandeka nguove, ‘Viniu vialaja viacili.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ha litangua limo lia Sapalalo Yesu na vandongisi vendi vakele nakuhita mu mehia a tiliku. Vandongisi vendi vaputukile kushututozola mitue ya tiliku, vaitsenene mu mavoko avo, kaha valile vinona. ");
INSERT INTO nkn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kaha Vafaliseo vamo vakele kuje vavehuile nguavo, “Omo vika mulinakulingila evi kuvekulinga ha litangua lia Sapalalo kuya mu Lishiko lia Mosesa?” ");
INSERT INTO nkn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu uavakumbuluile nguendi, “Nkuma kanda mutande vije vialingile Ndaviti na vaje vakele hamo nendi omo vazivile njala ndi? ");
INSERT INTO nkn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uakovelele mu njivo ya Muene Njambi, kasasendote uamuhanene lisesa lia kunona ije mbolo ivakombelele kuli Njambi, ualile, na kuhanako naua vantu vendi. Mbolo ije kuyapandele ku ilia kuli muntu uoshe kuvanga tusasendote lika.” ");
INSERT INTO nkn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kaha Yesu uamanesele nguendi, “Muna Muntu ikeye Muene ua Litangua lia Sapalalo.” ");
INSERT INTO nkn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha litangua lia Sapalalo likuavo Yesu uakovelele mu njivo ya malombelo, kaha ualongesele. Muakele yala umo uakusekua livoko lia cilio. ");
INSERT INTO nkn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kaha valongisi va mezi a Lishiko lia Mosesa na Vafaliseo vamo vatondele kashuilo hali Yesu linga vamu uaneneho mulonga, nankuma, vamutalele ntoma muyehi yehi linga vamone nga ikeye akanguisa uje muntu ha litangua lia Sapalalo. ");
INSERT INTO nkn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Vuno honi Yesu uazivukile viyongola viavo, kaha uahandekele kuli uje yala uakusekua livoko nguendi, “Katuka uije hano hhakati.” Kaha uje yala uakatukile uemanene mukati. ");
INSERT INTO nkn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nankuma, Yesu uahandekele kuli vakevo nguendi, “Njimihula nguange, cuma muka vanatutavesa ha Lishiko lietu kucilinga ha litangua lia Sapalalo? Kupanga viacili indi kupanga viavipi? Kuamena muono ua muntu indi kuunongesa?” ");
INSERT INTO nkn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Uatalele kuli vakevo voshe noku noku, kaha uahandekele kuli uje yala nguendi, “Olola livoko liove.” Uoluele livoko liendi, kaha liakangukile. ");
INSERT INTO nkn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ha cuma eci valongisi va mezi a Lishiko lia Mosesa na Vafaliseo vakele na matoto, kaha valihandekesele hhakati kavo vivapandele kulinga kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ha ntsimbu ije Yesu ualondele ku munkinda na kulombela, kaha uakele nakulombela vutsiki vuoshe kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Omo litangua liatuhukile, kaha uasanene vandongisi vendi linga veje kuli ikeye, kaha uahanguileho likumi na vavali hhakati kavo, vaje vatumbuile tunganda. ");
INSERT INTO nkn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aua akeuo mazina avo: Simoni uje yalukile Petulu na munaina Anduleo, Yakomba na Iuano, Filipu na Mbatolomeo, ");
INSERT INTO nkn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu na Tomasi, Yakomba muna Alufeya, na Simoni (uje ivatumbuile “Zelote.”) ");
INSERT INTO nkn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yundasa muna Yakomba, na Yundasa Sakaliote uje uamuendele vungungu. ");
INSERT INTO nkn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu na vandongisi vendi vahumine ku munkinda kaha vemanene ku mutambela uaku jalamanena. Na civunga ceka cakama ca vandongisi vakele kuje nakumuvandamena. Naua civunga cakama ca vantu cahumine ku Yundeya kuoshe na ku Yelusalema, naku vimbonge via ku cikuma ca Tile na ku Sindone. ");
INSERT INTO nkn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vezile nakumuvuilila na kuvakanguisa ku mishongo yavo. Voshe vaje vakele nakuyanda na vimbembesi via kujuala vezile, kaha uavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kaha civunga coshe ca vantu vesekele kumukambeka mavoko, omuo nzili yahumine kuli ikeye na kuvakanguisa voshe. ");
INSERT INTO nkn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu uatalele vandongisi vendi, kaha uahandekele nguendi, “Muavezika yeni vaka kuhutua, omuo Vumuene vua Njambi vunapu vueni!” ");
INSERT INTO nkn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Muavezika yeni muli na njala vuavuno, omuo mukakuta!” “Muavezika yeni mulinakulila vuavuno, omuo mukajolelela!” ");
INSERT INTO nkn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Muavezika omuo vantu vamizinda na kumiviana na kumishaula na kumitumbula nguavo muva vapi, vioshe evi omuo mukavangeya Muna Muntu!” ");
INSERT INTO nkn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Joleleni omo eci cilingiua, kineni na kujolela, omuo Njambi namivuahesela cikandelela ceni cakama muilu. Omuo vakuluntu vavo valingile ngacije kuli tunanguizi va Njambi va Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Vuno honi tuyando kuli yeni munafuku laja, omuo muatambula laja kuyoya kuacili!” ");
INSERT INTO nkn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tuyando tueni yeni munakuta vuavuno, omuo mukaziva njala!” “Tuyando tueni yeni muli nakujolela, omuo muka pihilila na kulila! ");
INSERT INTO nkn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tuyando tueni omuo vantu voshe vali nakumishangazala, omuo vakuluntu vavo valingile ngacije kuli tunanguizi va Njambi va makuli. ");
INSERT INTO nkn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Vuno honi njimileka yeni vaka kunjitolilila nguange, zangeni vitozi veni, lingeni muacili kuli vaje vamizinda, ");
INSERT INTO nkn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","vezikiseni vaje vamisinga, kaha lombeleleni vaje vali nakumiyandesa. ");
INSERT INTO nkn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nga muntu akupupa ku litama limo, kaha mutenguluile akupupe ku litama likuavo naua, nga muntu akunieka kazaku kove, muhane naua na cikovelo cove. ");
INSERT INTO nkn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Muntu uje amilomba muhaneni cuma cije canamilombo, omo muntu ambata cuma cove, kaha keti ucihule naua. ");
INSERT INTO nkn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Viuma vioshe vimutonda ngeci vakueni vamilingilevio, mukemuo vene, neni naua valingilenavio. ");
INSERT INTO nkn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nga muzanga lika vaje vamizanga, vikahoni mutambuila vishangalo? Cipue vaka vipi vakazanga vaka kuvazanga! ");
INSERT INTO nkn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nga mulinga lika muacili kuli vaje vakamilingi muacili, vikahoni mutambuila vishangalo? Cipue vaka vupi mukemuo muvakalingi! ");
INSERT INTO nkn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nga mukumuisa lika vaje muavandamena ngueni vamihiluisila, vikahoni mutambuila vishangalo? Cipue vaka vupi naua vakalikumuisa, linga vatambule ngue muje muvanahana. ");
INSERT INTO nkn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Vuno honi zangeni vitozi veni, kaha lingeni muacili kuli vakevo, vakumuiseni vuno honi keti muvandamene ngueni mukavitambula naua. Kaha cikandelela ceni cikapua cakama, mukapua vana va Njambi ua Helu lia Helu. Omuo ikeye akevuila ngozi vaje kuvekumukandelela na vaje vaka vupi. ");
INSERT INTO nkn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pueni vaka cikeketima ngue Ishueni uapua muka cikeketima. ");
INSERT INTO nkn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Keti muhise, kuteua neni vakamihisa, keti mupaye, kuteua neni vakamipaya, sambeseni, kaha neni vakamisambesa. ");
INSERT INTO nkn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Haneni, kaha neni vakamihana. Cikapua nge muka kulandesa uje akuhana seteko ya vinona, akaizindangeya nakui niekumuna kaha akashulilisaho cikuma noho ishulisa muvimbango via cisetekelo na kumuanianga kaha honi akakuhanavio vioshe. Seteko ije museteka nayo vakueni, ikeyo naua vakamiseteka nayo.” ");
INSERT INTO nkn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kaha Yesu uavatelele cisimo eci nguendi, “Kapuputua umo kasa kutuamenena kapuputua mukuavo, nga alingamo voshe vavali vakauila mucina. ");
INSERT INTO nkn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kukuesi ndongisi atuvakana mulongisi uendi vuno honi ndongisi uoshe, omo namanesa kulilongesa cendi, ikeye naua akapua hamo na mulongisi uendi. ");
INSERT INTO nkn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Vikahoni umona kacishoni kali ha lisho lia mukueni, vuno honi ku uyongola mukambo uli mulisho liove? ");
INSERT INTO nkn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vatihoni uhandeka na mukueni nguove, ‘Mukuetu, teua njikuhumise kacishoni kali ha lisho liove,’ omo yove uli na mukambo mu lisho liove? Ove muka civembulu! Ha kulivanga humisa mukambo uli mu lisho liove, kaha umone muacili hakuhumisa kacishoni kali ha lisho lia mukueni. ");
INSERT INTO nkn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Muti uacili kuuasa kuima vushuka vuavupi, cipue muti uaupi kuuasa kuima vushuka vuacili. ");
INSERT INTO nkn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Muti uoshe vauzivukila ku vushuka vuauo, omuo kuuasa kuhela vushuka vua mukuyu na mikolovozi ya viniu ku muti ua mambimbo. ");
INSERT INTO nkn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muntu uacili ikeye muka kusholola viuma via viacili via ku mutima uendi, muntu ua mupi akasholola viuma viavipi via ku mutima uendi omuo kanua kakahandeka vije viashula mu mutima. ");
INSERT INTO nkn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Vika munjitumbuila ngueni, ‘Muene, Muene’, vuno honi kumulingi vinjimileka? ");
INSERT INTO nkn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Njimileka cifua cendi uoshe uje eja kuli yange na kuvuilila mezi ange na kuuononoka. ");
INSERT INTO nkn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Napu ngue yala uakutungila njivo yendi, uahindile nakulovesa luvula ha livue. Livazi liezile liapupile kuje ku njivo, vuno honi kuyaningangele, omuo luvula luaije njivo luakele ha livue. ");
INSERT INTO nkn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Vuno honi uoshe aziva mezi ange kuakuhona kuuononoka napu ngue yala uatungile njivo yendi kuakuhona kuhinda luvula. Omo livazi liapupile kuje ku njivo, kaha yasiukile hajevene, kuua kuayo kuapuile kuakupi cikuma!” ");
INSERT INTO nkn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Omo Yesu uamanesele kuhandeka viuma vioshe evi ku vantu, kaha uaile ku Kapenama. ");
INSERT INTO nkn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mu mbonge ije muakele mukuluntu ua masualale va Loma uje uakele na ngamba yendi uaseho cikuma kuli ikeye. Uje muntu uavavalele uatondele kutsa. ");
INSERT INTO nkn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Omo uje mukuluntu uovuile lutsimo lua Yesu, uatumine vamo vakuluntu va Vayunda kuli ikeye nakumulomba eje mukukanguisa ngamba yendi. ");
INSERT INTO nkn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Vezile kuli Yesu vamulambelelele cikuma nguavo, “Ou yala napande kumukuasa. ");
INSERT INTO nkn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ikeye uazanga vantu vetu, naua uatutungilile njivo ya malombelo yetu.” ");
INSERT INTO nkn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu uaile navo, vuno honi omo uahete kuyehi na njivo, uje mukuluntu ua masualale uatumine vavusamba vendi kuli Yesu nakumuleka nguavo, “Muene, keti ukaluuise mutima uove omuo kucanjipandele yove ukakovele mu njivo yange. ");
INSERT INTO nkn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngecivene nange naua kucanjipandele kuheta kuli yove. Handeka lika lizi, kaha ngamba yange akakanguka. ");
INSERT INTO nkn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Njitantekeye eci omuo nange njili muitsi lia nzili yakama, na masualale vali muitsi liange, njishika umo nguange, ‘Ya!’ kaha aya, kaha naua njishika mukuavo nguange, ‘Ija!’ kaha eja. Njihandeka kuli ngamba yange nguange, ‘Linga evi!’ kaha acilinga.” ");
INSERT INTO nkn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ualikomokelele omo uovuile evi, kaha uatengulukilile kuli cije civunga camukavele, uahandekele nguendi, “Njimileka nguange, nakumo kuahi kunjinauana lutsilieloliakama ngue eli, cipue mu Isaleli luahimo.” ");
INSERT INTO nkn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Omo vaje vamala vavatumine vahilukile ku njivo ya uje mukuluntu vaka uanene uje ngamba nakanguka. ");
INSERT INTO nkn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Munima yevi Yesu uaile ku mbonge ya Naine, vandongisi vendi na civunga cakama vamukavele. ");
INSERT INTO nkn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Omo ikeye uahete kuyehi na cikolo ca mbonge, kaha vantu vatuhuile civimbi ha mbanza, uje yala uatsile uapuile muana umolika uaumo ntuluue, kaha civunga cakama cahumine muje mu limbo cakele hamo nauje ntuluue. ");
INSERT INTO nkn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Omo Muene Yesu uamumuene, kaha uamuivuilile cikeketima, kaha uahandekele kuli ikeye nguendi, “Keti ulile.” ");
INSERT INTO nkn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ambahoni Yesu uaile uakakuate ku citala tala, kaha vaje tufunde vemanene. Yesu uahandekele nguendi, “Ove kankalava, njikuleka nguange, hinduka!” ");
INSERT INTO nkn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kaha uje yala uatsile uasangukile uatumamene na kuputuka kuhandeka, kaha Yesu uamuhanene kuli vaina. ");
INSERT INTO nkn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vantu voshe vovuile liova, kaha vashangazalele Njambi, vahandekele nguavo, “Kananguizi ua Njambi uakama neja kuli yetu na Njambi neja nakuovola vantu vendi!” ");
INSERT INTO nkn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kaha lutsimo olu lua Yesu luashandokelele mu Yundeya muoshe na ku vinganda vioshe via kulihata. ");
INSERT INTO nkn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Omo vandongisi va Iuano vamulekele viuma vioshe evi, kaha uasaneneko vandongisi vendi vavali. ");
INSERT INTO nkn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Uavatumine kuli Muene Yesu nakumuihula nguavo, “Yove vene uija? Indi tuvandameneko ueka naua.” ");
INSERT INTO nkn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Omo vamala vezile kuli Yesu vahandekele nguavo, “Iuano muka kumbuitika natutumu kuli yove nakuihula nga yove uje eja indi tucivandameneko ueka naua.” ");
INSERT INTO nkn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ha ntsimbu ijevene Yesu uakanguisile vantu vavengi ku kuvavala kuavo, naku mishongo yavo nakuhumisa mahamba na kumuesa tupuputua vavengi. ");
INSERT INTO nkn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaha uatavele vandongisi va Iuano nguendi, “Yemuye mukahandeke kuli Iuano vimunamono nevi vimunevu. Tupuputua vamona, vilema venda, vaka mbumba vanalele, tusinda matuitui vaziva, vatsi vasanguka, kaha muzimbu uacili vauambulula kuli tuhutu. ");
INSERT INTO nkn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vanavezika vaje kuvakecela lutsilielo luavo muli yange.” ");
INSERT INTO nkn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Omo vandongisi va Iuano vahilukile, kaha Yesu ualekele cije civunga hali Iuano nguendi, “Omo muaile kuli Iuano mu mpambo muatondele kukamona muntu ua vati? Indi muaile mukumona yala uakufua ngue vishoni via laha viakutepuzoka na mpunzi? ");
INSERT INTO nkn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Muaile nakumona vika honi? Muntu nazala vuzalo vuasenga ndi? Vantu vakakuzala muacili na kukala muasenga vakakala mu mihela ya muene. ");
INSERT INTO nkn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Njilekeni muatondele kukamona vikahoni? Muatondele kukamona kananguizi ua Njambi ndi? Eyo, ikeye vene naua ikeye kananguizi ua Njambi uakama. ");
INSERT INTO nkn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ou ikeye Iuano uje visoneka vihandeka nguavio, ‘Njikatuma kanganda kange kulutue luove. Akavuahesa ngila yove.’ ");
INSERT INTO nkn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Njimileka nguange, ku vantu voshe vaje vanakeleko, naumo uahi napulaka Iuano. Vuno honi uje uamundende kumaneselela mu vumuene vua Njambi ikeye napulakana Iuano.” ");
INSERT INTO nkn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Vantu voshe hamo na vaka kutambula lisimo vononokele vusunga vua Njambi, kaha vavambuitikile kuli Iuano. ");
INSERT INTO nkn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vuno honi Vafaliseo na valongisi va Mashiko a Mosesa vavianene vilinga via Njambi hali vakevo, mukemo kuva vambuitikile kuli Iuano. ");
INSERT INTO nkn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu uahandekele nguendi, “Kuliveya njasa kusetekesa vantu va matangua ano? Vanapu ngue vika? ");
INSERT INTO nkn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vakevo vanapu ngue vanike vanatumama kumuhela uakulandesela viuma, kaha valitambakana umo na mukuavo, ‘Tunamimbilile miaso ya vushombolua, vuno honi kumuakinine! Tuamimbilile miaso ya vusiua vuno honi kumua lilile!’ ");
INSERT INTO nkn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Omo Iuano muka kumbuitika uezile, kalile mbolo cipue kunua viniu, kaha muahandekele ngueni, ‘Ali na mahamba!’ ");
INSERT INTO nkn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kaha omo Muna Muntu uezile, ikeye ualile nakunua, kaha muahandekele ngueni, ‘Taleni ou yala! Uapua mukamutupu na kupenda, kaha kavusamba ua vaka kutambula lisimu na vaka vupi!’ ");
INSERT INTO nkn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngoco vene mana vana amuesa kupua acili kuvuyoye vua vaje vauakava.” ");
INSERT INTO nkn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Litangua limo umo ua Vafaliseo ualizanga lia Simon ualaniene Yesu kulia nendi, kaha uakovelele mu njivo Yakafaliseo nakutumama ku mesa. ");
INSERT INTO nkn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kuakele mpuevo ua mu mbonge ije, uapuile muka vupi. Omo uovuile nguendi Yesu hali na kulia mu njivo ya Kafaliseo, uanehele kantsazi kacili ka mazi aluengo luacili. ");
INSERT INTO nkn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kaha uemanene kunima ya viliato via Yesu, na kulila kaha uaputukile kujulisa viliato via Yesu na misozi yendi, kaha uavihundile navi nkambu viendi naku tsuemba ku viliato viendi, kaha uamuitilile mazi kumikono. ");
INSERT INTO nkn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Omo Kafaliseo uje uamusanene uamuene eci, uahandekele kuli ikeye vavenia nguendi, “Nga ou yala uapuile kananguizi, nge natantekeya nacifua muka cou mpuevo na mukuata. Nge natantekeya nguendi uapua muka vupi.” ");
INSERT INTO nkn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu uamulekele nguendi, “njili na cuma cimo njitonda kukuleka.” Kaha uatavele nguendi, “Cikahoni Mulongisi?” ");
INSERT INTO nkn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu uamutililile nguendi, “Kuakele vamala vavali vakumuine vimbongo kuli muka kukumuisa. Umo uakumuine vimbongo via Siliva viakupua vihita vitanu, mukuavo naua uakumuine vimbongo via Siliva makumi atanu. ");
INSERT INTO nkn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Omo vahonouele kuvihiluisa, uava konekelele voshe vavali. Hakati kavo iya uje akamuzanga cikuma?” ");
INSERT INTO nkn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni uamukumbuluile nguendi, “Njasinganieka nguange uje yakonekelele cikuma.” Kaha Yesu uahandekele kuli ikeye nguendi, “Una yulu muacili.” ");
INSERT INTO nkn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tala ou mpuevo, kaha lisikanieke yove vavenia. Kaha uatengulukilile kuli mpuevo na kuhandekele kuli Simoni nguendi, “Uamumono ou mpuevo? Njakovelele mu njivo yove, kuuanjihanene mema akutana ku viliato viange, vuno honi najulisa viliato viange na misozi yendi na kunjihunda na vinkambu viendi. ");
INSERT INTO nkn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Unahonouele cipue kunjitsuemba, vuno honi kuhuma ntsimbu njakovelele muno mu njivo yove kecelele kutsuemba viliato viange. ");
INSERT INTO nkn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kuuanjitambuile mukunjitila mazi ku mutue uange, vuno honi ikeye nanjitila mazi aluengo kuviliato viange. ");
INSERT INTO nkn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Njimileka, vanamukonekela vupi vuavuingi mukemo uakala nacizangango cikuma, vuno honi uje vanakonekela muvundende, uazanga via vindende.” ");
INSERT INTO nkn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kaha Yesu uahandekele kuli uje mpuevo nguendi, “Vipi vuove vana vanavikonekela.” ");
INSERT INTO nkn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kaha vaje vakele nendi ku mesa vaputukile kusinganieka nguavo, “Iya ou, asa kukonekela vipi?” ");
INSERT INTO nkn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kaha uahandekele kuli mpuevo nguendi, “Lutsilielo luove lua kusambuesa. Ya mu ciyulo.” ");
INSERT INTO nkn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hanima yevi, Yesu uakele nakuendangana mu vimbonge na mu membo, nakuambulula muzimbu uacili ua vumuene vua Njambi. Vavandongisi vendi likumi na vavali vaile hamo ");
INSERT INTO nkn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Navampuevo vamo vaile hamo nendi. Yesu uahumisile mahamba muli vakevo na kuvakanguisa ku mishongo yavo. Umo uavo uapuile Maliya mangandalena muli ikeye uahumisile mahamba atanu na avali. ");
INSERT INTO nkn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mukuavo uapuile Njuana mpuevo ya Kuza, mukuluntu uakulama vitenga via mu njivo ya Helonde, Mukuavo uapuile Susana na vakuavo vavengi. Ava vampuevo vakele nakukuasa Yesu na vandongisi vendi navukuasi vua vimbongo viavo. ");
INSERT INTO nkn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Litangua limo vantu vavengi vezile nakukunguluka amo. Vahumine kuvi mbonge via vingi via kuli sezaseza kua kuivuilila Yesu. Uavatelele cisimo eci: ");
INSERT INTO nkn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Muka kulima uaile na kukuna vimbuto viendi. Omo uakele nakukuna vimbuto viendi, imo yauililile kumukulo ua ngila kaha vantu valiatangeleleho na tuzila vailile. ");
INSERT INTO nkn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imo yauililile ha mavue kaha omo yamenene, yomine omuo kuya uanene mema. ");
INSERT INTO nkn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imo ya vimbuto yauililile ha mingonga, ha kukola kuayo vaituvile ku mingonga. ");
INSERT INTO nkn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Vikuavo vimbuto via uililile ha mavu a vuilo, mbuto imo lika ya tuihuile cihita cavimbuto. Kaha Yesu uamanesele kuhandeka nguendi, “Uje uoshe hali na matuitui, azive!” ");
INSERT INTO nkn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vandongisi va Yesu Kilistu vamuihuile nguavo, Yesu, eci cisimo cilumbununa vika? ");
INSERT INTO nkn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Uavakumbuluile nguendi, “Njambi namihangula linga mutantekeye vushueka vua vumuene vuendi, vuno honi kuli vamo njihandeka mu visimo linga, ‘Cipue vamona, vuno honi kuvamonesesa, cipue vovua vuno honi kuvovuisisa.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Eci cikeco cilumbununa ca cisimo: mbuto ikeyo lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vimbuto vije via uililile kumukulo ua ngila vili ngue vantu vevua lizi lia Njambi. Kaha satana eja na kuambata lizi mu mitima yavo, linga keti vakulahele na kuyoyesiua. ");
INSERT INTO nkn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Vimbuto viauililile ha mavu a mavue vinapu ngue vantu vaje vatambula lizi nakuvuahelelela omo valivua, vuno honi kuvesi na mizi. Ha ntsimbu ya vieseko vahilukila munima. ");
INSERT INTO nkn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Vimbuto viauililile ha mingonga vinapu ngue vantu vaje vevua lizi lia Njambi, vuno honi kulinienga, vufuko na senga via vuyoye via vatuvile. Kaha kuviakolele na kuima vushuka. ");
INSERT INTO nkn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Vuno honi vimbuto vije via uililile ha mavu acili vinapu ngue vantu vacili vaje vali na mitima yacili, vovua lizi lia Njambi na kuliniunga na kukolesa ngo noho vema vushuka. ");
INSERT INTO nkn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Naumo uahi a shuameka ndeya na kuishueka muintsi lia liendeko cipue kuyaka muintsi lia muhela. Vuno honi vaihaka helu lia citumbiko linga uoshe akovela amone ceke. ");
INSERT INTO nkn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vioshe vije vanashueke hano vikajomboloka na vioshe vije via kushueka hano vakavitantekeya, na kuvineha ha ceke. ");
INSERT INTO nkn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mukemo muapande kuivuilila muacili kuvilongesa viange. Vaje vali navimo vakatambula viavingi vuno honi voshe kuvesi nacimo vakavanieka cipue vije viavindende vivasinganieka nguavo valinavio.” ");
INSERT INTO nkn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kaha vaina ya Yesu na vamuanaye vezile kuli ikeye na kumumona, vuno honi vahonouele kushuena kuli ikeye omuo ya vantu vuingi. ");
INSERT INTO nkn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Umo ua vantu vaje vakele kuje uamulekele nguendi, “Vanoko na vamuanoko vanemana hambanza, vatonda ku kumona.” ");
INSERT INTO nkn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu uamukumbuluile nguendi, “Vanana na vamuanetu vaje vaziva mezi a Njambi na kuakavangeya.” ");
INSERT INTO nkn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Litangua limo Yesu uakovelele mu vuato na vandongisi vendi kaha uahandekele nguendi, “Tuyeni musinia lia cisali.” Kaha vaputukile kuya. ");
INSERT INTO nkn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Omo vakele nakujavuka Yesu uaile mutulo. Linkimba liaputukile mu cisali, ngeci na vuato vuaputukile kushula na mema, kaha vakele muvukalu. ");
INSERT INTO nkn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Vandongisi vaile nakumuhindula, nguavo, “Muene, Muene, tuli nakunonga!” Uahindukile kaha uashikile mpunzi na mankimba, kaha vioshe vialikelele na kuholoka. ");
INSERT INTO nkn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Uavehuile nguendi, “Lutsilielo lueni luli kuli?” Mu liova na mukukomoka valihuezele umo na mukuavo nguavo, “Iya ou? Ashika mpunzi na mema, kaha vimuononoka.” ");
INSERT INTO nkn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na vandongisi viendi vajavukilile ku cihela kuje vantu va Ngalasene vakele nakuyoya, cije cakele musinia lia cisali kuhuma ku Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Omo Yesu uahete ha ntunda, uali uanene na yala uje uakele na lihamba uamuje mbonge. Ntsimbu yailaha ou yala kakele nakuzala vuzalo cipue kukala hembo, vuno honi uakele nakukala lika ku vihilo. ");
INSERT INTO nkn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Omo uamuene Yesu ualilile cikuma na kuuila ku mikono yendi, kaha uatambakanene nguendi, “Utonda kulinga vika kuli yange, Yesu Muna Njambi Uakuhiana? Njikulomba keti unjiyandese!” ");
INSERT INTO nkn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Uje yala uahandekele evi omuo Yesu uahandekele kuli lije lihamba linga lihume muli uje yala. Vintsimbu viavingi viakele nakumuyandesa. Vantu vakele na kumukuta na malienge ku mavoko na ku mikono naku muniunga, vuno honi uakele nakuvatula kaha lihamba liakele nakumutuala mu musenge. ");
INSERT INTO nkn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu uamuihuile nguendi, “Lizina liove yove iya?” Kaha uamukumbuluile nguendi, “Tuvavengi,” omuo mahamba vavengi vakovelele muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kaha mahamba vamulombele kushuakumo nguavo keti avatuale mu cina ca kuhona cimbaluila. ");
INSERT INTO nkn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kuakele vangulu vavengi vakele na kulia kumukulo ua munkinda. Kaha mahamba valombele Yesu nguavio vika kovele muli vaje vangulu, kaha uavitavesele. ");
INSERT INTO nkn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Omo mahamba ahumine muli uje yala, aile muli vaje vangulu, kaha vaje vangulu vahumine ha munkinda vashatukilile mu cisali na kunonga. ");
INSERT INTO nkn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Omo vaje vaka kuniunga vangulu vamuene vije vialingiuile, vashatukile naku kambulula mu mbonge na mu membo akulihata. ");
INSERT INTO nkn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kaha vantu vaile na kumona ovio vialingiuile. Omo vahete kuli Yesu, vamuene uje yala yahumisile mahamba natumama ku viliato via Yesu, nazala na visinganieka viendi viakele muacili, kaha vateuele. ");
INSERT INTO nkn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vaje va vimuene valekele vantu muje uje yala uakele na mahamba muamu kanguisile. ");
INSERT INTO nkn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kaha vantu voshe vamu mbonge ya Ngalasa na vakumihela yakulihata valombele Yesu nguavo, ahume kuli vakevo omuo vateuele cikuma. Kaha Yesu uakovelele mu vuato na kulivuahesela linga aye. ");
INSERT INTO nkn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Uje yala ya humisile mahamba ualombele Yesu nguendi, “Njikukave!” Vuno honi Yesu uavianene ua handekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hiluka kuimbo ukavaleke viakama viana kulingila Njambi.” Kaha uje yala uaile na kuleka vantu mu mbonge vije Yesu namu lingilavio. ");
INSERT INTO nkn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Omo Yesu uahilukile ku Ngalileya, vantu vavengi vamutambuile, omuo voshe vakele naku muvandamena. ");
INSERT INTO nkn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kaha yala umo uezile kuli Yesu. Lizina liendi Njailusi mukuluntu ua njivo ya malombelo. Uauile ku viliato via Yesu na kumulomba nguendi, aye ku njivo yendi, ");
INSERT INTO nkn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","omuo munendi umo lika ua miaka likumi na ivali, uatondele kutsa. Yesu uaile hamo nendi. Omo vakele nakuya civunga ca vantu vakele nakusindakana Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mu civunga cije vene muakele mpuevo uakele na mushongo uakuhita maninga ha miaka likumi na ivali vuno honi naumo uahi uamukanguisile. ");
INSERT INTO nkn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uezile munima ya Yesu kaha uakuate ku mukunduilo ua vuzalo vuendi, kaha hajevene kuhita maninga kuemanene. ");
INSERT INTO nkn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu uehuile nguendi, “Iya nanjikuata?” Omo voshe vavianene Petulu uahandekele nguendi, “Muene vantu va kuzengeleka kaha naua vakusindakana.” ");
INSERT INTO nkn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Vuno honi Yesu uahandekele nguendi, “Umo nanjikuata, omuo njatantekeya nguange nzili yahumu muli Yange.” ");
INSERT INTO nkn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kaha uje mpuevo ha kumona nge vanamutantekeya. Uezile nakujaja na kuuila ku viliato via Yesu. Kaha ku mesho a civunga ca vantu uahandekele omuo vika uakuatele Yesu nomu muana kangukila mu vuasi. ");
INSERT INTO nkn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kaha Yesu uahandekele kuli ikeye nguendi, “Munange, lutsilielo luove lua Kukuangisa. Ya na ciyulo.” ");
INSERT INTO nkn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tele Yesu uakele nakuhandeka, umo uezile kuhuma ku njivo ya Njailusi, Uahandekele nguendi, “Munove ua mpuevo natsi keti uyandese mulongisi naua.” ");
INSERT INTO nkn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ha kuivua eci, Yesu uahandekele kuli Njailusi nguendi, “keti uzive liova, kulahela lika, akayoya naua.” ");
INSERT INTO nkn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Omo Yesu uahete ku njivo ya Njailusi, katavesele muntu kukovela nendi kuvanga Petulu, na luano, na Yakomba, na vaishe na vaina vauje mumbanda. ");
INSERT INTO nkn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ha ntsimbu ije, vantu voshe vakele nakulinienga na kulila. Kaha Yesu uahandekele nguendi, “Eceleni kulila, katsile vuno honi nakosa tulo.” ");
INSERT INTO nkn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Vamujolele, omuo vatantekeyele nguavo natsi. ");
INSERT INTO nkn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kaha Yesu uaile kuje kumuhela kuakele uje mumbanda kaha uamukuate ku livoko na kumusana nguendi, “Kanike, hinduka!” ");
INSERT INTO nkn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Muono uendi uahilukile kaha ha ntsimbu ijevene uemanene. Kaha Yesu ualekele visemi linga vamuhane viakulia alie. ");
INSERT INTO nkn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Visemi vendi vali komokelele, kaha Yesu uavashikile keti valeke cipue umo via lingiuile. ");
INSERT INTO nkn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu uasanene vandongisi likumi na vavali veje kuli ikeye, kaha uavahanene nzili yakama ya kuhumisa mahamba voshe na kukanguisa mishongo. ");
INSERT INTO nkn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kaha uavatumine kuya na kuambulula Vumuene vua Njambi na kukanguisa vaka kuvavala. ");
INSERT INTO nkn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Uavalekele nguendi, “Keti muambate cuma cimo ha vungenzi vueni, cipue mbueti, cipue cola, cipue viakulia, cipue vimbongo, cipue vikovelo vivali. ");
INSERT INTO nkn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kuoshe kuje kuvaka mitambula muacili, tumameni ku njivo ijevene noho mukahuma mu mbonge ije. ");
INSERT INTO nkn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kuoshe kuje vaka viana kumitambula, kaha humeni mu mbonge ije, kaha totomoneni likungu ku viliato vieni. Eci cikapua cinangulo ku vantu vamuje mu mbonge nge Njambi akavasompesa.” ");
INSERT INTO nkn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kaha vandongisi vaile, vaihitanganene mu membo oshe na kuambulula Muzimbu Uacili na kukanguisa vantu uoshe. ");
INSERT INTO nkn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Omo Helonde, muka kusuana mu Ngalileya, uovuile viuma vioshe vialingiuile, kaha uakele na citanga, omuo vantu vamo vakele nakuhandeka nguavo, “Iuano muka kumbuitika nasanguka ku vatsi.” ");
INSERT INTO nkn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kaha vamo nguavo, kananguizi ua Njambi Eliya nasholoka, vamo nguavo, “Umo ua tunanguizi va Njambi veka va Njambi valaja nasanguka naua.” ");
INSERT INTO nkn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaha Helonde uahandekele nguendi, “Iuano njamutapele mutue, vuno honi iya honi ou yala injili nakuvua viendi?” Kaha uatondele cikuma kumumona Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tunganda va Yesu vahilukile vamulekele vioshe vije vivalingile. Kaha uaile hamo navo uavatualele kualikaliavo lika ku mbonge ivatumbuile Mbetesainda. ");
INSERT INTO nkn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Omo civunga ca vantu vovuile evi, kaha vamukavele. Uavatambuile na kuvalongesa via Vumuene vua Njambi na kukanguisa vaje vakele nakuvavala. ");
INSERT INTO nkn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Omo kuapuile cinguezi, vandongisi vaje likumi na vavali vezile kuli ikeye vahandekele nguavo, “Shandola vivunga evi linga vaye ku membo na ku mehia aua amuyehi vaka liuaneneko viakulia vakevo vavenia noku kuakukosa, omuo muno munapu mu musenge uangoco.” ");
INSERT INTO nkn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Vuno honi Yesu uahandekele kuli vakevo nguendi, “Yeni vene vahaneni viakulia linga valie.” Kaha vamukumbuluile nguavo, “Kutuesi na viakulia vieka kuvanga vimbolo vitanu na vatsi vavali. Nkuma yove utonda tuye na kulanda viakulia via civunga coshe eci ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kuakele vamala vakupua makulukazi atanu kuakuhona vampuevo na vanike kuje. Yesu uahandekele kuli vandongisi vendi nguendi, “Lekeni vantu vatumame ha mavu mu vimunga, munga na munga mukale vantu makumi atanu.” ");
INSERT INTO nkn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Vandongisi valingile ngacije na vantu voshe vatumamene ha mavu. ");
INSERT INTO nkn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kaha Yesu uatambuile vije vimbolo vitanu na vatsi vavali, uatalele muilu, kaha uatsatselele kuli Njambi, kaha uavipazuile, uavihanene kuli vandongisi vendi linga vavipangezele vivunga via vantu. ");
INSERT INTO nkn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Voshe valile, vakutile, kaha vandongisi vakunguluile vimbazuvuila vije viasaleleho, vashulisile mitonga likumi na ivali. ");
INSERT INTO nkn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Litangua limo omo Yesu uakele nakulombela kualikaliendi lika, vandongisi vendi vakele kuyehi nendi. Kaha uavehuile nguendi, “Vantu vali nakunjitumbula nguavo yange iya?” ");
INSERT INTO nkn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Vamukumbuluile nguavo, “Vamo vali nakuhandeka nguavo yove Iuano Muka kumbuitika, veka naua nguavo yove Eliya, vakuavo naua nguavo yove umo ua tunanguizi va Njambi va Njambi valaja uje nasanguka.” ");
INSERT INTO nkn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kaha Yesu uavehuile nguendi, “Yeni honi munjitumbula ngueni yange iya?” Petulu uakumbuluileko nguendi, “Yove Kilistu ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ambahoni Yesu uavashikile nguendi keti valekeko muntu umo cuma eci. ");
INSERT INTO nkn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kaha uahandekele naua kuli vakevo nguendi, “Muna Muntu napande kuyanda cikuma, vakuluntu na vakuluntu va vasasendote, na valongisi va mezi a Lishiko lia Mosesa vaka muviana. Kaha vakamutuala ku kutsa, vuno honi munima ya matangua atatu, akasanguka.” ");
INSERT INTO nkn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kaha Yesu uahandekele naua kuli vantu voshe vaje vakele kuje nguendi, “Nga muntu atonda kunjikava, napande kuliviana ikeye vavenia, ambate cilindakano cendi ha litangua na litangua, kaha anjikavangeye. ");
INSERT INTO nkn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Omuo muntu uje uoshe atonda kuniunga muono uendi auzimbalesa, vuno honi muntu uje voshe azimbalesa muono uendi omuo lizina liange akauuana. ");
INSERT INTO nkn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nga muntu afuka mavu oshe, vuno honi alinongesa ikeye vavenia na kuzimbalesa muono uendi vika akauanaho? ");
INSERT INTO nkn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nga muntu anjuvuila shuamua na vilongesa viange, kaha Muna Muntu naua nendi akamiuvuila shuamua omo akeja mu vumpau vuendi na mu vumpau vua Ishe na mu vumpau vua tungelo vakulela. ");
INSERT INTO nkn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mua vusunga njimileka nguange, kuli vamo kuno, vaje kuvakatsi kuvanga vanamono Vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Munima ya matangua atanu na atatu omo uahandekele viuma evi, Yesu uaile hamo na Petulu, na Iuano, na Yakomba ku munkinda nakulombela. ");
INSERT INTO nkn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ntsimbu uakele nakulombela, cihanga cendi cahimbukile, kaha vuzalo vuendi vuatokele too ngue ceke. ");
INSERT INTO nkn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hajevene vamala vavali vasholokele vaputukile kuhandeka nendi, vapuile Mosesa na Eliya. ");
INSERT INTO nkn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Vakele mu misha ya muilu. Vakele nakuhandeka na Yesu ha kuija kua kutsa cendi mu Yelusalema muje muakashulisililamo vutumbe vua Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulu na vaje vakele navo vakele mu tulo, vuno honi omo vahindukile vamuene misha ya Yesu na vamala vavali vaje vemanene navo. ");
INSERT INTO nkn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Omo Mosesa na Eliya vatonde kuya, kaha Petulu uahandekele kuli Yesu nguendi, “Muene, cacili kuli yetu nga tukala kuno! Tutunga vintsingi vitatu, imo yove, imo ya Mosesa na imo ya Eliya.” Kazivukile vije viakele nakuhandeka. ");
INSERT INTO nkn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ntsimbu Petulu uakele nakuhandeka, lishelua liezile na kuvafuika, kaha vandongisi vazivile liova omo lishelua liavafuikile. ");
INSERT INTO nkn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kaha lizi liahumine mu lishelua liahandekele kuli vakevo ngualio, “Ou ikeye Munange injinahangula, muivuilileni!” ");
INSERT INTO nkn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Omo lizi liaholokele, Yesu uakele halikaliendi lika. Kaha vandongisi vaholokele kuluu ha viuma vioshe evi, kaha ha ntsimbu ije kuvalekeleko muntu umo viuma vije vivamuene. ");
INSERT INTO nkn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Omo kuacele Yesu na vandongisi vendi vatatu vashulukile ku munkinda, civunga cakama caliuanene na Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yala umo ua haje ha civunga uatambakanene nguendi, “Mulongisi, njikulomba tala munange, omuo ikeye lika umolika. ");
INSERT INTO nkn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Evi vikevio vikalingika lihamba nga limu uana, kaha atambeka na kushinia na kututumuna lifulu ku kanua, umuvetuesa cikuma kaha kuumuecela vuasi. ");
INSERT INTO nkn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Njalambelelele vandongisi vove nguange vamuhumise vuno honi kuvasele.” ");
INSERT INTO nkn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kaha Yesu uakumbuluile nguendi, “Yeni vaka kujeneka kutsiliela na vantu vaka vupi! Lungahi honi njikakala neni? Lungahi honi mukeseka kusimpa kuange?” Kaha uahandekele kuli uje yala nguendi, “Neha kuno munove.” ");
INSERT INTO nkn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Omo kanike uakele nakuija, kaha lihamba liamu uisilile ha mavu na kumushiniisa cikuma. Kaha Yesu uashikile lije lihamba, uje kanike ka yala uakangukile kaha uamuhanene kuli ishe. ");
INSERT INTO nkn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kaha vantu voshe vali komokelele ha nzili yakama ya Njambi. Tele vantu voshe vakele nakulikomokela ha vioshe vije Yesu uapangele, kaha uahandekele kuli vandongisi vendi nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ivuilileni keti musuve evi njimileka! Muna Muntu vuavuno amuhana ku nzili ya vantu.” ");
INSERT INTO nkn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Vuno honi vandongisi kuvatantekeyele mucalumbunukile cuma eci. Vavashuekelele linga keti vacitantekeye, vovuile liova liakumuihula vije viahandekele. ");
INSERT INTO nkn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kuaputukile vimpata hhakati ka vandongisi linga iya honi uakama kupulakana hhakati kavo. ");
INSERT INTO nkn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu uatantekeyele viyongola via mu mitima yavo, nankuma, uasanene kanike uamundende, uamuimikile kunionga yendi, ");
INSERT INTO nkn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kaha uahandekele kuli vakevo nguendi, “Uoshe atambula kanike ou mu lizina liange, kaha natambula yange vene, uoshe uje anjitambula, natambula naua uje uanjitumine. Omuo uoshe uje napu uamundende hhakati keni muvavoshe, ikeye napu uakama kupulakana.” ");
INSERT INTO nkn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iuano uahandekele nguendi, “Muene, tuamuene yala umo uakele nakuhumisa mahamba mu lizina liove, kaha tuamulekele linga alikele, omuo ikeye keti uamu munga yetu.” ");
INSERT INTO nkn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu uahandekele nguendi, “Keti mumuvindike, omuo uoshe uje kamiluisa ikeye hali hamo neni.” ");
INSERT INTO nkn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Omo matangua ashuenene kuyehi linga Yesu vamutuale muilu, uatenguluile viyongola viendi, nakuya ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Uatumine vamo va vandongisi vendi kulutue, kaha vaile na kukovela mu limbo lia muka Samaliya linga vaka muvuahesele vualumo kuakuhetela. ");
INSERT INTO nkn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vuno honi vantu vakele kuje kuva mutambuile, omuo vungenzi vuendi vuakele vuakuya ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Omo vandongisi vendi Yakomba na Iuano vamuene evi, vahandekele nguavo, “Muene, utonda linga tusane tuhia tua muilu tuije na kuvanongesa?” ");
INSERT INTO nkn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Vuno honi Yesu uatengulukile kuli vakevo na kuvavindika. ");
INSERT INTO nkn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kaha vaile ku limbo likuavo. ");
INSERT INTO nkn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Omo Yesu na vandongisi vendi vakele nakuya mu ngila, yala umo uahandekele kuli Yesu nguendi, “Njikakukava kuoshe kuuya.” ");
INSERT INTO nkn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu uahandekele kuli ikeye nguendi, “Vambanje vali na vina, na tuzila vali na mashua, vuno honi Muna Muntu kesi naha ha kusatela mutue uendi.” ");
INSERT INTO nkn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kaha Yesu uahandekele kuli yala mukuavo nguendi, “Njikave.” Vuno honi uje yala uahandekele nguendi, “Muene, ha kulivanga njitave njihiluke njikatsinde tahi tate.” ");
INSERT INTO nkn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu uamukumbuluile nguendi, “Seza vaka kutsa valitsinde vakevo vavenia. Yove ya na kuambulula via Vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yala mukuavo uahandekele nguendi, “Njikakukava Muene, vuno honi ha kulivanga njitave njiye njikasalese tahi vavushoko vuange.” ");
INSERT INTO nkn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu uahandekele kuli ikeye nguendi, “Nga umo naputuka kulima na vangombe kaha atala kunima vipangi viendi kuvikapu viaseho. Mucifua cimo vene nga umo anjikava kaha atenguluka kunima kuvipangi viendi vialaja kakapu uaseho kupanga vipangi mu Vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hanima yevi Muene Yesu uahanguile vandongisi makumi atanu na avali vakuavo. Kaha uavatumine kulutue luendi vavali na vavali vaye mu vimbonge namu vihela kuje vavenia uatondele kuya. ");
INSERT INTO nkn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tele kanda vaye uahandekele kuli vakevo nguendi, “Kuteja kuakama, vuno honi vaka kuteja vavandende. Kaha ihuleni Muene ua kuteja atume vaka kuteja mu lihia liendi. ");
INSERT INTO nkn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yeni! Njimituma kupua ngue vampanga mukati ka tungunga. ");
INSERT INTO nkn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Keti muambate vikuama cipue vingonga cipue vinkaku, kaha keti mumeneke muntu uoshe mu ngila. ");
INSERT INTO nkn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ntsimbu yoshe nga mukovela mu njivo, cakulivanga handekeni ngueni, ‘Ciyulo cikale mu njivo ino.’ ");
INSERT INTO nkn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nga muli muntu uayulo mu njivo ije, ciyulo ceni cikakala hali vakevo, nga keti ngoco kaha cikamihilukila. ");
INSERT INTO nkn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tumameni mu njivo ije, nueni na kulia vioshe vamihana, omuo muka kupanga napande kutambula fueto yendi. Keti muendangane ku njivo na njivo. ");
INSERT INTO nkn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nga mukovela mu mbonge na vantu vamo vamitambula, lieni vivana mivuahesela. ");
INSERT INTO nkn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kanguiseni vaka kuvavala valimo, kaha handekeni kuli vakevo ngueni, ‘Vumuene vua Njambi vuneja muyehi neni.’ ");
INSERT INTO nkn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Vuno honi nga mukovela mu mbonge ku vamitambula, kaha yeni mu vingila muhandeke ngueni, ");
INSERT INTO nkn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Cipue likungu lia mu mbonge yeni lili kumikono yetu tulitotomona linga limilemuise. Vuno honi tantekeyeni eci: Vumuene vua Njambi vuneja.’ ");
INSERT INTO nkn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Njimileka, ha litangua lia Cisompelo vukalu vua vantu vamu Sondoma vukapua nahongano kupulakana vantu vamu mbonge ije! ");
INSERT INTO nkn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Tuyando kuli yeni vantu vamu Kolazini! Tuyando kuli yeni naua vantu vamu Mbetesainda! Nga evi vikomoueso vivalingile mu vimbonge vieni, nge njavipangele mu vinganda via vaje keti Vayunda va mu Tile na Sindone vakevo vaje vantu nge vatengulukile laja ha kuzala vijeke naku likuita muto. ");
INSERT INTO nkn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ha litangua lia Cisompelo, vukalu vua vantu vamu Tile na Sindone vukapuako nahongano kupulakana vueni. ");
INSERT INTO nkn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yeni Vantu va mu Kapenama mutonda vaka mijundule kuheta na kuilu ndi? Houe, vaka mineha ha mavu nakuya mu Ngehena!” ");
INSERT INTO nkn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu ualekele vandongisi vendi nguendi, “Ou evuilila yeni novuilila yange, omuo ou aviana yeni naviana naua yange, kaha nou aviana yange naviana naua nauje ua njitumine.” ");
INSERT INTO nkn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vaje makumi atanu na avali vahilukile nakuvuahelela, na kuhandeka nguavo, “Muene mu lizina liove na mahamba a tuvuililile omo tuakele nakuuahumisa!” ");
INSERT INTO nkn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kaha Yesu uahandekele kuli vakevo nguendi, “Eyo! Njamuene Satana aua kuilu ngue muhiato. ");
INSERT INTO nkn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Taleni, njamihana nzili ya kuliata manoka na manieue, na nzili yoshe ya citozi, kaha na cimo cahi cika mivetuesa. ");
INSERT INTO nkn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cipue ngocovene, keti muvuahelele hali eci lika, ngueni na mahamba amivuililile, vuno honi vuaheleleni cikuma ngueni mazina eni vana asoneka muilu.” ");
INSERT INTO nkn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ha ntsimbu ijevene Yesu ua vuahelelele mu Cimbembesi ca Kulela kaha uahandekele nguendi, “Njikusatsela Tate, Muene ua muilu na mavu, omuo unashueka viuma evi ku vaka mana na vaka kuzangama kaha uavisholola ku vanike vavandende, cili Tate, eci cikeco ca kuvuaheselele naco. ");
INSERT INTO nkn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tate nanjihana viuma vioshe. Naumo uahi atantekeya Muana kuvanga Ishe cipue naumo uahi atantekeya Ishe kuvanga Muana. Na Muana akasholola Ishe kuli vaje vatonda.” ");
INSERT INTO nkn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kaha uatengulukile kuli vandongisi vendi na kuhandeka kuli vakevo ku mukulo nguendi, “Avezika aje mesho amona vije vimu mona! ");
INSERT INTO nkn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Njimileka nguange vavengi tunanguizi va Njambi va Njambi na vamiene vazangele kumona vimumona, vuno honi kuva vimuene, naua vatondele kuivua vimuli na kuivua, vuno honi kuva vivuile.” ");
INSERT INTO nkn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hajevene mulongisi ua mashiko uemanene kueseka Yesu nguendi, “Mulongisi,” “Njilinge vati njikakale na muono ua yaye?” ");
INSERT INTO nkn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu uamuihuile nguendi, “Vika vanasoneka mu Lishiko lia Mosesa? Vika ukatandamo?” ");
INSERT INTO nkn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uamukumbuluile nguendi, “Zanga Muene Njambi yove na mutima uove uoshe, na muono uove uoshe, na nzili yove yoshe, na visinganieka viove vioshe, kaha zanga mukueni ngue omo nalivanga yove vavenia.” ");
INSERT INTO nkn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kaha Yesu uahandekele kuli ikeye nguendi, “Uahandeka muacili, linga eci, kaha ukakala muono ua yaye.” ");
INSERT INTO nkn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Vuno honi uje mulongisi uatondele kulimuesa ikeye vavenia, uehuile Yesu nguendi, “Mukuetu ikeye iya?” ");
INSERT INTO nkn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu uamukumbuluile mu cisimo nguendi, “Litangua limo kuakele yala umo uahumine ku Yelusalema nakuya ku Yeliko, kaha ua liuanene na vezi. Vamuivilile vuzalo vuendi, na kumuveta na kuteua, na kumuseza na lezumuka. ");
INSERT INTO nkn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kaha capuile nge cakukasumuka, kasasendote uaile mu ngila ijevene, kaha omo uamuene ou yala, uamuongolokele kumukulo. ");
INSERT INTO nkn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na Kalevi naua omo uahete kucihela cije uamumuene nendi naua kaha uamuongolokele. ");
INSERT INTO nkn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kaha ka Samaliya umo uakele nakuhita mu ngila ije, omo uahete kucihela cije kuakosele uje yala kaha ua mumuene, kaha ua muivuilile cikeketima. ");
INSERT INTO nkn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uashuenene kuyehi na kumuzenga ha vimbandu, kaha uamuhakeleho mazi na viniu. Kaha uamuhakele ha Cimulu cendi na kumutuala ku njivo ya vangenzi, naku kamuniungilako. ");
INSERT INTO nkn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hakuca ca litangua uambate vimbongo viamu uayauaya vivali na kuhana muka kuniunga njivo ya vangenzi, kaha uahandekele kuli ikeye nguendi, ‘Umuniunge muacili,’ kaha omo njikahiluka nja kukufueta vioshe vije viulinakulikuasesa.” ");
INSERT INTO nkn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hanima yevi Yesu uehuile uje mulongisi ua mezi a mashiko a Mosesa nguendi, “Iya hhakati ka vantu ava vatatu uje uapuile ngue mukuavo ou yala, uje uauililile mu mavoko a vezi?” ");
INSERT INTO nkn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kaha uahandekele nguendi, “Uje uamumuesele ngozi.” Kaha hanima yevi Yesu uahandekele kuli ikeye nguendi, “Eyo, ya ukalinge ngoco.” ");
INSERT INTO nkn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Omo Yesu na vandongisi vendi vaile mu ngila, vahete hembo haje hakele mpuevo ua lizina lia Mata ikeye uamutambuile mu njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Uakele na munaina Maliya, ou ua tumamene ku viliato via Yesu na kuivuilila viakele na kuhandeka. ");
INSERT INTO nkn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Vuno honi Mata uakele nakulinga vipangi viavingi, kaha uezile kuli Yesu na kumuihula nguendi, “Muene, kuumono munanana na njecelela vipangi vioshe likaliange? Muleke anjikuaseko.” ");
INSERT INTO nkn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Vuno honi Yesu uamukumbuluile nguendi, “Mata, Mata, yove ua lijujukila na kunienguela vipangi viavingi. ");
INSERT INTO nkn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vuno honi cuma cimo citondeka. Maliya na hangula cuma cacili, oco ku cikahumisila kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Litangua limo Yesu uakele kumuhela umo na kulombela kuli Njambi. Omo uamanesele kulombela, umo ua vandongisi vendi uamuhandekesele nguendi, “Muene tulongese kulombela, ngue Iuano muka kumbuitika muana longeselele vandongisi vendi.” ");
INSERT INTO nkn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu uavalekele nguendi, “Omo mulombela kuli Njambi lombeleni ngueni, “Tatetu valemese lizina liove lia kulela vumuene vuove vuije. ");
INSERT INTO nkn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tuhaneni cakulia cije tutonda litangua na litangua. ");
INSERT INTO nkn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tukonekele ku vipi vuetu, omuo netu tukakonekela vantu vaka kutuvulumuina, keti ututuamenene muvieseko.” ");
INSERT INTO nkn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kaha uahandekele nguendi, “Singaniekeni nge uli na kavusamba kove kaha uyako mukati kavutsiki na kumuhandekesa na kumulomba nguove, ‘Kavusamba, njantsantela njilombako vimbolo vitatu lika, ");
INSERT INTO nkn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kavusamba kange neja muvungezi vua kunjimenekela kaha kujesi naviakulia viaku mujumbula!’ ");
INSERT INTO nkn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaha uje kavusamba kove oku hali mu njivo akutava, ‘Keti unjitanganese njapata laja ku njivo kaha yange na vana vange tuakoso laja, Kunjasa kuhinduka na kukuhana cimo naua.’ ");
INSERT INTO nkn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Njimileka nguange, cipue ngocovene kakahinduka na kukuhana viakulia omuo uapua kavusamba kove, vuno honi akahinduka na kukuhana vioshe vije viutonda omuo akaziva shuamua kuakuhona kukuhana. ");
INSERT INTO nkn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kaha njimileka nguange, lombeni, kaha vakamihana, tondeni kaha mukauana, toteni kaha vaka mishokoliela. ");
INSERT INTO nkn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Uoshe uje alomba akatambula, kaha uoshe uje atonda akauana, kaha kuli uje atota vaka mushokoluela. ");
INSERT INTO nkn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Iya ishe hhakati keni, nga munendi amulomba itsi, kaha ikeye amuhana linoka? ");
INSERT INTO nkn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Cipue nga amulomba mayaki amuhana linieue? ");
INSERT INTO nkn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nga yeni, vaka vupi mutantekeya kuhana viacili kuli vana veni, kaha honi Ishueni ua muilu akahanavene Cimbembesi ca Kulela kuli vaje vamulomba!” ");
INSERT INTO nkn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Litangua limo Yesu uakele nakuhumisa lihamba lije vialingikile muntu kupua kaveveve. Omo lije lihamba liahumine kaha uje yala uaputukile kuhandeka. Omo vantu vamuene evi valikomokelele. ");
INSERT INTO nkn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Vuno honi vamo vavo vahandekele nguavo, “Nahumisa lihamba mu nzili ya Mbelezembulu mukuluntu ua mahamba.” ");
INSERT INTO nkn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kaha vamo vatondele kumueseka, lingahoni vamulombele linga apange cikomoueso cije cimuesa nge Njambi ikeye namutumu. ");
INSERT INTO nkn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Vuno honi Yesu ua tantekeyele vili mu mitima yavo, kaha uahandekele kuli vakevo nguendi, “Nga vantu vavumuene vumo valiluisa hhakati kavo vumuene vuje vukahua. Nga vantu vanjivo imo valiluisa hhakati kavo kaha ije njivo ikaua. ");
INSERT INTO nkn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nga vumuene vua Satana vuli navimunga vililuisa vikevio vavenia, kaha vumuene vuendi vukakola vatihoni? Njinehula eci omuo yeni muhandeka ngueni, njikahumisa mahamba mu nzili ya Mbelezembulu. ");
INSERT INTO nkn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Honi nga njihumisa mahamba mu nzili ya Mbelezembulu, kaha vandongisi veni vaka likuasesa nzili yeya omo muvakahumisa mahamba? Eci cikeco vandongisi veni vaka mihisa. ");
INSERT INTO nkn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nga njihumisa mahamba mu nzili ya Njambi, kaha vumuene vua Njambi vuneja kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Omo nga yala ua nzili nalivuahesela laja vitua viendi aniunga njivo yendi, kaha vupite vuendi vuoshe vukaniungiua muacili. ");
INSERT INTO nkn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nga uje hali na nzili ya kupulakana eje nakuluisa mukuavo na kumuhiana kaha akambata vitua vioshe via uje via kulahelele. Kaha akalipangezela na vakuavo vije vioshe vianambata. ");
INSERT INTO nkn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kaha uoshe uje kesi kumutambela uange, muavusunga ikeye anjiluisa, kaha uoshe uje kakunguluka nange akashandola. ");
INSERT INTO nkn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Omo lihamba lihuma muli muntu, kaha liendakana mu mpambo kutalezeka muhela uakuhuimina. Nga kuliasa kuuana muhela kaha lilihandekesa likelio vavenia ngualio, ‘Njihiluka kuli muntu kuje njahumine.’ ");
INSERT INTO nkn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kaha omo lihiluka liuana muhela uje uakulela vanauhaka muacili. ");
INSERT INTO nkn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaha liya na kuneha vatanu na vavali mahamba veka vakupihia cikuma kupulakana likelio kaha vakovelamo na kukalamo. Kaha kupihia kua muntu uje kuakukotokela kupulakana kuje kua kuli vanga!” ");
INSERT INTO nkn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Omo Yesu uakele nakuhandeka vije, mpuevo umo uamuje mu civunga uje uakele nakuivuilila evi uatambakanene cikuma na kuhandeka nguendi, “Uakukuisula uje mpuevo uakusemene na kukulela!” ");
INSERT INTO nkn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Vuno honi Yesu uamukumbuluile nguendi, “Vakukuisula cikuma vaje vovua lizi lia Njambi naku likava!” ");
INSERT INTO nkn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Omo civunga ca vantu calivuezelelele, Yesu uahandekele nguendi, “Vantu vavapi va matangua ano vatonda lika cikomoueso vuno honi kuvacimono, kuvanga lika cikomoueso ca Yona. ");
INSERT INTO nkn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngue Yona uapuile cimueso ca vantu vamu Nanive, kaha Muna Muntu akapua cimueso ca vantu va matangua ano. ");
INSERT INTO nkn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Muene uampuevo uaku Sheva akemana nakuluisa vantu va matangua ano ha litangua lia cisompelo na kuvahisa. Uahuminine kulahako kuakuivua mana a Solomoni. Kaha honi taleni! Umo uakupulakana Solomoni hali kuno, vuno honi muviana kumuivuila. ");
INSERT INTO nkn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Vantu vaku Nanive vaka katuka nakuluisa vantu vamatangua ano ha litangua lia cisompelo naku vahisa. Vantu vaku Nanive vatengulukile ku vilinga viavo via vipi omo vovuile kuambulula kua Yona. Taleni honi! Uakama cikuma kupulakana Yona halikuno vuno honi muviana kumuvuilila! ");
INSERT INTO nkn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Naumo uahi asa kushuameka ndeya yendi naku ishueka cipue kuifuika na liendeko vuno honi ihaka haci tumbiko, kaha linga uoshe uje akovela mu njivo amone ceke. ");
INSERT INTO nkn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mesho ove akeuo ceke ca muvila uove. Nga mesho ove amona muacili kaha muvila uoshe ukashula na ceke, vuno honi nga mesho ove avavala kaha muvila uoshe ukapua na milima. ");
INSERT INTO nkn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaha tantekeya muacili nguove ceke cili muli yove keti cipue milima. ");
INSERT INTO nkn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nga muvila uove uoshe uashulu na ceke, kua kuhona kapenga kamilima, kaha ukashula na ceke ngue muje ndeya muikaneha misha hali yove.” ");
INSERT INTO nkn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Omo Yesu uamanesele kuhandeka, Kafaliseo umo uamulaniene linga akalie nendi. Kaha Yesu uakovelele na kutumama nakulia hamo nendi. ");
INSERT INTO nkn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kafaliseo ualikomokelele omo uamuene Yesu katanene ku mavoko endi mukulia. ");
INSERT INTO nkn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaha Yesu uahandekele kuli ikeye nguendi, “Taleni yeni Vafaliseo muka lelesa hambanza na lilonga helu, vuno honi mukati keni muashulu na lizangamena na vupi. ");
INSERT INTO nkn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yeni vilema! Kumutantekeya ngueni, Njambi uatangele helu lieni, ikeye naua uatangele mukati ndi? ");
INSERT INTO nkn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Haneni ku tuhutu muje mumuzivukila mu mitima yeni ngueni tunapande kuviana, kaha mukapua vakulela kuli Njambi cipue kuakuhona kutana ku mavoko eni. ");
INSERT INTO nkn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tuyando kuli yeni Vafaliseo! Yeni mukahana kuli Njambi camulikumi ha viuma mukatepesa kuvia kulia ngue minte, na luku, na visapa-sapa vikuavo, vuno honi kumuekulinga muacili vantu naua kumuazangele Njambi. Evi munapande kuvilinga kuakuhona kulikela kuli vije vikuavo. ");
INSERT INTO nkn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tuyando tueni, Vafaliseo! Yeni muazanga kutumama ha vituamo viacili mu vinjivo via malombelo, kaha muzanga vantu kumikandelela na kumihana kasingimiko mu mihela yakulandesela. ");
INSERT INTO nkn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tuyando tueni, omuo yeni muapua ngue vihilo vije viakuhona kumoneka. Vantu vakendeho nakupua vaka vupi kuakuhona kutantekeya.” ");
INSERT INTO nkn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kaha umo ua valongisi va mezi a mashiko a Mosesa uahandekele kuli Yesu nguendi, “Mulongisi, omo uli na kuhandeka evi, uli nakushaula yetu naua.” ");
INSERT INTO nkn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kaha uahandekele kuli vakevo nguendi, “Tuyando tueni, yeni naua valongisi va mezi a mashiko a Mosesa! Omuo mukatuika vantu vituika via kulema vuno honi yeni vavenia kumuekukakulako cipue na munie umo kukuasa vaje vajundula vije viteli. ");
INSERT INTO nkn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tuyando tueni, omuo mukavuahesa ha vihilo via tunanguizi va Njambi va Njambi vaje vavatsihile vakukuluila veni. ");
INSERT INTO nkn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nkuma yeni mulinavukaleho vuje mutava vije vivalingile vaje vakukuluila veni. Vatsihile tunanguizi va Njambi va Njambi na yeni muatungile vihilo viavo. ");
INSERT INTO nkn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaha cuma eci mana a Njambi ahandeka nguauo, ‘Njikavatumina tunanguizi va Njambi va Njambi na tunganda kaha vakatsihaho vamo vavo na vamo naua muka vayandesa cikuma.’ ");
INSERT INTO nkn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nkuma vantu va ntsimbu ino vaka vazangamesa ha kutsiha tunanguizi va Njambi va Njambi voshe hume hakutanga kua lifuti, ");
INSERT INTO nkn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","hume hakutsiha Avele nakuheta ha kutsiha Zakaliya uje vatsihilile mukati ka mutula ha Muhela Uakulela. Njimileka nguange, vantu va ntsimbu ino vaka vazangamesa voshe hali evi. ");
INSERT INTO nkn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tuyando tueni, valongisi va mezi a mashiko a Mosesa! Omuo munanieke vantu sapi yakushokoluesa ku cikolo ca mangana, vuno honi yeni vavenia kumue kukovelamo, cipue vaje veseka kukovelamo kumue kuvatavesa!” ");
INSERT INTO nkn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Omo Yesu uamanesele kuhandeka evi, uahumine kucihela kuje. Valongisi va mezi a Lishiko lia Mosesa na Vafaliseo vaputukile kumuluisa cikuma na kumuihula vihula viavingi vakumunienguesa. ");
INSERT INTO nkn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Vavandamenene indi nga ahandeka via vipi linga vamukuateho. ");
INSERT INTO nkn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ha ntsimbu ije vene vivunga viakama via vantu vavengi viakungulukile hamo, vapuile vavengi mukemuo vakele na kuliliatangela umo na mukuavo, Yesu uaputukile kuhandeka kuli vandongisi vendi nguendi, “Liniungeni ku cimbaluila ca Vafaliseo, cije cikeco civembulu cavo. ");
INSERT INTO nkn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Keti mupue ngue vakevo omuo nacimo cahi ca kufuika ku cikafukuliua, cipue ca kushueka kuci kajomboloka. ");
INSERT INTO nkn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Viunahandeka mu milima vaka viziva mu mutania, nevi uayevetela kumuhela vaka vihandeka hambanza.” ");
INSERT INTO nkn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Njimileka vavusamba keti muteue atsiha muvila kaha kuhumaho kasa naua kulinga cuma cimo. ");
INSERT INTO nkn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Vuno honi njimileka uje imunapande kuteua. Muteue uje nga namanesa kutsiha muvila, hanga hali na nzili yaku miumbila mu ngehena. Eyo, njimileka muteueni.” ");
INSERT INTO nkn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Singaniekeni tumpiasa, kutuesi naseho cipue tutanu vatulanda ha vimbingo vivali. Vuno honi naumo uahi uavo vakamusuva kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vuno honi cipue vinkambu viaku mutue uove vana vitanda. Keti muteue, muli naseho yakama cikuma kupulakana tumpiasa vavengi. ");
INSERT INTO nkn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Njimileka nguange uoshe uje ahandeka hacivunga nguendi uakundama kuli yange, na Muna Muntu naua aka muhandeka ku tungelo va Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Vuno honi uoshe uje anjiviana hakati ka civunga ca vantu, nange njikamuviana ku tungelo va Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Uoshe ashaula Muna Muntu vaka musambesa, vuno honi uoshe atuka Cimbembesi Uakulela ku vaka musambesa. ");
INSERT INTO nkn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Omo vakamituala mu vinjivo via malombelo kuli vaka kuyula na vaka nzili mukumieseka, keti mukalinienge mu mukaliluila yeni vavenia, kuli vimukahandeka na muje mu mukavakumbuiluila, ");
INSERT INTO nkn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","omuo Cimbembesi Uakulela cikamilongesa ha ntsimbu ije vimuapande kukahandeka.” ");
INSERT INTO nkn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muntu umo uakele muje mu civunga uehuile Yesu nguendi, “Mulongisi, leka muanetu linga tulipangele vitenga vije tate uatusezelelele.” ");
INSERT INTO nkn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Vuno honi Yesu uamukumbuluile nguendi, “Kavusamba, iya nanjihangula kupua muka kuyula cipue muka kuimanena hhakati keni?” ");
INSERT INTO nkn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaha uahandekele kuli vakevo nguendi, “Liniungeni! Zangameni ku miyati ya lizangamena lioshe: vuyoye vua muntu kuvuesi mu vufuko vuendi.” ");
INSERT INTO nkn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaha uavatelele cisimo eci nguendi, “Kuakele muntu umo uakufuka mu lihia liendi muakele viakuteja viavingi. ");
INSERT INTO nkn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kaha uasinganiekele ikeye vavenia nguendi, ‘Njikalinga vati, omuo kunjesi na vishete viakama via kutulikila viakuteja viange?’ ");
INSERT INTO nkn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kaha naua uahandekele nguendi, ‘Njikalinga eci, njikasiula vishete viange na kutunga viakama, muje mukemo njikahaka vimbuto viange na viuma viange vioshe. ");
INSERT INTO nkn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kaha njikahandeka ku muono uange nguange, Muono, uli na viuma viavingi unalitumbikila ha miaka yaingi, huima, lia, nua na kuvuahelela.’ ");
INSERT INTO nkn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Vuno honi Njambi uahandekele kuli ikeye nguendi, ‘Yove cilema! Vutsiki vuno vene muono uove vauambata. Kaha vije viuma viuna livuahesela vikapua vieya?’ ");
INSERT INTO nkn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Omu mukemuo mucikapua kuli muntu uje, vikakala navaje vakalitulikila vufuko vakevo vavenia vuno honi kuva fukile ku mesho a Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kaha Yesu uahandekele kuli vandongisi vendi nguendi, “Nankuma njimileka nguange, keti mulinienge ha vuyoye vueni vimukalia, cipue via muvila ueni vimukazala. ");
INSERT INTO nkn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Omuo vuyoye vunapu vuaseho kupulakana viakulia, na muvila kupulakana vuzalo. ");
INSERT INTO nkn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Singaniekeni makololo kuve kulima cipue kuteja, kuvakele na cishete cipue muakutulikila viakulia, vuno honi Njambi alina kuvalisa. Yeni muvaseho cikuma kupulakana tuzila. ");
INSERT INTO nkn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iya hhakati keni mu kulinienga asa kuhakelako cipue ka ntsimbu kakandende ku vuyoye vuendi? ");
INSERT INTO nkn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nga kumuasa kulinga eci cuma cacindende, kaha vika muliniengela ha vioshe? ");
INSERT INTO nkn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Singaniekeni vintemo muvikakolela: Kuvie kupanga cipue kulizika. Vuno honi njimileka nguange, cipue vene muene Solomoni mu vufuko vuendi vuoshe kazalele ngue vuzalo ngue vua evi. ");
INSERT INTO nkn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nga omu mukemo Njambi akazikilamo vishoni via musenge, vije vikalako lika lelo kaha imene vavintsimika mu tuhia, yeni akamizika cikuma, keti mukale nalikulahelo lialindende ngacije.” ");
INSERT INTO nkn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Keti mutualeleleho kulinienge hali vimu kalia cipue vimu kanua. ");
INSERT INTO nkn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vaka lifuti vakevo vakatondo evi vioshe viuma. Vuno honi yeni Ishueni azivuka nguendi muvitonda. ");
INSERT INTO nkn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vuno honi tondeni tahi vumuene vua Njambi, kaha navioshe evi vaka mihanavio naua.” ");
INSERT INTO nkn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Keti muvue liova yeni mpunga yaindende, Ishueni navuahelela kumihana vumuene. ");
INSERT INTO nkn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Landeseni vufuko vueni nakuvuhana vimbongo kuli tuhutu. Livuaheseleni vikuama vieni vavenia vije kuvikapihia, vukevuo vufuko vua muilu vuje kuvuekuhua cipue vezi kuvasa kuvushuena na tuntembulu kuvasa kuvupihisa. ");
INSERT INTO nkn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Oko kuli vufuko vuove, kukeko kukakala mutima uove.” ");
INSERT INTO nkn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Livuaheseleleni vipangi na vindeya vieni vishuame. ");
INSERT INTO nkn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pueni ngue vangamba vavandamena Muene uavo ahuma ku cilika cavulo. Omo nge eja nakutota ku cikolo ohovene kaha va mushokuelela. ");
INSERT INTO nkn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vanavezika vaje vangamba omo Muene uavo akavauana vatona na kulivuahesela nge eja. Njimileka muavusunga, Muene uavo akalizitika muiva uendi na kuvalania vatumame ku mesa na kuvahana viakulia.” ");
INSERT INTO nkn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vavezika vangamba vaje nga Muene uavo eja avauana vanalivuahesela vualuno cipue eje hhakati ka vutsiki cipue akasholoka hanima. ");
INSERT INTO nkn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naua Yesu ualekele vandongisi vendi nguendi tantekeyeni eci, “Nga vavenia njivo akatantekeya ntsimbu ije muizi akeja, nge kekuseza njivo yendi vaituve. ");
INSERT INTO nkn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Neni naua muapande kuli vuahesela, omuo Muna Muntu akeja ha ntsimbu kumua livuaheselele.” ");
INSERT INTO nkn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulu uehuile nguendi, “Muene, uli nakutulekesa eci cisimo yetu lika indi na voshe?” ");
INSERT INTO nkn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Muene Yesu uamukumbuluile nguendi, “Kuakele ngamba ua mana na lutsilielo. Muene uendi uamuhakele kuendesa vakuavo vangamba nakukahana viakulia ha ntsimbu yatelamo. ");
INSERT INTO nkn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uakukuisula uje ngamba omo Muene uendi ahiluka amuuana hali laja kuvipangi. ");
INSERT INTO nkn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Njimileka muavusunga, Muene uendi akamupuisa kupua mukuluntu ua vufuko vuendi vioshe. ");
INSERT INTO nkn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Vuno honi vije vikalingika nga uje ngamba halihandekesa ikeye vavenia nguendi, ‘Muene uange nakotokela ha kuhiluka,’ kaha akaputuka kupupa vangamba vakuavo, va vamala nava va vampuevo na kulia na kunua na kupenda? ");
INSERT INTO nkn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nga Muene ua uje ngamba akahiluka ha litangua olio kamuvandamene na ola ije katantekeyele, akamutetanga vimpindi na kumuhaka hamo nava kakuhona kutava. ");
INSERT INTO nkn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nga ngamba uje atantekeya viatonda Muene uendi, vuno honi kuvivuahesa kuahi cipue kalingi viatonda Muene uendi vaka mupupa na vimbanda viavingi. ");
INSERT INTO nkn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Vuno honi uje katantekeya Muene uendi viatonda, kaha alinga viuma viafuila kashitiku vaka mupupa vimbanda viavindende. Kuli uoshe vanahana viavingi, viavingi naua vakatonda, kuli uje vanatulikisile viavingi, viavingi cikuma vakamuihula. ");
INSERT INTO nkn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Njezile nakuneha tuhia ha mavu, njatondo nge tunakuata laja! ");
INSERT INTO nkn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ha kulivanga njapandele kuhita mu cimbuitikilo ca tuyando tuatuingi, njinazeye kuvanga cinahiti! ");
INSERT INTO nkn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Muasinganieka ngueni njinezile mukuneha ciyulo ha mavu? Houe, njimileka vuno honi njinanehe kulitepa. ");
INSERT INTO nkn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kuhuma hano ntanga ya vantu vatanu vakalitepa, vatatu valiluisa na vavali kaha vavali valiluisa na vatatu. ");
INSERT INTO nkn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vakalipanga, vaishe valuisa vana va vamala, na va vamala kuluisa vaishavo, vaina kuluisa vana vavo va vampuevo kaha na vana va vampuevo kuluisa vainavo, vaina mueno kuluisa vaniotomueno yavo, vaina mueno kuluisa vaniotomueno yavo.” ");
INSERT INTO nkn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu uahandekele ku civunga nguendi, “Nga mumona lishelua lihuminina kuli katokela litangua, vuasi vuasi muhandeka ngueni, ‘Ikanoka’, kaha inoka. ");
INSERT INTO nkn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kaha nga muvua mpunzi ihuminina mu mbuela, muhandeke ngueni, ‘Kukayukuma’, kaha mukemo vene. ");
INSERT INTO nkn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yeni vaka civembulu! Muatantekeya kulumbununa cifua ca mavu cipue ca melu, vuno honi vika kumutantekeyela kulumbununa viuma vije Njambi alina kulinga ha vintsimbu vino tulimo? ");
INSERT INTO nkn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Vika muhonoua kuli yula yeni vavenia hakulinga viuma viacili? ");
INSERT INTO nkn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nga uya na citozi cove kunzango, eseka cikuma kulivuasana nendi mu ngila. Nga kuahi akakutuala kuli muka kuyula, kaha muka kuyula akakutuala kuli mukuluntu ua kamenga kaha akakutuala mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Njimileka yeni nguange kumukahumumo kuvanga noho mukafueta vimbongo viama maneselelo via mukuli.” ");
INSERT INTO nkn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ha ntsimbu ije kuakele vantu vamo valekele Yesu via Vangalileya vaje Pilato uatsihile te valinakulinga vinkombelo viavo kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu uavehuile nguendi, “Omuo Vangalileya vaje vavatsihile mu ngila ije vene, kaha yeni muayongola ngueni vapuile vaka vupi kupulakana Vangalileya voshe ndi? ");
INSERT INTO nkn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Njimileka nguange, kuahi! Vuno honi nga kumutenguluka mukanonga ngue vakevo naua. ");
INSERT INTO nkn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Singaniekeni vaje vantu likumi na vatanu na vatatu vaje vatsile omo kaposhi ka mu Siloame kavauililile. Musinganieka ngueni vapuile vaka vupi kupulakana voshe vaje vakele mu Yelusalema ndi? ");
INSERT INTO nkn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Njimileka nguange, kuahi! Vuno honi kuvanga mutenguluke keti ngoconi mukanonga ngue vakevo naua.” ");
INSERT INTO nkn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kaha Yesu uavatele cisimo eci, “Kuakele yala umo uakunine muti ua mukuyu mu lihia liendi. Kaha uaile nakumonako vushuka vuno honi kavuuaneneko. ");
INSERT INTO nkn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaha uahandekele kuli ndimi yendi nguendi, ‘Tala, mu miaka itatu njinakele nakuija nakutondako vushuka oku ku muti ua mukuyu, hanga nakamo kanjinauanako kahi. Uteke! Vikahoni utualelelaho kushamuisa livu eli?’ ");
INSERT INTO nkn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Vuno honi uje ndimi uamukumbuluile nguendi, ‘Muene, acitaleleleniko muaka umo naua, njikahindako kuuzengeleka nakuhakako vuilo. ");
INSERT INTO nkn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nga ukema vushuka mungolosika, kaha muacili, vuno honi nga kuukemi, ambahoni njikauteka.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ha litangua limo lia Sapalalo Yesu uakele nakulongesa mu njivo ya malombelo. ");
INSERT INTO nkn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kaha kuakele mpuevo muje uakele na lihamba lije liamu vavalesele miaka likumi na itanu na itatu. Kaha ikeye uakotamene kasele kuhetuka kuahi. ");
INSERT INTO nkn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Omo Yesu uamumuene, uamusanene nakuhandeka kuli ikeye nguendi, “Mpuevo, njikukangula ku kuvavala kuove.” ");
INSERT INTO nkn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kaha Yesu uakambekele mavoko endi hali ikeye, hajevene uolokele na kuputuka kushangazala Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Vuno honi mukuluntu ua mu njivo ya malombelo uanienguele omuo Yesu uakanguisile muntu ha litangua lia Sapalalo, uakele na kuhandeka ku vantu nguendi, “Kuli matangua atanu na limo aje tunapande kupanga vipangi. Ijeni mu matangua aje linga vamikanguise, keti ha litangua lia Sapalalo, kuahi.” ");
INSERT INTO nkn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vuno honi Muene Yesu uamukumbuluile nguendi, “Eni vaka civembulu! Nkuma yeni kumue kuzitula vangombe yeni cipue vimulu ceni nakumutuala ku mema ha litangua lia Sapalalo ndi? ");
INSERT INTO nkn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Taleni ou Mpuevo! Ikeye mutekulu ua Avilahama uje yakutile Satana miaka likumi na itanu na itatu. Nkuma kuvapandele kumuzitula ha litangua lia Sapalalo ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kukumbulula nguendi kuazivisile vitozi vendi voshe shuamua, kaha vantu voshe vajolelelele ha viuma viakukomokesa viacili vije vialingile. ");
INSERT INTO nkn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kaha Yesu uavehuile nguendi, “Vumuene vua Njambi vunapu ngue vika? Njivuesekesa na vika? ");
INSERT INTO nkn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Vunapu ngue muje, muntu anona kanona kamo kambuto ya musalata nakukakuna mu lihia citungu. Kaha kakakola kapua muti uakama, kaha tuzila veja vakutungila mashua avo ku mintango yauo.” ");
INSERT INTO nkn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kaha naua Yesu uavehuile nguendi, “Vumuene vua Njambi njivuesekesa na vika? ");
INSERT INTO nkn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Vunapu ngue cimbaluila cije mpuevo uanonele na kuutsingasana na vunga vua vuingi vua tiliku mu lilonga, noho mukasha uoshe uafutunukile.” ");
INSERT INTO nkn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu uahitile mu Vinganda na mu membo, ualongesele vantu oku hali mu vungenzi vuakuya ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kaha umo uamuhuile nguendi, “Muene, nkuma vavandende lika vakovoka ndi?” Yesu uamukumbuluile nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Licikinineni mukovele mu cikolo ca cindende, muavusunga omuo vavengi vakatonda ku kovelamo vuno honi kuvakasa. ");
INSERT INTO nkn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Omo vavenia njivo akemana na kushoka lipito, kaha mukemana hambanza na kutota ha lipito ngueni, ‘Muene, tushokolueleko!’ Kaha akamikumbulula nguendi, ‘Kunjitantekeya oku kumuhuma.’ ");
INSERT INTO nkn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kaha mukaputuka kuhandeka ngueni, ‘Tualile na kunua nove, kaha ualongesele mu nganda yetu.’ ");
INSERT INTO nkn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Vuno honi akahandeka naua nguendi, ‘Kunjitantekeya oku muhuma. Humeni kuli yange, yeni voshe vaka kulinga viavipi!’ ");
INSERT INTO nkn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mukalila na kulishumanga ku mazo omo mukamona Avilahama, na Isake na Yakomba na tunanguizi va Njambi va Njambi voshe mu Vumuene vua Njambi, vuno honi yeni vakamiumbila hambanza. ");
INSERT INTO nkn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vantu vakahuma mu ngangela na mu kangombe ka yambi, ku kunto na mu mbuela, vakatumama ku ciuano mu Vumuene vua Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Cilivene vaka kukotokela vakapua vaka kulivanga, kaha vaka kulivanga vakapua vakevo vaka kukotokela.” ");
INSERT INTO nkn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ha ntsimbu ijevene kuezile Vafaliseo vamo kuli Yesu na ku handeka nguavo, “Unapande kuhuma kuno uye kueka, omuo Helonde atonda kukutsiha.” ");
INSERT INTO nkn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu uavakumbuluile nguendi, “Yeni mukamuleke ouo mbanje ngueni, ‘Njicili nakuhumisa mahamba na kukanguisa vantu kumavezi avo ku litangua lialelo na imene, kaha ha litangua lia mucitatu ambahoni njikamanesa vipangi viange.’ ");
INSERT INTO nkn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cipue ngoco njinapandele kuenda lelo na imene na imenuavuze, omuo keti cacili kuli kananguizi ua Njambi kutsila kueka vuno honi kuvanga mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusalema, Yelusalema, yove mu kakutsiha tunanguizi va Njambi va Njambi nakuasha mavue kuli vaje vavakutumina! Vintsimbu viavingi njatondele kukungulula vantu vove hamolika ngue cali muakavutikiya vana vendi mu mambava endi, vuno honi yove kuuanjitavele! ");
INSERT INTO nkn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tala, njivo yove ikasala ya mupulungua. Njikuleka nguange, kuukanjimono naua kuvanga noho ntsimbu ikeja omo ukahandeka nguove, ‘Uakuvezika ou eja mulizina lia Muene.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ha ntsimbu imo omo Yesu uaile ku njivo ya mukuluntu ua Vafaliseo na kulia via kulia ha litangua lia Sapalalo, voshe vaje vakele mu njivo vakele na kumutalela muyehi. ");
INSERT INTO nkn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ha lutue luendi hakele yala uakele nakuvavala kuzimba mikono uezile kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu uehuisile Vafaliseo na valongisi va mezi a mashiko a Mosesa nguendi, “Cinapu cacili kuli Lishiko lietu ku kanguisa vantu ha litangua lia Sapalalo, indi kuahi?” ");
INSERT INTO nkn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Vuno honi vaholokele. Kaha Yesu uamuambate uje yala uakuvavala na kumukanguisa, nakumuecela aye. ");
INSERT INTO nkn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kaha uahandekele kuli vakevo nguendi, “Nga hhakati keni hali umo hali na muana cipue ngombe uje nauila mulisima, kumuasa ku muhumisamo ha litangua lia Sapalalo ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaha vahonouele kumukumbulula eci. ");
INSERT INTO nkn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Omo Yesu uamuene vangenzi vanahangula vihela via vituamo viakama, uavatelele cisimo nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Omo nga vanakulaniako ku cilika cavulo, keti ukatumame ha cituamo ca kasingimiko, omuo hamo kuli umo ua kasingimiko kupulakana yove ivanalania. ");
INSERT INTO nkn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kaha uje uamilaniene muvavoshe a kahandeka kuli yove nguendi, ‘Njimilomba mutumameko kuje linga ou yala atumameko ha cihela ceni.’ Kaha mushuamua ukambata cituamo ca cindende kumaneselela. ");
INSERT INTO nkn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Vuno honi nga vanakulania, ya ukatumame ha cituamo ca cindende ca kumaneselela, nga vavenia cilika akeja, akahandeka kuli yove nguendi, ‘Kavusamba, tumama ku cituamo ca kasingimiko,’ kaha uka tumama na kasingimiko kuli voshe ukatumama navo ku mesa. ");
INSERT INTO nkn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaha voshe vaka lijundula vakevo vavenia va kavaneha ha mavu, kaha voshe vakalikehesa vakevo vavenia vakajundula.” ");
INSERT INTO nkn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kaha Yesu uahandekele kuli uje uamulaniene nguendi, “Nga uhana viakulia ha ciuano, keti lika ulanie vavusamba cipue va ndumbuevo cipue vavushoko vove cipue vakufuka vamua lihata navo, hamo vakamisana navakevo naua, kaha cikamuesa ngue vali nakumifueta. ");
INSERT INTO nkn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vuno honi nga uana viakulia ha ciuano, lania vihutu, na visualonda, na vilema na tupuputua. ");
INSERT INTO nkn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nga ulinga muje ukapua uakuvezika, omuo kuvakasa kukufueta, kaha vaka kufueta ha kusanguka ca vaka vusunga.” ");
INSERT INTO nkn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Umo mungenzi ivalaniene kukulia omo uovuile eci, uahandekele kuli Yesu nguendi, “uakukuisula uje akatumama ku ciuano mu vumuene vua Njambi!” ");
INSERT INTO nkn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kaha Yesu uahandekele kuli ikeye nguendi, “Kuakele muntu umo uje ualingile ciuano cakama kaha ualaniene vantu vavengi. ");
INSERT INTO nkn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ha ntsimbu ya ciuano uatumine vangamba kuli vaje valaniene nguendi, ‘Ijeni, omuo vioshe vinavua honi.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kaha umo na umo uakele nakuhandeka nguendi nazenzama. Uakulivanga ua handekele nguendi, ‘Njinalanda lihia, kaha njitonda njikalimone, tambula kulomba kuange.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mukuavo uahandekele nguendi, ‘Njinalanda vangombe likumi, kaha njili nakuya na kuveseka, tambula kulomba kuange.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mukuavo naua uahandekele nguendi, ‘Njinambata mpuevo vene, kaha kunjasa kuija.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kaha uje ngamba uahilukile na kuambulula kuli Muene yendi. Kaha vavenia njivo uanienguele kaha uahandekele kuli ngamba yendi nguendi, ‘Ya hano vene muvingila na mu vitapalo via mbonge unehe vihutu, na visualonda, na tupuputua na vilema.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Omo ngamba yendi uahilukile uahandekele nguendi, ‘Muene, viunashikile via lingiua, vuno honi kuhucili muhela.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kaha Muene uahandekele kuli ngamba yendi nguendi, ‘Ya mu vingila via mumikulo na mu vitapalo via mumikulo, usindiye vantu veje vakovele mu njivo yange linga ishule. ");
INSERT INTO nkn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kaha njikuleka nguange naumo uahi kuli vaje vanjinalaniene a kevua ku viakulia viange!’” ");
INSERT INTO nkn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Litangua limo omo vantu vavengi vaile na Yesu, kaha ualulukile na kuhandeka kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Uoshe uje eja kuli yange vuno honi kazindi va ishe na vaina, mpuevo yendi na vana vendi, na vandumbuendi na vamuanaye va vampuevo, cilivene, cipue ukeuo muono uendi, kasa kupua ndongisi uange. ");
INSERT INTO nkn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Uoshe uje kambata cilindakano cendi na kunjikava kasa kupua ndongisi uange. ");
INSERT INTO nkn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nga utonda kutunga njivo yakama, kaha utumama ha mavu na kumona vije vitondeka, kumona nga uasa kuimanusula. ");
INSERT INTO nkn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vuno honi nga uaputuka kuhinda luvula kaha uonoua kuimanesa, voshe vakaimona kaha vakakujola ");
INSERT INTO nkn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","na kuhandeka nguavo, ‘Uje mukuetu uaputukile kutunga vuno honi nahonoua.’ ");
INSERT INTO nkn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Cipue muene, nga aya ku nzita na kulua na mukuavo muene, kaha atumama ha mavu na kumona nga asa kulua na vantu va kupua makulukazi likumi na uje mukuavo eja na vantu vakupua makulukazi makumi avali. ");
INSERT INTO nkn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nga kasa, kaha omo mukuavo acili kulahako, akatumako vantu vakahandeke via ciyulo. ");
INSERT INTO nkn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mucifua cimo vene,” “naumo uahi hali yeni apua ndongisi uange nga kaseze vioshe vianafuku. ");
INSERT INTO nkn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Muongua uapua uacili, vuno honi nga uashamuka kaha kutovala caco cihiluka vati? ");
INSERT INTO nkn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kuukapu uacili ku mavu cipue ku vuilo, vaka umbila kuti. Uoshe hali na matuitui, napande kuivua evi!” ");
INSERT INTO nkn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Litangua limo omo vaka kutambula lisimu na vaka vupi vezile na kuivuilila Yesu, ");
INSERT INTO nkn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","kaha Vafaliseo na valongisi va mezi a mashiko a Mosesa vakele nakuningozola na kuhandeka nguavo, “Ou yala linakutambula vaka vupi na kulia navo.” ");
INSERT INTO nkn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kaha Yesu uava telele cisimo eci nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Iya hali yeni nga hali na Vampanga cihita kaha azimbalesaho umo, nkuma kaseze vaje makumi atanu na auana na vatanu na vauana (99) mu musenge na kuya nakutonda uje nazimbala kuvanga noho na muuana? ");
INSERT INTO nkn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nga namuuana, avuahelela na kumuhaka ha vitsili viendi, ");
INSERT INTO nkn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","omo ha kuya kuimbo, kaha akasana vavusamba vendi nava va lihata navo kaha akahandeka nguendi, ‘Vuaheleleni hamo nange omuo njinauana mpanga uange uje uazimbalele.’ ");
INSERT INTO nkn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Njimileka nguange, mucifua cimo vene kukapua kuvuahelela kuakama muilu hali muka vupi umo nga natenguluka kupulakana vaje makumi atanu na auana na vatanu na vauana vantu vaje kuvatondo kutenguluka.” ");
INSERT INTO nkn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu uatualeleleho kuleka vantu cisimo eci nguendi, “Nga mpuevo umo ali na vimbongo via mu uayauaya likumi, nga hazimbala imo, nkuma kashuameka ndeya yendi, nakukomba mu njivo na kutonda vuino kuvanga noho hakaiuanena? ");
INSERT INTO nkn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nga aiuana, kaha asana vavusamba vendi nava valihata navo na kuvaleka nguendi, ‘Vuaheleleni hamo nange omuo njinaiuana mbongo yange ije njazimbalesele.’ ");
INSERT INTO nkn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Njimileka nguange, mucifua cimo vene, muli kuvuahelela hakati katungelo va Njambi hali umo muka vupi uje atenguluka.” ");
INSERT INTO nkn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu uatualeleleleho kuhandeka nguendi, “Kuakele yala uakele navana va vamala vavali. ");
INSERT INTO nkn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ua kanike uahandekele kuli ishe nguendi, ‘Tate, njihaneko mutambela ua vufuko vuange,’ kaha ishavo uavapangelele vufuko vuendi hakati kavo vana vendi vavali. ");
INSERT INTO nkn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kukuahitile ntsimbu yailaha kuhuma haje, ua kanike ua mbate vioshe uakele navio na kuya ku lifuti lilahako na kupihisa viuma viendi vioshe kusenga. ");
INSERT INTO nkn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Muamanusuile kupihisa viuma viendi vioshe, kaha kuakele njala mu lifuti lioshe, kaha uaputukile kutsa njala na vuhutu. ");
INSERT INTO nkn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kaha uaile na kutonda vipangi kuli muntu umo uamu lifuti lije kaha ua mutualele ku lihia naku lisa vangulu. ");
INSERT INTO nkn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uatondele kulia vije vakele na kulia vangulu, vuno honi naumo uahi uamuhaneneko cimo ca kulia. ");
INSERT INTO nkn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Omo mana ahilukile muli ikeye, uahandekele kuli ikeye vavenia nguendi, ‘Vaka kupanga va vatate vali na viakulia viavingi, yange kuno njili nakutsa njala! ");
INSERT INTO nkn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Njikuta vungenzi njihiluke kuli tate kaha njikahandeka kuli ikeye nguange, “Tate, njapihisila Njambi nove, ");
INSERT INTO nkn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","kunjapandele naua kunjisana munove, njipuise kupua umo uava Vaka kupanga vove.”’ ");
INSERT INTO nkn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kaha uakatukile nakuya kuli ishe. “Omo uakele nakuendela kulako, ishe ua mumuene kaha ua muivuililile cikeketima kaha ishe uamushatukilile, uamuvumbatele na kumutsuemba. ");
INSERT INTO nkn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Muana uahandekele kuli ikeye nguendi, ‘Tate njapihisila Njambi nove. Kunjapandele naua kunjisana munove.’ ");
INSERT INTO nkn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Vuno honi ishe uahandekele kuli vangamba vendi nguendi, ‘Zambuleni! Neheni cikovelo cacili mumuzike nakumuzika kanzeya ku munie uendi na vinkaku ku viliato yendi. ");
INSERT INTO nkn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Neheni muna ngombe uakuhindala mumutsihe, kaha tulieni na kuvuahelela, ");
INSERT INTO nkn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","omuo munange ou uatsile vuno honi nahinduka naua, uazimbalele vuno honi nauaniua.’ Kaha vaputukile kulia na kuvuahelela. ");
INSERT INTO nkn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ha ntsimbu ijevene, muana ua mukuluntu uakele mulihia. Omo uezile hayehi na njivo, uovuile miaso na vakakukina. ");
INSERT INTO nkn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kaha uasanene umo ua vangamba na kumuihula vika ‘vili nakulingika.’ ");
INSERT INTO nkn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uamukumbuluile nguendi, ‘Ndumbuove neja kaha isho natsihi muana ngombe uakuhindala omuo nahiluka oku alimuacili.’ ");
INSERT INTO nkn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Muana ua mukuluntu ua nienguele na kuviana kukovela mu njivo. Kaha ishe uatuhukile na kumulambelela akovele mu njivo. ");
INSERT INTO nkn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Vuno honi uakumbuluile ishe nguendi, ‘Tala! Ha miaka yoshe njinakupangela ngue ndungo kaha kunjashauile mashiko ove. Vuno honi kuuanjihaneko cipue muna mpembe linga njivuahelele na vavusamba vange. ");
INSERT INTO nkn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vuno honi omo ou munove nahiluka, uje na pihisa vufuko vuove na vukoyi kaha neja kuimbo, kaha una mutsihila muana ngombe uakuhindala!’ ");
INSERT INTO nkn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ishe uahandekele kuli ikeye nguendi, ‘Munange, ntsimbu yoshe unakele nange, kaha vioshe njilinavio vinapu viove. ");
INSERT INTO nkn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vuno honi tuapande kuvuahelela na kujolela, omuo shongoyove ou uatsile kaha nayoyo naua, uazimbalele vuno honi nauaniua.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kaha Yesu uahandekele kuli vandongisi vendi nguendi, “Kuakele yala umo ua kufuka uje uakele na muka kutulika vufuko vuendi. Muka kufuka uje vamulekele nguavo muka kutulika vitenga viove hali nakupihisa vimbongo viove. ");
INSERT INTO nkn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kaha uamusanene na kuhandeka nguendi, ‘Vika evi njili nakuivua hali yove? Njihane vukaleho vua viuma vioshe muje munatulikilamo vufuko vuange, omuo kukapu naua muka kutulika uange.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Muka kutulika ualihandekesele ikeye vavenia nguendi, ‘Nga muene uange anjihumisa vipangi, njilinga vatihoni? Kunjesi na nzili yakuhinda vina, nganjihuma vipangi kuno, kaha naua njili na shuamua yakulomba. ");
INSERT INTO nkn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kaha honi njatantekeya vinjikalinga linga vantu vakanjitambule mu vinjivo viavo! Omo vipangi viange vikahua.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kaha uasanene vantu vaje vakele na mikuli kuli muene uendi. Uehuile uakulivanga nguendi, ‘Vungahi uakonguele kuli muene uange?’ ");
INSERT INTO nkn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kaha uamukumbuluile nguendi, ‘Vihita vitanu na vitatu via mingomo ya mazi a olive.’ Kaha uje muka kutulika uahandekele naua nguendi, ‘Livulu liove eli lije limuesa makongo ove, tumama ha mavu sonekamo viseteko via vihita viuana via mingomo.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kaha uehuile mukuavo ua mucivali nguendi, ‘Uakonguele cingahi?’ Kaha uamukumbuluile nguendi, ‘Cihita cimolika ca masaka a tiliku,’ kaha uamulekele nguendi, ‘Ambata livulu liove eli sonekamo makumi atanu na atatu a masaka a tiliku.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kaha uje muene uendi uashangazalele uje muka kutulika uakuhona kulongua hakukala na mana, omuo vantu va lifuti lino vatantekeya muakukela navakuavo kupulakana vana vamu ceke.” ");
INSERT INTO nkn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Njimileka nguange, pangeseni vufuko vua ha mavu kulinga vusamba kuli yeni na tuhutu. Kaha omo vufuko vueni vukahua, omo mukatsa vaka mitambula mu vihela via kuhona kuhua. ");
INSERT INTO nkn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Uoshe akala na vusunga muvia vindende na mu viakama akakala na vusunga, kaha uje kakala na vusunga muvia vindende kaha kakakala na vusunga mu viakama. ");
INSERT INTO nkn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaha nga kuuakele na vusunga na vufuko vua ha mavu, iya honi akutsiliela na vufuko vua vusunga? ");
INSERT INTO nkn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kaha nga kuuakele na vusunga ha vitenga via muntu, iya akakuhana vufuko vuje vuakupande? ");
INSERT INTO nkn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Uahi ngamba asa kupangela vamiene vavali omuo uje ngamba akazindaho umo naku zangaho mukuavo, cipue halihanako kuli umo na kushaula mukuavo. Kuuasa kupangela Njambi na vimbongo.” ");
INSERT INTO nkn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Vafaliseo vaje vapuile vaka kuzanga vimbongo, omo vovuile vioshe evi, kaha vashendumuine Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kaha uahandekele kuli vakevo nguendi, “Yeni vaje vaka limuesa kupua vaka vusunga ku vantu, vuno honi Njambi atantekeya mitima yeni, omuo coshe cije vashangazala hakati ka vantu, ku mesho a Njambi cinapu ca ngoco ngoco. ");
INSERT INTO nkn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lishiko lia Mosesa na tunanguizi va Njambi va Njambi vatuamenene vantu noho Iuano muka kumbuitika uezile. Kuhuma oho naha ntsimbu ino muzimbu uacili ua vumuene vua Njambi vauambulula. Muntu uoshe alinakueseka cikuma kukovela omu mu vumuene. ");
INSERT INTO nkn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Vuno honi cacasi melu na mavu kuhita kupulakana ka lizi kakande kamu mukanda ua Lishiko lia Mosesa kuhua. ");
INSERT INTO nkn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Uoshe akondola mpuevo yendi na kuambata ueka nalingi vupangala, kaha uoshe ambata mpuevo uakukondola kuli yala liendi alinga vupangala. ");
INSERT INTO nkn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kuakele yala umo uakufuka uje uakele nakuya vuzalo vua vunengu vuandando yakutula, uakele na ciuano ca kulia cakama halitangua na tangua. ");
INSERT INTO nkn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kuakele yala uacihutu lizina liendi Lazalu uje ivakele nakuneha ku cikolo ca muka kufuka, uje uakele na vimbandu muvila uoshe. ");
INSERT INTO nkn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalu uakele nakuvandamena kulia viakele na kuua ku mesa ya uje yala uakufuka, na tutali vakele nakuija na kuliasa ha vimbandu viendi. ");
INSERT INTO nkn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Uje yala uacihutu uatsile kaha tungelo vamuambate kukakala na Avilahama. Kaha na uje yala uakufuka naikeye uatsile kaha vamutsindile. ");
INSERT INTO nkn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Uakele mu ngehena na kuyanda. Uatalele kuilu kaha uamuene Avilahama kulahako hali na Lazalu ku mukulo uendi. ");
INSERT INTO nkn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kaha uasanene nguendi, ‘Tate Avilahama, njizivileko cikeketima tuma Lazalu ambuitike munie uendi mu mema anjitontuese ha ndaka yange, omuo njili na kuvua kuvavala muno mu tuhia.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Vuno honi Avilahama uamukumbuluile nguendi, ‘Munange, anuka ha ntsimbu yove uakele nakuyoya uakele nakutambula viuma viove via cili, na ntsimbu ya Lazalu uatambuile via vipi, vuno honi hali nakuyoya muacili yove uli na kuyanda. ");
INSERT INTO nkn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kaha naua mukati kove netu hali cina cakama, ngeci uoshe atonda kujavuka kuhuma kuli yetu kuija oko keti ase, kaha naumo uahi asa kujavuka kuhuma oko kuija kuno kutuli.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kaha yala ua kufuka uahandekele nguendi, ‘Honi, tate, njilomba yove utume Lazalu ku njivo ya tate, ");
INSERT INTO nkn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","omuo njili na vandumbuange vatanu. Ecela Lazalu aye nakuvanangula linga keti vakeje naua kuno kucihela ca tuyando.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kaha Avilahama uakumbuluile nguendi, ‘Vali na visoneka via Mosesa na tunanguizi va Njambi va Njambi, vanapande kuvovuilila.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Uje yala ua kufuka uahandekele nguendi, ‘houe, tate Avilahama, vuno honi nga umo akasanguka kuvatsi aya kuli vakevo kaha vakatenguluka.’ ");
INSERT INTO nkn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Avilahama uamukumbuluile nguendi, ‘Nga kuvevuilila ku visoneka via Mosesa na tunanguizi va Njambi va Njambi, kaha cipue muntu uakuhuma ku vatsi ku vakatava.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu uahandekele kuli vandongisi vendi nguendi, “Viaseko via vupi mua vusunga vihita, vuno honi tuyando kuli uje avineha! ");
INSERT INTO nkn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cacili kuli ikeye nga vaka mukutilila livue liakama muntsingo na kumumbila mu cisali, kuhona akovelese umo ua vanike vavandende mu vupi. ");
INSERT INTO nkn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Zangameni ku vije muli nakulinga. Nga mukueni alinga vupi munangule nga halitavela mukonekele. ");
INSERT INTO nkn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kaha nga muntu umo vene akupihisila lutanu na luvali ha litangua limo, kaha eja kuli yove lutanu na luvali na kuhandeka nguendi, ‘njatenguluka,’ unapande kumukonekela.” ");
INSERT INTO nkn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kaha tunganda vahandekele kuli Muene Yesu nguavo, “Vuezelela lutsilielo luetu!” ");
INSERT INTO nkn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kaha Muene Yesu uahandekele nguendi, “Nga muli nalutsilielo lualundende ngue mbuto ya musalata, nge muasa kuhandeka ku muti ou uakama ua mizi yaingi ngueni, ‘Tukuka uka shimbame ha mema a kalunga!’ Kaha ukeuo ukamiononoka. ");
INSERT INTO nkn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nga ulina ngamba muka kulima cipue muka kuniunga vampanga uasa kuhandeka kuli ikeye nga ahuminina ku mehia nguove, ‘Ija hano vene uakutumame na kulia’? ");
INSERT INTO nkn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Houe! Ukahandeka kuli ikeye nguove, ‘Vuahesa viakulia viange via cinguezi, Naua lizitikile vualumo muiva uove nakunjipangela noho njikalia na kunua, nga njamanesa ambahoni ulie na kunua!’ ");
INSERT INTO nkn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Honi ngamba kuveku mutsatsela hakulinga vije vivamushikile kulinga ndi? Mua vusunga kuahi! ");
INSERT INTO nkn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Neni naua vene, omo mualingile vioshe vije vivamishikile kulinga, handekeni ngueni, ‘Tuva ngamba vangoco, tunalingi lika vipangi vietu.’” ");
INSERT INTO nkn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu hakuya ku Yelusalema uahitile mukati ka Samhaliya na Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kaha uakovelele muimbo muje vamala vambumba likumi vamuuanene, vemanene kulahako. ");
INSERT INTO nkn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Vatambakanene cikuma na kuhandeka nguavo, “Yesu, Muene tuvuileko cikeketima!” ");
INSERT INTO nkn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Omo Yesu uavamuene, uahandekele kuli vakevo nguendi, “Yeni mukalimuese yeni vavenia kuli tusasendote.” Omo vakele nakuya vavalelesele. ");
INSERT INTO nkn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kaha umo uavo omo uamuene nguendi nakanguka, uahilukile na kushangazala Njambi na lizi liakama, ");
INSERT INTO nkn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Uauile na cihanga cendi ku viliato ya Yesu na kumutsatsela. Ikeye uapuile Kasamaliya. ");
INSERT INTO nkn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kaha Yesu uahandekele nguendi, “Kuvapuile likumi vanakanguka? Ava vatanu na vauana vali kulihoni? ");
INSERT INTO nkn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Vikahoni cipue umo kuija nakuhana cisantsela kuli Njambi kuvanga lika ou keti kayunda?” ");
INSERT INTO nkn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kaha Yesu uahandekele kuli ikeye nguendi, “Katuka uye, lutsilielo liove lua kukanguisa.” ");
INSERT INTO nkn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kaha Yesu vamuihuile kuli Vafaliseo nguavo, “Ntsimbu muka vumuene vua Njambi vukeja?” Kaha uavatavele nguendi, “Vumuene vua Njambi kuvukeja mungila ije muasa kuvumona na mesho eni kuahi. ");
INSERT INTO nkn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kukuesi akahandeka nguendi, ‘Tala, vuno vulikuno!’ Cipue ‘Taleni, vuje vuli kuje!’ Omuo vumuene vua Njambi muli navuo hakati keni.” ");
INSERT INTO nkn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kaha honi Yesu uahandekele kuli vandongisi vendi nguendi, “Matangua akeja omo mukatonda kumona litangua limo lia Muna Muntu, vuno honi kumukasa kuli mona. ");
INSERT INTO nkn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kaha kukakala vamo vakahandeka kuli yeni nguavo, ‘Taleni ali kuje!’ Cipue, ‘Taleni ali kuno!’ Keti muyeko, keti muvakavangeye. ");
INSERT INTO nkn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngue muhiato mukahiatula muilu, kaha vaumona uhuma kumuhela umo ua lilu nakuya ku muhela ukuavo ua lilu, mukemovene naua Muna Muntu muakafua ha litangua liendi liakuhiluka. ");
INSERT INTO nkn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Vuno honi napande kuyanda cikuma na kumuyengula kuli vantu va ntsimbu ino. ");
INSERT INTO nkn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nge mucapuile ku matangua a Noua mukemovene mucikapuilamo naku matangua a Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Vantu vakele nakulia na kunua, na kuliambata na kushombuesa, noho Noua uakovelele mu vuato. Kaha livazi liezile nakuvanongesa voshe. ");
INSERT INTO nkn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nge mucapuile ku matangua a Lote: vantu voshe vanuine, valile, valandesele na kulandulula, vakunine na kutunga, ");
INSERT INTO nkn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","vuno honi ha litangua lije Lote uahumine mu Sondoma, tuhia na mavue vianokele ngue mema a kuhuma muilu, kaha via vanongesele voshe. ");
INSERT INTO nkn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cikapua ngue mujevene ha litangua liakasholoka Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ha litangua lijevene, uoshe uje yala hali helu lia njivo keti akovele mu njivo na kuambata viuma viendi, naua na uje hali mu lihia liendi keti ahiluke ku njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Singaniekeni hali mpuevo ya Lote. ");
INSERT INTO nkn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Voshe vaje vatonda kuniunga muono uavo vavenia vaka uzimbalesa, vuno honi vaje vazimbalesa muono uavo vakau uana. ");
INSERT INTO nkn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Njimileka, ha vutsiki vuje kukakala vantu vavali ha muhela umo, umo vakamuambata ou mukuavo vakamuseza. ");
INSERT INTO nkn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaha kukakala vampuevo vavali vali mukutua hamo mucini cimo, mukuavo vaka muambata na mukuavo vakamuseza.” ");
INSERT INTO nkn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vamala vavali vakapanga mu lihia, umo vakaya nendi mukuavo vakamuseza. ");
INSERT INTO nkn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kaha vandongisi vendi vamuihuile nguavo, “Kulihoni kuvikalingika, Muene?” Kaha Yesu uavatavele nguendi, “Kuoshe kuje kuli civimbi kukeko kukalikunguluila makuvi.” ");
INSERT INTO nkn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu ualekele vandongisi vendi cisimo eci kuvalongesa nguendi, vapande kulombela ntsimbu yoshe cakuhona kuecela. ");
INSERT INTO nkn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uahandekele nguendi, “Mu mbonge imo muakele muka kuyula uje kateuele Njambi cipue kusingimika vantu. ");
INSERT INTO nkn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kaha naua mu mbonge ijevene muakele ntuluue uje uakele nakuija kuli ikeye vintsimbu viavingi na kuhandeka nguendi, ‘njihaneko kapandi kange ha vitozi vange!’ ");
INSERT INTO nkn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ha ntsimbu yaindende uje muka kuyula uavianene, hajevene uahandekele kuli ikeye vavenia nguendi, ‘Cipue kunjiteue Njambi cipue kusingimika vantu, ");
INSERT INTO nkn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","vuno honi ou ntuluue nanjishupu cikuma, njapande kumuhana kapandi kendi, omuo nga atualelelaho kuija kaha aka njihonesa!’” ");
INSERT INTO nkn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kaha Muene Yesu uahandekele nguendi, “Ivuilileni vije viahandeka uje muka kuyula uakuhona vusunga! ");
INSERT INTO nkn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nkuma Njambi kasa kuyula mu vusunga ku vantu vendi vaje valinakulilila kuli ikeye vutsiki na mutania? Nkuma ngueni akasimbula mukuvakuasa ndi? ");
INSERT INTO nkn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Njimileka nguange, hajevene akavahana kapandi kavo. Vuno honi omo Muna Muntu akeja, akauanaho vantu vali nalutsilielo hano ha mavu ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu uate cisimo eci naua kuli vantu vaje vaka kutsiliela vusunga vuavo vavenia nakushaula vakuavo, ");
INSERT INTO nkn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Uahandekele nguendi, “Vamala vavali vayile ku njivo ya Njambi nakulomba, umo Kafaliseo, mukuavo muka kutambula lisimu. ");
INSERT INTO nkn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kafaliseo uemanene na kulomba nguendi, ‘Njikutsantsela Njambi, yange kunjafuile ngue vakuetu vantsintsa, vaka kuhona vusunga, vaka vupangala. Yange kunjafuile ngue uje muka kutambula lisimu nemana kuje. ");
INSERT INTO nkn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Njikaliumina kulia ha matangua avali mu simano, njikahana cimo kulikumi ca vioshe vinjikauana.’ ");
INSERT INTO nkn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Vuno honi uje muka kutambula lisimu uemanene ku lahako, kaha kasele cipue kutala kuilu, vuno honi ualivete ha ntulo na kuhandeka nguendi, ‘Njambi, civuile cikeketima yange muka vupi.’ ");
INSERT INTO nkn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Njimileka,” nguange, “uje muka kutambula lisimu uaile kuimbo liendi mu vusunga kupulakana uje Kafaliseo, voshe vaje valijundula vakevo vavenia vaka vakehesa, vuno honi voshe vaje valikehesa vakevo vavenia vakava jundula.” ");
INSERT INTO nkn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vantu vanehelelele Yesu vanike vavandende linga avasaleke mavoko, kaha omo vandongisi vendi vacimuene, vesekele kuvindika vaje vantu. ");
INSERT INTO nkn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Vuno honi Yesu uasanene vanike vavandende veje kuli ikeye, uahandekele nguendi, “Eceleni vanike vavandende veje kuli yange keti muvavindike, omuo vumuene vua Njambi vuli ku vantu ngue ava vanike vavandende. ");
INSERT INTO nkn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mua vusunga njimileka nguange, uoshe uje katambula vumuene vua Njambi ngue kanike uamundende, kakakovela mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Litangua limo umo mukuluntu ua Vayunda uehuile Yesu nguendi, “Mulongisi uacili, vika njinapande kulinga linga njikauane muono uakuhona kuua?” ");
INSERT INTO nkn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu uamukumbuluile nguendi, “Vika unjitumbuila nguove uacili?” Naumo uahi “uacili kuvanga Njamba lika. ");
INSERT INTO nkn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uatantekeya mashiko a Njambi nguauo, ‘Keti ulinge vupangala, keti utsihe, keti uive, keti uvangeye mukueni vukaleho vua makuli, singimika isho na noko.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kaha uje yala uakumbuluile Yesu nguendi, “Mashiko oshe aua njaononoka laja hume kuvuanike vuange.” ");
INSERT INTO nkn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kaha omo Yesu uevuile evi, uahandekele kuli ikeye nguendi, “Kunasupila cuma cimo ciunapande ku linga. Ya ukalandese vioshe viulinavio kaha ukahane vimbongo vioshe kuli tuhutu, kaha ukakala na vufuko muilu, kaha uije, uakunjikave.” ");
INSERT INTO nkn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Vuno honi uje yala omo uevuile evi, kaha uanienguele, omuo ikeye uakele navufuko vua vuingi. ");
INSERT INTO nkn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Omo Yesu uamuene nguendi naniengua, kaha uahandekele nguendi, “cinapu cacikalu kuli vaka kufuka kukovela mu vumuene vua Njambi! ");
INSERT INTO nkn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cacikalu kuli kamelu kukovela mu lisho lia nguya vuno honi cacikalu cikuma kuma muntu muka kufuka kukovela mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kaha vaje vantu vovuile, vamuihuile nguavo, “Iya honi akovoka?” ");
INSERT INTO nkn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kaha Yesu uavakumbuluile nguendi, “Kuli viuma vije vantu kuvasa kulinga vuno honi Njambi asa kulinga coshe.” ");
INSERT INTO nkn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kaha Petulu uahandekele nguendi, “Tala! Yetu tunaseza vioshe vituli navio, nakukukava.” ");
INSERT INTO nkn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kaha Yesu uahandekele kuli vakevo nguendi, “Eyo, mua vusunga njimileka uoshe uje naseza njivo yendi, cipue mpuevo yendi, cipue munaina, cipue visemi vendi, cipue vana vendi, omuo vumuene vua Njambi, ");
INSERT INTO nkn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","akatambula viavingi cikuma mu muono ou na muono ua yaye mu miaka ije ikeja kulutue.” ");
INSERT INTO nkn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu uatualele vandongisi vendi likumi na vavali kuavo lika, kaha uahandekele kuli vakevo nguendi, “Evuilileni! Tulinakuya mu Yelusalema kuje viuma vioshe vije vivasonekele kuli tunanguizi va Njambi va Njambi hali Muna Muntu linga vika lishulisise. ");
INSERT INTO nkn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Muna Muntu vakamuhana ku mavoko a Maloma vaje vaka mushendumuna na kumutuka na kumujekuila malenzi. ");
INSERT INTO nkn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Vaka muveta, kaha vaka mutsiha, vuno honi munima ya matangua atatu akasanguka.” ");
INSERT INTO nkn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Vuno honi vandongisi vendi kuvovuisisile nacimo cahi ha viuma evi, omuo kulumbunuka kua mezi aua vavashuekeleleuo linga keti vatantekeye vije via handekele Yesu kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Omo Yesu uahete kuyehi na Yeliko, kuakele yala umo ua kapuputua uakele kumukulo ua ngila nakulomba. ");
INSERT INTO nkn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kaha omo uevuile civunga ca vantu cili nakuita, kaha uehuile nguendi “Vika vili nakulingika?” ");
INSERT INTO nkn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kaha vamulekele nguavo, “Yesu uaku Nazaleta hali nakuhita.” ");
INSERT INTO nkn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kaha uatambakanene nguendi, “Yesu! Muna Ndaviti! Njivuileko cikeketima!” ");
INSERT INTO nkn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kaha vantu vaje vakele kulutue lia civunga, vamulekele linga aholoke. Vuno honi ikeye uatambakanene cikuma nguendi, “Ove Muna Ndaviti! Njivuileko cikeketima!” ");
INSERT INTO nkn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu uemanene nakushika nguendi, “Muneheni kuno”. Omo uje yala uashuenene kuyehi, Yesu uamuhulisile nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Vika utonda linga njikulingile?” Kaha uamukumbuluile nguendi, “Muene njitonda linga njimone naua.” ");
INSERT INTO nkn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kaha Yesu uahandekele kuli ikeye nguendi, “Mona! Lutsilielo luove luna kukanguisa.” ");
INSERT INTO nkn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kaha hajevene uaputukile kumona, uakavele Yesu, na kushangazala Njambi. Omo vantu vacimuene, kaha voshe vashangazalale Njambi. ");
INSERT INTO nkn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hanima yevi Yesu kukovela mu Yeliko na kuputuka kuhitanganamo. ");
INSERT INTO nkn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Muakele yala umo mu mbonge ije, uje uapuile mukuluntu ua vaka kutambula lisimo lizina liendi Sangeo, uje uapuile muka kufuka. ");
INSERT INTO nkn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Uatondele kumona Yesu, vuno honi kasele kumumona omuo uapuile uamuihi, kaha naua kuakele civunga cakama. ");
INSERT INTO nkn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaha uashatukilile kulutue lia civunga, ualondele ku muti ua linongo linga amone Yesu uje uahitilile mu ngila ijevene. ");
INSERT INTO nkn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Omo Yesu uahete ha mutambela uje, uatalele kuilu, kaha uahandekele kuli Sangeo nguendi, “shuluka vuasi Sangeo, omuo lelo njapande kuija ku njivo yove.” ");
INSERT INTO nkn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sangeo uashulukile vuasi na kumutambula na kuvuahelela cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vantu voshe vaje vamuene vialingiuile vaninguile nguavo, “Ou Yala nai kupua mungezi ku njivo ya muka vupi!” ");
INSERT INTO nkn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kaha Sangeo uemanene na kuhandeka kuli Muene Yesu nguendi, “Muene ivuilila njihana mutambela ua vufuko vuange kuli tuhutu, nga njambate cimo kuli umo mu ngila ya makuli, kaha njika mufueta vintsimbu viuana.” ");
INSERT INTO nkn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu uahandekele nguendi, “Kuovoka ku neja mu njivo muno lelo, omuo yala ou nalimuesa kupua muana ua vusunga ua Avilahama. ");
INSERT INTO nkn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mua vusunga Muna Muntu uezile nakutonda na kuovola vaje vana zimbala.” ");
INSERT INTO nkn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tele vantu vakele nakuivuilila vije Yesu uakele nakuhandeka, uavatele cisimo omuo uakele kuyehi na Yelusalema, kaha vasinganiekele nge vumuene vua Njambi hajevene vuavuno vusholoka. ");
INSERT INTO nkn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaha Yesu uahandekele nguendi, “Kuakele muntu uaku vumuene uje uaile ku lifuti lia kulahako linga vakamupuise muene, hanima yevi uasinganiekele kuhiluka linga akuendese vantu vendi. ");
INSERT INTO nkn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tele kanda aye, uasanene vangamba vendi likumi kaha uahanene umo na umo mbongo ya ngolinde na kuvaleka nguendi, ‘Landululeni noho njikeja.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Vuno honi vantu vamu lifuti liendi vamuzindile cikuma, kaha vatumine tunganda vamukave munima yendi na kukahandeka nguavo, ‘Ou yala kutumutondo linga apue Muene yetu kuahi.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Omo uje yala uahilukile, hanima ya kumuhaka kupua muene, uashikile vaje vangamba vahanene vimbongo linga veje kuli ikeye linga atantekeya cingahi vana landuluilaho. ");
INSERT INTO nkn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kaha uakulivanga uezile nakuhandeka nguendi, ‘Muene, mbongo imolika ije iuanjihanene yasemuininahoni vimbongo likumi vikuavo.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kaha uahandekele kuli ikeye nguendi, ‘Unalingi muacili cikuma, ngamba uacili! Kaha muene uahandekele kuli ikeye nguendi, omuo unakala nalutsilielo mu viuma viavindende, njikakuhana nzili yakama ya kutuamenena vimbonge likumi.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kaha uamucivali naua uezile uahandekele nguendi, ‘Muene, mbongo yove imolika ije iuanjihanene yasemuinina vimbongo vitanu.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kaha naua muene uahandekele kuli ikeye nguendi, ‘Njikakupuisa muka kutuamenena vimbonge vitanu.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kaha mukuavo ngamba uezile uahandekele nguendi, ‘Muene, mbongo yove eyi, hanga njaitulikilile akantanga kakandende. ");
INSERT INTO nkn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Njakutinine, omuo yove uapua muntu uavutenu. Ukambata cije keti cove na kuteja vije kuuakuvile.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kaha muene uahandekele kuli ikeye nguendi, ‘Yove ngamba uamupi! Njikakuhisa na mezi akuhuma mu kanua kove! Utantekeye nguove yange nji yala uavutenu, njikambata vije keti viange na kuteja vije kunjakuvile? ");
INSERT INTO nkn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Vikahoni kuua yakele kuli vaka kusekasana mbongo yange? Omo yange njineja nge njinauana mbongo yange hamo na kakondueso kayo.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kaha muene uahandekele kuli vaje vemanene kumukulo nguendi, ‘Muniekeni oyo mbongo, muihane kuli uje hali na vimbongo likumi.’ ");
INSERT INTO nkn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vuno honi vakevo vahandekele kuli ikeye nguavo, ‘Muene, hali laja na vimbongo likumi!’ ");
INSERT INTO nkn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kaha ikeye uavatavele nguendi, ‘Muavusunga njimileka nguange, uje hali naco, vakamuhakelako viavingi, vuno honi uje kesi navio, cipue vene vije viavindende viali navio vakamuniekavio. ");
INSERT INTO nkn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kaha honi ku vitozi vange, vaje kuvatondele linga yange njipue muene uavo, vaneheni kuno nakuvatsihila ha mesho ange.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Omo Yesu uamanesele kuhandeka evi, kaha uaile kulutue luavo nakuya ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Omo Yesu uahete kuyehi na Mbetefenje na Mbeteniya ku munkinda ua Oliveta, kaha uatumine vandongisi vavali kulutue, ");
INSERT INTO nkn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Uavalekele nguendi, “Yeni ku limbo lije lili kulutue lueni, omo mukakovelamo mukauana muna cimulu vanamukutu, uje kanda muntu alondeho. Kaha muzituleni mumunehe kuno.” ");
INSERT INTO nkn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nga muntu umo amihula nguendi vika mumuzituila, mulekeni ngueni Muene amutonda. ");
INSERT INTO nkn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kaha vaje vatumine vaile vakauanene muje muahandekelele Muene. ");
INSERT INTO nkn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tele vali nakuzitula uje muna cimulu, kaha vavenia cimulu uavehuile nguendi, “Vika mumuzituila ou muna cimulu?” ");
INSERT INTO nkn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kaha vamutavele nguavo, “Muene hali nakumutonda.” ");
INSERT INTO nkn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kaha vatualele uje muna cimulu kuli Yesu. Kaha vajalele tuzaku tuavo ha muongo ua cimulu, kaha valondeseleho Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Omo uakele nakuya ha cimulu, vantu vajalele tuzaku tuavo mu ngila kulutue lua Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Omo Yesu uahete kuyehi na Yelusalema, kucikulo ca munkinda ua Oliveta, kaha civunga cacingi ca vandongisi vendi vaputukile kuvuahelela na kulemesa Njambi na mezi akama ha vikomoueso vioshe viakama vivamuene vije Yesu ualingile, ");
INSERT INTO nkn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","nguavo “Uakukuisula muene uje akeja mu lizina lia Muene Njambi! Ciyulo cikale muilu na vumpau kuli Njambi!” ");
INSERT INTO nkn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kaha Vafaliseo vamo vaje vakele mu civunga vahandekele kuli Yesu nguavo, “Mulongisi, shika vandongisi vove vaholoke” ");
INSERT INTO nkn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu uavatavele nguendi, “Njimileka nguange, nga ava valikela kulemesa kaha aua mavue akaputuka kutambakana.” ");
INSERT INTO nkn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Omo Yesu uahete kuyehi na kumona Yelusalema, uailililile, ");
INSERT INTO nkn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","uahandekele nguendi, “Nga uatantekeyele lika lelo nguove vika vitondeka linga kukale ciyulo! Vuno honi vuavuno vacishuekesa ku mesho ove! ");
INSERT INTO nkn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ntsimbu ikeja hali yove, omo vitozi vove vaka kutungila cimpaka, nakukuhaka mukati kavo, na kukushetuilamo mukati ku mitambela yoshe. ");
INSERT INTO nkn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kaha vakevo vakakunongesa hamo na vantu vove vaje vali mu vivumbe viove, kuvakaseze livue limo mu muhela ualio, omuo yove kuuatantekeyele ntsimbu omo Njambi uezile nakukuovola.” ");
INSERT INTO nkn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu uakovelele mu njivo ya Njambi, na kuputuka kushekamo voshe vaje vakele na kulandesa, ");
INSERT INTO nkn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","uahandekele kuli vakevo nguendi, “Vanasoneka mu visoneka nguavio, ‘Njivo yange ikapua njivo ya Malombelo’, vuno honi yeni muaipuisa muhela ua vizi!” ");
INSERT INTO nkn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu uakele nakulongesa mu njivo ya Njambi ha litangua na litangua. Vakuluntu va tusasendote na valongisi va mezi a Lishiko lia Mosesa na vantuama va vantu vatondele kumutsiha, ");
INSERT INTO nkn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","vuno honi kuvauanene ngila yaku cilingila, omuo vantu voshe vakele naku muvuilila linga keti vasezeho cipue lizi limo. ");
INSERT INTO nkn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Litangua limo Yesu uakele nakulongesa mu njivo ya Njambi na kuambulula muzimbu uacili ku vantu, kaha vakuluntu va tusasendote na valongisi va mezi a Lishiko lia Mosesa, hamo na vakuluntu vezile. ");
INSERT INTO nkn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kaha vahandekele kuli ikeye nguavo, “Tuleke, nzili muka ukalikuasesa nayo kulinga viuma evi? Iya nakuhana nzili eyi?” ");
INSERT INTO nkn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu uavakumbuluile nguendi, “Nange naua njimihula cihula cimo. Njilekeni, ");
INSERT INTO nkn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nzili ya likuasesele Iuano muka kumbuitika ya humine kuli Njambi indi kuli vantu?” ");
INSERT INTO nkn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Vaputukile vimpata hhakati kavo nguavo, “Vika tuhandeka? Nga tuhandeka nguetu, ‘ya humine kuli Njambi,’ kaha akatuihula nguendi, ‘Vikahoni kumua mukulahelele Iuano?’ ");
INSERT INTO nkn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vuno honi nga tuhandeka nguetu, ‘Ihuminina ku vantu,’ Kaha civunga coshe ca vantu vakatutsiha mukutuasha mavue, omuo vovuisisile nguavo Iuano uapuile Kananguizi ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaha vakumbuluile Yesu nguavo, “Kututantekeya kuje kuya humine.” ");
INSERT INTO nkn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kaha Yesu uahandekele nguendi, “Nange naua kunjimileke kuihuminina nzili injili nakulikuasesa kulinga viuma evi.” ");
INSERT INTO nkn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kaha Yesu uaputukile kuleka vantu cisimo eci nguendi, “Kuakele yala umo uakele na citungu ca mikolovozi ya vushuka vua viniu, kaha uacikumuisile kuli vandimi vamo, kaha uaile vungezi vuendi ha ntsimbu yalaha. ");
INSERT INTO nkn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Omo ntsimbu ya kuteja vushuka yahete, uatumine ngamba uendi kuli vaje vandimi, muku katambulako mutambela uendi kuli vije vanateje. Vuno honi vaje vandimi vapupile uje ngamba, na kumuhiluisa mavoko voko. ");
INSERT INTO nkn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaha uje vavenia citungu uatumineko naua ngamba mukuavo, vuno honi vaje vandimi vamupupile na kumulinga mua mupi, kaha uamuhiluisile mavoko voko. ");
INSERT INTO nkn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Uatumineko naua ngamba uamu citatu, kaha vaje vandimi vamu vulumuine naua nakumumbila hambaza lia citungu. ");
INSERT INTO nkn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kaha honi vavenia citungu uahandekele nguendi, ‘Njilinga vati? Njikatuma munange injazanga, hamo vaka musingimika!’ ");
INSERT INTO nkn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Vuno honi omo vandimi vamumuene, kaha valihandekesele hhakati kavo nguavo, ‘Ou ikeye muna uje vavenia citungu. Ijeni tumutsihe, kaha tukafungulula vufuko vuendi!’ ");
INSERT INTO nkn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nkuma, vamumbilile hambaza lia citungu, kaha vamutsihile.” Yesu uavehuile nguendi, “Vika akalinga uje vavenia citungu kuli vaje vandimi? ");
INSERT INTO nkn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Akeja na kutsiha vaje vantu na kuhana cije citungu kuli vandimi veka.” Kaha omo vantu vavuile evi, vahandekele nguavo, “Mua vusunga vene keti ngoco kuahi!” ");
INSERT INTO nkn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu uavatalele nakuvehula nguendi, “Visoneka vilumbunuka vika omo vihandeka nguavio, ‘Livue lije livavianene vaka kutunga ngue kuliesi na seho likelio vuavuno linapu liaseho kupulaka mavue oshe’? ");
INSERT INTO nkn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kaha uoshe uje akauila ha livue lije akapokoka, vuno honi nga lije livue lika uila hali muntu umo, likamusaniuna.” ");
INSERT INTO nkn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kaha valongisi va mezi a Lishiko lia Mosesa na tusasendote vayonguele kukuata Yesu haje vene, omuo vatantekeyele nguavo cisimo eci nacitela vakevo, vuno honi vateuele vantu. ");
INSERT INTO nkn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nankuma, vatatele ntsimbu ya cili. Kaha vahanene lizika kanua kuli vantu vamo valipuise nge vaka vusunga, kaha va vatumine kuli Yesu linga vakamueseke na vihula linga vamuhane ku mavoko a Nguvulu ua Maloma. ");
INSERT INTO nkn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kaha vaje vavatumine vehuile Yesu nguavo, “Mulongisi tuatantekeya nguetu yove ukahandeka vusunga na kulongesa vusunga naua kuue kutala hali muntu cipue uapua ua vulemu, cipue keti ua vulemu vuno honi ntsimbu yoshe ukalongesa vantu vusunga muje muatondela Njambi vayoyemo. ");
INSERT INTO nkn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tuleke, nkuma Lishiko lietu litutavesa kufueta lisimo kuli Sezale indi kuahi?” ");
INSERT INTO nkn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Vuno honi Yesu uatantekeyela kuzangama kuavo, kaha uahandekele kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Njimueseni mbongo ya siliva. Cihanga ceya na lizina lieya viliho?” Kaha vamukumbuluile nguavo “via Sezale!” ");
INSERT INTO nkn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kaha Yesu uahandekele kuli vakevo nguendi, “Muacili, haneni kuli Sezale vije viapande kuli Sezale, kaha haneni kuli Njambi vije viapande kuli Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kaha kuvasele kumu uanenaho mulonga ha mezi aua ku mesho a vantu. Valikomokelele ku kukumbulula cendi kaha vaholokele kuluu. ");
INSERT INTO nkn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kaha Vasanduki vamo, vaje vakulahela nguavo vantu kuvakasanguka ku vatsi, vezile kuli Yesu nakumuihula nguavo, ");
INSERT INTO nkn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mulongisi, Mosesa uatusonekelele Lishiko eli nguendi, ‘Nga yala atsa, kaha aseza mpuevo yendi vuno honi kesi na vana, kaha munaina ambate uje ntuluue linga vakase kukala na vana va uje natsi.’ ");
INSERT INTO nkn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kuakele vamuanaye vatanu na vavali, kaha uje uamukuluntu uambate mpuevo, uatsile kuakuhona vana. ");
INSERT INTO nkn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kaha uje ua mucivali uambate uje mpuevo naua uatsile kuakuhona vana ");
INSERT INTO nkn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kaha mucitatu naua. Cuma cimo cafuile mujevene kuli voshe vatanu na vavali, voshe vatsile kuakuhona vana. ");
INSERT INTO nkn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kaha kukumanusuila uje mpuevo uatsile. ");
INSERT INTO nkn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nankuma, ha litangua lije omo vatsi vaka sanguka, uje mpuevo akapua ueya hhakati kavaje voshe vamuambate vatanu na vavali?” ");
INSERT INTO nkn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu uavakumbuluile nguendi, “Vantu va lifuti lino vakambata na kushombuesa naua, ");
INSERT INTO nkn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","vuno honi vampuevo na vamala vaje vapande kusanguka ku vatsi na kuyoya mu ntsimbu ije ikeja kulutue kuva kambata cipue kushomboka. ");
INSERT INTO nkn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vakevo vakapua ngue tungelo kuvakasa naua kutsa omuo vanapu vana va Njambi, omuo vanasanguka kuvatsi. ");
INSERT INTO nkn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesa nahana vukaleho linga vatsi vaka sanguka. Mu visoneka vije vihandeka via lifo liakele nakuuema Mosesa ahandeka hali Muene Njambi ikeye vene ‘Njambi ya Avilahama, Njambi ya Isake, na Njamba ya Yakomba.’ ");
INSERT INTO nkn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ikeye uapua Njambi ua vaka kuyoya, keti ua vaka kutsa kuahi, omuo ku mesho a Njambi voshe vantu vendi vayoya.” ");
INSERT INTO nkn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kaha vamo valongisi va mezi a Lishiko lia Mosesa vahandekele nguavo, “Mulongisi, uakumbulula muacili!” ");
INSERT INTO nkn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kuhuma ha ntsimbu ije kuvasele naua kuihula Yesu vihula vieka. ");
INSERT INTO nkn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu uavehuile nguendi, “Vatihoni vali nakuhandeka nguavo, Kilistu akapua ua ku ntanga ya muene Ndaviti? ");
INSERT INTO nkn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ndaviti vavenia nahandeka mu livulu lia miaso nguendi, ‘Muene Njambi uahandekele kuli Muene uange nguendi, Tumama ku livoko liange lia cilio, ");
INSERT INTO nkn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","noho njikapuisa vitozi vove ngue cituamo caku viliato viove.’ ");
INSERT INTO nkn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ndaviti ikeye vavenia uamutumbuile nguendi, ‘Muene,’ vatihoni Kilistu apua mutekulu lia Ndaviti?” ");
INSERT INTO nkn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaha omo civunga ca vantu vakele nakuvuilia, kaha Yesu uakele nakuhandeka kuli vandongisi vendi nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Zangameni kuli valongisi va mezi a Lishiko lia Mosesa, vaje vazanga kuenda na vikovelo viavo via laha viandando na kutsetsela na kasingimiko mumihela yakulandesela na kuhangula vituamo viacili mu vinjivo via Njambi via malombelo na mihela ya vantu va vulemu ku viuano. ");
INSERT INTO nkn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Vakevo vakakuisi vantuluue na kuvevila vinjivo viavo, kaha vashueka vilinga viavo na malombelo alaha! Kaha nakuzangamesa kuavo kukapu kuakama cikuma!” ");
INSERT INTO nkn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Litangua limo omo Yesu uakele nakutalazeka, uamuene vaka kufuka vali nakuhana mulambu uavo mu njivo ya Njambi, ");
INSERT INTO nkn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","kaha naua uamuene ntuluue umo ua cihutu uahanene tumbongo tuvali. ");
INSERT INTO nkn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaha Yesu uahandekele nguendi, “Mua vusunga njimileka nguange, ou ntuluue ua cihutu nahana viavingi kupulakana voshe vaje vantu vakufuka, ");
INSERT INTO nkn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","njahandeka evi omuo veka vanakala nakulambuila via kusalaho ku vufuko vuavo, vuno honi ou mpuevo nalambuila vioshe vianakele navio via kulikuasa navio.” ");
INSERT INTO nkn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vamo va vandongisi va Yesu vakele nakuhandeka ha njivo ya Njambi, ha vucili vua mavue aje vaitungisile, na vuana vuje vakele nakuhana mukuivuahesa, kaha Yesu uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Maneni njimileke ha viuma vioshe evi munamono. Ntsimbu ikaheta omo vitozi veni vaka humisa livue lioshe lia njivo mu muhela uhalio, kaha mavue oshe a ka siuka.” ");
INSERT INTO nkn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Vandongisi va Yesu vamuihuile nguavo, “Mulongisi, muaka muka evi viuma vikalingika?” Na cimueso muka tukatantekeya naco nguetu ntsimbu inahete ya viuma vioshe evi vilingiue. ");
INSERT INTO nkn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu uahandekele kuli vakevo nguendi, “Zangameni keti vamikuise. Vantu vavengi vakeja mu lizina liange na kuhandeka nguavo, ‘Yange vene ikeye!’ Kaha naua nguavo, ‘Ntsimbu inahete vuavuno!’ Vuno honi keti mukava kavangeye. ");
INSERT INTO nkn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Omo mukevua vizita na kulitengulukila, keti mukateue, viuma evi vinapande kulingika tahi, vuno honi kuvilumbunuka nge kuhua kua mavu kunahete.” ");
INSERT INTO nkn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaha Yesu uahandekele naua nguendi, “lifuti likalua nzita na lifuti likuavo, kaha vumuene vukalua na vumuene vukuavo. ");
INSERT INTO nkn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kukala mandundumua, na njala yakama, na mishongo ya kulitambuisa kuoshe, kukakala viuma viakuteuesa na vitantekeyeso viaku komouesa vikahuminina muilu. ");
INSERT INTO nkn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Omo ntsimbu kanda viuma evi visholoke. Vakamikuata na kumiyandesa, vakamituala kuvi njivo via malombelo avo naku kamiyula naku mihaka mutumenga, kaha vakamituala ku vimiene naku vanguvulu mukunieseka omuo lizina liange. ");
INSERT INTO nkn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ikapua ntsimbu yacili kuli yeni ya kuambulula Muzimbu ua Cili. ");
INSERT INTO nkn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nankuma, vihakeni mu mitima yeni keti muvisinganiekele vualumo ngueni vika tukahandeka, ");
INSERT INTO nkn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","omuo njikamihana mana akutantekeya vije vimukahandeka linga vitozi veni kuvakasa kumihisa cipue kuviana vimukahandeka. ");
INSERT INTO nkn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cipue visemi vieni, na vamuanoko, na vavushoko veni na vavusamba veni vakamienda vungungu. Kaha vamo hhakati keni vaka vatsiha. ");
INSERT INTO nkn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaha voshe vakamizinda omuo lizina liange. ");
INSERT INTO nkn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Vuno honi cipue cinkambu cimo ca kumutue ueni ku cikazimbala. ");
INSERT INTO nkn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Takameseni, kaha mukohiela miono yeni. ");
INSERT INTO nkn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Omo mukamona Yelusalema vana izengeleka ku civunga ca masualale, tantekeyeni ngueni kunonga kuayo kuli muyehi. ");
INSERT INTO nkn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nankuma, vaje vali mu Yundeya vapande kuteuela ku minkinda, kaha vaje vali mu mbonge vapande kuhumamo, kaha Vaje vali hambaza ya mbonge naku mehia vapande keti vakovelemo mu mbonge. ");
INSERT INTO nkn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aua akeuo matangua akuzangamesa, vivahandekele mu visoneka linga vilishulisise. ");
INSERT INTO nkn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Luvinda ku vampuevo vaje vakakala na mazimo na vampuevo vaje vaka jamuesa ha ntsimbu ije! Tuyando tuakama tukeja ha lifuti eli, na vukalu vua Njambi vukeja hali vantu ava. ");
INSERT INTO nkn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kaha vamo vaka vatsiha na mukuale, kaha vakuavo vakavatuala ku vunzinda ku mafuti eka, kaha vaje keti Vayunda vaka pihisa Yelusalema noho ntsimbu yavo ikaheta. ");
INSERT INTO nkn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kaha viuma via kukomouesa vikapangiua ku litangua naku ngonde naku vingongonosi. Vantu voshe vaha mavu vakevua liova lia kuohia kua mema a kalunga na kukuma kua mankimba kaha kuvakatantekeya vivakalinga. ");
INSERT INTO nkn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vantu vaka lezimuka kuliova omo vakatatela vije vikasholoka hano ha mavu oshe, omuo viuma vioshe via muilu vikalininganga. ");
INSERT INTO nkn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kaha vakamona Muna Muntu akeja mu mashuelua na nzili na vumpau vuakama. ");
INSERT INTO nkn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Omo viuma evi vikaputuka kupangiua, katukeni nanzili na kutala kuilu, omuo kuohela kueni kuli hayehi.” ");
INSERT INTO nkn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kaha Yesu uavatelele cisimo eci nguendi, “Singaniekeni ha muti ua mukuyu na miti yeka yoshe. ");
INSERT INTO nkn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Omo mumona mafo auo aputuka kuzovelela, muapande kutantekeye ngueni ntondue ili muyehi. ");
INSERT INTO nkn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kaha mucifua aci vene, omo mukamona viuma evi vipangiua mutantekeye ngueni vumuene vua Njambi vuli muyehi. ");
INSERT INTO nkn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Muavusunga njimileka, viuma vioshe evi vikapangiua oku vantu voshe va ntsimbu ino vaciyoya. ");
INSERT INTO nkn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Melu na mavu vikahita, vuno honi mezi ange kuakahiti. ");
INSERT INTO nkn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Zangameni! Keti mushoshomue cikuma mitima yeni ha ciuano viakulia na kunua na kulinienga ha viuma vije via lifuti. Nga muvilinga litangua lije lika miniangumuna ngue mukapiluka muheto. ");
INSERT INTO nkn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Litangua lije likeja ku vantu voshe vali hano ha mavu. ");
INSERT INTO nkn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Livuaheseleni na kulombela ntsimbu yoshe linga mukakale na nzili yakuhiana vioshe vije vikapangiua na kuimana ku mesho a Muna Muntu.” ");
INSERT INTO nkn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu uakale na kulongesa mu njivo ya Njambi ha matangua aje, kaha kuheta ku ntsimbu ya cinguezi, uakele nakuhumamo na kuya ku munkinda ua Oliveta kukakalako vutsiki vuoshe. ");
INSERT INTO nkn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kucimenemene coshe vantu voshe vakele nakuya mu njivo ya Njambi na kumuivuilila. ");
INSERT INTO nkn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Omo ntsimbu yahete kuyehi ya ciuano ca kulia mbola ya kuhona cimbaluila, civasana nguavo Ciuano ca Paseka. ");
INSERT INTO nkn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kaha vakuluntu vatusasendote na valongisi va mezi a Lishiko lia Mosesa vatondele ngila ya vushueke ya kutsilamo Yesu omuo vakele na liova lia vantu. ");
INSERT INTO nkn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kaha Satana uakovelele muli Yundasa ivasana Sakaliote, umo uavaje likumi na vavali ua vandongisi. ");
INSERT INTO nkn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kaha Yundasa uaile na kukahande kuli vakuluntu vatusasendote na vaka kuniunga Njivo ya Njambi, uavamuesela ngila yakuendela Yesu vungungu. ");
INSERT INTO nkn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kaha vakevo vavuahelelele cikuma, valitaivatumbuile nendi kumuhana vimbongo. ");
INSERT INTO nkn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yundasa uatavele, kaha uatalazekele ngila imo ya kuendelamo Yesu vungungu kua kuhona vantu kutantekeya. ");
INSERT INTO nkn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Litangua liete ha ntsimbu ya ciuano ca mbolo ya kuhona cimbaluila, omo vatsihile vana va vampanga vakulia ha Ciuano a Paseka. ");
INSERT INTO nkn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu uatumine Petulu na Iuano nguendi “Yemuye muka vuahesele vualumo mutu kalila Ciuano ca Paseka.” ");
INSERT INTO nkn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kaha vamuihuile nguavo, “Kuli ku utonda linga tuka civuaheleseko?” ");
INSERT INTO nkn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kaha uavakumbuluile nguendi, “Omo mukakovela mu mbonge, muka uana muntu nambata njava ya kutekuila mema. Mukaveni noho akaheta mu njivo ya kakovela. ");
INSERT INTO nkn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Handekeni kuli vavenia njivo ngueni, ‘Mulongisi natutumu kukuihula nguendi, cilikuli cihela cituakulila yange na vandongisi vange Ciuano ca Paseka?’ ");
INSERT INTO nkn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kaha akamimuesa cihela cakama helu lia njivo, vanauvuahesa vualumo, kuje mukavuahese viakulia.” ");
INSERT INTO nkn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kaha vaile vauanene viuma vioshe nge muavalekelele Yesu, vavuahesele viakulia via Ciuano ca Paseka. ");
INSERT INTO nkn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kaha omo ntsimbu ya hete Yesu uatumamene ku mesa hamo na tunganda vendi. ");
INSERT INTO nkn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kaha uahandekele kuli vakevo nguendi, “Njatondele cikuma kulia eci Ciuano ca Paseka hamo neni ntsimbu kanda njiyande, ");
INSERT INTO nkn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","omuo njimileka nguange, kuhuma lelo kunjikacili naua kuvanga noho calishulisilila muacili mu Vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kaha Yesu uanonele hambanza ya viniu, kaha uahandekele kuli Njambi, na kuhandeka kuli vandongisi vendi nguendi, “Ambateni hambanza eyi mulishumuine hhakati keni. ");
INSERT INTO nkn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Njimileka nguange, kuhuma lelo kunjikanu naua neni viniu kuvanga noho vumuene vua Njambi vuneja.” ");
INSERT INTO nkn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kaha uambate naua mbolo uakandelele kuli Njambi, kaha uaitavuile uava haneneyo nguendi, “ Ei inapu muvila uange uvanahana ha yeni. Lingelingeni eci mukunjivuluka yange.” ");
INSERT INTO nkn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Omo vamanesele kulia uambate kambanza uahandekele nguendi, “Eyi kambanza inapu litavasano lihaliha lia Njambi livanakutu na maninga ange aje ahitikila hali yeni. ");
INSERT INTO nkn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Vuno honi taleni! Ou anjenda vungungu hali hamo nange kuno ku mesa! ");
INSERT INTO nkn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Muna Muntu akatsa nge muje muasinganiekelemo Njambi, vuno honi tuyando tuendi uje akamuenda vungungu!” ");
INSERT INTO nkn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kaha vandongisi vendi vaputukile kulihozola hhakati kavo nguavo, iya honi akalinga cuma eci. ");
INSERT INTO nkn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kaha kuaputukile vimpata hhakati ka vandongisi va Yesu nguavo, iya umo hhakati kavo napu uakama kupulakana. ");
INSERT INTO nkn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kaha Yesu uandekele kuli vakevo nguendi, “Vamiene va vaje keti Vayunda vali na nzili ha vantu vavo. Kaha vaje vaka kushika vavatumbula vakuasi va vantu.” ");
INSERT INTO nkn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Vuno honi ei keti ikeyo ngila hhakati keni, vuno honi uoshe uje uakama hhakati keni napande kupua uamundende, kaha ntuama yeni napande kupua ngue ngamba. ");
INSERT INTO nkn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iya uakama kupulakana? Uje natumama kukulia cipue uje hamuhana viakulia? Nguetu uje natumama kukulia ikeye uakama ndi? Vuno honi yange njili hakati keni nguange muka kuhana viakulia. ");
INSERT INTO nkn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yeni munakala nange mu tuyando tuange tuoshe. ");
INSERT INTO nkn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nge mua nanjihanena Tate nzili ya kuyula, neni naua njikamihana nzili yakuyula. ");
INSERT INTO nkn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Linga yeni mukalie na kunua mu vumuene vuange, kaha mukatumama ku vituamo vua vumuene na kuyula miyati likumi na ivali ya Isaleli. ");
INSERT INTO nkn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni! Ivuilila, Satana atonda linga amieseke yeni mu vavoshe, ku hangununa vacili ku vavapi nge muka kulima muaka hangununa tiliku ku mujungu. ");
INSERT INTO nkn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Vuno honi yange njakulombelela linga lutsilielo luove keti luhue. Kaha omo ukatenguluka na kuhiluka kuli yange, unapande kukolesa vamuanoko. ");
INSERT INTO nkn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kaha Simoni Petulu uamukumbuluile nguendi, “Muene, njalivuahesela laja kuya mu kamenga nove na kukatsa nove!” ");
INSERT INTO nkn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kaha Yesu uamukumbuluile nguendi, “Muavusunga, Petulu” njikuleka nguange, “vutsiki vuno vene kanda ndemba atambeke, ukanjiviana lutatu.” ");
INSERT INTO nkn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu uehuile vandongisi vendi nguendi, “Muje njamitumine cakuhona cikuama, ngonga cipue vinkaku muahonoueleko cuma cimo ndi?” Kaha vamukumbuluile nguavo, “houe!” ");
INSERT INTO nkn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kaha Yesu uahandekele kuli vakevo nguendi, “Vuno honi” ntsimbu ino, “Ou hali na cikuama cipue ngonga napande kuambata, kaha uoshe nahonoua mukuale napande kulandesa kazaku kendi alande mukuale. ");
INSERT INTO nkn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Muomu vanacisoneka nguavo, ‘Vamutandelele kumo na vaka kushaula Lishiko.’ Kaha njimileka nguange eci cinapande kulishulisisa hali yange. Eyo vioshe vije vivanasoneka hali yange vili nakulishulisisa.” ");
INSERT INTO nkn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kaha vandongisi vahandekele nguavo, “Muene tala! Kuli mikuale ivali ei!” Kaha uavakumbuluile nguendi, “Mukemo vene!” ");
INSERT INTO nkn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kaha Yesu uahumine mu mbonge, kaha uaile ku munkinda ua Oliveta nge muakele nakulingilamo. Kaha vandongisi vendi vamukavele. ");
INSERT INTO nkn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Omo uahete kuje uavalekele nguendi, “Lombeleni linga keti mukovele muvieseko.” ");
INSERT INTO nkn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kaha uahumine kavundende kuli vakevo kaha uatsikamene na kulombela, ");
INSERT INTO nkn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","nguendi, “Tate nga mutonda hambanza eyi ya tuyando ihite kulahako nange. Keti nge ku cizango cange kuahi, vuno honi cizango cove cilingiue. ");
INSERT INTO nkn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kangelo uahumine kuilu uasholokele kuli ikeye na kumusimpisa. ");
INSERT INTO nkn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Omuo ha tuyando tuakama ua lombelele cikuma, kaha ntuima yendi yapuile ngue mambase a maninga anduekelele ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kaha omo uakatukile kuhuma ku kulombela, uaile kuli vandongisi vendi uavauanene vanakosa tulo, omuo vazeyele na vusiua. ");
INSERT INTO nkn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kaha uahandekele kuli vakevo nguendi, “Vikahoni muakosela? Hindukeni mu lombele, linga keti mukovela muvieseko.” ");
INSERT INTO nkn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kaha te Yesu uakele nakuhandeka navo, hajevene civunga ca vantu cahete. Yundasa Sakaliote uje uava likumi na vavali uatuamene kulutue luovo. Kaha uashuenene kuli Yesu na kumuntsuemba. ");
INSERT INTO nkn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kaha Yesu uahandekele kuli ikeye nguendi, “Yundasa nkumani yove uenda Muna Muntu vungungu na kumutsuemba ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kaha omo vandongisi vaje vakele hamo na Yesu vamuene vije viapangikile vahandekele nguavo, “Muene tulikuasese mikuale ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kaha umo ua vandongisi va Yesu uavatuile lituitui lia ngamba ua kasasendote uakama. ");
INSERT INTO nkn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Vuno honi Yesu uamu vianesele nguendi, “Ecela” kaha uakuate lituitui lia uje yala nakulihiluisilako naua. ");
INSERT INTO nkn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kaha Yesu uahandekele kuli vaje vakuluntu va tusasendote na vamo vakuluntu va vaka kuniunga njivo ya Njambi na vakuluntu vaje vezile na kumukuata nguendi, “Nkumani muneja namikuale na vimbueti ngue njimuizi ndi? ");
INSERT INTO nkn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Njinakele neni mu njivo ya Njambi ha matangua oshe vikahoni kumuanjikuate. Vuno honi eyi ikeyo ntsimbu yeni yakuipanga, omo nzili ya milima ili nakuhiana.” ");
INSERT INTO nkn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Vakuate Yesu kaha vamutualele ku njivo ya Kasasendote uakama, kaha Petulu uamukavele munima uakele kulahako. ");
INSERT INTO nkn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vamo vavuekele tuhia mukati ka cipango vatumamene nakuota, kaha Petulu uatumamene navo. ");
INSERT INTO nkn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Omo ngamba umo uampuevo uamuene Petulu natumama kuje ku tuhia, uamutalele ntoma, kaha uahandekele nguendi, “Yala ou naua uakele hamo na Yesu.” ");
INSERT INTO nkn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Vuno honi Petulu uavianene nguendi, “Yove mpuevo yange kunjimutantekeya!” ");
INSERT INTO nkn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kaha omo kuahitile ka ntsimbu kakandende, yala ueka naua uamuene Petulu, kaha uahandekele nguendi, “Nove naua ua umo vendi” Vuno honi Petulu uamukumbuluile nguendi, “Yala, kuahi, keti yange!” ");
INSERT INTO nkn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Omo kuahitile ola lika, kaha yala mukuavo naua uahandekele nanzili nguendi, “Ou yala cilivene uakele hamo na Yesu, nendi naua Kangalileya!” ");
INSERT INTO nkn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Vuno honi Petulu uamukumbuluile nguendi, “Yove yala yange kunjitantekeya evi ulinakuhandeka!” Hajevene te acili nakuhandeka kaha ndemba uatambekele. ");
INSERT INTO nkn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kaha Yesu uatengulukile uatalele kuli Petulu, kaha Petulu uavulukile vije via mulekele Yesu nguendi, “Ntsimbu kanda ndemba atambenge vutsiki vunovene ukanjiviana lutatu” ");
INSERT INTO nkn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kaha Petulu uatuhukile hambanza na kulila cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vamala vaje vaniungile Yesu vamushendumuine na kumupupa. ");
INSERT INTO nkn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vamukitile tanga ha mesho, kaha vahandekele kuli ikeye nguavo, “Nga ukananguizi, tuleke! Iya na kupupu?” ");
INSERT INTO nkn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vahandekele viuma viavingi via kumushaula. ");
INSERT INTO nkn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kaha omo kuacele vakuluntu voshe va vantu valiuanene hamolika. Vakuluntu va tusasendote, na valongisi va mezi a Lishiko lia Mosesa voshe kuvakele, kaha vanehele Yesu ku mpunga yavo. ");
INSERT INTO nkn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kaha vamuihuile nguavo, “Tuleke, yove Kilistu ndi?” Kaha Yesu uavakumbuluile nguendi, “Cipue nga njimileka nguange yange, kumukanjikulahela.” ");
INSERT INTO nkn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kaha naua nga njimihula cihula, kumukasa kunjitava. ");
INSERT INTO nkn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vuno honi hume lelo nakutuala kulutue Muna Muntu akatumama ku livoko lia cilio lia Njambi muka nzili yoshe. ");
INSERT INTO nkn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kaha voshe vamuihuile nguavo, “Nkuma yove u Muna Njambi ndi?” Ikeye uavakumbuluile nguendi, “Mumu nahandeka mukemo vene.” ");
INSERT INTO nkn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kaha vahandekele nguavo, “Vikahoni tutondela naua vukaleho vueka? Yetu vavenia tualivuila laja muanacihandeka.” ");
INSERT INTO nkn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kaha mpunga yoshe yakatukile na kutuala Yesu kuli Nguvulu Pilato. ");
INSERT INTO nkn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kaha vaputukile kumuvangeya nguavo, “Tuauana ou yala aleka vantu vetu linga valuise Fulumende yetu, alina kuvavindika kufueta lisimu kuli Sezale na kulihandeka ikeye vavenia nguendi ikeye Kilistu Muene uetu.” ");
INSERT INTO nkn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kaha Pilato uamuhulisile nguendi, “Yove Muene ua Vayunda ndi?” Yesu uamukumbuluile nguendi, “Munahandeka mukemo vene.” ");
INSERT INTO nkn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kaha Pilato uahandekele ku tusasendote vakama na civunga nguendi, “Yange kunjauanene mulonga kuli ou muntu.” ");
INSERT INTO nkn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Vuno honi vakevo vahandekele na nzili nguavo, “Ikeye alinakulinga mpindakano ku vantu na vilongesa viendi linga valuise Yundeya yoshe. Uaputukilile mu Ngalileya, kaha hano vene nejakuno.” ");
INSERT INTO nkn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Omo Nguvulu Pilato uevuile eci, kaha ueuile nguendi, “Nkuma ou yala ka Ngalileya ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Omo Pilato uatantekeyele nge Yesu uahumine ku nganda ije yakele nakuyula Muene Helonde naua mukemo muakele, kaha uamutumine kuli Muene Helonde, uje uakele mu Yelusalema ha ntsimbu ije. ");
INSERT INTO nkn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Muene Helonde uavuahelele cikuma omo uamuene Yesu, omuo uovuile viendi na laja uakele nakutonda cikuma kumumona. Uakele nalishungu lia kumona Yesu alinga vikomouesa. ");
INSERT INTO nkn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kaha Muene Helonde ueuile Yesu vihula viavingi, vuno honi Yesu katavele cipue lizi limo. ");
INSERT INTO nkn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kaha vakuluntu va tusasendote na valongisi va mezi a Lishiko lia Mosesa vaile kulutue nakuvangeya Yesu muakama. ");
INSERT INTO nkn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kaha Muene Helonde na masualale vendi vamushendumuine naku mupanga mua mupi, kaha vamuzikile mukanjo uandando, kaha Helonde vamuhiluisile kuli Pilato. ");
INSERT INTO nkn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kaha ha litangua lije vene Helonde na Pilato valikuate vusamba, te kanda lievi vapuile muntu na citozi cendi. ");
INSERT INTO nkn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato uasanene hamo vakuluntu va tusasendote na vantuama na vantu, ");
INSERT INTO nkn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kaha uahandekele kuli vakevo nguendi, “Muanehe ou yala kuli yange na kuhandeka ngueni alinakulekesa vantu linga valuise Fulumende. Ivuilileni, yange njamuihuile ku mesho eni, kaha kunjauanene mulonga ua cuma cimo cacipi cimunamuvangeya. ");
INSERT INTO nkn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Cipue Helonde kauanene mulonga muli ikeye mukemo namuhiluisa kuli yetu. Ou yala kukuesi cuma canalingi linga va muuaneneho mulonga ua kutsa. ");
INSERT INTO nkn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Njikamupupa lika kaha njikamuecela linga aye.” ");
INSERT INTO nkn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kuakele cilika cavo cije Pilato uatondele kuhumisila vantu cinzinda umo mu kamenga uje ivatondele ha ntsimbu ya Ciuano ca Paseka. ");
INSERT INTO nkn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kaha civunga coshe ca vantu ca tambakanene nguavo, “mutsihe!” Tuzituile Mbalambasa. ");
INSERT INTO nkn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Mbalambasa vamuhakele mu kamenga omuo uakele nakuluisa Fulumende mu mbonge na kuntsiha vantu.) ");
INSERT INTO nkn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Vuno honi Pilato uatondele kuecela Yesu, kaha uahandekele naua ku civunga. ");
INSERT INTO nkn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Vuno honi vakele nakutambeka nguavo, “Mushukike ha cilindakano! Mushukike ha cilindakano!” ");
INSERT INTO nkn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kaha Pilato uahandekele naua lua mucitatu nguendi, “Vupi muka vuanapanga? Yange kunjauanene cuma cimo ca kumutsihila! Njimupupa lika na kumuecela aye.” ");
INSERT INTO nkn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Vuno honi vantu vatualeleleho kutambeka nguavo Yesu vamushukike ha cilindakano, kaha hakutambeka nguavo uavahaneneye. ");
INSERT INTO nkn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nankuma, Pilato uatete cije cimpande, ngue muvalombele vakevo. ");
INSERT INTO nkn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kaha Pilato uecelele Mbalambasa muntu ivatondele, uje uakele mu kamenga ha mulonga ua kuluisa Fulumende na kutsiha vantu. Kaha uavahanene Yesu linga vamulinge muje muvatondelele vavenia. ");
INSERT INTO nkn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kaha masualale vatualele Yesu mukumushukika te vali nakuya valiuanene na yala umo ua lizina lia Simoni uaku Silene, uje uezile mu mbonge kuhuma ku mehia. Kaha vamukuate nakumutuika cilindakano ca Yesu kaha vamulekele linga akave Yesu munima. ");
INSERT INTO nkn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Civunga cakama ca vantu ca mukavele, hhakati kavo hakele vampuevo vaje vakele nakulilila ikeye cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu uatengulukile kuli vakevo nakuhandeka nguendi, “Yeni vampuevo vamu Yelusalema! Keti mulile yange vuno honi lilileni yeni vavenia na vana veni. ");
INSERT INTO nkn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaha matangua alina kuija omo vantu vakahandeka nguavo, ‘Vanakuisuliua vaje vantsimpi, vaje kuvasemene tukeke na vaje kuvalelele.’ ");
INSERT INTO nkn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ikapua ntsimbu ije vantu vakahandeka ku minkinda nguavo, ‘Tuuileni! Naku malundu nguavo, tufuikeni!’ ");
INSERT INTO nkn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nga valinga viuma evi ku muti uakutontola, kaha honi cikafua vati ku muti uakuma?” ");
INSERT INTO nkn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kaha naua kuakele mihuza vavali va vamala vavatualele hamo na Yesu na kuvashukika. ");
INSERT INTO nkn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Omo vahete kumuhela vatumbuile nguavo, “Cikola,” kaha vashukikile Yesu ha cilindakano na vaje mihuza vavali umo ku livoko lia cilio mukuavo ku livoko lia cimoshue. ");
INSERT INTO nkn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu uahandekele nguendi, “Tate vakonekele! Omuo kuvatantekeya cije civali nakulinga.” Kaha masualale valipangezelele vuzalo vuendi na kuta nkela. ");
INSERT INTO nkn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kaha vantu vemanene kuje nakutalela te vantuama va Vayunda vamushendumuine nguavo, “Uovuele vakuavo, nendi aliovole ikeye vavenia nga ikeye Kilistu uje ya nahangula Njambi!” ");
INSERT INTO nkn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kaha masualale vamushendumuine naua vezile hayehi kuli ikeye vamuhanene viniu via kushasha. ");
INSERT INTO nkn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Vahandekele kuli ikeye nguavo, “Liovole yove vavenia nga u Muene ua Vayunda!” ");
INSERT INTO nkn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Helu lia cilindakano cendi hakele mezi aua nguavo, “Ou ikeye Muene ua Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kaha muhuza umo ivamushukikile hamo nendi uahandekele lizi lia kumushaula nguendi, “Nkumani keti yove Kilistu ndi? Liovole yove vavenia netu naua utuovolo!” ");
INSERT INTO nkn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kaha uje mukuavo muhuza uamutenukilile nguendi, “Nkuma yove kuuteue Njambi ndi? Yove unambata cihiso ngue ikeye. ");
INSERT INTO nkn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Cihiso cetu cinatupande, omuo tunambata fueto ya vilinga vuetu, vuno honi yala ou kesi na vupi.” ");
INSERT INTO nkn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kaha uahandekele kuli Yesu nguendi, “Yesu njivuluke omo ukeja mu vumuene vuove.” ");
INSERT INTO nkn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu uamukumbuluile nguendi, “Mua vusunga njikuleka nguange lelo vene ukakala hamo nange mu vumuene vua muilu.” ");
INSERT INTO nkn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Omo ntsimbu yapuile hhakati ka litangua, kaha litangua liazivalele kuakekele milima mu lifuti lioshe ije yakeleko noho ha ola ya citatu ya cinguezi. ");
INSERT INTO nkn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kaha ntanga ije yakele mu njivo ya Njambi yatavukile hhakati kuhuma kuilu na mavu. ");
INSERT INTO nkn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kaha Yesu uatambekele na lizi liakama nguendi, “Tate! Njihaka muono uange mu mavoko ove.” Hanima yakuhandeka mezi aua uatsile. ");
INSERT INTO nkn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Omo mukuluntu ua masualale uamuene vije via lingiuile, ualemesele Njambi nakuhandeka nguendi, “Mua vusunga yala ou uapuile muka vusunga.” ");
INSERT INTO nkn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Omo vantu vaje vakungulukilile kuje ku muhela vamuene viuma vije valingiuile, kaha vahilukile ku vinjivo viavo vali pupangele ha vintulo viavo mu vusiua. ");
INSERT INTO nkn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kaha voshe vaje vatantekeyele Yesu ha mutuntu uendi hamo na vampuevo vaje vamukavele kuhuma ku Ngalileya vemanenene kulahako nakutala viuma evi. ");
INSERT INTO nkn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kuakele yala umo lizina liendi Yosefa uaku mbonge ya Alamatiya mu nganda ya Yunda. Uapuile yala uacili ua kasingimiko, ");
INSERT INTO nkn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","uje uakele nakutalelela kuija kua vumuene vua Njambi. Cipue vene uapuile umo uamu mpunga, katavele ku vutumbe vuavo vua kuluisa Yesu na vilinga viavo. ");
INSERT INTO nkn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uaile kuli Pilato nakulomba muvila ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Uahumisile muvila ua Yesu ha cilindakano, kaha uauzengelele ha ntanga ya liniu, kaha ualangekele muvila ua Yesu mu cihilo cije civa cokuele mu livue lije kanda vantsindemo muntu kuyehi na munkinda uaundende. ");
INSERT INTO nkn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Liapuile litangua lia mucitanu cinguezi omo litangua lia Sapalalo kanda lihete. ");
INSERT INTO nkn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vampuevo vaje vakavele Yesu kuhuma ku Ngalileya vaile hamo na Yosefa, vakamuene cihilo cije na kumona muje muvalangekelelemo muvila ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kaha vaile ku vinjivo viavo nakukavuahesa mukundu na mazi aluengo luacili linga vaka vuahese muvila ua Yesu. Kaha ha litangua lia Sapalalo vahuimine kuya ku Lishiko lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Omo kuacele lia calumingo vampuevo vaile ku cihilo, vambate mazi avavuahesele. ");
INSERT INTO nkn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kaha vauanene livue liakama vana lihumisa ku cikolo ca cihilo. ");
INSERT INTO nkn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kaha vakovelelemo vuno honi kuuanenemo muvila ua Muene Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Vemanene kuje te valikomokela, kaha hajevene kuasholokele vamala vavali mu vuzalo vuakuviakuma kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vaje vampuevo vovuile liova cikuma kaha vakotamene ha mavu, vaje vamala vavehuile nguavo, “Vika mutondela muka muono ku vantsi? ");
INSERT INTO nkn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Uahiko kuno nasanguka laja. Vulukeni muje muahandekele kuli yeni tele ali ku Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Muna Muntu vaka muhana mu mavako a vantu vavupi, kaha vaka mushukika, a kasanguka hanima ya matangua atatu.’ ” ");
INSERT INTO nkn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kaha vampuevo vavulukile mezi endi. ");
INSERT INTO nkn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kaha vahumine kuje ku cihilo vakalekele viuma vioshe vivamuene kuli vaje likumi na umo lia vandongisi na vakuavo voshe. ");
INSERT INTO nkn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vaje vampuevo vapuile Maliya Mangandalena, na Njuana, na Maliya vaina ya Yakomba na vampuevo vakuavo valekele evi viuma kuli tunganda va Yesu. ");
INSERT INTO nkn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vuno honi tunganda vasinganiekele nge vije vivahandekele vampuevo keti viaseho kaha kuva vakulahelele. ");
INSERT INTO nkn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vuno honi Petulu uakatukile na kushatukila ku cihilo, uakotamenenemo kaha uamuenemo lika vintanga na ceka cahi. Kaha uahilukile kuimbo na kulikomokela ha viuma vije via lingiuile. ");
INSERT INTO nkn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ha litangua lijevene vandongisi vavali va Yesu vendele kuya ku limbo lije liivatumbuile nguavo Emausi, ntunda yakele matambo likumi na imo kuhuma ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vakele nakuhandeka ha viuma vioshe vije vialingiuile. ");
INSERT INTO nkn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tele vacili nakuhandeka na kuliyongola, Yesu uezile hayehi navo nakuenda navo. ");
INSERT INTO nkn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vamumuene vuno honi kuvamutantekeyele. ");
INSERT INTO nkn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu uahandekele kuli vakevo nguendi, “Vimpande muka muli nakuhandeka oku muenda?” Vemanene kaha vihanga viavo viasolokele mu vusiua. ");
INSERT INTO nkn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kaha umo uavo lizina liendi Kolopase, uamukumbuluile nguendi, “Yove lika mungezi muno mu Yelusalema uje katantekeya vinapangika ha matangua ano.” ");
INSERT INTO nkn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kaha uavehuile nguendi, “Viuma muka?” Vamutavele nguavo, “Via Yesu uaku Nazaleta. Yala ou uapuile kananguizi ka Njambi na vantu voshe vamutavele kupua muka nzili mu viuma vioshe uahandekele na vije via lingile na Njambi uamu kulahelele. ");
INSERT INTO nkn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kaha tusasendote vakama na vakakuyula vamuhanene kuli Nguvulu ua Maloma linga vamutsihe, kaha vamushukikile ha cilindakano. ");
INSERT INTO nkn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tuakele na likulahelo nguetu ikeye akapatula Isaleli! Kaha lelo linapu litangua lia mucitatu kuhuma haje vialingiuile viuma evi. ");
INSERT INTO nkn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Vampuevo vamo hhakati ketu vatukomokesele, vamenekelele ku cihilo cimenemene, ");
INSERT INTO nkn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","vuno honi kuvakauanene muvila uendi. Kaha vahilukile nguavo vakamuene cimona ca tungelo vaje vavalekele nguavo hali nakuyoya. ");
INSERT INTO nkn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kaha vamo hakati ketu vaileko ku cihilo, kaha vakauanene nge muje muvahandekelele vaje vampuevo, vuno honi kuvamumuene.” ");
INSERT INTO nkn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kaha Yesu uahandekele kuli vakevo nguendi, “Yeni vilema, vaka kusimbula kutsiliela vije vioshe vivahandekele tunanguizi va Njambi va Njambi! ");
INSERT INTO nkn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nkumani Kilistu kapande kuyanda ha viuma evi nakukovela mu vumpau vuendi ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kaha Yesu uaputukile kuvalumbuinina vioshe viuma vije vahandekele mu visoneka hali ikeye, kuputuka na mavulu a Mosesa na kutuala ku visoneka via tunanguizi va Njambi va Njambi voshe. ");
INSERT INTO nkn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kaha omo vahete kuyehi na limbo kuje vakele nakuya, Yesu ualingile ngue atuvakana kamandende kuya kulutue, ");
INSERT INTO nkn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Vuno honi vamulombele na kuhandeka nguavo, “Tumama netu omuo cinguezi na litangua liatoko.” Kaha uaile na kukala navo. ");
INSERT INTO nkn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Uatumamene navo mukulia kaha uambatele mbolo naku ikuisula uaipazuile na kuvahana. ");
INSERT INTO nkn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kaha mesho avo ashokolokele vatantekeyele nguavo nkumani ikeye, vuno honi ualavukile ku mesho avo. ");
INSERT INTO nkn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kaha valihandekesele umo na mukuavo nguavo, “Nkumani mukemo mitima yetu yovuile kuvuahelela cikuma omo uakele nakuhandeka netu mu ngila na kutulumbunuina viuma viamu visoneka.” ");
INSERT INTO nkn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Vakatukile ha ntsimbu ijevene vahilukile ku Yelusalema, vauanene vandongisi likumi na umo vanalikungulula na vaje vakuavo veka naua. ");
INSERT INTO nkn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vahandekele nguavo, “Mua vusunga vene Muene Yesu nasanguka! Nalisholola kuli Simoni!” ");
INSERT INTO nkn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kaha vaje vavali vambuluile vije vialingiuile mu ngila, nomu vatantekeyele nguavo nkuma ikeye Muene Yesu omo uatavuile mbolo. ");
INSERT INTO nkn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tele ntsimbu vaje vavali vakele nakuvaleka viuma evi, vuasi vuasi Yesu vavenia uemanene hakati kavo uahandekele nguendi, “Ciyulo cikale neni.” ");
INSERT INTO nkn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kaha vovuile liova cikuma, omuo vasikaniekele nguavo vanamono ndumba ya muntu. ");
INSERT INTO nkn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Vuno honi uahandekele kuli vakevo nguendi, “Vikahoni munalijujukila? Omo vika muli na vimpata mu mitima yeni? ");
INSERT INTO nkn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Taleni mavoko ange na mu viliato viange. Taleni yange vene. Njikuateni, kaha mutantekeya omuo nduma ya muntu kakele na ntsitu na vitsiha ngue evi muomono njili navio.” ");
INSERT INTO nkn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uahandekele evi na kuvamuesa mavoko na viliato viendi. ");
INSERT INTO nkn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cipue ngoco kuva kulahelele omuo vavuahelele cikuma na kulikomokela kaha Yesu uavehuile nguendi, “Muli na viakulia linga njilie ndi?” ");
INSERT INTO nkn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kaha vamuhanene mbazuvuila ya intsi uakuoca. ");
INSERT INTO nkn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kaha uaitambuile na kulia ha mesho avo. ");
INSERT INTO nkn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kaha uahandekele kuli vakevo nguendi, “Evi vikevio viuma vije njamilekele omo njakele neni nguange viuma vioshe vije vasonekele hali yange mu Lishiko lia Mosesa, na visoneka via tunanguizi va Njambi va Njambi na mu miaso viapande kulishulisisa.” ");
INSERT INTO nkn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kaha uashokoluele mana avo linga vovuisise visoneka ");
INSERT INTO nkn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","na kuhandeka kuli vakevo nguendi, “Visoneka viahandeka nguavio, Kilistu napande kuyanda kaha akasanguka hanima ya matangua atatu.” ");
INSERT INTO nkn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Visoneka viahandeka naua nguavio linga kualuluka na lukonekelo lua vipi vaka viambulula mu lizina liendi ku mafuti oshe, kuputukila mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yeni munapu muvakaleho ha viuma evi. ");
INSERT INTO nkn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kaha yange njikatuma Cimbembesi Cakulele kuli yeni cije cakulahesele Tate. Muapande kuvandamena mu mbonge noho mukatambula nzili ei kuhuminina muilu. ");
INSERT INTO nkn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kaha uahumine navo mu mbonge uavatualele kuyehi na Mbeteniya kuje uajunduile mavoko endi naku vakuisula. ");
INSERT INTO nkn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tele hali nakuvakuisula, ualisezele navo nakumutuala muilu. ");
INSERT INTO nkn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vamushangazalele kaha vahilukile mu Yelusalema na kuvuahelela cikuma. ");
INSERT INTO nkn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kaha vakele ntsimbu yoshe mu njivo ya Njambi na kusantsela Njambi.");
INSERT INTO nkn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hambangelo kuakele Lizi, kaha Lizi liakele hamo na Njambi, kaha Lizi liapuile vene Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hume hambangelo, lizi liakele hamo na Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Muli ikeye Njambi uatangele viuma vioshe, kukuesi cuma civatangele kuakuhona ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Muli ikeye muakele muono, kaha muono uapuile ceke ca vantu voshe. ");
INSERT INTO nkn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ceke catuile mu milima, kaha na milima kuyasele kucihiana. ");
INSERT INTO nkn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kuakele yala ivatumine kuli Njambi, lizina liendi liapuile Iuano. ");
INSERT INTO nkn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Uezile ngue mukaleho, mukuhandeka vukaleho vua ceke, linga voshe vatsiliele kuhitila muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ikeye kapuile ceke, vuno honi uezile nakuambulula vukaleho vua ceke. ");
INSERT INTO nkn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ceke ca vusunga cije cikatuila hali muntu uoshe cezile ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lizi liakele ha mavu, kaha na mavu va atangele kuhitila muli ikeye, vuno honi cipue ngoco vene mavu ka amutantekeyele. ");
INSERT INTO nkn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Uezile ku lifuti liendi, vuno honi vantu vendi kuvamutambuile. ");
INSERT INTO nkn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vuno honi kuli voshe vaje vamutambuile, vaje vatsilielele mu lizina liendi, uavahanene nzili yakupua vana va Njambi, ");
INSERT INTO nkn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","vaje vasemukile keti ku maninga cipue ku mashungu a yala, cipue ku cizango ca kusemuka ku yala, vuno honi Njambi ikeye vavenia uapuile Ishavo. ");
INSERT INTO nkn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kaha lizi liahimpukile muntu nakukala hhakati ketu, uashulile na kavumbi na vusunga, tunamono vumpau vuendi, vumpau vuje hakupua Muana umolika ua Ishe. ");
INSERT INTO nkn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iuano uahandekele vukaleho hali ikeye nakutambeka nguendi, “Ou ikeye uje injahandekele nguange, ‘Ou eja munima yange napu uakama kupulakana yange, omuo ikeye uakeleko te kanda yange!’ ” ");
INSERT INTO nkn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hakushula cendi, yetu voshe tunatambula kavumbi ha kavumbi. ");
INSERT INTO nkn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Omuo lishiko cilivene valihanene kuhitila muli Mosesa, vuno honi kavumbi na vusunga viezile kuhitila muli Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naumo uahi uamonaho Njambi, kuvanga lika Muana uje umolika, uje ali kuyehi na mutima ua Ishe, uje ikeye namutantekeyesa. ");
INSERT INTO nkn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ovu vukevuo vukaleho vuahanene Iuano omo Vayunda vatumine tusasendote na Valevi kuhuma ku Yelusalema mukumuihula nguavo, “Yove iya?” ");
INSERT INTO nkn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iuano uahandekele vukaleho, kavianene kuvakumbulula, vuno honi uahandekele kuli vakevo nguendi, “Keti yange Kilistu.” ");
INSERT INTO nkn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Vamuhuile nguavo, “Honi yove iya? Yove Eliya ndi?” Vuno honi Iuano uavakumbuluile nguendi, “Houe, keti yange!” Vamuhuile naua nguavo, “Yove kananguizi ua Njambi ndi?” Iuano uavakumbuluile nguendi, “Houe keti yange.” ");
INSERT INTO nkn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kaha vamuhuile nguavo, “Indi yove iya honi? Tuleke linga tukaleke vaje vanatutumu kuli yove. Ulitumbula nguove yove iya?” ");
INSERT INTO nkn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Iuano uavakumbuluile nguendi, “Yange lizi liaumo atambeka mu mpambo nguendi, ‘Sungameseni ngila ya MUENE,’ ngue muahandekele kananguizi ua Njambi Isaya.” ");
INSERT INTO nkn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Honi omo vavatumine kuli Vafaliseo, ");
INSERT INTO nkn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","vehuile Iuano nguavo, “Vikahoni ulinakumbuitikila nga keti yove Kilistu, cipue Eliya, cipue kananguizi ua Njambi?” ");
INSERT INTO nkn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Iuano uavakumbuluile nguendi, “Yange njimbuitika na mema, vuno honi hhakati keni hanemana umo uje kumutantekeya. ");
INSERT INTO nkn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ikeye umo uje eja munima yange, yange kunjafuililile cipue kuzitula miva yaha vinkaku viendi.” ");
INSERT INTO nkn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vioshe evi vialingiuilile mu Mbeteniya musinia lia ndonga ya Yundau kuje kuakele nakumbuitikila Iuano. ");
INSERT INTO nkn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Liamukuavo Iuano uamuene Yesu alinakuija kuli ikeye, kaha uahandekele nguendi, “Taleni, Muna Mpanga ua Njambi uje akambata vupi vua vaka mavu! ");
INSERT INTO nkn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ou ikeye uje ijahandekele nguange, ‘Munima yange mukeja yala uakama kupulakana yange omuo ikeye uakeleko hambangelo yange tele kanda njisemuke.’ ");
INSERT INTO nkn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yange kunjamutantekeyele nguange ikeye, vuno honi njezile nakumbuitika na mema linga vaka Isaleli vamutantekeye.” ");
INSERT INTO nkn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Iuano uambuluile vukaleho ovu nguendi, “Njamuene Cimbembesi cishuluka kuhuma muilu ngue livembe, na kutonkama hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yange kunjatantekeyele nguange ikeye, vuno honi uje uanjitumine kumbuitika na mema ikeye uahandekele kuli yange nguendi, ‘Hali uje ukamona Cimbembesi cikashulukila nakumutonkama ikeye vene akambuitika na Cimbembesi Uakulela.’ ");
INSERT INTO nkn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yange vene vavenia njacimono nakuhandeka vukaleho nguange ou ikeye vene Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Liamukuavo naua Iuano uemanene na vandongisi vendi vavali, ");
INSERT INTO nkn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","omo uamuene Yesu uakele nakuhita, uahandekele nguendi, “Taleni! Uje Muna Mpanga ua Njambi!” ");
INSERT INTO nkn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vaje vandongisi vavali vovuile Iuano ahandeka evi, kaha vakavele Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Omo Yesu uatengulukile, kaha uavamuene valinakumukava, kaha uahandekele kuli vakevo nguendi, “Muli nakutonda vika?” Vamukumbuluile nguavo, “Lambi” (Eli lizi lilumbunuka “Mulongisi”). “Uakala kuli?” ");
INSERT INTO nkn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uahandekele kuli vakevo nguendi, “Ijeni mumone.” Vezile nakumona kuje kuakele nakukala, vakele nendi litangua lije. Omuo capuile mutania ua cinguezi ua hola ya likumi na vitanu na imo (16: 0 0). ");
INSERT INTO nkn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Umo ua vaje vavali vovuile Iuano ahandeka nakumukava uapuile Anduleo, munaina ya Simoni Petulu. ");
INSERT INTO nkn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hajevene Anduleo uauanene munaina Simoni, kaha uamulekele nguendi, “Tunauana Mesiya.” lizi eli lilumbunuka ngualio Kilistu. ");
INSERT INTO nkn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ambahoni Anduleo uatualele munaina Simoni kuli Yesu. Yesu uamutalele, kaha uahandekele kuli ikeye nguendi, “Yove Simoni muna Iuano, vuno honi vakakutumbula Kefase.” (Lije lilumbunuka Petulu). ");
INSERT INTO nkn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Liamukuavo cimene Yesu uayonguele kuya ku Ngalileya. Tele ali nakuya uauanene Filipu kaha uahandeka kuli ikeye nguendi, “Njikave!” ");
INSERT INTO nkn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Honi Filipu uahumininine ku Mbetesainda, ku nganda kuje ku vakele Anduleo na Petulu. ");
INSERT INTO nkn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu uauanene Natanele, kaha uamulekele nguendi, “Tunauana uje yasonekele Mosesa mu livulu lia Lishiko naua uje na tunanguizi va Njambi va Njambi ivasonekele, ikeye Yesu uaku Nazaleta, muna Yosefa.” ");
INSERT INTO nkn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanele uamuhuile nguendi, “Nkuma ku Nazaleta kuasa kuhuma cuma cacili ndi?” Filipu uamukumbuluile nguendi, “Ija ukamone.” ");
INSERT INTO nkn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Omo Yesu uamuene Natanele alinakuija kuli ikeye, uahandekele hali Natanele nguendi, “Ou ikeye Kaisaleli ua vusunga, uje muli ikeye kumuesi makuli!” ");
INSERT INTO nkn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanele uamuhuile nguendi, “Unanjitantekeyela kuli?” Yesu uamukumbuluile nguendi, “Njakumuene uatumama muintsi lia muti ua mukuyu tele kanda Filipu akusane.” ");
INSERT INTO nkn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanele uamukumbuluile nguendi, “Mulongisi, yove unapu Muna Njambi! Yove Muene ua Isaleli!” ");
INSERT INTO nkn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu uamukumbuluile nguendi, “Unatsiliela omuo njinakuleke nguange njakumuene uatumama muintsi lia muti ua mukuyu ndi? Ukamona viuma viakama kupulakana evi!” ");
INSERT INTO nkn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kaha naua Yesu uahandekele kuli ikeye nguendi, “Muavusunga njimileka nguange, mukamona lilu liashokoloka, kaha na tungelo va Njambi valonda na kushuluka hali Muna Muntu.” ");
INSERT INTO nkn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ha litangua lia mucitatu kuakele ciuano ca vulo ku Kana mu Ngalileya, na vaina ya Yesu vakeleko. ");
INSERT INTO nkn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na vandongisi vendi navo naua vavalaniene ku ciuano cije. ");
INSERT INTO nkn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Omo viniu viahuile, vaina ya Yesu vahandekele kuli ikeye nguavo, “Viniu vinahu.” ");
INSERT INTO nkn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kaha Yesu uahandekele kuli ikeye nguendi, “Yove mpuevo, keti unjileke viakulinga, ntsimbu yange kanda ihete.” ");
INSERT INTO nkn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Vaina ya Yesu valekele vaje vangamba nguendi, “Lingeni vioshe vije viamileka.” ");
INSERT INTO nkn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kuje kuakele vinjava via mavue viakutekuila mema vitanu na imo via Vayunda ngue ku muyati uavo ua kulilelesa, imo na imo yasele kukala na malita a mema akupua vihita (100). ");
INSERT INTO nkn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu ualekele vaje vangamba nguendi, “Shuliseni evi vinjava na mema.” Kaha vavishulisile vioshe naku kanua. ");
INSERT INTO nkn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Uavalekele nguendi, “Honi tekulenimo amo mutuale kuli mukuluntu ua ciuano.” Nankuma vamutualelele. ");
INSERT INTO nkn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Omo uje mukuluntu ua ciuano uamakelele aje mema aje atengulukile kupua viniu, ikeye katantekeyele kuje kuviahumine vije viniu (cipue vene vaje vangamba vatekuile aje mema vatantekeyele), nankuma mukuluntu ua ciuano uasanene vavenia vulo ");
INSERT INTO nkn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kaha uahandekele kuli ikeye nguendi, “Muntu voshe akalivanga kuhana viniu viacili, ambahoni ahana via vishamu munima ya vaje vavanalania vanapende laja. Vuno honi yove hanga uatulika viniu viacili kuheta na kuntsimbu ino.” ");
INSERT INTO nkn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu ualingile eci citantekeyeso cendi ca kulivanga ku Kana mu Ngalileya, nakusholola vumpau vuendi, na vandongisi vendi vatsilielele muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Munima yevi, Yesu uaile ku Kapenauma na vaina, na vamuanaye, na vandongisi vendi, vakele kuje matangua amandende lika. ");
INSERT INTO nkn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Omo Ciuano ca Paseka ca Vayunda cakele muyehi, nankuma Yesu uaile ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mu vimbalaka via njivo ya Njambi uauanene vantu vaje vakele nakulandeselamo vangombe, na vampanga, na mavembe na vaka kulandulula vimbongo vatumamene ku vimesa viavo. ");
INSERT INTO nkn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nankuma uapangele likote, voshe uavashekelele hambanza lia vimbalaka via njivo ya Njambi, hamolika na vampanga na vangombe, kaha uombilile vimbongo via muuaya uaya via vaje vakele nakulandulula kaha uafulumikile vimesa viavo. ");
INSERT INTO nkn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kaha ualekele vaje vakele nakulandesa mavembe nguendi, “Tuhuiseni evi viuma muno! Keti mupuise Njivo ya Tate mutambela uakulandesela!” ");
INSERT INTO nkn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vandongisi vendi vanukile ngeci vanavisoneka mu visoneka nguavo, “Cizango cange ha Njivo ya Tate cishukuma ngue tuhia muli yange.” ");
INSERT INTO nkn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Vayunda vamuhuile nguavo, “Cimueso muka uasa kutumuesa ngeci uli na nzili yakama yakulinga eci?” ");
INSERT INTO nkn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu uavakumbuluile nguendi, “Siuleni eyi Njivo ya Njambi, kaha mu matangua atatu njikaitunga naua.” ");
INSERT INTO nkn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kaha Vayunda vahandekele nguavo, “Eyi Njivo ya Njambi vanaitungile mu miaka yakupua makumi auana na miaka itanu na umo (46), kaha yove ukaitunga vati mu matangua atatu?” ");
INSERT INTO nkn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Vuno honi uakele nakuhandeka Njivo ya Njambi ya muvila uendi. ");
INSERT INTO nkn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hanima ya kusanguka ku vatsi, vandongisi vendi vanukile nguavo vikevio viahandekele evi, kaha vatsilielelele visoneka na lizi lije liahandekele Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Honi omo Yesu uakele mu Yelusalema ku ciuano ca Paseka, vavengi vatsilielelele mu lizina liendi omuo vamuene vitantekeyeso vije vialingile. ");
INSERT INTO nkn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Vuno honi Yesu kalihanene ikeye vavenia kuli vakevo, ");
INSERT INTO nkn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","omuo uatantekeyele vantu voshe kaha katondele muntu umo amuleke vukaleho vua hali mukuavo, omuo ikeye vavenia uatantekeyele vije viakele muli muntu uoshe. ");
INSERT INTO nkn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Honi kuakele Kafaliseo ualizina lia Nikondemo, ntuama ua Vayunda. ");
INSERT INTO nkn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Uaile kuli Yesu vutsiki nakuhandeka kuli ikeye nguendi, “Mulongisi, tuatantekeya nguetu u mulongisi uakuhuminina kuli Njambi, omuo naumo uahi asa kulinga vitantekeyeso evi vi ulinakulinga kuakuhona nzili ya Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu uamukumbuluile nguendi, “Muavusunga njikuleka, naumo uahi asa kumona vumuene vua Njambi kuakuhona kusemuka luvali.” ");
INSERT INTO nkn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikondemo uahandekele kuli ikeye nguendi, “Vatihoni muntu asa kusemuka luvali munima yakukola laja? Nkuma muntu asa kukovela muzimo lia vaina luvali na kusemuka naua ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu uamukumbuluile nguendi, “Muavusunga vene njikuleka nguange, naumo uahi asa kukovela mu vumuene vua Njambi kuakohona kusemuka ku mema na ku Cimbembesi. ");
INSERT INTO nkn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Uje uasemuka ku muntu uapua muntu na uje uasemuka ku Cimbembesi uapua Cimbembesi. ");
INSERT INTO nkn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Keti ukomoke nga njikuleka nguange unapande kusemuka luvali. ");
INSERT INTO nkn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mpunzi ikapekumuka kuoshe kuje kuikatondo, kaha mukevu cililimo cayo, vuno honi kuuasa kutantekeya kuje kuihuminina cipue kuje kuiya. Nankuma, omu mukemo vene mucinapu na kuli uoshe uje asemuka ku Cimbembesi.” ");
INSERT INTO nkn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikondemo uamuhuile nguendi, “Evi vikalingiua vatihoni?” ");
INSERT INTO nkn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu uamukumbuluile nguendi, “Keti yove mulongisi ua Isaleli, nkuma naua kuuvitantekeya evi viuma ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Muavusunga vene njikuleka, tukahandeka vije vitutantekeya nakuambulula vukaleho vua vije vitukamono, vuno honi yeni kumue kutambula vukaleho vuetu. ");
INSERT INTO nkn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Njamilekele viuma via ha mavu, vuno honi kumua njitsiliela, kaha vatihoni mukanjitsiliela nga njikamileka viuma via muilu? ");
INSERT INTO nkn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Naumo uahi uaya muilu kuvanga Muna Muntu lika uje uezile kuhuma muilu. ");
INSERT INTO nkn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngue Mosesa muje muajunduile linoka mu vindinda, mucifua cimo vene vakajundula na Muna Muntu, ");
INSERT INTO nkn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","linga uoshe akatsiliela muli ikeye akakale na muono uayaye. ");
INSERT INTO nkn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Omuo Njambi uazangele vaka mavu cikuma ngeci uahanene Munendi umolika, linga uoshe atsiliela muli ikeye keti akanonge vuno honi akale na muono uayaye. ");
INSERT INTO nkn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Omuo Njambi katumine Munendi hano ha mavu mukuhisa vaka mavu, vuno honi linga mavu ovoke kuhitila muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Uje natsiliela muli ikeye kuvakamuhisa, vuno honi uje katsiliela vanamuhisa laja, omuo katsilielelele mu lizina lia Muna Njambi umolika. ");
INSERT INTO nkn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nankuma eci cikeco cisompelo, ceke cezile ha mavu, vuno honi vantu vazangele milima kupulakana ceke omuo vilinga viavo viapuile via vupi. ");
INSERT INTO nkn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Omuo uoshe uje muka kulinga vupi uazinda ceke nakuhona kuija ku ceke, linga vilinga viendi keti vilisholole. ");
INSERT INTO nkn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Vuno honi uoshe uje muka kulinga via vusunga akeja ku ceke, linga cilimuese cilivene vilinga viendi viakundama kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Munima yevi, Yesu na vandongisi vendi vaile ku cihela ca Yundeya, kuje kuakele navo ka ntsimbu lika nakuvambuitika. ");
INSERT INTO nkn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Iuano naua uakele nakumbuitika ku Aenone kuyehi na Salime omuo kuakele mema amengi kuje, na vantu vakele nakuya nakuvambuitika. ");
INSERT INTO nkn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ha ntsimbu ije Iuano tele kanda vamuhake mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Vamo vandongisi va Iuano vakele nakulinga vimpata na Kayunda umo ha futisi ya kulilelesa. ");
INSERT INTO nkn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vaile kuli Iuano nakumulekesa nguavo, “Mulongisi, yala uje uakele nove musinia lia ndonga ya Yundau uje iualingilile vukaleho, kuno ali nakumbuitika, na vantu voshe valinakuya kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Iuano uavakumbuluile nguendi, “Naumo uahi asa kutambula cuma kuvanga vanamuhanaco kuilu. ");
INSERT INTO nkn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yeni muvakaleho vange ngue muje munjahandekele nguange, ‘Keti yange Kilistu, vuno honi vananjitumu kulutue luendi.’ ");
INSERT INTO nkn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uje ali na shombolua ikeye vavenia vulo, vuno honi kavusamba ua vavenia vulo uje nemana nakumuivuilila, avuahelela cikuma omo evua lizi lia vavenia vulo. Nankuma, mukemo mucikafua kuvuahelela cange. ");
INSERT INTO nkn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ikeye napande kuvuezelela, vuno honi yange njapande kuhumisa.” ");
INSERT INTO nkn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Uje ahuma muilu nahiana voshe, uje ahuma hano ha mavu nakundama kuvia ha mavu nakuhandeka viuma via hano ha mavu. Vuno honi uje ahuma muilu ali helu lia voshe. ");
INSERT INTO nkn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Akahandeka vukaleho vua vije viakamono na kuivua, vuno honi naumo uahi akatambula vukaleho vuendi. ");
INSERT INTO nkn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Uoshe uje natambula vukaleho vuendi amuesa ngeci Njambi uapua ua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uoshe uje yanatumu Njambi akahandeka mezi a Njambi, omuo Njambi mukakuhana Cimbembesi kuakuhona kuseteka. ");
INSERT INTO nkn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ishe uazanga Muana, kaha nahana viuma vioshe mu mavoko endi. ");
INSERT INTO nkn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Uoshe atsiliela muli Muana ali na muono ua yaye, kaha uoshe kononoka Muana kakakala na muono, vuno honi vutenu vua Njambi vukakala hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Honi omo Muene uatantekeyele nguendi Vafaliseo vanovu nguavo Yesu alinakuuana nakumbuitika vandongisi vavengi kupulakana Iuano ");
INSERT INTO nkn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(cipuevene nguavo keti Yesu uje uakele nakumbuitika vuno honi vandongisi vendi vacilingile.) ");
INSERT INTO nkn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Omo Yesu uevuile vije vivakele nakuhandeka, kaha uahumine ku Yundeya nakuhilukila ku Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Vuno honi mu vungenzi vuendi vuakuya kuje uahitile mu Samaliya. ");
INSERT INTO nkn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nankuma, mu Samaliya uahetele ku nganda ivatumbuile Sikali, muyehi na lihia lije Yakomba uahanene kuli munendi Yosefa. ");
INSERT INTO nkn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lisima lia Yakomba liakele kuje, Yesu uatumamene kuyehi na lisima omuo uahonene cikuma kuenda. Ntsimbu yapuile hhakati ka mutue. ");
INSERT INTO nkn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mpuevo ua Kasamaliya uezile nakutekula mema, kaha Yesu uahandekele kuli ikeye nguendi, “Njihaneko mema njinue.” ( ");
INSERT INTO nkn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Vandongisi vendi vaile mu nganda nakulanda via kulia.) ");
INSERT INTO nkn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mpuevo ua Kasamaliya uamukumbuluile nguendi, “Cija vatihoni yove Kayunda ulombe mema akunua kuli mpuevo ua Kasamaliya?” (Vayunda kuvekulitambosona viuma hamolika na vaka Samaliya.) ");
INSERT INTO nkn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu uamukumbuluile nguendi, “Nga uatantekeyele vuana vuje Njambi vualinavuo hali yove, nou ali nakuhandeka kuli yove nguendi, ‘Njihaneko mema akunua,’ ngue unamulombo, kaha ngue nakuhana mema a muono.” ");
INSERT INTO nkn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mpuevo uahandekele kuli ikeye nguendi, “Muene, kuuesi na cuma cakutekuisa mema, na lisima lialovo. Kulihoni ukauana mema a muono? ");
INSERT INTO nkn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nkuma yove uuakama kupulakana kuku yetu Yakomba, uje uatuhanene lisima eli, nakunuinamo ikeye vavenia na vana vendi na vimuna vendi vaje vanuinininemo ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu uamukumbuluile nguendi, “Uoshe anua ku mema aua akevua naua mpuila, ");
INSERT INTO nkn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","vuno honi voshe vakanua ku mema aje anjikavahana kuvakevu naua mpuila. Mema aje anjikamuhana akapua lisima lia livuelu vuelu muli vakevo lije likavahana mema a muono na kuvahana muono ua yaye.” ");
INSERT INTO nkn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mpuevo uahandekele kuli ikeye nguendi, “Muene, njihaneko ouo mema, linga keti njikevue naua mpuila cipue keti njikeje eje naua kuno nakutekula mema.” ");
INSERT INTO nkn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu uahandekele kuli ikeye nguendi, “Ya ukasane yala liove, kaha uhiluke kuno.” ");
INSERT INTO nkn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mpuevo uamukumbuluile nguendi, “Kunjesi na yala.” Yesu uahandekele kuli ikeye nguendi, “Ukahandeka muacili omo ukahandeka nguove, ‘Kuuesi na yala’, ");
INSERT INTO nkn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","omuo unashomboka ku vamala vatanu, honi ou yuli nendi hano keti yaliove. Viunahandeka via vusunga!” ");
INSERT INTO nkn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mpuevo uahandekele kuli ikeye nguendi, “Muene, njamono nguange u kananguizi ua Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Vakukuluila vetu valemeselele ha munkinda ou, vuno honi yeni muhandeka ngueni cihela cije vantu vanapande lika kulemeselani mu Yelusalema.” ");
INSERT INTO nkn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu uahandekele kuli ikeye nguendi, “Ove mpuevo, njitsiliele, ntsimbu ilinakuija omo kumukalemesela Tate ha munkinda ou cipue mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yeni mukalemesa uje kumutantekeya, vuno honi yetu tukalemesa uje itutantekeya, omuo kuovoka cahuma kuli Vayunda. ");
INSERT INTO nkn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Vuno honi ntsimbu ilinakuija, naua inahete laja, omo vaka kulemesa va vusunga vakalemesa Tate mu Cimbembesi na mu vusunga, omuo Tate uatonda vantu ava kumulemesa. ");
INSERT INTO nkn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Njambi ikeye vene Cimbembesi, na voshe vaje vamulemesa vanapande kulemesa mu Cimbembesi na mu vusunga.” ");
INSERT INTO nkn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mpuevo uahandekele kuli ikeye nguendi, “Njatantekeya nguange Mesiya ali nakuija” (uje ivatumbula Kilistu) “Omo akeja, akatuleka viuma vioshe.” ");
INSERT INTO nkn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu uamukumbuluile nguendi, “Yange vene ikeye, uje ali nakuhandeka nove.” ");
INSERT INTO nkn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hajevene vandongisi va Yesu vezile. Valikomokelele cikuma hakuuana Yesu ali nakuhandeka na mpuevo, vuno honi naumo uahi uahandekele kuli ikeye nguendi, “Uli nakutonda vika?” Cipue kuihula Yesu nguavo, “Vika uli nakuhandekela nendi?” ");
INSERT INTO nkn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ambahoni uje mpuevo uasezele njava yendi nakuhiluka ku nganda. Uakalekele vantu kuje nguendi, ");
INSERT INTO nkn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ijeni mukamone yala uje nanjileka viuma vioshe vinjalingile! Asa kupua Kilistu ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kaha vahumine mu nganda nakuya kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tele vandongisi vakele nakumulambelela nguavo, “Mulongisi, liako viakulia.” ");
INSERT INTO nkn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Vuno honi uahandekele kuli vakevo nguendi, “Njilina viakulia vije kumutantekeya.” ");
INSERT INTO nkn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nankuma, vandongisi vaputukile kulihula umo na mukuavo nguavo, “Nkuma kuli umo namunehela viakulia ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu uahandekele kuli vakevo nguendi, “Viakulia viange vinapu kupanga cizango cendi uje uanjitumine nakumanesa cipangi cendi. ");
INSERT INTO nkn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nkuma kumue kuhandeka ngueni, ‘Kuasala lika vingonde viuana, kaha tukateja ndi?’ Vuno honi njimileka nguange, taleseseni muacili, taleni muje vimbuto muvinahilamo linga vaviteje. ");
INSERT INTO nkn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muka kuteja natambula laja fueto yendi, naua ali nakukungulula vushuka vua muono uayaye, linga muka kukuna na muka kuteja voshe vavuahelele hamolika. ");
INSERT INTO nkn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nankuma, lizi eli liapua lia vusunga ngualio, ‘Umo akuna kaha mukuavo akateja.’ ");
INSERT INTO nkn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Njinakutumu kuteja vije kuuapangele. Vakueni vapangele, kaha yove unauanenamo vimo ha vipangi viavo.” ");
INSERT INTO nkn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vaka Samaliya vavengi vamu nganda ije vatsilielele kuli Yesu omuo uje mpuevo uahandekele nguendi, “Nanjileka viuma vioshe vinjalingile.” ");
INSERT INTO nkn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nankuma, omo vaka Samaliya vezile kuli ikeye, vamulombele linga akale navo, kaha Yesu uakele kuje matangua avali. ");
INSERT INTO nkn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vavengi vatsilielele kuli ikeye omuo ya mezi endi. ");
INSERT INTO nkn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vantu valekele uje mpuevo nguavo, “Keti nguavo omuo viunahandeka viatunehesa linga tutsiliele, vuno honi tualiuvuila yetu vavenia, tuatantekeya nguetu ou mua vusunga vene ikeye Muyoyesi ua vaka mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Omo Yesu uakele kuje matangua avali, kaha uahumineko uaile ku nganda ya Ngalileya ");
INSERT INTO nkn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(omuo ikeye vavenia uahandekele nguendi naumo uahi kananguizi ua Njambi ivasingimika mu lifuti liendi). ");
INSERT INTO nkn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Omo uahete mu nganda ya Ngalileya, vaka Ngalileya vamutambuile muacili, omuo vakamuene vioshe vije vialingile mu Yelusalema ku ciuano, omuo navakevo vaile ku ciuano. ");
INSERT INTO nkn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ambahoni Yesu uahilukile ku Kana mu nganda ya Ngalileya, kuje uatenguluile mema kupua viniu. Kuje kuakele mukuluntu ua vaka kusuana uakele na munendi ua yala uje uakele na kuvavala mu Kapenauma. ");
INSERT INTO nkn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Omo uevuile ngeci Yesu nahumu ku Yundeya neja ku nganda ya Ngalileya, uaile kuli ikeye nakumulomba ngeci eje ku Kapenauma nakukanguisa munendi, uje uatondele kutsa. ");
INSERT INTO nkn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kaha Yesu uahandekele kuli ikeye nguendi, “Naumo uahi hhakati keni atsiliela kuvanga mumone vitantekeyeso na vikomoueso.” ");
INSERT INTO nkn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uje mukuluntu uahandekele nguendi, “Muene tuye mumo ntsimbu kanda munange atse.” ");
INSERT INTO nkn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu uahandekele kuli ikeye nguendi, “Ya, munove akayoya!” Uje yala uatsilielele mezi a Yesu, kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Omo uakele nakuya kuimbo, ualiuanene na vangamba vendi vaje vamulekele nguavo munove ali nakuyoya. ");
INSERT INTO nkn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nankuma, uavehuile ntsimbu muka munendi uayoyele, kaha vamukumbuluile nguavo, “Izau tele mutania, lisika sika lia muhumine.” ");
INSERT INTO nkn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ishe uanukile ngeci ikeyo ntsimbu ije Yesu uamulekele nguendi, “Munove akayoya.” Nankuma, ikeye hamo na ntanga yendi voshe vatsilielele muli Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eci cikeco citantekeyeso ca mucivali cije ca lingile Yesu omo uahumine ku nganda ya Yundeya kuija ku nganda ya Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Munima yevi, Yesu uaile ku nganda ya Yelusalema ku ciuano ca Vayunda. ");
INSERT INTO nkn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kuje ku Yelusalema kuyehi na Cikolo ca Vampanga kuakele cisali cakele na mambalanda atanu, cije mu Cihevelu vacitumbula nguavo Mbetezasa. ");
INSERT INTO nkn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Civunga cakama ca vaka mishongo ya vupuputua, vilema, na vaka kalepa vakosele kuje. ");
INSERT INTO nkn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Omuo kangelo ka Muene ha ntsimbu yoshe uashulukilile muje mu cisali na kutupuisa mema. Kaha uoshe uje muka kuvavala alivangamo, akanguka ku mushongo uendi. ");
INSERT INTO nkn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kuakele yala umo kuje uavavalele miaka makumi atatu na miaka itanu na itatu (38). ");
INSERT INTO nkn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Omo Yesu uamumuene nakosa kuje nakutantekeya nguendi uje yala nakala kuje ntsimbu yailaha, uahandekele kuli ikeye nguendi, “Utonda kukanguka ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Uje yala uakuvavala uamukumbuluile nguendi, “Muene, kunjesi naumo uakunjikovelesa mu cisali omo mema atupuka, omo njeseka nguange njikovelemo, ueka naua alivangamo.” ");
INSERT INTO nkn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu uahandekele kuli ikeye nguendi, “Katuka, ambata linala liove kaha enda.” ");
INSERT INTO nkn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hajevene uje yala uakangukile, uambatele linala liendi nakuputuka kuenda. Lije litangua liapuile lia sapalalo. ");
INSERT INTO nkn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nankuma, Vayunda valekele uje yala ivakanguisile nguavo, “Lino linapu lia sapalalo, eci cinapu kuluisa lishiko omo unambata linala liove.” ");
INSERT INTO nkn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Vuno honi uavakumbuluile nguendi, “Yala uje nanjikangula ikeye nanjileka nguendi, ‘Ambata linala liove, enda!’ ” ");
INSERT INTO nkn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vamuhuile nguavo, “Iya ou yala nakuleka nguendi, ‘Ambata linala liove kaha enda’?” ");
INSERT INTO nkn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Honi uje yala ivakanguisile katantekeyele indi uapuile iya, omuo Yesu uavombolokele mu civunga cije cakele kuje. ");
INSERT INTO nkn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Munima yevi, Yesu uamuuanene ali mu Njivo ya Njambi kaha uahandekele kuli ikeye nguendi, “Tala, unakanguka! Keti ukalinge vupi naua, kuteua viavipi vikalingiue kuli yove.” ");
INSERT INTO nkn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ambahoni uje yala uaile nakuleka vaje vantuama va Vayunda nguendi Yesu ikeye namukanguisa. ");
INSERT INTO nkn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nankuma, vaputukile kupakesa Yesu, omuo uakanguisile muntu ha litangua lia sapalalo. ");
INSERT INTO nkn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Vuno honi Yesu uavakumbuluile nguendi, “Tate alinakupanga ntsimbu yoshe, nange naua njinapande kupanga.” ");
INSERT INTO nkn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Vihandeka evi vialingisile cikuma vantuama va Vayunda linga vamutsihe, omuo keti lika uapokuele lishiko lia ha litangua lia sapalalo, vuno honi uahandekele naua nguendi Njambi ikeye Ishe, mu ngila eyi ualipuisile mumo na Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu uahandekele kuli vakevo nguendi, “Mua vusunga njimileka nguange: Muana kasa kupanga hali kaliendi lika, vuno honi akalingi lika vije amona Ishe avilinga, omuo vije vioshe viakalingi Ishe, vikevio naua vialinga Muana. ");
INSERT INTO nkn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Omuo Ishe uazanga Muana kaha amumuesa vioshe vije viakalingi, amumuesa vipangi viakama kupulakana evi, linga muka likomokelele. ");
INSERT INTO nkn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngue muje Ishe akasangula vatsi nakuvahana muono, mucifua cimo vene naua Muana akahana muono kuli vaje atonda. ");
INSERT INTO nkn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ishe kekusompa hali uoshe vuno honi nahana cisompelo kuli Muana, ");
INSERT INTO nkn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","linga voshe vasingimike Muana ngue muvakasingimika Ishe. Uoshe uje kasingimika Muana kasingimika Ishe uje uamutumine. ");
INSERT INTO nkn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mua vusunga njimileka nguange, uoshe evua lizi liange na kutsiliela kuli uje uanjitumine alina muono uayaye, naua kuvakamusompo vuno honi nahumu ku kutsa nakovela ku muono. ");
INSERT INTO nkn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Mua vusunga njimileka nguange, ntsimbu ilinakuija, naua inahete laja, omo vatsi vakevua lizi lia Muna Njambi, kaha voshe vaje valivua vakayoya. ");
INSERT INTO nkn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngue muje Ishe uakala na muono muli ikeye vavenia, mukemo vene napuisa na Muana kukala na muono muli ikeye vavenia, ");
INSERT INTO nkn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","naua namuhana nzili yakama ya cisompelo, omuo ikeye napu Muna Muntu. ");
INSERT INTO nkn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Keti mulikomokele hali eci, omuo ntsimbu ilinakuija omo voshe vaje vali mu vihilo vakevua lizi liendi ");
INSERT INTO nkn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kaha vakahumamo, voshe vaje vapangele muacili vakasangukila ku muono na vaje voshe vapangele vupi vakasangukila ku cihiso. ");
INSERT INTO nkn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kunjasa kulinga cimo mu nzili yange vavenia. Njikasompo lika muje muanjileka Njambi, cisompelo cange naua capua lika ca vusunga, omuo kunjekulilingila cizango cange vuno honi cizango cauje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nga njiliambulula yange vavenia, vukaleho vuange keti vua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kuali ueka uje akuambulula vukaleho vuange, njatantekeya nguange vukaleho vuje ali nakuambulula hali yange vunapu vua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Muatumine tunganda kuli Iuano, uavalekele vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Keti ngue vukaleho vunjitambula vuahumu ku muntu, vuno honi njilinakuhandeka evi viuma linga muovoke. ");
INSERT INTO nkn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Uapuile ndeya yakushukuma na kutua ceke, neni muavuahelelele ka ntsimbu lika mu ceke cendi. ");
INSERT INTO nkn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Vuno honi yange njili na vukaleho vuakama kupulakana vukaleho vuje vuambuluile Iuano. Omuo evi vikevio vipangi viananjihana Tate linga njivimanusule, vipangi evi vene vinjilinakupanga, vilinakuhandeka hali yange kumuesa ngue Tate uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Tate uje uanjitumine alinakuhandeka vukaleho hali yange. Kanda muvueho lizi liendi, cipue kumona cihanga cendi, ");
INSERT INTO nkn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","naua yeni kumuekuniunga mezi endi mu mitima yeni, omuo kumuatsilielele kuli uje yatumine. ");
INSERT INTO nkn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Muli nakulilongesa visoneka omuo muyongola ngueni mu vikevio muuanamo muono uayaye, nkuma visoneka evi vene vikevio viambulula vukaleho vuange. ");
INSERT INTO nkn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Vuno honi yeni muviana kuija kuli yange linga mukale na muono. ");
INSERT INTO nkn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Yange kunjitondo linga vantu vanjishangazale. ");
INSERT INTO nkn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vuno honi njatantekeya nguange kumuesi na cizango ca Njambi muli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Njineja mu lizina lia Tate, vuno honi yeni kumuanjitambuile, nga ueka eja mu lizina liendi lika, mukamutambula. ");
INSERT INTO nkn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Muasa kutsiliela vati? Yeni mukatambula vumpau kuli umo na mukuavo nakuhona kusetela vumpau vuje vuhuminina kuli umo lika ikeye Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Keti muyongole ngueni njikamivangeya kuli Tate, Mosesa vene uje imuatsilielele ikeye akamivangeya. ");
INSERT INTO nkn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nga muatsilielele kuli Mosesa, nange naua ngue muanjitsiliela, omuo ikeye uasonekele viange. ");
INSERT INTO nkn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Vuno honi nga kumutsiliela vije viasonekele, kaha vatihoni mukatsiliela vinjihandeka?” ");
INSERT INTO nkn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Munima yevi Yesu uaile musinia lia Cisali ca Ngalileya, cije civatumbula naua nguavo Cisali ca Timbeliase. ");
INSERT INTO nkn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Civunga cakama camukavele, omuo vamuene vitantekeyeso vije viakele nakulinga ku vaka kuvavala. ");
INSERT INTO nkn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu ualondele ku munkinda nakutumama hamo na vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tele Paseka Ciuano ca Vayunda cakele muyehi. ");
INSERT INTO nkn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Omo Yesu uanduile mesho endi uamuene civunga cakama cili nakuija kuli ikeye, nankuma uehuile Filipu nguendi, “Kuli tuasa kulanda viakulia via vantu ava linga valie?” ");
INSERT INTO nkn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uahandekele eci mukumueseka, omuo ikeye vavenia uatantekeyele vije viakalinga. ");
INSERT INTO nkn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu uamukumbuluile nguendi, “Cipue vihita vivali (200) via vimbongo via muuaya uaya kuviasa kulanda viakulia viakulisa ava linga umo na umo auane kakandende.” ");
INSERT INTO nkn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Umo ua vandongisi vendi, Anduleo munaina ya Simoni Petulu, uahandekele kuli ikeye nguendi, ");
INSERT INTO nkn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kuli kanike kayala kuno alina mikasha itanu ya mbolo na vantsi vavali. Vuno honi viasa kupuamo kuli vantu voshe ava ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu uahandekele nguendi, “Lekeni vantu voshe vatumame ha mavu.” Kuakele muila uauingi ku cihela cije, nankuma voshe vatumamene ha mavu, kuakele vamala vakupua mu makulukazi atanu (5,000). ");
INSERT INTO nkn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kaha Yesu uatambuile ije mikasha ya mbolo, uatsatselelele kuli Njambi, kaha uaipangezelele vantu vaje vatumamene, ualingile cuma cimo naku vantsi naua, voshe valile kaha vakutile muva tondelelelemo. ");
INSERT INTO nkn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Omo voshe vakutile, Yesu ualekele vandongisi vendi nguendi, “Kungululeni evi vimbazuvuila vinasalaho, keti tuvihiseho cipue tuatundende.” ");
INSERT INTO nkn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nankuma vavikunguluile vioshe, kuje ku vimbazuvuila via mikasha itanu ya mbolo ivasezele vaje valile, vashulisileho mitonga likumi na ivali. ");
INSERT INTO nkn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Omo vantu vamuene vitantekeyeso vialingile Yesu, vaputukile kuhandeka nguavo, “Cilivene ou ikeye kananguizi ua Njambi uje akeja hano ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Omo Yesu uatantekeyele nguendi vatonda kumukuata linga vamupuise muene, uaile naua ku munkinda likaliendi lika. ");
INSERT INTO nkn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Omo litangua liatokele, vandongisi va Yesu vaile ku cisali, ");
INSERT INTO nkn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","vakovelele mu vuato nakuya musinia lia cisali ku Kapenauma. Kuaputukile milima, tele hanga Yesu kanda acihete kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Cisali cakele nakulininganga omuo kuahitile mpunzi yakama. ");
INSERT INTO nkn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Omo vajavuile ntunda ya mantambo akupua atatu cipue auana, vamuene Yesu alinakuenda ha mema kuija kuyehi na vuato, kaha vovuile liova. ");
INSERT INTO nkn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Vuno honi Yesu uahandekele kuli vakevo nguendi, “Yange vene, keti muvue liova.” ");
INSERT INTO nkn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kaha vatondele kumukovelesa mu vuato, hajevene vuato vuahetele ku ntunda kumutambela kuje vakele nakuya. ");
INSERT INTO nkn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Liamukuavo civunga ca vantu vaje vasalele musinia lia cisali vamuene nguavo kuakele lika vuato vumolika kuje. Vamuene naua nguavo Yesu kakovelele hamo mu vuato na vandongisi vendi, vuno honi vandongisi vendi vaile lika likaliavo. ");
INSERT INTO nkn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kaha mato amo aje ahumine ku Timbeliase ezile kuyehi na cihela kuje kuvalililile mbolo hanima ya Muene kuitsatselela kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nankuma, omo civunga camuene ngeci Yesu na vandongisi vendi vahiko kuje, vakovelele mu mato nakuya ku Kapenauma mukutonda Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Omo vamuuanene musinia lia cisali, vahandekele kuli ikeye nguavo, “Mulongisi, tangua lika unezile kuno?” ");
INSERT INTO nkn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu uavakumbuluile nguendi, “Mua vusunga vene njimileka nguange, muli nakunjitonda, keti ngue omuo muamuene vitantekeyeso viange, vuno honi omuo mualile mbolo nakukuta. ");
INSERT INTO nkn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Keti mupangele viakulia vije vikapola, vuno honi pangeleni viakulia via muono ua yaye, vije Muna Muntu akamihanavio. Omuo Njambi, Ishe namuhaka cimueso ca kumutava.” ");
INSERT INTO nkn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kaha vamuhuile nguavo, “Vika tuapande kulinga linga tulinge vije viatonda Njambi?” ");
INSERT INTO nkn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu uavakumbuluile nguendi, “Eci cinapu cipangi ca Njambi, linga mutsiliele muli uje yanatumu.” ");
INSERT INTO nkn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nankuma, vamuihuile nguavo, “Citantekeyeso muka ukatuhana honi, linga tukacimone na kukutsiliela? Cipangi muka ukalinga? ");
INSERT INTO nkn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vakukuluila vetu valile maana mu Mpambo, ngue muvanacisoneka nguavo, ‘Uavahanene mbolo yakuhuminina kuilu linga valie!’ ” ");
INSERT INTO nkn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kaha Yesu uahandekele kuli vakevo nguendi, “Mua vusunga vene njimileka nguange, kapuile Mosesa uje uamihanene mbolo yakuhuma kuilu, vuno honi Tate ikeye akamihana mbolo ya vusunga ya kuhuma kuilu. ");
INSERT INTO nkn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Omuo mbolo ya Njambi yapua ije ihuma muilu nakuhana muono kuli vaka mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Vahandekele kuli ikeye nguavo, “Muene, tuhane eyi mbolo ntsimbu yoshe.” ");
INSERT INTO nkn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu uavalekele nguendi, “Yange mbolo ya muono. Uoshe uje eja kuli yange kakatsiho njala, naua uoshe uje atsiliela kuli yange kakevuiho mpuila. ");
INSERT INTO nkn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vuno honi njamilekele nguange muanjimono vuno honi kumuasa kunjitsiliela. ");
INSERT INTO nkn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Coshe cije canjihana Tate cija kuli yange, na uoshe uje eja kuli yange kunjikamusheke, ");
INSERT INTO nkn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","omuo njahumine muilu, keti ngue mukulinga cizango cange, vuno honi cizango cauje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Honi eci cikeco cizango cauje uanjitumine, linga keti njikahone cimo ku vioshe vije viananjihana, vuno honi njikavasanguile ku muono ha litangua liama manusuilo. ");
INSERT INTO nkn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eci cilivene cikeco cizango ca Tate, ngeci uoshe amona Muana nakutsiliela kuli ikeye akakale na muono ua yaye, kaha njikamusanguile ku muono ha litangua liama manusuilo.” ");
INSERT INTO nkn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kaha vantuama va Vayunda vaputukile kuliniengetela hali ikeye omuo uahandekele nguendi, “Yange mbolo ije yahumine kuilu.” ");
INSERT INTO nkn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vakele nakuhandeka nguavo, “Keti ikeye Yesu ou, muna Yosefa, uje ishe na vaina vatutantekeya ndi? Cija vati ahandeke nguendi, ‘Njahumininine muilu’?” ");
INSERT INTO nkn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu uavakumbuluile nguendi, “Keti muliniengete hhakati keni. ");
INSERT INTO nkn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naumo uahi asa kuija kuli yange kuvanga uje yaneha Tate uanjitumine, kaha njikamusanguile ku muono uje muntu ha litangua liama manusuilo. ");
INSERT INTO nkn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vanacisoneka ku tunanguizi va Njambi va Njambi nguavo, ‘Voshe Njambi akavalongesa.’ Uoshe evua Tate nakulilongesa kuli ikeye eja kuli yange. ");
INSERT INTO nkn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Keti nguavo muntu uoshe uamona Tate, vuno honi kuvanga lika uje uahuma kuli Njambi ikeye uamona Tate. ");
INSERT INTO nkn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mua vusunga vene njimileka nguange, uje uoshe atsiliela alina muono uayaye. ");
INSERT INTO nkn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yange mbolo ya muono. ");
INSERT INTO nkn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vakukuluila veni valile maana mu Mpambo na kutsa. ");
INSERT INTO nkn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eyi ikeyo mbolo ije ihuma muilu, linga uoshe uje aliako kakatsi. ");
INSERT INTO nkn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yange mbolo ya muono ije yahumine muilu. Uoshe uje alia ku mbolo eyi akayoya miaka yoshe, kaha mbolo ije injikahana ya muono ua vaka mavu inapu muvila uange.” ");
INSERT INTO nkn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Vantuama va Vayunda vaputukile kulinga vimpata hhakati kavo, vahandekele nguavo, “Cija vati ou yala atuhane muvila uendi linga tu ulie?” ");
INSERT INTO nkn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nankuma, Yesu uahandekele kuli vakevo nguendi, “Mua vusunga vene njimileka nguange, nga kumukali muvila ua Muna Muntu na kunua maninga endi, kaha kumukakala na muono. ");
INSERT INTO nkn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Voshe valia muvila uange na kunua maninga ange valina muono uayaye, kaha njikavasanguila ku muono ha litangua liama manusuilo, ");
INSERT INTO nkn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","omuo muvila uange ukeuo viakulia via vusunga na maninga ange akeuo viakunua via vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Vaje voshe valia muvila uange na kunua maninga ange vakala muli yange, nange njikala muli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ngue muanjitumine Tate uakuyoya, nange njilinakuyoya omuo Tate, nankuma uoshe akanjilia akayoya omuo yange. ");
INSERT INTO nkn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eyi ikeyo mbolo ije yahumine muilu, keti ngue ije ivalile vakukuluila veni, kaha vatsile. Vuno honi uoshe uje alia mbolo eyi akayoya miaka yoshe.” ");
INSERT INTO nkn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu uakele nakuhandeka evi oku tele ali nakulongesa mu njivo ya malombelo ku Kapenauma. ");
INSERT INTO nkn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Omo vandongisi vendi vavengi vovuile evi, vahandekele nguavo, “Vilongesa evi viavikalu, iya asa kuvitambula?” ");
INSERT INTO nkn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Vuno honi Yesu hakutantekeya ngeci vandongisi vendi vali nakuliniengetela ha cikeco, uahandekele kuli vakevo nguendi, “Nkuma eci cilinakumivuisa kupihia ndi? ");
INSERT INTO nkn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kaha vatihoni nga muamuene Muna Muntu alonda kuya kuakele ha kulivanga? ");
INSERT INTO nkn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Cimbembesi ua Njambi ikeye akahana muono, muvilani uapua uangoco. Mezi aua anjinahandeka kuli yeni akeuo a Cimbembesi na muono. ");
INSERT INTO nkn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Vuno honi hhakati keni kuli vamo vaje vakuhona kutsiliela.” Omuo Yesu uatantekeyele laja hume hambangelo vaje vaka kuhona kutsiliela, na vaje vaka muenda vungungu. ");
INSERT INTO nkn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nankuma, uahandekele nguendi, “Ha cuma eci njamilekele nguange naumo uahi asa kuija kuli yange kuvanga Tate amutavese.” ");
INSERT INTO nkn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Omuo yevi vilongesa, vandongisi vendi vavengi vahilukilemo nakuhona naua kumukavangeya. ");
INSERT INTO nkn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nankuma Yesu uehuile vandongisi vendi likumi na vavali nguendi, “Neni naua mutonda kuhilukamo ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulu uamukumbuluile nguendi, “Muene, kuli iya tuasa kuya? Yove uli na mezi a muono ua yaye. ");
INSERT INTO nkn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tuatsiliela honi nakutantekeya nguetu yove uapua Umo Uakulela ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu uavakumbuluile nguendi, “Nkuma keti yange njamihanguile, yeni vandongisi likumi na vavali ndi? Vuno honi umo ueni napu satana.” ");
INSERT INTO nkn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Uakele nakuhandeka Yundasa muna Simoni Sakaliote, cipue vene uapuile umo uavaje vandongisi likumi na vavali, ikeye akamuenda vungungu. ");
INSERT INTO nkn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Munima yevi, Yesu uendanganene mu Ngalileya. Katondele kuendangana mu Yundeya omuo vantuama va Vayunda vakele nakutonda ngila ya kumutsihilamo. ");
INSERT INTO nkn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ntsimbu ya ciuano ca Mapapela ca Vayunda cakele mu yehi. ");
INSERT INTO nkn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nankuma, vamuanaye vahandekele kuli ikeye nguavo, “Huma kuno uye ku nganda ya Yundeya linga vandongisi vove navakevo naua vakamone vipangi viulinakulinga, ");
INSERT INTO nkn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","omuo naumo uahi ashueka vije vialinga nga atonda kutsimana. Nga ulinakulinga viuma evi, lisholole yove vavenia ku vaka mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Omuo cipue vene vamuanaye kuvamutsilielelele.) ");
INSERT INTO nkn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu uahandekele kuli vakevo nguendi, “Ntsimbu yange kanda ihete, vuno honi yeni ntsimbu yoshe ili kuno. ");
INSERT INTO nkn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vaka mavu kuvasa kumizinda, vuno honi vazinda yange omuo njilinakuvaleka nguange vipangi viaho via vipi. ");
INSERT INTO nkn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yeni ku ciuano yeni vavenia. Yange kunjiiko ku ciuano eci, omuo ntsimbu yange kanda icihete.” ");
INSERT INTO nkn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Munima yakuhandeka evi, Yesu uasalele mu Ngalileya. ");
INSERT INTO nkn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vuno honi omo vamuanaye vanai laja ku ciuano, ambahoni Yesu nendi uaile, kaile citoma mesho vuno honi uaile mu vushueke. ");
INSERT INTO nkn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vantuama va Vayunda vakele nakumutonda ha ciuano nakuhandeka nguavo, “Alikuli ikeye?” ");
INSERT INTO nkn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kuje kuakele kumufueya mu civunga. Vamo vakele nakuhandeka nguavo, “Ou yala uacili,” kaha vamo vakele nakuhandeka nguavo, “houe, alinakutangula civunga.” ");
INSERT INTO nkn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vuno honi naumo uahi uahandekele hali ikeye citona mesho omuo vakele na liova lia vantuama va Vayunda. ");
INSERT INTO nkn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ciuano cakele kuyehi nakuhua omo Yesu uaile ku Njivo ya Njambi nakukaputuka kulongesa. ");
INSERT INTO nkn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Vantuama va Vayunda valikomokelele cikuma, kaha vahandekele nguavo, “Cija vati yala ou akale navilongesa evi, omo ikeye kalilongesele?” ");
INSERT INTO nkn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kaha Yesu uavakumbuluile nguendi, “Vilongesa evi keti viange vuno honi via uje uanjitumine.” ");
INSERT INTO nkn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Uoshe uje atonda kulinga vije viatonda Njambi akatantekeya nga evi vinjilinakulongesa vihuma kuli Njambi cipue njilinakulihandekela lika yange vavenia. ");
INSERT INTO nkn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vaje vakalihandekela vakevo vavenia, vakatondo kuuana vumpau vakevo vavenia, vuno honi uje atonda vumpau vua uje uamutumine napu muntu ua vusunga, naua muli ikeye kumuesi makuli. ");
INSERT INTO nkn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Nkuma Mosesa kamihanene lishiko ndi? Vuno honi naumo uahi hhakati keni aniunga lishiko eli. Vika muli nakutondela ngila ya kunjitsihilamo?” ");
INSERT INTO nkn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vivunga vamukumbuluile nguavo, “Uli na lihamba! Iya alinakutonda kukutsiha?” ");
INSERT INTO nkn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu uavakumbuluile nguendi, “Njalingile cipangi cimo, kaha muva voshe mualikomokelele. ");
INSERT INTO nkn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesa uamishikile kulovoka ku mukanda (kucapuile ca Mosesa, vuno honi cahumine kuli vakukuluila veni), yenihoni mukalovola yala ha litangua lia sapalalo. ");
INSERT INTO nkn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nga yala alovoka ku mukanda lia sapalalo linga keti mupokole lishiko lia Mosesa, nkuma vika munienguela yange omuo njakanguisile muntu ha litangua lia sapalalo? ");
INSERT INTO nkn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Keti musompele vulemu vuno honi sompeni mu vusunga.” ");
INSERT INTO nkn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Vamo vantu vaku Yelusalema vakele nakuhandeka nguavo, “Keti ikeye ou yala uje ivatonda kutsiha vantuama va Vayunda ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nkuma ali kuno, mukuhandeka citona mesho ku vantu vuno honi vakevo nacimo cahi civali nakuhandeka kuli ikeye! Nkuma vaka nzili yakama vatantekeya ngeci ikeye vene Kilistu ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yetu tuatantekeya laja kuje kuahuminina ou yala, vuno honi omo Kilistu akeja, naumo uahi akatantekeya kuje kuakahuma.” ");
INSERT INTO nkn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kaha Yesu uatambakanene cikuma tele alinakulongesa mu vimbalaka via Njivo ya Njambi nguendi, “Muanjitantekeya naua muatantekeya kuje njihuma. Kunjalizililile vuno honi uje nanjitumine uapua ua vusunga naua kumu mutantekeya. ");
INSERT INTO nkn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yange njimutantekeya, omuo njihuma kuli ikeye naua ikeye uanjitumine.” ");
INSERT INTO nkn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kaha vatondele kumukuta vuno honi naumo uahi uasalekele livoko hali ikeye, omuo ntsimbu yendi tele kanda ihete. ");
INSERT INTO nkn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vuno honi vantu vavengi va muje mu civunga vamutsilielelele nakuhandeka nguavo, “Omo Kilistu akeja, nkuma ikeye akalinga vitantekeyeso viavingi kupulakana evi vianalingi ou yala ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Vafaliseo vovuile civunga cije cakele nakungunguta hali Yesu ha viuma evi, nankuma, vakuluntu va tusasendote na Vafaliseo vatumine vaka kuniunga Njivo ya Njambi mukukuata Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kaha Yesu uahandekele nguendi, “Njikakala neni ka ntsimbu kakandende lika, ambahoni njikaya kuli uje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mukanjitonda vuno honi kumukanjiuana, kaha kuje njikakala kumukasa kuyako.” ");
INSERT INTO nkn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Vantuama va Vayunda valihandekesele umo na mukuavo nguavo, “Kuli atonda kuya ou yala kuje kutukasa kumuuana? Atonda kuya ku Vinganda via Vangelengu kuje kuvanashandokela vantu vetu nakulongesa Vangelengu ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Alinakulumbununa vika mukuhandeka nguendi, ‘Mukanjitonda vuno honi kumukanjiuana’ naua ‘kuje njikakala, kumukasa kuyako’?” ");
INSERT INTO nkn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ha litangua lia kumanusula ciuano naua likelio litangua liakama, tele Yesu nacimana kuje, uatambakanene cikuma nguendi, “Uoshe uje ali nampuila eje kuli yange linga akunue mema, ");
INSERT INTO nkn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","na uoshe uje atsiliela kuli yange anue. Ngue muvinahandeka visoneka nguavio, ‘Mu mitima ya vaka kutsiliela mukahuma vindonga via mema a muono!’ ” ");
INSERT INTO nkn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu uahandekele evi hali Cimbembesi uje vaka kutsiliela ivakatambula, haje tele kanda kukale Cimbembesi omuo Yesu tele kanda vamujundule ku vumpau. ");
INSERT INTO nkn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Omo vovuile mezi aua, vamo mu civunga vahandekele nguavo, “Mua vusunga vene ou yala ikeye kananguizi ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kaha vamo vahandekele nguavo, “Ou ikeye vene Kilistu.” Vuno honi vamo vehuile nguavo, “Nkuma Kilistu asa kuhuma ku Ngalileya ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nkuma visoneka kuviahandekele nguavio Kilistu akahuminina ku muyati ua Ndaviti na kusemukila mu Mbetelehema, mu limbo muje muakele Ndaviti ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nankuma kuakele lihangununo hhakati ka civunga omuo yendi Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vamo vatondele kumukuta vuno honi naumo uahi uasalekele mavoko hali ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Omo vaka kuniunga Njivo ya Njambi vahilukile kuli vakuluntu va tusasendote na kuli Vafaliseo, vavehuile nguavo, “Vika kumua mukutilile?” ");
INSERT INTO nkn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Vaka kuniunga Njivo ya Njambi vakumbuluile nguavo, “Naumo uahi asa kuhandeka ngue ou yala!” ");
INSERT INTO nkn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kaha Vafaliseo vavakumbuluile nguavo, “Neni naua vamikuisa ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nkuma kuli umo ua vaka nzili yakama cipue ua Vafaliseo natsiliela kuli ikeye ndi? ");
INSERT INTO nkn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Vuno honi civunga eci kucitantekeya lishiko lia Mosesa, kaha cinasingiua.” ");
INSERT INTO nkn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikondemo uje uaile kuli Yesu hakulivanga, uehuile vakuavo nguendi, ");
INSERT INTO nkn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nkuma lishiko lietu likahisa vantu vaje kanda tucivue viavo na kuuana vika vivanalingi ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Vakevo vamukumbuluile nguavo, “Nkuma nove naua uhuma ku Ngalileya ndi? Tondesesa kaha ukauana nguove naumo uahi Kananguizi ua Njambi akahuminina ku Ngalileya.” ");
INSERT INTO nkn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kaha muntu na muntu uaile kuimbo liendi, ");
INSERT INTO nkn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Vuno honi Yesu tele nayi ku Munkinda ua Oliveta. ");
INSERT INTO nkn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cimene mene uahilukilile ku vimbalaka via Njivo ya Njambi. Kaha vantu voshe vezile kuli ikeye kaha uatumamene ha mavu nakuvalongesa. ");
INSERT INTO nkn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Valongisi va mashiko na Vafaliseo vanehele mpuevo uje vakuatele oku alinga vupangala, nakumuimika ha lutue luavo voshe, ");
INSERT INTO nkn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kaha vahandekele kuli ikeye nguavo, “Mulongisi, ou mpuevo tuamuuana alinga vupangala. ");
INSERT INTO nkn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mu lishiko lije Mosesa uatushikile lihandeka ngualio mpuevo ua cifua eci napande kumutsiha na mavue. Honi yove uhandekaho vika?” ");
INSERT INTO nkn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vahandekele eci mukumueseka, linga vamuuaneneho mulonga. Yesu uakotamene nakusoneka na munie uendi ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Omo vatualeleleleho kumuihula, kaha uandukile nakuhandeka kuli vakevo nguendi, “Iya uje hhakati keni kesi na vupi aputuke kumuasha livue.” ");
INSERT INTO nkn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kaha naua uakotamene nakusoneka ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Omo vovuile eci, vaputukile kuya umo na umo kuputukila ku vakuluntu, kaha Yesu uasalele likaliendi na mpuevo uje yemanene nendi. ");
INSERT INTO nkn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu uandukile nakuhandeka kuli uje mpuevo nguendi, “Mpuevo, valikuli? Nkuma naumo uahi nakuhisa ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uahandekele nguendi, “Naumo uahi, Muene.” Kaha Yesu uahandekele nguendi, “Nange kunjikuhisa. Ya, kuhuma hano kuya kulutue keti ukalinge vupi naua.” ");
INSERT INTO nkn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kaha naua Yesu uahandekele kuli vakevo nguendi, “Yange ceke ca mavu. Uoshe anjikava kakende mu milima vuno honi akakala na ceke ca muono.” ");
INSERT INTO nkn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kaha Vafaliseo vahandekele kuli ikeye nguavo, “Ulinakuhana vukaleho vuove vavenia, vukaleho vuove keti vua vusunga.” ");
INSERT INTO nkn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu uavakumbuluile nguendi, “Cipue vene njilinakuhana vukaleho vuange vavenia, vukaleho vuange vunapu vua vusunga omuo njitantekeya oku njihuma noku njiya, vuno honi kumutantekeya oku njihuma noku njiya. ");
INSERT INTO nkn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mukasompo mu vuntu, vuno honi yange uahi njikasompo. ");
INSERT INTO nkn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cipue vene nga njikasompo, kusompa cange capua ca vusunga, omuo keti likaliange njikasompo, vuno honi yange na Tate uje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu lishiko lieni vasoneka nguavo vukaleho vua vantu vavali vunapu vua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Njihana vukaleho vuange hali yange vavenia, kaha naua na Tate uanjitumine ahana vukaleho hali yange.” ");
INSERT INTO nkn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kaha vahandekele kuli ikeye nguavo, “Ali kuli Isho?” Yesu uavakumbuluile nguendi, “Nga kumutantekeya yange kaha na Tate kumu mutantekeya. Nga muanjitantekeyele nga na Tate muamutantekeya naua.” ");
INSERT INTO nkn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Uakele nakuhandeka evi oku tele ali nakulongesa mu vimbalaka via njivo ya Njambi kuyehi na mulili ua vimbongo via mulambu, vuno honi naumo uahi uamukutile, omuo ntsimbu yendi tele kanda ihete. ");
INSERT INTO nkn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Naua Yesu uahandekele kuli vakevo nguendi, “Njili nakuya, kaha mukanjitonda, vuno honi mukatsa na vupi vueni. Oku njiya, kumuasa kuyako.” ");
INSERT INTO nkn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kaha vantuama va Vayunda vahandekele nguavo, “Aya nakulitsiha ndi? Vikahoni vianalumbununa mukuhandeka nguendi, ‘Oku njiya, kumuasa kuyako’?” ");
INSERT INTO nkn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kaha uahandekele kuli vakevo nguendi, “Yeni muhuma kuintsi, vuno honi yange njihuma kuilu. Yeni mu vaka mavu, vuno honi yange keti njiuahano ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Njamilekele nguange mukatsa ku vupi vueni, cilivene mukatsa ku vupi vueni kuvanga noho muatsiliela ngueni, ‘Yange vene ikeye.’” ");
INSERT INTO nkn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Vahandekele kuli ikeye nguavo, “Yove iya?” Yesu uahandekele kuli vakevo nguendi, “Vika vinjihandekela viakulifua hume hambangelo kuli yeni? ");
INSERT INTO nkn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Njili naviavingi via kuhandeka hali yeni na viavingi via kumisompa, vuno honi ou uanjitumine uapua ua vusunga, kaha njihandeka ku vaka mavu vije vinjinevu kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kuvatantekeyele nguavo uakele nakuhandeka kuli vakevo via hali Ishe. ");
INSERT INTO nkn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kaha honi Yesu uahandekele nguendi, “Nga muamujundula Muna Muntu, ambahoni mukatantekeye ngueni yange vene, kunjililingila viuma lika liange, vuno honi njikahandeka viuma evi kuya muje Tate nanjishikilamo. ");
INSERT INTO nkn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nauje uanjitumine ali nange, kanjisezele lika liange, omuo ntsimbu yoshe njikalingi via kumuvuahelesa.” ");
INSERT INTO nkn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Oku tele ali nakuhandeka evi viuma, vavengi vatsilielele muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kaha Yesu uahandekele kuli Vayunda vaje vatsilielele muli ikeye nguendi, “Nga mutualelelaho kuononoka lizi liange, kaha cilivene mu vandongisi vange va vusunga, ");
INSERT INTO nkn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","kaha mukatantekeya vusunga, na vusunga kaha vukamipatula.” ");
INSERT INTO nkn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Vamukumbuluile nguavo, “Yetu tuvatekuluila va Avilahama kaha kanda tupueho tu vandungo ku muntu. Ulumbununa vika omo uhandeka nguove, ‘Vakamipatula’?” ");
INSERT INTO nkn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu uavakumbuluile nguendi, “Mua vusunga vene njimileka nguange, uoshe alinga vupi napu ndungo ua vupi. ");
INSERT INTO nkn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ndungo kakele na muhela ua kutumamenena ku ntanga ije keti yendi, vuno honi muana ikeye atumamenena ntsimbu yoshe. ");
INSERT INTO nkn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nga Muana akupatula, cilivene ukapua uakupatuka. ");
INSERT INTO nkn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Njatantekeya vene nguange muvatekuluila va Avilahama, vuno honi mulinakutonda ngila yakunjitsihilamo, omuo ku muesi lizi liange muli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Njihandeka vije vinjinamono kuli Tate, neni naua muapande kulinga vimunevu kuli ishueni.” ");
INSERT INTO nkn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Vamukumbuluile nguavo, “Avilahama ikeye tatetu.” Yesu uahandekele kuli vakevo nguendi, “Nga muapuile mu vana va Avilahama, ngue muli nakulinga vialingile Avilahama. ");
INSERT INTO nkn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vuno honi mulinakutonda kunjitsiha, yala uje namilekesa vusunga vuje vunjevuile kuli Njambi. Eci keti cikeco calingile Avilahama. ");
INSERT INTO nkn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Cilivene muli nakulinga vije vialingile isho.” Vahandekele kuli ikeye nguavo, “Yetu keti tuvana vaku vupangala, tuli na Tate umolika, ikeye Njambi likaliendi.” ");
INSERT INTO nkn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu uahandekele kuli vakevo nguendi, “Nga Njambi uapuile Ishueni, ngue muanjizange, omuo njahuma kuli Njambi kaha yange uno. Kunjalizilile lika liange, vuno honi ikeye uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nkuma vika kumuvuisisa vinjihandeka? Omuo kumutambula lizi liange. ");
INSERT INTO nkn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Muahuma kuli Ishueni Satana, kaha muahangula kulinga mashungu a ishueni. Uapuile muka kutsiha hume hambangelo kaha uahona vusunga, omuo kumuesi vusunga muli ikeye. Omo akeja, akahandeka kuya muafuilamo, omuo ikeye uapua ua makuli naua ishe ya vaka makuli. ");
INSERT INTO nkn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vuno honi omuo njikahandeka vusunga, kumuasa kunjitsiliela. ");
INSERT INTO nkn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Iya hhakati keni ahandeka nguendi nanjiuana na mulonga ua vupi? Nga njihandeka vusunga, kaha vika kumunjitsiliela? ");
INSERT INTO nkn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Uoshe ahuma kuli Njambi evua mezi a Njambi. Mulonga omuo kumueku evuilila omuo kumuhumu kuli Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Vakuluntu va Vayunda vamukumbuluile nguavo, “Nkuma kutuahandekele muacili omo tuahandeka nguetu u Kasamaliya kaha uli na lihamba ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu uakumbuluile nguendi, “Kunjesi na lihamba, vuno honi njikasingimika Tate, kaha yeni ku munjisingimika. ");
INSERT INTO nkn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kunjekutonda vumpau vuange vavenia, vuno honi kuali ali nakutonda vumpau kaha ikeye naua muka kusompa. ");
INSERT INTO nkn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mua vusunga njimileka nguange, uoshe aniunga lizi liange kakatsiho.” ");
INSERT INTO nkn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vakuluntu va Vayunda vahandekele kuli ikeye nguavo, “Tunamono cili vene nguetu uli na lihamba. Avilahama uatsile, kaha na tunanguizi va Njambi va Njambi vatsile, vuno honi uhandeka nguove, ‘Uoshe aniunga lizi liange kakatsiho.’ ");
INSERT INTO nkn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nkuma yove u uakama kupulakana tatetu Avilahama uje uatsa ndi? Na vaje tunanguizi va Njambi va Njambi vatsile. Usinganieka nguove yove iya?” ");
INSERT INTO nkn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu uavakumbuluile nguendi, “Nga njilihana vumpau yange vavenia, vumpau vuange kaha vunapu vuangoco. Tate ikeye muka kunjihana vumpau, ou muhandeka ngueni, Njambi yeni. ");
INSERT INTO nkn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Cipue vene ku mumutantekeya. Vuno honi yange njimutantekeya, nga njihandeka nguange kunjimutantekeya, kaha njipua ua makuli ngue yeni. Vuno honi njamutantekeya naua njiniunga lizi liendi. ");
INSERT INTO nkn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ishueni Avilahama uavuahelele ngue akamone litangua njikeja, kaha ualimuene nakuvuahelela.” ");
INSERT INTO nkn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kaha Vakuluntu va Vayunda vahandekele kuli ikeye nguavo, “Kanda uhete ha miaka makumi atanu (50), honi uamumono vati Avilahama?” ");
INSERT INTO nkn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu uahandekele kuli vakevo nguendi, “Mua vusunga vene njimileka nguange, ntsimbu kanda Avilahama a semuke, yange kunjili.” ");
INSERT INTO nkn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nankuma vambatele mavue nakumuasha, vuno honi Yesu ua lishuekele nakuhuma mu vimbalaka via njivo ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tele Yesu alinakuenda, uamuene yala uje ua semukile vupuputua. ");
INSERT INTO nkn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vandongisi vendi vamuhuile nguavo, “Mulongisi, iya ualingile vupi, ou yala indi visemi vendi, linga a semuke vupuputua?” ");
INSERT INTO nkn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu uavakumbuluile nguendi, “Voshe kuvalingile vupi, uasemukile vupuputua linga vipangi via Njambi visholoke muli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tuapande kupanga vipangi viendi uje uanjitumine tuyeni tupange ntsimbu kucili mutania, omo vutsiki vukeja tukahona kupanga. ");
INSERT INTO nkn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ntsimbu njicili ha mavu, njinapu ceke ca vaka mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Omo uamanusuile kuhandeka evi, uajekuililile ha mavu kaha uambatele mavu a kupandakana na malenzi naku ahaka ha mesho a uje yala, ");
INSERT INTO nkn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nakuhandeka kuli ikeye nguendi, “Ya, ukatane ku mesho ove mu cisali ca Siloame” (Siloame ilumbunuka vana mutumu). Kaha uaile nakutana omo uahilukile uaputukile kumona. ");
INSERT INTO nkn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vandambo vendi na vaje vamumuene laja tele acili muka kulomba vukuasi, vaputukile kuihula nguavo, “Ou keti ikeye uje yala uakele nakutumama na kulomba vukuasi ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vamo vaputukile kuhandeka nguavo, “Ikeye vene.” Vamo vahandekele nguavo, “houe, vuno honi muntu lika ueka uakulifua nendi.” Kaha ikeye uahandekele nguendi, “Yange vene uje yala.” ");
INSERT INTO nkn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Vuno honi vatualeleleho kumuihula nguavo, “Kaha mesho ove anemuka vati?” ");
INSERT INTO nkn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Uavakumbuluile nguendi, “Yala ivatumbula nguavo Yesu uambatele mavu nakunjihaka ha mesho, nakuhandeka kuli yange nguendi, ‘Ya ku Siloame ukatane.’ Kaha njaile nakutana mukemo njaputukile kumona.” ");
INSERT INTO nkn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Vahandekele kuli ikeye nguavo, “Ali kuli honi?” Uahandekele nguendi, “Kunjitantekeya.” ");
INSERT INTO nkn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Vanehele uje yala uapuile kapuputua kuli Vafaliseo. ");
INSERT INTO nkn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Liapuile litangua lia Sapalalo lije Yesu uemuisile uje yala. ");
INSERT INTO nkn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kaha Vafaliseo naua vaputukile kumuihula nguavo, cineja vati linga umone. Uahandekele kuli vakevo nguendi, “Uanjihakele mavu ha mesho ange. Kaha njataneneko, mukemo njili nakumona.” ");
INSERT INTO nkn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Vamo va Vafaliseo vahandekele nguavo, “Ou yala kahumu kuli Njambi, omuo kekuniunga litangua lia sapalalo.” Vuno honi vakuavo vahandekele nguavo, “Muka vupi asa vati kulinga vitantekeyeso evi?” Kaha vali hangunuine. ");
INSERT INTO nkn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kaha Vafaliseo vahandekele naua kuli uje kapuputua nguavo, “Uhandekaho vika hali ikeye? Mesho ove akeo anemuisile.” Uahandekele nguendi, “Ikeye Kananguizi ua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vakuluntu va Vayunda kuvatsilielele nguavo uapuile kapuputua kaha ali nakumona naua, kuvanga noho vasanene visemi va uje yala ivemuisile ");
INSERT INTO nkn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","nakuvehula nguavo, “Ou ikeye vene muneni, uje imuahandekele ngueni nasemuka vupuputua ndi? Cija vatihoni linga amone?” ");
INSERT INTO nkn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Visemi vendi vakumbuluile nguavo, “Tuatantekeya vene nguetu ou ikeye munetu, naua ikeye vene uje uasemukile vupuputua, ");
INSERT INTO nkn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","vuno honi kutuatantekeyele cije canehesa linga amone, kaha kutuatantekeyele naua nauje nemuisa mesho endi. Muhuliseni, mukuluntu alihandekela ikeye vavenia.” ");
INSERT INTO nkn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Visemi vendi vahandekele eci omuo vateuele vantuama va Vayunda, omuo vantuama va Vayunda valitavasanene nguavo uoshe ahandeka nguendi Yesu ikeye Kilistu vakamusheka mu njivo ya malombelo. ");
INSERT INTO nkn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nankuma visemi vendi vahandekele nguavo, “Nakolo, muhuliseni.” ");
INSERT INTO nkn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nankuma vasanene uje yala uapuile kapuputua lua mucivali, kaha vahandekele kuli ikeye nguavo, “Hana kalemeso kuli Njambi! Tuatantekeya nguetu ou yala napu muka vupi.” ");
INSERT INTO nkn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Uakumbuluile nguendi, “Kunjitantekeya indi muka vupi indi kuahi. Cuma cimo cinjitantekeya lika nguange njapuile njikapuputua, vuno honi hano njimona.” ");
INSERT INTO nkn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Vahandekele kuli ikeye nguavo, “Nalingile vika kuli yove? Nakuimuisa vati?” ");
INSERT INTO nkn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uavakumbuluile nguendi, “Njamilekesa laja, vuno honi ku muanjivuilile. Vika mutondela naua kucivua? Neni naua mutonda kupua vandongisi vendi ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kaha vaputukile nakuhandeka nguavo, “Yove ndongisi uendi, vuno honi yetu tuvandongisi va Mosesa. ");
INSERT INTO nkn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tuatantekeya nguetu Njambi uahandekele kuli Mosesa, vuno honi hali ou yala, kutuatantekeyele kuje kuahuma.” ");
INSERT INTO nkn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Uje yala uakumbuluile nguendi, “Eci cinapu cuma cakukomouesa! Kumuatantekeyele kuje ahuminina, vuno honi nemuisa mesho ange. ");
INSERT INTO nkn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tuatantekeya nguetu Njambi kekuivuilila kuva ka vupi, vuno honi akevuilila kuli uje muka kumulemesa na uje muka kuononoka cizango cendi. ");
INSERT INTO nkn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hume kuva tangelele mavu, naumo uahi uevua muntu uje emuisa muntu uasemukile vupuputua. ");
INSERT INTO nkn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nga ou yala kahumine kuli Njambi, ngue nevi ali nakulinga viahi.” ");
INSERT INTO nkn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vamukumbuluile nguavo, “Yove uasemukililile mu vupi, nkuma utonda kutulongesa ndi?” Kaha vamushekele mu njivo ya malombelo. ");
INSERT INTO nkn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Omo Yesu uevuile nguavo vanamusheke, kaha omo uamuuanene, uahandekele nguendi, “Uatsiliela muli Muna Muntu ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uamukumbuluile nguendi, “Napu iya, Muene? Njileke, linga njimutsiliele.” ");
INSERT INTO nkn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu uahandekele kuli ikeye nguendi, “Uamumono, nou ali nakuhandeka kuli yove ikeye vene.” ");
INSERT INTO nkn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Uahandekele nguendi, “Muene, njitsiliela.” Kaha uamulemesele. ");
INSERT INTO nkn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu uahandekele nguendi, “Njezile hano ha mavu mu kusompa linga vaje kuvamono linga vamone, naua navaje vamona linga keti vamone.” ");
INSERT INTO nkn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Vamo va Vafaliseo vaje vakele hayehi nendi vovuile eci vahandekele kuli ikeye nguavo, “Cili vene netu naua tutupuputua ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu uahandekele kuli vakevo nguendi, “Nga muapuile tupuputua, ngue kumuesi na vupi. Vuno honi muhandeka ngueni, ‘Tumona,’ vupi vueni hanga vuakala.” ");
INSERT INTO nkn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu uahandekele nguendi, “Mua vusunga vene njimileka nguange, uoshe uje akovelela ku cikolo ca limba lia vampanga napu kaniungi ua vusunga, vuno honi uje alikuasesa ngila yeka napu muizi cipue muhuza, ");
INSERT INTO nkn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","vuno honi uje akovelela ku cikolo napu kaniungi ka vampanga. ");
INSERT INTO nkn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Muka kuniunga ku cikolo akamushokuelela cikolo, kaha vampanga vakevu lizi liendi. Akavasana vampanga vendi ha lizina nakuvatuamenena mukulovoka. ");
INSERT INTO nkn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Omo nga natuhuisa voshe, akai kulutue luavo, kaha vampanga vaka mukavangeya omuo vatantekeya lizi liendi. ");
INSERT INTO nkn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kuvakakava mungenzi, vuno honi vakamuteua omuo kuvatantekeya lizi lia vangenzi.” ");
INSERT INTO nkn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ualikuasesele mezi aua kuli vakevo, vuno honi kuvevuisisile viakele nakuhandeka kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kaha naua Yesu uahandekele kuli vakevo nguendi, “Cili vene njimileka nguange, yange cikolo ca vampanga. ");
INSERT INTO nkn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Voshe vezile kulutue luange vapuile vezi na mihuza, vuno honi vampanga kuvevuililile kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yange cikolo, uoshe akovela kuhitila muli yange, akovoka, kaha akakovela nakulovoka na kuuana muila ua cili. ");
INSERT INTO nkn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muizi akeja lika na kuiva, na kutsiha na kupihisa, yange njezilile lika linga vakale na muono uacili mukushula. ");
INSERT INTO nkn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yange kaniungi uacili. Kaniungi uacili akatsila vampanga vendi. ");
INSERT INTO nkn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uakukumuna uje keti kaniungi naua kakele na vampanga, omo amona kangunga kaha aseza vampanga na kuteua, kaha uje kangunga akuata vaje vampanga nakuvashandola. ");
INSERT INTO nkn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Uje uakukumuna ateua omuo kazangele vampanga. ");
INSERT INTO nkn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nji kaniungi uacili, njitantekeya vange kaha vange naua vanjitantekeya, ");
INSERT INTO nkn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ngue omuo Tate anjitantekeya nange naua njitantekeya Tate, kaha njitsila vampanga vange. ");
INSERT INTO nkn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kaha njili na vampanga veka, vaje keti va mulimba lino, njapande kuvaneha naua, kaha vakovuilila lizi liange. Kaha vakapua vutanga vumo, na kaniungi umo. ");
INSERT INTO nkn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mucifua eci vene Tate uanjizanga, omuo njihana muono uange, linga njikauambate naua. ");
INSERT INTO nkn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naumo uahi akauambata kuli yange, vuno honi njihana muono uange mukulihana. Njili nanzili yaku utula, naua njili nanzili yaku uambata, eci kushika njinacambata kuli Tate.” ");
INSERT INTO nkn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kaha naua vantuama va Vayunda valihangunuine omuo ya mezi aua. ");
INSERT INTO nkn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vuingi vuavo vahandekele nguavo, “Ali na lihamba naua nazaluka, vika muli naku muivuililila?” ");
INSERT INTO nkn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Vakuavo vakele nakuhandeka nguavo, “Aua keti mezi a muntu uje ali na lihamba. Nkuma lihamba liasa kuimuisa kapuputua ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ha ntsimbu ije ciuano ca Kukundika cakele ku cihela ca Yelusalema. Capuile cisika, ");
INSERT INTO nkn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","na Yesu uakele nakuenda mu vimbalaka via njivo ya Njambi, mu mbalanda ya Solomoni. ");
INSERT INTO nkn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kaha vantuama va Vayunda vamuzengelekele nakuhandeka kuli ikeye nguavo, “Vintsimbu vingahi ukatuseza mu citanga? Nga yove Kilistu tuleke vusunga.” ");
INSERT INTO nkn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu uavakumbuluile nguendi, “Njamilekele vuno honi ku muanjitsilielelele. Vipangi vije njikapanga mu lizina lia Tate, vihandeka vukaleho hali yange, ");
INSERT INTO nkn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","vuno honi kumuvitsiliela, omuo kumuakundamene ku vampanga vange. ");
INSERT INTO nkn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vampanga vange vakevu lizi liange, kaha njivatantekeya naua vakanjikavangeya. ");
INSERT INTO nkn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Njikavahana muono uayaye, naua kuvakanongo. Naumo uahi akavahumisa mu livoko liange. ");
INSERT INTO nkn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Vije viananjihana Tate vinapu viakama kupulakana vioshe, kaha naumo uahi asa kuvihumisa mu livoko lia Tate. ");
INSERT INTO nkn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tate nange tunapu umolika.” ");
INSERT INTO nkn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vantuama va Vayunda vambatele mavue linga vamuashe. ");
INSERT INTO nkn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu uavakumbuluile nguendi, “Njamipangela vipangi viacili viavingi viakuhuminina kuli Tate, hali vioshe evi njalingi cilihoni munjashela mavue?” ");
INSERT INTO nkn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Vantuama va Vayunda vamukumbuluile nguavo, “Keti nguavo ha vipangi viacili tukuashela mavue, vuno honi yove uli nakushaula Njambi, omuo yove u muntu lika vuno honi ulinakulilinga ngue u Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu uavakumbuluile nguendi, “Nkuma kuvacisonekele mu lishiko lieni nguavo, ‘Njahandekele nguange, mu vanjambi ndi’? ");
INSERT INTO nkn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nga kuli vaje lizi lia Njambi liezile vavatumbuile nguavo ‘vanjambi’ (naumo uahi asa kuhaka kumukulo vije vivihandeka visoneka), ");
INSERT INTO nkn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nkuma muhandeka ngueni uje Tate yanalelesa nakumutuma ha mavu alinakushaula Njambi omuo njahandekele nguange, ‘Nji Muna Njambi ndi’? ");
INSERT INTO nkn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nga kunjesi nakupanga vipangi via Tate, kaha keti munjitsiliele, ");
INSERT INTO nkn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","vuno honi nga njilinakuvipanga, cipue vene kumunjitsiliela, tsilieleni vipangi, linga mukatantekeye na kuvua ngueni Tate ali muli yange kaha nange njili muli Tate.” ");
INSERT INTO nkn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kaha vesekele kumukuta vuno honi uapusunukile mu mavoko avo. ");
INSERT INTO nkn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kaha uahilukilile naua musinia lia ndonga ya Yundau ku cihela cije Iuano uakele nakumbuitikila ha kulivanga, kaha uakakele kuje. ");
INSERT INTO nkn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vavengi vezile kuli ikeye nakuhandeka nguavo, “Iuano kalingile vitantekeyeso vuno honi vioshe vije Iuano uahandekele hali ou yala viapuile via vusunga.” ");
INSERT INTO nkn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kaha vavengi vamutsilielelele. ");
INSERT INTO nkn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kuakele yala uakele nakuvavala ua lizina lia Lazalu uaku Mbeteniya, kuje kuvakele vamunaina Maliya na Mata. ");
INSERT INTO nkn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ou ikeye Maliya uje uetilile Muene mazi akunika aseho nakumuhunda ku viliato na vinkambu viendi ikeye uje munaina Lazalu uakele nakuvavala. ");
INSERT INTO nkn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nankuma vamuanaye vatumine mezi kuli Yesu nguavo, “Muene, uje kavusamba kove ali nakuvavala.” ");
INSERT INTO nkn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Vuno honi omo Yesu uacivuile uahandekele nguendi, “Eci kuvavala keti ca kutsa, vuno honi cinapu ca vumpau vua Njambi, linga Muna Njambi vamujundule kuhitila muli cikeco.” ");
INSERT INTO nkn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu uazangele Mata na munaina Lazalu. ");
INSERT INTO nkn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Munima yakuivua nguavo Lazalu ali nakuvavala, uatumameneko naua matangua avali kuje kuakele. ");
INSERT INTO nkn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kaha munima yakuivua ou muzimbu uahandekele kuli vandongisi vendi nguendi, “Tuyeni ku nganda ya Yundeya naua.” ");
INSERT INTO nkn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vandongisi vendi vahandekele kuli ikeye nguavo, “Lambi, vantuama va Vayunda vatondele kukuasha mavue, nkuma uciyako naua ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu uavakumbuluile nguendi, “Nkuma keti mahola likumi na avali ha litangua ndi? Vaje vakakuenda mutania, kuvekutsutsuka omuo vakamono ceke ca ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Vuno honi vaje vakakuenda vutsiki vakatsutsuka, omuo ceke kucesi muli vakevo.” ");
INSERT INTO nkn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Munima yakuhandeka eci, uavalekele nguendi, “Kavusamba ketu Lazalu nakosa tulo, vuno honi njiya naku muhindula mutulo.” ");
INSERT INTO nkn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vandongisi vendi vahandekele kuli ikeye nguavo, “Muene, nga nakosa tulo, kaha akahinduka.” ");
INSERT INTO nkn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu uahandekele kutsa ca Lazalu, vuno honi vakevo vasinganiekele nguavo nahandeka nguendi nakosa tulo lika. ");
INSERT INTO nkn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kaha Yesu uavalekele vusunga nguendi, “Lazalu natsi. ");
INSERT INTO nkn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Omuo yeni njavuahelela ngeci kunjakeleko, linga mutsiliele. Vuno honi tuyeni kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi, ivatumbuile nguavo Mpasa, uahandekele kuli vakuavo vandongisi nguendi, “Netu tuyeni, linga tukatse nendi.” ");
INSERT INTO nkn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Omo Yesu uahetele, uauanene Lazalu tele ali na matangua auana mu cihilo. ");
INSERT INTO nkn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mbeteniya yapuile kuyehi na nganda ya Yelusalema mu mantambo atatu lika, ");
INSERT INTO nkn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kaha vuingi vua Vayunda vezile kuli Mata na Maliya mukuva simpisa omuo hakutsa ca munaina Lazalu. ");
INSERT INTO nkn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Omo Mata uevuile nguavo Yesu ali nakuija, uamusheshele, tele Maliya ali mu njivo. ");
INSERT INTO nkn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata uahandekele kuli Yesu nguendi, “Muene, nga unakele kuno, muanetu ngue katsile. ");
INSERT INTO nkn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Vuno honi cipue ntsimbu ino njatantekeya nguange vioshe ulomba kuli Njambi, akakuhanavio.” ");
INSERT INTO nkn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu uahandekele kuli ikeye nguendi, “Muanoko ahinduka naua.” ");
INSERT INTO nkn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata uahandekele kuli ikeye nguendi, “Njatantekeya vene nguange akahinduka ha ntsimbu ya kusanguka ha litangua lia mamanusuilo.” ");
INSERT INTO nkn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu uahandekele kuli ikeye nguendi, “Yange kusanguka na muono, voshe vaje vatsiliela muli yange, cipue vakatsa, vakayoya naua, ");
INSERT INTO nkn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","kaha uoshe ayoya nakutsiliela muli yange kakatsiho. Utsiliela eci ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Uahandekele kuli ikeye nguendi, “Eyo, Muene, Njatsiliela nguange yove Kilistu Muna Njambi, uje akeja hano ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Munima yakuhandeka evi, Mata uaile nakusana munaina Maliya, uamusanenene kuali kaliendi nakumulekesa nguendi, “Mulongisi uno ali nakukusana.” ");
INSERT INTO nkn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kaha omuo uacivuile, uakatukile vuasi vuasi nakuya kuli Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Honi Yesu tele kanda ahete hembo, vuno honi uakele ku cihela kuje kualiuanenene na Mata. ");
INSERT INTO nkn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vayunda vaje vakele nendi mu njivo nakumusimpisa, vamuene Maliya akatuka vuasi vuasi nakuya hambanza, vamukavele omuo vasinganiekele nguavo alinakuya ku cihilo nakulililako. ");
INSERT INTO nkn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Omo Maliya uahetele kuje kuakele Yesu nakumumona, uauililile ku viliato viendi nakuhandeka nguendi, “Muene, nga unakele kuno ngue muanetu katsile.” ");
INSERT INTO nkn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Omo Yesu uamumuene alinakulila na vaje Vayunda vezile navo, uakele na vusiua cikuma mu Cimbembesi. ");
INSERT INTO nkn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kaha uahandekele nguendi, “Mua mutsindi kuli?” Vahandekele kuli ikeye nguavo, “Muene, ija umone.” ");
INSERT INTO nkn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ualilile. ");
INSERT INTO nkn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kaha Vayunda vahandekele nguavo, “Haaa! Taleni mua muzangelelele!” ");
INSERT INTO nkn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Vuno honi vamo vavo vahandekele nguavo, “Keti ikeye uje uemuisile uje yala ua kapuputua ndi, vikahoni kalingililile ou yala linga keti atse?” ");
INSERT INTO nkn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kaha Yesu naua uakele na vusiua cikuma, kaha uaile ku cihilo. Capuile cihilo cakuhinda mu livue, kuakele livue ku cikolo ca cihilo. ");
INSERT INTO nkn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu uahandekele nguendi, “Humiseniko livue eli.” Mata munaina ya uje yala uatsile, uahandekele kuli ikeye nguendi, “Muene, ntsimbu ino alinakunika, omuo ali na matangua auana mu cihilo.” ");
INSERT INTO nkn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu uahandekele kuli ikeye nguendi, “Nkuma kunjakulekele nguange nga uatsilielele nga umona vumpau vua Njambi ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kaha vahumisileko livue. Kaha Yesu uandukile nakuhandeka nguendi, “Tate, njantsantselako ha kunjivua. ");
INSERT INTO nkn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Njatantekeya nguange ukanjivu ntsimbu yoshe, vuno honi njahandeka evi ha mesho a vantu ava vanemana hano, linga vatsiliele nguavo yove uanjitumine.” ");
INSERT INTO nkn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Munima yakuhandeka evi, uatambakanene nguendi, “Lazalu, humamo!” ");
INSERT INTO nkn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Uje uatsile uahindukile, oku mavoko na mikono yendi yakukuta na vintanga, na cihanga cendi vacizengele na ntanga. Yesu uahandekele kuli vakevo nguendi, “Muzituleni, kaha mueceleni aye.” ");
INSERT INTO nkn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Vuingi vua Vayunda vaje vezile na Maliya omo vamuene vialingile Yesu, vatsilielele muli ikeye, ");
INSERT INTO nkn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","vuno honi vamo vaile kuli Vafaliseo nakuvalekesa vialingile Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nankuma vakuluntu va tusasendote na Vafaliseo valiuanene na vaka mpunga nakuhandeka nguavo, “Vika vituapande kulinga? Omuo ou yala alinakulinga vitantekeyeso viavingi. ");
INSERT INTO nkn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nga tumuecelela muje vene, kaha muntu uoshe akatsiliela muli ikeye, kaha Valoma vakeja naku pihisa njivo ya Njambi na lifuti lietu.” ");
INSERT INTO nkn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Vuno honi umo uavo, Kayafase, uje uapuile kasasendote uakama ha muaka uje, uahandekele kuli vakevo nguendi, “Navimo viahi vimutantekeya! ");
INSERT INTO nkn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kumuevuile nguavo cacili muntu umolika kutsila vantu, kupulakana lifuti lioshe kunonga.” ");
INSERT INTO nkn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kahandekele eci mu nzili yendi lika, vuno honi mukupuako kasasendote uakama ha muaka uje, uananguile nguendi Yesu napande kutsila vantu, ");
INSERT INTO nkn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kaha keti vantu lika vuno honi kukungulula vana va Njambi na vaje valishandokela ku mafuti eka. ");
INSERT INTO nkn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kuhuma ha litangua lije vatondele ngila ya kumutsihilamo. ");
INSERT INTO nkn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nankuma Yesu kalisholuele ceka naua kuli Vayunda, vuno honi uahumine kuje nakuya ku nganda ije ivatumbuile Efalime ku mutambela uje uakele kuyehi namu mpambo, kaha uakakele kuje na vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tele Ciuano ca Paseka ya Vayunda cakele kuyehi, vavengi vahumine mu lifuti nakuya ku Yelusalema ntsimbu kanda Paseka ihete nakulilelesa vakevo vavenia. ");
INSERT INTO nkn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Vakele nakutonda Yesu kaha vakele nakulihozola umo na mukuavo oku tele vali mu vimbalaka via njivo ya Njambi nguavo, “Musinganieka vika? Nkuma cilivene keja kuno ku ciuano ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Honi vakuluntu va tusasendote na Vafaliseo vashikile nguavo uoshe uje atantekeya kuje kuali Yesu avalemuise, linga vamukuate. ");
INSERT INTO nkn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tele matangua atanu na limo kanda ahete a paseka, Yesu uezile ku Mbeteniya kuimbo lia Lazalu, uje ya sanguile Yesu kuvatsi. ");
INSERT INTO nkn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Vamuvuaheselele kulia ca cinguezi, Mata uamuhanene via kulia, na Lazalu uapuile umo uavaje vakele nendi ku mesa. ");
INSERT INTO nkn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliya uambatele kantsazi kakupuisa hhakati ka mazi a luengo luacili nakuvuavesa ku viliato via Yesu nakuhunda viliato viendi na vinkambu viendi, kaha njivo yoshe yashulile na luengo luacili lua mazi. ");
INSERT INTO nkn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Vuno honi Yundasa Sakaliote, umo ua vandongisi vendi (ikeye uje akamuenda vungungu), uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Vika aua mazi a luengo lua cili ku va alandesela ha vimbongo via muuaya uaya viakupua vihita vitatu (300) na kuviana ku tuhutu?” ");
INSERT INTO nkn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uahandekele evi keti ngue uakele nakuniunga vuino tuhutu vuno honi omuo uapuile muizi, uakele na cikuama cakuhaka vimbongo muje muakele nakuiva. ");
INSERT INTO nkn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu uahandekele nguendi, “Mueceleni atumbikile ha ntsimbu yange ya kunjitsinda. ");
INSERT INTO nkn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tuhutu mukala navo ntsimbu yoshe, vuno honi yange kumukakala nange ntsimbu yoshe.” ");
INSERT INTO nkn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Omuo civunga ca Vayunda ca tantekeyele nguavo ali kuje, vezile keti lika omuo ya Yesu vuno honi kuija nakumona Lazalu, uje ivasanguile ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaha vakuluntu va tusasendote vasinganiekele muakutsihila Lazalu naua. ");
INSERT INTO nkn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Omuo ya vije vialingiuile kuli ikeye vuingi vua Vayunda va vavianene kaha vatsilielelele Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Omuo kuacele liamukuavo vantu vavengi vezile ku ciuano kaha vovuile nguavo Yesu ali nakuija ku nganda ya Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kaha vambatele mintango ya miti ya mambale nakumushesha oku vatambeka nguavo, “Hosana! Hosana! Uakukuisuliua uje eja mu lizina lia Muene, Shukulu ua Isaleli!” ");
INSERT INTO nkn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kaha Yesu uauanene muna cimulu, kaha ualondeleho nakutumama, ngue muje vacisoneka mu visoneka nguavio, ");
INSERT INTO nkn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Keti uteue, muana ua mpuevo ua Zioni, tala, Muene yove ali nakuija natumama ha muongo ua muna cimulu!” ");
INSERT INTO nkn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vandongisi vendi kuvatantekeyele evi hakulivanga, vuno honi omuo Yesu vamujunduile mu vumpau vuendi, kaha vanukile nguavo evi viuma vavisonekele hali ikeye kaha vialingiuile kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Civunga cije cakele nendi omo muahinduile Lazalu na kumuhumisa mu cihilo nakumusangula kuvatsi vahanene vukaleho. ");
INSERT INTO nkn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Omo civunga cevuile nguavo nalingi vitantekeyeso kaha vaile nakuliuana nendi. ");
INSERT INTO nkn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kaha Vafaliseo vahandekele kuli umo na mukuavo nguavo, “Taleni, mavu oshe ali nakumukava.” ");
INSERT INTO nkn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hhakati kavaje vaile na kulemesa ku ciuano, vamo vapuile Vangelengu. ");
INSERT INTO nkn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kaha vezile kuli Filipu uje uahumine ku Mbetesainda ku nganda ya Ngalileya, vahandekele kuli ikeye nguavo, “Muene, tutonda linga tumone Yesu.” ");
INSERT INTO nkn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu uaile nakuleka Anduleo, kaha Anduleo uaile na Filipu nakuleka Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kaha Yesu uavakumbuluile nguendi, “Ntsimbu inahete linga Muna Muntu vamujundule. ");
INSERT INTO nkn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cilivene njimileka nguange, kuvanga nona ya tiliku iuile ha mavu na kutsa, kaha ikakala likaliayo, vuno honi nga itsa, kaha ikahaka vushuka vua vuingi. ");
INSERT INTO nkn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Voshe vaje vazanga miono yavo vaka izimbalesa, kaha na vaje voshe vazinda miono yavo hano ha mavu vanalitulikila miono yayaye. ");
INSERT INTO nkn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nga uoshe uje anjipangela napande kunjikava, kaha kunjikakala yange, na vangamba vange vakakalako. Uoshe anjipangela, na Tate akamusingimika. ");
INSERT INTO nkn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Mutima uange uli nakulinienga. Kaha njikahandeka vika, ‘Tate, njohiele ha hola ino ndi’? Houe, omuo ha cuma eci njinahete ha hola ei. ");
INSERT INTO nkn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, lemesa lizina liove.” Kaha lizi liahumine muilu ngualio, “Njalilemesa, kaha njikalilemesa naua.” ");
INSERT INTO nkn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Civunga cije cemanene kuje cevuile evi kaha vahandekele nguavo muhiato unalumu. Veka vahandekele nguavo, “Kangelo nahandeka kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu uavakumbuluile nguendi, “Eli lizi linezila omuo yeni, keti yange. ");
INSERT INTO nkn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Eci cinapu kusompa ca mavu, honi muka kuyula ua hano ha mavu vaka muhumisaho. ");
INSERT INTO nkn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nga yange omo vaka njijundula hano ha mavu, vantu voshe vakeja kuli yange.” ");
INSERT INTO nkn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Uahandekele eci kumuesa kutsa cije cakatsilamo. ");
INSERT INTO nkn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Civunga camukumbuluile nguavo, “Tunevu ku lishiko ngualio Kilistu akayoya miaka yoshe. Cineja vati uhandeke nguove Muna Muntu vakamujundula? Iya honi ou Muna Muntu?” ");
INSERT INTO nkn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu uahandekele kuli vakevo nguendi, “Ceke cili neni lika muka ntsimbu kakandende. Endeni oku muli na ceke, linga milima keti imihiane, uje enda mu milima, kekutantekeya kuje ali nakuya. ");
INSERT INTO nkn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ha ntsimbu ije mucili na ceke, tsilieleni mu ceke, linga mukapue vana va ceke.” Munima yakuhandeka evi, Yesu uaile nakulishueka. ");
INSERT INTO nkn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cipue vene ualingile vitantekeyeso viavingi hhakati kavo, vuno honi vantuama va Vayunda kuvamutsilielele. ");
INSERT INTO nkn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Eci capuile kushulisisa lizi liahandekele kananguizi ua Njambi Isaya ngualio: “Muene, iya natsiliela muzimbu uetu, kaha kuli iya livoko lia Muene kuvanalisholuela?” ");
INSERT INTO nkn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kaha kuvatsilielelele, omuo Isaya naua uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Napuisa mesho avo vupuputua nakukolesa mitima yavo, linga mesho avo keti amone, na mitima yavo keti ivuisise kaha kuvakatengulukila kuli yange linga njika vakanguise.” ");
INSERT INTO nkn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya uahandekele eci omuo uamuene vumpau vuendi na kuhandeka hali Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cipue vene ngoco, vamo vantuama va Vayunda vavengi vatsilielelele muli ikeye. Vuno honi omuo hakuteua Vafaliseo kuvalitavelelele, hakuteua nguavo vakavasheka mu njivo ya malombelo, ");
INSERT INTO nkn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","omuo vazangele kulemesa ca vantu kupulakana kulemesa ca Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kaha Yesu uatambakanene cikuma nguendi, “Uoshe atsiliela muli yange, katsilielele muli yange lika vuno honi muli uje ua njitumine. ");
INSERT INTO nkn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kaha uoshe uje amona yange, namono naua na uje ua njitumine. ");
INSERT INTO nkn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Njineja ngue ceke ha mavu, linga uoshe atsiliela muli yange keti akale mu milima. ");
INSERT INTO nkn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kunjikasompo uoshe uje evua mezi ange nakuhona kuaniunga, omuo kujezile mukusompesa mavu, vuno honi muku ovola. ");
INSERT INTO nkn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Uje uoshe anjiviana nakuhona kutambula lizi liange alina muka kusompa, ha litangua liama manusuilo lizi eli njahandeka likapua ngue muka kusompa. ");
INSERT INTO nkn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Omuo kunjahandekele mu nzili yange lika, vuno honi Tate uje uanjitumine ikeye vavenia nanjihana lishiko muje munjikahandekela. ");
INSERT INTO nkn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kaha njatantekeya nguange lishiko liendi linapu muono uayaye. Evi njihandeka, nankuma, njihandeka kuya muje Tate muananjilekela.” ");
INSERT INTO nkn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tele kanda ciuano ca Paseka cihete, Yesu uatantekeyele nguendi ntsimbu yendi yakuhuma ha mavu nakuya kuli Ishe inahete. Ha kuzanga vendi vaje vakele ha mavu, uavazangele nakumamanusuilo. ");
INSERT INTO nkn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kaha ha kulia ca cinguezi, Satana tele nakovela laja mu mutima ua Yundasa Sakaliote, muna Simoni, uje akamuenda vungungu, ");
INSERT INTO nkn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ha kutantekeya nguendi Ishe namuhana vioshe mu mavoko endi, omuo uahumine kuli Njambi kaha naua ali nakuhiluka kuli Njambi, ");
INSERT INTO nkn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","uakatukile ku mesa, uashuluile cikovelo cendi cahelu, kaha ualikutile ntanga yendi mu mbunda. ");
INSERT INTO nkn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kaha uetilile mema mu lilonga, nakuputuka kutanesa viliato via vandongisi vendi, kaha uavahundile na ntanga ije ya likutile mu mbunda. ");
INSERT INTO nkn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uezile kuli Simoni Petulu, kaha Petulu uahandekele nguendi, “Muene, ukatanesa viliato viange ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu uamukumbuluile nguendi, “Vinjili nakulinga kumuvitantekeya ha ntsimbu ino, vuno honi kulutue muka vitantekeya.” ");
INSERT INTO nkn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulu uahandekele kuli ikeye nguendi, “Ku ukatanesaho viliato viange.” Yesu uamukumbuluile nguendi, “Nga kunjikutanesa, ku ukapu naua ndongisi uange.” ");
INSERT INTO nkn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulu uahandekele kuli ikeye nguendi, “Muene, keti utanese lika viliato viange vuno honi utanese na mavoko ange na mutue uange!” ");
INSERT INTO nkn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu uahandekele kuli ikeye nguendi, “Uoshe uje natana katela kutana naua, kuvanga lika ku viliato viendi, vuno honi muvila uendi una lele laja, kaha neni mualele, vuno honi keti muva voshe.” ");
INSERT INTO nkn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Omuo uatantekeyele uje akamuenda vungungu, ha cuma eci mukemo uahandekele nguendi, “Keti muva voshe munalele.” ");
INSERT INTO nkn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Omuo Yesu uamanusuile kuvatanesa ku viliato viavo, kaha uambatele kazaku kendi nakuzala, uahilukile nakukatumama ku mesa, kaha uahandekele kuli vakevo nguendi, “Muatantekeya vinjinalingi kuli yeni ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukanjitumbula ngueni, “Mulongisi na Muene, eyo mukahandeka muacili, omuo omu mukemo vene munjafua. ");
INSERT INTO nkn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nga yange vene Muene ueni na Mulongisi ueni, njamitanesa ku viliato vieni, neni naua muapande ku tanesa umo na mukuavo ku viliato vieni. ");
INSERT INTO nkn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Omuo yange njamihana cimueso, linga neni mulinge munjinalingi kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cilivene muavusunga njimileka nguange, ngamba kapulakana muene uendi, cipue kanganda kasa kupulakana uamutumine. ");
INSERT INTO nkn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nga muatantekeya evi viuma, kaha mupua vakukuisuliua nga muvilinga. ");
INSERT INTO nkn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kunjesi nakuhandeka muva voshe, njatantekeya ava njinahangula. Vuno honi linga visoneka vilishulisilile vije vihandeka nguavio, ‘Uje ualile mbolo yange lelo na njitengulukila.’ ");
INSERT INTO nkn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Njimileka eci ha ntsimbu ino kanda vilingiue, linga omuo vikalingiua mukatsiliele ngueni, ‘Yange vene ikeye.’ ");
INSERT INTO nkn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cilivene muavusunga njimileka nguange, uoshe uje atambula uje injituma natambula yange, kaha uoshe anjitambula atambula uje uanjitumine.” ");
INSERT INTO nkn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Munima yakuhandeka evi, Yesu uakele na vusiua mu Cimbembesi, kaha uahandekele nguendi, “Cilivene muavusunga njimileka nguange, umo ueni akanjenda vungungu.” ");
INSERT INTO nkn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vandongisi vendi valitalele umo na mukuavo, kuvatantekeyele uje yahandekele. ");
INSERT INTO nkn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Umo ua vandongisi vendi uje Yesu yazangele cikuma, uajendamenene cikuma ha ntulo ya Yesu, ");
INSERT INTO nkn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","nankuma Simoni Petulu uayevetele kuli ikeye nguendi, “Muihule atuleke uje yali nakuhandeka.” ");
INSERT INTO nkn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Omuo uajendamenene cikuma kuli Yesu, uamuhuile nguendi, “Muene, nkuma iya honi?” ");
INSERT INTO nkn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu uamukumbuluile nguendi, “Uje vene injikahana ei mbazuvuila ya mbolo munima yakuitanta mu lilonga.” Kaha omo naitanta, uaihanene Yundasa, muna Simoni Sakaliote. ");
INSERT INTO nkn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Munima yakutambula ije mbazuvuila ya mbolo, Satana uakovelele muli Yundasa. Kaha Yesu uahandekele kuli ikeye nguendi, “Linga vuasi vije viutonda kulinga.” ");
INSERT INTO nkn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naumo uahi kuje ku mesa uatantekeyele vika uahandekelele evi kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Vamo vasinganiekele nguavo, omuo Yundasa uapuile muka kuniunga cikuama ca vimbongo, Yesu uamulekele nguendi, “Landa vije vitondeka ha ciuano,” cipue ahaneko vimo kuli tuhutu. ");
INSERT INTO nkn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Munima ya kutambula mbazuvuila ya mbolo, hajevene uahumineho. Tele vutsiki. ");
INSERT INTO nkn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Omo Yundasa uahumineho, Yesu uahandekele nguendi, “Vuavuno Muna Muntu vamulemesa, kaha muli ikeye naua Njambi vamulemesa. ");
INSERT INTO nkn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nga Njambi vamulemesa kuhitila muli ikeye, na Njambi naua akamulemesa kuhitila muli ikeye vavenia, nakumulemesa ha ntsimbu ije vene. ");
INSERT INTO nkn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Vana vavandende, njili neni katsimbu kakandende lika. Mukanjitonda, ngue muje munjahandekele kuli vantuama va Vayunda mukemo naua njihandeka kuli yeni nguange, ‘Kunjili nakuya, kumukasa kuyako.’ ");
INSERT INTO nkn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Njimihana lishiko lialiha: lizangeni umo na mukuavo. Ngue munjinamizangelamo, neni naua muapande kulizanga umo na mukuavo. ");
INSERT INTO nkn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hakulinga eci vantu voshe vakatantekeya nguavo mu vandongisi vange, nga muli na cizango hali umo namukuavo.” ");
INSERT INTO nkn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulu uahandekele kuli ikeye nguendi, “Muene, kuli ulinakuya?” Yesu uamukumbuluile nguendi, “Oku njili nakuya kumuasa kunjikava ha ntsimbu ino, vuno honi mukanjikava munima.” ");
INSERT INTO nkn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulu uahandekele kuli ikeye nguendi, “Muene, vika kunjasela kukukava ha ntsimbu ino? Njikatula muono uange hali yove.” ");
INSERT INTO nkn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu uakumbuluile nguendi, “Nkuma ukasa kutula muono uove hali yange ndi? Muavusunga vene njikuleka nguange, ntsimbu kanda ndemba atambeke ukanjiviana lutatu. ");
INSERT INTO nkn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Keti mulinienge mu mitima yeni, tsilieleni muli Njambi kaha tsilieleni muli yange naua. ");
INSERT INTO nkn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu njivo ya Tate muakala milili yaingi, nga ketimo, nga njamileke nguange njiya nakumivuahesela cihela ndi? ");
INSERT INTO nkn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Honi nga njiya nakumivuahesela cihela, njikeja naua nakumiambata yange vavenia, linga kuje kunjakala neni mukakaleko. ");
INSERT INTO nkn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kaha honi mukatantekeya ngila ya kuje ku cihela kunjili nakuya.” ");
INSERT INTO nkn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi uahandekele kuli ikeye nguendi, “Muene, kututantekeya oku ulinakuya, tukatantekeya vati ngila?” ");
INSERT INTO nkn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu uahandekele kuli ikeye nguendi, “Yange ngila, na vusunga, na muono. Naumo uahi eja kuli Tate, kuvanga kuhitila muli yange. ");
INSERT INTO nkn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nga muatantekeya yange, kaha na Tate muamutantekeya naua, kuhuma hano kutuala kulutue muamutantekeya kaha mua mumono.” ");
INSERT INTO nkn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu uahandekele kuli ikeye nguendi, “Muene, tumuese Isho, kaha tuapuisamo.” ");
INSERT INTO nkn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kaha Yesu uahandekele kuli ikeye nguendi, “Nkuma kunjakele nove ntsimbu yailaha Filipu, vuno honi na ntsimbu ino kanda unjitantekeya ndi? Uoshe namono yange namono na Tate naua, uhandeka vatihoni nguove, ‘Tumuese Tate’? ");
INSERT INTO nkn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nkuma ku uatsilielele nguove njakala muli Tate, na Tate uakala muli yange ndi? Mezi aua njihandeka kuli yeni,” kunjesi nakuhandeka mu nzili yange vavenia, vuno honi Tate uakala muli yange ikeye akapanga vipangi viendi. ");
INSERT INTO nkn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Njitsilieleni ngueni njakala muli Tate kaha na Tate uakala muli yange, vuno honi nga kumunjitsiliela, kaha tsilieleniko lika vipangi njili nakulinga. ");
INSERT INTO nkn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Muavusunga vene njimileka nguange, uoshe atsiliela muli yange na ikeye akalinga vipangi vinjili nakulinga, cilivene akalinga vipangi viakama kupulakana evi, omuo njilinakuya kuli Tate. ");
INSERT INTO nkn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Njikalinga coshe mukalomba mu lizina liange, linga Tate vaka mulemese kuhitila muli Muana, ");
INSERT INTO nkn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nga mulomba cili coshe mu lizina liange, njikamilingilaco. ");
INSERT INTO nkn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nga munjizanga, mukaniunga mashiko ange. ");
INSERT INTO nkn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Njikalomba Tate, kaha akamihana mukuasi mukuavo, uje akakala neni miaka yoshe. ");
INSERT INTO nkn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ou ikeye Cimbembesi ua vusunga, uje vaka mavu kuvasa kumutambula, omuo kuvekumumona cipue kumutantekeya. Yeni mu mutantekeya, omuo uakala neni, naua akakala muli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kunjikamiseze ngue vantsiua, njikeja kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Muka ntsimbu kakandende vaka mavu kuvakanjimono, vuno honi yeni mukanjimona. Omuo njayoya, neni naua mukayoya. ");
INSERT INTO nkn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ha litangua lije mukatantekeya ngueni njakala muli Tate, kaha yeni muakala muli yange, nange naua muli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Voshe vaje vali na mashiko ange naku aniunga vakevo vaje vanjizanga, kaha voshe vaje vanjizanga na Tate akavazanga, nange naua njikavazanga kaha njikalisholola yange vavenia kuli vakevo.” ");
INSERT INTO nkn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yundasa (keti Sakaliote) uahandekele kuli ikeye nguendi, “Muene, cikapua vati linga ukalisholole yove vavenia kuli yetu, vuno honi keti ku vaka mavu?” ");
INSERT INTO nkn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu uamukumbuluile nguendi, “Uje uoshe uanjizanga akaniunga lizi liange. Kaha na Tate akamuzanga, kaha tukeja kuli ikeye nakutumama hamo nendi. ");
INSERT INTO nkn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Uoshe uje kanjizanga, kaniungu mezi ange, na mezi munevu keti ange, vuno honi a Tate uje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Njahandeka evi viuma kuli yeni ha ntsimbu ino njili neni. ");
INSERT INTO nkn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Vuno honi Mukuasi, Cimbembesi Uakulela, uje Tate akatuma kuhitila mu lizina liange, akamilongesa vioshe, nakumianukisa vioshe njahandeka kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ciyulo cikale neni, ciyulo cange njamihana. Kunjicihana kuli yeni ngue muje mavu akahanenamo. Mitima yeni keti ilinienge, naua keti muteue. ");
INSERT INTO nkn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Muevuile omo njahandekele kuli yeni nguange, ‘Njili nakuya, kaha njikeja naua kuli yeni.’ Nga muanjizangele, ngue muavuahelela ngueni njiya kuli Tate, omuo Tate uakama kupulakana yange. ");
INSERT INTO nkn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Njimileka viuma evi ntsimbu kanda vilingiue, linga omuo vikalingiua mutsiliele. ");
INSERT INTO nkn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kunjikahandeka cikuma neni, omuo muka kuyula ua hano ha mavu alinakuija. Kesi na nzili hali yange, ");
INSERT INTO nkn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","vuno honi njilinga ngue omuo muananjishikilamo Tate linga mavu akatantekeye nguauo njazanga Tate. “Katukeni, tuyeni tuhume kuno ku cihela. ");
INSERT INTO nkn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yange mukolovozi ua vushuka vua vusunga, kaha Tate ikeye ndimi. ");
INSERT INTO nkn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ikeye akatete mintango muli yange ije kuyimi vushuka. Kaha muntango uoshe uje uima vushuka aunonga linga uime vushuka vua vuingi. ");
INSERT INTO nkn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vamilelesa laja na lizi lije njahandeka kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaleni muli yange ngue omuo yange njakala muli yeni. Ngue omuo muntango kuuasa kuima vushuka hali kaliauo vuno honi kuvanga ukala ha mukolovozi, neni naua kuvanga mukale muli yange. ");
INSERT INTO nkn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yange mukolovozi, kaha yeni munapu mintango kaha vaje vakakala muli yange nange njikakala muli vakevo. Kaha vakema vushuka vua vuingi, omuo kuakuhona yange nacimo cahi muasa kulinga. ");
INSERT INTO nkn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uje uoshe kakala muli yange vakamumbila ngue muntango kaha akoma, kaha mintango ya cifua eci vaka yihaka hamo nakuyumbila mu tuhia nakuitsimika. ");
INSERT INTO nkn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nga mukala muli yange, na mezi ange akakala muli yeni, lombeni vioshe vimutonda, kaha vakamihanavio. ");
INSERT INTO nkn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mucifua eci, Tate vaka mulemesa cikuma omo nga mukema vushuka vua vuingi na kupua vandongisi vange. ");
INSERT INTO nkn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngue muje muanjizanga Tate, nange vene njamizanga, kaleni mu cizango cange. ");
INSERT INTO nkn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nga muniunga mashiko ange, mukakala mu cizango cange ngue muje yange munjaniungila mashiko a Tate nakukala mu cizango cendi. ");
INSERT INTO nkn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Njahandeka viuma evi kuli yeni linga kuvuahelela cange cikale muli yeni, kaha kuvuahelela ceni cikapuisemo. ");
INSERT INTO nkn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eli likelio lishiko liange, lizangeni umo na mukuavo ngue munja mizangela. ");
INSERT INTO nkn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Naumo uahi alina cizango cakama ngue eci, cakutsila va vusamba vendi. ");
INSERT INTO nkn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Muva vusamba vange nga mulinga vije vinjimishika. ");
INSERT INTO nkn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kunji kamisana vandungo naua, omuo vandungo kuvekuntatekeya vije via kalingi Muene uavo, vuno honi njamisana vavusamba vange, omuo njamitantekeyesa vioshe vije vinjevuile kuli Tate. ");
INSERT INTO nkn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kumuanjihanguile vuno honi njamihanguile. Kaha njamihanguile nguange mukeme vushuka, vushuka vuje kuvukahu, linga Tate akamihane vioshe vije vimukalomba mu lizina liange. ");
INSERT INTO nkn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Njili nakumihana aua mashiko linga mukalizange umo na mukuavo. ");
INSERT INTO nkn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nga vaka mavu vaka mizinda, mutantekeye ngueni vazindile yange tele kanda vazinde yeni. ");
INSERT INTO nkn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nga muakundamene ku vaka mavu, ngue vaka mavu vaka mizanga ngue muvavo. Omuo kumuakundamene kuva ka mavu, vuno honi njamihangula kuhuma kuli vaka mavu, nankuma vaka mavu vamizinda. ");
INSERT INTO nkn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Anukeni lizi lije linjahandekele kuli yeni nguange, ‘Vandungo kuvasa kupulakana vimiene vavo.’ Nga vanjipakesele, kaha neni naua vakamipakesa, nga vaniungile lizi liange, kaha neni naua vakaniunga mezi eni. ");
INSERT INTO nkn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vuno honi vakalinga vioshe evi kuli yeni omuo lizina liange, omuo kuvatantekeya uje uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nga kunjezile nakuhandeka kuli vakevo ngue kuvakele na vupi, vuno honi kuvesi nacimo cije casa kuvohiela ku vupi vuavo. ");
INSERT INTO nkn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Uoshe uanjizinda, uazinda Tate naua. ");
INSERT INTO nkn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nga kunjalingile vipangi vije naumo uahi uavilinga hhakati kavo, nga kuvesi na vupi, vuno honi vanavimono, kaha vananjizindi nakuzinda Tate. ");
INSERT INTO nkn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Capuile kushulisisa lizi lije livasoneka mu lishoko liavo nguavo, ‘Vanjizindile kuakuhona mulonga.’ ");
INSERT INTO nkn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Vuno honi omo Mukuasi akeja, uje injikatuma kuli yeni kuhuminina kuli Tate, cipue Cimbembesi ua vusunga uje akahuminina kuli Tate, akahandeka vukaleho vuange. ");
INSERT INTO nkn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Neni naua mukahana vukaleho omuo munakala nange hume hambangelo. ");
INSERT INTO nkn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Njahandeka evi kuli yeni, linga keti mukahilukile munima ku kutsiliela ceni. ");
INSERT INTO nkn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vakamisheka mu vinjivo via malombelo. Cilivene ntsimbu ikaheta omo vaje vakamitsiha vakasinganieka nguavo mukulinga evi vali nakuhana mulambu uakulemesa kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kaha vakalinga evi omuo kuvantatekeya Tate cipue yange. ");
INSERT INTO nkn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Vuno honi njinamileke evi omo ntsimbu yavio ikeja linga mukanuke ngueni njamilekelevio. “Kunjahandekele viuma evi kuli yeni hambangelo, omuo njakele neni. ");
INSERT INTO nkn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Vuno honi hano njili nakuya kuli uje uanjitumine, vuno honi na umo uahi hali yeni anjihula nguendi, ‘Ulina kuya kuli?’ ");
INSERT INTO nkn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Omuo njinahandeka evi kuli yeni, vusiua vunashulu mu mitima yeni. ");
INSERT INTO nkn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cipue ngocovene njimileka vusunga, cacili kuli yeni nga njiya, nga kunjiyi, mukuasi kakeja kuli yeni, vuno honi nga njiya, njikamutuma kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kaha omo akeja, akamuesa vaka mavu ha vupi na vusunga na cisompelo, ");
INSERT INTO nkn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ha vupi, omuo kuvanjitsilielelele, ");
INSERT INTO nkn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ha vusunga, omuo njilinakuya kuli Tate kaha kumukanjimono naua, ");
INSERT INTO nkn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ha cisompelo, omuo muka kuyula mavu vanamusompo laja. ");
INSERT INTO nkn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Njicili navia vingi via kuhandeka neni, vuno honi vimilemuuila cikuma. ");
INSERT INTO nkn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Omo Cimbembesi ua vusunga akeja, akamituamenena ku vusunga vuoshe, omuo kakahandeka mu nzili yendi, vuno honi akahandeka vije via kevua, nakuhandeka kuli yeni viuma vije vikeja. ");
INSERT INTO nkn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Akanjijundula omuo akambata viange nakumilekavio. ");
INSERT INTO nkn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vioshe vije viali navio Tate vinapu viange. Mucifua eci vene njahandekele nguange akambata vije viange nakumilekavio. ");
INSERT INTO nkn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Muka ntsimbu kakandende lika, kumukanjimono, kaha naua muka ntsimbu kakandende lika, mukanjimona.” ");
INSERT INTO nkn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kaha vamo va vandongisi vendi valihandekesele umo na mukuavo nguavo, “Vika alinakulumbununa mukuhandeka kuli yetu nguendi, ‘Muka ntsimbu kakandende lika, kumukanjimono, kaha naua nguendi muka ntsimbu kakandende lika, mukanjimona’, omuo ‘Njili nakuya kuli Tate’?” ");
INSERT INTO nkn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vahandekele nguavo, “Vika alinakulumbununa omo alinakuhandeka nguendi, ‘Muka ntsimbu kakandende lika’? Kututantekeya evi alinakuhandeka.” ");
INSERT INTO nkn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu mukutantekeya nguendi vatondele kumuihula, kaha uahandekele kuli vakevo nguendi, “Muli nakulihandekesa yeni vavenia vika njalumbununa omo njahandeka nguange, ‘Muka ntsimbu kakandende lika kumukanjimono, naua muka ntsimbu kakandende lika mukanjimona’?” ");
INSERT INTO nkn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mua vusunga vene njimileka nguange, mukalila na kusikoka cikuma vuno honi vaka mavu vaka vuahelela, muka pihilila, vuno honi kupihilila ceni cikahimpuka kuvuahelela. ");
INSERT INTO nkn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nga mpuevo ali ku cihela ca kusemena, akevu kuvavala, omuo ntsimbu yendi yahete. Vuno honi nga muana nasemuka, kekuvuluka naua kuje kuvavala ca nevuile omuo cakuvuahelela cije cakuneha muntu ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Muvua kuvavala hano, vuno honi njikamimona naua, kaha mitima yeni ikavuahelela, naumo uahi akambata kuvuahelela ceni. ");
INSERT INTO nkn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ha litangua lije nacimo cahi cimukalomba kuli yange. Mua vusunga njimileka nguange, nga mukalomba cuma kuli Tate mu lizina liange, aka mihanaco. ");
INSERT INTO nkn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hume haje na kuheta lelo kumualombele nacimo cahi mu lizina liange. Vuno honi lombeni kaha mukatambula, linga kuvuahelela ceni cikapuemo. ");
INSERT INTO nkn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Njahandeka viuma evi kuli yeni mu visimo. Ntsimbu ikeja omo kunjikahandeka neni mu visimo, vuno honi njikamilekesa via Tate via vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ha litangua lije mukalomba mu lizina liange. Kunjahandekele kuli yeni nguange njikamilombelela kuli Tate, ");
INSERT INTO nkn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","omo Tate ikeye vavenia ua mizanga, omuo muazanga yange kaha muantsiliela ngueni njahuma kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Njahumininine kuli Tate kaha njezile ha mavu naua, njili nakuseza mavu kaha njili nakuhiluka kuli Tate. ");
INSERT INTO nkn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vandongisi vendi vahandekele nguavo, “Haaa! Ulinakuhandeka muacili kaha honi tulinakuivuisisa, kuuesi nakulikuasesa visimo! ");
INSERT INTO nkn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kaha hano tuatantekeya nguetu utantekeya viuma vioshe, kaha naumo uahi asa kukuihula vihula naua, ha viuma evi tuatsiliela nguetu uhuma kuli Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu uavehuile nguendi, “Muatsiliela honi ndi? ");
INSERT INTO nkn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ntsimbu ikeja, kaha ineja laja, omo mukalishandozoka muntu na muntu ku njivo yendi, kaha mukanjiseza lika liange. Vuno honi kunjesi lika liange omuo Tate ali nange. ");
INSERT INTO nkn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Njahandeka evi kuli yeni, ngeci kuhitila muli yange linga mukale na ciyulo. Ha mavu mukamona mapakeso. Vuno honi simpeni, njahiana mavu!” ");
INSERT INTO nkn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu omo uamanesele kuhandeka mezi aua, uatalele kuilu nakuhandeka nguendi, “Tate ntsimbu inahete jundula Munove linga na Munove akujundule. ");
INSERT INTO nkn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Omuo uamuhanene nzili ya kuyula vantu voshe, na kuhana muono uayaye kuli vaje voshe vaua muhanene. ");
INSERT INTO nkn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kaha ou ukeuo muono uayaye, linga vakutantekeye ngeci uapua Njambi ua vusunga lika, na Yesu Kilistu uje iuatumine. ");
INSERT INTO nkn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Njakujundula hano ha mavu mukumanesa vipangi vije viuanjihanene kupanga. ");
INSERT INTO nkn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kaha honi Tate njijundule ha mesho ove, na vumpau vuje njakele navuo hamo nove tele kanda utange mavu. ");
INSERT INTO nkn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Njinalingisa lizina liove linga valitantekeye kuli vantu vaje uanjihanene hano ha mavu. Vapuile vove, vuno honi uanjihanenevo, kaha vanononoka lizi liove. ");
INSERT INTO nkn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kaha vanatantekeya vioshe vije viuanjihanene vije via humine kuli yove. ");
INSERT INTO nkn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kaha aje mezi auanjihanene njinahana kuli vakevo, kaha vana atambula nakutantekeya muavusunga nguavo njihuminina kuli yove, kaha vanatsiliela nguavo yove uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Njili nakuvalombelela. Kunjesi nakulombelela vaka mavu, vuno honi njilinakulombelela vaje vauanjihanene, omuo yove. ");
INSERT INTO nkn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Voshe vange vanapu vove, naua vove vanapu vange, kaha vumpau vuange vukalisholola muli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hano honi kunjesi ha mavu, vuno honi vakevo vali ha mavu, yange njilinakuhiluka kuli yove naua. Tate Uakulela! Vaniunge mu lizina lije liuna njihana, linga vakapue umolika, ngue omo yetu tuapua umolika. ");
INSERT INTO nkn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Omo njakele navo njavaniungile mu lizina liove lije liuanjihanene. Njavaniungile, kaha naumo uahi uavo uazimbalele kuvanga uje ivatantekeyele nguavo akazimbala, linga visoneka vilishulisise. ");
INSERT INTO nkn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kaha honi njilinakuija kuli yove, njili nakuhandeka mezi aua ku vaka mavu linga vakakale nanzolela yange ije ikashula muli vakevo. ");
INSERT INTO nkn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Njavahana mezi ove, vuno honi vaka mavu vana azindi omuo kuuakundamene kuli vaka mavu, ngue yange kunjakundamene kuli vaka mavu. ");
INSERT INTO nkn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kunjesi nakulomba linga uvahumise hano ha mavu, vuno honi njikulomba linga uvaniunge ku citozi. ");
INSERT INTO nkn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kuvakundamene kuli vaka mavu, ngue yange kunjakundamene ku vaka mavu. ");
INSERT INTO nkn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Valelese mu vusunga omuo lizi liove liapua lia vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngue muje uanjitumine ha mavu, nange naua njavatumu ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Omo yavakevo njalilelesa yange vavenia, linga navakevo valilelese mua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kunjilombo omuo yavo lika, vuno honi kuli voshe vaje vatsiliela muli yange kuhitila mu mezi avo, ");
INSERT INTO nkn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","linga voshe vapue vamo lika. Ngue omo yove, Tate, uakala muli yange nange naua njakala muli yove, kaha na vakevo vakale muli yetu, linga vaka mavu vatsiliele nguavo yove uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Vumpau vuje vuuanjihanene njavahanako navo, linga vapue vamolika, omo yetu tuapua umolika, ");
INSERT INTO nkn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","yange muli vakevo kaha yove muli yange, kaha navo vapue vantu vamolika mu vusunga, linga vaka mavu vatantekeye nguavo yove uanjitumine kaha uavazanga ngue omo muuazangela yange. ");
INSERT INTO nkn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate, njitonda nguange vaje vauanjihanene vakakale hamo nange kuje ku njikakala, linga vakamone vumpau vuange vuje vuuanjihanene omuo uanjizangele tele kanda utange mavu. ");
INSERT INTO nkn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate uavusunga, vaka mavu kuvakutantekeya, vuno honi yange njikutantekeya, kaha ava vatantekeya nguavo yove uanjitumine. ");
INSERT INTO nkn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Njatantekeyesiua lizina liove kuli vakevo, kaha njikalitsimanesa, linga cizango cije ciuanjizanga naco cikakale muli vakevo, kaha nange muli vakevo.” ");
INSERT INTO nkn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hanima ya Yesu kuhandeka mezi aua, uaile na vandongisi vendi musinia lia cana ca Kindeloni. Ku cihela kuje kuakele citungu cije ikeye na vandongisi vendi vakovelelemo. ");
INSERT INTO nkn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kaha Yundasa uje uamuendele vungungu, nendi uatantekeyele ku cihela kuje, omuo vintsimbu via vingi Yesu uakele na kuliuanenako cikuma na vandongisi vendi. ");
INSERT INTO nkn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kaha Yundasa uaile ku citungu cije, uaile hamo namasualale va Loma na vamo vaka kuniunga Njivo ya Njambi vaje vavatumine kuli tusasendote hamo na Vafaliseo, vezile na mitetengo ya tuhia, na vindeya na vitua. ");
INSERT INTO nkn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kaha omo Yesu ha kutantekeya vije vikalingiua kuli ikeye, uezile kuli vakevo nakuvehula nguendi, “Iya muli nakutonda?” ");
INSERT INTO nkn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Vamukumbuluile nguavo, “Yesu uaku Nazaleta.” Yesu uavakumbuluile nguendi, “Yange vene ikeye.” Yundasa uje uamuendele vungungu uakele hamo navo. ");
INSERT INTO nkn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Omo Yesu uahandekele kuli vakevo nguendi, “Yange vene ikeye,” vahilukilile munima kaha vauililile ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kaha naua uavehuile nguendi, “Iya muli nakutonda?” Kaha vahandekele kuli ikeye nguavo, “Yesu uaku Nazaleta.” ");
INSERT INTO nkn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu uavakumbuluile nguendi, “Njamileke laja nguange yange vene ikeye.” Kaha nguendi, “Nga munjitonda, eceleni ava va mala vaye.” ");
INSERT INTO nkn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Uahandekele evi linga vije viahandekele vilishulisise nguavo, “Kunjazimbaleseleho naumo uahi kuli vaje vauanjihanene.” ");
INSERT INTO nkn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kaha Simoni Petulu uakele na mukuale, uatete ndungo ya kasasendote uakama lituitui lia ku cilio. Lizina lia uje ndungo liapuile Maleka. ");
INSERT INTO nkn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu uahandekele kuli Petulu nguendi, “Haka mukuale uove mucindalo cauo. Nkumani yange kunjasa kunua ei nganja yanjihanene Tate ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nankuma, masualale Valoma na mukuluntu ua vaka kushika na vaka kusuana va vantuama va Vayunda vakuatele Yesu, kaha vamukutile ");
INSERT INTO nkn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ha kulivanga vamutualele kuli Anase, uje uapuile vaishe mueno ya Kayafase, uje uapuile kasasendote uakama ha muaka uje. ");
INSERT INTO nkn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafase ualekele vantuama va Vayunda nguendi cacili muntu umo kutsila vantu voshe. ");
INSERT INTO nkn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kaha honi Simoni Petulu na ndongisi mukuavo vakavangeyele Yesu. Uje ndongisi vamutantekeyele cikuma kuli kasasendote uakama, uakovelele na Yesu mu cipango ca njivo ya kasasendote uakama, ");
INSERT INTO nkn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","vuno honi Petulu uemanene hambanza ku cikolo. Ngeci uje mukuavo ndongisi, uje ivatantekeyele cikuma kuli kasasendote uakama, uaile hambanza, nakuhandeka na mpuevo uje uakele nakuniunga ku cikolo, kaha uakovelesele Petulu mukati. ");
INSERT INTO nkn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Uje mpuevo uahandekele kuli Petulu nguendi, “Nkuma keti yove uavamo ua vandongisi va yala ou ndi?” Petulu uamukumbuluile nguendi, “Keti yange.” ");
INSERT INTO nkn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kaha vangamba na vaka kuniunga vavuekele tuhia omuo kuakele lisika, kaha voshe valizengelekele kuje ku tuhia nakuota. Na Petulu nendi uemaneneko nakuota. ");
INSERT INTO nkn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kasasendote uakama uehuile Yesu via vandongisi vendi na vilongesa viendi. ");
INSERT INTO nkn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu uamukumbuluile nguendi, “Njahandekele citona mesho ku vaka mavu, njinakala nakulongesa mu vinjivo via malombelo na mu njivo ya Njambi, muje muva kakungulukila Vayunda voshe. Kunjahandekele cuma mu vushueke. ");
INSERT INTO nkn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Vika munjihuila? Ihuleni vaje vovuile vije vinjakele nakuhandeka kuli vakevo, vatantekeya vije njakele nakuhandeka.” ");
INSERT INTO nkn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Omo uahandekele eci, umo ua vaka kuniunga uemanene hayehi nendi, uapupile mbanda Yesu ha mesho nakuhandeka nguendi, “Nkuma omu mukemo muuapande kutava Kasasendote uakama ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu uamukumbuluile nguendi, “Nga njinahandeka cuma ca cipi, leka vantu voshe vatantekeye. Vuno honi nga njinahandeka vusunga, vika honi uanjipupila?” ");
INSERT INTO nkn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kaha Anase uatumine Yesu kuli Kayafase uje uapuile Kasasendote uakama oku vanamukutu. ");
INSERT INTO nkn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kaha Simoni Petulu uemanene nakuota tuhia. Vamuhuile nguavo, “Keti yove umo ua vandongisi vendi ndi?” Uavianene nakuhandeka nguendi, “Keti yange.” ");
INSERT INTO nkn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Umo ngamba ua Kasasendote uakama, kavushoko kauje yala yatetele lituitui Petulu, uamuhuile nguendi, “Nkuma kunjakumuene na Yesu mu citungu ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kaha naua Petulu uavianene, kaha ha ntsimbu ije vene ndemba uatambekele. ");
INSERT INTO nkn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tele cimenemene vahumisile Yesu kuli Kayafase nakumutuala kuli Pilato ku lipela liakama. Kuje vakevo kuvakovelele mu lipela liakama, omuo kuvatondele kulijualesa linga vakase kulia ciuano ca Paseka. ");
INSERT INTO nkn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaha Pilato uaile hambanza kuli vakevo nakuhandeka nguendi, “Mulonga muka muamu uana nauo ou yala?” ");
INSERT INTO nkn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Vamukumbuluile nguavo, “Nga ou yala kapuile muhuza, ngue kutuamunehele kuli yove.” ");
INSERT INTO nkn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato uahandekele kuli vakevo nguendi, “Muambateni yeni vavenia linga muka musompe muje muayila lishiko lieni.” Vantuama va Vayunda vamukumbuluile nguavo, “Kuvatutavesele kutsiha muntu.” ");
INSERT INTO nkn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Eci capuile kushulisisa aje mezi ahandekele Yesu omo uahandekele kutsa cije akatsa naco apue a vusunga.) ");
INSERT INTO nkn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kaha Pilato uakovelele mu lipela liakama naua, uasanene Yesu nakumuihula nguendi, “Yove Muene ua Vayunda ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu uamukumbuluile nguendi, “Cihula eci cihuminina kuli yove vavenia, indi kuli vamo vanakuleke viange?” ");
INSERT INTO nkn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato uamukumbuluile nguendi, “Usinganieka nguove yange Kayunda ndi? Vantu vove na vakuluntu va tusasendote vakevo vanahana yove kuli yange. Vika unalingi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu uamukumbuluile nguendi, “Vumuene vuange keti vua hano ha mavu, nga vumuene vuange vuapuile vua hano ha mavu, ngue vakuasi vange ngue vanalu kuvingilika kunjihana ku mavoko a vantuama va Vayunda. Vuno honi ngue mucinafuilamo, vumuene vuange keti vua hano ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato uamuhuile nguendi, “Nkumani yove muene ndi?” Yesu uamukumbuluile nguendi “Ukahandeka nguove nji muene. Ha cuma eci vene mukemo njasemukile, kaha naua ha cuma eci vene mukemo njezile ha mavu mukuhandeka vusunga. Uoshe uje nakundama ku vusunga akevuilila ku lizi liange.” ");
INSERT INTO nkn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato uamuhuile nguendi, “Vusunga vika?” Munima yakuhande evi vioshe, Pilato uaile naua hambanza kuli vantuama va Vayunda nakuvaleka nguendi, “Kunjauanene mulonga uakumuluisa nauo ou. ");
INSERT INTO nkn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Vuno honi muli na cilika ngueni njimihumisile umo ha litangua lia Paseka. Nkuma mutonda linga njimihumisile Kuene ua Vayunda ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Vatambakanene cikuma nakumukumbulula nguavo, “Keti ou yala, vuno honi mbalambasa!” Honi mbalambasa uapuile muhuza. ");
INSERT INTO nkn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kaha Pilato uambatele Yesu nakuvahanaye linga va mupupe makote. ");
INSERT INTO nkn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Masualale vazengele cilongo ca vimbimbo vacihakele ku mutue uendi, nakumuzika cikovelo calaha ca vunengu. ");
INSERT INTO nkn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Vakele nakuija kuli ikeye okuvahandeka nguavo, “Uavulie, Muene ua Vayunda!” Oku valinakushuena kuyehi nendi nakumupupanga ku cihanga. ");
INSERT INTO nkn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato naua uatuhukile hambanza nakuhandeka kuli vakevo nguendi, “Taleni, njilinakumuneha kuli yeni linga mutantekeye ngueni kunjauanene mulonga muli ikeye uakumuluisa.” ");
INSERT INTO nkn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kaha honi Yesu uatuhukile hambanza, oku nazala cilongo ca vimbimbo na cikovelo calaha ca vunengu. Pilato uahandekele kuli vakevo nguendi, “Ou yala uno.” ");
INSERT INTO nkn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Omo vakuluntu va tusasendote na vaka kuniunga njivo ya Njambi vamumuene, vatambakanene cikuma nguavo, “Mushukikeni! Mushukikeni!” Pilato uahandekele kuli vakevo nguendi, “Muambateni yeni vavenia linga mumushukike, kunjauanene mulonga muli ikeye uakumuluisa nauo.” ");
INSERT INTO nkn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kaha vantuama va Vayunda vamukumbuluile nguavo, “Tuli na lishiko, kaha kuya ku lishiko eli napande kutsa omuo nalitumbula kupua Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Honi omo Pilato uevuile eci, uovuile liova kupulakana hakulivanga. ");
INSERT INTO nkn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Uakovelele naua mu lipela liendi nakuihula Yesu nguendi, “Uhuminina kuli?” Vuno honi Yesu kamukumbuluile. ");
INSERT INTO nkn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nankuma Pilato uahandekele kuli ikeye nguendi, “Nkuma uviana kuhandeka nange ndi? Nkuma kuuatantekeyele nguove yange njili na nzili yaku kuhumisa, na nzili ya kukushukika ndi?” ");
INSERT INTO nkn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu uamukumbuluile nguendi, “Kuuesi na nzili hali yange kuvanga vanakuhanayo kuhuminina kuli Njambi, nankuma uje uanjinehele kuli yove ali na mulonga ua vupi uakama.” ");
INSERT INTO nkn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kuhuma haje Pilato uatondele ngila ya kumuecela, vuno honi vantuama va Vayunda vatambakanene cikuma nguavo, “Nga uecela ou yala linga aye, kaha keti ukavusamba ka Sezale. Uoshe uje alitumbula ikeye vavenia kupua muene napu citozi ca Sezale.” ");
INSERT INTO nkn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Omo Pilato uevuile mezi avahandekele, uatuhuisile Yesu hambanza, kaha uatumamene ha citumamo ca kusompela ku cihela civatumbuile nguavo, “Cihela cakujala mavue,” kaha mu Cihevelu nguavo “Ngavata.” ");
INSERT INTO nkn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kaha liapuile litangua lia Kulivuahesela Paseka, tele mutania. Pilato uahandekele kuli vantuama va Vayunda nguendi, “Ou Muene ueni!” ");
INSERT INTO nkn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Vatambakanene cikuma nguavo, “Mutsihe! Mutsihe! Mushukike ha cilindakano!” Kaha Pilato uavehuile nguendi, “Mutonda njishukike Muene ueni ndi?” Vakuluntu va tusasendote vamukumbuluile nguavo, “Kutuesi na muene ueka vuno honi Sezale.” ");
INSERT INTO nkn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kaha Pilato uavahaneneye linga vamushukike. Kaha vambatele Yesu linga vakamushukike ");
INSERT INTO nkn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","kaha Yesu uambate cilindakano cendi vavenia, vaile ku cihela cije civatumbula nguavo Cikola, mu Cihevelu vacitumbula nguavo Ngolongota. ");
INSERT INTO nkn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kuje kuvamushukikile, kaha vashukikile naua nava mala vavali, umo ku cilio mukuavo ku cimoshue, na Yesu mukati kavo. ");
INSERT INTO nkn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato uasonekele helu lia cilindakano nguendi, “Yesu uaku Nazaleta, Muene ua Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Vayunda vavengi vatandele haje helu lia cilindakano, omuo ku cihela kuje kuvamushukikilile cakele kuyehi na nganda, kaha haje hacilindakano uasonekeleho mu Cihevelu na mu Cilatini, na mu Cingelengu. ");
INSERT INTO nkn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kaha vakuluntu va tusasendote na vantuama va Vayunda vahandekele kuli Pilato Nguavo, “Keti usonekeho nguove, ‘Muene ua Vayunda,’ vuvoni nguove, ‘Ou yala uahandekele nguendi nji Muene ua Vayunda.’ ” ");
INSERT INTO nkn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato uavakumbuluile nguendi, “Vinjasoneka, njasoneka.” ");
INSERT INTO nkn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Omo masualale vamanusuile kushukika Yesu, vambatele vizalo viendi, kaha vavipangele mu vimbazuvuila viuana, lisualale umo na umo uambateleko cendi. Kaha naua vambatele cikovelo cendi ca mukati cakupanga ha ntanga imolika ya maka yakuhona mungundo, kuhuma kuilu na ha mavu. ");
INSERT INTO nkn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Valihandekesele umo na mukuavo nguavo, “Keti tucitavule, vuno honi tuteni nkela tumone iya akacambata.” Eci calingiuile linga visoneka vilishulisise vije vihandeka nguavio, “Valipangezelele vizalo viange hhakati kavo, kaha omuo ya vuzalo vuange vatile nkela.” Evi vikevio vivalingile masualale. ");
INSERT INTO nkn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kaha vaje vemanene kuyehi na cilindakano ca Yesu vapuile vaina, na shongo ya vaina, na Maliya mpuevo ya Kolopase, na Maliya Mangandalena. ");
INSERT INTO nkn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Omo Yesu uamuene vaina na ndongisi uje yazangele cikuma uemanene kuyehi nendi, kaha Yesu uahandekele kuli vaina nguendi, “Mpuevo, tala, munove!” ");
INSERT INTO nkn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kaha uahandekele kuli ndongisi yendi nguendi, “Tala vanoko!” Kuhuma ha ntsimbu ije uje ndongisi uatualele vaina ya Yesu ku njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hanima yevi Yesu uatantekeyele ngeci vioshe vinahu kaha uahandekele nguendi, “Linga visoneka vilishulisise, ‘Njilinakuvua mpuila!’ ” ");
INSERT INTO nkn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kuakele nganja kuje ije ya shulile na viniu. Kaha vajavekelemo mupelo muje mu viniu na ku haka ku muntango ua Isope, vaukakuile naku haka ku kanua kendi ");
INSERT INTO nkn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Omo Yesu uatambuile viniu kaha uahandekele nguendi, “Kunahu.” Kaha uatepuile mutue uendi nakuecela Cimbembesi cendi. ");
INSERT INTO nkn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Omo liapuile litangua lia Kulivuahesela ciuano ca paseka. Vayunda kuvatondele mivila isale ha cilindakano ha litangua lia Sapalalo omuo liapuile litangua liakama cikuma. Kaha Vayunda valombele Pilato linga vapokozole mikono ya vaje vamala va vashukikile na mivila yavo linga vaihumise ha vilindakano. ");
INSERT INTO nkn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kaha masualale vezile nakupokozola mikono ya vaje mihuza va vashukikile hamo na Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Vuno honi omo vahetele kuli Yesu vamuuanene natsi laja, nankuma kuvapokuele mikono yendi. ");
INSERT INTO nkn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Umo ua vaje masualale, uatuvile Yesu likunga ku vimpati, kaha haje vene maninga na meme atuhukileko. ");
INSERT INTO nkn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Uje uamuene vioshe evi muvialingiuile uahanene vukaleho ngeci neni naua mutsiliele. Vukaleho vuendi vua vusunga, kaha atantekeya nguendi ahandeka vusunga.) ");
INSERT INTO nkn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Vioshe evi via lingiuile linga visoneka vilishulisise vije vihandeka nguavio, “Kuvitsiha viendi nacimo cahi cikapokokako.” ");
INSERT INTO nkn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kaha naua visoneka vikuavo vihandeka nguavio, “Vakatonda uje ivatuvile likunga,” ");
INSERT INTO nkn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Munima ya viuma evi, Yosefa uaku Alamatiya, uje uapuile ndongisi ua Yesu mu vushueke, omuo ya liova lia vantuama va Vayunda uezile kuli Pilato nakumulomba linga ambate muvila ua Yesu. Kaha Pilato uamuhanene nzili yakuhumisa muvila ua Yesu ha cilindakano, Kaha ua uhumisile. ");
INSERT INTO nkn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikondemo, uje ikeye ha kulivanga uaile kuli Yesu vutsiki na ikeye uaileko, uambatele makilo akupua makumi atatu a mukundu, uakupandakana na miila na malimangango. ");
INSERT INTO nkn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vambatele muvila ua Yesu nakuzengela ha vintanga via liniu hamo na mukundu, kuya muvakatsindila ku cilika ca Vayunda. ");
INSERT INTO nkn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kuakele citungu ku cihela cije kuvamushukikilile, muje mu citungu muakele cihilo cije kanda vatsindemo muntu. ");
INSERT INTO nkn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Omuo liapuile litangua lia Vayunda lia Kulivuahesela ciuano ca paseka, kaha omuo na cihilo cakele muyehi, kaha vatsindilemo Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cimene mene ha litangua lia calumingu tele kuacizivala, Maliya Mangandalena uaile ku cihilo, kaha uamuene livue vana lihumisa ku cihilo. ");
INSERT INTO nkn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kaha uashatukilile kuli Simoni Petulu na ndongisi mukuavo naua uje uazangele Yesu cikuma, kaha uavalekele nguendi, “Muene uetu vana muhumisa mu cihilo kaha kututantekeya oku vanamuhaka!” ");
INSERT INTO nkn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hajevene Petulu na uje ndongisi mukuavo vaile ku cihilo. ");
INSERT INTO nkn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kaha voshe vavali vakele nakushatuka hamo, vuno honi uje ndongisi mukuavo uashatukile cikuma kupulakana Petulu, kaha uapuile uakulivanga kuheta ku cihilo. ");
INSERT INTO nkn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uemanene nakutalezeka mu cihilo, kaha uamuene vintanga via liniu, vuno honi kakovelelemo. ");
INSERT INTO nkn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulu uje uamukavele munima na ikeye uahetele, hajevene ikeye uakovelele mu cihilo uamuene lika vintanga via liniu vili ha mavu, ");
INSERT INTO nkn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na ntanga ije yakele ku mutue ua Yesu kuyakele hamo na vintanga via liniu vuno honi yalihuminine nakukala hali kaliayo lika. ");
INSERT INTO nkn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kaha uje ndongisi mukuavo ualivangele kuheta ku cihilo, nendi naua uakovelelemo, kaha uamuene nakutsiliela. ");
INSERT INTO nkn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cipue ngocovene kuvovuisisile visoneka vije viahandekele nguavio napande kusanguka ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kaha vaje vandongisi vahilukile ku membo avo. ");
INSERT INTO nkn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Vuno honi Maliya uemanene ku cihilo nakulila kaha omo tele ali nakulila uakotamene nakutala mu cihilo, ");
INSERT INTO nkn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","uamuene tungelo vavali vanazala vizalo via kutoka vanatumama kuje kuakele muvila ua Yesu, umo ku mitue mukuavo ku viliato. ");
INSERT INTO nkn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Vahandekele kuli ikeye nguavo, “Mpuevo vika ulinakulila?” Kaha uahandekele kuli vakevo nguendi, “Vanambata Muene uange, kaha kunjitantekeya oku vanamuhaka!” ");
INSERT INTO nkn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Omo tele acili nakuhandeka vioshe evi, uatalele kunima kaha uamuene Yesu nemana kuje, vuno honi katantekeyele nguendi Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu uamuhuile nguendi, “Mpuevo, vika ulinakulila iya utonda?” Maliya uasinganiekele nguendi ndimi, kaha uahandekele kuli ikeye nguendi, “Muene, indi yove unamuambata, njileke oku kunamuhaka, linga njikamuambateko.” ");
INSERT INTO nkn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu uahandekele kuli ikeye nguendi, “Maliya!” Kaha Maliya uatengulukile nakuhandeka nendi mu Cihevelu nguendi, “Lavoni!” (Kulumbununa Mulongisi). ");
INSERT INTO nkn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kaha Yesu uahandekele kuli ikeye nguendi, “Keti unjikuate omo kanda njilonde kuya kuli Tate. Vuno honi ya kuli vavusamba vange ukavaleke nguove njili nakuhiluka kuli Tate ikeye uje ishueni, kuli Njambi yange ikeye uje Njambi yeni.” ");
INSERT INTO nkn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya Mangandalena uaile nakuleka vandongisi nguendi, “Njinamono Muene.” Kaha Maliya Mangandalena uavalekele nguendi Yesu ikeye nahandeka viuma evi kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Omo capuile cinguezi ca litangua lia calumingu, vandongisi valikunguluilile hamolika mu njivo ije vikolo viapuile viakupata omuo vakele na liova lia kuteua vantuama va Vayunda, kaha Yesu uezile nakuimana navo nakuhandeka nguendi, “Ciyulo cikale neni.” ");
INSERT INTO nkn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Omo uamanesele kuhandeka evi, uavamonesele mavoko endi mukati na helu, kaha vandongisi vendi vavuahelelele kumona Muene uavo. ");
INSERT INTO nkn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu uahandekele kuli vakevo naua nguendi, “Ciyulo cikale neni. Omuo Tate uanjitumine nange naua njimituma.” ");
INSERT INTO nkn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Omo uamanesele kuhandeka evi, uavahuiminine nakuhandeka kuli vakevo nguendi, “Tambuleni Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nga mukonekela vipi vuamukueni, kaha vanamukonekela, nga kumuvakonekela, kaha kuva kavakonekela.” ");
INSERT INTO nkn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Vuno honi Tomasi (uje ivatumbuile nguavo mpasa), uje umo ua vaje likumi na vavali kakele hamo navo omo Yesu uezile. ");
INSERT INTO nkn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kaha vakuavo vandongisi va Yesu vamulekele nguavo, “Tuamono Muene.” Kaha ikeye uahandekele kuli vakevo nguendi, “Kuvanga njinamumono mu mavoko muje mu vatuvile vimbambo, nakukuatamo na munie uange, nga keti ngoconi kunjitsiliela.” ");
INSERT INTO nkn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Omo kuahitile matangua atanu na atatu kaha vandongisi vendi naua vakele mu njivo, kaha Tomasi uakele hamo navo. Cikolo capuile cakupata, vuno honi Yesu uezile nakuimana hhakati kavo nakuhandeka nguendi, “Ciyulo cikale neni.” ");
INSERT INTO nkn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kaha uahandekele kuli Tomasi nguendi, “Kuata munie uove mu livoko liange, tala mavoko ange kaha humisa livoko liove nakulihaka ku vimpati viange linga keti ukale navimpata vuno honi untsiliele.” ");
INSERT INTO nkn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi uamukumbuluile nguendi, “Muene uange, Njambi yange!” ");
INSERT INTO nkn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu uahandekele kuli ikeye nguendi, “Uatsiliela omuo uanjimono ndi? Vanakuisuliua vaje kuva njimuene vuno honi vanatsiliela.” ");
INSERT INTO nkn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kaha Yesu ualingile vitantekeyeso viavingi ha mesho a vandongisi vendi, vije kuvasonekele mu livulu eli. ");
INSERT INTO nkn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Vuno honi evi vanavisoneka linga mutsiliele ngeci Yesu ikeye Kilistu, Muna Njambi, kaha mukutsiliela mukakala na muono kuhitila mu lizina liendi. ");
INSERT INTO nkn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hanima yevi Yesu ualisholuele vavenia naua kuli vandongisi vendi ku cisali ca Timbeliase, ualisholuele ikeye vavenia mu ngila eyi. ");
INSERT INTO nkn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulu, na Tomasi uje ivatumbuile mpasa, na Natanele uje uahumine ku Kana mu nganda ya Ngalileya, na vana va Zembendeo na vakuavo vandongisi vavali voshe vakele hamo. ");
INSERT INTO nkn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulu uahandekele kuli vakevo nguendi, “Njili nakuya nakuta vatsi.” Kaha vahandekele kuli ikeye nguavo, “Tuya mumo.” Kaha vaile hamo mu vuato, vuno honi vutsiki vuje kuvakuatele na umo uahi. ");
INSERT INTO nkn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Liamukuavo cimene mene, Yesu uemanene ku cisali, vuno honi vandongisi vendi kuvatantekeyele nguavo Yesu. ");
INSERT INTO nkn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kaha Yesu uahandekele kuli vakevo nguendi, “Vana vange, kumuakuateleko cipue itsi umo ndi?” Kaha vamutavele nguavo, “Houe.” ");
INSERT INTO nkn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kaha uahandekele kuli vakevo nguendi, “Teni vuanda vueni ku cihela ca cilio ca vuato, kaha mukakuata vatsi.” Vatele vuanda vuavo kuje kaha vahonouele cipue kukoka vuje vuanda omuo vatsi vapuile vavengi. ");
INSERT INTO nkn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Uje ndongisi ivazangele cikuma kuli Yesu uahandekele kuli Petulu nguendi, “Nkumani Muene!” Omo Simoni Petulu uevuile nguendi uapuile Muene, uazalele vizalo viendi, omuo uashuluile vizalo viendi viahelu, kaha uakovelele mu mema. ");
INSERT INTO nkn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Vuno honi vandongisi veka vakevo vezile mu vuato, vakele nakukoka vuanda vuje vuashulile na vatsi. Omo kuvakele kulahako na ntunda, vuno honi yapuile lika ntunda yakupua matambo cihita (100). ");
INSERT INTO nkn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kaha omo vahetele ha ntunda vamuene manungu a tuhia hali na itsi na mbolo. ");
INSERT INTO nkn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu uahandekele kuli vakevo nguendi, “Neheniko vatsi vamo vamu nakuata.” ");
INSERT INTO nkn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kaha Simoni Petulu uakovelele mu vuato, nakukokela vuanda ku ntunda vuje vuashulile na vatsi vakama cikuma, vatsi vapuile cihita na makumi atanu na vatsi vatatu (153), kaha cipue vene tele vatsi vapuile vavengi, vuno honi vuanda ku vuatavukile. ");
INSERT INTO nkn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu uahandekele kuli vakevo nguendi, “Ijeni muakulie via kulia via cimene.” Kaha naumo uahi ua vandongisi uehuileko nguendi, “Yove iya?” Omuo vatantekeyele nguavo Muene. ");
INSERT INTO nkn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kaha Yesu uezile nakuambata mbolo na kuvahanayo, kaha ualingile cimo vene naua na ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Eyi yapuile ntsimbu ya mucitatu ije Yesu ualisholuele kuli vandongisi vendi hanima yakusanguka ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Omo vamanusuile kulia via kulia via cimene, kaha Yesu uahandekele kuli Simoni Petulu nguendi, “Simoni muna Iuano, nkuma uanjizaka kupulakana ava ndi?” Petulu uamukumbuluile nguendi, “Eyo Muene nove utantekeya nguove njakuzanga.” Yesu uahandekele kuli ikeye nguendi, “Lisa vana va vampanga vange.” ");
INSERT INTO nkn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kaha Yesu uahandekele kuli ikeye ntsimbu ya mucivali nguendi, “Simoni muna Iuano, uanjizanga ndi?” Petulu uamukumbuluile nguendi, “Eyo, Muene, nove utantekeya nguove njakuzanga,” Yesu uahandekele kuli ikeye nguendi, “Niunga vampanga vange.” ");
INSERT INTO nkn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kaha Yesu uahandekele kuli ikeye ntsimbu ya mucitatu nguendi, “Simoni muna Iuano, uanjizaka ndi?” Petulu uevuile kupihia omuo uamuihuile ntsimbu ya mucitatu nguendi, “Uanjizanga ndi?” Kaha uahandekele kuli ikeye nguendi, “Muene, utantekeya nove nguove njakuzanga.” Yesu uahandekele kuli ikeye nguendi, “Lisa vampanga vange. ");
INSERT INTO nkn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cilivene mua vusunga njikuleka nguange omo tele uapuile u kanike, uakele nakulikuta muiva uove mu mbunda nakuya kuoshe kuje ku uatondele. Vuno honi omo ukakuluvala ukolola mavoko ove kaha mukueni akakukuta muiva mu mbunda yove nakukutuala kuje ku utondo.” ");
INSERT INTO nkn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Mukuhandeka evi, Yesu uahandekele vutsi vuje vuakatsa navuo Petulu vuje vukaneha vumpau kuli Njambi.) Kaha Yesu uahandekele kuli Petulu nguendi, “Njikave!” ");
INSERT INTO nkn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petulu uatengulukile kaha uamuene uje ndongisi ivazangele cikuma kuli Yesu alinakumukava, uje uasindamenene ha ntulo ya Yesu ha ntsimbu ije ivalile via kulia via cinguezi naua ikeye uje uahandekele nguendi, “Muene iya akakuenda vungungu?” ");
INSERT INTO nkn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Omo Petulu uamumuene, uehuile Yesu nguendi, “Muene, vika vikalingiua kuli ou yala?” ");
INSERT INTO nkn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu uahandekele kuli ikeye nguendi, “Nga ku cizango cange akayoya noho njikeja, nkuma evi vikevio vika kuli yove? Njikave!” ");
INSERT INTO nkn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kaha muzimbu ou uashandokelele muimbo lioshe, nguavo ou ndongisi ka katsi. Vuno honi Yesu kahandekele kuli ikeye nguendi ka katsi, vuno honi nguendi, “Nga ku cizango cange ngue akayoya noho njikeja, evi vikevio vika kuli yove?” ");
INSERT INTO nkn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ou ikeye ndongisi uje ahandeka vukaleho vua viuma evi vialingiuile nakuvisoneka, kaha tutantekeya nguetu vukaleho vuendi vunapu vua vusunga. ");
INSERT INTO nkn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Vuno honi kuvili vimo viuma viavingi vikuavo vije Yesu ualingile, nga vioshe va visonekele, njatantekeya nguange nga mavu oshe ku asele kuuana cihela cakutulikila mavulu aje avanasoneka.");
INSERT INTO nkn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kuli ua cizango Telefilo, Mu livulu lia kulivanga Njasonekele hali vije vioshe Yesu ualingile na kulongesa cendi hume hambangelo, ");
INSERT INTO nkn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nakuheta litangua lije vamutualele muilu, munima yakuhana vishika kuhitila mu Cimbembesi Uakulela ku tunganda vaje vahanguile. ");
INSERT INTO nkn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Munima ya kutsa na kusanguka cendi, ualisholuele ikeye vavenia kuli vakevo mu vingila vije viakele na vukaleho ngeci ikeye alinakuyoya. Ualisholuele kuli vakevo mu matangua akupua makumi auana nakuhandeka via vumuene vua Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tele acilinavo, uavashikile nguendi, “Keti vakahume mu Yelusalema vuno honi vakavandamenene kuje cikulaheso ca Tate. Evi vikevio viahandekele vije vimuevuile kuli yange. ");
INSERT INTO nkn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Iuano uambuitikile na mema vuno honi ha matangua amandende lika vakamimbuitika na Cimbembesi Uakulela.” ");
INSERT INTO nkn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Omo tunganda vakele hamo na Yesu, vamuihuile nguavo, “Muene, nkuma kuntsimbu inovene ukahiluisila vumuene ku Isaleli?” ");
INSERT INTO nkn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu uavakumbuluile nguendi, “Keti kuli yeni kutantekeya vintsimbu cipue matangua aje Tate anavuahesa kuya ku nzili yendi. ");
INSERT INTO nkn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Vuno honi mukatambula nzili omo Cimbembesi Uakulela cikeja hali yeni, kaha mukapua vakaleho vange mu Yelusalema, na mu Yundeya muoshe na mu Samaliya, na kuma manusuililo a mavu.” ");
INSERT INTO nkn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Omo uamanusuile kuhandeka eci, vamukakuile naku mutuala muilu te oku vamutalelela, lishelua liamuambate kaha kuvamumuene naua. ");
INSERT INTO nkn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tele vali nakutalelela muilu, hajevene vamala vavali vazalele via kutoka vemanene kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Vehuile nguavo, “Vamala vaku Ngalileya, vika munemanena nakutala muilu? Ou Yesu, uje ivanambata kuli yeni nakumutuala muilu, akeja naua mucifua cimo nge muje mumuamumuenene aya muilu.” ");
INSERT INTO nkn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kaha tunganda vahilukille ku Yelusalema omo vahumine ku Munkinda ua Oliveta uje uakala kuyehi na Yelusalema, yapuile ntunda yakupua ngue kilomita imolika. ");
INSERT INTO nkn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Omo vakovelele mu nganda, kaha vaile ku mulili ua kuilu kuje kuvakele va Petulu, na Iuano, na Tiango, na Anduleo, na Filipu, na Tomasi, na Mbatolomeo, na Mateu, na Tiango muna Alufeya, na Simoni Zelote uje ualuisile vaka kusuana va Valoma, na Yundasa muna Tiango. ");
INSERT INTO nkn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vakele nakulikunguluila hamolika mukulombela na mutima umo, hamo na vampuevo veka na Maliya vaina ya Yesu hamolika na vashongo vendi Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu matangua aje Petulu uemanene hhakati ka vaka kutsiliela hamolika na civunga cakupua cihita na vantu makumi avali (120) nakuhandeka nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Vavusamba vange, visoneka vinapande vilishulisise muje Cimbembesi Uakulela kuhitila muli Ndaviti cahandekele hali Yundasa, uje uatuamenenene vaje vakutile Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yundasa uapuile umo uetu, omuo vamuhanguile kupua uakuvipangi vietu.” ");
INSERT INTO nkn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Na vimbongo vije viatambuile Yundasa ha vilinga viendi via vipi, uavilandele lihia muje mualiuilililile na kutsa, uatavukile lizimo na mila yendi yatutulukilile hambanza. ");
INSERT INTO nkn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vantu voshe vakele mu Yelusalema vacuvuile, kaha mu muyati uavo vatumbuile lije lihia nguavo Akalundama, “kulumbununa nguavo Lihia lia Maninga.”) ");
INSERT INTO nkn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Omuo vanacisoneka mu livulu lia Miaso nguavo, ‘Njivo yendi ipue yamupulungua, keti mukale cipue umo.’ vacisoneka naua nguavo, ‘Muntu ueka akahinge ha vipangi viendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nankuma tuapande kuhangula umo ha vamala vaje vanakala netu ntsimbu yoshe ije Muene Yesu uendanganene netu, ");
INSERT INTO nkn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kuputukila ku ntsimbu ije Iuano uambuluile muzimbu uendi uakumbuitika nakuheta ha litangua lije omo vahumisile Yesu kuli yetu nakumutuala muilu. Ha cuma eci, umo uavo napande kupua mukaleho uetu ku kusanguka cendi. ");
INSERT INTO nkn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nankuma, vahanguile vamala vavali, Yosefa uje ivalukile Mbalasambase (naua vamutumbuile nguavo Njasitase) na Maseyase. ");
INSERT INTO nkn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ambahoni valombelele nguavo, “Muene, utantekeya mutima ua muntu uoshe. Tumuese hali ava vavali iya uje iunahangula ");
INSERT INTO nkn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuambata cihela mu vipangi evi na kupanga vipangi via vunganda vije Yundasa uasezele nakuya ku mutambela uendi.” ");
INSERT INTO nkn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kaha vavatelele nkela, na nkela yauililile hali Maseyase, nankuma vamupandakanene ku tunganda likumi na umo. ");
INSERT INTO nkn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Omo litangua lia Pentekosita liahete, vaka kutsiliela voshe vakungulukile mu njivo imolika. ");
INSERT INTO nkn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hajevene muilu muahumine cililimo ngue kupekumuka kua mpunzi yakama, kaha yashulisile njivo yoshe muje muvatumamene. ");
INSERT INTO nkn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Vamuene vije viafuile ngue milengi ya tuhia vije vialihangunukile kaha imo na imo yakele hali umo na umo uavo. ");
INSERT INTO nkn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Voshe vashulile na Cimbembesi Uakulela kaha vaputukile kuhandeka mu vindaka vieka, nge muje Cimbembesi cavalingile linga vahandekemo. ");
INSERT INTO nkn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mu Yelusalema muakele Vayunda vaka kuivuila Njambi liova vaje vahumine ku mafuti oshe ahano ha mavu. ");
INSERT INTO nkn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Omo vovuile kalua kaje, civunga cakama cakungulukile. Voshe valikomokelele omuo muntu uoshe uovuile vaje vaka kutsiliela vahandeka mu vindaka viavo. ");
INSERT INTO nkn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Voshe valikomokelele cikuma nakuhandeka nguavo, “Nkuma ava vali nakuhandeka ngeci keti voshe Vangalileya ndi? ");
INSERT INTO nkn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Cija vati honi tuvavoshe tuvevua umo na umo mu muyati uetu vavenia? ");
INSERT INTO nkn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vamo vetu vahuma ku Palitiya, Mendiya na ku Elame, vakuavo ku Mesopotamia, Yundeya na ku Kapandosiya, vakuavo ku Pontiyasi na ku vinganda vimo via Valoma via mu Asiya, ");
INSERT INTO nkn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","vamo ku Filingiya na ku Pampiliya, vakuavo ku Ingito na ku mitambela ya Limbiya kuyehi na Silene, vamo vangenzi vahuma ku nganda ya Loma ");
INSERT INTO nkn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Vayunda na ava keti Vayunda vuno honi lika vakakava futisi ya Vayunda), vamo vetu vahuma ku Kelete na ku Alambiya yetu tuvavoshe tulinakuvevua vahandeka vikomoueso via Njambi mu miyati yetu.” ");
INSERT INTO nkn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kaha voshe valikomokelele nakukala na citanga, kaha valihozuele umo na mukuavo nguavo, “Eci cilumbunuka vika?” ");
INSERT INTO nkn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Vuno honi vamo vavo vashendumuine vaka kutsiliela nakuhandeka nguavo, “Vantu ava vanapende viniu!” ");
INSERT INTO nkn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Vuno honi Petulu uemanene na vakuavo tunganda likumi na umo, uahandekele na lizi liakama ku civunga cije nguendi, “Vamala vaku Yundeya neni voshe muakala mu Yelusalema, tantekeyeni eci cuma, kaha ivuilileni muacili kuli evi njihandeka. ");
INSERT INTO nkn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Cilivene, vantu ava kuvapendele nge mumuli nakuyonguelamo, ino inapu ntsimbu ya mucitanu na viuana ku cimene. ");
INSERT INTO nkn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Vuno honi evi vikevio viahandekele kananguizi ua Njambi Njuele nguendi. ");
INSERT INTO nkn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Njambi ahandeka nguendi, ‘Eci cikeco njikalinga mu matangua amamanusuililo njiketila Cimbembesi cange hali muntu na muntu. Vana veni va vamala na ava va vampuevo vakambulula vunanguizi, na vakuenje veni vakamona vimona, na vakulukazi veni vakalota vinjozi. ");
INSERT INTO nkn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mu matangua aje njiketila Cimbembesi cange, cipue hali vangamba vange, va vamala na ava va vampuevo kaha vakambulula vunanguizi. ");
INSERT INTO nkn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Njikalinga vikomoueso muilu na vitantekeyeso hano ha mavu, kukakala maninga, na tuhia, na vuisi vuakama. ");
INSERT INTO nkn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Litangua likazivala vuiii, na ngonde ikavenga ngengu ngue maninga, ntsimbu kanda litangua liakama lia vumpau vua Muene lihete. ");
INSERT INTO nkn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kaha uoshe akasana lizina lia Muene akovoka.’ ");
INSERT INTO nkn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yeni vamala vaku Isaleli! “Ivuilileni ku mezi aua, Yesu uaku Nazaleta uapuile yala uje nzili yendi yakama yavu Njambi yasholuele muacili kuli yeni vikomoueso na vitantekeyeso vije vialingile Njambi kuhitila muli ikeye hhakati keni, nge muje yeni vavenia mualitantekeyela. ");
INSERT INTO nkn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Njambi mu kutantekeya cendi na mu viyongola viendi via laja ngeci Yesu vaka muhana ku mavoko eni, kaha yeni muamutsihile hakutava vaka vupi linga vamushukike ha cilindakano. ");
INSERT INTO nkn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Vuno honi Njambi uamusanguile ku vatsi, uamupatuile ku nzili ya kutsa, omuo kucatavele linga kutsa cimupuise cinzinda. ");
INSERT INTO nkn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Omuo Ndaviti uahandekele hali ikeye nguendi, ‘Muene kulutue luange ntsimbu yoshe, omuo ali ku livoko liange lia cilio kaha kunjikajaja. ");
INSERT INTO nkn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nankuma mutima uange uvuahelela, na mezi ange anashulu na nzolela. Kaha muvila uange ukahuima mu lutsilielo. ");
INSERT INTO nkn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Omuo kukanjiseze mu vukalo vua vatsi, cipue kutava muka kulela uove linga apolele mu cihilo. ");
INSERT INTO nkn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unanjitantekeyesa vingila vituala ku muono, ukanjishulisa na nzolela mukukala muyehi nove.’ ");
INSERT INTO nkn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Vakuetu, njihandeka kuli yeni nakusimpa hali kukuluila yetu Ndaviti uje uatsile na kumutsinda, na cihilo cendi hanga tucili naco na lelo lino. ");
INSERT INTO nkn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ndaviti uapuile kananguizi ua Njambi, kaha uatantekeyele nguendi Njambi uamukulahesele na kulisinga nguendi akapuisa umo ua vatekuluila vendi kukala ha litanda lia vumuene. ");
INSERT INTO nkn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ndaviti ha kumona vije vikalingika kulutue, uahandekele ha kusanguka kua Kilistu omo uahandekele nguendi, ‘Ikeye kuvamusezele mu vukalo vua vatsi, muvila uendi kuuapolelele mu cihilo.’ ");
INSERT INTO nkn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Njambi nasangula ou Yesu ku vatsi, kaha yetu voshe tunapu vakaleho va viuma evi. ");
INSERT INTO nkn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ikeye hakumujundula kuya ku livoko lia cilio lia Njambi, nakutambula Cimbembesi Uakulela kuli Ishe cije camu kulahesele, kaha netilahoni vije vimuli nakumona na kuivua hali yetu. ");
INSERT INTO nkn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Omuo keti Ndaviti uje ualondele muilu, vuno honi ikeye uahandekele nguendi, ‘Muene uahandekele kuli Muene yange nguendi, Tumama ku livoko liange lia cilio ");
INSERT INTO nkn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","noho cikapuisa vitozi vove vuliatelo vuave.’ ");
INSERT INTO nkn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nankuma vantu voshe va Isaleli vanapande kutantekeya muacili ngeci ou ikeye Yesu, uje imuashukikile ha cilindakano ikeye Njambi yanapuisa Muene na Kilistu.” ");
INSERT INTO nkn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Omo vantu vovuile evi, cavakuate ku mitima yavo kaha vahandekele kuli Petulu na kuli tunganda vakuavo nguavo, “Eni vakuetu, tuapande kulinga vati?” ");
INSERT INTO nkn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulu uahandekele kuli vakevo nguendi, “Muntu na muntu napande kutenguluka ku vipi viendi nakumumbuitika mu lizina lia Yesu Kilistu linga vamisambese ku vipi vieni, kaha mukatambula vuana vua Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Omuo cikulaheso ca Njambi cinapu ceni na vana veni, na kuli voshe vaje vali kulahako, vaje voshe vakasana Muene Njambi yetu veje kuli ikeye.” ");
INSERT INTO nkn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulu uahandekele kuli vakevo na mezi eka akuvanangula nakuvalambelela nguendi, “Lioheleni yeni vavenia ku miyati eyi ya vilinga via vipi.” ");
INSERT INTO nkn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Vaje voshe vatambuile muzimbu ua Petulu vavambuitikile, kaha ha litangua lije kualivuezelelele vantu vakupua makulukazi atatu (3, 0 0 0). ");
INSERT INTO nkn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Vakakateyele ku vilongesa via tunganda na mukukunguluka hamo, na mukutavula mbolo na mukulombela. ");
INSERT INTO nkn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vikomoueso na vitantekeyeso viavingi vivalingile tunganda viovuisile vantu voshe liova. ");
INSERT INTO nkn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vaka kutsiliela voshe vakele hamo mukulitombola, kaha valipangelele vufuko vuavo voshe. ");
INSERT INTO nkn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Valandesele viuma viavo na vufuko vuavo, kaha valipangezelele vimbongo hhakati kavo, kuya muje muanazenekela muntu. ");
INSERT INTO nkn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ha litangua na litangua valikunguluile mu Njivo ya Njambi, vakele nakutavula mbolo mu vinjivo viavo na kulia viakulia viavo mukuvuahelela na mitima ya kulikehesa, ");
INSERT INTO nkn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","nakushangazala Njambi, nakuvazanga ku vantu voshe. Ha litangua na litangua Muene uavuezeleleleko ku civunga cavo vaje vantu vakele nakuovoka. ");
INSERT INTO nkn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ha litangua limo Petulu na Iuano vaile ku Njivo ya Njambi ha ntsimbu ya kulombela, yapuile ntsimbu ya maola atatu ku mutania. ");
INSERT INTO nkn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kuje ku cikolo civatumbuile nguavo Cikolo Cacili ca Njivo ya Njambi, kuakele yala umo uje uapuile cilema hume kukusemuka cendi. Vakele nakumutuala tuala ku cikolo ha litangua na litangua linga alombe vuana kuli vantu vaje vakele nakukovela mu Njivo ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Omo uamuene Petulu na Iuano valinakukovela mu Njivo ya Njambi, uavalombele linga vamuhaneko cimo. ");
INSERT INTO nkn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petulu na Iuano voshe vamutalele ntoma, kaha Petulu uahandekele kuli ikeye nguendi, “Tutale!” ");
INSERT INTO nkn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nankuma uavatalele ntoma, uayonguele nguendi hamo vamuhanako cimo. ");
INSERT INTO nkn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Vuno honi Petulu uahandekele kuli ikeye nguendi, “Kunjesi na Silivela cipue Ngolinde, vuno honi eci njilinaco cikeco cinjikuhana, mu lizina lia Yesu Kilistu uaku Nazaleta imana linga uende.” ");
INSERT INTO nkn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ambahoni uamukuate ku livoko liendi lia cilio nakumukatula, hajevene viliato na tutsendengele tuendi viakele na nzili. ");
INSERT INTO nkn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Uakatukile nakutumbuka kaha uaputukile kuenda, uakovelele hamo navo mu Njivo ya Njambi, uendele nakutumbuzoka na kushangazala Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vantu voshe kuje vamumuene alinakuenda nakushangazala Njambi, ");
INSERT INTO nkn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","omo vamutantekeyele ngeci ikeye uje uakele nakutumama ku cikolo cije civatumbuile nguavo Cikolo Cacili ca Njivo ya Njambi nakulomba vuana, kaha voshe valikomokelele cikuma ha cuma cije calingiuile kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Omo uje yala uakakateyele kuli Petulu na Iuano, vantu voshe valikomokelele kaha voshe vashatukililile kuli vakevo mu Mbalanda ya Solomoni. ");
INSERT INTO nkn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Omo Petulu uamuene vaje vantu, uahandekele kuli vakevo nguendi, “Yeni vaka Isaleli, vikahoni mualikomokela ha cuma eci, cipue vikahoni mututalela ntoma? Muayongola ngueni eci cinalingiua mu nzili yetu cipue mu vunjambi vuetu mukemo tunendesa ou muntu ndi? ");
INSERT INTO nkn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Njambi ua Avilahama, na Isake na Yakomba, Njambi ya vakukuluila vetu, ikeye nahana vumpau kuli ngamba yendi Yesu, uje imuahanene kuli vaka kusuana nakumuviana ku mesho a Pilato, cipue Pilato te nayongola kumuecela. ");
INSERT INTO nkn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Vuno honi yeni muamuvianene Uakulele na Vusunga kaha muashikile Pilato linga amiecelele na kumihana muhuza. ");
INSERT INTO nkn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kaha muamutsihile uje ikeye Vavenia muono, vuno honi Njambi uamusanguile ku vatsi. Yetu tunapu tuvakaleho ha cuma eci. ");
INSERT INTO nkn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mukutsiliela mu lizina lia Yesu, lizina liendi ikeye vavenia likelio liahana ou yala nzili, ou mumona nakutantekeya, nalutsilielo luakuhitila muli Yesu lunamuhana kukanguka kuacili ku mesho eni voshe. ");
INSERT INTO nkn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Honi vamuanetu njatantekeya nguange vije mualingile kuli Yesu, yeni na vantuama veni muavilingilile mu nzimba. ");
INSERT INTO nkn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mu ngila eyi vene Njambi uashulisilile vije viahandekele laja kuhitila ku tunanguizi va Njambi va Njambi voshe nguendi, Kilistu uendi akayanda. ");
INSERT INTO nkn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Omuo acuma eci tengulukeni, kaha hilukeni kuli Njambi linga amisambese ku vipi vieni, ");
INSERT INTO nkn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Vitsimbu via kuuima vikahuminina kuli Muene kaha akatuma Kilistu uendi uje yahanguile laja ikeye Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Napande kukala muilu noho ntsimbu ikaheta ije Njambi akapuisa viuma vioshe vuha, nge muahandekele laja kuhitila muli tunanguizi va Njambi vendi va kulela. ");
INSERT INTO nkn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosesa uahandekele nguendi, ‘Muene Njambi yeni akamitumina kananguizi ngue muje muatumine yange, akapua umo uakuhuma hhakati ka vantu veni, mukononoke vioshe vije viakamileka. ");
INSERT INTO nkn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Uoshe kakononoka uje kananguizi vakamuhumisa kuli vantu va Njambi.’ ");
INSERT INTO nkn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tunanguizi va Njambi voshe nge muvana vahandekelamo, kuhuma kuli Samuele na vaje vezile munima yendi, navo naua vambuluile vije vilingiua matangua ano. ");
INSERT INTO nkn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mu vatekuluila va tunanguizi va Njambi va Njambi na litavasano lije Njambi uahanene kuli vakukuluila veni nge muahandekele kuli Avilahama nguendi, ‘Kuhitila muli vatekuluila vove miyati yoshe ya vantu hano ha mavu vakakuisuliua.’ ");
INSERT INTO nkn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Omo Njambi ujunduile ngamba yendi, uamutumine kuli yeni hakulivanga, mukumikuisula linga muntu uoshe ahume ku vilinga viendi via vipi.” ");
INSERT INTO nkn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tele Petulu na Iuano vacili nakuhandeka ku vantu, vamo tusasendote na ntuama ua Njivo ya Njambi na Vasanduki vezile kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Vanienguele cikuma omuo vakele nakulongesa vantu nguavo Yesu nasanguka ku vatsi, eci camuesele ngeci vatsi vakasanguka. ");
INSERT INTO nkn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nankuma, vavakuate nakuvahaka mu kamenga noho liamukuavo, omuo kuapuile laja cinguezi. ");
INSERT INTO nkn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Vuno honi vavengi vaje vovuile lizi vatsilielelele, kaha vuingi vua vamala vapuile makulukazi atanu (5, 0 0 0). ");
INSERT INTO nkn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Liamukuavo vantuama va Vayunda, na vakuluntu, na valongisi va mezi a Lishiko valikunguluilile mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Valiuanene hamo na Anase Kasasendote Uakama na Kayafase na Iuano na Alekizanda na voshe vaje vapuile vaka ntanga ya Kasasendote Uakama. ");
INSERT INTO nkn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Omo vemikile Petulu na Iuano ku mesho avo vatondele kutantekeya kaha vavehuile nguavo, “Nzili yeya mulinayo cipue mu lizina lieya munalingi cuma eci?” ");
INSERT INTO nkn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ambahoni Petulu hakushula na Cimbembesi Uakulela, uavakumbuluile nguendi, “Yeni vantuama va vantu na vakuluntu, ");
INSERT INTO nkn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nga muli nakutuihula lelo ha vilinga viacili vinalingiua kuli yala ou ua cilema na vati muje muanakangukilamo, ");
INSERT INTO nkn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","yeni voshe munapande kutantekeya, na vantu voshe vamu Isaleli vanapande kutantekeya ngeci muntu ou nemana ku mesho eni nakanguka muacili mu lizina lia Yesu Kilistu ua ku Nazaleta, uje imuashukikile ha cilindakano, uje yasanguile Njambi ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ou Yesu ikeye uje visoneka vihandeka nguavo ‘Livue limuayenguile yeni vaka kutunga, ikeye honi napu cisimi caseho cikuma ca mumbango kupulakana vioshe.’ ");
INSERT INTO nkn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kutuasa kuuana kuovoka muli ueka naua, omuo kukuesi lizina lieka hano ha mavu lianahana Njambi ku vantu litunapande kuovokelamo.” ");
INSERT INTO nkn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vaka mpunga vakomokele omo vamuene kusimpa kua Petulu na Iuano omuo vamuene ngeci vapuile vantu vangoco vakuhona kulilongesa, kaha vavanongonuene ngeci vakevo vakele hamo na Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Vuno honi hakumona uje muntu ivakanguisile nemana hamo na Petulu na Iuano, kuvasele kuhandeka cuma cimo cakuvaluisa naua. ");
INSERT INTO nkn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nankuma, vavalekele linga vatuhuke mu njivo ya Mpunga, kaha vaputukile kulihandekesa hhakati kavo nguavo, ");
INSERT INTO nkn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Vika tulinga nava vamala? Omuo muntu uoshe mu Yelusalema natantekeya ngeci eci cikomoueso caciha civanalingi, kaha kutuasa kuciviana. ");
INSERT INTO nkn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Vuno honi kuvindika cuma eci ngeci keti citsimane naua hhakati ka vantu, tunanguleni ava vamala linga keti vahandeke naua kuli muntu mu lizina lia Yesu.” ");
INSERT INTO nkn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nankuma, vasanene mukati nakuvashika linga keti vahandeke cuma cimo cipue kulongesa naua mu lizina lia Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Vuno honi Petulu na Iuano vavakumbuluile nguavo, “Yeni vavenia uaneni cuma muka cacili ku mesho a Njambi, kuononoka yeni indi kuononoka Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Omuo kutuasa kuholoka kuhandeka viuma vije vituamono nevi vitunevu.” ");
INSERT INTO nkn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hanima yakuvanangula cikuma kaha vavecelele. Vamuene ngeci capuile cacikalu kuvahana kashitiku, omuo vantu voshe vashangazalele Njambi ha vije vialingiuile. ");
INSERT INTO nkn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Uje yala ivalingilile cimueso cakumukanguisa uakele na miaka yakupulakana makumi auana. ");
INSERT INTO nkn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Omo Petulu na Iuano vavecelele, vahilukile kuli vantu vavo nakuvaleka vije vivahandekele vakuluntu va tusasendote na vantuama kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Omo vaka kutsiliela vovuile viuma evi, voshe vakungulukile hamo nakulombela kuli Njambi nguavo, “Muene Samatanga ua lilu na mavu, na mema a kalunga na vioshe vilimo! ");
INSERT INTO nkn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yove uahandekele na Cimbembesi Uakulela kuhitila muli kukuluila yetu Ndaviti, ngamba yove, omo ikeye uahandekele nguendi, “‘Kaha omuo vika ava keti Vayunda vanienguele, na omuo vika vantu vatumba matumbe akuhona seho? ");
INSERT INTO nkn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vamiene va hano ha mavu valivuaheselele vualumo vakevo vavenia, na vaka kusuana valikunguluile hamo nakuluisa Muene na Kilistu uendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Cilivene Helonde na Pontiyu Pilato valikunguluile hamo mu nganda ino hamo na ava keti Vayunda na vantu va Isaleli nakuluisa ngamba yove uakulela Yesu, uje iuavuavesele. ");
INSERT INTO nkn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Valikunguluile nakulinga vioshe vije viuatondele laja na nzili yove na cizango cove linga vikalingiue. ");
INSERT INTO nkn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kaha vuavuno, Muene, tala muvali nakutushunguiya, kaha tava linga vangamba vove vambulule lizi liove na kusimpa. ");
INSERT INTO nkn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sholola livoko liove mukukanguisa nakulinga vitantekeyeso na vikomoueso mu lizina lia ngamba yove uakulela Yesu.” ");
INSERT INTO nkn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Omo vamanusuile kulombela, cihela cije vakungulukilile caliningangele. Kaha voshe vashulile na Cimbembesi Uakulela nakuambulula lizi lia Njambi nakusimpa. ");
INSERT INTO nkn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Civunga ca vaka kutsiliela vakele na mutima umolika na viyongola vimolika, naumo uahi uatumbuile viuma viendi vije viafukile kupua viendi, vuno honi valipangezelele vioshe viavo vije vivakele navio. ");
INSERT INTO nkn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kaha na nzili yakama tunganda vambuluile vukaleho vua kusanguka kua Muene Yesu, kaha na kavumbi kakama kakele hali vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kukuakele umo hhakati kavo uajenekele cuma, omuo vaje vakele na mehia cipue vinjivo vavilandesele kaha vanehele vimbongo vivatambuile ku viuma vije valandesele ");
INSERT INTO nkn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nakuvihana kuli tunganda, kaha vavipangezelele ku muntu na muntu ngue kukujeneka cendi. ");
INSERT INTO nkn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kaha Yosefa, Kalevi uje uasemukilile mu sapulasi, uje tunganda vamutumbuile nguavo Mbanambasa, kulumbunuka nguavo “Muka kuzembeleka,” ");
INSERT INTO nkn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ualandesele lihia liendi, kaha uanehele vimbongo nakuvihaka kuli tunganda. ");
INSERT INTO nkn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kuakele yala umo lizina liendi Ananiya, na mpuevo yendi Safila valitavasanene kulandesa mutambela ua vufuko vuavo. ");
INSERT INTO nkn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hakulitavasana na mpuevo yendi uashuekele mutambela ua fuvuko, kaha uatualele mutambela umo ua vimbongo kuli tunganda. ");
INSERT INTO nkn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kaha Petulu uahandekele kuli ikeye nguendi, “Ananiya, vika unatavela Satana akovele mu mutima uove nakuhandeka makuli kuli Cimbembesi Uakulela hakushueka mutambela ua vimbongo viunatambula hakulandesa lihia liavo? ");
INSERT INTO nkn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tele kanda uvulandese, vuakele vuove, naua namunima yakuvulandesa, vimbongo viapuile viove. Nkuma vika uayonguela kulinga cuma eci? Kuakuisile vantu vuno honi unakuisi Njambi!” ");
INSERT INTO nkn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hajevene omo Ananiya uovuile mezi aua, uauililile ha mavu na kutsa, kaha vantu voshe vaje vuovuile evi vakele na liova. ");
INSERT INTO nkn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Vakuenje vezile nakuzenga muvila uendi, kaha vamutualele hambanza na kumutsinda. ");
INSERT INTO nkn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Omo kuahitile maola atatu mpuevo yendi uezile, katantekeyele cuma cije calingiuile. ");
INSERT INTO nkn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulu uamuihuile nguendi, “Njileke nga evi vikevio vimbongo vimunalandesele lihia lieni yove na yaliove?” Kaha Safila uamukumbuluile nguendi, “Eyo, vikevio vene evi.” ");
INSERT INTO nkn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nankuma, Petulu uahandekele kuli ikeye nguendi, “Nkuma vika yove na yaliove muayongola kueseka Cimbembesi ca Muene? Tala, vamala vanakatsinda yaliove ava vali ku cikolo, vakevo vakutuala nove naua.” ");
INSERT INTO nkn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hajevene Safila uauililile ha mavu ku viliato via Petulu na kutsa. Omo vaje vakuenje vakovelele vamuuanene natsi, kaha vamutualele nakumutsinda kuyehi na yaliendi. ");
INSERT INTO nkn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Cikungulukilo coshe na vantu voshe vaje vovuile viuma evi vakele na liova liakama. ");
INSERT INTO nkn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tunganda valingile vitantekeyeso na vikomoueso viavingi hhakati ka vantu. Kaha vaka kutsiliela voshe vakungulukilile hamo mu Mbalanda ya Solomoni. ");
INSERT INTO nkn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Cipue vene vantu vavashangazalele cikuma, vuno honi naumo uahi ualipandakanene navo. ");
INSERT INTO nkn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vantu vavengi valivuezelele ku civunga cavo, civunga ca vamala na vampuevo vaje vatsilielelele kuli Muene. ");
INSERT INTO nkn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nankuma, ku vije vivalingile tunganda, vantu vakele nakuneha vaka kuvavala ku vitapalo nakuvalangeka ha mihela na ha vitalatala linga Cimbembesi ca Petulu cihite helu lia vamo omo ahita kuyehi. ");
INSERT INTO nkn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vivunga via vantu vavengi vezile kuhuma ku membo akuzenguluka Yelusalema, vanehele vaka kuvavala na vaje vakele navaje vanakele nakuyandisiua ku vimbembesi via kujuala, kaha voshe vavakanguisile. ");
INSERT INTO nkn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ambahoni kasasendote uakama na vakuavo vaje va mu mpunga ya Vasanduki, vovuile cipululu kaha vakele na vutumbe vua kuvaluisa. ");
INSERT INTO nkn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Vakuate tunganda nakuvahaka mu kamenga ka civunga. ");
INSERT INTO nkn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Vuno honi ku vutsiki vujevene kangelo ua Muene uashokoluele vikolo via kamenga, kaha uatuhuisile tunganda hambanza, nakuhandeka kuli vakevo nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yeni mukemane mu Njivo ya Njambi nakuleka vantu vioshe via muono ou ua uha.” ");
INSERT INTO nkn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Omo vovuile evi vakovelele mu Njivo ya Njambi cimene mene nakuputuka kulongesa vantu. Omo Kasasendote uakama na vantu vendi vahete kaha vasanene mpunga hamo navakuluntu voshe va vamtu va Isaleli, kaha honi vatumine vantu ku kamenga linga vanehe tunganda ku mesho avo. ");
INSERT INTO nkn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Vuno honi omo vaje vaka kuniunga Njivo ya Njambi vahete kuje, kuvauanene vaje tunganda mu kamenga, nankuma vahilukile ku Mpunga nakuambulula nguavo, ");
INSERT INTO nkn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Omo tuahete ku kamenga tuauanene kuakupata ngongongo na vaka kuniunga voshe te vanemana ku vikolo, vuno honi omo tunashokoluele tuauanene mukati naumo alimo uahi.” ");
INSERT INTO nkn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Omo vakuluntu va tusasendote na mukuluntu ua vaka kuniunga Njivo ya Njambi vovuile viuma evi, valikomokelele cikuma nguavo cuma muka cinalingiua. ");
INSERT INTO nkn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ambahoni yala umo uezile nakuhandeka kuli vakevo nguendi, “Taleni, vaje vamala vamunahakele mu kamenga vali mu Njivo ya Njambi nakulongesa vantu!” ");
INSERT INTO nkn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nankuma, uje mukuluntu ua vaka kuniunga Njivo ya Njambi uaile na vantu vendi mukuambata tunganda. Kuvakapangesele nzili omuo vovuile liova nguavo hamo vantu vavasha mavue. ");
INSERT INTO nkn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Omo vanehele tunganda, vavemikile ku mesho a Mpunga. Kaha kasasendote uakama uavehozuele nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tuamishikile nguetu keti mulongese naua mu lizina lia yala ou, vuno honi yeni munashandola laja vilongesa vieni mu Yelusalema muoshe kaha mutonda naua mutuhake mulonga ua kutsa cendi!” ");
INSERT INTO nkn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Vuno honi Petulu na tunganda vakuavo vavakumbuluile nguavo, “Tunapande kuononoka cikuma Njambi kupulukana vantu. ");
INSERT INTO nkn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Njambi ya vakukuluila vetu ikeye uasanguile Yesu ku vatsi, uje imuatsihile mukumushukika ha cilindakano. ");
INSERT INTO nkn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Njambi uamujunduile nakumutuala ku livoko liendi lia cilio na kumupuisa Ntuama na Muyoyesi linga akahane Isaleli ntsimbu yakutenguluka ngeci vavasambese ku vipi viavo. ");
INSERT INTO nkn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tuvakaleho va viuma evi, yetu hamo na Cimbembesi Uakulela cije Njambi nahana kuli vaje vamuononoka.” ");
INSERT INTO nkn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Omo vaje vaka Mpunga vovuile evi, vanienguele cikuma nakutonda linga vatsihe tunganda. ");
INSERT INTO nkn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Vuno honi umo uavo, uapuile Kafaliseo lizina liendi Ngamaliele, uapuile mulongisi ua mezi a Lishiko kaha naua vantu vamusingimikile cikuma, uakatukile nakushika Mpunga linga vacituhule tunganda hambanza muka ntsimbu kakandende. ");
INSERT INTO nkn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kaha uahandekele ku Mpunga nguendi, “Yeni vakuetu Vaisaleli, zangameni ha viuma evi mulinakulinga kuli ava vamala. ");
INSERT INTO nkn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ha vintsimbu via kunima kuasholokele Teundase uje ualipuisile uakama, kaha vamala vakupua makulukazi auana (400) valipandakanene nendi. Vuno honi vamutsihile kaha na voshe vaje vamukavele valishandokele, kaha cije civunga cendi cahuile. ");
INSERT INTO nkn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Munima yendi Yundasa Kangalileya uasholokele ha ntsimbu yakutanda vantu, uakokele civunga cakama vuno honi nendi naua vamutsihile kaha na voshe vaje vamukavele valishandokele. ");
INSERT INTO nkn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nankuma, ha cihande eci njimileka nguange, keti mueseke kulinga cuma cimo hali ava vamala. Veceleni! Nga evi vanayongola nevi vali nakulinga vinahumu ku vantu, kaha vikahua, ");
INSERT INTO nkn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","vuno honi nga vinahumu kuli Njambi, kaha kumuasa kuvahiana. Ha mulonga ou mukaliuana lika muli nakuluisa Njambi!” Kaha vovuisisile mezi a Ngamaliele. Kaha Mpunga yakavele kunangula kua Ngamaliele. ");
INSERT INTO nkn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nankuma, vasanene vaje tunganda linga vakovele, vavapupile nakuvashika nguavo keti naua vahandeke mu lizina lia Yesu, kaha vavecelele. ");
INSERT INTO nkn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ambahoni omo tunganda vasezele ije Mpunga, vavuahelelele cikuma omuo Njambi uavayonguelele kuyanda nakushauka omuo ha lizina lia Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kaha ha litangua na litangua vakele nakulongesa nakuambulula Muzimbu Uacili ua Yesu Kilistu mu Njivo ya Njambi na mu vinjivo via vantu. ");
INSERT INTO nkn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu matangua aje, omo vandongisi vakele nakulivuezelela, kuakele Vayunda vaje vakele nakuhandeka ndaka ya Cingelengu valingile vimpata na Vayunda vaje vakele nakuhandeka ndaka ya Cihevelu omuo vantuluue vavo vakele nakuvayengula hakuhana viakulia via ha litangua na litangua. ");
INSERT INTO nkn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nankuma, vaje tunganda likumi na vavali vasanene vandongisi voshe nakuhandeka kuli vakevo nguavo, “Kucitava tuecele kuambulula lizi lia Njambi linga tutale ha cimpande ca kupangezela viakulia. ");
INSERT INTO nkn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nankuma, vakuetu, hanguleni vamala vatanu na vavali hhakati keni vaje vamutantekeya ngeci vanashulu na Cimbembesi Uakulela na mana, tuvahake linga vapange cipangi eci. ");
INSERT INTO nkn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kaha yetu tukalihane lika ku kulombela nakupanga vipangi viakuambulula.” ");
INSERT INTO nkn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Civunga coshe cavuahalelele cikuma na viyongola via tunganda, nankuma, vahanguile Setefano, yala uakushula nalutsilielo na Cimbembesi Uakulela, hamolika na Filipu, na Polokolase, na Nikanole, na Timoni, na Palamanase, na Nikolau uje keti Kayunda ua ku Antiyoke uje uakavele futisi ya Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Civunga cemikile vaje vamala ku mesho a tunganda, vaje vakevo vavalombelelele nakuvasaleka mavoko. ");
INSERT INTO nkn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kaha lizi lia Njambi liashandokele. Civunga ca vandongisi mu Yelusalema calivuezelelele cikuma, na civunga ca tusasendote vavengi vatsilielele. ");
INSERT INTO nkn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kaha honi Setefano, mukushula na kavumbi ka Njambi na nzili, ualingile vitantekeyeso na vikomoueso viakama hhakati ka vantu. ");
INSERT INTO nkn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Vamuluisile kuli vamala vamo vaje vapuile vaka njivo ya malombelo ya Vamala Vakupatuka (nge muje muvaitumbuile), muje muakele Vayunda vakuhuma ku Silene na ku Alekizandiliya. Vakuavo vahumine ku mbonge ya Silisiya na ku Asiya valingile vimpata na Setefano. ");
INSERT INTO nkn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Vuno honi Cimbembesi cahanene Setefano mana linga omo ahandeka naumo uahi uasele kumuhiana kulinga nendi vimpata. ");
INSERT INTO nkn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ambahoni vahanene vamala vamo lizika kanua linga vahandeke nguavo, “Tunamuvu alinakuhandeka mezi akushaula Mosesa na Njambi.” ");
INSERT INTO nkn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kaha mu ngila eyi vene vashongangeyele vantu na vakuluntu na valongisi va mezi a Lishiko. Vakuate Setefano nakumutuala ku Mpunga. ");
INSERT INTO nkn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ambahoni vanehele vakaleho vamakuli vaje vamuvangeyele nguavo, “Ou yala ntsimbu yoshe alinakuluisa Njivo ya Njambi ya kulela na Lishiko lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tunevu ahandeka nguendi ou Yesu ua ku Nazaleta akasiula Njivo ya Njambi, nakutengulula futisi yatuhanene Mosesa.” ");
INSERT INTO nkn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Voshe vatumamene muje mu Mpunga mesho avo atalele hali Setefano, kaha vamuene cihanga cendi casholokele ngue ca kangelo. ");
INSERT INTO nkn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kaha Kasasendote uakama uehuile Setefano nguendi, “Viuma evi vinapu via vusunga ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kaha Setefano uavakumbuluile nguendi, “Vamuanetu na vatate njivuilileni! Njambi ua vumpau ualisholuele kuli kukuluila uetu Avilahama te acili mu Mesopotamia, ntsimbu kanda acikale mu Halane, ");
INSERT INTO nkn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kaha uahandekele kuli ikeye nguendi, ‘Seza lifuti liove na ntanga yove kaha ya ku lifuti lije linjikakumuesa.’ ");
INSERT INTO nkn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ambahoni uasezele lifuti liandi lia Kalundiya uaile nakukala mu lifuti lia Halane. Munima ya kutsa kua ishe ya Avilahama, kaha Njambi uamuhumisile mu lifuti lije nakumuneha mu lifuti lino limulinakukala hano. ");
INSERT INTO nkn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Njambi kahanene Avilahama mutambela umo ua lifuti linga upue uendi, cipue kamutambela kakandende ka kuliata ka livu, vuno honi Njambi uamukulahesele kumuhanalio linga lipue liendi na vatekuluila vendi cipue vene te Avilahama kanda akale na muana. ");
INSERT INTO nkn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kaha evi vikevio viahandekele Njambi nguendi, ‘Vatekuluila vove vakakala mu lifuti lia vungezi, kaha vakapua vandungo nakuvayandesa cikuma miaka yakupua vihita viuana (400). ");
INSERT INTO nkn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Njikahisa vantu vaje vavakapangela, kaha munima ya viuma evi vatekuluila vove vakahuma mu lifuti lije, kaha vakanjilemesa mu mutambela uno vene.’ ");
INSERT INTO nkn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ambahoni Njambi uahanene Avilahama cilika cakulovoka ku mukanda kupua cimueso ca cikumiyiyo. Nankuma, Avilahama uapuile ishe ya Isake kaha uamutuhuile ku mukanda omo kuahitile matangua atanu na atatu kuhuma ha kusemuka cendi, kaha Isake uatuhuile munendi Yakomba, na Yakomba uatuhuile vana vendi likumi na vavali, vaje vakevo vakukuluila vakutsimana va muyati uetu. ");
INSERT INTO nkn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kaha vakuavo vana va Yakomba vovuililile cipululu shongo yavo Yosefa, vamulandesele ku vundungo mu Ingito. Vuno honi Njambi uakele hamo nendi ");
INSERT INTO nkn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nakumuniunga muacili mu tuyando tuendi tuoshe. Omo Yosefa uasholokele ku mesho a Falao muene ua Ingito, Njambi uamuhanene mana na kavumbi, kaha muene ua Ingito uapuisile Yosefa nguvulu uaka yula Ingito yoshe ya njivo ya muene. ");
INSERT INTO nkn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ambahoni kuakele njala mu lifuti lioshe lia Ingito na mu Kanana, kaha njala ije yanehele tuyando tuakama. Kaha vakukuluila vetu kuvasele kuuana viakulia, ");
INSERT INTO nkn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","vuno honi omo Yakomba uovuile nguavo ku Ingito kuli viakulia, uatumineko vana vendi, vakukuluila vetu, ha vungezi vuavo vua kulivanga. ");
INSERT INTO nkn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kaha ha vungenzi vuavo vua mucivali Yosefa ualisholuele kuli vamuanaye, kaha Falao muene ua Ingito uatantekeyele ntanga ya Yosefa. ");
INSERT INTO nkn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nankuma, Yosefa uatumine lizi kuli ishe Yakomba linga vakamuleke hamo na ntanga yendi ngeci veje ku Ingito, vapuile makumi atanu na avali na vantu vatanu (75). ");
INSERT INTO nkn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ambahoni Yakomba uasikumukile uaile ku Ingito, ikeye na vakukuluila vetu vakatsililileko. ");
INSERT INTO nkn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mivila yavo vaitualele ku Shekeme kuje vakavatsindile mu cihilo cije calandele Avilahama na vimbongo kuli vana va Hamole. ");
INSERT INTO nkn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Vuno honi omo ntsimbu yahete muyehi linga Njambi ashulisise cikulaheso cendi kuli Avilahama, vantu vetu valanene cikuma mu Ingito. ");
INSERT INTO nkn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kaha kuasuanene muene ueka uje katantekeyele Yosefa. ");
INSERT INTO nkn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ikeye uazangamesele vakukuluila vetu nakuvapangesa mua mupi, nakuvasindiya linga vombile kuti vana vavo linga vatse. ");
INSERT INTO nkn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ha ntsimbu ivene Mosesa uasemukile, uapuile kanike uacili cikuma ku mesho a Njambi. Vamulelele mu njivo ya ishe mu vingonde vitatu, ");
INSERT INTO nkn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kaha omo vamuhumisile mu njivo yavo, muna muene Falao ua mpuevo uamuambate nakumulela muacili nge munendi. ");
INSERT INTO nkn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mosesa vamulongesele mana oshe a vaka Ingito, kaha uapuile yala uakama mukuhandeka cendi na mu vilinga. ");
INSERT INTO nkn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Omo Mosesa uakele na miaka makumi auana (40), cahuminine kuintsi lia mutima uendi kuya nakumenekela vavushoko vendi vaka Isaleli. ");
INSERT INTO nkn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kaha omo uamuene Kaingito ali nakuyandesa umo ua kuli vavushoko vendi, nankuma, uashueneneko nakuohiela uje Kaisaleli kaha uatsihile uje Kaingito. ");
INSERT INTO nkn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Uayonguele nguendi hamo va Isaleli vendi vovuisisa ngeci Njambi alinakumupangesa linga akavohiele, vuno honi kuvatantekeyele. ");
INSERT INTO nkn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ha litangua liamukuavo Mosesa uamuene Vaisaleli vavali valinakulua, kaha uezile mukati kavo nakuhandeka kuli vakevo na mezi a ciyulo nguendi, ‘Eni vamala ivuilileni, yeni muvushoko vueni, kaha vika mulinakuliluisa umo namukuavo?’ ");
INSERT INTO nkn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Vuno honi uje yala uakele nakuluisa mukuavo uanakuile Mosesa nakuhandeka kuli ikeye nguendi, ‘Iya nakupuisa muka kusuana cipue lihako hhakati ketu? ");
INSERT INTO nkn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nkuma utonda linga unjitsihe naua nge munatsihile uje Kaingito izau ndi?’ ");
INSERT INTO nkn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Omo Mosesa uovuile mezi aua, uateuele mu Ingito nakuya nakukala mu lifuti lia Mindyani. Kaha kuje uakakele na vana vavali va vamala. ");
INSERT INTO nkn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Omo kuahitile miaka makumi auana (40), kangelo uasholokele kuli Mosesa mu mulengi ua tuhia tuakele nakushukuma mu liputa mu mpambo kuyehi na Munkinda ua Sinai. ");
INSERT INTO nkn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Omo Mosesa uamuene evi ualikomokelele ha cuma cije camuene, kaha uashuenene kuyehi na liputa mukumonesesa muacili. Vuno honi uovuile lizi lia Muene ngualio, ");
INSERT INTO nkn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yange Njambi ya vakukuluila vove, Njambi ya Avilahama na Isake na Yakomba.’ Kaha Mosesa uajajele nakuvua liova, kaha kataleleko naua. ");
INSERT INTO nkn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kaha Muene uahandekele kuli ikeye nguendi, ‘Shulula vinkaku viove, omuo ha mutambela ha unemana hanapu ha kulela. ");
INSERT INTO nkn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Njinamono omo muvali na kuyandeselamo vantu vange vaje vali mu Ingito. Kaha njinevu kulinienieta kuavo, njineja ha mavu nakuvamena. Kaha ija honi, linga njikakutume ku Ingito.’ ");
INSERT INTO nkn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ou ikeye Mosesa uje ivavianene omo vahandekele nguavo, ‘Iya nakupuisa muka kusuana cipue lihako hhakati ketu?’ Ikeye vene uje yatumine Njambi kupua muka kusuana na muka kupatula kuhitila muli kangelo uje uasholokele kuli ikeye mu liputa lije liakele nakuuema. ");
INSERT INTO nkn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ikeye uahumisile vantu mu Ingito, ualingile vitantekeyeso na vikomoueso mu Ingito, na ku Cisali ca Kuvenga naua na mu mpambo ha miaka makumi auana (40). ");
INSERT INTO nkn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ou ikeye Mosesa uje ualeke vantu va Isaleli nguendi, ‘Njambi akahumisa kananguizi ngue yange uje akahuma hhakati ka vantu veni vavenia.’ ");
INSERT INTO nkn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ikeye uakele hamo na vantu va Isaleli omo vakungulukilile mu mpambo, naua hamo na vakukuluila vetu na kangelo uje uahandekele kuli ikeye ha Munkinda ua Sinai, kaha uatambuile muzimbu ua kuyoya ua Njambi nakutuhanauo. ");
INSERT INTO nkn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Vakukuluila vetu vavianene kumuononoka, kaha vamunakuililile kumukulo nakutonda linga vahilukile naua ku Ingito. ");
INSERT INTO nkn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nankuma, vahandekele kuli Alone nguavo, ‘Tupangele vanjambi linga vatutuamenene. Kututantekeya cuma muka cinalingiua kuli Mosesa uje uatuhumisile ku Ingito.’ ");
INSERT INTO nkn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yapuile ntsimbu ije ivamungile kamponia mu cifua ca ngombe ua nkomba nakukombelelako nkombelo nakulinga ciuano cakusingimika cipangi ca mavoko avo. ");
INSERT INTO nkn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Vuno honi Njambi uavatalesele nima, kaha uavecelele linga valemese viuma via muilu, nge muvanasoneka mu livulu lia tunanguizi va Njambi va Njambi nguavo, “‘Vantu va Isaleli! Keti kuli yange muatsihilile nakukombelela tusitu ha miaka makumi auana mu mpambo. ");
INSERT INTO nkn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yapuile mbalaka ya njambi Moleki ikeyo ije imuambate, na cifua ca Lefane, njambi yeni ua vintangantanga, ava vakevo tumponia tueni tuje tumuapangele linga mutulemese. Nankuma, njikamituma ku vunzinda musinia lia Mbambilone.’” ");
INSERT INTO nkn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Vakukuluila vetu vakele na mbalaka yakulihanena vukaleho mu mpambo. Vaipangele nge Njambi muashikile Mosesa linga vaipangemo, kuya mu cifua cije vene civamuesele Mosesa. ");
INSERT INTO nkn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vakukuluila vetu vaje vatambuile mbalaka kuli vaishavo vayambate omo vaile na Yoshua nakutambula lifuti ku miyati ije yashekelemo Njambi omo vakele nakuya kulutue. Nankuma, cakele kuje noho ha ntsimbu ya Ndaviti. ");
INSERT INTO nkn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ikeye vene Ndaviti uje uauanene kavumbi ku mesho a Njambi, kaha uehuile Njambi amutavese linga atungile Njambi ya Yakomba Muakukala. ");
INSERT INTO nkn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Vuno honi uapuile Solomoni uje uamutungilile njivo. ");
INSERT INTO nkn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Vuno honi Njambi ua Helu Liavioshe kekukala mu vinjivo viakutunga na mavoko a vuntu, ngue muje alinakuhandeka kananguizi ua Njambi nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Muene ahandeka nguendi, lilu lipua litanda liange, na mavu apua vuliatelo vuange. Njivo ya muyati muka muasa kunjitungila? Mutambela ua muyati muka munjasa kukala? ");
INSERT INTO nkn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nkuma keti livoko liange vene vavenia liapangele evi viuma vioshe ndi?’ ");
INSERT INTO nkn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Yeni vantu vakukaluua,” Kaha Setefano uatualeleho kuhandeka nguendi, “Yeni vantu va mitima yakuhona kukutsiliela, na matuitui eni anashoko ku lizi lia Njambi! Yeni naua muli nakuviana Cimbembesi Uakulela nge muvalingile vakukuluila veni. ");
INSERT INTO nkn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Iya kananguizi ua Njambi ivahonouele kuyandesa vakukuluila veni? Vatsihile tunganda va Njambi vaje kusenkulu vambuluile kuija kua Ngamba yendi ua Vusunga. Kaha honi yeni muamuendele vungungu nakumutsiha. ");
INSERT INTO nkn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yeni muatambuile Lishiko lia Njambi lije livamihanene tungelo, vuno honi kumualiononokele.” ");
INSERT INTO nkn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Omo vaje vaka mpunga vovuile evi viuma kuli Setefano, vanienguele cikuma nakulishumanga ku mazo avo mukupihilila. ");
INSERT INTO nkn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Vuno honi Setefano mukushula na Cimbembesi Uakulela uatalele muilu, kaha uamuene vumpau vua Njambi na Yesu nemana ku livoko lia cilio lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Uahandekele nguendi, “Taleni! Njinamono lilu linashokoloka na Muna Muntu nemana ku livoko lia cilio lia Njambi!” ");
INSERT INTO nkn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Vuno honi vaje vaka mpunga vatambekele na lizi liakama cikuma na kuzika matuitui avo. Kaha voshe vaile hamo vuasi kuli ikeye, ");
INSERT INTO nkn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ambahoni vamukokelele hambanza lia nganda, kaha vamuashele mavue. Vakaleho vasezele vikovelo viavo mukuviniunga kuli mukueje umo lizina liendi Saulu. ");
INSERT INTO nkn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tele vali nakumuasha mavue, Setefano ualombelele nguendi, “Muene Yesu tambula Cimbembesi cange!” ");
INSERT INTO nkn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kaha uatsikamene ha mavuli endi nakutambakana na lizi liakama nguendi, “Muene, keti uanuke vupi vuavo ovu vuvanalingi!” Omo uahandekele mezi aua kaha uatsile. ");
INSERT INTO nkn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kaha Saulu uatavele kutsa kua Setefano. Ha litangua lije vene cikungulukilo ca mu Yelusalema caputukile kuyanda na mapakeso. Vaka kukutsiliela voshe valishandokelele mu mafuti a Yundeya na mu Samaliya kaha kuvanga lika tunganda vakevo vasalelemo. ");
INSERT INTO nkn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Vamo vamala vaka kulemesa Njambi vatsindile Setefano, vamulilile cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Vuno honi Saulu uesekele kunongesa cikungulukilo, uaile ku njivo na njivo nakukokangeya vamala na vampuevo nakuvahaka mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vaka kukutsiliela vaje vashandokele vaile mutambela na mutambela nakuambulula lizi. ");
INSERT INTO nkn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu uasikumukile ku nganda ya Samaliya nakuambulula muzimbu ua Kilistu kuli vantu vaje vakele kuje. ");
INSERT INTO nkn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Omo civunga ca vantu vovuile Filipu nakumona vitantekeyeso vije vialingile, kaha voshe vovuililile kuli vije viakele nakuhandeka. ");
INSERT INTO nkn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vimbembesi viakujuala viahumine muli vantu vavengi oku vitambakana na lizi liakama, vaka tulepa vavengi na vilema vakangukile. ");
INSERT INTO nkn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nankuma, mu nganda ya Samaliya muakele kujolela kuakama. ");
INSERT INTO nkn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mu nganda ije muakele yala umo ua lizina lia Simoni, uje ha ntsimbu yahanima uakomokesele vaka Samaliya na mantseno endi. Ualimuesele ikeye vavenia kupua umo uakama, ");
INSERT INTO nkn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","kaha vantu voshe muje mu nganda, vantu va vulemu na vaje keti va vulemu vovuililile kuli ikeye, kaha vahandekele nguavo, “Ou ikeye vene nzili ya Njambi uje ivatumbula nguavo Nzili Yakama.” ");
INSERT INTO nkn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vakele nakumuivuilila omuo ha ntsimbu yalaha uavakomokesele na mantseno endi. ");
INSERT INTO nkn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Vuno honi omo vatsilielelele uje muzimbu uahandekele Filipu kuli vakevo ua muzimbu uacili ua vumuene vua Njambi na via Yesu Kilistu, kaha voshe vamala na vampuevo vavambuitikile. ");
INSERT INTO nkn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Cipue Simoni nendi vene naua uatsilieliele, kaha omo vamumbuitikile uakele hamo na Filipu, ualikomokelele cikuma omo uamuene vikomoueso na vitantekeyeso viakama vije viakele nakulinga. ");
INSERT INTO nkn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Omo tunganda vaje vakele mu Yelusalema vovuile nguavo vantu va mu Samaliya vanatambula lizi lia Njambi, Nankuma, vavatuminine Petulu na Iuano. ");
INSERT INTO nkn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Omo vahete kuje, vakalombelelele vaje vaka kutsiliela linga vatambule Cimbembesi Uakulela, ");
INSERT INTO nkn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","omuo Cimbembesi Uakulela te kanda cije kuli vakevo, vuno honi vavambuitikile lika mu lizina lia Muene Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ambahoni Petulu na Iuano vasalekele mavoko avo hali vakevo, kaha vatambuile Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Omo Simoni uamuene nguendi tunganda vanahana Cimbembesi kuli vaka kutsiliela mukusaleka mavoko avo hali vakevo, nankuma uahanene vimbongo kuli Petulu na Iuano ");
INSERT INTO nkn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nakuhandeka nguendi, “Nange naua njihaneniko eyi nzili yakama linga uoshe injikasaleka mavoko ange akatambule Cimbembesi Uakulela.” ");
INSERT INTO nkn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Vuno honi Petulu uamukumbuluile nguendi, “Yove na vimbongo viove munonge hamo, omuo yove uayongola nguove hamo uasa kulanda vuana vua Njambi na vimbongo! ");
INSERT INTO nkn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yove kuuesi na mutambela cipue cihela mu vipangi vietu, omuo mutima uove kuuesi muacili ku mesho a Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nankuma, tenguluka linga uhume ku viyongola viove via vipi, kaha lomba kuli Muene linga akusambese ku viyongola viove nge evi. ");
INSERT INTO nkn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Omuo njinamono nguange yove unashulu na cipululu cacipi naua unapu u cinzinda ca vupi.” ");
INSERT INTO nkn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kaha Simoni uahandekele kuli Petulu na Iuano nguendi, “Njilombeleleniko kuli Muene linga viuma evi vimunahandeka keti vilingiue kuli yange.” ");
INSERT INTO nkn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Omo vamanusuile kuhana vukaleho vuavo nakuambulula muzimbu ua Muene, Petulu na Iuano vahilukile ku Yelusalema. Mu ngila yavo vakele nakuambulula Muzimbu Uacili mu membo amengi a mu Samaliya. ");
INSERT INTO nkn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kaha kangelo ka Muene uahandekele kuli Filipu nguendi, “Katuka uye ku mbuela ku ngila ije ihuma ku Yelusalema iya ku Ngaza.” (Ngila eyi yapua ya mu mpambo.) ");
INSERT INTO nkn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nankuma, Filipu uakatukile nakuya kaha ualiuanene na kayunuke uje uapuile Kaisopia, ikeye uapuile mukuluntu ua vulemu muka kuniunga vufuko vuoshe vua Kandeke muene ua mpuevo ua ku Isopia. Kaha uaile laja ku Yelusalema nakulemesa Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Omo uahilukile kuimbo uatumamene mu litemba liendi nakutanda livulu lia Isaya kananguizi ua Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kaha Cimbembesi Uakulela cahandekele kuli Filipu nguaco, “Shuena kuyehi na litemba lije.” ");
INSERT INTO nkn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nankuma, Filipu uashatukilileko kaha uamuivuile ali nakutanda mu livulu lia kananguizi ua Njambi Isaya. Kaha uamuhuile nguendi, “Ulinakuivuisisa evi ulinakutanda ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Uje mukuluntu uamukumbuluile nguendi, “Vatihoni njasa kuvivuisisa kuvanga umo anjilumbuininevio?” Kaha ualombele Filipu linga alonde nakutumama hamo nendi mu litemba. ");
INSERT INTO nkn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kaha mezi amu visoneka atandele uje yala akeuo aua: “Uapuile ngue mpanga uje vatuala nakumutsiha. Ngue muna mpanga uje aholoka kuluu kuli vaka kumutehula. Mukemo vene muaholokelelele na ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Vamukehesele, kaha kuvamusompelelele vusunga. Iya asa kuambulula ntanga yendi? Omuo muono uendi vauambate hano ha mavu.” ");
INSERT INTO nkn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kaha uje Kayunike uehuile Filipu nguendi, “Njileke, iya nkuma yanatumbula kananguizi, ikeye vavenia indi mukuavo ueka?” ");
INSERT INTO nkn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ambahoni Filipu uaputukile kuhandeka na visoneka evi, uamulekele Muzimbu Uacili ua Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kaha omo vakele nakuenda mu ngila, vahete ku mutambela umo kuje kuakele mema, kaha uje Kayunike uahandekele nguendi, “Tala mema aua! Vika naua vihonouesa kunjimbuitika?” ");
INSERT INTO nkn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu uamukumbuluile nguendi, “Citava kukumbuitika nga unatsiliela na mutima uove uoshe.” Ikeye uamukumbuluile nguendi, “Muavusunga vene njitsiliela nguange Yesu Kilistu ikeye Muna Njambi.” ");
INSERT INTO nkn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kaha uje Kayunike uashikile linga vemike litemba, kaha voshe vavali, Filipu na uje Kayunike vakovelele mu mema, kaha Filipu uamumbuitikile. ");
INSERT INTO nkn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Omo vajavulukile mu mema, Cimbembesi ca Muene catualele Filipu kueka. Kaha uje Kayunike kamumuene naua, vuno honi uaile vungezi vuendi nakuvuahelela cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Vuno honi Filipu ualiuanene ikeye vavenia ali ku Azotase, kaha uaile ku Sesaliya, mu ngila muoshe uaile nakuambulula Muzimbu Uacili mu vinganda vioshe. ");
INSERT INTO nkn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ha ntsimbu ijevene Saulu uakele navutenu vuakutonda kutsiha vandongisi va Muene, uaile kuli kasasendote uakama ");
INSERT INTO nkn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nakuvalomba mikanda ya ku vinjivo via malombelo vije viakele ku Ndamasika, linga nga akauanako vamo vakundama ku Ngila ya Yesu, vampuevo cipue vamala, akavakuate nakuvatuala ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Omo Saulu uahete kuyehi na nganda ya Ndamasika, vuasi vuasi ceke cahumine muilu nakutuila hali ikeye nakumuzengeleka. ");
INSERT INTO nkn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Uauililile ha mavu kaha uovuile lizi lihandeka kuli ikeye ngualio, “Saulu, Saulu, vika ulinakunjiyandesela?” ");
INSERT INTO nkn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kaha Saulu uehuile nguendi, “Yove iya, Muene?” Kaha lizi liakumbuluile ngualio, “Yange Yesu, uje iulinakuyandesa. ");
INSERT INTO nkn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Vuno honi katuka uye mu nganda, kaha vakakuleka viunapande kulinga.” ");
INSERT INTO nkn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Vamala vaje vendele hamo na Saulu vemanene kuakuhona kuhandeka omuo vovuile lika lizi vuno honi kuvamuene muntu cipue umo uje alihandeka. ");
INSERT INTO nkn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulu uakatukile ha mavu kaha uemuine mesho endi vuno honi kamuene cuma cimo. Nankuma, vamukuate ku livoko nakumutuala ku Ndamasika. ");
INSERT INTO nkn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ha matangua atatu kasele kumona, kalile cipue kunua cuma cimo. ");
INSERT INTO nkn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mu Ndamasika muakele ndongisi ua Njambi lizina liendi Ananiyasi. Uamuene cimona cije Muene uahandekele kuli ikeye nguendi, “Ananiyasi!” Kaha ikeye uakumbuluile nguendi, “Yange uno Muene.” ");
INSERT INTO nkn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kaha Muene uamulekele nguendi, “Katuka uye ku Ngila ya Kusungama ku njivo ya Yundasa ukehuleko yala nahumu ku Talisi lizina liendi Saulu. Omuo ha ntsimbu inovene alinakulombela, ");
INSERT INTO nkn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kaha mu cimona cendi namono yala umo lizina liendi Ananiyasi neja nakumusaleka mavoko endi linga ase kumona naua.” ");
INSERT INTO nkn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Vuno honi Ananiyasi uakumbuluile nguendi, “Muene, njinevu viou yala kuli vantu vavengi, na viuma viavingi viavikalu vianalingi ku vantu vove vakulela mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kaha neja kuno na nzili yakama yakuhuma kuli vakuluntu va tusasendote mukukuata voshe vaje valemesa lizina liove.” ");
INSERT INTO nkn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Vuno honi Muene uahandekele kuli ikeye nguendi, “Ya, omuo njinamuhangula linga anjipangele mukusholola lizina liange kuli vaje keti Vayunda na kuli vamiene na kuli vantu va Isaleli. ");
INSERT INTO nkn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yange vavenia njikamuleka muje muanapande kuyanda omuo ya lizina liange.” ");
INSERT INTO nkn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nankuma, Ananiyasi uaile nakukovela mu njivo kaha uasalekele mavoko endi hali Saulu nakuhandeka nguendi, “Muanetu Saulu, Muene Yesu uje uasholokele kuli yove mu ngila omo uakele nakuija kuno, nanjitumu linga uase kumona naua kaha ushule na Cimbembesi Uakulela.” ");
INSERT INTO nkn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hajevene viuma viakufua ngue mavanda viahumine ha mesho endi, kaha uasele kumona naua. Ambahoni uakatukile kaha vamumbuitikile, ");
INSERT INTO nkn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","kaha munima yakulia viakulia, uakele na nzili naua. Saulu uakele matangua amandende lika na vandongisi mu Ndamasika. ");
INSERT INTO nkn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hajevene uaile ku vinjivo via malombelo via Vayunda nakukaputuka kuambulula nguendi Yesu ikeye Muna Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Voshe vaje vamuvuile valikomokelele nakuihula nguavo, “Nkuma ou keti ikeye uje yala uakele mu Yelusalema uje uakele nakutsiha voshe vaje valemesele lizina eli ndi? Kaha nkuma kezile kuno mukukuata vaje vantu linga avatuale kuli vakuluntu va tusasendote ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulu uakele na nzili cikuma, uapayesele Vayunda vaje vakele mu Ndamasika mukuvaleka vusunga nguendi Yesu ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Omo kuahitile matangua amengi, Vayunda valikunguluile hamo nakutumba vutumbe vuakutsiha Saulu, ");
INSERT INTO nkn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","vuno honi Saulu uatantekeyele via vutumbe vuavo. Mutania na vutsiki vakele nakuniunga ku vikolo via ku nganda linga vamutsihe. ");
INSERT INTO nkn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Vuno honi vutsiki vumo vandongisi vendi vamuhakele mu mutonga nakumusosela hambanza lia civumbe mu njanena. ");
INSERT INTO nkn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Omo Saulu uaile ku Yelusalema uesekele kulipandakana hamo na vandongisi, vuno honi voshe vamuteuele omuo kuvatsilielele nguavo ikeye napu ndongisi. ");
INSERT INTO nkn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Vuno honi Mbanambasa uamuambate nakumutuala kuli tunganda. Uavalumbunuine muje Saulu uamuene Muene ha ngila na muje Muene uahandekele kuli ikeye. Kaha naua uavalekele kusimpa kua Saulu omo uambuluile mu lizina lia Yesu mu Ndamasika. ");
INSERT INTO nkn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nankuma, Saulu uatumamene hamo navo kaha uahitanganene mu Yelusalema muoshe nakuambulula mu lizina lia Muene nakusimpa. ");
INSERT INTO nkn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Uahandekele nakuliluisa na Vayunda vaje vakele nakuhandeka Cingelengu, vuno honi vatondele kumutsiha. ");
INSERT INTO nkn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Omo vaka kutsiliela vovuile evi, vatualele Saulu ku Sesaliya nakumutuma ku Tasisi. ");
INSERT INTO nkn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nankuma, cikungulukilo coshe mu Yundeya na mu Ngalileya na mu Samaliya viakele na ntsimbu ya ciyulo. Hakukuasa kua Cimbembesi Uakulela vikungulukilo viakolele nakulivuezelela, nge hakuyoya kuavo kuakuvuila Muene liova. ");
INSERT INTO nkn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulu uendanganene oku noku, kaha ha ntsimbu imo uaile nakumona vaka kutsiliela vaje vakele mu Linda. ");
INSERT INTO nkn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kuje uakauanene yala umo lizina liendi Aeneyase uje uapuile muka kalepa kasele kuhuma ha linala ha miaka itanu na itatu. ");
INSERT INTO nkn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulu uahandekele kuli ikeye nguendi, “Aeneyase, Yesu Kilistu akukanguise. Katuka jandula linala liove.” Hajevene Aeneyase uakatukile. ");
INSERT INTO nkn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vantu voshe vamu Linda na mu Shalone vamumuene kaha vatengulukilile kuli Muene. ");
INSERT INTO nkn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mu Yopa muakele ndongisi ua mpuevo lizina liendi Tambita, (lizina liendi mu Cingelengu ikeye Ndokasi, kulumbunuka “Nsonge”) ntsimbu yoshe uakele nakulinga viacili nakukuasa tuhutu. ");
INSERT INTO nkn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ha ntsimbu ijevene uavavalele, kaha uatsile. Vatanesele muvila uendi nakuulangeka ku mulili ua helu lia njivo. ");
INSERT INTO nkn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Linda yakele kuyehi na Yopa, kaha omo vandongisi vaje vakele mu Yopa vovuile nguavo Petulu ali mu Linda vatumine vamala vavali kuli ikeye nguavo, “Muane, unapande kuija vuasi kuno kuli yetu.” ");
INSERT INTO nkn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nankuma, Petulu uakatukile nakuya navo. Omo uahete kuje vamutualele ku mulili uahelu kuje vantuluue voshe vamuzengelekele nakulila nakumumuesa vimbinja na vikovelo vije vialingile Ndokasi ha ntsimbu ije yakele navo. ");
INSERT INTO nkn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulu uavahumisilemo voshe muje mu mulili, kaha uatsikamene ha mavu nakulombela, ambahoni uatengulukilile ku civimbi ca Ndokasi nakuhandeka nguendi, “Tambita, hinduka!” Kaha uemukile, kaha omo uamuene Petulu, uahindukile na kutumama. ");
INSERT INTO nkn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulu uamukuate ku livoko nakumuimika. Ambahoni uasanene vaka kutsiliela voshe na vaje vantuluue, kaha uavahaneneye oku alinakuyoya. ");
INSERT INTO nkn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kaha Muzimbu ou uashandokelele mu Yopa muoshe, kaha vantu vavengi vatsilielelele kuli Muene. ");
INSERT INTO nkn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kaha Petulu uakele mu Yopa ntsimbu yalaha hamo na Simoni muka kufutungula vilambu. ");
INSERT INTO nkn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kuakele yala umo mu Sesaliya lizina liendi Koneliasi, uje uapuile ntuama uamasualale cihita cimo (100) va Valoma vaje vavatumbuile nguavo, “Civunga ca masualale va Itali.” ");
INSERT INTO nkn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uapuile yala uavakakulemesa Njambi uakuivuila Njambi liova hamo na ntanga yendi yoshe. Naua uakele nakukuasa cikuma vantu vakuhutua, kaha ntsimbu yoshe uakele nakulombela kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kuntsimbu imo te mutania ua vihola vitatu, uakele nacimona cije muamuene muacili kangelo ua Njambi uezile nakuhandeka kuli ikeye nguendi, “Koneliasi!” ");
INSERT INTO nkn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Uatalele kuli kangelo na liova nakuhandeka nguendi, “Vika Muene?” Kangelo uamukumbuluile nguendi, “Njambi navuluka malombelo ove na ku vipangi viove viacili. ");
INSERT INTO nkn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kaha honi tuma vamala vaye ku Yopa kuli yala umo Simoni ivatumbula Petulu kaha vamunehe kuno. ");
INSERT INTO nkn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ikeye napu mungezi mu njivo ya Simoni uje muka kufutungula vilambu, njivo yendi ili kuyehi na mema a kalunga.” ");
INSERT INTO nkn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Omo uje kangelo yakele nakuhandeka nendi uaile, kaha Koneliasi uasanene vangamba vendi vavali na lisualale uje uapuile uavaka kulemesa Njambi, umo uavaje vakele nakumupangela. ");
INSERT INTO nkn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hanima yakuvaleka vioshe, uavatumine ku Yopa. ");
INSERT INTO nkn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Liamukuavo, omo vakele mu ngila nakuya ku Yopa, kaha Petulu uaile ha tsimba lia njivo nakulombela te litangua lili hhakati ka mutue. ");
INSERT INTO nkn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Uevuile njala kaha uakele nakutonda viakulia, te vali nakuvuahesa viakulia, uakele nacimona. ");
INSERT INTO nkn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Uamuene lilu liashokoloka na cuma cimo cakulifua ngue ntanga yakama ije yazezumukilile ha mavu yakuta ku vimbango viuana via lifuti. ");
INSERT INTO nkn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mukati kayo muakale miyati yoshe ya tusitu, tusitu vakulikoka ha mavu na tuzila. ");
INSERT INTO nkn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kaha uevuile lizi ngualio, “Katuka Petulu, tsiha kaha alia.” ");
INSERT INTO nkn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Vuno honi Petulu uahandekele nguendi, “Muene kuahi, omuo kanda njicilieho cuma cimo cakujuala cipue cakujeneka kujela.” ");
INSERT INTO nkn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kaha lizi liahandekele kuli ikeye naua ntsimbu ya mucivali ngualio, “Keti utumbule nguove viakujuala vije Njambi nalelesa ");
INSERT INTO nkn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eci calingiuile vintsimbu vitatu, kaha cije cuma vacihiluisile naua muilu.” ");
INSERT INTO nkn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tele Petulu nalikomokela cije cimona mucinalumbunukila, vamala vaje vavatumine kuhuma kuli Koneliasi vehuile ku njivo ya Simoni kaha vemanene ku cikolo. ");
INSERT INTO nkn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vehuile nguavo, “Kuli mungezi kuno ivatumbula nguavo Simoni Petulu ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tele Petulu ali nakusinganieka cimona, Cimbembesi cahandekele kuli ikeye nguaco, “Tala, vamala vatatu vali nakukutonda. ");
INSERT INTO nkn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Katuka yauye ha mavu, linga ukaye navo kuakuhona kuhona, omuo yange njavatumu.” ");
INSERT INTO nkn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kaha Petulu uaile ha mavu kuli vaje vamala nakuhandeka nguendi, “Yange uno muli nakutonda. Vika munezila kuno?” ");
INSERT INTO nkn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kaha vamukumbuluile nguavo, “Koneliasi Ntuama ua masualale cihita cimo (100) ikeye natutumu kuno. Ikeye yala uacili mukakulemesa Njambi, kaha naua Vayunda voshe vakamusingimika. Kaha Kangelo ua Njambi kamulekele linga akulanie uye ku njivo yendi linga akevuilile vije viukahandeka.” ");
INSERT INTO nkn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kaha Petulu ualaniene vaje vamala linga vakose mu njivo yendi. Kaha liamukuavo uaile hamo navo, navamo vaka kutsiliela vaje vahumine ku Yopa vahile hamo nendi. ");
INSERT INTO nkn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kaha liamukuavo vahete ku Sesiliya, kuje Koneliasi uakele nakuvavandamena, hamo navavushoko na vavusamba vendi vaje valaniene. ");
INSERT INTO nkn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hakuheta kua Petulu, Koneliasi uamusheshele nakuua ku viliato viendi nakumulemesa. ");
INSERT INTO nkn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Vuno honi Petulu uamukatuile nakuhandeka nguendi, “Katuka njinapu nji muntu lika.” ");
INSERT INTO nkn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kaha omo uakele nakuhandeka nendi, uakovelele mu njivo kaha uauanene vantu vavengi valikungulula hamo. ");
INSERT INTO nkn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kaha uahandekele kuli vakevo nguendi, “Yeni munatantekeya ngueni Kayunda Lishiko liendi kulitavesa kulimenekele na kukala hamo nava keti Vayunda. Vuno honi Njambi nanjimuesa ngeci yange keti njiyongole muntu umo nguange uakujuala cipue uakuhona kulela. ");
INSERT INTO nkn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaha omo muanjisanene, njinezile kuakuhona vimpata. Kaha honi njihula vika muanjisanenena.” ");
INSERT INTO nkn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneliasi uamukumbuluile nguendi, “Yapuile nge ntsimbu ino vene te munahiti matangua auana omo njakele na kulombela mu njivo yange ha ola ya mucitatu ya cinguezi. Kaha hajevene yala umo uazalele vizalo viakuviazima uemanene kulutue luange. ");
INSERT INTO nkn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kaha uahandekele nguendi, ‘Koneliasi lilombelo liove vanalivu na vipangi viove vanavianuka kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuma umo ku Yopa linga akasane yala umo lizina liendi Simoni ivatumbula Petulu. Napu mungezi ku njivo ya Simoni uje mukakufutungula vilambu uje uakala kungenge ya cisali.’ ");
INSERT INTO nkn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nankuma, njakusanene vuasi vuasi, kaha unavuahesa omo uneja. Kaha tuvavoshe tuli kuno ku mesho a Njambi nakuivuilila vije Muene nakushiki kuhandeka.” ");
INSERT INTO nkn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kaha Petulu uaputukile kuhandeka kuli vakevo nguendi, “Mua vusunga njinevuisisa nguange Njambi kekuyengula. ");
INSERT INTO nkn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Vaje voshe vamuteua nakulinga vije viacili navatambula, kakatala ku muyati ua vantu. ");
INSERT INTO nkn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muatantekeya muzimbu uatumine kuli Vaisaleli, uje uakuambulula Muzimbu Uacili ua ciyulo kuhitila muli Yesu Kilistu, Muene ua voshe. ");
INSERT INTO nkn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Uje muzimbu uashandokelele mu Yundeya, uaputukilile mu Ngalileya munima ya Iuano ha kuambulula kumbuitika kua kutenguluka. ");
INSERT INTO nkn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Muje Njambi uavuavesele Yesu uaku Nazaleta na Cimbembesi Uakulela na nzili. Uakele nakuya kuoshe nakupanga viacili nakukanguisa vaje voshe vakele na nzili ya Liyavolo, omuo Njambi uakele hamo nendi. ");
INSERT INTO nkn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tuvakaleho kuvije vioshe vialingiuile mu Yundeya namu Yelusalema. Kaha vamutsihile mukumushukika ha cilindakano. ");
INSERT INTO nkn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Vuno honi Njambi uamusanguile ku vatsi ha litangua lia mu citatu na kumutavesa linga alisholole, ");
INSERT INTO nkn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","keti ku vantu voshe vuno honi kuli yetu lika vaje vahanguile Njambi kupua vakaleho vendi, yetu vaje valile nendi na kunua nendi munima yakusanguka ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Uatushikile kuambulula ku vantu na kuambulula vukaleho ngeci Njambi namuhangula kupua muka kuyula uavaka kuyoya na vatsi. ");
INSERT INTO nkn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kaha tunanguizi va Njambi voshe va Njambi vakahana vukaleho nguavo uoshe uje akatsiliela muli ikeye vakamukonekela ku vupi vuendi kuhitila muli lizina liendi.” ");
INSERT INTO nkn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tele Petulu uakele nakuhandeka, Cimbembesi Uakulela cezile hali voshe vaje uevuile muzimbu. ");
INSERT INTO nkn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kaha Vayunda vaje vaka kutsiliela vaje vezile na Petulu kuhuma ku Yopa valikomokelele cikuma hakumona vuana vua Cimbembesi Uakulela vanacihana cipue kuli vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Vevuile vali nakuhandeka mu vindaka viakuliseza seza nakulemesa vukama vua Njambi, kaha Petulu uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ava vantu vanatambula Cimbembesi Uakulela, nge muje yetu tuacitambuile. Nkuma kuli umo asa kuvavindika kuvambuitika ku mema ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kaha uavashikile linga vavambuitike mu lizina lia Yesu Kilistu. Kaha vamulombele linga akale navo matangua amandende lika. ");
INSERT INTO nkn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kaha Tunganda na vaka kutsiliela vaje vakele mu Yundeya vovuile nguavo vaje keti Vayunda navakevo vanatambula lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Omo Petulu uaile ku Yelusalema, vaje keti Vayunda vaje vauanene kavumbi ha kulovoka vamuluisile, ");
INSERT INTO nkn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nakuhandeka nguavo, “Vika unaila kuli ava keti Vayunda vakuhona kulovoka nakulia navo?” ");
INSERT INTO nkn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kaha Petulu uaputukile kuvalumbunuina kuputukila hambangelo nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Omo tele njakele nakulombela mu mbonge ya Yopa, njamuene cimona. Njamuene cimo cezile ha mavu cakulifua ngue ntanga yakama yakukuta ku vimbango viuana kuhuminina muilu, kaha yatulilile kuyehi nange. ");
INSERT INTO nkn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Omo njatalele cikuma mukati kayo njamuene miyati ya tusitu vamikono iuana, tungunga, tusitu vakulikoka ha mavu, na tuzila. ");
INSERT INTO nkn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kaha njevuile lizi lihandeka kuli yange ngualio, ‘Katuka Petulu, ntsiha kaha ulie!’ ");
INSERT INTO nkn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Vuno honi njakumbuluile nguange, ‘Muene kuahi, omuo kanda njicilieho cuma cimo cakujuala cipue cakujeneka kulela.’ ");
INSERT INTO nkn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kaha lizi liahandekele kuli yange naua ntsimbu ya mu civali kuhuminina muilu ngualio, ‘Vije Njambi nalelesa, keti uvitumbule nguove viakujuala.’ ");
INSERT INTO nkn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eci calingiuile ha vintsimbu vitatu, kaha ije ntanga na vioshe vije viakeleho vavihiluisile naua muilu. ");
INSERT INTO nkn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaha hajevene vamala vatatu vaje vavatumine kuli yange kuhuminina ku Seseliya vahete ku njivo kuje kunjakele. ");
INSERT INTO nkn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Cimbembesi canjilekele nguaco njiye navo kuakuhona kulisindiya. Ava vakuetu vatanu na umo vaka kutsiliela vaile hamo nange ku Seseliya, kaha tuvavoshe tuakovelele hamo mu njivo ya Koneliasi. ");
INSERT INTO nkn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Uatulekele omo muamuenenenemo kangelo uje uemanene mu njivo yendi nakuhandeka nguendi, ‘Tuma vantu ku Yopa vakasane Simoni, uje ivatumbula Petulu. ");
INSERT INTO nkn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Akamihana muzimbu uje yove na ntanga yove yoshe mukovokela.’ ");
INSERT INTO nkn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Omo njaputukile kuhandeka, Cimbembesi Uakulela cakele hali vakevo nge muje mucakele hali yetu hambangelo. ");
INSERT INTO nkn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nankuma njili nakuvuluka lizi liahandekele Muene nguendi, ‘Iuano uambuitikile na mema, vuno honi vakamimbuitika na Cimbembesi Uakulela.’ ");
INSERT INTO nkn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nga Njambi avahana vuana vuakulifua ngue vuje vua tuhanene omo tuatsilielele muli Muene Yesu Kilistu, kaha yange iya honi linga njivianese Njambi?” ");
INSERT INTO nkn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kaha omo vovuile vije viahandekele, vecelele kumuluisa kaha vaputukile kulemesa Njambi nakuhandeka nguavo, “Nkuma Njambi nahana ntsimbu kuli ava keti Vayunda linga vatenguluke naku yoya.” ");
INSERT INTO nkn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vakakutsiliela vaje valishandokele ha mapakeso na ha ntsimbu ije ivatsihile Setefano vaile kulahako, vaile ku Funisiya na ku sapulasi na ku Antioke nakuambulula lizi kuli Vayunda lika. ");
INSERT INTO nkn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Vuno honi vaka kutsiliela vakuavo vaje vahuminine ku Sapulasi naku Silene vaile ku Antioke kaha naua vaile nakuambulula muzimbu kuli Vangelengu, nakuvalekesa Muzimbu Uacili ua Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nzili ya Muene yakele hamo navo, kaha vantu vavengi vatengulukile na kutsiliela muli Muene. ");
INSERT INTO nkn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Muzimbu uoshe uahete ku cikungulukilo ca mu Yelusalema, kaha vatumine Mbanambasi ku Antioke. ");
INSERT INTO nkn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Omo uezile uamuene kavumbu ka Njambi muje muka nakuisuliua vantu, uavuahelelele kaha uavalambelele ngeci vapue vaka vusunga kuli Muene na mitima yavo yoshe. ");
INSERT INTO nkn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mbanambasa uapuile yala uacili uakushula na Cimbembesi Uakulela na lutsilielo, kaha na vantu vavengi vezile kuli Muene. ");
INSERT INTO nkn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kaha Mbanambasa uahile ku Tasisi mukutonda Saulu. ");
INSERT INTO nkn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kaha omo uamuuanene uamutualele ku Antioke, mu muaka uoshe uamutuntu ava vavali valiuanene na vantu va mu cikungulukilo nakulongesa civunga cakama kaha ku Antioke kuje Vandongisi vavaputukile kuvahandeka nguavo vaka Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ha ntsimbu ije tunanguizi va Njambi va Njambi vahumine ku Yelusalema vasikumukile ku Antioke. ");
INSERT INTO nkn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Umo uavo ua lizina lia Angambase uemanene na nzili ya Cimbembesi nakuambulula vunanguizi nguendi njala yakama ilinakuija hano ha mavu oshe a vaka Loma (kaha eci calingiuile omo Kalaundiase uapuile Sezale). ");
INSERT INTO nkn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nankuma vandongisi vasinganiekele ngeci umo na umo hhakati kavo akatume vukuasi ngue muanasela mukukuasa vakuavo vaka kutsiliela vaje vakele mu Yundeya. ");
INSERT INTO nkn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kaha valingile cuma eci, vahanene vimbongo kuli Mbanambase na Saulu ngeci vavituale kuli vakuluntu va cikungulukilo. ");
INSERT INTO nkn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kaha ha ntsimbu ije vene muene Helonde uaputukile kupakesa vaka cikungulukilo. ");
INSERT INTO nkn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Uatsihile Tiango munaina ya Iuano, namukuale. ");
INSERT INTO nkn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kaha omo uamuene ngeci navuahelesa Vayunda, kaha uatualeleleleho lutue kukuta Petulu. (Eci capangiuile ha ntsimbu ya ciuanao ca Mbolo yakuhona cimbaluila.) ");
INSERT INTO nkn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kaha omo uamukutile uamuhakele mu kamenga, kaha vamuhanene ku vivunga via masualale viuana muje muakele vauana mu civunga cimo na cimo linga vamuniunge. Helonde uatondele kumusompesela ha civunga ca vantu omo ciuano ca Paseka nga cinahu. ");
INSERT INTO nkn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tele Petulu acili mu kamenga, Cikungulukilo cakele nakumulombelelela kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Vutsiki vujevene ntsimbu Helonde kanda a mutuale kuli vantu, Petulu uakosele mukati kavaje vakele nakumuniunga vavali. Vamukutile na malienge avali, kaha kuakele masualale ha cikolo vaje vakele nakuniunga. ");
INSERT INTO nkn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kaha hajevene kangelo ua Njambi uasholokele na ceke kutuila mu kamenga, kaha uje kangelo uaningangele Petulu nakuhandeka kuli ikeye nguendi, “Katuka vuasi.” Kaha hajevene malienge aje akele ku mavoko endi azitukile. ");
INSERT INTO nkn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kaha kangelo uahandekele naua kuli ikeye nguendi, “Kuta muiva uove kaha zala na vinkaku viove.” kaha Petulu ualingile muje muamulekelelemo, kaha kangelo uahandekele naua nguendi, “Zala cikovelo cove kaha njikave.” ");
INSERT INTO nkn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kaha Petulu uamukavangeyele hambanza lia kamenga, vuno honi katantekeyele nguendi vije viakele nakulinga kangelo viapuile via vusunga, uasinganiekele nguendi hamo ali nakumona lika cimona. ");
INSERT INTO nkn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Omo vapulakanene civunga ca masualale ca kulivanga na cije ca mucivali, kaha vahete ku cikolo lia cikuavo cije cakushokoluela cikolo caku nganda. Kaha cikolo calishokolokelele cikeco vavenia, kaha vatuhukile hambaza. Vendele hamo kaha hajevene kangelo uasezele Petulu. ");
INSERT INTO nkn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petulu uasinganiekele hali vije vialingiuile kuli ikeye kaha uahandekele nguendi, “Hano honi njatantekeya muavusunga ngeci Muene natumu kangelo uendi linga anjovole ku nzili ya Helonde naku vioshe vije Vayunda vasinganiekele nguavo vikalingiua.” ");
INSERT INTO nkn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Omo uatantekeyele vioshe vije via lingiuile, uaile ku njivo ya Maliya vaina ya Iuano uje ivatumbuile Mako, kuje kuvakungulukilile vantu vavengi nakulombela. ");
INSERT INTO nkn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kaha Petulu ua tote ha cikolo ca hambanza, kaha ngamba umo ua lizina lia Londa uezile nakumutava. ");
INSERT INTO nkn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Uatantekeyele lizi lia Petulu kaha uavuahelele cikuma, uahilukile kuli vakevo kuakuhona kushokolola cikolo nakuhandeka nguendi, “Petulu ali hambaza.” ");
INSERT INTO nkn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kaha voshe vahandekele kuli ikeye nguavo, “Uzaluka!” Kaha uavasindiyiye nguendi njimileka vusunga. Kaha vamukumbuluile nguavo, “kumani kangelo uendi.” ");
INSERT INTO nkn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Vuno honi Petulu uatualeleho kutota ha cikolo, kaha omo vashokoluele ku cikolo vamumuene kaha valikomokelele cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Uavaniatelele na livoko liendi linga vaholoke kulu, kaha uavalekele omo Muene namuhumisilamo mu kamenga nguendi, “Lekeni evi kuli Tiango na vakakutsiliela.” Kaha uavasezele nakuya ku mutambela ueka. ");
INSERT INTO nkn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kaha omo kuacele cimene kuakele citanga cikuma hhakati ka masualale vaje vaka kuniunga kamenga, hali vije vialingiuile kuli Petulu. ");
INSERT INTO nkn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helonde uavashikile linga vamutonde vuno honi kuvamuuanene, uehozuele vaje vaka kuniunga kaha uashikile linga vavatsihe, nankuma Helonde uahumine mu Yundeya na kuya ku Sesaliya, nakukalako. ");
INSERT INTO nkn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nankuma Helonde uanienguelele cikuma vantu vaku Tile na Kusindone. Kaha civunga cakama caile nakumumona. Hakulivanga valambelele Mbalasitase muka kuniunga lipela ngeci avakuase. Kaha honi vaile kuli Helonde nakumulomba ngeci kukale ciyulo, omuo lifuti liavo liakele nakutambula via kulia via kuhuma ku lifuti lia muene. ");
INSERT INTO nkn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ha litangua lia kuhangula, Helonde ualikutile mukole uendi ua vumuene nakutumama ha vumuene vuendi nakuhandeka ku vantu. ");
INSERT INTO nkn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Vatambakanene cikuma nguavo, “Keti lizi lia muntu lihandeka vuno honi lizi lia tunjambi!” ");
INSERT INTO nkn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hajevene kangelo ua Njambi uapupile Helonde, omuo kahanene kasingimiko kuli Njambi. Kaha mavuno amulile, kaha uatsile. ");
INSERT INTO nkn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Vuno honi lizi lia Njambi liatualeleleleho kuya lutue. ");
INSERT INTO nkn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Omo vamanusuile vije vivaililile kuli Mbanambasa na Saulu kaha vahilukile ku Yelusalema hamo na Iuano, uje ivatumbuile naua nguavo Mako. ");
INSERT INTO nkn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kaha mu cikungulukilo ca Antioke kuakele tunanguizi va Njambi va Njambi na valongisi, vapuile Mbanambase na Simioni uje ivatumbuile nguavo uaku zivala, na Luyasi (uje uahumine ku Silene) na Manane, (Uje ivalelele hamo na Sezale Helonde) na Saulu. ");
INSERT INTO nkn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Omo vakele nakulemesa Muene nakuliumina via kulia, Cimbembesi Uakulela cahandekele nguaco, “Njitepeseleniko Mbanambase na Saulu linga vapange vipangi vije njavasanenene.” ");
INSERT INTO nkn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hanima yakuliumina via kulia na kulombela, nakuvasaleka mavoko kaha vavatumine. ");
INSERT INTO nkn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Omo Cimbembesi Uakulela ca tumine Mbanambase na Saulu vaye ku Seleusiya, kaha hakuhuma kuje vasikumukile mu vuato ku nkundu lia Sapulasi. ");
INSERT INTO nkn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Omo vahete ku Salamisi vaputukile kuhandeka lizi lia Njambi mu vinjivo via malombelo via Vayunda. Kaha Iuano uakele hamo navo mukuvakuasa vipangi. ");
INSERT INTO nkn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vendele mu nkundu muoshe nakuheta kuli Pafose kuje vakauanene umo muka matseno lizina liendi Mbala-Yesu, ikeye Kayunda uje ualitumbuile ikeye vavenia kupua kananguizi ua makuli. ");
INSERT INTO nkn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Uapuile kavusamba kauje mukuluntu uamuje mu nkundu lizina liendi Selengiyase Pauluse, uje uapuile yala uamangana. Nguvulu ua Loma uasanene Mbanambase na Saulu omuo uatondele kuivua lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Vuno honi vakele nakuvaluisa kuli muka mantseno Eliamase (eli likelio lizina liendi lia Cingelengu), uje uesekele kuhumisa Nguvulu lutsilielo. ");
INSERT INTO nkn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Vuno honi Saulu uje ivatumbuile nguavo Paulu uashulile na Cimbembesi Uakulela, uatalele uje muka mantseno. ");
INSERT INTO nkn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nakuhandeka nguendi, “Yove muna Liyavolo, yove citozi ca vusunga, uakushula na makuli oshe na lizangamena lioshe, kaha yove ntsimbu yoshe uli nakueseka kutengulula vusunga vua Muene kuvupuisa makuli. ");
INSERT INTO nkn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Muene akakuluisa, kaha ukapua kapuputua muka ntsimbu lika, kukamono kutua ca litangua.” Kaha hajevene mbundu na milina viezile ha mesho endi kaha uahonouele kumona, uaputukile kutonda muntu linga amukuate ku livoko. ");
INSERT INTO nkn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kaha omo Nguvulu uavimuene vije via lingiuile uatsilielele, omuo ualikomokelele cikuma ha vilongesa via Muene. ");
INSERT INTO nkn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kaha Paulu na vakuavo vajavukile mu vuato kuya musinia lia Pafose, kaha vezile ku Pelenga nganda ya mu Pamefeliya, kaha Iuano uavasezele uahilukile ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Vahumine ku Pelenga vahete ku Antioke mu Pisindiya, kaha lia Sapalalo vaile mu njivo ya malombelo ya Vayunda na kutumama. ");
INSERT INTO nkn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Omo vatandele Lishiko lia Mosesa na visoneka via tunanguizi va Njambi va Njambi kaha vantuama va mu njivo ya malombelo ya Vayunda vatumine lizi kuli vakevo nguavo, “Vavusamba tumilomba nguetu muhandeke kuli vantu nga muli na mezi akuvatakamesa.” ");
INSERT INTO nkn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kaha Paulu uemanene na kualola livoko liendi muilu nakuhandeka nguendi, “Vavushoko vuange vaka Isaleli neni keti Vayunda vaka kulemesa Njambi, tolilileni kuli yange! ");
INSERT INTO nkn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Njambi ua vantu va Isaleli uahanguile vakukuluila vetu, nakuvapuisa muyati uakama ha tsimbu ije vakele vangezi mu Ingito. Kaha Njambi uavahumisile mu Ingito na nzili yendi yakama, ");
INSERT INTO nkn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kaha uavaniungile mu mpambo miaka yakupua makumi auana. ");
INSERT INTO nkn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Uanongesele mafuti a miyati itanu na ivali mu lifuti lia Kanana, kaha uapuisile lifuti lije vusuana vua vantu vendi. ");
INSERT INTO nkn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kaha evi viuma vioshe via lingiuile ha miaka yakusetekesa vihita viuana na makumi atanu (450). “Kaha munima yevi uavahanene mahako noho ha ntsimbu ya kananguizi Samuele. ");
INSERT INTO nkn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Valombele muene, kaha Njambi uavahanene Saulu muna Kishe, uaku muyati ua Mbenjameni, ngeci apue muene uavo ha miaka makumi auana (40). ");
INSERT INTO nkn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kaha omo Njambi uahumisile Saulu ha vumuene, uapuisile Ndaviti muene uavo. Eci cikeco cahandekele Njambi hali ikeye nguendi, ‘Njinauana Ndaviti muna Njesi ikeye yala uje injazanga, uje akalinga vioshe vije njitonda ngeci avilinge.’ ");
INSERT INTO nkn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ikeye Yesu uaku ntanga ya Ndaviti uje Njambi uamupuisile muyoyesi ua vantu va Isaleli ngue muakulahesele laja. ");
INSERT INTO nkn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ntsimbu kanda Yesu aputuke vipangi viendi, Iuano uambuluile kuli vantu voshe va Isaleli ngeci vatenguluke ku vupi vuavo nakuvambuitika. ");
INSERT INTO nkn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kaha omo Iuano uahete muyehi nakumanesa vipangi viendi, uehuile vantu nguendi, ‘Musinganieka ngueni Yange iya? Keti yange uje muli na kuvandamena. Vuno honi ivuilileni! Alinakuija munima yange, yange kunjasa cipue kuzitula miva ya vinkaku viendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Vavushoko vange vaka Isaleli vatekuilila va Avilahama, kaha neni voshe keti Vayunda yeni mulikuno vaka kulemesa Njambi: muzimbu ou uakuovoka vanautumu kuli yetu! ");
INSERT INTO nkn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Omuo vantu vaje valinakuyoya mu Yelusalema na vakuluntu omuo kuvatantekeyele ngeci ikeye napu muyoyesi, cipue kuivuisisa mezi a tunanguizi va Njambi va Njambi aje avakatanda ha litangua na litangua lioshe lia Sapalalo, cipue ngoco valingisile mezi a tunanguizi va Njambi va Njambi kupua a vusunga mukuhana Yesu mulonga. ");
INSERT INTO nkn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Cipue ngocovene kuvauanene vukaleho ngeci vamuhatuile mulonga ua kutsa, vuno honi valombele Pilato linga amutsihe. ");
INSERT INTO nkn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kaha omo valingile vioshe vije ngue muviahandeka visoneka hali ikeye, vamuhumisile ha cilindakano na kumuhaka mu cihilo. ");
INSERT INTO nkn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Vuno honi Njambi uamusanguile ku vatsi, ");
INSERT INTO nkn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kaha ha matangua amengi ualisholuele kuli vaje uendele navo kuhuma ku Ngalileya nakuheta ku Yelusalema. Vakevo honi vanapu vakaleho vendi kuli vantu va Isaleli. ");
INSERT INTO nkn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Yetu tulikuno naku minehela Muzimbu Uacili, uje Njambi uakulahesele vakukuluila vetu kuvilinga, ");
INSERT INTO nkn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","vikevio natulingila yetu vatekuluila vavo mukusangula Yesu ku muono ngue muvanasoneka mu livulu lia mucivali lia Miaso ngualio, ‘Yove unapu u munange, litangua lia lelo njinapu nji Isho.’ ");
INSERT INTO nkn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kaha eci cikeco cahandekele Njambi hakumusangula ku vatsi nguendi kakapolela mu cihilo kuahi, ‘Njikakuhana vivesikiso via kulela via vusunga vije njakulahesele Ndaviti.’ ");
INSERT INTO nkn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ngue muanahandeka naua mu mikanda yeka nguendi, ‘Kukatava ngamba yove uakulela linga apole mu cihilo.’ ");
INSERT INTO nkn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kaha omo Ndaviti uapangele cizango ca Njambi ha ntsimbu yendi vavenia, kaha uatsile, vamutsindile na vakukuluila vendi, kaha muvila uendi uavolele mu cihilo. ");
INSERT INTO nkn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Vuno honi kuli uje yasanguile Njambi ku vatsi muvila uendi kuuapolelele mu cihilo. ");
INSERT INTO nkn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kaha yeni voshe vavushoko vange vaka Isaleli munapande kutantekeya ngeci kuhitila muli Yesu mukemuo vali nakuambulula muzimbu uaku sambuesa ca vipi. ");
INSERT INTO nkn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kaha muapande kutantekeye ngeci uoshe uje atsiliela muli Yesu nazituka ku vipi, Njambi amupuisa kupua ua vusunga ku viuma vioshe vije Lishiko lia Mosesa ku liasele kumupuisa ua vusunga. ");
INSERT INTO nkn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Zangameni linga vije vivahandekele Tunanguizi keti vilingiue kuli yeni. ");
INSERT INTO nkn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Taleni yeni vaka kusembulula, kaha likomokeleni na kutsa! Omuo cuma cije njikalinga mu matangua eni cikapua cuma cije kumukatsiliela, cipue vamilumbunuineco!’” ");
INSERT INTO nkn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Omo Paulu na Mbanambase vahumine mu njivo ya malombelo ya Vayunda, vantu vavalaniene naua kuhiluka kuli vakevo ha litangua lia Sapalalo likuavo nakuvaleka viuma evi. ");
INSERT INTO nkn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Omo vantu vahumine kuje ku njivo ya malombelo ya Vayunda, Vayunda vavengi na vaje keti Vayunda vaje vapuile va kulongua ku futisi ya Vayunda vakavele Paulu na Mbanambase. Kaha vahandekele kuli vakevo nakuvatakamesa kukakateya ha kuyoya mu kavumbi ka Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kaha lia Sapalalo yakaveleho vantu vavandende lika vasalele mu nganda omuo voshe vezile mukuivua lizi lia Muene. ");
INSERT INTO nkn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Omo Vayunda vamuene civunga, vakele nacipululu, valuisile vije viakele nakuhandeka Paulu nakumutukanga. ");
INSERT INTO nkn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Vuno honi Paulu na Mbanambase vahandekele nakusimpa nguavo, “Capandele ngue lizi lia Njambi valihandeke kuli yeni ha kulivanga. Vuno honi mualivianene, kaha munalisinganieka yeni vavenia ngueni kumuafuililile kutambula muono uayaye, kaha tumiseza nakuya kuli vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Omuo eli likelio Lishiko lianatushiki Muene nguendi, “‘Njinamipuisa ceke kuli ava keti Vayunda, ngeci vaka mafuti voshe vakovoke.’” ");
INSERT INTO nkn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Omo vaje keti Vayunda vuovuile evi, vavuahelele nakulemesa lizi lia Muene, kaha vaje vavahanguile kupua na muono uayaye vatsilielele. ");
INSERT INTO nkn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kaha lizi lia Muene liashandokelele kuoshe mu lifuti lije. ");
INSERT INTO nkn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Vuno honi Vayunda vashongangeyele vantuama va mu nganda, nava vampuevo vakutsimana vaje keti Vayunda vaje vakulongua vaka kulemesa Njambi. Kaha vaputukile kupakesa Paulu na Mbanambase nakuvasheka mu lifuti liavo. ");
INSERT INTO nkn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Vuno honi tunganda vatotomuene likungu ku viliato viavo kupua cihiso ca vantu va kuje, kaha vaile ku Ikoniyame. ");
INSERT INTO nkn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kaha vandongisi mu Antioke vashulile nakuvuahelela na Cimbembesi Uakulela. ");
INSERT INTO nkn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Cuma cimolika calingiuile mu Ikoniyame, muje Paulu na Mbanambase vaile mu njivo ya malombelo ya Vayunda vahandekele mu ngila ije yanehesele ngeci civunga cakama ca Vayunda na Vangelengu linga vatsiliele. ");
INSERT INTO nkn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Vuno honi Vayunda vaje vakakuhona kutsiliela vashongangeyele vaje keti Vayunda nakuluisa vaka kutsiliela. ");
INSERT INTO nkn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kaha Paulu na Mbanambase vakele kuje ntsimbu yalaha, vahandekele nakusimpa hali Muene, uje uasholuele ngeci muzimbu uavo ua kavumbi uapuile ua vusunga mukuvahana nzili ya kulinga vitantekeso na vikomoueso. ");
INSERT INTO nkn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vuno honi vantu va muje mu nganda valitepele, vamo vemanene na Vayunda, vakuavo vemanene na tunganda. ");
INSERT INTO nkn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kaha Vayunda na vaje keti Vayunda hamo na vakuluntu vavo, valitavasanene kuyandesa tunganda nakuvasha mavue. ");
INSERT INTO nkn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kaha omo tunganda vanangukile eci, vateuelele ku Lisitala na ku Ndemba vinganda via mu Likaoniya na ku mitambela yakuhatako. ");
INSERT INTO nkn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kaha kuje vambuluile Muzimbu Uacili. ");
INSERT INTO nkn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mu Lisitala muakele yala umo uje uapuile cilema ua mikono hume ha kusemuka cendi kasele kuenda. ");
INSERT INTO nkn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Uatumamene kuje nakuivua mezi a Paulu, Paulu uamuene ngeci natsiliela, kaha asa ku kanguka nankuma uamutalele ntoma. ");
INSERT INTO nkn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kaha Paulu uatambekele na lizi liakama nguendi, “Katuka uimane na mikono yove!” Kaha uje yala uatumbukile nakuputuka kuenda. ");
INSERT INTO nkn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Omo civunga camuene vije Vialingile Paulu, vaputukile kutambeka mu ndaka yavo ya Cilikaoniya nguavo, “vanjambi vaneja kuli yetu mu cifua ca vuntu!” ");
INSERT INTO nkn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kaha valukile Mbanambase lizina nguavo Zeyase, naua lizina lia Paulu nguavo Helemese, omuo ikeye uapuile mukuluntu uakuhandeka. ");
INSERT INTO nkn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kasasendote ua Zeyase uje njivo yendi yakulemesela yakele hambanza lia nganda, uanehele vangombe va vankomba na vitsani ku cikolo, omuo ikeye na vaje vivunga vatondele kukombelela nkombelo ku tunganda. ");
INSERT INTO nkn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Vuno honi omo Mbanambase na Paulu vovuile vije vatondele kulinga, vatavozuele vizalo viavo nakushatukila mukati ka civunga nakutambeka nguavo, ");
INSERT INTO nkn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Vika muli nakulingila cuma eci? Netu tunapu vantu ngeci yeni! Tulikuno mukuambulula Muzimbu Uacili, nakumitengulula ku viuma viangoco ngeci muije kuli Njambi ua kuyoya, uje uatangele lilu na mavu na mema a kalunga na vioshe vilimo. ");
INSERT INTO nkn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ku miaka ya vakukuluila vetu uatavesele vantu voshe linga vaye mu vingila viavo vavenia. ");
INSERT INTO nkn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Vuno honi ha ntsimbu ije uahanene vukaleho vuakukala cendi vavienia ha viuma via cili, kaha akamihana kalunga na vimbuto ha ntsimbu yavio, akamihana via kulia nakushulisa mitima yeni nakuvuahelela.” ");
INSERT INTO nkn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Cipue ngocovene na mezi aua a tunganda kuvasele kuvindika civunga kukombelela nkombelo kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Vuno honi Vayunda vamo vahuminine ku Antioke mu Pisindiya naku Ikoniyame vashongangeyele vivunga kaha vashele mavue Paulu nakumukokela hambaza ya nganda omo vayonguele nguavo hamo natsi. ");
INSERT INTO nkn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Vuno honi omo vandongisi vamuzengelekele, uahindukile nakuimana nakuhilukila mu nganda. Kaha liamukuavo ikeye na Mbanambase vaile ku Ndemba. ");
INSERT INTO nkn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Omo Paulu na Mbanambase vambuluile Muzimbu Uacilil mu Ndemba, kaha vauauanene vandongisi vavengi. Kaha vahilukile ku Lisitala na ku Ikonoyame noho vahete ku Antioke, mu Pisindiya. ");
INSERT INTO nkn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vakolesele vandongisi nakuvatakamesa ngeci vapue vaka vusunga mukutsiliela, vavalongesele nguavo, “Tuapande kuhita mu tuyando tuatuingi ngeci tukovele mu vumuene vua Njambi.” ");
INSERT INTO nkn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mu cikungulukilo na cikungulukilo vemikilemo vankulutu, kaha na malombelo na kuli kela kulia vavakundikile kuli Muene uje ivatsilielelele. ");
INSERT INTO nkn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kaha omo vahete mu mutambela ua Pisindiya, vezile ku Pampaliya, ");
INSERT INTO nkn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","kuje vambuluile lizi ku Pelenga, kaha vasikumukile ku Ataliya. ");
INSERT INTO nkn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kaha kuhuma kuje vajavukile mu vuato nakuhiluka ku Antioke ku mutambela uje vavakundikile kukavumbi ka Njambi ku vipangi vije vinamanesele ku linga ha ntsimbu ije. ");
INSERT INTO nkn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Omo vahete mu Antioke vakunguilile hamo vantu vaka cikungulukilo nakuvaleka viuma vije via lingile Njambi, muje mua shokololuele ngila kuli vaje keti Vayunda ngeci vatsiliele. ");
INSERT INTO nkn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kaha vakele kuje ntsimbu yalaha na vandongisi. ");
INSERT INTO nkn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Vuno honi vamala vamo vahumine ku Yundeya vaile ku Antioke vaputukile kulongesa vaka kutsiliela nguavo, “Kumuasa kuovoka kuvanga mutuhuke ngue kuya ku Lishiko lia Mosesa.” ");
INSERT INTO nkn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kaha Paulu na Mbanambase vakele na vimpata cikuma na vakevo ha cuma eci, vasinganiekele ngeci Paulu na Mbanambase na vamo veka vantu va mu Antioke vaye ku Yelusalema nakuliuana na tunganda na vakuluntu vamu nganda ije. ");
INSERT INTO nkn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nankuma, cikungulukilo ca vatumine, kaha omo vahitile mu Fonisiya na mu Samaliya, kaha valumbunuine muje vati vaje keti Vayunda vatengulukilile kuli Njambi, ou muzimbu uanehele kuvuahelela cikuma kuli vaka kutsiliela voshe. ");
INSERT INTO nkn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kaha omu vahete Yelusalema, vavatambuile ku cikungulukilo na tunganda na vakuluntu, kaha valimbunuine vuoshe vije valingile Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Vuno honi vakakutsiliela vamo vaje vakundamene ku civunga ca Vafaliseo vakatukile nakuhandeka nguavo, “Vaje keti Vayunda vanapande kulovoka nakuvaleka ngeci vononoke Lishiko lia Mosesa.” ");
INSERT INTO nkn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tunganda hamo na vakuluntu vakungulukile na nakusinganieka cihula eci. ");
INSERT INTO nkn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kaha omo vahandekele ntsimbu yalaha, Petulu uakatukile nakuhandeka kuli vakevo nguendi, “Vakakutsiliela muatantekeya hume laja Njambi uahanguile yange hhakati keni na kuambulula Muzimbu Uacili kuli vaje keti Vayunda ngeci vovue na kutsiliela. ");
INSERT INTO nkn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Njambi uje atantekeya visinganieka via muntu uoshe, uamuesele vukaleho vuendi kuli vaje keti Vayunda hakuvahana Cimbembesi Uakulela, ngue muje muatuhanene yetu. ");
INSERT INTO nkn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kaha kamonesele kahangu hhakati kavo netu, vuno honi uavasambesele ku vupi vuavo omo vatsilielele. ");
INSERT INTO nkn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kaha honi vika muesekela Njambi nakutuika citeli ha miongo ya vandongisi cije cipue vakukuluila vetu cipue yetu kutuasa kucambata. ");
INSERT INTO nkn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tutsiliela na kuovoka ha kavumbi ka Muene Yesu, ngue vakevo naua.” ");
INSERT INTO nkn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kaha civunga coshe ca vantu vaholokele kulu omuo vovuile Mbanambase na Paulu valumbununa vitantekeyeso na vikomoueso vije vialingile Njambi muli vakevo hali vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Omo vamanusuile kuhandeka vioshe, kaha Yakomba uahandekele nguendi, “Vavusamba njivuilileni! ");
INSERT INTO nkn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ahavene natulumbunuina muje vati Njambi hakulivanga uahakelele mana kuli vaje keti Vayunda mukuhangulaho vamo hhakati kavo ngeci vapue vantu vendi. ");
INSERT INTO nkn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Vihandeka via tunanguizi va Njambi va Njambi via litombola muacili na viuma evi. Ngue muje muviendeka visoneka, ");
INSERT INTO nkn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kaha Muene Njambi alinakuhandeka Nguendi, munima ya viuma evi njikeluka nakuiluisa naua vumuene vua Ndaviti njikavutungulula nakuvukolesa naua. ");
INSERT INTO nkn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kaha vantu voshe vakeja kuli yange, voshe vaje keti Vayunda vaje vanjikana kupua vange. ");
INSERT INTO nkn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kaha omu mukemuo mualinakuhandekela Muene, uje uasholuele viuma vioshe kusankulu.’ ");
INSERT INTO nkn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakomba uahandekele nguendi “Muvisinganieka viange,” nguange, “kutua kupesa vaje keti Vayunda vaje vanatengulukila kuli Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vuno honi tunapande kuvasonekela mukanda uakuvaleka nguetu keti valie viakulia via kujeneka kulela omo vanavikombelela ku tumponia nakulitenga kuvupangala, kaha naua keti valie tusitu tua kutikinia cipue kulia maninga. ");
INSERT INTO nkn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kuhuma kuntsimbu ya laja Lishiko lia Mosesa valitanda muvi njivo via malombelo via Vayunda ha litangua lia Sapalalo, kaha naua mezi endi va ambulula mu vinganda vioshe.” ");
INSERT INTO nkn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kaha tunganda na vakuluntu hamo na cikungulukilo coshe vasinganiekele kuhangula vantu vamo, vahanguile vamala ku civunga cavo ngeci vavatume ku Antioke hamo na Paulu na Mbanambase. Vahanguile naua vamala vavali vaje vavasingimikile cikuma vaka kutsiliela, Yundasa ivasanene Mbalambase na Silasi. ");
INSERT INTO nkn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kaha vavatumine hamo na mukanda uakuya kuli vakevo nguavo, “Vakuetu yetu tunganda na vakuluntu, tunatumu vihindu vietu kuli yeni voshe vakuetu vaje keti Vayunda ku cisemua vaje muakala mu Antioke na mu Silisha. ");
INSERT INTO nkn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tunevu nguavo vamo vamala vamu civunga cetu vaneja na nakumitanganesa na vije vivanahandeka vakevo kuvatambuile vilongesa viakuhuma kuli yetu. ");
INSERT INTO nkn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaha tualikunguluile nakulitavasana tu vavoshe kuhangula vamo vamala nakuvatuma kuli yeni. Hamo na vavusamba vetu vatuazangele cikuma Mbanambasa na Paulu, ");
INSERT INTO nkn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","vaje vahanene muono uavo mukupangela Muene uetu Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kaha tunatumu Yundasa na Silasi vaje vakamileka viuma vimo vije vituli na kusoneka. ");
INSERT INTO nkn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Omo Cimbembesi Uakulela hamolika netu tualitavasana ngeci kutuapandele kumituika citeli ceka lelo kuvanga lika mashiko aua nguetu, ");
INSERT INTO nkn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Keti mulie viakulia vije viakukombelela ku tumponia, keti munue maninga, keti mulie kasitu uakutikinia, kaha litengeni ku vupangala, mukakala muacili nga muliniunga kuakuhona kulinga viuma evi, vihindu vieni.” ");
INSERT INTO nkn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kaha vaje vavatumine vasikumukile ku Antioke kuje vakakunguluile civunga coshe ca vaka kutsiliela nakuvahana uje mukanda. ");
INSERT INTO nkn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kaha omo vantu muvatandele uje mukanda vavuahelelele cikuma ha muzimbu uakuvasimpisa. ");
INSERT INTO nkn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kaha Yundasa na Silasi vaje vapuile tunanguizi va Njambi va Njambi, va vasimpisile nakuvatakamesa cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Omo vakele navo kuje ha ntsimbu imo, kaha vaka kutsiliela vavahiluisile kuli vaje vavatumine nakuhandeka kuli vakevo nguavo endeni mu ciyulo. ");
INSERT INTO nkn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kaha Silasi uasinganiekele kukala kuje. ");
INSERT INTO nkn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Vuno honi Paulu na Mbanambasi vasalele mu Antioke, hamolika na vakuavo veka vavengi valongesele na kuambulula Muzimbu Uacili ua Muene. ");
INSERT INTO nkn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ha ntsimbu imo Paulu uahandekele kuli Mbanambase nguendi, “Tuye tuhiluke linga tukameneke vakakutsiliela mu vinganda vioshe muje tuambuluile lizi lia Muene, linga tukamone vati muje vali nakuyoya.” ");
INSERT INTO nkn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kaha Mbanambase uatondele kuambata Iuano uje ivatumbuile Mako, linga vaye nendi. ");
INSERT INTO nkn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Vuno honi Paulu uasinganiekele nguendi keti cacili kuya nendi, omuo kakele hamo navo mukumanesa vipangi, vuno honi uahilukile nakuvaseza mu Pampaliya. ");
INSERT INTO nkn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hakele vimpata, kaha valitepele Mbanambase uambate Mako nakuya ku Sepulasi na vuato. ");
INSERT INTO nkn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Vuno honi Paulu uahanguile Silasi nakuya nendi, vamutavesele kuli vaka kutsiliela kuhitila mu kavumbi ka Muene. ");
INSERT INTO nkn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Omo vaile vahitile mu silia namu Silisha mukukolesa vikungulukilo ");
INSERT INTO nkn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Kaha Paulu uahete naua ku Ndemba na kuli Lisitala, kuje kuakele mukua Yesu umo lizina liendi Timateo. Vaina navakevo vapuile vakua Yesu vaje vapuile Kayunda, vuno honi ishe uapuile Kangelengu. ");
INSERT INTO nkn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kaha voshe vaka kutsiliela vamu Lisitala na mu Ikoniyame vashangazalele cikuma Timoteo. ");
INSERT INTO nkn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Kaha Paulu uatondele kuya na Timoteo, kaha uamutuhuisile. Ualingile vioshe evi omuo Vayunda voshe vaje vakele mu mitambela ije vatantekeyele ngeci ishe ya Timoteo uapuile Kangelengu. ");
INSERT INTO nkn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Omo vakele nakuhita mu vinganda, vahanene vakakutsiliela mashiko aje avasinganiekele tunganda na vakuluntu mu Yelusalema, kaha vavalekele linga vononoke aje mashiko. ");
INSERT INTO nkn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Vikungulukilo viakele na nzili mukutsiliela kaha valivuezelele ha litangua na litangua. ");
INSERT INTO nkn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kaha vahitile mu mutambela ua Filingiya na mu Ngalatiya omuo Cimbembesi Uakulela cavavindikile kuambulula muzimbu mu nganda ya Asiya. ");
INSERT INTO nkn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kaha omo vahete ku nginga ya Misiya vesekele kuya mu lifuti lia Mbitaniya, vuno honi Cimbembesi ca Yesu kucavatavesele. ");
INSERT INTO nkn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kaha vahitile mukati ka Misiya nakuya ku Tolouase. ");
INSERT INTO nkn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kaha ku vutsiki vuje vene Paulu uamuene cimona muje uamuene yala umo ua ku Masendoniya nemana nakumulomba nguendi, “Ija kuno ku Masendoniya uakutukuase.” ");
INSERT INTO nkn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kaha omo Paulu uamuene eci cimona, hajevene tuakatukile nakuya ku Masendoniya, omuo tuasinganiekele nguetu Njambi natusana mukuambulula Muzimbu Uacili kuli vantu kuje. ");
INSERT INTO nkn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Omo tuahumine ku Tolouase tuajavukile mu vuato nakuya ku Samotalase, kaha lia mukuavo tuaile mu Neyapolise. ");
INSERT INTO nkn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kaha kuhuma kuje tuahile ku Filipu, nganda yamutambela uakulivanga mu lifuti lia Masendoniya, ikeyo naua yapuile nganda ya Loma kaha tuakele muje mu nganda matangua amengi. ");
INSERT INTO nkn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kaha lia Sapalalo tuakatukile mu nganda tuaile ku ngenga ya ndonga kuje tuayonguele nguetu kuli mutambela uakukungulukila mukulombela. Kaha tuatumamene nakusikama na vampuevo vaje vakungulukilili kuje. ");
INSERT INTO nkn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kaha umo uavo uatuvuile uapuile Lindiya uahumine ku Tiyatile uapuile mukakulandesa vintanga viacili viakuvenguluka naua uapuile mpuevo ua kulemesa Njambi, kaha Muene uashokoluele mutima uendi kukuivuilila ku vije viakele nakuhandeka Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kaha omo vamumbuitikile ikeye na vantu vamu njivo yendi, kaha uatulaniene nguendi, “Ijeni mukakale mu njivo yange nga muasinganieka ngueni njinapu muka kutsiliela muli Muene.” Nankuma uatusindiile linga tuye. ");
INSERT INTO nkn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ha litangua limo omo tuakele nakuya ku muhela uakulombelela, tualiuanene na ngamba ua mpuevo uje uakele na Cimbembesi cakujuala uje uakele nakumupangesa mukumona viuma via kulutue. Kaha uapitisile cikuma muene uendi mukuhandeka viuma viacili vije vikalingiua kulutue. ");
INSERT INTO nkn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ou mpuevo uakavele Paulu hamo netu kaha uatambekele nguendi, “Ava vamala vanapu vangamba va Njambi Uahelu lia Vioshe! Vali nakuambulula kuli yeni ngila ya kuovoka!” ");
INSERT INTO nkn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nankuma ualingile eci matangua amengi, vuno honi Paulu uapililihile, kaha uatengulukile nakuhandeka kuli uje Cimbembesi nguendi, “Mu lizina lia Yesu Kilistu njikushika nguange huma muli ikeye!” Kaha hajevene Cimbembesi cahumine muli uje mpuevo. ");
INSERT INTO nkn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Omo liavenia uje ngamba uevuile nguendi uje mpuevo ngila ya kupangelamo vimbongo inahu, vakuate Paulu na Silasi nakuvakokangeya nakuvatuala hambanza kuli vakakusuana ku muhela uakulandesela. ");
INSERT INTO nkn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kaha vavatualele ku mesho a vakuluntu Valoma nakuhandeka nguavo, “Ava vamala vanapu Vayunda, kaha valinakuneha vukalu mu nganda yetu. ");
INSERT INTO nkn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Vali nakulongesa futisi ije iluisa Lishiko lietu, yetu tu Valoma, kaha kutuasa kutava futisi yavo cipue kuyikava!” ");
INSERT INTO nkn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kaha civunga coshe calitavasanene kuluisa Paulu na Silasi. Kaha honi vaje vakuluntu vatavozuele vizalo via Paulu na Silasi. Nakushika ngeci vavapupe. ");
INSERT INTO nkn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kaha omo vavapupile cikuma, vavahakele mu kamenga, kaha vashikile cikuma muka kuniunga kamenga ngeci apate cikuma ku vikolo. ");
INSERT INTO nkn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Omo uje muka kuniunga kamenga uatambuile Lishiko eli, kaha uavahakele mukati ka mulili ua kamenga nakuhaka mikono yavo mu vikuali. ");
INSERT INTO nkn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Vuno honi mukati kavuntsiki Paulu na Silasi vakale nakulombela nakuimba miaso ya Njambi, kaha vaje vinzinda vakele mu kamenga vavevuilile. ");
INSERT INTO nkn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hajevene kuakele mandunduma akama cikuma kaha luvula lua kamenga luajajele cikuma. Kaha hajevene vikolo via kamenga viashokolokele, kaha malienge ahumine kuli vinzinda voshe. ");
INSERT INTO nkn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Omo uje mukakunianga kamenga uahindukile, kaha omo uamuene vikolo via shokoloka, uasinganiekele nguendi, vinzinda voshe vanateue, kaha uashomuene mukuale uendi linga alitsihe. ");
INSERT INTO nkn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kaha Paulu uatambakanene cikuma na lizi liakama nguendi, “Keti ulitsihe! Omuo tuvavoshe mutuli muno!” ");
INSERT INTO nkn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kaha uje mukakuninga kamenga uasanene ngeci vamuneheleko ndeya, kaha uashatukillilemo, kaha uatsikamene ku mikono ya Paulu na Silasi oku ali nakujaja. ");
INSERT INTO nkn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kaha uavatuhuile hambanza nakuvehula nguendi, “Muene, vika njasa kulinga linga njovoke?” ");
INSERT INTO nkn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kaha vamukumbuluile nguavo, “tsiliela kuli Muene Yesu, kaha ukovoka, yove na ntanga yove yoshe.” ");
INSERT INTO nkn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kaha vambuluile lizi lia Muene kuli ikeye na kuli voshe vaje vakele mu njivo yendi. ");
INSERT INTO nkn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kaha ha ntsimbu ijevene ya vutsiki uje mukakuniunga kamenga uaile navo, kaha uakushile ha vimbandu viavo, kaha hajevene ikeye na ntanga yendi voshe vavambuitikile. ");
INSERT INTO nkn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nankuma, uatualele Paulu na Silasi ku njivo yendi, kaha uakavahanene viakulia. Kaha ikeye na ntanga yendi vavuahelele cikuma, omuo vatsilielele muli Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kaha liamukuavo cimenemene vakuluntu Valoma vashikile vantuama masualale nguavo, “Eceleni ava vamala vaye.” ");
INSERT INTO nkn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kaha uje muka kuniunga kamenga ualekele Paulu nguendi, “Vakuluntu Valoma vanashiki lizi kuli yove na kuli Silasi nguavo tumiecele. Muasa kuya, kaha yeni mu ciyulo.” ");
INSERT INTO nkn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Vuno honi Paulu uahandekele kuli vaje vankuluntu vamasualale va kamenga nguendi, “Kuvatuuanene na mulonga, vuno honi vanatupupilile ku mesho a vantu kuakuhona kutusompesa, cipuevene yetu tuapua vandambo va lifuti lia Loma! Kaha vanatuhakele mukamenga. Kaha vuavuno vatonda kutuecela mu vushueke indi? Vakuluntu Valoma vanapande kuija kuno vakutuecele vakevo vavenia linga tuye.” ");
INSERT INTO nkn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kaha vantuama vamasualale vambuluile mezi aua kuli vankulutu Valoma, kaha omo vovuile ngeci Paulu na Silasi vapuile vandambo va lifuti lia Loma, kaha vovuile liova. ");
INSERT INTO nkn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kaha vaile kuli vakevo nakulomba cikonekelo, kaha honi vavahumisile mu kamenga, kaha vavalombele linga vahume mu nganda ije. ");
INSERT INTO nkn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Omo Paulu na Silasi vahumine mu kamenga, vaile ku njivo ya Lindiya. Kuje vakaliuanene na vaka kutsiliela, kaha vahandekele kuli vakevo mezi akuvasimpisa, kaha vaile. ");
INSERT INTO nkn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulu na Silasi omo vaile vahitile mu Afipolise na mu Apoloniya, kaha vezile ku Tesalonika, kuje kuakele njivo ya malombelo ya Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kaha ngue ku cilika cendi Paulu, uaile mu njivo ya malombelo ya Vayunda ha matangua atatu a Sapalalo uakele nakuhandeka na vantu nakuvaleka, ");
INSERT INTO nkn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nakuvalumbunuina visoneka, nakuvamuesa vukaleho vua kuhuma mu visoneka ngeci Kilistu napande kuyanda nakusanguka ku vatsi. Kaha Paulu uahandekele nguendi, “Ou Yesu njihandeka kuli yeni ikeye vene Kilistu.” ");
INSERT INTO nkn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kaha vamo hhakati kavo vatsilielele, kaha valipandakanene na Paulu na Silasi hamo na vampuevo vaje vapuile vantuama na civunga cakama ca Vangelengu vaje vakakulemesa Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Vuno honi Vayunda vakele na cipululu, kaha vakunguluile vamo viendangane va mihuza mu vitapalo, kaha vapangele civunga. Vanehele citanga cakama muje mu nganda yoshe, kaha valuisile njivo ya Njasone mukueseka kuuana Paulu na Silasi linga vavatuale ku civunga ca vantu. ");
INSERT INTO nkn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Vuno honi omo kuvavauanene, vakokangeyele Njasone na vamo vaka kutsiliela nakuvatuala kuli vakuluntu va nganda kaha vatambakanene nguavo, “Ava vamala vananeha vukalu mu lifuti lioshe kaha vaneja kuno, ");
INSERT INTO nkn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","kaha Njasone uavatambuile mu njivo yendi. Voshe valinakupokola mashiko a Sezale nakuhandeka nguavo kuli muene ueka naua lizina liendi Yesu.” ");
INSERT INTO nkn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kaha ha mezi aua vanehele citanga cakama ku civunga na kuli vakuluntu va nganda. ");
INSERT INTO nkn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kaha vakuluntu va nganda vafuetesele Njasone na vakuavo vimbongo vije viatondekele linga vavecele vaye. ");
INSERT INTO nkn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hajevene omo vutsiki vuezile vaka kutsiliela vatumine Paulu na Silasi ku Mbeleya. Omo vahete kuje vaile mu njivo ya malombelo ya Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Vayunda vakuje vapuile va ceke kupulakana vaku Tesalonika. Vakele nakuivuilila ku lizi na mitima yakuzituka kaha ha litangua na litangua vakele nakutanda mu visoneka linga vamone vije viandekele Paulu indi via vusunga. ");
INSERT INTO nkn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kaha vuingi vua Vayunda vatsilielele, kaha na vampuevo vamo vavengi va vakuluntu va Vangelengu na vamala vamo vavengi va Vangelengu vatsilielele navo. ");
INSERT INTO nkn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Vuno honi omo Vayunda vaku Tesalonika vatantekeyele nguavo Paulu nambulula lizi lia Njambi mu Mbeleya vaile kuje naku shongangeya civunga. ");
INSERT INTO nkn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kaha hajevene vaka kutsiliela vatumine Paulu ku cikuma ca mema a kalunga, vuno honi Silasi na Timateo vasalele mu Mbeleya. ");
INSERT INTO nkn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Kaha vamala vasindikiile Paulu vaile nendi kuvanga naku Atena kaha vahilukilile ku Mbeleni, kaha Paulu uavashikile nguendi Silasi na Timateo vanapande kumukavangeye vuasi vuasi. ");
INSERT INTO nkn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Omo te Paulu uakele nakuvandamena Silasi na Timateo mu Atena, uanienguele cikuma omo uamuene muje mu nganda muashulile tuponia tuatuingi cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kaha muje mu njivo ya malombelo ya Vayunda uahandekele na Vayunda na vaje keti Vayunda vaje vaka kulemesa Njambi, kaha ha litangua na litangua uakele nakuhandeka na vaje vakele nakuliuana navo ku cihela cakulandesela. ");
INSERT INTO nkn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vamo valongisi va civunga civatumbula nguavo Epikuliu na civunga ca Sitoike valingile vimpata nendi, kaha vamo vamuhuile nguavo, “Vika atonda kuhandeka ou cilema uakulihalesa?” veka vahandekele nguavo, “Kumoneka ngue ali nakuhandeka vanjambi veka naua.” Vahandekele evi omo Paulu uakele nakuambulula via Yesu na cisangukilo. ");
INSERT INTO nkn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kaha vamuambate nakumutuala ku mpunga ya nganda ya Alapangase nakuhandeka nguavo, “Tutonda kutantekeya eci cuma caciha ciuli nakulongesa. ");
INSERT INTO nkn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Omo vimo viuma tuli nakuivua uhandeka vinapu viavihia kuli yetu, kaha tutonda kutantekeya muvialumbunukila.” ");
INSERT INTO nkn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Omo vaka Atena voshe na vangezi vakele muje vatondele kupihisa ntsimbu yavo yoshe mukuhandeka na kuivua viuma viavihia.) ");
INSERT INTO nkn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kaha Paulu uemanene ha lutue lua mpunga ya Alepangase nakuhandeka nguendi, “Yeni vantu vamu Atena, njamono nguange mu vilinga vieni vioshe munapu mu vaka kulemesa. ");
INSERT INTO nkn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Omuo njakele nakuenda mu nganda yeni nakutala muacili mutambela mukalemesela, njauanene ha mutula uasonekele nguavo, ‘Kuli Njambi uje kututantekeya.’ Cije mukalemesa cipue ku mucitantekeya cikeco njilinakuambulula kuli yeni lelo. ");
INSERT INTO nkn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Njambi uje uatangele lifuti na vuoshe via kalamo, uapua Muene ua Melu na Mavu, kaha kekuyoya mu njivo yakutunga ku mavoko a vantu. ");
INSERT INTO nkn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Cipue kekutonda linga tumupangele cipue cuma cimo, omuo ikeye akahana muono na mpunzi ije ituhuima na viuma vioshe kuli vantu voshe. ");
INSERT INTO nkn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kaha uatangele mihati yoshe kuhuma kuli yala umo ngeci vakale ha mavu oshe. Ikeye vavenia uavuahesele laja vintsimbu na vinginga na vihela kuje vaka yoyela. ");
INSERT INTO nkn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ualingile eci linga vamutonde, kaha omo vakamutonda hamo vaka muuana. Vuno honi cipue ngoco Njambi kakele kulako netu kuahi, ");
INSERT INTO nkn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ngue umo uahandekele nguendi, ‘Muli ikeye mu kemo mutuayoyela, mukemuo mutuendela mukemuo mutuli.’ Ngue muihandeka miaso yeni imo nguayo, ‘Netu naua tunapu tu vana vendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kaha hakupua tuvana vendi, kutuapandele kusikanieka nguetu Njambi uapua ngue cifua ca Ngolinde cipue ca Siliva indi cipue livue lia kushonga na vutongue na mana a muntu. ");
INSERT INTO nkn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Laja Njambi uakele nakutalelela vantu omo kuvamutantekeyele, kaha hanohoni alinakushika vantu voshe kuoshe linga vatenguluke ku vupi vuavo. ");
INSERT INTO nkn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Omuo nalivuahesela laja litangua lije akasompa lifuti lioshe kuakuhona kahangu kuhitila muli yala uje yanahangula. Kaha ha cuma eci nahana vukaleho kuli muntu uoshe hakusangula yala uje ku vatsi!” ");
INSERT INTO nkn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Omo vovuile Paulu ahandeka kusanguka ku vatsi, vamo vamushendumuine vuno honi vamo vahandekele nguavo, “Tutonda linga tuvue viuma evi naua kuli yove.” ");
INSERT INTO nkn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kaha Paulu uasezele cije cikungulukilo. ");
INSERT INTO nkn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kaha vamo vamala valipandakanene nendi nakupua vaka kutsiliela, hhakati kavo umo uapuile Ndiyonisiyase, uapuile umo ua mpunga ca Elepase, na mpuevo umo lizina liendi Ndamalise, navakuavo veka naua. ");
INSERT INTO nkn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hanima ya viuma evi, Paulu ua humine ku Atena na kuya ku Kolinte. ");
INSERT INTO nkn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kaha kuje ualiuanene na Kayunda ualizina lia Akuila, uje uasemukilile ku Pontase, uje uahuminine ku Itali na mpuevo yendi Pilisila, Omuo Sezale Kalaundiasi uashikile linga Vayunda voshe vahume mu Loma. Kaha Paulu uaile nakuvamona, ");
INSERT INTO nkn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","kaha uatumamene nakupanga hamo navo, omuo uakele nakutunga vimbalaka, ngue muvakele nakulinga vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulu uakele nakuhandeka mu njivo ya malombelo ya Vayunda ha litangua lia Sapalalo lioshe, mukuesaka Vayunda na Vangelengu linga vatsiliele. ");
INSERT INTO nkn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Omo Silasi na Timoteo vahete mukuhuma ku Mbeteseniya, Paulu ha ntsimbu yendi yoshe ualihanene kuambulula muzimbu nakuhana vukaleho kuli Vayunda ngeci Yesu ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Omo vamuluisile nakuhandeka viuma via vipi kuli ikeye, kaha uatotomuene likungu ku vintanga viendi nakuhandeka nguendi, “Nga munazimbala, unapu mulonga ueni vavenia! Yange kujesi namulonga naumo uahi. Kuhuma lelo nakuya kulutue njiya kuli vaje keti Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kaha Paulu uahumine mu njivo ya malombelo ya Vayunda nakuya ku njivo ya yala umo lizina liendi, Tito Yusitasi muka kulemesa Njambi, njivo yendi yalihatela na cikolo ca njivo ya malombelo ya Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kaha Kilisipase uje uapuile ntuama ua mu njivo ya malombelo ya Vayunda uje uatsilielelele kuli muene hamo lika na ntanga yendi yoshe, kaha na vantu vavengi vamu Kolinte vovuile lizi na kutsiliela kaha vavambuitikile. ");
INSERT INTO nkn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kaha vutsiku vumo Paulu uamuene cimona cije Muene uahandekele kuli ikeye nguendi, “Keti uvue liova, vuno honi tualelelaho kuhandeka kaha keti ulikele, ");
INSERT INTO nkn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","omuo yange njili hamo nove. Kaha naumo uahi asa kukuvulumuna, omuo njili na vantu vavengi munganda eyi.” ");
INSERT INTO nkn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kaha Paulu uakele kuje muaka umo na vingonde vitanu na imo, mukulongesa vantu lizi lia Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Omo Ngaliyo uapuile nguvulu ua Loma mu nganda ya Akaya, kaha Vayunda valikunguliuile hamo vakuate Paulu nakumutuala hambanza lia nzango ya kusompela. ");
INSERT INTO nkn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Vahandekele nguavo, “Yala ou alinakusindiya vantu kulemesa Njambi mu ngila ya kuluisa Lishiko!” ");
INSERT INTO nkn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tele Paulu uatondele kuhandeka kaha Ngaliyo uahandekele kuli Vayunda nguendi, “Nga eci cimpande capuile ca mulonga uakuvulumuna cipue via vupi vumo vuanalingi, nge njinevuilila yeni Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Vuno honi omuo cinapu cimpande ca kulivianangana ha mezi na mazina na Lishiko lieni vavenia, munapande kuvimanusula yeni vavenia. Yange kunjapandele kupua lihako ua viuma evi!” ");
INSERT INTO nkn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kaha uavashekele mu nzango ya kusompela. ");
INSERT INTO nkn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kaha voshe vakokangeyele Sosetene, uje uapuile ntuama ua njivo ya malombelo ya Vayunda, vamupupilile ha mesho a nzango yakusompela. Vuno honi Ngaliyo kombileko mutima ku cuma cije. ");
INSERT INTO nkn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Kaha Paulu uakele mu Kolinte hamo na vaka kutsiliela matangua amengi, kaha honi uavasezele uaile mu vuato ku Siliya hamo na Pilisila na Akuila. Tele kanda ahume ku Senkilise Paulu uatehuile ku mutue uendi omuo ya cisingo cije calisingile. ");
INSERT INTO nkn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Omo uahete mu Efeso, kuje Paul uasezele Pilisila na Akuila, uakovelele mu njivo ya malombelo ya Vayunda nakuhandeka na Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Omo vantu vamulombele linga akale navo ntsimbu yalaha, vuno honi kavatavele. ");
INSERT INTO nkn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Vuno honi uavalekele omo uavasezele nguendi, “Nga eci cinapu cizango ca Njambi, kaha njikahiluka naua kuli yeni.” Kaha uakovelele mu vuato nakuhuma ku Efeso. ");
INSERT INTO nkn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Omo uahete ku Sesaliya, uaile ku Yelusalema mukukameneka cikungulukilo, ambahoni uaile ku Antioke. ");
INSERT INTO nkn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Munima yakukala navo ntsimbu imo, uahumineko uaile mu mutambela ua Ngalatiya na mu Filingiya nakukolesa vandongisi voshe. ");
INSERT INTO nkn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ha ntsimbu ije Kayunda umo ua lizina lia Apolo uje uasemukilile mu Alekizandiliya uezile ku Efeso. Uapuile muntu uakuhandeka muacili, kaha uakele na mana akulumbununa visoneka. ");
INSERT INTO nkn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Vamunanguile laja mu Ngila ya Muene, kaha uakele na ntuima yakuambulula nakulongesa muacili cili viuma via hali Yesu. Cipuevene ngoco, vuno honi uatantekeyele lika viakumbuitika kua Iuano. ");
INSERT INTO nkn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Uaputukile kuhandeka nakusimpa mu njivo ya malombelo ya Vayunda. Vuno honi omo Pilisila na Akuila vamuvuile, vamutualele ku njivo nakumunangula muacili cili cikuma Ngila ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Omo Apolo uatondele kuya ku Akaya, kaha vaka kutsiliela va mu Efeso vamukuasele mukusonekela mukanda kuli vandongisi va mu Akaya nakuvalomba ngeci vamutambule muacili. Omo uahele kuje, uapuile mukakukuasa cikuma kuli vaje vapuile vaka kutsiliela ngue ku kavumbi ka Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Omuo ha nzili yendi yakulivianangana uavianene Vayunda muviahandeka viavo citona mesho mukumuesa vukaleho vua mu visoneka ngeci Yesu ikeye Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tele omo Apolo uakele mu Kolinte, Paulu uahitile ku vihela via minkinda via mu mbonge kaha uasikumukilile ku Efeso. Kuje uakauanene vandongisi vamo ");
INSERT INTO nkn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","kaha uahandekele kuli vakevo nguendi, “Muatambuileho Cimbembesi Uakulela omo muapuile vaka kutsiliela ndi?” Vamukumbuluile nguavo, “houe, kanda tuivueho nguavo kuakala Cimbembesi Uakulela.” ");
INSERT INTO nkn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kaha uahandekele nguendi, “Mu cimbuitiko muka va mimbuitikile naco?” Vamukumbuluile nguavo, “Mu cimbuitiko ca muka kumbuitika Iuano.” ");
INSERT INTO nkn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kaha Paulu uahandekele nguendi, “Iuano uambuitikile mu cimbuitikilo cakutenguluka ku vupi, kulekesa vantu linga vatsiliele kuli uje eja munima yendi, uje ikeye, Yesu.” ");
INSERT INTO nkn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Omo vovuile eci, kaha vavambuitikile mu lizina lia Muene Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Omo Paulu uavasalekele mavoko endi, Cimbembesi Uakulela cezile hali vakevo kaha vaputukile kuhanda mu mindaka vieka kaha naua vaputukile kuambulula vunanguizi. ");
INSERT INTO nkn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Voshe vapuile ngue likumi na vavali. ");
INSERT INTO nkn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Uakovelele mu njivo ya malombelo ya Vayunda kaha ha vingonde vitatu uahandekele nakusimpa, nakulambelela cikuma vantu via vumuene vua Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Omo vamo vakukola mitima vavianene kutsiliela nakuhandeka viavipi angila ya Njambi ku mesho ya civunga ca vantu, kaha uavasezele, nakuya na vandongisi uakele nakuhandeka navo mu njivo ya kuli longesela mu Tilanase. ");
INSERT INTO nkn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Eci catualeleleleho ha miaka ivali, linga voshe vantu vamu mbonge ya Asiya, Vayunda na Vangelengu vovue lizi lia Muene. ");
INSERT INTO nkn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Njambi ualingile vikomoueso viavingi kuhitila muli Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Cipue vitambala na vizalo vije viakele nakulikuasesa vavihanene kuli vakakuvavala, kaha na mishongo yoshe yavahumine, kaha na vimbembesi viavipi via humine muli vakevo. ");
INSERT INTO nkn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kaha vamo Vayunda vaje vakele nakuendangana nakuhumisa vimbembesi via vipi mukulikuasesa mukutumbula lizina lia Muene Yesu kuhumisa vimbembesi viavipi. Kaha vakele nakuhandeka kuli vaje vakele navio nguavo, “Njimishika mu lizina lia Yesu uje yali nakuambulula Paulu humamo.” ");
INSERT INTO nkn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vaje vana vatanu na vavali va vamala va Kayunda uje uapuile Mukuluntu ua Kasasendote ivatumbuile nguavo Sikeva, vakevo vakele nakulinga evi. ");
INSERT INTO nkn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Vuno honi Cimbembesi cacipi ca handekele kuli vakevo nguaco, “Yesu njamutantekeya, na Paulu naua njamuivuaho viendi, vuno honi yeni, yeni veya?” ");
INSERT INTO nkn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kaha uje yala uakele na Cimbembesi cacipi uavaluisile, navukalu, nakuvahiana voshe kaha vahumile mu njivo mutotototo na vimbandu. ");
INSERT INTO nkn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Omo eci vacitantekeyele ku vantu voshe vaje vakele Efeso, Vayunda na Vangelengu, kaha muntu uoshe uakele na liova, kaha lizina lia Muene Yesu valilemesele. ");
INSERT INTO nkn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kaha naua vuingi vuavaje vapuile vakakutsiliela vahandekele vupi vuavo na kuambulula vilinga viavo. ");
INSERT INTO nkn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vuingi vua vaje vakele nakulinga matseno vambate mavulu avo na ku atsimika hakati ka civunga, kaha omo vapandakanene vimbongo via aje mavulu viapuile makulukazi a makumi atanu a vimbongo via muuayauaya Siliva (50 0 0 0). ");
INSERT INTO nkn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kaha lizi lia Muene liakolele cikuma nakushandoka. ");
INSERT INTO nkn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hanima ya kulingiua viuma evi, Paulu hakupua mu Cimbembesi uasinganiekele kuya ku Makandonia na ku Akaya kaha nakutualelelaho kuya ku Yelusalema. Kaha uahandekele nguendi, “Munima yakuya kuje, njapande naua kuya ku Loma”. ");
INSERT INTO nkn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kaha uatumine vakuasi vendi vavali, Timateo na Elasitase, ku Makindoniya, te ikeye uacikele mu mbonge ya Asiya ha ntsimbu imo. ");
INSERT INTO nkn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ha ntsimbu ije kuakele mpindangano yakama mu Efeso omuo ya Ngila ya Muene. ");
INSERT INTO nkn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Yala umo ivatumbuile nguavo Ndemetaliase mukakufula viuma via siliva, ualingile cifua ca njivo ya siliva yakulifua ngue njivo ya Atemesi kalunga ua mpuevo, kaha evi vipangi viendi vianehele vimbongo viavingi kuli vaka kupanga. ");
INSERT INTO nkn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Uakunguluile voshe hamolika vakuavo veka vaje vakele navipangi ngue viavo, kaha uahandekele kuli vakevo nguendi, “Yeni vamala, muatantekeya ngueni vufuko vuetu vukahumu ku vipangi evi. ");
INSERT INTO nkn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mu namono kaha munevu naua nguavo keti mu Efeso lika vuno honi na mu mutambela ua mbonge ya Asiya, ou Paulu nakoko vantu vavengi nakuhandeka nguendi tumponia tuakupanga na mavoko keti tulunga. ");
INSERT INTO nkn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kaha kuli vukalu keti lika kundando yetu vuno honi naua na ku njivo yakama ya kamponia ua mpuevo Atemise kuvaihana kalemesa, kaha uoshe muntu ua mu mbonge Asiya na lifuti lioshe uahi akamulemesa!” ");
INSERT INTO nkn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Omo vovuile evi, vanienguele na kutambakana nguavo, “Uakama Atemise uava Efeso!” ");
INSERT INTO nkn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mu nganda muoshe muakele kalua, kaha vantu vashatukilile mu njivo yakuehela kaha vakuate Ngayasie na Alisitakase, vaku makondoniya vavali vaje vapuile nakusindikiya Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulu uazangele kuya ha katati kacivunga, vuno honi vandongisi vamuvindikile, ");
INSERT INTO nkn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","navajevene vakuluntu va mbonge ya Asiya, vaje vapuile vasepa liendi, vamutuminine mezi akumulekesa nguavo keti akovele mu njivo yakuehela. ");
INSERT INTO nkn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ha ntsimbu ije, vamo vakele na kutambakana cuma cimo, vamo cikuavo, kaha civunga cakele namiyoyo na vuingi vavo kuvatantekeyele civali kunguililile. ");
INSERT INTO nkn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Vamo vantu va ha civunga cije vasompesele Alekizanda, uje ivatualele Vayunda kulutue. Kaha Alekizanda uavaholuesele nakueseka kuliohiela hhakati ka vantu. ");
INSERT INTO nkn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Vuno honi omo vatantekeyele nguavo ikeye Kayunda, mu vihola vivali voshe vatambakanene mukulivuasana nguavo, “Uakama Atemise ua va Efeso!” ");
INSERT INTO nkn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Vuno honi omo muka kusoneka ua nganda uaholuesele civunga, uahandekele nguendi, “Vantu va mu Efeso, iya katantekeya nguendi nganda ya Efeso yapua njivo ya kutumbikila Atemisi uakama na kamponia uje uauile kuilu? ");
INSERT INTO nkn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Omuo viuma evi kuviasiua kuviviana muapande kuholoka kaha naua keti mulinge viuma muvuasi. ");
INSERT INTO nkn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Munanehe vantu ava keti ngue vezi va mu njivo ya tumponia cipue nguavo vanashaula kamponia ua mpuevo. ");
INSERT INTO nkn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nga Ndemeteliase na vaka kupanga vendi valinakuvangeyaho umo, vinzango viashokoloka mukuhana ciyulo, kaha tuli naua na vaka nzili yakama vaka kusompesa kaha veceleni vanehe vimpande viavo viakuliluisa vakevo vavenia. ");
INSERT INTO nkn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nga kuli vimo vikuavo mutonda kutantekeya, muapande kuvihandekela mu nzango yakuliuanena. ");
INSERT INTO nkn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hanima yevi vinalingiua lelo, tuli muvukalu vuakama vuakutuvangeya nguavo yetu tunanehe mpindangano. Kaha kukuesi kusambuesa ha kalua aka koshe kanalingiua lelo, kutuasa kuhana vukaleho vuacili ha viuma evi.” ");
INSERT INTO nkn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hanima yakuhandeka evi uasunuine ciuano eci. ");
INSERT INTO nkn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hanima yakuhua kuampindangano ije Paulu uasanene vandongisi, kaha uahandekele kuli vakevo mezi akuvasimpisa nakuvasalesa. Ambahoni uakatukile nakuya ku Mesendoniya. ");
INSERT INTO nkn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Omo te alinakuhita mu vihela vije nakukolesa cikuma vandongisi, uaile ku Akaya, ");
INSERT INTO nkn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kuje uakatumamene vingonde vitatu. Ha ntsimbu ije uakele nakulivuahesela linga aye na vuato ku Silia kaha kalua ka kumuluisa kuli Vayunda kaputukile, kaha uasinganiekele kuhiluka nakuhita ku Mesendoniya. ");
INSERT INTO nkn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Vamusindikiile kuli Sopata muna Pihase uakuhuma ku Mbeleya, na Alisitikase na Sekundase uaku Matesolonika, na Ngayase na Timoteo vaku ndemba, Taikikase na Tolofimase vaku mbonge ya Asiya. ");
INSERT INTO nkn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Vaile kulutue luetu na kutuvandamena mu Tolouasi, ");
INSERT INTO nkn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","vuno honi tuajavukile mu vuato kuhuma ku Filipu hanima ya ciuano ca mbolo yakuhona cimbaluila, kaha munima ya matangua atanu tuakavauanene ku Tolouasi, kuje kukeko tuakakele matangua atanu na avali. ");
INSERT INTO nkn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ha cinguezi cakuhua litangua lia Sapalalo, tualiuanene nakutavula mbolo, kaha Paulu uakele nakuhandeka navo, kaha uatualeleho kuhandeka cikuma noho mukati kavutsiki, omuo uatondele kuya lia mukuavo. ");
INSERT INTO nkn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Muakele vindeya viavingi mu milili ya kuilu uje mukemo tuakele nakuliuanena. ");
INSERT INTO nkn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mukueje ua lizina lia Yutikase, uje uatumamene ku njanena, uaputukile kunenguka omo te Paulu alinakuhandeka ntsimbu yailaha, kaha uauililile ha mavu kuhuma haje ha mulili uahelu lia njivo ya mu citatu ya injivo viakulipandakana. Kaha omo uamukuate uauanene natsi. ");
INSERT INTO nkn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Vuno honi Paulu uasikumukile ha mavu, nakukotama hali ikeye nakumuvumbatela. Kaha uahandekele nguendi, “Keti mulishoshomuene, omuo hanga acilina kuyoya!” ");
INSERT INTO nkn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kaha Paulu ualondele ku milili ya kuilu, kaha hanima yakupazula mbolo na kulia, uatualeleleleho kuhandeka navo mu ntsimbu yailaha noho cimene, kaha uaile. ");
INSERT INTO nkn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kaha vatualele uje mukuenje kuimbo liavo oku te ali na kuyoya kaha eci cava simpile cikuma. ");
INSERT INTO nkn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Vuno honi yetu tualivangele kuya mu vuato nakukajavuka kuya ku Asose, kuje tuaile nakukambata Paulu linga akovele mu vuato. Uatushikile kulinga evi, omuo uaile kuje na ngila ya ntunda. ");
INSERT INTO nkn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kaha omo uatuuanene ku Asose, tuamukovelesele mu vuato ka tuahete ku Mitilene. ");
INSERT INTO nkn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kaha omo tuajavukile mu vuato kuhuma kuje, liamukuavo tuahete kuje ku cihela ca kulitala na Ciyosi, kaha liamukuavo tuaile ku Samose kaha naua hanima ya litangua eli tuaile ku Miletu. ");
INSERT INTO nkn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nankuma, Paulu uasinganiekele kuhona kuhita ku Efeso, linga keti akale ntsimbu yailaha mu Asiya, omuo uatondele kuheta ku Yelusalema, nge casiua, ha litangua lia Pentekosita mu mbonge ya Asiya. ");
INSERT INTO nkn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Omo uakele ku Miletu kaha uatumine mezi ku Efeso ku vakuluntu va cikungulukilo linga valiuane nendi. ");
INSERT INTO nkn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kaha omo vezile kuli ikeye, uahandekele kuli vakevo nguendi, “Yeni vavenia muatantekeya omo njayoyele hhakati keni ha ntsimbu yoshe kuputuka ha litangua liakulivanga lije linjahete mu mbonge ya Asiya, ");
INSERT INTO nkn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","mukupangela Muene nakulihana na masozi na vieseko vianjiuanene omuo yakunjiyandesa kuli Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nacimo cahi cije cacili njahonouele kuhandeka kuli yeni, kaha naua nakumilongesela hhakati ka vantu, kaha nakumilongesela ku njivo na njivo. ");
INSERT INTO nkn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nakuhana vukaleho kuli Vayunda na Vangelengu ha kutengulukila kuli Njambi na lutsilielo kuli Muene uetu Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kaha taleni njilinakuya ku Yelusalema ngue muje mucitondelamo Cimbembesi Uakulela, kuakuhona kutantekeya vika vikalingiua kuli yange kuje. ");
INSERT INTO nkn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Njatantekeyele lika nguange mu nganda muoshe Cimbembesi Uakulela cinjinangula nguaco, kamenga na vukalu vinanjivandamena. ");
INSERT INTO nkn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Vuno honi njasinganieka nguange mmuono uange kuuesi na seho kuli yange, njatondo lika kumanesa vipangi vianjihanene Muene Yesu kuvilinga, vije vikevio kuambulula Muzimbu Uacili ua kavumbi ka Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kaha honi njatantekeya nguange naumo uahi hhakati keni injinambuluila Vumuene vua Njambi, akamonaho cihanga cange,lueka naua. ");
INSERT INTO nkn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nankuma njimilekesa ha litangua lia lelo nguange kunjesi na mulonga ua maninga hali umo ueni nga azimbala. ");
INSERT INTO nkn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Omuo kunjahonouele kumileka vioshe via cizango ca Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Liniungeni kaha naua niungeni vutanga vua vampanga vuje Cimbembesi Uakulela camihana kumona, kuniunga cikungulukilo ca Njambi cije cambate na maninga a munendi. ");
INSERT INTO nkn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Njatantekeya nguange nga njinai, tungunga vaje vakuteuesa vakeja hhakati keni na kupihisa vutanga vua vampanga. ");
INSERT INTO nkn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Vamo vaku civunga ceni vakeja nakuhandeka makuli linga vatangule vandongisi linga vavakave. ");
INSERT INTO nkn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nankuma zangameni, anukeni ngueni ha miaka itatu vutsiki na mutania kunjahonouele kunangula uoshe na masozi. ");
INSERT INTO nkn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kaha honi njimikundika kuli Njambi linga aminiunge naku muzimbu ua Kavumbi kendi, uje uasa kumitungisa na kumihana vikuisulo vije viali navio Njambi ha vantu vendi voshe. ");
INSERT INTO nkn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ku njatondele siliva cipue ngolinde cipue vuzalo vua muntu. ");
INSERT INTO nkn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Muatantekeya yeni vavenia ngueni njapangele na mavoko ange vavenia hakulikuasa yange vavenia na vakuasi vange. ");
INSERT INTO nkn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ha vioshe evi njamihana cimueso ngeci ha vipangi evi tuapande kukuasa vaka kuzeya, kuvuluka mezi a Muene Yesu, omuo ikeye vavenia uahandekele nguendi, ‘Cinapu cakuvezika cikuma kuhana kupulakana kutambula.’ ” ");
INSERT INTO nkn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Omo uamanuisile kuhandeka, uatsikamene ha mavu navo voshe na kulombela. ");
INSERT INTO nkn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Valilile cikuma hhakati kavo voshe, kaha vamuvumbatele na ku mutsuemba. ");
INSERT INTO nkn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Vakele na vusiua omuo vovuile ahandekele nguendi ku vakamumonoho ceka naua. Kaha vamusindikiile ku vuato. ");
INSERT INTO nkn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hanima yakulisalesa navo kaha tuajavukilile musinia, kaha tuahete ku Kose, kaha lia mukuavo tuahete ku Londese, kaha kuhuma kuje tuahete ku Patala. ");
INSERT INTO nkn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Omo tuauanene vuato vuakuya ku Fonisiya, tuakovelele mu vuato kaha tuaile. ");
INSERT INTO nkn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tuahete kaha tuamuene sipulase, kaha tuajavukilile ku mbuela yaku Silia kaha tuahete ku Tile, omuo vuato vuapandele kuhumisa vitenga kuje. ");
INSERT INTO nkn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tuakauanene vandongisi kaha tuakakele navo matangua atanu na avali. Kuhitila mu Cimbembesi valekele Paulu nguavo keti aye ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Omo matangua etu ahuile kuje, tuatualeleleho na vungenzi vuetu, kaha voshe va mala na va mpuevo vavo na vanike, vatusindikiile hakuhuma munganda. Kuje tuatsikamene hamavu kungenga amame a kalunga kaha tua lombelele. ");
INSERT INTO nkn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kaha tualisalesele umo namukuavo. Kaha tuaile nakukovela mu vuato, kaha vakevo velukile ku membo avo. ");
INSERT INTO nkn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tuatualeleleleho vungenzi vuetu kuhuma ku Tile, kaha tuahete ku Putolemaise kaha tuamenekele vakakutsiliela kaha tuatumamene navo litangua limo. ");
INSERT INTO nkn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Omo kuacele tuaile kaha tuahete ku Sesilia, kaha tuakovelele mu njivo ya Filipu uje mukakutuala lizi lia Njambi ku vantu, uavaje vatanu na vavali, vaje vavahanguile mu Yelusalema kupua vakuasi kaha tuatumamene nendi. ");
INSERT INTO nkn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Uakele na vana vendi vauana va vampuevo vakuhona kushomboka vaje vakele na vuana vua vunanguizi. ");
INSERT INTO nkn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tuatumamene kuje ha matangua amo, kananguizi ua Njambi iva tumbuile nguavo Angambase uezile kuhuma ku Yundeya. ");
INSERT INTO nkn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Uezile kuli yetu kaha uambate muiva ua Paulu, ualikutile kuviliato na mavoko endi na muiva uje, kaha uahandekele nguendi, “Cimbembesi Uakulela cihandeka nguaco, Eyi ikeyo ngila Vayunda vamu Yelusalema vakakuta yala uavavenia muiva ou kaha vakamuhana kuli vaje keti Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Omo tuevuile eci, yetu na vakuetu vakele muje tualombele Paulu linga keti aye ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kaha Paulu uakumbuluile nguendi, “Vika muli nakulinga, kulila ngacije kaha muli nakupokola mutima uange? Njalivuahesela keti lika kunjikuta vuno honi cipue kukatsila mu Yelusalema omuo ha lizina lia Muene Yesu.” ");
INSERT INTO nkn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Omuo kutuahasele kumusindiya, tuaholokele kulu kaha tuahandekele nguetu, “Cizango ca Muene cilingiue.” ");
INSERT INTO nkn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Hanima ya matangua akukala kuje kaha tualivuaheselele kuya ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Vamo va vandongisi vaje vahumine ku Sesaliya na vakevo vezile netu kaha vatutualele ku njivo ya Manasone ua ku sipulasi, uje uapuile ndongisi uakulivanga. ");
INSERT INTO nkn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Omo tuahete ku Yelusalema, kaha vakuetu vaka kutsiliela vatutambuile muacili. ");
INSERT INTO nkn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Omo kuacele Paulu uaile netu hamo nakukamona Tiango, na vakuluntu va cikungulukilo kuvakele. ");
INSERT INTO nkn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Hanima yakuvameneka, Paulu ualumbuniune cimo na cimo ha viuma Njambi vialingile kuli vaje keti Vayunda kuhitila mucipangi cendi. ");
INSERT INTO nkn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Omo vacivuile, vashangazalele Njambi. Kaha vahandekele kuli vakevo nguavo, “Tala, muanetu Paulu, unamono makulukazi aje a Vayunda vaje muje muvanatsiliela, kaha namuje muvanalihanenamo vakevo vavenia voshe ku Lishiko lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Vanavalekesa viove nguavo ulinakulongesa voshe Vayunda vaje vatunga hhakati kavaje keti Vayunda linga keti vakave Lishiko lia Mosesa, kaha naua nguove keti vatuhule vana vavo cipue keti vaniunge futisi ya Vayunda. ");
INSERT INTO nkn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Cilivene vakevua nguavo unaija. Kaha vikahoni vikalingika? ");
INSERT INTO nkn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Evi vikevio vitutonda yove linga uvilinge. Kuli vamala vauana kuno vaje vanakulahesa Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ya hamo nava vamala vauana ulipandakane navo mu cilika ca kulilelesa, kaha fueta ndando yavo, linga vakatehule ku mitue yavo. Mu ngila eyi vene muntu uoshe akatantekeya ngeci vioshe vijevene vanakala nakuhandeka hali yove keti via vusunga, vuno honi yove vavenia uli nakuononoka Lishiko lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Vuno honi hali ava keti Vayunda vuno honi vaka kutsiliela, tunatumu mukanda ua kusompa kuetu nguetu vahume ku via kulia vije vanakombela ku tumponia na ku maninga naku tusitu tuakutikinia nakulihimisa vakevo vavenia ku vupangala.” ");
INSERT INTO nkn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kaha liamukuavo Paulu uaile navaje vamala hanima yakulilelesa, uakovelele mu Njivo ya Njambi navo, nakuvalekesa matangua a kulilelesa muje muakahuila, omo vakakombela nkombelo hali umo na umo uavo. ");
INSERT INTO nkn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Vuno honi omo matangua atanu na avali te atonda kuhua, Vayunda vaje vahumine ku mbonge ya Asiya, vaje vamuene Paulu mu Njivo ya Njambi. Vashongangeyele civunga coshe linga vakuate Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vatambekele nguavo, “Vamala vaku Isaleli, tukuaseni! Ou ikeye yala uje ali nakulongesa vantu voshe kuoshe linga valuise vantu va Isaleli, na Lishiko lia Mosesa, na Njivo ya Njambi ino. Kaha honi nanehe naua na Vangelengu mu Njivo ya Njambi linga vajualesa eci cihela cakulela.” ");
INSERT INTO nkn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Omo vamuene Tolofimase uaku Efeso hamo na Paulu mu nganda, kaha vasinganiekele nguavo hamo Paulu uamutualele mu Njivo ya Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kaha citanga eci cashandokelele mu nganda yoshe, kaha vantu voshe vashatukile hamo. Vakuate Paulu nakumuhumisa mu Njivo ya Njambi, kaha hajevene vashokele vikolo. ");
INSERT INTO nkn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Cije civunga casinganiekele kumutsiha, kaha lizi liaile kuli Ntuama ua masualale ua Loma ngualio Yelusalema yoshe ili mumpindangano. ");
INSERT INTO nkn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hajevene uambate masualale na vantuama ua masualale cihita cimo (100) kaha vashatukilile ku civunga. Kaha omo vamuene Ntuama ua masualale na masualale, kaha vecelele kupupa Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kaha Ntuama ua masualale uezile kuli Paulu, uamukutile, kaha uashilkile nguendi vamukute na malienge avali, kaha uavehuile nguendi, “Ikeye iya ou yala, kaha naua nalingi vika.” ");
INSERT INTO nkn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vamo mu civunga vatambekele vimo, vakuavo naua vieka. Mulonga uakuhona kuivuisisa muacili vialingiuile omuo ya citanga, ualekesele vatuale Paulu ku vinjivo kuje kuvakakala masualale. ");
INSERT INTO nkn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Omo Paulu uahete ha vindendelo, kaha vukalu vua civunga vuakele vuakama ngeci valingile uakukakula kuli masualale. ");
INSERT INTO nkn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Civunga cije cavakavele catualeleleleho kutambeka, “Mutsiheni!” ");
INSERT INTO nkn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Hajevene Paulu vatondele kumuneha mu vinjivo muje muakala masualale. Ntuama ua masualale likulukazi limo (1, 0 0 0) uahandekele kuli vakuluntu nguendi, “Njasakuhandekako cuma cimo kuliyeni?” Uje Ntuama ua masualale likulukazi limo (1, 0 0 0) uakumbuilile nguendi, “U tantekeya ci Ngelengu?” ");
INSERT INTO nkn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nkuma keti yove Kaingito uje ha ntsimbu yakunima uatengulukilile vumuene nakutuamenena vamala vanzita vakupua makulukazi auana (4, 0 0 0) mu ndinda ndi? ");
INSERT INTO nkn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulu uakumbuilile nguendi, “Yange nji Kayunda, njasemukilile ku Talisi mu Silisha, mundambo ua nganda yakasingimiko. Njitavese linga njihandeke kuli vantu. ");
INSERT INTO nkn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kaha uje mukakushika masualale uamuhanene ntsimbu yakuhandeka, kaha Paulu uemanene ha vindendelo nakuolola livoko liendi linga vantu voloke. Omo vantu vaholokele, kaha Paulu uahandekele kulivakevo mu Cihevelu. ");
INSERT INTO nkn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Vamuanetu na vatatetu Vayunda, njivuilileni omo njili na kuliamena hakati keni.” ");
INSERT INTO nkn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kaha omo vamuvuile ali nakuhandeka kuli vakevo mu Cihevelu, kaha vaholokele cikuma. Kaha uahandekele nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yange Kayunda, njasemukilile ku Talisi mu Silisha, njakolele mu nganda ino vene ya Yelusalema, kaha Ngamaliele ikeye uapuile mulongisi uange, nakulilongesa muacili lia Lishiko lia vakukuluila vetu, na kulikolesa cikuma kuli Njambi, nge omo mu munapu muva voshe lelo. ");
INSERT INTO nkn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Njapakesele noho nja tsihile vantu vaje vakavele Ngila ya Muene eyi. Njakutile vamala na vampuevo nakuvatuala mukamenga. ");
INSERT INTO nkn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kupua Kasesondote uakama na mpunga yoshe vanahase kuhana vukaleho hali yange. Kulivakevo njatambuile mikanda yakuhuminina kuli vakuetu Vayunda va ku Ndamasika, kaha njaileko linga njikakuate vaje vakele kuje nakuvahiluisa mu Yelusalema linga vavazangamese.” ");
INSERT INTO nkn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Kaha omo njakele nakuya nakuheta kuyehi na Ndamasiku, hhakati ka mutania kaha vuasi vuasi ceke ca humine muilu ca kuviazima catuile nakunjizengeleka. ");
INSERT INTO nkn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kaha njauilililile ha mavu kaha njevuile lizi lihandeka kuli yange ngualio, ‘Saulu, Saulu, vika uli na kunjiyandesela?’ ");
INSERT INTO nkn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kaha njehuile nguange, ‘Yove iya Muene?’ Kaha lizi liakumbuluile ngualio, ‘Yange Yesu ua ku Nazaleta uje ulinakuyandesa.’ ");
INSERT INTO nkn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vuno honi vaje vamala vakele hamo nange vamuene lika ceke vuno honi kuvovuile lizi lia uje uakele nakuhandeka kuli yange. ");
INSERT INTO nkn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kaha njehuile nguange, ‘Njilinge vati honi, Muene?’ Kaha Muene uahandekele kuli yange nguendi, ‘Katuka linga uye ku Ndamasika, kuje vakakuleka viuma vioshe vije via nakuimikila Njambi linga uvilinge.’ ");
INSERT INTO nkn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kaha njapuile njikapuputua omuo ca ceke cakuviazima, kaha vaje njendele navo vanjikuate ku livoko nakunjituala ku Ndamasika.” ");
INSERT INTO nkn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mu nganda muje muakele yala umo lizina liendi ikeye Ananiyasi, uakulongua nakuononoka Lishiko lietu kaha vamusingimikile cikuma kuli voshe Vayunda vakele Mundamasika. ");
INSERT INTO nkn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Uezile kuli yange, kaha uemanene kuyehi nange kaha uahandekele nguendi, ‘Muanetu Saulu mona naua!’ Kaha ha ntsimbu ijevene njamuene naua nakutala kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Kaha uahandekele nguendi, ‘Njambi ua vakukuluila vetu nakuhangula linga utantekeye cizango cendi, nakumona ngamba yendi ua vusunga nakumuivuila omo ahandeka na lizi liendi. ");
INSERT INTO nkn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Omuo ukapua mukaleho uendi ku vantu voshe ku vije viunamono na ku vije viunevu. ");
INSERT INTO nkn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kaha honi vika viuvandamena? Katuka linga vakumbuitike, kaha vupi vuove vavusambese, hakusana lizina liendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Hanima ya kuhilukila ku Yelusalema, kaha ha ntsimbu ije njakele nakulombela mu Njivo ya Njambi, njamuene cimona, ");
INSERT INTO nkn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mu cimona cije njamuene Muene ahandeka kuli yange nguendi, ‘Zangulako huma mu Yelusalema vuasi, omuo vantu valimuno kuvasa kutambula vukaleho vuove omuo yange.’” ");
INSERT INTO nkn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Kaha njamukumbuluile nguange, ‘Muene, vakevo vavenia vatantekeya nguavo njakele nakuya mu vinjivo vioshe via malombelo via Vayunda kaha njakele nakuya nakuvakuta nakuvapupa vaje vatsilielele muli yove. ");
INSERT INTO nkn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kaha omo mukaleho uove Setefano muva mutsihile, kunjakele nange vene hakulitavasana navo ha kutsa cendi, kaha njaniungile tuzaku tua vaje vamutsihile.’” ");
INSERT INTO nkn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Kaha Muene uahandekele kuli yange nguendi, ‘Ya, omuo njikakutuma kulahako kuli vaje keti Vayunda.’” ");
INSERT INTO nkn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kaha vantu vovuile vije viahandekele Paulu, kaha vaputukile kutambakana cikuma nguavo, “Kutuamutondele ou yala! Mutsiheni! Kapandele kuyoya!” ");
INSERT INTO nkn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vakele nakutambakana cikuma na kuashanga vizalo viavo, nakushauila livu muilu. ");
INSERT INTO nkn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kaha uje mukuluntu ua masualale ua Loma uashikile vantu vendi linga vatuale Paulu mu vinjivo muvakakala masualale kaha uavalekele nguendi vamupupe nakuuana omuo vika Vayunda vakele nakutambekela nakumuluisa. ");
INSERT INTO nkn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Vuno honi omo vamukutilile linga vamupupe, Paulu uahandekele kuli mukuluntu uje uemanene kuje nguendi, “Nkuma linapu Lishiko kupupa mundambo ua mu lifuti lia Loma uje kuvasompelele linga vauane mulonga uanalingi ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Omo uje ntuama ua masualale cihita cimo (100) uevuile evi, uaile kuli mukakushika ntuama ua masualale cihita cimo (1, 0 0 0) kaha uahandekele kuli ikeye nguendi, “Vika utonda kulinga? Ou yala napu ka Loma.” ");
INSERT INTO nkn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kaha uje mukakushika ua masualela uaile nakuihula Paulu nguendi, “ Njileke, unapu uka Loma ndi?” Kaha Paulu uahandekele nguendi, “Eyo.” ");
INSERT INTO nkn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kaha uje mukuluntu uamasualale uahandekele nguendi, “Yange ovu vundambo vua mu lifuti lia Loma njavulandele na vimbongo viavingi cikuma.” Vuno honi Paulu uamukumbuluile nguendi, “Vuno honi yange njasemukila mu nove vene.” ");
INSERT INTO nkn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hajevene vaje vamala vatondele kuihula Paulu vamushondolekele nakuya kaha na uje mukuluntu uamasualale naua uevuile liova, omo uakutantekeyele nguendi nkuma Paulu uapuile mundambo ua mu lifuti lia Loma, vuno honi uamuhakele mu malienge. ");
INSERT INTO nkn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Vuno honi uje mukakushika masualale uatondele muacili vika cuma cika Vayunda vakele nakuvangela Paulu, kaha liamukuavo uashikile linga vazitule Paulu, kaha uashikile vakuluntu vavasasendote na vakampunga voshe vakunguluke. Ambahoni uatualele Paulu nakumuimika ha mesho avo. ");
INSERT INTO nkn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Tele Paulu uatalele ntoma hali ije mpunga, kaha uahandekele nguendi, “Vamuanetu, vaka Isaleli! Visinganieka viange vinapu via vusunga ha ngila ije injinayoyo nayo ku mesho a Njambi nakuheta ku litangua lia lelo.” ");
INSERT INTO nkn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kaha mukuluntu ua kasasendote uakama ua lizina lia Ananiyasi uashikile vaje vemanene kuyehi nendi linga vapupe Paulu kukanua. ");
INSERT INTO nkn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ambahoni Paulu uahandekele kuli ikeye nguendi, “Muavusunga vene Njambi akupupa, yove civumbe cakukuita mufuitilo uakutoka! Uatumama aha linga unjisompe kuya na Lishiko, vuno honi yove unapokola Lishiko lia Mosesa mukuvashika linga vanjipupe!” ");
INSERT INTO nkn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Vaje vamala vemanene kuyehi na Paulu vahandekele nguavo, “Ulinakutuka Kasasendote Uakama ua Njambi!” ");
INSERT INTO nkn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Kaha Paulu uavakumbuluile nguendi, “Vamuanetu vaka Isaleli kunjatantekeyele nguange uapuile Kasasendote Uakama, omuo vacisoneka nguavo, ‘Keti uhandeke vupi hali ntuama ua vantu vove.’” ");
INSERT INTO nkn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Vuno honi omo Paulu uamuene nguendi vamo va muje mu civunga uapuile Vasanduki kaha naua vakuavo vapuile Vafaliseo, uatambakanene ku mpunga nguendi, “Vamuanetu, yange nji Kafaliseo, muna Vafalisi. Va linakunjisompa kuno omuo ya hakutsiliela cinje cinjili naco ca ha kusanguka kua vatsi.” ");
INSERT INTO nkn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kaha omo uahandekele evi, hajevene Vafaliseo na Vasanduki vaputukile vimpata, kaha vaka mpunga valipangele. ");
INSERT INTO nkn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Omuo Vasanduki vahandeka nguavo vantu kuvakasanguka ku vatsi, kaha naua kukuesi tungelo cipue vimbembesi, vuno honi Vafaliseo vatsiliela muviuma vioshe evi vitatu). ");
INSERT INTO nkn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ambahoni vantu vaputukile kutambakana cikuma mukuhandeka, kaha vamo valongisi va mashiko a Mosesa vaje vakele ku mpunga ya Vafaliseo vemanene nakuhandeka na nzili nguavo, “Kutuauanene cuma cimo cacipi canalingi ou yala! Hamo muavusunga Cimbembesi cipue kangelo nahandeka kuli ikeye!” ");
INSERT INTO nkn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kaha omuo vimpata viatualeleleho cikuma, uje Ntuama ua masualale cihita cimo (1, 0 0 0) uevuile liova nguendi hamo Paulu vamutavozola vimpindi vimpindi. Kaha uashikile masualale kukovela hakati ka mpunga cije linga vakatundiseho Paulu nakumutuala ku vinjivo vivakatumama masualale. ");
INSERT INTO nkn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kuvutsiki vujevene Muene uemanene kuyehi na Paulu kaha nakuhandeka nguendi, “Keti uivue liova! Unahana vukaleho vuove hali yange muno mu Yelusalema, kaha uapande kulinga cifua cimo naua na mu Loma.” ");
INSERT INTO nkn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kaha omo liamukuavo cimene vamo Vayunda valiuanene nakulitumba vutumbe vuavushuenge. Valisingile nguavo naumo uahi alia cipue kunua kuvanga noho vanatsihi Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kuakele vantu vakupulakana makumi auana vaje vatumbile vutumbi vuje hamo. ");
INSERT INTO nkn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kaha vaile kuvakuluntu va tusasendote na ku vakuluntu kaha vahandekele nguavo, “Tunalikutu tuva voshe nakulisinga nguetu naumo uahi amakela vioshe kuvanga noho tuatsihi Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kaha honi yeni na vaka mpunga muapande kutuma lizi ku Ntuama ua masualale cihita cimo (1, 0 0 0) ua Loma linga atume Paulu kuli yeni, mulikuise ngue mutonda kuuana vukaleho vuacili hali ikeye. Vuno honi yetu tulivuahesela kumutsiha ha ntsimbu kanda ahete kuno.” ");
INSERT INTO nkn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Vuno honi muihua ua Paulu uevuile vutumbe ou, kaha uaile ku vinjivo vivakakala masualale, uakalekele evi kuli Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kaha Paulu uasanene umo ua vaje Vantuama va masualale cihita cimo (100) nakuhandeka kuli ikeye nguendi, “Tualeni ou mukuenje kuli Ntuama ua masualale likulukazi vimo (1, 0 0 0) ali navimo vije atonda kumuleka.” ");
INSERT INTO nkn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ambahoni uje ntuama ua masualale cihita cimo (100) uamutualele kuli Ntuama ua masualale cihita cimo (1, 0 0 0) nakuhandeka nguendi, “Ou cinzinda Paulu na njilombele nguendi njinehe ou mukuenje kuli yove, kuli vimo atonda kukuleka.” ");
INSERT INTO nkn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kaha Ntuama ua masualale cihita cimo (1, 0 0 0) va Loma uakuate ku livoko lia uje mukueje, nakumutuala ikeye vavenia, kaha uamusanene kumukulo kualikaliavo, uamuhuilisile nguendi, “Vuima vikahoni utonda kunjileka?” ");
INSERT INTO nkn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kaha uahandekele nguendi, “Vaka nzili yakama ya Vayunda valitavasana kukulomba linga vatuale Paulu kuli va ku mpunga imene, mukulimuesa nge vakatondesesa muacili ha vukaleho vuendi. ");
INSERT INTO nkn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Vuno honi keti uvevuilile, omuo kuvali vamala vakupulakana makumi auana vaje vakavanda nakuvandamena Paulu. Vanalisingi linga keti valie viakulia cipue kunua mema kuvanga noho vanamutsihi. Vanalivuahesela laja kulinga eci, kaha vanamuvandamena nakuvandamena lika yove linga uvatave.” ");
INSERT INTO nkn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kaha uje ntuama ua masualale cihita cimo (1, 0 0 0) uahandekele nguendi, “Keti ulekeko muntu cipue umo nguove unahandeka evi kuli yange.” Kaha uashikile uje mukuenje linga aye. ");
INSERT INTO nkn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ambahoni Ntuama ua masualale cihita cimo (1, 0 0 0) uasanene vantuama ua masualale cihita cimo (100) vavali kaha uahandekele kuli vakevo nguendi, “Ambateni masualale vakupua vihita vivali (200) valivuahesele kuya ku Sesaliya, hamo makumi vatanu na avali vaje kakuendela ha tuvalu na masualale vakupua vihita vivali (200) vaje vakakulua na makunga, livuaheseleni kukatuka ha ntsimbu ya vitanu na viuana vutsiki vuno vene. ");
INSERT INTO nkn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Vuaheseniko vamo tuvalu linga Paulu alondeho, kaha muheteseni muacili kuli nguvulu Felekisi.” ");
INSERT INTO nkn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kaha uje Ntuama ua masualale cihita cimo (1, 0 0 0) uasonekele mukanda muje muakele mezi aua, ");
INSERT INTO nkn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kalaundiase Lisiyase kalemesa, kuli Nguvulu Felekisi, vihindu. ");
INSERT INTO nkn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Vayunda vakuate ou yala kaha vatondele kumutsiha. Kaha omo njevuile nguavo mundambo ua mu lifuti lia Loma, njaile na masualale vange na kumuyoyesa. ");
INSERT INTO nkn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kaha njatondele kutantekeya vika vakele nakumuvangeya, nankuma, njamutualele kuli vaka mpunga yavo. ");
INSERT INTO nkn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Njauanene nge nacimo cahi cacipi calingile cije vatondele kumutsihila cipue kumuhaka mu kamenga. Vakele nakumuvangeya viuma vije viakundama kuvihula via mashiko avo vavenia. ");
INSERT INTO nkn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kaha omo vanjilekesele nguavo vali navutumbe vua kumuluisa, hajevene njasinganiekele kumutuma kuli yeni. Njalekesele vaje vamuvangeyeye linga vamuhane mulonga ha mesho eni.” ");
INSERT INTO nkn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Masualale valingile mu vavashikilililemo. Vambate Paulu nakumutuala vutsiki vuje vene kuli Antipatilisise. ");
INSERT INTO nkn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Liamukuavo vaje masualale vahilukile kuvihela viavo nakuseza vaje vaka kuendela ha tuvalu linga vaye nendi. ");
INSERT INTO nkn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vamutualele ku Saseliya, kaha vahanene uje mukanda kuli Nguvulu, nakuhetesa Paulu kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nguvulu uatandele uje mukanda kaha uehuile Paulu nguendi uhuma ku mbonge muka. Omo uauanene nge Paulu uatundile ku Silisha, ");
INSERT INTO nkn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kaha uahandekele nguendi, “Njikakuivuilila nga vaje vanakuvangeya vanahete kuno.” Kaha uashikile linga vaniunge Paulu mu mapela a Nguvulu. ");
INSERT INTO nkn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Hanima ya matangua atanu Kasasendote Uakama Ananiyasi uaile ku Sesaliya na vamo vakuluntu na lihako umo ua lizina lia Tetulase. Vezile ku mesho a Nguvulu Felekisi nakumulekesa mulonga ua Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kaha uasanene Paulu linga akovele mukati, kaha Tetulase uaputukile kuvangeya Paulu nguendi, “Uakalemesa Felikisi, kutuamenena kuove kua mana cinatunehela ciyulo ntsimbu yakama, kaha viuma viavinga vinatenguluka linga vantu vetu vakale muacili. ");
INSERT INTO nkn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tunacitambula eci kuoshe na ha ntsimbu yoshe, kaha naua tuavuahelela cikuma kuli yove. ");
INSERT INTO nkn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kunjatondele kumipihisila ntsimbu yeni cikuma, cipue ngoco, njikulomba ukakeleko na ngozi nakuvuilila ku mezi etu amandende. ");
INSERT INTO nkn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tuauana ou yala kupua muntu ua kalua, uaputukile kulinga mpindangano hhakati ka Vayunda mu cifuti coshe, kaha naua ikeye ntuama ya mpunga ya vaka Nazalite. ");
INSERT INTO nkn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ikeye naua uatondele kujualesa Njivo ya Njambi, kaha tuamukutile.  ");
INSERT INTO nkn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Vuno honi Lisiyase ntuama ua masualale cihita (1, 0 0 0) ua Loma uezile, kaha na nzili yakama uatutambuileye. ");
INSERT INTO nkn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nga umuhulisa yove vavenia ou yala uasa kuuana kuli ikeye vioshe vije vitunamuvangeya.” ");
INSERT INTO nkn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Vayunda navo naua vamuvangeyeye nguavo vioshe evi via vusunga. ");
INSERT INTO nkn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kaha Nguvulu uashovueyele Paulu linga ahandeke, kaha Paulu uahandekele nguendi, “Njatatentekeya nguange yove unapu ulihako ua lifuti eli ha miaka yaingi, kaha njavuahelela cikuma kuliohiela yange vavenia ku mesho ove.” ");
INSERT INTO nkn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ngautondesesa, keti matangua a kupulakana matangua likumi na avali anahitimo ha njailile nakulemesa ku Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vayunda ku vanjiuanene njili nakulinga vimpata naumo mu Njivo ya Njambi cipue kuneha mpindangano mu civunga cipue mu njivo ya malombelo ya Vayunda cipue mu nganda yoshe. ");
INSERT INTO nkn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Cipue vase kukuhana vukaleho vua makuli aua vali nakunjihana hano. ");
INSERT INTO nkn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Vuno honi njitava cuma eci kuli yove nguange njikalemesa Njambi ua vakukuluila vetu mukukavangeya Ngila ije ivatumbula vakevo nguavo ya makuli. Kahanaua njikatsiliela mu vioshe vije vivanasoneka mu Lishiko lia Mosesa na mu mavulu a tunanguizi va Njambi va Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Njili na lutsilielo muli Njambi nge muje muvalinaluo vakevo, luje luvatumbula nguavo kukakala kusanguka kua vaka vupi na vaka vusunga. ");
INSERT INTO nkn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nankuma njili nakulinga na nzili yange yoshe linga njikale na lishungu ku mesho a Njambi na ku mesho a vantu. ");
INSERT INTO nkn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Hakuhona kukala mu Yelusalema ha miaka yaingi, kaha njahilukileko mu kutuala vukuasi ku vantu vange nakukakombelela vinkombelo. ");
INSERT INTO nkn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Omo yapuile ntsimbu ije njakele nakulinga eci vanjiuanene mu Njivo ya Njambi te njinamanesa kulijelesa. Kunjakele na civunga ca vantu cahi, cipue kulinga kalua. ");
INSERT INTO nkn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Vuno honi vamo va Vayunda vaje vahumine ku mbonge ya Asiya vakele kuje, vakevo vapandele kuija ku mesho ove nakunjivangeya nga vakele navimo viakuluisa yange. ");
INSERT INTO nkn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Cipue tava ava vamala valikuno linga vahandeke mulonga uvanjiuanene nauo omo njemanene ku mesho a mpunga. ");
INSERT INTO nkn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kuvanga lika mpano ha cuma cimo cije njatambekele omo njemanene ku mesho avo nguange, “Mulinakunjisompa ku litangua lia lelo omuo njatsiliela nguange vatsi vaka sanguka.” ");
INSERT INTO nkn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ambahoni Felekisi, uje ualilongesele cikuma ha vimpande via Ngila ya Muene uemikile kuje kusompa, “Omo Lisiyase uje ntuama ua masualale cihita (1, 0 0 0) akeja ambahoni njikasinganieka ha mulonga uove.” ");
INSERT INTO nkn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kaha uashikile uje muka kunuinga linga anuinge muacili Paulu, vuno honi napande kumuhanako kupatuka kumo nakuta vavusamba vendi linga vamukuase. ");
INSERT INTO nkn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hanima ya matangua amo Felekisi uezile na mpuevo yendi Ndulusila, uje uapuile Kayunda, uamuminine vantu linga vakambate Paulu linga eje kaha akumuvuilile uje muahandeka via lutsilielo muli Kilistu Yesu. ");
INSERT INTO nkn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Vuno honi Paulu uakele nakuhandeka ha vucili, na kuliniunga, kaha na ha kuija kua Litangua lia cisompelo, Felekisi uevuile liova kaha uahandekele nguendi, “Yahoni ha tsimbu ino, omo njikauana ntsimbu kaha njikakusana naua.” ");
INSERT INTO nkn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Hatsimbu ijevene uasinganiekele nguendi hamo Paulu amuhanako vimbongo vimo, kaha ha mulonga ou linga akamusane sane nakuhandeka nendi. ");
INSERT INTO nkn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Munima yakuhita miaka ivali, Posiyase Fesitase uasuanene mucihela ca Felekisi kupua Nguvulu. Felekisi uatondele kuvuahelesa Vayunda, kaha uasezele Paulu mu kamenga. ");
INSERT INTO nkn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Hanima ya matangua atatu Fesitase uahete mu nganda, uahumine ku Sesiliya nakuya ku Yelusalema, ");
INSERT INTO nkn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","kuje vakuluntu va tusasendote na vakuluntu va Vayunda vamuhanene vimpande viakuuanena mulonga Paulu. Kaha valombele Fesitase ");
INSERT INTO nkn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","linga avakuaseko kutuma Paulu ku Yelusalema omuo vatumbule vutumbe vuakumutsihila mu ngila. ");
INSERT INTO nkn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesitase uakumbuluile nguendi Paulu vali nakumuniungila mu kamenga ka ku Sesaliya kaha naua ikeye vavenia na singanieka kuhiluka kuje hano vene. ");
INSERT INTO nkn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kaha uahandekele nguendi, “Haliyeni vamo vaje vali na nzili vaye nange, nga kulicimo capihiako kuli uje yala, linga vakamuvangeye mulonga.” ");
INSERT INTO nkn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Hanima yakutumama navo matangua keti akupulakana matangua atanu na atatu cipue likumi, kaha uaile ku Sesaliya, liamukuavo cimene uatumamene ha cituamo cendi cakusompela kaha uashikile vanehe Paulu kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Omo Paulu uahete, Vayunda vaje vahumine ku Yelusalema vamuzengelekele, kuneha milonga hali ikeye, ha viuma vije kuvahanene vukaleho. ");
INSERT INTO nkn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulu ualiamenene ikeye vavenia nguendi, “Naimo yahi ngila injinapokuelamo Lishiko lia Vayunda, cipue kuluisa mu Njivo ya Njambi, cipue kuluisa Sezala.” ");
INSERT INTO nkn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Vuno honi Fesitase, uatondele kuvuahelesa Vayunda kaha uehuile Paulu nguendi, “Nkuma utonda kuya ku Yelusalema linga njikakusompele kuje ha milonga eyi ndi?” ");
INSERT INTO nkn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulu uahandekele nguendi, “Njikemana ku mesho a Sezale, kaha kuje vene munapande kunjisompesa. Nacimo cahi njapihisa kuli Vayunda, nge nove vene muje munatantekeyela. ");
INSERT INTO nkn_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nga njapokola Lishiko nakulinga cuma ca cipi cije cinjinapande kutsila, kaha kunjikalombo kuteua. Vuno honi nga kuhesi vusunga ha milonga eyi ivali nakunjinehela, kaha naumo uahi akanjihana ku mavoko avo. Kaha njikatualaho kulomba kuli Sezale.” ");
INSERT INTO nkn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kaha Fesitase hanima ya kulitavasana na vakakumunangula vendi uakumbuluile nguendi, “Unatuala vimpande viove kuli Sezale, kaha kuli Sezale vene kukeko ukaya.” ");
INSERT INTO nkn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hanima ya matangua amo muene Angilipa na Mbenisi vaile ku Sesaliya kumeneka Fesitase. ");
INSERT INTO nkn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Omo vakele kuje matangua amo, Fesitase uanehele mulonga ua Paulu kuli muene kaha uahandekele nguendi, “Kuli yala kuno yasezele Felekisi mu kamenga, ");
INSERT INTO nkn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","omo njakele mu Yelusalema, vakuluntu vatusasendote navakuluntu va Vayunda vanjilekele via hali ikeye kaha vanjilombele nguavo njimuhane mulonga. ");
INSERT INTO nkn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kaha njavalekele nguange keti kuvutisi yetu va Loma kuhisa muntu uje ivanavangeya mulonga, ntsimu kanda alimone mesho na mesho navaje vanamuvangeya, nakumuhana ntsimbu ya kuliamena ku mulonga uendi. ");
INSERT INTO nkn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kaha omo vezile kuno, kunjeshualele, kaha lia mukuavo njatumamene ha cituamo ca vusompele kaha njashikile uje yala nguange vamunehe kuli yange. ");
INSERT INTO nkn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kaha omo vaka kumuvangeya vemanene, kuvamuhanene mulonga uavupi ngue muje njavandamenene nguange vaka lingamo. ");
INSERT INTO nkn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Vuno honi vakele nakulinga vimpata nendi ha lutsilielo luavo nali yala umo ivatumbuile nguavo Yesu, uje uatsa, vuno honi Paulu anga anjili nakuhandeka nguendi acili nayoya. ");
INSERT INTO nkn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Omuo njahonouele kutondesesa cimpande eci, njamuihuile nguange utonda kuya ku Yelusalema linga vaka musompeleko ha milonga ei. ");
INSERT INTO nkn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Vuno honi Paulu ualombele linga vamuniunge kaha na Sezala linga asinganieke ha mulonga uendi. Kaha njahanene mashiko kuli ikeye linga vamuniunge kuvanga noho njikamutuma kuli Sezale.” ");
INSERT INTO nkn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Angilipa uahandekele kuli Fesitase nguendi, “Njitonda njimuivue yange vavenia ou yala omo a handeka.” Kaha Fesitase uakumbuluile nguendi, “Imene ukamuivua.” ");
INSERT INTO nkn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kaha liamukuavo Angilipa na Mbenisi vezile na kalua kua kama, kaha vakovelele mu njivo muva kakungulukila civunga na vakuluntu va masualale na vamala ava vakakumona via nganda. Kaha Fesitase uashikile linga Paulu vamunehe mukati. ");
INSERT INTO nkn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Kaha Fesitase uahandekele nguendi, “Muene Angilipa na voshe valihano netu, muamono ou yala uje Vayunda voshe kuluisa kuavo hali yange, voshe vamu Yelusalema na vamuno, vali nakutambeka nguavo kapandele kuyoya naua. ");
INSERT INTO nkn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Vuno honi njauanene nguavo nacimo cacipi canalingi cahi oco napandela kutsila kaha omo ualilombelele kuli Sezale, njatondele kumutuma kuli ikeye. ");
INSERT INTO nkn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Vuno honi kunjesi na cimo hali ikeye cinjapandele kusonekela Sezale. Nankuma njamuneha hhakati keni voshe, ngue cikuma kuli yove muene Angilpa, linga, hanima yakutondesesa mulonga uendi, hamo njikala nacimo ca kusoneka. ");
INSERT INTO nkn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Omuo kucikamoneka muacili kuli yange kutuala cinzinda mu kamenga kuakuhona kumonesa mulonga uendi.” ");
INSERT INTO nkn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Angilipa uahandekele kuli Paulu nguendi, “Uli na ntsimbu yakuliamena yove vavenia.” Kaha Paulu uoluele livoko liendi kaha uaputukile kuliamena ikeye vavenia nguendi, ");
INSERT INTO nkn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Muene Angilipa! Njamono nguange njavezika hakuliamena yange vavenia kulitangua lia lelo ku mesho ove ha viuma vioshe vali na kunjivangeya Vayunda, ");
INSERT INTO nkn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Omuo unatantekeya muacili futisi na viula via Vayunda. Nankuma njikulomba unjivuilile mukusimpa. ");
INSERT INTO nkn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","‘Vayunda voshe vatantekeya vati njinayoyo hume kuvukuenje vuange. Vatantekeya kuyoya kuange kuoshe, ha vantu vange na mu Yelusalema. ");
INSERT INTO nkn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ntsimbu yoshe vanatantekeya, nga vatonda kuhana vukaleho ovu, njapuile umo ua civunga ca Vafaliseho vaje vaka kavangeya cikuma ngila ya muje tukalemeselamo Njambi yetu. ");
INSERT INTO nkn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kaha honi njinemana hano linga vanjisompe omuo njahaka lutsilielo mu cikulaheso ca Njambi calingile kuli vakukuilila vetu, ");
INSERT INTO nkn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Aci cikeco cikulaheso cije miyati yetu likumi na ivali cije civatonda kumona cili shulisise omuo yakulemesa Njambi vutsiki na mutania. Muene Angilipa, omuo lualutsilielo olu mukemo Vayunda vali nakunjivangeya evi.’ ” ");
INSERT INTO nkn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Vika muhandekela ngueni cakaluua kuli yetu kutsiliela ngueni Njambi akasangula vatsi? ");
INSERT INTO nkn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Nange vene njasinganiekele kulinga viuma viavingi viakuluisa lizina lia Yesu uaku Nazaleta. ");
INSERT INTO nkn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Evi vikevio njalingile mu Yelusalema. Ha kutambulako nzili kuli vakuluntu vatusasendote, na kuhaka vantu vavengi va Njambi mukamenga, omo vavatsihele nange naua njatavele.” ");
INSERT INTO nkn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Njavazangamesele ha vintimbu viavingi mu vinjivo via malombelo via Vayunda njesekele linga vaviane kutsiliela kuavo. Kaha njanienguele cikuma navo ngeci njaile ku vinganda via vungezi na kuvayandeselako. ");
INSERT INTO nkn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ha mulonga ou njaile ku Ndamasika na nzili yakama cikuma na Lishiko lia kuhuma kuli vakuluntu vatusasendote. ");
INSERT INTO nkn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Yapuile mu ngila omo te litangua lili hakatati kamutue, yove Muene, njamuene ceke cakuviazima cikuma kupulakana litangua cahumine muilu canjizengelekele na vantu vaje njendele navo. ");
INSERT INTO nkn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kaha tuvavoshe tuauililile hamavu, kaha njevuile lizi mu Cihevelu lihandeka kuliyange ngualio, ‘Saulu, Saulu! Vika ulinakunjiyandesela? Ulinakulivulumuna yove vavenia omo ulinakuliamena, ngue ngombe uakulimisa aliatangela ku citi ca muene uendi.’ ");
INSERT INTO nkn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ka njehuile nguange, ‘Yove iya Muene?’ Muene uanjikumbuilile nguendi, ‘Yange Yesu ulinakuyandesa. ");
INSERT INTO nkn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Honi katuka njalisholola kuli yove linga njikuhangule kupua ngamba na mukaleho uange ha viuma evi unamo navije ukamona kulutue. ");
INSERT INTO nkn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Njikakuamena kuli vantu va Isaleli navaje keti Vayunda kuje kunjikakutuma. ");
INSERT INTO nkn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ukatonesa mesho avo na kuvahumisa kumilima na kuvatuala ku ceke nakuvahumisa ku nzili ya satana nakuvatuala kuli Njambi, linga ha kutsiliela kuavo kuli yange vakavasambese ku vupi vuavo nakutambula muhela uavo hakati ka vantu vaje vanahangula Njambi.’ ” ");
INSERT INTO nkn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nankuma Muene Angilipa, njononokele cimona cije njamuene cahumine muilu. ");
INSERT INTO nkn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Vuno honi hakulivanga njambuluile mu Ndamasika, kaha mu Yelusalema ambahoni mu lifuti lia Yundeya, na kati kavaje keti va Vayunda, njambuluile linga vatenguluke ku vupi vuavo nakuhiluka kuli Njambi nakulinga viuma vije vimuesa linga vanatenguluka. ");
INSERT INTO nkn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Omuo ha cuma eci mukemuo vanjikuate Vayunda mu Njivo ya Njambi kaha vatondele kunjitsiha. ");
INSERT INTO nkn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Vuno honi na kulitangua lia lelo Njambi nanjikuasa, nankuma njihana vukaleho vuange kuli yeni voshe, vakuluntu na vanike. Vije vinjihandeka vinapu vimo vije vivahandekele laja tunanguizi va Njambi tua Njambi na Mosesa linga vikalingiue: ");
INSERT INTO nkn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","nguavo Kilistu napande kuyanda nakupua umo uakulivanga kusanguka kuvatsi nakuambulula ceke ca kuovoka kuli Vayunda na kuli vaje keti Vayunda.” ");
INSERT INTO nkn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kaha omo Paulu uakele nakuliamena mungila eyi, Fesitase uatambekele kuli ikeye nguendi, “Ove Paulu unazaluka! Kulilongesa kuove kua cikuma kuli nakukuzaluisa!” ");
INSERT INTO nkn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Vuno honi Paulu uakumbuluile nguendi, “Yove muene Fesitase, kunjazalukile! Vuno honi njili nakuhandeka mezi a cili a vusunga. ");
INSERT INTO nkn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kunjasa kuteua kuhandeka cuma eci kuli Muene Angilipa! Omuo njatentekeya nguange atantekeya cuma eci. Kaha unamonoho cimo hali umo na umo uovo voshe, omuo cuma eci kucalingiuilile muvushueka. ");
INSERT INTO nkn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Muene Angilipa, uatsiliela tunanguizi va Njambi va Njambi? Njazivuka nguange utsiliela!” ");
INSERT INTO nkn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kaha Angilipa uahandekele kuli Paulu nguendi, “Mukantsimbu kakandende uasinganieka nguove uasa kunjipuisa mu kua Yesu?” ");
INSERT INTO nkn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Kaha Paulu uamukumbuluile nguendi, “Cipue njilinge vuasi cipue mu ntsimbu yailaha, lilombelo liange kuli Njambi nguange yove na vaje voshe vali nakunjivuilila lelo vapue ngue munjinapu yange kuhumisako lika aua malienge!” ");
INSERT INTO nkn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kaha Muene uemanene, hamo na nguvulu na Mbenisi na voshe vaje vatumamene navo, ");
INSERT INTO nkn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","kaha omo uapuile nakuya, vahandekele kuli umo na mukuavo, “Ou yala viahi napihisa linga atse cipue va muhake mukamenga.” ");
INSERT INTO nkn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Angilipa uahandekele kuli Felisitase nguendi, “Ou yala napandele kumuecela ngue kaile kuli Sezale.” ");
INSERT INTO nkn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Omo vasinganiekele nguavo tuapande kujavuka nakuya ku Italia, vahanene Paulu na vakuavo vinzinda mu mavoko a Njuliasi mukuluntu ua mpunga ya masualale ua va Loma ije vatumbuile nguavo, “Masualele va Nguvulu.” ");
INSERT INTO nkn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kaha tuakovelele muvuato kuhuma ku Andalamitayame, vuje vavuaheselele cimueja kuya kuvikuma via ku mbonge ya Asiya, kaha vasunuine vuato nakuya. Kaha Alisitakase uje Kamasindonia uahumine ku Tesalonika, uakele hamo netu. ");
INSERT INTO nkn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Liamukuavo tuahete ku Sindone. Kaha Njuliasi uakele na ngozi kuli Paulu kaha uamutavesele kuya kuli vasepa vendi linga vakamuhaneko vukuasi. ");
INSERT INTO nkn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tuahumine ku Sindoni nakuya. Kaha mpunzi yakele nakuhuminina kuje tuakele nakuya kaha tuakele na kukavangeya lika nkundu lia Sepulasi. ");
INSERT INTO nkn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Hanima yakujavuka musinia lia mema a kalunga kuseza Silisha namu Pamefiliya, kaha tuahete ku Maila mu Lisiya. ");
INSERT INTO nkn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kuje mukuluntu uauanene vuato vuahumine ku Alekizandiya vuakele nakuya ku Itali, kaha uatukoveselemo. ");
INSERT INTO nkn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tuajavuile matangua amengiko kamandende kamande kaha tuauanene vukalu vuakama te kanda tuhete ku nganda ya Sinindase. Kaha mpunzi yatuvindikile kuya kulutue, kaha tuasuangesele lika nkundu lia Kelete kuje mpunzi kuyakele na kupekumuka cikuma nakuhita muyehi na cikuma ca Salemone. ");
INSERT INTO nkn_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tuashueniele kuyehe na cikuma na kukaluhua cikuma, kaha tuahete kumutambela uje vatumbuile nguavo Vikuma viakuhona vukalu, keti kulako na nganda ya Laseya. ");
INSERT INTO nkn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kaha tuakele kuje ntsimbu yalaha cikuma omuo kuakele na vukalu muvungenzi vuetu, omuo ntsimbu ino litangua lia ku liumina via kulia linahiti laja. Ngue muavananguile Paulu, ");
INSERT INTO nkn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Nguendi “Yeni vamala njamono nguange vungenzi vuetu kuhuma hano nakuya kulutue vukakala na vukalu, vitenga vili muvuato vi kapihia, kaha naua na vuato vukapihia na miono ikanonga.” ");
INSERT INTO nkn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Vuno honi mukuluntu ua masualale uatavele via mukakuendesa vuato navije viahandele vavenia vuato kupulakana via handekele Paulu. ");
INSERT INTO nkn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kaha cije cikuma kucapuile cacili kukalamo ha ntsimbu ya cisika, nankuma vamala vakele na cizango cakusununa vuato nakueseka kuheta Fonikisi, nga citava, linga tukakaleko ha ntsimbu ya cisika. Fonikisi capuile cikuma camu Kelete cije cakenga mu mbuela ya mu kangombe kayambi na mukunto ya mungangela. ");
INSERT INTO nkn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kaha mpunzi lia lindende liahumine ku mbuela yaputukile kuhuua kaha vaje vamala vasinganiekele nguavo vasa kutualelaho na vutumbe vuavo, linga vakokele lisonga lia vuato nakujavuka kuhita kuyehi na cikuma ca Kelete. ");
INSERT INTO nkn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Vuno honi vuasi vuasi mpunzi yakama ije vatumbuile nguavo, “mpunzi ya mu mbuela ya Ngangela,” ya huuile kuhuma ku ntunda ya nkundu. ");
INSERT INTO nkn_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kaha mpunzi yapupile ku vuato, kaha capuile ca cikalu cikuma kutalesa ntongo ya vuato kuvuizililo vuampunzi, kaha tuecele vuato linga mpunzi ivupekumune. ");
INSERT INTO nkn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kaha mpunzi ya huile omo tuahete ku mbuela ya nkundu lia lindende lije vatumbuile nguavo kaunda. Kaha kuakele vukalu vumo tuasele kukuata kavuato kaje kakandende nakukahaka mu vuato vuakama linga kakale muacili. ");
INSERT INTO nkn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vakokele kaje ka vuato kamandende nakukakutilila helu lia vuato vua kama, ambahoni vakutile vuato vuakama na mikole nakuvushetula cikuma. Vakele na liova cikuma nguavo hamo vuato vukakateya ha mutumbo ualishekeshe lia masima a mema a kalunga kuyehi na cikuma ca Limbiya, linga vavungile vije vintanga viendesele vuato na mpunzi nakuecela vuato linga vupekumuke lika na mpunzi. ");
INSERT INTO nkn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mpunzi yakama cikuma liakele na kuhuua, nankuma, liamukuavo vaputukile kumbangela mundonga vivala vimo vije viakele mu vuato, ");
INSERT INTO nkn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kaha ha litangua lia mucitatu naua vombilile mu ndonga vimo viakulikuasesa ku vuato. ");
INSERT INTO nkn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kaha matangua amangi kutuahasele kumona litangua cipue vintanga ntanga, kaha mpunzi liakele na kuhuua cikuma. Kaha hamamanusuililo kutuakele na lutsilielo lua kuovoloka. ");
INSERT INTO nkn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Omo voshe vakele ntsimbu yailaha kuhona kulia, kaha Paulu uemanene nakuhandeka kuli vakevo nguendi, “Vamala, nga muanjivuilile na kuhona kujavuka kuhuma ku Kelete nga viuma evi ku viapihile na kuzimbala. ");
INSERT INTO nkn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Vuno honi njimilomba honi nguange koleseni, mitima naumo uahi ueni a kazimbalesa muono uendi, kuvanga lika vuato. ");
INSERT INTO nkn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Omuo izau vutsiki kuli yange kunemanene kangelo ka Njambi kuje kunjakundama nauje njikalemesa, ");
INSERT INTO nkn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","kaha uahandekele nguendi, ‘Keti muvue liova, Paulu! Uapande kuimana ku mesho a Nguvulu. Kaha Njambi na kuniungila voshe ava uli nakujavuka navo mu vuato.’ ");
INSERT INTO nkn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kaha likoleseni, vamala, muomu njili na lutsilielo muli Njambi kaha cikalingiua vene ngue omuo vana njilekelele mo. ");
INSERT INTO nkn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Vuno honi mankimba akatutuala ku linkanda limo.” ");
INSERT INTO nkn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Omo vuakele vutsiki vua mu likumi navuuana, tuakele na kuhungumuka mu cisali ca Andiliya, omo vuakele vtsiki kaha va kakujavula vasinganyekele nguavo vuavuno vahete kuntunda. ");
INSERT INTO nkn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kaha vesekele kulova kua mema, kaha vauanene kulova kuapuile mamita makumi auana (40), omo kuahitile ka ntsimbu kakandende naua vesekele kulova kua mema naua, kaha vauanene kulova kua mema mamita makumi atatu. (3 0) ");
INSERT INTO nkn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kaha vakele na liova nguavo vuato vukongumukila ku mavue, nankuma, kaha vasoselele vinkovo viuana mu mema ku ntongo ya kunima ya vuato, kaha vavandamene nguavo kuke vuasi ");
INSERT INTO nkn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vuno honi omo vakakujavula vesekele kuteua kuhuma muvuato, vahakele kavuato kakandende mu mema linga vaje vaya nakuhaka vinkovio vimo ku ntongo ya kulutue luavuato. ");
INSERT INTO nkn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Vuno honi Paulu uahandekele kuli uje mukuluntu na masualale nguendi, “Nga ava vakakujavula kuvakala muvuato kuvasa kuovoka.” ");
INSERT INTO nkn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kaha masualale vavatuile mukole uakuate vuato nakuvueca vuye. ");
INSERT INTO nkn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Omo litangua kanda like Paulu uavalombele voshe valie viakulia nguendi, “Munakala na kuvandamena matangua likumi na auana, kaha ntsimbu yoshe ei kumuakele nakulia viakulia. ");
INSERT INTO nkn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nankuma njimilomba muvoshe mulie viakulia, linga muyoye, omuo naumo uahi a kunongesa cinkambu cakumutue uendi.” ");
INSERT INTO nkn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hanima yakuhandeka evi, uambate mbolo, nakusatsela kuli Njambi ha mesho avo voshe, uaipazuile nakuputuka kulia. ");
INSERT INTO nkn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kaha voshe valisimpisile kaha vambate viakulia valile. ");
INSERT INTO nkn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(Tuvavoshe tuapuile vihita vivali na makumi atanu naua avali na vantu vatanu na umo tuakele muvuato.) (276) ");
INSERT INTO nkn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Hanima yakulia nakukuta, vombilile tiliku mu mema a kalunga linga vuato vuehuke. ");
INSERT INTO nkn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kaha omo kuacele, vakakujavula vamuene vuno honi ku vatantekeyele kuje kuvakele, vuno honi vamuene cinkonde cimo cakele na lishenkavu, kaha vayonguele nguavo nga citava, vapande vakatutike vuato kuje kulishenkavu. ");
INSERT INTO nkn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nankuma vavatuile vinkovo nakuviseza vivombele mu mema, kaha ha ntsimbu ije vene vazituile mikole ije yakele ku vilapo vije viendesele vuato. Ambahoni vajuinduile vintanga vije viendesele vuato na mpunzi vije viakele kulutue lua vuato linga mpunzi lipekumune vuato kulutue, kaha tuasungamene ku cikuma ");
INSERT INTO nkn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Vuno honi vuato vuapupile ha mutumbo ua mushekesheke lia ha cimbaluila lia mema, kaha vuakakatele, kaha kuyahasele kushuena, ha ntsimu ijevene ntongo ya kunima ya putukile kutavozoka vimbazivuila-mbazivuila na nzili ya mankimba. ");
INSERT INTO nkn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vutumbe vua masualale vatondele kutsiha vinzinda, linga cipue naumo napandele kuteua. ");
INSERT INTO nkn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Vuno honi mukuluntu ua masualale, uazangele kuyoyesa Paulu, uavavindikile kulinga vutumbe vuavo. Uashikile voshe vaje vahonele kutana linga vatumbuke muvuato cakulivanga kaha vatane nakuya ku ntunda, ");
INSERT INTO nkn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","kaha voshe vaje vasaleleho vavakave, valikuatele ha mavaya vamo valikuatele kuviuma vije via pokuozokele ku vuato. Kaha voshe vahete muacili kuntunda. ");
INSERT INTO nkn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Omo tuhete ku ntunda kuhona vukalu, tuauanene ngeci linkanda lije vatumbuile nguavo Melita. ");
INSERT INTO nkn_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Vavenia Vaje vakele kuje vakele na ngozi netu. Kaha kalunga uaputukile kunoka, kaha kuakele lisika kujevene, vatuvuekelele tuhia nakututambula muacili tuvavoshe. ");
INSERT INTO nkn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kaha Paulu uakunguiye mukuta uavikuni, kaha omo uahakele vije vikuni acoto, uje linoka akuivua ku yukuma uahumine muje mutuhia na kumushuma nakuniengelela ku livoko liendi. ");
INSERT INTO nkn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Vavenia Vaje vakele kuje vamuene uje linoka ali nakuniengela ku livoko lia Paulu, vali handekesele umo na mukuavo nguavo, “Cili vene ou yala napande mu ka kutsiha, cipue vene novoka kumema njambi uje uazangamesele vantu kuvipi viavo akalinga ngeci atse.” ");
INSERT INTO nkn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Vuno honi Paulu uamiakelele uje linoka mu tuhia kuakuhona kuvetua. ");
INSERT INTO nkn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vamutalelele hamo a nzimba vuasi cipue kuuila hamavu na kutsa. Vuno honi omo vavandamenene ntsimbu yakama kuakuhona kumona cuma cimo cacikalu calingiuile kuli ikeye, kaha vatenguluile visikanieka viavo, na kuhandekele nguavo, “Napu njambi.” ");
INSERT INTO nkn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kaha kuyehi namutambela uje kuakele mehia a Pambiliase, muene ualije linkanda. Uatutambuile muacili, kaha tuampuile tu vangezi vendi matangua atatu. ");
INSERT INTO nkn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Kaha ishe ya Pambiliase uakele mu mulili uendi na kuvavala cikuma masika sika na kuhuma maninga. Kaha Paulu uakovelele mu mulili uendi, ualombelele kaha uasalekele mavoko endi hali ikeye nakumukakuisa. ");
INSERT INTO nkn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Omo eci calingiuile, voshe vaje vakakuvavala vamuje mu linkanda vezile, kaha vakangukile. ");
INSERT INTO nkn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Vatusingimikile cikuma, kaha omo tuasunuine vuato, vahakele mu vuato vioshe vije tuatondele a vungenzi vuetu. ");
INSERT INTO nkn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kaha omo kuetile vingonde vitatu tuakovelele mu vuato vua humine ku Alekizandiliya, vuje vatumbuile nguavo, “Vanjambi va Vana vampasa,” vuje vuakele kuje cisika coshe muje mu nkundu. ");
INSERT INTO nkn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tuahete mu nganda ya Silakuse, tuakele kuje matangua atatu. ");
INSERT INTO nkn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuhuma kuje tuajavukile mu vuato nakueta mu nganda ya Lendile. Kaha liamukuavo naua mpunzi ya shangumukile kuhuma ku mbuela, kaha mu matangua avali tuahete mu nganda ya Puteoli. ");
INSERT INTO nkn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kuje tuauanene va kakutsiliela vamo vaje vatulombele kukala navo matangua atanu na avali. Kaha tuete ku Loma. ");
INSERT INTO nkn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kaha vakakutsiliela va mu Loma omo vovuile nguavo tunete, vezile kuhuma ku vinganda viakulako via kulandesela via Apiyase na vinjivo vitatu via vangezi mukuliuana netu. Omo Paulu uavamuene, kaha uatsatselele kuli Njambi nakulikolesa. ");
INSERT INTO nkn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Omo tuahete mu Loma, Paulu vamutavesele kukala mua lika liendi lika amo na lisualale muka ku muniuka. ");
INSERT INTO nkn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ha matanga atatu uasanene vakuluntu voshe vayunda linga valiuane hamo. Omo valiuanene hamo, uendekele kuli vakevo nguendi, “Vakuetu vaku Isaleli, cipue ngoco kunjalingile cimo ca kuluisa vantu cipue futisi ije ituatambuile kuli vakukuluila vatu, vuno honi vanjikutile Mu Yelusalema nakunjihana kumavoko a Valoma. ");
INSERT INTO nkn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Omo vanjihuile, Valoma vatondele kunjecela, omuo kuvauanene cuma cimo cije cinjalingile cije cinjapandela kutsila. ");
INSERT INTO nkn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Vuno honi omo Vayunda vavianene eci, kaha canjilingisile linga njituale cimpande cange kuli Sesale, cipue yange kunjauanenene vantu vange mulonga. ");
INSERT INTO nkn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Omuo ha cuma eci mukemuo njamisanene linga njimimone nakuhandeka neni. Yange njili mu malienge aua omuo lizina liou uje muvanatsiliela vantu va Isaleli.” ");
INSERT INTO nkn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kaha vahandekele kuli ikeye nguavo, “Kutuatambuile mikanda yakuhuma ku Yundeya ya hali yove, cipue kuno kukuezile umo ua vamuanetu kuhuma kuje na muzimbu umo, cipue kuhandeka via vipi hali yove. ");
INSERT INTO nkn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Vuno honi tutonda kutantekeya viyongola viove, omuo tuatantekeya nguetu kuoshe kuoshe vantu valinakuhandeka viakuluisa civunga eci cije mu uli.” ");
INSERT INTO nkn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nankuma, vahanguile litangua liakuliuana na Paulu. Kuhuma ku cimene kuheta ku cinguezi uavalumbunuinine muzimbu uendi ua Vumuene vua Njambi, kaha uesekele kuvalumbunuina vukaleho vua Yesu ha kuvaleka mezi a mu Lishiko lia Mosesa na mezi a mu visoneka via tunanguizi va Njambi tua Njambi. ");
INSERT INTO nkn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vamo vatavele mezi endi, vuno honi veka kuvatsilielelele. ");
INSERT INTO nkn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nankuma, vaile oku valinakuliviana hakati kavo, omuo Paulu nahandeka navo cuma eci nguendi, “Cimbembesi Uakulela cahandekele vusunga kuli vakukuluila veni hali kananguizi Isaya! ");
INSERT INTO nkn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Omo uahandekele nguendi, ‘Ya ukahandeke kuli vantu ava nguove, kuivua mukevuilila, vuno honi kumukevuisisa, kumona mukamona, vuno honi kumukamonesesa. ");
INSERT INTO nkn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Omuo mitima ya vantu ava inapu yakuzeya, vanaziki matuitui avo, kaha vanalalameka na mesho avo. Kuteua mesho avo amona, na matuitui avo evua, kaha mana avo akevua, kaha vakatengulukila kuli yange, mukemo mualinakuhandeka Njambi, kaha njikavakanguisa.’” ");
INSERT INTO nkn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kaha Paulu uamanesele kuhandeka nguendi, “Munapande kutantekeya ngueni muzimbu ua Njambi uakuovola vanautumu kuli vaje keti Vayunda. Kaha vakauivuilila!” ");
INSERT INTO nkn_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Omo Paulu uamanesele kuhandeka mezi aua, Vayunda vamusezele oku valinakulinga vimpata viakama hhakati kavo vavenia. ");
INSERT INTO nkn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulu uakele kuje miaka ivali mu njivo yakulifuetela ikeye vavenia, kaha uakele nakutambula voshe vaje vezile kuli ikeye nakumumona. ");
INSERT INTO nkn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Uambuluile via vumuene vua Njambi nakulongesa via Muene Yesu Kilistu nakusimpa na mutima uakupatuka.");
INSERT INTO nkn_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yange Paulu, ndungo ya Yesu Kilistu na kanganda uje yahanguile nakunjisana kuli Njambi mukuambulula Muzimbu uendi Uacili. ");
INSERT INTO nkn_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Njambi uakulahesele laja Muzimbu Uacili kuhitila muli tunanguizi va Njambi vendi, nge muvanavisoneka mu Visoneka via Kulela. ");
INSERT INTO nkn_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Vinapu via Munendi, ngue ku vuyoye vuendi vua ha mavu, uasemukile ku ntanga ya Ndaviti, ");
INSERT INTO nkn_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","kuhitila mu Cimbembesi Uakulela Yesu vamumuesele na nzili yakama kupua Muna Njambi omo vamusanguile ku vatsi. ");
INSERT INTO nkn_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kuhitila muli Yesu tuatambuile kavumbi na vunganda linga tusane vaje keti Vayunda linga vononoke kulutsilielo omuo ya lizina liendi. ");
INSERT INTO nkn_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kaha neni naua munapu vamo hhakati kavaje keti Vayunda vaje vavanasana linga vakundame kuli Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nankuma, njilinakusonekela kuli yeni voshe muli mu Loma vaje Njambi vazanga nakumisana linga mupue vantu vendi vakulela. Njambi Tatetu na Muene Yesu Kilistu vamihane kavumbi na ciyulo. ");
INSERT INTO nkn_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Cakulivanga, njitsatsela kuli Njambi yange kuhitila muli Yesu Kilistu hali yeni voshe, omuo lutsilielo lueni lunatsimana ha mavu oshe. ");
INSERT INTO nkn_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Njambi ikeye mukaleho uange linga vije vioshe vinjihandeka vinapu via vusunga, Njambi uje injili nakupangela na mutima uange uoshe mukuambulula Muzimbu Uacili ua Munendi. Njambi natantekeya ngeci njikamianuka, ");
INSERT INTO nkn_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ntsimbu yoshe mu malombelo ange njikalombo nguange Njambi mu cizango cendi nga atava njije kuli yeni nakumimeneka. ");
INSERT INTO nkn_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Njishunguiya cikuma kumimona, linga njakumihaneko vuana vua mu Cimbembesi mukumitakamesa. ");
INSERT INTO nkn_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Hano njilumbununa ngeci yeni nange tuakulikolesa ha ntsimbu imolika, yeni ha lutsilielo luange kaha nange ha lutsilielo lueni. ");
INSERT INTO nkn_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Vavusamba vange, munapande kuvuluka ngueni vintsimbu viavingi njakele na vutumbe vuakuija oko nakumimeneka, vuno honi kuli cuma cimo cinanjivindika. Njitonda kukoka vantu hhakati keni ngue munjinalingi hhakati ka vaje keti Vayunda. ");
INSERT INTO nkn_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Njilina likongo lia vipangi hhakati ka vantu voshe, kuli Vangelengu na ava keti Vangelengu, na kuli vaka kunangula na vilema. ");
INSERT INTO nkn_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nankuma, njitonda cikuma kuambulula Muzimbu Uacili nakuli yeni naua muakala mu Loma. ");
INSERT INTO nkn_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kunjesi na shuamua ya kuambulula muzimbu uacili, omuo unapu nzili ya Njambi ije ineha kuovoka kuli vaje voshe vatsiliela, hakulivanga kuli Vayunda, kaha naua na kuli Vangelengu. ");
INSERT INTO nkn_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Omuo muli likelio vusunga vua Njambi vanavusholola kuhitila mulutsilielo ngue muvihandeka visoneka nguavio, “Muntu uje ivanapuisa muka vusunga ku mesho a Njambi ha lutsilielo akayoya.” ");
INSERT INTO nkn_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Vutenu vua Njambi vunasholoka kuhuma muilu nakuluisa vupi vuoshe na vilinga via kupihia via vantu vaje vilinga viavo viavipi vivindika vusunga linga keti vavutantekeye. ");
INSERT INTO nkn_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Omuo vije vineha nguavo linga vatantekeye Njambi vinasholoka, omuo Njambi navisholola kuli vakevo. ");
INSERT INTO nkn_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Hume haje Njambi hatangelele mavu, vifua viendi vije kutuasa kumona, nzili yendi ya yaye na cifua cendi ca Vunjambi vinasholoka muacili, vantu vasa kuvitantekeyela mu viuma vije vianalingi Njambi. Nankuma, vantu ava kuvasa kulisambuesa kuahi. ");
INSERT INTO nkn_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Cipue vene vatantekeyele Njambi, vuno honi kuvamusingimikile cipue kumuhana citsatsela. Vuno honi visinganieka viavo vinapu viangoco kaha na mitima yavo yamupulungua inashulu na milima. ");
INSERT INTO nkn_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Vakahandeka nguavo vanapu vaka mana, vuno honi vanapu vilema, ");
INSERT INTO nkn_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","kaha vanalikela kulemesa uje kekutsa, nakulemesa viuma via vifua via vuntu vije kuviekuyoya miaka yoshe na vifua via tuzila cipue tusitu cipue viakulikoka. ");
INSERT INTO nkn_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nankuma, Njambi navecelela linga valinge viuma via mazilo ngue ku mashungu a mitima yavo, kaha valinga viuma via shuamua kuli umo na mukuavo. ");
INSERT INTO nkn_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Vanaviana kutsiliela vusunga vua Njambi, kaha vanatsiliela makuli nakulemesa nakupangela vije vianatanga Njambi kuhona kulemesa vavenia uje uavitangele, uje ivanapande kushangazala miaka yoshe ya yaye! Ameni. ");
INSERT INTO nkn_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Omuo ha cuma eci, Njambi navecela linga valinge viuma via shuamua ngue ku mashungu avo. Cipue vampuevo vanatenguluka kulinga vilika na vamala mu ngila ya cisemua, vuno honi valinakuvilinga mu vingila vije kuviapandelemo. ");
INSERT INTO nkn_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Kaha mu ngila imo naua vamala vanatenguluka kulinga vilika na vampuevo mu ngila ya cisemua, vuno honi valinakulinga vukoyi na vakuavo vamala. Vamala vali nakulinga viuma via shuamua kuli umo na mukuavo, kaha ha cuma eci vanatambula fueto inavapande omuo ya vilinga viavo viavipi vije vivanalingi. ");
INSERT INTO nkn_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Omuo vantu ava vanaviana kuniunga vusunga vuakuivuisisa Njambi mu viyongola viavo, Njambi navecelela linga vakale na mana a api, linga valinge viuma vije kuvapandele kulinga. ");
INSERT INTO nkn_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vanashulu na viuma vioshe via mazilo na vipi na lizangamena na cizindo, vanashulu na cipululu nakutsiha na luozi na makuli na lizangamena. Vakafueye, ");
INSERT INTO nkn_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","nakuhandeka viavipi hali umo na mukuavo, vanapu vakakuzinda Njambi, vaka likamba, vaka kulihalesa, kaha vaka kulipamba, vayongola vingila viavingi viakupangelamo vupi, kuvekuononoka visemi vavo, ");
INSERT INTO nkn_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","kuvekuvuisisa, kuvekuniunga vikulaheso viavo, kaha kuvekumuesa ngozi cipue kuvuila vakuavo cikeketima. ");
INSERT INTO nkn_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Cipuevene vatantekeya nguavo kusompa kua Njambi kuhandeka nguanguo vantu vaje vayoya mu ngila eyi vanapande kutsa, keti lika viuma evi valinakutualelelaho kulinga kuahi, vuno honi naua vacilitavasana na vaje vakakuvilinga. ");
INSERT INTO nkn_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yove kavusamba kange, nkuma ukasompo vakueni ndi? Kuli yove kukuesi kusambua, cipue vene yove iya. Nga yove usompa vakueni kaha ulinga viuma vije vivalinga vakevo, ulinakulihisa yove vavenia. ");
INSERT INTO nkn_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tuatantekeya ngeci kusompa ca Njambi capua ca vusunga ha vantu vaje valinga viuma via vipi. ");
INSERT INTO nkn_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nkuma omo yove, muntu lika, usompa vakueni kaha naua ukalingi viuma vije vivakalingi, uayongola nguove uasa kuputumuka ku kusompa ca Njambi ndi? ");
INSERT INTO nkn_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Cipue ulinakukehesa ngozi yendi yakama na kulongua cendi na kusimpa cendi. Muavusunga utantekeya nguove Njambi uakala na ngozi omuo alinakueseka kukutuamenena linga utenguluke. ");
INSERT INTO nkn_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Vuno honi omuo ya mutima uove uakukola nakukaluua, kaha ulinakulingisa cihiso cove linga cipue cakama ha Litangua lije omo vutenu vua Njambi nakusompa cendi ca vusunga vikasholoka. ");
INSERT INTO nkn_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Njambi akahana vuana ku muntu na muntu kuya kuvipangi viendi vije vianalingi. ");
INSERT INTO nkn_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vamo vantu vali nakutualelelaho kulinga muacili, nakutonda vumpau na kasingimiko na muono uje kuuekutsa, kuli vakevo Njambi akavahana muono ua yaye ya yaye. ");
INSERT INTO nkn_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Vuno honi vamo vantu valizanga vakevo vavenia nakuviana via vusunga nakukava vije viakupihia, kaha Njambi akamuesa vutenu vuendi na matoto endi hali vakevo. ");
INSERT INTO nkn_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kukakala tuyando nalamba kuli vantu voshe vaje valinga vupi, hakulivanga kuli Vayunda kaha naua nakuli Vangelengu. ");
INSERT INTO nkn_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Vuno honi Njambi akahana vumpau na kasingimiko na ciyulo kuli voshe vaje valinga muacili, hakulivanga kuli Vayunda kaha naua na kuli Vangelengu. ");
INSERT INTO nkn_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Muafua Njambi kakele nacivembulu. ");
INSERT INTO nkn_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Vaje keti Vayunda vaje kuvesi na lishiko lia Mosesa, valinga vupi kaha vazimbala omuo liakuhona lishiko. Vayunda vaje vali na lishiko, valinga vupi kaha vavasompa na lishiko. ");
INSERT INTO nkn_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Muafua keti hakuvua lika lishiko lia Mosesa ngeci vantu vavapuisa vaka vusunga kuli Njambi, vuno honi vaje vononoka lishiko lia Mosesa vakavatumbula nguavo vaka vusunga. ");
INSERT INTO nkn_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Cilivene vaje keti Vayunda kuvakele na lishiko lia Mosesa, vuno honi vioshe vivakalingi na mana aje muaya lishiko lia Mosesa, vakevo vavenia vanapu lishiko liavo, cipuevene kuvakele na lishiko lia Mosesa. ");
INSERT INTO nkn_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Cifua cavo cimuesa ngeci vije lishiko lia Mosesa lishika vanavisoneka mu mitima yavo. Kaha naua na vilinga viavo vimuesa ngeci viuma evi vinapu via vusunga, omuo vintsimbu vimo viyongola viavo vikavahisa kaha naua vintsimbu vikuavo vikavamena. ");
INSERT INTO nkn_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Kaha ngue kuya ku Muzimbu Uacili unjilinakuambulula, omu mukemo mucikafua ha Litangua lia Kusompa lije omo Njambi akahisa viyongola viavushueke via vantu voshe kuhitila muli Yesu Kilistu. ");
INSERT INTO nkn_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Honi yove, nga ulitumbula yove vavenia nguove nji Kayunda, nga uajendamena ha Lishiko lia Mosesa nakulipamba hali Njambi, ");
INSERT INTO nkn_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kaha unatantekeya vika Njambi atonda linga uvilinge, kaha unalilongesa ku lishiko lia Mosesa kuhangula vije vinapu vusunga, ");
INSERT INTO nkn_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","kaha unatantekeya muacili ngeci yove unapu ntuama ua tupuputua, naua ceke kuli vaje vali mu milima, ");
INSERT INTO nkn_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","unapu umuka kusungamesa vilema, naua mulongisi ua vaje vali kunzimba. Uatantekeya muacili nguove mu lishiko lia Mosesa unauanamo mana akushula na vusunga. ");
INSERT INTO nkn_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ukalongesa vakueni, nkuma vikahoni kulilongesela yove vavenia? Ukambulula nguove, “Keti muive.” Vuno honi yove vika ukevila? ");
INSERT INTO nkn_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ukahandeka nguove, “Keti mulinge vupangala.” Nkuma yove vika ukalingila vupangala? Uazinda tumponia, nkuma ukevi via mu vinjivo viakulemesela tumponia ndi? ");
INSERT INTO nkn_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ukalishasha ha lishiko lia Njambi, vuno honi kuuekuvuisa Njambi shuamua omo upokola lishiko liendi ndi? ");
INSERT INTO nkn_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Visoneka vihandeka nguavio, “Omuo yeni Vayunda, nankuma, vaje keti Vayunda vashaula Njambi.” ");
INSERT INTO nkn_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nga muononoka lishiko, kulovoka ceni cili na seho, vuno honi nga kumuononoka lishiko, mukapua cilivene ngue kumualovokele. ");
INSERT INTO nkn_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nga vaje keti Vayunda, vaje kuvatuhukile, vononoka vije lishiko lia Mosesa lilinakushika, nkuma Njambi kakavaniungu ngue vaka kulovoka ndi? ");
INSERT INTO nkn_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kaha yeni Vayunda vakamihisa kuli vaje keti Vayunda omuo mukapokola lishiko lia Mosesa, cipuevene vanamisonekelalio kaha naua muapua muvaka kulovoka, vuno honi vakevo valinakuononoka lishiko cipuevene kuvatuhukile ku cisemua. ");
INSERT INTO nkn_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Munima yavioshe evi, iya Kayunda ua vusunga, uje uakulovoka muavusunga? Keti muntu uje ikeye Kayunda hambanza lika, uje kulovoka cendi kunapu kua muvila lika. ");
INSERT INTO nkn_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Vuno honi Kayunda ua vusunga ikeye muntu uje Kayunda mukati, uje mutima uendi unalovoka, kaha eci cinapu cipangi ca Cimbembesi ca Njambi, keti ca lishiko liakusoneka. Muntu ua cifua eci Njambi amushangazala, keti vantu kuahi. ");
INSERT INTO nkn_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nkuma Vayunda vanapulakana vaje keti Vayunda ndi? Cipue nkuma kulovoka cili na seho ndi? ");
INSERT INTO nkn_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Cuma cakama cikuma mu vingila vioshe! Mu cihela cakulivanga, Njambi uakundikile lizi liendi kuli Vayunda. ");
INSERT INTO nkn_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Vuno honi vatihoni nga vamo vavo kuvapuile vakulongua? Nkuma eci cilumbunuka ngue Njambi keti muka kulongua ndi? ");
INSERT INTO nkn_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Houe keti ngoco! Njambi napande kupua ua kulongua, cipue vantu voshe vapua vaka makuli. Ngue muvasoneka mu visoneka nguavo, “Unapande kusholoka muka kulongua omo uhandeka, unapande kuhiana mulonga uove omo vakusompa.” ");
INSERT INTO nkn_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Vuno honi nga vilinga vietu viakupihia vije vituli nakulinga visholola muacili vusunga vua Njambi, nkuma tuasa kuhandeka nguetu Njambi akalingi muamupi omo atuhana kashitiku ndi? (Njilinakuhandeka mucifua ca vuntu.) ");
INSERT INTO nkn_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Houe keti ngoco! Nga Njambi keti ua kulongua, kaha vatihoni asompa vaka mavu? ");
INSERT INTO nkn_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Vuno honi nga makuli ange amuesa vumpau vua Njambi hakusholola vusunga vuendi muacili, omuo vika naua hanga vacinjisompa ngue muka vupi? ");
INSERT INTO nkn_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kaha vikahoni kumuhandekela ngueni, “Tulingeni vupi linga vucili vusholoke?” Cilivene, vantu vamo vali nakunjishaula nakunjivangeya nguavo njinahandeka cuma eci! Vakavahisa ngue mucinapandelamo. ");
INSERT INTO nkn_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Vatihoni, nkuma yetu Vayunda tunapu tuvacili kupulaka Vangelengungu ndi? Keti ngoco kuahi! Omuo njamilekele laja nguange Vayunda na Vangelengu voshe vali mu nzili ya vupi. ");
INSERT INTO nkn_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ngue muvasoneka mu visoneka nguavo, “Naumo uahi muka vusunga, ");
INSERT INTO nkn_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","naumo uahi ali na mana cipue muka kulemesa Njambi. ");
INSERT INTO nkn_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Voshe vanatenguluka kuhuma kuli Njambi, voshe vanalingi vupi, naumo uahi akalingi cuma ca vusunga. ");
INSERT INTO nkn_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Majui avo anashulu na vusungu vua makuli, vindaka viavo vihandeka makuli, tunua tuavo tuhandeka mezi akupihia ngue vusungu vua linoka. ");
INSERT INTO nkn_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Hendekesi yavo inashulu na visingo via kushasha. ");
INSERT INTO nkn_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Vakazambula kuvulumuna na kutsiha vakuavo, ");
INSERT INTO nkn_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","mu vingila viavo muli kupihisa na kunongesa. ");
INSERT INTO nkn_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ku vatantekeya ngila ya ciyulo, ");
INSERT INTO nkn_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","kaha na mu mesho avo kuvekuivuila Njambi liova.” ");
INSERT INTO nkn_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Honi tuatantekeya ngeci viuma vioshe mu lishiko viakundama kuli vaje vali mu lishiko, mukuvindika kulisambuesa kuoshe kua vantu nakuneha vantu voshe kukusompa ca Njambi. ");
INSERT INTO nkn_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Omuo naumo uahi napu muka vusunga ku mesho a Njambi mukulinga vije lishiko litonda, vipangi via lishiko vikevio vinapu kuleka yetu linga tutantekeye nguetu tu vaka vupi. ");
INSERT INTO nkn_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Vuno honi ngila ya Njambi yakupuisa vantu linga vapue vaka vusunga ku mesho endi inasholoka. Kuyesi nacimo na lishiko, cipue lishiko lia Mosesa na tunanguizi va Njambi vahanene vukaleho hali likelio. ");
INSERT INTO nkn_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Vusunga vua Njambi kuhitila mu lutsilielo muli Yesu Kilistu kuli voshe vaka kutsiliela. Omuo kukuesi kahangu kahi, ");
INSERT INTO nkn_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","vantu voshe vanalingi vupi, kaha vakelekulahako na vumpau vua Njambi. ");
INSERT INTO nkn_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Vuno honi vanavapuisa vaka vusunga kuli Njambi ha vuana vua kavumbi ka 