﻿USE sofia;
DROP TABLE IF EXISTS sofia.njd_vpl;
CREATE TABLE njd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES njd_vpl WRITE;
INSERT INTO njd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gangani nga mahina ga chilagwa cha Ayesu Kilisto, mwana bha Adaudi na mwana bha Aaibulahimu, ");
INSERT INTO njd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aaibulahimu bhakaabheleka Aisaka, na Aisaka bhakaabheleka Ayakobo, na Ayakobo bhakaabheleka Ayuda na akaanung'una bhabhenji, ");
INSERT INTO njd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ayuda bhakaabheleka Apelesi na Azela yakubhehe anyongo bhabhenji bhakibha Atamali, na Apelesi bhakaabheleka Ahesilomu, na Ahesiloni bhakaabheleka Aalamu. ");
INSERT INTO njd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aalamu bhakaabheleka Aaminadabu, na Aaminadabu bhakaabheleka Anashoni, na Anashoni bhakaabheleka Asalumoni, ");
INSERT INTO njd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Asalumoni bhakaabheleka Aboazi, na anyongo bhabhe Aboazi bhakibha Alahabu, Aboazi na Alutu bhakiabhanga akaabhelei bha Aobedi, na Aobedi bhakaabheleka Ayese, ");
INSERT INTO njd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ayese bhakaabheleka amwana yakubhehe bhakibha Amwenye Adaudi. Adaudi bhakaabheleka Asolomoni, yakubhehe anyongo bhabhe nga bhenibhala bhabhakibha hanu bha Aulia. ");
INSERT INTO njd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Asolomoni bhakaabheleka Alehoboamu, na Alehoboamu bhakaabheleka Aabiya, na Aabiya bhakaabheleka Aasa, ");
INSERT INTO njd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa bhakaabheleka Ayehoshafati, na Ayehoshafati bhakaabheleka Ayolamu, na Ayolamu bhakaabheleka Auzia, ");
INSERT INTO njd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Auzia bhakaabheleka Ayotamu, na Ayotamu bhakaabheleka Aahazi, na Aahazi bhakaabheleka Ahezekia, ");
INSERT INTO njd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ahezekia bhakaabheleka Amanase, na Amanase bhakaabheleka Aamoni, na Aamoni bhakaabheleka Ayosia, ");
INSERT INTO njd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ayosia bhakaabheleka Ayekonia na akaanung'una bhabhenji. Gono gukibha muda Bhayahudi chibhakakumukanga kuhamilanga ku Babeli. ");
INSERT INTO njd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bhayahudi pabhakibhanga kuubhanda ku Babeli, Ayekonia bhakaabheleka amwana Ashelitieli, na Ashelitieli bhakaabheleka Azelubabeli, ");
INSERT INTO njd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Azelubabeli bhakaabheleka Abiudi, na Abiudi bhakaabheleka Aeliakimu, na Aeliakimu bhakaabheleka Aazoli, ");
INSERT INTO njd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aazoli bhakaabheleka Azadoki, na Azadoki bhakaabheleka Aakimu, na Aakimu bhakaabheleka Aeliudi, ");
INSERT INTO njd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aeliudi bhakaabheleka Aeleazali, na Aeleazali bhakaabheleka Amatani, na Amatani bhakaabheleka Ayakobo, ");
INSERT INTO njd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na jonojwe Ayakobo akaabheleka Ayusufu, na habha Ayusufu akibha hangwana bhabhe Amalia, na habha Amalia nga jwakaabheleka Ayesu, bhakemitwa Kilisto. ");
INSERT INTO njd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bahi, penapo kukabhehe na ibhelei komi na ncheche kubhoka Aaibulahimu mpaka Adaudi, ibhelei komi na ncheche kubhoka Adaudi mpaka Bhayahudi chibhakatolekwa akaabhanda ku Babeli, na ibhelehi komi na ncheche kubhoka kutolekwa akaabhanda mpaka muda gwa kubhelekwa kwa Kilisto. ");
INSERT INTO njd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bahi, kubhelekwa kwa Ayesu Kilisto kukabhehe henela, Amalia anyongo bhabhe Ayesu bhakibha bhalombwite na Ayusufu. Nambo bhakibha tangu bhakakongana na kutama pamo handa analome na haikege, Amalia bhakabhonekana bhabhi na chitumbo kwa uwecho gwa Mboomo ja Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwa kubhehe Ayusufu nga hanalome bhabhakibha bhaalombite Amalia bhabhakibha amundu bha majendelo gammbone, bhangapala kwaalekela honi palundwaje, henela bhakapala kwaaleka kwa kuchiiya. ");
INSERT INTO njd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pabhakibha tangu bhatenda kuganikia ngani hejo, antumichi bha kumahunde bha Hangwana bhakaabhokela mu agamii, na kwaalobholela, “Ayusufu, amwana bha Adaudi, nkotokujogopa kwaapetula Amalia bhabhe hanu bhinu, maana gakwe bhatekola chitumbo kwa uwecho ga Mboomo Ja Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na bhenabho bhapakuchijogola mwana mwanalome, mpakunkema lihina lyabhe Ayesu, maana gakwe bhenabho nga bhapakwabhohanga bhandu bhabhe mu mabhou gabhenji.” ");
INSERT INTO njd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bahi, genego goha gapitila ili likweele lyela lilobhe lya Hangwana lilikalongelwa kwa ndela ja alondohi kubhee, ");
INSERT INTO njd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwaali bhangaamanya analome bhapakola chitumbo na bhapakubheleka mwana mwanalome, na bhenebho bhandu bhapakwaakema liina Aemanueli” Maana gakwe, “Annoongo pamo na tweenga” ");
INSERT INTO njd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Henela, Ayusufu bhakajimuka kubhoka mu lugono na bhakatenda handa antumichi bha kunani kulihunde bha Annoongo chibhakaalobholela, bhakaapetula Amalia kubhee hanu bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambo Achupu bhangatyanga nabho Amalia mpaka chibhakachijogola mwana mwanalome, na bhenabho Achupu bhakaapekea amwana bhenabho lihina lyakwe Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ayesu bhakabhelekwa ku chilambo cha ku Betelehemu, ku nkoa gwa ku Yudea, gono muda Ahelode bhakibha Amwenye. Mala tu baada ja kubhelekwa kwabhe, bhandu bha kumanyanga ngani ja ndondwa kubhoka kuulabho bhakahikanga ku Yelusalemu, ");
INSERT INTO njd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bhakakonyanga, “Bholi, habhi koji mwana jwaabhelikwe, Amwenye bha Bhayahudi? Tujilolite ndondwa jabhe kubhoka kuulabho, na tweenga tuhikite pambani kwaalumbalila.” ");
INSERT INTO njd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amwenye Ahelode pabhakajoha genego, bhakahechuka, bhenabho pamo na bhandu bhoa bhabhatamanga ku Yelusalemu. ");
INSERT INTO njd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Amwenye Ahelode bhakaakemanga pamo akaakolo bha akaakung'i na bhabhajigana bhandu bha malagilo ga Amusa, bhakakonyanga, “Akilisito bhabhelikwe koji?” ");
INSERT INTO njd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na bhenabho bhakaajangula, “Mu chilambo cha ku Betelehemu, ja ku Yudea, kwa kubhee henela nga chiikajandikwa na alondohi bha Annoongo kubhee, ");
INSERT INTO njd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mwe chilambo cha ku Betelehemu Mwenga ngabha mwachoko choko pakati ya hilambo hikolongwa ya ku Yudea, ligongo kwinu bhapakupitila chilongola bhapakwalongolea bhandu bhangu bha ku Isilaeli.’” ");
INSERT INTO njd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Penapo Ahelode bhakaakemanga bhenibhala bhakumanyanga ngani ja ndondwa kwa kuchihiya na kwaakonyanga, muda chibhakajibhona ndondwa. ");
INSERT INTO njd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Penapo bhakaalagikia bhajendange ku Betelehemu bhabhi kwaalobholelanga, “Nnyahulange nkaalolekeange maha ngani ya jono mwana. Na handa mumpatite, nnetelange ngani jabhe ili nanenga ngombole kujaula kwaachalila.” ");
INSERT INTO njd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pabhakajomolanga kwaajohanikia Amwenye, bhenibhala bhakumanyanga ngani ja ndondwa bhakajaula, na jela ndondwa chibhakajilola kuulabho jikaalongolela, na jikajema nnani ja penipala pabhabhile mwana. ");
INSERT INTO njd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pabhakajilola jene ndondwa, bhakaachukilanga muno. ");
INSERT INTO njd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pabhajingilanga nkati ja jenijela nyuumba, bhakaabhona mwana pamo na Amalia anyongo bhabhe, bhakatindibhala majugwa, bhakanchalila. Ngapena bhakajogolanga mihuko jabhenji na kwaapekea ngwahupa ja bunyu, ubhani na mahuta ga bei ngolongwa gakemitwa manemane. ");
INSERT INTO njd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na Annoongo bhakaakanikihanga mu agamii bhakotokubhujanga kwa Ahelode, ila bhakabhujanga kwaachabhenji kupetela ndela jengi. ");
INSERT INTO njd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Akaageni pabhakajaulanga, antumichi bha kunani kulihunde bha Annoongo bhakaabhokela Ayusufu mu agamii, bhakaalobholela, “Nnyimuke! Mwapetule mwana bhinu pamo na anyongo bhabhe ntilie ku Misili. Nkatamange konokwe mpaka pambakunnobholelanga, maana Ahelode bhapala kunkoma habha mwana.” ");
INSERT INTO njd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Henela, Achupu bhakajimuka kubhoka mulugono, bhakaapetula mwana bhabhe na anyongo bhabhe kwa muda gwa kilo, na bhenangota bhakajaulanga kuchilambo cha Misili. ");
INSERT INTO njd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bhakatama konokwe mpaka Ahelode pabhakajomoka. Ngani hejo jikatendeka ili lilobhe lya Hangwana kwa ndela ja akaalondohi likweele handa chibhalongile, “Ngankema mwana jwangu kubhoka kuchilambo cha Misili.” ");
INSERT INTO njd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ahelode chibhakahimanya yakubhee bhenibhala bhandu bhakumanyanga ngani ja ndondwa bhakibha bhatekwaatemba, bhakatumbala muno. Akalagia bhaana bhoa bhanalome mu chilambo cha Betelehemu na kubhandikila na penapo bhaabhilinge na yaaka hibhele au pahi jabhe bhakomekwe. Akatenda henela kubhokana na muda chibhakagupata kuhimanya kubhoka kwa bhenibhala bhandu bhakumanyanga ndondwa. ");
INSERT INTO njd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Henela nga henela chigakweela malobhe gagalobhwilike kwa ndela ja akaalondohi Ayelemia kubhee, ");
INSERT INTO njd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Amundu bhakajoahanika bhabhi kuguta konokwe kuchilambo cha Lama, nguto na majopelo gajingi. Alaheli bhatenda kuguta ligongo lya bhaana bhabhe, wala bhangapala amundu bhoa bhala bhabhapembelee bhakotoke kuguta, kwa kubhee bhana bhabhe bhoa bhatekujomoka.” ");
INSERT INTO njd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baada ja kujomoka Ahelode, antumichi bha kunani kulihunde bha Annoongo bhakaabhokela Ayusufu mu agamii konokwe kuchilambo cha Misili, ");
INSERT INTO njd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","bhakaalobholela, “Nnyimuke! Mwaatole mwana bhinu pamo na anyongo bhabhe, mmuje kabhele kuchilambo cha Isilaeli, kwa kubhee bhenibhala bhabhakapala kwaakoma mwana bhatekujomoka.” ");
INSERT INTO njd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bahi, Achupu bhakajimuka, bhakampetula mwana bhabhe na anyongo bhabhe, na kubhujanga kuchilambo cha Isilaeli. ");
INSERT INTO njd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambo Achupu pabhakajoha yakubhee Aakelao mwana bhabhe Ahelode, bhatenda kutabhala badala ja atati bhabhe chilambo cha Yudea, bhakajogopa kujaula konokwe. Na bhenabho baada ja kwaakanikiha mu agamii, bhakajaula kuchilambo cha Galilaya, ");
INSERT INTO njd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na bhenabho bhakajaula kutama mu chilambo chichikemitwa Nazaleti. Kwa ndela heje nga chilikakweela lilobhe lilikalobholekwa na akaalondohi, “Apakemwa Nnazaleti.” ");
INSERT INTO njd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pagakapeta machobha gajingi Ayohana ambatichaji bhakapitila, bhakajemeka kutangacha lilobhe lya Annoongo mu likonja lya kuchilambo cha Yudea bhakatangacha bhabhi kulobhola, ");
INSERT INTO njd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mutendebhukange na kugalekanga mabhou ginunji, kwa kubhee Umwenye gwa Annoongo gutekubhandikila.” ");
INSERT INTO njd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Habha nga Ayohana nga bhenibhala yakubhee Alondohi Aisaya bhakalobhola nnani jabhe pabhakalobhola, “Mundu bhatenda kema kubhoka kulikonja, ‘Nhalakihange ndela ligongo lya Hangwana, nchibhekange maha kwaapokela Hangwana.’” ");
INSERT INTO njd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ayohana bhakawala ngobho jijikatotwa kwa manjoja ga chinyama jwakemitwa ngamia, na bhakachitabha nkanda gwa limbendela mu chibhuno chabhe. Chakulya chabhe chikabhee mapalale na bhuchi. ");
INSERT INTO njd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bahi, bhandu kubhoka mu chilambo cha Yelusalemu, na kubhoka kuchilambo cha Yudea, na hilambo yoha kubhandikila na loochi lwa Yoludani, bhakaajabhulila, ");
INSERT INTO njd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na bhhenabho bhakagalekanga mabhou gabhenji na kwabhujila Annoongo, na bhenabho Ayohana hakabhabatichanga mu loochi lwa Yoludani. ");
INSERT INTO njd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambo Ayohana pabhakabhabhonanga Mafalisayo na Masadukayo bhajingi, bhabhikuhikanga ligongo lya kubatichwa, akabhakonyanga, “Mwangota chibhelei cha lijoka, Nga bheneke bhannobholile mujibhutuke hukumulo ja Annoongo jijihika? ");
INSERT INTO njd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ntendange kwa hikubho kulangia yakubhee ntekugalekanga mabhou ginu. ");
INSERT INTO njd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nkotokuganikiha na kuchilobholelanga, mu mitima jinunji yakubhee, ‘Atati bhitu nga Aaibulahimu!’ Ndekunnobholelanga kweli, Annoongo bhakombola kugatendebhua maganga haga kubhee bhaana bha Abulahamu. ");
INSERT INTO njd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bahi libhago libhekitwe maha mu mikega ja mikongo, henela kila nkongo gwangaogola mbeju jammbone gupakuheketwa na kugujeha pa mooto. ");
INSERT INTO njd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga ndenda kumbatichanga kwa machi na kulangia kubhee ntekugalekanga mabhou ginu. Nambo bhabhapakuhika baada ya nenga bhatekubhee na machili kupunda nenga, na nenga ngakombola hata kuipetula hilatu yabhe. Bhenabho bhapakumbatichanga kwa mboomo ja Annoongo na kwa mooto. ");
INSERT INTO njd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bhenabho bhakamwile mmabhoko gabhe chipalo ligongo lya kupetela mapemba gabhe, na bhena bhapakupyagila lubhagala lwabhe lwa kupetela mapemba, bhapakuumba na kubheka mapemba mu ngokwe, na mapoi bhagajoche kwa mooto gwangahimika.” ");
INSERT INTO njd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gono muda Ayesu bhakabhoka kuchilambo cha Galilaya na bhakahika mu loochi lwa Yoludani, ligongo lya kupala kubatichwa na Ayohana, ");
INSERT INTO njd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambo Ayohana bhakajiga kwaahibhila bhabhi kwaalobholela, “Mwenga nhika kwaachangu kupala nimbatiche?” Nenga mbala kubatichwa na mwenga. ");
INSERT INTO njd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambo Ayesu bhakajangula, “Nneke tu nangocheni jibhee henela, maana nga chijipalikwa kwa jenje ndela kutama nago genigala goha Annoongo chibhagapala.” Penapo Ayohana bhakakoonda. ");
INSERT INTO njd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Popopo Ayesu pabhakabatichwa, bhakabhoka mmachi, penapo kunani kulihunde kukajogoka, na bhena bhakajibhona Mboomo ja Annoongo chijitenda kutuluka kubhoka nnani handa nguunda na kutoola nnani jabhe. ");
INSERT INTO njd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pangaganikia lilobhe kubhoka kunani kulihunde likajohanika libhi kulobhola, “Hojo nga mwana jwangu junampalite, ndekubhajilwa nabho.” ");
INSERT INTO njd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngapena Mboomo ja Annoongo bhakaalongolea Ayesu mpaka palulemba bhaleengekwe na lichetani bhaalenge Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ayesu bhakatabha machobha makomi ncheche muhi na kilo pangali kulyehe choha chela, bhakajemeka kwaabhina njala. ");
INSERT INTO njd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bahi, bhakupembelea bhakahikila na kwaalobholela, “Handa mwenga nga mwana bha Annoongo mugalobholele maganga haga gabhee nkate.” ");
INSERT INTO njd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ayesu bhakaajangula, “Jijaandikwe, ‘Amundu ngatama kwa nkate tu, ila kwa malobhe gagalobholekwa na Annoongo.’” ");
INSERT INTO njd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngapena bhakupembelea bhakaapetula Ayesu mpaka ku Chilambo cha ku Yelusalemu, Chilambo cha Annoongo, bhakaabheka nnani kundepela kunnala gwa Nyuumba ja Annoongo, ");
INSERT INTO njd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","bhakaalobholela, “Handa mwe nga mwana bha Annoongo nchigwie pahi. Kwa kubhee jijaandikwe, ‘Annoongo bhapakwaatuma antumichi bhabhe ligongo lya mwenga, bhapakumpetula mmabhoko ga bhenaangota, nkoto kobhanduka paliganga.’” ");
INSERT INTO njd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ayesu bhakaajangula, “Jijaandikwe kabhele, ‘Nkoto kwaalenga Hangwana, Annoongo bhinu.’” ");
INSERT INTO njd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngapena bhakupembelea bhakaatola Ayesu mpaka kunani kundepela kulitombi litandamao na kwaalangia hilebhe yoha ya pachilambo na goha gakubhajila pamiho. ");
INSERT INTO njd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bhakupembelea bhakaalobholela Ayesu, “Heye yoha imuilola mbakumpekeha handa mpakutindibhala majugwa na kunjalila nenga.” ");
INSERT INTO njd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Penapo Ayesu bhakaajangula, “Nnyabhule mwe bhakupembelea! Jijaandikwe, ‘Mpakwaachalila Hangwana Annoongo bhinu na kwaatumikila bhenabho jikajabhe.’” ");
INSERT INTO njd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bahi, bhakupembelea bhkaaleka Ayesu, bhatumichi bha kunani kulihunde bha Annoongo bhakahikanga, na kwaatumikila. ");
INSERT INTO njd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ayesu pabhakajoha yakubhee Ayohana bhatabhwitwe kuligelecha bhakajaula kuchilambo cha Galilaya. ");
INSERT INTO njd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akabhoka kuchilambo cha ku Nazaleti na kujaula kutama kuchilambo cha ku Kafalanaumu, chilambo chichibhile kubhandikila na bahali ja Genezaleti, mumpaka gwa chilambo cha ku Zabuloni na chilambo cha ku Nafutali, bhakatama konokwe. ");
INSERT INTO njd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Akatenda henela ili gakwele malobhe gabhakalobhola alondohi Aisaya, kubhehe, ");
INSERT INTO njd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Chilambo cha ku Zabuloni na chilambo cha ku Nafutali, mu ndela ja kujaula ku bahali, kuntundu ja loochi lwa Yoludani, na Galilaya kubhatamanga bhandu bhanga Bhayahudi! ");
INSERT INTO njd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bhandu bhabhatamitinge mulubhendu bhaluweni lumuli lwene. Na bhenaangota bhandu bhabhatamanga pakujogoa muno, nhana gutekwaamulikila!” ");
INSERT INTO njd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kubhoka gono muda Ayesu bhakajemeka kutangacha bhabhi kulobhola, “Nnekange mabhou ginu, kwa kubhee Umwenye gwa kulihunde gutekubhandikila!” ");
INSERT INTO njd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ayesu pabhakibha bhatenda nngulugula ja litanda lya ku Galilaya, bhakaabhona akaanung'una bhabhele akaakoka, Asimoni jwakemitwa Apetulo, na Aandulea anung'una bhabhe. Bhabhikoka homba kwa hipelele mu litanda. ");
INSERT INTO njd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ayesu bhakaalobholelanga, “Ngagulange, na nenga mbakuntendanga mmangange bha kwaletanga bhandu kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Popopo bhakalekanga mapelele gabhenji na kwaakagula Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pabhakajenda nnongi kachoko, bhakaabhonanga akaanung'una bhangi bhabhele, Ayakobo na Ayohana, bhaana bha Azebedayo. Bhenabho bhakibhanga mu ntumbwi pamo na atati bhabhenji Azebedayo, bhabhikuhalakihanga mapelele gabhenji. Bahi, Ayesu bhakaakemanga, ");
INSERT INTO njd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na bhenaangota bhakagulekanga ntumbwi pamo na atati bhabhe, bhakaakagula Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ayesu bhakajenda koha muchilambo cha ku Galilaya bhakaajigananga bhandu mu Nyuumba ya konganilanga Bhayahudi na kutangacha Ngani Jammbone nnani ja umwenye gwa Annoongo. Akaalamihanga bhandu itamwa yabhenji yoha hiikibha nnani jabhenji. ");
INSERT INTO njd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngani jabhenji jikajohanikiha koha kuchilambo cha ku Silia. Akaatamwa bhoa bhabhabhilinge na itamwa ya kila namuna na bhenibhala bhabhalaganga, bhandu bhabhabhilinge na mahoka, akaatamwa chiinduindu na akanangwabha, bhakaapelekanga kwa Ayesu, na bhenabho bhakaalamihanga bhoa. ");
INSERT INTO njd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mabhoga makolongwa ga bhandu kubhoka kuchilambo cha ku Galilaya, kubhoka ku Dekapoli, ku chilambo cha ku Yelusalemu na kubhoka kuchilambo cha Yudea na kubhoka kuntundu ja loochi lwa Yoludani bhakakaagula. ");
INSERT INTO njd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ayesu pabhakagabhona malubhalo ga bhandu, bhakakweela nnani ja litombi bhakatama konokwe. Bhabhachijigana bhabhe bhakaajendela, ");
INSERT INTO njd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na bhenabho bhakajemeka kwaajigananga, ");
INSERT INTO njd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhapakuachukanga bhenibhala bhabhaalolea Annoongo, kwa kubhee umwenye gwa Annoongo nga gwabhenji. ");
INSERT INTO njd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bhapakuachukanga bhenibhala bhabhaumalanga nangocheni kwa kubhee Annoongo bhapakwaapembelea. ");
INSERT INTO njd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bhapakuachukanga bhabhabhii bhakutongamanika kwa kubhee bhapakwapekeanga chilambo chibhee chabhenji. ");
INSERT INTO njd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bhapakuachukanga bhabhapalanga muno kutenda gabhagapala Annoongo, ligongo Annoongo bhapakwajangatilanga kutenda henela. ");
INSERT INTO njd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bhapakuachukanga bhenibhala bhabhakolela kia bhangi, kwa kubhee Annoongo bhapakwaabhonela kia. ");
INSERT INTO njd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bhapakuachukanga bhabhabhilinge na ntima gwa kualala, kwa kubhee bhapakwaabhona Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bhapakuachukanga bhenibhala bhabhakamuanga bhandu, kwa kubhee bhenabho bhapakemwa bhaana bha Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhapakuachukanga bhabhapotekwa ligongo lya kutenda gagapalikwa na Annoongo, kwa kubhee umwenye gwa kunani kulihunde nga gwabhenji.” ");
INSERT INTO njd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ntekuachukanga mwangota handa bhandu bhapakuntukananga, kongo bhabhi kunnagianga na kumkopokeanga kila namuna ja ubhou ligongo lya nenga. ");
INSERT INTO njd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nhachukange na kuhangalala kwa kubhee ngwahupa jinunji nga ngolongwa kunani kulihunde. Henela nga chibhakaatendelanga akaalondoi bha Annoongo bhabhakibha tangu ja mwangota.” ");
INSERT INTO njd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwangota nga ngeleka pakati ja bhandu pachilambo. Nambo ngeleka handa jihobhite kunong'a kwabhe jipakunong'ea niki? Ngapalikwa kabhele, nambo kujijea panja na kulebhatikwa na bhandu.” ");
INSERT INTO njd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwangota nga lumuli lwa chilambo. Mwangota nga handa nyuumba jijichengikwe nnani ja litombi ngakomboleka kuchiiya. ");
INSERT INTO njd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na bhandu ngajaakiha taa na kujibheka pachitombenga. Badala jabhe bhakalubheka lumuli kunani kundepela, na jenejo jikamulikila kwa bhandu bhoa mu nyuumba jela. ");
INSERT INTO njd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hela hela, lumuli gwinu gumulikile nnoongi ja bhandu, ili bhapate kugabhona mahengo ginu gammbone, bhaalumbalile Atati bhinu bhabhabhii kunani kulihunde.” ");
INSERT INTO njd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nkoto kuganikiha ndekuhika kubhoa malagilo ga Amusa gabhapatite kubhoka kwa Annoongo na majigano ga akaalondoi, ila ndekuhika kunnangianga genago malagilo nga ga kweli. ");
INSERT INTO njd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndendakunnobholelanga kweli, mpaka penapo lihunde na chilambo pachipakupeta, jaakwa hata chipande chichokochoko cha malagilo ga Amusa chichipakuhutwa mpaka goha gateendeke. ");
INSERT INTO njd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bahi, amundu bhoa bhala bhangajeketela hata lilagilo limo lichoko, na kwaajigana bhangi bhatendange henela, bhenabho bhapakubhehe achoko muno mu umwenye gwa kunani kulihunde kwa Annoongo. Nambo bhenibhala bhabhapakujeketela malagilo ga Annoongo na kwaajigana bhajingi bhapakubhee umwenye mu umwenye gwa kunani kulihunde kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndenda kunnobholelanga kweli, handa ngatenda maha hikubho hiyaabhajila Annoongo handa chibhatendanga bhabhajigananga malagilo ga Amusa na Mafalisayo, ng'o ngajingilanga mu umwenye gwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ntekujohanikia yakubhehe bhandu bha lolo pabhakalobholelwanga, ‘Nkotokoma!’ Bhoa bhala bhabhapakoma bhapakuhukumulwa. ");
INSERT INTO njd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambo nenga ndendakunnobholelanga, bhoabhala bhabhapakwaachimwa anung'una bhabhe bhapakuhukumulwa. Na bhoabhala bhabhapakwaabhelua anung'una jwabhe na kwabhona ngabha chilebhe bhapachitakiana kwa annyumbe. Na bhabhapakwaakema anung'una bhabhe, ‘Apumbavu,’ bhapalikwa kujingila mu lihembo lya moto gwangahimika machobha goha. ");
INSERT INTO njd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bahi, handa mpeleka mabhokeo ginu nnoongi ja Annoongo, ngapena mkombokela anung'una bhinu abhi na bulwa na mwenga, ");
INSERT INTO njd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mmoe mbeeko jinu nnongi ja Annoongo, mmuje nkwelekane na anung'una bhinu, ngapena mmuje nnoongi ja Annoongo kubhoa mabhokeo ginu.” ");
INSERT INTO njd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nkwelekane na apwati bhinu muda mmi nndela pamo na bhenabho kujaula kwa annyumbe. Apwati bhinu bhapakunpeleka kwa annyumbe, na bhenabho annyumbe bhapakunpeleka kwa linyemba, na mwenga mpakutabhikwa kuligelecha. ");
INSERT INTO njd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ndendakunnobholela kweli, mmokahopo monomwe mpaka nnyomole kulepa ulohi gwoha.” ");
INSERT INTO njd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ayesu akapunda kulongela, “Ntekujohanikianga yakubhehe bhandu bhatekulobholelwa, ‘Nkotokutendanga ngoongola!’” ");
INSERT INTO njd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambo nenga ndendakunnobholelanga, bhoabhala bhabhapa kunnola mwikege kwa kunnokolila, bahi bhatekutenda ngongola na bhenabho mwikege muntima gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bahi, handa lio linu lya kunnelo handa lunyambwie kutenda mabhou, mulibhoe na mulijee kutali. Mbaya muno kwaachinu kuchihobha chiungo chinu cha mmele gwinu, kuliko mmele gwinu goa kulekelekwa mu litanda lya mooto gwangahimika machobha goa. ");
INSERT INTO njd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Handa lubhoko lwinu lwa kunnnelo lunyambwie kutenda mabhou, muluhekete na kulujea kutali. Mbaya kwaachinu kuhobha chiungo chimo cha mmele gwinu, kuliko mmele gwinu goa kujingila mu lihembo lyangapela. ");
INSERT INTO njd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Jijaandikwe mu majaandiko ga Annoongo, ‘Mundu joajola jwaapala kwaaleka hanu bhabhe, apalikwa kwaajandikila talaka.’” ");
INSERT INTO njd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambo nenga ndendakunnobholelanga, “Mundu handa apala kwaaleka hanu bhabhe ligongo lya lyohalela na ngabha ligongo lya ngoongola, atendakwatenda mwikege jonojwe kubhee jwa ngoongola, na jonojwe jwaapakwaalombela mwikege jonojwe jwaalekitwe na jono atenda ngoongola.” ");
INSERT INTO njd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ntekujohanikianga yakubhee bhandu bha lolo pabhakalobholelwa, ‘Nkotokuleka kutenda chinnongile, nambo hipalikwa kutenda yoha hintekuhaidi kwa Hangwana.’ ");
INSERT INTO njd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambo nenga ndendakunnobholelanga, nkotokulapilanga choachela pantendakuhaidi, wala nkotokulapilanga kwa kunani kulihunde, kwa kubhee chenecho nga chitengu cha umwenye cha Annoongo, ");
INSERT INTO njd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nkotokulapilanga kwa chilambo, kwakubhee nga mahali pakwe pa kubheka makongono, au ku Yelusalemu, wala nkotokulapilanga kwa Yelusalemu kubhee nga chilambo cha Amwenye akolo. ");
INSERT INTO njd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na mwangota nkotokulapilanga kwa mutwe gwinu, maana ngakombola kulitenda hata lijunju linu limo kubhee lihuu au lipili. ");
INSERT INTO njd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Handa mpakulobhola, ‘Elo,’ bahi jibhee, ‘Elo.’ Na handa mpakulobhola, ‘Ngabha’ bahi jibhee, ‘Ngabha,’ choha chela chipakupunda genago kubhoka kwa bheni bhala Abhou.” ");
INSERT INTO njd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ayesu akapunda kulongela, “Ntekujohanga yakubhee jikalobholekwa, ‘Lio kwa lio, na lino kwa lino.’ ");
INSERT INTO njd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambo nenga ndendakunnobholelanga, nkotokummujikia chikubho amundu abohu. Mundu handa ampotite lijegwa lya kunnelo, mumtendebhukie kabhele lijegwa linu lya kunchiji. ");
INSERT INTO njd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Handa mundu ampelike kuchebule kupala bhapetule lichati linu, mwaaleke bhapetule kabhele na likoti linu. ");
INSERT INTO njd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu handa bhapakunkulumikia kupetula nhigo gwinu maili jimo, mgupetule maili jibhele. ");
INSERT INTO njd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bhabhapakunnyopa chilebhe mwapekee, nkotokwaajima bhabhapakuhika kunnyahika chilebhe choachela mwapekee.” ");
INSERT INTO njd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ntekujohanikianga yakubhee jitekulobholekwa, ‘Mwaapale andami ajinu, na kwaachimwa apwati bhinu.’ ");
INSERT INTO njd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambo nenga ndendakunnobholelanga, mwaapalange akaapwati bhinu na kwaajopelanga kwa Annoongo bhabhampotekanga mwangota, ");
INSERT INTO njd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kupala mmangange bhaana bha Atati bhinu bhabhabhii kunani kulihunde kwa Annoongo. Kwa kubhee bhenabho bhatendakwabhalakia lyobha lyabhe bhandu akaabhou na bhammbone, na kwaakomelekea hula bhandu bhammbone na akaabhou. ");
INSERT INTO njd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jakwa ngwaupa joajela jimpakupatanga handa mpakwapalanga bhenibhala bhabhampalanga mwangota? Kwa kubhee hata bhabhatochanga kodi bhatendanga hela hela! ");
INSERT INTO njd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hela hela handa mpakwapekeanga chalamu akaanung'una bhinu jikajabhe, bholi, ntekutendanga chilebhe changa yobheleka? Hata bhandu bhangaamanya Annoongo na bhenabho bhatendanga hela hela. ");
INSERT INTO njd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bahi, mmangange bhandu mwangalemwa handa Atati bhinu bha kunani kulihunde kwa Annoongo chibhabhile bhangalemwa!” ");
INSERT INTO njd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ayesu bhakapunda kulongela, “Ntamange maha, nkotokutendanga hikubho yinu yammbone kupala bhandu bhannolange. Kwakubhee handa mpakutendanga henela jaakwa ngwahupa kubhoka kwa Atati bhinu bhabhabhii kunani kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bahi, pamwajangatila chilebhe ahocho, nkotokulobhola kwa bhandu. Nkotokutenda handa andendemundu chibhatendanga mu Nyuumba ja konganilana Bhayuhudi na nndela ligongo lya bhandu bhalumbalilwe. Ndendakunnobholelanga kweli bhenabho bhatekupatanga ngwahupa jabhenji. ");
INSERT INTO njd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambo mwenga pampakwaapekea chilebhe ahocho, ntende henela hata aganja bhinu bhabhammandikile bhakotokuhimanya chintenda. ");
INSERT INTO njd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Henela ngani hejo jipakubhee jakuchiiya kwaachinu, na Atati jwinu jwaalola gantendite kwa kuchiiya, bhapakumpekea ngwahupa.” ");
INSERT INTO njd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mwangota pantendanga kujopa, nkotokutenda handa andendemundu. Bhena angota bhapala kujema na kujopa Mu Nyuumba ja konganilana Bhayuhudi kuntundu ja ndela ligongo lya bhandu bhabhalolange. Ndendakunnobholelanga kweli, bhenaangota bhatekupatanga ngwahupa jabhenji. ");
INSERT INTO njd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambo mwenga pannyopa Annoongo, nnyingile mu chuumba chinu nchitabhile nnyango, ngapena mwajope Atati bhinu bhangabhonekana. Na bhena bhabhagabhona gagatekuchiia bhapakunpekea ngwahupa.” ");
INSERT INTO njd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na mwangota pantenda kujopanga, nkotokulobhola kwa malobhe gajingi handa bhandu bhangaamanya Annoongo. Bhena angota bhaganikia yakubhee Annoongo bhapakwaajohanikia ligongo lya malobhe gajingi. ");
INSERT INTO njd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nkotokubhee handa bhenabho, kwa kubhee Atati bhinu bhagamanya mumugapala hata kabula mwangaajopa. ");
INSERT INTO njd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bahi, henela nga chiipalikwa kujopa, ‘Atati bhitu bhammile kunani kulihunde kwa Annoongo, lihina linu lya kuhalala lilumbalilwe. ");
INSERT INTO njd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umwenye gwinu guike. Upalyo gwinu gutendeke pamba pachilambo handa kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ntupekee leleni chakulya chitu cha machobha goa. ");
INSERT INTO njd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ntulekelele kulemwa kwitu, handa na twenga chitutenda kwaalekelela bhabhatulemwite. ");
INSERT INTO njd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nkotokutujingia mu malengelo, nambo ntulolekee kubhoka kwa bhenibhala abohu. Kwa kubhee Umwenye nga gwinu, na machili na ng'anyimo hata machobha goa. Elo.’” ");
INSERT INTO njd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ligongo handa mwalekejelinge bhandu kulemwa kwabhenji chibhantendile, na atati bhinu bha kunani kulihunde kwa Annoongo nga chibhapakunlekelela na mwangota. ");
INSERT INTO njd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambo handa mwangaalekelela bhandu kulemwa kwabhenji, na bhenabho Atati bhinu bha kunani kulihunde kwa Annoongo bhannekelelanga hopo kulemwa kwinu.” ");
INSERT INTO njd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ayesu akapunda kulobhola, “Pampakutabha nkotokuhumalika handa akaandendemundu. Bhenaangota bhatenda kubheka lukenja pamiho jabhe ligongo bhabhonekane na bhandu kubhee bhatabhite. Nannobholelanga kweli, bhena angota bhatekupatanga ngwahupa jabhenji. ");
INSERT INTO njd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambo mwenga pamtenda kutabha, nkue pamihon jinu na mpakale mahuta mu mutwe gwinu na mkwemule majunju ginu, ");
INSERT INTO njd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kubhee amundu bhoa bhala bhakoto kuhimanya yakubhehe ntabhite, ila bhamanyike tu kwa Atati bhabhe bhangabhonekana. Na bhenabho Atati bhinu bhabhabhona gachiite bhapakunpekea ngwahupa.” ");
INSERT INTO njd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ayesu akapunda kwaalobholelanga, “Nkoto kuchibhekela hilebhe pambani pachilambo hikoko ya bhakuhalabiana na kuutu bhatenda kombola kujingila na kuhalabiana na akaabwihi kujingila na kujibha. ");
INSERT INTO njd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nchibhekele hilebhe kulihunde kwa Annoongo kwa kubhee hikoko na kuutu ngakombola kuhalibiana wala akaabwihi ngakombola kujiingila na kujibha. ");
INSERT INTO njd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maana penipala pajibhile ngokwe jinu, ngapena kabhele pagupakubhee ntima gwinu.” ");
INSERT INTO njd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lio nga lumuli gwa mmele. Handa lio linu nga likoto, mmele gwinu goa gupakubhehe pa nhana. ");
INSERT INTO njd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nambo handa lio linu nga libhou, mmele gwinu goa gupakubhee mu lubhendu. Bahi, handa nhana gugubhile nkati jinu nga lubhendu, bahi gonogwe nga lubhendu lwa kujogoa!” ");
INSERT INTO njd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ayesu akaalobholela bhaakwa amundu bhakombola kwaatumikila akaakolo bhabhele. Kwa kubhee bhapakwaachimwa bhamo na kwaapala bhenabho jwabhele, au bhapakubhee na bhamo na kwaabhelua bhenabho bhangi. Ngakombolanga kwaatumikila Annoongo pamo na hilebhe.” ");
INSERT INTO njd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nga kwa maana nannobholelanga, nkoto kubhee na lipamba kwa ngani ja chakulya chichimpakulyee na ching'welo chichimpakung'wee, wala ngani ja ngobho yakuwala mu mimele jinunji. Bholi, umomi nga chakulya jikajabhe au kupunda echocho? Na mmele, bholi nga kupunda ngobho? ");
INSERT INTO njd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muilolange hijuni. Ngapandanga na kuuna, wala bhangakola ngokwe joha jela. Hata henela Atati bhinu bha kunani kwa Annoongo bhapakunpekea yakulyee. Bholi, mwangota ngabha bhammbone kupunda hijuni? ");
INSERT INTO njd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nga aganiki nkati jinunji kwa kuchilagia bhakombola kuchijonjokea kutandamala kwabhe hata lichaa limo lya kutama kwabhe?” ");
INSERT INTO njd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ngani ja ngobho, ya niki kubhee na lipamba? Mugalolange malobha ga kumanyahi chigapunda kuhalala. Gateendahopo lihengo wala kuchihalakia ngobho. ");
INSERT INTO njd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambo ndendakunnobholelanga, hata Asolomoni bheene na kukola kwabhe hilebhe koha Annoongo bhangaaweka maha handa lilobha limo lyabhe lya gangani. ");
INSERT INTO njd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bahi, ikabhee Annoongo bhakagawekela mahamba ga kunng'onda, yakubhee leleni gabhile, malabhi gatenda kujoma na kulekelwa pamooto, bholi, ngabha bhapakuntendelanga maha muno? Bholi, mwangota mwangahobhalelanga!” ");
INSERT INTO njd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bahi, nkotokubhee na lipamba, ‘Tupakulyee niki?’ Au kabhele, ‘Tupakung'wee niki?’ Au ‘Tupakuwala niki!’ ");
INSERT INTO njd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwa kubhee genago goa gatenda kulolekewa na bhandu bhangaamanya Annoongo. Atati bhitu abhile kunani kwa Anoongo atenda kuhimanya hilebhe yoha tuhipala. ");
INSERT INTO njd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Henela, nnyemekange kugulolekea Umwenye gwa Annoongo kupeta yoha na gaagapala Annoongo, na Annoongo bhapakumpekea genago goa na kunnyonjokeanga. ");
INSERT INTO njd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bahi, nkotokubhee na lipamba nnani ja malabhi, kwa kubhee malabhi jitekubhee na hilebhe yabhe. Kila lichobha litekubhee na hilebhe ya lichobha elyo.” ");
INSERT INTO njd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nkotokwaahukumula bhandu bhangi, na mwangota mpakuhukumulwa na Annoongo, ");
INSERT INTO njd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","maana chimpakunhukumula nnyinu na mwangota chimpakuhukumulwa, na chipemelo chela chela chimpakupemela bhandu nga chochocho Annoongo nga chibhapakunpemelanga mwangota. ");
INSERT INTO njd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kwaniki muchibhona chipande chichoko chichibhile mu lio lya anung'una bhinu, na kongo chipalapata chichibhile nkati ja lio linu ngachilola? ");
INSERT INTO njd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nkombola bholi, kunnobholela anung'una bhinu, ‘Anung'una bhangu, nnende nimmoe chipande chichoko mu lio linu na kongo mwabhene nkweti chipalapata mu lio linu? ");
INSERT INTO njd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mwe andendemundu! Nnyemeke kubhoa chipalapata chichibhile mu lio linu, penapo nga pampakombola kulola kweli chimpakwaabhoa chipande chichibhile nkati ja lio lya anung'una bhinu.’” ");
INSERT INTO njd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nkoto kwaapekeanga bhandu hilebhe yammbone ya Annoongo, wala nkoto kwaajelea magolobhe hilebhe yammbone kwa kubhee bhapakuilebhatanga.” ");
INSERT INTO njd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nnyopange, mwangota mpakupatanga, nnoleange na mwangota mpakupatanga, nng'ombange pannyango, na mwangota mpakujogolelwa. ");
INSERT INTO njd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwa maana amundu bhoa bhala pabhajopa bhatendakwaapekea, na bhoa bhala bhabhalolekea bhapekewa, na bhoabhala bhang'omba pannyango bhajogolelwa. ");
INSERT INTO njd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bholi, bhabhi amundu nkati jinu handa mwana bhabhe bhaajopite nkate, bhapakwaapekea liganga? ");
INSERT INTO njd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Handa bhaajopite litobhi, bhapakwaapekea lijoka? ");
INSERT INTO njd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mwangota bhammilinge mwaabhou, nambo mmanyanga kwaapekea bhana bhinu hilebhe yammbone, nga henela Atati bhinu bhaabhile kunani kulihunde kwa Annoongo bhapakwaapekeanga yammbone muno bhenibhala bhabhaajopa.” ");
INSERT INTO njd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mwatendelange bhandu bhangi handa chimpalanga bhantendelange bhantendele mwangota. Hejeje nga maana ja malagilo ga Amusa na majigano ga Akaalondoi bha Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nnyingilange kupetela nnyango gwa kunying'inyala, ligongo ndela jijijaula kwahobheanga bhandu nga jitekupanuka, na nnyango gwa kujingila monomwe nga gutekupanuka, bhabhajaula mu ndela ejo nga bhajingi. ");
INSERT INTO njd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambo ndela jijijaula mu umomi nga jakunying'inyala, na nnyango gwa kujingila monomwe nga gwakunying'inyala, nga bhandu kachoko bhakombola kujimanya jene ndela.” ");
INSERT INTO njd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nchibhekange kutali na akaalondoi bha unami. Bhenaangota bhaikanga kwaachinunji bhabhi kubhonekana panja handa ngondolo, nambo nkati jabhe nga mamei gagahika kunhulaanga. ");
INSERT INTO njd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mpakubhamanyanga kwa hikubho yabhe. Bholi, bhandu bhakabhanga zabibu mu nkongo gwa miibha, au mbendembe mumkongo gwa mpengo? Ngabha! ");
INSERT INTO njd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bahi, nkongo gwammbone guogola matunda gammbone, na nkongo mbhou guogola matunda mabhou. ");
INSERT INTO njd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongo gwammbone ngakombola kuogola matunda gabhou, wala nkongo mmohu ngakombola kuogola matunda gammbone.” ");
INSERT INTO njd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongo gwangaogola matunda gammbone gupakueketwa na kulekelwa pamooto. ");
INSERT INTO njd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Henela, mpakubhamanyanga akaalondoi bha unami kwa hikubho yabhenji. ");
INSERT INTO njd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ngabha kila mundu jwaangema nenga, ‘Hangwana, Hangwana,’ bhapakujingilanga mu Umwenye gwa kunani kwa Annoongo, ila bhenibhala bhabhapakupangananga chibhapala Atati bhangu bhabhabhile kunani. ");
INSERT INTO njd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bhandu bhajingi bhapakunobholela nenga lichobha lyela lya kuhukumula, ‘Hangwana, Hangwana! Kwa lihina linu tukatangacha ngani jinu kwa bhandu, na kupetela lihina linu tukaabhoanga bhandu mahoka na kupangananga gajingi gakangachika!’ ");
INSERT INTO njd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Penapo mbakunnobholelanga, ‘Nimmanyanga hopo mwangota, mmokange kwaachangu, mwenga mwaangota akaabohu!’” ");
INSERT INTO njd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Henela, kila amundu bhabhajoha malobhe gangu na kugakamula, bhalandana na mundu jwaabhile na luunda, jwaachengite nyuumba panani ja liganga. ");
INSERT INTO njd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Handa hula jipakoma na loochi lukatweelela machi, na handa mboongo ngolongwa jipakuhika na kujipota jela nyuumba. Nambo jangagwee kwa kubhee jikachengwa panani pa liganga.” ");
INSERT INTO njd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambo amundu bhoa bhala bhabhajoha malobhe gangu na kugaleka, bhatenda kulandana na amundu bhapoganike bhabhakachenga nyuumba jabhe panani jamihanga. ");
INSERT INTO njd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hula jikakoma, machi gakatweelela mu loochi, na mboongo ngolongwa jikapoga na kujipota nyuumba ejo, nga jikagwee, na nhindo gwakwe gukibha nkolongwa muno.” ");
INSERT INTO njd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ayesu pabhakajomola kulobhola malobhe genago, lilubhalo likolongwa lya bhandu bhakakangachanga kwa henela chikajigana bhandu. ");
INSERT INTO njd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kwa kubhee bhakajigana handa amundu bhabhabhile na uwecho, wala ngabha bhabhajigana Malagilo ga Amusa. ");
INSERT INTO njd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ayesu pabhakatuluka kubhoka palitombi, lilubhalo likolongwa lya bhandu bhajingi likaakagula. ");
INSERT INTO njd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bahi, bhakahika amundu bhamo bhabhi atamwa mambujupuju, bhakaatindibhalila majugwa na kwaalobholela, “Hangwana, handa mpalite, nkombola kulamia nenga!” ");
INSERT INTO njd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ayesu bhakanyulula lubhoko lwabhe na kunkwaa na kulobhola, “Ndenda kupala! Nname.” Mala bhena amundu bhakalama mambujupuju gabhe. ");
INSERT INTO njd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngapena Ayesu bhakaalobholela, “Nnole nkoto kunnobholela mundu bhoabhala, nambo nnyaule kwa akaakung'i na kubhoa ngwahupa jijikahukumulikwa na Amusa ili kwaalangia yakubhee ntekulama.” ");
INSERT INTO njd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ayesu pabhakahika pannyini ku Kafalanaumu, akolo bhamo bha manyemba ga ku Lumi bhakaajendelela na kwaapembelela bhaanyangatile. ");
INSERT INTO njd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kongo bhabhi kulobhola, “Hangwana, antumichi bhangu bhatekugoloka kaaja atamwa muno na bhatekupola.” ");
INSERT INTO njd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ayesu bhakaalobholela, “Mbakuhika kwaalamia.” ");
INSERT INTO njd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bhenabho akolo bha manyemba ga ku Lumi bhakaalobholela Ayesu, “Hangwana, ngapalikwa mwenga nnyingile mu nyuumba jangu. Nambo nlagie tu lilobhole limo na antumichi bhangu bhapakulama. ");
INSERT INTO njd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwa kubhee nenga na mwene nga amundu nibhekitwe pahi ja mamulaka, ngweti manyemba pahi jangu. Handa mbakwaalobholela habhabha, ‘Nnyaule,’ na bhenabho bhakajaula. Na bhangi handa naalobholile, ‘Nhike,’ bhenabho bhatenda kuhika. Na handa mbakwaalobholela antumichi bhangu, ‘Npangane henela,’ na bhenabho bhapakungana.” ");
INSERT INTO njd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ayesu pabhakajoha genago, bhakakangacha muno, akabhalobholelanga bhandu bhabhakibha bhaakagula, “Ndendakunnobholelanga kweli, nangapata kwaabhona amundu bhoa bhala mu chilambo cha ku Isilaeli bhakuhobhalela muno handa bhenabho. ");
INSERT INTO njd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bahi ndendakunnobholelanga yakubhee bhandu bhajingi bhapakuhika kubhoka kuulabho na kuuwelo, na bhena angota bhapakutamanga ili bhalyee pamo na Aaibulahimu, na Aisaka, na Ayakobo mu Umwenye gwa kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambo bhenibhala yakubhee Umwenye gonogwe gwa Annoongo nga gwabhenji bhapakwaajeha panja, palubhendu, konokwe bhapakugutanga na kuyaga mino.” ");
INSERT INTO njd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kubhoka penapo Ayesu bhakaalobholela bhenabho akolo bha manyemba ga Ku Lumi, “Nnyaule kwaachinu na ibhee handa chinhobhalile.” Na antumichi bhabhe bhakalama muda gogogo. ");
INSERT INTO njd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ayesu bhakahika kwaachabhe Apetulo, bhakaakolela hakibhabhe haikege bhagolwike pachindanda, bhatenda kulwala muno. ");
INSERT INTO njd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bahi, Ayesu bhakaakamula lubhoko bhenibhala haikege, na bhakalama bhakajema na kujemeka kwabhekela tayali chakulya. ");
INSERT INTO njd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pajikahika kimuo, bhakaaletela bhandu bhajingi bhabhakibha na mahoka, na bhenabho Ayesu bhakaakulumikiha mahoka gabhoke kwa bhandu. Kabhele bhakaalamia bhandu bhoa bhabhakibha akaatamwa. ");
INSERT INTO njd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akatenda henela kupala genigala malobhe gaakalongela alondoi bhakeemitwa Aisaya galenganile, “Bhenabho bheene bhatekutupetula na kupongokewa kwitu, na bhatekuhipetula itamwa yitu.” ");
INSERT INTO njd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ayesu pabhakabhona lilubhalo likolongwa lya bhandu litekwaatindila, nga bhakaakulumikia bhabhachijigina bhabhe bhajombokange kujenda kuntundu ja litanda. ");
INSERT INTO njd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bhabhajigana bhamo bha Malagilo ga Amusa bhakaajendelela Ayesu na kwaalobholela, “Bhannyigana, nenga mbakunkagula koha kola kumpakujenda.” ");
INSERT INTO njd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ayesu bhakaajangula, “Mabwea gakweti macheembo, na hijuni hikweti hiyua, nambo amwana bha amundu bhakwetihopo chehemu ja kupomolelela.” ");
INSERT INTO njd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngapena amundu bhamo nkati ja bhabhachijigana bhabhe bhakaalobholela Ayesu, “Hangwana, naanjinu nneke oti ngaachike Atati bhangu.” ");
INSERT INTO njd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambo Ayesu bhakaalobholela, “Nkagule nenga! Nneke bhandu bhabhabhilinge handa bhajomwike bhachikane na bhandu handa bhabhawilinge.” ");
INSERT INTO njd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ayesu bhakakwela mu mtumbwi nkolongwa, na bhabhachijigana bhabhe bhakaakagula. ");
INSERT INTO njd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mala mboongo ngolongwa jikabhokela mulitanda, na mawimbi gakajemeka kugupukunyapukunya ntumbwi nkolongwa. Na muda gonogwe Ayesu bhabhi tangu bhagolwike lugono. ");
INSERT INTO njd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bhabhachijigana bhakaajendelela na kwaajimua, bhabhi kulobhola, “Hangwana ntuchobhole.” “Tutendakujomoka!” ");
INSERT INTO njd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ayesu akaajangulanga, “Mwe mwangota mmilinge na kuhobhalela kuchoko!” “Mboni ntenda kujogopanga?” Bahi, bhakajinuka na bhakajikalipila mboongo na mawimbi, na mboongo jikakotoka. ");
INSERT INTO njd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bhandu bhoa bhakakangachanga, bhabhi kulobhola, “Nga mundu jwa namuna niki hojojo?” “Hata mawimbi na mboongo jitendakwaajohanikia!” ");
INSERT INTO njd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ayesu pabhakahika ku chilambo cha bha Gadala, kuntundu ja litanda, na konokwe bhandu bhabhele bhabhakapoganikwa na mahoka gabhou bhakakongana nabho bhabhi kubhokanga kumakabuli. Bhandu habha bhakibha bhakalipa muno, hata pangabhee na amundu bhabhakajiga kupeta mu ndela jenejo. ");
INSERT INTO njd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bhenaangota bhakajemeka kupotanga nyenye, “Mmi na niki na tweenga, mwe Mwana bha Annoongo? Bholi, ntekuhika kutulagia tangu muda gwangahika?” ");
INSERT INTO njd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kubhandikila na penapo pakibha na magolobhe gajingi bhatendita kugaliyanga. ");
INSERT INTO njd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bahi, genago mahoka gabhou gakaapembelela Ayesu, “Handa mpakutubhoa, bahi ntuluke tukagajingile magolobhe gala.” ");
INSERT INTO njd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ayesu akaalobholelanga, “Nnyaulange, penapo bhakaabhoanga bhenibhala bhandu, na kujingila mumagolobhe gala. Lilubhalo lyoa lya magolobhe likabhutukila mu chihelelo chikolongwa, likajingila mu bahali, magolobhe goa gakawee na machi.” ");
INSERT INTO njd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bhenibhala bhandu bhabhalanga genigala magolobhe bhakabhutukanga na bhakajaula kunnyini, konokwe bhakakongolela ngani joha jijikapetela kwa bhenibhala bhandu bhabhi na mahoka. ");
INSERT INTO njd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kubhoka penapo bhandu bhoa bha pannyini bhakabhoka na kwaajendelela Ayesu, na pabhakaabhona bhakaapembelela bhabhoke pachilambo chabhe. ");
INSERT INTO njd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ayesu bhakakweela mu mtumbwi, na bhakajomboka litanda na kuhika mu chilambo chabhenji. ");
INSERT INTO njd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngapena bhandu bhajingi ngabhanneta mundu jwaapolite mmele goa, bhabhagonikwe nnani ja njeega. Ayesu pabhakabhona kuhobhalela kwabhenji, nga akaalobholela jonijola mundu jwaapolite, “Mwanangu nchipee ntima! Mabohu ginu gatekulekelelwa.” ");
INSERT INTO njd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bhandu bhangi bha bhenibhala bhabhamanyanga malagilo ga Amusa bhakajemekanga konyananga akaachinabhene, “Hojo mundu atekwaaponja Annoongo!” ");
INSERT INTO njd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ayesu akagamanya chibhatenda kuganikia, akaakonyanga, “Kwaniki ntendanga kuganikia mabohu mu mitima jinunji? ");
INSERT INTO njd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bholi, nga niki chichibhile changalimba, kulobhola, ‘Ntekulekelelwa mabohu ginu’ au kulobhola, ‘Nnyeme nnyaule?’” ");
INSERT INTO njd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nambo, mbala muimanyange yakubhehe amwana bha amundu bhakombola kwaalekelela bhandu mabhou gabhe pamba pachilambo. Penapo akaalobholela jonojwe mundu jwapolite mmele, “Nnyimuke ntole njeega chinu, nnyaule kwaachinu.” ");
INSERT INTO njd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jonojwe mundu jwaapolite mmele bhakajimuka, na bhakajaula kwaachabhe. ");
INSERT INTO njd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bhandu bhoa mu lilubhalo lyela pabhakagalola genago bhakajogopanga, bhakaalumbalila Annoongo bhabhaapekie bhandu machili ga henela. ");
INSERT INTO njd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ayesu bhakabhoka penapo, na pabhakajaula, bhakaabhona amundu bhamo bhakemitwa Amatayo, bhatamite panyuumba ja kutochela kodi, Ayesu bhakaalobholela, “Ngagule nenga.” Na bhenabho Amatayo bhakajema, na kwaakagula. ");
INSERT INTO njd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ayesu pabhakibha kwaachabhe Amatayo kulyee chakulya, bhakutochanga kodi bhajingi na akaabohu bhakahikanga bhakatama na kulyee nabho na bhabhachijigana bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo pabhakabhona genago, bhakaakonyanga bhabhachijigana bhabhe, “Kwaniki bhannyigana bhinu bhalyee pamo na bhandu bhabhabhilinge na mabohu?” ");
INSERT INTO njd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ayesu pabhakajoha genago, bhakaalobholelanga, “Bhandu bhanga itamwa bhaapalanga hopo ang'anga, nambo bhenibhala akaatamwa nga bhaapala ang'anga. ");
INSERT INTO njd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bahi, nnyaulange nkachijigane maana ga malobhe aga, ‘Mbala kia, ngabha mbeeko,’ kwa maana nangahika kwaakemanga bhandu bhabhilinge bhammbone, nambo bhabhilinge na mabhou.” ");
INSERT INTO njd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Penapo bhabhajichigana bha Ayohana ambatichaji bhakaajabhulila Ayesu, bhakaakonya, “Tweenga na Mafalisayo tutenda kutabha mala jijingi, kwa niki bhabhachijigana bhinu ngatabha?” ");
INSERT INTO njd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ayesu bhakaajangulanga, “Bholi, akaageni bhabhalaalikwe ku ulombela bhapakuhumalanga na kutabha pabhabhee pamo na hangwana bha ulombela? Nga henela! Nambo muda gupakuhika hangwana bha ulombela chibhapakubhokekwa nkati jabhenji, gono muda nga pabhapakutabhanga.” ");
INSERT INTO njd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Bhandu ngatotela chibhamba cha ngobho jiyono mu ngobho ja lolo. Handa bhatenditinge henela, jenejo ngobho ja lolo jipakujonjokeka lipobhole, na jenejo ngobho jipakuhalibika muno. ");
INSERT INTO njd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wala bhandu ngalekelanga divai jiyono mu mihuko jijilalite jijitotitwe na mambendela ga ngondolo. Handa bhatenditinge henela, divai hejo hipakuipapulana yeneyo mihuko jenejo, na divai jipakujitika na mihuko jipakupapuka. Divai jiyono jilekelwa mu mihuko miyono na henela divai na mihuko kubhee maha!” ");
INSERT INTO njd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ayesu pabhatendita kulobhola genago, akolo bhamo Annyahudi bhakahika, bhakaatindibhalila majugwa na kulobhola, “Amwali bhangu bhatekujomoka nangocheni. Nambo nhike nkaabhekele lubhoko lwinu na bhenabho bhapakulama.” ");
INSERT INTO njd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ayesu bhakajimuka na kujaula pamo na bhabhachijigana bhabhe bhakaakagula. ");
INSERT INTO njd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na pabhatendita kujaula haikege bhamo, atamwa ncholocholo kwa yaaka komi na jibhele, bhakaakagula Ayesu kuyeto, bhakamula mbendo ja ngobho jabhe. ");
INSERT INTO njd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwakubhee bhakachilobholela muntima gwabhe, “Handa ngamwile tu ngobho jabhe, mbakulama.” ");
INSERT INTO njd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ngapena Ayesu bhakatendebhuka bhakaabhona haikege, bhakaalobholela, “Amwali, nchipekee ntima! Kuhobhalela kwinu kutekunlamia.” Haikege bhenabho bhakalama popopo. ");
INSERT INTO njd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ngapena Ayesu pabhakahika kwaachakwe bhenibhala akolo. Na bhakaabhona bhandu bhagomba hipenga ya nguto na kuguta muno, ");
INSERT INTO njd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","bhakaalobholela, “Mmokange pamba! Amwali abha bhangawee, bhatekugoloka tu.” Nambo bhandu bhakaaheka. ");
INSERT INTO njd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bahi, lilubhalo lya bhandu pabhakaabhoanga panja, Ayesu bhakajingila nkati, bhakaakamula lubhoko bhena amwali, na bhenabho bhakajema. ");
INSERT INTO njd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bhandu bhoa bha chilambo echo bhakajoanga ngani hejo. ");
INSERT INTO njd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ayesu pabhakabhoka penapo, na pabhatendita kujenda, bhangalola bhabhele bhakaakagula kongo bhabhi kupotanga nyenye, “Amwana bha Adaudi, ntukolee kia!” ");
INSERT INTO njd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ayesu pabhakajingila mu nyuumba, bhangalola bhabhele bhakaajendelela Ayesu na bhakaakonya, “Bholi, nhobhalelanga kubhehe nenga ndenda kombola kunnamianga?” Na bhenaangota bhakaajangula, “Eloo, Hangwana.” ");
INSERT INTO njd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Penapo Ayesu bhakakwahanga miho gabhenji, bhakalobhola, “Na hibhee kwaachinunji handa chinhobhalilinge.” ");
INSERT INTO njd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miho gabhenji ngagakajogoka kulola. Na bhenabho Ayesu bhakaakanikia muno, “Nkotokwaalobholelanga amundu bhoabhala chilebhe chenjeni.” ");
INSERT INTO njd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambo bhenaangota bhakabhokanga, bhakajaula kutandahaa ngani ya Ayesu mu chilambo chela choa. ");
INSERT INTO njd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bhandu pabhatendita kujenda kwaachabhe, bhangi bhakaaleta kwa Ayesu amundu bhangalongela ligongo bhakibha na mahoka. ");
INSERT INTO njd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ayesu pabhakalibhoa lyenilyela lihoka, popopo bhenibhala amundu bhangalongela bhakajemeka kulongela kabhele. Bhandu bhakakachanga na kulobhola, “Chilebhe handa chenjeni changabhonekana mu chenje chilambo cha ku Isilaeli.” ");
INSERT INTO njd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambo Mafalisayo bhakalobhola, “Amundu abha bhatenda kugabhoa mahoka kwa machili ga akolongwa bha mahoka.” ");
INSERT INTO njd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ayesu bhakatyanga mu hilambo yoa na hijiji, na bhakajigana mu majuumba gabhenji ga konganilanga Bhayahudi, bhabhi kulongela Ngani Jammbone ja Umwenye gwa Annoongo, na kulamia bhandu itamwa yoa. ");
INSERT INTO njd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ayesu pabhakaabhonanga bhandu mabhoga mabhoga bhakaakole kia kwa kubhehe bhakibhanga na lipamba na bhangabhee bha kwaajangatila. ");
INSERT INTO njd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Penapo bhakaalobholelanga bhabhachigana bhabhe, “Hilebhe ya kuhuna nga hijingi ila bhakuhuna na ngachoko. ");
INSERT INTO njd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mwajopange bhenabho bhabhakweti hilebhe ya kuhuna bhaatume bhandu bhakahunange hilebhe yabhe.” ");
INSERT INTO njd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ayesu bhakaakema bhenibhala bhabhaajigana bhabhe komi na bhabhele, bhakapekeanga machili ga kubhoa mahoka na kalamia akaatamwa na hibhini yoa. ");
INSERT INTO njd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ganga nga mahina ga bhabhaajigana bhabhe bhabhakaakema akaatumi komi na bhabhele, bhabhakajemeka, Asimoni jwakemitwa Apetulo, na Aandulea bhabhakibha anung'una bhabhe Apetulo, Ayakobo mwana bha Azebedayo na anung'una bhabhe bhabhakemitwa Ayohana, ");
INSERT INTO njd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Afilipo na Abatolomayo, Atomaso na Amatayo bhabhakibha bhatocha kodi, Ayakobo mwana bha Aalufayo, na Atadei, ");
INSERT INTO njd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Asimoni bha ku Kanaani, na Ayuda Isikaliote bhabhakaagaluka Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ayesu akaatuma bhenabho akaatumi komi na bhabhele na kwaapekea Malagilo gangani, “Nkotokujaulanga kwa bhandu bhanga Bhayahudi, na wala nkotokujingilanga mu hilambo ya ku Samalia. ");
INSERT INTO njd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambo nnyendange kwa bhandu bha chilambo cha ku Isilaeli bhenaangota nga handa ngondolo hiiyobhite. ");
INSERT INTO njd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nnyaulange nkaalobholelange bhandu, ‘Umwenye gwa kunani kwa Annoongo gubhandikile,’ ");
INSERT INTO njd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nnamiange akaatamwa, mwayohange bhabhawilinge, mwalamiange bhabhabhile na mambujupuju, mmoange mahoka. Mpatitinge hiyoyo, mmoange hiyoyo. ");
INSERT INTO njd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nkotokupetulanga bunyu mu mihuko jinu, wala madini ga mbiya wala njeejeka ya chaba. ");
INSERT INTO njd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nkotokupetulanga nhuko gwa kujopela hilebhe nndela, wala ngobho ya kutindiganya, wala ilatu, wala ntindio. Kwa kubhehe bhabhatenda lihengo bhapalikwa kupokela chichipalikwa. ");
INSERT INTO njd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pampakujingilanga pachilambo au chijiji choachela, munnoleange mundu jwaapakummpokelanga na handa bhammpokilinge ntamange monomwe mpaka pampakubhokanga. ");
INSERT INTO njd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pampakujingilanga mu nyuumba hejo, mwaalobholelange bhandu, ‘Kuhengwa kubhee na mwangota.’ ");
INSERT INTO njd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Handa akaakola nyuumba bhampokilinge amani jipakubhee na bhenaangota. Nambo handa bhangapokela bahi amani jinunji jipakummujilanga mwaachina bhene. ");
INSERT INTO njd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Handa mundu joajolas jwapakana kumpokelanga au kunnyohanikianga, bahi pampakubhoka mu nyuumba hejo au chilambo hecho, mpyatange lutukunda mumakongono ginu hibhee chilolelo kubhee bhakanitinge kwaapokela Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndendakunnobholelanga kweli, bhandu bha namuna jenejo Annoongo bhapakwalagianga kupunda bhandu bhabhatamitanga chilambo cha ku Sodoma na chilambo cha ku Gomola.” ");
INSERT INTO njd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nangocheni, nenga ndendakuntumanga mwangota handa ngondolo pakati ja mamei. Mmangange na luunda handa lijoka na mmangange bhakutungamanika handa ngunda. ");
INSERT INTO njd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nchibhekange kutali bhandu bhapakuntaukanga bhapakunkamulanga na bhapakumpelekanga kuchebule na kumpotanga luyaakato mu majuumba gabhe ga kuchaalila. ");
INSERT INTO njd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bhapakumpelekanga nnoongi ja akaatabhala na manyewe ligongo lya nenga, mpate kwakongolela kwabhenji kwa bhandu bhangaamanya Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nambo pampakupelekwanga mwangota kuchebule, nkoto kubhehe na lipamba kuganikia chichimpakulongela, kwa kubhehe mpakupekewa lilobhe lya kulongela. ");
INSERT INTO njd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa kubhehe ngabha mwangota bhampakulongelanga nambo bhapakulongela nga Mboomo ja Annoongo bhena nga Atati bhinunji.” ");
INSERT INTO njd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Amundu bhapakung'aluka anung'una bhabhe bhakomekwe, na bhenabho atati bhapakung'aluka mwana bhabhe, na bhenabho bhaana bhapakwaapotanga akaabhelei bhabhe na kwaakomanga. ");
INSERT INTO njd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bhandu bhoa bhapakunchimwanga mwangota ligongo lya lihina lyangu, nambo bhabhapakuchitimalika mpaka kupela, Annoongo bhapakwaokoa. ");
INSERT INTO njd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Handa bhandu bhakampoteka muchilambo chimo, ntilange mpaka muchilambo chengi. Ndendakunnobholelanga kweli, ngajomolanga kutyanga mu hilambo yoa ya chilambo cha ku Isilaeli tangu Mwana bha Amundu bhangahika.” ");
INSERT INTO njd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Bhabhachijigana ngakombola kwaapunda bhabhanyigana bhabhe, na abhanda ngaapunda Hangwana bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bhabhachijigana na bhabhee tu handa bhabhaajigana bhabhe na abhanda bhabhee bhabhe handa Hangwana bhabhe. Handa akolo bha nyuumba bhakemitwe akolo bha Abelizebuli, bholi! Bhandu bhangi bha nyuumba jabhe ngati bhapakemwanga mahina mabhou muno?” ");
INSERT INTO njd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Henela nkotokwaajogopanga bhandu. Atenda kuhiyanga hilebhe hibhatendanga nambo muda gupakuhika bhandu bhapakugabhona genago gagabhatendanga na Kila jumo bhapakugamanya gagatekuchiiya. ");
INSERT INTO njd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Genigala ninnobholilinge pajika jitu, mwalobhololange bhandu, na genigala ganannobholilinge kwa kunong'ona mwaalobholele kila mundu. ");
INSERT INTO njd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nkotokwaajogopanga bhenibhala bhabhakombola kugukoma mmele gwinu, nambo ngakombola kujikoma mboomo jinu, nambo mwaajogope bhenibhala bhabhakombola kukoma mmele na mboomo jinunji mu mooto gwangahimika machobha goa. ");
INSERT INTO njd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Njehe huuchwa kwa ulohi nchoko. Nambo jwaakwa hata jumo jwabhe jwapakugwee pahi pangali atati bhinu kuimanya. ");
INSERT INTO njd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambo kwinunji mwangota, hata majunju mu mimutwe jinunji gatekubhalanganikwa goa. ");
INSERT INTO njd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Henela nkotokujogopa, mwangota nga bha maana muno nnongi ja Annoongo kupeta hijuni hijingi.” ");
INSERT INTO njd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mundu bhoa bhala bhabhapakoonda nnongi ja bhandu kubhee bhangu nenga, nanenga mbakwaajeketela nnongi ja Atati bhangu bhabhabhile kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambo bhoabhala bhabhapakungana nenga nnongi ja bhandu, na nenga mbakwaakana nnongi ja Atati bhangu bhaabhile Kunani kulihunde kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nkotokuganikiha yakubhee ndekuhika kujileta amani pachilambo. Nangahika kujileta amani ila ndekuhika kuleta ngoondo. ");
INSERT INTO njd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ndekuhika kwaatenda bhakoto kwelekana nkati ja mundu na atati mundu, pakati ja amwali na anyongo jwabhe na pakati ja akoano na akimundu, ");
INSERT INTO njd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na apwati bha mundu bhapakubhee bhandu bha kwaachabhe, akaalongo mundu.” ");
INSERT INTO njd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bhoabhala bhabhaapala atati bhabhe au anyongo bhabhe kupeta chibhambala nenga, ngapalikwa kubhee bhangu nenga. Na bhenibhala bhabhaapala mwana mwanalome au mwana mwikege kupeta chibhambala nenga, ngapalikwa kubhee bhangu nenga. ");
INSERT INTO njd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Amundu bhoabhala bhabhapetula nchalaba gwabhe na kungagula, bhapalikwa kubhee bhabhachijigana bhangu. ");
INSERT INTO njd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amundu bhoabhala bhabhapala kugulolekea umomi gwabhe, bhenabho bhapakugubhoa, nambo bhoa bhala bhabhapakugubhoa umomi ligongo lya nenga, bhapakupata umomi gwa machobha goa.” ");
INSERT INTO njd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bhabhampokelanga mwangota mu nyuumba yabhenji, bhambokela nenga, na mundu bhabhambokela nenga, bhampokela bhenibhala bhabhandumite. ");
INSERT INTO njd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amundu bhoabhala bhabhaapokela alondoi, bhapakupokela ngwahupa ja alondoi, na amundu bhabhampokela mundu bha ntima gwammbone kwa kubhee na ntima gwammbone bhapokela ngwahupa ja ntima gwammbone. ");
INSERT INTO njd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndendakunnobholelanga kweli, bhoabhala bhabhapakwaapekea mundu bhamo hata chikombe cha maachi gakuhima bhamo bha abha bhachoko kwa kubhee nga bhanaajigana, Annoongo bhapakwaapekea ngwahupa jabhe.” ");
INSERT INTO njd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ayesu pabhakajomola kwaalagianga bhaajigana bhenibhala komi na bhabhele bhakabhoka penapo, bhakajenda kujigana na kwaatangachianga bhandu Ngani Jammbone mu hilambo ya ku Galilaya. ");
INSERT INTO njd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ayohana Ambatichaji pabhakibha kuchitabho bhakajoha hikubho hibhatenda Ayesu Kilisto. Ayohana ngabhaatuma bhabhaajigana bhabhe bhakaakonye Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Bholi, mwenga nga bhenibhala bhabhapakuhika, au twaalende bhangi?” ");
INSERT INTO njd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ayesu bhakaajangula, “Nnyendange nkaalobholele Ayohana hikubho muijoine na kuilola, ");
INSERT INTO njd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bhangalola, bhatenda kulola, na bhabhi na mambujupuju bhatenda kulama, na bhangajoha bhatenda kujoha, bhabhawile bhatenda kuyoka na akaahocho bhatangachiwanga Ngani Jammbone. ");
INSERT INTO njd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bhatekutendelwa gammbone bhenibhala bhandu bhangakolanga lipamba na nenga!” ");
INSERT INTO njd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bhaajigana bha Ayohana pabhakajaulanga, Ayesu bhakajemeka kugalobholela malubhalo ga bhandu ngani nnani ja Ayohana, “Nkajaulanga kulola niki konikola kululemba? Bholi, nkapala kulilola linyai lilikajelwa kutali na mboongo? ");
INSERT INTO njd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Handa nga henela, nkajaulanga kulola niki? Nkajaulanga kwaalola mundu bhabhawalite ngobho ya bei ngolongwa? Bhandu bhawalanga ngobho ya bei ngolongwa hutamanga mu nyuumba ja akaakolo bha hilambo. ");
INSERT INTO njd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nambo nkajaulanga kulola niki? Nkajaulanga kwaalola Alondoi? Kweli, ngabha, nga kupunda alondohi. ");
INSERT INTO njd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jonojwe nga jwakalongelwa mu Majaandiko ga Annoongo, abhikulobhola ‘Ndendakwaatuma antumichi jwangu jwa kunani kwa Annoongo annongolelange, kwa kubhee bhapakunhalakia ndela jinu.’ ");
INSERT INTO njd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndendakunnobholelanga kweli, pakati ja bhaana bhoa bha bhandu, bhangabhokela bhabhile akolo kupeta Ayohana Ambatichaji. Hata henela, bhenibhala bhabhile ahocho muno mu umwenye gwa kunani kulihunde kwa Annoongo nga akolongwa kupunda Ayohana. ");
INSERT INTO njd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kubhokela muda gwa Ayohana Ambatichaji mpaka nangocheni, umwenye gwa kunani kulihunde kwa Annoongo gupetulikwa na bhandu bhabhi na machili, na bhandu bhabhilinge na machili bhapalanga kugutola kwa machili. ");
INSERT INTO njd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maana gakwe majigano goa na Malagilo ga Amusa gagajigana muda gwa Ayohana Ambatichaji. ");
INSERT INTO njd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Handa nkombolanga kujeketela kubhee Ayohana nga Aelia bhabhapakuhika ");
INSERT INTO njd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bhabhilinge na machikilo gakujoa na bhajoange!” ");
INSERT INTO njd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bhandu bha nangocheni nichilandanikie na niki? Handa achikakombo bhatamitinge palubhanja pabhahuchilanga hilebhe na kuhemela hilebhe bhatendakutamanga na kwaakemanga akaajabhe na kwaalobholelanga, ");
INSERT INTO njd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tumpotilinge ng'oma nambo mwangota mwangakina! Tujembite nyembo ya malilo nambo mwangota mwangagutanga kwa nnyembo gwa kokoleka!’ ");
INSERT INTO njd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ayohana akahika, akatabha na wala jwangang'wee divai, na bhenaangota bhakalobholanga, ‘Atekupoganikwa na mahoka gabohu!’ ");
INSERT INTO njd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana jwa Amundu akahika, akalyee na kung'wee, na bhenaangota bhakalobhola, ‘Munnolange hojo mundu jwakumenyeka na jwakung'wee muno, aganja bhabhe bhabhakumbanga kodi na bhabhilinge na mabohu!’ Hata henela Machili ga Annoongo gabhonekana gammbone kwa ndela ja hikubho yabhe.” ");
INSERT INTO njd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kubhoka penapo, Ayesu bhakajemeka kwaalongelelanga mabhou bhandu bha hilambo yela, yakubhee pamo na kuitendela yakangachika hijingi, kwa kubhee bhandu bhabhe bhangapala kuleka mabhou gabhenji. ");
INSERT INTO njd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akaalobholelanga, “Kulaga kupakubhee kwaachinu mwangota bhandu bha chilambo cha ku Kolasini! Kulaga kupakubhee kwa mwangota bhandu bha chilambo cha ku Betisaida! Kwa kubhee handa hikubho yakangachika hiikateendeka kwaachinu nga ikatendeka konikola ku chilambo cha Tilo na kuchilambo cha Sidoni, bhandu bhakwe bhakawala ngobho ja majunia, na kuchipakala lihu kulangia kubhee bhatenda kuleka mabohu gabhenji! ");
INSERT INTO njd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nambo ndendakunnobholelanga, lichobha lya kuhukumulwa lipakubhee chindema muno kwa bhandu bha chilambo cha ku Tilo na chilambo cha ku Sidoni bhapakupatanga hukumulo ngolongwa kupeta mwangota. ");
INSERT INTO njd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na mwangota, bhandu bha chilambo cha ku Kafalanaumu, bholi, bhapakuntuluanga mpaka kunani kwa Annoongo? Ngabha hopo, mpakutulukwa pahi mpaka kuwee. Hilebhe yakangachika hiikatendeka kwaachinu handa hikatendeka konokwe ku chilambo cha ku Sodoma, chilambo hecho chikabhee mpaka leleni! ");
INSERT INTO njd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambo nannobholela yakubhee, ipakubhee chindema muno kwachinu bhandu bha chilambo cha ku Sodoma kulaga mu lichobha lya kuhukumulwa kupeta mwenga!” ");
INSERT INTO njd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gono muda Ayesu bhakalobhola, “Ndendakunchukulu mwee Atati, Hangwana bha kunani kulihunde kwa Annoongo na chilambo, kwa kubhee ntekwaahiya hikubho heyo bhandu bhabhilinge na luunda na malango na mwenga ntekwahunukulila bhenibhala bhabhilinge handa bhaana bhachoko. ");
INSERT INTO njd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Elo, Atati, henela nga chimpalite hibhokele.” ");
INSERT INTO njd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Atati bhangu bhambekie hilebhe yoha. Bhaakwa bhakwamanya mwana ila Atati, na wala bhakwamanya Atati ila mwana, na bhoa bhala yakubhee bhapala kuhunukumulilwa na mwana.” ");
INSERT INTO njd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nhikange kwaachangu mwangota bhoa chintenda kuhabhukanga na kutopelwa na mihigo, na nenga mbakumpomoleanga. ");
INSERT INTO njd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngoondange nenga, na nndumikilange nenga na nkachijigane kubhoka kwangu nenga, kwa kubhee nenga nga mundu bha kalipa na wala ngachipuna na mwangota mpakupomolelanga. ");
INSERT INTO njd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwa kubhee majigano nganannyigananga mwangota nga gakulimba.” ");
INSERT INTO njd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gono muda, lichobha limo lya kupomolela Ayesu bhakibha bhatenda kupeta mu migonda ja ngaano. Penapo bhabhaajigana bhabhe bhakakola njala, na bhena angota bhakajemeka kukwachula maache na kupikicha mapemba na kutaunanga njelegwa jabhe. ");
INSERT INTO njd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo pabhakalola genago, bhakaalobholela Ayesu, “Nnole! Bhabhaajigana bhinu bhatendanga chilebhe changapalikwa mu malagilo ga Lichobha lya Kupomolela.” ");
INSERT INTO njd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ayesu bhakaajangula, “Bholi, mwangachoma chibhakatenda Adaudi na akaajabhe pabhakibha na njala? ");
INSERT INTO njd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akajingilanga mu Nyuumba ja Annoongo bhakalyee jenijela mikate jijikabhekwa nnongi ja Annoongo. Bhenabho na akaajabhe bhangapalikwa kulyee mikate hejo nambo akaakung'i jikajabhe. ");
INSERT INTO njd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bholi, mwangachomanga mu Malagilo ga Amusa gagakalobhola kila Lichobha lya Kupomolela Akaakung'i bhagaalibiana Malagilo ga Lichobha lya Kupomolela mu Nyuumba ja Annoongo kwa kutenda gangapalikwa mu Lichobha lya Kupomolela, nambo ngaganikiwa kubhee bhatenda kulemwa? ");
INSERT INTO njd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bahi, nannobholelanga yakubhee pambani pabhile na akolo kupunda Nyuumba ja Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Handa nkahimanyite maana gakwe malobhe gangani, ‘Mbala kwabhonelanga kiha na ngabha mbeeko,’ nkahukumulinge hopo bhandu bhangalemwa. ");
INSERT INTO njd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwa kubhee Mwana bha Mundu nga bhabhatabhala mu Lichobha lya kupomolela.” ");
INSERT INTO njd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ayesu bhakabhoka penapo, bhakajenda mu Nyuumba ja konganilananga Bhayahudi. ");
INSERT INTO njd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Monomwe akibha mundu jumo jwapolite lubhoko. Bahi bhandu bhakaakonya Ayesu, “Bholi, hipalikwa kunlamia mundu Lichobha lya Kupomolela?” Bhakaakonya henela kwaapala atangile bhapatange ndela ja kwaahukumula. ");
INSERT INTO njd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambo Ayesu akaalobholela, “Tulobhole abhi mundu nkati jinu jwabhile na ngondolo jwabhe atekujingila mu liembo, bholi, ngaakamula na kummoa kwa kubhee nga Lichobha lya Kupomolela? ");
INSERT INTO njd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nambo mundu nga bhammbone kupunda ngondolo! Bahi, hipalikwa kutenda gammbone mu Lichobha lya Kupomolela.” ");
INSERT INTO njd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngapena Ayesu bhakaalobholela bheni bhala mundu, “Nnyulule lubhoko lwinu.” Nga bhakagunyulula, lubhoko gukalama gukabhee gumomi handa gonigola gongi. ");
INSERT INTO njd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bahi, Mafalisayo bhakabhoka panja, bhakabhekanga chikomiti chibhou chakupala kwaakoma Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambo Ayesu pabhakajoa genigala bhakabhoka penipala. Bhandu bhajingi bhakaakagula nga bhakaalamia akaatamwa bhoa. ");
INSERT INTO njd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bhakaakanikia bhakoto kwaalobholela bhandu hikubho yabhe. ");
INSERT INTO njd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Akatenda henela kupala genigala gagalongolikwe na Annoongo kwa ndela ja alondoi Aisaya gapate kukweela ");
INSERT INTO njd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nnole antumichi bhangu ndekunhagula, mpaliyon bhangu naampalite muno mu ntima gwangu. Mbakujibheka mboomo jangu nnani jabhe, na bhenabho bhapakutangacha hukumu jangu kwa bhandu bhanga Bhayahudi. ");
INSERT INTO njd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bhapakubhee hopo na kutaukana wala kupota nyenye, na bhaakwa mundu bhabhapakujoha lilobhe lyabhe lipakujohanika hopo mu ndela. ");
INSERT INTO njd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nnai gugutekandaganika ngahengela, wala chibatali chichibhoa lyohi ngachiima, mpaka pabhapakujitenda hukumu jammbone jitabhale. ");
INSERT INTO njd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kwa lina lyabhe bhandu bhanga Bhayahudi bhapakuhobhalela kwa bhenabho.” ");
INSERT INTO njd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Penapo bhandu bhakaaletela Ayesu mundu bhamo bhangalola na bhangakombola kulongela, kwa kubhee bhakibha bhatekuchukilwa na mahoka. Ayesu bhakaalamia penapo bhakakombola kulongela na kulola. ");
INSERT INTO njd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bhandu bhoa bhakakangachanga na kulobholanga, “Bholi, komboleka habha nga Mwana bha Adaudi?” ");
INSERT INTO njd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambo Mafalisayo pabhakajoha genago, bhakalobhola, “Habha mundu bhatenda kugabhoa mahoka kwa machili bhabhagapatite kubhoka kwa akolo bha mahoka bhabhakemitwa Abelizebuli.” ");
INSERT INTO njd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ayesu bhakibha bhagamanya bhabhaganikia, bhakaaalobholela, “Umwenye goa gola gugumetunike kwa malubhalo gagapotana, ngakombola kutama machobha goa na chilambo choachela au akaalongo bhoabhala bhabhametunike malubhalo malubhalo gagatekukanangana, gapakugwee. ");
INSERT INTO njd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Handa Lichetani lijomana na Lichetani lijakwe bhatenda kuchimetula bheene mu mabhoga mabhoga bheene. Bahi umwenye gwabhe gupakujema bholi? ");
INSERT INTO njd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwangota ntenda kulobholanga nenga ndenda kugabhutua mahoka kwa machili ga Abelizebuli, bholi bhandu bhinu bhagabhenga mahoka kwa machili ga aganiki? Ligongo helyo bhenaangota nga bhapakunhukumulanga mwangota. ");
INSERT INTO njd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambo handa nenga ndenda kugabhutua mahoka kwa machili ga Annoongo, bahi mmanyange yakubhee umwenye gwa Annoongo guikite kwaachinu.” ");
INSERT INTO njd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bhaakwa mundu bhabhakombola kujingila mu nyuumba ja mundu jwaabhikle na machili na kwaapoka hilebhe yabhe, pangali kwaatabha oti jono mundu jwabhi na machili? Mpalikwa oti kwaatabha penapo nga pampakombola kwaapoka hilebhe yabhe.” ");
INSERT INTO njd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mundu bhoa bhala bhangalondanika na nenga, bhangana nenga, na bhoa bhala bhangakondanika pamo na nenga bhatenda kupwilingania. ");
INSERT INTO njd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nangocheni nannobholelanga, bhandu bhapakulekelelwa mabhou gabhenji na matukano gabhe goa, nambo bhandu ngalekelelwa mabhou gabhe ga kwaaponja Mboomo ja Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kabhele, bhabhapakulobhola lilobhe lya kwaakana Mwana bha Mundu bhabhapakulekelelwa mabhou gabhe, nambo bhenibhala bhabhapakulobhola lilobhe lya kunkana Mboomo Ja Annoongo ngalekelelwa mabhou gabhe, ngabha mu chenje chilambo au mu chilambo chichipakuhika.” ");
INSERT INTO njd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nkongo gwa kuhalala guogola matunda gakuhalala, na nkongo gwangammbone guhogola matunda gabhou. Nkongo gwamanyika kwa matunda gabhe gagabheleka. ");
INSERT INTO njd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwangota nga mwangalimmbone handa majoka gagabhile na uchoongo! Mkombolanga bholi kulobhola hilebhe yammbone na kongo mmile akaabhou? Kwa kubhee amundu bhatenda kulobhola kubhokana na genigala gagabhile muntima gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu bhakuhalala bhagapia gagabhile gakuhalala kubhoka muntima gwabhe, na amundu abhou bhapia hilebhe hibhou kubhoka muntima gwabhe.” ");
INSERT INTO njd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Bahi, ndendakunnobholelanga, lichobha lya hukumu kila amundu bhapalikwa kulongela nnani ja kila lilobhe lyangammbone libhalongile. ");
INSERT INTO njd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwa malobhe ginu mpakubhonekana mwangalimmbone, na kwa malobhe ginu mpakuhukumulwa kubhee bha kulemwa.” ");
INSERT INTO njd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kubhoka penapo bhabhajigana Malagilo ga Amusa na Mafalisayo bhakaalobholela Ayesu, “Bhannyigana, tupala kuibhona yakangachika kubhoka kwaachinu.” ");
INSERT INTO njd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nambo Ayesu bhakaajangula, “Chibhelei changaamanya Annoongo! Mpalanga hilolelo, nambo chibhelei heche ngapata hilolelo yoha yela nambo jeni jela hilolelo ya alondoi Ayona. ");
INSERT INTO njd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Handa henela Ayona chibhakatama machobha gatatu muhi na kilo mulutumbo lwa hoomba, nga chiipakubhee kwa bhena Mwana bha Amundu chibhapakutama pahi ja undopi kwa machobha gatatu muhi na kilo. ");
INSERT INTO njd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bhandu bha kubhoka chilambo cha ku Ninawi bhapakubhokela Lichobha lya Kuhukumulwa, na bhenaangota bhapakuchikopokea chenje chibhelei chichitekulemwite. Kwa kubhehe bhandu bha chilambo cha ku Ninawi bhenaangota bhakalekanga gabhou gabhe ligongo lya kutangacha kwa Ayona, na pamba bhabhi akolongwa kupunda Ayona! ");
INSERT INTO njd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Haikege bha kuchini bhapakujema muda kwa chebhelei chenjeni pachipakuhumuluwa, na bhenabho bhapakuchikupokea kwakubhee chilemwite. Kwa kubhehe bhenabho bhakajaula ulendo kubhoka kutali, bhakahika kugajohanikia malobhe ga malango ga Asolomoni, na pamba nangocheni bhabhile akolongwa kwaapunda Asolomoni.” ");
INSERT INTO njd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Muuda lihoka palyabhoka amundu, lihoka lityanga tyanga panga machi bhabhikulolea amundu bha kwaajingila na bhangaapata. ");
INSERT INTO njd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Penapo bhabhikuchilobholela, ‘Mbakubhuja ku nyuumba jangu kumokite.’ Na bhenabho pabhapakubhuja kujikolela jela nyuumba jikibha janga chilebhe, jitekupyagilwa na kubhekwa maha, ");
INSERT INTO njd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ngapena bhajenda na kubhatola mahoka bhangi saba, bhabhilinge na machili kupunda bhenabho, na bhoa bhatenda kuhika na kwaajingila bhena amundu. Na bhena mundu bhabhee na abhou kupunda pena kandahi. Nga chiipakubhehe kwa habha bhandu akaabhou.” ");
INSERT INTO njd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ayesu bhakibha tangu bhatendakulongela na nkutuli gwa bhandu muda gono anyongo mundu na akaanung'una bhabhe bhakahikanga kujema panja, bhakapalanga kulongela na bhenabho. ");
INSERT INTO njd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nnole, amundu bhamo bhakaalobholela Ayesu, “Anyongo bhinu na anung'una bhinu bhabhi panja, bhapala kulongela na mwenga.” ");
INSERT INTO njd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ayesu bhakaajangula bhena amundu, “Anyongo bhangu nga bheneki? Na anung'una bhangu nga bheneki?” ");
INSERT INTO njd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ngapena bhakagunyolola lubhoko lwabhe na kwaalangia bhabhaajigana bhabhe, bhakalobhola, “Habha nga anyongo bhangu na anung'una bhangu! ");
INSERT INTO njd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwa kubhehe bhoabhala bhabhatenda chibhapala Atati bhangu bhabhile kunani kulihunde kwa Annoongo, bhenabho nga anung'una bhangu na alombo bhandu na anyongo bhangu.” ");
INSERT INTO njd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lichobha lyolyolyo, Ayesu bhakabhoka mu jeni jela nyuumba, bhakajaula kutama nngulugulu mwa litanda. ");
INSERT INTO njd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nkutuli nkolongwa muno gwa bhandu gukaatindila mpaka Ayesu bhakakweela muntumbwi, bhakatama. Na popopo bhandu bhoa bhakajemanga kubhandikila na litanda. ");
INSERT INTO njd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Penapo Ayesu bhakaalobholela malobhe gajingi kwa kulengania. “Nnyohanikiange mwangota! Kukibha na mundu jumo jwakajaula kupanda mbeju ku mgonda gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pabhatendita kumicha mbeju, yengi hikagwee pandela, hijuni hikaika na kumila mbeju. ");
INSERT INTO njd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yengi hikagwee pamaganga pangali na undopi nnyingi. Hikabhonekana kumela kwa kujomboteka ligongo undopi gukibha nchoko. ");
INSERT INTO njd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nambo lyobha palikajaka, mimela jikajoma kwa kubhehe mikega jakwe jikibha jangatibhila pahi muno. ");
INSERT INTO njd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeju yengi hikagwela pamiibha, na jenejo jikajoma na kuchitabha tabha. ");
INSERT INTO njd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yengi hikagwee papabhile na undopi gwakoondea mimela, na mimela hikahogola mbeju makomi komi yengi mbeju makomi chita na yengi makomi gatatu.” ");
INSERT INTO njd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na Ayesu akajomolekea kulongela, “Bhabhakweti na machikilo gakujonikia na bhajohanike!” ");
INSERT INTO njd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ngapena bhabhaajigana bhabhe bhakahikanga kwaachabhe na Ayesu, “Kwaniki mwenga nnongela na bhandu kwa kulenganikia?” ");
INSERT INTO njd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ayesu bhakaajangula, “Mwangota mpatitinge kuhimanya hikubho yangahunukulilwa ya Umwenye gwa kunani kulihunde kwa Annoongo, nambo bhenaangota bhangapatanga kuimanya hikubho heyo. ");
INSERT INTO njd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwa kubhee amundu bhabhile na chilebhe bhapakujonjokewa, nambo bhanga chilebhe na hata chenecho chichoko chibhabhinacho bhapakupokonyolwa. ");
INSERT INTO njd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nga kwa maana ndendakulongela na bhenaangota kwa kulengania, ligongo bhatendalola nambo ngabhona, bhatenda kujohanikia nambo ngajohanga, na wala ngahimanya. ");
INSERT INTO njd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwa bhenaangota gatekweela genigala gabhakalobhola alondoi Aisaya kubhee, ‘Habha bhandu bhapakujoanikia na kujohanikia, nambo ngaimanya Bhapakulolanga na kukulola, nambo ngalolanga. ");
INSERT INTO njd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwa kubehehe habha ngakombola kuimanya kwa kupepeka, ngajoha kupetela machikilo gabhenji, na bhakanitinge kukola ukweli. Handa hopo bhakalolite kupetela miho gabhenji, na kupetela machikilo gabhe, bhakaimanyite kwa luunda lwabhe lwabhenji, na kundendebhukia, bhalobhola Hangwana, na nenga mbakwaalamia.’” ");
INSERT INTO njd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nambo nhachukange mwangota, kwa kubhee miho ginunji gatendakulola na machikilo ginu gatendakujohanikia. ");
INSERT INTO njd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndendakunnobholelanga kweli, alondoi na bhandu bhajingi bhammbone bhakapalanga kugalola genigala gamugalola bhangagalola, na kugajoha genigala gamugajohanga, na bhakoto kugajoha.” ");
INSERT INTO njd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Bahi, mwangota nnyohanikiange maana ja kulengania kwa bhabhapanda mbeju. ");
INSERT INTO njd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amundu bhabhajoha lilobhe nnani ja Umwenye gwa Annoongo pangali kuhimanya, nga handa jenijela mbeju hihikagwee kubhandikila nndela, na Abohu bhahika kuukula chichipanditwe muntima gwa amundu habho. ");
INSERT INTO njd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jenijela mbeju jijipanditwe pahi ja mwala handa amundu bhabhajoha lilobhe lya Annoogo na kulipokela kwa kuhangalala. ");
INSERT INTO njd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambo kwa kubhee Lilobhe lya Annoongo ngajiingila nkati ja mitima jabhenji. Lyela lilobhe lipakutama kwa muda nchoko tu. Ngapena muda gwa kulaga na kupotekwa hihipakubhokela ligongo lya lilobhe helyo, bhenabho bhalekanga kuhobhalela. ");
INSERT INTO njd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jenijela mbeju jijikagwee pakati ya mikongo ja miibha, nga handa amundu bhabhajoha lilobhe helyo, na lipamba lya umomi hogo na kupala kubhee na hilebhe hijingi ya pachilambo pani kuliminyaminya lilobhe helyo lilipandikwe nkati jinu, ngakombola kutenda gabhapala Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jenijela mbeju jijipanditwe mu undopi gwammbone nga handa mundu jwaajoha lilobhe na kulimanya, na bhenabho bhatenda gabhapala Annoongo na hipakubhee handa mbeju, jimo makomi komi, jengi makomi sita na jengi makomi gatatu.” ");
INSERT INTO njd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ayesu bhakaalobholela bhandu kulengania kongi, “Umwenye gwa kunani kwa Annoongo gutenda kulandana na mundu jwaapandite mbeju jammbone mu ng'onda gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nambo kilo bhandu pabhakagolola lugono, apwati bhabhe bhakahika, na bhapandikia maheya pakati ja nakaponga, na bhakajaula. ");
INSERT INTO njd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bahi, mbeju pajikamela na kujemeka kutumbuka, maheya kabhele gakajemeka gutumbuka. ");
INSERT INTO njd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Akaatumichi bha akola nng'onda bhakaajabhulila, bhakaalobholela, ‘Hangwana, tweenga tupandite mbeju jammbone mu nng'onda gwinu. Bholi maheya gagabhile gabhoka koji?’ ");
INSERT INTO njd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bhenabho bhakaajangula, ‘Apwati nga bhatendite henela.’ Bhenibhala akaatumichi bhakapundanga kwaakonyanga, ‘Bholi, mpala tujende tukagatupule?’ ");
INSERT INTO njd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na jonojwe akaajangula, ‘Ngabha, nkotokugatupula, kwa kubhee pampakutupulanga maheya hago nkombola kutupula pamo na ngaano. ");
INSERT INTO njd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nnekange ngaano na maheya gakole pamo mpaka machobha ga kuhuna. Gena machobha mbakwaalobholela bhakuuna, bhakondanike oti maheya bhagatabhe tabhe makendeka na kujochwa mooto. Nambo ngaano muihunange nkajibhekange mu ngokwe jangu.’” ");
INSERT INTO njd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ayesu bhakaalobholelanga bhandu kulandanikia kongi, “Umwenye gwa kuani kulihunde kwa Annoongo gulandanika na mbeju njoko jijikemwa haladali, yakubhehe amundu bhamo bhakaipetula na bhakapanda mu nng'onda gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jene mbeju nga njoko njoko muno kupeta mbeju yoa, nambo jimelite hubhehe ngolongwa kupeta mimela joha. Kola na kubhee nkongo nkolongwa na hijuni ya kunani bhatendakuhikanga na kuchenga hiyua mu matepo gabhe.” ");
INSERT INTO njd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ayesu bhakaalobholela kulandanikia kongi, “Umwenye gwa kunani kulihunde kwa Annoongo gutekulandanika henela. Mwikege bhapetula ngedule na kujihangalanga mu madebe gabhele ga ukobha gwa ngaano na ukobha goa gutendakutupuka.” ");
INSERT INTO njd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ayesu bhakaatambulila bhandu genago goa kwa kulandanikia. Bhangaalobholela choachela pangali kulandanikia. ");
INSERT INTO njd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gangani gakateenda ili genigala gagakalobholelwa na alondoi gakweele, “Mbakulongela na bhenaangota kwa kulandanikia. Mbakugapiya gangamanyikana kubhoka kuhalakiwa kwa chilambo.” ");
INSERT INTO njd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngapena Ayesu bhakaatabhuka bhenibhala bhandu, bhakajingila mu nyuumba. Bhabhaajigana bhabhe bhakaajendelela, bhakaalobholela, “Ntuatambulile kono kulandanikia kwa nakaponga kumigonda.” ");
INSERT INTO njd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ayesu bhakaalobholela, “Amundu bhabhapandite mbeju jammbone mu nng'onda nga Mwana bha Amundu. ");
INSERT INTO njd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nng'onda gola nga chilambo, mbeju jammbone nga bhenibhala bhandu yakubhee Umwenye nga gwabhenji. Nambo yeniyela nakaponga nga bhenibhala bhandu bha bhenibhala Abohu. ");
INSERT INTO njd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Akaapwati bhabhapandite genigala maheya nga Abohu. Mahuno nga kupela kwa chilambo na bhabhaunanga nga akaatumichi bha Annoongo bha kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Handa chiibhile yeniyela nakaponga pagalondanikwa pamo na kujochwa mooto, nga chiipakubhee lichobha lya kupela chilambo, ");
INSERT INTO njd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana bha Amundu bhapakwaatuma akaatumichi bha kunani kulihunde kwa Annoongo bhabhalondanike kubhoka mu Umwenye gwabhe bhenibhala bhoa bhabhajambukia bhandu bhatendange mabohu, na bhoa bhabhatendite hilebhe hibohu, ");
INSERT INTO njd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kwa kwaajeanga mu mooto gwa kalipa gwangahimaka machobha goha na konokwe bhapakugutanga na kuyaga mino. ");
INSERT INTO njd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngapena, bhenibhala bhandu bhammbone bhapakung'anyima handa lyobha mu Umwenye gwa Atati bhabhe. Henela bhabhakweti na machikilo ga kujahonikia na bhajohanikie!” ");
INSERT INTO njd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Umwenye gwa kunani kulihunde kwa Annoongo gulandana na hilebhe cha bei ngolongwa chichiitwe kumigonda. Amundu bhamo bhakachibhona, na bhakahiya kabhele. Ngabhakaachuka muno muntima na bhakaula kuucha hilebhe yabhe yoa hibhakibha nayo, na bhakajaula kuguemela nng'onda gola.” ");
INSERT INTO njd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kabhele, Umwenye gwa kunani kulihunde gulandanika na amundu bhamo bhabhatendita kulolea lulu jakuhalala. ");
INSERT INTO njd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pabhakapata lulu jimo ja bei ngolongwa, bhakajenda kuucha hilebhe yoa yakibha nayo, bhakahemela lulu jela.” ");
INSERT INTO njd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kabhele, Umwenye gwa kunani kulihunde kwa Annoongo gukalandanika na lipelele lilikachubhikwa mu bahali, likatangia homba yengi yengi. ");
INSERT INTO njd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lipelele palikatweelela, bhandu bhakaliuta panja pajomo, bhakatama, bhakaagulanga homba yammbone na kubhabhekanga nkati ja mapakacha gabhe, na bhangammbone bhakailekelanga. ");
INSERT INTO njd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nga chiipakubhee machobha ga kupela, akaatumichi bha Annoongo bha kunani kulihunde kwa Annoongo bhapakupitila, bhapakubhalangana bhandu akaabohu na bhandu bhammbone, ");
INSERT INTO njd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kwaajeanga bhenabho akaabohu mu mooto gwa kalipa gwangahimika machobha goha. Konokwe bhapakuguta na kuyaga mino.” ");
INSERT INTO njd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ayesu bhakaakonya, “Bholi, haga ganannyigine mgamanyite haga goa?” Bhakajangula, “Eloo, tugamanyi.” ");
INSERT INTO njd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na bhenabho bhakaalobholelanga, “Henela, kila bhabhajigana malagilo ga Amusa bhabhabhee bhabhaajigana bha Umwenye gwa kunani kulihunde bhalandana na akola nyuumba bhabhapiya hilebhe hiyono na ya lolo.” ");
INSERT INTO njd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ayesu pabhakajomola kulobhola kulandanikia hoko bhakabhoka penapo, ");
INSERT INTO njd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","pabhakahika mu chilambo chabhe. Konokwe bhatendita kwaajigana bhandu mu nyuumba ja konganilana Bhayahudi mpaka bhakakangachanga, bhakachilobholela, “Habha bhapatite koji malango haga? Na bhapatite koji machili gakutenda gakangachika? ");
INSERT INTO njd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hojo mwana nga jonijola apundi chelemala? Bholi, anyongo bhabhe ngati Amalia, na akaapwanga mundu ngati angota Ayakobo na Ayusufu na Asimoni na Ayuda? ");
INSERT INTO njd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bholi, akaalombo mundu nga bhoa bhabhabhilinge pambani na tweenga twabhoa? Bahi, bhapatite koji haga goa?” ");
INSERT INTO njd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Henela bhakaakana. Nambo Ayesu bhakaalobholelanga, “Alondohi bhatopewa koakoa ila ngakondekwa kwaachakwe na kwa bhandu bhakwe!” ");
INSERT INTO njd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Henela, bhangatenda yakangachika hijingi penipala ligongo lya kwangahobhalela kwabhe. ");
INSERT INTO njd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Machobha gala, Ahelode bhabhakibha atabhala bha chilambo cha ku Galilaya, bhakajoha ngani yoa hibhakaipangana Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bahi, bhakaalobholela akaatumichi bhabhe, “Habha amundu nga Ayohana Ambatichaji bhabhatekuyoka, nga maana machili gakangachika gatenda lihengo nkati jabhe” ");
INSERT INTO njd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ahelode nga bhabhakaakamula Ayohana na kwaatabha mu nyuumba ja kwaatabhila bhandu, ligongo lya Ahelodia, bhabhakibha hanu bha Afilipo, anung'una bhabhe Ahelode. ");
INSERT INTO njd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ligongo mala hijingi Ayohana bhatendita kwaalobholela Ahelode kubhee, “Ngapaalikwa mwenga kuntola haikege hojo kubhehe hanu bhinu!” ");
INSERT INTO njd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ahelode bhakapala kwaakoma Ayohana, nambo bhakajogopa bhandu ligongo bhakahobhalelanga kubhee Ayohana nga alondohi bha Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Palikahika lichobha lya kuhangalala lya kubhelekwa kwa Ahelode, mwana bha Ahelodia bhakahina nnoongi ja akaageni. Ahelodia bhakaachuka muntima gwabhe, ");
INSERT INTO njd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mpaka Ahelode bhakalapila kwaapekea jono mwali choachela chibhapakwajopa. ");
INSERT INTO njd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na kongo bhabhi kulobholelwa na anyongo bhabhe, bhakajopa, “Mbekee pambani mutwe gwa Ayohana Ambatichaji muchipalo.” ");
INSERT INTO njd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amwenye Ahelode bhakaechuka, nambo ligongo lya konikola kulapila kwabhe nnoongi ja akaageni bhakakulumikia bhapate. ");
INSERT INTO njd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bahi, Ahelode bhakaatuma linyemba bhajende mu nyuumba ja kutabhila bhandu bhakaahekete mutwe Ayohana. ");
INSERT INTO njd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mutwe gwabhe gukaletwa muchipalo, bhakaapekea bhenibhala haikege, na bhenabho bhakaapelekela anyongo bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bhabhaajigana Ayohana bhakahika, bhakagutola malilo ga Ayohana, bhakajenda kuguchika. Ngapena bhakajaula kwaapelekela ngani Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ayesu pabhakajoha genago, bhakabhoka penapo kwa ntumbwi bhakajenda panga bhandu ili bhabhee jika jabhe. Nambo bhandu pabhakapata ngani hejo, bhakaakagula kwa makongono kubhoka mu hilambo hijingi. ");
INSERT INTO njd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ayesu pabhakahika kuntundu ja litanda, bhakalibhona lilubhalo likolongwa lya bhandu bhakaakolela kiha na bhakaalamia akaatamwa bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pajikahika kimuho, bhabhachijigana bhabhe bhakaajendelela na kwaalobholela, “Pamba palulemba, na lyobha litekutipika, mwalekange bhandu bhajaulange mu hilambo yabhenji bhakaemelange chakulya bhalyangange.” ");
INSERT INTO njd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ayesu bhakaalobholelanga, “Ngabha mpaka bhajaulange, mwangota mwapekee chakulya.” ");
INSERT INTO njd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambo bhenaangota bhakaalobholela, “Tukweti mikate nhano na homba bhabhele.” ");
INSERT INTO njd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ayesu bhakaalobholelanga, “Nnetelange pambani.” ");
INSERT INTO njd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bhakaalobholela bhandu bhatamange mu manyai. Ngapena Ayesu bhakajitola jela mikate nhano na bhenibhala homba bhabhele, bhakalola kunani kulihunde kwa Annoongo, bhakaajopa Annoongo. Penapo bhakahimetula jenijela mikate bhakaapekea bhabhaajigana ili na bhenaangota bhabhapekee bhandu. ");
INSERT INTO njd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhandu bhoa bhakalyee na kujukuta. Kubhoka penapo bhabhachijigana nga bhakalokota mbakatika hihikagalila, bhakatweelela hikapo komi na jibhele. ");
INSERT INTO njd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bhandu bhabhakalyee bhakibha akanalome elupu nhano, pangali kubhalangala haikege na bhaana. ");
INSERT INTO njd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Popopo, Ayesu akaalobholela bhabhaajigana bhabhe bhajingilange muntumbwi bhalongolele kujaula kuntundu ja litanda, gono muda bhenabho Ayesu bhatenda kugatabhuka malubhalo ga bhandu. ");
INSERT INTO njd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ayesu pabhakajomola kwaatabhuka bhandu, bhakakwela palitombi kwaajopa Annoongo, bhakibha konokwe jikajabhe mpaka lubhendu palikahika, ");
INSERT INTO njd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na gono muda gonigola ntumbwi gukahika kubhandikila pakati ja litanda, nambo ntumbwi gukapukunywa pukunywa na mboongo. ");
INSERT INTO njd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kilo, kubhandikila na kuchee, Ayesu bhakaajendelela bhabhaajigana bhabhi kujenda panani ja machi. ");
INSERT INTO njd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bhabhaajigana bhabhe pabhakalola bhabhi kujenda panani ja machi bhakajogopa muno, bhakalobhola, “Nga liimwi!” Bhakapotanga nyenye kwa kujogopa. ");
INSERT INTO njd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nambo Ayesu akaalobholelanga, “Nkoto kujogopanga, nkotokange, nga nenga!” ");
INSERT INTO njd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Apetulo bhakaalobholela, “Hangwana, handa nga mwenga kweli, nnobholele nenga nihike panani ja machi konokwe kummile.” ");
INSERT INTO njd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ayesu bhakaalobholela, “Bahi nhike” Bahi Apetulo bhakatuluka kubhoka mu gonigola ntumbwi, akajenda panani ja machi, kwaakagula Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Apetulo pabhakabhona jenijela mboongo, bhakajogopa, bhakajemeka kutibhila, bhakaguta kwa lilobhe likolongwa, “Hangwana, nnjobhole!” ");
INSERT INTO njd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Penapo, Ayesu bhakagunyulula lubhoko lwabhe, bhakaakamula na kwaalobholela, “Mwe mmi na kuhobhalela kachoko! Kwaniki mkibha na lipamba?” ");
INSERT INTO njd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ngapena bhakajingila muntumbwi, na mboongo jikakotoka. ");
INSERT INTO njd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bhabhaajigana bhoa bhabhakibha nkati ja ntumbwi nga bhakatindibhala majugwa na kwaakotimia Ayesu, bhakalobhala, “Kweli mwenga nga Mwana bha Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bhakajomboka litanda, bhakahika kuchilambo cha ku Genesaleti. ");
INSERT INTO njd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bhandu bha konokwe pabhakaamanya bhabhatenda yeneyo nga Ayesu. Bhakajijenea ngani yoa mu hilambo yakubhandikila. Bhandu bhakaaletela Ayesu akaatamwa bhoa, ");
INSERT INTO njd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","bhakaajopa akaatamwa bhalebhatange mbiindo lwa ngobho jabhe, na penapo bhoa bhabhakalebhata bhakalama. ");
INSERT INTO njd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Penapo Mafalisayo teno na bhabhajigana Malagilo ga Amusa nga bhakahika kubhoka kuchilambo cha ku Yelusalemu, bhakaajendelela Ayesu, bhakaakonya, ");
INSERT INTO njd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwaniki bhabhaajigana bhinu ngapokelanga malagilo gatupookile kubhoka kwa akaahokolo bhitu? Ngakuanga mpaka pachindindili handa chiipalikwa pabhapala kulyee chakulya!” ");
INSERT INTO njd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ayesu bhakaajangula, “Kwaniki mwangota ngakagulanga Malagilo ga Annoongo nambo kugapala majigano ginu mwaachina bhene? ");
INSERT INTO njd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Annoongo bhalobhola, ‘Mwaatopee atati na anyongo bhinu,’ na bhoa bhala bhaatukana atati bhabhe au anyongo bhabhe, bhapalikwa bhakomekwe. ");
INSERT INTO njd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambo mwangota mwajigana handa mundu akweti chilebhe choachela chibhakombola kwaajangatila atati bhabhe au anyongo bhabhe, nambo bhakalobhola, ‘Chilebhe chenje ndekwaabhokea Annoongo,’ ");
INSERT INTO njd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mwangota ntenda kujigana bhena mundu, ngapalikwa kwaatopea atati bhabhe na anyongo bhabhe! Henela, nga chintendakubhelua lilobhe lya Anoongo kwa kugakagula majigano ginu mwachina bhene. ");
INSERT INTO njd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwe andendemundu! Alondoi Aisaya pabhakalobhola nnani jinu, ");
INSERT INTO njd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Annoongo bhalobhola, habha bhandu bhandopeanga nenga kwa malobhe jika jabhe, nambo mumitima jabhenji jibhile kutali na nenga. ");
INSERT INTO njd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kukotimia kwabhenji kwanga maana, kwa kubhee hilebhe bhabhajigana nga malagilo ga bhandu tu.’” ");
INSERT INTO njd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ayesu bhakagukema gonigola nkutuli gwa bhandu, bhakaalobholelanga, “Nnyoanikiange, na nhelewange! ");
INSERT INTO njd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chilebhe chichaatenda mundu bhakotokondekwa mu kwaakotimia Annoongo, nambo chenichela chichibhoka nkang'wa. Hecho nga chichaatenda mundu bhakotokondekwa mu kwaakotimia Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngapena bhabhaajigana bhakaajendelela, na kwaakonya, “Bholi, mwe mmanyite kubhee Mafalisayo bhakachimwanga, pabhakajohanga genigala malobhe ginu?” ");
INSERT INTO njd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambo Ayesu bhakaajangula, “Kila chilebhe changapandwa na Atati bhangu bha kunani kulihunde kwa Annoongo chipakutupulikwa. ");
INSERT INTO njd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nkotokwajogopanga bhandu habho! Bhenaangota ngalola, na handa bhangalola bhaatandie bhangalola ajabhe, bhoa bhabhele bhapakujingilanga muliembo.” ");
INSERT INTO njd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Apetulo bhakalobhola, “Ntuatambulile kono kulengania kubhile na maana niki.” ");
INSERT INTO njd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ayesu bhakalobhola, “Na mwangota, ngamanyanga? ");
INSERT INTO njd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bholi, ngamanyanga kubhee kila chichijingila pakang'wa chijenda mulutumbo na kubhoka panja kuliinda? ");
INSERT INTO njd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambo hilebhe hihibhoka pakang'wa hibhoka muntima, na genago nga gagalekelela mundu mu kanikwa mu kwaakotimia Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwa kubhee nkati ja ntima gabhoka maganikilo gabhou, ga koma, ga ngongola, ga uloloi, ga kujibha, ga kopokea hilebhe ya unani na maligo. ");
INSERT INTO njd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Genago nga gagaatenda mundu bhakanikwe mu kwaakotimia Annongo. Nambo kulyee chakulya pangali kuha mabhoko ngaalekela mundu mu kukanikwa mu kwaakotimia Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ayesu bhakabhoka penapo bhakajenda kutama ku hilambo ya ku Tilo na ku Sidoni. ");
INSERT INTO njd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bahi, haikege bhamo bhabhakibha bhatama konokwe yakubhee bhangabhee Anyahudi bhakaahikila Ayesu, bhakajomboa lilobhe, “Hangwana, mwana bha Adaudi, ngolee kia! Amwali bhangu bhatendakuchukilwa na mahoka na atenda kwaalagia muno.” ");
INSERT INTO njd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambo, Ayesu bhangaajangula lilobhe lyoalyela. Bahi, bhabhaajigana bhabhe bhakaajendelela, na kwaalobholela, “Mwaalobholele bhajaule kwaachabhe kwa kubhee bhatenda kutukagula kongo bhabhikulekela nyenye.” ");
INSERT INTO njd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ayesu bhakajangula, “Nenga ndumitwe ligongo lya bhandu bha kuchilambo cha ku Isilaeli bhabhahobhite handa ngondolo bhabhahobhitinge.” ");
INSERT INTO njd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Penapo bhenabho haikege bhakahika na kwaakotimia, bhakalobhola, “Choonde Hangwana, nyangatile,” ");
INSERT INTO njd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ayesu bhakaajangula, “Ngabha yammbone kutola chakulya cha bhaana kuilekela hiimbwa.” ");
INSERT INTO njd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bhenabho haikege bhakaajangula, “Kweli, Hangwana, nambo hiimbwa bhatenda kulyee mbakatika hiitekugwee kubhoka pamecha ja Hangwana bhabhe.” ");
INSERT INTO njd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Penapo Ayesu bhakajangula, “Haikege, kuhobhalela kwinu nga kukolongwa muno, bahi ibhehe kwaachinu handa chimpala.” Popopo amwali bhabhe bhakalama. ");
INSERT INTO njd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ayesu bhakabhoka penapo na kujenda kuntundu ja litanda lya ku Galilaya, bhakakwela palitombi, bhakatama pahi konokwe. ");
INSERT INTO njd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bhandu bhajingi bhakaahikila, bhakaapelekela bhandu bhabhalemile, bhangalola, anangwabha, bhangalola na bhangi bhajingi bhabhakibha akaatamwa, bhakabhabhekanga nnoongi ja makongono gabhe, penapo Ayesu bhakaalamia. ");
INSERT INTO njd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lyenilyela lilubhalo lya bhandu likakangachanga muno pabhakalola, bhangalongela, bhatenda kulongela, bhabhakibha bhabhalemile bhalamite, anangwabha bhatenda kujenda, na bhangalola bhatenda kulola, bhandu bhakaalumbalila Annoongo bha ku Isilaeli. ");
INSERT INTO njd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ayesu bhakaakemanga bhabhaajigana bhabhe, bhakaalobholela, “Ndendakwaakolekea kiha bhandu habha kwa kubhee bhatamitinge na nanenga kwa machobha gatatu, nangocheni bhanga chakulya chichiigalile. Nanenga ngapala kwaalekanga bhajaulange kwaachabhe pangali kulyee, bhakoto kuindukanga nndela.” ");
INSERT INTO njd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bhabhaajigana bhabhe bhakaalobholela, “Pamba tubhile palulemba, tupakupata koji chakulya cha kwaaliyanga habha bhandu bhajingi henela?” ");
INSERT INTO njd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ayesu bhakaakonya, “Mmilinge na mikate jilengwa?” Bhakaajangula, “Chaba na matobhi kachoko.” ");
INSERT INTO njd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bahi, Ayesu bhakaakulumikia bhandu bhatamange pahi. ");
INSERT INTO njd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ngapena bhakatola jenijela mikate chaba na yeniyela homba hibhele, na bhenabho bhakaachukulu Annoongo, bhakahimetula na kwaapekea bhabhaajigana bhabhe, na bhenaangota bhakaapekea bhenibhala bhandu. ");
INSERT INTO njd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhandu bhoa bhakalyee na kujukuta. Ngapena bhabhaajigana bhakalokota mbakatika hiikahigalila, bhakatwelelanga hijaluba saba. ");
INSERT INTO njd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bhenabho bhabhakalyee bhakibha akanalome elupu ncheche, pangali kubhalangana akaahikege na bhaana. ");
INSERT INTO njd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngapena Ayesu bhakaatabhukanga bhandu bhajingi bhakakwela muntumbwi, bhakajenda kuchilambo cha ku Magadani. ");
INSERT INTO njd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo bhakaajendelela Ayesu, na kwaalengela, na kwaajopa bhaalangiange yakangachika kubhoka kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambo Ayesu bhakajangula, “Handa jiikite kimuho mwangota nnobholanga, ‘Malabhi kupakubhee kwammbone ligongo kunani kumaunde nga kukele!’ ");
INSERT INTO njd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na mwangota pajiika kundabhi nnobholanga, ‘Leleni ula jipakoma, ligongo kunani kulihunde nga kukele na kutekubhee na mahunde.’ Mwangota mmanyanga muno kugalambuka namuna mahunde chigabhonekana, nambo ngakombolanga kugalambua hikubho hiibhokela nangocheni gabhii na maana niki. ");
INSERT INTO njd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bhandu bha nangocheni yakubhee nga akaabohu na bhangaamimika! Bhapalanga bhaibhone yakangachika, nambo ngaipatanga yakangachika yoayela nambo yeniyela yakangachika ya Ayona.” Bahi, Ayesu bhakaalekanga, bhakajaula kwaachabhe. ");
INSERT INTO njd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bhabhaajigana bhabhe pabhakajomboka kuntundu ja litanda, bhakahimanyanga kubhee bhatekulibhalila kupetula mikate. ");
INSERT INTO njd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ayesu bhakaalobholela, “Mmangange miho na nchilolekeange nnani ja ngedule ja Mafalisayo na Masadukayo!” ");
INSERT INTO njd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Popopo bhakajemekanga kulobholelana akaachinabhene, “Bhalobhola genago ligongo twangapetula mikate.” ");
INSERT INTO njd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ayesu bhakagamanya chibhakataukananga, henela bhakaalobholelanga, “Mwangota bhamilinge na kuhobhalela kuchoko! Mbona ntenda kutaukana nnani ja kutopetula mikate? ");
INSERT INTO njd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bholi, tangu mwangahimanya? Ngakombokelanga panakajimetula jeni jela mikate nhano jinakaaliya bhandu elupu nhano? Bholi, nkatweleanga hijaluba hilengwa ja mbakatika hiikahigala? ");
INSERT INTO njd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na jenijela mikate saba jijikaaliyanga bhandu elupu ncheche? Bholi, nkakumbanga hijaluba hilengwa ja mbakatika hiikahigalila? ");
INSERT INTO njd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bholi, ngamanyanga kubhee nangalongela nnani ja mikate? Ntamange maha na ngedule ga Mafalisayo na Masadukayo!” ");
INSERT INTO njd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Penapo bhabhaajigana bhakahimanya kubhee bhakaalobholelanga bhatamange maha, ngabha na ngedule ja kuhalakia mikate, nambo nga majigano ga Mafalisayo na Masadukayo. ");
INSERT INTO njd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ayesu pabhakahika kuchilambo cha ku Kaisalia Filipi, bhakaakonya bhabhaajina bhabhe, “Bhandu bhalobhola Mwana bha Mundu nga aganiki?” ");
INSERT INTO njd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakaajangula, “Bhangi bhalobhola kubhee nga Ayohana Ambatichaji, bhangi Aelia, na bhangi bhalobhola Ayelemia, au bhamo bha Akaalondoi.” ");
INSERT INTO njd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ayesu bhakaakonyanga, “Bholi, na mwangota mwalobholanga nenga nga aganiki?” ");
INSERT INTO njd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Asimoni jwakemitwa Apetulo bhakaajangula, “Mwenga nga Akilisito Bhabhaokoa Mwana bha Annoongo bhabhile bhamomi.” ");
INSERT INTO njd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nabhena Ayesu bhakalobhola, “Npakuhachuka mwenga Asimoni mwana bha Ayona, kwa kubhee ngabha mwenga na ngabha mundu bhoabhala bhabhanhunukulile ngani heje, nambo nga Atati bhangu bhabhabhile kunani kulihunde kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nenga ndendakunnobholela, mwenga nga Apetulo, mwenga nga luhala na panani ja luhala holo mbakulichenga lilubhalo lya bhandu bhabhaahobhalela Akilisito na wala machili ga malilo ngakoombola kulichinda. ");
INSERT INTO njd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mbakumpekea chijogolelo cha Umwenye gwa kunani kwa Annoongo, choachela chimpakutabha pachilambo, chipakutabhwikwa na kunani kwa Annoongo, na choachela chimpakujogola pachilambo, chipakujogolekwa na kunani kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ngapena bhakaakanikianga bhabhaajigana bhabhe bhakoto kwaalobholela mundu bhoabhala kubhee bhenabho nga Akilisto. ");
INSERT INTO njd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kubhokela gono muda Ayesu bhakajemeka kwaalobholela bhabhaajigana bhabhe pangali kuhiya kubhee, “Hipalikwa tujende kuchilambo cha ku Yelusalemu na konokwe bhapakupotekwa muno kubhoka kwa akanahota, akaakung'i akolo, na bhabhajigana Malagilo ga Amusa. Na bhenabho bhapakomekwa nambo lichobha lya tatu bhapakuyoka.” ");
INSERT INTO njd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Penapo Apetulo akaatola nnyenje, bhakajemeka kwaakalipila, “Jikoto kubhee henela Hangwana! Ngani hejo ngankolela mwenga!” ");
INSERT INTO njd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambo Ayesu bhakaatendebhukia na kwaalobholela Apetulo, “Mmoke nnongi jangu nenga, Lichetani! Mwenga ntenda kunhibhila mu ndela jangu. Kuganikia kwinu ngabha ga Annoongo, nambo nga ga bhandu!” ");
INSERT INTO njd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ngapena Ayesu bhakaalobholela bhabhaajigana bhabhe, “Mundu bhoabhala handa bhapala kubhee bhabhaajigana bhangu, ipaalikwa bhachikane oti bhene, bhagupetule nchalaba gwabhe, ngapena bhangagule. ");
INSERT INTO njd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwa kubhee mundu bhoabhala bhabhapala kugaokoa umomi gwabhe bheene, bhapakuguhobhea, nambo mundu bhabhapakugubhoa umomi gwabhe ligongo lyangu nenga, bhapakugupata. ");
INSERT INTO njd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bholi, mundu bhapakupata chiniki handa bhapakupata hilebhe yoa ya pachilambo kongo bhabhoite umomi gwabhe? Chakwa choachela! Ngakombola kupata chilebhe choachela cha kombolea kubhujia umomi gwinu. ");
INSERT INTO njd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwa kubhee Mwana bha Mundu bhapakuhika mu ng'anyimo na Umwenye gwa Atati bhangu pamo na akaatumichi bha kunani kwa Annoongo, penapo nga pabhapakwaalepa kila mundu ngwahupa jabhe kubhokela na hikubho yabhenji. ");
INSERT INTO njd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nannobholelanga kweli, bhabhile bhandu bhangi panipani pachilambo ngajomokanga, tangu ja kwaabhona Mwana bha Mundu bhabhi kuhika mu umwenye gwabhe.” ");
INSERT INTO njd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagakajomoka machobha sita, Ayesu bhakaatola Apetulo na Ayakobo na Ayohana, anung'una bhabhe, bhakajenda nabho mpaka palitombi litandamao, na bhakatamanga konokwe jikajabhenji. ");
INSERT INTO njd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pabhakibhanga konokwe, Ayesu bhakatendebhuka kumiho kwabhe nnoongi jabhe. Kumiho kwabhe kukamulikila handa liobha na ngobho yabhe hikibha hiyuu kuu na kung'anyima. ");
INSERT INTO njd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Konokwe bhakabhokela Amusa na Aelia, bhakalongela nabho Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Penapo Apetulo bhakaalobholela Ayesu, “Hangwana, nga yammbone twenga kubhee pambani! Handa mpalite mbakuchenga hilendo hitatu, chimo chinu mwenga, na chimo cha Amusa na chimo cha Aelia.” ");
INSERT INTO njd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Apetulo pabhakibha tangu bhalongela henela, lihunde lihuu likaawekela, na lilobhe lya Annoongo likajohanika kubhoka mu helyo lihunde, “Habha nga mwana jwangu junampala, ndekubhajilwa nabho.” ");
INSERT INTO njd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhabhaajigana pabhakajoha lilobhe helyo, bhakagwee manguku, bhakajogopa muno. ");
INSERT INTO njd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ayesu bhakajabhulila, bhakaakwaanga, bhakaalobholela, “Nnyemange, nkotokujogopanga!” ");
INSERT INTO njd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabhakalola bhangaabhona amundu, nambo bhakibha Ayesu jika jabhe. ");
INSERT INTO njd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pabhakatulukanga palitombi, Ayesu bhakaalobholela, “Nkotokwaalobholelanga bhandu hilebhe muibhonitinge mpaka Mwana bha Mundu pabhapakuyoka.” ");
INSERT INTO njd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bhenibhala bhabhaajigana bhakaakonya Ayesu, “Kwaniki bhabhajigana Malagilo ga Amusa bhalobhola kubhee, Aelia bhapakuhika oti?” ");
INSERT INTO njd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ayesu bhakaajangula, “Kweli, Aelia bhapakuhika oti, bhapakuhika kubheka hilebhe yoa maha. ");
INSERT INTO njd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambo ndendakunnobholelanga, Aelia bhahikite na bhenaangota bhangaamanya, nambo bhakaatendelela hilebhe yoa handa chibhakapalanga. Amwana bha Amundu bhapakwaatendela helahela handa chibhakaatendela Aelia.” ");
INSERT INTO njd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Penapo bhenibhala bhabhaajigana bhakahimanyanga kubhehe bhakaalobholela nnani ja Ayohana Ambatichaji. ");
INSERT INTO njd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabhakaguhikila kabhele gonigola nkutuli gwa bhandu, amundu bhamo bhakaajendela Ayesu bhakaatindibhalila majugwa, ");
INSERT INTO njd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","bhakalobhola, “Hangwana, nngolee kiha mwana jwangu mwanalome ntamwa chihinduhindu, bhatendakulaga muno, na bhombe mala jijingi bhatenda kugwela pamooto au mmachi. ");
INSERT INTO njd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nganneta kwa bhenibhala bhabhajiganwa bhinu nambo bhangakombola kwaalamia.” ");
INSERT INTO njd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ayesu bhakaajangula, “Mwangota mwa bhandu bha nangocheni mwangahobalelanga, bhannekitinge ndela! Mbakutama na mwangota mpaka lii? Mbakumpumilianga mpaka lii? Munnetange jono mwana pambani!” ");
INSERT INTO njd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ayesu bhakagakalipila genago mahoka, na bhenabho gakaabhoka, bhenibhala amwana bhakalama popopo. ");
INSERT INTO njd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngapena bhenibhala bhabhaajigana bhakaajendelela Ayesu pannyenje pabhakibha jikajabhe, bhakaakonya, “Mbone twenga twangakombola kugabhoa genigala mahoka?” ");
INSERT INTO njd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ayesu bhakaajangula, “Kwa kubhehe kuhobhalela kwinu kuchoko. Nannobholelanga kweli, handa nhobhalilinge hata kachoko handa mbeju ja haladali, mpakombola kulilobholela litombi helyelye, ‘Libhoke pamba lijabhule papala,’ na lyenelo lipakujabhula. Chaakwa choachela changakomboleka kwaachinu. ");
INSERT INTO njd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambo lihoka handa heyeye ngabhoka tu ila kwa kujopa na kutabha, na kutama pangali kulyee na kung'wee choachela.” ");
INSERT INTO njd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pabhakibha pamo na bhabhachijigana bhabhe konokwe ku Chilambo cha ku Galilaya, Ayesu bhakaalobholela, “Amwana bha Amundu bhajaula kamulikwa na kwaakamua kwa bhandu. ");
INSERT INTO njd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na bhena bhandu bhapakwakoma, nambo lichobha lya tatu bhapakuyoka.” Na babhaajigana bhabhe bhakahechukanga muno. ");
INSERT INTO njd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pabhakahikanga kuchilambo cha ku Kafalanaumu bhandu bhabhakumbanga kodi ja Nyuumba ja Annoongo bhakaajendelela Apetulo, bhakaakonya, “Bholi, bhabhajigana bhinu bhalepa kodi?” ");
INSERT INTO njd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Apetulo bhakaajangula, “Elo, bhatendakulepa.” Apetulo pabhakabhuja kwaachabhe kabula ja kulobhola lilobhe, Ayesu bhakaakonya, “Mwe Asimoni nnola bholi? Akaakolongwa bha chilambo bhakumbanga kodi kwa bheneki? Kubhoka kwa akaakola chilambo au kubhoka kwa akaageni?” ");
INSERT INTO njd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Apetulo bhakajangula, “Kubhoka kwa akaageni.” Ayesu bhakaalobholela, “Henela, bahi, akaakola chilambo ngapalikwa kulepa. ");
INSERT INTO njd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambo kwa kupala tukotokwaachimwa, nnyende kulitanda, nkalopoe, ntole homba hipakujemeka kutangila, nhunukule nkang'wa jabhe, na mpakugukolela ulohi nkati. Ntole gono ulohi nkalepe kodi ligongo lya nenga na ligongo linu mwenga.” ");
INSERT INTO njd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gonigola muda bhabhachijigana bhakaajendelela Ayesu, bhakaakonya, “Nga bheneki bhabhile akolongwa muno mu Umwenye gwa Annoongo?” ");
INSERT INTO njd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ayesu bhakaankema mwana jumo na kunnyemea pakati jabhenji, ");
INSERT INTO njd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ngapena bhakalobhola, “Ndendakunnobholelanga kweli, handa ngatendebhuka kubhehe handa mwana, ngajingilanga mu Umwenye gwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Henela, bhoabhala bhabhachitulua handa mwana jonjoni, bhenabho nga bhabhabhile akolongwa mu Umwenye gwa kunani kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amundu bhoabhala bhabhampokela mwana handa jonjoni kwa lihina lyangu, bhambokela na nenga.” ");
INSERT INTO njd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nambo amundu bhoabhala handa bhapakwajambukia bhamo bha habhaangota bhabhanhobhalela nenga, kutendanga mabhou, nga mbaya bhaatabhe pantandala liganga likolongwa lya kuyagila na kwaatumbukila mu bahali. ");
INSERT INTO njd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mpakulaganga mwangota bhandu bha heche pachilambo babhajambukia bhandu bhabhahobhalela Akilisito bhatendange mabhou, hikubho hiyaajambua bhandu bhatendange mabhou nga gapakuhika, nambo bhapakulaganga amundu bhenibhala bhabhajambukia bhandu bhangi bhatendange mabhou. ");
INSERT INTO njd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Handa lubhoko au lukongono lwinu lupakunyambukia mabhou, muluekete na kulujea kutali na mwenga. Mbaya kwaachinu kujingila mu umomi gwa machobha goa pangali lubhoko au lukongono, kuliko kulekelelwa mu mooto gwa machobha goa gwangahimika pangali mabhoko mabhele na makongono gabhele. ");
INSERT INTO njd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na handa lio linu lipakunnyambukia mabhou, mbaya mulitupule na kulilekela kutaali. Mbaya kwaachinu kujingila mu umomi mmi na lio limo, kupunda kulekelelwa mu mooto gwangahimika machobha goa kongo mmi na miho goa gabhele.” ");
INSERT INTO njd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ntamange maha! Nkotokummelua bhamo bha habhaangota bhachoko. Ndendakunnobholelanga, akaatumichi bha kunani kwa Annoongo bhabhabhilinge pamo na Annoongo machobha goa.” ");
INSERT INTO njd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Kwakubhehe mwana jwa mundu akahika kwaalolengea bhenibhala bhabhatamanga handa bhabhahobhitinge.” ");
INSERT INTO njd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mnolanga bholi? Handa amundu akweti ngondolo makomi komi, na kuhobha jumo, bhatenda bholi? Kwalekanga bhenibhala makoni tisa na tisa palitombi, na kajaula kunnolea jonijola jwaahobhite. ");
INSERT INTO njd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Handa bhaapatite, ndendakunnobholelanga kweli, bhapakuhachuka mutima nnani ja bhenabho ngondolo jumo kupunda bhenibhala ngondolo makoni tisa na tisa hiigalile. ");
INSERT INTO njd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Helahela, Atati bhinu bha kunani kwa Annoongo ngapala jumo jwa habhabha bhachoko kuhobha.” ");
INSERT INTO njd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Anung'una handa alemwite, mwaajabhulile nkaakelebhuhe mmi mwangota jikajinu. Handa bhannyoine mpakubhehe mumpatite anung'una bhinu. ");
INSERT INTO njd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Handa bhangannyonikia, mwatole amundu bhamo au bhabhele bhabhe pamo na mwenga nyuale nabho ili kwa uchahidi gwa bhandu bhabhele au bhatatu, ili kila chilebhe chibhee maha handa Majaandiko ga Annoongo chigalobhola. ");
INSERT INTO njd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Handa bhangaajonikianga bhenaangota, mugulobholele nkutuli gwa bhandu bhabhanhobhalela Akilisito. Na handa ngagujohanikia nkutuli gwa bhandu bhabhanhobhalela Akilisito, na bhabhe kwaachinu handa amundu bhangaamanya Annoongo au atocha kodi.” ");
INSERT INTO njd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ndendakunobholelanga kweli, chimpakutabhanga pachilambo chipakutabhwa kunani kwa Annoongo, na chimpakujogola pachilambo chipakujogolekwa na kunani kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kabhele ndendakunnobholelanga, bhabhele pakati jinunji handa bhakondikininge pambani pachilambo nnani ja chilebhe choachela cha chibhapakujopanga, Atati bhangu bha kunani kwa Annoongo bhapakutenda chikubho hecho. ");
INSERT INTO njd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwakubhehe pohapala pabhakongananga bhandu bhabhele au bhatatu kwa lihina lyangu, na nenga mi nkati jabhenji.” ");
INSERT INTO njd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngapena Apetulo gubhaajendelaje Ayesu, bhakaakonya, “Bholi, handa anung'una bhangi bhapakupunda kunnemwa nenga, naelekelele palengwa? Mala saba?” ");
INSERT INTO njd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ayesu akaajangula, “Ngalobhola mala chaba tu,” “Nambo mala chabini na chaba. ");
INSERT INTO njd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwakubhee Umwenye gwa kunani kwa Annoongo gubhile henele, amwenye bhamo bhakabhoka kujaula kulola mabhalangano kwa akaatumichi bhabhe. ");
INSERT INTO njd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pabhakajemeka kutenda mabhalangano gabhe, amundu bhamo bhabhakibha na ligambo lya mamilioni gajingi ja mbiya bhabhakaleta kwaachabhe. ");
INSERT INTO njd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bhena amundu bhakibha bhangali chilebhe cha kulepa, henela Hangwana bhabhe bhakaakulumika bhauchwe bheene, hanu bhabhe, bhana na hilebhe yoha hibhakibha nabho, kupala bhalepe magambo. ");
INSERT INTO njd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Penapo, antumichi habho bhakatindibhala majugwa nnongi jabhe, bhakalobhola, ‘Choonde nnende na nenga mbakulepa ligambo linu lyoha!’ ");
INSERT INTO njd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hangwana bhenabho bhakaabhonela kiha, bhakaalekelela ligambo lyelya, bhakaaleka bhajende kwaachakwe.” ");
INSERT INTO njd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambo bhenabho antumichi bhakabhoka, bhakaakolela bhamo bha antumichi nnyakwe bhabhakibha na ligambo lyabhe mbia kachoko. Bhakaahiling'inya pantandala bhabhi kulobhola, ‘Nnepe ligambo linu!’ ");
INSERT INTO njd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Antumichi ajakwe bhakatindibhala majugwa, bhakaapembelela, ‘Nnende nanenga mbakunnepa.’ ");
INSERT INTO njd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nambo bhenabho bhakakana, na bhakaatabha mu nyuumba ja kutabhila bhandu mpaka penapo pabhapakwalepe ligambo lyabhe. ");
INSERT INTO njd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bahi, akaatumichi akaajabhe pabhakalola chilebhe hecho bhakakokolekela muno, bhakajaulanga kwaalobholela amwenye bhabhe nnani ja chikubho hecho chichikabhokela. ");
INSERT INTO njd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Penapo bhena amwenye bhakankema bhenabho antumichi, bhakaalobholela, ‘Mwenga ngabha antumichi bhammbone! Nkanyopa nenga, na nenga ngannekelela ligambo linu lyoa. ");
INSERT INTO njd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bholi, jangapalikwa namwenga kunmmonela kia ntumichi nnyinu handa nanenga chingammonela kia mwenga?’ ");
INSERT INTO njd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Penapo amwenye bhenabho hikanchimwa muno, bhakaatabha mu nyuumba ja kutabhila bhandu bhannagie mpaka pabhapakulepa ligambo lyoa.” ");
INSERT INTO njd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ayesu bhakajomola kwa kulongela, Atati bhangu bha kunani kwa Annoongo chibhapakuntendelanga hela hela handa mwangota ngaalekeleanga anung'una bhabhe kwa ntima gwabhe goa.” ");
INSERT INTO njd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ayesu pabhakajomola kulongela malobhe genago, bhakabhoka ku chilambo cha ku Galilaya bhakajenda ku chilambo cha Yudea, kuntundu ja loochi lwa Yoludani. ");
INSERT INTO njd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nkutuli nkolongwa gwa bhandu gukaakagula konokwe, na bhenaangota bhakaalamianga bhabhakibha na itamwa. ");
INSERT INTO njd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bhangi bha Mafalisayo bhakahika, bhakakonya, “Bholi, hipalikwa amundu kwaaleka hanu bhabhe kwa kulemwa kohakola?” ");
INSERT INTO njd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ayesu bhakaajangula, “Bholi, mwangachomanga mu Majaandiko ga Annoongo, kubhee Annoongo bhabhakaatenda amundu tangu kandahi, nga bhakaatenda hanalome na haikege? ");
INSERT INTO njd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na Annoongo bhakalobhola, ‘Ligongo helyo mwanalome bhapakwaaleka atati na anyongo bhabhe, bhapakondekana na hanu bhabhe, bhoa bhabhele bhapakubhehe mmele gumo?’ ");
INSERT INTO njd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Henela, bhenaangota ngabha bhabhele kabhele, nambo mmele gumo. Bahi, chibhachilondanike Annoongo, amundu bhakoto kuchilekania.” ");
INSERT INTO njd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nambo bhenaangota Mafalisayo bhakaakonya, “Kwaniki, bahi, Amusa bhakatulagia hanalome bhaajandikile malobhe ga ulekani hanu mundu na kwaaleka?” ");
INSERT INTO njd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ayesu bhakaajangula, “Amusa bhakannyeketela kwaaleka hanu bhinu ligongo lya mwangota nga bhandu bha kulimba yakubhee ngajiganikwa. Nambo pena kandahi ngakibha hopo henela. ");
INSERT INTO njd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nenga nannobholelanga, amundu bhoabhala jujwapakwaaleka hanu bhabhe ligongo lyoalyela ngabha ligongo lya ngongola, handa bhapakulombela haikege bhangi, bhenabho bhatenda ngongola.” ");
INSERT INTO njd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bhabhaajigana bhabhe bhakaalobholela, “Handa hikubho ya analome na haikege nga henela, mbaya kutama pangali kulombela.” ");
INSERT INTO njd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ayesu bhakaalobholela, “Nga bhoa bhabhakombola kupokela majigano haga, nambo kwa bhenibhala Annoongo bhabhatekwapekea ngani hejo. ");
INSERT INTO njd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwa kubhehe kutekubhee na hilebhe hijingi hiyatendanga bhandu bhakoto kulombela, bhangi ligongo lya chibhelekwa, bhangi bhatekutendelwa na bhandu bhakoto kubhee na machili gakombola kulombela, na bhangi bhatekuamua bheene akaangweto ngaalombela ligongo lya Umwenye gwa kunani kulihunde. Bhakombolanga kulipokela helye lijigano na bhalipokele.” ");
INSERT INTO njd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngapena bhandu bhakaaletanga bhana kwa Ayesu ili bhaabhekele mabhoko na kwaajopelanga. Nambo bhabhachijigana bhebhe bhakaakanikianga bhenibhala bhandu bhabhakaaletanga. ");
INSERT INTO njd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ayesu akalobhola, “Mwaalekange bhena bhana bhachoko bhaikange kwaachangu, wala nkotokwaahibhilanga, kwa kubhee Umwenye gwa kunani kwa Annoongo nga gwa bhandu bhabhilinge handa habha bhana.” ");
INSERT INTO njd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bahi, bhakaabhekela mabhoko, ngapena bhakabhoka penapo. ");
INSERT INTO njd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu jumo akola hilebhe akaajendelela Ayesu na kwaakonya, “Bhannyigana, ndende chilebhe niki chammbone ili nigupate umomi gwa machobha goha?” ");
INSERT INTO njd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ayesu akaajangula, “Mboni ntenda kukonya nnani ja chilebhe chammbone? Jwaakwa jwabhii jwammbone ila jumo tu, nga Annoongo. Nambo handa mpala kujingila mu umomi gwa machobha goa mgakamule malagilo gabhe.” ");
INSERT INTO njd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jonijola mundu akaakonya, “Malagilo niki?” Ayesu akaajangula, “Nkotokoma, nkoto kutenda ngongola, nkotokujibha na nkoto kulobhola malobhe ga unami, ");
INSERT INTO njd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mwaatopee atati bhinu na anyongo bhinu na mwaapale ajinu handa mwabhene.” ");
INSERT INTO njd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jonijola kakombo akalobhola, “Gena goha ndekugatenda, ndende niki chengi?” ");
INSERT INTO njd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ayesu akaalobholela, “Handa mpala kubhee handa henela Annoongo chibhapala, nnyaule nkauche hilebhe yoha mmi nayo na yene mbiha nkaapekeange akaahocho, na mwenga mpakubhee na chilebhe chammbone kunani kwa Annoongo. Ngapena nhike, ngagule nenga.” ");
INSERT INTO njd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jonijola kakombo paakajoha genago akajaula kongo atekuchimwa ligongo akibha na hilebhe hijingi muno. ");
INSERT INTO njd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Penapo Ayesu akaalobholela bhabhaajigana bhabhe, “Kweli ndendakunnobholelanga, hipakubhee kulimba kwa mundu jwabhi na hilebhe hijingi kujingila mu Umwenye gwa kunani kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kabhele ndendakunnobholelanga, ngabha kulimba muno kwa chinyama chichikemwa ngamia kupeta palipobhole lya chindano, ila ngabha kwa mundu jwabhi na hilebhe hijingi kujingila mu Umwenye gwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bhabhaajigana bhabhe pabhakajoha genago, bhakakangachanga muno na kwaakonya, “Nga aganiki bahi jwaakombola kuokoka?” ");
INSERT INTO njd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nambo Ayesu akabhalolanga, akabhalobholelanga, “Chikubho hecho ngakomboleka kwa bhandu, nambo kwa Annoongo goa gatenda komboleka.” ");
INSERT INTO njd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ngapena Apetulo akalobhola, “Nnole,” “Tulekite hilebhe yoha na kunkagula. Tupakupata niki?” ");
INSERT INTO njd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ayesu akaalobholelanga, “Nannobholelanga kweli, Mwana jwa Mundu chibhapakutama pachitengu chabhe cha Umwenye cha kung'anyima pachilambo chiyono, na mwangota bhanngagulanga mpakutama pahitengu komi na hibhele kongo mmikuhukumulanga hilongelo komi na bhele ya chilambo cha ku Isilaeli. ");
INSERT INTO njd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Helahela mundu joajola jwaalekite nyuumba, au akaanung'una mundu, au akaalombo, au atati, au anyongo au bhana, au migonda, ligongo lya nenga, apakupokela mala mia kupunda chenichela chibhaatendite, na kupata umomi gwangapela. ");
INSERT INTO njd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambo bhabhilinge bhakujemeka, bhapakubhee bha kujomolekea, na bhabhii bha kujomolekea bhapakubhee bhakujemeka.” ");
INSERT INTO njd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Umwenye gwa kunani kwa Annoongo gulandana na mundu jwalemite ng'onda gwa mizabibu, yakubhee bhakabhoka kundabhi muno na kwaakamuanga bhandu mahengo mu ng'onda gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na bhena paakajomola kondana nabho na akaalemi kwaalepa mbiha dinali jimo kwa lichobha, ngapena akabhapelekanga mu nng'onda gwabhe gwa mizabibu. ");
INSERT INTO njd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akabhoka saa tatu kundabhi, akabhona bhandu bhangi bhatekujema pakutendela malonda, bhanga mahengo, ");
INSERT INTO njd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","akaalobholelanga, ‘Nnyaulange mwangota nkatendange lihengo mu nng'onda gwa mizabibu, na nenga mbakunnepanga chiipalikwa.’ ");
INSERT INTO njd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bahi, bhakajaulanga. Bhena akola nng'onda bhakabhoka kabhele saa sita na saa ticha, bhakatenda hiyoyo. ");
INSERT INTO njd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lyobha palikatipika akabhoka kabhele akajaula palubhanja pabhauchilanga bhandu hilebhe na akaakolelanga bhandu bhangi tangu bhajemite pangali lihengo. Akaakonyanga, ‘Kwaniki nnyemite pambani muhi goa pangali kutenda lihengo?’ ");
INSERT INTO njd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na bhenaangota bhakaajangula, ‘Kwa kubhee jwakwa mundu jwaatupekie lihengo.’ Akaalobholelanga, ‘Nnyaulange na mwangota nkatendange mahengo mu nng'onda gwa mizabibu.’” ");
INSERT INTO njd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pajikahika kimuho, jonijola akola nng'onda akaalobholelanga bhakujemelela bhabhe, ‘Mwaakemange akaalemi, mwaalepe ulohi gwabhenji, nnyemeke kwaalepa bhabhakajomolekea kuhika na nyomolekee kwalepa bhenibhala bhabhakajemekanga kuhika.’ ");
INSERT INTO njd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ngapena bhakahikanga bhenibhala bhabhapekiwe mahengo saa komi na jimo, bhakapokelanga kila jumo mbiha dinali jimo. ");
INSERT INTO njd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Henela bhenibhala bhabhakalongelela kupekewa mahengo, bhakaganikianga bhapakulepwanga kupunda, na bhenaangota bhakapekewa kila jumo jwabhe malepo ga lichobha limo. ");
INSERT INTO njd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bahi, bhakapokelanga mbiha yabhenji, na bhangachukanga henela bhakaakokolekela akola nng'onda mwangatutendela yammbone. ");
INSERT INTO njd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bhakalobholanga, ‘Habha bhandu bhabhakajomolekewa kwaakamua mahengo bhatenditinge mahengo kwa muda gwa lichaa limo tu, mboni ntutendile kulandana na bhenaangota wakati twenga tutekupumuilia kutenda lihengo muhi goha!’ ");
INSERT INTO njd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Penapo bhenibhala akola nng'onda bhakaajangula jumo jwabhe, ‘Aganja,’ ‘Nangamponja chilebhe, bholi, mwangalagana na nenga kunepa kwa lichobha? ");
INSERT INTO njd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ntole ulohi gwinu na nnyaule kwaachinu. Mbala kunnepa hojo mundu bhakujomolekea kulandana na mwenga. ");
INSERT INTO njd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bholi, mbalikwa hopo kutenda chimbala na ulohi gwangu? Au ntenda kulola bwihu kwa kubhee nenga nga bhammbone?’” ");
INSERT INTO njd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngapena Ayesu akalobhola, “Bhoa bhabhabhilinge bhakujomolekea bhapakubhee bhakujemeka, na bhoa bhabhabhilinge bhakujemeka bhapakubhee bhakujomolekea.” ");
INSERT INTO njd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ayesu paakibha atenda kujaula kuchilambo cha ku Yelusalemu, akaapetulanga bhenibhala bhabhaajigana komi na bhabhele pajika jabhenji, na nndela akaalobholelanga, ");
INSERT INTO njd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nnyoanikiange! Akaalobholelanga kubhee, “Tutenda kujenda kuchilambo cha ku Yelusalemu, na konokwe Mwana jwa Mundu apakubhekwa mmabhoko ga akakolo bha akaakung'i na bhabhajigana Malagilo na bhenaangota bhapakwaahukumula akomekwe. ");
INSERT INTO njd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ngapena bhapakwaapeleka kwa bhandu bhangabhee Bhayahudi bhapatange kwaatendelanga mbeenje, na kwaapota mihimbati, na kwaabhamba panchalaba na kwaakoma, nambo lichobha lya tatu apakuyoka.” ");
INSERT INTO njd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngapena ahanu bha Azebedayo pamo na bhana bhabhe bhakaajendelela Ayesu bhakaatindibhalila majugwa na kwaajopa chilebhe. ");
INSERT INTO njd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ayesu bhakaakonya, “Bholi, mpala niki?” Nabhena ahikege bhakajangula, “Nnobholele kweli mu Umwenye gwinu, habha bhana bhangu bhabhele bhapakutamanga jumo kunnelo, na jongi kunchiji mu Umwenye gwinu.” ");
INSERT INTO njd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ayesu bhakajangula, “Ngachimanya chinnyopanga nga chiniki. Bholi, nkombolanga kuching'wela chikombe cha kulaga ching'wela nenga yakubhee mmi kubhandikila kuching'wela?” Bhakajangulanga, “Tutenda kombola.” ");
INSERT INTO njd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ayesu bhakaalobholelanga, “Kweli mpakung'wela chikombe changu, nambo kutama upande gwangu gwa kunnelo au kunchiji ngabha mamulaka gangu kunnpekeanga, nambo bhapakupatanga bhenibhala bhabhekitwe tayali na Atati bhangu.” ");
INSERT INTO njd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhenibhala bhabhaajigana komi bhangi pabhakajohanga genago, bhakaachimwanga bhena angota Ayakobo na Ayohana. ");
INSERT INTO njd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngapena Ayesu akaakemanga bhoa pamo na kwaalobholelanga, “Ntendakuhimanyanga kubhee chilongola cha bhandu bhanga Bhayahudi, bhatenda kwaatabhalanga bhandu bhabhenji kwa machili, na bhabhaatandaha bhandu na kulangia mamulaka gabhenji. ");
INSERT INTO njd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambo kwaachinu ikoto kubhee henela, nambo bhabhapala kubhee chilongola nkati jinunji bhapalikwa kubhee antumichi bhinunji, ");
INSERT INTO njd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na mundu johajola jwaapala kubhee chilongola kwaachinunji bhapalikwa kwaatumikilanga bhangi. ");
INSERT INTO njd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Handa henela Mwana jwa Mundu jwangahika ili kwaatumikila, nambo kutumikila na kugubhoa umomi gwabhe ili kwaakomboanga bhandu bhajingi.” ");
INSERT INTO njd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ayesu paakabhoka kuchilambo cha ku Yeliko na bhabhaajigana bhabhe, bhandu bhajingi bhakaakagula. ");
INSERT INTO njd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bahi, pakibha na bhangalola bhabhele bhatamitinge nngulugulu ja ndela, na bhenaangota pabhakajoha Ayesu bhatenda kupeta, bhakaajaomboa lilobhe, bhabhi kulobholanga, “Hangwana, Mwana jwa Adaudi, ntukolele kiha!” ");
INSERT INTO njd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lyenilyela lilubhalo lya bhandu likaakalipila na kwaalobholelanga bhakotokange. Nambo bhenangota bhakapundanga kujomboa lilobhe, “Hangwana, Mwana jwa Adaudi, ntukolele kiha!” ");
INSERT INTO njd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ayesu akajema na akaakemanga na kwaakonyanga, “Mpalanga nintendelange niki?” ");
INSERT INTO njd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bhakaajangula, “Hangwana, tupala tulole.” ");
INSERT INTO njd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bahi, Ayesu akaabhonela kiha, akaakwanga miho gabhenji, na popopo bhakakombolanga kulola. ");
INSERT INTO njd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ayesu na bhabhachijigana bhabhe pabhakahika mu chijiji cha Betifage, mu litombi lya Mizeituni kubhandikila na kuchilambo cha ku Yelusalemu, ngapena Ayesu apakwatumanga bhabhaajigana bhabhele, ");
INSERT INTO njd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akaalobholelanga, “Nnyaulange mu chijiji chichibhii nnongi jinu na mpakunkolela liponda atabhitwe pamo na mwana jwakwe. Nkaajogolelange na mwaaletange kwaachangu. ");
INSERT INTO njd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na handa amundu bhankonyitinge, mwaalobholele, ‘Hangwana bhatenda kwaapala.’ Na bhena bhapakunnekanga guna kamo.” ");
INSERT INTO njd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chikubho hecho chikatendeka ili genigala gagakalobholekwa na akaalondoi bha Annoongo gakweele, ");
INSERT INTO njd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwalobhelele bhandu bha chilambo cha ku Yelusalemu Nnole, Amwenye bhinu bhatendakuhika! Bhabhi na kiha na bhatekwela liponda, mwana liponda, mwana jwa liponda.” ");
INSERT INTO njd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Henela, bhenibhala bhabhachijigana bhabhe bhakajaulanga handa bhabhakalagikiwa na Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakaaleta bhenibhala liponda na mwana jwakwe, bhakatandika ngobho yabhenji nnani jabhenji na Ayesu bhakatama panani jakwe. ");
INSERT INTO njd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nkutuli gwa bhandu bhajingi bhakatandikanga ngobho yabhenji nndela, na bhandu bhangi bhakaeketanga nyaambi ya mikongo kuijanjaa nndela. ");
INSERT INTO njd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nkutuli gwa bhandu gugukalongolela nnongi ja Ayesu na nkutuli gugukaakagula kuyetu gwoa gukapotanga nyenye bhabhi kulobholanga, “Alumbalilwe mwana jwa Adaudi! Atekutendelwa gammbone bhenabho bhabhahika kwa lihina lya Hangwana! Alumbalilwe Annoongo bhabhabhile kunani kwa Annoongo!” ");
INSERT INTO njd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ayesu pabhakajingila chilambo cha ku Yelusalemu, chilambo choha chikapupulika. Bhandu bhatendita konyananga, “Hojo nga aganiki?” ");
INSERT INTO njd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bhandu bhabhakibha mu lyenilyela lilubhalo bhakalobholanga, “Hojo nga Ayesu bha ku Nazaleti chilambo cha ku Galilaya.” ");
INSERT INTO njd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ngapena Ayesu akahika mu Nyuumba ja Annoongo, akaabhabhenga bhandu panja bhabhakibha bhatenda kuemela na kuuchanga hilebhe mu Nyuumba ja Annoongo, bhakahipendekula mecha ya bhabhatindigana mbiya, na hitengu yabhenji bhabhahuchitanga nguunda, ");
INSERT INTO njd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","na kwalobholelanga, “Jijaandikwe mu Majandiko ga Annoongo, ‘Nyumba jangu jipakemwa nyumba ja kujopela.’ Nambo mwangota ntekujitendanga kubhee likunguni ja akaabwii.” ");
INSERT INTO njd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bhangalolanga na akanangwabha bhangi bhakaajendelela Ayesu mu Nyuumba ja Annoongo, na bhena Ayesu bhakaalamianga. ");
INSERT INTO njd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nambo akaakung'i akolongwa na bhabhajigana Malagilo ga Amusa pabhakagalola yakangachika gagatendikwe na Ayesu, na bhana bhapalianga lilobhe lyabhenji mu Nyuumba ja Annoongo bhabhikulobholanga, “Bhalumbalilwe Mwana jwa Adaudi,” bhakachimwanga. ");
INSERT INTO njd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Henela bhakaakonya Ayesu, “Bholi, ngajoa chibhalongela bhana?” Ayesu akabhajangulanga, “Eloo, ndendakujoha,” Bholi “Mwangapatanga kuchoma Majandiko gangani? ‘Kwa kang'wa ya bhana bhachoko na hilemba bhatendakunnumbalila mwenga.’” ");
INSERT INTO njd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ayesu bhakabhoka penapo na kujaula ku chilambo cha ku Betania, bhakagoloka konokwe. ");
INSERT INTO njd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ayesu akobhoka kundabhi tuputupu mu chilambo cha ku Betania kubhuja ku chilambo ku Yelusalemu, akajoa njala. ");
INSERT INTO njd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akagubhona nkojo gumo nngulugulu ja ndela, akagujaulila, nambo akagukolela gwanga choachela nambo mahamba jika. Bahi, akagulobholela, “Nkotokuogola matunda ng'o!” Popopo kongo gwa nkojo gukajoma. ");
INSERT INTO njd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bhabhachijigana bhabhe pabhakagulola bhakahechukanga, bhabhikulobhola, “Kwaniki gongo ntini gutekunyalila chindema?” ");
INSERT INTO njd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ayesu akaajangulanga, “kweli ndendakunnobholelanga, handa nkahobhalilinge pangali kubhee na lipamba, ngabha kubhee mpakombolanga kutenda tu genigala gagatendikike kwa gongo ntini, nambo hata nkalilobholela litombi, ‘Nchitupule nkachijee mu bahali,’ na lyene lipakutendeka. ");
INSERT INTO njd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na handa nkahobhalelanga, choachela chimpakujopanga kwa Annoongo, mpakupatanga.” ");
INSERT INTO njd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ayesu pabhakabhuja kabhele pa Nyuumba ja Annoongo, bhakibha bhatenda kujigana. Pabhakibha bhatenda kujigana, Akaakung'i bhakolongwa na akanahota bhakaakonya, “Ntenda hikubho heye kwa mamulaka niki? Na aganiki bhampile ganga mamulaka?” ");
INSERT INTO njd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ayesu akaajangulanga, “Na nenga mbakunkonyanga nkonnyekelo gumo, handa mpakujangula bahi na nenga mbakwaalobholela ndenda hikubho heye kwa mamulaka niki. ");
INSERT INTO njd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bholi, mamulaka ga Ayohana ga kubaticha bhandu gakabhoka kwa aganiki, gakabhoka kunani kwa Annoongo au kwa bhandu?” Nambo bhakalobholelana akaachinabhene henela, “Tulobhole chiniki? Handa tulobhwile, ‘Gakabhoka kunani kwa Annoongo,’ apakutukonya, ‘Kwa niki mwanganhobhalelanga Ayohana?’ ");
INSERT INTO njd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nambo handa tulobwile, ‘Gakabhoka kwa bhandu,’ Tutendakujogopanga bhandu chenichela chibhapakutendanga, ligongo bhenaangota bhatendakondanga kubhee Ayohana nga Alondoi bha Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bahi, bhakaajangula Ayesu, “Tuhimanyi hopo!” Na bhena Ayesu akaalobholelanga, “Na nenga kabhele ngannobholelanga ndenda hikubho heye kwa mamulaka niki.” ");
INSERT INTO njd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwangota mmonanga bholi? Pakibha na mundu jumo jwakibha na bhana bhabhele. Bhakajabhulila jonijola jwa kujemeka, akaalobholela, ‘Mwana jwangu, leleni nnyaule nkatende lihengo mu nng'onda gwa mizabibu.’ ");
INSERT INTO njd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jonijola kakombo akaajangula, ‘Nalema!’ Nambo baadae akagatendebhua maganikio gabhe, akajaula kupangana lihengo. ");
INSERT INTO njd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ngapena bhenibhala atati akaalobholoela mwana jwabhe jwa bhele hela hela. Nabhena bhakajangula, ‘Elo, atati,’ Nambo bhangajaula kupangana lihengo. ");
INSERT INTO njd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bholi! Nga ganiki nkati ja abha bhabhele bhabhakatenda gagapalikwa na atati bhabhe?” Bhakajangulanga, “Bhenibhala mwana jwa kujemeka.” Bahi, Ayesu bhakaalobholelanga, “Kweli nannobholelanga, bhatochanga kodi na bhandu bha ngongola bhapakunnongolelanga kujingila mu Umwenye gwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa kubhehe Ayohana ambatichaji akahika kwaachinunji kunnangianga namuna chiipalikwa kutama kwa kwabhajila Annoongo, na mwangota mwangahobhalela, nambo bhatochanga kodi na bhangongola bhakaahobhalela, na mwangota hata pamkagabhweni genigala goa mwangagalekanga na kuhobhalela.” ");
INSERT INTO njd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ayesu akalobholelanga, “Nnyohanikiange kulandanikia kongi,” Pakibha na mundu jumo akola migonda, na jono akalema mizabibu, akalitindila luwani, akahemba lilibha lya kuminyila zabibu jabhe, akachenga hilendo ya akaalendei. Ngapena akalijahika kwa akaalemi na kujaula ulendo gwa chilambo cha kutaali. ");
INSERT INTO njd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Muda gwa kuhuna pagukahika, bhakaatumanga akaatumichi bhabhe kwa bhenibhala akaalemi, ili bhakapokelange malepo kubhoka kwa bhena bhandu bhabhakajaika nng'onda gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bhenibhala akaalemi bhakaakwenyanga akaatumichi bhenibhala, bhamo bhakaapota, bhangi bhakaakoma na bhangi bhakaapota kwa maganga. ");
INSERT INTO njd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bhenibhala akola ng'onda akaatumanga akaatumichi bhangi, bhajingi kupeta bha kandai. Bhenibhala akaalemi bhakaatendelanga namuna jela jela. ");
INSERT INTO njd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kupela kwa yoa akaatuma mwana jwabhe kongo akiganikia, “Bhapakunnyoanikia mwana jwangu.” ");
INSERT INTO njd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambo bhenibhala akaalemi pabhakaabhona mwana jwabhe akalobholelananga akaachinabhene, “Hojo nga nnekelwa, twaakome ili tupakuhipetula hilebhe yabhenji!” ");
INSERT INTO njd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bahi, bhakaakamula chikwenya, bhakaapia panja ja gonigola nng'onda gwa mizabibu, bhakaakoma. ");
INSERT INTO njd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ayesu akaakonyanga, “Nangocheni pabhapakuhika bhenibhala akola nng'onda gwa mizabibu, bhapakwaatenda niki bhenabho akaalemi?” ");
INSERT INTO njd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhenabho bhakaajangulanga, “Apakwaakoma bhenibhala akaabhou, na gonigola nng'onda apakugukamua kwa akaalemi bhangi yakubhehe bhapakunpekea lilubhalo lya mahuno kwa muda gugupalikwa.” ");
INSERT INTO njd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Penapo Ayesu akaakonyanga, “Bholi, mwangachomanga ngani heje mu Majandiko ga Annoongo? ‘Liganga bhabhalikanite akaachengi nangocheni litekubhee liganga lilipalikwa muno. Hangwana nga bhabhatendite chikubho chenjeni, na chene chikubho nga chakangachika muno kwaachitu!’” ");
INSERT INTO njd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Henela ndendakunnobholelanga.” “Umwenye gwa Annoongo bhapakugubhoa na bhapakupekewa bhandu bhangi bhabhapakutendanga gabhagapala Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Mundu joajola jwapakugwila paliganga helyo apakuhengeleka hipande hipande, nambo jonijola lilipakwagwila liganga helyo apakuyagika muno.” ");
INSERT INTO njd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akakung'i akolo na Mafalisayo pabhakajohanga kono kulandanikia kwabhe bhakahimanyanga kubhee Ayesu akibha atenda kwaalongela bhenaangota. ");
INSERT INTO njd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Penapo bhakibha bhalolea ndela ja kwakamula Ayesu, nambo bhakaajogopanga bhandu ligongo bhenaangota bhakahimanyanga kubhee Ayesu nga Alondoi. ");
INSERT INTO njd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ayesu akalongela nabho kabhele kwa kulandanikia, kwa kwaalobholelanga, ");
INSERT INTO njd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Umwenye gwa kunani kulihunde gulandana na akolo bhamo bhabhapanganikie chikakombo jwabhe chakulya cha ulombela. ");
INSERT INTO njd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bahi, akaatumanga akaatumichi bhabhe kwaakema bhenibhala bhabhakalalikwa mu lichobha likolongwa lya ulombela, nambo bhandu bhabhakalalikwa bhakakananga kuhika. ");
INSERT INTO njd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngapena bhakaatumanga kabhele akaatumichi bhangi bhabhikulobhola, ‘Mwaalobholelange bhenibhala bhabhakalalikwa, yakulya yangu hibhi tayali ligongo linu, ndekuchenja makambako ga ng'ombe na ng'ombe yengi hiinenipe, kila chilebhe chibhi tayali, nhikange kuulombela.’ ");
INSERT INTO njd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambo bhenaangota bhangajeketela, bhakajaula kwaachina bhenji, jumo kunng'onda gwabhe, na bhangi ku mahengo gabhe, ");
INSERT INTO njd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na bhangi bhabhakahigalila bhakaakamulanga akaabhanda bhabhe, na kwapotanga na kwaakomanga. ");
INSERT INTO njd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bahi bhenibhala amwenye akachimwa muno, bhakaatumanga manyemba gabhe kwaatinihanga bhenibhala bhoa bhabhakoma bhandu na kutinia chilambo chabhe kwa mooto. ");
INSERT INTO njd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ngapena akabhalobholelanga akaabhanda bhabhe, ‘Yakulya ya ku ulombela hibhi tayali kweli, nambo bhabhakalalikwa bhangapalikwa kuhika. ");
INSERT INTO njd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nangocheni nnyaulange mu ndela ya hilambo ya bhandu bhajingi, na bhenibhala bhoa bhampakwaabhonanga mwaakemange bhahikange ku ulombela.’ ");
INSERT INTO njd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bhenibhala akaabhanda bhakabhokanga, bhakajaulanga mu ndela ya hilambo ya bhandu bhajingi, bhakaakondekananga bhoa bhabhakaabhonanga, bhammbone na akaabhou, chebule jijikatendekela ulombela jikatwelela akaageni.” ");
INSERT INTO njd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Amwenye pabhakajingila kwaalola akaageni, akaalola mundu jumo jwakibha jwangawala ngobho ja kuulombela. ");
INSERT INTO njd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amwenye akaakonya, ‘Aganja, ntekujingilabholi momboni pangali kuwala ngobho ja ulombela?’ Nambo jonojwe akatama jii. ");
INSERT INTO njd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngapena amwenye akaalobholelanga akaabhanda bhabhe, ‘Muntabhange makongono na mabhoko, mwajee panja palubhendu, konokwe bhapakuguta na kuyaga mino.’” ");
INSERT INTO njd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ayesu akajomolekea kwa kulobhola, “Bhajingi bhatekulalikwanga, nambo bhabhatekuagulikwa nga kachoko.” ");
INSERT INTO njd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngapena, Mafalisayo bhakajaulanga, na kulolea ndela ja kwaatangia Ayesu kwa malobhe gabhe. ");
INSERT INTO njd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bahi, bhakaatumanga bhabhachijigana bhabhe pamo na lilubhalo lya Ahelode. Bhakaakonya, “Bhannyigana, tuhimanyi kubhee mwenga nga amundu bhannongela kweli, na ndela ja Annoongo mwahijigana mu kweli, ngaajogopa amundu bhoabhala, kwa kubhee mwenga ngalola ukolo gwa mundu. ");
INSERT INTO njd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bahi, ntulobholele ching'anikia mwenga. Kwani twenga tupalikwa kulepa kodi kwa Akolo jwa ku Loma?” ");
INSERT INTO njd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambo Ayesu akagamanya mabhou gabhenji, akalobholelanga, “Mwangota akaandendemundu kwa niki ntendakundeganga? ");
INSERT INTO njd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nnangiange jene mbiha ja kulepela kodi!” Na bhenaangota bhakaaletela jene mbiha. ");
INSERT INTO njd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bahi, Ayesu akaakonyanga, “Kumiho na lihina helyelye nga lya aganiki?” ");
INSERT INTO njd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakaajangula, “Nga ja amwenye bha ku Loma.” Penapo Ayesu akalobholelanga, “Bahi, hiibhile ya akolo bha ku Loma mwapekee Akolo jwa ku Loma, na ga Annoongo mwapekee Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pabhakajohanga genago bhakakangachanga, bhakaaleka na kujaulanga. ");
INSERT INTO njd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lichobha lyolyolyo, Masadukayo bhabhalobhola bhandu bhabhawilinge ngayoka bhakajendelela Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bahi, bhakaalobholelanga, “Bhannyigana, Amusa akalobhola amundu bhabhalombile handa ajomwike pangali kuleka bhana, hipalikwa anung'una bhabhe bhaalombele bhena nhwelwa, ili bhaapatile anung'una bhabhe bhana. ");
INSERT INTO njd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bahi, pamba pachitu pakibha na akaanung'una saba. Jwa kujemeka akalombela ngapena akajomoka pangali kubheleka bhana, na anung'una bhabhe akaalombela jono mwikege nhwelwa. ");
INSERT INTO njd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chikubho chochocho chikaabhokela jono jwa bhele, na jwa tatu, mpaka jwaa saba. ");
INSERT INTO njd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kupela kwa yoa bhenibhala mwikege akajomoka. ");
INSERT INTO njd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bholi, lichobha lya kuyoka bhabhawilinge ahikege bhenabho bhapakubhee hanu bha aganiki pakati ja bhenibhala akaanung'una saba? Kwa kubhee bhoa saba bhakibha bhatekwaalombela.” ");
INSERT INTO njd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ayesu akaajangula bhenibhala Masadukayo, “Mwangota ntekulemwanga? Ligongo ngahimanyanga Majandiko ga Annoongo wala Machili ga Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lichobha lya kuyoka bhandu ngalombela wala kulombwa, nambo bhapakubhee handa Bhatumichi bha kunani kwa Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nambo nnani ja kuyoka mwangachomanga chenichela Annoongo chibhannobholilinge kubhee, ");
INSERT INTO njd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenga nga Annoongo Aaibulahimu, Annoongo bha Aisaka, na Annoongo bha Ayakobo.’ Bahi, Annoongo ngabha Annoongo bha bhandu bhabhawilinge nambo nga Annoongo bha bhandu bhabhilinge bhamomi.” ");
INSERT INTO njd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lyenilyela lilubhalo lya bhandu palikajoha genago, likakangacha kwa majigano gabhe. ");
INSERT INTO njd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo pabhakajoha kubhee Ayesu bhakibha bhatekwakotoanga Masadukayo, bhakakongananga pamo. ");
INSERT INTO njd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jumo jwabhenji, jwaajigana malagilo ga Amusa, akaakonya Ayesu kwa kunlengela, ");
INSERT INTO njd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bhannyigana, nga amuli niki jijibhii ngolongwa mu malagilo?” ");
INSERT INTO njd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ayesu akaajangula, “Mwapale Hangwana Annoongo bhinu kwa ntima gwinu goa, na kwa mbomo jinu joha, na kwa luunda ginu goa. ");
INSERT INTO njd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jenjeni nga amuli jijibhii ngolongwa, kabhele nga ja kujemeka. ");
INSERT INTO njd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na jabhele jijilandana na jenejo nga jenjeni, ‘Mwaapale andami ajinu handa chinchipala mwabhene.’ ");
INSERT INTO njd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagilo na Majandiko ga Akaalondoi bha Annoongo hitekubhokela na heye Amuli jibhele.” ");
INSERT INTO njd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Muda gogogo Mafalisayo bhenibhala tangu bhakondikine penipala, Ayesu akaakonyanga, ");
INSERT INTO njd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwangota nnolanga bholi kwa ngani ja Akilisto? Bholi, nga amwana bha aganiki?” Bhakaajangulanga, “Jonojwe nga mwana jwa Adaudi.” ");
INSERT INTO njd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ayesu akaalobholelanga, Bahi, Ikombolekabholi “Kwa machili ga Mboomo ja Annoongo, Adaudi ankeme, ‘Hangwana?’ Kwa kubhee Adaudi akalobhola, ");
INSERT INTO njd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Hangwana bhakaalobholela, Hangwana bhangu. Ntame lubhoko lwangu lwa kunnelo, mpaka naabhekange akaapwati bhinu pahi mpaka pampakwapetanga akaapwati bhinu.’ ");
INSERT INTO njd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bahi, handa jikibha Adaudi bhaakema Akilisito ‘Hangwana,’ hikombolekabholi Akilisito mwana jwabhe?” ");
INSERT INTO njd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jwakwa mundu joha jola jwakakombola kunnyangula Ayesu chilebhe. Kabhele kubhoka lyene lichobha jwakwa jwaakajiga kwaakonya kabhele chilebhe. ");
INSERT INTO njd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngapena Ayesu bhakalilobholela lilubhalo lya bhandu pamo na bhabhachijigana bhakwe, akalobhola, ");
INSERT INTO njd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bhabhajigananga Malagilo ga Amusa na Mafalisayo bhakweti mamulaka ga kugaatambulana Malagilo ga Amusa. ");
INSERT INTO njd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwa henela mkamulange na kupangana choachela chibhapakunnobholelanga. Nambo nkoto kugajiga gabhatendanga, kwa kubhee ngatendanga genigala handa chibhalobholanga. ");
INSERT INTO njd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bhenaangota bhatendakwaapapianga bhandu mihigo ja kutopa na ja kulimba paming'ongo jabhenji, nambo bhenaangota ngakombolanga kunyulula hata lukonji ili kupetula jene mihigo ja kutopa. ");
INSERT INTO njd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bhenaangota bhapangana hikubho yabhenji yoa kupala bhabhonekane na bhandu. Bhatenda kuwala hipande ya mambendela hiitekujandikwa malagilo mmutwe na mmabhoko gabhenji hiibhi na Majandiko ga Malagilo ga Amusa. ");
INSERT INTO njd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mu lichobha likolongwa bhapalanga kutama mu hitengu yakutopea mu Nyuumba ja konganilananga Bhayahudi. ");
INSERT INTO njd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na kupalanga kulamukilwa kwa kutopewa mahali pakonganilana bhandu bhajingi na kupala bhandu bhabhakeme, ‘Bhannyigana.’ ");
INSERT INTO njd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambo mwangota nkoto kemwa, ‘Bhannyigana,’ kwa kubhee Bhannyigana bhinu nga bhamo jika jabhe, na mwangota mwabhoa nga ntendakungagula nenga. ");
INSERT INTO njd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na nkoto kwaakema mundu bhoa bhala, ‘Atati’ pamba pachilambo, kwa kubhee Atati bhinu nga jumo jika, bhabhabhile kunani. ");
INSERT INTO njd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na wala nkoto kemwanga, ‘Mwachilongola,’ kwakubhee achilongola bhinu nga jumo jika, nga Akilisito. ");
INSERT INTO njd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nabhena bhabhabhile akolongwa pakati jinunji nga bhapalikwa bhabhee oti abhanda bhinu. ");
INSERT INTO njd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwa mundu joajola jwaapkuchikwea apakwaatulua, na jwaachitulua apakwaakwea.” ");
INSERT INTO njd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mpakulaganga Bhannyigana bha Malagilo ga Amusa na Mafalisayo, munchitendanga kubhee bhammbone! Ntendakwaahibhilanga bhandu bhakotokugubhona nniyango gwa Umwenye gwa kunani kwa Annoongo kongo mwakaachinabhene ngajingila nkati na kwaakanikia bhabhapala kujiingila bhakotokujingilanga monomwe. ");
INSERT INTO njd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mpakulaganga mwangota Bhanyigana Malagilo ga Amusa na Mafalisayo, akaandendemundu! Ntenda kwatolelanga akaawelwa hilebhe yabhenji, kwa kuchitenda bhammbone ntenda kujopanga kwa kutandamala. Ligongo lyenelyo mpakupatanga ukumu jijibhii ngolongwa.” ");
INSERT INTO njd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mpakulaganga mwangota Bhannyigana Malagilo ga Amusa na Mafalisayo, mwangota nga akaandendemundu! Ntenda kujaulanga mu bahali na chilambo chijomo ili kwaapata mundu jumo ahobhalele handa chintendakuhobhalela. Pampakwaapata, muntendanga bhapalikwe mala jibhele kujaula ku mooto gwangahimika machobha goa kupunda mwachinabhene.” ");
INSERT INTO njd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mpakulaganga akaachilongola bhangalola! Mwangota mulobholanga, ‘Amundu handa bhapakulapila ku Nyuumba ja Annoongo, kulapila konokwe nga chilebhe, nambo bhapakulapila kwa chaabu jijing'anyima ja Nyuumba ja Annoongo, kulapila konokwe kwa jono mundu kupakwanamatila.’ ");
INSERT INTO njd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwangota bhangalola akaajinga! Chiniki chichibhi chammbone muno, chahabu au Nyuumba ja Annoongo lichitenda jene chahabu kondekwa nnongi ja Annoongo? ");
INSERT INTO njd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kabhele nnyigananga, ‘Kila mundu abhapakulapila mu litatali lya kubhokea mbeeko kwa Annoongo, ngabha chilebhe, nambo handa bhapakulapila kwa chadaka jijibhi nnani ja litatali lya kubhokea mbeeko kwa Annoongo, kulapila konokwe kupakwanamatila.’ ");
INSERT INTO njd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwangota mwangalola! Nga chiniki chichibhi chammbone muno, jenijela chawadi, au mu litatali lya kubhokea mbeeko kwa Annoongo yakubhee bhatendanga jene ngwahupa jikondekwe nnoongi ja Annoongo? ");
INSERT INTO njd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bhabhalapila kwa litatali lya kubhokea mbeeko bhaalapile mu lyene litatali lya kubhokea mbeeko, na kwa choa chela chichibhekitwe nnani jabhe. ");
INSERT INTO njd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na bhabhalapila mu litatali lya kubhokea mbeeko kwa Annoongo bhatekulapila kwa lyenelyo litatali lya kubhokea mbeeko kwa Annoongo na kabhele na kwa bhenibhala bhabhatamite bhabhatamanga nkati jabhenji. ");
INSERT INTO njd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na bhena bhabhalapila kunani kwa Annoongo, bhalapila kwa chitengu cha Umwenye gwa Annoongo, na kwa jonojwe jwatama pachitengu chenecho.” ");
INSERT INTO njd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mpakulaganga, mwenga Bannyigana Malagilo ga Amusa na Mafalisayo! akaandendemundu! Ntochanga bhandu lilubhalo lya komi, hata nnani ja mahamba gakunungila, matoongola na jila, na kongo ntendakulekanga hikubho yammbone ya Malagilo ga Amusa handa henela gagakondekwa kwa Annoongo, kia na kuhengwai. Genago nga gagapaalikwa kugakamula pangali kulibhalila genigala gangi. ");
INSERT INTO njd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwangota akaachilongola bhangalola! Ntendakubhoanga mabhembe mu chilebhe ching'wenganga, nambo ntendakumilanga ngamia.” ");
INSERT INTO njd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mpakulaganga mwangota Bhannyigana Malagilo ga Amusa na Mafalisayo, mwangota akaandendemundu! Mujelejea panja ja chikombe na bakuuli, nambo nkati mtwelilinge hilebhe muhipatite kwa kwaapokanga bhandu handa chintekupalanga mwakachinabhene. ");
INSERT INTO njd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwe Mfalisayo mwangalola! Nchijelejee oti chikombe nkati na panja chipakubhee chwapi hiyoyo!” ");
INSERT INTO njd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mpakulaganga mwangota Bhannyigana Malagilo ga Amusa na Mafalisayo, mwangota akaandendemundu! Mmilinge handa makabuli gagapakilwe uwakala yakubhee panja gabhonekana gatekuhalala, nambo nkati gatwelile mahupa ga bhabhawilinge na kila namuna ja uwakwa. ");
INSERT INTO njd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hiyoyo mwangota kwa panja mmonekana na kila mundu kubhee mwammbone, nambo nkati mtwelilinge undendemundu na ubohu.” ");
INSERT INTO njd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mpakulaganga Bhannyigana Malagilo ga Musa na Mafalisayo, mwangota akaandendemundu! Mchengelanga makabuli ga Akaalondoi na kugatenda makabuli ga bhandu bhammbone gabhonekane maha. ");
INSERT INTO njd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwalobholanga, handa twenga tukabhee muda gwa akanahota bhitu pabhakibha bhamomi, tukakondikinehopo na bhenaangota mu kwaakomanga Akaalondoi. ");
INSERT INTO njd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Henela mwachinabhene ntendakondanga kubhee mwangota nga bhana bha bhandu bhabhakaakomanga Akaalondoi. ");
INSERT INTO njd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Henela, nkajomolekeange lyeni lyela lihengo lya akanahota bhinu bhabhakalijemekanga! ");
INSERT INTO njd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwangota mwakaabhelei bha lijoka, nkombolanga bholi kujibhutuka hukumu ja kujaula kumooto gwangahimika machobha goa? ");
INSERT INTO njd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nenga nannetelanga mwangota akaalondoi na bhandu akaakola malango na bhabhajigana, na bhangi bhabhenji mwangota mpakwaakomanga na kwaabhamba panchalaba, na bhangi bhabhenji mpakwaapotanga mihimbati mu Nyuumba yinunji ya konganilana Bhayahudi na kwaakagulanga kubhoka ku chilambo chimo mpaka chengi. ");
INSERT INTO njd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kulaga kupakuhika kwinu ligongo lya akanahota bhinu bhakaakomanga bhandu bhammbone. Kubhoka pabhakakomekwa Aabeli jwakibha jwanga kulemwa, mpaka kukomekwa kwa Azakalia mwana jwa Abalakia, jonijola munkaakomanga pa litatali lilichengitwe kwa maganga pakubhokea mbeeko mu litatali lya kubhokea mbeeko kwa Annoongo pakati ja mahali papabhi chwaapi. ");
INSERT INTO njd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ndendakunnobholelanga kweli, chibhelei chenjeni chipakuhukumulikwa ligongo lya genago goa!” ");
INSERT INTO njd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mwangota bhandu bha ku Yelusalemu! Bhandu bha ku Yelusalemu! Mwakomanga Akaaolondoi na kwaapotanga maganga bhenibhala bhabhakatumwanga kwaachinunji! Nga mala jilengwa nyigite kwakondanika bhana bhinu kwaachangu? Handa henela kongo bhabhatendanga kwa yaana yabhe pahi ja mapapatilo gakwe, nambo mwangapala! ");
INSERT INTO njd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nnole nyuumba jinunji jitekulekwa panga chilebhe na ukebha. ");
INSERT INTO njd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ndendakunnobholelanga kweli, ngamona kabhele mpaka pampakulobhola, ‘Bhatekutendelwa gammbone bhenabho bhabhapakuhika kwa lihina lya Hangwana.’” ");
INSERT INTO njd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ayesu akabhoka pa Nyuumba ja Annoongo, na pabhakibha atenda kujaula, bhabhachijigana bhabhe bhakaajendelela, bhakajemekanga kulongela nabho ngani ja Majuumba gangi gagakibha penapo. ");
INSERT INTO njd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ayesu akaalobholelanga, “Kombolanga kugalola majuumba ganga goa! Ndendakunnobholelanga kweli, lyakwa hata liganga limo lilipakuigalila pamba panani ja lyengi, kila chilebhe chipakubomolekwa.” ");
INSERT INTO njd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ayesu pabhakibha atamite palitombi lya Mizeituni, bhabhachijigana bhakaajendelela pantemela, akaakonyanga, “Ntulobholele hikubho heye hipakubhokela lichobha niki?” “Na hilolelo niki hipakulangia kuhika kwinu na kupela kwa chilambo?” ");
INSERT INTO njd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ayesu akabhajangulanga, “Mmangange miho nkoto kutembwanga na amundu. ");
INSERT INTO njd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwa kubhee bhajingi bhapakuhika kwa kupetela lihina lyangu, bhabhikulobholanga kila mundu, ‘Nenga nga Akilisito!’ na bhenaangota bhapakwaatembanga bhandu bhajingi. ");
INSERT INTO njd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mpakujohanga ngani ja ngondo na nong'ominong'omi ya ngondo, nambo nkotokuhechukanga, kwa kubhee genago gapalikwa kubhokela, nambo kupela hoko kubhii tangu. ");
INSERT INTO njd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bhandu bha chilambo chimo chipakupotana na bhandu bha chilambo chengi, ungwana gumo gupakupotana na ungwana gongi. Pambani na penipala papakubhee na njala na milindimilo ja chilambo. ");
INSERT INTO njd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Genago goha nga handa kujemeka kwa uchuungu gwa kuchijogola mwana.” ");
INSERT INTO njd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ngapena bhapakunkamulanga mwangota na kunpotanga na kunkomanga. Bhandu bha hilambo yoa hipakunchimwanga ligongo lya lihina lyangu. ");
INSERT INTO njd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Muda gonogwe, bhandu bhajingi bhapakulekanga kunhobhalela, na bhenaangota bhapakugalukananga na kuchimwana. ");
INSERT INTO njd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na bhapakupitilanga akaalondoi bhajingi bha unami na bhapakwatembanga bhajingi. ");
INSERT INTO njd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ligongo lya kujonjokeka kwa ubohu nnyingi, kupalana kwa bhandu bhajingi kupa kupongoka. ");
INSERT INTO njd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambo jwapakupumilia mpaka kupela jonojwe nga apakombolewa. ");
INSERT INTO njd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabhele Ngani ja Jammbone ya Umwenye gwa Annoongo jipakutangachika pachilambo choa, ili bhandu bhoa bha chilambo bhajoange, penapo nga konikola kupela pagupakuhika.” ");
INSERT INTO njd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pampakubhonanga, ‘Chilebhe chichileta ubohu’ chichilobholikwe na alondohi Adanieli. Chijemite pa Nyuumba ja Annoongo.” Jwaachoma na bhaimanye maana gakwe! ");
INSERT INTO njd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ngapena bhandu bhoa bhabhabhile ku chilambo cha ku Yudea na bhabhutukilange muhitombi. ");
INSERT INTO njd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na jwaabhile nnani ya chipagala cha nyuumba jabhe bhakoto kutuluka na kutola chilebhe mu nyuumba jabhe. ");
INSERT INTO njd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na jwabhii kumigonda bhakoto kubhuja kuyeto kutola ngobho jabhe. ");
INSERT INTO njd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gapakubhee machobha ga kulaga muno kwa akaahikege bhabhabhi na hitumbo na akahikege bhabhabhii na hilemba hiijonga machobha genago! ");
INSERT INTO njd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mwajopange Annoongo kutila kwinu kukoto kubhee machobha ga malili au Lichobha lya Kupomolela! ");
INSERT INTO njd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwakubhee machobha genago bhandu bhapakulaganga muno yakubhee kwangapitilanga tangu kujemeka kwa chilambo mpaka leleni, wala ngapitila hopo kabhele. ");
INSERT INTO njd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Handa machobha genago ngapongookwa na Annoongo, jwakwa amundu joajola jwaapakuokoka, nambo Annoongo apakugapongoa machobha hago ligongo lya bhenibhala bhabhaagulikwe.” ");
INSERT INTO njd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Handa amundu apakunnobholelanga, ‘Nnolange Akilisito bhabhi pambani, andaje bhabhi konikola,’ nkotokwahobhalela. ");
INSERT INTO njd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa maana bhapakupitilanga akaalondohi bha unami, na bhandu yakubhee bhapakulongelanga unami na kulongela bhenaangota angota Akilisito. Bhapakutendanga yakangachika na hilolelo hikolongwa, ili kwatembenga bhandu, hata kwa bhandu bhabhaagulikwe na Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nnyoanikiange, ndekunnobholelanga tangu gangabhokela.” ");
INSERT INTO njd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Handa bhandu bhakannobholelanga, ‘Nnolelange, bhabhi kulikonja,’ nkotokujaulanga konokwe, au, ‘Nnolange, bhatekuchiiya nkati,’ nkotokwahobhalela. ");
INSERT INTO njd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwa maana handa njai pajimwetuka kubhoka kuulabho hata kuuwelo, nga chiipakubhee kuhika kwa Amwana bha Amundu.” ");
INSERT INTO njd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kwakubhee poapala pachiwile chinyama nga pabhakondanikanga matumbui.” ");
INSERT INTO njd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pagapakujomoka machobha hago ga kulaga, lihobha lipakulekelwa lubhendu, mwehi ngabhoa nhana, na ndondwa hipakugwee kubhoka kunani, na kulihunde kupakupukunyika. ");
INSERT INTO njd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kubhoka penapo, hilolelo ya Amwana bha Amundu hipakubhonekana kunani, na penapo hilongelo yoa ya pachilambo hipakuguta, na bhenaangota bhapakwaabhona Amwana bha Amundu abhi kuhika panani ja mahunde ga kunani pamo na machili na ng'anyimo nkolongwa. ");
INSERT INTO njd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na bhena apakwaatuma akaatumichi bha kunani kwa Annoongo bhabhabhile na lipenga lilijemba muno, na bhenaangota bhapakwaakondanika bhabhagulikwe kubhoka kila upande gwa chilambo, kubhoka kujomoka kongo kwa mahunde mpaka kujomoka kongoni.” ");
INSERT INTO njd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Muchijigane kulandanikia na nkongo gwa nkojo. Nyaambi yabhe paijemeka kuhipuka mahamba, mmanyanga kubhee machobha ga hula gabhandikile. ");
INSERT INTO njd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na mwangota hiyoyo pampakubhona hikubho heye yoa gabhi kutendeka, mmanyange kubhee muda gwa kupitila genago goha gutekubhandikila muno. ");
INSERT INTO njd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndendakunnobholelanga kweli, chibhelei chenjeni ngapena, tangu ja hikubho yeneyo yoa kupitila. ");
INSERT INTO njd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kulihunde na chilambo hipakupeta, nambo malobhe gangu ngapeta.” ");
INSERT INTO njd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambo, nnani ja lichobha au muda jwakwa mundu jwahimanya hipakubhee lii, ngabha akaatumichi bha kunani kulihunde, wala ngabha mwana, ila Atati jikajabhe nga jwaimanyite. ");
INSERT INTO njd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Handa chiikabhee machobha ga Anuhu, nga chiipakubhee kuhika kwabhe Amwana bha Amundu. ");
INSERT INTO njd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwa kubhee machobha gala tangu kwa kupitila hula ngolongwa, bhandu bhabhakibha bhatenda kulyee, na kung'wee, bhakilombelanga, na kulombwa, mpaka lichobha lyela Anuhu pabhakajingila nkati ja gonigola ntumbwi nkolongwa gukemitwa chapina, ");
INSERT INTO njd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","bhandu bhangahimanyanga chichipakupitila hula jikakoma kwa muda ntandamao na bhandu bhakajomokanga ligongo lya machi majingi, hela hela nga chibhapakuhika kwa Mwana jwa Mundu. ");
INSERT INTO njd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Muda gonogwe bhandu bhabhele bhapakubhee kung'onda, jumo bhapakutolekwa na jongi bhapakulekwa. ");
INSERT INTO njd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akaahikege bhabhele bhapakukubhee bhayaganga mapemba paliganga, bhamo bhapakutolekwa, na bhamo bhapakulekwa. ");
INSERT INTO njd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bahi, mmangange miho, kwa kubhee ngalimanyanga lichobha niki libhapakuhika Hangwana bhinu. ");
INSERT INTO njd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nambo nkombokelange chikubho chenjeni, handa akola nyuumba handa bhakalimanyite lichobha abwii chibhapakuhika, akacheite, wala ngaleka nyuumba jabhe jibomolekwe. ");
INSERT INTO njd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa henela, mwangota kabhele mmangange tayali, kwa kubhee Amwana bha Amundu bhapakuhika muda gwangamanyika.” ");
INSERT INTO njd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ayesu bhakajendelea kulobhola, “Nga aganiki bahi antumichi jwammbone na bhabhii na malango, yakubhee hangwana bhabhe bhapakwabheka nnani ja bhandu bhabhe, bhaapekee chakulya kwa muda gwabhe? ");
INSERT INTO njd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ntumichi jonojwe apakuhangalala muno muda hangwana pabhapakubhuja abhikutenda henela. ");
INSERT INTO njd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndendakunnobholelanga kweli, bhapakwabheka abhanda bhenabho bhailolekee hilebhe yabhe yoa. ");
INSERT INTO njd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambo handa antumichi apakubhee jwangammbone apakuchilobholela mu ntima gwabhe, ‘Hangwana bhangu atenda kabha kubhuja,’ ");
INSERT INTO njd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ngapena akajemeka kwaapotanga akaabhanda ajabhe, akajemeka kulyee na kung'wee pamo na bhandu bhabhakolelwa, ");
INSERT INTO njd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","akolo bhabhe apakuhika lichobha lyangamanyika ma muda gwangamanyika. ");
INSERT INTO njd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Apakwapota muno na kwabheka chibhoga chimo na bhandu bhanganyonikia. Konokwe apakuguta na kuyaga mino.” ");
INSERT INTO njd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Gono muda, Umwenye gwa kunani kwa Annoongo gutenda kulandana henela. Akaamwali komi bhabhatolitinge hibatali yabhenji na kujaula kwaapokela hangwana jwalombela. ");
INSERT INTO njd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nhano pakati ja bhenabho komi bhakibhanga akaajinga na nhano bhakibhanga na malango. ");
INSERT INTO njd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhenibhala akaajinga bhakapetulanga hibatali yabhenji, nambo bhangapetulanga mahuta gangi gakujonjokea, ");
INSERT INTO njd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","nambo bhenibhala bhabhabhii na malango bhakapetulanga mahuta mu yupa pamo na hibatali yabhenji. ");
INSERT INTO njd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hangwana jwalombela pabhakakabha kuhika bhenibhala akamwali bhoa bhakagochelanga na kugoloka lugono.” ");
INSERT INTO njd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pakati ja kilo mundu jumo akapota nyenye, ‘Hangwana jwalombela bhatenda kuhika! Nnyaulange mkaapokele!’ ");
INSERT INTO njd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Penapo akamwali bhoa bhakajimukanga, bhakahalakia hibatali yabhenji ili hijake maha. ");
INSERT INTO njd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bhenibhala akaajinga bhakaalobholelanga bhenibhala bha luunda, ‘Ntupekeange mahuta ginu nkachoko hibatali yitu hitenda kuhimika.’ ");
INSERT INTO njd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambo bhenibhala bhabhabhii na malango bhakaajangulanga, ‘Ngatutochanga twenga na mwangota, mbaya nnyendange kuliduka nkahemelange ginunji!’ ");
INSERT INTO njd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Penapo bhenibhala akamwali akaajinga pabhakajaulanga kuhemela mahuta. Kongo kuyeto hangwana jwalombela bhakahika, na bhenibhala akaamwali bhabhakibha tayali bhakajingilanga pamo na bhena mu nyuumba jijitendeka ulombela, na nniango gukajigalwa.” ");
INSERT INTO njd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pagukapeta muda kachoko bhenibhala akamwali bhajinga bhakahikanga, bhakakema, ‘Akolo, akolo, ntujogolele!’” ");
INSERT INTO njd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nambo jonojwe akaajangulanga, “Ndendakunnobholelanga kweli, ‘Nimmanyangahopo mwangota.’” ");
INSERT INTO njd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ngapena Ayesu akajomolekea kulongela, “Mmangange miho, kwa kubhee ngalimanya lichobha wala muda gupakubhee lii.” ");
INSERT INTO njd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kabhele Umwenye gwa Annoongo gupakubhee henela. Mundu jumo jwaapala kujaula ulendo, bhakaakema akaabhanda bhabhe na kwaabheka bhailolekee hilebhe yabhe. ");
INSERT INTO njd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Bhakaapekea kila mundu kubhokana na uwecho gwabhe, jumo hiyuko nhano ja mbiya, jongi hiyuoko hibhele na jongi chihuko chimo cha mbiya, penapo bhakajaula ulendo. ");
INSERT INTO njd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mmanda jwaakapata hiyuko nhano bhakajaula na kuhitendela lihengo, akajonjokea hiyuoko yengi ja mbiya nhano. ");
INSERT INTO njd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hela hela na bhenibhala jwaakapata mihuko hibhele ya mbiya bhakajonjokea yengi hibhele. ");
INSERT INTO njd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambo bhenibhala bhabhakapata chihuko chimo bhakajenda, bhakahemba lihembo pahi, bhakajihelela mbiha ja hangwana bhabhe.” ");
INSERT INTO njd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagakapeta machobha gajingi, bhakahika hangwana na akaabhanda bhabhe kukonya bhatendite niki mu mbiha jabhe. ");
INSERT INTO njd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jonijola antumichi jwaakaapata chihuko cha mbiya nhano akahika na nnyonjokeo gwa talanta yengi nhano, akaalobholela, ‘Hangwana, nkambekea chihuko cha mbiyaa nhano,’ ‘Nnole mbatite kujonjokea hihuko yengi ya mbiya nhano.’ ");
INSERT INTO njd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hangwana bhabhe bhakaalobholela, ‘Yammbone, mwenga antumichi jwammbone na jwakuaminika.’ ‘Mmi jwa kuaminika hata kwa hilebhe hichoko hichoko, mbakumkamua makolongwa. Nhike nhangalale pamo na hangwana bhinu!’ ");
INSERT INTO njd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ngapena jonijola antumichi jwakapata hihuko hibhele ya mbiya hibhele nabhena akahika, akabhoa hihuko yengi hibhele hiijonjokike. Akalobhola, ‘Hangwana nkambekea hihuko hibhele ya mbiya. Ntole hihuko yinu yengi hibhele niipatite kwa kujonjokea.’ ");
INSERT INTO njd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hangwana bhabhe akajangula, ‘Yammbone, abhanda jwammbone na jwakuaminika!’ ‘Mmile jwakuaminika mu hikubho hichokochoko, mbakunpekea hikubho hikolongwa. Nhike nhangalale pamo na hangwana bhinu!’ ");
INSERT INTO njd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nambo jonijola jwakapata chihuko chimo akahika, akalobhola, ‘Hangwana, niimanyi mwenga nga mundu jwakulimba, mwenga ntenda kuhuna penipala pangapanda mbeju, na ntenda kukumba penipala pangamicha mbeju. ");
INSERT INTO njd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngajogopa, nakahiiya mbiha jinu pamandopi. Mpetule jenjeni mihuko jinu ja mbiha.’” ");
INSERT INTO njd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hangwana bhabhe bhakaalobholela, ‘Mwenga nga mmanda abohu na mkata! Muhimanyi kubhee nenga ndenda kuhuna penipala panangapanda mbeju, na kukumba panga kumicha mbeju. ");
INSERT INTO njd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mkapalikwa kuibheka mbiha jangu kwa bhandu bhabhauchanga na kuhemela bunyu, nanenga chimbakuhika ngajipetula jenijele mihuko jangu na jijijonjokike. ");
INSERT INTO njd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bahi, munpokange jene mbiha mumpee bhenibhala bhabhabhii na hihuko komi. ");
INSERT INTO njd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwa maana mundu joajaola jwaatendela lihengo chilebhe chindekwaapekea mbaakwajonjokea na chengi, na jono apakubhee na hijingi. Nambo mundu joajola jwaatendelahopo lihengo chilebhe chichooko chindekwaapekea, hata chenechela chichoko chibhabhii nacho, na chene chichooko mbaakwapokonyola. ");
INSERT INTO njd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mmanda ojojo jwangajonjokea mbiha, munlekelange panja palubhendu! Konokwe bhapakuguta na kuyaga mino ligongo lya hibhini muno.’” ");
INSERT INTO njd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Penapo Amwana bha Amundu pabhapakuhika mu ukolo gwabhe, pamo na akaatumichi bha kunani kwa Annoongo bhoa, penapo bhapakutama nnani ja chitengu chabhe cha ukolo bhene akibha Amwenye. ");
INSERT INTO njd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bhandu bha hilambo yoa bhapakongananga nnongi jabhe, nabhena bhapakwaabheka bhandu kwa malubhalo handa anchungaji chibhaabheka malubhalo ngondolo na mbuhi. ");
INSERT INTO njd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bhapakwaabheka ngondolo lubhoko lwabhe lwa kunnelo na mbuhi lubhoko lwabhe lwa kunchiji.” ");
INSERT INTO njd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ngapena Amwenye bhakaalobholela bhenibhala bhabhabhii lubhoko lwabhe lwa kunnelo, “Nhikange mwangota mubhekitwe ligongo lya Annoongo, Atati bhangu, npokelange umwenye gugutekupanganikwa tangu kuhalakiwa kwa chilambo. ");
INSERT INTO njd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa kubhee nakibha na njala na mwangota mkambekea chakulya, nakibha na nyoota na mwangota mkambekea machi, nakibha ageni na mwangota mkambokela, ");
INSERT INTO njd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nakibha nanga ngobho, na mwangota mkambekeanga ngobho, nakibha ndenda kulwala mkahikanga kunola, nakibha kuchitabho na mwangota mwakahikanga kutyangila.” ");
INSERT INTO njd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Penapo, bhandu bhabhakamwile bhagapala Annoongo bhapakwajangula, bhabhi kulobhola, “Hangwana, lii tukammona mmi na njala na twenga tukampee chakulya, na mmi na nyota na twenga tukampee machi? ");
INSERT INTO njd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lii tukammona mmi ageni na twenga tukampokela, na mwangawala bhongo, na twenga tukampee ngobho ya kuwala? ");
INSERT INTO njd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lii tukammona mmi mtamwa au ntekutabhwa na twenga tukahikanga kunnola? ");
INSERT INTO njd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Amwenye bhapakwaajangula, ‘Ndendakunnobholelanga kweli, kila chilebhe chintendilinge jumo jwa habha akaalongo bhangu bhangamanyikana, mkandendelanga nenga!’” ");
INSERT INTO njd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ngapena bhapakwaalobholelanga bhenibhala bhabhabhile lubhoko lwabhe lwa kunnchiji, ‘Mmokange nnongi jangu mwangota muntekulaaniwa na Annoongo! Nnyendange kumooto gwangahimika machobha goa gugubhekitwe ligongo lya lichetani bhatumichi bhabhe! ");
INSERT INTO njd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwa kubhee nakibha na njala mwangambee chakulya, nakibha na nyota mwangambee machi ga kung'wee. ");
INSERT INTO njd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nakibha ageni na mwangota mwangambokela, nakibha nangawala ngobho nambo mwangota mwangambee ngobho ya kuwala, nakibha atamwa na kutabhwa muchitabho nambo mwangota mwangahika kunnola.’ ");
INSERT INTO njd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Penapo bhenaangota bhapakujangulanga, ‘Hangwana nga lii tukammona mmi na njala au nyoota, mmi ageni au mwangawala ngobho, mmi atamwa na twenga twangannyangatila?’ ");
INSERT INTO njd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na bhena bhapakwaajangulanga, ‘Nannobholelanga kweli, kila pamkakananga kwaatendela hikubho heye jumo jwa habha bhangamanyikana, nkakananga kundendela nenga.’” ");
INSERT INTO njd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Bahi, habha bhapakupatanga kuhukumu jangapela. Nambo bhenibhala bhabhagakamula bhagapala Annoongo bhenabho bhapakujingila mu umomi gwa machobha goa pangakupela.” ");
INSERT INTO njd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ayesu pabhakajomola kulobhola genago goa, akaalobholelanga bhabhachijigana bhabhe, ");
INSERT INTO njd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mmanyanga kubhee pagapakupeta machobha gabhele kupakubhee na lichobha likolongwa lya Pasaka, na Amwana bha Amundu bhapakugalukwa ili bhabhambwe panchalaba.” ");
INSERT INTO njd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gono muda Akaakung'i akolo na akanachilongola bha Bhayahudi bhakakongana pamo paluwani lwa nyuumba ja Akayafa jwaakibha Akung'i Amwenye. ");
INSERT INTO njd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhakakongolelana ndela ja kunkamula Ayesu kwa kuhiiya ili bhaakome. ");
INSERT INTO njd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nambo bhakalobholanga, “Chikubho chenecho chikotokubhee mu lichobha likolongwa lya Pasaka, ili gukotokupetela ukomo nkati ja bhandu.” ");
INSERT INTO njd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ayesu pabhakibha ku Betania, kaja kwa Asimoni, jwakibha na matana, ");
INSERT INTO njd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mwikege jumo jwakibha na chupa chichitwelile mahuta ga kunungila ga bei ngolongwa, bhakahika penipala Ayesu pabhatenda kulyee chakulya, bhakaakuchulila gena mahuta mmutwe. ");
INSERT INTO njd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bhabhachijigana bhabhe pabhakabhona genago bhakachimwanga, bhakalobholanga, “Janiki achala jenjeni? ");
INSERT INTO njd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kwa kubhee mahuta gangani nga ga bei ngolongwa, hikakombolike kuhuchwa na yene mbiha bhakaapekiinge akaahocho.” ");
INSERT INTO njd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ayesu bhakagamanya chibhaganikia, bhakaalobholela, “Mboni ntendakunhabhuanga mwikege hojo? Jonojwe atekutenda chikubho chammbone. ");
INSERT INTO njd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Akaahocho mmi nabho machobha goa, nambo nenga mbakubheehopo pamo na mwangota machobha goa. ");
INSERT INTO njd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hojo mwikege bhatekunguchulila mahuta gakunungila ili kumeka tayali kwa kunjika. ");
INSERT INTO njd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nannobholelanga kweli, poa pala pachilambo pabhapakutangachiwanga jenje Ngani Jammbone, chikubho chaachitendite hojo mwikege chipakulongoleka kwa kwaakombokela bhenabho.” ");
INSERT INTO njd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ngapena jumo jwa bhenibhala bhabhachijigana komi na bhabhele, bhakemitwa Ayuda Isikaliote, bhakajaula kwa Akung'i Akolo, ");
INSERT INTO njd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bhakaakonyanga, “Mpakumbee chilebhe niki handa mbakwaagaluka Ayesu kwaachinu?” Bhakaalangia hipande makomi gatatu ga maganga gagakemitwa mbiha. ");
INSERT INTO njd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kubhoka penapo Ayuda bhakibha bhalolea ndela ja kwaagaluka Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lichobha lya kujemeka tangu ja lichobha likolongwa lya mikate jangalekelwa chilongo, bhabhachijigana bhakaajendela Ayesu bhakaakonya, “Mpala tumpanganikie koji chakulya cha lichobha likolongwa lya Pasaka?” ");
INSERT INTO njd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ayesu akaajangulanga, “Nnyaulange kunnyini kwa analome teno, mkaalobholele, ‘Bhannyigana bhalobhola, muda gwangu guikite, kwaachinu mbakulyee chakulya cha Pasaka pamo na bhabhachijigana bhangu.’” ");
INSERT INTO njd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bhabhachijigana bhakatendanga handa Ayesu chibhakaalagia, bhakaapanganikia chakulya cha Pasaka. ");
INSERT INTO njd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pajikahika kimuho Ayesu na bhabhachijigana bhabhe komi na bhabhele bhakatama kulyee chakulya. ");
INSERT INTO njd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pabhatendita kulyee, Ayesu bhakalobhola, “Ndendakunnobholelanga kweli, jumo gwinu bhapakung'aluka.” ");
INSERT INTO njd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhabhachijigana ikaabhinanga muno mu mitima jabhenji, kila jumo akajemeka kwaakonya, “Hangwana! Bholi, nga nenga?” ");
INSERT INTO njd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ayesu akajangula, “Jwapakutobhela mkate pamo na nenga mu libakuli nga jwapakung'aluka. ");
INSERT INTO njd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amwana bha Amundu apakujomoka handa chigalobhola Majandiko ga Annoongo, nambo apakulaga mundu jola jwapakwaagaluka Amwana bha Amundu! Jikibha mbaya kwa mundu jonojwe handa akibha angabhelekwa.” ");
INSERT INTO njd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ayuda, jonijola jwaagaluka, akaakonya, “Bhannyigana, bholi, nga nenga?” Ayesu bhakajangula, “Handa chinnongile,” ");
INSERT INTO njd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pabhatendita kulyee, Ayesu akatola nkate, akaachukulu Annoongo, akagumetula, akaapekea bhabhachijigana bhabhe abhikulobholo, “Ntolange nlyangange, gongo nga mmele gwangu.” ");
INSERT INTO njd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ngapena bhakatola chikombe cha divai, bhakachukulu Annoongo, bhakaapekea bhabhachijigana babhe bhabhikulobhola, “Nng'wangange mwabhoa mu chikombe chenjeni. ");
INSERT INTO njd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwa maana jenje nga mihai jangu jijilangia lilagano, jijijitika ligongo lya bhandu bhajingi ili kwaabhokea mabohu. ");
INSERT INTO njd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nambo ndendakunnobholela, ngang'wee kabhele divai mpaka lichobha lyela chimbakung'wee divai jiyono pamo na mwangota mu Umwenye gwa Atati bhangu.” ");
INSERT INTO njd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na bhenaangota pabhakajomola kujemba, bhakajenda ku Litombi lya Mizeituni. ");
INSERT INTO njd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Penapo Ayesu bhakaalobholela, “Kilo cha leleni, mwangota mwabhoa mpakubhutuka na kuneka nenga, kwa kubhee jijaandikwe mu Majandiko ga Annoongo, ‘Mbakwapota anchugaji, na lilubhalo lya ngondolo lipakupwilingana.’ ");
INSERT INTO njd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambo chimbakuyoka, mbakunlongolelanga chilambo cha ku Galilaya.” ");
INSERT INTO njd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Apetulo akaajangula Ayesu, “Hata handa bhoa bhapakubhee na lipamba na mwenga na kunneka, nenga nganneka ng'o.” ");
INSERT INTO njd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ayesu bhakaalobholela Apetulo, “Kweli ndendakunnobholela, kilo chenjeni tangu likambaliko lyangajemba, mpakungana patatu.” ");
INSERT INTO njd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nambo Apetulo akajangula, “Hata handa hipalikwa kujomoka pamo na mwenga, ngankana ng'o.” Na bhenibhala bhabhachijigana bhangi bhoa bhakalobholanga hela hela. ");
INSERT INTO njd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngapena Ayesu akajenda pamo na bhabhachijigana bhabhe mahali pakemitwa ku Getisemane, na jono akaalobholelanga, “Ntamange pambani na nenga nyaule penipala kwaajopa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bhakaatola Apetulo pamo na bhenibhala bhana bhabhele bha Azebedayo, na bhena bhakajemeka kuhechuka na kuumalika. ");
INSERT INTO njd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Penapo akaalobholelanga, “Ndenda kuhechuka muno muntima gwangu hata kubhandikila na kiujomoka. Mtamange pambani ntamange miho pamo na nenga.” ");
INSERT INTO njd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bahi, akajaula nnoongi kachoko, akagwee manguku, akajopa, “Atati bhangu, handa ikombolike chikombe heche cha kulaga chimbete, nambo hikoto kubhee handa chimbala nenga, ila chimpala mwenga.” ");
INSERT INTO njd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngapena Ayesu akabhuja kwa bhabhachijigana bhabhe na kwaakolela bhatekugoloka. Akaakonya Apetulo, “Bholi, mwangota mwangacheanga pamo na nenga hata kwa lichaa limo? ");
INSERT INTO njd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ncheange na mwajope Annoongo nkotokujingilanga mmalengelo. Mboomo jitenda kupala nambo mmele gwangamachili.” ");
INSERT INTO njd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akajaula kabhele pabhele kwaajopa Annoongo, “Atati handa ikombolike chikombe heche cha kulagia chimbete ngoto kung'wela, bahi, upaliho gwinu gukweele.” ");
INSERT INTO njd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pabhakabhuja kabhele, akaakolelanga bhagolwikinge, kwa kubhee miho gabhenji gakibha na lugono. ");
INSERT INTO njd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ayesu akaalekanga akajaula kabhele patatu na kujopa abhi kulobhola malobhe galagala. ");
INSERT INTO njd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngapena bhakabhuja kwa bhabhachijigana bhabhe na kwaalobholela, “Bholi, tangu mgolwikinge na kupomolela? Nnolange muuda guhikite gwa Amwana bha Amundu bhapalikwa kulekelwa mmabhoko ga bhandu bhabhabhii na mabohu. ");
INSERT INTO njd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nnyimukange, tujaulange. Atenda kuhika jonijola jwapakung'aluka!” ");
INSERT INTO njd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bahi, Ayesu pabhakibha tangu bhatenda kulongela nabho, popopo akahika Ayuda, jumo jwa bhabhachijigana komi na bhabhele. Pamo na bhenabho bhakahikanga bhandu bhajingi bhabhabhii na mapanga na himbonga bhabhatumwanga na Akaakung'i Akolo na akanahota. ");
INSERT INTO njd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na jonojwe jwakapala kwaagaluka Ayesu, akibha atekwapekea hilolelo abhi kulobhola, “Amundu jonijola junapakunnamatila na kunchalimiaa nga jonojwe munkamulange.” ");
INSERT INTO njd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bahi, Ayuda akajendelela Ayesu na kwalobholela, “Kunchelile bhannyigana!” Ngapena akaanyambatila. ");
INSERT INTO njd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ayesu akaalobholela, “Aganja, ntende chintekuhika kutenda.” Penapo bhenibhala bhandu bhakahikanga, bhakaakamula Ayesu, bhakaalekelela mmachili. ");
INSERT INTO njd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","“Jumo jwa jonijola jwakibha na Ayesu akagunyulula lubhoko lwabhe, akaguolomola upanga gwabhe, akaapota antumichi jwa Akaakung'i Akolo, akaaheketa lichikilo. ");
INSERT INTO njd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngapena Ayesu akaalobholela, mmujie upanga gwinu mu lihako lyakwe, maana joajola jwakoma kwa upanga, apakujomoka kwa upanga. ");
INSERT INTO njd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bholi, nng'anikia ngakombola kwaajopa Atati bhangu anyangatile nabhena akanetela manyemba kupunda komi na bhabhele ga akaatumichi bhabhe bha kunani kulihunde? ");
INSERT INTO njd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nambo bholi, Majandiko ga Annoongo gapakweela bholi gagalobhola, henela nga chiipalikwa kubhee?” ");
INSERT INTO njd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Muda gogogo Ayesu bhakagulobholela nkutuli gwa bhandu bhabhakahika kwaalekela mmachili, “Bholi, ntekuhikanga na mapanga na himbonga kuhika kungamula handa henela bhakupokanga bhandu? Machobha goa nakibha mu Nyuumba ja Annoongo kwaajigananga bhandu, mboni mwangakamulanga? ");
INSERT INTO njd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambo haga gangani goa gatekubhee, ili Majandiko ga akaalondoi bha Annoongo gakweele.” Ngapena bhabhachijigana bhoa bhakapwilinganika. ");
INSERT INTO njd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhandu bhenibhala bhabhakaakamula Ayesu bhakaapeleka ku nyuumba ja Akayafa, Akung'i akolo, pabhakakongananga na bhabhajigana Malagilo ga Amusa na akanahota. ");
INSERT INTO njd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nambo Apetulo bhakaakagula kwa kutali mpaka kulugwani lwa Akaakung'i Amwenye. Bhakajingila nkati bhakatama pamo na akaalendei ili bhapate kulola chiipakubhee. ");
INSERT INTO njd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bahi, Akaakung'i akolo na chebule joa bhakalolea malobhe ga unami nnani ja Ayesu ili bhapatange kwaakoma, ");
INSERT INTO njd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nambo bhangapatanga malobhe goagala ga kwakamulila Ayesu, hata handa bhandu bhajingi bhakahikanga bhabhakalobhola malobhe gajingi ga unami. Pakujomolekea kuhika bhakahikanga bhandu bhabhele, ");
INSERT INTO njd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na akalobhola, “Habha amundu bhakalobhola, ‘Ngombola kujibomola Nyuumba ja Annoongona na kujichenga kabhele kwa machobha gatatu.’” ");
INSERT INTO njd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Akung'i akolo akajema, akaakonya Ayesu, “Bholi, ngajangula lilobhe? Nga malobhe ga namuna niki habha bhandu bhagaleta nnani jinu?” ");
INSERT INTO njd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambo Ayesu akatama jii. Akaakung'i akolo akaalobholela, “Ndenda kunnapila kwa Annoongo bhabhii bhamomi, ntulobholele handa mwenga nga Akilisito Amwana bha Annoongo!” ");
INSERT INTO njd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ayesu akaajangula, “Mwenga nnobhwile! Nambo ndendakunnobholelanga, kujemeka nangocheni mpakunnolanga Mwana jwa Amundu atamite upande gwa kunnelo jwa jonijola Hangwana jwabhii na machili, abhikuhika nnani ja mahunde ga kunani kwa Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Penapo Akung'i akolo akapapula ngobho yabhe, akalobhola, “Atendakwatukana Annoongo! Tupalahopo kabhele bhandu bha kongolela, nangocheni ntekunyoanikianga maligo gabhe. ");
INSERT INTO njd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwangota mmonanga bholi?” Bhenaangota bhakaajangulanga, “Jwatekulemwa apalikwa kujomoka.” ");
INSERT INTO njd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngapena bhakaahunila mata kumiho, bhakaapota mmajegwa. Bhangi kongo bhabhikwapota mmajegwa, ");
INSERT INTO njd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na kulobhola, “Ntulondolele, mwee Akilisito, nga aganiki bhabhampotite!” ");
INSERT INTO njd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Apetulo akibha atamite panja palugwani. Bahi, antumichi jumo Ahikege bhakajendelela, bhakalobhola, “Mwenga nkibha pamo na Ayesu bha ku Galilaya.” ");
INSERT INTO njd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nambo Apetulo akakana nnongi ja bhoa bhabhi kulobhola, “Ngachimanya chinlongela.” ");
INSERT INTO njd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Akabhoka penipala akajaula panniango, antumichi bhangi ahikege akaalola, bhakaalobholelanga bhandu bhabhakibha penapo, “Habha amundu bhakibha pamo na Ayesu Nnazaleti.” ");
INSERT INTO njd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Apetulo akakana kabhele kwa kulapila abhi kulobhola, “Ngaamanya abha amundu.” ");
INSERT INTO njd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagukapeta muuda kachoko, bhandu bhenibhala bhabhakibhanga bhajemite penipala bhakaajabhulila Apetulo bhakaalobholela, “Kweli mwenga nga jumo jwabhe, kwa kubhee namuna chinnongela ntenda kulandana na bhenaangota.” ");
INSERT INTO njd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ngapena Apetulo bhakajemeka kuchilaani na kulapila abhi kulobhola, “Ngaamanya bhena amundu!” Popopo likambaliko likajemba. ");
INSERT INTO njd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Apetulo akakombokela malobhe gabhakalobholelwa na Ayesu, “Tangu likambaliko kujemba, mpakungana patatu.” Bahi, akabhoka panja, akaguta kwa hibhini. ");
INSERT INTO njd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kundabhi tuputupu, Amwenye bha akaakug'i bhoa na akachilongola bha Bhayahudi bhakatendanga chikomiti pamo nnani ja Ayesu ili bhapatange kwaakoma. ");
INSERT INTO njd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhakaatabha nyololo, bhakaapetula, bhakaapeleka kwa Apilato, jwakibha akolo jwa ku Loma. ");
INSERT INTO njd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Penapo Ayuda, bhenibhala bhabhakaagaluka Ayesu, pabhakalola kubhee Ayesu bhatekuhukumulwa komekwa, bhakachikokolekela na kubhujia yeniyela hipande makomi gatatu ya mbiha bhabhakapekewa na akaakung'i akolo na akachilongola bha Bhayahudi. ");
INSERT INTO njd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akaalobholelanga, “Ndekulemwa kwa kwaabhoa amundu bhangakulemwa bhakomekwe.” Nambo bhenaangota bhakalobholanga, “Twenga tutende niki? Genago ginu mwachinabhene.” ");
INSERT INTO njd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na jonojwe akahijeha yeniyela mbiha mu Nyuumba ja Annoongo, bhakabhoka panja, bhakajaula kuchijomola kwa kuchitabhila nng'oji muntandala gwabhe. ");
INSERT INTO njd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akaakung'i akolo akatola ulohi gola, bhakalobhola, “Ngapalikwa kubheka heye mbiha mu nhuko gwa Nyuumba ja Annoongo kwa kubhee mbiha hiibhokile kwa koma mundu.” ");
INSERT INTO njd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bahi, bhakatendanga chikomiti, bhakakondanga bhakahemele nng'onda gwa jwaalakiha undopi, ili pabhee mahali pa kwaachikila akaageni. ");
INSERT INTO njd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nga maana mpaka leleni nng'onda gonogwe gukemwa nng'onda gwa mihai. ");
INSERT INTO njd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Penapo likakweela lyenilyela lilobhe lya alondoi Ayelemia kubhee, “Bhakapetulanga hipande makomi gatatu ga mbiha, Bhandu bha ku Isilaeli bhakakondekananga kulepa ligongo lya mundu hojwe, ");
INSERT INTO njd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bhakahemelela nng'onda gwa amundu bhabhabhomba hibhega, handa henela Hangwana bhabhakaalangia.” ");
INSERT INTO njd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Muuda Ayesu pabhakannyemekea nnongi ja chilongola bha ku Lumi, atabhala bhakaakonya, “Mwenga nga Amwenye bha Bhayahudi?” Ayesu bhakajangula, “Mwenga ntekulobhola.” ");
INSERT INTO njd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambo akaakung'i na akachilongola bha Bhayahudi pabhakibha bhatenda kunchitaki, jwangajangula lilobhe. ");
INSERT INTO njd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Henela Apilato bhakaakonya, “Bholi, mwangajoha haga machitaka goa gabhapianga nnani jinu?” ");
INSERT INTO njd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambo Ayesu jwangajangula hata lilobhe limo, hata akolo bha ku Lumi akakangacha muno. ");
INSERT INTO njd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bahi, jikibha jiyobhalilike mu lichobha likolongwa lya Pasaka, achilongola bha ku Lumi kwaagopolela Bhayahudi atabhwa jumo bhandu bhabhaapala. ");
INSERT INTO njd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gono muda pakibha na atabhwa jumo jwaakamanyika muno kwa ubohu gubhakatenda, lihina lyabhe Abalaba. ");
INSERT INTO njd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Henela nkutuli gwa bhandu pabhakakongana Apilato bhakaakonyanga, “Mpala ninnyogolele aganiki, Abalaba au Ayesu bhakemitwa Akilisito?” ");
INSERT INTO njd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Apilato akalobhola henela kwa kubhee akahimanya kubhee bhakaaleta kwaachabhe ligongo lya bwiu. ");
INSERT INTO njd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apilato pabhakibha atamite pachitebhu cha kuhukumula, hanu bhabhe bhakaapelekela ngani, “Nkotokuntenda lyoalyela lyangammbone mundu hojo jwammbone, kwa kubhee leleni ndekulaga muno kuagamila ligongo lyabhe.” ");
INSERT INTO njd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nambo Akaakung'i akolo na akanachilongola bha Bhayahudi bhakaapembelea bhandu bhajingi bhaajope bhajogolekwe Abalaba na Ayesu bhakomekwe. ");
INSERT INTO njd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Apilato bhakapunda kwaakonyanga, “Nga aganiki nkati ja abha bhabhele mpalanga ninnyogolele?” Bhakaajangulanga, “Abalaba!” ");
INSERT INTO njd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nambo Apilato bhakaakonyanga kabhele, “Nangocheni naatendele chiniki Ayesu bhaakemitwa Akilisito?” Bhakajangulanga bhoa, “Abhambikwe panchalaba!” ");
INSERT INTO njd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Apilato akakonya kwa mala jengi, “Kwaniki? Bhatendite ubohu niki?” Bhenaangota bhakapunda kukwela lilobhe, “Mwaabhambe panchalaba!” ");
INSERT INTO njd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bahi, Apilato pabhakahimanya kubhee ngakombola kutenda choa chela, na ukomu gukibha gutenda kujemeka, akatola machi, akakua mabhoko nnoongi ja gonigola nkuli gwa bhandu, abhikulobhola, “Chikubho heche muchipetulange mwakaachinabhene.” ");
INSERT INTO njd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bhandu bhoa bhakalobholanga, “Kulemwa konokwe kwa kwaakoma Ayesu kubhee kwitu na bhana bhitu!” ");
INSERT INTO njd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngapena Apilato bhakaajogolela Abalaba kubhoka kuchitabho, na kwaalagia manyemba bhakwe bhaapote Ayesu mihimbati, ngapena akaabhoa na kubhambikwa panchalaba. ");
INSERT INTO njd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngapena manyemba bha Apilato, bhakaapeleka Ayesu nkati ja luwani lwa nyuumba ja chilongola jwa ku Loma, lilubhalo lyoa lya manyemba bhakakongana kwaatindila bhenabho. ");
INSERT INTO njd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakaahula chiwalo chabhe, bhakaaweka chiwalo chikele. ");
INSERT INTO njd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngapena bhakatotanga hiingwa ya miibha, bhakaaweka mmutwe, bhakaabhekela kabhele nhimbati mu lubhoko lwabhe lwa kunnelo. Bhakatindibhala majugwa nnoongi jabhe, bhakaatendela mbeenje bhabhi kulobholanga, “Kunchelile Amwenye bha Bhayahudi!” ");
INSERT INTO njd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bhakaahunila mata, bhakatola gonigola nhimbati, bhakaapota mmutwe. ");
INSERT INTO njd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pabhakajomolanga kwaatendelanga mbeenje, bhakaahula jenijela ngobho, bhakaaweka kabhele ngobho yabhenji, kubhoka penapo bhakampeleka kwaabhamba panchalaba. ");
INSERT INTO njd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pabhakibhanga nndela bhabhikujaulanga, bhakakongana na mundu jumo lihina lyakwe Asimoni, mundu jwa ku Kilene, na bhenaangota bhakaakulumikia kugupetule nchalaba gwa Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na pabhakahikanga mahali pakemitwa Goligota, maana gakwe, “Lingambwa lya mutwe,” ");
INSERT INTO njd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bhakaapekea Ayesu divai jibhakaangalana na chilebhe chakubhabha ili bhang'wee, nambo Ayesu pabhakapaa akakana kung'wee. ");
INSERT INTO njd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pabhakajomola kwaabhamba ngobho jabhe bhakagabhananga kwa gudugudu, ili likweele lyela lilobhe lilikalobholekwa na alondoi, “Bhakagabhananga ngobho yangu kwa kuhitendelanga gudugudu.” ");
INSERT INTO njd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kubhoka penapo, bhakatamanga, kwaalendelela. ");
INSERT INTO njd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani ja mutwe gwabhe panchalaba pakajandikwa malobhe gangani, “Habha nga Ayesu, Amwenye bha Bhayahudi.” ");
INSERT INTO njd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bhakaabhamba pamichalaba pamo na akaabwii bhabhele, jumo upande gwa kunchiji na jongi upande gwa kunnelo. ");
INSERT INTO njd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhandu bhabhakibha bhatenda kupeta penapo bhakaatukana Ayesu kongo bhabhi kupukunya mitwe jabhenji na kulobhola, ");
INSERT INTO njd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mwenga! Ngati nkachitenda mpakujibomolana Nyuumba ja Annoongo na kuchenga kwa machobha gatatu? Nangocheni nchiokoe mwabhene. Handa mwenga nga Mwana jwa Amundu, bahi, ntuluke panchalaba!” ");
INSERT INTO njd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yelayela, Akolo bha akaakung'i pamo na bhabhachijigana Malagilo ga Amusa na akanachilongola bha Bhayahudi bhakaatendela mbeenje bhabhi kulobhola, ");
INSERT INTO njd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Bhakaaokoa bhangi, nambo ngakombola kuchiokoa mwene! Bhena ngati Amwenye bha bhandu bha ku Isilaeli! Bahi, nangocheni bhatuluke panchalaba, na twenga twahobhalele. ");
INSERT INTO njd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Akaahobhalela Annoongo na kulobhola bhena nga Amwana bha Annoongo, bahi, Annoongo na bhaaokoe handa bhatenda kwaapala.” ");
INSERT INTO njd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Helahela na akabwii bhabhele bhabhakabhambwa pamo na bhena bhakaatukana ");
INSERT INTO njd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jikibha saa sita muhi mpaka saa tisa lubhendu lukawekela chilambo choa. ");
INSERT INTO njd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pajikahika handa saa tisa Ayesu akakwea lilobhe akaguta, “Eloi, Eloi, lama Sabakitani?” Maana gakwe, “Annoongo bhangu, Annoongo bhangu, mboni ntekuneka?” ");
INSERT INTO njd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nambo bhenibhala bhandu bhabhakajemanga penipala pabhakajohanga henela bhakalobhola, “Atendakwakema Aelia.” ");
INSERT INTO njd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Penapo jumo jwabhenji akabhutuka, akatola lidodoki lijomo, akatobhela mu siki, akatabhalila nnani ja nnai, akaapekea ang'wee. ");
INSERT INTO njd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bhenibhala bhangi bhakalobholanga, “Tuleke twaalole handa Aelia apakuhika kwaaokoa.” ");
INSERT INTO njd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bahi, Ayesu akaguta kabhele kwa lilobhe likolongwa, akajomoka. ");
INSERT INTO njd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Penapo lipanjia lya Nyuumba ja Annoongo likapapuka hipande hibhele, kubhoka panani mpaka pahi, chilambo chikalendemela, ");
INSERT INTO njd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","makabuli gakajogoka na bhandu bhajingi bha Annoongo bhabhakajomokanga bhakayokanga, ");
INSERT INTO njd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","na bhenaangota bhakabhokanga mumakabuli, na baada ja Ayesu kuyoka bhakajingilanga, mu hilambo ya chwapi na kubhonekana kwa bhandu bhajingi. ");
INSERT INTO njd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bahi, jonijola linyemba akolo na bhenibhala bhabhakibha pamo na bhena kwaalendelea Ayesu bhakabhona kulendemela na yeniyela hikubho hiikabhokela, bhakajogopanga muno, bhakalobholanga, “Kweli hojo mundu akibha Amwana bha Annoongo.” ");
INSERT INTO njd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Penapo pakibha na akaahikege bhabhalolita kwa kutali. Bhenabho bhakibha bhatekwaakagula Ayesu kubhoka ku Galilaya, na kwaatumikila. ");
INSERT INTO njd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nkati jabhenji bhakibha Amalia bha ku Magidala, Amalia anyongo bhabhenji Ayakobo na Ayusufu, pamo na anyongo bhabhenji bhana bha Azebedayo. ");
INSERT INTO njd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pajikahika kimuho, akahika mundu jumo akola hilebhe kubhoka ku Alimataya, lihina lyabhe Ayusufu. Jonojwe kabhele akibha bhabhachijigana jwa Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Akaajendelela Apilato, akaajopa mmele gwa Ayesu. Ngapena Apilato akahukumula aapekee. ");
INSERT INTO njd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ayusufu akagutola gonigola mmele gwa Ayesu, akaguhiligila chanda ja chitambala chihuu muno, ");
INSERT INTO njd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","akagubheka nkati ja likabuli lyakwe liyono libhakalibhacha pamwala. Ngapena bhakalimbikia liganga likolongwa nnoongi ja nniango gwa likabuli, akajaula. ");
INSERT INTO njd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Amalia bha ku Magidala na jonijola Amalia jongi bhakibhanga mahali penapo, bhakibhanga bhatamitinge bhabhikulilolanga likabuli. ");
INSERT INTO njd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Malabhi jakwe, yakubhee likibha Lichobha lya Kupomolela, akaakolo bha akaakung'i na Mafalisayo bhakaajendelela Apilato, ");
INSERT INTO njd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na kulobholanga, “Hangwana, tutekombokela kubhee jonijola anami tangu ja kujomoka akalobhola, ‘Mu machobha gatatu gagahika mbakuyoka.’ ");
INSERT INTO njd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa henela nnagikie likabuli lilendelelwe mpaka lichobha lya tatu ili bhabhachijigana bhabhe bhakoto kujibha mmele gwabhe na kwaalobholela bhandu kubhee bhayokite. Unami gongo gwa kupela gupakubhee gubohu muno kupunda gonigola gwa kujemeka.” ");
INSERT INTO njd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Apilato akaalobholelanga, “Aya, mmilinge na manyemba gakulendelela, nnyendange mkalendelele handa chinkombolanga.” ");
INSERT INTO njd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bahi, bhakajaulanga na akaalendei bha likabuli, ili kulendelela, bhakabheka chilangia nnani ja liganga lyela na kuleka penapo akaalendei bhabhi kulendelelanga. ");
INSERT INTO njd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kubhoka ku Lichobha lya Kupomolela, kubhandikila na kuchee lichobha lyela lya Jumapili, Amalia bha ku Magidala na jonijola Amalia jongi bhakajendanga kulolanga likabuli lyela. ");
INSERT INTO njd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Popopo kukabhokela na kulendemela kukuolongwa kwa chilambo, kwa kubhee antumichi jwa kunani kwa Annoongo akatuluka kubhoka kunani akajaula konikola kulikabuli akalipilingita na kulibheka nnyenje linganga lyela na akalitamila. ");
INSERT INTO njd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Akabhonekana handa njahi na ngobho yabhe hikibha hihuhu kuu. ");
INSERT INTO njd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhenibhala bhakulendelela likabuli bhakandendemelanga kwa bhoga nkolongwa, hata bhakibhanga handa bhatekujomokanga. ");
INSERT INTO njd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nambo jonijola antumichi jwa kunani kwa Annoongo akaalobholelanga bhenibhala akaahikege, “Mwangota nkotokujogopanga! Niimanyi kubhee ntendakwaloleanga Ayesu jwakaabhambwa panchalaba. ");
INSERT INTO njd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jwakwa pambani, maana ayokite handa chibhakalobhola. Nhikange nkalolange mahali pabhakaagoneka. ");
INSERT INTO njd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nyaulange chindema nkaalobholelange bhabhachijigana bhabhe kubhee ayokite, na ngocheni atendakwalongoleanga kujaula konikola ku Galilaya, konokwe nga kumpakummonanga. Ayaga, nenga ndekunnobholelanga.” ");
INSERT INTO njd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Henela bhenibhala akaahikege bhakabhokanga chindema penipala palikabuli, bhabhi bhatwelilinge na bhoga nkolongwa kongo bhabhikuhangalala, bhakajaulanga lubhelo kwalobholelanga bhabhachijigana bhabhe ngani hejo. ");
INSERT INTO njd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Popopo, Ayesu akakongana nabho, akalobhola, “Kuhengwa kubhee na mwenga.” Bhenibhala akaahikege bhakaajendelela, bhakatindibhala majugwa nnongi jabhe, bhakagamulanga makongo gabhe. ");
INSERT INTO njd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngapena Ayesu akaalobholelanga, “Nkotokujogopanga! Nyaulange nkaalobholelange akaanung'una bhangu bhajaulange ku Galilaya, na konokwe bhapakumona.” ");
INSERT INTO njd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bhenibhala akaahikege pabhakibhanga nndela bhabhikujaulanga, akaalendei bhangi bha lyenilyee likabuli bhakajaulanga kunnyini na kwalobholelanga akaakolo bha akaakung'i ngani ja hikubho yoha hiitekubhokela. ");
INSERT INTO njd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ngapena akaakolo bha akaakung'i pamo na akanachilongola bha Bhayahudi bhakakongananga, na pabhakakondananga bhakaapekeanga bhenibhala akaaledei mbiha hijingi ");
INSERT INTO njd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bhabhikulobholanga, “Mwangota nkalobholange henela, bhabhachijigana bhabhe bhakahikanga kilo na kugujibha mmele gwabhe twenga tubhi tugolwikinge. ");
INSERT INTO njd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na handa achilongola bha chilambo handaajimanyite ngani heje, twenga mmoange lipamba twenga tupakunnongelelanga na mwangota ngapatanga kulemwa koha kola.” ");
INSERT INTO njd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bhenibhala akaalendei bhakaipetulanga yeniyee mbiya, bhakatendanga handa chibhakajiganwanga. Ngani heyo hitekujeenela pakati ja Bhayahudi mpaka leleni. ");
INSERT INTO njd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ngapena bhenibhala bhabhachijigana bhabhe komi na bhamo bhakajaulanga kuchilambo cha Galilaya pa lyenilyee litombi lilyakaalagikia Ayesu. ");
INSERT INTO njd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pabhakammonanga, bhakaakotimila, nambo bhangi bhakibhanga na lipamba. ");
INSERT INTO njd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ayesu akahika kubhandikila na bhenaangota, akaalobholelanga, “Mbatite uwecho gwa kutabhala kunani kwa Annoongo na pachilambo. ");
INSERT INTO njd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nyaulange, nkaatendange bhandu bha hilambo yoha bhabhee bhabhachijigana bhangu, mmikwabatichanga kwa lihina lya Atati, na lya Amwana, na lya Mboomo ja Annoongo. ");
INSERT INTO njd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mwangota mwajiganange kukamula Malagilo goha gandekumpekeanga. Na nenga mi pamo na mwangota machobha goha, mpaka pachipakujomoka chilambo.”");
ALTER TABLE njd_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
