﻿USE sofia;
DROP TABLE IF EXISTS sofia.niy_vpl;
CREATE TABLE niy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES niy_vpl WRITE;
INSERT INTO niy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yàrɨ́ nɨ́ Yěsù Krɨ́stɔ̀ t’ábhúna-ɔvɔ̀. Yěsù Krɨ́stɔ̀ nɨ’ɨ̀ Dàwudì-dhú bvʉ̌ alɛ, ndɨrɔ̀ Dàwudì nɨ’ɨ̀ Àbràhamʉ̀-dhú bvʉ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Àbràhamʉ̀ náadhɨ̀ Ìsakà, Ìsakà náadhɨ̀ Yàkɔbhɔ̀, Yàkɔbhɔ̀ náadhɨ̀ Yudhà mà adɔ́na mànà. ");
INSERT INTO niy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudhà náadhɨ̀ Pàrezì mà Zǎrà nà. Abádhí-tsánà nɨ’ɨ̀ Tàmarɨ̀. Pàrezì náadhɨ̀ Ɛ̀srɔmʉ̀, Ɛ̀srɔmʉ̀ náadhɨ̀ Àramʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Àramʉ̀ náadhɨ̀ Àmɨ̀nàdabhʉ̀, Àmɨ̀nàdabhʉ̀ náadhɨ̀ Nàsɔnɨ̀, Nàsɔnɨ̀ náadhɨ̀ Sàlmɔnɨ̀, ");
INSERT INTO niy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ndɨrɔ̀, Sàlmɔnɨ̀ náadhɨ̀ Bɔ̀azà. Bɔ̀azà-tsánà nɨ’ɨ̀ Ràhabà. Bɔ̀azà náadhɨ̀ Ɔ̀bɛdɛ̀. Ɔ̀bɛdɛ̀-tsánà nɨ’ɨ̀ Rútà. Ɔ̀bɛdɛ̀ náadhɨ̀ Yɛ̌sɛ̀, ");
INSERT INTO niy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yɛ̌sɛ̀ náadhɨ̀ Ádrʉ̀ngbǎ kamà Dàwudì, ndɨrɔ̀, Dàwudì náadhɨ̀ Sɔ̀lɔ̀mɔnɨ̀. Sɔ̀lɔ̀mɔnɨ̀-tsánà nɨ’ɨ̀ yà Ùriyà-fɔ́ rɔ̀ Dàwudì akɔ̀ tsìbhálɛ. ");
INSERT INTO niy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɔ̀lɔ̀mɔnɨ̀ náadhɨ̀ Rɛ̀hɔ̀bɔ̀hamʉ̀, Rɛ̀hɔ̀bɔ̀hamʉ̀ náadhɨ̀ Àbiyà, Àbiyà náadhɨ̀ Asà, ");
INSERT INTO niy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asà náadhɨ̀ Yɔ̀sàfatà, Yɔ̀sàfatà náadhɨ̀ Yɔ̀ramà, Yɔ̀ramà náadhɨ̀ Ùziyà, ");
INSERT INTO niy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ùziyà náadhɨ̀ Yɔ̀tamʉ̀, Yɔ̀tamʉ̀ náadhɨ̀ Àhazɨ̀, Àhazɨ̀ náadhɨ̀ Zèkíyà, ");
INSERT INTO niy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Zèkíyà náadhɨ̀ Mànasɨ̀, Mànasɨ̀ náadhɨ̀ Àmɔsɛ̀, Àmɔsɛ̀ náadhɨ̀ Yòsíyà, ");
INSERT INTO niy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ndɨrɔ̀, Yòsíyà náadhɨ̀ Yɛ̀kɔ̀nɨyà mà adɔ́na mànà, yà Pbàìsràyélí ka kʉmba kowù nà ɨnɔ tɨ́ Bàbelì tɔ́ pbìrì ɔ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pbàìsràyélí ka kʉ́mbà kowù nà ɨnɔ tɨ́ Bàbelì tɔ́ pbìrì ɔ̀ dhu-dzidɔ̌, Yɛ̀kɔ̀nɨyà náadhɨ̀ Sàrtɨ̀yɛlɛ̀, Sàrtɨ̀yɛlɛ̀ náadhɨ̀ Zèrùbàbelì. ");
INSERT INTO niy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zèrùbàbelì náadhɨ̀ Àbìhudì, Àbìhudì náadhɨ̀ Èlìyàkimù, Èlìyàkimù náadhɨ̀ Àzɔrɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Àzɔrɔ̀ náadhɨ̀ Zàdhokì, Zàdhokì náadhɨ̀ Àkimù, Àkimù náadhɨ̀ Èlìhudì, ");
INSERT INTO niy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Èlìhudì náadhɨ̀ Èlìyèzerì, Èlìyèzerì náadhɨ̀ Màtanɨ̀, Màtanɨ̀ náadhɨ̀ Yàkɔbhɔ̀, ");
INSERT INTO niy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yàkɔbhɔ̀ náadhɨ̀ Yɔ̀zɛfʉ̀, ndɨ Yɔ̀zɛfʉ̀ nɨ’ɨ̀ Màrɨyà bhà alɛ. Ndɨ Màrɨyà nɨ́ ndɨ, Yěsù, yà Krɨ́stɔ̀ tɨ́ kátɨna alɛ nadhɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɨ́ kɔ́rɔ́ ɨ rʉ̀gànda-bvʉ nɨ́ɨ’ɨ̀ yà dhu bhěyi: rɔ̀pɛ̀ ndɨ̀ Àbràhamʉ̀ rɔ̌ rɔ̀, ràrà àhʉ Dàwudì rɔ̌, nɨ’ɨ̀ atdí kumì dɔ̀ná ɨ̀fɔ nà rʉ̀gànda. Rɔ̀pɛ̀ ndɨ̀ Dàwudì rɔ̌ rɔ̀, ràrà àhʉ Pbàìsràyélí nʉ́mba ka kɨ́ kowù nà ɨnɔ tɨ́ Bàbelì tɔ́ pbìrì ɔ̀ dhu ɔ̀, nɨ’ɨ̀ atdí kumì dɔ̀ná ɨ̀fɔ nà rʉ̀gànda. Ndɨrɔ̀ rɔ̀pɛ̀ ndɨ̀ Pbàìsràyélí ka kʉ́mbà kowù nà ɨnɔ tɨ́ Bàbelì tɔ́ pbìrì ɔ̀ dhu rɔ̌ rɔ̀, ràrà àhʉ Yěsù Krɨ́stɔ̀ nʉ́gʉ ka kɨ́ dhu ɔ̀, nɨ’ɨ̀ atdí kumì dɔ̀ná ɨ̀fɔ nà rʉ̀gànda. ");
INSERT INTO niy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yěsù Krɨ́stɔ̀ nʉ́gʉ ka kɨ́ dhu nɨ́ɨ’ɨ̀ yà dhu bhěyi: kà-tsánà, Màrɨyà, nɨ́ɨ’ɨ̀ ɨwà Yɔ̀zɛfʉ̀ órì rɔ́. Pbɛ́tʉ̀, ɨnzá ɨ̀ àpɛ̀ ’ʉ̀mbǎ rɔ́rɔ̀, Màrɨyà náatù ndɨ̀ ɔ̀na nà Ɨ̀lɨ̌lǎ-Alafí bhà ɔbɨ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yɔ̀zɛfʉ̀, yà kà mà rɨ̌ ’ʉ̀mbǎ nà alɛ, nɨ’ɨ̀ obhónángatálɛ. Pbɛ́tʉ̀, kǎzè nzá kà-nyɨ̀ nɨ́wʉ̌ ndɨ̀ ndɨ́ ibí alɛ nzínzì ɔ̌ dhu. Nɨ́ kǎzè ndɔ̀dhɔ̀ ka ɨnzá ìndrǔ nʉ́nɨ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wɔ̀ dhu nɨ́rɛ̀ kà rɨ̌ rɔ́rɔ̀ nɨ́ ndɨ, Kàgàwà bhà màlàyikà náavì ndɨ̀ ɔnyʉ-bvʉ̀ kà tɔ̀ ndàtɨ: «Yɔ̀zɛfʉ̀, Dàwudì-dhú bvʉ̌ alɛ́, ɨ̀nzɨ̌ ɔnzɨ Màrɨyà nídyì nyɨ nyɨ́ pbʉ̀kʉ̀ tsìbhálɛ tɨ́ dhu-ɔdɔ̀. Obhó tɨ́, kà rɨ̌’ɨ̀ nà ari nɨ́ Ɨ̀lɨ̌lǎ-Alafí bhà ɔbɨ nɨ̌ kǒdyì. ");
INSERT INTO niy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kʉ̌gʉya kpatsìbhíngba, nyadʉ̀ ɔvɔ̀na nɔ́vɔ̀ Yěsù tɨ́, ka nɨ́ ndɨ pbɨ̀ndà alɛ nɨgʉ́ya fɨ̌yɔ́ nzɛ́rɛnga ɔ̌ rɔ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kɔ́rɔ́ wɔ̀ dhu náanzɨ̀ ndɨ̀, ndɨ́nɨ̌ angyí Kàgàwà nʉ́ʉnɔ pbɨ̀ndà nabì otù ɔ̌ dhu náaká tɨ́. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Kànɨ̌ ɨnzá àpɛ̀ kpatsìbhálɛ nʉ́nɨ̌ tsìbhíngba nɨ́ɨ’ɨya ɔ̀na nà. Ndɨrɔ̀ kʉ̌gʉya kpatsìbhá ngbángba, kadʉ̀ ɔvɔ̀na nɔ́vɔ̀ Mànolì tɨ́.» Kà-tɨ̀ nɨ́: «Kàgàwà rɨ̌’ɨ̀ atdíkpá àlɛ̌ mànà.» ");
INSERT INTO niy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɨdhɔ ɔ̀ rɔ̀ ndɨ̀ ndɨ̀và ndɨ̀ rɔ̀, Yɔ̀zɛfʉ̀ náanzɨ̀ yà Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà nʉ́nɔ̀nà fɨ̌ndà dhu. Nɨ́ kǎdʉ̀ Màrɨyà nídyì pbɨ̀ndà tsìbhálɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pbɛ́tʉ̀ kʉ̌pbá nzá kà-ngbɔ̀, ràrà àhʉ kà rɨ̌ kpatsìbhá ngbángba nʉ́gʉ dhu ɔ̀. Nɨ́ Yɔ̀zɛfʉ̀ náadʉ̀ ndɨ ngbángba-ɔvɔ̀ nɔ́vɔ̀ Yěsù tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yěsù ka kʉgʉ Yùdɛyà tɔ́ pbìrì ɔ̌ kɨgɔ̀, Bɛ̀tɛ̀lɛ̀hɛmʉ̀ tɨ́ kátɨna ɔ̀, ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ bhà atɔ ɔ̌. Ndɨ nɨ́nganɨ́, ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ rɨ́ ’ɔ̀nzɨ dhu dɔ̌ ɨnga nʉ́nɨ alɛ-akpá níiwú adyifɔ̀ náarɨ́ ndɨ̀tɔ ɨnǎ rɔ̀, ’ìwǔ ùvò Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nɨ́ abádhí níivú dhu ìndrǔ-tsʉ̌ ’àtɨ: «Yà ka kʉ̀gʉ̀ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà rɨ̌’ɨ̀ ɨ̀ngbɔrɔ́? Mǎ màla kàbhà alalɨ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ adyifɔ̀ arɨ́ ndɨ̀tɔ ɨnǎ rɔ̀. Nɨ́ mǎ mìwǔ ka nɨ́fʉ.» ");
INSERT INTO niy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ mà kɔ́rɔ́ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ bhà mànà nɨ́ɨrɛ̀ nga abhɔ nyʉ́, dɔ̀ya ràdʉ̀ ndɨ̀nza atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nɨ́ kǔndu pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà kɔ́rɔ́, ndìvǔ Krɨ́stɔ̀ nʉ́gʉ ka kàmbɛ̀nà ɨ nga tsʉ̀yá. ");
INSERT INTO niy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nɨ́ abádhí náadù ɔtɛ kà tɔ̀ ’àtɨ: «Bɛ̀tɛ̀lɛ̀hɛmʉ̀, Yùdɛyà tɔ́ pbìrì ɔ̀. Obhó tɨ́, Kàgàwà bhà nabì náandí dhu angyí, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ndɨrɔ̀ ɨnyɨ Bɛ̀tɛ̀lɛ̀hɛmʉ̌, Yudhà bhà pbìrì ɔ̌ nyɨ nyɨ́’ɨ̀ rɔ̀, nyɨ nɨ́ nzɨ̌ pɔ́tsɔ̀ kɨgɔ̀ Yùdɛyà ɔ̌ kɨgɔ̀ nzínzì ɔ̌. Obhó tɨ́, ʉ̀nʉ́ rɔ̀ nɨ́ ndɨ atdí kamà rǎhʉ. Ndɨ kamà nɨ́ ndɨ Pbàìsràyélí, pbàkà alɛ nʉndaya.›» ");
INSERT INTO niy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wɔ̀ dhu-dzidɔ̌, kamà Hɛ̀rɔdɛ̀ náanzi kɔ̌kɔ̀ ɨnga nʉ́nɨ alɛ-akpá ɨnzá ngʉ̌kpà alɛ nʉ́nɨ rɔ́rɔ̀, ndìvǔ alalɨ abádhí ala dòtsí ɔ̀ná ɨdhɔ tsʉ̀yá. ");
INSERT INTO niy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nɨ́ kǎdʉ̀ abádhí nóvì Bɛ̀tɛ̀lɛ̀hɛmʉ̀ tɔ́ kɨgɔ̀ ɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu nyɔ̀mɛ pɛ́ awáwʉ̀ wɔ̀ ngbángba dɔ̌. Ndɨrɔ̀ ka nyɨ̌ nyòtù rɔ̀, nɨ́ nyàdʉ̀ nyìbho màkʉ̌rʉ̀ idù, ndɨ́nɨ̌ ma madʉ̀ tɨ́ àrà kɨ̀fʉ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ bhà ɔtɛ ɨ̀ ɨ̀rɨ̀ dhu-dzidɔ̌, abádhí náadɨ̀ dɔ̀ya ’òwù. Nɨ́rɔ̀ nɨ́ ndɨ yà abádhí álaná adyifɔ̀ arɨ́ ndɨ̀tɔ ɨnǎ rɔ̀ alalɨ náadɨ̀ angyi abádhí tɔ̀, ndàmbɛ àrà dɔ̌, ndàrà ìde yà ngbángba rɨ̌’ɨ̀ ɔ̀ná ngari-dɔ̀tsírɔ́. ");
INSERT INTO niy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Abádhí níitdègu wɔ̀ alalɨ nálǎ, nɨ́ abádhí-dhɛ̀ nɨ́ɨka ndɨ̀ atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nɨ́ abádhí náatsù ányɨ̀-dza, ’àdʉ̀ ngbángba mà nála ɨ́yànà Màrɨyà mànà. Nɨ́ abádhí nʉ́ʉkɔ ɨ̀ ɔtdyʉ̀ya dɔ̌, ɨ̀ rɨ̀fʉ ndɨ ngbángba. Wɔ̀ dhu-dzidɔ̌, abádhí nʉ́ʉnga fɨ̀yɔ́ bhɔlɔ-tsʉ̀, ’àdʉ̀ pɛrɛ̀ núbho, ’ɔ̀dhɛ̀ ka nɨ̌. Ɨ pɛrɛ̀ nɨ’ɨ̀: ɔrɔ̀ mà, mběyi arɔ́ngʉ kàzʉ ɔ̀ ka kɔ̀bɨ̀ ndɨ̀ rɔ̀ alɨndra-tɨdɔ̀ mà, ndɨrɔ̀ mběyi arɔ́ngʉ akyɛ-tɨdɔ̀, mànɛ̀manɛ̀ tɨ́ kátɨna mànà. ");
INSERT INTO niy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wɔ̀ dhu-dzidɔ̌, Kàgàwà nʉ́ʉnɔ dhu ɔnyʉ-bvʉ̀ abádhí tɔ̀, ɨ̀nzɨ̌ ɨ̀ nadù tɨ́ Hɛ̀rɔdɛ̀ bhà nanǎ. Nɨ́ abádhí adʉ̀ ’àdu fɨ̀yɔ́ pbìrì ɔ̀ ngǎtsi otu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɔ̌kɔ̀ abhɔ ɨnga nʉ́nɨ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ arɨ́ ’ɔ̀nzɨ dhu dɔ̌ alɛ-akpá nádu ɨ̀ dhu-dzidɔ̌, Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà náavì ndɨ̀ Yɔ̀zɛfʉ̀ tɔ̀ ɔnyʉ-bvʉ̀, ndàdʉ̀ àtɨ̀nà kànɨ̌: «Ɨ́và nyɨ, nyidyì ngbángba mà ɨ́yànà mànà, nyadʉ̀ ɔ̀kʉ nà Mísrì tɔ́ pbìrì ɔ̀. Ndɨrɔ̀, nyàdʉ̀ nyòko ányɨ̀ ràrà àhʉ ma mɨ́ nyǎvǐ nyǎdu nyɨ̌ ányɨ̀ rɔ̀ dhu ɔ̀. Obhó tɨ́, Hɛ̀rɔdɛ̀ rɨ̌ ngbángba nábhʉ̌ kambɛ ɔ̀nɛ̀nà dɔ̌, ndɨ́nɨ̌ ka koho tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nɨ́ ndɨ iku ɔ̌ tɨ́, Yɔ̀zɛfʉ̀ nɨ́ɨvà ndɨ̀ ɨdhɔ ɔ̀ rɔ̀, ndìdyì ngbángba mà ɨ́yànà mànà, ndɔ̀kʉ̀ nà Mísrì tɔ̀ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Abádhí adʉ̀ òko ányɨ̀, ràrà àhʉ Hɛ̀rɔdɛ̀ rɔ̌vɛ̀ dhu ɔ̀. Wɔ̀rɨ́ dhu náanzɨ̀ ndɨ̀ ndɨ́nɨ̌ Ádrʉ̀ngbǎlɛ Kàgàwà nʉ́ʉnɔ pbɨ̀ndà nabì-otù ɔ̌ dhu náaká tɨ́. Kǎtɨ: «Ma mánzì idhùdu ràhʉ Mísrì rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛ̀rɔdɛ̀ níitdègu dhu nɔ́sʉ̀ ʉ̀trǎ tɨ́ abhɔ ɨnga nʉ́nɨ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ arɨ́ ’ɔ̀nzɨ dhu dɔ̌ alɛ-akpá rʉ̀trǎ ndɨ̀, nɨ́ kà-afí-ɔ̌nga nɨ́ɨwa ndɨ̀ atdídɔ̌. Nɨ́, kǎvì pbɨ̀ndà pbànówí rɔ̀kyɛ̀ ɔ́yɔ̌ atɔ nà kpabhá nzónzo mà, ɨnzá àpɛ̀ ɔ́yɔ̌ atɔ nísě kpabhá nzónzo mànà kɔ́rɔ́, Bɛ̀tɛ̀lɛ̀hɛmʉ̀ tɔ́ kɨgɔ̀ mà, tɨná arɨ́’ɨ̀ kɔ́rɔ́ pbanga mànà ɔ̌ rɔ̀. Kǎnzɨ̀ wɔ̀ dhu àdhàdhɨ̀ yà ɨ abhɔ ɨnga nʉ́nɨ alɛ-akpá nábhʉ fɨ̌ndà alalɨ ɨ̀ ala ɔ̀ná kàsʉmɨ̀ dɔ̌ awáwʉ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nɨ́rɔ̀ nɨ́ ndɨ yà nabì Yɛ̀rɛ̀mɨyà nʉ́ʉnɔ kpangba dhu náaká. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Alɛ-tù ɨ̀rɨ̀ ndɨ̀ Ramà tɔ́ kɨgɔ̀ ɔ̀. Ìndrǔ rɔ̌dzɨ, ndàdʉ̀ àmbɛ ndʉ̀hʉ dɔ̌ atdídɔ̌. Ràkelì nɨ́ ndɨ rɨ́ pbɨ̀ndà inzo nɔ́dzɨ. Kòzè nzá kopè afína mà, ɨwà ɨ inzo nʉ́vɛ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɛ̀rɔdɛ̀ nɔ́vɛ̀ dhu-dzidɔ̌, Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà náavì ndɨ̀ ɔnyʉ-bvʉ̀ Yɔ̀zɛfʉ̀ tɔ̀ Mísrì tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ndɨ màlàyikà náatɨ Yɔ̀zɛfʉ̀ nɨ̌: «Ɨ́và nyɨ, nyidyì ngbángba mà ɨ́yànà mànà, nyadʉ̀ nyadu abádhí nà Ìsràyelì tɔ́ pbìrì ɔ̀. Obhó tɨ́, yà ndɨ ngbángba nazè ’òhò alɛ nʉ́vɛ wà.» ");
INSERT INTO niy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nɨ́, Yɔ̀zɛfʉ̀ nɨ́ɨvà ndɨ̀, ndìdyì ngbángba mà ɨ́yànà mànà, ndàdu ndɨ̀ nà Ìsràyelì tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pbɛ́tʉ̀, kǐtdègu dhu nɨ́rɨ Àrkɛ̀lawʉ̀ ràrɨ̌ ndɨ àbanà Hɛ̀rɔdɛ̀ dzidɔ̌ idzi nɔ́nyʉ̀ Yùdɛyà tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà tɨ́, nɨ́ kǎdʉ̀ ndɨ pbìrì ɔ̀ ndɨ̀ ndárà àdɨ dhu-ɔdɔ̀ nɔ́nzɨ̀. Kàgàwà ɔ̀vɔ̀ dhu fɨ̌ndà ɔnyʉ-bvʉ̀ dhu-dzidɔ̌, Yɔ̀zɛfʉ̀ náadʉ̀ àrà Gàlìlayà tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kǎdʉ̀ àrà àdɨ Nàzàretì tɨ́ kátɨna atdí kɨgɔ̀ ɔ̀. Ndɨ dhu náanzɨ̀ ndɨ̀ wɔ̀ dhu bhěyi, ndɨ́nɨ̌ Kàgàwà nʉ́ʉnɔ pbɨ̀ndà pbànábí-otù ɔ̌ dhu náaká tɨ́. Kǎtɨ: «Ka kanziya ka Nàzàretì ɔ̌ alɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, bàtizò nubhónà Yùwanɨ̀ nɨ́ɨtɔ ndɨ̀ Yùdɛyà tɔ́ rʉ̀ngʉ̀ ɔ̀. Kǎmbɛ́nà Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ dɔ̌ ìndrǔ tɔ̀, ndàrà àtɨ̀nà rɔ̌: ");
INSERT INTO niy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga. Obhó tɨ́, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi-tsʉ̀ níndù wà ndɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yùwanɨ̀ nɨ́ ndɨ, yà nabì Ìsayà nʉ́ʉnɔ dhu dɔ̀ná alɛ, ndàtɨ: «Kànɨ̌ atdí alɛ-tù rɨ̌ ndɨ̀rɨ rʉ̀ngʉ̀ ɔ̀: ‹Nyɔ̀bhɔlɔ Ádrʉ̀ngbǎlɛ Kàgàwà bhà ngʉdhà, nyùtǒ kàbhà otu.›» ");
INSERT INTO niy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ndɨ Yùwanɨ̀ rɔ̌ mʉ̀dzarʉ̀ nɨ’ɨ̀ ngàmɨyà tɨ́ kátɨna ɨ̀zǎ-ká nɨ̌ ka kódyù. Ndɨrɔ̀ kǐsónà ɔ̀na asé tɔ́ kùkyě nɨ̌. Kǒngónà àdʉ̀ ndòngù índù mà, ɨrɨ́ ɔ̌ ɨtɨ-dha mànà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nɨ́ ìndrǔ nóongónà ìwu kà-tɨ’ɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, Yùdɛyà tɔ́ pbìrì ɔ̀ rɔ̀ kɔ́rɔ́, ndɨrɔ̀ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-bɨdɔ̌ arɨ́’ɨ̀ kɔ́rɔ́ mʉ̀lɛngʉ̀ ɔ̀ rɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Abádhí nʉ́ʉnɔ́nà fɨ̀yɔ́ nzɛ́rɛnga kpangba kɔ́rɔ́ alɛ-ɔ̀nzɨ̌, Yùwanɨ̀ ràdʉ̀ bàtizò núbho fɨ̌yɔ̀ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bàtizò nubhónà Yùwanɨ̀ náala ábhɔ̌ Pbàfàrìsáyó mà, Pbàsàdùkáyó mànà tɨna ɔ̀ rówu ìwu rɔ̌ ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ bàtizò rɔ́. Nɨ́ kǎtɨ abádhí nɨ̌: «Nyɨ̌, ámvɔ̀ tɔ́ osu-tsè! Ádhɨ ndɨ dhu nɔ́vɔ̀ fʉ̌kʉ̀ ndɨ́nɨ̌ nyɨ̌ nyotse tɨ́ yà rɨ́rà Kàgàwà bhà nàwí-tsʉ̌ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nyɔ̀nzɨ ɨwà nyɨ̌ nyʉ́gɛ̀rɛ̀ nyɨ̌, nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga dhu návǐ rɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ndɨrɔ̀, àpɛ́ nyɨ̀rɛ̀ nga afíkʉ ɔ̀, nyǎtɨ: ‹Àbràhamʉ̀ nɨ́ abhukà!› Ma mɨ́ dhu nʉ́nɔ kpangba fʉ̌kʉ̀, Kàgàwà rǎdʉ̀ kǎkàrɨ́ odu mà nʉ́gɛ̀rɛ̀ ròngò Àbràhamʉ̀ t’ídhúna tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Àlɔ̌ ka kɨ̀lɨ wà itsu-pfɔ̀ rɔ̌, ndɨ́nɨ̌ ka kɨ’à tɨ́ ɨ itsu-vɛ́ nɨ̌. Nɨ́ kɔ́rɔ́ itsu yà ɨ̀nzɨ̌ arɨ́ ídzì itsu-kpɔ̌ nɨ́’ɔ̌, nʉ́kɛ̀rɛ̌ ka kɨ́, kadʉ̀ àwànà kàzʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨma, ma mɨ́ bàtizò núbhǒ fʉ̌kʉ̀ ɨdha nɨ̌, ndɨ́nɨ̌ ɨwà nyɨ̌ nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga dhu navì tɨ́. Pbɛ́tʉ̀, dzidu dɔ̌ rɨ́rà alɛ náaraya bàtizò núbho rɔ̌ fʉ̌kʉ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ̌, ndɨrɔ̀ kàzʉ nɨ̌. Ndɨ alɛ rɨ̌’ɨ̀ ɔbɨ nà atdídɔ̌ ròsè dùdu nǎ. Ma màkǎ nzá mʉwà kà-pfɔ̀ rɔ̌ kàyìtò mà. ");
INSERT INTO niy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kàlʉ̌ ɔ̀nyʉ̀-ɔ̌nga t’ɨ́lɛ̀ta tɔ́ kanyà-tɨdɔ̀ fɔná. Ndɨrɔ̀ kà rɨ̌ pbɨ̀ndà odhó-dɔ̌nga nátsu, ndàdʉ̀ nganʉ̀-kpɔ̌ nípfo kɛ́lɛ́na ɔ̀ rɔ̀. Kà rɨ̌ pbɨ̀ndà nganʉ̀-kpɔ̌-tsʉ̀ núndǔ ɔ́ngɔ̀lɨ̌ ɔ̀, ndàdʉ̀ dzɛ́ngɛ́lɛ́na nʉ́bɨ̀ ɨ̀nzɨ̌ arávɛ ádrʉ̀ngbǎ kàzʉ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Atdíku, Yěsù nɨ́ɨra Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀, ndɨ̀rà àhʉ Yùwanɨ̀-tɨ’ɔ̀, Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-tsʉ̀, ndɨ́nɨ̌ kǎbhʉ̀ tɨ́ bàtizò fɨ̌ndà. ");
INSERT INTO niy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nɨ́ Yùwanɨ̀ núuvó ndɨ̀ kà-rɔ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨma nɨ́ ndɨ, ma màmbɛ̀nà bàtizò nálʉ̌ fʉnʉ́, nɨ́ ádhu nyɨ nyádʉ̀ ɨ̀rà kònzì fudú nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pbɛ́tʉ̀, Yěsù náadʉ̀ ɔtɛ àdu kà tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ úvǒ nyɨ! Ítsè kà rɨ’ɨ ndɨ dhu bhěyi. Obhó tɨ́, kòmbí dhu àkǎ àlɛ̌ rɔ̀nzɨ̀ kɔ́rɔ́ dhu Kàgàwà nózè ka dhu bhěyi.» Nɨ́rɔ̀ nɨ́ ndɨ Yùwanɨ̀ náadʉ̀ Yěsù nʉ́nɔ̀ dhu ná’ù, ndàdʉ̀ bàtizò nábhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bàtizò ndɨ̀ ndàlʉ̌ rɔ́rɔ̀ tɨ́, Yěsù rǎhʉ ɨdha ɔ̀ rɔ̀ rɔ̀, ɔ̀rʉ̀-akpà-tsʉ̀ náangbɛ ndɨ̀ kà tɔ̀. Nɨ́ kǎla Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ɔrʉ̀ rɔ̀ rífo àmbò tɔ́ ɔ́fɔ̀ ɔ̌ rɔ́, ndɨ àmbò ràdʉ̀ àdɨ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ndɨrɔ̀ Kàgàwà-tù náadʉ̀ ndɨ̀rɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndàtɨ: «Yàrɨ́ nɨ́ Idhùdu, atdídɔ̌ ma mózè, nyɨ̀kpɔ́du nɔ̀fɔ̀ dhu ɔ̀nzɨ arɨ́ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wɔ̀ dhu-dzidɔ̌, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí náabhʉ̀ Yěsù ràrà rʉ̀ngʉ̀ ɔ̀, ndɨ́nɨ̌ Pfɔ̀mvɔ núumvú tɨ́ afína. ");
INSERT INTO niy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nɨ́ Yěsù nʉ́ʉtsɨ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ ɨ̀fɔ kumì ɨdhɔ tɨ́, ɨ̀nzɨ̌ ndàrà ɔ̀nyʉ̀ nɔ́nyʉ̀ rɔ̌ adyíbhengá màtɨ́ ndɨrɔ̀ kùbhingá màtɨ́. Nɨ́ àwù náadʉ̀ kàlʉ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nɨ́rɔ̀ nɨ́ ndɨ pfɔ̀mvɔ nɨ́ɨra àhʉ kà-tɨ́, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Kàgàwà t’Ídhùnà nyʉ́ tɨ́, nɨ́ ávǐ kàrɨ́ odu rʉ̀gɛ̀rɛ̀ ɨ̀, ’òngò mʉ̀gatì tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu katɨ: ‹Ɨ̀nzɨ̌ nɨ́ mʉ̀gatì kɛ̀lɛ̌ ndɨ ìndrǔ tɔ̀ rǎdʉ̀ ípìrɔ̌nga nábhʉ, pbɛ́tʉ̀ Kàgàwà-li’ɔ̀ rɔ̀ àhʉ kɔ́rɔ́ ɔtɛ nɨ́ ndɨ rǎdʉ̀ ípìrɔ̌nga nábhʉ ìndrǔ tɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tdɨ́tdɔ̌, Pfɔ̀mvɔ náarà kà nà Yèrùsàlɛmà, ɨ̀lɨ̌lǎ kɨgɔ̀ ɔ̀, ndàdʉ̀ kàbhʉ rùpò Kàgàwà bhà ɨdza dɔ̀-tsírɔ́ ɔrʉ́ ngari dɔ̀, ");
INSERT INTO niy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ndàdʉ̀ àtɨ̀nà kànɨ̌: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Kàgàwà t’ídhùnà nyʉ́ tɨ́, nɨ́ ɔ́bɛ̀ pɛ́ nyɨ obvò. Obhó tɨ́, Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu katɨ: ‹Kàgàwà rɨ̌ dhu nʉ́yǎ pbɨ̀ndà màlàyikà tɔ̀ okúnʉ dɔ̀ rɔ̀, ndɨ́nɨ̌ nyɨ nɔkɔ tɨ́ ɔrʉ́ rɔ̀ ɔtsʉ́na-tsírɔ́, akyɛ odu nɔ́ɔbɛna pfɔ̌nʉ nɨ̌.›» ");
INSERT INTO niy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu átɔ̀ katɨ: ‹Dhu-àkǎ nzá nyumvǔ pbʉ̀kʉ̀ Ádrʉ̀ngbǎlɛ Kàgàwà-afí.›» ");
INSERT INTO niy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wɔ̀ dhu-dzidɔ̌, Pfɔ̀mvɔ abhʉ̀ Yěsù rùpò ádzǐ pbìrì-akpà dɔ̀. Kǎdʉ̀ kɔ́rɔ́ yà adzɨ dɔ̌ ádrɔ̀drɔ̌ kámá tɔ́ pbìrì mà, kɔ́rɔ́ ɔ̀yá ònzì mànà nɨ́tɛ̀ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kǎdʉ àtɨ̀nà Yěsù nɨ̌: «Nyɨ nyapɛ́ nyɔkɔ̀ ɔtdyʉ̀nʉ dɔ̌ ɔnzɨ̀dú nyɨfʉ ma, nɨ́ kɔ́rɔ́ kɔ̀rɨ́ dhu núbhǒ ma mɨ́ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Índrǐ nyɨ́ àwú, Sìtanɨ̌! Obhó tɨ́, Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu katɨ: ‹Dhu àkǎ nyʉlɛ̌ Ádrʉ̀ngbǎlɛ pbʉ̀kʉ̀ Kàgàwà, nyadʉ̀ kà kɛ̀lɛ̌ nɨ́fʉ atdírɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nɨ́rɔ̀ nɨ́ ndɨ Pfɔ̀mvɔ náadʉ̀ ndɨ̀và, ndàrà kà-tɨ́ rɔ̀. Kàgàwà bhà màlàyíká náadʉ̀ ìwu Yěsù-tɨ’ɔ̀, àdʉ̀ àmbɛ kà kàsʉ̌ nɔ́nzɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yěsù níitdègu bàtizò nubhónà Yùwanɨ̀ ka kósò imbi ɔ̀ dhu nɨ́rɨ, nɨ́ kǎdʉ̀ àrà fɨ̀ndá dhu nɨ̌ Gàlìlayà tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ányɨ̀, kǎdɨ̀ nzá Nàzàretì tɔ́ kɨgɔ̀ ɔ̌, pbɛ́tʉ̀ kǎdʉ̀ àrà àdɨ Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̌ arɨ́’ɨ̀ kɨgɔ̀, Kàpɛ̀rnàwumù tɨ́ kátɨna ɔ̀. Kàpɛ̀rnàwumù nɨ’ɨ̀ Zàbʉ̀lɔnà mà, Nɛ̀ftalɨ̀ mànà tɔ́ mʉ̀lɛngʉ̀ ɔ̌ kɨgɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kɔ́rɔ́ wɔ̀ dhu náanzɨ̀ ndɨ̀, ndɨ́nɨ̌ Kàgàwà nʉ́ʉnɔ pbɨ̀ndà nabì Ìsayà-otù ɔ̌ dhu náaká tɨ́. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ɔ̀ɔ! Zàbʉ̀lɔnà bhà pbìrì mà, Nɛ̀ftalɨ̀ bhà pbìrì mànǎ, ádrʉ̀ngbǎ rɛ̀rʉ̀-bɨdɔ̀ rárà ngʉdhà, Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-adzè nǎ rɔ̀ rɨ́’ɨ̀ pbìrì, Gàlìlayà, yà ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí náaróko ɔ̀ná pbìrì! ");
INSERT INTO niy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yà ɨ́nɔ̀ ɔ̌ aróko kɔ́rɔ́ alɛ nála wà ádrʉ̀ngbǎ awáwʉ̀. Yà ɔvɛ-sɨsɨ̀ tɔ́ ɨ́nɔ̀ níibvú ndɨ̀ dɔ̀ná pbìrì ɔ̌ aróko alɛ dɔ̌nga awáwʉ̀ náwʉ̀ wà.» ");
INSERT INTO niy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kàpɛ̀rnàwumù ndɨ̀ ndàrà àhʉ rɔ̀ nɨ́ ndɨ, Yěsù apɛ̀ ndʉ̀nɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀, ndàrà àtɨ̀nà rɔ̌: «Nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga. Obhó tɨ́, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi-tsʉ̀ níndù wà ndɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̌ ndɨ̀ ndúbhi rɔ́rɔ̀, Yěsù náala atdí alɛ bhà ɔ́yɔ̌ inzo. Abádhí nɨ’ɨ̀ àwěrù. Atdí-ɔvɔ̀ nɨ’ɨ̀ Sìmonì. Ngǎtsi ndɨ Sìmonì-ɔvɔ̀ nɨ’ɨ̀ Pɛ́tɛrʉ̀. Ndɨrɔ̀ kà t’ádɔ̀nà-ɔvɔ̀ nɨ’ɨ̀ Àndɛ̀rɛyà. Abádhí ubhínà ɨ̀bhɛ̀ nɔ́kyɛ̀ rɔ̌ imbi nɨ̌ rɛ̀rʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nɨ́ Yěsù atɨ abádhí nɨ̌: «Nyìwǔ owùdu ɔ̌! Ma mɨ́ nyʉ̌gɛ̀rɛ̀, nyǒngò ìndrǔ-tsʉ̀ núndu róngo, ndɨ́nɨ̌ owùdu nʉngʉ tɨ́ alɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nɨ́ ʉrɔ́ rɔ̀ tɨ́, abádhí nʉ́ʉbhà fɨ̀yɔ́ ɨ̀bhɛ̀-mbǐ, ’àdʉ̀ òwu kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tdɨ́tdɔ̌ Yěsù náandrì ɨtsɛta akɛ, ndàdʉ̀ Zɛ̀bɛ̀dayò bhà ɔ́yɔ̌ inzo nála. Ɨ inzo nɨ’ɨ̀ Yàkɔbhɔ̀ mà adɔ̀nà Yùwanɨ̀ mànà. Abádhí nɨ́ɨ’ɨ̀ fɨ̀yɔ́ ibhú ɔ̀, àbayà Zɛ̀bɛ̀dayò mànà, fɨ̀yɔ́ ɨ̀bhɛ̀-mbǐ nɔ́bhɔlɔ ɨ̀ ɨ́ rɔ́. Nɨ́ Yěsù adʉ̀ abádhí nánzì. ");
INSERT INTO niy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, abádhí adʉ̀ àbayà nʉ́bhà ibhú mànà, ’àdʉ̀ òwu Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yěsù nóongónà ùbhi kɔ́rɔ́ ngari ɔ̀nǎ Gàlìlayà tɔ́ pbìrì ɔ̌. Kǎránà dhu ùdhe rɔ̌ unduta-dzà ɔ̌ rɔ̀, ndàdʉ̀ àrà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ìndrǔ tɔ̀. Ndɨrɔ̀ kǎránà kɔ́rɔ́ andɨ-tɨdɔ̀ nɨ́gʉ rɔ̌, ndàdʉ̀ kɔ́rɔ́ otsu-tɨdɔ̀ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɨ́ kɔ̀yɨ̌ náaká kɔ́rɔ́ Sìriyà tɔ́ pbìrì ɔ̌. Ndɨrɔ̀, ka kowúnà dhèdhèrɔ̀ andɨ-tɨdɔ̀ nɨ̌ arándɨ alɛ nʉ́mbà rɔ̌ kà-fɔ’ɔ̀. Ɨ alɛ nɨ’ɨ̀ yà nzɛ́rɛ-alafí nà arɨ́’ɨ̀ ɔ̀yà alɛ mà, sɨ́mvɔtálɛ mà, ndɨrɔ̀ ngbɔ̌ya ʉ́vɛ alɛ mànà. Nɨ́ Yěsù náaránà ɨ alɛ nɨ́gʉ rɔ̌ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ábhɔ̌ ihé-yà nóowúnà ìwu rɔ̌ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀, Dɛ̀kàpolì tɔ́ pbìrì ɔ̀ rɔ̀, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, Yùdɛyà tɔ́ pbìrì ɔ̀ rɔ̀, ndɨrɔ̀ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-adzè rɔ̀ màtɨ́, ɨ̀ rùbhi kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yěsù níitdègu ihé-yà nálǎ, nɨ́ kǔpò pbìrì dɔ̀, ndàdʉ̀ àdɨ obvò. Nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ ìwu kà-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu abádhí tɔ̀, ndàmbɛ àtɨ̀nà dɔ̌: ");
INSERT INTO niy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Hirò nɔnzɨya alɛ nɨ́ yà nǎkʉ̀ tɨ́ arɨ́’ɨ̀ alɛ-afí ɔ̀nǎ rɔ̀ alɛ, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi nɨ́ abádhí tɔ́ nɨ́dhunɨ̌! ");
INSERT INTO niy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hirò nɔnzɨya alɛ nɨ́, yà kòmbí aróko nyɨ̀ya-dha ɔ̌ alɛ, Kàgàwà nóopéya abádhí-afí nɨ́dhunɨ̌! ");
INSERT INTO niy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hirò nɔnzɨya alɛ nɨ́ yà ɨ̀yɔ̀nga ɔ̌ aróko alɛ, abádhí nóokoya yà adzɨ-kàmǎ tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hirò nɔnzɨya alɛ nɨ́, yà obhónánga ɔ̀nzɨ ɨ̀ ɨ́ dhu tɔ́ àwù nà arɨ́’ɨ̀, àdhàdhɨ̀ ɔ̀nyʉ̀ mà ɨdha mànà-atdyú òho ka karɨ́ dhu bhěyi alɛ, Kàgàwà náadʉ̀ya abádhí ózè dhu nábhʉ ràkǎ abádhí tɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hirò nɔnzɨya alɛ nɨ́ ɨzʉ nábà arɨ́ ɔdhɨ́ya dɔ̌ alɛ, Kàgàwà náabáya ɨzʉ abádhí dɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hirò nɔnzɨya alɛ nɨ́ afíya ɔ̀nǎ rɔ̀ ɨ́lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ alɛ, abádhí náalaya Kàgàwà-ngbɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hirò nɔnzɨya alɛ nɨ́, màrʉ̀ngà ɔ̌ arɨ́ ìndrǔ nábhʉ̌ ròkò alɛ, Kàgàwà náanziya abádhí pbɨ̀ndà inzo tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hirò nɔnzɨya alɛ nɨ́ obhónánga ɔ̀nzɨ ɨ̀ arɨ́ dhu-okú dɔ̀ rɔ̀ ka karávu rɔ̀yá alɛ, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi nɨ’ɨya abádhí tɔ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ndɨrɔ̀, hirò nɔnzɨya nɨ́ nyɨ̌, yà nyɨ̌ nɨ̌ ka karɨ́ dhu nʉ́nɔ, kavu rʉ̀kʉ́, kadʉ̀ kɔ́rɔ́ nzɛ́rɛ dhu-tɨdɔ̀ náwɛ dʉ̀kʉ́ okúdu dɔ̀ rɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nɨ́ nyìlè nyɨ̌, nyǎdʉ̀ òko dhɛ̀dhɛ ɔ̌, nyɨ̌ nyabáya ádrʉ̀ngbǎ mʉ̀kɨ̀mbà nyʉ́ ɔ̀rʉ̀-akpà ɔ̀ nɨ́dhunɨ̌. Wɔ̀ dhu bhěyi tɨ́ nɨ́ ndɨ ka kavù angyi ɨ’ɨ̀ Kàgàwà bhà pbànábí rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ihé-yà nɨ̌: «Nyɨ̌ nɨ́ iko yà adzɨ dɔ̌ alɛ nzínzì ɔ̌. Pbɛ́tʉ̀, iko-òvǔ náapɛ́ ìku, nɨ́ ka kádʉ̀ kàbhʉ ròkyè àdhu nɨ̌ tdɨ́tdɔ̌? Kà kàsʉ̌ rɨ̌ mbǎ àdʉ̀ ɨ̀’ɨ̀ tdɨ́tdɔ̌. Kà rǎdʉ̀ àkǎ koyì iri, kadʉ̀ àmbɛ ɔ̀nánga nótsì dɔ̌ alɛ-pfɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nyɨ̌ nɨ́ ndɨ awáwʉ̀ yà adzɨ dɔ̌ alɛ nzínzì ɔ̌. Pbìrì dɔ̌ ka kɔ́sɨ̀ kɨgɔ̀ náarɨ́ nzɨ̌ ndòru. ");
INSERT INTO niy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ndɨrɔ̀, ka kɨ́nzɨ̌ àdʉ̀ tarà nɔ́bɨ̀, kadʉ̀ àtsìnà ɨ̀tǎ-tsì. Pbɛ́tʉ̀, ka kádʉ̀ kɔ̀bɨ̀, kadʉ̀ ɨ̀lɨnà tarà ʉ̀lɨ̌ ka karɨ́ ɔ̀ná ɔrʉ́ ngari ɔ̌. Ndɨ dhu bhěyi nɨ́ ndɨ kà rǎdʉ̀ ɨdzá rɨ́’ɨ̀ kɔ́rɔ́ alɛ-nyɨ̌nga náwʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nɨ́ ndɨ dhu bhěyi tɨ́, dhu àkǎ fʉ̀kʉ́ awáwʉ̀ ràwʉ̀ kɔ́rɔ́ alɛ-nyɨ̌nga, ndɨ́nɨ̌ abádhí ala tɨ́ ídzì kàsʉ̌kʉ, ’àdʉ̀ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà nɨ́fʉ.» ");
INSERT INTO niy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Àpɛ́ nyɨ̀rɛ̀ nga ma rɨ́rà Músà bhà Ʉyátá mà, pbànábí nʉ́ʉnɔ dhu mànà dhu núgolo. Ma mɨ́rà nzá abádhí núgolo, pbɛ́tʉ̀, ma mɨ́rà ndɨ́nɨ̌ ma mabhʉ̀ tɨ́ ɨ Ʉyátá nʉ́nɔ̀ dhu rɔ̀nzɨ̀ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: òko yà adzɨ mà ɔ̀rʉ̀-akpà mànà nóko rɔ́rɔ̀, atdí andítá-nyɨ̀kpɔ́-tʉ́tʉ̌ngba mà ɨ Ʉyátá ɔ̌ náawíya nzɨ̌, ràrà àhʉ yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nɨ́rɔ̀, atdí alɛ náapɛ atdí akɛkpá Ʉyátá-ngba mà nʉ́kɔ̀ kɔ̀rɨ́ Ʉyátá nzínzì ɔ̌, ndàdʉ̀ dhu ùdhe ngʉ̌kpà alɛ tɔ̀ ròwù kʉ̀kɔ̀ rɔ̌ átɔ̀ ndɨ̀ bhěyi, nɨ́ ndɨ alɛ nɨ’ɨya ndɨ ákɛ̌kpá alɛ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi ɔ̌. Pbɛ́tʉ̀ ɨ Ʉyátá nɨ́fʉ̌ rɨ̌, ndàdʉ̀ dhu ùdhe ngʉ̌kpà alɛ tɔ̀ rɨ̀fʉ ka átɔ̀ ndɨ̀ bhěyi alɛ, nɨ́ ndɨ alɛ nɨ’ɨya ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi ɔ̌ ádrʉ̀ngbǎlɛ. ");
INSERT INTO niy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: nyɨ̌ nyarɔ́nzɨna obhónánga náapɛ́ nzɨ̌ òse Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà tɔ́ obhónánga dɔ̀nǎ, nɨ́ nyɨ̌ nyotsúya nzɨ̌ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Nyɨ̌ nyɨ́rɨ̀ wà abhúkʉ tɔ̀ Kàgàwà ʉyá dhu ndàtɨ: ‹Dhu àkǎ nzá nyohò abvo. Abvo nòhò alɛ nákǎ kɔtdɨ̀ ànyǎna.› ");
INSERT INTO niy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pbɛ́tʉ̀, ma mɨ́ dhu ɔ̀vɔ fʉ̌kʉ̀, matɨ: ɔdhɨ̀nà rɔ̌ àkǒ alɛ, nákǎ kɔtdɨ̀ ànyǎna. Ndɨrɔ̀, ɔdhɨ̀nà nàtɨ̀ kɨ̀dhɔmà tɨ́ alɛ, nákǎ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ rɔ̀tdɨ̀ anya dɔ̀ná. Ndɨrɔ̀, ndɨ alɛ ràtɨ ɔdhɨ̀nà nɨ̌: ‹Ɨnyɨ nɨ́ àrǐtálɛ!› Nɨ́ ndɨ alɛ àkǎ, kobvù yà ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nyɨ nyapɛ́ ɨ̀’ɨ̀ pɛrɛ̀ nábhʉ̌ nyɨ nyɨ́ màzàbahʉ̀ dɔ̌ rɔ̀ Kàgàwà tɔ̀ rɔ́, dhu ràdʉ̀ ìse ʉ̀nʉ́ ányɨ̀rɔ̌ rɔ̀ ìnè nzɛ́rɛ dhu ràrɨ̌’ɨ̀ nzínzìkʉ ɔ̌ adɔ̀nʉ nà, ");
INSERT INTO niy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nɨ́ dhu àkǎ nyʉbhà ndɨ pɛrɛ̀ màzàbahʉ̀-ɔ̀nzɨ̌, nyadʉ̀ nyadu, nyǒwù ndɨ nzínzìkʉ ɔ̌ rɨ́’ɨ̀ dhu nɨ́tɔ̀ angyi adɔ̀nʉ mànà. Wɔ̀ dhu-dzidɔ̌ nɨ́ ndɨ, nyɨ nyádʉ̀ nyadu, nyɨrà pbʉ̀kʉ̀ pɛrɛ̀ nábhʉ Kàgàwà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dhu nà nyɨ̌ nyarɨ́’ɨ̀ nà nzínzìkʉ ɔ̌ ɔdhɨ̀nʉ náapɛ́ àmbɛ àrà dɔ̌ nyɔbhʉ̀, nyǎdʉ̀ òko nyǎmbɛ òwu dɔ̌ atdíkpá ka mànà dhʉ̀wanɨ̀ ɔ̀, nɨ́ dhu àkǎ nyɔnzɨ̀ ɔbɨ, nyɨ̌rɨ̀ nyɨ̌, nyɨ̌tɔ̀ ndɨ dhu, ɨnzá nyɨ̌ nyàpɛ̀ òwu ùvò anya t’ɨ́tdɨ̀ta t’álɛ-ɔ̀nzɨ̌ rɔ́rɔ̀. Ɨ̀mbǎ kɨ̀’ɨ̀ ndɨ dhu bhěyi rɔ̀, kà rǎdʉ̀ nyabhʉ kɔtdɨ̀ ànyǎnʉ, kadʉ̀ nyabhʉ pùrǔsì ròsò nyɨ imbi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀: nyɨ nyɨ́ nzɨ̌ àdʉ̀ àhʉ imbi ɔ̀ rɔ̀ ɨnzá nyɨ nyùbho dʉ̀nʉ́ ka kɔ̀tdɨ̀ dhu rìku kɔ́rɔ́ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Nyɨ̌ nyɨ́rɨ̀ wà yà ka kʉnɔ dhu, katɨ: ‹Dhu àkǎ nzá nyɔnzɨ̀ mʉ̀nyɔ̀nɨ̀.› ");
INSERT INTO niy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pbɛ́tʉ̀ ɨma, ma mátɨna nyɨ̌ nɨ̌: atdí kpatsìbhálɛ náapɛ́ ngǎtsi alɛ-ve dɔ̀ nga nándà, ndàdʉ̀ kǎtdyú nóhò, nɨ́ ndɨ alɛ nɔ́nzɨ̀ wà mʉ̀nyɔ̀nɨ̀ ndɨ̀ tsìbhálɛ nà afína ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɨ́ dhu náapɛ́ ɨ̀’ɨ̀, fangà tɔ́ nyɨ̀kpɔ́nʉ náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ dhu àkǎ nyɨtǎ ka, nyadʉ̀ ìtùnà nyobvù ɨtsɛ rʉ̀nʉ́ rɔ̀. Obhó tɨ́, dhu àkǎ wà nyiwǐ atdí ngbɔ̌nʉ-rɔ̌ngá-ngba, ròsè kɔ́rɔ́ ngbɔ̌nʉ nóbvù ka kɨ́ ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndɨrɔ̀, dhu náapɛ́ ɨ̀’ɨ̀, fangà tɔ́ ɔtsʉ́nʉ náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ dhu àkǎ nyɔtdɨ̀ ka, nyadʉ̀ òbvùnà ɨtsɛ rʉ̀nʉ́ rɔ̀. Obhó tɨ́, dhu àkǎ wà nyiwǐ atdí ngbɔ̌nʉ-rɔ̌ngá-ngba, ròsè kɔ́rɔ́ ngbɔ̌nʉ nóbvù ka kɨ́ ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Ka katɨ átɔ̀: ‹Pbɨ̀ndà tsìbhálɛ nɔ́dhɔ rɨ́ alɛ nákǎ ndàndǐ ʉbhátá tɔ́ bhàrʉwà, ndàdʉ̀ àbhʉnà kà-fɔ́.› ");
INSERT INTO niy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pbɛ́tʉ̀ ɨma, ma mátɨna nyɨ̌ nɨ̌: ‹Atdí alɛ mà náapɛ́ pbɨ̀ndà tsìbhálɛ nɔ́dhɔ ɨnzá nɨ́ mʉ̀nyɔ̀nɨ̀ kɔ̀nzɨ̀nà dhu-okú dɔ̀ rɔ̀ tɨ́, nɨ́ ndɨ alɛ nítsu wà pbɨ̀ndà tsìbhálɛ mʉ̀nyɔ̀nɨ̀ ɔ̀, ndɨ tsìbhálɛ mà rǎdʉ̀ òwu ’ʉ̀mba ngǎtsi kpatsìbhálɛ nà nɨ́dhunɨ̌. Ndɨrɔ̀, ndɨ ɔ̀dhɔ ka kɔ̀dhɔ̀ tsìbhálɛ nà ɨ̀ nʉ̀mbǎ alɛ nádʉ̀ ɨ’ɨ̀ ɨwà mʉ̀nyɔ̀nɨ̀ nɔ̀nzɨ̀ átɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Nyɨ̌ nyɨ́rɨ̀ wà yà abhúkʉ tɔ̀ ka kʉyá dhu, katɨ: ‹Àpɛ́ nyʉ̀tsɔ̌ dhu tɨ̀tɔ̀ dɔ̌, pbɛ́tʉ̀ dhu àkǎ nyɔ̌nzɨ̀ yà Ádrʉ̀ngbǎlɛ Kàgàwà-ɔ̀nzɨ̌ nyɨ̌ nyɔ́tsɔ̀ ɔ̀nzɨ nyɨ̌ nyɔ́nzɨna dhu tɨ́ dhu.› ");
INSERT INTO niy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pbɛ́tʉ̀, ma mátɨna nyɨ̌ nɨ̌: Àpɛ́ nyʉ̀tsɔ̌ dhu akɛkpá màtɨ́. Àpɛ́ nyʉ̀tsɔ̌ dhu ɔ̀rʉ̀-akpà-ɔvɔ̀ rɔ̌ màtɨ́, Kàgàwà náarádɨ dɔ̀ná tombi nɨ́ ndɨ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Àpɛ́ nyʉ̀tsɔ̌ dhu yà adzɨ-ɔvɔ̀ rɔ̌ màtɨ́, Kàgàwà náarɨ́ pfɔ̌na ʉ̀lɨ̌ rɔ́nga nɨ́ ndɨ nɨ́dhunɨ̌. Àpɛ́ nyʉ̀tsɔ̌ dhu Yèrùsàlɛmà tɔ́ kɨgɔ̀-ɔvɔ̀ rɔ̌ màtɨ́, ádrʉ̀ngbǎ Ádrʉ̀ngbǎ kamà bhà kɨgɔ̀ nɨ́ ndɨ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndɨrɔ̀, àpɛ́ nyʉ̀tsɔ̌ dhu dʉ̀kʉ-ɔvɔ̀ rɔ̌ màtɨ́, ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ atdí àyɨ̌-vɛ́-ngba mà nábhʉ rɔ̀tɨ̀, ndɨrɔ̀ ngǎtsi nɨ̌ ròpfò nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Obhó dhu tɨ́ rɨ́’ɨ̀ dhu nákǎ nyǎtɨ̀ obhó dhu tɨ́. Ndɨrɔ̀, ɨ̀nzɨ̌ nɨ́ obhó dhu tɨ́ rɨ́’ɨ̀ dhu nákǎ nyǎtɨ̀ ɨ̀nzɨ̌ nɨ́ obhó dhu tɨ́. Wɔ̀ dhu dɔ̌ ka kísěna ngʉ̌kpà dhu nádʉ̀ ɨ̀’ɨ̀ nzɛ́rɛ alɛ, Pfɔ̀mvɔ bhà rɔ̀ ɨ̀rà dhu.» ");
INSERT INTO niy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̌ nyɨ́rɨ̀ wà yà ka kʉnɔ dhu, katɨ: ‹Alɛ-nyɨ̀kpɔ́ alɛ-nyɨ̀kpɔ́ arì ɔ̌, ndɨrɔ̀ alɛ-kù alɛ-kù arì ɔ̌.› ");
INSERT INTO niy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pbɛ́tʉ̀ ɨma, ma mátɨna nyɨ̌ nɨ̌, dhu ràkǎ nzá nyǔbho nzɛ́rɛ dhu nzɛ́rɛ dhu nɨ̌. Atdí alɛ náapɛ́ ngàngànʉ ɔ̀pbɨ fangà dɔ̀nǎ rɔ̀, nɨ́ dhu àkǎ nyʉgɛ̀rɛ̀ ígù dɔ̀nǎ ngàngànʉ kà rɔ̀pbɨ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Atdí alɛ náapɛ́ ndòzè ndàrà nyɔbhʉ̀ dhʉ̀wanɨ̀ ɔ̀, ndɨ́nɨ̌ ndakɔ̀ tɨ́ rʉ̀nʉ́ sìmisì, nɨ́ dhu àkǎ nyɨwà rʉ̀nʉ́ kotì átɔ̀, nyabhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Atdí alɛ náapɛ́ nyʉtʉ̌ ɔbɨ nɨ̌ nyanɔ̀ dɔ̀ná dhu, nyarà nà atdí kìlòmɛ̌tɛ̀rɛ̀ tɨ́, nɨ́ dhu àkǎ nyanɔ̀ ka, nyarà nà ɔ́yɔ̌ kìlòmɛ̌tɛ̀rɛ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Atdí alɛ náapɛ́ dhu ònzi fʉnʉ́, nɨ́ dhu àkǎ nyabhʉ ndɨ dhu kà tɔ̀. Ndɨrɔ̀, kǎpɛ́ dhu ònzi ndʉ̀wʉ fʉnʉ́, nɨ́ dhu àkǎ nzá nyuvǒ nyɨ ndɨ dhu rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Nyɨ̌ nyɨ́rɨ̀ wà yà ka kʉnɔ dhu átɔ̀, katɨ: ‹Dhu àkǎ nyozè ɔdhɨ̀nʉ, nyadʉ̀ pbʉ̀kʉ̀ òmvǔ nɔ́ndrɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pbɛ́tʉ̀ ɨma, ma mátɨna nyɨ̌ nɨ̌: Dhu àkǎ nyǒzè fʉ̀kʉ́ òmvǔ, nyǎdʉ̀ òwu nyɨ̌tsɔ̀ rɔ̌ rʉ̀kʉ́ arávu alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ndɨ dhu bhěyi nɨ́ ndɨ, nyɨ̌ nyǎdʉ̀ òngo ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà bhà inzo tɨ́. Obhó tɨ́, ka nɨ́ ndɨ adyifɔ̀ nábhʉ̌ arɨ́ rɨ̀kà nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ alɛ mà, ídzì dhu ɔ̀nzɨ arɨ́ alɛ mànà dɔ̌. Ndɨrɔ̀ kǎrɨ́ igye nábhʉ̌ rɨ̀kɔ̌ obhónánga ɔ̀nzɨ arɨ́ alɛ dɔ̌, ɨ̀nzɨ̌ arɨ́ kɔ̀nzɨ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyɨ̌ nyapɛ́ yà nyɨ̌ nózè alɛ kɛ̀lɛ̌ nózè, nɨ́ ádhu Kàgàwà adʉ̀ya àbhʉnà fʉ̌kʉ̀ pɛrɛ̀ tɨ́? Pàratà tɔ́ pbàndɔ́mbɛ́ mà náatɨ́ obhó dhu nɔ́nzɨ átɔ̀ ndɨ dhu bhěyi tɨ́? ");
INSERT INTO niy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ndɨrɔ̀ adɔ́kʉ-tsʉ̌ tɨ́ nyɨ̌ nyɨ́ mʉ̀lɛ̀mbɛ̀ nɔ́ngʉ̀ rɔ̀, ádhu ndɨ ádrʉ̀ngbǎ dhu tɨ́ nyɨ̌ nyarɔ́nzɨna? Ɨnzá Kàgàwà ná’ù alɛ mà náatɨ́ obhó dhu ɔ̀nzɨ ndɨ dhu bhěyi tɨ́ átɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nɨ́, dhu àkǎ nyɨ̌’ɨ̀ mbǎ afátá nà alɛ tɨ́, àdhàdhɨ̀ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbǎkʉ Kàgàwà narɨ́ mbǎ afátá nà alɛ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Nyàndà nga mběyi ɨ̀nzɨ̌ nyɔ̌nzɨ̀ ídzì dhu tɨ́ rɨ́’ɨ̀ dhu ìndrǔ tɔ̀ ìndrǔ-nyɨ̀kpɔ́ ɔ̌ rɔ̀, ndɨ́nɨ̌ ka kala tɨ́ nyɨ̌. Ndɨ dhu bhěyi nyɨ̌ nyapɛ́ kɔ̀nzɨ, nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà rɨ̌ nzɨ̌ àdʉ̀ pɛrɛ̀ núbho fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nɨ́, pɛrɛ̀ nábhʉ̌ nyɨ nyɨ́ nyɔnzɨ̀ ìndrǔ-dzʉ̀nà nɨ̌ rɔ̀, dhu àkǎ nzá nyabhʉ ka ìkǔ ɔ̌, àdhàdhɨ̀ ɔyɔyɔ ɨdàya nà alɛ náarɨ́ kɔ̀nzɨ unduta-dzà ɔ̌ rɔ̀ ndɨrɔ̀ ngʉdhà ɔ̌ rɔ̀ màtɨ́ dhu bhěyi. Abádhí náarɨ́ dhu ɔ̀nzɨ ndɨ dhu bhěyi ndɨ́nɨ̌ ka kɨfʉ tɨ́ ɨ̀. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: abádhí nábà wà fɨ̀yɔ́ mʉ̀kɨ̀mbà angyangyɨ. ");
INSERT INTO niy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pbɛ́tʉ̀ ɨnyɨ, pɛrɛ̀ nábhʉ̌ nyɨ nyɨ́ nyɔnzɨ̀ ìndrǔ-dzʉ̀nà nɨ̌ rɔ̀, dhu àkǎ nzá nyabhʉ ígù tɔ́ ɔtsʉ́nʉ rʉ̀nɨ fangà tɔ́ ɔtsʉ́nʉ rǎbhʉ̌na dhu. ");
INSERT INTO niy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ndɨ dhu bhěyi nɨ́ ndɨ, nyɨ nyàbhʉ pɛrɛ̀ rǎdʉ̀ àdɨ ɔ̀dhʉ̌ ɔ̀. Ndɨrɔ̀, Àbanʉ Kàgàwà, yà ɔ̀dhʉ̌ ɔ̀ dhu nálǎ arɨ́ alɛ, nɨ́ rǎdʉ̀ mʉ̀kɨ̀mbà nábhʉ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Nyɨ̌tsɔ̀ nyɨ̌ nyɨ́ rɔ̀, dhu àkǎ nzá nyɔ̌nzɨ̀ nyɨ̌ ɔyɔyɔ ɨdàya nà alɛ náarɨ́ ’ɔ̀nzɨ dhu bhěyi. ’Ɨ̀tsɔ̀ ɨ̀ ɨ́ rɔ̀, abádhí náarɨ́ ’òzè ’ɨ̀tsɔ̀ ɨ̀ ɔrʉ́ ɨ̀ ìkò rɔ́rɔ̀ unduta-dzà ɔ̌ rɔ̀, ndɨrɔ̀ otu-yàgá ɔ̌ rɔ̀ màtɨ́, ndɨ́nɨ̌ kɔ́rɔ́ alɛ náala tɨ́ ɨ̀. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, abádhí nábà wà fɨ̀yɔ́ mʉ̀kɨ̀mbà. ");
INSERT INTO niy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pbɛ́tʉ̀ ɨnyɨ, nyɨtsɔ̀ nyɨ nyɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, dhu àkǎ nyotsù pbʉ̀kʉ̀ kàluga ɔ̀, nyadyì tsʉ̀nʉ ányɨ̀, nyadʉ̀ nyɨtsɔ̀ yà ányɨ̀ rɨ́’ɨ̀ ɔ̀dhʉ̌ ɔ̀ Àbanʉ Kàgàwà rɔ̌. Nɨ́, ɔ̀dhʉ̌ ɔ̀ nyɨ nyɔ́nzɨna dhu àlǎ arɨ́ ndɨ Àbanʉ Kàgàwà, rǎdʉ̀ pɛrɛ̀ nábhʉ ɨndʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nɨ́, nyɨ̌tsɔ̀ nyɨ̌ nyɨ́ rɔ̀, dhu àkǎ nzá nyʉ̌nɔ̀ ɨ̀mbǎ tɨ̌ya nà ɔtɛ abhɔ, yà ɨnzá Kàgàwà ná’ù alɛ náarɔ́nzɨna dhu bhěyi. Abádhí náarɨ́ ɨnga nɨ́rɛ̀, abhɔ ɨ̀ ɔ̀tɛ̀ rɔ̀ nga ràrɨ̌ ndɨ Kàgàwà rǎdʉ̀ ɨ̀ ʉ́nɔna dhu nɨ́rɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nɨ́, dhu àkǎ nzá nyɔ̌nzɨ̀ nyɨ̌ abádhí bhěyi. Obhó tɨ́, Àbakʉ Kàgàwà nʉ́nɨ wà àkǎ àkǎ fʉ̌kʉ̀ dhu, ɨnzá nyɨ̌ nyàpɛ̀ ndɨ dhu ònzi fɔná rɔ́rɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nɨ́, kànɨ̌ nyɨ̌ nyádʉ̀ nyɨ̌tsɔ̀ tɨ́ dhu: ‹Ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakà Kàgàwǎ, Ábhʉ̌ ɔvɔ̀nʉ rìlè ndɨ̀, ");
INSERT INTO niy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ábhʉ̌ idzi ɔ̀nyʉ nyɨ nyɨ́ dɔ̀ká ɔ̀ná ɨdhɔ ràkǎ, ábhʉ̌ nyɨ nyòzè dhu ròngò ndɔ̀nzɨ̀ yà adzɨ dɔ̌, ɔ̀rʉ̀-akpà ɔ̀ arɨ́ ndɔ̀nzɨ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Íbhò yà bìlǐnganà nyɨ nyaríbhona ɔ̀nyʉ̀ indo fǎkà. ");
INSERT INTO niy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ʉ́bà fàká afátá fǎkà, àdhàdhɨ̀ mǎ marɨ́ dhu nʉ́ba ɔnzɨ̀ká dhu nʉ̀fǎ alɛ tɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndɨrɔ̀ àpɛ́ nyabhʉ̀ pfɔ̀mvɔ rùmvǔ afíka, pbɛ́tʉ̀, ɔ́dɔ mǎ wɔ̀ ndɨ Nzɛ́rɛ alɛ rɔ̌ rɔ̀. Obhó tɨ́, Idzi t’ɔ́nyʉta mà, ádrʉ̀ngbǎnga tɔ́ ɔbɨ mà, ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ mànà nákǎ ɨnyɨ nà tɨ́ dhòdhódhónga nà. Àmɨ̀nà.› ");
INSERT INTO niy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Obhó tɨ́, nyɨ̌ nyapɛ́ dhu nʉ́bà ɔnzɨ̀kʉ́ dhu nʉ̀fǎ alɛ tɔ̀, nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà rǎdʉ̀ dhu nʉ́bà átɔ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pbɛ́tʉ̀, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ dhu nʉ́ba ɔnzɨ̀kʉ́ dhu nʉ̀fǎ alɛ tɔ̀, nɨ́ Àbakʉ Kàgàwà rɨ̌ nzɨ̌ adʉ̀ dhu nʉ́bà átɔ̀ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nyɨ̌ nyʉ̀tsɨ̀ rɔ̀, dhu àkǎ nzá nyǒkò ɨzʉ̀kʉ ɔ̌, ɔyɔyɔ ɨdàya nà alɛ náarɔ́nzɨna dhu bhěyi. Abádhí náarɨ́ nyɨ̀ya wɔ̀yɔ̌ nʉ́gɛ̀rɛ̀, ndɨ́nɨ̌ kɔ́rɔ́ alɛ náala tɨ́ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ ɨ̀ ʉ̀tsɨ̀ dhu. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: abádhí nábà wà fɨ̀yɔ́ mʉ̀kɨ̀mbà angyangyɨ. ");
INSERT INTO niy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pbɛ́tʉ̀ ɨnyɨ, ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nyɨ nyʉ̀tsɨ̀ rɔ̀, dhu-àkǎ nyu’o nyɨ̀nʉ rɨ̀lǎ, nyadʉ̀ ndrùù rɔ́ngʉ akyɛ nútri dʉ̀nʉ rɔ̌ àyɨ̌ ɔ̀, ");
INSERT INTO niy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","akyɛ kɔ́rɔ́ alɛ náalana ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nyɨ nyʉ̀tsɨ̀ dhu nɨ̌. Pbɛ́tʉ̀, Àbanʉ Kàgàwà yà ɔ̀dhʉ̌ ɔ̀ rɨ́’ɨ̀ ányɨ̀, nɨ́ ndɨ àkǎ ndʉ̀nɨ ka. Ndɨ dhu bhěyi nɨ́ ndɨ Àbanʉ Kàgàwà, yà ɔ̀dhʉ̌ ɔ̀ nyɨ nyɔ́nzɨna dhu nálǎ arɨ́, náadʉ̀ya pɛrɛ̀ àbhʉ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Dhu àkǎ nzá nyǔndu ongyéngá-tsʉ̀ fʉ̌kʉ̀ yà adzɨ dɔ̌. Ányɨ̀, akuku mà kéngezé mànà náarɨ́ dhu ɨ̀nzǎ, ndɨrɔ̀ ányɨ̀ ogbotálɛ náarɨ́ ɨdza-tsʉ̀ nʉ́kɔ̌, ’àdʉ̀ ɔ̀yá dhu nʉ́mbà. ");
INSERT INTO niy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pbɛ́tʉ̀, dhu àkǎ nyǔndu ongyéngá-tsʉ̀ fʉ̌kʉ̀ ɔ̀rʉ̀-akpà ɔ̀, yà ɨ̀nzɨ̌ akuku mà kéngezé mànà náarɨ́ dhu ɨ̀nzǎ ɨ, ndɨrɔ̀ ɨ̀nzɨ̌ ogbotálɛ náarɨ́ ɨdza-tsʉ̀ nʉ́kɔ̌, ’àdʉ̀ ɔ̀yá dhu nʉ́mbà ɨ. ");
INSERT INTO niy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Obhó tɨ́, pbʉ̀kʉ̀ ongyéngá náarɨ́’ɨ̀ ɨ nga nɨ́ ndɨ afínʉ rǎdʉ̀ ɨ̀’ɨ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Alɛ-nyɨ̀kpɔ́ nɨ́ alɛ-ngbɔ̀ rɔ̌ tarà. Nɨ́, nyɨ̀kpɔ́nʉ náapɛ́ ɨ̀’ɨ̀ ídzì rɔ̌ rɔ̀, nɨ́ kɔ́rɔ́ ngbɔ̌nʉ rǎdʉ̀ ɨ̀’ɨ̀ awáwʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pbɛ́tʉ̀ nyɨ̀kpɔ́nʉ náapɛ́ ɨ̀’ɨ̀ andɨ nà, nɨ́ kɔ́rɔ́ ngbɔ̌nʉ rǎdʉ̀ ɨ̀’ɨ̀ ɨ́nɔ̀ ɔ̌. Nɨ́rɔ̀, afínʉ ɔ̀ rɨ́’ɨ̀ awáwʉ̀ náapɛ́ òngo ɨ́nɔ̀ tɨ́, nɨ́ ndɨ ɨ́nɔ̌-yà tɨ́ mbǎ àdʉ̀ ɨ̀’ɨ̀ ádrʉ̀ngbǎ nyʉ́?» ");
INSERT INTO niy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ ɔ́yɔ̌ ádrɔ̀drɔ̌ alɛ-kàsʉ̌ nɔ́nzɨ̀ atdíkpá, atdí kàsʉmɨ̀ ɔ̌. Kà rǎdʉ̀ atdí ádrʉ̀ngbǎlɛ nɔ́ndrɔ̀, ndàdʉ̀ ngǎtsi ádrʉ̀ngbǎlɛ nózè. Ndɨrɔ̀, kà rǎdʉ̀ ndàpba atdí alɛ rɔ̌, ndàdʉ̀ ngǎtsi alɛ nɨ́dzɛ̀lɛ̀. Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ Kàgàwà-kàsʉ̌ nɔ́nzɨ̀ atdíkpá yà adzɨ dɔ̌ ònzì-kàsʉ̌ mànà.» ");
INSERT INTO niy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Kɔ̀nɨ̌ wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mátɨna nyɨ̌ nɨ̌: dhu ràkǎ nzá nyǐtǔ afíkʉ fʉ̀kʉ́ ípìrɔ̌nga mà ngbɔ̌kʉ mànà dhu nàndà dhu nɨ̌, nyǎmbɛ àtɨ̀nà dɔ̌: nyɨ̌ ràrɨ̌ àdhu ɔ̀nyʉ, nyɨ̌ ràrɨ̌ àdhu ɔ̀mvʉ̀, ndɨrɔ̀ nyɨ̌ ràrɨ̌ àdhu ʉ̀fɔ̌ rʉ̀kʉ́. Ìndrǔ bhà ípìrɔ̌nga nósè tɨ́ nzá ɔ̀nyʉ̀ dɔ̀nǎ? Ndɨrɔ̀, alɛ-ngbɔ̀ nósè tɨ́ nzá mbɛrʉ̀ dɔ̀nǎ? ");
INSERT INTO niy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nyàndà pɛ́ ɔrʉ́ arángɨlɨ àrɛ̀: abádhí arɨ́ nzɨ̌ ɨnga nóbhì, ndɨrɔ̀ abádhí arɨ́ nzɨ̌ ɔ̀nyʉ̀ nógu. Abádhí arɨ́ nzɨ̌ ɔ̀nyʉ̀-tsʉ̀ mà núndǔ ɔ́ngɔ̀lɨ̌ ɔ̀, pbɛ́tʉ̀ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà náarɨ́ abádhí nóngù. Nɨ́ nyɨ̌, nyɨ̌ nyʉ́dà tɨ́ nzá ɨ àrɛ̀ kɔ́rɔ́? ");
INSERT INTO niy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ádhɨ pbá alɛ ndɨ nzínzìkʉ ɔ̌, wɔ̀ afína ndɨ̀ ndìtǔ abhɔ dhu rǎdʉ̀ ɨdhɔ̀na nɨ́trɔ atdí ɨdhɔ nɨ̌ màtɨ́ yà adzɨ dɔ̌? ");
INSERT INTO niy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ndɨrɔ̀, ádhu nyɨ̌ nyarɨ́ afíkʉ nítǔ rʉ̀kʉ́ nyɨ̌ nyʉ́fɔ̌na dhu nɨ̌ nɨ́? Nyàndà pɛ́ ɨnga ɔ̌ màuwà náarɨ́ ɨ̀nga tɨ́ dhu: abádhí arɨ́ nzɨ̌ kasʉ nɔ́nzɨ, ndɨrɔ̀ abádhí arɨ́ nzɨ̌ mbɛrʉ̀ nódyù. ");
INSERT INTO niy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pbɛ́tʉ̀, ma mátɨna nyɨ̌ nɨ̌: kɔ́rɔ́ pbɨ̀ndà ònzì-ɨ́yà ɔ̌, ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ nyʉ́ mà, náafɔ́ nzá fɨ̀ndá aya rǎkǎ àdhàdhɨ̀ kɔ̌kɔ̀ màuwà nzínzì ɔ̌, atdí màuwà tɔ́ aya nà màtɨ́ atdí mbɛrʉ̀ mà. ");
INSERT INTO niy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɨrɨ́-bɨ̌ nɨ́ indo tɨ́ rɨ́nga ɨnga ɔ̌, kadʉ̀ òbvùnà tsútsǎ tɨ́ kàzʉ ɔ̀ dhu. Pbɛ́tʉ̀, Kàgàwà náarɨ́ abádhí ʉ̀fɔ̌ mběyi nyʉ́. Nɨ́ Kà tɨ́ nzɨ̌ àdʉ̀ nyʉ̌fɔ mběyi nyʉ́ ròsè ɨ ɨrɨ́-bɨ̌ dɔ̀nǎ, nyɨ̌, ákɛ̌ a’uta nà alɛ́? ");
INSERT INTO niy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nɨ́rɔ̀, dhu àkǎ nzá nyǐtǔ afíkʉ nyǎtɨ: ‹Mǎ mɨ́ àdhu ɔ̀nyʉ? Mǎ mɨ́ àdhu ɔ̀mvʉ̀? Ndɨrɔ̀ rɔ̀ká mǎ mɨ́ àdhu ʉ̀fɔ̌?› ");
INSERT INTO niy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Obhó tɨ́, ɨnzá Kàgàwà ná’ù alɛ nɨ́ ɨ afíya nítǔ arɨ́, àmbɛ kɔ́rɔ́ kɔ̌kɔ̀ dhu nɔ́mɛ̀ dɔ̌. Pbɛ́tʉ̀, ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà nʉ́nɨ wà nyɨ̌ ràrɨ̌’ɨ̀ kɔ́rɔ́ ɨ dhu-atdyú nà. ");
INSERT INTO niy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nɨ́ wɛmbɛrɛ̀ tɨ́, dhu àkǎ pɛ́ nyɔ̌mɛ̀ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi, fɨ̀ndá obhónánga mànà. Ndɨrɔ̀ nɨ́ ndɨ, Àbakʉ Kàgàwà rǎdʉ̀ kɔ́rɔ́ dhu-tsí námà àma tɨ́ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ndɨrɔ̀, dhu àkǎ nzá nyǐtǔ afíkʉ tsútsǎnga tɔ́ dhu nɨ̌. Tsútsǎnga tɔ́ dhu nándà nga tsútsǎnga nà tɨ́, ndɨrɔ̀ indonga tɔ́ àpbɛ̀ nákǎ wà indonga nà tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Dhu àkǎ nzá nyɨ̌tdɨ̀ ngʉ̌kpà alɛ-ànyǎ, akyɛ Kàgàwà náadʉ̀ya ànyǎkʉ ɨ̀tdɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Obhó tɨ́, Kàgàwà nɨ́ɨtdɨ̀ya ànyǎkʉ àdhàdhɨ̀ nyɨ̌ nyarɨ́ ìndrǔ-ànyǎ nɨ́tdɨ̀ dhu bhěyi. Ndɨrɔ̀ kǔdhèya dhu fʉ̌kʉ̀ yà nyɨ̌ nyarɨ́ dhu ùdhě ngʉ̌kpà alɛ tɔ̀ ɔ̀nǎ mʉ̀gɛ̀rɛ̀ ɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ádhu nyɨ nyɨ́ ɔdhɨ̀nʉ-nyɨ̀kpɔ́ ɔ̀ ɨ̀tsɨ̀ kɨ̌kɔ̌-ngba kɛ̀lɛ̌ nálǎ, ɨ̀nzɨ̌ nyadʉ̀ yà nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ itsukpó-tsʉ̀dɔ́-ngba nyʉ́ nínè nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nyɨ nyádʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi ɔdhɨ̀nʉ nɨ̌: ‹Ítsè midyi wɔ̀ nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ kɨ̌kɔ̌-ngba›, àzèmbè itsukpó-tsʉ̀dɔ́-ngba nyʉ́ nóongó ɨ̀’ɨ̀ nyɨ̀kpɔ́nʉ ɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nyɨ nɨ́ ɔyɔyɔ ɨdàna nà alɛ. Ípfǒ pɛ́ nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ itsukpó-tsʉ̀dɔ́-ngba angyi, ndɨrɔ̀ nɨ́ ndɨ, nyɨ nyádʉ̀ ɔdhɨ̀nʉ-nyɨ̀kpɔ́ ɔ̀ rɨ́’ɨ̀ kɨ̌kɔ̀ nídyì nyɨ nyɨ́ tɨ́ dhu nála mběyi. ");
INSERT INTO niy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dhu àkǎ nzá nyǎbhʉ Kàgàwà tɔ̀ ka kútri dhu ìtsě tɔ̀, ndɨrɔ̀ dhu àkǎ nzá nyǎwà fʉ̀kʉ́ yɔ̀kpɔ́ àdʉ̀-ɔ̀nzɨ̌, akyɛ abádhí adʉ̀na kà-ɔ̌nga òtsì pfɔ̌ya nɨ̌, ndɨrɔ̀ akyɛ abádhí adʉ̀na ’ʉ̀gɛ̀rɛ̀ ’ʉ̀ka nyɨ̌ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Dhu àkǎ nyǒnzì nyɨ̌ nyɨ́ atdyúna nóho dhu, nɨ́rɔ̀ nɨ́ ndɨ ka kádʉ̀ kàbhʉ fʉ̌kʉ̀. Dhu àkǎ nyɔ̌mɛ̀ nyɨ̌ nyɨ́ atdyúna nóho dhu, nɨ́rɔ̀ nɨ̌ ndɨ, nyɨ̌ nyádʉ̀ kàbà. Ndɨrɔ̀ dhu àkǎ nyɨ̌tdɔ̌ tsǎtsʉ̀, nɨ́rɔ̀ nɨ́ ndɨ, ka kádʉ̀ kàpfò fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dhu nònzì alɛ tɔ̀ nɨ́ ndɨ ka kádʉ̀ ndɨ dhu nábhʉ. Dhu nɔ̀nɛ̀ alɛ nɨ́ ndɨ rǎdʉ̀ ndɨ dhu àbà, ndɨrɔ̀ tsǎtsʉ̀ nɨ́tdɔ̌ alɛ nɨ́ ndɨ, ka kádʉ̀ kàpfò fɨ̌ndà. ");
INSERT INTO niy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ádhɨ pbá alɛ ndɨ nzínzìkʉ ɔ̌ rádʉ̀ odu àbhʉ pbɨ̀ ɨngba tɔ̀, mʉ̀gatì kònzì fɔná rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ndɨrɔ̀, ádhɨ pbá alɛ ndɨ ɨ̀bhɛ̀ pbɨ̀ ɨngba ònzì fɔná rɔ̀ rǎdʉ̀ osu àbhʉ kà tɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyɨ̌ nyʉ́, nzɛ́rɛ alɛ tɨ́rɔ̀, nyɨ̌ nyarɨ́ ídzì dhu núbhǒ fʉ̀kʉ́ inzo tɔ̀. Nɨ́, ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà rǎdʉ̀ àdɨ ɨ̀ngbǎ dhu bhěyi ɨnzá ndɨ̀ ndàbhʉ fɔná ka kònzì ídzì dhu ɨ dhu nònzì fɔná alɛ tɔ̀ rɔ́rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dhu àkǎ nyɔ̌nzɨ̀ ídzì dhu ngʉ̌kpà alɛ rɔ̌, àdhàdhɨ̀ nyɨ̌ nyòzè abádhí rɔ̀nzɨ̀ ka rʉ̀kʉ́ dhu bhěyi. Wɔ̀rɨ́ nɨ́ ndɨ Músà bhà Ʉyátá mà, Kàgàwà bhà pbànábí náandí dhu mànà nʉ́ʉnɔ dhu.» ");
INSERT INTO niy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Dhu àkǎ nyǒtsù ndɨ̀ nɨ́pbɔ̌ tsǎtsʉ̀ ɔ̌. Obhó tɨ́, yà ìndrǔ bhà ípìrɔ̌nga rǎwǐ dhòdhódhónga nà ɨ ka kótsù ɔ̀ná tsǎtsʉ̀ rɨ̌’ɨ̀ ádrʉ̀ngbǎ nyʉ́, ányɨ̀ rárà otu ràdʉ̀ ɨ̀’ɨ̀ íhǔ nyʉ́. Ndɨrɔ̀ ndɨ tsǎtsʉ̀ ɔ̌ rótsù, ’àdʉ̀ òwu ányɨ̀ alɛ náarádʉ̀ ɨ̀’ɨ̀ ibí nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pbɛ́tʉ̀, dhòdhódhónga tɔ́ ípìrɔ̌nga nábà ka kɨ́ ɨ, ka kótsù ɔ̀ná tsǎtsʉ̀ narɨ́ ndɨ̀ nɨ́pbɔ̌ tsǎtsʉ̀, ányɨ̀ rárà otu ràdʉ̀ ɨ̀’ɨ̀ ákɛ̌kpá otú-ngba nyʉ́. Ndɨrɔ̀, ndɨ tsǎtsʉ̀ àlǎ rɨ́, ’òtsù ɔ̀ná, ’àdʉ̀ òwu ndɨ otu ɔ̌ alɛ náarádʉ̀ ɨ̀’ɨ̀ ngúfe nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Nyɔ̀dɔ nyɨ̌ mběyi tɨ̀tɔ̀ tɔ́ pbànábí rɔ̌ rɔ̀. Abádhí náarítsù nzínzìkʉ ɔ̌ tàmà-ndɨ̀ ɨ̀ ʉ̀fɔ̌ rɔ̀yá rɔ́rɔ̀, pbɛ́tʉ̀ afíya ɔ̀nǎ rɔ̀ ’àdʉ̀ ɨ̀’ɨ̀ ɔ̀rɔ̌rʉ̀ tsamangɛ̀rɛ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nyɨ̌ nyádʉ̀ abádhí nʉ́nɨ fɨ̌yɔ́ nzɛ́rɛ mʉ̀tsɔ rɔ̌. Vǐnyò-kpɔ̌ nɔ́pɛ̀ ka tɨ́ àdʉ̀ ɔ̀pɛ̀ okpèna nà itsu dɔ̌? Ndɨrɔ̀ mùtinì-kpɔ̌ nɔ́pɛ̀ ka tɨ́ àdʉ̀ ɔ̀pɛ̀ ɨlɛ́ dɔ̌? ");
INSERT INTO niy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kɔ́rɔ́ ídzì itsu-tɨdɔ̀ náarɔ́dhɨna nɨ́ ídzì itsu-kpɔ̌. Pbɛ́tʉ̀ nzɛ́rɛ itsu-tɨdɔ̀ náarɔ́dhɨna nɨ́ nzɛ́rɛ itsu-kpɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ídzì itsu-tɨdɔ̀ rɨ̌ nzɨ̌ àdʉ̀ nzɛ́rɛ itsu-kpɔ̌ nɔ́dhɨ̀, ndɨrɔ̀ nzɛ́rɛ itsu-tɨdɔ̀ rɨ̌ nzɨ̌ àdʉ̀ ídzì itsu-kpɔ̌ nɔ́dhɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kɔ́rɔ́ itsu, yà ɨ̀nzɨ̌ arɨ́ ídzì itsu-kpɔ̌ nɔ́dhɨ, nʉ́kɛ́rɛ̌ ka karɨ́ kawà kàzʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ nyádʉ̀ tɨ̀tɔ̀ tɔ̀ pbànábí nʉ́nɨ fɨ̌yɔ́ nzɛ́rɛ mʉ̀tsɔ rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Ɨ̀nzɨ̌ nɨ́ kɔ́rɔ́ alɛ, yà mɨtdɛ̀ arɨ́ ’àmbɛ àtɨ̀nà dɔ̌: Ádrʉ̀ngbǎlɛ, Ádrʉ̀ngbǎlɛ́, ɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi ɔ̀ otsúya, pbɛ́tʉ̀ ányɨ̀ otsúya alɛ nɨ́ kǎkà ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà ózè dhu nɔ́nzɨ arɨ́ alɛ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ndɨ nɨ́nganɨ́, ábhɔ̌ alɛ nóowuya àtɨ̀nà rɔ̌ ma nɨ̌: ‹Ádrʉ̀ngbǎlɛ, Ádrʉ̀ngbǎlɛ́! Tɨ́ obhó mǎ ndɨ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ mǎ mʉnɔ ìndrǔ tɔ̀ ɔvɔ̀nʉ rɔ̌? Tɨ́ obhó mǎ ndɨ nzɛ́rɛ-alafí mǎ mipfo ìndrǔ ɔ̀ rɔ̀ ɔvɔ̀nʉ rɔ̌? Ndɨrɔ̀ tɨ́ obhó mǎ ndɨ mǎ manzɨ̀ ábhɔ̌ wɨwɨ̀ nyʉ́ ɔvɔ̀nʉ rɔ̌?› ");
INSERT INTO niy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nɨ́rɔ̀ nɨ́ ndɨ ma maraya dhu ɔ̀vɔ̀ rɔ̌ kpangba abádhí tɔ̀ matɨ: ‹Ɨnzá ma mʉ́nɨ nyɨ̌ akɛkpá màtɨ́, nyìndrǐ nyɨ̌ ɨtsɛ tɨdú rɔ̀, nyɨ̌ nzɛ́rɛnga ɔ̀nzɨ arɨ́ alɛ tɨ́rɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kʉ̀tsa ndɨ̀ ndɨ́ dɔ̀ná rɔ̀ nɨ̌, Yěsù adʉ̀ àtɨ̀nà: «Yà ma mʉ̀nɔ̀ dhu nɨ́rɨ rɨ́, ndàdʉ̀ ɔ̀nzɨ̀nà alɛ, nɨ́ rɨ̌ ndɨ̀lɨ̌ nyɨ̀kpɔ́na ótdyù alɛ, yà bhalabhala dɔ̌ pbɨ̀ndà ɨdza narʉ̀ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Igye nɨ́ɨkɔ́, ɨdha rùtǔ nɨ̌. Nɨ́ igye-dha náakpà ndɨ ɨdza-pfɔ̀, awɛ ràdʉ̀ òpili ɔbɨ nyʉ́ nà ndɨ ɨdza rɔ̌. Pbɛ́tʉ̀, ndɨ ɨdza náadʉ̀ nzá ndàdrù, bhalabhala dɔ̌ ka karʉ̀ kà-pfɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pbɛ́tʉ̀, yà ma mʉ̀nɔ̀ dhu nɨ́rɨ rɨ́ ɨ̀nzɨ̌ ndàdʉ̀ ɔ̀nzɨ̀nà alɛ, nɨ́ rɨ̌ ndɨ̀lɨ̌ nyɨ̀kpɔ́na ɔ̌ ìwǐ nà alɛ, yà ɔsɔkpɔ́ dɔ̌ pbɨ̀ndà ɨdza nasɨ̀ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Igye nɨ́ɨkɔ́, ɨdha rùtǔ nɨ̌. Nɨ́ igye-dha náakpà ndɨ ɨdza-pfɔ̀, awɛ ràdʉ̀ òpili ɔbɨ nyʉ́ nà ndɨ ɨdza rɔ̌. Nɨ́ ndɨ ɨdza náadrù ndɨ̀ drùù!» ");
INSERT INTO niy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yěsù níitdègu ihé-yà tɔ̀ ndɨ̀ ndùbhi ùdhenà rɔ̌, dhu t’údheta nɨ́tɔ, nɨ́ ɨdhɔ nʉ́ʉkɔ ɨ ihé-yà kà rɨ̌ dhu núdhě fɨ̌yɔ̀ tɨ́ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Obhó tɨ́, kàbhà dhu t’údheta nɨ́ɨ’ɨ̀ mbǎ àdhàdhɨ̀ Músà bhà Ʉyátá tɔ́ màlímó tɔ́ dhu t’údheta bhěyi, ndɨrɔ̀ kǎránà dhu núdhe rɔ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yěsù níitdègu àwǔ pbìrì dɔ̀ rɔ̀, nɨ́ ihé-yà adʉ̀ òwu kɔ̌wù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nɨ́rɔ̀ nɨ́ ndɨ kɨ́kɨ́ nà atdí alɛ nɨ́ɨtɔ ndɨ̀, ndìtsì ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, nyɨ nyòzè ka nɨ̌, dhu ɔ̀fɔ̀ nga nyɨgʉ̌ ma.» ");
INSERT INTO niy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nɨ́ Yěsù agba ɔtsʉ́na ndàpbàlǎ kà-ngbɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨwà ma mòzè wɔ̀ nyɨ nyʉ̀nɔ̀ dhu. Nɨ́ ɔ́gʉ̀!» Nɨ́ ányɨ̀ rɔ̌ rɔ̀ tɨ́, wɔ̀rɨ́ alɛ-rɔ̌ kɨ́kɨ́ náadʉ̀ ɔ̀gʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wɔ̀ dhu-dzidɔ̌, Yěsù àdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ́rɨ dhu mběyi! Àpɛ́ nyʉnɔ wɔ̀ dhu atdí alɛ tɔ̀ màtɨ́. Pbɛ́tʉ̀, árà nyɨtɛ̀ nyɨ nyɨ̀lɨ nyɨ tɨ́ dhu pbàkùhánɨ́ tɔ̀. Ndɨrɔ̀, nyádʉ̀ nyabhʉ̀ yà Músà bhà Ʉyátá nʉ́ʉnɔ pɛrɛ̀ Kàgàwà tɔ̀, ndɨ́nɨ̌ ɨwà nyɨ nyɔ̀gʉ̀ dhu navì tɨ́ kɔ́rɔ́ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kàpɛ̀rnàwumù tɔ̀ kɨgɔ̀ ɔ̀ Yěsù rǒtsù ɔ̀ná kàsʉmɨ̀ ɔ̌, Pbàrɔ́má tɔ́ pbìrì ɔ̌, atdí mɨyà pbànówí dɔ̌ atdí ádrʉ̀ngbǎlɛ nɨ́ɨra Yěsù-tɨ’ɔ̀. Kǎdʉ̀ ndɨ̀tsɔ̀ kà-rɔ̌, ndònzì mʉ̀dzʉ̀nà fɔná, ");
INSERT INTO niy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ndàtɨ: «Ádrʉ̀ngbǎlɛ́, pbàkà kasʉtálɛ rɨ̌’ɨ̀ ara dɔ̌ ndɨ̀ ndàyi ɨdzá rɔ́. Kà-ngbɔ̀ nʉ́vɛ wà, nɨ́ kà rǎndɨ atdídɔ̌ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Àrà ma márà pbʉ̀kʉ̀, madʉ̀ kɨ̀gʉ.» ");
INSERT INTO niy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pbɛ́tʉ̀, wɔ̀ pbànówí tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, dhu-àkǎ nzá nyarà àhʉ pbàkà, ɨnzá ma mɨ̀lɨ ma nyɨ nyádʉ̀ òtsù pbɨ̀ ɨdza alɛ bhěyi nɨ́dhunɨ̌. Pbɛ́tʉ̀, órì atdí dhú-ngba kɛ̀lɛ̌, nɨ́ pbàkà kasʉtálɛ rǎdʉ̀ ɔ̀gʉ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ɨma nyʉ́, yà ma mɨ́’ɨ̀ ɨrɔ́ rɔ̀, ma mɨ́’ɨ̀ ìnè dùdu-tsírɔ́ ádrɔ̀drɔ̌ alɛ nà, ndɨrɔ̀ ma mɨ́’ɨ̀ ìnè ma marúvǐna pbànówí nà. Ma mapɛ́ àtɨna atdí mùnowì nɨ̌: ‹Árà ndǎlʉ̀!›, nɨ́ kà rǎdʉ̀ àrà ányɨ̀. Ma mapɛ́ àtɨna ngǎtsi mùnowì nɨ̌: ‹Ɨ́rà àzú!› Nɨ́ ka rǎdʉ̀ ɨ̀rà. Ndɨrɔ̀ ma mapɛ́ àtɨna pbàkà kasʉtálɛ nɨ̌: ‹Ɔ́nzɨ yà dhu!› Nɨ́ kà rǎdʉ̀ ndɨ dhu ɔ̀nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nɨ́ wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ nʉ́nɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, ɨdhɔ nʉ́ʉkɔ Yěsù atdídɔ̌. Nɨ́ kǎdʉ̀ àtɨ̀nà owùna ɔ̌ rúbhi ìwu rɔ̌ alɛ nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ̀ fʉ̌kʉ̀. Ɨnzá ma màpɛ̀ yà dhu bhěyi a’uta-tɨdɔ̀ nà alɛ nálǎ atdí màtɨ́ Pbàìsràyélí tɔ̀ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nɨ́ ma mátɨna kpangba nyɨ̌ nɨ̌, ábhɔ̌ alɛ nyʉ́ níiwúya adyifɔ̀ náarɨ́ ndɨ̀tɔ ɨnǎ rɔ̀ màtɨ́ ndɨrɔ̀ adyifɔ̀ náarótsù ɨnǎ rɔ̀ màtɨ́, àdʉ̀ dhu ɔ̀nyʉ̀ atdíkpá Àbràhamʉ̀ mà, Ìsakà mà, Yàkɔbhɔ̀ mànà, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pbɛ́tʉ̀, wɔ̀ ndɨ̀ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi ɔ̌ àkǎnà ’òkò alɛ nyʉ́ nɨ́ ka kipfoya, kawà iri ɨ́nɔ̀ ɔ̀. Ányɨ̀ nɨ’ɨya ɔdzɨ mà, alɛ-kù t’átrita mànà.» ");
INSERT INTO niy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù àdʉ̀ àtɨ̀nà wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ nɨ̌: «Árà pbʉ̀kʉ̀! Wɔ̀ nyɨ nyà’ù ndɔ̀nzɨ̀ rádʉ̀ dhu tɨ́ dhu, nákǎ ndɔ̀nzɨ̀ ndɨ̀ ɨndʉ̀.» Nɨ́ wɔ̀ dhu Yěsù nʉ́nɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌ tɨ́, wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ bhà kasʉtálɛ náadʉ̀ ɔ̀gʉ̀ dòtsí. ");
INSERT INTO niy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wɔ̀ dhu-dzidɔ̌, Yěsù arà Pɛ́tɛrʉ̀ bhà. Nɨ́ ɨdza ndɨ̀ ndòtsù rɔ̀, kǎtù Pɛ́tɛrʉ̀ bhà agʉna-àyi ara dɔ̌ àyi rɔ́, atdídɔ̌ andɨ àbhʉ kàzʉ rʉ̀tɔ̀ ndɨ̀ ɔ̀na nǎ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nɨ́ Yěsù apbálá kɔ̌tsʉ́-ngbɔ̀, kà ràdʉ̀ ɔ̀gʉ̀ atdídɔ̌. Nɨ́ kǎdʉ̀ ndɨ̀và, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀bhɔ̀lɔ̀ ɔ̀nyʉ̀ Yěsù tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pbɨ́tsɔ̀ngánǎ, ka kʉmba ábhɔ̌ alɛ yà nzɛ́rɛ-alafí nà arɨ́’ɨ̀ ɔ̀yà, kiwǔ nà Yěsù-tɨ’ɔ̀. Nɨ́ Yěsù náaránà nzɛ́rɛ-alafí nípfo rɔ̌ abádhí ɔ̀ rɔ̀ ɔ̀tɛ̌na nɨ̌ tɨ́, ndàdʉ̀ andɨ nà alɛ nɨ́gʉ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ndɨ dhu bhěyi nɨ́ ndɨ, yà Kàgàwà bhà nabì Ìsayà nʉ́ʉnɔ dhu náaká. Kǎtɨ: «Kǐtdu àlɛ̌ tɔ́ ivívínga, ndàdʉ̀ àlɛ̌ rɔ̌ andɨ tɔ́ ìtǔnga nánɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yěsù níitdègu ihé-yà nálǎ ngbɔ̌na nàkpɔ̀rɔ̀ rɔ́, nɨ́ kǎdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kàda rɛ̀rʉ̀-adzè.» ");
INSERT INTO niy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nɨ́rɔ̀ nɨ́ ndɨ Músà bhà Ʉyátá tɔ́ atdí màlimò náandrì Yěsù-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Màlimǒ, ma móngo ùbhi owùnʉ ɔ̌ kɔ́rɔ́ ngari ɔ̌ nyɨ nyúbhi ɨ nanǎ.» ");
INSERT INTO niy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ayíwě mà náarɨ́ ìnè bhǔya nà, ndɨrɔ̀ yà ɔrʉ́ arángɨlɨ àrɛ̀ mà náarɨ́’ɨ̀ ìnè ɨdzàya nà. Pbɛ́tʉ̀, Ìndrǔ t’ídhùnà rɨ̌ ndɔ̀kɔ̀, ndɨ̀lɨ dɔ̀na obvò rɔ́nga mà náarɨ́’ɨ̀ mbǎ.» ");
INSERT INTO niy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ndɨrɔ̀, kàbhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ náatɨ kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, ítsè mara mɔtdʉ́ pɛ́ àbadu angyi.» ");
INSERT INTO niy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨ́rà owù-du ɔ̌, ʉ́bhà kɔ̌kɔ̀ abvo rʉ̀tdʉ̌ fɨ̀yɔ́ abvo.» ");
INSERT INTO niy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yěsù níitdègu ùpo ibhú ɔ̀, nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ ùpo átɔ̀ kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nɨ́ kòmbómbí tɨ́, ádrʉ̀ngbǎ àpùpú náapɛ̀ ndòpìlì atdídɔ̌ rɛ̀rʉ̀ dɔ̌, mʉ̀kʉrà ràdʉ̀ ’ɔ̀pɛ̀ ’àwà ɨ̀ ibhú ɔ̀. Pbɛ́tʉ̀, Yěsù náadʉ̀ ɨ̀’ɨ̀ ɔ̀dhɔ̀ ndɨ̀ ndɔ̀dhɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nɨ́ kàbhà ábhàlɨ̌ náandrì kà-tɨ’ɔ̀, ’ɨ̀nga ka ɨdhɔ ɔ̀ rɔ̀, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, ɨ́gʉ̌ àlɛ̌! Kànɨ̌ àlɛ̌ kʉ́vɛ!» ");
INSERT INTO niy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ádhu nyɨ̌ nyɨ́ ɔdɔ ɔ̀nzɨ nɨ̌? Nyɨ̌ nɨ́ ákɛ̌ a’uta nà alɛ!» Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ ndɨ̀và ndìdè, ndàdʉ̀ ɔ̀tɛ ɔrʉ́ tǔna nyʉ́ nà awɛ mà, rɛ̀rʉ̀ ɔ̌ ɨdha mànà nɨ̌, ɨnga ràdʉ̀ ɨ̀nɛ̀ bhìì. ");
INSERT INTO niy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɨdhɔ nʉ́ʉkɔ ábhàlɨ̌ atdídɔ̌, ràdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ nzínzì yà ɔ̌ ’àmbɛ àtɨ̀nà dɔ̌: «Ɨ́ngbǎgà alɛ-tɨdɔ̀ yà, awɛ mà, rɛ̀rʉ̀ ɔ̌ ɨdha mànà dhu náarɨ́ tsʉ̀ná dhu nɨ́rɨ?» ");
INSERT INTO niy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wɔ̀ dhu-dzidɔ̌, Yěsù níitdègu àrà àhʉ rɛ̀rʉ̀-adzè, Pbàgɛ̀rasɨ̀ tɔ́ pbìrì ɔ̀, nɨ́ ɔ́yɔ̌ alɛ yà nzɛ́rɛ-alafí nà arɨ́’ɨ̀ ɔ̀yà, núuvò yà ìndrǔ ʉ̀tdʉ̌ ka karɨ́ ɔ̀ná ngari ɔ̀ rɔ̀, ’ìwǔ Yěsù-tɨ’ɔ̀. Ɨ̀ alɛ nɨ’ɨ̀ atdídɔ̌ arɨ́ ɔ̀rʉ̀ alɛ, ɨ̀nzɨ̌ atdí alɛ mà ràdʉ̀ àrà ndòzè rɔ̌ ndʉ̀dà ndɨ ngari ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nɨ́ abádhí adʉ̀ òkù, ’àtɨ Yěsù nɨ̌: «Ádhu nyɨ nyòzè mǎ nà Kàgàwà t’Ídhùnǎ? Nyɨ nyɨ̀rà tɨ́ ɨrɔ́ ndɨ́nɨ̌ nyavù tɨ́ rɔ̀ká angyangyɨ, àdɨ̌ ndɨ avuta-ɨdhɔ̀ nádɨ rɔ́rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, àdʉ̀ tɔ́ ádrʉ̀ngbǎ màhò nɨ́ɨ’ɨ̀ ɨtsɛta abádhí tɨ́ rɔ̀, ànyʉ̌ ɨ̀ ányʉ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nɨ́ kɔ̌kɔ̀ alɛ ɔ̀ rɨ́’ɨ̀ nzɛ́rɛ-alafí nɨ́ɨtsɔ̀ ɨ̀ Yěsù rɔ̌, ’àtɨ: «Nyɨ nyapɛ́ nyozè nyipfo mǎ kǎkà alɛ ɔ̀ rɔ̀, nɨ́ óvì mǎ mǒwù òtsù ndǎkà àdʉ̀ tɔ́ màhò ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu ányɨ̀.» Nɨ́ nzɛ́rɛ-alafí núuvò kɔ̌kɔ̀ ɔ́yɔ̌ alɛ ɔ̀ rɔ̀, ’àdʉ̀ òwu òtsù kɔ̌kɔ̀ àdʉ̀ ɔ̀. Ányɨ̀rɔ̌ rɔ̀ tɨ́, kɔ̀rɨ́ àdʉ̀ tɔ́ màhò náadrú pbìrì ɔngɔ̀ rɔ̌ rɔ̀, ɨ̀ rʉ̀pbà ɨ̀ rɛ̀rʉ̀ ɔ̀, ’àdʉ̀ ʉ̀vɛ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndɨrɔ̀, ɨ àdʉ̀ nʉ́ndà rɔ̌ rúbhi alɛ náatsè ɔyɨ nà kɨgɔ̀ ɔ̀. Ányɨ̀ abádhí náawɛ wɔ̀ ɨ nɔ̀nzɨ̀ dhu tɔ́ màkʉ̌rʉ̀, kɔ̌kɔ̀ nzɛ́rɛ-alafí nà ɔ́yɔ̌ alɛ-rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu mànà kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nɨ́ kɨgɔ̀ ɔ̌ alɛ nɨ́ɨvà ɨ̀ kɔ́rɔ́, ɨ̀ rìwǔ Yěsù-tɨ’ɔ̀. Nɨ́ Yěsù ɨ̀ àla rɔ̀, abádhí náadʉ̀ Yěsù nónzì rɨ̀và ndɨ̀ ndàrà fɨ̀yɔ́ pbìrì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yěsù níitdègu ùpo ibhú ɔ̀, nɨ́ kǎdà rɛ̀rʉ̀-adzè, ndàdʉ̀ àrà fɨ̌yɔ́ kɨgɔ̀ nyʉ́ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nɨ́ ányɨ̀ kàrà àhʉ rɔ̀, ka kiwú ngbɔ̌na ʉ́vɛ atdí alɛ nà kà-tɨ’ɔ̀ ótdù dɔ̌ ka kànɔ̀ rɔ́rɔ̀. Nɨ́ abádhí tɔ́ a’uta ndɨ̀ ndàla rɔ̀, Yěsù náatɨ wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: «Ótù afínʉ pbànɨ̌ngbá! Pbʉ̀kʉ̀ nzɛ́rɛnga nʉ́bà wà ndɨ̀!» ");
INSERT INTO niy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nɨ́rɔ̀ nɨ́ ndɨ ányɨ̀rɔ̌ ɨ̀’ɨ̀ Músà bhà Ʉyátá tɔ́ ngúfe màlímó náatɛ̀ nzínzìya ɔ̌, ’àtɨ: «Wɔ̀rɨ́ alɛ rɨ̌ dhu nʉ́nɔ nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌!» ");
INSERT INTO niy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yěsù níitdègu abádhí tɔ́ ɨrɛ̀ta nʉ́nɨ̌, nɨ́ kǐvú dhu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɨ́’ɨ̀ kɔ̀rɨ́ nzɛ́rɛ ɨrɛ̀ta nà afíkʉ ɔ̀ nɨ́? ");
INSERT INTO niy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɨsɔ́ rɔ́’ɔ dhu nɨ́ ɨ̀ngbǎgà? Tɨ́ katɨ: ‹Pbʉ̀kʉ̀ nzɛ́rɛnga nʉ́bà wà ndɨ̀›, ndɨrɔ̀, tɨ́ katɨ: ‹Ɨ́và nyɨ nyubhi?› ");
INSERT INTO niy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma mòzè nyʉ̌nɨ dhu, ìnè Ìndrǔ t’ídhùnà ràrɨ̌’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà ndʉ̀bà ìndrǔ bhà nzɛ́rɛnga yàrɨ́ adzɨ dɔ̌.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: «Ɨ́và nyɨ, nyitdù pbʉ̀kʉ̀ ótdù, nyadʉ̀ àrà pbʉ̀kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nɨ́ wɔ̀ alɛ adʉ̀ ndɨ̀và ndìdè, ndàdʉ̀ àrà pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nɨ́ wɔ̀rɨ́ dhu ɨ̀ àla rɔ̀, ɔdɔ nɨ́ɨsɨ́ ʉrɔ́ ɨ̀’ɨ̀ ihé-yà ɔ̀. Nɨ́ abádhí adʉ̀ Kàgàwà nɨ́fʉ wɔ̀ dhu bhěyi ádrʉ̀ngbǎnga tɔ́ ɔbɨ kǐbhò ìndrǔ tɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yěsù níitdègu ndɨ̀và wɔ̀ ndɨ̀ ndɨ̀’ɨ̀ rɔ́rɔ̀, nɨ́ ʉ̀da ndɨ̀ ndʉ́da rɔ́rɔ̀, kǎla Màtayò tɨ́ kátɨna atdí alɛ pàratà nʉ́fɔ̌ ka karɨ́ ɔ̀ná ɨdza ɔ̌ àdɨ rɔ́. Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ́rà owùdu ɔ̌.» Nɨ́ Màtayò adʉ̀ ndɨ̀và ányɨ̀rɔ̌ rɔ̀ tɨ́, ndàrà kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wɔ̀ dhu lutɨ̀nǎ, Yěsù adʉ̀ àrà dhu ɔ̀nyʉ̀ Màtayò bhà ɨdza. Nɨ́ Yèsù mà pbɨ̀ndà ábhàlɨ̌ mànà rɨ̌ ɔ̀nyʉ̀ ɔ̀nyʉ ányɨ̀-dzá rɔ̀, ábhɔ̌ ngʉ̌kpà alɛ níiwú dhu ɔ̀nyʉ̀ atdíkpá abádhí mànà. Ɨ alɛ nɨ’ɨ̀ pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ mà, nzɛ́rɛ fɨ̌yɔ́ mʉ̀tsɔ nà ngʉ̌kpà alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nɨ́ Pbàfàrìsáyó níitdègu wɔ̀ dhu nálǎ, nɨ́ abádhí náadʉ̀ dhu ìvu Yěsù bhà ábhàlɨ̌-tsʉ̌ ’àtɨ: «Ádhu fʉ̀kʉ́ màlimò rɨ̌ dhu ɔ̀nyʉ pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ mànà, ndɨrɔ̀ nzɛ́rɛ fɨ̌yɔ́ mʉ̀tsɔ nà alɛ mànà nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù adʉ̀ dhu ɔ̀vɔ̀ kpangba abádhí tɔ̀ ndàtɨ: «Ɨ̀mbǎ rɨ́’ɨ̀ andɨ nà alɛ náarɨ́ nzɨ̌ mʉ̀ngangà-atdyú nóho, pbɛ́tʉ̀ andɨ nà rɨ́’ɨ̀ alɛ kɛ̀lɛ̌ nɨ́ ndɨ mʉ̀ngangà-atdyú nóho arɨ́. ");
INSERT INTO niy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nyòwu nyɔ̀mɛ pɛ́ Kàgàwà bhà bhǔkù ɔ̀ ka kandí dhu-tɨ̀. Ndɨ andítá rǎtɨna: ‹Ma mózè dhu nɨ́ ìndrǔ dɔ̌ ka kɨ́ ɨzʉ àbà dhu, ɨ̀nzɨ̌ nɨ́ ɨ̀zǎ tɔ́ pɛrɛ̀ núbhǒ ka kɨ́ idù dhu.› Obhó tɨ́, ma mɨ́rà nzá obhónángatálɛ alɛ núnzì, pbɛ́tʉ̀ mà mɨ́rà nzɛ́rɛngatálɛ núnzì.» ");
INSERT INTO niy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wɔ̀ dhu-dzidɔ̌, bàtizò nubhónà Yùwanɨ̀ bhà ábhàlɨ̌ níiwú Yěsù-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Ádhu mǎ’ɨ, Pbàfàrìsáyó mànà, mǎ marɨ́ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ bìlǐnganà, ɨ̀nzɨ̌ pbʉ̀kʉ̀ ábhàlɨ̌ ràdʉ̀ kʉ̀tsɨ̀ átɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyɨ̀rɛ̀ tɨ́ ɨnga, àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀ ìwǔ alɛ ràrǎdʉ̀ òko ɨzʉ̀ya ɔ̌, àzèmbè ìnè akpa-tsi rɨ̌’ɨ̀ nzínzìya ɔ̌ rɔ́rɔ̀? Ɨ̀nzɨ̌ akɛkpá màtɨ́. Pbɛ́tʉ̀, atdí ɨdhɔ nɨ́ɨ’ɨya ìnè, yà akpa-tsi nódyì ka kɨ́ ɔ̀ná kowù nà abádhí-nzínzì ɔ̌ rɔ̀. Ndɨ ɨdhɔ-ɔ̌nga nɨ́ ndɨ abádhí adʉ̀ya ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ ngoyì-ɔwʉ́tá tɔ́ kɛ̀lɛ̀mʉ̀ nápba mbɛrʉ̀-ayɨ́ ɔ̌. Ndɨ dhu bhěyi kʉ̀pbǎ ka rɔ̀, ndɨ kɛ̀lɛ̀mʉ̀ rǎdʉ̀ ndɨ mbɛrʉ̀-ayɨ́-ɔ̌nga ʉ̀dha rʉ̀fà ndɨ̀, ndɨ ʉfàta-bhu rǎdʉ̀ àhʉ ádrʉ̀ngbǎ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ndɨrɔ̀, ɨ̀nzɨ̌ ka kádʉ̀ dɨ̀vayì-ɔwʉ́tá nʉ́dhɔ kàmʉdzɛ̀-ayɨ́ ɔ̀. Ndɨ dhu bhěyi ka kʉ̀dhɔ ka rɔ̀, ndɨ dɨ̀vayì-ɔwʉ́tá rǎdʉ̀ ɨ̀vʉ̀ kàmʉdzɛ̀-ayɨ́ ɔ̀, ràdʉ̀ ndɨ kàmʉdzɛ̀-ayɨ́ nʉ́fà, dɨ̀vayì ràdʉ̀ ndʉ̀fʉ̀ obvò. Nɨ́ dhu àkǎ kʉdhɔ dɨ̀vayì-ɔwʉ́tá kàmʉdzɛ̀-ɔwʉ́tá ɔ̀, ɨ̀nzɨ̌ ndɨ kàmʉdzɛ̀ adʉ̀ tɨ́ ndʉ̀fà, dɨ̀vayì ràdʉ̀ ndʉ̀fʉ̀ obvò.» ");
INSERT INTO niy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yěsù rɨ̌ dhu nɔ́vɔ Yùwanɨ̀ bhà ábhàlɨ̌ tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, Pbàyàhúdí nzínzì ɔ̌ atdí ádrʉ̀ngbǎlɛ nɨ́ɨra àhʉ Yěsù-tɨ́, ndìtsì ndɔ̀kɔ̀ kɔ̀nzɨ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Màlimǒ, ma mʉ̀bhà ɨvàdú-ngba kòmbí tɨ́ afína ɨ̀tdɛ̌ rɔ́. Nɨ́ ma mòzè nyɨrà, ndɨ́nɨ̌ nyɨlɨ tɨ́ ɔtsʉ́nʉ kà-dɔ̌, kà ràdʉ̀ ɨ̀kyɛ.» ");
INSERT INTO niy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nɨ́ Yěsù adʉ̀ ndɨ̀và, ’àdʉ̀ òwu atdíkpá pbɨ̀ndà ábhàlɨ̌ mànà wɔ̀ ádrʉ̀ngbǎlɛ-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nɨ́, otu ɔ̌ abádhí rǒwu rɔ́rɔ̀, atdí tsìbhálɛ náandrì olùnǎ rɔ̀ Yěsù-tɨ’ɔ̀, ndàpbàlǎ kà-rɔ̌ mʉ̀dzarʉ̀ bɨdɔ̀-ngbɔ̀. Ndɨ tsìbhálɛ nɨ’ɨ̀ yà vèbhálɛ tɔ́ ɔgɔ́bhà tɔ́ azu náarɨ́rà rɔ̀ná, ràrà àhʉ atdí kumì dɔ̀ná ɔ́yɔ̌ nà atɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Obhó tɨ́, ka nɨ’ɨ̀ afína ɔ̀ rɨ́rà ɔ̀tɛ rɔ̌, ndàmbɛ àtɨ̀nà dɔ̌: «Kà-rɔ̌ mʉ̀dzarʉ̀-ngbɔ̀ kɛ̀lɛ̌ ma mapbálána gukyè, nɨ́ ma mɔ́gʉ̀ ɔ̀gʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nɨ́ Yěsù agɛ́rɛ́ ndɨ̀, ndàndà olùnga, ndàla wɔ̀ tsìbhálɛ, ndàdʉ̀ dhu ɔ̀vɔ̀ kpangba fɨ̌ndà ndàtɨ: «Ótù afínʉ pbà nɨ̌ tsìbhíngbá! Pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ wà nyɨ.» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ tsìbhálɛ náadʉ̀ ɔ̀gʉ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yěsù níitdègu àrà àhʉ wɔ̀ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎlɛ bhà, nɨ́ kǎtù rʉ̀gɛ̌ ʉ̀mɨ rɨ́ alɛ mà ihé-yà mànà atdídɔ̌ tsìya náva ɨ̀ ányɨ̀-dzá rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nɨ́ kǎtɨ: «Nyùvò àwú-dza rɔ̀! Wɔ̀ tsìbhíngba nɔ́vɛ̀ nzá, pbɛ́tʉ̀ kàyi àyǐ tɨ́!» Nɨ́ kɔ̀rɨ́ alɛ náadʉ̀ kà rʉ̌nɔna dhu gàyà nɔ́nzɨ̀ ɔ̀nzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nɨ́ kɔ̀rɨ́ alɛ ndɨ̀ ndàbhʉ rùvò ɨdza rɔ̀ rɔ̀, Yěsù atsù, ndàlʉ̌ tsìbhíngba ɔtsʉ́na rɔ̌, kà ràdʉ̀ ɨ̀kyɛ. ");
INSERT INTO niy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yěsù ɔ̀nzɨ̀ dhu-ɔ̀yɨ̌ náadʉ̀ ndʉ̀gà kɔ́rɔ́ wɔ̀ ndɨ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ʉrɔ́ rɔ̀ Yěsù ɨ̀và ndɨ̀ rɔ̀, ɔ́yɔ̌ ndùmùndúmú adʉ̀ òko, ’àmbɛ òwu dɔ̌ kǒwù ɔ̌. Abádhí owúnà ùkǔ rɔ̌ ’àmbɛ àtɨ̀nà dɔ̌: «Ábà ɨzʉ dɔ̀ká, Dàwudì t’Ídhùnǎ!» ");
INSERT INTO niy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nɨ́ ɨdza Yěsù àrà àhʉ rɔ̀, kɔ̀rɨ́ ndùmùndúmú náandrì Yěsù ɨ. Nɨ́ Yěsù ivú dhu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyà’ù tɨ́ wà dhu ʉ̀ngbɛ̌ ma ràrǎdʉ̀ nyɨ̀kpɔ́kʉ nʉ́ngbɛ?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Ádrʉ̀ngbǎlɛ́, ɨwà mǎ mà’ù.» ");
INSERT INTO niy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nɨ́ Yěsù adʉ̀ ɔtsʉ́na nʉ́lɨ abádhí-nyɨ̀kpɔ́ dɔ̌, ndàdʉ̀ àtɨ̀nà: «Dhu àkǎ ndɨ dhu rɔ̀nzɨ̀ ndɨ̀ fʉ̌kʉ̀ yà nyɨ̌ nyà’ù ka dhu bhěyi!» ");
INSERT INTO niy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nɨ́ abádhí-nyɨ̀kpɔ́ náadʉ̀ ’ʉ̀ngbɛ ányɨ̀rɔ̌ rɔ̀ tɨ́. Yěsù náadʉ̀ dhu ʉ̀ya ɔbɨ nyʉ́ nà abádhí tɔ̀, ndàtɨ: «Nyɨ̀rɨ yà ma mʉ́nɔna dhu mběyi! Atdí alɛ mà nákǎ nzá ndʉ̀nɨ wɔ̀ rʉ̀kʉ́ ndɨ̀ nɔ̀nzɨ̀ dhu!» ");
INSERT INTO niy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pbɛ́tʉ̀, abádhí níitdègu ’ɨ̀và, ’òwù Yěsù-tɨ́ rɔ̀, nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’òwù yà Yěsù ɔ̀nzɨ̀ rɔ̀yá dhu náwɛ rɔ̌ kɔ́rɔ́ ndɨ pbìrì ɔ̌ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Abádhí rǔvò, àmbɛ òwu dɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, ka kiwú atdí alɛ, yà ɔ̀nà rɨ́’ɨ̀ nzɛ́rɛ-alafí nʉ́tsɨ̀ tsʉ̀na, ɨ̀nzɨ̌ ròngò ɔtɛ nà Yěsù-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nɨ́ Yěsù níitdègu nzɛ́rɛ-alafí nípfǒ wɔ̀ alɛ ɔ̀ rɔ̀, nɨ́ ndɨ alɛ náadʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́. Nɨ́ ɨdhɔ nʉ́ʉkɔ ányɨ̀rɔ̌ ɨ̀’ɨ̀ ihé-yà atdídɔ̌, ràdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Ɨnzá mǎ màpɛ̀ yà dhu bhěyi dhu-tɨdɔ̀ nálǎ atdíku màtɨ́ Pbàìsràyélí tɔ́ pbìrì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pbɛ́tʉ̀, Pbàfàrìsáyó náadʉ̀ àtɨ̀nà: «Sìtanɨ̀, nzɛ́rɛ-alafí ɔ̌ ádrʉ̀ngbǎlɛ nɨ́ ndɨ arɨ́ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ̌ kà tɔ̀, kà ràmbɛ nzɛ́rɛ-alafí nódì dɔ̌ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yěsù núubhì kɨgɔ̀ ɔ̀nǎ, ndɨrɔ̀ pbanga ɔ̀nǎ màtɨ́ kɔ́rɔ́. Kǎránà dhu núdhe rɔ̌ Pbàyàhúdí tɔ́ unduta-dzà ɔ̌ rɔ̀. Ndɨrɔ̀ kǎránà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ìndrǔ tɔ̀, ndàdʉ̀ àrà kɔ́rɔ́ andɨ nɨ́gʉ rɔ̌, ndàdʉ̀ alɛ-ngbɔ̀ tɔ́ kɔ́rɔ́ ivívínga nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nɨ́ Yěsù níitdègu ihé-yà nʉ́lɨ ɨ̀ tɨ́ dhu nálǎ, nɨ́ ɨzʉ ʉka ka atdídɔ̌, abádhí nɨ́ngyɛ̌ ɨ̀, ’àdʉ̀ ɨ̀fàlà, ɨ̀mbǎ ʉ̀ndana rɨ́ alɛ rɨ̌’ɨ̀ tàmà bhěyi nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ɔ̀nyʉ̀ nɔ́’ɔ̀ wà, pbɛ́tʉ̀ ndɨ ɔ̀nyʉ̀-tsʉ̀ núndǔ rɨ́ alɛ rɨ̌ ɨ̀ ngúfe. ");
INSERT INTO niy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɨ́ kɨ̀tsɔ̀ alɛ ɨnga-àbadhi rɔ̌ ndɨ́nɨ̌ kasʉtálɛ-bvʉ nɨtrɔ́ tɨ́ ɔ̀nyʉ̀-tsʉ̀ t’únduta tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù náanzi pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌, ndàdʉ̀ nzɛ́rɛ-alafí nípfo abádhí rǎdʉ̀ nɨ̌ ìndrǔ ɔ̀ rɔ̀, ’àdʉ̀ kɔ́rɔ́ andɨ-tɨdɔ̀ nɨ́gʉ nɨ̌ kɔ́rɔ́ ivívínga mànà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yàrɨ́ nɨ́ ndɨ ɨ atdí kumì dɔ̀ná ɔ́yɔ̌ nà uvitatálɛ-ɔvɔ̀. Wɛmbɛrɛ̀ tɨ́ nɨ́ Sìmonì, Pɛ́tɛrʉ̀ tɨ́ kátɨna mà, adɔ̀nà Àndɛ̀rɛyà mànà. Abádhí dzidɔ̌ nɨ́ Zɛ̀bɛ̀dayò bhà ɔ́yɔ̌ inzo, Yàkɔbhɔ̀ mà, adɔ̀nà Yùwanɨ̀ mànà, ");
INSERT INTO niy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fìlipò mà, Bàrtɔ̀lɔ̀mayò mànà, ndɨrɔ̀ Tʉ̀masɨ̀ mà, Màtayò mànà. Angyi ndɨ Màtayò nɨ’ɨ̀ pàratà t’ʉ́fɔ́tá tɔ́ ndɔmbɛ̀. Ngʉ̌kpà uvitatálɛ nɨ́ Yàkɔbhɔ̀, Àlʉ̀fayò t’ídhùnà mà, Tàdayò mànà. ");
INSERT INTO niy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ndɨrɔ̀ Sìmonì, yà atdídɔ̌ ndɨ̀ nugyénà fɨ̀yɔ́ pbìrì dɔ̌ alɛ mà, Yudhà Ìskàrìyɔtà, yà Yěsù nipfo ndàbhʉ òmvǔ-fɔ́ mànà. ");
INSERT INTO niy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yěsù núuví kɔ̌kɔ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ uvitatálɛ, ndàdʉ̀ dhu ʉ̀ya fɨ̌yɔ̀ ndàtɨ: «Àpɛ́ nyòwu ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí tɔ́ pbìrì ɔ̀, ndɨrɔ̀ àpɛ́ nyòtsù Sàmàrɨyà tɔ́ pbìrì ɔ̌ atdí kɨgɔ̀ ɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pbɛ́tʉ̀, nyòwu Ìsràyelì tɔ́ pbìrì ɔ̌ bhà, yà ùwǔwǐ tàmà bhěyi ɨ̀ nʉ̀lɨ bvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ányɨ̀ nyɨ̌ nyówu rɔ̀, nyɨ̌ nyàkǎ nyʉ̌nɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ ìndrǔ tɔ̀, nyǒwù àtɨ̀nà rɔ̌: ‹Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi-tsʉ̀ níndù wà ndɨ̀.› ");
INSERT INTO niy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nyɨ̌ nyàkǎ nyǒwù andɨtálɛ nɨ́gʉ rɔ̌, ndɨrɔ̀ nyɨ̌ nyàkǎ nyǒwù ʉ̀vʉ̌vɛ alɛ nɨ́kyɛ rɔ̌. Nyɨ̌ nyàkǎ nyǒwù kɨ́kɨ́tálɛ nɨ́gʉ rɔ̌, ndɨrɔ̀ nyɨ̌ nyàkǎ nyǒwù nzɛ́rɛ-alafí nípfo rɔ̌ ìndrǔ ɔ̀ rɔ̀. Nyɨ̌ nyàbà kɔ̌kɔ̀ dhu nɔ́nzɨ nyɨ̌ nyɨ́ nɨ̌ ɔbɨ tɨ́rɔ̌rɔ̀, nɨ́ nyɨ̌ nyàkǎ nyǒwù ɨ dhu nɔ́nzɨ̀ rɔ̌ tɨ́rɔ̌rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Àpɛ́ nyùgu ɔrɔ̀ mà, fʉ̀rangà mànà nyʉ̌fɔ̌ ngbɔ̌kʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Àpɛ́ nyùgu bhɔlɔ abhi tɔ̀, ndɨrɔ̀ àpɛ́ nyʉ̀fɔ̌ mbɛrʉ̀ ɔyɔ̌yɔ́ rʉ̀kʉ́. Ndɨrɔ̀, àpɛ́ nyùgu kàyìtò mà, mùgǒ mànà. Obhó tɨ́, kasʉ ɔ̀nzɨ rɨ́ alɛ nákǎ ndàbà ndɨ̀ ndɔ́nyʉna dhu pbɨ̀ndà kasʉ ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɨ̀ngbǎ tɨ́ ɨ̀lɨ ndɨ̀ kɨgɔ̀ mà, ndɨrɔ̀ ɨ̀ngbǎ tɨ́ ɨ̀lɨ ndɨ̀ pbanga ɔ̌ màtɨ́ nyɨ̌ nyòwu ùvò rɔ̀, nyɨ̌ nyowuna nyǎkɔ rádʉ̀ alɛ-tɨdɔ̀ nɔ́mɛ̀ rɔ̌. Ndɨ alɛ àkɔ nyɨ̌ rɔ̀, nyɨ̌ nyowuna òko rɔ̌ kàbhà ɨdzá ràrà àhʉ ányɨ̀ rɔ̌ rɔ̀ nyɨ̌ nyúvò, nyǒwù dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Atdí alɛ bhà ɨdza nyɨ̌ nyòtsù rɔ̀, nyɨ̌ nyowuna ányɨ̀-dzá-bhà nátsɛ̀ rɔ̌, nyǎtɨ: ‹Kàgàwà àkǎ ndàso nyɨ̌.› ");
INSERT INTO niy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ányɨ̀-dzá-bhà nákɔ nyɨ̌ mběyi rɔ̀, Kàgàwà arana abádhí àso rɔ̌. Pbɛ́tʉ̀, ɨnzá abádhí àkɔ nyɨ̌ mběyi rɔ̀, Kàgàwà arana nzɨ̌ abádhí náso rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Atdí ɨdza ɔ̌ alɛ, ndɨrɔ̀ atdí kɨgɔ̀ ɔ̌ alɛ mà nóowuna gukyè ’ùvo rɔ̌ ɨ̀nzɨ̌ ’àkɔ nyɨ̌, ndɨrɔ̀ ɨ̀nzɨ̌ ’ɨ̀rɨ̀ nyɨ̌ nyʉ́nɔna dhu, nɨ́ nyɨ̌ nyowuna òwu rɔ̌ ányɨ̀rɔ̌ rɔ̀, nyǎdʉ̀ pfɔ̌kʉ-tsítsírɔ́ àhʉ̀ nɔ́’ɔ̀ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, ɨ kɨgɔ̀ ɔ̌ alɛ dɔ̌ ka kɨtdɨ̀ya dhu ròsè yà Sɔ̀dɔmɔ̀ mà Gɔ̀mɔrà mànà tɔ́ kɨgɔ̀ ɔ̌ bhà dɔ̌ ka kɨ́tdɨ̀na dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà uvitatálɛ nɨ̌: «Kɔ̀nɨ̌ ma mùvǐ nyɨ̌ tàmà bhěyi atdídɔ̌ arɔ́rʉ̀ tsamangɛ̀rɛ̌ nzínzì ɔ̀. Nɨ́ nyàbhʉ nyɨ̀kpɔ́kʉ ròtdyù osu-nyɨ̀kpɔ́ ótdyù dhu bhěyi, nyǎdʉ̀ òko yɔrɔwà ɔ̌ àmbò bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dhu àkǎ nyɔ̌dɔ̀ nyɨ̌ mběyi! Ìndrǔ nóowuya nyǐpfo rɔ̌, ’àdʉ̀ nyǎbhʉ kɨtdɨ̀ ànyǎkʉ. Ndɨrɔ̀ abádhí nóowuya nyʉ̌vɨ rɔ̌ asé nɨ̌ unduta-dzà ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ìndrǔ nóowuya òwu rɔ̌ nyɨ̌ nà lɨ̀walɨ̀-ɔ̀nzɨ̌, ndɨrɔ̀ ádrɔ̀drɔ̌ kámá mànà dhu-ɔ̀nzɨ̌ okúdu dɔ̀ rɔ̀, ndɨ́nɨ̌ nyɨ̌ nyɨ’ɨ tɨ́ pbàkà ngàmbì tɨ́ abádhí-ɔ̀nzɨ̌, ndɨrɔ̀ ngʉ̌kpà alɛ, yà ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí-ɔ̀nzɨ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nyɨ̌ nà ka kòwù ùvò ànyǎkʉ nɨ́tdɨ̀ ka kɨ́ ɨ rɔ̀, àpɛ́ nyǒwuya afíkʉ nítu rɔ̌ nyɨ̌ nyʉ́nɔna dhu nɨ̌, ndɨrɔ̀ nyɨ̌ nyɨ́ kʉ̀nɔ tɨ́ dhu nɨ̌. Nyɨ̌ nyowuya nyɨ̌ nyʉ́nɔna dhu nábà rɔ̌ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɨ̀nzɨ̌ nɨ́ nyɨ̌ ndɨ nyɨ̌ nyowuya ɔtɛ rɔ̌, pbɛ́tʉ̀ Àbakʉ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí náaraya ndɨ ɔ̀tɛ rɔ̌ ʉ̀kʉ nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ngǎtsi alɛ náaraya adɔ̀nà nípfo rɔ̌ ndɨ́nɨ̌ ka koho tɨ́. Ndɨrɔ̀ nzónzo t’ábána nóowuya dhu ɔ̀nzɨ̀ rɔ̌ ndɨ dhu bhěyi tɨ́ fɨ̌yɔ́ inzo rɔ̌. Nzónzo nɨ́ɨvàya dhu ɨ̀ nɔ́dhɨ̀ alɛ rɔ̌, ’àdʉ̀ abádhí àbhʉ kɔkyɛ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kɔ́rɔ́ alɛ nɔ́ɔndrɔ́ya nyɨ̌ okúdu dɔ̀ rɔ̀. Pbɛ́tʉ̀, kɔ̌kɔ̀ dhu-dzi òndù rɨ́ kɔ́rɔ́, ràrà àhʉ kɔ́rɔ́ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ dhu ɔ̀ alɛ nɨ́ ndɨ ɔ̀gʉ̀ ɔgʉ́ya. ");
INSERT INTO niy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yà nyɨ̌ nyɨ́’ɨ̀ ɔ̀ná kɨgɔ̀ ɔ̌ ka kɔ̀pɛ̀ kavu rʉ̀kʉ́, nyǎmbɛ àpbɛ̀ àbà dɔ̌ rɔ̀, nyɨ̌ nyowuya òtse rɔ̌ ngǎtsi kɨgɔ̀ ɔ̀. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, nyɨ̌ nyasòya nzɨ̌ Ìsràyelì tɔ́ pbìrì ɔ̌ kɨgɔ̀ kɔ́rɔ́, ɨnzá Ìndrǔ t’ídhùnà níngò rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Dhu núdhě ka kɨ́ fɨ̌ndà alɛ bhà ɨrɛ̀ta náarɨ́ nzɨ̌ òse pbɨ̀ndà màlimò bhà ɨrɛ̀ta dɔ̀nǎ, ndɨrɔ̀ kasʉtálɛ bhà ádrʉ̀ngbǎnga náarɨ́ nzɨ̌ òse kasʉ ɔ̀nzɨ kà rɨ̌ fɨ̌ndà alɛ bhà ádrʉ̀ngbǎnga dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nɨ́, ɨnga nɔ̀fɔ̀ dhu nɨ́, dhu ùdhě ka kɨ́ fɨ̌ndà alɛ ròngò pbɨ̀ndà màlimò bhěyi. Ndɨrɔ̀ ɨnga nɔ̀fɔ̀ dhu nɨ́, kasʉtálɛ ròngò pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ bhěyi. Ìndrǔ apɛ́ ɨdza-àbadhi nyʉ́ nánzi Bɛ̀lìzèbulì tɨ́, nɨ́ kàbhà ɨdzá bhà dɔ̌ abádhí tɨ́ nzɨ̌ àdʉ̀ nzɛ́rɛ ɔvɔ nyʉ́ nɔ́vɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ábhàlɨ̌ nɨ̌: «Dhu àkǎ nzá nyɔ̌nzɨ̀ kɔ̌kɔ̀ dhu bhěyi alɛ-ɔdɔ̀. Kɔ́rɔ́ dhu-tsí yà ɨ̀ nuru, núuvòya kpangba. Ndɨrɔ̀ kɔ́rɔ́ dhu-tsí, yà ɔ̀dhʉ̌ ɔ̀ aróko, núuvìya ɨ̀ kpangba kɔ́rɔ́ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yà ɨ́nɔ̀ ɔ̌ ma mʉ̀nɔ̀ fʉ̌kʉ̀ dhu nákǎ nyǒwù ìpfonà rɔ̌ awáwʉ̀ ɔ̀, ndɨrɔ̀ yà bhɛ̀lʉ ɔ̌ ka kʉ́nɔna rɔ́ nyɨ̌ nyɨ̀rɨ̀ dhu nákǎ nyǒwù ʉ̀nɔ̀nà rɔ̌ ìkǔ ɔ̌ ɨdza dɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nɨ́ dhu àkǎ nzá nyɔ̌nzɨ alɛ-ngbɔ̀ kɛ̀lɛ̌ nóho rɨ́, ɨ̀nzɨ̌ ndàdʉ̀ alɛ-afí nóhò átɔ̀ alɛ-ɔdɔ̀. Pbɛ́tʉ̀, dhu àkǎ nyɔ̌nzɨ̀ Kàgàwà-ɔdɔ̀, yà alɛ-ngbɔ̀ mà, alɛ-afí mànà nábhʉ rádʉ̀ rògbè, yà ɨ̀nzɨ̌ arávɛ dhòdhódhónga nà kàzʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ɔ́yɔ̌ àrɛ̀-tʉ́tʉ̌-nzo nódzi ka ka tɨ́ obhó atdí fʉ̀rangà-kpɔ̌ rɔ̌? Pbɛ́tʉ̀, atdí abádhí nzínzì ɔ̌ mà náarɨ́ nzɨ̌ ɨ̀tsɨ̀ obvò ɨnzá Àbakʉ Kàgàwà nózè rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nɨ́rɔ̀ nyɨ̌, Kàgàwà nʉ́nɨ wà ìfe màtɨ́ dʉ̀kʉ-ká-vɛ́ náarɨ́ ɨ̀’ɨ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nɨ́ dhu àkǎ ɨnzá nyɔ̌nzɨ̀ ɔdɔ. Obhó tɨ́, nyɨ̌ nyʉ̀dà ábhɔ̌ àrɛ̌-nzo ɨtsɛ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Ndɨ alɛ apɛ́ dhu ɔ̀vɔ kpangba ibí alɛ-ɔ̀nzɨ̌, ndàtɨ ndɨ ràrɨ̌ pbàkà alɛ, nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà-ɔ̀nzɨ̌ màtɨ́, ma madʉ̀ya dhu nʉ́nɔ̀ átɔ̀ kpangba matɨ, ndɨ alɛ ràrɨ̌ pbàkà alɛ. ");
INSERT INTO niy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pbɛ́tʉ̀, ndɨ alɛ nʉ́ʉnɔya gukyè dhu kpangba ìndrǔ-ɔ̀nzɨ̌, ndàtɨ ɨnzá ndɨ̀ rʉ́nɨ ma, nɨ́ ma madʉ̀ya dhu nʉ́nɔ̀ átɔ̀ kpangba ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà-ɔ̀nzɨ̌ matɨ, ɨnzá ma rʉ́nɨ ka.» ");
INSERT INTO niy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Àpɛ́ nyɨ̀rɛ̀ nga ma rɨ́rà yà adzɨ dɔ̌ alɛ àbhʉ ròkò màrʉ̀ngà ɔ̌. Ma mɨ́rà ɨnzá màrʉ̀ngà nà, pbɛ́tʉ̀ ma mɨ́rà nà dhu nɨ́ alɨ. ");
INSERT INTO niy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma mɨ́rà ɨngba mà ɔ̌nga nʉ́ndɔ̀ àbanà nà, tsìbhíngba mà ɔ̌nga nʉ́ndɔ̀ ɨ́yànà nà, ndɨrɔ̀ àdhɨ̀ngbǎ mà ɔ̌nga nʉ́ndɔ̀ pbɨ̀ndà agʉna-àyi nà. ");
INSERT INTO niy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ìndrǔ rɔ̌ òmvǔ naraya ɨ̀’ɨ̀ rɔ̌ ndɨ alɛ bhà ɨdzá bhà kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Atdí alɛ náapɛ́ àbanà mà, ndɨrɔ̀ ɨ́yànà mà nózè, ròsè dùdunǎ, nɨ́ ndɨ alɛ nákǎ ɨnzá ndàtɨ̀ ndɨ̀ owùdu nʉ́ngʉ alɛ tɨ́. Ndɨrɔ̀, atdí alɛ náapɛ́ idhùnà mà, ndɨrɔ̀ ɨvànà mà nózè, rósè dùdunǎ, nɨ́ ndɨ alɛ nákǎ ɨnzá ndàtɨ̀ ndɨ̀ owùdu nʉ́ngʉ alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɨ̀nzɨ̌ rɨ́ pbɨ̀ndà mʉ̀sàlabhà nánɔ̀, ndàdʉ̀ owùdu ʉ̀ngʉ nà alɛ, nákǎ ɨnzá ndàtɨ̀ ndɨ̀ owùdu nʉ̀ngʉ alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pbɨ̀ndà ípìrɔ̌nga nózè rɨ́ ndɔ̀dɔ̀ fɨ̌ndà alɛ níiwíya ka, pbɛ́tʉ̀ pbɨ̀ndà ípìrɔ̌nga níwǐ rɨ́ okúdu dɔ̀ rɔ̀ alɛ náadʉ̀ya kàbà àbà tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Atdí alɛ apɛ́ nyǎkɔ̌, nɨ́ ɨwà ma nàkɔ átɔ̀. Ndɨrɔ̀, ɨma nàkɔ alɛ nɨ́ ɨwà ma nivi alɛ nàkɔ. ");
INSERT INTO niy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Atdí alɛ náapɛ́ Kàgàwà bhà nabì nákɔ̌, Kàgàwà bhà nabì tɨ́ kà rɨ̌’ɨ̀ dhu-okú dɔ̀ rɔ̀, nɨ́ ndɨ alɛ náabáya Kàgàwà bhà nabì àkǎ ndàbà pɛrɛ̀. Ndɨrɔ̀, atdí alɛ náapɛ́ obhónángatálɛ nákɔ̌, obhónángatálɛ tɨ́ kà rɨ̌’ɨ̀ dhu-okú dɔ̀ rɔ̀, nɨ́ ndɨ alɛ náabáya obhónángatálɛ nákǎ ndàbà pɛrɛ̀. ");
INSERT INTO niy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: atdí alɛ náapɛ́ ìrǐre ɨdha tɔ́ kɔ́pà-tsí dhu mà nábhʉ̌ kǎkà owùdu nʉ́ngʉ alɛ nzínzì ɔ̌ atdí àkyǎkyɛ̀ alɛ tɔ̀, owùdu kʉ̀ngʉ dhu-okú dɔ̀ rɔ̀, nɨ́ ndɨ alɛ náabáya àbà pbɨ̀ndà pɛrɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yěsù níitdègu yà pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ tɔ̀ ndɨ̀ ndúbhi ʉ̀yanà rɔ̌ dhu t’ʉ́yátá nɨ́tɔ, nɨ́ kǎdʉ̀ ndɨ̀và, ndàrà ányɨ̀rɔ̌ rɔ̀. Kǎrà dhu núdhe ìndrǔ tɔ̀, ndàdʉ̀ àrà Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̀ abádhí tɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ kɨgɔ̀ ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ndɨ kàsʉmɨ̀ ɔ̌, bàtizò nubhónà Yùwanɨ̀ nɨ́ɨ’ɨ̀ imbi ɔ̀ ka kósò rɔ́. Nɨ́ imbi ɔ̀ ndɨ̀ ndɨ́’ɨ̀ rɔ́rɔ̀, kɨ̌rɨ Krɨ́stɔ̀ rǎrà ɔ̀nzɨ̀nà rɔ̌ dhu-ɔ̀yɨ̌. Nɨ́ kǎdʉ̀ pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ ngúfe alɛ nóvì, ròwù dhu ìvu Yěsù-tsʉ̌, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Nyɨ tɨ́ yà mǎ márɔ́dɔna ndɨ́nɨ̌ ɨra tɨ́ alɛ, ndɨrɔ̀ mǎ màkǎ tɨ́ mɔ̌dɔ̀ vurò alɛ?» ");
INSERT INTO niy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyòwu nyʉ̀nɔ yà nyɨ̌ nyɨ́rɨna dhu, ndɨrɔ̀ yà nyɨ̌ nyálǎna dhu Yùwanɨ̀ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ɨ dhu nɨ́: ndùmùndúmú-nyɨ̀kpɔ́ rǒwu ’ʉ̀ngbɛ rɔ̌, ’àdʉ̀ ɨnga àla. Òtsótsù alɛ rǒwu ùbhi rɔ̌ mběyi. Kɨ́kɨ́ nà alɛ ràrǒwu ʉ̀gʉ rɔ̌, ìwǐ ràdʉ̀ ɨnga nɨ́rɨ̀. Ʉ̀vʉ̌vɛ alɛ rǒwu ɨ̀kyɛ rɔ̌, ndɨrɔ̀ nǎkʉ̀tálɛ rǒwu Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nɨ́rɨ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hirò nɔnzɨya alɛ nɨ́ nzɨ̌ yà ma mʉ́nɔna dhu rǎbhʉ̌na ròtsù nzɛ́rɛnga ɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yùwanɨ̀ bhà ábhàlɨ̌ nɨ́và ɨ̀, ’àmbɛ ’àdu dɔ̌ rɔ̀, Yěsù adʉ̀ ndɔ̀pɛ̀ ndàwɛ dhu ihé-yà tɔ̀ Yùwanɨ̀ dɔ̌. Kǎpɛ̀ ndɔ̀ngʉ̀ dhu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyówù àndànà rʉ̀ngʉ̀ ɔ̀? Tɨ́ awɛ rɨ̌ ɔ̀nánga nʉ́tdyǎ ízò? ");
INSERT INTO niy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ádhɨ nyʉ́ nyɨ̌ nyawù àndànà? Tɨ́ atdídɔ̌ áya mʉ̀dzarʉ̀ nʉ̀fɔ̌ alɛ? Pbɛ́tʉ̀, atdídɔ̌ àya mʉ̀dzarʉ̀ nʉ̀fɔ̌ alɛ náaróko ádrɔ̀drɔ̌ kámá-ɨdzà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɨ́ ádhu nyʉ́ nyɨ̌ nyówù àndànà? Tɨ́ Kàgàwà bhà nabì? Obhó tɨ́, nyɨ̌ nyówù Kàgàwà bhà nabì nándà. Pbɛ́tʉ̀ ma mátɨna nyɨ̌ nɨ̌, ɨwà kà ròsè Kàgàwà bhà ngʉ̌kpà pbànábí dɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yùwanɨ̀ nɨ́ ndɨ, yà Kàgàwà bhà Andítá rɨ̌ dhu ʉ̀nɔ kpangba dɔ̀ná ndàtɨ: ‹Kɔ̀nɨ̌ ma mɨ́ pbàkà mʉ̀kɛ̀ngyɛ̀ nóvì angyi ɨndʉ̀, ndɨ́nɨ̌ pbʉ̀kʉ̀ otu nɔbhɔlɔ tɨ́ ɨndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, yà vèbhálɛ ʉ́gʉ̀ yà adzɨ dɔ̌ alɛ nzínzì ɔ̌, Bàtizò nubhónà Yùwanɨ̀ bhà ádrʉ̀ngbǎnga dɔ̀nǎ pbɨ̀ndà ádrʉ̀ngbǎnga ósè alɛ rɨ̌ mbǎ ɨ̀’ɨ̀. Pbɛ́tʉ̀, yà ákɛ̌ alɛ tɨ́ ka kálǎna ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ alɛ, nɨ́ rɨ̌ ádrʉ̀ngbǎlɛ nyʉ́ tɨ́, ròsè Bàtizò ùbhǒ arɨ́ Yùwanɨ̀ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Rɔ̀pɛ̀ ndɨ̀ yà ndɨ Bàtizò ùbhǒ arɨ́ Yùwanɨ̀ apɛ̀na ndɔ̀nzɨ̀ pbɨ̀ndà kasʉ, rɨ̀rà àhʉ indo nga ɔ̀ rɔ̀, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi náarɨ́ ìnè ɔbɨ nɨ̌ ka karúgyena rɔ́, ndɨrɔ̀ ɔ̀rɔ̌rʉ̀ alɛ náarɨ́ kàpà fɨ̌yɔ̀ ɔbɨ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Músà bhà Ʉyátá mà, Kàgàwà bhà pbànábí mànà kɔ́rɔ́, rɨ̀rà àhʉ Yùwanɨ̀ ɔ̀, náapɛ̀ ʉ̀nɔ̀ dhu angyangyɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndɨrɔ̀, ma mʉ́nɔna dhu ná’ù nyɨ̌ nyádʉ̀ nánɨ̌, ma màmbɛ̀nà àtɨna nyɨ̌ nɨ̌, Yùwanɨ̀ ràrɨ̌ ndɨ Ɛ̀lɨyà, yà ɨ̀rà rɨ́rà dhu tɨ́ ka katɨ. ");
INSERT INTO niy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́ alɛ nɨ́rɨ yà dhu mběyi! ");
INSERT INTO niy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yà indo arɨ́ alɛ núdhe ma mádʉ̀ àdhà bhà rɔ̌? Abádhí ʉ̀lɨ ɨ̀ yà pbanga-tsi dɔ̌ ɨ̀ nùndu nzónzo bhěyi. Atdídhená ràdʉ̀ òwu ɔdhɨ́ya núnzì rɔ̌ ìkǔ ɔ̌ àtɨ: ");
INSERT INTO niy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Mǎ mʉ̀mɨ̀ mbǎ ɔbɛ́ tɔ́ adyi rʉ̀gɛ̌ ɔ̌ màtɨ́ fʉ̌kʉ̀, nɨ́ nyɨ̌ nyàdʉ̀ ɨnzá ɔ̀bɛ̀. Ndɨrɔ̀ mǎ mʉ̀yʉ̀ mbǎ ɨzʉ tɔ́ adyi mà fʉ̌kʉ̀, nɨ́ ɨzʉ àdʉ̀ ɨnzá nyʉ̌ka.› ");
INSERT INTO niy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Obhó tɨ́, Yùwanɨ̀ nɨ́ɨra, ɨ̀nzɨ̌ ndàdʉ̀ àrà dhu ɔ̀nyʉ rɔ̌, ndɨrɔ̀ ɨ̀nzɨ̌ ndàdʉ̀ àrà dhu mà nɔ́mvʉ̀ rɔ̌. Nɨ́ ìndrǔ adʉ̀ àtɨ̀nà nzɛ́rɛ-alafí ràrɨ̌’ɨ̀ kà’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ndɨ dhu bhěyi tɨ́, Ìndrǔ t’ídhùnà nɨ́rà ndàrà dhu ɔ̀nyʉ̀ rɔ̌, ndàdʉ̀ arà dhu nɔ́mvʉ̀ rɔ̌. Nɨ́ ìndrǔ arádʉ̀ kàtɨ̀ ɔ̀na óvò alɛ tɨ́, ndɨrɔ̀ atdídɔ̌ arɨ́ ndɔ̀mvʉ̀ alɛ tɨ́. Ndɨrɔ̀ abádhí arádʉ̀ kàtɨ̀ pàratà tɔ́ pbàndɔ́mbɛ́ mà, yà nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ alɛ mànà ɨ̀ nózè alɛ tɨ́. Pbɛ́tʉ̀, Kàgàwà arɨ́ dhu-ɔ̌nga òvò tɨ́ dhu tɔ́ obhónga náarɨ́ ndàvǐ kpangba kà rɔ̌nzɨna dhu-nyʉtsì.» ");
INSERT INTO niy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wɔ̀ dhu-dzidɔ̌, Yěsù apɛ̀ ndɔ̀rʉ̀ atdídɔ̌ yà ábhɔ̌ wɨwɨ̀ nyʉ́ ndɨ̀ ndɔ́nzɨ̀ ɔ̀yá kɨgɔ̀ dɔ̌, ɨnzá ɨ kɨgɔ̀ ɔ̌ alɛ nʉ́gɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̌yɔ́ nzɛ́rɛnga dhu-okú dɔ̀ rɔ̀. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kɔ̀ràzinì mà, Bɛ̀tɛ̀sàyidà mànà tɔ́ kɨgɔ̌, yà ʉ̀kʉ́ ndɨ̀ nɔ̀nzɨ̀ wɨwɨ̀ nɨ́’ɨ̀yana gukyè Tirò mà, Sìdɔnà mànà tɔ́ kɨgɔ̀ ɔ̌ ndɨ̀ nɔ́nzɨ̀ dhu tɨ́, nɨ́ ɨ kɨgɔ̀ ɔ̌ alɛ nɨ́’ɨ̀yana angyí ɨ̀ ʉ́fɔ̌ gɔ̀nɨ́yà mbɛrʉ̀ tɨ́ rɔ̀yá, ’àdʉ̀ ohu nʉ́trɔ dɔ̀ya ɔ̀, ndɨ́nɨ̌ ɨ̀ ʉ̀gɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̌yɔ́ nzɛ́rɛnga dhu navì tɨ́ rɔ́. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, nyɨ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ Kɔ̀ràzinǐ, ndɨrɔ̀ nyɨ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ Bɛ̀tɛ̀sàyidǎ. ");
INSERT INTO niy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mɨ́ dhu ɔ̀vɔ kpangba fʉ̌kʉ̀. Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, kɨ̌tdɨ̀ya dhu dʉ̀kʉ́ abhàbhɔ́ nyʉ́, ròsè Tirò mà, Sìdɔnà mànà tɔ́ kɨgɔ̀ dɔ̌ ndɨ̀ ndɨ́tdɨ̀na dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndɨrɔ̀ ɨnyɨ, Kàpɛ̀rnàwumù tɔ̀ kɨgɔ̌, yà ʉ̀nʉ́ ndɨ̀ nɔ́nzɨ̀ wɨwɨ̀ nɨ́’ɨ̀yana gukyè Sɔ̀dɔmɔ̀ tɔ́ kɨgɔ̀ ɔ̌ ndɨ̀ nanzɨ̀ dhu tɨ́, nɨ́ Sɔ̀dɔmɔ̀ nɨ́’ɨ̀yana ìnè indo màtɨ́. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, ɨnyɨ, Kàpɛ̀rnàwumù tɔ̀ kɨgɔ̌, nyɨ nyà’ù tɨ́ dhu, ɨ̀dzɨ̌ Kàgàwà ràrǎdʉ̀ nyɨdzɨ ɔ̀rʉ̀-akpà ɔ̀? Ɨ̀nzɨ̌ rádʉ̀ nyɨdzɨ, akɛkpá màtɨ́. Pbɛ́tʉ̀, kà rɨ̌ nyifǒ obvò, ndàdʉ̀ nyobvù ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mɨ́ dhu ɔ̀vɔ kpangba fʉ̌kʉ̀, Kàpɛ̀rnàwumù ɔ̌ bhǎ, Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, kɔ̌tdɨ́ya dhu Kàpɛ̀rnàwumù tɔ̀ kɨgɔ̀ dɔ̌ abhɔ nyʉ́, ròsè Sɔ̀dɔmɔ̀ tɔ̀ kɨgɔ̀ dɔ̌ ndɨ̀ ndɔ́tdɨ̀na dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Ɔ̀ɔ, Àba Kàgàwà, ɔ̀rʉ̀-akpà mà, yà adzɨ mànà ɔ̌ Ádrʉ̀ngbǎlɛ́, ma mɨ̀fʉ nyɨ atdídɔ̌ yà ɨnga nʉ́nɨ dhu tɨ́ ka kɔ́zʉ̀na alɛ-rɔ̌ nyɨ nyarù dhu nɨ́ nyɨ nyábhʉ àkyǎkyɛ̀ alɛ nyʉ́ rʉ̀nɨ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Obhó tɨ́ Àbá, nyɨ nyazè ndɨ dhu rɔ̀nzɨ̀ ndɨ̀ wɔ̀ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà: «Àbadu níibho wà kɔ́rɔ́ dhu tɔ́ ádrʉ̀ngbǎnga fudú. Atdí alɛ mà nʉ́nɨ nzá Kàgàwà t’ídhùnà, pbɛ́tʉ̀ ka nʉ́nɨ nɨ́ kà t’Ábanà kɛ̀lɛ̌. Ndɨrɔ̀ atdí alɛ mà nʉ́nɨ nzá kà t’Ábanà, pbɛ́tʉ̀ ka nʉ́nɨ nɨ́ Ɨma kà t’ídhùnà kɛ̀lɛ̌, yà ma mózè mɔvɔ̀ ka fɨ̌yɔ̀ alɛ mànà.» ");
INSERT INTO niy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà: «Nyìwǔ tɨdu ɔ̀, nyɨ̌ kɔ́rɔ́ yà nyɨ̌ nyɨ̀ngyɛ̌ nyɨ̌, nyǎdʉ̀ ɨ̀’ɨ̀ ɨ̀ nà’ɛ ànɔ̀ nà dʉ̀kʉ́ rɔ̀. Nɨ́ ma mɨ́ asota nábhʉ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nyòsò yà tudú rɨ́’ɨ̀ kɔ̀mɔ̀ átɔ̀ tukʉ́, ndɨrɔ̀ nyɨ̀rɨ fʉ̌kʉ̀ ma mʉ́yǎna dhu. Obhó tɨ́, ɨma nɨ́ ndɨ ɨ̀yɔ̀ arádɨ, ndɨrɔ̀ yɔrɔwà tɔ́ afína nà alɛ. Ndɨrɔ̀ nɨ́ ndɨ nyɨ̌ nyádʉ̀ asota nábà afíkʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Obhó tɨ́, pbàkà kɔ̀mɔ̀ nɨ́ ɨsɔ́ rɔ́’ɔ kɔ̀mɔ̀, ndɨrɔ̀ pbàkà ànɔ̀ nɨ́ ɨsɔ́ ɨnzá ndɨ̀ nà’ɛ ànɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wɔ̀ dhu-dzidɔ̌, sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náambɛ́nà ʉ̀da dɔ̌ nganʉ̀ tɔ́ ɨnga ɔ̀na nǎ ʉ́dà otu ɔ̌. Ndɨ kàsʉmɨ̀ ɔ̌, kàbhà ábhàlɨ̌ nɨ́ɨ’ɨ̀ àwù nà atdídɔ̌. Nɨ́ ɨ ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀, ’òwù otu-igì dɔ̌ rɨ́’ɨ̀ nganʉ̀ náfà rɔ̌, ’ʉ̀tsɛ̀rɛ̌ kpɔ̌na liya ɔ̀, ’àdʉ̀ ʉ̀kanà. ");
INSERT INTO niy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nɨ́ Pbàfàrìsáyó níitdègu wɔ̀ dhu nálǎ, nɨ́ abádhí adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ándà pɛ́ pbʉ̀kʉ̀ ábhàlɨ̌ rɨ̌ ɨnzá àkǎ kɔnzɨ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌ dhu nɔ́nzɨ.» ");
INSERT INTO niy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyàpɛ̀ tɨ́ obhó Dàwudì mà, rɔ̀ná alɛ mànà náanzɨ̀ atdíku àwù nà ɨ̀ ɨ́’ɨ̀ rɔ̀ dhu nɔ́zʉ̀? ");
INSERT INTO niy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Àbadhi náatsù Kàgàwà bhà ɨdza, ndàdʉ̀ pɛrɛ̀ tɨ́ ka kùbho Kàgàwà tɔ̀ mʉ̀gatì núgù, ɨ̀ rɔ̀nyʉ̀ rɔ̀ná alɛ mànà. Wɔ̀ ndɨ mʉ̀gatì nɨ’ɨ̀ ɨnzá àkǎ àbadhi mà, rɔ̀ná alɛ mànà rɔ̀nyʉ̀ mʉ̀gatì. Pbɛ́tʉ̀, kɔ̀nyʉ̀ rádʉ̀ alɛ nɨ’ɨ̀ pbàkùhánɨ́ kɛ̀lɛ̌ vǐya dɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ndɨrɔ̀, nyɨ̌ nyɔ́zʉ̀ tɨ́ obhó Músà bhà Ʉyátá ɔ̀ ka kándǐ dhu, katɨ: ‹Sàbatʉ̀-ɨdhɔ̀ ɔ̌ arɨ́ kasʉ ɔ̀nzɨ Kàgàwà bhà ɨdzá, ɨ̀nzɨ̌ ’ɨ̀fʉ ndɨ ɨdhɔ pbàkùhánɨ́, nɨ́ dɔ̌ ka ràrɨ̌ nzɨ̌ àdʉ̀ ndɨ dhu nɔ́zʉ̀ afátá tɨ́?› ");
INSERT INTO niy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pbɛ́tʉ̀, ma mɨ́ dhu ɔ̀vɔ kpangba fʉ̌kʉ̀: yà ɨrɔ́ rɨ́’ɨ̀ dhu nósè ɨwà Kàgàwà bhà ɨdza dɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dhu ɨ́’ɨ̀ná gukyè ɨwà nyɨ̌ nyʉ́nɨ yà Kàgàwà bhà Andítá rʉ̌nɔna dhu-tɨ̀ dhu tɨ́, yà ɨ̀tɨ́ rátɨna: ‹Ma mózè dhu nɨ́ ɨzʉ àbà ka kɨ́ ìndrǔ dɔ̌ dhu, ɨ̀nzɨ̌ nɨ́ ɨ̀zǎ tɔ́ pɛrɛ̀ núbhǒ ka kɨ́ idù dhu kɛ̀lɛ̌›, nɨ́ nyɨ̌ nyàmbɛ̀nà nzɨ̌ anya nɨ́tdɨ̀ yà ɨ̀mbǎ rɨ́’ɨ̀ afátá nà alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Obhó tɨ́, Ìndrǔ t’ídhùnà nɨ́ ndɨ sàbatʉ̀-ɨdhɔ̀ dɔ̌ Ádrʉ̀ngbǎlɛ.» ");
INSERT INTO niy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ʉrɔ́ rɔ̀ Yěsù nɨ́ɨvà ndɨ̀, ndàrà òtsù fɨ̀yɔ́ unduta-dzà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɨ́ ɔtsʉ́na ótsù atdí alɛ nɨ́ɨ’ɨ̀ ányɨ̀ ɨdza. Ányɨ̀ rɔ̌ ɨ̀’ɨ̀ alɛ náazè ’ɔ̀bhʉ̀ Yěsù. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, abádhí níivú dhu Yěsù-tsʉ̌, ’àtɨ: «Àlɛ̌ tɔ́ Ʉyátá návi tɨ́ àvǐ ìndrǔ kɨgʉ̌ sàbatʉ̀-ɨdhɔ̀ ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nzínzìkʉ ɔ̌ atdí alɛ náapɛ́ ɨ̀’ɨ̀ atdí tàmà nà tɨ́, ndɨ tàmà ràdʉ̀ ɨ̀tsɨ̀ ádzǐ ibhu-akpà ɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌, nɨ́ ndɨ alɛ tɨ́ nzɨ̌ àdʉ̀ òfo ndɨ ibhu-akpà ɔ̀, ndàrà kìdyì ányɨ̀ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ìndrǔ òsè tɨ́ nzá tàmà dɔ̀nǎ! Nɨ́rɔ̀, Músà bhà Ʉyátá návi wà kɔnzɨ̀ ídzìnga ìndrǔ tɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nɨ́ Yěsù adʉ̀ àtɨ̀nà wɔ̀ ɔtsʉ́na ótsù alɛ nɨ̌: «Ɨ́gba ɔtsʉ́nʉ.» Nɨ́ ndɨ alɛ náadʉ̀ ɔtsʉ́na nɨ́gbà, ndɨ kɔ̌tsʉ́ ràdʉ̀ ɔ̀gʉ̀, ròngò yà ídzì rɔ̌ rɔ̀ rɨ̌’ɨ̀ ngǎtsi kɔ̌tsʉ́ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nɨ́ Pbàfàrìsáyó núuvò, ’òwù ’ùndu, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ ɨ̀ ɨ̀ngbǎ dhu bhěyi màtɨ́ ɨ̀ ɨ́ Yěsù nábhʉ̌ kohò dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yěsù níitdègu wɔ̀ dhu nɨ́rɨ, nɨ́ kǎdʉ̀ ndɨ̀và ányɨ̀ rɔ̌ rɔ̀ ndàrà. Nɨ́ ábhɔ̌ alɛ́-yà náadʉ̀ òwu kǒwù ɔ̌, kà ràdʉ̀ andɨ nà rɨ́’ɨ̀ alɛ nɨ́gʉ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pbɛ́tʉ̀, kʉ̌yá dhu ɔbɨ nyʉ́ nà abádhí tɔ̀, ɨ̀nzɨ̌ àdhɨ màtɨ́ ndɨ̀ ndɨ́’ɨ̀ dhu nʉnɔ tɨ́ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wɔ̀ dhu anzɨ̀ ndɨ̀ ndɨ́nɨ̌ yà Kàgàwà nʉ́ʉnɔ pbɨ̀ndà nabì Ìsayà-otù ɔ̌ dhu náaká tɨ́. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Kànɨ̌ ma mɔ́pɨ̀ pbàkà ɨnɔ-akpà, yà atdídɔ̌ ma mózè alɛ, ndɨrɔ̀ afídu arɨ́ ɨdha nɔ́mvʉ̀ pbɨ̀ndà dhu dɔ̌ alɛ. Ma mɨ́ kɨ̀rǎ pbàkà Ɨ̀lɨ̌lǎ-Alafí nɨ̌, ndɨrɔ̀ kà rɨ̌ obhónánga ɔ̀vɔ kɔ́rɔ́ pbìrì ɔ̌ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kà rɨ̌ nzɨ̌ tsʉ̀na nálɛ̀ atdí alɛ nà màtɨ́, ndɨrɔ̀ kà rɨ̌ nzɨ̌ ɔtɛ ɔrʉ́ tǔna nà. Atdí alɛ mà rɨ̌ nzɨ̌ kà-tù ɨ̀rɨ ngʉdhà ɔ̌ rɔ́tɛ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kà rɨ̌ nzɨ̌ ndɨ̀ nàtdo ízò nʉ́kɔ̀, ndɨrɔ̀ kà rɨ̌ nzɨ̌ núnúnú rɔ́rʉ̀ tarà nɨ́vɛ̌, ràrà àhʉ mʉ̀lɛ̀mà nábhʉ̌ kà rɨ̌ obhónánga tɔ̀ dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɨ́ kɔ́rɔ́ pbìrì ɔ̌ alɛ náapbáya afíya kà-rɔ̌ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nɨ́rɔ̀ nɨ́ ndɨ ìndrǔ níiwú nzɛ́rɛ-alafí arɨ́ ɔ̀nà atdí alɛ nà Yěsù-tɨ’ɔ̀. Ndɨ alɛ nɨ’ɨ̀ ndùmùndúmú, ndɨrɔ̀ ɨ̀nzɨ̌ arɔ́tɛ alɛ. Nɨ́ Yěsù ɨgʉ́ ka, ràdʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀, ndàdʉ̀ ɨnga àla. ");
INSERT INTO niy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nɨ́ ɨdhɔ nʉ́ʉkɔ kɔ́rɔ́ ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ, abádhí ràdʉ̀ àtɨ̀nà: «Tɨ́ nzɨ̌ Dàwudì t’ídhùnà yà?» ");
INSERT INTO niy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pbɛ́tʉ̀, abádhí rʉ̌nɔna dhu nɨ̀rɨ̀ Pbàfàrìsáyó náadʉ̀ àtɨ̀nà: «Yàrɨ́ alɛ náarɨ́ nzɛ́rɛ-alafí nódì Bɛ̀lìzèbulì tɨ́ kátɨna pfɔ̀mvɔ ɔ̌ kamà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pbɛ́tʉ̀ Yěsù nʉ́ʉnɨ abádhí rɨ̌rɛ̀na dhu, nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ náapɛ́ ambɛ ’ùgyè dɔ̌ nzínzìya ɔ̌, nɨ́ ndɨ ádrʉ̀ngbǎ kamà bhà idzi-tsʉ̀ rǎdʉ̀ ndɔ̀dɨ̀ ɔ̀dɨ̀ tɨ́. Atdí kɨgɔ̀ ɔ̌ alɛ mà, ndɨrɔ̀ atdí ɔdhɨ mà náapɛ́ àmbɛ anya nɔ́nzɨ̀ dɔ̌ nzínzìya ɔ̌, nɨ́ ɨ kɨgɔ̀ náarɨ́ nzɨ̌ àpɛrɛ, ndɨrɔ̀ ɨ alɛ tɔ́ ɔdhɨ-tɨ̀ náarɨ́ nzɨ̌ ìde. ");
INSERT INTO niy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nɨ́ pfɔ̀mvɔ Sìtanɨ̀ náapɛ́ àdʉ̀ ndɔ̀pɛ̀ ndòdì pfɔ̀mvɔ, nɨ́ ka nádʉ̀ ɨ̀’ɨ̀ ndùgye rɨ́ ndɨ̀tɨ́rɔ̀ alɛ. Nɨ́ kàbhà ádrʉ̀ngbǎnga tɔ́ idzi rǎdʉ̀ àpɛrɛ ɨ̀ngbǎ dhu bhěyi? ");
INSERT INTO niy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ndɨrɔ̀, ma mapɛ́ ɨ̀’ɨ̀ Bɛ̀lìzèbulì bhà ɔbɨ nɨ̌ ma márɨ́ nzɛ́rɛ-alafí nódì dhu tɨ́, nɨ́ fʉ̀kʉ́ inzo náarádʉ̀ kòdì àdhɨ bhà ɔbɨ nɨ̌? Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, abádhí nɨ́ɨtdɨ̀ya ndɨ ànyǎkʉ. ");
INSERT INTO niy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pbɛ́tʉ̀, dhu apɛ́ ɨ̀’ɨ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí bhà ɔbɨ nɨ̌ ma márɨ́ nzɛ́rɛ-alafí nódì dhu tɨ́, nɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́rà wà àhʉ bvʉ̀kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ òtsù ɔbɨ nɨ̌ ɨ̀dzɨ̌dzɔ̀ alɛ bhà ɨdza, ndàdʉ̀ kàbhà ɨdzá dhu nʉ́mbà, ɨnzá ndɨ̀ ndʉ̀tsɨ̀ ndɨ ɨ̀dzɨ̌dzɔ̀ alɛ angyi rɔ́rɔ̀. Pbɛ́tʉ̀ ka ndɨ̀ ndʉ̀tsɨ̀ dhu-dzidɔ̌ nga nɨ́ ndɨ kà rǎdʉ̀ kɔ́rɔ́ kàbhà ɨdzá dhu nʉ́mbà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɨ̀mbǎ rɨ́’ɨ̀ tɨdu ɔ̀nǎ rɔ̀ alɛ nɨ́ pbàkà òmvǔ. Ndɨrɔ̀ ɨ̀nzɨ̌ rɨ́ dhu-tsʉ̀ ùndǔ atdíkpá ma mànà alɛ, nɨ́ rɨ̌ dhu ɨ̀nda ɨ̀nda tɨ́ rùdú rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mɨ́ kʉ̀nɔ kpangba fʉ̌kʉ̀: ìndrǔ náabáya àbà kɔ́rɔ́ fɨ̌yɔ́ nzɛ́rɛnga mà, Kàgàwà nɨ̌ ɨ̀ arɨ́ dhu ʉ̀nɔ nzɛ́rɛ dhu mànà dhu tɔ́ ʉbàta. Pbɛ́tʉ̀, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ̌ rɨ́ dhu ʉ̀nɔ nzɛ́rɛ alɛ, náabáya nzɨ̌ ʉbàta akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ìndrǔ t’ídhùnà nɨ̌ rɨ́ nzɛ́rɛ dhu ʉ̀nɔ alɛ náabáya àbà ʉbàta. Pbɛ́tʉ̀, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ̌ rɨ́ nzɛ́rɛ dhu ʉ̀nɔ alɛ náabáya nzɨ̌ ʉbàta, yà kombí rɨ́’ɨ̀ kàsʉmɨ̀ ɔ̌ màtɨ́, ndɨrɔ̀ olù rɨ́rà kàsʉmɨ̀ ɔ̌ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Atdí itsu náapɛ́ ɨ̀’ɨ̀ ídzì itsu-tɨdɔ̀ tɨ́, nɨ́ ndɨ itsu rǎdʉ̀ ɨ̀’ɔnà nɨ́ ídzì itsu-kpɔ̌-tɨdɔ̀. Ndɨrɔ̀ itsu náapɛ́ ɨ̀’ɨ̀ nzɛ́rɛ itsu-tɨdɔ̀ tɨ́, nɨ́ ndɨ itsu rǎdʉ̀ ɨ̀’ɔnà nɨ́ nzɛ́rɛ itsu-kpɔ̌-tɨdɔ̀. Obhó tɨ́, itsu nʉ́nɨ̌ ka karɨ́ kpɔ̌na rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyɨ̌, ámvɔ̀ tɔ́ osu tɔ́ rʉ̀gànda tɨ́rɔ̀, ídzì ɔtɛ rǎdʉ̀ àhʉ ɨ̀ngbǎ dhu bhěyi likʉ ɔ̀ rɔ̀, àzèmbè nyɨ̌ nongó ɨ̀’ɨ̀ nzɛ́rɛ alɛ nyʉ́? Obhó tɨ́, alɛ-tsʉ̀ arórìna dhu nɨ́ alɛ-afí àlè nɨ̌ ɨrɛ̀ta. ");
INSERT INTO niy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ídzì afína nà alɛ-afí ɔ̀ rɔ̀ aráhʉ dhu nɨ́ ídzì dhu, ndɨrɔ̀ nzɛ́rɛ afína nà alɛ-afí ɔ̀ rɔ̀ aráhʉ dhu nɨ́ nzɛ́rɛ dhu. ");
INSERT INTO niy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, Kàgàwà rɨ̌ ìndrǔ-ànyǎ ɨ̀tdɨ̀ nɨ́nganɨ́, kǎraya ìndrǔ návi rɔ̌ ràwɛ yà ɨ̀ ʉnɔ ɨ̀mbǎ tɨ̌na nà dhu mà kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Obhó tɨ́, tsʉ̀nʉ-bvʉ rɔ̌ nɨ́ ndɨ ka kɔzʉ́ya nyɨ obhónángatálɛ tɨ́, ndɨrɔ̀ tsʉ̀nʉ-bvʉ rɔ̌ nɨ́ ndɨ ka kɔtdɨ́ya anya dʉ̀nʉ́.» ");
INSERT INTO niy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wɔ̀ dhu-dzidɔ̌, Músà bhà Ʉyátá tɔ́ ngúfe màlímó mà, ngúfe Pbàfàrìsáyó mànà náatɨ Yěsù nɨ̌: «Màlimǒ, mǎ mòzè nyɔnzɨ̀ wɨwɨ̀ ndɨ́nɨ̌ mǎ mala tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Indo arɨ́’ɨ̀ alɛ narɨ́ nzɛ́rɛ alɛ, ndɨrɔ̀ abádhí náarɨ́ nzɨ̌ Kàgàwà ózè dhu ɔ̀nzɨ. Abádhí òzè kɔnzɨ̀ wɨwɨ̀ kɛ̀lɛ̌ fɨ̌yɔ̀, nɨ́ ka kɨ́ nzɨ̌ atdí wɨwɨ̀ mà nɔ́nzɨ abádhí tɔ̀. Pbɛ́tʉ̀, abádhí tɔ̀ ka kávǐna dhu nɨ́ nabì Yɔ̌nà rɔ̌ ndɨ̀ nanzɨ̀ wɨwɨ̀ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Àdhàdhɨ̀ nabì Yɔ̌nà náadhɔ̀ ɨ̀bhʉ ɨdhɔ ádrʉ̀ngbǎ ɨ̀bhɛ̌-yà-ba ɔ̀ dhu bhěyi tɨ́, nɨ́ ndɨ dhu bhěyi tɨ́, Ìndrǔ t’ídhùnà nɔ́ɔdhɔ́ya ɨ̀bhʉ ɨdhɔ adzɨ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nabì Yɔ̌nà rʉ̌nɔna Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ ɨ̀ ɨ̀rɨ̀ rɔ̀, Nìnawè tɔ́ kɨgɔ̀ ɔ̌ bhà nʉ́ʉgɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̌yɔ́ nzɛ́rɛnga. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, Nìnawè ɔ̌ bhà nɨ́ɨvàya ɨ̀ ’ìkò indo arɨ́ alɛ-nyɨ̀kpa rɔ̌, ’àdʉ̀ abádhí-ànyǎ nɨ́tdɨ̀. Ndɨrɔ̀ yà ɔnzɨ̀kʉ́ ìdè alɛ nósè wà Yɔ̌nà dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Músùngú dɔ̀nǎ rɔ̀ arɨ́’ɨ̀ Sabà tɨ́ kátɨna pbìrì ɔ̌ tsìbhá ádrʉ̀ngbǎ kamà nɨ́ɨra yà adzɨ-tsʉ̀ ɔ́dɨ̀ ndɨ̀ ɨ rɔ̀, ndɨ̀rà yà dhu-ɔ̌nga t’óvòta nʉnɨ ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ rʉ̌nɔna ɔtɛ nɨ́rɨ̀. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, ɨ́yàdhíyà nɨ́ɨvàya ndɨ̀, ndìdè indo arɨ́ alɛ-nyɨ̀kpa rɔ̌, ndàdʉ̀ abádhí-ànyǎ nɨ́tdɨ̀. Pbɛ́tʉ̀, yà ɔnzɨ̀kʉ́ ìdè alɛ nósè wà Sɔ̀lɔ̀mɔnɨ̀ dɔ̀nǎ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nzɛ́rɛ-alafí náapɛ́ àhʉ atdí alɛ ɔ̀ rɔ̀, nɨ́ kà rǎdʉ̀ àrà, ndùbhi rʉ̀ngʉ̀ ɔ̀nǎ, ndàmbɛ ndɨ̀ ndárà ndàso rɔ́nga nɔ́mɛ̀ dɔ̌, ɨ̀nzɨ̌ ndàdʉ̀ àbànà. ");
INSERT INTO niy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nɨ́ kà rǎdʉ̀ àtɨ̀nà afína ɔ̀: ‹Ma mɨ́ madǔ yà ma mahʉ̀ ɔ̀nà rɔ̀ pbàkà ɨdza ɔ̀.› Ányɨ̀ kàdu ndɨ̀ rɔ̀, kà rɨ̌ ndɨ ɨdza nótù tɨ́rɔ̌rɔ̀, ɨwà ka kàtsù ɔ̀nánga, kadʉ̀ ɔ̀bhɔ̀lɔ̀nà mběyi nyʉ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɨ́rɔ̀ nɨ́ ndɨ kà rǎdʉ̀ àrà àrʉ̀bhʉ̀ ngʉ̌kpà nzɛ́rɛ-alafí, yà atdídɔ̌ ɔ̀rʉ̀ ròsè dɔ̀na nǎ núnzì, ’ìwǔ òtsù mànà atdíkpá ndɨ alɛ ɔ̀. Nɨ́ wɔ̀ dhu-dzidɔ̌, ndɨ alɛ bhà ɔ́fɔ̀ rǎdʉ̀ ɨ̀’ɨ̀ nzɛ́rɛ nyʉ́ ròsè yà angyi ɨ’ɨ̀ kàbhà ɔ́fɔ̀ dɔ̀nǎ. Nɨ́ ndɨ dhu nɨ́ɨ’ɨya ndɨ dhu bhěyi tɨ́ yà indo arɨ́ nzɛ́rɛ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yěsù rɨ̌ dhu ɔ̀vɔ ìndrǔ tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kà-tsánà mà kà t’ádɔ́na mànà níiwú ùvò kà rɨ̌’ɨ̀ ɔ̀nà ɨdza-lí. Nɨ́ abádhí níitsi iko irinǎ rɔ̀, ’àdʉ̀ ’òzè ndɨ́nɨ̌ ɨ̀ ɔtɛ tɨ́ Yěsù nà. ");
INSERT INTO niy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɨ́ atdí alɛ náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ɨ́yànʉ mà adɔ́nʉ mànà rɨ̌’ɨ̀ irí, nɨ́ abádhí òzè ’ɔ̀tɛ̀ ɨnyɨ nà.» ");
INSERT INTO niy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nɨ́ Yěsù adʉ̀ dhu ìvu ndɨ alɛ-tsʉ̌ ndàtɨ: «Ɨ́yàdu nɨ́ àdhɨ, ndɨrɔ̀ adɔ́du nɨ́ àdhɨ mà?» ");
INSERT INTO niy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tdɨ́tdɔ̌ kǎdʉ̀ pbɨ̀ndà ábhàlɨ̌ nɨ́tɛ̀ ɔtsʉ́na nɨ̌, ndàdʉ̀ àtɨ̀nà: «Kànɨ̌ ɨ́yàdu mà, adɔ́du mànà. ");
INSERT INTO niy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Obhó tɨ́, adɔ̀du, awɛ̀du, ndɨrɔ̀ ɨ́yàdu nɨ́ yà ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà ózè dhu ɔ̀nzɨ arɨ́ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ndɨ nɨ́nganɨ́ tɨ́, Yěsù náahʉ̀ ɨdza rɔ̀, ndàdʉ̀ àrà àdɨ rɛ̀rʉ̀-bɨdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nɨ́, ádrʉ̀ngbǎ ihé-yà nyʉ́ núundu ɨ̀, ɨ̀ ràkpɔ̀rɔ̀ kà-ngbɔ̀. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kǎdʉ̀ ùpo, ndàdɨ ibhú ɔ̀. Ihé-yà náadʉ̀ òko rɛ̀rʉ̀-bɨdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yěsù nʉ́ʉnɔ ábhɔ̌ dhu nyʉ́ abádhí tɔ̀ mbólí ɔ̌, ndàtɨ: «Atdí alɛ náahʉ̀ ndàmbɛ ɔ̀nyʉ̀-tsè nɔ́rɛ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nɨ́ yà ɔ̀nyʉ̀-tsè nɔ́rɛ kà rɨ̌ pbɨ̀ndà ɨnga ɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdídhená itse náawà ɨ̀ otu-gì dɔ̌. Nɨ́ àrɛ̀ náadʉ̀ ìwu, ’ùbhǐ ɨ itse otu-gì dɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ngʉ̌kpà-tsí náadʉ̀ ’àwà ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ abhɔ dɔ̀ná odu-kɛngɛrɛ dɔ̌. Ɨ itse nɨ́ɨnga kòmbómbí, ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ abhɔ tsìyà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pbɛ́tʉ̀, adyifɔ̀ níitdègu ɨ̀ka, nɨ́ kǎdʉ̀ wɔ̀ ɨ̀ngɨngà ɔ̀nyʉ̌-nzo nʉ́bɨ̀, ràdʉ̀ òtdyù, ɨnzá ɨvɛ́ya nótsù ádzàdzǐ adzɨ ɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Atdídhená itse náawà ɨ̀ okpèya nà itsukpó-nzo nzínzì ɔ̌. Ɨ okpèya nà itsukpó-nzo náadʉ̀ òvi kòmbómbí, ’àdʉ̀ wɔ̀ ɨ̀ngɨngà ídzì ɔ̀nyʉ̀ nʉ́tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pbɛ́tʉ̀ ngʉ̌kpà itse náawà ɨ̀ ídzì adzɨ ɔ̌. Nɨ́ ɨ itse-tsí náa’ɔ̀, atdídhená rɔ̀dhɨ̀ atdátdí mɨyà itse, ngʉ̌kpà rɔ̀dhɨ̀ azàzá kumì itse, ndɨrɔ̀ ngʉ̌kpà ràdʉ̀ ɨbhɨ̀bhʉ́ kumì itse nɔ́dhɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ihé-yà nɨ̌: «Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ nákǎ ndɨ̀rɨ̀ yà ma mʉ́nɔna dhu mběyi!» ");
INSERT INTO niy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wɔ̀ dhu-dzidɔ̌ nɨ́ ndɨ, Yěsù bhà ábhàlɨ̌ náandrì kà-tɨ’ɔ̀, ’àdʉ̀ dhu nívu kà-tsʉ̌ ’àtɨ: «Ádhu nyɨ nyarɨ́ dhu nʉ́nɔ ihé-yà tɔ̀ mbólí ɔ̌ tɨ́ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Kàgàwà nábhʉ wà nyɨ̌ nyʉ̌nɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà bhà idzi-nyʉtsì ndɨ̀ nórù dhu, pbɛ́tʉ̀ abádhí nʉ́nɨ nzá ka. ");
INSERT INTO niy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Obhó tɨ́, dhu nà arɨ́’ɨ̀ alɛ tɔ̀, ka kabhʉ̀ya dhu abhɔ, ràdʉ̀ ɨ̀’ɨ̀ dhu nà abhɔ nyʉ́ ròsè. Pbɛ́tʉ̀, akɛkpá arɨ́’ɨ̀ dhu nà alɛ, nɨ́-fɔ́ rɔ̀ ka kakɔ̀ya ndɨ ákɛ̌ fɛ́nángba mà kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma márɨ́ dhu nʉ́nɔ abádhí tɔ̀ mbólí ɔ̌, ndɨ́nɨ̌ abádhí nóowu tɨ́ ɨnga nándà rɔ̀, ɨ̀nzɨ̌ ’àdʉ̀ dhu nála. Abádhí nóowu tɨ́ bɨ̌ya nɨ́kpɛ̀lɛ̀ rɔ̌, ɨ̀nzɨ̌ ’àdʉ̀ dhu nɨ́rɨ̀, ndɨrɔ̀ ɨ̀nzɨ̌ ndɨ dhu ràdʉ̀ dɔ̀ya nálʉ. ");
INSERT INTO niy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ndɨ dhu bhěyi nɨ́ ndɨ, nabì Ìsayà nʉ́ʉnɔ dhu rǎdʉ̀ àkǎ. Kǎtɨ: Kàgàwà rǎtɨna: ‹Nyɨ̌ nyɨ́ ɨnga nɨ́rɨ ɨ̀rɨ mběyi nyʉ́, pbɛ́tʉ̀ ɨ̀nzɨ̌ yà nyɨ̌ nyɨ̀rɨ̀ dhu ràdʉ̀ dʉ̀kʉ àlʉ akɛkpá màtɨ́. Nyɨ̌ nyɨ́ ɨnga nándà àndà mběyi nyʉ́, pbɛtʉ̀ ɨ̀nzɨ̌ nyǎdʉ̀ atdí dhu mà nála. ");
INSERT INTO niy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Obhó tɨ́, atdí dhu mà náarɨ́ nzɨ̌ kàrɨ́ alɛ-afí-ngbɔ̀ nʉ́bɛ̀lɛ̀. Abádhí nʉ́rɨ̌ bɨ̌ya, ndɨrɔ̀ abádhí núpbǐ nyɨ̀kpɔ́ya, akyɛ ɨ̀ alana nga nɨ̌, akyɛ ɨ̀ ɨrɨna nga nɨ̌, ndɨrɔ̀ akyɛ dhu alʉ́na dɔ̀ya, ’àdʉ̀ ’ʉ̀gɛ̀rɛ̀ ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga, madʉ̀ ɨ̀ nɨ́gʉ nɨ̌.› ");
INSERT INTO niy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pbɛ́tʉ̀, nyɨ̌ nɨ́ ndɨ hirò nyɨ̌ nyɔ́nzɨ̀, yà nyɨ̀kpɔ́kʉ náarɨ́ ɨnga nálǎ, ndɨrɔ̀ bɨ̌kʉ ràdʉ̀ ɨnga nɨ́rɨ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, ibí pbànábí mà, obhónánga ɔ̀nzɨ arɨ́ alɛ mànà, náazè ’àla yà kombí nyɨ̌ nyálǎna dhu, pbɛ́tʉ̀ abádhí náadʉ̀ nzá kàla. Abádhí náazè ’ɨ̀rɨ̀ yà nyɨ̌ nyɨ́rɨna kòmbí dhu, pbɛ́tʉ̀ abádhí náadʉ̀ nzá kɨ̀rɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̀rɨ pɛ́ yà ɔ̀nyʉ̀-tsè nɔ́rɛ rɨ́ alɛ tɔ́ mbólí-tɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà rɨ̌ idzi ɔ̀nyʉ ìndrǔ dɔ̌ dhu dɔ̌ ka kʉ́nɔna dhu nɨ́rɨ rɨ́ alɛ, ɨ̀nzɨ̌ ndɨ dhu ràdʉ̀ dɔ̀ya àlʉ, nʉ́lɨ ɨ̀ yà itse náawà ɨ̀ ɔ̀yá otu-gì-dɔ bhěyi. Pfɔ̀mvɔ rǎdʉ̀ ɨ̀rà, ndàdʉ̀ yà abádhí-afí ɔ̀ ka kòzò ɔtɛ nʉ́wa abádhí-afí ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ yà itse náawà ɨ̀ ɔ̀yá, ɨ̀mbǎ ábhɔ̌ adzɨ nà dɔ̀ná odu-kɛngɛrɛ-dɔ bhěyi. Abádhí rɨ̌ Kàgàwà bhà ɔtɛ nɨ́rɨ, ’àdʉ̀ àkɔnà dhɛ̀dhɛ nyʉ́ nà ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Abádhí rɨ̌ nzɨ̌ àdʉ̀ kàbhʉ ɨvɛ́na rɔ̀dɨ̀ ndɨ̀ afíya ɔ̀. Pbɛ́tʉ̀, abádhí rǎdʉ̀ ɨ̀ àpba ndɨ ɔtɛ rɔ̌ ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́. Nɨ́ yà àpbɛ̀ mà, avuta mànà nɔ́pɛ̀ ɨ̀ Kàgàwà bhà ɔtɛ-okú dɔ̀ rɔ̀ rɔ̀, abádhí rǎdʉ̀ fɨ̀yɔ́ a’uta nʉ́bhà ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ngʉ̌kpà alɛ-tsí tdɨ́tdɔ̌, nʉ́lɨ ɨ̀ yà itse náawà ɨ̀ nzínzìya ɔ̌ okpèya nà itsukpó-nzo bhěyi. Abádhí rɨ̌ Kàgàwà bhà ɔtɛ nɨ́rɨ, pbɛ́tʉ̀ yà adzɨ ɔ̌ ɨrɛ̀ta mà, yà adzɨ dɔ̌ ònzì náarábhʉ̌na tɨ̀tɔ̀ tɔ̀ dhɛ̀dhɛ mànà dhu ràdʉ̀ ndɨ ɔtɛ nʉ́tsɨ̀ ɨ̀nzɨ̌ rɔ̀dhɨ̀ itse. ");
INSERT INTO niy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ndɨrɔ̀, ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ yà itse náawà ɨ̀ ɔ̀ná ídzì adzɨ bhěyi. Ɨ̀ alɛ náarɨ́ Kàgàwà bhà ɔtɛ nɨ́rɨ, ’àdʉ̀ à’ùnà. Ndɨrɔ̀ abádhí nɨ́ ɨ itse ɔ̀dhɨ̀ rádʉ̀: atdídhená rɔ̀dhɨ̀ ka atdátdí mɨyà, ngʉ̌kpà rɔ̀dhɨ̀ ka azàzá kumì, ndɨrɔ̀ ngʉ̌kpà-tsí ràdʉ̀ ɨbhɨ̀bhʉ́ kumì nɔ́dhɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wɔ̀ dhu-dzidɔ̌, Yěsù náawɛ ngǎtsi mbólí ihé-yà tɔ̀ ndàtɨ: «Kànɨ̌ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɔ́fɔ̀ ndɨ̀ nà dhu: Atdí alɛ náazò ídzì nganʉ̀-tsè pbɨ̀ndà ɨnga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nɨ́ atdíku kúbhingánǎ, ɨdhɔ ɔ̀ kɔ́rɔ́ alɛ rɨ̌’ɨ̀ rɔ́rɔ̀, òmvǔ nɨ́ɨra, ndòzò nzɛ́rɛ ɨrɨ́-tɨdɔ̀ tɔ́ itse ndɨ nganʉ̀ nzínzì ɔ̌, ndàdʉ̀ àrà. ");
INSERT INTO niy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wɔ̀ nganʉ̀ níitdègu ɨnga, ndòvì, ndàdʉ̀ ndìtù, nɨ́ wɔ̀ nzɛ́rɛ ɨrɨ́-tɨdɔ̀ náadʉ̀ ɨ̀nga, ndòvì átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nɨ́ wɔ̀ ɨnga-àbadhi bhà kasʉtálɛ níiwú kà-tɨ’ɔ̀, ’ìvǔ dhu kà-tsʉ̌, ’àtɨ: ‹Ádrʉ̀ngbǎlɛ́, nyɨ nyazò ɨnga ɔ̌ dhu nɨ’ɨ̀ tɨ́ obhó ídzì nganʉ̀-tsè? Olu, wɔ̀ nzɛ́rɛ ɨrɨ́-tɨdɔ̀ nádʉ̀ ɨ̀rà àdhà rɔ̀?› ");
INSERT INTO niy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wɔ̀ ɨnga-àbadhi náadʉ̀ dhu àdu kasʉtálɛ tɔ̀ ndàtɨ: ‹Òmvǔ nɨ́ ndɨ wɔ̀ dhu nɔ́nzɨ̀.› Kɔ̌kɔ̀ kasʉtálɛ náadʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌ ’àtɨ: ‹Nyɨ nyòzè tɨ́ nzá mǒwù ɨ nzɛ́rɛ ɨrɨ́ nɔ́drʉ̀?› ");
INSERT INTO niy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nɨ́ ɨnga-àbadhi náadʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: ‹Ɨnzá ma mòzè nyǒwù kɔ̀drʉ̀, akyɛ nyɨ̌ nyadʉ̀na nganʉ̀ nɔ́kpɔ̀ átɔ̀ kɔ̀drʉ nyɨ̌ nyɨ́ rɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nyìtse pɛ́ abádhí rovi atdíkpá, ràrà àhʉ nganʉ̀ nótsè ka kowuya ɔ̀ná ɨdhɔ ɔ̀. Ndɨ nɨ́nganɨ́ nɨ́ ndɨ ma matɨya nganʉ̀ nótse rɨ́ alɛ nɨ̌: Nyɔ̀drʉ pɛ́ wɔ̀ nzɛ́rɛ ɨrɨ́ nyʉ̌tsɨ̀ dɔ̀na tɨ́, ndɨ́nɨ̌ kʉbɨ̀ tɨ́ kàzʉ ɔ̀. Ndɨrɔ̀, nyàdʉ̀ nyòtse nganʉ̀, nyàdʉ̀ ùndunà nyʉ̌lɨ ɔ́ngɔ̀lɨ̌ ɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tdɨ́tdɔ̌, Yěsù adʉ̀ ngǎtsi mbólí náwɛ ihé-yà tɔ̀, ndàtɨ: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ pbɨ̀ndà ɨnga ɔ̌ atdí alɛ níidyi ndòzò hàràdalɨ̀-kpɔ̌ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndɨ hàràdalɨ̀-kpɔ̌ nɨ́ ákɛ̌kpá dhu-tʉ́tʉ̌-ngba nyʉ́ kɔ́rɔ́ itse nzínzì ɔ̌. Pbɛ́tʉ̀ kǎpɛ́ ɨ̀nga, ndàdʉ̀ òvi, nɨ́ kǎrádʉ̀ òse yà ɨnga ɔ̌ ka karɨ́ òzòna kɔ́rɔ́ itsukpó dɔ̀nǎ. Ndɨrɔ̀, kǎrádʉ̀ òngo itsú-yà-ba tɨ́, àrɛ̀ mà ràdʉ̀ òwu ɨdzàya nɔ́sɨ̀ rɔ̌ ɔpbɨ́na nzínzì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yěsù adʉ̀ yàrɨ́ ngǎtsi mbólí náwɛ tdɨ́tdɔ̌ abádhí tɔ̀, ndàtɨ: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ yà tsìbhálɛ rǐdyina ndàngbǒ nganʉ̀-ra tɔ́ ɔ́yɔ̌ kumì dɔ̀ná imbò nà kìlo ɔ̀ afi bhěyi. Nɨ́ ndɨ dhu rǎdʉ̀ ndɨ idyi nábhʉ rɨ̀vʉ̀ kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yěsù náawɛ kɔ́rɔ́ kɔ̀rɨ́ dhu mbólí ɔ̌ ihé-yà tɔ̀. Kǎránà nzɨ̌ atdí dhu mà nʉ́nɔ̀ rɔ̌ abádhí tɔ̀ ɨnzá ndɨ̀ ndàwɛ mbólí ɔ̌ rɔ́rɔ̀, ");
INSERT INTO niy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ndɨ́nɨ̌ Kàgàwà bhà nabì nʉ́ʉnɔ dhu náaká tɨ́. Kǎtɨ: «Ma mʉnɔya dhu abádhí tɔ̀ mbólí ɔ̌, ndɨrɔ̀ ma mawɛya yà ɔ̀dhʉ̌ ɔ̀ aróko yà Kàgàwà anzɨ̀na yà adzɨ ɔ̀ná ɨdhɔ ɔ̀ rɔ̀ kɔ́rɔ́ dhu abádhí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wɔ̀ dhu-dzidɔ̌, Yěsù nʉ́ʉbhà wɔ̀rɨ́ ihé-yà, ndàdʉ̀ òtsù ɨdza. Nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ òtsù kà-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Áwɛ̌ pɛ́ wɔ̀ ɨnga ɔ̌ ɨnga nzɛ́rɛ ɨrɨ́-tɨdɔ̀ tɔ́ mbólí-tɨ̀ fǎkà.» ");
INSERT INTO niy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yà ídzì itse òzò rɨ́ alɛ nɨ́ Ìndrǔ t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Itse òzò ka kɨ́ ɔ̀ná ɨnga nɨ́ yà adzɨ. Ndɨ ídzì itse nɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà rɨ̌ idzi ɔ̀nyʉ dɔ̀yá alɛ. Nzɛ́rɛ ɨrɨ́-tɨdɔ̀ nɨ́ Nzɛ́rɛ alɛ, Pfɔ̀mvɔ bhà inzo. ");
INSERT INTO niy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yà ndɨ nzɛ́rɛ ɨrɨ́-tɨdɔ̀ nózò òmvǔ nɨ́ Pfɔ̀mvɔ. Nganʉ̀ nótse ka kɨ́ ɨnga ɔ̌ rɔ̀ dhu nɨ́ yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ ɔ̀ná ɨdhɔ. Ndɨrɔ̀, nganʉ̀ òtse rɨ́ alɛ nɨ́ Kàgàwà bhà màlàyíká. ");
INSERT INTO niy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nɨ́ àdhàdhɨ̀ ka karɨ́ nzɛ́rɛ ɨrɨ́ núndǔ ɨnga ɔ̌ rɔ̀ kʉbɨ̀ kàzʉ ɔ̀ dhu bhěyi, ndɨ dhu ɔnzɨya ndɨ̀ ndɨ dhu bhěyi tɨ́, yà adzɨ ɔ̌ dhu-tsʉ̀ rǐtsi ndɔ̀dɨ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nɨ́, Ìndrǔ t’ídhùnà náavìya pbɨ̀ndà màlàyíká rìwǔ yà ngʉ̌kpà alɛ nábhʉ̌ arɨ́ rɔ̀nzɨ̀ nzɛ́rɛnga alɛ mà, yà nzɛ́rɛnga nɔ́nzɨ arɨ́ alɛ mànà nípfo pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ idzi ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɨ màlàyíká náadʉ̀ya abádhí náwà yà ɨ̀nzɨ̌ arávɛ dhòdhódhónga nà kàzʉ ɔ̀. Ányɨ̀ nɨ’ɨya ɔdzɨ mà, alɛ-kù t’átrita mànà. ");
INSERT INTO niy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nɨ́, obhónángatálɛ náambɛ̀ya ʉ̀mbɨlɨ dɔ̌ adyifɔ̀ bhěyi ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbayà Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ idzi ɔ̌. Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ, nákǎ ndɨ̀rɨ̀ yà ma mʉ́nɔna dhu.» ");
INSERT INTO niy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tdɨ́tdɔ̌ Yěsù atɨ: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ ɨnga ɔ̀ ndɨ̀ nórù ábhɔ̌ odzìna nà dhu bhěyi. Atdí alɛ náapɛ́ kàbà, nɨ́ ndɨ alɛ rǎdʉ̀ kìdyì, ndòrù tdɨ́tdɔ̌ ndɨ ɨnga ɔ̌ tɨ́. Wɔ̀ dhu-dzidɔ̌, ábhɔ̌ dhɛ̀dhɛ-okú dɔ̀ rɔ̀, kà rǎdʉ àrà, ndùdzǐ kɔ́rɔ́ fɔná arɨ́’ɨ̀ dhu-tsí, ndàdʉ̀ ɨ̀rà ndɨ ɨnga nódzì fɨ̌ndà.» ");
INSERT INTO niy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wɔ̀ dhu-dzidɔ̌, Yěsù atɨ ihé-yà nɨ̌: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ ʉ̀yʉ̌ya yɔ̀kpɔ́ nɔ́mɛ rɨ́ ndòdzì dhu t’údzítátálɛ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɔrʉ́ odzìna rɨ̌’ɨ̀ atdí yɔ̀kpɔ́ ndɨ̀ ndàbà rɔ̀, nɨ́ kà rǎdʉ̀ àrà, ndùdzǐ kɔ́rɔ́ fɔná arɨ́’ɨ̀ dhu, ndàdʉ̀ ndɨ yɔ̀kpɔ́ nódzì.» ");
INSERT INTO niy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ rɛ̀rʉ̀ ɔ̀ ka kùpe ɨ̀bhɛ̀ t’óhota tɔ́ imbi bhěyi. Ndɨ imbi rǎdʉ̀ kɔ́rɔ́ ɨ̀bhɛ-tɨdɔ̀ nɔ́tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kǎpɛ́ àle ɨ̀bhɛ̀ nɨ̌, nɨ́ ka nùpenà alɛ rǎdʉ̀ kàdhà, ’ìpfo ɨdha-bɨdɔ̀, ’àdʉ̀ òko obvò ɨ̀bhɛ̀-ɔ̌nga t’óvòta tɔ̀. Abádhí rǎdʉ̀ ídzì ɨ̀bhɛ̀ nʉ́dɔ fɨ̌yɔ́ sɛ̌ngɛ̀ ɔ̀, ’àdʉ̀ nzɛ́rɛ-tsí náwà. ");
INSERT INTO niy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dhu ɔnzɨya ndɨ̀ ndɨ dhu bhěyi tɨ́ yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ nɨ́nganɨ́. Kàgàwà bhà màlàyíká níiwúya, ’àdʉ̀ nzɛ́rɛnga ɔ̀nzɨ arɨ́ alɛ nípfo obhónángatálɛ nzínzì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abádhí náadʉ̀ya ɨ nzɛ́rɛngatálɛ náwà ɨ̀nzɨ̌ arávɛ dhòdhòdhónganà kàzʉ ɔ̀. Ányɨ̀ nɨ’ɨya ɔdzɨ mà, alɛ-kù t’átrita mànà.» ");
INSERT INTO niy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ dhu ìvu pbɨ̀ndà ábhàlɨ̌-tsʉ̌, ndàtɨ: «Yà ma màwɛ kɔ́rɔ́ dhu nálʉ̌ tɨ́ wà dʉ̀kʉ?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Ɨwà dɔ̀ka nàlʉ̌.» ");
INSERT INTO niy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɨ́ Yěsù adʉ̀ atɨ̀nà abádhí nɨ̌: «Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ɔ̀rʉ̀-akpà ɔ̀ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi dɔ̌ ka kúdhe dhu fɨ̌ndà Músà bhà Ʉyátá tɔ́ atdí màlimò, rǎdʉ̀ ndɨ̀lɨ atdí ɨdza-àbadhi, yà pbɨ̀ndà ongyéngá nɔ́dɔ ndɨ̀ ndarɨ́ ɔ̀nà dhu ɔ̀ rɔ̀ arɨ́ dhu-ɔwʉ́tá mà, dhu-ayɨ́ mànà nípfǒ bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yěsù níitdègu kɔ̌kɔ̀ mbólí t’áwɛta nɨ́tɔ, nɨ́ kǎdʉ̀ ndɨ̀và ndàrà ányɨ̀rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kǎdʉ̀ àrà yà ndɨ̀ ndavì ɔ̀ná kɨgɔ̀ ɔ̀. Kǎdʉ̀ ndɔ̀pɛ̀ ndàrà dhu núdhe rɔ̌ ìndrǔ tɔ̀ fɨ̀yɔ́ unduta-dzà ɔ̌ rɔ̀. Nɨ́ yà kà rʉ̌nɔna dhu nɨ́rɨ rɨ́ alɛ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. Abádhí náambɛ́nà àtɨ̀nà dɔ̌: «Wɔ̀ ɨnga t’ʉ́nɨta-tɨdɔ̀ mà wɨwɨ̀ t’ɔ́nzɨta tɔ́ ɔbɨ mànà nɨ́ kǎbà àdhà? ");
INSERT INTO niy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ka tɨ́ obhó sàpàtɨ t’ídhùnà? Kà-tsánà-ɔvɔ̀ tɨ́ obhó Màrɨyà? Ndɨrɔ̀, kà t’ádɔ́na tɨ́ obhó Yàkɔbhɔ̀ mà, Yɔ̀zɛfʉ̀ mà, Sìmonì mà, Yudhà mànà? ");
INSERT INTO niy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ndɨrɔ̀ kɔ́rɔ́ kà t’áwɛ́na nátɨ́ obhó òko ɨrɔ́ àlɛ̌-nzínzì ɔ̌? Nɨ́ kɔ́rɔ́ kɔ̌kɔ̀ dhu kǎbà àdhà?» ");
INSERT INTO niy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nɨ́ wɔ̀ dhu-okú dɔ̀ rɔ̀, abádhí nóowúnà nzɨ̌ kà rʉ̌nɔna dhu ná’ù rɔ̌. Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nabì nɨ́fʉ̌ ka karɨ́ kɔ́rɔ́ ngari ɔ̌. Pbɛ́tʉ̀, ndɨ̀ nyʉ́ ka kadhɨ̀ ɔ̀ná kɨgɔ̀ ɔ̌, ndɨrɔ̀ fɨ̌-dzá bhà nzínzì ɔ̌, kǎrɨ́’ɨ̀ mbǎ ɨfʉta nà.» ");
INSERT INTO niy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nɨ́ wɔ̀ ɨ̀mbǎ abádhí rɨ̌’ɨ̀ a’uta nà dhu-okú dɔ̀ rɔ̀, Yěsù adʉ̀ nzá ábhɔ̌ wɨwɨ̀ nɔ́nzɨ̀ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hɛ̀rɔdɛ̀ nɨ́ɨ’ɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ lɨ̀walɨ̀ tɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, kɨ̌rɨ Yěsù dɔ̌ ka kʉ́nɔna dhu. ");
INSERT INTO niy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nɨ́ kǎdʉ̀ àtɨ̀nà pbɨ̀ndà kasʉtálɛ nɨ̌: «Bàtizò nubhónà Yùwanɨ̀ nɨ́ wɔ̀ ndɨ̀ nɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, kà rɨ̌’ɨ̀ wɨwɨ̀ t’ɔ́nzɨta tɔ́ ɔbɨ nà.» ");
INSERT INTO niy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wɔ̀ ndɨ Hɛ̀rɔdɛ̀ nɨ́ ndɨ ʉyátá nabhʉ̀ kosò Yùwanɨ̀, kadʉ̀ ʉ̀tsɨ̀nà kɨdɔ̀ imbi ɔ̀. Kǎnzɨ̀ ndɨ dhu, adɔ̀nà Fìlipò-ve, Hɛ̀rɔ̀diyà-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Obhó tɨ́, Yùwanɨ̀ ongónà àtɨ̀nà ɨnzá dhu ràkǎ Hɛ̀rɔdɛ̀ rìdyì Hɛ̀rɔ̀diyà venà tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nɨ́ wɔ̀ dhu-okú dɔ̀ rɔ̀, Hɛ̀rɔdɛ̀ nóongónà ndòzè ndàbhʉ Yùwanɨ̀ kohò. Pbɛ́tʉ̀, kǒngónà ihé-yà ɔdɔ̀ nɔ́nzɨ̀, kɔ́rɔ́ alɛ nʉ́ʉnɨ dhu Yùwanɨ̀ ràrɨ̌ Kàgàwà bhà nabì nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nɨ́ atdíku, Hɛ̀rɔdɛ̀ rɨ̌ ndɨ̀ ka kadhɨ̀ ɔ̀ná ɨdhɔ nɨ́rɛ̀ nɨ́nganɨ́, Hɛ̀rɔ̀diyà bhà tsìbhíngba náabɛ̀ yà Hɛ̀rɔdɛ̀ núnzìnà alɛ-ɔnzɨ̌, ndɨ ɔbɛ́ ràdʉ̀ Hɛ̀rɔdɛ̀-nyɨ̀kpɔ́ nɔ́fɔ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kǎdʉ̀ dhu ɔtsɔ̀ ndàtɨ, ndɨ̀ ràrɨ̌ kɔ́rɔ́ dhu-tsí yà ndɨ tsìbhíngba rǒnzina-fɔná nábhʉ̌ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nɨ́ ɨ́yànà ɔ̀vɔ̀ fɨ̌ndà dhu-okú dɔ̀ rɔ̀, ndɨ tsìbhíngba náadʉ̀ àtɨ̀nà Hɛ̀rɔdɛ̀ nɨ̌: «Íbhò bàtizò ùbhǒ arɨ́ Yùwanɨ̀-dɔ fudú ɨrɔ́ tsàlɨ̀tsalɨ̀ dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nɨ́ ɨzʉ nʉ́ʉka ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ atdídɔ̌ wɔ̀ dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, angyangyɨ ndɨ̀ ndɔ̀tsɔ̀nà dhu yà ndɨ̀ ndùnzìnà alɛ-ɔ̀nzɨ̌ rɔ̀ dhu-okú dɔ̀ rɔ̀, kǎdʉ̀ dhu ʉ̀ya ndɨ́nɨ̌ kabhʉ̀ tɨ́ Yùwanɨ̀-dɔ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nɨ́ kǎdʉ̀ atdí alɛ návi ràrà Yùwanɨ̀-dɔ nɔ́kɛ̀rɛ̀ imbi ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wɔ̀ alɛ adʉ̀ ɨ̀rà Yùwanɨ̀-dɔ nà tsàlɨ̀tsalɨ̀ dɔ̌ rɔ̀, ndàdʉ̀ àbhʉnà wɔ̀ tsìbhíngba-fɔ́, kà ràdʉ̀ àrà àbhʉnà ɨ́yànà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yùwanɨ̀ bhà ábhàlɨ̌ náadʉ̀ ìwu kǎ-bvò nídyì, ’òwù ɔ̀tdʉ̀nà. Abádhí adʉ̀ òwu wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu ɔ̀yɨ̌ nà Yěsù tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bàtizò nubhónà Yùwanɨ̀ nɔ́vɛ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù nɨ́ɨvà ndɨ̀ ʉrɔ́ rɔ̀ ibhú ɔ̌, ndàrà atdí rɔ̀ atdí rʉ̀ngʉ̀ tɨ́ rɨ́’ɨ̀ ngari ɔ̀. Pbɛ́tʉ̀, kà rǎrà dhu nɨ̀rɨ̀ ihé-yà náadʉ̀ ùvò fɨ̌yɔ́ kɨgɔ̀ ɔ̌ rɔ̀, ’òwù kǒwù ɔ̌ pfɔ̌ya dɔ̌, ɨdha-gì dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ibhú ɔ̀ rɔ̀ ndɨ̀ ndàhʉ rɔ̀, Yěsù náala ádrʉ̀ngbǎ ihé-yà, ndàdʉ̀ ɨzʉ nábà atdídɔ̌ abádhí dɔ̌. Nɨ́ kǎdʉ̀ ndɔ̀pɛ̀ ndɨ̀gʉ̌ abádhí ìwǔ nà andɨtálɛ. ");
INSERT INTO niy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pbɨ́tsɔ̀ngǎnǎ, Yěsù bhà ábhàlɨ̌ níiwú kà-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨnga nátɨ ɨwà, ndɨrɔ̀ ɨrɔ́ nga rɨ̌’ɨ̀ igi. Nɨ́ ávǐ kɔ̌kɔ̀ alɛ ràdʉ ɨ̀ pbanga-tsidɔ̀, ndɨ́nɨ̌ ɨ̀ udzí tɨ́ ɔ̀nyʉ̀ fɨ̌yɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nɨ́ Yěsù adʉ̀ dhu àdu pbɨ̀ndà ábhàlɨ̌ tɔ̀ ndàtɨ: «Ɨnzá dhu àkǎ abádhí ròwù pbanga-tsidɔ̀! Nyàbhʉ ɔ̀nyʉ̀ nyɨ̌-tɨ́rɔ̀ abádhí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pbɛ́tʉ̀, abádhí náadʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Ɔ̀nyʉ̀ tɨ́ mǎ mɨ́’ɨ̀ nà ɨrɔ́ dhu nɨ́ imbò mʉ̀gatì mà, ɔ́yɔ̌ ɨ̀bhɛ̀ mànà kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìwǔ ɨ dhu nà àzú fudu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù náadʉ̀ kɔ̀rɨ́ alɛ́-yà návi ròkò obvò ɨrɨ́ dɔ̌. Kǎdʉ̀ kɔ̌kɔ̀ imbò mʉ̀gatì núgù, ɔ́yɔ̌ ɨ̀bhɛ̀ mànà ndʉ̀lʉ̌ fɔná. Tdɨ́tdɔ̌ kǎdʉ̀ ɔ̀rʉ̀-akpà ɔ̀ nga nándà, ndàdʉ̀ Kàgàwà nónzì ràso ɨ dhu. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ mʉ̀gatì-ɔ̌nga nʉ́kɔ, ndùbho pbɨ̀ndà ábhàlɨ̌-fɔ́, abádhí ràdʉ̀ ʉ̀ndɔ̀nà ihé-yà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kɔ́rɔ́ alɛ náanyʉ̀ dhu, ɨ̀ rùlè nɨ̌ àkǎkǎ dhu-bvʉ̌. Wɔ̀ dhu-dzidɔ̌, Yěsù bhà ábhàlɨ̌ núundu ɔ̀dɔ̀dɨ̀ ɔ̀nyʉ̀-go-tsʉ̀, ɨ̀ rɨ̀rǎ ɨdrɛ dɔ̀ná ɔ́yɔ̌ nà sɛ̌ngɛ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dhu nanyʉ̀ alɛ-bvʉ nɨ’ɨ̀ mbɛ̀mbɛ̀ imbò lʉfʉ̀ kpabhálɛ, ɨnzá ka kɔ̀zʉ̀ vèbhálɛ mà, nzónzo mànà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Yěsù náavì pbɨ̀ndà ábhàlɨ̌ rùpò ibhú ɔ̀, ndɨ́nɨ̌ ada tɨ́ angyi fɨ̌ndà rɛ̀rʉ̀-adzè, ihé-yà návǐ ndɨ̀ ndɨ́ ràdu ɨ̀ ɨbha ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Abádhí ndɨ̀ ndàdu dhu lutɨ̀nǎ, kǎdʉ̀ ùpo pbìrì dɔ̀, ndàrà ndɨ̀tsɔ̀. Nɨ́ ɨnga nátɨ rɔ̀, kǎtù ndɨ̀ atdírɔ̀ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ibhú náadʉ̀ ɨ̀’ɨ̀ ɨwà ndɨ̀ ndàrà ɨtsɛ nyʉ́ ɨdha-bɨdɔ̌ rɔ̀ rɔ́. Mʉ̀kʉrà núubhínà ndʉ̀pbɨ̀ rɔ̌ ibhú rɔ̌, awɛ rǒpili tʉ̀mbà tɨ́ abádhí-nyɨ̀kpa rɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nɨ́ à’ʉ̌-akpà-ɔ̀ngɔ̌ ɔ̌, Yěsù adɨ̀ ndàmbɛ ɨ̀rà dɔ̌ pbɨ̀ndà ábhàlɨ̌-tɨ’ɔ̀ ɨdha dɔ̌ ndɨ̀ ndúbhi rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nɨ́, ɨdha dɔ̌ kà rǔbhi dhu ɨ̀ àla rɔ̀, ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ abádhí ɔ̀, ’àdʉ̀ àtɨ̀nà: «Mɨ̀gɨ̀ngɔ̀ nɨ́ yà!» Nɨ́ abádhí náapɛ̀ ’àmbɛ ùkǔ dɔ̌ ɔdɔ rɨ̌ ’ɔ̀nzɨ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù náadʉ̀ tǔna nápfò abádhí tɔ̀ ndàtɨ: «Nyòtù afíkʉ! Ɨma nɨ́ yà, ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ!» ");
INSERT INTO niy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɨnyɨ tɨ́ kǎpɛ́ ɨ̀’ɨ̀, nɨ́ ávǐ ma marà tɨnʉ ɔ̀ ɨdha dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ́rà nà!» Nɨ́ Pɛ́tɛrʉ̀ ifo ibhú ɔ̀ rɔ̀, ndàmbɛ ùbhi dɔ̌ ɨdha dɔ̌ Yěsù-tɨ’ɔ̀ ndɨ̀ ndárà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pbɛ́tʉ̀, awɛ rǒpili ɔbɨ nà dhu ndɨ̀ ndàla rɔ̀, ɔdɔ nɨ́ɨsɨ́ àbadhi ɔ̀. Nɨ́ ɨdha ɔ̀ ndɨ̀ ndɔ̀pɛ̀ ndòsù rɔ̀, kǎkù: «Ádrʉ̀ngbǎlɛ́ ɨ́gʉ̌ ma!» ");
INSERT INTO niy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Yěsù adʉ̀ ɔtsʉ́na nágbà, ndàlʉ̌ ka, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨnyɨ, ákɛ̌ a’uta nà alɛ, ádhu afínʉ rǔguru nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɨ́ abádhí náadʉ̀ ùpo ɔ́yɔ̌ rɔ̀ kɔ́rɔ́ ibhú ɔ̀, awɛ ràdʉ̀ opilita nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɨ́rɔ̀ nɨ́ ndɨ ibhú ɔ̀ ɨ̀’ɨ̀nà Yěsù bhà ábhàlɨ̌ nʉ́ʉkɔ ɨ̀ kɔ̀nzɨ̌, ɨ̀ rɨ̀fʉ ka, ’àdʉ̀ àtɨ̀nà: «Obhó nyʉ́, nyɨ nɨ́ Kàgàwà t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà níitdègu rɛ̀rʉ̀ náda, nɨ́ abádhí awù ùvo Gɛ̀nɛ̀zàretì tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndɨ pbìrì ɔ̌ bhà nʉ́ʉnɨ Yěsù. Nɨ́ abádhí náadʉ̀ ìndrǔ núvi ròwù dhu nɔ́vɔ̀ kɔ́rɔ́ kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ pbanga ɔ̀na nǎ. Nɨ́ ìndrǔ náadʉ̀ andɨ nà rɨ́’ɨ̀ kɔ́rɔ́ alɛ nʉ́mbà Yěsù-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Abádhí náadʉ́nà Yěsù nɨ́tdɛ̀ ɨ̀tdɛ̀ tɨ́ rʉ̀bhà ɨ andɨtálɛ rʉ̀pbàlǎ rɔ̀ná mʉ̀dzarʉ̀-bɨdɔ̀-ngbɔ̀ kɛ̀lɛ̌. Nɨ́ ka nʉ̀pbàlǎ alɛ nóowúnà ʉ̀gʉ rɔ̌ dòtsí. ");
INSERT INTO niy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wɔ̀ dhu-dzidɔ̌, Pbàfàrìsáyó mà Músà bhà Ʉyátá tɔ́ màlímó mànà níiwú Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, ’ìwǔ ùvò Yěsù-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ádhu pbʉ̀kʉ̀ ábhàlɨ̌ náarɨ́ nzɨ̌ àlɛ̌ t’ábhúna tɔ́ màndʉ nɨ́fʉ̌ nɨ̌? Obhó tɨ́, abádhí náarɨ́ nzɨ̌ ɔtsʉ́ya nú’ǒ tdʉ̌ ɨ̀ ɔnyʉ dhu rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ́, ndàtɨ: «Olu nyɨ̌, ádhu nyɨ̌ nyarɨ́ nzɨ̌ Kàgàwà bhà Ʉyátá nɨ́fʉ̌, pbɛ́tʉ̀ nyǎdʉ̀ abhúkʉ tɔ́ màndʉ kɛ̀lɛ̌ nɨ́fʉ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Obhó tɨ́, Kàgàwà náatɨ: ‹Ɨ́fʉ̌ àbanʉ mà ɨ́yànʉ mànà.› Ndɨrɔ̀ kǎtɨ: ‹Àbanà nɨ̌ ndɨrɔ̀ ɨ́yànà nɨ̌ màtɨ́ dhu nʉ̀nɔ̀ alɛ, nákǎ kohò, rɔ̀vɛ̀.› ");
INSERT INTO niy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyarɨ́ àtɨna, atdí alɛ rapɛ́ dhu ɔ̀vɔ kpangba àbanà tɔ̀, ndɨrɔ̀ ɨ́yànà tɔ̀ màtɨ́, ndàtɨ: ‹Dzʉ̀nànʉ nɔ́nzɨ ma màmbɛ̀nà nɨ̌ fudú rɨ́’ɨ̀ dhu, nɨ́ ma mùtri wà pɛrɛ̀ tɨ́ Kàgàwà tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nɨ́ ndɨ alɛ rɨ̌ mbǎ àbanà mà ɨ́yànà mànà dzʉ̀nà ɔ̀nzɨ ndɨ̀ ndɨ́ dhu-atdyú nà. Nɨ́ ndɨ dhu bhěyi, nyɨ̌ nyóhò wà Kàgàwà bhà Ɔtɛ fʉ̀kʉ́ màndʉ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nyɨ̌, ɔyɔyɔ ɨdàya nà alɛ́! Nabì Ìsayà nʉ́ʉnɔ obhó dhu nyʉ́ dʉ̀kʉ́, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Kàrɨ́ alɛ náarɨ́ mɨfʉ̌ tsʉ̀ya-kpɔ̀ dɔ̌ tɨ́, afíya ràdʉ̀ ɨ̀’ɨ̀ ɨtsɛ nyʉ́ rùdú rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yà abádhí arɨ́ mʉlɛ̌ nɨ̌ ʉlɛ́tá nɨ́ kɔkɔ́rɔ̀ nga tɔ́. Abádhí náarúdhěna ìndrǔ tɔ̀ nɨ́ ìndrǔ tɔ́ ʉyátá.›» ");
INSERT INTO niy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wɔ̀ dhu-dzidɔ̌, Yěsù anzi ihé-yà, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̀rɨ yà ma mʉ́nɔna dhu, nyǎdʉ̀ àlʉnà mběyi dʉ̀kʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ɨ̀nzɨ̌ nɨ́ alɛ-lí òtsù dhu ndɨ ìndrǔ nábhʉ rádʉ̀ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. Pbɛ́tʉ̀, ìndrǔ nábhʉ rádʉ̀ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ dhu nɨ́ ndɨ alɛ-li’ɔ̀ rɔ̀ àhʉ dhu.» ");
INSERT INTO niy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ ìndri kà-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyʉ̀nɨ tɨ́ wà Pbàfàrìsáyó-ɔ̌nga nɨ́wà ndɨ̀ tɨ́, wɔ̀ nyɨ nyʉ́nɔna dhu nɨ́rɨ ɨ̀ ɨ́ rɔ̀ dhu?» ");
INSERT INTO niy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Kɔ́rɔ́ itsukpó, yà ɨnzá ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà náazò nɨ́ ka kɔngbɛ́ya kɔ́rɔ́ ɨvɛ́ya mànà. ");
INSERT INTO niy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nyʉ̀bhà abádhí. Ndùmùndúmú nɨ́ kɔ̌kɔ̀ rɨ́ ndùmùndúmú nʉ́nda. Ndɨrɔ̀, atdí ndùmùndúmú náapɛ́ àmbɛ ngǎtsi ndùmùndúmú nʉ́ndà dɔ̌, nɨ́ abádhí rǎdʉ̀ ’àwà ɔ́yɔ̌ kɔ́rɔ́ ibhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Áwɛ̌ pɛ́ wɔ̀rɨ́ mbólí-tɨ̀ fǎkà.» ");
INSERT INTO niy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ̌ nyʉ́ mà, kàlʉ̌ tɨ́ obhó dʉ̀kʉ átɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nyɨ̌ nyʉ̀nɨ tɨ́ nzá dhu kɔ́rɔ́ dhu-tsí yà alɛ-lí rótsù, ràrǎdʉ̀ ʉ̀da alɛ ɔ̀, ndàdʉ̀ àhʉ alɛ ɔ̀ rɔ̀ ɔtsɔ́ dɔ̀ ka kòwù rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pbɛ́tʉ̀, alɛ-tsʉ̀ arórìna dhu nɨ́ alɛ-afí ɔ̀ rɔ̀ àhʉ dhu. Ndɨrɔ̀ ndɨ dhu nɨ́ ndɨ arádʉ̀ ìndrǔ àbhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Obhó tɨ́, ìndrǔ-afí ɔ̀ rɔ̀ nga nɨ́ ndɨ nzɛ́rɛ dhu náarúvò nɨ̌. Ɨ dhu nɨ́: nzɛ́rɛ ɨrɛ̀ta, abvo òho ka kɨ́ dhu, mʉ̀nyɔ̀nɨ̀ ɔ̀nzɨ ka kɨ́ dhu, màkunì ɔ̀nzɨ ka kɨ́ dhu, ogbo ɔ̀nzɨ ka kɨ́ dhu, tɨ̀tɔ̀ nʉ́nɔ ka kɨ́ alɛ t’ɔ́dhɨ́na dɔ̌ dhu, ndɨrɔ̀ ìndrǔ nɨ̌ ka kɨ́ dhu ʉ̀nɔ nzɛ́rɛ dhu mànà. ");
INSERT INTO niy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kɔ̀rɨ́ nɨ́ ɨ ìndrǔ àbhʉ rádʉ̀ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. Pbɛ́tʉ̀, ɔ̀nyʉ̀ nɔ́nyʉ ka kɨ́ ɨnzá ka kù’o alɛ-ɔtsʉ́ rɔ́rɔ̀ dhu, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ìndrǔ nábhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wɔ̀ dhu-dzidɔ̌, Yěsù nɨ́ɨvà ndɨ̀ ʉrɔ́ rɔ̀, ndàrà Tirò mà, Sìdɔnà mànà tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nɨ́ ndɨ pbìrì ɔ̌ arádɨ Kànanà tɔ́ pbìrì ɔ̌ atdí tsìbhálɛ nɨ́ɨra àhʉ Yěsù-tɨ’ɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndùkǔ, ndàmbɛ àtɨ̀nà dɔ̌: «Ádrʉ̀ngbǎlɛ, Dàwudì t’Ídhùnǎ, ábà ɨzʉ dùdú! Nzɛ́rɛ-alafí rǎvu atdídɔ̌ ɨvàdú-ngba rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pbɛ́tʉ̀ Yěsù adʉ̀ nzá atdí dhu mà nádu kà tɔ̀. Nɨ́ Yěsù bhà ábhàlɨ̌ náandrì Yěsù-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Ávǐ wɔ̀ tsìbhálɛ ràdu ndɨ̀ àlɛ̌-owù ɔ̌ rɔ̀, ìkǔ nà kà rǔbhi àlɛ̌-owù ɔ̌ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nɨ́ Yěsù adʉ̀ dhu àdu ábhàlɨ̌ tɔ̀, ndàtɨ: «Kàgàwà ívì ma Ìsràyelì tɔ́ pbìrì ɔ̌ bhà-okú dɔ̀ rɔ̀, kǎkà ùwǔwǐ tàmà bhěyi ɨ̀ nʉ́lɨ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pbɛ́tʉ̀, wɔ̀ tsìbhálɛ náadʉ̀ ɨ̀rà, ndɔ̀kɔ̀ ndɨ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɔ́nzɨ dzʉ̀nàdu!» ");
INSERT INTO niy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨnzá dhu ɔ̀fɔ̀ nga kidyì nzónzo tɔ́ ɔ̀nyʉ̀, kadʉ̀ òbvùnà ìtsě-nzo tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wɔ̀ tsìbhálɛ adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Wɔ̀ nyɨ nyʉ̀nɔ̀ dhu nɨ́ obhó dhu nyʉ́, Ádrʉ̀ngbǎlɛ́. Pbɛ́tʉ̀, ìtsě-nzo mà náarɨ́ abáya rɨ̌ dhu ɔ̀nyʉ dɔ̀ná rɔ̀ mɨzà dɔ̌ rɔ̀ ɨ̀ nàwà ɔ̀nyʉ̀-ú’ù nɔ́nyʉ.» ");
INSERT INTO niy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ìgyò! Yà tsìbhálɛ́, pbʉ̀kʉ̀ a’uta rɨ̌’ɨ̀ ádrʉ̀ngbǎ nyʉ́. Wɔ̀ nyɨ nyòzè dhu nákǎ ndɔ̀nzɨ̀ ndɨ̀ ɨndʉ̀ yà nyɨ nyʉ́ nyɨ nyòzè ka dhu bhěyi.» Nɨ́, wɔ̀ tsìbhálɛ t’ɨ́vànǎ-ngba náadʉ̀ ɔ̀gʉ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wɔ̀ dhu-dzidɔ̌, Yěsù nɨ́ɨvà ndɨ̀ ʉrɔ́ rɔ̀, ndàrà Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̀. Nɨ́ ányɨ̀ kǎdʉ̀ ùpo atdí pbìrì dɔ̀, ndàdʉ̀ àdɨ obvò. ");
INSERT INTO niy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɨ́rɔ̀ nɨ́ ndɨ abhàbhɔ́ alɛ nà ɔ̀yá ihé níiwú ngbɔ̌ya ʉ́vɛ kɔ́rɔ́ alɛ mà, ndùmùndúmú mà, otsutálɛ mà, ìwǐ mà, ndɨrɔ̀ ábhɔ̌ ngʉ̌kpà andɨtálɛ mànà nà ’ìwǔ ʉ̀lɨnà Yěsù-ɔ̀nzɨ̌, kà ràdʉ̀ abádhí ɨ̀gʉ. ");
INSERT INTO niy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɨ́ ɨdhɔ nʉ́ʉkɔ ihé-yà atdídɔ̌ nyʉ́ ìwǐ rɔ̌tɛ dhu, ngbɔ̌ya ʉ́vɛ alɛ-ngbɔ̀ rʉ̌gʉ dhu, otsutálɛ rǔbhi dhu, ndɨrɔ̀ ndùmùndúmú mà rɨ̌ ɨnga àlǎ dhu ɨ̀ àla rɔ̀. Nɨ́ abádhí náadʉ̀ ’ɔ̀pɛ̀ ɨ̀ rɨ̀fʉ Pbàìsràyélí tɔ́ Kàgàwà atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wɔ̀ dhu-dzi dɔ̌, Yěsù náanzi pbɨ̀ndà ábhàlɨ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ kǎkàrɨ́ alɛ-ɨzʉ ɔ̀nzɨ atdídɔ̌. Kɔ̀nɨ̌ mǎ mòkò ɨ̀bhʉku abádhí mànà mbàlìmbàlì, ndɨrɔ̀ abádhí rɔ̌nyʉna dhu rɨ̌’ɨ̀ mbǎ. Nɨ́ ma mòzè nzá mabhʉ abádhí ròwù ɨnzá dhu nɔ̀nyʉ̀ rɔ́rɔ̀, akyɛ sàzɨ̀ arana abádhí àbhʉ ràwà ɨ̀ otu ɔ̌ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Yàrɨ́ rʉ̀ngʉ̀ ɔ̌, àlɛ̌ kówu yà dhu bvʉ̌ tɨ́ ihé-yà nóngù àlɛ̌ kɨ́ nɨ̌ ɔ̀nyʉ̀ nábà àdhà?» ");
INSERT INTO niy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyɨ́’ɨ̀ mʉ̀gatì nà ìfe?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Àrʉ̀bhʉ̀, ndɨrɔ̀ ngúfe ɨ̀bhɛ̀ nzo mànà.» ");
INSERT INTO niy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ ihé-yà návi ròkò obvò. ");
INSERT INTO niy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ kɔ̌kɔ̀ àrʉ̀bhʉ̀ mʉ̀gatì mà, kɔ̌kɔ̀ ɨ̀bhɛ̀ mànà núgù ndʉ̀lʉ̌ fɔná, ndàdʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀. Tdɨ́tdɔ̌, kǎdʉ̀ kɔ̌kɔ̀ mʉ̀gatì-ɔ̌nga nʉ́kɔ, ndùbho pbɨ̀ndà ábhàlɨ̌-fɔ́, abádhí ràdʉ̀ ʉ̀ndɔ̀nà ihé-yà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kɔ́rɔ́ alɛ náanyʉ̀ dhu ’ùlè nɨ̌ àkǎkǎ dhu bvʉ̌. Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ ɔ̀dɔ̀dɨ̀ ɔ̀nyʉ̀-go-tsʉ̀ núndu, rùlè àrʉ̀bhʉ̀ sɛ̌ngɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dhu nanyʉ̀ alɛ-bvʉ nɨ’ɨ̀ ɨ̀fɔ lʉfʉ̀ kpabhálɛ, ɨnzá ka kɔ̀zʉ̀ vèbhálɛ mà nzónzo mànà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kɔ̀rɨ́ ihé-yà ndɨ̀ ndàvi ràdu ɨ̀ ɨbha dhu-dzidɔ̌, Yěsù adʉ̀ ùpo ibhú ɔ̀, ndàdʉ̀ àrà Màgàdanɨ̀ tɨ́ kátɨna pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pbàfàrìsáyó mà, Pbàsàdùkáyó mànà náawù ùvò Yěsù-tɨ’ɔ̀. Nɨ́ kà-afí ɨ̀ omvú tɨ́ nɨ̌, abádhí náavì ka rɨ̀tɛ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà atdí ize fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pbɛ́tʉ̀, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ɨnga rǎtɨ rɔ̀, nyɨ̌ nyáróngo àtɨ̀nà: ‹Igye rɨ̌ nzɨ̌ ɨ̀kɔ̌, ɔ̀rʉ̀-akpà-nyɨ̀-rɔ̌nga nílìlu tɨ́ nɨ́dhunɨ̌.› ");
INSERT INTO niy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ndɨrɔ̀ bhɔ̌tsʉngá, nyɨ̌ nyarádʉ̀ àtɨ̀nà: ‹Indo igye rǒgye ògye, ɔ̀rʉ̀-akpà-nyɨ̀-rɔ̌nga nɨ́tɨ̀ ɨ̀tɨ̀ tɨ́ nɨ́dhunɨ̌.› Nyɨ̌ nyʉ́nɨ dhu nɨ́ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ nyɨ̌ nyàla dhu rɨ̌tɛ̀na dhu kɛ̀lɛ̌, ɨ̀nzɨ̌ nyǎdʉ̀ ɨ̀rà rɨ́rà kàsʉmɨ̀ ɔ̌ rɨ́ ndɔ̀nzɨ dhu nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Indo arɨ́ alɛ nɨ́ nzɛ́rɛ alɛ, ndɨrɔ̀ abádhí náarɨ́ nzɨ̌ Kàgàwà ózè dhu ɔ̀nzɨ. Abádhí ózè kɔnzɨ̀ wɨwɨ̀ fɨ̌yɔ̀. Pbɛ́tʉ̀ ka kɨ́ nzɨ̌ atdí wɨwɨ̀ mà nɔ́nzɨ abádhí tɔ̀. Abádhí tɔ̀ ka kávǐna dhu nɨ́ nabì Yɔ̌nà rɔ̌ ndɨ̀ nanzɨ̀ wɨwɨ̀ kɛ̀lɛ̌.» Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ abádhí nʉ́bhà, ndàdʉ̀ àrà fɨ̀ndá dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà níitdègu ada rɛ̀rʉ̀-adzè, nɨ́ mʉ̀gatì nídyì ɨ̀ ɨ́ dhu náadzò Yěsù bhà ábhàlɨ̌ ɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɔ̀ɔ! Nyàndà nga mběyi! Nyɔ̀dɔ nyɨ̌ Pbàfàrìsáyó mà, Pbàsàdùkáyó mànà tɔ́ afi rɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ka rɔ̌tɛ wɔ̀ dhu bhěyi ɨnzá àlɛ̌ kìdyì mʉ̀gatì dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nɨ́ Yěsù náasʉ̀ abádhí rʉ̌nɔna dhu, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Ádhu nyɨ̌ nyátɨna nzínzìkʉ ɔ̌, ɨ̀mbǎ àlɛ̌ kɨ́’ɨ̀ mʉ̀gatì nà dhu-okú dɔ̀ rɔ̀ dhu ràrɨ̌ ndɨ nɨ̌? Nyɨ̌ nɨ́ ákɛ̌ a’uta nà alɛ! ");
INSERT INTO niy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kàpɛ̀ tɨ́ obhó dʉ̀kʉ àlʉ̌? Nyɨ̌ nyàpɛ̀ tɨ́ nzá imbò mʉ̀gatì-ɔ̌nga ma mʉkɔ, imbò lʉfʉ̀ alɛ ràdʉ̀ ɔ̀nyʉ̀nà dhu ɨ̀rɛ̀? Ndɨrɔ̀ nyɨ̌ nyɨ̀rɛ̀ tɨ́ ɨnzá yà nyɨ̌ nyadʉ̀ òwunà ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go tɔ́ sɛ̌ngɛ̀-bvʉ? ");
INSERT INTO niy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nyɨ̌ nyɨ̀rɛ̀ tɨ́ ɨnzá àrʉ̀bhʉ̀ mʉ̀gatì-ɔ̌nga ma mʉkɔ, ɨ̀fɔ lʉfʉ̀ alɛ rɔ̀nyʉ̀ dhu? Ndɨrɔ̀ nyɨ̌ nyɨ̀rɛ̀ tɨ́ ɨnzá yà nyɨ̌ nyadʉ̀ òwunà ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go tɔ̀ sɛ̌ngɛ̀-bvʉ? ");
INSERT INTO niy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɨ́ngbà dhu bhěyi dhu, ɨnzá nyɨ̌ nyàdʉ̀ dhu ʉ̀nɨ, ɨ̀nzɨ̌ ràrɨ̌ mʉ̀gatì ma mɔ́tɛ dɔ̀ná, yà ma mɨ́ dhu ɔ̀vɔ fʉ̌kʉ̀ matɨ, nyɨ̌ rɔ̀dɔ nyɨ̌ Pbàfàrìsáyó mà, Pbàsàdùkáyó mànà tɔ́ afi rɔ̌ rɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà ábhàlɨ̌ nádʉ̀ dhu ʉ̀nɨ, Yěsù rɔ̌tɛ dɔ̀na dhu ràrɨ̌ nzɨ̌ mʉ̀gatì nɔ́nzɨ ka karɨ́ nɨ̌ afi. Pbɛ́tʉ̀, kà rɔ̌tɛ dɔ̀ná dhu ràrɨ̌ Pbàfàrìsáyó mà Pbàsàdùkáyó mànà náarúdhěna ìndrǔ tɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù Kàyìsàriyà-Fìlipì tɔ́ kɨgɔ̀-bɨdɔ̌ rɨ́’ɨ̀ pbìrì ɔ̀. Nɨ́ kǐvú dhu pbɨ̀ndà ábhàlɨ̌-tsʉ̌, ndàtɨ: «Ádhu ìndrǔ nàarʉ́nɔna Ìndrǔ t’ídhùnà dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Atdídhená alɛ náarátɨna nyɨ ràrɨ̌ Bàtizò nubhónà Yùwanɨ̀. Ngʉ̌kpà alɛ náarádʉ̀ àtɨ̀nà nyɨ ràrɨ̌ nabì Ɛ̀lɨyà. Ndɨrɔ̀ ngʉ̌kpà alɛ-tsí náarádʉ̀ àtɨ̀nà nyɨ ràrɨ̌ nabì Yɛ̀rɛ̀mɨyà, ndɨrɔ̀ ngǎtsi nɨ̌ nyɨ ràrɨ̌ Kàgàwà bhà pbànábí nzínzì ɔ̌ atdí nabì.» ");
INSERT INTO niy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Olu nyɨ̌, nyɨ̌ nyarátɨna ma ràrɨ̌ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nɨ́ Sìmonì Pɛ́tɛrʉ̀ náadʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Nyɨ nɨ́ Krɨ́stɔ̀, ɨ̀nzɨ̌ arɔ́vɛ̀ Kàgàwà t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ atɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Nyɨ nyɔ̀nzɨ̀ wà hirò, Sìmonì, Yùwanɨ̀ t’ídhùnǎ! Ɨ̀nzɨ̌ nɨ́ ìndrǔ ndɨ wɔ̀ dhu nàbhʉ nyʉnɨ. Pbɛ́tʉ̀ ka nàbhʉ nyʉnɨ nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nɨ́, ma mátɨna nyɨ nɨ̌: Nyɨ nɨ́ Pɛ́tɛrʉ̀, bhalabhala tɔ́ odu. Ndɨ bhalabhala tɔ́ odu dɔ̌ nɨ́ ndɨ ma mɔsɨ́ya pbàkà Kànɨsà. Ɔvɛ-bvʉ̀ ka kótsù ɔ̀ná tsǎtsʉ̀ nɔ́ɔnzɨya nzɨ̌ atdí dhu mà ndɨ Kànɨsà rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma mabhʉ̀ya ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ ka kótsù nɨ̌ fʉ̀ngʉlà fʉnʉ́. Kɔ́rɔ́ dhu-tsí yà adzɨ dɔ̌ nyɨ nyʉ̀tsɨ̀, nóngo ɨ̀’ɨ̀ ɨwà ndɨ̀ nʉ̀tsɨ̀ ɔ̀rʉ̀-akpà ɔ̀ màtɨ́. Ndɨrɔ̀ kɔ́rɔ́ dhu-tsí yà adzɨ dɔ̌ nyɨ nyʉ̀nga, nóngo ɨ̀’ɨ̀ ɨwà ndɨ̀ nʉ̀nga ɔ̀rʉ̀-akpà ɔ̀ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ dhu nʉ́ya pbɨ̀ndà ábhàlɨ̌ tɔ̀ ɨ̀nzɨ̌ dhu nʉnɔ tɨ́ atdí alɛ tɔ̀ màtɨ́ ndɨ̀ ràrɨ̌ Krɨ́stɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rɔ̀pɛ̀ ndɨ̀ ányɨ̀rɔ̌ rɔ̀, Yěsù apɛ̀ ndɔ̀vɔ̀ dhu kpangba pbɨ̀ndà ábhàlɨ̌ tɔ̀ ndàtɨ, dhu ràkǎ wà ndàrà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ndɨ́nɨ̌ pbàkʉ̀rʉ̌ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, ndɨrɔ̀ Músà bhà Ʉyátá tɔ́ màlímó mànà náabhʉ̀ tɨ́ ndɨ̀ ndàbà àpbɛ̀ abhɔ ányɨ̀. Abádhí ràrɨ̌ ndàbhʉ̌ kohò ndɨ̀, kadʉ̀ ndɔ̀tdʉ̀, ndɨrɔ̀ ɨ̀bhʉ ɨdhɔ dzidɔ̌, ndɨ̀ radʉ̀ya ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ kìdyì ndàrà nà igi, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀rʉ̀ kà-dɔ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, Kàgàwà àkǎ ndɔ̀dɔ̀ ngbɔ̌nʉ! Ɨnzá dhu àkǎ wɔ̀ dhu rɔ̀nzɨ̀ ndɨ̀ rʉ̀nʉ́.» ");
INSERT INTO niy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pbɛ́tʉ̀, Yěsù adʉ̀ ndàgɛrɛ, ndàtɨ Pɛ́tɛrʉ̀ nɨ̌: «Índrǐ nyɨ ɨtsɛ tɨdú rɔ̀ pfɔ̀mvɔ Sìtanɨ̌! Nyɨ nyɨ́ dhu ɔ̀nzɨ nyitsu ma nzɛ́rɛnga ɔ̀. Obhó tɨ́, nyɨ nyɨ́ nzɨ̌ ɨnga nɨ́rɛ̀ Kàgàwà náarɨ́ ɨnga ɨ̀rɛ̀ dhu bhěyi, pbɛ́tʉ̀ nyɨ nyɨ́ ɨnga nɨ́rɛ̀ ìndrǔ náarɨ́ ɨnga ɨ̀rɛ̀ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ndɨ alɛ náapɛ́ ndòzè ndùbhi owùdu ɔ̌, nɨ́ kàkǎ ndàdzo rɔ̀ná rɔ̀, ndàdʉ̀ ndà’ù ndànɔ̀ pbɨ̀ndà mʉ̀sàlabhà, ndàdʉ̀ ùbhi owùdu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pbɨ̀ndà ípìrɔ̌nga nòzè ndɨ̀gʉ̌ alɛ níiwíya ka. Pbɛ́tʉ̀ okúdu dɔ̀ rɔ̀ rɨ́ pbɨ̀ndà ípìrɔ̌nga níwǐ alɛ, náadʉ̀ya kàbà àbà tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ìndrǔ rɨ̌ yà adzɨ ɔ̌ dhu nóngyè kɔ́rɔ́, pbɨ̀ndà ípìrɔ̌nga ràdʉ̀ àwǐ dhu tɔ́ ídzìnga nɨ́ àdhu? Atdí dhu mà tɨ́ ìnè, yà ìndrǔ rǎdʉ̀ àbhʉnà pbɨ̀ndà ípìrɔ̌nga nʉwʉ̀ tɨ́? ");
INSERT INTO niy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Obhó tɨ́, Ìndrǔ t’ídhùnà nɨ́ɨraya Àbanà Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ pbɨ̀ndà màlàyíká mànà. Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ya ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà núbho ndɨ alɛ bhà kasʉ-bvʉ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ngʉ̌kpà alɛ kǎkà ɨrɔ́ rɨ́’ɨ̀ alɛ nzínzì ɔ̌, nʉ́ʉvɛ̀ya nzɨ̌ ɨnzá ɨ̀ àla Ìndrǔ t’ídhùnà rɨ̌rà pbɨ̀ndà idzi tɔ́ ádrʉ̀ngbǎnga ɔ̌ dhu rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Azà ɨdhɔ dzidɔ̌, Yěsù núugu Pɛ́tɛrʉ̀ mà, Yàkɔbhɔ̀ mà, ndɨrɔ̀ Yàkɔbhɔ̀ t’ádɔ̀nà Yùwanɨ̀ mànà, ’àdʉ̀ òwu nà lɛ̀ngɛ̀lɛ̀ngɛ̀ ádzǐ pbìrì-akpà dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nɨ́ Yěsù-wɔ̀yɔ̌ nʉ́ʉgɛ̀rɛ̀ ndɨ̀ abádhí-nyɨ̀kpɔ́ ɔ̌ rɔ̀. Kà-nyɨ̀ náadʉ̀ ndɔ̀pɛ̀ ndʉ̀mbɨ̀lɨ̀ adyifɔ̀ bhěyi, kà-rɔ̌ mʉ̀dzarʉ̀ ràdʉ̀ ɔ̀wʉ tdyé awáwʉ̀ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nɨ́rɔ̀ nɨ́ ndɨ Músà mà Ɛ̀lɨyà mànà nʉ́ʉtɔ ɨ̀, ’àdʉ̀ àmbɛ ɔ̀tɛ dɔ̌ Yěsù mànà. ");
INSERT INTO niy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, dhu ɔ̀fɔ̀ nga àlɛ̌ ròkò ɨrɔ́. Nɨ́ nyɨ nyòzè ka nɨ̌, ma mɨ́ ɨ̀bhʉ hɛmɛ̌-dzà núpě ɨrɔ́, atdí nɨ́ pbʉ̀kʉ̀, ngǎtsi nɨ́ Músà bhà, ndɨrɔ̀ ngǎtsi nɨ́ Ɛ̀lɨyà bhà.» ");
INSERT INTO niy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wɔ̀ dhu nʉ́nɔ Pɛ́tɛrʉ̀ rɨ̌ rɔ́rɔ̀ nɨ́ ndɨ, ɨnga àwʉ̀ rɨ́ ádrʉ̀ngbǎ àpbù níibvú ndɨ̀, ndàtsì abádhí sɨsɨ̀na nɨ̌. Ndɨrɔ̀ ndɨ àpbù ɔ̀ rɔ̀, atdí alɛ-tù náadʉ̀ ndɨ̀rɨ, ndàtɨ: «Yàrɨ́ nɨ́ Idhùdu, atdídɔ̌ ma mózè alɛ. Kǎrɨ́ nyɨ̀kpɔ́du nɔ̀fɔ̀ dhu ɔ̀nzɨ. Nɨ́, nyɨ̀rɨ kà-tsʉ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yěsù bhà ábhàlɨ̌ níitdègu wɔ̀rɨ́ alɛ-tù nɨ́rɨ, nɨ́ ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ abádhí ɔ̀. Abádhí adʉ̀ ’àwà obvò, ɨ̀ rʉ̀pbǎ nyɨ̀ya adzɨkpa nyʉ́ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nɨ́ Yěsù náandrì abádhí-tɨ’ɔ̀, ndàpbàlǎ abádhí-ngbɔ̀, ndàdʉ̀ àtɨ̀nà: «Nyɨ̀và nyɨ̌, Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ!» ");
INSERT INTO niy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nɨ́ kɔ̌kɔ̀ ábhàlɨ̌ nɨ́ɨvà ɨ̀ ’àndà nga, ’àdʉ̀ Yěsù kɛ̀lɛ̌ nála atdírɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pbìrì dɔ̀ rɔ̀ abádhí rǎwǔ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù adʉ̀ dhu nʉ́ya abádhí tɔ̀ ndàtɨ: «Àpɛ́ nyàwɛ yà nyɨ̌ nyàla dhu atdí alɛ tɔ̀ màtɨ́, ràrà àhʉ Ìndrǔ t’ídhùnà rɨ̌ ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wɔ̀ dhu-dzidɔ̌, Yěsù bhà ábhàlɨ̌ náadʉ̀ dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Ádhu Músà bhà Ʉyátá tɔ́ màlímó náarátɨna Ɛ̀lɨyà ràkǎ pɛ́ ndɨ̀rà angyi nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Obhó tɨ́, Ɛ̀lɨyà nákǎ wà ndɨ̀rà, kɔ́rɔ́ dhu nyɨ̀tɨ̀ ndɨ̀ ndohú tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pbɛ́tʉ̀, ma mátɨna Ɛ̀lɨyà nɨ́rà wà àhʉ, ɨ̀nzɨ̌ ìndrǔ ràdʉ̀ Ɛ̀lɨyà tɨ́ kà rɨ̌’ɨ̀ dhu nʉ́nɨ. Ndɨrɔ̀ abádhí náadʉ̀ àvu kà-rɔ̌ afíya nózè dhu bhěyi. Nɨ́ ndɨ dhu bhěyi tɨ́, abádhí náavùya Ìndrǔ t’ídhùnà rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà ábhàlɨ̌ náadʉ̀ dhu ʉ̀nɨ, yà Yěsù rǔbhi ɔ̀tɛ rɔ̌ dɔ̀ná fɨ̌yɔ̀ alɛ ràrɨ̌ Bàtizò nubhónà Yùwanɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yěsù mà, pbɨ̀ndà ɨ̀bhʉ ábhàlɨ̌ mànà níitdègu ìwu ùvò ihé-yà rɨ̌’ɨ̀ rɔ́, nɨ́ atdí alɛ níindri Yěsù-tɨ’ɔ̀, ndɔ̀kɔ̀ ndɨ̀ ɔtdyʉ̀na dɔ̌ kɔ̀nzɨ̌, ");
INSERT INTO niy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ndàdʉ̀ àtɨ̀nà kànɨ̌: «Ádrʉ̀ngbǎlɛ́, ábà ɨzʉ idhùdu dɔ̌. Kà rɨ̌’ɨ̀ sɨ́mvɔ nà, ndɨrɔ̀ kǎrɨ́ àndɨ atdídɔ̌. Bìlǐnganà kǎrɨ́ ndàwà kàzʉ ɔ̀, ndɨrɔ̀ ɨdha ɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma mɨ̀rà kà nà ndɨ́nɨ̌ pbʉ̀kʉ̀ ábhàlɨ̌ nɨ́ɨgʉ́ tɨ́, nɨ́ abádhí àdʉ̀ nzá kɨ̀gʉ.» ");
INSERT INTO niy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nɨ́ Yěsù adʉ̀ àtɨ̀nà: «Hàkà! Nyɨ̌, ɨ̀mbǎ a’uta nà alɛ tɔ́ rʉ̀gànda, ndɨrɔ̀ nzɛ́rɛ alɛ! Àlɛ̌ kokoya nyɨ̌ mànà ìfe kàsʉmɨ̀ tɨ́? Ndɨrɔ̀ fʉ̀kʉ́ dhu-dzi ma mondúya ràrà àhʉ ìfe ɨdhɔ tɨ́? Nyìwǔ ndɨ ngbángba nà àzú fudu ɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yěsù adʉ̀ ɔ̀tɛ ɔrʉ́ tǔna nyʉ́ nà wɔ̀ ngbángba ɔ̀ rɨ́’ɨ̀ nzɛ́rɛ-alafí dɔ̌, ndɨ nzɛ́rɛ-alafí ràdʉ̀ àhʉ ndɨ ngbángba ɔ̀ rɔ̀. Nɨ́ ndɨ ngbángba náadʉ̀ ɔ̀gʉ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ òndri Yěsù-tɨ’ɔ̀ atdírɔ̀ kà rɨ̌’ɨ̀ rɔ́rɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Ádhu ɨnzá mǎ mìpfo wɔ̀ nzɛ́rɛ-alafí nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ nyìpfo nzá ka fʉ̀kʉ́ ákɛ̌ a’uta-okú dɔ̀ rɔ̀. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: fʉ̀kʉ́ a’uta nɨ́’ɨ̀ná gukyè hàràdalɨ̀-kpɔ̌ náarɨ́’ɨ̀ dhu bvʉ̀tɨ́ màtɨ́, nɨ́ nyɨ̌ nyambɛ̀nà àtɨna yàrɨ́ pbìrì nɨ̌: ‹Ɨ́ngbɛ̀ nyɨ ɨrɔ́ rɔ̀ nyarà ndǎlʉ̀,› nɨ́ ndɨ pbìrì àmbɛ̀nà àdʉ̀ ndɨ̀ngbɛ̀ ányɨ̀rɔ̌ rɔ̀. Ndɨrɔ̀, lɛ̀màkʉ nɔ́nzɨ rɨ́ atdí dhu mà námbɛ̀nà ɨ̀’ɨ̀ mbǎ.  ");
INSERT INTO niy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pbɛ́tʉ̀, wɔ̀rɨ́ nzɛ́rɛ-alafí-tɨdɔ̀ nábhʉ rádʉ̀ ràhʉ dhu nɨ́ ɨtsɔ̀ta mà, ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ t’ʉ́tsɨta mànà kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà níitdègu ’òtù atdíkpá Gàlìlayà tɔ́ pbìrì ɔ̀, nɨ́ Yěsù adʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀, ndàtɨ: «Ka kɨ́ Ìndrǔ t’ídhùnà nípfǒ, kabhʉ ìndrǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nɨ́ ɨ alɛ rɨ̌ kòho, kadʉ̀ ɔ̀tdʉ̀nà. Pbɛ́tʉ̀ ɨ̀bhʉ ɨdhɔ dzidɔ̌, kǎdʉ̀ya ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀.» Nɨ́ wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ɨzʉ náadʉ̀ Yěsù bhà ábhàlɨ̌ nʉ́ka atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà níitdègu owu ùvò Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀, nɨ́ Kàgàwà bhà ɨdza-dɔ tɔ́ pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ níindri Pɛ́tɛrʉ̀-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Fʉ̀kʉ́ màlimò náatɨ́ Kàgàwà bhà ɨdza-dɔ tɔ́ pàratà nʉ́fɔ̌ ʉ̀fɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ʉ̀fɔ̌ arʉ́fɔ̌na.» Nɨ́ ɨdza Pɛ́tɛrʉ̀ òtsù rɔ̀, Yěsù náapɛ̀ ɔtɛ angyi, ndìvǔ dhu kà-tsʉ̌ ndàtɨ: «Ádhu nyɨ nyɨ̀rɛ̀ wɔ̀ dhu dɔ̌, Sìmonǐ? Ádhɨ ndɨ yà adzɨ ɔ̀ ádrɔ̀drɔ̌ kámá tɔ́ pàratà nʉ́fɔ rádʉ̀? Ndɨrɔ̀, ádhɨ ndɨ ùdzǐna ndɨ̀ ndɨ́ dhu-dɔ nátsà rádʉ̀ abádhí tɔ̀? Tɨ́ abádhí tɔ́ pbìrì ɔ̌ alɛ nyʉ́? Ndɨrɔ̀ ngǎtsi nɨ̌, tɨ́ ìwǔ tɨ́ ɨ́wǔ ndɨ pbìrì ɔ̌ alɛ?» ");
INSERT INTO niy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ìwǔ tɨ́ íwǔ ndɨ pbìrì ɔ̌ alɛ.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Wɔ̀rɨ́ nɨ́ ɨ̀tɨ́ ka kátɨna, ndɨ pbìrì ɔ̌ alɛ nyʉ́ ràrɨ̌ nzɨ̌ àdʉ̀ kʉ̀fɔ. ");
INSERT INTO niy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pbɛ́tʉ̀, dhu àkǎ nzá àlɛ̌ ràbhʉ abádhí ròtsù nzɛ́rɛnga ɔ̀. Nɨ́, ndɨ dhu bhěyi kà rɨ̌’ɨ̀ rɔ̀, árà rɛ̀rʉ̀ ɔ̀, nyadʉ̀ ɨ́nɛ̀ nóbvù ɨdha ɔ̀. Nɨ́ angyi nyɨ nyíbvùna ɨ̀bhɛ̀-li’ɔ̀ nga nyángbɛ̌, nyadʉ̀ fʉ̀rangà-kpɔ̌ nídyì lina ɔ̀ rɔ̀. Ndɨ fʉ̀rangà nɨ́ ndɨ nyɨ nyádʉ̀ pàratà náfɔ nɨ̌ àlɛ̌ tɔ̀, ɔ́yɔ̌ kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ndɨ kàsʉmɨ̀ ɔ̌, Yěsù bhà ábhàlɨ̌ níindri Yěsù-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌, ádrʉ̀ngbǎ alɛ nyʉ́ ròsè nɨ́ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nɨ́ Yěsù adʉ̀ atdí ákɛ̌ ngbángba nánzì, ndɨ̀lɨ rìdè abádhí-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kǎdʉ̀ àtɨ̀nà: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ nyʉ̌gɛ̀rɛ̀, nyʉ̌lɨ nyɨ̌ nɨ̀nɨ́ nzónzo bhěyi, nɨ́ nyɨ̌ nyotsúya nzɨ̌ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ndìfǒ rɨ́ obvò ndɨ̀tɨ́rɔ̀, ndɨ̀lɨ ndɨ̀ yàrɨ́ ngbángba bhěyi alɛ, nɨ’ɨya ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ ádrʉ̀ngbǎ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ndɨrɔ̀, yà dhu bhěyi ngbángba nákɔ̌ rɨ́ okúdu dɔ̀ rɔ̀ alɛ, nɨ́ ɨwà ɨma nàkɔ ɨma nyʉ́ tɨ́rɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Yà ma ná’ù nzónzo nzínzì ɔ̌, atdí ngbángba mà nábhʉ̌ rɨ́ ròtsù nzɛ́rɛnga ɔ̀ alɛ, nɨ́ dhu ɔ̀fɔ̀ nga mběyi nyʉ́ kosò ádrʉ̀ngbǎ odu-ba ndɨ alɛ-tú, kadʉ̀ ndɨ alɛ nɨ́dɔ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ tɔ́ lùlù ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Àpbɛ̀ nɨ́ ndɨ yàrɨ́ adzɨ tɔ̀, ìndrǔ àbhʉ̌ kǎrɨ́ ròtsù nzɛ́rɛnga ɔ̀ dhu-okú dɔ̀ rɔ̀. Obhó tɨ́, ìndrǔ rǎdʉ̀ òtsù òtsù nzɛ́rɛnga ɔ̀. Pbɛ́tʉ̀, ìndrǔ nábhʉ̌ rɨ́ ròtsù nzɛ́rɛnga ɔ̀ alɛ rɨ̌’ɨ̀ àpbɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dhu apɛ́ ɨ̀’ɨ̀ ɔtsʉ́nʉ mà, ndɨrɔ̀ pfɔ̌nʉ mà náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ ɔ́tdɨ̀ ndɨ ɔtsʉ́nʉ mà ndɨ pfɔ̌nʉ mànà, nyadʉ̀ àwànà ɨtsɛ nyʉ́ rʉ̀nʉ́ rɔ̀. Dhu ɔ̀fɔ̀ nga mběyi nyʉ́, nyotsù atdí ɔtsʉ́nʉ nà, ndɨrɔ̀ atdí pfɔ̌nʉ nà dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀, ròsè ɔ́yɔ̌ ɔtsʉ́nʉ mà, ɔ́yɔ̌ pfɔ̌nʉ mà nɔ́dɔ nyɨ nyɨ́ ɨndʉ̀, kadʉ̀ nyobvù nà ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndɨrɔ̀, dhu apɛ́ ɨ̀’ɨ̀ nyɨ̀kpɔ́nʉ náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ ɨ́tǎ ka, nyadʉ̀ ɨ̀wànà nyobvù ɨtsɛ rʉ̀nʉ́ rɔ̀. Dhu ɔ̀fɔ̀ nga mběyi nyʉ́, nyotsù dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀ atdí nyɨ̀kpɔ́nʉ nà, ròsè ɔ́yɔ̌ nyɨ̀kpɔ́nʉ nɔ́dɔ nyɨ nyɨ́ ɨndʉ̀, kadʉ̀ nyobvù ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Nyɔ̀dɔ nyɨ̌ mběyi, ɨ̀nzɨ̌ nyɔ̌nzɨ̀ kǎkàrɨ́ nzónzo nzínzì ɔ̌ atdí ngbángba mà gàyà. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ abádhí tɔ́ màlàyíká náaróko bìlǐnganà, ’àmbɛ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà-nyɨ̀kpa nándà dɔ̌.  ");
INSERT INTO niy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Obhó tɨ́, Ìndrǔ t’ídhùnà nɨ́ɨra àwǎwí alɛ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nɨ́, ádhu nyɨ̌ nyɨ́rɛ̀na yà dhu dɔ̌? Atdí alɛ náapɛ́ ɨ̀’ɨ̀ atdí mɨyà tàmà nà, atdí ràdʉ̀ àwǐ abádhí nzínzì ɔ̌ rɔ̀, nɨ́ ndɨ alɛ tɨ́ nzɨ̌ àdʉ̀ kɔ̌kɔ̀ àrʉ̀gyètdí kumì dɔ̀ná àrʉ̀gyètdí nà ngʉ̌kpà tàmà nʉ́bhà pbìrì dɔ̌ rányʉ rɔ́, ndàdʉ̀ àrà yà àwǎwǐnà tsí nɔ́mɛ̀? ");
INSERT INTO niy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kǎpɛ́ kàbà, nɨ́ ma mátɨna nyɨ̌ nɨ̌: kà rǎdʉ̀ ɨ̀’ɨ̀ ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ nà ndɨ tàmà-okú dɔ̀ rɔ̀, ròsè yà àrʉ̀gyètdí kumì dɔ̀ná àrʉ̀gyètdí nà ngʉ̌kpà tàmà, yà ɨnzá ùwǐnà dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nɨ́ ndɨ dhu bhěyi tɨ́, ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ Kàgàwà nózè nzá atdí ngbángba mà rǎwǐ kǎkàrɨ́ nzónzo nzínzì ɔ̌ rɔ̀ dhu.» ");
INSERT INTO niy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ábhàlɨ̌ nɨ̌: «Ɔdhɨ̀nʉ náapɛ́ dhu àfǎ nyɨ nɨ̌, nɨ́ dhu àkǎ nyarà kòtù, nyadʉ̀ kàbhà afátá nɔ́vɔ̀ kà tɔ̀ ɔ́yɔ̌ rɔ̀ nyɨ̌ nyɨ́’ɨ̀ kà mànà rɔ́rɔ̀. Kǎpɛ́ nyɨ nyʉ̀nɔ̀ dhu nɨ́rɨ, nɨ́ nyɨ nyɨ̀gʉ̌ wà ndɨ ɔdhɨ̀nʉ. ");
INSERT INTO niy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pbɛ́tʉ̀, kǎpɛ́ ndùvǒ ɨ̀nzɨ̌ ndɨ̀rɨ̀ tsʉ̀nʉ́ dhu, nɨ́ ádʉ̀ nyidyi atdí alɛ mà, ndɨrɔ̀ ngǎtsi nɨ̌ ɔ́yɔ̌ alɛ mà, nyǒwù mànà kà-tɨ’ɔ̀, ndɨ́nɨ̌ ɔ́yɔ̌, ndɨrɔ̀ ngǎtsi nɨ̌ ɨ̀bhʉ ngàmbì mà nʉ́nɔ̀ dhu-bvʉ rɔ̌ ka kadʉ̀ tɨ́ ndɨ dhu nɔ́bhɔ̀lɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pbɛ́tʉ̀, kǎpɛ́ ndùvǒ ɨ̀nzɨ̌ ndɨ̀rɨ̀ abádhí-tsʉ̌ dhu, nɨ́ ádʉ̀ nyipfo ndɨ dhu Kàgàwà ná’ù alɛ tɔ́ mʉ̀tʉ̀ nzínzì ɔ̀. Ndɨrɔ̀ kǎpɛ́ ndùvǒ ɨ̀nzɨ̌ ndɨ̀rɨ̀ ɨ̀ alɛ mà, nɨ́ ádʉ̀ nyɔzʉ́ ka ɨnzá Kàgàwà ná’ù alɛ tɨ́, ndɨrɔ̀ ádʉ̀ nyɔzʉ́ ka pàratà t’ʉ́fɔ́tá tɔ́ atdí ndɔmbɛ̀ bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Kɔ́rɔ́ dhu-tsí yà adzɨ dɔ̌ nyɨ̌ nyʉ̀tsɨ̀, nóngo ɨ̀’ɨ̀ ɨwà ndɨ̀ nʉ̀tsɨ̀ ɔ̀rʉ̀-akpà ɔ̀ màtɨ́. Ndɨrɔ̀ kɔ́rɔ́ dhu-tsí yà adzɨ dɔ̌ nyɨ̌ nyʉ̀nga, nóngo ɨ̀’ɨ̀ ɨwà ndɨ̀ nʉ̀nga ɔ̀rʉ̀-akpà ɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma mɨ́ obhó dhu nʉ́nɔ tdɨ́tdɔ̌ fʉ̌kʉ̀: nzínzìkʉ ɔ̌ ɔ́yɔ̌ alɛ mà náapɛ́ ’ɨ̀rɨ yà adzɨ dɔ̌, ’ònzì yà ɨ̀ òzè kɔ́rɔ́ dhu-tsí, nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà rǎdʉ̀ ndɨ dhu nábhʉ àbhʉ̌ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Obhó tɨ́, ɔ́yɔ̌ alɛ mà, ngǎtsi nɨ̌ ɨ̀bhʉ alɛ mà núndu ɨ̀ ɔvɔ̀du rɔ̌ rɔ́, nɨ́ ma mɨ́’ɨ̀ ìnè abádhí nzínzì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wɔ̀ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ náandrì Yěsù-tɨ’ɔ̀ ndàdʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ma mádʉ̀ dhu ʉ̀bà ìfe-gʉ̀na dhu nàfǎ ɔnzɨ̀dú ɔdhɨ̀du tɔ̀? Ma tɨ́ àdʉ̀ dhu ʉ̀bà kà tɔ̀ àrʉ̀bhʉ̀-gʉ̀na?» ");
INSERT INTO niy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ma mɨ́ nzɨ̌ atɨna nyɨ ràrǎdʉ̀ dhu ʉ̀bà kà tɔ̀ àrʉ̀bhʉ̀-gʉ̀na. Pbɛ́tʉ̀, dhu àkǎ nyʉbà dhu kà tɔ̀ àrʉ̀bhʉ̀ kumì, àrʉ̀bhʉ̀-ràdɔ̌-gʉ̀na. ");
INSERT INTO niy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mátɨna, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi rɨ́lɨ ndɨ̀ atdí ádrʉ̀ngbǎ kamà yà pbɨ̀ndà wànzá nà arɨ́’ɨ̀ pbɨ̀ndà kasʉtálɛ nazè rùbho ɨ wànzá bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nɨ́, kǐtdègu ɨ wànzá nà arɨ́’ɨ̀ alɛ-ɔvɔ̀ nɔ́pɛ̀ ndùnzì, nɨ́ ka kiwú atdí kasʉtálɛ, yà fʉ̀rangà tɔ́ lʉfʉ̀-tsʉ̀ tɔ́ wànzá nà rɨ́’ɨ̀ nà kà-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wɔ̀ ndɨ alɛ rɨ̌ ndɨ wànzá núbhǒ nɨ̌ atdí dhu mà nɨ́ɨ’ɨ̀ mbǎ kà-fɔ́. Nɨ́ kàbhà ádrʉ̀ngbǎlɛ náadʉ̀ dhu ʉ̀ya, ndɨ́nɨ̌ ka kudzí tɨ́ ndɨ alɛ mà, pbɨ̀ndà tsìbhálɛ mà, pbɨ̀ndà nzónzo mà, kɔ́rɔ́ fɔná arɨ́’ɨ̀ dhu mànà, ndɨ́nɨ̌ ka kubhò tɨ́ ndɨ wànzá nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nɨ́ wɔ̀ kasʉtálɛ náakɔ̀ ndɨ̀ ɔtdyʉ̀na dɔ̌ pbɨ̀ndà ádrʉ̀ngbǎlɛ-ɔ̀nzɨ̌, ndàdʉ̀ ndɨ̀tsɔ̀ kà-rɔ̌ ndàtɨ: ‹Ádrʉ̀ngbǎlɛ́, ʉ́bà dhu idù, nyadʉ̀ nga ɔ̀dɔ̀ akɛ. Ùbhǒ ma mɨ́ wɔ̀ wànzá núbhǒ kɔ́rɔ́ ɨndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nɨ́ wɔ̀ ádrʉ̀ngbǎlɛ náadʉ̀ ɨzʉ àbà atdídɔ̌ kà dɔ̌, ndàdʉ̀ àtɨ̀nà ɨ̀nzɨ̌ kà ràrɨ̌ atdí dhu mà núbhǒ fɨ̌ndà. Nɨ́ kǎdʉ̀ kʉ̀bhà ràrà. ");
INSERT INTO niy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nɨ́ ʉrɔ́ rɔ̀ ndɨ̀và ndɨ̀ rɔ̀, wɔ̀ kasʉtálɛ náatù yà ɨ̀ arɨ́ kasʉ ɔ̀nzɨ mànà alɛ nzínzì ɔ̌ atdí alɛ. Ndɨ alɛ nɨ́ɨ’ɨ̀ mbɛ̀mbɛ̀ atdí mɨyà dɨ̀narɨ̀ tɔ́ kàbhà wànzá nà. Nɨ́, kǎkɔ̀ wɔ̀ alɛ dàna-tsì rɔ̌, ndɨ rìpbǒ dàna-tsì, ɨhɛ̀na rɔ̀rɨ̀, ndàdʉ̀ àtɨ̀nà nɨ̌: ‹Úbhǒ pbàkà wànzá!› ");
INSERT INTO niy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nɨ́ wɔ̀ kà t’ɔ́dhɨ̀nà náakɔ̀ ndɨ̀ ɔtdyʉ̀na dɔ̌ kà-pfɔ̀ rɔ̌, ndàdʉ̀ ndɨ̀tsɔ̀ kà-rɔ̌, ndàtɨ: ‹Ʉ́bà dhu idù, nyadʉ̀ nga ɔ̀dɔ̀ akɛ. Ùbhǒ ma mɨ́ pbʉ̀kʉ̀ wànzá núbhǒ.› ");
INSERT INTO niy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pbɛ́tʉ̀, wɔ̀rɨ́ alɛ náazè nzá ndɨ̀rɨ̀ kà rʉ̌nɔna dhu. Nɨ́, kǎdʉ̀ kàbhʉ kosò imbi ɔ̀, kɔ̀dɔ ndɨ̀ ndɨ́ rùbho pbɨ̀ndà wànzá dhu ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nɨ́, yà abádhí arɨ́ kasʉ nɔ́nzɨ mànà atdíkpá ngʉ̌kpà kà t’ɔ́dhɨ́na, níitdègu wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu nálǎ, nɨ́ ɨzʉ nʉ́ʉka abádhí atdídɔ̌. Nɨ́ abádhí adʉ̀ òwu wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu náwɛ kɔ́rɔ́ fɨ̌yɔ́ ádrʉ̀ngbǎlɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nɨ́rɔ̀ nɨ́ ndɨ wɔ̀ ádrʉ̀ngbǎlɛ náavì kanzì ndɨ kasʉtálɛ, ndàdʉ̀ àtɨ̀nà nɨ̌: ‹Nyɨ nɨ́ nzɛ́rɛ kasʉtálɛ nyʉ́! Nyɨ nyɨ̀tsɔ̀ nyɨ rùdú dhu-okú dɔ̀ rɔ̀, ma màtɨ ɨ̀nzɨ̌ nyɨ ràrɨ̌ atdí dhu mà núbhǒ idù. ");
INSERT INTO niy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nɨ́ nyɨ nyàmbɛ̀nà àdʉ̀ dhu ʉ̀bà átɔ̀ ɔdhɨ̀nʉ tɔ̀, àdhàdhɨ̀ ma mʉ̀bà dhu ɨndʉ̀ dhu bhěyi.› ");
INSERT INTO niy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nɨ́ wɔ̀ ádrʉ̀ngbǎlɛ náakó atdídɔ̌, ndàdʉ̀ wɔ̀ kasʉtálɛ nábhʉ kosò imbi ɔ̀, kɔ̀dɔ ndɨ̀ ndɨ́ ndɨ́nɨ̌ kɔ́rɔ́ pbɨ̀ndà wànzá nubhò tɨ́ dhu ɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ábhàlɨ̌ nɨ̌: «Ndɨ dhu bhěyi tɨ́ nɨ́ ndɨ, ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbadu Kàgàwà rǎdʉ̀ dhu ɔ̀nzɨ̀ rʉ̀kʉ́, ɨnzá ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà nzínzìkʉ ɔ̌ nʉ́bà dhu atdí afína nyʉ́ nà adɔ̀nà tɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yěsù níitdègu yà ndɨ̀ ndúbhi ùdhenà rɔ̌ dhu t’údheta nɨ́tɔ, nɨ́ kɨ̌và ndɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀, ndàrà Yùdɛyà tɔ́ pbìrì-alàdɔ, yà Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-apkà-adzènǎ rɔ̀ arɨ́’ɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɨ́ abhàbhɔ́ alɛ nà ɔ̀yá ihé náadʉ̀ òwu kǒwu ɔ̌, kà ràdʉ̀ abádhí nzínzì ɔ̌ andɨ nà alɛ nɨ́gʉ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nɨ́ ngúfe Pbàfàrìsáyó níiwú Yěsù-tɨ’ɔ̀ ndɨ́nɨ̌ ɨ̀ omvú tɨ́ kà-afí. Nɨ́, abádhí níivú dhu kà-tsʉ̌ ’àtɨ: «Àlɛ̌ tɔ́ Ʉyátá návi tɨ́ wà atdí kpatsìbhálɛ mà rɔ̀dhɔ̀ pbɨ̀ndà tsìbhálɛ ɨ̀ngbǎ tɨ́ ɨ́lɨ ndɨ̀ afátá-okú dɔ̀ rɔ̀ màtɨ́?» ");
INSERT INTO niy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ nyàpɛ̀ tɨ́ obhó Kàgàwà bhà Andítá náarʉ́nɔna kpangba dhu nɔ́zʉ̀? Kǎrátɨna: ‹Mʉ̀hàngʉ́ ɔ̀ rɔ̀, Kàgàwà náanzɨ̀ kpatsìbhálɛ mà, tsìbhálɛ nà.› ");
INSERT INTO niy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ndɨrɔ̀ kǎrátɨna: ‹Ndɨ dhu-okú dɔ̀ rɔ̀, kpatsìbhálɛ rǎdʉ̀ àbanà mà, ɨ́yànà mànà nʉ́bhà, ’àdʉ̀ ’ùngbò pbɨ̀ndà tsìbhálɛ nà. Ndɨrɔ̀, abádhí ɔ́yɔ̌ rɔ̀ rǎdʉ̀ òngo atdí alɛ-ngbɔ̀ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nɨ́ ndɨ dhu bhěyi tɨ́, abádhí nɨ́ nzɨ̌ àdʉ̀ ɨ̀’ɨ̀ ɔ́yɔ̌ alɛ tdɨ́tdɔ̌, pbɛ́tʉ̀ abádhí nóngò wà atdí alɛ-ngbɔ̀ tɨ́. Nɨ́ dhu àkǎ nzá atdí alɛ mà rùtu Kàgàwà úngbò alɛ-ɔ̌nga.» ");
INSERT INTO niy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nɨ́ Pbàfàrìsáyó adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌, ’àtɨ: «Olu, ádhu Músà nʉ́ʉyá dhu ndàtɨ, dhu ràrǎdʉ̀ àkǎ kandǐ ʉbhátá tɔ́ bhàrʉwà kabhʉ tsìbhálɛ-fɔ́, ndɨ tsìbhálɛ òdì ka kɨ́ rɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Músà náabhʉ̀ nyɨ̌ nyǒngo fʉ̀kʉ́ vèbhálɛ nódì odú afíkʉ náarɔ́’ɔ dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀ mʉ̀hàngʉ́ ɔ̀ rɔ̀, ndɨ dhu nɨ́ɨ’ɨ̀ mbǎ wɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: atdí kpatsìbhálɛ náapɛ́ pbɨ̀ndà tsìbhálɛ nɔ́dhɔ, ndàdʉ̀ òdìnà, ɨnzá nɨ́ mʉ̀nyɔ̀nɨ̀ kɛ̀lɛ̌ nɔ̀nzɨ̀ ngǎtsi kpatsìbhálɛ nà dhu-okú dɔ̀ rɔ̀ rɔ̀, nɨ́ ngǎtsi tsìbhálɛ ndɨ̀ ndàmbà rɔ̀, ka nádʉ̀ ɨ̀’ɨ̀ ɨwà mʉ̀nyɔ̀nɨ̀ nɔ̀nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Wɔ̀ dhu bhěyi kpatsìbhálɛ mà nzínzì ɔ̌ dhu rɨ̌’ɨ̀ tsìbhálɛ mànà rɔ̀, ìndrǔ rɨ̌ ’ʉ̀mbǎ dhu tɔ́ ídzìnga rɨ̌’ɨ̀ mbǎ.» ");
INSERT INTO niy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ nɨ́ kɔ́rɔ́ alɛ wɔ̀rɨ́ Ɔtɛ náarɨ́ dɔ̀ya àlʉ̌, pbɛ́tʉ̀ kǎrɨ́ dɔ̀ya àlʉ̌ alɛ nɨ́ kǎkà Kàgàwà ábhʉ kà ràlʉ̌ dɔ̀ya alɛ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kpabhálɛ-tsʉ̀ àtɔ̀ rádʉ̀ ɨ̀nzɨ̌ rʉ̀mbǎ vèbhálɛ dhu-tsʉ̀ rɨ̌’ɨ̀ ibí. Obhó tɨ́, atdídhená kpabhálɛ náarɨ́ nzɨ̌ vèbhálɛ ʉ̀mbǎ ʉ̀dhɨ̌ tɨ́ ka kʉdhɨ́ ɨ̀ àmǎ tɨ́rɔ̀ dhu-okú dɔ̀ rɔ̀. Ngʉ̌kpà kpabhálɛ náarɨ́ nzɨ̌ vèbhálɛ nʉ́mbǎ, ɔbɨ nɨ̌ ka ka kʉ́gɛ̀rɛ̀ ɨ̀, ’òngò àmǎ tɨ́ dhu-okú dɔ̀ rɔ̀. Ndɨrɔ̀ ngʉ̌kpà-tsí náaróko àmǎ bhěyi, ɨ̀nzɨ̌ ’ʉ̀mbǎ vèbhálɛ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi-okú dɔ̀ rɔ̀. Yà ma mʉ̀nɔ̀ dhu rɨ̌ dɔ̀na àlʉ̌ alɛ nákǎ kà ràlʉ̌ dɔ̀na!» ");
INSERT INTO niy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wɔ̀ dhu-dzidɔ̌, ìndrǔ níiwú nɨ̀nɨ́ nzónzo nà Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ kʉ̌lɨ tɨ́ ɔtsʉ́na dɔ̀yá, ndàdʉ̀ ndɨ̀tsɔ̀ dɔ̀yá. Pbɛ́tʉ̀, Yěsù bhà ábhàlɨ̌ náadʉ̀ òko ’àmbɛ ɔ̀rʉ̀ dɔ̌ ɨ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyʉ̀bhà nzónzo rìwǔ tɨdu ɔ̀, ndɨrɔ̀ ɨ̀nzɨ̌ nyàtɔ̀ abádhí-tsʉ̀, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́ abádhí bhěyi ɨ̀ nʉ́lɨ alɛ tɔ́ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nɨ́ Yěsù adʉ̀ ɔtsʉ́na nʉ́lɨ ɨ nzónzo dɔ̌, ndɨ dhu-dzidɔ̌, ndàdʉ̀ ndɨ̀và ndàrà ányɨ̀rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wɔ̀ dhu-dzidɔ̌, atdí alɛ nɨ́ɨra Yěsù-tɨ’ɔ̀, ndàdʉ̀ dhu ìvu kà-tsʉ̌ ndàtɨ: «Màlimǒ, àdhu ndɨ ídzì dhu tɨ́ ma màkǎ mɔnzɨ̀, ndɨ́nɨ̌ ma mabá tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga?» ");
INSERT INTO niy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nɨ́ Yěsù adʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Ádhu nyɨ nyɨ́ dhu ìvǔ tsʉ̀dú ídzì dhu tɨ́ rɨ́’ɨ̀ dhu dɔ̌ nɨ̌? Atdí alɛ kɛ̀lɛ̌ nɨ́ ndɨ ídzì alɛ tɨ́ rɨ́’ɨ̀. Nyɨ nyapɛ́ nyozè nyotsù dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀, nɨ́ dhu àkǎ nyɨfʉ Músà bhà Ʉyátá.» ");
INSERT INTO niy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nɨ́ wɔ̀ alɛ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Ɨ́ngbǎgà Ʉyátá ɨ?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Dhu àkǎ nzá nyohò abvo, dhu àkǎ nzá nyɔnzɨ̀ mʉ̀nyɔ̀nɨ̀, dhu àkǎ nzá nyɔnzɨ̀ ogbo, ndɨrɔ̀ dhu àkǎ nzá nyʉnɔ̀ tɨ̀tɔ̀ ɔdhɨ̀nʉ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Dhu àkǎ nyɨfʉ àbanʉ mà ɨ́yànʉ mànà, ndɨrɔ̀ dhu àkǎ nyozè ɔdhɨ̀nʉ yà nyɨ nyʉ́ nyɨ nyózè nyɨ nyɨ-tɨ́rɔ̀ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɨ́ wɔ̀rɨ́ kpatsìbhíngba náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ma mɨ́fʉ wà kɔ̌kɔ̀rɨ́ Ʉyátá kɔ́rɔ́, nɨ́ ádhu ndɨ àkǎkǎ mɔnzɨ̀ tdɨ́tdɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyapɛ́ nyozè nyɨ’ɨ̀ àkǎkǎ alɛ tɨ́, nɨ́ árà, nyadʉ̀ kɔ́rɔ́ nyɨ nyarɨ́’ɨ̀ nà dhu núdzi, nyadʉ̀ ɨ dhu ɔ̀ rɔ̀ nyɨ nyòngyè fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ nyɨ nyadʉ̀ya ònzì nábà ɔ̀rʉ̀-akpà ɔ̀. Wɔ̀ dhu-dzidɔ̌, nyádʉ̀ nyɨra, nyadʉ̀ owùdu nʉ́ngʉ.» ");
INSERT INTO niy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pbɛ́tʉ̀, wɔ̀ kpatsìbhíngba níitdègu wɔ̀ ɔtɛ nɨ́rɨ, nɨ́ kǎdʉ̀ àrà ányɨ̀rɔ̌ rɔ̀ atdídɔ̌ ɨzʉ nʉ́ka ndɨ̀ rɔ́rɔ̀, atdídɔ̌ ndɨ̀ ndónzì nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ònzìtálɛ rǒtsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ dhu nɨ́ odú dhu nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndɨrɔ̀, ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀ tdɨ́tdɔ̌: ngàmɨyà rǒtsù, ndʉ̀dà sìndanɨ̀-bhu ɔ̌ dhu rɨ̌’ɨ̀ ɨsɔ́. Pbɛ́tʉ̀, ònzìtálɛ rǒtsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ dhu rɨ̌’ɨ̀ odú nyʉ́ ròsè.» ");
INSERT INTO niy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nɨ́ wɔ̀rɨ́ ɔtɛ ɨ̀ ɨ̀rɨ̀ rɔ̀, ɨdhɔ nʉ́ʉkɔ Yěsù bhà ábhàlɨ̌ atdídɔ̌. Nɨ́ abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀ dhu bhěyi kà rɨ̌’ɨ̀ rɔ̀, ádhɨ pbá alɛ ndɨ ɔ̀gʉ̀ rádʉ̀ ɔ̀gʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nɨ́ Yěsù andà abádhí, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ìndrǔ tɔ̀ ndɨ dhu rɨ̌ nzɨ̌ àkǎ, pbɛ́tʉ̀ Kàgàwà tɔ̀ kà rɨ̌ àkǎ àkǎ.» ");
INSERT INTO niy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ adʉ̀ ɔtɛ ɔ̀pɛ̀, ndàtɨ: «Ɨ́rɨ, mǎ mʉ́bhà kɔ́rɔ́ dhu mǎdʉ̀ owùnʉ nʉ́ngʉ, nɨ́ ádhu ndɨ mǎ mabáya?» ");
INSERT INTO niy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: yà adzɨ dɔ̌ kɔ́rɔ́ dhu rɨ̌ ’ʉ̀wʉ̌, ’òngò ɔwʉ́tána tɨ́ rɔ̀, Ìndrǔ t’ídhùnà náadɨ̀ya pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ tɔ́ tombi dɔ̌. Ndɨ nɨ́nganɨ́, nyɨ̌, yà owùdu nyɨ̌ nyʉ́ngʉ rɔ̀, nyɨ̌ nyokoya átɔ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà tombi dɔ̌, nyǎmbɛ atdí kumì dɔ̀ná ɔ́yɔ̌ nà Pbàìsràyélí tɔ́ rʉ̀gànda-tsʉ̀-ànyǎ nɨ́tdɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ndɨrɔ̀ ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà, yà okúdu dɔ̀ rɔ̀ rɨ́ pbɨ̀ndà ɨdza, adɔ́na, awɛ́na, àbanà, ɨ́yànà, pbɨ̀ndà inzo, ndɨrɔ̀ pbɨ̀ndà ɔnzɨbvʉ mà nʉ́bha, náabáya ɨ dhu atdí mɨyà-gʉ̀na ròsè. Ndɨrɔ̀, kǎdʉ̀ya dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pbɛ́tʉ̀, ábhɔ̌ alɛ yà kòmbí arɨ́’ɨ̀ wɛmbɛrɛ̀ tɨ́ nóongoya olù alɛ tɨ́, ndɨrɔ̀ yà olù alɛ tɨ́ arɨ́’ɨ̀ kòmbí alɛ náadʉ̀ya òngo wɛmbɛrɛ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ́: «Obhó tɨ́, yàrɨ́ nɨ́ ndɨ Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɔ́fɔ̀ ndɨ̀ nà dhu: Atdí ɨdza-àbadhi náahʉ̀ bhɔ̌tsʉngánǎ ɨdza rɔ̀, ndàmbɛ kasʉtálɛ nɔ́mɛ̀ dɔ̌, ndɨ́nɨ̌ owu tɨ́ kasʉ ɔ̀nzɨ̀ pbɨ̀ndà vǐnyò tɔ́ ɨnga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Abádhí nɨ́ɨrɨ ɨ̀ ɨ kasʉtálɛ mànà atdí dɨ̀narɨ̀-kpɔ̌ dɔ̌ atdíku ɨdhɔ tɔ́ kasʉ tɔ́ mʉ̀kɨ̀mbà tɨ́. Kǎdʉ̀ ɨ alɛ nóvì ròwù vǐnyò tɔ́ pbɨ̀ndà ɨnga-bvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tdɨ́tdɔ̌, kǎhʉ̀ ɨ̀bhʉ adyifɔ̀-sɨsɨ̀ kútsingá nga tɔ́ ɔ̌, ndàdʉ̀ ngʉ̌kpà alɛ nála pbanga-tsidɔ̌ róko ɨ̀mbǎ kasʉ́na rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nɨ́ kǎdʉ̀ àtɨ̀nà ɨ alɛ nɨ̌: ‹Nyɨ̌ mà átɔ̀, nyòwu nyɔ̀nzɨ kasʉ vǐnyò tɔ́ pbàkà ɨnga ɔ̀, tdʉ̌ ma mádʉ̀ fʉ̀kʉ́ mʉ̀kɨ̀mbà núbho àkǎkǎ dhu bhěyi.› ");
INSERT INTO niy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nɨ́ ɨ alɛ náadʉ̀ òwu ndɨ vǐnyò tɔ́ ɨnga ɔ̀. Wɔ̀ ɨdza-àbadhi náahʉ̀ tdɨ́tdɔ̌ azà adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌, ndɨrɔ̀ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ adyídɔ̌ nga tɔ́ ɔ̌, ndàdʉ̀ dhu ɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kà rǐku dɔ̀ná rɔ̀ nɨ̌, kǎhʉ̀ atdí kumì dɔ̀ná atdí nà adyifɔ̀-sɨsɨ̀ pbɨ́tsɔ̀ngǎ nga tɔ́ ɔ̌, ndàdʉ̀ ngʉ̌kpà alɛ nála pbanga-tsidɔ̌ òkò, ɨ̀nzɨ̌ ɨ̀ ɨ́ atdí dhu mà nɔ́nzɨ rɔ́rɔ̀ rɔ́. Nɨ́ kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: ‹Ádhu, rɔ̀pɛ̀ ndɨ̀ kútsingánǎ rɔ̀ rɨ̀rà àhʉ kòmbí, nyɨ̌ nyòkò ɨrɔ́ ɨ̀nzɨ̌ nyɨ̌ nyɨ́ atdí dhu mà nɔ́nzɨ rɔ́rɔ̀ nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: ‹Ɨnzá nɨ́ atdí alɛ mà nápɛ̀ mǐtsǔ pbɨ̀ndà kasʉ ɔ̀.› Nɨ́ kǎdʉ̀ àtɨ̀nà ɨ alɛ nɨ̌: ‹Olu nyɨ̌ mà átɔ̀, nyòwu nà nyɔ̀nzɨ kasʉ pbàkà vǐnyò tɔ́ ɨnga ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nɨ́ pbɨ́tsɔ̀ngánǎ, wɔ̀ ɨnga-àbadhi náatɨ pbɨ̀ndà kasʉtálɛ tɔ́ ádrʉ̀ngbǎlɛ nɨ̌: ‹Únzi kasʉtálɛ, nyadʉ̀ fɨ̀yɔ́ mʉ̀kɨ̀mbà núbho. Nyɨ nyɨ́ kɔ̀pɛ̀ yà olù kasʉ nɔ̀pɛ̀ alɛ rɔ̌ rɔ̀, nyadʉ̀ àrà kʉ̀tsà yà angyi kasʉ nɔ̀pɛ̀nà alɛ rɔ̌.› ");
INSERT INTO niy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nɨ́ yà atdí kumì dɔ̀ná atdí nà adyifɔ̀-sɨsɨ̀ pbɨ́tsɔ̀ngǎ nga tɔ́ ɔ̌ kasʉ nɔ̀pɛ̀ alɛ níiwú, kadʉ̀ ngǎtsi alɛ bhà atdí dɨ̀narɨ̀ nábhʉ ndɨ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yà angyi kasʉ nɔ̀pɛ̀nà alɛ níiwú ùvò átɔ̀. Abádhí nɨ́ɨrɛ̀ nga fɨ̌yɔ̀ ka kúbhǒna mʉ̀kɨ̀mbà ràrǒse òse yà olù kasʉ nɔ̀pɛ̀nà alɛ tɔ́ mʉ̀kɨ̀mbà dɔ̀nǎ. Pbɛ́tʉ̀, abádhí mà átɔ̀ náadʉ̀ atdátdí dɨ̀narɨ̀ kɛ̀lɛ̌ nábà. ");
INSERT INTO niy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nɨ́ kàkɔ̌ ɨ̀ ɨ́ rɔ̀, kɔ̌kɔ̀ alɛ náapɛ̀ ’àmbɛ ònu dɔ̌ ɨnga-àbadhi nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Abádhí atɨ kà nɨ̌: ‹Kǎkà kasʉtálɛ níwǔ ùvò olù, ’àdʉ̀ kasʉ nɔ́nzɨ̀ atdí adyifɔ̀-sɨsɨ̀ kɛ̀lɛ̌ tɨ́. Nɨ́ nyɨ nyàdʉ̀ tɨ́ mʉ̀kɨ̀mbà núbho abádhí tɔ̀ àdhàdhɨ̀ mǎ mànà, àzèmbè mǎ’ɨ nɨ́ ndɨ bìlǐ mǎ mɔ̀nzɨ̀ kasʉ, adyifɔ̀ ràdʉ̀ mɔ̌bɨ̀ rɔ̀?› ");
INSERT INTO niy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nɨ́ wɔ̀ alɛ adʉ̀ dhu àdu atdí abádhí nzínzì ɔ̌ alɛ tɔ̀, ndàtɨ: ‹Pbǎlɛ́ ma mɔ̀nzɨ̀ nzá nyɨ nzɛ́rɛ. Nyɨ nyà’ùnà tɨ́ nzá atdí dɨ̀narɨ̀ rɔ̌ nyɨ nyɨ́ kasʉ nɔ́nzɨ atdí ɨdhɔ ɔ̌ dhu? ");
INSERT INTO niy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɨ́rɔ̀, ákɔ̌ ɨndʉ́ mʉ̀kɨ̀mbà, nyadʉ̀ àrà ɨndʉ́ dhu nɨ̌. Ma mòzè mabhʉ ka wɔ̀ olù ɨ̀rànà alɛ tɔ̀ àdhàdhɨ̀ ɨndʉ̀ ma màbhʉ ka dhu bvʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma mádʉ̀ pbàkà fʉ̀rangà nʉ́ndɔ̀ ma mòzè ka dhu bhěyi. Tɨ́ nzɨ̌ obhó? Ndɨrɔ̀ yà ma mɔ̀nzɨ̀ ídzì dhu nyɨ nyàla tɨ́ nzɛ́rɛ dhu ma mɔ̀nzɨ̀ dhu tɨ́?›» ");
INSERT INTO niy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nɨ́ Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Yà kòmbí arɨ́’ɨ̀ olù alɛ tɨ́ alɛ nóongoya wɛmbɛrɛ̀ tɨ́, ndɨrɔ̀ yà kòmbí arɨ́’ɨ̀ wɛmbɛrɛ̀ tɨ́ alɛ náadʉ̀ya òngo olù alɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndúpo rɔ́rɔ̀, Yěsù náanzi pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ igi. Nɨ́ otu ɔ̌ ɨ̀ ówu rɔ́rɔ̀, kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: ");
INSERT INTO niy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Kànɨ̌ àlɛ̌ kúpo Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, nɨ́ ányɨ̀ ka kɨ́ Ìndrǔ t’ídhùnà nípfǒ kabhʉ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà fɔ́. Abádhí rɨ̌ anya nɔ́tdɨ̀ kà-dɔ̌ ndɨ́nɨ̌ ka koho tɨ́ ka, ");
INSERT INTO niy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","’àdʉ̀ kàbhʉ ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí-fɔ́. Ɨ alɛ rɨ̌ kɔ̀zʉ̀ àkyǎkyɛ̀ alɛ tɨ́, ’àdʉ̀ kʉ̀vɨ asé nɨ̌. Ndɨrɔ̀ abádhí rɨ̌ kʉ̀tɔ̌ mʉ̀sàlabhà dɔ̌, rɔ̀vɛ̀, kadʉ̀ ɔ̀tdʉ̀nà. Pbɛ́tʉ̀, ɨ̀bhʉ ɨdhɔ dzidɔ̌, kǎdʉ̀ya ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wɔ̀ dhu-dzidɔ̌, Zɛ̀bɛ̀dayò bhà ɨngba-tsánà mà, pbɨ̀ndà ɔ́yɔ̌ inzo mànà náandrì Yěsù-tɨ’ɔ̀. Nɨ́ ndɨ ɨngba-tsánà náakɔ̀ ndɨ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndɨ́nɨ̌ ndɨ̀ ndonzi tɨ́ dhu kà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nɨ́ Yěsù ivú dhu kà-tsʉ̌ ndàtɨ: «Ádhu nyɨ nyòzè?» Nɨ́ kǎdʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Pbʉ̀kʉ̀ ádrʉ̀ngbǎnga tɔ́ idzi ɔ̌, ábhʉ̌ kǎkà pbàkà ɔ́yɔ̌ inzo ròkò tɨnʉ́, atdí ràdɨ ɨndʉ́ fangà dɔ̀nǎ rɔ̀, ngǎtsi ràdʉ̀ àdɨ ígù dɔ̀nǎ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Nyɨ̌ nyʉ̀nɨ nzá wɔ̀ nyɨ̌ nyónzina fudú dhu. Nyɨ̌ tɨ́ àdʉ̀ yà ma mɔ́mvʉ̀na àpbɛ̀ tɔ́ kɔ́pà-tsʉ̀ nɔ́mvʉ̀ ɔ̀mvʉ̀?» Nɨ́ wɔ̀ ɨngba-tsánà mà náadʉ̀ dhu àdu Yěsù tɔ̀, àtɨ: «Ɔ̀mvʉ̀ mǎ mádʉ̀ ɔ̀mvʉ̀nà.» ");
INSERT INTO niy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Obhó tɨ́, ɔ̀mvʉ̀ nyɨ̌ nyɔmvʉ́ya ma mɔ́mvʉ̀na kɔ́pà-tsʉ̀. Pbɛ́tʉ̀ ìndrǔ nɨ́lɨ̌ ka kɨ́ ràdɨ idú fangà dɔ̀nǎ rɔ̀, ndɨrɔ̀ idú ígù dɔ̀nǎ rɔ̀ dhu nɨ́ nzɨ̌ ɔ̀tɛ̌du. Ɨ ngari nɨ́ yà Àbadu náabhɔ̀lɔ̀ ka fɨ̌yɔ̀ alɛ tɔ́.» ");
INSERT INTO niy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, atdí kumì ngʉ̌kpà ábhàlɨ̌ náadʉ̀ àkǒ àkǒ tɨ́ kɔ̌kɔ̀ ɔ́yɔ̌ atdí iya bhà alɛ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nɨ́ Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ nánzì tɨna ɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyʉ́nɨ wà yà ìndrǔ dɔ̌ ádrɔ̀drɔ̌ alɛ tɨ́ ka kátɨna alɛ náarádʉ̀ ɨ alɛ nʉ́lɨ fɨ̀yɔ́ ɨnɔ tɨ́, ’àmbɛ avu dɔ̌ rɔ̀yá dhu. Ndɨrɔ̀, nyɨ̌ nyʉ́nɨ wà yà ádrɔ̀drɔ̌ alɛ náarádʉ̀ ɔbɨ̀ya à’ɛ ìndrǔ dɔ̌ tɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pbɛ́tʉ̀, dhu àkǎ nzá ndɔ̀nzɨ̀ ndɨ̀ ndɨ dhu bhěyi nzínzìkʉ ɔ̌. Atdí nzínzìkʉ ɔ̌ alɛ náapɛ́ ndòzè ndàdɨ ádrʉ̀ngbǎlɛ tɨ́, nɨ́ kà rǎdʉ̀ àkǎ ndɨ̀’ɨ̀ fʉ̀kʉ́ kasʉtálɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ndɨrɔ̀ atdí nzínzìkʉ ɔ̌ alɛ náapɛ́ ndòzè ndàdɨ wɛmbɛrɛ̀ tɨ́, nɨ́ ndɨ alɛ rǎdʉ̀ àkǎ ndɨ̀’ɨ̀ fʉ̀kʉ́ ɨnɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndɨ dhu bhěyi nɨ́ ndɨ, Ìndrǔ t’ídhùnà nɨ́rà nzá ndɨ́nɨ̌ ka kɔnzɨ tɨ́ kasʉ fɨ̌ndà. Pbɛ́tʉ̀ kɨ̌rà ndɨ́nɨ̌ ndɔnzɨ tɨ́ kasʉ ngʉ̌kpà alɛ tɔ̀, ndàdʉ̀ pbɨ̀ndà ípìrɔ̌nga nábhʉ ábhɔ̌ alɛ nʉwʉ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yěsù mà rǔvò pbɨ̀ndà ábhàlɨ̌ mànà Yɛ̀rɨkɔ̀ tɔ́ kɨgɔ̀ ɔ̀ rɔ̀ ɔ̀nà kàsʉmɨ̀ ɔ̌, ábhɔ̌ ihé-yà náadʉ̀ òwu Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nɨ́ yà otu-gì dɔ̌ ɨ̀ òkò rɔ́ ɨ̀’ɨ̀ ɔ́yɔ̌ ndùmùndúmú nɨ́ɨrɨ Yěsù rʉ̌da dhu. Nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌: «Ádrʉ̀ngbǎlɛ, Dàwudì-dhú bvʉ̌ alɛ́, ábà ɨzʉ dɔ̀ká!» ");
INSERT INTO niy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ihé-yà náadʉ̀ òko ’àmbɛ ɔ̀rʉ̀ dɔ̌ abádhí dɔ̌, ’àdʉ̀ abádhí návi rɨ̀nɛ̀. Pbɛ́tʉ̀ kɔ̌kɔ̀rɨ́ ndùmùndúmú náadʉ̀ ùkǔ ɔrʉ́ tǔya nyʉ́ nà tdɨ́tdɔ̌, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, Dàwudì t’ídhùnǎ, ábà ɨzʉ dɔ̀ká!» ");
INSERT INTO niy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nɨ́ Yěsù adʉ̀ ìde, ndànzì abádhí, ndàdʉ̀ dhu ìvu tsʉ̀yá, ndàtɨ: «Ádhu nyɨ̌ nyòzè mɔnzɨ̀ fʉ̌kʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, ábhʉ̌ nyɨ̀kpɔ́ka ràla ɨnga.» ");
INSERT INTO niy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nɨ́ Yěsù adʉ̀ ɨzʉ nábà abádhí dɔ̌, ndàdʉ̀ abádhí-nyɨ̀kpɔ́-ngbɔ̀ nʉ́pbala. Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, kɔ̀rɨ́ ɔ́yɔ̌ alɛ náadʉ̀ ’ɔ̀pɛ̀ ’àla ɨnga, ’àdʉ̀ òwu Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɨ́kyɛ̀rɔ̌ Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà nókò Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ɨ̀ owu tɨ́ ùvò rɔ́rɔ̀, nɨ́ abádhí nʉ́ʉtɔ ɨ̀ Bɛ̀tɛ̀fagɛ̀ tɨ́ kátɨna pbanga ɔ̀. Ndɨ pbanga nɨ́ɨ’ɨ̀ mìzèyìtunì tɨ́ kátɨna itsu náarɨ́’ɨ̀ dɔ̀ná pbìrì-ɔngɔ̀ rɔ̌. Nɨ́ Yěsù náavì ɔ́yɔ̌ pbɨ̀ndà ábhàlɨ̌ ròwù angyi, ");
INSERT INTO niy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu wɔ̀ angyi rɨ́’ɨ̀ fʉ̌kʉ̀ pbanga ɔ̀. Nɨ́ ndɨ pbanga ɔ̀ nyɨ̌ nyòtsù rɔ́rɔ̀, nyɨ̌ nyɨ́ kayinǒ-yà nótù òsò ka kòsò rɔ́, pbɨ̀ndà ɨngba ràdʉ̀ ɨ̀’ɨ̀ tɨná. Nɨ́, nyʉ̀nga ka, nyǎdʉ̀ ìwu abádhí nà kɔ́rɔ́ tɨdu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɨ́ atdí alɛ mà nʉ́ʉnɔna gukyè dhu abádhí dɔ̌, nɨ́ nyɨ̌ nyadʉ̀na àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ rɨ̌’ɨ̀ abádhí-atdyú nà.› Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, ka kadʉ̀na abádhí nʉ́bhà nyǐwǔ nà.» ");
INSERT INTO niy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wɔ̀rɨ́ dhu náanzɨ̀ ndɨ̀ ndɨ́nɨ̌ angyí nabì Zàkàrɨyà nʉ́ʉnɔ dhu náaká tɨ́. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Nyàtɨ Sàyunì tɔ́ kɨgɔ̀ ɔ̌ tsìbhíngba nɨ̌: ‹Ándà! Kànɨ̌ pbʉ̀kʉ̀ kamà rɨ̌rà tɨnʉ ɔ̀! Kà rɨ̌rà ɨ̀yɔ̀nga nyʉ́ ɔ̌, kayinǒ-yà dɔ̌ ndɨ̀ ndàdɨ rɔ́rɔ̀, kayinǒ-yà bhà ɨngba dɔ̌ ndɨ̀ ndàdɨ rɔ́rɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nɨ́ ábhàlɨ̌ náawù, ’àdʉ̀ yà Yěsù àvinà fɨ̌yɔ̀ dhu nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Abádhí níiwú kayinǒ-yà nà pbɨ̀ndà ɨngba mànà, ’àdʉ̀ rɔ̀yá ɔrʉ́ mʉ̀dzarʉ̀ núhu dɔ̀yá, Yěsù ràdʉ̀ àdɨ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ábhɔ̌ ihé-yà núuhu rɔ̀yá mbɛrʉ̀ otu ɔ̌. Ngʉ̌kpà alɛ náadʉ̀ itsu-dɔ̀ká nɔ́kɔ̀, ’àdʉ̀ ùhunà otu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɨ́ yà angyi rówu Yěsù-ɔ̀nzɨ̌ alɛ mà, kǒwù ɔ̌ ríwu alɛ mànà náambɛ́nà ùkǔ dɔ̌, ’àtɨ: «Hɔ̀sanà! Ilèta nákǎ kabhʉ Dàwudì-dhú bvʉ̌ alɛ tɔ̀! Kàgàwà nákǎ ndàso Ádrʉ̀ngbǎlɛ-ɔvɔ̀ rɔ̌ rɨ́rà alɛ! Hɔ̀sanà! Ilèta nákǎ kabhʉ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Kàgàwà tɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nɨ́ Yěsù rǒtsù Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, kɔ́rɔ́ alɛ-tsì náava ndɨ̀, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀rɨ́ alɛ tɨ́ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nɨ́ ihé-yà noowúnà dhu àdu rɔ̌ abádhí tɔ̀, ’àtɨ: «Nabì Yěsù nɨ́ yà, Nàzàretì-alɛ, Gàlìlayà tɔ́ pbìrì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Wɔ̀ dhu-dzidɔ̌, Yěsù náatsù Kàgàwà bhà-dza ɔ̀, ndàdʉ̀ ányɨ̀-dzá rɔ̀ rɨ́ dhu òdzi alɛ mà, ányɨ̀-dzá rɔ̀ rɨ́ dhu ùdzǐ alɛ mànà dhu nódì kɔ́rɔ́. Kǎdʉ̀ fʉ̀rangà-ɔ̌nga nʉ́wʉ̌ rɨ́ alɛ rɨ̌ fʉ̀rangà nʉ́wʉ̌ dɔ̀ná rɔ̀ mɨzà mà, àmbò núdzǐ rɨ́ alɛ nókò dɔ̀yá tombi mànà dhu nátdi. ");
INSERT INTO niy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà ɨ alɛ nɨ̌: «Kàgàwà bhà bhǔkù ɔ̀ Andítá rǎtɨna: ‹Pbàkà ɨdza nɨ́ ka kanziya ɨtsɔ̀ta-dzà tɨ́, pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyàdʉ̀ kʉ̀gɛ̀rɛ̀ ròngò ogbotálɛ náarɨ́ ’ùru ɔ̀ná ngari tɨ́.›» ");
INSERT INTO niy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wɔ̀ dhu-dzidɔ̌, ndùmùndúmú mà, otsutálɛ mànà níiwú Yěsù-tɨ’ɔ̀ Kàgàwà bhà ɨdza ɔ̌, ka ràdʉ̀ ɨ̀ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà náakó yà Yěsù rɔ̌nzɨna wɨwɨ̀ ɨ̀ àla rɔ̀, ndɨrɔ̀ nzónzo rǔkǔ Kàgàwà bhà ɨdzá dhu ɨ̀ ɨ̀rɨ̀ rɔ̀. Ɨ nzónzo ambɛ́nà àtɨ̀nà dɔ̌: «Hɔ̀sanà! Ilèta nákǎ kabhʉ Dàwudì dhú-bvʉ̌ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Abádhí adʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Nyɨ tɨ́ kɔ̌kɔ̀ nzónzo rʉ̌nɔna dhu nɨ́rɨ ɨ̀rɨ?» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀rɨ ma mɨ́rɨna! Nyɨ̌ nyàpɛ̀ tɨ́ nzá Kàgàwà bhà bhǔkù ɔ̀ ka kándǐ dhu nɔ́zʉ̀? Ndɨ Andítá rǎtɨna: ‹Nyɨ nyábhʉ nzónzo mà, ndɨrɔ̀ ɨrɛ́-nzo mànà dhu ràmbɛ nyɨfʉ dɔ̌.›» ");
INSERT INTO niy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ ndɨ̀và pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà tɨ́ rɔ̀, ndàdʉ̀ àhʉ kɨgɔ̀ ɔ̀ rɔ̀, ndàrà Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̀. Ányɨ̀ nɨ́ ndɨ kǎdʉ̀ àrà ɔ̀dhɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tsútsǎ nɨ́nganɨ́ kútsingánǎ Yěsù rǐngo Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kɨ̌’ɨ̀ àwù nà. ");
INSERT INTO niy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nɨ́ kǎla mùtinì tɨ́ kátɨna atdí itsu otu-gì dɔ̌, ndàdʉ̀ òndri tɨna ɔ̀. Pbɛ́tʉ̀ kǎdʉ̀ ndɨ itsu-bɨ̌ kɛ̀lɛ̌ nótù. Nɨ́ kǎdʉ̀ ndɨ itsu nófù ndàtɨ: «Rɔ̀pɛ̀ ndɨ̀ indo, atdí itsu-kpɔ̌ mà nákǎ nzá ndɔ̀’ɔ̀ dʉ̀nʉ́ tdɨ́tdɔ̌.» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ wɔ̀ itsu náadʉ̀ òtdyù atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yěsù bhà ábhàlɨ̌ náala wɔ̀ dhu, ɨdhɔ ràdʉ̀ ʉ̀kɔ atdídɔ̌. Nɨ́ abádhí adʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Wɔ̀rɨ́ mùtinì nótdyù atdídɔ̌ kòmbómbí tɨ́ ɨ̀ngbà-dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, nyɨ̌ nyapɛ́ ɨ̀’ɨ̀ a’uta nà ɨ̀nzɨ̌ afíkʉ ràdʉ̀ ùguru, nɨ́ nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ wɔ̀ itsu rɔ̌ ma mɔ̀nzɨ̀ dhu kɛ̀lɛ̌ nɔ́nzɨ̀. Pbɛ́tʉ̀, nyɨ̌ nyádʉ̀ àtɨ̀nà yà pbìrì nɨ̌ màtɨ́: ‹Ɨ́ngbɛ̀ nyɨ ʉrɔ́ rɔ̀, nyadʉ̀ àrà ɨ̀tsɨ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̀!› Nɨ́ ndɨ dhu rǎdʉ̀ ndɔ̀nzɨ̀ yà nyɨ̌ nyʉ̀nɔ̀ ka dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nyɨ̌ nyapɛ́ ɨ̀’ɨ̀ a’uta nà, nɨ́ nyɨ̌ nyádʉ̀ fʉ̀kʉ́ ɨtsɔ̀ta ɔ̌ nyɨ̌ nyònzì kɔ́rɔ́ dhu-tsí nábà àbà.» ");
INSERT INTO niy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wɔ̀ dhu-dzidɔ̌, Yěsù atsù Kàgàwà bhà ɨdza, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ìndrǔ tɔ̀. Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí-bvʉ̌ pbàkʉ̀rʉ̌ mànà náandrì Yěsù-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Ádhɨ nyɨ návi nyongò kɔ́rɔ́ kɔ̀rɨ́ dhu nɔ́nzɨ? Ádhɨ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ ɨndʉ̀ nyongò ɨ dhu nɔ́nzɨ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ atdí dhu kɛ̀lɛ̌ nívǔ tsʉ̀kʉ́. Nyɨ̌ nyapɛ́ ndɨ dhu nádǔ idù, nɨ́ ma mádʉ̀ ma márɨ́ ɨ dhu nɔ́nzɨ pbɨ̀ndà ɔbɨ nɨ̌ alɛ nʉ́nɔ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ádhɨ Yùwanɨ̀ nivi rɨ̀rà bàtizò núbho ìndrǔ tɔ̀? Tɨ́ Kàgàwà, ndɨrɔ̀ ngǎtsi nɨ̌ tɨ́ ìndrǔ?» Pbɛ́tʉ̀ abádhí náadʉ̀ ’ɔ̀pɛ̀ ’ɨ̀rɛ̀ nga nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Àlɛ̌ kapɛ́ dhu àdǔ Kàgàwà ràrɨ̌ ndɨ ka nivi, nɨ́ kǎdʉ̀na dhu ìvu àlɛ̌-tsʉ̌ ndàtɨ: ‹Olu, ádhu ɨnzá nyɨ̌ nyadʉ̀ Yùwanɨ̀ nʉ́nɔ̀ dhu ná’ù nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ndɨrɔ̀ àlɛ̌ kapɛ́ àtɨna, ìndrǔ ràrɨ̌ ndɨ ka nivi, nɨ́ àlɛ̌ kɨ́ ihé-yà-ɔdɔ̀ nɔ́nzɨ, kɔ́rɔ́ alɛ náarɨ́ Yùwanɨ̀ nɔ́zʉ̀ Kàgàwà bhà nabì tɨ́ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nɨ́rɔ̀ nɨ́ ndɨ abádhí adʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Ɨnzá mǎ mʉ̀nɨ.» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨma nyʉ́ mà átɔ̀, ma mɨ́ nzɨ̌ ɨ dhu nɔ́nzɨ ma márɨ́ nɨ̌ ɔbɨ nʉ́nɔ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ dhu ìvu tdɨ́tdɔ̌ abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɨ̀rɛ̀ yà ma máwɛ̌na mbólí dɔ̌? Atdí alɛ nɨ́ɨ’ɨ̀ ɔ́yɔ̌ pbɨ̀ndà kpabhínzo nà. Nɨ́ kʉ̌nɔ dhu atdí ɨngba tɔ̀ ndàtɨ: ‹Pbànɨ̌ngbá, árà nyɔnzɨ kasʉ vǐnyò tɔ́ ɨnga ɔ̀ indo.› ");
INSERT INTO niy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wɔ̀ ɨngba náadʉ̀ dhu àdu àbanà tɔ̀, ndàtɨ: ‹Ɨ̀nzɨ̌ ma márà àwólò!› Pbɛ́tʉ̀ olù nyʉ́, kʉ̌gɛ̀rɛ̀ pbɨ̀ndà ɨrɛ̀ta, ndàdʉ̀ ndɨ̀và, ndàrà vǐnyò tɔ́ ɨnga-bvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tdɨ́tdɔ̌ wɔ̀ alɛ nʉ́ʉnɔ àdhàdhɨ̀ dhu kɛ̀lɛ̌ ngǎtsi pbɨ̀ndà ɨngba tɔ̀. Nɨ́ ndɨ-tsí náadʉ̀ dhu àdu àbanà tɔ̀, ndàtɨ: ‹Àrà ma márà àbá.› Pbɛ́tʉ̀ kǎdʉ̀ nzá àrà ndɨ ɨnga-bvʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɨ́ Yěsù adʉ̀ dhu ìvu pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà-tsʉ̌ ndàtɨ: «Ádhɨ ndɨ kɔ̌kɔ̀ ɔ́yɔ̌ kpabhínzo nzínzì ɔ̌, àbanà òzè dhu nanzɨ̀?» Nɨ́ abádhí adʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Yà angyi àbanà àvinà ràrà kasʉ ɔ̀nzɨ̀ ɨngba.» Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ mà, mʉ̀nyɔ̀nɨ̀ tɔ́ vèbhálɛ mànà nóowuya ùvò angyi rʉ̀kʉ́ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Obhó tɨ́, bàtizò nubhónà Yùwanɨ̀ nɨ́ɨra bvʉ̀kʉ̀, ndàdʉ̀ obhónánga tɔ́ otu nɨ́tɛ̀ fʉ̌kʉ̀, nɨ́ nyɨ̌ nyadʉ̀ nzá kà rʉ̌nɔna dhu ná’ù. Pbɛ́tʉ̀ pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ mà, mʉ̀nyɔ̀nɨ̀ tɔ́ vèbhálɛ mànà nɨ́ ɨ kà rʉ̌nɔna dhu na’u. Ndɨrɔ̀ wɔ̀ ndɨ dhu mà nyɨ̌ nyàla rɔ̀, nyɨ̌ nyadʉ̀ nzá nyʉ̌gɛ̀rɛ̀, nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga, nyǎdʉ̀ Yùwanɨ̀ rʉ̌nɔna dhu ná’ù.» ");
INSERT INTO niy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà nɨ̌: «Nyɨ̀rɨ ngǎtsi mbólí. Atdí alɛ náazò pbɨ̀ndà vǐnyò tɔ́ ɨnga, ndàdʉ̀ ngbɔ̌na nákpɔ̀rɔ̀ kɔrɔwà nɨ̌. Kǎdʉ̀ ndɨ vǐnyo-kpɔ̌ náhà ka kóngo ɔ̀ná ibhu nógyè, ndàdʉ̀ ini nɔ́sɨ̀ ndɨ ɨnga ɔ̌ ɔdɔ́tálɛ tɔ̀. Wɔ̀ dhu-dzidɔ̌, àbadhi mà náadʉ̀ ’ɨ̀rɨ̀ ndɨ ɨnga-kàsʉ̌ nɔ́nzɨ̀ róngo alɛ mànà, ndɨ́nɨ̌ ɨ̀ owu tɨ́ ndɨ ɨnga ɔ̌ ɔ̀’ɔ̀ dhu-ɔ̌nga nʉ́ndɔ̀ rɔ̌ ɨ alɛ mànà. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɨ̀và ndàrà abhi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nɨ́ ndɨ vǐnyò-kpɔ̌ nɔ́pɛ̀ ka kɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, kǎvì ngúfe alɛ pbɨ̀ndà kasʉtálɛ nzínzì ɔ̌ ròwù fɨ̌ndà ka kútù vǐnyò-kpɔ̌-tsí nákɔ, ndɨ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pbɛ́tʉ̀, kɔ̀rɨ́ alɛ náadʉ̀ kɔ̌kɔ̀ ùvǐ ka kùvǐ alɛ nʉ́lʉ ʉ̀lʉ̌ tɨ́. Abádhí náavɨ̀ atdí, ’àdʉ̀ atdí nóhò, ndɨrɔ̀ ’àdʉ̀ ɨ̀bhʉ rɨ́ kìsě-tsí núbvu odu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tdɨ́tdɔ̌ wɔ̀ ɨnga-àbadhi náavì ibí ngʉ̌kpà kasʉtálɛ, ròsè yà angyi ɨ́’ɨ̀ dɔ̀na nǎ. Nɨ́ kɔ̌kɔ̀ vǐnyò tɔ́ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ náadʉ̀ ɨ alɛ nɔ́nzɨ̀ yà angyi ɨ’ɨ̀ alɛ ɨ̀ anzɨ̀ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nɨ́ kà rǐku dɔ̀ná rɔ̀ nɨ̌, wɔ̀ ɨnga-àbadhi náavì idhùnà nyʉ́ ràrà kɔ̌kɔ̀ pbɨ̀ndà ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ-tɨ’ɔ̀. Kǎdʉ̀ ɨnga ɨ̀rɛ̀ afína ɔ̀ ndatɨ: ‹Ɨ̀fʉ̌ abádhí rɨ̌ idhùdu nyʉ́ nɨ́fʉ̌.› ");
INSERT INTO niy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pbɛ́tʉ̀, wɔ̀ vǐnyò tɔ́ ɨnga kàsʉ̌ nɔ́nzɨ arɨ́ alɛ níitdègu wɔ̀ ɨnga-àbadhi t’ídhùnà nálǎ, nɨ́ abádhí atɛ̀ nzínzìya ɔ̌ ’àtɨ: ‹Kɔ̀nɨ̌, ɨnga-àbadhi tɨ́ ongoya olù alɛ nyʉ́ nɨ́ wɔ̀. Kòwu kòho ka, ndɨ́nɨ̌ ɨnga adʉ̀ tɨ́ àdɨ àlɛ̌ tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nɨ́ abádhí náalʉ́ ɨnga àbadhi t’ídhùnà, ’ìpfo ɨnga ɔ̀ rɔ̀, ’àdʉ̀ òhònà!» ");
INSERT INTO niy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nɨ́ Yěsù adʉ̀ dhu ìvu pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà-tsʉ̌, ndàtɨ: «Nyɨ̌ nyʉ̀nɨ rɔ̀, wɔ̀ ɨnga-àbadhi rɨ̌rà àhʉ nɨ́nganɨ́, kɔ̌nzɨya wɔ̀ vǐnyò tɔ́ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ ɨ̀ngbà dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nɨ́ abádhí adʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Kɔ̌kyɛya kɔ̌kɔ̀ nzɛ́rɛ alɛ ɨ̀mbǎ ɨzʉ́ na, ndàdʉ̀ ndɨ vǐnyò tɔ́ ɨnga-kàsʉ̌ nábhʉ ngʉ̌kpà alɛ-fɔ́. Ɨ alɛ nɨ́ ɨ, kà tɔ̀ róngo àdʉ̀ òwu yà kà tɔ̀ ɨ̀ ùtù vǐnyò-kpɔ̌-tsí nábhʉ rɔ̌, ndɨ vǐnyò-kpɔ̌ ɨ̀ ɔ̀pɛ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tdɨ́tdɔ̌ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyàpɛ̀ tɨ́ obhó Kàgàwà bhà bhǔkù ɔ̀ ka kándǐ dhu ɔ̀zʉ̀? Ndɨ Andítá rǎtɨna: ‹Yà odu-dzà nɔ́sɨ̀ arɨ́ alɛ náabvù igi odu, nɨ́ ndɨ adʉ̀ òngo ɨdza-pbɨdɔ̀ nɔ́dɔ rɨ́ ádrʉ̀ngbǎ odu tɨ́. Ádrʉ̀ngbǎlɛ Kàgàwà nɨ́ ndɨ ndɨ dhu nanzɨ̀, ndɨrɔ̀ ndɨ dhu nɨ́ ɨdhɔ rɨ̌ àlɛ̌ nʉ́kɔ̌ nɨ̌.› ");
INSERT INTO niy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mátɨna nyɨ̌ nɨ̌: ka kakɔ̀ya Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi fʉkʉ́ rɔ̀, kadʉ̀ àbhʉnà yà ndɨ idzi-ɔ̌nga nà àkǎ itse nɔ́dhɨ̀ rádʉ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yà ndɨ òbvù ka kabvù odu dɔ̌ rɨ́tsɨ̀ alɛ nɨ́ ɔ̌nga nɨ́ɨkɔ̀ya ndɨ̀ ɨ̀kɔ̀ tɨ́, ndɨrɔ̀ ndɨ odu rɨ̌tsɨ̀ dɔ̀ná alɛ nɨ́ ɔ̌nga kɨ̌nyɨrɨya ɨ̀nyɨrɨ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà níitdègu kɔ̌kɔ̀ Yěsù àwɛ mbólí nɨ́rɨ, nɨ́ abádhí adʉ̀ dhu nɔ́sʉ̀ ɨ̀ ràrɨ̌ ndɨ Yěsù rɔ̌tɛ dɔ̀yá. ");
INSERT INTO niy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀mɛ̀ Yěsù nálʉ̌ ɨ̀’ɨ́ ɔ̀ná otu. Pbɛ́tʉ̀, abádhí náadʉ̀ ihé-yà-ɔdɔ̀ nɔ́nzɨ̀, kɔ́rɔ́ alɛ nʉ́ʉnɨ dhu Yěsù ràrɨ̌ Kàgàwà bhà nabì nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù náapɛ̀ ndɔ̀vɔ̀ dhu tdɨ́tdɔ̌ ihé-yà tɔ̀ mbólí ɔ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Kànɨ̌ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɔ́fɔ̀ ndɨ̀ nà dhu: ‹Atdí ádrʉ̀ngbǎ kamà náahʉ̀ ndɔ̀nzɨ̀ mʉ̀hɛndʉ̀ idhùnà bhà ndrǔ-àyi ka kʉ̀ndà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nɨ́ kǔví pbɨ̀ndà kasʉtálɛ ròwù ndɨ mʉ̀hɛndʉ̀ ɔ̀ iwú tɨ́ ndɨ̀ ndúnzì alɛ návi rìwǔ. Pbɛ́tʉ̀, ɨ alɛ náadʉ̀ nzá ’òzè ’ìwǔ mʉ̀hɛndʉ̀ ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nɨ́ kǎdʉ̀ ngʉ̌kpà kasʉtálɛ núvi tdɨ́tdɔ̌ ròwù, ndàdʉ̀ dhu nʉ́ya fɨ̌yɔ̀, ndàtɨ: ‹Nyàtɨ, yà mʉ̀hɛndʉ̀ ɔ̀ iwú tɨ́ ma múnzì alɛ nɨ̌: mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ níye wà, pbàkà ìkyì-akpá mà, ivu nà ɨ̀zǎ mànà nɨ́ ka kàzè wà. Kɔ́rɔ́ dhu-tsí àkǎ wà, nɨ́ nyìwǔ àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pbɛ́tʉ̀, wɔ̀ ka kʉ̀nɔ̀ dhu náatdú nzá kɔ̌kɔ̀ ùnzi ka kùnzì alɛ-afí mà. Abádhí adʉ̀ òwu ɨ̀ òzè dhu nyʉ́ nɔ́nzɨ. Atdí alɛ náarà pbɨ̀ ɨnga-bvʉ̀, ngǎtsi alɛ adʉ̀ àrà pbɨ̀ndà udzítá tɔ́ dhu-otù ɔ̌, ");
INSERT INTO niy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ngʉ̌kpà alɛ-tsí náadʉ̀ wɔ̀ ádrʉ̀ngbǎ kamà bhà kasʉtálɛ nʉ́lʉ, ɨ̀ ràvu rɔ̀yá nzɛ́rɛ nyʉ́, ’àdʉ̀ ɔ̀kyɛ̀nà. ");
INSERT INTO niy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nɨ́ wɔ̀ ádrʉ̀ngbǎ kamà náakó atdídɔ̌. Kǎdʉ̀ pbɨ̀ndà pbànówí nóvì ròwù kɔ̌kɔ̀ pbɨ̀ndà kasʉtálɛ nɔ̀kyɛ̀ alɛ nɔ́kyɛ̀, ndɨrɔ̀ ràdʉ̀ ɨ alɛ tɔ́ kɨgɔ̀ nʉ́bɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà ɔ̀dɔ̀dɨ̀ kasʉtálɛ nɨ̌: ‹Àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ níye wà. Pbɛ́tʉ̀, ndɨ ɔ̀nyʉ̀ nɔnyʉ tɨ́ ma múnzì alɛ nákǎ nzá ’òtsù mʉ̀hɛndʉ̀-ɨdzà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nɨ́ nyòwu otu-yàgá ɔ̀nǎ, nyǎdʉ̀ ányɨ̀ nyɨ̌ nyótùna alɛ núnzì kɔ́rɔ́, rìwǔ mʉ̀hɛndʉ̀ ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nɨ́ kɔ̌kɔ̀ kasʉtálɛ náawù ádrɔ̀drɔ̌ ngʉdhà ɔ̀, ɨ̀ rùndu kɔ́rɔ́ ányɨ̀ ɨ̀ òtù alɛ, nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ alɛ mà, ídzìnga ɔ̀nzɨ arɨ́ alɛ mànà, mʉ̀hɛndʉ̀-ɨdzà-ɔ̌nga ràlè ìndrǔ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nɨ́rɔ̀ nɨ́ ndɨ ádrʉ̀ngbǎ kamà náaròtsù mʉ̀hɛndʉ̌-dzà ɔ̀, ndàhʉ kɔ̌kɔ̀ ka kùnzì alɛ nándà. Nɨ́ kǎla atdí alɛ ɨnzá mʉ̀hɛndʉ̀ tɔ́ mbɛrʉ̀ nàfɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nɨ́ kǐvú dhu wɔ̀ alɛ-tsʉ̌ ndàtɨ: ‹Pbǎlɛ́, nyɨ nyìtsù ɨ̀ngbǎ dhu bhěyi àzú-dza, ɨ̀mbǎ nyɨ nyɨ́’ɨ̀ mʉ̀hɛndʉ̀ tɔ́ mʉ̀dzarʉ̀ nà rɔ́rɔ̀?› Pbɛ́tʉ̀, wɔ̀ alɛ rǎdǔna dhu nɨ́ɨ’ɨ̀ mbǎ atdí màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nɨ́ kamà adʉ̀ àtɨ̀nà pbɨ̀ndà kasʉtálɛ nɨ̌: ‹Nyʉ̀tsɨ wɔ̀ alɛ-pfɔ̀, kɔ̌tsʉ́ mànà, nyǎdʉ̀ kìtdù, nyǒbvù iri ɨ́nɔ̀ ɔ̀. Ányɨ̀ nɨ́ ɔdzɨ mà, alɛ-kù t’átrita mànà tɔ́ ngari.›» ");
INSERT INTO niy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ihé-yà nɨ̌: «Ùnzi ka kúnzì alɛ rɨ̌’ɨ̀ abhɔ, pbɛ́tʉ̀ òvò ka kóvò alɛ rɨ̌’ɨ̀ ngúfe.» ");
INSERT INTO niy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wɔ̀ dhu-dzidɔ̌, Pbàfàrìsáyó náawù mʉ̀hanʉrà nɔ́nzɨ̀, ’àdʉ̀ ’ɨ̀rɨ̀ ɨ̀ngbǎ dhu bhěyi ɨ̀’ɨ́ dhu ìvǔ Yěsù-tsʉ̌, ndɨ́nɨ̌ ɨ̀ omvú tɨ́ kà-afí nɨ̌ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nɨ́ abádhí adʉ̀ ngúfe fɨ̌yɔ́ ábhàlɨ̌ mà, Hɛ̀rɔdɛ̀ bhà alɛ mànà nóvì ròwù àtɨ̀nà Yěsù nɨ̌: «Màlimǒ, mǎ mʉ́nɨ wà dhu nyɨ rarɨ́ obhó dhu nʉ́nɔ. Nyɨ nyarɨ́ obhó dhu núdhě Kàgàwà òzè ìndrǔ ròkò tɨ́ dhu dɔ̌. Ndɨrɔ̀ nyɨ nyarɨ́ nzɨ̌ ìndrǔ rǎdʉ̀ ɨ̀rɛ̀nà dhu ɔdɔ̀ nɔ́nzɨ, ɨ̀nzɨ̌ nyɨ nyarɨ́ ìndrǔ bhà ádrʉ̀ngbǎnga nándà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nɨ́, ádǔ pɛ́ dhu fǎkà yà mǎ mívǔna tsʉ̀nʉ́ dhu dɔ̌. Àlɛ̌ tɔ́ Ʉyátá návi tɨ́ àvǐ àlɛ̌ rʉ̀fɔ̌ ádrɔ̀drɔ̌ kámá dɔ̌ kamà Kàyìsarà bhà pàratà?» ");
INSERT INTO niy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pbɛ́tʉ̀ Yěsù nʉ́ʉnɨ abádhí rɨ̌rɛ̀na nzɛ́rɛ dhu angyangyɨ. Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ ɔyɔyɔ ɨdàya nà alɛ́, ádhu nyɨ̌ nyɨ́ afídu númvǔ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nyɨ̀tɛ̀ pɛ́ ndɨ pàratà nʉ́fɔ̌ ka kárɨ́ nɨ̌ fʉ̀rangà-kpɔ̌ mandà.» Nɨ́ abádhí adʉ̀ atdí fʉ̀rangà-kpɔ̌ nábhʉ Yěsù-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Yà ka kɔ̀bhɔ̀lɔ̀ nyɨ̀na-wɔ̀yɔ̌, kadʉ̀ ɔvɔ̀na nándi ɨrɔ́ alɛ nɨ́ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Ádrɔ̀drɔ̌ kámá dɔ̌ kamà Kàyìsarà.» Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyùbho Kàyìsarà bhà dhu-tsí Kàyìsarà-fɔ’ɔ̀, nyǎdʉ̀ Kàgàwà bhà dhu-tsí núbho Kàgàwà-fɔ’ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wɔ̀ dhu bhěyi Yěsù àdu fɨ̌yɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ɨdhɔ náadʉ̀ abádhí nʉ́kɔ atdídɔ̌. Nɨ́ abádhí náadʉ̀ Yěsù nʉ́bhà, àdʉ̀ òwu fɨ̀yɔ́ dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ndɨ nɨ́nganɨ́ tɨ́ ngúfe Pbàsàdùkáyó níiwú Yěsù-tɨ’ɔ̀. Abádhí nɨ́ ɨ arátɨna ɨ̀nzɨ̌ ʉ̀vʉ̌vɛ alɛ rʉngbɛya ɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ abádhí níivú dhu Yěsù-tsʉ̌, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Màlimǒ, Músà náatɨ atdí alɛ rapɛ́ tsìbhálɛ námba, ndàdʉ̀ ɔ̀vɛ̀ ɨnzá ɨ̀ ɔ̀dhɨ̀ atdí ngbángba mà rɔ́rɔ̀, nɨ́ dhu ràkǎ ndɨ alɛ t’ádɔ̀nà rùndu yà pbɨ̀ndà kpatsìbhálɛ ɔ́vɛ̀ tsìbhálɛ-tsʉ̀. Ndɨ dhu bhěyi nɨ́ ndɨ abádhí rǎdʉ̀ nzónzo nɔ́dhɨ̀ wɔ̀ àvǎvɛ̀ adɔ̀nà-ɔvɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nɨ́ ndɨ dhu bhěyi tɨ́, fàrábvʉ̌ atdí alɛ nɨ́ɨ’ɨ̀ kpabhínzo nà àrʉ̀bhʉ̀. Nɨ́ sengba náambà tsìbhálɛ, ndàdʉ̀ ɔ̀vɛ̀ ɨnzá ɨ̀ ɔ́dhɨ̀ atdí ngbángba mà rɔ́rɔ̀. Kǎdʉ̀ venà nʉ́bhà lunatɨ̀nǎ adɔ̀nà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dhu adʉ̀ ndɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́ kà-dzidɔ̌ kà t’ádɔ̀nà rɔ̌, ndɨrɔ̀ ɨ̀bhʉ rɨ́ kìsě kpatsìbhíngba rɔ̌ màtɨ́, ràrà àhʉ kɔ́rɔ́ kɔ̌kɔ̀ àrʉ̀bhʉ̀ kpabhínzo rǐku dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kɔ́rɔ́ kɔ̌kɔ̀ kpabhínzo nʉ́vɛ dhu lutɨ̀nǎ, wɔ̀ ndɨ tsìbhálɛ náadʉ̀ ɔ̀vɛ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nɨ́ ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ nɨ́nganɨ́, wɔ̀rɨ́ tsìbhálɛ nɨ’ɨya àdhɨ-ve, kɔ́rɔ́ kɔ̌kɔ̀ àrʉ̀bhʉ̀ alɛ nʉ́ʉmbá ka nɨ́dhunɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ nyùwǐ ɨtsɛ nyʉ́ fʉ̀kʉ́ ɨrɛ̀ta ɔ̌, ɨnzá nyɨ̌ nyʉ̀nɨ Kàgàwà bhà Andítá rʉ̌nɔna dhu mà, ndɨrɔ̀ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ mà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Obhó tɨ́, ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ nɨ́nganɨ́, kpabhálɛ mà vèbhálɛ mànà nʉ́ʉmbáya nzɨ̌ ɨ̀. Pbɛ́tʉ̀ abádhí nóokoya Kàgàwà bhà màlàyíká náaróko ɔ̀rʉ̀-akpà ɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ndɨrɔ̀, yà ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ dhu dɔ̌, nyɨ̌ nyàpɛ̀ tɨ́ nzá Kàgàwà nʉ́ʉnɔ kpangba fʉ̌kʉ̀ dhu nɔ́zʉ̀? Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ɨma nɨ́ Àbràhamʉ̀ bhà Kàgàwà, Ìsakà bhà Kàgàwà, ndɨrɔ̀ Yàkɔbhɔ̀ bhà Kàgàwà.› Kàgàwà nɨ́ ípìrɔ̌rɔ̀ arɨ́’ɨ̀ alɛ tɔ́ Kàgàwà, ɨ̀nzɨ̌ nɨ́ ʉ̀vʉ̌vɛ alɛ tɔ́ Kàgàwà.» ");
INSERT INTO niy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ɨdhɔ nʉ́ʉkɔ ihé-yà atdídɔ̌ kà rǔdhěna dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pbàfàrìsáyó níitdègu Yěsù àdu Pbàsàdùkáyó tɔ̀ dhu nábhʉ abádhí rɨ̀nɛ̀ dhu ɨ̀rɨ, nɨ́ abádhí náadʉ̀ ’àndu ’ɔ̀tɛ̀. ");
INSERT INTO niy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nɨ́rɔ̀ nɨ́ ndɨ abádhí nzínzì ɔ̌ atdí alɛ, Músà bhà Ʉyátá tɔ́ màlimò, náazè ndòmvù Yěsù-afí. Nɨ́ kǐvú dhu Yěsù-tsʉ̌ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Màlimǒ, ádrʉ̀ngbǎ Ʉyátá ròsè kɔ́rɔ́ Músà bhà Ʉyátá dɔ̀nǎ nɨ̌ ɨ̀ngbǎ Ʉyátá?» ");
INSERT INTO niy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Dhu àkǎ nyozè pbʉ̀kʉ̀ Ádrʉ̀ngbǎlɛ Kàgàwà kɔ́rɔ́ afínʉ mànà, kɔ́rɔ́ atdyúnʉ mànà, ndɨrɔ̀ kɔ́rɔ́ pbʉ̀kʉ̀ ɨrɛ̀ta mànà. ");
INSERT INTO niy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wɔ̀rɨ́ nɨ́ ndɨ wɛmbɛrɛ̀ tɔ́ ádrʉ̀ngbǎ Ʉyátá ròsè kɔ́rɔ́ Ʉyátá dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndɨrɔ̀, yàrɨ́ nɨ́ ndɨ ɔyɔ rɨ́ kìsě Ʉyátá, yà ndɨ̀ nɔ̀fɔ̀ angyi rɨ́’ɨ̀ Ʉyátá nà: Dhu àkǎ nyozè ɔdhɨ̀nʉ yà ɨnyɨ nyʉ́ nyɨ nyózè nyɨ nyɨtɨ́rɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kɔ́rɔ́ Músà bhà Ʉyátá mà, Kàgàwà bhà pbànábí náarúdhěna kɔ́rɔ́ dhu mànà nɨ́pbɨ̀ ɨ̀ kɔ̌kɔ̀ ɔ́yɔ̌ Ʉyátá rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pbàfàrìsáyó nɨ́ɨ’ɨ̀ ùndǔ ɨ̀ ùndu ɨ̀ rɔ́. Nɨ́ Yěsù níivú dhu abádhí-tsʉ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ádhu Krɨ́stɔ̀ dɔ̌ nyɨ̌ nyárɨ́ ɨ̀rɛ̀na? Ádhɨ t’ídhùnà ndɨ?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Krɨ́stɔ̀ nɨ́ Dàwudì t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Olu ádhu, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí rɨ̌ ndʉ̀nda rɔ̀, Dàwudì náatɨ ka pbɨ̀ndà Ádrʉ̀ngbǎlɛ tɨ́ nɨ̌? Ndɨ Dàwudì atɨ: ");
INSERT INTO niy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Ádrʉ̀ngbǎlɛ Kàgàwà rǎtɨna pbàkà Ádrʉ̀ngbǎlɛ nɨ̌: ɨ́rà nyadɨ̀ idú fangà dɔ̀nǎ rɔ̀, ràrà àhʉ ma mɨ́ pbʉ̀kʉ̀ òmvǔ nábhʉ̌ nyɔbɛ̀ dɔ̀ya dhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɨ́ Dàwudì rɨ̀’ɨ̀ Ádrʉ̀ngbǎlɛ tɨ́ rɨ́ Krɨ́stɔ̀ nánzi, nɨ́ Krɨ́stɔ̀ rǎdʉ̀ ɨ̀’ɨ̀ ɨ̀ngbǎ dhu bhěyi kà t’ídhùnà tɨ́?» ");
INSERT INTO niy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nɨ́ Pbàfàrìsáyó nzínzì ɔ̌ atdí alɛ mà náadʉ̀ nzá atdí dhu mà nádu Yěsù tɔ̀. Ndɨrɔ̀ rɔ̀pɛ̀ ndɨ̀ ányɨ̀rɔ̌ rɔ̀, atdí alɛ mà náadʉ̀ nzá ndòmvù ndɔ̀ngʉ̀ dhu Yěsù-tsʉ̌ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù náavɔ̀ dhu ihé-yà mà, pbɨ̀ndà ábhàlɨ̌ mànà tɔ̀, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà nɨ́ tɔ́ kasʉ narɨ́ ’àwɛ Músà bhà Ʉyátá-tɨ̀ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nɨ́ dhu àkǎ nyɨ̌rɨ̀ abádhí-tsʉ̌ dhu, nyǎdʉ̀ abádhí àvi fʉ̌kʉ̀ kɔ́rɔ́ dhu ɔ̀nzɨ̀. Pbɛ́tʉ̀, dhu àkǎ nzá nyɔ̌nzɨ̀ nyɨ̌ abádhí náarɨ́ ’ɔ̀nzɨ dhu bhěyi. Obhó tɨ́, abádhí náarɨ́ nzɨ̌ àdʉ̀ yà ɨ̀ údhěna ìndrǔ tɔ̀ dhu nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Abádhí náarɨ́ ɨ̀ nà’ɛ ànɔ̀ nʉ́tsɨ, ’àdʉ̀ ʉ̀gbanà ìndrǔ-ʉdɔ̌, pbɛ́tʉ̀ ɨ̀nzɨ̌ ’àdʉ̀ ’òzè ’ʉ̀pbàlǎ ɨ ànɔ̀-ngbɔ̀ ɔtsʉ́ya-dɔ nɨ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Abádhí náarɨ́ kɔ́rɔ́ fɨ̀yɔ́ dhu nɔ́nzɨ ndɨ́nɨ̌ ìndrǔ náala tɨ́. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ abádhí náarɨ́ yà nyɨ̀ya-ndrìnǎ màtɨ́, ndɨrɔ̀ tsʉyatsʉ̀nǎ màtɨ́ ɨ̀ arúsǒna ɨ́sɔ̀wʉ̌-nzo nɔ́bhɔlɔ rɨ̀’ɨ̀ íhìhǔ. Ndɨrɔ̀ abádhí arádʉ̀ fɨ̀yɔ́ mbɛrʉ̀-bɨdɔ̀ rɔ̌ bhɛ̀lɛ̀bhɛ́lɛ́ nɔ́nzɨ̀ rɨ̀’ɨ̀ ádzàdzǐ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mʉ̀hɛndʉ̀ ɔ̌, abádhí arɨ́ ’òzè ’òkò ndàvǐ rɨ́ ngari ɔ̌. Ndɨrɔ̀ unduta-dzà ɔ̌, abádhí arɨ́ ’òzè ’òkò angyinǎ rɔ̀ rɨ́’ɨ̀ ɨfʉta tɔ́ tombi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pbanga-tsidɔ̌ ìndrǔ arɨ́ ’ùndǔ ɔ̀yá ngari ɔ̌, abádhí arádʉ̀ ’òzè katsɛ̀ ɨ̀ ɨfʉta nyʉ́ nà, ’àdʉ̀ ’òzè kanzì ɨ̀ ‹Màlímó› tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pbɛ́tʉ̀, nyɨ̌ nyàkǎ nzá nyǎbhʉ nyɨ̌ kambɛ nyǔnzì dɔ̌ ‹Màlímó› tɨ́. Obhó tɨ́, nyɨ̌ nyɨ́’ɨ̀ Màlimò nà atdí tɨ́, ndɨrɔ̀ nyɨ̌ nɨ́ atdí àba bhà alɛ. ");
INSERT INTO niy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ndɨrɔ̀ yà adzɨ dɔ̌, dhu àkǎ nzá nyǎnzì atdí alɛ mà àbakʉ tɨ́. Obhó tɨ́, nyɨ̌ nyɨ́’ɨ̀ Àbakʉ nà atdí tɨ́. Ndɨ Àbakʉ nɨ́ Kàgàwà, yà ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndɨrɔ̀ dhu àkǎ nzá nyǎbhʉ nyɨ̌ kambɛ nyǔnzì dɔ̌ ‹Ìndrǔ ʉ̀nda arɨ́ alɛ› tɨ́. Obhó tɨ́, nyʉ̌nda arɨ́ nɨ́ atdí alɛ kɛ̀lɛ̌. Ndɨ alɛ nɨ́ Krɨ́stɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nzínzìkʉ ɔ̌ ádrʉ̀ngbǎlɛ tɨ́ rɨ́’ɨ̀ alɛ náadɨ̀ya fʉ̀kʉ́ kasʉtálɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ndɨ̀dzɨ̌ rɨ́ ndɨ̀tɨ́rɔ̀ ɔrʉ́ alɛ, nɨ́ Kàgàwà ifoya ìfǒ tɨ́. Ndɨrɔ̀ ndìfǒ rɨ́ ndɨ̀tɨ́rɔ̀ alɛ, nɨ́ Kàgàwà ɨdzɨ́ya ɨ̀dzɨ̌ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyárɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ ka kótsù ɔ̀ná tsǎtsʉ̀ nápbǐ ìndrǔ rɔ̌. Nyɨ̌ nyarɨ́ nzɨ̌ òtsù ányɨ̀ nyɨ̌-tɨ́rɔ̀ màtɨ́, ndɨrɔ̀ nyɨ̌ nyarɨ́ nzɨ̌ àdʉ̀ ányɨ̀ ɨ̀ nòzè ’òtsù alɛ mà nábhʉ ròtsù ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyárɨ́ abvo-ayí-fɔ́ dhu nʉ́dhǎ kɔ́rɔ́, nyǎdʉ̀ àmbɛ nyɨ̌tsɔ̀ dɔ̌ ádzàdzǐ, ndɨ́nɨ̌ katɨ tɨ́ nyɨ̌ ídzì alɛ tɨ́. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ka kɔtdɨ́ya anya dʉ̀kʉ́ ròsè ngʉ̌kpà alɛ dɔ̀nǎ! ");
INSERT INTO niy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyarúbhi kɔ́rɔ́ ngari ɔ̌ yà adzɨ dɔ̌, ndɨrɔ̀ rɛ̀rʉ̀ dɔ̀nǎ màtɨ́, ndɨ́nɨ̌ nyɨ̌ nyabá tɨ́ atdí alɛ mà, nyʉ̌gɛ̀rɛ̀ ròngò fʉ̀kʉ́ ábhàlɨ̌ tɨ́. Ndɨ alɛ nyɨ̌ nyàbà rɔ̀, nyɨ̌ nyarádʉ̀ kàbhʉ ròngò ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ ogbeya alɛ tɨ́ ɔyɔ-gʉ̀na ròsè dʉ̀kʉ nǎ. ");
INSERT INTO niy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, yà ndùmùndúmú tɨ́rɔ̀ nyɨ̌ nyárɨ́ ìndrǔ nʉ́nda rɔ̀! Nyɨ̌ nyarátɨna, atdí alɛ rapɛ́ dhu ɔ̀tsɔ Kàgàwà bhà ɨdza-ɔvɔ̀ rɔ̌, nɨ́ ndɨ dhu rɔ̌nzɨna dhu ràrɨ̌’ɨ̀ mbǎ. Pbɛ́tʉ̀, ndɨ alɛ rapɛ́ dhu ɔ̀tsɔ Kàgàwà bhà ɨdzá dhu ka kɔ́bhɔ̀lɔ̀ nɨ̌ ɔrɔ̀-ɔvɔ̀ rɔ̌, nɨ́ dhu ràrǎdʉ̀ àkǎ ndɨ alɛ rɔ̀nzɨ̀ wɔ̀ ndɨ̀ ndɔ̀tsɔ̀ dhu okúna dɔ̀ rɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyɨ̌ nɨ́ ɨ̀mbǎ dɔ̀ya nà alɛ, ndɨrɔ̀ ndùmùdúmú! Ádhu ndɨ ádrʉ̀ngbǎ dhu nyʉ́ ròsè? Tɨ́ ɔrɔ̀, ndɨrɔ̀ tɨ́ Kàgàwà bhà ɨdza, wɔ̀ ndɨ ɔrɔ̀ nʉ́gɛ̀rɛ̀ ròngò Kàgàwà-nyɨ̀kpɔ́ ɔ̌ ɨ́lǎ dhu tɨ́? ");
INSERT INTO niy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nyɨ̌ nyárádʉ̀ àtɨ̀nà átɔ̀, atdí alɛ rapɛ́ dhu ɔ̀tsɔ màzàbahʉ̀-ɔvɔ̀ rɔ̌, nɨ́ ndɨ dhu rɔ̌nzɨna dhu ràrɨ̌’ɨ̀ mbǎ. Pbɛ́tʉ̀, ndɨ alɛ rapɛ́ dhu ɔ̀tsɔ ndɨ màzàbahʉ̀ dɔ̌ rɨ́’ɨ̀ pɛrɛ̀ tɨ́ ka kàbhʉ Kàgàwà tɔ̀ dhu-ɔvɔ̀ rɔ̌, nɨ́ dhu ràrǎdʉ̀ àkǎ ndɨ alɛ rɔ̀nzɨ̀ wɔ̀ ndɨ̀ ndɔ̀tsɔ̀ dhu okúna dɔ̀ rɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nyɨ̌ nɨ́ ndùmùndúmú! Ádhu ndɨ ádrʉ̀ngbǎ dhu nyʉ́ ròsè? Tɨ́ yà Kàgàwà tɔ̀ ka kàbhʉ pɛrɛ̀? Ndɨrɔ̀, tɨ́ màzàbahʉ̀, wɔ̀ ndɨ pɛrɛ̀ nʉ̀gɛ̀rɛ̀ ròngò Kàgàwà-nyɨ̀kpɔ́ ɔ̌ ɨ̀lǎ dhu tɨ́? ");
INSERT INTO niy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Atdí alɛ náapɛ́ dhu ɔ̀tsɔ màzàbahʉ̀-ɔvɔ̀ rɔ̌, nɨ́ kɔ̀tsɔ̀ wà dhu ndɨ màzàbahʉ̀-ɔvɔ̀ rɔ̌, kɔ́rɔ́ dɔ̀ná rɨ́’ɨ̀ dhu mànà. ");
INSERT INTO niy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Atdí alɛ náapɛ́ dhu ɔ̀tsɔ Kàgàwà bhà ɨdza-ɔvɔ̀ rɔ̌, nɨ́ kɔ̀tsɔ̀ wà dhu ndɨ Kàgàwà bhà ɨdza-ɔvɔ̀ rɔ̌, ndɨrɔ̀ ányɨ̀-dzá arádɨ Kàgàwà-ɔvɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Atdí alɛ náapɛ́ dhu ɔ̀tsɔ ɔ̀rʉ̀-akpà-ɔvɔ̀ rɔ̌, nɨ́ kɔ̀tsɔ̀ wà dhu Kàgàwà bhà tombi-ɔvɔ̀ rɔ̌, ndɨrɔ̀ kɔ̀tsɔ̀ wà dhu ndɨ tombi dɔ̌ àdɨ Kàgàwà-ɔvɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyárɨ́ ɔ̀nyʉ̀-dzi nábhʉ̌ arɨ́ rɔ̀ngʉ̀ mběyi ɨrɨ́-bɨ̌-tɨdɔ̀ mà, pbabɨ̌ ɔ̀bhɔlɔ ka karɨ́ nɨ̌ ɨrɨ́-bɨ̌-tɨdɔ̀ mà, ɔ̀nyʉ̀ àbhʉ̌ arɨ́ ròvù mběyi ɨrɨ́-bɨ̌-tɨdɔ̀ mànà tɔ́ atdínga ɨdrɛ̀ dɔ̌ núbhǒ pɛrɛ̀ tɨ́ Kàgàwà tɔ̀. Pbɛ́tʉ̀, nyɨ̌ nyarádʉ̀ Músà bhà Ʉyátá nzínzì ɔ̌ ádrɔ̀drɔ̌ Ʉyátá nyʉ́ nʉ́bhà ɨ̀nzɨ̌ nyɨ̌fʉ. Ɨ Ʉyátá nɨ́: Obhó dhu nɔ́nzɨ ka kɨ́ dhu mà, ɨzʉ àbà ka kɨ́ ìndrǔ dɔ̌, kadʉ̀ dhu ʉ̀bà fɨ̌ndà dhu mà, ndɨrɔ̀ dhu ka kɔ̀tsɔ̀ okúna dɔ̀ rɔ̀ dhu ɔ̀nzɨ ka kɨ́ dhu mànà. Kɔ̌kɔ̀ nɨ́ ɨ àkǎkǎ nyɔ̌nzɨ̀ dhu, ɨnzá nyɨ̌ nyʉ̀bhà ngʉ̌kpà Ʉyátá nɨ́fʉ̌ nyɨ̌ nyɨ́ dhu rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyɨ̌, ndùmùndúmú tɨ́ rɔ̀ nyɨ̌ nyárɨ́ ìndrǔ nʉ́nda rɔ̀! Nyɨ̌ nyárɨ́ ɔ̀mvʉ̀na nyɨ̌ nyɨ́ dhu nʉ́rɔ̌ ʉ̀rɔ̌ tɨ́, akyɛ nyʉngʉnyʉngʉ mà nʉ́ʉdàna ɔ̀nà nɨ̌, pbɛ́tʉ̀ nyɨ̌ nyarádʉ̀ ngàmɨyà nyʉ́ nɔ́tɔ̀ ʉ̀kʉ̀! ");
INSERT INTO niy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyárɨ́ kɔ́pà mà sǎnɨ̀ mànà-ngbɔ̀ nú’ǒ, pbɛ́tʉ̀ ɨ kɔ́pà mà, ɨ sǎnɨ̀ mànà ɔ̀nga ràdʉ̀ ɨ̀’ɨ̀ ùlè tɨ́ ɨ̀ ùlè ogbo ɔ̌ nyɨ̌ nyùwě dhu mà, ìndrǔ-fɔ́ rɔ̀ nyɨ̌ nyʉ̀dhǎ ɔbɨ nɨ̌ dhu mànà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɨnyɨ, ndùmùndúmú tɔ́ Mʉ̀fàrìsayǒ, ú’ǒ pɛ́ kɔ́pà ɔ̀ nga angyi rɨ̀lǎ, ndɨrɔ̀ nɨ́ ndɨ kà-ngbɔ̀ rǎdʉ̀ ɨ̀lǎ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyʉ́lɨ nyɨ̌ ùtrǐ ka kùtri rɔ̀wʉ̀ adzɨ-dɔ bhěyi. Ɨ adzɨ-dɔ rǎdʉ̀ ʉ̀ya atdídɔ̌ iri nǎ rɔ̀, pbɛ́tʉ̀ ɔ̀yà rɔ̀ ’àdʉ̀ ɨ̀’ɨ̀ ùle tɨ́ ɨ̀ ùle ʉ̀vʉ̌vɛ alɛ-kpa mà, kɔ́rɔ́ ʉ̀mʉ̌mɔ dhu-tɨdɔ̀ mànà nɨ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nyɨ̌ nyʉ́ mà átɔ̀, nyɨ̌ nyarólo ídzì alɛ bhěyi nyǎndà rɨ́ alɛ-nyɨ̀kpɔ́ ɔ̌. Pbɛ́tʉ̀ afíkʉ ɔ̀nǎ rɔ̀ pbánɨ́ ùlè tɨ́ nyɨ̌ nyùlè ɔyɔyɔ alɛ-ɨdà mà, nzɛ́rɛnga mànà nɨ̌ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànǎ, nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ dhu-okú dɔ̀ rɔ̀! Nyɨ̌ nyárɨ́ ibhu nógye Kàgàwà bhà pbànábí ka kʉtdʉ́ tɨ́ ɔ̀yà, nyǎdʉ̀ obhónángatálɛ-adzɨ̀-dɔ tɔrɔ̀ nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndɨrɔ̀ nyɨ̌ nyarádʉ̀ àtɨ̀nà: ‹Mǎ mɨ’ɨ̀na gukyè yà abhúka nɨ́ɨ’ɨ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, nɨ́ mǎ mɨrɨna nzɨ̌ mǎ abádhí mànà mʉ̌fʉ̀ Kàgàwà bhà pbànábí-azù.› ");
INSERT INTO niy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wɔ̀ dhu bhěyi nɨ́ ndɨ, nyɨ̌ nyà’ù wà dhu nyɨ̌-tɨ́rɔ̀, nyɨ̌ ràrɨ̌ yà Kàgàwà bhà pbànábí nakyɛ̀ alɛ tɔ́ pbàdzʉkʉrʉ. ");
INSERT INTO niy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nɨ́rɔ̀, nyɔ̀nzɨ ɨ abhúkʉ náapɛ̀ kasʉ, nyǒwù ʉ̀tsànà! ");
INSERT INTO niy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyɨ̌ nɨ́ osu! Atdídɔ̌ arɔ́rʉ̀ ámvɔ̀! Nyɨ̌ nyʉgʉ̀ya ɨ̀ngbǎ dhu bhěyi anya ɨ̀tdɨ̀ ka kɨ́ dʉ̀kʉ́ kawà nyɨ̌ yà ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu ɔ̌ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mɨ́ Kàgàwà bhà pbànábí mà, dhu-ɔ̌nga t’óvòta nʉ́nɨ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà núvǐ ròwù bvʉ̀kʉ̀. Nyɨ̌ nyɔkyɛya atdídhená alɛ abádhí nzínzì ɔ̌, nyǎdʉ̀ ngʉ̌kpà nʉ́tɔ mʉ̀sàlabhà dɔ̌. Nyɨ̌ nyadʉ̀ya ngʉ̌kpà nɔ́vɨ̀ asé nɨ̌ fʉ̀kʉ́ unduta-dzà ɔ̌ rɔ̀, nyǎdʉ̀ àvu rɔ̀yá kɔ́rɔ́ kɨgɔ̀ ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndɨ dhu bhěyi nɨ́ ndɨ, ka kɨtdɨ̀ya yà ɨ̀mbǎ afátá na ndɨ̀ nʉfʉ azu-ànyǎ kɔ́rɔ́ dʉ̀kʉ́, rɔ̀pɛ̀ ndɨ̀ Àbělì, obhónángatálɛ-azù rɔ̌ rɔ̀, ràrà àhʉ Zàkàrɨyà, Bèrèkiyà t’ídhùnà-azù ɔ̀. Ndɨ Zàkàrɨyà nyɨ̌ nyahò màzàbahʉ̀ mà yà ‹atdídɔ̌ ɨ́lǎ ngari› tɨ́ kátɨna kàluga mànà nzínzì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Kàgàwà nɨ́ɨtdɨ̀ya kɔ́rɔ́ kɔ̀rɨ́ alɛ-azù-ànyǎ kǎkà indo arɨ́’ɨ̀ alɛ dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Wɔ̀ dhu-dzidɔ̌, Yěsù apɛ̀ ɔtɛ ndàtɨ: «Yèrùsàlɛmǎ, Yèrùsàlɛmǎ, Kàgàwà bhà pbànábí nɔ́kyɛ nyɨ nyarɨ́, nyǎdʉ̀ Kàgàwà òvì tɨnʉ ɔ̀ alɛ núbvu odu nɨ̌ rɔ̀, ma mómvù mandu ʉ̀nʉ́ aróko alɛ-tsʉ̀ ìfe-gʉ̀na, àdhàdhɨ̀ à’ʉ̌-yà-ba náarɨ́ pbɨ̀ndà inzo nándǔ pékéléna-tsì dhu bhěyi. Pbɛ́tʉ̀ nyɨ nyádʉ̀ nzá ndɨ dhu nózè! ");
INSERT INTO niy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nɨ́rɔ̀, kànɨ̌ Kàgàwà rɨ̌ pɛ́ yà ʉ̀nʉ́ arɨ́’ɨ̀ pbɨ̀ndà ɨdza nʉ́bha ròngò rʉ̀ngʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma mɨ́ dhu ʉ̀nɔ fʉ̌kʉ̀: Rɔ̀pɛ̀ ndɨ̀ kombí nyɨ̌ nyɨ́ nzɨ̌ malǎ tdɨ́tdɔ̌, ràrà àhʉ nyɨ̌ nyowuya àtɨ̀nà ɨma nɨ̌: ‹Kàgàwà àkǎ ndàso Ádrʉ̀ngbǎlɛ-ɔvɔ̀ rɔ̌ rɨ́rà alɛ› dhu ɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yěsù àhʉ Kàgàwà bhà ɨdza rɔ̀ ndàmbɛ àrà dɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, kàbhà ábhàlɨ̌ náandrì kà-tɨ’ɔ̀, ’àdʉ̀ Kàgàwà bhà ɨdza ka kɔ́sɨ̀ tɨ́ dhu nɨ́tɛ̀ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyàla tɨ́ wà kɔ́rɔ́ kɔ̌kɔ̀ dhu? Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ngǎtsi nɨ́nganɨ́ atdí odu mà nɔ́ɔdɨ́ya nzɨ̌ ngǎtsi odu dɔ̌ yà ɨrɔ́ ka kɔ̀rʉ̀ odu nzínzì ɔ̌, ɨnzá ka kùgolo ndɨ̀ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yěsù àdɨ Mìzèyìtunì tɨ́ kátɨna itsu náarɨ́’ɨ̀ dɔ̀ná pbìrì dɔ̌ rɔ́rɔ̀, kàbhà ábhàlɨ̌ náawù ɔ̀yá kà-tɨ’ɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Ʉ́nɔ pɛ́ wɔ̀ dhu nɔ́ɔnzɨya ndɨ̀ ɔ̀ná kàsʉmɨ̀ fǎkà. Ndɨrɔ̀, ádhu ndɨ nyɨ nyíngo ɔ̀ná, ndɨrɔ̀ kɔ́rɔ́ yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ ɔ̀ná kàsʉmɨ̀ nɨtɛ̀ya fǎkà?» ");
INSERT INTO niy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyàndà nga mběyi, ndɨrɔ̀ àpɛ́ nyǎbhʉ̀ atdí alɛ mà rʉ̀trǎ nyɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ábhɔ̌ alɛ nóowuya ìwu rɔ̌ ɔvɔ̀du rɔ̌, ’àdʉ̀ àtɨ̀nà: ‹Ɨma nɨ́ Krɨ́stɔ̀.› Ndɨrɔ̀ abádhí nʉ́ʉtráya ábhɔ̌ alɛ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nyɨ̌ nyɨrɨya ɨla-ɔ̀yɨ̌ mà, ’ɔ̀nzɨ rɨ́ ila-gìrìtǐ mànà. Pbɛ́tʉ̀, àpɛ́ nyǎbhʉ̀ya ɔdɔ rɨ̀sɨ̌ ʉ̀kʉ̀. Obhó tɨ́, dhu àkǎ wà kɔ́rɔ́ kɔ̌kɔ̀ dhu rɔ̀nzɨ̀ ɨ̀. Pbɛ́tʉ̀, wɔ̀rɨ́ nɨ’ɨya nzɨ̌ yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ kɔ́rɔ́ dhu. ");
INSERT INTO niy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Atdídhená alɛ-tɨdɔ̀ nóowuya ’ùgyè rɔ̌ ngʉ̌kpà alɛ-tɨdɔ̀ mànà. Ndɨrɔ̀ atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ mà, nóowuya ’ùgyè rɔ̌ ngǎtsi ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ mànà. Àgǎyì mà mùtìtì mànà nɨ́ɨ’ɨya dhèdhèrɔ̀ ngari ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kɔ́rɔ́ ndɨ àpbɛ̀ nɨ́ɨ’ɨya àdhàdhɨ̀ yà ari ɔ̀pɛ̀ ndàkà ndɨ̀ ɔ̀ná tsìbhálɛ náarábàna àpbɛ̀ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kɔ̌kɔ̀ dhu rɨ̌ ’ɔ̀nzɨ ɔ̀ná kàsʉmɨ̀ ɔ̌, ìndrǔ nóowuya nyǐpfo rɔ̌ ndɨ́nɨ̌ ka kavù tɨ́ rʉ̀kʉ́, kadʉ̀ nyɔ̌kyɛ̀. Kɔ́rɔ́ alɛ yà ɨnzá Kàgàwà nʉ́nɨ nɔ́ɔndrɔ́ya nyɨ̌ okúdu dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, ábhɔ̌ alɛ nyʉ́ nʉ́ʉbhàya fɨ̀yɔ́ a’uta. Abádhí nɔ́ɔndrɔ́ya ɨ̀ nzínzìya ɔ̌. Ndɨrɔ̀ nzínzìya ɔ̌, abádhí nóowuya ɨ̀ nípfo rɔ̌, ’ùbho ɨ̀ òmvǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tɨ̀tɔ̀ tɔ́ ábhɔ̌ pbànábí nʉ́ʉnyàya ɨ̀, ’àdʉ̀ ábhɔ̌ alɛ nyʉ́ nʉ́tra. ");
INSERT INTO niy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nzɛ́rɛnga nɔ́ɔtrɔya yà adzɨ dɔ̌, ràdʉ̀ ábhɔ̌ alɛ tɔ́ àzè nábhʉ ràzo. ");
INSERT INTO niy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pbɛ́tʉ̀, kɔ̌kɔ̀ dhu-dzi òndù rɨ́ kɔ́rɔ́, ràrà àhʉ kɔ́rɔ́ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ dhu ɔ̀ alɛ nɨ́ ndɨ ɔ̀gʉ̀ ɔgʉ́ya. ");
INSERT INTO niy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka kʉnɔya pɛ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀ angyi kɔ́rɔ́ yà adzɨ ɔ̌, ndɨ́nɨ̌ kɔ́rɔ́ alɛ adʉ̀ tɨ́ ɨ̀rɨ̀nà. Ndɨrɔ̀ nɨ́ ndɨ yà adzɨ ɔ̌ dhu-tsʉ̀ náadʉ̀ya ndɔ̀dɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̌ nyalaya yà Kàgàwà bhà nabì Dànyɛlɛ̀ nʉ́ʉnɔ ‹ɔdɔ̀na rɔ̌’ɔ atdídɔ̌ ɔ̀ndrɔ̀ ka kɔ́ndrɔ̀ atdídɔ̌ alɛ› tɨ́ ka kátɨna alɛ, Kàgàwà bhà ɨdzá ɨ̀lɨ̌lǎ ngari ɔ̀ ìdè rɔ́. Yàrɨ́ dhu ɔ̀zʉ̀ rɨ́ alɛ nákǎ ndàlʉ̌ ka mběyi dɔ̀na ɔ̀! ");
INSERT INTO niy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nɨ́ ndɨ nɨ́nganɨ́, Yùdɛyà tɔ́ pbìrì ɔ̌ ɨ̀ nòtù alɛ náakáya òtsè pbìrì-akpá dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pbɨ̀ ɨdza dɔ̀ ka kɔ́bhɔ̀lɔ̀ okota tɔ̀ ngari ɔ̀ ndɨ̀ nòtù alɛ, náakáya nzɨ̌ ndìfò, ndɨ̀rà pbɨ̀ ɨdzá dhu nʉ́mbà ndɔ̀kʉ̀ nà. ");
INSERT INTO niy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndɨrɔ̀, ɨnga-bvʉ̀ ndɨ̀ nòtù alɛ náakáya nzɨ̌ ndòngò ɨbha, ndàrà rɔ̀ná ɔrʉ́ mʉ̀dzarʉ̀ nídyì. ");
INSERT INTO niy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndɨ nɨ́nganɨ́, ɔ̀ya nà rɨ́’ɨ̀ vèbhálɛ mà, ɨba nóndo rɨ́ nzónzo rɨ̌’ɨ̀ fɔyá vèbhálɛ mànà nɨ́ɨ’ɨya ádrʉ̀ngbǎ àpbɛ̀ ɔ̌! ");
INSERT INTO niy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nyɨ̀tsɔ̀ nyɨ̌ Kàgàwà rɔ̌, ɨ̀nzɨ̌ nyɨ̌ nyángɨlɨ dhu nɨ́ɨ’ɨya tɨ́ yà igye àmɔ̌ ɔ̀ná ádrʉ̀ngbǎ gìrì nà kàsʉmɨ̀ mà, ndɨrɔ̀ sàbatʉ̀-ɨdhɔ̀ mànà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ndɨ nɨ́nganɨ́, ìndrǔ náabáya àpbɛ̀ abhɔ nyʉ́, ròsè kɔ́rɔ́ yà ɨ̀ abà yà Kàgàwà náanzɨ̀na yà adzɨ rɔ̀ rɨ̀rà àhʉ indo àpbɛ̀ dɔ̀nǎ. Ndɨrɔ̀ ndɨ àpbɛ̀-tɨdɔ̀ nɨ́ɨ’ɨya mbǎ tdɨ́tdɔ̌ akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ɨ̀nzɨ̌ Kàgàwà núungòna gukyè wɔ̀rɨ́ ɨdhɔ-ɔ̌nga, nɨ́ atdí alɛ mà náagʉ̀na nzɨ̌. Pbɛ́tʉ̀ kǔngò ndɨ ɨdhɔ-ɔ̌nga ròngò ídǒ yà fɨ̌ndà oko tɨ́ ndɨ̀ ndavò alɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Atdí alɛ mà náatɨya gukyè nyɨ̌ nɨ̌: ‹Nyàndà! Kànɨ̌ Krɨ́stɔ̀ rɨ̌’ɨ̀ ɨrɔ́!› ndɨrɔ̀ ndàtɨ: ‹Ndǎnɨ̌ kà rɨ̌’ɨ̀ ndɔrɔ́!›, nɨ́ àpɛ́ nyǎ’uya ka. ");
INSERT INTO niy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tɨ̀tɔ̀ tɔ́ Krɨ́stɔ̀ mà, tɨ̀tɔ̀ tɔ́ pbànábí mànà nʉ́ʉnyàya ɨ̀, ’àmbɛ ádrɔ̀drɔ̌ wɨwɨ̀ mà, ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mànà dhu ɔ̀nzɨ̀ dɔ̌, ndɨ́nɨ̌ ɨ̀ ʉtrá tɨ́ fɨ̌ndà Kàgàwà avò alɛ mà, àkǎkǎ fɨ̌yɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kɔ̀nɨ̌, ma mɔ̀vɔ̀ wà ndɨ dhu angyangyɨ fʉ̌kʉ̀! ");
INSERT INTO niy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ìndrǔ owuya gukyè àtɨ̀nà rɔ̌ nyɨ̌ nɨ̌: ‹Nyàndà, ndǎnɨ̌ kà rɨ̌’ɨ̀ rʉ̀ngʉ̀ ɔ̀,› nɨ́ àpɛ́ nyǒwuya òwu rɔ̌ ányɨ̀. Ndɨrɔ̀, ìndrǔ owuya gukyè àtɨ̀nà rɔ̌: ‹Kànɨ̌ kà rɨ̌’ɨ̀ kàluga ɔ̌,› nɨ́ àpɛ́ nyǎ’uya ɨ alɛ rʉ̌nɔna dhu. ");
INSERT INTO niy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Obhó tɨ́, Ìndrǔ t’ídhùnà rɨ̌rà dhu nɨ́ɨlɨya ndɨ̀ àdhàdhɨ̀ ɔvɔ náarámbɨlɨ ɔ̀rʉ̀-akpà rɔ̌, ndɨ̀tɔ̀ ndɨ̀ adyifɔ̀ náarɨ́ ndɨ̀tɔ ɨnǎ rɔ̀, ndʉ̀dà adyifɔ̀ náarótsù ɨnǎ rɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Abvo rɨ̌’ɨ̀ rɔ́nga nɨ́ ndɨ pbàsɛ̀gɛ̀ núunduya ɨ̀ ɔ̀yá.» ");
INSERT INTO niy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ábhàlɨ̌ nɨ̌: «Wɔ̀rɨ́ ádrʉ̀ngbǎ àpbɛ̀ dzidɔ̌ tɨ́ adyifɔ̀ nʉ́ʉtɨ̀ya, àbǐ ràdʉ̀ ɨnga t’áwʉ̀ta nʉ́bhà. Alalɨ náawáya ɨ̀ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ rɔ̀, ndɨrɔ̀ ádrɔ̀drɔ̌ ɔbɨ nà arɨ́’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀ dhu-tsí níivìya. ");
INSERT INTO niy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nɨ́rɔ̀ nɨ́ ndɨ ka kalaya Ìndrǔ t’ídhùnà rǐngo dhu ɨ̀tɛ̀ rɨ́ dhu ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌. Nɨ́ yà adzɨ ɔ̌ kɔ́rɔ́ alɛ-tɨdɔ̀ náambɛ̀ya ’ʉ̀hʉ dɔ̌ atdídɔ̌. Abádhí náalaya Ìndrǔ t’ídhùnà, ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɨ́rà ádrʉ̀ngbǎ àpbù dɔ̌, ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà, ndɨrɔ̀ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ádrʉ̀ngbǎ wàndà nɔ́ɔngɔ́ya, Ìndrǔ t’ídhùnà, ràdʉ̀ pbɨ̀ndà màlàyíká núvi ɨ̀fɔ yà adzɨ-pbɨdɔ̀ ɔ̀nǎ, ndɨ́nɨ̌ fɨ̌ndà ndɨ̀ ndavò alɛ-tsʉ̀ nundu tɨ́, rɔ̀pɛ̀ ndɨ̀ yà adzɨ náapɛ̀ ndɨ̀ ɨ rɔ̀, ràrà àhʉ kà-tsʉ̀ náarà ndɔ̀dɨ̀ ɨ.» ");
INSERT INTO niy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̀rɛ̀ pɛ́ mùtinì-kpa dɔ̌ rɔ́tɛ mbólí rʉ̌nɔna dhu: yà kà-bɨ̌ nɨ́pbànà ndɨ̀ tsànda ɔ̌ rɔ̀, kɔ̌pbɨ́ náapɛ́ ɨ̀’ǎ, bɨ̌na ràdʉ̀ ndɔ̀pɛ̀ ndàtà, nɨ́ nyʉ̀nɨ dhu lábhú tɔ́ kàsʉmɨ̀ rɨ̀rà wà. ");
INSERT INTO niy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ nyalaya gukyè kɔ̌kɔ̀rɨ́ dhu rɨ̌ ’ɔ̀nzɨ dhu, nɨ́ nyɨ̌ nyʉnɨya dhu Ìndrǔ t’ídhùnà rǐngo ɔ̀ná kàsʉmɨ̀ ràkǎ wà, ndɨrɔ̀ kà ràrɨ̌’ɨ̀ tsǎtsʉ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, kǎkà kòmbí rɨ́’ɨ̀ alɛ rɨ̌ nzɨ̌ ʉ̀vɛ kɔ́rɔ́ ɨnzá kɔ̌kɔ̀ dhu nɔ́nzɨ̀ ɨ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ɔ̀rʉ̀-akpà mà, yà adzɨ mànà nʉ́ʉdàya ʉ̀dà, pbɛ́tʉ̀ pbàkà ɔtɛ nʉ́ʉdàya nzɨ̌ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ábhàlɨ̌ nɨ̌: «Atdí alɛ mà nʉ́nɨ nzá ɨ dhu nɔ́ɔnzɨya ɨ̀ ɔ̀yá ɨdhɔ mà ndɨ kàsʉmɨ̀ mànà, ɨ̀mbǎ rɨ́’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ màlàyíká màtɨ́, ndɨrɔ̀ ɨ̀mbǎ rɨ’ɨ̀ Kàgàwà t’ídhùnà màtɨ́. Pbɛ́tʉ̀ ka nʉ́nɨ nɨ́ Àba Kàgàwà kɛ̀lɛ̌ atdírɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Obhó tɨ́, yà Nʉwà bhà atɔ ɔ̌ ɨ̀ nanzɨ̀ dhu nɔ́ɔnzɨya ɨ̀ ndɨ dhu bhěyi tɨ́ yà Ìndrǔ t’ídhùnà rǐngo nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Obhó tɨ́, angyinǎ rɔ̀, tdʉ̌ ɨdha núutú ràmbìlǐ kɔ́rɔ́ yà adzɨ rɔ̀, ìndrǔ ongónà ’ɔ̀nyʉ̀, ’àdʉ̀ ’ɔ̀mvʉ̀. Abádhí ongónà ’ʉ̀mba, ’àdʉ̀ fɨ̀yɔ́ nzónzo nábhʉ rʉ̀mbǎ ɨ̀, ràrà àhʉ Nʉwà rǒtsù sàfinà ɔ̀ ɔ̀ná ɨdhɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ìndrǔ nɨ́ɨlɨ nzá afíya atdí dhu dɔ̌ màtɨ́, ràrà àhʉ ɨdha rǔtǔ ràmbìlǐ yà adzɨ, ràdʉ̀ ìndrǔ-tsè nɔ́tdɨ̀ kɔ́rɔ́ dhu ɔ̀. Nɨ́ ndɨ dhu nɔ́ɔnzɨya ndɨ̀ ndɨ dhu bhěyi tɨ́ Ìndrǔ t’ídhùnà rǐngo nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ndɨ nɨ́nganɨ́, ɔ́yɔ̌ rɔ̀ ɨ̀ nòtù ɨnga-bvʉ̌ alɛ nzínzì ɔ̌ rɔ̀, ka kowuya atdí alɛ nódyì rɔ̌, kadʉ̀ ngǎtsi alɛ nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ndɨrɔ̀, ɔ́yɔ̌ rɔ̀ ɨ̀ nòtù dhu ò’ù ɨ̀’ɨ́ odu dɔ̌ rɔ́ vèbhálɛ nzínzì ɔ̌ rɔ̀, ka kowuya atdí tsìbhálɛ nódyì rɔ̌, kadʉ̀ ngǎtsi nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nɨ́rɔ̀, nyàndà nga mběyi, ɨnzá nyɨ̌ nyʉ̀nɨ fʉ̀kʉ́ Ádrʉ̀ngbǎlɛ nɨ́ɨraya ɔ̀ná ɨdhɔ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ndɨrɔ̀, nyàlʉ̌ yà ma mʉ́nɔna dhu mběyi dʉ̀kʉ ɔ̀: ɨdza-àbadhi náapɛ́ àdʉ̀ ogbotálɛ rɨ̌rà pbɨ̀ndà kúbhingá ɔ̀ná kàsʉmɨ̀ nʉ́nɨ angyangyɨ, nɨ́ kà rǎdʉ̀ àdɨ ípìrɔ̌ rɔ̀, ɨ̀nzɨ̌ ndàdʉ̀ pbɨ̀ndà ɨdza-tsʉ̀ nábhʉ ogbo rʉ̀kɔ̀, ndàdʉ̀ ɔ̀ná dhu ʉ̀mbà. ");
INSERT INTO niy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, nyɨ̌ nyʉ́ mà átɔ̀, nyɨ̌ nyàkǎ nyǒkò ípìrɔ̌ rɔ̀. Obhó tɨ́, Ìndrǔ t’ídhùnà nɨ́ɨraya yà ɨnzá nyɨ̌ nyɨ̀rɛ̀ kà rǎdʉ̀ ɨ̀rà ɔ̀ná dhu tɨ́ kàsʉmɨ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wɔ̀ dhu-dzidɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ádhɨ pbà kasʉtálɛ yà ndɨ̀ nɨ́fʉ, ndɨrɔ̀ nyɨ̀kpɔ́na ótdyù, yà pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɨ́ɨlɨ kasʉtálɛ dɔ̌ ádrʉ̀ngbǎlɛ tɨ́, ròngò ɔ̀nyʉ̀ núbho kasʉtálɛ tɔ̀ àkǎkǎ kàsʉmɨ̀ ɔ̌? ");
INSERT INTO niy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hirò nɔnzɨya nɨ́ wɔ̀ ndɨ kasʉtálɛ, yà ndàdǔ ndɨ̀ ndɨ́ rɔ̀ pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ rǒtùna fɨ̌ndà ka kavì kasʉ nɔ́nzɨ arɨ́ rɔ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɨ́ɨlɨya ka ádrʉ̀ngbǎlɛ tɨ́, ròngò kɔ́rɔ́ pbɨ̀ndà dhu-tsí nɔ́dɔ̀! ");
INSERT INTO niy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pbɛ́tʉ̀, ndɨ kasʉtálɛ nɨ́ɨ’ɨya gukyè nzɛ́rɛ alɛ tɨ́, ndàdʉ̀ àtɨ̀nà afína ɔ̀: ‹Pbàkà kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɨ́ nzɨ̌ ndɨ̀ nadùya tsàkàtsàkà,› ");
INSERT INTO niy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀vɨ̀ ɨ̀ arɨ́ kasʉ ɔ̀nzɨ mànà atdíkpá ɔdhɨ́na, ’àdʉ̀ òwu dhu ɔ̀nyʉ̀ rɔ̌, ’àdʉ̀ dhu ɔ̀mvʉ̀ atdíkpá òri aróri alɛ mànà, ");
INSERT INTO niy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nɨ́ kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ rɨ̌ ndàdǔ ɨnzá kɨ̀rɛ̀nà ɨdhɔ ɔ̌, ndɨrɔ̀ ɨnzá kʉ̀nɨ kàsʉmɨ̀ ɔ̌ nɨ́nganɨ́, ");
INSERT INTO niy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kǒdíya ka kasʉ ɔ̌ rɔ̀, ndàdʉ̀ ànyǎna nɔ́tdɨ̀ àdhàdhɨ̀ ɔyɔyɔ ɨdàya nà alɛ-ànyǎ nɨ́tdɨ̀ ka karɨ́ dhu bhěyi. Ányɨ̀ nɨ’ɨya ɔdzɨ mà, alɛ-kù t’átrita mànà.» ");
INSERT INTO niy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́ɨlɨya ndɨ̀ yà dhu bhěyi: Ɨdrɛ̀ ɨnzá àpɛ̀ kpabhálɛ nʉ́nɨ̌ vèbhínzo núugu fɨ̌yɔ́ tarà ndɨ́nɨ̌ ɨ̀ owu tɨ́ amba-akpà-tsí nákɔ. ");
INSERT INTO niy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nɨ́ imbò abádhí nzínzì ɔ̌ nɨ’ɨ̀ pbàdhɔ́má, ndɨrɔ̀ imbò nadʉ̀ ɨ̀’ɨ̀ nyɨ̀kpɔ́ya ótdyù. ");
INSERT INTO niy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pbàdhɔ́má tɔ́ imbò tsí núugu fɨ̌yɔ́ tarà, ɨ̀nzɨ̌ ’àdʉ̀ olù dzʉ̀nàya nɔnzɨna tarà ɔ̀ ɨdha nídyì. ");
INSERT INTO niy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pbɛ́tʉ̀, yà nyɨ̀kpɔ́ya ótdyù tsí, náadʉ̀ fɨ̌yɔ́ tarà núgù, ’àdʉ̀ olù dzʉ̀nàya nɔnzɨna tarà ɔ̀ ɨdha nídyì ngǎtsi wɨ̀tʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nɨ́ ɨ̀nzɨ̌ amba-akpà-tsí rɨ̌rà tsàkàtsàkà rɔ̀, kɔ̌kɔ̀ ɨdrɛ̀ vèbhínzo-nyɨ̀kpɔ́ náapɛ̀ ’ɔ̀rɨ̀, ɨdhɔ ràdʉ̀ ’òdyì. ");
INSERT INTO niy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nɨ́rɔ̀ nɨ́ ndɨ ìkǔ náarà àta iku-alìkpa ɔ̌: ‹Kànɨ̌ amba-akpà-tsí nɨ́rà wà! Nɨ́ nyùvò nyǒwù kàkɔ!› ");
INSERT INTO niy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nɨ́ kɔ̌kɔ̀ ɨdrɛ̀ vèbhínzo nɨ́ɨvà ɨ̀ ɨdhɔ ɔ̀ rɔ̀, ’àdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀bhɔ̀lɔ̀ fɨ̀yɔ́ tarà. ");
INSERT INTO niy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɨ́ pbàdhɔ́má tɔ́ vèbhínzo náatɨ yà nyɨ̀kpɔ́ya ótdyù tsí nɨ̌: ‹Kànɨ̌ fàká tarà rǎvɛ, nɨ́ nyìbho fʉ̀kʉ́ tarà ɔ̀ ɨdha akɛ fǎkà.› ");
INSERT INTO niy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nɨ́ yà nyɨ̀kpɔ́ya ótdyù tsí náadʉ̀ dhu àdu abádhí tɔ̀ ’àtɨ: ‹Ɨ̀nzɨ̌ fɔká rɨ́’ɨ̀ ɨdha rǎkǎ àlɛ̌ tɔ̀ atdíkpá nyɨ̌ mànà! Nɨ́ nyòwu nyòdzi fʉ̀kʉ́ kùdzǐ arɨ́ alɛ-fɔ́.› ");
INSERT INTO niy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nɨ́ kɔ̌kɔ̀ pbàdhɔ́má tɔ́ vèbhínzo náadʉ̀ òwu tarà ɔ̀ ɨdha nódzì. Pbɛ́tʉ̀, ányɨ̀ abádhí òwù rɔ́ nɨ́ ndɨ, amba-akpà-tsí adʉ̀ ndɨ̀tɔ̀. Nɨ́ yà imbò vèbhínzo, nyɨ̀kpɔ́ya ótdyù, yà angyangyɨ rúbhi kɔ̀dɔ̀ rɔ̌, náadʉ̀ òtsù atdíkpá àbadhi mànà amba ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀, kadʉ̀ tsǎtsʉ̀ nápbi atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nɨ́ olù nyʉ́ nɨ́ ndɨ, ngʉ̌kpà imbò vèbhínzo níiwú ùvò. Abádhí níitsi ’ɔ̀pɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌: ‹Ádrʉ̀ngbǎlɛ́, ádrʉ̀ngbǎlɛ́, ápfo tsǎtsʉ̀ fǎkà!› ");
INSERT INTO niy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pbɛ́tʉ̀, amba-akpà-tsí náadʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: ‹Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Ɨnzá ma mʉ̀nɨ nyɨ̌!›» ");
INSERT INTO niy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nɨ́ Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyòko nyɨ̀kpɔ́kʉ nà, ɨnzá nyɨ̌ nyʉ̀nɨ ndɨ ɨdhɔ mà, ndɨ kàsʉmɨ̀ mànà nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́lɨ ndɨ̀ yà dhu bhěyi: Atdí alɛ náazè ndàrà abhi ɔ̀. Nɨ́ kǎnzi pbɨ̀ndà kasʉtálɛ, ndàdʉ̀ pbɨ̀ndà malɨ̀ nʉ́ndɔ̀ fɔyá. ");
INSERT INTO niy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Atdí alɛ-fɔ́ kǎbhʉ̀ imbò tàlatà, ngǎtsi-fɔ́ kǎbhʉ̀ ɔ́yɔ̌ tàlatà, ndɨrɔ̀ ɨ̀bhʉ rɨ́ kìsě alɛ-fɔ́ kǎbhʉ̀ atdí tàlatà. Ngǎtsi alɛ tɔ̀ kǎránà kàbhʉ rɔ̌ ndɨ alɛ bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ-bvʉ rɔ̌. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɨ̀và ndàrà abhi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, yà imbò tàlatà nabà alɛ náarà mùtùruzì ɔ̀nzɨ̀ ndɨ fʉ̀rangà dɔ̌, ndàdʉ̀ ngǎtsi imbò tàlatà nóngyè. ");
INSERT INTO niy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yà ɔ́yɔ̌ tàlatà nàbà alɛ náanzɨ̀ dhu ndɨ dhu bhěyi tɨ́, ndàdʉ̀ ngǎtsi ɔ́yɔ̌ tàlatà nóngyè. ");
INSERT INTO niy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pbɛ́tʉ̀, yà atdí tàlatà nabà alɛ náarà ibhu nógyè, ndàdʉ̀ pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ bhà malɨ̀ nɔ́tdʉ̀ ɔ̀nà. ");
INSERT INTO niy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nɨ́ ábhɔ̌ ɨdhɔ nyʉ́ dzidɔ̌, wɔ̀ kasʉ tɔ́ ádrʉ̀ngbǎlɛ náarà ndàdu abhi ɔ̀ rɔ̀. Nɨ́ kǎdʉ̀ pbɨ̀ndà kasʉtálɛ núnzì ndɨ́nɨ̌ ngǎtsi alɛ nʉ́ʉnɔ tɨ́ ɨ̀ngbǎ dhu bhěyi màtɨ́ ndɨ̀ ndɔ́nzɨ̀ kasʉ fɔná ka kabhʉ̀ tàlatà nɨ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nɨ́ yà imbò tàlatà ka kabhʉ̀ fɔná alɛ nɨ́ɨra, ndɨ̀tɛ̀ yà ndɨ̀ ndóngyè ngǎtsi imbò tàlatà, ndàdʉ̀ àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ́, nyɨ nyibho imbò tàlatà fudú, nɨ́ kànɨ̌ ma móngyè ngǎtsi imbò tàlatà.› ");
INSERT INTO niy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ àtɨ̀nà kà nɨ̌: ‹Ídzì dhu nɨ́ wɔ̀! Nyɨ nɨ́ ídzì kasʉtálɛ, ndɨrɔ̀ mběyi arɨ́ fɔná ka kɨ̀lɨ dhu ɔ̀dɔ alɛ. Nyɨ nyɔ́dɔ̀ yà fʉnʉ́ ma mabhʉ̀ ákɛ̌kpá dhu nyʉ́ mběyi. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, ma mɨ́ nyɨlɨ̌ nyongò pbàkà ádrʉ̀ngbǎ malɨ̀ nyʉ́ nɔ́dɔ̀. Ɨ́rà àlɛ̌ rɔnzɨ dhɛ̀dhɛ atdíkpá nyɨ mànà!› ");
INSERT INTO niy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wɔ̀ dhu-dzidɔ̌, yà ɔ́yɔ̌ tàlatà nabà alɛ nɨ́ɨra, ndàdʉ̀ àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ́, nyɨ nyibho ɔ́yɔ̌ tàlatà fudú. Nɨ́ kànɨ̌ ma móngyè ngǎtsi ɔ́yɔ̌ ngʉ̌kpà tàlatà.› ");
INSERT INTO niy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ àtɨ̀nà kà nɨ̌: ‹Ídzì dhu nɨ́ wɔ̀! Nyɨ nɨ́ ídzì kasʉtálɛ, ndɨrɔ̀ mběyi arɨ́ fɔná ka kɨ̀lɨ dhu ɔ̀dɔ alɛ. Nyɨ nyɔ́dɔ̀ yà fʉnʉ́ ma mabhʉ̀ ákɛ̌kpá dhu nyʉ́ mběyi. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, ma mɨ́ nyɨlɨ̌ nyongò pbàkà ádrʉ̀ngbǎ malɨ̀ nyʉ́ nɔ́dɔ̀. Nɨ́ ɨ́rà àlɛ̌ rɔnzɨ dhɛ̀dhɛ atdíkpá nyɨ mànà.› ");
INSERT INTO niy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kà rǐku dɔ̀ná rɔ̀ nɨ̌, yà atdí tàlatà nabà alɛ nɨ́ɨra átɔ̀, ndàdʉ̀ àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ́, ma mʉnɨ dhu nyɨ ràrɨ̌ atdídɔ̌ arɔ́rʉ̀ alɛ. Nyɨ nyarɨ́ dhu ògu ɨnzá nyɨ nyazò dhu ɔ̀ná ɨnga ɔ̌, ndɨrɔ̀ nyɨ nyarɨ́ ɔ̀nyʉ̀-tsʉ̀ núndǔ ɨnzá nyɨ nyarɛ̀ itse ɔ̀ná ɨnga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ma mɨ’ɨ̀ ɔdɔ nà atdídɔ̌, nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, ma marà pbʉ̀kʉ̀ tàlatà nɔ́tdʉ̀ adzɨ ɔ̀. Nɨ́, ákɔ̌ pbʉ̀kʉ̀ malɨ̀ fudú rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: ‹Nyɨ nɨ́ nzɛ́rɛ, ndɨrɔ̀ ngbɔ̌na áyǐ kasʉtálɛ! Nyɨ nyʉnɨ wà dhu ma rarɨ́ dhu ògu ɨnzá ma mazò dhu ɔ̀ná ɨnga ɔ̌, ndɨrɔ̀ ma rarɨ́ ɔ̀nyʉ̀-tsʉ̀ ùndǔ ɨnzá ma marɛ̀ itse ɔ̀ná ɨnga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nɨ́ dhu akána tɨ́ obhó nyarà pbàkà fʉ̀rangà nɨ́lɨ yà fʉ̀rangà ɔ̀dɔ arɨ́ alɛ-fɔ́, ndɨ́nɨ̌ ma mɨ́ madǔ nɨ́nganɨ́, ma madʉ̀ya t’ítsi àkɔnà ɨwà dɔ̀ná nɨ̀dɔ̀ rɔ́rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wɔ̀ kasʉ tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ àtɨ̀nà tdɨ́tdɔ̌: ‹Nyàkɔ wɔ̀ atdí tàlatà kà-fɔ́ rɔ̀, nyǎdʉ̀ àbhʉnà yà ɨdrɛ̀ tàlatà nà rɨ́’ɨ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Obhó tɨ́, dhu nà arɨ́’ɨ̀ alɛ tɔ̀ ka kabhʉ̀ya dhu, àbadhi ràdʉ̀ ɨ̀’ɨ̀ dhu nà abhɔ nyʉ́ ròsè. Pbɛ́tʉ̀, ɨ̀mbǎ arɨ́’ɨ̀ dhu nà alɛ-fɔ́ rɔ̀, ka kakɔ̀ya yà akɛkpá kǎrɨ́’ɨ̀ nà dhú-ngba mà. ");
INSERT INTO niy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nɨ́ nyìdyi wɔ̀ àkyǎkyɛ̀ kasʉtálɛ, nyǒbvù iri ɨ́nɔ̀ ɔ̀. Ányɨ̀ nɨ’ɨya ɔdzɨ mà alɛ-kù t’átrita mànà.›» ");
INSERT INTO niy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ìndrǔ t’ídhùnà mà rǐwu pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ kɔ́rɔ́ pbɨ̀ndà màlàyíká mànà nɨ́nganɨ́, kǎdɨ̀ya ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ tɔ́ pbɨ̀ndà tombi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nɨ́ kɔ́rɔ́ yà adzɨ dɔ̌ alɛ-tɨdɔ̀ núunduya ɨ̀ kɔ̀nzɨ̌, kà ràdʉ̀ ɔ̀yánga nʉ́ndɔ̀ àdhàdhɨ̀ tàmà nʉ́nda arɨ́ alɛ náarɨ́ tàmà mà nzínzì ɔ̌nga nútǔ ɨ̀ndrɨ̀ mànà dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kʉ̌lɨya tàmà pbɨ̀ndà fangà dɔ̀nǎ rɔ̀, ndàdʉ̀ ɨ̀ndrɨ̀ nʉ́lɨ pbɨ̀ndà ígù dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nɨ́rɔ̀ nɨ́ ndɨ Ádrʉ̀ngbǎ kamà náadʉ̀ya àtɨ̀nà pbɨ̀ndà-fangà dɔ̀nǎ rɔ̀ rɨ́’ɨ̀ alɛ nɨ̌: ‹Nyìwǔ, nyɨ̌ yà Àbadu náaso nyɨ̌ rɔ̀, nyǒkò yà angyangyɨ kǎbhɔ̀lɔ̀ fʉ̌kʉ̀ yà adzɨ ndɨ̀ ndanzɨ̀ nɨ́nganɨ́ Ádrʉ̀ngbǎ kamà bhà idzi-kàmǎ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Obhó tɨ́, ma mɨ’ɨ̀ àwù nà, nɨ́ nyɨ̌ nyibho ɔ̀nyʉ̀ mɔnyʉ̀. Ma mɨ’ɨ̀ ɨdha-atdyú nà, nɨ́ nyɨ̌ nyibho ɨdha mɔmvʉ̀. Ma mɨ’ɨ̀ olo tɨ́, nɨ́ nyɨ̌ nyakɔ̀ ma mběyi. ");
INSERT INTO niy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma mɨ’ɨ̀ tɨ́rɔ̌rɔ̀, nɨ́ nyɨ̌ nyʉfɔ́ ma. Ma mɨ’ɨ̀ andɨ nà, nɨ́ nyɨ̌ nyiwú mandà. Ndɨrɔ̀ ma mɨ’ɨ̀ imbi ɔ̀, nɨ́ nyɨ̌ nyiwú mandà.› ");
INSERT INTO niy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nɨ́rɔ̀ nɨ́ ndɨ obhónángatálɛ nɔ́ɔngʉ́ya dhu kà-tsʉ̌, ’àtɨ: ‹Ádrʉ̀ngbǎlɛ́, ɨ́ngbàngá nga ndɨ mǎ mala nyɨ àwù nà nyɨ́’ɨ̀ rɔ́, mǎdʉ̀ ɔ̀nyʉ̀ nábhʉ nyɔnyʉ̀ nɨ̌? Ɨ́ngbàngá nga ndɨ mǎ mala nyɨ ɨdha-atdyú nà nyɨ nyɨ́’ɨ̀ rɔ́, mǎdʉ̀ ɨdha nábhʉ nyɔmvʉ̀ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɨ́ngbàngá nga ndɨ nyɨ nyɨ’ɨ̀ olo tɨ́, mǎdʉ̀ nyakɔ mběyi nɨ́? Ndɨrɔ̀, ɨ́ngbàngá nga ndɨ mǎ mala nyɨ tɨ́rɔ̌rɔ̀ nyɨ nyɨ́’ɨ̀ rɔ́, mǎdʉ̀ mbɛrʉ̀ nʉ́fɔ rʉ̀nʉ́ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɨ́ngbàngá nga ndɨ, mǎ mala nyɨ andɨ nà nyɨ nyɨ́’ɨ̀ rɔ́, mǎdʉ̀ òwu nyandà nɨ́? Ndɨrɔ̀, ɨ́ngbàngá nga ndɨ mǎ mala nyɨ imbi ɔ̀ nyɨ nyɨ́’ɨ̀ rɔ́, mǎdʉ̀ òwu nyandà nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nɨ́ Ádrʉ̀ngbǎ kamà, adʉ̀ya dhu àdu abádhí tɔ̀, ndàtɨ: ‹Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, dhu apɛ́ ɨ̀’ɨ̀ ɨwà nyɨ̌ nyanzɨ̀ kɔ̌kɔ̀ dhu yà ɨ̀nzɨ̌ ka karɔ́zʉ̀na dhu tɨ́ adɔ́du nzínzì ɔ̌ atdí alɛ rɔ̌ màtɨ́ dhu tɨ́, nɨ́ nyɨ̌ nyanzɨ̀ wà ka rùdú.› ");
INSERT INTO niy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tdɨ́tdɔ̌, Ádrʉ̀ngbǎ kamà náadʉ̀ya àtɨ̀nà fɨ̀ndá ígù dɔ̀nǎ rɔ̀ rɨ́’ɨ̀ alɛ nɨ̌: ‹Nyìndrǐ nyɨ̌ ɨtsɛ tɨdú rɔ̀, yà Àba Kàgàwà afù nyɨ̌ rɔ̀. Nyòwu yà kǎbhɔ̀lɔ̀ Pfɔ̀mvɔ mà, pbɨ̀ndà màlàyíká mànà tɔ̀ ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀! ");
INSERT INTO niy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Obhó tɨ́, ma mɨ’ɨ̀ àwù nà, nɨ́ nyɨ̌ nyibho nzá dhu mɔnyʉ̀. Ma mɨ’ɨ̀ ɨdha-atdyú nà, nɨ́ nyɨ̌ nyibho nzá ɨdha mɔmvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma mɨra olo tɨ́ bvʉ̀kʉ̀, nɨ́ nyɨ̌ nyakɔ̀ nzá ma. Ma mɨ’ɨ̀ tɨ́rɔ̌rɔ̀, nɨ́ nyɨ̌ nyʉfɔ́ nzá ma. Ma mɨ’ɨ̀ andɨ nà, ndɨrɔ̀ ma mɨ’ɨ̀ imbi ɔ̀ ka kósò ma rɔ́, nɨ́ nyɨ̌ nyiwú nzá mandà.› ");
INSERT INTO niy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nɨ́ kɔ̌kɔ̀ ígù dɔ̀nǎ rɔ̀ ɨ̀’ɨ̀nà alɛ náadʉ̀ya dhu ɔ̀ngʉ̀ átɔ̀ kà-tsʉ̌, ’àtɨ: ‹Ádrʉ̀ngbǎlɛ́, ɨ́ngbàngá nga ndɨ mǎ mala nyɨ àwù rɨ̌ nyoho rɔ́, ɨdha-atdyú rɨ̌ nyoho rɔ́, olo tɨ́ nyɨ nyɨ̀rà fàrábvʉ̀ rɔ́, tɨ́rɔ̌rɔ̀ nyɨ nyɨ́’ɨ̀ rɔ́, andɨ nà nyɨ nyɨ́’ɨ̀ rɔ́, ndɨrɔ̀ imbi ɔ̀ ka kósò nyɨ rɔ́, ɨ̀nzɨ̌ mǎdʉ̀ atdí dhu mà nɔ́nzɨ̀ ɨndʉ̀ nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nɨ́ Ádrʉ̀ngbǎ kamà náadʉ̀ya dhu àdu abádhí tɔ̀, ndàtɨ: ‹Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, kɔ̌kɔ̀ ɨnzá nyɨ̌ nyanzɨ̀ yà ɨ̀nzɨ̌ ka karɔ́zʉ̀na dhu tɨ́ adɔ́du nzínzì ɔ̌ atdí alɛ-rɔ̌ màtɨ́ dhu, nɨ́ nyɨ̌ nyanzɨ̀ nzá rùdú.› ");
INSERT INTO niy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nɨ́ abádhí nóowuya dhòdhódhónga tɔ́ àpbɛ̀ ɔ̀, pbɛ́tʉ̀ obhónángatálɛ náadʉ̀ya òwu dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yěsù níitdègu yà ndɨ̀ ndúbhi ùdhenà rɔ̌ ìndrǔ tɔ̀ dhu t’údheta nɨ́tɔ kɔ́rɔ́, nɨ́ kǎdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: ");
INSERT INTO niy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Nyɨ̌ nyʉ̀nɨ wà dhu Pásɨ̀ka tɔ́ Mʉ̀hɛndʉ̀ ràrɨ̌’ɨ̀ ɔ́yɔ̌ ɨdhɔ dzidɔ̌. Nɨ́ ka kɨ́ Ìndrǔ t’ídhùnà nípfǒ, kabhʉ òmvǔ-fɔ́, ndɨ́nɨ̌ ka kʉtɔ́ tɨ́ mʉ̀sàlabhà dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí tɔ́ pbàkʉ̀rʉ̌ mànà, núundu ɨ̀ Kàyafà bhà ádrʉ̀ngbǎ ɨdzá-yà-ba ɔ̌. Kàyafà nɨ’ɨ̀ pbàkùhánɨ́ dɔ̌ kamà. ");
INSERT INTO niy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nɨ́, abádhí nɨ́ɨrɨ ɨ̀ ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ Yěsù ɨnzá kɔ́rɔ́ alɛ nʉ́nɨ rɔ́rɔ̀, ’àdʉ̀ àbhʉnà kohò. ");
INSERT INTO niy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pbɛ́tʉ̀, abádhí náadʉ̀ àtɨ̀nà: «Dhu àkǎ nzá àlɛ̌ ràlʉ̌ ka mʉ̀hɛndʉ̀ ɔ̌ rɔ̀, akyɛ ìndrǔ nɨ́ɨvàna dhu nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yěsù nɨ́ɨ’ɨ̀ Bɛ̀tànɨyà tɨ́ kátɨna pbangá-ngba ɔ̌, Sìmonì tɨ́ kátɨna atdí alɛ bhà ɨdzá. Ndɨ Sìmonì nɨ́ yà kɨ́kɨ́ nà ɨ’ɨ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nɨ́ atdí tsìbhálɛ náandrì kà-tɨ’ɔ̀. Ndɨ tsìbhálɛ nɨ́ɨ’ɨ̀ àlbatrɔ̀ tɨ́ kátɨna odu nɨ̌ ka kɔ́bhɔ̀lɔ̀ tsúpà nà fɔná. Ndɨ tsúpà ɔ̀ ɨ’ɨ̀ dhu nɨ́ ndrùù rɔ́ngʉ, ndɨrɔ̀ ɔrʉ́ odzìna nà akyɛ. Nɨ́ ɔ̀nyʉ̀ nɔ́nyʉ Yěsù rɨ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, kǎdhɔ̀ ndɨ akyɛ Yěsù-dɔ̀tsírɔ́. ");
INSERT INTO niy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nɨ́ wɔ̀ dhu ɨ̀ àla rɔ̀, Yěsù bhà ábhàlɨ̌ náapɛ̀ ’ònù nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀kɔ̀! Ádhu kà rɨ̌ wɔ̀rɨ́ akyɛ nɨ́nzǎ wɔ̀ dhu bhěyi nɨ́? ");
INSERT INTO niy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ka kàmbɛ̀nà tɨ́ obhó ndɨ akyɛ nábhʉ̌ kodzì ɔrʉ́ odzi ɔ̌, kadʉ̀ ndɨ fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀?» ");
INSERT INTO niy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nɨ́ Yěsù níitdègu wɔ̀ abádhí rʉ̌nɔna dhu nɔ́sʉ̀, nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu nyɨ̌ nyʉ̀va wɔ̀ tsìbhálɛ-tsì nɨ̌? Yà rùdú kɔ̀nzɨ̀ dhu nɨ́ ídzì dhu nyʉ́ ròsè. ");
INSERT INTO niy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Obhó tɨ́, nyɨ̌ nyóngo òko nǎkʉ̀tálɛ mànà bìlǐnganà, pbɛ́tʉ̀ àlɛ̌ kɨ́ nzɨ̌ ongo òko nyɨ̌ mànà bìlǐnganà. ");
INSERT INTO niy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wɔ̀ akyɛ kɔ̀dhɔ̀ dùdu-tsírɔ́ dhu nɨ̌, kɔ̀bhɔ̀lɔ̀ wà ngbɔ̌du angyangyɨ ɔtdʉ́ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: kɔ́rɔ́ ngari ɔ̌, yà Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ ka kɨ́ yà adzɨ ɔ̌ ɨnanǎ, ka kóngo yà tsìbhálɛ nɔ́nzɨ̀ dhu àwɛ ìndrǔ tɔ̀, kowù kɨ̀rɛ̀ rɔ̌ rɔ̀ná.» ");
INSERT INTO niy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wɔ̀ dhu-dzidɔ̌, ɨdrɛ dɔ̀ná ɔ́yɔ̌ nà Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, Yudhà Ìskàrìyɔtà tɨ́ kátɨna, náarà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ-tɨ́ ’ɔ̀, ");
INSERT INTO niy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu nyɨ̌ nyòzè nyǐbhò idù ndɨ́nɨ̌ ma mipfo tɨ́ Yěsù mabhʉ fʉkʉ́?» Nɨ́ abádhí náadʉ̀ Pbàyàhúdí-bvʉ̌ ɨ̀bhʉ kumì fʉ̀rangà-kpɔ̌ nɔ́zʉ̀, ’àbhʉ kà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Yudhà náadʉ̀ Yěsù nípfǒ ndɨ̀ ndɨ́, ndàbhʉ abádhí-fɔ́ nɨ̌ ídzì otu nɔ́pɛ̀ ndɔ̀nɛ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ɨ̀mbǎ ɔ̀nà afi nà mʉ̀gatì ka kɔnyʉ́nà ɔ̀ná mʉ̀hɛndʉ̀ tɔ́ wɛmbɛrɛ̀ tɔ́ ɨdhɔ ɔ̌, Yěsù bhà ábhàlɨ̌ náawù dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Ádhà nga ndɨ nyɨ nyòzè Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ mɔ̌bhɔ̀lɔ̀ ɨndʉ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyòwu kɨgɔ̀ ɔ̀ atdí alɛ bhà, nyǎdʉ̀ àtɨ̀nà kà nɨ̌, Màlimò rǎtɨna ɨwà pbɨ̀ndà ɔvɛ tɔ́ kàsʉmɨ̀-tsʉ̀ rìndù ndɨ̀. Nɨ́ ɨ̀ ràrɨ̌ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ ɔ̀nyʉ atdíkpá pbɨ̀ndà ábhàlɨ̌ mànà pbʉ̀ ɨdzá rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nɨ́ Yěsù bhà ábhàlɨ̌ náanzɨ̀ yà kàvinà fɨ̌yɔ̀ dhu, ’àdʉ̀ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ nɔ́bhɔ̀lɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɨnga níitdègu àtɨ, nɨ́ Yěsù mà náadʉ̀ òko ɔ̀nyʉ̀-tsʉ̀nǎ pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ mànà. ");
INSERT INTO niy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nɨ́ dhu nɔ́nyʉ ɨ̀ ɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù náatɨ abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, nzínzìkʉ ɔ̌ atdí alɛ rɨ̌ mipfǒ, ndàbhʉ ma òmvǔ-fɔ́.» ");
INSERT INTO niy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nɨ́ ɨzʉ nʉ́ʉka Yěsù bhà ábhàlɨ̌ atdídɔ̌ nyʉ́, ’àdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu atdátdírà ɔ̌ kà-tsʉ̌, ’òwù àtɨ̀nà rɔ̌: «Tɨ́ ɨma ndɨ Ádrʉ̀ngbǎlɛ́?» ");
INSERT INTO niy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Yà atdíkpá mǎ mʉ̀fɔ̌ ɔtsʉ́ka nà kyàwì ɔ̀ alɛ nɨ́ ndɨ rɨ́ mipfǒ, ndàbhʉ ma òmvǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ìndrǔ t’ídhùnà rɔ̌vɛ̀ yà Kàgàwà bhà Andítá rʉ̌nɔna dɔ̀ná dhu bhěyi. Pbɛ́tʉ̀, kìpfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ rɨ̌’ɨ̀ ádrʉ̀ngbǎ àpbɛ̀ ɔ̌! Dhu akána nzɨ̌ kɔdhɨ̀ ndɨ alɛ mà!» ");
INSERT INTO niy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nɨ́ Yudhà, yà Yěsù nípfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ, náakɔ̀ ɔtɛ, ndìvǔ dhu kà-tsʉ̌, ndàtɨ: «Tɨ́ ɨma ndɨ Màlimǒ?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Nyɨ nɨ́ ndɨ ka nyɨ nyʉ̀nɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dhu ɔ̀nyʉ ɨ̀’ɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù idyi mʉ̀gatì, ndàlʉ̌ fɔná. Nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kʉ̌kɔ kà-ɔ̌nga, ndàdʉ̀ ʉ̀ndɔ̀nà pbɨ̀ndà ábhàlɨ̌-fɔ́, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyàkɔ yà dhu, nyǎdʉ̀ ɔ̀nyʉ̀nà. Ngbɔ̌du nɨ́ yà.» ");
INSERT INTO niy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tdɨ́tdɔ̌ kǐdyi dɨ̀vayì rɨ̌’ɨ̀ ɔ̀nà kɔ́pà ndàlʉ̌ fɔná. Nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kǎdʉ̀ kàbhʉ abádhí tɔ̀, ndàdʉ̀ àtɨ̀nà: «Nyɨ̌’ɨ kɔ́rɔ́, nyɔ̀mvʉ̀ ka. ");
INSERT INTO niy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yàrɨ́ nɨ́ azùdu, yà ìndrǔ nùngbò Kàgàwà mànà azu, ndɨrɔ̀ ábhɔ̌ alɛ-okú dɔ̀ rɔ̀ ndɨ̀ nʉ̀fʉ̀, ndɨ́nɨ̌ Kàgàwà nʉ́ʉbà tɨ́ ìndrǔ tɔ́ nzɛ́rɛnga abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma mátɨna nyɨ̌ nɨ̌: Rɔ̀pɛ̀ ndɨ̀ kòmbí, ma mɨ́ nzɨ̌ yàrɨ́ dɨ̀vayì nɔ́mvʉ̀ tdɨ́tdɔ̌, ràrà àhʉ dɨ̀vayì ɔwʉ́tá nɔ́mvʉ̀ àlɛ̌ kowuya atdíkpá nyɨ̌ mànà Àbadu Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ idzi ɔ̌ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Adyi ɨ̀ ʉ̀yʉ̀ dhu-dzidɔ̌, abádhí adʉ̀ òwu mìzèyìtunì tɨ́ kátɨna itsu náarɨ́’ɨ̀ dɔ̀ná pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Indo, yàrɨ́ iku ɔ̌, nyɨ̌ kɔ́rɔ́, nyɨ̌ nyɨ́ mʉbha atdírɔ̀. Obhó tɨ́, Kàgàwà bhà bhǔkù ɔ̀ ka kándǐ dhu katɨ: ‹Ma mohoya tàmà t’ʉ́ndatatálɛ, tàmà ràdʉ̀ ’ɨ̀fàlà kɔ́rɔ́ ngari ɔ̀nǎ.› ");
INSERT INTO niy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pbɛ́tʉ̀, ma mɨ̀ngbɛ̀ ma dhu-dzidɔ̌, ma madʉ̀ya àrà nyɔ̌dɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nɨ́ Pɛ́tɛrʉ̀ apɛ̀ ɔtɛ, ndàdʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ngʉ̌kpà alɛ mà rɨ̌ mbǎ nyʉbha, nɨ́ ma mɨ́ nzɨ̌ nyʉbha akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀: ‹Indo, yàrɨ́ iku ɔ̌, ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyàtɨ ɨ̀bhʉ-gʉ̀na ɨnzá nyɨ rʉ́nɨ ma rɔ́.›» ");
INSERT INTO niy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ma mɨ́ nzɨ̌ àtɨna akɛkpá màtɨ́ ɨnzá ma rʉ́nɨ nyɨ, ɨ̀mbǎ dhu ɨ’ɨna atdíkpá àlɛ̌ kʉ́vɛ nyɨ mànà dhu màtɨ́.» Ndɨrɔ̀ kɔ́rɔ́ ngʉ̌kpà ábhàlɨ̌ náadʉ̀ dhu ʉ̀nɔ̀ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tdɨ́tdɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Gɛ̀tɛ̀sɛ̀manɨ̀ tɨ́ kátɨna atdí ngari ɔ̀. Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòko ɨrɔ́ ndǎlʉ̀ ma márà mɨtsɔ̀ ɔ̀na nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nɨ́ kǎdʉ̀ Pɛ́tɛrʉ̀ mà, Zɛ̀bɛ̀dayò bhà ɔ́yɔ̌ inzo mànà núnzì, ’àdʉ̀ òwu mànà ányɨ̀. Nɨ́ kɨ̌’ɨ̀ ɨzʉ nà atdídɔ̌, afína ràdʉ̀ ndɔ̀pɛ̀ ndɨ̀nza ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ àtɨ̀nà abádhí nɨ̌: «Afídu rɨ̌’ɨ̀ ábhɔ̌ ɨzʉ nyʉ́ nà, akyɛ ma mɔ́vɛ̀ dhu bhěyi. Nɨ́ nyòko ɨrɔ́, ndɨrɔ̀ nyòko ípìrɔ̌rɔ̀, yà ma mádɨ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kǎdʉ̀ àrà ɨtsɛta akɛ, ndàdʉ̀ ndìbvu obvò, ndàpbǎ nyɨ̀na adzɨkpa nyʉ́ rɔ̌. Nɨ́ kǎdʉ̀ ndɨ̀tsɔ̀, ndàtɨ: «Àbá, ndɨ dhu rǎdʉ̀ ndɔ̀nzɨ̀ nánɨ̌, índrǐ wɔ̀ àpbɛ̀ tɔ́ kɔ́pà ɨtsɛ rùdú rɔ̀. Pbɛ́tʉ̀, ndɨ dhu àkǎ nzá ndɔ̀nzɨ̀ ndɨ̀ ma mòzè ka dhu bhěyi, kàkǎ ndɔ̀nzɨ̀ ndɨ̀ yà nyɨ nyʉ́ nyɨ nyòzè ka dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɨ́ kǎdʉ̀ ndàdu kɔ̌kɔ̀ ɨ̀bhʉ ábhàlɨ̌-tɨ’ɔ̀, ndàdʉ̀ abádhí nótù ɨwà ʉ̀dhɔ rɔ́. Nɨ́ kǎdʉ̀ dhu ìvu Pɛ́tɛrʉ̀-tsʉ̌, ndàtɨ: «Nyɨ̌ nyàdʉ̀ tɨ́ obhó òko ípìrɔ̌ rɔ̀ ma mànà atdí adyifɔ̀-sɨsɨ̀ màtɨ́? ");
INSERT INTO niy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nyòko ípìrɔ̌rɔ̀, ndɨrɔ̀ nyɨ̀tsɔ̀ nyɨ̌ akyɛ nyɨ̌ nyotsúna umvútá ɔ̀ nɨ̌. Alafí nózè ndɔ̀nzɨ̀ ídzì dhu, pbɛ́tʉ̀ alɛ-ngbɔ̀ rɨ̌ ndɨ ɨ̀’ɨ̀ ivíví ɨ dhu t’ɔ́nzɨta tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ɔyɔ rɨ́ kìsě nɨ̌, kǐndrí ndɨ̀ ɨtsɛ tdɨ́tdɔ̌ abádhí-tɨ́ rɔ̀, ndàdʉ̀ ndɨ̀tsɔ̀ yà dhu bhěyi: «Àbadú, yàrɨ́ àpbɛ̀ tɔ́ kɔ́pà náapɛ́ ɨ̀’ɨ̀ ɨ̀nzɨ̌ rʉ́da dùdu nǎ ɨnzá ma mɔ̀mvʉ̀ rɔ́rɔ̀ dhu tɨ́, nɨ́ ítsè afínʉ òzè dhu rɔnzɨ ndɨ̀!» ");
INSERT INTO niy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nɨ́, ábhàlɨ̌-tɨ’ɔ̀ ndɨ̀ ndàdu ndɨ̀ rɔ̀, kǎdʉ̀ abádhí òtù ɨwà ʉ̀dhɔ rɔ́, atdídɔ̌ ɨdhɔ rɨ̌’ɨ̀ nyɨ̀kpɔ́ya ɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yěsù nɨ́ɨvà ndɨ̀, ndìndrǐ ndɨ̀ ɨtsɛ tdɨ́tdɔ̌ abádhí-tɨ́ rɔ̀. Nɨ́ ɨ̀bhʉ rɨ́ kìsě nɨ̌, kǎdʉ̀ ndɨ̀tsɔ̀, ndʉ̀nɔ̀ yà angyi ndɨ̀ ndárà ʉ̀nɔ̀nà rɔ̌ ɔtɛ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tdɨ́tdɔ̌ kǎdù ndɨ̀ ábhàlɨ̌ ɨ, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ pbánɨ́ òko nyɨ̌ nyòko ɔ̀dhɔ̀ nyɨ̌ nyɔ́dhɔ̀ rɔ́! Nyɨ̌ pbánɨ́ nyǎsǒ nyɨ̌? Nyàndà! Kànɨ̌ Ìndrǔ t’ídhùnà nábhʉ̌ ka kɨ́ nzɛ́rɛngatálɛ-fɔ́ nɨ̌ kàsʉmɨ̀ nákǎ wà. ");
INSERT INTO niy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nɨ́ nyɨ̀và nyɨ̌, kòwu! Kànɨ̌ ma àbhʉ̌ rɨ́ òmvǔ-fɔ́ alɛ nɨ́rà wà!» ");
INSERT INTO niy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yěsù rɔ̌tɛ ɔ̀nanǎ, Yudhà, atdí kumì dɔ̀ná ɔ́yɔ̌ nà kàbhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, nɨ́ɨtɔ ndɨ̀ ábhɔ̌ ihé-yà mànà owùna ɔ̌. Ɨ alɛ-fɔ́ nɨ’ɨ̀ obhí-akpá mà, mùgǒ mànà. Abádhí nivi nɨ’ɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà. ");
INSERT INTO niy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ndɨ Yudhà yà Yěsù nípfǒ rɨ́ ndàbhʉ rɨ́ òmvǔ-fɔ́ alɛ, nɨ’ɨ̀ ɨwà ndɨ̀ ndɔnzɨna Yěsù ka kʉnɨ tɨ́ rɔ̀ná dhu nʉ̀nɔ̀nà ihé-yà tɔ̀. Kǎtɨ abádhí nɨ̌: «Ma mámbǒna alɛ nɨ’ɨna ndɨ nyɨ̌ nyɨ́ atdyúna òho alɛ. Nɨ́ nyàlʉ̌ ka dòtsí.» ");
INSERT INTO niy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nɨ́ Yudhà náandrì ányɨ̀rɔ̌ rɔ́ tɨ́ Yěsù-tɨ’ɔ̀, ndàdʉ̀ kàtsɛ̀ ndàtɨ: «Yǎmbʉ̀ Màlimò!» Kǎdʉ̀ kàmbo. ");
INSERT INTO niy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɔdhɨ́, ɔ́nzɨ nyɨ nyɨ̀rà ɔ̀nzɨ̀nà dhu!» Nɨ́rɔ̀ nɨ́ ndɨ ngʉ̌kpà alɛ náadʉ̀ ìndri, àlʉ̌ Yěsù, àdʉ̀ òsònà. ");
INSERT INTO niy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nɨ́ Yěsù mà nɨ́’ɨ̀ mànà alɛ nzínzì ɔ̌, atdí alɛ nɨ́ɨdhá pbɨ̀ndà ɨla tɔ́ obhi-akpà, ndʉ̀’à pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà kasʉtálɛ-bɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nɨ́ Yěsù àdʉ̀ àtɨ̀nà kà nɨ̌: «Ádǔ pbʉ̀kʉ̀ obhi fɨ̀ndá ngari ɔ̀. Obhó tɨ́, kɔ́rɔ́ alɛ yà obhi ùgu arɨ́ ìndrǔ tɔ̀, nʉ́ʉvɛ̀ya obhi nɨ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nyɨ nyɨ̀rɛ̀ tɨ́ dhu ɨ̀nzɨ̌ ma ràmbɛ̀nà mʉ̀dzʉ̀nà nónzi Àbadu Kàgàwà-fɔ́, ràdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà dɔ̀nǎ róse ɨla t’úgyeta tɔ́ pbɨ̀ndà màlàyíká tɔ́ pɨ̀kɔ̀ níbhò idù ányɨ̀rɔ̌ rɔ̀ tɨ́? ");
INSERT INTO niy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pbɛ́tʉ̀, ndɨ dhu bhěyi kɨ̀’ɨ̀ rɔ̀, yà àndǐ ka kandí Kàgàwà bhà Andítá ɔ̀ dhu náakána ɨ̀ngbǎ dhu bhěyi? Obhó tɨ́, ndɨ Andítá rǎtɨna kà ràkǎ ndɔ̀nzɨ̀ ndɨ̀ ndɨ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ndɨ kàsʉmɨ̀ ɔ̌, Yěsù adʉ̀ àtɨ̀nà ihé-yà nɨ̌: «Ádhu nyɨ̌ nyíwu ma nálʉ fʉkʉ́ obhí-akpá mà, mùgǒ mànà nà, ogbotálɛ nálʉ ríwu alɛ bhěyi nɨ̌? Bìlǐnganà ma múbhì àdɨ rɔ̀ mambɛ dhu ùdhe dɔ̌ Kàgàwà bhà ɨdza ɔ̌ rɔ̀, ɨ̀nzɨ̌ nyǎdʉ̀ ma àlʉ. ");
INSERT INTO niy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pbɛ́tʉ̀, kɔ́rɔ́ kɔ̌kɔ̀ dhu nɔ́nzɨ̀ ɨ̀ ndɨ́nɨ̌ Kàgàwà bhà pbànábí náandí dhu náaká tɨ́.» Nɨ́rɔ̀ nɨ́ ndɨ kɔ́rɔ́ ábhàlɨ̌ nʉ́ʉbhà àbadhi, ’àdʉ̀ òtse. ");
INSERT INTO niy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yà Yěsù nòsò alɛ náawù kà nà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà, Kàyafà tɨ́ kátɨna bhà, yà Músà bhà Ʉyátá tɔ́ màlímó mà, pbàkʉ̀rʉ̌ mànà núndu ɨ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɛ́tɛrʉ̀ adʉ̀ àdɨ ɨtsɛta ndàmbɛ àrà dɔ̌ Yěsù-owù ɔ̌, ndàrà àhʉ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà ɨdza-li’ɔ̀. Nɨ́ kǎtsù ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀ ɔ̀, ’àdʉ̀ òko obvò atdíkpá sàndǐrì mànà, ndɨ́nɨ̌ ndɨ̀ ndala tɨ́ wɔ̀ dhu rǎrà ìku tɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ ngʉ̌kpà alɛ mànà kɔ́rɔ́, náambɛ́nà tɨ̀tɔ̀ dɔ̌ màtɨ́ ka kɨ́ Yěsù nɔ́bhʉ dɔ̀ná dhu nɔ́nɛ̀ dɔ̌, ndɨ́nɨ̌ kadʉ̀ tɨ́ kòhò. ");
INSERT INTO niy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pbɛ́tʉ̀, ɨ̀mbǎ tɨ̀tɔ̀ tɔ́ ábhɔ̌ ngàmbì mà níiwú, ’ʉ̀nɔ̀ tɨ̀tɔ̀ kà-dɔ̌, nɨ́ abádhí náabà nzá atdí dhu mà. Nɨ́rɔ̀ nɨ́ ndɨ ɔ́yɔ̌ alɛ nʉ́ʉtɔ ɨ̀, ");
INSERT INTO niy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","’àdʉ̀ àtɨ̀nà: «Wɔ̀rɨ́ alɛ átɨ: ndɨ̀ ràrǎdʉ̀ Kàgàwà bhà ɨdza núgolo, ndàdʉ̀ ɔ̀sɨ̀nà tdɨ́tdɔ̌ ɨ̀bhʉ ɨdhɔ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà nɨ́ɨvà ndɨ̀, ndìdè, ndàtɨ Yěsù nɨ̌: «Nyɨ tɨ́ obhó dhu àdǔ? Ádhu kɔ̌kɔ̀ alɛ rʉ̌nɔna dʉ̀nʉ́?» ");
INSERT INTO niy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pbɛ́tʉ̀, Yěsù adʉ̀ ɨ̀nɛ̀ ɨ̀nɛ̀ tɨ́. Nɨ́ wɔ̀ kamà adʉ̀ àtɨ̀nà kà nɨ̌: «Yà ɨ̀nzɨ̌ arɔ́vɛ̀ Kàgàwà-ɔvɔ̀ rɔ̌, ma mòzè nyɔtsɔ̀ dhu nyʉ́. Nyɨ tɨ́ Krɨ́stɔ̀, Kàgàwà t’ídhùnà nyʉ́?» ");
INSERT INTO niy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨnyɨ nɨ́ ndɨ ka nyɨ nyʉ̀nɔ̀. Pbɛ́tʉ̀, ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Rɔ̀pɛ̀ ndɨ̀ kòmbí, nyɨ̌ nyɨ́ Ìndrǔ t’ídhùnà nálǎ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà arɨ́’ɨ̀ Kàgàwà bhà fangà dɔ̀nǎ rɔ̀ àdɨ rɔ́. Ndɨrɔ̀, nyɨ̌ nyalaya ka átɔ̀ ádrʉ̀ngbǎ àpbù dɔ̌ rɨ́rà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà nʉ́ʉfa rɔ̀ná mbɛrʉ̀-ɔ̌nga, ndàdʉ̀ àtɨ̀nà ihé-yà nɨ̌: «Kʉ̀nɔ̀ dhu nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌! Ɨ̀mbǎ àlɛ̌ kɨ́’ɨ̀ ngàmbì-atdyú nà tdɨ́tdɔ̌. Nyɨ̌ nyɨ̀rɨ̀ wà kʉ̀nɔ̀ Kàgàwà nɨ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nɨ́ ádhu nyɨ̌ nyɨ̀rɛ̀ kà dɔ̌?» Nɨ́ ihé-yà adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Kàkǎ wà ndɔ̀vɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wɔ̀ dhu-dzidɔ̌, abádhí núuso ɨsɔ Yěsù-nyɨ̀kpɔ́ ɔ̀, ’àdʉ̀ kùdù ùngùrǔ ɨ̀ ùngùrǔ ɔtsʉ́ya nɨ̌. Ngʉ̌kpà alɛ nóowúnà kʉ̀pbɨ̀ rɔ̌, ");
INSERT INTO niy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","’àdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨnyɨ Krɨ́stɔ̌, átɨ pɛ́ nyɨ nɔ̀pbɨ̀ alɛ fǎkà!» ");
INSERT INTO niy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pɛ́tɛrʉ̀ nɨ́ɨ’ɨ̀ irí ndɨ̀ ndàdɨ ɨdza-lí rɔ́. Nɨ́ kasʉ tɔ́ atdí tsìbhálɛ níindri kà-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨnyɨ mà átɔ̀, nyɨ̌ nyɨ́’ɨ̀ atdíkpá Yěsù, Gàlìlayà tɔ́ pbìrì ɔ̌ alɛ mànà.» ");
INSERT INTO niy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ wɔ̀ dhu nágò kɔ́rɔ́ alɛ-ɔ̀nzɨ̌ rɔ̀, ndàtɨ: «Ɨnzá ma mʉ̀nɨ wɔ̀ nyɨ nyʉ́nɔna dhu.» ");
INSERT INTO niy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wɔ̀ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ adʉ̀ ndɨ̀và, ndàrà ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀-li’ɔ̀. Nɨ́ kasʉ tɔ́ ngǎtsi tsìbhálɛ náala ka, ndàdʉ̀ àtɨ̀nà ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nɨ̌: «Yàrɨ́ alɛ mà nɨ́’ɨ̀nà atdíkpá Yěsù, Nàzàretì alɛ mànà!» ");
INSERT INTO niy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ wɔ̀ tsìbhálɛ ʉ̀nɔ̀ dhu nágò tdɨ́tdɔ̌, ndàdʉ̀ dhu nyʉ́ ɔ̀tsɔ̀, ndàtɨ: «Ɨnzá ma mʉ̀nɨ wɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nɨ́ ɨnzá kàsʉmɨ̀ nʉ́dà abhɔ màtɨ́ rɔ́rɔ̀, ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ náandrì Pɛ́tɛrʉ̀-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Obhó nyʉ́, nyɨ nɨ́ abádhí nzínzì ɔ̌ atdí alɛ. Obhó tɨ́, mǎ mʉ̀nɨ nyɨ yà nyɨ nyɔ́tɛ tɨ́ dhu rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nɨ́ Pɛ́tɛrʉ̀ ádʉ̀ ɔtɛ nɔ́pɛ̀, ndàtɨ abádhí nɨ̌: «Kàgàwà nákǎ ndɔ̀tdɨ̀ ànyǎdu! Ma mɔ̀tsɔ̀ wà dhu matɨ, ɨnzá ma rʉ́nɨ wɔ̀ alɛ!» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ à’ʉ̌-akpà náadʉ̀ ɔ̀ngɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ adʉ̀ yà Yěsù nʉ́nɔ̀nà fɨ̌ndà dhu nɨ́rɛ̀. Kǎtɨ: «Ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyàtɨ ɨ̀bhʉ-gʉ̀na, ɨnzá nyɨ rʉ́nɨ ma rɔ́.» Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àhʉ iri, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀dzɨ̀ ádrʉ̀ngbǎ ɨzʉ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kútsingánǎ nyʉ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà kɔ́rɔ́, nɨ́ɨrɨ ɨ̀ atdíkpá, ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ Yěsù kohò. ");
INSERT INTO niy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nɨ́ abádhí náabhʉ̀ ka kʉtsɨ̀, ’àdʉ̀ òwu àbhʉnà Pìlatɔ̀-fɔ́. Ndɨ Pìlatɔ̀ nɨ’ɨ̀ Pbàrɔ́má tɔ́ pbìrì ɔ̌ lɨ̀walɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudhà, yà Yěsù nípfo ndàbhʉ òmvǔ-fɔ́ alɛ, níitdègu kà-dɔ̌ ka kɔ̀tdɨ̀ anya ndɨ́nɨ̌ ka koho tɨ́ dhu nɨ́rɨ, nɨ́ kǎpɛ̀ ndɨ̀rɛ̀ nga yà ndɨ̀ ndɔ̀nzɨ̀ dhu dɔ̌, ɨzʉ ràdʉ̀ ndʉ̀ka atdídɔ̌. Nɨ́ kǐdyi yà ndɨ̀ ndàkɔ ɨ̀bhʉ kumì fʉ̀rangà-kpɔ̌, ndàrà àdunà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà fɔ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma máfǎ dhu nzɛ́rɛ nyʉ́, ɨ̀mbǎ afátá nà alɛ ma mípfo ɔvɛ tɔ̀ nɨ́dhunɨ̌.» Pbɛ́tʉ̀, abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Ɨnzá wɔ̀ dhu àndà mǎ. Ɔ̀tɛ̌nʉ nɨ́ ndɨ!» ");
INSERT INTO niy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nɨ́ Yudhà adʉ̀ wɔ̀ fʉ̀rangà nɨ́vɔ̀ Kàgàwà bhà ɨdzá, ndàdʉ̀ àhʉ, ndàrà ndʉ̀tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ nʉ́ʉwá wɔ̀ fʉ̀rangà-kpɔ̌, ’àdʉ̀ àtɨ̀nà: «Àlɛ̌ tɔ́ Ʉyátá návi nzá àlɛ̌ rʉ̀lɨ yàrɨ́ fʉ̀rangà pɛrɛ̀ tɨ́ ka kùbho Kàgàwà bhà ɨdzá fʉ̀rangà nʉ́lɨ̌ ka karɨ́ ɔ̀nà sàndukù ɔ̀. Obhó tɨ́, ndɨ fʉ̀rangà nɨ́ ìndrǔ-azù ka kòdzì rɔ̀ná fʉ̀rangà.» ");
INSERT INTO niy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Abádhí níitdègu ’ɨ̀rɨ ndɨ fʉ̀rangà dɔ̌, nɨ́ abádhí adʉ̀ òwu ɨ̀tǎ ɔ̀rʉ arɨ́ alɛ bhà ɨnga nódzì kà-rɔ̌, ndɨ́nɨ̌ ka kongó tɨ́ ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí nʉ́tdʉ ɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ndɨ ɨnga nánzi ka kárɨ́ indo màtɨ́ «azu tɔ́ ɨnga» tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndɨ dhu bhěyi nɨ́ ndɨ, yà Kàgàwà bhà nabì Yɛ̀rɛ̀mɨyà nʉ́ʉnɔ dhu náaká. Kǎtɨ: «Abádhí níidyi ɨ̀bhʉ kumì fʉ̀rangà-kpɔ̌ yà Pbàìsràyélí nɨ́ɨrɨ ɨ̀ dɔ̀ná ka ka kodzi tɨ́ rɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Abádhí adʉ̀ ndɨ fʉ̀rangà nídyì, ’àbhʉ ɨ̀tǎ nɔ́rʉ arɨ́ alɛ bhà ɨnga rɔ̌, yà Ádrʉ̀ngbǎlɛ Kàgàwà nʉ́ʉyá idù dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wɔ̀ dhu-dzidɔ̌, Yěsù níidè lɨ̀walɨ̀-ɔ̀nzɨ̌. Nɨ́ lɨ̀walɨ̀ níivú dhu kà-tsʉ̌ ndàtɨ: «Nyɨ tɨ́ Pbàyàhúdí tɔ́ Ádrʉ̀ngbǎ kamà?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨnyɨ nɨ́ ndɨ ka nyɨ nyʉ̀nɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tdɨ́tdɔ̌ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mànà náadʉ̀ kɔ̀bhʉ̀, pbɛ́tʉ̀ kǎdʉ̀ nzá atdí dhu mà nádu. ");
INSERT INTO niy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nɨ́rɔ̀ nɨ́ ndɨ Pìlatɔ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyɨ̀rɨ̀ tɨ́ nzá wɔ̀ kɔ́rɔ́ ka kʉ̀nɔ̀ dʉ̀nʉ́ dhu?» ");
INSERT INTO niy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pbɛ́tʉ̀, Yěsù adʉ̀ nzá atdí dhu mà nádu kà tɔ̀, ɨdhɔ ràdʉ̀ lɨ̀walɨ̀ nʉ́kɔ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bìlǐ, yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ náarɨ́rà dhu bhěyi, lɨ̀walɨ̀ bhà màndʉ nɨ’ɨ̀ ndɨ̀kɔ̀lɔ̀ atdí alɛ, yà ihé-yà nózè kɨkɔ̀lɔ̀ imbi ɔ̀ rɨ́’ɨ̀ alɛ nzínzì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nɨ́ ndɨ nɨ́nganɨ́, yà atdídɔ̌ ɔvɔ̀na ɔ́tɔ̀ ndɨ̀ Bàrabà tɨ́ kátɨna atdí alɛ, nɨ́ɨ’ɨ̀ imbi ɔ̀ ka kósò rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nɨ́ ihé-yà níitdègu ’àndǔ, nɨ́ Pìlatɔ̀ ivú dhu abádhí-tsʉ̌, ndàtɨ: «Ádhɨ nyɨ̌ nyòzè mɨkɔ̀lɔ̀ fʉ̌kʉ̀? Tɨ́ Yěsù Bàrabà? Ndɨrɔ̀ tɨ́ Yěsù, yà Krɨ́stɔ̀ tɨ́ kátɨna alɛ?» ");
INSERT INTO niy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pìlatɔ̀ nʉ́ʉnɨ dhu mběyi nyʉ́ abádhí rìwǔ kà nà fɔna ɔ̀ kǎdhà nɔ́nzɨ ɨ̀ ɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nɨ́ Pìlatɔ̀ àdɨ anya t’ɨ́tdɨ̀ta tɔ́ tombi dɔ̌ rɔ́rɔ̀, kà-ve níivi tǔna kà tɔ̀, ndàtɨ: «Nzǐtsǔ nyɨ wɔ̀ ɨ̀mbǎ rɨ́’ɨ̀ afátá nà alɛ bhà dhu ɔ̀. Obhó tɨ́, indo kúbhingá, ma màbà àpbɛ̀ abhɔ nyʉ́ ɔnyʉ-bvʉ̀ kǒkú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pbɛ́tʉ̀, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mànà níitsu dhu ihé-yà-dɔ ɔ̀, ndɨ́nɨ̌ Bàrabà nonzi tɨ́ kɨkɔ̀lɔ̀, kadʉ̀ Yěsù nóhò. ");
INSERT INTO niy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nɨ́ lɨ̀walɨ̀ náakɔ̀ ɔtɛ tdɨ́tdɔ̌, ndìvǔ dhu abádhí-tsʉ̌ ndàtɨ: «Ádhɨ ndɨ kǎkà ɔ́yɔ̌ alɛ nzínzì ɔ̌ nyɨ̌ nyòzè mɨkɔ̀lɔ̀ fʉ̌kʉ̀?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Bàrabà!» ");
INSERT INTO niy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nɨ́ lɨ̀walɨ̀ adʉ̀ dhu ìvu tdɨ́tdɔ̌ abádhí-tsʉ̌, ndàtɨ: «Olu, ádhu ndɨ Yěsù Krɨ́stɔ̀ tɨ́ ka kátɨna alɛ nɨ̌ ma mɔ́nzɨna?» Nɨ́ kɔ́rɔ́ alɛ náadʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nɨ́ Pìlatɔ̀ níivú dhu tdɨ́tdɔ̌ ndàtɨ: «Ádhu nyʉ́ ndɨ kǎfǎ?» Nɨ́rɔ̀ nɨ́ ndɨ abádhí adʉ̀ ɨ̀dʉ̀ àrǐ nyʉ́ tɨ́, ’àtɨ: «Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌ dhé!» ");
INSERT INTO niy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dhu ɔ̀nzɨ̀ lɛ̀màna dhu mà, ìndrǔ-tsì àva ndɨ̀ tɨ́ dhu mànà dhu ndɨ̀ ndàla rɔ̀, Pìlatɔ̀ níidyi ɨdha, ndù’o ɔtsʉ́na nɨ̌ ihé-yà-ɔ̀nzɨ̌ rɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ́: «Wɔ̀ alɛ-azù àbhʉ̌ ka kɨ́ rʉ̀fʉ̀ ndɨ̀ dhu ɔ̀ ma mɨ́ mbǎ ɨ̀’ɨ̀! Ɔ̀tɛ̌kʉ nɨ́ ndɨ.» ");
INSERT INTO niy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɨ́ kɔ́rɔ́ ihé-yà adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Kǎzù àkǎ ndàdɨ dɔ̀ka-tsírɔ́ fàká nzónzo mànà.» ");
INSERT INTO niy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nɨ́rɔ̀ nɨ́ ndɨ Pìlatɔ̀ adʉ̀ Bàrabà nɨ́kɔ̀lɔ̀ abádhí tɔ̀. Kǎdʉ̀ Yěsù àbhʉ kʉvɨ asé nɨ̌, ndàdʉ̀ àbhʉnà kowù ʉ̀tɔnà mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pìlatɔ̀ bhà pbànówí náawù Yěsù nà lɨ̀walɨ̀ bhà ádrʉ̀ngbǎ ɨdzá-yà-ba ɔ̀, kɔ́rɔ́ pbànówí tɔ́ pɨ̀kɔ̀ ràdʉ̀ ’àndu rɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nɨ́ abádhí nʉ́ʉwa kà-rɔ̌ mʉ̀dzarʉ̀, ’àdʉ̀ òlǒlù kanzʉ̀ náfɔ kà-rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tdɨ́tdɔ̌ abádhí akpɔrɔ okpèna nà itsukpó-nzo tɔ́ mʉ̀kàkʉ́, ’àdʉ̀ àfɔnà kà-dɔ rɔ̌. Abádhí adʉ̀ ízò nábhʉ kà ràlʉ̌ fangà tɔ́ ɔtsʉ́na nɨ̌. Wɔ̀ dhu-dzidɔ̌, abádhí nóowúnà ’ʉ̀kɔ rɔ̌ ɔtdyʉ̀ya dɔ̌ kɔ̀nzɨ̌, ’àdʉ̀ òwu kɨ̀wa rɔ̌, ’ɔ̀pbɨ̀ sàlutì fɨ̌ndà, ’àdʉ̀ àtɨ̀nà kànɨ̌: «Yǎmbʉ̀ Pbàyàhúdí tɔ́ Ádrʉ̀ngbǎ kamà!» ");
INSERT INTO niy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Abádhí nóowúnà ɨsɔ núso rɔ̌ kà-dɔ̀, ’àdʉ̀ òwu ízò nɨ́dha rɔ̌ kà-fɔ́ rɔ̀, ’ʉ̀tɨ̀ kà-dɔ̀tsirɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wɔ̀ dhu bhěyi ɨ̀ àvu kà-rɔ̌ dhu-dzidɔ̌, abádhí nɨ́ɨwa òlǒlù kanzʉ̀ kà-rɔ̌ rɔ̀, ’àdʉ̀ kà-rɔ̌ mʉ̀dzarʉ̀ nyʉ́ nʉ́fɔ kà-rɔ̌ tdɨ́tdɔ̌. Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ òwu kà nà, ’òwu ʉ̀tɔnà mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀ ɨ̀ úvò rɔ́rɔ̀, abádhí náatù ɨ̀ Kùrenì tɔ́ kɨgɔ̀ ɔ̌ atdí alɛ nà. Ndɨ alɛ-ɔvɔ̀ nɨ’ɨ̀ Sìmonì. Nɨ́ pbànówí adʉ̀ kʉ̀tʉ rànɔ̀ Yěsù bhà mʉ̀sàlabhà. ");
INSERT INTO niy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nɨ́ abádhí awù ùvò atdí ngari Gɔ̀lɔ̀gɔtà tɨ́ kátɨna ɔ̀. Gɔ̀lɔ̀gɔtà-tɨ̀ nɨ́ alɛ dɔ̀-kpa tɔ́ ngari. ");
INSERT INTO niy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ányɨ̀ abádhí náabhʉ̀ tdyɔkpɔ́ nà ka kàngbǒ dɨ̀vayì ndɨ́nɨ̌ Yěsù ɔmvʉ́ tɨ́. Nɨ́ ka ndɨ̀ ndìnè rɔ̀, Yěsù adʉ̀ nzá kòzè ndɔ̀mvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wɔ̀ dhu-dzidɔ̌, abádhí nʉ́ʉtɔ́ ka mʉ̀sàlabhà dɔ̌, ’àdʉ̀ kà-rɔ̌ mʉ̀dzarʉ̀ nʉ́ndɔ̀ fɔyá ngàlà ɔ̌ ɨ̀ ɔ̀vɨ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ òko obvò, ’àmbɛ kà-ngbɔ̀ nɔ́dɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kà-dɔ̀nǎ, abádhí apbá àndǐ ka kàndǐ dhu dɔ̀ná bháwʉ̌-ngba. Ɨ andítá nɨ’ɨ̀ kà-ànyǎ ka kɔ̀tdɨ̀ ndɨ́nɨ̌ ka koho tɨ́ okúna dɔ̀ rɔ̀ afátá nɨ́tɛ̀ rɨ́. Ndɨ andítá nɨ’ɨ̀: «Yàrɨ́ nɨ́ Yěsù, Pbàyàhúdí tɔ́ Ádrʉ̀ngbǎ kamà.» ");
INSERT INTO niy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ndɨrɔ̀ ka kʉtɔ́ ɔ́yɔ̌ ogbotálɛ mʉ̀sàlabhà dɔ̌ kà mànà, atdí alɛ kà tɔ́ fangà dɔ̀nǎ rɔ̀, ndɨrɔ̀ ngǎtsi alɛ kàbhà ígù dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ányɨ̀rɔ̌ rʉ́da alɛ nóowúnà dhu nʉ́nɔ̀ rɔ̌ kà nɨ̌, ’àdʉ̀ òwu dɔ̀ya nóbhì rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Abádhí owúnà àtɨ̀nà rɔ̌ ka nɨ̌: «Ɨnyɨ, yà Kàgàwà bhà ɨdza nyɨ nyátsǔ nyugolo, nyadʉ̀ ɔ̀sɨ̀nà ɨ̀bhʉ ɨdhɔ ɔ̌ rɔ̀, ɨ́gʉ̌ pɛ́ nyɨ nyɨ-tɨ́rɔ̀! Nyɨ nyapɛ́ ɨ̀’ɨ̀ Kàgàwà t’ídhùnà nyʉ́ tɨ́, nɨ́ ífo pɛ́ mʉ̀sàlabhà dɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà nʉ́ʉgbɔ́ ka ndɨ dhu bhěyi tɨ́, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Kɨ̌gʉ̌ ngʉ̌kpà alɛ, pbɛ́tʉ̀ kà rɨ̌ nzɨ̌ àdʉ̀ ndɨ̀gʉ ndɨ̀tɨ́rɔ̀! Ka ná tɨ́ Pbàìsràyélí tɔ́ Ádrʉ̀ngbǎ kamà? Kìfo pɛ́ kombí mʉ̀sàlabhà dɔ̌ rɔ̀, ndɨrɔ̀ nɨ́ ndɨ mǎ madʉ̀na kà’ù. ");
INSERT INTO niy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kǎ’u Kàgàwà, ndɨrɔ̀ kǎtɨ: ‹Ɨma nɨ́ Kàgàwà t’ídhùnà.› Nɨ́ kàndà pɛ́ Kàgàwà rɨ̌ kɨ̀gʉ̌ kombí dhu.» ");
INSERT INTO niy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndɨrɔ̀ kɔ̌kɔ̀ kà-tɨ́ ka kʉ̀tɔ̌nà mʉ̀sàlabhà dɔ̌ ogbotálɛ nʉ́ʉnɔ dhu kà nɨ̌ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rɔ̀pɛ̀ ndɨ̀ azà adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌ rɔ̀, ràrà àhʉ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ adyídɔ̌ nga tɔ́ ɔ̀, ɨ́nɔ̌-yà níibvú ndɨ̀ kɔ́rɔ́ ndɨ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nɨ́ mbɛ̀mbɛ̀ ndɨ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ ɔ̌, Yěsù náakù ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Èloyì, Èloyì, lamà sàbàkàtanɨ̀?» Kà-tɨ̀ nɨ́: «Pbàkà Kàgàwà, pbàkà Kàgàwǎ, ádhu nyɨ nyʉ̀bhà ma nɨ́?» ");
INSERT INTO niy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngúfe alɛ kɔ̌kɔ̀ ányɨ̀ rɔ̌ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌ nɨ́ɨrɨ wɔ̀ dhu, ’àdʉ̀ àtɨ̀nà: «Kà rɨ̌ Ɛ̀lɨyà nánzi.» ");
INSERT INTO niy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɨ́ abádhí nzínzì ɔ̌ atdí alɛ náakʉ̀, ndìdyì sìfɔngɔ̀, ndàfɔ̌ ògyǒgyè dɨ̀vayì ɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ kɨ̀wà ndɔ̀tʉ̀ ízò-tsʉ̀ dɔ̌, ndàdʉ̀ àvanà Yěsù-tsʉ̌ ndɨ́nɨ̌ kǎndʉ́ tɨ́ ɔ̀nà rɨ́’ɨ̀ dɨ̀vayì. ");
INSERT INTO niy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pbɛ́tʉ̀, ngʉ̌kpà alɛ àdʉ̀ àtɨ̀nà: «Kàndà pɛ́ Ɛ̀lɨyà rɨ̌rà kɨ̀gʉ dhu.» ");
INSERT INTO niy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yěsù adʉ̀ òkù tdɨ́tdɔ̌ àrǐ nyʉ́ tɨ́, afína ràdʉ̀ ɨ̀tdɛ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Kàgàwà bhà ɨdzá ka kúsò mbɛrʉ̀ náadù ndɨ̀fa, ɔ̀nánga rùtù ndɨ̀ ɔyɔ, rɔ̀pɛ̀ ndɨ̀ ɔrʉ̀ rɔ̀, ràrà àhʉ obvò. Mùtìtì náabhʉ̀ adzɨ rìvi, bhalabhala tɔ́ odu ràdʉ̀ ’ʉ̀fa. ");
INSERT INTO niy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ndɨrɔ̀, ìndrǔ ka kʉtdʉ́ ɔ̀yà ibhu-li’ɔ̀ náadʉ̀ ’ʉ̀ngbɛ. Nɨ́ yà Kàgàwà bhà alɛ tɨ́ ɨ̀ arɨ́’ɨ̀ rɔ́rɔ̀ ʉvɛ̀ alɛ náadʉ̀ ’ʉ̀ngbɛ. ");
INSERT INTO niy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Abádhí núuvò ibhu ɔ̀ rɔ̀. Nɨ́ Yěsù ɨ̀ngbɛ̀ ndɨ̀ dhu-dzidɔ̌, abádhí àdʉ̀ òtsù Yèrùsàlɛmà ɨ̀lɨ̌lǎ kɨgɔ̀ ɔ̀ ábhɔ̌ alɛ nyʉ́ ràdʉ̀ ɨ̀ àla ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pbàrɔ́má tɔ́ pbìrì ɔ̌ atdí mɨyà pbànówí dɔ̌ ádrʉ̀ngbǎlɛ mà, yà Yěsù-ngbɔ̀ nɔ́dɔ̀ rɔ̌ ùbhinà pbànówí mànà, náala mùtìtì nábhʉ adzɨ ràmbɛ ìvi dɔ̌ dhu, kɔ́rɔ́ ndɨ̀ nɔ̀nzɨ̀ dhu mànà. Nɨ́ ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ abádhí ɔ̀, abádhí ràdʉ̀ àtɨ̀nà: «Obhó nyʉ́, yàrɨ́ alɛ nɨ’ɨ̀ Kàgàwà t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ábhɔ̌ vèbhálɛ nɨ́ɨ’ɨ̀ ányɨ̀ rɔ̀ ’àmbɛ ’ɔ̀nzɨ rɨ́ dhu àndà dɔ̌ ɨtsɛ rɔ̀. Ɨ vèbhálɛ nɨ’ɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀ íwǔ Yěsù-owù ɔ̌, ’òwù kà-kàsʉ̌ nɔ́nzɨ̀ rɔ̌ vèbhálɛ. ");
INSERT INTO niy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Abádhí nzínzì ɔ̌ ɨ’ɨ̀ nɨ́: Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà mà, Màrɨyà, Yàkɔbhɔ̀ mà Yɔ̀zɛfʉ̀ mànà tsánà, ndɨrɔ̀ Zɛ̀bɛ̀dayò bhà inzo tsánà mànà. ");
INSERT INTO niy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pbɨ́tsɔ̀ngǎnǎ, atdí ònzǒnzì alɛ nɨ́ɨra àhʉ Pìlatɔ̀ bhà. Ndɨ alɛ nɨ’ɨ̀ Àrìmàtayò tɨ́ kátɨna kɨgɔ̀ ɔ̌ alɛ, ndɨrɔ̀ kɔ̌vɔ̀ nɨ’ɨ̀ Yɔ̀zɛfʉ̀. Ka nɨ’ɨ̀ Yěsù bhà ábhàlɨ̌ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nɨ́ kǎrà Pìlatɔ̀-tɨ’ɔ̀, ndàdʉ̀ Yěsù-abvò nónzì. Nɨ́ Pìlatɔ̀ àdʉ̀ ndɨ abvo návi kabhʉ kà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nɨ́ Yɔ̀zɛfʉ̀ adʉ̀ ndɨ abvo nídyì, ndàkpɔ̀rɔ̀ ngbɔ̌na yà abvo ɔ̀tdʉ̀ ka karɨ́ ɔ̀ná mbɛrʉ̀-ɔwʉ́tá nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kǎdʉ̀ àrà kɔ̀tdʉ̀ yà ndɨ̀ nyʉ́ ka kɔtdʉ́ya tɨ́ ɔ̀ná ndɨ̀ ndabhʉ̀ kogyè bhalabhala ɔ̀ ibhu ɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ádrʉ̀ngbǎ odu-ɨ́yà-ba nɨ́gɛ̀rɛ̀ ndàpbǐ ndɨ ibhu-li’ɔ̀ nɨ̌, ndàdʉ̀ àrà. ");
INSERT INTO niy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà mà, ngǎtsi Màrɨyà mànà náadʉ̀ òko ányɨ̀rɔ̌, ibhu-tsʉ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tsútsǎ nɨ́nganɨ́, sàbatʉ̀-ɨdhɔ̀ tɔ̀ ìndrǔ ɔ́bhɔ̀lɔ̀ná ɨ̀ ɔ̀ná ɨdhɔ dzidɔ̌ ùbho ɨnga ɔ̌, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà náawù atdíkpá Pìlatɔ̀ bhà. ");
INSERT INTO niy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Abádhí adʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, wɔ̀ tɨ̀tɔ̀-ba nʉ́ʉnɔ ɨnzá ndɨ̀ ndàpɛ̀ ɔ̀vɛ̀ rɔ́rɔ̀ dhu nísè wà ɔ̀ká. Kǎtɨ, ɨ̀bhʉ ɨdhɔ dzidɔ̌ ndɨ̀ rɨngbɛ̀ya ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, dhu àkǎ nyavi kɔdɔ̀ wɔ̀ adzɨdɔ-ngbɔ̀ ràrà àhʉ ɨ̀bhʉ ɨdhɔ ɔ̀. Obhó tɨ́, kàbhà ábhàlɨ̌ rǎdʉ̀ ìwu kǎ-bvò nówè, ’òwù nà, ’àdʉ̀ àtɨ̀nà ìndrǔ nɨ̌ ɨwà kà rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ wɔ̀ ndɨ tɨ̀tɔ̀ nádʉ̀ ɨ̀’ɨ̀ nzɛ́rɛ nyʉ́, ròsè yà angyi ɨ’ɨ̀ dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nɨ́ Pìlatɔ̀ adʉ̀ àtɨ̀nà abádhí nɨ̌: «Kànɨ̌ pbànówí sàndǐrì tɨ́ oko tɨ́. Nɨ́ nyòwu, nyǎdʉ̀ ndɨ adzɨdɔ-ngbɔ̀ nábhʉ kɔdɔ̀ mběyi yà nyɨ̌ nyòzè ka dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nɨ́ abádhí awù, ’àdʉ̀ ize nɨ́lɨ ibhu-tsʉ̀ ka kàpbǐ nɨ̌ odu rɔ̌, ’àdʉ̀ pbànówí nʉ́lɨ ràmbɛ ndɨ adzɨdɔ-ngbɔ̀ nɔ́dɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tsútsǎ nɨ́nganɨ́, sàbatʉ̀-ɨdhɔ̀ dzidɔ̌ rùbho ɨnga ɔ̌, Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà mà, ngǎtsi Màrɨyà mànà náawù màmbì ɔ̌ Yěsù ka kɔ̀tdʉ̀ rɔ́nga nándà. ");
INSERT INTO niy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nɨ́ ʉrɔ́ rɔ̀ tɨ́, ádrʉ̀ngbǎ mùtìtì nɨ́ɨsɨ́, Kàgàwà bhà màlàyikà ràdʉ̀ ìfo ɔ̀rʉ̀-akpà ɔ̀ rɔ̀. Kǎdʉ̀ odu nɔ́gɛ̀rɛ̀ igi, ndàdʉ̀ àdɨ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kɨ̌lɨ ndɨ̀ ɔvɔ námbɨlɨ dhu tɔ́ awáwʉ̀ bhěyi, kà-rɔ̌ mʉ̀dzarʉ̀ ràdʉ̀ ɔ̀wʉ tdyé, mbɨ̀lɨ̀kàkù bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nɨ́ ádrʉ̀ngbǎ ɔdɔ nɨ́ɨsɨ́ yà ibhu-ngbɔ̀ ɔ̀dɔ̀ rɔ̌ rúbhi sàndǐrì ɔ̀. Abádhí adʉ̀ ’ɔ̀pɛ̀ ’àmbɛ ìvi dɔ̌, ndɨrɔ̀ ’àdʉ̀ ’àwà obvò ɨwà ʉ̀vɛ alɛ bhěyi. ");
INSERT INTO niy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nɨ́ màlàyikà náapɛ̀ ɔtɛ, ndàtɨ vèbhálɛ nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ. Ma mʉ̀nɨ wà dhu nyɨ̌ nyɔ́mɛna alɛ ràrɨ̌ Yěsù, yà mʉ̀sàlabhà dɔ̌ ka kʉ́tɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kà rɨ̌ mbǎ ɨ̀’ɨ̀ ɨrɔ́, kɨ̀ngbɛ̀ wà ndɨ̀ yà ndɨ ndʉnɔ dhu bhěyi. Nyìwǔ nyàndà pɛ́ kǎ-bvò ka kɨ́lɨ ràyi rɔ́nga. ");
INSERT INTO niy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨ́ nyòwu nyʉ̀nɔ dhu tsàkàtsàkà kàbhà ábhàlɨ̌ tɔ̀ nyǎtɨ, ka rɨ̀ngbɛ̀ wà ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀, ndɨrɔ̀ kà ràrɨ̌ àrà nyɔ̌dɔ̀ kòmbí Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀. Ányɨ̀ nga ràrɨ̌ ndɨ nyɨ̌ nyɨ́ ndàlǎ nɨ̌. Kɔ̀nɨ̌ ma mɨ̀’ɨ̀ nà fʉ̌kʉ̀ ma mʉnɔ tɨ́ dhu nɨ́ wɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nɨ́ abádhí nɨ́ɨvà ɨ̀, ’òwù tsàkàtsàkà ibhu-tsʉ̀nǎ rɔ̀, ùlè tɨ́ ɨ̀ ùlè ɔdɔ mà, ábhɔ̌ dhɛ̀dhɛ mànà nɨ̌ rɔ́rɔ̀. Ndɨrɔ̀ abádhí adʉ̀ òtse ’òwù màkʉ̌rʉ̀ nà Yěsù bhà ábhàlɨ̌ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Yěsù ɨra, ndɨ̀rà ndùsò abádhí mànà, ndàdʉ̀ abádhí nátsɛ̀, ndàtɨ: «Yǎmbʉ̀.» Abádhí adʉ̀ ìndri kà-tɨ’ɔ̀, ’ʉ̀lʉ̌ ɨ̀ kà-pfɔ̀ rɔ̌, ’àdʉ̀ kɨ̀fʉ. ");
INSERT INTO niy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ. Nyòwu nyʉ̀nɔ dhu adɔ́du tɔ̀, ròwù Gàlìlayà tɔ́ pbìrì ɔ̀. Ányɨ̀ nga nɨ́ ndɨ, abádhí rɨ̌ malǎ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Otu ɔ̌ kɔ̌kɔ̀ vèbhálɛ rɨ̌’ɨ̀ rɔ́rɔ̀, yà Yěsù adzɨ̀dɔ-ngbɔ̀ nɔ́dɔ̀ rɔ̌ rúbhi pbànówí nzínzì ɔ̌ ngúfe alɛ náadù ɨ̀ Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀. Abádhí náawù kɔ̌kɔ̀ kɔ́rɔ́ ɨ̀ nɔ̀nzɨ̀ dhu náwɛ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nɨ́ ɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà núundu ɨ̀, ’àdʉ̀ ’ɨ̀rɨ̀ ndɨ́nɨ̌ ɨ̀ ubhò tɨ́ ábhɔ̌ fʉ̀rangà nyʉ́ pbànówí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Abádhí adʉ̀ dhu ʉ̀ya ɨ pbànówí tɔ̀ ’àtɨ: «Nyɨ̌ nyowuna dhu ɔ̀vɔ̀ rɔ̌ kpangba nyǎtɨ, kàbhà ábhàlɨ̌ rìwǔ kǎ-bvò nówè kúbhingá ɔ̀dhɔ̀ nyɨ̌ nyɔ̀dhɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ndɨrɔ̀ lɨ̀walɨ̀ nɨ́ɨrɨna gukyè ndɨ dhu, nɨ́ mǎ mʉ̀nɨ wà mǎ mɨ́ kà-afí nábhʉ̌ rʉ̀kɔ̀ ndɨ̀ tɨ́ dhu, ndɨrɔ̀ mǎdʉ̀ nyɨ̌gʉ ɨ̀nzɨ̌ nyǎbá tɨ́ àpbɛ̀!» ");
INSERT INTO niy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nɨ́ kɔ̌kɔ̀ Sàndǐrì náakɔ̀ fʉ̀rangà, ’àdʉ̀ wɔ̀ fɨ̌yɔ̀ ka kʉ̀yǎ dhu kɛ̀lɛ̌ nɔ́nzɨ̀. Nɨ́ ndɨ màkʉ̌rʉ̀ náadʉ̀ ndʉ̀gà Pbàyàhúdí nzínzì ɔ̌, rɨ̀rà àhʉ indo màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yěsù bhà atdí kumì dɔ̀ná atdí nà ábhàlɨ̌ náawù Gàlìlayà yà kɨ̀tɛ̀nà fɨ̌yɔ̀ pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nɨ́ ábhàlɨ̌ níitdègu Yěsù nálǎ, nɨ́ abádhí nɨ́ɨfʉ ka. Pbɛ́tʉ̀, dhèdhè abádhí nzínzì ɔ̌ alɛ náa’u nzá dhu Yěsù nyʉ́ ràrɨ̌ ndɨ. ");
INSERT INTO niy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nɨ́ Yěsù adʉ̀ ìndri abádhí-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Kàgàwà níibho wà kɔ́rɔ́ ádrʉ̀ngbǎnga fudú ɔ̀rʉ̀-akpà ɔ̀ dhu-tsí dɔ̌, ndɨrɔ̀ yà adzɨ ɔ̌ dhu-tsí dɔ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɨ́rɔ̀, nyòwu kɔ́rɔ́ pbìrì ɔ̌ alɛ-bvʉ̀, nyǎdʉ̀ abádhí nábhʉ rʉ̀gɛ̀rɛ̀ ɨ̀, ’òngò pbàkà ábhàlɨ̌ tɨ́. Ndɨrɔ̀, nyùbho bàtizò abádhí tɔ̀, Àba Kàgàwà-ɔvɔ̀ rɔ̀, ka t’ídhùnà-ɔvɔ̀ rɔ̀, ndɨrɔ̀ Ɨ̀lɨ̌lǎ-Alafí-ɔvɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ndɨrɔ̀, nyùdhe dhu abádhí tɔ̀ rɨ̀fʉ yà kɔ́rɔ́ ma mʉyá fʉ̌kʉ̀ dhu. Ndɨrɔ̀, nyʉ̀nɨ dhu ma ràrɨ̌ ìnè atdíkpá nyɨ̌ mànà, ràrà àhʉ kɔ́rɔ́ yà adzɨ ɔ̌ dhu-tsʉ̀ náaraya ndɔ̀dɨ̀ ɔ̀ná ɨdhɔ ɔ̀.»");
INSERT INTO niy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yàrɨ́ nɨ́ Yěsù Krɨ́stɔ̀, Kàgàwà t’ídhùnà dɔ̌ rɔ́tɛ Ídzì Màkʉ̌rʉ̀ náapɛ̀ ndɨ̀ tɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Àdhàdhɨ̀ nabì Ìsayà náandí dhu pbɨ̀ndà bhǔkù ɔ̀ dhu bhěyi, ndàtɨ: «Kàgàwà rǎtɨna: ‹Ma mɨ́ pbàkà mʉ̀kɛ̀ngyɛ̀ nóvì angyi ɨndʉ̀. Kà rɨ̌ otu nɔ́wɛ̀ ɨndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndɨ mʉ̀kɛ̀ngyɛ̀ rɨ̌ dhu ɔ̀vɔ ɔrʉ́ tǔna nyʉ́ nà rʉ̀ngʉ̀ ɔ̀, ndàtɨ: ‹Nyɔ̀bhɔlɔ ngʉdhà Ádrʉ̀ngbǎlɛ tɔ̀, nyùtǒ kà rǔbhi ɔ̀ná otu!›» ");
INSERT INTO niy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nɨ́ Yùwanɨ̀ nɨ́ɨtɔ ndɨ̀ rʉ̀ngʉ̀ ɔ̀, ndàmbɛ bàtizò núbho dɔ̌ ìndrǔ tɔ̀, ndàdʉ̀ àrà dhu nɔ́vɔ rɔ̌ abádhí tɔ̀ ndàtɨ: «Nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga, nyǎdʉ̀ bàtizò nálʉ, ndɨ́nɨ̌ Kàgàwà adʉ̀ tɨ́ fʉ̀kʉ́ nzɛ́rɛnga nʉ́bà fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yùdɛyà tɔ́ pbìrì ɔ̌ ábhɔ̌ alɛ nyʉ́, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ alɛ mànà níiwúnà kɔ́rɔ́ kà tɨ’ɔ̀. Abádhí nʉ́ʉnɔ́nà fɨ̀yɔ́ nzɛ́rɛnga kpangba, Yùwanɨ̀ ràdʉ̀ bàtizò núbho fɨ̌yɔ̀ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yùwanɨ̀ náafɔ́nà ngàmɨyà tɨ́ kátɨna ɨ̀zǎ-ká nɨ̌ ka kódyù mʉ̀dzarʉ̀, ndàdʉ̀ mvʉna’ɔ̀ níso asé tɔ́ kùkyě nɨ̌. Kǒngúnà ndɨ̀ índù mà nɨ̌, ɨrɨ́ ɔ̌ ɨtɨ-dha mànà. ");
INSERT INTO niy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kǎránà dhu nʉ́nɔ̀ rɔ̌ ihé-yà tɔ̀ ndàtɨ: «Olù rɨ́rà dzidu dɔ̌ alɛ rɨ̌’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà atdídɔ̌ ròsè dùdunǎ. Ma màkǎ nzá mɔkɔ̀ ma mʉnga kàpfɔ̀ rɔ̌ kàyìtò-mbǐ mà. ");
INSERT INTO niy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨma, ma marɨ́ bàtizò núbhǒ fʉ̌kʉ̀ ɨdha nɨ̌. Pbɛ́tʉ̀, àbadhi náaraya bàtizò núbho rɔ̌ fʉ̌kʉ̀ Ɨ̀lɨ̌lǎ-Alafí nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yùwanɨ̀ arɨ́ bàtizò ùbhǒ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù nɨ́ɨra Gàlìlayà tɔ́ pbìrì ɔ̌ atdí kɨgɔ̀, Nàzàretì tɨ́ kátɨna ɔ̀ rɔ̀, ndɨ̀rà àhʉ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà ɔ̀, Yùwanɨ̀ ràdʉ̀ bàtizò nábhʉ fɨ̌ndà. ");
INSERT INTO niy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɨ́ ɨdha ɔ̀ rɔ̀ Yěsù rǎhʉ rɔ̀, kǎla ɔ̀rʉ̀-akpà-li’ɔ̀ ndɨ̀kpa rɨ́ rɔ́, Ɨ̀lɨ̌lǎ-Alafí ràdʉ̀ ìfo ɔ̀ná kà-dɔ̌ àmbò tɔ́ ɔ́fɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndɨrɔ̀, kɨ̌rɨ atdí alɛ-tù ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɔ́tɛ rɔ́, ndàtɨ: «Ɨnyɨ nɨ́ Idhùdu, yà atdídɔ̌ ma mózè alɛ, ɨdhɛ̀du náarɨ́ ndɨ̀kǎ okúnʉ dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, Ɨ̀lɨ̌lǎ-Alafí nʉ́ʉtʉ Yěsù ràrà rʉ̀ngʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nɨ́ kǎnzɨ̀ ɨ̀fɔ kumì ɨdhɔ ányɨ̀, Sìtanɨ̀ ràdʉ̀ àmbɛ kà-afí númvu dɔ̌. Kǎdɨ̀ ɨrɨ́ ɔ̌ ɨ̀zǎ náaróko ɔ̀ná ngari ɔ̀, màlàyíká ràdʉ̀ àmbɛ dzʉ̀nàna nɔ́nzɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yùwanɨ̀ ka kósò imbi ɔ̀ dhu-dzidɔ̌, Yěsù náarà Gàlìlayà tɔ́ pbìrì ɔ̀, ndàmbɛ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ dɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kǎránà àtɨ̀nà rɔ̌: «Kàsʉmɨ̀ nákǎ wà. Ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi-tsʉ̀ níndù wà ndɨ̀. Nɨ́, nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga, ndɨrɔ̀ nyà’u Ídzì Màkʉ̌rʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̌ ndɨ̀ ndúbhi rɔ́rɔ̀, Yěsù náala ɔ́yɔ̌ àwěrù, Sìmonì mà adɔ̀nà Àndɛ̀rɛyà nà, ɨ̀bhɛ̀ nóho rɨ́ imbi nɨ̌ rɛ̀rʉ̀ ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nɨ́ Yěsù náatɨ abádhí nɨ̌: «Nyìwǔ owùdu ɔ̌, ma mɨ́ nyʉ̌gɛ̀rɛ̀ nyǒngò ìndrǔ tɔ́ àwěrù tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nɨ́ ʉrɔ́ rɔ̀ tɨ́, abádhí nʉ́ʉbhà fɨ̀yɔ́ ɨ̀bhɛ̀-mbǐ, ’àdʉ̀ òwu kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tdɨ́tdɔ̌, Yěsù náandrì ɨtsɛta akɛ, ndàdʉ̀ Zɛ̀bɛ̀dayò bhà inzo, Yàkɔbhɔ̀ mà Yùwanɨ̀ nà nála. Abádhí nɨ́ɨ’ɨ̀ fɨ̌yɔ́ ibhú ɔ̀, fɨ̀yɔ́ ɨ̀bhɛ̀-mbǐ nɔ́bhɔlɔ ɨ̀’ɨ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, Yěsù náanzi abádhí. Nɨ́, abádhí adʉ̀ àbayà Zɛ̀bɛ̀dayò nʉ́bhà ibhú ɔ̀ kasʉtálɛ mànà, ’àdʉ̀ òwu Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Kàpɛ̀rnàwumù tɨ́ kátɨna kɨgɔ̀ ɔ̀. Nɨ́, Pbàyàhúdí tɔ́ asota-dhɔ̀ ɔ̌, Yěsù náatsù unduta-dzà ɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ányɨ̀-dzá ɨ̀’ɨ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nɨ́ Yěsù rʉ̌nɔna dhu nɨ́rɨ rɨ́ alɛ ɨdhɔ nʉ́ʉkɔ atdídɔ̌, kàrɨ̌ dhu núdhě tɨ́ dhu dɔ̌. Obhó tɨ́, kàbhà dhu t’údheta nɨ́ɨ’ɨ̀ mbǎ Músà bhà Ʉyátá tɔ́ màlímó tɔ́ dhu t’údheta bhěyi. Ndɨrɔ̀, kǎmbɛ́nà dhu núdhe dɔ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɨ́ wɔ̀ kàrɨ̌ dhu núdhě ɔ̀ná kàsʉmɨ̀ ɔ̌ tɨ́, nzɛ́rɛ-alafí nà arɨ́’ɨ̀ atdí alɛ náatsù ndɨ unduta-dzà ɔ̀, ndàdʉ̀ òkù ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ádhu nyɨ nyòzè mǎ nà Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ́? Nyɨ nyɨ̀rà tɨ́ tsěka nyɨ nyɔtdɨ́ tɨ́? Ma mʉ̀nɨ wà dhu mběyi nyʉ́ nyɨ ràrɨ̌ àdhɨ. Nyɨ nɨ́ Kàgàwà ívì Ɨ̀lɨ̌lǎ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nɨ́ Yěsù náarʉ̀ wɔ̀ alɛ ɔ̀ rɨ́’ɨ̀ nzɛ́rɛ-alafí dɔ̌, ndàtɨ: «Ɨ́nɛ̀, áhʉ̌ wɔ̀ alɛ ɔ̀ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nɨ́ wɔ̀ ndɨ nzɛ́rɛ-alafí nɨ́ɨyà wɔ̀ alɛ-ɔ̌nga ɔbɨ nyʉ́ nà, ndàdʉ̀ àhʉ kà ɔ̀ rɔ̀ ádrʉ̀ngbǎ ìkǔ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kɔ́rɔ́ alɛ ɨdhɔ nʉ́ʉkɔ, ràmbɛ dhu nɔ́ngʉ̀ dɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ɨ́ngbà dhu-tɨdɔ̀ wɔ̀? Màkʉ̌rʉ̀-ɔwʉ́tá nyʉ́ nɨ́ yà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nyʉ́ nà ka kʉ̀nɔ̀! Yàrɨ́ alɛ rɨ̌ dhu nʉ́yǎ nzɛ́rɛ-alafí tɔ̀ màtɨ́, ràdʉ̀ tsʉ̀ná dhu nɨ́rɨ̀!» ");
INSERT INTO niy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɨ́ Yěsù rɔ̌nzɨna dhu-ɔ̀yɨ̌ nʉ́ʉgà ndɨ̀ kòmbómbí kɔ́rɔ́ Gàlìlayà tɔ́ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Unduta-dzà ɔ̀ rɔ̀ ɨ̀ ’ùvò dhu-dzidɔ̌, Yěsù mà náadʉ̀ òwu ʉrɔ́ rɔ̀ tɨ́ Sìmonì mà Àndɛ̀rɛyà nà mà t’ɨ́dza. Abádhí awù atdíkpá Yàkɔbhɔ̀ mà Yùwanɨ̀ mànà nà. ");
INSERT INTO niy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nɨ́ ányɨ̀-dzá, Sìmonì bhà agʉna-àyi nɨ́ɨ’ɨ̀ ara dɔ̀ ndɨ̀ ndàyi rɔ́, atdídɔ̌ kàzʉ ʉ̀tɔ̀ ndɨ̀ ɔ̀na nǎ nɨ́dhunɨ̌. Nɨ́, yà Yěsù ɨ̀rà àhʉ rɔ́rɔ̀ tɨ́, ka kavɔ̀ ɨ́yàdhíyà rǎndɨ dhu kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nɨ́ Yěsù náandrì kà ɨ, ndàlʉ̌ kɔ̌tsʉ́, ndàdʉ̀ kɨ̀và ɔrʉ̀. Nɨ́ kà-ɔ̌ ɨ̀’ɨ̀ kàzʉ náavɛ̀, kà ràdʉ̀ àdɨ ndàmbɛ ɔ̀nyʉ̀ ùbho dɔ̌ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pbɨ́tsɔ̀ngǎ, adyifɔ̀ nótsù dhu-dzidɔ̌, ka kowúnà ìwu rɔ̌ andɨ nà arɨ́’ɨ̀ kɔ́rɔ́ alɛ nà Yěsù tɨ’ɔ̀, nzɛ́rɛ-alafí nà arɨ́’ɨ̀ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nɨ́, kɨgɔ̀ ɔ̌ alɛ núundu ɨ̀ kɔ́rɔ́ Yěsù rɨ̌’ɨ̀ ɔ̀nà ɨdza-lí. ");
INSERT INTO niy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nɨ́ Yěsù nɨ́ɨgʉ́ dhèdhèrɔ̀ andɨ-tɨdɔ̀ nɨ̌ arándɨ ábhɔ̌ alɛ nyʉ́. Kǎránà nzɛ́rɛ-alafí nípfo rɔ̌ átɔ̀ ábhɔ̌ alɛ ɔ̀ rɔ̀. Ndɨrɔ̀, kǎránà nzɨ̌ ɨ nzɛ́rɛ-alafí nʉ́bhà rɔ̌ rɔ̀tɛ̀, ɨwà abádhí nʉ́nɨ Yěsù ràrɨ̌ àdhɨ dhu nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tsútsǎ nɨ́nganɨ́ bhɔ̌tsʉngá, ɨnzá ɨnga nápɛ̀ àwʉ̀ rɔ́rɔ̀, Yěsù nɨ́ɨvà ndɨ̀ ndàhʉ kɨgɔ̀ ɔ̀ rɔ̀, ndàrà igi rʉ̀ngʉ̀ ɔ̀ ndàdʉ̀ ndɔ̀pɛ̀ ndɨ̀tsɔ̀ ndɨ̀ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nɨ́, Sìmonì mà ɔdhɨ́na mànà náawù kɔ̀mɛ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nɨ́ Yěsù ɨ̀ àla rɔ̀, abádhí náatɨ kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, kɔ́rɔ́ alɛ rɨ̌ nyɔmɛ.» ");
INSERT INTO niy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pbɛ́tʉ̀ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Kòwu kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ ngʉ̌kpà pbanga ɔ̀. Ányɨ̀, ma màkǎ mʉnɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ átɔ̀, ndɨ dhu-okú dɔ̀ rɔ̀ ma mɨra nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ ùbhi Gàlìlayà ɔ̌ kɔ́rɔ́ ngari ɔ̌, ndàrà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ndɨ pbìrì ɔ̌ unduta-dzà ɔ̌ rɔ̀, ndàdʉ̀ àrà nzɛ́rɛ-alafí nípfo rɔ̌ abádhí rɨ̌’ɨ̀ ɔ̀yà alɛ ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Atdíku, kɨ́kɨ́ nà atdí alɛ nɨ́’ɨra Yěsù ɨ, ndìtsì ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌ kɔ̀nzɨ̌, ndàdʉ̀ ndɨ̀tsɔ̀ kàrɔ̌ ndàtɨ: «Nyɨ nyòzè ka nɨ̌, nyɨ nyínè nyabhʉ ma mɨlǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nɨ́ Yěsù náabà ɨzʉ kàdɔ̌, ndàdʉ̀ ɔtsʉ́na nágbà, ndàpbàlǎ kàngbɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨwà ma mòzè. Ɨ́lǎnà!» ");
INSERT INTO niy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, kɨ́kɨ́ níikù wɔ̀rɨ́ alɛ rɔ̌ rɔ̀, kà ràdʉ̀ ɨ̀lǎ. ");
INSERT INTO niy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wɔ̀ dhu-dzidɔ̌, Yěsù ʉyá dhu kà tɔ̀ ɔbɨ nyʉ́ nà, ndàdʉ̀ kàvi ràrà, ");
INSERT INTO niy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ndàtɨ nɨ̌: «Ándà nga mběyi, àpɛ́ nyʉnɔ wɔ̀ dhu atdí alɛ tɔ̀ màtɨ́. Pbɛ́tʉ̀ árà nyɨtɛ̀ nyɨ nyɔ̀gʉ̀ dhu kùhanɨ̀ tɔ̀, ndɨrɔ̀ nyádʉ̀ nyabhʉ̀ yà Músà bhà Ʉyátá nʉ́ʉyá pɛrɛ̀ Kàgàwà tɔ̀, ndɨ́nɨ̌ nyɨ nyɔ̀gʉ̀ dhu nɨtɛ̀ tɨ́ kɔ́rɔ́ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pbɛ́tʉ̀ wɔ̀rɨ́ alɛ níitdègu àrà, náadʉ̀ ndɔ̀pɛ̀ ndàrà rɔ̀ná ndɨ̀ nɔ̀nzɨ̀ dhu náwɛ rɔ̌ atdídɔ̌ nyʉ́, ndʉ̀gà ndɨ dhu-ɔ̀yɨ̌ kɔ́rɔ́ ngari ɔ̀nǎ. Wɔ̀ ndɨ dhu-okú dɔ̀ rɔ̀, Yěsù náadʉ́nà nzɨ̌ àrà òtsù rɔ̌ kpangba atdí kɨgɔ̀ ɔ̀ màtɨ́, pbɛ́tʉ̀ kǎránà àdɨ rɔ̌ lɛ̀ngɛ̀lɛ̀ngɛ̀. Nɨ́, ìndrǔ owúnà ìwu rɔ̌ kà-tɨ’ɔ̀ kɔ́rɔ́ ngari ɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngúfe ɨdhɔ dzidɔ̌, Yěsù níingo tdɨ́tdɔ̌ Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀, kɔ́rɔ́ alɛ ràdʉ̀ dhu ɨ̀rɨ̀, ìnè kà ràrɨ̌’ɨ̀ ɨdzá. ");
INSERT INTO niy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɨ́ ábhɔ̌ alɛ́-yà núundu ɨ̀ Yěsù rɨ̌’ɨ̀ ɔ̀nà ɨdza ɔ̌, ɨ̀mbǎ alɛ-pfɔ̀ kafɔ́ rɔ́nga mà rɨ̀’ɨ̀ ndɨ ɨdza-lí màtɨ́. Yěsù náadʉ̀ àdɨ ndàmbɛ Kàgàwà bhà Ɔtɛ núdhe dɔ̌ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nɨ́rɔ̀ nɨ́ ndɨ ngʉ̌kpà alɛ níiwú ngbɔ̌na ʉ́vɛ alɛ nà Yěsù-tɨ’ɔ̀, ɨ̀fɔ alɛ nánɔ̀ ótdù dɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pbɛ́tʉ̀, abádhí rɨ̌ ndɨ alɛ nítsǔ Yěsù-tɨ’ɔ̀ dhu nɨ́ɨ’ɨ̀ ɔbɨ tɨ́ ihé-yà-okú dɔ̀ rɔ̀. Nɨ́ abádhí nʉ́ʉngbɛ ɨdza-dɔ̀tsirɔ̀ yà Yěsù nádɨ ɔ̀ná ngari dɔ̌ rɔ̀, ’àdʉ̀ wɔ̀rɨ́ alɛ nífo ɔ̀ná ótdù mànà Yěsù-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nɨ́ kɔ̀rɨ́ alɛ tɔ́ a’uta ndɨ̀ ndàla rɔ̀, Yěsù atɨ wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: «Ɔdhɨ́, ma mʉ̀bà wà pbʉ̀kʉ̀ nzɛ́rɛnga.» ");
INSERT INTO niy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nɨ́, yà ányɨ̀rɔ̌ ɨ̀ òkò rɔ́ ɨ’ɨ̀ Músà bhà Ʉyátá tɔ́ ngúfe màlímó, náambɛ́nà ɨnga nɨ́rɛ̀ dɔ̌ afíya ɔ̀, ’àmbɛ àtɨ̀nà dɔ̌: ");
INSERT INTO niy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ádhu wɔ̀ alɛ rɨ̌ dhu ʉ̀nɔ nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌ nɨ̌? Ádhɨ ìndrǔ bhà nzɛ́rɛnga nʉ́bà rádʉ̀, ɨnzá nɨ́ Kàgàwà kɛ̀lɛ̌ atdírɔ̀ nʉ́bà ka rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nɨ́ ʉrɔ́ rɔ̀ tɨ́, Yěsù nʉ́ʉnɨ abádhí rɨ̌rɛ̀na afíya ɔ̀ dhu, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Ádhu nyɨ̌ nyɨ́’ɨ̀ wɔ̀rɨ́ ɨrɛ̀ta-tɨdɔ̀ nà nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Katɨ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: ‹Ma mʉ̀bà wà pbʉ̀kʉ̀ nzɛ́rɛnga›, ndɨrɔ̀ katɨ: ‹Ɨ́và nyɨ, ítdù ɨndʉ́ ótdù, nyadʉ̀ àrà›, nɨ́ kɔ̀rɨ́ ɔ́yɔ̌ dhu nzínzì ɔ̌ ɨsɔ́ rɔ́’ɔ dhu nɨ́ àdhu? ");
INSERT INTO niy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nɨ́rɔ̀, ma mòzè nyʉ̌nɨ dhu, ìnè Ìndrǔ t’ídhùnà ràrɨ̌’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà, ndʉ̀bà ìndrǔ bhà nzɛ́rɛnga yà adzɨ dɔ̌.» Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ àtɨ̀nà wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: ");
INSERT INTO niy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ma mátɨna ɨnyɨ nɨ̌: Ɨ́và nyɨ, ítdù ɨndʉ́ ótdù, nyadʉ̀ àrà pbʉ̀kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀rɨ́ alɛ nɨ́ɨvà ndɨ̀ kɔ́rɔ́ alɛ-nyɨ̀kpɔ́ ɔ̌ rɔ̀, ndìtdù fɨ̀ndá ótdù, ndàdʉ̀ àrà pbɨ̀ndà. Ɨdhɔ nyʉ́ nʉ́ʉkɔ ʉrɔ́ ɨ̀’ɨ̀ alɛ́-yà kɔ́rɔ́ atdídɔ̌, ràdʉ̀ Kàgàwà nɨ́fʉ ’àtɨ: «Ɨnzá mǎ màpɛ̀ yà dhu bhěyi dhu-tɨdɔ̀ nálǎ!» ");
INSERT INTO niy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù náadù ndɨ̀ Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̀. Nɨ́, ihé-yà nóowúnà ìwu rɔ̌ kà ɨ, kà ràdʉ̀ àmbɛ dhu ùdhe dɔ̌ fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nɨ́ ʉ̀da ndɨ̀ ndʉ́da rɔ́rɔ̀, kǎla Lawì, Àlʉ̀fayò t’ídhùnà pàratà t’ʉ́fɔ́tá-dzà ɔ̌ àdɨ rɔ́. Nɨ́ Yěsù atɨ kà nɨ̌: «Ɨ́rà owùdu ɔ̌.» Nɨ́, Lawì adʉ̀ ndɨ̀và ndàrà kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù dhu nɔ́nyʉ̀ ndɨ Lawì bhà ɨdza. Nɨ́, pàratà tɔ́ ibí pbàndɔ́mbɛ́ mà, nzɛ́rɛnga tɔ́ ngʉ̌kpà alɛ mànà nɨ́ɨ’ɨ̀ atdíkpá abádhí mànà ndɨ ɔ̀nyʉ̀-tsʉ̀nǎ. Obhó tɨ́, ibí ɨ dhu bhěyi alɛ-tɨdɔ̀ nóongónà ndɨ ùbhi kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nɨ́ Pbàfàrìsáyó nzínzì ɔ̌ Músà bhà Ʉyátá tɔ́ màlímó nɨ́ɨ’ɨ̀ ìnè ányɨ̀rɔ̌. Nɨ́ abádhí níitdègu Yěsù mà rɨ̌ dhu ɔ̀nyʉ ɨ nzɛ́rɛngatálɛ mà, pàratà tɔ́ pbàndɔ́mbɛ́ mànà dhu nálǎ, náatɨ Yěsù bhà ábhàlɨ̌ nɨ̌: «Ádhu kàrɨ̌ dhu nɔ́nyʉ pàratà tɔ́ pbàndɔ́mbɛ́ mà ndɨrɔ̀ nzɛ́rɛngatálɛ mànà nɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nɨ́, wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù adʉ̀ atɨ̀nà abádhí nɨ̌: «Ɨ̀mbǎ rɨ́’ɨ̀ andɨ nà alɛ náarɨ́ nzɨ̌ mʉ̀ngangà-atdyú nóho, pbɛ́tʉ̀ mʉ̀ngangà-atdyú òho arɨ́ alɛ nɨ́ andɨ nà rɨ́’ɨ̀ kɛ̀lɛ̌. Ɨnzá ma mɨra obhónángatálɛ núnzì, pbɛ́tʉ̀ ma mɨra ùnzìnà nɨ́ nzɛ́rɛngatálɛ.» ");
INSERT INTO niy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bàtizò nubhónà Yùwanɨ̀ bhà ábhàlɨ̌ mà Pbàfàrìsáyó mànà nóongónà ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ̀. Nɨ́ atdíku, ìndrǔ iwú dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Ádhu Yùwanɨ̀ bhà ábhàlɨ̌ mà Pbàfàrìsáyó tɔ́ ábhàlɨ̌ mànà náarɨ́ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ, ɨ̀nzɨ̌ pbʉ̀kʉ̀ ábhàlɨ̌ ràdʉ̀ kʉ̀tsɨ̀ átɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ mbólí ɔ̌ ndàtɨ: «Nyɨ̌ nyɨ̀rɛ̀ tɨ́ nga àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀ ìwǔ alɛ ràrǎdʉ̀ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ̀, àzèmbè ìnè akpa-tsi rɨ̌’ɨ̀ nzínzìya ɔ̌ rɔ́rɔ̀? Ɨ̀nzɨ̌ akɛkpá màtɨ́! Kɔ́rɔ́ kàsʉmɨ̀ yà ìnè ɨ̀ ɨ́’ɨ̀ ɔ̀ná atdíkpá akpa-tsi mànà ɔ̌, abádhí rɨ̌ nzɨ̌ àdʉ̀ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pbɛ́tʉ̀, atdí ɨdhɔ nɨ́ɨ’ɨya ìnè, yà akpa-tsi nódyì ka kɨ́ ɔ̀ná abádhí nzínzì ɔ̌ rɔ̀. Ndɨ ɨdhɔ rǎkǎ nɨ́nganɨ́ nɨ́ ndɨ, abádhí nʉ́ʉtsɨya ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ndɨrɔ̀, ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ ngoyì-ɔwʉ́tá tɔ́ kɛ̀lɛ̀mʉ̀ nápba mbɛrʉ̀-ayɨ́ ɔ̌, akyɛ ndɨ kɛ̀lɛ̀mʉ̀ náadʉ̀na ndàduru ndɨ mbɛrʉ̀ ka kù’o rɔ̀, ndàdʉ̀ ndɨ mbɛrʉ̀-ayɨ́ nʉ́fà, ndɨ ʉfàta-bhu ràdʉ̀ àhʉ íhǔ nyʉ́ tdɨ́tdɔ̌ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ndɨ dhu bhěyi tɨ́, ka kɨ́ nzɨ̌ àdʉ̀ dìvayì-ɔwʉ́tá nɨ́sɨ kàmʉdzɛ̀-ayɨ́ ɔ̀, akyɛ ndɨ dìvayì nɨ́ɨvʉ̀na kàmʉdzɛ̀-ayɨ́ ɔ̀, ràdʉ̀ ndɨ kàmʉdzɛ̀ nʉ́fà, ndɨ dìvayì ràdʉ̀ ndʉ̀fʉ̀ obvò nɨ̌. Nɨ́rɔ̀ dhu-ɔ̀fɔ̀ nga kɨsɨ̌ dìvayì-ɔwʉ́tá kàmʉdzɛ̀-ɔwʉ́tá ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Atdíku Pbàyàhúdí tɔ́ sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náambɛ́nà òwu dɔ̌ nganʉ̀ tɔ́ ɨnga ɔ̀na nǎ ʉ́dà otu ɔ̌. Nɨ́, Yěsù bhà ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀ ’òwù otu-igì dɔ̌ rɨ̌’ɨ̀ nganʉ̀ náfà rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɨ́ wɔ̀ dhu nàla Pbàfàrìsáyó náatɨ Yěsù nɨ̌: «Ándà pɛ́ dhu, ádhu pbʉ̀kʉ̀ ábhàlɨ̌ rɨ̌ ɨnzá àlɛ̌ tɔ́ ʉyátá ávi dhu ɔ̀nzɨ sàbatʉ̀-ɨdhɔ̀ ɔ̌ nɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyàpɛ̀ tɨ́ ɨnzá Dàwudì náanzɨ̀ dhu nɔ́zʉ̀? Atdíku, àbadhi mà rɔ̀ná alɛ mànà nɨ́ɨ’ɨ̀ àwù nà, ɨ̀mbǎ ɨ̀ ɔ́nyʉna dhu ràdʉ̀ ɨ̀’ɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nɨ́, kǎtsù Kàgàwà bhà ɨdza, ndàdʉ̀ pɛrɛ̀ tɨ́ ka kùbho Kàgàwà tɔ̀ mʉ̀gatì nídyì ndɔ̀nyʉ̀. Obhó tɨ́, àlɛ̌ tɔ́ Ʉyátá rǎtɨna wɔ̀ ndɨ mʉ̀gatì nɔ́nyʉ̀ rádʉ̀ ràrɨ̌ pbàkùhánɨ́ kɛ̀lɛ̌ vǐya dɔ̌ rɔ̀. Pbɛ́tʉ̀ Dàwudì níidyi ka ndɔ̀nyʉ̀, ndàdʉ̀ kàbhʉ átɔ̀ ɨ̀ ùbhi mànà pbɨ̀ndà alɛ tɔ̀. Wɔ̀ ndɨ dhu náanzɨ̀ ndɨ̀ Àbìyàtarɨ̀ nɨ́ɨ’ɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà tɨ́ nɨ́nganɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Ìndrǔ ka kanzɨ̀ nzá sàbatʉ̀-ɨdhɔ̀ tɔ̀, pbɛ́tʉ̀ sàbatʉ̀-ɨdhɔ̀ ka kanzɨ̀ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ɨma Ìndrǔ t’ídhùnà, ɨma nɨ́ ndɨ Ádrʉ̀ngbǎlɛ sàbatʉ̀-ɨdhɔ̀ dɔ̌ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngǎtsi nɨ́nganɨ́ sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù náatsù tdɨ́tdɔ̌ unduta-dzà ɔ̀. Nɨ́ ɔtsʉ́na ótsù atdí alɛ nɨ́ɨ’ɨ̀ ányɨ̀-dza. ");
INSERT INTO niy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ányɨ̀rɔ̌ ɨ̀’ɨ̀ ngʉ̌kpà alɛ náambɛ́nà Yěsù nándà dɔ̌ atdyúya nyʉ́ nà, ndɨ́nɨ̌ ’ala tɨ́, kàrà tɨ́ wɔ̀ alɛ nɨ́gɨ̌gʉ̌ sàbatʉ̀-ɨdhɔ̀ ɔ̌, ndɨ́nɨ̌ ’adʉ̀ tɨ́ kɔ̀bhʉ̀ ndɨ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nɨ́ Yěsù atɨ wɔ̀ ndɨ ɔtsʉ́na ótsù alɛ nɨ̌: «Ɨ́và nyɨ, nyidè ʉrɔ́ kɔ́rɔ́ alɛ nzínzì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tdɨ́tdɔ̌ kǎdʉ̀ dhu nívu yà ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ-tsʉ̌ ndàtɨ: «Àlɛ̌ tɔ́ Ʉyátá návi tɨ́ kɔnzɨ̀ ídzì dhu ìndrǔ tɔ̀, ndɨrɔ̀ tɨ́ kɔnzɨ̀ nzɛ́rɛ dhu ìndrǔ tɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌? Tɨ́ kɨgʉ̌ ìndrǔ bhà ípìrɔ̌nga, ndɨrɔ̀ tɨ́ kʉbhà ndɨ alɛ rɔ̀vɛ̀?» Pbɛ́tʉ̀ abádhí adʉ̀ ɨ̀nɛ̀ ɨ̀nɛ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nɨ́, Yěsù náandà abádhí-dɔ̀ nga kɔ́rɔ́ akótá nyʉ́ nà, ɨzʉ ràdʉ̀ ndʉ̀ka atdídɔ̌ abádhí tɔ́ odú alɛ-afí-okú dɔ̀ rɔ̀. Nɨ́ kǎdʉ̀ àtɨ̀nà ndɨ alɛ nɨ̌: «Ɨ́gba ɔtsʉ́nʉ!» Kà ràdʉ̀ kɨ̀gbà. Nɨ́ kɔ̌tsʉ́ náadʉ̀ ɔ̀gʉ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, Pbàfàrìsáyó núuvò unduta-dzà ɔ̀ rɔ̀, ’àdʉ̀ ’ùndu Hɛ̀rɔdɛ̀ bhà alɛ mànà, ndɨ́nɨ̌ ’ɨrɨ tɨ́ ɨ̀ ɨ̀ngbǎ dhu bhěyi màtɨ́ ka kɨ́ Yěsù nábhʉ̌ kohò dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà nɨ́ɨdhá ɨ̀ Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̀, ábhɔ̌ alɛ tɔ́ ihé-yà ràdʉ̀ òwu owùya ɔ̌. Ɨ alɛ́-yà níiwú Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀, Yùdɛyà tɔ́ pbìrì ɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, Ìdùmɛyà tɔ́ pbìrì ɔ̀ rɔ̀, Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-adzènǎ rɔ̀ arɨ́’ɨ̀ pbìrì ɔ̀ rɔ̀. Ndɨrɔ̀ abádhí iwú Tirò mà Sìdɔnà mànà tɔ́ kɨgɔ̀ tɔ́ mʉ̀lɛngʉ̀ ɔ̀nǎ rɔ̀. Ɨ ábhɔ̌ alɛ tɔ́ ihé-yà níiwú Yěsù ɨ, kǎrɔ́nzɨna dhu-ɔ̀yɨ̌ ɨ̀ ɨ́rɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nɨ́, Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ návi rɨ̀lɨ atdí ibhú fɨ̌ndà, akyɛ ndɨ ihé-yà níipbóna ndɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Obhó tɨ́, ibí alɛ nɨ́gʉ̌ kǎrɨ́ dhu-okú dɔ̀ rɔ̀, kɔ́rɔ́ alɛ andɨ nà rɨ́’ɨ̀ nóowúnà ’òdzì rɔ̌ kà rɨ̌’ɨ̀ ɨ, ndɨ́nɨ̌ ’apbálá tɨ́ kàngbɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndɨrɔ̀ Yěsù ɨ̀ àla rɔ̀, nzɛ́rɛ-alafí nóowúnà yà ɨ̀ arɨ́’ɨ̀ ɔ̀yà alɛ nábhʉ rɔ̌ rʉ̀kɔ ɨ̀ ɔtdyʉ̀ya dɔ̌ Yěsù-ɔ̀nzɨ̌, ’àdʉ̀ òwu abádhí àbhʉ rɔ̌ rùkǔ, ’àmbɛ àtɨ̀nà dɔ̌: «Ɨnyɨ, nyɨ nɨ́ Kàgàwà t’ídhùnà nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pbɛ́tʉ̀ Yěsù adʉ́nà àrà dhu nʉ́ya rɔ̌ ɨ nzɛ́rɛ-alafí tɔ̀ ɔbɨ nyʉ́ nà, ɨ̀nzɨ̌ àdhɨ màtɨ́ ndɨ̀ ndɨ́’ɨ̀ dhu nʉnɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù núupò atdí pbìrì dɔ̀, ndàdʉ̀ ndɨ̀ ndòzè ndùnzì alɛ núnzì, ɨ alɛ ràdʉ̀ ìwu tɨna ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kǎdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà alɛ nʉ́lɨ, ndàdʉ̀ ɔvɔ̀ya nɔ́vɔ̀ «uvitatálɛ» tɨ́. Kʉ̌lɨ abádhí ndɨ́nɨ̌ ’ongó tɨ́ oko mànà atdíkpá. Kʉ̌lɨ abádhí, ndɨ́nɨ̌ ndongó tɨ́ ùvinà ròwù Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ ìndrǔ tɔ̀, ");
INSERT INTO niy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ndɨrɔ̀ ndɨ́nɨ̌ ɨ’ɨ tɨ́ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà ’òwù nzɛ́rɛ-alafí nípfo rɔ̌ nɨ̌ ìndrǔ ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yàrɨ́ nɨ́ ndɨ yà kǎvò atdí-kumì dɔ̀ná ɔ́yɔ̌ nà Uvitatálɛ-ɔvɔ̀: Sìmonì (Yěsù adʉ̀ ngǎtsi kɔ̌vɔ̀ nɔ́vɔ̀ Pɛ́tɛrʉ̀ tɨ́), ");
INSERT INTO niy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yàkɔbhɔ̀ mà adɔ̀nà Yùwanɨ̀ nà. Abádhí ɔ́yɔ̌ kɔ́rɔ́ nɨ’ɨ̀ Zɛ̀bɛ̀dayò bhà inzo. Yěsù adʉ̀ ngǎtsi abádhí-ɔvɔ̀ nɔ́vɔ̀ Bɔ̀wànɛrgɛ̀ tɨ́, kà-tɨ̀ nɨ́ ɔvɔ bhà inzo. ");
INSERT INTO niy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Àndɛ̀rɛyà, Fìlipò, Bàrtɔ̀lɔ̀mayò, Màtayò, Tʉ̀masɨ̀, Yàkɔbhɔ̀ (Àlʉ̀fayò t’ídhùnà), Tàdayò, Sìmonì, yà atdídɔ̌ ndɨ̀ nugyénà fɨ̀yɔ́ pbìrì dɔ̌ alɛ, ");
INSERT INTO niy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ndɨrɔ̀ Yudhà Ìskàrìyɔtà, yà Yěsù ìpfo adʉ̀ àrà ndàbhʉ òmvǔ-fɔ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wɔ̀ dhu-dzidɔ̌, Yěsù náadù ndɨ̀ ɨdza. Nɨ́, ihé-yà náadʉ̀ ’àndu tdɨ́tdɔ̌ kà-tɨ́, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà rɨ̌ ɔ̀nyʉ̀ nɔ́nyʉ ɔ̀ná kàsʉmɨ̀ mà ràdʉ̀ ɨ̀’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nɨ́ wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, kà mà t’ɨ́dzá-bhà náadʉ̀ kàtɨ̀ ɨwà dɔ̀na ɨ̀nza ndɨ̀ dhu tɨ́. Nɨ́, abádhí adʉ̀ ìwu kòdyì òwùnà. ");
INSERT INTO niy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ndɨrɔ̀, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀ ìwǔ Yěsù-tɨ’ɔ̀ Músà bhà Ʉyátá tɔ́ màlímó náambɛ́nà àtɨ̀nà dɔ̌: «Pfɔ̀mvɔ Bɛ̀lìzèbulì rɨ̌’ɨ̀ kà ɔ̀.» Ndɨrɔ̀ abádhí ambɛ́nà àtɨ̀nà dɔ̌: «Wɔ̀ ndɨ nzɛ́rɛ-alafí ɔ̌ ádrʉ̀ngbǎlɛ nɨ́ ndɨ arɨ́ kàbhʉ̌ ròdì kɔ̌kɔ̀ ɨ nzɛ́rɛ-alafí.» ");
INSERT INTO niy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nɨ́ Yěsù anzi abádhí, ndàdʉ̀ dhu ʉ̀nɔ̀ fɨ̌yɔ̀ mbólí ɔ̌ ndàtɨ: «Nzɛ́rɛ-alafí dɔ̌ ádrʉ̀ngbǎlɛ, Sìtanɨ̀, rǎdʉ̀ ndòdì ɨ̀ngbǎ dhu bhěyi ndɨ̀tɨ́rɔ̀? ");
INSERT INTO niy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ náapɛ́ àmbɛ ’ùgyè dɔ̌ nzínzìya ɔ̌, nɨ́ ndɨ kamà bhà idzi náarɨ́ nzɨ̌ àpɛrɛ. ");
INSERT INTO niy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ndɨrɔ̀, atdí ɔdhɨ náapɛ́ àmbɛ anya nɔ́nzɨ̀ dɔ̌ nzínzìya ɔ̌, nɨ́ ɨ alɛ tɔ́ ɔdhɨ-tɨ̀ náarɨ́ nzɨ̌ ìde. ");
INSERT INTO niy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nɨ́rɔ̀, Sìtanɨ̀ náapɛ́ àdʉ̀ ndɔ̀pɛ̀ ndùgyè ndɨ̀ ndɨ̀tɨ́rɔ̀, kàbhà idzi-ɔ̌nga ràdʉ̀ ndùtu, nɨ́ kàbhà ádrʉ̀ngbǎnga rɨ̌ nzɨ̌ adʉ̀ àpɛrɛ, kàbhà idzi-tsʉ̀ ràdʉ̀ ndɔ̀dɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ òtsù ɔbɨ nɨ̌ ɨ̀dzɨ̌dzɔ̀ alɛ bhà ɨdza, ndàdʉ̀ kàbhà ɨdzá dhu nʉ́mbà, ɨnzá ndɨ̀ ndàlʉ̌ pɛ́ ka ndʉ̀tsɨ̀ angyi rɔ́rɔ̀. Ka ndɨ̀ ndàlʉ̌ ndʉ̀tsɨ̀ dhu-lutìnǎ nɨ́ ndɨ, kà rǎdʉ̀ kàbhà ɨdzá dhu nʉ́mbà. ");
INSERT INTO niy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, ìndrǔ náabáya àbà kɔ́rɔ́ fɨ̀yɔ́ nzɛ́rɛnga tɔ́ ʉbàta, ndɨrɔ̀ abádhí náabáya àbà Kàgàwà nɨ̌ ɨ̀ arɨ́ dhu ʉ̀nɔ nzɛ́rɛ dhu tɔ́ ʉbàta mà. ");
INSERT INTO niy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pbɛ́tʉ̀, Ɨ̀lɨ̌lǎ-Alafí nɨ̌ rɨ́ dhu ʉ̀nɔ̀ nzɛ́rɛ alɛ náabáya nzɨ̌ ʉbàta akɛkpá màtɨ́. Obhó tɨ́, kàbhà nzɛ́rɛnga nɨ́ dhòdhódhónga nà rádɨ nzɛ́rɛnga.» ");
INSERT INTO niy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yěsù atɛ̀ wɔ̀ dhu bhěyi abádhí nɨ̌, abádhí àtɨ ndɨ̀ ràrɨ̌’ɨ̀ nzɛ́rɛ-alafí dɔ̌ ádrʉ̀ngbǎlɛ nà ɔ̀nà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tdɨ́tdɔ̌, Yěsù-tsánà mà kà t’ádɔ́na mànà níiwú ùvò Yěsù rɨ̌’ɨ̀ ɔ̀nà ɨdza-lí. Abádhí itsi ìko irinǎ rɔ̀, ’àdʉ̀ atdí alɛ návi rànzì Yěsù ɨdza rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ihé-yà nɨ́ɨ’ɨ̀ kà-tɨ́ ɨ̀ òkò, ’àkpɔ̀rɔ̀ kàngbɔ̀ rɔ́. Nɨ́ ka kadʉ̀ àtɨ̀nà kà nɨ̌: «Kànɨ̌ ɨ́yànʉ mà adɔ́nʉ mà awɛ́nʉ mànà rɨ̌’ɨ̀ iri. Abádhí rɨ̌ nyɔmɛ.» ");
INSERT INTO niy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nɨ́ Yěsù adʉ̀ dhu àdu ndàtɨ: «Ádhɨ ndɨ ɨ́yàdu, ndɨrɔ̀ ádhɨmà ndɨ adɔ́du?» ");
INSERT INTO niy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tdɨ́tdɔ̌ kǎdʉ̀ yà tɨná ókò ’àkpɔ̀rɔ̀ ngbɔ̌na alɛ dɔ̀ nga nándà, ndàdʉ̀ àtɨ̀nà: «Kànɨ̌ ɨ́yàdu mà adɔ́du mànà. ");
INSERT INTO niy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kàgàwà òzè dhu nɔ́nzɨ rɨ́ alɛ nɨ́ ndɨ, adɔ̀du, awɛ̀du, ndɨrɔ̀ ɨ́yàdu.» ");
INSERT INTO niy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù ɨvà ndɨ̀ ndàrà Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̀. Nɨ́ ányɨ̀ ndɨ̀ ndàrà àhʉ rɔ̀, kǎpɛ̀ ndàmbɛ dhu ùdhe dɔ̌ tdɨ́tdɔ̌ ìndrǔ tɔ̀. Nɨ́, ádrʉ̀ngbǎ ihé-yà nyʉ́ núundu ɨ̀, ’àkpɔ̀rɔ̀ kàngbɔ̀. Ndɨ dhu-okú dɔ̀ rɔ̀, kǎdʉ̀ ùpo ibhú ɔ̀, ndàdɨ ányɨ̀. Ndɨ ibhú nɨ́ɨ’ɨ̀ rɛ̀rʉ̀ dɔ̌, ihé-yà ràdʉ̀ òko rɛ̀rʉ̀-bɨdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nɨ́ kǎmbɛ́nà ábhɔ̌ dhu nyʉ́ núdhe dɔ̌ abádhí tɔ̀ mbólí ɔ̌. Ndɨ pbɨ̀ndà dhu t’údheta ɔ̌, kǎwɛ dhu abádhí tɔ̀ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Nyɨ̀rɨ pɛ́! Atdíku, atdí alɛ náahʉ̀ ndàrà ɔ̀nyʉ̀-tsè nɔ́rɛ̀ ɨnga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nɨ́ yà ɔ̀nyʉ̀-tsè nɔ́vɔ kàrɨ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdídhená itse náawà ɨ̀ otu ɔ̌. Nɨ́, àrɛ̀ adʉ̀ ìwu, ’ùbhǐ ɨ itse otu ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ngʉ̌kpà-tsí náawà ɨ̀ ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ dɔ̀ná abhɔ odu-kɛngɛrɛ dɔ̌. Kɔ̀rɨ́ itse náadʉ̀ ɨ̀nga kòmbómbí, ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ dɔ̀yá abhɔ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nɨ́ adyifɔ̀ níitdègu ɨ̀ka, náadʉ̀ wɔ̀ ɨ̀ngɨngà ɔ̀nyʉ̌-nzo nɔ́bɨ̀, ràdʉ̀ òtdyù, ɨ̀mbǎ ɨvɛ́ya rɨ̌’ɨ̀ ádzàdzǐ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Atdídhená itse náawà ɨ̀ okpèna nà itsukpó nzínzì ɔ̌, ɨ okpèna nà itsu náadʉ̀ àta, ’àdʉ̀ òvi, ’àdʉ̀ wɔ̀ ɨ̀ngɨngà ídzì ɔ̀nyʉ̀ nʉ́tsɨ̀, ɨ̀nzɨ̌ ràdʉ̀ ɔ̀’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pbɛ́tʉ̀, ngʉ̌kpà itse náawà ɨ̀ ídzì adzɨ ɔ̌. Nɨ́ ɨ ɔ̀nyʉ̀ nɨ́ɨnga, ’òvì, ’àdʉ̀ ɔ̀’ɔ̀ mběyi nyʉ́. Atdídhená náadhɨ̀ itse ɨ̀bhʉ kumì-gʉ̀na ròsè, ngʉ̌kpà náadhɨ̀ azà kumì-gʉ̀na ròsè, ndɨrɔ̀ ngʉ̌kpǎkà-tsí náadʉ̀ ɔ̀dhɨ atdɨ́-mɨyà-gʉ̀na ròsè.» ");
INSERT INTO niy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ nɨ́rɨ ka.» ");
INSERT INTO niy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yěsù níitdègu ndìndrǐ ɨtsɛ ihé-yà rɔ̌ rɔ̀, nɨ́ yà kà-tɨ́ aróko alɛ mà, kàbhà atdí-kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ mànà náavì ka ràwɛ kɔ̌kɔ̀ mbólí-tɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nɨ́ kǎdù dhu abádhí tɔ̀ ndàtɨ: «Fʉ̌kʉ̀ nyʉ́, ka kɨ́tɛ̀ wà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi-nyʉ-tsì ndɨ̀ nórù dhu. Pbɛ́tʉ̀, ngʉ̌kpà alɛ náarɨ́ kɔ́rɔ́ dhu nɨ́rɨ mbólí tɔ́ ɔ́fɔ̀ ɔ̌, ");
INSERT INTO niy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‹ndɨ́nɨ̌ ɨ̀ owu tɨ́ ɨnga àndà rɔ̌, pbɛ́tʉ̀ ɨ̀nzɨ̌ ’àdʉ̀ atdí dhu mà nála, ndɨrɔ̀ ’àdʉ̀ nga nɨ́rɨ̀, pbɛ́tʉ̀ ɨ̀nzɨ̌ atdí dhu mà ràdʉ̀ dɔ̀ya nálʉ, akyɛ ɨ̀ owuna ’ʉ̀gɛ̀rɛ̀ fɨ̀yɔ́ nzɛ́rɛnga ɔ̌ rɔ̀, Kàgàwà ràdʉ̀ dhu nʉ́bà fɨ̌yɔ̀ nɨ̌!›» ");
INSERT INTO niy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyʉ̀nɨ tɨ́ nzá yàrɨ́ mbólí rʉ̌nɔna dhu? Olu, nyɨ̌ nyádʉ̀ kɔ́rɔ́ ngʉ̌kpà mbólí rʉ̌nɔna dhu nʉ́nɨ ɨ̀ngbǎ dhu bhěyi? ");
INSERT INTO niy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yàrɨ́ nɨ́ ndɨ ɔ̀nyʉ̀-tsè nɔ́rɛ rɨ́ alɛ tɔ́ mbólí-tɨ̀: Ɔ̀nyʉ̀-tsè ɔ̀rɛ rɨ́ alɛ nɔ́rɛ̀ dhu nɨ́ Kàgàwà bhà Ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ yà Kàgàwà bhà Ɔtɛ náwà ɨ̀ ɔ̀ná otu bhěyi. Abádhí rɨ̌ ndɨ Kàgàwà bhà Ɔtɛ nɨ́rɨ, ányɨ̀rɔ̌ rɔ̀ tɨ́ Pfɔ̀mvɔ ràdʉ̀ ɨ̀rà, ndàdʉ̀ ndɨ ɔ̀rɛ ka kɔ̀rɛ̀ Ɔtɛ nípfo abádhí-afí ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ odu-kɛngɛrɛ-dɔ yà ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ dɔ̀ná abhɔ bhěyi. Kàgàwà bhà Ɔtɛ ɨ̀ ɨ̀rɨ̀ rɔ̀, abádhí rǎdʉ̀ kà’ù dhɛ̀dhɛ nyʉ́ nà ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pbɛ́tʉ̀, abádhí rɨ̌ nzɨ̌ àdʉ̀ kàbhʉ ɨvɛ́na rɔ̀dɨ̀ ndɨ̀ afíya ɔ̀, ’àdʉ̀ ’àpba kà-rɔ̌ ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́. Nɨ́, yà àpbɛ̀ mà avuta mànà nɔ́pɛ̀ ɨ̀ Kàgàwà bhà Ɔtɛ abádhí á’ù dhu-okú dɔ̀ rɔ̀ rɔ̀, abádhí rǎdʉ̀ ’àwà dòtsí fɨ̀yɔ́ a’uta ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ngʉ̌kpà alɛ-tsí nʉ́lɨ ɨ̀ okpèna nà itsu nzínzì ɔ̌ itse náwà ɨ̀ ɔ̀ná ɨnga bhěyi. Abádhí náarɨ́ Kàgàwà bhà Ɔtɛ nɨ́rɨ, ");
INSERT INTO niy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pbɛ́tʉ̀, yà adzɨ dɔ̌ ka kóko tɨ́ dhu tɔ́ ɨrɛ̀ta mà, ònzì náaríbhona ʉtrátá tɔ́ dhɛ̀dhɛ mà, ngʉ̌kpà dhu-atdyú mànà rǎdʉ̀ òtsù abádhí-afí ɔ̀. Nɨ́, kɔ́rɔ́ kɔ̀rɨ́ dhu rǎdʉ̀ ndɨ Ɔtɛ nʉ́tsɨ̀, ’àdʉ̀ àbhʉnà ɨ̀nzɨ̌ rɔ̀dhɨ̀ itse. ");
INSERT INTO niy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ndɨrɔ̀ ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ ídzì adzɨ ɔ̌ itse náwà ɨ̀ ɔ̀ná ɨnga bhěyi. Ɨ alɛ náarɨ́ Kàgàwà bhà Ɔtɛ nɨ́rɨ, ’àdʉ̀ à’ùnà. Ndɨrɔ̀, ɨ alɛ náarádʉ̀ ídzì itse nɔ́dhɨ̀: atdídhená alɛ rɔ̀dhɨ̀ ka ɨ̀bhʉ kumì-gʉ̀na ròsè, ngʉ̌kpà rɔ̀dhɨ̀ ka azà kumì-gʉ̀na ròsè, ndɨrɔ̀ ngʉ̌kpà-tsí ràdʉ̀ kɔ̀dhɨ̀ atdí-mɨyà-gʉ̀na ròsè.» ");
INSERT INTO niy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tdɨ́tdɔ̌, Yěsù ivú dhu abádhí-tsʉ̌ ndàtɨ: «Ka katɨ́ tarà ɔ̀bɔbɨ, kadʉ̀ àtsìnà ɨ̀tǎ-tsì? Ndɨrɔ̀, ka katɨ́ kɔ̀bɔbɨ, kadʉ̀ ɨ̀lɨnà ara-tsì? Ka katɨ́ nzɨ̌ kɔ̀bɨ kɨlɨ ɔrʉ́, mběyi kàrɨ̌ ɨnga náwʉ̀ rɔ́? ");
INSERT INTO niy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Obhó tɨ́, kɔ́rɔ́ dhu-tsí yà ndɨ̀ narù náalaya ndɨ̀ kpangba, ndɨrɔ̀ kɔ́rɔ́ dhu-tsí yà ɔ̀dhʉ̌ ɔ̀ arádɨ náavìya ndɨ̀ kpangba awáwʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ nákǎ ndɨ̀rɨ̀ ka!» ");
INSERT INTO niy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Nyàndà nga mběyi yà nyɨ̌ nyɨ́rɨna dhu nà. Ka kudhèya dhu fʉ̌kʉ̀ àdhàdhɨ̀ yà nyɨ̌ nyarɨ́ dhu núdhě ìndrǔ tɔ̀ ɔ̀ná mʉ̀gɛ̀rɛ̀ ɔ̌, kadʉ̀ àmànà àma tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Obhó tɨ́, dhu nà arɨ́’ɨ̀ abhɔ alɛ tɔ̀, ka kabhʉ̀ya dhu abhɔ nyʉ́ ròsè. Pbɛ́tʉ̀, ɨ̀mbǎ dhu arɨ́’ɨ̀ abhɔ fɔná alɛ-fɔ́ rɔ̀, ka kakɔ̀ya yà akɛ kǎrɨ́’ɨ̀ nà dhu mà.» ");
INSERT INTO niy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Yàrɨ́ nɨ́ ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi nɔ́fɔ̀ ndɨ̀ nà dhu: Atdí alɛ nɨ́ɨvà ndɨ̀ ndɔ̀rɛ̀ nganʉ̀-tsè pbɨ̀ ɨnga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nɨ́ yà ɨnga náarátɨ, ndàdʉ̀ ùbho dhu bhěyi, kǎráyi ɨnga nátɨ rɔ̀, ndàdʉ̀ ndɨ̀và ɨnga núbho rɔ̀. Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ ɔ̀nyʉ̀-tsè náaráta, ndàdʉ̀ ɨ̀nga ɨnzá àbadhi nʉ́nɨ ɨ̀ngbǎ dhu bhěyi màtɨ́ kà rɨ̌nga dhu rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Adzɨ rǎdʉ̀ wɔ̀rɨ́ nganʉ̀ nɨ́’ɔ ndɨ̀tɨ́rɔ̀. Wɛmbɛrɛ̀ tɨ́ kà rɨ̌ kàbhʉ̌ rɨ̀ngà, ɔyɔ rɨ́ kìsě nɨ̌ ndàdʉ̀ kàbhʉ ròvì, kà rǐku dɔ̀ ná rɔ̀ nɨ̌, ndàdʉ̀ kàbhʉ rìtù ndɨ̀, ràdʉ̀ ɔ̀’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wɔ̀ nganʉ̀ nɔ́’ɔ̀ dhu-dzidɔ̌ nɨ́ ndɨ, wɔ̀ alɛ rǎdʉ̀ kasʉ nɔ́pɛ̀ pbɨ̀ndà obhi nɨ̌, nganʉ̀ t’ótseta tɔ́ kàsʉmɨ̀ nákǎ wà nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ádhu àlɛ̌ kádʉ̀ àtɨ̀nà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi nɔ́fɔ̀ ndɨ̀ nà dhu tɨ́? Ndɨrɔ̀, ɨ́ngbà mbólí ndɨ kà dɔ̌ àlɛ̌ kádʉ̀ àwɛnà rɨ̀tɛ̀ ka? ");
INSERT INTO niy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kɔ̌fɔ̀ ndɨ̀ hàràdalɨ̀ tɔ́ itsukpó-tsè nà. Adzɨ ɔ̀ ka kɨ́ kòzò ɔ̀ná kàsʉmɨ̀ ɔ̌, ka nɨ́ ákɛ̌ dhu-tʉ́tʉ̌-ngba nyʉ́ ròsè kɔ́rɔ́ yà adzɨ ɔ̌ itse dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pbɛ́tʉ̀, yà nɨ́ ka kɨ́ kòzò adzɨ ɔ̀, nɨ́ kà rǒvi, ndàdʉ̀ òngo ádrʉ̀ngbǎ itsukpó tɨ́, ròsè kɔ́rɔ́ itsukpó-tɨdɔ̀ dɔ̀nǎ. Kɔ̌pbɨ́ rǎdʉ̀ òvi ádzàdzǐ nyʉ́, àrɛ̀ mà ràdʉ̀ ɨdzàya nɔ́sɨ̀ kà-bɨ̌ tɔ́ sɨ́sɨ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ndɨ dhu bhěyi tɨ́, Yěsù nʉ́ʉnɔ́nà Kàgàwà bhà Ɔtɛ kɔ́rɔ́ alɛ tɔ̀ ábhɔ̌ yàrɨ́ mbólí-tɨdɔ̀ ɔ̌. Kʉ̌nɔ́nà ka àdhàdhɨ̀ yà ndɨ̀ ndʉ́nɔna dhu nɨ́rɨ rɨ́ alɛ-dɔ nálʉ rádʉ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kɔ̌tɛ́nà nzɨ̌ abádhí nà ɨnzá ndɨ̀ ndʉ̀nɔ̀ mbólí ɔ̌ rɔ́rɔ̀. Pbɛ́tʉ̀, ɔ̀yá ɨ̀ òtù ɨ̀ pbɨ̀ndà ábhàlɨ̌ mànà ɔ̀ná kàsʉmɨ̀ ɔ̌, kǒngónà àdʉ̀ ɨ mbólí-tɨ̀ náwɛ kɔ́rɔ́ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ndɨ nɨ́nganɨ́ tɨ́ pbɨ́tsɔ̀ngǎ, Yěsù náatɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kàda rɛ̀rʉ̀-adzè.» ");
INSERT INTO niy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nɨ́, Yěsù bhà ábhàlɨ̌ nʉ́ʉbhà ihé-yà, ’àdʉ̀ òtsù yà Yěsù rɨ̌’ɨ̀ ɔ̀nà ibhú ɔ̀, ’àdʉ̀ òwu. Ngʉ̌kpà ibhú náadʉ̀ ɨ̀’ɨ̀ ìnè ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nɨ́rɔ̀ nɨ́ ndɨ àpùpú náapɛ̀ ndòpìlì ɔbɨ nyʉ́ nà, mʉ̀kʉrà ràdʉ̀ ’ɔ̀pɛ̀ ’àwà ɨ̀ ibhú ɔ̀, ibhú ràdʉ̀ àmbɛ àle dɔ̌ ɨdha nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yěsù náadʉ̀ ɨ̀’ɨ̀ ibhú tɔ́ kɔ̀bhɛ́ ɔ̀ ndɨ̀ ndàyi ndɨ̀pbɨ̀ dɔ̀na kùsé rɔ̌, ɨdhɔ ràdʉ̀ ndòdyì rɔ́. Nɨ́ kàbhà ábhàlɨ̌ nɨ́ɨnga ka ɨdhɔ ɔ̀ rɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌ ìkǔ nyʉ́ ɔ̌: «Màlimǒ, yà àlɛ̌ kʉ́vɛ dhu nátdǔ tɨ́ obhó afínʉ akɛkpá màtɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nɨ́ ɨdhɔ ɔ̀ rɔ̀ ndɨ̀ ndɨ̀và ndɨ̀ rɔ̀, Yěsù náarʉ̀ awɛ dɔ̌, ndàdʉ̀ àtɨ̀nà rɛ̀rʉ̀ nɨ̌: «Ɨ́nɛ̀! Ʉ́tsɨ tsʉ̀nʉ!» Nɨ́ awɛ náadʉ̀ opilita nʉ́bhà, ɨnga ràdʉ̀ ɨnɛ̀ bhìì. ");
INSERT INTO niy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ádhu nyɨ̌ nyɨ́ ɔdɔ nɔ́nzɨ nɨ̌? Nyɨ̌ nyàpɛ̀ t’óbhó ɨ̀’ɨ̀ a’uta nà?» ");
INSERT INTO niy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nɨ́, ádrʉ̀ngbǎ ɔdɔ nyʉ́ nɨ́ɨsɨ́ abádhí ɔ̀, abádhí ràdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ nzínzìya ɔ̌ ’àmbɛ àtɨ̀nà dɔ̌: «Ádhɨ pbá alɛ yà, awɛ mà, rɛ̀rʉ̀ mànà dhu náarɨ́ tsʉ̀ná dhu nɨ́rɨ?» ");
INSERT INTO niy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Gàlìlayà tɔ́ rɛ̀rʉ̀-adzè, Pbàgɛ̀rasɨ̀ tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nɨ́ yà Yěsù ìfò ibhú ɔ̀ rɔ̀ rɔ́rɔ̀ tɨ́, atdí alɛ náahʉ̀ ìndrǔ ʉ̀tdʉ̌ ka karɨ́ ɔ̀ná ngari ɔ̀ rɔ̀, ndɨ̀rà kà-tɨ’ɔ̀. Ndɨ alɛ nɨ’ɨ̀ nzɛ́rɛ-alafí nà arɨ́’ɨ̀ ɔ̀nà alɛ. ");
INSERT INTO niy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kǒngónà ɔ̀dhɔ̀ ndɨ ngari ɔ̀, ndɨrɔ̀ kà sɔ̀wɔ̀rɔ̀ nɔ́nzɨ rɨ́ ndʉ̀tsɨ̀ àdrà-mbǐ nɨ̌ atdí alɛ mà nɨ́ɨ’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Obhó tɨ́, bìlǐnganà ka kʉtsɨ́nà kàpfɔ̀ sìngà-mbǐ nɨ̌, kadʉ̀ kɔ̌tsʉ́ nʉ́tsɨ̀ àdrà-mbǐ nɨ̌. Nɨ́ kǒngónà àdʉ̀ ɨ àdrà-mbǐ nátdɨ, ndàdʉ̀ sìngà-mbǐ nátdɨ átɔ̀. Ndɨrɔ̀, kàlʉ̌ rɨ́ ndɔ̀nzɨ̀ lɛ̀màna alɛ nɨ́ɨ’ɨ́nà mbǎ atdí màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bìlǐnganà, yà ɨnga náarátɨ, ndàdʉ̀ ùbho dhu bhěyi, kǐtúnà ndɨ̀ ndàmbɛ ùbhi dɔ̌ ìndrǔ nʉ́tdʉ̌ ka karɨ́ ɨnanǎ, ndɨrɔ̀ pbìrì dɔ̀nǎ, ndàmbɛ ùkǔ dɔ̌, ndàdʉ̀ àrà ngbɔ̌na àzè rɔ̌ kpùwǎkpùwǎ odu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nɨ́ kǎla Yěsù ɨtsɛ rɔ̀, ndàdʉ̀ ɔ̀kʉ tɨna ɔ̀. Kǎdʉ̀, ndìbvu kɔ̀nzɨ̌, ndʉ̀kɔ ndɨ̀ ɔtdyʉ̀na dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kǎdʉ̀ òkù àrǐ nyʉ́ tɨ́ ndàtɨ: «Ádhu nyɨ nyòzè ma nà Yěsù, kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ Kàgàwà t’Ídhùnǎ? Ma mɨ̀tdɛ̀ nyɨ ɨ̀tdɛ̀ tɨ́, Kàgàwà-ɔvɔ̀ rɔ̌, ɨ̀nzɨ̌ àvǔ rùdú.» ");
INSERT INTO niy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wɔ̀ dhu kʉ̌nɔ okúna dɔ̀ rɔ̀ dhu nɨ́, Yěsù aránà àtɨ̀nà rɔ̌ kà nɨ̌: «Nzɛ́rɛ-alafí, áhʉ̌ wɔ̀ alɛ ɔ̀ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɨ́ Yěsù adʉ́nà àrà dhu ìvu rɔ̌ kà-tsʉ̌ ndàtɨ: «Ɔvɔ̀nʉ nɨ́ àdhɨ?» Kà ràdʉ̀ dhu àdu Yěsù tɔ̀ ndàtɨ: «Ɔvɔ̀du nɨ́ ‹Ihé›, ibí rɔ̀ mǎ mɨ́’ɨ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nɨ́, kǎdʉ́nà àrà Yěsù nónzì rɔ̌ atdyúna nyʉ́ nà, ɨ̀nzɨ̌ ɨ nzɛ́rɛ-alafí nabhʉ̀ tɨ́ ròwù ɨtsɛ ndɨ pbìrì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ányɨ̀rɔ̌, àdʉ̀ tɔ́ ádrʉ̀ngbǎ màhǒ-yà nɨ́ɨ’ɨ̀ pbìrì-ɔngɔ̀ rɔ̌ ɨ̀ ányʉ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nɨ́ ɨ nzɛ́rɛ-alafí náadʉ̀ Yěsù ɨ̀tdɛ̀ ɨ̀tdɛ̀ tɨ́, ’àtɨ: «Óvì mǎ mǒwù ndǎkà àdʉ̀ nzínzì ɔ̀, ndɨ́nɨ̌ mǎdʉ̀ tɨ́ ùtsǔ abádhí ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɨ́ Yěsù adʉ̀ ndɨ dhu ná’ù abádhí tɔ̀. Nɨ́rɔ̀ nɨ́ ndɨ kɔ̌kɔ̀ nzɛ́rɛ-alafí núuvò wɔ̀ alɛ ɔ̀ rɔ̀, ’àdʉ̀ òwu òtsù àdʉ̀ ɔ̀. Nɨ́ kɔ́rɔ́ kɔ̌kɔ̀ àdʉ̀ tɔ́ màhǒ-yà, mbɛ̀mbɛ̀ ɔ́yɔ̌ lʉfʉ̀, náadrú pbìrì-ɔngɔ̀ rɔ̌ rɔ̀, ɨ̀ rʉ̀pbà ɨ̀ rɛ̀rʉ̀ ɔ̀, tsěya rɔ̀tdɨ̀ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kɔ̌kɔ̀ àdʉ̀ nʉ́ndà rɔ̌ rúbhi alɛ náatsè, ’òwù ɔyɨ nà kɨgɔ̀ ɔ̀, ndɨrɔ̀ igigi rɨ́’ɨ̀ pbanga ɔ̀na nǎ. Nɨ́ ìndrǔ náadʉ̀ ìwu, ’ìwǔ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu àndà. ");
INSERT INTO niy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Abádhí níiwú ùvò Yěsù tɨ́, ’àdʉ̀ wɔ̀ ndɨ ibí nzɛ́rɛ-alafí arúbhi ɨ̀’ɨ̀ rɔ̌ ɔ̀nà alɛ nála. Ndɨ alɛ nɨ́ɨ’ɨ̀ obvò ndɨ̀ ndàdɨ, ndʉ̀fɔ̌ rɔ̀ná mʉ̀dzarʉ̀, pbɨ̀ndà ɨrɛ̀ta ràdʉ̀ ndàdu rɔ́. Nɨ́ ɔdɔ náadʉ̀ ɨ̀sɨ̌ abádhí ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yà ndɨ̀ nɔ̀nzɨ̀ dhu nàlanà alɛ náadʉ̀ wɔ̀ nzɛ́rɛ-alafí nà alɛ mà àdʉ̀ mànà rɔ̌ ɨ̀ nɔ̀nzɨ̀nà dhu náwɛ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nɨ́ abádhí náadʉ̀ ɔ̀pɛ̀ ’ɨ̀tdɛ̀ Yěsù ndɨ́nɨ̌ ndɨ̀ nɨvà tɨ́, ndàrà fɨ̀yɔ́ pbìrì ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nɨ́ yà Yěsù rǔpo ibhú ɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, yà nzɛ́rɛ-alafí núvònà ɔ̀nà rɔ̀ alɛ nɨ́ɨtdɛ̀ Yěsù ndɨ́nɨ̌ ’owu tɨ́ mànà atdíkpá. ");
INSERT INTO niy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nɨ́ Yěsù náa’u nzá ndɨ dhu kà tɔ̀. Pbɛ́tʉ̀ kǎdʉ̀ àtɨ̀nà ndɨ alɛ nɨ̌: «Ádǔ nyɨ pbʉ̀kʉ̀, ɨndʉ́ alɛ-tɨ’ɔ̀, nyadʉ̀ yà ɨndʉ̀ Ádrʉ̀ngbǎlɛ ɔ̀nzɨ̀ kɔ́rɔ́ dhu náwɛ abádhí tɔ̀, ɨzʉ kàbà dʉ̀nʉ́ dhu mànà.» ");
INSERT INTO niy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nɨ́ wɔ̀ alɛ náadɨ̀ dɔ̀na ndàrà, ndàdʉ̀ ndɔ̀pɛ̀ ndʉ̀nɔ̀ yà Yěsù nɔ́nzɨ̀ fɨ̌ndà kɔ́rɔ́ dhu Dɛ̀kàpolì tɨ́ kátɨna pbìrì ɔ̌. Nɨ́, yà kà rʉ̌nɔna dhu nɨ̀rɨ̀ alɛ kɔ́rɔ́ nɨ́ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tdɨ́tdɔ̌ Yěsù náadà ibhú ɔ̌ rɛ̀rʉ̀-adzè. Nɨ́ ɨdha-gì dɔ̌ kìdè rɔ́rɔ̀, ádrʉ̀ngbǎ ihé-yà náandu ndɨ̀ ndàkpɔ̀rɔ̀ kà-ngbɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nɨ́, unduta-dzà ɔ̌ ádrɔ̀drɔ̌ alɛ nzínzì ɔ̌ atdí ádrʉ̀ngbǎlɛ, Yàhirò tɨ́ kátɨna, nɨ́ɨra àhʉ ányɨ̀rɔ̌. Nɨ́ Yěsù ndɨ̀ ndàla rɔ̀, kǐbvú ndɨ̀ obvò kà-pfɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kǎdʉ̀ kɨ̀tdɛ̀ atdyúna nyʉ́ nà, ndàtɨ: «Ɨvàdú-ngba rɨ̌’ɨ̀ afína rɔ̌ ka kɔ́dɔna rɔ́. Nɨ́, ɨ́rà ɔtsʉ́nʉ nyɨ nyʉlɨ tɨ́ kà-dɔ̌, ndɨ́nɨ̌ kɔ̌gʉ́ tɨ́, ndàdʉ̀ àdɨ nyɨ̀kpɔ́na nà.» ");
INSERT INTO niy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yěsù mà náadʉ̀ òwu Yàhirò nà, ádrʉ̀ngbǎ ihé-yà ràdʉ̀ ndɨ̀dhɔ̀ owùya ɔ̌ Yěsù ɨ̀ ìpbǒ nzínzìya ɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɨ alɛ nzínzì ɔ̌ nɨ’ɨ̀ atdí tsìbhálɛ, atdí kumì dɔ̀ná ɔ́yɔ̌ nà atɔ tɨ́ azu nóongónà ɨ̀rà rɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kǎbà àpbɛ̀ abhɔ nyʉ́ ibí pbàngángá-bvʉ̀nǎ, ndàdʉ̀ kɔ́rɔ́ fɔná ongyéngá-tsè nɔ́tdɨ̀ ányɨ̀. Pbɛ́tʉ̀ ndɨ dhu adʉ́nà nzɨ̌ àrà kà dzʉ̀nà nɔ́nzɨ̀ rɔ̌, kà rɔ̌ andɨ ràdʉ̀ àrà ɔ̀trɔ rɔ̌ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nɨ́, Yěsù dɔ̌ ka kʉ́nɔna dhu ndɨ̀ ndɨ́rɨ̀ dhu-okú dɔ̀ rɔ̀, kɨ̌ra ihé-yà nzínzì ɔ̀, ndàpbàlǎ kà-rɔ̌ mʉ̀dzarʉ̀-ngbɔ̀ olùnǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ka nɨ’ɨ̀ afína ɔ̀ rɨ́rà ɔ̀tɛ rɔ̌ ndàmbɛ àtɨ̀nà dɔ̌: «Ma mapɛ́ kà-rɔ̌ mʉ̀dzarʉ̀-ngbɔ̀ nápbàlǎ, nɨ́ ma mɔ́gʉ̀ ɔ̀gʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɨ́ Yěsù rɔ̌ mʉ̀dzarʉ̀-ngbɔ̀ kàpbàlǎ rɔ́rɔ̀ tɨ́, yà kà-rɔ̌ arɨ́rà azu náadʉ̀ ìde, kà ràdʉ̀ ndìnè ɨwà ndɨ̀ ndɔ̀gʉ̀ pbɨ̀ndà andɨ ɔ̌ rɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Yěsù níinè ndɨ̀ ɨwà ìndrǔ t’ɨ́gʉ́tá tɔ́ pbɨ̀ndà ɔbɨ nɔ́nzɨ̀ kasʉ rɔ́. Nɨ́ kǎgɛ́rɛ́ ndɨ̀ ihé-yà nzínzì dɔ̀, ndìvǔ dhu ndàtɨ: «Ádhɨ rùdú mʉ̀dzarʉ̀-ngbɔ̀ nàpbàlǎ?» ");
INSERT INTO niy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nɨ́ kàbhà ábhàlɨ̌ adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Ádrʉ̀ngbǎlɛ́, nyɨ nyàla wà ihé-yà nákpɔ̀rɔ̀ ngbɔ̌nʉ ’ìpbǒ nyɨ tɨ́ dhu. Nɨ́, nyɨ tɨ́ àdʉ̀ dhu ìvu tdɨ́tdɔ̌ ràrɨ̌ àdhɨ ngbɔ̌nʉ nàpbàlǎ?» ");
INSERT INTO niy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pbɛ́tʉ̀ Yěsù adʉ̀ ndàgɛrɛ ndàndà kɔ́rɔ́ ihé-yà-dɔ̀ nga, ndɨ́nɨ̌ ndɨ̀ ndala tɨ́ ràrɨ̌ àdhɨ ndɨ dhu nɔ̀nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɨ́ ndɨ tsìbhálɛ adʉ̀ àdɨ ndàmbɛ ìvi dɔ̌ ɔdɔ nɨ̌, ɨwà ndɨ̀ ndʉ̀nɨ rɔ̀ná ndɨ̀ nɔ̀nzɨ̀ dhu nɨ́dhunɨ̌. Nɨ́ kǎdʉ̀ ɨ̀rà ndìbvǔ ndɨ̀ Yěsù-pfɔ̀-rɔ̌, ndàdʉ̀ kɔ́rɔ́ obhó dhu nʉ́nɔ̀ fɨ̌ndà. ");
INSERT INTO niy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Pbà nɨ̌ tsìbhíngbá, pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ wà nyɨ. Nɨ́, árà mběyi, nyadʉ̀ ɔ̀gʉ̀ pbʉ̀kʉ̀ àpbɛ̀ ɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wɔ̀ dhu nʉ́nɔ Yěsù rɨ̌ rɔ́rɔ̀ nɨ́ ndɨ, ɔyɨ nà ríwu unduta-dzà ɔ̌ ádrʉ̀ngbǎlɛ Yàhirò bhà rɔ̀ alɛ nʉ́ʉtɔ ɨ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Pbʉ̀kʉ̀ tsìbhíngba nɔ́vɛ̀ wà, nɨ́ ádhu nyɨ nyɨ́ Màlimò-tsì àvǎ tdɨ́tdɔ̌ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pbɛ́tʉ̀ Yěsù náadʉ̀ nzá afína mà nɨ́lɨ abádhí rʉ̌nɔna dhu dɔ̌. Kǎdʉ̀ àtɨ̀nà Yàhirò nɨ̌: «Ɨ̀nzɨ̌ ɔnzɨ ɔdɔ, ɨ́’ɨ̀ a’uta nà tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kǎdʉ̀ nzá atdí alɛ mà nózè rʉ̀ndà ndɨ̀ ányɨ̀, pbɛ́tʉ̀ kǎdʉ̀ ùnzìnà rʉ̀ndà ndɨ̀ nɨ́ Pɛ́tɛrʉ̀ mà, Yàkɔbhɔ̀ mà, adɔ̀nà Yùwanɨ̀ mànà kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nɨ́ abádhí awù ùvò unduta-dzà ɔ̌ ádrʉ̀ngbǎlɛ bhà. Nɨ́ ányɨ̀, Yěsù náatù ìndrǔ tsìya náva ɨ̀, ’àmbɛ ɔ̀dzɨ dɔ̌, ’àdʉ̀ àmbɛ ùkǔ dɔ̌ ɔrʉ́ tǔya nyʉ́ nà rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nɨ́ kǎtsù ɨdza, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu wɔ̀ dhu bhěyi tsìkʉ náva ndɨ̀ nɨ̌? Ádhu nyɨ̌ nyɔ́dzɨ nɨ̌? Yàrɨ́ ngbángba nɔ́vɛ̀ nzá, pbɛ́tʉ̀ kɔ̀dhɔ̀ ɔ̀dhɔ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pbɛ́tʉ̀, abádhí náadʉ̀ Yěsù rʉ̌nɔna dhu-gàyà ɔ̀nzɨ̀ ɔ̀nzɨ tɨ́. Nɨ́ Yěsù adʉ̀ abádhí nípfo ɨdza rɔ̀ kɔ́rɔ́, ndàdʉ̀ ndɨ ngbángba t’ábanà mà kà-tsánà, ndɨrɔ̀ pbɨ̀ndà ɨ̀bhʉ ábhàlɨ̌ mànà kɛ̀lɛ̌ núnzì, ’òtsù mànà ndɨ ngbángba-abvò rɨ̌’ɨ̀ ɔ̀nà kàluga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nɨ́ kǎlʉ́ ndɨ ngbángba ɔtsʉ́na rɔ̌, ndàdʉ̀ àtɨ̀nà nɨ̌: «Tàlità kumì.» Kà-tɨ̀ nɨ́: «Tsìbhíngbá, ma mátɨna: ‹Ɨ́và nyɨ, nyidè!›» ");
INSERT INTO niy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ tsìbhíngba nɨ́ɨvà ndɨ̀ ndìdè, ndàdʉ̀ ndɔ̀pɛ̀ ndùbhi. Obhó tɨ́, kàbhà atɔ nɨ’ɨ̀ ɨwà áhʉ atdí kumì dɔ̀ná ɔ́yɔ̌ nà atɔ tɨ́. Wɔ̀ dhu ɨ̀ àla rɔ̀, ɨdhɔ nʉ́ʉkɔ ányɨ̀rɔ̌ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yěsù adʉ̀ dhu nʉ́ya abádhí tɔ̀ atdídɔ̌, ɨ̀nzɨ̌ ndɨ dhu nabhʉ̀ tɨ́ atdí alɛ mà rʉ̀nɨ. Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà ndɨ ngbángba t’álɛ nɨ̌: «Nyàbhʉ ɔ̀nyʉ̀ akɛ kà rɔ̀nyʉ̀!» ");
INSERT INTO niy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù nɨ́ɨvà ndɨ̀ ányɨ̀rɔ̌ rɔ̀, ndàrà ndɨ̀ ndavì ɔ̀ná kɨgɔ̀ ɔ̀, pbɨ̀ndà ábhàlɨ̌ ràdʉ̀ òwu owùna ɔ̌ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɨ́ sàbatʉ̀-ɨdhɔ̀ ɔ̌, kǎdɨ̀ ndàmbɛ dhu núdhe dɔ̌ ìndrǔ tɔ̀ unduta-dzà ɔ̌ rɔ̀. Nɨ́ ábhɔ̌ alɛ yà kà rʉ̌nɔna dhu ɨ̀rɨ rɨ́, nɨ́ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. Abádhí ambɛ́nà àtɨ̀nà dɔ̌: «Kɔ́rɔ́ wɔ̀ ɔtɛ-tɨdɔ̀ nà kɨ̌rà àdhà rɔ̀? Wɔ̀rɨ́ dhu-ɔ̌nga t’óvòta-tɨdɔ̀ mà, ndɨrɔ̀ wɔ̀ wɨwɨ̀ nɔ́nzɨ kǎrɨ́ nɨ̌ ɔbɨ mànà dhu kǎbà àdhà? ");
INSERT INTO niy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tɨ́ obhó ka ndɨ sàpàtɨ, Màrɨyà t’ídhùnà? Ka tɨ́ obhó Yàkɔbhɔ̀ mà, Yɔ̌sɛ̀ mà, Yudhà mà, Sìmonì mànà t’ádɔ̀nà? Ndɨrɔ̀ kà t’áwɛ́na t’óbhó òko atdíkpá ɨrɔ́ àlɛ̌ mànà?» Nɨ́ wɔ̀ dhu-okú dɔ̀ rɔ̀, ìndrǔ nóowúnà nzɨ̌ kà rʉ̌nɔna dhu ná’ù rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nabì nɨ́fʉ̌ ka karɨ́ kɔ́rɔ́ ngari ɔ̌. Pbɛ́tʉ̀, yà ndɨ̀ nyʉ́ ka kadhɨ̀ ɔ̀ná kɨgɔ̀ ɔ̌, ndɨrɔ̀ fɨ̀ndá alɛ nzínzì ɔ̌, ndɨrɔ̀ pbɨ̀ ɨdzá-bhà nzínzì ɔ̌ màtɨ́, ka karɨ́ nzɨ̌ kɨ̀fʉ̌.» ");
INSERT INTO niy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yěsù náadʉ̀ nzá atdí wɨwɨ̀ mà nɔ́nzɨ̀ ányɨ̀rɔ̌, pbɛ́tʉ̀ kǎdʉ̀ ɔtsʉ́na nʉ́lɨ ngúfe andɨtálɛ dɔ̌ tɨ́, ɨ alɛ ràdʉ̀ ʉ̀gʉ fɨ̀yɔ́ andɨ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nɨ́ ɨdhɔ nʉ́ʉkɔ Yěsù atdídɔ̌, ɨ̀mbǎ fɨ̀yɔ́ kɨgɔ̀ ɔ̌ bhà rɨ̌’ɨ̀ a’uta nà dhu-okú dɔ̀ rɔ̀. Yěsù náaránà ùbhi rɔ̌ kɔ́rɔ́ kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ pbanga ɔ̀nǎ, ndàmbɛ dhu ùdhe dɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nɨ́ kǎnzi pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌, ndàdʉ̀ ndɔ̀pɛ̀ ndùvǐ abádhí ɔyɔ̌yɔ́ rɔ̀. Kǔví abádhí ɨwà ndɨ̀ ndàbhʉ nzɛ́rɛ-alafí nódì abádhí rǎdʉ̀ nɨ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ fɨ̌yɔ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kǎdʉ̀ dhu nʉ́ya abádhí tɔ̀ ndàtɨ: «Àpɛ́ nyìdyi atdí dhu mà abhi tɔ̀, pbɛ́tʉ̀ nyùgu mùgǒ kɛ̀lɛ̌. Àpɛ́ nyùgu mʉ̀gatì mà, bhɔlɔ mà, fʉ̀rangà mà ngbɔ̌kʉ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nyʉ̀fɔ̌ kàyìtò pfɔ̌kʉ rɔ̌, pbɛ́tʉ̀ àpɛ́ nyʉ̀fɔ̌ mbɛrʉ̀ ɔyɔ̌yɔ́ rʉ̀kʉ́.» ");
INSERT INTO niy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ndɨrɔ̀, kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ ka kàkɔ atdí ɨdza ɔ̌ rɔ̀, nyɨ̌ nyowuna òko rɔ̌ ányɨ̀-dzá, ràrà àhʉ ányɨ̀rɔ̌ rɔ̀ nyɨ̌ nyúvò nyǒwù dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Atdí pbanga ɔ̌ alɛ nóowuna gukyè ’ùvo rɔ̌ ɨ̀nzɨ̌ ’àkɔ nyɨ̌, ndɨrɔ̀ ɨ̀nzɨ̌ ’ɨ̀rɨ̀ nyɨ̌ nyʉ́nɔna dhu, nɨ́ nyɨ̌ nyowuna òwu rɔ̌ ányɨ̀rɔ̌ rɔ̀, nyǎdʉ̀ pfɔ̌kʉ-tsítsírɔ́ àhʉ̀ nɔ́’ɔ̀, ndɨ́nɨ̌ abádhí tɔ́ afátá nɨtɛ̀ tɨ́ abádhí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɨ́ kɔ̌kɔ̀ ábhàlɨ̌ náawù Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ ìndrǔ tɔ̀, ’òwù àtɨ̀nà rɔ̌, dhu ràkǎ abádhí rʉ̀gɛ̀rɛ̀ ɨ̀ ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga. ");
INSERT INTO niy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Abádhí nóowúnà ábhɔ̌ nzɛ́rɛ-alafí nípfo rɔ̌ ìndrǔ ɔ̀ rɔ̀, ’àdʉ̀ òwu andɨ nà ábhɔ̌ alɛ nútri rɔ̌ akyɛ nɨ̌, ɨ alɛ ràdʉ̀ ʉ̀gʉ. ");
INSERT INTO niy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ nɨ́ɨrɨ Yěsù dɔ̌ ka kʉ́nɔna dhu, kɔ̌vɔ̀ nɔ́tɔ̀ ndɨ̀ kɔ́rɔ́ ngari ɔ̌ nɨ́dhunɨ̌. Atdídhená alɛ nóowúnà àtɨ̀nà rɔ̌: «Bàtizò ùbho rɔ̌ arúbhi Yùwanɨ̀ nɨ́ngbɛ̀ wà ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, kǎbà wɨwɨ̀ t’ɔ́nzɨta tɔ́ ɔbɨ.» ");
INSERT INTO niy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pbɛ́tʉ̀, ngʉ̌kpà alɛ owúnà àtɨ̀nà rɔ̌: «Ɛ̀lɨyà nɨ́ wɔ̀.» Ngʉ̌kpà ràdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Angyí ɨ’ɨ̀ pbànábí nzínzì ɔ̌ atdí nabì bhěyi alɛ nɨ́ wɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Hɛ̀rɔdɛ̀ atɨ: «Bàtizò ùbho rɔ̌ arúbhi Yùwanɨ̀ nɨ́ wɔ̀. Ma mábhʉ kàdɔ kɔtdɨ̀, nɨ́ ka nɨ́ wɔ̀ wà ndɨ̀ nɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wɔ̀ ndɨ Hɛ̀rɔdɛ̀ nyʉ́ ndɨ̀tɨ́rɔ̀ nɨ́ ndɨ ʉyátá nabhʉ̀ kosò Yùwanɨ̀, ndàdʉ̀ àbhʉnà kʉtsɨ̀, kadʉ̀ ɨ̀lɨnà imbi-dzà ɔ̀. Hɛ̀rɔdɛ̀ náanzɨ̀ ndɨ dhu, adɔ̀nà Fìlipò-fɔ́ rɔ̀ ndɨ̀ ndakɔ̀ tsìbhálɛ nóokú dɔ̀ rɔ̀. Ndɨ tsìbhálɛ-ɔvɔ̀ nɨ’ɨ̀ Hɛ̀rɔ̀diyà. ");
INSERT INTO niy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kǎnzɨ̀ ndɨ dhu, Bàtizò nubhónà Yùwanɨ̀ nóongónà àdʉ̀ àtɨ̀nà kà nɨ̌, ɨnzá dhu ràkǎ kà ràkɔ adɔ̀nà-ve nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hɛ̀rɔ̀diyà náakó atdídɔ̌ Yùwanɨ̀ rɔ̌, ndàdʉ̀ kòzè ndàbhʉ kohò. Pbɛ́tʉ̀, ndɨ dhu náadʉ̀ ɨ̀’ɨ̀ odú kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Obhó tɨ́, Hɛ̀rɔdɛ̀ nóongónà Yùwanɨ̀-ɔdɔ̀ nɔ́nzɨ̀ obhónángatálɛ tɨ́, ndɨrɔ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ ɨ́lǎ alɛ tɨ́ ndɨ̀ ndʉ̀nɨ ka dhu-okú dɔ̀ rɔ̀. Nɨ́ kǒngónà àdʉ̀ Yùwanɨ̀-ngbɔ̀ nɔ́dɔ̀ atdídɔ̌. Yùwanɨ̀ rʉ̌nɔna dhu nɨ́rɨ ndɨ̀ ndɨ́ rɔ̀, Hɛ̀rɔdɛ̀ bhà ɨrɛ̀ta nóongónà àdʉ̀ ndɨ̀nza atdídɔ̌, pbɛ́tʉ̀ kǒngónà àdʉ̀ kà rʉ̌nɔna dhu òzè ndɨ̀rɨ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nɨ́ atdíku, Hɛ̀rɔ̀diyà náabà Yùwanɨ̀ àbhʉ̌ ndɨ̀ ndɨ́ kohò ɔ̀ná otu. Ndɨ dhu nɨ’ɨ̀ yà Hɛ̀rɔdɛ̀ rɨ̌ ndɨ̀ ka kadhɨ̀ ɔ̀ná ɨdhɔ nɨ́rɛ̀ ɔ̀ná mʉ̀hɛndʉ̀-ɨdhɔ̀ ɔ̌ dhu. Nɨ́ Hɛ̀rɔdɛ̀ unzi rìwǔ ndɨ mʉ̀hɛndʉ̀ ɔ̀ alɛ nɨ’ɨ̀: yà ɨ̀ arɨ́ kasʉ ɔ̀nzɨ mànà ádrɔ̀drɔ̌ alɛ mà, pbɨ̀ndà pbànówí tɔ́ ádrɔ̀drɔ̌ alɛ mà, ndɨrɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ pbangá-nzo ɔ̀nǎ arɨ́’ɨ̀ ɨfʉta nà atdídɔ̌ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nɨ́ Hɛ̀rɔ̀diyà bhà tsìbhíngba náatsù mʉ̀hɛndʉ̌-dzà ɔ̀, ndàdʉ̀ ɔ̀bɛ̀ atdídɔ̌. Ndɨ ɔbɛ́ náafɔ̀ Hɛ̀rɔdɛ̀-nyɨ̀kpɔ́ atdídɔ̌ yà ndɨ̀ ndùnzìnà alɛ mànà. Nɨ́ ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ adʉ̀ àtɨ̀nà wɔ̀ tsìbhíngba-ɔwʉ́ nɨ̌: «Ónzi afínʉ òzè dhu fudú, nɨ́ ma mɨ́ ndɨ dhu àbhʉ̌ àbhʉ̌ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kǎdʉ̀ dhu nɔ́tsɔ̀ ndɨ tsìbhíngba-ɔ̀nzɨ̌ ndàtɨ: «Ma mɔ̀tsɔ̀ wà dhu ndɨ́nɨ̌ ma mabhʉ̀ tɨ́ nyɨ nyónzina dhu ɨndʉ̀, ɨ̀mbǎ ɨ’ɨna yà idzi ma mɔ́nyʉ̀ dɔ̀ná pbìrì tɔ́ atdínga ɔ́yɔ̌ dɔ̌ mà nábhʉ̌ ma mɨ́ ɨndʉ̀ dhu màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nɨ́ wɔ̀ tsìbhíngba náahʉ̀ àwú-dza rɔ̀, ndàdʉ̀ dhu nívu ɨ́yànà-tsʉ̌ ndàtɨ: «Ádhu ndɨ ma màkǎ monzì?» Nɨ́ kà-tsánà adʉ̀ dhu àdu ndàtɨ: «Bàtizò núbhǒ arɨ́ Yùwanɨ̀-dɔ.» ");
INSERT INTO niy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nɨ́ tsìbhíngba náangbó ndɨ̀ kòmbómbí ádrʉ̀ngbǎ kamà-tɨ’ɔ̀, ndàdʉ̀ dhu ònzì fɔná ndàtɨ: «Ma mòzè nyibhò Bàtizò ùbhǒ arɨ́ Yùwanɨ̀-dɔ kòmbí fudú tsàlɨ̀tsalɨ̀ dɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nɨ́ ɨzʉ nʉ́ʉka ádrʉ̀ngbǎ kamà atdídɔ̌ nyʉ́. Pbɛ́tʉ̀, kà rɨ̌ ndùvǒ Yùwanɨ̀-dɔ rɔ̌ dhu nɨ́ɨ’ɨ̀ ɔbɨ tɨ́, yà ndɨ̀ ndùnzìnà alɛ-ɔ̀nzɨ̌ rɔ̀ ndɨ̀ ndɔ̀tsɔ̀nà dhu dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, kǎdʉ̀ ngbɔ̌na nɔ́dɔ arɨ́ pbànówí nzínzì ɔ̌ atdí mùnowì nóvì, ndʉ̀yǎ dhu fɨ̌ndà ndɨ́nɨ̌ ɨra tɨ́ Yùwanɨ̀-dɔ nà fɔná. Nɨ́ wɔ̀ mùnowì nɨ́ɨvà ndɨ̀ ndàrà imbi-dzà ɔ̀, ndìtsì Yùwanɨ̀-dɔ nɔ́kɛ̀rɛ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ɨ̀rà ndɨ alɛ-dɔ nà tsàlɨ̀tsalɨ̀ dɔ̌ rɔ̀, ndàdʉ̀ àbhʉnà wɔ̀ tsìbhíngba-fɔ́, ndɨ tsìbhíngba ràdʉ̀ àbhʉnà ɨ́yànà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nɨ́ Yùwanɨ̀ bhà ábhàlɨ̌ níitdègu wɔ̀ dhu nɨ́rɨ, nɨ́ abádhí adʉ̀ ìwu, ’àdʉ̀ kǎ-bvò nídyì ’òwù ɔ̀tdʉ̀nà. ");
INSERT INTO niy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yěsù bhà uvitatálɛ náandu ɨ̀ kà-tɨ́, ’àdʉ̀ yà ɨ̀ ɔ̀nzɨ̀ kɔ́rɔ́ dhu mà, ndɨrɔ̀ yà ɨ̀ ùdhe ìndrǔ tɔ̀ kɔ́rɔ́ dhu mànà dhu náwɛ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, abádhí-tɨ’ɔ̀ ríwu alɛ mà, abádhí tɨ́ ɔ̀ rɔ̀ rɨ́ ’àdǔ alɛ mànà nɨ́ɨ’ɨ̀ abhɔ nyʉ́, ɔ̀nyʉ̀ nɔ́nyʉ abádhí rɨ̌ ɔ̀ná kàsʉmɨ̀ mà ràdʉ̀ ɨ̀’ɨ̀ mbǎ. Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà uvitatálɛ nɨ̌: «Nyìwǔ rʉ̀ngʉ̀ tɨ́ rɨ́’ɨ̀ atdí ngari ɔ̀, ndɨ́nɨ̌ nyɨ̌ nyaso tɨ́ nyɨ̌ akɛ.» ");
INSERT INTO niy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nɨ́ abádhí náadʉ̀ òwu vǐyà dɔ̌ rɔ̀ ibhú ɔ̌ rʉ̀ngʉ̀ tɨ́ rɨ́’ɨ̀ atdí ngari ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pbɛ́tʉ̀, ábhɔ̌ alɛ nyʉ́ náala abádhí rǒwu dhu, ’àdʉ̀ abádhí rǒwu ɨ nga nʉ́nɨ. Nɨ́ ìndrǔ náadʉ̀ ’ɨ̀và kɔ́rɔ́ kɨgɔ̀ ɔ̀nǎ rɔ̀, ’òwù tsàkàtsàkà nyʉ́ pfɔ̌ya dɔ̌ ányɨ̀, ’àdʉ̀ òwu ùvò angyi abádhí rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nɨ́ Yěsù náhʉ ibhú ɔ̀ rɔ̀ rɔ̀, kǎla wɔ̀ ádrʉ̀ngbǎ ihé-yà, abádhí-ɨzʉ̀ ràdʉ̀ ndàlʉ atdídɔ̌, ɨ̀mbǎ ʉ̀ndana rɨ́ alɛ rɨ̌’ɨ̀ tàmà tɔ́ màhò bhěyi abádhí nʉ́lɨ ɨ̀ nɨ́dhunɨ̌. Yěsù adʉ̀ àdɨ ndàmbɛ ábhɔ̌ dhu nyʉ́ núdhe dɔ̌ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɨnga rǎtɨ dhu níitdègu ndìndù, nɨ́ kàbhà ábhàlɨ̌ níindri kà-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨrɔ́ nga rɨ̌’ɨ̀ rʉ̀ngʉ̀ tɨ́, ndɨrɔ̀ ɨnga nátɨ wà.» ");
INSERT INTO niy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɨ́, ávǐ kɔ̌kɔ̀ alɛ ròwù ɨnga nóbhì ka karɨ́ ɔ̀yà ngari ɔ̀, ndɨrɔ̀ kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ pbanga ɔ̀, ndɨ́nɨ̌ ɔ̀nyʉ̀ nudzí tɨ́ fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yěsù adʉ̀ ɔtɛ nádu abádhí tɔ̀ ndàtɨ: «Nyàbhʉ ɔ̀nyʉ̀ abádhí tɔ̀ nyɨ̌-tɨ́rɔ̀!» Nɨ́ ábhàlɨ̌ náadʉ̀ dhu nívu Yěsù-tsʉ̌ ’àtɨ: «Nyɨ nyòzè tɨ́ mǒwù mʉ̀gatì nódzì ɔ́yɔ̌ mɨyà dɨ̀narɨ̀ rɔ̌, ndɨ́nɨ̌ mǎ mabhʉ̀ tɨ́ abádhí rɔ̀nyʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nɨ́ Yěsù adʉ̀ dhu nívu abádhí-tsʉ̌, ndàtɨ: «Ífe mʉ̀gatì nyɨ̌ nyɨ́’ɨ̀ nà? Nyàndà pɛ́ ka.» Nɨ́ kà-bvʉ ɨ̀ ʉ̀nɨ rɔ̀, abádhí adʉ̀ dhu nádu kà tɔ̀ àtɨ: «Mǎ mɨ́’ɨ̀ imbò mʉ̀gatì nà, ndɨrɔ̀ ɔ́yɔ̌ ɨ̀bhɛ̀ nà.» ");
INSERT INTO niy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wɔ̀ dhu-dzidɔ̌, Yěsù avì pbɨ̀ndà ábhàlɨ̌ ràbhʉ kɔ́rɔ́ alɛ ròkò tsʉ̀na rɔ̌ obvò ɨrɨ́ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Abádhí adʉ̀ òko tsʉ̀na tɨ́: atdídhená ngari ɔ̌ atdátdí mɨyà alɛ, ndɨrɔ̀ ngʉ̌kpà ngari ɔ̌ imbìmbó kumì alɛ. ");
INSERT INTO niy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù núugu kɔ̌kɔ̀ imbò mʉ̀gatì, ɔ́yɔ̌ ɨ̀bhɛ̀ mànà ndʉ̀lʉ̌ fɔná. Nɨ́, ɔ̀rʉ̀-akpà ɔ̀ nga àndà ndɨ̀ ndɨ́ rɔ́rɔ̀, kǎdʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀. Kǎdʉ̀ mʉ̀gatì-ɔ̌nga nʉ́kɔ, ndùbho pbɨ̀ndà ábhàlɨ̌-fɔ́, ndɨ́nɨ̌ abádhí nʉ́ʉndɔ tɨ́ ìndrǔ tɔ̀. Kǎdʉ̀ kɔ̌kɔ̀ ɔ́yɔ̌ ɨ̀bhɛ̀ nʉ́ndɔ̀ átɔ̀ abádhí-fɔ́ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ányɨ̀rɔ̌ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ náanyʉ̀ dhu ’ùlè nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yěsù bhà ábhàlɨ̌ náadʉ̀ ɔ̀dɨ̀ ɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀ núndu, ɨ̀bhɛ̀-go mànà, ’àdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà sɛ̌ngɛ̀ nɨ́ra nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ndɨ mʉ̀gatì nanyʉ̀ alɛ nzínzì ɔ̌, kpabhálɛ nɨ́ɨ’ɨ̀ imbò lʉfʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wɔ̀ dhu-dzidɔ̌ tɨ́, Yěsù náabhʉ̀ pbɨ̀ndà ábhàlɨ̌ rùpò ibhú ɔ̀, ndɨ́nɨ̌ ada tɨ́ angyi fɨ̌ndà rɛ̀rʉ̀-adzè, Bɛ̀tɛ̀sàyidà tɔ́ kɨgɔ̀ ɨnǎ rɔ̀, yà ndɨ̀ nyʉ́ tɨ́rɔ̀ ndɨ̀ ndɨ́ ihé-yà návǐ ròwù ɨbha ɔ̀nanǎ. ");
INSERT INTO niy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ihé-yà nà ɨ̀ ʉ̀bhǎ ɨ̀ dhu-dzidɔ̌, kǎdʉ̀ àrà pbìrì dɔ̀, ndàrà ndɨ̀tsɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɨnga nátɨ rɔ̀, ibhú nɨ́ɨ’ɨ̀ rɛ̀rʉ̀-alìkpa ɔ̀ ábhàlɨ̌ nà, Yěsù ràdʉ̀ ndʉ̀bhà atdírɔ̀ olù ɨdha-adzè. ");
INSERT INTO niy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nɨ́ Yěsù ala ɔbɨ tɨ́ ibhú t’ɔ́tʉ̀ta rɨ̌’ɨ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀ dhu, tʉ̀mbà tɨ́ awɛ rǒpili abádhí-nyɨ̀kpa rɔ̌ nɨ́dhunɨ̌. Nɨ́ à’ʉ̌-akpà-ɔ̀ngɔ̌ ɔ̌, kǎrà pbɨ̀ndà ábhàlɨ̌-tɨ’ɔ̀, ndàmbɛ ùbhi dɔ̌ ɨdha dɔ̌. Kǎdʉ̀ dhu ɔ̀nzɨ̀ angyi ndʉ́da abádhí tɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nɨ́, kà rǔbhi ɨdha dɔ̌ dhu ɨ̀ àla rɔ̀, abádhí náadʉ̀ kàtɨ̀ mɨ̀gɨ̀ngɔ̀ tɨ́, ’àdʉ̀ ’ɔ̀pɛ̀ ’ùkǔ, ");
INSERT INTO niy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ábhɔ̌ ɔdɔ nyʉ́ nà kàlǎ rɨ́ kɔ́rɔ́ alɛ nɨ́ɨ’ɨ̀ nɨ́dhunɨ̌. Pbɛ́tʉ̀ ʉrɔ́ rɔ̀ tɨ́, Yěsù adʉ̀ tǔna àpfò abádhí tɔ̀ ndàtɨ: «Nyòtù afíkʉ, ɨma nɨ́ yà! Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ!» ");
INSERT INTO niy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tdɨ́tdɔ̌, kǎdʉ̀ ùpo ibhú ɔ̀ abádhí-tɨ’ɔ̀, awɛ ràdʉ̀ opilita nʉ́bhà atdídɔ̌. Nɨ́ ɨdhɔ nʉ́ʉkɔ abádhí atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Obhó tɨ́, Yěsù ɔ̀nzɨ̀ wɨwɨ̀, ndɨ̀trɔ̌ mʉ̀gatì dhu náalʉ́ nzá abádhí-dɔ: abádhí tɔ́ ɨrɛ̀ta rɨ̌ ndɨ dhu-tɨ̀ nálʉ̌ dhu nɨ́ɨ’ɨ̀ odú. ");
INSERT INTO niy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà níitdègu rɛ̀rʉ̀ náda, nɨ́ abádhí náasò fɨ̀yɔ́ ibhú kìfukù ɔ̌, ’àdʉ̀ òtsù Gɛ̀nɛ̀zàretì tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nɨ́ ibhú ɔ̀ rɔ̀ abádhí núvò rɔ́rɔ̀ tɨ́, ìndrǔ náadʉ̀ Yěsù nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nɨ́ abádhí náadʉ̀ àngɨlɨ kɔ́rɔ́ ndɨ pbìrì ɔ̀nǎ, ’àdʉ̀ ’ɔ̀pɛ̀ ’ʉ̀mbà andɨtálɛ, ’òwù òwu rɔ̌ nà ótdù dɔ̌, Yěsù-bvʉ ka kɔ̀’ɨ̀ ɔ̀yà kɔ́rɔ́ ngari ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ndɨrɔ̀, kɔ́rɔ́ ngari ɔ̌ Yěsù rǔbhi ɨnanǎ, pbanga ɔ̀nǎ, kɨgɔ̀ ɔ̀nǎ, ndɨrɔ̀ ɨnga nóbhì ka karɨ́ ɨnǎ màtɨ́, ìndrǔ nóowúnà ìwu rɔ̌ andɨtálɛ nà, ’ʉ̀lɨ pbanga-tsidɔ̌ ìndrǔ náarɨ́ ’ùndǔ ɔ̀yá ngari ɔ̌. Abádhí adʉ́nà òwu Yěsù nónzì rɔ̌ rʉ̀bhà ɨ alɛ rʉ̀pbàlǎ rɔ̀ná mʉ̀dzarʉ̀-bɨdɔ̀-ngbɔ̀ kɛ̀lɛ̌. Nɨ́ ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà yà kàbhà mʉ̀dzarʉ̀-bɨdɔ̀-ngbɔ̀ nàpbàlǎ, náaránà ɔ̀gʉ̀ rɔ̌ dòtsí. ");
INSERT INTO niy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pbàfàrìsáyó mà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀ ìwǔ Músà bhà Ʉyátá tɔ́ ngúfe màlímó mànà núundu ɨ̀ Yěsù tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nɨ́, abádhí náala Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ ngʉ̌kpà alɛ, ɔ̀tɔ̀tɨ̀ ɔtsʉ́ya nɨ̌ rówu dhu nɔ́nyʉ̀ rɔ̌, kà-tɨ̀ nɨ́ ɨnzá ɨ̀ ù’o ɔtsʉ́ya yà fɨ̀yɔ́ sɔmà tɔ́ màndʉ nónzì ka dhu bhěyi rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pbàfàrìsáyó mà, kɔ́rɔ́ ngʉ̌kpà Pbàyàhúdí mànà nɨ́ɨfʉ abhúya tɔ́ màndʉ atdídɔ̌. Nɨ́, abádhí nɔ́ɔnyʉ́nà nzɨ̌ ɔ̀nyʉ̀ ɨnzá ɨ̀ ù’o ɔtsʉ́ya mběyi nyʉ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ndɨrɔ̀ kòbǐ ɔ̀ rɔ̀ ɨ̀ ìngò rɔ̀, abádhí nɔ́ɔnyʉ́nà nzɨ̌ dhu ɨnzá ɨ̀ ù’o ɨ̀ rɔ́rɔ̀. Abádhí nɨ́ɨfʉ yà ɨ́ abà ábhɔ̌ ngʉ̌kpà màndʉ átɔ̀. Ɨ màndʉ nɨ’ɨ̀: kɔ́pà nú’ǒ ka kɨ́ mběyi nyʉ́ dhu, ɨ̀tǎ mà, sʉma nɨ̌ ka kɔ́bhɔ̀lɔ̀ ɨ̀tǎ mà, dɔ̀yá ka karóyì dhu mànà nú’ǒ ka kɨ́ mběyi nyʉ́ dhu mànà. ");
INSERT INTO niy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nɨ́, Pbàfàrìsáyó mà Músà bhà Ʉyátá tɔ́ màlímó mànà níivú dhu Yěsù-tsʉ̌ ’àtɨ: «Ádhu ɨnzá pbʉ̀kʉ̀ ábhàlɨ̌ nɨ́fʉ àlɛ̌ t’ábhúna tɔ́ màndʉ, ’àdʉ̀ àmbɛ dhu nɔ́nyʉ̀ dɔ̌ ɔ̀tɔ̀tɨ̀ ɔtsʉ́ya nɨ̌ nɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nabì Ìsayà nʉ́ʉnɔ obhó dhu nyʉ́ dʉ̀kʉ́. Nyɨ̌ nɨ́ ɔyɔyɔ afíya nà alɛ yà kǎndí dhu bhěyi tɨ́, ndàtɨ: ‹Kàgàwà rǎtɨna: kàrɨ́ alɛ náarɨ́ mɨfʉ̌ tsʉ̀ya ɔ̌ tɨ́, afíya ràdʉ̀ ɨ̀ ɨtsɛ nyʉ́ rùdú rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Abádhí náarɨ́ mʉlɛ̌ kɔkɔ́rɔ̀. Abádhí arúdhěna ìndrǔ tɔ̀ dhu nɨ́ ìndrǔ tɔ́ ʉyátá kɛ̀lɛ̌.›» ");
INSERT INTO niy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̌ nyárɨ́ Kàgàwà bhà Ʉyátá nʉ́bha igi, nyǎdʉ̀ nyǎpba ìndrǔ ɔ́vɔ̀ fʉ̌kʉ̀ dhu rɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nyɨ̌ nyárɨ́ Kàgàwà bhà Ʉyátá nɔ́dhɔ, nyǎdʉ̀ afíkʉ nápba fʉ̀kʉ́ màndʉ rɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Obhó tɨ́, Músà nʉ́ʉyá dhu fʉ̌kʉ̀ ndàtɨ: nyɨ ràkǎ nyɨfʉ àbanʉ mà ɨ́yànʉ mànà, ndɨrɔ̀ àbanà mà ɨ́yànà mànà nɨ̌ dhu nʉ̀nɔ̀ alɛ ràkǎ kohò òho tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pbɛ́tʉ̀ nyɨ̌ nyʉ́, nyɨ̌ nyárɨ́ dhu ɔ̀vɔ ìndrǔ tɔ̀ nyǎtɨ: ndɨ alɛ rapɛ́ dhu ʉ̀nɔ kpangba àbanà tɔ̀, ndɨrɔ̀ ɨ́yànà tɔ̀ màtɨ́ ndàtɨ: ‹Dzʉ̀nànʉ nɔ́nzɨ ma màmbɛ̀nà nɨ̌ fudú rɨ́’ɨ̀ dhu nɨ́ Kɔ̀rbanɨ̀, kà-tɨ̀ nɨ́: Kàgàwà tɔ̀ ka kùtri pɛrɛ̀.› ");
INSERT INTO niy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nɨ́ ndɨ alɛ rɨ̌ mbǎ àbanà mà, ndɨrɔ̀ ɨ́yànà mà dzʉ̀nà nɔ́nzɨ ndɨ̀ ndɨ́ dhu-atdyú nà. Nɨ́ nyɨ̌ nyarádʉ̀ ndɨ dhu kɛ̀lɛ̌ ná’ù ndɨ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nɨ́ ndɨ dhu nɨ̌, nyɨ̌ nyárɨ́ Kàgàwà bhà ɔtɛ-òvǔ nɨ́tɔ, yà nyɨ̌ nyarúdhěna fʉ̌kʉ̀ nzínzìkʉ ɔ̌ fʉ̀kʉ́ màndʉ nɨ̌. Ndɨrɔ̀, nyɨ̌ nyarɨ́ ndɨ dhu bhěyi dhu-tɨdɔ̀ nɔ́nzɨ abhɔ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wɔ̀ dhu-dzidɔ̌, Yěsù náanzi ihé-yà tdɨ́tdɔ̌, ndàdʉ̀ àtɨ̀nà nɨ̌: «Nyɨ̌ kɔ́rɔ́, nyɨ̀rɨ yà ma mʉ́nɔna fʉ̌kʉ̀ dhu, ndɨrɔ̀ nyàlʉ̌ ka dʉ̀kʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ɨ̀nzɨ̌ iri rɔ̀ rótsù ìndrǔ ɔ̀ atdí dhu mà, rǎdʉ̀ ìndrǔ nábhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. Pbɛ́tʉ̀, ìndrǔ-afí ɔ̀ rɔ̀ àhʉ dhu nɨ́ ndɨ kàbhʉ rádʉ̀ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ, nákǎ ndɨ̀rɨ̀ wɔ̀ ma mʉ̀nɔ̀ dhu.» ");
INSERT INTO niy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yěsù níitdègu ihé-yà nʉ́bha ndàdʉ̀ òtsù ɨdza, nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ wɔ̀ ndɨ mbólí-tɨ̀ nívu kà-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyʉ́ mà, kàlʉ̌ t’óbhó dʉ̀kʉ átɔ̀? Nyɨ̌ nyʉ̀nɨ t’óbhó dhu, ɨ̀nzɨ̌ iri rɔ̀ rótsù ìndrǔ ɔ̀ atdí dhu mà ràrǎdʉ̀ ìndrǔ nábhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌? ");
INSERT INTO niy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Obhó tɨ́, ndɨ dhu nótsù nzá ndɨ alɛ-afí ɔ̀, pbɛ́tʉ̀ kòtsù ndɨ alɛ-fi-tsʉ̀ ɔ̀, ndàdʉ̀ àhʉ kà-ɔ̀ rɔ̀ ɔtsɔ́ dɔ̀ ndɨ alɛ àrà rɔ̀.» Wɔ̀ ndɨ̀ ndʉ̀nɔ̀ ɔtɛ ɔ̌, Yěsù náavɔ̀ dhu kpangba ɔ̀nyʉ ka ràrǎdʉ̀ kɔ́rɔ́ ɔ̀nyʉ̀-tɨdɔ̀ nɔ́nyʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɨ́ kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ìndrǔ-afí ɔ̀ rɔ̀ àhʉ dhu nɨ́ ndɨ rádʉ̀ ìndrǔ nábhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Obhó tɨ́, ìndrǔ-afí ɔ̀ rɔ̀ arúvò nzɛ́rɛ ɨrɛ̀ta náarɨ́ ndɨ ìndrǔ nábhʉ̌ rɔ̀nzɨ̀ nzɛ́rɛ dhu. Ɨ nzɛ́rɛ dhu nɨ́: mʉ̀nyɔ̀nɨ̀ t’ɔ́nzɨta, ogbo t’ɔ́nzɨta, abvo t’óhota, ");
INSERT INTO niy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","màkunì t’ɔ́nzɨta, ngǎtsi alɛ-fɔ́ rɨ́’ɨ̀ dhu dɔ̌ ka kɨ́ alɛ-afí ɨ̀lɨ̌ dhu, ɔ̀rʉ̀ ka kɔ́rʉ̀ dhu, ìndrǔ t’ʉ́trátá, ɨ̀nzɨ̌ ka kɨ́ ʉyátá-ɔdɔ̀ nɔ́nzɨ dhu, adha t’ɔ́nzɨta, ìndrǔ nɨ̌ ka kɨ́ dhu ʉ̀nɔ nzɛ́rɛ dhu, alɛ ɔ̀yɔ̀ ka kɨ́ dhu, àrǐ bhěyi ka kɨ́ alɛ ɔ̀nzɨ dhu. ");
INSERT INTO niy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kɔ́rɔ́ kɔ̀rɨ́ nzɛ́rɛ dhu náarúvò ìndrǔ-afí ɔ̀ rɔ̀, ràdʉ̀ ìndrǔ nábhʉ rɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ʉrɔ́ rɔ̀, Yěsù ɨvà ndɨ̀ ndàrà Tirò tɨ́ kátɨna kɨgɔ̀ tɔ́ mʉ̀lɛngʉ̀ ɔ̀. Nɨ́ kǎtsù atdí ɨdza ɔ̀, ɨ̀nzɨ̌ ndàdʉ̀ atdí alɛ mà nózè rʉ̀nɨ ányɨ̀rɔ̌ ndɨ̀ ndɨ́’ɨ̀ dhu. Pbɛ́tʉ̀, kà rɨ̌ ndòru dhu nɨ́ɨ’ɨ̀ odú. ");
INSERT INTO niy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Obhó tɨ́, atdí tsìbhálɛ yà nzɛ́rɛ-alafí náarávu pbɨ̀ndà tsìbhíngba rɔ̌, nɨ́ɨrɨ Yěsù dɔ̌ ka káwɛ̌na dhu. Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, ɨ́yàdhíyà náadʉ̀ ɨ̀rà Yěsù-tɨ’ɔ̀, ndàdʉ̀ ndìbvu obvò kàpfɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ndɨ tsìbhálɛ nɨ’ɨ̀ ɨ̀nzɨ̌ nɨ́ Mùyàhudì-àyi, pbɛ́tʉ̀ ka nɨ’ɨ̀ Sìrò-Fòyìnikì tɔ́ pbìrì ɔ̌ alɛ. Nɨ́ kɨ̌tsɔ̀ ndɨ̀ Yěsù rɔ̌, ndɨ́nɨ̌ nzɛ́rɛ-alafí nipfo tɨ́ pbɨ̀ndà tsìbhíngba ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ʉ́bhà pɛ́ nzónzo rɔ̀nyʉ̀ dhu ’ùlè nɨ̌ angyi. Obhó tɨ́, dhu ɔ̀fɔ̀ nzá nga kidyì nzónzo tɔ́ ɔ̀nyʉ̀, kadʉ̀ òbvùnà ìtsě-nzo tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɨ́yàdhíyà náadʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Obhó Ádrʉ̀ngbǎlɛ, pbɛ́tʉ̀ mɨzà tsìnǎ rɨ́’ɨ̀ ìtsě mà náarɨ́ nzónzo-fɔ́ rɔ̀ ɨ̀ nàwà ɔ̀nyʉ̀-ú’ǔ-nzo mà nɔ́nyʉ.» ");
INSERT INTO niy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Wɔ̀ nyɨ nyàdu ɔtɛ-okú dɔ̀ rɔ̀, ádǔnà nyɨ pbʉ̀kʉ̀, ɨwà nzɛ́rɛ-alafí náhʉ pbʉ̀kʉ̀ tsìbhíngba ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nɨ́ kǎdù ndɨ̀ pbɨ̀ndà, ndàdʉ̀ pbɨ̀ ɨngba nótù ara dɔ̌ àyi rɔ́, ɨwà nzɛ́rɛ-alafí náhʉ ɔ̀nà rɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù ɨvà ndɨ̀ tdɨ́tdɔ̌ Tirò tɔ́ mʉ̀lɛngʉ̀ ɔ̌ rɔ̀, ndʉ̀dà Sìdɔnà tɔ́ kɨgɔ̀ ɔ̀nǎ, ndàdʉ̀ ìngo Gàlìlayà tɔ́ rɛ̀rʉ̀-bɨdɔ̀, Dɛ̀kàpolì tɔ́ pbìrì ɔ̀nǎ ndɨ̀ ndʉ̀dà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nɨ́, ka kiwú ɨ̀nzɨ̌ bɨ̌na arɨ́ nga ɨ̀rɨ, ndɨrɔ̀ ɨ̀nzɨ̌ arɔ́tɛ mběyi atdí alɛ nà Yěsù tɨ ’ɔ̀. Ka kadʉ̀ kɨ̀tdɛ̀ ɨ̀tdɛ̀ tɨ́, ndɨ́nɨ̌ ɔtsʉ́na nɨlɨ tɨ́ ndɨ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nɨ́ Yěsù náadʉ̀ kìdyì atdírɔ̀ ndàrànà lɛ̀ngɛ̀lɛ̀ngɛ̀ ihé-yà ɔ̌ rɔ̀. Kǎdʉ̀ ɔtsʉ́na-kpɔ̀ nʉ́fɔ wɔ̀ alɛ-bɨ̀ ɔ̀, ndàdʉ̀ ɨsɔ nísò ɔtsʉ́na-kpɔ̀ rɔ̌, ndàpbàlǎ kɨ̌dà-dɔ-ngbɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tdɨ́tdɔ̌, Yěsù andà ɔ̀rʉ̀-akpà ɔ̀ nga, ndàdha ɨhɛ̀na, ndàdʉ̀ àtɨ̀nà wɔ̀ alɛ nɨ̌: «Ɛ̀fatà!» Kà-tɨ̀ nɨ́ «Ángbɛ̌ nyɨ!» ");
INSERT INTO niy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nɨ́ ʉrɔ́ rɔ̀ tɨ́, wɔ̀rɨ́ alɛ-bɨ̀ nʉ́ʉngbɛ ɨ̀, ɨdàna ràdʉ̀ ɔ̀’ɔ ɨsɔ́ ɔtɛ tɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀ mběyi. ");
INSERT INTO niy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yěsù adʉ̀ kɔ́rɔ́ alɛ nɨ́sɔ ɨ̀nzɨ̌ ndɨ dhu nʉnɔ tɨ́ atdí alɛ tɔ̀ màtɨ́, pbɛ́tʉ̀ yà kàrɨ̌ abádhí nɔ́sɔ̀ dhu náaránà ìndrǔ názɨ rɔ̌ àzɨ̌ tɨ́ ràmbɛ ɔ̀tɛ dɔ̌ ndɨ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nɨ́ ɨdhɔ náadʉ̀ abádhí nʉ́kɔ atdídɔ̌ nyʉ́ ròsè, ’àmbɛ àtɨ̀nà dɔ̌: «Kà rɔ̌nzɨna dhu nɨ́ kɔ́rɔ́ ídzì dhu nyʉ́. Ndɨrɔ̀, kà rǎrà bɨ̌ya ʉ́rɨ̌ alɛ-bɨ̀ mà nʉ́ngbɛ rɔ̌, ndàdʉ̀ ɨ̀nzɨ̌ arɔ́tɛ alɛ mà nábhʉ rɔ̀tɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ndɨ nɨ́nganɨ́, ádrʉ̀ngbǎ ihé-yà náandu ɨ̀ tdɨ́tdɔ̌. Nɨ́ ɨ̀mbǎ abádhí rɨ̌’ɨ̀ ɔ̀nyʉna ɨ̀ ɨ́ dhu nà nɨ́dhunɨ̌, Yěsù anzi pbɨ̀ndà ábhàlɨ̌ ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: ");
INSERT INTO niy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ma mɨ́’ɨ̀ ɨzʉ nà atdídɔ̌ kǎkà alɛ dɔ̌. Mǎ mòkò wà abádhí mànà ɨ̀bhʉku mbàlìmbàlì, ndɨrɔ̀ abádhí rɨ̌ mbǎ ɨ̀’ɨ̀ ɔ̀nyʉna ɨ̀ ɨ́ dhu nà. ");
INSERT INTO niy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma mapɛ́ abádhí àvǐ ròwù àwù nà fɨ̀rábvʉ̀, nɨ́ sàzɨ̀ rǎrà abádhí nábhʉ ràwà ɨ̀ otu ɔ̌. Obhó tɨ́, abádhí nzínzì ɔ̌ atdídhená alɛ níwǔ ɨtsɛ rɔ̀ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nɨ́, kàbhà ábhàlɨ̌ náadʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Ka kówu abádhí nóngù ka kɨ́ nɨ̌ ɔ̀nyʉ̀ nótù àdhà yàrɨ́ rʉ̀ngʉ̀ ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Nyɨ̌ nyɨ́’ɨ̀ mʉ̀gatì nà ìfe?» Nɨ́ abádhí adʉ̀ dhu àdu ’àtɨ: «Mǎ mɨ́’ɨ̀ mʉ̀gatì nà àrʉ̀bhʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nɨ́ Yěsù avì ihé-yà ròkò obvò. Kǎdʉ̀ kɔ̌kɔ̀rɨ́ àrʉ̀bhʉ̀ mʉ̀gatì núgù ndʉ̀lʉ̌ fɔná, ndàdʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ɨ mʉ̀gatì-ɔ̌nga nʉ́kɔ ndùbho pbɨ̀ndà ábhàlɨ̌-fɔ́, ndɨ́nɨ̌ abádhí ʉndɔ tɨ́ ihé-yà tɔ̀. Nɨ́ ɨ ábhàlɨ̌ náadʉ̀ ɨ mʉ̀gatì nʉ́ndɔ̀ ɨ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Abádhí nɨ́ɨ’ɨ̀ ngúfe ɨ̀bhɛ̌-nzo nà átɔ̀. Nɨ́ Yěsù adʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀ kɔ̌kɔ̀rɨ́ ɨ̀bhɛ̀ dɔ̌, ndàdʉ̀ pbɨ̀ndà ábhàlɨ̌ návi rʉ̀ndɔ̀ ɨ ɨ̀bhɛ̌-nzo átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kɔ́rɔ́ alɛ náanyʉ̀ dhu ’ùlè nɨ̌ àkǎkǎ dhu bhěyi. Nɨ́ ábhàlɨ̌ náadʉ̀ ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀ núndu, rùlè àrʉ̀bhʉ̀ sɛ̌ngɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ányɨ̀rɔ̌, ìndrǔ nɨ́ɨ’ɨ̀ mbɛ̀mbɛ̀ ɨ̀fɔ lʉfʉ̀ ráhʉ dhu bvʉ̌. Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ abádhí àvi ròwù. ");
INSERT INTO niy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ányɨ̀rɔ̌ rɔ̀ tɨ́, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà núupò ibhú ɔ̀, ’àdʉ̀ òwu Dàlmànutà tɨ́ kátɨna pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Atdíku, Pbàfàrìsáyó níiwú ùvò Yěsù-tɨ’ɔ̀, ’àdʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ kà nà kǎfí ɨ̀ omvú tɨ́. Nɨ́, abádhí náavì ka rɔ̀nzɨ̀ atdí wɨwɨ̀, ndɨ́nɨ̌ Kàgàwà bhà rɔ̀ kàbhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ́rà dhu navì tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nɨ́ ndɨ dhu adʉ̀ ɨ̀nzɛ Yěsù rɔ̌ atdídɔ̌, ndàdʉ̀ àtɨ̀nà: «Heè! Ádhu indo arɨ́’ɨ̀ alɛ nózè wɨwɨ̀ kɛ̀lɛ̌ ’àla nɨ̌? Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ka kɨ́ nzɨ̌ atdí wɨwɨ̀ mà nɔ́nzɨ abádhí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wɔ̀ dhu-dzidɔ̌, Yěsù ɨvà ndɨ̀ abádhí-tɨ́ rɔ̀, ’àdʉ̀ ùpo ibhú ɔ̀ pbɨ̀ndà ábhàlɨ̌ mànà, ’àdʉ̀ àda rɛ̀rʉ̀-adzè. ");
INSERT INTO niy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mʉ̀gatì nídyì ɨ̀ ɨ́ àkǎkǎ dhu bvʉ̀tɨ́ dhu náadzò Yěsù bhà ábhàlɨ̌ ɔ̀nǎ rɔ̀, abádhí ràdʉ̀ ’òtù atdí mʉ̀gatì kɛ̀lɛ̌ nà fɔyá ibhú ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nɨ́ Yěsù nʉ́ʉyá dhu abádhí tɔ̀ ndàtɨ: «Nyàndà nga mběyi, nyɔ̀dɔ nyɨ̌ Pbàfàrìsáyó tɔ́ afi mà, Hɛ̀rɔdɛ̀ bhà afi mànà dhu rɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nɨ́, Yěsù bhà ábhàlɨ̌ náatɛ̀ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌ ɨ̀mbǎ ɨ̀ ràrɨ̌’ɨ̀ mʉ̀gatì nà. ");
INSERT INTO niy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nɨ́ Yěsù náasʉ̀ abádhí rʉ̌nɔna dhu, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Ádhu nyɨ̌ nyátɨna, ɨ̀mbǎ nyɨ̌ ràrɨ̌’ɨ̀ mʉ̀gatì nà nɨ̌? Ndɨ dhu àpɛ̀ t’óbhó dʉ̀kʉ àlʉ̌? Nyɨ̌ nyàpɛ̀ tɨ́ nzá ndɨ dhu àlʉ̌ dʉ̀kʉ ɔ̀? Fʉ̀kʉ́ ɨrɛ̀ta dɔ̀nǎ dhu òsè t’óse tɨ́? ");
INSERT INTO niy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyɨ̀kpɔ́kʉ rǐnè, nɨ́ nyɨ̌ t’óbhó ɨnga nálǎ? Bɨ̌kʉ rǐnè, nɨ́ nyɨ̌ t’óbhó ɨnga nɨ́rɨ? Nyɨ̌ nyɨ̀rɛ̀ t’óbhó ");
INSERT INTO niy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ìfe sɛ̌ngɛ̀ ɔ̌ màtɨ́ nyɨ̌ nyundu ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀ rùlè dhu, yà imbò mʉ̀gatì-ɔ̌nga ma mʉkɔ imbò lʉfʉ̀ alɛ tɔ̀ nɨ́nganɨ́?» Abádhí adʉ̀ dhu àdu ’àtɨ: «Atdí-kumì dɔ̀ná ɔ́yɔ̌ nà sɛ̌ngɛ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ndɨrɔ̀ Yěsù adʉ̀ dhu ìvu tdɨ́tdɔ̌ ndàtɨ: «Yà àrʉ̀bhʉ̀ mʉ̀gatì-ɔ̌nga ma mʉkɔ ɨ̀fɔ lʉfʉ̀ alɛ tɔ̀ nɨ́nganɨ́, nyɨ̌ nyundu ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀ rùlè ìfe sɛ̌ngɛ̀ ɔ̌?» Nɨ́ abádhí adʉ̀ dhu àdu, ’àtɨ: «Àrʉ̀bhʉ̀ sɛ̌ngɛ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nɨ́ ndɨ dhu àpɛ̀ tɨ́ nzá dʉ̀kʉ àlʉ̌ kòmbí màtɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Bɛ̀tɛ̀sàyidà tɨ́ kátɨna pbanga ɔ̀. Nɨ́ ányɨ̀, ìndrǔ níiwú atdí ndùmùndúmú nà Yěsù-tɨ’ɔ̀, ’àdʉ̀ ’ɨ̀tsɔ̀ Yěsù rɔ̌ ndɨ́nɨ̌ kà-ngbɔ̀ napbálá tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nɨ́ Yěsù náalʉ́ wɔ̀rɨ́ ndùmùndúmú ɔtsʉ́na rɔ̌, ’ùvò nà pbanga ɔ̀ rɔ̀. Tdɨ́tdɔ̌ kǎdʉ̀ ɨsɔ nísò kànyɨ̀kpɔ́ rɔ̌, ndàdʉ̀ ɔtsʉ́na nʉ́lɨ kà dɔ̌. Ndɨrɔ̀ Yěsù adʉ̀ dhu nívu kà-tsʉ̌ ndàtɨ: «Nyɨ tɨ́ atdí dhu mà nálǎ àlǎ?» ");
INSERT INTO niy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nɨ́ wɔ̀ ndùmùndúmú náangbɛ nyɨ̀kpɔ́na, ndàdʉ̀ àtɨ̀nà: «Ma mɨ́ ìndrǔ nálǎ itsu bhěyi rólo rɔ́, pbɛ́tʉ̀ abádhí rǔbhi ùbhǐ.» ");
INSERT INTO niy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yěsù adʉ̀ ɔtsʉ́na nʉ́lɨ tdɨ́tdɔ̌ kànyɨ̀kpɔ́ dɔ̌, kà ràdʉ̀ ɨnga nála kpangba. Ndɨrɔ̀, kǎdʉ̀ ɔ̀gʉ̀ atdídɔ̌, ndàdʉ̀ kɔ́rɔ́ dhu àla mběyi nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nɨ́ Yěsù adʉ̀ kàvi ràdu ndɨ̀ pbɨ̀ndà, ndàdʉ̀ àtɨ̀nà: «Àpɛ́ nyotsú wɔ̀ pbanga ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù Kàyìsàriyà-Fìlipì tɔ́ kɨgɔ̀ tɨ́ rɨ́’ɨ̀ pbangá-nzo ɔ̀. Nɨ́ otu ɔ̌, kǐvú dhu abádhí-tsʉ̌ ndàtɨ: «Ìndrǔ arátɨna ma ràrɨ̌ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Atdídhená alɛ náarátɨna nyɨ ràrɨ̌ bàtizò nubhónà Yùwanɨ̀. Ngʉ̌kpà alɛ náarádʉ̀ àtɨ̀nà nyɨ ràrɨ̌ Ɛ̀lɨyà. Ndɨrɔ̀, ngʉ̌kpà alɛ-tsí náarádʉ̀ àtɨ̀nà nyɨ ràrɨ̌ angyí ɨ’ɨ̀ ngʉ̌kpà pbànábí nzínzì ɔ̌ atdí alɛ.» ");
INSERT INTO niy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Olu nyɨ̌, nyɨ̌ nyarátɨna ma ràrɨ̌ àdhɨ?» Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨnyɨ, nyɨ nɨ́ Krɨ́stɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ abádhí nɨ́sɔ ɨ̀nzɨ̌ wɔ̀ dhu nʉnɔ tɨ́ atdí alɛ tɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù náadɨ̀ ndàmbɛ dhu núdhe dɔ̌ pbɨ̀ndà ábhàlɨ̌ tɔ̀. Kǎtɨ: «Dhu àkǎ Ìndrǔ t’ídhùnà ràbà àpbɛ̀ atdídɔ̌. Pbanga ɔ̌ pbàkʉ̀rʉ̌ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà nɔ́ɔdhɔya ka. Ndɨrɔ̀, ka kohoya ka, kadʉ̀ ɔ̀tdʉ̀nà. Pbɛ́tʉ̀ ɨ̀bhʉ ɨdhɔ dzidɔ̌ kǎdʉ̀ya ndɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kʉ̌nɔ wɔ̀ dhu abádhí tɔ̀ kpangba nyʉ́. Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ kìdyì ndàrà nà igi, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀rʉ̀ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nɨ́ Yěsù agɛ́rɛ́ ndɨ̀ ndàndà pbɨ̀ndà ábhàlɨ̌, ndàdʉ̀ ɔ̀rʉ̀ Pɛ́tɛrʉ̀ dɔ̌ ndàtɨ: «Índrǐ nyɨ ɨtsɛ tɨdú rɔ̀ Pfɔ̀mvɔ Sìtanɨ̌! Nyɨ nyɨ́ nzɨ̌ ɨnga nɨ́rɛ̀ Kàgàwà náarɨ́ ɨnga ɨ̀rɛ̀ dhu bhěyi nɨ́dhunɨ̌, pbɛ́tʉ̀ nyɨ nyɨ́ ɨnga nɨ́rɛ̀ ìndrǔ bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tdɨ́tdɔ̌, Yěsù náanzi ihé-yà pbɨ̀ndà ábhàlɨ̌ mànà, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ndɨ alɛ náapɛ́ ndòzè ndùbhi owùdu ɔ̌, nɨ́ ndɨ alɛ àkǎ ndàdzo rɔ̀ná rɔ̀, ndàdʉ̀ ndà’ù ndànɔ̀ pbɨ̀ndà mʉ̀sàlabhà, ndàdʉ̀ ùbhi owùdu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Obhó tɨ́, pbɨ̀ndà ípìrɔ̌nga nòzè ndɔ̀dɔ̀ fɨ̌ndà alɛ níiwíya ka. Pbɛ́tʉ̀, okúdu dɔ̀ rɔ̀, ndɨrɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀-okú dɔ̀ rɔ̀ rɨ́ pbɨ̀ndà ípìrɔ̌nga níwǐ alɛ, nɨ́ɨgʉ́ya ka. ");
INSERT INTO niy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ndɨrɔ̀, ìndrǔ rɨ̌ yà adzɨ ɔ̌ ònzì nábà, ndàdʉ̀ pbɨ̀ndà ípìrɔ̌nga níwi dhu tɔ́ ídzìnga nɨ́ àdhu? ");
INSERT INTO niy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ìndrǔ rǎdʉ̀ àbhʉnà pbɨ̀ndà ípìrɔ̌nga ndʉwʉ̀ tɨ́ nɨ̌ atdí dhu mà tɨ́’ɨ̀ ìnè? ");
INSERT INTO niy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Indo arɨ́’ɨ̀ alɛ nɨ́ nzɛ́rɛnga ɔ̀nzɨ arɨ́ alɛ, ndɨrɔ̀ ɨ̀nzɨ̌ arɨ́ ’ɔ̀dɔ Kàgàwà tɔ̀ alɛ. Nɨ́ ndɨ alɛ-nyɨ̀ náapɛ́ ɨ̀wʉ okúdu dɔ̀ rɔ̀, ndɨrɔ̀ pbàkà ɔtɛ-okú dɔ̀ rɔ̀ kɔ̀rɨ́ ɨ alɛ nzínzì ɔ̌, nɨ́ Ìndrǔ t’ídhùnà-nyɨ̀ nɨ́ɨwʉya átɔ̀ kǒkú dɔ̀ rɔ̀ ɨ̀ ítsi ìwu ɨ̀lɨ̌lǎ màlàyíká mànà Àbanà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ nɨ́nganɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: yà ɨrɔ́ rɨ́’ɨ̀ alɛ nzínzì ɔ̌, ngʉ̌kpà alɛ nʉ́ʉvɛ̀ya nzɨ̌ ɨnzá ɨ̀ àla ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi rɨ̌rà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà dhu rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Azà ɨdhɔ dzidɔ̌, Yěsù náanzi Pɛ́tɛrʉ̀ mà, Yàkɔbhɔ̀ mà, Yùwanɨ̀ mànà, ’àdʉ̀ ùpo mànà ádzǐ pbìrì-akpà dɔ̀. Ányɨ̀ abádhí náatù ɨ̀ ɔ̀yá. Nɨ́ Yěsù-wɔ̀yɔ̌ nʉ́ʉgɛ̀rɛ̀ ndɨ̀ abádhí-nyɨ̀kpɔ́ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kà-rɔ̌ mʉ̀dzarʉ̀ náapɛ̀ ndʉ̀mbɨ̀lɨ̀ atdídɔ̌, ràdʉ̀ ɔ̀wʉ̀ tdyé, ɨ̀nzɨ̌ yàrɨ́ adzɨ dɔ̌ atdí alɛ mà rǎdʉ̀ dhu ɔ̀bhɔ̀lɔ̀ rɔ̀wʉ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tdɨ́tdɔ̌, nabìƐ̀lɨyà mà Músà mànà nʉ́ʉtɔ ɨ̀ abádhí tɨ́, ’àdʉ̀ àmbɛ ɔ̀tɛ dɔ̌ Yěsù mànà. ");
INSERT INTO niy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ náatɨ Yěsù nɨ̌: «Màlimǒ, dhu ɔ̀fɔ̀ nga àlɛ̌ ròkò ɨrɔ́. Mǎ mɨ́ ɨ̀bhʉ hɛmɛ̌-dzà núpě, atdí ɨndʉ̀, atdí Músà tɔ̀, ndɨrɔ̀ atdí Ɛ̀lɨyà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pɛ́tɛrʉ̀ nʉ́ʉnɨ nzá àdhu mà nʉ́nɔ ndɨ̀ ndɨ́ dhu. Obhó tɨ́, àbadhi mà ngʉ̌kpà ábhàlɨ̌ mànà nɨ́ɨ’ɨ̀ ɔdɔ nà atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɨ́ ádrʉ̀ngbǎ àpbù níibvú ndɨ̀, ndàtsì abádhí sɨsɨ̀na nɨ̌. Ndɨrɔ̀ atdí alɛ-tù náadʉ̀ ndɨ̀rɨ̀ wɔ̀ àpbù ɔ̀ rɔ̀, ndàtɨ: «Yàrɨ́ nɨ́ Idhùdu, atdídɔ̌ ma mózè alɛ. Nyɨ̀rɨ kà-tsʉ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ányɨ̀rɔ̌ rɔ̀ tɨ́, kɔ̌kɔ̀rɨ́ ábhàlɨ̌ náandà tɨyá nga, pbɛ́tʉ̀ ɨ̀nzɨ̌ àdʉ̀ atdí alɛ mà nála. Yěsù kɛ̀lɛ̌ náadʉ̀ ɨ̀ atdírɔ̀ abádhí-tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pbìrì dɔ̀ rɔ̀ abádhí rǎwǔ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù nʉ́ʉyá dhu abádhí tɔ̀ ndàtɨ: «Àpɛ́ nyàwɛ yà nyɨ̌ nyàla dhu atdí alɛ tɔ̀ màtɨ́, ràrà àhʉ ɨma, Ìndrǔ t’ídhùnà, ma mɨ́ mɨngbɛ̀ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nɨ́ abádhí náalʉ́ wɔ̀ fɨ̌yɔ̀ ka kʉ̀yǎnà dhu dɔ̀ya ɔ̀, àzèmbè ɨ̀ ɨ́ dhu ɔ̀ngʉ̀ tsʉ̀yá nzínzìya ɔ̌ rɔ́rɔ̀, ’àmbɛ àtɨ̀nà dɔ̌: «Ìndrǔ rɨ̌ ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu-tɨ̀ nɨ́ àdhu?» ");
INSERT INTO niy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wɔ̀ dhu-dzidɔ̌, abádhí níivú dhu Yěsù-tsʉ̌ ’àtɨ: «Ádhu Músà bhà Ʉyátá tɔ́ màlímó náarátɨna, Ɛ̀lɨyà ràkǎ pɛ́ ndɨ̀rà angyi nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nɨ́ Yěsù adù dhu abádhí tɔ̀ ndàtɨ: «Obhó tɨ́, Ɛ̀lɨyà nákǎ wà ndàdu ndɨ̀ angyi, ndɨ̀rà kɔ́rɔ́ dhu-nyɨ̀tɨ̀ nóhù. Pbɛ́tʉ̀, ádhu Kàgàwà bhà Andítá náarátɨna átɔ̀ ìndrǔ t’Ídhùnà rabáya àpbɛ̀ abhɔ, kadʉ̀ ɨtsɨ̀na nɔ́nzɨ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pbɛ́tʉ̀, ma mɨ́ dhu ɔ̀vɔ fʉ̌kʉ̀: Ɛ̀lɨyà bhěyi atdí alɛ nɨ́ɨra wà àhʉ, ìndrǔ ràdʉ̀ àvu rɔ̀ná ɨ̀ òzè dhu bhěyi, àdhàdhɨ̀ Andítá nɔ́vɔ̀ kà dɔ̌ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yěsù mà kɔ̌kɔ̀ ɨ̀bhʉ ábhàlɨ̌ mànà níiwú ùvò ngʉ̌kpà ábhàlɨ̌-tɨ́. Nɨ́ abádhí náala ádrʉ̀ngbǎ ihé-yà ɨ ábhàlɨ̌-ngbɔ̀ nàkpɔ̀rɔ̀ rɔ́. Ndɨrɔ̀ Músà bhà Ʉyátá tɔ́ màlímó náadʉ̀ òko ’àmbɛ ’àgò dɔ̌ abádhí mànà. ");
INSERT INTO niy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nɨ́, ìndrǔ níitdègu Yěsù nálǎ, nɨ́ ɨdhɔ nʉ́ʉkɔ abádhí atdídɔ̌, ’àdʉ̀ òtse ’òwù Yěsù nátsɛ̀. ");
INSERT INTO niy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yěsù adʉ̀ dhu ìvu pbɨ̀ndà ábhàlɨ̌-tsʉ̌ ndàtɨ: «Ádhu abádhí mànà nyɨ̌ nyɨ́ nyǎgò dɔ̀ná?» ");
INSERT INTO niy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nɨ́ ihé-yà nzínzì ɔ̌ atdí alɛ náadʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Màlimǒ, ma mɨ̀rà idhùdu nà fʉnʉ ɔ̀. Nzɛ́rɛ-alafí yà kàbhʉ̌ arɨ́ ɨ̀nzɨ̌ ràmbɛ ɔ̀tɛ dɔ̌ nɨ́ rɨ̌’ɨ̀ kà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kɔ́rɔ́ ngari ɔ̌, ndɨ nzɛ́rɛ-alafí nɨ́và dhu kà rɔ̌ rɔ́, kǎrɨ́ kà-ɔ̌nga níbvǔ obvò, ɨsɔ́-yà rùpbò ndɨ̀ liná, ràdʉ̀ àmbɛ kǔna nátri dɔ̌, kàngbɔ̀ ràdʉ̀ ndìfìrì ndɨ̀dzɔ̀. Nɨ́ ma màvi pbʉ̀kʉ̀ ábhàlɨ̌ rìpfo ndɨ nzɛ́rɛ-alafí kà ɔ̀ rɔ̀, pbɛ́tʉ̀ abádhí nádʉ̀ nzá kà-lɛ̀mà nɔ́nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nɨ́ Yěsù adʉ̀ dhu nʉ́nɔ̀ abádhí tɔ̀ kpangba ndàtɨ: «Hàkà! Nyɨ̌ ɨ̀mbǎ a’uta nà alɛ́! Àlɛ̌ kokoya nyɨ̌ mànà ìfe kàsʉmɨ̀ tɨ́ tdɨ́tdɔ̌? Ma mɨ́ fʉ̀kʉ́ dhu-dzi nóndù ràrà àhʉ ìfe ɨdhɔ tɨ́? Nyìwǔ ndɨ ngbángba nà tɨdu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nɨ́ ka kadʉ̀ ìwu kà nà Yěsù-tɨ’ɔ̀. Ʉrɔ́ rɔ̀ tɨ́, wɔ̀ nzɛ́rɛ-alafí níitdègu Yěsù nálǎ, nɨ́ kɨ̌yà ndɨ ngbángba-ɔ̌nga ɔbɨ nyʉ́ nà, ràdʉ̀ ɨ̀tsɨ̀ obvò, ràmbɛ ndùbolo dɔ̌ adzɨ ɔ̌, ɨsɔ́-yà ràdʉ̀ ndùpbò liná. ");
INSERT INTO niy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yěsù adʉ̀ dhu ìvu kà t’ábanà-tsʉ̌ ndàtɨ: «Wɔ̀ dhu ɔ́pɛ̀ ndɨ̀ ɨ̀ngbàtɨ́ngá kà rɔ̌?» Kà t’ábanà náadʉ̀ dhu àdu ndàtɨ: «Àdɨ̌ kàdɨ ngbángba nyʉ́ tɨ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndɨrɔ̀ ibí-gʉ̀na nyʉ́, nzɛ́rɛ-alafí náarɨ́ kàbhʉ̌ ràwà ndɨ̀ kàzʉ ɔ̀ màtɨ́, ndɨrɔ̀ ɨdha ɔ̀ màtɨ́, ndɨ́nɨ̌ ɔvɛ́ tɨ́. Nɨ́, ɨ̀mbǎ màtɨ́ dhu ɨ̀’ɨ, ndɨ dhu ɔ̀nzɨ̀ nyɨ nyádʉ̀ nánɨ̌, ábà ɨzʉ dɔ̀ká nyɔnzɨ̀ dzʉ̀nàka.» ");
INSERT INTO niy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Nyɨ pbánɨ́ àtɨna, ndɨ dhu ɔ̀nzɨ̀ nyɨ nyádʉ̀ nánɨ̌? Kɔ́rɔ́ dhu rǎdʉ̀ àkǎ a’uta nà rɨ́’ɨ̀ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ ngbángba t’ábanà náafà ndɨ̀ ndàtɨ: «Ìnè ma mɨ́’ɨ̀ a’uta nà! Nɨ́ ɔ́nzɨ dzʉ̀nàdu nyɨtrɔ̌ ka!» ");
INSERT INTO niy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wɔ̀ dhu-dzidɔ̌, Yěsù ala ihé-yà tɨya ɔ̀ rítse rɔ́. Nɨ́ kǎdʉ̀ ɔ̀rʉ̀ ndɨ nzɛ́rɛ-alafí dɔ̌, ndàtɨ kà nɨ̌: «Yà ngbángba nábhʉ̌ arɨ́ ɨ̀nzɨ̌ ràmbɛ ɔ̀tɛ dɔ̌, ndɨrɔ̀ ɨ̀nzɨ̌ ràmbɛ nga nɨ́rɨ̀ dɔ̌ nzɛ́rɛ-alafí, ma mátɨna nyɨ nɨ̌: ‹Áhʉ̌ yà ngbángba ɔ̀ rɔ̀, ndɨrɔ̀ àpɛ́ nyadù nyɨ tdɨ́tdɔ̌ kà ɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nɨ́ wɔ̀rɨ́ nzɛ́rɛ-alafí náakù, ndɨ̀yà wɔ̀ ngbángba-ɔ̌nga ɔbɨ nyʉ́ nà, ndàdʉ̀ àhʉ kà ɔ̀ rɔ̀. Wɔ̀ ngbángba nɨ́ɨlɨ ndɨ̀ ɨwà ɔ̀vɛ̀ alɛ bhěyi, ányɨ̀rɔ̌ ɨ̀’ɨ̀ ábhɔ̌ alɛ ràdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Ɨwà ɔ̀vɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pbɛ́tʉ̀, Yěsù náadʉ̀ kàlʉ ɔtsʉ́na rɔ̌, ndɨ̀và, rìdè. ");
INSERT INTO niy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yěsù níitdègu ndàdǔ ɨdza, kàbhà ábhàlɨ̌ ràdʉ̀ ’òtù ɔ̀yá kà mànà, nɨ́ abádhí adʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Ádhu ɨnzá mǎ mìpfo wɔ̀ nzɛ́rɛ-alafí nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ɨ̀nzɨ̌ vurò dhu rǎdʉ̀ wɔ̀rɨ́ nzɛ́rɛ-alafí-tɨdɔ̀ nípfo. Pbɛ́tʉ̀ kìpfo rádʉ̀ nɨ́ ɨtsɔ̀ta kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà nɨ́ɨvà ɨ̀ ányɨ̀rɔ̌ rɔ̀, ’àdʉ̀ ʉ̀da Gàlìlayà tɔ́ pbìrì ɔ̀na nǎ. Kǎzè nzá kʉnɨ ɨ̀ngbɔrɔ́ màtɨ́ ɨ̀ ɨ́’ɨ̀ pbɨ̀ndà ábhàlɨ̌ mànà dhu. ");
INSERT INTO niy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Obhó tɨ́, kǎmbɛ́nà dhu ùdhe dɔ̌ abádhí tɔ̀, ndàmbɛ àtɨ̀nà dɔ̌ abádhí nɨ̌: «Ka kɨ́ mipfǒ, ɨma Ìndrǔ t’Ídhùnà, kabhʉ ma ìndrǔ-fɔ́. Nɨ́ ɨ alɛ rɨ̌ moho, kadʉ̀ mɔtdʉ̀. Ndɨrɔ̀ ɨ̀bhʉ ɨdhɔ dzidɔ̌, ma mádʉ̀ mɨngbɛ̀ ɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pbɛ́tʉ̀, wɔ̀rɨ́ ɔtɛ náalʉ́ ɨnzá kɔ̌kɔ̀ ábhàlɨ̌-dɔ, ndɨrɔ̀ abádhí adʉ̀ kà-tsʉ̌ ɨ̀ ɨ́ dhu ɔ̀ngʉ̀ dhu-ɔdɔ̀ nɔ́nzɨ̀ ɔ̀nzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Kàpɛ̀rnàwumù tɨ́ kátɨna kɨgɔ̀ ɔ̀. Nɨ́, ɨdzá ɨ̀ ɨ́’ɨ̀ rɔ́rɔ̀, Yěsù níivú dhu pbɨ̀ndà ábhàlɨ̌-tsʉ̌ ndàtɨ: «Ádhu nyɨ̌ nyúbhi nyǎgò rɔ̌ dɔ̀ná otu ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pbɛ́tʉ̀ abádhí náadʉ̀ ɨ̀nɛ̀ ɨ̀nɛ̀ tɨ́. Obhó tɨ́, otu ɔ̌, abádhí ubhínà ’àgò rɔ̌ nzínzìya ɔ̌, ndɨ́nɨ̌ ɨ̀ ʉnɨ tɨ́ ádrʉ̀ngbǎlɛ ròsè nzínzìya ɔ̌ ràrɨ̌ àdhɨ. ");
INSERT INTO niy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nɨ́ Yěsù adɨ̀ obvò, ndàdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ núnzì, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ndɨ alɛ náapɛ́ ndòzè ndɨ̀’ɨ̀ wɛmbɛrɛ̀ t’álɛ tɨ́, nɨ́ ndɨ alɛ àkǎ ndɨ̀’ɨ̀ kɔ́rɔ́ alɛ tɔ̀ arádɨ olù alɛ tɨ́, ndàdʉ̀ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ tɔ̀ arɨ́ kasʉ ɔ̀nzɨ alɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tdɨ́tdɔ̌, kǎdʉ̀ ákɛ̌ ngbángba nídyì, ndɨ̀lɨ rìdè abádhí-ɔ̀nzɨ̌. Kǐdyi ndɨ ngbángba ndàtdǔ, ndàdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: ");
INSERT INTO niy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Yàrɨ́ ngbángba bhěyi atdí ngbángba nàkɔ okúdu dɔ̀ rɔ̀ alɛ, nádʉ̀ ɨ̀’ɨ̀ ɨwà ɨma nàkɔ alɛ. Ndɨrɔ̀ ɨma nàkɔ alɛ nákɔ ɨnzá ɨma kɛ̀lɛ̌, pbɛ́tʉ̀ kàkɔ ɨma nívì alɛ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yùwanɨ̀ náatɨ Yěsù nɨ̌: «Màlimǒ, mǎ màla atdí alɛ nzɛ́rɛ-alafí nípfǒ rɨ́ ìndrǔ ɔ̀ rɔ̀ ɔvɔ̀nʉ rɔ̌ rɔ́. Nɨ́ mǎ màtsǔ mɨ̌sɔ̌ ndɨ dhu kà tɔ̀, ɨ̀nzɨ̌ ndɨ alɛ náarúbhi atdíkpá àlɛ̌ mànà nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pbɛ́tʉ̀, Yěsù adʉ̀ dhu àdu ndàtɨ: «Ɨ̀nzɨ̌ nyɨ̀sɔ̌ ndɨ dhu kà tɔ̀, ɨ̀nzɨ̌ ìndrǔ rǎdʉ̀ wɨwɨ̀ nɔ́nzɨ̀ ɔvɔ̀du rɔ̌, ndàdʉ̀ ɔ̀tɛ nzɛ́rɛ ɨma nɨ̌ kòmbómbí tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɨ̀nzɨ̌ ndɨ alɛ náapɛ́ ɨ̀’ɨ̀ àlɛ̌ tɔ́ òmvǔ tɨ́, nɨ́ ka nɨ́ àlɛ̌-tɨ’ɔ̀nǎ rɔ̀ rɨ́’ɨ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Obhó tɨ́, ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨdha mà nábhʉ̌ rɨ́ nyɔ̌mvʉ̀ Krɨ́stɔ̀ bhà alɛ tɨ́ nyɨ̌ nyɨ́’ɨ̀ dhu-okú dɔ̀ rɔ̀ alɛ, náadɨ̀ya nzɨ̌ ɨnzá ndɨ̀ ndàbà pbɨ̀ndà pɛrɛ̀ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Yà ma ná’ù nzónzo nzínzì ɔ̌ atdí ngbángba mà nábhʉ̌ rɨ́ ròtsù nzɛ́rɛnga ɔ̀ alɛ-tú, dhu ɔ̀fɔ̀ nga mběyi nyʉ́ kosò dhu ò’ù ka karɨ́ dɔ̀ná odu-ba, kadʉ̀ ndɨ alɛ nɨ́dɔ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dhu apɛ́ ɨ̀’ɨ̀ ɔtsʉ́nʉ náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ ɔ́tdɨ̀ ka. Dhu ɔ̀fɔ̀ nga atdídɔ̌ ɨndʉ̀, nyotsù atdí ɔtsʉ́nʉ nà dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀, ròsè ɔ́yɔ̌ ɔtsʉ́nʉ nà nyɨ nyárà ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ányɨ̀, alɛ-ngbɔ̀ nɔ́nyʉ rɨ́ rɨ̀pbà ndɨ̀ asa náarɨ́ nzɨ̌ ʉ̀vɛ, ndɨrɔ̀ ányɨ̀ kàzʉ náarɨ́ nzɨ̌ àvɛ akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Dhu apɛ́ ɨ̀’ɨ̀ pfɔ̌nʉ náarɨ́ nyabhʉ̌ nyòtsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ ɔ́tdɨ̀ ka. Dhu ɔ̀fɔ̀ nga nyotsù atdí pfɔ̌nʉ nà dhòdhódhónga tɔ́ ípìrɔ̌nga ɔ̀, ròsè ɔ́yɔ̌ pfɔ̌nʉ nà ka kɨ́ nyobvù ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ányɨ̀ alɛ-ngbɔ̀ nɔ́nyʉ rɨ́ rɨ̀pbà ndɨ̀ asa náarɨ́ nzɨ̌ ʉ̀vɛ, ndɨrɔ̀ ányɨ̀ kàzʉ náarɨ́ nzɨ̌ àvɛ akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndɨrɔ̀, dhu apɛ́ ɨ̀’ɨ̀ atdí nyɨ̀kpɔ́nʉ náarɨ́ nyabhʉ̌ nyotsù nzɛ́rɛnga ɔ̀ dhu tɨ́, nɨ́ ítù ka nyobvù. Dhu ɔ̀fɔ̀ nga nyotsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ atdí nyɨ̀kpɔ́nʉ nà, ròsè ɔ́yɔ̌ nyɨ̀kpɔ́nʉ nà ka kɨ́ nyobvù ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ányɨ̀ alɛ-ngbɔ̀ nɔ́nyʉ arɨ́ rɨ̀pbà ndɨ̀ asa náarɨ́ nzɨ̌ ʉ̀vɛ, ndɨrɔ̀ ányɨ̀ kàzʉ náarɨ́ nzɨ̌ àvɛ akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Obhó tɨ́, Kàgàwà núu’oya kɔ́rɔ́ alɛ kàzʉ nɨ̌ rɨ̀lǎ nyɨ̀kpɔ́na ɔ̌, àdhàdhɨ̀ ka karɨ́ pɛrɛ̀ tɨ́ ka kúbhǒna kà tɔ̀ dhu nú’ǒ iko nɨ̌ rɨ̀lǎ kà-nyɨ̀kpɔ́ ɔ̌ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Iko nɨ́ ídzì dhu nyʉ́. Pbɛ́tʉ̀, iko-òvǔ náapɛ́ ìku, nɨ́ ka kádʉ̀ kàbhʉ ròkyè àdhu nɨ̌ tdɨ́tdɔ̌? Nyàbhʉ òvǔkʉ rɨ̀’ɨ̀ iko nɨ̌ ka kɔ̀sɨ̀ dhu-òvǔ náarɨ́’ɨ̀ dhu bhěyi, nyǒkò màrʉ̀ngà ɔ̌ nzínzìkʉ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù nɨ́ɨvà ndɨ̀ Kàpɛ̀rnàwumù rɔ̀, ndàrà Yùdɛyà tɔ́ pbìrì ɔ̀, ndàdʉ̀ àda Yɔ̀rɔ̀danɨ̀ tɨ́ kátɨna ɨdha-akpà-adzè. Nɨ́, ábhɔ̌ ihé-yà náadʉ̀ ’ùndu kàtɨ́ tdɨ́tdɔ̌, kà ràdʉ̀ dhu ɔ̀pɛ̀ ndùdhe tdɨ́tdɔ̌ fɨ̌yɔ̀ yà bìlǐnganà ndɨ̀ ndarɔ́nzɨna dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nɨ́ ngúfe Pbàfàrìsáyó níiwú kà ɨ ndɨ́nɨ̌ ɨ̀ omvú tɨ́ kǎfí. Abádhí níivú dhu Yěsù-tsʉ̌ àtɨ: «Músà bhà Ʉyátá návi tɨ́ wà kpatsìbhálɛ rɔ̀dhɔ̀ pbɨ̀ndà tsìbhálɛ ndàdʉ̀ òdìnà?» ");
INSERT INTO niy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Ádhu Músà bhà Ʉyátá nʉ́ʉnɔ fʉ̌kʉ̀ ndɨ dhu dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Abádhí adʉ̀ àtɨ̀nà: «Músà náatɨ, kpatsìbhálɛ ràrǎdʉ̀ ʉbhátá tɔ́ bhàrʉwà nándi, ndàbhʉ ndɨ pbɨ̀ndà tsìbhálɛ-fɔ́, ndàdʉ̀ kòdì.» ");
INSERT INTO niy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Músà náandí wɔ̀rɨ́ Ʉyátá fʉ̌kʉ̀ odú afíkʉ náarɔ́’ɔ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pbɛ́tʉ̀ mʉ̀hàngʉ́ ɔ̀ rɔ̀, Kàgàwà náanzɨ̀ kɔ́rɔ́ dhu nɨ́nganɨ́, kǎnzɨ̀ kpatsìbhálɛ mà tsìbhálɛ nà. ");
INSERT INTO niy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kpatsìbhálɛ rǎdʉ̀ àbanà mà ɨ́yànà mànà nʉ́bhà, ’àdʉ̀ òwu ’ùngbò atdíkpá pbɨ̀ndà tsìbhálɛ mànà, ");
INSERT INTO niy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","abádhí ɔ́yɔ̌ rɔ̀ ràdʉ̀ òngo atdí alɛ tɨ́. Ndɨ dhu bhěyi nɨ́ ndɨ, abádhí nɨ́ nzɨ̌ ɔ́yɔ̌ alɛ tdɨ́tdɔ̌, pbɛ́tʉ̀ abádhí nóngò ɨwà atdí alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nɨ́rɔ̀, dhu àkǎ nzá atdí alɛ mà rùtu Kàgàwà úngbò alɛ-ɔ̌nga.» ");
INSERT INTO niy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà níitdègu ’àdǔ ɨdza, nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ dhu ɔ̀ngʉ̀ kà-tsʉ̌ tdɨ́tdɔ̌ ndɨ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nɨ́, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Atdí kpatsìbhálɛ náapɛ́ pbɨ̀ndà tsìbhálɛ nɔ́dhɔ, ndàdʉ̀ ngǎtsi tsìbhálɛ nídyì, nɨ́ ndɨ kpatsìbhálɛ nɔ́nzɨ̀ wà mʉ̀nyɔ̀nɨ̀, ndàdʉ̀ dhu àfa angyì pbɨ̀ndà tsìbhálɛ-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ndɨ dhu bhěyi tɨ́, atdí tsìbhálɛ náapɛ́ pbɨ̀ndà kpatsìbhálɛ nʉ́bha, ndàdʉ̀ ndɔ̀kʉ̀ ngǎtsi kpatsìbhálɛ tɔ̀, nɨ́ ndɨ tsìbhálɛ nɔ́nzɨ̀ wà mʉ̀nyɔ̀nɨ̀.» ");
INSERT INTO niy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Atdíku, ìndrǔ níiwú nzónzo nà Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ kʉ̌lɨ tɨ́ ɔtsʉ́na dɔ̀yá, ndàdʉ̀ àsonà. Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ ɔ̀rʉ̀ ɔ̀rʉ̀ tɨ́ ɨ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nɨ́, wɔ̀ dhu ndɨ̀ ndàla rɔ̀, Yěsù-ɔ̌nga náadʉ̀ ndɨ̀wà pbɨ̀ndà ábhàlɨ̌ rɔ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyʉ̀bhà nzónzo rìwǔ tɨdu ɔ̀, ɨ̀nzɨ̌ nyʉ̀tɔ̀ abádhí-tsʉ̀. Obhó tɨ́, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi nɨ́ abádhí bhěyi ɨ̀ nʉ́lɨ alɛ tɔ́. ");
INSERT INTO niy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨ̀nzɨ̌ rɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi nákɔ̌ ngbángba náarɨ́ dhu àkɔ̌ dhu bhěyi alɛ, náadʉ̀ya nzɨ̌ òtsù ányɨ̀ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ nzónzo númbo, ndʉ̀lɨ ɔtsʉ́na dɔ̀yá, ndàdʉ̀ abádhí náso. ");
INSERT INTO niy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yěsù níitdègu ɨ̀sɨ̌ otu ɔ̌ ndàmbɛ àrà dɔ̌, nɨ́ atdí alɛ nɨ́ɨkʉ ɔngʉ tɨ́ kà-tɨ’ɔ̀. Kǐtsi ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndàdʉ̀ dhu ìvu kà-tsʉ̌ ndàtɨ: «Ídzì Màlimǒ, ádhu ndɨ àkǎ mɔnzɨ̀ ndɨ́nɨ̌ ma mabá tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga?» ");
INSERT INTO niy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ádhu nyɨ nyɨ́ manzi ídzì alɛ tɨ́ nɨ̌? Ɨ̀mbǎ ídzì alɛ rɨ̌’ɨ̀ atdí màtɨ́, pbɛ́tʉ̀ Kàgàwà kɛ̀lɛ̌ atdírɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyɨ nyʉ̀nɨ wà Kàgàwà bhà Ʉyátá: ‹dhu àkǎ nzá nyohò abvo, dhu àkǎ nzá nyɔnzɨ̀ mʉ̀nyɔ̀nɨ̀, ndɨrɔ̀ dhu àkǎ nzá nyɔnzɨ̀ ogbo. Dhu àkǎ nzá nyadɨ tɨ̀tɔ̀ tɔ́ ngàmbì tɨ́ ɔdhɨ̀nʉ rɔ̌, ndɨrɔ̀ dhu àkǎ nzá nyugù ngʉ̌kpà alɛ tɔ́ dhu ʉtrátá ɔ̌. Dhu àkǎ nyɨfʉ àbǎnʉ mà ɨ́yànʉ nà.›» ");
INSERT INTO niy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wɔ̀ alɛ náadʉ̀ dhu àdu Yěsù tɔ̀ ndàtɨ: «Màlimǒ, ma mɨ́fʉ kɔ̌kɔ̀rɨ́ Ʉyátá kɔ́rɔ́ rɔ̀pɛ̀ ndɨ̀ idú ngbángba ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nɨ́ Yěsù adʉ̀ kàndà àzè nyʉ́ nà, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Atdí dhu nɨ́ ndɨ rʉ̀nʉ́ ndɨ̀ nʉ̀bhà: Árà, nyadʉ̀ kɔ́rɔ́ nyɨ nyarɨ́’ɨ̀ nà dhu núdzi, nyadʉ̀ nyɨ nyòngyè fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀, ndɨ dhu bhěyi nɨ́ ndɨ nyɨ nyabáya ònzì ɔ̀rʉ̀-akpà ɔ̀. Wɔ̀ dhu-dzidɔ̌, ádʉ̀ nyɨra, nyadʉ̀ owùdu nʉ́ngʉ.» ");
INSERT INTO niy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pbɛ́tʉ̀ wɔ̀ alɛ níitdègu wɔ̀ ɔtɛ nɨ́rɨ, nɨ́ kànyɨ̀-ɔ̌nga náadʉ̀ ɨ̀fà ɨ̀fà tɨ́, ndàdʉ̀ àrà ɨzʉ nyʉ́ nà, ábhɔ̌ ònzì nyʉ́ nà ndɨ̀ ndɨ́’ɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nɨ́, Yěsù náandà tɨná nga, ndàdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ònzìtálɛ rǒtsù Kàgàwà bhà Idzi ɔ̀ dhu nɨ́ odú dhu nyʉ́!» ");
INSERT INTO niy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nɨ́, ɨdhɔ nʉ́ʉkɔ ábhàlɨ̌ atdídɔ̌ nyʉ́ wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀. Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Pbànɨ̌nzó, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi ɔ̀ ka kótsù dhu nɨ́ odú dhu nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngàmɨyà rǒtsù ndʉ̀dà sìndanɨ̀-bhu ɔ̀nǎ dhu rɨ̌’ɨ̀ ɨsɔ́ nyʉ́. Pbɛ́tʉ̀ ònzìtálɛ rǒtsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi ɔ̀ dhu rɨ̌’ɨ̀ odú nyʉ́ ròsè.» ");
INSERT INTO niy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɨdhɔ náadʉ̀ ábhàlɨ̌ nʉ́kɔ atdídɔ̌ nyʉ́ ròsè angyi ɨ̀’ɨ̀nà dɔ̀nǎ, abádhí ràdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Olu, ádhɨ nyʉ́ ndɨ ɔ̀gʉ̀ rádʉ̀ ɔ̀gʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nɨ́, Yěsù andà pbɨ̀ndà ábhàlɨ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ìndrǔ tɔ̀ ndɨ dhu rɨ̌ nzɨ̌ àdʉ̀ àkǎ, pbɛ́tʉ̀ Kàgàwà tɔ̀ kà rǎdʉ̀ àkǎ àkǎ. Obhó tɨ́, Kàgàwà tɔ̀ kɔ́rɔ́ dhu náarɨ́ àkǎ àkǎ.» ");
INSERT INTO niy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ apɛ̀ ɔtɛ ndàtɨ kà nɨ̌: «Ɨ́rɨ, mǎ mʉ́bhà kɔ́rɔ́ dhu, mǎdʉ̀ owùnʉ nʉ́ngʉ.» ");
INSERT INTO niy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: atdí alɛ mà náapɛ́ pbɨ̀ndà ɨdza, adɔ́na, awɛ́na, ɨ́yànà, àbanà, pbɨ̀ndà nzónzo mà, pbɨ̀ndà ɔnzɨbvʉ mànà nʉ́bha okúdu dɔ̀ rɔ̀, ndɨrɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀-okú dɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nɨ́ yà kòmbí àlɛ̌ kɨ́’ɨ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kǎbáya ɨdza, adɔ́na, awɛ́na, ayína, inzo, ɔnzɨbvʉ mànà atdí mɨyà-gʉ̀na ròsè, kadʉ̀ àvu rɔ̀ná átɔ̀. Ndɨrɔ̀ olù rɨ́rà kàsʉmɨ̀ ɔ̌, kǎdʉ̀ya dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pbɛ́tʉ̀, ábhɔ̌ alɛ yà kòmbí arɨ́’ɨ̀ wɛmbɛrɛ̀ tɨ́, nóokoya olù alɛ tɨ́. Ndɨrɔ̀ yà olù alɛ tɨ́ arɨ́’ɨ̀ kòmbí alɛ nóokoya wɛmbɛrɛ̀ t’álɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ndɨ kàsʉmɨ̀ ɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà nɨ́ɨ’ɨ̀ Yèrùsàlɛmà ɨ̀ úpo ɔ̀ná otu ɔ̌. Nɨ́, Yěsù náadɨ̀ ndàmbɛ àrà dɔ̌ angyi abádhí tɔ̀. Nɨ́ ɨdhɔ nʉ́ʉkɔ kàbhà ábhàlɨ̌ atdídɔ̌, ndɨrɔ̀ kà-dzidɔ̌ ríwu alɛ náadʉ̀ ɨ̀’ɨ̀ ɔdɔ nà. Nɨ́ Yěsù náanzi atdí-kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ tɨna ɔ̀ tdɨ́tdɔ̌, ndàdʉ̀ ndɔ̀pɛ̀ ndàwɛ rɔ̀ná rɨ́ ndɔ̀nzɨ ɨnzá ɔ̀trɔ̀ kàsʉmɨ̀ ɔ̌ dhu fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kǎtɨ abádhí nɨ̌: «Nyɨ̀rɨ dhu, kànɨ̌ àlɛ̌ kúpo Yèrùsàlɛmà. Nɨ́ ányɨ̀, ka kɨ́ Ìndrǔ t’Ídhùnà nábhʉ̌ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà-fɔ́. Abádhí rɨ̌ anya ɔ̀tdɨ̀ kà-dɔ̌ ndɨ́nɨ̌ ka koho tɨ́, ndɨrɔ̀ abádhí rɨ̌ kàbhʉ̌ ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɨ alɛ rɨ̌ kà gàyà nɔ́nzɨ, ɨ̀ rùso ɨsɔ kà-dɔ̀, ’ʉ̀vɨ ka asé nɨ̌, ’àdʉ̀ kòhò, kadʉ̀ kɔ̀tdʉ̀. Ndɨrɔ̀, ɨ̀bhʉ ɨdhɔ dzidɔ̌, kǎdʉ̀ya ndɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wɔ̀ dhu-dzidɔ̌, Zɛ̀bɛ̀dayò bhà inzo, Yàkɔbhɔ̀ mà Yùwanɨ̀ nà níiwú Yěsù-tɨ’ɔ̀, àdʉ̀ àtɨ̀nà kà nɨ̌: «Mǎ mòzè nyɔnzɨ̀ fʉnʉ́ mǎ mónzina dhu fǎkà.» ");
INSERT INTO niy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu nyɨ̌ nyòzè mɔnzɨ̀ fʉ̌kʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nɨ́, abádhí adʉ̀ dhu àdu kà tɔ̀ àtɨ: «Pbʉ̀kʉ̀ Idzi tɔ́ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̀ nyɨ nyótsù nɨ́nganɨ́, nyɨ nyabhʉ̀ya mǎ mǒkò tɨnʉ́, atdí alɛ ràdɨ ɨndʉ́ fangà dɔ̀nǎ rɔ̀, ngǎtsi alɛ ràdʉ̀ àdɨ ígù dɔ̀nǎ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pbɛ́tʉ̀ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyʉ̀nɨ nzá wɔ̀ nyɨ̌ nyònzì dhu. Nyɨ̌ tɨ́ àdʉ̀ yà ma mɔ́mvʉ̀na àpbɛ̀ tɔ́ kɔ́pà-tsʉ̀ nɔ́mvʉ̀ ɔ̀mvʉ̀? Ndɨrɔ̀ nyɨ̌ tɨ́ àdʉ̀ yà ma málʉ̌na àpbɛ̀ tɔ́ bàtizò nálʉ àlʉ̌?» ");
INSERT INTO niy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ àtɨ: «Ɔ̀nzɨ mǎ mádʉ̀ lɛ̀màna nɔ́nzɨ̀.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Obhó tɨ́, ɔ̀mvʉ̀ nyɨ̌ nyɔmvʉ́ya ma mɔ́mvʉ̀na àpbɛ̀ tɔ́ kɔ́pà-tsʉ̀, nyǎdʉ̀ ma málʉ̌na àpbɛ̀ tɔ́ bàtizò nálʉ. ");
INSERT INTO niy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pbɛ́tʉ̀, ìndrǔ nɨ́lɨ̌ ka kɨ́ ràdɨ idú fangà dɔ̀nǎ rɔ̀, ndɨrɔ̀ idú ígù dɔ̀nǎ rɔ̀ dhu nɨ́ nzɨ̌ ɔ̀tɛ̌du. Ɨ ngari nɨ́ Kàgàwà náabhɔ̀lɔ̀ ka fɨ̌yɔ̀ alɛ tɔ́.» ");
INSERT INTO niy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, atdí-kumì ngʉ̌kpà ábhàlɨ̌ náadʉ̀ àkǒ àkǒ tɨ́ Yàkɔbhɔ̀ mà Yùwanɨ̀ nà rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nɨ́ Yěsù adʉ̀ abádhí nánzì kɔ́rɔ́, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyʉ́nɨ wà yà ìndrǔ ʉ̀nda rɨ́ dhu tɨ́ ka kátɨna alɛ náarádʉ̀ ’à’ɛ yà ɨ̀ ʉ́ndana alɛ dɔ̌ tɨ́ dhu. Ndɨrɔ̀, nyɨ̌ nyʉ́nɨ wà ìndrǔ dɔ̌ ádrɔ̀drɔ̌ alɛ tɨ́ ka kátɨna alɛ náarádʉ̀ òko ’àmbɛ ɔbɨ̀ya kɛ̀lɛ̌ nívì dɔ̌ ìndrǔ tɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pbɛ́tʉ̀, dhu àkǎ nzá ndɔ̀nzɨ̀ ndɨ̀ wɔ̀ ndɨ bhěyi nzínzìkʉ ɔ̌. Atdí nzínzìkʉ ɔ̌ alɛ náapɛ́ ndòzè ndɨ̀’ɨ̀ ádrʉ̀ngbǎlɛ tɨ́, nɨ́ kàkǎ ndɨ̀’ɨ̀ fʉ̀kʉ́ kasʉtálɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ndɨrɔ̀, atdí nzínzìkʉ ɔ̌ alɛ náapɛ́ ndòzè ndɨ̀’ɨ̀ wɛmbɛrɛ̀ t’álɛ tɨ́, nɨ́ kàkǎ ndɨ̀’ɨ̀ kɔ́rɔ́ alɛ tɔ́ ɨnɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Obhó tɨ́, ɨma Ìndrǔ t’ídhùnà, ma mɨra nzá ndɨ́nɨ̌ ma mabhʉ̀ tɨ́ ìndrǔ rɔ̀nzɨ̀ kasʉ idù, pbɛ́tʉ̀ ma mɨra ìndrǔ-kàsʉ̌ ma mɔnzɨ tɨ́, madʉ̀ pbàkà ípìrɔ̌nga nábhʉ kɔ́rɔ́ alɛ nʉwʉ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà níiwú ùvò Yɛ̀rɨkɔ̀ tɨ́ kátɨna kɨgɔ̀ ɔ̀. Nɨ́ ndɨ kɨgɔ̀ ɔ̀ rɔ̀ abádhí rǔvò pbɨ̀ndà ábhàlɨ̌ mànà, ndɨrɔ̀ ádrʉ̀ngbǎ ihé-yà mànà ɔ̀ná kàsʉmɨ̀ ɔ̌, atdí ndùmùndúmú Bàràtìmayò tɨ́ kátɨna, Tìmayò t’ídhùnà, náadɨ̀ otu-igì dɔ̌ ndàmbɛ dhu núnzi dɔ̌ ìndrǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nɨ́, kǐtdègu dhu nɨ́rɨ Yěsù, Nàzàretì ɔ̌ alɛ ràrɨ̌ wɔ̀ rɨ́rà, nɨ́ kǎpɛ̀ ndùkǔ, ndàmbɛ àtɨ̀nà dɔ̌: «Yěsù, Dàwudì t’Ídhùnǎ, ábà ɨzʉ dùdú!» ");
INSERT INTO niy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ábhɔ̌ alɛ náambɛ́nà ɔ̀rʉ̀ dɔ̌ kàdɔ̌ ndɨ́nɨ̌ kɨ̌nɛ̀ tɨ́. Pbɛ́tʉ̀, kǎdʉ̀ àdɨ ndàmbɛ ùkǔ dɔ̌ àrǐ nyʉ́ tɨ́ tdɨ́tdɔ̌, ndàmbɛ àtɨ̀nà dɔ̌: «Dàwudì t’Ídhùnǎeè, ábà ɨzʉ dùdú!» ");
INSERT INTO niy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nɨ́ Yěsù adʉ̀ ìde, ndàdʉ̀ àtɨ̀nà: «Nyànzi pɛ́ ka!» Nɨ́ abádhí náadʉ̀ wɔ̀ ndùmùndúmú nánzì, ’àdʉ̀ àtɨ̀nà nɨ̌: «Ótù afínʉ! Ɨ́và nyɨ, kànɨ̌ kà rɨ̌ nyanzi!» ");
INSERT INTO niy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nɨ́ kǎbvù pbɨ̀ndà ɔrʉ́ mʉ̀dzarʉ̀, ndàdʉ̀ ndɨ̀bɛ̀ ndìdè, ndàdʉ̀ àrà Yěsù-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nɨ́ Yěsù níivú dhu kà-tsʉ̌ ndàtɨ: «Ádhu nyɨ nyòzè mɔnzɨ̀ ɨndʉ̀?» Nɨ́ wɔ̀ ndùmùndúmú náadù ɔtɛ kà tɔ̀ ndàtɨ: «Màlimǒ, ma mòzè mala nga tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Árà, ɨwà pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ nyɨ.» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ kǎdʉ̀ nga nɔ́pɛ̀ ndàla, ’àdʉ̀ òwu atdí otu ɔ̌ Yěsù mànà. ");
INSERT INTO niy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà rɨ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ níndù ɔ̀ná kàsʉmɨ̀ ɔ̌, abádhí náawù ùvò ɨ́kyɛ̀rɔ̌ Bɛ̀tɛ̀fagɛ̀ mà Bɛ̀tànɨyà mànà tɨ́ kátɨna pbangá nzo tɨ́. Ɨ pbangá nzo nɨ́ɨ’ɨ̀ Mìzèyìtunì tɔ́ pbìrì-ɔngɔ̀ rɔ̌. Nɨ́ Yěsù avì pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ ɔ́yɔ̌ alɛ, ");
INSERT INTO niy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu wɔ̀ angyi rɨ́’ɨ̀ fʉ̌kʉ̀ pbanga ɔ̀. Nɨ́ ányɨ̀ nyɨ̌ nyótsù rɔ́rɔ̀ tɨ́, nyɨ̌ nyɨ́ atdí kayinǒ-ngba nótù òsò ka kòsò rɔ́, yà ɨnzá atdí alɛ mà nápɛ̀ ùbhi dɔ̀ná angyi. Nɨ́ nyʉ̀nga ka, nyǎdʉ̀ ìwu nà ɨrɔ́. ");
INSERT INTO niy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ndɨrɔ̀, atdí alɛ mà níivúna gukyè dhu tsʉ̀kʉ́ ndàtɨ: ‹Ádhu nyɨ̌ nyɨ́ wɔ̀ dhu ɔ̀nzɨ okúna dɔ̀ rɔ̀?› Nɨ́ nyɨ̌ nyadʉ̀na àtɨ̀nà ndɨ alɛ nɨ̌: ‹Ádrʉ̀ngbǎlɛ rɨ̌ kǎtdyú nóho, ndɨrɔ̀ kà rɨ̌ kàdǔ kòmbí tɨ́.› » ");
INSERT INTO niy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nɨ́ abádhí náadʉ̀ òwu, àdʉ̀ kayinǒ-ngba nótù irí, tsǎtsʉ̀ tɨ́ ka kòsò ngʉdhà-bɨdɔ̌ rɔ́. Nɨ́ abádhí adʉ̀ kʉ̀nga. ");
INSERT INTO niy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngúfe alɛ, wɔ̀ ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌, níivú dhu abádhí-tsʉ̌ ’àtɨ: «Ádhu wɔ̀ nyɨ̌ nyɔ́nzɨna? Ádhu nyɨ̌ nyɨ́ wɔ̀ kayinǒ-ngba nʉ́ngǎ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nɨ́ kɔ̌kɔ̀ ɔ́yɔ̌ ábhàlɨ̌ náadʉ̀ yà Yěsù ɔ̀vɔ̀nà fɨ̌yɔ̀ ɔtɛ kɛ̀lɛ̌ nádu abádhí tɔ̀, kadʉ̀ abádhí nʉ́bhà ròwù. ");
INSERT INTO niy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Abádhí níiwú wɔ̀ kayinǒ-ngba nà Yěsù-tɨ’ɔ̀. Abádhí adʉ̀ rɔ̀yá ɔrʉ́ mʉ̀dzarʉ̀ nʉ́wà, ’ùhu ndɨ kayinǒ-ngba dɔ̌, Yěsù ràdʉ̀ àdɨ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ibí alɛ náadʉ̀ rɔ̀yá ɔrʉ́ mʉ̀dzarʉ̀ nʉ́wà, ’ùhu otu ɔ̌. Ndɨrɔ̀ ngʉ̌kpà alɛ náadʉ̀ yà ɨnga ɔ̌ ɨ̀ à’à àwǎ-dɔ̀ká núhu otu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nɨ́, yà angyi rówu Yěsù-ɔ̀nzɨ̌ alɛ mà, kǒwù ɔ̌ ríwu alɛ mànà náambɛ́nà ùkǔ dɔ̌ ’àtɨ: «Hɔ̀sanà! Ádrʉ̀ngbǎlɛ Kàgàwà nákǎ ndàso ɔvɔ̀na rɔ̌ rɨ́rà alɛ! ");
INSERT INTO niy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kàgàwà nákǎ ndàso yà rɨ́rà àlɛ̌ t’ábanà, ádrʉ̀ngbǎ kamà Dàwudì bhà Idzi! Hɔ̀sanà ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Kàgàwà tɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nɨ́ Yěsù náarà àhʉ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ndàdʉ̀ òtsù Kàgàwà bhà ɨdza. Nɨ́, tɨná rɨ́’ɨ̀ kɔ́rɔ́ dhu ndɨ̀ ndàndà dhu-dzidɔ̌, abádhí náadʉ̀ ùvò ’òwù pbɨ̀ndà atdí-kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ mànà Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̀, ɨnga rɨ̌rà ndɨ́nɨ̌ ndatɨ̀ tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tsútsǎ nɨ́nganɨ́, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà rǔvò Bɛ̀tànɨyà rɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù nɨ́ɨ’ɨ̀ àwù nà. ");
INSERT INTO niy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nɨ́ ɨtsɛ rɔ̀, kǎla mùtinì tɨ́ kátɨna itsu atdídɔ̌ bɨ̌na núkǔ rɔ́. Nɨ́ kǎdʉ̀ àrà ndɨ itsu dɔ̀ nga nándà, ndɨ́nɨ̌ ndotú tɨ́ itsu-kpɔ̌ kàdɔ̀. Nɨ́ ɨ́kyɛ̀rɔ̌ ndɨ̀ ndàrà àhʉ ndɨ itsu-tɨ́ rɔ̀, kǎtù kà-bɨ̌ kɛ̀lɛ̌, ndɨ kàsʉmɨ̀ nɨ’ɨ̀ ɨ̀nzɨ̌ ndɨ itsu-tɨdɔ̀ náarɔ́’ɔ̀ ɔ̀ná nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nɨ́ Yěsù atɛ̀ wɔ̀ itsu nɨ̌ ndàtɨ: «Dhu àkǎ nzá atdí alɛ mà rɔ̀tɔ̀ dʉ̀nʉ́ rɔ́’ɔ̀ itsu-kpɔ̌ ɨ̀ngbàngá màtɨ́!» Kàbhà ábhàlɨ̌ náadʉ̀ wɔ̀ kʉ̀nɔ̀ dhu nɨ́rɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò tdɨ́tdɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Nɨ́ kǎtsù Kàgàwà bhà ɨdza, ndàdʉ̀ ndɔ̀pɛ̀ ndòdì ányɨ̀-dzá rɔ̀ rɨ́ dhu núdzǐ alɛ. Kǎránà fʉ̀rangà-ɔ̌nga nʉ́wʉ̌ ka kɨ́ dɔ̀ná rɔ̀ mɨzà nótdì rɔ̌, ndàdʉ̀ àmbò núdzǐ rɨ́ alɛ nókò dɔ̀yá kitì náwà. ");
INSERT INTO niy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ndɨrɔ̀ kǎránà nzɨ̌ atdí alɛ mà nábhʉ rɔ̌ rànɔ̀ dhu dɔ̀ná, ndʉ̀dà nà Kàgàwà bhà ɨdza ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɨ́ kǎdʉ̀ dhu ùdhe abádhí tɔ̀ ndàtɨ: «Ɨ̀lɨ̌lǎ Andítá ɔ̀, Kàgàwà rǎtɨna: ‹Pbàkà ɨdza ka katɨya ɨtsɔ̀ta-dzà tɨ́ kɔ́rɔ́ pbìrì ɔ̌ alɛ tɔ̀.› Pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyádʉ̀ kʉ̀gɛ̀rɛ̀ ròngò ogbotálɛ náarɨ́ ’òtù ɔ̀ná ngari tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nɨ́ Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà Ʉyátá tɔ́ màlímó mànà nɨ́ɨrɨ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu. Nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀nɛ̀ Yěsù nábhʉ̌ ɨ̀ ɨ́ kohò ɔ̀ná otu. Obhó tɨ́, abádhí ambɛ́nà kɔ̌dɔ̀ ɔ̀nzɨ̀ dɔ̌, kɔ́rɔ́ alɛ nʉ́kɔ rɔ̌ ɨdhɔ rǎrà kà rǔdhěna dhu dɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɨnga rǎtɨ dhu-tsʉ̀ dɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náadʉ̀ ùvò ’òwù Yèrùsàlɛmà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tsútsǎ nɨ́nganɨ́ kútsingánǎ, otu ɔ̌ ’ʉ́da rɔ́rɔ̀, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náala yà Yěsù ófùná mùtinì tɨ́ kátɨna itsu ɨwà òtdyù ɨvɛ́na mànà rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ yà Yěsù ʉ́nɔ̀ná ndɨ itsu nɨ̌ dhu nɨ́rɛ̀, ndàdʉ̀ àtɨ̀nà kànɨ̌: «Màlimǒ, ándà pɛ́ yà nyɨ nyófùná mùtinì nótdyù wà atdídɔ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyà’u Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, atdí alɛ náapɛ́ atɨna yàrɨ́ pbìrì nɨ̌: ‹Ɨ́ngbɛ̀ nyɨ ʉrɔ́ rɔ̀, nyadʉ̀ àrà ɨ̀tsɨ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̀›. Nɨ́, ɨ̀nzɨ̌ kǎfí náapɛ́ ùguru, pbɛ́tʉ̀ kà ràdʉ̀ yà ndɨ̀ ndʉ̀nɔ̀ dhu rɨ̌ ndɔ̀nzɨ dhu ná’ù, nɨ́ ndɨ dhu rǎdʉ̀ ndɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mátɨna nyɨ̌ nɨ̌, Kàgàwà-fɔ́ nyɨ̌ nyónzina ɨtsɔ̀ta ɔ̌ kɔ́rɔ́ dhu, nákǎ nyǎ’ù ɨwà nyɨ̌ ràbà ndɨ dhu. Nɨ́ kà rǎdʉ̀ ndɨ dhu nábhʉ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndɨrɔ̀, nyɨ̌ nyìkò nyǎmbɛ nyɨ̌tsɔ̀ dɔ̌ Kàgàwà rɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, nyɨ̌ nyapɛ́ ɨ̀ ìnè dhu nà afíkʉ ɔ̀ ɔdhɨ̀kʉ dɔ̌, nɨ́ dhu àkǎ nyʉ̌bà ndɨ dhu kà tɔ̀, ndɨ́nɨ̌ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ náadʉ̀ tɨ́ fʉ̀kʉ́ afátá nʉ́bà fʉ̌kʉ̀.  ");
INSERT INTO niy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pbɛ́tʉ̀, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ dhu nʉ́ba ngʉ̌kpà alɛ tɔ̀, nɨ́ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ rɨ̌ nzɨ̌ àdʉ̀ fʉ̀kʉ́ afátá nʉ́bà fʉ̌kʉ̀ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náadù ɨ̀ tdɨ́tdɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Nɨ́ Kàgàwà bhà ɨdzá Yěsù rǔbhi ɔ̀ná kàsʉmɨ̀ ɔ̌, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàyàhúdí tɔ́ pbàkʉ̀rʉ̌ mànà níiwú kà ɨ. ");
INSERT INTO niy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nɨ́ abádhí níivú dhu kà-tsʉ̌ ’àtɨ: «Kɔ̌kɔ̀rɨ́ dhu nɔ́nzɨ nyɨ nyárɨ́ àdhɨ-tù rɔ̌? Ádhɨ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ ɨndʉ̀ nyongò ɨ dhu nɔ́nzɨ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ma mɨ́ atdí dhu kɛ̀lɛ̌ nívǔ tsʉ̀kʉ́. Nyɨ̌ nyapɛ́ ndɨ dhu nádǔ idù, nɨ́ ma mádʉ̀ yà ma marɨ́ ɨ dhu nɔ́nzɨ pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ alɛ nʉ́nɔ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ádhɨ Yùwanɨ̀ nívì rɨ̀rà bàtizò núbho ìndrǔ tɔ̀? Tɨ́ Kàgàwà, ndɨrɔ̀ tɨ́ ìndrǔ? Nyàdu pɛ́ ka idù.» ");
INSERT INTO niy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pbɛ́tʉ̀ abádhí náapɛ̀ ’ɨ̀rɛ̀ ɨnga nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Àlɛ̌ kapɛ́ dhu àdǔ: ‹Kàgàwà nɨ́ ndɨ ka nívì›, nɨ́ kǎdʉ̀na dhu ìvu àlɛ̌-tsʉ̌, ndàtɨ: ‹Olu, ádhu ɨnzá nyɨ̌ nyádʉ̀ Yùwanɨ̀ nʉ́ʉnɔ dhu ná’ù nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ndɨrɔ̀, àlɛ̌ kapɛ́ àtɨna: ‹Ìndrǔ nɨ́ ndɨ ka nívì…›» Abádhí náambɛ́nà ihé-yà-ɔdɔ̀ nɔ́nzɨ̀ dɔ̌, kɔ́rɔ́ alɛ nʉ́ʉnɨ dhu Yùwanɨ̀ ràrɨ̌ Kàgàwà bhà obhóná nabì nyʉ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nɨ́ abádhí adʉ̀ dhu àdu Yěsù tɔ̀ ’àtɨ: «Ɨnzá mǎ mʉ̀nɨ.» Nɨ́ Yěsù adʉ̀ dhu àdu ndàtɨ: «Nɨ́rɔ̀, ɨma mà átɔ̀, ma mɨ́ nzɨ̌ ɨ dhu nɔ́nzɨ ma marɨ́ nɨ̌ ɔbɨ nʉ́nɔ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tdɨ́tdɔ̌, Yěsù náapɛ̀ ndàwɛ ɔtɛ mbólí ɔ̌ abádhí tɔ̀ ndàtɨ: «Atdí alɛ náazò vǐnyò tɔ́ ɨnga, ndàdʉ̀ ngbɔ̌na nákpɔ̀rɔ̀ kɔrɔwà nɨ̌. Kǎdʉ̀ ndɨ vǐnyò-kpɔ̌ náhà ka kóngo ɔ̀ná ibhu nɔ́bhɔ̀lɔ̀, ndàdʉ̀ ini nɔ́sɨ̀ ɔdɔ́tálɛ tɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɨ ɨnga nʉ́bhà kasʉ ɔ̀nzɨ̀ róngo kà ɔ̌ alɛ-fɔ́, ndàdʉ̀ àrà abhi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nɨ́ ndɨ vǐnyò-kpɔ̌ nɔ́pɛ̀ ka kɨ́ ɔ̀ná kàsʉmɨ̀ nákǎ rɔ̀, kǎvì atdí pbɨ̀ndà kasʉtálɛ ràrà fɨ̌ndà ka kútù vǐnyò-kpɔ̌-tsí nákɔ ndɨ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pbɛ́tʉ̀, abádhí náalʉ́ wɔ̀ ka kìvìnà alɛ ’ɔ̀ngbʉ̀, ’àdʉ̀ àdunà ròngò ɔtsʉ́na-kpa nà. ");
INSERT INTO niy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nɨ́, ɨnga-àbadhi náavì ngǎtsi kasʉtálɛ ràrà abádhí-tɨ’ɔ̀. Nɨ́ abádhí nʉ́ʉvɨ ndɨ alɛ-dɔ̀-tsirɔ̀, ’àdʉ̀ dhu ʉ̀nɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɨnga-àbadhi náavì ngǎtsi alɛ tdɨ́tdɔ̌ ányɨ̀, abádhí ràdʉ̀ ndɨ-tsí nóhò. Ndɨrɔ̀, kǔví ibí ngʉ̌kpà kasʉtálɛ ányɨ̀, nɨ́ abádhí náavɨ̀ atdídhená-tsí, ’àdʉ̀ ngʉ̌kpǎkà nɔ́kyɛ̀. ");
INSERT INTO niy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nɨ́, wɔ̀ ɨnga-àbadhi-fɔ́ arà ɔ̀dɨ̀ nɨ́ atdí kà t’ídhùnà yà atdídɔ̌ kǒzè kɛ̀lɛ̌. Nɨ́ kà rǐku dɔ̀ná rɔ̀ nɨ̌, kǎvì ndɨ idhùnà abádhí ɨ, ndàdʉ̀ ɨnga nɨ́rɛ̀ afína ɔ̀ ndàtɨ: ‹Ɨ̀fʉ̌ abádhí rɨ̌ idhùdu nɨ́fʉ̌.› ");
INSERT INTO niy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pbɛ́tʉ̀, wɔ̀ vǐnyò tɔ́ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ náadʉ̀ ɔ̀tɛ nzínzìya ɔ̌ ’àtɨ: ‹Kɔ̀nɨ̌ ɨnga-àbadhi tɨ́ ongoya olù alɛ nɨ́ wɔ̀. Kòwu kòho ka, ndɨ́nɨ̌ ndɨ ɨnga náadɨ̀ya tɨ́ àlɛ̌ tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nɨ́ abádhí náalʉ́ kà t’ídhùnà ’òhò, ’àdʉ̀ abvòna nóbvù ɨtsɛ ndɨ ɨnga ɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nɨ́ Yěsù adʉ̀ dhu ìvu ndàtɨ: «Ádhu nyʉ́ wɔ̀ ɨnga-àbadhi rǎdʉ̀ ɔ̀nzɨ̀nà? Kà rǎdʉ̀ ɨ̀rà, ndɔ̀kyɛ̀ wɔ̀ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ, ndàdʉ̀ ndɨ vǐnyò tɔ́ ɨnga nábhʉ ngʉ̌kpà alɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nyɨ̌ nyɔ́zʉ̀ tɨ́ nzá yà Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu: ‹Yà odu-dzà nɔ́sɨ̀ arɨ́ alɛ náabvù igi odu, náadʉ̀ òngo ɨdza-pbɨdɔ̀ nɔ́dɔ arɨ́ odu tɨ́. ");
INSERT INTO niy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kɔ̀nɨ̌ Ádrʉ̀ngbǎlɛ Kàgàwà náanzɨ̀ dhu, ndɨrɔ̀ ndɨ dhu nɨ́ ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ atdídɔ̌ dhu.›» ");
INSERT INTO niy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nɨ́ Pbàyàhúdí ɔ̌ kámá náasʉ̀ dhu ɨ̀ ràrɨ̌ ndɨ Yěsù rɨ̌ ɨ̀ ʉ̀nɔ mbólí ɔ̌. Nɨ́ abádhí apɛ̀ ’ɔ̀mɛ̀ Yěsù nálʉ̌ ɨ̀ ɨ́ ɔ̀ná otu, pbɛ́tʉ̀ abádhí adʉ̀ ihé-yà-ɔdɔ̀ nɔ́nzɨ̀. Nɨ́ abádhí adʉ̀ kʉ̀bhà, ’àdʉ̀ òwu fɨ̀yɔ́ dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pbàyàhúdí ɔ̌ kámá náavì ngúfe Pbàfàrìsáyó mà Hɛ̀rɔdɛ̀ bhà alɛ mànà Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ kà-ɨda-dɔ nidyi tɨ́ ɔtɛ̌na ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nɨ́ abádhí náawù, ’àdʉ̀ àtɨ̀nà kà nɨ̌: «Màlimǒ, mǎ mʉ́nɨ wà dhu nyɨ rárɨ́ obhó dhu nʉ́nɔ, ndɨrɔ̀ nyɨ rárɨ́ nzɨ̌ atdí alɛ-ɔdɔ̀ mà nɔ́nzɨ. Obhó tɨ́, nyɨ nyarɨ́ nzɨ̌ ìndrǔ-nyɨ̀-kpa nándà, pbɛ́tʉ̀ nyɨ nyárɨ́ Kàgàwà bhà otu núdhě ìndrǔ tɔ̀ obhónga dɔ̌. Nɨ́, àlɛ̌ tɔ́ Ʉyátá návi tɨ́ àvǐ àlɛ̌ rʉ̀fɔ̌ Rɔmà tɔ́ pbìrì ɔ̌ kámá dɔ̌ ádrʉ̀ngbǎ kamà bhà pàratà? Ndɨrɔ̀, kɨ̌sɔ̌ tɨ́ ka ɨ̀sɔ̌? Àlɛ̌ tɨ́ àdʉ̀ kʉ̀fɔ ʉ̀fɔ̌, ndɨrɔ̀ àlɛ̌ tɨ́ nzɨ̌ àdʉ̀ kʉ̀fɔ?» ");
INSERT INTO niy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pbɛ́tʉ̀, òru tɨ́ abádhí òrù yà ɨ̀ ɨ́rɛ̀na afíya ɔ̀ dhu dhu ndɨ̀ ndʉ̀nɨ rɔ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu nyɨ̌ nyɨ́ afídu númvǔ nɨ̌? Nyìbho pɛ́ atdí fʉ̀rangà-kpɔ̌ fudu ɔ̀, ndɨ́nɨ̌ mandá tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nɨ́ abádhí náadʉ̀ ìwu fʉ̀rangà-kpɔ̌ nà atdí Yěsù-fɔ ɔ̀. Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Yà ka kɔ̀bhɔ̀lɔ̀ nyɨ̀na-wɔ̀yɔ̌, kadʉ̀ ɔvɔ̀na nándi alɛ nɨ́ àdhɨ?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Kámá dɔ̌ ádrʉ̀ngbǎ kamà Kàyìsarà.» ");
INSERT INTO niy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ndɨ dhu bhěyi kà rɨ̌’ɨ̀ rɔ̀, nyùbho kámá dɔ̌ ádrʉ̀ngbǎ kamà Kàyìsarà bhà dhu-tsí Kàyìsarà tɔ̀, nyǎdʉ̀ Kàgàwà bhà dhu-tsí núbho Kàgàwà tɔ̀.» Wɔ̀ dhu bhěyi Yěsù àdu dhu náadʉ̀ abádhí àbhʉ ɨdhɔ rʉ̀kɔ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wɔ̀ dhu-dzidɔ̌, ngúfe Pbàsàdùkáyó níiwú Yěsù-tɨ’ɔ̀. Abádhí nɨ́ ndɨ arátɨna ɨ̀nzɨ̌ ʉ̀vʉ̌vɛ̀ alɛ rʉngbɛya ɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ abádhí níivú dhu Yěsù-tsʉ̌ ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Màlimǒ, Músà náandí dhu yà dhu bhěyi fǎkà: ‹Atdí alɛ t’ádɔ̀nà náapɛ́ ɔ̀vɛ̀, ndàdʉ̀ tsìbhálɛ nʉ́bhà ɨ̀mbǎ atdí ngbángba nà màtɨ́ fɔná, nɨ́ dhu àkǎ ndɨ alɛ rùndu adɔ̀nà ʉ̀bhà abvo-àyi-tsʉ̀, ’àdʉ̀ nzónzo nɔ́dhɨ̀ nà yà ɔ̀vɔ̀vɛ̀ adɔ̀nà-ɔvɔ̀ dɔ̌.› ");
INSERT INTO niy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nɨ́, atdí alɛ nɨ́ɨ’ɨ̀ kpabhínzo nà àrʉ̀bhʉ̀. Nɨ́ sengba náambà tsìbhálɛ, ndàdʉ̀ ɔ̀vɛ̀ ɨ̀nzɨ̌ ndʉ̀bhà atdí ngbángba mà. ");
INSERT INTO niy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nɨ́ kà lutɨ̀nǎ kpatsìbhíngba náadʉ̀ wɔ̀ abvo-àyi-tsʉ̀ núndu, ndàdʉ̀ ɔ̀vɛ̀ átɔ̀ ɨ̀nzɨ̌ ndʉ̀bhà atdí ngbángba mà. Ndɨ dhu náanzɨ̀ ndɨ̀ ndɨ dhu bhěyi tɨ́ ɨ̀bhʉ rɨ́ kìsě kpatsìbhíngba rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɨ́ kɔ́rɔ́ kɔ̌kɔ̀ àrʉ̀bhʉ̀ kpabhínzo wɔ̀ tsìbhálɛ nʉ́mbǎ ndɨ̀ fɨ̌yɔ̀, nʉ́ʉvɛ̀ kɔ́rɔ́ ɨ̀nzɨ̌ ’ʉ̀bhà atdí ngbángba mà. Abádhí nʉ́vɛ kɔ́rɔ́ dhu-dzidɔ̌, wɔ̀ tsìbhálɛ náadʉ̀ ɔ̀vɛ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nɨ́ kòmbí, kɔ́rɔ́ ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ nɨ́nganɨ́, wɔ̀rɨ́ tsìbhálɛ nɨ’ɨya àdhɨ bhà? Obhó tɨ́ kɔ́rɔ́ kɔ̀rɨ́ àrʉ̀bhʉ̀ kpabhínzo nʉ́ʉmbá wà ɨ̀ ndɨ tsìbhálɛ nà.» ");
INSERT INTO niy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyùwǐ wà fʉ̀kʉ́ ɨrɛ̀ta ɔ̌: nyɨ̌ nyʉ̀nɨ nzá Kàgàwà bhà Andítá nʉ́nɔ̀ dhu mà, ndɨrɔ̀ nyɨ̌ nyʉ̀nɨ nzá Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ mà. ");
INSERT INTO niy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Obhó tɨ́, ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ nɨ́nganɨ́, kpabhálɛ mà vèbhálɛ mànà nʉ́ʉmbáya nzɨ̌ ɨ̀, pbɛ́tʉ̀ abádhí nóokoya Kàgàwà bhà màlàyíká náaróko ɔ̀rʉ̀-akpà ɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ndɨrɔ̀, yà ʉ̀vʉ̌vɛ̀ alɛ rɨ̌ ’ʉ̀ngbɛ̌ ɔvɛ-bvʉ̀ rɔ̀ dhu dɔ̌, nyɨ̌ nyàpɛ̀ tɨ́ nzá atdí ngari nɔ́zʉ̀ Músà bhà Andítá ɔ̀, yà kàzʉ rɔ̌rʉ̀ rɔ̀ná ɨ̀nzɨ̌ rógbe rɔ́rɔ̀ kɨ̀dzʉ̀mbà dɔ̌? Ányɨ̀rɔ̌ nga nɨ́ ndɨ Kàgàwà atɨ Músà nɨ̌: ‹Ɨma, Ɨma nɨ́ Àbràhamʉ̀ bhà Kàgàwà, Ìsakà bhà Kàgàwà, ndɨrɔ̀ Yàkɔbhɔ̀ bhà Kàgàwà.›» ");
INSERT INTO niy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Kàgàwà nɨ́ nzɨ̌ ʉ̀vʉ̌vɛ alɛ tɔ́ Kàgàwà, pbɛ́tʉ̀ ka nɨ́ ípìrɔ̌ rɔ̀ arɨ́’ɨ̀ alɛ tɔ́ Kàgàwà. Nɨ́ nyɨ̌, nyɨ̌ nyùwǐ atdídɔ̌ nyʉ́ fʉ̀kʉ́ ɨrɛ̀ta ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Músà bhà Ʉyátá tɔ́ màlímó nzínzì ɔ̌ atdí màlimò nɨ́ɨrɨ Yěsù mà rɨ̌ ’àgò Pbàsàdùkáyó mànà dhu. Kǎla Yěsù nádu dhu mběyi nyʉ́ Pbàsàdùkáyó tɔ̀ dhu. Nɨ́ kǎndrì Yěsù ɨ, ndàdʉ̀ dhu ìvu tsʉ̀ná ndàtɨ: «Ɨ́ngbà Ʉyátá ndɨ kɔ́rɔ́ Ʉyátá dɔ̀nǎ ósè?» ");
INSERT INTO niy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Kànɨ̌ kɔ́rɔ́ Ʉyátá dɔ̀nǎ ósè Ʉyátá: ‹Ɨ́rɨ dhu Ìsràyelǐ, àlɛ̌ tɔ́ Ádrʉ̀ngbǎlɛ Kàgàwà nɨ́ ndɨ atdírɔ̀ Ádrʉ̀ngbǎlɛ. ");
INSERT INTO niy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dhu àkǎ nyozè pbʉ̀kʉ̀ Ádrʉ̀ngbǎlɛ Kàgàwà kɔ́rɔ́ afínʉ nà, kɔ́rɔ́ atdyúnʉ nà, kɔ́rɔ́ pbʉ̀kʉ̀ ɨrɛ̀ta nà, ndɨrɔ̀ kɔ́rɔ́ ɔbɨ̀nʉ mànà.› ");
INSERT INTO niy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndɨrɔ̀ kànɨ̌ ɔyɔ rɨ́ kìsě Ʉyátá: ‹Dhu àkǎ nyozè ɔdhɨ̀nʉ yà nyɨ nyʉ́ nyɨ nyózè nyɨ nyɨ-tɨ́rɔ̀ dhu bhěyi.› Kɔ̌kɔ̀rɨ́ ɔ́yɔ̌ Ʉyátá dɔ̀nǎ róse ngǎtsi ʉyátá rɨ̌’ɨ̀ mbǎ.» ");
INSERT INTO niy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nɨ́ Músà bhà Ʉyátá tɔ́ màlimò náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Nyɨ nyɔ̀tɛ̀ mběyi nyʉ́ Màlimǒ. Nyɨ nyʉ̀nɔ̀ dhu nɨ́ obhó dhu: Ádrʉ̀ngbǎlɛ Kàgàwà nɨ́ ndɨ atdírɔ̀ Ádrʉ̀ngbǎlɛ, ndɨrɔ̀ ngǎtsi kà bhěyi Kàgàwà rɨ̌’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nɨ́ dhu àkǎ ìndrǔ ròzè Kàgàwà kɔ́rɔ́ afína nyʉ́ nà, kɔ́rɔ́ pbɨ̀ndà ɨrɛ̀ta nyʉ́ nà, ndɨrɔ̀ kɔ́rɔ́ ɔbɨ̀na nyʉ́ mànà. Ndɨrɔ̀ dhu àkǎ kà ròzè ɔdhɨ̀nà yà ndɨ̀ nyʉ́ ndɨ̀ ndózè ndɨ̀ ndɨ̀tɨ́rɔ̀ dhu bhěyi. Wɔ̀rɨ́ nɨ́ ndɨ ídzì dhu nyʉ́ ròsè Kàgàwà tɔ̀ ka kɨ́ ɨ̀zǎ tɔ́ pɛrɛ̀ nʉ́bɨ màzàbahʉ̀ dɔ̌, kadʉ̀ kɔ́rɔ́ pɛrɛ̀-tɨdɔ̀ núbho kà tɔ̀ dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yěsù náala wɔ̀ Músà bhà Ʉyátá tɔ́ màlimò nádu dhu fɨ̌ndà mběyi nyʉ́ ndɨrɔ̀ ídzì ɨrɛ̀ta nyʉ́ nà dhu. Nɨ́ kǎdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ̀mbǎ nyɨ nyɨ́’ɨ̀ ɨtsɛ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi rɔ̌ rɔ̀.» Wɔ̀ dhu-dzidɔ̌, atdí alɛ mà náamvù nzá ndìvǔ dhu tdɨ́tdɔ̌ Yěsù-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yěsù rɨ̌ dhu núdhě ìndrǔ tɔ̀ Kàgàwà bhà ɨdzá rɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kǐvú dhu ndàtɨ: «Músà bhà Ʉyátá tɔ́ màlímó náarátɨna ɨ̀ngbǎ dhu bhěyi Krɨ́stɔ̀ ràrɨ̌ Dàwudì t’ídhùnà? ");
INSERT INTO niy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ɨ̀lɨ̌lǎ-Alafí rɨ̌ ndʉ̀nda rɔ̀, ádrʉ̀ngbǎ kamà Dàwudì nyʉ́ ndɨ̀tɨ́rɔ̀ náatɨ: ‹Ádrʉ̀ngbǎlɛ Kàgàwà náatɨ pbàkà Ádrʉ̀ngbǎlɛ nɨ̌: ɨ́rà nyadɨ̀ idú fangà dɔ̀nǎ rɔ̀, ràrà àhʉ ma mɨ́ pbʉ̀kʉ̀ òmvǔ nábhʉ̌ nyɔbɛ̀ dɔ̀ya dhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dàwudì nyʉ́ ndɨ̀tɨ́rɔ̀ rɨ̌ kànzi Ádrʉ̀ngbǎlɛ tɨ́. Nɨ́ kà rǎdʉ̀ ɨ̀’ɨ̀ ɨ̀ngbǎ dhu bhěyi átɔ̀ Dàwudì t’ídhùnà tɨ́?» Ábhɔ̌ ihé-yà núubhínà Yěsù rʉ̌nɔna dhu nɨ́rɨ̀ rɔ̌ atdyúya nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yà ndɨ̀ ndúdhěna ìndrǔ tɔ̀ dhu ɔ̌, Yěsù ubhínà àtɨ̀nà rɔ̌ ɨ alɛ nɨ̌: «Nyɔ̀dɔ nyɨ̌ Músà bhà Ʉyátá tɔ́ màlímó rɔ̌ rɔ̀. Abádhí arózèna dhu nɨ́ ’ùbhi ádzàdzǐ kanzʉ̀ ɨ̀ ʉ̀fɔ̌ rɔ́rɔ̀, ’àdʉ̀ ìndrǔ nózè ràtsɛ̀ ɨ̀ ɨfʉta nyʉ́ nà ìndrǔ arɨ́ ’ùndǔ ɔ̀yá ngari ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Unduta-dzà ɔ̌, abádhí arɨ́ ’òzè ’òkò ádrɔ̀drɔ̌ alɛ tɔ̀ ka kɔ̀bhɔ̀lɔ̀ ngari ɔ̌, ndɨrɔ̀ mʉ̀hɛndʉ̀ ɔ̌, ’àdʉ̀ òzè ’òkò ɨfʉta tɔ́ ngari ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Abádhí arɨ́ abvo-ayí-ɨdzà ɔ̌ dhu òvo kɔ́rɔ́, àzèmbè ɨ̀’ɨ́ ’ɨ̀tsɔ̀ ádzàdzǐ ndɨ́nɨ̌ ka katɨ tɨ́ ɨ̀ ídzì alɛ tɨ́ rɔ́rɔ̀. Wɔ̀ dhu-okú dɔ̀ rɔ̀, ka kɨtdɨ̀ya anya abádhí dɔ̌ ɔbɨ nyʉ́ nà.» ");
INSERT INTO niy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wɔ̀ dhu-dzidɔ̌, Yěsù náadɨ̀ Kàgàwà bhà ɨdzá, Kàgàwà tɔ̀ ka karɨ́ pɛrɛ̀ nʉ́dɔ̌ ɔ̀nà sàndukù-tɨ́. Nɨ́ kǎdɨ̀ ndàmbɛ ìndrǔ rɨ̌ fʉ̀rangà nʉ́dɔ̌ ndɨ sàndukù ɔ̀ tɨ́ dhu nándà dɔ̌. Ònzì tɔ́ ibí alɛ nʉ́ʉdɔ fʉ̀rangà abhàbhɔ́. ");
INSERT INTO niy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nɨ́ nǎkʉ̀ tɔ́ atdí abvo-àyi nɨ́ɨra, ndàdʉ̀ ɨ̀nzɨ̌ rɨ́ ábhɔ̌ kasʉ mà nɔ́nzɨ ɔ́yɔ̌ fʉ̀rangà-kpɔ̌-nzo kɛ̀lɛ̌ nɨ́dɔ̀ wɔ̀ sàndukù ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɨ́ Yěsù anzi pbɨ̀ndà ábhàlɨ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Wɔ̀rɨ́ nǎkʉ̀ tɔ́ abvo-àyi nɨ́dɔ̀ fʉ̀rangà sàndukù ɔ̀ ròsè kɔ́rɔ́ alɛ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kɔ́rɔ́ kɔ̌kɔ̀ ngʉ̌kpà alɛ núbho ɨ̀mbǎ rɨ́’ɨ̀ kasʉ nà fɨ̌yɔ̀ fʉ̀rangà kɛ̀lɛ̌ fɔyá rɨ́’ɨ̀ fʉ̀rangà dɔ̌ rɔ̀. Pbɛ́tʉ̀ pbɨ̀ndà nǎkʉ̀ ɔ̌, wɔ̀ abvo-àyi núbho dzʉ̀nàna nɔ́nzɨ àmbɛ̀nà pbɨ̀ndà ípìrɔ̌nga ɔ̌ fɔná rɨ́’ɨ̀ fʉ̀rangà kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yěsù rǎhʉ Kàgàwà bhà ɨdza rɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kàbhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ náatɨ kà nɨ̌: «Màlimǒ, ándà pɛ́! Ɨ́ngbàtɨ́ ʉ̀ya odu kǎkà! Ɨ́ngbàtɨ́ ka kasɨ̀ ɔsɨ́-tɨdɔ̀ yà!» ");
INSERT INTO niy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Nyɨ nyàla tɨ́ wà kǎkà ɔsɨ́-abábá? Kàrɨ́ ɔsɨ́-abábá ka kɔ́sɨ̀ nɨ̌ odu nzínzì ɔ̌, atdí odu mà rɨ̌ nzɨ̌ ndʉ̀bha ngǎtsi odu dɔ̌. Ka kɨ́ abádhí núgòlǒ kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wɔ̀ dhu-dzidɔ̌, Yěsù adɨ̀ Mìzèyìtunì tɔ́ pbìrì dɔ̌, ndàmbɛ Kàgàwà bhà ɨdza nándà dɔ̌ nyɨ̀na-kpa tɨ́. Nɨ́ ɔ̀yá ɨ̀ òtù ɨ̀ Yěsù mànà rɔ̀, Pɛ́tɛrʉ̀ mà, Yàkɔbhɔ̀ mà, Yùwanɨ̀ mà, Àndɛ̀rɛyà mànà níivú dhu Yěsù-tsʉ̌ ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ʉ́nɔ pɛ́ ɨ̀ngbǎ kàsʉmɨ̀ ɔ̌ màtɨ́ wɔ̀ nyɨ nyʉ̀nɔ̀ dhu nɔ́ɔnzɨya ndɨ̀ dhu fǎkà? Ndɨrɔ̀, ɨ́ngbà ize ndɨ kɔ́rɔ́ kɔ̌kɔ̀ dhu rɨ̌ ’ɔ̀nzɨ ɔ̀ná kàsʉmɨ̀ nɨtɛ̀ya?» ");
INSERT INTO niy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nɨ́ Yěsù adʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀ ndàtɨ: «Nyàndà nga mběyi, ɨ̀nzɨ̌ nyǎbhʉ nyɨ̌ atdí alɛ mà rʉ̀trǎ nyɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ábhɔ̌ alɛ nóowuya ìwu rɔ̌ ɔvɔ̀du rɔ̌, ’òwù àtɨ̀nà rɔ̌: ‹Ɨma nɨ́ Krɨ́stɔ̀›. Ndɨrɔ̀ abádhí nʉ́ʉtráya ábhɔ̌ alɛ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ndɨrɔ̀, nyɨ̌ nyɔpɛ́ya gukyè nyɨ̌rɨ̀ ɨla rɨ̌ ndɔ̀nzɨ dhu mà, ɨla dɔ̌ ka kʉ́nɔna dhu mànà, nɨ́ àpɛ́ nyɔ̌nzɨya ɔdɔ. Dhu àkǎ wà kɔ̌kɔ̀ dhu rɔ̀nzɨ̀ ɨ̀, pbɛ́tʉ̀ wɔ̀ dhu nɨ’ɨya nzɨ̌ ɨwà yàrɨ́ adzɨ ɔ̌ dhu-tsʉ̀ nɔ́dɨ̀ ndɨ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Atdí pbìrì ɔ̌ alɛ núugyeya ɨ̀ ngǎtsi pbìrì ɔ̌ alɛ mànà. Ndɨrɔ̀ atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ núugyeya ɨ̀ ngǎtsi ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ mànà. Ndɨ kàsʉmɨ̀ ɔ̌, mùtìtì náabhʉ̀ya dhèdhèrɔ̀ pbìrì rìvi, ndɨrɔ̀ àgǎyì nɨ́ɨtsɨya yà adzɨ ɔ̌. Ndɨ dhu nɨ́ɨ’ɨya àdhàdhɨ̀ ari rɨ̌ ndɔ̀pɛ̀ ndàkà ndɨ̀ ʉgʉta tɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pbɛ́tʉ̀ nyɨ̌, nyàndà nga mběyi. Ka kowuya nyǎbhʉ rɔ̌ anya ʉ̀nɔ arɨ́ alɛ rɨ̀tdɨ̀ ànyǎkʉ. Ka kowuya nyǎbhʉ rɔ̌ kʉvɨ nyɨ̌ unduta-dzà ɔ̌ rɔ̀. Ka kowuya nyǎbhʉ rɔ̌ nyɔ̌nzɨ̀ mʉ̀sambà lɨ̀wálɨ́-ɔ̀nzɨ̌ rɔ̀, ndɨrɔ̀ ádrɔ̀drɔ̌ kámá-ɔ̀nzɨ̌ rɔ̀ okúdu dɔ̀ rɔ̀, ndɨ́nɨ̌ nyɨ̌ nyɨ’ɨ tɨ́ pbàkà ngàmbì tɨ́ abádhí-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Obhó tɨ́, dhu àkǎ pɛ́ kʉnɔ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ angyinǎ rɔ̀ kɔ́rɔ́ pbìrì ɔ̌ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ndɨrɔ̀, nyɨ̌ nà abádhí òwù ànyǎkʉ ka kɨtdɨ̀ tɨ́ rɔ̀, àpɛ́ nyǒwuya afíkʉ nítu rɔ̌ angyangyɨ nyɨ̌ nyʉ́nɔna dhu nɨ̌. Pbɛ́tʉ̀, dhu akáya nyǒwù tsʉ̀kʉ dɔ̌ ɨ̀sɨ̌ ɔtɛ kɛ̀lɛ̌ nʉ́nɔ̀ rɔ̌ ndɨ kàsʉmɨ̀ ɔ̌. Obhó tɨ́, ɨ ɔtɛ nóowuya nzɨ̌ ùvò rɔ̌ ʉ̀kʉ̀ rɔ̀, pbɛ́tʉ̀ Ɨ̀lɨ̌lǎ-Alafí náaraya ndɨ kɨ̀lɨ rɔ̌ tsʉ̀kʉ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ìndrǔ náaraya adɔ̀nà nípfo rɔ̌ ndàbhʉ kohò, ndɨrɔ̀ ɨngba t’ábanà náaraya dhu ɔ̀nzɨ̀ rɔ̌ ndɨ dhu bhěyi tɨ́ pbɨ̀ ɨngba rɔ̌. Nzónzo nɨ́ɨvàya dhu ɨ̀ nɔ́dhɨ̀ alɛ rɔ̌, ’àdʉ̀ abádhí àbhʉ kɔkyɛ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kɔ́rɔ́ alɛ nɔ́ɔndrɔ́ya nyɨ̌ okúdu dɔ̀ rɔ̀. Pbɛ́tʉ̀ Kàgàwà nɨ́ɨgʉ́ya alɛ nɨ́ kɔ̌kɔ̀ dhu-dzi nóndù rɨ́ kɔ́rɔ́ ràrà àhʉ ɨ dhu rǐku dhu ɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̌ nyalaya gukyè ‹ɔdɔ̀na rɔ̌’ɔ atdídɔ̌ ɔ̀ndrɔ̀ ka kɔ́ndrɔ̀ atdídɔ̌ alɛ› tɨ́ ka kátɨna alɛ, yà ɨnzá ndɨ̀ ndàkǎnà ndìdè ɔ̀ná ngari ɔ̌ ìdè rɔ́ (Yàrɨ́ dhu ɔ̀zʉ̀ rɨ́ alɛ nákǎ ndàlʉ̌ ka mběyi dɔ̀na ɔ̀), nɨ́ Yùdɛyà ɔ̌ ɨ̀ nòtù alɛ náakáya ’òtsè pbìrì-akpá dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pbɨ̀ ɨdza dɔ̀ ka kɔ́bhɔ̀lɔ̀ okota tɔ̀ ngari ɔ̀ ndɨ̀ nòtù alɛ, náakáya nzɨ̌ ndìfò, ndɨrɔ̀ ɨ̀nzɨ̌ ndòtsù ndàhʉ atdí dhu mà nídyì ɨdza rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ndɨrɔ̀, ɔnzɨ-bvʉ̀ ndɨ̀ nòtù alɛ náakáya nzɨ̌ ndòngò ɨbha, ndàrà rɔ̀ná ɔrʉ́ mʉ̀dzarʉ̀ nídyì. ");
INSERT INTO niy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ɨ ɨdhɔ ɔ̌, ɔ̀ya nà rɨ́’ɨ̀ vèbhálɛ mà, ɨba òndo rɨ́ nzónzo rɨ̌’ɨ̀ fɔyá vèbhálɛ mànà nɨ́ɨ’ɨya àpbɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nyɨ̀tsɔ̀ nyɨ̌ Kàgàwà rɔ̌, ɨ̀nzɨ̌ kɔ̌kɔ̀ dhu nɔ́ɔnzɨya tɨ́ ɨ̀ ádrʉ̀ngbǎ gìrì tɔ́ kàsʉmɨ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Obhó tɨ́ ɨ ɨdhɔ ɔ̌, ìndrǔ náabáya àpbɛ̀ abhɔ, ròsè yà Kàgàwà anzɨ̀na yàrɨ́ adzɨ rɔ̀, rɨ̀rà àhʉ indo ɨ̀ arɨ́ àbàna àpbɛ̀ dɔ̀nǎ. Ndɨrɔ̀ ɨ àpbɛ̀-tɨdɔ̀ nɨ́ɨ’ɨya ɨ̀mbǎ akɛkpá màtɨ́ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ɨ̀nzɨ̌ Ádrʉ̀ngbǎlɛ Kàgàwà náadùna gukyè wɔ̀rɨ́ ɨdhɔ-ɔ̌nga, nɨ́ atdí alɛ mà náagʉ̀na nzɨ̌. Pbɛ́tʉ̀ kǎdù ndɨ ɨdhɔ-ɔ̌nga rɔ̀dɨ̀ ídǒ, fɨ̌ndà ndɨ̀ ndóvò pbɨ̀kɨ̀ alɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Atdí alɛ mà náatɨya gukyè nyɨ̌ nɨ̌: ‹Nyàndà, kànɨ̌ Krɨ́stɔ̀ rɨ̌’ɨ̀ ɨrɔ́!› Ndɨrɔ̀ ngǎtsi nɨ̌, ‹nyàndà, ndǎnɨ̌ kà rɨ̌’ɨ̀ ndɔrɔ́!› Nɨ́ àpɛ́ nyǎ’uya ka! ");
INSERT INTO niy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Obhó tɨ́, tɨ̀tɔ̀ tɔ́ krɨ́stɔ̀ mà, tɨ̀tɔ̀ tɔ́ pbànábí mànà nʉ́ʉnyàya ɨ̀ ʉ̀nyà. Abádhí náambɛ̀ya wɨwɨ̀ mà, ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ dhu mànà nɔ́nzɨ̀ dɔ̌, ndɨ́nɨ̌ ’ʉtrá tɨ́ yà Kàgàwà óvò fɨ̌ndà alɛ nɨ̌, àkǎ ka rǎdʉ̀ àkǎ fɨ̌yɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nɨ́ nyɨ̌, nyàndà nga mběyi! Ma mɔ̀vɔ̀ wà kɔ́rɔ́ dhu fʉ̌kʉ̀ angyangyɨ.» ");
INSERT INTO niy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Pbɛ́tʉ̀ ɨ ɨdhɔ ɔ̌, wɔ̀ àpbɛ̀ tɔ́ kàsʉmɨ̀ dzidɔ̌, adyifɔ̀ nʉ́ʉtɨ̀ya, àbǐ ràdʉ̀ ɨnga t’áwʉ̀ta nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Alalɨ náawáya ɨ̀ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ rɔ̀, ndɨrɔ̀ ádrɔ̀drɔ̌ ɔbɨ nà arɨ́’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀ dhu níivìya. ");
INSERT INTO niy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nɨ́rɔ̀ nɨ́ ndɨ ka kalaya ìndrǔ t’Ídhùnà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɨ́rà ádrʉ̀ngbǎ àpbù ɔ̌, ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà, ndɨrɔ̀ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nɨ́ kǔvìya pbɨ̀ndà màlàyíká ɨ̀fɔ yà adzɨ-pbɨdɔ̀ ɔ̀nǎ, rùndu yà ndɨ̀ ndavò fɨ̌ndà pbɨ̀ndà alɛ-tsʉ̀, rɔ̀pɛ̀ ndɨ̀ yà adzɨ-tsʉ̀ náapɛ̀ ndɨ̀ ɨ rɔ̀, ràrà àhʉ kà-tsʉ̀ arà ndɔ̀dɨ̀ ɨ.» ");
INSERT INTO niy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà: «Nyɨ̀rɛ̀ pɛ́ mùtinì tɨ́ kátɨna itsu tɔ́ mbólí rɔ̌vɔna dhu: kɔ̌pbɨ́ náapɛ́ ɨ̀’ǎ, kà-bɨ̌ ràdʉ̀ ndɔ̀pɛ̀ ndàtà, nɨ́ nyɨ̌ nyʉ̀nɨ wà dhu adyifɔ̀ tɔ́ kàsʉmɨ̀ ràrɨ̌’ɨ̀ ɨ́kyɛ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ mà átɔ̀, nyɨ̌ nyalaya gukyè kɔ̌kɔ̀rɨ́ dhu rɨ̌ ’ɔ̀nzɨ dhu, nɨ́ nyɨ̌ nyʉnɨya dhu kà rǐngo dhu ràrɨ̌’ɨ̀ ɨ́kyɛ̀rɔ̌, ndɨrɔ̀ kà ràrɨ̌’ɨ̀ tsǎtsʉ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, yà kòmbí rɨ́’ɨ̀ rʉ̀gànda rɨ̌ nzɨ̌ ʉ̀da ɨnzá kɔ́rɔ́ kɔ̌kɔ̀ dhu nɔ́nzɨ̀ ɨ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ɔ̀rʉ̀-akpà mà yà adzɨ mànà nʉ́ʉdàya ʉ̀dà, pbɛ́tʉ̀ pbàkà ɔtɛ nʉ́ʉdàya nzɨ̌ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ma míngo ɔ̀ná ɨdhɔ mà, ndɨ kàsʉmɨ̀ mànà dhu nàndà dhu nɨ̌, atdí alɛ mà nʉ́nɨ ɨnzá ka, ɨ̀mbǎ rɨ́’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɨ́’ɨ̀ màlàyíká màtɨ́, ɨ̀mbǎ rɨ́’ɨ̀ Kàgàwà t’ídhùnà màtɨ́. Pbɛ́tʉ̀ ka nʉ̀nɨ nɨ́ Àba Kàgàwà kɛ̀lɛ̌ atdírɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nyàndà nga mběyi, nyòko nyɨ̀kpɔ́kʉ nà, ɨnzá nyɨ̌ nyʉ̀nɨ ndɨ kàsʉmɨ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ndɨ dhu nɨ́ɨlɨya ndɨ̀ àdhàdhɨ̀ abhi ɔ̀ rárà alɛ náarɨ́ dhu ɔ̀nzɨ dhu bhěyi: kà rǎhʉ pbɨ̀ ɨdza rɔ̀, ndʉ̀bhà ndɨ ɨdza kasʉtálɛ-fɔ́. Kà rɨ̌ ɨ alɛ nzínzì ɔ̌ ngǎtsi alɛ rɔ̌nzɨna kasʉ nɨ́tɛ̀ ndɨ alɛ tɔ̀, ndàdʉ̀ dhu nʉ́ya ɨdza-li’ɔ̀ nɔ́dɔ rɨ́ sàndǐrì tɔ̀ ràdɨ nyɨ̀kpɔ́na nà. ");
INSERT INTO niy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nɨ́rɔ̀, nyòko nyɨ̀kpɔ́kʉ nà, ɨnzá nyɨ̌ nyʉ̀nɨ ɨdza-àbadhi rǐngo ɔ̀ná kàsʉmɨ̀ nɨ́dhunɨ̌. Nyɨ̌ nyʉ̀nɨ nzá dhu kà ràtɨ́ ndàdǔ pbɨ́tsɔ̀ngǎnǎ, ngǎtsi nɨ̌ iku-alìkpa ɔ̌, ngǎtsi nɨ̌ à’ʉ̌-akpà-ɔ̀ngɔ̌ ɔ̌, ndɨrɔ̀ ngǎtsi nɨ̌ kútsingánǎ. ");
INSERT INTO niy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kɨ̀tɔ̀ ndɨ̀ ɨnzá nyɨ̌ nyɨ̀rɛ̀ kàsʉmɨ̀ ɔ̌ nɨ̌, dhu àkǎ nzá kà ròtù nyɨ̌ ɔ̀dhɔ̀ nyɨ̌ nyɔ́dhɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yà fʉ̌kʉ̀ ma mʉ̀nɔ̀ dhu nɨ́ ma mʉ̀nɔ̀ wà kɔ́rɔ́ alɛ tɔ̀. Nyòko nyɨ̀kpɔ́kʉ nà!» ");
INSERT INTO niy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ mà, Ɨ̀mbǎ ɔ̀nà afi nà mʉ̀gatì tɔ́ mʉ̀hɛndʉ̀ mànà nɨ́ɨ’ɨ̀ ɔyɔ ɨdhɔ̀ya nɔ́dɨ̀ rɔ́. Nɨ́ Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà náapɛ̀ ɔ̀nɛ̀ Yěsù nálʉ̌ ɨ̀’ɨ́ ɨnzá kɔ́rɔ́ alɛ ʉ̀nɨ rɔ́rɔ̀ ɔ̀ná otu, ndɨ́nɨ̌ ’adʉ̀ tɨ́ àbhʉnà kohò. ");
INSERT INTO niy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Obhó tɨ́, abádhí owúnà àtɨ̀nà rɔ̌ nzínzìya ɔ̌: «Dhu àkǎ nzá àlɛ̌ ràlʉ̌ ka mʉ̀hɛndʉ̀ ɔ̌ rɔ̀, akyɛ ìndrǔ nɨ́ɨvàna dhu nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yěsù nɨ́ɨ’ɨ̀ Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̌, Sìmonì tɨ́ kátɨna alɛ bhà ɨdzá. Ndɨ alɛ nɨ́ɨ’ɨ̀ kɨ́kɨ́ nà angyinǎ rɔ̀. Nɨ́ ɔ̀nyʉ̀ nɔ́nyʉ Yěsù rɨ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdí tsìbhálɛ náatsù àlbatrɔ̀ tɨ́ kátɨna odu nɨ̌ ka kɔ́bhɔ̀lɔ̀ tsúpà nà fɔná. Ndɨ tsúpà ɔ̀ ɨ’ɨ̀ dhu nɨ́ ɔrʉ́ odzìna nà ndrùù rɔ́ngʉ akyɛ. Ndɨrɔ̀ ndɨ akyɛ nɨ’ɨ̀ nardɔ̀ tɨ́ kátɨna ɨrɨ́-vǐ nɨ̌ ka kɔ́bhɔ̀lɔ̀ akyɛ. Nɨ́ ɨ́yàdhíyà nʉ́ʉkɔ̀ ndɨ tsúpà-tsʉ̀, ndàdʉ̀ ndɨ akyɛ nɔ́dhɔ̀ Yěsù-dɔ̀tsírɔ́. ");
INSERT INTO niy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nɨ́ ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌, dhèdhè alɛ náakó, ’àdʉ̀ àmbɛ ɔ̀tɛ dɔ̌ nzínzìya ɔ̌ àtɨ: «Ádhu kàrɨ̌ wɔ̀rɨ́ akyɛ nɨ́nzǎ wɔ̀ dhu bhěyi nɨ̌? ");
INSERT INTO niy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ka kambɛ̀nà tɨ́ obhó kàbhʉ̌ kodzì ɨ̀bhʉ mɨyà dɔ̀nǎ róse fʉ̀rangà-kpɔ̌ rɔ̌, kadʉ̀ ndɨ fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀!» Abádhí náadʉ̀ àkǒ atdídɔ̌ nyʉ́ wɔ̀rɨ́ tsìbhálɛ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyʉ̀bhà wɔ̀ tsìbhálɛ ràdɨ. Ádhu nyɨ̌ nyʉ̀va kà-tsì nɨ̌? Yà rùdú kɔ̀nzɨ̀ dhu nɨ́ ídzì dhu nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Obhó tɨ́, nyɨ̌ nyóngo òko nǎkʉ̀tálɛ mànà bìlǐnganà. Ndɨrɔ̀, nyɨ̌ nyòzè ka ɔ̀ná kɔ́rɔ́ kàsʉmɨ̀ ɔ̌, nyɨ̌ nyóngo adʉ̀ abádhí-dzʉ̀nà nɔ́nzɨ̀ ɔ̀nzɨ. Pbɛ́tʉ̀ ɨma, àlɛ̌ kɨ́nzɨ̌ ongo òko nyɨ̌ mànà bìlǐnganà. ");
INSERT INTO niy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɨ́yàdhíyà ɔ̀nzɨ̀ dhu nɨ́ lɛ̀màna nɔ́nzɨ ndɨ̀ ndɨ́ dhu: kùtri wà ngbɔ̌du, ndɔ̀bhɔ̀lɔ̀ angyangyɨ ɔtdʉ́ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ ka kɨ́ yà adzɨ ɔ̌ kɔ́rɔ́ ngari ɔ̌ ɨnanǎ, ka kóngo yà tsìbhálɛ nɔ́nzɨ̀ dhu náwɛ ìndrǔ tɔ̀ átɔ̀, kadʉ̀ òwu kɨ̀rɛ̀ rɔ̌ rɔ̀ná.» ");
INSERT INTO niy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yěsù bhà ɨdrɛ dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, Yudhà Ìskàrìyɔtà tɨ́ kátɨna, náarà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ-tɨ’ɔ̀, ndɨ́nɨ̌ ndɨ̀ ndipfo tɨ́ Yěsù ndàbhʉ abádhí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nɨ́, Yudhà ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, abádhí-dhɛ̀ nɨ́ɨka ndɨ̀ atdídɔ̌. Abádhí adʉ̀ àtɨ̀nà ɨ̀ ràrɨ̌ fʉ̀rangà nábhʉ̌ kà tɔ̀. Nɨ́ Yudhà náadʉ̀ ndɔ̀pɛ̀ ndɔ̀mɛ̀ Yěsù ìpfǒ ndɨ̀ ndɨ́ ndàbhʉ abádhí-fɔ́ ɔ̀ná ídzì kàsʉmɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɨ̀mbǎ ɔ̀ná afi nà mʉ̀gatì tɔ́ mʉ̀hɛndʉ̀ tɔ́ wɛmbɛrɛ̀ tɔ́ ɨdhɔ, yà tàmà-akpá-nzo-zǎ ka kʉbɨ́nà ɔ̀ná ɔ̌, Yěsù bhà ábhàlɨ̌ níivú dhu kà-tsʉ̌ ’àtɨ: «Ádhànga ndɨ nyɨ nyòzè mǒwù Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ nɔ́bhɔ̀lɔ̀ ɔ̀nà ɨndʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɨ́, Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ ɔ́yɔ̌ alɛ nóvì, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu kɨgɔ̀ ɔ̀, nɨ́ nyɨ̌ nyɨ́ atdí alɛ nótù ɨdha nànɔ̀ andu ɔ̌ rɔ́. Nɨ́ nyàdʉ̀ nyòwu kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nɨ́ kà rǎrà òtsù ɨdza rɔ́, nyɨ̌ nyatɨna ndɨ ɨdza-àbadhi nɨ̌: ‹Màlimò nívǔ dhu ndàtɨ: Mǎ mɨ́ Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ nɔ́nyʉ ɔ̀ná rɔ̀ pbàkà ábhàlɨ̌ mànà kàluga rɨ̌’ɨ̀ ngbɔrɔ́?› ");
INSERT INTO niy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nɨ́, kǎdʉ̀na ɔrʉ̀nǎ rɔ̀ rɨ́’ɨ̀ ádrʉ̀ngbǎ kàluga nɨ́tɛ̀ fʉ̌kʉ̀, yà angyangyɨ ka kɔ̀bhɔ̀lɔ̀ kɔ́rɔ́ dhu ɔ̀nà. Ányɨ̀ nga nɨ́ ndɨ, nyɨ̌ nyɔbhɔlɔna ɔ̀nyʉ̀ àlɛ̌ tɔ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nɨ́, kɔ̌kɔ̀ ɔ́yɔ̌ ábhàlɨ̌ nɨ́ɨvà ɨ̀ ’òwù kɨgɔ̀ ɔ̀. Abádhí náadʉ̀ kɔ́rɔ́ dhu nótù yà Yěsù nʉ́nɔ̀nà ka fɨ̌yɔ̀ dhu bhěyi tɨ́, ’àdʉ̀ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ nɔ́bhɔ̀lɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pbɨ́tsɔ̀ngánǎ, Yěsù mà pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ mànà náawù ùvò wɔ̀ ka kɔ̀bhɔ̀lɔ̀nà ngari ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nɨ́, yà abádhí òkò ’àmbɛ dhu ɔ̀nyʉ̀ dɔ̌ mɨzà dɔ̌ rɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù atɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, nzínzìkʉ ɔ̌ atdí alɛ rɨ̌ ɨma nípfǒ ndàbhʉ ma òmvǔ-fɔ́. Ndɨ alɛ nɨ́ yà atdíkpá mǎ mɨ́ dhu ɔ̀nyʉ mànà alɛ.» ");
INSERT INTO niy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nɨ́, ɨzʉ nʉ́ʉka kɔ̌kɔ̀ ábhàlɨ̌ atdídɔ̌ nyʉ́, ràdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu atdátdí-rà ɔ̌ kà-tsʉ̌, ’òwù àtɨ̀nà rɔ̌: «Tɨ́ ɨma ndɨ?» ");
INSERT INTO niy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ndɨ alɛ nɨ́ nzínzìkʉ ɔ̌ atdí alɛ, yà atdí kumì dɔ̀ná ɔ́yɔ̌ nà nyɨ̌ nyɨ́’ɨ̀ rɔ̀, yà atdíkpá mǎ mɨ́ ɔtsʉ́ka ʉ̀fɔ̌ mànà sǎnɨ̀ ɔ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Obhó tɨ́, ìndrǔ t’Ídhùnà rɔ̌vɛ̀ yà Kàgàwà bhà Andítá nʉ́nɔ̀ dɔ̀ná dhu bhěyi. Pbɛ́tʉ̀, ìndrǔ t’Ídhùnà nípfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ rɨ̌’ɨ̀ àpbɛ̀ ɔ̌! Dhu akána nzɨ̌ kɔdhɨ̀ ndɨ alɛ mà!» ");
INSERT INTO niy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà rɨ̌ dhu ɔ̀nyʉ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù níidyi mʉ̀gatì ndàlʉ̌ fɔná. Nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kʉ̌kɔ kà-ɔ̌nga, ndàdʉ̀ ʉ̀ndɔ̀nà pbɨ̀ndà ábhàlɨ̌-fɔ́, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyàkɔ yà dhu, ngbɔ̌du nɨ́ yà.» ");
INSERT INTO niy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tdɨ́tdɔ̌ kǐdyi dɨ̀vayì rɨ̌’ɨ̀ ɔ̀nà kɔ́pà ndàlʉ̌ fɔná. Nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kǎdʉ̀ kàbhʉ abádhí tɔ̀, abádhí kɔ́rɔ́ ràdʉ̀ ɔ̀mvʉ̀nà. ");
INSERT INTO niy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Yàrɨ́ nɨ́ azùdu, yà ìndrǔ nùngbò Kàgàwà mànà azu, ndɨrɔ̀ yà ábhɔ̌ alɛ-okú dɔ̀ rɔ̀ ndɨ̀ nʉ̀fʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, ma mɨ́ nzɨ̌ dɨ̀vayì nɔ́mvʉ̀ tdɨ́tdɔ̌ akɛkpá màtɨ́, ràrà àhʉ dɨ̀vayì-ɔwʉ́tá nɔ́mvʉ̀ ma maraya ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi ɔ̌ ɔ̀ná ɨdhɔ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Adyi ɨ̀ ʉ̀yʉ̀ dhu-dzidɔ̌, abádhí náadʉ̀ òwu Mìzèyìtunì tɔ́ pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yěsù atɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̌ kɔ́rɔ́, nyɨ̌ nyɨ́ mʉbha ʉ̀bha. Obhó tɨ́, Kàgàwà bhà Andítá ɔ̀ ka kándǐ dhu katɨ: ‹Ma mohoya tàmà t’ʉ́ndatatálɛ, tàmà ràdʉ̀ ’ɨ̀fàlà kɔ́rɔ́ ngari ɔ̀nǎ.› ");
INSERT INTO niy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pbɛ́tʉ̀, ma mɨ̀ngbɛ̀ ma dhu-dzidɔ̌, ma madʉ̀ya àrà nyɔ̌dɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Ngʉ̌kpà alɛ mà rɨ̌ mbǎ nyʉbha, nɨ́ ɨma, ma mɨ́ nzɨ̌ nyʉbha.» ");
INSERT INTO niy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀, indo yàrɨ́ iku ɔ̌ tɨ́, ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ ɔyɔ-gʉ̀na rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyàtɨ ɨ̀bhʉ-gʉ̀na ɨnzá nyɨ rʉ́nɨ ɨma rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ ɔbɨ nyʉ́ nà: «Ma matɨna nzɨ̌ akɛkpá màtɨ́ ɨnzá ma rʉ̀nɨ nyɨ, ɨ̀mbǎ dhu ɨ’ɨna atdíkpá àlɛ̌ kʉ́vɛ dhu màtɨ́.» Ndɨrɔ̀ kɔ́rɔ́ ngʉ̌kpà ábhàlɨ̌ náadʉ̀ dhu ʉ̀nɔ̀ ndɨ dhu bhěyi tɨ́ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò atdí ngari Gɛ̀tɛ̀sɛ̀manɨ̀ tɨ́ kátɨna ɔ̀. Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyòko ɨrɔ́ mɨtsɔ̀ ma márà ɔ̀nanǎ.» ");
INSERT INTO niy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ Pɛ́tɛrʉ̀ mà, Yàkɔbhɔ̀ mà, Yùwanɨ̀ mànà núgù ’òwù mànà. Nɨ́, kǎpɛ̀ ndɨ̀’ɨ̀ ádrʉ̀ngbǎ ɔdɔ nà, ndàdʉ̀ ɨ̀’ɨ̀ ábhɔ̌ ɨzʉ nà. ");
INSERT INTO niy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Afídu rɨ̌’ɨ̀ ábhɔ̌ ɨzʉ nyʉ́ nà, akyɛ ma mɔ́vɛ̀ dhu bhěyi. Nɨ́, nyòko ɨrɔ́, ndɨrɔ̀ nyòko ípìrɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kǎdʉ̀ àrà ɨtsɛta akɛ, ndàdʉ̀ ndìbvu obvò. Nɨ́ kǎdʉ̀ ndɨ̀tsɔ̀ Kàgàwà rɔ̌, ndɨ́nɨ̌ kàkǎ nɨ̌, ndɨ àpbɛ̀ tɔ́ kàsʉmɨ̀ nʉ́ʉdà tɨ́ dɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nɨ́ kǎmbɛ́nà àtɨ̀nà dɔ̌: «Ɔ̀ɔ Àbá, lɛ̀mànʉ ɔ̀nzɨ rɨ́ dhu náarɨ́’ɨ̀ mbǎ. Nɨ́ índrǐ wɔ̀ àpbɛ̀ tɔ́ kɔ́pà ɨtsɛ rùdú rɔ̀. Pbɛ́tʉ̀ ndɨ dhu àkǎ nzá ndɔ̀nzɨ̀ ndɨ̀ ma mòzè ka dhu bhěyi, kàkǎ ndɔ̀nzɨ̀ ndɨ̀ nyɨ nyʉ́ nyɨ nyòzè dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndàdu kɔ̌kɔ̀ ɨ̀bhʉ ábhàlɨ̌-tɨ’ɔ̀, ndàdʉ̀ abádhí nótù ɨwà ʉ̀dhɔ rɔ́. Nɨ́ kǎdʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Sìmonì, nyɨ tɨ́ ɔ̀dhɔ̀ ɔ̀dhɔ̀ tɨ́? Nyɨ nyàdʉ̀ tɨ́ obhó àdɨ ípìrɔ̌ rɔ̀ atdí adyi màtɨ́? ");
INSERT INTO niy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nyòko ípìrɔ̌rɔ̀, ndɨrɔ̀ nyɨ̀tsɔ̀ nyɨ̌, akyɛ nyɨ̌ nyotsúna umvútá ɔ̀ nɨ̌. Alafí nózè wà kɔnzɨ̀ ídzì dhu, pbɛ́tʉ̀ alɛ-ngbɔ̀ rɨ̌’ɨ̀ ivíví.» ");
INSERT INTO niy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tdɨ́tdɔ̌, Yěsù indrí ndɨ̀ abádhí tɨ́ rɔ̀, ndàdʉ̀ ndɨ̀tsɔ̀ ndʉ̀nɔ̀ yà angyi ndɨ̀ ndʉ̀nɔ̀nà ɔtɛ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndàdu pbɨ̀ndà ábhàlɨ̌-tɨ’ɔ̀, ndàdʉ̀ abádhí nótù ɨwà ʉ̀dhɔ rɔ́, atdídɔ̌ ɨdhɔ rɨ̌’ɨ̀ nyɨ̀kpɔ́ya ɔ̌ nɨ́dhunɨ̌. Nɨ́ abádhí náadʉ̀ nzá kà tɔ̀ ɨ̀ ádǔna dhu nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ɨ̀bhʉ rɨ́ kìsě nɨ̌, Yěsù adù ndɨ̀ pbɨ̀ndà ábhàlɨ̌-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyòko tɨ́ òko ɔ̀dhɔ̀ nyɨ̌ nyɔ́dhɔ̀ rɔ́? Nyɨ̌ tɨ́ nyǎsǒ nyɨ̌ nyɨ́ rɔ́? Ɨwà àkǎ wɔ̀ dhu-bvʉ̀tɨ́! Kàsʉmɨ̀ nákǎ wà! Nyàndà, kànɨ̌ ka kɨ́ Ìndrǔ t’ídhùnà nípfǒ kabhʉ nzɛ́rɛngatálɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nyɨ̀và nyɨ̌, kòwu! Kànɨ̌ ma nípfǒ rɨ́ ndàbhʉ ma òmvǔ-fɔ́ alɛ nɨ́rà wà àhʉ ɨ́kyɛ̀rɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, yà Yěsù rɔ̌tɛ ɔ̀nanǎ, Yudhà, yà ɨdrɛ dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, nɨ́ɨtɔ ndɨ̀ ihé-yà mànà owùna ɔ̌. Ɨ alɛ-fɔ́ nɨ’ɨ̀ obhi-akpá, mùgǒ mànà. Abádhí nivi nɨ’ɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mà, pbàkʉ̀rʉ̌ mànà. ");
INSERT INTO niy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudhà, yà Yěsù nípfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ, nɨ’ɨ̀ ɨwà ndɨ̀ ndɔnzɨna Yěsù ka kʉnɨ tɨ́ rɔ̀ná dhu nʉ̀nɔ̀nà ihé-yà tɔ̀. Kǎtɨ: «Ma mámbǒna alɛ nɨ’ɨna ndɨ yà nyɨ̌ nyɨ́ atdyúna nóho alɛ. Nɨ́ nyɨ̌ nyalʉ́na ka, nyǎdʉ̀ òwu nà mběyi nyɨ̌ nyɔ́dɔna rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudhà níitdègu ndɨ̀tɔ, nɨ́ kǎndrì Yěsù-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Màlimò!» Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ kàmbo. ");
INSERT INTO niy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ngʉ̌kpà alɛ náadʉ̀ Yěsù nálʉ, ’àdʉ̀ òsònà. ");
INSERT INTO niy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nɨ́, ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌ atdí alɛ nɨ́ɨdhá pbɨ̀ obhi-akpà, ndɨ̀tsà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà kasʉtálɛ-bɨ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨma àlʉ nyɨ̌ nyíwu rɔ̀, nyɨ̌ nyàdʉ̀ tɨ́ ìwu fʉkʉ́ obhi-akpá nà mùgǒ mànà, ogbotálɛ nálʉ ríwu alɛ bhěyi? ");
INSERT INTO niy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bìlǐnganà ma múbhì àdɨ rɔ̌ tɨkʉ́, madʉ̀ àmbɛ dhu núdhe dɔ̌ Kàgàwà bhà ɨdza ɔ̌ rɔ̀, ɨ̀nzɨ̌ nyǎdʉ̀ malʉ. Pbɛ́tʉ̀, wɔ̀ dhu rɨ̌ ndɔ̀nzɨ ndɨ́nɨ̌ Andítá ʉ́nɔ̀ dhu náaká tɨ́.» ");
INSERT INTO niy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nɨ́rɔ̀ nɨ́ ndɨ ábhàlɨ̌ nʉ́ʉbhà àbadhi, ’àdʉ̀ òtse kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Atdí kpatsìbhíngba náadɨ̀ ndàmbɛ àrà dɔ̌ Yěsù-owù ɔ̌, atsìta tɔ́ mbɛrʉ̀ kɛ̀lɛ̌ ndɨ̀ ndòbvù rɔ̀ná rɔ́rɔ̀. Nɨ́ ka kadʉ̀ àbadhi nálʉ. ");
INSERT INTO niy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pbɛ́tʉ̀, kǎdʉ̀ ndɨ mbɛrʉ̀ nángɔlɔ rɔ̀ná rɔ̀, ndàdʉ̀ ɔ̀kʉ nzɨ̀nzɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yà Yěsù nòsò alɛ náawù kà nà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà, yà kɔ́rɔ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà núndu ɨ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɛ́tɛrʉ̀ adʉ̀ àdɨ ɨtsɛta, ndàmbɛ àrà dɔ̌ Yěsù-owù ɔ̌, ndàrà òtsù pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀ ɔ̀. Nɨ́ ányɨ̀, abádhí náadʉ̀ òko atdíkpá sàndǐrì mànà, ’àmbɛ kàzʉ nɔ́vɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, kɔ́rɔ́ ngʉ̌kpà alɛ yà Pbàyàhúdí bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ mànà, náambɛ́nà Yěsù nɔ́bhʉ ka kɨ́ dɔ̀ná dhu nɔ́nɛ̀ dɔ̌, ndɨ́nɨ̌ ’adʉ̀ tɨ́ ànyǎna nɔ́tdɨ̀ kohò. Pbɛ́tʉ̀, abádhí náabà nzá atdí dhu mà. ");
INSERT INTO niy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Obhó tɨ́, ábhɔ̌ alɛ nóowúnà ìwu rɔ̌, ’àdʉ̀ Yěsù nɔ́bhʉ̀ tɨ̀tɔ̀ dɔ̌, pbɛ́tʉ̀ abádhí-ɔ̀tɛ̌ nóowúnà nzɨ̌ ’àsò rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngúfe alɛ nɨ́ɨvà ɨ̀, ’ɔ̀bhʉ̀ ka tɨ̀tɔ̀ dɔ̌, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Mǎ mɨ́rɨ̀ kà rǎtɨna: ‹Ma mɨ́ yà ìndrǔ asɨ̀ ɔtsʉ́ya nɨ̌ Kàgàwà bhà ɨdza núgòlǒ, madʉ̀ ngǎtsi-tsí, yà ɨ̀nzɨ̌ ìndrǔ rɨ̌ kàsʉ̌na nɔ́nzɨ ɔtsʉ́ya nɨ̌ nɔ́sɨ̀ ɨ̀bhʉ ɨdhɔ ɔ̌.›» ");
INSERT INTO niy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nɨ́ wɔ̀ ndɨ ɔbhʉta dɔ̌ màtɨ́, abádhí-ɔ̀tɛ̌ náasò nzá ɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà nɨ́ɨvà ndɨ̀ ndìdè kɔ́rɔ́ alɛ-ɔ̀nzɨ̌, ndàdʉ̀ dhu ìvu Yěsù-tsʉ̌ ndàtɨ: «Nyɨ t’óbhó dhu àdǔ kɔ̌kɔ̀ alɛ rʉ̌nɔna dʉ̀nʉ́ dhu dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pbɛ́tʉ̀, Yěsù adʉ́nà àrà ɨ̀nɛ̀ rɔ̀ ɨ̀nɛ̀ tɨ́, ɨ̀nzɨ̌ ndàdu atdí dhu mà. Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà níivú dhu tdɨ́tdɔ̌ kà-tsʉ̌ ndàtɨ: «Nyɨ tɨ́ Krɨ́stɔ̀, yà mǎ márɨ́ ɨ̀fʉ̌na Kàgàwà t’Ídhùnà?» ");
INSERT INTO niy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nɨ́, Yěsù adʉ̀ dhu àdu ndàtɨ: «Obhó, ɨma nɨ́ ndɨ. Ndɨrɔ̀ nyɨ̌ kɔ́rɔ́, nyɨ̌ nyalaya Ìndrǔ t’ídhùnà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà arɨ́’ɨ̀ Kàgàwà bhà fangà dɔ̀nǎ rɔ̀ àdɨ rɔ́. Ndɨrɔ̀, nyɨ̌ nyalaya ka átɔ̀ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ àpbù ɔ̌ rɨ́rà rɔ́.» ");
INSERT INTO niy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà nʉ́ʉfà rɔ̀ná mbɛrʉ̀-ɔ̌nga nàwí-okú dɔ̀ rɔ̀, ndàdʉ̀ àtɨ̀nà: «Ádhu tɔ́ ngàmbì àlɛ̌ kɨ́’ɨ̀ atdyúna nà tdɨ́tdɔ̌! ");
INSERT INTO niy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyɨ̌ nyɨ̀rɨ̀ wà kʉ̀nɔ̀ dhu nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌ dhu. Nɨ́, ádhu nyɨ̌ nyɨ̀rɛ̀ kà dɔ̌?» Nɨ́, kɔ́rɔ́ alɛ adʉ̀ anya ɔ̀tdɨ̀ kà-dɔ̌, ’àtɨ kà ràkǎ kohò. ");
INSERT INTO niy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Abádhí nzínzì ɔ̌ atdídhená alɛ náapɛ̀ ’ùso ɨsɔ Yěsù dɔ̀. Abádhí owúnà kà-nyɨ̀ nátsì rɔ̌, ’àdʉ̀ kùdù ɔtsʉ́ya nɨ̌. Ndɨrɔ̀ abádhí owúnà àtɨ̀nà rɔ̌ kà nɨ̌: «Nyɨ nyʉ̀nɨ rɔ̀, átɨ pɛ́ nyɨ nɔ̀pbɨ̀ alɛ fǎkà.» Ndɨrɔ̀ sàndǐrì náalʉ́ Yěsù, ’àdʉ̀ ʉ̀pbɨ̀nà ɔtsʉ́ya nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pɛ́tɛrʉ̀ àdɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà ɨdza-lí ɔ̀ná kàsʉmɨ̀ ɔ̌, ndɨ kamà bhà kasʉ tɔ́ vèbhálɛ nzínzì ɔ̌ atdí tsìbhálɛ nɨ́ɨtɔ ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nɨ́, kǎla Pɛ́tɛrʉ̀ kàzʉ nɔ́vɔ rɨ́ rɔ́, ndàdʉ̀ nyɨ̀kpɔ́na nɔ́dɨ̀ rɔ̀ná, ndàdʉ̀ àtɨ̀nà nɨ̌: «Ɨnyɨ átɔ̀, nyɨ nyɨ̀’ɨ̀ atdíkpá Yěsù yà Nàzàretì ɔ̌ alɛ mànà.» ");
INSERT INTO niy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ wɔ̀ kʉ̀nɔ̀ dhu nágò ndàtɨ: «Ɨnzá ma mʉ̀nɨ, ndɨrɔ̀ ɨnzá dùdu àlʉ̌ wɔ̀ nyɨ nyʉ̀nɔ̀ dhu.» Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ ndɨ̀và ndɨ ɨdza-lí rɔ̀, ndàrà ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀-li’ɔ̀, à’ʉ̌-akpà ràdʉ̀ ɔ̀ngɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pbɛ́tʉ̀, wɔ̀ kasʉ tɔ́ tsìbhálɛ náala àbadhi, ndàdʉ̀ ndɔ̀pɛ̀ ndʉ̀nɔ̀ dhu tdɨ́tdɔ̌ ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ tɔ̀ ndàtɨ: «Yàrɨ́ alɛ nɨ́ abádhí nzínzì ɔ̌ atdí alɛ!» ");
INSERT INTO niy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pɛ́tɛrʉ̀ adʉ̀ ndɨ dhu nágò àgò tɨ́ tdɨ́tdɔ̌. Nɨ́ ákɛ̌ kàsʉmɨ̀ dzidɔ̌, ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ náatɨ Pɛ́tɛrʉ̀ nɨ̌ tdɨ́tdɔ̌: «Obhó nyʉ́, nyɨ nɨ́ abádhí nzínzì ɔ̌ atdí alɛ, nyɨ nɨ́ Gàlìlayà tɔ́ pbìrì ɔ̌ alɛ átɔ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ ɔtɛ ɔ̀pɛ̀ ndàtɨ: «Dhu apɛ́ ɨ̀ tɨ̀tɔ̀ nʉ́nɔ ma mɨ́ dhu tɨ́, nɨ́ Kàgàwà àkǎ ndɔ̀tdɨ̀ ànyǎdu. Ma mɔ̀tsɔ̀ wà dhu nyʉ́, ɨnzá ma mʉ̀nɨ wɔ̀ nyɨ̌ nyʉ́nɔna alɛ.» ");
INSERT INTO niy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, à’ʉ̌-akpà náadʉ̀ ɔ̀ngɔ̀ ɔyɔ rɨ́ kìsě nɨ̌. Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ yà Yěsù ʉ̀nɔ̀nà fɨ̌ndà dhu nɨ́rɛ̀: «Ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ ɔyɔ-gʉ̀na rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyàtɨ ɨ̀bhʉ-gʉ̀na ɨnzá nyɨ rʉ́nɨ ma rɔ́.» Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ adʉ̀ ndɔ̀pɛ̀ ndɔ̀dzɨ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kútsingá nyʉ́, Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà núundu ɨ̀ pbàkʉ̀rʉ̌ mà, Músà bhà Ʉyátá tɔ́ màlímó mà, kɔ́rɔ́ ngʉ̌kpà alɛ yà Pbàyàhúdí bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ mànà, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ ɨ̀ Yěsù dɔ̌. Nɨ́, abádhí adʉ̀ Yěsù àbhʉ kʉtsɨ̀, ’àdʉ̀ òwu nà ’òwù àbhʉnà Pìlatɔ̀-fɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nɨ́ Pìlatɔ̀ ivú dhu Yěsù-tsʉ̌ ndàtɨ: «Ɨnyɨ, nyɨ tɨ́ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨnyɨ nɨ́ ndɨ ka nyʉ̀nɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ náambɛ́nà Yěsù nɔ́bhʉ̀ dɔ̌ ibí otu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nɨ́ Pìlatɔ̀ adʉ̀ dhu nívu kà-tsʉ̌ tdɨ́tdɔ̌ ndàtɨ: «Nyɨ nyàdu tɨ́ nzá atdí dhu mà? Nyɨ nyɨ̀rɨ̀ wà abádhí rɨ̌ nyɔbhʉ dɔ̀ná kɔ́rɔ́ dhu!» ");
INSERT INTO niy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pbɛ́tʉ̀, Yěsù adʉ̀ nzá atdí dhu mà nádu, ɨdhɔ ràdʉ̀ Pìlatɔ̀ nʉ́kɔ atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yà Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ náarɨ́rà dhu bhěyi, Pìlatɔ̀ nóongónà atdí alɛ nɨ́kɔ̀lɔ̀ yà imbi ɔ̀ rɨ́’ɨ̀ alɛ nzínzì ɔ̌ rɔ̀. Ndɨ alɛ nongónà ɨ̀’ɨ̀ yà ihé-yà nózè kɨkɔ̀lɔ̀ fɨ̌yɔ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nɨ́, Bàrabà tɨ́ kátɨna atdí alɛ nɨ́ɨ’ɨ̀ imbi ɔ̀ ka kósò rɔ́. Ka kusó abádhí atdíkpá yà abvo nóhò alɛ mànà. Ɨ alɛ náahò ndɨ abvo yà dhu ɨ̀ ɨ̀và ɨ̀nzɨ̌ àmbɛ kamà-tsʉ̌ dhu nɨ́rɨ̀ dɔ̌ ɔ̀ná kasʉmɨ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nɨ́, ihé-yà nɨ́ɨvà ɨ̀ ’òwù Pìlatɔ̀ bhà, ’àdʉ̀ kàvi rɨ̀kɔ̀lɔ̀ atdí alɛ fɨ̌yɔ̀, yà bìlǐ ndɨ̀ ndarɔ́nzɨna Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ ɔ̌ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pìlatɔ̀ adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyòzè tɨ́ mɨkɔ̀lɔ̀ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà fʉ̌kʉ̀?» ");
INSERT INTO niy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Obhó tɨ́, kʉ̌nɨ dhu mběyi nyʉ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ rìwǔ Yěsù nà fɔna ɔ̀ kǎdhà ɔ̀nzɨ ɨ̀’ɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pbɛ́tʉ̀, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ níitsu dhu ihé-yà-dɔ ɔ̀, ndɨ́nɨ̌ Bàrabà kɛ̀lɛ̌ nonzi tɨ́ kɨkɔ̀lɔ̀ fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nɨ́, Pìlatɔ̀ níivú dhu tdɨ́tdɔ̌ ihé-yà-tsʉ̌ ndàtɨ: «Ádhu nyʉ́ nyɨ̌ nyòzè mɔnzɨ̀ yà Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà tɨ́ nyɨ̌ nyarɨ́ ànzina alɛ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nɨ́, abádhí adʉ̀ dhu àdu kà tɔ̀ ìkǔ nyʉ́ ɔ̌ àtɨ: «Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nɨ́, Pìlatɔ̀ adʉ̀ dhu nívu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyʉ́ ndɨ kɔ̌nzɨ̀ nzɛ́rɛ dhu tɨ́?» Nɨ́, abádhí adʉ̀ ɨ̀dʉ̀ àrǐ nyʉ́ tɨ́ ’àtɨ: «Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pìlatɔ̀ náazè ndɔ̀nzɨ̀ ihé-yǎ-dhɛ̀ nɨ́kǎ rɨ́ dhu. Nɨ́ kǎdʉ̀ Bàrabà nɨ́kɔ̀lɔ̀ abádhí tɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ Yěsù nábhʉ kʉvɨ asé nɨ̌, ndàdʉ̀ àbhʉnà kowù ʉ̀tɔnà mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pbànówí náawù Yěsù nà lɨ̀walɨ̀ bhà ádrʉ̀ngbǎ ɨdzá-yà-ba-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀ ɔ̀. Abádhí adʉ̀ kɔ́rɔ́ pbànówí tɔ́ pɨ̀kɔ̀ núnzì rìwǔ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nɨ́, abádhí náafɔ́ òlǒlù ɔrʉ́ mʉ̀dzarʉ̀ Yěsù rɔ̌, ’àdʉ̀ okpèna nà itsu-dɔ̀ká tɔ́ mʉ̀kàkʉ́ nákpɔ̀rɔ̀, ’àfɔ̌ kà-dɔ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wɔ̀ dhu-dzidɔ̌, abádhí náapɛ̀ ’àtsɛ̀ Yěsù ’òwù àtɨ̀nà rɔ̌: «Yǎmbʉ̀, Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà!» ");
INSERT INTO niy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Abádhí nóowúnà kà-dɔ̀tsirɔ̀ nɔ́vɨ̀ rɔ̌ ízò nɨ̌, ’àdʉ̀ ɨsɔ núso kà-dɔ̀. Ndɨrɔ̀, abádhí adʉ́nà òwu ’ʉ̀kɔ rɔ̌ ɔtdyʉ̀ya dɔ̌, ’àgǔ ɨ̀ obvò nyʉ́ kɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ka ɨ̀ ìkpǒ dhu-lutìnǎ, abádhí nɨ́ɨwa òlǒlù ɔrʉ́ mʉ̀dzarʉ̀ kàrɔ̌ rɔ̀, ’àdʉ̀ kàrɔ̌ mʉ̀dzarʉ̀ nʉ́fɔ kàrɔ̌ tdɨ́tdɔ̌. Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ ùvò kànà iri, ’àdʉ̀ òwu kʉ̀tɔ mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kùrenì tɔ́ kɨgɔ̀ ɔ̌ atdí alɛ, Sìmonì tɨ́ kátɨna, núubhínà ʉ̀da rɔ̌ ányɨ̀rɔ̌ ɨnga bvʉ̀ rɔ̀ ndɨ̀ ndɨ́rà rɔ́rɔ̀. Ndɨ alɛ nɨ’ɨ̀ Àlɨ̀sandʉrʉ̀ mà Rufù nà mà t’ábanà. Nɨ́ pbànówí nʉ́ʉtʉ ka rànɔ̀ Yěsù bhà mʉ̀sàlabhà. ");
INSERT INTO niy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Abádhí náawù Yěsù nà, ’òwù ùvò nà Gɔ̀lɔ̀gɔtà tɨ́ kátɨna ngari ɔ̀. Gɔ̀lɔ̀gɔtà-tɨ̀ nɨ́ «alɛ-dɔ-kpa tɔ́ ngari.» ");
INSERT INTO niy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Abádhí náatsú ’àbhʉ mànɛ̀manɛ̀ tɨ́ kátɨna itsu-dha nà ka kàngbǒ dɨ̀vayì Yěsù tɔ̀. Pbɛ́tʉ̀, Yěsù adʉ̀ nzá kɔ̀mvʉ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wɔ̀ dhu-dzidɔ̌, abádhí náadʉ̀ kʉ̀tɔ mʉ̀sàlabhà dɔ̌. Abádhí adʉ̀ kàrɔ̌ mʉ̀dzarʉ̀ nʉ́ndɔ̀ fɔyá, ngàlà ɔ̌ ɨ̀ ɔ̀vɨ̀ rɔ́rɔ̀. Abádhí avɨ̀ ngàlà ndɨ́nɨ̌ ɨ̀ ʉnɨ tɨ́ ngǎtsi alɛ ràrɨ̌ ngbǎgà-tsí nábà. ");
INSERT INTO niy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ka kʉtɔ́ ka mʉ̀sàlabhà dɔ̌ ɨ̀bhʉ adyifɔ̀-sɨsɨ̀ kútsingá nga tɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kòho ka kɨ́ okúna dɔ̀ rɔ̀ dhu ka kɨ̀tɛ̀ ɔ̀nà andítá náatɨ: «Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà.» ");
INSERT INTO niy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ndɨrɔ̀, abádhí nʉ́ʉtɔ́ ɔ́yɔ̌ ogbotálɛ átɔ̀ mʉ̀sàlabhà dɔ̌ Yěsù tɨ́: atdí alɛ ka kʉtɔ́, kɔdɨ̀ Yěsù bhà fangà dɔ̀nǎ rɔ̀, kadʉ̀ ngǎtsi alɛ nʉ́tɔ, kɔdɨ̀ Yěsù bhà ígù dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ndɨ dhu bhěyi nɨ́ ndɨ, yà Kàgàwà bhà Andítá ɔ̀ ka kandí dhu náaká. Ndɨ Andítá rǎtɨna: «Ka kazʉ̀ ka nzɛ́rɛngatálɛ nzínzì ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nɨ́, ányɨ̀rɔ̌ rʉ́da alɛ nóowúnà dɔ̀ya nóbhì rɔ̌, ’àdʉ̀ dhu ʉ̀nɔ̀ kà nɨ̌, ’àtɨ: «Ɔ̀hɔ̌! Ɨnyɨ, yà nyɨ nyátsǔ nyugolo Kàgàwà bhà ɨdza, nyadʉ̀ tɨ́ ɔ̀sɨ̀nà ɨ̀bhʉ ɨdhɔ ɔ̌ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ɨ́gʉ̌ pɛ́ nyɨ nyɨ-tɨ́rɔ̀, nyadʉ̀ ìfo mʉ̀sàlabhà dɔ̌ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ndɨ dhu bhěyi tɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà nʉ́ʉgbɔ́ Yěsù, ’àdʉ̀ òwu àtɨ̀nà rɔ̌ nzínzìya ɔ̌: «Kɨ̌gʉ́ ngʉ̌kpà alɛ, pbɛ́tʉ̀ kàrɨ̌ nzɨ̌ àdʉ̀ ndɨ̀gʉ ndɨ̀tɨ́rɔ̀! ");
INSERT INTO niy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dhu àkǎ Krɨ́stɔ̀, Pbàìsràyélí tɔ́ ádrʉ̀ngbǎ kamà, rìfò kòmbí mʉ̀sàlabhà dɔ̌ rɔ̀, ndɨ́nɨ̌ mǎ mala tɨ́, mǎdʉ̀ kà’ù.» Yà Yěsù tɨ́ ka kʉ̀tɔ̌nà mʉ̀sàlabhà dɔ̌ alɛ, náambɛ́nà dhu ʉ̀nɔ̀ dɔ̌ átɔ̀ kà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Adyíbhengá nga tɔ́ azà adyifɔ̀-sɨsɨ̀ ɔ̌, ɨ́nɔ̌-yà níibvú ndɨ̀ kɔ́rɔ́ ndɨ pbìrì ɔ̌, ràrà àhʉ adyídɔ̌ nga tɔ́ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nɨ́ adyídɔ̌ nga tɔ́ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ ɔ̌, Yěsù náakù ɔrʉ́ tǔna nyʉ́ nà ndàtɨ: «Èloyì, Èloyì, lamà sàbàkàtanɨ̀.» Kàtɨ̀ nɨ́: «pbàkà Kàgàwà, pbàkà Kàgàwà, ádhu nyɨ nyʉ̀bhà ma nɨ́?» ");
INSERT INTO niy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌, wɔ̀ dhu nɨ̀rɨ̀ atdídhená alɛ náadʉ̀ àtɨ̀nà: «Nyɨ̀rɨ pɛ́, kà rɨ̌ nabì Ɛ̀lɨyà nánzi!» ");
INSERT INTO niy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Atdí alɛ abádhí nzínzì ɔ̌ náakʉ̀ ndìdyì sɨ̀fɔngɔ̀, ndàfɔ̌ ògyògyè dìvayì ɔ̀. Kǎdʉ̀ kɨ̀wà ndɔ̀tʉ̀ ízò-tsʉ̀-dɔ̌, ndàbhʉ ndɨ́nɨ̌ Yěsù andʉ́ tɨ́ ɔ̀nà rɨ́’ɨ̀ dìvayì ndɔ̀tɔ̀. Kǎdʉ̀ àtɨ̀nà: «Nyìtse pɛ́! Kàndà pɛ́ Ɛ̀lɨyà ràtɨ́ kìfo ìfǒ mʉ̀sàlabhà dɔ̌ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nɨ́ Yěsù adʉ̀ òkù àrǐ nyʉ́ tɨ́, afína ràdʉ̀ ɨ̀tdɛ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kàgàwà bhà ɨdza ɔ̌ ka kúsò ádrʉ̀ngbǎ mbɛrʉ̀-ɔ̌nga náadʉ̀ ndɨ̀fa ɔ̀nánga rùtù ndɨ̀ ɔyɔ, rɔ̀pɛ̀ ndɨ̀ ɔrʉ̀ rɔ̀ rɨ̀sɨ̌ obvò. ");
INSERT INTO niy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pbàrɔ́má tɔ́ pbìrì ɔ̌ atdí mɨyà pbànówí dɔ̌ ádrʉ̀ngbǎ alɛ nɨ́ɨ’ɨ̀ Yěsù-ɔ̀nzɨ̌ ndɨ̀ ndìdè rɔ́. Nɨ́ Yěsù ɔ̀vɛ̀ tɨ́ dhu ndɨ̀ ndàla rɔ̀, kǎtɨ: «Yàrɨ́ alɛ nɨ́’ɨ̀ obhó nyʉ́ Kàgàwà t’Ídhùnà!» ");
INSERT INTO niy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngúfe vèbhálɛ nɨ́ɨ’ɨ̀ átɔ̀ ányɨ̀rɔ̌, ’àmbɛ dhu àndà dɔ̌ ɨtsɛ rɔ̀. Abádhí nzínzì ɔ̌ ɨ’ɨ̀ nɨ́, Màgàdalà tɔ́ pbanga ɔ̌ Màrɨyà mà, Màrɨyà, Yàkɔbhɔ̌-ngba mà Yɔ̌sɛ̀ mànà-tsánà mà, Sɔ̀lɔmɨ̀ mànà. ");
INSERT INTO niy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abádhí núubhì Yěsù-owù ɔ̌, ’àdʉ̀ òwu kà-kàsʉ̌ ɔ̀nzɨ̀ rɔ̌ Gàlìlayà tɔ́ pbìrì ɔ̀ kɨ̌’ɨ̀ rɔ̀. Ibí ngʉ̌kpà vèbhálɛ yà kà mànà upò atdíkpá ’òwù Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ nɨ́ɨ’ɨ̀ ìnè átɔ̀ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɨnga rǎtɨ dhu-tsʉ̀ dɔ̌, yà tsútsǎ nɨ́nganɨ́ Sàbatʉ̀ nɨ́ɨ’ɨna rɔ́rɔ̀ ìndrǔ rɨ̌ ɨ̀ ɔ̀bhɔlɔ ɔ̀ná ɨdhɔ ɔ̌, ");
INSERT INTO niy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yɔ̀zɛfʉ̀ nɨ́ɨra àhʉ. Ka nɨ’ɨ̀ Àrìmàtayò tɨ́ kátɨna pbanga ɔ̌ alɛ. Ndɨrɔ̀, ka nɨ’ɨ̀ atdídɔ̌ ka kɨ́fʉ Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ nzínzì ɔ̌ atdí alɛ. Ndɨrɔ̀, ka nɨ’ɨ̀ átɔ̀ arɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi rɨ̌rà dhu nɔ́dɔ atdyúna nà alɛ. Nɨ́, kǎrà ɨ̀mbǎ ɔ̀ná ɔdɔ́na Pìlatɔ̀ bhà, ndàdʉ̀ Yěsù-abvò nónzì kàfɔ́. ");
INSERT INTO niy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pbɛ́tʉ̀, ɨdhɔ nʉ́ʉkɔ Pìlatɔ̀ atdídɔ̌ ɨwà Yěsù ɔ̀vɛ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀. Nɨ́ kǎdʉ̀ Pbàrɔ́má tɔ́ pbìrì ɔ̌ atdí mɨyà pbànówí dɔ̌ ádrʉ̀ngbǎlɛ návi kanzì, ndàdʉ̀ angyí màtɨ́ Yěsù nɔ́vɛ̀nà dhu nívu tsʉ̀ná. ");
INSERT INTO niy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nɨ́ wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ nádu fɨ̌ndà dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, kǎdʉ̀ Yɔ̀zɛfʉ̀ návi rìdyì Yěsù-abvò. ");
INSERT INTO niy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yɔ̀zɛfʉ̀ náadʉ̀ abvo t’ɔ́tdʉ̀ta tɔ́ mbɛrʉ̀ nódzì. Kǎdʉ̀ Yěsù-abvò nífo mʉ̀sàlabhà dɔ̌ rɔ̀, ndàkpɔ̀rɔ̀ ndɨ mbɛrʉ̀ ɔ̀. Kǎdʉ̀ àrà ndɨ abvo nà, ndàrà ɔ̀tdʉ̀nà, ndɨ̀lɨ bhalabhala ɔ̀ ka kóbhì ròtsù ibhu ɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ádrʉ̀ngbǎ odu-ɨ́yà-ba nɨ́gɛ̀rɛ̀, ndàpbǐ ndɨ ibhu-li’ɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Màgàdalà tɔ́ pbanga ɔ̌ Màrɨyà mà, Màrɨyà Yɔ̌sɛ̀-tsánà mànà, náadʉ̀ òko ’àmbɛ kɔ̀tdʉ̀ ka kɨ́ rɔ́ nga nándà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sàbatʉ̀-ɨdhɔ̀ nʉ́dà dhu-dzidɔ̌, Màgàdalà tɔ́ pbanga ɔ̌ Màrɨyà mà, Màrɨyà, Yàkɔbhɔ̀-tsánà mà, Sɔ̀lɔmɨ̀ mànà núudzí ndrùù rɔ́ngʉ akyɛ, ndɨ́nɨ̌ ’owu tɨ́ Yěsù-abvò-ngbɔ̀ nútri nɨ̌. ");
INSERT INTO niy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nɨ́ kútsingá nyʉ́, Sàbatʉ̀ dzidɔ̌ rúbho nga ɔ̌, adyifɔ̀ rɨ̌ ndɨ̀tɔ rɔ́rɔ̀, abádhí náawù Yěsù ka kɔ́tdʉ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nɨ́ otu ɔ̌, abádhí owúnà dhu ɔ̀ngʉ̀ rɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ádhɨ wɔ̀ odu-ɨ́yà-ba nɔ́gɛrɛ rɨ́ àlɛ̌tɔ̀ ibhu-lí rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pbɛ́tʉ̀, yà ɨ̀ ʉ̀bɛ̀ nga ’àndà rɔ̀, abádhí ala wɔ̀ odu ɨwà ka kɔ̀gɛ̀rɛ̀ igi rɔ́. Obhó tɨ́, ndɨ odu ɨ’ɨ̀ ádrʉ̀ngbǎ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɨ́ abádhí atsù ibhu ɔ̀, ’àdʉ̀ ɔ̀wɔ̌wʉ̀ kanzʉ̀ nàfɔ̌ kpatsìbhíngba nála fangà dɔ̀nǎ rɔ̀ àdɨ ányɨ̀ rɔ́. Nɨ́ ɔdɔ náadʉ̀ ɨ̀sɨ̌ atdídɔ̌ abádhí ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nɨ́, wɔ̀ kpatsìbhíngba adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ, nyɨ̌ nyɔ́nɛna nɨ́ Yěsù, Nàzàretì ɔ̌ alɛ, yà mʉ̀sàlabhà dɔ̌ ka kʉ́tɔ̌. Kɨ̀ngbɛ̀ wà ndɨ̀, nɨ́ kàrɨ̌ ɨ̀mbǎ ɨrɔ́. Nyàndà, kànɨ̌ kǎ-bvò ka kɨlɨ ràyi rɔ́ nga. ");
INSERT INTO niy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nyòwu nyʉ̀nɔ dhu Pɛ́tɛrʉ̀ mà tɔ̀, ngʉ̌kpà ábhàlɨ̌ mànà nyǎtɨ, kà ràrɨ̌ àrà nyɔ̌dɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀. Ányɨ̀ nɨ́ ndɨ nyɨ̌ nyɨ́ kàlǎ, yà fʉ̌kʉ̀ kʉ̌nɔ ka dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nɨ́ abádhí núuvò ibhu ɔ̀ rɔ̀, ’àdʉ̀ òtse ɨtsɛ nyʉ́ ndɨ ibhu tɨ́ rɔ̀. Obhó tɨ́, abádhí ambɛ́nà ìvi dɔ̌, ɨdhɔ ràdʉ̀ ’ʉ̀kɔ atdídɔ̌. Ndɨrɔ̀ abádhí nʉ́ʉnɔ nzá atdí dhu mà atdí alɛ tɔ̀ màtɨ́, ɔdɔ nà ɨ̀ ɨ́’ɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yěsù níitdègu ndɨ̀ngbɛ̀, nɨ́ sàbatʉ̀-ɨdhɔ̀ dzidɔ̌ wɛmbɛrɛ̀ tɔ́ ɨdhɔ ɔ̌, kǎvì ndɨ̀ angyi Màgàdalà tɔ́ pbanga ɔ̌ Màrɨyà tɔ̀. Ndɨ Màrɨyà nɨ́ ndɨ àrʉ̀bhʉ̀ nzɛ́rɛ-alafí kǐpfo ɔ̀nà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɨ́yàdhíyà adʉ̀ àrà ndɨ dhu nʉ́nɔ̀ yà Yěsù mà nɨ́ɨ’ɨ̀ mànà alɛ tɔ̀. Ɨ alɛ nɨ́ɨ’ɨ̀ ɨzʉ nà, ’àdʉ̀ àmbɛ ɔ̀dzɨ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pbɛ́tʉ̀, abádhí níitdègu Màrɨyà rǎtɨna Yěsù rɨ̀ngbɛ̀ wà ndɨ̀, ndɨrɔ̀ ɨwà ndɨ̀ ràla ka dhu nɨ́rɨ, nɨ́ abádhí náadʉ̀ nzá kà rʉ̌nɔna dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wɔ̀ dhu-dzidɔ̌, Yěsù náavì ndɨ̀ pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ ɔ́yɔ̌ alɛ tɔ̀. Kǎvì ndɨ̀ abádhí tɔ̀ ɨ̀nzɨ̌ abádhí rɨ̌ ndʉ̀nɨ̌ ɔ̀ná vurò wɔyɔ̀ ɔ̌. Ɨ ábhàlɨ̌ núubhínà òwu rɔ̌ atdí pbanga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nɨ́ ɨ ábhàlɨ̌ náadʉ̀ ’àdu, ’òwù ndɨ dhu nɔ́vɔ̀ ngʉ̌kpà ábhàlɨ̌ tɔ̀. Pbɛ́tʉ̀ ɨ ábhàlɨ̌ náadʉ̀ nzá abádhí rʉ̌nɔna dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kà rǐku dɔ̀ná rɔ̀ nɨ̌, Yěsù náavì ndɨ̀ pbɨ̀ndà ɨdrɛ dɔ̀ná atdí nà ábhàlɨ̌ tɔ̀, ɔ̀nyʉ̀ nɔ́nyʉ abádhí rɨ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌. Nɨ́ Yěsù apɛ̀ ndɔ̀rʉ̀ abádhí dɔ̌ ndàtɨ: «Nyɨ̌ nyɨ́’ɨ̀ mbǎ a’uta nà, ndɨrɔ̀ afíkʉ rɨ̌’ɨ̀ odú nyʉ́, ɨnzá nyɨ̌ nyà’ù yà ma mɨ̀ngbɛ̀ ma dhu nàla alɛ rʉ̌nɔna dhu dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu yà adzɨ ɔ̌ kɔ́rɔ́ ngari ɔ̀nǎ, nyǎdʉ̀ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ kɔ́rɔ́ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nyɨ̌ nyʉ́nɔna dhu ná’u rɨ́, ndàdʉ̀ bàtizò nálʉ alɛ nɔ́ɔgʉ́ya ɔ̀gʉ̀. Pbɛ́tʉ̀ ɨ̀nzɨ̌ rɨ́ nyɨ̌ nyʉ́nɔna dhu ná’u alɛ dɔ̌ ka kɔtdɨ́ya anya. ");
INSERT INTO niy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kàrɨ́ nɨ́ ɨ yà nyɨ̌ nyʉ́nɔna dhu nà’ù alɛ nʉ́nɨ rɔ̌ ka kowuya rɔ̀yá ize: abádhí nóowuya nzɛ́rɛ-alafí nípfo rɔ̌ ìndrǔ ɔ̀ rɔ̀ ɔvɔ̀du rɔ̌. Abádhí nóowuya ɔ̀tɛ rɔ̌ yà ɨnzá ɨ̀ àpɛ̀ ʉ̀nɨ̌na angyangyɨ alávà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Abádhí nóowuya mbǎ osu mà nʉ́lʉ rɔ̌ ɔtsʉ́ya nɨ̌, ’àdʉ̀ ìndrǔ òho rɨ̌ itsu mà nɔ́mvʉ̀, nɨ́ atdí nzɛ́rɛ dhu mà náaraya nzɨ̌ ndɔ̀nzɨ̀ rɔ̌ abádhí rɔ̌. Abádhí nóowuya ɔtsʉ́ya nʉ́lɨ rɔ̌ andɨtálɛ dɔ̌, ɨ alɛ ràdʉ̀ ʉ̀gʉ.» ");
INSERT INTO niy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wɔ̀ dhu bhěyi Ádrʉ̀ngbǎlɛ Yěsù nɔ́vɔ̀ dhu pbɨ̀ndà ábhàlɨ̌ tɔ̀ dhu-dzidɔ̌, Kàgàwà náadʉ̀ kòdyì tɨna ɔ̀ ɔ̀rʉ̀-akpà ɔ̀, kà ràdʉ̀ àdɨ Kàgàwà bhà fangà dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nɨ́ Yěsù bhà ábhàlɨ̌ adʉ̀ òwu Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ kɔ́rɔ́ ngari ɔ̀nǎ. Ádrʉ̀ngbǎlɛ Kàgàwà náaránà abádhí-dzʉ̀nà nɔ́nzɨ̀ rɔ̌ ndɨ kasʉ ɔ̌, ndàdʉ̀ àrà abádhí rʉ̌nɔna ɔtɛ tɔ́ obhónga nábhʉ rɔ̌ ràvi ndɨ̀ wɨwɨ̀-otù ɔ̌.");
INSERT INTO niy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ádrʉ̀ngbǎlɛ Tòfilǒ, ábhɔ̌ alɛ nyʉ́ nómvù wà ɨ̀ ràndǐ dhu yà àlɛ̌ nzínzì ɔ̌ ndɨ̀ nɔ́nzɨ̀ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Abádhí nándǐ ɨ dhu àdhàdhɨ̀, yà ɨ dhu rɨ̌ ’ɔ̀pɛ̀ ’ɔ̀nzɨ̀ ɨ̀ dhu nala nyɨ̀kpɔ́ya nyʉ́ nɨ̌ alɛ náawɛ àlɛ̌ tɔ̀ dhu bhěyi. Ɨ alɛ nɨ́ ɨ adʉ̀ ’ɔ̀pɛ̀ ’ʉ̀nɔ̀ ndɨ ɔtɛ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nɨ́ ɨma mà átɔ̀, ma mádʉ̀ kɔ́rɔ́ ɨ dhu tɔ́ obhónga nɔ́nɛ̀ mʉnɨ mběyi nyʉ́, rɔ̀pɛ̀ ndɨ̀ yà ɨ dhu náapɛ̀ ɨ̀ rɔ́rɔ̀. Nɨ́ ádrʉ̀ngbǎlɛ Tòfilǒ, ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mòzè mandǐ yà ma mɔ́nɛ̀ mʉnɨ fɨ̀ndá obhónga dhu ɨndʉ̀, ");
INSERT INTO niy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ndɨ́nɨ̌ nyɨ nyʉnɨ tɨ́ dhu, yà ɨndʉ̀ ka kúdhe dhu ràrɨ̌ obhó dhu nyʉ́. ");
INSERT INTO niy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hɛ̀rɔdɛ̀ nɨ́ɨ’ɨ̀ Yùdɛyà tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà tɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, Zàkàrɨyà nɨ’ɨ̀ kùhanɨ̀. Ndɨ Zàkàrɨyà nɨ’ɨ̀ atdí kùhanɨ̀ yà Àbiyà bhà pbàdzʉkʉrʉ tɨ́ ɨ’ɨ̀ pbàkùhánɨ́ nzínzì ɔ̌. Kàbhà tsìbhálɛ-ɔvɔ̀ nɨ’ɨ̀ Èlìzàbetì, Àrɔ̌nɨ̀-dhú bvʉ̌ tsìbhíngba. Ndɨrɔ̀, ndɨ Àrɔ̌nɨ̀ nɨ’ɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà. ");
INSERT INTO niy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nɨ́ Zàkàrɨyà mà Èlìzàbetì mànà ɔ́yɔ̌ kɔ́rɔ́ nɨ’ɨ̀ obhónángatálɛ Kàgàwà-ɔ̀nzɨ̌, ndɨrɔ̀ Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ʉyátá nɨ́fʉ̌ arɨ́ atdídɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pbɛ́tʉ̀ abádhí nɨ́ɨ’ɨ̀ ɨ̀mbǎ atdí ngbángba nà màtɨ́, Èlìzàbetì nɨ’ɨ̀ ìngò-àyi nɨ́dhunɨ̌. Ndɨrɔ̀ abádhí ɔ́yɔ̌ kɔ́rɔ́ nɨ’ɨ̀ ɨwà óngò mʉ̀là tɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nɨ́ atdíku, yà Zàkàrɨyà mà náarɨ́ kasʉ ɔ̀nzɨ mànà atdíkpá pbàkùhánɨ́ tɔ́ rʉ̀wʉ ɔ̌, Zàkàrɨyà adɨ̀ ndàmbɛ pbɨ̀ndà kasʉ nɔ́nzɨ̀ dɔ̌ Kàgàwà-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nɨ́, yà pbàkùhánɨ́ tɔ́ màndʉ nʉ́nɔ̀ dhu bhěyi, ɔdhɨ́na náavò Zàkàrɨyà ngàlà nɨ̌, ndɨ́nɨ̌ otsú tɨ́ yà pbàkùhánɨ́ kɛ̀lɛ̌ vǐyà dɔ̌ rɔ̀ nóotsúnà ɔ̀nà Ádrʉ̀ngbǎlɛ Kàgàwà bhà ɨdzá kàluga ɔ̀. Kǎhʉ̀ ndrùù arɔ́ngʉ alɨndra-tɨdɔ̀ nɔ́bɨ̀ pɛrɛ̀ tɨ́ màzàbahʉ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, kɔ́rɔ́ ngʉ̌kpà alɛ náadʉ̀ òko àmbɛ ’ɨ̀tsɔ̀ dɔ̌ irinǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nɨ́rɔ̀ nɨ́ ndɨ Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà nɨ́ɨtɔ ndɨ̀ Zàkàrɨyà tɨ́, ndàdʉ̀ ìde alɨndra nʉ́bɨ kà rɨ̌ dɔ̀ná rɔ̀ màzàbahʉ̀ tɔ́ fangà dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nɨ́ wɔ̀ màlàyikà ndɨ̀ ndàla rɔ̀, Zàkàrɨyà-afí náabɛ̀ ndɨ̀ atdídɔ̌, ɔdɔ ràdʉ̀ ɨ̀sɨ̌ ɔ̀nà. ");
INSERT INTO niy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pbɛ́tʉ̀ màlàyikà adʉ̀ àtɨ̀nà kà nɨ̌: «Zàkàrɨyǎ, nzɨ̌ ɔnzɨ ɔdɔ, Kàgàwà nɨ́rɨ̀ wà pbʉ̀kʉ̀ ɨtsɔ̀ta nɨ́dhunɨ̌. Pbʉ̀kʉ̀ tsìbhálɛ Èlìzàbetì rɨ̌ kpatsìbhá ngbángba nʉ́gʉ ɨndʉ̀, nyadʉ̀ ɔvɔ̀na nɔ́vɔ̀ Yùwanɨ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɨ́ kǒkú dɔ̀ rɔ̀, ɨdhɛ̀nʉ nɨ́ɨkaya ndɨ̀, nyadʉ̀ àdɨ ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ ɔ̌. Ndɨrɔ̀, ibí alɛ nyʉ́ nóokoya dhɛ̀dhɛ ɔ̌, ka kʉ̀gʉ̀ ka dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ndɨ ngbángba nɨ’ɨya ádrʉ̀ngbǎlɛ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. Kɔ̌mvʉ́ya nzɨ̌ dɨ̀vayì mà, ndɨrɔ̀ kɔ̌mvʉ́ya nzɨ̌ alɛ òrì rádʉ̀ atdí ɨwa-tɨdɔ̀ mà. Kàgàwà nɨɨráya ka pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nɨ̌, àdàdɨ̀ ɨ́yànà-fɨtsʉ̀ ɔ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ndɨrɔ̀, ka nɨ́ ndɨ Pbàìsràyélí nzínzì ɔ̌ ibí alɛ nabhʉ̀ya rìngò fɨ̀yɔ́ Ádrʉ̀ngbǎlɛ Kàgàwà-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kàgàwà-ɔ̀nzɨ̌ kǔbhìya nà alɛ-afí-tɨdɔ̀, ndɨrɔ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ-tɨdɔ̀ nɨ’ɨya yà Kàgàwà bhà nabì Ɛ̀lɨyà nɨ́ɨ’ɨ̀ nà alɛ-afí mà, ádrʉ̀ngbǎnga tɔ́ ɔbɨ mànà-tɨdɔ̀. Kǎbhʉ̀ya inzo mà rùngbò ɨ̀ abáya mànà, ndàdʉ̀ ɨ̀nzɨ̌ arɨ́ Kàgàwà ózè dhu ɔ̀nzɨ alɛ nábhʉ rʉ̀gɛ̀rɛ̀ ɨ̀, ’òngò obhónángatálɛ tɨ́. Ndɨ dhu bhěyi nɨ́ ndɨ, kɔ̌bhɔlɔya ìndrǔ angyangyɨ Ádrʉ̀ngbǎlɛ Kàgàwà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zàkàrɨyà níivú dhu màlàyikà-tsʉ̌, ndàtɨ: «Wɔ̀ nyɨ nyʉ̀nɔ̀ dhu tɔ́ obhónga nʉ́nɨ̌ ma mɨ́ àdhu rɔ̌? Obhó tɨ́, ɨma nɨ́ mʉ̀là-akpà nyʉ́, ndɨrɔ̀ pbàkà tsìbhálɛ bhà atɔ mà nárà wà ádzǐ nyʉ́ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nɨ́ wɔ̀ màlàyikà adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨma nɨ́ Gàbrìyelì, yà bìlǐ ma marɨ́ ìde Kàgàwà-ɔ̀nzɨ̌, mambɛ kàbhà kasʉ ɔ̀nzɨ̀ dɔ̌ alɛ. Nɨ́ Kàgàwà ìvì ma tɨnʉ ɔ̀, mɨrà wɔ̀rɨ́ ídzì màkʉ̌rʉ̀ nɔ́vɔ̀ ɨndʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pbɛ́tʉ̀ yà ɨnzá nyɨ nyà’ù yà ma mʉ̀nɔ̀ ɨndʉ̀ dhu rɨ̌ ’ɔ̀nzɨ fɨ̀yɔ́ kàsʉmɨ̀ ɔ̌ dhu dhu-okú dɔ̀ rɔ̀, nyɨ nyóngo ìwǐ tɨ́, ɨ̀nzɨ̌ nyongò ɔ̀tɛ, ràrà àhʉ ɨ dhu nóowuya ’ɔ̀nzɨ̀ ɔ̀yá ɨdhɔ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wɔ̀ Zàkàrɨyà mà rɔ̌tɛ màlàyikà mànà ɔ̀ná kàsʉmɨ̀ ɔ̌, ihé-yà náadʉ̀ òko ’àmbɛ Zàkàrɨyà nɔ́dɔ̀ dɔ̌ irí rɔ̀. Nɨ́, ɨ̀nzɨ̌ kà rǎhʉ sɛsɛ Kàgàwà bhà ɨdzá kàluga ɔ̀ rɔ̀ rɔ̀, ɨdhɔ nʉ́ʉkɔ abádhí atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nɨ́ Zàkàrɨyà níitdègu àrà àhʉ ányɨ̀ rɔ̀, nɨ́ kǎdʉ̀ nzá ɔ̀tɛ ìndrǔ mànà. Pbɛ́tʉ̀ kǎdʉ̀ àdɨ ndàmbɛ ɨnga nʉ́dhɔ̀ dɔ̌ ɔtsʉ́na-kpɔ̀ nɨ̌, ɨ̀nzɨ̌ ndɨ̀ ndɔ́tɛ rɔ́rɔ̀. Nɨ́ ìndrǔ adʉ̀ dhu ɔ̀sʉ̀, ɨwà Kàgàwà ràvi ndɨ̀ Zàkàrɨyà tɔ̀ ɔnyʉ rɔ̌dzɨ̀ kà-dɔ̀ dhu bhěyi dhu tɔ́ ɔ́fɔ̀ ɔ̌ ndɨ kàluga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zàkàrɨyà mà tɔ́ rʉ̀wʉ níitdègu ìku, nɨ́ kǎdù ndɨ̀ ndàrà àhʉ pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nɨ́ ngúfe ɨdhɔ dzidɔ̌, Èlìzàbetì, kàbhà tsìbhálɛ náangò ɔ̀na tɨ́. Kǎdʉ̀ ndòrù, ràrà àhʉ imbò àbǐ tɨ́. Kǒngónà àtɨ̀nà afína ɔ̀: ");
INSERT INTO niy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kànɨ̌ Ádrʉ̀ngbǎlɛ Kàgàwà ɔ́nzɨ̀ idù dhu. Àbadhi nípfo wà ma yà nyɨ̀du àbhʉ̌ arɨ́ ràmbɛ ɨ̀wʉ dɔ̌ ìndrǔ nzínzì ɔ̌ dhu-ɨ́yà ɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Atdíku, azà àbǐ tɔ́ ɔ̀na nà Èlìzàbetì rɨ̌’ɨ̀ rɔ́rɔ̀, Kàgàwà náavì pbɨ̀ndà màlàyikà Gàbrìyelì ràrà Gàlìlayà tɔ́ pbìrì ɔ̀, Nàzàretì tɨ́ kátɨna atdí pbanga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ányɨ̀ kǎrà atdí tsìbhíngba, ɨnzá àpɛ̀ kpatsìbhálɛ nʉ́nɨ̌ tɨ’ɔ̀. Ndɨ tsìbhíngba nɨ’ɨ̀ ɨwà Dàwudì-dhú bvʉ̌ alɛ, Yɔ̀zɛfʉ̀ órì. Kɔ̌vɔ̀ nɨ’ɨ̀ Màrɨyà. ");
INSERT INTO niy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Màrɨyà tɨ́ ndɨ̀ ndàrà àhʉ rɔ̀, wɔ̀ màlàyikà náatsɛ ka, ndàtɨ: «Ílè nyɨ Màrɨyǎ, ɨwà nyɨ nyàbà Ádrʉ̀ngbǎlɛ Kàgàwà bhà ídzìnga, ndɨrɔ̀ ìnè Kàgàwà rɨ̌’ɨ̀ nyɨ nà.» ");
INSERT INTO niy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wɔ̀ ɔtɛ ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Màrɨyà-afí náabɛ̀ ndɨ̀ atdídɔ̌. Kɨ̌rɛ̀ nga afína ɔ̀ ndàtɨ: «Yàrɨ́ mʉ̀lɛ̀mbɛ̀-tɨ̀ nyʉ́ nɨ́ àdhu?» ");
INSERT INTO niy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nɨ́ màlàyikà adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ̀nzɨ̌ ɔnzɨ ɔdɔ Màrɨyǎ, Kàgàwà bhà ídzìnga nyɨ nyàbà wà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kɔ̀nɨ̌ nyɨ nyóngo ʉ̀nʉ tɨ́, ndɨrɔ̀ nyɨ nyʉgʉya kpatsìbhá ngbángba, nyadʉ̀ ɔvɔ̀na nɔ́vɔ̀ Yěsù tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka nɨ’ɨya ádrʉ̀ngbǎlɛ, ndɨrɔ̀ ka kanziya ka kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ Kàgàwà t’ídhùnà tɨ́. Ndɨrɔ̀, Ádrʉ̀ngbǎlɛ Kàgàwà náadʉ̀ya kɨ̀lɨ ràdɨ abhunà, kamà Dàwudì bhà tombi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kɔ̌nyʉya idzi Yàkɔbhɔ̀-dhú dɔ̌, ndɨrɔ̀ kàbhà idzi nɨ’ɨya dhòdhódhónga tɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nɨ́, Màrɨyà níivú dhu màlàyikà-tsʉ̌, ndàtɨ: «Wɔ̀ dhu rǎkǎ ɨ̀ngbǎ dhu bhěyi idù, yà ɨnzá ma màpɛ̀ kpatsìbhálɛ nʉ́nɨ̌ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nɨ́, màlàyikà náadʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨ̀lɨ̌lǎ-Alafí rǐfo dʉ̀nʉ́, ndɨrɔ̀ kɔ́rɔ́ dhu dɔ̌ arɨ́ Kàgàwà rɨ̌ nyatsì pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ sɨ́sɨ́ bhěyi. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, nyɨ nyʉ́gʉna ngbángba nɨ’ɨya Kàgàwà ɔ́pɨ̀ fɨ̌ndà, ndɨrɔ̀ ka kanziya ka Kàgàwà t’ídhùnà tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kɔ̀nɨ̌, a’ɛ̀nʉ Èlìzàbetì rɨ̌’ɨ̀ azà àbǐ tɔ́ ɔ̀na nà, àzèmbè ɨwà ka katɨ ndɨ̀ ìngò-àyi tɨ́ rɔ́rɔ̀. Kà rɨ̌ kpatsìbhíngba nʉ́gʉ mʉ̀là dɔ̌ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ɨ̀mbǎ Kàgàwà lɛ̀mà nɔ́nzɨ rɨ́ dhu náarɨ́’ɨ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nɨ́rɔ̀ nɨ́ ndɨ Màrɨyà náadʉ̀ àtɨ̀nà màlàyikà nɨ̌: «Ma nɨ́ Ádrʉ̀ngbǎlɛ Kàgàwà bhà ɨnɔ-àyi. Nɨ́, ítsè ndɨ dhu rɔnzɨ ndɨ̀ yà nyɨ nyʉ̀nɔ̀ ka dhu bhěyi.» Wɔ̀ dhu-dzidɔ̌, màlàyikà náadʉ̀ ndɨ̀và ndàrà kà-tɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Màrɨyà náadʉ̀ ndɨ̀và ndàrà kòmbómbí, yà Yùdhà bhà pbìrì ɔ̌ arɨ́ pbìrì-akpá nzínzì ɔ̌ atdí kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nɨ́ ányɨ̀, kǎtsù Zàkàrɨyà bhà ɨdza, ndàdʉ̀ kàbhà tsìbhálɛ Èlìzàbetì nátsɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Èlìzàbetì níitdègu Màrɨyà nátsɛ̀ ndɨ̀ dhu nɨ́rɨ, nɨ́ kà-fitsʉ̀ ɔ̀ rɨ́’ɨ̀ ngbángba náadʉ̀ ndɔ̀pɛ̀ ndʉ̀bɛ̌ nga kà’ɔ̀. Ndɨrɔ̀, Kàgàwà náadʉ̀ Èlìzàbetì nɨ́ra Ɨ̀lɨ̌lǎ-Afína nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nɨ́, Èlìzàbetì náadʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀ ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ Màrɨyà nɨ̌: «Kàgàwà náso wà nyɨ atdídɔ̌ ròsè kɔ́rɔ́ vèbhálɛ dɔ̀nǎ. Ndɨrɔ̀, kàso wà finʉ-tsʉ̀ ɔ̀ rɨ́’ɨ̀ ngbángba átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ɨ́ngbà dhu-bvʉ̀tɨ́ dhu yà, pbàkà Ádrʉ̀ngbǎlɛ Kàgàwà-tsánà nyʉ́ náarɨ́rà mandà nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ándà, nyɨ nyàtsɛ̀ ma dhu nítdègu ɨ̀sɨ̌ bɨ̌du ɔ̀, nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, yà fidu-tsʉ̀ ɔ̀ rɨ́’ɨ̀ ngbángba nádʉ̀ ndɔ̀pɛ̀ ndʉ̀bɛ̌ nga fidu-tsʉ̀ ɔ̀, ádrʉ̀ngbǎ dhɛ̀dhɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ɨnyɨ, nyɨ nyɔ̀nzɨ̀ wà hirò, yà Ádrʉ̀ngbǎlɛ Kàgàwà nʉ́nɔ̀ ɨndʉ̀ dhu rɨ̌ ndɔ̀nzɨ ɔ̀nzɨ dhu nyɨ nyà’ù dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nɨ́rɔ̀ nɨ́ ndɨ Màrɨyà atɨ: «Ma mɨ́ Ádrʉ̀ngbǎlɛ Kàgàwà nílè atdyúdu nyʉ́ nà, ");
INSERT INTO niy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ndɨrɔ̀ afídu rɨ̌’ɨ̀ ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ ɔ̌, Kàgàwà pbàkà Ɔ̀gʉ̀ba ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kàgàwà nɨ́rɛ̀ ma, yà ɨ̀nzɨ̌ ìndrǔ rǎdʉ̀ ɔ̀zʉ̀nà dhu tɨ́ pbɨ̀ndà ɨnɔ-àyi. Obhó tɨ́, rɔ̀pɛ̀ ndɨ̀ kombí, kɔ́rɔ́ alɛ rǒngo matɨ̀ hirò nɔ́nzɨ̀ tsìbhíngba tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ ɔbɨ nà Kàgàwà nɔ́nzɨ̀ ádrɔ̀drɔ̌ dhu nyʉ́ idù. Kɔ̌vɔ̀ nɨ́ ɨ̀lɨ̌lǎ ɔvɔ. ");
INSERT INTO niy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndɨrɔ̀, yà ɔdɔ̀na ɔ̀nzɨ arɨ́ alɛ dɔ̌ kǎrɨ́ ɨzʉ nábà bìlǐnganà. ");
INSERT INTO niy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kǎvi ɔbɨ̀na nyʉ́, ndòpfòlò yà ɨdzɨ́tá tɔ́ afíya nà arɨ́’ɨ̀ alɛ-ɔ̌nga. ");
INSERT INTO niy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kǐfo ádrɔ̀drɔ̌ kámá fɨ̀yɔ́ ádrɔ̀drɔ̌nga tɔ́ tombi dɔ̌ rɔ̀, ndàdʉ̀ yà ɨ̀nzɨ̌ ka karɔ́zʉ̀na dhu tɨ́ alɛ nɨ́dzɨ, ndʉ̀lɨ ádrɔ̀drɔ̌ ngari ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kǎbhʉ ɨ̀mbǎ dhu arɨ́’ɨ̀ fɔyá alɛ rònzì atdídɔ̌, ndàdʉ̀ ònzǒnzì alɛ nítu, ndòdì ròwù ɔtsʉ́ya-kpa nà. ");
INSERT INTO niy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kɔ̀nzɨ̀ pbɨ̀ndà ɨnɔ, Pbàìsràyélí dzʉ̀nà, ndàdʉ̀ pbɨ̀ndà ɨzʉ nɨ́rɛ̀ dɔ̀yá, ");
INSERT INTO niy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","àdhàdhɨ̀ yà angyangyɨ ndɨ̀ ndavɔ̀ àlɛ̌ t’ábána, Àbràhamʉ̀ mà, pbɨ̀ndà pbàdzʉkʉrʉ mànà tɔ̀, bìlǐnganà ndɨ̀ ndongó tɨ́ ɔ̀nzɨ̀nà dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nɨ́ Màrɨyà mà náadʉ̀ òko atdíkpá Èlìzàbetì mànà, ràrà àhʉ mbɛ̀mbɛ̀ ɨ̀bhʉ àbǐ tɨ́. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɨ̀và, ndàdu ndɨ̀ pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Èlìzàbetì rɨ̌ ndʉ̀gʉ ɔ̀ná kàsʉmɨ̀ níitdègu àkǎ, nɨ́ kǎdʉ̀ kpatsìbhá ngbángba nʉ́gʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nɨ́, Èlìzàbetì mà aróko mànà atdíkpá pbanga ɔ̌ alɛ mà, kà mà t’ɨ́dzá-bhà mànà níitdègu Ádrʉ̀ngbǎlɛ Kàgàwà nábà ɨzʉ Èlìzàbetì dɔ̌, rʉ̀gʉ̀ ngbángba dhu tɔ́ màkʉ̌rʉ̀ nɨ́rɨ, nɨ́ abádhí-ɨdhɛ̀ nɨ́ɨka ndɨ̀ atdíkpá Èlìzàbetì mànà. ");
INSERT INTO niy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nɨ́, wɔ̀ ngbángba nɔ́nzɨ̀ atdí yɛngɛ̀ rɔ̀, abádhí iwú, kadʉ̀ kɔ̀nzɨ̌nga nɔ́bhɔ̀lɔ̀. Ndɨrɔ̀, abádhí azè kɨlɨ àbanà Zàkàrɨyà-ɔvɔ̀ kà-dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pbɛ́tʉ̀, wɔ̀ ngbángba-tsánà Èlìzàbetì náadʉ̀ àtɨ̀nà: «Ɨ̀nzɨ̌ nɨ́ wɔ̀ dhu bhěyi. Kàkǎ kɔvɔ̀ ɔvɔ̀na Yùwanɨ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nɨ́, kɔ̌kɔ̀ Èlìzàbetì mà rɨ̌’ɨ̀ mànà alɛ náadʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ̀mbǎ Yùwanɨ̀ tɨ́ kátɨna ɔvɔ náarɨ́ ɨ̀’ɨ̀ pbʉ̀kʉ̀ ɨdzá-bhà nzínzì ɔ̌ alɛ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɨ́, abádhí adʉ̀ dhu ìvu kà t’ábanà-tsʉ̌ ɔtsʉ́ya nɨ̌, ndɨ́nɨ̌ ɨ̀ ʉnɨ tɨ́ kà ròzè kɔvɔ̀ pbɨ̀ndà ɨngba-ɔvɔ̀ àdhɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nɨ́, Zàkàrɨyà adʉ̀ dhu àndǐ karɨ́ dɔ̀ná odu-afǎ-ngba nónzì ɔtsʉ́na nɨ̌ kiwǔ nà, ndàdʉ̀ yàrɨ́ dhu àndi dɔ̀ná: «Kɔ̌vɔ̀ nɨ́ Yùwanɨ̀.» Nɨ́ ɨdhɔ adʉ̀ kɔ̀rɨ́ alɛ nʉ́kɔ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ Zàkàrɨyà-tsʉ̀ náadʉ̀ ndàngbɛ, Zàkàrɨyà ràdʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀, ndàmbɛ Kàgàwà nílè dɔ̌ ɔrʉ́ tǔna nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɔdɔ nɨ́ɨsɨ́ kɔ́rɔ́ ányɨ̀rɔ̌ arɨ́’ɨ̀ kyɛ̀rɔ̀kyɛ̀rɔ̀ pbanga ɔ̌ alɛ ɔ̀. Ndɨrɔ̀, Yùdɛyà tɔ́ pbìrì ɔ̌ arɨ́’ɨ̀ pbìrì-akpá nzínzì ɔ̌ pbanga ɔ̌, ìndrǔ nóowúnà wɔ̀ ndɨ̀ nɔ̀nzɨ̀ kɔ́rɔ́ dhu tɔ́ màkʉ̌rʉ̀ kɛ̀lɛ̌ náwɛ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nɨ́, kɔ̌kɔ̀ ɨ̀ nɔ̀nzɨ̀ kɔ́rɔ́ dhu dɔ̌ ka kʉ́nɔna dhu nɨ̀rɨ̀ alɛ náadɔ̀ ɨ dhu afíya ɔ̀, ’àdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Yàrɨ́ ngbángba nɨ’ɨya ɨ̀ngbà dhu bhěyi ngbángba-tɨdɔ̀?» Obhó tɨ́, Ádrʉ̀ngbǎlɛ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ́ɨ’ɨ̀ ndɨ ngbángba nà. ");
INSERT INTO niy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wɔ̀ dhu-dzidɔ̌, Kàgàwà nɨ́ɨrá Zàkàrɨyà, wɔ̀rɨ́ ngbángba t’ábanà, Ɨ̀lɨ̌lǎ-Alafí nɨ̌. Nɨ́, Zàkàrɨyà adʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀ Kàgàwà bhà nabì bhěyi, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Ilèta nákǎ kabhʉ Ádrʉ̀ngbǎlɛ, Pbàìsràyélí tɔ́ Kàgàwà tɔ̀, kɨ̌rà pbɨ̀ndà alɛ nándà, ndàdʉ̀ ʉ̀wʉnà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kǎdʉ̀ obhónánga tɔ́ ʉwʉta níbhò àlɛ̌ tɔ̀, pbɨ̀ndà ɨnɔ-akpà Dàwudì bhà ɨdzá-bhà tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kàgàwà náavɔ̀ dhu angyí nyʉ́ pbɨ̀ndà ɨ̀lɨ̌lǎ pbànábí-otù ɔ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ndɨ̀ rɨgʉ́ya àlɛ̌ àlɛ̌ tɔ́ òmvǔ-fɔ́ rɔ̀, ndɨrɔ̀ ndɨ̀ rɨgʉ́ya àlɛ̌ kɔ́rɔ́ alɛ yà àlɛ̌ nɔ́ndrɔ̀-fɔ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ndɨ dhu bhěyi nɨ́ ndɨ kɨ̌tɛ̀ pbɨ̀ndà ɨzʉ àlɛ̌ t’ábána tɔ̀, ndàdʉ̀ abádhí tɔ̀ ndɨ̀ ndanzɨ̀ pbɨ̀ndà ɨ̀lɨ̌lǎ ungbòta tɔ́ làká nɨ́rɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kǎnzɨ̀ ndɨ dhu àdhàdhɨ̀ yà àlɛ̌ t’ábanà Àbràhamʉ̀ tɔ̀ ndɨ̀ ndatsɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kǎtɨ, ndɨ̀ rɨgʉ́ya àlɛ̌ àlɛ̌ tɔ́ òmvǔ-fɔ́ rɔ̀, ndɨ́nɨ̌ àlɛ̌ kongó tɨ́ kàsʉ̌na nɔ́nzɨ̀ ɨ̀nzɨ̌ àlɛ̌ kɨ́ ɔdɔ ɔ̀nzɨ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ndɨ dhu bhěyi nɨ́ ndɨ, àlɛ̌ kokoya ɨ̀lɨ̌lǎ alɛ tɨ́ Kàgàwà-nyɨ̀kpɔ́ ɔ̌, ndɨrɔ̀ obhónángatálɛ tɨ́, kɔ́rɔ́ kàsʉmɨ̀ yà òko àlɛ̌ kòko àlɛ̌-nyɨ̀kpɔ́ nà ɔ̀ná ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndɨrɔ̀ ɨnyɨ pbànɨ̌ngbá, ɨnyɨ nɨ’ɨya kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ Kàgàwà bhà nabì. Obhó tɨ́, nyɨ nyadɨ̀ya angyi Ádrʉ̀ngbǎlɛ tɔ̀, otu nyɨ nyɔbhɔlɔ tɨ́ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ndɨrɔ̀, nyɨ nyadʉ̀ya dhu ɔ̀vɔ̀ kàbhà alɛ tɔ̀, ndɨ́nɨ̌ abádhí ʉnɨ tɨ́ dhu, kà ràrɨ̌ ɨ̀rà ɨ̀ nɨ́gʉ, ndàdʉ̀ fɨ̀yɔ́ nzɛ́rɛnga nʉ́bà fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Obhó tɨ́, àlɛ̌ tɔ́ Kàgàwà nɨ́ atdídɔ̌ arɨ́ ìndrǔ-ɨzʉ̀ nálǎ Kàgàwà: kǎbhʉ̀ya ɔ̀rʉ̀-akpà ɔ̌ awáwʉ̀ ràwʉ̀ àlɛ̌-dɔ̌nga, àdhàdhɨ̀ ndɨ̀tɔ rɨ́ adyifɔ̀ náarɨ́ alɛ-dɔ̌nga náwʉ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kǎbhʉ̀ya yà ɨ́nɔ̀ ɔ̌ aróko, yà ɔvɛ-sɨsɨ̀ níibvú ndɨ̀ dɔ̀yá alɛ-nyɨ̌nga ràwʉ̀. Ndɨ dhu adʉ̀ya àlɛ̌ àbhʉ àlɛ̌ rʉ̀ngʉ màrʉ̀ngà tɔ́ otu.» ");
INSERT INTO niy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wɔ̀rɨ́ ngbángba náambɛ́nà òvi dɔ̌, afína ràdʉ̀ àmbɛ ɔbɨ òtsì dɔ̌. Kǒngónà àdɨ rʉ̀ngʉ̀ ɔ̀, ràrà àhʉ Pbàìsràyélí-ɔ̀nzɨ̌ ndɨ̀ ndaraya ndàvi kpangba ɔ̀ná ɨdhɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ndɨ ɨdhɔ ɔ̌, ádrɔ̀drɔ̌ kámá dɔ̌ kamà Kàyìsarà Ògústò náabhʉ̀ ʉyátá ndàtɨ, pbɨ̀ndà pbìrì ɔ̌ aróko kɔ́rɔ́ alɛ ràkǎ kandǐ fɨ́sɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wɔ̀ ndɨ wɛmbɛrɛ̀ tɔ́ andítá náanzɨ̀ ndɨ̀ yà Kùrèniyò nɨ́ɨ’ɨ̀ lɨ̀walɨ̀ tɨ́ Sìriyà tɔ́ pbìrì dɔ̌ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kɔ́rɔ́ alɛ náawù ɨ̀ àndi, ngǎtsi alɛ ràrà ndàndi fɨ̀yɔ́ pbanga nyʉ́ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nɨ́, Yɔ̀zɛfʉ̀ nɨ́ɨvà ndɨ̀ átɔ̀, ndùpò Gàlìlayà tɔ́ pbìrì ɔ̌ pbanga, Nàzàretì tɨ́ kátɨna ɔ̀ rɔ̀, ndàrà Yùdɛyà tɔ́ pbìrì ɔ̀, ndàrà àhʉ Bɛ̀tɛ̀lɛ̀hɛmʉ̀, ádrʉ̀ngbǎ kamà Dàwudì ka kʉgʉ ɔ̀ná pbanga ɔ̀. Kǎrà ányɨ̀ Dàwudì-dhú bvʉ̌ alɛ tɨ́ ndɨ̀ ndɨ́’ɨ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Àbadhi mà náawù ányɨ̀ yà ndɨ̀ ndórì pbɨ̀ndà tsìbhálɛ Màrɨyà nà, ɔ̀na nà rɨ́’ɨ̀ rɔ́rɔ̀, ndɨ́nɨ̌ ka kandí tɨ́ ɨ̀ fɨ́sɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nɨ́ ányɨ̀ ɨ̀ òwù ùvò rɔ̀, Màrɨyà rɨ̌ ndʉ̀gʉ ɔ̀ná ɨdhɔ náaká. ");
INSERT INTO niy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nɨ́, kʉ̌gʉ pbɨ̀ndà sengba tɔ́ kpatsìbhá ngbángba, ndàdʉ̀ ngbɔ̌na nákpɔ̀rɔ̀ mbɛrʉ̀ nɨ̌. Kǎdʉ̀ ndɨ ngbángba nɨ́lɨ ràyi ɨ̀zǎ arɨ́ dhu ɔ̀nyʉ ɔ̀ná kɨ̀walɨ̀ ɔ̀, ɨ̀mbǎ ngari rɨ̌’ɨ̀ olo-dzà ɔ̀ abádhí tɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndɨ pbìrì ɔ̌, mʉ̀tʉngà t’ʉ́ndatatálɛ nɨ́ɨ’ɨ̀ fɨ̀yɔ́ tàmà tɔ́ màhò nɔ́dɔ ɨ̀’ɨ́ kúbhingá ɨrɨ́ ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nɨ́, Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà nɨ́ɨtɔ ndɨ̀ abádhí tɨ́, Ádrʉ̀ngbǎlɛ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ràdʉ̀ ndàtsì abádhí dɔ̌. Nɨ́ ɔdɔ nɨ́ɨsɨ́ abádhí-afí ɔ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pbɛ́tʉ̀, màlàyikà náadʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ, ma mɨ̀rà kɔ́rɔ́ alɛ-ɨdhɛ̀ rɨ̌ ndɨ̀kǎ nɨ̌ ídzì màkʉ̌rʉ̀ nà fʉ̌kʉ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Indo yàrɨ́ iku ɔ̌, ka kʉ̀gʉ̀ Ɔ̀gʉ̀ba fʉ̌kʉ̀, Dàwudì bhà kɨgɔ̀ ɔ̌. Ndɨ Ɔ̀gʉ̀ba nɨ́ Krɨ́stɔ̀ Ádrʉ̀ngbǎlɛ. ");
INSERT INTO niy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndɨrɔ̀, kànɨ̌ kʉ̀nɨ̌ nyɨ̌ nyɨ́ rɔ̀ná dhu: nyɨ̌ nyɨ́ ɨrɛ́-ngba nótù mbɛrʉ̀ ɔ̀ ka kàkpɔ̀rɔ̀ ngbɔ̌na, kadʉ̀ ɨ̀lɨnà ràyi ɨ̀zǎ náarɨ́ dhu ɔ̀nyʉ ɔ̀ná kɨ̀walɨ̀ ɔ̀ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ányɨ̀rɔ̌ rɔ̀ tɨ́ nɨ́ ndɨ, ɔ̀rʉ̀-akpà ɔ̌ màlàyíká tɔ́ ihé-yà náandu ɨ̀ wɔ̀rɨ́ màlàyikà rɔ̌, ɨ̀ rìlè Kàgàwà, àtɨ: ");
INSERT INTO niy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ilèta nákǎ kabhʉ ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Kàgàwà tɔ̀! Ndɨrɔ̀, màrʉ̀ngà nákǎ ndɨ̀’ɨ̀ yà adzɨ dɔ̌ ídzì afíya nà alɛ tɔ̀!» ");
INSERT INTO niy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Màlàyíká nɨ́và ɨ̀ tɨyá rɔ̀, ’àdu ɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, mʉ̀tʉngà t’ʉ́ndatatálɛ náatɛ̀ nzínzìya ɔ̌ ’àtɨ: «Kòwu Bɛ̀tɛ̀lɛ̀hɛmʉ̀, ndɨ́nɨ̌ àlɛ̌ kala tɨ́ ányɨ̀ ndɨ̀ nɔ̀nzɨ̀ dhu, yà Ádrʉ̀ngbǎlɛ Kàgàwà nʉ́nɔ̀ àlɛ̌ tɔ̀ dhu.» ");
INSERT INTO niy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nɨ́, abádhí náawù ányɨ̀ tsàkàtsàkà, ’àdʉ̀ Màrɨyà mà nótù Yɔ̀zɛfʉ̀ mànà, ndɨrɔ̀ ngbángba ràdʉ̀ ɨ̀’ɨ̀ ɨ̀zǎ arɨ́ dhu ɔ̀nyʉ ɔ̀ná kɨ̀walɨ̀ ɔ̀ ndɨ̀ ndàyi rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ndɨ ngbángba ɨ̀ àla rɔ̀, abádhí náawɛ yà màlàyikà nʉ́nɔ̀nà fɨ̌yɔ̀ kà-dɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nɨ́ kɔ́rɔ́ alɛ, yà mʉ̀tʉngà t’ʉ́ndatatálɛ rʉ̌nɔna dhu nɨ̀rɨ̀ nɨ́ ɨdhɔ nʉ́ʉkɔ wɔ̀ abádhí rʉ̌nɔna dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pbɛ́tʉ̀, Màrɨyà náadɔ̀ wɔ̀ dhu kɔ́rɔ́ afína ɔ̀, ndàdʉ̀ àmbɛ ɨnga nɨ́rɛ̀ dɔ̌ dɔ̀ná atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wɔ̀ dhu-dzidɔ̌, mʉ̀tʉngà t’ʉ́ndatatálɛ náadù ɨ̀ Kàgàwà nɨ́fʉ̌ ɨ̀’ɨ́, ’àdʉ̀ àmbɛ ìlènà dɔ̌ rɔ́rɔ̀, kɔ́rɔ́ dhu-tsí yà ɨ̀ ɨ̀rɨ̀, ’àdʉ̀ àlanà nɔ́nzɨ̀ ɨ̀ yà abádhí tɔ̀ màlàyikà nʉ́nɔ̀nà dhu bhěyi tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Atdí yɛngɛ̀ níitdègu àkǎ wɔ̀ ngbángba ka kʉ́gʉ̀ dhu-dzidɔ̌, nɨ́ ka kadʉ̀ kɔ̀nzɨ̌nga nɔ́bhɔ̀lɔ̀. Ka kadʉ̀ ndɨ ngbángba-ɔvɔ̀ nɔ́vɔ̀ Yěsù tɨ́, àdhàdhɨ̀ yà màlàyikà nʉ́ʉnɔ ɨnzá kà-tsánà àpɛ̀ òngo ɔ̀na tɨ́ rɔ́rɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yɔ̀zɛfʉ̀ mà, Màrɨyà nà rɨ̌ ’ù’ǒ ’ɨ̀lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ ɔ̀ná ɨdhɔ náaká àdhàdhɨ̀ Músà bhà Ʉyátá nʉ́nɔ̀ ka dhu bhěyi. Nɨ́ abádhí idyi Yěsù tɔ́ ngbángba ’òwù nà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ’òwù ɨ̀tɛ̀nà Ádrʉ̀ngbǎlɛ Kàgàwà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Obhó tɨ́, Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ʉyátá ɔ̀ ka kandí dhu katɨ, sengba tɨ́ ka kʉ̀gʉ̀ kpatsìbhíngba nɔ́pɨ̀ ka ràrǒngo Ádrʉ̀ngbǎlɛ Kàgàwà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nɨ́ abádhí náadʉ̀ yà Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ʉyátá nʉ́nɔ̀ pɛrɛ̀ núbho átɔ̀. Ɨ pɛrɛ̀ nɨ’ɨ̀ ɔ́yɔ̌ aliri, ngǎtsi nɨ̌ ɔ́yɔ̌ àmbǒ-nzo. ");
INSERT INTO niy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, atdí alɛ, Sìmìyonì tɨ́ kátɨna nɨ́ɨ’ɨ̀ ìnè Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Ndɨ alɛ nɨ’ɨ̀ ídzì alɛ nyʉ́. Ka nɨ’ɨ̀ obhónángatálɛ, ndɨrɔ̀ Kàgàwà nɨ́fʉ̌ arɨ́ atdídɔ̌ alɛ. Ndɨrɔ̀, kǒngónà Pbàìsràyélí ndɨ̀ ndɨgʉ́ tɨ́ rɨ́rà alɛ nɔ́dɔ̀. Nɨ́ Kàgàwà nɨ́ɨrá ka pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nɨ̌, ");
INSERT INTO niy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ndɨ Ɨ̀lɨ̌lǎ-Alafí ràdʉ̀ dhu ɔ̀vɔ̀ angyangyɨ kà tɔ̀ ndàtɨ: ɨ̀nzɨ̌ kà rɔvɛ́ya ɨnzá ndɨ̀ ndàla Ádrʉ̀ngbǎlɛ Kàgàwà rǐvìna Krɨ́stɔ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nɨ́, Ɨ̀lɨ̌lǎ-Alafí rɨ̌ ndʉ̀nda rɔ̀, kǎrà òtsù Kàgàwà bhà ɨdza. Nɨ́rɔ̀ nɨ́ ndɨ Màrɨyà mà, Yɔ̀zɛfʉ̀ nà níiwú Yěsù tɔ́ ngbángba nà, ndɨ́nɨ̌ yà Ʉyátá nʉ́nɔ̀ dhu náaká tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nɨ́, Sìmìyonì náakɔ̀ ngbángba ndàtdǔ, ndàdʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ádrʉ̀ngbǎlɛ Kàgàwǎ, kòmbí nyɨ nyɨ́ mbǎ pbʉ̀kʉ̀ ɨnɔ-akpà nʉ́bha rɔ̀vɛ̀, àdhàdhɨ̀ yà angyangyɨ nyɨ nyavɔ̀ idù dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Obhó tɨ́, ma màla wà pbʉ̀kʉ̀ rɔ̀ ɨ̀rà ɔ̀gʉ̀ nyɨ̀kpɔ́du nyʉ́ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ndɨ ɔ̀gʉ̀ nɨ́ yà nyɨ nyʉ́ nyɨ nyabhɔ̀lɔ̀ kɔ́rɔ́ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ka nɨ́ yà ɨnzá àpɛ̀ nyʉnɨ̌ kɔ́rɔ́ yà adzɨ ɔ̌ alɛ-nyɨ̌nga náwʉ̀ rɨ́ awáwʉ̀. Ndɨrɔ̀ ka nɨ́ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ pbʉ̀kʉ̀ alɛ Pbàìsràyélí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yěsù t’ábanà mà, kà-tsánà mànà ɨdhɔ nʉ́ʉkɔ atdídɔ̌, wɔ̀ Sìmìyonì rʉ̌nɔna Yěsù tɔ́ ngbángba nɨ̌ dhu nɨ́rɨ ɨ̀’ɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sìmìyonì náaso abádhí, ndàdʉ̀ àtɨ̀nà kà-tsánà Màrɨyà nɨ̌: «Yàrɨ́ ngbángba rɨ̌ Pbàìsràyélí nzínzì ɔ̌ ábhɔ̌ alɛ nábhʉ̌ ràwà ɨ̀, ndàdʉ̀ ábhɔ̌ alɛ nɨ́dɨ̀. Ndɨrɔ̀, ka nɨ́ ize yà ìndrǔ àbhʉ̌ rɨ́ ràgò ɨ̀ nzínzìya ɔ̌, ");
INSERT INTO niy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ndɨ́nɨ̌ yà ábhɔ̌ alɛ núuru afíya ɔ̀ ɨrɛ̀ta núuvì tɨ́ ɨ̀ kpangba. Ndɨrɔ̀ ɨnyɨ Màrɨyǎ, pbʉ̀kʉ̀ àpbɛ̀ rɨ̌ ndɨ̀lɨ̌ ɨla tɔ́ obhi-akpà ka kòdù, rɔ̀sʉ̀ afína alɛ bhà àpbɛ̀ bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Kàgàwà bhà atdí tsìbhá nabì, Anà tɨ́ kátɨna, nɨ́ɨ’ɨ̀ ìnè átɔ̀. Anà nɨ’ɨ̀ Àserì-dhú-bvʉ̌ alɛ, Fànolì t’ɨ́vànà. Ka nɨ’ɨ̀ mʉ̀là-àyǐ-ngba nyʉ́. Abádhí náakò yà tsìbhíngba tɨ́ rɔ̀ ɨ̀ ʉmbá ɨ̀ nà alɛ nà àrʉ̀bhʉ̀ atɔ kɛ̀lɛ̌ tɨ́, ndɨ alɛ ràdʉ̀ ɔ̀vɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nɨ́, kǎdʉ̀ àdɨ abvo-àyi tɨ́, ràrà àhʉ àrʉ̀ kumì dɔ̀ná ɨ̀fɔ nà atɔ nɔ́nzɨ ndɨ̀ ndɨ́ dhu ɔ̀. Kǒngónà nzɨ̌ àhʉ iri Kàgàwà bhà ɨdzá rɔ̀. Pbɛ́tʉ̀, kǒngónà Kàgàwà bhà ɨdzá kasʉ kɛ̀lɛ̌ nɔ́nzɨ̀ adyíbhengá màtɨ́ ndɨrɔ̀ kúbhingá màtɨ́. Kǒngónà àdʉ̀ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ̀, ndàdʉ̀ àmbɛ ndɨ̀tsɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nɨ́, ndɨ tsìbhá nabì Anà nɨ́ɨtɔ ndɨ̀ wɔ̀ Sìmìyonì rɔ̌tɛ ɔ̀ná kàsʉmɨ̀ ɔ̌, ndàdʉ̀ ndɔ̀pɛ̀ ndàbhʉ ɔ̀tsɔ̀ Kàgàwà tɔ̀. Ndɨrɔ̀, kǎdʉ̀ ndɔ̀pɛ̀ ndàwɛ dhu Yěsù tɔ́ ngbángba dɔ̌, yà Kàgàwà rɨ̌ Yèrùsàlɛmà nʉ́wʉ̌ dhu nɔ́dɔ arɨ́ kɔ́rɔ́ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yěsù t’ábanà mà, kà-tsánà mànà níitdègu kɔ́rɔ́ dhu nɔ́nzɨ yà Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ʉyátá nʉ́nɔ̀ ka dhu bhěyi, nɨ́ abádhí adʉ̀ ’àdu Yěsù tɔ́ ngbángba nà Gàlìlayà tɔ́ pbìrì ɔ̌ fɨ̀yɔ́ kɨgɔ̀, Nàzàretì tɨ́ kátɨna ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɨ́, Yěsù tɔ́ ngbángba adʉ̀ àdɨ ndàmbɛ ovi dɔ̌, ndàdʉ̀ àmbɛ ɔbɨ àbà dɔ̌. Kàgàwà nɨ́ɨrá ka dhu-ɔ̌nga t’óvòta tɔ́ ɨrɛ̀ta nɨ̌, kɔ́rɔ́ kà rɔ̌nzɨna dhu ràdʉ̀ Kàgàwà-nyɨ̀kpɔ́ nɔ́fɔ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yà atɔ náarɨ́rà dhu bhěyi, Yěsù t’ábanà mà kà-tsánà mànà nóongónà òwu Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nɨ́, Yěsù níitdègu atdí kumì dɔ̀ná ɔ́yɔ̌ nà atɔ nísě, nɨ́ abádhí náawù atdíkpá Yěsù tɔ́ ngbángba mànà àdhàdhɨ̀ yà angyi ɨ̀ arɔ́nzɨna dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nɨ́, mʉ̀hɛndʉ̀ ìku rɔ̀, Yěsù t’ábanà mà, kà-tsánà mànà náadù ɨ̀, ’òngò ɨbha. Pbɛ́tʉ̀, Yěsù tɔ́ ngbángba náadʉ̀ àdɨ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ɨnzá àbanà mà, ɨ́yànà mànà nʉ́nɨ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Abádhí adʉ̀ Yěsù àtɨ̀ ìnè rɨ́’ɨ̀ ɔdhɨ́na mànà ɨ̀ úbhi atdíkpá rɔ́ dhu tɨ́. Nɨ́rɔ̀ nɨ́ ndɨ ɨwà ɨ̀ ùbhi, rɔ̀pɛ̀ ndɨ̀ kútsingánǎ, ràrà àhʉ pbɨ́tsɔ̀ngǎ rɔ́rɔ̀, abádhí apɛ̀ ’ɔ̀mɛ̀ Yěsù, fɨ̀yɔ́ alɛ mà, ɔdhɨ́ya mànà nzínzì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pbɛ́tʉ̀, abádhí náadʉ̀ nzá kàla. Nɨ́, ndɨ dhu-okú dɔ̀ rɔ̀, abádhí náadù ɨ̀ tdɨ́tdɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ’òwù kɔ̀mɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nɨ́, ɨ̀bhʉ ɨdhɔ dzidɔ̌ nɨ́ ndɨ, abádhí náawù kòtù Kàgàwà bhà ɨdzá àdɨ Ʉyátá tɔ́ màlímó nzínzì ɔ̌ rɔ́. Kǎmbɛ́nà Ʉyátá tɔ́ màlímó rʉ̌nɔna dhu nɨ́rɨ̀ dɔ̌, ndàdʉ̀ àrà dhu ɔ̀ngʉ̀ rɔ̌ abádhí-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kɔ́rɔ́ alɛ, yà kà rʉ̌nɔna dhu nɨ́rɨ rɨ́ nʉ́kɔ rɔ̌ ɨdhɔ aránà atdídɔ̌, kàbhà ɨnga t’ʉ́nɨta mà, kà rǎrà tsʉ̀ná ka kìvǔ dhu nádu rɔ̌ tɨ́ dhu mànà dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nɨ́, kà t’ábanà mà kà-tsánà mànà níitdègu kàlǎ, nɨ́ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. Nɨ́, kà-tsánà adʉ̀ àtɨ̀nà kà nɨ̌: «Pbànɨ̌ngbá, ádhu wɔ̀ nyɨ nyɔ̀nzɨ̀ rɔ̀ká? Ándà pɛ́, ɨma, àbanʉ mànà, mǎ mɔ̀nɛ̀ nyɨ ádrʉ̀ngbǎ ɨzʉ nyʉ́ nà.» ");
INSERT INTO niy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ádhu nyɨ̌ nyúbhi mɔmɛ̀ rɔ̌ fɨ̌ndà? Nyɨ̌ nyʉ̀nɨ tɨ́ nzá dhu ma ràrɨ̌’ɨ̀ Àbadu bhà ɨdzá ma mɔ́nzɨna kasʉ nà?» ");
INSERT INTO niy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pbɛ́tʉ̀, wɔ̀ Yěsù nʉ́nɔ̀ dhu náadʉ̀ nzá kà t’ábanà mà, kà-tsánà mànà-dɔ nálʉ. ");
INSERT INTO niy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nɨ́, Yěsù mà náadʉ̀ ɨ̀ àdu abádhí mànà ’òwù Nàzàretì. Kǒngónà abádhí-tsʉ̌ dhu nɨ́rɨ̀ atdídɔ̌, ndɨrɔ̀ kà-tsánà ongónà àdʉ̀ kɔ̌kɔ̀ dhu nɔ́dɔ̀ kɔ́rɔ́ afína ɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ndɨrɔ̀, Yěsù tɔ́ ngbángba náadɨ̀ ndàmbɛ òvi dɔ̌ ngbɔ̌na ɔ̀ rɔ̀, dhu-ɔ̌nga t’óvòta tɔ́ pbɨ̀ndà ɨrɛ̀ta ràdʉ̀ àmbɛ ndìse dɔ̌. Kǒngónà àdʉ̀ Kàgàwà-nyɨ̀kpɔ́ nɔ́fɔ̀ rɨ́ dhu nɔ́nzɨ̀, ndàdʉ̀ ìndrǔ-nyɨ̀kpɔ́ nɔ́fɔ̀ rɨ́ dhu nɔ́nzɨ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tìbèriyò Kàyìsarà nɨ’ɨ̀ Pbàrɔ́má tɔ́ pbìrì ɔ̌ kámá dɔ̌ ádrʉ̀ngbǎ kamà. Nɨ́, atdí kumì dɔ̀ná imbò nà atɔ tɨ́ kɔ̌nyʉ̀ idzi rɔ́ atɔ náhʉ rɔ́rɔ̀, Pòtiyò Pìlatɔ̀ nɨ’ɨ̀ Yùdɛyà tɔ́ pbìrì ɔ̌ lɨ̀walɨ̀. Ndɨrɔ̀, Hɛ̀rɔdɛ̀ nɨ’ɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà, Hɛ̀rɔdɛ̀ t’ádɔ̀nà, Fìlipò ràdʉ̀ ɨ̀’ɨ̀ Ìtùriyò mà, Tràkònitì mànà tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà. Ndɨrɔ̀, Lìsànɨyà nɨ’ɨ̀ Àbìlenì tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà. ");
INSERT INTO niy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Anà mà Kàyafà mànà nɨ’ɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kámá. Nɨ́, rʉ̀ngʉ̀ ɔ̀ Zàkàrɨyà t’ídhùnà Yùwanɨ̀ rɨ̌’ɨ̀ rɔ́rɔ̀, Kàgàwà náavɔ̀ pbɨ̀ndà ɔtɛ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wɔ̀ dhu-dzidɔ̌, Yùwanɨ̀ náadʉ̀ ndɔ̀pɛ̀ ndùbhi Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-bɨdɔ̌ arɨ́’ɨ̀ kɔ́rɔ́ pbìrì ɔ̀na nǎ. Kǎránà ìndrǔ núnzì rɔ̌ bàtizò tɔ̀, ndàrà àtɨ̀nà rɔ̌: «Nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga, nyǎdʉ̀ bàtizò nálʉ. Nɨ́, Kàgàwà rǎdʉ̀ fʉ̀kʉ́ nzɛ́rɛnga nʉ́bà fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wɔ̀ dhu bhěyi nɨ́ ndɨ, nabì Ìsayà náandí pbɨ̀ndà bhǔkù ɔ̀ dhu náaká. Kǎtɨ: «Kɔ̀nɨ̌ atdí alɛ-tù rɨ̌ ndɨ̀rɨ rʉ̀ngʉ̀ ɔ̀: ‹Nyɔ̀bhɔlɔ Àdrʉ̀ngbǎlɛ Kàgàwà bhà ngʉdhà, nyùtǒ kà rǔbhi ɔ̀ná otu. ");
INSERT INTO niy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ɨ̀bhʉ̀ rɨ̌’ɨ̀ ɔ̀yá ngari nákǎ nyʉ̌trɔ adzɨ ɔ̀yá rùlè, nyǎdʉ̀ pbìrì-akpá mà pbìrǐ-nzo mànà núgolo, nyǒhù ròngò kyɛ̀ngyɛ̀rʉ̀ tɨ́. Ɨ̀ nʉ́tdya otu nákǎ nyǔtǒ rìkò tʉ́rʉ́tʉ́rʉ́, ndɨrɔ̀, kulukulu arɨ́’ɨ̀ ɔ̀yá ngari nákǎ nyǒhù mběyi. ");
INSERT INTO niy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ndɨrɔ̀ nɨ́ ndɨ, kɔ́rɔ́ alɛ rɨ̌ Kàgàwà rɨ̌ ìndrǔ nɨ́gʉ̌ tɨ́ dhu nálǎ.›» ");
INSERT INTO niy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɨ́, ihé-yà nóowúnà ìwu rɔ̌ Yùwanɨ̀-tɨ’ɔ̀, ndɨ́nɨ̌ Yùwanɨ̀ núubhò tɨ́ bàtizò fɨ̌yɔ̀. Nɨ́, Yùwanɨ̀ aránà àtɨ̀nà rɔ̌ abádhí nɨ̌: «Nyɨ̌ nɨ́ ámvɔ̀ tɔ́ osu-tsè! Ádhɨ ndɨ dhu nɔ́vɔ̀ fʉ̌kʉ̀ ndàtɨ, nyɨ̌ ràrɨ̌ ʉ̀gʉ yà rɨ́rà Kàgàwà bhà anya t’ɨ́tdɨ̀ta ɔ̌ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nyɔ̀nzɨ ɨwà nyɨ̌ nyʉ̀gɛ̀rɛ̀ nyɨ̌, nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛ mʉ̀tsɔ dhu návǐ rɨ́ dhu. Ndɨrɔ̀, àpɛ́ nyɨ̀rɛ̀ nga afíkʉ ɔ̀ nyǎmbɛ àtɨ̀nà dɔ̌: ‹Àbràhamʉ̀ nɨ́ abhukà.› Ma mɨ́ dhu nʉ́nɔ fʉ̌kʉ̀: Kàgàwà rǎdʉ̀ kàrɨ́ odu mà nʉ́gɛ̀rɛ̀ ròngò Àbràhamʉ̀ t’ídhúna tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Àlɔ̌ ka kɨ̀yǎ wà kɨlɨ itsu-pfɔ̀ rɔ̌. Nɨ́ kɔ́rɔ́ itsu, yà ɨ̀nzɨ̌ arɨ́ ídzì itsu-kpɔ̌ nɨ́’ɔ̌, nʉ́kɛ̀rɛ̌ ka kɨ́, kadʉ̀ àwànà kàzʉ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nɨ́ ihé-yà níivú dhu Yùwanɨ̀-tsʉ̌ ’àtɨ: «Mǎ mɨ́ dhu ɔ̀nzɨ ɨ̀ngbǎ tɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nɨ́, kǎdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɔyɔ rɨ́’ɨ̀ mʉ̀dzarʉ̀ nà alɛ, nákǎ ndàbhʉ ka atdí yà ɨ̀mbǎ rɨ́’ɨ̀ kà nà alɛ tɔ̀. Ndɨrɔ̀, ɔ̀nyʉ̀ rɨ̌’ɨ̀ fɔná alɛ nákǎ ndʉ̀ndɔ̀ ka ɨ̀mbǎ rɨ́’ɨ̀ kà nà alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pàratà tɔ́ pbàndɔ́mbɛ́ níiwú átɔ̀, ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ bàtizò. Nɨ́ abádhí níivú dhu Yùwanɨ̀-tsʉ̌, ’àtɨ: «Màlimǒ, mǎ mɨ́ dhu ɔ̀nzɨ ɨ̀ngbàtɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nɨ́, kǎdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Àpɛ́ nyòwu pàratà t’ʉ́fɔ́tá tɔ́ fʉ̀rangà-bvʉ nɔ́tdɨ̀ rɔ̌ ɔrʉ́ nyʉ́, ròsè yà ʉyátá ɔ̀ ka kɔ́tdɨ̀ ka tɨ́ dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ndɨrɔ̀, pbànówí níivú dhu átɔ̀ Yùwanɨ̀-tsʉ̌ ’àtɨ: «Olu mǎ’ɨ́ na, mǎ mɨ́ dhu ɔ̀nzɨ ɨ̀ngbàtɨ́?» Nɨ́, Yùwanɨ̀ adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Àpɛ́ nyòwu atdí alɛ-fɔ́ fʉ̀rangà mà nɨ́dha rɔ̌ ɔbɨ nɨ̌. Ndɨrɔ̀, àpɛ́ nyòwu ìndrǔ nɔ́bhʉ̀ rɔ̌ tɨ̀tɔ̀ dɔ̌, nyǎdʉ̀ fɔná fʉ̀rangà nákɔ. Pbɛ́tʉ̀, nyòwu yà àbǐ dɔ̌ ka karɨ́ nyǔbhǒ nɨ̌ fʉ̀kʉ́ mʉ̀kɨ̀mbà kɛ̀lɛ̌ nɔ́dɔ̀ rɔ̌ nyǎlʉ̌.» ");
INSERT INTO niy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ʉrɔ́ ɨ̀’ɨ̀ alɛ kɔ́rɔ́ náambɛ́nà ndɔ̀nzɨ rɨ́ dhu nɔ́dɔ̀ dɔ̌ atdyúya nyʉ́ nà, ndɨ́nɨ̌ ɨ̀ ala tɨ́. Ndɨrɔ̀ abádhí kɔ́rɔ́ náambɛ́nà nga nɨ́rɛ̀ dɔ̌ afíya ɔ̀ ngǎtsi nɨ̌ Yùwanɨ̀ ràrɨ̌ ndɨ Krɨ́stɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nɨ́, Yùwanɨ̀ adʉ̀ àtɨ̀nà kɔ́rɔ́ ɨ alɛ nɨ̌: «Ɨma, ma mɨ́ bàtizò núbhǒ fʉ̌kʉ̀ ɨdha nɨ̌. Pbɛ́tʉ̀, dzidu dɔ̌ rɨ́rà alɛ rɨ̌’ɨ̀ ɔbɨ nà ròsè dùdu nǎ. Ma màkǎ nzá mʉnga kàpfɔ̀ rɔ̌ kàyìtò-mbǐ mà. Ndɨ alɛ náaraya bàtizò núbho rɔ̌ fʉ̌kʉ̀ Ɨ̀lɨ̌lǎ-Alafí nɨ̌, ndɨrɔ̀ kàzʉ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kàlʉ̌ ɔ̀nyʉ̀-ɔ̌nga t’ɨ́lɛ̀ta tɔ́ kanyà-tɨdɔ̀ fɔná, ndɨ́nɨ̌ ndipfo tɨ́ nganʉ̀-kpɔ̌ nɨ̌ kɛ́lɛ́na ɔ̀ rɔ̀. Nɨ́, kǔnduya nganʉ̀-kpɔ̌-tsʉ̀ pbɨ̀ndà ɔ́ngɔ̀lɨ̌ ɔ̀, ndàdʉ̀ dzɛ́ngɛ́lɛ́na nʉ́bɨ̀ ɨ̀nzɨ̌ arávɛ ádrʉ̀ngbǎ kàzʉ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Wɔ̀ dhu bhěyi nɨ́ ndɨ, Yùwanɨ̀ náaránà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ìndrǔ tɔ̀. Kǎránà ìndrǔ àkǎ ’òkò tɨ́ dhu nɔ́vɔ̀ rɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nɨ́rɔ̀ nɨ́ ndɨ Yùwanɨ̀ adʉ̀ lɨ̀walɨ̀ Hɛ̀rɔdɛ̀ bhà nzɛ́rɛnga nɔ́vɔ̀ kà tɔ̀, adɔ̀nà-ve Hɛ̀rɔ̀diyà kǎkɔ dhu-okú dɔ̀ rɔ̀, ndɨrɔ̀ abhɔ kʉ̌fǎ ngʉ̌kpà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nɨ́, Hɛ̀rɔdɛ̀ adʉ̀ dhu àfa tdɨ́tdɔ̌ atdídɔ̌ nyʉ́ ròsè, ndàbhʉ Yùwanɨ̀ kosò imbi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kɔ́rɔ́ alɛ níitdègu bàtizò nálʉ̌, nɨ́ Yěsù adʉ̀ bàtizò nálʉ átɔ̀. Nɨ́, Yěsù rɨ̌ ndɨ̀tsɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, ɔ̀rʉ̀-akpà-tsʉ̀ náangbɛ ndɨ̀, ");
INSERT INTO niy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɨ̀lɨ̌lǎ-Alafí ràdʉ̀ ìfo ɔrʉ̀ rɔ̀, àmbò tɔ́ ɔ́fɔ̀ ɔ̌, ndàdɨ kàdɔ̌. Ndɨrɔ̀, alɛ-tù náadʉ̀ ndɨ̀rɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndàtɨ: «Nyɨ nɨ́ Idhùdu, atdídɔ̌ ma mózè, nyɨ̀kpɔ́du nɔ̀fɔ̀ dhu ɔ̀nzɨ arɨ́ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yěsù rɨ̌ pbɨ̀ndà kasʉ nɔ́pɛ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kàbhà atɔ nɨ́ɨ’ɨ̀ mbɛ̀mbɛ̀ ɨ̀bhʉ kumì tɨ́ ndɨ̀ ndáhʉ rɔ́. Nɨ́ ìndrǔ ongónà dhu ɨ̀rɛ̀ Yěsù ràrɨ̌ Yɔ̀zɛfʉ̀ t’ídhùnà. Yɔ̀zɛfʉ̀ nɨ’ɨ̀ Helì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helì nɨ’ɨ̀ Màtatì t’ídhùnà. Màtatì nɨ’ɨ̀ Lawì t’ídhùnà. Lawì nɨ’ɨ̀ Mèlekì t’ídhùnà. Mèlekì nɨ’ɨ̀ Yanà t’ídhùnà. Yanà nɨ’ɨ̀ Yɔ̀zɛfʉ̀ t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yɔ̀zɛfʉ̀ nɨ’ɨ̀ Màtàtiyà t’ídhùnà. Màtàtiyà nɨ’ɨ̀ Àmɔsɛ̀ t’ídhùnà. Àmɔsɛ̀ nɨ’ɨ̀ Nàhumù t’ídhùnà. Nàhumù nɨ’ɨ̀ Èsilì t’ídhùnà. Èsilì nɨ’ɨ̀ Nàgayì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nàgayì nɨ’ɨ̀ Matì t’ídhùnà. Matì nɨ’ɨ̀ Màtàtiyà t’ídhùnà. Màtàtiyà nɨ’ɨ̀ Sìmeyì t’ídhùnà. Sìmeyì nɨ’ɨ̀ Yɔ̌sɛ̀ t’ídhùnà. Yɔ̌sɛ̀ nɨ’ɨ̀ Yudhà t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yudhà nɨ’ɨ̀ Yɔ̀wanà t’ídhùnà. Yɔ̀wanà nɨ’ɨ̀ Rɛsà t’ídhùnà. Rɛsà nɨ’ɨ̀ Zèrùbàbelì t’ídhùnà. Zèrùbàbelì nɨ’ɨ̀ Sàrtɨ̀yɛlɛ̀ t’ídhùnà. Sàrtɨ̀yɛlɛ̀ nɨ’ɨ̀ Nerì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerì nɨ’ɨ̀ Mèlekì t’ídhùnà. Mèlekì nɨ’ɨ̀ Adì t’ídhùnà. Adì nɨ’ɨ̀ Kɔ̀samà t’ídhùnà. Kɔ̀samà nɨ’ɨ̀ Èlìmàdamʉ̀ t’ídhùnà. Èlìmàdamʉ̀ nɨ’ɨ̀ Erì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erì nɨ’ɨ̀ Yɛ̀sʉwà t’ídhùnà. Yɛ̀sʉwà nɨ’ɨ̀ Èlìyèzerì t’ídhùnà. Èlìyèzerì nɨ’ɨ̀ Yòrimù t’ídhùnà. Yòrimù nɨ’ɨ̀ Màtatà t’ídhùnà. Màtatì nɨ’ɨ̀ Lawì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawì nɨ’ɨ̀ Sìmìyonì t’ídhùnà. Sìmìyonì nɨ’ɨ̀ Yudhà t’ídhùnà. Yudhà nɨ’ɨ̀ Yɔ̀zɛfʉ̀ t’ídhùnà. Yɔ̀zɛfʉ̀ nɨ’ɨ̀ Yɔ̀namà t’ídhùnà. Yɔ̀namà nɨ’ɨ̀ Èlìyàkimù t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Èlìyàkimù nɨ’ɨ̀ Mɛ̀lɛyà t’ídhùnà. Mɛ̀lɛyà nɨ’ɨ̀ Mɛ́nà t’ídhùnà. Mɛ́nà nɨ’ɨ̀ Màtatà t’ídhùnà. Màtatà nɨ’ɨ̀ Nàtanà t’ídhùnà. Nàtanà nɨ’ɨ̀ Dàwudì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dàwudì nɨ’ɨ̀ Yɛ̌sɛ̀ t’ídhùnà. Yɛ̌sɛ̀ nɨ’ɨ̀ Ɔ̀bɛdɛ̀ t’ídhùnà. Ɔ̀bɛdɛ̀ nɨ’ɨ̀ Bɔ̀azà t’ídhùnà. Bɔ̀azà nɨ’ɨ̀ Sàlmɔnɨ̀ t’ídhùnà. Sàlmɔnɨ̀ nɨ’ɨ̀ Nàsɔnɨ̀ t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nàsɔnɨ̀ nɨ’ɨ̀ Àmɨ̀nàdabhʉ̀ t’ídhùnà. Àmɨ̀nàdabhʉ̀ nɨ’ɨ̀ Àdɨ̀mɨnɨ̀ t’ídhùnà. Àdɨ̀mɨnɨ̀ nɨ’ɨ̀ Arnì t’ídhùnà. Arnì nɨ’ɨ̀ Hɛ̀srɔmɨ̀ t’ídhùnà. Hɛ̀srɔmɨ̀ nɨ’ɨ̀ Pàrezì t’ídhùnà. Pàrezì nɨ’ɨ̀ Yudhà t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudhà nɨ’ɨ̀ Yàkɔbhɔ̀ t’ídhùnà. Yàkɔbhɔ̀ nɨ’ɨ̀ Ìsakà t’ídhùnà. Ìsakà nɨ’ɨ̀ Àbràhamʉ̀ t’ídhùnà. Àbràhamʉ̀ nɨ’ɨ̀ Tɛrà t’ídhùnà. Tɛrà nɨ’ɨ̀ Nàhorì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nàhorì nɨ’ɨ̀ Sèrugù t’ídhùnà. Sèrugù nɨ’ɨ̀ Rewù t’ídhùnà. Rewù nɨ’ɨ̀ Pèlegì t’ídhùnà. Pèlegì nɨ’ɨ̀ Èberì t’ídhùnà. Èberì nɨ’ɨ̀ Sɛlà t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sɛlà nɨ’ɨ̀ Kàyìnanà t’ídhùnà. Kàyìnanà nɨ’ɨ̀ Àrʉ̀fàsadì t’ídhùnà. Àrʉ̀fàsadì nɨ’ɨ̀ Semù t’ídhùnà. Semù nɨ’ɨ̀ Nʉwà t’ídhùnà. Nʉwà nɨ’ɨ̀ Làmekì t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Làmekì nɨ’ɨ̀ Mètùsilà t’ídhùnà. Mètùsilà nɨ’ɨ̀ Ɛ̀nɔkà t’ídhùnà. Ɛ̀nɔkà nɨ’ɨ̀ Yɛ̀rɛdɛ̀ t’ídhùnà. Yɛ̀rɛdɛ̀ nɨ’ɨ̀ Màhèlelì t’ídhùnà. Màhèlelì nɨ’ɨ̀ Kàyìnanà t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kàyìnanà nɨ’ɨ̀ Ɛ̀nɔsà t’ídhùnà. Ɛ̀nɔsà nɨ’ɨ̀ Setì t’ídhùnà. Setì nɨ’ɨ̀ Àdamʉ̀ t’ídhùnà. Àdamʉ̀ nabhɔ̀lɔ̀ nɨ’ɨ̀ Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ɨ̀lɨ̌lǎ-Alafí nɨ́rǎ ndɨ̀ rɔ́rɔ̀, Yěsù náadù ndɨ̀ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà ɔ̀ rɔ̀, ndɨ Ɨ̀lɨ̌lǎ-Alafí ràdʉ̀ ndʉ̀ndà ndàrà rʉ̀ngʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nɨ́ ányɨ̀, Pfɔ̀mvɔ núumvú kà-afí ɨ̀fɔ kumì ɨdhɔ tɨ́. Kɔ̌kɔ̀rɨ́ ɨdhɔ́-yà nʉ́ʉdà ɨ̀nzɨ̌ kà rɔ̀nyʉ̀ atdí dhu mà, àwù ràdʉ̀ kàlʉ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɨ́ ndɨ kàsʉmɨ̀ ɔ̌, Pfɔ̀mvɔ náatɨ Yěsù nɨ̌: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Kàgàwà t’ídhùnà tɨ́, nɨ́ ʉ́gɛ̀rɛ̀ pɛ́ wɔ̀rɨ́ odu ròngò mʉ̀gatì tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Kàgàwà bhà Andítá rǎtɨna: ‹Ɨ̀nzɨ̌ nɨ́ mʉ̀gatì kɛ̀lɛ̌ ndɨ ìndrǔ bhà ípìrɔ̌nga ɔ̀dɔ̀ rádʉ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pfɔ̀mvɔ náadʉ̀ kàbhʉ ràrà ɔrʉ́ nyʉ́ ndɨ̀ nángbɛ ngari ɔ̀, ndàdʉ̀ kàbhʉ ràndà yà adzɨ dɔ̌ ádrɔ̀drɔ̌ kámá tɔ́ pbìrì kɔ́rɔ́ ákɛ̌ kàsʉmɨ̀ ɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kǎdʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ma mɨ́ nyabhʉ̌ nyɔnyʉ̀ idzi kɔ́rɔ́ kǎkàrɨ́ pbìrì dɔ̌, nyadʉ̀ àdɨ ɨ pbìrì tɔ́ ádrɔ̀drɔ̌nga mà, ɔ̀yá ònzì mànà dɔ̌ kɔ́rɔ́. Ka kibho wà ka idù, nɨ́ ma mádʉ̀ kàbhʉ ma mòzè alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nɨ́rɔ̀, nyɨ nyapɛ́ nyɔkɔ̀ ɔnzɨ̀dú, nyɨfʉ ɨma, nɨ́ ma mɨ́ kɔ̌kɔ̀rɨ́ dhu núbhǒ kɔ́rɔ́ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nɨ́ Yěsù adʉ̀ ɔtɛ àdu kà tɔ̀, ndàtɨ: «Andítá rǎtɨna: ‹Dhu àkǎ nyɨfʉ Ádrʉ̀ngbǎlɛ, pbʉ̀kʉ̀ Kàgàwà, nyadʉ̀ kà kɛ̀lɛ̌ nʉ́lɛ atdírɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tdɨ́tdɔ̌, Pfɔ̀mvɔ adʉ̀ Yěsù àbhʉ ràrà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ràrà àhʉ Kàgàwà bhà ɨdza tɔ́ mʉ̀narà dɔ̀. Kǎdʉ̀ àtɨ̀nà Yěsù nɨ̌: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Kàgàwà t’ídhùnà tɨ́, nɨ́ ɔ́bɛ̀ nyɨ ɨrɔ́ rɔ̀ nyɨsɨ̌ obvò. ");
INSERT INTO niy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Andítá rǎtɨna: ‹Kàgàwà rǎdʉ̀ pbɨ̀ndà màlàyikà návi rɔ̀dɔ̀ ngbɔ̌nʉ.› ");
INSERT INTO niy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ndɨrɔ̀, ndɨ Andítá rǎtɨna tdɨ́tdɔ̌: ‹Abádhí rɨ̌ nyitdù ɔtsʉ́ya-tsírɔ́, akyɛ odu abhʉ̀na pfɔ̌nʉ ràvɔ nɨ̌.›» ");
INSERT INTO niy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nɨ́, Yěsù adʉ̀ dhu àdu Pfɔ̀mvɔ tɔ̀, ndàtɨ: «Kàgàwà bhà Andítá rǎtɨna: ‹Ɨnzá dhu àkǎ nyumvǔ Ádrʉ̀ngbǎlɛ pbʉ̀kʉ̀ Kàgàwà-afí.›» ");
INSERT INTO niy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nɨ́ Pfɔ̀mvɔ níitdègu Yěsù-afí númvǔ kɔ́rɔ́ otu ɔ̌, nɨ́ kǎdʉ̀ àrà ɨtsɛ Yěsù-tɨ́ rɔ̀, ràrà àhʉ ngǎtsi kàsʉmɨ̀ náaraya ndìbhò dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wɔ̀ dhu-dzidɔ̌, Yěsù náadù ndɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̀, ɨwà Ɨ̀lɨ̌lǎ-Alafí nɨ́rǎ ndɨ̀ pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ rɔ́rɔ̀. Nɨ́ kà rɔ̌nzɨna dhu-ɔ̀yɨ̌ nʉ́ʉgà ndɨ kɔ́rɔ́ ndɨ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kǎránà dhu núdhe rɔ̌ ìndrǔ tɔ̀ Pbàyàhúdí tɔ́ unduta-dzà ɔ̌ rɔ̀, kɔ́rɔ́ alɛ ràdʉ̀ òwu ndɨ̀ kɛ̀lɛ̌ nɨ́fʉ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wɔ̀ dhu-dzidɔ̌, Yěsù náarà Nàzàretì tɔ́ pbanga yà ndɨ̀ nyʉ́ ndɨ̀ ndavì ɔ̀ná ɔ̀. Nɨ́, sàbatʉ̀-ɨdhɔ̀ ɔ̌, kǎtsù unduta-dzà ɔ̀, yà bìlǐ ndɨ̀ ndarɨ́ ɔ̀nzɨna dhu bhěyi. Nɨ́, kɨ̌và ndɨ̀ ndìdè, ndɨ́nɨ̌ ndɨ̀ ndɔzʉ́ tɨ́ Kàgàwà bhà Andítá. ");
INSERT INTO niy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nɨ́, ka kadʉ̀ nabì Ìsayà náandí bhǔkù nábhʉ kà-fɔ́. Nɨ́, kǎngbɛ ndɨ bhǔkù, ndàdʉ̀ ɨ̀sɨ̌ yà dhu bhěyi ka kándǐ dhu ɔ̀ná ngari dɔ̌: ");
INSERT INTO niy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ádrʉ̀ngbǎlɛ bhà Ɨ̀lɨ̌lǎ-Alafí rɨ̌’ɨ̀ dùdú. Kǔtri ɨma, ndɨ́nɨ̌ ma mʉnɔ tɨ́ pbɨ̀ndà Ídzì Màkʉ̌rʉ̀ nǎkʉ̀tálɛ tɔ̀. Kǐvì ɨma, ndɨ́nɨ̌ ma mɔvɔ tɨ́ imbi ɔ̀ ka kúsǒ alɛ nʉ́kɔ̀lɔ̌ ka kɨ́ dhu ɨ alɛ tɔ̀, madʉ̀ ndùmùndúmú-nyɨ̀kpɔ́ rɨ̌ ɨ̀ nʉ́ngbɛ̌ dhu nɔ́vɔ̀ ɨ ndùmùndúmú tɔ̀. Kǐvì ɨma, ndɨ́nɨ̌ ma mʉkɔlɔ tɨ́ yà rɔ̀yá ka karávu alɛ, ɨnɔ-kàsʉ̌ ɔ̌ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","madʉ̀ ndɨ, Ádrʉ̀ngbǎlɛ Kàgàwà rɨ̌ pbɨ̀ndà ídzìnga návǐ ìndrǔ tɔ̀ ɔ̀ná atɔ nɔ́vɔ̀ ìndrǔ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ wɔ̀rɨ́ Andítá nápbi, ndàdʉ̀ àdunà unduta-dzà ɔ̌ arɨ́ kasʉ ɔ̀nzɨ alɛ-fɔ ɔ̀, ndàdʉ̀ àdɨ obvò. Nɨ́ wɔ̀ unduta-dzà ɔ̌ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ náadʉ̀ nyɨ̀kpɔ́ya nʉ́dɨ Yěsù rɔ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ ɔtɛ ɔ̀pɛ̀, ndàtɨ abádhí nɨ̌: «Wɔ̀ nyɨ̌ nyɨ̀rɨ̀ ma mɔ́zʉ̀na rɔ́ Andítá nákǎ wà indo.» ");
INSERT INTO niy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nɨ́ kɔ́rɔ́ alɛ náa’u wɔ̀ Yěsù rʉ̌nɔna dhu, ɨdhɔ ràdʉ̀ ɨ̀ ʉ̀kɔ kà-li’ɔ̀ rɔ̀ ráhʉ ídzì ɔtɛ nɨ́rɨ ɨ̀’ɨ́ rɔ̀. Abádhí ambɛ́nà àtɨ̀nà dɔ̌: «Tɨ́ obhó Yɔ̀zɛfʉ̀ t’ídhùnà nyʉ́ wɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nɨ́, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Obhó tɨ́, nyɨ̌ nyínè ɨ̀’ɨ̀ nyʉ̌nɔ̀ yàrɨ́ mbàyì idù, nyǎtɨ: ‹Mʉ̀ngangǎ, ɨ́gʉ̌ pɛ́ nyɨ nyɨ-tɨ́rɔ̀.› Ndɨrɔ̀, nyɨ̌ nyínè ɨ̀’ɨ̀ nyǎtɨ ɨma nɨ̌ átɔ̀: ‹Mǎ mɨ́rɨ̀ wà Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̌ nyɨ nyɔ́nzɨ̀ kɔ́rɔ́ dhu. Nɨ́rɔ̀, ɔ́nzɨ pɛ́ ɨ dhu átɔ̀ yà fʉ̀kʉ́ kɨgɔ̀ ɔ̌.›» ");
INSERT INTO niy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà: «Ma mɨ́ kʉ̀nɔ kpangba fʉ̌kʉ̀, obhó dhu nyʉ́ nɨ́ ndɨ: Kàgàwà bhà atdí nabì mà nákɔ̌ ka karɨ́ nzɨ̌ mběyi yà ndɨ̀ nyʉ́ ka kʉ́gʉ̀ ɔ̀ná pbanga ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Nabì Ɛ̀lɨyà bhà atɔ ɔ̌, abvo-ayí nɨ́ɨ’ɨ̀ ìnè ibí nyʉ́ Pbàìsràyélí tɔ́ pbìrì ɔ̌. Ndɨ atɔ ɔ̌, igye náadɨ̀ ɨ̀nzɨ̌ ndɨ̀kɔ̌ ɨ̀bhʉ atɔ dɔ̀ná azà àbǐ nà tɨ́, ádrʉ̀ngbǎ àgǎyì ràdʉ̀ ɨ̀tsɨ̀ kɔ́rɔ́ ndɨ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nɨ́, Kàgàwà náavì nzá nabì Ɛ̀lɨyà ràrà kɔ́rɔ́ ɨ abvo-ayí-bvʉ̀. Pbɛ́tʉ̀, kǎdʉ̀ kòvì ràrà pbɨ̀ndà nɨ́ Sìdɔnà tɔ́ pbìrì ɔ̌ Sàrɛ̀patà tɨ́ kátɨna kɨgɔ̀ ɔ̌ atdí abvo-àyi kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndɨrɔ̀, Kàgàwà bhà nabì Èlisà bhà atɔ ɔ̌, kɨ́kɨ́tálɛ nɨ́ɨ’ɨ̀ ìnè ibí nyʉ́ Pbàìsràyélí tɔ́ pbìrì ɔ̌. Nɨ́, abádhí nzínzì ɔ̌ atdí alɛ mà rɔ̌ kɨ́kɨ́ náagʉ̀ nzá. Pbɛ́tʉ̀, rɔ̀ná kɨ́kɨ́ náagʉ̀ nɨ́ Sìriyà tɔ́ pbìrì ɔ̌ atdí alɛ, Nàmanɨ̀ tɨ́ kátɨna kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nɨ́, wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, kɔ́rɔ́ wɔ̀ Pbàyàhúdí tɔ́ unduta-dzà ɔ̌ ɨ̀’ɨ̀ alɛ náakó atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nɨ́ abádhí adʉ̀ ’ɨ̀và, ’àdhà Yěsù, ’ìpfo kɨgɔ̀ ɔ̀ rɔ̀. Ndɨ dhu-dzidɔ̌ abádhí adʉ̀ ùpo kà nà ndɨ kɨgɔ̀ ka kɔ́sɨ̀ dɔ̀ná pbìrì dɔ̀-tsirɔ̀ ɔ̀, ndɨ́nɨ̌ ’idzì tɨ́ ka ròbòlò pbìrì-ɔngɔ̀ rɔ̀, ràrà ɨ̀tsɨ̀ pbìrì-pfɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pbɛ́tʉ̀, Yěsù adʉ̀ ndàwɨlɨ abádhí nzínzì ɔ̌ rɔ̀, ndàdʉ̀ àrà fɨ̀ndá dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù náarà Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀, Gàlìlayà tɔ́ pbìrì ɔ̀. Nɨ́ ányɨ̀ kǎdɨ̀, ndàmbɛ dhu núdhe dɔ̌ ìndrǔ tɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nɨ́ kɔ́rɔ́ alɛ ɨdhɔ nʉ́ʉkɔ atdídɔ̌, kà rɨ̌ dhu núdhě ádrʉ̀ngbǎlɛ bhěyi nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ndɨrɔ̀, nzɛ́rɛ-alafí náarávu rɔ̀ná atdí alɛ nɨ́ɨ’ɨ̀ unduta-dzà ɔ̌. Nɨ́, ndɨ alɛ akù àrǐ nyʉ́ tɨ́ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Áà! Ádhu nyɨ nyòzè mǎ nà Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ́? Nyɨ nyɨ̀rà tɨ́ tsěka nyɨ nyɔtdɨ́ tɨ́? Ma mʉ̀nɨ wà dhu mběyi nyʉ́ nyɨ ràrɨ̌ àdhɨ. Nyɨ nɨ́ Kàgàwà bhà Ɨ̀lɨ̌lǎ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nɨ́, Yěsù náarʉ̀ ɔrʉ́ tǔna nyʉ́ nà wɔ̀ alɛ ɔ̀ rɨ́’ɨ̀ nzɛ́rɛ-alafí dɔ̌, ndàtɨ: «Ɨ́nɛ̀! Áhʉ̌ wɔ̀ alɛ ɔ̀ rɔ̀!» Nɨ́ wɔ̀ nzɛ́rɛ-alafí níibvú wɔ̀ alɛ-ɔ̌nga kɔ́rɔ́ alɛ-ɔ̀nzɨ̌, ndàdʉ̀ àhʉ kà-ɔ̀ rɔ̀ ɨnzá ndɨ̀ ndɔ̀nzɨ̀ atdí nzɛ́rɛ dhu mà kà-rɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nɨ́, kɔ́rɔ́ alɛ ɨdhɔ nʉ́ʉkɔ atdídɔ̌, ’àdʉ̀ àmbɛ ɔtɛ dɔ̌ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ɨ́ngbà dhu bhěyi ɔtɛ-tɨdɔ̀ wɔ̀? Wɔ̀ alɛ rɨ̌ dhu nʉ́yǎ nzɛ́rɛ-alafí tɔ̀ ádrʉ̀ngbǎlɛ bhěyi, ndɨrɔ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nyʉ́ nà, ɨ nzɛ́rɛ-alafí ràdʉ̀ ùvò ìndrǔ ɔ̀ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɨ́, Yěsù-ɔ̀yɨ̌ náadʉ̀ ndʉ̀gà kɔ́rɔ́ Gàlìlayà tɔ́ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wɔ̀ dhu-dzidɔ̌, Yěsù náahʉ̀ unduta-dzà ɔ̀ rɔ̀, ndàdʉ̀ àrà Sìmonì bhà ɨdza. Ányɨ̀ ɨdzá, Sìmonì bhà agʉna-àyi nɨ́ɨ’ɨ̀ atdídɔ̌ kàzʉ ʉ̀tɔ̀ ndɨ̀ ɔ̀na nǎ rɔ́. Nɨ́, ka kadʉ̀ Yěsù návi, ndɨ́nɨ̌ ka nɨgʉ́ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nɨ́, ányɨ̀-dza ndɨ̀ ndòtsù rɔ̀, Yěsù náagú ndɨ̀ agʉna-àyi dɔ̌, ndàdʉ̀ ɔ̀rʉ̀ ɔrʉ́ tǔna nyʉ́ nà kàbhà andɨ dɔ̌, ndɨ andɨ ràdʉ̀ ɔ̀gʉ̀. Nɨ́, wɔ̀ agʉna-àyi adʉ̀ ndɨ̀và ányɨ̀rɔ̌ rɔ̀ tɨ́ ndòyè ɔ̀nyʉ̀ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Adyifɔ̀ rǒtsù rɔ́rɔ̀, yà dhèdhèrɔ̀ andɨ-tɨdɔ̀ nà alɛ nà rɨ́’ɨ̀ ɨdzàya ɔ̀nǎ kɔ́rɔ́ alɛ, níiwú ɨ andɨtálɛ nà Yěsù-tɨ’ɔ̀. Nɨ́, Yěsù nʉ́ʉlɨ ɔtsʉ́na ɨ andɨtálɛ dɔ̌, ɨ alɛ ràdʉ̀ ʉ̀gʉ. ");
INSERT INTO niy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nzɛ́rɛ-alafí náadʉ̀ ùvò átɔ̀ ibí andɨtálɛ ɔ̀ rɔ̀, ’àdʉ̀ òwu ùkǔ rɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Nyɨ nɨ́ Kàgàwà t’ídhùnà!» Pbɛ́tʉ̀, Yěsù náaránà ɔ̀rʉ̀ rɔ̌ ɨ nzɛ́rɛ-alafí dɔ̌, ɨ̀nzɨ̌ ndàdʉ̀ abádhí à’ù rɔ̀tɛ̀, ɨwà abádhí nʉ́nɨ ndɨ̀ ràrɨ̌ Krɨ́stɔ̀ nɨ́dhunɨ̌! ");
INSERT INTO niy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɨnga níitdègu ubho, nɨ́ Yěsù ahʉ̀ Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, ndàdʉ̀ àrà atdí ngari lɛ̀ngɛ̀lɛ̀ngɛ̀ rɨ́’ɨ̀ ɔ̀. Nɨ́, ihé-yà adʉ̀ ’ɔ̀pɛ̀ ɔ̀mɛ̀ ka. Abádhí níitdègu owu kòtù, nɨ́ abádhí adʉ̀ ’ùvo kàrɔ̌ ɨ̀nzɨ̌ ara tɨ́ nzínzìya ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma ka kivi, ndɨ́nɨ̌ ma mʉnɔ tɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀ kɔ́rɔ́ kɨgɔ̀ ɔ̀nǎ. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, dhu àkǎ marà kʉ̀nɔ̀ átɔ̀ ngʉ̌kpà kɨgɔ̀ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nɨ́ kǎdʉ̀ ndɔ̀pɛ̀ ndʉ̀nɔ̀ ka Yùdɛyà tɔ́ pbìrì ɔ̌ unduta-dzà ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Atdíku, Yěsù idè Gɛ̀nɛ̀zàretì tɔ́ rɛ̀rʉ̀-bɨdɔ̌. Nɨ́, ihé-yà adʉ̀ ’àndu ɨ́kyɛ̀rɔ̌ nyʉ́ kàtɨ́, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ kà rʉ̌nɔna Kàgàwà bhà Ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nɨ́, Yěsù ala ɔ́yɔ̌ ibhú rɛ̀rʉ̀-bɨdɔ̌. Ɨ ibhú ɔ̀ ɨ̀’ɨ̀ àwěrù náadʉ̀ ìfo, ’àmbɛ fɨ̀yɔ́ ɨ̀bhɛ̀-mbǐ nú’o dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nɨ́, Yěsù adʉ̀ ùpo ɨ ibhú nzínzì ɔ̌ atdí ibhú ɔ̀. Ndɨ ibhú nɨ’ɨ̀ Sìmonì bhà ibhú. Nɨ́ kǎdʉ̀ Sìmonì àvi rɔ̀tʉ̀ ibhu rɛ̀rʉ̀-bɨdɔ̌ rɔ̀, ròndrì akɛ ɨdha ɔ̀. Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àdɨ ibhú ɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ihé-yà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nɨ́, Yěsù itdègu ndɨ̀ ndúbhi ùdhenà rɔ̌ dhu nɨ́tɔ, nɨ́ kǎdʉ̀ àtɨ̀nà Sìmonì nɨ̌: «Ɔ́tʉ̀ ibhú, ròndrì ádzǐ ɨdha rɨ̌’ɨ̀ rɔ́.» Wɔ̀ dhu-dzidɔ̌, nyàdʉ̀ nyùpe fʉ̀kʉ́ ɨ̀bhɛ̀-mbǐ ɨdha ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nɨ́, Sìmonì adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, mǎ mɔ̀nzɨ̀ kasʉ kurà, ɨ̀nzɨ̌ mǎbà atdí dhu mà. Pbɛ́tʉ̀, nyɨ nyàvi ka dhu bhěyi, ma mɨ́ kùpě ùpě.» ");
INSERT INTO niy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nɨ́, ɨ̀bhɛ̀-mbǐ ɨ̀ ùpe rɔ̀, Sìmonì mà ɔdhɨ́na mànà náadʉ̀ ábhɔ̌ ɨ̀bhɛ̀-ɨ́yà nyʉ́ nɔ́tsɨ̀, abádhí tɔ́ ɨ̀bhɛ̀-mbǐ ràdʉ̀ ’ɔ̀pɛ̀ ’ʉ̀drʉ ɨ̀ ɨ̀bhɛ̀ à’ɛ ndɨ̀ dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sìmonì mà adʉ̀ ngǎtsi ibhú ɔ̀ ɨ̀’ɨ̀ ɔdhɨ́ya nánzì, rìwǔ dzʉ̀nàya ɔ̀nzɨ̀. Nɨ́, ɨ abádhí t’ɔ́dhɨ́ya níiwú, ’àdʉ̀ kɔ̌kɔ̀ ɔ́yɔ̌ ibhú nɨ́ra ɨ̀bhɛ̀ nɨ̌. Ɨ ibhú náadʉ̀ ’ɔ̀pɛ̀ ’àmbɛ usu dɔ̌ ɨdha ɔ̀, ɨ̀bhɛ̀ ná’ɛ ɨ̀ atdídɔ̌ ɔ̀yà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sìmonì Pɛ́tɛrʉ̀ níitdègu wɔ̀ dhu àlǎ, nɨ́ kǎdʉ̀ ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Índrǐ nyɨ ɨtsɛ tɨdú rɔ̀, Ádrʉ̀ngbǎlɛ́, ɨma nɨ́ nzɛ́rɛngatálɛ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Obhó tɨ́, ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ nyʉ́ Sìmonì mà, yà atdíkpá ɨ̀ ɨ́’ɨ̀ mànà kɔ́rɔ́ ɔdhɨ́na mànà ɔ̀ yà abhɔ nyʉ́ ɨ̀ ɔ̀kyɛ̀ ɨ̀bhɛ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sìmonì t’ɔ́dhɨ́na: Yàkɔbhɔ̀ mà, Yùwanɨ̀ mànà ɔ̀ ɔdɔ nɨ́ɨsɨ́ ndɨ dhu bhěyi tɨ́. Ɨ kà t’ɔ́dhɨ́na nɨ’ɨ̀ Zɛ̀bɛ̀dayò bhà inzo. Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà Sìmonì nɨ̌: «Ɨ̀nzɨ̌ ɔnzɨ ɔdɔ, Sìmonǐ! Rɔ̀pɛ̀ ndɨ̀ indo, nyɨ nyóngo ìndrǔ tɔ́ àwěrù tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nɨ́rɔ̀ nɨ́ ndɨ abádhí náawù fɨ̀yɔ́ ibhú nà ɨnga-kpa dɔ̀, ’àdʉ̀ kɔ́rɔ́ fɔyá ɨ̀’ɨ̀ dhu nʉ́bhà ányɨ̀rɔ̌, ndɨ dhu-dzidɔ̌ ’àdʉ̀ Yěsù-owù nʉ́ngʉ. ");
INSERT INTO niy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Atdíku, Yěsù nɨ́ɨ’ɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ atdí kɨgɔ̀ ɔ̀. Nɨ́, kɨ́kɨ́ álʉ̌ ngbɔ̌na kɔ́rɔ́ atdí alɛ nɨ́ɨtɔ ndɨ̀, ndàdʉ̀ Yěsù nála. Nɨ́ kɨ̌ra, ndìtsì ndìbvu Yěsù-ɔ̀nzɨ̌, ndàpbǎ nyɨ̀na adzɨkpa nyʉ́ rɔ̌, ndàdʉ̀ ndɨ̀tsɔ̀ Yěsù rɔ̌ ndàtɨ: «Ádrʉ̀ngbǎlɛ́, nyɨ nyòzè ka nɨ̌, dhu ɔ̀fɔ̀ nga nyɨgʉ̌ ma.» ");
INSERT INTO niy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nɨ́ Yěsù agba ɔtsʉ́na, ndàpbàlǎ kàngbɔ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨwà ma mòzè ka. Nɨ́ ɔ́gʉ̀ nà!» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀rɨ́ alɛ rɔ̌ kɨ́kɨ́ náadʉ̀ ndàwʉ. ");
INSERT INTO niy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wɔ̀ dhu-dzidɔ̌ Yěsù adʉ̀ dhu ʉ̀ya wɔ̀ alɛ tɔ̀, ndàtɨ: «Àpɛ́ nyʉnɔ wɔ̀ dhu atdí alɛ tɔ̀ màtɨ́. Pbɛ́tʉ̀, árà nyɨtɛ̀ nyɨ nyɔ̀gʉ̀ dhu kùhanɨ̀ tɔ̀, nyadʉ̀ yà Músà bhà Ʉyátá nʉ́ʉnɔ pɛrɛ̀ nábhʉ Kàgàwà tɔ̀, ndɨ́nɨ̌ ɨwà nyɨ nyɔ̀gʉ̀ dhu navì tɨ́ kɔ́rɔ́ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wɔ̀ Yěsù ɔ̀nzɨ̀ dhu-ɔ̀yɨ̌ nʉ́ʉgà ndɨ̀ atdídɔ̌. Nɨ́, ihé-yà náadʉ̀ àndu Yěsù tɨ́, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ kà rʉ̌nɔna dhu, ndɨrɔ̀ ndɨ́nɨ̌ kɨ̌gʉ́ tɨ́ nyʉyatsì rɨ́’ɨ̀ andɨ. ");
INSERT INTO niy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pbɛ́tʉ̀, Yěsù adʉ́nà àrà ndɨ̀và rɔ̌, ndàrà àdɨ lɛ̀ngɛ̀lɛ̀ngɛ̀ rɨ́’ɨ̀ ngari ɔ̀, ndàdʉ̀ àmbɛ ndɨ̀tsɔ̀ dɔ̌ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Atdíku Yěsù adɨ̀ ndàmbɛ dhu núdhe dɔ̌ ìndrǔ tɔ̀. Nɨ́, Pbàfàrìsáyó mà, Ʉyátá tɔ́ màlímó mànà níiwú, ’òkò Yěsù tɨ́. Abádhí níiwú Gàlìlayà mà Yùdɛyà mànà tɔ́ pbìrì ɔ̌ kɔ́rɔ́ pbanga ɔ̀nǎ rɔ̀, ndɨrɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀nǎ rɔ̀ màtɨ́. Ndɨrɔ̀, yà Yěsù rɨ̌’ɨ̀ nà Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ náaránà kàbhʉ rɔ̌ rɨ̀gʉ̌ andɨ nà alɛ fɨ̀yɔ́ andɨ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nɨ́rɔ̀ nɨ́ ndɨ ìndrǔ níiwú ngbɔ̌na ʉ́vɛ atdí alɛ nà ótdù dɔ̌ ɨ̀ ànɔ̀ rɔ́rɔ̀. Abádhí ambɛ́nà dhu ɔ̀nzɨ̀ dɔ̌ ɨdza ɨ̀ itsu tɨ́ ka, ’àdʉ̀ ɨ̀lɨnà Yěsù-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pbɛ́tʉ̀, abádhí rɨ̌ kìtsǔ tɨ́ ányɨ̀-dza dhu nɨ́ɨ’ɨ̀ ɔbɨ tɨ́, ihé-yà-okú dɔ̀ rɔ̀. Nɨ́, abádhí núupò kà nà ɨdza dɔ̀, ’àdʉ̀ ɨdza dɔ̀-tsirɔ̀ nʉ́ngbɛ, ’ìfo wɔ̀ alɛ pbɨ̀ndà ótdù mànà imbi rɔ̌ ɔ̀ná, ’àdʉ̀ ɨ̀lɨnà ihé-yà nzínzì ɔ̌ Yěsù-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nɨ́, Yěsù itdègu kɔ̀rɨ́ alɛ rɨ̌’ɨ̀ nà a’uta nálǎ, nɨ́ kǎdʉ̀ àtɨ̀nà wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: «Yà alɛ́, pbʉ̀kʉ̀ nzɛ́rɛnga nʉ́bà wà ndɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nɨ́, Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà náadʉ̀ òko ’àmbɛ ɨnga nɨ́rɛ̀ dɔ̌ afíya ɔ̀, ’àmbɛ àtɨ̀nà dɔ̌: «Ádhɨ pbá alɛ wɔ̀ wɔ̀ dhu bhěyi rɨ́ dhu ʉ̀nɔ nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌? Ádhɨ ndɨ ìndrǔ tɔ́ nzɛ́rɛnga nʉ́bà rádʉ̀ ɨnzá nɨ́ Kàgàwà kɛ̀lɛ̌ atdírɔ̀ nʉ́bà ka rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nɨ́, Yěsù asʉ̀ abádhí tɔ́ ɨrɛ̀ta, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɨ́’ɨ̀ wɔ̀rɨ́ ɨrɛ̀ta-tɨdɔ̀ nà afíkʉ ɔ̀ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ádhu ndɨ ɨsɔ́ rɔ́’ɔ ʉ̀nɔna ka kɨ́ rɔ̀? Tɨ́ katɨ: ‹Pbʉ̀kʉ̀ nzɛ́rɛnga nʉ́bà wà ndɨ̀›, ndɨrɔ̀ tɨ́ katɨ: ‹Ɨ́và nyɨ, nyubhi?› ");
INSERT INTO niy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pbɛ́tʉ̀ ma mòzè nyʉ̌nɨ dhu ìnè Ìndrǔ t’ídhùnà ràrɨ̌’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà yà adzɨ dɔ̌, ndʉ̀bà ìndrǔ tɔ́ nzɛ́rɛnga.» Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ àtɨ̀nà wɔ̀ ngbɔ̌na ʉ́vɛ alɛ nɨ̌: «Ma mátɨna ɨnyɨ nɨ̌: ‹Ɨ́và nyɨ, nyitdù ɨndʉ́ ótdù, nyadʉ̀ àrà pbʉ̀kʉ̀!›» ");
INSERT INTO niy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀rɨ́ alɛ nɨ́ɨvà ndɨ̀ ndìdè, kɔ́rɔ́ alɛ-ɔ̀nzɨ̌, ndàdʉ̀ yà ndɨ̀ ka kànɔ̀nà dɔ̀ná ótdù nídyì, ndàdʉ̀ àrànà pbɨ̀ndà Kàgàwà nílè rɔ̌ ndɨ̀ ndárà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nɨ́ kɔ́rɔ́ alɛ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. Abádhí ambɛ́nà Kàgàwà nílè dɔ̌ atdídɔ̌, ùlè tɨ́ ɨ̀ ùlè ɔdɔ nɨ̌ rɔ́rɔ̀, ’àdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Indo mǎ màla dhu nɨ́ ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ dhu!» ");
INSERT INTO niy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wɔ̀ dhu-dzidɔ̌, Yěsù ahʉ̀ ɨdza rɔ̀, ndàdʉ̀ pàratà tɔ́ atdí ndɔmbɛ̀, Lawì tɨ́ kátɨna nála pàratà t’ʉ́fɔ́tá tɔ́ bɨ̀rɔ ɔ̌ àdɨ rɔ́. Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ́rà owùdu ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nɨ́ Lawì adʉ̀ ndɨ̀và, ndʉ̀bhà kɔ́rɔ́ fɔná ɨ̀’ɨ̀ dhu-tsí, ndàdʉ̀ àrà kǒwù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wɔ̀ dhu-dzidɔ̌, Lawì adʉ̀ ádrʉ̀ngbǎ mʉ̀hɛndʉ̀ nɔ́nzɨ̀ Yěsù tɔ̀ pbɨ̀ndà dzá. Ányɨ̀-dzá, abádhí nɨ́ɨ’ɨ̀ ɔ̀nyʉ̀-tsʉ̀nǎ atdíkpá pàratà t’ʉ́fɔ́tá tɔ́ ibí pbàndɔ́mbɛ́ mànà, ndɨrɔ̀ ngʉ̌kpà alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nɨ́, Pbàfàrìsáyó mà, fɨ̀yɔ́ Ʉyátá tɔ́ màlímó mànà náambɛ́nà ònu dɔ̌ nzínzìya ɔ̌. Nɨ́, abádhí ivú dhu Yěsù bhà ábhàlɨ̌-tsʉ̌ ’àtɨ: «Ádhu nyɨ̌ nyɨ́ dhu ɔ̀nyʉ, nyǎdʉ̀ dhu ɔ̀mvʉ̀ atdíkpá pàratà t’ʉ́fɔ́tá tɔ́ pbàndɔ́mbɛ́ mà, ndɨrɔ̀ nzɛ́rɛngatálɛ mànà nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀mbǎ rɨ́’ɨ̀ andɨ nà alɛ náarɨ́ nzɨ̌ mʉ̀ngangà-atdyú nóho. Pbɛ́tʉ̀ kǎtdyú òho arɨ́ nɨ́ andɨ nà rɨ́’ɨ̀ alɛ kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma mɨ́rà nzá ídzì alɛ núnzì. Pbɛ́tʉ̀, ma mɨ́rà ùnzìnà nɨ́ nzɛ́rɛngatálɛ, ndɨ́nɨ̌ ɨ̀ nʉgɛ̀rɛ̀ tɨ́ ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga.» ");
INSERT INTO niy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wɔ̀ dhu-dzidɔ̌, Pbàfàrìsáyó mà, nzínzìya ɔ̌ Ʉyátá tɔ́ màlímó mànà náatɨ Yěsù nɨ̌: «Bàtizò núbhǒ arɨ́ Yùwanɨ̀ bhà ábhàlɨ̌ mà, fàká ábhàlɨ̌ mànà náarɨ́ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ, ’àdʉ̀ àmbɛ ’ɨ̀tsɔ̀ dɔ̌ àpàpɨ̀. Pbɛ́tʉ̀, pbʉ̀kʉ̀ ábhàlɨ̌ kɛ̀lɛ̌ náarádʉ̀ òko ’àmbɛ dhu ɔ̀nyʉ̀ dɔ̌, ’àdʉ̀ àmbɛ dhu ɔ̀mvʉ̀ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ nyɨ̀rɛ̀ tɨ́ dhu nyɨ̌ ràrǎdʉ̀ àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀ ìwǔ alɛ nágo ɔbɨ nɨ̌ ɨ̀nzɨ̌ ɔ̀nyʉ̀ nɔnyʉ tɨ́, àzèmbè ìnè ɨ̀ nɨ́’ɨ̀ atdíkpá akpa-tsi mànà ɔ̀ná kàsʉmɨ̀ ɔ̌? ");
INSERT INTO niy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pbɛ́tʉ̀, ɨdhɔ nɨ́ɨ’ɨya ìnè, yà akpa-tsi nɨ́và ka kɨ́ abádhí nzínzì ɔ̌ rɔ̀ ɔ̀ná. Ɨ ɨdhɔ ɔ̌ nɨ́ ndɨ, abádhí nʉ́ʉtsɨya ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yěsù adʉ̀ yàrɨ́ mbólí náwɛ átɔ̀ abádhí tɔ̀. Kǎtɨ: «Ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ kɛ̀lɛ̀mʉ̀ tɨ́ ndɨ̀ ndɨ́lɨ̌na dhu nɨ́fa mbɛrʉ̀-ɔwʉ́tá ɔ̌ rɔ̀, ndàdʉ̀ àpbanà mbɛrʉ̀-ayɨ́ ɔ̌. Kǎpɛ kɔ̀nzɨ ndɨ dhu bhěyi, nɨ́ rǎdʉ̀ ndɨ mbɛrʉ̀-ɔwʉ́tá nɨ́nza ɨ̀nzǎ tɨ́. Ndɨrɔ̀, ndɨ kɛ̀lɛ̀mʉ̀ mà rɨ̌ nzɨ̌ àdʉ̀ ɨ̀ àkɔ mbɛrʉ̀-ayɨ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ndɨrɔ̀, ɨ̀nzɨ̌ ka kádʉ̀ dɨ̀vayì-ɔwʉ́tá nʉ́dhɔ andu-ayɨ́ ɔ̀, akyɛ ndɨ dɨ̀vayì nɨ́ɨvʉ̀na ɨ andu-ayɨ́ ɔ̀, ràdʉ̀ ɨ andu nɔ́trɛ̀, ndɨ dɨ̀vayì ràdʉ̀ ndʉ̀fʉ̀ obvò nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nɨ́rɔ̀, dhu ɔ̀fɔ̀ nga kʉdhɔ dɨ̀vayì-ɔwʉ́tá andu-ɔwʉ́tá ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ndɨrɔ̀, ɨ̀nzɨ̌ dɨ̀vayì-ayɨ́ nɔ̀mvʉ̀ alɛ rǎdʉ̀ ndòzè ndɔ̀mvʉ̀ dɨ̀vayì-ɔwʉ́tá tdɨ́tdɔ̌, kà rǎdʉ̀ àtɨ̀nà dɨ̀vayì-ayɨ́ ràrɨ̌ ndɨ òvòvù nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Atdíku, sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náakò ’àmbɛ owu dɔ̌ nganʉ̀ tɔ́ ɨnga ɔ̀na nǎ ʉ́dà otu ɔ̌. Nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀ ’òwù otu-igì dɔ̌ rɨ́’ɨ̀ nganʉ̀ náfà rɔ̌, ’àdʉ̀ òwu ɨ̀nyɨ̀nà rɔ̌ ɔtsʉ́ya-tsírɔ́, ’àdʉ̀ kpɔ̌na nʉ́ka. ");
INSERT INTO niy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nɨ́, ngúfe Pbàfàrìsáyó náadʉ̀ dhu ìvu Yěsù bhà ábhàlɨ̌-tsʉ̌ ’àtɨ: «Ádhu nyɨ̌ nyɨ́ ɨnzá àlɛ̌ tɔ́ Ʉyátá návi kɔnzɨ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌ dhu nɔ́nzɨ nɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nɨ́, Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyàpɛ̀ tɨ́ obhó Dàwudì anzɨ̀ atdíku, àwù nà ɨ̀ ɨ́’ɨ̀ rɔ̀ná alɛ mànà rɔ̀ dhu nɔ́zʉ̀? ");
INSERT INTO niy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Àbadhi náatsù Kàgàwà bhà ɨdza, ndàdʉ̀ pɛrɛ̀ tɨ́ ka kùbho Kàgàwà tɔ̀ mʉ̀gatì núgù ndɔ̀nyʉ̀. Kǎdʉ̀ kʉ̀bhà átɔ̀ rɔ̀ná alɛ tɔ̀, àzèmbè àlɛ̌ tɔ́ Ʉyátá nóongó àtɨ̀nà ndɨ mʉ̀gatì ɔ̀nyʉ̀ rádʉ̀ ràrɨ̌ pbàkùhánɨ́ kɛ̀lɛ̌ vǐya dɔ̌ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Ìndrǔ t’ídhùnà, nɨ́ sàbatʉ̀-ɨdhɔ̀ dɔ̌ ádrʉ̀ngbǎlɛ.» ");
INSERT INTO niy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngǎtsi nɨ́nganɨ́ sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù náatsù unduta-dzà ɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ìndrǔ tɔ̀. Nɨ́, atdí alɛ, fangà tɔ́ ɔtsʉ́na ótsù nɨ́ɨ’ɨ̀ ányɨ̀-dzá. ");
INSERT INTO niy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nɨ́ Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà náambɛ́nà Yěsù nándà dɔ̌ atdyúya nyʉ́ nà, ndɨ́nɨ̌ ɨ̀ ala tɨ́ kàrà tɨ́ àdʉ̀ wɔ̀ alɛ nɨ́gʉ̌ ɨ̀gʉ̌ sàbatʉ̀-ɨdhɔ̀ ɔ̌. Obhó tɨ́, abádhí azè ’àbà kɔ̀bhʉ̀ ɨ̀ ádʉ̀ dɔ̀ná dhu. ");
INSERT INTO niy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pbɛ́tʉ̀, Yěsù nʉ́ʉnɨ abádhí rɨ̌rɛ̀na dhu. Nɨ́, kǎdʉ̀ àtɨ̀nà wɔ̀ ɔtsʉ́na ótsù alɛ nɨ̌: «Ɨ́và nyɨ, nyidè ndɔrɔ́ kɔ́rɔ́ alɛ-ɔ̀nzɨ̌.» Nɨ́, wɔ̀ alɛ adʉ̀ ndɨ̀và, ndìdè wɔ̀ Yěsù ɨ̀tɛ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ dhu nívǔ tsʉ̀kʉ́: àlɛ̌ tɔ́ Ʉyátá návi tɨ́ àvǐ kɔnzɨ̀ ídzì dhu mà, ndɨrɔ̀ ngǎtsi nɨ̌ kɔnzɨ̀ nzɛ́rɛ dhu mà ìndrǔ tɔ̀? Ndɨrɔ̀, kǎvi tɨ́ àvǐ kɨgʉ̌ ìndrǔ bhà ípìrɔ̌nga, ndɨrɔ̀ ngǎtsi nɨ̌, kʉbhà ndɨ alɛ rɔ̀vɛ̀?» ");
INSERT INTO niy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wɔ̀ dhu-dzidɔ̌, Yěsù andà kɔ́rɔ́ kɔ̀rɨ́ alɛ dɔ̀ nga, ndàdʉ̀ àtɨ̀nà wɔ̀ ɔtsʉ́na ótsù alɛ nɨ̌: «Ɨ́gba ɔtsʉ́nʉ!» Wɔ̀ alɛ náadʉ̀ ɔtsʉ́na nɨ́gbà: ndɨ ɔtsʉ́na ràdʉ̀ ndàto, ndɔ̀gʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pbɛ́tʉ̀, abádhí náakó atdídɔ̌, ’àdʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ nzínzìya ɔ̌, àdhu mà àkǎ ɨ̀ rɔ̀nzɨ̀ Yěsù-rɔ̌ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Atdíku Yěsù núupò pbìrì dɔ̀, ndàrà ndɨ̀tsɔ̀. Nɨ́, kǎdɨ̀ ányɨ̀, ndɨ̀tsɔ̀ ndɨ̀ kurà Kàgàwà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nɨ́ ɨnga núbho rɔ̀, Yěsù núunzi pbɨ̀ndà ábhàlɨ̌, ndàdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà alɛ nóvò nzínzìya ɔ̌ rɔ̀. Kǎdʉ̀ abádhí ɔvɔ̀ nɔ́vɔ̀ uvitatálɛ tɨ́. Yàrɨ́ nɨ́ ndɨ ɨ alɛ-ɔvɔ̀: ");
INSERT INTO niy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sìmonì, yà Yěsù adʉ̀ ɔvɔ̀na nɔ́vɔ̀ átɔ̀ Pɛ́tɛrʉ̀ tɨ́ mà, adɔ̀nà Àndɛ̀rɛyà mànà. Yàkɔbhɔ̀ mà Yùwanɨ̀ nà. Fìlipò mà Bàrtɔ̀lɔ̀mayò nà. ");
INSERT INTO niy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Màtayò mà, Tʉ̀masɨ̀ nà. Yàkɔbhɔ̀, Àlʉ̀fayò t’ídhùnà mà, Sìmonì, yà atdídɔ̌ ndɨ̀ nugyénà fɨ̀yɔ́ pbìrì dɔ̌ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudhà, Yàkɔbhɔ̀ t’ídhùnà mà, Yudhà Ìskàrìyɔtà, yà Yěsù nipfo ndàbhʉ òmvǔ-fɔ́ mànà. ");
INSERT INTO niy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wɔ̀ dhu-dzidɔ̌, Yěsù mà, pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà uvitatálɛ mànà náawú pbìrì dɔ̀ rɔ̀, ’ìwǔ ùvò kyɛ̀ngyɛ̀rʉ̀ dɔ̌, yà ábhɔ̌ ngʉ̌kpà pbɨ̀ndà ábhàlɨ̌ rɨ̌’ɨ̀ rɔ́. Ányɨ̀rɔ̌, ábhɔ̌ ihé-yà nɨ́ɨ’ɨ̀ átɔ̀. Ɨ alɛ níiwú Yùdɛyà tɔ́ pbìrì ɔ̀ rɔ̀, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, ndɨrɔ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀-bɨdɔ̌ arɨ́’ɨ̀ kɨgɔ̀, Tirò mà Sìdɔnà nà tɨ́ kátɨna ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Abádhí níiwú, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ Yěsù rʉ̌nɔna dhu, ndɨrɔ̀, ndɨ́nɨ̌ kɨ̌gʉ́ tɨ́ nzínzìya ɔ̌ rɨ́’ɨ̀ andɨ nà alɛ. Nɨ́ Yěsù adʉ̀ abádhí nzínzì ɔ̌ nzɛ́rɛ-alafí náarávu rɔ̀yá alɛ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kɔ́rɔ́ alɛ, yà andɨ nà rɨ́’ɨ̀, nóowúnà ’òzè rɔ̌ ’àpbàlǎ Yěsù-ngbɔ̀. Obhó tɨ́, kà-nyʉtsì rɔ̀ ráhʉ ádrʉ̀ngbǎnga tɔ́ ɔbɨ náaránà kɔ́rɔ́ alɛ nɨ́gʉ rɔ̌ fɨ̀yɔ́ andɨ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ dɔ̀ nga àndà, ndàdʉ̀ àtɨ̀nà ɨ ábhàlɨ̌ nɨ̌: «Nyɨ̌ nyɔ̀nzɨ̀ wà hirò yà nǎkʉ̀ tɨ́ nyɨ̌ nyɨ́’ɨ̀ rɔ̀, Kàgàwà nɔ́ɔnyʉya idzi dʉ̀kʉ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nyɨ̌ nyɔ̀nzɨ̀ wà hirò yà àwù nà nyɨ̌ nyarɨ́’ɨ̀ kòmbí rɔ̀, nyɨ̌ nyulèya ɔ̀nyʉ̀ nɨ̌ nɨ́dhunɨ̌. Nyɨ̌ nyɔ̀nzɨ̀ wà hirò yà nyɨ̌ nyarɨ́ ɔ̀dzɨ kòmbí rɔ̀, nyɨ̌ nyokoya ʉgbɔ́tá ɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nyɨ̌ nyɔ̀nzɨ̀ wà hirò yà ìndrǔ nɔ́ndrɔ̀ nyɨ̌, ’àdʉ̀ nyǐtu nzínzìya ɔ̌ rɔ̀, ’àdʉ̀ òwu dhu ʉ̀nɔ̀ rɔ̌ nyɨ̌ nɨ̌, ndɨrɔ̀ ’àdʉ̀ òwu nyɔ̌zʉ̀ rɔ̌ nzɛ́rɛ alɛ tɨ́ Ìndrǔ t’ídhùnà-okú dɔ̀ rɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nyàbhʉ ɨdhɛ̀kʉ rɨ̀ka ndɨ̀, ndɨrɔ̀ nyɔ̀bhɛ̀ nyɨ̌ dhɛ̀dhɛ-okú dɔ̀ rɔ̀, fʉ̀kʉ́ pɛrɛ̀ nɨ́ɨ’ɨya ádrʉ̀ngbǎ nyʉ́ ɔ̀rʉ̀-akpà ɔ̀ nɨ́dhunɨ̌. Obhó tɨ́ wɔ̀ dhu bhěyi tɨ́ abádhí t’ábáya náavù pbànábí rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pbɛ́tʉ̀, nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, nyɨ̌ ònzìtálɛ tɨ́ rɔ̀, nyɨ̌ nyábà wà nyǎbhʉ̌ rɨ́ nyɔ̌nzɨ̀ hirò dhu nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ yà kòmbí nyɨ̌ nyarɨ́’ɨ̀ ɔ̀nyʉ̀ nà abhàbhɔ́ rɔ̀, nyɨ̌ nyokoya àwù nà nɨ́dhunɨ̌. Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌, yà kòmbí nyɨ̌ nyarɨ́ òko ʉgbɔ́tá ɔ̌ rɔ̀, nyɨ̌ nyokoya ɨzʉ ɔ̌, ndɨrɔ̀ nyǎdʉ̀ àmbɛ ɔ̀dzɨ dɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ yà kɔ́rɔ́ alɛ náarɨ́ nyǐlè rɔ̀, ndɨ dhu bhěyi tɨ́, abádhí t’ábhúya níilè tɨ̀tɔ̀ tɔ́ pbànábí nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Pbɛ́tʉ̀, nyɨ̌ yà nyɨ̌ nyɨ́ ma mʉ́nɔna dhu nɨ́rɨ rɔ̀, ma mátɨna nyɨ̌ nɨ̌: Nyòzè fʉ̀kʉ́ òmvǔ. Nyɔ̀nzɨ ídzìnga yà nyɨ̌ nɔ́ndrɔ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nyàso nyǒfù arɨ́ alɛ. Ndɨrɔ̀, nyɨ̀tsɔ̀ nyɨ̌ nyʉ̌dhʉ̌ arɨ́ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Atdí alɛ náapɛ́ atdídhená bɨnʉ-bhu nɔ́pbɨ, nɨ́ ágɛ̀rɛ̌ ngǎtsi kà rɔ̀pbɨ̀ átɔ̀. Ndɨrɔ̀, atdí alɛ náapɛ́ pbʉ̀kʉ̀ ɔrʉ́ mʉ̀dzarʉ̀ nídyì, nɨ́ àpɛ́ nyúvǒ nyɨ ɨ̀nzɨ̌ kà rìdyì pbʉ̀kʉ̀ sìmisì átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dhu nònzì fʉnʉ́ alɛ tɔ̀ dhu àkǎ nyarà ndɨ dhu àbhʉ rɔ̌. Ndɨrɔ̀, atdí alɛ náapɛ́ ɨndʉ́ dhu nídyì, nɨ́ dhu àkǎ nzá nyʉdyɔ̌ ka. ");
INSERT INTO niy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ɔ́nzɨ dhu ngʉ̌kpà alɛ tɔ̀ àdhàdhɨ̀ nyɨ nyózè abádhí rɔ̀nzɨ̀ ka ɨndʉ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nyɨ̌ nyapɛ́ yà nyɨ̌ nózè alɛ kɛ̀lɛ̌ nózè, nɨ́ nyɨ̌ nyɨ̀rɛ̀ tɨ́ nga nyɨ̌ ràrǎdʉ̀ ídzìnga nábà àbà? Nzɛ́rɛngatálɛ mà nózè yà ɨ̀ nózè alɛ átɔ̀! ");
INSERT INTO niy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndɨrɔ̀ nyɨ̌ nyapɛ́ ídzìnga nɔ́nzɨ yà fʉ̌kʉ̀ arɨ́ kɔ̀nzɨ alɛ tɔ̀ tɨ́, nɨ́ nyɨ̌ nyɨ̀rɛ̀ tɨ́ nga nyɨ̌ ràrǎdʉ̀ ídzìnga nábà àbà? Nzɛ́rɛngatálɛ mà náarɨ́ dhu ɔ̀nzɨ átɔ̀ ndɨ dhu bhěyi tɨ́! ");
INSERT INTO niy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nyɨ̌ nyapɛ́ dhu ʉ̀wʉ̌ yà nyɨ̌ nyà’ù ndɨ dhu àdu rádʉ̀ fʉ̌kʉ̀ alɛ tɔ̀ tɨ́, nɨ́ nyɨ̌ nyɨ̀rɛ̀ tɨ́ nga nyɨ̌ ràrǎdʉ̀ ídzìnga nábà àbà? Nzɛ́rɛngatálɛ mà átɔ̀ náarɨ́ dhu ʉ̀wʉ̌wʉ̌ yà fɨ̌yɔ̀ rádʉ̀ kàdu alɛ tɔ̀! ");
INSERT INTO niy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pbɛ́tʉ̀ nyɨ̌, nyòzè fʉ̀kʉ́ òmvǔ, nyǎdʉ̀ ídzìnga nɔ́nzɨ̀ fɨ̌yɔ̀. Ndɨrɔ̀, nyàdʉ̀ nyʉ̀wʉ dhu ìndrǔ tɔ̀, ɨnzá nyɨ̌ nyɨ̀rɛ̀ nga abádhí rǎdǔna fʉ̌kʉ̀ dhu dɔ̌ rɔ́rɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ, nyɨ̌ nyabáya ádrʉ̀ngbǎ pɛrɛ̀. Ndɨrɔ̀ Kàgàwà, yà kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ alɛ náanziya nyɨ̌ pbɨ̀ndà inzo tɨ́. Obhó tɨ́, kǎrɨ́ ídzìnga nɔ́nzɨ yà ɨ̀nzɨ̌ arɨ́ fɨ̌yɔ̀ ka kɔ̀nzɨ̀ dhu tɔ́ ídzìnga nʉ́nɨ̌ alɛ tɔ̀, ndɨrɔ̀ nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ alɛ tɔ̀ màtɨ́ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nyàvi fʉ̀kʉ́ ídzìnga ìndrǔ tɔ̀, àdhàdhɨ̀ Àbakʉ Kàgàwà náarɨ́ kàvǐ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Dhu àkǎ nzá nyʉ̌nɔ̀ ìndrǔ-ànyǎ, akyɛ Kàgàwà náaraya ànyǎkʉ ʉ̀nɔ̀ nɨ̌. Dhu àkǎ nzá nyɨ̌tdɨ̀ anya ìndrǔ dɔ̌, akyɛ Kàgàwà náaraya anya ɨ̀tdɨ̀ dʉ̀kʉ́ nɨ̌. Dhu àkǎ nyʉ̌bà dhu ìndrǔ tɔ̀, ndɨ́nɨ̌ Kàgàwà náadʉ̀ya tɨ́ dhu ʉ̀bà fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dhu àkǎ nyǎbhʉ fʉkʉ́ rɨ́’ɨ̀ dhu ìndrǔ tɔ̀, ndɨ́nɨ̌ Kàgàwà adʉ̀ya tɨ́ dhu àbhʉ fʉ̌kʉ̀. Ka kɨtrɔ̀ya dhu fʉ̀kʉ́ ɨ́sɔ̀wʉ̌ ɔ̀ ídzì mʉ̀gɛ̀rɛ̀ ɔ̌, ràlè, ròyì ndɨ̀, kadʉ̀ òsònà, kape, kadʉ̀ ɨ̀ranà mběyi nyʉ́. Obhó tɨ́, ka kudhèya dhu fʉ̌kʉ̀ àdhàdhɨ̀ yà nyɨ̌ nyarɨ́ dhu núdhě ngʉ̌kpà alɛ tɔ̀ ɔ̀ná mʉ̀gɛ̀rɛ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yěsù adʉ̀ yàrɨ́ mbólí ʉ̀nɔ̀ átɔ̀ abádhí tɔ̀, ndàtɨ: «Atdí ndùmùndúmú t’ádʉ̀ ngǎtsi ndùmùndúmú nʉ́ndà ʉ̀nda? Ɨ̀nzɨ̌ akɛkpá màtɨ́: abádhí rǎdʉ̀ ’àwà ɔ́yɔ̌ kɔ́rɔ́ ibhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɨ̀nzɨ̌ atdí ábhàlɨ̌ bhà ɨrɛ̀ta mà náaróse pbɨ̀ndà màlimò bhà ɨrɛ̀ta dɔ̀nǎ. Pbɛ́tʉ̀, mběyi ka kùdhe dhu fɨ̌ndà ábhàlɨ̌ bhà ɨrɛ̀ta rǎdʉ̀ àkǎkǎ pbɨ̀ndà màlimò bhà ɨrɛ̀ta nà. ");
INSERT INTO niy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ádhu nyɨ nyádʉ̀ nyozè nyala ɔdhɨ̀nʉ-nyɨ̀kpɔ́ ɔ̀ ɨ̀tsɨ̀ kɨ̌kɔ̌-ngba kɛ̀lɛ̌, ɨ̀nzɨ̌ nyadʉ̀ nyɨ̀kpɔ́nʉ ɔ̀ ɨ̀tsɨ̀ itsukpó-tsʉ̀dɔ́-ngba nyʉ́ nínè nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nyɨ nyádʉ̀ àtɨ̀nà ɨ̀ngbà dhu bhěyi ɔdhɨ̀nʉ nɨ̌: ‹Ɔdhɨ́, ítsè midyi nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ kɨ̌kɔ̀,› àzèmbè nyɨ nyongó ɨ̀’ɨ̀ ɨ̀nzɨ̌ nyɨ nyɨ́ nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ itsukpó-tsʉ̀dɔ́-ngba nyʉ́ nínè rɔ́? Ɨnyɨ, ɔyɔyɔ ɨdàna nà alɛ́, ídyì pɛ́ nyɨ̀kpɔ́nʉ ɔ̀ rɨ́’ɨ̀ itsukpó-tsʉ̀dɔ́-ngba angyi, ndɨrɔ̀ nɨ́ ndɨ nyɨ nyádʉ̀ ɔdhɨ̀nʉ-nyɨ̀kpɔ́ ɔ̀ rɨ́’ɨ̀ kɨ̌kɔ̀ nídyì nyɨ nyɨ́ tɨ́ dhu nála mběyi.» ");
INSERT INTO niy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Ɨ̀nzɨ̌ ídzì itsu-tɨdɔ̀ rǎdʉ̀ nzɛ́rɛ itsu-kpɔ̌ nɨ́’ɔ. Ndɨrɔ̀, ɨ̀nzɨ̌ nzɛ́rɛ itsu-tɨdɔ̀ rǎdʉ̀ ídzì itsu-kpɔ̌ nɨ́’ɔ. ");
INSERT INTO niy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kɔ́rɔ́ itsu-tɨdɔ̀ nʉ́nɨ̌ ka karɨ́ kpɔ̌na nyʉ́ rɔ̌. Ɨ̀nzɨ̌ ka kádʉ̀ mùtinì-kpɔ̌ nɔ́pɛ̀ ɨlɛ́ dɔ̌, ndɨrɔ̀ ɨ̀nzɨ̌ ka kádʉ̀ vǐnyò-kpɔ̌ nɔ́pɛ̀ okpèna nà itsu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ídzì afína nà alɛ náafí ɔ̀ rɔ̀ aráhʉ dhu nɨ́ ídzì dhu. Ndɨrɔ̀, nzɛ́rɛ afína nà alɛ náafí ɔ̀ rɔ̀ aráhʉ dhu nɨ́ nzɛ́rɛ dhu. Alɛ-tsʉ̀ náarɨ́ òrìna dhu nɨ́ alɛ-afí rǔbhi ɨ̀rɛ̀nà rɔ̌ atdídɔ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ádhu nyɨ̌ nyárɨ́ mɨtdɛ̀, nyǎmbɛ àtɨ̀nà dɔ̌: ‹Ádrʉ̀ngbǎlɛ! Ádrʉ̀ngbǎlɛ́›, ɨ̀nzɨ̌ nyǎdʉ̀ ma mʉ́nɔna fʉ̌kʉ̀ dhu ɔ̀nzɨ̀ nɨ́? ");
INSERT INTO niy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma mɨ́ pɛ́ tɨdu ɔ̀ rɨ́rà alɛ, ndɨ̀rɨ̀ ma mʉ́nɔna dhu, ndàdʉ̀ ndɨ dhu ɔ̀nzɨ̀, nɨ́ rǎdʉ̀ ndɔ̀fɔ̀ nà alɛ nɨ́tɛ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ndɨ alɛ nɨ́lɨ ndɨ̀ yà pbɨ̀ndà ɨdza napɛ̀ ndɔ̀sɨ̀ alɛ bhěyi. Kǎgyè pbɨ̀ndà ɨdza-bhu mběyi nyʉ́ ndàrà ɨ̀sɨ̌ bhalabhala dɔ̌, ndàdʉ̀ ɨdza-pfɔ̀ nɔ́rʉ̀ ndɨ bhalabhala dɔ̌. Nɨ́, igye nɨ́kɔ̌, ɨdha rùtǔ nɨ̌ rɔ̀, ɨdha náakpà ndɨ ɨdza-pfɔ̀, ɨ̀nzɨ̌ ngbɔ̌na mà ràdʉ̀ ndàyà, mběyi nyʉ́ ka kasɨ̀ ndɨ ɨdza nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pbɛ́tʉ̀, ma mʉ́nɔna dhu nɨ́rɨ rɨ́, ɨ̀nzɨ̌ ndàdʉ̀ ndɨ dhu nɔ́nzɨ̀ alɛ, nɨ́lɨ ndɨ̀ yà adzɨ-vǐ ɔ̌ pbɨ̀ndà ɨdza nasɨ̀ ɨnzá ndɨ̀ ndògyè bhǔna rɔ́rɔ̀ alɛ bhěyi. Igye nɨ́kɔ̌, ɨdha rùtǔ nɨ̌ rɔ̀, ɨdha náakpà ndɨ ɨdza-pfɔ̀, ràdʉ̀ ndùgòlò ányɨ̀rɔ̌ rɔ̀ tɨ́, ràdrù ndɨ̀ atdídɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yěsù níitdègu yà ndɨ̀ ndúbhi ʉ̀nɔ̀nà rɔ̌ ìndrǔ tɔ̀ dhu t’ʉ́nɔta nɨ́tɔ, nɨ́ kǎdʉ̀ àrà Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ányɨ̀, Pbàrɔ́má tɔ́ pbìrì ɔ̌ atdí mɨyà pbànówí dɔ̌ ádrʉ̀ngbǎlɛ bhà kasʉtálɛ nɨ́ɨ’ɨ̀ afína rɔ̌ ka kɔ́dɔna rɔ́. Ndɨrɔ̀ ndɨ kasʉtálɛ nɨ’ɨ̀ atdídɔ̌ kǒzè. ");
INSERT INTO niy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nɨ́ wɔ̀ ádrʉ̀ngbǎlɛ níitdègu Yěsù dɔ̌ ka kʉ́nɔna dhu nɨ́rɨ, nɨ́ kǎvì Pbàyàhúdí nzínzì ɔ̌ ngúfe pbàkʉ̀rʉ̌ ròwù Yěsù nánzì, ndɨ́nɨ̌ ɨra tɨ́ pbɨ̀ndà kasʉtálɛ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kɔ̌kɔ̀ pbàkʉ̀rʉ̌ náawù ùvò Yěsù-tɨ’ɔ̀, ’àdʉ̀ ’ɔ̀pɛ̀ ’ɨ̀tsɔ̀ ɨ̀ atdídɔ̌ Yěsù rɔ̌, ’àtɨ: «Yà mǎ nìvì tɨnʉ ɔ̀ ádrʉ̀ngbǎlɛ nákǎ wà nyɔnzɨ̀ dzʉ̀nàna. ");
INSERT INTO niy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Àbadhi nózè tɨkàdɔ atdídɔ̌. Ndɨrɔ̀, ka nɨ́ ndɨ fàká unduta-dzà nábhʉ kɔsɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɨ́, Yěsù mà náadʉ̀ òwu atdíkpá kɔ̌kɔ̀ pbàkʉ̀rʉ̌ mànà. Nɨ́, ɨ́kyɛ̀rɔ̌ abádhí òkò wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ bhà ɨdza-li’ɔ̀ ɨ̀ owu tɨ́ ùvò rɔ́rɔ̀, ndɨ ádrʉ̀ngbǎlɛ náadʉ̀ ɔdhɨ́na nóvì ròwù dhu ʉ̀nɔ̀ Yěsù tɔ̀, ’àtɨ: «Pbànówí dɔ̌ ádrʉ̀ngbǎlɛ rǎtɨna nyɨ nɨ̌: ‹Ádrʉ̀ngbǎlɛ́, nzǐtǔ afínʉ! Ɨnzá ma mɨ̀lɨ ma nyɨ nyádʉ̀ òtsù pbɨ̀ndà ɨdza alɛ bhěyi.› ");
INSERT INTO niy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndɨ dhu-okú dɔ̀ rɔ̀ átɔ̀ nɨ́ ndɨ, ma màdɨnà ɨ̀nzɨ̌ marà ma-tɨ́rɔ̀ tɨnʉ ɔ̀. Pbɛ́tʉ̀, órì atdí dhu kɛ̀lɛ̌, nɨ́ pbàkà kasʉtálɛ rǎdʉ̀ ɔ̀gʉ̀ ɔ̀gʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ɨma nyʉ́, yà ma mɨ́’ɨ̀ rɔ̀, ma mɨ́’ɨ̀ ìnè dùdu-tsírɔ́ ádrɔ̀drɔ̌ alɛ nà. Ndɨrɔ̀, ma mɨ́’ɨ̀ ìnè ma marúvǐna pbànówí nà. Ma mapɛ́ àtɨna atdí mùnowì nɨ̌ ‹Árà!› Nɨ́ kà rǎdʉ̀ àrà. Ndɨrɔ̀ ma mapɛ́ àtɨna ngǎtsi nɨ̌ ‹Ɨ́rà!›, nɨ́ ndɨ tsí rǎdʉ̀ ɨ̀rà. Ndɨrɔ̀, ma mapɛ́ àtɨna pbàkà kasʉtálɛ nɨ̌ ‹Ɔ́nzɨ yà dhu!›, nɨ́ kà rǎdʉ̀ kɔ̀nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nɨ́ Yěsù níitdègu wɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ nʉ́nɔ̀ dhu ɨ̀rɨ, nɨ́ ɨdhɔ nʉ́ʉkɔ atdídɔ̌. Nɨ́, Yěsù adʉ̀ ndàgɛrɛ ndàtɨ yà owùna ɔ̌ rúbhi ìwu rɔ̌ ihé-yà nɨ̌: «Ma mátɨna nyɨ̌ nɨ̌: ɨnzá ma màpɛ̀ yà dhu bhěyi a’uta-tɨdɔ̀ nà alɛ nálǎ Pbàìsràyélí tɔ́ pbìrì ɔ̌ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kɔ̌kɔ̀ pbànówí dɔ̌ ádrʉ̀ngbǎlɛ nóvìnà Yěsù-tɨ’ɔ̀ ɔdhɨ́na níitdègu ’àdǔ, ’ìwǔ ùvò ɨdza, nɨ́ abádhí náatù wɔ̀ andɨ nà ɨ̀’ɨ̀nà kasʉtálɛ ɨwà ɔ̀gʉ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wɔ̀ dhu-dzidɔ̌, Yěsù náarà Nàyinà tɨ́ kátɨna pbanga ɔ̀. Kàbhà ábhàlɨ̌, ábhɔ̌ ihé-yà mànà náadʉ̀ kʉ̀ndà ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nɨ́, pbanga ɔ̀ kótsù rɔ́ kàrà àhʉ rɔ̀ nɨ́ ndɨ, ka kubhínà òwu rɔ̌ atdí abvo nà, ndɨ́nɨ̌ ka kowu tɨ́ ɔ̀tdʉ̀nà. Ndɨ abvo nɨ’ɨ̀ atdí tɨ́ arɨ́’ɨ̀ atdí abvo-àyi-fɔ́ ngbángba-abvò. Ndɨ pbanga ɔ̌ ábhɔ̌ alɛ nyʉ́ nɨ́ɨ’ɨ̀ atdíkpá ɨ̀ ówu ndɨ abvo-àyi mànà kàbhǔlì ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nɨ́ ka ndɨ̀ ndàla rɔ̀, Ádrʉ̀ngbǎlɛ Yěsù náabà ɨzʉ atdídɔ̌ kàdɔ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Nzɔ̌dzɨ iyá!» ");
INSERT INTO niy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nɨ́ kǎdʉ̀ ìndri ndàlʉ̌ ótdù-ngbɔ̀, ka nànɔ̀ alɛ ràdʉ̀ ìko. Nɨ́ Yěsù adʉ̀ àtɨ̀nà: «Mʉ̌lɛ̌-ngbá, ma mátɨna nyɨ nɨ̌: ɨ́và nyɨ.» ");
INSERT INTO niy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɨ́ wɔ̀ ɔ̀vɔ̀vɛ̀nà alɛ nɨ́ɨvà ndɨ̀, ndàdɨ sùnátù dɔ̌, ndàdʉ̀ ɔtɛ nɔ́pɛ̀. Nɨ́ Yěsù adʉ̀ kàdu ɨ́yànà-fɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wɔ̀ dhu-dzidɔ̌, ɔdɔ nɨ́ɨsɨ́ kɔ́rɔ́ alɛ ɔ̀. Nɨ́, abádhí níilè Kàgàwà, ’àdʉ̀ àtɨ̀nà: «Kàgàwà bhà ádrʉ̀ngbǎ Nabì náhʉ wà àlɛ̌-nzínzì ɔ̌, ndɨrɔ̀ Kàgàwà nɨ́rà ɨwà pbɨ̀ndà alɛ-kʉ̀mbà nɔ́nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wɔ̀ Yěsù ɔ̀nzɨ̀ dhu-ɔ̀yɨ̌ náadʉ̀ àkǎ kɔ́rɔ́ Yùdɛyà tɔ́ pbìrì ɔ̌, tɨná arɨ́’ɨ̀ ngʉ̌kpà pbanga mànà. ");
INSERT INTO niy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wɔ̀ dhu-dzidɔ̌, Yùwanɨ̀ bhà ábhàlɨ̌ náadʉ̀ wɔ̀ Yěsù ɔ̀nzɨ̀ dhu náwɛ kɔ́rɔ́ fɨ̀yɔ́ màlimò tɔ̀. Nɨ́, Yùwanɨ̀ náanzi ɔ́yɔ̌ alɛ abádhí nzínzì ɔ̌, ");
INSERT INTO niy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ndàdʉ̀ òvìnà ròwù dhu ìvu Ádrʉ̀ngbǎlɛ Yěsù-tsʉ̌ ’àtɨ: «Nyɨ tɨ́ yà mǎ marɨ́ ɔ̀dɔna, ndɨ́nɨ̌ ɨra tɨ́ alɛ? Ndɨrɔ̀ mǎ màkǎ tɨ́ mɔ̌dɔ̀ vurò alɛ?» ");
INSERT INTO niy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kɔ̌kɔ̀ Yùwanɨ̀ nívì alɛ níitdègu ìwu ùvò Yěsù-tɨ’ɔ̀, nɨ́ abádhí níivú dhu Yěsù-tsʉ̌ ’àtɨ: «Bàtizò núbhǒ arɨ́ Yùwanɨ̀ nívì mǎ mǐwǔ dhu ìvu tsʉ̀nʉ́, nyɨ ràtɨ́ yà mǎ marɨ́ ɔ̀dɔna, ndɨ́nɨ̌ ɨra tɨ́ alɛ, ndɨrɔ̀ mǎ ràkǎ tɨ́ mɔ̌dɔ̀ vurò alɛ?» ");
INSERT INTO niy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Yěsù nɨ́ɨgʉ́ ibí alɛ nyʉ́ fɨ̀yɔ́ andɨ mà, nzɛ́rɛ arɨ́ ɨ̀ ɔ̀nzɨ dhu mànà ɔ̌ rɔ̀. Kǎránà nzɛ́rɛ-alafí nípfo rɔ̌ ìndrǔ ɔ̀ rɔ̀, ndàdʉ̀ ibí ndùmùndúmú-nyɨ̀kpɔ́ nábhʉ rʉ̀ngbɛ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ dhu àdu Yùwanɨ̀ ìvìnà alɛ tɔ̀, ndàtɨ: «Nyòwu nyàwɛ yà nyɨ̌ nyálǎna dhu mà, yà nyɨ̌ nyɨ́rɨna dhu mànà Yùwanɨ̀ tɔ̀. Kà tɔ̀ nyɨ̌ nyáwɛ̌na dhu nɨ́: ndùmùndúmú-nyɨ̀kpɔ́ ràrǒwu ’ʉ̀ngbɛ rɔ̌, ’àdʉ̀ ɨnga àla. Òtsótsù alɛ ràrǒwu ʉ̀gʉ rɔ̌, ’àdʉ̀ ùbhi mběyi. Kɨ́kɨ́ nà alɛ ràrǒwu ʉ̀gʉ̌ rɔ̌, ìwǐ ràdʉ̀ òwu ɨnga nɨ́rɨ̀ rɔ̌. Ʉvʉ̌vɛ alɛ ràrǒwu ɨ̀kyɛ rɔ̌, ʉ̀tdʉ̌ ka kʉ̀tdʉ̌ alɛ ràdʉ̀ ’ʉ̀ngbɛ. Ndɨrɔ̀, nǎkʉ̀tálɛ ràrǒwu Ídzì Màkʉ̌rʉ̀ nɨ́rɨ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hirò nɔnzɨya alɛ nɨ́ yà ɨ̀nzɨ̌ rɨ́ ’àwà okúdu dɔ̀ rɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kɔ̌kɔ̀ Yùwanɨ̀ ìvìnà alɛ níitdègu ’ɨ̀và ’òwù, nɨ́ Yěsù adʉ̀ ndɔ̀pɛ̀ ndàwɛ dhu ihé-yà tɔ̀ Yùwanɨ̀ dɔ̌. Kǎpɛ̀ ndɔ̀ngʉ̀ dhu abádhí-tsʉ̌, ndàtɨ: «Ádhɨ nyɨ̌ nyawù àndànà rʉ̀ngʉ̀ ɔ̀? Tɨ́ awɛ rɨ̌ ɔ̀nánga nʉ́tdyǎ ízò? ");
INSERT INTO niy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ádhɨ nyʉ́ nyɨ̌ nyawù àndànà? Tɨ́ ɔrʉ́ odzìya nà mʉ̀dzarʉ̀ nàfɔ̌ alɛ? Pbɛ́tʉ̀, ɔrʉ́ odzìya nà mʉ̀dzarʉ̀ nʉ̀fɔ̌ alɛ, ’àdʉ̀ òko ònzì ɔ̌, nótù nyɨ̌ nyádʉ̀ ádrɔ̀drɔ̌ kámá-ɨdzà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nɨ́ ádhɨ nyʉ́ nyɨ̌ nyawù àndànà olu? Tɨ́ Kàgàwà bhà nabì? Obhó tɨ́, nyɨ̌ nyawù Kàgàwà bhà nabì nándà. Pbɛ́tʉ̀ ma mátɨna nyɨ̌ nɨ̌, ɨwà kà ròsè nabì dɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kǒkú dɔ̀ rɔ̀ nga nɨ́ ndɨ ka kandí dhu katɨ: ‹Kɔ̀nɨ̌ ma mòvì pbàkà mʉ̀kɛ̀ngyɛ̀ angyi ɨndʉ̀, ndɨ́nɨ̌ nyɨ nyʉ́bhi ɔ̀ná otu nɔbhɔlɔ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma mátɨna nyɨ̌ nɨ̌, yà tsìbhálɛ nyʉ́ nʉ́ʉgʉ yà adzɨ dɔ̌ alɛ nzínzì ɔ̌, Yùwanɨ̀ dɔ̀nǎ òsè alɛ rɨ̌’ɨ̀ mbǎ. Pbɛ́tʉ̀, yà ákɛ̌ alɛ tɨ́ ka kálǎna ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ alɛ, nósè wà Yùwanɨ̀ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yùwanɨ̀ rʉ̌nɔna dhu nɨ́rɨ̀ kɔ́rɔ́ alɛ, pàratà tɔ́ pbàndɔ́mbɛ́ mànà, náa’u Kàgàwà ózè ɨ̀ rɔ̀nzɨ̀ dhu, ’àdʉ̀ bàtizò àlʉ̌ Yùwanɨ̀-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pbɛ́tʉ̀, Pbàfàrìsáyó mà, Ʉyátá tɔ́ màlímó mànà náadhɔ̀ Kàgàwà òzè ’ɔ̀nzɨ̀ dhu. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, abádhí náadʉ̀ nzá ’òzè ’àlʉ̌ bàtizò Yùwanɨ̀-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yà indo arɨ́ alɛ nyʉ́ núdhe ma mádʉ̀ àdhà bhà rɔ̌? Abádhí nʉ́lɨ ɨ̀ àdhà bhà bhěyi? ");
INSERT INTO niy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Abádhí nʉ́lɨ ɨ̀ yà pbanga-tsidɔ̌ ɨ̀ nùndu nzónzo bhěyi. Atdídhená rǎdʉ̀ òwu ɔdhɨ́ya núnzì rɔ̌ ìkǔ ɔ̌, ’àtɨ: ‹Mǎ mʉ̀mɨ̀ mbǎ ɔbɛ́ tɔ́ adyi rʉ̀gɛ̌ ɔ̌ màtɨ́ fʉ̌kʉ̀, nɨ́ nyɨ̌ nyàdʉ̀ nzá ɔ̀bɛ̀. Ndɨrɔ̀, mǎ mʉ̀yʉ̀ mbǎ làngáyí tɔ́ adyi mà fʉ̌kʉ̀, nɨ́ nyɨ̌ nyàdʉ̀ nzá ɔ̀dzɨ.› ");
INSERT INTO niy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Obhó tɨ́, bàtizò nubhónà Yùwanɨ̀ nɨ́ɨra, ɨ̀nzɨ̌ ndàrà ɔ̀nyʉ̀ nɔ́nyʉ̀ rɔ̌, ɨ̀nzɨ̌ ndàdʉ̀ dhu mà nɔ́mvʉ̀. Nɨ́, nyɨ̌ nyadʉ̀ àtɨ̀nà, nzɛ́rɛ-alafí ràrɨ̌’ɨ̀ kà-ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ndɨ dhu bhěyi tɨ́, Ìndrǔ t’ídhùnà nɨ́rà, ndàrà dhu ɔ̀nyʉ̀ rɔ̌, ndàdʉ̀ dhu ɔ̀mvʉ̀. Nɨ́, nyɨ̌ nyarádʉ̀ kàtɨ̀ ɔ̀na óvò alɛ, ndɨrɔ̀ atdídɔ̌ arɨ́ ndɔ̀mvʉ̀ alɛ tɨ́. Ndɨrɔ̀, nyɨ̌ nyarádʉ̀ kàtɨ̀ pàratà tɔ́ pbàndɔ́mbɛ́ mà nzɛ́rɛngatálɛ mànà ɨ̀ nózè alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pbɛ́tʉ̀, dhu-ɔ̌nga t’óvòta tɔ́ obhónga náarɨ́ ndàvǐ kà-nyʉtsì rɔ̀ àhʉ dhu-otù ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Atdí Mʉ̀fàrɨ̀sayò náanzi Yěsù ’òwù dhu ɔ̀nyʉ̀ mànà pbɨ̀ndà. Nɨ́, Yěsù arà, ndòtsù kàbhà ɨdza, ndàdʉ̀ àdɨ ndàmbɛ dhu ɔ̀nyʉ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nɨ́ kòmbómbí tɨ́, ndɨ kɨgɔ̀ ɔ̌ nzɛ́rɛnga tɔ́ atdí tsìbhálɛ nɨ́ɨrɨ Yěsù rɨ̌ dhu ɔ̀nyʉ Mʉ̀fàrɨ̀sayò bhà ɨdzá rɔ̀ dhu. Nɨ́ kǎdʉ̀ ɨ̀rà àlʉ̀batrɔ̀ tɨ́ kátɨna odu nɨ̌ ka kɔ́bhɔ̀lɔ̀ tsúpà nà fɔná Yěsù-tɨ’ɔ̀. Ndɨ tsúpà ɔ̀ ɨ̀’ɨ̀ dhu nɨ́ ndrùù rɔ́ngʉ akyɛ. ");
INSERT INTO niy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nɨ́, kǐtsi ìde Yěsù tɨ́ olù nǎ rɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀dzɨ̀. Nɨ́ ɔ̀dzɨ ndɨ̀ ndɔ́dzɨ rɔ́rɔ̀, kǎdʉ̀ ndàgu ndàmbɛ Yěsù-pfɔ̀-ngbɔ̀ nɨ́mɔ dɔ̌ nyɨ̀na-dha nɨ̌, ndàdʉ̀ ùndonà dɔ̀na-ká nɨ̌. Tdɨ́tdɔ̌, kǎdʉ̀ Yěsù-pfɔ̀ námbo, ndàdʉ̀ ndrùù rɔ́ngʉ akyɛ nʉ́dhɔ dɔ̀yá. ");
INSERT INTO niy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nɨ́ wɔ̀ Yěsù nànzìnà ɔ̀nyʉ̀ tɔ̀ Mʉ̀fàrɨ̀sayò níitdègu wɔ̀ dhu nálǎ, náadʉ̀ ndɔ̀pɛ̀ ndàmbɛ àtɨ̀nà dɔ̌ afína ɔ̀: «Yàrɨ́ alɛ ɨ́’ɨ̀ná gukyè Kàgàwà bhà nabì nyʉ́ tɨ́, nɨ́ kàmbɛ̀nà pɛ́ wɔ̀ ngbɔ̌na nʉ́lʉ̌ rɨ́ tsìbhálɛ ràrɨ̌ àdhɨ dhu nʉ́nɨ̌. Kàmbɛ̀nà pɛ́ dhu nʉ́nɨ̌ ɨ́yàdhíyà ràrɨ̌ nzɛ́rɛnga tɔ́ tsìbhálɛ.» ");
INSERT INTO niy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nɨ́, Yěsù apɛ̀ ɔtɛ ndàtɨ wɔ̀ Mʉ̀fàrɨ̀sayò nɨ̌: «Sìmonǐ, ma mòzè mʉnɔ̀ atdí dhu ɨndʉ̀.» Nɨ́ Sìmonì adʉ̀ àtɨ̀nà: «Màlimǒ, ʉ́nɔ nà ndɨ dhu.» ");
INSERT INTO niy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nɨ́ Yěsù adʉ̀ àtɨ̀nà: «Atdí alɛ náabhʉ̀ fʉ̀rangà ɔ́yɔ̌ alɛ rʉ̀wʉ fɔná: atdí alɛ tɔ̀ kǎbhʉ̀ imbò mɨyà fʉ̀rangà-kpɔ̌, ndɨrɔ̀ ngǎtsi alɛ tɔ̀ kǎbhʉ̀ imbò kumì fʉ̀rangà-kpɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nɨ́ ɨ̀mbǎ kɔ̌kɔ̀ ɔ́yɔ̌ alɛ rɨ̌’ɨ̀ kɔ́rɔ́, wɔ̀ ɨ̀ ʉwʉ̀ fʉ̀rangà nádǔ ɨ̀’ɨ́ nɨ̌ fangà nà rɔ̀, wɔ̀ alɛ náadʉ̀ dhu ʉ̀bà ɔ́yɔ̌ kɔ́rɔ́ abádhí tɔ̀, ɨ̀nzɨ̌ rùbho fɨ̀yɔ́ wànzá. Nɨ́, ádhɨ ndɨ nyɨ nyʉ̀nɨ rɔ̀, kɔ̌kɔ̀ ɔ́yɔ̌ alɛ nzínzì ɔ̌ atdídɔ̌ rádʉ̀ wɔ̀ fʉ̀rangà nʉwʉ̀ fɨ̌ndà alɛ nózè?» ");
INSERT INTO niy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sìmonì adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ma mʉ̀nɨ rɔ̀, atdídɔ̌ rádʉ̀ wɔ̀ alɛ òzè alɛ nɨ́ yà ábhɔ̌ fʉ̀rangà tɔ́ wànzá ka kʉ̀bà fɨ̌ndà alɛ.» Nɨ́, Yěsù adʉ̀ àtɨ̀nà Sìmonì nɨ̌: «Nyɨ nyʉ̀nɔ̀ wà obhó dhu nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ ndàgɛrɛ, ndàndà wɔ̀ tsìbhálɛ, ndàdʉ̀ àtɨ̀nà Sìmonì nɨ̌: «Nyɨ nyàla tɨ́ wà wɔ̀ tsìbhálɛ, Sìmonǐ? Ándà, ma mìtsù pbʉ̀kʉ̀ ɨdza, nɨ́ nyɨ nyìbhò nzá alɛ-pfɔ̀ tɔ́ ɨdha mà idù. Pbɛ́tʉ̀, wɔ̀ tsìbhálɛ nú’o pfɔ̌du nyɨ̀na-dha nyʉ́ nɨ̌, ndàdʉ̀ ngbɔ̌na núndo dɔ̀na-ká nyʉ́ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nyɨ nyàmbǒnà nzá ɨma, nyɨ nyɨ́ makɔ̌ rɔ̀. Pbɛ́tʉ̀, yà pbʉ̀kʉ̀ ɨdza ma mìtsùnà rɔ̀, ɨ́yàdhíyà rɨ̌’ɨ̀ ìnè pfɔ̌du námbo rɔ̌ ndɨ̀ ndárà rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nyɨ nyɨ̀tdɛ̌nà nzá akyɛ mà dùdu-tsí rɔ́. Pbɛ́tʉ̀, ɨ́yàdhíyà nʉ́dhɔ ndrùù rɔ́ngʉ akyɛ nyʉ́ pfɔ̌du dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mɨ́ dhu nɔ́vɔ kpangba ɨndʉ̀. Wɔ̀ tsìbhálɛ návi ádrʉ̀ngbǎ àzè nyʉ́ idù. Nɨ́, ndɨ dhu-okú dɔ̀ rɔ̀, ma mʉ̀bà wà kàbhà nzɛ́rɛnga kɔ́rɔ́. Pbɛ́tʉ̀, akɛkpá dhu ka kʉ̀bà fɨ̌ndà alɛ bhà àzè narɨ́ ákɛ̌ kɛ̀lɛ̌ yà fɨ̌ndà dhu nʉ̀bà alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yěsù adʉ̀ àtɨ̀nà wɔ̀ tsìbhálɛ nɨ̌: «Ma mʉ̀bà wà pbʉ̀kʉ̀ nzɛ́rɛnga.» ");
INSERT INTO niy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɨ́ kɔ̌kɔ̀ Yěsù mà rǔbhi dhu ɔ̀nyʉ̀ rɔ̌ mànà alɛ náadʉ̀ ’ɔ̀pɛ̀ ’àmbɛ àtɨ̀nà dɔ̌ afíya ɔ̀: «Ɨ́ngbà alɛ-tɨdɔ̀ yà ìndrǔ bhà nzɛ́rɛnga mà nʉ́bà rádʉ̀ ìndrǔ tɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà wɔ̀ tsìbhálɛ nɨ̌: «Pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ wà nyɨ. Nɨ́ árà mběyi.» ");
INSERT INTO niy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù núubhì kɨgɔ̀ ɔ̀nǎ, ndɨrɔ̀ pbanga ɔ̀nǎ màtɨ́. Kǎránà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌, ndàdʉ̀ àrà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ màkʉ̌rʉ̀ nɔ́vɔ̀ rɔ̌ ìndrǔ tɔ̀. Nɨ́, atdí kumì dɔ̀ná ɔ́yɔ̌ nà kàbhà ábhàlɨ̌ mà, ");
INSERT INTO niy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","yà kǐpfo nzɛ́rɛ-alafí ɔ̀yà rɔ̀, ndɨrɔ̀ yà kɨ̌gʉ́ fɨ̀yɔ́ andɨ ɔ̌ rɔ̀ ngúfe vèbhálɛ mànà, nóowúnà ùbhi rɔ̌ atdíkpá kà mànà. Yàrɨ́ nɨ́ ɨ vèbhálɛ-ɔvɔ̀: Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà, yà àrʉ̀bhʉ̀ nzɛ́rɛ-alafí Yěsù ipfo ɔ̀nà rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zǎnɨ̀, Kʉzà bhà ɨngba-tsánà. Ndɨ Kʉzà nɨ’ɨ̀ Hɛ̀rɔdɛ̀ bhà malɨ̀ nɔdɔ́nà alɛ. Ndɨrɔ̀ nɨ’ɨ̀ Sùzanà mà, ibí ngʉ̌kpà vèbhálɛ mànà. Ɨ vèbhálɛ nɨ́ yà Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà nɨ́ dzʉ̀nà ɔ̀nzɨ̀ rɔ̌ owúnà fɔyá dhu nɨ̌ vèbhálɛ. ");
INSERT INTO niy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Atdíku, ìndrǔ níiwú Yěsù-tɨ’ɔ̀ dhèdhèrɔ̀ pbanga ɔ̀nǎ rɔ̀. Nɨ́, ádrʉ̀ngbǎ ihé-yà náandu ɨ̀’ɨ̀ Yěsù-tɨ́. Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ yàrɨ́ mbólí náwɛ abádhí tɔ̀, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Atdí alɛ nɨ́ɨvà ndɨ̀, ndàrà ɔ̀nyʉ̀-tsè nɔ́rɛ̀ pbɨ̀ndà ɨnga ɔ̌. Nɨ́ yà ɔ̀nyʉ̀-tsè nɔ́rɛ kà rɨ̌ ɨnga ɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdídhená itse náawà ɨ̀ ndɨ ɨnga-gìnǎ ʉ́dà otu ɔ̌, ìndrǔ ràdʉ̀ ɔ̀yánga nótsì pfɔ̌ya nɨ̌. Ndɨrɔ̀, àrɛ̀ adʉ̀ ìwu, ’ùbhǐ ɨ itse otu ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ngʉ̌kpà-tsí náawà ɨ̀ ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ dɔ̀ná abhɔ odu-kɛngɛrɛ dɔ̌. Nɨ́, ɨ tsí nɨ́ɨnga, adyifɔ̀ ràdʉ̀ ìtdyunà, ɨ̀mbǎ ɔ̀dɔ̀dʉ̀ adzɨ rɨ̌’ɨ̀ abhɔ dɔ̀yá dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndɨrɔ̀, ngʉ̌kpà itse náawà ɨ̀ okpèya nà itsukpó-vɛ́ rɨ̌’ɨ̀ ɔ̀nà adzɨ ɔ̌. Nɨ́, ɨ okpèya nà itsu-kpó náadʉ̀ àta, ’òvì atdíkpá kɔ̀ ɨ̀ngɨngà ɔ̀nyʉ̀ mànà, ’àdʉ̀ ɨ òvi róvi ɔ̀nyʉ̀ nʉ́tsɨ̀ ɨ̀nzɨ̌ ràdʉ̀ ɔ̀’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pbɛ́tʉ̀, ngʉ̌kpà itse náawà ɨ̀ ídzì adzɨ ɔ̌. Nɨ́, ɨ tsí nɨ́ɨnga, ’òvì, ’àdʉ̀ ɔ̀’ɔ̀, ngǎtsi ràrà atdí mɨyà itse nɔ́dhɨ̀ rɔ̌.» Yěsù adʉ̀ àtɨ̀nà ihé-yà nɨ̌ tdɨ́tdɔ̌: «Ɨnga t’ɨ́rɨta tɔ́ bɨ̌kʉ nà nyɨ̌ nyapɛ́ ɨ̀’ɨ̀, nɨ́ nyɨ̀rɨ nga mběyi!» ");
INSERT INTO niy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nɨ́ wɔ̀rɨ́ mbólí ɨ̀ ɨ̀rɨ̀ dhu-lutìnǎ, Yěsù bhà ábhàlɨ̌ níivú ndɨ mbólí-tɨ̀ kà-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nyʉ́, nyɨ̌ nyʉ́nɨ wà ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi-nyʉtsì ndɨ̀ nórù dhu. Pbɛ́tʉ̀, ngʉ̌kpà alɛ tɔ̀ ka karɨ́ kàwɛ̌ mbólí tɔ́ ɔ́fɔ̀ ɔ̌, ndɨ́nɨ̌ abádhí owu tɨ́ ɨnga àndà rɔ̌, pbɛ́tʉ̀ ɨ̀nzɨ̌ ’àdʉ̀ atdí dhu mà nála, ’àdʉ̀ òwu ɨnga nɨ́rɨ̀ rɔ̌, pbɛ́tʉ̀ ɨ̀nzɨ̌ atdí dhu mà ràdʉ̀ dɔ̀ya nálʉ.» ");
INSERT INTO niy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Yàrɨ́ nɨ́ ndɨ wɔ̀rɨ́ mbólí-tɨ̀: Ɔ̀nyʉ̀-tsè nɨ́ Kàgàwà bhà Ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Atdídhená alɛ nʉ́lɨ ɨ̀ yà itse náawà ɨ̀ ɔ̀ná otu bhěyi. Kàgàwà bhà ɔtɛ abádhí ɨ̀rɨ̀ rɔ̀, Pfɔ̀mvɔ rǎdʉ̀ ɨ̀rà, ndìpfo ndɨ ɔtɛ abádhí-afí ɔ̀ rɔ̀, ɨ̀nzɨ̌ abádhí a’u tɨ́ dhu, ’àdʉ̀ ʉ̀gʉ. ");
INSERT INTO niy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ngʉ̌kpà alɛ nʉ́lɨ ɨ̀ yà ɨ̀mbǎ adzɨ rɨ̌’ɨ̀ dɔ̀ná abhɔ odu-kɛngɛrɛ-dɔ bhěyi. Kàgàwà bhà ɔtɛ ɨ̀ ɨ̀rɨ̀ rɔ̀, abádhí rɨ̌ kà’u dhɛ̀dhɛ nyʉ́ nà. Pbɛ́tʉ̀, abádhí rɨ̌ ’àpbǎ ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́ Kàgàwà bhà ɔtɛ rɔ̌, ɨ̀nzɨ̌ ’àdʉ̀ kàbhʉ ɨvɛ́na rɔ̀dɨ̀ ndɨ̀ afíya ɔ̀. Nɨ́, alɛ-afí ùmvǔ rɨ́ dhu-tɨdɔ̀ nɔ́pɛ̀ ndɨ̀ rɔ̀, abádhí rǎdʉ̀ fɨ̀yɔ́ a’uta nʉ́bhà atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Okpèna nà itsu-vɛ́ nà adzɨ bhěyi ɨ̀ nʉ́lɨ alɛ nɨ́, yà Kàgàwà bhà ɔtɛ nɨ́rɨ arɨ́, ɨ̀nzɨ̌ yà ɨ̀ ɨ̀rɨ̀nà ɔtɛ ràdʉ̀ itse nɔ́dhɨ̀. Obhó tɨ́, yà adzɨ ɔ̌ dhu-tsí tɔ́ ɨrɛ̀ta mà, yà adzɨ dɔ̌ ònzì mà, ndɨrɔ̀ yà adzɨ dɔ̌ ka kóko dhu tɔ́ dhɛ̀dhɛ mànà, náarádʉ̀ abádhí-afí nʉ́tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ídzì adzɨ bhěyi ɨ̀ nʉ́lɨ alɛ nɨ́, yà Kàgàwà bhà ɔtɛ nɨ́rɨ arɨ́ atdí afíya nyʉ́ nà, ’àdʉ̀ ɔ̀dɔ̀nà afíya ɔ̀, ’àdʉ̀ ’àpba rɔ̀ná alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ tarà nɔ́bɨ̀, ndàdʉ̀ àtsì nà ɨ̀tǎ-tsì. Ndɨrɔ̀, kà rɨ̌ nzɨ̌ àdʉ̀ kɔ̀bɨ̀, ndàdʉ̀ ɨ̀lɨnà ara-tsì. Pbɛ́tʉ̀, ka kádʉ̀ kɔ̀bɨ̀ kɨlɨ ɔrʉ́, ndɨ́nɨ̌ ɨdza rítsù alɛ-nyɨ̌nga nawʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kɔ́rɔ́ dhu tsí, yà ùru ɨ̀ nuru núuvìya ɨ̀ kpangba. Ndɨrɔ̀, kɔ́rɔ́ dhu-tsí yà ɔ̀dhʉ̌ ɔ̀ aróko, nɨ́ ka kʉnɨya kɔ́rɔ́, ràdʉ̀ ’ùvi kpangba awáwʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nyàndà nga mběyi yà fʉ̌kʉ̀ ka kʉ́nɔna dhu nɨ́rɨ nyɨ̌ nyárɨ́ tɨ́ dhu nà. Obhó tɨ́, dhu nà arɨ́’ɨ̀ abhɔ alɛ náabáya dhu abhɔ nyʉ́ ròsè. Ndɨrɔ̀, ɨ̀mbǎ arɨ́’ɨ̀ kà nà alɛ-fɔ́ rɔ̀ ka kakɔ̀ya yà kǎrɨ́ ɨ̀rɛ̀na ndɨ̀ ndɨ́’ɨ̀ nà dhu tɨ́ dhu mà.» ");
INSERT INTO niy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wɔ̀ dhu-dzidɔ̌, Yěsù-tsánà mà, kà t’ádɔ́na mànà níiwú Yěsù rɨ̌’ɨ̀ ɨ. Pbɛ́tʉ̀, abádhí rǒwu ùvò kà-tɨ́ dhu nɨ́ɨ’ɨ̀ ɔbɨ tɨ́ ihé-yà-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɨ́, ka kadʉ̀ dhu ɔ̀vɔ̀ Yěsù tɔ̀, katɨ: «Ɨ́yànʉ mà adɔ́nʉ mànà níkò irí. Nɨ́, abádhí òzè ’àla ngbɔ̌nʉ.» ");
INSERT INTO niy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà yà tɨná ɨ̀’ɨ̀ kɔ́rɔ́ alɛ nɨ̌: «Ɨ́yàdu mà, adɔ́du mànà nɨ́ yà Kàgàwà bhà Ɔtɛ nɨ́rɨ arɨ́, ’àdʉ̀ kʉ̀nɔ̀ dhu ɔ̀nzɨ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Atdíku, Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà núupò atdí ibhú ɔ̀. Nɨ́, kǎtɨ abádhí nɨ̌: «Kàda rɛ̀rʉ̀-adzè.» Nɨ́, abádhí adʉ̀ abhi ɔ̀pɛ̀ ’òwù ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nɨ́ ɨdha dɔ̌ ɨ̀ ówu rɔ́rɔ̀, Yěsù náayì, ɨdhɔ ròdyì ndɨ̀. Nɨ́, kòmbómbí tɨ́ àpùpú náapɛ̀ ndòpìlì rɛ̀rʉ̀ dɔ̌, ɨdha ràdʉ̀ ndɔ̀pɛ̀ ndòtsù ibhú ɔ̀. Nɨ́, ibhú ɨ’ɨ̀ ɨ́kyɛ̀rɔ̌ ndɨ́nɨ̌ ndɨ̀ ndabì tɨ́ abádhí nà ɨdha ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nɨ́rɔ̀ nɨ́ ndɨ ábhàlɨ̌ náandrì Yěsù-tɨ’ɔ̀, ’ɨ̀nga ka ɨdhɔ ɔ̀ rɔ̀, ’àdʉ̀ àtɨ̀nà: «Ádrʉ̀ngbǎlɛ́, Ádrʉ̀ngbǎlɛ́, àlɛ̌ kìku wà!» Nɨ́, Yěsù nɨ́ɨvà ndɨ̀, ndɨ̀sɔ̌ awɛ mà, mʉ̀kʉrà mànà rìkò. Ányɨ̀rɔ̌ rɔ̀ tɨ́, awɛ nʉ́ʉbhà opilita, ɨdha ràdʉ̀ ɨ̀nɛ̀ bhìì. ");
INSERT INTO niy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̌ nyàpɛ̀ tɨ́ obhó ɨ̀’ɨ̀ a’uta nà?» Nɨ́ ɔdɔ nɨ́ɨsɨ́ abádhí ɔ̀, ɨdhɔ ràdʉ̀ ’ʉ̀kɔ. Abádhí ambɛ́nà ɔ̀tɛ dɔ̌ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ɨ́ngbà dhu bhěyi alɛ-tɨdɔ̀ yà? Kǎrɔ́tɛ awɛ mà, ɨdha mànà dhu dɔ̌, ràdʉ̀ tsʉ̀ná dhu ɨ̀rɨ̀!» ");
INSERT INTO niy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà náawù ùvò Pbàgɛ̀rasɨ̀ tɔ́ pbìrì ɔ̀. Ndɨ pbìrì nɨ́ɨ’ɨ̀ Gàlìlayà tɔ́ rɛ̀rʉ̀-adzènǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nɨ́, ibhú ɔ̀ rɔ̀ Yěsù ìfò, ndàhʉ ɨdha-bɨdɔ̀ rɔ̀, kɨgɔ̀ ɔ̌ atdí alɛ nɨ́ɨra àhʉ kɔ̀nzɨ̌. Ndɨ alɛ nɨ’ɨ̀ ibí nzɛ́rɛ-alafí náarɨ́’ɨ̀ ɔ̀nà. Ndɨrɔ̀, kɨ̌’ɨ̀ mbǎ mbɛrʉ̀ nà rɔ̀ná ábhɔ̌ ɨdhɔ nyʉ́ tɨ́. Kǒngónà nzɨ̌ àdɨ atdí ɨdza ɔ̌ màtɨ́. Pbɛ́tʉ̀, kǒngónà àdɨ kàbhǔlì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nɨ́, Yěsù ndɨ̀ ndàla rɔ̀, kǎkù, ndàdʉ̀ ɨ̀rà ndìbvu obvò Yěsù-ɔ̀nzɨ̌. Ndɨrɔ̀, kǎdʉ̀ dhu ɔ̀vɔ̀ Yěsù tɔ̀ ɔrʉ́-tǔna nyʉ́ nà, ndàtɨ: «Hɨ́ɨ̀! Àdhu àlɛ̌ nzínzì ɔ̌ rɨ̌’ɨ̀ Yěsù, yà kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ Kàgàwà t’Ídhùnǎ? Ma mɨ̀tsɔ̀ ma ɨ̀tsɔ̀ tɨ́ nyʉ́ rʉ̀nʉ́, nzɨ̌ àvǔ rùdú.» ");
INSERT INTO niy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Obhó tɨ́, Yěsù adʉ̀ àdɨ ndàmbɛ dhu nʉ́ya dɔ̌ wɔ̀ alɛ ɔ̀ rɨ̌’ɨ̀ nzɛ́rɛ-alafí tɔ̀, ndɨ́nɨ̌ àhʉ tɨ́ kà ɔ̀ rɔ̀. Ndɨrɔ̀, ibí-gʉ̀na ndɨ nzɛ́rɛ-alafí ongónà dhu ɨ̀và kà rɔ̌. Nɨ́, ka kongónà àdʉ̀ ndɨ alɛ nɔ́dɔ̀ àdrà-mbǐ nɨ̌ ka kʉ̀tsɨ̀ rɔ́rɔ̀, ndɨrɔ̀ sìngà-mbǐ nɨ̌ ka kʉ̀tsɨ̀ pfɔ̌na mà rɔ́rɔ̀. Pbɛ́tʉ̀, kǒngónà kɔ̌kɔ̀ ndɨ̀ ka kʉ̀tsɨ̀ nɨ̌ imbi nátdɨ kɔ́rɔ́. Ndɨrɔ̀, kà’ɔ̀ rɨ̌’ɨ̀ nzɛ́rɛ-alafí nóongónà àdʉ̀ kìdzì ràrà ɨ̀mbǎ ìndrǔ arɨ́’ɨ̀ ɨ nanǎ. ");
INSERT INTO niy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nɨ́, Yěsù níivú dhu wɔ̀ alɛ-tsʉ̌, ndàtɨ: «Ɔvɔ̀nʉ nɨ́ àdhɨ?» Nɨ́, kǎdʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ɔvɔ̀du nɨ́ ‹Ihé-yà.›» Obhó tɨ́, ibí nzɛ́rɛ-alafí nyʉ́ náatsù kà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndɨrɔ̀, ɨ̀ nzɛ́rɛ-alafí nɨ́ɨtsɔ̀ ɨ̀ Yěsù rɔ̌, ɨ̀nzɨ̌ dhu nʉyá tɨ́ fɨ̌yɔ̀ ’òwù òyǐ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, àdʉ̀ tɔ́ màhò nɨ́ɨ’ɨ̀ ìnè ányɨ̀rɔ̌ ɨ̀ ányʉ pbìrì-ɔngɔ̀ rɔ̌ rɔ́. Nɨ́, kɔ̌kɔ̀ nzɛ́rɛ-alafí náadʉ̀ ’ɨ̀tsɔ̀ Yěsù rɔ̌, ndɨ́nɨ̌ rʉsà nʉfà tɨ́ fɨ̌yɔ̀, ’òwù òtsù ɨ àdʉ̀ ɔ̀. Nɨ́, kǎdʉ̀ ndɨ rʉsà ʉ̀fà abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kɔ̌kɔ̀ nzɛ́rɛ-alafí náadʉ̀ ’ʉ̀nyà wɔ̀ ɨ̀ ɨ́’ɨ̀ ɔ̀nà alɛ ɔ̀ rɔ̀, ’àdʉ̀ òwu òtsù àdʉ̀ ɔ̀. Nɨ́rɔ̀ nɨ́ ndɨ ɨ àdʉ̀ tɔ́ màhò náadʉ̀ àdrǔ pbìrì-ɔngɔ̀ rɔ̌ rɔ̀, ’òwù ’ʉ̀pbà ndɨ pbìrì-pfɔ̀ ɔ̀ rɨ̌’ɨ̀ rɛ̀rʉ̀ ɔ̀, tsěya rɔ̀tdɨ̀ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu ɨ̀ àla rɔ̀, kɔ̌kɔ̀ àdʉ̀ nʉ́ndà rɔ̌ rǔbhi alɛ náatsè kɔ́rɔ́, ’àdʉ̀ ndɨ dhu ɔ̀yɨ̌ nʉ́gà kɨgɔ̀ ɔ̌ bhà tɔ̀, ndɨrɔ̀ pbanga ɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ìndrǔ náawù wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu nándà. Nɨ́ abádhí adʉ̀ òwu Yěsù-tɨ’ɔ̀, ’àdʉ̀ wɔ̀ nzɛ́rɛ-alafí núvò ɔ̀nà rɔ̀ alɛ nótù kà-tɨ́ nyʉ́ àdɨ rɔ̀ná mbɛrʉ̀ mànà, ndɨrɔ̀ ídzì rɔ̌ rɔ̀ nyʉ́ rɔ́. Nɨ́, ɔdɔ náadʉ̀ ɨ̀sɨ̌ atdídɔ̌ abádhí ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wɔ̀ ɨ̀ nɔ̀nzɨ̀ kɔ́rɔ́ dhu nàla alɛ náawɛ wɔ̀ nzɛ́rɛ-alafí náarɨ́ àvu rɔ̀ná alɛ nɔ́gʉ̀ tɨ́ dhu kɔ̌kɔ̀ ìwǔ ìwǔ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nɨ́ Pbàgɛ̀rasɨ̀ tɔ́ pbìrì ɔ̌ alɛ kɔ́rɔ́ náadʉ̀ Yěsù nónzì rɨ̀và ndɨ̀ fɨ̀rábvʉ̌ rɔ̀, atdídɔ̌ ɨ̀’ɨ́ ɔdɔ nɔ́nzɨ nɨ́dhunɨ̌. Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ ùpo ibhú ɔ̀, ndàdʉ̀ ndàdu abádhí-bvʉ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wɔ̀ nzɛ́rɛ-alafí núvònà ɔ̀nà rɔ̀ alɛ nɨ́ɨtsɔ̀ ndɨ̀, ndɨ́nɨ̌ ɨ̀ owu tɨ́ atdíkpá Yěsù mànà. Pbɛ́tʉ̀, Yěsù àdʉ̀ ndùvo ùvǒ tɨ́ kàrɔ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ádǔ nyɨ pbʉ̀kʉ̀ nyadʉ̀ Kàgàwà ɔ̀nzɨ̀ rʉ̀nʉ́ kɔ́rɔ́ dhu náwɛ.» Nɨ́rɔ̀ nɨ́ ndɨ wɔ̀ alɛ náadʉ̀ àrà, ndàdʉ̀ àmbɛ Yěsù ɔ̀nzɨ̀ fɨ̌ndà dhu náwɛ dɔ̌ ìndrǔ tɔ̀ kɨgɔ̀ ɔ̌ kɔ́rɔ́ ngari ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yěsù níitdègu ndàdǔ, ndàdà rɛ̀rʉ̀-adzè, nɨ́ ányɨ̀ ihé-yà nyʉ́ náadʉ̀ kàkɔ, angyangyɨ ɨ̀ úbhi kɔ̀dɔ̀ rɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nɨ́ kombómbí tɨ́, Yàhirò tɨ́ kátɨna atdí alɛ nɨ́ɨra àhʉ ányɨ̀rɔ̌. Ka nɨ’ɨ̀ Pbàyàhúdí tɔ́ unduta-dzà ɔ̌ ádrʉ̀ngbǎlɛ. Nɨ́, kǐbvú ndɨ̀ Yěsù-ɔ̀nzɨ̌, ndàdʉ̀ ndɨ̀tsɔ̀ kàrɔ̌, ndɨ́nɨ̌ ara tɨ́ pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kɨ̌tsɔ̀ ndɨ̀ ndɨ dhu bhěyi, yà atdí tɨ́ arɨ́’ɨ̀ fɔná tsìbhíngba rɨ̌’ɨ̀ afína rɔ̌ ka kɔ́dɔna rɔ́ dhu-okú dɔ̀ rɔ̀. Wɔ̀ ndɨ tsìbhíngba ɨ’ɨ̀ mbɛ̀mbɛ̀ atdí kumì dɔ́nà ɔ́yɔ̌ nà atɔ nà. Nɨ́, Yàhirò bhà Yěsù rǎrà ɔ̀ná kàsʉmɨ̀ ɔ̌, ihé-yà nyʉ́ níibòlò ɨ̀ kà-rɔ̌, ’ìpbǒ ka átsǐ. ");
INSERT INTO niy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ndɨrɔ̀, atdí tsìbhálɛ, yà vèbhàlɛ tɔ́ ɔgɔ́bhà tɔ́ azu náarɨ́ ɨ̀rà rɔ̀ná, ràrà àhʉ atdí kumì dɔ̀ná ɔ́yɔ̌ nà atɔ tɨ́, nɨ́ɨ’ɨ̀ ìnè abádhí nzínzì ɔ̌. Ka nɨ’ɨ̀ ɨwà fɔná ongyéngá-tsè nɔ́tdɨ̀ pbàngángá dɔ̀nǎ ndɨ̀ ndarɨ́ ùbhi rɔ́. Pbɛ́tʉ̀, atdí mʉ̀ngangà mà náadʉ̀ nzá kɨ̀gʉ. ");
INSERT INTO niy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nɨ́, wɔ̀ tsìbhálɛ náawè ndɨ̀ Yěsù-dzidɔ̀ nǎ rɔ̀, ndàpbàlǎ kàrɔ̌ mʉ̀dzarʉ̀-bɨdɔ̀-ngbɔ̀. Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ wɔ̀ tsìbhálɛ rɔ̌ arɨ́ ɨ̀rà azu náadʉ̀ ìde. ");
INSERT INTO niy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nɨ́, Yěsù ivú dhu ihé-yà-tsʉ̌ ndàtɨ: «Ádhɨ ngbɔ̌du nàpbàlǎ?» Nɨ́ kɔ́rɔ́ alɛ adʉ̀ ’àgò àgò tɨ́. Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ dhu ɔ̀vɔ̀ Yěsù tɔ̀ ndàtɨ: «Hɔ̀kɔ̀ Màlimò, ihé-yà nyʉ́ nɨ́ ndɨ ngbɔ̌nʉ nàkpɔ̀rɔ̀, ’ìpbǒ nyɨ átsǐ!» ");
INSERT INTO niy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨwà atdí alɛ nápbàlǎ ngbɔ̌du! Ma mʉ̀nɨ wà dhu mběyi nyʉ́, atdí ɔbɨ ràhʉ wà nyʉdutsì rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nɨ́, wɔ̀ tsìbhálɛ níitdègu ɨwà Yěsù nɔ́sʉ̀ wɔ̀ ndɨ̀ ndɔ̀nzɨ̀ dhu dhu nálǎ, nɨ̌ kǎdʉ̀ ɨ̀rà ìvǐ ndɨ̀ ndívi rɔ́rɔ̀, ndìbvǔ ndɨ̀ Yěsù-ɔ̀nzɨ̌: Nɨ́, kɔ́rɔ́ alɛ-ɔ̀nzɨ̌ rɔ̀, kǎdʉ̀ Yěsù rɔ̌ mʉ̀dzarʉ̀-bɨdɔ̀-ngbɔ̀ ndɨ̀ ndàpbàlǎ okúna dɔ̀ rɔ̀ dhu mà, ndɨrɔ̀ ndɨ̀ ndɔ̀gʉ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́ dhu mànà dhu náwɛ. ");
INSERT INTO niy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɨ́ Yěsù ádʉ̀ àtɨ̀nà ɨ́yàdhíyà nɨ̌: «Pbà nɨ̌ tsìbhíngbá, ɨwà pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ nyɨ! Nɨ́ árà màrʉ̀ngà ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Àzèmbè Yěsù rɔ̌tɛ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdí alɛ nɨ́ɨra Pbàyàhúdí tɔ́ unduta-dzà ɔ̌ atdí ádrʉ̀ngbǎlɛ, Yàhirò tɨ́ kátɨna bhà rɔ̀. Nɨ́, kǐtsi àtɨ̀nà ndɨ Yàhirò nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɨvànʉ́-ngba nɔ́vɛ̀ wà! Nɨ́ nzɨ̌ àvǎ Màlimò-tsì.» ");
INSERT INTO niy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pbɛ́tʉ̀, Yěsù níitdègu wɔ̀ Yàhirò tɔ̀ ka kʉ̀nɔ̀ dhu nɨ́rɨ, nɨ́ kǎdʉ̀ àtɨ̀nà ndɨ Yàhirò nɨ̌: «Nzɨ̌ ɔnzɨ ɔdɔ! Ɨ́’ɨ̀ a’uta nà tɨ́! Nɨ́ pbʉ̀kʉ̀ tsìbhíngba rɔ̌gʉ̀ ɔ̀gʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nɨ́ Yàhirò bhà ndɨ̀ ndàrà àhʉ rɔ̀, Yěsù náa’u nzá atdí alɛ mà ròtsù ɨdza owùna ɔ̌. Pbɛ́tʉ̀, kǎ’u nɨ́ Pɛ́tɛrʉ̀ mà, Yùwanɨ̀ mà, Yàkɔbhɔ̀ mà, wɔ̀ ngbángba t’ábanà mà, kà-tsánà mànà kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ányɨ̀rɔ̌ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ náambɛ́nà ɔ̀dzɨ dɔ̌, ɨzʉ ràdʉ̀ ’ʉ̀ka atdídɔ̌ wɔ̀ ngbángba bhà ɔvɛ-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀dzɨ, ɨnzá wɔ̀ ngbángba nɔ́vɛ̀! Kɔ̀dhɔ̀ ɔ̀dhɔ̀ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nɨ́ ìndrǔ adʉ̀ Yěsù rʉ̌nɔna dhu ʉ̀gbɔ ʉ̀gbɔ̌ tɨ́, ɨ̀ ʉ̀nɨ dhu ɨwà wɔ̀ tsìbhíngba rɔ̀vɛ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pbɛ́tʉ̀, Yěsù adʉ̀ wɔ̀ tsìbhíngba nálʉ ɔtsʉ́na rɔ̌, ndàdʉ̀ dhu ɔ̀vɔ̀ fɨ̌ndà ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Pbànɨ̌ngbá, ɨ́và nyɨ!» ");
INSERT INTO niy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɨ́, kà-afí náadʉ̀ ìngo, ndàdʉ̀ ndɨ̀và ndɨ kàsʉmɨ̀ ɔ̌ tɨ́. Nɨ́ Yěsù adʉ̀ ɔ̀nyʉ̀ àvi kabhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nɨ́ wɔ̀ tsìbhíngba t’ábanà mà, kà-tsánà mànà nʉ́kɔ ɨ̀dhɔ adʉ̀ atdídɔ̌. Ndɨrɔ̀, Yěsù adʉ̀ abádhí nɨ́sɔ ɨ̀nzɨ̌ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu nɔvɔ tɨ́ atdí alɛ tɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yěsù andu atdí kumì dɔ̀ná ɔ́yɔ̌ nà pbɨ̀ndà ábhàlɨ̌-tsʉ̀, ndàbhʉ ádrʉ̀ngbǎnga tɔ́ ɔbɨ fɨ̌yɔ̀. Ndɨ ɔbɨ nɨ’ɨ̀ kɔ́rɔ́ nzɛ́rɛ-alafí nípfo abádhí rǎdʉ̀ nɨ̌ ìndrǔ ɔ̀ rɔ̀, ’àdʉ̀ dhèdhèrɔ̀ andɨ-tɨdɔ̀ nà alɛ nɨ́gʉ nɨ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ. ");
INSERT INTO niy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nɨ́, kǔví abádhí ròwù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ màkʉ̌rʉ̀ nʉ́nɔ̀ ìndrǔ tɔ̀, ’àdʉ̀ andɨ nà alɛ nɨ́gʉ. ");
INSERT INTO niy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kʉ̌yá dhu abádhí tɔ̀ ndàtɨ: «Àpɛ́ nyìdyi atdí dhu mà abhi tɔ̀. Àpɛ́ nyùgu mùgǒ mà, bhɔlɔ mà, mʉ̀gatì mà, ndɨrɔ̀ fʉ̀rangà mànà. Ndɨrɔ̀, àpɛ́ nyùgu mbɛrʉ̀ ɔyɔ̌yɔ́. ");
INSERT INTO niy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyɨ̌ ka kàkɔ ɔ̀ná ɨdza ɔ̌, nyɨ̌ nyowuna òko rɔ̌, ràrà àhʉ ányɨ̀rɔ̌ rɔ̀ nyɨ̌ nyɨ́ nyɨ̌và nyǒwù dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ndɨrɔ̀, ɨnzá ka kàkɔ nyɨ̌ ɔ̀ná kɨgɔ̀ ɔ̌ rɔ̀, nyɨ̌ nyowuna ùvò rɔ̌, nyǎdʉ̀ pfɔ̌kʉ-tsítsírɔ́ àhʉ̀ nɔ́’ɔ̀ ányɨ̀rɔ̌, ndɨ́nɨ̌ abádhí tɔ́ afátá nɨtɛ̀ tɨ́ abádhí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nɨ́ kɔ̌kɔ̀ ábhàlɨ̌ nɨ́ɨvà ɨ̀ ’òwù, ɨ̀ rùbhi dhèdhèrɔ̀ pbanga ɔ̀na nǎ, ’àmbɛ Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ dɔ̌, ’àdʉ̀ òwu ìndrǔ nɨ́gʉ rɔ̌ kɔ́rɔ́ ngari ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ nɨ́ɨrɨ Yěsù rɔ̌nzɨna dhu-ɔ̀yɨ̌. Nɨ́ ndɨ dhu adʉ̀ kàdɔ àbhʉ rɨ̀nza ndɨ̀ atdídɔ̌. Atdídhená alɛ nóowúnà àtɨ̀nà rɔ̌, bàtizò ùbho rɔ̌ arúbhi Yùwanɨ̀ rɨ̀ngbɛ̀ wà ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngʉ̌kpà alɛ adʉ́nà òwu àtɨ̀nà rɔ̌, Ɛ̀lɨyà ràrɨ̌ wɔ̀ ndɨ̀ nɨ̀tɔ̀. Ndɨrɔ̀ ngʉ̌kpà-tsí náadʉ́nà òwu àtɨ̀nà rɔ̌, yà angyí ʉvɛ̀ pbànábí nzínzì ɔ̌ atdí alɛ ràrɨ̌ wɔ̀ ndɨ̀ nɨ̀ngbɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pbɛ́tʉ̀, Hɛ̀rɔdɛ̀ adʉ̀ àtɨ̀nà: «Ma mávi wà bàtizò ùbho rɔ̌ arúbhi Yùwanɨ̀-dɔ kɔkɛ̀rɛ̀. Nɨ́rɔ̀, ádhɨ pbá alɛ nyʉ́ wɔ̀ ma márà ɔ̀nzɨna rɨ́ dhu-ɔ̀yɨ̌ nɨ́rɨ̀ rɔ̌?» Nɨ́rɔ̀ nɨ́ ndɨ Hɛ̀rɔdɛ̀ adʉ̀ ndòzè ndàla Yěsù. ");
INSERT INTO niy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yěsù bhà uvitatálɛ níitdègu ’àdǔ, nɨ́ abádhí adʉ̀ ɨ̀ ɔ̀nzɨ dhu àwɛ Yěsù tɔ̀ kɔ́rɔ́. Nɨ́, Yěsù mà, ɨ ábhàlɨ̌ mànà adʉ̀ ùvò atdíkpá, ’òwù lɛ̀ngɛ̀lɛ̀ngɛ̀ rɨ̌’ɨ̀ ngari ɔ̀, Bɛ̀tɛ̀sàyidà tɨ́ kátɨna kɨgɔ̀-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pbɛ́tʉ̀ ihé-yà níitdègu abádhí òwù ndɨ ngari ɔ̀ dhu ɨ̀rɨ, nɨ́ ihé-yà adʉ̀ òwu ányɨ̀ átɔ̀. Nɨ́, ányɨ̀ ɨ̀ òwù ùvò rɔ̀, Yěsù adʉ̀ abádhí àkɔ, ndàdʉ̀ ɔtɛ ɔ̀pɛ̀ ndàwɛ fɨ̌yɔ̀ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi dɔ̌. Ndɨrɔ̀, kǎdʉ̀ ɨ̀ nòzè ndɨ̀gʉ̌ ɨ̀ alɛ nɨ́gʉ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nɨ́ ɨnga níitdègu ndɔ̀pɛ̀ ndàtɨ, nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ ìwu kà-tɨ’ɔ̀. Nɨ́ abádhí adʉ̀ dhu ɔ̀vɔ̀ kà tɔ̀, ’àtɨ: «Ɨrɔ́ àlɛ̌ kɨ́’ɨ̀ rʉ̀ngʉ̀ ɔ̀. Nɨ́, óvì ihé-yà ròwù kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ pbanga mà, ɨnga òbhì ka karɨ́ ɔ̀yá ngari mànà ɔ̀nǎ. Ányɨ̀ nga nɨ́ ndɨ abádhí rɨ̌ ɔ̀nyʉ̀ mà, ɨdhɔ tɔ́ ngari mànà dhu nábà nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyàbhʉ ɔ̀nyʉ̀ abádhí tɔ̀ nyɨ̌-tɨ́rɔ̀!» Nɨ́, ábhàlɨ̌ adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Mǎ mɨ́ imbò mʉ̀gatì mà ɔ́yɔ̌ ɨ̀bhɛ̀ kɛ̀lɛ̌ mànà nà. Nɨ́, nyɨ nyòzè tɨ́ mǒwù ɔ̀nyʉ̀ ùdzi mǎ-tɨ́rɔ̀ kɔ̌kɔ̀ alɛ́-yà tɔ̀ kɔ́rɔ́!» ");
INSERT INTO niy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ányɨ̀rɔ̌ kpabhálɛ ɨ’ɨ̀ mbɛ̀mbɛ̀ imbò lʉfʉ̀ tɨ́. Nɨ́, Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ àvi ràbhʉ kɔ̌kɔ̀ alɛ, ròkò obvò, imbìmbó kumì rɔ̀ tsʉ̀na tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɨ ábhàlɨ̌ adʉ̀ dhu ɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́, ’àbhʉ kɔ́rɔ́ alɛ ròkò obvò. ");
INSERT INTO niy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wɔ̀ dhu-dzidɔ̌, Yěsù ugu kɔ̌kɔ̀ imbò mʉ̀gatì mà, ɔ́yɔ̌ ɨ̀bhɛ̀ mànà, ndʉ̀lʉ̌ fɔná. Nɨ́, kǎdʉ̀ ɔrʉ̀-akpà-ɔ̀nga àndà, ndàdʉ̀ wɔ̀rɨ́ ɔ̀nyʉ̀ náso. Tdɨ́tdɔ̌, kǎdʉ̀ mʉ̀gatì-ɔ̌nga nʉ́kɔ, ndùbho pbɨ̀ndà ábhàlɨ̌-fɔ́, ndɨ́nɨ̌ abádhí nʉ́ʉndɔ tɨ́ ihé-yà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nɨ́, kɔ́rɔ́ alɛ náadʉ̀ dhu ɔ̀nyʉ̀ ’ùlè nɨ̌. Yěsù bhà ábhàlɨ̌ náadʉ̀ ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go mà, ɨ̀bhɛ̀-go mànà-tsʉ̀ núndu, ’àdʉ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà sɛ̌ngɛ̀ nɨ́ra nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Atdíku, Yěsù núubhínà ndɨ̀tsɔ̀ rɔ̌ atdírɔ̀, ìnè pbɨ̀ndà ábhàlɨ̌ rɨ̌’ɨ̀ tɨná rɔ́rɔ̀. Nɨ́, kǐvú dhu abádhí-tsʉ̌, ndàtɨ: «Yà ìndrǔ rɔ̌tɛ dùdú rɔ̀, abádhí náaróngo àtɨ̀nà ma ràrɨ̌ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nɨ́ abádhí náadù ɔtɛ kà tɔ̀ ’àtɨ: «Atdídhená alɛ náarátɨna nyɨ ràrɨ̌ yà bàtizò nubhónà Yùwanɨ̀. Ngʉ̌kpà alɛ náarátɨna nyɨ ràrɨ̌ Ɛ̀lɨyà. Ndɨrɔ̀, ngʉ̌kpà alɛ-tsí náarádʉ̀ àtɨ̀nà nyɨ ràrɨ̌ angyí ʉvɛ̀ pbànábí nzínzì ɔ̌ rɔ̀ ndɨ̀ nɨ́ngbɛ̀ atdí alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nɨ́, kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Olu, nyɨ̌ nyʉ́, nyɨ̌ nyarátɨna ma ràrɨ̌ àdhɨ?» Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ dhu àdu, ndàtɨ: «Nyɨ nɨ́ Kàgàwà bhà Krɨ́stɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yěsù adʉ̀ abádhí nɨ́sɔ ɔbɨ nyʉ́ nà ɨ̀nzɨ̌ ndɨ dhu nʉnɔ tɨ́ atdí alɛ tɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kadʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌ tdɨ́tdɔ̌: «Dhu àkǎ Ìndrǔ t’ídhùnà ràbà àpbɛ̀ atdídɔ̌. Pbanga ɔ̌ pbàkʉ̀rʉ̌ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mànà dhu nɔ́ɔdhɔya ka. Ka kohoya ka, kadʉ̀ ɔ̀tdʉ̀nà. Ndɨrɔ̀, ɨ̀bhʉ ɨdhɔ ɔ̌, kǎdʉ̀ya ndɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà ányɨ̀rɔ̌ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ nɨ̌: «Ndɨ̀ nòzè ndùbhi owùdu ɔ̌ alɛ nákǎ ndàdzo rɔ̀ná rɔ̀, ndàdʉ̀ ndà’ù ndànɔ̀ pbɨ̀ndà mʉ̀sàlabhà kɔ́rɔ́ kàsʉmɨ̀ ɔ̌, ndàdʉ̀ owùdu nʉ́ngʉ. ");
INSERT INTO niy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pbɨ̀ndà ípìrɔ̌nga nòzè ndɔ̀dɔ̀ fɨ̌ndà alɛ níiwíya ka. Pbɛ́tʉ̀, okúdu dɔ̀ rɔ̀ rɨ́ pbɨ̀ndà ípìrɔ̌nga níwǐ alɛ, nɨ́ɨgʉ́ya ka. ");
INSERT INTO niy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ìndrǔ rɨ̌ yà adzɨ ɔ̌ kɔ́rɔ́ ònzì nábà, pbɨ̀ndà ípìrɔ̌nga ràdʉ̀ ndɨ̀nza, ngǎtsi nɨ̌ ndɨ̀ nyʉ́ ndàdʉ̀ àwǐ dhu tɔ́ ídzìnga nɨ́ àdhu? ");
INSERT INTO niy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ìndrǔ-nyɨ̀ náapɛ́ ɨ̀wʉ okúdu dɔ̀ rɔ̀, ndɨrɔ̀ pbàkà ɔtɛ-okú dɔ̀ rɔ̀ màtɨ́, nɨ́ Ìndrǔ t’ídhùnà-nyɨ̀ nɨ́ɨwʉya átɔ̀ kǒkú dɔ̀ rɔ̀ ndɨ̀ ndítsi ɨ̀rà pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ mà Àbanà bhà awáwʉ̀ mà ndɨrɔ̀ ɨ̀lɨ̌lǎ màlàyíká tɔ́ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ mànà ɔ̌ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ngʉ̌kpà alɛ, yà ɨrɔ́ rɨ̌’ɨ̀ alɛ nzínzì ɔ̌, nʉ́ʉvɛ̀ya nzɨ̌ ɨnzá ɨ̀ àla Kàgàwà rɨ̌ idzi nɔ́nyʉ ìndrǔ dɔ̌ dhu rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mbɛ̀mbɛ̀ àrʉ̀ ɨdhɔ dzidɔ̌, wɔ̀ dhu ndɨ̀ ndɔ́tɛ̀ rɔ́rɔ̀, Yěsù náanzi Pɛ́tɛrʉ̀ mà, Yùwanɨ̀ mà, Yàkɔbhɔ̀ mànà, ’àdʉ̀ ùpo nà pbìrì dɔ̀, ndɨ́nɨ̌ ɨ̀ ɨtsɔ̀ tɨ́ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɨ́, Yěsù rɨ̌ ndɨ̀tsɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kà-nyɨ̀-wɔ̀yɔ̌ nʉ́ʉgɛ̀rɛ̀ ndɨ̀, kà-rɔ̌ mʉ̀dzarʉ̀ ràdʉ̀ ɔ̀wʉ, ndàmbɛ ʉ̀mbɨlɨ dɔ̌ alɛ-nyɨ̀kpɔ́ nóho rɨ́ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nɨ́ ányɨ̀rɔ̌, ɔ́yɔ̌ alɛ nʉ́ʉtɔ ɨ̀, ’àmbɛ ɔ̀tɛ dɔ̌ Yěsù mànà. Ɨ alɛ nɨ’ɨ̀ Músà mà Ɛ̀lɨyà nà. ");
INSERT INTO niy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nɨ́ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ ɨ̀ ʉ̀tɔ̀ ɨ̀ rɔ̀, abádhí náambɛ́nà ɔ̀tɛ dɔ̌ Yèrùsàlɛmà Yěsù rǎrà pbɨ̀ndà kasʉ nʉ́tsà nɨ̌ abhi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɛ́tɛrʉ̀ mà, ɔdhɨ́na mànà nɨ́ɨ’ɨ̀ ɨwà ɨdhɔ nʉ́dà nà atdídɔ̌ rɔ́. Nɨ́, ɨdhɔ ɔ̀ rɔ̀ ɨ̀ ɨ̀và ɨ̀ rɔ̀, abádhí náala Yěsù bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀, kɔ̌kɔ̀ tɨná ìkò ɔ́yɔ̌ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nɨ́, kɔ̌kɔ̀rɨ́ alɛ rɨ̌ Yěsù nʉ́bha ɔ̀ná kàsʉmɨ̀ ɔ̌, Pɛ́tɛrʉ̀ náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Màlimǒ, dhu ɔ̀fɔ̀ nga àlɛ̌ ròkò ɨrɔ́. Kʉ̀dɨ̌ ɨ̀bhʉ hɛmɛ̌-dzà, atdí ɨndʉ̀, ngǎtsi Músà tɔ̀, ndɨrɔ̀ ngǎtsi Ɛ̀lɨyà tɔ̀.» (Pɛ́tɛrʉ̀ nʉ́ʉnɨ ɨnzá àdhu mà nʉ́nɔ ndɨ̀ ndɨ́ dhu.) ");
INSERT INTO niy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wɔ̀ dhu nɔ́tɛ kà rɨ̌ rɔ́rɔ̀ nɨ́ ndɨ, ádrʉ̀ngbǎ àpbù níibvú ndɨ̀, ndàtsì abádhí sɨsɨ̀na nɨ̌. Nɨ́ ɔdɔ nɨ́ɨsɨ́ Yěsù bhà ábhàlɨ̌ ɔ̀, wɔ̀ àpbù rɨ̌ ndàtsì dɔ̀yá dhu ɨ̀ àla rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wɔ̀ àpbù ɔ̀ rɔ̀, atdí alɛ-tù nɨ́ɨrɨ ndɨ̀, ndàtɨ: «Yàrɨ́ nɨ́ Idhùdu, idù ma mɔ́pɨ̀ alɛ. Nɨ́, nyɨ̀rɨ kà-tsʉ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wɔ̀ dhu-dzidɔ̌, Yěsù náadʉ̀ ndòtù atdírɔ̀ tɨ́ ányɨ̀rɔ̌. Kàbhà ábhàlɨ̌ náadʉ̀ wɔ̀ ɨ̀ àla dhu nɔ́dɔ̀ afíya ɔ̀ tɨ́, ɨ̀nzɨ̌ àdʉ̀ atdí dhu mà nʉ́nɔ̀ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tsútsǎ nɨ́nganɨ́, Yěsù mà, kɔ̌kɔ̀ ɨ̀bhʉ pbɨ̀ndà ábhàlɨ̌ mànà náawú pbìrì dɔ̀ rɔ̀. Nɨ́, ihé-yà náadʉ̀ ìwu Yěsù tɨ́ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nɨ́, ɨ ihé-yà nzínzì ɔ̌ atdí alɛ náavɔ̀ dhu ɔrʉ́ tǔna nyʉ́ nà Yěsù tɔ̀, ndàtɨ: «Màlimǒ, ma mɨ̀tsɔ̀ mà ɨ̀tsɔ̀ tɨ́ nyʉ́ rʉ̀nʉ́, ágɛ̀rɛ̌ pɛ́ nyɨ nyàndà idhùdu. Obhó tɨ́ àbadhi arɨ́’ɨ̀ atdírɔ̀ tɨ́ fudú. ");
INSERT INTO niy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nzɛ́rɛ-alafí òtsù kà ɔ̀ rɔ̀, nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́ kǎrókù, ndɨ nzɛ́rɛ-alafí ràdʉ̀ ɔ̀nánga nɨ́yà ɔbɨ nyʉ́ nà, ɨsɔ́-yà ràdʉ̀ ndùpbò liná. Ndɨ nzɛ́rɛ-alafí náarɨ́ àrà kʉ̀bhà pbǎ ngbɔrɔ́ rɔ̀, ɨwà ndɨ̀ ndàbhʉ ka rɨ̀ngyɛ̌ ndɨ̀, ndʉ̀vɛ̌ kpàna atdídɔ̌ nyʉ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɨ́, ma mɨ̀tsɔ̀ ma pbʉ̀kʉ̀ ábhàlɨ̌ rɔ̌, ndɨ́nɨ̌ wɔ̀ nzɛ́rɛ-alafí nipfo tɨ́ kà ɔ̀ rɔ̀. Pbɛ́tʉ̀, abádhí àdʉ̀ nzá kà-lɛ̀mà ɔ̀nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nɨ́, Yěsù adʉ̀ àtɨ̀nà: «Hàkà! Nyɨ̌ indo arɨ́’ɨ̀ alɛ tɨ́ rɔ̀, nyɨ̌ nɨ́ ɨ̀mbǎ arɨ́’ɨ̀ a’uta nà alɛ! Ndɨrɔ̀, nyɨ̌ nɨ́ nzɛ́rɛ alɛ! Àlɛ̌ kokoya atdíkpá nyɨ̌ mànà ìfe kàsʉmɨ̀ tɨ́? Ndɨrɔ̀, ma mondúya fʉ̀kʉ́ dhu-dzi ràrà àhʉ ìfe ɨdhɔ tɨ́?» Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àtɨ̀nà wɔ̀ ngbángba t’ábanà nɨ̌: «Ɨ́rà ndɨ idhùnʉ nà ɨrɔ́!» ");
INSERT INTO niy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɨ́, Yěsù-tɨ’ɔ̀ ndɨ ngbángba rǒndri ɔ̀ná kàsʉmɨ̀ ɔ̌, nzɛ́rɛ-alafí níibvú kà-ɔ̌nga obvò, ndàdʉ̀ kà-ɔ̌nga nɨ́yà ɔbɨ nyʉ́ nà. Pbɛ́tʉ̀, Yěsù náadʉ̀ ɔ̀rʉ̀ wɔ̀ nzɛ́rɛ-alafí dɔ̌, wɔ̀ ngbángba ràdʉ̀ ɔ̀gʉ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɨ ngbángba nádu àbanà-fɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɨ́, ɨdhɔ nʉ́ʉkɔ ʉrɔ́ ɨ̀’ɨ̀ kɔ́rɔ́ alɛ atdídɔ̌, Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ ɨ̀ àla rɔ̀. Òko ìndrǔ òko ɨdhɔ rɨ̌ ’ʉ̀kɔ̌ Yěsù ɔ̀nzɨ̀ dhu dɔ̌ rɔ́rɔ̀, nɨ́ kǎdʉ̀ dhu ɔ̀vɔ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kǎtɨ́: «Nyʉ̀dɨ̌ bɨ̌kʉ nyɨ̌rɨ̀ yà fʉ̌kʉ̀ ma mʉ́nɔna ɔtɛ mběyi: Obhó tɨ́, ka kɨ́ Ìndrǔ t’ídhùnà nípfǒ kabhʉ ìndrǔ-yà-fɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pbɛ́tʉ̀, wɔ̀ ɔtɛ náadʉ̀ nzá abádhí-dɔ àlʉ. Obhó tɨ́, ndɨ ɔtɛ-tɨ̀ náarù ndɨ̀ òru tɨ́ abádhí rɔ̌ ɨ̀nzɨ̌ abádhí ʉnɨ tɨ́. Ndɨrɔ̀, abádhí adʉ̀ Yěsù-tsʉ̌ ɨ̀’ɨ́ ndɨ ɔtɛ-tɨ̀ nívǔ dhu-ɔdɔ̀ nɔ́nzɨ̀ ɔ̀nzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɨ ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ nzínzìya ɔ̌. Abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Àlɛ̌ nzínzì ɔ̌ ádrʉ̀ngbǎlɛ nyʉ́ ròsè nɨ́ ádhɨ?» ");
INSERT INTO niy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pbɛ́tʉ̀, Yěsù nʉ́ʉnɨ abádhí tɔ́ ɨrɛ̀ta angyangyɨ. Nɨ́, kǎdʉ̀ ákɛ̌ ngbángba nídyì ndɨ̀lɨ rìdè tɨná nyʉ́, ");
INSERT INTO niy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ndàdʉ̀ dhu ɔ̀vɔ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀, ndàtɨ: «Yàrɨ́ ngbángba nàkɔ ɔvɔ̀du rɔ̌ alɛ nákɔ wà ma. Ndɨrɔ̀, ɨma nàkɔ alɛ nákɔ wà yà ɨma nívì alɛ. Obhó tɨ́, nzínzìkʉ ɔ̌ kɔ́rɔ́, ákɛ̌ alɛ tɨ́ rɨ̌’ɨ̀ alɛ nɨ́ ndɨ ádrʉ̀ngbǎlɛ.» ");
INSERT INTO niy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yùwanɨ̀ adʉ̀ dhu ɔ̀vɔ̀ Yěsù tɔ̀, ndàtɨ: «Màlimǒ, mǎ màla atdí alɛ ɔvɔ̀nʉ rɔ̌ rɨ̌ nzɛ́rɛ-alafí nípfǒ ìndrǔ ɔ̀ rɔ̀ rɔ́. Nɨ́ mǎ mɨ̀sɔ̌ ka ɨ̀nzɨ̌ kǎrɨ́ ùbhi atdíkpá mǎ mànà owùnʉ ɔ̌ dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pbɛ́tʉ̀, Yěsù adʉ̀ dhu ɔ̀vɔ̀ kà tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ nyɨ̀sɔ̌ ndɨ dhu kà tɔ̀. Obhó tɨ́, ɨ̀nzɨ̌ ndɨ alɛ náapɛ́ ɨ̀’ɨ̀ àlɛ̌ tɔ́ òmvǔ tɨ́, nɨ́ ndɨ alɛ nɨ́ àlɛ̌ nzínzì ɔ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yěsù rɔ̌dzɨ̀ yà adzɨ ɔ̌ rɔ̀, ndàrà ɔ̀rʉ̀-akpà ɔ̀ ɔ̀ná ɨdhɔ nɨ́ɨ’ɨ̀ ɨwà ndɨ̀ ndìndù ndɨ̀ rɔ́. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kǎká ndàrà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nɨ́, kǎdʉ̀ pbɨ̀ndà mʉ̀kɛ̀ngyɛ̀ nóvì ròwù angyi fɨ̌ndà. Nɨ́ ɨ alɛ uvò ’òwù, ’òwù òtsù Pbàsàmàrɨ́yá tɔ́ atdí pbanga ɔ̀, ndɨ́nɨ̌ ɨ̀ ɔbhɔlɔ tɨ́ kàkɔ̌ ka kɨ́ tɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pbɛ́tʉ̀, ndɨ pbanga ɔ̌ bhà adʉ̀ nzá Yěsù àkɔ fɨ̀rábvʉ̌, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ kà rǎrà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nɨ́, Yěsù bhà ábhàlɨ̌, Yàkɔbhɔ̀ mà Yùwanɨ̀ mànà níitdègu wɔ̀ dhu àlǎ, nɨ́ abádhí adʉ̀ dhu ɔ̀vɔ̀ Yěsù tɔ̀, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, nyɨ nyòzè tɨ́ wà mǒnzì kàzʉ rìfò ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, rɔ̀tdɨ̀ kɔ̌kɔ̀ alɛ-tsè?» ");
INSERT INTO niy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pbɛ́tʉ̀, Yěsù adʉ̀ ndàgɛrɛ ndàndà abádhí dɔ̀ nga, ndàdʉ̀ ɔ̀rʉ̀ abádhí dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náadʉ̀ ùvò, ’òwù ngǎtsi pbanga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Otu ɔ̌ kɔ̌kɔ̀ alɛ rǒwu rɔ́rɔ̀, atdí alɛ náavɔ̀ dhu Yěsù tɔ̀ ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ma móngo ùbhi owùnʉ ɔ̌, kɔ́rɔ́ ngari ɔ̌ nyɨ nyúbhi ɨ nanǎ.» ");
INSERT INTO niy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ayíwě mà náarɨ́’ɨ̀ ìnè bhǔya nà. Ndɨrɔ̀, yà ɔrʉ́ arángɨlɨ àrɛ̀ mà náarɨ́’ɨ̀ ìnè ɨdzàya nà. Pbɛ́tʉ̀, Ìndrǔ t’ídhùnà, rɨ̌ ndɔ̀kɔ̀, ndɨ̀lɨ dɔ̀na obvò rɔ́nga mà náarɨ́’ɨ̀ ɨ̀mbǎ.» ");
INSERT INTO niy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndɨrɔ̀, Yěsù adʉ̀ àtɨ̀nà ngǎtsi alɛ nɨ̌: «Ɨ́rà owùdu ɔ̌!» Pbɛ́tʉ̀, ndɨ alɛ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ʉ́fà rʉsà idù, marà pɛ́ àbadu ɔ̀tdʉ̀ angyi.» ");
INSERT INTO niy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nɨ́, Yěsù adʉ̀ dhu ɔ̀vɔ̀ kà tɔ̀, ndàtɨ: «Ʉ́bhà kɔ̌kɔ̀ abvo rʉ̀tdʉ̌ fɨ̌yɔ́ abvo. Pbɛ́tʉ̀, árà nyʉnɔ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi tɔ́ Màkʉ̌rʉ̀ ìndrǔ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngǎtsi alɛ náatɨ tdɨ́tdɔ̌ Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, ma mòzè mʉngʉ owùnʉ. Pbɛ́tʉ̀, ʉ́fà pɛ́ rʉsà angyi idù, marà pbàkà ɨdzá-bhà nóvì.» ");
INSERT INTO niy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨwà ɨnga nɔ̀pɛ̀ ndòbhì alɛ náapɛ́ olùnga àndà, nɨ́ ndɨ alɛ àkǎ nzá ndɔ̀nzɨ̀ kasʉ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà Idzi ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wɔ̀ dhu-dzidɔ̌, Ádrʉ̀ngbǎlɛ Yěsù náavò àrʉ̀bhʉ̀ kumì dɔ̀ná ɔ́yɔ̌ nà ngʉ̌kpà alɛ. Kǎdʉ̀ ɨ alɛ núvi ɔyɔ̀yɔ́ rɔ̀ ròwù angyi fɨ̌ndà, yà ndɨ̀ nyʉ́ ndɨ̀tɨ́rɔ̀ ndɨ̀ ndàkǎnà ndàrà ɔ̀yà kɔ́rɔ́ kɨgɔ̀ mà, kɔ́rɔ́ ngari mànà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tdʉ̌ abádhí òwu rɔ̀, kǎdʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀, ndàtɨ: «Ɔ̀nyʉ̀ t’óguta-kàsʉ̌ rɨ̌’ɨ̀ abhɔ nyʉ́, pbɛ́tʉ̀ ndɨ ɔ̀nyʉ̀ ògu rɨ́ alɛ rɨ̌’ɨ̀ ngúfe. Nɨ́ nyɨ̀tsɔ̀ nyɨ̌ ɨnga-àbadhi rɔ̌, ndɨ́nɨ̌ ɔ̀nyʉ̀ t’óguta-kàsʉ̌ t’álɛ-bvʉ nɨtrɔ́ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨ́rɔ̀, nyòwu: Kɔ̀nɨ̌ ma mùvǐ nyɨ̌ tàmà bhěyi tsamangɛ̀rɛ̌ nzínzì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Àpɛ́ nyùgu ɨ́sɔ̀wʉ̌ mà, bhɔlɔ mànà. Ndɨrɔ̀, àpɛ́ nyùgu kàyìtò. Àpɛ́ nyòwu ìko rɔ̌ ìko tɨ́ otu ɔ̌, atdí alɛ mà nátsɛ nyɨ̌ nyɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Atdí ɨdza ɔ̀ nyɨ̌ nyòtsù rɔ̀, nyɨ̌ nyowuna ányɨ̀ ɨdzá-bhà àtsɛ̀ rɔ̌ angyi nyǎtɨ: ‹Màrʉ̀ngà àkǎ ndɨ̀’ɨ̀ àzú-dzá.› ");
INSERT INTO niy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Màrʉ̀ngà nòzè atdí alɛ mà nɨ́’ɨ̀ ányɨ̀-dzá rɔ̀, nɨ́ wɔ̀ nyɨ̌ nyòzè rɨ̀’ɨ̀ ányɨ̀-dzá màrʉ̀ngà náarana ɨ̀’ɨ̀ rɔ̌ ndɨ alɛ tɔ̀. Pbɛ́tʉ̀, ɨ̀mbǎ nyǎkɔ̌ rɨ̌ màrʉ̀ngà ɔ̌ alɛ nɨ́’ɨ̀ rɔ̀, ndɨ màrʉ̀ngà arana ndàdu rɔ̌ fʉkʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nyɨ̌ ka kàkɔ ɔ̀ná ɨdza ɔ̌, nyɨ̌ nyowuna òko rɔ̌ ányɨ̀-dzá tɨ́. Ndɨrɔ̀ nyɨ̌ nyowuna fʉ̌kʉ̀ ka kàbhʉ dhu kɛ̀lɛ̌ nɔ́nyʉ̀ rɔ̌, nyǎdʉ̀ fʉ̌kʉ̀ ka kàbhʉ dhu kɛ̀lɛ̌ nɔ́mvʉ̀. Obhó tɨ́ kasʉtálɛ nákǎ ndàbà pbɨ̀ndà mʉ̀kɨ̀mbà. Àpɛ́ nyòwu ʉ̀da rɔ̌ atdí ɨdza ɔ̀ rɔ̀ ngǎtsi ɨdza ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Atdí kɨgɔ̀ ɔ̀ nyɨ̌ nyòtsù, kadʉ̀ nyǎkɔ rɔ̀, nyɨ̌ nyowuna fʉ̌kʉ̀ ka kàbhʉ dhu nɔ́nyʉ̀ rɔ̌ ɔ̀nyʉ. ");
INSERT INTO niy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nyɨ̌ nyowuna ndɨ kɨgɔ̀ ɔ̌ andɨ nà alɛ nɨ́gʉ rɔ̌, nyǎdʉ̀ àtɨ̀nà ndɨ kɨgɔ̀ ɔ̌ bhà nɨ̌: ‹Kàgàwà rɨ̌ idzi ɔ̀nyʉ dʉ̀kʉ́ ɔ̀ná kàsʉmɨ̀ níndù wà ndɨ̀.› ");
INSERT INTO niy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pbɛ́tʉ̀, atdí kɨgɔ̀ ɔ̀ nyɨ̌ nyòtsù, ɨ̀nzɨ̌ kadʉ̀ nyǎkɔ rɔ̀, nyɨ̌ nyowuna ùvò rɔ̌ ndɨ kɨgɔ̀-tsidɔ̌ ngʉdhà ɔ̀, nyǎdʉ̀ àtɨ̀nà ndɨ kɨgɔ̀ ɔ̌ bhà nɨ̌: ");
INSERT INTO niy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Kànɨ̌, mǎ mɔ̀’ɔ̀ wà pfɔ̌ka-tsítsírɔ́ ɨ̀ nʉ̀pbǎ fʉ̀kʉ́ kɨgɔ̀ ɔ̌ àhʉ̀ ròngò dʉ̀kʉ̀. Pbɛ́tʉ̀ nyʉ̀nɨ dhu, Kàgàwà rɨ̌ idzi nɔ́nyʉ ìndrǔ dɔ̌ ɔ̀ná kàsʉmɨ̀ rìndù wà ndɨ̀.› ");
INSERT INTO niy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma mɨ́ dhu ɔ̀vɔ fʉ̌kʉ̀: Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, wɔ̀rɨ́ kɨgɔ̀ dɔ̌ kɔ̌tdɨ́ya anya, ròsè Sɔ̀dɔmɔ̀ tɔ́ kɨgɔ̀ dɔ̌ ndɨ̀ ndatdɨ̀ anya dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Nyɨ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ Kɔ̀ràzinì tɔ́ kɨgɔ̌, ndɨrɔ̀ nyɨ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ Bɛ̀tɛ̀sàyidà tɔ́ kɨgɔ̌! Obhó tɨ́, yà ʉ̀kʉ́ ɨ̀ nɔ̀nzɨ̀ wɨwɨ̀ nɨ́’ɨ̀yana gukyè Tirò mà, Sìdɔnà mànà tɔ́ kɨgɔ̀ ɔ̌ ɨ̀ nɔ́nzɨ̀ dhu tɨ́, nɨ́ ɨ kɨgɔ̀ ɔ̌ alɛ nɨ́’ɨ̀yana angyí nyʉ́ ɨ̀ ʉgɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛ mʉ̀tsɔ rɔ́. Abádhí ɨ’ɨ̀yana ɨwà ɨ̀ ʉfɔ́ gɔ̀nɨ̌yà mbɛrʉ̀ tɨ́ rɔ̀yá, ’àdʉ̀ ohu nʉ́trɔ dɔ̀ya ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nɨ́rɔ̀, Kàgàwà rɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀ nɨ́nganɨ́, kɨ̌tdɨ̀ya dhu dʉ̀kʉ́ abhàbhɔ́ nyʉ́, ròsè Tirò mà Sìdɔnà mànà tɔ́ kɨgɔ̀ dɔ̌ ndɨ̀ ndɨtdɨ̀ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ndɨrɔ̀ ɨnyɨ Kàpɛ̀rnàwumǔ, nyɨ nyà’ù tɨ́ dhu ɨ̀dzɨ̌ Kàgàwà ràrǎdʉ̀ nyɨdzɨ ɔ̀rʉ̀-akpà ɔ̀? Pbɛ́tʉ̀ kà rɨ̌ nyifǒ obvò, ndàdʉ̀ nyabhʉ nyarà àhʉ ɔvɛ-bvʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsʉ̀kʉ́ dhu nɨ̀rɨ̀ alɛ nɨ́rɨ̀ wà tsʉ̀dú dhu. Ndɨrɔ̀, ɨnzá nyɨ̌ nàkɔ alɛ nákɔ nzá ɨma átɔ̀. Ndɨrɔ̀, ɨnzá ɨma nàkɔ alɛ nákɔ nzá yà ɨma nívì alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kɔ̌kɔ̀ Yěsù ùvinà àrʉ̀bhʉ̀ kumì dɔ̀ná ɔ́yɔ̌ nà pbɨ̀ndà ábhàlɨ̌ náadù ɨ̀ atdídɔ̌ nyʉ́ ɨdhɛ̀ya nɨ́ka ɨ̀ rɔ́rɔ̀. Nɨ́, abádhí adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, nzɛ́rɛ-alafí mà nɨ́rɨ̀ tsʉ̀ká dhu, ɔvɔ̀nʉ rɔ̌ mǎ mòdì ɨ̀ rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma màla àlǎ Sìtanɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɨ́tsɨ̀, ràmbɨlɨ ɔvɔ bhěyi rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kɔ̀nɨ̌ ma màbhʉ wà ádrʉ̀ngbǎnga tɔ́ ɔbɨ fʉ̌kʉ̀, ndɨ́nɨ̌ nyɨ̌ nyɔbɛ́ tɨ́ osu mà áwɨ̀ya nɨ̌ arɨ́ ìndrǔ ʉ̀bɨ̌ àwǔ-tɨdɔ̀ mànà-ɔ̌nga nɨ̌. Ndɨrɔ̀ ma màbhʉ wà ɔbɨ fʉ̌kʉ̀ ndɨ́nɨ̌ nyɨ̌ nyɔnzɨ tɨ́ wɔ̀ òmvǔ bhà kɔ́rɔ́ ɔbɨ lɛ̀mà nɨ̌. Ndɨrɔ̀, nyɔ̌nzɨ rɨ́ nzɛ́rɛ atdí dhu mà rɨ̌’ɨ̀ ɨ̀mbǎ. ");
INSERT INTO niy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pbɛ́tʉ̀, dhu àkǎ nzá ɨdhɛ̀kʉ rɨ̀ka ndɨ̀ nzɛ́rɛ-alafí rǒwu tsʉ̀kʉ́ dhu ɨ̀rɨ̀ rɔ̌ dhu-okú dɔ̀ rɔ̀. Dhu àkǎ kà rɨ̀ka ndɨ̀ ɨwà ka kúndǐ ɔvɔ̀kʉ ɔ̀rʉ̀-akpà ɔ̀ dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí náabhʉ̀ Yěsù ɨdhɛ̀na rɨ̀ka ndɨ̀ atdídɔ̌. Nɨ́ kǎtɨ: «Ɔ̀ɔ Àba Kàgàwà, ɔ̀rʉ̀-akpà mà yà adzɨ mànà ɔ̌ Ádrʉ̀ngbǎlɛ́, ma mìlè nyɨ atdídɔ̌ nyʉ́, yà ɨnga nʉ́nɨ, ’àdʉ̀ dhu-ɔ̌nga t’óvòta nʉ́nɨ alɛ rɔ̌ nyɨ nyarù dhu nɨ́ nyɨ nyábhʉ ɨ̀nzɨ̌ ka kádʉ̀ ɔ̀zʉ̀nà dhu tɨ́ alɛ nyʉ́ rʉ̀nɨ dhu-okú dɔ̀ rɔ̀. Obhó tɨ́ Àbá, wɔ̀ dhu bhěyi nɨ́ ndɨ nyɨ nyazè ndɨ dhu rɔ̀nzɨ̀ ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Àbadu níibho wà kɔ́rɔ́ dhu fudú, ndɨrɔ̀ atdí alɛ mà nʉ́nɨ nzá àdhɨ mà ràrɨ̌ Kàgàwà t’ídhùnà, pbɛ́tʉ̀ ka nʉ́nɨ nɨ́ kà t’Ábanà kɛ̀lɛ̌. Ndɨrɔ̀, atdí alɛ mà nʉ́nɨ nzá Àba ràrɨ̌ àdhɨ mà dhu, pbɛ́tʉ̀ ka nʉ́nɨ nɨ́ kà t’ídhùnà kɛ̀lɛ̌, ndɨrɔ̀ yà kǒzè ndɨ̀tɛ̀ ka fɨ̌yɔ̀ alɛ mànà.» ");
INSERT INTO niy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wɔ̀ dhu-dzidɔ̌, Yěsù agɛ́rɛ́ ndɨ̀ pbɨ̀ndà ábhàlɨ̌ dɔ̀, ndàdʉ̀ dhu ɔ̀vɔ̀ fɨ̌yɔ̀ tɨ́ ɔ̀yá, ndàtɨ: «Hirò nɔ̀nzɨ̀ alɛ nɨ́ yà nyɨ̌ nyálǎna dhu àlǎ rɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: ábhɔ̌ pbànábí nyʉ́, ábhɔ̌ ádrɔ̀drɔ̌ pbàkámá mànà nɨ́ɨ’ɨ̀ dhu-atdyú nà ’àla yà nyɨ̌ nyálǎna dhu, pbɛ́tʉ̀ abádhí adʉ̀ nzá ɨ dhu nála. Ndɨrɔ̀, abádhí ɨ’ɨ̀ dhu-atdyú nà ’ɨ̀rɨ̀ yà nyɨ̌ nyɨ́rɨna dhu, pbɛ́tʉ̀ abádhí adʉ̀ nzá ɨ dhu nɨ́rɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ʉyátá tɔ́ atdí màlimò nɨ́ɨvà ndɨ̀ ndìvǔ dhu Yěsù-tsʉ̌ kà-afí ndɨ̀ ndomvú tɨ́ nɨ̌, ndàtɨ: «Màlimǒ, ádhu ndɨ àkǎkǎ mɔnzɨ̀, ndɨ́nɨ̌ ma mabá tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga?» ");
INSERT INTO niy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ádhu àlɛ̌ tɔ́ Ʉyátá ɔ̀ ka kándǐ? Ádhu kà ɔ̀ nyɨ nyarɨ́ ɔ̀zʉ̀na?» ");
INSERT INTO niy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wɔ̀ alɛ náadʉ̀ dhu àdu ndàtɨ: «Dhu àkǎ nyozè pbʉ̀kʉ̀ Ádrʉ̀ngbǎlɛ Kàgàwà kɔ́rɔ́ afínʉ nyʉ́ nà, kɔ́rɔ́ atdyúnʉ nà, kɔ́rɔ́ ɔbɨ̀nʉ nà, ndɨrɔ̀ kɔ́rɔ́ pbʉ̀kʉ̀ ɨrɛ̀ta mànà. Ndɨrɔ̀, dhu àkǎ nyozè ɔdhɨ̀nʉ yà nyɨ nyʉ́ nyɨ nyózè nyɨ nyɨ-tɨ́rɔ̀ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Nyɨ nyɔ̀tɛ̀ mběyi nyʉ́. Ɔ́nzɨ ka, nɨ́ nyɨ nyádʉ̀ ípìrɔ̌nga nábà.» ");
INSERT INTO niy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pbɛ́tʉ̀, wɔ̀ Ʉyátá tɔ́ màlimò náazè ndòlè dhu fɨ̌ndà. Nɨ́ kǎdʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Ɔdhɨ̀du nɨ́ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ yàrɨ́ mbólí náwɛ. Kǎtɨ: «Atdí alɛ núubhínà àwǔ rɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀, ndàmbɛ àrà dɔ̌ Yɛ̀rɨkɔ̀ tɔ́ kɨgɔ̀ ɔ̀. Nɨ́ otu ɔ̌, ogbotálɛ náakɛ̀rɛ̀ ka, ’àdʉ̀ kɔ̀ngbʉ̀, ’àdʉ̀ kàrɔ̌ mʉ̀dzarʉ̀ nʉ́dha, ’àdʉ̀ òwu fɨ̀yɔ́ dhu nɨ̌, ’ʉ̀bhà àbadhi ɨwà ɔvɛ-ngbɔ̀ nɔ̀fɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nɨ́ pbǎ ngbɔrɔ́ rɔ̀, atdí kùhanɨ̀ núubhínà ʉ̀da rɔ̌ wɔ̀ otu ɔ̌. Nɨ́ ndɨ alɛ ndɨ̀ ndàla rɔ̀, wɔ̀ kùhanɨ̀ nʉ́ʉdà otu-igì dɔ̀, ndàdʉ̀ àrà fɨ̀ndá dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ndɨrɔ̀, atdí Mʉ̀lawì nɨ́ɨra àhʉ ányɨ̀rɔ̌ ndɨ dhu bhěyi tɨ́. Nɨ́, kǎndrì ndàla wɔ̀rɨ́ alɛ, ndàdʉ̀ pbɨ̀ndà otu nága igi, ndàdʉ̀ àrà. ");
INSERT INTO niy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pbɛ́tʉ̀, Sàmàrɨyà tɔ́ pbìrì ɔ̌ atdí alɛ, wɔ̀ ndɨ otu ɔ̌ rárà, náarà àhʉ wɔ̀ ngbɔ̌na àvɔ alɛ tɨ́. Nɨ́ ka ndɨ̀ ndàla rɔ̀, àbadhi náadʉ̀ ɨzʉ àbà atdídɔ̌ kàdɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nɨ́, kǎdʉ̀ òndri tdɨ́tdɔ̌ ɨ́kyɛ̀rɔ̌ nyʉ́ kà-tɨ’ɔ̀, ndɨ̀ rʉ̀dhɔ akyɛ, dɨ̀vayì mànà kà-rɔ̌ otú dɔ̌, ndàdʉ̀ ndɨ otú nʉ́tsɨ̀. Tdɨ́tdɔ̌, kǎdʉ̀ kìtdù ndɨ̀lɨ pbɨ̀ndà kayinò dɔ̌, ndàdʉ̀ àrànà olo-dzà ɔ̀. Ányɨ̀, kǎdʉ̀ kàngbɔ̀ nɔ́dɔ̀ mběyi nyʉ́. ");
INSERT INTO niy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tsútsǎ nɨ́nganɨ́, kǐdyi ɔ́yɔ̌ fʉ̀rangà-kpɔ̌ ndàbhʉ olo-dzà-àbadhi-fɔ́, ndàdʉ̀ àtɨ̀nà kà nɨ̌: ‹Ɔ́dɔ yàrɨ́ alɛ mběyi. Tdɨ́tdɔ̌ ma mʉ́da ɨrɔ́ rɔ̀, ma mítsi kǒkú dɔ̀ rɔ̀ nyɨ nyìwǐ tdɨ́tdɔ̌ dhu núbho ɨndʉ̀ ma-tɨ́rɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wɔ̀rɨ́ mbólí dzidɔ̌, Yěsù adʉ̀ dhu ìvu ndàtɨ: «Ádhɨ ndɨ kɔ̌kɔ̀ ɨ̀bhʉ alɛ nzínzì ɔ̌ ndɨ̀ nàvi nyɨ̀kpɔ́nʉ ɔ̌ wɔ̀ ogbotálɛ angbʉ̀ alɛ t’ɔ́dhɨ̀nà tɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nɨ́, Ʉyátá tɔ́ màlimò náadʉ̀ dhu àdu, ndàtɨ: «Yà ídzìnga nɔ̀nzɨ̀ kà tɔ̀ alɛ.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyʉ́ mà átɔ̀, árà, nyadʉ̀ dhu ɔ̀nzɨ̀ ndɨ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà rɨ̌’ɨ̀ abhi ɔ̌ rɔ̀, nɨ́ abádhí awù òtsù atdí pbanga ɔ̀. Ndɨ pbanga ɔ̌, Màrɨtà tɨ́ kátɨna atdí tsìbhálɛ náakɔ̀ abádhí pbɨ̀ ɨdzá. ");
INSERT INTO niy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ndɨ Màrɨtà nɨ́ɨ’ɨ̀ ìnè Màrɨyà tɨ́ kátɨna awɛ̀nà nà. Nɨ́, ndɨ Màrɨyà náadɨ̀ Ádrʉ̀ngbǎlɛ Yěsù tɨ́ ɨ́kyɛ̀rɔ̌ nyʉ́, ndàmbɛ kà rʉ̌nɔna dhu nɨ́rɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pbɛ́tʉ̀, Màrɨtà adʉ̀ ɨ̀’ɨ̀ atdídɔ̌ ɨdzá ábhɔ̌ kasʉ náva tsìna rɔ́. Nɨ́, ɨ́yàdhíyà arà Yěsù-tɨ’ɔ̀ ndɨ dhu-okú dɔ̀ rɔ̀. Kǎtɨ: «Ádrʉ̀ngbǎlɛ́, wɔ̀ awɛ̀du ʉ̀bhà ɨma, mambɛ kasʉ ɔ̀nzɨ̀ dɔ̌ atdírɔ̀ dhu nɔ́nzɨ̀ tɨ́ nzá atdí dhu mà rʉ̀nʉ́? Nɨ́rɔ̀, ávǐ ka rɨ̀rà dzʉ̀nàdu ɔ̀nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nɨ́, Ádrʉ̀ngbǎlɛ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Màrɨtà! Màrɨtà! Nyɨ nyɨ́ ɨnga ɨ̀rɛ̀ abhɔ, tsìnʉ ràdʉ̀ ndàva ábhɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Atdí dhu kɛ̀lɛ̌ nɨ́ ndɨ àkǎkǎ dhu tɨ́ rɨ̌’ɨ̀. Màrɨyà òvò ídzì dhu nyʉ́, yà ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ àkɔnà fɔná rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Atdíku Yěsù náadɨ̀ ndàmbɛ ndɨ̀tsɔ̀ dɔ̌ atdí ngari ɔ̌ rɔ̀. Nɨ́ kǐtdègu ɨtsɔ̀ta nɨ́tɔ, nɨ́ kàbhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ náatɨ kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, údhě mǎ màkǎ mǒngò mɨ̌tsɔ̀ tɨ́ dhu fǎkà, àdhàdhɨ̀ Bàtizò nubhónà Yùwanɨ̀ núudhè ka pbɨ̀ndà ábhàlɨ̌ tɔ̀ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌tsɔ̀ nyɨ̌ nyɨ́ rɔ̀, nyòngò àtɨ̀nà: ‹Àbakǎ, ɔvɔ̀nʉ àkǎ kʉnɨ Ɨ̀lɨ̌lǎ Ɔvɔ tɨ́. Ábhʉ̌ dɔ̀ká nyɨ nyɨ́ idzi ɔ̀nyʉ ɔ̀ná ɨdhɔ ràkǎ. ");
INSERT INTO niy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Óngò mǎ’ɨ nà rákǎ ɔ̀nyʉ̀ níbhò fǎkà bìlǐnganà. ");
INSERT INTO niy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ʉ́bà fàká nzɛ́rɛnga fǎkà, átɔ̀ mǎ marɨ́ dhu ʉ̀ba ɔnzɨ̀ká dhu nʉ̀fǎ alɛ tɔ̀ nɨ́dhunɨ̌. Ndɨrɔ̀, àpɛ́ nyabhʉ̀ mǎ mǒtsù umvútá ɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tdɨ́tdɔ̌, kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Atdí nzínzìkʉ ɔ̌ alɛ rɨ̀’ɨ̀ ɔdhɨ̀nà nà, ndàdʉ̀ ndɨ̀và ndàrà iku-alìkpa ɔ̌ ndɨ ɔdhɨ̀nà bhà, ndìtsì àtɨ̀nà kà nɨ̌: ‹Ɔdhɨ́, íbhò pɛ́ ɨ̀bhʉ mʉ̀gatì mʉwʉ fʉnʉ́, ");
INSERT INTO niy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","atdí ɔdhɨ̀du nɨ́rà àhʉ pbàkà, abhi ɔ̀nǎ rɔ̀, nɨ́ ma mábhʉ̌na kà rɔ̀nyʉ̀ dhʉ rɨ̌’ɨ̀ ɨ̀mbǎ akɛkpá màtɨ́ fudú.› ");
INSERT INTO niy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nɨ́, ɨdza nǎ rɔ̀ wɔ̀ alɛ náapɛ́ àdʉ̀ dhu àdu ndàtɨ: ‹Ɨ̀nzɨ̌ ávǎ tsìdu. Tsǎtsʉ̀ ka kàpbǐ wà. Mǎ mòyì wà pbàkà inzo mànà. Nɨ́, ma mɨ́ nzɨ̌ mɨvà marà mʉ̀gatì àbhʉ ɨndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nɨ́ ma mɨ́ dhu ɔ̀vɔ kpangba fʉ̌kʉ̀: wɔ̀ alɛ rɨ̌ mbǎ àdʉ̀ àdɨ ɨ̀nzɨ̌ ndɨ̀và ndɨ̀, ndɨ̀rà mʉ̀gatì àbhʉ kà tɔ̀ ɔdhɨ̀nà tɨ́ kà rɨ̌ dhu-okú dɔ̀ rɔ̀, pbɛ́tʉ̀ kà rǎdʉ̀ ndɨ̀và, ndàdʉ̀ kɔ́rɔ́ dhu yà kà rɨ̌ atdyúna òho nábhʉ kà tɔ̀ dhu nɨ́, ɨ̀nzɨ̌ ndɨ̀ ndɨ́ ndɨ̀ngyɛ̌ rɔ́rɔ̀ kà rǔbhi kònzì rɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɨ́rɔ̀, ma mátɨna nyɨ̌ nɨ̌: dhu àkǎ nyǒnzì dhu, ndɨrɔ̀ nɨ́ ndɨ ka kádʉ̀ kàbhʉ fʉ̌kʉ̀. Dhu àkǎ nyɔ̌nɛ̀ dhu, nɨ́ ndɨ nyɨ̌ nyádʉ̀ kàbà. Ndɨrɔ̀ dhu àkǎ nyɨ̌tdɔ̌ tsǎtsʉ̀, nɨ́ ka kádʉ̀ kàpfò fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Obhó tɨ́, dhu nònzì alɛ tɔ̀ ka kádʉ̀ dhu àbhʉ. Dhu nɔ̀nɛ̀ alɛ, rǎdʉ̀ dhu àbà. Ndɨrɔ̀, tsǎtsʉ̀ nɨ̀tdɔ̌ alɛ nɨ́ tɔ̀ ka kádʉ̀ tsǎtsʉ̀ àpfò. ");
INSERT INTO niy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ádhɨ pbá alɛ t’ábanà ndɨ idhùnà nónzì ɨ̀bhɛ̀ fɔná rɔ̀ rádʉ̀ osu nábhʉ kà tɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ndɨrɔ̀ ngǎtsi nɨ̌, idhùnà nónzì à’ʉ̌-bhǐ fɔná rɔ̀, kà t’ádʉ̀ áwɨ̀na nɨ̌ arɨ́ ìndrǔ ʉ̀bɨ̌ àwǔ-tɨdɔ̀ nábhʉ àbhʉ̌ kà tɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nɨ́rɔ̀ nyɨ̌ nyʉ́ ngà, nzɛ́rɛ alɛ tɨ́rɔ̀ nyɨ̌ nyárɨ́ ídzì dhu núbhǒ fʉ̀kʉ́ nzónzo tɔ̀ rɔ̀, ɔ̀rʉ̀-akpà ɔ̀ arɨ́’ɨ̀ Àbakʉ rǎdʉ̀ àdɨ ɨ̀ngbà dhu bhěyi ɨ̀nzɨ̌ ndàbhʉ Ɨ̀lɨ̌lǎ-Alafí ka nònzì fɔná alɛ tɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Atdíku Yěsù adɨ̀ ndàmbɛ atdí alɛ nábhʉ ròngò ìwǐ tɨ́ nzɛ́rɛ-alafí nípfo dɔ̌ ndɨ alɛ ɔ̀ rɔ̀. Nɨ́ nzɛ́rɛ-alafí níitdègu àhʉ, nɨ́ ndɨ alɛ adʉ̀ ndɔ̀pɛ̀ ndɔ̀tɛ̀, ɨdhɔ ràdʉ̀ ihé-yà nʉ́kɔ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pbɛ́tʉ̀, ngúfe alɛ adʉ̀ àtɨ̀nà: «Kàrɨ̌ nzɛ́rɛ-alafí nódì Bɛ̀lìzèbulì tɨ́ kátɨna nzɛ́rɛ-alafí dɔ̌ ádrʉ̀ngbǎlɛ bhà ɔbɨ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ngʉ̌kpǎkà-tsí náazè ’òmvù Yěsù-afí. Nɨ́, abádhí náavì ka rɔ̀nzɨ̀ atdí wɨwɨ̀, ndɨ́nɨ̌ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ kàbhà ɔbɨ ɨ́rà dhu navì tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pbɛ́tʉ̀ Yěsù nʉ́ʉnɨ abádhí rɨ̌rɛ̀na dhu angyangyɨ. Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ-ɔ̌nga náapɛ́ àdʉ̀ ndʉ̀ndɔ̀, nɨ́ ndɨ ádrʉ̀ngbǎ kamà bhà idzi-tsʉ̀ rǎdʉ̀ ndɔ̀dɨ̀ ɔ̀dɨ̀ tɨ́, ɔ̀ná ɨdza ràdʉ̀ ’ùgolo, atdídhená ɨdza ràdrù ɨ̀ ngʉ̌kpà ɨdza dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɨ́ Pfɔ̀mvɔ náapɛ́ àmbɛ ndùgyè dɔ̌ ndɨ̀tɨ́rɔ̀, nɨ́ kàbhà idzi rǎdʉ̀ àdɨ ɨ̀ngbà dhu bhěyi ɨ̀nzɨ̌ tsʉ̀na rɔ̀dɨ̀ ndɨ̀, wɔ̀ nyɨ̌ nyátɨna Bɛ̀lìzèbulì bhà ɔbɨ nɨ̌ ma rarɨ́ nzɛ́rɛ-alafí nódì rɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ndɨrɔ̀, dhu apɛ́ ɨ̀’ɨ̀ Bɛ̀lìzèbulì bhà ɔbɨ nɨ̌ ma marɨ́ nzɛ́rɛ-alafí nódì dhu tɨ́, nɨ́ fʉ̀kʉ́ alɛ náarádʉ̀ kòdì àdhɨ bhà ɔbɨ nɨ̌? Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ɨ fʉ̀kʉ́ alɛ nʉ́ʉnɔya ndɨ ànyǎkʉ. ");
INSERT INTO niy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pbɛ́tʉ̀, dhu apɛ́ ɨ̀’ɨ̀ ma marɨ́ nzɛ́rɛ-alafí nípfǒ modì ìndrǔ ɔ̀ rɔ̀ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ dhu tɨ́, nɨ́ nyʉ̀nɨ dhu Kàgàwà rɨ̌ idzi ɔ̀nyʉ dʉ̀kʉ́ ɔ̀ná ɨdhɔ nákǎ wà. ");
INSERT INTO niy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɔbɨ nà atdí alɛ, ndàdʉ̀ ɨ̀’ɨ̀ kɔ́rɔ́ fɨ̀ndá màtsǔmù nà, náapɛ́ àmbɛ pbɨ̀ndà pbanga-ngbɔ̀ nɔ́dɔ̀ dɔ̌, nɨ́ kàbhà dhu-tsí rǎdʉ̀ òko mběyi, ɨ̀nzɨ̌ kɨnza. ");
INSERT INTO niy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pbɛ́tʉ̀ ngǎtsi alɛ yà ɨ̀dzɨ̌dzɔ̀ ròsè kà dɔ̀nǎ náapɛ́ àdʉ̀ ɨ̀rà àhʉ, ndàdʉ̀ kà lɛ̀mà nɔ́nzɨ̀, ndʉ̀dhǎ yà kǎrɨ́ ndɔ̀yɔ̀ rɔ̀yá kɔ́rɔ́ kà-fɔ́ màtsǔmù, nɨ́ ndɨ alɛ rǎdʉ̀ kà-fɔ́ rɔ̀ ndɨ̀ ndʉ̀dhǎ dhu nʉ́ndɔ̀ ɔdhɨ́na tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɨ̀mbǎ rɨ́’ɨ̀ tɨdu ɔ̀nǎ rɔ̀ alɛ nɨ́ pbàkà òmvǔ, ndɨrɔ̀ ɨ̀nzɨ̌ rɨ́ dhu-tsʉ̀ ùndǔ atdíkpá ɨma mànà alɛ nɨ́ rɨ̌ dhu ɨ̀nda ɨ̀nda tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nzɛ́rɛ-alafí náapɛ́ àhʉ atdí alɛ ɔ̀ rɔ̀, nɨ́ ndɨ nzɛ́rɛ-alafí náarɨ́ àrà, ndùbhi rʉ̀ngʉ̀ ɔ̀nǎ màtɨ́ ndàmbɛ ndɨ̀ ndárà ndàso rɔ́nga nɔ́mɛ̀ dɔ̌. Nɨ́ ɨnzá ndɨ̀ ndàbà ka rɔ̀, kà rǎdʉ̀ àtɨ̀nà: ‹Ma mɨ́ madǔ yà ma mahʉ̀ ɔ̀nà rɔ̀ pbà ɨdza ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ányɨ̀ ndɨ̀ ndàrà àhʉ rɔ̀, kà rɨ̌ ányɨ̀-dzá nga nótù ɨwà ka kàtsù, kadʉ̀ nyɨ̀natɨ̀ òhù mběyi nyʉ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nɨ́rɔ̀ nɨ́ ndɨ kà rǎdʉ̀ àrà àrʉ̀bhʉ̀ ngʉ̌kpà nzɛ́rɛ-alafí, atdídɔ̌ fɨ̀yɔ́ nzɛ́rɛnga-ɔbɨ̀ ósè pbɨ̀ndà ɔbɨ dɔ̀na nǎ núnzì, ’ìwǔ òko mànà atdíkpá ndɨ alɛ ɔ̀. Nɨ́ wɔ̀ dhu-dzidɔ̌, ndɨ alɛ bhà ɔ́fɔ̀ rǎdʉ̀ ɨ̀’ɨ̀ nzɛ́rɛ nyʉ́ ròsè yà angyi ɨ̀’ɨ̀ kàbhà ɔ́fɔ̀ dɔ̀nǎ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wɔ̀ dhu bhěyi Yěsù rɔ̌tɛ ɔ̀ná kàsʉmɨ̀ ɔ̌, atdí tsìbhálɛ náatɨ kà nɨ̌ ihé-yà nzínzì ɔ̀ rɔ̀: «Ɨndʉ́ ari ayɔ̀ finatsʉ̀ ɔ̀, nyadʉ̀ ɨbàna òndò tsìbhálɛ nɔ́nzɨ̀ wà hirò.» ");
INSERT INTO niy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pbɛ́tʉ̀, Yěsù adʉ̀ dhu àdu ndàtɨ: «Hirò nyʉ́ nɔ́nzɨ̀ alɛ nɨ́ yà Kàgàwà bhà Ɔtɛ nɨ́rɨ arɨ́, ’àdʉ̀ ndɨ Ɔtɛ rʉ̌nɔna dhu nɔ́nzɨ̀ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ihé-yà níitdègu ’ɔ̀pɛ̀ ’àndu ɨ̀ Yěsù tɨ́, nɨ́ Yěsù adʉ̀ ɔtɛ ɔ̀pɛ̀ ndàtɨ: «Indo arɨ́’ɨ̀ alɛ narɨ́’ɨ̀ nzɛ́rɛ alɛ nyʉ́. Abádhí nózè kɔnzɨ̀ wɨwɨ̀ kɛ̀lɛ̌ fɨ̌yɔ̀. Pbɛ́tʉ̀, ka kɨ́ nzɨ̌ atdí ngǎtsi wɨwɨ̀ mà nɨ́tɛ̀ abádhí tɔ̀, ɨnzá nɨ́ Yɔ̌nà rɔ̌ ndɨ̀ nanzɨ̀ dhu kɛ̀lɛ̌ nádɨ wɨwɨ̀ tɨ́ abádhí tɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Àdhàdhɨ̀ yà nabì Yɔ̌nà rɔ̌ ndɨ̀ nanzɨ̀ dhu nɨ́ɨ’ɨ̀ wɨwɨ̀ tɨ́ Nìnawè ɔ̌ bhà tɔ̀ dhu bhěyi, Ìndrǔ t’ídhùnà rɔ̌ rɨ́ ndɔ̀nzɨ dhu nɨ́ɨ’ɨya wɨwɨ̀ tɨ́ kǎkà indo arɨ́’ɨ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ndɨrɔ̀ ìndrǔ-ànyǎ nɨ́tdɨ̀ ka kɨ́ nɨ́nganɨ́, Sabà tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ tsìbhá kamà nɨ́ɨvàya ndɨ̀, ndìdè indo arɨ́ alɛ-nyɨ̀kpa rɔ̌, ndàdʉ̀ abádhí-ànyǎ nɨ́tdɨ̀. Obhó tɨ́, kɨ̌ra yà adzɨ-tsʉ̀ adɨ̀ ndɨ̀ ɨ rɔ̀, ndɨ̀rà dhu-ɔ̌nga t’óvòta nʉnɨ ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ rʉ̌nɔna dhu nɨ́rɨ̀. Ndɨrɔ̀ nyʉ̀nɨ dhu, yà ɔnzɨ̀kʉ́ ìdè alɛ nósè wà Sɔ̀lɔ̀mɔnɨ̀ dɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndɨrɔ̀, ìndrǔ-ànyǎ nɨ́tdɨ̀ ka kɨ́ nɨ́nganɨ́, Nìnawè ɔ̌ bhà nɨ́ɨvàya ɨ̀, ’ìkò kǎkà indo arɨ́ alɛ-nyɨ̀kpa rɔ̌, ’àdʉ̀ abádhí-ànyǎ nɨ́tdɨ̀. Obhó tɨ́, Nìnawè ɔ̌ bhà nʉ́ʉgɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛ mʉ̀tsɔ Yɔ̌nà rʉ̌nɔna dhu ɨ̀ ɨ̀rɨ̀ rɔ̀. Ndɨrɔ̀ nyʉ̀nɨ dhu ɨrɔ́ rɨ́’ɨ̀ alɛ rʉ̀dà wà Yɔ̌nà dɔ̀nǎ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tdɨ́tdɔ̌ Yěsù adʉ̀ ɔtɛ ìse ndàtɨ: «Atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ tarà nɔ́bɨ̀, ndàdʉ̀ ɨ̀lɨnà ndɨ̀ nórù ngari ɔ̌, ngǎtsi nɨ̌ ndàdʉ̀ àtsìnà ɨ̀tǎ-tsì. Pbɛ́tʉ̀ kà rǎdʉ̀ kɔ̀bɨ̀, ndàdʉ̀ àgʉ̀rʉ̀nà ɔrʉ́, ndɨ́nɨ̌ ɨdza rítsù alɛ-nyɨ̌nga nawʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nyɨ̀kpɔ́nʉ rɨ̌’ɨ̀ àdhàdhɨ̀ ngbɔ̌nʉ náwʉ̀ rɨ́ tarà bhěyi. Nyɨ̀kpɔ́nʉ náapɛ́ ɨ̀’ɨ̀ ídzì rɔ̌ rɔ̀, nɨ́ kɔ́rɔ́ ngbɔ̌nʉ rǎdʉ̀ ɨ̀’ɨ̀ awáwʉ̀ ɔ̌. Pbɛ́tʉ̀ nyɨ̀kpɔ́nʉ náapɛ́ ɨ̀’ɨ̀ mbǎ ídzì rɔ̌ rɔ̀, nɨ́ kɔ́rɔ́ ngbɔ̌nʉ rǎdʉ̀ ɨ̀’ɨ̀ ɨ́nɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɨ́ dhu ɔ̀fɔ̀ nga nyɔdɔ̀ afínʉ ɔ̀ rɨ́’ɨ̀ awáwʉ̀ mběyi, ɨ̀nzɨ̌ ongo tɨ́ ɨ́nɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndɨrɔ̀ kɔ́rɔ́ ngbɔ̌nʉ náapɛ́ àwʉ̀, ɨ̀mbǎ rʉ̀nʉ́ atdí ngari mà rɨ̀’ɨ̀ ɨ́nɔ̀ ɔ̌, nɨ́ kɔ́rɔ́ ngbɔ̌nʉ rǎdʉ̀ àwʉ̀, àdhàdhɨ̀ yà atdídɔ̌ ráwʉ̀ tarà nátdyi ngbɔ̌nʉ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wɔ̀ Yěsù rɔ̌tɛ ɔ̀ná kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, atdí Mʉ̀fàrɨ̀sayò náanzi ka ràrà ɔ̀nyʉ̀ nɔ́nyʉ̀ pbɨ̀ndà. Nɨ́, Yěsù atsù kàbhà ɨdza, ndàdɨ ɔ̀nyʉ̀-tsʉ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nɨ́, ɨdhɔ nʉ́ʉkɔ wɔ̀ Mʉ̀fàrɨ̀sayò atdídɔ̌ nyʉ́ yà Yěsù rɨ̌ ɔ̀nyʉ̀ nɔ́pɛ̀ ndɔ̀nyʉ̀ ɨnzá ndɨ̀ ndù’o ɔtsʉ́na rɔ́rɔ̀ dhu ndɨ̀ ndàla rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pbɛ́tʉ̀, Ádrʉ̀ngbǎlɛ Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Nyɨ̌, Pbàfàrìsáyó tɨ́rɔ̀, Nyɨ̌ nyárɨ́ kɔ́pà mà sǎnɨ̀ mànà ngbɔ̀ kɛ̀lɛ̌ nú’ǒ, pbɛ́tʉ̀ afíkʉ ɔ̀nǎ rɔ̀ nyǎdʉ̀ ɨ̀’ɨ̀ ùlè tɨ́ nyɨ̌ nyùlè ogbo t’ɔ́nzɨta mà, nzɛ́rɛnga t’ɔ́nzɨta mànà-atdyú nɨ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nyɨ̌ nɨ́ ɨ̀mbǎ dɔ̀ya nà alɛ. Kàgàwà, yà alɛ-ngbɔ̀ nanzɨ̀, náanzɨ̀ tɨ́ obhó alɛ-afí átɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nɨ́ dhu àkǎ nyǔbho afíkʉ nyʉ́ ɔ̀ rɔ̀ àhʉ dhu pɛrɛ̀ tɨ́ Kàgàwà tɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ nyɨ̌ nyádʉ̀ ɨ̀lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nyɨ̌ Pbàfàrìsáyó tɨ́rɔ̀, nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌! Nyɨ̌ nyárɨ́ ɔ̀nyʉ̀ nábhʉ̌ arɨ́ ròvù ɨrɨ́-bɨ̌-tɨdɔ̀ mà, kɔ́rɔ́ ìtò-tɨdɔ̀ mànà tɔ́ atdínga ɨdrɛ dɔ̌ núbhǒ pɛrɛ̀ tɨ́ Kàgàwà tɔ̀, nyǎdʉ̀ àdzo obhónánga ɔ̀nzɨ nyɨ̌ nyɨ́ dhu mà, Kàgàwà òzè nyɨ̌ nyɨ́ dhu mànà dhu rɔ̌ rɔ̀. Kɔ̌kɔ̀ nɨ́ ɨ àkǎkǎnà nyɔ̌nzɨ̀ dhu, ɨnzá nyɨ̌ nyàdzo kɔ̌kɔ̀ angyangyɨ nyɨ̌ nyarɔ́nzɨna ngʉ̌kpà dhu rɔ̌ rɔ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nyɨ̌ Pbàfàrìsáyó tɨ́rɔ̀, nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌! Pbàyàhúdí tɔ́ unduta-dzà ɔ̌, nyɨ̌ nyárɨ́ nyǒzè nyǒkò angyinǎ rɔ̀ rɨ́’ɨ̀ tombi dɔ̌, ndɨrɔ̀ ìndrǔ arɨ́ ’ùndǔ ɔ̀yá ngari ɔ̌, nyɨ̌ nyárɨ́ nyǒzè kowù nyǎtsɛ̀ rɔ̌ ɨfʉta nyʉ́ nà! ");
INSERT INTO niy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌! Nyɨ̌ nyʉ́lɨ nyɨ̌ ɨ̀nzɨ̌ arɨ́ ’àlǎ adzɨdɔ, yà ìndrǔ arúbhi dɔ̀yá ɨnzá ɨ̀ ʉ̀nɨ rɔ́rɔ̀ bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tdɨ́tdɔ̌, Ʉyátá tɔ́ atdí màlimò náatɨ Yěsù nɨ̌: «Màlimǒ, wɔ̀ nyɨ nyɔ́tɛna ɔtɛ ɔ̌, nyɨ nyʉ̀nɔ̀ wà dhu mǎ nɨ̌ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Nyɨ̌, Ʉyátá tɔ́ màlímó tɨ́rɔ̀, nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌ átɔ̀! Obhó tɨ́, nyɨ̌ nyárɨ́ odú rɔ́’ɔ ànɔ̀na ka kɨ́ rɔ̀ ànɔ̀ nʉ́gbǎ ìndrǔ dɔ̌, ɨ̀nzɨ̌ nyǎdʉ̀ nyǒzè nyǎpbàlǎ ɨ ànɔ̀-ngbɔ̀ ɔtsʉ́kʉ-dɔ nɨ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌! Nyɨ̌ nyárɨ́ Kàgàwà bhà pbànábí-adzɨ̀dɔ nɔ́rʉ, àzèmbè pbánɨ́ abákʉ kɛ̀lɛ̌ náakyɛ̀ abádhí rɔ́rɔ̀! ");
INSERT INTO niy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wɔ̀ dhu bhěyi nɨ́ ndɨ nyɨ̌ nyɨ̀tɛ̀ dhu kpangba ɨwà nyɨ̌ rà’ù abákʉ anzɨ̀ dhu. Obhó tɨ́, abádhí náakyɛ̀ Kàgàwà bhà pbànábí, ndɨrɔ̀ nyɨ̌ nyarádʉ̀ ɨ pbànábí-adzɨ̀dɔ nɔ́rʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, Kàgàwà náavɔ̀ dhu kpangba dhu-ɔ̌nga t’óvòta tɔ́ pbɨ̀ndà ɨrɛ̀ta nɨ̌ ndàtɨ: ‹Ma mɨ́ pbàkà pbànábí mà, pbàkà uvitatálɛ mànà núvǐ abádhí nzínzì ɔ̀. Nɨ́ abádhí nɔ́ɔkyɛya kɔ̌kɔ̀ ma mòvì alɛ nzínzì ɔ̌ atdídhená alɛ, ’àdʉ̀ àvu ngʉ̌kpà-tsí rɔ̌.› ");
INSERT INTO niy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndɨ dhu bhěyi nɨ́ ndɨ, Kàgàwà nɨ́ɨtdɨ̀ya yà indo arɨ́’ɨ̀ alɛ-ànyǎ, yà yà adzɨ Kàgàwà anzɨ̀na rɔ̀ ndɨ̀ nʉfʉ Kàgàwà bhà pbànábí-azù-okú dɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","rɔ̀pɛ̀ ndɨ̀ Àbělì-azù rɔ̌ rɔ̀, ràrà àhʉ Zàkàrɨyà-azù ɔ̀. Ndɨ Zàkàrɨyà ka kahò Kàgàwà bhà ɨdzá màzàbahʉ̀ mà atdídɔ̌ ɨ́lǎ ngari mànà nzínzì ɔ̌ rɔ̀. Obhó tɨ́, ma mɨ́ kʉ̀nɔ kpangba fʉ̌kʉ̀, Kàgàwà nɨ́ɨtdɨ̀ya yà àkyɛ ka kakyɛ̀ alɛ-abvò-ànyǎ yà indo arɨ́’ɨ̀ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nyɨ̌, Ʉyátá tɔ́ màlímó tɨ́rɔ̀, nyɨ̌ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌! Nyɨ̌ nyɨ́wà ɨnga t’ʉ́nɨta tɔ́ tsǎtsʉ̀ tɔ́ fʉ̀ngʉlà, ɨ̀nzɨ̌ nyǎdʉ̀ nyǒzè nyǒtsù nyɨ̌-tɨ́rɔ̀ ndɨ tsǎtsʉ̀ ɔ̌, ndɨrɔ̀ nyǎdʉ̀ nyǔvo ɨ̀ nòzè ’òtsù kà ɔ̌ alɛ rɔ̌ ɨ̀nzɨ̌ ròtsù!» ");
INSERT INTO niy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yěsù níitdègu ndɨ̀và ʉrɔ́ rɔ̀, nɨ́ Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà náakó atdídɔ̌ kà rɔ̌, ’àdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ ábhɔ̌ dhu nyʉ́ kà-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Abádhí nóowúnà kà-afí nómvù rɔ̌ ɔtɛ nɨ̌ ndɨ́nɨ̌ ɨ̀ idyi tɨ́ kà-ɨdà-dɔ ’àdʉ̀ kɔ̀bhʉ̀ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, ábhɔ̌ ihé-yà náandu ɨ̀ Yěsù tɨ́, ’àkpɔ̀rɔ̀ kà-ngbɔ̀, alɛ-pfɔ̀ kafɔ́ rɔ́nga mà ràwǐ. Nɨ́rɔ̀ nɨ́ ndɨ Yěsù apɛ̀ ndɔ̀tɛ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀ angyi, ndàtɨ: «Nyɔ̀dɔ nyɨ̌ mběyi Pbàfàrìsáyó tɔ́ afi rɔ̌ rɔ̀. Ndɨ afi nɨ́ abádhí tɔ́ ɔyɔyɔ alɛ-ɨdà. ");
INSERT INTO niy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kɔ́rɔ́ dhu-tsí yà ɨ̀ nuru nʉ́ʉnɨya ɨ̀ kpangba. Ndɨrɔ̀ kɔ́rɔ́ dhu-tsí yà ɔ̀dhʉ̌ ɔ̌ aróko nʉ́ʉnɨya ɨ̀ kpangba. ");
INSERT INTO niy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, yà ɨ́nɔ̀ ɔ̌ rɔ̀ nyɨ̌ nyɔ̀tɛ̀ kúbhingá dhu náaraya ndɨ̀rɨ̀ rɔ̌ kpangba awáwʉ̀ ɔ̌. Ndɨrɔ̀, yà bhɛ̀lʉ ɔ̌ nyɨ̌ nyɔ̀tɛ̀ kàluga ɔ̌ rɔ̀ dhu núku rɔ̌ ka kowuya ìkǔ ɔ̌ ɨdza dɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ɔdhɨ́dǔ, ma mɨ́ yà dhu nʉ́nɔ fʉ̌kʉ̀: dhu àkǎ nzá nyɔ̌nzɨ̀ yà ngbɔ̌kʉ kɛ̀lɛ̌ nóho rɨ́, ndɨ dhu-dzidɔ̌ ɨ̀mbǎ ’àdʉ̀ ɨ̀’ɨ̀ rʉ̀kʉ́ ɨ̀ ɔ́nzɨna ngǎtsi dhu nà alɛ-ɔdɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma mɨ́ ɔdɔ̀na àkǎ nyɔ̌nzɨ̀ alɛ nɨ́tɛ̀ fʉ̌kʉ̀. Nyɨ̌ nyàkǎ nyɔ̌nzɨ̀ ɔdɔ̀na alɛ nɨ́ Kàgàwà, yà ìndrǔ ndɨ̀ ndòhò rɔ̀ rádʉ̀ ɨ̀’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà ndòbvù ndɨ alɛ ɨ̀nzɨ̌ arávɛ dhòdhódhónganà kàzʉ ɔ̀ alɛ. Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: ndɨ alɛ nɨ́ ndɨ nyɨ̌ nyàkǎ nyɔ̌nzɨ̀ ɔdɔ̀na. ");
INSERT INTO niy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Imbò àrɛ̀-tʉ́tʉ̌-nzo nódzi ka ka tɨ́ obhó ɔ́yɔ̌ fʉ̀rangà-kpɔ̌-nzo rɔ̌ tɨ́? Pbɛ́tʉ̀, atdí kɔ̌kɔ̀ àrɛ̀-tʉ́tʉ̌-nzo nzínzì ɔ̌ mà náarɨ́ nzɨ̌ àdzo Kàgàwà ɔ̀nǎ rɔ̀ ɨ̀nzɨ̌ kà rɔ̀dɔ̀ ngbɔ̌na. ");
INSERT INTO niy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ndɨrɔ̀ Kàgàwà ʉ́nɨ wà dʉ̀kʉ-ká-vɛ́-bvʉ mà kɔ́rɔ́. Nɨ́ ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ! Obhó tɨ́, fʉ̀kʉ́ ípìrɔ̌nga nósè wà ábhɔ̌ àrɛ̀-tʉ́tʉ̌-nzo tɔ́ ípìrɔ̌nga dɔ̀nǎ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà: «Ma mátɨna nyɨ̌ nɨ̌: ndɨ alɛ náapɛ́ dhu ʉ̀nɔ kpangba ábhɔ̌ alɛ-ɔ̀nzɨ̌ ndàtɨ ndɨ̀ ràrɨ̌ pbàkà alɛ, nɨ́ Ìndrǔ t’ídhùnà náadʉ̀ya àtɨ̀nà átɔ̀ Kàgàwà bhà màlàyíká-ɔ̀nzɨ̌, ndɨ alɛ ràrɨ̌ pbɨ̀ndà alɛ. ");
INSERT INTO niy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pbɛ́tʉ̀, mɔdhɔ rɨ́ ìndrǔ-ɔ̀nzɨ̌ alɛ nɨ́ ma mɔdhɔya átɔ̀ Kàgàwà bhà màlàyíká-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ndɨrɔ̀, Ìndrǔ t’ídhùnà nɨ̌ rɨ́ dhu ʉ̀nɔ nzɛ́rɛ alɛ, náabáya àbà pbɨ̀ndà nzɛ́rɛnga tɔ́ ʉbàta. Pbɛ́tʉ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ̌ rɨ́ dhu ʉ̀nɔ nzɛ́rɛ alɛ, náabáya nzɨ̌ ʉbàta akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nyɨ̌ nà ka kówu ànyǎkʉ kɨtdɨ̀ tɨ́ unduta-dzà ɔ̌ rɔ̀ màtɨ́, pbàkámá-ɔ̀nzɨ̌ rɔ̀ màtɨ́, ndɨrɔ̀ ngǎtsi nɨ̌ pbanga ɔ̌ ádrɔ̀drɔ̌ alɛ-ɔ̀nzɨ̌ rɔ̀ màtɨ́ rɔ̀, nɨ́ àpɛ́ nyǒwuya afíkʉ nítu rɔ̌ nyɨ̌ nyɨ́ rʉ̀kʉ́ dhu nɨ́sɔ̌ tɨ́ dhu mà, ndɨrɔ̀ nyɨ̌ nyʉ́nɔna dhu mà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Obhó tɨ́, Ɨ̀lɨ̌lǎ-Alafí náaraya ndɨ nyɨ̌ nyʉ́nɔna ndɨ kàsʉmɨ̀ ɔ̌ dhu núdhe rɔ̌ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ihé-yà nzínzì ɔ̌ rɔ̀, atdí alɛ náatɨ Yěsù nɨ̌: «Màlimǒ, ávǐ adɔ̀du rʉ̀ndɔ̀ yà àbadu nʉ́ʉbhà ɔ̀vɛ̀ ndɨ̀ ndɔ́vɛ̀ rɔ̀ dhu-ɔ̌nga fɔká.» ");
INSERT INTO niy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ádhɨ ndɨ ɨma nɨ́lɨ ndɨ́nɨ̌ mongó tɨ́ ànyǎkʉ nʉ́nɔ̀, madʉ̀ fʉ̀kʉ́ dhu nʉ́ndɔ̀ fʉkʉ́?» ");
INSERT INTO niy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà kɔ́rɔ́ alɛ nɨ̌: «Nyàndà nga mběyi! Nyɔ̀dɔ nyɨ̌ ábhɔ̌ ongyéngá-atdyú òho nyɨ̌ nyɨ́ nyǎbà dhu rɔ̌ rɔ̀. Obhó tɨ́, ɨ̀nzɨ̌ nɨ́ ábhɔ̌ ongyéngá ndɨ ìndrǔ tɔ̀ rǎdʉ̀ ípìrɔ̌nga nábhʉ.» ");
INSERT INTO niy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù náadʉ̀ yàrɨ́ mbólí náwɛ ihé-yà tɔ̀. Kǎtɨ: «Ònzǒnzì atdí alɛ bhà ɨnga ɔ̌ ɔ̀nyʉ̀ náanzì, ndàdʉ̀ ɔ̀’ɔ̀ mběyi nyʉ́. ");
INSERT INTO niy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nɨ́ kǎdʉ̀ ndɔ̀pɛ̀ ndɨ̀rɛ̀ nga afína ɔ̀, ndàtɨ: ‹Ádhu ndɨ àkǎ àkǎ mɔnzɨ̀ yà ɨ̀mbǎ ma mɨ́’ɨ̀ pbàkà ɔ̀nyʉ̀-tsè-tsʉ̀ núndǔ ma mɨ́ ɔ̀ná ngari nà rɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kànɨ̌ ma mɔ́nzɨna dhu: ma mɨ́ pbàkà ɔ́ngɔ̀lɨ̌ núgòlǒ, madʉ̀ ádrɔ̀drɔ̌ ngʉ̌kpà-tsí nʉ́sɨ. Wɔ̀ dhu-dzidɔ̌, ma mɨ́ kɔ́rɔ́ pbàkà ɔ̀nyʉ̀-tsè mà, kɔ́rɔ́ pbàkà ngʉ̌kpà ongyéngá mànà núndǔ mʉlɨ ɨ ɔ́ngɔ̀lɨ̌ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɨ́rɔ̀ nɨ́ ndɨ ma mɨ́ ɨnga ɨ̀rɛ̀ afídu ɔ̀ matɨ: nyɨ nyɨ́’ɨ̀ ìnè nyɔdɔ rɨ́ ibí atɔ nyʉ́ tɨ́ ábhɔ̌ dhu-tsí-yà nà. Nɨ́ ásǒ nyɨ, ɔ́nyʉ nyɨ, ɔ́mvʉ̀ nyɨ, ndɨrɔ̀ ɔ́nzɨ mʉ̀hɛndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pbɛ́tʉ̀, Kàgàwà náadʉ̀ àtɨ̀nà kànɨ̌: ‹Ɨnyɨ, nyɨ̀kpɔ́na ɔ̌ ìwǐ nà alɛ́, indo yàrɨ́ iku ɔ̌, nyɨ nyɨ́ yàrɨ́ adzɨ nʉ́bha! Nɨ́, yà nyɨ nyúndu nyɔdʉ̀ dhú-yà nʉ́bhà nyɨ nyɨ́ àdhɨ tɔ̀?› ");
INSERT INTO niy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wɔ̀ dhu bhěyi tɨ́ nɨ́ ndɨ ndɨ dhu rɨ̌’ɨ̀ yà dhu-tsʉ̀ ùndǔ arɨ́ fɨ̌ndà, ɨ̀mbǎ ndàdʉ̀ ɨ̀’ɨ̀ ònzìtálɛ tɨ́ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kɔ̀nɨ̌, wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mátɨna nyɨ̌ nɨ̌: dhu ràkǎ nzá nyǐtǔ afíkʉ fʉ̀kʉ́ ípìrɔ̌nga-okú dɔ̀ rɔ̀, ndɨrɔ̀ ngbɔ̌kʉ-okú dɔ̀ rɔ̀ nyǎtɨ, nyɨ̌ ràrɨ̌ àdhu nɔ́nyʉ, ndɨrɔ̀ nyɨ̌ ràrɨ̌ àdhu nʉ́fɔ̌ rʉ̀kʉ́. ");
INSERT INTO niy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Obhó tɨ́, ìndrǔ bhà ípìrɔ̌nga nósè wà ɔ̀nyʉ̀ dɔ̀nǎ, ndɨrɔ̀ alɛ-ngbɔ̀ nósè wà mʉ̀dzarʉ̀ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nyàndà pɛ́ àkʉ̌rʉ̀! Abádhí náarɨ́ nzɨ̌ dhu òzò, ndɨrɔ̀ abádhí náarɨ́ nzɨ̌ ɔ̀nyʉ̀ ògu ɔnzɨ-bvʉ̌ rɔ̀. Ndɨrɔ̀ abádhí-fɔ́, ɔ̀nyʉ̀ ɔ̀dɔ ka karɨ́ ɔ̀yà àrɔ̌ mà, ɔ́ngɔ̀lɨ̌ mànà náarɨ́’ɨ̀ mbǎ. Pbɛ́tʉ̀ Kàgàwà náarɨ́ ndɨ abádhí nóngù! Nɨ́rɔ̀, fʉ̀kʉ́ ípìrɔ̌nga nósè wà atdídɔ̌ kɔ̌kɔ̀rɨ́ àrɛ̀ tɔ́ ípìrɔ̌nga dɔ̀nǎ! ");
INSERT INTO niy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ádhɨ-pbá alɛ ndɨ nzínzìkʉ ɔ̌, wɔ̀ afína ndɨ̀ dìtǔ ndàmbɛ ɨ̀rɛ̀nà dɔ̌ dhu bhěyi, rádʉ̀ ɨdhɔ̀na nɨ́trɔ yà adzɨ ɔ̌ atdí ɨdhɔ nɨ̌ màtɨ́? ");
INSERT INTO niy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɨ́, dhu rɨ̀’ɨ̀ ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ kɔ̌kɔ̀ ɨsɔ́ rɔ́’ɔ dhu bhěyi rólo dhu sɔ̀wɔ̀rɔ̀ nɔ́nzɨ̀ dhu tɨ́, nɨ́ ádhu nyɨ̌ nyádʉ̀ afíkʉ nítu ngʉ̌kpà dhu-tsí nɨ̌ nɨ́? ");
INSERT INTO niy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nyàndà pɛ́ kɔ̌kɔ̀ ɨnga ɔ̌ arɨ́ ɨ̀nga dhu-tsí náarípfǒ tɨ́ dhu. Abádhí náarɨ́ nzɨ̌ kasʉ nɔ́nzɨ, ndɨrɔ̀ abádhí náarɨ́ nzɨ̌ mbɛrʉ̀ nódyù. Pbɛ́tʉ̀ ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ nyʉ́ mà, kɔ́rɔ́ pbɨ̀ndà ònzì-ɨ́yà ɔ̌, náafɔ́ nzá kɔ̀rɨ́ itsu-opfò nzínzì ɔ̌ atdí itsu-opfò tɔ́ aya dɔ̀nǎ màtɨ́ fɨ̀ndá aya rʉ̌da mʉ̀dzarʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɨrɨ́-bɨ̌ nɨ́ indo tɨ́ rɨ́ ndàlǎ ɨnga ɔ̌, tsútsǎ ràdʉ̀ òtdyù, kadʉ̀ òbvùnà kàzʉ ɔ̀ dhu. Pbɛ́tʉ̀ Kàgàwà náarádʉ̀ abádhí ʉ̀fɔ mběyi nyʉ́. Nɨ́ kà tɨ́ nzɨ̌ àdʉ̀ nyʉ̌fɔ mběyi nyʉ́ ròsè ɨ ɨrɨ́-bɨ̌ dɔ̀nǎ màtɨ́, nyɨ̌ ákɛ̌ a’uta nà alɛ́? ");
INSERT INTO niy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nɨ́ nyɨ̌, dhu àkǎ nzá nyǐtǔ afíku, nyǎmbɛ nyɨ̌ nyɔ́nyʉna dhu mà, nyɨ̌ nyɔ́mvʉ̀na dhu mànà dhu nɔ́nɛ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Obhó tɨ́, kɔ́rɔ́ kɔ̌kɔ̀ dhu nɔ́nɛ arɨ́ ɨ̀nzɨ̌ ɨ̀’ɨ́ ɨ̀ngyɛ̌ rɔ́rɔ̀ alɛ nɨ́ yà adzɨ ɔ̌ alɛ, yà ɨnzá Kàgàwà ná’ù. Pbɛ́tʉ̀ nyɨ̌, Àbakʉ Kàgàwà nʉ́nɨ wà dhu nyɨ̌ ràrɨ̌’ɨ̀ ɨ dhu-atdyú nà. ");
INSERT INTO niy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nɨ́rɔ̀, nyɔ̀mɛ pɛ́ Kàgàwà bhà idzi angyi, ndɨrɔ̀ nɨ́ ndɨ kà rǎdʉ̀ kɔ̌kɔ̀ nyɨ̌ nyɨ́ atdyúya òho dhu námà àma tɨ́ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ, wɔ̀ ákɛ̌ tàmà tɔ́ màhǒ-ngba bhěyi nyɨ̌ nyɨ́’ɨ̀ ngúfe rɔ̀! Obhó tɨ́, Àbakʉ-nyɨ̀kpɔ́ dhu ɔ́fɔ̀ wà, ndàbhʉ pbɨ̀ndà Idzi fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyùdzǐ fʉkʉ́ arɨ́’ɨ̀ dhu-tsí, nyǎdʉ̀ nyɨ̌ nyòngyè fʉ̀rangà núbho pɛrɛ̀ tɨ́ nǎkʉ̀tálɛ tɔ̀. Nyɔ̀bhɔlɔ ɨ̀nzɨ̌ rádʉ̀ ’ɨ̀nza ɨ́sɔ̀wʉ̌, nyǎdʉ̀ fʉ̀kʉ́ ongyéngá-tsʉ̀ núndu ɔ̀rʉ̀-akpà ɔ̀. Ányɨ̀, kà rɨ̌ nzɨ̌ àdʉ̀ ndɨ̀ ɨ̀nza, ogbotálɛ mà rɨ̌ nzɨ̌ àdʉ̀ òwu ùvò ányɨ̀, ndɨrɔ̀ akuku mà rɨ̌ nzɨ̌ àdʉ̀ dhu òbhè ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Obhó tɨ́, pbʉ̀kʉ̀ ongyéngá rɨ̌’ɨ̀ ɨ nga nɨ́ ndɨ afínʉ rǎdʉ̀ ɨ̀’ɨ̀ ɔ̀nà átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyòko kɛngɛ̀ dɔ̌, nyǎdʉ̀ mvʉkʉ’ɔ̀ níso kùkyě nɨ̌, fʉ̀kʉ́ tarà ràdʉ̀ òko ɔ̀rʉ̀ ɨ̀ ɔ́rʉ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ndɨrɔ̀, dhu àkǎ nyʉ̌lɨ nyɨ̌ átɔ̀ yà fɨ̀yɔ́ kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɔ́dɔ rɨ́ rìngò àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ ɔ̀ rɔ̀ kasʉtálɛ bhěyi. Nɨ́, kɨ̀rà àhʉ, ndìtsì tsǎtsʉ̀ nɨ́tdɔ rɔ̀, abádhí rǎdʉ̀ tsǎtsʉ̀ nápfò kà tɔ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nɨ́, hirò nɔnzɨya kasʉtálɛ nɨ́ yà fɨ̀yɔ́ ádrʉ̀ngbǎlɛ rɨ̌rà àhʉ dhu nóotúya ípìrɔ̌ rɔ̀ alɛ. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, wɔ̀ kasʉ tɔ́ ádrʉ̀ngbǎlɛ rɨ̌rà àhʉ rɔ̀, kǎfɔ́ya kasʉ tɔ́ pbɨ̀ndà mbɛrʉ̀ rɔ̀ná. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ya pbɨ̀ndà kasʉtálɛ nóhù, ròkò ɔ̀nyʉ̀-tsʉ̀nǎ, ndàdʉ̀ ɔ̀nyʉ̀ nábhʉ abádhí rɔ̀nyʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iku-alìkpa ɔ̌ màtɨ́, ngǎtsi nɨ̌ à’ʉ̌-akpà-ɔ̀ngɔ̌ ɔ̌ màtɨ́ kɨ̀rà àhʉ rɔ̀, hirò nɔnzɨya nɨ́ yà ípìrɔ̌ rɔ̀ kà rǒtùna alɛ. ");
INSERT INTO niy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nyàlʉ̌ yà ma mʉ́nɔna dhu mběyi dʉ̀kʉ ɔ̀. Ɨdza-àbadhi náapɛ́ àdʉ̀ ogbotálɛ rɨ̌rà ɔ̀ná kàsʉmɨ̀ nʉ́nɨ, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ pbɨ̀ndà ɨdza-tsʉ̀ nábhʉ ogbotálɛ rʉ̀kɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɨ́, nyɨ̌ nyʉ́ mà átɔ̀, nyòko nyɨ̀kpɔ́kʉ nà, Ìndrǔ t’ídhùnà nɨ́ɨraya ɨnzá nyɨ̌ nyɨ̀rɛ̀nà ndɨ̀ ndádʉ̀ ɨ̀rà ɔ̀ná dhu tɨ́ kàsʉmɨ̀ ɔ̌ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pɛ́tɛrʉ̀ adʉ̀ dhu ìvu kà-tsʉ̌ ndàtɨ: «Ádrʉ̀ngbǎlɛ́, nyɨ tɨ́ wɔ̀rɨ́ mbólí náwɛ̌ fǎkà tɨ́, ndɨrɔ̀ nyɨ tɨ́ kàwɛ̌ kɔ́rɔ́ alɛ tɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nɨ́, Ádrʉ̀ngbǎlɛ adʉ̀ dhu àdu ndàtɨ: «Ádhɨ-pbá kasʉtálɛ nyɨ̀kpɔ́na ótdyù, yà fɨ̌ndà ka kàvinà dhu ɔ̀nzɨ arɨ́? Ndɨ alɛ nɨ́ ndɨ yà pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ya ɨ̀lɨnà pbɨ̀ndà alɛ dɔ̌ ádrʉ̀ngbǎlɛ tɨ́, ràrà ɔ̀nyʉ̀ nʉ́ndɔ̀ rɔ̌ abádhí tɔ̀ àkǎkǎ kàsʉmɨ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nɨ́ hirò nɔnzɨya kasʉtálɛ nɨ́ yà pbɨ̀ndà ádrʉ̀ngbǎlɛ rǐngo rɔ̀ kà rǒtùna yà fɨ̌ndà ka kavì kasʉ nɔ́nzɨ arɨ́ rɔ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɨ́ɨlɨya ka kɔ́rɔ́ pbɨ̀ndà dhu-tsí dɔ̌ ádrʉ̀ngbǎlɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pbɛ́tʉ̀, wɔ̀ kasʉtálɛ náapɛ́ àdʉ̀ ɨnga nɨ́rɛ̀ afína ɔ̀ ndàtɨ: pbàkà kasʉ tɔ́ ádrʉ̀ngbǎlɛ nɨ́ dhu ʉ́mbɛ̀ wà, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀vɨ̀ yà ɨ̀ árɨ́ kasʉ ɔ̀nzɨ mànà atdíkpá kpabhálɛ mà, vèbhálɛ mànà, ndàdʉ̀ àrà ndɔ̀nyʉ̀ rɔ̌, ndàdʉ̀ ndɔ̀mvʉ̀, ndòrì, ");
INSERT INTO niy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nɨ́ kàbhà kasʉ tɔ́ ádrʉ̀ngbǎlɛ rɨ̌ ndàdǔ ɨnzá kɨ̀rɛ̀nà ɨdhɔ ɔ̌, ndɨrɔ̀ ɨnzá kʉ̀nɨnà kàsʉmɨ̀ ɔ̌ rɔ̀, ndɨ ádrʉ̀ngbǎlɛ náabhʉ̀ya atdídɔ̌ ɔ́rʉ̀ màlɨpɔ̀ kà tɔ̀, ndàdʉ̀ kòbvù yà ɨ̀nzɨ̌ arɨ́ fɨ̌yɔ̀ ka kàvi dhu ɔ̀nzɨ alɛ nzínzì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ndɨ kasʉtálɛ, yà ɨwà ndɨ̀ ndʉ́nɨ pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ-afí nózè dhu rɔ́rɔ̀ rádɨ ɨ̀nzɨ̌ ndɔ̀bhɔ̀lɔ̀ ndɨ̀, ɨ̀nzɨ̌ ndàdʉ̀ pbɨ̀ndà ádrʉ̀ngbǎlɛ ózè dhu ɔ̀nzɨ̀, náabáya mùgǒ abhɔ nyʉ́ ròsè. ");
INSERT INTO niy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pbɛ́tʉ̀ ɨnzá ndɨ̀ ndʉ́nɨ pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ-afí ózè dhu dhu-okú dɔ̀ rɔ̀ rɨ́ dhu àfǎ alɛ, ndɨ afátá ràdʉ̀ kòzè kʉvɨ, nɨ́ ndɨ alɛ náabáya mùgǒ ngúfe tɨ́. Abhɔ ka kubhò dhu fɔná alɛ-fɔ́ ka konziya dhu abhɔ, ndɨrɔ̀ abhɔ nyʉ́ ròsè ka kʉbhà dhu fɔná alɛ-fɔ́ ka kadʉ̀ya dhu ònzì abhɔ nyʉ́ ròsè.» ");
INSERT INTO niy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Ma mɨ́rà kàzʉ ma mivó tɨ́ yà adzɨ dɔ̌, nɨ́ ma mòzè wà ndɨ̀ kàzʉ rɨ̀rʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma mɨ́ atdí bàtizò nà ma málʉ̌na. Nɨ́, ìtǔ kà rɔ̌’ɔ rùdú dhu bhěyi, kàkǎ wà ndɔ̀nzɨ̀ ndɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Nyɨ̌ nyɨ̀rɛ̀ tɨ́ nga ma rɨ́rà màrʉ̀ngà níbhò yà adzɨ ɔ̌? Ɨ̀nzɨ̌ nɨ́ ndɨ dhu bhěyi, akɛkpá màtɨ́. Pbɛ́tʉ̀ ma mɨ́rà ìndrǔ-ɔ̌nga nábhʉ rʉ̀ndɔ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Obhó tɨ́, rɔ̀pɛ̀ ndɨ̀ kòmbí, imbo rɔ̀ aróko atdí ɨdza ɔ̌ alɛ-ɔ̌nga náarana ndùtù rɔ̌ ɔyɔ, ɨ̀bhʉ alɛ rɔ̀ndrɔ̀ ɔ́yɔ̌ alɛ, ndɨrɔ̀ ɔ́yɔ̌ alɛ ràdʉ̀ ɨ̀bhʉ alɛ nɔ́ndrɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Àbanà náaraya idhùnà nɔ́ndrɔ̀ rɔ̌, idhùnà ràdʉ̀ àbanà nɔ́ndrɔ̀. Ɨ́yànà náaraya ɨvànà ɔ̀ndrɔ̀ rɔ̌, ɨvànà ràdʉ̀ ɨ́yànà nɔ́ndrɔ̀. Agʉna-àyi náaraya pbɨ̀ndà àdhɨ̀ngbǎ nɔ́ndrɔ̀ rɔ̌, àdhɨ̀ngbǎ ràdʉ̀ pbɨ̀ndà agʉna-àyi nɔ́ndrɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yěsù adʉ̀ àtɨ̀nà átɔ̀ ihé-yà nɨ̌: «Nyɨ̌ nyapɛ́ àpbù nálǎ adyifɔ̀ arótsù ɨnǎ rɔ̀ rɨ́rà rɔ́, nɨ́ nyɨ̌ nyarɨ́ àdʉ̀ àtɨ̀nà ányɨ̀rɔ̌ rɔ̀ tɨ́ ɨ̀kɔ̌ igye ràrɨ̌ ɨ̀kɔ̌, ndɨ dhu ràdʉ̀ ndɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ndɨrɔ̀, nyɨ̌ nyapɛ́ awɛ àlǎ mùsùngú dɔ̀nǎ rɔ̀ rɨ́rà rɔ́, nɨ́ nyɨ̌ nyarɨ́ àdʉ̀ àtɨ̀nà ɨ̀ka adyifɔ̀ ràrɨ̌ ɨ̀ka, ndɨ dhu ràdʉ̀ ndɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyɨ̌ nɨ́ ɔyɔ-ɔyɔ ɨdàya nà alɛ. Nyɨ̌ nyárɨ́ yà adzɨ dɔ̌ rɨ́ ’ɔ̀nzɨ dhu mà, ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ rɨ́ ’ɔ̀nzɨ dhu mànà dhu nʉ́nɨ̌ mběyi nyʉ́. Nɨ́, ádhu ɨ̀nzɨ̌ nyɨ̌ nyárɨ́ àdʉ̀ yà kòmbí rɨ́’ɨ̀ kàsʉmɨ̀ ɔ̌ rɨ́ ’ɔ̀nzɨ dhu rʉ̌nɔna fʉ̌kʉ̀ dhu nʉ́nɨ̌ nɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ádhu ɨ̀nzɨ̌ nyɨ̌ nyárɨ́ dhu-ɔ̌nga òvò nyɨ̌-tɨ́rɔ̀, ndɨ́nɨ̌ nyɨ̌ nyʉnɨ tɨ́ obhónánga tɔ́ dhu tɨ́ rɨ́’ɨ̀ dhu nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dhʉ̀wanɨ̀ ɔ̀ nyɨ̌ nyówu nyɨ nɔ̀bhʉ̀ alɛ mànà rɔ̀, dhu àkǎ nyɔnzɨ̀ ɔbɨ nyɨ̌rɨ̀ nyɨ̌ ndɨ alɛ nà, nyɨ̌tɔ̀ ndɨ dhu òko nyɨ̌ nyòko otu ɔ̌ rɔ́rɔ̀. Ɨnzá nyɨ nyɔ̀nzɨ̀ ka ndɨ dhu bhěyi rɔ̀, kà rǎdʉ̀ àrà nyabhʉ anya t’ɨ́tdɨ̀ta t’álɛ-fɔ́, ɨ alɛ ràdʉ̀ nyabhʉ pùrǔsɨ-fɔ́, ndɨ pùrǔsì ràdʉ̀ nyosò imbi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀: nyɨ nyɨ́ nzɨ̌ àdʉ̀ àhʉ imbi ɔ̀ rɔ̀ ɨnzá nyɨ nyùbho dʉ̀nʉ́ ka kɔ̀tdɨ̀ dhu, rìku kɔ́rɔ́ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ndɨ kàsʉmɨ̀ ɔ̌, ngúfe alɛ níiwú Gàlìlayà tɔ́ pbìrì ɔ̌ bhà rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu náwɛ Yěsù tɔ̀. Abádhí atɨ, Pìlatɔ̀ ràbhʉ ɨ alɛ kɔkyɛ̀, azùya rùngbǒ ndɨ̀ yà abádhí rǔbhǒna pɛrɛ̀ tɨ́ ɨ̀zǎ-azù mànà. ");
INSERT INTO niy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyɨ̀rɛ̀ tɨ́ dhu kɔ̌kɔ̀ ɨ Gàlìlayà ɔ̌ bhà rɨ’ɨ̀ ɨ nzɛ́rɛngatálɛ ròsè Gàlìlayà tɔ́ pbìrì ɔ̌ kɔ́rɔ́ ngʉ̌kpà alɛ dɔ̀nǎ, wɔ̀ dhu bhěyi ka kakyɛ̀ abádhí dhu-okú dɔ̀ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma mátɨna nyɨ̌ nɨ̌, ɨ̀mbǎ kà rɨ́’ɨ̀ ndɨ dhu bhěyi. Pbɛ́tʉ̀, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ nyʉ̌gɛ̀rɛ̀, nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛ mʉ̀tsɔ, nɨ́ nyɨ̌ nyʉ́vɛ kɔ́rɔ́ átɔ̀! ");
INSERT INTO niy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ndɨrɔ̀, atdí kumì dɔ̀ná àrʉ̀ nà alɛ, yà Sìlòamù tɔ́ mʉ̀narà núugòlò ndɨ̀ dɔ̀yá rʉ̀vɛ, nɨ́ nyɨ̌ nyɨ̀rɛ̀ tɨ́ dhu abádhí rɨ’ɨ̀ nzɛ́rɛngatálɛ ròsè Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ kɔ́rɔ́ ngʉ̌kpà alɛ dɔ̀nǎ? ");
INSERT INTO niy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɨ̀nzɨ̌ akɛkpá màtɨ́. Pbɛ́tʉ̀, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ nyʉ̌gɛ̀rɛ̀, nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛ mʉ̀tsɔ, nɨ́ nyɨ̌ nyʉvɛ̀ya kɔ́rɔ́ ndɨ dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tdɨ́tdɔ̌ Yěsù adʉ̀ yàrɨ́ mbólí náwɛ átɔ̀ ndàtɨ: «Atdí alɛ nɨ́ɨ’ɨ̀ mùtinì-kpa nà pbɨ̀ndà vǐnyò tɔ́ ɨnga ɔ̌. Nɨ́ kɨ̌ra ndɨ́nɨ̌ ndɔpɛ́ tɨ́ itsu-kpɔ̌ ndɨ̀ mùtinì-kpa dɔ̌, pbɛ́tʉ̀ kǎdʉ̀ nzá atdí dhu mà nótù kà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nɨ́ kǎdʉ̀ àtɨ̀nà ndɨ vǐnyò tɔ́ ɨnga kàsʉ̌ nɔ́nzɨ arɨ́ alɛ nɨ̌: ‹Ándà pɛ́! Kànɨ̌ atɔ náhʉ wà ɨ̀bhʉ nyʉ́ yà ma marɨ́ ɨ̀rà mùtinì-kpɔ̌ ma mɔpɛ́ tɨ́ yàrɨ́ mùtinì-kpa dɔ̌ rɔ́, nɨ́ ma márɨ́ nzɨ̌ atdí dhu mà nótù kà dɔ̌. Nɨ́ ɔ́kɛ̀rɛ̀ ka, ɨnga-ɔ̌nga nɨ́rɨ̌ kǎrɨ́ kɔkɔ́rɔ̀ dhu-okú dɔ̀ rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wɔ̀rɨ́ kasʉtálɛ náadʉ̀ dhu àdu kà tɔ̀ ndàtɨ: ‹Ádrʉ̀ngbǎlɛ́, ítsè kà radɨ̀ pɛ́ yàrɨ́ atɔ ɔ̌ tɨ́. Ma mɨ́ kà-pfɔ̀-rɔ̌nga nóbhì, madʉ̀ ìkyǐ-zɨ̀ nʉ́trɔ rɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nɨ́ ngǎtsi nɨ̌, kǎdʉ̀ya ɔ̀’ɔ̀ ɔ̀’ɔ̀ tdɨ́tdɔ̌ rɨ́rà atɔ ɔ̌. Ndɨrɔ̀ ɨnzá kɔ̀’ɔ̀ rɔ̀ nɨ́ ndɨ nyɨ nyadʉ̀ya kàbhʉ kɔkɛ̀rɛ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Atdíku, sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù adɨ̀ ndàmbɛ dhu núdhe dɔ̌ unduta-dzà ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nɨ́ atdí tsìbhálɛ nɨ́ɨ’ɨ̀ ìnè ányɨ̀ ɨdzá. Ndɨ tsìbhálɛ nɨ’ɨ̀ yà ɔ̀nà arɨ́’ɨ̀ nzɛ́rɛ-alafí ábhʉ adzína-kpa ràtdɔ̀ ndɨ̀, ɨ̀nzɨ̌ ròngò ndàto akɛ màtɨ́, ràrà àhʉ atdí kumì dɔ̀ná àrʉ̀ nà atɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nɨ́ Yěsù itdègu wɔ̀ tsìbhálɛ àlǎ, nɨ́ kǎnzi ɨ́yàdhíyà, ndàdʉ̀ àtɨ̀nà nɨ̌: «Tsìbhálɛ́, nyɨ nyɔ̀gʉ̀ wà pbʉ̀kʉ̀ andɨ ɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nɨ́ Yěsù adʉ̀ ɔtsʉ́na nʉ́lɨ wɔ̀rɨ́ tsìbhálɛ dɔ̌, ányìrɔ̌ rɔ̀ tɨ́ kǎdzí-kpa ràdʉ̀ ndàto, ɨ́yàdhíyà ràdʉ̀ ndɔ̀pɛ̀ ndɨ̀fʉ Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nɨ́ unduta-dzà ɔ̌ ádrʉ̀ngbǎlɛ níitdègu Yěsù ɨ̀gʉ̌ wɔ̀rɨ́ tsìbhálɛ sàbatʉ̀-ɨdhɔ̀ ɔ̌ dhu nálǎ, náakó atdídɔ̌. Nɨ́ wɔ̀rɨ́ ádrʉ̀ngbǎlɛ náatɨ ihé-yà nɨ̌: «Ìndrǔ rǎdʉ̀ kasʉ nɔ́nzɨ̀ ɔ̀yá ɨdhɔ náarɨ́’ɨ̀ aza. Nɨ́ nyòngò ìwu nyɨ̌ nà kɨgʉ̌ nyɨ̌ ɨ azà ɨdhɔ ɔ̌, ɨ̀nzɨ̌ nɨ́ sàbatʉ̀-ɨdhɔ̀ ɔ̌!» ");
INSERT INTO niy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ádrʉ̀ngbǎlɛ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Nyɨ̌ nɨ́ ɔyɔyɔ ɨdàya nà alɛ! Sàbatʉ̀-ɨdhɔ̀ ɔ̌ tɨ́, nyɨ̌ kɔ́rɔ́, nyɨ̌ nyatɨ́ nzɨ̌ fʉ̀kʉ́ ìkyì-akpá mà, fʉ̀kʉ́ kayinò mànà nʉ́ngǎ kɨ̀walɨ̀ ɔ̌ rɔ̀ rɨ́ dhu ɔ̀nyʉ rɔ́rɔ̀, nyǎdʉ̀ ʉ̀ndànà ròwù ɨdha nɔ́mvʉ̀? ");
INSERT INTO niy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nɨ́ yàrɨ́ tsìbhálɛ nɨ́ Àbràhamʉ̀-dhú-bvʉ̌ tsìbhíngba, ndɨrɔ̀ Sìtanɨ̀ nʉ́ʉtsɨ ka ràrà àhʉ atdí kumì dɔ̀ná àrʉ̀ nà atɔ nyʉ́ tɨ́. Nɨ́ dhu àmbɛ̀nà tɨ́ obhó àkǎ kɨkɔ̀lɔ̀ ka Sìtanɨ̀ bhà imbi ɔ̌ rɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wɔ̀ dhu bhěyi Yěsù ìvǔ dhu rɔ̀, yà kà-rɔ̌ òmvǔ tɨ́ rɨ́’ɨ̀ kɔ́rɔ́ alɛ-nyɨ̀ náadʉ̀ ɨ̀wʉ atdídɔ̌. Pbɛ́tʉ̀, ihé-yà-ɨdhɛ̀ náadʉ̀ ndɨ̀ka atdídɔ̌, yà Yěsù rǎrà ɔ̀nzɨ̀nà rɔ̌ ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ kɔ́rɔ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ádhu ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɔ́fɔ̀ ndɨ̀ nà? Ma mádʉ̀ kùdhe àdhu rɔ̌? ");
INSERT INTO niy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kɨ̀lɨ ndɨ̀ yà atdí alɛ níidyi ndòzò pbɨ̀ndà ɨnga ɔ̌ hàràdalɨ̀-kpɔ̌ bhěyi. Ndɨ hàràdalɨ̀-kpɔ̌ nɨ́ɨnga, ndòvì, ndàdʉ̀ òngo itsukpó tɨ́, àrɛ̀ ràdʉ̀ ɨdzàya nɔ́sɨ̀ sɔ̀bɨ̌na nzínzì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yěsù adʉ̀ dhu ìvu tdɨ́tdɔ̌, ndàtɨ: «Ádhu ndɨ ma mádʉ̀ Kàgàwà bhà idzi núdhě rɔ̀ná? ");
INSERT INTO niy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yàrɨ́ nɨ́ ndɨ kɔ̌fɔ̀ ndɨ̀ nà dhu: Kɨ̌lɨ ndɨ̀ yà atdí tsìbhálɛ níidyi, ndàngbǒ mbɛ̀mbɛ̀ ɔ́yɔ̌ kumì dɔ̀ná imbò nà kìlo nganʉ̀-ra tɔ́ ɔ̀ afi bhěyi, ndɨ dhu ràdʉ̀ ndɨ idyi nábhʉ rɨ̀vʉ̀ kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yěsù adɨ̀ ndàmbɛ àrà dɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Nɨ́ kǎránà dhu núdhe rɔ̌ ìndrǔ tɔ̀ yà ndɨ̀ ndʉ́da ɔ̀yanǎ kɨgɔ̀ mà pbanga mànà ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɨ́ atdí alɛ níivú dhu kà-tsʉ̌ ndàtɨ: «Ádrʉ̀ngbǎlɛ́, tɨ́ ngúfe alɛ kɛ̀lɛ̌ ɨ ʉ̀gʉ̌gʉ̀ya?» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Nyɔ̀nzɨ ɔbɨ nyǒtsù ndɨ̀ nɨ́pbɔ̌ tsǎtsʉ̀ ɔ̌. Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: ábhɔ̌ alɛ nyʉ́ nóowuya ’òmvù rɔ̌ ’òtsù, pbɛ́tʉ̀ ndɨ dhu náaraya nzɨ̌ àkǎ rɔ̌ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Atdíku, ɨdza-àbadhi nɨ́ɨvàya ndɨ̀, ndàdʉ̀ tsǎtsʉ̀ nápbi ɨdza nǎ rɔ̀. Nɨ́ iri nyɨ̌ nyɔ̀tdɨ̀ nyɨ̌ rɔ̀, nyɨ̌ nyokoya gukyè nyǎmbɛ tsǎtsʉ̀ ɔ̀tdɔ̀ dɔ̌, nyǒwù àtɨ̀nà rɔ̌: ‹Ádrʉ̀ngbǎlɛ́, ápfo tsǎtsʉ̀ fǎkà,› nɨ́ ɨdza-àbadhi náaraya dhu àdu rɔ̌ fʉ̌kʉ̀ ndàtɨ: ‹Ɨnzá ma mʉ̀nɨ nyɨ̌ nyìwǔ àdhà rɔ̀ màtɨ́ dhu!› ");
INSERT INTO niy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nɨ́rɔ̀ nɨ́ ndɨ nyɨ̌ nyowuya àtɨ̀nà rɔ̌ kànɨ̌: ‹Mǎ manyʉ̀ tɨ́ obhó dhu, mǎdʉ̀ dhu ɔ̀mvʉ̀ ɔnzɨ̀nʉ́ rɔ̀? Ndɨrɔ̀ nyɨ nyaránà tɨ́ obhó dhu núdhe rɔ̌ fǎkà fàká pbanga-tsidɔ̌ ngʉdhà ɔ̌ rɔ̀?› ");
INSERT INTO niy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nɨ́ àbadhi adʉ̀ya àtɨ̀nà nyɨ̌ nɨ̌ tdɨ́tdɔ̌: ‹Ɨnzá ma mʉ̀nɨ àdhà rɔ̀ màtɨ́ nyɨ̌ nyìwǔ dhu. Nɨ́ nyìndrǐ nyɨ̌ ɨtsɛ nyʉ́ tɨdú rɔ̀, nyɨ̌ kɔ́rɔ́, yà nzɛ́rɛ dhu ɔ̀nzɨ nyɨ̌ nyarɨ́ rɔ̀!› ");
INSERT INTO niy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Àbràhamʉ̀ mà, Ìsakà mà, Yàkɔbhɔ̀ mà kɔ́rɔ́ pbànábí mànà nyɨ̌ nyàla ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ òkò rɔ́, kadʉ̀ nyǒdì iri ányɨ̀rɔ̀ rɔ̀ nɨ́ ndɨ, nyɨ̌ nyambɛ̀ya ɔ̀dzɨ dɔ̌, nyǎdʉ̀ àmbɛ kǔkʉ nátri dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nɨ́ ìndrǔ níiwúya ɨ̀fɔ yà adzɨ-pbɨdɔ̀ ɔ̀nǎ rɔ̌, ’àdʉ̀ dhu ɔ̀nyʉ̀ atdíkpá ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nɨ́ yà kòmbí arɨ́’ɨ̀ olù alɛ tɨ́ alɛ, nóokoya wɛmbɛrɛ̀ tɨ́, ndɨrɔ̀ yà wɛmbɛrɛ̀ tɨ́ arɨ́ kombí alɛ, nóokoya olù alɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, ngúfe Pbàfàrìsáyó níiwú dhu ɔ̀vɔ̀ Yěsù tɔ̀, ’àtɨ: «Ɨ́và nyɨ nyarà ɨrɔ́ rɔ̀, Hɛ̀rɔdɛ̀ rɨ̌ dhu ɔ̀nzɨ ndɨ́nɨ̌ ndabhʉ̀ tɨ́ nyɨ kohò nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòwu nyàtɨ wɔ̀ ayíwě nɨ̌: Rɔ̀pɛ̀ ndɨ̀ indo, ràrà àhʉ tsútsǎ, ma ràrɨ̌ nzɛ́rɛ-alafí nípfǒ, modì ìndrǔ ɔ̀ rɔ̀, ndɨrɔ̀ ma ràrɨ̌ andɨ nà alɛ nɨ́gʉ̌. Ndɨrɔ̀ ibho ma radʉ̀ya pbàkà kasʉ nɨ́tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pbɛ́tʉ̀ rɔ̀pɛ̀ ndɨ̀ indo, tsútsǎ, ràrà àhʉ ibho, dhu àkǎ mɔdɨ̀ dùdu, mambɛ àrà dɔ̌. Obhó tɨ́, dhu àkǎnà nzá nabì ràrà ɔ̀vɛ̀ igi Yèrùsàlɛmà tɔ́ kɨgɔ̀ rɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yèrùsàlɛmà, Yèrùsàlɛmǎ, nyɨ̌ nyarɨ́ pbànábí nɔ̀kyɛ nyǎdʉ̀ Kàgàwà òvì tɨnʉ ɔ̀ alɛ núbvu odu nɨ̌. Abhɔ-gʉ̀na nyʉ́ ma mómvù mandu ʉ̀nʉ́ aróko alɛ-tsʉ̀ àdhàdhɨ̀ à’ʉ̌-yà-ba náarɨ́ pbɨ̀ndà inzo-tsʉ̀ nándǔ pékéléna-tsì dhu bhěyi! Pbɛ́tʉ̀ nyɨ nyádʉ̀ nzá ndɨ̀ dhu nózè. ");
INSERT INTO niy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɨ́rɔ̀ kɔ̀nɨ̌, ka kɨ́ pɛ́ fʉ̀kʉ́ ɨdza nʉ́bha fʉkʉ́. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: nyɨ̌ nyɨ́ nzɨ̌ ma àlǎ tdɨ́tdɔ̌, ràrà àhʉ nyɨ̌ nyowuya àtɨ̀nà: Kàgàwà ràkǎ ndàso Ádrʉ̀ngbǎlɛ-ɔvɔ̀ rɔ̌ rɨ́rà alɛ ɔ̀ná ɨdhɔ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Atdíku sàbatʉ̀-ɨdhɔ̀ ɔ̌, Yěsù ɨra dhu ɔ̀nyʉ̀ Pbàfàrìsáyó nzínzì ɔ̌ atdí ádrʉ̀ngbǎlɛ bhà ɨdzá. Nɨ́ ìndrǔ adʉ̀ nyɨ̀kpɔ́ya nʉ́dɨ, ’àmbɛ kàndà dɔ̌ atdyúya nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nɨ́, ɔ̀na ádhà ndɨ̀ atdí alɛ nɨ́ɨ’ɨ̀ Yěsù-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nɨ́ Yěsù, ivú dhu Ʉyátá tɔ́ màlímó mà Pbàfàrìsáyó mànà-tsʉ̌, ndàtɨ: «Àlɛ̌ tɔ́ Ʉyátá ná’ù tɨ́ wà ìndrǔ ɨ̀gʉ ka kádʉ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌ dhu? Ndɨrɔ̀ ngǎtsi nɨ̌, kǎtɨ tɨ́ ɨ̀nzɨ̌ ka ràrǎdʉ̀ kɨ̀gʉ?» ");
INSERT INTO niy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pbɛ́tʉ̀ abádhí náadʉ̀ ɨ̀nɛ̀, ɨ̀nzɨ̌ ’àdu ɔtɛ. Nɨ́ Yěsù idyi wɔ̀rɨ́ alɛ ndɨ̀gʉ̌, ndàdʉ̀ àvinà ràrà. ");
INSERT INTO niy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhɨ pbá alɛ nzínzìkʉ ɔ̌, pbɨ̀ndà ɨngba mà, ndɨrɔ̀ pbɨ̀ndà ìkyì mà nɨ́tsɨ̀ dzɨ̀wɔ̀ ɔ̀ rɔ̀, ɨ̀nzɨ̌ rǎdʉ̀ kìpfo ányɨ̀rɔ̌ rɔ̀ tɨ́ ndɨ dzɨ̀wɔ̀ ɔ̀ rɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nɨ́ abádhí rǎdǔna wɔ̀rɨ́ ɔtɛ dɔ̌ dhu náadʉ̀ abádhí-lɛ̀mà nɔ́nzɨ̀ ɔ̀nzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yěsù níitdègu yà ɨ̀ ka kùnzìnà mànà ɔ̀nyʉ̀ tɔ̀ alɛ nóvò angyinǎ rɔ̀ rɨ́’ɨ̀ tombi, ’àdʉ̀ òko dɔ̀yá dhu nálǎ, nɨ́ kǎdʉ̀ yàrɨ́ mbólí náwɛ ɨ alɛ tɔ̀ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Atdí alɛ nánzì nyɨ àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ tɔ̀ rɔ̀, dhu àkǎ nzá nyitsì àdɨ angyinǎ rɔ̀ rɨ́’ɨ̀ tombi dɔ̌. Obhó tɨ́, ngǎtsi nɨ̌ wɔ̀rɨ́ alɛ nádʉ̀ ɨ̀’ɨ̀ ɨwà ànzìnà pbʉ̀kʉ̀ ɨfʉta dɔ̀nǎ pbɨ̀ndà ɨfʉta ósè ngǎtsi alɛ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nɨ́ wɔ̀ ngǎtsi alɛ nɨ́tɔ̀ ndɨ̀ rɔ̀, wɔ̀ nyɨ̌ nùnzìnà ɔ́yɔ̌ kɔ́rɔ́ alɛ rǎdʉ̀ àrà àtɨ̀nà nyɨ nɨ̌: ‹Ɨ́và nyɨ, nyʉbhà ngari wɔ̀ alɛ tɔ̀.› Nɨ́ nyɨ nyɨ́ nyɨvà, nyarà àdɨ olù rɨ́’ɨ̀ tombi dɔ̌ dhu rǎdʉ̀ nyɨ̀nʉ nábhʉ rɨ̀wʉ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nɨ́, nyɨ ka kànzì mʉ̀hɛndʉ̀ ɔ̌ ɔ̀nyʉ̀ tɔ̀ rɔ̀, dhu ɔ̀fɔ̀ nga nyitsì àdɨ olùnǎ rɔ̀ rɨ́’ɨ̀ tombi dɔ̌, ndɨ́nɨ̌ yà nyɨ nànzìnà alɛ nítsù rɔ̀, kǐtsi tɨ́ ndɨ àtɨ̀nà nyɨ nɨ̌: ‹Ɔdhɨ́, ʉ́dà nyadɨ angyinǎ rɔ̀.› Nɨ́, ndɨ dhu nádʉ̀ ɨ̀’ɨ̀ ádrʉ̀ngbǎ ɨfʉta nyʉ́ tɨ́ ɨndʉ̀ yà atdíkpá nyɨ̌ nyɨ́ dhu ɔ̀nyʉ mànà kɔ́rɔ́ alɛ-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Obhó tɨ́, ndɨ̀dzɨ̌ rɨ́ ndɨ̀tɨ́rɔ̀ ɔrʉ́ alɛ nɨ́ ka kifoya. Ndɨrɔ̀, ndìfǒ rɨ́ ndɨ̀tɨ́rɔ̀ alɛ nɨ́ ka kɨdzɨ́ya.» ");
INSERT INTO niy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà wɔ̀ ndɨ̀ nànzìnà ɔ̀nyʉ̀ tɔ̀ alɛ nɨ̌: «Kútsingá nga tɔ́ ɔ̀nyʉ̀, ndɨrɔ̀ ngǎtsi nɨ̌ adyíbhengá nga tɔ́ ɔ̀nyʉ̀ nyɨ nyɔ̀bhɔ̀lɔ̀ ìndrǔ tɔ̀ rɔ̀, dhu àkǎ nzá nyunzì ɔdhɨ́nʉ mà, adɔ́nʉ mà, fʉ̀kʉ́ ɨdzá-bhà mà, ndɨrɔ̀ ònzǒnzì ɔdhɨ́nʉ mànà. Obhó tɨ́, abádhí rǎdʉ̀ òwu nyanzì átɔ̀ fɨ̀yɔ́ mʉ̀hɛndʉ̀ ɔ̀, nyadʉ̀ yà abádhí tɔ̀ nyɨ nyanzɨ̀ dhu-arì ɔ̌ nábà abádhí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pbɛ́tʉ̀, dɨ̀nɨ́ nyɨ nyɔ̀nzɨ̀ rɔ̀, dhu ɔ̀fɔ̀ nga nyunzì alɛ nɨ́: nǎkʉ̀tálɛ mà, òtsótsù alɛ mà, ùkele arúkele alɛ mà, ndùmùndúmú mànà. ");
INSERT INTO niy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nɨ́rɔ̀ nɨ́ ndɨ nyɨ nyádʉ̀ hirò ɔ̀nzɨ̀, ɨ̀mbǎ abádhí rɨ̌’ɨ̀ ɨndʉ̀ ɨ̀ ádǔna dhu nà dhu-okú dɔ̀ rɔ̀. Obhó tɨ́, Kàgàwà náadʉ̀ya ndɨ yà nyɨ nyanzɨ̀ dhu-arì ɔ̌ nádu ɨndʉ̀, yà Kàgàwà rɨ̌ obhónángatálɛ nábhʉ̌ rʉ̀ngbɛ ɨ̀ ɔvɛ-bvʉ̀ rɔ̀ nɨ́nganɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wɔ̀ Yěsù ʉ̀nɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, kà mà rǔbhi dhu ɔ̀nyʉ̀ rɔ̌ mànà atdíkpá alɛ nzínzì ɔ̌ atdí alɛ náatɨ Yěsù nɨ̌: «Hirò nɔnzɨya alɛ nɨ́, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ dhu nɔnyʉya alɛ!» ");
INSERT INTO niy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Atdí alɛ náanzɨ̀ ádrʉ̀ngbǎ dɨ̀nɨ́ ndàdʉ̀ ábhɔ̌ alɛ nyʉ́ núnzì ɔ̀nà. ");
INSERT INTO niy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nɨ́, ndɨ dɨ̀nɨ́ tɔ́ kàsʉmɨ̀ àkǎ rɔ̀, kǎvì pbɨ̀ndà kasʉtálɛ ràrà dhu ʉ̀nɔ̀ yà ndɨ̀ ndúnzì alɛ tɔ̀, ndàtɨ: ‹Kɔ́rɔ́ dhu-tsí ka kɔ̀bhɔ̀lɔ̀ wà, nɨ́ nyìwǔ kòmbí.› ");
INSERT INTO niy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pbɛ́tʉ̀, kɔ́rɔ́ kɔ̀rɨ́ alɛ náapɛ̀ ’òwù ʉbàta nónzì rɔ̌ atdátdírà ɔ̌. Wɛmbɛrɛ̀ t’álɛ atɨ wɔ̀ kasʉtálɛ nɨ̌: ‹Ma módzì atdí ɨnga, nɨ́ dhu àkǎ marà ndɨ ɨnga nándà. Nɨ́, ma mɨ̀tsɔ̀ ma rʉ̀nʉ́ atdídɔ̌, ʉ́bà dhu idù.› ");
INSERT INTO niy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngǎtsi alɛ náatɨ: ‹Ma módzì ɨnga t’óbhìta tɔ́ ìkyì-akpá ɨdrɛ, nɨ́ ma mɨ́ abádhí nɨ̌ ma móngo kasʉ ɔ̀nzɨ̀ tɨ́ dhu nómvù. Nɨ́rɔ̀, ma mɨ̀tsɔ̀ ma atdídɔ̌ rʉ̀nʉ́, ʉ́bà dhu idù.› ");
INSERT INTO niy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ndɨrɔ̀, ngǎtsi alɛ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Mǎ mʉ́mbǎ mǎ pbàkà tsìbhálɛ nà rɔ́ ɨdhɔ nápɛ̀ nzá ɔ̀trɔ. Nɨ́, ma mɨ́ nzɨ̌ àrà àwólò.› ");
INSERT INTO niy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nɨ́ wɔ̀ kasʉtálɛ náadù ndɨ̀ pbɨ̀ndà ádrʉ̀ngbǎlɛ ɨ, ndàdʉ̀ kɔ̌kɔ̀ alɛ rǒwu àdunà rɔ̌ fɨ̌ndà dhu náwɛ kɔ́rɔ́ àbadhi tɔ̀. Nɨ́ wɔ̀rɨ́ ɨdza-àbadhi náakó atdídɔ̌, ndàdʉ̀ àtɨ̀nà pbɨ̀ndà kasʉtálɛ nɨ̌: ‹Árà tsàkàtsàkà kɨgɔ̀ ɔ̌ ngʉdhà ɔ̀nǎ, ndɨrɔ̀ otu ɔ̀nǎ màtɨ́, nyundu nǎkʉ̀tálɛ mà, òtsótsù alɛ mà, ndùmùndúmú mà, ndɨrɔ̀ ùkele arúkele alɛ mànà, nyɨrà nà ɨrɔ́.› ");
INSERT INTO niy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nɨ́, ányɨ̀rɔ̀ ndɨ̀ ndìngò rɔ̀, kǐtsi àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ́, ma mɔ̀nzɨ̀ wà yà nyɨ nyàvi dhu, pbɛ́tʉ̀ ngari nɔ́dɨ̀ ɔ̀dɨ̀ tdɨ́tdɔ̌ ɨdzá.› ");
INSERT INTO niy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nɨ́ wɔ̀ kasʉ tɔ́ ádrʉ̀ngbǎlɛ náadʉ̀ àtɨ̀nà pbɨ̀ndà kasʉtálɛ nɨ̌: ‹Áhʉ̌, nyarà igigi pbanga ɔ̀ rówu otu ɔ̀nǎ, ɨnga-ngbɔ̀ ka kʉ́kpɔ̀rɔ̀ nɨ̌ kɔrɔwà ɔ̀nǎ màtɨ́, nyadʉ̀ ìndrǔ nʉ́tʉ rìtsù, ndɨ́nɨ̌ ɨdzá nga núupílí tɨ́ ndɨ̀ ìndrǔ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: atdí alɛ mà yà ka kùnzìnà alɛ nzínzì ɔ̌ níinèya nzɨ̌ pbàkà dɨ̀nɨ́ ɔ̌ ɔ̀nyʉ̀-dzi mà.›» ");
INSERT INTO niy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wɔ̀ dhu-dzidɔ̌, ábhɔ̌ ihé-yà núubhínà òwu rɔ̌ atdíkpá Yěsù mànà. Nɨ́ Yěsù agɛ́rɛ́ ndɨ̀ abádhí dɔ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: ");
INSERT INTO niy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Owùdu ɔ̌ ndɨ̀ nòzè ndùbhi alɛ náapɛ́ nzɨ̌ àbanà mà, ɨ́yànà mà, pbɨ̀ndà tsìbhálɛ mà, pbɨ̀ndà nzónzo mà, adɔ́na mà, awɛ́na mà, ndɨrɔ̀ pbɨ̀ndà ípìrɔ̌nga nyʉ́ mà nɔ́ndrɔ̀, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ àdɨ pbàkà ábhàlɨ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndɨrɔ̀, ɨ̀nzɨ̌ ndɨ alɛ náapɛ́ pbɨ̀ndà mʉ̀sàlabhà nánɔ̀, ndàdʉ̀ ùbhi owùdu ɔ̌, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ àdɨ pbàkà ábhàlɨ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ádhɨ pbá alɛ, nzínzìkʉ ɔ̌, ɨdzá-yà-ba ndɨ̀ ndòzè ndɔ̀sɨ̀ rɔ̀, ɨ̀nzɨ̌ rádʉ̀ àdɨ, ndʉ̀pɨ̌ pɛ́ ìfe màtɨ́ ndɨ ɨdza t’ɔ́sɨ̀ta kàsʉ̌ rǎdʉ̀ fʉ̀rangà nónzì dhu angyi, ndàdʉ̀ dhu àndà yà fɔná rɨ́’ɨ̀ fʉ̀rangà ràtɨ́ ndɨ kasʉ nɨ́tɔ ɨ̀tɔ? ");
INSERT INTO niy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pbɛ́tʉ̀ kǎpɛ́ àdʉ̀ ndɨ ɨdza-pfɔ̀ kɛ̀lɛ̌ nɔ́sɨ̀, ndɨ ɨdza-kàsʉ̌ ràdʉ̀ àkpa, nɨ́ kɔ́rɔ́ alɛ wɔ̀rɨ́ dhu nàla rǎdʉ̀ ’ɔ̀pɛ̀ ’ʉ̀gbɔ̌ ndɨ alɛ, ’òwù àtɨ̀nà rɔ̌: ");
INSERT INTO niy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Yàrɨ́ alɛ náapɛ̀ ndɔ̀sɨ̀ yà ɨdzá-yà-ba, pbɛ́tʉ̀ kà-kàsʉ̌ nɨ́tɔ kà rɨ̌ dhu nádʉ̀ wà kà-lɛ̀mà nɔ́nzɨ̀.› ");
INSERT INTO niy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ndɨ dhu bhěyi tɨ́, ádhɨ pbá ádrʉ̀ngbǎ kamà, ɨla ùgyè ndɨ̀ ndárà ngǎtsi ádrʉ̀ngbǎ kamà nà rɔ̀, ɨ̀nzɨ̌ rǎdʉ̀ àdɨ, ndàndà fɔná rɨ́’ɨ̀ pbànówí-bvʉ, ndɨ́nɨ̌ ndʉnɨ tɨ́ dhu, pbɨ̀ndà atdí kumì lʉfʉ̀ pbànówí ràtɨ́ àdʉ̀ ’ùgyè ùgye kɔ̌kɔ̀ pbɨ̀ndà òmvǔ rɨ̌rà nà ɔ́yɔ̌ kumì lʉfʉ̀ pbànówí mànà? ");
INSERT INTO niy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kǎpɛ́ ndɨ dhu àlǎ odú fɨ̌ndà, nɨ́ kà rǎdʉ̀ pbɨ̀ndà mʉ̀kɛ̀ngyɛ̀ núvi ròwù wɔ̀rɨ́ ngǎtsi kamà bhà, àdɨ̀ kàdɨ̀ ɨtsɛ rɔ́rɔ̀, ròwù màrʉ̀ngà ɔ̌ ɨ̀ óko nɨ̌ otu nɔ́mɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nɨ́ ndɨ dhu bhěyi tɨ́, atdí alɛ mà nzínzìkʉ ɔ̌, ɨnzá fɔná arɨ́’ɨ̀ kɔ́rɔ́ dhu nʉ̀bhà, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ àdɨ pbàkà ábhàlɨ̌ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Iko nɨ́ ídzì dhu nyʉ́, pbɛ́tʉ̀ iko ɔ̀ okyeta náapɛ́ ìku, nɨ́ ka kádʉ̀ kàbhʉ ròkyè àdhu nɨ̌ tdɨ́tdɔ̌? ");
INSERT INTO niy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kà-kàsʉ̌ rɨ̌ mbǎ àdʉ̀ ɨ̀’ɨ̀ akɛkpá màtɨ́ ɨnga tɔ̀ màtɨ́, ndɨrɔ̀ ɨnga ɔ̌ ka kʉ́trɔ̌na ìkyǐ-zɨ̀ tɔ̀ màtɨ́. Nɨ́ ka kádʉ̀ kòyì ɨrɨ́ ɔ̀. Ɨnga t’ɨ́rɨta tɔ́ bɨ̌na nà rɨ́’ɨ̀ alɛ nákǎ ndɨ̀rɨ̀ dhu!» ");
INSERT INTO niy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Àlɨ̀tá bhà fʉ̀rangà-tsʉ̀ núndǔ arɨ́ pbàndɔ́mbɛ́ mà, nzɛ́rɛ fɨ̌yɔ́ mʉ̀tsɔ nà alɛ mànà níiwú kɔ́rɔ́ Yěsù tɨ́ ɔ̀, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ kà rʉ̌nɔna dhu. ");
INSERT INTO niy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nɨ́, Pbàfàrìsáyó mà, Ʉyátá tɔ́ màlímó mànà náambɛ́nà ònu dɔ̌ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀ alɛ náarɨ́ nzɛ́rɛ fɨ̌yɔ́ mʉ̀tsɔ nà alɛ nákɔ̌, ’àdʉ̀ àmbɛ dhu nɔ́nyʉ̀ dɔ̌ mànà.» ");
INSERT INTO niy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɨ́, Yěsù adʉ̀ yàrɨ́ mbólí náwɛ abádhí tɔ̀: ");
INSERT INTO niy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Atdí alɛ nzínzìkʉ ɔ̌ náapɛ́ àdʉ̀ ɨ̀’ɨ̀ atdí mɨyà tàmà nà, atdí ràdʉ̀ àwǐ nzínzìya ɔ̌ rɔ̌. Nɨ́, ndɨ alɛ tɨ́ nzɨ̌ àdʉ̀ kɔ̌kɔ̀ àrʉ̀gyètdí kumì dɔ̀ná àrʉ̀gyètdí nà ngʉ̌kpà tàmà nʉ́bhà ànyʉ̌ rányʉ rɔ́, ndàdʉ̀ àrà àwǎwǐnà-tsí nɔ́nɛ̀, ràrà àhʉ kàbà ndɨ̀ ndárà dhu ɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ndɨrɔ̀ ka ndɨ̀ ndàbà rɔ̀, kà rǎdʉ̀ kìdyì ndɨ̀lɨ ʉna dɔ̌, atdídɔ̌ ɨdhɛ̀na ɨ̀ka ndɨ̀ rɔ́rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ndàdu ndɨ̀ nà ɨbha. Kà rǎdʉ̀ ɔdhɨ́na núnzì, tɨná aróko alɛ mànà, ndàdʉ̀ àtɨ̀nà nɨ̌: ‹Nyàbhʉ ɨdhɛ̀kʉ rɨ̀ka ndɨ̀ ma mànà atdíkpá, ma màbà wà àwǎwǐnà pbàkà tàmà nɨ́dhunɨ̌.› ");
INSERT INTO niy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ndɨ dhu bhěyi tɨ́, ma mátɨna nyɨ̌ nɨ̌: ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ rǎdʉ̀ ɨ̀’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀, atdí nzɛ́rɛngatálɛ nʉ́gɛ̀rɛ̀ ndɨ̀ ndʉ̀bhà pbɨ̀ndà nzɛ́rɛnga dhu-okú dɔ̀ rɔ̀, ròsè àrʉ̀gyètdí kumì dɔ̀ná àrʉ̀gyètdí nà ídzì alɛ, yà ɨ̀mbǎ rɨ́’ɨ̀ ɨ̀ ɨ́ ’ʉ̀gɛ̀rɛ̀ ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga dhu-atdyú nà dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Ndɨrɔ̀, ádhɨ pbá tsìbhálɛ, ɨdrɛ fʉ̀rangà-kpɔ̌ nà ndɨ̀ ndɨ̀’ɨ̀, atdí ràdʉ̀ àwǐ nzínzìya ɔ̌ rɔ̀ rɔ̀, ɨ̀nzɨ̌ rádʉ̀ tarà nɔ́bɨ̀, ndàtsù ɨdzá nga, ndàdʉ̀ nga nɔ́nɛ̀ mběyi nyʉ́, ràrà àhʉ kàbà ndɨ̀ ndárà dhu ɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ndɨrɔ̀, ka ndɨ̀ ndàbà rɔ̀, ɨ́yàdhíyà rǎdʉ̀ ɔdhɨ́na núnzì, tɨná aróko alɛ mànà, ndàdʉ̀ àtɨ̀nà nɨ̌: ‹Nyàbhʉ ɨdhɛ̀kʉ rɨ̀ka ndɨ̀ ma mànà atdíkpá, ma màbà wà fudú rɔ̀ àwǐ idú fʉ̀rangà-kpɔ̌ nɨ́dhunɨ̌.› ");
INSERT INTO niy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ndɨ dhu bhěyi tɨ́, ma mɨ́ kʉ̀nɔ fʉ̌kʉ̀, Kàgàwà bhà màlàyíká-ɨdhɛ̀ rǎdʉ̀ ndɨ̀ka atdídɔ̌, atdí nzɛ́rɛngatálɛ kɛ̀lɛ̌ nʉ́gɛ̀rɛ̀ ndɨ̀, ndʉ̀bhà pbɨ̀ndà nzɛ́rɛnga rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Atdí alɛ nɨ́ɨ’ɨ̀ kpabhínzo nà ɔyɔ. ");
INSERT INTO niy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nɨ́ olù ɨngba náatɨ àbanà nɨ̌: ‹Àbá, íbhò yà pbʉ̀kʉ̀ ongyéngá ɔ̌ rɔ̀ ákǎ kibhò dzǎkà dhu-tsí fudu ɔ̀.› Nɨ́ abádhí t’ábanà nʉ́ʉndɔ pbɨ̀ndà ongyéngá-ɔ̌nga pbɨ̀ndà inzo-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nɨ́, ngúfe ɨdhɔ dzidɔ̌, olù ɨngba núudzí fɨ̌ndà ka kùbho dhu-tsí, ndàdʉ̀ àrà pbɨ̀ndà fʉ̀rangà nà ɨtsɛ nyʉ́ ngǎtsi pbìrì ɔ̀. Ányɨ̀, kǎtdɨ̀ fɔná dhu-tsè kɔ́rɔ́, yà adzɨ dɔ̌ dhɛ̀dhɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kǐtdègu fɔná fʉ̀rangà nɨ́nzǎ kɔ́rɔ́, nɨ́ àgǎyì nɨ́ɨsɨ́ wɔ̀ ndɨ pbìrì ɔ̌, àbadhi-ngbɔ̀ ràdʉ̀ ndɔ̀tdɨ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɨ́, àbadhi náarà òtsù ndɨ pbìrì ɔ̌ atdí alɛ bhà kasʉ ɔ̀. Ndɨ alɛ náadʉ̀ kòvì ràrà pbɨ̀ndà àdʉ̀ nóngù ɨnga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kǎránà ndòzè rɔ̌ ndòngù ndɨ̀ àdʉ̀ rɔ̌nyʉna itsu-kpɔ̌ nɨ̌, ndɨrɔ̀ kà tɔ̀ rɨ́ atdí dhu mà nábhʉ̌ alɛ náaránà ɨ̀’ɨ̀ rɔ̌ mbǎ. ");
INSERT INTO niy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nɨ́, kǎpɛ̀ ndɨ̀rɛ̀ nga afɨ́na ɔ̀, ndàdʉ̀ àtɨ̀nà: ‹Ífe kasʉtálɛ nyʉ́ àbadu tɔ̀ arɨ́ kasʉ nɔ́nzɨ, ’àdʉ̀ dhu ɔ̀nyʉ̀ ’ùlè nɨ̌ gòna mà rɔ̀dɨ̀, madʉ̀ àmbɛ ɔ̀vɛ̀ dɔ̌ ɨrɔ́ àwù nɨ̌! ");
INSERT INTO niy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma mɨ́ mɨvà madu ma àbadu bhà. Nɨ́ ma mítsi àtɨ̀nà àbadu nɨ̌: Àbá, ma máfǎ dhu ɔ̀rʉ̀-akpà-ɔ̀nzɨ̌, madʉ̀ dhu àfa ɔnzɨ̀nʉ́. ");
INSERT INTO niy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɨ́ ma màkǎ nzá kanzì ma tdɨ́tdɔ̌ pbʉ̀kʉ̀ ɨngba tɨ́. Ítsè madɨ̀ pbʉ̀kʉ̀ kasʉtálɛ nzínzì ɔ̌ atdí alɛ màtɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ʉrɔ́ rɔ̀, kǎdʉ̀ ndɨ̀và, ndàdu ndɨ̀ àbanà bhà. Nɨ́ àdɨ̀ kàdɨ̀ ɨtsɛta nyʉ́ rɔ́rɔ̀, kà t’ábanà náala ka, ndàdʉ̀ ɨzʉ nábà atdídɔ̌ kàdɔ̌. Nɨ́ kà t’ábanà náakʉ̀ kà ɨ, ndìtsì ndìbvu kàdɔ̌, ndàdʉ̀ kàmbo. ");
INSERT INTO niy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nɨ́ kà t’ídhùnà náadʉ̀ àtɨ̀nà kà nɨ̌: ‹Àbá, ma máfǎ dhu ɔ̀rʉ̀-akpà ɔ̀nzɨ̀, madʉ̀ dhu àfa ɔnzɨ̀nʉ́. Nɨ́, ma màkǎ nzá kanzì ma pbʉ̀kʉ̀ ɨngba tɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pbɛ́tʉ̀, kà t’ábanà náadʉ̀ àtɨ̀nà pbɨ̀ndà ɨnɔ nɨ̌: ‹Nyɔ̀nzɨ dhu tsàkàtsàkà nyǐdyì atdídɔ̌ àya kanzʉ̀ nyǎfɔ̌ kà-rɔ̌. Ndɨrɔ̀ nyìdyi pɛtɛ̀ nyǎfɔ̌ kɔ̌tsʉ́-kpɔ̀ rɔ̌, nyǎdʉ̀ kàyìtò nʉ́fɔ kà-pfɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nyìwǔ ɔ̀yɔ̌yɔ̀ ìkyì-akpǎ-ngba nà nyǒdù, àlɛ̌ ràdʉ̀ ádrʉ̀ngbǎ mʉ̀hɛndʉ̀ nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Obhó tɨ́, yàrɨ́ pbàkà ɨngba náavɛ̀, nɨ́ kɨ̀kyɛ̀ wà. Ndɨrɔ̀ kǎwí, nɨ́ kàrà wà ndàdu.› Nɨ́, ányɨ̀rɔ̌ rɔ̀, abádhí adʉ̀ ádrʉ̀ngbǎ mʉ̀hɛndʉ̀ nɔ́pɛ̀ ɨ̀ rɔ̀nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wɔ̀ dhu rɨ̌ ndɔ̀nzɨ rɔ̀, wɔ̀ alɛ bhà ádrʉ̀ngbǎ ɨngba nɨ́ɨ’ɨ̀ ɨnga bvʉ̀ ndɨ̀ ndàrànà rɔ̌. Nɨ́, ányɨ̀rɔ̀ ndɨ̀ ndàrà ìngo rɔ̀, ɨ́kyɛ̀rɔ̌ ndɨ̀ ndɔ̀dɨ̀ ɨdza-li’ɔ̀ ndɨtɔ tɨ́ ndɨ̀ rɔ́rɔ̀, kɨ̌rɨ adyi mà, ɔbɛ́ mànà tɔ́ wɔ̀gɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nɨ́ kǎnzi àbanà bhà kasʉtálɛ atdí, ndìvǔ wɔ̀ rɨ́ ndɔ̀nzɨ dhu-tɨ̀ tsʉ̀ná. ");
INSERT INTO niy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nɨ́ ndɨ kasʉtálɛ náadʉ̀ dhu àdu kà tɔ̀ ndàtɨ: ‹Adɔ̀nʉ nɨ́rà wà àhʉ. Nɨ́, ídzì rɔ̌ rɔ̀ kàrà ìngo dhu-okú dɔ̀ rɔ̀, àbanʉ àdʉ̀ ɔ̀yɔ̌yɔ̀ ìkyì-akpǎ-ngba nábhʉ kodù.› ");
INSERT INTO niy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nɨ́, ádrʉ̀ngbǎ ɨngba náadʉ̀ àkǒ, ndàdʉ̀ ndùvo ɨ̀nzɨ̌ ndotsú tɨ́ ɨdza. Kà t’ábanà náadʉ̀ àhʉ ɨdza rɔ̀, ndàdʉ̀ kà-afí nópè ndɨ́nɨ̌ otsú tɨ́ ɨdza. ");
INSERT INTO niy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nɨ́, kǎdʉ̀ dhu àdu àbanà tɔ̀ ndàtɨ: ‹Yà atɔ-akpá-tsʉ̀ náarɨ́ ndɔ̀vɨ̀ dhu bhěyi, ma marɨ́ kasʉ ɔ̀nzɨ ɨndʉ̀ ɨnɔ bhěyi. Ndɨrɔ̀, ma màpɛ̀ nzá mɔbɛ̀ ɔ̀tɛ̌nʉ dɔ̀nǎ atdíku màtɨ́. Nɨ́, nyɨ nyapɛ̀na nzá ɨ̀ndrɨ̌-ngba-tsí dhu mà níbhò mozè, mɔ̌nzɨ̀ mʉ̀hɛndʉ̀ nɨ̌ ɔdhɨ́du mànà! ");
INSERT INTO niy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pbɛ́tʉ̀, wɔ̀ pbʉ̀kʉ̀ ɨngba, fʉnʉ́ dhu-tsè natdɨ̀ kɔ́rɔ́ mʉ̀nyɔ̀nɨ̀ ɔ̌ nárà ìngo rɔ̀ nɨ́ ndɨ, nyɨ nyàdʉ̀ ɔ̀yɔ̌yɔ̀ ìkyì-akpǎ-ngba nábhʉ kodù kà tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kà t’ábanà náadʉ̀ àtɨ̀nà kà nɨ̌: ‹Pbànɨ̌ngbá, àlɛ̌ karóko nyɨ nà bìlǐnganà, ndɨrɔ̀ yà kɔ́rɔ́ fudú rɨ́’ɨ̀ dhu nɨ́ pbʉ̀kʉ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pbɛ́tʉ̀, dhu àkǎnà àlɛ̌ rɔ̀nzɨ̀ mʉ̀hɛndʉ̀, àlɛ̌-ɨdhɛ̀ ràdʉ̀ ndɨ̀ka. Obhó tɨ́, yàrɨ́ àvǎvɛ̀ adɔ̀nʉ nɨ́kyɛ̀ wà. Ndɨrɔ̀ kǎwí, nɨ́ kàla wà ndɨ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yěsù adʉ̀ yàrɨ́ dhu náwɛ átɔ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀: «Atdí ònzìtálɛ nɨ́ɨ’ɨ̀ atdí pbɨ̀ndà kasʉtálɛ nà. Ndɨ kasʉtálɛ kɨ̌lɨ rɨ̀’ɨ̀ kɔ́rɔ́ pbɨ̀ndà dhu-tsí dɔ̌ ádrʉ̀ngbǎlɛ tɨ́. Nɨ́ ka kadʉ̀ ndɨ kasʉtálɛ nɔ́bhʉ̀ katɨ, kà rarɨ́ pbɨ̀ndà ádrʉ̀ngbǎlɛ bhà dhu-tsí nɨ́nzǎ. ");
INSERT INTO niy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nɨ́ wɔ̀rɨ́ ádrʉ̀ngbǎlɛ náanzi ka, ndàdʉ̀ dhu ìvu tsʉ̀ná ndàtɨ: ‹Ádhu wɔ̀ ma márà ɨ̀rɨ̀nà rɔ̌ dʉ̀nʉ́ ka kʉ́nɔna rɔ́? Ɨ́tɛ̀ pɛ́ pbàkà dhu-tsí nɔ́dɔ nyɨ nyárɨ́ tɨ́ dhu idù. Rɔ̀pɛ̀ ndɨ̀ kòmbí, nyɨ́ nzɨ̌ adɨ tdɨ́tdɔ̌ pbàkà dhu-tsí dɔ̌ ádrʉ̀ngbǎlɛ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nɨ́ wɔ̀rɨ́ alɛ nɨ́ɨrɛ̀ nga afína ɔ̀, ndàtɨ: ‹Ma mɨ́ dhu ɔ̀nzɨ ɨ̀ngbǎ dhu bhěyi yà pbàkà ádrʉ̀ngbǎlɛ rɨ̌ ɨma nípfǒ pbɨ̀ndà dhu-tsí t’ɔ́dɔta-kàsʉ̌ ɔ̀ rɔ̀ rɔ̀? Tɨ́ mongò ɨnga nóbhì? Wɔ̀rɨ́ tɔ̀ ma mɨ́’ɨ̀ ɨ̀mbǎ ɔbɨ nà. Tɨ́ mongò dhu núnzi ìndrǔ-fɔ́? Wɔ̀rɨ́ nɨ̌ nyɨ̀du rǎdʉ̀ ɨ̀wʉ tɨ́ ɨ̀wʉ. ");
INSERT INTO niy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɨwà ma mʉ̀nɨ ma mɔ́nzɨna dhu, ndɨ́nɨ̌ ìndrǔ ongó tɨ́ makɔ mběyi fɨ̀rábvʉ̀ nǎ, mipfǒ ka kɨ́ kasʉ ɔ̀ rɔ̀ rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nɨ́rɔ̀ nɨ́ ndɨ kǎpɛ̀ ndùnzì pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ bhà wànzá nà arɨ́’ɨ̀ alɛ atdátdírà ɔ̌. Angyi ndɨ̀ nɨ̀tɔ̀ alɛ-tsʉ̌ kǐvú dhu, ndàtɨ: ‹Ífe dhu nyɨ nyɨ́’ɨ̀ nà pbàkà ádrʉ̀ngbǎlɛ bhà wànzá tɨ́?› Nɨ́ wɔ̀ alɛ adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‹Atdí mɨyà kàtinì akyɛ tɔ́.› Nɨ́ wɔ̀rɨ́ kasʉtálɛ adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: ‹Kànɨ̌ bhàrʉwà. Ádɨ̌ obvò nyadʉ̀ imbò kumì kàtinì akyɛ tɔ́ nándi kà dɔ̌ tsàkàtsàkà.› ");
INSERT INTO niy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tdɨ́tdɔ̌ kǐvú dhu ngǎtsi alɛ-tsʉ̌, ndàtɨ: ‹Olu ɨnyɨ, pbʉ̀kʉ̀ nɨ́ ìfe?› Nɨ́ wɔ̀ alɛ adʉ̀ dhu àdu ndàtɨ: ‹Ma mɨ́’ɨ̀ atdí mɨyà gɔ̀nɨ̌yà nganʉ̀-kpɔ̌ tɔ́ nà.› Nɨ́ wɔ̀ kasʉtálɛ náadʉ̀ àtɨ̀nà kà nɨ̌: ‹Kànɨ̌ pbʉ̀kʉ̀ bhàrʉwà. Ándǐ àrʉ̀ kumì.› ");
INSERT INTO niy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nɨ́, ádrʉ̀ngbǎlɛ níilè wɔ̀ ɨ̀mbǎ obhónánga nà pbɨ̀ndà kasʉtálɛ atdídɔ̌, àbadhi ɔ̀nzɨ̀ dhu nyɨ̀kpɔ́na ótdyù alɛ bhěyi dhu-okú dɔ̀ rɔ̀. Obhó tɨ́, yà adzɨ ɔ̌ alɛ-nyɨ̀kpɔ́ nótdyù atdídɔ̌ nyʉ́. Abádhí náarɨ́ nzínzìya ɔ̌ dhu nɔ́bhɔlɔ màgězì nà, ròsè yà awáwʉ̀ ɔ̌ arúbhi alɛ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nɨ́rɔ̀, ma mátɨna nyɨ̌ nɨ̌: nyùfě olo yà ɨ̀mbǎ fɨ̀ndá obhónánga nà otu ɔ̌ nyɨ̌ nyábà ongyéngá nɨ̌. Ndɨ dhu bhěyi nɨ́ ndɨ, dhu ìtsìnà ndɔ̀tdɨ̀ rʉ̀kʉ́ nɨ́nganɨ́, ɨ olo náadʉ̀ya tɨ́ ndɨ nyǎkɔ yà dhòdhódhónga nà nyɨ̌ nyóngo òko ɔ̀yá ɨdza ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Obhónánga dɔ̌ arɨ́ akɛkpá dhú-ngba nɔ́dɔ alɛ, nɨ́ ndɨ rádʉ̀ ádrʉ̀ngbǎ dhu nɔ́dɔ̀ átɔ̀ obhónánga dɔ̌. Ndɨrɔ̀, ɨ̀nzɨ̌ arɨ́ ákɛ̌kpá dhu nɔ́dɔ obhónánga dɔ̌ alɛ, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ádrʉ̀ngbǎ dhu mà nɔ́dɔ̀ átɔ̀ obhónánga dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nɨ́rɔ̀, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ àdʉ̀ yà fʉkʉ́ arɨ́’ɨ̀ yà adzɨ dɔ̌ ongyéngá nɔ́dɔ̀ obhónga dɔ̌, nɨ́ ádhɨ ndɨ ídzì ongyéngá-tɨdɔ̀ nábhʉ adʉ̀ya fʉ̌kʉ̀? ");
INSERT INTO niy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndɨrɔ̀ ɨnzá nyɨ̌ nyɔ̀dɔ̀ fʉkʉ́ ka kàbhʉ ngǎtsi alɛ bhà dhu mà mběyi rɔ̀, ádhɨ ndɨ fʉ̌kʉ̀ adʉ̀ya fʉ̀kʉ́ ongyéngá nyʉ́ nábhʉ? ");
INSERT INTO niy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ɨ̀nzɨ̌ atdí kasʉtálɛ mà rǎdʉ̀ ɔ́yɔ̌ ádrɔ̀drɔ̌ alɛ-kàsʉ̌ nɔ́nzɨ̀ atdí kàsʉmɨ̀ ɔ̌ tɨ́. Obhó tɨ́, kà rǎdʉ̀ atdí ádrʉ̀ngbǎlɛ nɔ́ndrɔ̀, ndàdʉ̀ ngǎtsi nózè. Ndɨrɔ̀ ngǎtsi nɨ̌, kà rǎdʉ̀ ndàpba atdí rɔ̌, ndàdʉ̀ ngǎtsi nɨ́dzɛ̀lɛ̀. Ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ Kàgàwà-kàsʉ̌ nɔ́nzɨ̀ atdíkpá fʉ̀rangà-kàsʉ̌ mànà.» ");
INSERT INTO niy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pbàfàrìsáyó, abhɔ ɨ̀ ózè fʉ̀rangà dhu-okú dɔ̀ rɔ̀, núubhínà Yěsù rʉ̌nɔna dhu nɨ́rɨ̀ rɔ̌, ’àdʉ̀ òko ’àmbɛ ndɨ dhu nʉ́gbɔ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌, nyɨ̌ nɨ́ obhónángatálɛ tɨ́ arɨ́ ’àbhʉ̌ ìndrǔ rɔ̀zʉ̀ ɨ̀ alɛ. Pbɛ́tʉ̀, Kàgàwà ʉ́nɨ wà afíku ɔ̀ nyɨ̌ nyɨ́rɛ̀na dhu. Obhó tɨ́, yà ìndrǔ rɔ̌zʉ̀na ádrʉ̀ngbǎ dhu tɨ́ dhu nɨ́ ndɨ Kàgàwà ɔ́ndrɔ̀ atdídɔ̌ dhu.» ");
INSERT INTO niy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Músà bhà Ʉyátá mà, pbànábí mànà tɔ́ kàsʉmɨ̀-tsʉ̀ náarà ìku bàtizò nubhónà Yùwanɨ̀ rɔ̌. Ndɨrɔ̀, rɔ̀pɛ̀ ndɨ̀ ndɨ Yùwanɨ̀ bhà kàsʉmɨ̀ ɔ̀ rɔ̀, ka kárʉ́nɔna nɨ́ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀. Nɨ́, ngǎtsi alɛ náarɨ́ ɔbɨ ɔ̀nzɨ fɨ̌ndà ndɨ́nɨ̌ ndɨ̀ ndotsú tɨ́ ndɨ idzi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yà adzɨ mà, ɔ̀rʉ̀-akpà mànà rǎdʉ̀ ʉ̀da ʉ̀da ɨsɔ́ nyʉ́, pbɛ́tʉ̀ yàrɨ́ Ʉyátá ɔ̌ atdí andítá-tʉ́tʉ̌ngba mà náawíya nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Atdí kpatsìbhálɛ mà náapɛ́ pbɨ̀ndà tsìbhálɛ nɔ́dhɔ, ndàdʉ̀ ngǎtsi tsìbhálɛ nɔ́kʉ̀, nɨ́ ndɨ alɛ nɔ́nzɨ̀ wà mʉ̀nyɔ̀nɨ̀. Ndɨrɔ̀ atdí kpatsìbhálɛ mà náapɛ́ àdʉ̀ pbɨ̀ndà kpatsìbhálɛ ɔ́dhɔ̀ tsìbhálɛ nɔ́kʉ, nɨ́ ndɨ alɛ ɔ̀nzɨ̀ wà mʉ̀nyɔ̀nɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Atdí alɛ nɨ’ɨ̀ ònzìtálɛ. Ndɨ alɛ nóongónà atdídɔ̌ ʉ́ya ɔrʉ́ odzìya nà mbɛrʉ̀ nʉ́fɔ. Bìlǐnganà kǒngónà àdɨ dhɛ̀dhɛ ɔ̌ tɨ́, ndàdʉ̀ ídzì ɔ̀nyʉ̀-tɨdɔ̀ kɛ̀lɛ̌ nɔ́nyʉ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ndɨrɔ̀, Làzarʉ̀ tɨ́ kátɨna alɛ nɨ’ɨ̀ nǎkʉ̀tálɛ. Ka nɨ’ɨ̀ otú ɨ́pbà ngbɔ̌na kɔ́rɔ́ alɛ. Nɨ́, kǒngónà àyi wɔ̀ ònzìtálɛ bhà ɨdza-lí. ");
INSERT INTO niy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kǒngónà àdʉ̀ ndòzè ndòngù ndɨ̀ ònzìtálɛ rɨ̌ dhu ɔ̀nyʉ dɔ̀ná rɔ̀ mɨzà dɔ̌ rɔ̀ rɨ́ ’àwà obvò ɔ̀nyʉ̀-ú’ǔ-nzo nɨ̌. Ndɨrɔ̀ ìtsě nóongónà àdʉ̀ ìwu, ’àmbɛ kà rɔ̌ otú dɔ̌nga nʉ́tda dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nɨ́ atdíku wɔ̀rɨ́ nǎkʉ̀tálɛ náavɛ̀, Kàgàwà bhà màlàyíká ràdʉ̀ afína nódyì, ’òwù nà ɔ̀rʉ̀-akpà ɔ̀, Àbràhamʉ̀-tɨ’ɔ̀. Ngǎtsi ɨdhɔ ɔ̌, wɔ̀ ònzìtálɛ náadʉ̀ ɔ̀vɛ̀ átɔ̀, kadʉ́ ɔ̀tdʉ̀nà. ");
INSERT INTO niy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nɨ́ ɔvɛ-bvʉ̀, àzèmbè ndɨ̀ ndɨ́ àpbɛ̀ nábà abhɔ nyʉ́ rɔ́rɔ̀, wɔ̀ ònzìtálɛ náangbɛ dɔ̀na, ndàndà nga, ndàdʉ̀ Àbràhamʉ̀ nála ɨtsɛ rɔ̀, Làzarʉ̀ àdɨ tɨná rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nɨ́ wɔ̀ ònzìtálɛ náafà ndɨ̀ ndàtɨ: ‹Àbadu Àbràhamʉ̌, ábà ɨzʉ dùdú! Ávǐ Làzarʉ̀ ròdù ɔtsʉ́na-kpɔ̀-dɔ ɨdha ɔ̀, ndàdʉ̀ ɨ̀rà nà ɨdàdu-dɔ ma mɨdʉ́ tɨ́ nɨ̌. Obhó tɨ́, ma mɨ́’ɨ̀ ábhɔ̌ àpbɛ̀ nyʉ́ ɔ̌ yàrɨ́ kàzʉ ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pbɛ́tʉ̀ Àbràhamʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Pbànɨ̌ngbá, ɨ́rɛ̀ pɛ́ dhu: nyɨ nyábà ábhɔ̌ ídzìnga nyʉ́ pbʉ̀kʉ̀ ípìrɔ̌nga ɔ̌, pbɛ́tʉ̀ Làzarʉ̀ ɨ́’ɨ̀ àpbɛ̀ ɔ̌ pbɨ̀ndà ípìrɔ̌nga ɔ̌. Nɨ́ kòmbí Làzarʉ̀ rɨ̌’ɨ̀ ídzìnga ɔ̌, ndɨrɔ̀ nyɨ nyɨ́’ɨ̀ àpbɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ndɨrɔ̀ ròsè kɔ́rɔ́ dhu dɔ̀nǎ, àlɛ̌-nzínzì ɔ̌ nyɨ̌ mànà rɨ́’ɨ̀ dhu nɨ́ ádzǐ ibhu-akpà. Nɨ́ àzú dhená rɔ̀ ìndrǔ rǎda tɨkʉ ɔ̀ nɨ̌ fangà rɨ̌’ɨ̀ ɨ̀mbǎ, ndɨrɔ̀ tɨkʉ ɔ̀nǎ rɔ̀ màtɨ́ ìndrǔ rɨ̌da tɨka ɔ̀ nɨ̌ fangà rɨ̌’ɨ̀ ɨ̀mbǎ átɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wɔ̀ ònzìtálɛ adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: ‹Ma mɨ̀tdɛ̀ nyɨ atdídɔ̌ àbadú. Ávǐ Làzarʉ̀ ràrà àba bhà pbanga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Obhó tɨ́, ma mɨ́’ɨ̀ ìnè imbò adɔ́du nà. Nɨ́, dhu àkǎ Làzarʉ̀ ràrà dhu ɔ̀vɔ̀ abádhí tɔ̀ ngàmbì bhěyi, akyɛ abádhí nóowuya ìwu átɔ̀ yàrɨ́ àpbɛ̀ tɔ́ ngari ɔ̀ nɨ̌.› ");
INSERT INTO niy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nɨ́ Àbràhamʉ̀ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: ‹Músà mà pbànábí mànà náandí dhu rɨ̌ ɨ̀’ɨ̀ ìnè àwú. Nɨ́ ɨ adɔ́nʉ àkǎ ɨ̀ rɨ̀rɨ̀ ɨ Andítá rʉ̌nɔna dhu!› ");
INSERT INTO niy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tdɨ́tdɔ̌ wɔ̀ ònzìtálɛ adʉ̀ àtɨ̀nà: ‹Ɨnzá wɔ̀ dhu àkǎ wɔ̀ dhu bhěyi, àbadu Àbràhamʉ̌. Ɔvɛ-bvʉ̀ rɔ̀ ndɨ̀ nɨ̀ngbɛ̀ atdí alɛ nyʉ́ náapɛ́ àrà dhu ɔ̀vɔ̀ abádhí tɔ̀, nɨ́ abádhí rǎdʉ̀ ’ʉ̀gɛ̀rɛ̀ ʉ̀gɛ̀rɛ̀, ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛ mʉ̀tsɔ.› ");
INSERT INTO niy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pbɛ́tʉ̀ Àbràhamʉ̀ adʉ̀ àtɨ̀nà àbadhi nɨ̌: ‹Ɨ̀nzɨ̌ abádhí náapɛ́ Músà mà, pbànábí mànà rʉ̌nɔna dhu nɨ́rɨ, nɨ́ abádhí rɨ̌ nzɨ̌ ibhu ɔ̀ rɔ̀ ndɨ̀ nɨ́ngbɛ̀ alɛ rʉ̌nɔna dhu mà nɨ́rɨ.›» ");
INSERT INTO niy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yěsù atɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ìndrǔ rǎdɨ ɨ̀mbǎ ndɨ̀’ɨ̀ ndàbhʉ̌ rɨ́ ndòtsù nzɛ́rɛnga ɔ̀ dhu nà dhu rɨ̌’ɨ̀ odú nyʉ́. Pbɛ́tʉ̀ ɔdhɨ̀nà nábhʉ̌ rɨ́ ròtsù nzɛ́rɛnga ɔ̀ alɛ rɨ̌’ɨ̀ àpbɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dhu ɔ̀fɔ̀ nga mběyi nyʉ́, kosò ádrʉ̀ngbǎ odu-ba ndɨ alɛ-tú, kadʉ̀ ndɨ alɛ nɨ́dɔ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̀, kɨ̀’ɨ̀ kàrɨ́ nzónzo nzínzì ɔ̌ atdí ngbángba mà nábhʉ̌ rɨ́ ròtsù nzɛ́rɛnga ɔ̀ alɛ tɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nɨ́rɔ̀, nyɔ̀dɔ nyɨ̌ mběyi nyɨ̌-tɨ́rɔ̀! Ɔdhɨ̀nʉ náapɛ́ dhu àfǎ ɔnzɨ̀nʉ́, nɨ́ dhu àkǎ nyɔvɔ̀ kàbhà afátá kà tɔ̀. Kǎpɛ́ ndʉ̀gɛ̀rɛ̀ ndʉ̀bhà pbɨ̀ndà nzɛ́rɛnga, nɨ́ dhu àkǎ nyʉbà dhu kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ndɨrɔ̀ kǎpɛ́ dhu àfǎ ɔnzɨ̀nʉ́ àrʉ̀bhʉ̀-gʉ̀na atdí adyi ɔ̌, ndàdʉ̀ ndàdu àrʉ̀bhʉ̀-gʉ̀na ndɨ̀rà àtɨ̀nà nyɨ nɨ̌: ‹Ma mʉ̀gɛ̀rɛ̀ wà ma mʉbhà pbàkà nzɛ́rɛ mʉ̀tsɔ.› Nɨ́ dhu àkǎ nyarà dhu ʉ̀bà rɔ̌ kà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wɔ̀ dhu-dzidɔ̌, pbɨ̀ndà uvitatálɛ náadʉ̀ àtɨ̀nà Ádrʉ̀ngbǎlɛ Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɨ́trɔ̌ fàká a’uta.» ");
INSERT INTO niy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nɨ́ Ádrʉ̀ngbǎlɛ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Fʉ̀kʉ́ a’uta nɨ́’ɨ̀ná gukyè hàràdalɨ̀ tɨ́ kátɨna itsu-kpɔ̌ bvʉ̌ màtɨ́, nɨ́ nyɨ̌ nyàmbɛ̀nà àtɨna yàrɨ́ itsu nɨ̌: ‹Ɨ́ngbɛ̀ nyɨ ɨvɛ́nʉ mànà, nyarà nyɔdɨ̀ ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̀›, nɨ́ kàmbɛ̀nà àdʉ̀ tsʉ̀kʉ́ dhu nɨ́rɨ̀ ɨ̀rɨ.» ");
INSERT INTO niy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Ádhɨ pbá alɛ nzínzìkʉ ɔ̌ ndɨ, yà ɨnga bvʉ̀ rɔ̀ ríngo, ngǎtsi nɨ̌ tàmà ndɨ̀ ndʉ̀ndà ɨ rɔ̀ ríngo pbɨ̀ndà kasʉtálɛ nɨ̌ rádʉ̀ àtɨ̀nà: ‹Ɨ́rà tsàkàtsàkà, ɔ̀nyʉ̀ nyɨ nyɔnyʉ tɨ́!› ");
INSERT INTO niy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pbɛ́tʉ̀ kà tɨ́ nzɨ̌ àdʉ̀ àtɨ̀nà kà nɨ̌: ‹Óyè ɔ̀nyʉ̀ idù. Ndɨrɔ̀ nyádʉ̀ nyʉfɔ́ nyɨ mběyi, nyadʉ̀ ɔ̀nyʉ̀ níbhò idù. Dhu ma mɔ̀nyʉ̀ madʉ̀ dhu ɔ̀mvʉ̀ dhu-dzidɔ̌ nɨ́ ndɨ, nyɨ nyadʉ̀na dhu ɔ̀nyʉ̀, nyadʉ̀ dhu ɔ̀mvʉ̀ átɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wɔ̀ ádrʉ̀ngbǎlɛ t’ádʉ̀ ɔ̀tsɔ̀ àbhʉ àbhʉ̌ ndɨ pbɨ̀ndà kasʉtálɛ tɔ̀ yà kà tɔ̀ ndɨ̀ ndàvinà dhu kɔ̀nzɨ̀ dhu-okú dɔ̀ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ nyʉ́ mà átɔ̀, nyɨ̌ nyapɛ́ yà fʉ̌kʉ̀ ka kàvinà dhu ɔ̀nzɨ kɔ́rɔ́, nɨ́ nyɨ̌ nyàkǎ nyǎtɨ: ‹Mǎ nɨ́ ɨ̀mbǎ tɨ̌ya nà kasʉtálɛ, mǎ mɔ̀nzɨ̀ yà àkǎ àkǎnà mɔ̌nzɨ̀ fàká kasʉ kɛ̀lɛ̌.›» ");
INSERT INTO niy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndárà rɔ́rɔ̀, Yěsù nʉ́ʉdà Sàmàrɨyà tɔ́ pbìrì mà Gàlìlayà tɔ́ pbìrì mànà nzínzì ɔ̌ ifo ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nɨ́ atdí pbanga ɔ̀ kà rǒtsù rɔ́, ɨdrɛ̀ kɨ́kɨ́tálɛ náatù ɨ̀ kà mànà. Nɨ́, ɨtsɛta ɨ̀ ìkò rɔ́rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","abádhí apɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌: «Yěsù, Màlimǒ, ábà ɨzʉ dɔ̀ká!» ");
INSERT INTO niy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nɨ́, abádhí ndɨ̀ ndàla rɔ̀, Yěsù atɨ abádhí nɨ̌: «Nyòwu nyɨ̀tɛ̀ nyɨ̌ pbàkùhánɨ́ tɔ̀.» Nɨ́ ányɨ̀ ɨ̀ ówu rɔ́rɔ̀, abádhí náala ɨ̀ ɨwà ɨ̀ ʉ̀gʉ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nɨ́ abádhí nzínzì ɔ̌ atdí alɛ níitdègu ndɨ̀ ndɔ̀gʉ̀ dhu nálǎ, náadù ndɨ̀ owùna-lú, Kàgàwà nɨ́fʉ̌ ndɨ̀ ndɨ́ ɔrʉ́ tǔna nyʉ́ nà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nɨ́, kǐtsi ndìbvu Yěsù-pfɔ̀ rɔ̌, ndàpbǎ nyɨ̀na adzɨkpa nyʉ́ rɔ̌, ndàdʉ̀ ɔ̀tsɔ̀ nábhʉ Yěsù tɔ̀. Wɔ̀ ndɨ alɛ nɨ’ɨ̀ Sàmàrɨyà tɔ́ pbìrì ɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nɨ́, Yěsù ivú dhu ndàtɨ: «Nɨ̀’ɨ̀ tɨ́ obhó ɨdrɛ̀ alɛ ɨ ʉ̀gʉ̌ ʉ̀gʉ kɔ́rɔ́? Nɨ́ àrʉ̀gyètdí ngʉ̌kpà alɛ rɨ̌’ɨ̀ àdhà? ");
INSERT INTO niy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tɨ́ yà vurò pbìrì ɔ̌ atdí alɛ kɛ̀lɛ̌ ndɨ ndɨ̀ nàdu ndɨ̀rà Kàgàwà nɨ́fʉ?» ");
INSERT INTO niy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà wɔ̀ ndɨ alɛ nɨ̌: «Ɨ́và nyɨ, nyadʉ̀ àrà. Ɨwà pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ nyɨ.» ");
INSERT INTO niy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pbàfàrìsáyó nívǔ Kàgàwà rɨ̌ idzi nɔ́nyʉ ìndrǔ dɔ̌ ɔ̀ná ɨdhɔ Yěsù-tsʉ̌ rɔ̀, kǎdʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Kàgàwà rɨ̌ idzi nɔ́nyʉ ìndrǔ dɔ̌ ɔ̀ná ɨdhɔ rɨ̌ nzɨ̌ ɨ̀rà alɛ-nyɨ̀kpɔ́ nɨ̌ kádʉ̀ àlanà ɔ́fɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ka kɨ́ nzɨ̌ àdʉ̀ àtɨ̀nà: ‹Nyàndà, kà rɨ̌’ɨ̀ ɨrɔ́!› Ndɨrɔ̀ ngǎtsi nɨ̌: ‹Kà rɨ̌’ɨ̀ ndɔrɔ́!› Obhó tɨ́, ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi nɨ́ rɨ̌’ɨ̀ ìnè nzínzìkʉ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà ábhàlɨ̌ nɨ̌: «Ɨdhɔ nɨ́ɨ’ɨya ìnè yà Ìndrǔ t’ídhùnà bhà ɨdhɔ nózè nyɨ̌ nyɨ́ nyǎla atdí màtɨ́ ɔ̀ná, pbɛ́tʉ̀ nyɨ̌ nyadʉ̀ya nzɨ̌ kàla. ");
INSERT INTO niy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka kowuya àtɨ̀nà rɔ̌ nyɨ̌ nɨ̌: ‹Kà rɨ̌’ɨ̀ ndálʉ̀!› ngǎtsi nɨ̌: ‹Kà rɨ̌’ɨ̀ ɨrɔ́!› Nɨ́, àpɛ́ nyǒwuya òwu rɔ̌ ányɨ̀, ndɨrɔ̀ àpɛ́ nyǒwuya òtse rɔ̌ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Obhó tɨ́, àdhàdhɨ̀ ɔvɔ náarámbɨlɨ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌, atdídhená adzɨ-igì ɔ̀nǎ rɔ̀, ndʉ̀dà ngǎtsi adzɨ-igì ɔ̀ dhu bhěyi, Ìndrǔ t’ídhùnà bhà ɨdhɔ ɔ̌ dhu nɨ́ɨ’ɨya ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pbɛ́tʉ̀, dhu àkǎ pɛ́ kà ràbà àpbɛ̀ abhɔ nyʉ́ angyi, ndɨrɔ̀ yà indo arɨ́’ɨ̀ alɛ ràdʉ̀ kɔ̀dhɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nʉwà bhà kàsʉmɨ̀ ɔ̌ ndɨ̀ nanzɨ̀ dhu-tɨdɔ̀ nɔ́ɔnzɨya ndɨ̀ ndɨ dhu bhěyi tɨ́ Ìndrǔ t’ídhùnà bhà ɨdhɔ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ndɨ kàsʉmɨ̀ ɔ̌, ìndrǔ nóongónà ’ɔ̀nyʉ̀, ’àdʉ̀ ’ɔ̀mvʉ̀. Abádhí ongónà ’ʉ̀mba, ’àdʉ̀ fɨ̀yɔ́ nzónzo nábhʉ rʉ̀mbǎ ɨ̀, ràrà àhʉ Nʉwà rǒtsù sàfinà ɔ̀ ɔ̀ná ɨdhɔ ɔ̀. Wɔ̀ dhu-dzidɔ̌ nɨ́ ndɨ, ádrʉ̀ngbǎ igye nɨ́ɨkɔ́, ɨdha ràdʉ̀ yà adzɨ dɔ̌ kɔ́rɔ́ dhu-tsí àmbili, ndàdʉ̀ ìndrǔ-tsè nɔ́tdɨ̀ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndɨrɔ̀ kɔ̌nzɨya ndɨ̀ átɔ̀, yà Lotì bhà kàsʉmɨ̀ ɔ̌ ndɨ̀ nanzɨ̀ dhu bhěyi. Ndɨ kàsʉmɨ̀ ɔ̌, ìndrǔ nóongónà ’ɔ̀nyʉ̀, ’àdʉ̀ ’ɔ̀mvʉ̀. Abádhí ongónà ɔdhɨ́ya-fɔ́ dhu núdzi, ’àdʉ̀ òwu fɔyá dhu núbho rɔ̌ ɔdhɨ́ya rùdzǐ átɔ̀. Abádhí ongónà itse núzo ɨnga ɔ̌, ’àdʉ̀ òwu ɨdza nʉ́sɨ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pbɛ́tʉ̀ Lotì àhʉ Sɔ̀dɔmɔ̀ tɔ́ kɨgɔ̀ ɔ̌ rɔ̀ nɨ́nganɨ́, Kàgàwà náabhʉ̀ ɔ̀rʉ̀ rɔ́rʉ̀ odu tɔ́ kàzʉ rɨ̀pbà ndɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, rɔ̀tdɨ̀ Sɔ̀dɔmɔ̀ ɔ̌ bhà-tsè kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nɨ́, dhu nɔ́ɔnzɨya ndɨ̀ ndɨ dhu bhěyi tɨ́ Ìndrǔ t’ídhùnà rɨ̌ ndàvǐ ìndrǔ tɔ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ndɨ nɨ́nganɨ́, pbɨ̀ndà ɨdza dɔ̀ ka kɔ́bhɔ̀lɔ̀ okota tɔ̀ ngari ɔ̀ ndɨ̀ nòtù alɛ, pbɨ̀ndà dhu-tsí ràdʉ̀ ɨ̀’ɨ̀ ɨdza, náakáya nzɨ̌ ndìfò, ndàhʉ ɨ dhu-tsí núgù. Ndɨ dhu bhěyi tɨ́, ɨnga bvʉ̀ ndɨ̀ nòtù alɛ náakáya nzɨ̌ ndàdu ndɨ̀ ɨbha. ");
INSERT INTO niy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nyɨ̀rɛ̀ pɛ́ Lotì-ve rɔ̌ ndɨ̀ nanzɨ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pbɨ̀ndà ípìrɔ̌nga nòzè ndɨ̀gʉ̌ alɛ níiwíya ka. Pbɛ́tʉ̀ pbɨ̀ndà ípìrɔ̌nga níwǐ rɨ́ alɛ náadʉ̀ya kɔ̀dɔ̀ ɔ̀dɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ma mɨ́ kʉ̀nɔ fʉ̌kʉ̀, ndɨ iku ɔ̌, ɔ́yɔ̌ rɔ̀ ɨ̀ nòtù atdí ara dɔ̌ alɛ nzínzì ɔ̌ rɔ̀ ka kowuya atdí alɛ nódyì rɔ̌, kadʉ̀ ngǎtsi alɛ nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɔ́yɔ̌ rɔ̀ rɨ́ dhu ò’ù atdíkpá odu dɔ̌ rɔ́ ɨ̀ nòtù vèbhálɛ nzínzì ɔ̌ rɔ̀, ka kowuya atdí nódyì rɔ̌, kadʉ̀ ngǎtsi nʉ́bhà. ");
INSERT INTO niy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɔ́yɔ̌ rɔ̀ ɨ̀ nòtù ɨnga-bvʉ̌ kpabhálɛ nzínzì ɔ̌ rɔ̀, ka kowuya atdí alɛ nódyì rɔ̌, kadʉ̀ ngǎtsi alɛ nʉ́bhà.» ");
INSERT INTO niy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Wɔ̀rɨ́ dhu ɔnzɨya ndɨ̀ àdhà Ádrʉ̀ngbǎlɛ́?» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Abvo rɨ̌’ɨ̀ rɔ́nga nɨ́ ndɨ pbàsɛ̀gɛ̀ núunduya ɨ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yěsù awɛ atdí mbólí pbɨ̀ndà ábhàlɨ̌ tɔ̀, ndɨ́nɨ̌ ɨtɛ̀ tɨ́ dhu abádhí ràkǎ ’òngò ’ɨ̀tsɔ̀ bìlǐnganà ɨ̀nzɨ̌ ɨ̀ ɨ́ ɨ̀ngyɛ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kǎtɨ: «Atdí kɨgɔ̀ ɔ̌, anya t’ɨ́tdɨ̀ta tɔ́ atdí alɛ nɨ́ɨ’ɨ̀ ìnè. Ndɨ alɛ nɨ’ɨ̀ ɨ̀nzɨ̌ arɨ́ Kàgàwà ɔdɔ̀ nɔ́nzɨ, ndɨrɔ̀ ɨ̀nzɨ̌ arɨ́ atdí alɛ mà nɨ́fʉ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ndɨrɔ̀, ndɨ kɨgɔ̀ ɔ̌, atdí abvo-àyi nɨ́ɨ’ɨ̀ ìnè átɔ̀. Nɨ́ ndɨ abvo-àyi ongónà ɨ̀rà anya t’ɨ́tdɨ̀ta t’álɛ-tɨ’ɔ̀, ndàdʉ̀ ndɨ̀tsɔ̀ kà-rɔ̌, ndàtɨ: ‹Ʉ́nɔ ànyǎka pbàkà anyatálɛ mànà.› ");
INSERT INTO niy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nɨ́ ábhɔ̌ ɨdhɔ nyʉ́ tɨ́, wɔ̀ anya t’ɨ́tdɨ̀ta t’álɛ náazè nzá ndʉ̀nɔ̀ ndɨ anya. Nɨ́rɔ̀ nɨ́ ndɨ atdíku kɨ̌rɛ̀ nga, ndàtɨ: ‹Ma mɨ́ mbǎ ɨ̀nzɨ̌ ma marɨ́ Kàgàwà ɔdɔ̀ nɔ́nzɨ dhu màtɨ́, ndɨrɔ̀ ɨ̀nzɨ̌ ma marɨ́ atdí alɛ mà nɨ́fʉ̌ dhu màtɨ́, ");
INSERT INTO niy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nɨ́, bìlǐ kǎrɨ́ tsìdu àvǎ dhu-okú dɔ̀ rɔ̀, dhu àkǎ wà mʉnɔ̀ abádhí-ànyǎ pbɨ̀ndà anyatálɛ mànà, akyɛ kǒngóna ɨ̀rà dùdu-ɔ̌nga ʉ̀kpà nɨ̌.›» ");
INSERT INTO niy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ádrʉ̀ngbǎlɛ Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̀rɨ pɛ́ wɔ̀ ɨ̀mbǎ obhónga nà anya t’ɨ́tdɨ̀ta t’álɛ nʉ́ʉnɔ dhu! ");
INSERT INTO niy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nɨ́, Kàgàwà tɨ́ nzɨ̌ àdʉ̀ yà adyíbhengá nga mà, kùbhingá nga mànà ɔ̌ arɨ́ ’ɨ̀tsɔ̀ rɔ̀ná fɨ̌ndà ndɨ̀ ndavò alɛ rɔ̌ dhu nʉ́tsɛ̀? Kà tɨ́ àdʉ̀ ɨ̀nɛ̀ ɨ̀nɛ̀ abádhí rɔ̌? ");
INSERT INTO niy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ma mátɨna nyɨ̌ nɨ̌: kà ràrǎdʉ̀ abádhí-rɔ̌ dhu nʉ́tsɛ̀ tsàkàtsàkà nyʉ́. Pbɛ́tʉ̀, Ìndrǔ t’ídhùnà rǐngo nɨ́nganɨ́, kǒtúya tɨ́ tdʉ̌ a’uta nà alɛ yà adzɨ dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tdɨ́tdɔ̌, Yěsù awɛ yàrɨ́ mbólí yà obhónángatálɛ tɨ́ arɨ́ ’ɔ̀zʉ̀, ’àdʉ̀ ngʉ̌kpà alɛ-gàyà nɔ́nzɨ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kǎtɨ: «Ɔ́yɔ̌ alɛ náatsù Kàgàwà bhà ɨdza, ndɨ́nɨ̌ ’ɨtsɔ̀ tɨ́ ɨ̀. Atdí abádhí nzínzì ɔ̌ alɛ nɨ’ɨ̀ Mʉ̀fàrɨ̀sayò, ndɨrɔ̀ ngǎtsi alɛ nɨ’ɨ̀ pàratà tɔ́ ndɔmbɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nɨ́, Mʉ̀fàrɨ̀sayò níidè, ndàmbɛ ndɨ̀tsɔ̀ dɔ̌ afína ɔ̀, ndàtɨ: ‹Ɔ̀ɔ Kàgàwǎ, ma màbhʉ ɔ̀tsɔ̀ nyʉ́ ɨndʉ̀, ɨ̀mbǎ ma marɨ́’ɨ̀ ngʉ̌kpà alɛ-tsí bhěyi nɨ́dhunɨ̌. Ɨ alɛ nɨ́ kǎkà ogbo ɔ̀nzɨ arɨ́ alɛ, kǎkà ɨ̀nzɨ̌ nɨ́ obhónángatálɛ, ndɨrɔ̀ kǎkà mʉ̀nyɔ̀nɨ̀ ɔ̀nzɨ arɨ́ alɛ. Ndɨrɔ̀ ma nɨ́ nzɨ̌ pàratà tɔ́ yàrɨ́ ndɔmbɛ̀ bhěyi alɛ. ");
INSERT INTO niy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ma márɨ́ ɔ̀nyʉ̀ t’ɔ́nyʉta-tsʉ̀ nʉ́tsɨ ɔyɔ-gʉ̀na atdí yɛngɛ̀ rɔ̌. Ndɨrɔ̀ ma marɨ́ pbàkà kɔ́rɔ́ ongyéngá tɔ́ atdínga ɨdrɛ̀ dɔ̌ núbhǒ pɛrɛ̀ tɨ́ ɨndʉ̀.› ");
INSERT INTO niy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pbɛ́tʉ̀, wɔ̀ pàratà tɔ́ ndɔmbɛ̀ níidè ɨtsɛta, ɨ̀nzɨ̌ ndòzè ndàngbɛ dɔ̀na, ndàndà ɔrʉ̀ nga mà. Pbɛ́tʉ̀, kǎdɨ̀ ndàmbɛ odrùna-dɔ nʉ́pbɨ̀ dɔ̌ ɨzʉ nà, ndàdʉ̀ àmbɛ àtɨ̀nà dɔ̌: ‹Ɔ̀ɔ Kàgàwǎ, ábà ɨzʉ dùdú, ɨma nzɛ́rɛngatálɛ tɨ́rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma mátɨna nyɨ̌ nɨ̌: wɔ̀rɨ́ pàratà tɔ́ ndɔmbɛ̀ náadù ndɨ̀ pbɨ̀ndà ɨwà Kàgàwà nɔ́zʉ̀ ndɨ̀ ídzì alɛ tɨ́ rɔ́rɔ̀. Obhó tɨ́, ndɨ̀dzɨ̌ rɨ́ ndɨ̀tɨ́rɔ̀ ɔrʉ́ alɛ nɨ́ ka kifoya obvò. Ndɨrɔ̀, ndìfǒ rɨ́ obvò ndɨ̀tɨ́rɔ̀ alɛ nɨ́ ka kɨdzɨ́ya ɔrʉ́.» ");
INSERT INTO niy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ìndrǔ nóowúnà ìwu rɔ̌ ɨba-tsʉ̀nǎ nzónzo nà Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ kʉ̌lɨ tɨ́ ɔtsʉ́na dɔ̀yá. Pbɛ́tʉ̀, wɔ̀ dhu ɨ̀ àla rɔ̀, ábhàlɨ̌ adʉ̀ ɔ̀rʉ̀ ɔ̀rʉ̀ tɨ́ ɨ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nɨ́ Yěsù adʉ̀ ɨ nzónzo nónzì kiwǔ nà tɨna ɔ̀, ndàdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyʉ̀bhà nzónzo rìwǔ tɨdu ɔ̀, ɨ̀nzɨ̌ nyǎtɔ̀ tsʉ̀ya. Obhó tɨ́, Kàgàwà bhà idzi nɨ́ abádhí bhěyi ɨ̀ nʉ́lɨ alɛ tɔ́. ");
INSERT INTO niy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨ̀nzɨ̌ rɨ́ Kàgàwà bhà idzi nákɔ̌ ákɛ̌ ngbángba bhěyi alɛ, nóotsúya nzɨ̌ akɛkpá màtɨ́ kà ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Atdí ádrʉ̀ngbǎlɛ níivú dhu Yěsù-tsʉ̌, ndàtɨ: «Ídzì màlimǒ, ádhu ndɨ àkǎ àkǎ mɔnzɨ̀, ndɨ́nɨ̌ ma mabá tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga?» ");
INSERT INTO niy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nɨ́ Yěsù adʉ̀ dhu ìvu kà-tsʉ̌ ndàtɨ: «Ádhu nyɨ nyɨ́ ma ànzi ídzì alɛ tɨ́ nɨ̌? Ɨ̀mbǎ ídzì alɛ rɨ̌’ɨ̀ atdí màtɨ́. Kàgàwà kɛ̀lɛ̌ atdírɔ̀ nɨ́ ndɨ ídzì alɛ. ");
INSERT INTO niy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyɨ nyʉ́nɨ wà Ʉyátá: ‹Dhu àkǎ nzá nyɔnzɨ̀ mʉ̀nyɔ̀nɨ̀, dhu àkǎ nzá nyohò abvo, dhu àkǎ nzá nyɔnzɨ̀ ogbo, dhu àkǎ nzá nyʉnɔ̀ tɨ̀tɔ̀ ɔdhɨ̀nʉ dɔ̌. Ndɨrɔ̀, dhu àkǎ nyɨfʉ àbanʉ mà ɨ́yànʉ nà.›» ");
INSERT INTO niy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nɨ́ wɔ̀ alɛ náadʉ̀ dhu àdu Yěsù tɔ̀ ndàtɨ: «Ma mɨ́fʉ kɔ̌kɔ̀rɨ́ Ʉyátá kɔ́rɔ́, rɔ̀pɛ̀ ndɨ̀ idú ngbángba ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Atdí dhu nɨ́ ndɨ ndɨ̀ nʉ̀bhà tdɨ́tdɔ̌ ɨndʉ̀: dhu àkǎ nyudzǐ fʉnʉ́ arɨ́’ɨ̀ dhu kɔ́rɔ́, nyadʉ̀ kà ɔ̀ rɔ̀ nyɨ nyòngyè fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀, nɨ́ nyɨ nyádʉ̀ ɨ̀’ɨ̀ ònzì nà ɔ̀rʉ̀-akpà ɔ̀. Wɔ̀ dhu-dzidɔ̌, nyádʉ̀ nyɨra, nyadʉ̀ owùdu nʉ́ngʉ.» ");
INSERT INTO niy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, ɨzʉ nʉ́ʉka ka atdídɔ̌, abhɔ ndɨ̀ ndónzì dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yěsù níitdègu ɨzʉ nʉ́ka ka atdídɔ̌ dhu nálǎ, náadʉ̀ àtɨ̀nà kà nɨ̌: «Ònzì t’álɛ rǒtsù Kàgàwà bhà idzi ɔ̀ dhu rɨ̌’ɨ̀ ɔbɨ nyʉ́ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Obhó tɨ́, dhu rɨ̌’ɨ̀ ɨsɔ́ nyʉ́ ngàmɨyà ròtsù ndʉ̀dà sìndanɨ̀-bhu ɔ̀nǎ, ròsè ònzìtálɛ rǒtsù Kàgàwà bhà idzi ɔ̀ dhu dɔ̀nǎ.» ");
INSERT INTO niy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɨ́, wɔ̀ Yěsù rʉ̌nɔna dhu nɨ̀rɨ̀ alɛ níivú dhu kà-tsʉ̌, ’àtɨ: «Olu, ádhɨ nyʉ́ ndɨ ɔ̀gʉ̀ rádʉ̀ ɔ̀gʉ̀?» ");
INSERT INTO niy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ìndrǔ-lɛ̀mà nɔ̀nzɨ̀ dhu rɨ̌ nzɨ̌ àdʉ̀ Kàgàwà-lɛ̀mà nɔ́nzɨ̀.» ");
INSERT INTO niy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Kànɨ̌, mǎ mʉ́bhà fɔká dhu, mǎdʉ̀ owùnʉ nʉ́ngʉ.» ");
INSERT INTO niy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Ìndrǔ náapɛ́ pbɨ̀ndà ɨdza mà, pbɨ̀ndà ɨngba-tsánà mà, adɔ́na mà, àbanà mà, ɨ́yànà mà, pbɨ̀ndà inzo mànà nʉ́bha ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi-okú dɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nɨ́, yà kòmbí rɨ́’ɨ̀ kàsʉmɨ̀ ɔ̌, kà rɨ̌ dhu nábà abhɔ nyʉ́ ròsè. Ndɨrɔ̀, olù rɨ́rà kàsʉmɨ̀ ɔ̌, kǎdʉ̀ya dhòdhódhónga tɔ́ ípìrɔ̌nga nábà.» ");
INSERT INTO niy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yěsù núugu pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ tɨna ɔ̀, ndàdʉ̀ àtɨ̀nà nɨ̌: «Kànɨ̌ àlɛ̌ kúpo Yèrùsàlɛmà. Nɨ́ kɔ́rɔ́ dhu, yà pbànábí náandí Ìndrǔ t’ídhùnà dɔ̌, nɨ́ ràkǎ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Obhó tɨ́, ka kɨ́ àbadhi nípfǒ, kabhʉ yà ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí-fɔ́. Ndɨrɔ̀ ka kɨ́ kʉ̀gbɔ̌ kadʉ̀ àvu rɔ̀ná, kadʉ̀ ɨsɔ núso kà dɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ndɨrɔ̀, asé nɨ̌ ka kʉ̀vɨ ka dhu-dzidɔ̌, ka kadʉ̀ya kòhò, kadʉ̀ ɔ̀tdʉ̀nà. Nɨ́ ɨ̀bhʉ ɨdhɔ dzidɔ̌, kǎdʉ̀ya ndɨ̀ngbɛ̀.» ");
INSERT INTO niy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pbɛ́tʉ̀ wɔ̀ Yěsù ʉ̀nɔ̀ dhu náadʉ̀ nzá abádhí-dɔ nálʉ akɛkpá màtɨ́. Ndɨ ɔtɛ-tɨ̀ náarù ndɨ̀ òru tɨ́ abádhí rɔ̌, ɨ̀nzɨ̌ abádhí ràdʉ̀ àdhu dɔ̌ màtɨ́ Yěsù rɔ̌tɛ dhu nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yěsù níitdègu Yɛ̀rɨkɔ̀ tɔ́ kɨgɔ̀ níndù, nɨ́ kǎtù atdí ndùmùndúmú otu-igì dɔ̌ àdɨ, ndàmbɛ dhu núnzi dɔ̌ ìndrǔ-fɔ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nɨ́, wɔ̀ ndùmùndúmú nɨ́ɨrɨ ihé-yà rʉ̌da dhu, ndàdʉ̀ dhu ìvu, àdhu mà rɨ̌ ndɔ̀nzɨ dhu ndɨ̀ ndʉnɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nɨ́ ka kadʉ̀ dhu ɔ̀vɔ̀ kà tɔ̀ katɨ: Yěsù, Nàzàretì ɔ̌ alɛ ràrɨ̌ wɔ̀ rʉ́da. ");
INSERT INTO niy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nɨ́ kǎkù, ndàtɨ: «Yěsù, Dàwudì nɨ̌ngbá, ábà ɨzʉ dùdú!» ");
INSERT INTO niy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nɨ́ yà angyi òkò ’àmbɛ òwu dɔ̌ alɛ náarʉ̀ kà dɔ̌, àdʉ̀ kàvi rɨ̀nɛ̀. Pbɛ́tʉ̀ kǎdʉ̀ òkù tdɨ́tdɔ̌ àrǐ nyʉ́ tɨ́, ndàtɨ: «Dàwudì nɨ̌ngbá, ábà ɨzʉ dùdú!» ");
INSERT INTO niy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nɨ́ Yěsù adʉ̀ ìde ndàdʉ̀ kàvi kiwǔ nà tɨna ɔ̀. Nɨ́, ɨ́kyɛ̀rɔ̌ kɨ̀rà àhʉ tɨná rɔ̀, Yěsù ivú dhu kà-tsʉ̌ ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ádhu nyɨ nyòzè mɔnzɨ̀ ɨndʉ̀?» Nɨ́ kǎdʉ̀ dhu àdu ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ma mòzè mala nga.» ");
INSERT INTO niy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Álǎ nà ɨnga! Ɨwà pbʉ̀kʉ̀ a’uta nɨ́gʉ̌ nyɨ!» ");
INSERT INTO niy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ ndùmùndúmú-nyɨ̀kpɔ́ náadʉ̀ ndɔ̀pɛ̀ ndàla nga, àbadhi ràdʉ̀ àrà Yěsù-owù ɔ̌, Kàgàwà-ɔvɔ̀ nílè ndɨ̀ ndɨ́ rɔ́rɔ̀. Ndɨrɔ̀ kɔ́rɔ́ alɛ, wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu nàla, náadʉ̀ Kàgàwà-ɔvɔ̀ nílè átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yɛ̀rɨkɔ̀ tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndòtsù rɔ̀, Yěsù náadɨ̀ ndàmbɛ ʉ̀da dɔ̌ ndɨ kɨgɔ̀ ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nɨ́ atdí alɛ Zàkayò tɨ́ kátɨna nɨ́ɨ’ɨ̀ ìnè ányɨ̀. Ndɨ Zàkayò nɨ’ɨ̀ pàratà tɔ́ pbàndɔ́mbɛ́ dɔ̌ ádrʉ̀ngbǎlɛ, ndɨrɔ̀ ka nɨ’ɨ̀ ònzìtálɛ. ");
INSERT INTO niy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nɨ́ kǎzè ndàla Yěsù ràrɨ̌ àdhɨ. Pbɛ́tʉ̀, kà rɨ̌ Yěsù nálǎ ihé-yà nzínzì ɔ̌ dhu nɨ́ɨ’ɨ̀ odú, ídǒ ndɨ̀ ndɨ́’ɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nɨ́ kǎkʉ̀ angyi, ndàdʉ̀ ùpo mùkuyù tɨ́ kátɨna itsu dɔ̀, ndɨ́nɨ̌ ndɨ̀ ndala tɨ́ Yěsù, ányɨ̀rɔ̌ kà rʉ̌da dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nɨ́, Yěsù níitdègu ɨ̀rà àhʉ ányɨ̀rɔ̌, nɨ́ kǎndà ɔrʉ̀ nga, ndàdʉ̀ àtɨ̀nà Zàkayò nɨ̌: «Zàkayǒ, ífo tsàkàtsàkà. Indo dhu àkǎ mɔdhɔ̀ pbʉ̀kʉ̀ ɨdzá.» ");
INSERT INTO niy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nɨ́ Zàkayò adʉ̀ ìfo tsàkàtsàkà, ndàdʉ̀ kàkɔ dhɛ̀dhɛ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nɨ́ wɔ̀ dhu nàla kɔ́rɔ́ alɛ náanù afíya ɔ̀, ’àmbɛ àtɨ̀nà dɔ̌: «Kàrà ɔ̀dhɔ̀ nzɛ́rɛngatálɛ bhà nyʉ́!» ");
INSERT INTO niy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pbɛ́tʉ̀ Zàkayò nɨ́ɨvà ndɨ̀ ndìdè, ndàdʉ̀ àtɨ̀nà Ádrʉ̀ngbǎlɛ Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, kànɨ̌ ma màbhʉ pbàkà ongyéngá tɔ́ atdínga ɔ́yɔ̌ dɔ̌ nǎkʉ̀tálɛ tɔ̀. Ndɨrɔ̀ dhu ɨ’ɨna gukyè ìndrǔ bhà dhu ma makɔ̀ tɨ̀tɔ̀ dɔ̌ dhu tɨ́, nɨ́ ma mɨ́ ndɨ dhu nádǔ ɨ̀fɔ-rà-dɔ̌ ndɨ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Indo ɔ̀gʉ̀ nɨ́rà wà àhʉ àzú-dzá, yàrɨ́ alɛ nɨ́ Àbràhamʉ̀ t’ídhùnà átɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Obhó tɨ́, Ìndrǔ t’ídhùnà ɨ́rà ùwǔwí alɛ nɔ́nɛ̀, ndɨ́nɨ̌ ndadʉ̀ tɨ́ ɨ̀gʉnà.» ");
INSERT INTO niy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yà ndɨ̀ ndʉ́nɔna dhu ɨ̀rɨ rɨ́ alɛ tɔ̀, Yěsù adʉ̀ yàrɨ́ mbólí náwɛ tdɨ́tdɔ̌. Obhó tɨ́, yà ɨ́kyɛ̀rɔ̌ Yěsù rɨ̌’ɨ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndotsú tɨ́ dhu-okú dɔ̀ rɔ̀, ìndrǔ náambɛ́nà ɨnga nɨ́rɛ̀ dɔ̌ afíya ɔ̀, kòmbí nga ràrɨ̌ ndɨ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi rɨ̌ ndɔ̀pɛ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nɨ́ kǎtɨ: «Atdí alɛ nɨ’ɨ̀ kamà-tɨdɔ̀. Nɨ́ ndɨ alɛ nɨ́ɨvà ndɨ̀ fɨ̀yɔ́ pbìrì ɔ̌ rɔ̀, ndàrà ɨtsɛ nyʉ́ vurò pbìrì ɔ̀, ndɨ́nɨ̌ ka kʉdɔ tɨ́ ndɨ̀ ádrʉ̀ngbǎ kamà tɨ́, ndɨ dhu-dzidɔ̌, ndàdʉ̀ ìngo fɨ̀yɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nɨ́, kǔnzi ɨdrɛ̀ alɛ pbɨ̀ndà kasʉtálɛ nzínzì ɔ̌ rɔ̀, ndàbhʉ ɨdrɛ̀ fʉ̀rangàfɔyá. Ndɨrɔ̀, kǎdʉ̀ dhu ʉ̀ya abádhí tɔ̀, ndàtɨ: ‹Nyɔ̀nzɨ mùtùruzì wɔ̀ fʉ̀rangà dɔ̌, ràrà àhʉ ma míngo dhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pbɛ́tʉ̀, kà mà tɔ́ pbìrì ɔ̌ alɛ náandrɔ̀ ka atdídɔ̌. Nɨ́ abádhí adʉ̀ ìndrǔ òvì ròwù kǒwù ɔ̌, ròwù àtɨ̀nà: ‹Mǎ mòzè nzá wɔ̀ alɛ rɔ̀nyʉ̀ idzi dɔ̀ká.› ");
INSERT INTO niy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nɨ́, ádrʉ̀ngbǎ kamà tɨ́ ka kʉ́dɔ ndɨ̀ dhu-dzidɔ̌, ndɨ̀ ndìngò fɨ̀yɔ́ pbìrì ɔ̀ rɔ̀, kǎvì kunzì kɔ̌kɔ̀ fʉ̀rangà ndɨ̀ ndʉndɔ fɔyá pbɨ̀ndà kasʉtálɛ, ndɨ́nɨ̌ ndɨ̀ ndʉnɨ tɨ́ ɨ̀ngbǎ dhu bhěyi màtɨ́ abádhí nɔ́nzɨ̀ kasʉ ndɨ fʉ̀rangà nɨ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nɨ́, wɛmbɛrɛ̀ tɔ́ alɛ nɨ́ɨra, ndàtɨ kà nɨ̌: ‹Ádrʉ̀ngbǎlɛ́, pbʉ̀kʉ̀ fʉ̀rangà nísě ndɨ̀ atdí kumì fʉ̀rangà nɨ̌.› ");
INSERT INTO niy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nɨ́ ádrʉ̀ngbǎlɛ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Ídzì dhu nɨ́ wɔ̀! Nyɨ nɨ́ ídzì kasʉtálɛ. Nyɨ nyɔ́dɔ̀ yà fʉnʉ́ ma mabhʉ̀ ákɛ̌kpá dhʉ́-ngba nyʉ́ mběyi. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, ma mɨ́ nyɨlɨ̌ nyadɨ ádrʉ̀ngbǎlɛ tɨ́ ɨdrɛ̀ kɨgɔ̀ dɔ̌.› ");
INSERT INTO niy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɔyɔ rɨ́ kìsě kasʉtálɛ nɨ́ɨra ndàdʉ̀ àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ́, pbʉ̀kʉ̀ fʉ̀rangà nísě ndɨ̀ imbò fʉ̀rangà nɨ̌.› ");
INSERT INTO niy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nɨ́ ádrʉ̀ngbǎlɛ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Ɨnyɨ nyʉ́ mà átɔ̀, nyɨ nyádɨ imbò kɨgɔ̀ dɔ̌ ádrʉ̀ngbǎlɛ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ngǎtsi kasʉtálɛ nɨ́ɨra, ndàdʉ̀ àtɨ̀nà: ‹Ádrʉ̀ngbǎlɛ, kànɨ̌ pbʉ̀kʉ̀ fʉ̀rangà. Ma makpɔrɔ ka mbɛrʉ̀ ɔ̀, madʉ̀ òrùnà. ");
INSERT INTO niy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Obhó tɨ́, ma marúbhi ɔdɔ̀nʉ nɔ́nzɨ̀ rɔ̌, ɨnyɨ nɨ́ atdídɔ̌ arɔ́rʉ̀ alɛ nɨ́dhunɨ̌. Nyɨ nyárɨ́ dhu ìdyi ɨnzá nyɨ nyɨlɨ dhu rɔ́, ndɨrɔ̀ nyɨ nyárɨ́ ɔ̀nyʉ̀ ògu ɨnzá nyɨ nyazò dhu rɔ́.› ");
INSERT INTO niy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nɨ́ ádrʉ̀ngbǎlɛ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Ma mɨ́ anya ɔ̀tdɨ̀ dʉ̀nʉ́ tsʉ̀nʉ-bvʉ rɔ̌. Ɨnyɨ nɨ́ nzɛ́rɛ kasʉtálɛ. Nyɨ nyʉnɨ wà dhu ma ràrɨ̌ ɔ̀rʉ̀ arɔ́rʉ̀ alɛ, ma rarɨ́ dhu ìdyi ɨnzá ma mɨlɨ dhu rɔ́, ndɨrɔ̀ ma rarɨ́ ɔ̀nyʉ̀ ògu ɨnzá ma mazò dhu rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nɨ́rɔ̀, ádhu ɨnzá nyɨ nyadʉ̀ àrà idú fʉ̀rangà nɨ́lɨ bǎkì ɔ̀ nɨ̌, ndɨ́nɨ̌ ma mɨ́rà àhʉ nɨ́nganɨ́, ma madʉ̀ya tɨ́ àkɔnà ɨwà dɔ̀ná nɨ́dɔ̀ rɔ́rɔ̀?› ");
INSERT INTO niy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà ányɨ̀rɔ̌ ɨ̀’ɨ̀ alɛ nɨ̌: ‹Nyàkɔ wɔ̀ kà-fɔ́ rɨ́’ɨ̀ fʉ̀rangà, nyǎdʉ̀ àbhʉnà yà ɨdrɛ rɨ́’ɨ̀ kà nà alɛ tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nɨ́ ɨ alɛ adʉ̀ àtɨ̀nà kà nɨ̌: ‹Ádrʉ̀ngbǎlɛ́, kà rɨ̌’ɨ̀ ìnè ɨdrɛ̀ fʉ̀rangà nyʉ́ nà.› ");
INSERT INTO niy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma mátɨna nyɨ̌ nɨ̌, ka kabhʉ̀ya dhu ìnè dhu rɨ̌’ɨ̀ fɔná alɛ tɔ̀. Pbɛ́tʉ̀ yà ɨ̀mbǎ rɨ́’ɨ̀ dhu nà alɛ-fɔ́ rɔ̀, ka kakɔ̀ya yà kà-fɔ́ rɨ́’ɨ̀ dhu mà. ");
INSERT INTO niy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ndɨrɔ̀ nyìwǔ pɛ́ yà ɨnzá ma nazè mɔnyʉ̀ idzi dɔ̀yá pbàkà òmvǔ-tsí nà ɨrɔ́, nyǎdʉ̀ àzènà ɔnzɨ̀dú rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wɔ̀ dhu bhěyi ndɨ̀ ndɔ̀tɛ̀ dhu-dzidɔ̌, Yěsù àdʉ̀ ʉ̀da ndàdɨ angyi ihé-yà tɔ̀, ndàdʉ̀ ùpo ndàrà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nɨ́ kǐtdègu Bɛ̀tɛ̀fagɛ̀ mà Bɛ̀tànɨyà mànà tɔ́ pbanga níndù, Mìzèyìtunì tɔ́ pbìrì ɨnǎ rɔ̀, nɨ́ kǎvì ɔ́yɔ̌ alɛ pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ rɔ̀ ròwù angyi, ");
INSERT INTO niy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ndàdʉ̀ àtɨ̀nà nɨ̌: «Nyòwu wɔ̀ angyi rɨ́’ɨ̀ pbanga ɔ̀. Nɨ́, ányɨ̀ nyɨ̌ nyówu ùvò rɔ̀, nyɨ̌ nyɨ́ ɨnzá atdí alɛ mà nápɛ̀ ùbhi dɔ̀ná angyi kayinǒ-ngba nótù òsò ka kòsò rɔ́. Nɨ́ nyàdʉ̀ nyʉ̌nga ka, nyǎdʉ̀ ìwu nà ɨrɔ́. ");
INSERT INTO niy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ndɨrɔ̀ atdí alɛ mà níivúna gukyè dhu tsʉ̀kʉ́ ndàtɨ: ‹Ádhu nyɨ̌ nyɨ́ kʉ̀ngǎ nɨ̌?› Nɨ́ nyɨ̌ nyadʉ̀na dhu àdu kà tɔ̀ nyǎtɨ ádrʉ̀ngbǎlɛ ràrɨ̌’ɨ̀ kǎtdyú nà.» ");
INSERT INTO niy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nɨ́ kɔ̌kɔ̀ Yěsù òvì alɛ náawù, ’àdʉ̀ kɔ́rɔ́ dhu-tsí nótù yà Yěsù nʉ́nɔ̀nà fɨ̌yɔ̀ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nɨ́ abádhí rɨ̌ kayinǒ-ngba nʉ́ngǎ rɔ̀ nɨ́ ndɨ, ndɨ kayinǒ-ngba-abádhí níivú dhu abádhí-tsʉ̌, ’àtɨ: «Ádhu nyɨ̌ nyɨ́ kayinǒ-ngba nʉ́ngǎ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nɨ́ abádhí adʉ̀ dhu àdu ’àtɨ: «Ádrʉ̀ngbǎlɛ rɨ̌’ɨ̀ kǎtdyú nà.» ");
INSERT INTO niy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Abádhí náadʉ̀ òwu wɔ̀rɨ́ kayinǒ-ngba nà Yěsù-tɨ’ɔ̀, ’àdʉ̀ rɔ̀yá ɔrʉ́ mʉ̀dzarʉ̀ nʉ́wà, ’ùhu dɔ̀ná, ’àdʉ̀ Yěsù àbhʉ rùpò ndàdɨ ndɨ kayinǒ-ngba dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nɨ́ yà Yěsù rǎrà angyi dhu bhěyi, ìndrǔ nóowúnà rɔ̀yá mʉ̀dzarʉ̀ nʉ́wà rɔ̌, ’ùhu otu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nɨ́ Yěsù itdègu Yèrùsàlɛmà tɔ́ kɨgɔ̀ níndù, yà Mìzèyìtunì tɔ́ pbìrì dɔ̀ rɔ̀ ráwǔ otu ɔ̌, nɨ́ kǒwu ɔ̌ ríwu ábhàlɨ̌ tɔ́ ihé-yà náadʉ̀ ’ɔ̀pɛ̀ ’ìlè Kàgàwà ɔrʉ́ tǔya nyʉ́ nà, yà Yěsù rɔ̌nzɨna kɔ́rɔ́ wɨwɨ̀ ɨ̀ àla dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Abádhí ambɛ́nà àtɨ̀nà dɔ̌: «Asota nákǎ yà Ádrʉ̀ngbǎlɛ Kàgàwà-ɔvɔ̀ rɔ̌ rɨ́rà ádrʉ̀ngbǎ kamà nà. Màrʉ̀ngà àkǎ ndɨ̀’ɨ̀ ɔ̀rʉ̀-akpà ɔ̀, ndɨrɔ̀, ilèta nákǎ ndɨ̀’ɨ̀ ɔ̀rʉ̀-akpà ɔ̌ ɔrʉ́ ngari ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nɨ́ ihé-yà nzínzì ɔ̌ ɨ̀’ɨ̀ ngúfe Pbàfàrìsáyó náatɨ Yěsù nɨ̌: «Màlimǒ, ɨ́sɔ̌ pbʉ̀kʉ̀ ábhàlɨ̌ rɨ̀nɛ̀.» ");
INSERT INTO niy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ma mátɨna nyɨ̌ nɨ̌: abádhí nɨ́ɨnɛ̀na gukyè, nɨ́ odu rɨ̌ ndɨ ùkǔ.» ");
INSERT INTO niy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yěsù itdègu ɨ̀rà àhʉ ɨ́kyɛ̀rɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ tɨ́ ndàdʉ̀ kàla, nɨ́ kǎpɛ̀ ndɔ̀dzɨ̀ kà dɔ̌, ");
INSERT INTO niy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ndàmbɛ àtɨ̀nà dɔ̌: «Yàrɨ́ ɨdhɔ ɔ̌, nyɨ nyʉ́ mà átɔ̀ nyɨ nyʉ́nɨ̌yana gukyè màrʉ̀ngà nábà nyɨ nyádʉ̀ tɨ́ dhu! Pbɛ́tʉ̀ kombí ndɨ dhu òrù wà ndɨ̀ rʉ̀nʉ́. ");
INSERT INTO niy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Obhó tɨ́, ɨdhɔ nɨ́ɨ’ɨya ìnè, yà pbʉ̀kʉ̀ òmvǔ rɨ̌ nyɔkɛ̀rɛ̀, ɨ̀ ràkpɔ̀rɔ̀ ngbɔ̌nʉ ɔ̀ná odu tɔ́ kàlɨ̀ nɨ̌, ɨ̀ rɨ̀lɨ nyɨ átsǐ, ’àdʉ̀ ’ɔ̀pɛ̀ ’ùgyè nyɨ kɔ́rɔ́ ngari ɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Abádhí rɨ̌ nyugòlǒ, ɨ̀ rɔ̀bɛ̀ ʉ̀nʉ́nga, ɨnyɨ, kɔ́rɔ́ ʉ̀nʉ́ aróko alɛ mànà. Ndɨrɔ̀, abádhí rɨ̌ nzɨ̌ ɨnyɨ ka kasɨ̀ nɨ̌ atdí odu mà nʉ́bha ràdɨ ngǎtsi odu dɔ̌, ɨnzá nyɨ nyʉnɨ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ mʉ̀dzʉ̀nà ɨ́rà ɨndʉ̀ ɔ̀ná kàsʉmɨ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kàgàwà bhà ɨdza ndɨ̀ ndòtsù rɔ̀, Yěsù adʉ̀ ndɔ̀pɛ̀ ndòdì ányɨ̀ ɨdzá rɔ̀ rɨ́ dhu ùdzǐ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kǎmbɛ́nà àtɨ̀nà dɔ̌ abádhí nɨ̌: «Andítá átɨ: ‹Pbàkà ɨdza nɨ’ɨya ɨtsɔ̀ta-dzà›, pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyádʉ̀ kʉ̀gɛ̀rɛ̀ ròngò ogbotálɛ náarɨ́ ɨ̀ núru ɔ̀nà ngari tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àdɨ ndàrà dhu ùdhe rɔ̌ ìndrǔ tɔ̀ bìlǐnganà Kàgàwà bhà ɨdzá rɔ̀. Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mà, ndɨrɔ̀ Pbàyàhúdí nzínzì ɔ̌ ádrɔ̀drɔ̌ alɛ mànà náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀mɛ̀ kàbhʉ ɨ̀ ádʉ̀ kohò ɔ̀ná otu. ");
INSERT INTO niy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pbɛ́tʉ̀ abádhí nʉ́ʉnɨ ɨnzá ɨ̀ ádʉ̀ ɔ̀nzɨ̀nà dhu, kɔ́rɔ́ alɛ rǒwu Yěsù rʉ̌nɔna dhu nɨ́rɨ̀ rɔ̌ atdyúya nyʉ́ nà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kɔ̌kɔ̀rɨ́ ɨdhɔ nzínzì ɔ̌, atdíku Yěsù adɨ̀ ndàmbɛ dhu ùdhe dɔ̌, ndàdʉ̀ àmbɛ Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ dɔ̌ ìndrǔ tɔ̀ Kàgàwà bhà ɨdzá rɔ̀. Nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mà, ndɨrɔ̀ Pbàyàhúdí ɔ̌ pbàkʉ̀rʉ̌ mànà náadʉ̀ ’ʉ̀tɔ̀ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nɨ́ abádhí ivú dhu Yěsù-tsʉ̌ ’àtɨ: «Ʉ́nɔ pɛ́ àdhɨ bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ màtɨ́ nyɨ nyárɨ́ kɔ̌kɔ̀rɨ́ dhu nɔ́nzɨ dhu fǎkà. Ndɨrɔ̀, ádhɨ nyʉ́ ndɨ wɔ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ ɨndʉ̀?» ");
INSERT INTO niy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ɨma nyʉ́ mà átɔ̀, ma mɨ́ atdí dhu nívǔ tsʉ̀kʉ́: Nyàdu pɛ́ dhu idù. ");
INSERT INTO niy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yùwanɨ̀ bhà bàtizò nɨ’ɨ̀ tɨ́ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà? Ka nɨ’ɨ̀ tɨ́ ìndrǔ-bvʉ̌ rɔ̀ áhʉ bàtizò?» ");
INSERT INTO niy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pbɛ́tʉ̀ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɨ̀rɛ̀ nga nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Àlɛ̌ kapɛ́ dhu àdǔ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ kà rɨ́rà, nɨ́ kǎdʉ̀na àtɨ̀nà: ‹Olu ádhu ɨnzá nyɨ̌ nyadʉ̀ Yùwanɨ̀ rʉ̌nɔna dhu ná’ù nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ndɨrɔ̀, àlɛ̌ kapɛ́ dhu àdǔ ìndrǔ-bvʉ̌ rɔ̀ kà ráhʉ, nɨ́ kɔ́rɔ́ alɛ adʉ̀na àlɛ̌ núbvu odu nɨ̌, ɨwà kɔ́rɔ́ alɛ ná’ù dhu Yùwanɨ̀ rɨ’ɨ̀ Kàgàwà bhà nabì nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɨ́, abádhí adʉ̀ dhu àdu, ɨnzá ɨ̀ rʉ́nɨ àdhà rɔ̀ màtɨ́ ndɨ bàtizò ɨ́rà dhu. ");
INSERT INTO niy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨma nyʉ́ mà átɔ̀, ma mɨ́ nzɨ̌ àdhɨ bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ màtɨ́ ma marɨ́ ɨ dhu ɔ̀nzɨ dhu nʉ́nɔ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ ndɔ̀pɛ̀ ndàwɛ yàrɨ́ mbólí ihé-yà tɔ̀ ndàtɨ: «Atdí alɛ náazò vǐnyò tɔ́ ɨnga, ’àdʉ̀ ’ɨ̀rɨ̀ ndɨ ɨnga-kàsʉ̌ nɔ́nzɨ̀ róngo alɛ mànà. Wɔ̀ dhu-lutìnǎ, kǎdʉ̀ ndɨ̀và ndàrà abhi ɔ̀ ábhɔ̌ ɨdhɔ nyʉ́ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nɨ́ vǐnyò-kpɔ̌ t’ɔ́pɛ̀ta tɔ́ kàsʉmɨ̀ nákǎ rɔ̀, wɔ̀rɨ́ ɨnga-àbadhi náavì atdí pbɨ̀ndà kasʉtálɛ ràrà fɨ̌ndà ka kùtù vǐnyò-kpɔ̌ nákɔ ndɨ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ-fɔ́. Pbɛ́tʉ̀ ɨ kasʉtálɛ náadʉ̀ kɔ̀ngbʉ̀, ’àdʉ̀ kàdu ròngò ɔtsʉ́na-kpa nà. ");
INSERT INTO niy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wɔ̀rɨ́ ɨnga-àbadhi náavì ngǎtsi kasʉtálɛ tdɨ́tdɔ̌ ràrà ányɨ̀. Pbɛ́tʉ̀ vǐnyò tɔ́ ɨnga-kàsʉ̌ nɔ́nzɨ arɨ́ alɛ náangbʉ̀ ndɨ alɛ átɔ̀, ’ʉ̀nɔ̀ dhu nɨ̌, ’àdʉ̀ àdunà ròngò ɔtsʉ́na-kpa nà. ");
INSERT INTO niy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tdɨ́tdɔ̌ kǎvì ɨ̀bhʉ rɨ́ kìsě kasʉtálɛ ràrà ányɨ̀. Nɨ́ abádhí náavɨ̀ ndɨ tsí átɔ̀, ngbɔ̌na rʉ̀ngbɨlɨ ndɨ̀ otú tɨ́, ’àdʉ̀ òdìnà. ");
INSERT INTO niy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nɨ́ wɔ̀ ɨnga-àbadhi náatɨ: ‹Ma mɨ́ dhu ɔ̀nzɨ ɨ̀ngbǎ tɨ́? Ɔ̀tsɔ̀! Ma mɨ́ idhùdu nyʉ́, afídu-mbi nóvì ányɨ̀. Ngǎtsi nɨ̌ abádhí rɨ̌ kɨ̀fʉ̌ ɨ̀fʉ̌.› ");
INSERT INTO niy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pbɛ́tʉ̀, kɔ̌kɔ̀rɨ́ kasʉtálɛ níitdègu wɔ̀rɨ́ kà t’ídhùnà nálǎ, nɨ́ abádhí náadʉ̀ ɔ̀tɛ nzínzìya ɔ̌ ’àtɨ: ‹Kɔ̀nɨ̌ ɨnga-àbadhi tɨ́ adɨ̀ya ngǎtsi nɨ́nganɨ́ alɛ nyʉ́ nɨ́ wɔ̀. Nɨ́ kòho ka, ndɨ́nɨ̌ ɨnga adʉ̀ya tɨ́ àdɨ àlɛ̌ tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nɨ́ abádhí adʉ̀ kòdì ɨnga ɔ̀ rɔ̀, ’àdʉ̀ òhònà. Nɨ́, ádhu nyʉ́ ndɨ wɔ̀rɨ́ ɨnga-àbadhi rǎdʉ̀ ɔ̀nzɨ̀nà kɔ̌kɔ̀rɨ́ kasʉtálɛ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kà rǎdʉ̀ ɨ̀rà, ndàbhʉ abádhí kɔkyɛ̀, ndàdʉ̀ ndɨ ɨnga-kàsʉ̌ nábhʉ ngʉ̌kpà alɛ-fɔ́.» Nɨ́ ìndrǔ níitdègu wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀rɨ, náadʉ̀ àtɨ̀nà: «Ɨnzá wɔ̀rɨ́ dhu àkǎ ndɔ̀nzɨ̀ ndɨ̀ wɔ̀ nyɨ nyʉ́nɔna dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nɨ́, Yěsù andà abádhí dɔ̀ nga, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Yà Kàgàwà bhà Andítá nʉ́nɔ̀ dhu-tɨ̀ nɨ́ àdhu? Ndɨ Andítá átɨ: ‹Yà odu-dzà nɔ́sɨ̀ arɨ́ alɛ náabvù igi odu, nɨ́ ndɨ adʉ̀ òngo ɨdza-pbɨdɔ̀ nɔ́dɔ̀ rádʉ̀ àkǎkǎ odu tɨ́.› ");
INSERT INTO niy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndɨ odu dɔ̌ rɨ́tsɨ̀ alɛ nɨ́ɨkɔ̀ya ndɨ̀ ɨ̀kɔ̀ tɨ́ kà dɔ̌. Ndɨrɔ̀ kà rɨ̌tsɨ̀ dɔ̀ná alɛ nɨ́ ɔ̌nga kɨ̌nyɨrɨya ɨ̀nyɨrɨ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Ʉyátá tɔ́ màlímó mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mànà náatsú ’àlʉ̌ Yěsù, pbɛ́tʉ̀ abádhí náadʉ̀ ihé-yà-ɔdɔ̀ nɔ́nzɨ̀. Abádhí nɨ’ɨ̀ ɨwà dhu nɔ̀sʉ̀ ɨ̀ ràrɨ̌ ndɨ Yěsù rǔbhi ɔ̀tɛ rɔ̌ dɔ̀yá mbólí ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nɨ́ abádhí náapɛ̀ ’àmbɛ Yěsù rʉ̌nɔna dhu mà kà rɔ̌nzɨna dhu mànà nándà dɔ̌ kɔ́rɔ́, ’àdʉ̀ abhábhɔ nʉ́lɨ ròkò Yěsù tɨ́ ídzì alɛ bhěyi. Ɨ abhábhɔ akò kà-tɨ́ ndɨ́nɨ̌ ’adʉ̀ tɨ́ kàlʉ nzɛ́rɛ alɛ tɨ́ tsʉ̀na-bvʉ rɔ̌, ’àdʉ̀ kìpfo ’àbhʉ anya t’ɨ́tdɨ̀ta t’álɛ mà, lɨ̀walɨ̀ mànà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nɨ́ ɨ abhábhɔ níivú dhu Yěsù-tsʉ̌, ɨ̀ ràtɨ: «Màlimǒ, mǎ mʉ́nɨ wà dhu nyɨ nyárɨ́ ʉ̀nɔna dhu mà, nyɨ nyárɨ́ ùdhěna ìndrǔ tɔ̀ dhu mànà ràrɨ̌ obhó dhu nyʉ́. Ndɨrɔ̀, nyɨ nyárɨ́ ɨ̀nzɨ̌ ìndrǔ-ɔ̌nga nóvò, pbɛ́tʉ̀ nyɨ nyárɨ́ Kàgàwà ózè ìndrǔ ròkò tɨ́ dhu núdhě obhónga dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nɨ́rɔ̀, àlɛ̌ tɔ́ ʉyátá návi tɨ́ àvǐ àlɛ̌ rʉ̀fɔ̌ Kàyìsarà bhà pàratà?» ");
INSERT INTO niy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pbɛ́tʉ̀, abádhí rɨ̌rɛ̀na dɔ̀ná dhu ndɨ̀ ndɔ̀sʉ̀ rɔ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìbho pɛ́ atdí dɨ̀narɨ̀ fudu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ádhɨ yà, nyɨ̀na-wɔ̀yɔ̌ mà pbɨ̀ndà andítá mànà rɨ̌’ɨ̀ kà dɔ̌?» Nɨ́ abádhí adʉ̀ dhu àdu ’àtɨ: «Kàyìsarà nɨ́ ndɨ.» ");
INSERT INTO niy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyùbho Kàyìsarà bhà dhu-tsí Kàyìsarà tɔ̀, nyǎdʉ̀ Kàgàwà bhà-tsí núbho Kàgàwà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nɨ́ abádhí rɨ̌ kɔ̀zʉ̀ nzɛ́rɛ alɛ tɨ́ wɔ̀ kʉ̀nɔ̀ ìndrǔ tɔ̀ dhu-okú dɔ̀ rɔ̀ dhu náadʉ̀ abádhí lɛ̀mà nɔ́nzɨ̀ ɔ̀nzɨ tɨ́. Pbɛ́tʉ̀, ɨdhɔ nʉ́kɔ ɨ̀ atdídɔ̌ fɨ̌yɔ̀ kàdu ɔtɛ nɨ̌ rɔ̀, abádhí adʉ̀ ɨ̀nɛ̀ ɨ̀nɛ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wɔ̀ dhu-dzidɔ̌, Pbàsàdùkáyó nzínzì ɔ̌ ngúfe alɛ níiwú Yěsù-tɨ’ɔ̀. Abádhí nɨ’ɨ̀ ɨnzá á’ù yà ʉ̀vʉ̌vɛ̀ kʉtdʉ̌ ɨ̀ alɛ rǎdʉ̀ ’ʉ̀ngbɛ ɔvɛ-bvʉ̀ rɔ̀ dhu alɛ. Nɨ́ abádhí níivú dhu Yěsù-tsʉ̌ ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Màlimǒ, yàrɨ́ nɨ́ Músà náandí fǎkà Ʉyátá: Atdí alɛ náapɛ́ ɔ̀vɛ̀, ndʉ̀bhà pbɨ̀ndà tsìbhálɛ ɨ̀mbǎ atdí ngbángba nà màtɨ́, nɨ́ dhu àkǎ kà t’ádɔ̀nà rùndu ndɨ abvo-àyi-tsʉ̀, ’àdʉ̀ nzónzo ɔ̀dhɨ̀ mànà yà àvǎvɛ̀ adɔ̀nà-ɔvɔ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɨ́rɔ̀, atdí alɛ nɨ́ɨ’ɨ̀ àrʉ̀bhʉ̀ kpabhínzo nà. Nɨ́ ádrʉ̀ngbǎ ɨngba náakʉ̀ tsìbhálɛ, ndàdʉ̀ ɔ̀vɛ̀ ɨ̀nzɨ̌ ndʉ̀bhà atdí ngbángba mà. ");
INSERT INTO niy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nɨ́ kà-lutìnǎ kpatsìbhíngba mà, ");
INSERT INTO niy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ɨ̀bhʉ rɨ́ kìsě mànà núundu wɔ̀rɨ́ abvo-àyi-tsʉ̀, ’àdʉ̀ ʉ̀vɛ. Ndɨ dhu anzɨ̀ ndɨ̀ wɔ̀ dhu bhěyi tɨ́ kɔ̌kɔ̀rɨ́ àrʉ̀bhʉ̀ kpabhínzo rɔ̌, rʉ̀vɛ kɔ́rɔ́ ɨ̀nzɨ̌ ’ʉ̀bhà atdí ngbángba mà. ");
INSERT INTO niy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Abádhí ʉ́vɛ kɔ́rɔ́ dhu-dzidɔ̌, ndɨ tsìbhálɛ náadʉ̀ ɔ̀vɛ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nɨ́, ʉngbɛta-ɨdhɔ̀ ɔ̌, wɔ̀rɨ́ tsìbhálɛ nɨ’ɨya àdhɨ bhà, yà kɔ́rɔ́ kɔ̌kɔ̀rɨ́ àrʉ̀bhʉ̀ kpabhínzo tɔ̀ kɨ̌’ɨ̀ tsìbhálɛ tɨ́ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Yà kòmbí rɨ́’ɨ̀ adzɨ ɔ̌, kpabhálɛ mà vèbhálɛ mànà náarɨ́ ’ʉ̀mbʉ̌mbǎ. ");
INSERT INTO niy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pbɛ́tʉ̀ yà Kàgàwà ɔ́zʉ̀ àkǎkǎnà ’òkò yà olù rɨ́rà adzɨ ɔ̌ dhu tɨ́ alɛ, kà-tɨ̀ nɨ́ yà ’ʉ̀ngbɛ̌ rɨ́ ʉ̀vʉ̌vɛ̀ alɛ nzínzì ɔ̌ rɔ̀ vèbhálɛ mà kpabhálɛ mànà, nóokoya ɨ̀nzɨ̌ ’ʉ̀mbǎ ɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndɨrɔ̀ abádhí nʉ́ʉvɛ̀ya nzɨ̌ tdɨ́tdɔ̌ akɛkpá màtɨ́, màlàyíká bhěyi abádhí nʉ́ʉlɨya ɨ̀ nɨ́dhunɨ̌. Ndɨrɔ̀, abádhí nɨ’ɨya Kàgàwà bhà inzo ɨwà abádhí ʉ̀ngbɛ ɨ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Músà avɔ̀ dhu kpangba ʉ̀ngbɛ̌ ʉ̀vʉ̌vɛ̀ alɛ rʉngbɛya ɨ̀. Pbɨ̀ndà andítá ɔ̀, yà kàzʉ rɔ̌rʉ̀ rɔ̀ná kɨ̀dzʉ̀mbà dɔ̌ rɔ́tɛ ngari ɔ̌, kǎnzi Ádrʉ̀ngbǎlɛ Kàgàwà Àbràhamʉ̀ bhà Kàgàwà, Ìsakà bhà Kàgàwà, ndɨrɔ̀ Yàkɔbhɔ̀ bhà Kàgàwà tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nɨ́rɔ̀, Kàgàwà nɨ́ nzɨ̌ ʉ̀vʉ̌vɛ alɛ tɔ́ Kàgàwà, pbɛ́tʉ̀ ka nɨ́ ípìrɔ̌ rɔ̀ arɨ́’ɨ̀ alɛ tɔ́ Kàgàwà. Obhó tɨ́, Kàgàwà tɔ̀ kɔ́rɔ́ alɛ rɨ̌’ɨ̀ ìnè ípìrɔ̌ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nɨ́, Ʉyátá tɔ́ ngúfe màlímó náakɔ̀ ɔtɛ ’àtɨ Yěsù nɨ̌: «Màlimǒ, nyɨ nyɔ̀tɛ̀ mběyi nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Abádhí náadʉ̀ nzá ’òmvù ’ìvǔ atdí dhu mà tdɨ́tdɔ̌ Yěsù-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tdɨ́tdɔ̌ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Ka kádʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi Krɨ́stɔ̀ ràrɨ̌ Dàwudì t’ídhùnà? ");
INSERT INTO niy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dàwudì nyʉ́ ndɨ̀tɨ́rɔ̀ rǎtɨna Zàburì tɔ́ bhǔkù ɔ̀: ‹Ádrʉ̀ngbǎlɛ Kàgàwà rǎtɨna pbàkà Ádrʉ̀ngbǎlɛ nɨ̌: Ádɨ̌ idú fangà dɔ̀nǎ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ràrà àhʉ ma mɨ́ pbʉ̀kʉ̀ òmvǔ nábhʉ̌ nyɔbɛ̀ dɔ̀ya dhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nɨ́, Dàwudì rɨ̀’ɨ̀ Ádrʉ̀ngbǎlɛ tɨ́ rɨ́ kànzi, nɨ́ kà rǎdʉ̀ ɨ̀’ɨ̀ ɨ̀ngbǎ dhu bhěyi Dàwudì t’ídhùnà tɨ́?» ");
INSERT INTO niy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Àzèmbè ihé-yà nókò ’àmbɛ ndɨ̀ ndʉ́nɔna dhu ɨ̀rɨ̀ dɔ̌ rɔ́rɔ̀, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: ");
INSERT INTO niy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Nyɔ̀dɔ nyɨ̌ Ʉyátá tɔ́ màlímó rɔ̌ rɔ̀. Abádhí arózèna dhu nɨ́ ’ùbhi ádzàdzǐ kanzʉ̀ ɨ̀ ʉ̀fɔ̌ rɔ́rɔ̀, ’àdʉ̀ ìndrǔ nózè ràtsɛ̀ ɨ̀ ɨfʉta nyʉ́ nà yà ìndrǔ arɨ́ ’ùndu ɔ̀yá ngari ɔ̌. Abádhí arɨ́ ’òzè ’òkò ’àvǐ rɨ́ tombi dɔ̌ unduta-dzà ɔ̌, ’àdʉ̀ ’òzè ’òkò angyinǎ rɔ̀ rɨ́’ɨ̀ ngari ɔ̌ mʉ̀hɛndʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Abádhí arɨ́ abvo-ayí-fɔ́ dhu òvo kɔ́rɔ́, ’àdʉ̀ àmbɛ ’ɨ̀tsɔ̀ dɔ̌ ádzàdzǐ, ndɨ́nɨ̌ ka katɨ tɨ́ ɨ̀ ídzì alɛ tɨ́. Nɨ́ Kàgàwà ɨtdɨ̀ya anya abádhí dɔ̌ ɔbɨ nyʉ́ nà.» ");
INSERT INTO niy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yěsù angbɛ ndɨ̀ ndàndà nga, ndàdʉ̀ ònzìtálɛ nála pɛrɛ̀ tɨ́ ɨ̀ úbhǒna Kàgàwà tɔ̀ fʉ̀rangà nʉ́dɔ̌ rɨ́ sàndukù ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kǎdʉ̀ atdí nǎkʉ̀ tɔ́ abvo-àyi nála átɔ̀ rɨ̌ ɔ́yɔ̌ fʉ̀rangà-kpɔ̌-nzo nɨ́dɔ̀ ndɨ sàndukù ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɨ́ Yěsù adʉ̀ àtɨ̀nà ányɨ̀ ɨdzá ɨ̀’ɨ̀ alɛ nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀. Wɔ̀rɨ́ nǎkʉ̀ tɔ́ abvo-àyi nɨ́dɔ̀ fʉ̀rangà abhɔ nyʉ́ ròsè kɔ́rɔ́ alɛ dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Obhó tɨ́, kɔ́rɔ́ kɔ̌kɔ̀rɨ́ ngʉ̌kpà alɛ núbho pɛrɛ̀ tɨ́ fʉ̀rangà nɨ́ yà ɨ̀mbǎ rɨ́’ɨ̀ kasʉ nà fɨ̌yɔ̀ kɛ̀lɛ̌. Pbɛ́tʉ̀ ɨ́yàdhíyà, pbɨ̀ndà nǎkʉ̀ ɔ̌, nádʉ̀ kɔ́rɔ́ fɔná rɨ́’ɨ̀ fʉ̀rangà yà dzʉ̀nàna ɔ̀nzɨ àmbɛ̀nà nɨ́dɔ̀ pɛrɛ̀ tɨ́ Kàgàwà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ngúfe alɛ náakò ’àmbɛ ɔ̀tɛ dɔ̌ Kàgàwà bhà ɨdza dɔ̌. Abádhí ambɛ́nà àtɨ̀nà dɔ̌ ka rɔ́sɨ̀ ka ʉ̀yʉ̌ya odu mà, Kàgàwà tɔ̀ ka kúbho pɛrɛ̀ tɨ́ dhu mànà nɨ̌. Nɨ́, Yěsù adʉ̀ àtɨ̀nà: ");
INSERT INTO niy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ɨdhɔ nɨ́ɨ’ɨya ìnè, yà ɨ̀nzɨ̌ atdí odu mà nʉ́ʉbhàya ndɨ̀ ngǎtsi odu dɔ̌ ɨnzá ka kùgòlò rɔ́rɔ̀ ɔ̀yá, kɔ̌kɔ̀ nyɨ̌ nyálǎna dhu nzínzì ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tdɨ́tdɔ̌ ɨ alɛ náadʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Màlimǒ, ɨ́ngbà tɨ́ngá nga ndɨ kɔ̌kɔ̀rɨ́ dhu nɔ́ɔnzɨya ɨ̀ nɨ̌? Ádhu ndɨ ɨ dhu rɨ̌ ’ɔ̀nzɨ ɔ̀ná kàsʉmɨ̀ àkǎ dhu nɨtɛ̀ya fǎkà?» ");
INSERT INTO niy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nɨ́ Yěsù adʉ̀ dhu àdu ndàtɨ: «Nyàndà nga mběyi, ɨ̀nzɨ̌ nyǎbhʉ nyɨ̌ atdí alɛ mà rʉ̀trǎ nyɨ̌. Obhó tɨ́, ábhɔ̌ alɛ níiwúya ɔvɔ̀du rɔ̌, ngǎtsi alɛ ràrà àtɨ̀nà rɔ̌: ‹Ɨma nɨ́ Krɨ́stɔ̀.› Ndɨrɔ̀: ‹Yà adzɨ dɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ ɔ̀ná kàsʉmɨ̀-tsʉ̀ níndù wà ndɨ̀.› Nɨ́, àpɛ́ nyòwu òwu rɔ̌ ɨ alɛ-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nyɨ̌ nyowuya gukyè ɨla-ɔ̀yɨ̌ nɨ́rɨ̀ rɔ̌, nyǎdʉ̀ ìndrǔ ɨ̀và dhu ɨ̀nzɨ̌ ’àmbɛ fɨ̀yɔ́ kámá-tsʉ̌ dhu ɨ̀rɨ̀ dɔ̌ dhu-ɔ̀yɨ̌ nɨ́rɨ̀ rɔ̌, nɨ́ àpɛ́ nyǒwuya ɔdɔ nábhʉ rɔ̌ rɨ̀sɨ̌ ʉ̀kʉ̀. Obhó tɨ́, dhu akáya kɔ̌kɔ̀rɨ́ dhu rɔ̀nzɨ̀ ɨ̀ angyi, pbɛ́tʉ̀ ɨ dhu náavìya nzɨ̌ dhu yà adzɨ ɔ̌ dhu-tsʉ̀ ràrɨ̌ ndɔ̀dɨ̀ kòmbí tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Atdídhená alɛ-tɨdɔ̀ nóowuya ’ùgyè rɔ̌ ngʉ̌kpà alɛ-tɨdɔ̀ mànà, ndɨrɔ̀ atdí ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ nóowuya ’ùgyè rɔ̌ ngǎtsi ádrʉ̀ngbǎ kamà bhà pbìrì ɔ̌ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ádrɔ̀drɔ̌ mùtìtì náabhʉ̀ya adzɨ rìvi, ndɨrɔ̀ ozokpa mà àgǎyì mànà ràdʉ̀ ɨ̀’ɨ̀ dhèdhèrɔ̀ ngari ɔ̀nǎ. Ɔdɔ àbhʉ̌ rɨ́ rɨ̀sɨ̌ ìndrǔ ɔ̀ dhu nɔ́ɔnzɨya ɨ̀, ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ ádrɔ̀drɔ̌ dhu ràdʉ̀ ’ɔ̀nzɨ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pbɛ́tʉ̀, tdʉ̌ kɔ̌kɔ̀ dhu nɔ́ɔnzɨ ɨ̀ kɔ́rɔ́ rɔ̀, ka kʉlʉ́ya pɛ́ nyɨ̌, kadʉ̀ àvu rʉ̀kʉ́. Ka kubhòya nyɨ̌ unduta-dzà ɔ̌ ádrɔ̀drɔ̌ alɛ-fɔ́ ndɨ́nɨ̌ ka kɨtdɨ̀ tɨ́ ànyǎkʉ. Ka kusóya nyɨ̌ imbi ɔ̀, ndɨrɔ̀ ka kowuya nyɨ̌ nà ádrɔ̀drɔ̌ kámá mà, lɨ̀wálɨ́ mànà ɔ̀nzɨ̌, ɔvɔ̀du-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ndɨ kàsʉmɨ̀-ɔ̌nga nɨ́ ndɨ nyɨ̌ nyowuya dùdú nyɨ̌ nyʉ́nɨ dhu náwɛ rɔ̌ abádhí tɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nɨ́, nyɨ̌ nyàkǎ nyʉ̌nɨ dhu, ɨnzá dhu ràkǎnà nyǐtǔ afíkʉ, nyɨ̌ nyɨ́ mʉ̀sambà ɔ̀nzɨ tɨ́ dhu nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Obhó tɨ́, ɨma nɨ́ ndɨ ma maraya nyɨ̌ nyʉ́nɔna dhu mà, àkǎ àkǎ dhu-ɔ̀nga t’óvòta tɔ́ ɨrɛ̀ta mànà dhu nábhʉ fʉ̌kʉ̀. Nɨ́ fʉ̀kʉ́ òmvǔ nóowuya nzɨ̌ ìko rɔ̌ nyɨ̀kʉ-kpa rɔ̌, ’àgò nyɨ̌ nyʉ́nɔna dhu. ");
INSERT INTO niy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abákʉ mà, ayíkʉ mà, adɔ́kʉ mà, fʉ̀kʉ́ ɨdzá-bhà mà, ɔdhɨ́kʉ mànà nóowuya nyǐpfo rɔ̌, ’ùbho nyɨ̌ òmvǔ-fɔ́, ’àdʉ̀ nzínzìkʉ ɔ̌ ábhɔ̌ alɛ nyʉ́ núbho kɔkyɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kɔ́rɔ́ alɛ nɔ́ɔndrɔ́ya nyɨ̌ okúdu dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pbɛ́tʉ̀, dʉ̀kʉ rɔ̌ atdí àyɨ̌-ngba mà náawíya nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nyɨ̌ nyɨ́ dhu-dzi òndù tɨ́ dhu náabhʉ̀ya ndɨ nyɔ̌dɔ̀ fʉ̀kʉ́ ípìrɔ̌nga.» ");
INSERT INTO niy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Nyɨ̌ nyalaya gukyè Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɨwà òmvǔ tɔ́ pbànówí àkpɔ̀rɔ̀ ngbɔ̌na rɔ́, nɨ́ nyɨ̌ nyʉnɨya dhu ndɨ kɨgɔ̀ rɨ̌ ndʉ̀kɔ̌ ɔ̀ná kàsʉmɨ̀-tsʉ̀ rìndù wà ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nɨ́, Yùdɛyà tɔ́ pbìrì ɔ̌ ɨ̀ nòtù alɛ, náakáya ’òtsè pbìrì-akpá dɔ̀. Yèrùsàlɛmà ɨ̀ nòtù alɛ náakáya ’ùvò ányɨ̀rɔ̀, àdʉ̀ òtse. Ndɨrɔ̀ ngʉ̌kpà pbanga ɔ̀nǎ ɨ̀ nòtù alɛ náakáya nzɨ̌ ’òtsù Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Obhó tɨ́, ɨ ɨdhɔ nɨ’ɨya dhu t’ʉ́tsɛ̀ta tɔ́ ɨdhɔ, ndɨ́nɨ̌ yà Andítá náarʉ́nɔna kɔ́rɔ́ dhu náaká tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ndɨ nɨ́nganɨ́, ɔ̀ya nà rɨ́ ’òtù vèbhálɛ mà, ɨba òndo rɨ́ nzónzo rɨ̌ ’òtù fɔyá vèbhálɛ mànà, nɨ́ɨ’ɨya àpbɛ̀ ɔ̌. Obhó tɨ́, Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhà náabáya àpbɛ̀ abhɔ nyʉ́, ndɨrɔ̀ Kàgàwà bhà nàwí náadʉ̀ya ndàvi kpangba abádhí dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abádhí nzínzì ɔ̌ atdídhená alɛ-tsè ka kɔtdɨ́ya obhi nɨ̌, kadʉ̀ ngʉ̌kpǎkà núso kʉmbà kɔ́rɔ́ ngʉ̌kpà pbìrì ɔ̀nǎ. Ndɨrɔ̀, ɨ ngʉ̌kpà pbìrì ɔ̌ alɛ nɔ́ɔbɛ́ya Yèrùsàlɛmà tɔ́ kɨgɔ̀-dɔ, ràrà àhʉ fɨ̀yɔ́ pbìrì ɔ̀nǎ ɨ̀ ɨ́ ’àdǔ ɔ̀ná kàsʉmɨ̀ rǎkǎ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Nyɨ̌ nyalaya ize adyifɔ̀ rɔ̌, àbǐ rɔ̌, ndɨrɔ̀ alalɨ rɔ̌ màtɨ́. Ndɨrɔ̀, yà adzɨ dɔ̌ kɔ́rɔ́ pbìrì ɔ̌ alɛ nɨ́ɨ’ɨya ádrʉ̀ngbǎ ɨzʉ ɔ̌, ádrʉ̀ngbǎ rɛ̀rʉ̀ mà, mʉ̀kʉrà mànà rɔ̌nzɨna wɔ̀gɔ̀ nɨ́rɨ ɨ̀ ɨ́, ɨ̀nzɨ̌ ’àdʉ̀ àdhu mà nɔ́nzɨ ɨ̀ ɨ́ dhu nʉ́nɨ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ìndrǔ nʉ́ʉvɛ̀ya ʉ̀vɛ̌ tɨ́ ɔdɔ nɨ̌, yà adzɨ rɔ̌ rɨ́ ndɔ̀nzɨ dhu nɔ́dɔ ɨ̀ ɨ́ rɔ̀. Obhó tɨ́, ádrɔ̀drɔ̌nga tɔ́ ɔbɨ nà arɨ́’ɨ̀ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ dhu-tsí níivìya kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɨ́rɔ̀ nɨ́ ndɨ ka kalaya Ìndrǔ t’ídhùnà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɨ́rà rɔ́. Kɨ̌raya ádrʉ̀ngbǎ àpbù nzínzì ɔ̌, ábhɔ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà, ndɨrɔ̀ ábhɔ̌ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ nà. ");
INSERT INTO niy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nɨ́, kɔ́rɔ́ kɔ̌kɔ̀rɨ́ dhu nɔ́ɔpɛ́ya gukyè ’ɔ̀nzɨ̀ ɨ̀, nɨ́ nyɨ̌ nyikòya mběyi, nyǎngbɛ dʉ̀kʉ, ɨwà nyʉ̌kɔ̀lɔ̌ ka kɨ́ àpbɛ̀ ɔ̌ rɔ̀ ɔ̀ná ɨdhɔ níndù ndɨ̀ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yěsù adʉ̀ yàrɨ́ mbólí náwɛ tdɨ́tdɔ̌ abádhí tɔ̀ ndàtɨ: «Nyàndà pɛ́ mùtinì tɨ́ kátɨna itsu mà, kɔ́rɔ́ ngʉ̌kpà itsu mànà. ");
INSERT INTO niy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nyɨ̌ nyapɛ́ abádhí-bɨ̌ nálǎ ɨwà ɨ̀ nɔ̀pɛ̀ ’àtà rɔ́, nɨ́ ka nyɨ̌ nyàndà rɔ̀, nyɨ̌ nyarɨ́ dhu nʉ́nɨ̌ nyɨ̌-tɨ́rɔ̀ tɨ́ ɨwà lábhú tɔ́ kàsʉmɨ̀ rìndù ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nɨ́ ndɨ dhu bhěyi tɨ́, nyɨ̌ mà átɔ̀, nyɨ̌ nyalaya gukyè kɔ̌kɔ̀rɨ́ dhu rɨ̌ ’ɔ̀nzɨ dhu, nɨ́ nyɨ̌ nyʉnɨya dhu Kàgàwà rɨ̌ idzi ɔ̀nyʉ ìndrǔ dɔ̌ ɔ̀ná ɨdhɔ-tsʉ̀ rìndù wà ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: yà kòmbí rɨ́’ɨ̀ rʉ̀gànda rɨ̌ nzɨ̌ ʉ̀da ɨnzá kɔ̌kɔ̀rɨ́ dhu nɔ́nzɨ̀ ɨ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ɔ̀rʉ̀-akpà mà, yàrɨ́ adzɨ mànà nʉ́ʉdàya ʉ̀dà, pbɛ́tʉ̀ pbàkà ɔtɛ nʉ́ʉdàya nzɨ̌ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Nyàndà nga mběyi, akyɛ ɔnyʉ́ mà, ɨwa t’órita mà, ndɨrɔ̀ yà adzɨ ɔ̌ dhu t’ɨ́rɛ̀ta mànà náatdúna afíkʉ nɨ̌. Ndɨrɔ̀, nyàndà nga mběyi, akyɛ ndɨ ɨdhɔ náaraya ɨ̀sɨ̌ dʉ̀kʉ́ ɨnzá nyɨ̌ nyʉ̀nɨ rɔ́rɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Àdhàdhɨ̀ àdà náarɨ́ ɨ̀sɨ̌ ɨ̀zǎ dɔ̌ dhu bhěyi, ndɨ ɨdhɔ nɨ́ɨsɨ́ya ndɨ dhu bhěyi tɨ́ kɔ́rɔ́ yà adzɨ ɔ̌ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɨ́rɔ̀, nyòko nyɨ̀kpɔ́kʉ nà, nyǎdʉ̀ òwu nyɨ̌tsɔ̀ rɔ̌ kɔ́rɔ́ kàsʉmɨ̀ ɔ̌. Ndɨ dhu bhěyi nɨ́ ndɨ, nyɨ̌ nyadʉ̀ya yà rɨ́rà kɔ́rɔ́ dhu ɔ̌ rɔ̀ nyɨ̌ nyʉ́gʉ nɨ̌, ndɨrɔ̀ Ìndrǔ t’ídhùnà-ɔ̀nzɨ̌ nyɨ̌ nyíko nɨ̌ ɔbɨ nábà.» ");
INSERT INTO niy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Adyíbhengá, Yěsù aránà dhu núdhe rɔ̌ ìndrǔ tɔ̀ Kàgàwà bhà ɨdzá rɔ̀, ndɨrɔ̀ kúbhingá ndàdʉ̀ àrà àhʉ rɔ̌, ndàrà àyi Mìzèyìtunì tɨ́ kátɨna pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndɨrɔ̀ bhɔ̌tsʉngánǎ nyʉ́, kɔ́rɔ́ alɛ nóowúnà ’ɨ̀và rɔ̌, ’òwù Kàgàwà bhà ɨdza, Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ ɨ̀ ɨrɨ tɨ́ kà rǔdhěna dhu. ");
INSERT INTO niy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yà ɨ̀mbǎ ɔ̀ná afi nà Mʉ̀gatì tɔ́ mʉ̀hɛndʉ̀, Pásɨ̀ka tɨ́ kátɨna, nɨ́ɨ’ɨ̀ ɨwà ɨdhɔ̀na níndù ndɨ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mànà náambɛ́nà Yěsù nábhʉ ɨ̀ ádʉ̀ kohò ɔ̀ná otu nɔ́nɛ̀ dɔ̌, ihé-yà-ɔdɔ̀ nɔ́nzɨ ɨ̀ ɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nɨ́rɔ̀ nɨ́ ndɨ Sìtanɨ̀ náatsù Yudhà, Ìskàrìyɔtà tɨ́ kátɨna alɛ-afí ɔ̀. Ndɨ Yudhà nɨ’ɨ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ. ");
INSERT INTO niy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nɨ́ kǎrà, òwù ’ɨ̀rɨ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì tɔ́ ádrɔ̀drɔ̌ alɛ mànà, Yěsù nípfǒ ndɨ̀ ndɨ́ ndàbhʉ abádhí-fɔ́ tɨ́ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nɨ́, abádhí-ɨdhɛ̀ nɨ́ɨka ndɨ̀ atdídɔ̌, ’àdʉ̀ ’ɨ̀rɨ̀ fʉ̀rangà ɨ̀ abhʉ̀ tɨ́ Yudhà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nɨ́ Yudhà náadʉ̀ ndɨ dhu ná’ù, ndàdʉ̀ ndɔ̀pɛ̀ ndɔ̀nɛ̀ Yěsù nípfǒ ndɨ̀ ndɨ́ ndàbhʉ abádhí-fɔ́ ɔ̀ná otu, ɨnzá ihé-yà nʉ́nɨ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yà ɨ̀mbǎ ɔ̀ná afi nà Mʉ̀gatì tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ náaká. Ndɨ ɨdhɔ nɨ’ɨ̀ yà tàmǎ-nzo náze ka kɨ́ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ tɨ́ ɔ̀ná ɨdhɔ. ");
INSERT INTO niy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nɨ́, Yěsù avì Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà ndàtɨ nɨ̌: «Nyòwu nyɔ̀bhɔlɔ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ ndɨ́nɨ̌ àlɛ̌ kɔnyʉ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nɨ́, abádhí ivú dhu kà-tsʉ̌ ’àtɨ: «Ádhà nga ndɨ nyɨ nyòzè mǒwù ndɨ ɔ̀nyʉ̀ ɔ̀bhɔ̀lɔ̀ ɔ̀nà?» ");
INSERT INTO niy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Kɨgɔ̀ ɔ̀ nyɨ̌ nyótsù rɔ̀, nyɨ̌ nyɨ́ nyǎsò ɨdha nànɔ̀ andu ɔ̌ atdí alɛ nà. Nɨ́, nyòwu kǒwù ɔ̌ tɨ́, nyǒwù òtsù kà rǎrà òtsù ɔ̀nà ɨdza ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɨ́ nyɨ̌ nyadʉ̀na àtɨ̀nà ndɨ ɨdza-àbadhi nɨ̌: ‹Màlimò nívǔ dhu tsʉ̀nʉ́ ndàtɨ: Mǎ mɨ́ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ nɔ́nyʉ ɔ̀ná rɔ̀ pbàkà ábhàlɨ̌ mànà kàluga rɨ̌’ɨ̀ àdhà?› ");
INSERT INTO niy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nɨ́ kǎdʉ̀na ɔrʉ̀nǎ rɔ̀ rɨ́’ɨ̀ ádrʉ̀ngbǎ kàluga, yà kɔ́rɔ́ dhu ka kɔ̀bhɔ̀lɔ̀ ɔ̀nà nɨ́tɛ̀ fʉ̌kʉ̀. Ányɨ̀ nga nɨ́ ndɨ nyɨ̌ nyɔbhɔlɔna ɔ̀nyʉ̀ àlɛ̌ tɔ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nɨ́ abádhí náawù kɨgɔ̀ ɔ̀, ’àdʉ̀ kɔ́rɔ́ dhu nótù yà Yěsù ʉ̀nɔ̀nà ka fɨ̌yɔ̀ dhu bhěyi tɨ́, ’àdʉ̀ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ nɔ́bhɔ̀lɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ɔ̀nyʉ̀ tɔ́ kàsʉmɨ̀ níitdègu àkǎ, nɨ́ Yěsù mà náakò ’àmbɛ dhu ɔ̀nyʉ̀ dɔ̌ pbɨ̀ndà uvitatálɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nɨ́ Yěsù atɨ abádhí nɨ̌: «Atdyúdu ɨ̀’ɨ̀nà atdídɔ̌ àlɛ̌ rɔ̀nyʉ̀ yàrɨ́ Pásɨ̀ka tɔ́ ɔ̀nyʉ̀ atdíkpá nyɨ̌ mànà tdʉ̌ ma mabá àpbɛ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌, ma ràrɨ̌ nzɨ̌ kɔ̀nyʉ tdɨ́tdɔ̌, ràrà àhʉ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̌ kǎraya àkǎ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nɨ́, Yěsù idyi dɨ̀vayì rɨ̌’ɨ̀ ɔ̀nà kɔ́pà, ndàdʉ̀ ɔ̀tsɔ̀ àbhʉ Kàgàwà tɔ̀, ndàdʉ̀ àtɨ̀nà: «Nyàkɔ yàrɨ́ kɔ́pà, nyʉ̌dà nzínzìkʉ ɔ̌, nyɔ̌mvʉ̀ ɔ̀nà rɨ́’ɨ̀ dɨ̀vayì. ");
INSERT INTO niy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌, ma ràrɨ̌ nzɨ̌ dɨ̀vayì ɔ̀mvʉ̀ tdɨ́tdɔ̌, ràrà àhʉ Kàgàwà rɨ̌ idzi nɔ́nyʉ ìndrǔ dɔ̌ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tdɨ́tdɔ̌ kǎdʉ̀ mʉ̀gatì nídyì, nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kʉ̌kɔ ndɨ mʉ̀gatì-ɔ̌nga, ndàdʉ̀ àbhʉnà pbɨ̀ndà uvitatálɛ-fɔ́, ndàdʉ̀ àtɨ̀nà: yàrɨ́ nɨ́ ngbɔ̌du, okúkʉ dɔ̀ rɔ̀ ma màbhʉ. Nyòngò dhu ɔ̀nzɨ̀ ndɨ dhu bhěyi, nyǎmbɛ mɨrɛ̀ dɔ̌ rɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ɔ̀nyʉ̀ dzidɔ̌, kǎdʉ̀ dɨ̀vayì rɨ̌’ɨ̀ ɔ̀nà kɔ́pà nábhʉ ndɨ dhu bhěyi tɨ́ abádhí tɔ̀, ndàdʉ̀ àtɨ̀nà: «Yàrɨ́ kɔ́pà nɨ́ ɔwʉ́tána tɨ́ rɨ́ nyǔngbò Kàgàwà nà, yà okúkʉ dɔ̀ rɔ̀ rɨ́ ndʉ̀fʉ azùdu-otù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pbɛ́tʉ̀, kànɨ̌ ɨma nípfǒ rɨ́ ndàbhʉ ma òmvǔ-fɔ́ alɛ rɨ̌ ìnè atdíkpá ɨma mànà ɔ̀nyʉ̀-tsʉ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Obhó tɨ́, Ìndrǔ t’ídhùnà rǎrà fɨ̀ndá dhu nɨ̌ yà dɔ̀ná ka kudhé dhu bhěyi. Pbɛ́tʉ̀ ka nìpfo ndàbhʉ òmvǔ-fɔ́ alɛ rɨ̌’ɨ̀ àpbɛ̀ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nɨ́, Yěsù bhà uvitatálɛ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌ ’àmbɛ àtɨ̀nà dɔ̌, ràrɨ̌ àdhɨ pbá alɛ nzínzìya ɔ̌, wɔ̀ dhu bhěyi dhu ɔ̀nzɨ̀ rádʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wɔ̀ dhu-dzidɔ̌, Yěsù bhà ábhàlɨ̌ náakò ’àmbɛ ’àgò dɔ̌ nzínzìya ɔ̌ ɔbɨ nyʉ́ nà. Abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá, ràrɨ̌ àdhɨ nyʉ́ ndɨ ádrʉ̀ngbǎlɛ nzínzìya ɔ̌ ròsè. ");
INSERT INTO niy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Yà adzɨ ɔ̌ pbìrì dɔ̌ ádrɔ̀drɔ̌ kámá náarɨ́ ɨ pbìrì-dɔ nɔ́nyʉ ɔbɨ nyʉ́ nà. Ndɨrɔ̀ ɨ pbìrì dɔ̌ rɨ́’ɨ̀ ɔbɨ nà alɛ náarádʉ̀ ’òzè kanzì ɨ̀ ídzìnga ɔ̀nzɨ arɨ́ alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nɨ́, fʉ̌kʉ̀ kà rɨ̌’ɨ̀ mbǎ ndɨ dhu bhěyi. Pbɛ́tʉ̀, ádrʉ̀ngbǎlɛ tɨ́ rɨ́’ɨ̀ nzínzìkʉ ɔ̌ alɛ nákǎ ndɨ̀’ɨ̀ ákɛ̌kpá alɛ bhěyi, ndɨrɔ̀ ìndrǔ ʉ̀nda rɨ́ alɛ nákǎ ndɨ̀’ɨ̀ ìndrǔ-kàsʉ̌ ɔ̀nzɨ rɨ́ alɛ bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nɨ́rɔ̀, ádrʉ̀ngbǎlɛ nyʉ́ nɨ́ àdhɨ? Tɨ́ yà mɨzà dɔ̌ rɔ̀ rɨ́ ɔ̀nyʉ̀ nɔ́nyʉ alɛ? Ngǎtsi nɨ̌, tɨ́ yà ɔ̀nyʉ̀ nʉ̀lɨ mɨzà dɔ̌ alɛ? Tɨ́ obhó yà ɔ̀nyʉ̀ nɔ́nyʉ rɨ́ mɨzà dɔ̌ rɔ̀ alɛ kɛ̀lɛ̌ ndɨ ádrʉ̀ngbǎlɛ? Pbɛ́tʉ̀ ma mɨ́’ɨ̀ nzínzìkʉ ɔ̌ àdhàdhɨ̀ yà ɔ̀nyʉ̀ nʉ́lɨ̌ rɨ́ mɨzà dɔ̌ alɛ bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nyɨ̌, nyɨ̌’ɨ nɨ́ ndɨ nyɨ̌ nyádzi nyɨ̌, nyǒndù àpbɛ̀-dzi atdíkpá ɨma mànà alɛ. ");
INSERT INTO niy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mútri nyɨ̌ ádrʉ̀ngbǎ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ̀, àdhàdhɨ̀ Àbadu Kàgàwà núutri ma kà tɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ndɨ dhu bhěyi nɨ́ ndɨ, nyɨ̌ nyɔnyʉya dhu, nyǎdʉ̀ dhu ɔ̀mvʉ̀ atdíkpá ɨma mànà pbàkà idzi ɔ̌. Ndɨrɔ̀ nyɨ̌ nyadʉ̀ya òko kamà tɔ́ tombi dɔ̌, nyǎmbɛ atdí kumì dɔ̀ná ɔ́yɔ̌ nà Pbàìsràyélí tɔ́ rʉ̀gànda-tsʉ̀-ànyǎ nʉ́nɔ̀ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Sìmonì, Sìmonǐ, ɨ́rɨ pɛ́! Sìtanɨ̀ nónzì nyɨ̌, ndɨ́nɨ̌ ndɨlɛ̀ tɨ́ ʉ̀kʉ́nga, àdhàdhɨ̀ nganʉ̀-ɔ̌nga nɨ́lɛ̀ ka karɨ́ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pbɛ́tʉ̀ ma mɨ̀tsɔ̀ ma okúnʉ dɔ̀ rɔ̀ ɨ̀nzɨ̌ pbʉ̀kʉ̀ a’uta nóongo tɨ́ olù. Nɨ́, nyɨ nyapɛ́ ìngo tɨdu ɔ̀, nɨ́ dhu àkǎ nyabhʉ ɔbɨ adɔ́nʉ-afí tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, ma mà’ù wà dhu kusǒ àlɛ̌ atdíkpá imbi ɔ̀, ndɨrɔ̀ àlɛ̌ ràdʉ̀ ʉ̀vɛ atdíkpá nyɨ mànà.» ");
INSERT INTO niy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Pɛ́tɛrʉ̌, ma mátɨna nyɨ nɨ̌: indo, à’ʉ̌-akpà rɨ̌ nzɨ̌ ɔ̀ngɔ̀ ɨnzá nyɨ nyɔ̀dhɔ̀ ma ɨ̀bhʉ-gʉ̀na nyatɨ, ɨnzá nyɨ rʉ́nɨ ma rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tdɨ́tdɔ̌, Yěsù ivú dhu pbɨ̀ndà ábhàlɨ̌-tsʉ̌ ndàtɨ: «Yà ma muví nyɨ̌ nyǒwù ɨ̀mbǎ ɨ́sɔ̀wʉ̌ mà, ɨ̀mbǎ bhɔlɔ mà, ndɨrɔ̀ ɨ̀mbǎ kàyìtǒ na rɔ̀, nɨ́ atdí dhu mà náawí tɨ́ àwǐ rʉ̀kʉ́?» Nɨ́ abádhí adʉ̀ dhu àdu ’àtɨ: «Ɨnzá atdí dhu mà náawí rɔ̀ká.» ");
INSERT INTO niy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Pbɛ́tʉ̀ kòmbí, ɨ́sɔ̀wʉ̌ nà rɨ́’ɨ̀ alɛ nákǎ ndìdyì ka, bhɔlɔ nà alɛ ràdʉ̀ pbɨ̀ndà bhɔlɔ nídyì. Ndɨrɔ̀, ɨ̀mbǎ rɨ́’ɨ̀ ɨla tɔ́ obhi-akpà nà alɛ nákǎ ndàbhʉ rɔ̀ná mʉ̀dzarʉ̀ kodzì, ndɨ́nɨ̌ ndadʉ̀ tɨ́ ɨla tɔ́ obhi-akpà nódzì ndɨ fʉ̀rangà rɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Obhó tɨ́, ma mátɨna nyɨ̌ nɨ̌: yà Andítá nʉ́nɔ̀ dùdú dhu nákǎ wà rɔ̀nzɨ̀ ndɨ̀. Ndɨ Andítá rǎtɨna: ‹Ka kazʉ̀ àbadhi nzɛ́rɛ alɛ nzínzì ɔ̀.› Nɨ́ obhó tɨ́, ɨma nàndà dhu nɨ́ rɨ̌ ndɔ̀nzɨ ɔ̀nzɨ.» ");
INSERT INTO niy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nɨ́, abádhí adʉ̀ àtɨ̀nà: «Ádrʉ̀ngbǎlɛ́, kànɨ̌ ɔ́yɔ̌ ɨla tɔ́ obhi-akpá.» Nɨ́ kǎdʉ̀ àtɨ̀nà: «Ɨwà àkǎ.» ");
INSERT INTO niy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yěsù náahʉ̀ ɨdza rɔ̀, ndàdʉ̀ àrà Mìzèyìtunì tɔ́ pbìrì dɔ̀, yà bìlǐ ndɨ̀ ndarɨ́ ɔ̀nzɨna dhu bhěyi. Kàbhà uvitatálɛ náadʉ̀ òwu kǒwù ɔ̌ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nɨ́ ányɨ̀ ndɨ̀ ndàrà àhʉ rɔ̀, kǎtɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̀tsɔ̀ nyɨ̌, akyɛ nyɨ̌ nyotsúna umvútá ɔ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tdɨ́tdɔ̌, kǐndrí ndɨ̀ ɨtsɛta abádhí tɨ́ rɔ̀, mbɛ̀mbɛ̀ òbvù ka kòbvù odu námbɛ̀nà ɨ̀tsɨ̀ rɔ́nga adzí tɨ́, ndàdʉ̀ ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌, ndɨ̀tsɔ̀ ndɨ̀, ");
INSERT INTO niy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ndàtɨ: «Àbá, nyɨ nyòzè ka nɨ̌, índrǐ pɛ́ yàrɨ́ kɔ́pà ɨtsɛ rùdú rɔ̀. Pbɛ́tʉ̀, àpɛ́ kɨ̀’ɨ ma mòzè dhu rɨ̌ ndɔ̀nzɨ dhu tɨ́, kàkǎ ndɨ̀’ɨ̀ ndɨ nyɨ nyòzè dhu tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nɨ́rɔ̀ nɨ́ ndɨ màlàyikà nɨ́ɨtɔ ndɨ̀ ɔ̀rʉ̀-akpà ɔ̀nǎ rɔ̀, ndɨ̀rà ɔbɨ nábhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ádrʉ̀ngbǎ ɨzʉ nʉ́ka ndɨ̀ dhu-okú dɔ̀ rɔ̀, kǎránà ndɨ̀tsɔ̀ rɔ̌ ádrʉ̀ngbǎ ɔbɨ nyʉ́ nà tdɨ́tdɔ̌, rɔ̀ná rɔ̀ rʉ́tdɛ̌ adyɔ ràdʉ̀ ndɨ̀lɨ azu rʉ̌tdɛ̌ obvò dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɨtsɔ̀ta dzidɔ̌, kɨ̌và ndɨ̀, ndàdʉ̀ ndàdu pbɨ̀ndà ábhàlɨ̌-tɨ’ɔ̀, ndàdʉ̀ abádhí òtù ɨwà ʉ̀dhɔ rɔ́, atdídɔ̌ ɨzʉ nʉ́ka ɨ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu nyɨ̌ nyɔ́dhɔ̀ nɨ̌? Nyɨ̀và nyɨ̌, ndɨrɔ̀ nyɨ̀tsɔ̀ nyɨ̌, akyɛ nyɨ̌ nyotsúna umvútá ɔ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Àzèmbè Yěsù rɔ̌tɛ rɔ́rɔ̀ nɨ́ ndɨ, ihé-yà nʉ́ʉnyà ɨ̀, Yudhà tɨ́ kátɨna alɛ ràdʉ̀ àdɨ fɨ̀yɔ́ pɨ̀kɔ̀ dɔ̀-tsírɔ́. Ndɨ Yudhà nɨ’ɨ̀ Yěsù bhà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ. Nɨ́ kǐndri Yěsù-tɨ’ɔ̀, ndɨ́nɨ̌ ndɨ̀ ndambó tɨ́ ka. ");
INSERT INTO niy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Yudhǎ, tɨ́ ambótá-otù ɔ̌ nga ndɨ nyɨ nyɨ́ Ìndrǔ t’ídhùnà nábhʉ̌ òmvǔ-fɔ́ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kǎkà Yěsù mànà ɨ̀’ɨ̀nà alɛ níitdègu wɔ̀ rɨ́ ndàpà ndɔ̀nzɨ̀ ndɨ̀ dhu nálǎ, níivú dhu Yěsù-tsʉ̌, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, dhu àkǎ tɨ́ mʉ̌’a ìndrǔ ɨla tɔ́ obhi-akpá nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nɨ́, abádhí nzínzì ɔ̌ atdí alɛ nʉ́ʉ’à pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà kasʉtálɛ, ndɨ̀tsà fangà dɔ̀nǎ bɨ̌na. ");
INSERT INTO niy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà: «Ìnzě, ʉ́bhà! Ɨwà àkǎ wɔ̀ dhu bvʉ̀tɨ́!» Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ ndɨ alɛ-bɨ̀-ngbɔ̀ nápbala, ràdʉ̀ ɔ̀gʉ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɨ́, Yěsù adʉ̀ àtɨ̀nà kɔ̌kɔ̀ rɔ̀ná ìwǔ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mànà nɨ̌: «Nyɨ̌ nyàdʉ̀ tɨ́ ìwu fʉ̀kʉ́ ɨla tɔ́ obhi-akpá nà, ndɨrɔ̀ fʉ̀kʉ́ mùgǒ mànà ogbotálɛ nósò ríwu alɛ bhěyi? ");
INSERT INTO niy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Àlɛ̌ kúbhì ɨ̀’ɨ̀ rɔ̌ nyɨ̌ mànà bìlǐnganà Kàgàwà bhà ɨdzá, ɨ̀nzɨ̌ nyǎdʉ̀ malʉ. Pbɛ́tʉ̀ kòmbí rɨ́ kàsʉmɨ̀ nɨ́ fʉ̀kʉ́, yà ɨ́nɔ̀ ɔ̌ arɨ́ kasʉ ɔ̀nzɨ ɔbɨ mànà.» ");
INSERT INTO niy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yěsù ɨ̀ àlʉ̌ dhu-dzidɔ̌, abádhí náadʉ̀ òwu kà nà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà. Pɛ́tɛrʉ̀ adʉ̀ àdɨ olùnǎ rɔ̀, ndàmbɛ àrà dɔ̌ abádhí-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kɔ̌kɔ̀rɨ́ alɛ nʉ́ʉtɔ kàzʉ rʉ̀wʉgà dɔ̌, ’àdʉ̀ òko tsʉ̀na nǎ. Pɛ́tɛrʉ̀ adʉ̀ ɨ̀rà, ndàdɨ átɔ̀ abádhí nzínzì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nɨ́, kasʉ tɔ́ atdí tsìbhálɛ náala Pɛ́tɛrʉ̀ kàzʉ-tsʉ̀nǎ àdɨ rɔ́. Nɨ́ kǎdɨ̀ nyɨ̀kpɔ́na kà rɔ̌, ndàdʉ̀ àtɨ̀nà: «Yàrɨ́ alɛ mà nɨ́’ɨ̀nà átɔ̀ kà mànà.» ");
INSERT INTO niy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ kà-tsʉ̌ dhu nágò, ndàtɨ: «Yà tsìbhálɛ́, ɨnzá ma mʉ̀nɨ wɔ̀ alɛ!» ");
INSERT INTO niy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ákɛ̌ kàsʉmɨ̀ dzidɔ̌ tɨ́, ngǎtsi alɛ náala ka tdɨ́tdɔ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ɨnyɨ nyʉ́ mà átɔ̀, nyɨ nɨ́ atdí abádhí nzínzì ɔ̌ alɛ.» Pbɛ́tʉ̀ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà wɔ̀ alɛ nɨ̌: «Ɨ̀nzɨ̌ nɨ́ ma abádhí nzínzì ɔ̌ alɛ.» ");
INSERT INTO niy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tdɨ́tdɔ̌, mbɛ̀mbɛ̀ ɨwà atdí adyifɔ̀-sɨsɨ̀ nyʉ́ nʉ́dà rɔ́rɔ̀, ngǎtsi alɛ náavɔ̀ dhu ɔbɨ nyʉ́ nà ndàtɨ: «Obhó nyʉ́, yàrɨ́ alɛ mà nɨ́’ɨ̀ atdíkpá kà mànà, ka nɨ́ Gàlìlayà tɔ́ pbìrì ɔ̌ alɛ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨnzá ma mʉ̀nɨ wɔ̀ nyɨ nyòzè nyʉnɔ̀ dhu.» Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, àzèmbè Pɛ́tɛrʉ̀ rɔ̌tɛ rɔ́rɔ̀ nɨ́ ndɨ, à’ʉ̌-akpà náadʉ̀ ɔ̀ngɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nɨ́, Ádrʉ̀ngbǎlɛ Yěsù náagɛ́rɛ́ ndɨ̀, ndàndà Pɛ́tɛrʉ̀. Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ adʉ̀ yà Ádrʉ̀ngbǎlɛ Yěsù nʉ́nɔ̀nà fɨ̌ndà dhu nɨ́rɛ̀. Kǎtɨ: «Indo, ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyɔ̀dhɔ̀ ma ɨ̀bhʉ-ràdɔ̌ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àhʉ iri, ndàdʉ̀ ɔ̀dzɨ ádrʉ̀ngbǎ ɨzʉ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yà Yěsù rɨ̌’ɨ̀ fɔyá alɛ náambɛ́nà kʉ̀gbɔ dɔ̌, ’àdʉ̀ àmbɛ kɔ̀vɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Abádhí owúnà kà-nyɨ̀ àtsì rɔ̌, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Átɨ pɛ́ nyɨ nʉ̀tɨ̀ alɛ fǎkà?» ");
INSERT INTO niy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndɨrɔ̀ abádhí náadʉ̀ ábhɔ̌ ngʉ̌kpà nzɛ́rɛ dhu nyʉ́ nʉ́nɔ̀ kà nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɨnga níitdègu ùbho, nɨ́ Pbàyàhúdí tɔ́ pbàkʉ̀rʉ̌ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mànà, núundu ɨ̀, ’àdʉ̀ Yěsù nábhʉ kowù nà fɨ̀rábvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɨ́, abádhí níivú dhu Yěsù-tsʉ̌ ’àtɨ: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Krɨ́stɔ̀ tɨ́, nɨ́ ʉ́nɔ pɛ́ ka fǎkà.» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ma mapɛ́ kʉ̀nɔ fʉ̌kʉ̀, nɨ́ nyɨ̌ nyɨ́ nzɨ̌ kà’u. ");
INSERT INTO niy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ndɨrɔ̀, ma mapɛ́ dhu ìvǔ tsʉ̀kʉ́, nɨ́ nyɨ̌ nyɨ́ nzɨ̌ dhu àdu idù. ");
INSERT INTO niy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pbɛ́tʉ̀ rɔ̀pɛ̀ ndɨ̀ kombí, Ìndrǔ t’ídhùnà rǎrà àdɨ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ tɔ́ fangà dɔ̀nǎ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɨ́, kɔ́rɔ́ alɛ adʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Olu nyɨ tɨ́ ndɨ Kàgàwà t’ídhùnà?» Nɨ́ kǎdʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyɨ̌ nɨ́ ndɨ nyɨ̌ nyàtɨ, ɨma ràrɨ̌ ndɨ.» ");
INSERT INTO niy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nɨ́ abádhí adʉ̀ àtɨ̀nà: «Àlɛ̌ tɨ́’ɨ̀ ìnè ngàmbì-atdyú nà tdɨ́tdɔ̌? Àlɛ̌ kɨ̀rɨ̀ wà kʉ̀nɔ̀ dhu àlɛ̌-bɨ̀ nyʉ́ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Abádhí nɨ́ɨvà ɨ̀ kɔ́rɔ́ atdíkpá, ’òwù Yěsù nà, ’òwù ùvò nà Pìlatɔ̀-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nɨ́ abádhí apɛ̀ ’ɔ̀bhʉ̀ ka, ’àmbɛ àtɨ̀nà dɔ̌: «Mǎ mòtù yàrɨ́ alɛ àlɛ̌ tɔ́ pbìrì ɔ̌ alɛ-dɔ ɨ̀dzɨ̌ rɨ́, ndɨ́nɨ̌ dhu nɨvà tɨ́ rɔ́. Kà rǎrà ìndrǔ-tsʉ̀ nátɔ̀ rɔ̌ ɨ̀nzɨ̌ Kàyìsarà bhà pàratà nʉfɔ́ tɨ́. Ndɨrɔ̀ kà rǎrà ndàtɨ̀ rɔ̌ ndɨ̀tɨ́rɔ̀ Krɨ́stɔ̀, ádrʉ̀ngbǎ kamà tɨ́.» ");
INSERT INTO niy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nɨ́ Pìlatɔ̀ ivú dhu Yěsù-tsʉ̌ ndàtɨ: «Ɨnyɨ, nyɨ tɨ́ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ɨnyɨ nɨ́ ndɨ ka nyɨ nyʉ̀nɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nɨ́ Pìlatɔ̀ adʉ̀ àtɨ̀nà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, ihé-yà mànà nɨ̌: «Ɨnzá ma màla atdí afátá mà yàrɨ́ alɛ dɔ̌ ka kádʉ̀ anya ɔ̀tdɨ̀ okúna dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pbɛ́tʉ̀ abádhí náadʉ̀ dhu nʉ́tʉ atdídɔ̌, ’àdʉ̀ àtɨ̀nà: «Kà rǔdhěna dhu náarɨ́ ìndrǔ-dɔ nɨ́dzɨ̌. Kɔ̌pɛ̀ ka Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀, ndʉ̀dà nà kɔ́rɔ́ Yùdɛyà tɔ́ pbìrì ɔ̀nǎ, ndɨ̀rà àhʉ nà ɨrɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pìlatɔ̀ níitdègu wɔ̀ dhu ɨ̀rɨ, náadʉ̀ dhu ìvu wɔ̀ ndɨ alɛ ràtɨ́ Gàlìlayà tɔ́ pbìrì ɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nɨ́, ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ bhà pbìrì ɔ̌ alɛ tɨ́ kà rɨ̌’ɨ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Pìlatɔ̀ adʉ̀ kàbhʉ kowù nà Hɛ̀rɔdɛ̀-fɔ ɔ̀. Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Hɛ̀rɔdɛ̀ náadʉ̀ ndòtù Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndɨ́rà átɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nɨ́ Yěsù ndɨ̀ ndàla rɔ̀, Hɛ̀rɔdɛ̀-ɨdhɛ̀ nɨ́ɨka ndɨ̀ atdídɔ̌. Obhó ka nɨ’ɨ̀ angyangyi tɨ́ ubhínà ndòzè rɔ̌ ndàla Yěsù-ngbɔ̀, yà kà dɔ̌ ka kʉ́nɔna dhu nɨ́rɨ ndɨ̀ ndarɨ́ dhu-okú dɔ̀ rɔ̀. Ndɨrɔ̀, kǎzè ndàla kà rɔ̌nzɨna atdí wɨwɨ̀ mà. ");
INSERT INTO niy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nɨ́ Hɛ̀rɔdɛ̀ náangʉ̀ dhu ádzǐta nyʉ́ Yěsù-tsʉ̌, pbɛ́tʉ̀ kǎdʉ̀ nzá atdí dhu mà nádu kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Ʉyátá tɔ́ màlímó mànà nɨ́ɨ’ɨ̀ ányɨ̀rɔ̌. Nɨ́ abádhí adʉ̀ Yěsù ɔ̀bhʉ̀ ɔbɨ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nɨ́rɔ̀ nɨ́ ndɨ Hɛ̀rɔdɛ̀ mà, yà ngbɔ̌na ɔ̀dɔ rɨ́ pbànówí mànà, náambɛ́nà kʉ̀nɔ̀ dɔ̌ ɨtsɨ dɔ̌. Nɨ́ ka ndɨ̀ ndʉ̀gbɔ̌, ndàdʉ̀ àyǎya mbɛrʉ̀ náfɔ kà-rɔ̌ dhu-dzidɔ̌, kǎdʉ̀ Yěsù àdu kowù nà tdɨ́tdɔ̌ Pìlatɔ̀-fɔ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndɨ nɨ́nganɨ́ tɨ́, Hɛ̀rɔdɛ̀ mà Pìlatɔ̀ nà, náadʉ̀ ’òzè òzè tɨ́, àzèmbè òmvǔ tɨ́ ɨ̀ árúbhi ɨ̀’ɨ̀ rɔ̌ angyinǎ rɔ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pìlatɔ̀ náandu pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ mà, ngʉ̌kpà alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyìwǔ yàrɨ́ alɛ nà fudu ɔ̀, nyǎdʉ̀ àtɨ̀nà kà rarɨ́ ìndrǔ-dɔ nɨ́dzɨ̌ ndɨ́nɨ̌ dhu nɨvà tɨ́. Nɨ́rɔ̀, kànɨ̌ ma mɔ̀ngʉ̀ dhu kà-tsʉ̌ nyɨ̀kpɔ́kʉ ɔ̌ rɔ̀. Nɨ́ ma màla nzá atdí afátá mà kà-dɔ̌ ka kɨ́ anya nɔ́tdɨ̀ okúna dɔ̀ rɔ̀. Ndɨrɔ̀, atdí dhu mà rɨ̌’ɨ̀ ɨ̀mbǎ yà nyɨ̌ nyɔ̀bhʉ̀ ka dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛ̀rɔdɛ̀ nyʉ́ mà nála nzá atdí afátá mà kà dɔ̌, kàdʉ̀ kàdu tdɨ́tdɔ̌ àlɛ̌-fɔ ɔ̀ nɨ́dhunɨ̌. Nɨ́, yà kɔ̌nzɨ̀ dhu ɔ̌, atdí dhu mà rɨ̌’ɨ̀ mbǎ, yà kàbhʉ rádʉ̀ kohò. ");
INSERT INTO niy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nɨ́, ma mɨ́ kɨ̀kɔlɔ ɨwà ma màbhʉ ka kʉvɨ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ náarɨ́rà dhu bhěyi, ka kongónà atdí alɛ nɨ́kɔ̀lɔ̀ imbi ɔ̀ rɔ̀ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nɨ́, abádhí kɔ́rɔ́ náapɛ̀ ’ùkǔ atdíkpá, ’àmbɛ àtɨ̀nà dɔ̌: «Ábhʉ̌ wɔ̀ alɛ kohò, nyadʉ̀ Bàrabà nɨ́kɔ̀lɔ̀ fǎkà.» ");
INSERT INTO niy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ndɨ Bàrabà ka kasò imbi ɔ̀, kɨgɔ̀ ɔ̌ ndɨ̀ nɔ́nzɨ̀ wɔ̀gɔ̀-okú dɔ̀ rɔ̀, ndɨrɔ̀ ìndrǔ kǒhò dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pìlatɔ̀ abhʉ̀ tǔna tdɨ́tdɔ̌ ihé-yà tɔ̀, Yěsù ndɨ̀ ndòzè ndɨ̀kɔ̀lɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pbɛ́tʉ̀, abádhí adʉ̀ ɨ̀dʉ̀: «Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌! Ʉ́tɔ̌ ka mʉ̀sàlabhà dɔ̌!» ");
INSERT INTO niy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ɨ̀bhʉ rɨ́ kìsě nɨ̌, kǎtɨ abádhí nɨ̌: «Ádhu nyʉ́ ndɨ kǎfǎ? Ɨnzá ma màla atdí afátá mà, yà kàkǎ kohò okúna dɔ̀ rɔ̀. Nɨ́ ma mɨ́ kàbhʉ̌ kʉvɨ, madʉ̀ ɨ̀kɔ̀lɔ̀nà ràrà.» ");
INSERT INTO niy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pbɛ́tʉ̀, abádhí náadʉ̀ dhu ʉ̀tʉ, ’àmbɛ ùkǔ dɔ̌ àrǐ nyʉ́ tɨ́, ndɨ́nɨ̌ ka kʉtɔ́ tɨ́ ka mʉ̀sàlabhà dɔ̌. Nɨ́ abádhí tɔ́ ìkǔ-ɔbɨ̀ òsè dɔ̀na nǎ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pìlatɔ̀ adʉ̀ abádhí-afí òzè dhu nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nɨ́ kɨ̌kɔ̀lɔ̀ yà imbi ɔ̀ ka kósò kɨgɔ̀ ɔ̌ ndɨ̀ nɔ́nzɨ̀ wɔ̀gɔ̀-okú dɔ̀ rɔ̀, ndɨrɔ̀ abvo nóhò dhu-okú dɔ̀ rɔ̀ alɛ. Ndɨ alɛ nɨ’ɨ̀ yà abádhí rǔbhi ònzìnà rɔ̌ kɨkɔ̀lɔ̀ alɛ. Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ Yěsù nábhʉ abádhí-fɔ́, ndɨ́nɨ̌ abádhí ɔnzɨ tɨ́ afíya nózè dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yěsù nà ɨ̀ ówu ɔ̀ná kàsʉmɨ̀ ɔ̌, abádhí náalʉ́ Sìmonì tɨ́ kátɨna atdí alɛ ɨnga bvʉ̀ rɔ̀ rɨ́rà rɔ́rɔ̀. Ndɨ alɛ nɨ’ɨ̀ Kùrenì tɔ́ kɨgɔ̀ ɔ̌ alɛ. Nɨ́ abádhí náadʉ̀ mʉ̀sàlabhà nágba kà-dɔ̌, ndɨ́nɨ̌ kǎnɔ́ tɨ́, ndàmbɛ àrà dɔ̌ nà Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ábhɔ̌ ihé-yà mà, vèbhálɛ mànà náambɛ́nà òwu dɔ̌ Yěsù owù ɔ̌. Ɨ vèbhálɛ náambɛ́nà odrùya-dɔ nʉ́pbɨ̀ dɔ̌ ɨzʉ-okú dɔ̀ rɔ̀, ’àdʉ̀ àmbɛ Yěsù ɔ̀dzɨ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nɨ́ Yěsù agɛ́rɛ́ ndɨ̀ ndàndà abádhí, ndàdʉ̀ àtɨ̀nà: «Yèrùsàlɛmà ɔ̌ vèbhínzó, ɨ̀nzɨ̌ nyɔ̀dzɨ ma! Pbɛ́tʉ̀, nyɔ̀dzɨ nyɨ̌ nyɨ̌-tɨ́rɔ̀, ndɨrɔ̀ nyɔ̀dzɨ fʉ̀kʉ́ nzónzo. ");
INSERT INTO niy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Obhó tɨ́, ɨdhɔ rɨ̌’ɨ̀ ìnè yà ɔ̀yá ka kowuya àtɨ̀nà rɔ̌: ‹Hirò nɔ̀nzɨ̀ nɨ́ ìngò-ayí, ndɨrɔ̀ hirò nɔ̀nzɨ̀ nɨ́ ɨnzá ɨ̀ nʉgʉ vèbhálɛ, yà ɨnzá inzo apɛ̀na ɨbàya-tsʉ̀ nɨ́ndʉ̌ vèbhálɛ.› ");
INSERT INTO niy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndɨ nɨ́nganɨ́, ìndrǔ owuya àtɨ̀nà rɔ̌ pbìrì-akpá nɨ̌: ‹Nyàgbǔ nyɨ̌ dɔ̀ká!› Ndɨrɔ̀ abádhí owuya àtɨ̀nà rɔ̌ pbìrì nɨ̌: ‹Nyàtsì nyɨ̌ dɔ̀ká!› ");
INSERT INTO niy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Obhó tɨ́, yà dhu bhěyi ka kɨ́ dhu ɔ̀nzɨ kázǔ itsu rɔ̌ rɔ̀, òtdyǒtdyù itsu rɔ̌ ka kɔ́nzɨna dhu nóoloya ɨ̀ngbǎ dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, ka kambɛ́nà òwu dɔ̌ átɔ̀ nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ ɔ́yɔ̌ alɛ nà, ndɨ́nɨ̌ ka kɔkyɛ tɨ́ atdíkpá Yěsù mànà. ");
INSERT INTO niy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nɨ́, «Alɛ-dɔ-kpa» tɨ́ kátɨna ngari ɔ̀ ɨ̀ òwù ùvò rɔ̀, abádhí nʉ́ʉtɔ́ Yěsù mʉ̀sàlabhà dɔ̌ ányɨ̀rɔ̌, kɔ̌kɔ̀ nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ ɔ́yɔ̌ alɛ mànà. Atdí alɛ ka kʉtɔ́ Yěsù bhà fangà dɔ̀nǎ rɔ̀, kadʉ̀ ngǎtsi nʉ́tɔ kàbhà ígù dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɨ́, Yěsù ambɛ́nà àtɨ̀nà dɔ̌: «Àbá, ʉ́bà dhu abádhí tɔ̀, ɨnzá abádhí ʉ̀nɨ ɨ̀ ɔ́nzɨna dhu nɨ́dhunɨ̌.» Abádhí náadʉ̀ Yěsù rɔ̌ mʉ̀dzarʉ̀ nʉ́ndɔ̀ fɔyá, ngàlà ɔ̌ ɨ̀ ɔ̀vɨ̀ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ìndrǔ náadʉ̀ ìko ányɨ̀rɔ̌, ’àmbɛ ndɔ̀nzɨ rɨ́ dhu nándà dɔ̌. Pbɛ́tʉ̀, pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ òko ’àmbɛ Yěsù nʉ́gbɔ dɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Kɨ̌gʉ̌ ngʉ̌kpà alɛ, nɨ́ kɨ̀gʉ̌ pɛ́ ndɨ̀ ndɨ̀tɨ́rɔ̀, kǎpɛ́ ɨ̀’ɨ̀ Krɨ́stɔ̀, Kàgàwà ɔ́pɨ̀ fɨ̌ndà alɛ tɨ́!» ");
INSERT INTO niy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pbànówí náambɛ́nà kʉ̀gbɔ dɔ̌ átɔ̀, ’àdʉ̀ òwu ògyògyè dɨ̀vayì náva rɔ̌ kà-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Abádhí adʉ́nà òwu àtɨ̀nà rɔ̌: «Nyɨ nyapɛ́ ɨ̀’ɨ̀ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà tɨ́, nɨ́ ɨ́gʉ̌ pɛ́ nyɨ nyɨ-tɨ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kà-dɔ̀nǎ ka kadʉ̀ dhu àndi yà dhu bhěyi: «Yàrɨ́ alɛ nɨ́ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà.» ");
INSERT INTO niy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yà Yěsù tɨ́ ka kʉ̀tɔ̌ mʉ̀sàlabhà dɔ̌ alɛ nzínzì ɔ̌ atdí alɛ nʉ́ʉnɔ dhu kà nɨ̌ ndàtɨ: «Nyɨ tɨ́ obhó Krɨ́stɔ̀? Ɨ́gʉ̌ pɛ́ nyɨ nyɨ-tɨ́rɔ̀, nyadʉ̀ mǎ nɨ́gʉ!» ");
INSERT INTO niy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pbɛ́tʉ̀ ngǎtsi kà t’ɔ́dhɨ̀nà náadʉ̀ ɔ̀rʉ̀ kà dɔ̌ ndàtɨ: «Nyɨ tɨ́ obhó Kàgàwà-ɔdɔ̀ mà nɔ́nzɨ, àzèmbè nyɨ nyongó ɨ̀’ɨ̀ ndɨ àpbɛ̀-tɨdɔ̀ kɛ̀lɛ̌ nábà nyɨ nyɨ́? ");
INSERT INTO niy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Àlɛ̌ kɨ́ àpbɛ̀ nábà obhónánga dɔ̌, àlɛ̌ tɔ́ afátá-okú dɔ̀ rɔ̀ àlɛ̌ kɨ́ kàbà nɨ́dhunɨ̌. Pbɛ́tʉ̀ yàrɨ́ alɛ náfǎ nzá atdí dhu mà.» ");
INSERT INTO niy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tdɨ́tdɔ̌, kǎdʉ̀ àtɨ̀nà: «Yěsǔ, ɨ̀rɛ̀ nyɨ́rɛ̀ ma pbʉ̀kʉ̀ idzi ɔ̀ nyɨ nyótsù rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀ ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀: àlɛ̌ kótsù nyɨ mànà indo tɨ́ pàràdisò ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mbɛ̀mbɛ̀ azà adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌, ɨ́nɔ̌-yà níibvú ndɨ̀ kɔ́rɔ́ ndɨ pbìrì ɔ̌, ràrà àhʉ àrʉ̀gyètdí adyifɔ̀-sɨsɨ̀ adyídɔ̌ nga tɔ́ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Adyifɔ̀ náavɛ̀, Kàgàwà bhà ɨdza ɔ̌ ka kúsò ádrʉ̀ngbǎ mbɛrʉ̀ pàziyà tɨ́ kátɨna-ɔ̌nga ràdʉ̀ ndɨ̀fa átsǐ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nɨ́ Yěsù akù ɔrʉ́ tǔna nyʉ́ nà ndàtɨ: «Àbá, ma màbhʉ afídu fʉnʉ́.» Wɔ̀ dhu ndɨ̀ ndòrì dhu-dzidɔ̌ nɨ́ ndɨ, kà-afí náadʉ̀ ɨ̀tdɛ̌ dòtsí. ");
INSERT INTO niy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu ndɨ̀ ndàla rɔ̀, Pbàrɔ́má tɔ́ pbìrì ɔ̌ atdí mɨyà pbànówí dɔ̌ ádrʉ̀ngbǎlɛ níilè Kàgàwà ndàtɨ: «Obhó nyʉ́, yàrɨ́ alɛ nɨ́’ɨ̀ obhónángatálɛ!» ");
INSERT INTO niy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kɔ́rɔ́ alɛ́-yà, yà ibí rɔ̀ ìwǔnà dhu àndà, náala wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu. Nɨ́ abádhí náadù ɨ̀ ányɨ̀rɔ̌ rɔ̀ dɔ̀ya-tsirɔ̀ ʉ̀lʉ̌ ɨzʉ nyʉ́ nà rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yà Yěsù nʉ́nɨ kɔ́rɔ́ alɛ, Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀ ka nʉ́ndà vèbhálɛ mànà, níikò ɨtsɛta, ’àmbɛ ʉ̀da rʉ́da dhu nándà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ nzínzì ɔ̌, Yɔ̀zɛfʉ̀ tɨ́ kátɨna atdí alɛ nɨ́ɨ’ɨ̀ ìnè. Ndɨ alɛ nɨ’ɨ̀ ídzì alɛ, ndɨrɔ̀ ka nɨ’ɨ̀ obhónángatálɛ. ");
INSERT INTO niy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kǎtsù nzá yà Yěsù dɔ̌ rɨ́ ’ɨ̀rɨ alɛ tɔ́ ɔtɛ ɔ̀ màtɨ́, ndɨrɔ̀ abádhí rɔ̌nzɨna dhu ɔ̀ màtɨ́. Wɔ̀ ndɨ Yɔ̀zɛfʉ̀ nɨ’ɨ̀ Àrìmàtayò tɨ́ kátɨna Pbàyàhúdí-bvʉ̌ atdí kɨgɔ̀ ɔ̌ alɛ. Ndɨrɔ̀ kǒngónà Kàgàwà rɨ̌ idzi ɔ̀nyʉ ìndrǔ dɔ̌ ɔ̀ná ɨdhɔ nɔ́dɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nɨ́ kǎrà Pìlatɔ̀ bhà, ndàrà Yěsù-abvò nónzì kà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kǎdʉ̀ Yěsù-abvò nífo mʉ̀sàlabhà dɔ̌ rɔ̀, ndàdʉ̀ ngbɔ̌na nákpɔ̀rɔ̀ mbɛrʉ̀ ɔ̀. Kǎdʉ̀ àrà ndɨ abvo nɔ́tdʉ̀ bhalabhala ɔ̀ ka kóbhì ibhu ɔ̀. Ndɨ ibhu nɨ’ɨ̀ ɨnzá ka kàpɛ̀ atdí alɛ mà nɔ́tdʉ̀ ɔ̀nà angyi. ");
INSERT INTO niy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wɔ̀ dhu anzɨ̀ ndɨ̀ yà ìndrǔ rɨ̌ ’ɔ̀bhɔlɔ ndɨ́nɨ̌ sàbatʉ̀ adʉ̀ tɨ́ ndɔ̀pɛ̀ ɔ̀ná ɨdhɔ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yà Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀ Yěsù nʉ́ndà vèbhálɛ, náadʉ̀ òwu atdíkpá Yɔ̀zɛfʉ̀ mànà. Abádhí náala Yěsù-abvò nɔ́tdʉ̀ ka kɨ́ ɔ̀nà ibhu, ’àdʉ̀ Yěsù ka kɨ̀lɨ ibhu ɔ̀ tɨ́ dhu nála. ");
INSERT INTO niy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wɔ̀ dhu-dzidɔ̌, abádhí náadʉ̀ ’àdu fɨ̀rábvʉ̀, ’òwù andrɔ̀kɔ mà, ndrùù rɔ́ngʉ akyɛ mànà nɔ́bhɔ̀lɔ̀. Sàbatʉ̀-ɨdhɔ̀ ɔ̌, abádhí náadʉ̀ ’àso yà Ʉyátá nónzì dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sàbatʉ̀-ɨdhɔ̀ dzidɔ̌ rúbho nga ɔ̌, vèbhálɛ náawù kútsingá nyʉ́ kàbhǔlì ɔ̀. Abádhí awù ányɨ̀ yà angyangyɨ ɨ̀ ɔ́bhɔ̀lɔ̀ mběyi rɔ́ngʉ akyɛ mànà fɔyá. ");
INSERT INTO niy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nɨ́, abádhí adʉ̀ odu nótù ɨwà ka kɔ̀gɛ̀rɛ̀ ibhu-lí rɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nɨ́ abádhí atsù ndɨ ibhu ɔ̀, pbɛ́tʉ̀ abádhí adʉ̀ nzá Ádrʉ̀ngbǎlɛ Yěsù-abvò nótù. ");
INSERT INTO niy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nɨ́ atdídɔ̌ ɨdhɔ nʉ́kɔ abádhí ndɨ dhu dɔ̌ rɔ́rɔ̀ nɨ́ ndɨ, ɔ́yɔ̌ alɛ nʉ́ʉtɔ ɨ̀ abádhí tɨ́, atdídɔ̌ rʉ́mbɨlɨ mʉ̀dzarʉ̀ nà rɔ̀yá. ");
INSERT INTO niy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɨ́ atdídɔ̌ ɔdɔ nɨ́sɨ̌ ɔ̀yà dhu-okú dɔ̀ rɔ̀, abádhí adʉ̀ dɔ̀ya nʉ́tdɔ̀ obvò. Pbɛ́tʉ̀, kɔ̀rɨ́ alɛ adʉ̀ dhu ìvu abádhí-tsʉ̌ ’àtɨ: «Ádhu nyɨ̌ nyɨ́ ìnè rɨ́’ɨ̀ nyɨ̀kpɔ́na nà alɛ nɔ́mɛ ʉ̀vʉ̌vɛ alɛ nzínzì ɔ̌ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kà rɨ̌’ɨ̀ mbǎ ɨrɔ́, kɨ̀ngbɛ̀ wà ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Nyɨ̀rɛ̀ pɛ́ yà fʉ̌kʉ̀ kʉ̌nɔ àdɨ̀ ndɨ̀ ndàdɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ́rɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kǎtɨ: ‹Dhu àkǎ kipfo Ìndrǔ t’ídhùnà kabhʉ nzɛ́rɛngatálɛ-fɔ́, kadʉ̀ ʉ̀tɔnà mʉ̀sàlabhà dɔ̌, ndɨrɔ̀ ɨ̀bhʉ ɨdhɔ dzidɔ̌, kà ràdʉ̀ ndɨ̀ngbɛ̀.›» ");
INSERT INTO niy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nɨ́rɔ̀ nɨ́ ndɨ abádhí náadʉ̀ yà Yěsù ʉnɔ ɔtɛ nɨ́rɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nɨ́ abádhí adù ɨ̀ ibhu-tɨ’ɔ̀ rɔ̀, ’òwù yà ɨ̀ àla kɔ́rɔ́ dhu nʉ́nɔ̀ atdí kumì dɔ̀ná atdí nà ábhàlɨ̌ tɔ̀, kɔ́rɔ́ ngʉ̌kpà alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɨ vèbhálɛ nɨ’ɨ̀ Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà mà, Zǎnɨ̀ mà, Yàkɔbhɔ̀-tsánà, Màrɨyà mànà. Ndɨrɔ̀, yà abádhí ɨ̀’ɨ̀nà mànà ngʉ̌kpà vèbhálɛ, náadʉ̀ dhu àwɛ ndɨ dhu bhěyi tɨ́ Yěsù bhà uvitatálɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pbɛ́tʉ̀, kɔ̌kɔ̀ vèbhálɛ ʉ̀nɔ̀ fɨ̌yɔ̀ dhu nátɨ̀ uvitatálɛ adʉ̀ zèze tɨ́. Nɨ́ abádhí adʉ̀ nzá ndɨ dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pbɛ́tʉ̀ Pɛ́tɛrʉ̀ náadʉ̀ ndɨ̀và, ndɔ̀kʉ̀ kàbhǔlì ɔ̀. Nɨ́, ndɨ̀ ndàgǔ ndɨ̀ ndàndà ibhu-ɔ̀nga rɔ̀, kǎla mbɛrʉ̀-mbɛ́lɛ́mbɛ̀lɛ̀ kɛ̀lɛ̌ ányɨ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndàdu ndàrà pbɨ̀ndà atdídɔ̌ ɨdhɔ nʉ́kɔ ndɨ̀ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu dɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ndɨ nɨ́nganɨ́ tɨ́, Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ ɔ́yɔ̌ alɛ náakò ’àmbɛ òwu dɔ̌ Ɛ̀mawù tɨ́ kátɨna pbanga ɔ̀. Ndɨ pbanga nɨ́ɨ’ɨ̀ atdí kumì dɔ̀ná atdí nà kìlòmɛ̌tɛ̀rɛ̀ tɨ́ Yèrùsàlɛmà tɔ́ kɨgɔ̀ rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Abádhí ambɛ́nà ɔ̀tɛ dɔ̌ yà ɨ̀ nɔ̀nzɨ̀ kɔ́rɔ́ dhu-tsí dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɨ́ wɔ̀ abádhí rɔ̌tɛ, ’àdʉ̀ àmbɛ ’àgò dɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù nyʉ́ ndɨ̀tɨ́rɔ̀ náandrì abádhí tɨ́ ɔ̀, ’àdʉ̀ àmbɛ òwu dɔ̌ atdíkpá abádhí mànà. ");
INSERT INTO niy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pbɛ́tʉ̀, dhu adʉ̀ abádhí-nyɨ̌nga nɨ́tɨ ɨ̀nzɨ̌ rʉ̀nɨ Yěsù. ");
INSERT INTO niy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nɨ́ Yěsù ivú dhu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɨ́ nyǎgò dɔ̀ná, àzèmbè nyɨ̌ nyongó òwu?» Nɨ́ kɔ̀rɨ́ ábhàlɨ̌ náadʉ̀ ìko, ɨzʉ ràdʉ̀ ’ʉ̀ka atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Atdí abádhí nzínzì ɔ̌ alɛ, Kìlìyɔpà tɨ́ kátɨna, náadʉ̀ dhu ìvu kà-tsʉ̌ ndàtɨ: «Nyɨ tɨ́ ndɨ atdírɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ bhà nzínzì ɔ̌ ɨnzá nyɨ nyʉ̀nɨ kàrɨ́ ɨdhɔ nzínzì ɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu?» ");
INSERT INTO niy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ádhu ndɨ?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Yà Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ rɔ̌ ndɨ̀ nɔ́nzɨ̀ dhu. Ndɨ alɛ nɨ́’ɨ̀ ádrʉ̀ngbǎ ɔbɨ nà nabì. Kǎrà ndɨ pbɨ̀ndà ɔbɨ návi rɔ̌ kàsʉ̌na ɔ̌, ndɨrɔ̀ ɔ̀tɛ̌na ɔ̌ màtɨ́, Kàgàwà-ɔ̀nzɨ̌ ndɨrɔ̀ kɔ́rɔ́ alɛ-ɔ̀nzɨ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nɨ́ fàká pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, fàká ádrɔ̀drɔ̌ alɛ mànà nípfo ka, ’àbhʉ kɔtdɨ̀ anya dɔ̀ná ndɨ́nɨ̌ ka koho tɨ́, ’àdʉ̀ kàbhʉ kʉtɔ̌ mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mǎ nyʉ́, mǎ múbhì dhu ɨ̀rɛ̀ rɔ̌ ka ràrɨ̌ ndɨ Pbàìsràyélí nʉ́wʉ̌ rɨ́ ɨnɔ-kàsʉ̌ ɔ̌ rɔ̀. Pbɛ́tʉ̀ ròsè kɔ́rɔ́ dhu dɔ̀nǎ, indo kɔ́rɔ́ kɔ̀rɨ́ dhu ɔ́nzɨ̀ ɨ̀ rɔ́ ɨdhɔ náhʉ wà ɨ̀bhʉ. ");
INSERT INTO niy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nɨ́ obhó tɨ́, nzínzìka ɔ̌ ngúfe vèbhálɛ nábhʉ ɨdhɔ rʉ̀kɔ mǎ atdídɔ̌. Abádhí òwùnà bhɔ̌tsʉngá kàbhǔlì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nɨ́ ɨnzá ɨ̀ òtù Yěsù-abvò rɔ̀, abádhí àdʉ̀ ìngo, ’àdʉ̀ àtɨ̀nà màlàyíká ràvi ɨ̀ fɨ̌yɔ̀. Nɨ́, ɨ màlàyíká ràtɨ ìnè Yěsù ràrɨ̌’ɨ̀ nyɨ̀kpɔ́na nà. ");
INSERT INTO niy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yà mǎ mɨ̀’ɨ̀ mànà atdíkpá alɛ nzínzì ɔ̌, ngúfe alɛ nádʉ̀ òwu átɔ̀ kàbhǔlì ɔ̀, ’àdʉ̀ ndɨ dhu nótù àdhàdhɨ̀ yà vèbhálɛ náwɛnà dhu bhěyi tɨ́. Pbɛ́tʉ̀ abádhí àdʉ̀ nzá ndɨ Yěsù-ngbɔ̀ nyʉ́ nála.» ");
INSERT INTO niy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nɨ́ ɨ̀mbǎ ɨrɛ̀ta nà alɛ! Ndɨrɔ̀ nyɨ̌ nɨ́ ɨ̀nzɨ̌ arɨ́ pbànábí nʉ́ʉnɔ kɔ́rɔ́ dhu ná’u tsàkàtsàkà alɛ! ");
INSERT INTO niy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dhu aká tɨ́ obhó Krɨ́stɔ̀ ràbà àpbɛ̀ ndɨ dhu bhěyi tdʉ̌ ndɨ̀ ndotsú pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ dɔ̀ná ka kandí Kàgàwà bhà Andítá ɔ̀ kɔ́rɔ́ dhu-tɨ̀ nɔ́pɛ̀ ndàwɛ abádhí tɔ̀, rɔ̀pɛ̀ ndɨ̀ Músà bhà Andítá ɔ̀ rɔ̀, ràrà àhʉ kɔ́rɔ́ pbànábí náandí dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Abádhí níitdègu yà ɨ̀ úbhi òwu rɔ̌ ɔ̀nà pbanga níndù, nɨ́ Yěsù adʉ̀ dhu ɔ̀nzɨ̀ ɨtsɛ rárà alɛ bhěyi. ");
INSERT INTO niy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pbɛ́tʉ̀ abádhí adʉ̀ Yěsù àgo ’àtɨ: «Ádɨ̌ atdíkpá mǎ mànà. Obhó tɨ́, adyifɔ̀ àrà wà, ndɨrɔ̀ ɨnga rǎtɨ kòmbí tɨ́.» Nɨ́ Yěsù adʉ̀ òtsù, ’òkò atdíkpá abádhí mànà. ");
INSERT INTO niy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nɨ́ ɔ̀nyʉ̀-tsʉ̀nǎ ɨ̀ òkò atdíkpá abádhí mànà rɔ́rɔ̀, Yěsù níidyi mʉ̀gatì ndàlʉ̌ fɔná, ndàdʉ̀ ɔ̀tsɔ̀ nábhʉ Kàgàwà tɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ mʉ̀gatì-ɔ̌nga nʉ́kɔ ndʉ̀ndɔ̀ abádhí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nɨ́rɔ̀ nɨ́ ndɨ abádhí-nyɨ̌nga náarà ndùtù, ’àdʉ̀ Yěsù nʉ́nɨ. Pbɛ́tʉ̀ Yěsù náadʉ̀ àwǐ dòtsí abádhí-nyɨ̀kpɔ́ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Àlɛ̌-afí nígběnà tɨ́ obhó àlɛ̌ ɔ̀, yà otu ɔ̌ kà rǔbhi Kàgàwà bhà Andítá-tɨ̀ náwɛ rɔ̌ àlɛ̌ tɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Abádhí adʉ̀ ’ɨ̀và ányɨ̀rɔ̌ rɔ̀ tɨ́, ’àdu ɨ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Nɨ́ ányɨ̀ abádhí atù kɔ̌kɔ̀ atdí kumì dɔ̀ná atdí nà uvitatálɛ ɔdhɨ́ya mànà ɨ̀ nàndu rɔ́. ");
INSERT INTO niy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nɨ́ ɨ uvitatálɛ náadʉ̀ àtɨ̀nà abádhí nɨ̌: «Obhó nyʉ́, Ádrʉ̀ngbǎlɛ Yěsù nɨ́ngbɛ̀ wà ndɨ̀. Kàvi wà ndɨ̀ Sìmonì tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nɨ́ kɔ̀rɨ́ ɔ́yɔ̌ ábhàlɨ̌ náadʉ̀ rɔ̀yá ndɨ̀ nɔ̀nzɨ̀ otu ɔ̌ dhu mà, ɨ̀ngbǎ dhu bhěyi màtɨ́ ɨ̀ òwù Yěsù nʉ́nɨ mʉ̀gatì-ɔ̌nga nʉ́kɔ̌ rɨ́ rɔ́ dhu mànà dhu náwɛ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yà Ɛ̀mawù rɔ̀ ìwǔ alɛ rɔ̌tɛ ngʉ̌kpà ábhàlɨ̌ mànà ɔ̀ná kàsʉmɨ̀ ɔ̌ tɨ́ nɨ́ ndɨ, Yěsù nyʉ́ ndɨ̀tɨ́rɔ̀ náavì ndɨ̀ abádhí nzínzì ɔ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Kàgàwà àkǎ ndàbhʉ nyɨ̌ nyǒkò màrʉ̀ngà ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nɨ́ atdídɔ̌ ádrʉ̀ngbǎ ɔdɔ nɨ́sɨ̌ ɔ̀yà dhu-okú dɔ̀ rɔ̀, abádhí adʉ̀ dhu àtɨ̀ alɛ-mùlǐ ɨ̀ àla dhu tɨ́. ");
INSERT INTO niy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pbɛ́tʉ̀ Yěsù adʉ̀ dhu nívu abádhí-tsʉ̌ ndàtɨ: «Ádhu fʉ̀kʉ́ ɨrɛ̀ta nɨ̀nza? Ndɨrɔ̀ ádhu wɔ̀rɨ́ ɨrɛ̀ta-tɨdɔ̀ rɨ̌’ɨ̀ afíku ɔ̀ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nyàndà pɛ́ ɔtsʉ́du mà pfɔ̌du mànà! Ɨma nyʉ́ nɨ́ yà! Nyàpbàlǎ pɛ́ ngbɔ̌du, ndɨrɔ̀ nyàndà pɛ́, alɛ-mùlǐ náarɨ́’ɨ̀ ɨ̀mbǎ ɨ̀zǎ nà rɔ̀ná, ndɨrɔ̀ kà-kpa mà náarɨ́’ɨ̀ ɨ̀mbǎ yà rùdú nyɨ̌ nyálǎna dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wɔ̀ dhu ʉ̀nɔ ndɨ̀ ndɨ́ rɔ̀, kǎdʉ̀ ɔtsʉ́na mà, pfɔ̌na mànà nɨ́tɛ̀ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pbɛ́tʉ̀ wɔ̀ ɨ̀ ɨ́’ɨ̀ nà ádrʉ̀ngbǎ dhɛ̀dhɛ ɔ̌, abádhí rɨ̌ nzɨ̌ ndɨ̀ ndʉ́nɔna dhu ná’u, ndɨrɔ̀ atdídɔ̌ ɨdhɔ àdʉ̀ abádhí nʉ́kɔ dhu-okú dɔ̀ rɔ̀, Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Nyɨ̌ tɨ́’ɨ̀ ìnè ɔ̀nyʉ̀nà ka kádʉ̀ dhu nà fʉkʉ́ ɨrɔ́?» ");
INSERT INTO niy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nɨ́ abádhí adʉ̀ ìkùrǔ ìkuru ɨ̀bhɛ̀-rɔrɔ̌-ngba nábhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kǎdʉ̀ ndɨ ɨ̀bhɛ̀ nákɔ, ndàdʉ̀ à’ànà àzèmbè abádhí rǎlǎna rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Kɔ̀nɨ̌ yà fʉ̌kʉ̀ ma mongónà ʉ̀nɔ̀nà òko alɛ kòko atdíkpá rɔ́rɔ̀ dhu nɨ́ wɔ̀. Dhu aká yà kɔ́rɔ́ ka kandí dùdú Músà bhà Ʉyátá ɔ̀ màtɨ́, Kàgàwà bhà pbànábí tɔ́ Andítá ɔ̀ màtɨ́, ndɨrɔ̀ Zàburì ɔ̀ màtɨ́ dhu rɔ̀nzɨ̀ ɨ̀ kɔ́rɔ́.» ");
INSERT INTO niy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɨ́rɔ̀ nɨ́ ndɨ kǎdʉ̀ abádhí tɔ́ ɨrɛ̀ta nʉ́ngbɛ, ndɨ́nɨ̌ abádhí alʉ́ tɨ́ Kàgàwà bhà Andítá rʉ̌nɔna dhu dɔ̀ya ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tdɨ́tdɔ̌ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Kàgàwà bhà Andítá ɔ̀ ka kandí dhu katɨ: Krɨ́stɔ̀ àkǎ ndàbà àpbɛ̀, kàkǎ ndɔ̀vɛ̀, ɨ̀bhʉ rɨ́ kìsě ɨdhɔ ɔ̌ ndàdʉ̀ ndɨ̀ngbɛ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ndɨrɔ̀ kɔ̌vɔ̀ rɔ̌, dhu àkǎ kʉnɔ̀ ìndrǔ rɨ̌ ’ʉ̀gɛ̀rɛ̀, ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga, Kàgàwà ràdʉ̀ dhu ʉ̀bà fɨ̌yɔ̀ dhu kɔ́rɔ́ pbìrì ɔ̌ alɛ tɔ̀, rɔ̀pɛ̀ ndɨ̀ Yèrùsàlɛmà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyɨ̌ nɨ́ ndɨ dhu tɔ́ ngàmbì. ");
INSERT INTO niy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ndɨrɔ̀ kɔ̀nɨ̌ ma mɨ́ yà Àbadu náakɔ̀ fɨ̀ndá làká fʉ̌kʉ̀ dhu nívì fʉ̌kʉ̀. Nɨ́ nyɨ̌ nyàkǎ nyǒkò yàrɨ́ kɨgɔ̀ ɔ̌ tɨ́, ràrà àhʉ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɨ́rà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábà nyɨ̌ nyɨ́ dhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yěsù adʉ̀ àrà pbɨ̀ndà ábhàlɨ̌ nà Bɛ̀tànɨyà tɨ́ kátɨna pbanga-tɨ’ɔ̀. Nɨ́, kǎngbɛ ɔtsʉ́na ndàso abádhí nɨ̌. ");
INSERT INTO niy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nɨ́ yà abádhí násǒ ndɨ̀ ndɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, àbadhi mà nʉ́ʉbhá ɨ̀ pbɨ̀ndà ábhàlɨ̌ mànà, ndàdʉ̀ ɔ̀dzɨ̀, ndàrà ɔ̀rʉ̀-akpà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɨ́ Yěsù ɨ̀ ɨ̀fʉ dhu-lutìnǎ, abádhí náadʉ̀ ’àdu ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ nà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Abádhí nóongónà ’ùndu bìlǐnganà Kàgàwà bhà ɨdzá, ’àmbɛ Kàgàwà-ɔvɔ̀ nílè dɔ̌.");
INSERT INTO niy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ɔ̀pɛ̀ tɨ́ kɔ́rɔ́ dhu rɨ̌ ndɔ̀pɛ̀ rɔ̀, Ɔtɛ tɨ́ ka kátɨna alɛ nɨ́ɨ’ɨ̀ ìnè. Ndɨ Ɔtɛ tɨ́ ka kátɨna alɛ mà nɨ́ɨ’ɨ̀ atdíkpá Kàgàwà mànà. Ndɨrɔ̀ ndɨ Ɔtɛ nɨ’ɨ̀ Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ɔ̀pɛ̀ tɨ́ kɔ́rɔ́ dhu rɨ̌ ndɔ̀pɛ̀ rɔ̀, kɨ̌’ɨ̀ Kàgàwà-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kàgàwà náanzɨ̀ kɔ́rɔ́ dhu kǒtù ɔ̌. Ndɨrɔ̀ Kàgàwà náanzɨ̀ nzá atdí dhu mà ɨnzá ndɨ̀ ndɔ̀nzɨ̀ kǒtù ɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ndɨ Ɔtɛ-nyʉtsì ɨ’ɨ̀ dhu nɨ’ɨ̀ ípìrɔ̌nga, ndɨ ípìrɔ̌nga ràdʉ̀ ɨ̀’ɨ̀ awáwʉ̀ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndɨ awáwʉ̀ nátdyi nga ɨ́nɔ̀ ɔ̌ rɔ̀, ɨ́nɔ̀ náadʉ̀ nzá ndɨ awáwʉ̀ nákɔ. ");
INSERT INTO niy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nɨ́rɔ̀ nɨ́ ndɨ Kàgàwà nívì atdí alɛ nɨ́ɨtɔ ndɨ̀. Ndɨ alɛ-ɔvɔ̀ nɨ’ɨ̀ Yùwanɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kɨ̌ra ndɨ́nɨ̌ ndɨ̀ ndadɨ̀ tɨ́ ngàmbì tɨ́ ndɨ awáwʉ̀ tɔ̀, ndɨ́nɨ̌ kɔ́rɔ́ alɛ náadʉ̀ tɨ́ ndɨ awáwʉ̀ ná’ù kà rʉ̌nɔna ndɨ awáwʉ̀ dɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ndɨ Yùwanɨ̀ nyʉ́ ndɨ̀tɨ́rɔ̀ nɨ’ɨ̀ nzɨ̌ awáwʉ̀, pbɛ́tʉ̀ kɨ̌ra ndɨ́nɨ̌ ndadɨ̀ tɨ́ ngàmbì tɨ́ ndɨ awáwʉ̀ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndɨ Ɔtɛ nɨ’ɨ̀ obhóná awáwʉ̀ nyʉ́, yà kɔ́rɔ́ alɛ-nyɨ̌nga náwʉ̀ rǎdʉ̀ yà adzɨ ɔ̌ ndɨ̀ ndɨ̀rà àhʉ rɔ̀ awáwʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kɨ̌’ɨ̀ ìnè yà adzɨ ɔ̌. Ndɨrɔ̀ Kàgàwà náanzɨ̀ yà adzɨ kǒtù ɔ̌, pbɛ́tʉ̀ yà adzɨ ɔ̌ alɛ náadʉ̀ nzá kʉ̀nɨ. ");
INSERT INTO niy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kɨ̌ra àhʉ fɨ̀yɔ́ pbìrì ɔ̌ alɛ nyʉ́ nzínzì ɔ̌, pbɛ́tʉ̀ ɨ alɛ nádʉ̀ nzá kàkɔ. ");
INSERT INTO niy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pbɛ́tʉ̀ kɔ́rɔ́ alɛ, yà ka nakɔ̀ ’àdʉ̀ kà’ù tɔ̀, kǎdʉ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ rʉ̀gɛ̀rɛ̀ ɨ̀ ’òngò Kàgàwà bhà inzo nyʉ́ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abádhí nóngò Kàgàwà bhà inzo tɨ́, ɨ̀nzɨ̌ nɨ́ alɛ-ngbɔ̀ tɔ́ ɔ́fɔ̀ ɔ̌, ndɨrɔ̀ ɨ̀nzɨ̌ nɨ́ ìndrǔ-afí nózè ka dhu bhěyi ka kʉgʉ ɨ̀ dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀ abádhí nóngò kà bhà inzo tɨ́ Kàgàwà ózè ka rɨ̀’ɨ̀ ndɨ dhu bhěyi dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɔtɛ tɨ́ ka kátɨna alɛ nʉ́ʉgɛ̀rɛ̀ ndɨ̀, ndòngò ìndrǔ tɨ́, ndàdʉ̀ ɨ̀rà àdɨ àlɛ̌ nzínzì ɔ̌, àlè tɨ́ ndɨ̀ ndàlè ídzìnga mà, obhónga mànà nɨ̌ rɔ́rɔ̀. Àlɛ̌ kala kàbhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀. Ndɨ awáwʉ̀ nɨ́, yà Àbanà Kàgàwà-fɔ́ ndɨ atdí tɨ́ arɨ́ ɨ̀’ɨ̀ kàbhà ɨngba náabà. ");
INSERT INTO niy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kà dɔ̌ ndɨ̀ ndɨ́ dhu àwɛ̌ rɔ̀, bàtizò nubhónà Yùwanɨ̀ náavɔ̀ dhu àrǐ nyʉ́ tɨ́, ndàtɨ: «Yàrɨ́ nɨ́ ndɨ yà ma mʉnɔ alɛ, matɨ: ‹Dzidu dɔ̌ rɨ́rà alɛ ràrɨ̌ Ádrʉ̀ngbǎlɛ nyʉ́, ròsè dùdunǎ. Kɨ̌’ɨ̀ ìnè angyangyɨ ɨnzá ka kàpɛ̀ mʉgʉ rɔ́rɔ̀ nɨ́dhunɨ̌.›» ");
INSERT INTO niy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pbɨ̀ndà ádrʉ̀ngbǎ ídzìnga-okú dɔ̀ rɔ̀, kǎso àlɛ̌, àlɛ̌ ràbà ídzìnga, ídzìnga dɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kàgàwà níibho pbɨ̀ndà Ʉyátá àlɛ̌ tɔ̀, Músà-otù ɔ̌. Pbɛ́tʉ̀ kǎdʉ̀ pbɨ̀ndà ídzìnga mà, pbɨ̀ndà obhónga mànà níbhò àlɛ̌ tɔ̀ Yěsù Krɨ́stɔ̀-otù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Atdí alɛ mà nápɛ̀ nzá Kàgàwà àlǎ akɛkpá màtɨ́. Pbɛ́tʉ̀ ka nábhʉ àlɛ̌ rʉ̀nɨ nɨ́ yà atdí tɨ́ arɨ́’ɨ̀ kà t’Ídhùnà. Ndɨ kà t’Ídhùnà nɨ́ ndɨ̀ Àbanà tɨ́ arádɨ, ndɨrɔ̀ ka nɨ́ Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Atdíku Yèrùsàlɛmà rɔ̀, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náavì pbàkùhání mà, pbàláwí mànà ròwù dhu ìvu Bàtizò nubhónà Yùwanɨ̀-tsʉ̌ ka ràrɨ̌ àdhɨ. Nɨ́, yàrɨ́ nɨ́ ndɨ Yùwanɨ̀ adʉ̀ àdunà dhu. ");
INSERT INTO niy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɨnzá ndɨ̀ ndàgò ndɨ̀ rɔ́rɔ̀, kǎvɔ̀ dhu kpangba ndàtɨ: «Ɨma, ma nɨ́ nzɨ̌ Krɨ́stɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nɨ́, abádhí adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌ ’àtɨ: «Olu, ɨnyɨ nɨ́ àdhɨ? Nyɨ tɨ́ Ɛ̀lɨyà?» Nɨ́ kǎdʉ̀ dhu àdu, ndàtɨ: «Ɨ̀nzɨ̌ nɨ́ ma Ɛ̀lɨyà.» Abádhí níivú dhu tdɨ́tdɔ̌: «Nyɨ tɨ́ Kàgàwà bhà nabì yà mǎ márɔ́dɔna?» Yùwanɨ̀ náadʉ̀ dhu àdu: «Ɨ̀nzɨ̌ nɨ́ ma Kàgàwà bhà Nabì.» ");
INSERT INTO niy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nɨ́ abádhí adʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Olu, nyɨ nɨ́ àdhɨ, ndɨ́nɨ̌ mǎ madʉ̀ tɨ́ òwu nyɨ nyádǔna fǎkà dhu ɔ̀vɔ̀ yà mǎ nìvìnà alɛ tɔ̀? Ádhu nyɨ nyʉ́ nyɨ nyʉ̀nɔ̀ nyɨ-tɨ́rɔ̀ dʉ̀nʉ́?» ");
INSERT INTO niy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nɨ́, Yùwanɨ̀ adʉ̀ yà Kàgàwà bhà nabì Ìsayà náandí dhu nádu abádhí tɔ̀, ndàtɨ: «Ɨma nɨ́ yà rʉ̀ngʉ̀ ɔ̀ rɔ̀ rúkǔ, tǔna ràmbɛ ndɨ̀rɨ̀ dɔ̌ alɛ: ‹Nyùtǒ Ádrʉ̀ngbǎlɛ bhà otu.›» ");
INSERT INTO niy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kɔ̌kɔ̀ ka kìvìnà alɛ nɨ’ɨ̀ Pbàfàrìsáyó. ");
INSERT INTO niy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nɨ́ abádhí níivú dhu tdɨ́tdɔ̌ Yùwanɨ̀-tsʉ̌, ’àtɨ: «Olu, ɨ̀nzɨ̌ nɨ́ nyɨ Krɨ́stɔ̀ mà, ndɨrɔ̀ Ɛ̀lɨyà mà, ndɨrɔ̀ ɨ̀nzɨ̌ nɨ́ nyɨ yà mǎ marɨ́ ɔ̀dɔna Kàgàwà bhà nabì mà rɔ̀, ádhu nyɨ nyárɨ́ bàtizò núbhǒ ìndrǔ tɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nɨ́ Yùwanɨ̀ adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ɨma, ma márɨ́ bàtizò núbhǒ ìndrǔ tɔ̀ ɨdha nɨ̌. Pbɛ́tʉ̀ nzínzìkʉ ɔ̌ atdí alɛ rɨ̌’ɨ̀ ìnè. Ndɨ alɛ nɨ́ ɨnzá nyɨ̌ nyʉ́nɨ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kà rɨ̌rà dzidu dɔ̌, pbɛ́tʉ̀ ma màkǎ nzá mɔkɔ̀ ma, mʉnga kà-pfɔ̀ rɔ̌ kàyìtò-mbǐ mà.» ");
INSERT INTO niy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wɔ̀ dhu náanzɨ̀ ndɨ̀ Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̀, yà Yùwanɨ̀ ongónà bàtizò núbho ìndrǔ tɔ̀ ɔ̀ná rɔ̀, Yɔ̀rɔ̀danɨ̀ tɨ́ kátɨna ɨdha-akpà-adzènǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsútsǎ nɨ́nganɨ́, Yùwanɨ̀ náala Yěsù tɨna ɔ̀ rɨ́rà rɔ́, ndàdʉ̀ àtɨ̀nà: «Kànɨ̌ Kàgàwà bhà Tàmǎ-ngba, yà adzɨ ɔ̌ alɛ tɔ́ nzɛ́rɛnga nú’ǒ rɨ́. ");
INSERT INTO niy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ka nɨ́ ndɨ yà ma mʉnɔ dhu okúna dɔ̀ rɔ̀, matɨ: ‹Dzidu dɔ̌ rɨ́rà alɛ ràrɨ̌ Ádrʉ̀ngbǎlɛ nyʉ́ ròsè dùdunǎ, kɨ̌’ɨ̀ ìnè angyangyɨ, ɨnzá ka kàpɛ̀ mʉgʉ rɔ́rɔ̀ nɨ́dhunɨ̌.› ");
INSERT INTO niy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ɨma nyʉ́ mà ma mʉnɨ nzá ka. Pbɛ́tʉ̀, ma mɨ́rà bàtizò núbho ìndrǔ tɔ̀ ɨdha nɨ̌, ndɨ́nɨ̌ Ìsràyelì ɔ̌ bhà nabhʉ̀ tɨ́ rʉ̀nɨ ka.» ");
INSERT INTO niy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nɨ́ kǎdʉ̀ dhu ɔ̀vɔ̀ tdɨ́tdɔ̌, ndàtɨ: «Ma mala Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rífo àmbò tɔ́ ɔ́fɔ̀ ɔ̌, ndàdɨ kà-dɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ndɨrɔ̀ ɨma nyʉ́ mà, ma mʉnɨ nzá ka. Pbɛ́tʉ̀ Kàgàwà, yà ɨma nivi mɨrà bàtizò núbho ìndrǔ tɔ̀ ɨdha nɨ̌, náatɨ ɨma nɨ̌: ‹Nyɨ nyálǎna Ɨ̀lɨ̌lǎ-Alafí rǐfo, ndàdʉ̀ àdɨ dɔ̀ná alɛ nɨ́ ndɨ Ɨ̀lɨ̌lǎ-Alafí nɨ̌ rɨ́ bàtizò núbho ìndrǔ tɔ̀ alɛ.› ");
INSERT INTO niy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɨ́rɔ̀, ma mála wà ndɨ dhu, ndɨrɔ̀ ma mɨ́ dhu ɔ̀vɔ kpangba, àbadhi ràrɨ̌ ndɨ Kàgàwà t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tsútsǎ nɨ́nganɨ́ tdɨ́tdɔ̌, bàtizò nubhónà Yùwanɨ̀ mà nɨ́ɨ’ɨ̀ yà inzì ɨ̀ ɨ́’ɨ̀ná ɔ̀ná ngari ɔ̌ tɨ́, pbɨ̀ndà ɔ́yɔ̌ ábhàlɨ̌ mànà. ");
INSERT INTO niy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nɨ́, Yěsù ndɨ̀ ndàla ʉ̀da rʉ́da rɔ́ rɔ̀, kǎtɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kɔ̀nɨ̌ Kàgàwà bhà Tàmǎ-ngba.» ");
INSERT INTO niy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nɨ́ kɔ̌kɔ̀ ɔ́yɔ̌ ábhàlɨ̌ nɨ́ɨrɨ wɔ̀ Yùwanɨ̀ ʉ̀nɔ̀ dhu, ’àdʉ̀ ’ɨ̀và, ’òwù Yěsù-owù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nɨ́, àrà ndɨ̀ ndárà rɔ́rɔ̀, Yěsù náagɛ́rɛ́ ndɨ̀ ndàndà olùnga, ndàdʉ̀ kɔ̌kɔ̀ ábhàlɨ̌ nála owùna ɔ̌ ríwu rɔ́. Nɨ́ kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɔ́nɛna?» Nɨ́ abádhí adʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Rabǐ, nyɨ nyarádɨ ɨ̀ngbɔrɔ́?» Rabì-tɨ̀ nɨ́ Màlimò. ");
INSERT INTO niy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyìwǔ, ndɨ́nɨ̌ nyɨ̌ nyala tɨ́ ka.» Nɨ́ abádhí adʉ̀ òwu, ’àdʉ̀ kǎrádɨ rɔ́ nga àla. Abádhí adʉ̀ òko atdíkpá kà mànà ndɨ nɨ́nganɨ́. Ndɨ dhu nɨ’ɨ̀ mbɛ̀mbɛ̀ ɨdrɛ̀ adyifɔ̀-sɨsɨ̀ adyídɔ̌ nga tɔ́ ɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kɔ̌kɔ̀ Yùwanɨ̀ rʉ̌nɔna dhu nɨ̀rɨ̀nà, ’àdʉ̀ òwu Yěsù-owù ɔ̌ alɛ nzínzì ɔ̌ atdí alɛ-ɔvɔ̀ nɨ’ɨ̀ Àndɛ̀rɛyà. Ndɨ Àndɛ̀rɛyà nɨ’ɨ̀ Sìmonì Pɛ́tɛrʉ̀ t’ádɔ̀nà. ");
INSERT INTO niy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nɨ́ Yěsù-tɨ́ rɔ̀ ɨ̀ ɨ̀và ɨ̀ rɔ̀, Àndɛ̀rɛyà náadʉ̀ àrà angyi adɔ̀nà Sìmonì rɨ̌’ɨ̀ ɨ, ndàdʉ̀ àtɨ̀nà kànɨ̌: «Mǎ màla Màsiyà.» Màsiyà-tɨ̀ nɨ́ Krɨ́stɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kǎdʉ̀ wɔ̀ ndɨ adɔ̀nà, Sìmonì, nʉ́ndà ’òwù nà Yěsù rɨ̌’ɨ̀ ɨ. Nɨ́ ányɨ̀ abádhí òwù ùvò rɔ̀, Yěsù ʉdɨ́ nyɨ̀kpɔ́na ndàndà Sìmonì, ndàdʉ̀ àtɨ̀nà nɨ̌: «Ɨnyɨ, nyɨ nɨ́ Sìmonì, Yùwanɨ̀ t’ídhùnà. Nɨ́ rɔ̀pɛ̀ ndɨ̀ kòmbí, ka kóngo nyanzì Kɛfà tɨ́.» Kà-tɨ̀ nɨ́ Pɛ́tɛrʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsútsǎ nɨ́nganɨ́, Yěsù azè ndàrà Gàlìlayà tɔ́ pbìrì ɔ̀. Nɨ́ ányɨ̀ ndɨ̀ ndárà rɔ́rɔ̀, kǎtù Fìlipò, ndàdʉ̀ àtɨ̀nà nɨ̌: «Fìlipǒ, ɨ́rà owùdu ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Wɔ̀ ndɨ Fìlipò nɨ’ɨ̀ Àndɛ̀rɛyà mà Pɛ́tɛrʉ̀ mànà mà tɔ́ pbanga, Bɛ̀tɛ̀sàyidà tɨ́ kátɨna ɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nɨ́ Fìlipò arà, ndàrà àhʉ Nàtànelì-tɨ́, ndìtsì àtɨ̀nà kànɨ̌: «Mǎ màla wà yà pbɨ̀ndà Ʉyátá ɔ̀ Músà avɔ̀ dhu okúna dɔ̀ rɔ̀, ndɨrɔ̀ yà fɨ̀yɔ́ andítá ɔ̀ Kàgàwà bhà pbànábí náavɔ̀ dhu okúna dɔ̀ rɔ̀ alɛ. Ndɨ alɛ nɨ́ Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ, Yɔ̀zɛfʉ̀ t’ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nɨ́, Nàtànelì adʉ̀ dhu ìvu Fìlipò-tsʉ̌, ndàtɨ: «Ídzì dhu nyʉ́ t’ádʉ̀ àhʉ àhʉ̌ Nàzàretì rɔ̀ dhéè?» Nɨ́, Fìlipò adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ́rà pɛ́ ndɨ́nɨ̌ nyɨ nyala tɨ́ ka.» ");
INSERT INTO niy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nɨ́, Yěsù itdègu Nàtànelì àlǎ tɨna ɔ̀ rɨ́rà rɔ́, nɨ́ kǎdʉ̀ dhu ɔ̀vɔ̀ kǒkú dɔ̀ rɔ̀, ndàtɨ: «Kànɨ̌ Pbàìsràyélí tɔ́ pbìrì ɔ̌ alɛ nyʉ́ nɨ́ yà, ɨ̀mbǎ ʉtrátá rɨ̌’ɨ̀ nyʉnatsì.» ");
INSERT INTO niy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nɨ́ Nàtànelì adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Nyɨ nyʉ̀nɨ ma ɨ̀ngbǎ dhu bhěyi?» Nɨ́ Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ɨnzá Fìlipò àpɛ̀ nyanzi rɔ́rɔ̀, ma màlanà nyɨ mùtinì-kpa-tsìnǎ nyɨ nyìdè rɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nɨ́ Nàtànelì adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Màlimǒ, ɨnyɨ nɨ́ Kàgàwà t’ídhùnà, ndɨrɔ̀ nyɨ nɨ́ Pbàìsràyélí tɔ́ Ádrʉ̀ngbǎ Kamà!» ");
INSERT INTO niy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Nyɨ nyà’ù tɨ́ dhu, yà ma màtɨ, ma ràlanà nyɨ mùtinì-kpa-tsìnǎ nyɨ nyìdè rɔ́ dhu-okú dɔ̀ rɔ̀? Pbɛ́tʉ̀, nyɨ nyɨ́ wɔ̀ dhu dɔ̀nǎ róse ádrɔ̀drɔ̌ dhu nyʉ́ nálǎ!» ");
INSERT INTO niy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀. Nyɨ̌ nyɨ́ ɔ̀rʉ̀-akpà-tsʉ̀ nálǎ ndɨ̀ nàngbɛ, Kàgàwà bhà màlàyíká ràdʉ̀ òwu ùpo rɔ̌ ɔrʉ̀, ’àdʉ̀ ìfo obvò Ìndrǔ t’ídhùnà dɔ̌ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ɨ̀bhʉ ráhʉ ɨdhɔ ɔ̌, ka kanzɨ̀ àdhɨ̀ngbǎ ka kʉ̀ndà nɨ̌ mʉ̀hɛndʉ̀ Kanà tɨ́ kátɨna pbanga ɔ̌, Gàlìlayà tɔ́ pbìrì ɔ̀. Yěsù tsánà, Màrɨyà, nɨ́ɨ’ɨ̀ ìnè ndɨ mʉ̀hɛndʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ndɨrɔ̀ ka kadʉ̀ Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà núnzì átɔ̀ rìwǔ ndɨ mʉ̀hɛndʉ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nɨ́, yà ɔ̀mvʉ̀na ka kɨ́ dɨ̀vayì níku rɔ̀, Yěsù tsánà náatɨ Yěsù nɨ̌: «Kàrɨ́ alɛ rɔ̌mvʉ̀na dɨ̀vayì rɨ̌’ɨ̀ mbǎ.» ");
INSERT INTO niy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nɨ́ Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Iyá, ádhu ndɨ nyɨ nyòzè mɔnzɨ̀? Ɨnzá pbàkà kàsʉmɨ̀ nápɛ̀ àkǎ.» ");
INSERT INTO niy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nɨ́ kà-tsánà adʉ̀ àtɨ̀nà kasʉtálɛ nɨ̌: «Ɔ̀nzɨ nyɔ̀nzɨ kà rǎvǐna nyɔ̌nzɨ̀ kɔ́rɔ́ dhu.» ");
INSERT INTO niy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ányɨ̀rɔ̌, yà odu nɨ̌ ka kɔ́bhɔ̀lɔ̀ andu-abábá nɨ́ɨ’ɨ̀ ìnè aza. Ɨ andu nɨ’ɨ̀ yà Pbàyàhúdí náarɨ́ ’ù’ǒ ’ɨ̀lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ nɨ̌ ɨdha nʉ́dhɔ̌ ka karɨ́ ɔ̀yà andu. Ndɨrɔ̀, ɨ andu nɨ’ɨ̀ mbɛ̀mbɛ̀ atdí mɨyà lítrè mà rǎdʉ̀ òtsù atdí ɔ̀ nɨ̌ dhu bvʉ̀tɨ́ andu. ");
INSERT INTO niy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nɨ́ Yěsù atɨ kɔ̌kɔ̀ kasʉtálɛ nɨ̌: «Nyùtdyǒ ɨdha, nyɨ̌rǎ kɔ̀rɨ́ andu nɨ̌ kɔ́rɔ́.» Nɨ́ abádhí adʉ̀ ɨ andu nɨ́ra ɨdha nɨ̌ rùlè liyá. ");
INSERT INTO niy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìtdyo pɛ́ ka akɛ, nyǒwù nà mʉ̀hɛndʉ̀ tɔ́ ádrʉ̀ngbǎlɛ rìnè.» Nɨ́ abádhí adʉ̀ òwu kà nà ndɨ ádrʉ̀ngbǎlɛ rìnè. ");
INSERT INTO niy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Wɔ̀ mʉ̀hɛndʉ̀ tɔ́ ádrʉ̀ngbǎlɛ níinè yà dɨ̀vayì tɨ́ Yěsù ʉ̀gɛ̀rɛ̀ ròngò ɨdha, ɨ̀nzɨ̌ ndàdʉ̀ àdhà rɔ̀ màtɨ́ ka kìwǔ ndɨ dɨ̀vayì nà dhu nʉ́nɨ. Pbɛ́tʉ̀ yà ndɨ ɨdha nùtdyǒnà kasʉtálɛ kɛ̀lɛ̌ nɨ́ ɨ ɨwà ka nʉnɨ. Nɨ́ wɔ̀ mʉ̀hɛndʉ̀ tɔ́ ádrʉ̀ngbǎlɛ náanzi akpatsi, ndàdʉ̀ dhu ìvu tsʉ̀ná, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Ìgyò! Kɔ́rɔ́ alɛ náarɨ́ atdídɔ̌ òvù dɨ̀vayì nábhʉ̌ kɔpɛ̀ ɔmvʉ́ rɔ̀ná rɔ̀ angyi, kadʉ̀ yà ɨnzá òvù mběyi-tsí níbhò olù, ɨwà ìndrǔ ɔ̀mvʉ̀ ɨ̀ ’òrì rɔ́rɔ̀. Nɨ́, nyɨ nyàdʉ̀ tɨ́ atdídɔ̌ òvù dɨ̀vayì nyʉ́ nɔ́dɔ̀ rɨ̀rà àhʉ kòmbínga ɔ̀ màtɨ́?» ");
INSERT INTO niy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wɔ̀rɨ́ nɨ́ ndɨ Yěsù anzɨ̀ pbɨ̀ndà wɛmbɛrɛ̀ tɔ́ wɨwɨ̀. Kǎnzɨ̀ ka Kanà tɨ́ kátɨna Gàlìlayà tɔ́ pbìrì ɔ̌ atdí pbanga ɔ̀. Ndɨ dhu adʉ̀ kàbhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ nɨ́tɛ̀, kàbhà ábhàlɨ̌ ràdʉ̀ kà’ù. ");
INSERT INTO niy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wɔ̀ dhu-dzidɔ̌, Yěsù mà náadʉ̀ òwu Kàpɛ̀rnàwumù tɨ́ kátɨna pbanga ɔ̀ atdíkpá, ɨ́yànà mà, adɔ́na mà, ndɨrɔ̀ pbɨ̀ndà ábhàlɨ̌ mànà. Abádhí náadʉ̀ òko ányɨ̀ ngúfe ɨdhɔ kɛ̀lɛ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Atdíku, Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ nɨ́ɨ’ɨ̀ ɨwà ndɨ̀ ndìndù ndɨ̀ rɔ́. Nɨ́ Yěsù ɨvà ndɨ̀, ndàrà Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nɨ́ ányɨ̀, kǎtsù Kàgàwà bhà ɨdza, ndàdʉ̀ ìkyì-akpá mà, tàmà mà, àmbò mànà nábhʉ̌ rɨ́ kudzǐ alɛ mà nótù obvò òkò rɔ́. Ndɨrɔ̀ ányɨ̀-dza kǎtù ngʉ̌kpà alɛ nɨ’ɨ̀ fʉ̀rangà ɔ̌ nga nábhʉ̌ rɨ́ kʉwʉ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nɨ́, Yěsù akyɛ̀ imbi asé bhěyi, ndàdʉ̀ kɔ̀rɨ́ alɛ nódì nɨ̌ kɔ́rɔ́, ndìpfo Kàgàwà bhà ɨdza rɔ̀, fɨ̀yɔ́ tàmà mà, ndɨrɔ̀ fɨ̀yɔ́ ìkyì-akpá mànà. Kǎdʉ̀ yà fʉ̀rangà-ɔ̌nga nábhʉ rɔ̌ rúbhi kʉwʉ alɛ tɔ́ fʉ̀rangà-ɔ̌nga nʉ́vɔ obvò, ndàdʉ̀ abádhí tɔ́ mɨzà nátdi ràwà ɨ̀ adzíya dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ndɨrɔ̀, kǎdʉ̀ àtɨ̀nà àmbò nábhʉ rɔ̌ rúbhi kudzǐ alɛ nɨ̌: «Nyìpfo kɔ̌kɔ̀ dhu ɨrɔ́ rɔ̀. Ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ Àbadu bhà ɨdza nʉ́gɛ̀rɛ̀ ròngò dhu t’údzítá-ɨdzà tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà ábhàlɨ̌ náadʉ̀ yà Kàgàwà bhà Andítá ɔ̀ ka kandí dhu nɨ́rɛ̀. Ndɨ andítá rǎtɨna: «Pbʉ̀kʉ̀ ɨdza ma mózè nɨ̌ àzè náarɨ́ mɔbɨ àdzò bhěyi.» ");
INSERT INTO niy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nɨ́ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Ɨ́ngbǎgà wɨwɨ̀ nyɨ nyávǐna fǎkà wɔ̀ nyɨ nyɔ̀nzɨ̀ dhu-okú dɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyùgolo pɛ́ wɔ̀rɨ́ Kàgàwà bhà ɨdza, nɨ́ ma mɨ́ kɔ̀sɨ̀ rìdè ɨ̀bhʉ ɨdhɔ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nɨ́, kɔ̀rɨ́ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ àtɨ̀nà Yěsù nɨ̌: «Hɔ̀kɔ̀! Wɔ̀rɨ́ ɨdza ka kasɨ̀ ràrà àhʉ ɨ̀fɔ kumì dɔ̀ná azà nà atɔ nyʉ́ tɨ́, nɨ́ nyɨ tɨ́ àdʉ̀ kɔ̀sɨ̀ ɔ̀sɨ̀ ɨ̀bhʉ ɨdhɔ ɔ̌?» ");
INSERT INTO niy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pbɛ́tʉ̀, Yěsù ɨpbɛ́ ndàmbɛ àtɨ̀nà dɔ̌ ɨdza tɨ́ dhu nɨ’ɨ̀ ngbɔ̌na nyʉ́ ndɨ̀ ndɨ̀tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nɨ́, yà ndɨ̀ ndɔ́vɛ̀, kɔtdʉ̀ ndɨ̀ dhu-dzidɔ̌, Yěsù níitdègu ndɨ̀ngbɛ̀ ibhu ɔ̀ rɔ̀, nɨ́rɔ̀ nɨ́ ndɨ kàbhà ábhàlɨ̌ náadʉ̀ yà kʉ̌nɔ dhu nɨ́rɛ̀. Nɨ́ abádhí adʉ̀ yà Kàgàwà bhà Andítá mà, Yěsù ʉnɔ fɨ̌yɔ̀ ɔtɛ mànà dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ níitdègu Yěsù òtù Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀, nɨ́ ábhɔ̌ alɛ nyʉ́ náa’u ka yà kà rǎrà ɔ̀nzɨ̀nà rɔ̌ wɨwɨ̀-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pbɛ́tʉ̀, Yěsù nyʉ́ ndɨ̀tɨ́rɔ̀ náa’u nzá ɨwà abádhí ná’ù ndɨ dhu, kʉ̌nɨ abádhí kɔ́rɔ́ nɨ́dhùnɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndɨrɔ̀, kǎránà mbǎ ɨ̀’ɨ̀ rɔ̌ ngàmbì-atdyú nà ìndrǔ bhà dhu-okú dɔ̀ rɔ̀, ɨ̀wà ndɨ̀ ndʉ̀nɨ ndɨ alɛ-afí ɔ̀ dhu kɔ́rɔ́ angyangyɨ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nɨ̀kɔ̀dɛmʉ̀ tɨ́ kátɨna atdí alɛ nɨ́ɨ’ɨ̀ Pbàfàrìsáyó nzínzì ɔ̌. Ndɨ alɛ nɨ’ɨ̀ Pbàyàhúdí tɔ́ atdí ádrʉ̀ngbǎlɛ. ");
INSERT INTO niy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nɨ́ atdíku, kɨ̌và ndɨ̀ ndɨ̀rà àhʉ kúbhingánǎ Yěsù-tɨ’ɔ̀, ndàdʉ̀ àtɨ̀nà kànɨ̌: «Màlimǒ, mǎ mʉ́nɨ wà dhu nyɨ ràrɨ̌ Kàgàwà ívì rɨ̀rà dhu ùdhe fǎkà alɛ. Obhó tɨ́, atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ kɔ̌kɔ̀ nyɨ nyarɔ́nzɨna wɨwɨ̀-tɨdɔ̀ nɔ́nzɨ̀ ɨ̀mbǎ Kàgàwà ɨ̀’ɨ̀ atdíkpá ndɨ̀ nà rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀. Atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ òtsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀ ɨnzá ka kʉ̀gʉ̀ ndɨ̀ ɔwʉ́tána tɔ́ ʉgʉta nɨ̌ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nɨ́, Nɨ̀kɔ̀dɛmʉ̀ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Ɨwà óngò mʉ̀là tɨ́ alɛ nʉ́gʉ̀ ka kádʉ̀ ɨ̀ngbà dhu bhěyi tdɨ́tdɔ̌? Ndɨ alɛ tɨ́ àdʉ̀ ndàdu tdɨ́tdɔ̌ ɨ́yànà-fɨtsʉ̀ ɔ̀, kadʉ̀ ndʉ̀gʉ̀ ɔyɔ rɨ́ kìsě ʉgʉta nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nɨ́ Yěsù adʉ̀ dhu àdu Nɨ̀kɔ̀dɛmʉ̀ tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀: ɨ̀nzɨ̌ ndɨ alɛ náapɛ́ ndàbhʉ̌ kʉgʉ̀ ndɨ̀ ɨdha mà Ɨ̀lɨ̌lǎ-Alafí mànà-otù ɔ̌, nɨ́ ndɨ alɛ rɨ̌ nzɨ̌ àdʉ̀ òtsù ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ìndrǔ ɔ̀dhɨ arɨ́ ngbɔ̌na ɔ̀nǎ rɔ̀ nɨ́ ìndrǔ. Ndɨrɔ̀ ìndrǔ ɔ̀dhɨ arɨ́ afína ɔ̀nǎ rɔ̀ nɨ́ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí. ");
INSERT INTO niy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nɨ́, dhu àkǎ nzá ɨdhɔ rʉ̀kɔ nyɨ yà ma mátɨna dhu ràkǎ kʉgʉ̀ nyɨ̌ ɔwʉ́tána tɔ́ ʉgʉta nɨ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Awɛ náarópili, ndàmbɛ àrà dɔ̌ afína òzè ɨ, nyadʉ̀ àmbɛ tǔna nɨ́rɨ̀ dɔ̌. Pbɛ́tʉ̀, nyɨ nyɨ́ nzɨ̌ àdʉ̀ àdhà rɔ̀ màtɨ́ ka rɨ̌rà dhu, ndɨrɔ̀ àdhà màtɨ́ kà rǎrà dhu nʉ́nɨ. Nɨ́ ndɨ dhu rɨ̌’ɨ̀ ndɨ dhu bhěyi tɨ́, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí-otù ɔ̌ ndɨ̀ nʉ́gʉ̀ alɛ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nɨ́, Nɨ̀kɔ̀dɛmʉ̀ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Wɔ̀rɨ́ dhu rǎdʉ̀ ndɔ̀nzɨ̀ ɨ̀ngbà dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨnyɨ nɨ́ atdídɔ̌ ndɨ̀ nʉ́nɨ Pbàìsràyélí tɔ́ pbìrì ɔ̌ màlimò nyʉ́, nɨ́ nyɨ nyʉ́nɨ tɨ́ ɨnzá wɔ̀ dhu? ");
INSERT INTO niy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ma mɨ́ obhó dhu nʉnɔ ɨndʉ̀. Mǎ marʉ́nɔna dhu nɨ́ ʉ̀nɨ̌ mǎ mʉ́nɨ dhu. Ndɨrɔ̀ mǎ maróko fɨ̀ndá ngàmbì tɨ́ dhu nɨ́ nyɨ̀kpɔ́ka nɨ̌ mǎ mála dhu, pbɛ́tʉ̀ nyɨ̌ nyárɨ́ nzɨ̌ àdʉ̀ mǎ mʉ́nɔna dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yà ɨ̀nzɨ̌ nyɨ̌ nyárɨ́ fʉ̌kʉ̀ ma mʉ́nɔna yà adzɨ dɔ̌ arɨ́ ’ɔ̀nzɨ dhu ná’u rɔ̀, nɨ́ nyɨ̌ nyádʉ̀ fʉ̌kʉ̀ ma mʉ́nɔna ɔ̀rʉ̀-akpà ɔ̀ arɨ́ ’ɔ̀nzɨ dhu ná’ù ɨ̀ngbà dhu bhěyi? ");
INSERT INTO niy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atdí alɛ mà núpò nzá ányɨ̀. Pbɛ́tʉ̀ ányɨ̀ úpò nɨ́ Ìndrǔ t’ídhùnà kɛ̀lɛ̌, yà ányɨ̀rɔ̀ ifo alɛ. ");
INSERT INTO niy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nɨ́ àdhàdhɨ̀ Músà nɨ́ɨdɨ̀ osu-wɔ̀yɔ̌ itsu dɔ̌ rɔ̀ ɔrʉ́ rʉ̀ngʉ̀ ɔ̌ dhu bhěyi, dhu-àkǎ kɨdɨ̀ Ìndrǔ t’ídhùnà ɔrʉ́, ");
INSERT INTO niy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ndɨ́nɨ̌ ka nà’ù ɨ̀ngbà tɨ́ ɨ́lɨ ndɨ̀ alɛ mà náadʉ̀ya tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Obhó tɨ́, Kàgàwà náazè yà adzɨ ɔ̌ alɛ atdídɔ̌. Nɨ́ kǐbho yà atdí tɨ́ arɨ́’ɨ̀ Idhùnà yà adzɨ ɔ̌, ndɨ́nɨ̌ ka nà’ù ɨ̀ngbà tɨ́ ɨ́lɨ ndɨ̀ alɛ mà náadʉ̀ya tɨ́ nzɨ̌ àwǐ, pbɛ́tʉ̀ ndɨ alɛ adʉ̀ya tɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Obhó tɨ́, Kàgàwà níivi nzá Idhùnà rɨ̀rà yà adzɨ ɔ̌ alɛ-ànyǎ nɨ́tdɨ̀, pbɛ́tʉ̀ kǐvi ka rɨ̀rà ndɨ́nɨ̌ yà adzɨ ɔ̌ alɛ nʉ́ʉgʉ̀ tɨ́ otùna ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ndɨ̀ alɛ náapɛ́ kà’u, nɨ́ ndɨ alɛ dɔ̌ Kàgàwà adʉ̀ya nzɨ̌ anya ɔ̀tdɨ̀. Pbɛ́tʉ̀, ɨnzá ka ná’ù alɛ dɔ̌ kɔ̌tdɨ̀ wà anya angyangyɨ, ɨnzá kǎ’ù Idhùnà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yàrɨ́ nɨ́ ndɨ Kàgàwà nɨ́ɨtdɨ̀ya anya ìndrǔ dɔ̌ okúna dɔ̀ rɔ̀ dhu. Awáwʉ̀ nɨ́ɨra àhʉ yà adzɨ ɔ̌, pbɛ́tʉ̀ ìndrǔ náadʉ̀ ɨ́nɔ̀ ɔ̌ ɨ̀ óko dhu nózè atdídɔ̌, ròsè ndɨ awáwʉ̀ dɔ̀nǎ, nzɛ́rɛ dhu ɔ̀nzɨ ɨ̀ arɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Obhó tɨ́, nzɛ́rɛnga ɔ̀nzɨ arɨ́ alɛ náarɨ́ awáwʉ̀ ɔ̀ndrɔ̀ ɔ̀ndrɔ̀ tɨ́, ɨ̀nzɨ̌ ndàdʉ̀ ndòzè ndàhʉ awáwʉ̀ ɔ̀, akyɛ ndɨ̀ ndarɔ́nzɨna nzɛ́rɛ dhu náadʉ̀na àrà ndàla rɔ̌ kpangba nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pbɛ́tʉ̀, obhó dhu ɔ̀nzɨ arɨ́ alɛ náarɨ́ ndòzè ndùbhi awáwʉ̀ ɔ̌, ndɨ́nɨ̌ ndɨ̀ ndarɔ́nzɨna dhu náala tɨ́ ndɨ̀ Kàgàwà ózè dhu bhěyi ndɨ̀ ndarɔ́nzɨna dhu tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wɔ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà náawù Yùdɛyà tɔ́ pbìrì ɔ̀. Nɨ́ ányɨ̀, abádhí náakò ngúfe ɨdhɔ tɨ́, ’àdʉ̀ òwu bàtizò núbho rɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yùwanɨ̀ náaránà bàtizò núbho rɔ̌ átɔ̀ ìndrǔ tɔ̀ Sàlimù tɨ́ kátɨna pbanga tɨ́ arɨ́’ɨ̀ ngǎtsi pbanga, Àyìnonì tɨ́ kátɨna ɔ̌. Obhó tɨ́, ndɨ pbanga ɔ̌ ɨdha nɨ́ɨ’ɨ̀ abhɔ nyʉ́. Nɨ́ ìndrǔ nóowúnà ìwu rɔ̌ Yùwanɨ̀ rɨ̌’ɨ̀ ɨ, kà ràdʉ̀ bàtizò núbho fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Yùwanɨ̀ nɨ́ɨ’ɨ̀ ɨnzá ka kàpɛ̀ òsòna imbi ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nɨ́rɔ̀ nɨ́ ndɨ Yùwanɨ̀ bhà ábhàlɨ̌ mà atdí Mʉ̀yàhudì mànà náakò ’àmbɛ ’àgò dɔ̌ ìndrǔ rɨ̌ ndù’ǒ ndɨ̀lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌ tɨ́ dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nɨ́, ɨ ábhàlɨ̌ níiwú Yùwanɨ̀-tɨ’ɔ̀, ’àdʉ̀ àtɨ̀nà kànɨ̌: «Màlimǒ, yà Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-adzè nyɨ̌ nyɨ́’ɨ̀ mànà atdíkpá alɛ, yà nyɨ nyʉ́ tɨ́rɔ̀ nyɨ nyɔ́vɔ̀ dhu dɔ̀ná fǎkà alɛ, nɨ́ rɨ̌’ɨ̀ bàtizò ùbhǒ ndɨ̀ ndɨ́ ìndrǔ tɔ̀ rɔ́. Ndɨrɔ̀ kɔ́rɔ́ alɛ rǒwu òwu rɔ̌ kà-tɨ’ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nɨ́ Yùwanɨ̀ adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ìndrǔ rǎdʉ̀ àbànà dhu nɨ́ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ka kìbhò fɨ̌ndà dhu kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyɨ̌ nyʉ́ nyɨ̌-tɨ́rɔ̀, nyɨ̌ nɨ́ yà ma mʉnɔ dhu tɔ́ ngàmbì. Ma mátɨ ɨma ràrɨ̌ nzɨ̌ Krɨ́stɔ̀, pbɛ́tʉ̀ ma ràrɨ̌ Kàgàwà ívì angyinǎ rɔ̌ kà tɔ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Àdhɨ̀ngbǎ-ɔwʉ́tá nà rɨ́’ɨ̀ alɛ nɨ́ ndɨ ndɨ àdhɨ̀ngbǎ bhà alɛ. Pbɛ́tʉ̀ ndɨ kà bhà alɛ t’ɔ́dhɨ̀nà, yà kà-tɨ́ ìdè ndàmbɛ kà rʉ̌nɔna dhu ɨ̀rɨ̀ dɔ̌, nɨ́ɨdhɛ̀ rǎdʉ̀ ndɨ̀ka atdídɔ̌ kà-tù ɨ̀rɨ ndɨ̀ ndɨ́ rɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ, ma mɨ́’ɨ̀ dhɛ̀dhɛ nà, ndɨrɔ̀ ndɨ dhɛ̀dhɛ nákǎ wà atdídɔ̌ nyʉ́ kòmbí. ");
INSERT INTO niy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nɨ́ dhu àkǎ wà Yěsù-ɔvɔ̀ ràmbɛ ndɔ̀tɔ̀ dɔ̌, ɔvɔ̀du ràdʉ̀ àmbɛ àwǐ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wɔ̀ dhu-dzidɔ̌, Yùwanɨ̀ náadʉ̀ dhu-ɔvɔ̀ tdɨ́tdɔ̌, ndàtɨ: «Ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà alɛ nɨ́ ndɨ rɨ́’ɨ̀ kɔ́rɔ́ alɛ dɔ̌. Pbɛ́tʉ̀, yà adzɨ ɔ̌ ka kʉ́gʉ̀ alɛ nɨ́ yà adzɨ ɔ̌ alɛ kɛ̀lɛ̌, ndɨrɔ̀ kà rǎdʉ̀ ɔ̀tɛ yà adzɨ ɔ̌ dhu dɔ̌ tɨ́. Ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà alɛ rɨ̌’ɨ̀ kɔ́rɔ́ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kǎrʉ́nɔna dhu nɨ́ nyɨ̀kpɔ́na nyʉ́ nɨ̌ ndɨ̀ ndála dhu, ndɨrɔ̀ nɨ́ bɨ̌na nyʉ́ nɨ̌ ndɨ̀ ndɨ́rɨ̀ dhu. Pbɛ́tʉ̀, ìndrǔ arɨ́ nzɨ̌ àdʉ̀ kà rʉ̌nɔna dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kà rʉ̌nɔna dhu nà’ù alɛ návi dhu kpangba Kàgàwà ràrɨ̌ obhó dhu ʉ̀nɔ arɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Obhó tɨ́, Kàgàwà ívì alɛ náarɨ́ Kàgàwà bhà ɔtɛ nʉ́nɔ, atdídɔ̌ kɨ̀rǎ ndɨ̀ pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nɨ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kàgàwà ózè Idhùnà atdídɔ̌. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kǎdʉ̀ kɔ́rɔ́ dhu tɔ́ ádrʉ̀ngbǎnga nábhʉ kà-fɔ́. ");
INSERT INTO niy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kàgàwà t’ídhùnà nà’ù alɛ, nɨ́ rǎdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. Pbɛ́tʉ̀, ndɨ̀ nùvǒ ɨ̀nzɨ̌ ndɨ̀rɨ̀ kà t’Ídhùnà-tsʉ̌ dhu alɛ, náabáya nzɨ̌ dhòdhódhónga tɔ́ ípìrɔ̌nga, pbɛ́tʉ̀ Kàgàwà bhà nàwí rǒngo àdɨ dhòdhódhónganà ndɨ alɛ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Yùdɛyà tɔ́ pbìrì ɔ̌ Pbàfàrìsáyó nɨ́ɨrɨ ìndrǔ rʉ̌nɔna Yěsù dɔ̌ dhu. Abádhí ambɛ́nà àtɨ̀nà dɔ̌, Yěsù ràrɨ̌ àrà ibí alɛ nyʉ́ nʉ́gɛ̀rɛ̀ rɔ̌ ròngò pbɨ̀ndà ábhàlɨ̌ tɨ́, ndàdʉ̀ àrà bàtizò núbho rɔ̌ ábhɔ̌ alɛ nyʉ́ tɔ̀, ròsè yà Yùwanɨ̀ arɨ́ kɔ̀nzɨ tɨ́ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pbɛ́tʉ̀, Yěsù nyʉ́ ndɨ̀tɨ́rɔ̀ náaránà nzɨ̌ bàtizò núbho rɔ̌ ìndrǔ tɔ̀, kùbho rɔ̌ owúnà nɨ́ kàbhà ábhàlɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nɨ́, Yěsù adʉ̀ ndɨ̀và Yùdɛyà tɔ́ pbìrì ɔ̀ rɔ̀, ndàdu ndɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nɨ́ ányɨ̀ ndɨ̀ ndárà rɔ̀, kǎká ndʉ̀dà Sàmàrɨyà tɔ́ pbìrì ɔ̀na nǎ. ");
INSERT INTO niy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nɨ́ kǎrà àhʉ Sàmàrɨyà tɔ́ pbìrì ɔ̌ atdí pbanga, Sìkarì tɨ́ kátɨna ɔ̀. Ndɨ pbanga nɨ́ɨ’ɨ̀ kyɛ̀rɔ̀kyɛ̀rɔ̀ yà idhùnà Yɔ̀zɛfʉ̀ tɔ̀ Yàkɔbhɔ̀ náabhʉ̀ adzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ndɨrɔ̀, Yàkɔbhɔ̀ bhà dzɨ̀wɔ̀ nɨ́ɨ’ɨ̀ ányɨ̀rɔ̌. Nɨ́, Yěsù itsi àdɨ wɔ̀rɨ́ dzɨ̀wɔ̀-bɨdɔ̌ atdídɔ̌ ndɨ̀ ndɨ̀ngyɛ̌ ndɨ̀ abhi nɨ̌ dhu-okú dɔ̀ rɔ̀. Ndɨ dhu nɨ’ɨ̀ mbɛ̀mbɛ̀ azà adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nɨ́, Sàmàrɨyà tɔ́ pbìrì ɔ̌ atdí tsìbhálɛ nɨ́ɨra ɨdha nítdyò. Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Íbho pɛ́ ɨdha mɔmvʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Yěsù bhà ábhàlɨ̌ náadʉ̀ ɨ̀’ɨ̀ kɨgɔ̀ ɔ̀ ɨ̀ òwù ɔ̀nyʉ̀ núdzi ndɨ́nɨ̌ ɨ̀ ɔnyʉ tɨ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nɨ́, wɔ̀ Sàmàrɨyà tɔ́ pbìrì ɔ̌ tsìbhálɛ náadʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Hɔ̀kɔ̀! Ɨ́ngbà dhu bhěyi dhu, ɨnyɨ Mʉ̀yàhudì tɨ́ rɔ̀, nyɨ nyɨ́ ɨ̀dha nónzi fudú ndɨ́nɨ̌ nyɨ nyɔmvʉ́ tɨ́, àzèmbè ɨma nongó ɨ̀’ɨ̀ Mʉ̀sàmàrɨyà-àyi?» Obhó tɨ́, ɨrɨta nɨ́ɨ’ɨ̀ ɨ̀mbǎ Pbàyàhúdí mà nzínzì ɔ̌ Sàmàrɨyà ɔ̌ bhà mànà. ");
INSERT INTO niy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀ ndàtɨ: «Nyɨ nyɨ́’ɨ̀ná gukyè Kàgàwà arábhʉ̌na ìndrǔ tɔ̀ dhu nʉ́nɨ alɛ tɨ́, nyadʉ̀ yà fʉnʉ́ rɨ́ ɨdha nónzi ndɔ̀mvʉ̀ alɛ ràrɨ̌ àdhɨ dhu nʉ́nɨ, nɨ́ nyɨ nyàmbɛ̀nà ndɨ ɨdha nónzi kà-fɔ́, kà ràdʉ̀ ípìrɔ̌nga àbhʉ̌ rɨ́ ìndrǔ tɔ̀ ɨdha nábhʉ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nɨ́ wɔ̀ tsìbhálɛ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨdha ìtdyò nyɨ nyádʉ̀ nɨ̌ ngɛmɛkʉ̀ mà rɨ̌’ɨ̀ mbǎ fʉnʉ́, ndɨrɔ̀ yàrɨ́ dzɨ̀wɔ̀ rɨ̌’ɨ̀ ádzǐ nyʉ́. Nɨ́ nyɨ nyɨ́ wɔ̀ ndɨ ípìrɔ̌nga àbhʉ̌ rɨ́ ɨdha nábà àdhà? ");
INSERT INTO niy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Abhukà Yàkɔbhɔ̀ nɨ́ ndɨ yàrɨ́ dzɨ̀wɔ̀ nʉbhà fǎkà. Ka nyʉ́ ndɨ̀tɨ́rɔ̀, kàbhà inzo mà, kà bhà mʉ̀tʉngà mànà, nʉ́ʉmvʉ́ kà ɔ̌ ɨdha átɔ̀. Nɨ́ ɨnyɨ, nyɨ tɨ́ ndɨ adrʉ̀ngbǎlɛ ròsè ndɨ abhukà Yàkɔbhɔ̀ dɔ̀nǎ?» ");
INSERT INTO niy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nɨ́ Yěsù àdʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà yàrɨ́ dzɨ̀wɔ̀ ɔ̌ ɨdha nɔ̀mvʉ̀, nóhò ɨdha-atdyú rǎdʉ̀ òho tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pbɛ́tʉ̀, yà ɨma nyʉ́ ma mábhʉ̌na ɨdha nɔ́mvʉ̀ rɨ́ alɛ, nóhò ɨdha-atdyú rɨ̌ nzɨ̌ àdʉ̀ tdɨ́tdɔ̌ akɛkpá màtɨ́. Obhó tɨ́, ma mábhʉ̌na ndɨ alɛ tɔ̀ ɨdha rǎdʉ̀ òngo dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ rɨ́ ìndrǔ tɔ̀ ɨdha rǒngo ɨ̀tʉ ɔ̀nà rɔ̀ ɨdha-dɔ̀tɨ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nɨ́ wɔ̀ tsìbhálɛ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, íbhò wɔ̀rɨ́ ɨdha idù, ɨ̀nzɨ̌ ɨdha-atdyú nóongó tɨ́ mohò, ndɨrɔ̀ ɨ̀nzɨ̌ ma mongó tɨ́ ɨ̀rà ɨdha nítdyò ɨrɔ́ tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Árà nyanzi pbʉ̀kʉ̀ kpatsìbhálɛ, nyǎdʉ̀ ìwu mànà ɨrɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nɨ́ wɔ̀ tsìbhálɛ adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ɨ̀mbǎ ma mɨ́’ɨ̀ kpatsìbhálɛ nà.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Nyɨ nyàdu dhu mběyi nyʉ́ nyatɨ, ɨ̀mbǎ nyɨ ràrɨ̌’ɨ̀ kpatsìbhálɛ nà. ");
INSERT INTO niy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Obhó tɨ́, nyɨ nyʉ́mbǎ nyɨ imbò kpabhálɛ nyʉ́ tɔ̀. Nɨ́, yà kombí nyɨ̌ nyɨ́’ɨ̀ nà kpatsìbhálɛ nɨ́ nzɨ̌ pbʉ̀kʉ̀ alɛ. Nɨ́, wɔ̀ nyɨ nyʉ̀nɔ̀ dhu nɨ́ obhó dhu nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nɨ́, wɔ̀ tsìbhálɛ adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨwà ma mʉ̀nɨ dhu nyɨ ràrɨ̌ Kàgàwà bhà nabì nyʉ́. ");
INSERT INTO niy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Abhúka nóongónà Kàgàwà nʉ́lɛ yàrɨ́ pbìrì dɔ̌ rɔ̀, pbɛ́tʉ̀ nyɨ̌ Pbàyàhúdí-tɨ́rɔ̀, nyɨ̌ nyarádʉ̀ àtɨ̀nà, Yèrùsalɛmà tɔ́ kɨgɔ̀ ràrɨ̌ ndɨ Kàgàwà nʉ́lɛ ka kádʉ̀ òwu ɔ̀nà rɔ̀ kɨgɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Yàrɨ́ tsìbhálɛ́, á’u yà ma mʉ́nɔna ɨndʉ̀ dhu. Atdí kàsʉmɨ̀ nɨ́ɨ’ɨya ìnè, yà ɨ̀nzɨ̌ nyɨ̌ nyʉlɛ́ya àlɛ̌ t’Ábanà Kàgàwà yàrɨ́ pbìrì dɔ̌ rɔ̀ màtɨ́, ndɨrɔ̀ Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̌ rɔ̀ màtɨ́ ɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyɨ̌, Sàmàrɨyà tɔ́ pbìrì ɔ̌ bhà tɨ́rɔ̀, nyɨ̌ nyárɨ́ Kàgàwà nʉ́lɛ̌ ɨnzá nyɨ nyʉ́nɨ mbɛ̌yi rɔ́rɔ̀. Pbɛ́tʉ̀ mǎ, Pbàyàhúdí tɨ́rɔ̀, mǎ márɨ́ kʉ̀lɛ̌ ɨwà mǎ mʉ́nɨ mbɛ̌yi nyʉ́ rɔ́rɔ̀. Obhó tɨ́, Kàgàwà rǐbhona ìndrǔ tɔ̀ ɔ̀gʉ̀ rǎhʉ Pbàyàhúdí nzínzì-bvʉ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pbɛ́tʉ̀, kàsʉmɨ̀ níndù wà ndɨ̀, ndɨrɔ̀ ndɨ kàsʉmɨ̀ nákǎ wà. Wɔ̀ ndɨ kàsʉmɨ̀ nɨ́, yà Kàgàwà-nyɨ̀kpɔ́ nɔ̀fɔ̀ dhu bhěyi arɨ́ Kàgàwà ʉ̀lɛ̌ alɛ rɨ̌ ’ɔ̀pɛ̀ ’ʉ̀lɛ̌ ka afíya ɔ̀, ndɨrɔ̀ obhónga nyʉ́ dɔ̌ ɔ̀ná kàsʉmɨ̀. Obhó tɨ́, àlɛ̌ t’Ábanà Kàgàwà arɔ́nɛna nɨ́ ndɨ dhu bhěyi rɨ́ ndʉ̀lɛ̌ alɛ-tɨdɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kàgàwà nɨ́ Alafí. Nɨ́ dhu àkǎ kʉ̀lɛ̌ rɨ́ alɛ rʉ̀lɛ̌ ka afíya ɔ̀, ndɨrɔ̀ obhónga nyʉ́ dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nɨ́ wɔ̀ tsìbhálɛ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ma mʉ̀nɨ wà dhu Màsiyà, Krɨ́stɔ̀ tɨ́ kátɨna alɛ rɨraya ɨ̀rà. Nɨ́, kà rɨ̌rà nɨ́nganɨ́, kǎwɛya kɔ́rɔ́ dhu fǎkà.» ");
INSERT INTO niy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nɨ́ Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ɨma nɨ́ ndɨ Krɨ́stɔ̀, yà ɨnyɨ nà ma mɔ́tɛ.» ");
INSERT INTO niy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, Yěsù bhà ábhàlɨ̌ náadʉ̀ ’ʉ̀tɔ̀ ányɨ̀rɔ̌. Nɨ́ ɨdhɔ nʉ́ʉkɔ abádhí atdídɔ̌, ɨ̀ àla Yěsù mà rɔ̌tɛ atdí tsìbhálɛ nà dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, atdí alɛ mà abádhí nzínzì ɔ̌ náadʉ̀ nzá ndòmvù ndìvǔ dhu Yěsù-tsʉ̌, ràrɨ̌ àdhu Yěsù rɨ̌’ɨ̀ atdyúna nà, ndɨrɔ̀ ràrɨ̌ àdhu abádhí rɔ̌tɛ dɔ̀ná wɔ̀rɨ́ tsìbhálɛ mànà. ");
INSERT INTO niy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nɨ́rɔ̀ nɨ́ ndɨ wɔ̀ tsìbhálɛ nʉ́ʉbhà fɔná ɨdha-andù ʉrɔ́, ndàdʉ̀ òngo ndàrà kɨgɔ̀ ɔ̀. Kǎdʉ̀ àtɨ̀nà ányɨ̀ ndɨ̀ ndòtù alɛ nɨ̌: ");
INSERT INTO niy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Nyìwǔ nyàndà pɛ́ yà kɔ́rɔ́ ma marɔ́nzɨna dhu nàwɛ idù alɛ! Ngǎtsi nɨ̌, pbǎ ɨ̀nzɨ̌ Krɨ́stɔ̀ ndɨ.» ");
INSERT INTO niy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɨ́ kɔ̀rɨ́ alɛ náadʉ̀ ’ɨ̀và, ’òwù Yěsù rɨ̌’ɨ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, pbɨ̀ndà ábhàlɨ̌ nʉ́ʉtʉ Yěsù ’àtɨ: «Màlimǒ, ɔ́nyʉ dhu akɛ.» ");
INSERT INTO niy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ma mɨ́’ɨ̀ ìnè ma mɔ́nyʉna ɔ̀nyʉ̀ nà. Ndɨ ɔ̀nyʉ̀ nɨ́ ɨnzá nyɨ̌ nyʉ̀nɨ ɔ̀nyʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nɨ́ ɨ ábhàlɨ̌ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌ ’àmbɛ àtɨ̀nà dɔ̌: «Atdí alɛ mà nɨ́rà tɨ́ ɨ̀rà ɔ̀nyʉ̀ nà kàtɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Pbàkà ɔ̀nyʉ̀ nɨ́ mɔnzɨ̀ yà ma nívì alɛ-afí òzè dhu, madʉ̀ yà kǐbhò ndɨ́nɨ̌ ma mɔnzɨ tɨ́ kasʉ nɔ́nzɨ̀ mɨtɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tɨ́ obhó nyɨ̌ ndɨ nyɨ̌ nyarɨ́ àtɨna: ‹Ɨnga ɔ̌ rɔ́’ɔ̀ ɔ̀nyʉ̀ nógu ka kɨ́ ɔ̀ná àbǐ nʉ́bhà ndɨ̀ ɨ̀fɔ àbǐ tɨ́.› Pbɛ́tʉ̀ ɨma, ma mátɨna nyɨ̌ nɨ̌, nyɨ̌ ràngbɛ pɛ́ dʉ̀kʉ nyǎndà ɨnga. Ɔ̀nyʉ̀ nɔ́’ɔ̀ wà ɨnga ɔ̌, ndɨrɔ̀ kàkǎ wà oguta nà! ");
INSERT INTO niy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɔ̀nyʉ̀-tsʉ̀ nùndu ɨnga ɔ̌ rɔ̀ alɛ náarɨ́ pbɨ̀ndà mʉ̀kɨ̀mbà nábà. Ndɨrɔ̀ kǎrɨ́ ɔ̀nyʉ̀-tsʉ̀ núndǔ dhòdhódhónga tɔ́ ípìrɔ̌nga tɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ, yà ɔ̀nyʉ̀-tsè nazò ɨnga ɔ̌ alɛ mà, kà-tsʉ̀ núndu adʉ̀ ɨnga ɔ̌ rɔ̀ alɛ mànà-ɨdhɛ̀ rǎdʉ̀ ndɨ̀ka atdíkpá. ");
INSERT INTO niy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Obhó tɨ́, yàrɨ́ mbólí nʉ́nɔ̀ dhu nɨ́ obhó dhu nyʉ́: ‹Atdí alɛ náarɨ́ ɔ̀nyʉ̀-tsè nózò ɨnga ɔ̌, ngǎtsi alɛ ràdʉ̀ ndɨ ɔ̀nyʉ̀ nógù ɨnga ɔ̌ rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɨ́ ɨma, ma móvì nyɨ̌ nyǒwù ɔ̀nyʉ̀ ògù ɨnzá nyɨ̌ nyazò dhu ɔ̀ná ɨnga ɔ̌. Ngʉ̌kpà alɛ náanzɨ̀ ndɨ kasʉ kà ɔ̌ angyinǎ rɔ̀, nyǎdʉ̀ ídzìnga nábà abádhí tɔ́ kasʉ-nyʉ-tsì.» ");
INSERT INTO niy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nɨ́, wɔ̀rɨ́ kɨgɔ̀ ɔ̌ aróko Sàmàrɨyà ɔ̌ ábhɔ̌ alɛ nyʉ́ náa’u Yěsù, wɔ̀rɨ́ tsìbhálɛ náwɛnà fɨ̌yɔ̀ dhu-okú dɔ̀ rɔ̀. Kǎtɨ: «Kàwɛ ma mɔ́nzɨ̀ dhu kɔ́rɔ́ idù.» ");
INSERT INTO niy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nɨ́, Sàmàrɨyà ɔ̌ alɛ níitdègu ìwu ùvò Yěsù-tɨ’ɔ̀, nɨ́ abádhí adʉ̀ kònzì ndɨ́nɨ̌ adɨ̀ tɨ́ ɨ̀ mànà fɨ̀rábvʉ̌. Nɨ́ Yěsù mà náadʉ̀ òko abádhí mànà ɔ́yɔ̌ ɨdhɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nɨ́, ábhɔ̌ ngʉ̌kpà alɛ nyʉ́ náadʉ̀ Yěsù ná’ù, yà kà rʉ̌nɔna ndɨ̀ nyʉ́ tɨ́rɔ̀ ɔtɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Abádhí owúnà àtɨ̀nà rɔ̌ wɔ̀ tsìbhálɛ nɨ̌: «Mǎ mà’ù Yěsù, ɨ̀nzɨ̌ nɨ́ nyɨ nyʉ̀nɔ̀ dhu-okú dɔ̀ rɔ̀ tɨ́, pbɛ́tʉ̀ mǎ mà’ù ka yà bɨ̌ka nyʉ́ nɨ̌ mǎ mɨ̀rɨ̀ kà rʉ̌nɔna dhu dhu-okú dɔ̀ rɔ̀. Ndɨrɔ̀, mǎ mʉ̀nɨ wà dhu ka nyʉ́ ràrɨ̌ ndɨ yà adzɨ ɔ̌ alɛ tɔ́ Ɔ̀gʉ̀ba.» ");
INSERT INTO niy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ɔ́yɔ̌ ɨdhɔ ndɨ̀ ndɔ̀nzɨ̀ Sàmàrɨyà dhu-dzidɔ̌, Yěsù ɨvà ndɨ̀ ndàrà Gàlìlayà. ");
INSERT INTO niy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Obhó tɨ́, ka nɨ’ɨ̀ ɨwà átɨ ndɨ̀ nyʉ́ tɨ́rɔ̀, ɨ̀nzɨ̌ ka rarɨ́ nabì nɨ́fʉ̌ pbɨ̀ndà pbìrì nyʉ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pbɛ́tʉ̀, Gàlìlayà tɔ́ pbìrì ɔ̀ Yěsù àrà àhʉ rɔ̀, ányɨ̀ bhà náakɔ̀ ka mběyi nyʉ́, ɨwà ɨ̀ awù átɔ̀ Yèrùsalɛmà, Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ ɔ̌, ’àdʉ̀ kà rɔ̌nzɨna kɔ́rɔ́ dhu àla nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àrà tdɨ́tdɔ̌ Kanà tɨ́ kátɨna atdí pbanga ɔ̀, Gàlìlayà tɔ́ pbìrì ɔ̀. Ndɨ pbanga nɨ́ ndɨ kʉ̌gɛ̀rɛ̀ ɨdha ròngò dɨ̀vayì tɨ́ ɔ̀ná. Gàlìlayà, Kàpɛ̀rnàwumù tɨ́ kátɨna pbanga ɔ̌, àlɨ̀tá bhà kasʉ tɔ́ atdí ádrʉ̀ngbǎlɛ nɨ́ɨ’ɨ̀ ìnè. Ndɨ alɛ t’ídhùnà nɨ́ɨ’ɨ̀ andɨ nà. ");
INSERT INTO niy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nɨ́, Yěsù ɨ̀rà Yùdɛyà rɔ̀ ndɨ̀rà àhʉ Gàlìlayà dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, wɔ̀ ádrʉ̀ngbǎlɛ náarà Yěsù-tɨ’ɔ̀. Kǎdʉ̀ ndɨ̀tsɔ̀ Yěsù rɔ̌ ndɨ́nɨ̌ awú tɨ́, ndàrà idhùnà nɨ́gʉ Kàpɛ̀rnàwumù. Ndɨ kà t’ídhùnà nɨ́ɨ’ɨ̀ afína rɔ̌ ka kɔ́dɔna rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Nyɨ̌ nyɨ́ nzɨ̌ dhu à’u, ɨnzá nyɨ̌ nyàla wɨwɨ̀ mà, ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ nzínzì ɔ̌ dhu mànà dhu rɔ̀!» ");
INSERT INTO niy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nɨ́ wɔ̀ ádrʉ̀ngbǎlɛ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɨ́rà nyawú pbàkà ɨnzá pbàkà ɨngba-afí nápɛ̀ ɨ̀tdɛ̌ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Árà ɨbha! Ìnè idhùnʉ rɨ̌’ɨ̀ nyɨ̀kpɔ́na nà.» Nɨ́ wɔ̀ ádrʉ̀ngbǎlɛ náa’u Yěsù ʉ̀nɔ̀ fɨ̌ndà dhu, ndàdʉ̀ ndɨ̀và, ndàrà. ");
INSERT INTO niy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɨ́ ɨbha ndɨ̀ ndóngo rɔ́rɔ̀, abádhí núusò ɨ̀ otu ɔ̌ pbɨ̀ndà kasʉtálɛ mànà, ɨ alɛ ràdʉ̀ àtɨ̀nà ɨwà kà t’ídhùnà rɔ̀gʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɨ́ wɔ̀ alɛ adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Kɔ̌gʉ̀ná ìfe adyifɔ̀-sɨsɨ̀ ɔ̌?» Nɨ́, abádhí adʉ̀ dhu àdu kàtɔ̀ ’àtɨ: «Kɔ̌gʉ̀ná inzì, àrʉ̀bhʉ̀ adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nɨ́ wɔ̀ ngbángba t’ábanà adʉ̀ dhu ɔ̀sʉ̀ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́ Yěsù rátɨná ndɨ̀ nɨ̌: ɨwà pbɨ̀ndà ɨngba rɔ̀gʉ̀. Nɨ́ àbadhi mà, kɔ́rɔ́ pbɨ̀ndà ɨdzá-bhà mànà náadʉ̀ Yěsù ná’ù atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wɔ̀ dhu bhěyi nɨ́ ndɨ, Yěsù anzɨ̀ ɔyɔ rɨ́ kìsě pbɨ̀ndà wɨwɨ̀, Yùdɛyà rɔ̀ ndɨ̀ ndɨ̀rà àhʉ Gàlìlayà rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wɔ̀ dhu-dzidɔ̌, yà Pbàyàhúdí rɨ̌ fɨ̀yɔ́ sɔmà tɔ́ atdí mʉ̀hɛndʉ̀ nɔ́nzɨ ɔ̀ná kàsʉmɨ̀ ɔ̌, Yěsù ɨvà ndɨ̀ ndàrà Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ndɨ kɨgɔ̀ ɔ̀ ka kótsù ɔ̀ná atdí tsǎtsʉ̀-ɔvɔ̀ nɨ’ɨ̀ «Tàmà tɔ́ Tsǎtsʉ̀.» Nɨ́, ùye ka kúyè ɨdha nɨ́ɨ’ɨ̀ ndɨ tsǎtsʉ̀ tɨ́. Pbàyàhúdí t’ávàna ɔ̌, ndɨ ɨdha-ɔvɔ̀ nɨ’ɨ̀ Bɛ̀tɛ̀sàyidà. Ndɨrɔ̀, kǐgì rɔ̌ ka kasɨ̀ imbò mbàrazà. ");
INSERT INTO niy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nɨ́, dhèdhèrɔ̀ andɨ-tɨdɔ̀ nà alɛ nóongónà òyì ɨ mbàrazà tsìnǎ. Ɨ alɛ nɨ’ɨ̀ ndùmùndúmú mà, òtsótsù alɛ mà, ndɨrɔ̀ ngbɔ̌ya ʉ́vɛ alɛ mànà.  ");
INSERT INTO niy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nɨ́, abádhí ongónà òyì ányɨ̀rɔ̌, ’àmbɛ Kàgàwà bhà màlàyikà rɨ̌ ndɨ ɨdha-ɔ̌nga nángbǒ dhu ɔ̀dɔ̀ dɔ̌. Obhó tɨ́, atdí kàsʉmɨ̀ ɔ̌, Kàgàwà bhà màlàyikà nóongónà ìfo ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndòtsù ndɨ ɨdha ɔ̀, ndàdʉ̀ ɔ̀nánga àngbo. Nɨ́, wɛmbɛrɛ̀ tɨ́ òtsù ndɨ ɨdha ɔ̀ alɛ nóongónà àdʉ̀ ɔ̀gʉ̀ dòtsí pbɨ̀ndà andɨ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nɨ́, ányɨ̀rɔ̌ ɨ’ɨ̀ atdí alɛ nɨ’ɨ̀ ɨwà andɨ alʉ́ ndɨ̀ rɔ́ atɔ árà àhʉ ɨ̀bhʉ kumì dɔ̀ná àrʉ̀ nà atɔ tɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nɨ́, wɔ̀ alɛ ndɨ̀ ndàla àyǎyi rɔ́, ndàdʉ̀ dhu ʉ̀nɨ ɨwà ka rɔ́nzɨ̀ ábhɔ̌ ɨdhɔ nyʉ́ andɨ nà rɔ̀, Yěsù ivú dhu kà-tsʉ̌, ndàtɨ: «Nyɨ nyòzè tɨ́ ɨwà nyɔgʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nɨ́ wɔ̀ alɛ adʉ̀ dhu àdu Yěsù tɔ̀ ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨdha-ɔ̌nga màlàyikà àngbǒ rɔ̀, ma marɨ́ mbǎ àdʉ̀ ɨ̀’ɨ̀ mitdu rɨ́, ndàfɔ̌ ma ndɨ ɨdha ɔ̀ alɛ nà. Ndɨrɔ̀, yà ma mɨ́ momvù ndɨ́nɨ̌ ma mofo tɨ́ ɨdha ɔ̀ rɔ̀, ngǎtsi alɛ kɛ̀lɛ̌ náarádʉ̀ òfo angyi rùdú ndɨ ɨdha ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nɨ́ Yěsù adʉ̀ àtɨ̀nà wɔ̀ alɛ nɨ̌: «Ɨ́và nyɨ, nyitdù ɨndʉ́ ara, nyadʉ̀ àrà.» ");
INSERT INTO niy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, wɔ̀ alɛ náagʉ̀, ndàdʉ̀ pbɨ̀ndà ara nítdù ndàrà nà. Wɔ̀ dhu rɨ̌ ndɔ̀nzɨ ɔ̀ná ɨdhɔ nɨ’ɨ̀ sàbatʉ̀-ɨdhɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nɨ́ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ àtɨ̀nà wɔ̀ ɔ̀gɔ̀gʉ̀ alɛ nɨ̌: «Indo rɨ́’ɨ̀ nɨ́ sàbatʉ̀-ɨdhɔ̀! Nɨ́ dhu àkǎ nzá nyanɔ̀ pbʉ̀kʉ̀ ara nyambɛ ùbhi dɔ̌ nà.» ");
INSERT INTO niy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nɨ́, wɔ̀ alɛ adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Ɨma nɨ̀gʉ̌ alɛ nɨ́ ndɨ àtɨ ɨma nɨ̌, ma rìtdu pbàkà ara, madʉ̀ àrà nà.» ");
INSERT INTO niy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nɨ́ kɔ̌kɔ̀ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ adʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Ádhɨ pbá alɛ ndɨ nyɨ nɨ̌ àtɨ, nyɨ rìtdu pbʉ̀kʉ̀ ara, nyadʉ̀ àrà nà?» ");
INSERT INTO niy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pbɛ́tʉ̀, wɔ̀ ka kɨ̀gʉ̌ alɛ náadʉ̀ nzá àdhɨ mà ʉ̀nɔ̀nà ndɨ dhu dhu nʉ́nɨ. Obhó tɨ́, wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Yěsù adʉ̀ ɨ̀’ɨ̀ ɨwà ndɨ̀ ndàwɨ̀lɨ̌ ndɨ̀, ndàrà ányɨ̀rɔ̌ ɨ̀’ɨ̀ ihé-yà nzínzì ɔ̌ rɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àrà wɔ̀ alɛ nótù Kàgàwà bhà ɨdzá, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Kɔ̀nɨ̌ nyɨ nyɔ̀gʉ̀ wà. Nɨ́ àpɛ́ nyɔnzɨ nzɛ́rɛnga tdɨ́tdɔ̌, akyɛ nzɛ́rɛ dhu nyʉ́ ròsè wɔ̀rɨ́ dɔ̀nǎ náarana nyabà tdɨ́tdɔ̌ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nɨ́ wɔ̀ alɛ náadʉ̀ àrà, ndìtsì àtɨ̀nà Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nɨ̌, Yěsù ràrɨ̌ ndɨ ndɨ̀ nɨ̀gʉ̌nà. ");
INSERT INTO niy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ɨ ádrɔ̀drɔ̌ alɛ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀nɛ̀ Yěsù, ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ kohò, sàbatʉ̀-ɨdhɔ̀ ɔ̌ kà rǎrà ìndrǔ ɨ̀gʉ rɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Àbadu Kàgàwà rɨ̌’ɨ̀ ìnè kòmbí màtɨ́ ndɨ̀ ndɨ́ kasʉ ɔ̀nzɨ rɔ́, nɨ́ ɨma mà átɔ̀, ma mɨ́’ɨ̀ kasʉ ɔ̀nzɨ ma mɨ́ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀nɛ̀ Yěsù tdɨ́tdɔ̌ atdyúya nyʉ́ nà, ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ kohò. Abádhí ambɛ́nà kɔ̀nɛ̀ dɔ̌, ɨ̀nzɨ̌ nɨ́ ɨnzá kɨ̌fʉ sàbatʉ̀-ɨdhɔ̀ dhu-okú dɔ̀ rɔ̀ tɨ́, pbɛ́tʉ̀ kǎrádʉ̀ Kàgàwà àtɨ̀ àbanà nyʉ́ tɨ́, ndɨ dhu ràdʉ̀ ndàbhʉ ɨ̀’ɨ̀ àdhàdhɨ̀ Kàgàwà nà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Kàgàwà t’Ídhùnà rɨ̌ nzɨ̌ àdʉ̀ atdí dhu mà nɔ́nzɨ̀ dɔ̀na rɔ̌, pbɛ́tʉ̀ kà rǎdʉ̀ ɔ̀nzɨ̀nà dhu nɨ́ yà Àbanà rɔ̌nzɨna rɔ́ ndɨ̀ ndálǎna dhu kɛ̀lɛ̌. Obhó tɨ́, Àbanà arɔ́nzɨna dhu nɔ́nzɨ̀ kà t’Ídhùnà rǎdʉ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Obhó tɨ́, Àbanà ózè Idhùnà, ndàdʉ̀ ndɨ̀ ndarɔ́nzɨna kɔ́rɔ́ dhu núvi kà tɔ̀. Kàrɨ̌ yà ndɨ̀ ndɔ́nzɨ̀ dhu dɔ̀nǎ róse ádrɔ̀drɔ̌ dhu núvǐ tdɨ́tdɔ̌ ndɨ Idhùnà tɔ̀, ndɨ́nɨ̌ ɨdhɔ adʉ̀ tɨ́ nyʉ̌kɔ nɨ̌ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Àdhàdhɨ̀ Àbadu náarɨ́ ʉ̀vʉ̌vɛ alɛ nábhʉ̌ rʉ̀ngbɛ ɨ̀ ɔvɛ-bvʉ̀ rɔ̀, ndàdʉ̀ ípìrɔ̌nga ùbho fɨ̌yɔ̀ dhu bhěyi tɨ́, nɨ́ ka t’Ídhùnà rǎdʉ̀ ípìrɔ̌nga núbho yà ndɨ̀ ndòzè ndùbho ka fɨ̌yɔ̀ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ndɨrɔ̀, Àbadu náarɨ́ nzɨ̌ ìndrǔ-ànyǎ nɨ́tdɨ̀, pbɛ́tʉ̀ kǐbhò anya t’ɨ́tdɨ̀ta tɔ́ ádrʉ̀ngbǎnga tɔ́ ɔbɨ kɔ́rɔ́ Idhùnà-fɔ́, ");
INSERT INTO niy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ndɨ́nɨ̌ kɔ́rɔ́ alɛ nɨ́ɨfʉ tɨ́ Idhùnà, àdhàdhɨ̀ ɨ̀ arɨ́ Àbanà nɨ́fʉ̌ dhu bhěyi. Nɨ́, ɨ̀nzɨ̌ arɨ́ Kàgàwà t’Ídhùnà nɨ́fʉ̀ alɛ, nɨ́fʉ nzá yà ka nívì Àbanà. ");
INSERT INTO niy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Yà ma mʉ́nɔna dhu nɨ́rɨ rɨ́ alɛ, ndàdʉ̀ yà ɨma nívì alɛ ná’ù, nábà wà dhòdhódhónga tɔ́ ípìrɔ̌nga. Ndɨrɔ̀, ka kɔtdɨ́ya nzɨ̌ anya kà dɔ̌, pbɛ́tʉ̀ kʉ̌dà wà ɔvɛ ɔ̀na nǎ, ndàdʉ̀ òtsù ípìrɔ̌nga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: kàsʉmɨ̀ níndù wà ndɨ̀, ndɨrɔ̀ ndɨ kàsʉmɨ̀ àkǎ wà. Ndɨ kàsʉmɨ̀ nɨ́ yà ʉ̀vʉ̌vɛ̀ kʉtdʉ̌ ɨ̀ alɛ rɨ̌ Kàgàwà t’Ídhùnà-tù nɨ́rɨ ɔ̀ná, ndɨrɔ̀ kà-tù ɨ̀rɨ rɨ́ alɛ ràdʉ̀ ípírɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Obhó tɨ́, àdhàdhɨ̀ Àba Kàgàwà náarɨ́’ɨ̀ ípìrɔ̌nga nà nyʉnatsì dhu bhěyi, nɨ́ kǎbhʉ Idhùnà rɨ̀’ɨ̀ ípìrɔ̌nga nà átɔ̀ nyʉnatsì. ");
INSERT INTO niy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ndɨrɔ̀, kǎdʉ̀ ìndrǔ-ànyǎ t’ɨ́tdɨ̀ta tɔ́ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nábhʉ Idhùnà tɔ̀, Ìndrǔ t’ídhùnà nɨ́ ka dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɨ́, àpɛ́ nyàbhʉ ɨdhɔ rʉ̀kɔ nyɨ̌ ndɨ dhu dɔ̌. Obhó tɨ́, kàsʉmɨ̀ níndù wà ndɨ̀, yà kɔ́rɔ́ alɛ kǎkà ʉ̀vʉ̌vɛ̀ kʉtdʉ̌ ɨ̀ rɨ̌ tǔdu ɨ̀rɨ ɔ̀ná, ");
INSERT INTO niy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","’àdʉ̀ ’ʉ̀ngbɛ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ yà ídzì nga ɔ̀nzɨ ɨ̀ arɨ́ rɔ́rɔ̀ ʉvɛ̀ alɛ nʉ́ʉngbɛya ɨ̀, ’àdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. Pbɛ́tʉ̀, yà nzɛ́rɛnga ɔ̀nzɨ ɨ̀ arɨ́ rɔ́rɔ̀ ʉvɛ̀ alɛ, nʉ́ʉngbɛya ɨ̀, kadʉ̀ anya nɨ́tdɨ̀ dɔ̀yá.» ");
INSERT INTO niy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tdɨ́tdɔ̌ Yěsù adʉ̀ dhu ɔ̀vɔ̀ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ tɔ̀, ndàtɨ: «Ɨma nyʉ́, ma mɨ́ nzɨ̌ àdʉ̀ atdí dhu mà nɔ́nzɨ̀ dùdu rɔ̌, pbɛ́tʉ̀ ma mádʉ̀ ìndrǔ-ànyǎ nɔ́tdɨ̀ Àbadu Kàgàwà nɔ́vɔ̀ ka idù dhu bhěyi. Ndɨrɔ̀ ndɨ anya nɔ́tdɨ̀ ma mádʉ̀ obhónánga dɔ̌. Obhó tɨ́, ma marɨ́ nzɨ̌ ma mòzè dhu nɔ́nzɨ, pbɛ́tʉ̀ ma marɔ́nzɨna dhu nɨ́ yà ɨma nivi alɛ nózè dhu kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ma mapɛ́ àdʉ̀ àdɨ pbàkà ngàmbì tɨ́ ma-tɨ́rɔ̀, nɨ́ ma mʉ́nɔna dhu nɨ́ nzɨ̌ àdʉ̀ ɨ̀’ɨ̀ obhó dhu. ");
INSERT INTO niy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pbɛ́tʉ̀, ngǎtsi alɛ nɨ́ ndɨ pbàkà ngàmbì, ndɨrɔ̀ ma mʉ̀nɨ wà dhu, kà rʉ̌nɔna dùdú dhu ràrɨ̌ obhó dhu. ");
INSERT INTO niy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyɨ̌ nyóvì ìndrǔ ròwù dhu ɔ̀ngʉ̀ bàtizò núbhǒ arɨ́ Yùwanɨ̀-tsʉ̌, nɨ́ kǎdʉ̀ obhó dhu tɨ́ rɨ́’ɨ̀ dhu nʉ́nɔ̀ fʉ̌kʉ̀ ɨ alɛ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɨma nyʉ́, ma mózè nzá ìndrǔ rǎdɨ pbàkà ngàmbì tɨ́ dhu, pbɛ́tʉ̀ ma mɨ́ yàrɨ́ dhu nʉ́nɔ fʉ̌kʉ̀ ndɨ́nɨ̌ nyɨ̌ nyʉgʉ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yùwanɨ̀ ɨ́’ɨ̀ nzínzìkʉ ɔ̌ àdhàdhɨ̀ ɔ̀bɨ ka kɔ̀bɨ̀ ràmbɛ ɨnga náwʉ̀ dɔ̌ tarà bhěyi. Ndɨrɔ̀, nyɨ̌ nyádʉ̀ ɨdhɛ̀kʉ nábhʉ rɨ̀ka ndɨ̀ ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́ kà rʉ̌nɔna fʉ̌kʉ̀ dhu tɔ́ awáwʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nɨ́ ɨma nyʉ́, ma mɨ́’ɨ̀ ìnè Yùwanɨ̀ ʉnɔ dhu dɔ̀nǎ òsè ngǎtsi dhu nà. Obhó tɨ́, ndɨ dhu nɨ́ yà Àbadu Kàgàwà íbhò ndɨ́nɨ̌ ma mɔnzɨ tɨ́ ràkǎ kasʉ, yà ìnè rɨ́’ɨ̀ ɔ̀nzɨ ma mɔ́nzɨna rɔ́. Nɨ́ ɨ kasʉ arɨ́ ndɨ dhu àvǐ, Àbadu Kàgàwà ràrɨ̌ ndɨ ɨma nívì. ");
INSERT INTO niy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yà ma nívì Àbadu nɨ́ átɔ̀ pbàkà ngàmbì. Nɨ́, nyɨ̌ nyàpɛ̀ nzá kà-tù nɨ́rɨ akɛkpá màtɨ́, ndɨrɔ̀ nyɨ̌ nyàpɛ̀ nzá kà-nyɨ̀-kpa nálǎ. ");
INSERT INTO niy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ndɨrɔ̀, nyɨ̌ nyɨ́’ɨ̀ mbǎ kàbhà ɔtɛ nà afíkʉ ɔ̀, ɨnzá nyɨ̌ nyá’ù yà kǐvì alɛ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyɨ̌ nyózè nyǒgyè Kàgàwà bhà Andítá-ɔ̀nga, nyɨ̌ nyárɨ́ ɨnga ɨ̀rɛ̀ kǒtù ɔ̌ nyɨ̌ ràrǎdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà dhu-okú dɔ̀ rɔ̀. Nɨ́, ɨ Andítá nɨ́ ɨ pbàkà ngàmbì. ");
INSERT INTO niy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pbɛ́tʉ̀, nyɨ̌ nyózè nzá nyǐwǔ tɨdu ɔ̀, ndɨ́nɨ̌ nyɨ̌ nyabá tɨ́ obhóná ípìrɔ̌nga. ");
INSERT INTO niy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma mózè nzá ìndrǔ rɨ̌ milè dhu. ");
INSERT INTO niy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pbɛ́tʉ̀, ma mʉ́nɨ wà nyɨ̌: nyɨ̌ nyózè nzá Kàgàwà. ");
INSERT INTO niy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨma, ma mɨ́rà Àbadu Kàgàwà-ɔvɔ̀ rɔ̌, nɨ́ nyɨ̌ nyàdʉ̀ nzá makɔ. Pbɛ́tʉ̀, ngǎtsi alɛ náapɛ́ àdʉ̀ ɨ̀rà ɔvɔ̀na nyʉ́ rɔ̌, nɨ́ nyɨ̌ nyádʉ̀ ndɨ alɛ àkɔ akyɛ. ");
INSERT INTO niy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nyɨ̌ nyádʉ̀ dhu à’ù ɨ̀ngbà dhu bhěyi, yà nyɨ̌ nyózè nyɨ̌fʉ nyɨ̌ nyɨ̌-tɨ́rɔ̀ nzínzìkʉ ɔ̌, ɨ̀nzɨ̌ nyǎdʉ̀ Kàgàwà atdírɔ̀ rɨ̌ nyɨ̌fʉ̌ dhu ɔ̀nɛ̀ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Àpɛ́ nyɨ̀rɛ̀ nga ɨma ràrɨ̌ ndɨ ma mɨ́ nyɔ̌bhʉ Àbadu-fɔ́. Pbɛ́tʉ̀ nyɔ̌bhʉ rɨ́ nɨ́ Músà, yà atdídɔ̌ nyɨ̌ nyá’ù tsʉ̀ná dhu alɛ. ");
INSERT INTO niy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Obhó tɨ́, nyɨ̌ nyá’ùyana gukyè Músà náandí dhu, nɨ́ nyɨ̌ nyádʉ̀yana ma mʉ́nɔna dhu à’ù átɔ̀, okúdu dɔ̀ rɔ̀ kǎndí ɨ dhu nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nɨ́ yà ɨnzá nyɨ̌ nyá’ù kǎndí dhu rɔ̀, nyɨ̌ nyádʉ̀ ma mʉ́nɔna ɔtɛ ná’ù ɨ̀ngbà dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù adà Gàlìlayà tɔ́ rɛ̀rʉ̀-adzè. Ndɨ rɛ̀rʉ̀ ka kanzínà átɔ̀ Tìbèriyà tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɨ́ ádrʉ̀ngbǎ ihé-yà náadʉ̀ òwu kǒwù ɔ̌, andɨ nà alɛ rɔ̌ ka rǎrà ɔ̀nzɨ̀nà rɔ̌ wɨwɨ̀ nála rɔ̌ ɨ̀ ówu nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nɨ́ Yěsù núupò pbìrì dɔ̀, ’àdʉ̀ òko obvò ányɨ̀ pbɨ̀ndà ábhàlɨ̌ mànà. ");
INSERT INTO niy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Pbàyàhúdí tɔ́ mʉ̀hɛndʉ̀, Pásɨ̀ka tɨ́ kátɨna-ɨdhɔ̀ nɨ́ɨ’ɨ̀ ɨwà ndìndù ndɨ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nɨ́ Yěsù ʉbɛ̀ nga ndàndà, ndàdʉ̀ ihé-yà nála tɨna ɔ̀ ríwu rɔ́. Nɨ́ kǎdʉ̀ dhu ìvu Fìlipò-tsʉ̌, ndàtɨ: «Àlɛ̌ kówu mʉ̀gatì òdzì àdhà ndɨ́nɨ̌ kǎkà alɛ ɔnyʉ tɨ́?» ");
INSERT INTO niy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kǐvú wɔ̀ dhu Fìlipò-tsʉ̌, àbadhi-afí kɛ̀lɛ̌ ndɨ̀ ndomvú tɨ́ nɨ̌. Obhó tɨ́, kʉ̌nɨ wà ndɨ̀ ndádʉ̀ ɔ̀nzɨ̀nà dhu. ");
INSERT INTO niy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nɨ́ Fìlipò adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Àlɛ̌ kɨ́ mbǎ mʉ̀gatì nódzi ɔ́yɔ̌ mɨyà fʉ̀rangà-kpɔ̌ rɔ̌ màtɨ́, kadʉ̀ ʉ̀ndɔ̀nà nɨ̀nɨ́ màtɨ́ kɔ̀rɨ́ alɛ-fɔ́, nɨ́ rɨ̌ nzɨ̌ àkǎ abádhí rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌, Àndɛ̀rɛyà tɨ́ kátɨna atdí alɛ, Sìmonì Pɛ́tɛrʉ̀ t’ádɔ̀nà, náadʉ̀ àtɨ̀nà Yěsù nɨ̌: ");
INSERT INTO niy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Atdí kpatsìbhíngba rɨ̌’ɨ̀ ìnè ɨrɔ́ sàyirì tɨ́ kátɨna nganʉ̀-ra nɨ̌ ka kɔ́bhɔ̀lɔ̀ imbò mʉ̀gatì nà, dɔ̀ná ɔ́yɔ̌ ɨ̀bhɛ̀ nà. Pbɛ́tʉ̀ wɔ̀ ndɨ dhu mà rɔ̌nzɨna yà dhu bvʉ̀ tɨ́ alɛ rɔ̌ dhu nɨ́ àdhu?» ");
INSERT INTO niy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyàvi ìndrǔ ròkò obvò.» Ányɨ̀rɔ̌ ɨrɨ́ nɨ́ɨ’ɨ̀ ìnè abhɔ. Nɨ́ ihé-yà adʉ̀ òko obvò ndɨ ɨrɨ́ dɔ̌. Ɨ alɛ-bvʉ nɨ’ɨ̀ mbɛ̀mbɛ̀ imbò lʉfʉ̀ kpabhálɛ. ");
INSERT INTO niy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nɨ́ Yěsù ugu kɔ̌kɔ̀ imbò mʉ̀gatì ndʉ̀lʉ̌ fɔná. Nɨ́ ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ɨ mʉ̀gatì àbhʉ kʉndɔ̀ ʉrɔ́ ɨ̀’ɨ̀ alɛ tɔ̀. Ndɨrɔ̀, kǎdʉ̀ ɨ̀bhɛ̀ nábhʉ átɔ̀ kʉndɔ̀ abádhí tɔ̀, abádhí nà rákǎ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ihé-yà níitdègu dhu ɔ̀nyʉ ’ùlè nɨ̌, nɨ́ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyùndu ɔ̀dɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀, akyɛ ndɨ̀ nɨnzana kɔkɔ́rɔ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nɨ́ Yěsù bhà ábhàlɨ̌ náadʉ̀ kɔ̌kɔ̀ ɔ̀nyʉ ka kɔ̀nyʉ̀ imbò mʉ̀gatì ɔ̀ rɔ̀ ɔ̀dɨ̀ mʉ̀gatì-go-tsʉ̀ núndu, rùlè atdí kumì dɔ̀ná ɔ́yɔ̌ nà sɛ̌ngɛ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nɨ́ wɔ̀ Yěsù ɔ̀nzɨ̀ wɨwɨ̀ ɨ̀ àla rɔ̀, ihé-yà adʉ̀ ɔtɛ ɔ̀pɛ̀ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Obhó nyʉ́, yàrɨ́ alɛ nɨ́ yà ka kʉnɔ ɨ̀rà ɨraya yà adzɨ ɔ̌ dhu tɨ́ Kàgàwà bhà nabì nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nɨ́ Yěsù itdègu abádhí rɨ̌ dhu ɔ̀nzɨ ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ ndɨ̀, ’ʉ̀dɔ ndɨ̀ fɨ̀yɔ́ ádrʉ̀ngbǎ kamà tɨ́ dhu ʉ̀nɨ̌, nɨ́ kǎdʉ̀ ndɨ̀dha abádhí nzínzì ɔ̌ rɔ̀, ndàdʉ̀ àrà atdírɔ̀ pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɨnga níitdègu àtɨ, nɨ́ Yěsù bhà ábhàlɨ̌ náawú pbìrì dɔ̀ rɔ̀, ìwǔ ùvò rɛ̀rʉ̀-tsʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nɨ́ abádhí núupò atdí ibhú ɔ̀, ’àdʉ̀ abhi ɔ̀pɛ̀ ’àmbɛ òwu dɔ̌ rɛ̀rʉ̀-adzè, Kàpɛ̀rnàwumù tɔ́ pbanga ɔ̀. Ɨnga nɨ́ɨ’ɨ̀ ɨwà ndɨ̀ ndàtɨ rɔ́, Yěsù ràdʉ̀ ɨ̀’ɨ̀ ɨnzá ndɨ̀ ndàpɛ̀ ɨ̀rà àhʉ abádhí ɨ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ndɨrɔ̀ ɨdha adʉ̀ ɨ̀’ɨ̀ atdídɔ̌ tsìna àva ndɨ̀ awɛ rǒpili ɔbɨ nyʉ́ nà dhu-okú dɔ̀ rɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nɨ́ Yěsù bhà ábhàlɨ̌ nɨ́ɨ’ɨ̀ ɨwà ɨ̀ ɔ̀tʉ̀ ibhú ràrà mbɛ̀mbɛ̀ imbò kìlòmɛ̌tɛ̀rɛ̀ tɨ́, ndɨrɔ̀ ngǎtsi nɨ̌ mbɛ̀mbɛ̀ azà kìlòmɛ̌tɛ̀rɛ̀ tɨ́ rɛ̀rʉ̀-alìkpa ɔ̀ rɔ́. Nɨ́rɔ̀ nɨ́ ndɨ abádhí náala Yěsù ɨdha dɔ̌ rúbhi pfɔ̌na dɔ̌, ndàmbɛ ɨ̀rà dɔ̌ ibhú ɨ rɔ́. Nɨ́ ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ abádhí ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ! Ɨma nɨ́ yà.» ");
INSERT INTO niy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nɨ́ abádhí náatsú ’àbhʉ Yěsù rùpò ibhú ɔ̀, nɨ́ kòmbómbí tɨ́ ibhú náadʉ̀ àrà àhʉ adzènǎ ɨdha-bɨdɔ̀, yà abádhí rǔbhi àda rɔ̌ ɨnǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsútsǎ nɨ́nganɨ́, rɛ̀rʉ̀-adzè ɨ̀ nʉ́bhàná ihé-yà nɨ́ɨrɛ̀ dhu atdí tɨ́ ibhú rɨ́’ɨ̀ná ɨdha-tsʉ̀nǎ. Ndɨrɔ̀, abádhí ɨrɛ̀ dhu Yěsù rúpòná nzá ndɨ ibhú ɔ̀, ’àdà atdíkpá pbɨ̀ndà ábhàlɨ̌ mànà, pbɛ́tʉ̀ ɨ ábhàlɨ̌ rówùná ɔ̀yá. ");
INSERT INTO niy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɨ́, ngʉ̌kpà ibhú náadʉ̀ ìwu Tìbèriyà tɔ́ kɨgɔ̀ ɔ̀nǎ rɔ̀, ìwǔ ùvò ɨ́kyɛ̀rɔ̌ yà ɔ̀tsɔ̀ ndɨ̀ ndàbhʉ Kàgàwà tɔ̀ dhu-dzidɔ̌, Yěsù ábhʉná mʉ̀gatì ihé-yà rɔ̀nyʉ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nɨ́ ihé-yà níitdègu dhu àlǎ, ɨ̀mbǎ Yěsù mà, pbɨ̀ndà ábhàlɨ̌ mànà ràrɨ̌’ɨ̀ nzínzìya ɔ̌, nɨ́ abádhí adʉ̀ ùpo Tìbèriyà rɔ̀ ìwǔ ibhú ɔ̌, ’òwù Yěsù ɔ̀nɛ̀ Kàpɛ̀rnàwumù tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kɔ̌kɔ̀ ihé-yà náawù ùvò rɛ̀rʉ̀-adzè, ’àdʉ̀ Yěsù òtù ányɨ̀. Nɨ́ abádhí níivú dhu kà-tsʉ̌ ’àtɨ: «Màlimò! Nyɨ nyɨ̀rà àhʉ ɨ̀ngbǎ tɨ́ ngá àzú?» ");
INSERT INTO niy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: nyɨ̌ nyɨ́ mɔnɛ dhu nɨ́ mʉ̀gatì nyɨ̌ nyɔ́nyʉ̀ná nyǔlè nɨ̌ dhu, ɨ̀nzɨ̌ nɨ́ yà ma márɔ́nzɨna wɨwɨ̀ nyɨ̌ nyála, nyǎdʉ̀ à’ùnà dhu. ");
INSERT INTO niy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nɨ́, dhu àkǎ nzá nyɔ̌nzɨ̀ kasʉ ndɨ̀nza rádʉ̀ ɔ̀nyʉ̀-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, dhu àkǎ nyɔ̌nzɨ̀ kasʉ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ rádʉ̀ fʉ̌kʉ̀ ɔ̀nyʉ̀-okú dɔ̀ rɔ̀. Ndɨ ɔ̀nyʉ̀ àbhʉ rádʉ̀ fʉ̌kʉ̀ nɨ́ Ìndrǔ t’ídhùnà. Obhó tɨ́, ka nɨ́ ndɨ Àbanà Kàgàwà nɨ́ɨlɨ pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ize rɔ̀ná alɛ, ndɨ́nɨ̌ ndɨ̀ ndívì ndɨ ka dhu navì tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nɨ́ kɔ̌kɔ̀ ihé-yà adʉ̀ dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Ádhu ndɨ àkǎkǎ mɔ̌nzɨ̀, ndɨ́nɨ̌ mà mɔnzɨ tɨ́ Kàgàwà bhà kasʉ?» ");
INSERT INTO niy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Kàgàwà bhà kasʉ nɨ́, nyǎ’ù yà ndɨ̀ nyʉ́ tɨ́rɔ̀ ndɨ̀ ndívì alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Abádhí adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌ ’àtɨ: «Ɨ́ngbà wɨwɨ̀ nyɨ nyɔ́nzɨna mǎla, ndɨ́nɨ̌ mǎ madʉ̀ tɨ́ nya’ù? Ádhu ndɨ nyɨ nyɔ́nzɨna? ");
INSERT INTO niy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abhúka náanyʉ̀ manà tɨ́ kátɨna mʉ̀gatì rʉ̀ngʉ̀ ɔ̌, àdhàdhɨ̀ yà Kàgàwà bhà Andítá rʉ̌nɔna dhu bhěyi. Ndɨ Andítá rǎtɨna: ‹Kàgàwà náabhʉ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ̀rà mʉ̀gatì abádhí rɔ̀nyʉ̀.›» ");
INSERT INTO niy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨ̀nzɨ̌ nɨ́ Músà ndɨ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ̀rà mʉ̀gatì nabhʉ̀ fʉ̌kʉ̀. Pbɛ́tʉ̀, Àbadu Kàgàwà nɨ́ ndɨ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ̀rà obhóná mʉ̀gatì nábhʉ̌ rɨ́ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Obhó tɨ́, Kàgàwà bhà mʉ̀gatì nɨ́ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà mʉ̀gatì. Ndɨrɔ̀, ndɨ mʉ̀gatì nɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ rɨ́ yà adzɨ ɔ̌ alɛ tɔ̀ mʉ̀gatì.» ");
INSERT INTO niy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nɨ́, ihé-yà adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, óngò wɔ̀rɨ́ mʉ̀gatì níbhò fǎkà bìlǐnganà.» ");
INSERT INTO niy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nɨ́ Yěsù adʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀ kpangba, ndàtɨ: «Ɨma nɨ́ ndɨ yà ípìrɔ̌nga nábhʉ rádʉ̀ ìndrǔ tɔ̀ mʉ̀gatì. Ndɨ alɛ náapɛ́ ɨ̀rà tɨdu ɔ̀, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ àwù nínè akɛkpá màtɨ́. Ndɨrɔ̀, ndɨ alɛ náapɛ́ ma’u, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ɔ̀mvʉ̀na ndɨ̀ ndɨ́ dhu-atdyú nóhò akɛkpá màtɨ́. ");
INSERT INTO niy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kɔ̀nɨ̌ ma mʉ̀nɔ̀ wà ɨ dhu fʉ̌kʉ̀. Nyɨ̌ nyála wà ma, pbɛ́tʉ̀ nyɨ̌ nyàpɛ̀ nzá ma’u. ");
INSERT INTO niy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Àba Kàgàwà níbhò idù alɛ nákǎ ’ìwǔ kɔ́rɔ́ tɨdu ɔ̀. Ndɨrɔ̀, tɨdu ɔ̀ ɨ̀rà alɛ nódì ma mɨ́ nzɨ̌ àdʉ̀ iri. ");
INSERT INTO niy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Obhó tɨ́, ma mɨ́rà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndɨ́nɨ̌ ma mɔnzɨ tɨ́ yà ma nívì alɛ-afí ózè dhu. Pbɛ́tʉ̀, ma mɨ́rà nzá ndɨ́nɨ̌ ma mɔnzɨ tɨ́ afídu ózè dhu. ");
INSERT INTO niy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yàrɨ́ nɨ́ ndɨ yà ma nívì Àbadu-afí ózè dhu: ‹Dhu àkǎ nzá mabhʉ yà fudú kǐbhò alɛ nzínzì ɔ̌ atdí alɛ mà ràwǐ. Pbɛ́tʉ̀, yà adzɨ ɔ̌ dhu-tsʉ̀ rǐtsi ndɔ̀dɨ̀ nɨ́nganɨ́, dhu akáya mabhʉ abádhí rʉ̀ngbɛ ɨ̀.›» ");
INSERT INTO niy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà: «Yàrɨ́ nɨ́ ndɨ Àbadu ózè dhu: kɔ́rɔ́ alɛ yà Idhùnà àlǎ rɨ́, ’àdʉ̀ à’ùnà, rǎdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. Ndɨrɔ̀, ma madʉ̀ya abádhí nábhʉ rʉ̀ngbɛ ɨ̀ yà adzɨ ɔ̌ dhu-tsʉ̀ rǐtsi ndɔ̀dɨ̀ nɨ́nganɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nɨ́ wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náapɛ̀ ’àmbɛ ònu dɔ̌ nzínzìya ɔ̌ Yěsù-okú dɔ̀ rɔ̀. Abádhí anù wɔ̀ Yěsù àtɨ, ndɨ̀ ràrɨ̌ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà mʉ̀gatì nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɨ́, abádhí ambɛ́nà àtɨ̀nà dɔ̌ nzínzìya ɔ̌: «Tɨ́ obhó Yěsù, Yɔ̀zɛfʉ̀ t’ídhùnà nyʉ́ yà? Àlɛ̌ kʉ́nɨ wà kà t’ábanà mà, kà-tsánà mànà. Nɨ́, kà rǎdʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi ndɨ̀ rɨ́rà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ nyònu nzínzìkʉ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ ɨ̀rà tɨdu ɔ̀, ɨ̀nzɨ̌ nɨ́ yà ɨma nívì Àbadu Kàgàwà kɛ̀lɛ̌ nábhʉ ndɨ̀ ndɨ̀rà tɨdu ɔ̀ rɔ̀. Ndɨ alɛ nɨ́ ndɨ ma madʉ̀ya àbhʉnà rɨ̀ngbɛ̀ ndɨ̀, yà adzɨ ɔ̌ dhu-tsʉ̀ rǐtsi ndɔ̀dɨ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kàgàwà bhà pbànábí náandí dhu ’àtɨ: ‹Kàgàwà nyʉ́ ndɨ̀tɨ́rɔ̀ núudhèya dhu kɔ́rɔ́ alɛ tɔ̀.› Àbadu Kàgàwà rʉ̌nɔna dhu nɨ̀rɨ̀, ndàdʉ̀ à’ùnà alɛ nɨ́ ndɨ rádʉ̀ ɨ̀rà tɨdu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Atdí alɛ mà nápɛ̀ nzá Àbadu àlǎ. Pbɛ́tʉ̀, ka nála nɨ́ yà Kàgàwà-tɨ’ɔ̀ rɔ̀ ɨ́rà alɛ kɛ̀lɛ̌ atdírɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Yěsù nà’ù alɛ nɨ́ rɨ̌’ɨ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nà. ");
INSERT INTO niy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɨma nɨ́ ndɨ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ arɨ́ ìndrǔ tɔ̀ mʉ̀gatì. ");
INSERT INTO niy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abhúkʉ náanyʉ̀ manà tɨ́ kátɨna mʉ̀gatì rʉ̀ngʉ̀ ɔ̀, nɨ́ abádhí adʉ̀ wà ùvɛ. ");
INSERT INTO niy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pbɛ́tʉ̀, yàrɨ́ nɨ́ ndɨ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà mʉ̀gatì. Ndɨ mʉ̀gatì nɔ̀nyʉ̀ alɛ rɨ̌ nzɨ̌ àdʉ̀ ɔ̀vɛ̀. ");
INSERT INTO niy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɨma nɨ́ ndɨ ípìrɔ̌nga tɔ́ ndɨ mʉ̀gatì, yà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ɨ́rà. Ndɨ alɛ apɛ́ ndɨ mʉ̀gatì nɔ́nyʉ, nɨ́ ndɨ alɛ adʉ̀ya dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. Ma mábhʉ̌na ndɨ alɛ rɔ̀nyʉ̀ mʉ̀gatì tɨ́ dhu nɨ́ ngbɔ̌du. Ma mɨ́ ndɨ ngbɔ̌du nábhʉ̌, ndɨ́nɨ̌ yà adzɨ ɔ̌ alɛ náabá tɨ́ ípìrɔ̌nga otùna ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, Pbàyàhúdí adʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ ɔbɨ nyʉ́ nà nzínzìya ɔ̌. Abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá, ’àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀kɔ̀! Yàrɨ́ alɛ rǎdʉ̀ ngbɔ̌na níbhò ɨ̀ngbǎ dhu bhěyi àlɛ̌ rɔ̀nyʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ Ìndrǔ t’ídhùnà-ngbɔ̀ nɔ́nyʉ, ɨ̀nzɨ̌ nyǎdʉ̀ kǎzù nɔ́mvʉ̀, nɨ́ nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà. ");
INSERT INTO niy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ndɨ alɛ apɛ́ ngbɔ̌du nɔ́nyʉ, ndàdʉ̀ azùdu ɔ̀mvʉ̀, nɨ́ ndɨ alɛ rǎdʉ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábà, ndɨrɔ̀ ma madʉ̀ya ndɨ alɛ àbhʉ rɨ̀ngbɛ̀ ndɨ̀ yà adzɨ ɔ̌ dhu-tsʉ̌ rǐtsi ndɔ̀dɨ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Obhó tɨ́, ngbɔ̌du nɨ́ obhóná ɔ̀nyʉ̀, ndɨrɔ̀ azùdu nɨ́ obhóná ɔmvʉ́. ");
INSERT INTO niy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nɨ́ ndɨ alɛ apɛ́ ngbɔ̌du nɔ́nyʉ, ndàdʉ̀ azùdu ɔ̀mvʉ̀, nɨ́ ma mɨ́’ɨ̀ ìnè ndɨ alɛ-nyʉtsì, ndɨrɔ̀ ndɨ alɛ rɨ̌’ɨ̀ ìnè nyʉdutsì. ");
INSERT INTO niy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ɨma nívì Àbadu Kàgàwà náarɨ́’ɨ̀ ìnè ípìrɔ̌nga nà, ndɨrɔ̀ ma márɨ́’ɨ̀ ìnè ípìrɔ̌nga nà kǒkú dɔ̀ rɔ̀. Nɨ́ ndɨ dhu bhěyi tɨ́, ngbɔ̌du nɔ̀nyʉ̀ alɛ nɨ́ rǎdʉ̀ ɨ̀’ɨ̀ ípìrɔ̌nga nà otùdu ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yàrɨ́ nɨ́ ndɨ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ífò mʉ̀gatì. Ndɨ mʉ̀gatì rɨ̌’ɨ̀ mbǎ yà abhúkʉ náanyʉ̀ mʉ̀gatì bhěyi. Ndɨ mʉ̀gatì ɨ̀ ɔ̀nyʉ̀ dhu-dzidɔ̌, abádhí náadʉ̀ wà ʉ̀vɛ. Pbɛ́tʉ̀, ndɨ alɛ náapɛ́ yàrɨ́ mʉ̀gatì nɔ́nyʉ, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ɔ̀vɛ̀ ɨ̀ngbǎ tɨ́ ngá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Wɔ̀rɨ́ nɨ́ ndɨ Yěsù ʉnɔ dhu, yà Kàpɛ̀rnàwumù tɔ́ pbanga ɔ̌ unduta-dzà ɔ̌ rɔ̀ ndɨ̀ ndɨ́ dhu núdhě ìndrǔ tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ rɔ̀, kàbhà ábhàlɨ̌ nzínzì ɔ̌ ábhɔ̌ alɛ nyʉ́ náadʉ̀ ’ɔ̀pɛ̀ ’àmbɛ àtɨ̀nà dɔ̌: «Yàrɨ́ alɛ rǔdhěna ìndrǔ tɔ̀ dhu nɨ́dzɔ̀ ɨ̀dzɔ tɨ́. Nɨ́ ádhɨ pbá alɛ ndɨ kɨ̀rɨ̀ rádʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yěsù itdègu kɔ̌kɔ̀ alɛ rǒnu nzínzìya ɔ̌ yà ndɨ̀ ndùdhe fɨ̌yɔ̀ dhu-okú dɔ̀ rɔ̀ dhu nʉ́nɨ̌, nɨ́ kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Wɔ̀ ma mʉ̀nɔ̀ dhu nábhʉ tɨ́ nyɨ̌ nyǒtsù nzɛ́rɛnga ɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Olu, nyɨ̌ nyálǎyana gukyè Ìndrǔ t’ídhùnà ɔ̀rʉ̀-akpà ɔ̀ rúpo yà angyi ndɨ̀ ndɨ’ɨ̀ ɨ rɔ́, nɨ́ ádhu nyɨ̌ nyʉ́nɔ̀yana? ");
INSERT INTO niy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɨ̀lɨ̌lǎ-Alafí nɨ́ ndɨ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ arɨ́ ìndrǔ tɔ̀ alɛ. Pbɛ́tʉ̀, ìndrǔ nyʉ́ rǎdʉ̀ ɔ̀nzɨ̀nà dhu rɨ̌’ɨ̀ ɨ̀mbǎ. Yà fʉ̌kʉ̀ ma mʉ̀nɔ̀ ɔtɛ nɨ́ Ɨ̀lɨ̌lǎ-Alafí ìbhò mʉnɔ̀ fʉ̌kʉ̀ ɔtɛ. Ndɨrɔ̀, ndɨ ɔtɛ nɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ rɨ́ ìndrǔ tɔ̀ ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pbɛ́tʉ̀, nzínzìkʉ ɔ̌ ngʉ̌kpà alɛ ná’ù nzá ndɨ ɔtɛ.» Obhó tɨ́, angyangyɨ nyʉ́, Yěsù nʉ́ʉnɨ wà abádhí nzínzì ɔ̌ ɨnzá ndɨ̀ ná’ù alɛ mà, ndɨ̀ nipfoya ndàbhʉ ndɨ̀ òmvǔ-fɔ́ alɛ mànà. ");
INSERT INTO niy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nɨ́ kǎdʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Kɔ̀nɨ̌ wɔ̀ dhu-okú dɔ̀ rɔ̀ nga nɨ́ ndɨ, ma mɔ́vɔ̀ dhu fʉ̌kʉ̀ matɨ: ɨ̀nzɨ̌ atdí alɛ mà ràrǎdʉ̀ ɨ̀rà tɨdu ɔ̀, ɨnzá Àba Kàgàwà kɛ̀lɛ̌ nábhʉ ndɨ̀ ndɨ̀rà rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nɨ́ rɔ̀pɛ̀ ndɨ̀ ʉrɔ́ rɔ̀, Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ ábhɔ̌ alɛ nyʉ́ nʉ́ʉdhá ɨ̀ olù, ’àdʉ̀ ’ɔ̀pɛ̀ ɨ̀nzɨ̌ ’òwù ùbhi rɔ̌ kǒwù ɔ̌ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nɨ́ wɔ̀ dhu ndɨ̀ ndàla rɔ̀, Yěsù adʉ̀ dhu ìvu pbɨ̀ndà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌-tsʉ̌, ndàtɨ: «Nyɨ̌ nyʉ́ mà nyɨ̌ nyòzè tɨ́ nyǒwù átɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nɨ́ Sìmonì Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, mǎ mówu àdhɨ bhà? Nyɨ nyarʉ́nɔna ɔtɛ nɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ rádʉ̀ ìndrǔ tɔ̀ ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nɨ́ kòmbí mǎ’ɨ́ na, mǎ mà’ù wà nyɨ. Ndɨrɔ̀ mǎ mʉ̀nɨ wà dhu nyɨ ràrɨ̌ Kàgàwà bhà rɔ̀ ɨ́rà Ɨ̀lɨ̌lǎ alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yà atdí kumì dɔ̀ná ɔ́yɔ̌ nà nyɨ̌ nyɨ́’ɨ̀ rɔ̀, tɨ́ obhó ɨma ndɨ ma mavò nyɨ̌? Pbɛ́tʉ̀ nzínzìkʉ ɔ̌ rɨ́’ɨ̀ atdí alɛ nɨ́ Pfɔ̀mvɔ nyʉ́!» ");
INSERT INTO niy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yěsù ambɛ́nà ɔ̀tɛ dɔ̌ dɔ̀ná nɨ́ Yudhà, Sìmonì Ìskàrìyɔtà t’ídhùnà. Obhó tɨ́, ndɨ Yudhà nɨ’ɨ̀ ndɨ Yěsù ìpfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ, àzèmbè ndɨ̀ ndongó ɨ̀’ɨ̀ kàbhà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ. ");
INSERT INTO niy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù ubhì Gàlìlayà tɔ́ pbìrì ɔ̀nǎ. Obhó tɨ́, kǎzè nzá ndùbhi Yùdɛyà tɔ́ pbìrì ɔ̀nǎ, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ rǒwu ndɔ̀nɛ̀ rɔ̌, ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ ndɨ̀ kohò ndɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Pbàyàhúdí tɔ́ hɛmɛ̌-dzà tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ nɨ́ɨ’ɨ̀ ɨwà ndìndù ndɨ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nɨ́ Yěsù t’ádɔ́na náatɨ kà nɨ̌: «Ɨ́và nyɨ ɨrɔ́ rɔ̀, nyarà Yùdɛyà tɔ́ pbìrì ɔ̀, ndɨ́nɨ̌ pbʉ̀kʉ̀ ábhàlɨ̌ náala tɨ́ nyɨ nyarɔ́nzɨna dhu átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɨ̀nzɨ̌ ndɨ̀ nòzè kʉnɨ ndɨ̀ alɛ rǎdʉ̀ ndɨ̀ ndarɔ́nzɨna dhu núrù ùru tɨ́. Nɨ́ kɔ̌kɔ̀ nyɨ nyarɔ́nzɨna dhu àkǎ nyarà ɔ̀nzɨ̀nà rɔ̌ kɔ́rɔ́ alɛ ràdʉ̀ àlanà.» ");
INSERT INTO niy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Obhó tɨ́, ɨ Yěsù t’ádɔ́na nyʉ́ mà ɨ̀tɨ́rɔ̀ náa’u nzá kàbhà dhu. ");
INSERT INTO niy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Idù ídzì kàsʉmɨ̀ nápɛ̀ nzá àkǎ. Pbɛ́tʉ̀, fʉ̌kʉ̀ kɔ́rɔ́ kàsʉmɨ̀ nɨ́ ídzì kàsʉmɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yà adzɨ ɔ̌ alɛ rɨ̌ nzɨ̌ àdʉ̀ nyɔ̌ndrɔ̀. Pbɛ́tʉ̀, ɨma abádhí ɔ́ndrɔ̀ atdídɔ̌, yà ma márádʉ̀ dhu ʉ̀nɔ̀ kpangba matɨ: abádhí arɔ́nzɨna dhu ràrɨ̌ nzɛ́rɛ dhu dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɨ́ nyɨ̌, nyòwu mʉ̀hɛndʉ̀ ɔ̀. Ɨmá na, ma mɨ́ nzɨ̌ àrà wɔ̀ mʉ̀hɛndʉ̀ ɔ̀, ɨnzá ányɨ̀ ma márà nɨ̌ pbàkà kàsʉmɨ̀ àpɛ̀ àkǎ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wɔ̀ dhu ndɨ̀ ndʉ̀nɔ̀ abádhí tɔ̀ rɔ̀, Yěsù adʉ̀ àdɨ Gàlìlayà tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yěsù t’ádɔ́na níitdègu òwu mʉ̀hɛndʉ̀ ɔ̀, nɨ́ kǎdʉ̀ ndɨ̀và ndàrà átɔ̀ ányɨ̀. Kǎrà ányɨ̀ ɨ̀nzɨ̌ ndɨ̀tɛ̀ ndɨ̀ kpangba ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náambɛ́nà kɔ̀nɛ̀ dɔ̌ wɔ̀ ndɨ mʉ̀hɛndʉ̀ ɔ̌. Abádhí owúnà dhu ɔ̀ngʉ̀ rɔ̌ ’àmbɛ àtɨ̀nà dɔ̌: «Ka nyʉ́ rɨ̌’ɨ̀ ɨ̀ngbɔrɔ́?» ");
INSERT INTO niy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, ihé-yà náambɛ́nà ’àgò dɔ̌ atdídɔ̌ nyʉ́ nzínzìya ɔ̌ Yěsù nàndà dhu dɔ̌. Atdídhená alɛ nóowúnà àtɨ̀nà rɔ̌: «Wɔ̀rɨ́ alɛ nɨ́ ídzì alɛ nyʉ́.» Ngʉ̌kpà alɛ ràdʉ̀ òwu àtɨ̀nà rɔ̌: «Ɨ̀nzɨ̌ nɨ́ wɔ̀ dhu bhěyi! Wɔ̀rɨ́ alɛ náarɨ́ ìndrǔ nʉ́trǎ atdídɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pbɛ́tʉ̀, abádhí nzínzì ɔ̌ atdí alɛ mà náaránà nzɨ̌ ndɨ̀ ndòzè ndʉ̀nɔ̀ Yěsù dɔ̌ dhu nɔ́vɔ̀ rɔ̌ kpangba, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ-ɔdɔ̀ nɔ́nzɨ ɨ̀’ɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nɨ́, ɨwà mʉ̀hɛndʉ̀-ɔ̌nga nálì ndɨ̀ rɔ́rɔ̀ nɨ́ ndɨ, Yěsù atsù Kàgàwà bhà ɨdza ɔ̀, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nɨ́ ɨdhɔ nʉ́ʉkɔ Pbàyàhúdí atdídɔ̌ nyʉ́. Abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá, ’àmbɛ àtɨ̀nà dɔ̌: «Yàrɨ́ alɛ nyʉ́ nʉ́nɨ Andítá ɨ̀ngbǎ dhu bhěyi, àzèmbè ɨnzá ndɨ̀ ndɔ́zʉ̀ dhu rɔ́rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yà ma marúdhěna ìndrǔ tɔ̀ dhu nɨ́ nzɨ̌ dùdu ɔ̀ rɔ̀ áhʉ dhu, pbɛ́tʉ̀ ndɨ dhu aráhʉ yà ma nívì Àbadu Kàgàwà-dɔ ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kàgàwà ózè dhu nòzè ndɔ̀nzɨ̀ alɛ nɨ́ ndɨ rádʉ̀ dhu ʉ̀nɨ, yà ma marúdhěna dhu ràtɨ́ Kàgàwà údhe idù dhu, ndɨrɔ̀ ngǎtsi nɨ̌, yà ma marʉ́nɔna ɔtɛ ràtɨ́ dùdu ɔ̀ rɔ̀ àhʉ ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dɔ̀na ɔ̀ rɔ̀ àhʉ dhu dɔ̌ tɨ́ arɨ́ ndòzè ndìdè alɛ nɨ́ ndɨ̀ nòzè kɨfʉ ndɨ alɛ. Pbɛ́tʉ̀, yà ndɨ̀ nívì alɛ nòzè kɨfʉ alɛ rǎdʉ̀ obhó dhu nʉ́nɔ̀. Ndɨrɔ̀, nzɛ́rɛ dhu mà rɨ̌ nzɨ̌ àdʉ̀ àhʉ kà-ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Músà nʉ́ʉbhà tɨ́ nzá Ʉyátá fʉ̌kʉ̀? Pbɛ́tʉ̀, atdí alɛ mà nzínzìkʉ ɔ̌ náarɨ́ nzɨ̌ àdʉ̀ ndɨ Ʉyátá nɨ́fʉ. Nɨ́ ádhu nyɨ̌ nyárɨ́ mɔnɛ ndɨ́nɨ̌ nyɨ̌ nyabhʉ̀ tɨ́ ma kohò nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nɨ́ ihé-yà adʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Nyɨ nyɨ́’ɨ̀ nzɛ́rɛ-alafí nà ʉ̀nʉ̀! Ádhɨ ndɨ nyɔnɛ rɨ́ ndɨ́nɨ̌ ndɨ̀ ndabhʉ̀ tɨ́ nyɨ kohò?» ");
INSERT INTO niy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɔ́nzɨ̀ atdí dhu kɛ̀lɛ̌ sàbatʉ̀-ɨdhɔ̀ ɔ̌, ɨdhɔ ràdʉ̀ nyʉ̌kɔ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Músà nʉ́ʉyá dhu fʉ̌kʉ̀ nyǒngò fʉ̀kʉ́ kpabhínzo-ɔ̀nzɨ̌nga nɔ́bhɔ̀lɔ̀. (Pbɛ́tʉ̀ ndɨ dhu nyʉ́ napɛ̀ nɨ́ nzɨ̌ Músà. Ka napɛ̀ nɨ́ abhúkʉ). Nɨ́, nyɨ̌ nyarádʉ̀ kpabhínzo-ɔ̀nzɨ̌nga nɔ́bhɔ̀lɔ̀ sàbatʉ̀-ɨdhɔ̀ ɔ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nyɨ̌ nyárɨ́ fʉ̀kʉ́ kpabhínzo-ɔ̀nzɨ̌nga nɔ́bhɔlɔ sàbatʉ̀-ɨdhɔ̀ ɔ̌ màtɨ́, ɨ̀nzɨ̌ ndɨ dhu ràdʉ̀ nyǎbhʉ nyʉ̌kɔ̀ Músà bhà Ʉyátá. Nɨ́ ádhu ìndrǔ-ngbùlǔ nyʉ́ ma mɨ̀gʉ̌ sàbatʉ̀-ɨdhɔ̀ ɔ̌ rɔ̀ nyɨ̌ nyádʉ̀ àkǒ rùdú nɨ̌? ");
INSERT INTO niy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɨ̀nzɨ̌ nyòngò ìndrǔ-ànyǎ nɨ́tdɨ̀ yà nyɨ̀kpɔ́kʉ ɔ̌ nyɨ̌ nyálǎna dhu-okú dɔ̀ rɔ̀ tɨ́. Pbɛ́tʉ̀, nyòngò ìndrǔ-ànyǎ nɨ́tdɨ̀ obhónánga dɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̌ atdídhená alɛ náapɛ̀ ’ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá, ’àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀kɔ̀! Tɨ́ obhó yà ka kúbhi ɔ̀nɛ̀nà rɔ̌ ndɨ́nɨ̌ kabhʉ̀ tɨ́ kohò alɛ nyʉ́ wɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nyàndà pɛ́ kà rɔ̌tɛ kpangba, ɨ̀nzɨ̌ kadʉ̀ atdí dhu mà nɔ́nzɨ̀ rɔ̀ná! Àlɛ̌ tɔ́ ádrɔ̀drɔ̌ alɛ nyʉ́ nʉ́nɨ tɨ́ nzá wà dhu, yàrɨ́ alɛ ràrɨ̌ obhó nyʉ́ Krɨ́stɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pbɛ́tʉ̀, àlɛ̌ kʉ̀nɨ wà àdhà rɔ̀ màtɨ́ yàrɨ́ alɛ nɨ́rà dhu. Krɨ́stɔ̀ rɨ̌rà nɨ́nganɨ́, atdí alɛ mà nʉ́ʉnɨya ɨ̀nzɨ̌ àdhà rɔ̀ màtɨ́ kɨ̀rà dhu.» ");
INSERT INTO niy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nɨ́rɔ̀ nɨ́ ndɨ Kàgàwà bhà ɨdza ɔ̌ rɔ̀ ndɨ̀ ndɨ́ dhu ùdhě ìndrǔ tɔ̀ rɔ́rɔ̀, Yěsù atɛ̀ ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Nyɨ̌ nyʉ̀nɨ wà ma, ndɨrɔ̀ nyɨ̌ nyʉ̀nɨ wà àdhà alɛ màtɨ́ ma mɨ́’ɨ̀ dhu. Pbɛ́tʉ̀, ma mɨ́rà nzá ɔvɔ̀du dɔ̌ ma-tɨ́rɔ̀. Ɨma nívì alɛ nɨ́ àkǎ àkǎ nyǎ’ù alɛ, ndɨrɔ̀ ndɨ alɛ nɨ́ ɨnzá nyɨ̌ nyʉ́nɨ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pbɛ́tʉ̀, ma mʉ́nɨ wà àbadhi. Obhó tɨ́, ma mɨ́rà kà bhà rɔ̀, ndɨrɔ̀ Ka nɨ́ ndɨ ɨma nívì alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɨ́, abádhí adʉ̀ dhu ɔ̀nzɨ̀ ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ Yěsù, pbɛ́tʉ̀ atdí alɛ mà náadʉ̀ nzá ɔtsʉ́na nɨ́lɨ kà-rɔ̌, ɨnzá kà bhà kàsʉmɨ̀ nápɛ̀ àkǎ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pbɛ́tʉ̀, ihé-yà nzínzì ɔ̌ ábhɔ̌ alɛ nyʉ́ náadʉ̀ Yěsù à’ù. Ɨ alɛ nóowúnà àtɨ̀nà rɔ̌: «Krɨ́stɔ̀ rɨ̌rà nɨ́nganɨ́, kɔ̌nzɨya tɨ́ ɔ̀nzɨ ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ dhu ròsè yàrɨ́ alɛ rǎrà ɔ̀nzɨ̀nà rɔ̌ dhu dɔ̀nǎ?» ");
INSERT INTO niy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pbàfàrìsáyó níitdègu kɔ̌kɔ̀ ihé-yà rʉ̌nɔna obvò tǔyá na Yěsù dɔ̌ dhu nɨ́rɨ, nɨ́ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà, náavì Kàgàwà bhà ɨdza-ngbɔ̀ nɔ́dɔ arɨ́ sàndǐrì, ròwù Yěsù nósò. ");
INSERT INTO niy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nɨ́ abádhí níwǔ ùvò tɨná rɔ̀ Yěsù atɨ: «Àlɛ̌ kòko òko atdíkpá nyɨ̌ mànà ákɛ̌ kàsʉmɨ̀ tɨ́ tdɨ́tdɔ̌. Ndɨ dhu-dzidɔ̌, ma mɨ́ madǔ yà ɨma nivi alɛ-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɨ́, nyɨ̌ nyowuya ɨma nɔmɛ̀ rɔ̌, ɨ̀nzɨ̌ nyǎdʉ̀ mala. Obhó tɨ́, yà ma márà ɨ nga nɨ́ ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ òwu ùvò ɨ nga.» ");
INSERT INTO niy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀kɔ̀! Kà rɨ̌ ndɨ̀và ndàrà àdhà, ɨ̀nzɨ̌ àlɛ̌ kadʉ̀ tɨ́ ndàla? Kà tɨ́ àrà yà Pbàgìríkí-bvʉ̀nǎ ɨ̀ nɨ́fàlà Pbàyàhúdí-bvʉ̀? Kà tɨ́ àrà dhu ùdhe Pbàgìríkí tɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nyàndà pɛ́ kàtɨ, àlɛ̌ ràrɨ̌ ndɔ̀nɛ ɨ̀nzɨ̌ àlɛ̌ ràdʉ̀ ndàla, ndɨrɔ̀ ndɨ̀ ndárà ɨ nga ràrɨ̌ ɨ̀nzɨ̌ àlɛ̌ ka kádʉ̀ òwu ùvò ɔ̀nà ngari. Nɨ́ wɔ̀ dhu-tɨ̀ nɨ́ àdhu?» ");
INSERT INTO niy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hɛmɛ̌-dzà tɔ́ mʉ̀hɛndʉ̀ rǐku ɔ̀ná ɨdhɔ nɨ’ɨ̀ ndɨ ádrʉ̀ngbǎ ɨdhɔ nyʉ́. Nɨ́, ndɨ nɨ́nganɨ́, Yěsù ɨvà ndɨ̀ ndìdè ihé-yà-ɔ̀nzɨ̌, ndàdʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀ ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Ɨdha-atdyú nà rɨ́’ɨ̀ alɛ nákǎ ndɨ̀rà tɨdu ɔ̀, ndɨ́nɨ̌ ndadʉ̀ tɨ́ ɨdha nɔ́mvʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Àdhàdhɨ̀ yà Kàgàwà bhà Andítá rʉ̌nɔna dhu bhěyi tɨ́, ɨma nà’ù alɛ-afí ɔ̀ rɔ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ rɨ́ ìndrǔ tɔ̀ ɨdha rǎdʉ̀ àhʉ, rɨ̀lɨ ndɨ̀ yà bhʉ̀na ɔ̌ rɔ́kʉ ɨdha-akpà ɔ̌ ɨdha bhěyi.» ");
INSERT INTO niy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yěsù ʉnɔ wɔ̀ dhu, yà Kàgàwà rǎdʉ̀ ndɨ̀ nà’ù alɛ ɨ̀ra nɨ̌ Ɨ̀lɨ̌lǎ-Alafí-okú dɔ̀ rɔ̀. Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Kàgàwà nɨ́ɨ’ɨ̀ ɨnzá ndɨ̀ ndàpɛ̀ pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nívì rɨ̀rà yà adzɨ dɔ̌ rɔ́. Obhó tɨ́, Kàgàwà nɨ́ɨ’ɨ̀ ɨnzá ndɨ̀ ndàpɛ̀ Yěsù ɨ̀dzɨ̌, ndɨ̀lɨ pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nɨ́ wɔ̀ Yěsù ʉ̀nɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ihé-yà nzínzì ɔ̌ atdídhená alɛ náatɨ Yěsù nɨ̌: «Yàrɨ́ alɛ nɨ́ obhó nyʉ́ Kàgàwà bhà nabì nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ngʉ̌kpà alɛ adʉ̀ àtɨ̀nà: «Yàrɨ́ alɛ nɨ́ Krɨ́stɔ̀.» Ndɨrɔ̀, ngʉ̌kpà-tsí náadʉ̀ àtɨ̀nà: «Hǒyì! Krɨ́stɔ̀ tɨ́ àdʉ̀ ɨ̀rà ɨ̀rà Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kàgàwà bhà Andítá nátɨ́ obhó àtɨna Krɨ́stɔ̀ rahʉ̀ya Dàwudì-dhú bvʉ̌ rɔ̀? Ndɨrɔ̀, kǎtɨ́ obhó àtɨna àbadhi rahʉ̀ya Bɛ̀tɛ̀lɛ̀hɛmʉ̀, yà Dàwudì adɨ̀ ɔ̀ná pbanga ɔ̌ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nɨ́rɔ̀ nɨ́ ndɨ ihé-yà-ɔ̌nga náadʉ̀ ndʉ̀ndɔ̀ Yěsù-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nɨ́ atdídhená abádhí nzínzì ɔ̌ alɛ náatsú ’òsò Yěsù, pbɛ́tʉ̀ atdí alɛ mà náadʉ̀ nzá ɔtsúna nɨ́lɨ kà-rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wɔ̀ dhu-dzidɔ̌, yà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà nóvìnà ròwù Yěsù òsò sàndǐrì níitdègu ’àdǔ, nɨ́ ɨ alɛ níivú dhu ɨ sàndǐrì-tsʉ̌, ’àtɨ: «Ádhu ɨnzá nyɨ̌ nyìwǔ Yěsù nà nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɨ́ kɔ̌kɔ̀ sàndǐrì náadʉ̀ dhu àdu ’àtɨ: «Ɨnzá atdí alɛ mà nápɛ̀ ɔ̀tɛ angyi wɔ̀rɨ́ alɛ rǎrà ɔ̀tɛ rɔ̌ dhu bhěyi!» ");
INSERT INTO niy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pbàfàrìsáyó adʉ̀ dhu ìvu abádhí-tsʉ̌ ’àtɨ: «Nyɨ̌ nyʉ́ mà, nyɨ̌ nyʉ̀bhà tɨ́ nyɨ̌ kà rʉ̀trǎ nyɨ̌ átɔ̀? ");
INSERT INTO niy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nyɨ̌ nyála tɨ́ àlǎ àlɛ̌ tɔ́ ádrɔ̀drɔ̌ alɛ nzínzì ɔ̌ atdí alɛ mà, ndɨrɔ̀ Pbàfàrìsáyó nzínzì ɔ̌ atdí alɛ mà ka ná’ù rɔ́? ");
INSERT INTO niy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pbɛ́tʉ̀, kɔ̌kɔ̀ ka ná’ù ihé-yà nɨ́ ɨnzá àlɛ̌ tɔ́ Ʉyátá nʉ́nɨ alɛ. Ndɨrɔ̀, ɨ alɛ nɨ́ òfù tɨ́ ka kófù alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Nɨ̀kɔ̀dɛmʉ̀, yà kúbhingánǎ arà àhʉ Yěsù-tɨ’ɔ̀ alɛ nɨ́ɨ’ɨ̀ ìnè ɨ Pbàfàrìsáyó nzínzì ɔ̌. Nɨ́ kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Àlɛ̌ tɔ́ Ʉyátá návi tɨ́ àvǐ kɔtdɨ̀ anya ìndrǔ dɔ̌, ɨnzá ka kɨ̀rɨ̀ ndɨ alɛ rʉ̌nɔna dhu mà, ndɨrɔ̀ ɨnzá ka kʉ̀nɨ ndɨ alɛ ɔ́nzɨ̀ dhu mà rɔ́rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɨ́ abádhí adʉ̀ dhu àdu Nɨ̀kɔ̀dɛmʉ̀ tɔ̀ ’àtɨ: «Nyɨ nátɨ́ átɔ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ alɛ? Ɔ́nɛ pɛ́ Kàgàwà bhà Andítá ɔ̀ nga mběyi! Nɨ́ nyɨ nyɨ́ dhu àlǎ, ɨnzá Kàgàwà bhà nabì ràpɛ̀ àhʉ atdí màtɨ́ Gàlìlayà tɔ́ pbìrì ɔ̀ rɔ̀.»  ");
INSERT INTO niy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wɔ̀ dhu-dzidɔ̌, ngǎtsi alɛ adʉ̀ ndɨ̀và ndɔ̀dɨ̀ dɔ̀na, ndàrà pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù ɨvà ndɨ̀ ndàrà mìzèyìtunì tɨ́ kátɨna itsu náarɨ́’ɨ̀ dɔ̀ná pbìrì dɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nɨ́, tsútsǎnɨ́nganɨ́ kútsingá nyʉ́, kǎdù ndɨ̀ tdɨ́tdɔ̌ Kàgàwà bhà ɨdza, kɔ́rɔ́ alɛ ràdʉ̀ ’àndu tɨná. Nɨ́ kǎdɨ̀ obvò, ndàdʉ̀ ndɔ̀pɛ̀ ndùdhe dhu ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nɨ́rɔ̀ nɨ́ ndɨ Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà, níiwú atdí tsìbhálɛ nà Yěsù-tɨ’ɔ̀, ’àdʉ̀ àbhʉnà rìdè kɔ́rɔ́ alɛ-ɔ̀nzɨ̌. Ndɨ tsìbhálɛ nɨ’ɨ̀ mʉ̀nyɔ̀nɨ̀ ɔ̀nzɨ rɨ́ rɔ́ ka kɔ̀tdɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nɨ́ abádhí atɨ Yěsù nɨ̌: «Màlimǒ, yàrɨ́ tsìbhálɛ mà ka kɔ̀tdɨ̀ mʉ̀nyɔ̀nɨ̀ ɔ̀nzɨ rɨ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Músà nʉ́ʉyá dhu fǎkà ndàtɨ, ɨ dhu bhěyi vèbhálɛ núbvu mǎ ròngò odu nɨ̌, rʉ̀vɛ. Nɨ́ nyɨ nyʉ́, nyɨ nyátɨna ɨ̀ngbǎ dhu bhěyi yàrɨ́ tsìbhálɛ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Abádhí níivú wɔ̀ dhu Yěsù-tsʉ̌, ’òmvù kà-afí nɨ̌, ndɨ́nɨ̌ ɨ̀ idyi tɨ́ kǎ-dà-dɔ, ’àdʉ̀ kɔ̀bhʉ̀ okúna dɔ̀ rɔ̀. Pbɛ́tʉ̀, Yěsù adʉ̀ ndàgu obvò, ndàdʉ̀ àdɨ ndàmbɛ dhu àndi dɔ̌ ɔtsʉ́na-kpɔ̀ nɨ̌ adzɨkpa dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nɨ́ Músà bhà Ʉyátá tɔ́ màlímó mà, Pbàfàrìsáyó mànà nʉ́tʉ dhu, ’àmbɛ dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀ná tɨ́ rɔ̀, Yěsù angbɛ ndɨ̀, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nzínzìkʉ ɔ̌, ɨnzá àpɛ̀ dhu àfǎ atdíku màtɨ́ alɛ nákǎ ndɨ ndɔ̀pɛ̀ ndùbvǔ ka wɛmbɛrɛ̀ tɨ́ odu nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yěsù adʉ̀ ndàgu tdɨ́tdɔ̌, ndàmbɛ dhu àndi dɔ̌ adzɨkpa dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nɨ́ abádhí níitdègu wɔ̀ kʉ̀nɔ̀ dhu nɨ́rɨ, nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ùwě ɨ̀ atdátdírà ɔ̌ ányɨ̀rɔ̌ rɔ̀, rɔ̀pɛ̀ ndɨ̀ kǎkà ɨwà atɔ̀ya ówù angyi alɛ rɔ̌ rɔ̀. Yěsù mà náadʉ̀ ’ʉ̀bhà ɔ́yɔ̌ rɔ̀ tɨ́ wɔ̀ ndɨ ɔnzɨ̀ná ìdènà tsìbhálɛ mànà. ");
INSERT INTO niy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nɨ́rɔ̀ nɨ́ ndɨ kǎngbɛ ndɨ̀ tdɨ́tdɔ̌, ndàdʉ̀ àtɨ̀nà wɔ̀ tsìbhálɛ nɨ̌: «Hɔ̀kɔ̀! Kɔ̌kɔ̀ nyɔbhʉ̀ rɔ̌ rúbhi alɛ rɨ̌’ɨ̀ ɨ̀ngbɔrɔ́? Atdí alɛ mà nɔ́tdɨ̀ tɨ́ obhó anya dʉ̀nʉ́?» ");
INSERT INTO niy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nɨ́ wɔ̀ tsìbhálɛ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨnzá atdí alɛ mà nɔ́tdɨ̀ anya dùdú.» Nɨ́ Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ma nyʉ́ mà, ma mɨ́ nzɨ̌ anya ɔ̀tdɨ̀ dʉ̀nʉ́. Nɨ́ árà, ndɨrɔ̀ àpɛ́ nyɔnzɨ nzɛ́rɛnga tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ dhu ɔ̀vɔ̀ tdɨ́tdɔ̌ ihé-yà tɔ̀ ndàtɨ: «Ɨma nɨ́ ndɨ yà adzɨ ɔ̌ alɛ-nyɨ̌nga àwʉ̀ rɨ́ awáwʉ̀. Ndɨ alɛ náapɛ́ owùdu nʉ́ngʉ̌, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ùbhi ɨ́nɔ̀ ɔ̌ akɛkpá màtɨ́, pbɛ́tʉ̀, kà rǎdʉ̀ ɨ̀’ɨ̀ ípìrɔ̌nga nábhʉ̌ rɨ́ awáwʉ̀ nà.» ");
INSERT INTO niy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nɨ́, Pbàfàrìsáyó adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Nyɨ nyarádɨ nyɨ-tɨ́rɔ̀ nyɨ nyarɔ́nzɨna dhu tɔ́ ngàmbì tɨ́. Nɨ́, nyɨ nyarʉ́nɔna dhu nɨ́ nzɨ̌ obhó dhu.» ");
INSERT INTO niy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nɨ́, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨ̀mbǎ dhu rɨ̌’ɨ̀ ma marádɨ pbàkà ngàmbì tɨ́ ma-tɨ́rɔ̀ dhu màtɨ́, nɨ́ ma marʉ́nɔna dhu nɨ́ obhó dhu. Obhó tɨ́, ma mʉ́nɨ wà àdhà rɔ̀ màtɨ́ ma mɨ́rà dhu, ndɨrɔ̀ ma mʉ́nɨ wà àdhà màtɨ́ ma márà dhu. Pbɛ́tʉ̀, nyɨ̌ nyʉ́nɨ nzá àdhà rɔ̀ màtɨ́ ma mɨ́rà dhu, ndɨrɔ̀ nyɨ̌ nyʉ́nɨ nzá àdhà màtɨ́ ma márà dhu. ");
INSERT INTO niy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyɨ̌ nyárɨ́ ìndrǔ-ànyǎ nɨ́tdɨ̀ yà adzɨ ɔ̌ alɛ náarɨ́ ìndrǔ-ànyǎ nɨ́tdɨ̀ ɔ̀ná ɔ́fɔ̀ ɔ̌. Pbɛ́tʉ̀, ma marɨ́ nzɨ̌ atdí alɛ-ànyǎ mà nɔ́tdɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ndɨrɔ̀, ma mapɛ́ àdʉ̀ ìndrǔ-ànyǎ nɔ́tdɨ̀, nɨ́ ma mádʉ̀ kɔ̀tdɨ̀ obhónga dɔ̌. Obhó tɨ́, ma mɨ́’ɨ̀ mbǎ atdírɔ̀ ndɨ anya t’ɨ́tdɨ̀ta ɔ̌, pbɛ́tʉ̀ mǎ mɨ́’ɨ̀ yà ɨma nívì Àbadu mànà. ");
INSERT INTO niy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Fʉ̀kʉ́ Ʉyátá ɔ̀ ka kándǐ dhu katɨ, ɔ́yɔ̌ alɛ rapɛ́ òko atdí dhu tɔ́ ngàmbì tɨ́, nɨ́ ɨ alɛ ʉ̀nɔ̀ dhu ràrǎdʉ̀ ɨ̀’ɨ̀ obhó dhu. ");
INSERT INTO niy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nɨ́ ma marádɨ pbàkà ngàmbì tɨ́ ma-tɨ́rɔ̀, ndɨrɔ̀ yà ma nívì Àbadu nɨ́ átɔ̀ pbàkà ngàmbì.» ");
INSERT INTO niy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nɨ́ Pbàfàrìsáyó adʉ̀ dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Ndɨ Àbanʉ rɨ̌’ɨ̀ àdhà?» Nɨ́ Yěsù adʉ̀ dhu àdu, ndàtɨ: «Nyɨ̌ nyʉ́nɨ nzá ma, ndɨrɔ̀ nyɨ̌ nyʉ́nɨ nzá Àbadu. Nyɨ̌ nyʉ́nɨ̌yana gukyè ɨma, nɨ́ nyɨ̌ nyʉ́nɨ̌yana ʉ̀nɨ̌ Àbadu átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yěsù ambɛ́nà wɔ̀ dhu ʉ̀nɔ̀ dɔ̌ Kàgàwà bhà ɨdzá ndɨ̀ ndàdɨ ndàmbɛ dhu ùdhe dɔ̌ ìndrǔ tɔ̀ rɔ́rɔ̀. Kǎdɨ̀ yà pɛrɛ̀ tɨ́ ka kúbhǒna Kàgàwà tɔ̀ fʉ̀rangà nʉ́dɔ̌ ka kárɨ́ ɔ̀nà sàndukù tɨ́. Pbɛ́tʉ̀, atdí alɛ mà náadʉ̀ nzá kòsò, ɨnzá kàbhà kàsʉmɨ̀ nápɛ̀ àkǎ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà Pbàyàhúdí nɨ̌: «Kànɨ̌ ma màrà wà, nɨ́ nyɨ̌ nyɨ́ nyɔ̌pɛ̀ nyɔ̌nɛ̀ ma, pbɛ́tʉ̀, nyɨ̌ nyʉ́vɛ ʉ̀vɛ̌ tɨ́ fʉ̀kʉ́ nzɛ́rɛnga ɔ̌. Ma márà ɨ nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ òwu ùvò.» ");
INSERT INTO niy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɨ́, Pbàyàhúdí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Kà tɨ́ ndòho òho tɨ́, wɔ̀ kà rǎtɨna ɨ̀nzɨ̌ àlɛ̌ ràrǎdʉ̀ òwu ùvò ndɨ̀ ndárà ɨ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nɨ́ obvò bhà, pbɛ́tʉ̀ ɨma nɨ́ ɔrʉ̀ alɛ. Nyɨ̌ nɨ́ yà adzɨ ɔ̌ bhà, pbɛ́tʉ̀ ɨma nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma màtɨ, ʉ̀vɛ̌ tɨ́ nyɨ̌ ràrʉ̌vɛ fʉ̀kʉ́ nzɛ́rɛnga ɔ̌ nɨ̌. Obhó tɨ́, ɨ̀nzɨ̌ nyɨ̌ nyapɛ́ dhu à’u ɨma ràrɨ̌ ndɨ yà ɨ̀’ɨ̀ arɨ́’ɨ̀ alɛ, nɨ́ nyɨ̌ nyʉ́vɛ ʉ̀vɛ̌ tɨ́ fʉ̀kʉ́ nzɛ́rɛnga ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pbàyàhúdí adʉ̀ dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Nyɨ nyʉ́, nyɨ nɨ́ àdhɨ?» Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨma nɨ́ yà mʉ̀hàngʉ́ ɔ̀ rɔ̀ ndɨ̀ napɛ̀na rɔ̀ ma marʉ́nɔna fʉ̌kʉ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ma mɨ́’ɨ̀ ábhɔ̌ dhu nyʉ́ nà okúkʉ dɔ̀ rɔ̀ ma mʉ́nɔna. Ndɨrɔ̀, ma mɨ́’ɨ̀ dʉ̀kʉ́ ma mádʉ̀ anya ɨ̀tdɨ̀ okúya dɔ̀ rɔ̀ dhu nà abhɔ nyʉ́. Pbɛ́tʉ̀, yà ɨma nívì alɛ náarʉ́nɔna dhu nɨ́ obhó dhu. Ndɨrɔ̀, ma márádʉ̀ ɔ̀vɔ̀nà yà adzɨ ɔ̌ alɛ tɔ̀ dhu nɨ́ kà-tsʉ̌ ma mɨ́rɨ̀ dhu.» ");
INSERT INTO niy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nɨ́ Pbàyàhúdí náadʉ̀ nzá dhu ʉ̀nɨ Àbanà Kàgàwà-okú dɔ̀ rɔ̀ kà ràrǔbhi ɔ̀tɛ rɔ̌ fɨ̌yɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ìndrǔ t’ídhùnà nʉ́tɔ̌ nyɨ̌ nyɨ́ mʉ̀sàlabhà dɔ̌ nɨ́nganɨ́ nɨ́ ndɨ nyɨ̌ nyʉnɨya dhu ma ràrɨ̌ ndɨ yà ɨ̀’ɨ̀ arɨ́’ɨ̀ alɛ. Ndɨrɔ̀, nyɨ̌ nyadʉ̀ya dhu ʉ̀nɨ, ɨ̀nzɨ̌ ma rarɨ́ atdí dhu mà nɔ́nzɨ ma mòzè ka dhu bhěyi, pbɛ́tʉ̀, ma marʉ́nɔna dhu ràrɨ̌ Àbadu Kàgàwà núudhè idù dhu kɛ̀lɛ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yà ɨma nívì Àbadu náarɨ́’ɨ̀ ìnè atdíkpá ma mànà. Kǔbhà nzá ma atdírɔ̀, yà ma márɔ́nzɨna bìlǐnganà dhu nɨ́ kà-nyɨ̀kpɔ́ nɔ́fɔ̀ dhu kɛ̀lɛ̌ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nɨ́rɔ̀ nɨ́ ndɨ wɔ̀ dhu bhěyi Yěsù ɔ̀tɛ̀ rɔ̀, ábhɔ̌ alɛ nyʉ́ náadʉ̀ kà’ù. ");
INSERT INTO niy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà yà ndɨ̀ nà’ù Pbàyàhúdí nɨ̌: «Nyɨ̌ nyapɛ́ yà ma mʉ̀nɔ̀ fʉ̌kʉ̀ dhu nɨ́fʉ̌, nɨ́ nyɨ̌ nɨ’ɨna obhó nyʉ́ pbàkà ábhàlɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nyɨ̌ nyɨ́ obhónga nʉ́nɨ̌, ndɨ obhónga ràdʉ̀ nyǎbhʉ nyɨ̌’ɨ̀ dʉ̀kʉ́ nyɨ̌-tɨ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nɨ́ kɔ̌kɔ̀ Pbàyàhúdí náadʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Mǎ nɨ́ Àbràhamʉ̀ bhà pbàdzʉkʉrʉ. Ndɨrɔ̀, mǎ mapɛ̀na nzá òko atdí alɛ bhà ɨnɔ mà tɨ́. Nɨ́ ádhu nyɨ nyátɨna, mǎ ràrɨ̌ mʉ̌gɛ̀rɛ̀ mɨ̌’ɨ̀ dɔ̀ká mǎ-tɨ́rɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Ndɨ alɛ náapɛ́ àmbɛ nzɛ́rɛnga nɔ́nzɨ̀ dɔ̌, nɨ́ ndɨ alɛ nɨ́ nzɛ́rɛnga tɔ́ ɨnɔ. ");
INSERT INTO niy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɨnɔ nɨ́ ɨ̀nzɨ̌ rádʉ̀ àdɨ ɨdzá alɛ nyʉ́ tɨ́ bìlǐnganà alɛ. Pbɛ́tʉ̀, alɛ t’ídhùnà nyʉ́ náarádɨ ɨdzá alɛ tɨ́ bìlǐnganà. ");
INSERT INTO niy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nɨ́rɔ̀, Kàgàwà t’ídhùnà nyʉ́ náapɛ́ àdʉ̀ nyǐpfo ɨnɔ-kàsʉ̌ ɔ̀ rɔ̀, nɨ́ nyɨ̌ nyádʉ̀ ɨ̀’ɨ̀ obhó tɨ́ dʉ̀kʉ́ nyɨ̌-tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma mʉ́nɨ wà dhu nyɨ̌ ràrɨ̌ Àbràhamʉ̀ bhà pbàdzʉkʉrʉ. Pbɛ́tʉ̀, nyɨ̌ nyarádʉ̀ mɔnɛ̀, ndɨ́nɨ̌ nyǎbhʉ̀ tɨ́ ma kohò, ɨ̀nzɨ̌ yà ma mʉ́nɔna dhu náarádʉ̀ ngari àbà afíkʉ ɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma marʉ́nɔna dhu nɨ́ Àbadu Kàgàwà bhà ma mála dhu. Pbɛ́tʉ̀, nyɨ̌ nyarɔ́nzɨna dhu nɨ́ yà àbakʉ nʉ́ʉnɔ fʉ̌kʉ̀ dhu.» ");
INSERT INTO niy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nɨ́ Pbàyàhúdí adʉ̀ dhu àdu Yěsù tɔ̀ ’àtɨ: «Àbakà nɨ’ɨ̀ Àbràhamʉ̀.» Nɨ́ kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyɨ̌ nyɨ́’ɨ̀yana gukyè Àbràhamʉ̀ bhà inzo nyʉ́ tɨ́, nɨ́ nyɨ̌ nyóngòyana Àbràhamʉ̀ anzɨ̀ kasʉ nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma mʉ́nɔ̀ yà Kàgàwà nɨ́ɨtɛ̀ idu obhó dhu fʉ̌kʉ̀. Pbɛ́tʉ̀, nyɨ̌ nyarádʉ̀ mɔnɛ̀ ndɨ́nɨ̌ nyɨ̌ nyǎbhʉ̀ tɨ́ ma kohò. Àbràhamʉ̀ náanzɨ̀ nzá dhu wɔ̀ nyɨ̌ nyarɔ́nzɨna dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyɨ̌ nyarɔ́nzɨna dhu nɨ́ àbakʉ arɔ́nzɨna dhu.» Nɨ́ abádhí adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Mǎ nɨ́ nzɨ̌ mʉ̀nyɔ̀nɨ̀ ɔ̌ ka kɔ́dhɨ̀ nzónzo. Àbakà rɨ̌’ɨ̀ atdí tɨ́. Ndɨ Àbakà nɨ́ Kàgàwà.» ");
INSERT INTO niy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Kàgàwà ɨ́’ɨ̀yana gukyè Àbakʉ tɨ́, nɨ́ nyɨ̌ nyózèyana ma òzè, Àbadhi-tɨ’ɔ̀ rɔ̀ ma mɨ́rà, ndɨrɔ̀ kǐvì ndɨ ɨma nɨ́dhunɨ̌. Ma mɨ́rà nzá ɔvɔ̀du dɔ̌ ma-tɨ́rɔ̀, pbɛ́tʉ̀ ɨma nívì nɨ̀ Àbadhi ndɨ̀tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nɨ́ ádhu ɨ̀nzɨ̌ ma mʉ́nɔna dhu náarɨ́ dʉ̀kʉ àlʉ̌ nɨ̌? Obhó tɨ́, kǎrɨ́ nzɨ̌ dʉ̀kʉ àlʉ̌, ɨ̀nzɨ̌ nyɨ̌ nyádʉ̀ fʉ̌kʉ̀ ma mʉ́nɔna dhu ɨ̀rɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyɨ̌ nɨ́ àbakʉ Pfɔ̀mvɔ bhà inzo. Ndɨrɔ̀, nyɨ̌ nyarózèna nyɔ̌nzɨ̀ dhu nɨ́ ndɨ àbakʉ ózè dhu kɛ̀lɛ̌. Mʉ̀hàngʉ́ ɔ̀ rɔ̀, àbadhi nɨ’ɨ̀ ìndrǔ-tsè ɔ̀tdɨ̀ arɨ́ alɛ. Kǎpɛ̀na nzá obhó dhu nʉ́nɔ akɛkpá màtɨ́, ɨ̀mbǎ obhónga náarɨ́’ɨ̀ kà ɔ̀ nɨ́dhunɨ̌. Tɨ̀tɔ̀ ʉ̀nɔ ndɨ̀ ndɨ́ rɔ̀, kǎrɔ́nzɨna dhu nɨ́ pbɨ̀ndà màndʉ nyʉ́. Obhó tɨ́, àbadhi nɨ́ tɨ̀tɔ̀ ʉ̀nɔ arɨ́ alɛ, ndɨrɔ̀ ka nɨ́ tɨ̀tɔ̀ t’ábanà. ");
INSERT INTO niy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pbɛ́tʉ̀ ɨma, ma marʉ́nɔna dhu nɨ́ obhó dhu. Nɨ́, ndɨ dhu-okú dɔ̀ rɔ̀ nyɨ̌ nyárɨ́ nzɨ̌ àdʉ̀ ma mʉ́nɔna dhu ná’ù. ");
INSERT INTO niy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ádhɨ pbá alɛ ndɨ nzínzìkʉ ɔ̌ rádʉ̀ pbàkà nzɛ́rɛnga nɨ́tɛ̀? Ádhu obhó dhu nʉ́nɔ ma mɨ́ fʉ̌kʉ̀ rɔ̀, nyɨ̌ nyárɨ́ nzɨ̌ àdʉ̀ ma mʉ́nɔna dhu ná’ù nɨ̌? ");
INSERT INTO niy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kàgàwà bhà inzo rǎdʉ̀ kàbhà ɔtɛ ɨ̀rɨ̀. Pbɛ́tʉ̀, nyɨ̌ nyárɨ́ nzɨ̌ kàbhà ɔtɛ ɨ̀rɨ̀, nyɨ̌ nɨ́ nzɨ̌ kàbhà inzo dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wɔ̀ dhu-dzidɔ̌, Pbàyàhúdí náadʉ̀ dhu àdu Yěsù tɔ̀ ’àtɨ: «Mǎ mʉ̀nɔ̀ obhó dhu nyʉ́, yà mǎ màtɨ nyɨ ràrɨ̌ Sàmàrɨyà tɔ́ pbìrì ɔ̌ alɛ, ndɨrɔ̀ nzɛ́rɛ-alafí ràrɨ̌’ɨ̀ ʉ̀nʉ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nzɛ́rɛ-alafí rɨ̌’ɨ̀ mbǎ ùdù. Ma márɨ́ Àbadu Kàgàwà nɨ́fʉ̌, pbɛ́tʉ̀ nyɨ̌ nyárɨ́ nzɨ̌ àdʉ̀ mɨfʉ. ");
INSERT INTO niy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma márɨ́ nzɨ̌ ìndrǔ rɨ̌ mɨfʉ̌ dhu nɔ́nɛ. Pbɛ́tʉ̀, ìndrǔ rɨ̌ mɨfʉ̌ dhu nɔ́nɛ arɨ́, ndàdʉ̀ ìndrǔ-ànyǎ ɨ̀tdɨ̀ atdí alɛ rɨ̌’ɨ̀ ìnè. ");
INSERT INTO niy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀. Ndɨ alɛ náapɛ́ ma mʉ́nɔna dhu nɨ́fʉ̌, nɨ́ ndɨ alɛ náalaya nzɨ̌ ɔvɛ-ngbɔ̀ akɛkpá màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nɨ́ Pbàyàhúdí adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ɔ̀tsɔ̀! Kòmbí nga nɨ́ ndɨ mǎ mà’ù dhu ìnè nzɛ́rɛ-alafí ràrɨ̌’ɨ̀ ʉ̀nʉ̀ nɨ̌. Àbràhamʉ̀ náavɛ̀ wà, ndɨrɔ̀ Kàgàwà bhà pbànábí mà nʉ́ʉvɛ̀ wà átɔ̀. Nɨ́ nyɨ nyádʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi nyɨ nyʉ́nɔna dhu nɨ́fʉ̌ rɨ́ alɛ ralaya nzɨ̌ ɔvɛ-ngbɔ̀ akɛkpá màtɨ́? ");
INSERT INTO niy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nyɨ tɨ́ ádrʉ̀ngbǎlɛ nyʉ́, ròsè yà àvǎvɛ̀ abhukà Àbràhamʉ̀ dɔ̀nǎ? Ndɨrɔ̀, Kàgàwà bhà pbànábí mà nʉ́ʉvɛ̀ wà átɔ̀. Nɨ́ nyɨ nyʉ́, nyɨ nyɔ́zʉ̀ nyɨ àdhɨ tɨ́?» ");
INSERT INTO niy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Dhu ɨ́’ɨ̀yana gukyè ma-tɨ́rɔ̀ ma márɨ́ mɨfʉ̌ dhu tɨ́, nɨ́ ndɨ ɨfʉta nɨ́’ɨ̀yana mbǎ tɨ̌na nà. Pbɛ́tʉ̀, mɨfʉ̌ arɨ́ nɨ́ Àbadu Kàgàwà, yà nyɨ̌ nyarátɨna fʉ̀kʉ́ Kàgàwà tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nyɨ̌ nyʉ́nɨ nzá Àbadhi, pbɛ́tʉ̀ ma mʉ́nɨ wà ka. Ma mapɛ́ àdʉ̀ àtɨ̀nà ɨnzá ma rʉ́nɨ ka, nɨ́ ma nádʉ̀ ɨ̀’ɨ̀ ɨwà ma mòngò tɨ̀tɔ̀tálɛ tɨ́ átɔ̀ nyɨ̌ bhěyi. Pbɛ́tʉ̀ ma mʉ́nɨ wà ka, ndɨrɔ̀ ma márɨ́ kà bhà ɔtɛ nɨ́fʉ̌. ");
INSERT INTO niy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abhukʉ Àbràhamʉ̀ nʉ́ʉnɨ dhu, àhʉ̌ ndɨ̀ raraya àhʉ ma mɨ́rà yà adzɨ ɔ̌ ɔ̀ná ɨdhɔ ɔ̀. Nɨ́ ndɨ ɨdhɔ ndɨ̀ ndàla pbɨ̀ndà a’uta ɔ̌ rɔ̀, kɨ̌dhɛ̀ nɨ́ɨka ndɨ̀ atdídɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nɨ́ Pbàyàhúdí adʉ̀ dhu ìvu Yěsù-tsʉ̌ ’àtɨ: «Nyɨ nyʉ́, nyɨ nyàpɛ̀ nzá imbò kumì atɔ mà nísě. Nɨ́, nyɨ nyala tɨ́ àlǎ Àbràhamʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Ɨnzá ka kàpɛ̀ Àbràhamʉ̀ nʉ́gʉ rɔ́rɔ̀, ma mɨ’ɨ̀ ìnè.» ");
INSERT INTO niy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nɨ́rɔ nɨ́ ndɨ, Pbàyàhúdí náadʉ̀ ’ɔ̀pɛ̀ ’ʉ̀wǎ odu, ndɨ́nɨ̌ ɨ̀ ubvú tɨ́ ka nɨ̌. Pbɛ́tʉ̀, kǎdʉ̀ ndòrù dòtsí, ndàdʉ̀ àhʉ Kàgàwà bhà ɨdza ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Otu ɔ̌ ɨ̀ ówu pbɨ̀ndà ábhàlɨ̌ mànà rɔ́rɔ̀, Yěsù ala ndùmùndúmú tɨ́rɔ̀ ka kʉgʉ atdí alɛ. ");
INSERT INTO niy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nɨ́ kàbhà ábhàlɨ̌ náadʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Màlimǒ, ádhɨ nzɛ́rɛnga nanzɨ̀ ndɨ́nɨ̌ wɔ̀rɨ́ alɛ nabhʉ̀ tɨ́ kʉgʉ̀ ndùmùndúmú tɨ́rɔ̀? Tɨ́ ka nyʉ́ ndɨ ndɨ̀tɨ́rɔ̀ nzɛ́rɛnga nanzɨ̀? Ndɨrɔ̀ ngǎtsi nɨ̌, tɨ́ kà t’ábanà mà kà-tsánà mànà ɨ nzɛ́rɛnga nanzɨ̀?» ");
INSERT INTO niy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ nɨ́ àbadhi bhà nzɛ́rɛnga mà ndɨ, ndɨrɔ̀ ɨ̀nzɨ̌ nɨ́ kà t’ábanà mà kà-tsánà mànà tɔ́ nzɛ́rɛnga mà ndɨ. Pbɛ́tʉ̀, wɔ̀rɨ́ dhu anzɨ̀ ndɨ̀ kà-rɔ̌ ndɨ́nɨ̌ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ náavì tɨ́ ndɨ̀ kà-nyʉtsì. ");
INSERT INTO niy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nɨ́, dhu àkǎ àlɛ̌ rɔ̀nzɨ̀ yà ma nívì alɛ bhà kasʉ àdɨ̀ ɨnga àdɨ̀ adyíbhengá nga tɨ́ rɔ́. Kɔ̀nɨ̌ ɨnga rɨ̌rà ndɨ́nɨ̌ ndatɨ̀ tɨ́, yà ɨ̀nzɨ̌ atdí alɛ mà rǎdʉ̀ kasʉ ɔ̀nzɨ̀ iku ɔ̌ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yà àdɨ̌ ma màdɨ yà adzɨ dɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, ɨma nɨ́ ndɨ yà adzɨ ɔ̌ awáwʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wɔ̀ dhu bhěyi ndɨ̀ ndɔ̀tɛ̀ dhu-dzidɔ̌, Yěsù isò ɨsɔ obvò, ndàdʉ̀ ɔtdɔ nɔ́bhɔ̀lɔ̀ ndɨ ɨsɔ nɨ̌. Tdɨ́tdɔ̌, kǎdʉ̀ ndɨ ɔtdɔ nídyì ndàbòlǒ, ndàdʉ̀ àtrinà wɔ̀ ndùmùndúmú-nyɨ̀kpɔ́ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kǎdʉ̀ àtɨ̀nà kà nɨ̌: «Árà nyu’o nyɨ̀kpɔ́nʉ Sìlòamù tɨ́ kátɨna ùye ka kúyè ɨdha ɔ̀.» (Silòamù-tɨ̀ nɨ́: ìvì tɨ́ ka kívì alɛ.) Nɨ́ wɔ̀ ndùmùndúmú arà ɨdha ɔ̀, ndàdʉ̀ nyɨ̀kpɔ́na nú’o. Nɨ́, ányɨ̀rɔ̀ kà rɨ̌ ndàdǔ rɔ̀, kǎdʉ̀ ndɔ̀pɛ̀ ndàla ɨnga mběyi. ");
INSERT INTO niy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nɨ́, yà atdíkpá abádhí aróko mànà alɛ mà, yà kàlǎ arɨ́ dhu ùnzǐ rɨ́ ìndrǔ-fɔ́ rɔ́ alɛ mànà, náapɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá, ’àmbɛ àtɨ̀nà dɔ̌: «Tɨ́ obhó yà obvò arádɨ, ndàmbɛ dhu ùnzi dɔ̌ ìndrǔ-fɔ́ alɛ yà?» ");
INSERT INTO niy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Atdídhená alɛ náambɛ́nà àtɨ̀nà dɔ̌: «Ka nyʉ́ nɨ́ yà,» ngʉ̌kpà ràdʉ̀ àtɨ̀nà: «Tɨ̀tɔ̀! Ɨ̀nzɨ̌ nɨ́ ka wɔ̀! Kà mà ɔ́fɔ̀ ɨ̀ nà alɛ nɨ́ wɔ̀.» Pbɛ́tʉ̀, wɔ̀ ndùmùndúmú náadʉ̀ dhu à’ù ndɨ̀tɨ́rɔ̀, ndàtɨ: «Ɨma nyʉ́ nɨ́ yà.» ");
INSERT INTO niy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nɨ́ kɔ̀rɨ́ alɛ adʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Olu, nyɨ̀kpɔ́nʉ nyʉ́ nʉ́ngbɛ ɨ̀ ɨ̀ngbǎ dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nɨ́ kǎdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yěsù tɨ́ kátɨna alɛ nɨ́ ndɨ ɔtdɔ nàbòlǒ, ndàtri nyɨ̀kpɔ́du rɔ̌, ndàdʉ̀ àtɨ̀nà ma nɨ̌, ma ràra maru’o nyɨ̀kpɔ́du Sìlòamù ɔ̀. Nɨ́ ma màrà ányɨ̀, mu’o nyɨ̀kpɔ́du, madʉ̀ mɔpɛ̀ mala ɨnga dòtsí.» ");
INSERT INTO niy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kɔ̀rɨ́ alɛ adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌ ’àtɨ: «Wɔ̀ ndɨ alɛ rɨ̌’ɨ̀ ɨ̀ngbɔrɔ́?» Nɨ́ kǎdʉ̀ dhu àdu, ndàtɨ: «Ɨnzá ma mʉ̀nɨ.» ");
INSERT INTO niy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wɔ̀ dhu-dzidɔ̌, ka kadʉ̀ òwu wɔ̀rɨ́ alɛ nà, kowù ùvònà Pbàfàrìsáyó-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Obhó tɨ́, wɔ̀ Yěsù àbòlǒ ɔtdɔ, ndʉ̀ngbɛ ndùmùndúmú-nyɨ̀kpɔ́ nɨ̌ ɔ̀ná ɨdhɔ nɨ’ɨ̀ sàbatʉ̀-ɨdhɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, Pbàfàrìsáyó mà átɔ̀ níivú dhu wɔ̀rɨ́ alɛ-tsʉ̌ ’àtɨ: «Nyɨ̀kpɔ́nʉ nyʉ́ nʉ́ngbɛ-ndɨ̀ ɨ̀ngbǎ dhu bhěyi?» Nɨ́ kǎdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yěsù ìdyì ɔtdɔ ɔtsʉ́na-kpɔ̀ rɔ̌, ndàtri nyɨ̀kpɔ́du rɔ̌, madʉ̀ àrà nyɨ̀kpɔ́du nú’o ɨdha ɔ̀. Nɨ́, kòmbí ma mɨ́ ɨnga nálǎ àlǎ.» ");
INSERT INTO niy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nɨ́ Pbàfàrìsáyó nzínzì ɔ̌ atdídhená alɛ náadʉ̀ àtɨ̀nà: «Wɔ̀rɨ́ dhu nɔ̀nzɨ̀ alɛ nɨ́rà nzá Kàgàwà bhà rɔ̀, ɨnzá kɨ̀fʉ sàbatʉ̀-ɨdhɔ̀ nɨ́dhunɨ̌.» Pbɛ́tʉ̀, ngʉ̌kpà-tsí náadʉ̀ àtɨ̀nà: «Nzɛ́rɛngatálɛ rǎdʉ̀ wɔ̀rɨ́ wɨwɨ̀-tɨdɔ̀ nɔ́nzɨ̀ ɨ̀ngbǎ dhu bhěyi?» Wɔ̀ dhu adʉ̀ abádhí-ɔ̌nga nábhʉ rʉ̀ndɔ̀ ndɨ̀ ʉ̀ndɔ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nɨ́ Pbàfàrìsáyó adʉ̀ dhu ìvu tdɨ́tdɔ̌ wɔ̀ ɨ̀gʉ̌ Yěsù ɨ̀gʉ̌ ndùmùndúmú-tsʉ̌, ’àtɨ: «Olu ɨnyɨ nyʉ́, nyɨ nyátɨna ɨ̀ngbǎ tɨ́ wɔ̀ nyɨ̀kpɔ́nʉ nàbhʉ rʉ̀ngbɛ ɨ̀ alɛ nɨ̌?» Nɨ́ kǎdʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ. «Wɔ̀rɨ́ alɛ nɨ́ Kàgàwà bhà nabì.» ");
INSERT INTO niy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pbɛ́tʉ̀, ɨ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ núuvó ɨ̀ dòtsí ɨ̀nzɨ̌ à’ù dhu, wɔ̀rɨ́ alɛ rɨ́’ɨ̀ ndùmùndúmú, nɨ́ kà rɔ̀pɛ̀ wà ndàla nga kòmbí. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, abádhí núunzi kà t’ábanà mà, kàtsánà mànà rìwǔ. ");
INSERT INTO niy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nɨ́ abádhí ìwǔ ùvò rɔ̀, ɨ ádrɔ̀drɔ̌ alɛ níivú dhu, ’àtɨ: «Tɨ́ yà ndùmùndúmú tɨ́rɔ̀ ka kʉgʉ dhu tɨ́ nyɨ̌ nyarátɨna idhùkʉ nyʉ́ yà? Olu kàdʉ̀ ndɔ̀pɛ̀ ndàla nga ɨ̀ngbǎ dhu bhěyi kòmbí?» ");
INSERT INTO niy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nɨ́ wɔ̀ ndùmùndúmú t’ábanà mà, kàtsánà mànà náadʉ̀ dhu àdu abádhí tɔ̀ ’àtɨ: «Mǎ nyʉ́, mǎ mʉ̀nɨ dhu nɨ́, yàrɨ́ nɨ́ idhùkà nyʉ́. Ndɨrɔ̀, mǎ mʉgʉ ka ndùmùndúmú tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pbɛ́tʉ̀, kàdʉ̀ ndɔ̀pɛ̀ ndàla nga ɨ̀ngbǎ dhu bhěyi màtɨ́ kòmbí dhu nɨ́ mǎ mʉ̀nɨ nzá. Ndɨrɔ̀, àdhɨ mà nábhʉ kà-nyɨ̀kpɔ́ rʉ̀ngbɛ ɨ̀ dhu mǎ mʉ̀nɨ nzá. Àbadhi nɨ́ ɨwà óvì alɛ. Nɨ́ nyìvǔ dhu kà-tsʉ̌, ndɨ́nɨ̌ kǎdʉ̀ tɨ́ rɔ̀ná dhu àwɛ ndɨ̀tɨ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kà t’ábanà mà, kàtsánà mànà náadù dhu wɔ̀ dhu bhěyi Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ tɔ̀, abádhí-ɔdɔ̀ nɔ́nzɨ ɨ̀ ɨ́ dhu-okú dɔ̀ rɔ̀. Obhó tɨ́, ɨ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nɨ’ɨ̀ ɨwà ɨ̀ nɨ́rɨ̀ angyangyɨ ndɨ́nɨ̌ ɨ̀ ongó tɨ́ Yěsù nàtɨ̀ Krɨ́stɔ̀ tɨ́ ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà nípfo, ’òdì unduta-dzà ɔ̌ rɔ̀, ɨ̀nzɨ̌ kadʉ̀ ɔ̀zʉ̀nà Mʉ̀yàhudì tɨ́ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, wɔ̀ ndùmùndúmú t’ábanà mà, kà-tsánà mànà náadʉ̀ àtɨ̀nà Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nɨ̌: «Àbadhi nɨ́ ɨwà óvì alɛ, nɨ́ nyìvǔ dhu kà-tsʉ̌ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nɨ́ ɔyɔ rɨ́ kìsě nɨ̌, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náanzi wɔ̀ ndùmùndúmú tɨ́ arúbhi ɨ̀’ɨ̀ rɔ̀ alɛ, ’àdʉ̀ dhu ɔ̀vɔ̀ fɨ̌ndà ’àtɨ: «Ɔ́tsɔ pɛ́ dhu Kàgàwà-ɔ̀nzɨ̌, nyɨ ràrɨ̌ obhó dhu nyʉ́ nʉ́nɔ. Mǎ nyʉ́, mǎ mʉ́nɨ wà dhu wɔ̀rɨ́ alɛ ràrɨ̌ nzɛ́rɛngatálɛ.» ");
INSERT INTO niy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nɨ́ wɔ̀rɨ́ alɛ adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nzɛ́rɛngatálɛ mà tɨ́ kà rɨ̌’ɨ̀ dhu ma mʉ̀nɨ nzá. Pbɛ́tʉ̀, ʉ̀nɨ̌ tɨ́ ma mʉ̀nɨ atdí dhu nɨ́, ɨma nɨ’ɨ̀ ndùmùndúmú, nɨ́ kòmbí ma mɨ́ ɨnga nálǎ àlǎ.» ");
INSERT INTO niy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nɨ́ abádhí adʉ̀ dhu ìvu wɔ̀rɨ́ alɛ-tsʉ̌ ’àtɨ: «Ádhu nyʉ́ wɔ̀rɨ́ alɛ nɔ́nzɨ̀ ɨndʉ̀? Kàbhʉ nyɨ̀kpɔ́nʉ rʉ̀ngbɛ ndɨ̀ ɨ̀ngbǎ dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɨ́ kǎdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma màwɛ wà wɔ̀ dhu fʉ̌kʉ̀, pbɛ́tʉ̀ nyɨ̌ nyàdʉ̀ nzá ma mʉ́nɔna dhu ɨ̀rɨ̀. Nɨ́ ádhu nyɨ̌ nyòzè mawɛ nyɨ̌rɨ̀ tdɨ́tdɔ̌? Nyɨ̌ nyòzè tɨ́ nzá wà nyǒngò átɔ̀ kàbhà ábhàlɨ̌ tɨ́?» ");
INSERT INTO niy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nɨ́rɔ̀ nɨ́ ndɨ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nʉ́ʉnɔ dhu wɔ̀rɨ́ alɛ nɨ̌ ’àtɨ: «Ɨnyɨ nyʉ́, nyɨ nɨ́ ndɨ kàbhà ábhàlɨ̌. Pbɛ́tʉ̀ mǎ, mǎ’ɨ nɨ́ Músà bhà ábhàlɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mǎ nyʉ́, mǎ mʉ́nɨ wà dhu Kàgàwà mà ratɛ̀ Músà nà. Pbɛ́tʉ̀, àdhà rɔ̀ màtɨ́ wɔ̀rɨ́ alɛ́ ɨ́rà dhu mǎ mʉ̀nɨ nzá.» ");
INSERT INTO niy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nɨ́ wɔ̀ alɛ adʉ̀ àtɨ̀nà kɔ̌kɔ̀ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nɨ̌: «Hɔ̀kɔ̀! Kɔ̀nɨ̌ ɨdhɔ rɨ̌ ìndrǔ ʉ̀kɔ̌ nɨ̌ dhu nyʉ́ nɨ́ ndɨ wɔ̀, wɔ̀ nyɨ̌ nyátɨna ɨnzá nyɨ̌ rʉ̀nɨ àdhà rɔ̀ màtɨ́ kɨ̌rà dhu. Pbɛ́tʉ̀ nyɨ̀kpɔ́dǔ na kʉ̀ngbɛ wà! ");
INSERT INTO niy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mǎ mʉ̀nɨ ɨwà dhu, Kàgàwà ràrɨ̌ nzɨ̌ àdʉ̀ nzɛ́rɛngatálɛ tɔ́ ɨtsɔ̀ta nɨ́rɨ̀. Pbɛ́tʉ̀, ka rǎdʉ̀ pbɨ̀ndà ɨtsɔ̀ta nɨ́rɨ̀ alɛ nɨ́, pbɨ̀ndà Ʉyátá nɨ́fʉ̌ arɨ́, ndàdʉ̀ ndɨ̀ ndózè dhu ɔ̀nzɨ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yà mʉ̀hàngʉ́ ɔ̀ rɔ̀ ndɨ̀ napɛ̀na rɔ̀, ka kapɛ̀na nzá dhu ɨ̀rɨ atdí alɛ mà rʉngbɛ yà àdhɨ tɨ́ ka kadhɨ̀ ndùmùndúmú tɨ́rɔ̀ alɛ-nyɨ̀kpɔ́. ");
INSERT INTO niy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɨ̀nzɨ̌ dhu ɨ́’ɨ̀ná gukyè Kàgàwà bhà rɔ̀ wɔ̀rɨ́ alɛ ɨ́rà dhu tɨ́, nɨ́ kàmbɛ̀nà nzɨ̌ atdí dhu mà nɔ́nzɨ.» ");
INSERT INTO niy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nɨ́rɔ̀ nɨ́ ndɨ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ adʉ̀ dhu ìvu wɔ̀rɨ́ alɛ-tsʉ̌, ’àtɨ: «Ɨnyɨ nyʉ́, ɨnyɨ ka kadhɨ̀ ɔ̀dhɨ tɨ́ ngbùlǔnʉ nyʉ́ mànà pbʉ̀kʉ̀ nzɛ́rɛnga ɔ̌. Nɨ́ nyɨ tɨ́ ndɨ àdʉ̀ dhu ùdhe fǎkà?» Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ kìpfo, ràhʉ unduta-ɨdzà ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yěsù itdègu Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nípfo wɔ̀rɨ́ alɛ iri unduta-ɨdzà ɔ̀ rɔ̀ dhu nɨ́rɨ, nɨ́ kǎrà ndɨ alɛ-tɨ’ɔ̀, ndàdʉ̀ ìtsi àtɨ̀nà kà nɨ̌: «Ɨnyɨ nyʉ́, nyɨ nyá’ù tɨ́ wà Ìndrǔ t’ídhùnà?» ");
INSERT INTO niy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nɨ́, kǎdʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Màlimǒ, ádhɨ pbá alɛ ndɨ, ndɨ́nɨ̌ ma madʉ̀ tɨ́ à’ùnà?» ");
INSERT INTO niy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɨ́ Yěsù adù dhu kàtɔ̀, ndàtɨ: «Nyɨ nyàla wà ka! Ndɨrɔ̀ ka nɨ́ yà nyɨ̌ nyɔ́tɛ nà kòmbí alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nɨ́, wɔ̀ alɛ adʉ̀ dhu ɔ̀vɔ̀ kpangba Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨwà ma mà’ù nyɨ.» Kǎdʉ̀ ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌ Yěsù-ɔ̀nzɨ̌, ndɨ̀fʉ ka. ");
INSERT INTO niy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Ma mɨ́rà yà adzɨ ɔ̌, ndɨ́nɨ̌ ma mʉnɔ tɨ́ yà adzɨ ɔ̌ alɛ-ànyǎ. Ma mɨ́rà, ndɨ́nɨ̌ yà adzɨ ɔ̌ ndùmùndúmú nɔ́ɔpɛ́ tɨ́ ’àla nga, yà ɨnga àlǎ arɨ́ alɛ ràdʉ̀ ’ʉ̀gɛ̀rɛ̀ ’òngò ndùmùndúmú tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nɨ́rɔ̀ nɨ́ ndɨ yà Yěsù mà ɨ̀’ɨ̀ mànà atdíkpá ngúfe Pbàfàrìsáyó náadʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Mǎ nyʉ́ mà, mǎ nátɨ́ ndùmùndúmú átɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ nyʉ́nɨ̌yana gukyè dhu nyɨ̌ ràrɨ̌ ndùmùndúmú, nɨ́ ka kàmbɛ̀nà nzɨ̌ àtɨna nyɨ̌ ràrɨ̌’ɨ̀ nzɛ́rɛnga nà. Pbɛ́tʉ̀ kòmbí nyɨ̌ nyarádʉ̀ àtɨ̀nà àlǎ nyɨ̌ rarɨ́ ɨnga àlǎ. Nɨ́ ka kʉ̀nɨ wà dhu, fʉ̀kʉ́ nzɛ́rɛnga ràrɨ̌’ɨ̀ otùna nyʉ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ kɔ̌kɔ̀ Pbàfàrìsáyó nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀. Ɨ̀nzɨ̌ arótsù kàlɨ̀-lí, tàmà tɔ́ kàlɨ̀ ɔ̀ alɛ, pbɛ́tʉ̀ yà kàlɨ̀ dɔ̀nǎ arúpo ndɔ̀yɔ̀ ndɨ̀ kàlɨ̀ ɔ̀ alɛ nɨ́ ogbotálɛ, ndɨrɔ̀ ka nɨ́ ɔbɨ nɨ̌ arɨ́ dhu ʉ̀dhǎ ìndrǔ-fɔ́ rɔ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pbɛ́tʉ̀, yà kàlɨ̀-lí arótsù alɛ nɨ́ ndɨ tàmà ʉ̀nda arɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kà tɔ̀ nga nɨ́ ndɨ kàlɨ̀-li’ɔ̀ ɔ̀dɔ arɨ́ alɛ rǎdʉ̀ kàlɨ̀-átʉ̀ ʉ̀ngbɛ kà ròtsù ɔ̀ná kàlɨ̀ ɔ̀, tàmà ràdʉ̀ kʉ̀nɨ tǔna rɔ̌ nɨ̌. Nɨ́, kà rǎdʉ̀ pbɨ̀ndà tàmà nyʉ́ núnzì ɔvɔ̀ya rɔ̌, ndàdʉ̀ ìpfonà rùvò kàlɨ̀ ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nɨ́ kɔ́rɔ́ ndɨ̀ ndìpfo pbɨ̀ndà tàmà, rùvò kàlɨ̀ ɔ̀ rɔ̀ dhu-dzidɔ̌, kà rǎdʉ̀ àdɨ ndàmbɛ àrà dɔ̌ angyi abádhí dɔ̀-tsírɔ́, abádhí ràdʉ̀ ’ɔ̀dhɔ̀ owùna ɔ̌, kà-tù ɨ̀ ʉ̀nɨ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tàmà rɨ̌ nzɨ̌ àdʉ̀ òwu olo tɨ́ rɨ́’ɨ̀ alɛ-owù ɔ̌, pbɛ́tʉ̀ abádhí rǎdʉ̀ òtse òtse tɨ́ kà-tsʉ̌ rɔ̀, ɨnzá ɨ̀ ʉ̀nɨ kà-tù nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yěsù ʉnɔ wɔ̀rɨ́ mbólí Pbàfàrìsáyó tɔ̀, pbɛ́tʉ̀ wɔ̀ kʉ̀nɔ̀ abádhí tɔ̀ dhu náadʉ̀ nzá abádhí-dɔ nálʉ. ");
INSERT INTO niy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀, ɨma nɨ́ ndɨ tàmà tɔ́ kàlɨ̀ tɔ́ tsǎtsʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kɔ́rɔ́ alɛ yà angyinǎ rɔ̀ íwǔ idù nɨ́’ɨ̀ ogbotálɛ, ndɨrɔ̀ ɔbɨ nɨ̌ arɨ́ dhu ʉ̀dhǎ ìndrǔ-fɔ́ rɔ̀ alɛ. Pbɛ́tʉ̀, tàmà ádʉ̀ nzá abádhí-tù nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nɨ́, ɨma nɨ́ ndɨ kàlɨ̀ tɔ́ tsǎtsʉ̀. Ndɨ alɛ náapɛ́ ìtsù ùdunǎ, nɨ́ rǎdʉ̀ ɔ̀gʉ̀ ɔ̀gʉ̀. Kà rǎdʉ̀ òtsù kàlɨ̀ ɔ̀, ndàdʉ̀ àhʉ kàlɨ̀ ɔ̀ rɔ̀. Ndɨrɔ̀ kà rǎdʉ̀ ɔ̀nyʉ̀ nábà àbà. ");
INSERT INTO niy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ogbotálɛ náarɨ́rà dhu kɛ̀lɛ̌ ndɨ̀ nduwé tɨ́. Ndɨrɔ̀ kǎrɨ́ ɨ̀rà, ndɨ́nɨ̌ ndɨ̀ ndɔkyɛ tɨ́ dhu, ndàdʉ̀ dhu ɨ̀nza. Pbɛ́tʉ̀ ɨma nyʉ́, ma mɨ́rà ndɨ́nɨ̌ ìndrǔ abá tɨ́ ípìrɔ̌nga, ndɨrɔ̀ ndɨ́nɨ̌ abádhí abá tɨ́ ka abhɔ nyʉ́ ròsè. ");
INSERT INTO niy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ɨma nɨ́ ídzì ʉndataba. Ídzì ʉndataba náarɨ́ pbɨ̀ndà ípìrɔ̌nga nádzǐ ɔvɛ tɔ̀ pbɨ̀ndà tàmà-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tàmà ʉ̀nda arɨ́ ndɨ́nɨ̌ ka kubhò tɨ́ ndɨ̀ alɛ nɨ́ nzɨ̌ tàmà-àbadhi. Kǎpɛ́ nyàmǎsɔ̀ rɨ̌rà dhu nálǎ, nɨ́ kà rǎdʉ̀ ɔ̀kʉ tɨ́ ɔ̀kʉ, ndàdʉ̀ tàmà ʉ̀bhà vǐyà dɔ̌ rɔ̀. Nɨ́, nyàmǎsɔ̀ rǎdʉ̀ atdídhená tàmà nʉ́mbà ndàrà nà, ndàdʉ̀ ngʉ̌kpà-ɔ̌nga nɨ́fàlà. ");
INSERT INTO niy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Obhó tɨ́, fʉ̀rangà-okú dɔ̀ rɔ̀ rɨ́ kasʉ ɔ̀nzɨ alɛ, náafí àtdu tàmà rʉ̌vɛ dhu rɨ̌ nzɨ̌ àdʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ɨma nɨ́ ndɨ ídzì ʉndataba. Ma mʉ́nɨ wà pbàkà tàmà, ndɨrɔ̀ pbàkà tàmà nʉ́nɨ wà ma. ");
INSERT INTO niy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Àdhàdhɨ̀ Àbadu nʉ́nɨ ma, madʉ̀ Àbadu nʉ́nɨ dhu bhěyi, ma mádzi wà pbàkà ípìrɔ̌nga ɔvɛ tɔ̀ pbàkà tàmà-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndɨrɔ̀, ma mɨ́’ɨ̀ ìnè ngʉ̌kpà pbàkà tàmà nà, kǎkà ɨ̀mbǎ rɨ́’ɨ̀ yàrɨ́ kàlɨ̀ ɔ̀. Nɨ́, ma màkǎ marà ɨ tsí nídì átɔ̀ madu kàlɨ̀ ɔ̀. Abádhí rǎdʉ̀ tǔdu ɨ̀rɨ̀ ɨ̀rɨ. Ndɨ dhu bhěyi nɨ́ ndɨ, tàmà tɔ́ màhò rǎdʉ̀ ɨ̀’ɨ̀ atdí tɨ́, ʉ̀ndana rɨ́ alɛ ràdʉ̀ ɨ̀’ɨ̀ atdí tɨ́ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Àbadu ózè ma, pbàkà ípìrɔ̌nga ma mádzi ɔvɛ tɔ̀, ndɨ́nɨ̌ madʉ̀ya tɨ́ àbànà tdɨ́tdɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pbàkà ípìrɔ̌nga nódyì rɨ́ atdí alɛ mà rɨ̌’ɨ̀ mbǎ, pbɛ́tʉ̀, ma mɨ́ pbàkà ípìrɔ̌nga nádzǐ ma-tɨ́rɔ̀ ɔvɛ tɔ̀. Ma mɨ́’ɨ̀ ìnè ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà madzi pbàkà ípìrɔ̌nga ɔvɛ tɔ̀, ndɨrɔ̀ ma mɨ́’ɨ̀ ìnè ɔbi nà mabà ndɨ ípìrɔ̌nga tdɨ́tdɔ̌. Wɔ̀rɨ́ nɨ́ ndɨ Àbadu nʉ́yǎ idù dhu.» ");
INSERT INTO niy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nɨ́ wɔ̀ Yěsù ʉ̀nɔ̀ ɔtɛ-okú dɔ̀ rɔ̀, Pbàyàhúdí-ɔ̌nga náadʉ̀ ndʉ̀ndɔ̀ ʉ̀ndɔ tɨ́ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abádhí nzínzì ɔ̌, ábhɔ̌ alɛ nyʉ́ náambɛ́nà àtɨ̀nà dɔ̌: «Ìnè pfɔ̀mvɔ rɨ̌’ɨ̀ yàrɨ́ alɛ ɔ̀. Àrǐ rɨ̌’ɨ̀ kà dɔ̌. Nɨ́ ádhu nyɨ̌ nyɨ́ kà-tsʉ̌ dhu ɨ̀rɨ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pbɛ́tʉ̀ ngʉ̌kpà-tsí ambɛ́nà àtɨ̀nà dɔ̌: «Ɨ̀nzɨ̌ pfɔ̀mvɔ rɨ̌’ɨ̀ ɔ̀nà alɛ rǎdʉ̀ ɔ̀tɛ wɔ̀ dhu bhěyi. Pfɔ̀mvɔ tɨ́ àdʉ̀ ndùmùndúmú-nyɨ̀kpɔ́ ʉ̀ngbɛ ʉ̀ngbɛ̌?» ");
INSERT INTO niy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̌, Pbàyàhúdí náambɛ́nà yà Kàgàwà bhà ɨdza ka kitsu tdɨ́tdɔ̌ dhu nɨ́rɛ̀ ka kongónà nɨ̌ mʉ̀hɛndʉ̀ nɔ́nzɨ̀ dɔ̌. Ndɨ kàsʉmɨ̀ nɨ’ɨ̀ ádrʉ̀ngbǎ gìrì tɔ́ kàsʉmɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nɨ́ ndɨ ɨdhɔ̀ ɔ̌, Yěsù ambɛ́nà ùbhi dɔ̌ Kàgàwà bhà ɨdza-lí, «Sɔ̀lɔ̀mɔnɨ̀ bhà mbàrazà» tɨ́ kátɨna mbàrazà-tsìnǎ. ");
INSERT INTO niy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nɨ́ ngúfe Pbàyàhúdí andu ɨ̀, ’àkpɔ̀rɔ̀ kà-ngbɔ̀, ’àdʉ̀ dhu ìvu kà-tsʉ̌, ’àtɨ: «Nyɨ nyʉ́, nyɨ nyabhʉ̀ya afíka ràgʉ̀rʉ̀ ndɨ̀ ràrà àhʉ ìfe ɨdhɔ tɨ́? Nyɨ nyapɛ́ ɨ̀’ɨ̀ Krɨ́stɔ̀ nyʉ́ tɨ́, nɨ́ ɔ́vɔ pɛ́ ndɨ dhu kpangba fǎkà.» ");
INSERT INTO niy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nɨ́ Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mɔ́vɔ̀ wà wɔ̀ dhu fʉ̌kʉ̀, pbɛ́tʉ̀ nyɨ̌ nyá’ù nzá ndɨ dhu. Yà Àba Kàgàwà-ɔvɔ̀ rɔ̌ ma márɔ́nzɨna wɨwɨ̀, náarɨ́ ndɨ àdhɨ-pbá alɛ màtɨ́ ma mɨ́’ɨ̀ dhu nɨ́tɛ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pbɛ́tʉ̀, nyɨ̌ nyárɨ́ nzɨ̌ ndɨ dhu ná’u, ɨ̀nzɨ̌ nárɨ́ nyɨ̌ pbàkà tàmà nzínzì ɔ̌ tàmà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Pbàkà tàmà náarɨ́ tǔdu ɨ̀rɨ ɨ̀rɨ. Ma mʉ́nɨ wà abádhí, ndɨrɔ̀ abádhí náarádʉ̀ owùdu nʉ́ngʉ. ");
INSERT INTO niy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ndɨrɔ̀, ma mɨ́ dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ̌ owùdu nʉ́ngʉ alɛ tɔ̀. Nɨ́ abádhí núuwíya nzɨ̌ akɛkpá màtɨ́ afíya ɔ̀nǎ rɔ̀. Ndɨrɔ̀, atdí alɛ mà nʉ́ʉdháya nzɨ̌ abádhí fudú rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Àba Kàgàwà yà abádhí nibho fudú, nɨ́ ádrʉ̀ngbǎlɛ ròsè kɔ́rɔ́ alɛ dɔ̀nǎ. Ndɨrɔ̀, atdí alɛ mà rɨ̌’ɨ̀ ɨ̀mbǎ ɔbɨ nà ndɨ̀dhǎ atdí dhu mà Àbadu-fɔ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ɨma, Àbadu Kàgàwà mànà, mǎ’ɨ nɨ́ atdí alɛ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nɨ́, Pbàyàhúdí náadʉ̀ odu ʉ̀wa tdɨ́tdɔ̌, ndɨ́nɨ̌ ɨ̀ ubvú tɨ́ Yěsù nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ma mábhʉ nyɨ̌ nyǎla ábhɔ̌ ídzì dhu nyʉ́ yà Àba Kàgàwà íbhò idù ɔbɨ nɨ̌. Nɨ́, ádhu ndɨ kɔ̌kɔ̀ ɨ dhu nzínzì ɔ̌, nyɨ̌ nyɨ́ mapà nyǔbvǔ ma odu nɨ̌ okúna dɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nɨ́ Pbàyàhúdí adʉ̀ dhu àdu Yěsù tɔ̀, ’àtɨ: «Ɨ̀nzɨ̌ nɨ́ ídzì dhu-okú dɔ̀ rɔ̀ nga ndɨ mǎ mɨ́ mǎpà mǔbvǔ nyɨ nɨ̌. Pbɛ́tʉ̀, mǎ mòzè mǔbvǔ nyɨ okúna dɔ̀ rɔ̀ dhu nɨ́, nyɨ nyʉ̀nɔ̀ dhu nzɛ́rɛ nyʉ́ Kàgàwà nɨ̌ dhu. Ɨnyɨ nɨ́ ìndrǔ-tsí dhu, nɨ́ nyɨ nyádʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi, nyɨ ràrɨ̌ Kàgàwà!» ");
INSERT INTO niy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yěsù adʉ̀ dhu àdu tdɨ́tdɔ̌ abádhí tɔ̀, ndàtɨ: «Fʉ̀kʉ́ Ʉyátá ɔ̀ ka kándǐ tɨ́ nzá dhu, katɨ: ‹Ɨma Kàgàwà, ma mátɨ nyɨ̌ nɨ̌, nyɨ̌ ràrɨ̌ mʉ̌ngʉ̌-nzo?› ");
INSERT INTO niy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Àlɛ̌ kʉ́nɨ wà dhu atdí alɛ mà ràrɨ̌ nzɨ̌ àdʉ̀ Kàgàwà bhà Andítá-tɨ̀ nʉ́gɛrɛ. Kàgàwà átɨ̀ pbɨ̀ndà ɔtɛ ka kʉ̀nɔ̀ fɨ̌yɔ̀ alɛ-ɔvɔ̀ mʉ̌ngʉ̌-nzo tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nɨ́, Àba Kàgàwà ɔ́pɨ̀ ndɨ ɨma, ndìvì ma yà adzɨ ɔ̌. Nɨ́, yà ma mátɨna, ɨma ràrɨ̌ kà t’Ídhùnà rɔ̀, nyɨ̌ nyádʉ̀ àtɨ̀nà ɨ̀ngbǎ dhu bhěyi ma rʉ̀nɔ̀ dhu nzɛ́rɛ nyʉ́ kà nɨ̌? ");
INSERT INTO niy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dhu apɛ́ ɨ̀’ɨ̀ ɨ̀nzɨ̌ ma márɨ́ Àbadu bhà kasʉ ɔ̀nzɨ dhu tɨ́, nɨ́ dhu àkǎ nzá nyǎ’ù ma. ");
INSERT INTO niy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pbɛ́tʉ̀, dhu apɛ́ ɨ̀’ɨ̀ ɔ̀nzɨ ma márɨ́ kàbhà kasʉ ɔ̀nzɨ dhu tɨ́, nɨ́ ɨnzá màtɨ́ nyɨ̌ nyà’ù ɨma nyʉ́ rɔ̀, dhu àkǎ nyǎ’ù yà ma márɔ́nzɨna kasʉ. Ma mʉ̀nɔ̀ wà dhu, ndɨ́nɨ̌ ndɨ dhu alʉ́ tɨ́ dʉ̀kʉ, nyǎdʉ̀ dhu ʉ̀nɨ mběyi nyʉ́ Àbadu ràrɨ̌’ɨ̀ nyʉdutsì, ndɨrɔ̀ ma ràrɨ̌’ɨ̀ kà-nyʉtsì.» ");
INSERT INTO niy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ dhu ɔ̀nzɨ̀ tdɨ́tdɔ̌ ndɨ́nɨ̌ ɨ̀ alʉ́ tɨ́ Yěsù ’òsò. Pbɛ́tʉ̀, Yěsù adʉ̀ ndàwɨlɨ abádhí-fɔ́ rɔ̀, ndàrà. ");
INSERT INTO niy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nɨ́ Yěsù adʉ̀ ndàdu, ndàrà tdɨ́tdɔ̌ Yɔ̀rɔ̀danɨ̀ tɔ́ ɨdha-akpà-adzè, yà Yùwanɨ̀ úbhì bàtizò ùbho rɔ̌ angyinǎ rɔ̀ ìndrǔ tɔ̀ ɨ, ndòngò àdɨ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nɨ́ ányɨ̀, ábhɔ̌ alɛ nyʉ́ nóowúnà ìwu rɔ̌ kà ɨ, ’àdʉ̀ òwu àtɨ̀nà rɔ̌ nzínzìya ɔ̌: «Obhó tɨ́, Yùwanɨ̀ nɔ́nzɨ̀ nzá atdí wɨwɨ̀ mà. Pbɛ́tʉ̀, yàrɨ́ alɛ dɔ̌ kǎrà àwɛnà rɔ̌ kɔ́rɔ́ dhu nɨ́’ɨ̀ obhó dhu nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɨ́ ábhɔ̌ alɛ nyʉ́ náadʉ̀ Yěsù à’ù ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Làzarʉ̀ tɨ́ kátɨna atdí alɛ nɨ́ɨ’ɨ̀ andɨ̀ nà. Ndɨ alɛ nóongónà àdɨ Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̌. Ndɨrɔ̀, Bɛ̀tànɨyà nɨ’ɨ̀ Màrɨyà mà, awɛ̀nà Màrɨtà mànà, mà tɔ́ pbanga. ");
INSERT INTO niy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ndɨ Màrɨyà nɨ́ ndɨ, yà Ádrʉ̀ngbǎlɛ Yěsù-pfɔ̀ dɔ̌ adʉ̀ àrà ndrùù rɔ́ngʉ akyɛ nɔ́dhɔ̀, ndàdʉ̀ kà-pfɔ̀-ngbɔ̀ núndo dɔ̀na-ká nɨ̌. Ndɨrɔ̀, ka nɨ’ɨ̀ ndɨ wɔ̀ andɨ nà ɨ’ɨ̀ Làzarʉ̀ t’áwɛ̀nà. ");
INSERT INTO niy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nɨ́, Làzarʉ̀ t’áwɛ́na náavì ìndrǔ ràrà dhu ɔ̀vɔ̀ Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, kànɨ̌ yà atdídɔ̌ nyɨ nyózè alɛ, Làzarʉ̀ rɨ̌’ɨ̀ andɨ nà.» ");
INSERT INTO niy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nɨ́ wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù adʉ̀ àtɨ̀nà wɔ̀ alɛ nɨ̌: «Wɔ̀ Làzarʉ̀ rǎndɨ nɨ̌ andɨ rɨ̌ nzɨ̌ kàbhʉ̌ rɔ̀vɛ̀ dòtsí. Pbɛ́tʉ̀, ndɨ andɨ àlʉ̌ ka ndɨ́nɨ̌ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨtɛ̀ tɨ́, ndàdʉ̀ kà t’Ídhùnà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ́tɛ̀ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yěsù azè Màrɨtà mà, awɛ̀nà Màrɨyà mànà, ndàdʉ̀ Làzarʉ̀ nózè átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nɨ́, Làzarʉ̀ rǎndɨ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Yěsù adʉ̀ ɔ́yɔ̌ ɨdhɔ nyʉ́ nɔ́nzɨ̀, yà ndɨ andɨ tɔ́ màkʉ̌rʉ̀ ótù ndɨ̀ ɔ̀ná ngari ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kàdu àlɛ̌ Yùdɛyà tɔ́ pbìrì ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nɨ́, ábhàlɨ̌ adʉ̀ dhu ìvu kà-tsʉ̌ ’àtɨ: «Hɔ̀kɔ̀ Màlimò! Kòmbí tɨ́ nɨ́ Pbàyàhúdí nápà ’ùbvǔ nyɨ odu nɨ̌. Nɨ́ nyɨ nyòzè tɨ́ nyadu nyɨ ányɨ̀ tdɨ́tdɔ̌?» ");
INSERT INTO niy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nɨ́ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Adyíbhengá nga ɔ̌, adyifɔ̀-sɨsɨ̀ náatɨ́ obhó ongo ɨ̀’ɨ̀ atdí kumì dɔ̀ná ɔ́yɔ̌ nà? Nɨ́ ìndrǔ apɛ́ àmbɛ ùbhi dɔ̌ adyíbhengá, nɨ́ ndɨ alɛ rɨ̌ nzɨ̌ àdʉ̀ ndàgɨlɨ ndɨ̀tsɨ̀, yà adzɨ dɔ̌ awáwʉ̀ nálǎ ndɨ̀ ndɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pbɛ́tʉ̀, kǎpɛ́ àmbɛ ùbhi dɔ̌ kúbhingá, nɨ́ kà rǎdʉ̀ àrà ndàgɨlɨ rɔ̌ ndɨ̀tsɨ̀, ɨ̀nzɨ̌ ndɨ̀ ndɨ́ ɨnga nálǎ dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wɔ̀ dhu ndɨ̀ ndʉ̀nɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Àlɛ̌ t’ɔ́dhɨ̀nà Làzarʉ̀ nɔ́dhɔ̀ ɔ̀dhɔ̀ tɨ́. Pbɛ́tʉ̀, ma márà ndɨ́nɨ̌ ma mitsi tɨ́ kɨ̀nga ɨdhɔ ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nɨ́, Yěsù bhà ábhàlɨ̌ adʉ̀ dhu àdu ’àtɨ: «Ádrʉ̀ngbǎlɛ́, kǎpɛ́ ɨ̀’ɨ̀ ɔ̀dhɔ̀ tɨ́ ɔ̀dhɔ̀ dhu tɨ́, nɨ́ kà rɔ̌gʉ̀ ɔ̀gʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Obhó tɨ́, Yěsù azè ndʉ̀nɔ̀ dhu nɨ’ɨ̀, ɨwà Làzarʉ̀ rɔ̀vɛ̀. Pbɛ́tʉ̀, kàbhà ábhàlɨ̌ adʉ̀ dhu ɨ̀rɛ̀ ɨdhɔ nyʉ́ dɔ̌ kà ràrɔ̌tɛ. ");
INSERT INTO niy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nɨ́, Yěsù adʉ̀ dhu ɔ̀vɔ̀ kpangba abádhí tɔ̀, ndàtɨ: «Làzarʉ̀ ɔ̀vɛ̀ wà. ");
INSERT INTO niy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ndɨrɔ̀, ɨdhɛ̀du nɨ̀ka okúkʉ dɔ̀ rɔ̀ dhu nɨ́, ɨ̀mbǎ ma mɨ̀’ɨ̀ ányɨ̀ dhu. Nɨ́, wɔ̀ ndɨ dhu ɔ̀nzɨ̀ ndɨ̀, ndɨ́nɨ̌ nyɨ̌ nyadʉ̀ tɨ́ ma à’ù. Nɨ́, kòwu pɛ́ ndɨ Làzarʉ̀ ɔ̀vɛ̀ ɨ.» ");
INSERT INTO niy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, Tʉ̀masɨ̀ tɨ́ kátɨna, yà ka kongónà àdʉ̀ ànzìnà átɔ̀ Dìdimò tɨ́, náadʉ̀ àtɨ̀nà ngʉ̌kpà ábhàlɨ̌ nɨ̌: «Kòwu átɔ̀ ányɨ̀, ndɨ́nɨ̌ àlɛ̌ kʉvɛ̀ tɨ́ atdíkpá Màlimò mànà.» ");
INSERT INTO niy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yěsù itdègu àrà àhʉ Bɛ̀tànɨyà, nɨ́ kǎtù Làzarʉ̀ ɨwà ka kɔ́tdʉ̀ ka rɔ́ ɨdhɔ àhʉ ɨ̀fɔ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ndɨ Bɛ̀tànɨyà tɔ́ pbanga nɨ́ɨ’ɨ̀ mbɛ̀mbɛ̀ ɨ̀bhʉ kìlòmɛ̌tɛ̀rɛ̀ tɨ́ Yèrùsàlɛmà tɔ́ kɨgɔ̀ rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nɨ́, Pbàyàhúdí nzínzì ɔ̌ ábhɔ̌ alɛ nyʉ́ níiwú Màrɨtà mà Màrɨyà mànà-tɨ’ɔ̀, ndɨ́nɨ̌ ɨ̀ opé tɨ́ abádhí-afí adɔ̀yà Làzarʉ̀ bhà ɔvɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nɨ́, Màrɨtà níitdègu Yěsù rɨ̌rà dhu ɨ̀rɨ, nɨ́ kǎdʉ̀ ndɨ̀và, ndàrà kàkɔ otu ɔ̀ rɔ̀. Pbɛ́tʉ̀, Màrɨyà adʉ̀ àdɨ ɨdza. ");
INSERT INTO niy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nɨ́, Màrɨtà itsi àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, nyɨ nyɨ́’ɨ̀yana gukyè ɨrɔ́, nɨ́ adɔ̀du ɔ́vɛ̀yana nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pbɛ́tʉ̀, ma mʉ̀nɨ wà dhu, kòmbí màtɨ́ Kàgàwà ràrɨ̌ fɔná nyɨ nyónzina kɔ́rɔ́ dhu nábhʉ̌ àbhʉ̌ ɨndʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nɨ́, Yěsù adʉ̀ àtɨ̀nà Màrɨtà nɨ̌: «Adɔ̀nʉ rɨ̌ ndɨ̀ngbɛ̀ ɨ̀ngbɛ̀ ibhu ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nɨ́, Màrɨtà adʉ̀ àtɨ̀nà kà nɨ̌: «Ma mʉ̀nɨ wà dhu, yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ nɨ́nganɨ́, yà ʉ̀vʉ̌vɛ̀ alɛ kɔ́rɔ́ rɨ̌ ’ʉ̀ngbɛ̌ rɔ̀, àbadhi rɨngbɛ̀ya ndɨ̀ ɨ̀ngbɛ̀ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨma nɨ́ ndɨ ìndrǔ àbhʉ rádʉ̀ rɨ̀ngbɛ̀ ndɨ̀, ndàdʉ̀ ípìrɔ̌nga nábhʉ ìndrǔ tɔ̀ alɛ. Nɨ́, ɔ̀vɛ̀ tɨ́ màtɨ́ ɨma ná’ù alɛ náapɛ́ ɔ̀vɛ̀, nɨ́ rǎdʉ̀ ípìrɔ̌nga nábà àbà. ");
INSERT INTO niy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndɨrɔ̀, ìnè rɨ́’ɨ̀ pbɨ̀ndà ípìrɔ̌nga nà, ndàdʉ̀ ma’ù alɛ, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ɔ̀vɛ̀ akɛkpá màtɨ́. Nyɨ nyà’ù tɨ́ wà yà ma mʉ̀nɔ̀ dhu?» ");
INSERT INTO niy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nɨ́, Màrɨtà adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ɨwà ma mà’ù ndɨ dhu Ádrʉ̀ngbǎlɛ́. Ma mà’ù wà dhu ɨnyɨ ràrɨ̌ ndɨ Krɨ́stɔ̀, Kàgàwà t’ídhùnà, yà yàrɨ́ adzɨ ɔ̌ rɨ́rà dhu tɨ́ ka katɨ alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wɔ̀ dhu bhěyi ndɨ̀ ndàdu dhu Yěsù tɔ̀ dhu-dzidɔ̌, Màrɨtà náadʉ̀ àrà awɛ̀nà Màrɨyà nánzì. Nɨ́, ɨdza ndɨ̀ ndòtsù Màrɨyà ɨ rɔ̀, Màrɨtà náadʉ̀ dhu ɔ̀vɔ̀ kàtɔ̀ bhɛ̀lʉ ɔ̌, ndàtɨ: «Màlimò ɨ̀rà wà. Nɨ́ kà rɨ̌ nyanzi.» ");
INSERT INTO niy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nɨ́ wɔ̀ Màrɨtà ʉ̀nɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Màrɨyà adʉ̀ àhʉ àrǐ nyʉ́ tɨ́, ndàrà Yěsù rɨ̌’ɨ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Yěsù ɨ’ɨ̀ ɨnzá ndɨ̀ ndàpɛ̀ ìtsù pbanga ɔ̀ rɔ́. Pbɛ́tʉ̀, kǎdʉ̀ ɨ̀’ɨ̀ àdɨ̀ ndɨ̀ ndàdɨ̀ yà Màrɨtà mànà ɨ̀ òtùnà ɨ̀ ɔ̀ná ngari ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pbàyàhúdí nɨ́ɨ’ɨ̀ atdíkpá Màrɨyà mànà ɨdzá, ’àdʉ̀ àmbɛ kà-afí nópè dɔ̌. Nɨ́, Màrɨyà ɨ̀và ndɨ̀, ndàhʉ àrǐ nyʉ́ tɨ́ dhu ɨ̀ àla rɔ̀, abádhí adʉ̀ ’ɨ̀và átɔ̀, ’òwù kǒwù ɔ̌. Abádhí atɨ ka yà Làzarʉ̀ ka kɔ́tdʉ̀ ɨ rárà, ndàrà ɔ̀dzɨ ányɨ̀rɔ̀ dhu tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nɨ́, yà Yěsù rɨ̌’ɨ̀ rɔ́ ndɨ̀ ndàrà àhʉ rɔ̀, Màrɨyà níitdègu Yěsù àlǎ, nɨ́ kǎdʉ̀ ndìbvu obvò kà-pfɔ̀ rɔ̌, ndàdʉ̀ àtɨ̀nà kà nɨ̌: «Ádrʉ̀ngbǎlɛ́, nyɨ nyɨ́’ɨ̀yana gukyè ɨrɔ́, nɨ́ adɔ̀du ɔ́vɛ̀yana nzɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nɨ́ Màrɨyà mà, yà owùna ɔ̌ ìwǔ Pbàyàhúdí mànà rɔ̌dzɨ dhu ndɨ̀ ndàla rɔ̀, ɨzʉ nʉ́ʉka Yěsù atdídɔ̌, afína ràmbɛ ɨnga ɨ̀rɛ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyɔ́tdʉ̀ ka ɨ̀ngbɔrɔ́?» Nɨ́ abádhí adʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Ádrʉ̀ngbǎlɛ́, ɨ́rà ndɨ́nɨ̌ nyɨ nyala tɨ́ ányɨ̀rɔ̌ nga.» ");
INSERT INTO niy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ ɔ̀dzɨ. ");
INSERT INTO niy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nɨ́, Pbàyàhúdí adʉ̀ òko ’àmbɛ àtɨ̀nà dɔ̌: «Ìgyò! Nyàndà pɛ́ kǒzè Làzarʉ̀ tɨ́ dhu!» ");
INSERT INTO niy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pbɛ́tʉ̀, abádhí nzínzì ɔ̌ atdídhená alɛ náadʉ̀ àtɨ̀nà: «Hɔ̀kɔ̀! Wɔ̀ alɛ nyʉ́ nɨ́ ndɨ ndùmùndúmú-nyɨ̀kpɔ́ nábhʉ rʉ̀ngbɛ ndɨ̀. Nɨ́ kǎbhʉ̀yana tɨ́ obhó Làzarʉ̀ ɨ̀nzɨ̌ rɔ̀vɛ̀?» ");
INSERT INTO niy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kɔ̌kɔ̀ Pbàyàhúdí rʉ̌nɔna dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, ɨzʉ náadʉ̀ Yěsù ʉ̀ka atdídɔ̌ nyʉ́. Nɨ́, abádhí adʉ̀ òwu Làzarʉ̀ ka kɔ́tdʉ̀ ɨ. Ka katdʉ̀ ka ɔ̀nà ibhu nɨ’ɨ̀ bhalabhala ɔ̀ ka kógyè, kadʉ̀ lina’ɔ̀ nápbi odu-ɨ́yà-ba nɨ̌ ibhu. ");
INSERT INTO niy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nɨ́, ányɨ̀ ɨ̀ òwù ùvò rɔ̀, Yěsù atɨ yà tɨná ɨ̀’ɨ̀ alɛ nɨ̌: «Nyɔ̀gɛrɛ wɔ̀ odu ibhu-lí rɔ̀.» Nɨ́ Làzarʉ̀-bvʉ̀ t’áwɛ̀nà Màrɨtà náadʉ̀ Yěsù ɨ̀sɔ, ndàtɨ: «Ìnzě Ádrʉ̀ngbǎlɛ́! Wɔ̀ abvo nɔ́pɛ̀ wà ndɔ̀ngʉ̀ atdídɔ̌. Kɔ̀nzɨ̀ wà ɨ̀fɔ ɨdhɔ nyʉ́ ibhu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pbɛ́tʉ̀, Yěsù adʉ̀ dhu àdu Màrɨtà tɔ̀, ndàtɨ: «Ma màtɨnà tɨ́ obhó nyɨ nɨ̌, nyɨ rapɛ́ ɨma ná’u, nɨ́ nyɨ ràrɨ̌ àdʉ̀ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ nála?» ");
INSERT INTO niy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nɨ́, ka kadʉ̀ odu nɔ́gɛ̀rɛ̀ ibhu-lí rɔ̀. Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ nyɨ̀kpɔ́na náva ndàndà ɔrʉ̀ nga, ndàdʉ̀ ndɨ̀tsɔ̀, ndàtɨ: «Àba Kàgàwǎ, ma màbhʉ ɔ̀tsɔ̀ ɨndʉ̀, tsʉ̀dú dhu nyɨ nyɨ̀rɨ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Obhó tɨ́, ma mʉ̀nɨ wà dhu ɨ̀rɨ nyɨ raróngo tsʉ̀dú dhu ɨ̀rɨ̀ bìlǐnganà. Pbɛ́tʉ̀, ma mɨ̀tsɔ̀ ma wɔ̀ dhu bhěyi dhu nɨ́, ndɨ́nɨ̌ kǎkà ngbɔ̌du nàkpɔ̀rɔ̀ ɨrɔ́ alɛ náa’u tɨ́ dhu ɨnyɨ ràrɨ̌ ndɨ nyɨ nyívì ma.» ");
INSERT INTO niy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wɔ̀ dhu ndɨ̀ ndòrì dhu-dzidɔ̌, Yěsù adʉ̀ Làzarʉ̀ nánzì ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Làzarʉ̌, áhʉ̌ wɔ̀rɨ́ ibhu ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nɨ́, Làzarʉ̀ adʉ̀ àhʉ ibhu ɔ̀ rɔ̀, ɔtsʉ́na mà, pfɔ̌na mànà ka kʉ̀ndɨ̀lɨ̌ abvo ʉ̀tdʉ̌ ka karɨ́ ɔ̀ná mbɛrʉ̀ nɨ̌, kadʉ̀ nyɨ̀na níso mbɛ̌rɛ̀sɛ nɨ̌ rɔ́rɔ̀. Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà ihé-yà nɨ̌: «Nyʉ̀nga Làzarʉ̀, nyǎdʉ̀ ʉ̀bhànà ràrà ɨbha.» ");
INSERT INTO niy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yà Màrɨyà mǎrábvʉ̀ ìwǔnà, ’àdʉ̀ Yěsù ɔ̀nzɨ̀ Làzarʉ̀ rɔ̌ dhu àla Pbàyàhúdí nzínzì ɔ̌, ábhɔ̌ alɛ nyʉ́ náadʉ̀ Yěsù à’ù. ");
INSERT INTO niy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pbɛ́tʉ̀, abádhí nzínzì ɔ̌ atdídhená alɛ náadʉ̀ òwu Pbàfàrìsáyó-tɨ’ɔ̀, ’àdʉ̀ yà Yěsù ɔ̀nzɨ̀ dhu àwɛ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nɨ́, ndɨ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà, náadʉ̀ yà Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ-tsʉ̀ núndu. Nɨ́rɔ̀ nɨ́ ndɨ abádhí náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀rɨ́ alɛ rǎrà ábhɔ̌ wɨwɨ̀ nyʉ́ nɔ́nzɨ̀ rɔ̌. Nɨ́ ádhu ndɨ àkǎ àkǎ àlɛ̌ rɔ̀nzɨ̀? ");
INSERT INTO niy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Àlɛ̌ kapɛ́ kʉ̀bha ràmbɛ ndɨ dhu ɔ̀nzɨ̀ dɔ̌, nɨ́ kɔ́rɔ́ alɛ rɨ̌ kà’u. Ndɨrɔ̀ Pbàrɔ́má tɔ́ pbìrì ɔ̌ ádrɔ̀drɔ̌ alɛ náadʉ̀ya ìwu, ’ùgolo àlɛ̌ tɔ́ Sɔmǎ-dzà, ’àdʉ̀ àlɛ̌ tɔ́ pbìrì nɨ́nza.» ");
INSERT INTO niy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kɔ̌kɔ̀ ɨ Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya nɨ́tdɨ̀ arɨ́ alɛ nzínzì ɔ̌, atdí alɛ-ɔvɔ̀ nɨ’ɨ̀ Kàyafà. Nɨ́ ndɨ atɔ ɔ̌, ka nɨ’ɨ̀ ndɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà. Nɨ́, kǎtɨ ɔdhɨ́na nɨ̌: «Nyɨ̌ nyʉ́ nyɨ̌ nyʉ̀nɨ nzá atdí dhu mà wɔ̀ dhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nyɨ̌ nyʉ̀nɨ tɨ́ obhó dhu, dhu ràkǎnà atdí alɛ kɛ̀lɛ̌ rɔ̀vɛ̀ kɔ́rɔ́ alɛ tɔ́ ngari ɔ̌, ɨ̀nzɨ̌ àlɛ̌ tɔ́ pbìrì ɔ̌ kɔ́rɔ́ alɛ-tsè náadʉ̀ tɨ́ ndɔ̀tdɨ̀?» ");
INSERT INTO niy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kʉ̌nɔ nzá wɔ̀rɨ́ dhu dɔ̀na nyʉ́ ɔ̀ rɔ̀ àhʉ rɔ́rɔ̀. Pbɛ́tʉ̀, wɔ̀ ndɨ atɔ ɔ̌ ndɨ̀ ndɨ’ɨ̀ ndɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà tɨ́ dhu-okú dɔ̀ rɔ̀, kǎvɔ̀ dhu angyangyɨ, Kàgàwà bhà Nabì bhěyi, ndàtɨ: Yěsù ràkǎ ndɔ̀vɛ̀ Pbàyàhúdí tɔ́ ngari ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ndɨrɔ̀, kǎtɨ átɔ̀ kà ràrɨ̌ nzɨ̌ ɔ̀vɛ̀ Pbàyàhúdí tɔ́ ngari ɔ̌ tɨ́, pbɛ́tʉ̀ kà ràkǎ ndɔ̀vɛ̀ ndɨ́nɨ̌ ndɨ̀ ndundu tɨ́ yà adzɨ ɔ̌ ɨ̀ nɨfàlà Kàgàwà bhà inzo-tsʉ̀, ròkò atdíkpá. ");
INSERT INTO niy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nɨ́, rɔ̀pɛ̀ ndɨ̀ ndɨ ɨdhɔ ɔ̌ rɔ̀, Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ alɛ náapɛ̀ ’ɔ̀nɛ̀ Yěsù ndɨ́nɨ̌ ɨ̀ adʉ̀ tɨ́ àbhʉnà kohò. ");
INSERT INTO niy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, Yěsù adʉ̀ ndɔ̀pɛ̀ ɨ̀nzɨ̌ ndàrà ùbhi rɔ̌ kpangba Pbàyàhúdí nzínzì ɔ̌. Pbɛ́tʉ̀ àbadhi mà, pbɨ̀ndà ábhàlɨ̌ mànà, náadʉ̀ ’ɨ̀và ’òwù yà rʉ̀ngʉ̀-tɨ’ɔ̀ arɨ́’ɨ̀ mʉ̀lɛngʉ̀ ɔ̌ atdí pbanga Ɛ̀fʉ̀ràyimʉ̀ tɨ́ kátɨna ɔ̀, ’àdʉ̀ òko ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ nɨ́ɨ’ɨ̀ ɨwà ndɨ̀ ndìndù ndɨ̀ rɔ́. Nɨ́, ábhɔ̌ alɛ nyʉ́ níiwú fɨ̀yɔ́ pbanga ɔ̀nǎ rɔ̀, ’ìwǔ ùvò angyinǎ rɔ̀ Pásɨ̀ka tɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ndɨ́nɨ̌ ɨ̀ u’o tɨ́ ɨ̀, ’ɨ̀lǎ Kàgàwà-nyɨ̀kpɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nɨ́, Yèrùsàlɛmà ɨ̀ òwù ùvò rɔ̀, abádhí ambɛ́nà Yěsù ɔ̀nɛ̀ dɔ̌. Nɨ́ Kàgàwà bhà-dzá ɨ̀ ɨ́’ɨ̀ rɔ́rɔ̀, abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ádhu nyɨ̌ nyɨ̀rɛ̀ kà-dɔ̌? Tɨ́ ɨ̀nzɨ̌ kà ràrɨ̌ ɨ̀rà mʉ̀hɛndʉ̀ ɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Pbàfàrìsáyó mànà náadʉ̀ dhu ʉ̀ya ìndrǔ tɔ̀ ’àtɨ: «Atdí alɛ mà náapɛ́ Yěsù rɨ̌’ɨ̀ rɔ́ nga nʉ́nɨ̌, nákǎ ndɨ̀tɛ̀ ka ndɨ́nɨ̌ kadʉ̀ tɨ́ òwu kòsò.» ");
INSERT INTO niy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Azà ɨdhɔ tɨ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀-ɨdhɔ̀ nʉ́bhà ndɨ̀ rɔ́rɔ̀, Yěsù ɨvà ndɨ̀ ndàrà Bɛ̀tànɨyà tɨ́ kátɨna pbanga ɔ̀. Ndɨ pbanga nɨ’ɨ̀ yà kǎbhʉ̀ rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ Làzarʉ̀ mà tɔ́ pbanga. ");
INSERT INTO niy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nɨ́ ányɨ̀, ka kabhʉ̀ ɔ̀nyʉ̀ kà tɔ̀. Màrɨtà náambɛ́nà ɔ̀nyʉ̀ nʉ́ndɔ̀ dɔ̌ abádhí tɔ̀, Làzarʉ̀ ràdʉ̀ ɨ̀’ɨ̀ átɔ̀ ndɨ ɔ̀nyʉ̀ ɔ̀nyʉ rɨ́ atdíkpá Yěsù mànà alɛ nzínzì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nɨ́rɔ̀ nɨ́ ndɨ Màrɨyà níidyi ndrùù rɔ́ngʉ akyɛ tɔ́ atdí lítrè-ɔ̌nga ka kʉ̀ndɔ̀ ɔyɔ tɔ́ atdínga, ndɔ̀dhɔ̀ Yěsù-pfɔ̀ dɔ̌. Ndɨ akyɛ nɨ’ɨ̀ nardɔ̀ tɨ́ kátɨna ɨrɨ́-vǐ nɨ̌ ka kɔ́bhɔ̀lɔ̀, odzìna ràdʉ̀ ɨ̀’ɨ̀ ɔrʉ́ nyʉ́ akyɛ. Wɔ̀ dhu-dzidɔ̌, Màrɨyà adʉ̀ Yěsù-pfɔ̀-ngbɔ̀ núndo dɔ̀na-ká nɨ̌, ndɨ akyɛ-dzi ràdʉ̀ ndìtu, ndàkǎ kɔ́rɔ́ ányɨ̀-dzá. ");
INSERT INTO niy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nɨ́ wɔ̀ dhu ndɨ̀ ndàla rɔ̀, Yěsù bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, Yudhà Ìskàrìyɔtà tɨ́ kátɨna, yà Yěsù ìpfo arana ndàbhʉ òmvǔ-fɔ́ alɛ, níivú dhu, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ádhu ɨnzá ka kàbhʉ wɔ̀rɨ́ akyɛ kodzì ɨ̀bhʉ mɨyà dɨ̀narɨ̀ rɔ̌, kadʉ̀ ndɨ fʉ̀rangà nʉ́ndɔ̀ nǎkʉ̀tálɛ tɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kʉ̌nɔ nzá wɔ̀ dhu nǎkʉ̀tálɛ-ɨzʉ̀ ndɨ̀ ndàla dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, kʉ̌nɔ ka ogbotálɛ tɨ́ ndɨ̀ ndɨ́’ɨ̀ dhu-okú dɔ̀ rɔ̀. Obhó tɨ́, kǒngónà ndɨ fʉ̀rangà tɔ́ ɨ́sɔ̀wʉ̌ nɔ́dɔ̀, ndàdʉ̀ àrà ndɨ fʉ̀rangà núwe rɔ̌ afína òzè dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nɨ́, Yěsù adʉ̀ dhu àdu Yudhà tɔ̀, ndàtɨ: «Ʉ́bhà Màrɨyà radɨ̀! Ítsè ka rɔdɔ wɔ̀rɨ́ akyɛ ɨma ka kɔtdʉ́ya ɔ̀ná ɨdhɔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nyɨ̌ nyóngo òko nǎkʉ̀tálɛ mànà bìlǐnganà, pbɛ́tʉ̀ àlɛ̌, àlɛ̌ kɨ́ nzɨ̌ ongo òko nyɨ̌ mànà bìlǐnganà.» ");
INSERT INTO niy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pbàyàhúdí tɔ́ ihé-yà níitdègu Yěsù rɨ̌’ɨ̀ Bɛ̀tànɨyà dhu ɨ̀rɨ, nɨ́ abádhí adʉ̀ òwu ányɨ̀. Abádhí awù nzá ányɨ̀ Yěsù-okú dɔ̀ rɔ̀ tɨ́, pbɛ́tʉ̀ abádhí awù ányɨ̀ ndɨ́nɨ̌ ɨ̀ adʉ̀ tɨ́ yà Yěsù ábhʉ rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ Làzarʉ̀-ngbɔ̀ mà nála átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nɨ́rɔ̀ nɨ́ ndɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ ’ɨ̀rɨ̀ ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ Làzarʉ̀ kohò átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Obhó tɨ́, ábhɔ̌ Pbàyàhúdí nyʉ́ nóowúnà ùvò rɔ̌ abádhí nzínzì ɔ̌ rɔ̀, ’àdʉ̀ Yěsù ná’ù kǒkú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tsútsǎ nɨ́nganɨ́, yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ ɔ̀ íwǔ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ihé-yà nɨ́ɨrɨ dhu, Yěsù ràrɨ̌’ɨ̀ otu ɔ̌ ndɨ̀ ndɨ́rà átɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nɨ́, abádhí adʉ̀ ngazɨ̀-kpa-dɔ̀ká nɔ́kɔ̀, ’ùvò nà, ’òwù Yěsù àkɔ nà otu ɔ̀ rɔ̀. Nɨ́, Yěsù ɨ̀ àla rɔ̀, abádhí apɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀sanà! Ilèta nákǎ kabhʉ yà Ádrʉ̀ngbǎlɛ Kàgàwà-ɔvɔ̀ rɔ̌ rɨ́rà Pbàìsràyélí tɔ́ Ádrʉ̀ngbǎ Kamà tɔ̀!» ");
INSERT INTO niy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù abà kayinǒ-ngba, ndàdʉ̀ ùpo, ndàdɨ dɔ̀ná, yà Kàgàwà bhà Andítá ɔ̀ ka kandí dhu bhěyi. Ɨ Andítá rǎtɨna: ");
INSERT INTO niy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Nyɨ̌ Sàyunì tɔ́ kɨgɔ̀ ɔ̌ bhǎ, ɨ̀nzɨ̌ nyɔ̀nzɨ ɔdɔ. Kɔ̀nɨ̌ fʉ̀kʉ́ Ádrʉ̀ngbǎ Kamà rɨ̌rà, kayinǒ-ngba dɔ̌ ndɨ̀ ndàdɨ rɔ́rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wɔ̀ dhu náalʉ́ nzá Yěsù bhà ábhàlɨ̌-dɔ. Pbɛ́tʉ̀, Yěsù ɔ́dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀ pbɨ̀ndà Ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ɔ̌ dhu-dzidɔ̌ nɨ́ ndɨ, abádhí awù dhu ɨ̀rɛ̀, yà Kàgàwà bhà Andítá ɔ̀ ka kandí dhu, ka randí Yěsù-okú dɔ̀ rɔ̀. Ndɨrɔ̀, ka rádʉ̀ ndɨ dhu ɔ̀nzɨ kà-rɔ̌ ndɨ dhu bhěyi tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ábhɔ̌ alɛ nyʉ́, yà Yěsù rɨ̌ Làzarʉ̀ ànzi rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ rɔ́ ɨ’ɨ̀, náadʉ̀ òko ’àmbɛ Yěsù ɔ́nzɨ̀ dhu àwɛ dɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɨ́, kǎrɨ́ wɨwɨ̀ ɔ̀nzɨ dhu ɨ̀ ɨ́rɨ̀ dhu-okú dɔ̀ rɔ̀, ihé-yà náadʉ̀ òwu Yěsù àkɔ otu ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nɨ́rɔ̀ nɨ́ ndɨ Pbàfàrìsáyó náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Nyɨ̌ nyàla tɨ́ wà! Nyɨ̌ nyɨ́ nzɨ̌ yà dhu lɛ̀mà ɔ̀nzɨ. Kɔ́rɔ́ alɛ òkò wà ’àmbɛ òwu dɔ̌ kǒwù ɔ̌ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ ɔ̀ íwǔ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, ’ìwǔ Kàgàwà ʉ̀lɛ alɛ nzínzì ɔ̌, ngúfe Pbàgìríkí nɨ́ɨ’ɨ̀ ìnè átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nɨ́, ɨ Pbàgìríkí níindri Fìlipò tɨ́ kátɨna ábhàlɨ̌-tɨ’ɔ̀. Ndɨ Fìlipò nɨ’ɨ̀ Gàlìlayà tɔ́ pbìrì ɔ̌ atdí pbanga, Bɛ̀tɛ̀sàyidà tɨ́ kátɨna ɔ̌ alɛ. Nɨ́, abádhí avɔ̀ dhu Fìlipò tɔ̀, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, mǎ mòzè mǎla Yěsù-ngbɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nɨ́ Fìlipò adʉ̀ àrà wɔ̀ dhu ɔ̀vɔ̀ Àndɛ̀rɛyà tɨ́ kátɨna ngǎtsi ábhàlɨ̌ tɔ̀. Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ ’ɨ̀và ’òwù wɔ̀ dhu ɔ̀vɔ̀ atdíkpá Yěsù tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nɨ́, Yěsù adʉ̀ àtɨ̀nà ʉrɔ́ ɨ̀’ɨ̀ alɛ nɨ̌: «Àba Kàgàwà rɨ̌ Ìndrǔ-t’ídhùnà-ɔvɔ̀ nábhʉ̌ rìlè ndɨ̀ ɔ̀ná kàsʉmɨ̀ nɨ́rà wà. ");
INSERT INTO niy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɨ̀nzɨ̌ nganʉ̀-kpɔ̌ náapɛ́ ɨ̀tsɨ̀ adzɨ ɔ̀, ndàdʉ̀ ɔ̀mɔ̀, nɨ́ ndɨ nganʉ̀-kpɔ̌ rǎdʉ̀ àdɨ atdírɔ̀ tɨ́. Pbɛ́tʉ̀ kǎpɛ́ ɔ̀mɔ̀, ndàdʉ̀ ɨ̀nga, nɨ́ ndɨ rádʉ̀ ábhɔ̌ itse nyʉ́ nɔ́dhɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pbɨ̀ndà ípìrɔ̌nga nózè rɨ́ ndɔ̀dɔ̀ fɨ̌ndà alɛ níiwíya ka. Pbɛ́tʉ̀, pbɨ̀ndà ípìrɔ̌nga nózè rɨ́ ndìwǐ okúdu dɔ̀ rɔ̀ yà adzɨ ɔ̌ alɛ, náadʉ̀ya kɔ̀dɔ̀ dhòdhódhónga tɔ́ ípìrɔ̌nga tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ndɨ alɛ náapɛ́ ndòzè ndɔ̀nzɨ̀ kàsʉ̌du, nɨ́ ndɨ alɛ àkǎ ndʉ̀ngʉ owùdu. Ndɨrɔ̀, ma mɨ́’ɨ̀ rɔ́, pbàkà kasʉtálɛ rǎdʉ̀ ɨ̀’ɨ̀ átɔ̀. Ndɨ alɛ náapɛ́ kàsʉ̌du ɔ̀nzɨ, nɨ́ Àba Kàgàwà rǎdʉ̀ ndɨ alɛ ɨ̀fʉ.» ");
INSERT INTO niy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà: «Afídu rɨ̌ ɨnga ɨ̀rɛ̀ atdídɔ̌ kòmbí. Nɨ́, ma mátɨna ɨ̀ngbà tɨ́? Ma tɨ́ àtɨna: Àba Kàgàwǎ, ɨ́gʉ̌ ma yà yàrɨ́ kàsʉmɨ̀ ɔ̌ rɨ́ ndàpà ndɔ̀nzɨ̀ ndɨ̀ rùdú dhu ɔ̌ rɔ̀? Pbɛ́tʉ̀, ma mɨ́rà wɔ̀ ndɨ kòmbí rɨ́ ndàpà ndɔ̀nzɨ̀ ndɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nɨ́ Àbá, ábhʉ̌ ɔvɔ̀nʉ rìlè ndɨ̀.» Nɨ́rɔ̀ nɨ́ ndɨ atdí alɛ-tù náadʉ̀ ndɨ̀rɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndàtɨ: «Ma màbhʉ wà ɔvɔ̀du rìlè ndɨ̀, ndɨrɔ̀ ma mɨ́ kàbhʉ̌ àbhʉ̌ rìlè ndɨ̀ tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nɨ́, ányɨ̀rɔ̌ ɨ̀ ìkò rɔ́ ɨ̀’ɨ̀ ihé-yà nɨ́ɨrɨ wɔ̀ dhu, ’àdʉ̀ àtɨ̀nà: «Ìgyò! Ɔvɔ nyʉ́ nɨ́ wɔ̀ àtà!» Ngʉ̌kpà alɛ adʉ̀ àtɨ̀nà: «Hɔ̀kɔ̀! Kàgàwà-bhà màlàyikà nɨ́ wɔ̀ dhu nʉ̀nɔ̀ kà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Wɔ̀ nyɨ̌ nyɨ̀rɨ̀ alɛ-tù nʉ́nɔ̀ nzá dhu idù, pbɛ́tʉ̀ kʉ̀nɔ̀ ka fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kòmbí rɨ̌rà kàsʉmɨ̀ nɨ́ yà Kàgàwà rɨ̌ yà adzɨ ɔ̌ alɛ-ànyǎ nɨ́tdɨ̀ ɔ̀ná kàsʉmɨ̀. Ndɨrɔ̀, ndɨ kàsʉmɨ̀ nɨ́ ndɨ Kàgàwà rɨ̌ Pfɔ̀mvɔ, yà adzɨ ɔ̌ ádrʉ̀ngbǎlɛ, nípfǒ ɔ̀ná, ndòdì yà adzɨ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pbɛ́tʉ̀ ɨma, yà adzɨ ɔ̌ rɔ̀ ka kɨ́ modyì marà ɔrʉ̀ rɔ̀, ma madʉ̀ya kɔ́rɔ́ alɛ-tsʉ̀ nándu tɨdu ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wɔ̀ ndɨ̀ ndʉ̀nɔ̀ dhu ɔ̌, Yěsù azè ndɨ̀tɛ̀ dhu nɨ́ ɨ̀ngbà dhu bhěyi ɔvɛ-tɨdɔ̀ nɨ̌ màtɨ́ ndɨ̀ ndɔ́vɛ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nɨ́ ihé-yà adʉ̀ dhu ìvu Yěsù-tsʉ̌, ’àtɨ: «Mǎ mɔ́zʉ̀ dhu Músà bhà Ʉyátá ɔ̀, Krɨ́stɔ̀ radɨ̀ya dhòdhódhónganà. Nɨ́, ádhu nyɨ nyádʉ̀ àtɨ̀nà Ìndrǔ t’ídhùnà ràkǎ pɛ́ ndàrà ɔ̀rʉ̀-akpà ɔ̀ nɨ̌? Ndɨrɔ̀, ndɨ Ìndrǔ t’ídhùnà nyʉ́ nɨ́ àdhɨ?» ");
INSERT INTO niy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Awáwʉ̀ rɨ̌’ɨ̀ inè nzínzìkʉ ɔ̌ ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́. Nɨ́, dhu àkǎ nyǔbhi yà ìnè nyɨ̌ nyɨ́’ɨ̀ ndɨ awáwʉ̀ nà rɔ́, akyɛ ɨ́nɔ̀ adʉ̀na tsʉ̀kʉ ʉ̀tɔ̀ nɨ̌. Obhó tɨ́, ɨ́nɔ̀ ɔ̌ rúbhi alɛ rɨ̌ nzɨ̌ àdʉ̀ àdhà màtɨ́ ndɨ̀ ndárà dhu nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɨ́ dhu àkǎ nyǎ’ù ndɨ awáwʉ̀, yà òko nyɨ̌ nyòko atdíkpá kà mànà ɔ̀ná kàsʉmɨ̀ ɔ̌, ndɨ́nɨ̌ nyɨ̌ nyadʉ̀ya tɨ́ òko awáwʉ̀ ɔ̌ nzónzo tɨ́.» Wɔ̀ dhu ndɨ̀ ndʉ̀nɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àrà ndòrù ɨtsɛ ihé-yà rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yěsù anzɨ̀ mbǎ ábhɔ̌ wɨwɨ̀ mà Pbàyàhúdí-ɔ̀nzɨ̌, nɨ́ abádhí adʉ̀ nzá kà à’ù. ");
INSERT INTO niy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Wɔ̀ ndɨ dhu anzɨ̀ ndɨ̀ ndɨ́nɨ̌ yà Kàgàwà bhà nabì Ìsayà nʉ́ʉnɔ dhu náaká tɨ́. Kǎtɨ: «Ádrʉ̀ngbǎlɛ Kàgàwǎ, ádhɨ tsʉ̀ká dhu na’u? Ndɨrɔ̀, ádhɨ ndɨ Ádrʉ̀ngbǎlɛ Kàgàwà nɨ́ɨtɛ̀ pbɨ̀ndà ɔbɨ fɨ̌ndà?» ");
INSERT INTO niy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndɨrɔ̀, ndɨ Ìsayà kɛ̀lɛ̌ nʉ́ʉnɔ ɨnzá Pbàyàhúdí náa’u dhu okúna dɔ̀ rɔ̀ dhu. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Kàgàwà nɨ́ɨtɨ abádhí-nyɨ̌nga ròngò ndùmùndúmú tɨ́, ɨ̀nzɨ̌ ɨnga nala tɨ́. Ndɨrɔ̀, kǎdʉ̀ abádhí-afí nábhʉ rɔ̀’ɔ̀ odú, akyɛ dhu alʉ́na dɔ̀ya, ràdʉ̀ ’ʉ̀gɛ̀rɛ̀ ’ʉ̀bhà fɨ̌yɔ́ nzɛ́rɛnga, ndɨ́nɨ̌ ndadʉ̀ tɨ́ abádhí nɨ́gʉ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nabì Ìsayà nʉ́ʉnɔ wɔ̀rɨ́ dhu Yěsù bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ ndɨ̀ ndala angyangyɨ, ndàdʉ̀ ɔ̀tɛ kà dɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pbɛ́tʉ̀, nabì Ìsayà nʉ́ʉnɔ mbǎ wɔ̀ dhu mà, nɨ́ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ nzínzì ɔ̌ màtɨ́, ábhɔ̌ alɛ nyʉ́ náa’u Yěsù. Nɨ́, abádhí adʉ́nà nzɨ̌ òwu ndɨ dhu àvi rɔ̌ kpangba, Pbàfàrìsáyó-ɔdɔ̀ nɔ́nzɨ ɨ̀ ɨ́ dhu-okú dɔ̀ rɔ̀, akyɛ ka kadʉ̀na òwu ’ìpfo, kodì ɨ̀ unduta-ɨdzà ɔ̌ rɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abádhí náazè ìndrǔ rɨ̌ ’ɨ̀fʉ̌ dhu, ròsè Kàgàwà rɨ̌ ’ɨ̀fʉ̌ dhu dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Wɔ̀ dhu-dzidɔ̌, Yěsù apɛ̀ ɔtɛ ɔrʉ́ tǔna nyʉ́ nà, ndàtɨ: «Ndɨ alɛ náapɛ́ ɨma ná’u, nɨ́ kà’ù nzá ɨma kɛ̀lɛ̌, pbɛ́tʉ̀ kà’ù wà yà ɨma nivi mɨrà yà adzɨ ɔ̌ alɛ mà átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ndɨrɔ̀, ndɨ alɛ apɛ́ ɨma àlǎ, nála wà yà ɨma nivi yà adzɨ ɔ̌ alɛ mà átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨma, yà adzɨ ɔ̌ awáwʉ̀ tɨ́rɔ̀, ma mɨ́rà ndɨ́nɨ̌ ɨ̀nzɨ̌ ɨma nà’ù alɛ náadʉ̀ tɨ́ àdɨ ɨ́nɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ndɨ alɛ náapɛ́ ma mʉ́nɔna dhu ɨ̀rɨ, ɨ̀nzɨ̌ ndàdʉ̀ ndɨ dhu nɨ́lɨ afína ɔ̀, nɨ́ ndɨ alɛ-dɔ̌ rádʉ̀ anya ɔ̀tdɨ̀ nɨ́ nzɨ̌ ɨma. Obhó tɨ́, ma mɨ́rà nzá ndɨ́nɨ̌ mɨtdɨ̀ tɨ́ anya yà adzɨ ɔ̌ alɛ dɔ̌, pbɛ́tʉ̀ ma mɨ́rà ndɨ́nɨ̌ ma mɨgʉ́ tɨ́ yà adzɨ ɔ̌ alɛ ɨ̀gʉ̌ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ndɨ alɛ apɛ́ ɨma nɔ́dhɔ, ɨ̀nzɨ̌ ndàdʉ̀ ma mʉ́nɔna dhu ná’ù, nɨ́ ndɨ alɛ nábà wà ànyǎna ɔ̀tdɨ̀ rɨ́ dhu. Yà ma mʉ̀nɔ̀ ɔtɛ nɨ́ ndɨ kà-ànyǎ nɔtdɨ́ya yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ nɨ́nganɨ́. ");
INSERT INTO niy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Obhó tɨ́, yà ma marʉ́nɔna dhu nʉ́nɔ ma marɨ́ nzɨ̌ ràhʉ ùdù rɔ̀ ma-tɨ́rɔ̀. Pbɛ́tʉ̀ kǎráhʉ Àbadu Kàgàwà, yà ɨma nivi mɨrà yà adzɨ ɔ̌ alɛ bhà rɔ̀. Ka nyʉ́ ndɨ̀tɨ́rɔ̀ nɨ́ ndɨ dhu nʉ́yǎ idù ma màkǎ mʉnɔ̀ dhu mà, ma màkǎ mɔvɔ̀ ìndrǔ tɔ̀ dhu mànà dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ndɨrɔ̀, ma mʉ̀nɨ wà dhu yà kʉ̌yǎ dhu ràrɨ̌ ndɨ dhòdhódhónga tɔ́ ípìrɔ̌nga níbhò rádʉ̀ ìndrǔ tɔ̀ dhu. Nɨ́, yà ma mʉ́nɔna dhu nʉ́nɔ ma mɨ́ àdhàdhɨ̀ Àbadu Kàgàwà nʉ́yǎ ka idù dhu bhěyi.» ");
INSERT INTO niy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tsútsǎ nɨ́nganɨ́ Pbàyàhúdí tɔ́ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ nɨ́ɨ’ɨna rɔ́rɔ̀, Yěsù ʉnɨ dhu, yà adzɨ ɔ̌ rɔ̀ ndɨ̀ ndɨ́ ndɨ̀và, ndàrà Àbanà Kàgàwà bhà ɔ̀ná kàsʉmɨ̀ ràkǎ wà. Nɨ́ Yěsù, yà atdídɔ̌ yà adzɨ ɔ̌ arɨ́’ɨ̀ pbɨ̀ndà alɛ nazè, náadʉ̀ abádhí òzè tdɨ́tdɔ̌ ɨ̀nzɨ̌ rádʉ̀ ìku àzè nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nɨ́ pbɨ́tsɔ̀ngǎnǎ, Yěsù mà nɨ́ɨ’ɨ̀ ɔ̀nyʉ̀-tsʉ̀nǎ pbɨ̀ndà ábhàlɨ̌ mànà. Nɨ́rɔ̀ nɨ́ ndɨ Pfɔ̀mvɔ níitsu dhu Yudhà, Sìmonì Ìskàrìyɔtà t’ídhùnà-afí ɔ̀, ndɨ́nɨ̌ Yěsù nipfo tɨ́ ndàbhʉ òmvǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pbɛ́tʉ̀, Yěsù nyʉ́ nʉ́ʉnɨ dhu, ɨwà Àbanà Kàgàwà ribho kɔ́rɔ́ dhu dɔ̌ ádrʉ̀ngbǎnga tɔ́ ɔbɨ fɔná. Ndɨrɔ̀, kʉ̌nɨ wà dhu, ndɨ̀ nyʉ́ ndɨ̀ rɨ́rà Àbanà Kàgàwà-tɨ’ɔ̀ rɔ̀, nɨ́ ndɨ̀ ràrɨ̌ ndàdǔ Àbanà-tɨ’ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nɨ́, Yěsù ɨvà ndɨ̀ ɔ̀nyʉ̀-tsʉ̀nǎ rɔ̀, ndɨ̀wà rɔ̀ná ɔrʉ́ mʉ̀dzarʉ̀, ndɨ̀lɨ igi. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ bɛ̌rɛ̀sɛ nídyì ndìsǒ mvʉna ’ɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tdɨ́tdɔ̌, kǎdʉ̀ ɨdha ìdyì ndɔ̀dhɔ̀ ádrʉ̀ngbǎ sǎnɨ̀ ɔ̌, ndàdʉ̀ ndɔ̀pɛ̀ ndù’o pbɨ̀ndà ábhàlɨ̌-pfɔ̀ nɨ̌, ndàdʉ̀ àrà ùndonà rɔ̌ yà mvʉna ’ɔ̀ ndɨ̀ ndìsǒnà nɨ̌ bɛ̌rɛ̀sɛ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nɨ́, Yěsù níitdègu àrà àhʉ Sìmonì Pɛ́tɛrʉ̀ tɨ́, nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Ɨnyɨ nyʉ́ pbàkà Ádrʉ̀ngbǎlɛ́ tɨ́rɔ̀, nyɨ nyòzè tɨ́ nyu’o pfɔ̌du?» ");
INSERT INTO niy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Yà ma mɔ́nzɨna dhu nʉ́nɨ̌ nyɨ nyɨ́ nzɨ̌ kòmbí, pbɛ́tʉ̀, nyɨ nyaraya kʉ̀nɨ olù.» ");
INSERT INTO niy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Nyɨ nyɨ́ nzɨ̌ pfɔ̌du ù’ǒ akɛkpá màtɨ́.» Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ ma mapɛ́ pfɔ̌nʉ nú’ǒ, nɨ́ àlɛ̌ kɨ́’ɨ̀ ɨ̀mbǎ ɨrɨta nà ɨnyɨ mànà.» ");
INSERT INTO niy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nɨ́, Sìmonì Pɛ́tɛrʉ̀ adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, wɔ̀ dhu bhěyi kà rɨ̌’ɨ̀ rɔ̀, nyɨ nyɨ́ nzɨ̌ pfɔ̌du kɛ̀lɛ̌ nú’ǒ, pbɛ́tʉ̀, nyɨ nyɨ́ ɔtsʉ́du mà, dùdu mànà nú’ǒ átɔ̀!» ");
INSERT INTO niy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nɨ́, Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Ɨwà ndɨ̀ nù’o alɛ rɨ̌’ɨ̀ mbǎ ndɨ̀ ndɨ́ ndù’ǒ tdɨ́tdɔ̌ dhu-atdyú nà. Pbɛ́tʉ̀ kà rǎdʉ̀ àkǎ ndù’o pfɔ̌na kɛ̀lɛ̌, ɨwà ndɨ̀ ndɨ̀lǎ kɔ́rɔ́ otu ɔ̌ nɨ́dhunɨ̌. Nyɨ̌ nyʉ́, nyɨ̌ nyɨ̀lǎ wà Kàgàwà-nyɨkpɔ́ ɔ̌. Pbɛ́tʉ̀, nyɨ̌ kɔ́rɔ́ nyɨ̌ nyɨ̀lǎ nzá kà-nyɨ̀kpɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Obhó tɨ́, Yěsù nʉ́ʉnɨ ndìpfǒ rɨ́ ndàbhʉ ndɨ̀ òmvǔ-fɔ́ alɛ angyangyɨ. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ kǎtɨ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̌ kɔ́rɔ́, nyɨ̌ nyɨ̀lǎ nzá Kàgàwà-nyɨ̀kpɔ́ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pbɨ̀ndà ábhàlɨ̌-pfɔ̀ ndɨ̀ ndù’o dhu lutɨ̀nǎ, Yěsù adʉ̀ yà rɔ̀ná rɔ̀ ndɨ̀ ndɨ̀wànà mʉ̀dzarʉ̀ nídyì ndàfɔ̌ rɔ̀ná, ndàdʉ̀ ndàdu ɔ̀nyʉ̀-tsʉ̀. Nɨ́rɔ̀ nɨ́ ndɨ kǐvú dhu pbɨ̀ndà ábhàlɨ̌-tsʉ̌, ndàtɨ: «Nyɨ̌ nyʉ̀nɨ tɨ́ ʉ̀nɨ̌ yà ma mɔ̀nzɨ̀ rʉ̀kʉ́ dhu-tɨ̀? ");
INSERT INTO niy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyɨ̌ nyárɨ́ ɨma nánzi Màlimò tɨ́, ndɨrɔ̀ Ádrʉ̀ngbǎlɛ tɨ́. Nɨ́ ndɨ dhu nɨ́ obhó dhu. Obhó tɨ́, ɨma nɨ́ ndɨ Màlimò. Ndɨrɔ̀, ɨma nɨ́ ndɨ Ádrʉ̀ngbǎlɛ. ");
INSERT INTO niy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɨ́rɔ̀ ɨma, fʉ̀kʉ́ Màlimò tɨ́rɔ̀ nyʉ́, ndɨrɔ̀ fʉ̀kʉ́ Ádrʉ̀ngbǎlɛ tɨ́rɔ̀ nyʉ́, ma mù’o pfɔ̌kʉ rɔ̀, dhu àkǎ nyǒngò pfɔ̌kʉ ù’o nzínzìkʉ ɔ̌ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Obhó tɨ́, yà fʉ̌kʉ̀ ma mɨ̀tɛ̀ dhu nɨ́ ɔ́fɔ̀, ndɨ́nɨ̌ nyɨ̌ nyongó tɨ́ dhu ɔ̀nzɨ̀ átɔ̀ ɔdhɨ́kʉ rɔ̌ yà rʉ̀kʉ́ ma mɔ̀nzɨ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Kasʉtálɛ bhà ádrʉ̀ngbǎnga nósè nzá pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ bhà ádrʉ̀ngbǎnga dɔ̀nǎ. Ndɨrɔ̀, òvì ka kòvì alɛ bhà ádrʉ̀ngbǎnga nósè nzá yà ndɨ̀ nòvì alɛ bhà ádrʉ̀ngbǎnga dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kɔ̀nɨ̌, kòmbí nyɨ̌ nyʉ̀nɨ wà kɔ̌kɔ̀ dhu. Nɨ́, nyɨ̌ nyádʉ̀ hirò ɔ̀nzɨ̀ ɨ dhu nyɨ̌ nyɔ̀nzɨ̀ nɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ma mʉ̀nɔ̀ nzá wɔ̀ dhu okúkʉ dɔ̀ rɔ̀ kɔ́rɔ́. Ma mʉ̀nɨ wà ɨma nyʉ́ ma móvò nzínzìkʉ ɔ̌ alɛ. Pbɛ́tʉ̀, Kàgàwà bhà Andítá arʉ́nɔna dhu nákǎ rɔ̀nzɨ̀ ndɨ̀. Ndɨ Andítá arátɨna: ‹Yà atdíkpá mǎ marɨ́ dhu ɔ̀nyʉ mànà alɛ, nóngò wà rùdú òmvǔ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma mɔ̀vɔ̀ wɔ̀ dhu angyangyɨ fʉ̌kʉ̀, ɨnzá ndɨ dhu àpɛ̀ ndɔ̀nzɨ rɔ́rɔ̀. Ndɨ dhu bhěyi nɨ́ ndɨ, ndɨ dhu rǐtsi ndɔ̀nzɨ̀ nɨ́nganɨ́, nyɨ̌ nya’uya dhu, ɨma ràrɨ̌ ‹Ɨ̀’ɨ̀ arɨ́’ɨ̀ alɛ.› ");
INSERT INTO niy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ma mòvì alɛ nàkɔ alɛ, nákɔ wà ɨma átɔ̀. Ndɨrɔ̀, ɨma nàkɔ alɛ nákɔ wà yà ɨma nivi mɨrà yà adzɨ ɔ̌ alɛ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wɔ̀ dhu bhěyi ndɨ̀ ndɔ̀tɛ̀ dhu-dzidɔ̌, Yěsù-afí náadʉ̀ àdɨ ndàmbɛ ɨnga nɨ́rɛ̀ dɔ̌ atdídɔ̌. Nɨ́, kǎdʉ̀ dhu ɔ̀vɔ̀ kpangba pbɨ̀ndà ábhàlɨ̌ tɔ̀, ndàtɨ: «Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀. Nzínzìkʉ ɔ̌ atdí alɛ rɨ̌ ndɨ mipfǒ, ndàbhʉ ma òmvǔ-fɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nɨ́, Yěsù bhà ábhàlɨ̌ adʉ̀ òko, ’àmbɛ ’àndà dɔ̌ nzínzìya ɔ̌, ɨ̀nzɨ̌ ’àdʉ̀ àdhɨ dɔ̌ màtɨ́ kà rɔ̌tɛ dhu nʉ́nɨ. ");
INSERT INTO niy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, yà atdídɔ̌ Yěsù ózè pbɨ̀ndà ábhàlɨ̌ nzínzì ɔ̌ atdí ábhàlɨ̌ nɨ́ɨ’ɨ̀ Yěsù-tɨ́ ndɨ̀ ndàdɨ ɔ̀nyʉ̀-tsʉ̀nǎ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nɨ́, Sìmonì Pɛ́tɛrʉ̀ adʉ̀ kàvi ìwǐna ɔ̌ rìvǔ dhu Yěsù-tsʉ̌, ràrɨ̌ àdhɨ ndɨ kà rǔbhi ɔ̀tɛ rɔ̌ dɔ̀ná. ");
INSERT INTO niy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nɨ́, wɔ̀ ábhàlɨ̌ adʉ̀ ndìlò Yěsù dɔ̀, ndàdʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ádhɨ ndɨ?» ");
INSERT INTO niy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ndɨ alɛ nɨ́ yà ma mɨ́ mʉ̀gatì-afà nídyì modù supù ɔ̀, madʉ̀ àbhʉnà fɨ̌ndà alɛ.» Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ mʉ̀gatì-afà nídyì, ndòdù supù ɔ̀, ndàdʉ̀ àbhʉnà Yudhà, Sìmonì Ìskàrìyɔtà t’ídhùnà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudhà níitdègu wɔ̀ mʉ̀gatì-afà àkɔ̌, nɨ́ Sìtanɨ̀ adʉ̀ òtsù kà-afí ɔ̀. Nɨ́ Yěsù adʉ̀ àtɨ̀nà Yudhà nɨ̌: «Wɔ̀ nyɨ nyòzè nyɔnzɨ̀ dhu, nákǎ nyɔnzɨ̀ tsàkàtsàkà.» ");
INSERT INTO niy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kɔ̌kɔ̀ ʉrɔ́ ɨ̀’ɨ̀ alɛ nzínzì ɔ̌, atdí alɛ mà nʉ́ʉnɨ nzá àdhu-okú dɔ̀ rɔ̀ màtɨ́ Yěsù rɨ̌ wɔ̀ dhu nʉ́nɔ kà tɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yà fʉ̀rangà tɔ́ ɨ́sɔ̀wʉ̌ nɔ́dɔ Yudhà arɨ́ dhu-okú dɔ̀ rɔ̀, abádhí nzínzì ɔ̌ atdídhená alɛ náadʉ̀ dhu àtɨ̀, Yěsù àvi ka rùdzǐ mʉ̀hɛndʉ̀ tɔ̀ àkǎ kudzǐ dhu dhu tɨ́. Ndɨrɔ̀ ngǎtsi nɨ̌, abádhí adʉ̀ dhu àtɨ̀ Yěsù àvi ka rʉ̀ndɔ̀ fʉ̀rangà nǎkʉ̀tálɛ tɔ̀ dhu tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pbɛ́tʉ̀, mʉ̀gatì-afà ndɨ̀ ndàkɔ Yěsù-fɔ́ rɔ̀, ndàdʉ̀ ɔ̀nyʉ̀nà dhu-dzidɔ̌, Yudhà náadʉ̀ àhʉ dòtsí ndàrà. Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, ɨnga náadʉ̀ ɨ̀’ɨ̀ ɨwà ndɨ̀ ndàtɨ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudhà àhʉ ɨdza rɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Kòmbí nga nɨ́ ndɨ Ìndrǔ t’ídhùnà-ɔvɔ̀ ìlè ndɨ̀ nɨ̌. Ndɨrɔ̀, kòmbí nga nɨ́ ndɨ Kàgàwà-ɔvɔ̀ ìlè ndɨ̀ kà-nyʉtsì nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kàgàwà-ɔvɔ̀ náapɛ́ ndìlè kà-nyʉtsì, nɨ́ Kàgàwà adʉ̀ya kɔ̌vɔ̀ àbhʉ rìlè ndɨ̀ átɔ̀ nyʉnatsì, ndɨrɔ̀ kàrɨ̌ ndɨ kɔ̌vɔ̀ àbhʉ̌ rìlè ndɨ̀ kòmbí tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Pbànɨ̌nzó, àlɛ̌ kɨ́’ɨ̀ atdíkpá nyɨ̌ mànà ákɛ̌ kàsʉmɨ̀ kɛ̀lɛ̌ tɨ́. Nyɨ̌ nyɨ́ mɔnɛ ɔ̀nɛ. Nɨ́ àdhàdhɨ̀ yà ma mʉ̀nɔ̀ Pbàyàhúdí tɔ̀ dhu bhěyi tɨ́, ma mátɨna nyɨ̌ nɨ̌ átɔ̀, yà ma márà ɨ nyɨ̌ ràrɨ̌ nzɨ̌ àdʉ̀ òwu ùvò. ");
INSERT INTO niy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nɨ́, kànɨ̌ fʉ̌kʉ̀ ma mʉ̀bhà ʉyátá ɔwʉ́tá: nyòzè nyɨ̌ nzínzìkʉ ɔ̌. Àdhàdhɨ̀ yà ɨma nyʉ́ ma mózè nyɨ̌ dhu bhěyi, dhu àkǎ nyǒzè nyɨ̌ átɔ̀ nzínzìkʉ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nyɨ̌ nyapɛ́ nyǒzè nzínzìkʉ ɔ̌, nɨ́rɔ̀ nɨ́ ndɨ kɔ́rɔ́ alɛ rǎdʉ̀ dhu ʉ̀nɨ, nyɨ̌ ràrɨ̌ pbàkà ábhàlɨ̌ nyʉ́.» ");
INSERT INTO niy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wɔ̀ dhu-dzidɔ̌, Sìmonì Pɛ́tɛrʉ̀ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, nyɨ nyárà àdhà?» Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Nyɨ nyɨ́ nzɨ̌ ɨ̀rà owùdu ɔ̌ kòmbí, yà ma márà ɨ. Pbɛ́tʉ̀, nyɨ nyaraya ɨ̀rà owùdu ɔ̌ olù.» ");
INSERT INTO niy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ádhu ɨ̀nzɨ̌ ma márà kòmbí owùnʉ ɔ̌ okúna dɔ̀ rɔ̀? Ma mòzè wà miwǐ pbàkà ípìrɔ̌nga okúnʉ dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nɨ́, Yěsù adʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Ɨnyɨ nyʉ́ nyɨ nyòzè tɨ́ wà nyiwǐ pbʉ̀kʉ̀ ípìrɔ̌nga okúdu dɔ̀ rɔ̀? Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀, ɨnzá à’ʉ̌-akpà nápɛ̀ ɔ̀ngɔ̀ rɔ́rɔ̀, nyɨ nyɨ’ɨna ɨwà nyɨ nyɔ̀dhɔ̀ ma ɨ̀bhʉ-gʉ̀na, nyàtɨ ɨnzá nyɨ rʉ́nɨ ma rɔ́.» ");
INSERT INTO niy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ɨ̀nzɨ̌ nyàbhʉ afíkʉ rɨ̀rɛ̀ ɨnga abhɔ. Nyɨ̌ nyàkǎ nyǎ’ù Àba Kàgàwà, ndɨrɔ̀ nyɨ̌ nyàkǎ nyǎ’ù ma átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Àba Kàgàwà bhà ɨdzá, ɔ̀yá ka kóko ngari rɨ̌’ɨ̀ abhɔ. Ɨ̀mbǎ kà rɨ̌’ɨ̀ ndɨ dhu bhěyi nánɨ̌, ma màmbɛ̀nà nzɨ̌ àtɨna ma ràrà wà ngari ɔ̀bhɔ̀lɔ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndɨrɔ̀, ma márà, madʉ̀ ngari ɔ̀bhɔ̀lɔ̀ fʉ̌kʉ̀ rɔ̀, ma mɨ́ madǔ àdǔ mɨrà nyǔgù, ndɨ́nɨ̌ ma márà àdɨ rɔ́, nyɨ̌ nyadʉ̀ya tɨ́ òwu òko átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ndɨrɔ̀, yà ma márà ɨ rárà otu nyɨ̌ nyʉ́nɨ wà.» ");
INSERT INTO niy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nɨ́, Tʉ̀masɨ̀ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, mǎ mʉ̀nɨ nzá nyɨ nyárà ɨ nga. Olu, mǎ mádʉ̀ ányɨ̀ rárà otu nʉ́nɨ ɨ̀ngbà dhu bhěyi?» ");
INSERT INTO niy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nɨ́, Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨma nɨ́ ndɨ otu, obhónga, ndɨrɔ̀ ípìrɔ̌nga. Atdí alɛ mà rɨ̌ nzɨ̌ àdʉ̀ àrà àhʉ Àbadu Kàgàwà ɨ, ɨnzá ndɨ̀ ndʉ̀dà otùdu ɔ̀nǎ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dhu apɛ́ ɨ̀’ɨ̀ ɨwà nyɨ̌ nyʉ́nɨ ma dhu tɨ́, nɨ́ nyɨ̌ nyʉ́nɨ wà Àbadu átɔ̀. Nɨ́, rɔ̀pɛ̀ ndɨ̀ kòmbí, nyɨ̌ nyʉ̀nɨ wà ka, ndɨrɔ̀ nyɨ̌ nyàla wà ka.» ");
INSERT INTO niy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nɨ́, Fìlipò adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ádrʉ̀ngbǎlɛ́, ɨ́tɛ̀ pɛ́ ndɨ Àbanʉ mǎ ràla, wɔ̀rɨ́ kɛ̀lɛ̌ nɨ́ ndɨ àkǎ àkǎ fǎkà dhu.» ");
INSERT INTO niy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nɨ́, Yěsù adʉ̀ dhu àdu Fìlipò tɔ̀, ndàtɨ: «Hɔ̀kɔ̀, Fìlipò! Àlɛ̌ kókò wà nyɨ̌ mànà ábhɔ̌ ɨdhɔ nyʉ́ tɨ́, nɨ́ nyɨ nyàpɛ̀ tɨ́ nzá mʉnɨ̌? Ɨma nála alɛ, nála wà Àbadu átɔ̀. Nɨ́ ɨ́ngbà dhu bhěyi dhu nyɨ nyádʉ̀ àtɨ̀nà, ma rɨ̀tɛ̀ pɛ́ Àbadu nyala nɨ̌? ");
INSERT INTO niy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nyɨ nyà’ù tɨ́ nzá dhu, ma ràrɨ̌’ɨ̀ Àbadu-nyʉtsì, ndɨrɔ̀ Àbadu ràrɨ̌’ɨ̀ nyʉdutsì? Yà ma maráwɛ̌na fʉ̌kʉ̀ dhu nɨ́ nzɨ̌ ùdù rɔ̀ àhʉ dhu. Pbɛ́tʉ̀, yà nyʉdutsì arádɨ Àbadu nɨ́ ndɨ arɨ́ pbɨ̀ndà kasʉ ɔ̀nzɨ. ");
INSERT INTO niy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nyà’u ɨma, yà ma mátɨna nyɨ̌ nɨ̌, ɨma ràrɨ̌’ɨ̀ Àbadu-nyʉtsì, ndɨrɔ̀ Àbadu ràrɨ̌’ɨ̀ nyʉdutsì rɔ̀. Ɨ̀mbǎ kɨ̀’ɨ̀ ndɨ dhu bhěyi rɔ̀, nyà’u ɨma yà nyʉdutsìnǎ rɔ̀ rɨ́ ndɔ̀nzɨ kasʉ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ndɨ alɛ apɛ́ ɨma ná’u, nɨ́ yà ma márɔ́nzɨna kasʉ nɔ́nzɨ̀ ndɨ alɛ rǎdʉ̀ ɔ̀nzɨ átɔ̀. Ndɨrɔ̀, kà rǎdʉ̀ kɔ̀nzɨ̀ abhɔ nyʉ́ ròsè yà ma marɔ́nzɨna-tsí dɔ̀nǎ, Àbadu bhà ma márà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ɔvɔ̀du rɔ̌ nyɨ̌ nyònzì kɔ́rɔ́ dhu-tsí, nɔ́nzɨ̀ ma móngo ɔ̀nzɨ, ndɨ́nɨ̌ Àbadu-ɔvɔ̀ náadʉ̀ tɨ́ ndìlè Idhùnà-nyʉtsì. ");
INSERT INTO niy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nyɨ̌ nyapɛ́ óngo dhu nónzì fudú ɔvɔ̀du rɔ̌, nɔ́nzɨ̀ ma móngo ɔ̀nzɨ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Nyɨ̌ nyapɛ́ ɨ̀’ɨ̀ ɨma nyɨ̌ nyózè dhu tɨ́, nɨ́ nyɨ̌ nyàkǎ nyɨ̌fʉ pbàkà ʉyátá. ");
INSERT INTO niy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɨma, ma mɨ́ Àbadu Kàgàwà nónzi rìbhò ngǎtsi Mʉ̀dzʉ̀nàba fʉ̌kʉ̀, ndɨ́nɨ̌ nyɨ̌ nyongó tɨ́ òko mànà dhòdhódhónganà. ");
INSERT INTO niy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ka nɨ́ obhónga núdhě arɨ́ ìndrǔ tɔ̀ Ɨ̀lɨ̌lǎ-Alafí. Obhó tɨ́, yà adzɨ ɔ̌ alɛ rɨ̌ nzɨ̌ àdʉ̀ kàkɔ, ɨ̀nzɨ̌ ɨ̀ ɨ́ kàlǎ, ndɨrɔ̀ ɨnzá ɨ̀ ʉ́nɨ ka dhu-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyʉ́nɨ wà ka, atdíkpá nyɨ̌ nyaróko ka mànà, ndɨrɔ̀ afíkʉ ɔ̀ kǎrádɨ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma mɨ́ nzɨ̌ nyʉ̌bha ɨ̀zʉ̀ tɨ́, ma míngo ìngo tɨkʉ ɔ̀ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɨnzá ɔ̀trɔ̀ ɨdhɔ ɔ̌, yà adzɨ ɔ̌ alɛ rɨ̌ nzɨ̌ malǎ tdɨ́tdɔ̌. Pbɛ́tʉ̀ nyɨ̌, nyɨ̌ nyɨ́ malǎ àlǎ, inè ma mɨ’ɨya nyɨ̀kpɔ́du nà, ndɨrɔ̀ inè nyɨ̌ nyɨ’ɨya nyɨ̀kpɔ́kʉ nà átɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ndɨ ɨdhɔ rǎkǎ nɨ́nganɨ́ nɨ́ ndɨ, nyɨ̌ nyʉnɨya dhu, ɨma rarɨ́’ɨ̀ ìnè Àbadu-nyʉtsì, nyɨ̌ rarɨ́’ɨ̀ ìnè nyʉdutsì, ndɨrɔ̀ ma rarɨ́’ɨ̀ ìnè nyʉkʉtsì. ");
INSERT INTO niy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pbàkà ʉyátá nà’ù, ndàdʉ̀ ɨ̀fʉnà alɛ, nɨ́ ndɨ ma nózè alɛ. Ɨma nózè alɛ, nózè Àbadu rǎdʉ̀ átɔ̀. Ndɨrɔ̀, ma mádʉ̀ kòzè átɔ̀, madʉ̀ mɨtɛ̀ fɨ̌ndà.» ");
INSERT INTO niy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nɨ́rɔ̀ nɨ́ ndɨ Yudhà, ɨ̀nzɨ̌ nɨ́ Yudhà Ìskàrìyɔtà, níivú dhu Yěsù-tsʉ̌, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ádhu ndɨ nyɨ nyádʉ̀ nyɨtɛ̀ fǎkà tɨ́, ɨ̀nzɨ̌ nyadʉ̀ nyɨtɛ̀ yà adzɨ ɔ̌ ngʉ̌kpà alɛ tɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ndɨ alɛ náapɛ́ ɨma nózè, nɨ́ ndɨ alɛ rǎdʉ̀ ma mʉ́nɔna dhu nɨ́fʉ. Àbadu rǎdʉ̀ ndɨ alɛ nózè átɔ̀. Ndɨrɔ̀, mǎ mádʉ̀ ìwu Àbadu mànà ndɨ alɛ bhà, mǎdʉ̀ mǎ móko rɔ́nga nɔ́bhɔ̀lɔ̀ kàbhà. ");
INSERT INTO niy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pbɛ́tʉ̀, ɨ̀nzɨ̌ ndɨ alɛ náapɛ́ mozè, nɨ́ rɨ̌ nzɨ̌ àdʉ̀ ma mʉ́nɔna dhu nɨ́fʉ. Yà nyɨ̌ nyɨ́rɨna ma mʉ́nɔna rɔ́ dhu nɨ́ rɨ̌ nzɨ̌ àhʉ ùdù rɔ̀. Pbɛ́tʉ̀, kà rǎhʉ yà ma nívì Àbadu ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kɔ̀nɨ̌, ma mʉ̀nɔ̀ ndɨ dhu fʉ̌kʉ̀, àdɨ̀ ma màdɨ̀ nzínzìkʉ ɔ̌ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nɨ́, Àbadu rǐvìna ɔvɔ̀du rɔ̌ Mʉ̀dzʉ̀nàba, Ɨ̀lɨ̌lǎ-Alafí, rǒngo kɔ́rɔ́ dhu núdhe fʉ̌kʉ̀, ndàdʉ̀ àrà yà fʉ̌kʉ̀ ma mʉ́nɔ̀ kɔ́rɔ́ dhu nábhʉ rɔ̌ nyɨ̌rɛ̀. ");
INSERT INTO niy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ma mʉ̀bhà màrʉ̀ngà fʉ̌kʉ̀, ma màbhʉ pbàkà màrʉ̀ngà nyʉ́ fʉ̌kʉ̀. Ndɨrɔ̀, ma màbhʉ nzá ka fʉ̌kʉ̀ àdhàdhɨ̀ yà adzɨ ɔ̌ alɛ náarɨ́ kàbhʉ̌ ìndrǔ tɔ̀ ɔ̀ná ɔ́fɔ̀ ɔ̌. Nɨ́, afíkʉ àkǎ nzá ndɨ̀rɛ̀ nga abhɔ, ndɨrɔ̀ nyɨ̌ nyàkǎ nzá nyɔ̌nzɨ̀ ɔdɔ. ");
INSERT INTO niy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nyɨ̌ nyɨ́rɨ̀ wà yà fʉ̌kʉ̀ ma mʉ́nɔ̀ dhu, matɨ: ‹Ma màrà wà, ndɨrɔ̀ ma mɨ́ madǔ àdǔ tɨkʉ ɔ̀.› Nɨ́ nyɨ̌ nyɨ́’ɨ̀ná gukyè ɨma nyɨ̌ nyózè dhu tɨ́, nɨ́ ɨdhɛ̀kʉ àmbɛ̀nà ndɨ̀kǎ ɨ̀kǎ tɨ́ Àbadu ɨ ma márà rɔ̀. Obhó tɨ́, ndɨ Àbadu bhà ádrʉ̀ngbǎnga nósè wà pbàkà ádrʉ̀ngbǎnga dɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kɔ̀nɨ̌, ma mʉ̀nɔ̀ wà ka fʉ̌kʉ̀ kòmbí ɨnzá ndɨ dhu àpɛ̀ ndɔ̀nzɨ rɔ́rɔ̀, ndɨ́nɨ̌ ndɨ dhu rɨ̌ ndɔ̀nzɨ nɨ́nganɨ́, nyɨ̌ nyadùya tɨ́ dhu à’ù. ");
INSERT INTO niy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma mɨ́ nzɨ̌ ɔ̀tɛ abhɔ nyɨ̌ mànà tdɨ́tdɔ̌. Obhó tɨ́, kɔ̀nɨ̌ yà adzɨ ɔ̌ kamà Pfɔ̀mvɔ rɨ̌rà. Pbɛ́tʉ̀, rùdú kà rɔ̌nzɨna atdí dhu mà rɨ̌’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pbɛ́tʉ̀, kà rɨ̌rà, ndɨ́nɨ̌ yà adzɨ ɔ̌ alɛ nʉ́ʉnɨ tɨ́ dhu ɨwà ma rózè Àbadu, ndɨrɔ̀ ma rarɨ́ dhu ɔ̀nzɨ kʉ̌yǎ idù dhu bhěyi. Nɨ́rɔ̀, nyɨ̀và nyɨ̌, kòwu ɨrɔ́ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ɨma nɨ́ ndɨ vǐnyò-kpa nyʉ́. Ndɨrɔ̀, Àbadu Kàgàwà nɨ́ ndɨ vǐnyò-kpa-ngbɔ̀ ɔ̀bhɔlɔ arɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nɨ́ kɔ́rɔ́ ɔpbɨ́du, yà ɨ̀nzɨ̌ arɨ́ itsu-kpɔ̌ ɨ̀’ɔ̌, nʉ́’a kà rǎdʉ̀ ʉ̀’ǎ tɨ́ rùdú rɔ̀. Ndɨrɔ̀, yà mběyi arɨ́ itsu-kpɔ̌ ɨ̀’ɔ̌ ɔpbɨ́du-ngbɔ̀ nʉ́wa kà rǎdʉ̀, ndɨ́nɨ̌ adʉ̀ tɨ́ itsu-kpɔ̌ ɨ̀’ɔ abhɔ nyʉ́ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nɨ́ nyɨ̌, ɔpbɨ́du tɨ́rɔ̀, nyɨ̌ nyɨ́lǎ wà Àbadu-nyɨ̀kpɔ́ ɔ̌, yà fʉ̌kʉ̀ ma mɔ́vɔ̀ ɔtɛ-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nɨ́rɔ̀, dhu àkǎ nyǒkò nyʉdutsì, àdhàdhɨ̀ ma marádɨ nyʉkʉtsì dhu bhěyi. Vǐnyò-ɔpbɨ́ rɨ̌ nzɨ̌ àdʉ̀ ɔ̀’ɔ̀, ɨ̀mbǎ ndɨ̀ ndɨ́’ɨ̀ ndɨ vǐnyò-kpa rɔ̌ rɔ́rɔ̀. Nɨ́, ndɨ dhu bhěyi tɨ́, nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ atdí dhu mà nɔ́nzɨ̀ ɨnzá nyɨ̌ nyòkò nyʉdutsì rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ɨma nɨ́ ndɨ vǐnyò-kpa, ndɨrɔ̀ nyɨ̌ nɨ́ vǐnyò-ɔpbɨ́. Nɨ́, nyʉdutsì rádɨ, madʉ̀ àdɨ nyʉnatsì alɛ, rǎdʉ̀ itse nɔ́dhɨ̀ abhɔ nyʉ́. Obhó tɨ́, ɨnzá nyɨ̌ nyòkò nyʉdutsì rɔ̀, nyɨ̌ nyɨ́ nzɨ̌ àdʉ̀ atdí dhu mà nɔ́nzɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɨnzá àdɨ nyʉdutsì alɛ, nóbvù ka kádʉ̀ igi, àdhàdhɨ̀ yà ɨ̀nzɨ̌ arɨ́ itsu-kpɔ̌ ɨ̀’ɔ̌ vǐnyò-ɔpbɨ́ nʉ́’à ka karɨ́, kadʉ̀ òbvùnà igi dhu bhěyi. Kà rǎdʉ̀ òtdyù, kadʉ̀ àndunà kawà kàzʉ ɔ̀, ràdʉ̀ ògbe. ");
INSERT INTO niy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pbɛ́tʉ̀, nyɨ̌ nyapɛ́ òko nyʉdutsì, nyǎdʉ̀ pbàkà ɔtɛ nɔ́dɔ̀ afíkʉ ɔ̀, nɨ́ nyònzi nyɨ̌ nyòzè kɔ́rɔ́ dhu Àbadu-fɔ́, nɨ́ ka rǎdʉ̀ ndɨ dhu àbhʉ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nyɨ̌ nyapɛ́ ídzì kasʉ tɔ́ itse nɔ́dhɨ abhɔ, nyǎdʉ̀ dhu ɨ̀tɛ̀ nyɨ̌ ràrɨ̌ pbàkà ábhàlɨ̌ nyʉ́, nɨ́ Àbadu-ɔvɔ̀ rǎdʉ̀ ndìlè. ");
INSERT INTO niy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Àdhàdhɨ̀ Àbadu ózè ma dhu bhěyi, ma mózè nyɨ̌ átɔ̀. Nɨ́ dhu àkǎ nyǒkò ndɨ ma mózè nyɨ̌ nɨ̌ àzè ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nyɨ̌ nyapɛ́ pbàkà ʉyátá nɨ́fʉ̌, nɨ́ nyɨ̌ nyádʉ̀ òko nyɨ̌ ma mózè nɨ̌ àzè ɔ̌, àdhàdhɨ̀ ma mɨ́fʉ Àbadu bhà ʉyátá, madʉ̀ àdɨ kǒzè ma nɨ̌ àzè ɔ̌ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma mʉ̀nɔ̀ wɔ̀ dhu fʉ̌kʉ̀ ndɨ́nɨ̌ nyɨ̌ nabhʉ̀ tɨ́ nyɨ̌’ɨ̀ pbàkà dhɛ̀dhɛ nà, ndɨ fʉ̀kʉ́ dhɛ̀dhɛ ràdʉ̀ àkǎ. ");
INSERT INTO niy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yàrɨ́ nɨ́ ndɨ pbàkà ʉyátá fʉ̌kʉ̀: ‹Nyòzè nyɨ̌ nzínzìkʉ ɔ̌, àdhàdhɨ̀ ma mózè nyɨ̌ dhu bhěyi.› ");
INSERT INTO niy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ìndrǔ rɨ̌ ndàdzǐ ndɔ̀vɛ̀ ɔdhɨ́na tɔ́ ngari ɔ̌ nɨ̌ àzè dɔ̀nǎ róse ngǎtsi àzè rɨ̌’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyɨ̌ nyádʉ̀ òko ɔdhɨ́du tɨ́, yà fʉ̌kʉ̀ ma mʉ̀yǎ dhu nyɨ̌ nyɨ̀fʉ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma mɨ́ nzɨ̌ nyǎnzi tdɨ́tdɔ̌ pbàkà kasʉtálɛ tɨ́, ɨ̀nzɨ̌ kasʉtálɛ rǎdʉ̀ pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ rɔ̌nzɨna dhu nʉ́nɨ nɨ́dhunɨ̌. Pbɛ́tʉ̀, ma márɨ́ nyǎnzi ɔdhɨ́du tɨ́, Àbadu-tsʉ̌ ma mɨrɨ dhu nɨ́ ma mɔ́vɔ̀ wà kɔ́rɔ́ fʉ̌kʉ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɨ̀nzɨ̌ nɨ́ nyɨ̌ ndɨ nyɨ̌ nyóvò ma, pbɛ́tʉ̀ ɨma nɨ́ ndɨ ma móvò nyɨ̌. Nɨ́, ma mòvì nyɨ̌ nyǒwù, ndɨ́nɨ̌ nyɨ̌ nyɔdhɨ tɨ́ dhòdhódhónganà róngo àdɨ itse. Ndɨ dhu bhěyi nɨ́ ndɨ, Àbadu rǎdʉ̀ fɔná nyɨ̌ nyònzì ɔvɔ̀du rɔ̌ kɔ́rɔ́ dhu-tsí nábhʉ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nɨ́rɔ̀, fʉ̌kʉ̀ ma mʉ̀yǎ dhu nɨ́, nyɨ̌ ràkǎ nyǒzè nyɨ̌ nzínzìkʉ ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Tdɨ́tdɔ̌ Yěsù àdʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Yà adzɨ ɔ̌ alɛ náapɛ́ nyɔ̌ndrɔ̀, nɨ́ nyʉ̀nɨ dhu abádhí rɔ́ndrɔ̀ wà ɨma átɔ̀ angyinǎ rɔ̀ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nyɨ̌ nyɨ́’ɨ̀yana gukyè yà adzɨ ɔ̌ alɛ tɨ́, nɨ́ abádhí ádʉ̀yana nyǒzè òzè tɨ́, fɨ̌yɔ́ alɛ nɨ́ nyɨ̌ nɨ́dhunɨ̌. Pbɛ́tʉ̀ ɨma, ma móvò nyɨ̌ abádhí nzínzì ɔ̌ rɔ̀, mʉlɨ nyɨ̌ igi. Nɨ́ nyɨ̌ nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ tdɨ́tdɔ̌. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ abádhí ɔ́ndrɔ̀ nyɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nyɨ̀rɛ̀ pɛ́ yà fʉ̌kʉ̀ ma mʉ́nɔ̀ dhu, matɨ: Kasʉtálɛ bhà ádrʉ̀ngbǎnga rósè nzá pbɨ̀ndà kasʉ tɔ́ ádrʉ̀ngbǎlɛ bhà ádrʉ̀ngbǎnga dɔ̀nǎ. Nɨ́, dhu apɛ́ ɨ̀’ɨ̀ abádhí ávu rùdú dhu tɨ́, nɨ́ abádhí rǎvu àvǔ rʉ̀kʉ́ átɔ̀. Ndɨrɔ̀, dhu apɛ́ ɨ̀’ɨ̀ abádhí ɨ́fʉ ma múdhe fɨ̌yɔ̀ dhu dhu tɨ́, nɨ́ abádhí rɨ̌ nyɨ̌ nyúdhěna fɨ̌yɔ̀ dhu nɨ́fʉ̌ ɨ̀fʉ̌ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Obhó tɨ́, abádhí rǒngo kɔ́rɔ́ kɔ̌kɔ̀ dhu ɔ̀nzɨ̀ rʉ̀kʉ́ okúdu dɔ̀ rɔ̀, ɨnzá ɨ̀ ʉ́nɨ ɨma nívì mɨrà yà adzɨ ɔ̌ alɛ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ɨnzá ma mɨ́rà yà adzɨ ɔ̌, madʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀ nánɨ̌, abádhí ʉ́nɨ̌yana nzɨ̌ nzɛ́rɛnga nà ɨ̀ ɨ́’ɨ̀ dhu. Pbɛ́tʉ̀, kòmbí abádhí dɔ̌ ka kɨ́ ɨzʉ àbà kʉbà fɨ̀yɔ́ nzɛ́rɛnga tɨ́ dhu rɨ̌’ɨ̀ mbǎ. ");
INSERT INTO niy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɨma nɔ̀ndrɔ̀ alɛ nɔ́ndrɔ̀ wà Àbadu átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ɨnzá ma mɔ́nzɨ̀ yà ɨnzá atdí alɛ mà nápɛ̀ ɔ̀nzɨna dhu abádhí nzínzì ɔ̌ nánɨ̌, abádhí ʉ́nɨ̌yana nzɨ̌ nzɛ́rɛnga nà ɨ̀ ɨ́’ɨ̀ dhu. Pbɛ́tʉ̀, kòmbí abádhí àla wà ma mɔ́nzɨ̀ dhu. Nɨ́ ɨwà ɨ̀ àla ɨ dhu rɔ́rɔ̀ màtɨ́, abádhí òko òko ɨma ɨ̀ ɔ́ndrɔ̀, ’àdʉ̀ Àbadu nɔ́ndrɔ̀ átɔ̀ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Abádhí ɔ́nzɨ̀ kɔ̀rɨ́ dhu kɔ́rɔ́, ndɨ́nɨ̌ fɨ̀yɔ́ ʉyátá ɔ̀ ka kʉnɔ dhu náaká tɨ́. Ndɨ ʉyátá ɔ̀ ka katɨ: ‹Abádhí ɔ́ndrɔ̀ ɨma ɨ̀mbǎ tɨ̌ná na.›» ");
INSERT INTO niy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tdɨ́tdɔ̌ Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Àbadu Kàgàwà-tɨ’ɔ̀ rɔ̀, ma mɨ́ Mʉ̀dzʉ̀nàba nívì ìvì fʉ̌kʉ̀. Ndɨ Mʉ̀dzʉ̀nàba nɨ́ kà bhà rɔ̀ rɨ́rà obhónga tɔ́ Ɨ̀lɨ̌lǎ-Alafí. Nɨ́ kà rɨ̌rà àhʉ rɔ̀, ka nɨ’ɨya ndɨ pbàkà ngàmbì. ");
INSERT INTO niy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ndɨrɔ̀, nyɨ̌ nyʉ́ mà átɔ̀, nyɨ̌ nɨ’ɨya pbàkà ngàmbì, yà ndɨ̀ napɛ̀na rɔ̀, àlɛ̌ karɨ́’ɨ̀ ìnè atdíkpá nyɨ̌ mànà dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ma mɔ̀vɔ̀ wɔ̀ dhu angyangyɨ fʉ̌kʉ̀, akyɛ nyɨ̌ nyowuya nyǎwà fʉ̀kʉ́ a’uta ɔ̌ rɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka kowuya nyǐpfo rɔ̌, kodì nyɨ̌ unduta-dzà ɔ̌ rɔ̀. Ndɨrɔ̀, yà rɨ́rà kàsʉmɨ̀ ɔ̌, nyɔ̌kyɛ rɨ́ alɛ nóowuya dhu ʉ̀nɨ rɔ̌ Kàgàwà ràrɨ̌ yà ɨ̀ ʉ́lɛ̌na. ");
INSERT INTO niy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ndɨrɔ̀, abádhí owuya ndɨ dhu ɔ̀nzɨ̀ rɔ̌ ɨnzá ɨ̀ ʉ́nɨ Àbadu Kàgàwà mà, ndɨrɔ̀ ɨnzá ɨ̀ ʉ́nɨ ɨma mà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nɨ́rɔ̀, ma mɔ̀vɔ̀ wɔ̀ dhu angyangyɨ fʉ̌kʉ̀, ndɨ́nɨ̌ ndɨ kàsʉmɨ̀ rǎkǎ rɔ̀, nyɨ̌ nyɨrɛ̀ya tɨ́ dhu, ɨwà ma ravɔ̀ ka fʉ̌kʉ̀.» Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ma mɔ́vɔ̀ nzá wɔ̀ dhu angyangyɨ fʉ̌kʉ̀, òko àlɛ̌ kòko atdíkpá nyɨ̌ mànà dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nɨ́rɔ̀, kànɨ̌ kòmbí ma màdu wà ma yà ma nívì mɨrà yà adzɨ ɔ̌ alɛ-tɨ’ɔ̀. Ndɨrɔ̀, nzínzìkʉ ɔ̌ atdí alɛ mà nívǔ nzá dhu tsʉ̀dú, ndàtɨ: ‹Nyɨ nyárà àdhà?› ");
INSERT INTO niy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Obhó tɨ́, wɔ̀ dhu bhěyi mà mɔ̀vɔ̀ fʉ̌kʉ̀ dhu nábhʉ wà nyɨ̌ ɨzʉ rʉ̀ka nyɨ̌ atdídɔ̌! ");
INSERT INTO niy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nɨ́rɔ̀, kànɨ̌ ma mɨ́ obhó dhu nɔ́vɔ fʉ̌kʉ̀ kòmbí: ídzì dhu tɨ́ àkǎ atdídɔ̌ fʉ̌kʉ̀ dhu nɨ́ marà Àbadu Kàgàwà-tɨ’ɔ̀. Obhó tɨ́, ɨnzá ma màrà kà-tɨ’ɔ̀ rɔ̀, kàbhà rɔ̀ àmbɛ̀nà ɨ̀rà Mʉ̀dzʉ̀nàba rɨ̌ nzɨ̌ àdʉ̀ ɨ̀rà tɨkʉ ɔ̀. Pbɛ́tʉ̀, ma mapɛ́ àrà, nɨ́ ma mádʉ̀ ndɨ Mʉ̀dzʉ̀nàba nívì ìvì rɨ̀rà tɨkʉ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɨ́ kà rɨ̌rà àhʉ rɔ̀, kà rǒngo yà adzɨ ɔ̌ alɛ tɔ́ nzɛ́rɛnga nɨ́tɛ̀ abádhí tɔ̀, ndàdʉ̀ abádhí àkǎnà ’ùbhi ɔ̀ná obhónánga tɔ́ otu nɨ́tɛ̀ abádhí tɔ̀. Ndɨrɔ̀, kà rǒngo àdʉ̀ Kàgàwà nɨ́ɨtdɨ̀ya anya ìndrǔ-dɔ̌ tɨ́ dhu nɨ́tɛ̀ átɔ̀ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kà rǒngo ɨnzá abádhí ná’ù ɨma dhu tɔ́ nzɛ́rɛnga nɨ́tɛ̀ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kà rǒngo obhónánga nɨ́tɛ̀ fʉ̌kʉ̀, ma mɨ́ madǔ Àbadu-tɨ’ɔ̀, ɨ̀nzɨ̌ nyǎdʉ̀ òwu ma àla rɔ̌ tdɨ́tdɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ndɨrɔ̀, kà rǒngo Kàgàwà rɨ̌ anya ɨ̀tdɨ̀ ìndrǔ dɔ̌ tɨ́ dhu nɨ́tɛ̀, ɨwà kǎtdɨ̀ anya angyangyɨ yà adzɨ ɔ̌ ádrʉ̀ngbǎlɛ Pfɔ̀mvɔ dɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ma mɨ́’ɨ̀ ìnè fʉ̌kʉ̀ ma mʉ́nɔna tdɨ́tdɔ̌ ábhɔ̌ dhu nyʉ́ nà. Pbɛ́tʉ̀, ɨ dhu rɨ̌ nzɨ̌ àdʉ̀ dʉ̀kʉ àlʉ kòmbí. ");
INSERT INTO niy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ndɨ Ɨ̀lɨ̌lǎ-Alafí, yà obhónga nɨ́tɛ̀ rɨ́ ìndrǔ tɔ̀ rɨ̌rà àhʉ rɔ̀, kà rǒngo nyʉ̌ndà kɔ́rɔ́ obhónga tɔ́ otu ɔ̌. Obhó tɨ́, kà rɨ̌ nzɨ̌ ongo ɔ̀nà rɔ̀ nyʉ́ àhʉ dhu nʉ́nɔ̀ ìndrǔ tɔ̀. Pbɛ́tʉ̀, kà rǒngo ʉ̀nɔ̀nà fʉ̌kʉ̀ dhu nɨ́ Àbadu-tsʉ̌ ndɨ̀ ndɨ́rɨna dhu. Ndɨrɔ̀, kà rǒngo ɔ̀vɔ̀nà fʉ̌kʉ̀ dhu nɨ́ ɨ̀ nɔnzɨya dhu. ");
INSERT INTO niy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kǎraya ɔvɔ̀du nábhʉ rɔ̌ rìlè ndɨ̀, ma maraya dhu náwɛ rɔ̌ kà tɔ̀, kà ràdʉ̀ ʉ̀dànà fʉ̌kʉ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Àbadu-fɔ́ rɨ́’ɨ̀ kɔ́rɔ́ dhu nɨ́ pbàkà dhu. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma màtɨ nyɨ̌ nɨ̌, obhónga tɔ́ ndɨ Ɨ̀lɨ̌lǎ-Alafí raraya ma màwɛ fɨ̌ndà dhu nʉ́dà rɔ̌ fʉ̌kʉ̀.» ");
INSERT INTO niy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tdɨ́tdɔ̌, Yěsù adʉ̀ àtɨ̀nà pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ngúfe ɨdhɔ ɔ̌, nyɨ̌ nyɨ́ nzɨ̌ malǎ. Ndɨrɔ̀, ngúfe ɨdhɔ dzidɔ̌, nyɨ̌ nyɨ́ malǎ àlǎ tdɨ́tdɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nɨ́, kàbhà ábhàlɨ̌ nzínzì ɔ̌ atdídhená alɛ náadʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀ kà rǎwɛ̌na àlɛ̌ tɔ̀ dhu-tɨ̀ nɨ́ àdhu? Kà rǎtɨna: ‹Ngúfe ɨdhɔ dzidɔ̌, nyɨ̌ nyɨ́ nzɨ̌ malǎ, ndɨrɔ̀ ngúfe ɨdhɔ dzidɔ̌, nyɨ̌ nyɨ́ malǎ àlǎ tdɨ́tdɔ̌.› Ndɨrɔ̀, kà rǎtɨna átɔ̀: ‹Ma márà Àbadu Kàgàwà-tɨ’ɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Abádhí adʉ̀ òko, ’àmbɛ dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá tdɨ́tdɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀ kà rʉ̌nɔna ngúfe ɨdhɔ-tɨ̀ nyʉ́ nɨ́ àdhu?» Nɨ́, abádhí adʉ́nà òwu dhu àdu rɔ̌ ɨ̀tɨ́rɔ̀ tɨ́, ’àtɨ: «Ɨnzá àlɛ̌ kʉ̀nɨ wɔ̀ kà rʉ̌nɔna dhu-tɨ̀.» ");
INSERT INTO niy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nɨ́, Yěsù ʉnɨ dhu abádhí ràrɨ̌ dhu ɔ̀nzɨ ndɨ́nɨ̌ ɨ̀ ivú tɨ́ dhu tsʉ̀ná. Nɨ́ kǎdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyátɨ́ dhu ɔ̀ngʉ̀ tsʉ̀kʉ́ nzínzìkʉ ɔ̌, yà ma mʉ̀nɔ̀ dhu dɔ̌? Ma màtɨ, ngúfe ɨdhɔ dzidɔ̌ nyɨ̌ ràrɨ̌ nzɨ̌ malǎ, ndɨrɔ̀, ngúfe ɨdhɔ dzidɔ̌, nyɨ̌ ràrɨ̌ malǎ àlǎ tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: Nyɨ̌ nyɔdzɨya, ɨzʉ ràdʉ̀ nyʉ̌ka atdídɔ̌ fʉ̀kʉ́ àpbɛ̀-okú dɔ̀ rɔ̀. Pbɛ́tʉ̀, ndɨ dhu adʉ̀ya yà adzɨ ɔ̌ alɛ-ɨdhɛ̀ nábhʉ rɨ̀ka ndɨ̀ ɨ̀kǎ tɨ́. Ndɨrɔ̀, nyɨ̌ nyokoya ɨzʉ̀kʉ ɔ̌, pbɛ́tʉ̀ fʉ̀kʉ́ ɨzʉ náadʉ̀ya ndʉ̀gɛ̀rɛ̀, ndòngò dhɛ̀dhɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɔ̀na rɨ̌ ndàkà tsìbhálɛ, náaróngo ɨ̀’ɨ̀ ɨzʉ ɔ̌, ndɨ̀ ndɨ́ ndʉ̀gʉ ɔ̀ná kàsʉmɨ̀ níndù wà ndɨ̀ nɨ́dhunɨ̌. Pbɛ́tʉ̀ ndɨ̀ ndʉ̀gʉ̀ ndɨ̀ rɔ̀, kà rɨ̌ nzɨ̌ àdʉ̀ yà ndɨ̀ ndàbànà àpbɛ̀ nɨ́rɛ̀ tdɨ́tdɔ̌, ngbángba ndɨ̀ ndʉ̀gʉ̀ yà adzɨ ɔ̌ dhu ɨ̀ka ɨdhɛ̀na dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɨ́rɔ̀, nyɨ̌ nyʉ́ mà átɔ̀, nyɨ̌ nyɨ́’ɨ̀ ɨzʉ nà kòmbí. Pbɛ́tʉ̀, ma mɨ́ nyǎlǎ àlǎ tdɨ́tdɔ̌. Nɨ́rɔ̀ nɨ́ ndɨ ɨdhɛ̀kʉ nɨ́ɨkaya ndɨ̀, ɨ̀nzɨ̌ atdí alɛ mà ràdʉ̀ ndɨ fʉ̀kʉ́ dhɛ̀dhɛ nɔ́tdɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ndɨ ɨdhɔ rɨ̌rà nɨ́nganɨ́, nyɨ̌ nyowuya nzɨ̌ atdí dhu mà nívu rɔ̌ tsʉ̀dú. Ma mɨ́ obhó dhu nʉ́nɔ fʉ̌kʉ̀: ɔvɔ̀du rɔ̌ nyɨ̌ nyònzì kɔ́rɔ́ dhu, nábhʉ Àbadu Kàgàwà rǒngo àbhʉ̌ fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Rɨ̀rà àhʉ kòmbínga ɔ̀, nyɨ̌ nyàpɛ̀ nzá atdí dhu mà nónzi kà-fɔ́ ɔvɔ̀du rɔ̌. Nɨ́rɔ̀, nyòngò dhu ònzì kà-fɔ́, nɨ́ kà rǒngo àdʉ̀ ndɨ dhu nábhʉ àbhʉ̌ fʉ̌kʉ̀, ndɨ́nɨ̌ ɨdhɛ̀kʉ náadʉ̀ tɨ́ ndɨ̀ka atdídɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yěsù adʉ̀ àtɨ̀nà tdɨ́tdɔ̌ pbɨ̀ndà ábhàlɨ̌ nɨ̌: «Ma mʉ̀nɔ̀ kɔ̌kɔ̀ dhu fʉ̌kʉ̀ mbólí ɔ̌. Pbɛ́tʉ̀, kàsʉmɨ̀ rɨ̌rà ɨ̀rà, yà ɨ̀nzɨ̌ ma móngo dhu ɔ̀vɔ̀ ɔ̀ná fʉ̌kʉ̀ mbólí ɔ̌. Ndɨ kàsʉmɨ̀ ɔ̌, ma móngo Àbadu Kàgàwà dɔ̌ dhu nɔ́vɔ̀ kpangba fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ndɨrɔ̀, ndɨ kàsʉmɨ̀ ɔ̌, nyɨ̌ nyóngo dhu ònzì ɔvɔ̀du rɔ̌ Àbadu-fɔ́. Ma màtɨ nzá nyɨ̌ nɨ̌, ma ràrɨ̌ ndɨ òngo mɨtsɔ̀ Àbadu rɔ̌ okúkʉ dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Obhó tɨ́, Àbadu nyʉ́ ndɨ̀tɨ́rɔ̀ nózè wà nyɨ̌, nyɨ̌ nyózè ɨma, nyǎdʉ̀ dhu à’ù, ma rɨ́rà Kàgàwà-tɨ’ɔ̀ rɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɨma nyʉ́, ma mɨ́rà Àbadu-tɨ’ɔ̀ rɔ̀, mɨrà àhʉ yà adzɨ ɔ̌. Nɨ́ kòmbí, ma mɨ́ mɨvà yà adzɨ ɔ̌ rɔ̀, madu ma kà ɨ.» ");
INSERT INTO niy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nɨ́, Yěsù bhà ábhàlɨ̌ àdʉ̀ àtɨ̀nà kà nɨ̌: «Kɔ̀nɨ̌, kòmbí nga nɨ́ ndɨ nyɨ nyɔ̀tɛ̀ kpangba fǎkà, ɨ̀nzɨ̌ nyʉnɔ̀ atdí dhu mà mbólí ɔ̌ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndɨrɔ̀ kòmbí mǎ mʉ̀nɨ wà dhu, nyɨ rʉ́nɨ wà kɔ́rɔ́ dhu, ndɨrɔ̀ nyɨ rarɨ́ ìndrǔ rɨ̌rɛ̀na ndɨ́nɨ̌ ndɨ̀ ndivú tɨ́ dhu nʉ́nɨ̌ angyangyɨ. Ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ, mǎ mà’ù wà dhu nyɨ rɨ́rà Kàgàwà-tɨ’ɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nɨ́, Yěsù àdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyà’ù tɨ́ wà dhu kòmbí? ");
INSERT INTO niy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kànɨ̌ kàsʉmɨ̀ rɨ̌rà, ndɨrɔ̀, ndɨ kàsʉmɨ̀ nyʉ́ nákǎ wà. Nɨ́, nyɨ̌ nyɨ́ nyɨ̌ndà rùdú rɔ̀, ngǎtsi alɛ ròdyì otùna, nyǎdʉ̀ mʉbhà atdírɔ̀. Pbɛ́tʉ̀, ma mɨ́ nzɨ̌ mʉbha atdírɔ̀, ìnè Àbadu rɨ̌’ɨ̀ atdíkpá ɨma mànà nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma mɔ̀vɔ̀ wɔ̀ dhu fʉ̌kʉ̀ ndɨ́nɨ̌ nyɨ̌ nyabá tɨ́ màrʉ̀ngà nyʉdutsì. Obhó tɨ́, yà adzɨ ɔ̌ nyɨ̌ nyɨ́ àpbɛ̀ nábà àbà. Pbɛ́tʉ̀, àpɛ́ nyɔ̀nzɨ ɔdɔ, ma mɔ̀nzɨ̀ wà yà adzɨ-lɛ̀mà nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wɔ̀ dhu bhěyi ndɨ̀ ndɔ̀tɛ̀ dhu-dzidɔ̌, Yěsù agɛ́rɛ́ ndɨ̀, ndàndà ɔ̀rʉ̀-akpà ɔ̀ nga, ndàdʉ̀ ndɨ̀tsɔ̀, ndàtɨ: «Àba Kàgàwǎ, kàsʉmɨ̀ nákǎ wà. Nɨ́, ábhʉ̌ Idhùnʉ-ɔvɔ̀ rìlè ndɨ̀, ndɨ́nɨ̌ Idhùnʉ adʉ̀ tɨ́ ɔvɔ̀nʉ àbhʉ rìlè ndɨ̀ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nyɨ nyábhʉ ka rɨ̀’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà kɔ́rɔ́ alɛ dɔ̌. Ndɨ dhu bhěyi nɨ́ ndɨ, kà rǒngo dhòdhódhónga tɔ́ ípìrɔ̌nga nábhʉ fɔná nyɨ nyábhʉ kɔ́rɔ́ alɛ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ndɨ dhòdhódhónga tɔ́ ípìrɔ̌nga nɨ́: abádhí rʉ̀nɨ ɨnyɨ kɛ̀lɛ̌ atdírɔ̀ ràrɨ̌ ndɨ obhóná Kàgàwà, ndɨrɔ̀ abádhí rʉ̀nɨ Yěsù Krɨ́stɔ̀, yà nyɨ nyívì rɨ̀rà yà adzɨ ɔ̌ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma mábhʉ wà ɔvɔ̀nʉ rìlè ndɨ̀ yà adzɨ dɔ̌, madʉ̀ yà fudú nyɨ nyibho ndɨ́nɨ̌ ma mɔnzɨ tɨ́ kasʉ nɔ́nzɨ̀ mɨtɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nɨ́ kòmbí, ɨnyɨ Àbá, ábhʉ̌ ɔvɔ̀du rìlè ndɨ̀ tɨnʉ́ ɔ̀, àdhàdhɨ̀ yà ɨnzá nyɨ nyàpɛ̀ yà adzɨ ɔ̀bhɔlɔ rɔ́rɔ̀, ɔvɔ̀du níilè ndɨ̀ tɨnʉ́ ɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma mábhʉ wà ɔvɔ̀nʉ, yà adzɨ ɔ̌ alɛ nzínzì ɔ̌ rɔ̀ nyɨ nyóvò, nyibhò fudú alɛ rʉ̀nɨ. Abádhí nɨ́’ɨ̀ pbʉ̀kʉ̀ alɛ, nɨ́ nyɨ nyádʉ̀ abádhí níbhò fudú. Ndɨrɔ̀, abádhí nɔ́dɔ̀ wà pbʉ̀kʉ̀ ɔtɛ afíya ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nɨ́ kòmbí, abádhí nʉ́nɨ wà dhu, yà fudú nyɨ nyíbhò kɔ́rɔ́ dhu ráhʉ fʉnʉ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Obhó nyʉ́, ma mʉ́dà wà yà abádhí tɔ̀ ma mʉdà tɨ́ nyɨ nyíbhò fudú ɔtɛ abádhí tɔ̀, abádhí ràdʉ̀ àkɔnà mběyi nyʉ́. Abádhí ʉ́nɨ wà dhu, obhó tɨ́ ma rɨ́rà tɨnʉ ɔ̀ rɔ̀, ’àdʉ̀ dhu à’ù átɔ̀ nyɨ rívì ndɨ ɨma. ");
INSERT INTO niy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Abádhí-dɔ̌ nga nɨ́ ndɨ ma mɨ́ mɨtsɔ̀ nɨ̌. Ma mɨ́ nzɨ̌ mɨtsɔ̀ yà adzɨ ɔ̌ ngʉ̌kpà alɛ-dɔ̌. Pbɛ́tʉ̀, ma mɨ́ mɨtsɔ̀ yà fudú nyɨ nyíbhò alɛ dɔ̌, pbʉ̀kʉ̀ alɛ tɨ́ abádhí rɨ̌’ɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kɔ́rɔ́ alɛ, yà fudú rɨ́’ɨ̀ nɨ́ pbʉ̀kʉ̀ alɛ, ndɨrɔ̀ yà fʉnʉ́ rɨ́’ɨ̀ kɔ́rɔ́ alɛ nɨ́ pbàkà alɛ. Ndɨrɔ̀ ɔvɔ̀du náarɨ́ ndìlè abádhí-nyʉtsì. ");
INSERT INTO niy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Àbá, ma mɨ́ nzɨ̌ àdɨ tdɨ́tdɔ̌ yà adzɨ ɔ̌. Pbɛ́tʉ̀, abádhí nóko òko yà adzɨ ɔ̌. Ndɨrɔ̀ kòmbí ma márà tɨnʉ ɔ̀. Nɨ́ Ɨ̀lɨ̌lǎ Àba Kàgàwǎ, ɔ́dɔ abádhí yà dùdú nyɨ nyɔ́vɔ̀ ɔvɔ̀nʉ-ɔbɨ̀ nɨ̌. Ndɨ dhu bhěyi nɨ́ ndɨ, abádhí rǎdʉ̀ òko atdí alɛ tɨ́, àdhàdhɨ̀ àlɛ̌ nɨ́ atdí alɛ ɨnyɨ mànà dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yà abádhí mànà mǎ mɨ́’ɨ̀ atdíkpá ɔ̀ná kàsʉmɨ̀ ɔ̌, ma mɔ̀dɔ̀ abádhí, yà dùdú nyɨ nyavɔ̀ ɔvɔ̀nʉ-ɔbɨ̀ nɨ̌. Ndɨrɔ̀, ma mɔ̀dɔ̀ abádhí mběyi nyʉ́, ɨ̀nzɨ̌ atdí alɛ mà ràwǐ nzínzìya ɔ̌ rɔ̀. Pbɛ́tʉ̀, abádhí nzínzì ɔ̌ rɔ̀ àwǐ atdí alɛ nɨ́, yà pbʉ̀kʉ̀ Andítá ɔ̀ ka kandí dhu dɔ̀ná, àwǎwíya dhu tɨ́ alɛ kɛ̀lɛ̌, ndɨ́nɨ̌ ndɨ Andítá náadʉ̀ tɨ́ àkǎ. ");
INSERT INTO niy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ɔ̀ɔ! Àba Kàgàwǎ, kànɨ̌ kòmbí ma mɨ́ madǔ tɨnʉ ɔ̀. Nɨ́ ma mɔ́tɛ wɔ̀ dhu bhěyi, àdɨ̀ ma màdɨ̀ yà adzɨ ɔ̌ rɔ́rɔ̀, ndɨ́nɨ̌ pbàkà dhɛ̀dhɛ nɨ́ɨrá tɨ́ abádhí. ");
INSERT INTO niy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɨma, ma mɔ́vɔ̀ pbʉ̀kʉ̀ ɔtɛ abádhí tɔ̀, nɨ́ yà adzɨ ɔ̌ alɛ nádʉ̀ abádhí ɔ̀ndrɔ̀ ɔ̀ndrɔ̀ tɨ́. Ɨ alɛ ɔ́ndrɔ̀ abádhí, abádhí nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ, àdhàdhɨ̀ ɨma mà átɔ̀, ɨma nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ dhu bhěyi dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Àbá, ma mɨ́ nzɨ̌ mɨtsɔ̀ rʉ̀nʉ́, ndɨ́nɨ̌ nyɨ nyugu tɨ́ abádhí yà adzɨ ɔ̌ rɔ̀. Pbɛ́tʉ̀, ma mɨ́ mɨtsɔ̀ rʉ̀nʉ́, ndɨ́nɨ̌ nyɨ nyɔdɔ tɨ́ abádhí Nzɛ́rɛ alɛ, Pfɔ̀mvɔ rɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Obhó tɨ́ Àbá, abádhí nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ, àdhàdhɨ̀ ɨma mà átɔ̀, ɨma nɨ́ nzɨ̌ yà adzɨ ɔ̌ alɛ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nɨ́, útrǐ abádhí ròkò pbʉ̀kʉ̀ alɛ tɨ́ obhónga-otù ɔ̌. Ndɨ obhónga nɨ́ pbʉ̀kʉ̀ ɔtɛ. ");
INSERT INTO niy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nyɨ nyívì ma mɨrà yà adzɨ ɔ̌. Nɨ́ ndɨ dhu bhěyi tɨ́, ma mòvì abádhí átɔ̀ ròwù yà adzɨ ɔ̌ alɛ nzínzì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Abádhí-okú dɔ̀ rɔ̀ nɨ́ ndɨ, ma mábhʉ ma kɔ́rɔ́ ɨma nyʉ́ tɨ́rɔ̀ ɨndʉ̀, ndɨ́nɨ̌ abádhí adʉ̀ tɨ́ ’àbhʉ átɔ̀ ɨndʉ̀ obhónga-otù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Àbá, ma mɨ́ nzɨ̌ mɨtsɔ̀ yà fudú nyɨ nyíbhò alɛ-okú dɔ̀ rɔ̀ tɨ́. Pbɛ́tʉ̀, ma mɨ́ mɨtsɔ̀ átɔ̀ yà abádhí rɔ̌vɔna pbʉ̀kʉ̀ obhónga tɔ́ ɔtɛ nɨ́rɨ rɨ́, ’àdʉ̀ ma’ù alɛ-okú dɔ̀ rɔ̀ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma mɨ́ mɨtsɔ̀ átɔ̀, ndɨ́nɨ̌ abádhí kɔ́rɔ́ nɨ́ɨ’ɨ tɨ́ atdí alɛ tɨ́, àdhàdhɨ̀ ɨnyɨ Àbá, nyɨ nyarɨ́’ɨ̀ nyʉdutsì, madʉ̀ ɨ̀’ɨ̀ nyʉnʉtsì dhu bhěyi. Ma mɨ́ mɨtsɔ̀ átɔ̀ ndɨ́nɨ̌ abádhí ɨ’ɨ tɨ́ atdí alɛ tɨ́ àlɛ̌-nyʉtsì, ndɨ́nɨ̌ yà adzɨ ɔ̌ alɛ náa’u tɨ́ dhu, nyɨ rívì ndɨ ɨma, mɨrà yà adzɨ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma mábhʉ wà abádhí-ɔvɔ̀ rìlè ndɨ̀, àdhàdhɨ̀ nyɨ nyábhʉ ɔvɔ̀du rìlè ndɨ̀ dhu bhěyi, ndɨ́nɨ̌ abádhí ɨ’ɨ tɨ́ atdí alɛ tɨ́, àdhàdhɨ̀ àlɛ̌ karɨ́’ɨ̀ atdí alɛ tɨ́ ɨnyɨ mànà dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ma mɨ́’ɨ̀ abádhí-nyʉtsì, nyadʉ̀ ɨ̀’ɨ̀ nyʉdutsì, ndɨ́nɨ̌ abádhí oko tɨ́ kɔ́rɔ́ atdí alɛ nyʉ́ tɨ́, yà adzɨ ɔ̌ alɛ ràdʉ̀ dhu ʉ̀nɨ nyɨ rívì ndɨ ɨma yà adzɨ ɔ̌. Ndɨrɔ̀, abádhí rǎdʉ̀ dhu ʉ̀nɨ nyɨ rózè ɨ̀, àdhàdhɨ̀ nyɨ nyózè ɨma dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ndɨrɔ̀ Àba Kàgàwǎ, nyɨ nyíbhò ndɨ abádhí fudú. Nɨ́, ma mòzè mǒwù òko atdíkpá abádhí mànà yà tɨnʉ́ ma márà àdɨ rɔ́, ndɨ́nɨ̌ abádhí ala tɨ́ pbàkà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀. Ndɨ ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ nyɨ nyɨbho idù, nyɨ nyazè ma ɨnzá nyɨ nyàpɛ̀ yà adzɨ ɔ̀bhɔlɔ rɔ́rɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Obhónánga tɔ́ Àba Kàgàwǎ, yà adzɨ ɔ̌ ábhɔ̌ alɛ mà nókò mbǎ ɨ̀nzɨ̌ ’ʉ̀nɨ nyɨ, nɨ́ ɨma, ma mʉ́nɨ wà nyɨ. Ndɨrɔ̀, yà fudú nyɨ nyíbhò alɛ nʉ́nɨ wà dhu nyɨ rívì ndɨ ma, mɨrà yà adzɨ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma mábhʉ wà ɔvɔ̀nʉ abádhí rʉ̀nɨ. Ndɨrɔ̀, ma mɨ́ kàbhʉ̌ àbhʉ̌ olù ríwu ngʉ̌kpà alɛ mà rʉ̀nɨ átɔ̀. Ma mɨ́ wɔ̀ dhu ɔ̀nzɨ, ndɨ́nɨ̌ yà nyɨ nyózè ma nɨ̌ àzè-tɨdɔ̀ náadʉ̀ tɨ́ àdɨ abádhí-afí ɔ̀, ndɨrɔ̀ madʉ̀ àdɨ abádhí-afí ɔ̀ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wɔ̀ dhu bhěyi ndɨ̀ ndɨ̀tsɔ̀ ndɨ̀ dhu-dzidɔ̌, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà núuvò, ’àdʉ̀ àda Kìdrǒnɨ̀ tɨ́ kátɨna ɨdhá-ngba-adzè. Nɨ́ ányɨ̀, atdí ɨnga nɨ́ɨ’ɨ̀ ìnè. Nɨ́, abádhí adʉ̀ òtsù ndɨ ɨnga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudhà, yà Yěsù ìpfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ ábhàlɨ̌, nɨ’ɨ̀ ɨwà ányɨ̀rɔ̌ nga nʉ́nɨ átɔ̀. Obhó tɨ́, Yěsù mà pbɨ̀ndà ábhàlɨ̌ mànà, nóongónà òwu ’ùndu bìlǐnganà ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nɨ́, Yudhà ìdè fɨ̀ndá pɨ̀kɔ̀-dɔ̀tsírɔ́ alɛ níiwú ùvò ndɨ ɨnga ɔ̌. Ndɨ pɨ̀kɔ̀ ɔ̌ nɨ’ɨ̀ pbànówí mà, yà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà Pbàfàrìsáyó mànà nívì sàndǐrì mànà. Abádhí-fɔ́ nɨ’ɨ̀, ɔ̀rʉ̀ rɔ́rʉ̀ tarà mà, mʉ̀lɛ rɔ̌ kàzʉ mà, màtsǔmù mànà. ");
INSERT INTO niy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nɨ́ Yěsù, yà angyangyɨ rɔ̀ná rɨ́ ndɔ̀nzɨ̀ kɔ́rɔ́ dhu nʉ̀nɨ, náandrì abádhí tɨ́ ɔ̀, ndàdʉ̀ dhu ìvu tsʉ̀yá, ndàtɨ: «Ádhɨ nyɨ̌ nyɔ́nɛna?» ");
INSERT INTO niy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nɨ́, abádhí àdʉ̀ dhu àdu kà tɔ̀ ’àtɨ: «Mǎ mɔ́nɛna nɨ́ Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ.» Nɨ́, Yěsù àdʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨma nɨ́ ndɨ.» Ndɨ kàsʉmɨ̀ ɔ̌, Yudhà yà Yěsù ìpfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́ alɛ, nɨ́ɨ’ɨ̀ ìnè átɔ̀ abádhí nzínzì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nɨ́, Yěsù ɨtdègu ndɨ̀tɛ̀ abádhí tɔ̀, ndàtɨ: «Ɨma nɨ́ ndɨ.» Nɨ́ abádhí adʉ̀ ’àdu dziyà-dɔ nɨ̌ olù, ’àdʉ̀ ’àwà obvò. ");
INSERT INTO niy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yěsù ivú dhu tdɨ́tdɔ̌ abádhí-tsʉ̌, ndàtɨ: «Ádhɨ nyɨ̌ nyɔ́nɛna?» Nɨ́, abádhí adʉ̀ dhu àdu Yěsù tɔ̀ ’àtɨ: «Mǎ mɔ́nɛna nɨ́ Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nɨ́, Yěsù àdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ma mʉ̀nɔ̀ wà dhu fʉ̌kʉ̀ matɨ, ɨma ràrɨ̌ ndɨ. Nɨ́, dhu apɛ́ ɨ̀’ɨ̀ ɨma nɔ́nɛ nyɨ̌ nyɨ́ dhu tɨ́, nɨ́ nyʉ̀bhà kǎkà ngʉ̌kpà alɛ ròwù.» ");
INSERT INTO niy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yěsù atɛ̀ wɔ̀ dhu bhěyi, ndɨ́nɨ̌ yà angyinǎrɔ̀ ndɨ ndʉ̀nɔ̀nà dhu náaká tɨ́. Kǎtɨ: «Àba Kàgàwǎ, yà fudú nyɨ nyíbhò alɛ nzínzì ɔ̌ rɔ̀, ma mábhʉ nzá atdí alɛ mà ràwǐ.» ");
INSERT INTO niy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sìmonì Pɛ́tɛrʉ̀ nɨ́ɨ’ɨ̀ pbɨ̀ndà obhi-akpà nà. Nɨ́, kɨ̌dhá ka ɔ̀dhʉ̌na ɔ̀ rɔ̀, ndʉ̀’à pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà kasʉtálɛ nɨ̌, ndɨ̀tsà fangà dɔ̀nǎ bɨ̌na. Ndɨ kasʉtálɛ-ɔvɔ̀ nɨ’ɨ̀ Malkɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pbɛ́tʉ̀, Yěsù adʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Pɛ́tɛrʉ̌, ádǔ pbʉ̀kʉ̀ obhi-akpà ɔ̀dhʉ̌na ɔ̀! Nyɨ nyòzè tɨ́ obhó yà Àba Kàgàwà ìbhò ndɨ́nɨ̌ ma mɔmvʉ́ tɨ́ àpbɛ̀ tɔ́ kɔ́pà-tsʉ̀ mɔmvʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nɨ́rɔ̀ nɨ́ ndɨ pbànówí tɔ́ pɨ̀kɔ̀, ɔ̀yá ádrʉ̀ngbǎlɛ mà, Pbàyàhúdí tɔ́ sàndǐrì mànà, náalʉ́ Yěsù ’òsò, ’àdʉ̀ ɔtsʉ́na nʉ́tsɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wɔ̀ dhu-dzidɔ̌, kɔ̌kɔ̀ Yěsù nòsò alɛ náawù kà nà wɛmbɛrɛ̀ tɨ́ Anà bhà. Ndɨ Anà nɨ’ɨ̀ Kàyafà bhà agʉna-akpà. Ndɨrɔ̀, wɔ̀ dhu rɨ̌ ndɔ̀nzɨ ɔ̀ná atɔ ɔ̌, Kàyafà nɨ’ɨ̀ ndɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà. ");
INSERT INTO niy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wɔ̀ ndɨ Kàyafà nɨ́ ndɨ dhu navɔ̀ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ tɔ̀, ndàtɨ: «Dhu àkǎ atdí alɛ kɛ̀lɛ̌ rɔ̀vɛ̀ àlɛ̌ tɔ́ pbìrì ɔ̌ kɔ́rɔ́ alɛ tɔ́ ngari ɔ̌.» ");
INSERT INTO niy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yěsù nà ka kówu Anà bhà ɔ̀ná kàsʉmɨ̀ ɔ̌, Sìmonì Pɛ́tɛrʉ̀ mà, Yěsù bhà ngǎtsi ábhàlɨ̌ mànà, náambɛ́nà òwu dɔ̌ átɔ̀ Yěsù-owù ɔ̌ ányɨ̀. Wɔ̀ ndɨ ngǎtsi ábhàlɨ̌ nɨ’ɨ̀ ɨwà ndɨ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà ʉ́nɨ angyangyɨ. Nɨ́, ndɨ ábhàlɨ̌ adʉ̀ òtsù Yěsù-owù ɔ̌, ndɨ pbàkùhání tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɛ́tɛrʉ̀ adʉ̀ ndʉ̀bhà irinǎ rɔ̀ tsǎtsʉ̀nǎ. Nɨ́, wɔ̀ Yěsù-owù ɔ̌ òtsù ngǎtsi ábhàlɨ̌, yà ɨwà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà ʉ́nɨ angyangyɨ náahʉ̀ iri, ’ìwǔ ɔtɛ yà tsǎtsʉ̀-ngbɔ̀ ɔ̀dɔ rɨ́ tsìbhá sàndǐrì nà. Ndɨ̀ sàndǐrì adʉ̀ Pɛ́tɛrʉ̀ àvi ròtsù kàlɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nɨ́, kàlɨ̀ ɔ̀ Pɛ́tɛrʉ̀ òtsù rɔ̀, wɔ̀rɨ́ tsìbhá sàndǐrì níivú dhu kà-tsʉ̌, ndàtɨ: «Nyɨ nyʉ́, nyɨ tɨ́ nzɨ̌ átɔ̀ wɔ̀ alɛ bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ?» Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Hɔ́ɔ̀! Ɨ̀nzɨ̌ nɨ́ ma kàbhà ábhàlɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, gìrì ambɛ́nà ɔ̀’ɔ dɔ̌ atdídɔ̌. Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà kasʉtálɛ mà, Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì mànà, náadʉ̀ òko ’àmbɛ yà ɨ̀ ʉ̀tɔ kàzʉ ɔ̀vɔ̀ dɔ̌. Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ àdɨ átɔ̀, ndàmbɛ kàzʉ ɔ̀vɔ̀ dɔ̌ atdíkpá abádhí mànà. ");
INSERT INTO niy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wɔ̀ Pɛ́tɛrʉ̀ mà rɨ̌ kàzʉ ɔ̀vɔ ɔ̀ná kàsʉmɨ̀ ɔ̌, Anà, pbàkùhánɨ́ dɔ̌ ádrʉ̀ngbǎ kamà, náadʉ̀ ndɔ̀pɛ̀ ndɔ̀ngʉ̀ dhu Yěsù-tsʉ̌, kàbhà ábhàlɨ̌ mà, ndɨrɔ̀ yà ìndrǔ tɔ̀ kǎrúdhěna dhu mànà dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ma márà dhu ɔ̀vɔ̀ rɔ̌ kpangba kɔ́rɔ́ alɛ tɔ̀. Ndɨrɔ̀, ma márà dhu ùdhe rɔ̌ bìlǐnganà Pbàyàhúdí tɔ̀, yà abádhí núndu ɨ̀ fɨ̀yɔ́ unduta-dzà ɔ̌ màtɨ́, ndɨrɔ̀, Kàgàwà bhà ɨdza ɔ̌ màtɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, ɨ̀nzɨ̌ madʉ̀ àrà atdí dhu mà nórù rɔ̌ abádhí rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nɨ́, ádhu nyɨ nyɨ́ dhu ɔ̀ngʉ̀ tsʉ̀dú nɨ̌? Nyɨ nyàkǎ nyɔngʉ̀ yà tsʉ̀dú abádhí ɨ́rɨ̀ fɨ̌yɔ̀ ma mʉ́nɔna rɔ́ dhu abádhí-tsʉ̌. Abádhí ʉ́nɨ ndɨ fɨ̌yɔ̀ ma mʉ́nɔ̀ dhu mběyi.» ");
INSERT INTO niy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nɨ́, wɔ̀ dhu ʉ̀nɔ Yěsù rɨ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, ányɨ̀rɔ̌ ɨ̀’ɨ̀ atdí sàndǐrì níindri Yěsù-tɨ’ɔ̀, ndɔ̀pbɨ̀ kà-bɨ-bhù, ndàdʉ̀ dhu ìvu tsʉ̀ná, ndàtɨ: «Nyɨ tɨ́ àdʉ̀ ɔtɛ àdu wɔ̀ dhu bhěyi pbàkùhánɨ́ tɔ́ ádrʉ̀ngbǎ kamà tɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ma mapɛ́ ɨ̀’ɨ̀ nzɛ́rɛ ma mɔ̀tɛ̀ dhu tɨ́, nɨ́ ɨ́tɛ̀ pɛ́ ndɨ nzɛ́rɛ ma mʉ̀nɔ̀ dhu. Ndɨrɔ̀, dhu apɛ́ ɨ̀’ɨ̀ mběyi ma màdu dhu kàtɔ̀ dhu tɨ́, nɨ́ ádhu nyɨ nyɨ́ ɨma nʉ́pbɨ okúna dɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wɔ̀ dhu-dzidɔ̌, Anà náadʉ̀ Yěsù àbhʉ kowù nà ʉ̀tsɨ ka kʉ̀tsɨ̀ ɔtsʉ́na rɔ́rɔ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà Kàyafà bhà. ");
INSERT INTO niy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wɔ̀ ndɨ Yěsù nà ka kówu Kàyafà bhà ɔ̀ná kàsʉmɨ̀ ɔ̌, Sìmonì Pɛ́tɛrʉ̀ adɨ̀ kàzʉ-tsʉ̀nǎ tɨ́, ndàmbɛ kàzʉ ɔ̀vɔ̀ dɔ̌. Nɨ́, ka kivú dhu kà-tsʉ̌, katɨ: «Nyɨ tɨ́ nzɨ̌ átɔ̀ wɔ̀ ka kówu nà alɛ bhà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ?» Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ ndàgò, ndàtɨ: «Hɔ́ɔ̀! Ɨ̀nzɨ̌ nɨ́ ma wɔ̀ alɛ bhà ábhàlɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nɨ́, Anà bhà kasʉtálɛ nzínzì ɔ̌ atdí alɛ náadʉ̀ dhu ìvu Pɛ́tɛrʉ̀-tsʉ̌, ndàtɨ: «Hɔ̀kɔ̀! Ma màlanà tɨ́ obhó nyɨ̌ atdíkpá wɔ̀ alɛ mànà ɨnga ɔ̌?» Wɔ̀ ndɨ alɛ nɨ’ɨ̀, yà Pɛ́tɛrʉ̀ ʉ̀’ànà, ndɨ̀tsà bɨ̌na alɛ mà t’ɨ́dzá alɛ. ");
INSERT INTO niy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nɨ́, Pɛ́tɛrʉ̀ adʉ̀ ndàgò àgò tɨ́ tdɨ́tdɔ̌, ányɨ̀rɔ̌ rɔ̀ tɨ́, à’ʉ̌-akpà ràdʉ̀ ɔ̀ngɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wɔ̀ dhu-dzidɔ̌, ka kuvò Yěsù nà kútsingá nyʉ́ Kàyafà bhà rɔ̀, kowù nà Lɨ̀walɨ̀ Pìlatɔ̀ bhà ɨdzá-yà-ba ɔ̀. Pbɛ́tʉ̀, kɔ̌kɔ̀ Yěsù nà òwù ányɨ̀ Pbàyàhúdí náadʉ̀ ’ùvo ùvǒ tɨ́, ɨ̀nzɨ̌ ’òtsù Pìlatɔ̀ bhà ɨdza-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ kàlɨ̀ ɔ̀. Abádhí anzɨ̀ ndɨ dhu, akyɛ ɨ̀ owuna ɔ̀tɨ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̌, ɨ̀nzɨ̌ ’àdʉ̀ Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ tɔ́ ɔ̀nyʉ̀ nɔ́nyʉ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nɨ́, Pìlatɔ̀ náadʉ̀ àhʉ ndàrà abádhí-tɨ’ɔ̀, ndàdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Ádhu nyɨ̌ nyɔ̀bhʉ̀ yà alɛ okúna dɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nɨ́, abádhí adʉ̀ dhu àdu Pìlatɔ̀ tɔ̀, ’àtɨ: «Ɨ̀nzɨ̌ kɨ̌’ɨ̀ná gukyè nzɛ́rɛ dhu ɔ̀nzɨ arɨ́ alɛ tɨ́, nɨ́ mǎ màmbɛ̀nà nzɨ̌ kòsò mǐwǔ nà fʉnʉ ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nɨ́, Pìlatɔ̀ adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìdyi ka nyɔ̌tdɨ̀ ànyǎna nyɨ̌ nyʉ́ tɨ́rɔ̀ yà fʉ̀kʉ́ ʉyátá nʉ́nɔ̀ ka dhu bhěyi.» Nɨ́, kɔ̌kɔ̀ Yěsù nà òwù ányɨ̀ Pbàyàhúdí náadʉ̀ àtɨ̀nà Pìlatɔ̀ nɨ̌: «Ɨ̀mbǎ mǎ mɨ́’ɨ̀ ìndrǔ-ànyǎ nɔ́tdɨ̀ mǎ mɨ́, ndɨ́nɨ̌ ka koho tɨ́ nɨ̌ rʉsà nà.» ");
INSERT INTO niy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wɔ̀ dhu anzɨ̀ ndɨ̀, ndɨ́nɨ̌ yà Yěsù avɔ̀ angyangyɨ ɨ̀ngbà dhu bhěyi ɔvɛ-tɨdɔ̀ nɨ̌ màtɨ́ ndɨ̀ ndɔvɛ́ya dhu náaká tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wɔ̀ dhu-dzidɔ̌, Pìlatɔ̀ adʉ̀ ndàdu pbɨ̀ndà ɨdzá-yà-ba ɔ̀, ndàdʉ̀ Yěsù ànzì ndìvǔ dhu tsʉ̀ná, ndàtɨ: «Nyɨ nyʉ́, nyɨ tɨ́ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà?» ");
INSERT INTO niy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nɨ́, Yěsù adʉ̀ dhu ìvu kà-tsʉ̌, ndàtɨ: «Nyɨ nyʉ́, nyɨ tɨ́ wɔ̀ dhu ìvǔ afínʉ nyʉ́ ɔ̀ rɔ̀ àhʉ rɔ́rɔ̀? Ndɨrɔ̀ ngǎtsi nɨ̌ nyɨ tɨ́ kìvǔ ngʉ̌kpà alɛ náwɛ ndɨ dhu ɨndʉ̀ dùdú dhu-okú dɔ̀ rɔ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pìlatɔ̀ ivú dhu tdɨ́tdɔ̌ Yěsù-tsʉ̌, ndàtɨ: «Ɨma tɨ́ Mʉ̀yàhudì? Fʉ̀kʉ́ pbìrì ɔ̌ alɛ nyʉ́ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mànà nípfo ndɨ nyɨ ’ìbhò nyɨ fudú. Nɨ́ ádhu nyʉ́ nyɨ nyáfǎ?» ");
INSERT INTO niy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nɨ́, Yěsù adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Pbàkà idzi nɨ́ nzɨ̌ yà adzɨ ɔ̌ idzi-tɨdɔ̀. Pbàkà idzi ɨ́’ɨ̀ná gukyè yà adzɨ ɔ̌ idzi-tɨdɔ̀ tɨ́, nɨ́ pbàkà alɛ àmbɛ̀nà ’ùgye ùgye dùdú ɨ̀nzɨ̌ ka kipfo tɨ́ ɨma, kabhʉ ma Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ-fɔ́. Pbɛ́tʉ̀, kòmbí pbàkà idzi nɨ́ nzɨ̌ yà adzɨ ɔ̌ idzi-tɨdɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pìlatɔ̀ adʉ̀ dhu ìvu Yěsù-tsʉ̌ tdɨ́tdɔ̌, ndàtɨ: «Olu ɨnyɨ, nyɨ tɨ́ ádrʉ̀ngbǎ kamà?» Nɨ́ Yěsù adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨnyɨ nɨ́ ndɨ nyɨ nyátɨna ɨma ràrɨ̌ ádrʉ̀ngbǎ kamà. Ɨma ka kʉ́gʉ̀ yà adzɨ ɔ̌, madʉ̀ ɨ̀rà ndɨ́nɨ̌ ma mongó tɨ́ obhónga nɨ́tɛ̀ ìndrǔ tɔ̀. Obhónga nózè ’ʉ̀nɨ alɛ rǎdʉ̀ tǔdu nɨ́rɨ̀ ɨ̀rɨ.» ");
INSERT INTO niy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɨ́, Pìlatɔ̀ adʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Obhónga nyʉ́ nɨ́ àdhu?» Wɔ̀ dhu bhěyi ndɨ̀ ndìvǔ dhu Yěsù-tsʉ̌ dhu-dzidɔ̌, Pìlatɔ̀ adʉ̀ àhʉ tdɨ́tdɔ̌ kàlɨ̀ ɔ̀ rɔ̀, ndàrà Pbàyàhúdí-tɨ’ɔ̀. Nɨ́ kǎdʉ̀ dhu ɔ̀vɔ̀ abádhí tɔ̀, ndàtɨ: «Ma màla nzá wɔ̀ alɛ dɔ̌ ka kɨ́ anya nɔ́tdɨ̀ okúna dɔ̀ rɔ̀ atdí dhu mà. ");
INSERT INTO niy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pbɛ́tʉ̀, yà fʉ̀kʉ́ màndʉ nʉ́nɔ̀ ka dhu bhěyi, ma marɨ́ imbi ɔ̀ ka kósò atdí alɛ nɨ́kɔ̀lɔ̀ bílǐnganà fʉ̌kʉ̀ yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ náarɨ́ ɨ̀rà dhu bhěyi. Nɨ́, nyɨ̌ nyòzè tɨ́ mɨkɔ̀lɔ̀ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà fʉ̌kʉ̀?» ");
INSERT INTO niy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nɨ́, abádhí àdʉ̀ dhu àdu ìkǔ nyʉ́ ɔ̌ Pìlatɔ̀ tɔ̀, ’àtɨ: «Ɨ̀nzɨ̌ nɨ́ wɔ̀ alɛ ndɨ mǎ mòzè kɨkɔ̀lɔ̀! Pbɛ́tʉ̀, mǎ mǒzè kɨkɔ̀lɔ̀ alɛ nɨ́ Bàrabà!» Wɔ̀ ndɨ Bàrabà nɨ’ɨ̀ àrǐ ɔ̀nzɨ arɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wɔ̀ dhu bhěyi ihé-yà nádu dhu fɨ̌ndà dhu-dzidɔ̌, lɨ̀walɨ̀ Pìlatɔ̀ náadʉ̀ Yěsù àvi kalʉ̌, kʉvɨ asé nɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nɨ́rɔ̀ nɨ́ ndɨ pbànówí náadʉ̀ okpèna nà itsu-dɔ̀ká tɔ́ mʉ̀kàkʉ́ nákpɔ̀rɔ̀, ’àfɔ̌ Yěsù-dɔ rɔ̌, ’àdʉ̀ òlǒlù kanzʉ̀ náfɔ kà-rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Abádhí nóowúnà ìwu rɔ̌ Yěsù-tɨ’ɔ̀, ’àdʉ̀ kàtsɛ̀, ’àtɨ: «Yǎmbʉ̀, Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà!» Ndɨrɔ̀, abádhí adʉ́nà òwu kà-bɨ-bhù nɔ́pbɨ̀ rɔ̌ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pìlatɔ̀ náahʉ̀ tdɨ́tdɔ̌ kàlɨ̀ ɔ̀ rɔ̀, ndàrà ihé-yà ɨ, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Kɔ̀nɨ̌, ma mɨ́ wɔ̀ alɛ návǐ kuvò nà kàlɨ̀ ɔ̀ rɔ̀, ndɨ́nɨ̌ nyɨ̌ nyʉnɨ tɨ́ dhu ɨnzá ma ràla kà-dɔ̌ ka kɨ́ anya ɔ̀tdɨ̀ okúna dɔ̀ rɔ̀ atdí dhu mà.» ");
INSERT INTO niy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù adʉ̀ àhʉ kàlɨ̀ ɔ̀ rɔ̀ dɔ̀na rɔ̌ okpèna nà itsu-dɔ̀ká tɔ́ mʉ̀kàkʉ́ nà, ndɨrɔ̀ rɔ̀ná òlǒlù kanzʉ̀ nà. Nɨ́, Pìlatɔ̀ àdʉ̀ àtɨ̀nà ihé-yà nɨ̌: «Kànɨ̌ ndɨ fʉ̀kʉ́ alɛ!» ");
INSERT INTO niy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì mànà níitdègu Yěsù àlǎ, nɨ́ abádhí náadʉ̀ ’ɔ̀pɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌ Pìlatɔ̀ nɨ̌: «Ábhʉ̌ kʉtɔ̌ mʉ̀sàlabhà dɔ̌! Ábhʉ̌ kʉtɔ̌ mʉ̀sàlabhà dɔ̌!» Pìlatɔ̀ adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìdyi ka nyʉ̌tɔ̌ nyɨ̌-tɨ́rɔ̀ ndɨ mʉ̀sàlabhà dɔ̌. Obhó tɨ́, ɨma nyʉ́, ma màla nzá kà-dɔ̌ ka kɨ́ anya nɔ́tdɨ̀ okúna dɔ̀ rɔ̀ atdí dhu mà.» ");
INSERT INTO niy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nɨ́, Pbàyàhúdí náadʉ̀ dhu àdu Pìlatɔ̀ tɔ̀, ’àtɨ: «Mǎ mɨ́’ɨ̀ ìnè atdí ʉyátá nà. Ndɨ ʉyátá rǎtɨna kà ràkǎ ndɔ̀vɛ̀, Kàgàwà t’Ídhùnà tɨ́ kǎrɨ́ ndàtɨ ndɨ̀tɨ́rɔ̀ dhu-okú dɔ̀ rɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pìlatɔ̀ itdègu wɔ̀ ɔtɛ ɨ̀rɨ, nɨ́ ɔdɔ adʉ̀ ɨ̀sɨ̌ kà-ɔ̀ atdídɔ̌ ròsè yà angyinǎrɔ̀ kɨ̀’ɨ̀nà nà dɔ̀nǎ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nɨ́, pbɨ̀ndà ɨdzá-yà-ba ɔ̀ ndɨ̀ ndàdu ndɨ̀ tdɨ́tdɔ̌ rɔ̀, Pìlatɔ̀ àdʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Nyɨ nɨ́ àdhà alɛ?» Pbɛ́tʉ̀, Yěsù adʉ̀ nzá atdí dhu mà nádu kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pìlatɔ̀ adʉ̀ dhu ìvu tdɨ́tdɔ̌ kà-tsʉ̌, ndàtɨ: «Nyɨ nyòzè tɨ́ obhó nyadu ɔtɛ idù? Nyɨ nyʉ̀nɨ tɨ́ obhó dhu, ma ràrɨ̌’ɨ̀ ìnè ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà mɨkɔ̀lɔ̀ nyɨ? Ndɨrɔ̀, nyɨ nyʉ̀nɨ tɨ́ obhó dhu, ma ràrɨ̌’ɨ̀ ìnè ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà mabhʉ nyɨ kʉtɔ̌ nyɨ mʉ̀sàlabhà dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nɨ́, Yěsù adʉ̀ dhu àdu Pìlatɔ̀ tɔ̀, ndàtɨ: «Hɔ̀kɔ̀! Ɨ̀mbǎ nyɨ nyɨ́’ɨ̀ atdí ádrʉ̀ngbǎnga tɔ́ ɔbɨ nà màtɨ́ dùdú, ɨnzá Kàgàwà kɛ̀lɛ̌ nábhʉ ka ɨndʉ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rɔ̀. Ndɨ dhu-okú dɔ̀ rɔ̀, ma mátɨna nyɨ nɨ̌: Yà ma nìpfo ndàbhʉ ma fʉnʉ́ alɛ bhà nzɛ́rɛnga nósè wà pbʉ̀kʉ̀ nzɛ́rɛnga dɔ̀nǎ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nɨ́, rɔ̀pɛ̀ ndɨ̀ ʉrɔ́ rɔ̀, Pìlatɔ̀ adʉ̀ ndɔ̀pɛ̀ ndɔ̀nɛ̀ Yěsù ɨ̀kɔ̀lɔ̀ ndɨ̀ ndɨ́ ɔ̀ná otu. Pbɛ́tʉ̀, Pbàyàhúdí tɔ́ ihé-yà náadʉ̀ ’ɔ̀pɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌ Pìlatɔ̀ nɨ̌: «Nyɨ nyʉ́ nyɨ nyapɛ́ wɔ̀rɨ́ alɛ ɨ̀kɔlɔ, nɨ́ nyɨ nɨ’ɨna ɨnzá nyɨ nyózè Pbàrɔ́má tɔ́ pbìrì ɔ̌ kámá dɔ̌ ádrʉ̀ngbǎ kamà alɛ. Ndɨ alɛ apɛ́ ndàtɨ ndɨ̀tɨ́rɔ̀ ádrʉ̀ngbǎ kamà tɨ́, nɨ́ ndɨ alɛ nɨ́ ndɨ kámá dɔ̌ ádrʉ̀ngbǎ kamà nà arɨ́ ndùgye alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nɨ́, kɔ̌kɔ̀ alɛ ʉ̀nɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Pìlatɔ̀ adʉ̀ Yěsù àvi kuvò nà iri, ndàdʉ̀ àdɨ odu nɨ̌ ka kɔ́rʉ̀, rɨ̀và ndɨ̀ ɔrʉ́ ngari ɔ̌. Pbàyàhúdí t’ávàna ɔ̌, ka kɨ́ kànzi Gàbatà tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wɔ̀ dhu rɨ̌ ndɔ̀nzɨ ɔ̀ná ɨdhɔ nɨ’ɨ̀ yà Pásɨ̀ka tɔ́ mʉ̀hɛndʉ̀ tɔ̀ ìndrǔ rɨ̌ ’ɔ̀bhɔlɔ ɔ̀ná ɨdhɔ. Ndɨrɔ̀, ndɨ dhu anzɨ̀ ndɨ̀ mbɛ̀mbɛ̀ azà adyifɔ̀-sɨsɨ̀ adyíbhengá nga tɔ́ ɔ̌. Nɨ́, Pìlatɔ̀ atɨ Pbàyàhúdí tɔ́ ihé-yà nɨ̌: «Kɔ̀nɨ̌ fʉ̌kʉ̀ ádrʉ̀ngbǎ kamà!» ");
INSERT INTO niy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pbɛ́tʉ̀, kɔ̀rɨ́ ihé-yà náadʉ̀ ’ɔ̀pɛ̀ ’ùkǔ, ’àmbɛ àtɨ̀nà dɔ̌ Pìlatɔ̀ nɨ̌: «Kàkǎ ndɔ̀vɛ̀! Kàkǎ ndɔ̀vɛ̀! Ábhʉ̌ ka kʉtɔ̌ mʉ̀sàlabhà dɔ̌!» Pìlatɔ̀ àdʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nyɨ̌ nyòzè tɨ́ mabhʉ fʉ̀kʉ́ ádrʉ̀ngbǎ kamà kʉtɔ̌ mʉ̀sàlabhà dɔ̌?» Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ dhu àdu Pìlatɔ̀ tɔ̀, ’àtɨ: «Ɨ̀mbǎ mǎ mɨ́’ɨ̀ ngǎtsi ádrʉ̀ngbǎ kamà nà! Fàká ádrʉ̀ngbǎ kamà nɨ́ kámá dɔ̌ ádrʉ̀ngbǎ kamà kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nɨ́rɔ̀ nɨ́ ndɨ Pìlatɔ̀ adʉ̀ Yěsù àbhʉ abádhí-fɔ́, ndɨ́nɨ̌ ka kowu tɨ́ ʉ̀tɔnà mʉ̀sàlabhà dɔ̌. Pìlatɔ̀ àvi ɨ̀ dhu-okú dɔ̀ rɔ̀, Ihé-yà adʉ̀ Yěsù ìdyì ’òwùnà kɨgɔ̀ ɔ̌ rɔ̀, ndɨ́nɨ̌ ɨ̀ owu tɨ́ ʉ̀tɔnà mʉ̀sàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nɨ́, kɨgɔ̀ ɔ̀ rɔ̀ ɨ̀ ùvò rɔ̀, Yěsù anɔ̀ ndʉ̀tɔ̌ ka kɨ́ dɔ̀ná mʉ̀sàlabhà ndɨ̀tɨ́rɔ̀, ndàmbɛ àrà dɔ̌ nà alɛ-dɔ-kpa tɔ́ ngari tɨ́ ka kátɨna ngari ɔ̀. Pbàyàhúdí t’ávàna ɔ̌, ka kɨ́ kànzi Gɔ̀lɔ̀gɔtà tɨ́. ");
INSERT INTO niy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ányɨ̀ nɨ́ ndɨ pbànówí nʉ́ʉtɔ́ Yěsù mʉ̀sàlabhà dɔ̌. Ka kʉtɔ́ abádhí dhèdhèrɔ̀ mʉ̀sàlabhà dɔ̌ ɔ́yɔ̌ ngʉ̌kpà alɛ mànà. Ka kʉtɔ́ atdí alɛ, kɔdɨ̀ Yěsù bhà fangà dɔ̀nǎ rɔ̀, kadʉ̀ ngǎtsi alɛ nʉ́tɔ, kɔdɨ̀ Yěsù bhà ígù dɔ̀nǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pìlatɔ̀ adʉ̀ dhu àvi kandǐ, kapbǎ mʉ̀sàlabhà dɔ̌ kà-dɔ̀nǎ. Ndɨ andítá nɨ’ɨ̀: «YÀRƗ́ NƗ́ YĚSÙ, NÀZÀRETÌ TƆ́ KƗGƆ̀ Ɔ̌ ALƐ, PBÀYÀHÚDÍ TƆ́ ÁDRɄ̀NGBǍ KAMÀ.» ");
INSERT INTO niy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nɨ́, ábhɔ̌ Pbàyàhúdí nyʉ́ nóowúna wɔ̀ dhu ɔ̀zʉ̀ rɔ̌. Obhó tɨ́, yà Yěsù ka kʉ̀tɔ̌ mʉ̀sàlabhà dɔ̌ rɔ́nga nɨ́ɨ’ɨ̀ íkyɛ̀rɔ̌ kɨgɔ̀ tɨ́. Ndɨrɔ̀ ndɨ dhu ka kandí Pbàyàhúdí t’ávàna mà, Pbàrɔ́má t’ávàna mà, ndɨrɔ̀ Pbàgìríkí t’ávàna mànà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nɨ́, pbàkùhání tɔ́ ádrɔ̀drɔ̌ alɛ náadʉ̀ òwu Pìlatɔ̀ ɨ̀sɔ, ’atɨ: «Nzǎndǐ dhu ka ràrɨ̌ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà. Pbɛ́tʉ̀, ándǐ dhu nyatɨ: Àbadhi rátɨ ndɨ, ndɨ̀ ràrɨ̌ Pbàyàhúdí tɔ́ ádrʉ̀ngbǎ kamà.» ");
INSERT INTO niy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pbɛ́tʉ̀, Pìlatɔ̀ adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Yà ma màndǐ dhu nɨ́ ma màndǐ wà!» ");
INSERT INTO niy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yěsù ɨ̀ ʉ̀tɔ̌ mʉ̀sàlabhà dɔ̌ dhu-dzidɔ̌, pbànówí adʉ̀ kà-rɔ̌ mʉ̀dzarʉ̀ núgù, ’ʉ̀ndɔ̀ ɔyánga ɨ̀fɔ àdhàdhɨ̀, ’àdʉ̀ ʉ̀ndɔ̀nà fɔyá, ngǎtsi alɛ rìdyì atdínga ɨ̀fɔ dɔ̌ fɨ̌ndà. Ʉrɔ́ adʉ̀ ndʉ̀bhà nɨ́ kà-rɔ̌ kanzʉ̀ kɛ̀lɛ̌. Ndɨ kanzʉ̀ nɨ’ɨ̀ ɨnzá ka kʉ́pbǎ ʉ̀pbǎ tɨ́. Pbɛ́tʉ̀, ka nɨ’ɨ̀ atdí-nyɨ̀na kɛ̀lɛ̌ tɨ́ ka kódyù, rɔ̀pɛ̀ ndɨ̀ tǔna ɔ̀ rɔ̀, ràrà àhʉ pfɔ̌na ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nɨ́, kɔ̌kɔ̀ pbànówí adʉ̀ ɔ̀tɛ nzínzìya ɔ̌, ’àtɨ: «Apɛ́ kʉ̀fa wɔ̀ kanzʉ̀-ɔ̌nga ʉ̀fǎ tɨ́, pbɛ́tʉ̀, kàkǎ àlɛ̌ rɔ̀vɨ̀ ngàlà ɔ̌, ndɨ́nɨ̌ àlɛ̌ kala tɨ́ kà rǎdɨ fɨ̌ndà alɛ.» Wɔ̀ dhu anzɨ̀ ndɨ̀, ndɨ́nɨ̌ Kàgàwà bhà Andítá ɔ̀ ka kandí dhu náaká tɨ́. Ndɨ̀ Andítá rǎtɨna: «Abádhí ʉndɔ rùdú mʉ̀dzarʉ̀ fɔyá, ’àdʉ̀ rùdú kanzʉ̀ nɔ́vɨ̀ ngàlà ɔ̌.» Wɔ̀rɨ́ nɨ́ ndɨ pbànówí anzɨ̀ Yěsù rɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yà Yěsù ka kʉ̀tɔ̌ dɔ̀ná mʉ̀sàlabhà tɨ́ ikò ɨ́kyɛ̀rɔ̌ nɨ́: Màrɨyà, Yěsù-tsánà mà, ndɨ kà-tsánà t’áwɛ̀nà nà, ndɨrɔ̀ nɨ́ Màrɨyà, Kìlìyɔpà bhà ɨngba-tsánà mà, Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà mànà. ");
INSERT INTO niy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nɨ́ Yěsù itdègu ɨ́yànà nálǎ, ndàdʉ̀ yà atdídɔ̌ ndɨ̀ ndózè pbɨ̀ndà ábhàlɨ̌ nála kà-tɨ́ ìdè átɔ̀ rɔ́, nɨ́ kǎdʉ̀ àtɨ̀nà ɨ́yànà nɨ̌: «Iyá, kɔ̀nɨ̌ idhùnʉ.» ");
INSERT INTO niy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tdɨ́tdɔ̌, kǎdʉ̀ àtɨ̀nà wɔ̀ ábhàlɨ̌ nɨ̌: «Pbǎlɛ́, kɔ̀nɨ̌ ɨ́yànʉ.» Nɨ́, rɔ̀pɛ̀ ndɨ̀ ʉrɔ́ rɔ̀, wɔ̀ ábhàlɨ̌ náadʉ̀ Yěsù-tsánà nídyì ndàrà nà pbɨ̀ndà. ");
INSERT INTO niy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wɔ̀ dhu-dzidɔ̌, Yěsù ʉnɨ dhu, yà ndɨ̀ ndɨra ɔ̀nzɨ̀nà yà adzɨ ɔ̌ kasʉ ràkǎ wà kɔ́rɔ́. Nɨ́, ndɨ́nɨ̌ Kàgàwà bhà Andítá ɔ̀ ka kandí dhu náaká tɨ́, kǎdʉ̀ àtɨ̀nà: «Ma mɨ́’ɨ̀ ɨdha-atdyú nà.» ");
INSERT INTO niy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, òdyògyè dɨ̀vayì rɨ̌’ɨ̀ ɔ̀nà atdí andu nɨ́’ɨ̀ ìnè ányɨ̀rɔ̌. Nɨ́, pbànówí adʉ̀ sìfɔngɔ̀ nídyì, ’òdù ndɨ dɨ̀vayì ɔ̀, ’àdʉ̀ ndɨ sìfɔngɔ̀ ɔ̀tʉ̀ hìsɔpɔ̀ tɨ́ kátɨna itsukpó-tsʉ̀-dɔ̌, ’àva Yěsù-tsʉ̌. ");
INSERT INTO niy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nɨ́, Yěsù itdègu ndɨ dɨ̀vayì àndʉ̌ ndɔ̀tɔ̀, nɨ́ kǎdʉ̀ àtɨ̀nà: «Kɔ́rɔ́ dhu àkǎ wà.» Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ dɔ̀na ɨ̀yʉ̀, afína ràdʉ̀ ɨ̀tdɛ̌ dòtsí. ");
INSERT INTO niy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wɔ̀ dhu anzɨ̀ ndɨ̀ ɔ̀ná ɨdhɔ nɨ’ɨ̀, sàbatʉ̀ tɔ̀ ìndrǔ rɨ̌ ’ɔ̀bhɔlɔ ɔ̀ná ɨdhɔ. Obhó tɨ́, ndɨ sàbatʉ̀-ɨdhɔ̀ nɨ’ɨ̀ ádrʉ̀ngbǎ ɨdhɔ nyʉ́ Pbàyàhúdí tɔ̀. Nɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ náazè nzá abvo rǒko mʉ̀sàlabhà dɔ̌ ndɨ ɨdhɔ ɔ̌ dhu. Nɨ́, ndɨ dhu-okú dɔ̀ rɔ̀, abádhí náawù Pìlatɔ̀ bhà, ’òwù ɨ abvo nónzì, ndɨ́nɨ̌ ka kʉkɔ tɨ́ agàya-kpa, kadʉ̀ ìfonà mʉ̀sàlabhà dɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nɨ́ pbànówí náawù, ’àdʉ̀ ìtsi mʉ̀sàlabhà dɔ̌ ɨ̀’ɨ̀ Yěsù mànà alɛ-agà-kpa nʉ́kɔ. Abádhí nʉ́ʉkɔ wɛmbɛrɛ̀ t’álɛ-agà-kpa, ’àdʉ̀ ɔyɔ rɨ́ kìsě alɛ-agà-kpa nʉ́kɔ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pbɛ́tʉ̀, Yěsù-tɨ́ ɨ̀ ìwǔ ùvò rɔ̀, abádhí adʉ̀ kòtù ɨwà afína ɨ̀tdɛ̌ rɔ́, ɨ̀nzɨ̌ ’àdʉ̀ agàna-kpa nʉ́kɔ. ");
INSERT INTO niy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nɨ́, kɔ̌kɔ̀ pbànówí nzínzì ɔ̌ atdí mùnowì náadù Yěsù-ɔngɔ̀-kpa àlɨ̌ nɨ̌. Ányɨ̀rɔ̌ rɔ̀ tɨ́, azu mà ɨdha mànà ràdʉ̀ ’ɨ̀sɔ̀lɔ̀ ndɨ kɔ̌ngɔ̀-kpa ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wɔ̀rɨ́ dhu rɨ̌ ndɔ̀nzɨ dhu nala nyɨ̀kpɔ́na nyʉ́ nɨ̌ alɛ náawɛ ka kpangba. Ndɨrɔ̀ kʉ̌nɨ dhu, ndɨ ràwɛ obhó dhu nyʉ́, ndɨ́nɨ̌ nyɨ̌ nyʉ́ mà nyɨ̌ nya’u tɨ́ ka átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Obhó tɨ́, wɔ̀ Yěsù-rɔ̌ ndɨ̀ nanzɨ̀ dhu náanzɨ̀ ndɨ̀, ndɨ́nɨ̌ yà Kàgàwà bhà Andítá ɔ̀ ka kandí dhu náaká tɨ́. Ndɨ Andítá rǎtɨna: «Kà-kpa nzínzì ɔ̌ atdí alɛ-kpa mà ka kʉkɔ̀ya nzɨ̌.» ");
INSERT INTO niy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ndɨrɔ̀, ngǎtsi ngari ɔ̌, ndɨ Andítá rǎtɨna tdɨ́tdɔ̌: «Abádhí agɛ́rɛ́ya pɛ́ ɨ̀, ’àndà yà ɔngɔ̀na-kpa ɨ̀ udù àlɨ̌ nɨ̌ alɛ.» ");
INSERT INTO niy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wɔ̀ dhu-dzidɔ̌, Yɔ̀zɛfʉ̀ yà Àrìmàtayò tɨ́ kátɨna kɨgɔ̀ ɔ̌ alɛ, náarà Pìlatɔ̀ bhà, ndàdʉ̀ Yěsù-abvò nónzì kà-fɔ́, ndɨ́nɨ̌ ka kifo tɨ́ mʉ̀sàlabhà dɔ̌ rɔ̀. Ndɨ Yɔ̀zɛfʉ̀ nɨ’ɨ̀ átɔ̀ Yěsù bhà ábhàlɨ̌. Pbɛ́tʉ̀, kǎbhʉ̀ nzá kʉnɨ ndɨ̀ Yěsù bhà ábhàlɨ̌ tɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ-ɔdɔ̀ nɔ́nzɨ ndɨ̀ ndarɨ́ dhu-okú dɔ̀ rɔ̀. Nɨ́, Pìlatɔ̀ níitdègu wɔ̀ Yɔ̀zɛfʉ̀ ʉ̀nɔ̀ dhu ná’u, nɨ́ kǎdʉ̀ àrà, ndàdʉ̀ Yěsù-abvò nífo mʉ̀sàlabhà dɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Nɨ̀kɔ̀dɛmʉ̀, yà atdíku arà àhʉ Yěsù-tɨ́ kúbhingá alɛ, náadʉ̀ ɨ̀rà àhʉ átɔ̀ Yɔ̀zɛfʉ̀-tɨ́. Kɨ̌ra yà mběyi arɔ́ngʉ akyɛ-tɨdɔ̀ tɔ́ mbɛ̀mbɛ̀ ɨ̀bhʉ kumì kìlo nà fɔná. Ndɨ akyɛ nɨ’ɨ̀ mànɛ̀manɛ̀ tɨ́ kátɨna itsu-dha mà, kàdzagulè-dha mànà ka kángbǒ atdíkpá. ");
INSERT INTO niy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nɨ́, Yɔ̀zɛfʉ̀ mà Nɨ̀kɔ̀dɛmʉ̀ nà níitdu Yěsù-abvò, ’àkpɔ̀rɔ̀ ngbɔ̌na wɔ̀ ndɨ ndrùù rɔ́ngʉ akyɛ ɨ̀ ʉ̀dhɔ dɔ̀ná mbɛrʉ̀ nɨ̌. Abádhí anzɨ̀ ndɨ dhu àdhàdhɨ̀ yà fɨ̀yɔ́ màndʉ ɔ̌ Pbàyàhúdí náarɔ́nzɨna abvo ɔ̀tdʉ̀ ɨ̀ ɨ́ rɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wɔ̀ ndɨ Yěsù ka kʉ̀tɔ̌nà mʉ̀sàlabhà dɔ̌ rɔ́, atdí ɨnga nɨ́ɨ’ɨ̀ ìnè. Ndɨrɔ̀, ndɨ ɨnga ɔ̌, atdí ibhu-ɔwʉ́tá yà ɨnzá ka kàpɛ̀ ìndrǔ ɔ̀tdʉ̀ angyi ɔ̀nà náadʉ̀ ɨ̀’ɨ̀ ìnè átɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nɨ́, sàbatʉ̀ tɔ̀ Pbàyàhúdí rɨ̌ ’ɔ̀bhɔlɔ dhu-okú dɔ̀ rɔ̀, ndɨrɔ̀ ɨ́kyɛ̀rɔ̌ ndɨ ibhu nótù ndɨ̀ dhu-okú dɔ̀ rɔ̀, Yɔ̀zɛfʉ̀ mà Nɨ̀kɔ̀dɛmʉ̀ nà náadʉ̀ ùvò Yěsù ɔ̀tdʉ̀ ndɨ ibhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yɛngɛ̀-ɨdhɔ̀ ɔ̌ bhɔ̌tsʉngá, ɨnzá ɨnga àpɛ̀ ùbho mběyi rɔ́rɔ̀, Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà nɨ́ɨvà ndɨ̀, ndàrà Yěsù ka kɔ́tdʉ̀ ɨ. Nɨ́, kǎtù ibhu li’ɔ̀ ka kápbǐ nɨ̌ odu-ɨ́yà-ba ɨwà ka kɔ̀gɛ̀rɛ̀ igi rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nɨ́, kǎngbó ndɨ̀ owùna-lú, ndɔ̀kʉ̀ wɔ̀ dhu àwɛ Sìmonì Pɛ́tɛrʉ̀ mà, ngǎtsi ábhàlɨ̌ yà atdídɔ̌ Yěsù azè mànà tɔ̀, ndàtɨ: «Ɨwà ka kìtdù àlɛ̌ tɔ́ Ádrʉ̀ngbǎlɛ-abvò ibhu ɔ̀ rɔ̀, kowù nà. Nɨ́, àlɛ̌ kʉ̀nɨ nzá ka kòwù kɨ̀lɨ rɔ́-nga!» ");
INSERT INTO niy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nɨ́ Pɛ́tɛrʉ̀ mà, wɔ̀ ndɨ ngǎtsi ábhàlɨ̌ mànà, náadʉ̀ òwu Yěsù ka kɔ́tdʉ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Abádhí ambɛ́nà òtse dɔ̌ ɔ́yɔ̌ rɔ̀ atdíkpá. Pbɛ́tʉ̀, wɔ̀ ngǎtsi ábhàlɨ̌ náadʉ̀ ɔ̀kʉ, ndʉ̀bhà Pɛ́tɛrʉ̀ olù, ndàdʉ̀ àrà àhʉ angyi yà Yěsù ka kɔ́tdʉ̀ ɨ. ");
INSERT INTO niy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nɨ́, kǐtsi ndàgu, ndàndà ibhu-ɔ̀nga, ndàdʉ̀ yà Yěsù-abvò-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ mbɛrʉ̀ kɛ̀lɛ̌ nála ányɨ̀. Pbɛ́tʉ̀ kǎdʉ̀ nzá òtsù ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tdɨ́tdɔ̌, yà olù ndɨ̀ nʉ̀bhànà Sìmonì Pɛ́tɛrʉ̀, nɨ́ɨra àhʉ ányɨ̀rɔ̌, ndàdʉ̀ òtsù ibhu ɔ̀. Nɨ́, kǎdʉ yà Yěsù-abvò-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ mbɛrʉ̀ mà, ");
INSERT INTO niy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yà kà-dɔ ka kátsì nɨ̌ bɛ̌rɛ̀sɛ mànà kɛ̀lɛ̌ nótù ndɨ ibhu ɔ̀. Ndɨ bɛ̌rɛ̀sɛ mà nɨ́ɨ’ɨ̀ mbǎ atdíkpá abvo-ngbɔ̀ ka kákpɔ̀rɔ̀ nɨ̌ mbɛrʉ̀ mànà, pbɛ́tʉ̀ kɨ̌’ɨ̀ atdírɔ̀ ka kɔ̀kɔ̀ kɨlɨ rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nɨ́rɔ̀ nɨ́ ndɨ yà angyi àrànà àhʉ ábhàlɨ̌ náadʉ̀ òtsù ibhu ɔ̀ átɔ̀. Nɨ́ kǎla wɔ̀ dhu, ndàdʉ̀ dhu à’ù ɨwà Yěsù rɨ̀ngbɛ̀ ndɨ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Obhó tɨ́, Kàgàwà bhà Andítá ɔ̀ ka kʉ́nɔ̀ Yěsù dɔ̌ dhu nɨ́ɨ’ɨ̀ ɨnzá ndɨ̀ ndàpɛ̀ kàbhà ábhàlɨ̌-dɔ àlʉ̌ rɔ́. Ndɨ Andítá rǎtɨna: Ɨ̀ngbɛ̀ kà rɨngbɛ̀ya ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wɔ̀ dhu-dzidɔ̌, kɔ̌kɔ̀ ɔ́yɔ̌ ábhàlɨ̌ náadʉ̀ ’àdu, ’òwù fɨ̀rábvʉ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kɔ̌kɔ̀ ábhàlɨ̌ òwù dhu-dzidɔ̌, Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà nɨ́ɨra àhʉ átɔ̀ Yěsù ka kɔ́tdʉ̀ rɔ́, ndàdʉ̀ itsi ìde ndɨ ibhu tɨ́ ndàmbɛ ɔ̀dzɨ dɔ̌. Nɨ́, ɔ̀dzɨ ndɨ̀ ndɔ́dzɨ rɔ́rɔ̀, kǎgú ndɨ̀, ndàndà ibhu-ɔ̀nga. ");
INSERT INTO niy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kǎdʉ̀ Kàgàwà bhà ɔ́yɔ̌ màlàyíká nála ányɨ̀ òkò rɔ́. Ɨ màlàyíká nʉ́ʉfɔ́ ɔ̀wɔ̌wʉ̀ mbɛrʉ̀, ’àdʉ̀ òko yà Yěsù-abvò ka kɨlɨ ràyi rɔ́. Atdí màlàyikà náadɨ̀ kà-dɔ ka kɨlɨ ràyi ɨnǎ rɔ̀, ngǎtsi ràdʉ̀ àdɨ kà-pfɔ̀ ɨnǎ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nɨ́ ɨ màlàyíká níivú dhu Màrɨyà-tsʉ̌, ’àtɨ: «Iyá, ádhu nyɨ nyɔ́dzɨ nɨ̌?» Nɨ́, Màrɨyà àdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ka kìtdù wà pbàkà Ádrʉ̀ngbǎlɛ-abvò ibhu ɔ̀ rɔ̀ kɔwù nà. Nɨ́ ma mʉ̀nɨ nzá àdhà màtɨ́ ka kòwù kɨ̀lɨ dhu.» ");
INSERT INTO niy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nɨ́ wɔ̀ dhu ndɨ̀ ndʉ̀nɔ̀ rɔ̀, Màrɨyà agɛ́rɛ́ ndɨ̀, ndàndà olù nga, ndàdʉ̀ Yěsù nála ìdìdè rɔ́. Pbɛ́tʉ̀, kʉ̌nɨ nzá dhu Yěsù ràrɨ̌ ndɨ. ");
INSERT INTO niy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nɨ́, Yěsù ivú dhu kà-tsʉ̌ ndàtɨ: «Iyá, ádhu nyɨ nyɔ́dzɨ nɨ̌? Ádhɨ nyɨ nyɔ́nɛna?» Nɨ́ wɔ̀ Yěsù ka kɔ̀tdʉ̀ ɔ̀ná ɨnga-àbadhi tɨ́ ndɨ̀ ndɨ́ Yěsù àtɨ rɔ̀, Màrɨyà adʉ̀ àtɨ̀nà kànɨ̌: «Pbǎlɛ́, dhu apɛ́ ɨ̀’ɨ̀ nyɨ nyìtdù ndɨ pbàkà Ádrʉ̀ngbǎlɛ-abvò, nyarà nà dhu tɨ́, nɨ́ ɨ́tɛ̀ nyɨ nyàrà kɨ̀lɨ rɔ́ nga idù, ndɨ́nɨ̌ ma madʉ̀ tɨ́ àrà kìdyì.» ");
INSERT INTO niy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nɨ́, Yěsù adʉ̀ kànzì ɔvɔ̀na rɔ̌, ndàtɨ: «Màrɨyà!» Nɨ́rɔ̀ nɨ́ ndɨ Màrɨyà náagɛ́rɛ́ ndɨ̀, ndàdʉ̀ àtɨ̀nà kà nɨ̌ Pbàyàhúdí t’ávàna ɔ̌: «Ràbunì!» Kà-tɨ̀ nɨ́: «Màlimò.» ");
INSERT INTO niy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ɨ̀nzɨ̌ ʉ̀tɔ̀ tsʉ̀du! Obhó tɨ́ ma màpɛ̀ nzá madǔ Àbadu-tɨ’ɔ̀. Pbɛ́tʉ̀, árà nyɔvɔ dhu adɔ́du tɔ̀ nyatɨ, ma ràrɨ̌ àrà Àbadu-tɨ’ɔ̀. Ndɨ Àbadu nɨ́ Àbakʉ átɔ̀. Ka nɨ́ pbàkà Kàgàwà, ndɨrɔ̀ ka nɨ́ fʉ̀kʉ́ Kàgàwà átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nɨ́, Màgàdalà tɔ́ kɨgɔ̀ ɔ̌ Màrɨyà náadʉ̀ àrà dhu ɔ̀vɔ̀ Yěsù bhà ábhàlɨ̌ tɔ̀, ndàtɨ: «Ma màla Ádrʉ̀ngbǎlɛ!» Kǎdʉ̀ yà Yěsù àvinà ndʉ̀nɔ̀ abádhí tɔ̀ dhu náwɛ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ndɨ yɛngɛ̀-ɨdhɔ̀ ɔ̌ tɨ́, pbɨ́tsɔ̀ngǎ, Yěsù bhà ábhàlɨ̌ náandu ɨ̀ atdí ɨdza ɔ̌, ’àdʉ̀ tsǎtsʉ̀ ùpbi ɨdzanǎ rɔ̀, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ-ɔdɔ̀ nɔ́nzɨ ɨ̀ ɨ́ dhu-okú dɔ̀ rɔ̀. Nɨ́rɔ̀ nɨ́ ndɨ Yěsù ɨtɔ ndɨ̀, ndìdè abádhí nzínzìya ɔ̌, ndàdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòko màrʉ̀ngà ɔ̌!» ");
INSERT INTO niy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wɔ̀ dhu ndɨ̀ ndòrì dhu-dzidɔ̌, Yěsù adʉ̀ ɔtsʉ́na-tsirɔ̀ mà, ɔngɔ̀na-kpa mànà nɨ́tɛ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀. Nɨ́ ɨ ábhàlɨ̌-ɨdhɛ̀ náadʉ̀ ndɨ̀ka atdídɔ̌, fɨ̀yɔ́ Ádrʉ̀ngbǎlɛ ɨ̀ àla nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yěsù àdʉ̀ àtɨ̀nà tdɨ́tdɔ̌ abádhí nɨ̌: «Nyòko màrʉ̀ngà ɔ̌. Àdhàdhɨ̀ yà Àba Kàgàwà níivi ma mɨrà yà adzɨ ɔ̌ dhu bhěyi, ma mòvì nyɨ̌ átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wɔ̀ dhu ndɨ̀ ndòrì dhu-dzidɔ̌, kǐvò ɨhɛ̀na abádhí dɔ̀, ndàdʉ̀ àtɨ̀nà: «Nyàkɔ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí! ");
INSERT INTO niy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Fɨ̀yɔ́ nzɛ́rɛnga nyɨ̌ nyʉ̀bà fɨ̌yɔ̀ alɛ tɔ̀, Kàgàwà rǒngo dhu ʉ̀bà átɔ̀. Ndɨrɔ̀, ɨnzá nyɨ̌ nyʉ̀bà fɨ̀yɔ́ nzɛ́rɛnga fɨ̌yɔ̀ alɛ tɔ̀, kà rɨ̌ nzɨ̌ ongo àdʉ̀ dhu ʉ̀bà átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wɔ̀ Yěsù rɨ̌ ndàvǐ ɨdzá pbɨ̀ndà ábhàlɨ̌ tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, kàbhà atdí kumì dɔ̀ná ɔ́yɔ̌ nà ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ, Tʉ̀masɨ̀ tɨ́ kátɨna nɨ́ɨ’ɨ̀ ɨ̀mbǎ. Ngǎtsi ndɨ Tʉ̀masɨ̀-ɔvɔ̀ nɨ’ɨ̀ Dìdimò. ");
INSERT INTO niy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nɨ́, Tʉ̀masɨ̀ ɨ̀rà àhʉ nzínzìya ɔ̌ rɔ̀, kɔ̌kɔ̀ ábhàlɨ̌ adʉ̀ àtɨ̀nà kà nɨ̌: «Mǎ màla wà àlɛ̌ tɔ́ Ádrʉ̀ngbǎlɛ!» Pbɛ́tʉ̀, Tʉ̀masɨ̀ adʉ̀ àtɨ̀nà abádhí nɨ̌: «Ɨnzá ma màla kɔ̌tsʉ́-tsírɔ́ mʉ̀sʉ̀malɨ̀-bhu, madʉ̀ ɔtsʉ́du-kpɔ̀ nɔ́tʉ̀ ndɨ mʉ̀sʉ̀malɨ̀-bhu ɔ̀, ndɨrɔ̀ kɔ̌ngɔ̀-kpa rɔ̌ àlɨ̌-bhu ɔ̀ rɔ̀, ma mɨ́ nzɨ̌ wɔ̀ dhu ná’u akɛkpá màtɨ́!» ");
INSERT INTO niy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nɨ́ atdí yɛngɛ̀ dzidɔ̌, Yěsù bhà ábhàlɨ̌ náandu tsʉ̀ya tdɨ́tdɔ̌ ɨdzá, Tʉ̀masɨ̀ ràdʉ̀ ɨ̀’ɨ̀ átɔ̀ nzínzìya ɔ̌. Nɨ́, àzèmbè inè tsǎtsʉ̀ rɨ̌’ɨ̀ ɨdzanǎ rɔ̀ ka kàpbì rɔ́ rɔ́rɔ̀, abádhí ala Yěsù ɨwà ìdè nzínzìya ɔ̌ rɔ́. Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyòko màrʉ̀ngà ɔ̌!» ");
INSERT INTO niy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tdɨ́tdɔ̌, kǎdʉ̀ àtɨ̀nà Tʉ̀masɨ̀ nɨ̌: «Ɨ́rà ɔtsʉ́nʉ-kpɔ̀ nà ɨrɔ́, ndɨrɔ̀, ándà pɛ́ ɔtsʉ́du-tsírɔ́ nga. Ɨ́gba ɔtsʉ́nʉ, nyadʉ̀ ɔtsʉ́nʉ-kpɔ̀ nɔ́tʉ̀ ɔngɔ̀du rɔ̌ àlɨ̌-bhu ɔ̀. Nzǎbhʉ̌ afínʉ rùgùrù, dhu àkǎ nya’ù dhu à’u tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nɨ́, Tʉ̀masɨ̀ adʉ̀ àtɨ̀nà Yěsù nɨ̌: «Ɨnyɨ nɨ́ pbàkà Ádrʉ̀ngbǎlɛ, pbàkà Kàgàwà.» ");
INSERT INTO niy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yěsù adʉ̀ àtɨ̀nà kànɨ̌: «Nyɨ nyà’ù tɨ́ ma nyɨ̀kpɔ́nʉ nyʉ́ nɨ̌ nyɨ nyàla ma dhu-okú dɔ̀ rɔ̀? Hirò nɔ́nzɨ̀ alɛ nɨ́, yà ɨnzá ɨ̀ àla dhu rɔ́rɔ̀ arɨ́ dhu à’u alɛ!» ");
INSERT INTO niy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yěsù anzɨ̀ ábhɔ̌ ngʉ̌kpà wɨwɨ̀ nyʉ́ pbɨ̀ndà ábhàlɨ̌-ɔ̀nzɨ̌. Nɨ́, ɨ wɨwɨ̀ àndi ka kadʉ̀ nzá yàrɨ́ bhǔkù ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pbɛ́tʉ̀, yàrɨ́ bhǔkù ɔ̀ ka kandí wɨwɨ̀-tsí, nɨ́ ka kandí, ndɨ́nɨ̌ ìndrǔ náa’u tɨ́ dhu, Yěsù ràrɨ̌ Krɨ́stɔ̀, Kàgàwà t’ídhùnà. Ndɨrɔ̀ ka kandí ka ndɨ́nɨ̌ ka nà’ù alɛ, náadʉ̀ tɨ́ ípìrɔ̌nga nábà kɔ̌vɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wɔ̀ dhu-dzidɔ̌, Yěsù avì ndɨ̀ tdɨ́tdɔ̌ àrʉ̀bhʉ̀ pbɨ̀ndà ábhàlɨ̌ tɔ̀, Tìbèriyà tɨ́ kátɨna rɛ̀rʉ̀-bɨdɔ̌. Yàrɨ́ nɨ́ ndɨ, kǎvì ndɨ̀ abádhí tɔ̀ tɨ́ dhu. ");
INSERT INTO niy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Sìmonì Pɛ́tɛrʉ̀ mà, Tʉ̀masɨ̀ Dìdimò tɨ́ kátɨna mà, Nàtànelì, Gàlìlayà tɔ́ pbìrì ɔ̌ atdí pbanga, Kanà tɨ́ kátɨna ɔ̌ alɛ mà, Zɛ̀bɛ̀dayò bhà inzo mà, ndɨrɔ̀ Yěsù bhà ɔ́yɔ̌ ngʉ̌kpà ábhàlɨ̌ mànà, nɨ́ɨ’ɨ̀ atdíkpá. ");
INSERT INTO niy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nɨ́ pbɨ́tsɔ̀ngǎ, Sìmonì Pɛ́tɛrʉ̀ atɨ ɔdhɨ́na nɨ̌: «Ma màrà wà ɨ̀bhɛ̀ ùpe.» Nɨ́, ɨ kà t’ɔ́dhɨ́na adʉ̀ àtɨ̀nà kà nɨ̌: «Mǎ’ɨ mà átɔ̀, mǎ mówu atdíkpá nyɨ mànà.» Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, abádhí adʉ̀ ’ɨ̀và ’òwù, ’àdʉ̀ ùpo ibhú ɔ̀. Pbɛ́tʉ̀, ndɨ iku ɔ̌, abádhí abà nzá atdí dhu mà. ");
INSERT INTO niy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nɨ́rɔ̀ nɨ́ ndɨ màmbì òzè ndɨ̀ rɔ̀, Yěsù idè rɛ̀rʉ̀-bɨdɔ̌. Nɨ́, ka ɨ̀ àla rɔ̀, ábhàlɨ̌ adʉ̀ nzá dhu ʉ̀nɨ Yěsù ràrɨ̌ ndɨ. ");
INSERT INTO niy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nɨ́, Yěsù adʉ̀ dhu ìvu abádhí-tsʉ̌, ndàtɨ: «Nzónzǒ, nyɨ̌ tɨ́’ɨ̀ ìnè ɔ̀nyʉ̀ nà akɛ màtɨ́?» Nɨ́, abádhí adʉ̀ dhu adu kàtɔ̀, ’àtɨ: «Ɨ̀mbǎ!» ");
INSERT INTO niy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nɨ́ Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyàpe pɛ́ imbi fangà dɔ̀nǎ rɔ̀ ibhú tɔ̀, nɨ́ nyɨ̌ nyɨ́ dhu nábà àbà.» Nɨ́, abádhí adʉ̀ imbi nápe yà Yěsù ɨ̀tɛ̀ rɔ́, ndɨ imbi ɨ̀dha abádhí rɨ̌ dhu ràdʉ̀ abádhí lɛ̀mà nɔ́nzɨ̀ ɔ̀nzɨ tɨ́, abhɔ ɨ̀bhɛ̀ rɨ̌’ɨ̀ kà ɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nɨ́, wɔ̀ dhu ndɨ̀ ndàla rɔ̀, yà atdídɔ̌ Yěsù ózè pbɨ̀ndà ábhàlɨ̌ náadʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Hàkà! Ádrʉ̀ngbǎlɛ Yěsù nɨ́ wɔ̀!» Nɨ́, Pɛ́tɛrʉ̀ itdègu fɨ̀yɔ́ Ádrʉ̀ngbǎlɛ tɨ́ kà rɨ̌’ɨ̀ dhu nɨ́rɨ, náadʉ̀ mbɛrʉ̀ àfɔ rɔ̀ná, ɨ̀wa ndɨ̀ ndɨ̀wà rɔ̀ná rɔ̀ rɔ́ ndɨ mʉ̀dzarʉ̀ ɨ̀’ɨ̀ nɨ́dhunɨ̌. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndìbvu ɨdha ɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngʉ̌kpà ábhàlɨ̌ náadʉ̀ òko ’àmbɛ ìwu dɔ̌ ibhú ɔ̌, ɨ̀bhɛ̀-mbǐ àdha ɨ̀ ɨ́ rɔ́rɔ̀. Ndɨ imbi nɨ’ɨ̀ abhɔ nyʉ́ ɨ̀bhɛ̀ nɔ̀tsɨ̀, ndàlè nɨ̌. Ndɨrɔ̀, ɨ ábhàlɨ̌ nɨ́ɨ’ɨ̀ mbǎ ɨtsɛta nyʉ́ ɨdha-bɨdɔ̌ rɔ̀. Abádhí ɨ’ɨ̀ mbɛ̀mbɛ̀ atdí mɨyà mɛ̌tɛ̀rɛ̀ kɛ̀lɛ̌ tɨ́ ɨdha-bɨdɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nɨ́, ibhú ɔ̀ rɔ̀ ɨ̀ ìfò ’ʉ̀dà ɨdha-bɨdɔ̌ rɔ̀, abádhí ala kàzʉ-li ɨ̀bhɛ̀ ka kʉ̀lɨ ràmbɛ ɨ̀bɨ dɔ̌ dɔ̀ná, ndɨrɔ̀ mʉ̀gatì ràdʉ̀ ɨ̀’ɨ̀ átɔ̀ tɨná rɔ́. ");
INSERT INTO niy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nɨ́, Yěsù adʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìwǔ pɛ́ kɔ̌kɔ̀ nyɨ̌ nyɔ̀kyɛ̀ ɨ̀bhɛ̀-rɔrɔ̀ nà.» ");
INSERT INTO niy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nɨ́, Sìmonì Pɛ́tɛrʉ̀ adʉ̀ ùpo tdɨ́tdɔ̌ ibhú ɔ̀, ’àdʉ̀ imbi ìpfo ibhú ɔ̀ rɔ̀ áyà-bvʉdɔ̀. Ndɨ imbi nɨ́ɨ’ɨ̀ ɨwà ndɨ̀ ndàlè atdí mɨyà, imbò kumì dɔ̀ná ɨ̀bhʉ nà ádrɔ̀drɔ̌ ɨ̀bhɛ̀ nɨ̌ rɔ́. Pbɛ́tʉ̀, ɨ̀mbǎ dhu ɨ’ɨ̀ wɔ̀ dhu bvʉ̀tɨ́ màtɨ́ ɨ̀bhɛ̀ àlè kà ’ɔ̀ dhu tɨ́, nɨ́ ndɨ imbi náadʉ̀ nzá ndʉ̀drʉ. ");
INSERT INTO niy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nɨ́, ɨ̀bhɛ̀ nɨ́bɨ dhu-dzidɔ̌, Yěsù adʉ̀ pbɨ̀ndà ábhàlɨ̌ nánzì, ndàtɨ: «Nyìwǔ nyɔ̀nyʉ dhu!» Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, ábhàlɨ̌ nzínzì ɔ̌ atdí alɛ mà náadʉ̀ nzá dhu ìvu Yěsù-tsʉ̌ ndàtɨ, kà ràrɨ̌ àdhɨ. Obhó tɨ́, abádhí nʉ́ʉnɨ wà dhu fɨ̀yɔ́ Ádrʉ̀ngbǎlɛ ràrɨ̌ ndɨ. ");
INSERT INTO niy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nɨ́, Yěsù adʉ̀ ìndri abádhí-tɨ’ɔ̀, ndìdyì mʉ̀gatì, ndàdʉ̀ ʉ̀ndɔ̀nà abádhí-fɔ́. Kǎdʉ̀ ɨ̀bhɛ̀ núgù átɔ̀, ndʉ̀ndɔ̀ abádhí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wɔ̀rɨ́ nɨ’ɨ̀ ɨ̀bhʉ rɨ́ kìsě nɨ̌ Yěsù rɨ̌ ndàvǐ pbɨ̀ndà ábhàlɨ̌ tɔ̀, ɔvɛ-bvʉ̀ rɔ̀ ndɨ̀ ndɨ́ngbɛ̀ ndɨ̀ dhu-dzidɔ̌ dhu. ");
INSERT INTO niy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɔ̀nyʉ̀ pbɨ̀ndà ábhàlɨ̌ ɔ̀nyʉ̀ dhu-dzidɔ̌, Yěsù adʉ̀ dhu ìvu Sìmonì Pɛ́tɛrʉ̀-tsʉ̌, ndàtɨ: «Sìmonì, Yùwanɨ̀ t’ídhùnǎ, nyɨ nyʉ́, nyɨ nyózè tɨ́ wà ma, ròsè kɔ́rɔ́ kǎkà ngʉ̌kpà ɔdhɨ́nʉ nózè ɨma tɨ́ dhu dɔ̀nǎ?» Nɨ́, Pɛ́tɛrʉ̀ àdʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Ɨwà Ádrʉ̀ngbǎlɛ́! Nyɨ nyʉ́, nyɨ nyʉ̀nɨ wà dhu ɨwà ma rózè atdídɔ̌.» Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Óngù pbàkà tàmà.» ");
INSERT INTO niy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɔyɔ rɨ́ kìsě nɨ̌, Yěsù ivú dhu Sìmonì-tsʉ̌, ndàtɨ: «Sìmonì, Yùwanɨ̀ t’ídhùnǎ, nyɨ nyózè tɨ́ wà ma?» Nɨ́, Sìmonì adʉ̀ dhu àdu kàtɔ̀, ndàtɨ: «Ɨwà Ádrʉ̀ngbǎlɛ́! Nyɨ nyʉ̀nɨ wà dhu ɨwà ma rózè nyɨ.» Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Ádɨ̌ pbàkà tàmà t’ʉ́ndatatálɛ tɨ́.» ");
INSERT INTO niy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɨ̀bhʉ rɨ́ kìsě nɨ̌, Yěsù ivú dhu Sìmonì-tsʉ̌, ndàtɨ: «Sìmonì, Yùwanɨ̀ t’ídhùnǎ, ɨnyɨ nyʉ́ nyɨ nyózè tɨ́ wà ma?» Nɨ́, wɔ̀ dhu ndɨ ndɨ̀rɨ̀ rɔ̀, ɨzʉ náadʉ̀ Sìmonì ʉ̀ka atdídɔ̌, ɨ̀bhʉ-gʉ̀na Yěsù ìvǔ dhu tsʉ̀ná, ndàtɨ: «Nyɨ nyózè tɨ́ wà ma?» dhu-okú dɔ̀ rɔ̀. Nɨ́, Sìmonì adʉ̀ dhu àdu Yěsù tɔ̀, ndàtɨ: «Ádrʉ̀ngbǎlɛ́, ɨnyɨ nyʉ́ nyɨ nyʉ́nɨ wà kɔ́rɔ́ dhu. Nɨ́, nyɨ nyʉ̀nɨ wà dhu ɨwà ma rózè nyɨ.» Nɨ́, Yěsù adʉ̀ àtɨ̀nà kà nɨ̌: «Óngù pbàkà tàmà. ");
INSERT INTO niy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ma mɨ́ obhó dhu nʉ́nɔ ɨndʉ̀. Ìndrǔ-ɔwʉ́ tɨ́ nyɨ nyɨ’ɨ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌, nyɨ nyongónà rʉ̀nʉ́ dhu ìso nyɨ-tɨ́rɔ̀, nyadʉ̀ àrà afínʉ òzè ɨ. Pbɛ́tʉ̀, mʉ̀là tɨ́ nyɨ nyóngo rɔ̀, nyɨ nyóngo okùnʉ nʉ́yɨ, ngǎtsi alɛ ràdʉ̀ ndɨ rʉ̀nʉ́ dhu ìso, ndàdʉ̀ dʉ̀nʉ òtdì, ndàrà nyɨ nà ɨnzá afínʉ òzè ɨ.» ");
INSERT INTO niy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yěsù avɔ̀ dhu wɔ̀ dhu bhěyi Pɛ́tɛrʉ̀ tɔ̀, ndɨ́nɨ̌ ɨ̀ngbà dhu bhěyi ɔvɛ-tɨdɔ̀ nɨ̌ màtɨ́ Pɛ́tɛrʉ̀ ɔvɛ́ya dhu nɨtɛ̀ tɨ́, ndɨ kàbhà ɔvɛ ràdʉ̀ Kàgàwà-ɔvɔ̀ àbhʉ rìlè ndɨ̀. Wɔ̀ dhu ndɨ̀ ndʉ̀nɔ̀ dhu-dzidɔ̌, Yěsù adʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ nɨ̌: «Ʉ́ngʉ̌ owùdu.» ");
INSERT INTO niy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nɨ́, òwu ɨ̀ ówu rɔ́rɔ̀, Pɛ́tɛrʉ̀ agɛ́rɛ́ ndɨ̀, ndàndà olùnga, ndàdʉ̀ yà atdídɔ̌ Yěsù ózè pbɨ̀ndà ábhàlɨ̌ nála owùya ɔ̌ rɨ́rà rɔ́. Wɔ̀ ndɨ ábhàlɨ̌ nɨ́ ndɨ yà ɔ̀nyʉ̀-tsʉ̀nǎ ɨ̀ ɨ́’ɨ̀ rɔ́rɔ̀ ndɨ̀ nilo Yěsù-dɔ̀, ndìvǔ dhu kà-tsʉ̌, ndàtɨ: ràrɨ̌ àdhɨ ndɨ kìpfǒ rɨ́ ndàbhʉ òmvǔ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nɨ́, Pɛ́tɛrʉ̀ itdègu wɔ̀ ábhàlɨ̌ àlǎ, nɨ́ kǎdʉ̀ dhu ìvu Yěsù-tsʉ̌, ndàtɨ: «Olu Ádrʉ̀ngbǎlɛ́, ádhu ndɨ wɔ̀ atdídɔ̌ nyɨ nyózè pbʉ̀kʉ̀ ábhàlɨ̌ rɔ̌ ndɨ̀ nɔnzɨya?» ");
INSERT INTO niy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nɨ́, Yěsù àdʉ̀ dhu àdu Pɛ́tɛrʉ̀ tɔ̀, ndàtɨ: «Ma mapɛ́ kòzè ràdɨ, ɨ̀nzɨ̌ rɔ̀vɛ̀, ràrà àhʉ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ma míngo tdɨ́tdɔ̌ yà adzɨ ɔ̌ ɔ̀ná ɨdhɔ ɔ̀, nɨ́ ndɨ dhu àndà tɨ́ ɨnyɨ? Pbɛ́tʉ̀, ma mátɨna nyɨ nɨ̌: ‹Ʉ́ngʉ̌ owùdu!›» ");
INSERT INTO niy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wɔ̀ dhu bhěyi Yěsù ʉ̀nɔ̀ dhu-ɔ̀yɨ̌ náadʉ̀ ndʉ̀gà ka ná’ù alɛ nzínzì ɔ̌, ɨ alɛ ràdʉ̀ àmbɛ àtɨ̀nà dɔ̌, ɨ̀nzɨ̌ wɔ̀ atdídɔ̌ kǒzè ábhàlɨ̌ rɔvɛ́ya. Obhó nyʉ́, Yěsù atɨ nzá ɨ̀nzɨ̌ kà rɔvɛ́ya, pbɛ́tʉ̀, kǎtɨ Sìmonì nɨ̌: ndɨ̀ rapɛ́ ndɨ ábhàlɨ̌ nózè ɨ̀nzɨ̌ rɔ̀vɛ̀, ràrà àhʉ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ ndɨ̀ ndíngo tdɨ́tdɔ̌ yà adzɨ ɔ̌ ɔ̀ná ɨdhɔ ɔ̀, nɨ́ ndɨ dhu ràndà tɨ́ ka. ");
INSERT INTO niy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kɔ̀rɨ́ dhu nawɛ, ndàdʉ̀ àndinà alɛ nɨ́ yà atdídɔ̌ Yěsù azè ábhàlɨ̌. Ndɨrɔ̀, mǎ mà’ù wà dhu kǎndí dhu ràrɨ̌ obhó dhu nyʉ́. ");
INSERT INTO niy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yěsù anzɨ̀ ábhɔ̌ ngʉ̌kpà dhu nyʉ́. Nɨ́, ka kandíyana gukyè ɨ dhu atdátdírà ɔ̌, nɨ́ kɔ́rɔ́ ɨ dhu ka kàndǐ ɔ̀yà bhǔkù náakána nzɨ̌ yà adzɨ ɔ̌.");
INSERT INTO niy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tòfilǒ pbǎlɛ́, yà angyɨ ma mándǐ ɨndʉ̀ bhǔkù ɔ̀, ma máwɛ Yěsù anzɨ̀ kɔ́rɔ́ dhu, kǔdhè ìndrǔ tɔ̀ dhu mànà, rɔ̀pɛ̀ ndɨ̀ dɔ̀na-kpa ɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ràrà àhʉ kà rɔ̌dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀ ɔ̀ná ɨdhɔ ɔ̀. Tdʉ̌ ndɨ̀ ndɔdzɨ́ rɔ̀, kʉ̌yá dhu Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí bhà ɔbɨ nɨ̌, yà fɨ̌ndà ndɨ̀ ndóvò uvitatálɛ tɔ̀ abádhí rǒngo ɔ̀nzɨ̀nà dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ndɨ̀ ndɔ́vɛ̀ kɔtdʉ̀ ndɨ̀, ndàdʉ̀ ndɨ̀ngbɛ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu-dzidɔ̌, Yěsù ɨtɛ̀ ndɨ̀ ibí otu nyʉ́ ɔ̌ pbɨ̀ndà uvitatálɛ tɔ̀, ɨ̀fɔ kumì ɨdhɔ nzínzì ɔ̌. Kǎnzɨ̀ wɔ̀ dhu ndɨ́nɨ̌ ìnè ndɨ̀ ndɨ́’ɨ̀ ípìrɔ̌ rɔ̀ nyɨ̀kpɔ́na nà dhu tɔ́ obhónga nɨtɛ̀ tɨ́ abádhí tɔ̀. Kǎránà dhu ɔ̀vɔ̀ rɔ̌ abádhí tɔ̀ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nɨ́ atdíku, atdíkpá Yěsù mà rɨ̌’ɨ̀ ɔ̀nyʉ̀-tsʉ̀nǎ pbɨ̀ndà uvitatálɛ mànà rɔ́rɔ̀, kʉ̌yá dhu abádhí tɔ̀, ndàtɨ: «Àpɛ́ nyɨ̀và nyɨ̌ Yèrùsalɛmà tɔ́ kɨgɔ̀ ɔ̌ rɔ̀. Pbɛ́tʉ̀, nyɔ̀dɔ yà fʉ̌kʉ̀ ma mɔ́vɔ̀ Àbadu Kàgàwà náakɔ̀ fʉ̌kʉ̀ làká. ");
INSERT INTO niy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Obhó tɨ́, bàtizò nubhónà Yùwanɨ̀ núubhónà bàtizò ìndrǔ tɔ̀ ɨdha nɨ̌. Pbɛ́tʉ̀ ngúfe ɨdhɔ dzidɔ̌, nyɨ̌, nyɨ̌ nyɨ́ Ɨ̀lɨ̌lǎ-Alafí tɔ́ bàtizò nálʉ̌.» ");
INSERT INTO niy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yěsù-tɨ́ ɨ̀ nùndu kàbhà uvitatálɛ níivú dhu kà-tsʉ̌, ’àtɨ: «Ádrʉ̀ngbǎlɛ́, tɨ́ kòmbí nga ndɨ nyɨ nyɨ́ Pbàìsràyélí tɔ́ idzi nádǔ abádhí-fɔ ɔ̀ nɨ̌?» ");
INSERT INTO niy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nɨ́, Yěsù adʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Ɨ̀nzɨ̌ nɨ́ ɔ̀tɛ̌kʉ ndɨ nyʉ̌nɨ ndɨ ɨdhɔ mà, ndɨ kàsʉmɨ̀ mànà. Àbadu náatdɨ̀ ka atdírɔ̀ pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ɔbɨ-bvʉ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pbɛ́tʉ̀, nyɨ̌ nyabáya ádrʉ̀ngbǎnga tɔ́ ɔbɨ Ɨ̀lɨ̌lǎ-Alafí rǐfo dʉ̀kʉ́ nɨ́nganɨ́. Nɨ́, nyɨ̌ nyadʉ̀ya òngo pbàkà ngàmbì tɨ́ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌, Yùdɛyà tɔ́ pbìrì ɔ̌, ndɨrɔ̀ Sàmàrɨyà tɔ́ pbìrì ɔ̌, ràrà àhʉ yà adzɨ-tsʉ̀ náadɨ̀ ndɨ̀ ɨ.» ");
INSERT INTO niy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wɔ̀ dhu ndɨ̀ ndɔ̀tɛ̀ dhu-dzidɔ̌ nɨ́ ndɨ Yěsù náapɛ̀ ndɔ̀dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀, àzèmbè abádhí rǎndàna rɔ́rɔ̀, àpbù ràrà ndìwi abádhí-nyɨ̀kpɔ́ ɔ̌ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nɨ́, òko abádhí òko nyɨ̀kpɔ́ya ɨ̀ ʉ̀dɨ̌ ’àmbɛ Yěsù àrànà ɔ̀rʉ̀-akpà ɔ̀ ɨ nga nándà dɔ̌ rɔ́rɔ̀ nɨ́ ndɨ, ɔ̀wɔ̌wʉ̀ mʉ̀dzarʉ̀ nʉ̀fɔ̌ rɔ̀yá ɔ́yɔ̌ alɛ nʉ́ʉtɔ ɨ̀ abádhí-tɨ́, ");
INSERT INTO niy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","’àdʉ̀ àtɨ̀nà abádhí nɨ̌: «Gàlìlayà ɔ̌ bhǎ, ádhu nyɨ̌ nyòkò ʉrɔ́, nyǎmbɛ ɔ̀rʉ̀-akpà ɔ̀nga nándà dɔ̌ nɨ́? Wɔ̀ Yěsù, nzínzìkʉ ɔ̌ rɔ̀ ndɨ̀ nɨ̀và ndɔ̀dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀ alɛ, náadùya ndɨ̀ ányɨ̀rɔ̀ àdhàdhɨ̀ wɔ̀ nyɨ̌ nyàla kà rǎrà ányɨ̀ dhu bhěyi tɨ́.» ");
INSERT INTO niy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wɔ̀ dhu-dzidɔ̌, Yěsù bhà uvitatálɛ náadù ɨ̀ pbìrì dɔ̀ rɔ̀, ’òwù Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Ndɨ pbìrì-ɔvɔ̀ nɨ’ɨ̀ Mìzèyìtunì, ndɨrɔ̀ ndɨ pbìrì ɨ’ɨ̀ ɨ́kyɛ̀rɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ tɨ́rɔ̀ mbɛ̀mbɛ̀ atdí kìlòmɛ̌tɛ̀rɛ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nɨ́, abádhí níitdègu òwu ùvò Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀, nɨ́ abádhí atsù ɨdza, ’àdʉ̀ ùpo ɔrʉ̀nǎ rɔ̀ ka kɔ́bhɔ̀lɔ̀ ányɨ̀dzá kàluga ɔ̀. Ndɨ kàluga nɨ’ɨ̀ angyinǎrɔ̀ màtɨ́ abádhí arɨ́ ’ùndǔ ɔ̀ná bìlǐnganà kàluga. Ɨ uvitatálɛ nɨ’ɨ̀ Pɛ́tɛrʉ̀, Yùwanɨ̀, Yàkɔbhɔ̀, Àndɛ̀rɛyà, Fìlipò, Tʉ̀masɨ̀, Bàrtɔ̀lɔ̀mayò, Màtayò, Yàkɔbhɔ̀, Àlʉ̀fayò t’ídhùnà, Sìmonì, yà atdídɔ̌ ndɨ̀ nugyénà fɨ̀yɔ́ pbìrì dɔ̌ alɛ, ndɨrɔ̀ Yudhà, Yàkɔbhɔ̀ t’ídhùnà. ");
INSERT INTO niy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abádhí andu ɨ̀ atdíkpá, ’òngò ’ɨ̀tsɔ̀ bìlǐnganà atdyúya nyʉ́ nà. Ndɨrɔ̀, abádhí nzínzì ɔ̌ ɨ’ɨ̀ átɔ̀ nɨ’ɨ̀ Màrɨyà, Yěsù tsánà mà, ngʉ̌kpà vèbhálɛ mà, ndɨrɔ̀ Yěsù t’ádɔ́na mànà. ");
INSERT INTO niy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nɨ́ atdíku, kɔ̀rɨ́ alɛ núundu ɨ̀ mbɛ̀mbɛ̀ atdí mɨyà dɔ̀ná ɔ́yɔ̌ kumì nà alɛ tɨ́ rɔ̀. Nɨ́ ndɨ nɨ́nganɨ́, Pɛ́tɛrʉ̀ ɨvà ndɨ̀ ndìdè abádhí nzínzì ɔ̌, ndàdʉ̀ àtɨ̀nà: ");
INSERT INTO niy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Àbanɨ̌nzó, dhu àkǎ wà yà Ɨ̀lɨ̌lǎ-Alafí náavɔ̀ Ɨ̀lɨ̌lǎ Andítá ɔ̀ dhu ràkǎ. Ádrʉ̀ngbǎ kamà Dàwudì-otù ɔ̌, kǎvɔ̀ dhu angyangyi Yudhà-okú dɔ̀ rɔ̀. Ndɨ Yudhà nɨ́ ndɨ yà Yěsù òsò rówu alɛ tɔ́ pɨ̀kɔ̀-dɔ̀tsírɔ́ idè alɛ. ");
INSERT INTO niy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ka nɨ’ɨ̀ àlɛ̌ nzínzì ɔ̌ alɛ nyʉ́, ndɨrɔ̀ kà-kàsʉ̌ nɨ́ɨ’ɨ̀ ìnè. ");
INSERT INTO niy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kǎdzì atdí ɨnga ɨnzá àkǎ otu ɔ̌ ndɨ̀ ndóngyè fʉ̀rangà rɔ̌. Pbɛ́tʉ̀, ndɨ ɨnga ɔ̌ kɨ̌tsɨ, nyɨ̀na-ndri rɔ̀pbɨ̀ ndɨ̀ wɛmbɛrɛ̀ tɨ́ adzɨ rɔ̌, ɔ̀na rɨ̀kpà ndɨ̀, tsùna márámàrà ràdʉ̀ ndʉ̀vɔ adzɨ-bvʉ̌. ");
INSERT INTO niy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nɨ́ Yèrùsàlɛmà ɔ̌ bhà kɔ́rɔ́ nɨ́ɨrɨ kà-rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu, ’àdʉ̀ ndɨ ɨnga-ɔvɔ̀ nɔ́vɔ̀ Àkɛ̀ldamà tɨ́ ávàya ɔ̌. Àkɛ̀ldamà-tɨ̀ nɨ́: ‹Azu tɔ́ ɨnga.› ");
INSERT INTO niy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Zàburì tɔ́ bhǔkù ɔ̀ ka kándǐ dhu, katɨ: ‹Kàbhà pbanga rǒngo rʉ̀ngʉ̀ tɨ́, ɨ̀nzɨ̌ atdí alɛ mà rʉ̀bhà ndɨ̀ ɔ̀ná.› Ndɨrɔ̀ kà rǎtɨna átɔ̀: ‹Kàbhà kasʉ àbhʉ̌ ka kɨ́ ngǎtsi alɛ tɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yà Yěsù-owù ɔ̌ àlɛ̌ kúbhì ùbhi rɔ̌ mànà atdíkpá alɛ rɨ̌’ɨ̀ ìnè, ");
INSERT INTO niy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","rɔ̀pɛ̀ ndɨ̀ ndɨ Yěsù rɨ̌ bàtizò àlʉ̌ Yùwanɨ̀-fɔ́ dhu ɔ̀ rɔ̀, ràrà àhʉ kà rɔ̌dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀ ɔ̀ná ɨdhɔ ɔ̀. Nɨ́, dhu àkǎ wà àlɛ̌ ròvò abádhí nzínzì ɔ̌ atdí alɛ, ndɨ́nɨ̌ àlɛ̌ koko tɨ́ mànà Yěsù ɨ́ngbɛ̀ ndɨ̀ dhu tɔ́ ngàmbì tɨ́.» ");
INSERT INTO niy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nɨ́, abádhí adʉ̀ ɔ́yɔ̌ alɛ-ɔvɔ̀ nípfo: Yɔ̀zɛfʉ̀ mà Màtíyà nà. Yɔ̀zɛfʉ̀ ka kanzínà átɔ̀ Bàrɨ̀sabà tɨ́, ndɨrɔ̀ ɨtdɛ̀ta tɔ́ kɔ̌vɔ̀ nɨ’ɨ̀ Yèsitò. ");
INSERT INTO niy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wɔ̀ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ mà náadʉ̀ ’ɨ̀tsɔ̀ ɨ̀ ràtɨ: «Àdrʉ̀ngbǎlɛ Kàgàwǎ, nyɨ nyʉ́nɨ kɔ́rɔ́ alɛ-afí ɔ̀ dhu. Nɨ́, ɨ́tɛ̀ pɛ́ kǎkà ɔ́yɔ̌ alɛ nzínzì ɔ̌ nyɨ nyʉ́ nyɨ nyòvò alɛ, ");
INSERT INTO niy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ndɨ́nɨ̌ uvitatálɛ tɔ́ kasʉ nɔnzɨ tɨ́ yà Yudhà ʉ́bhà ngari ɔ̌, ndàdʉ̀ àrà yà pbɨ̀ndà dhu tɨ́ ndɨ̀ ndʉ́nɨ ngari ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nɨ́rɔ̀ nɨ́ ndɨ Pɛ́tɛrʉ̀ mà ɔdhɨ́na mànà náadʉ̀ ngàlà nɔ́vɨ̀. Ndɨ ngàlà adʉ̀ Màtíyà àlʉ, Màtíyà ràdʉ̀ kɔ̌kɔ̀ atdí kumì dɔ̀ná atdí nà ɨ̀ nʉ́bhà Yěsù bhà uvitatálɛ-bvʉ níse. ");
INSERT INTO niy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pɛ̀ndɛ̀kɔtɛ̀-ɨdhɔ̀ níitdègu àkǎ, nɨ́ Yěsù ná’ù alɛ nɨ́ɨ’ɨ̀ atdíkpá ɨ̀ àndu tsʉ̀ya atdí ngari ɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nɨ́ kòmbómbí, awɛ rǒpili ɔbɨ nyʉ́ nà dhu bhěyi rɔ́’ɔ dhu tɔ́ wɔ̀gɔ̀ nɨ́ɨrɨ ndɨ̀ ɔ̀rʉ̀-akpà ɔ̀ rɔ̀ rífo rɔ́, ndɨ dhu ràdʉ̀ abádhí òkò ɔ̀ná ɨdza nɨ́ra. ");
INSERT INTO niy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nɨ́rɔ̀ nɨ́ ndɨ abádhí ala kàzʉ-ɨdà-dɔ bhěyi rólo dhu-ɨdà-dɔ ányɨ̀dzá, ɔ̀nánga ràdʉ̀ ndʉ̀ndɔ̀ ròkò abádhí-dɔ̀tsírɔ́. ");
INSERT INTO niy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nɨ́ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ́ɨrá abádhí kɔ́rɔ́, abádhí ràdʉ̀ ’ɔ̀pɛ̀ ’ɔ̀tɛ̀ dhèdhèrɔ̀ alɛ t’ávàna-tɨdɔ̀ àdhàdhɨ̀ Ɨ̀lɨ̌lǎ-Alafí nɨ́tɛ̀ ka fɨ̌yɔ̀ dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wɔ̀ dhu rɨ̌ ndɔ̀nzɨ ɔ̀ná ɨdhɔ ɔ̌, yà adzɨ ɔ̌ kɔ́rɔ́ pbìrì ɔ̀nǎ rɔ̀ íwǔ, Kàgàwà rɔ̌ afíya nápbǎ Pbàyàhúdí, nɨ́ɨ’ɨ̀ ìnè átɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nɨ́, wɔ̀rɨ́ wɔ̀gɔ̀ ɨ̀ ɨ̀rɨ̀ rɔ̀, ìndrǔ náandu ɨ̀ Yěsù ná’ù alɛ rɨ̌’ɨ̀ rɔ́, ɨdhɔ ràdʉ̀ ’ʉ̀kɔ atdídɔ̌ ngǎtsi alɛ rɨ̌ abádhí ɨ̀rɨ ávàna nyʉ́ nɔ́tɛ rɨ́ rɔ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nɨ́, ɨdhɔ nʉ́ʉkɔ abádhí atdídɔ̌, ’àdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Hɔ̀kɔ̀! Kɔ̌kɔ̀ rɔ́tɛ alɛ kɔ́rɔ́ tɨ́ obhó Gàlìlayà ɔ̌ bhà nyʉ́? ");
INSERT INTO niy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nɨ́, ádhu ngǎtsi alɛ rɨ̌ abádhí ɨ̀rɨ ávàna nyʉ́ nɔ́tɛ rɨ́ rɔ́ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kǎkà àlɛ̌ nzínzì ɔ̌ rɨ́’ɨ̀ atdídhená alɛ níwǔ Pbàpartɛ̀ tɔ́ pbìrì ɔ̀ rɔ̀, Pbàmedì mà Pbàèlamù mànà tɔ́ pbìrì ɔ̀ rɔ̀. Ndɨrɔ̀, ngʉ̌kpà alɛ níwǔ Mɛ̀zɔ̀pɔ̀tàmiyà mà, Yùdɛyà mà, ndɨrɔ̀ Kàpàdòkiyà mànà tɔ́ pbìrì ɔ̀ rɔ̀. Ngʉ̌kpà-tsí níwǔ Pɔtɔ̀ mà Àziyà mànà tɔ́ mʉ̀lɛngʉ̀ ɔ̀ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ngʉ̌kpà ràdʉ̀ ìwu Fùrùgiyà rɔ̀, Pàfùliyà rɔ̀, Mísrì rɔ̀, ndɨrɔ̀ kyɛ̀rɔ̀kyɛ̀rɔ̀ Lìbiyà tɔ́ pbìrì ɔ̌ atdí pbanga Kùrenì tɨ́ kátɨna ɔ̀ rɔ̀. Ndɨrɔ̀, ngʉ̌kpà alɛ íwǔ Rɔmà tɔ́ kɨgɔ̀ mà, Krɛ̌tɛ̀ tɔ́ pbìrì mà, Àràbiyà tɔ́ pbìrì mànà ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Atdídhená alɛ nɨ́ Pbàyàhúdí nyʉ́, ndɨrɔ̀ ngʉ̌kpǎkà nɨ́ ʉ̀gɛ̀rɛ̀ tɨ́ ɨ̀ nʉ́gɛ̀rɛ̀, ’òngò Pbàyàhúdí tɔ́ sɔmà tɔ́ Ʉyátá nɨ́fʉ alɛ. Pbɛ́tʉ̀, àlɛ̌ kɨ́ abádhí ɨ̀rɨ Kàgàwà anzɨ̀ ádrɔ̀drɔ̌ dhu tɔ́ màkʉ̌rʉ̀ àwɛ̌ rɨ́ àlɛ̌ t’ávàna nyʉ́ ɔ̌ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nɨ́, ɨdhɔ nʉ́ʉkɔ kɔ̀rɨ́ alɛ, fɨ̀yɔ́ ɨrɛ̀ta rìku. Abádhí ambɛ́nà dhu ɔ̀ngʉ̀ dɔ̌ tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Wɔ̀ dhu-tɨ̀ nyʉ́ nɨ́ àdhu?» ");
INSERT INTO niy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pbɛ́tʉ̀, ngʉ̌kpà alɛ-tsí náambɛ́nà Yěsù ná’ù alɛ rʉ̌nɔna dhu gàyà nɔ́nzɨ̀ dɔ̌ ɔ̀nzɨ tɨ́, ’àdʉ̀ àmbɛ àtɨ̀nà dɔ̌: «Ɨwà kɔ̌kɔ̀ alɛ òrì atdídɔ̌.» ");
INSERT INTO niy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà uvitatálɛ tɨ́rɔ̀ ɨ̀ ìkò atdíkpá atdí kumì dɔ̀ná atdí nà ngʉ̌kpà ɔdhɨ́na mànà rɔ́rɔ̀, Pɛ́tɛrʉ̀ apɛ̀ ndɔ̀vɔ̀ dhu ɔrʉ́ tǔna nyʉ́ nà ihé-yà tɔ̀. Kǎtɨ: «Nyɨ̌ Pbàyàhúdí tɨ́rɔ̀, ndɨrɔ̀ nyɨ̌ kɔ́rɔ́ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ nyɨ̌ nyɨ́’ɨ̀ rɔ̀, nyɨ̀kpɛ̀lɛ̀ bɨ̌kʉ nyɨ̌rɨ̀ yà ma mʉ́nɔna dhu mběyi. ");
INSERT INTO niy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kɔ̀rɨ́ alɛ nórì nzá wɔ̀ nyɨ̌ nyɨ́rɛ̀na dhu bhěyi, àlɛ̌ kòko òko ɨ̀bhʉ adyifɔ̀-sɨsɨ̀ kútsingá nga tɔ́ ɔ̌ tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pbɛ́tʉ̀, wɔ̀ rɨ́ ndɔ̀nzɨ dhu nɨ́ yà Kàgàwà bhà nabì Yɔ̀wɛlɛ̀ náavɔ̀ ìndrǔ tɔ̀ dhu. Kǎtɨ: ");
INSERT INTO niy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Kàgàwà rǎtɨna: yà adzɨ ɔ̌ dhu-tsʉ̀ rɨ̌ ndɔ̀dɨ̀ nɨ́nganɨ́, ma mɨráya kɔ́rɔ́ alɛ Afídu nɨ̌. Nɨ́ fʉ̀kʉ́ kpabhínzo mà vèbhínzo mànà nóongoya pbànábí tɨ́, Fʉ̀kʉ́ zàdhà náalaya dhu ɔnyʉ bhěyi rɔ́dzɨ̀ dɔ̀yà dhu tɔ́ ɔ́fɔ̀ ɔ̌, Fʉ̀kʉ́ mʉ̀là-akpá tɔ̀, madʉ̀ dhu ɔ̀vɔ̀ ɔ̀nyʉ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Obhó tɨ́, ndɨ nɨ́nganɨ́, ma mɨráya pbàkà ɨnɔ-akpá mà, pbàkà ɨnɔ-ayí mànà Afídu nɨ̌, ràdʉ̀ òngo pbànábí tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma mɔnzɨya yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌, madʉ̀ wɨwɨ̀ ɔ̀nzɨ̀ yà adzɨ dɔ̌. Ɨ dhu nɨ’ɨya azu mà, kàzʉ mà, ndɨrɔ̀ àpbù bhěyi ʉ̀tɨ̀ ɨkɔ mànà. ");
INSERT INTO niy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tdʉ̌ wɔ̀ ndɨ Ádrʉ̀ngbǎlɛ Kàgàwà bhà ɨdhɔ náaká rɔ̀, adyifɔ̀ nʉ́ʉgɛ̀rɛ̀ya ndɨ̀ ndòngò ɨ́nɔ̀ tɨ́, ndɨrɔ̀ àbǐ nʉ́ʉgɛ̀rɛ̀ya ndɨ̀ ndòlù azu bhěyi. Ndɨ ɨdhɔ nɨ’ɨya ádrʉ̀ngbǎ ɨdhɔ nyʉ́. Ndɨrɔ̀, ndɨ ɨdhɔ nɨ’ɨya Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ rɨ̌ ndàvǐ kpangba ɔ̀ná ɨdhɔ. ");
INSERT INTO niy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɨ́rɔ̀ nɨ́ ndɨ Kàgàwà araya ɔvɔ̀na nànzì ɨ̀ngbàtɨ́ ɨ́lɨ ndɨ̀ alɛ mà nɨ́gʉ rɔ̌.› ");
INSERT INTO niy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nyɨ̌ Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhǎ, nyɨ̀rɨ yà ma mʉ́nɔna fʉ̌kʉ̀ dhu. Kàgàwà nɨ́tɛ̀ wà dhu ndɨ̀ rɔ́pɨ̀ ndɨ Yěsù, yà Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ. Obhó tɨ́, kǒtù ɔ̌, Kàgàwà ɔ́nzɨ̀ wà wɨwɨ̀ mà, yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mànà, ndàdʉ̀ ize nɨ́tɛ̀ nzínzìkʉ ɔ̌. Nɨ́ nyɨ̌ nyʉ́nɨ ɨ dhu mběyi nyʉ́. ");
INSERT INTO niy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wɔ̀ ndɨ alɛ ka kipfo kabhʉ fʉkʉ́, àdhàdhɨ̀ yà angyangyɨ Kàgàwà udhé, ndɨrɔ̀ angyangyɨ kʉ̌pɨ́ dhu bhěyi. Nɨ́, nyɨ̌ nyípfo ka, nyǎbhʉ ɨnzá àpɛ̀ Kàgàwà ʉ̀nɨ̌ alɛ ròhò, ’ʉ̀tɔ̌ mùsàlabhà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ka kɔ́tdʉ̀ ka, pbɛ́tʉ̀ Kàgàwà ádʉ̀ kàbhʉ rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀, ndɨ dhu ràdʉ̀ kàbhʉ ràhʉ ɔvɛ tɔ́ àpbɛ̀ ɔ̌ rɔ̀, ɨ̀mbǎ ɔvɛ nɨ́’ɨ̀ ɔbɨ nà kà dɔ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Obhó tɨ́, ádrʉ̀ngbǎ kamà Dàwudì náavɔ̀ dhu kǒkú dɔ̀ rɔ̀, ndàtɨ: ‹Ma mongónà Ádrʉ̀ngbǎlɛ Kàgàwà àla ɔnzɨ̀dú bìlǐnganà. Kà rɨ̌’ɨ̀ ìnè idú fangà dɔ̀nǎ rɔ̀, nɨ́ ùdúnga rɨ̌ nzɨ̌ ìvi ɔdɔ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kɔ̀nɨ̌ wɔ̀ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ afídu rɨ̌’ɨ̀ dhɛ̀dhɛ nà, dhɛ̀dhɛ tɔ́ ɔtɛ ràdʉ̀ ɨ̀’ɨ̀ ɨdàdu dɔ̌. Ndɨrɔ̀ ma mʉ̀nɨ wà dhu, ɔvɛ-bvʉ̀ màtɨ́ ngbɔ̌du radɨ̀ya ɨnga t’ɔ́dɔta nà tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Obhó tɨ́, nyɨ nyʉbhàya nzɨ̌ afídu ràdɨ ɔvɛ-bvʉ̀. Ndɨrɔ̀, nyɨ nyadʉ̀ya nzɨ̌ ɨma, pbʉ̀kʉ̀ ɨ̀lɨ̌lǎ alɛ-abvò nyʉ́ nʉ́bhà rɔ̀mɔ̀ ibhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nyɨ nyɨ́tɛ̀ wà ípìrɔ̌nga tɔ́ otu idù, ndɨrɔ̀, ɔnzɨ̀nʉ́ ma mɨ́ motù nɨ́nganɨ́, ɨdhɛ̀du nɨ́ɨkaya ndɨ̀ atdídɔ̌ nyʉ́.›» ");
INSERT INTO niy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tdɨ́tdɔ̌ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà ihé-yà nɨ̌: «Ɔdhɨ́dǔ, ma mòzè mɔvɔ̀ dhu kpangba fʉ̌kʉ̀ àlɛ̌ t’ábhunà-nzɨ̀nzɨ̀, ádrʉ̀ngbǎ kamà Dàwudì-okú dɔ̀ rɔ̀: kǎvɛ̀, kadʉ̀ ndɔ̀tdʉ̀. Ndɨrɔ̀ indo màtɨ́, kǎ-dzɨ̀dɔ rɨ̌’ɨ̀ ìnè àlɛ̌-rábvʉ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pbɛ́tʉ̀ ka nɨ’ɨ̀ Kàgàwà bhà nabì. Nɨ́, kʉ̌nɨ dhu angyangyɨ Kàgàwà ratsɔ̀ dhu ndàtɨ, ndɨ̀ rɨlɨya kàbhà pbàdzʉkʉrʉ nzínzì ɔ̌ atdí alɛ ràdɨ kǎrì dɔ̌ ádrʉ̀ngbǎ kamà tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ádrʉ̀ngbǎ kamà Dàwudì náala ndɨ̀ nɔnzɨya dhu angyangyɨ. Nɨ́ ndɨ dhu bhěyi nɨ́ ndɨ kǎvɔ̀ dhu angyangyɨ Krɨ́stɔ̀ nɨ́ɨngbɛ̀ya ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu dɔ̌. Kǎtɨ: ‹Kàgàwà nʉ́ʉbhàya nzɨ̌ ka ɔvɛ-bvʉ̀. Ndɨrɔ̀, kǎ-bvò nɔ́ɔmɔ́ya nzɨ̌ ibhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kàgàwà abhʉ̀ wà wɔ̀ ndɨ Yěsù rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ àlɛ̌’ɨ kɔ́rɔ́, àlɛ̌ nɨ́ ndɨ dhu tɔ́ ngàmbì. ");
INSERT INTO niy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nɨ́rɔ̀, Kàgàwà ábhʉ wà ka rɔ̀dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀, ràdʉ̀ àdɨ fɨ̀ndá fangà dɔ̀nǎ rɔ̀. Ndɨrɔ̀, kǎkɔ wà yà Àbanà akɔ̀ fɨ̀ndá làká Ɨ̀lɨ̌lǎ-Alafí. Nɨ́, kɨ̀rǎ wà mǎ kà nɨ̌. Wɔ̀ ndɨ Ɨ̀lɨ̌lǎ-Alafí rɔ̌nzɨna dhu nɨ́ ndɨ wɔ̀ nyɨ̌ nyálǎna nyǎdʉ̀ àmbɛ ɨ̀rɨ̀nà dɔ̌ kòmbí. ");
INSERT INTO niy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ádrʉ̀ngbǎ kamà Dàwudì núupò nzá ɔ̀rʉ̀-akpà ɔ̀, pbɛ́tʉ̀ kǎtɨ: ‹Ádrʉ̀ngbǎlɛ Kàgàwà náatɨ pbàkà Ádrʉ̀ngbǎlɛ nɨ̌: Ádɨ̌ pbàkà fangà dɔ̀nǎ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ràrà àhʉ ma mɨ́ pbʉ̀kʉ̀ òmvǔ nábhʉ̌ nyɔbɛ̀ dɔ̀ya dhu ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nɨ́rɔ̀, kɔ́rɔ́ Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhà nákǎ ɨ̀ rʉ̀nɨ dhu mběyi nyʉ́, Yěsù wɔ̀ nyɨ̌ nyábhʉ kʉtɔ̌ mʉ̀sàlabhà dɔ̌ alɛ, nɨ́ Kàgàwà rábhʉ wà ròngò Ádrʉ̀ngbǎlɛ tɨ́, ndɨrɔ̀ Màsiyà tɨ́.» ");
INSERT INTO niy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nɨ́, wɔ̀ Pɛ́tɛrʉ̀ ɔ̀vɔ̀ fɨ̌yɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, ndɨ dhu náasʉ̀ ihé-yà atdídɔ̌. Nɨ́ abádhí adʉ̀ dhu ìvu Pɛ́tɛrʉ̀ mà ngʉ̌kpà uvitatálɛ mànà-tsʉ̌, ’àtɨ: «Àbanɨ̌nzó, mǎ màkǎ mɔ̌nzɨ̀ dhu ɨ̀ngbàtɨ́?» ");
INSERT INTO niy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ dhu àdu abádhí tɔ̀ ndàtɨ: «Nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga. Ndɨrɔ̀ nyàlʉ̌ bàtizò Yěsù Krɨ́stɔ̀-ɔvɔ̀ rɔ̌, ndɨ́nɨ̌ Kàgàwà ʉbà tɨ́ fʉ̀kʉ́ nzɛ́rɛnga, nyǎdʉ̀ kàbhà Ɨ̀lɨ̌lǎ-Alafí tɔ́ pɛrɛ̀ nákɔ. ");
INSERT INTO niy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Obhó tɨ́, Ádrʉ̀ngbǎlɛ Kàgàwà náakɔ̀ ndɨ làká fʉ̌kʉ̀ fʉ̀kʉ́ nzónzo mànà. Ndɨrɔ̀ kǎkɔ̀ ka átɔ̀ yà ndɨ̀ ndúnzina kɔ́rɔ́ alɛ, yà ɨtsɛ arɨ́’ɨ̀ rʉ̀kʉ́ rɔ̀ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pɛ́tɛrʉ̀ ʉnɔ ábhɔ̌ ngʉ̌kpà dhu nyʉ́ tdɨ́tdɔ̌ abádhí tɔ̀, ndɨ́nɨ̌ abádhí nabhʉ̀ tɨ́ rà’ù ndɨ̀ ndʉ̀nɔ̀ dhu, ndɨrɔ̀ ndɨ́nɨ̌ abádhí-afí nabhʉ̀ tɨ́ ròtsì ɔbɨ. Kǎvɔ̀ dhu abádhí tɔ̀, ndàtɨ: «Nyàbhʉ nyɨ̌ Kàgàwà rɨ̀gʉ̌ nyɨ̌, ɨ̀nzɨ̌ nyɨ̌ nyabá tɨ́ kɔ̌kɔ̀ nzɛ́rɛ alɛ tɔ́ ɔ́fɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wɔ̀ Pɛ́tɛrʉ̀ ʉ̀nɔ̀ dhu nà’ù alɛ kɔ́rɔ́ náadʉ̀ bàtizò à’ù kubho fɨ̌yɔ̀. Nɨ́ ndɨ nɨ́nganɨ́, Yěsù ná’ù alɛ-bvʉ níisé ndɨ̀ mbɛ̀mbɛ̀ ɨ̀bhʉ lʉfʉ̀ alɛ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɨ́ ɨ alɛ náapbá afíya atdídɔ̌, ’òngò Yěsù bhà uvitatálɛ rǔdhěna fɨ̌yɔ̀ dhu ɨ̀rɨ̀. Abádhí andu tsʉ̀ya, ’òngò òko atdíkpá, ’òngò dhu ɔ̀nyʉ̀ atdíkpá, ndɨrɔ̀ ’òngò ’ɨ̀tsɔ̀ atdíkpá. ");
INSERT INTO niy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɔdɔ ongónà ɨ̀sɨ̌ kɔ́rɔ́ alɛ ɔ̀, yà Yěsù bhà uvitatálɛ rɔ̌nzɨna yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mà, abádhí rɔ̌nzɨna wɨwɨ̀ mànà dhu àlǎ ɨ̀ ɨ́ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kɔ́rɔ́ alɛ, yà Yěsù ná’ù, nóongónà òko atdíkpá. Ndɨrɔ̀, abádhí ongónà fɔyá dhu ʉ̀lɨ atdíkpá kàsʉ̌ya nɔnzɨ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Abádhí ongónà fɔyá dhu-tsí mà fɔyá ongyéngá mànà núdzi, ’àdʉ̀ ɨ̀ òngyè fʉ̀rangà nʉ́ndɔ̀ fɔyá, ngǎtsi alɛ ràbà ka dzʉ̀nàna nyʉ́ ɔ̀nzɨ̀ rádʉ̀ dhu-bvʉ̀tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Abádhí ongónà tsʉ̀ya àndu kɔ́rɔ́ ɨdhɔ ɔ̌ Kàgàwà bhà ɨdzá. Ndɨrɔ̀, abádhí ongónà ɨdzàya ɔ̀nǎ ɔ̀nyʉ̀ nɔ́nyʉ̀ atdíkpá dhɛ̀dhɛ nyʉ́ nà, ndɨrɔ̀ atdí afíya nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Abádhí ongónà Kàgàwà ìlè, kɔ́rɔ́ alɛ ràdʉ̀ abádhí ɨ̀fʉ. Ndɨrɔ̀, yà ɨnga náarúbho dhu bhěyi, Ádrʉ̀ngbǎlɛ Kàgàwà nóongónà àrà abádhí-bvʉ níse rɔ̌ yà ɔwʉ́tána tɨ́ ndɨ̀ nà’ù alɛ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Atdíku, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà náava ɨ̀ ndɨ́nɨ̌ ɨ̀ owu tɨ́ ’ɨ̀tsɔ̀ Kàgàwà bhà ɨdza ɔ̌ rɔ̀, arʉ̀gyètdí adyifɔ̀-sɨsɨ̀ adyídɔ̌ nga tɔ́ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nɨ́, Kàgàwà bhà ɨdza ka kótsù ɔ̀ná tsǎtsʉ̀-tɨ́, abádhí atù òtsótsù rɔ́rɔ̀ ka kʉgʉ atdí alɛ. Wɔ̀ ndɨ tsǎtsʉ̀-ɔvɔ̀ nɨ’ɨ̀ «Àyǎya Tsǎtsʉ̀.» Bìlǐnganà ka kongónà ndɨ alɛ nítdù, kiwǔ ɨ̀lɨnà ràdɨ ndɨ tsǎtsʉ̀-tɨ́, ràmbɛ mʉ̀dzʉ̀nà núnzi dɔ̌ ányɨ̀ dza rótsù alɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nɨ́, wɔ̀ alɛ itdègu Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà nálǎ Kàgàwà bhà ɨdza rótsù rɔ́, nɨ́ kǎdʉ̀ ndɔ̀pɛ̀ ndàmbɛ dhu ùnzi dɔ̌ abádhí-fɔ́. ");
INSERT INTO niy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nɨ́, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà nʉ́ʉdɨ́ nyɨ̀kpɔ́ya wɔ̀ alɛ rɔ̌, Pɛ́tɛrʉ̀ ràdʉ̀ àtɨ̀nà kà nɨ̌: «Ándà pɛ́ dɔ̀kà nga.» ");
INSERT INTO niy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nɨ́ wɔ̀ alɛ adʉ̀ abádhí dɔ̀ nga nándà atdyúna nyʉ́ nà, dhu ɔ̀dɔ ndɨ̀ ndɨ́ ndɨ́nɨ̌ ndɨ̀ ndabá tɨ́ abádhí-fɔ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà kà nɨ̌: «Ma mɨ́’ɨ̀ ɨ̀mbǎ ɔrɔ̀ mà, ndɨrɔ̀ fʉ̀rangà tɨ́ kátɨna sʉma mà nà màtɨ́. Ɨndʉ̀ ma mábhʉ̌na nɨ́ fudú rɨ́’ɨ̀ dhu kɛ̀lɛ̌. Nɨ́ ma mátɨna ɨnyɨ nɨ̌: ‹Nàzàretì ɔ̌ alɛ Yěsù Krɨ́stɔ̀-ɔvɔ̀ rɔ̌, ɨ́và nyɨ nyidè, nyadʉ̀ ùbhi.›» ");
INSERT INTO niy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wɔ̀ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ adʉ̀ wɔ̀ alɛ àlʉ fangà tɔ́ ɔtsʉ́na rɔ̌, ndɨ̀và ɔrʉ̀. Nɨ́ ʉrɔ́ rɔ̀ tɨ́, kà-pfɔ̀ mà kà-pfɔ̀-kɨ̀lɨ̀tà mànà náadʉ̀ ɔbɨ nábà. ");
INSERT INTO niy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nɨ́ wɔ̀ alɛ ɨbɛ ndɨ̀ ndìdè pfɔ̌na dɔ̌, ndàdʉ̀ abhi ɔ̀pɛ̀. Àbadhi mà náadʉ̀ òtsù atdíkpá Kàgàwà bhà ɨdza, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ mànà nà. Nɨ́ àrà ndɨ̀ ndárà rɔ́rɔ̀, wɔ̀ alɛ ambɛ́nà ndɔ̀bhɛ̀ dɔ̌ ɔ̀bhɛ̀ tɨ́, Kàgàwà nílè ndɨ̀ ndɨ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kàgàwà bhà ɨdzá ɨ̀’ɨ̀ kɔ́rɔ́ alɛ náala ka ùbhǐ rúbhi ndàdʉ̀ àmbɛ Kàgàwà ìlè dɔ̌ rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nɨ́, abádhí itdègu kʉ̀nɨ̌ yà Kàgàwà bhà ɨdza tɔ́ «Àyǎya Tsǎtsʉ̀» tɨ́ kátɨna tsǎtsʉ̀-tɨ́ arádɨ ndàmbɛ mʉ̀dzʉ̀nà ùnzi dɔ̌ ìndrǔ-fɔ́ alɛ tɨ́, nɨ́ ɔdɔ nɨ́ɨsɨ́ abádhí ɔ̀, ɨdhɔ ràdʉ̀ abádhí ʉ̀kɔ atdídɔ̌ wɔ̀ alɛ rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wɔ̀ alɛ náapbá ndɨ̀ atdídɔ̌ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ mànà rɔ̌. Nɨ́ abádhí adʉ̀ òwu atdíkpá, ’òwù òko Kàgàwà bhà ɨdza tɔ́ mbàrazà-tsìnǎ. Ndɨ mbàrazà-ɔvɔ̀ nɨ’ɨ̀ «Ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ bhà mbàrazà.» Nɨ́rɔ̀ nɨ́ ndɨ ìndrǔ náadʉ̀ ìtse, ɨ̀ ràndu ɨ̀ abádhí-tɨ́, ɨdhɔ ʉ̀kɔ ɨ̀ atdídɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nɨ́, Pɛ́tɛrʉ̀ itdègu wɔ̀ dhu àlǎ, náadʉ̀ dhu ìvu abádhí-tsʉ̌ ndàtɨ: «Nyɨ̌, Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhà tɨ́rɔ̀, ádhu nyɨ̌ nyàbhʉ nyɨ̌ ɨdhɔ rʉ̀kɔ nyɨ̌ wɔ̀ alɛ ɔ̀gʉ̀ dhu-okú dɔ̀ rɔ̀ nɨ̌? Ndɨrɔ̀, ádhu nyɨ̌ nyʉ̀dɨ̌ nyɨ̀kpɔ́kʉ rɔ̀ká, nyǎmbɛ mǎndà dɔ̌ fàká ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ mǎ màbhʉ ka rɔ̀gʉ̀ dhu bhěyi nɨ̌? Ndɨrɔ̀ ngǎtsi nɨ̌, Kàgàwà ózè dhu ɔ̀nzɨ mǎ marɨ́ dhu-okú dɔ̀ rɔ̀ mǎ màbhʉ ka rɔ̀pɛ̀ ndùbhi dhu bhěyi nɨ̌? ");
INSERT INTO niy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Àlɛ̌ t’ábhúna Àbràhamʉ̀, Ìsakà, Yàkɔbhɔ̀ mà tɔ́ Kàgàwà nɨ́ ndɨ pbɨ̀ndà ɨnɔ-akpà Yěsù Krɨ́stɔ̀, yà nyɨ̌ nyípfo nyǎbhʉ òmvǔ-fɔ́ alɛ nɔ́ɔvɔ̀ nàbhʉ rìlè ndɨ̀. Nyɨ̌ nyuvó nyɨ̌ lɨ̀walɨ̀ Pìlatɔ̀ rɔ̌ ɨ̀nzɨ̌ ka nɨkɔ̀lɔ̀ tɨ́ imbi ɔ̀ rɔ̀, àzèmbè ɨwà àbadhi ɔ̀tdɨ̀ kà-ànyǎ ndɨ́nɨ̌ ndɨ̀ ndɨkɔ̀lɔ̀ tɨ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nyɨ̌ nyadhɔ̀ yà Kàgàwà-nyɨ̀kpɔ́ ɔ̌ ɨ́lǎ alɛ nyʉ́, ndɨrɔ̀ obhónángatálɛ nyʉ́, nyǎdʉ̀ abvo ɔ̀kyɛ arɨ́ alɛ nyʉ́ nábhʉ kɨkɔ̀lɔ̀ imbi ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nɨ́ ndɨ dhu-otù ɔ̌, nyɨ̌ nyábhʉ kohò alɛ nɨ́ yà ípìrɔ̌nga nábhʉ̌ arɨ́ ìndrǔ tɔ̀ alɛ nyʉ́. Pbɛ́tʉ̀, Kàgàwà ábhʉ wà ka rɨ̀ngbɛ̀ ndɨ ɔvɛ-bvʉ̀ rɔ̀. Nɨ́ mǎ nɨ́ ndɨ dhu tɔ́ ngàmbì. ");
INSERT INTO niy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wɔ̀ nyɨ̌ nyálǎna alɛ nyɨ̌ nyʉ́nɨ wà mběyi nyʉ́. Nɨ́ ka nàbhʉ ràbà ɔbɨ dhu nɨ́ yà mǎ má’ù Yěsù-ɔvɔ̀ bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ. Yěsù ná’u ka kɨ́ dhu nábhʉ ndɨ ka rɔ̀gʉ̀ atdídɔ̌ wɔ̀ nyɨ̌ nyálǎna dhu bhěyi. ");
INSERT INTO niy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nɨ́ àbanɨ̌nzó, kòmbí mǎ mʉ̀nɨ wà dhu wɔ̀ nyɨ̌ nyɔ́nzɨ̀ fʉ̀kʉ́ ádrɔ̀drɔ̌ alɛ mànà Yěsù rɔ̌ dhu, nɨ́ nyɨ̌ rɔ́nzɨ̀ ɨnzá nyɨ̌ nyʉ̀nɨ nga dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pbɛ́tʉ̀, wɔ̀ Kàgàwà ádʉ̀ ɔ̀nzɨ̀nà kà-rɔ̌ dhu nɨ́ yà angyangyɨ ndɨ̀ ndavɔ̀ kɔ́rɔ́ pbɨ̀ndà pbànábí-otù ɔ̌ dhu. Kǎtɨ pbɨ̀ndà Màsiyà rabáya àpbɛ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nɨ́rɔ̀, nyʉ̀gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga, nyǎdʉ̀ ìngo Kàgàwà-tɨ’ɔ̀, ndɨ́nɨ̌ kǎdʉ̀ tɨ́ fʉ̀kʉ́ nzɛ́rɛnga níndò. ");
INSERT INTO niy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ndɨ dhu bhěyi nɨ́ ndɨ Ádrʉ̀ngbǎlɛ Kàgàwà rɨ̌ nyɨ̌ nyɨ́ nyǎsǒ ɔ̀ná kàsʉmɨ̀ nábhʉ̌ ràkǎ, ndàdʉ̀ Yěsù, yà angyangyɨ ndɨ̀ ndapɨ̀ Màsiyà nívì rɨ̀rà fʉ̌kʉ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kòmbí dhu àkǎ kà ràdɨ ɔ̀rʉ̀-akpà ɔ̀, ràrà àhʉ Kàgàwà rɨ̌ kɔ́rɔ́ dhu-tsí nʉ́gɛ̀rɛ̀ ròngò ɔwʉ́tána tɨ́ ɔ̀ná ɨdhɔ ɔ̀. Kàgàwà avɔ̀ wà ndɨ dhu angyangyɨ nyʉ́ pbɨ̀ndà ɨ̀lɨ̌lǎ pbànábí-otù ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Obhó tɨ́, Músà atɨ: ‹Ádrʉ̀ngbǎlɛ fʉ̀kʉ́ Kàgàwà níipfoya ɨma bhěyi atdí pbɨ̀ndà nabì fʉ̌kʉ̀ nzínzìkʉ ɔ̌ rɔ̀. Nɨ́ dhu akáya nyǒngò kà rʉ̌nɔna fʉ̌kʉ̀ kɔ́rɔ́ dhu nɨ́rɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɨ̀nzɨ̌ róngo ndɨ nabì rʉ̌nɔna dhu ɨ̀rɨ̀ alɛ-tsè nɔ́tdɨ̀ Kàgàwà rǒngo àdʉ̀ kɔ́rɔ́ pbɨ̀ndà alɛ nzínzì ɔ̌ rɔ̀.›» ");
INSERT INTO niy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pɛ́tɛrʉ̀ adʉ̀ dhu ìse átɔ̀ ihé-yà tɔ̀, ndàtɨ: «Kàgàwà bhà pbànábí kɔ́rɔ́, rɔ̀pɛ̀ ndɨ̀ Sàmɔlɛ̀ rɔ̌ rɔ̀, ràrà àhʉ dzina dɔ̌ uvò kɔ́rɔ́ ngʉ̌kpà pbànábí ɔ̀, náavɔ̀ dhu átɔ̀ ɨ ɨdhɔ ɔ̌ ɨ̀ nɔnzɨya dhu dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nyɨ̌ nɨ́ pbànábí tɔ́ inzo. Nɨ́ kɔ̌kɔ̀ pbɨ̀ndà pbànábí-otù ɔ̌ Kàgàwà anzɨ̀ làká nɨ́ kǎnzɨ̀ fʉ̌kʉ̀. Ndɨrɔ̀ nyɨ̌ nyùngbò wà nyɨ̌ Kàgàwà nà yà abhúkʉ mànà Kàgàwà mà núungbò ɨ̀ dhu-otù ɔ̌. Obhó tɨ́, Kàgàwà atɨ Àbràhamʉ̀ nɨ̌: ‹Pbʉ̀kʉ̀ pbàdzʉkʉrʉ-otù ɔ̌, ma masoya yà adzɨ ɔ̌ rʉ̀gànda-tsʉ̀ kɔ́rɔ́.› ");
INSERT INTO niy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ndɨ dhu bhěyi nɨ́ ndɨ Kàgàwà ívì pbɨ̀ndà ɨnɔ-akpà Yěsù Krɨ́stɔ̀ fʉ̌kʉ̀ wɛmbɛrɛ̀ tɨ́, ndɨ́nɨ̌ nyɨ̌ naso tɨ́ ndàbhʉ nyɨ̌ nyʉ̌gɛ̀rɛ̀ nyɨ̌ nyʉ̌bhà fʉ̀kʉ́ nzɛ́rɛnga.» ");
INSERT INTO niy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wɔ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà rɨ̌ dhu ɔ̀vɔ ihé-yà tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ pbàkùhánɨ́ mà, Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì tɔ́ ádrʉ̀ngbǎlɛ alɛ mà, Pbàsàdùkáyó mànà nʉ́ʉtɔ ɨ̀ ányɨ̀rɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nɨ́, abádhí-ɨdhɛ̀ nɨ́ɨka nzá ndɨ̀ wɔ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà rɨ̌ dhu ùdhě ihé-yà tɔ̀ Yěsù ɨngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu dɔ̌ rɔ̀. Ndɨ dhu rɨ̌tɛ̀na dhu nɨ́ ɨ̀kyɛ ʉ̀vʉ̌vɛ alɛ rǎdʉ̀ ɨ̀kyɛ dhu, ndɨrɔ̀ ʉ̀ngbɛ̌ ʉ̀vʉ̌vɛ kʉtdʉ̌ ɨ̀ alɛ rǎdʉ̀ ʉ̀ngbɛ ɔvɛ-bvʉ̀ rɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nɨ́, abádhí adʉ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà núso. Nɨ́ ɨnga rǎtɨ nɨ́dhunɨ̌, abádhí adʉ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà nʉ́lɨ imbi ɔ̀, ràrà àhʉ tsútsǎ nɨ́nganɨ́ nga ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pbɛ́tʉ̀, ihé-yà nzínzì ɔ̌ ábhɔ̌ alɛ nyʉ́, kɔ̌kɔ̀ ɔ́yɔ̌ ábhàlɨ̌ rǔdhěna ìndrǔ tɔ̀ dhu nɨ̀rɨ̀, náa’u Yěsù, ndɨ dhu ràdʉ̀ Yěsù ná’ù alɛ-bvʉ nábhʉ rìsě ndɨ̀, ràhʉ mbɛ̀mbɛ̀ imbò lʉfʉ̀ alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tsútsǎ nɨ́nganɨ́, Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà náandu ɨ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Abádhí náandu ɨ̀ atdíkpá pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà Anà mà, Kàyafà mà, Yùwanɨ̀ mà, Àlɨ̀sandʉrʉ̀ mà, ndɨrɔ̀ pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kámá-ɨdzà ɔ̌ bhà mànà. ");
INSERT INTO niy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nɨ́, kɔ̌kɔ̀ ɨ̀ nàndu alɛ náavì Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà kiwǔ nà nzínzìya ɔ̀, ’àdʉ̀ dhu ɔ̀pɛ̀ ’ɔ̀ngʉ̀ tsʉ̀yá. Abádhí atɨ: «Nyɨ̌ nyʉ́, nyɨ̌ nyɨ́gʉ̌ wɔ̀ òtsótsù alɛ àdhɨ bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌, ndɨrɔ̀ àdhɨ-ɔvɔ̀ rɔ̌?» ");
INSERT INTO niy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nɨ́, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nɨ́ɨrá Pɛ́tɛrʉ̀, ràdʉ̀ dhu àdu abádhí tɔ̀, ndàtɨ: «Nyɨ̌ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mànà tɨ́rɔ̀, ");
INSERT INTO niy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kɔ̀nɨ̌ indo nyɨ̌ nyɨ́ dhu ɔ̀ngʉ̀ tsʉ̀ká wɔ̀ òtsótsù alɛ rɔ̌ mǎ mɔ́nzɨ̀ ídzìnga mɨ̌gʉ̌ ka dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nyɨ̌ nyàkǎ nyʉ̌nɨ, nyɨ̌ kɔ́rɔ́ Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhà mànà dhu nɨ́, nyɨ̌ nyábhʉ Yěsù Krɨ́stɔ̀, Nàzàretì tɔ́ pbanga ɔ̌ alɛ, kʉtɔ̌ mʉ̀sàlabhà dɔ̌ dhu. Nɨ́, Kàgàwà ádʉ̀ wà kàbhʉ rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. Kɔ̌vɔ̀-okú dɔ̀ rɔ̀ nga nɨ́ ndɨ wɔ̀ alɛ ìdè ɔnzɨ̀kʉ́ ídzì rɔ̌ rɔ̀ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ndɨ Yěsù nɨ́ ndɨ Kàgàwà bhà Andítá nɔ́vɔ̀ dhu okúna dɔ̀ rɔ̀ ndàtɨ: ‹Yà nyɨ̌ nyabvù igi odu, nyɨ̌, ɨdza ɔ̀rʉ arɨ́ alɛ tɨ́rɔ̀, nɨ́ ndɨ òngò ɨdza-pbɨdɔ̀ nɔ́dɔ̀ rádʉ̀ odu tɨ́.› ");
INSERT INTO niy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ɔ̀gʉ̀ rǎdʉ̀ ndàbà kǒtù ɔ̌ tɨ́ atdírɔ̀, ɨ̀mbǎ ngǎtsi alɛ-ɔvɔ̀ rɨ̌’ɨ̀ yà adzɨ ɔ̌ atdí màtɨ́, yà Kàgàwà íbhò ndɨ́nɨ̌ ìndrǔ ʉgʉ̀ tɨ́ otùna ɔ̌ nɨ́dhunɨ̌.» ");
INSERT INTO niy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nɨ́ wɔ̀ dhu bhěyi Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà àdu dhu fɨ̌yɔ̀ ɨ̀mbǎ ɔ̀yá ɔdɔ́ na dhu náadʉ̀ Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ àbhʉ ɨdhɔ rʉ̀kɔ atdídɔ̌. Ndɨrɔ̀, abádhí asʉ̀ dhu Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà ràrɨ̌ ɨnzá ɨnga nʉ́nɨ ndɨrɔ̀ ɨnzá dhu nɔ́zʉ̀ alɛ. Ndɨrɔ̀ abádhí asʉ̀ dhu átɔ̀ Yěsù mànà arúbhi ùbhi rɔ̌ atdíkpá alɛ ràrɨ̌ ɨ. ");
INSERT INTO niy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pbɛ́tʉ̀, wɔ̀ ɔ̀gɔ̀gʉ̀ òtsótsù alɛ nálǎ ɨ̀ ɨ́ nzínzìya ɔ̌ ìdè rɔ́ rɔ̀, abádhí rʉ̌nɔna dhu náadʉ̀ àwǐ àwǐ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nɨ́, abádhí adʉ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà návi rùvò dhʉ̀wanɨ̌-dzà ɔ̀ rɔ̀, ’àdʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ nzínzìya ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Abádhí ambɛ́nà àtɨ̀nà dɔ̌ nzínzìya ɔ̌: «Àlɛ̌ kɨ́ kɔ̀rɨ́ alɛ ɔ̀nzɨ ɨ̀ngbà dhu bhěyi? Obhó tɨ́, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ bhà kɔ́rɔ́ nʉ́nɨ wà wɔ̀ abádhí ɔ̀nzɨ̀ wɨwɨ̀ mběyi nyʉ́. Nɨ́, àlɛ̌ kɨ́ nzɨ̌ àdʉ̀ ndɨ dhu àgò. ");
INSERT INTO niy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pbɛ́tʉ̀, dhu àkǎ nzá ndɨ dhu-ɔ̀yɨ̌ rʉ̀gà ndɨ̀ kɔ́rɔ́ alɛ nzínzì ɔ̌. Àlɛ̌ kàkǎ àlɛ̌ rɨ̀sɔ̌ abádhí ɨ̀nzɨ̌ Yěsù-ɔvɔ̀ natɨ tɨ́ tdɨ́tdɔ̌ atdí alɛ-bɨ̀ ɔ̌ màtɨ́.» ");
INSERT INTO niy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nɨ́ wɔ̀ dhu-dzidɔ̌, kɔ̌kɔ̀ ádrɔ̀drɔ̌ alɛ adʉ̀ Pɛ́tɛrʉ̀ mà návi rìtsù tdɨ́tdɔ̌ tɨya ɔ̀. Abádhí adʉ̀ dhu ɨ̀sɔ Pɛ́tɛrʉ̀ mà tɔ̀ ɨ̀nzɨ̌ Yěsù-ɔvɔ̀ natɨ tɨ́ akɛkpá màtɨ́, ndɨrɔ̀ ɨ̀nzɨ̌ dhu nudhè tɨ́ tdɨ́tdɔ̌ ìndrǔ tɔ̀ Yěsù-ɔvɔ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà náadʉ̀ dhu àdu abádhí tɔ̀, ’àtɨ: «Nyɔ̀tdɨ̀ pɛ́ yà anya nyɨ̌ nyʉ́ tɨ́rɔ̀. Ádhu Kàgàwà-nyɨ̀kpɔ́ nɔ̀fɔ̀: tɨ́ kɨrɨ̀ tsʉ̀kʉ́ dhu, ndɨrɔ̀, tɨ́ kɨrɨ̀ tsʉ̀ná dhu? ");
INSERT INTO niy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mǎ’ɨ́ na nɨ́ ndɨ, ɨ̀nzɨ̌ mǎ mádʉ̀ ɨwà mǎ màla dhu mà, ndɨrɔ̀ ɨwà mǎ mɨ̀rɨ̀ dhu mà nɔ́vɔ mǎ mɨ́ ìndrǔ tɔ̀ dhu nʉ́bhà.» ");
INSERT INTO niy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nɨ́, abádhí dɔ̌ ɨ̀ ɔ̀rʉ̀ tdɨ́tdɔ̌ dhu-dzidɔ̌, kɔ̌kɔ̀ Pbàyàhúdí tɔ́ ádrɔ̀drɔ̌-anya ɨ̀tdɨ̀ arɨ́ alɛ náadʉ̀ abádhí ʉ̀kɔlɔ ròwù. Ɨ ádrɔ̀drɔ̌ alɛ ala nzá abádhí dɔ̌ ɨ̀ ɨ́ anya ɔ̀tdɨ̀ okúna dɔ̀ rɔ̀ atdí dhu mà. Obhó tɨ́, kɔ́rɔ́ alɛ adʉ̀ òko ’àmbɛ Kàgàwà ìlè dɔ̌ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wɔ̀ ndɨ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà náanzɨ̀ wɨwɨ̀ rɔ̀ná ’ɨ̀gʉ̌ alɛ nɨ’ɨ̀ ɨwà pbɨ̀ndà atɔ ísě ndɨ̀ ròsè ɨ̀fɔ kumì atɔ dɔ̀nǎ alɛ. ");
INSERT INTO niy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ɨ̀ ka kʉ̀kɔlɔ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà náadʉ̀ òwu ɔdhɨ́ya rɨ̌’ɨ̀ ɨ, ’àdʉ̀ yà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mà, pbàkʉ̀rʉ̌ mànà nɔ́vɔ̀ fɨ̌yɔ̀ dhu náwɛ abádhí tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nɨ́ wɔ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀, kɔ̌kɔ̀ Yěsù ná’ù alɛ náadʉ̀ ’ɨ̀tsɔ̀ Kàgàwà rɔ̌, ’àtɨ: «Ɔ̀ɔ Ádrʉ̀ngbǎlɛ́, nyɨ nyanzɨ ndɨ ɔ̀rʉ̀-akpà mà, yà adzɨ mà, ádrɔ̀drɔ̌ rɛ̀rʉ̀-abábá mànà ɔ̀yá arɨ́’ɨ̀ kɔ́rɔ́ dhu mànà. ");
INSERT INTO niy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pbʉ̀kʉ̀ Ɨ̀lɨ̌lǎ-Alafí nɨ̌ nyɨ nyabhʉ̀ pbʉ̀kʉ̀ ɨnɔ-akpà, abhukà, ádrʉ̀ngbǎ kamà Dàwudì rɔ̀vɔ̀ dhu ìndrǔ tɔ̀. Kǎtɨ: ‹Ádhu wɔ̀ dhu bhěyi ɨnzá Kàgàwà nʉ́nɨ alɛ-tsì àva ndɨ̀ nɨ̌? Ndɨrɔ̀, ádhu ìndrǔ òko ’àmbɛ ɨ̀mbǎ tɨ̌ya nà dhu ùdhe dɔ̌ ndɨ́nɨ̌ ɨ̀ ɔnzɨ tɨ́ nɨ̌? ");
INSERT INTO niy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yà adzɨ ɔ̌ ádrɔ̀drɔ̌ alɛ nɔ́bhɔ̀lɔ̀ wà ɨ̀ ɨla t’úgyeta tɔ̀. Ndɨrɔ̀, kámá nádʉ̀ wà ’ɨ̀rɨ̀ atdíkpá, ndɨ́nɨ̌ ɨ̀ ugye tɨ́ ɨ̀ Ádrʉ̀ngbǎlɛ Kàgàwà nà, pbɨ̀ndà Màsiyà mànà.› ");
INSERT INTO niy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Obhó tɨ́, ádrʉ̀ngbǎ kamà Hɛ̀rɔdɛ̀ mà, lɨ̀walɨ̀ Pòtiyò Pìlatɔ̀ mà, ɨ̀nzɨ̌ nɨ́ Pbàyàhúdí mà, Ìsràyelì tɔ́ pbìrì ɔ̌ bhà mànà núndu wà ɨ̀ yàrɨ́ kɨgɔ̀ ɔ̌. Abádhí ùndu ɨ̀, ndɨ́nɨ̌ ɨ̀ ugye tɨ́ Yěsù, pbʉ̀kʉ̀ Ɨ̀lɨ̌lǎ ɨnɔ-akpà, yà nyɨ nyʉ́ nyɨ nyútri alɛ. ");
INSERT INTO niy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ndɨ dhu bhěyi nɨ́ ndɨ abádhí ɔ̀nzɨ̀ pbʉ̀kʉ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nɨ̌ yà nyɨ nyʉ́ nyɨ nyudhè ndɨrɔ̀ nyɨ nyazè rɔ̀nzɨ̀ ndɨ̀ angyangyi dhu. ");
INSERT INTO niy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nɨ́rɔ̀ kòmbí Ádrʉ̀ngbǎlɛ Kàgàwǎ, ándà pɛ́ kɔ̌kɔ̀ alɛ rǎpàna ’ɔ̀nzɨ̀ rɔ̀ká dhu. Ábhʉ̌ pbʉ̀kʉ̀ ɨnɔ ròwù pbʉ̀kʉ̀ ɔtɛ ɔ̀vɔ̀ rɔ̌ ìndrǔ tɔ̀ ɨ̀mbǎ ɔ̀yá ɔdɔ́ na. ");
INSERT INTO niy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɨ́gba ɔtsʉ́nʉ, ndɨ́nɨ̌ ìndrǔ nɨgʉ́ tɨ́, ràdʉ̀ wɨwɨ̀ mà, yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mànà nɔ́nzɨ̀ pbʉ̀kʉ̀ Ɨ̀lɨ̌lǎ ɨnɔ-akpà Yěsù-ɔvɔ̀ rɔ̌.» ");
INSERT INTO niy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nɨ́ Yěsù ná’ù kɔ̌kɔ̀ alɛ níitdègu ɨtsɔ̀ta nɨ́tɔ, nɨ́ yà abádhí ɨ̀’ɨ̀ ɨ̀ àndu ɨ̀ rɔ́ nga náadʉ̀ ndɔ̀pɛ̀ ndìvi, Kàgàwà ràdʉ̀ abádhí ɨ̀ra pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nɨ̌. Nɨ́, abádhí adʉ̀ ’ɔ̀pɛ̀ ’ʉ̀nɔ̀ Kàgàwà bhà Ɔtɛ ɨ̀mbǎ ɔ̀yá ɔdɔ́ na. ");
INSERT INTO niy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yěsù ná’ù alɛ nɨ́ɨ’ɨ̀ atdí alɛ bhěyi afíya mà, atdyúya mànà ɔ̀ rɔ̀. Atdí alɛ mà abádhí nzínzì ɔ̌ nóongónà nzɨ̌ fɔná dhu àtɨ̀ pbɨ̀ndà dhu nyʉ́ tɨ́. Pbɛ́tʉ̀, abádhí ongónà kɔ́rɔ́ fɔyá dhu nʉ́lɨ atdíkpá. ");
INSERT INTO niy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abádhí ongónà àdʉ̀ Ádrʉ̀ngbǎlɛ Yěsù ɨngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀ dhu tɔ́ màkʉ̌rʉ̀ nɔ́vɔ̀ ìndrǔ tɔ̀ ádrʉ̀ngbǎ ɔbɨ nyʉ́ nà. Ndɨrɔ̀ Kàgàwà ongónà àdʉ̀ abádhí àso kɔ́rɔ́ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dhu ɔ̀tdɨ̀ ndɨ̀ rɔ̀ná alɛ nɨ́ɨ’ɨ́nà mbǎ abádhí nzínzì ɔ̌ atdí màtɨ́. Obhó tɨ́, ɨnga nà alɛ mà kɔ́rɔ́, ɨdza nà alɛ mànà kɔ́rɔ́, nóongónà ɨ dhu-tsí núdzi, ’àdʉ̀ ìwu ɨ̀ òngyè fʉ̀rangà nà, ");
INSERT INTO niy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","’ùbho Yěsù bhà uvitatálɛ-fɔ́. Ɨ uvitatálɛ ongónà àdʉ̀ ndɨ fʉ̀rangà nʉ́ndɔ̀ kɔ́rɔ́ alɛ tɔ̀, ngǎtsi alɛ ràbà ka dzʉ̀nàna ɔ̀nzɨ̀ rádʉ̀ dhu-bvʉ̀tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ndɨ dhu bhěyi tɨ́, Yɔ̀zɛfʉ̀ tɨ́ kátɨna atdí Mʉ̀lawì nɨ́ɨ’ɨ̀ ɨnga nà. Ka nɨ’ɨ̀ Kìpurɔ̀ tɨ́ kátɨna pbìrì ɔ̀ ka kʉgʉ alɛ. Yěsù bhà uvitatálɛ ongónà àdʉ̀ kànzì átɔ̀ Bàrnabà tɨ́. Bàrnabà-tɨ̀ nɨ́ ìndrǔ-afí òpè arɨ́ alɛ. ");
INSERT INTO niy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nɨ́ kǎbhʉ̀ pbɨ̀ndà ɨnga kodzì, ndàdʉ̀ ɨ̀rà ndɨ fʉ̀rangà nà, ndɨ̀rà àbhʉ nà Yěsù bhà uvitatálɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pbɛ́tʉ̀, Ànànɨyà tɨ́ kátɨna alɛ mà nɨ́ɨrɨ ɨ̀ pbɨ̀ndà tsìbhálɛ Sàfirà nà ’àbhʉ fɨ̀yɔ́ ɨnga kodzì. ");
INSERT INTO niy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nɨ́, Ànànɨyà idyi ndɨ ɨnga ka kodzì rɔ̀ná fʉ̀rangà-rɔrɔ̀ fɨ̌ndà, ɨwà pbɨ̀ndà tsìbhálɛ ʉ̀nɨ átɔ̀ rɔ́rɔ̀. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ àrà ndɨ fʉ̀rangà-go àbhʉ Yěsù bhà uvitatálɛ-fɔ́. ");
INSERT INTO niy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nɨ́ Pɛ́tɛrʉ̀ ivú dhu Ànànɨyà-tsʉ̌, ndàtɨ: «Ànànɨyǎ, ádhu nyɨ nyàbhʉ pfɔ̀mvɔ Sìtanɨ̀ rɨ̀rǎ afínʉ nɨ̌? Nyɨ nyʉ̀trǎ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí, nyadʉ̀ ɨnga nyɨ nyàbhʉ kodzì rɔ̀ nyɨ nyàbà fʉ̀rangà-rɔrɔ̀ nídyì ɨndʉ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ɨnzá nyɨ nyàpɛ̀ ndɨ ɨnga àbhʉ̌ kodzì rɔ̀, ka nɨ̀’ɨ̀ t’óbhó pbʉ̀kʉ̀? Ndɨrɔ̀, ɨwà màtɨ́ nyɨ nyàbhʉ ka kodzì rɔ̀, nyɨ nyòngyè fʉ̀rangà nɨ̀’ɨ̀ t’óbhó pbʉ̀kʉ̀ kɛ̀lɛ̌? Nɨ́, ádhu nyʉ́ nyɨ nàbhʉ nyɔnzɨ̀ dhu wɔ̀ dhu bhěyi? Nyɨ nyʉ̀nɔ̀ nzá tɨ̀tɔ̀ ìndrǔ tɔ̀, pbɛ́tʉ̀ nyɨ nyʉ̀nɔ̀ ka Kàgàwà tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nɨ́ wɔ̀ Pɛ́tɛrʉ̀ ʉ̀nɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ́rɔ̀ tɨ́, Ànànɨyà nɨ́ɨtsɨ obvò, ndàdʉ̀ ɔ̀vɛ̀ dòtsí. Nɨ́ kɔ́rɔ́ alɛ, wɔ̀ Ànànɨyà rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu nɨ̀rɨ̀ ɔ̀ ɔdɔ ɨsɨ́ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wɔ̀ dhu-dzidɔ̌, kpabhínzo adʉ̀ ìwu, ’àkpɔ̀rɔ̀ Ànànɨyà-abvò-ngbɔ̀ mbɛrʉ̀ ɔ̀, ’àdʉ̀ òwu ɔ̀tdʉ̀nà. ");
INSERT INTO niy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mbɛ̀mbɛ̀ ɨ̀bhʉ adyifɔ̀-sɨsɨ̀ tɨ́ Ànànɨyà ɔ̀vɛ̀nà rɔ́ adyifɔ̀-sɨsɨ̀ ʉ̀dà rɔ́rɔ̀ nɨ́ ndɨ, kàbhà tsìbhálɛ, Sàfirà náatsù tdɨ́tdɔ̌ Pɛ́tɛrʉ̀ mà-tɨ’ɔ̀. Kʉ̌nɨ nzá pbɨ̀ndà alɛ rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nɨ́, Pɛ́tɛrʉ̀ ivú dhu kà-tsʉ̌, ndàtɨ: «Ʉ́nɔ pɛ́! Tɨ́ nyɨ̌ nyàbhʉ ɨnga kodzì rɔ̀ná fʉ̀rangà-bvʉ yà?» Nɨ́, Sàfirà adʉ̀ dhu àdu ndàtɨ: «Ɨ̀ɨ̀! Ka nɨ́ wɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nɨ́ Pɛ́tɛrʉ̀ adʉ̀ àtɨ̀nà Sàfirà nɨ̌: «Nyɨ̌ nyàdʉ̀ nyɨ̌rɨ̀ ɨ̀ngbà dhu bhěyi pbʉ̀kʉ̀ alɛ nà, nyǒwù Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nyʉ́ nʉ́tra? Ándà! Kɔ̀nɨ̌ pbʉ̀kʉ̀ alɛ ɔ̀tdʉ̀ òwù kpabhínzo rǐtsù kɔ̀kɔ̀ dɔ̌. Nɨ́, abádhí rɨ̌ abvònʉ ìtdu átɔ̀, ’òwù ɔ̀tdʉ̀nà.» ");
INSERT INTO niy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ʉrɔ́ rɔ̀ tɨ́, Sàfirà nɨ́ɨtsɨ gbùù obvò Pɛ́tɛrʉ̀-ɔ̀nzɨ̌, ndàdʉ̀ ɔ̀vɛ̀ dòtsí. Nɨ́, ɨdza ɨ̀ ìtsù rɔ̀, kpabhínzo adʉ̀ Sàfirà òtù ɨwà ɔ̀vɛ̀ rɔ́, ’àdʉ̀ kǎ-bvò ìtdù, ’òwù ɔ̀tdʉ̀nà átɔ̀ yà kàbhà alɛ ɨ̀ ɔ̀tdʉ̀nà rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nɨ́, ɔdɔ nɨ́ɨsɨ́ atdídɔ̌ kànɨsà ɔ̀, wɔ̀ Ànànɨyà mà Sàfirà nà rɔ̌ ndɨ̀ nɔ̀nzɨ̀ dhu ɨ̀ ɨ̀rɨ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yěsù bhà uvitatálɛ náanzɨ̀ ábhɔ̌ wɨwɨ̀ mà, yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ ábhɔ̌ dhu mànà ìndrǔ nzínzì ɔ̌. Ndɨrɔ̀, Yěsù ná’ù alɛ kɔ́rɔ́ nóongónà ’àndu bìlǐnganà. Abádhí ongónà òko atdíkpá «Ádrʉ̀ngbǎ kamà Sɔ̀lɔ̀mɔnɨ̀ bhà mbàrazà» tɨ́ kátɨna mbàrazà-tsìnǎ. ");
INSERT INTO niy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ndɨrɔ̀, yà ɨnzá Yěsù ná’ù alɛ nzínzì ɔ̌, atdí alɛ mà nóongónà nzɨ̌ ndòmvù ndàngbò ndɨ̀ abádhí nzínzì ɔ̀. Pbɛ́tʉ̀, ìndrǔ ongónà àdʉ̀ àmbɛ Yěsù ná’ù alɛ ìlè dɔ̌ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ábhɔ̌ kpabhálɛ mà vèbhálɛ mànà nóowúnà Ádrʉ̀ngbǎlɛ Yěsù à’ù rɔ̌, ndɨ dhu ràdʉ̀ àrà ka ná’ù alɛ-bvʉ àbhʉ rɔ̌ rìsě ndɨ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nɨ́, ìndrǔ nóowúnà andɨ nà alɛ nʉ́mbà rɔ̌ ’ìwǔ nà ngʉdhà ɔ̀. Abádhí owúnà ɨ alɛ nʉ́lɨ rɔ̌ ròyì fɨ̀yɔ́ ara mà fɨ̀yɔ́ ótdù mànà dɔ̌, ndɨ́nɨ̌ Pɛ́tɛrʉ̀ rʉ̌da ányɨ̀rɔ̌ ɔ̀ná kàsʉmɨ̀ ɔ̌, àbadhi-sɨsɨ̀ nyʉ́ mà náara tɨ́ ndìbvu rɔ̌ atdí alɛ dɔ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ábhɔ̌ alɛ nyʉ́ nóowúnà ìwu rɔ̌ andɨ nà alɛ nà, nzɛ́rɛ-alafí náarávu rɔ̀yá alɛ mànà yà kyɛ̀rɔ̀kyɛ̀rɔ̀ rɨ́’ɨ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀-tɨ́ pbanga ɔ̀nǎ rɔ̀. Nɨ́ ɨ alɛ owúnà ʉ̀gʉ rɔ̌ kɔ́rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wɔ̀ dhu-dzidɔ̌, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà, yà ɨ̀ ɨ̀’ɨ̀ mànà atdíkpá Pbàsàdùkáyó tɔ́ mʉ̀tʉ̀ nzínzì ɔ̌ alɛ mànà, náambɛ́nà Yěsù bhà uvitatálɛ rɔ̌nzɨna dhu-adhà ɔ̀nzɨ̀ dɔ̌ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nɨ́ abádhí adʉ̀ Yěsù bhà uvitatálɛ àbhʉ kusǒ, kʉdɔ kɔ́rɔ́ alɛ tɔ́ imbi-dzà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pbɛ́tʉ̀ kúbhingá nǎ, Ádrʉ̀ngbǎlɛ Kàgàwà bhà atdí màlàyikà náadʉ̀ ɨ̀rà imbi-dzà-tsʉ̀ núpfò, ndàdʉ̀ Yěsù bhà uvitatálɛ àbhʉ rùvò iri. Ndɨrɔ̀, ndɨ màlàyikà adʉ̀ àtɨ̀nà abádhí nɨ̌: ");
INSERT INTO niy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Nyòwu nyǐkò Kàgàwà bhà ɨdzá, nyǎdʉ̀ ípìrɔ̌nga-ɔwʉ́tá dɔ̌ rɔ́tɛ kɔ́rɔ́ màkʉ̌rʉ̀ nɔ́vɔ̀ ìndrǔ tɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nɨ́, Yěsù bhà uvitatálɛ adʉ̀ ’ɨ̀và bhɔ̀tsʉngá nyʉ́, ’òwù Kàgàwà bhà ɨdza ɔ̀, ’àdʉ̀ ’ɔ̀pɛ̀ ùdhe dhu ìndrǔ tɔ̀. Pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà mà, yà ɨ̀ ɨ̀’ɨ̀ mànà atdíkpá alɛ mànà níwǔ ùvò rɔ̀, abádhí adʉ̀ Pbàyàhúdí-bvʉ̌ ádrɔ̀drɔ̌-anya ɨ̀tdɨ̌ arɨ́ pbàkʉ̀rʉ̌-tsʉ̀ àndu. Ndɨrɔ̀, abádhí adʉ̀ sàndǐrì àvi ròwù Yěsù bhà uvitatálɛ ùgù, ’ìwǔ nà imbi ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nɨ́ imbi-dzà ɔ̀ ɨ̀ ìwǔ ùvò rɔ̀, kɔ̌kɔ̀ sàndǐrì adʉ̀ nzá ɨ uvitatálɛ òtù abádhí ka kʉ́dɔ ɔ̀nà kàluga ɔ̀. Nɨ́ abádhí adʉ̀ ’àdu anya t’ɨ́tdɨ̀ta t’álɛ-tɨ’ɔ̀, ’àdʉ̀ dhu ɔ̀vɔ̀ fɨ̌yɔ̀, ’àtɨ: ");
INSERT INTO niy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Mǎ mòwù ùvò imbi-dzà-li’ɔ̀, nɨ́ mǎ mòtù ndɨ imbi-dzà-tsʉ̀ mběyi nyʉ́ ka kùpbǐ rɔ́. Ndɨrɔ̀, sàndǐrì nɨ́’ɨ̀ ìnè fɨ̀yɔ́ ngari ɔ̌ tɨ́ ɨ̀ ìkò rɔ́. Pbɛ́tʉ̀, mǎ mìtdègu tsǎtsʉ̀ ùpfo, nɨ́ mǎ màdʉ̀ nzá atdí alɛ mà nótù kàluga ɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nɨ́ wɔ̀ Kàgàwà bhà ɨdza-ngbɔ̀ ɔ̀dɔ arɨ́ sàndǐrì tɔ́ ádrʉ̀ngbǎlɛ mà, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ mànà níitdègu wɔ̀ dhu ɨ̀rɨ, nɨ́ abádhí-dɔ ɔ̀ nga adʉ̀ ìkǔ tɨ́ ìku. Nɨ́ abádhí adʉ̀ ’ɔ̀pɛ̀ ’ɔ̀ngʉ̀ dhu tsʉ̀yá nzínzìya ɔ̌, ’àmbɛ àtɨ̀nà dɔ̌: «Ádhu nyʉ́ wɔ̀ ndɨ̀ nɔ̀nzɨ̀ kɔ̌kɔ̀ alɛ-rɔ̌?» ");
INSERT INTO niy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɨ́rɔ̀ nɨ́ ndɨ atdí alɛ ɨtɔ ndɨ̀, ndìtsì àtɨ̀nà kɔ̌kɔ̀ ádrɔ̀drɔ̌ alɛ nɨ̌: «Nyɨ̀rɨ dhu! Kɔ̌kɔ̀ nyɨ̌ nyábhʉ kusǒ, kʉdɔ imbi ɔ̀ alɛ rɨ̌’ɨ̀ Kàgàwà bhà ɨdzá ɨ̀ ìkò, ’àmbɛ dhu ùdhe dɔ̌ ìndrǔ tɔ̀ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nɨ́, sàndǐrì tɔ́ ádrʉ̀ngbǎlɛ mà, rɔ̀ná ngʉ̌kpà sàndǐrì mànà náawù Kàgàwà bhà ɨdza, ndɨ́nɨ̌ ɨ̀ ugu tɨ́ Yěsù bhà uvitatálɛ ’ìwǔ nà anya t’ɨ́tdɨ̀ta t’álɛ-ɔ̀nzɨ̌. Pbɛ́tʉ̀, abádhí nʉ́ʉlʉ́ nzá ɨ uvitatálɛ ɔbɨ nɨ̌ ìwǔ nà, ìndrǔ rǎdʉ̀ ’ùbvu odu nɨ̌ dhu-ɔdɔ̀ ɔ̀nzɨ ɨ̀ ’ɨ́ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wɔ̀ dhu-dzidɔ̌, sàndǐrì abhʉ̀ Yěsù bhà uvitatálɛ rìwǔ ùvò ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ-ɔ̀nzɨ̌. Nɨ́, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà náadʉ̀ ndɔ̀pɛ̀ ndɔ̀ngʉ̀ dhu abádhí-tsʉ̌, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Mǎ mɨ́sɔ̌ wà nyɨ̌ ɨ̀nzɨ̌ nyɨ̌ nyowu tɨ́ dhu ùdhe rɔ̌ wɔ̀ alɛ-ɔvɔ̀ rɔ̌. Nɨ́, nyàndà pɛ́ nyɨ̌ nyɔ́nzɨ̀ dhu: Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ bhà núlè wà ùlè tɨ́ fɨ̌yɔ̀ nyɨ̌ nyúdhěna wɔ̀ alɛ dɔ̌ dhu nɨ̌. Ndɨrɔ̀ nyɨ̌ nyòzè nyǐfo wɔ̀ alɛ-azù dɔ̀ká átɔ̀!» ");
INSERT INTO niy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nɨ́ Pɛ́tɛrʉ̀ mà ngʉ̌kpà uvitatálɛ mànà náadʉ̀ dhu àdu kà tɔ̀, ’àtɨ: «Àkǎkǎ dhu tɨ́ kɨfʉ Kàgàwà ʉ̀nɔ̀ dhu, ndɨrɔ̀ tɨ́ kɨfʉ ìndrǔ ʉ̀nɔ̀ dhu? ");
INSERT INTO niy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nyɨ̌ nɨ́ ndɨ nyɨ̌ nyabhʉ̀ Yěsù kʉtɔ̌ mʉ̀sàlabhà dɔ̌ rɔ̀vɛ̀, kadʉ̀ ɔ̀tdʉ̀nà. Pbɛ́tʉ̀, abhúka tɔ́ Kàgàwà nábhʉ wà ka rɨ̀ngbɛ̀ ndɨ̀ ɔvɛ-bvʉ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ndɨrɔ̀, Kàgàwà ábhʉ wà ka rɔ̀dzɨ̀ ɔ̀rʉ̀-akpà ɔ̀, ndàdʉ̀ àbhʉnà ràdɨ fɨ̀ndá fangà dɔ̀nǎ rɔ̀. Kǎbhʉ ka ràdɨ Kamà tɨ́ ndɨrɔ̀ Ɔ̀gʉ̀ba tɨ́, ndɨ́nɨ̌ otu nabhʉ̀ tɨ́ Pbàìsràyélí tɔ̀ rʉ̀gɛ̀rɛ̀ ɨ̀, ’ʉ̀bhà fɨ̀yɔ́ nzɛ́rɛnga, ràdʉ̀ ʉbàta tɔ́ otu àbà. ");
INSERT INTO niy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mǎ nɨ́ ɨ ɨ̀ nɔ́nzɨ̀ dhu tɔ́ ngàmbì. Ndɨrɔ̀, Kàgàwà ʉ̀nɔ̀ dhu ɨ̀fʉ̌ arɨ́ alɛ nɨ́rǎ kǎrɨ́ nɨ̌ pbɨ̀ndà Ɨ̀lɨ̌lǎ-Alafí nɨ́ ɨ dhu tɔ́ ngàmbì átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nɨ́ wɔ̀rɨ́ ɔtɛ ɨ̀ ɨ̀rɨ̀ rɔ̀, ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ náakó atdídɔ̌, ’àdʉ̀ dhu òzè ndɨ́nɨ̌ ɨ̀ abhʉ̀ tɨ́ Yěsù bhà uvitatálɛ kɔkyɛ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pbɛ́tʉ̀, abádhí nzínzì ɔ̌ Gàmàlìyelì tɨ́ kátɨna atdí Mʉ̀fàrìsayò nɨ́ɨ’ɨ̀ ìnè. Ndɨ alɛ nɨ’ɨ̀ Músà bhà Ʉyátá tɔ́ màlimò, ndɨrɔ̀ ka nɨ’ɨ̀ atdídɔ̌ kɔ́rɔ́ alɛ arɨ́fʉ̌na alɛ. Nɨ́, kɨ̌và ndɨ̀ ndìdè ɔrʉ́ ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ nzínzì ɔ̌, ndàdʉ̀ Yěsù bhà uvitatálɛ àvi kipfo iri ákɛ̌ kàsʉmɨ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nɨ́ kɔ̌kɔ̀ uvitatálɛ ùvò iri dhu-dzidɔ̌, kǎdʉ̀ dhu ɔ̀vɔ̀ ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ tɔ̀, ndàtɨ: «Nyɨ̌ Pbàìsràyélí tɔ́ pbìrì ɔ̌ bhǎ, nyàndà nga mběyi kɔ̌kɔ̀ alɛ rɔ̌ nyɨ̌ nyápàna nyɔ̌nzɨ̀ dhu nà. ");
INSERT INTO niy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kɔ̀nɨ̌, tdèku tɨ́ Tèwudhà nɨ́và ndɨ̀, ndàrà ndàtɨ̀ rɔ̌ ádrʉ̀ngbǎlɛ tɨ́, mbɛ̀mbɛ̀ ɨ̀fɔ mɨyà alɛ ràdʉ̀ ’ɔ̀dhɔ̀ owùna ɔ̌. Nɨ́ ka kóhò ka, yà kà-tsʉ̌ dhu ná’ù alɛ ràdʉ̀ ’ɨ̀fàlà, wɔ̀ abádhí ɨ́tsɔ̌ dhu ràdʉ̀ ɨ̀nɛ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tèwudhà-dzidɔ̌, Gàlìlayà tɔ́ pbìrì ɔ̌ atdí alɛ, Yudhà tɨ́ kátɨna nɨ́và ndɨ̀ ndɨ dhu bhěyi tɨ́ yà ìndrǔ ɔ̀zʉ̀ ka kɨ́ ɔ̀ná kàsʉmɨ̀ ɔ̌, ihé-yà ràdʉ̀ ’ɔ̀dhɔ̀ owùna ɔ̌. Pbɛ́tʉ̀, ka kòhò ka rɔ̀, yà kà-tsʉ̌ dhu ná’ù alɛ nádʉ̀ ’ɨ̀fàlà átɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nɨ́ kòmbí ma mátɨna nyɨ̌ nɨ̌: ‹Nyùvò kɔ̌kɔ̀ alɛ tɔ́ dhu ɔ̀ rɔ̀. Nyʉ̀bhà abádhí ròwù. Wɔ̀ abádhí ùdhe ɨ̀ ɔnzɨ tɨ́ dhu mà, wɔ̀ abádhí rɔ̌nzɨna dhu mànà nɨ́ɨ’ɨna gukyè ìndrǔ ɔ̀ rɔ̀ àhʉ dhu tɨ́, nɨ́ ɨ dhu rɨ̌nɛ̀ ɨ̀tɨ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pbɛ́tʉ̀, ɨ dhu apɛ́ ɨ̀’ɨ̀ Kàgàwà nyʉ́ ùdhě ndɨ̀ ndɔnzɨ tɨ́ dhu tɨ́, nɨ́ nyɨ̌ nyɨ́ nzɨ̌ ɨ dhu àbhʉ̌ rɨ̀nɛ̀. Nyàndà nga mběyi! Akyɛ nyɨ̌ nyowuna nyǒtù Kàgàwà nà nyɨ̌ nyɨ́ nyǔgye rɔ́.›» Nɨ́ kɔ̌kɔ̀ ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ náadʉ̀ wɔ̀ Gàmàlìyelì ɔ̀vɔ̀ fɨ̌yɔ̀ dhu ɨ̀rɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Abádhí adʉ̀ uvitatálɛ àvi rìtsù tɨya ɔ̀. Nɨ́ ɨdza abádhí ìtsù rɔ̀, ɨ ádrɔ̀drɔ̌ alɛ adʉ̀ abádhí àbhʉ kʉvɨ, ’àdʉ̀ dhu ɨ̀sɔ fɨ̌yɔ̀ ɨ̀nzɨ̌ Yěsù-ɔvɔ̀ natɨ tɨ́ tdɨ́tdɔ̌ ìndrǔ nzínzì ɔ̌. Wɔ̀ dhu-dzidɔ̌, ɨ alɛ adʉ̀ abádhí ʉ̀kɔlɔ, ròwù. ");
INSERT INTO niy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nɨ́ Yěsù bhà uvitatálɛ uvò kɔ̀rɨ́ alɛ-ɔ̀nzɨ̌ rɔ̀ dhɛ̀dhɛ nyʉ́ nà, ɨ̀ ka kɔ̀zʉ̀ ɨwà àkǎ ’àbà àpbɛ̀ Yěsù-ɔvɔ̀-okú dɔ̀ rɔ̀ alɛ tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ndɨrɔ̀, Kàgàwà bhà ɨdza ɔ̌ màtɨ́, ɨdzàya ɔ̀nǎ màtɨ́, abádhí ʉbhà nzá kɔ́rɔ́ ɨdhɔ ɔ̌ ɨ̀ ’ɨ́ dhu ùdhě ìndrǔ tɔ̀ dhu. Ndɨrɔ̀ abádhí ʉbhà nzá Yěsù ràrɨ̌ Màsiyà dhu tɔ́ Ídzì Màkʉ̌rʉ̀ nɔ́vɔ ɨ̀ ’ɨ́ ìndrǔ tɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kɔ̌kɔ̀ ɨ ɨdhɔ ɔ̌, Yěsù bhà ábhàlɨ̌-bvʉ náadɨ̀ ndàrà ndìse rɔ̌. Nɨ́ yà Pbàgìríkí t’ávàna ɔ̀tɛ arɨ́ Pbàyàhúdí náadʉ̀ ’ɔ̀pɛ̀ ’ònù yà ávàya nyʉ́ nɔ́tɛ arɨ́ Pbàyàhúdí nɨ̌, fɨ̀yɔ́ abvo-ayí rǒwu ùdzǒ tɨ́ ùdzo rɔ̌ bìlǐnganà ɔ̀nyʉ̀ ʉ̀ndɔ ka kɨ́ ìndrǔ tɔ̀ ɔ̀ná kàsʉmɨ̀ ɔ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nɨ́, atdí kumì dɔ̀ná ɔ́yɔ̌ nà Yěsù bhà uvitatálɛ náandu Yěsù bhà ábhàlɨ̌-tsʉ̀ kɔ́rɔ́, ’àdʉ̀ àtɨ̀nà nɨ̌: «Ɨnzá dhu àkǎ àlɛ̌ rʉ̀bhà Kàgàwà bhà Ɔtɛ ʉ̀nɔ àlɛ̌ kɨ́ ìndrǔ tɔ̀ dhu ɔ̀nyʉ̀-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nɨ́rɔ̀ àbanɨ̌nzó, dhu àkǎ nyǒvò àrʉ̀bhʉ̀ alɛ nzínzìkʉ ɔ̌, ndɨ́nɨ̌ mǎ madʉ̀ tɨ́ ndɨ kasʉ àbhʉ fɔyá. Ɨ alɛ àkǎ ɨ̀’ɨ̀ ídzì mʉ̀tsɔ nà alɛ tɨ́, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ɨ́rǎ alɛ tɨ́, ndɨrɔ̀ dhu-ɔ̌nga t’óvòta nʉ́nɨ alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ndɨ dhu bhěyi nɨ́ ndɨ kàsʉ̌ka nádʉ̀ ɨ̀’ɨ̀ ìndrǔ dɔ̌ mǎ mɨ́ mɨ̌tsɔ̀ dhu mà, Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ ʉ̀nɔ mǎ mɨ́ ìndrǔ tɔ̀ dhu mànà dhu kɛ̀lɛ̌.» ");
INSERT INTO niy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nɨ́, wɔ̀ dhu adʉ̀ Yěsù bhà ábhàlɨ̌-nyɨ̀kpɔ́ nɔ́fɔ̀ kɔ́rɔ́. Nɨ́, abádhí avò Stɨ̀fanʉ̀ ádrʉ̀ngbǎ a’uta nà alɛ, ndɨrɔ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ɨ́rǎ alɛ mà, Fìlipò mà, Pɔ̀rɔ̀kɔrɔ̀ mà, Nɨ̀kànɔrà mà, Tìmonì mà, Pàràmɨnà mà, Nɨ̀kʉ̀la mànà. Nɨ̀kʉ̀la nɨ’ɨ̀ Àtìyòkiyà tɔ́ kɨgɔ̀ ɔ̌ alɛ, yà Pbàyàhúdí tɔ́ sɔmà ɔ̀ ndɨ̀ nʉ́gɛ̀rɛ̀ alɛ. ");
INSERT INTO niy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wɔ̀ dhu-dzidɔ̌, abádhí adʉ̀ kɔ̌kɔ̀ ɨ̀ òvò alɛ nɨ́tɛ̀ Yěsù bhà uvitatálɛ tɔ̀. Nɨ́rɔ̀ nɨ́ ndɨ Yěsù bhà uvitatálɛ adʉ̀ ’ɨ̀tsɔ̀ ɔtsʉ́ya ɨ̀ ʉ̀lɨ abádhí dɔ̀-tsírɔ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Kàgàwà bhà Ɔtɛ adʉ̀ ndànga atdídɔ̌ ìndrǔ nzínzì ɔ̌. Ndɨrɔ̀, Yěsù bhà ábhàlɨ̌-bvʉ náadʉ̀ àdɨ ndàrà ndìse rɔ̌ atdídɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌, ibí pbàkùhánɨ́ mà ràdʉ̀ Yěsù ná’ù átɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kàgàwà nɨ́ɨrá Stɨ̀fanʉ̀ pbɨ̀ndà ídzìnga mà, pbɨ̀ndà ádrʉ̀ngbǎnga tɔ́ ɔbɨ mànà nɨ̌. Nɨ́, kǎránà yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mà, wɨwɨ̀-abábá mànà nɔ́nzɨ̀ rɔ̌ ìndrǔ nzínzì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nɨ́ ngúfe alɛ, yà «Ɨnɔ-kàsʉ̌ ɔ̌ rɔ̀ ka kʉ́kɔlɔ alɛ» tɨ́ kátɨna unduta-dzà ɔ̌ alɛ nzínzì ɔ̌, náadʉ̀ ’ɔ̀pɛ̀ ’àgò ɨ̀ kà nà. Ɨ alɛ nɨ’ɨ̀ Kùrenì tɔ́ kɨgɔ̀ ɔ̌ Pbàyàhúdí, Àlɨ̀sàndùriyà tɔ́ kɨgɔ̀ ɔ̌ Pbàyàhúdí, Kìlìkiyà tɔ́ kɨgɔ̀ ɔ̌ Pbàyàhúdí, ndɨrɔ̀ Àziyà tɔ́ mʉ̀lɛngʉ̀ ɔ̌ Pbàyàhúdí. ");
INSERT INTO niy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pbɛ́tʉ̀, abádhí anzɨ̀ nzá Stɨ̀fanʉ̀ lɛ̀mà, kɨ̌’ɨ̀ dhu-ɔ̌nga t’óvòta tɔ́ màgězì nà, ndɨrɔ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ambɛ́nà kʉ̀ndà dɔ̌ kà rɔ̌tɛ rɔ̀ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nɨ́rɔ̀ nɨ́ ndɨ abádhí adʉ̀ ìndrǔ nódzì fʉ̀rangà rɔ̌ ndɨ́nɨ̌ ɨ alɛ ɔvɔ tɨ́ dhu ’àtɨ: «Mǎ mɨ́rɨ̀ wɔ̀ alɛ nzɛ́rɛ nyʉ́ rɨ́ dhu ʉ̀nɔ Músà nɨ̌ ndɨrɔ̀ Kàgàwà nɨ̌ rɔ́.» ");
INSERT INTO niy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Abádhí adʉ̀ dhu ìtsu ihé-yà mà, pbàkʉ̀rʉ̌ mà, Músà bhà Ʉyátá tɔ́ màlímó mànà-dɔ ɔ̀, ndɨ́nɨ̌ dhu nɨvà tɨ́ Stɨ̀fanʉ̀ rɔ̌. Nɨ́rɔ̀ nɨ́ ndɨ abádhí alʉ́ ka ’òsò, ’àdʉ̀ òwu nà, ’òwù ùvò nà ádrɔ̀drɔ̌ anya ɨ̀tdɨ̀ arɨ́ alɛ-ɔ̀nzɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Abádhí adʉ̀ òwu tɨ̀tɔ̀ dɔ̌ rɨ́ Stɨ̀fanʉ̀ ɔ̀bhʉ alɛ nà átɔ̀ ányɨ̀, ndɨ́nɨ̌ ka nɔbhʉ tɨ́ ’àtɨ: «Ɨ̀nzɨ̌ ndɨ̀ ndɨ́ ndɨ̀ngyɛ̌ rɔ́rɔ̀, wɔ̀ alɛ náarɨ́ dhu ʉ̀nɔ nzɛ́rɛ nyʉ́ àlɛ̌ tɔ́ Kàgàwà bhà ɨ̀lɨ̌lǎ ɨdza nɨ̌, ndɨrɔ̀ Músà bhà Ʉyátá nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mǎ mɨ́rɨ̀ wà ka ɨ̀tɨ́ rátɨna: Yěsù, Nàzàretì tɔ́ kɨgɔ̀ ɔ̌ alɛ ràrɨ̌ Kàgàwà bhà ɨdza núgòlǒ, ndàdʉ̀ yà Músà ʉbhà àlɛ̌ tɔ̀ àlɛ̌ tɔ́ màndʉ nʉ́gɛrɛ.» ");
INSERT INTO niy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nɨ́, wɔ̀ anya t’ɨ́tdɨ̀ta-ɨdzà ɔ̌ ɨ̀’ɨ̀ alɛ kɔ́rɔ́ nʉ́ʉdɨ́ nyɨ̀kpɔ́ya Stɨ̀fanʉ̀ rɔ̌, ’àdʉ̀ kà-nyɨ̀ àla Kàgàwà bhà màlàyikà-nyɨ̀ bhěyi rólo rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wɔ̀ dhu-dzidɔ̌, pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà níivú dhu Stɨ̀fanʉ̀-tsʉ̌, ndàtɨ: «Wɔ̀ dʉ̀nʉ́ ka kʉ̀nɔ̀ dhu tɨ́ obhó dhu?» ");
INSERT INTO niy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nɨ́ Stɨ̀fanʉ̀ adʉ̀ ɔtɛ ɔ̀pɛ̀, ndàtɨ: «Abádǔ ndɨrɔ̀ adɔ́dǔ, nyɨ̀rɨ yà ma mʉ́nɔna fʉ̌kʉ̀ dhu. Ádrʉ̀ngbǎnga tɔ́ awáwʉ̀ nà arɨ́’ɨ̀ Kàgàwà náavì ndɨ̀ àlɛ̌ t’ábhunà Àbràhamʉ̀ tɔ̀ Mɛ̀zɔ̀pɔ̀tàmiyà tɔ́ pbìrì ɔ̀ kà rɨ̌’ɨ̀ rɔ́rɔ̀, tdʉ̌ kǎra àdɨ Hàranɨ̀ tɔ́ pbìrì ɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nɨ́, kǎtɨ Àbràhamʉ̀ nɨ̌: ‹Ɨ́và nyɨ fʉ̀kʉ́ pbìrì ɔ̌ rɔ̀, ndɨrɔ̀ fʉ̌-dzá-bhà nzínzì ɔ̌ rɔ̀, nyarà yà ɨndʉ̀ ma mɨ́tɛ̀na pbìrì ɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nɨ́ Àbràhamʉ̀ ɨvà ndɨ̀ Kàlɨ̀dɛyà tɨ́ kátɨna pbìrì ɔ̌ rɔ̀, ndàrà àdɨ Hàranɨ̀. Àbràhamʉ̀ t’ábanà ɔ́vɛ̀ dhu-dzidɔ̌, Kàgàwà adʉ̀ Àbràhamʉ̀ àbhʉ rɨ̀và ndɨ̀ Hàranɨ̀ rɔ̀, ràrà àdɨ yà kòmbí nyɨ̌ nyɨ́’ɨ̀ ɔ̀ná pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nɨ́ ndɨ pbìrì ɔ̌, kǎbhʉ̀ nzá atdí adzɨ mà, ndɨrɔ̀ pfɔ̌na-owù kɨ̀lɨ rɔ́nga bvʉ̀tɨ́ ngarí-ngba mà kà tɔ̀. Pbɛ́tʉ̀, kǎkɔ̀ wà làká Àbràhamʉ̀ tɔ̀ ndàtɨ, àbhʉ̌ ndɨ̀ rabhʉ̀ya ndɨ pbìrì kà tɔ̀ pbɨ̀ndà pbàdzʉkʉrʉ mànà. Kʉ̌nɔ wɔ̀ dhu ɨ̀mbǎ Àbràhamʉ̀ arɨ́’ɨ̀ atdí ngbángba nà màtɨ́ rɔ́rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kàgàwà atɨ yà dhu bhěyi: ‹Pbʉ̀kʉ̀ pbàdzʉkʉrʉ nóowuya òko ngʉ̌kpà alɛ tɔ́ pbìrì ɔ̀. Ányɨ̀, ka kabhʉ̀ya abádhí ròngò ɨnɔ tɨ́, kadʉ̀ àvu rɔ̀yá, ràrà àhʉ ɨ̀fɔ mɨyà atɔ tɨ́.› ");
INSERT INTO niy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kàgàwà atɨ átɔ̀: ‹Ma mɨtdɨ̀ya ndɨ anya nyǎbhʉ̌ ɔ̀yá alɛ rɨ̌ nyǒngò ɨnɔ tɨ́ pbìrì ɔ̌ alɛ-dɔ̌. Ndɨ dhu-dzidɔ̌ nɨ́ ndɨ, ma mabhʉ̀ya abádhí rùvò ndɨ pbìrì ɔ̌ rɔ̀, rìwǔ òko, ’òngò ɨma nʉ́lɛ yàrɨ́ ngari ɔ̌ rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wɔ̀ dhu-dzidɔ̌, Kàgàwà adʉ̀ kpabhínzo-ɔ̀nzɨ̌nga ɔ̀bhɔlɔ ka kɨ́ dhu nɨ́dɨ̀ ize tɨ́ ndɨ́nɨ̌ Àbràhamʉ̀ mànà ɨ̀ ùngbò ɨ̀ dhu nɨtɛ̀ tɨ́. Ndɨ dhu bhěyi nɨ́ ndɨ, Ìsakà ka kʉ̀gʉ̀ rɔ̀, Àbràhamʉ̀ abhʉ̀ kɔ̀nzɨ̌nga kɔbhɔ̀lɔ̀ àrʉ̀ rɨ́ ɨdhɔ ìsě ɨdhɔ ɔ̌. Ìsakà anzɨ̀ dhu ndɨ dhu bhěyi tɨ́ idhùnà Yàkɔbhɔ̀-rɔ̌, Yàkɔbhɔ̀ ràdʉ̀ kɔ̀nzɨ̀ ndɨ dhu bhěyi tɨ́ atdí kumì dɔ̀ná ɔ́yɔ̌ nà idhúna, àlɛ̌ t’ábhúna-nzɨ̀nzɨ̀ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Adɔ̀yà Yɔ̀zɛfʉ̀-adhà ɔ̀nzɨ ɨ̀ arɨ́ dhu-okú dɔ̀ rɔ̀, ɨ àlɛ̌ t’ábhúna-nzɨ̀nzɨ̀ náabhʉ̀ ka Mísrì tɔ́ pbìrì ɔ̌ bhà ròdzì. Pbɛ́tʉ̀, Kàgàwà ɨ’ɨ̀ ìnè atdíkpá kà nà. ");
INSERT INTO niy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nɨ́, kǎdʉ̀ kàbhʉ ràrà ʉ̀da rɔ̌ ndɨ̀ ndábàna kɔ́rɔ́ àpbɛ̀ ɔ̀nǎ. Ndɨrɔ̀, Kàgàwà abhʉ̀ ka ràbà ídzìnga Mísrì tɔ́ pbìrì ɔ̌ ádrʉ̀ngbǎ kamà Fàrawʉ̀-ɔ̀nzɨ̌, ndàdʉ̀ dhu-ɔ̌nga t’óvòta tɔ́ màgězì àbhʉ kà tɔ̀. Nɨ́, Fàrawʉ̀ adʉ̀ Yɔ̀zɛfʉ̀ ɨ̀lɨ Mísrì tɔ́ pbìrì ɔ̌ lɨ̀walɨ̀ tɨ́. Ndɨrɔ̀, kǎdʉ̀ kɨ̀lɨ ádrʉ̀ngbǎlɛ tɨ́ pbɨ̀ndà ɨdzá kɔ́rɔ́ dhu-dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wɔ̀ dhu-dzidɔ̌, àgǎyì nɨ́ɨsɨ́ Mísrì tɔ́ pbìrì ɔ̌ ndɨrɔ̀ Kànanà tɔ́ pbìrì ɔ̌ màtɨ́. Ndɨ dhu nɨ’ɨ̀ ádrʉ̀ngbǎ àpbɛ̀ nyʉ́. Ndɨrɔ̀, àlɛ̌ t’ábhúna rɨ̌ ɨ̀ ɔ́nyʉna dhu mà àbà rɔ́ nga mà nɨ́ɨ’ɨ̀ ɨ̀mbǎ. ");
INSERT INTO niy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nɨ́, Yàkɔbhɔ̀ itdègu ìnè ɔ̀nyʉ̀ rɨ̌’ɨ̀ Mísrì dhu ɨ̀rɨ, náadʉ̀ àlɛ̌ t’ábhúna nóvì, ròwù wɛmbɛrɛ̀ tɔ́ abhi nɨ̌ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ɔyɔ rɨ́ abádhí tɔ́ abhi nísě ányɨ̀ abhi ɔ̌, Yɔ̀zɛfʉ̀ adʉ̀ ndɨ̀tɛ̀ abádhí tɔ̀ abádhí t’ádɔ̀nà nyʉ́ tɨ́. Nɨ́rɔ̀ nɨ́ ndɨ ádrʉ̀ngbǎ kamà Fàrawʉ̀ adʉ̀ Yɔ̀zɛfʉ̀ mǎ-dzá-bhà nʉ́nɨ átɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Wɔ̀ dhu-dzidɔ̌, Yɔ̀zɛfʉ̀ adʉ̀ àbanà Yàkɔbhɔ̀ mà, kɔ́rɔ́ fɨ̌-dzá-bhà mànà návi rìwǔ òko Mísrì tɔ́ pbìrì ɔ̀. Ɨ alɛ-bvʉ kɔ́rɔ́ nɨ’ɨ̀ àrʉ̀bhʉ̀ kumì dɔ̀ná imbò nà alɛ. ");
INSERT INTO niy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nɨ́, Yàkɔbhɔ̀ adʉ̀ òtse Mísrì. Àbadhi mà, pbɨ̀ inzo àlɛ̌ t’ábhúna mànà náawù ʉvɛ̀ ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ka kadʉ́nà òwu abádhí-abvò nʉ́mbà rɔ̌, kiwǔ ʉ̀tdʉnà Sìkemù tɔ́ pbìrì ɔ̀, yà àlɛ̌ t’ábhunà Àbràhamʉ̀ náadzì fʉ̀rangà rɔ̌ Hɛ̀mɔrà bhà inzo-fɔ́ ibhu ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nɨ́, yà Àbràhamʉ̀ tɔ̀ Kàgàwà akɔ̀ làká rǎkǎ ɔ̀ná kàsʉmɨ̀ níitdègu ndìndù, nɨ́ àlɛ̌ tɔ́ alɛ-bvʉ níisé ndɨ̀ ndɔ̀trɔ̀ atdídɔ̌ Mísrì tɔ́ pbìrì ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nɨ́rɔ̀ nɨ́ ndɨ yà ɨnzá Yɔ̀zɛfʉ̀ nʉ́nɨ ádrʉ̀ngbǎ kamà náanyʉ̀ idzi Mísrì tɔ́ pbìrì dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nɨ́ ndɨ ádrʉ̀ngbǎ kamà nʉ́ʉtrá àlɛ̌ tɔ́ alɛ, ndàdʉ̀ àvu àlɛ̌ t’ábhúna rɔ̌. Kǎdʉ̀ abádhí ʉ̀tʉ átɔ̀ rʉ̀bhǎ fɔyá nzónzo ndɨ́nɨ̌ ʉvɛ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, ka kʉgʉ Músà. Músà nɨ’ɨ̀ atdídɔ̌ áya, ndàdʉ̀ Kàgàwà-nyɨ̀kpɔ́ ɔ̀fɔ̀ ngbángba. Nɨ́ ka kadɔ̀ ndɨ Músà tɔ́ ngbángba ɨ̀bhʉ àbǐ tɨ́ àbanà bhà ɨdzá. ");
INSERT INTO niy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɨ́yànà itdègu Músà tɔ́ ngbángba ʉ̀bha, nɨ́ ádrʉ̀ngbǎ kamà Fàrawʉ̀ t’ɨ́vànà adʉ̀ kìdyì, ndàrà ìvinà pbɨ̀ndà ngbángba nyʉ́ bhěyi. ");
INSERT INTO niy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nɨ́ ányɨ̀-dzá, ka kudhè Mísrì ɔ̌ bhà tɔ̀ ka karúdhěna dhu-tsí-tɨdɔ̀ kɔ́rɔ́ Músà tɔ̀, àbadhi ràdʉ̀ ɨ̀’ɨ̀ ádrʉ̀ngbǎnga tɔ́ ɔbɨ nyʉ́ nà ɔ̀tɛ̌na ɔ̌, ndɨrɔ̀ kàsʉ̌na ɔ̌ màtɨ́. ");
INSERT INTO niy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nɨ́ atdiku, ɨ̀fɔ kumì atɔ nà ndɨ̀ ndɨ́’ɨ̀ rɔ́rɔ̀, Músà núudhé dhu ndɨ̀ ràkǎ ndàrà adɔ́na Pbàìsràyélí nándà. ");
INSERT INTO niy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nɨ́, kǎtù abádhí nzínzì ɔ̌ atdí alɛ rɔ̀ná Mísrì ɔ̌ atdí alɛ rǎvu rɔ́. Nɨ́, kǎzè ndɨ̀sɔ̌ kà-rɔ̌ dhu. Nɨ́, adɔ̀nà-rɔ̌ dhu ndɨ̀ ndʉtsɛ̀ tɨ́, kǎdʉ̀ wɔ̀ Mísrì ɔ̌ alɛ nóhò òho tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kǎtɨ dhu ʉ̀nɨ̌ adɔ́na Pbàìsràyélí rɨ̌ dhu ʉ̀nɨ̌, Kàgàwà rívì ndɨ ndɨ̀, ndɨ́nɨ̌ ndɨ̀ ndʉwʉ̀ tɨ́ ɨ̀ ɨnɔ-kàsʉ̌ ɔ̌ rɔ̀ dhu tɨ́. Pbɛ́tʉ̀ abádhí adʉ̀ nzá ndɨ dhu ʉ̀nɨ. ");
INSERT INTO niy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tsútsǎ nɨ́nganɨ́, Músà atù ɔ́yɔ̌ Pbàìsràyélí ’ɔ̀ngbʉ rɨ́ rɔ́. Nɨ́ kǎzè ndʉ̀kɔlɔ abádhí-ɔ̌nga ròkò màrʉ̀ngà ɔ̌. Nɨ́, kǎtɨ abádhí nɨ̌: ‹Àbanɨ̌nzó, nyɨ̌ nɨ́ atdí ɔdhɨ! Nɨ́ ádhu nyɨ̌ nyávu rʉ̀kʉ́ nyɨ̌-tɨ́rɔ̀ nɨ̌?› ");
INSERT INTO niy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pbɛ́tʉ̀, yà ɔdhɨ̀nà rɔ̌ rúbhi àvu rɔ̌ alɛ níidzì Músà, ndàdʉ̀ àtɨ̀nà nɨ̌: ‹Ádhɨ ndɨ ɨnyɨ nɨ́lɨ dɔ̀ká kamà tɨ́? Ndɨrɔ̀ ádhɨ ndɨ nyɨ nɨ́lɨ ndɨ́nɨ̌ nyɨ nyongó tɨ́ ànyǎka ʉ̀nɔ̀? ");
INSERT INTO niy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nyɨ nyòzè tɨ́ nyohò ma yà inzì nyɨ nyóhòná Mísrì tɔ́ pbìrì ɔ̌ alɛ dhu bhěyi?› ");
INSERT INTO niy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nɨ́, wɔ̀ dhu ndɨ̀ ndɨ̀rɨ̀ rɔ̀, Músà akʉ̀ dòtsí, ndàrà àdɨ Pbàmìdìyanì tɔ́ pbìrì ɔ̀. Ányɨ̀ kǎdhɨ̀ kpabhá nzónzo ɔyɔ. ");
INSERT INTO niy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ɨ̀fɔ kumì atɔ dzidɔ̌, Kàgàwà bhà màlàyikà náavì ndɨ̀ kà tɔ̀ Sìnayì tɨ́ kátɨna pbìrì-akpà tɨ́ arɨ́’ɨ̀ rʉ̀ngʉ̀ ɔ̌, kàzʉ rɔ̌rʉ̀ rɔ̀ná ɨ̀nzɨ̌ rógbe rɔ́rɔ̀ kɨ̀dzʉ̀mbà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nɨ́ ɨdhɔ nʉ́ʉkɔ Músà atdídɔ̌ wɔ̀ dhu ndɨ̀ ndàla rɔ̀. Pbɛ́tʉ̀, yà ndɨ̀ ndóndri ndɨ́nɨ̌ ndɨ̀ ndandá tɨ́ dhu mběyi rɔ̀, Músà ɨrɨ Ádrʉ̀ngbǎlɛ Kàgàwà-tù wɔ̀ kàzʉ ɔ̀ rɔ̀ rɔ́tɛ rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Kǎtɨ: ‹Ɨma nɨ́ abhúnʉ tɔ́ Kàgàwà. Ɨma nɨ́ Àbràhamʉ̀ mà, Ìsakà mà, Yàkɔbhɔ̀ mànà tɔ́ Kàgàwà.› Nɨ́, ɔdɔ nɨ̌ ndɨ̀ ndívi dhu-okú dɔ̀ rɔ̀, Músà adʉ̀ nzá ndòmvù ndàndà ndɨ kàzʉ-dɔ̀nga mà tdɨ́tdɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wɔ̀ dhu-dzidɔ̌, Ádrʉ̀ngbǎlɛ Kàgàwà adʉ̀ àtɨ̀nà kànɨ̌: ‹Ʉ́wa pfɔ̌nʉ rɔ̌ kàyìtò, wɔ̀ nyɨ nyìdè rɔ́ nga nɨ́ ɨ̀lɨ̌lǎ ngari nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Obhó tɨ́, ma màla wà pbàkà alɛ rǎbàna Mísrì tɔ́ pbìrì ɔ̌ bhà fɔ́ àpbɛ̀! Ndɨrɔ̀, ma mɨ̀rɨ̀ wà abádhí rɨ̌ ’ʉ̀hʉ̌ tɨ́ dhu. Nɨ́, ma mìfò wà ɔ̀rʉ̀-akpà ɔ̀ rɔ̀, ndɨ́nɨ̌ ma mipfo tɨ́ abádhí ndɨ àpbɛ̀ ɔ̌ rɔ̀. Nɨ́, ɨ́rà! Kòmbí ma mɨ́ nyovì Mísrì.›» ");
INSERT INTO niy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stɨ̀fanʉ̀ adʉ̀ dhu ɔ̀vɔ tdɨ́tdɔ̌, ndàtɨ: «Wɔ̀ ndɨ Músà Pbàìsràyélí adhɔ̀ angyɨnǎ rɔ̀. Abádhí atɨ kànɨ̌: ‹Ádhɨ ndɨ ɨnyɨ nɨ́lɨ dɔ̀ká kamà tɨ́? Ndɨrɔ̀ ádhɨ ndɨ nyɨ nɨ́lɨ ndɨ́nɨ̌ nyɨ nyongó tɨ́ ànyǎka ʉ̀nɔ̀?› Ndɨ Músà kɛ̀lɛ̌ nɨ́ ndɨ Kàgàwà adʉ̀ òvìnà ràrà kamà tɨ́, ndɨrɔ̀ Pbàìsràyélí ʉ̀kɔ̀lɔ̌ rɨ́ ɨnɔ-kàsʉ̌ ɔ̌ rɔ̀ alɛ tɨ́. Kɨ̌tɛ̀ ndɨ̀ kà tɔ̀ pbɨ̀ndà màlàyikà-otù ɔ̌, yà ɨ̀nzɨ̌ rógbe rɔ́rɔ̀ kàzʉ rɔ̌rʉ̀ rɔ̀ná kɨ̀dzʉ̀mbà ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndɨ Músà nɨ́ ndɨ, Pbàìsràyélí nipfo Mísrì rɔ̀, yà ɨnzá apɛ̀na ’ɔ̀nzɨ angyi ìndrǔ-nzínzì ɔ̌ dhu mà, ize mànà nɔ́nzɨ ndɨ̀ ndɨ́ dhu-otù ɔ̌. Kǎnzɨ̀ ɨ dhu Mísrì tɔ́ pbìrì ɔ̌ ‹Òlǒlù ádrʉ̀ngbǎ rɛ̀rʉ̀› tɨ́ kátɨna ádrʉ̀ngbǎ rɛ̀rʉ̀ ɔ̌, ndɨrɔ̀ rʉ̀ngʉ̀ ɔ̌ ɨ̀fɔ kumì atɔ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ndɨ Músà kɛ̀lɛ̌ nɨ́ ndɨ dhu navɔ̀ Pbàìsràyélí tɔ̀ ndàtɨ: ‹Kàgàwà níipfoya ɨma bhěyi atdí pbɨ̀ndà nabì fʉ̌kʉ̀ nzínzìkʉ ɔ̌ rɔ̀.› ");
INSERT INTO niy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Pbàìsràyélí àndu tsʉ̀ya rʉ̀ngʉ̀ ɔ̌ rɔ̀, kǒngónà ndɨ ìde àlɛ̌ t’ábhúna mà nzínzì ɔ̌ yà Sìnayì tɔ́ pbìrì dɔ̀ rɔ̀ rɨ́ dhu ɔ̀vɔ fɨ̌ndà Kàgàwà bhà màlàyikà mànà. Kǎkɔ̀ ndɨ ípìrɔ̌nga tɔ́ ɔtɛ, ndàdʉ̀ ʉ̀dànà àlɛ̌ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pbɛ́tʉ̀, àlɛ̌ t’ábhúna náazè nzá ’ɨ̀fʉ Músà rʉ̌nɔna dhu. Abádhí ongónà kà-tsʉ̌ dhu àsà àsa tɨ́, atdyúya ràdʉ̀ ɨ̀’ɨ̀ ndɨ́nɨ̌ ɨ̀ adù tɨ́ ɨ̀ Mísrì tɔ́ pbìrì ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nɨ́ atdíku, abádhí atɨ Àrɔ̌nɨ̀ nɨ̌: ‹Mǎ mʉ̀nɨ nzá yà Mísrì rɔ̀ mǎ nábhʉ mǔvò Músà rɔ̌ ndɨ̀ nɨ̀pɛ̀ yà kǎrà ɨ dhu. Nɨ́, ɔ́bhɔlɔ mʉ̌ngʉ̌-nzo-wɔ̀yɔ̌ fǎkà, ndɨ́nɨ̌ ka kongó tɨ́ ànɔ̀nà kambɛ òwu dɔ̌ nà angyɨ fǎkà.› ");
INSERT INTO niy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nɨ́ abádhí abhɔ̀lɔ̀ ìkyǐ-ngba-wɔ̀yɔ̌, ’àdʉ̀ ɨ̀zǎ tɔ́ pɛrɛ̀ ʉ̀bɨ̀ ndɨ sànamʉ̌-ngba-ɔ̀nzɨ̌. Ndɨrɔ̀ abádhí anzɨ̀ mʉ̀hɛndʉ̀ dhɛ̀dhɛ nyʉ́ nà ndɨ ɨ̀tɨ́rɔ̀ ɨ̀ ɔ́bhɔ̀lɔ̀ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nɨ́, Kàgàwà ʉgɛ̀rɛ̀ dzinà-dɔ abádhí tɔ̀, ndʉ̀bhà ròngò àmbɛ ɔ̀rʉ̀-akpà-nyɨ̀ rɔ̌ dhu nʉ́lɛ dɔ̌, Kàgàwà bhà pbànábí tɔ́ bhǔkù ɔ̀ ka kandí dhu bhěyi. Ndɨ andítá átɨ: ‹Ìsràyelì ɔ̌ bhǎ, yà rʉ̀ngʉ̀ ɔ̌ nyɨ̌ nyɔ́nzɨ̀ ɨ̀fɔ kumì atɔ ɔ̌, nyɨ̌ nyʉ́bɨ̀ tɨ́ ʉ̀bɨ̀ ɨ̀zǎ tɔ́ pɛrɛ̀ ɔnzɨ̀dú? Ndɨrɔ̀, nyɨ̌ nyúbho tɨ́ ùbhǒ ngʉ̌kpà dhu-tsí tɔ́ pɛrɛ̀ idù? ");
INSERT INTO niy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɨnzá akɛkpá màtɨ́! Pbɛ́tʉ̀ nyɨ̌ nyúbhì Mòlokì bhà hɛmɛ̀ nánɔ̀ rɔ̌, nyǎdʉ̀ òwu fʉ̀kʉ́ mʉ̌ngʉ̌-ngba Rɛ̀fanɨ̀ bhà alalɨ-wɔ̀yɔ̌ nánɔ̀ rɔ̌. Ɨ dhu-wɔ̀yɔ̌ nyɨ̌ nyabhɔ̀lɔ̀ ndɨ́nɨ̌ nyɨ̌ nyongó tɨ́ ʉ̀lɛnà. Nɨ́, ndɨ dhu-okú dɔ̀ rɔ̀ nɨ́ ndɨ ma mɨ́ nyǎbhʉ̌ kʉmbà nyɨ̌, karʉ̀ nyɨ̌ nà àrʉ̀ tɨ́ Bàbelì tɔ́ pbìrì ɔ̀nǎ.› ");
INSERT INTO niy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Rʉ̀ngʉ̀ ɔ̌ ɨ̀ ɨ’ɨ̀ nɨ́nganɨ́, àlɛ̌ t’ábhúna nɨ́ɨ’ɨ̀ ìnè Kàgàwà rɨ̌’ɨ̀ nzínzìya ɔ̌ dhu ɨ̀tɛ̀ rɨ́ hɛmɛ̌-dzà nà. Ndɨ ɨdza ka kupe àdhàdhɨ̀ yà Kàgàwà nyʉ́ nɨ́ɨtɛ̀ ka Músà tɔ̀ ɔ̀ná ɔ́fɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Olùnǎ rɔ̀, abáya adʉ̀ ndɨ hɛmɛ̌-dzà ʉ̀dà àlɛ̌ t’ábhúna-fɔ’ɔ̀. Ndɨrɔ̀, Yɛ̀sʉwà arɨ́ ’ʉ̀nda ɔ̀ná kàsʉmɨ̀ ɔ̌, àlɛ̌ t’ábhúna náadʉ̀ kìdyì ’ìwǔ nà yà ɔ̀yá alɛ Kàgàwà ábhʉ ’òdì pbìrì ɔ̀. Ndɨ hɛmɛ̌-dzà náadɨ̀ abádhí nzínzì ɔ̌, ràrà àhʉ ádrʉ̀ngbǎ kamà Dàwudì bhà kàsʉmɨ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dàwudì tɔ̀ Kàgàwà ɨtɛ̀ pbɨ̀ndà ídzìnga atdídɔ̌. Nɨ́ Dàwudì adʉ̀ rʉsà ònzì ndɨ́nɨ̌ ndɨ̀ ndɔbhɔlɔ tɨ́ adɨta tɔ́ ngari àlɛ̌ t’ábhunà Yàkɔbhɔ̀ bhà Kàgàwà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pbɛ́tʉ̀, ɨdza ɔ̀sɨ̀ adʉ̀ Kàgàwà tɔ̀ alɛ nɨ́ Sɔ̀lɔ̀mɔnɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pbɛ́tʉ̀ngàtɨ́, yà kɔ́rɔ́ dhu dɔ̌ arɨ́’ɨ̀ Kàgàwà náarɨ́ nzɨ̌ àdɨ ìndrǔ-ɔtsʉ́ asɨ̀ ɨdza ɔ̌. Wɔ̀rɨ́ nɨ́ ndɨ Kàgàwà bhà nabì nʉ́ʉnɔ dhu, ndàtɨ: ");
INSERT INTO niy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Ɔ̀rʉ̀-akpà nɨ́ pbàkà tombi, ndɨrɔ̀ yà adzɨ nɨ́ pfɔ̌du ʉ̀lɨ̌ ma marɨ́ dɔ̀ná dhu. Nɨ́ ɨ́ngbà tɨ́ ɨ̀lɨ ndɨ̀ ɨdza ndɨ idù nyɨ̌ nyɔ́sɨ̀na? Ndɨrɔ̀ ɨ́ngbà tɨ́ ɨ̀lɨ ndɨ̀ ngari ndɨ ma mádʉ̀ maso ɔ̀ná? ");
INSERT INTO niy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tɨ́ obhó ɔtsʉ́du ndɨ ɨ dhu nabhɔ̀lɔ̀ kɔ́rɔ́?›» ");
INSERT INTO niy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stɨ̀fanʉ̀ adʉ̀ àtɨ̀nà tdɨ́tdɔ̌: «Nyɨ̌ atdídɔ̌ dɔ̀ya ɨ́dzɔ̀ alɛ́, ndɨrɔ̀ afíya mà bɨ̌ya mànà nʉ́tsɨ̀ Kàgàwà rɔ̌ alɛ́, bìlǐnganà nyɨ̌ nyarɨ́ nzɨ̌ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí rɔ̌vɔna fʉ̌kʉ̀ dhu ɨ̀rɨ. Nyɨ̌ nyɨ́ dhu ɔ̀nzɨ abhúkʉ bhěyi! ");
INSERT INTO niy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ádhɨ pbá alɛ ndɨ Kàgàwà bhà pbànábí nzínzì ɔ̌ ɨnzá abhúkʉ ávu rɔ̀ná? Abádhí akyɛ̀ yà angyangyɨ dhu navɔ̀ Obhónángatálɛ rɨ̌rà dhu dɔ̌ alɛ. Nyɨ̌ nɨ́ ndɨ nyɨ̌ nyípfo ndɨ Obhónángatálɛ nyǎbhʉ òmvǔ-fɔ́. Nɨ́ kòmbí, nyɨ̌ nyòngò wà ka nahò alɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ndɨrɔ̀, nyɨ̌ nyábà Kàgàwà bhà Ʉyátá kàbhà màlàyíká-otù ɔ̌, pbɛ́tʉ̀, nyɨ̌ nyádʉ̀ nzá ndɨ Ʉyátá nɨ́fʉ.» ");
INSERT INTO niy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Anya t’ɨ́tdɨ̀ta-ɨdzà ɔ̌ ɨ̀’ɨ̀ alɛ níitdègu wɔ̀ Stɨ̀fanʉ̀ ʉ̀nɔ̀ dhu ɨ̀rɨ, nɨ́ abádhí akó atdídɔ̌, ’àdʉ̀ kǔya àtri Stɨ̀fanʉ̀-okú dɔ̀ rɔ̀, nàwí rɨ̌ ’òri nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pbɛ́tʉ̀, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí ɨ̀rǎ ndɨ̀ dhu-okú dɔ̀ rɔ̀, Stɨ̀fanʉ̀ adʉ̀ ɔ̀rʉ̀-akpà ɔ̀ nga àndà. Nɨ́ ányɨ̀, kǎla Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ awáwʉ̀, ndàdʉ̀ Yěsù àla Kàgàwà bhà fangà dɔ̀nǎ rɔ̀ ìdè rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nɨ́, Stɨ̀fanʉ̀ adʉ̀ àtɨ̀nà: «Ma mɨ́ ɔ̀rʉ̀-akpà-li’ɔ̀ àlǎ ndɨ̀ nàngbɛ rɔ́. Ndɨrɔ̀, ma mɨ́ Ìndrǔ t’ídhùnà nálǎ Kàgàwà bhà fangà dɔ̀nǎ rɔ̀ ìdè rɔ́.» ");
INSERT INTO niy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nɨ́, wɔ̀ dhu nɨ̀rɨ̀ alɛ nɨ́ɨdʉ̀ ìkǔ nà kɔ́rɔ́, ’àdʉ̀ ɔtsʉ́ya-kpɔ̀ nʉ́fɔ bɨ̌ya-bhu ɔ̀ akyɛ ɨ̀ ɨrɨna kà rʉ̌nɔna dhu tdɨ́tdɔ̌ nɨ̌. Abádhí náalà ɨ̀ atdíkpá kàdɔ̀, ’ɔ̀dɨ̀ ɨ̀ kà-dɔ̌, ");
INSERT INTO niy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","’àdhà ka ’ìpfo iri kɨgɔ̀ ɔ̀ rɔ̀, ’àdʉ̀ kɔ̀pɛ̀ ’ùbvǔ odu nɨ̌ ndɨ́nɨ̌ ɔvɛ́ tɨ́. Wɔ̀ dhu tɔ́ ngàmbì tɨ́ ɨ̀’ɨ̀ alɛ, nʉ́ʉwa rɔ̀yá mʉ̀dzarʉ̀ ’ʉ̀lɨ Sáwúlò tɨ́ kátɨna kpatsìbhíngba-pfɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yà odu nɨ̌ ka kɨ́ ndùbvǔ ɔ̀ná kàsʉmɨ̀ ɔ̌, Stɨ̀fanʉ̀ ambɛ́nà ndɨ̀tsɔ̀ dɔ̌, ndàtɨ yà dhu bhěyi: «Ádrʉ̀ngbǎlɛ Yěsǔ, ákɔ̌ afídu!» ");
INSERT INTO niy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndɔ̀kɔ̀ ɔtdyʉ̀na dɔ̌, ndàdʉ̀ òkù ɔrʉ́ tǔna nyʉ́ nà ndàtɨ: «Ádrʉ̀ngbǎlɛ́, àpɛ́ nyɔzʉ́ wɔ̀rɨ́ nzɛ́rɛnga abádhí dɔ̌.» Wɔ̀ dhu ndɨ̀ ndòrì rɔ́rɔ̀ nɨ́ ndɨ, kà-afí náadʉ̀ ɨ̀tdɛ̌ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sáwúlò adʉ̀ dhu òlè òlè tɨ́ kɔ̌kɔ̀ Stɨ̀fanʉ̀ nòhò alɛ tɔ̀. Wɔ̀ Stɨ̀fanʉ̀ ka kòhò ɔ̀ná ɨdhɔ ɔ̌ tɨ́, ka kapɛ̀ kavu atdídɔ̌ kànɨsà rɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌. Nɨ́, Yěsù ná’ù alɛ uvò Yèrùsàlɛmà rɔ̀, ’ɨ̀fàlà ɨ̀ Yùdɛyà tɔ́ pbìrì mà Sàmàrɨyà mànà ɔ̀nǎ. Pbɛ́tʉ̀, Yěsù bhà uvitatálɛ kɛ̀lɛ̌ náadʉ̀ ’ʉ̀bhà vǐya dɔ̌ rɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kàgàwà bhà Ʉyátá ɨ̀fʉ̌ arɨ́ ngʉ̌kpà alɛ náadʉ̀ Stɨ̀fanʉ̀-abvò ìdyì ’òwù ɔ̀tdʉ̀nà, ’àdʉ̀ kɔ̀dzɨ̀ atdídɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pbɛ́tʉ̀, wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ tɨ́, Sáwúlò náazè ndùgolo kànɨsà. Nɨ́ ndɨ dhu-okú dɔ̀ rɔ̀, kǎlʉ́ ɨdza tsʉ̀nà rɔ̌ ndàrà ùtsǔ rɔ̌ ɔ̀yà, ndàdʉ̀ ányɨ̀-dzá ndɨ̀ ndòtù Yěsù ná’ù kpabhálɛ mà vèbhálɛ mànà nípfo ɔbɨ nɨ̌, ndàrà àwànà imbi-dzà ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kɨgɔ̀ ɔ̌ rɔ̀ ɨ̀ nɨ́fàlà alɛ núubhì dhèdhèrɔ̀ ngari ɔ̀nǎ, ’àmbɛ Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ dɔ̌ ìndrǔ tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ndɨ dhu bhěyi nɨ́ ndɨ, Fìlipò náawú Sàmàrɨyà tɔ́ pbìrì ɔ̌ atdí kɨgɔ̀ ɔ̀, ndàrà dhu ɔ̀vɔ̀ ìndrǔ tɔ̀ Màsiyà dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nɨ́, ihé-yà náapbá afíya atdíkpá Fìlipò rʉ̌nɔna dhu rɔ̌, kà rǎrà ɔ̀nzɨ̀nà rɔ̌ wɨwɨ̀-ɔ̀yɨ̌ ɨ̀ ɨ̀rɨ̀, ’àdʉ̀ ɨ dhu nála nyɨ̀kpɔ́ya nyʉ́ nɨ̌ dhu-okú dɔ̀ rɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Obhó tɨ́, nzɛ́rɛ-alafí nóowúnà ùvò rɔ̌ ádrʉ̀ngbǎ ìkǔ nà yà ɨ̀ arávu rɔ̀yá ábhɔ̌ alɛ nyʉ́ ɔ̀ rɔ̀. Ndɨrɔ̀, ábhɔ̌ alɛ kǎkà ngbɔ̌ya ʉ́vɛ, ndɨrɔ̀ òtsótsù, nóowúnà ʉ̀gʉ rɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɨ́, ndɨ dhu abhʉ̀ ìndrǔ-ɨdhɛ̀ rɨ̀ka ndɨ̀ atdídɔ̌ ndɨ kɨgɔ̀ ɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wɔ̀ ndɨ kɨgɔ̀ ɔ̌, Sìmonì tɨ́ kátɨna atdí alɛ nɨ́ɨ’ɨ̀ ìnè. Ndɨ alɛ nɨ’ɨ̀ màzǐtálɛ. Kǒngónà Sàmàrɨyà ɔ̌ bhà àbhʉ ɨdhɔ rʉ̀kɔ atdídɔ̌. Ndɨrɔ̀, kǒngónà àdʉ̀ ndàtɨ̀ ndɨ̀tɨ́rɔ̀ ádrʉ̀ngbǎlɛ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nɨ́ kɔ́rɔ́ alɛ, nzónzo mà, ádrɔ̀drɔ̌ alɛ mànà nóongónà afíya àpba atdídɔ̌ kà rʉ̌nɔna dhu rɔ̌. Abádhí adʉ́nà òwu àtɨ̀nà rɔ̌: «Yàrɨ́ alɛ nɨ́ Kàgàwà bhà ádrʉ̀ngbǎnga tɔ́ ɔbɨ, yà ‹Ádrʉ̀ngbǎ Ɔbɨ› tɨ́ ka karátɨna.» ");
INSERT INTO niy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Abádhí apbá afíya kà rɔ̌ dhu nɨ́, angyɨ́ta tɨ́ kɔ̌pɛ̀ ndɨ̀, ndàrà ìndrǔ àbhʉ rɔ̌ ɨdhɔ rʉ̀kɔ atdídɔ̌ pbɨ̀ndà màzǐ ɔ̌ ndɨ̀ ndɔ́nzɨna dhu-okú dɔ̀ rɔ̀ dhu. ");
INSERT INTO niy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pbɛ́tʉ̀, ìndrǔ níitdègu Fìlipò rʉ̌nɔna fɨ̌yɔ̀ ɔ̀rʉ̀-akpà ɔ̌ Ádrʉ̀ngbǎ kamà Kàgàwà bhà idzi tɔ́ Ídzì Màkʉ̌rʉ̀ mà, Yěsù Krɨ́stɔ̀ dɔ̌ Ídzì Màkʉ̌rʉ̀ mànà ná’u, nɨ́ abádhí àdʉ̀ bàtizò àlʉ Fìlipò-fɔ́. Ɨ alɛ nɨ’ɨ̀ kpabhálɛ mà vèbhálɛ mànà. ");
INSERT INTO niy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nɨ́, Sìmonì náa’u dhu átɔ̀, ndàdʉ̀ bàtizò àlʉ. Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ ndàpba atdídɔ̌ Fìlipò rɔ̌. Ndɨrɔ̀, wɨwɨ̀ mà, ɨnzá apɛ̀na ’ɔ̀nzɨ angyɨ dhu mànà dhu ndɨ̀ ndàla rɔ̀, ɨdhɔ adʉ́nà àrà kʉ̀kɔ rɔ̌ atdídɔ̌ nyʉ́. ");
INSERT INTO niy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nɨ́, Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̌ ɨ̀ nòtù Yěsù bhà uvitatálɛ níitdègu ɨwà Sàmàrɨyà ɔ̌ bhà nɨ́rɨ̀ Kàgàwà bhà Ɔtɛ ’àdʉ̀ à’ùnà dhu ʉ̀nɨ̌, nɨ́ abádhí adʉ̀ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà nóvì ròwù ányɨ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nɨ́, kɔ̌kɔ̀ ɔ́yɔ̌ uvitatálɛ nówù ùvò Sàmàrɨyà tɔ́ pbìrì ɔ̀ rɔ̀, abádhí ɨtsɔ̀ ɨ̀ ndɨ pbìrì ɔ̌ Yěsù ná’ù alɛ dɔ̌ ndɨ́nɨ̌ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí nabá tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Obhó tɨ́, abádhí ɨ’ɨ̀ bàtizò kɛ̀lɛ̌ ɨ̀ álʉ̌ Ádrʉ̀ngbǎlɛ Yěsù-ɔvɔ̀ rɔ̌, ’àdʉ̀ ɨ̀’ɨ̀ ɨnzá Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí àpɛ̀ ìfo nzínzìya ɔ̌ atdí alɛ dɔ̌ màtɨ́ rɔ́. ");
INSERT INTO niy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nɨ́, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ nà nʉ́ʉlɨ ɔtsʉ́ya abádhí dɔ̌, ràdʉ̀ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí àbà. ");
INSERT INTO niy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nɨ́, Sìmonì itdègu ìndrǔ àbà Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí kɔ̌kɔ̀ ɔ́yɔ̌ uvitatálɛ ʉ̀lɨ ɔtsʉ́ya dɔ̀yá rɔ̀ dhu nálǎ, nɨ́ kǎdʉ̀ fʉ̀rangà àbhʉ Pɛ́tɛrʉ̀ mà Yùwanɨ̀ mànà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kǎdʉ̀ àtɨ̀nà abádhí nɨ̌: «Nyìbho wɔ̀ nyɨ̌ nyɨ́’ɨ̀ nà ádrʉ̀ngbǎnga tɔ́ ɔbɨ-tɨdɔ̀ átɔ̀ idù, ndɨ́nɨ̌ ɔtsʉ́du ma mɨ̀lɨ dɔ̀ná alɛ nóongó tɨ́ Ɨ̀lɨ̌lǎ-Alafí nábà átɔ̀.» ");
INSERT INTO niy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pbɛ́tʉ̀, Pɛ́tɛrʉ̀ adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Nyɨ̌ nyàkǎ tsěkʉ rɔ̀tdɨ̀ ɨ̀ kɔ́rɔ́ wɔ̀ pbʉ̀kʉ̀ fʉ̀rangà mànà, nyɨ nyàtɨ̀ dhu fʉ̀rangà rɔ̌ ka kádʉ̀ yà tɨ́rɔ̌rɔ̀ Kàgàwà arábhʉ̌na dhu òdzì dhu tɨ́ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nyɨ nyɨ́’ɨ̀ ɨ̀mbǎ nyɨ nyábàna ndɨrɔ̀ nyɨ nyɔ́nzɨna yà mǎ mɔ́nzɨna dhu ɔ̀ dhu nà, ɨ̀mbǎ afínʉ rɨ̌’ɨ̀ tʉ̀mbà tɨ́ Kàgàwà-ɔ̀nzɨ̌ nɨ́dhunɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nɨ́rɔ̀, ʉ́gɛ̀rɛ̀ nyɨ nyʉbhà wɔ̀ pbʉ̀kʉ̀ nzɛ́rɛ ɨrɛ̀ta. Ndɨrɔ̀, ɨ́tsɔ̀ nyɨ Ádrʉ̀ngbǎlɛ Kàgàwà rɔ̌, ndɨ́nɨ̌ kʉ̌bà tɨ́ wɔ̀ afínʉ ɔ̀ rɨ̌’ɨ̀ nzɛ́rɛ ɨrɛ̀ta ɨndʉ̀, àkǎkǎ nɨ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Obhó tɨ́, ma màla wà afínʉ ògyè tɨ́ dhu, ndɨrɔ̀ ma màla wà nzɛ́rɛnga ʉ̀tsɨ̀ afínʉ tɨ́ dhu.» ");
INSERT INTO niy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nɨ́, Sìmonì adʉ̀ àtɨ̀nà Pɛ́tɛrʉ̀ mà Yùwanɨ̀ mànà nɨ̌: «Nyɨ̀tsɔ̀ nyɨ̌ nyɨ̌-tɨ́rɔ̀ dùdú Ádrʉ̀ngbǎlɛ Kàgàwà rɔ̌, ɨ̀nzɨ̌ wɔ̀ nyɨ̌ nyʉ́nɔna dhu nɔ́ɔnzɨ tɨ́ ndɨ̀ rùdú.» ");
INSERT INTO niy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ɔtɛ tɔ́ obhónga ɨ̀ ɨ̀tɛ̀, ’àdʉ̀ ɔ̀vɔ̀nà ìndrǔ tɔ̀ dhu-dzidɔ̌, Pɛ́tɛrʉ̀ mà Yùwanɨ̀ mànà náadʉ̀ òwu Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. Abádhí adʉ́nà òwu Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ìndrǔ tɔ̀ yà ɨ̀ ʉ́da ɔ̀na nǎ Sàmàrɨyà tɔ́ pbìrì ɔ̌ ibí pbanga ɔ̀nǎ. ");
INSERT INTO niy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wɔ̀ dhu-dzidɔ̌, Ádrʉ̀ngbǎlɛ Kàgàwà bhà màlàyikà náavɔ̀ dhu Fìlipò tɔ̀, ndàtɨ: «Ɨ́và nyɨ ɨrɔ́ rɔ̀, nyarà mùsùngú dɔ̀, yà Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ rɔ̀ ráwǔ ndàrà Gǎzà tɨ́ kátɨna kɨgɔ̀ ɔ̀ otu ɔ̀. Ndɨ otu ɔ̌ ìndrǔ arɨ́ nzɨ̌ ùbhi gbɔ̀kà.» ");
INSERT INTO niy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nɨ́ ányɨ̀rɔ̌ rɔ̀ tɨ́, Fìlipò ɨvà ndɨ̀ ndàrà ányɨ̀. Nɨ́ otu ɔ̌, kǎtù Ètìyòpiyà tɔ́ pbìrì ɔ̌ atdí alɛ. Ndɨ alɛ nɨ’ɨ̀ àmǎ, ndɨrɔ̀ ka nɨ’ɨ̀ Ètìyòpiyà tɔ́ pbìrì ɔ̌ tsìbhá ádrʉ̀ngbǎ kamà, Kàndakɛ̀ tɨ́ kátɨna bhà kɔ́rɔ́ malɨ̀ dɔ̌ ádrʉ̀ngbǎlɛ. Nɨ́, kǔbhínà ndàdu rɔ̌ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀ ndɨ̀ ndárà Kàgàwà ʉ̀lɛ ɨnǎ rɔ̀, ");
INSERT INTO niy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ndàmbɛ àrà dɔ̌ pbɨ̀ndà, yà mʉ̀hàgʉ̀ arádhana gɛ̀rɛ̀gɛ̀rɛ̀-tɨdɔ̀ ɔ̌. Ndɨ gɛ̀rɛ̀gɛ̀rɛ̀ ɔ̀ kǎdɨ̀, ndàdʉ̀ àmbɛ yà Kàgàwà bhà nabì Ìsayà náandí dhu ɔ̀zʉ̀ dɔ̌. ");
INSERT INTO niy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nɨ́ wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌ nɨ́ ndɨ, Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí atɨ Fìlipò nɨ̌: «Índrǐ nyɨ ɨ́kyɛ̀rɔ̌ nyʉ́ wɔ̀ gɛ̀rɛ̀gɛ̀rɛ̀-tɨ́.» ");
INSERT INTO niy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nɨ́, Fìlipò adʉ̀ ɔ̀kʉ tsàkàtsàkà, ndàrà àhʉ wɔ̀ gɛ̀rɛ̀gɛ̀rɛ̀-tɨ́, ndàdʉ̀ wɔ̀ Ètìyòpiyà tɔ́ pbìrì ɔ̌ alɛ ɨ̀rɨ̀ Kàgàwà bhà nabì Ìsayà andí dhu ɔ̀zʉ̀ rɨ́ rɔ́. Nɨ́, Fìlipò ivú dhu kà-tsʉ̌, ndàtɨ: «Wɔ̀ nyɨ nyɔ́zʉ̀na dhu àlʉ̌ tɨ́ àlʉ̌ dʉ̀nʉ?» ");
INSERT INTO niy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nɨ́, wɔ̀ alɛ adʉ̀ dhu àdu Fìlipò tɔ̀, ndàtɨ: «Ɨ̀mbǎ ndɨ dhu-tɨ̀ àwɛ̌ rɨ́ idù alɛ ɨ̀’ɨ̀ rɔ̀, kà rǎdʉ̀ dùdu àlʉ ɨ̀ngbà dhu bhěyi?» Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ Fìlipò àvi rùpò ràdɨ tɨná gɛ̀rɛ̀gɛ̀rɛ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wɔ̀ ndɨ kǎmbɛ́nà ɔ̀zʉ̀nà dɔ̌ Andítá ɔ̀ ngari nɨ́ yà dhu bhěyi rátɨna: «Kɨ̌lɨ ndɨ̀ yà òzènà ka kowu tɨ́ ka kówu nà tàmà bhěyi. Àdhàdhɨ̀ ɨkána àze ka kɨ́ tàmǎ-ngba náarɨ́nɛ̀ ɨ̀nzɨ̌ ndàpfò tsʉ̀na mà dhu bhěyi, kɨ̌nɛ̀ ɨ̀nzɨ̌ ndàpfò tsʉ̀na mà. ");
INSERT INTO niy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ka kazʉ̀ nzá ka dhu tɨ́, ndɨrɔ̀ ka katdɨ̀ nzá kà-ànyǎ ndɨ anya nyʉ́ àkǎnà kɔtdɨ̀ dhu bhěyi. Ádhɨ pbá alɛ ndɨ, kàbhà pbàdzʉkʉrʉ dɔ̌ dhu nawɛya, ɨwà ka kadʉ̀ kàbhà ípìrɔ̌nga níwi yà adzɨ ɔ̌ rɔ̀ nɨ́dhunɨ̌?» ");
INSERT INTO niy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nɨ́ wɔ̀ Ètìyòpiyà ɔ̌ alɛ adʉ̀ dhu ìvu Fìlipò-tsʉ̌, ndàtɨ: «Ma mɨ̀tdɛ̀ nyɨ ɨ̀tdɛ̀ tɨ́! Ádhɨ nyʉ́ ndɨ wɔ̀ Kàgàwà bhà nabì rɨ̌ dhu àwɛ̌ dɔ̀ná? Kà t’ɔ́tɛ dɔ̀ná ndɨ̀tɨ́rɔ̀, ndɨrɔ̀ kà t’ɔ́tɛ vurò alɛ dɔ̌?» ");
INSERT INTO niy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nɨ́ Fìlipò adʉ̀ ɔtɛ ɔ̀pɛ̀, ndɔ̀vɔ̀ Yěsù dɔ̌ Ídzì Màkʉ̌rʉ̀ kà tɔ̀ wɔ̀ ndɨ Andítá tɔ́ ngari ɔ̌ rɔ̀ tɨ́. ");
INSERT INTO niy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nɨ́ otu ɔ̌ ɨ̀ ówu rɔ́rɔ̀, abádhí awù ùvò ɨdha rɨ̌’ɨ̀ ɔ̀ná ngari ɔ̌. Nɨ́, wɔ̀ Ètìyòpiyà ɔ̌ alɛ adʉ̀ dhu ìvu Fìlipò-tsʉ̌ ndàtɨ: «Kànɨ̌ ɨdha rɨ̌’ɨ̀ ìnè ɨrɔ́! Nɨ́ ádhu ndɨ ndùvo rádʉ̀ rùdú ɨ̀nzɨ̌ ma malʉ́ tɨ́ bàtizò fʉnʉ́?» ");
INSERT INTO niy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nɨ́ Fìlipò adʉ̀ dhu àdu kà tɔ̀, ndàtɨ: «Nyɨ nyapɛ́ Yěsù à’u atdí afínʉ nyʉ́ nà, nɨ́ nyɨ nyádʉ̀ bàtizò àlʉ àlʉ̌.» Nɨ́ wɔ̀ alɛ adʉ̀ àtɨ̀nà Fìlipò nɨ̌: «Ma mà’ù wà dhu Yěsù Krɨ́stɔ̀ ràrɨ̌ Kàgàwà t’Ídhùnà.» ");
INSERT INTO niy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wɔ̀ dhu-dzidɔ̌, kǎdʉ̀ gɛ̀rɛ̀gɛ̀rɛ̀ àvi kòdì rɨ́ alɛ ràlʉ̌ rìdè. Nɨ́, abádhí adʉ̀ òfo ɨdha ɔ̀ ɔ́yɔ̌ rɔ̀ Fìlipò mànà, Fìlipò ràdʉ̀ bàtizò àbhʉ kà tɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nɨ́, ɨdha ɔ̀ rɔ̀ ɨ̀ ùvò rɔ̀, Ádrʉ̀ngbǎlɛ Kàgàwà bhà Ɨ̀lɨ̌lǎ-Alafí adʉ̀ Fìlipò òdyì ndàrà nà, ɨ̀nzɨ̌ Ètìyòpiyà ɔ̌ alɛ ràdʉ̀ àlanà tdɨ́tdɔ̌. Pbɛ́tʉ̀, wɔ̀ ndɨ Ètìyòpiyà ɔ̌ alɛ náadʉ̀ fɨ̀ndá otu ʉ̀ngʉ, ndàmbɛ àrà dɔ̌ ádrʉ̀ngbǎ dhɛ̀dhɛ nyʉ́ nà. ");
INSERT INTO niy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wɔ̀ dhu-dzidɔ̌, Fìlipò adʉ̀ àrà ndòtù Àzɔtɔ̀ tɨ́ kátɨna kɨgɔ̀ ɔ̀. Kǎdʉ̀ àdɨ ndàrà Kàgàwà bhà Ídzì Màkʉ̌rʉ̀ nʉ́nɔ̀ rɔ̌ ìndrǔ tɔ̀ yà ndɨ̀ ndʉ́da ɔ̀nanǎ kɨgɔ̀ ɔ̌, ndàrà àhʉ nà Kàyìsàriyà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wɔ̀ ndɨ kàsʉmɨ̀ ɔ̌, Sáwúlò tɨ́ kátɨna alɛ azè dhu nɨ́ ndàvu Ádrʉ̀ngbǎlɛ Yěsù bhà ábhàlɨ̌ rɔ̌, ndɨ́nɨ̌ ʉvɛ̀ tɨ́. Nɨ́ kɨ̌và ndɨ̀, ndàrà pbàkùhánɨ́ tɔ́ ádrɔ̀drɔ̌ alɛ dɔ̌ kamà bhà. ");
INSERT INTO niy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Kǎrà bhàrʉwà àkɔ kà-fɔ́, ndɨ́nɨ̌ ndɨ̀ ndarana tɨ́ ɨ̀tɛ̀nà rɔ̌ Dàmàsikì tɔ́ kɨgɔ̀ ɔ̌ unduta-dzà ɔ̌ ádrɔ̀drɔ̌ alɛ tɔ̀. Ɨ bhàrʉwà nɨ’ɨ̀ rʉsà nʉ́fà rɨ̌ kà tɔ̀ rùsǒ ndɨ kɨgɔ̀ ɔ̌ kà rǒtùna Ádrʉ̀ngbǎlɛ Yěsù bhà otu nʉ́ngʉ̌ arɨ́ rɔ́ kpabhálɛ mà vèbhálɛ mànà, ndʉ̀mbà, ndàrà nà àdrà-mbǐ dɔ̌ ka kùsǒ rɔ́rɔ̀ Yèrùsàlɛmà tɔ́ kɨgɔ̀ ɔ̀. ");
INSERT INTO niy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɨ́, otu ɔ̌ kà rǎrà rɔ́rɔ̀, ɨ́kyɛ̀rɔ̌ kɔ̀dɨ̀ Dàmàsikì ndɨ̀ ndotsú tɨ́ rɔ́rɔ̀ nɨ́ ndɨ, aw